﻿USE sofia;
DROP TABLE IF EXISTS sofia.oodNT_vpl;
CREATE TABLE oodNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES oodNT_vpl WRITE;
INSERT INTO oodNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ia atsh mahsi g Jesus Christ jewed dahm k ab d amjedkamaj hegai t‑kekelibad ha‑kownalig mash hab chehgig David. Kush g Davidbad ab d amjedkamaj hegai mash d t‑shohshon ahchim Tutuligo ch hab chehgig Abraham. In ant wo oꞌoha g ha‑chechgig hegam mash d Jesus Christ shohshonbad. ");
INSERT INTO oodNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham atsh wa an alidt g Isaac. Tsh g Isaac an alidt g Jacob. Tsh g Jacob an ha aꞌalidt hegam Judah. ");
INSERT INTO oodNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Tsh g Judah an ha aꞌalidt g Perez ch Zerah heg ab mash d Tamar. Tsh g Perez an alidt g Hezron. Tsh g Hezron an alidt g Ram. ");
INSERT INTO oodNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Tsh g Ram an alidt g Amminadab. Tsh g Amminadab an alidt g Nahshon. Tsh g Nahshon an alidt g Salmon. ");
INSERT INTO oodNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Tsh g Salmon an alidt g Boaz heg ab mash d Rahab. Tsh g Boaz an alidt g Obed heg ab mash d Ruth. Tsh Obed an alidt g Jesse. ");
INSERT INTO oodNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Tsh g Jesse an alidt g David. David atsh an alidt g Solomon heg ab mash d chum hohnigaj g Uriah. ");
INSERT INTO oodNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Tsh g Solomon an alidt g Rehoboam. Tsh g Rehoboam an alidt g Abijah. Tsh g Abijah an alidt g Asa. ");
INSERT INTO oodNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Tsh g Asa an alidt g Jehoshaphat. Tsh g Jehoshaphat an alidt g Joram. Kush ihda Joram d shonaj g Uzziah. ");
INSERT INTO oodNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Tsh g Uzziah an alidt g Jodam. Tsh g Jodam an alidt g Ahaz. Tsh g Ahaz an alidt g Hezekiah. ");
INSERT INTO oodNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Tsh g Hezekiah an alidt g Manassah. Tsh g Manassah an alidt g Amos. Tsh g Amos an alidt g Josiah. ");
INSERT INTO oodNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Kush ihda Josiah d ha‑shon hegam Jeconiah matsh eda gam hu hab i e juh g t‑shohshonbad Babylon kihhim wui. ");
INSERT INTO oodNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jeconiah atsh an hahawa alidt g Shealtiel. Tsh g Shealtiel an alidt g Zerubbabel. ");
INSERT INTO oodNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Tsh g Zerubbabel an alidt g Abiud. Tsh g Abiud an alidt g Eliakim. Tsh g Eliakim an alidt g Azol. ");
INSERT INTO oodNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Tsh g Azol an alidt g Zadok. Tsh g Zadok an alidt g Akim. Tsh g Akim an alidt g Eliud. ");
INSERT INTO oodNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Tsh g Eliud an alidt g Eliazar. Tsh g Eliazar an alidt g Matthan. Tsh g Matthan an alidt g Jacob. ");
INSERT INTO oodNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Tsh g Jacob an alidt g Joseph. Kush ihda Joseph d kunaj hegai mo d Jesus jeꞌe ch hab chehgig Mary. K ihda Jesus hab e aꞌaga Christ. ");
INSERT INTO oodNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pegih, nt gamai giꞌik an oꞌoha g ha‑chechgig hegam mo d e‑oꞌogbad am i amjed mash eda am oimmed g Abrahambad ch am hugkam mash eda am oimmed g Davidbad. Kunt hab waꞌap gamai giꞌik an oꞌoha g ha‑chechgig hegam mo d e‑oꞌogbad heg i amjed ch gam hu hugkam matsh eda gam hu hab i e juh g t‑shohshon Babylon wui. Kunt gamai giꞌik an oꞌoha g ha‑chechgig hegam mo d e‑oꞌogbad heg i amjed ch gam hu hugkam matsh ab mahsi hegai mo hab e aꞌaga Jiosh si Kehsha (Christ). ");
INSERT INTO oodNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ia ant wo oꞌoha matsh has e juh matsh eda mahsi g Jesus Christ. Am amtsh i apꞌech matsh idam Joseph ch Mary wo e hohont. Tsh am hahawa s‑e mai mat g ali wo bei. ");
INSERT INTO oodNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","K hab chuꞌig g chehanig mat chum pi wo ha bei g cheoj matp hab wo wa e juh. Kush g Joseph am wabsh si s‑ap oid g chehanig ch hekaj hab e elid mat pi wo be k wabshaba pi hedai wo ha ahgi. T hab pi wo si e el g Mary. ");
INSERT INTO oodNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sh am oidahim ihda g Joseph. Kutsh am haha wabsh ab wui i e chehgi g anghil am chehchkij ed k hab kaij, “Joseph map ab d Davidbad amjedkam, am g wabsh s‑ap e tahtk k wo bei g Mary mat d wo m‑wehm kihkamk. Hekia S‑apꞌekam Gewkdag at hab juh ihda ali mat g Mary wo bei. ");
INSERT INTO oodNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kut d wo cheojk. Kupt hab wo chehch Jesus mo hab d ahga ha‑Doꞌibiakam. Bat wo chehgigk nat pi wo ha doꞌibia g e‑hemajkamga ab ha‑chuꞌijig amjed.” Neh, bash kaij g anghil am Joseph wui. ");
INSERT INTO oodNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Wehs atsh wa hab e juh ihda hab masma mash wa hab masma heki hu hab kaij g Jiosh. Kelibad Jiosh haꞌichu i tashogiddam atki an oꞌoha mash wa hab kaij: ");
INSERT INTO oodNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Hema g si s‑ap chehia at wo bei g cheoj ali pi koi ab hu i miabidk g cheoj. Kumt hab wo aꞌagad Manuel mo hab d ahga Jiosh o t‑Wehmaj. ");
INSERT INTO oodNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kutsh hekid am i nea g Joseph k atsh am ha hekaj hab e juh mash has i kaij g anghil ab wui matsh an bei g Mary. ");
INSERT INTO oodNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sh wabshaba pi am hu hab masma e wehm kih mo g e wehm kihkam am hugkam mat hekid ip bei g ali. Tsh g Joseph hab hahawa chehch Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus atsh am mahsi Bethlehem kihhim t am am Judea chekshani ch ed. Sh wenog am hema d kownal Judea ch ed ch hab chehgig Herod. Tsh ab haꞌi hihi siꞌal tahgio amjed mash s‑chu aꞌamichud ab huhuꞌu t ab. K eda g Jerusalem d kownal daikud am t‑jewedga ed. Tsh am dada idam k am ha kakke g hahaꞌichu ch hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Bahꞌo haꞌichug hegai ali matki hemu mahsi matsh d wo ge ha‑kownaligk g Tutuligo. Am at dahiwua g huꞌu matt heg amjed s‑mai g mahsidaj. Kutt heg hekaj ab i hihi matt am hab wo juh g si has t‑elida ab wui.” ");
INSERT INTO oodNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kutsh si e kudu g kownal am i kahk. Tsh heg hekaj wehs g kihkam amai hab waꞌap e kudu. ");
INSERT INTO oodNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tsh g kownal am ha hekaj i ha hemapai g uꞌugchu papal ch chehanig t‑mashchamdam k ab ha kakke, “Bahtsh ab haꞌab wo mahsi hegai matsh g Jiosh d wo Kehshak mat d wo chum em‑kownaligk?” ");
INSERT INTO oodNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sh hab ahg, “Ab Bethlehem t ab id eda chekshani. Batki masma an hema oꞌoha g kelibad Jiosh haꞌichu i tashogiddam mo g Jiosh hab kaij: ");
INSERT INTO oodNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Do al chum kihhim g Bethlehem. Kut eda am hema wo i wuhsh mat d wo ha‑kownaligk ch wo ha wanimedad g ni‑hemajkamga.” ");
INSERT INTO oodNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tsh g Herod am s‑aꞌagim i ha wai hegam s‑chu aꞌamichuddam k ab ha amjed s‑mai matsh hekid ab i e mahsid hegai huꞌu. Tsh am ahgi. ");
INSERT INTO oodNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tsh g Herod am hahawa ha ahgi mat gam hu wo hihi Bethlehem wui hab ha ahgch, “Am g wo hihim k am wo si i gah hegai ali k hekid wo sha chehg k ia wo ni‑ahgi. Kunt ahni am hab waꞌap wo him k ab wo ihm mani ab has elid.” ");
INSERT INTO oodNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Kutsh gam hu hahawa hihim k gam hu hebai i hihim. Tsh ab ep i e mahsid hegai huꞌu mash am wa heki hu neid. Kush si s‑hehegig am i neidok. Tsh heg am ha baꞌich him k am dahiwua heg dahm mash am dadha hegam Joseph. ");
INSERT INTO oodNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tsh am dada k am i wahp kih ch ed. Sh am woꞌo hegai ali. Kush g jeꞌej am wehmaj. Tsh idam s‑chu aꞌamichuddam am wui i shul g ali k am hab juh g ab si has e‑elida k am hahawa i ha wuwhas g s‑namkig haꞌichu k ab mah. Sh id d ohla ch hegai s‑ap uhwchu mo hekaj e iagchulid ch hegai mo hekaj e huhud g muhki. ");
INSERT INTO oodNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sh g Jiosh am ha ahgid am ha‑chehchki ed matsh pi am hu ep wo hihi Herod wui. Kutsh heg hekaj im hu wabsh hihi e‑jewedga wui am hema wohg ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tsh ab hahawa i e chehgi g anghil Joseph wui am chehchkij ed k ash hab kaij, “Kownal Herod at am wo i gahghi ihda ali mat wo chum s‑muꞌam. Mt heg hekaj gam hu wo hihi Egypt jewed wui k am wo haꞌichugkad. Kunt am wo em‑ahgi mamt hekid ep wo i hihi.” ");
INSERT INTO oodNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kutsh am ha hekaj i wami g Joseph k am bei g ali ch jeꞌej k heg waꞌi s‑chuhugam hihi am Egypt wui ");
INSERT INTO oodNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","k am wa dadha. Id atki am hab e juh mat hekaj s‑ap hab wo e juh hegai matki heki hu waꞌi oꞌoha g kelibad Jiosh haꞌichu i tashogiddam. Bo chuꞌig g oꞌohanaj mash g Jiosh hab kaij: Am ant wo i wuhshad g ni‑alidag Egypt jewed amjed. ");
INSERT INTO oodNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pegih, tsh pi am hu ep i hihi Herod wui hegam s‑chu aꞌamichuddam mash wa am ha ahgid g Jiosh. Tsh heg hekaj bagat g Herod. Sh eda idam heki hu ahgid mo am hu d i gohk aꞌahidag mat wa am cheh hegai huꞌu. Kutsh heg hekaj ha cheha g e‑shondalig matsh wehs wo ha kokda g aꞌal wihpiop mash d gohk ahidkam ch am i wecho amai Bethlehem ch ed ch an i wehgaj. ");
INSERT INTO oodNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Neh, id atsh wa hab e juh hab masma mash wa g Jiosh heki hu waꞌi hab kaij matsh hab masma hab wo e juh. Hegai kelibad Jiosh haꞌichu i tashogiddam mash hab chehgig Jeremiah atki an oꞌoha mash hab kaij g Jiosh: ");
INSERT INTO oodNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Am ant wo kah g shoshaki Ramah ch ed. Rachelbad amjedkam at am wo shoanid g aꞌal ha wehhejed ch pi haꞌas wo shosha nat pi wehs wo e kokda. ");
INSERT INTO oodNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sh am dadha hegam Joseph g ali wehm Egypt jewed ch ed. Sh am hu hebai, tsh g Herod muh. Tsh am hahawa ep i e chehgi g anghil am chehchkij ed g Joseph k ash hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Muh at hegai mat chum s‑muꞌam g ali. Mt heg hekaj wo wahpamig k wo uhpam hihi am e‑jewedga wui.” ");
INSERT INTO oodNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kutsh am i wami g Joseph k am ha ui g ali ch jeꞌej k ep hihi am e‑jewedga wui. ");
INSERT INTO oodNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","K wabshaba g Herodbad alidag wenog am d kownal Judea ch ed ch hab chehgig Arkelaus. Tsh g Joseph am i s‑mai mo id d kownal k atsh sha s‑ehbeni mas am wo i dahiwua amai. Tsh g Jiosh am ep ahgi chehchkij ed matsh pi am hu ep wo hihi Judea wui. Tsh hekaj imhab haꞌab ep hihi Galilee chekshani wui ");
INSERT INTO oodNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","k am dadhaiwua Nazareth kihhim ch ed. Heki atki hu hema oꞌoha g kelibad Jiosh haꞌichu i tashogiddam mamt hab wo aꞌagad ihda “Nazareth t am oꞌodham.” ");
INSERT INTO oodNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tsh am hahawa jegko i wuhsh Judea chekshani ch ed ihda mash d John ch ha pahl wapkon g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","John jehnigida ash hab chuꞌig, “Gam g hu wo s‑ohhod g pi ap e‑chegitoi. E o aihim mat in wo i wuhsh g Jiosh kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Neh, id o hab ahg John hegai kelibad Jiosh haꞌichu i tashogiddam mash hab chehgig Isaiah mash eda hab kaij: Hema atsh gam hu jeg ed wo ha mihshmad g hemajkam hab kaijch: Neh, in atsh wo i wuhsh jewed dahm hegai mo d ge kownal wehs haꞌichu dahm. Kumt heg wehhejed wo i e nako. ");
INSERT INTO oodNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sh ab e enigadadch g John g ka‑mihyo wopo ikuskaj ch ge hogi giwud ch heg waꞌi hekaj e gegosid kohktpul ch sitꞌol. ");
INSERT INTO oodNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kutsh ab wui i hihi g hemajkam miajed ch an i aꞌai wehskojed g Judea chekshani, chum hems ab Jerusalem t amjed. ");
INSERT INTO oodNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Muꞌi ash am ahg g pi ap e‑chuꞌijig am i kahkch g John. Kush heg am ha pahl wapkon Jordan akimel ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","9","Haꞌi atsh am dada hegam mo d Palasi ch hegam mo d Sajusi matsh wo nei ihda pahl wakona. Sh hab ha ahg g John, “Hah, ahpim mam pi ap chegitoidag, bamki e elid mamt wo e doꞌibia ab amjed g s‑koꞌok e‑namkidadag heg wabsh hekaj mam ab d Abrahambad amjedkam. Nt wabshaba wo em‑ahgi mamt pi woho wo e doꞌibia, heg hi wa mamt am wo e chehgi am hab junihidch g s‑apꞌekam mamt gam hu s‑ohhod g pi ap e‑chegitoi. Wehs hegam mat gam hu wo s‑ohhod g pi ap e‑chegitoi at d wo Jiosh hemajkamgak ch hekaj hab masma wo e kuint mo d Abrahambad amjedkam, chum wa g nahnko mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kumt ahpim gam hu wo s‑e ohhod hab masma mat g pi kehg bahidkam uꞌus mamtp pi gam hu wo s‑ohhod g pi ap e‑chegitoi k pi am hu hab wo junihid g s‑apꞌekam.” ");
INSERT INTO oodNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kush hab ep kaij g John, “Pi g hab wo ni‑elid manis ahni d si haꞌichu. Ab at hema wo i wuhsh ni‑oidk k d wo si haꞌichuk. Ahni ani hi wa em‑pahl wapkon mamt eda gam hu wo s‑ohhod g pi ap e‑chegitoi. T wabshaba heg ab wo em‑mah g Hekia S‑apꞌekam Gewkdag k gam hu hab wo i juh g pi em‑apꞌekam hab sha masma mat g mehi wo mehi g shaꞌi. ");
INSERT INTO oodNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nam hig pi nehnichud g pilkan mamt g mohgaj gam hu wo i gawulkad k wo mehid k g pilkani ged hu wo i baꞌiha. Pegih, t hab waꞌap am aꞌai wo i ha gawulkai g hemajkam am lodaita ch ed ihda mani em‑ahgid k wo ha doꞌibia g s‑apꞌekam k g pi apꞌekam s‑koꞌokam wo ha namkid. T g ha‑namkidadag pi hekid wo huhug.” Neh, bash kaij g John. ");
INSERT INTO oodNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesus atsh ab hahawa i hih Galilee chekshani t amjed mo hebai d i kihkam k ab jiwia Jordan akimel t ab matsh wo e pahl wako. ");
INSERT INTO oodNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sh g John chum pi pahl wakonamk hab kaijch, “Nis haschu ahgk wo m‑pahl wako nap pi d hekia s‑apꞌekam? Ahpi apt wo chum ni‑pahl wako.” ");
INSERT INTO oodNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sh hab kaij g Jesus ab wui, “Bapt wo ni‑juh no pi g Jiosh hab d elida.” Tsh heg hekaj hab juh g John. ");
INSERT INTO oodNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tsh am haha wabsh i chum wuhsh g Jesus shuhdagi t amjed. Tsh g dahm kahchim gam i e kuhpiꞌo. Tsh ab i hud g Hekia S‑apꞌekam Gewkdag ab ab g Jesus hab sha masma mat g hohhi. ");
INSERT INTO oodNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sh ab neok g Jiosh ab dahm kahchim t amjed ch hab kaij, “Id o d si ni‑tatchuidch ni‑alidag ch am si ni‑tatchui oidch hab masma.” ");
INSERT INTO oodNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sh g Hekia S‑apꞌekam Gewkdag hab hahawa ahg g Jesus mat gam hu hejelko wo hih mo am d tohono jewed matsh wo e aꞌappe. Tsh heg hekaj gam hu hih g Jesus ");
INSERT INTO oodNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","k am haꞌichugkahim giꞌikko wehst‑mahm tash ab pi haꞌichu koꞌadch nash pi e hoꞌigeꞌidahun ab Jiosh wui. ");
INSERT INTO oodNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kutsh ab wui jiwia g jijawul ha‑geꞌejig am chum s‑wuimk pi apꞌekam ch ed k hab kaij, “Bap chum e elid map d Jiosh alidag. Pegih, ab g hig chehani idam hohodai mat wo e pahnch naptki pi bihugim.” ");
INSERT INTO oodNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kush hab kaij g Jesus, “Pi ant hab wo juh. An o hab chuꞌig Jiosh oꞌohana ed: Jiosh neꞌoki o baꞌich d i si s‑has haꞌichu mo hi g haꞌichu hugi. Kut g oꞌodham hemho ab wo wa s‑wohog elidad.” ");
INSERT INTO oodNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kutsh g ge Jiawul am hahawa wuhpuij tahgio i mahsid g geꞌe cheopi. Heg o am kehk amai mo hab e aꞌaga Si Hekia S‑apꞌekam Kihhim ch d Jerusalem. ");
INSERT INTO oodNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kush hab ahg, “Maptp woho d wo Jiosh alidagk, pegih, am g i dahꞌi amjed mo gan hu si uhgk kihtas. No hig pi hab chuꞌig an Jiosh oꞌohana ed: Jiosh at ab wo ha cheha g muꞌi anghil mat wo m‑nuhkud. Kut an hu wo m‑uꞌukchid mapt nih g shaꞌi e‑tahtad ab hu wo shul hohodai t ab.” ");
INSERT INTO oodNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sh hab kaij g Jesus ab wui, “Pi ant wo pipꞌich g Jiosh. An o hab chuꞌig oꞌohanaj ed: Pi g wo shaꞌi pipꞌichudad g e‑kownalig Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kutsh am hahawa wuhpuij tahgio wehs i mahsid g kokownaltalig ch kaistalig jewed dahm ");
INSERT INTO oodNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","k ab wui hab kaij, “Wehs ant am wo m‑mah ihda maptp ab ni‑wui wo i gehsh k ab wo ni‑ihmad.” ");
INSERT INTO oodNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kush hab kaij g Jesus, “Gam g hu hihm, ahpi ge Jiawul. An o hab chuꞌig Jiosh oꞌohana ed: Heg amt waꞌi Jiosh ab wui wo i gehsh k ab wo ihmad ch heg ab wo waꞌi s‑wohog elidad.” ");
INSERT INTO oodNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kutsh wa woho gam hu hih g ge Jiawul. Tsh g anghil ab wui hihi g Jesus k am i wehmt. ");
INSERT INTO oodNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Am hu hebai amtsh am kuh hegai John mo am wa ha pahl wapkon. Kutsh am i kah g Jesus mamtsh kuh k atsh gam hu hahawa hih Galilee chekshani wui ");
INSERT INTO oodNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","k am jiwia Nazareth t ab. K am hema ep d kihhim mo d Capernaum ch an hugidaj an g Galilee kahchki. Kutsh am i dahiwua g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Neh, heki atki hu waꞌi oꞌoha g Isaiabad matsh id am hab wo e juh. K hegai oꞌohanaj hab chuꞌig: ");
INSERT INTO oodNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Si haꞌichu at am hab wo e juh Galilee ch ed. Ihda chekshani o an hab chuꞌig kahchki hugid an ch am huduni tahgio amjed g Jordan akimel. K an kihdag hegam mo d Zebulonbad amjedkam ch hegam mo d Naphtalibad amjedkam ch hegam ehp mo d gawul mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bo sha mahs mo am dadha s‑chuhugam k ed no ge mahch g Jiosh. K g muhkig ab ha wui him. T wabshaba wo nei mat am haꞌichu wo i wuhshani k hab wo sha masmak mo g si geꞌe tonlig. Neh, bash wa kaij g Isaiabad. ");
INSERT INTO oodNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kutsh wa woho am i wuhsh g Jesus k am i ahgahi g haꞌichu e‑ahga hab kaijch, “Gam g hu wo s‑ohhod g pi ap e‑chegitoi. E o aihim mat in wo i wuhsh g Jiosh kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sh an him g Jesus Galilee kahchki hugid an. Kush am haꞌi oiopo g waptopi ha uꞌudam ch am wuhpa g chuagia shuhdagi ch ed ch hekaj am ha uꞌu g waptopi. Hema ash d Simon ch hab hahawa e chechcheg Peter. Kush hema d wehngaj ch hab chehgig Andrew. Jesus atsh am i ha nei idam ");
INSERT INTO oodNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","k hab ha ahg, “Ab g wo i ni‑oid k wo ni‑wehmajkad. Kunt ahni wo em‑mashcha mamt g hemajkam wo i ha wanchkwua am s‑apꞌekam wui.” ");
INSERT INTO oodNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kutsh am ha hekaj wabsh i dagito g e‑chikpan k am i oi. ");
INSERT INTO oodNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tsh am shaꞌi hihi haꞌas huꞌi. Tsh g Jesus am i ha nei idam James ch John. Idam o hab waꞌap d e‑wepngam ch ash am chikpan g e‑ohg wehm wahlko ch ed ch am apꞌechud g e‑chuagia. Tsh g Jesus ab ha wai mat am wo wehmajk. ");
INSERT INTO oodNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kutsh am ha hekaj wabsh i dagito g e‑ohg ch e‑chikpan k am i oi g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kush idam am hahawa hahasko oiopo Galilee chekshani ch ed. Kush g Jesus am ha mashcham g hemajkam ha‑chechopi ed ch am ha ahgidahim g s‑kehg haꞌichu ahgaj g Jiosh ab amjed g kownaltaligaj ch am ep ha dodajid g nahnko mahs kokꞌodam. ");
INSERT INTO oodNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tsh an wehsko i kaida g haꞌichu ahga ab amjed am Syria jewed ch ed mo heg eda g Galilee d chekshani. Tsh g hemajkam heg hekaj wehs ab ha uꞌapa wui hegam mo nahnko masma kokꞌo ch hegam mo haꞌichukaj e kudut ch hegam mo g jijawul an uꞌukch g ha‑chegitoidag ch hegam mo s‑ha chuhugchud ch hegam mo pi himdag. Tsh g Jesus wehs ha dodaj. ");
INSERT INTO oodNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kutsh g hemajkam wehskojed i hihim k am oid g Jesus. Idam ash haꞌi d Galilee t am oꞌodham ch haꞌi ab amjed mo hab e aꞌaga Wehst‑mahm Kihhim ch haꞌi ab Jerusalem t amjed ch an wehskojed g Judea chekshani k ch haꞌi ga hu aigojed g Jordan akimel. ");
INSERT INTO oodNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tsh am i ha nei g Jesus idam muꞌi hemajkam k ab i chesh kawulk t ab mat ab ha wui wo neo. Kutsh an wehgaj i e hemapai hegam mash ab si wecho e mashcham. ");
INSERT INTO oodNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tsh g Jesus am i ha mashcha. Kush id d mashchamdaj: ");
INSERT INTO oodNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Mt wo chum si s‑ap e tahtkkad ahpim mam ab e shoꞌigchud Jiosh wui. Do em‑wehhejedkam g Jiosh kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mt wo chum si s‑ap e tahtkkad ahpim mam hemuch pi ap e tahtk ab amjed g pi apꞌekam. Jiosh at ab wo em‑mah g s‑ap tahhadkam. ");
INSERT INTO oodNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mt wo chum si s‑ap e tahtkkad ahpim mam ab wabsh i e shoꞌigchudch. Wehs at ab wo em‑mah g Jiosh hegai mo an oꞌohanas mo ab em‑makiog am jewed dahm. ");
INSERT INTO oodNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mt wo chum si s‑ap e tahtkkad ahpim mam am si e gahgid mamt d wo s‑apꞌekamk. Bat wo em‑juh g Jiosh mamt d wo si hekia s‑apꞌekamk. ");
INSERT INTO oodNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mt wo chum si s‑ap e tahtkkad ahpim mam s‑ha hoꞌigeꞌid g hemajkam. Jiosh at hab waꞌap wo s‑em‑hoꞌigeꞌidad. ");
INSERT INTO oodNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mt wo chum si s‑ap e tahtkkad ahpim mamt gam hu s‑ohhod g pi ap e‑chegitoi. Am o hiwgidas mamt ab wo neidad g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mt wo chum si s‑ap e tahtkkad ahpim mam am ha dodolimachud g hemajkam. Mt wo s‑em‑mahchk mam d aꞌaligaj g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mt wo em‑shoꞌigch ahpim mamt hab wo junihid g Jiosh tatchui. K wabshaba d em‑wehhejedkam g Jiosh kownaltalig. Kumt heg hekaj wo si s‑ap e tahtkkad. ");
INSERT INTO oodNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mt wo s‑koꞌokam has em‑ahgad ch wo em‑shoꞌigchudad ch nahnko masma hab wo wuad g iattogig ab em‑ab nam pi ab s‑ni‑wohochud. Kumt wabsh wo si s‑ap e tahtkkad ");
INSERT INTO oodNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ch wo si s‑hehgigk no pi geꞌe haꞌichu ab em‑makiog g Jiosh. Heg at wa oidk am hihi g kekelibad Jiosh haꞌichu i tashogiddam. ");
INSERT INTO oodNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Neh, s‑mahch am mat pi wo e padch g chuhkug mamtp wo si onmad. Pegih, mt hab wa masma haꞌichu wehhejed wo s‑kehgajk am ha shahgid hegam mo pi mahch g Jiosh. Jiosh at gam hu hab wo i em‑juh mamtp pi haꞌichu wehhejed wo s‑kehgajk hab masma mamt hab wo juh g on matp wo kahko. ");
INSERT INTO oodNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ahpim mam ab si ni‑hiwig amt wehs wo ha tonolidad g hemajkam. Heg o wa wepo mam d tonlig am ha wehhejed. Pi g am wo ehstokch hegai mamt haschu hab wo junidad g Jiosh. Neh, no hig pi woho mat pi ap wo e ehsto g kihhim matp am wo dahmkad g tohnk. ");
INSERT INTO oodNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","T g lahmpa hab waꞌap pi wo e ehsto haꞌichu wecho. Mt an wo dai mat hebai wo em‑tonolidad. ");
INSERT INTO oodNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pegih, mt ahpim pi wo ehsto g s‑em‑apꞌekam k wabsh wo ha hiwgidad g hemajkam mat wo nei. Kut hekaj ab wo si has elidad g em‑ohg Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Pi ant hab ahgk ia jiwia jewed dahm manis gam hu hab wabsh wo i juh hegai chehanig ch mashchamadag matsh wa g kekelibad Jiosh haꞌichu i tashogiddam ab bei Jiosh t amjed. Heg eda o an oꞌohanas mant has wo masmak ch has wo ni‑juh k wo nahto g ni‑chikpan. ");
INSERT INTO oodNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nt wo si shel em‑ahgi mat pi hekid gam hu hab wo i e juh g Jiosh chehanig. Wehs at s‑ap wo e nahto hegai mo an oꞌohanas mat koi wo huhug g dahm kahchim ch jewed kahchim, chum hems g si al chuꞌuchum haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kut d wabsh wo pi haꞌichuk am Jiosh nena ed hegai mat hedai pi am hu wo wohog elidad g Jiosh chehanig ch wo ha mashcha haꞌijj ehp mat hab waꞌap pi ab hu wo wohog elidad. Kut heg d wo si haꞌichuk am Jiosh nena ed mat hedai ab wo wohog elidad g Jiosh chehanig ch wo ha mashcha haꞌijj ehp mat ab wo wohog elidad. ");
INSERT INTO oodNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bo e elid g chehanig em‑mashchamdam ch Palasi mo s‑ap oid g Jiosh chehanig. Nt wabshaba wo em‑ahgi mamt hemho wa ha baꞌich i s‑ap wo oidad mamtp am s‑wahpkim Jiosh kihdag ed. ");
INSERT INTO oodNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“S‑mahch am mo hab chuꞌig g heki hu chehanig mamt pi wo ha mua g hemajkam. Kut hemho wa wo e lodai matp hedai wo sha ha mua. ");
INSERT INTO oodNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kunt ahni am baꞌich hab wo i ah mamt am wa hugkam ab wo moht g chuꞌijig mo g ha muꞌakam mamt chum hems wabsh wo bagat ab hema i wui k hab wo ah mo d wabsh pad haꞌichu. Ab o em‑wui him mat g Jiosh wo em‑lodai heg hekaj k gam hu wo i em‑wua Jiawul kih ed. ");
INSERT INTO oodNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Am g wo haꞌasa e hoꞌigeꞌidahun mamtp wo s‑chegito mamt hema i pi ap dohdda. Pi at ab hu wo em‑kaiha g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Wehpeg amt am wo i e apꞌech heg wui mamt pi ap dohdda k am haha wo e‑hoꞌigeꞌidahu. ");
INSERT INTO oodNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","26","Mtp hems wo em‑lodai mamtp pi am hu s‑hohtam wo i e apꞌech. Kumt wo e kuhpach am hugkam mamt wehs wo namkid wehhejed mamt has i juh. Baꞌich at wo i s‑apꞌek mamt wehpeg hejel am wo i e apꞌech aꞌai e wui. ");
INSERT INTO oodNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“S‑mahch am mo hab chuꞌig g heki hu chehanig mamt pi wo ha ehs g ha‑wehm kihkam. ");
INSERT INTO oodNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kunt ahni am baꞌich hab wo i ah mo heg wa wepo mamt ha ehs mamtp am wabsh wehmaj wo s‑woꞌiwuim hegai mo pi d em‑wehm kihkam. ");
INSERT INTO oodNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kut d wo em‑wuikamk mamt gam hu wo i e wua Jiawul kih ed. Baꞌich at wo i s‑apꞌek mamt chum hems wo heb hu wua g e‑nendag. ");
INSERT INTO oodNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Do em‑wuikam mamt am hu wo i e wua Jiawul kih ed chum ams haschu pi apꞌekam hab wo juh. K baꞌich i s‑apꞌe mamt chum hems wo heb hu wua g e‑nowi. ");
INSERT INTO oodNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“S‑mahch am mo hab chuꞌig g heki hu chehanig mamt hemho wa am wo i wuhshad g ohhoda tapial e‑hohnig wehhejed mamtp wo s‑ohhod. ");
INSERT INTO oodNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nt wabshaba am wo em‑ahgi mat d wo pi apꞌekamk mamt wo s‑ohhod, heg hi wa mamt wo s‑mai am i chum hohntk mat heki hu ha wehm woꞌiwua. Kut d wo pi apꞌekamk mat g em‑ohhoda hema ep wo kunt. Id at d wo em‑chuꞌijigk mamtp wo s‑ohhod. Kut hegai mat wo hohnt hab waꞌap wo juh g pi apꞌekam. ");
INSERT INTO oodNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“S‑mahch am mo hab chuꞌig g heki hu chehanig mamt pi wo ha iattogidad ch hemho am hab wo wa juh mam haschu ha ahgid ch chehcheg g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nt wabshaba am wo em‑ahgi mamt hemho am hab wo wa juh g e‑neꞌoki. Pi o apꞌe mams wabsh chum haschu wehhejed wo gewkaj g e‑neꞌoki. Neh, am am wabsh pehegia gewkaj g e‑neꞌoki am chehchegch g dahm kahchim. K eda g dahm kahchim d Jiosh kihdag. K hab wa masma mamtp hems g Jiosh am chehch. ");
INSERT INTO oodNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kum am ep chehcheg g jewed. K eda heg d Jiosh nahtoi ch heg wa wepo mo d keishpakudaj. Kum am ep chehcheg g Jerusalem. K eda heg d kihhimaj g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","E‑moꞌo am hab waꞌap aꞌaga hab kaijch mamt wo moht g chuꞌijig mamtp pi hab wo juh g e‑neꞌoki. T eda g Jiosh wo waꞌi e nako mat wo em‑mohtoꞌi g chuꞌijig. Id o wehs hab masma mamtp hems am chehch g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Neh, bamt wo chum juh g e‑neꞌoki, chum ams pi wo gewkaj am chehchegch g Jiosh. T d wabsh wo ge Jiawul amjedkamk mamtp wo ha iattogi. ");
INSERT INTO oodNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“S‑mahch am mo hab chuꞌig g heki hu chehanig mamt wo ha lodai mat hedai s‑koꞌokam has em‑juh. T ab wui hab epai wo e juh mat has i em‑juh. ");
INSERT INTO oodNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nt wabshaba am wo em‑ahgi mamt pi wo shaꞌi e agwuim. Tp hems hema ab wo em‑shonihi em‑kahm ab. Pegih, mt wabsh wo hiwigi mat ab ep wo em‑shonihi. ");
INSERT INTO oodNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kumt baꞌich haꞌichu ab wo mah hegai matp hedai wo em‑lodai haꞌichu s‑em‑wohppoꞌidamch. ");
INSERT INTO oodNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kumt gam hu wo si baꞌiwich mam haschu chikpan em‑mohtoꞌid wabsh s‑ap e tahtkch. ");
INSERT INTO oodNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pi g wo shaꞌi daꞌid matp haschu i tatchua g shoꞌigkam. ");
INSERT INTO oodNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“S‑mahch am mo e ahgachug mamt ab wo si ha tatchuad g e‑naipijju ch wo s‑ha kehꞌidad g e‑obga. ");
INSERT INTO oodNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","47","Nt wabshaba am wo em‑ahgi mamt pi hegam waꞌi ab wo si ha tatchuad e‑naipijju. Chum o hems g pi ap hemajkam ab si ha tatchua g e‑naipijju ch wabshaba pi heg hekaj wo e doꞌibia. Neh, ahpim amt chum hems g e‑obga wo si ha tatchuad ch am ha wehhejed wo e hoꞌigeꞌidahunad Jiosh wui. Jiosh o chum hems g pi ap hemajkam ab si ha tatchua ch ab ha mahk g tash tonlig ch juhki. Kumt ahpim hab wo chum masmak mo g Jiosh nam pi d aꞌaligaj. ");
INSERT INTO oodNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Em‑ohg Jiosh o d si hekia s‑apꞌekam. Pegih, mt ahpim hab waꞌap d wo si hekia s‑apꞌekamk.” ");
INSERT INTO oodNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kush hab ep kaij g Jesus, “Am g wo s‑e nenꞌoidad mamt pi am hu hab wabsh wo wuad g haꞌichu s‑apꞌekam hab ahgk mat g hemajkam wo neidad mam haschu am hab junihim. Jiosh at pi ab hu wo em‑mah g s‑kehg mahkigdag mamtp hab masma wabsh wo s‑e chehgidam. ");
INSERT INTO oodNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Pi g wo s‑e chehgidamk mamt hekid wo i ha wehmt g shoꞌigkam. Hegam mo s‑e chehgidamk mo i ha wehmt o am hab wua em‑namki ed ch an kahya ch ed. K g hemajkam ab si has ha elid. Neh, id o d ha‑namkidadag. Nt wo si shel em‑ahgi mat g Jiosh pi ab hu has wo ha el. ");
INSERT INTO oodNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ahpim amt wabsh s‑aꞌagi wo i ha wehmtad g shoꞌigkam mat pi hedai wo s‑mahchk. ");
INSERT INTO oodNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","T g em‑ohg Jiosh wo em‑neid k ab wo si has em‑elidad. ");
INSERT INTO oodNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pi g wo s‑e chehgidamk mamt hekid wo e hoꞌigeꞌidahu. Hegam mo s‑e chehgidamk at wo gegokiwua k wo e hoꞌigeꞌidahu am em‑namki ed ch an kahya ch ed. Kut wehsijj wo ha neid k ab wo si has ha elidad. Neh, id o d ha namkidadag. Nt wo si shel em‑ahgi mat g Jiosh pi ab hu has wo ha elidad. ");
INSERT INTO oodNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ahpim amt am wo i wahp e‑kih ed k ab wo si i kuh g kihjeg k am wabsh hejelko wo e hoꞌigeꞌidahu Jiosh wui. Kut heg wo waꞌi em‑neidad ch ab wo has em‑elidad. ");
INSERT INTO oodNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Hegam mo pi mahch g Jiosh o am wabsh muꞌikko e dahm hab haꞌichu chechꞌe hab elidch mat hab waꞌi masma wo ha kah g Jiosh. Mt wabshaba ahpim pi hab masma hab wo e junihid. ");
INSERT INTO oodNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jiosh o d em‑ohg ch heki hu s‑mahch mam haschu i tatchua mam wa chum koi ab hu tahni haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bamt masma am wo e hoꞌigeꞌidahunad: T‑ohg Jiosh, an ap kihdag dahm kahchim ch ed. Kuch ab si has m‑elid ch si haꞌichuchud g m‑chehgig. ");
INSERT INTO oodNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ab ach m‑tahni mapt wo i geꞌedaj g e‑kownaltalig ia t‑shahgid mat g m‑tatchui am hab wo e junihid ia jewed dahm hab masma mo an hab e wua m‑kihdag ed. ");
INSERT INTO oodNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ab g i s‑t‑hoꞌigeꞌid k ab wo t‑mahkad g haꞌichu hugi wehs tashkaj. ");
INSERT INTO oodNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gam g hu hab i juhni g pi ap t‑chuꞌijig hab masma mach gam hu pi chechegitod g ha‑chuꞌijig hegam mat hedai pi ap has chuꞌi ab t‑wui. ");
INSERT INTO oodNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pi g am hiwgid g Jiawul mas am wo t‑shul pi apꞌekam ch ed. Ahpi ap d kownal wehs haꞌichu dahm ch wehs edgid g gewkdag. Kutt ab wo si has m‑elidad chum hekid. ");
INSERT INTO oodNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Neh, bamt masma am wo e hoꞌigeꞌidahunad Jiosh wui wabsh pi chegitok g pi ap ha‑chuꞌijig. T g Jiosh gam hu hab wo i juh g pi ap em‑chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","T wabshaba g em‑chuꞌijig pi gam hab wo i e juh mamtp pi wo pi chegito g ha‑chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pi g wo s‑e chehgidamk mam pi ap e tahtk mamt hekid heꞌekkio pi wo e gegos e hoꞌigeꞌidahunch. Hegam mat wo s‑e chehgidam at wo nei g e‑namkidadag mat g hemajkam ab wo si has ha el. Nt wabshaba wo si shel em‑ahgi mat g Jiosh pi ab hu has wo ha el. ");
INSERT INTO oodNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Am g wo wakon g e‑wuhiosha k ab wo si i gaswua g e‑moꞌo. ");
INSERT INTO oodNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","T hab pi wo mahchk g hemajkam ab i em‑neidk mam pi e gegosid. T heg wo waꞌi s‑mahchk em‑ohg Jiosh ch ab wo si has em‑elidad. ");
INSERT INTO oodNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Pi g an hu wo e toꞌidahid g s‑kaisdag id dahm jewed. Tp hems wabsh wo padt o atp hems hema wo em‑ehs. ");
INSERT INTO oodNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mt wabshaba wo hekaj g e‑kaisdag am Jiosh wehhejed. T heg wo wa wepok mam heg an e toꞌidahim Jiosh kihdag ed. T pi hekid wo padt. Kut pi hedai wo em‑ehs. ");
INSERT INTO oodNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kumt am wo s‑hihimim no pi g em‑tatchuidag am ulinig mo hebai haꞌichug mam haschu hab i elid mo d em‑kaisdag. ");
INSERT INTO oodNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Em‑wuhpui at s‑ap am wo i wahki g tonlig matp wo s‑mamsk ");
INSERT INTO oodNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","k wabshaba pi am hu wo i wahki matp pi wo mamsk. Kum heg hekaj s‑ap nuhkud. Pegih, wahm amt wo si s‑ap nuhkudad g haꞌichu e‑amichudadag mat heg s‑ap am wo i wahki g wohokam. Dat wo si geꞌe s‑chuhugamk em‑wehhejed matp pi wo apꞌek g em‑amichudadag. ");
INSERT INTO oodNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Pi at hedai wo e nako mas ha wepo hab masma ab wo ha neidad g gohk e‑aꞌamo. Hemho wa atp hems hema baꞌich wo i s‑wohog elidad. Em‑kaisdag o heg wa wepo mo d em‑ahmo mamtp heg hekaj baꞌich wo i pihk e elidad mam hi g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Neh, nt heg hekaj hab wo em‑ah mamt pi wabsh wo i e kudutad heg hekaj mams haschukaj wo e gegos o mams haschukaj wo e enigadad. Jiosh at ab em‑mah g em‑doakag, pegih, k ab hab waꞌap wo em‑mah mamt haschukaj wo e dagioꞌidad. ");
INSERT INTO oodNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","An g wo i ha neid hegam uꞌuwhig mo an nenꞌe. Idam o pi haꞌichu eꞌeshad ch pi od g haꞌichu esha ch pi gan hu e toꞌidahim g haꞌichu bahidag. K wabshaba g em‑ohg Jiosh ha nuhkud. Kum eda ahpim baꞌich d i si haꞌichu mo g uꞌuwhig. ");
INSERT INTO oodNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Pi amt wo e nako mams am baꞌich wo i himch g e‑aꞌahidagga, chum ams hems wo si e kudutad am chegitokch. ");
INSERT INTO oodNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Pi g am wo si e kudutad ab amjed mams haschu ab wo enigat. An g wo i neidad g haꞌichu heosig m an wehsko chuhch. Heg o wa wepo mo si s‑kehg e enigadadch ch eda pi haꞌichu shaꞌi shohshom. ");
INSERT INTO oodNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Solomonbad o pi hab masma s‑kehg e enigadadch, chum as d si s‑kais kownal. ");
INSERT INTO oodNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Neh, haꞌichu wuhshanig o wabsh al heꞌekia tash an hab chuꞌig. K eda g Jiosh si s‑kehg an wuhshad. Kum ahpim baꞌich d i haꞌichu am wehhejed. Kut woho ab wo em‑enigadad. Pegih, mt heg hekaj ab wabsh wo si hiwgad ");
INSERT INTO oodNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ch pi am hu wo e kudutad ab amjed mams hebai wo bei g e‑gegosig o g e‑wehschuga. ");
INSERT INTO oodNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hegam mo pi mahch g Jiosh o id am wa si oid. M eda ahpim d Jiosh aꞌaliga. K heg s‑mahch mam tatchua wehs ihda. ");
INSERT INTO oodNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wehpeg g am wo i e dagitok Jiosh wui k hab d wo s‑apꞌekamk. Kut heg wehs ab wo i em‑mah mam haschu i tatchua. ");
INSERT INTO oodNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Pi g am wo shaꞌi e kudutad heg amjed mat haschu has wo i e juh baꞌich tash. Am o wa haꞌichug g em‑kudutadag id i tashkaj ch pi hab chum mahs mams g siꞌalim kudutadag ab wo i wehnad. ");
INSERT INTO oodNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Pi g am hedai has wo ahgad nat pi ab uhpam wo i e nodagi em‑wui. ");
INSERT INTO oodNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mamt has i masma wo has ha ahgad, t ab wo i nod em‑wui g has ahgadag hab masma. Ab at wo i e nodagi em‑wui mamt has i masma ab wo neidad hema. ");
INSERT INTO oodNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Pi g am wo si s‑nenꞌoidad g hema chuꞌijig. Tp hems baꞌich i geꞌej g hejel em‑chuꞌijig. Id at heg wo wa wepok mam g chum haꞌichu ab i s‑wuhshdamk wuhij ed mo eda baꞌich i geꞌe haꞌichu ab woꞌo em‑wuhi ed. ");
INSERT INTO oodNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Do iattogi mamtp hab wo chei mamt haꞌichu ab wo i wuhshad wuhij ed mo eda g baꞌich i geꞌe haꞌichu ab woꞌo em‑wuhi ed. Hemho wa amt wehpeg wo i apꞌech g pi e‑apꞌedag k haha wo e nako mamt wo i apꞌech g hema pi apꞌedag. ");
INSERT INTO oodNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Pi g ab hu wo ha ahgid g Jiosh haꞌichu ahga hegam mo pi ab hu tatchua. Heg at wo wa wepok mamt g s‑ta keꞌidam gogogs ab wo ha mah g hekia s‑apꞌekam haꞌichu o g kokji ab wo ha mah g si s‑namkig babiuga. Gogogs at hi ab wabsh wo i nehni k wo s‑koꞌokam has wo em‑juh. T g kokji hi wabsh wo kehiwia g babiuga. ");
INSERT INTO oodNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","“Ab g wo ha tahnid haꞌichu k ab wo bebhed. Am g wo e gahgidad haꞌichu k wo cheh. Ab g wo shontpagad. T ab wo i e kuhpiꞌo g pualit em‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ahpim oꞌog, namt hig wabsh g hodai wo mah g e‑alidag mat g simito wo em‑tai ");
INSERT INTO oodNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","o wabsh g wamad wo mah mat g watopi hidod ab wo em‑tai? ");
INSERT INTO oodNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Chum ams d pi apꞌekam ch eda s‑mahch mamt s‑kehg haꞌichu wo ha mah g e‑aꞌaliga. Wahm hig g em‑ohg Jiosh at woho baꞌich i s‑kehg haꞌichu ab wo em‑mah mamt ab wo tahnid haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Am g hab wo ha juhkchid g hemajkam mam has i chum ha elid mat hab wo em‑juhkchid. Bamt masma wehs am hab wo juh mo haschu an oꞌohanas Jiosh heki hu oꞌohana ed. ");
INSERT INTO oodNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Am g wo i e dagitok Jiosh wui k ab wo s‑wohog elidad. Id at heg wo wa wepok mamt am i wahp al aj kihjeg t amjed k am aj wohg oidch hihim. Pi o muꞌijj hab masma hab e wua. Kumt hab waꞌi masma am wo bei g pi ha huhugedam doakag. (13) Pi o hasig mamt hab wabsh wo junihid g hejel e‑tatchui. Id at heg wo wa wepok mamt ab s‑tadani kihjeg t amjed i wahp k am s‑tadani wohg oidch hihim. Muꞌijj o hab masma hab e wua ch hab ab aihim g Jiawul kih. ");
INSERT INTO oodNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Muꞌi at an wo i wuwha g s‑chu iꞌattomkam k hab wo e aꞌagad mo d Jiosh haꞌichu i tashogiddam. Am g wo s‑ha nenꞌoidad mat pi am hu wo i em‑shul pi apꞌekam ch ed. T wo s‑em‑padchudam hab masma mat g shehꞌe wo s‑muꞌam g kahwal. ");
INSERT INTO oodNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mt wo s‑mahchk mo pi d wohokam am neidch mo has masma. Nat hig wo e nako g hoꞌi shaꞌi mat wo bahidagt g uhdwis o g suhna? Pegih, t hab wa masma pi wo e nako hegam s‑chu iꞌattomkam mas wo em‑oidk hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Neh, heg at wo waꞌi s‑kehg bahidagt s‑kehg haꞌichu wuhshanig. ");
INSERT INTO oodNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","T g pi kehg wuhshanig pi kehg wo bahidagt. ");
INSERT INTO oodNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kumt wo shonch k gam hu wo mei. ");
INSERT INTO oodNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Neh, mt hab wa masma wo ha mai mas hu wa woho d Jiosh haꞌichu i tashogiddam mamt wo nei mas wa woho ab s‑wohog elid g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Muꞌijj at hab wo chum ni‑aꞌagad mani d s‑apꞌekam ha‑kownalig ch wabshaba pi am hu hab wo junihid g ni‑ohg Jiosh tatchui. Kut g Jiosh pi am hu wo i ha wahpki e‑kihdag ed. ");
INSERT INTO oodNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“T ab wo i e ai g lodaita tash. T idam hab wo chum kaijjid ab ni‑wui, ‘S‑apꞌekam ni‑kownalig, m‑gewkdagkaj ach am ahgachug g Jiosh haꞌichu ahga ch gam hu i ha wuwhasid g jijawul ch am hab junihim g s‑hasig haꞌichu.’ ");
INSERT INTO oodNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","“Kunt hab wo chei ab ha wui, ‘Pi ani hekid shaꞌi s‑em‑mahch. Gam g hu wo hihim ab ni‑amjed ahpim mam hab junihim g pi apꞌekam.’ T hemho wa gam hu wo hihi. ");
INSERT INTO oodNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ab g wo s‑wohog elidad g haꞌichu ni‑ahga. T hab wo s‑apꞌek g em‑doakag. Id at heg wo wa wepok matp hems hema s‑wihnam wo shondad g e‑kihta. ");
INSERT INTO oodNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","T hab pi wo i gei mat hekid wo hewed k juh k wo s‑gewkam mel g shuhdagi. Pegih, mt hab wa masma s‑wihnam wo gegokkad mo ihda kih mamtp ab wo s‑ni‑wohog elidad. ");
INSERT INTO oodNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“T wabshaba pi wo apꞌek g em‑doakag mamtp pi ab hu wo wohog elidad g haꞌichu ni‑ahga. Heg at wo wa wepok matp hems hema pi wihnam wo shondad g e‑kihta. ");
INSERT INTO oodNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","T wo si hewed k juh k s‑gewkam wo mel g shuhdagi. Kut g kihj wo i gehsh k am wabsh wo i e padch. Pegih, t hab wa masma wo i e padch g em‑doakag mo ihda kih mamtp pi ab hu wo ni‑wohog elidad.” ");
INSERT INTO oodNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Neh, tsh am i haꞌasa ha mashcha g Jesus. Tsh g hemajkam si has i el ");
INSERT INTO oodNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","no pi s‑e mamachim ha mashcham. Sh eda hegam mo d chum chehanig ha mashchamdam pi hab masma s‑e mamachim ha mashcham. ");
INSERT INTO oodNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tsh ab hahawa i hud g Jesus kawulk t amjed. Tsh ab i oi hegam muꞌi hemajkam mo an wehmaj. ");
INSERT INTO oodNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tsh am hema jiwia g oꞌodham mash mumku heg hekaj mumkidag mo g chuhkugaj muhkhim k atsh ab i gei Jesus wecho k hab kaij, “S‑apꞌekam ni‑kownalig, ab g si i s‑ni‑hoꞌigeꞌid k i ni‑doajid, pej maptp wo tatchuad.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tsh g Jesus ab tahtam k hab kaij, “Am o wa s‑apꞌe. Doajini.” Tsh am ha hekaj i doa. ");
INSERT INTO oodNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sh hab hahawa kaij g Jesus ab wui, “Neh, pi apt hedai wo ahgid k wabshaba am ha hekaj wo hih pahl wui. T am wo m‑chechga k wo wohokamch mapt doa. Pt am hab haha wo juh hegai iagchulida mo wa g Jiosh em‑chehani Mosesbad oꞌohana ed. T hab wo s‑mahchk g hemajkam mapt woho doa.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kutsh gam hu hahawa hihi idam Jesus k am dada Capernaum t am. Sh amai am hema d shondal ha‑geꞌejig ch ab Rome t amjed am d ha kehsha ch ab si tahni g i wehmtadag ch hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“S‑apꞌekam ni‑kownalig, mumku at g ni‑pionag k ab woꞌo ni‑kih ab ch pi e nako mas an has wo i e juh k muꞌi e shoꞌigchud.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sh hab kaij g Jesus, “Am ant wo wa i him k wo doaj.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sh hab kaij hegai shondal ha‑geꞌejig, “Pi ani am hu hugkam d haꞌichu maps am wo i wah ni‑kih ed. Am apt hab wabsh wo chea. T wo doa g ni‑pionag. ");
INSERT INTO oodNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Bo wa masma ab haꞌichu ni‑chehani g ni‑geꞌejig. Kuni ab s‑wohog elid. K g ni‑shondalig hab waꞌap ab s‑ni‑wohog elid. Hema ant hab wo ah, ‘Am g hihm.’ T am wo hih. Nt hema hab ep wo ah, ‘Ab g i hihm.’ T ab wo i hih. Kuni g ni‑pionag hab ep aꞌaga mat haꞌichu hab wo ni‑juni. K am hab wua.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kutsh si has i el g Jesus am i kaiok k hab kaij ab ha wui hegam mo an wehmaj, “Neh, ab o si ni‑hiwig ihda gawul mahs oꞌodham. Pi ani hekid shaꞌi kah mas hab masma ab si ni‑hiwig g Tutuligo. ");
INSERT INTO oodNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kunt hab wo em‑ahgi mat muꞌijj ab wo i hihi siꞌal wecho amjed ch hudunig wecho amjed k am wo wehmaj dadhaiwua g Abrahambad ch Isaacbad ch Jacobbad an Jiosh kihdag ed. ");
INSERT INTO oodNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Id o d chum ha‑apꞌedag g Tutuligo. T wabshaba muꞌijj pi am hu wo i wahp no pi pi ab hu ni‑hiwig. T g Jiosh gam hu wo ha shul s‑chuhugam k ed. Kut chum hekid am wo shoanid ch ga hu wabsh wo i si e kiꞌishch nat pi wo shaꞌi si s‑koꞌok haꞌichu nakogad.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kush hab hahawa kaij g Jesus heg wui shondal ha‑geꞌejig, “Gamai g hihm uhpam. T heg am hab wo e juh map haschu ab ni‑tahni nap pi ab si ni‑hiwig.” Kutsh heg waꞌi ohla ab doa g piongaj. ");
INSERT INTO oodNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kutsh amjed gam hu haꞌi hihi idam Jesus Peter kih wui. Sh am woꞌok ch mumku g Peter hohnig jeꞌe ch g s‑toni iajidch. ");
INSERT INTO oodNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kush g Jesus an taht g nowij. Tsh ha hekaj huhug g s‑tonjig ab ab. Kutsh am i wamig k ha hihidol. ");
INSERT INTO oodNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tsh gam hu i juh. Tsh g hemajkam muꞌi am ha uꞌapa g kokꞌodam ch hegam mo g jijawul an ha uꞌukch. Tsh g Jesus am i ha wuwhas g jijawul k am wehs ha doaj g kokꞌodam. ");
INSERT INTO oodNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Heki atki hu waꞌi oꞌoha g Isaiabad matsh id am hab wo e juh. K hegai oꞌohanaj hab chuꞌig: Heg at ab wo moht g t‑mumkidag k im hu hab wo i juh ab t‑amjed. ");
INSERT INTO oodNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sh muꞌi hemajkam an ha wehgaj. Sh heg hekaj hab ha ahg g Jesus hegam mo si ha mashcham mat wo e nako. T gan hu aigojed wo i chehchsh g sikod shuhdagi. ");
INSERT INTO oodNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tsh wabshaba am hema jiwia g chehanig ha mashchamdam k hab kaij, “T‑mashchamdam, ni‑nahtokch ani mant am wo m‑oi.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sh hab kaij g Jesus ab wui, “Napt hig wo e nako? Neh, chum o hems g gagso ch uꞌuwhig ge koksh. Ni wabshaba ahni Jiosh si Kehsha pi shaꞌi ha kih ia jewed dahm. K heg hekaj s‑hasig maps am wo ni‑oi.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sh hema hab kaij hegam mash ab wecho e mashcham, “S‑apꞌekam ni‑kownalig, chum ani hi wa am i s‑m‑oidamk idani. T wabshaba hoꞌipki hekid muh g ni‑ohg. Nt wo hiashpok haha wo m‑oi.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sh hab kaij g Jesus, “Am g ha hiwgid hegam mo pi uꞌukch g wechij doakag mat wo ha hiash g koꞌi. Pt ahpi hi ab wo i him k wo ni‑wehmajk.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sh g Jesus an hahawa dahiwua wahlko ch ed am ha wehm hegam mash ab si wecho e mashcham k am gahi i shul. ");
INSERT INTO oodNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kutsh haha wabsh si s‑gewkam ab i meh g hewel shuhdagi dahm k ab i toꞌotonkai g shuhdagi matsh gam hu si i chesh wahlko dahm. Sh g Jesus am woꞌok ch kohsh. ");
INSERT INTO oodNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kutsh am wui hihim k am wuhan k hab kaij, “T‑kownalig, t‑doꞌibiani. Ttki wo t‑koꞌij.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Sh hab kaij g Jesus ab ha wui, “Shahchu amt ahgk si e totods. Pi amki ab hu si ni‑hiwig.” Bash kaij ch am wamig k ab si chehani g hewel ch shuhdagi toꞌotonk mat wo dodolimat. Kutsh gam hu wabsh i pi shahm. ");
INSERT INTO oodNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tsh wehsijj si has i elid k hab kaij, “S has mahs d oꞌodham ihda mo chum hems g hewel ch shuhdagi toꞌotonk ab s‑wohog elid.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tsh am aigo dada. K amai d ha‑chekshani g Gadarene hemajkam. Sh am ge chehchog mo am g koꞌi e toꞌaw. Tsh gohk ab i wuwha g chechoj. Kush g jijawul an ha uꞌukch. Kush shaꞌi s‑ta ehbidama. Sh chum hedai s‑ehbid matsh am haꞌab wo i bij. ");
INSERT INTO oodNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tsh idam an ha nam k si s‑kaidam hab kaij ab Jesus wui, “Shahchu apt ahgk ab t‑wui i hih, ahpi Jiosh alidag. Napt wo s‑koꞌokam t‑namkid mat wa chum koi e ai g tash?” Bash kaij nash pi g Jesus s‑ha wuwhasidamk g jijawul. ");
INSERT INTO oodNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sh eda muꞌi an oiopo g kokji kawulk bahsho ch e gegosid. ");
INSERT INTO oodNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sh idam jijawul ab si tahni g Jesus ch hab kaij, “Pt hig wo t‑hiwigi matt am wo i wahp hegam ha eda kokji.” ");
INSERT INTO oodNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sh hab ha ahg g Jesus, “Hijiwo.” Tsh wa woho gam hu i wuwha k am wahp kokji ha eda. Kutsh wehsijj idam kokji am agshp i wohp k am shul shuhdagi ch ed k wachkk. ");
INSERT INTO oodNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kutsh hegam mash am ha nuhkud idam kokji gam hu si wohp k am dada kihhim t am k am ha ahgid mat haschu has e juh am ha tahgio idam oꞌodham mash g jijawul an ha uꞌukch. ");
INSERT INTO oodNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kutsh muꞌijj ab amjed hegai kihhim am i namkhi g Jesus k am i chehg k hab ahg mat wo si s‑ha hoꞌigeꞌid k gm hu wo hih ab ha‑chekshani amjed. ");
INSERT INTO oodNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tsh an hahawa gahi ep hihi g wahlkokaj idam Jesus k am dada Capernaum t am mo am kih. ");
INSERT INTO oodNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tsh am haꞌi dada hema woꞌichugch wahkus ch ed nash pi ab wabsh i s‑moik ch pi himid. Sh am neid g Jesus mo ab si hiwig idam mat am wui uꞌapa ch hab kaij ab wui g mumkudam, “Am g si e gewkaj, ni‑nawoj. Gm ant hu hab i juh g pi ap m‑chuꞌijig.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sh haꞌi gegok g chehanig ha mashchamdam ch hab kaij ab aꞌai e wui, “Ih, shoꞌo waꞌi si pi ap neok hab masma e wepogidch g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kush g Jesus s‑mahch mo haschu am chegito ch hab kaij ab ha wui, “Am am g pi apꞌekam haꞌichu chegito ");
INSERT INTO oodNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","hab elidch mani hab wabsh kaij ch pi woho edgid g gewkdag mant gam hu hab wo i juh g pi ap ha‑chuꞌijig. Bam elid mo s‑pehegim hab e kaij, ‘Gm ant hu hab i juh g pi ap m‑chuꞌijig,’ no ge hedai s‑mahch mas s‑wohom gam hu hab i e juh. ");
INSERT INTO oodNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pegih, nt wo em‑chehgi mani woho ge gewkdag ch hab wua mani has i kaij ahni Jiosh si Kehsha,” k hab hahawa kaij ab wui ihda mo ab wabsh i s‑moik, “I g wamig k am behꞌi g e‑wahkus k hihm am uhpam.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kutsh am i wamig k gam hu hih uhpam. ");
INSERT INTO oodNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kutsh am i nei g hemajkam ihda k si s‑ehbeni k ab si has i el g Jiosh natki pi ab mah g Jesus ihda gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tki amjed am hih g Jesus k am hu hebai himad ch ni‑cheh ahni Matthew. Nid wa eda am chikpan mo am g kownal ha kowlant g hemajkam g lial. D hab kaij g Jesus ab ni‑wui, “Ab g i hihm k ab si ni‑wecho wo e mashchamad.” Nid am ha hekaj i wuhshani k am i oi. ");
INSERT INTO oodNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Am hu hebai amjed, nid ab ha wai hegam Jesus mat am wo e gegos ni‑kih am. D ab i hihi. Kud muꞌi am dada k am t‑wehm e gegosid g lial ha kowlantdam ch hegam mo pi am hu si oid g t‑shohshon ha‑himdag. ");
INSERT INTO oodNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dki am haꞌi dada g Palasi. Kuchd eda am t‑gegosid. D idam hab kaij ab t‑wui, “Ih, k haschu ahgch g em‑mashchamdam ha wehm e gegosid g pi ap hemajkam, chum hems g lial t‑kowlantdam?” ");
INSERT INTO oodNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","D g Jesus am i ha kaiok hab kaij ab ha wui, “Idam pi ap hemajkam o s‑e doꞌibiamk hab masma mat g kokꞌodam wo s‑e doajidam. Hegam mat hab wo e elidad mo s‑apꞌe at pi wo tatchua g mahkai. ");
INSERT INTO oodNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pi ant hab ahgk ia jiwia jewed dahm manis wo ha doꞌibia hegam mo pi e doꞌibiamk. Neh, an o oꞌohanas mash wa hab kaij g Jiosh: S‑ap am hab wua g iagchulida ab ni‑wui. K wabshaba baꞌich d i si haꞌichu mamt wo s‑hehemajimak. Pegih, am g wo s‑amichud mo haschu hab ahg ch hab kaij.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","D am haꞌi dada hegam mo ab si wecho e mashcham hegai John mo wa ha pahl wapkon k ab kakke g Jesus ch hab kaij, “Neh, muꞌikko ach pi t‑gegosid hab ahgch matt wo t‑hoꞌigeꞌidahu. K hegam Palasi hab waꞌap e wua. K eda haschu ahgch idam pi hab masma hab e wua mo ab si m‑wecho e mashcham?” ");
INSERT INTO oodNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","D hab kaij g Jesus ab ha wui, “Nat hig pi wo e gegos g wo ha hohntam naipijju mat eda heg am wo ha wehmajk? T am wo i e ai mat pi am hu wo ha wehmajk. T am hahawa pi wo e gegos. Pegih, bat wo wa e juh idam ni‑naipijju mant hekid pi ia hu wo ha wehmajk.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","D am hahawa chum ha tashogid g Jesus mat g wechij mashchama pi ap wo wehnad g heki hu himdag hab kaijch, “Pi at hedai g wechij ikuskaj wo shohsho g hekiuchij lihwa mat wo s‑e wia nat pi wo i dahiwua hegai wechij ikus k baꞌich wo i wantp g hekiuchij. ");
INSERT INTO oodNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","K hab waꞌap pi hab mahs machs am wo toa g wechij uhdwis wadag am hekiuchij haꞌichu elidag kostal ch ed nat pi wo wantsh g hekiuchij am i e ak. Kut wo e iawua g uhdwis wadag. Wechij uhdwis wadag at am wo e toa wechij kokstal ch ed mat wehs wo s‑ap e nuhkud.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","D am wabsh kia ha wehm neok g Jesus. Kud am hema jiwia g t‑hahaꞌichuga k ab i gei wui k hab kaij, “Ni‑chehiaga atp hems heki hu muh. Pt wabshaba ab wo i him k ab wo taht. T wo e chegito.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kud gam hu wehmaj hih g Jesus. Kuchd ahchim gam hu ep ha oi. ");
INSERT INTO oodNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kudki eda am hema haꞌichug g uwi mash gamai gohk ahid ab waꞌi mumku heg hekaj mo g ehꞌedaj jegwoni. Kuchd am hihim. Kudki ab i hih Jesus wui k ab taht g kahbaj hugidag ");
INSERT INTO oodNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","nash pi hab e elid matp hems an wabsh wo taht k wo doa. ");
INSERT INTO oodNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","D g Jesus am sikol i kekiwua k neidok hab ahg, “Pegih, ni‑uwiga, ab g si i e gewkad. Am apt wa doa napt pi ab i s‑ni‑wohoch.” Kud amjed gam hu s‑doa. ");
INSERT INTO oodNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","D amjed gam hu hih g Jesus k am i wah heg kih ed matsh g chehiagaj muh. Sh am si s‑nankosig g mumsigo ch shoanidam. ");
INSERT INTO oodNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sh hab kaij g Jesus ab ha wui, “Gam g hu wo i wuwhaki wehsijj. Heg o wa wepo ni‑wehhejed mo wabsh kohsh g chehia.” Kush wehsijj si s‑koꞌokam ash nash pi s‑mahch matsh muh. ");
INSERT INTO oodNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kumtsh am wabsh i chum ha wuwhas. Tsh g Jesus am i wah mo am woꞌo g chehia k ab bei nowij ab. Kutsh i wami. ");
INSERT INTO oodNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kum amjed an aꞌai wehsko aꞌagahim mat has e juh. ");
INSERT INTO oodNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kuchd am hu hebai ep hihim. D gohk pi neneadam oꞌodham ab i oi g Jesus k si s‑kaidam hab kaij, “Ab g si i s‑t‑hoꞌigeꞌid ahpi mapsh d t‑kownaligbad David amjedkam.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kuchd ged hu i wahp kih ch ed. D idam gohk pi neneadam am dada wui g Jesus. Kud heg ab ha kakke ch hab kaij, “Nam s‑wohochud mant wo ni‑nako mant wo em‑nench?” D hab kaij idam, “Heuꞌu, ab ach si m‑hiwig, s‑apꞌekam t‑kownalig.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kud g Jesus ab ha taht g ha‑wuhpui k hab kaij, “Am at hab wo e juh mam has i masma ab s‑wohochud.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kud wa woho ab bei g e‑nendag. D g Jesus ab si s‑gewkam ha ahgid, “Pi g am hedai wo shaꞌi ahgid ihda.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","D wabshaba am wabsh i chum dagito k gam hu hihim k am aꞌai i ahgahi wehsko anai ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","D am hahawa haꞌi ep dada g hemajkam Jesus wui am hema uꞌapadch mo pi ha neok nash pi jiawul an uꞌukch. D g Jesus gam hu wabsh chum i wuhshad g jiawul ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kud ha hekaj wabsh neo ihda oꞌodham. D wehsijj si e todsid k hab kaij, “Pi ach hekid haꞌichu hab shaꞌi masma neid am t‑shahgid.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kud wabshaba g Palasi hab kaij, “Jijawul ha‑geꞌejig o ab mahkch g gewkdag. Kuki heg hekaj e nakog ch ab i ha wuwhasid g jijawul.” ");
INSERT INTO oodNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Am achd hahawa hahasko oiopod ch am daiw wehs kihhim ch ed. Kud g Jesus am ha mashcham g hemajkam ha‑chechopi ed ch am ha ahgidahim g s‑kehg haꞌichu ahga ab amjed g Jiosh kownaltalig ch am ep ha dodajid g nahnko mahs kokꞌodam. ");
INSERT INTO oodNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","D muꞌi ab wui e chehm g hemajkam. Kudki g Jesus si i s‑ha hoꞌigeꞌel no pi si e kudut ch e shoꞌigchud hab sha masma mat g kakawal hab wo e wuad pi e nuhkudch. ");
INSERT INTO oodNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","D hab kaij g Jesus ab t‑wui, “Neh, muꞌij o hegam mo e nahtokch mat wo e doꞌibia. Kuch eda pi muꞌij ahchim mach am ha ahgidahim g doꞌibiadag ahga. Id o heg wa wepo mat hebai g ha‑hihka wo si geꞌejk. T g ha‑pionag pi wo muꞌijk. ");
INSERT INTO oodNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ab g wo si tahnid g Jiosh mat muꞌi wo i ha chuhcha mat am wo i ha ahgidahid g s‑kehg haꞌichu ahgaj ch ab wo i ha baꞌihamad hegam mo e nahtokch.” ");
INSERT INTO oodNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ab ad hahawa i t‑wai g Jesus ahchim mach ab si wecho t‑mashcham k ab t‑mah g gewkdag matt gam hu wo i ha wuwhas g jijawul ab ha amjed hegam mo an ha uꞌukch k wo ha dodaj g kokꞌodam. ");
INSERT INTO oodNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Dachd gamai gohk ahchim mach d si chuhchaij. Simon o d wehpegkam ch hab ep chehgig Peter. K g Simon shehpij hab waꞌap d Jesus kehsha ch hab chehgig Andrew. K haꞌi ep d James ch John ch d e‑wepngam. K g ha‑ohg hab chehgig Zebedee. ");
INSERT INTO oodNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","K haꞌi ep d Philip ch Bartholomew ch Thomas. Ni ahni hab waꞌap d kehshaj ch hab chehgig Matthew ch wa d ge lial ha kowlantdam. K hema d hegai James mo g ohgaj d Alphias. K hema hab chehgig Thaddaus. ");
INSERT INTO oodNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","K hema hab ep chehgig Simon ch d hema hegam mo tatchua matt ahchim Tutuligo hejel wo himchudad g t‑kownaltalig. K hema hab chehgig Judas Iscariot ch d ihda matki wo gagda g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","D g Jesus am hahawa i t‑shelini ahchim gamai gohk matt gm hu wo ahgachugad g haꞌichu ahgaj hab kaijch, “Pi g am hu wo hihim gawul mahs hemajkam ha wui ch Samaria hemajkam ha wui iaꞌi idani. ");
INSERT INTO oodNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Am amt wo waꞌi hihi hegam ha wui e‑wehm Tutuligo. Idam o hab sha masma mo g heb hu hihimkam kahwal. ");
INSERT INTO oodNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Am g wo hihim k id am wo i ha ahgidahi mat am wo i himch g Jiosh g e‑kownaltalig jewed dahm. ");
INSERT INTO oodNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mt wo ha dodaj g kokꞌodam k ab uhpam wo i ha chechegitoich hegam mat wabsh chum koi k g jijawul ab wo i ha wuwhas ha amjed hegam mo an uꞌukch k wo ha dodaj hegam mo kokꞌo heg hekaj mo g ha‑chuhkug wabsh muhkhim. Ab ant wabsh em‑mah ihda gewkdag. Kumt pi haꞌichu wo ha kowlantad am hab ha junidch. ");
INSERT INTO oodNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“K wabshaba ab d ha‑wuikam hegam mat ab wo em‑kaiha mat ab aigo wo i em‑wehmaj k wo em‑dagioꞌi. Mt heg hekaj ab wabsh wo e enigadadch ch wo hihi pi haꞌichu uꞌadch mams hekaj wo e dagioꞌi o ams wo ha namkid. T g Jiosh wo em‑nuhkud. Kumt pi wo uꞌad g cheowikud mamt hekaj wo e nuhkud. ");
INSERT INTO oodNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","14","“Mt am wo i wahp kihhim ch ed k an wo i ha gahghi hegam mat hedai s‑ap ab wo i em‑nei k ab ha wui hab wo chei, ‘Jiosh o ab em‑makiog g si geꞌe s‑ap tahhadkam.’ Kut am wo i em‑wahpkid k wo em‑dagioꞌi am hugkam mamt hekid gm hu baꞌich ep wo i hihi. Kutp hems hebai pi ap ab hu wo i em‑nei g kihkam. Kumt am wo si i shahmud g jewed ab e‑tahtad ab k hab wo ha chehgi mamt wo ha dagito. ");
INSERT INTO oodNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nt wo si shel em‑ahgi mat g Jiosh baꞌich i s‑koꞌokam wo ha namkid hegam mat pi ab hu wo kaiha ihda s‑kehg haꞌichu ahgaj matsh hi hegam hab ha juh pi ap hemajkam mash am kih Sodom ch Gomorra kihhimbad ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Neh, am amt wo oiopod ha shahgid g hemajkam. Kut haꞌi wo s‑ta ehbidamak am em‑wehhejed hab sha masma mo g sheshꞌe am ha wehhejed g kahwal. Mt wo si s‑e nenꞌoidad hab masma mo g ban ch wo si s‑hehemajimak hab masma mo g hohohi. ");
INSERT INTO oodNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ab o him g tash mamt an wo em‑uꞌu k wo em‑lodait k atp hems ep wo em‑gewitta am chechopi ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Am amt wo em‑lodai ha tahgio g hahaꞌichu ch kokownal heg hekaj mam ab ni‑hiwig. Kumt wo s‑ni‑mahch k ah am ha tahgio ch am ha tahgio g gawul mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pi g wo shaꞌi e kudut ab amjed mamt has masma e wehhejed wo neo. ");
INSERT INTO oodNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Hekia S‑apꞌekam Gewkdag at wo em‑ahgi mamt has wo chei. ");
INSERT INTO oodNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Hahaꞌichu at wo em‑kokda. Kut ab ha wui wo em‑gagda chum hems g em‑wepnag o g em‑jehj o g em‑aꞌaliga. ");
INSERT INTO oodNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Muꞌi hemajkam at wo s‑em‑kehꞌidad ni‑hekaj. Kumt wo sha e nakog k wo gahi wuwha g e‑shoꞌigdag. T g Jiosh am wo i em‑wahpki e‑kihdag ed. ");
INSERT INTO oodNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Neh, mtp hems wo em‑shoꞌigch hasko. Pegih, mt wo ahhio heg amjed kihhim k gam hu baꞌich kihhim wui ep wo hihi. Nt wo shel em‑ahgi mant ep wo jiwia ahni Jiosh si Kehsha mamt koi wo ha chehmo g e‑wehm oꞌodham ha‑kihhim. ");
INSERT INTO oodNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“E mashchamdam o ab wabsh wecho hegai mo d ha mashchamdam ch heg hekaj wepo wo nako haꞌichu. T g pion hab waꞌap wepo haꞌichu wo nako g e‑ahmo. Kumt ahpim hab waꞌap ni‑wepo wo nako haꞌichu. Neh, bo ni‑aꞌaga haꞌi mani d ge Jiawul ch wahm s‑koꞌokam has wo em‑ahgad ahpim mam ab si ni‑wecho e mashcham. ");
INSERT INTO oodNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Pi g wo shaꞌi ha ehbidad g hemajkam nat pi wehs wo i e maꞌishpiꞌo mo haschu i e maꞌishch ch wehs wo s‑e mai mo haschu s‑e aꞌagchud. ");
INSERT INTO oodNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Si amt tasho wo i ahgahi wehsko mani haschu ab si hejel em‑ahgid. ");
INSERT INTO oodNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Pi g wo shaꞌi ha ehbidad hegam matp hedai wo chum s‑em‑kokdaim. Pi at wo e nako mas baꞌich i s‑koꞌokam has wo em‑juh em‑kokdak. Heg at waꞌi Jiosh wo e nako mat am wo em‑daꞌich Jiawul kih ed mamtp pi am hu wo wohog elidad. Kumt heg ab wo waꞌi si has elidad. ");
INSERT INTO oodNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","“K wabshaba g Jiosh si s‑hemajima ch pi tatchua mas wo s‑koꞌokam em‑juh. Am g wo oidahim mo chum hems g al uꞌuwhig s‑ap ha nuhkud. K eda chum alo pi haꞌichu namkig idam. Kum ahpim d si haꞌichu am tahgio. Jiosh o wehs haꞌichu s‑mahch ab em‑ab. Mt heg hekaj pi haꞌichu wo shaꞌi ehbidad ab wui e dagitokch. ");
INSERT INTO oodNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Neh, am amt wo s‑ni‑mahch k ah hemajkam ha tahgio mam d ni‑wohochuddam. Kunt ahni hab waꞌap wo s‑em‑mahch k ah am tahgio g ni‑ohg Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kutp wabshaba hedai pi wo ni‑mahch k ah am ha tahgio g hemajkam, nt ahni hab waꞌap pi wo mahch k ah am tahgio g ni‑ohg Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Pi g hab wo e elidad mat wo dodolimat g hemajkam mant ia jiwia. Ab at em‑wui wo gegokiwua hegam mo pi ab hu has ni‑elid. ");
INSERT INTO oodNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Wihpiop atp hems wo s‑kehꞌidad g e‑ohg ch g chetcha g e‑jeꞌe o g e‑kahkma jeꞌe. ");
INSERT INTO oodNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Em‑wehm kihkam atp hems d wo si em‑obgak. ");
INSERT INTO oodNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Pi at haꞌichu wo namkigk g em‑wohochudadag mamtp pi baꞌich wo i ni‑tatchua mam hi g e‑ohg ch e‑jeꞌe ch e‑aꞌaliga. ");
INSERT INTO oodNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mt gam hu wo dagito g hejel hab e elida k ahni hab ni‑elida hab wo junihid ni‑wehhejed e shoꞌigchudch. Heg at wo wa wepok mam ab mohto g kots ch ab ab wo e muhkid. Kut pi haꞌichu wo namkigk g em‑wohochudadag mamtp pi hab masma ab wo i ni‑oi. ");
INSERT INTO oodNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pi amt wo heki wua g e‑doakag mamtp wo hekaj am ni‑wehhejed. Heg at wo heki wua g e‑doakag matp hedai wo chum s‑daꞌad. ");
INSERT INTO oodNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Heg o wa wepo mo s‑ap ab ni‑neid ahni matp hedai ahpim s‑ap ab wo em‑neidad. K hab waꞌap s‑ap ab neid g Jiosh matp hedai s‑ap ab wo ni‑neidad. ");
INSERT INTO oodNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hegai mat hedai s‑ap ab wo i ha nei g ni‑chuhchai at ha wepo wo bei g s‑kehg mahkigdag. Kut hegai mat hedai s‑ap ab wo i nei g s‑apꞌekam oꞌodham heg wepo wo bei g s‑kehg mahkigdag. ");
INSERT INTO oodNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kut heg s‑wohom ab wo bei g s‑kehg e‑mahkigdag mat hedai chum hems g s‑hehpi shuhdagi ab wo hema ha wasibi idam al aꞌal am hema em‑wehhejed ahpim mam ab si ni‑wecho e mashcham.” ");
INSERT INTO oodNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Am ad i haꞌasa haꞌichu t‑shelini g Jesus ahchim gamai gohk e‑chuhchai k gam hu hahawa him k atsh an i ha mashcham k ha mihshmad mo an aꞌai mia kihhimag. ");
INSERT INTO oodNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kumd wa eda am wabsh kia kuhpch hegai John mad am i shonwuich g pahl wakona. Sh hegam mad ab si wecho e mashcham am ahgid mo haschu chikpan hab wua g Jesus. Kutsh am haꞌi ha cheha mat am wo hihim k ab wo kakke mas woho d Jiosh si Kehsha. Kudki am dada ");
INSERT INTO oodNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","k ab kakke g Jesus ch hab kaij, “Ab o t‑chehani g John matt ab wo m‑kakke maps woho d Jiosh si Kehsha aha nat ab hahawa hema wo i wuhsh mat d wo hegaik.” ");
INSERT INTO oodNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","D eda g Jesus am ahg g e‑kehg haꞌichu e‑ahga ch ha dodajid g kokꞌodam ch hab hahawa kaij ab ha wui hegam John chuhchai, “Am g uhpam wo hihim k wo ahgi g John mam haschu i kah ch haschu i neid. ");
INSERT INTO oodNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ha ani dodajid g pi ha dodajidam kokꞌodam ch pi neneadam ch pi hihimidkam ch pi chechkaidkam ch ha chechegitoichud g koꞌi ch am ha ahgid g shoꞌigkam mat g Jiosh wo ha doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","T g Jiosh ab wo s‑em‑hoꞌigeꞌidad mamtp hedai ab wabsh wo ni‑hiwgad.” ");
INSERT INTO oodNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Neh, d amjed gam hu uhpam hihi. D g Jesus am haꞌichu ha ahgid g hemajkam ab amjed g John ch hab kaij, “Neh, am amt wa hihim k ab kaiha g John. K wa eda am oimmelhim pi apkokam jewed ch ed. Kumt pi woho am hu wo i wuwha wui matp d wabsh s‑pehegi oꞌodham ch am gawul wo wuad g e‑neꞌoki. Pi o an aꞌai e wanchkwua g John. ");
INSERT INTO oodNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kumt pi hema s‑neidam mo s‑kakaisim e enigadadch. Hegam mo hab masma e enigadadch o si s‑kakaisim kih. ");
INSERT INTO oodNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Neh, heg amt s‑kaim haꞌichu i tashogiddam k heg wa woho kah. K g John am baꞌich haꞌichu k ed ep kehk. ");
INSERT INTO oodNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Heg o hab ahg g Jiosh ch hab kaij: Am ant wo hema i maskogi mat am wo i ha apꞌech g hemajkam am wehhejed g si ni‑Kehsha jiwhiadag am jewed dahm. Neh, bash kaij g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kunt wo em‑ahgi mo g John wehs hemajkam ha baꞌich d i si s‑has haꞌichu. T wabshaba am wo i e chehgi g Jiosh kownaltalig id dahm jewed. T hahawa chum hems g si pi haꞌichukam Jiosh ab hiwigdam baꞌich d wo i s‑has haꞌichuk mo hegai John. ");
INSERT INTO oodNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Muꞌi hemajkam, chum wa g pi ap hemajkam, o am i wahpk Jiosh kownaltalig ed ab i amjed mat g John ab i ahgahi g haꞌichu e‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Wehsijj g kekelibad Jiosh haꞌichu i tashogiddam o am ahgachug mat wo e chehgi g Jiosh kownaltalig. K hegai t‑chehanig mat g Mosesbad ab bei Jiosh t amjed hab waꞌap tashogid mat wo e chehgi. ");
INSERT INTO oodNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Neh, heki ash hu si ha mihshmad hegai kelibad Jiosh haꞌichu i tashogiddam mash hab chehgig Elijah. K g Jiosh oꞌohana hab chuꞌig matsh hema ep wo i wuhshani k hab wo masmak mash wa hegai. Pegih, ihda John o d hegai mat an wo i wuhsh. ");
INSERT INTO oodNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Neh, am g wo s‑ap i aꞌamichud ihda.” ");
INSERT INTO oodNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","D hab ep kaij g Jesus, “Hegam mat pi ab hu wohog el g John k pi ab hu ni‑bei o hab masma pi ta wepoma mo g aꞌal. Neh, tp hems am wo chichwid g aꞌal ch hab wo ha ah, ");
INSERT INTO oodNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Am att em‑gehged g e hohontam ha‑piastakaj. Kumt pi e waila. Am att nei g muhki neꞌi. Kumt pi shaꞌi shoshani.’ ");
INSERT INTO oodNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Id ani hab ahg mat g John ab i wuhshani k pi ihꞌe g nawait ch muꞌikko pi e gegosid e hoꞌigeꞌidahunch Jiosh wui. K muꞌijj hab kaij mo g jiawul an uꞌukch g chegitoidaj. ");
INSERT INTO oodNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nt ahni ia jiwia Jiosh si Kehsha k wabsh chum hedai ha wehm ni‑gegosid. K muꞌijj hab kaij mani s‑banma ch s‑iꞌidag ch d ha‑nawoj g s‑ta kekeꞌidamakam lial ha kowlantdam ch hegam mo pi ap oid g t‑chehanig. Neh, bo masma pi ta wepoma ch im hu hab wabsh i juh g Jiosh amichudadag. K wabshaba hegam mo ab s‑wohochud g wohokam am chehgidch mo d wohokam.” ");
INSERT INTO oodNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Muꞌi kihhim ed ad wa am hab junihim g s‑hasig haꞌichu g Jesus. D eda muꞌijj pi gam hu s‑ohhod g pi ap e‑chegitoi ab kahk. D g Jesus si s‑ha kehꞌid ");
INSERT INTO oodNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","22","ch ab kaij, “Muꞌi s‑hasig haꞌichu ant am hab juh Korasin ch Bethsaida kihhim ch ed. Kutki eda muijj amai pi ab hu ni‑wohochud k heg hekaj ab wo bei g s‑koꞌok e‑namkidadag geꞌe lodaita tash ch ed. Hegam mo am kih Tyre ch Sidon t am ch pi geꞌe mahch ab amjed g Jiosh at pi am hu hugkam wo bei g s‑koꞌok e‑namkidadag. Tp hems ab wo i e shoꞌigchud k gam hu wo s‑ohhod g pi ap e‑chegitoi matp wo nei ihda s‑hasig haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum t am hemajkam o ab si e haschud. T wabshaba g Jiosh gam hu wo shul Jiawul kih ed. Hegam mash wa am kih Sodombad t am at gam hu wo s‑ohhod g pi ap e‑chegitoi matp wo nei ihda s‑hasig haꞌichu. Kut pi wo chum padch g ha‑kihhim. ");
INSERT INTO oodNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Idam at pi am hu hugkam wo bei g s‑koꞌok e‑namkidadag mat g Capernaum t am hemajkam mat hekid wo e ai g geꞌe lodaita.” ");
INSERT INTO oodNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","D g Jesus am hahawa e hoꞌigeꞌidahun k hab kaij, “Ni‑ohg Jiosh, dap kownal wehs haꞌichu dahm. K hab d m‑elida mat pi hedai wo e nako mas hejel wo s‑amich g haꞌichu m‑ahga. E o ehstokch am ha wehhejed g s‑chu aꞌamichuddam ch haꞌichu s‑mahchim. Kup wabshaba am ha chehgid idam mo haꞌichu s‑mahchimk hab masma mo g aꞌal. Ni heg hekaj ab si m‑hoꞌigeꞌid.” ");
INSERT INTO oodNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","D hab ep kaij ab ha wui g hemajkam, “Ni‑ohg at wehs haꞌichu ab ni‑mah. Pi o hedai s‑ni‑mahch ch heg waꞌi ni‑ohg s‑ni‑mahch. K pi hedai mahch g ni‑ohg. Ni ahni waꞌi s‑mahch ch hegam ehp mani hedai i ha wui tashogid. ");
INSERT INTO oodNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ab g wo i e dagito ni‑wui wehsijj ahpim mam d gewpkokam. Kunt ahni ab wo i em‑mah g ulinihogig. ");
INSERT INTO oodNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Pi o hasig g ni‑himdag ch pi wechima wo i em‑mohtoꞌi haꞌichu. Si ani s‑hemajima ch ab wabsh ni‑shoꞌigchud. Kumt ab ni‑amjed wo s‑mahch k wo e ulinihogidad. Hegai mant ab heheꞌejel wo em‑mohtoꞌi at wo s‑hawkk nant pi am wo i em‑wehmajk hab sha masma matt wo t‑makodadch g yehwakaj.” Neh, bo kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kuchd am hu hebai hihim t‑mihshmda tash ed. K am eshas g pilkani wohg huhugid an. Kutt bihugk k hekaj ab ha wohni g pilkani ch i mohon ch koꞌa. ");
INSERT INTO oodNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kudki t‑neid hegam Palasi ch hab kaij ab Jesus wui, “Nehꞌe, melchkwua o g t‑chehanig mo id hab wua mihshmda tash ch ed.” ");
INSERT INTO oodNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","D g Jesus hab kaij ab ha wui, “Bo wabsh masma hab e wua matsh wa g Davidbad. Pi amtki chegitoi matsh heg has e juh am si i bihugimk. Bo chuꞌig g Jiosh oꞌohana ");
INSERT INTO oodNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","matsh am i wah geꞌe cheopi ch ed k am ui g pahn k huh hegam ha wehm mash am wehmaj. K d hegai pahn mo am e toꞌaw k ch hegam d waꞌi ha‑wuikam papal. T eda hemho wa am hab e juh. K heg hekaj am wa s‑apꞌe. ");
INSERT INTO oodNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Am g ep wo oidahim mo g papal am hab junihim g e‑chikpan geꞌe cheopi ch ed mihshmda tash ed. K eda g Jiosh pi ha mohtoꞌid g chuꞌijig no pi hemho wa am hab junihim g e‑chikpan geꞌe cheopi ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kuni ahni baꞌich d i si haꞌichu mo g geꞌe cheopi. ");
INSERT INTO oodNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“An o oꞌohadag mo hab kaij g Jiosh: S‑ap am hab wua g iagchulida ab ni‑wui. K wabshaba baꞌich d i si haꞌichu mamt wo s‑hehemajimak. Neh, pi amt ab hu wo ha mohtoꞌi g chuꞌijig hegam mo pi d chuꞌijkam mamtp woho wo s‑amichudad ihda. ");
INSERT INTO oodNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pi am amichud mani ahni d Jiosh si Kehsha ch gewkdag am dahm g mihshmda tash.” ");
INSERT INTO oodNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","D am ha dagito g Jesus. Kuchd gam hu hihi hema wui g cheopi. ");
INSERT INTO oodNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","D am hema daha g oꞌodham mad g nowij mahnikodag. D am haꞌi g oꞌodham ab haꞌichu s‑abchudamk g Jesus ch ab kakke, “No hiwgidas am t‑chehanig ed mamt wo ha doaj mihshmda tash ed?” ");
INSERT INTO oodNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","D hab kaij g Jesus ab ha wui, “Matp hems hema g em‑kahwaliga am wo gei wag ch ed mihshmda tash ed. Namt hig pi wo chikpan k wo i wuhshad? ");
INSERT INTO oodNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Oꞌodham o baꞌich d i si haꞌichu mo g kahwal. Pegih, k g t‑chehanig am t‑hiwgid matt am hema wo i wehmt mihshmda tash ed.” ");
INSERT INTO oodNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Neh, bad kaij ch hab hahawa ahg g mahnikokam, “Ab g si i shelin g e‑nowi.” Kud am wabsh i chum shelin k am waꞌi hekaj apꞌet. ");
INSERT INTO oodNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","D amjed gam hu hihi g Palasi k e wehm aꞌaga mat has hig masma wo mua g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","D am i kah g Jesus mash am s‑muꞌamk k gam hu hih ab amjed amai. Kud muꞌi hemajkam am i oi. D wehs ha dodaj g kokꞌodam ");
INSERT INTO oodNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ab si ha chehanich mat pi hedai haꞌichu wo ahgidad ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Neh, bad wa masma hab e juh hegai matki g Isaiabad heki hu waꞌi oꞌoha matsh hab wo e juh. Oꞌohanaj o hab chuꞌig mash g Jiosh an aꞌaga g si e‑kehsha ch hab kaij: ");
INSERT INTO oodNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Id o d si ni‑Kehsha mat d wo ni‑pionagk. Ab ani si tatchua. K si ni‑tatchui oidch hab masma. Ab ant wo mah g Hekia S‑apꞌekam ni‑Gewkdag. Kut am wo ha ahgi g wehs hemajkam mant s‑ap wo ha aꞌappe. ");
INSERT INTO oodNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pi at wo ha neꞌowinad ch pi wo hihnkad ch pi wo s‑kaidam amogad am kahya ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","T wo ha doꞌibia hegam mat chum alo pi wo e nako hab masma mamtp hems ahpim wo doꞌibia g e‑eꞌes mo i gehsim. Am at wo ha gewkadch am hugkam mat wo gewito g pi apꞌekam. ");
INSERT INTO oodNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","T wehs nahnko mahs hemajkam ab ab wo i e gewpkai. ");
INSERT INTO oodNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","D haꞌi g hemajkam am hema uꞌapa g oꞌodham Jesus wui. Kudki id pi nead ch pi ha neok nadki pi g jiawul an uꞌukch. D g Jesus doaj ihda oꞌodham. D hahawa e nako mad neok k ep haꞌichu neid. ");
INSERT INTO oodNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","D g muꞌi hemajkam ab si has i el ihda k hab kaij, “Shahag wepo mo id d hegai Davidbad amjedkam mach ab nenida.” ");
INSERT INTO oodNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","D am i ha kah hegam Palasi k hab kaij, “Moki g jijawul ha‑geꞌejig ab mahkch g gewkdag. Kuki heg hekaj gam hu hab i ha wua g jijawul ab ha amjed hegam mo an ha uꞌukch.” ");
INSERT INTO oodNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","D g Jesus s‑mahch mo haschu am chegito ch hab kaij ab ha wui, “S‑mahch am mat g oꞌodham wo padch g hejel e‑jewedga o g hejel e‑kihhim mat ab aꞌai wo e cheggia. T g e‑wehm kihkam hab waꞌap wo padch g hejel e‑kihdag mat ab aꞌai wo e cheggia. ");
INSERT INTO oodNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pegih, t has hig masma g ge Jiawul pi wo padch g hejel e‑kownaltalig matp ab wo sha ni‑mah g gewkdag mant am wo i ha wuwhas g piongaj. ");
INSERT INTO oodNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Neh, hegam mo ab si em‑wecho e mashcham o hab waꞌap i ha wuwhasid g jijawul. Kum eda pi hab masma hab ha elid mo g Jiawul ab ha mahkch g gewkdag. Pegih, id o am wohokamchud mo pi woho hegai mam hab chum elid. ");
INSERT INTO oodNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Hekia S‑apꞌekam Gewkdag o ab ni‑mahkch ihda gewkdag mani hekaj gam hu hab i ha wua g jijawul. K id am wohokamchud mat heki hu in i wuhsh g Jiosh kownaltalig em‑shahgid. ");
INSERT INTO oodNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Neh, wohppoꞌid ani g ge Jiawul hegam mo an ha uꞌukch. Kum s‑mahch mat pi hedai wo e nako mas am hu wabsh wo wah hema kih ed mat wo s‑haꞌahamak k am wo ui g enigaj, heg hi wa matp wehpeg wo wulsh. ");
INSERT INTO oodNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Hegai matp hedai pi ab hu wo i ni‑wehmajk o ab ni‑wui kehk ch wabsh ha gantan hegam mani s‑ha doꞌibiamk. ");
INSERT INTO oodNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Wehs o gam hu hab i junihog g pi ap ha‑chuꞌijig g Jiosh. K wabshaba si geꞌej g em‑chuꞌijig mamtp ab wo has ah g Hekia S‑apꞌekam Gewkdag. T g Jiosh pi hekid gam hu hab wo i juh. ");
INSERT INTO oodNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Im at hu hab wo i juh g Jiosh g chuꞌijigaj hegai mat ab wo has ni‑ah ahni Jiosh si Kehsha k wabshaba pi hekid gam hu hab wo i juh g chuꞌijigaj hegai mat wo has ah g Hekia S‑apꞌekam Gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mt wo s‑mai mas hedai d s‑apꞌekam oꞌodham hab masma mamt wo s‑mai mas s‑kehgaj g bahidkam uhs. S‑kehg uhs at wo s‑kehg bahidagt. T g pi kehg uhs wo pi kehg bahidagt. ");
INSERT INTO oodNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ahpim Palasi am hab sha masma mam d kohkꞌoi ch pi wo shaꞌi e nako mams s‑kehg haꞌichu hab wo chei nam pi d pi apꞌekam ch hemho wa am hab wo chei mo haschu am hab i chuꞌig em‑ihbdag ed. ");
INSERT INTO oodNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","S‑kehg haꞌichu o am hab chuꞌig ihbdaj ed g s‑apꞌekam oꞌodham. Kut heg s‑kehg haꞌichu hab wo kaijjid. K pi kehg haꞌichu am hab chuꞌig ihbdaj ed g pi apꞌekam oꞌodham. Kut heg pi kehg haꞌichu hab wo kaijjid. ");
INSERT INTO oodNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","“Id ant hab wo chei mat hemho wa wehs haꞌichu am wo mahsko e wua lodaita tash ch ed mam haschu has i kaij id dahm jewed. Jiosh at wo hekaj g hejel em‑neꞌoki mat wo em‑lodai, chum hems g s‑pehegi em‑neꞌoki.” ");
INSERT INTO oodNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","D am haꞌi haꞌichug g chehanig t‑mashchamdam ch Palasi ch hab ahg g Jesus, “Ha mashchamdam, ab g t‑chehgid g s‑hasig haꞌichukaj maptp woho d Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","D hab kaij g Jesus, “Si o hig woho pi apꞌe ch mehk ab amjed g Jiosh hegam mat pi ab hu wo ni‑hiwgam k hoꞌip nei g s‑hasig haꞌichu. Heg ant ab wo waꞌi ha chehgi mant am oidk hab wo ni‑juh hegai Jiosh haꞌichu i tashogiddam mash hab chehgig Jonah. ");
INSERT INTO oodNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Id ash wa waik tash oidam am haꞌichug geꞌe watopi wohk ed. Neh, nt hab wa masma waik tash oidam am wo kahchk hihaꞌini ch ed ahni Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Jonabad ash wa am ha ahgid g Ninevah t am hemajkam g Jiosh haꞌichu ahga. Kutsh wa gam hu s‑ohhod g pi ap e‑chegitoi k hab pi ab hu wo e chuꞌijigch geꞌe lodaita tash ch ed. Ni ahni baꞌich d i si haꞌichu mo g Jonabad. Kum eda pi ab hu ni‑kaiham ch heg hekaj ab wo motoig g chuꞌijig lodaita tash ed. ");
INSERT INTO oodNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Mehkjed atsh ab i hih g uwi kownal ab Sheba jewed t amjed matsh ab wo kaiha g Solomonbad haꞌichu mahchig. Ni ahni baꞌich d i si haꞌichu mo g Solomonbad. Kum eda pi ab hu ni‑kaiham ch heg hekaj ab wo motoig g chuꞌijig lodaita tash ed.” ");
INSERT INTO oodNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kud hab ep kaij g Jesus, “Matp hems g jiawul an wo hema uꞌukch g oꞌodham k wabsh wo dagito mat am hebai ep wo e ul. Kut hegai oꞌodham wo i chum kegch g e‑doakag. T wabshaba g jiawul pi hebai wo chehg. ");
INSERT INTO oodNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","K hekaj hab wo i e ah, ‘Mo hig woho d ni‑kih hegai oꞌodham. Nt hig am uhpam wo hih wui.’ Kut wa woho am wo uhpam him k wo cheh mo am wabsh jeg ch si kegchudas ch hehosimhunas. ");
INSERT INTO oodNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","T am haha wo him k wewaꞌak ep wo ha uꞌapa g jijawul. T idam baꞌich wo i pi apꞌek ch am wehmaj wo i chiwia. T ihda oꞌodham baꞌich wo i pi apꞌek mo wa ga hu i heki hu. Neh, bat wa masma hab wo e juh hegam mat pi gam hu wo s‑ohhod g pi ap e‑chegitoi.” ");
INSERT INTO oodNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Am ad wabsh kia ha wui neok g hemajkam g Jesus. Kud am haha wabsh dada g jeꞌej ch wepngaj s‑neidamk. D wabshaba si muꞌij g hemajkam an wehgaj. Kud heg hekaj gam hu wabsh mehk gegok. ");
INSERT INTO oodNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","D hema hegam mo an wehgaj gegok g Jesus hab kaij ab wui, “M‑jeꞌe ch m‑wepnag ash am hu gegok ch s‑m‑neidamk.” ");
INSERT INTO oodNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","D g Jesus hab ahg, “Neh, idam mo ab ni‑kaiham o heg wa wepo mo d ni‑jeꞌe ch ni‑wepnag. ");
INSERT INTO oodNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Hegam mat hab wo junihid g ni‑ohg Jiosh tatchui o hab masma mo d ni‑wepnag ch ni‑jeꞌe.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Heg waꞌi tash ed achd gam hu hihi Galilee Kahchki wui. D am i chum dahiwua g Jesus mat wo t‑mashcha. ");
INSERT INTO oodNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kud wabshaba shaꞌi muꞌi hemajkam an e hemapai wehgaj. D heg hekaj gan hu i chesh g Jesus wahlko ch ed k an dahiwua k amjed ha mashcham. D g hemajkam an gegok shuhdagi koa an ch amjed ab kaiham. ");
INSERT INTO oodNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kud muꞌi haꞌichu ha tashogid g wepogida ahgakaj ab amjed g Jiosh kownaltalig. Id o d haꞌichu ahgaj mo hab kaij: “Am ant heꞌes wo i em‑tashogi g Jiosh kownaltalig wepogidch mat hema an i chum gantad g e‑kaichka e‑oid ed. ");
INSERT INTO oodNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","T haꞌi gan hu shul wohg ch ed. T g uꞌuwhig am dada k koꞌito. ");
INSERT INTO oodNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","T haꞌi gan hu shul waw t ab mo pi geꞌej g jewed k ab ha hekaj hi wa chum i wuhsh no pi pi an hu juhk g jewed. ");
INSERT INTO oodNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","T ab i chesh g tash. Kut wabsh gaksh no ge mehk tatk. ");
INSERT INTO oodNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","T haꞌi gan hu shul shaꞌi ch ed. Kut g shaꞌi ab i geꞌege k ha kokda g haꞌichu esha. ");
INSERT INTO oodNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","T wabshaba hegam mat an s‑ap shul moihuna ch ed an wuhshani k muꞌi ab kait. Haꞌi at siant ab kait ch haꞌi chuhdpo wehst‑mahm ch haꞌi waikko wehst‑mahm.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kud hab hahawa ep kaij g Jesus, “Neh, am g wo s‑ap i aꞌamichud ihda.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","D am hahawa i e hejelko. Kuchd am wui hihim k ab kakke mas haschu ahgch pi ta amichudam ha mashcham g haꞌichu wepogidakaj. ");
INSERT INTO oodNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","D hab kaij, “Nt wo em‑ahgi mo has d ahga no pi g Jiosh em‑hiwgid mamt wo s‑mai mo haschu hemu am maskogid ab amjed g e‑kownaltalig. Ni wabshaba heg waꞌi ha ahgid haꞌichu wepogida ahga hegam mo pi ab hu wohochudamk. T hab pi wo amich haꞌichu ab amjed g Jiosh kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Hegam mat s‑ap wo hekaj g e‑apꞌedag at baꞌich ep wo i nei. T hegam mat pi ap wo hekaj wabsh wo heb hu wua. ");
INSERT INTO oodNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Heg ani hekaj g haꞌichu wepogidakaj haꞌichu ha ahgid: Mat pi wo amich, chum as wo haꞌichu neid k wo haꞌichu kah ");
INSERT INTO oodNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","K hekaj am wohokamchud hegai mo an hab chuꞌig Isaiabad oꞌohana ed mash wa hab kaij Jiosh. Bo chuꞌig: Chum am hekid ab kah g haꞌichu ni‑ahga ch ab neidchug g ni‑apꞌechuda ch wabsh pi amichud ");
INSERT INTO oodNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","no pi g em‑chegitoidag wabsh s‑kohmagi. Heg o wa wepo mamt am si ha kuhkp g e‑wuhpui ch e‑nahnk mamt pi wo neid k pi wo kah k pi wo amich nam pi pi e nohnogidamk ab ni‑wui. Kunt heg hekaj pi am hu wo i em‑apꞌech. Neh, bo chuꞌi g g Jiosh oꞌohana. ");
INSERT INTO oodNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kum eda ahpim pi hab shaꞌi mahs mo hegam mash pi amichud. Jiosh o ab s‑em‑hoꞌigeꞌid. Kum s‑ap s‑amichud mam haschu i neid ch kah. ");
INSERT INTO oodNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nt wo si shel em‑ahgi mo muꞌijj g kekelibad Jiosh haꞌichu i tashogiddam ch Jiosh hemajkamga chum si tatchua mat wo neid k wo kah ihda mam haschu i neid ch kah idani. K wa wabshaba pi hab mahs am ha wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Am ant haha wo em‑ahgi mani haschu chum em‑mashcham id hekaj haꞌichu ni‑ahga ab amjed g haꞌichu eshdam. Heg kaichka ani wepogid g Jiosh haꞌichu ahga. Id o am e gantan ha shahgid g hemajkam hab masma mo g haꞌichu kai. ");
INSERT INTO oodNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","K eda haꞌi pi amichud no pi g ha‑iꞌibdag s‑kawpk hab sha masma mo g wohg. K g Jiawul am wabsh s‑pehegi ha wohppoꞌid mo haschu i kah. ");
INSERT INTO oodNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“K haꞌi g ha‑iꞌibdag hab sha masma mo hebai pi geꞌej g jewed ab waw t ab. K idam si s‑hohhoꞌid ch kah g Jiosh haꞌichu ahga ");
INSERT INTO oodNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ch wabshaba pi wihnam ab hu uꞌukch ch am hi wa heꞌes wo i s‑chegitokahimch. T oi wa g kudutadag ab ha wui wo i hih. Kumt wo ha shoꞌigch id hekaj Jiosh haꞌichu ahga. T ha hekaj wabsh wo taꞌi i shul. ");
INSERT INTO oodNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“K haꞌi g ha‑iꞌibdag hab sha masma mo hebai s‑shaꞌig. K am ha shaꞌijidch g pihk ha‑elidadag ch s‑ha‑kaisdag. Kut pi haꞌichu wehhejed wo s‑kehgajk am Jiosh wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“K haꞌi g ha‑iꞌibdag s‑moik hab sha masma mo g moihuna. Idam at wo s‑amich g Jiosh haꞌichu ahga k am wo ahgachugad matp hems haꞌi siant ab ep wo ha baꞌiha k atp hems haꞌi chuhdpo wehst‑mahm k haꞌi g waikko wehst‑mahm ab ep wo ha baꞌiha.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus ad am hema ep ha ahgi g hemajkam g haꞌichu wepogida hab kaijch, “Am ant baꞌichu ep wo i em‑tashogi g Jiosh kownaltalig wepogidch mat hema ei g s‑kehg kai e‑oid ed. ");
INSERT INTO oodNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","T am hu hebai haha wabsh hema jiwia g obgaj chuhug ch ed mo wehsijj kohksh k g shaꞌi kai am ei ha shahgid g pilkani k gam hu hahawa ep hih. ");
INSERT INTO oodNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kut am i wuhsh g eꞌes k ab i mudadt. T am hahawa s‑masma i wuhsh g shaꞌi. ");
INSERT INTO oodNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“K hab kaij g eshdam pionag, ‘S hebai amjed i wuhsh g shaꞌi mapt wa eda t‑mah g s‑kehg kaichka.’ ");
INSERT INTO oodNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“K hab kaij am ha wui, ‘Ni‑obga at hab juh ihda.’ “K hab hahawa ep kaij g piongaj, ‘Natt am wo i ha huhpsh hegam shaꞌi?’ ");
INSERT INTO oodNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“K hab ha ahg, ‘Piaꞌa. Mt wo am hu wabsh g pilkani ha huhpsh. ");
INSERT INTO oodNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Am g wabsh wo hiwgid mat am e wehm wo wuwha. T ab wo e ai mat wo e hih. Kunt hab haha wo ha ahgi g hihkdam mat g shaꞌi wehpeg am wo ha huhpsh k am wo i hemapad k ged hu wo mehid k am haha wo i hemapai g pilkani k ged hu wo i baꞌiha.’ Neh, bo kaij g ha‑ahmo.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","D am hema ep ah g haꞌichu wepogida g Jesus hab kaijch, “Am ant heꞌes wo i em‑tashogi g Jiosh kownaltalig am wepogidch g haꞌichu kai. ");
INSERT INTO oodNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Neh, heg am eꞌesha mo al chumaj ch oi wa am wo wuhshani k haꞌas wo i geꞌeda mo g s‑ehheg uhs. Tp hems g uꞌuwhig an ab wo koksht. Pegih, t hab wa masma wo geꞌe i geꞌeda g Jiosh kownaltalig, chum as al chum am wo shonwua.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","D am hema ep ah g haꞌichu wepogida g Jesus hab kaijch, “Jiosh kownaltalig o hab waꞌap wepogidas mo g jewajidakud. Heg amt wo be k am wo wah wehnadk g chuꞌi k am heꞌes wo i dai. T wo chehmo g wahga mat wehs am wo i kopodka. Pegih, t g Jiosh kownaltalig hab wa masma wo chehmo g jewed.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus ad haschu i ha ahgid g hemajkam ch heg waꞌi hekaj haꞌichu wepogida ahga. ");
INSERT INTO oodNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Heki atki hu waꞌi oꞌoha g kelibad Jiosh haꞌichu i tashogiddam mat id am hab wo wa e juh. K hab chuꞌig g oꞌohanaj: Haꞌichu wepogida ant wo hekaj k am wo ha ahgi g hemajkam hegai mo pi hekid shaꞌi s‑e mahch ga hu i shohshonk amjed. ");
INSERT INTO oodNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","D g Jesus gam hu ha dagito g hemajkam k ged hu i wah kih ch ed. Kuchd am wehmaj hihim k ab hahawa kakke mas has d ahga hegai wepogida ahga ab amjed g shaꞌi mo am t‑ahgid. ");
INSERT INTO oodNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","D hab kaij, “Heg ani wepogidas mo g haꞌichu eshdam ahni Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","K g oidag d ihda jewed. K g s‑kehg kai d hegam mat wo e doꞌibia k am wo haꞌichugk Jiosh kownaltalig ed. K g ni‑obga d jijawul ha‑geꞌejig. K g eshaj d hegam mat pi wo e doꞌibia. Hihka tash o d lodaita tash. K hegam mat hab wo juh g hihka d anghil. ");
INSERT INTO oodNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Hegai shaꞌi mehidda o hab d ahga mat g pi ap hehemajkam gam hu wo i e shul jiawul kih ed mat hekid wo i e ai g lodaita tash. ");
INSERT INTO oodNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Am ant wo i ha chuhcha g anghil ahni Jiosh si Kehsha. Kut ab wo i hihi jewed wui k gam hu hab wo i juh hegai matp haschu am wo i em‑wua pi apꞌekam ch ed ");
INSERT INTO oodNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","k gam hu wo ha shul g pi ap chuꞌijkam mei ch ed. T idam wo si shoanid ch ga hu wabsh wo i si e kiꞌisch nat pi wo shaꞌi si s‑koꞌok haꞌichu nakogad. ");
INSERT INTO oodNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","T am hahawa wo si tondad g s‑apꞌekam hemajkam e‑ohg Jiosh kownaltalig ed. Neh, am g wo i aꞌamichud ihda ahpim mam kah!” ");
INSERT INTO oodNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","D am hema ep ah g Jesus g haꞌichu wepogida ahga hab kaijch, “Jiosh kownaltalig o heg wepogidas mo g s‑namkig haꞌichu mat am hema ehsto oidag ch ed k hahawa muh. T am hema haha wabsh chehg k am wabsh uhpam i maꞌishp k si s‑hehgig ch am i wehs gagda g haꞌichu e‑eniga k am hahawa uhpam ep him k wabsh wehs ha nolawt ihda oidag.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Kud hab ep kaij g Jesus, “Bamt masma wo s‑behim g Jiosh kownaltalig mat g s‑namkig hohodai nolawtdam wo s‑behim hegai mat wehs ha baꞌich wo i s‑kehgajk. Heg at wehs wo gagda g haꞌichu e‑eniga mat wo e nakog k wo ha nolawt hegai s‑namkigchu.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","D hab ep kaij g Jesus, “Am ant heꞌes wo i em‑tashogi g Jiosh kownaltalig am wepogidch g waptopi uꞌikud chuagia. Heg at am wo wua g waptopi ha uꞌudam shuhdagi ch ed. T am wo e baꞌiha g nahnko mahs waptopi. ");
INSERT INTO oodNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kut am wo i wanchkwua shuhdagi hugid an k am wo dahiwua k wo i ha gawulkad k hegam wo e toꞌi mo s‑kehgaj k g pi kehg waptopi gam hu wo nehnich. ");
INSERT INTO oodNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bat wo wa masmak mat hekid wo i e ai g lodaita tash. Anghil at am wo aꞌai hihim k am wo i ha gawulkai g pi apꞌekam hemajkam ");
INSERT INTO oodNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","k ged hu wo ha shul mei ch ed. T idam wo si shoanid ch ga hu wabsh wo i si e kiꞌishch nat pi wo shaꞌi si s‑koꞌok haꞌichu nakogad.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","D g Jesus ab hahawa t‑kakke, “Namt am wa s‑amich wehs ihda?” Kuchd hab kaij, “Heuꞌu.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","D hab hahawa ep kaij ab t‑wui, “Pegih, mt hahawa pi wabsh g Jiosh heki hu oꞌohana wo ha mashchamad ch wabshaba id wehnadk ep wo ha mashchamad wechij mashchama ab amjed g Jiosh kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","D g Jesus am i haꞌasa ah idam haꞌichu wepogida ahga. ");
INSERT INTO oodNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kuchd gam hu hihi Nazareth wui mo am d si kihkam. D g Jesus am haꞌichu ha mashcham ha‑cheopi ed. D si has elid hegam mo am kah ch ab wabsh aꞌai i e kakke, “Kus hebai mai wehs ihda amichudadag ch ihda s‑hasig haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","No hig pi woho d alidaj hegai t‑nawojbad mo d huk chikpandam? No hig pi g Mary d jeꞌej ch g wepngaj d James ch Joses ch Simon ch Jude. ");
INSERT INTO oodNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ia o wa kih g uꞌuwigaj. Kus hebai mai wehs ihda.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Neh, bad kaij ch wabsh pi haꞌichuch. D hab kaij g Jesus ab ha wui, “Jiosh haꞌichu i tashogiddam at chum hebai ab wo si has e elidad. T wabshaba g si kihꞌamkam oꞌodham ch wehmaj kihkam pi ab hu has wo elidad.” ");
INSERT INTO oodNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Neh, bad kaij ch pi muꞌi s‑hasig haꞌichu hab juh amai no pi pi ab hu wohochud idam mas d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","D eda am hahasko haꞌi d ha‑kokownalig g Tutuligo ch d giꞌik. D idam am hema d kownal Galilee chekshani ch ed ch hab chehgig Herod. Kumd eda wehsko aꞌaga g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kush id hab ha ahgid g e‑hahaꞌichuga, “Heg oki d hegai mo wa ha pahl wapkonahim ch hab chehgig John. Mua ant. Kutki wabshaba uhpam e chegito k hekaj hab e nakog mat hab wo juh g s‑hasig haꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod atsh wa an bei g John k wulshp k ged hu si kuh am wehhejed g e‑hohnig. Id ash hab chehgig Herodias ch ash d chum hohnigaj g Herod wehnag. Kush heg hab chehgig Philip. Tsh g Herod ehs g hohnigaj. ");
INSERT INTO oodNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sh amjed g John chum hekid hab a aꞌaga, “Mo pi shaꞌi hiwgidas maps g e‑wehnag hohnig wo ehs.” Kush g Herodias heg hekaj ahgid g Herod mat ged hu wo si kuh. ");
INSERT INTO oodNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tsh g Herod chum s‑muꞌam nash pi am ahg g pi ap ha‑chuꞌijig. K wabshaba g Tutuligo hab kaij mo d Jiosh haꞌichu i tashogiddam. Kush s‑ha ehbid ch hekaj pi mua. ");
INSERT INTO oodNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kutsh am i e ai g Herod mahsidag. Sh geꞌe piastchud. Tsh g Herodias uwi mad am e waila ha tahgio. Tsh g Herod si s‑hohhoꞌi ihda ");
INSERT INTO oodNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","k wehs ha kaichudch si s‑kaidam hab kaij mat hemho wa wo mah mat haschu ab wo i tai. ");
INSERT INTO oodNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sh g jeꞌej hab ahg mat hab wo chei mat ab wo mah g moꞌoj g John am hoas‑haꞌa ch ed dahshk. Tsh wa woho heg ab tai. ");
INSERT INTO oodNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kutsh si pi ap e taht g kownal. Sh wabshaba wehsijj kah mo has i kaij. Tsh heg hekaj pi e nako mas pi am hu hab wo juh ");
INSERT INTO oodNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","k am hahawa hema cheha g shondal mat an wo him k wo shonch g John moꞌo. ");
INSERT INTO oodNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tsh wa woho hab e juh k am hahawa uꞌapa g moꞌoj am hoas‑haꞌa ch ed dahshch k ab mah ihda uwi. Kut ihda gd hu hahawa epai mah g e‑jeꞌe. ");
INSERT INTO oodNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kutsh am hahawa dada hegam mad ab si wecho e mashcham g John k am bei g honshpadaj k ged hu chehg k am hahawa hihim k ged hu ahgid g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","D am i kah g Jesus mamt mua g John k am hahawa gam hu hejelko s‑himimk. Kuchd an dadhaiwua wahlko ch ed k gam hu aigo i chehchsh haꞌabjed. Dki wabshaba kah g hemajkam k gn hu i bihbij wabsh hihimk. ");
INSERT INTO oodNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kuchd am dada k am wabsh i chum huhud. D eda muꞌijj am heki hu haꞌichug g hemajkam. D g Jesus si i s‑ha hoꞌigeꞌid k ha dodaj g kokꞌodam. ");
INSERT INTO oodNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","D gam hu si i juh. Kuchd am wui dada g Jesus k hab chum ahg, “Neh, mehk at waꞌi juh. K eda ia hu wabsh si jegko. Am g ha ahgid g hemajkam mat gam hu wo hihi kihhim wui k wo ha nolawt g haꞌichu hugi mat wo huh.” ");
INSERT INTO oodNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","D hab kaij g Jesus ab t‑wui, “Ahpim amt wo haꞌichu ha mah mat wo huh.” ");
INSERT INTO oodNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kuchd hab kaij ab wui, “Pi ach geꞌe haꞌichu edgid. Al hetasp sismito ch gohk waptopi ach am toꞌakch.” ");
INSERT INTO oodNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","D hab hahawa ep kaij g Jesus, “Ab g wo i uꞌukaꞌi.” Kud am e uꞌapa. ");
INSERT INTO oodNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","D am hahawa ha cheha g hemajkam mat am wo dadhaiwua washai ch ed. Kud am dadhaiwua. Kud am ui ihda hetasp sismito ch gohk waptopi k am e dahm i nen k ab hoꞌigeꞌel g Jiosh k am hahawa hahain k ab t‑mah. Kuchd gam hu aꞌai ha mahkhi g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kuchd wehsijj hug k kokwod. Kuchd ahchim chuhchaij an hahawa i uꞌihim k uꞌapa g wihpiꞌidaj mat am huꞌi gamai gohk hoha wo ha shuhshud. ");
INSERT INTO oodNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kuchd am hu d i hetasp mihl chechoj ch muꞌijj g uꞌuwi ch aꞌal ehp. ");
INSERT INTO oodNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","D am hahawa t‑ahgi g Jesus matt gam hu aigo wo hihi. Tsh heg am wo wiꞌi k am wo ha ahgi g hemajkam mat gam hu wo hihi e‑kihki wui. Kuchd an i chehchsh wahlko ch ed k gam hu hihi. ");
INSERT INTO oodNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","D g Jesus am ha dagito g hemajkam. Kud gam hu himto. D am hahawa hejel i chesh kawulk dahm k am e hoꞌigeꞌidahu. D am i hud. D am wabsh kia hejel haꞌichug. ");
INSERT INTO oodNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","D g t‑wahlko gam hu si eda i cheka g shuhdagi. Kud g hewel ab si s‑gewkam meh ab t‑wui. D g shuhdagi toꞌotonk am si aꞌai hab t‑wua wehs s‑chuhugam oidk. ");
INSERT INTO oodNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kud koi mahsi. D ab hema him t‑wui an wabsh shuhdagi dahm. ");
INSERT INTO oodNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kuchd ab i neidok si s‑ehbeni ch si hihnk ch hab kaij mo d wabsh kokꞌoi. ");
INSERT INTO oodNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","D ab hahawa si t‑wui neok ch d Jesus ch hab kaij, “Pi g wo shaꞌi ni‑ehbenid. Dani ahni. Mt oi wo s‑ap e taht.” ");
INSERT INTO oodNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kud g Peter si s‑kaidam hab kaij ab wui, “Ni‑kownalig, maptp d wo ahpik ch ab wo i ni‑wai. Nt ab wo i hih m‑wui an wabsh shuhdagi dahm.” ");
INSERT INTO oodNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","D hab kaij g Jesus, “Oi g ab i hihm.” D wa woho ab i hud wahlko t‑amjed k am wui i hih shuhdagi dahm. ");
INSERT INTO oodNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","D wabshaba am wabsh si s‑gewkam hewed. D g Peter si s‑ehbenid k gam hu wabsh i wachumkahi shuhdagi ch ed k ab si e shoꞌigchud k hab kaij, “Ni‑kownalig, ni‑doꞌibiani.” ");
INSERT INTO oodNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","D ha hekaj am i wuhshad g Jesus k hab kaij ab wui, “Pi apki ab hu si ni‑hiwig.” ");
INSERT INTO oodNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","D ged hu hahawa e wehm i chehchsh wahlko ch ed. D am waꞌi hekaj huhug g hewel. ");
INSERT INTO oodNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kuchd ab hahawa si has elid ch ab ihm g Jesus ch hab kaij ab wui, “Woho apki d Jiosh alidag.” ");
INSERT INTO oodNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ga achd hu aigo i chehchsh k ab dada Gennesaret t am. ");
INSERT INTO oodNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kud g hemajkam s‑amich g Jesus k hekaj ab i ha wai g kokꞌodam wehsko an heg oidk chekshani. Md ha uꞌapa Jesus wui ");
INSERT INTO oodNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","k ab si e shoꞌigchud k ab ahgid mat chum hems wabsh g kahbaj hugidag an wo taht. Kud s‑ap ha doda mad hedai an i taht. ");
INSERT INTO oodNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","D am haꞌi dada g Palasi ch chehanig ha mashchamdam ab Jerusalem t amjed k ab kakke g Jesus hab kaijch, ");
INSERT INTO oodNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“K haschu ahgch g m‑pionag pi ab hu wohog elid g haꞌichu ha‑mashchamadag g kekelibad? Neh, e o gegosid pi am hu t‑himdag oidch ha wapkonk g e‑nohnhoi.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","D hab kaij g Jesus ab ha wui, “M ahpim haschu ahgch pi ab hu wohog elid g Jiosh chehanig ch wabsh g hejel e‑himdag am hab junihim? ");
INSERT INTO oodNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Id o d chehanigaj g Jiosh mo hab chuꞌig: Ab g si has wo i ha elidad g e‑ohg ch e‑jeꞌe, ch id ehp, Mat hemho wo wa e muhkid hegai mat hedai wo sha s‑koꞌokam has ah g e‑jehj. ");
INSERT INTO oodNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kum eda ahpim ha mashcham mat pi ab hu has wo ha elidad ch ab ha wui hab wo chei, ‘Mah ant g Jiosh hegai mat haschu ab d wo i chum em‑wuikamk.’ ");
INSERT INTO oodNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kum hab masma im hu hab wabsh i wua g Jiosh neꞌoki ch am ha mashcham hegai mo haschu d wabsh oꞌodham ha‑nahtoi. ");
INSERT INTO oodNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bam wabsh s‑e junimk mam ab has elid g Jiosh. Kuki wabshaba g Jiosh hab em‑ahg ch hab kaij ihda matki g Isaiabad an oꞌoha: ");
INSERT INTO oodNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Haꞌi idam mo d chum ni‑hemajkamga o hab kaij mo ab si has ni‑elid ch ab ni‑ihm. K wabshaba g ha‑iꞌibdag si s‑kawpk ch si mehk ab ni‑amjed. ");
INSERT INTO oodNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pi o shaꞌi wohom ab has ni‑elid no pi wabsh g hemajkam ha‑chehanig ha mashcham hab chum masma mo d ni‑chehanig.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","D g Jesus ab hahawa i ha wai g hemajkam k hab kaij ab ha wui, “Ab g wo ni‑kaiham k wo s‑amich. ");
INSERT INTO oodNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Pi at im hu hab wo i em‑juh g Jiosh heg hekaj mamt haschu wo huh k wabshaba im hu hab wo i em‑juh heg hekaj pi kehg em‑chegitoidag.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kuchd am dada wui ahchim k hab kaij, “Nap s‑mahch mat si e taht g Palasi heg hekaj map hab kaij?” ");
INSERT INTO oodNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","D hab kaij g Jesus, “Pi g has wo e tahtkkad ab ha amjed. Do chum em‑wanimeddam ch eda hab sha masma mo d pi neneadam ch chum ha wanimed g haꞌi ep pi neneadam ch atp hems am wabsh ha wehm wo i shul hiktani ch ed. Ni‑ohg Jiosh at gam hu hab wo i ha juh hab sha masma mamt wo huhpsh k gam hu wo nehnich g haꞌichu wuhshdag am e‑esha ed.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","D g Peter ab neok ch hab kaij, “Am g t‑ahgid maps haschu tashogid ch hab kaij mat pi im hu hab wo i t‑juh g Jiosh heg hekaj matt haschu wo huh.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","D hab kaij g Jesus ab t‑wui, “Kumt ahpim hab waꞌap pi koi shaꞌi amich hegai mani em‑ahgid. ");
INSERT INTO oodNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Pi at im hu hab wo i em‑juh ab amjed g Jiosh mamtp haschu wo huh. ");
INSERT INTO oodNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Heg at im hu hab wabsh wo i em‑juh ab amjed g Jiosh mat wo pi apꞌek g em‑chegitoi. ");
INSERT INTO oodNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Heg at hab wo em‑juh mamt hab wo juh g haꞌichu pi apꞌekam. Neh, mtp hems wo ha mua o wo ha ehs g ha‑wehm kihkam o hab wo juh g s‑tohntom haꞌichu o wo haꞌichu ha ehs o wo haꞌichu ha iattogi ab hema i ep amjed o wo pi ap neo. ");
INSERT INTO oodNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Id o d hegai mat im hu hab wo i em‑juh ab amjed g Jiosh. Pi at heg im hu hab wo i em‑juh mamt pi am hu ha‑chehanig oidk wo wapko g e‑nohnhoi k haha wo e gegos.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kuchd gam hu hahawa hihi Syria jewed wui k am miabi g Tyre ch Sidon kihhim. ");
INSERT INTO oodNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","D am hema d uwi ch pi d t‑wehm oꞌodham ch am t‑wui jiwia k hab kaij ab wui g Jesus, “S‑apꞌekam ni‑kownalig mapsh d Davidbad amjedkam, ab g si i s‑ni‑hoꞌigeꞌid. Ni‑chehiaga o g jiawul an uꞌukch ch si shoꞌigchud.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","D wabshaba g Jesus pi ab hu has shaꞌi kaij wui. Kuchd ab si ahgid mat hig wo cheha mat gam hu wo hih no pi an t‑oidahim ch si s‑nakosig. ");
INSERT INTO oodNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","D hab kaij g Jesus ab wui ihda uwi, “Heg o d waꞌi ni‑chikpan idani mant wo i ha wehmt g Tutuligo hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","D ab ha hekaj i gei wecho ihda uwi k hab kaij, “Am g hig i ni‑wehmt.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","D hab kaij g Jesus, “Heg at wo wa wepok mamt ab wo ha mah g gogogs g ha‑chechmait g aꞌal.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","D hab kaij hegai uwi, “Woho o wa. T wabshaba chum hems g gogogs am wo huh g aꞌal ha‑haꞌichu hugi hahainig. Kunt ahni hab wa masma wo si s‑ap ni‑taht mapt id am hab wo al i ni‑juni.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","D hab hahawa kaij g Jesus ab wui, “Neh, m‑neꞌoki o am chehgid map ab si ni‑hiwig. T heg hekaj am hab wo e juh ihda map ab ni‑tahni.” Kutsh am waꞌi hekaj doa hegai chehiagaj. ");
INSERT INTO oodNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Amjed achd gam hu hahawa ep hihi Galilee shuhdagi babsho. D g Jesus am i chesh kawulk dahm. ");
INSERT INTO oodNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kud muꞌijj am dada g hemajkam k am ha uꞌapa g pi hihimidkam ch pi neneadam ch pi neneokdan ch muꞌi nahnko mahs kokꞌodam. D g Jesus ha dodaj. ");
INSERT INTO oodNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kud si has i elid g hemajkam neidok mo neneok g mumio ch g pi hihimidkam oiopo ch g momjo hahawa ab wehsig ch g pi neneadam s‑ap haꞌichu neid. D wehsijj ab si has elid g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","D g Jesus ab hahawa i t‑waid k hab kaij, “Neh, waik tashkaj in o waꞌi t‑wehmaj idam hemajkam ch heki hu waꞌi pi haꞌichu huh. Ni s‑ha hoꞌigeꞌid. Tp hems haꞌi wo s‑e chuhugi matp gam hu wo sha hihi pi haꞌichu hugok.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kuchd hab kaij ab wui, “Kuchs hebai hig wo ui g haꞌichu hugi id eda tohono jewed matt hekaj wo ha gegos g haꞌakia hemajkam?” ");
INSERT INTO oodNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","D hab kaij g Jesus, “Heꞌekia at am i wih g sismito?” Chd hab kaij, “Al wewaꞌak sismito ch al heꞌekia chuꞌuchum waptopi.” ");
INSERT INTO oodNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","D g Jesus am hahawa ha chehani g hemajkam mat wo dadhaiwua. Kud am dadhaiwua. ");
INSERT INTO oodNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","D am ha ui hegam wewaꞌak sismito ch waptopi k ab hoꞌigeꞌel g Jiosh k am i hahain k ab t‑mah. Kuchd an i ha mahkhi g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","D wehsijj hug k oi wa hi si s‑kokwod chum as am hu hebai d giꞌik mihl chechoj ch muꞌi ehp mo d uꞌuwi ch aꞌal ch pi kuintas. Kuchd an hahawa i uꞌihi g wihpiꞌidaj mat am huꞌi wewaꞌak hoha wo ha shuhshud. ");
INSERT INTO oodNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","D g Jesus am hahawa ha ahgi g hemajkam mat gam hu wo hihi. Kuchd gan hu dadhaiwua wahlko ch ed k gam hu aigo i chehchsh Magadan chekshani am. ");
INSERT INTO oodNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","D am haꞌi dada g Palasi ch Sajusi k ab neꞌowin g Jesus ch ab chum si chehani mat am wo ha chehgi g si s‑hasig haꞌichu matp woho d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","D hab kaij g Jesus ab ha wui, “Neh, s‑mahch am mat has mahs tash ab wo himad ab wabsh neidch mas hebaijed hewed ch has mahs chewagi i wushke. Pegih, mt hab waꞌap wo chum s‑mahchk mo haschu has e junihog iaꞌi idani am neidch mo haschu hab e junihim.” ");
INSERT INTO oodNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","D hab ep kaij, “Si o hig woho pi apꞌe ch mehk ab amjed g Jiosh hegam mat pi ab hu wo ni‑hiwgam k hoꞌip nei g s‑hasig haꞌichu. Heg ant ab wo waꞌi ha chehgi mant am oidk hab wo ni‑juh hegai kelibad Jiosh haꞌichu i tashogiddam mash d Jonah.” Bad cheꞌiok k am ha dagito k gam hu hih. ");
INSERT INTO oodNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kuchd am gahi ep i shul wahlko ch ed k ga hu aigo dada k s‑mai machdki pi haꞌi uꞌuk g sismito. ");
INSERT INTO oodNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","D am waꞌi hekaj mad hab kaij g Jesus ab t‑wui, “Si g wo s‑e nenꞌoidk mat pi wo em‑cheawogi g ha‑jewajidakud hegam Palasi ch Sajusi.” ");
INSERT INTO oodNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kuchd am si aꞌaga ihda k hab kaij, “Heg oki hekaj hab kaij mattki pi haꞌi uꞌuk g sismito.” ");
INSERT INTO oodNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kudki s‑t‑amichud g Jesus ch hab kaij, “Pi amki koi amichud mani heꞌes edgid g gewkdag ch hekaj am aꞌaga mach pi ha sismitoga. ");
INSERT INTO oodNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Am am wa chum neid mant al hetasp sismitokaj ha gegos g hetasp mihl chechoj ch muꞌi ehp. Ms huꞌi pi chegito mamt heꞌekia i hoha an i ui g wihpiꞌidaj. ");
INSERT INTO oodNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kum am wa chum neid mant al wewaꞌak sismitokaj ha gegos g giꞌik mihl chechoj ch muꞌi ehp. Ms huꞌi pi chegito mamt heꞌekia i hoha an i ui g wihpiꞌidaj. ");
INSERT INTO oodNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pegih, mt wo chum s‑mahchk mani pi wabsh g haꞌichu hugi hab ahg ch hab kaij mamt wo s‑e nenꞌoidad ab amjed g Palasi ch Sajusi ha‑jewajidakud.” ");
INSERT INTO oodNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kuchd am hahawa i s‑amich moki pi heg hab ahg jewajidakud mo hekaj e pahnt ch oki heg hab ahg Palasi ch Sajusi ha‑mashchamadag. ");
INSERT INTO oodNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kuchd gam hu hahawa hihim k am i miabi g Cesaria Philippi kihhim. D g Jesus ab t‑kakke ch hab kaij, “Am g wo ni‑ahgid Dohꞌo ni‑elid g hemajkam?” ");
INSERT INTO oodNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kuchd hab kaij, “Haꞌijj o hab m‑elid map d hegai Johnbad mo wa chum t‑pahl wapkonahim ch haꞌijj hab kaij map d Elijabad o Jeremiabad o hema i ep kekelibad Jiosh haꞌichu i tashogiddam.” ");
INSERT INTO oodNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","D ab hahawa ep t‑kakke, “M ahpim hig hedai ni‑elid?” ");
INSERT INTO oodNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","D ihda Simon mamt hab hahawa chehch Peter hab kaij, “Dap Jiosh alidag ch d si Kehshaj g Jiosh,” ");
INSERT INTO oodNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","D hab kaij g Jesus, “Simon, Jiosh at si s‑m‑hoꞌigeꞌid k am m‑chehgi mani d si Kehshaj. Pi at wabsh g hemajkam am m‑chehgi. ");
INSERT INTO oodNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kupt ab i s‑wohoch g Jiosh k ab si ni‑hiwig. Nt heg hekaj hab wo m‑chehch Peter (Hodai). Neh, id ab waw ant am wo i kei g ni‑cheopiga. Bani ahgch hab kaij mat wehsijj hegam mat hab waꞌap ab wo si ni‑hiwgad at d wo ni‑hemajkamgak. Kut pi hedai wo shaꞌi e nako mas wo ha keshwua, chum hems g jijawul. ");
INSERT INTO oodNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kunt ab wo m‑mah g gewkdag mapt wo s‑mahch k ah g Jiosh haꞌichu ahga k hab wo yahwitpiꞌo g apꞌedag am ha wehhejed hegam mat ab wo s‑wohoch. Ab ant wo m‑mah g gewkdag mapt hab wo ah mo haschu shohbidas ch haschu hiwgidas am ha wehhejed hegam mat ab wo ni‑hiwgad.” ");
INSERT INTO oodNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Neh, bad kaij g Jesus ch ab hahawa si t‑chehani matt pi hedai wo ahgi mo heg d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","D am i amjed am hahawa si tasho t‑ahgi g Jesus k hab kaij, “Hemho wa ant am wo hih Jerusalem wui. Kut muꞌi wo ni‑shoꞌigch g geꞌeged ch uꞌugchu papal ch chehanig ha mashchamdam k am wo i ni‑dagito mant wo ni‑muhkid. T wabshaba am wo him k d wo i waik tashk amjed. Nt ab wo uhpam i wuhsh muhkig amjed.” Neh, bo kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","D g Peter im hu goꞌolko i be k ab si s‑gewkam neok wui hab kaijch, “Pi at woho wo shaꞌi hiwigi g Jiosh mamt hab wo m‑juh.” ");
INSERT INTO oodNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","D hab kaij g Jesus ab wui, “Pi g shaꞌi ni‑shohbid. Do wabsh hejel hab m‑elida ihda. Kup ab wui kehk g Jiosh hab elida hab masma mo g ge Jiawul.” ");
INSERT INTO oodNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","D hab hahawa ep kaij ab wehsijj t‑wui, “Mamtp am wo s‑oidam g niꞌhimdag k hemho wa gam hu wo dagito g hejel e‑tatchui k ahni ni‑tatchui hab wo junihid ni‑wehhejed e shoꞌigchudch. Heg at wo wa wepok mam ab mohto g kots ch ab ab wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pi amt wo heki wua g e‑doakag mamtp wo hekaj am ni‑wehhejed am ahgachugch g Jiosh haꞌichu ahga. Heg at wo heki wua g e‑doakag matp hedai wo chum s‑daꞌad. ");
INSERT INTO oodNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pi at haꞌichu wehhejed wo s‑kehgajk matp g oꞌodham wehs wo bei mo haschu i tatchua id dahm jewed k wabshaba pi wo e doꞌibia. Pi o an hu haꞌichug id dahm jewed mas heg hekaj wo e doꞌibia g oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jiosh at ab uhpam wo ni‑mah g si geꞌe gewkdag an e‑kihdag ed. Kunt heg hekaj si s‑tondam wo tondad ch ia ep wo jiwia jewed dahm. T muꞌi anghil wo i ni‑wehmajk. Kunt wehs wo ha namkid g hemajkam heg hekaj mo haschu hab i junihim. ");
INSERT INTO oodNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nt wo si shel em‑ahgi mamt haꞌijj an d wabsh wo kia dodakamk ch wo nei mant s‑gewkam am wo chehgi g ni‑kownaltalig em‑shahgid.” ");
INSERT INTO oodNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","D am d i chuhdp tash amjed. D g Jesus ab i ha wai g Peter ch James ch John. D am wehmaj ab i chehchsh hema uhgk doꞌag t ab k atsh gan hu dada doꞌag dahm. ");
INSERT INTO oodNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kutsh g Jesus am hahawa gawul e juh. Sh g wuhioshaj hab waꞌi masma tonod mo g tash ch g wehschugaj hab masma s‑tohta mo g tonlig. ");
INSERT INTO oodNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kutsh ab haha wabsh i e chehgi g Mosesbad ch Elijabad k am wehmaj neneok g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sh g Peter hab kaij ab wui g Jesus, “T‑kownalig, s‑apꞌe oki mach ia haꞌichug. Kutt ia waik wo ha chuhcha g al chechopi matt hekaj ab wo si has em‑el ahpi ch Mosesbad ch Elijabad maptp wo tatchuad.” ");
INSERT INTO oodNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Neh, sh am wabsh kia neok g Peter. Kutsh g si s‑mahs chewagi ab i wuhshani k ab ehka ha dahm. Tsh g Jiosh neꞌoki ab kaida chewagi t amjed k hab kaij, “Jesus o d si ni‑tatchuidch ni‑alidag. Heg amt ab wo si kaihamad.” ");
INSERT INTO oodNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kutsh si s‑ehbeni hegam Peter am i kahk g neꞌoki k am wabsh si kupal shul jewedo. ");
INSERT INTO oodNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tsh am hahawa jiwia g Jesus k an ha tahtam k hab kaij, “Gegokiwuio. Pi g wo shaꞌi e todsid.” ");
INSERT INTO oodNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tsh am hahawa i chum nenhog. Kush heg waꞌi Jesus hejel am kehk. Sh pi am hu haꞌichug hegam gohk. ");
INSERT INTO oodNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sh ab hahawa i huhudkhim doꞌag t amjed. Sh ab si ha chehani g Jesus ch hab kaij, “Pi g am hedai wo shaꞌi ahgid mamt haschu nei, nt hoꞌip kia uhpam i wuhsh ab muhkig amjed ahni Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kush hab kaij idam ab wui g Jesus, “Neh, bo chechꞌe hegam chehanig t‑mashchamdam matsh ia wehpeg wo e maskogi g Elijabad. Tsh g Jiosh si Kehsha ia haha wo e maskogi. Pegih, t haschu ahgk pi ia wehpeg m‑baꞌich e maskogi hegai Elijabad?” ");
INSERT INTO oodNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Sh hab kaij g Jesus, “Hema at woho wehpeg wo e maskogid k hab wo masmak mash wa g Elijabad ch wehs haꞌichu wo i apꞌech. ");
INSERT INTO oodNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kunt wo em‑ahgi mat wa woho heki hu jiwia. K Wabshaba muꞌijj pi mahch mo hedai wud ch ab wui hab wabsh juh g pi ap e‑tatchui. Pegih, k e aihim mat hab waꞌap wo ni‑juh k wo ni‑shoꞌigch ahni Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kutsh am hahawa i amich idam moki heg hab ahg John mat wa am i shonwuich g pahl wakona. ");
INSERT INTO oodNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","D eda muꞌi hemajkam am haꞌichug amai machd am wih. Kud am uhpam dada hegam Jesus. D ab hema i tonwua Jesus wui ");
INSERT INTO oodNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","k hab kaij, “Ab g si i s‑hoꞌigeꞌid g ni‑sulijga. Si o pi ap mumku ch hebai am wabsh s‑e chuchkagid ch muꞌikko am gegshe nahda ch ed o am shuhdagi ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kunt ia chum uꞌapa ha wui idam m‑chuhchai. T pi e nako mas wo doaj.” ");
INSERT INTO oodNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","D hab kaij g Jesus ab t‑wui, “Shoꞌo waꞌi pi geꞌej g em‑wohochudadag. M im hu hab wabsh i si e Juhkch ab ni‑amjed. Shahag wepo mant tash ia wo em‑wehmajkad ch wo em‑nakogad mat haha wo i geꞌeda.” Bad kaij g Jesus ch hab hahawa ahg hegai oꞌodham, “Ab g i bekaꞌi g e‑alidag.” ");
INSERT INTO oodNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","D ab hahawa i bei wui. D g Jesus am si s‑gewkam chehani g jiawul mat gam hu hab wo i e juh. Kud wa woho hab e juh. D am ha hekaj wabsh i doa g ali. ");
INSERT INTO oodNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kuchd ab hahawa hejelko kakke g Jesus machs haschu ahgk ahchim pi t‑nako matt gam hu hab wo i juh g jiawul. ");
INSERT INTO oodNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","D hab kaij g Jesus, “Heg amt hekaj pi e nako mam pi ab hu wohochud mat hab wo e juh. Nt wo si shel em‑ahgi mamt wo e nakog k wabsh chum haschu hab wo juh mamt hab wo chei s‑wohochudch mat hab wo e juh. Chum at hems g geꞌe doꞌag gan hu hab wo i kekiwua mamt wabsh wo ahgi s‑wohochudch mat hab wo e juh.  ");
INSERT INTO oodNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","T wabshaba ihda hab mahs haꞌichu hab waꞌi masma gm hu hab wo i juh mamt wo si e hoꞌigeꞌidahunad Jiosh wui pi haꞌichu koꞌadch.” ");
INSERT INTO oodNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Am achd wabsh kia oiopo Galilee chekshani ch ed. D hab kaij g Jesus ab t‑wui, “E o aihim mat wo ni‑bei hegam mo s‑ni‑kehꞌid k ab wo ni‑dagito ");
INSERT INTO oodNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","mant wo ni‑muhkid. T wabshaba am wo him k d wo i waik tashk amjed. Nt ab wo uhpam i wuhsh muhkig amjed.” Neh, kuchd wehsijj si pi ap t‑taht am i kaiok ihda. ");
INSERT INTO oodNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kuchd ged hu dada Capernaum t am. D am hema jiwia Peter wui hegam mo an hemapad g cheopi kowlanta k ab kakke ch hab kaij, “No ha namkid g cheopi kowlanta g em‑mashchamdam?” ");
INSERT INTO oodNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","D hab kaij g Peter, “Hemho wa,” K amjed ged hu i wah kih ch ed. D g Jesus ab ha hekaj kakke ch hab kaij, “Simon Peter, nap hab elid mat g kokownal ab wo haꞌichu ha kowlant hegam mo d ha wehm kihkam?” ");
INSERT INTO oodNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","D hab kaij g Peter, “Piaꞌa.” D hab ep kaij g Jesus, “Pegih, t heg hekaj pi haꞌichu wo ni‑kowlant g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ch wabshaba pi tatchua machs wo ha kudu idam hemajkam. Kupt heg hekaj am wo hih shuhdagi wui k am wo wua g waptopi hukshpakud. Kut g si wehpeg watopi mapt wo huksh g lial ab wo kamshchid mat wo ai hegai cheopi kowlanta an ni‑wehhejed ch ep m‑wehhejed. Pt am wo be k hekaj wo ha namkid.” ");
INSERT INTO oodNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kuchd ab kakke g Jesus ch hab kaij, “Doht d wo si s‑has haꞌichuk am Jiosh kownaltalig ed?” ");
INSERT INTO oodNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","D eda an hema kehk g al chum ali. D g Jesus am i waid k ab t‑baꞌich i kehsh ");
INSERT INTO oodNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","k hab kaij, “Nt wo shel em‑ahgi mamt hab waꞌi masma am wo i wahp Jiosh kownaltalig ed mamt am gawul wo juh g e‑chegitoidag k ab wabsh wo i pi e haꞌichuchud k hab wo masmak mo ihda al chum ali. ");
INSERT INTO oodNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hegai mat hab wo juh ihda at d wo s‑has haꞌichuk am Jiosh kownaltalig ed. ");
INSERT INTO oodNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","T hedai i s‑ap ab wo i ha nei g aꞌal am ni‑wehhejed o heg wa wepo mat ahni s‑ap ab ni‑nei. ");
INSERT INTO oodNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“S‑toꞌo ehbidam hab mahs am wehhejed hegai mat hema am wo i ha wanchkwua pi apꞌekam wui idam al aꞌal mo ab al ni‑hiwig. Baꞌich at wo i s‑apꞌek wehhejed matp hems wo e wachumchud k wo e muhkid mat koi hab wo juh ihda chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Chum o hekid an hab e wua g pi apꞌekam jewed dahm. K hegam mo hab wua am haꞌi ep ha wanchshulig pi apꞌekam wui. T g Jiosh hemho wo wa ha namkid. ");
INSERT INTO oodNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","9","“Pi at hedai wo e nako mas ab uhpam wo i wuhsh Jiawul kih amjed. Kut pi hekid wo huhug g ha‑shoꞌigchuda amai. Heg at wo wa wepok mat am mei ch ed wo e shoꞌigchudad. Mt heg hekaj am wo i e nako mamt pi am hu wo gei heg eda. Baꞌich at wo i s‑apꞌek mamt chum hems wo heb hu wua g e‑nowi o g e‑tad o g e‑wuhi matp hema idam hab wo em‑juh mamt am wo gei Jiawul kih ed k pi wo bei hegai pi ha huhugedam doakag mo g Jiosh ab em‑makiog. ");
INSERT INTO oodNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Am g wo s‑nenꞌoidk mamt pi wo s‑ha kehꞌidad idam al chuꞌuchumchu. Jiosh o ab si has ha elid ch am ha nuhkudachud g anghil.  ");
INSERT INTO oodNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ia ant jiwia jewed dahm mant wo ha doꞌibia g heb hu hihimkam. ");
INSERT INTO oodNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Neh, am g wo i oidahim ihda. Mamtp hems hema ahpim siant wo kahwaligak. Kut hema wo heb hu hih. Namt hig pi woho am wo s‑apko ha dagito hegam humukto gamai humukt k am wo hih doꞌag oidk k am wo i gahghi g heb hu himkam e‑shoiga. ");
INSERT INTO oodNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kut woho d wo s‑hehgigk mamtp wo cheh. ");
INSERT INTO oodNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bo wa masma pi shaꞌi tatchua g em‑ohg Jiosh mat hema wo heb hu hih idam al chuꞌuchum aꞌal. ");
INSERT INTO oodNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mt heg waꞌi hejel wo ahgi e‑wehm wohochuddam matp pi ap wo chuꞌi ab em‑wui. Kutp hems ab s‑ap wo em‑kaiha. Kut ab hahawa ep wo i e hemakoch g em‑chegitoidag, ");
INSERT INTO oodNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tp wabshaba pi ab hu wo em‑kaiha, kumt hemako o gohk am ha wehm wo him k am wo ah g chuꞌijigaj. Kut hab masma gohk o waik wo s‑mahchk g chuꞌijigaj mo id hab masma an oꞌohanas Jiosh oꞌohana ed. ");
INSERT INTO oodNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kutp eda wa sha pi ab hu wo em‑kaiha, kumt am wo ha ahgi wehsijj hegam mam am ha wehm e mihshmad. Kutp pi ab hu wo ha kaiha idam, kumt haha wo dagito hab masma mo pi d em‑wehm wohochuddam. ");
INSERT INTO oodNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nt wo si shel em‑ahgi mant ab wo em‑mah g gewkdag mamt hab wo ah mo haschu shohbidas ch haschu hiwgidas am ha wehhejed g ni‑hemajkamga. ");
INSERT INTO oodNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Jiosh at am hab wo em‑juni mamt haschu ab wo tahnid e wepo hab elidch. ");
INSERT INTO oodNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kunt am wo haꞌichugk em‑shahgid mamt hebai am wo i e hemapai, chum ams d wo waꞌi gohkk o waikk.” ");
INSERT INTO oodNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","D g Peter ab kakke g Jesus ch hab kaij, “Ni‑kownalig, nant wewaꞌakko ab wabsh wo i s‑hoꞌigeꞌel g ni‑wehm wohochuddam matp haꞌakkio hab wo juh g pi apꞌekam ab ni‑wui?” ");
INSERT INTO oodNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","D hab kaij g Jesus, “Pi amt wabsh wewaꞌakko ab wo i s‑hoꞌigeꞌel. Matp heꞌekkio hab wo i juh g pi apꞌekam, mt haꞌakkio wo s‑hoꞌigeꞌel. ");
INSERT INTO oodNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Bo wa e wua g em‑kownalig Jiosh ch em‑tatchuid mamt am hab waꞌap wo e junihid. “Id ant am wo em‑tashogi em‑ahgidch matp hems hema d wo kownalk ch am wo i ha hoa g e‑pionag ha‑wulshpadag, ");
INSERT INTO oodNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kumt am hema uꞌapa g piongaj, K id ab ab e wulshch g muꞌi mi‑yohn pihsh. ");
INSERT INTO oodNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kuki ihda pi am hu hugkam edgid g lial mat wo namkid g e‑wulshpadag. T hekaj g ahmoj am ha cheha mamt wo gagda k g wehmaj kihkam ch aꞌaligaj ch haꞌichu enigaj ep wo ha gagda. T d wabsh wo neneholk. ");
INSERT INTO oodNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kut ihda ha‑pionag ab i gei e‑ahmo wui k ab i tahni mat ab wabsh wo i s‑hoꞌigeꞌel. Kut wo wa wehs ha namkid. ");
INSERT INTO oodNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","T am i s‑hoꞌigeꞌel g ahmoj k im hu hab i juh g wulshpadaj k dagito. ");
INSERT INTO oodNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kut am hih ihda oꞌodham. “K eda hema g wehmaj pion al heꞌekia pihsh ab ab e wulshch hegai mamt ab i s‑hoꞌigeꞌel. Kut heg nam k g baꞌichuj be k hab si ah mat wo namkid. ");
INSERT INTO oodNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Kut ihda wehmaj pion ab i gei wecho k ab i e shoꞌigchud wui mat ab wabsh wo i nenida. Kut wo wa uhpam namkid. ");
INSERT INTO oodNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Kut wabshaba pi ab hu kaiham k wabsh ha chehani mamt ged hu wo si kuh am hugkam mat hekid wo i namkid. ");
INSERT INTO oodNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Neh, t haꞌi ehp g pion si pi ap e taht neidok mat has e juh k am hihim k am ahgid g e‑ahmo wehs haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“T g ha‑ahmo ab i wai ihda e‑pionag k hab kaij ab wui, ‘Ahpi si pi amkam ni‑pionag, ab ant i si s‑m‑hoꞌigeꞌid k im hu hab i juh wehs hegai m‑wulshpadag heg waꞌi hekaj map ab si ni‑tahni. ");
INSERT INTO oodNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kupt hab wa masma wo chum s‑hoꞌigeꞌel g e‑wehm pion mant has i masma s‑m‑hoꞌigeꞌel.’ ");
INSERT INTO oodNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Neh, bo kaij ch si bagat k ged hu si kuh am hugkam mat hekid wehs wo i namkid. ");
INSERT INTO oodNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Pegih, t hab wa masma am hab wo em‑juh g ni‑ohg Jiosh mamtp pi hab hu e‑ihbdag amjed wo i s‑ha hoꞌigeꞌel hegam mat ab em‑wui pi ap wo chuꞌi.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Am ad i haꞌasa ha mashcha g Jesus k am i dagito g Galilee chekshani. Kuchd gam hu aigo hihi Jordan akimel haꞌabjed k am hihim k am dada Judea chekshani ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","D muꞌi hemajkam an oidahim g Jesus. Kud ha doajid. ");
INSERT INTO oodNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","D am haꞌi dada g Palasi hab chum ahgk mat ab wo haꞌichu kakke k hekaj wo heki himch. K g ha‑kakkei hab chuꞌig, “No hiwgidas an t‑chehanig ed mat g oꞌodham wo s‑ohhod g e‑hohnig?” ");
INSERT INTO oodNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","D hab kaij g Jesus, “An o hab chuꞌig Jiosh oꞌohana ed: Ga hu i wehpeg at am ha nahto g Jiosh g cheoj ch uwi mat d wo e wehhejedkamk ");
INSERT INTO oodNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","k hab kaij: Iꞌajed at g oꞌodham wo ha dagito g e‑ohg ch e‑jeꞌe k ab wo i wehmt g e‑wehm kihkam. T idam d haha wo hemakok. ");
INSERT INTO oodNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Neh, bo kaij g Jiosh. K pi hab chum mahs mas g oꞌodham ab aꞌai wo i ha gawulkai hegam mat g Jiosh ab i ha hemakoch.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","D hab kaij g Palasi ab wui, “K wabshaba an oꞌohanas t‑chehanig ed matsh g oꞌodham wo mah g e‑hohnig g ohhoda tapial k wo s‑ohhod.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","D hab kaij g Jesus, “Heuꞌu, bo chuꞌig mamt wo ha mah g ohhoda tapial mamtp pi ab hu wo kaihamad g Jiosh ch pi wo pihk e elidad ha hekaj. K wa eda chum pi hab masma ga hu i wehpeg mat in ha nahto g Jiosh g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kunt id hab wo em‑ahgi mat d wo pi apꞌekamk mamt wo s‑ohhod g e‑wehm kihkam k hema ep wo hohnt, heg hi wa mamt wo s‑mai am i chum hohntk matki heki hu ha wehm woꞌiwua.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kuchd hab kaij ab wui, “Kuki heg hekaj baꞌich i chum s‑apꞌe mat g oꞌodham pi wo ha hohnt.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","D hab kaij g Jesus, “Pi at wehsijj wo e nako hab masma, heg hi wa mat g Jiosh am wo i ha wehmt. ");
INSERT INTO oodNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Haꞌijj at pi wo hohont no pi hab masma d mahsikam mo pi tatchua g hohnig ch haꞌijj d hegam mamt hab wabsh ha juh mat pi ap wo hohont. Haꞌijj o ep pi hohont heg hekaj mo g Jiosh kownaltalig baꞌich hab i elid. Kumt id am hab wo juh mamtp wo e nako.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kud haꞌi am ha uꞌapa g e‑aꞌaliga mat ab wo ha taht g Jesus k wo e hoꞌigeꞌidahu ha wehhejed. Kuchd chum s‑ha kehꞌid mo hab e wua. ");
INSERT INTO oodNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","D hab kaij g Jesus, “Ab g wabsh wo i ha hiwgid g aꞌal mat ab wo i hihi ni‑wui k pi an hu wo shaꞌi ha shohbi. Am at wabsh s‑moimam wo i wahp Jiosh kownaltalig ed ab ni‑hiwigch. Kumt hab waꞌi masma am wo i wahp.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Neh, bad kaij ch ab hahawa ha tahtam k amjed gam hu hih. ");
INSERT INTO oodNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","D am hu hebai am hema jiwia g wechij oꞌodham Jesus wui k hab kaij, “Ha mashchamdam, shahchu ant am hab wo juh g s‑apꞌekam mant ab wo bei g pi ha huhugedam doakag?” ");
INSERT INTO oodNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","K hab kaij g Jesus, “Ab ap ni‑kakke ab amjed g s‑apꞌekam. K eda heg waꞌi Jiosh d s‑apꞌekam. Am g hab junihid g Jiosh chehanig maptp wo tatchuad mapt wo bei g pi ha huhugedam doakag.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","D hab kaij g oꞌodham, “Hedai hegam chehanig?” D hab ep kaij g Jesus, “Idam mo hab chuꞌig: Pi g am hu ha muaꞌi g oꞌodham. Pi g am hu ha ehsidad g ha‑wehm kihkam. Pi g am hu haꞌichu ha ehsidad. Pi g am hu haꞌichu ha iattogidad. ");
INSERT INTO oodNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ab g si has ha elidad g e‑ohg ch e‑jeꞌe. Ab g i pihk e elidad ha wui g hemajkam hab masma map hab masma hejel pihk e elid.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","D hab kaij g oꞌodham, “Wehs ani am hab wa chum ha junihim idam chehanig. Shahchu ant hab ep wo juh?” ");
INSERT INTO oodNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","D hab kaij g Jesus ab wui, “Pegih, pt am wo him k wo gagda wehs haꞌichu map haschu i eniga k wo ha mah g namkigaj g shoꞌigkam k ab wo i him k wo ni‑oidad maptp woho s‑behimk hegai map chum e gahgid.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kud si pi ap e taht am i kaiok k gam hu hih no pi d shaꞌi si s‑kais ch si s‑huwid g e‑kaisdag. ");
INSERT INTO oodNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","D hab hahawa ep kaij g Jesus ab t‑wui, “Neh, nt wo si shel em‑ahgi mat wo shaꞌi si s‑hasigk mas g s‑kakais am wo i wahp Jiosh kownaltalig ed. ");
INSERT INTO oodNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mam hig hab elid mat wo e nako g ka‑mihyo mas am wo gahi wuhsh hoꞌipad jeg ed? Pegih, t hab wa masma pi wo e nako hegam mo hiwig g haꞌichu e‑eniga mas am wo i wahp Jiosh kownaltalig ed.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kuchd am wabsh i pi amichud k hab kaij ab wui, “A t hedai hig wo e doꞌibia.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","D g Jesus ab si shel i t‑neid k hab kaij, “Pi at wo e nako wabsh g oꞌodham. T wabshaba g Jiosh wo e nako mat wabsh chum haschu am hab wo juh.” ");
INSERT INTO oodNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","D g Peter hab kaij, “Nehꞌe, ahchim att wehs haꞌichu dagito k am i m‑oi. Tt haschu ab wo bei heg hekaj?” ");
INSERT INTO oodNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","D g Jesus hab kaij ab t‑wui, “Woho o wa mamt ab si i ni‑oi. Kunt am wo si shel em‑ahgi mant an wo dahiwua s‑kehg ni‑kownal daikud ed ahni Jiosh si Kehsha. Kumt ahpim an hab waꞌap wo dadhaiwua gamai gohk kownal dadaikud an k d wo uꞌusagakamk am ha dahm hegam gamai gohk dakam e‑wehm Tutuligo. ");
INSERT INTO oodNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Matp hedai am wo i dagito g e‑kih o g e‑wepnag o g e‑jehj o g e‑aꞌaliga o g e‑oidag at ab wo ui siant e dahm baꞌich i muꞌi k ab wo bei g pi ha huhugedam doakag. ");
INSERT INTO oodNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Muꞌijj hegam mo d wehpegkam hemu at d wo si ha oidchkamk ch muꞌijj hegam mo ga hu si ha oidch hemu d wo wehpegkamk. ");
INSERT INTO oodNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Id ant am wo em‑tashogi id hekaj mant wo haꞌichu wepogi g Jiosh kownaltalig. Heg o wepogidas mat g uhdwis oidag enigakam wabsh i siꞌalim am him k haꞌi ha ui g oꞌodham mat am wo chikp oidaj ed. ");
INSERT INTO oodNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","T g ha‑namkidadag d wo hegaik mo haschu i uꞌu g pion tash ab. T am ha hekaj hihim k chikp. ");
INSERT INTO oodNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“T am hahawa ep hih humukt ohla ch ed. K am haꞌi gegok g oꞌodham ch pi haꞌichu has wua. ");
INSERT INTO oodNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","K hab ha ahg, ‘Nt wo s‑ap em‑namkid mamt wo chikp am ni‑oidag ed.’ ");
INSERT INTO oodNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kut wa woho am chikpano idam. T hab wa masma hab ep e juh am i gamai gohk ohla ch ed ch waik ohla ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“K am hu d i hetasp ohla. T am hih kahya wui. K am wabsh haꞌi gegok. K hab kaij ab ha wui, ‘Shahchu am ahgch wabsh heki wua g tash pi haꞌichu has wuadch?’ ");
INSERT INTO oodNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“K hab kaij idam, ‘Pi at hedai t‑chikpanach.’ “K hab hahawa ep kaij ab ha wui, ‘Pegih, k am wo hihim k wo chikp am ni‑oidag ed.’ ");
INSERT INTO oodNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Neh, t gam hu si i juh. Kut ihda oidag enigakam hab ah g e‑pionag ha‑geꞌejig, ‘Ab g i ha waid g pion k ab wo i ha namkidahi. T hegam wehpeg wo e namkid mant si ha oidch an ha ui k amjed hegam ehp mant ep ha ui k hegam ga hu si ha oidk wo e namkid mant si wehpeg an ha ui.’ ");
INSERT INTO oodNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kut hegam mat gam hu si i juhk chikp mo d i hetasp ohla ab ui g e‑namkidadag haꞌakia mo heꞌekia uꞌu g pion tash ab ch amjed wehs g haꞌi. ");
INSERT INTO oodNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","“Kut ab ha ai hegam mat wabsh i siꞌalim chikp. K hab e ahg mat baꞌich i muꞌi wo ui g e‑namkidadag. Mt wabshaba haꞌakia wa ha namkid. ");
INSERT INTO oodNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","T ab ui g e‑lialiga k babgat ab wui g e‑ahmo k ab wui hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Neh, hegam oꞌodham mapt si oidk an ha ui al hemako ohla ab chikp. Kutt ahchim ge tash oidk chikp am s‑toni k ed. Kupt eda am wo haꞌakia t‑namkid mapt hegam.’ ");
INSERT INTO oodNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“K hab kaij g oidag enigakam ab wui hegai mo ha wehhejed neok, ‘Neh, ni‑nawoj, pi ant shaꞌi em‑iattogi namt pi am wa apꞌech mamt haꞌakia k ab wo chikp ni‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pegih, ab g wabsh wo uhꞌi g e‑namkidadag k gam hu hihim uhpam no hig pi ab ni‑ab ahni hejel mant haꞌakia wo wa ha namkid hegam mant gam hu si i juhk ha ui mant ahpim heꞌekia em‑namkid. ");
INSERT INTO oodNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ab o ni‑ab mant has masma wo hekaj g ni‑lialiga. Aha nam wabsh s‑ni‑hehgamk mani s‑hemajima?’ ” ");
INSERT INTO oodNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","D hab hahawa ep kaij g Jesus, “Nehꞌe, t hekaj hab hegam mo gam hu si i ha oidch d wo wehpegkamk ch hegam mo d wehpegkam ga hu wo si ha oidchk.” ");
INSERT INTO oodNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Am achd i t‑nakog k gam hu hihi. Kud g Jesus am hejelko t‑wai ahchim gamai gohk ");
INSERT INTO oodNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","k hab kaij, “Neh, am att wo hihi Jerusalem wui. T hegam mo s‑ni‑kehꞌid am wo ni‑dagito ha wui g uꞌugchu papal ch chehanig em‑mashchamdam. Kut idam ab wo haꞌichu ni‑abch s‑ni‑muꞌamk ");
INSERT INTO oodNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","k am wo ni‑dagito ha wui g goꞌol hemajkam. T idam wo nahnko ni‑ahgad ch wo ni‑gewittan k amjed ab wo ni‑sisish kots t ab. Nt ab wo muh. T am wo him k d wo i waik tashk amjed. Nt ab wo uhpam i wuhsh muhkig amjed.” ");
INSERT INTO oodNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","D eda am t‑wehmaj g ha‑jeꞌe g James ch John. D idam am wehmaj hihi Jesus wui ab haꞌichu s‑tahnimk. D g ha‑jeꞌe ab si has elid k ab wui hab kaij matsh ab wo haꞌichu tai. ");
INSERT INTO oodNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","D hab kaij g Jesus, “Shahchu ap tatchua?” D hab kaij ihda, “Pt hig wo i ha chuhcha idam gohk ni‑mahmad mat am m‑oidch d wo hahaꞌichuk mapt hekid am wo i himch g e‑kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","D hab kaij g Jesus ab ha wui, “Pi am shaꞌi ap mahch mam haschu ab ni‑tahni. Wehpeg ant ab wo nako g geꞌe shoꞌigdag. Kut hegam mat am ni‑oidch d wo si hahaꞌichuk hab waꞌap wo e juh.” D hab kaij idam, “Pegih, tt wo t‑nako.” ");
INSERT INTO oodNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","D hab hahawa ha ahg g Jesus, “Pegih, woho amt ab wo nako hegai hab mahs shoꞌigdag. K wabshaba pi ab hu ni‑ab manis ahni am wo i ha chuhcha mat hedai am ni‑oidch d wo hahaꞌichuk. Hegam at am wo i e chuhcha mat hedai i ha wehhejed am apꞌech g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kuchd ahchim haꞌi babgat ab ha wui hegam gohk mad hab masma ab hejel chum e haꞌichuchud. ");
INSERT INTO oodNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","D g Jesus ab hahawa wehs i t‑hemapad k hab kaij ab t‑wui, “S‑mahch am mo g ha‑maliomig s‑gewkam ha chehani g e‑pionag ch g ha wanimeddam am ha himchudahim. ");
INSERT INTO oodNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","T wabshaba pi hab masma hab wo shaꞌi chum mahsk am em‑shahgid. Mt wabsh si s‑hemajim am wo i ha wehmtad g e‑wehm wohochuddam hab sha masma mam d wabsh ha‑pionag mamtp wo tatchuad mamt wo ha wanimedad. ");
INSERT INTO oodNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ahni ani hab wa masma si s‑hemajim i em‑wehmt ch pi ab hu ni‑haꞌichuchud em‑dahm, chum anis d Jiosh si Kehsha. Ab o em‑wui him g s‑koꞌok namkidadag heg hekaj pi ap em‑chuꞌijig. Nt wabshaba ahni em‑wehhejed wo nako mamt wo e wupulꞌo.” Neh, bad kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kuchd gam hu i wuwha ab Jerico t amjed. D muꞌi hemajkam ab i t‑oi. ");
INSERT INTO oodNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","D am hu hebai wohg hugid an gohk am dadha g pi neneadam oꞌodham. Kuchd am hihim. D am i t‑kah k s‑mai mo an him g Jesus k si s‑kaidam hab chechꞌe, “Ab g si i s‑t‑hoꞌigeꞌid, ahpi map d s‑apꞌekam t‑kownalig ch apsh d t‑kownaligbad David amjedkam.” ");
INSERT INTO oodNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","D hegam mo an ha wehgaj si s‑ha kehꞌid ch hab ha ahg mat wo pi shahmunik. D wabshaba baꞌich haha wabsh i s‑kaidam hab kaij, “Ab g si i s‑t‑hoꞌigeꞌid, ahpi Davidbad amjedkam.” ");
INSERT INTO oodNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kud am hahawa i kekiwua g Jesus k ab i ha waid k hab kaij, “Shahchu am tatchua mant hab wo em‑juni?” ");
INSERT INTO oodNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","D hab kaij idam, “Si g s‑t‑hoꞌigeꞌid k ab i t‑nenchud.” ");
INSERT INTO oodNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kud si s‑ha hoꞌigeꞌel g Jesus k ab ha taht ha‑wuhpui ab. D ha hekaj haꞌichu s‑ap neid k ab i oi. ");
INSERT INTO oodNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kuchd amjed am hihim Jerusalem wui k am ai g Olive Uꞌus Kawulk. D heg mia kihhimag ch hab chehgig Bethphage. ");
INSERT INTO oodNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","D g Jesus gohk hab ha ah g e‑chuhchai, “Am g wo hihim k ga hu wo dada kihhim t am. Kut am hema wo wulshpik g wuhlu g e‑mad wehm. Mt gam wo ha wulꞌo. ");
INSERT INTO oodNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kumt ab wo em‑kakke mams has wo juh. Kumt hab wo ha ah mani ahni d em‑mashchamdam ch tatchua. Kut ab wabsh wo i ha dagito mamt ab wo i ha wanim ni‑wui.” Neh, bad kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","K eda heki hu waꞌi oꞌohanas matsh id am hab wo e juh. Hema atki wa an oꞌoha g kelibad Jiosh haꞌichu i tashogidam. K g oꞌohanaj hab chuꞌig: ");
INSERT INTO oodNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Am g wo ha ahgid g hemajkam am Jerusalem kihhim t am: Ab at wo hih g s‑apꞌekam em‑kownalig em‑wui k ab wabsh wo si e shoꞌigchudch ch hab g wechij wuhlu wo cheshajhid. ");
INSERT INTO oodNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kud am hihi idam gohk k am hab juh mo haschu hab ha ahg g Jesus ");
INSERT INTO oodNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","k am ha uꞌapa hegam wuplu. Kuchd an toa g t‑liliwa ha ab. D an dahiwua heg an mo d wechij. ");
INSERT INTO oodNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kud muꞌi hemajkam an t‑wehgaj ch am i tahtdahim g e‑liliwa wohg ch ed. D haꞌi g wechij uꞌus iꞌibhonig an hikkumiꞌak k am toꞌahim wohg oidch. ");
INSERT INTO oodNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","D hegam muꞌi hemajkam mo an t‑wehgaj hihim si s‑kaidam hihnk ch hab kaij, “T‑doꞌibiakam! Dap amjedkamaj g t‑kownaligbad David. Jiosh atki ia i m‑wuhshad k ab si s‑m‑hoꞌigeꞌid. Kuch ab si has elid g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kuchd am i dada Jerusalem kihhim t am. D muꞌijj am wabsh i pi amich mo haschu has e wua k hab kaij, “Dohꞌo wud hegai?” ");
INSERT INTO oodNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","D haꞌijj hab ep kaij, “Id oki d Jiosh haꞌichu i tashogiddam ch hab chehgig Jesus ch am d kihkam Nazareth t am am Galilee chekshani ch ed.” ");
INSERT INTO oodNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","D am i wah g Jesus kolhai ch ed mo am kehk g geꞌe cheopi. D eda am haꞌi dadha mo am haꞌichu gagda ch haꞌichu ha nolawt cheopi miabidch. D g Jesus gam hu si ha shahmud k g ha‑dadaikud kuhkpal ha shul. D am haꞌi ep dadha ch am kammialt g lial. Kud g ha‑mimsa gam hu aꞌai kuhkpal si ha shulig ");
INSERT INTO oodNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","k hab hahawa wehs ha ah, “Bo chuꞌig an Jiosh oꞌohana ed mo hab kaij g Jiosh: Ahni o d ni‑wehhejedkam ihda geꞌe cheopi. Kut id wui ab wo hihhimad g hemajkam mat ab wo ni‑ihmad. Neh, bo kaij g Jiosh. Kumt wabshaba ahpim an be k am eda hab wabsh wua g hejel e‑tatchui ch chum hems haꞌichu s‑aꞌagi ha ehsid ab ha wui haꞌichu gagdach.” ");
INSERT INTO oodNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kumd am wui ha uꞌapa am geꞌe cheopi t am hegam mo d pi neneadam ch hegam mo pi aꞌapkodag. Kud ha dodaj. ");
INSERT INTO oodNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","D g aꞌal am si hihnk geꞌe cheopi t am ch hab kaij, “Ab ach si has elid ihda mo d t‑kownaligbad David amjedkam ch d Jiosh si Kehsha.” Kud g uꞌugchu papal ch chehanig t‑mashchamdam neid mo g s‑hasig haꞌichu hab wua ch ha kah g aꞌal ch shaꞌi si babgat ");
INSERT INTO oodNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","k hab kaij ab Jesus wui, “Shahchu ap ahgch pi ha shohbid? Aha nap pi has shaꞌi elid mo has i kaij?” D hab kaij g Jesus, “Am o wa s‑apꞌe. Jiosh at hab masma ha nahto g aꞌal mat si s‑ap ab wo hehgchulidad mo hab masma an hab chuꞌig Jiosh heki hu oꞌohana ed.” Neh, bad kaij g Jesus ");
INSERT INTO oodNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ch am ha dagito. Kuchd gam hu hihi Bethany kihhim wui k am kohk. ");
INSERT INTO oodNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Baꞌich tash, chd gam hu hebai uhpam hihim Jerusalem wui. Tsh bihugim g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","D eda am hu hema kehk g suhna uhs. Kuchd ab wui hihi no pi s‑hahhagag ch ab wo chum bahidagk. D oi wa pi ab hu haꞌichu shaꞌi ihbdag. D hekaj hab kaij, “Pi at dahm ab hu ep wo bahidagt.” Kudki wa woho gaksh. ");
INSERT INTO oodNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kuchd am i neidok si has i elid k hab kaij, “S has masma shaꞌi si s‑hohtam gaksh.” ");
INSERT INTO oodNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","D hab kaij g Jesus, “Nt wo si shel em‑ahgi mamt ab wabsh wo hiwgad g Jiosh. Kut wabsh chum haschu hab wo em‑juni. Mtp hems wo cheha ihda doꞌag mat gam hu wo e wua ge shuhdagi ch ed. Kut wa woho hab wo e juh mamtp wo s‑wohochudad mat hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ab g wo tahnid g Jiosh mamt haschu wo i tatchua. T heg hab wo em‑junidad mamtp woho wo s‑wohochudad mat hab wo e juh.” ");
INSERT INTO oodNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kuchd ged hu uhpam dada mo am kehk g geꞌe cheopi. D g Jesus am ha mashcham g hemajkam. D am haꞌi dada g uꞌugchu papal ch geꞌeged k ab kakke ch hab kaij, “Dohp amjed hab chum e elid map an uꞌukch g e‑gewkdag ch am hab haꞌichu wua? Oi g am t‑ahgid.” ");
INSERT INTO oodNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","D hab kaij g Jesus ab ha wui, “Pegih, nt ahni wehpeg ab epai wo haꞌichu em‑kakke. Mt am wo ni‑ahgi. Nt am haha wo em‑ahgi g em‑kakkei. ");
INSERT INTO oodNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Am g hig wo ni‑ahgid mams hedai amjed hab elid mo wa g Johnbad ab uꞌukch g e‑gewkdag ch ha pahl wapkonahim. No ab Jiosh amjed aha no ab oꞌodham amjed?” D idam am wabsh chum hejel si aꞌaga ch hab kaij, “Shahtt hig wo chei? T wo s‑t‑kehꞌid k ab wo t‑kakke matt haschu ahgk pi ab hu wohoch g Johnbad mattp hab wo chei mo ab Jiosh amjed uꞌukch g gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","T g hemajkam has wo t‑juh mattp hab wo chei mo ab wabsh oꞌodham amjed uꞌukch. Muꞌijj o hab elid mo d Jiosh haꞌichu i tashogidam.” ");
INSERT INTO oodNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Neh, bad kaij ch ab hahawa uhpam i e nohnogi Jesus wui k hab kaij, “Pi ach shaꞌi mahch mas hedai amjed ab uꞌukch g e‑gewkdag.” D g Jesus hab epai kaij, “Pegih, nt ahni hab waꞌap pi wo shaꞌi em‑ahgi mani hedai amjed uꞌukch g ni‑gewkdag ch hab wua wehs ihda.” ");
INSERT INTO oodNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","D hab ep kaij g Jesus, “Am g wo oidahim ihda mant wo em‑ahgi. Matp hems hema g oꞌodham gohk wo aꞌalidagk ch hab wo ah g geꞌechu, ‘Ni‑sulijga, am g hihm k chikpan am uhdwis oidag ch ed id i tashkaj.’ ");
INSERT INTO oodNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“K hab kaij ihda, ‘Pi ani tatchua mant am wo hih,’ ch wabshaba am shaꞌi heꞌes gawul juh g e‑chegitoidag k am hih oidag wui. ");
INSERT INTO oodNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Kut ihda ohg am hahawa hih heg wui alichu e‑alidag k hab waꞌap kaij ab wui. “K hab kaij ihda, ‘Heuꞌu, am ant wo wa hih,’ ch wabshaba pi am hu hih. ");
INSERT INTO oodNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Dohm hab elid mat ab s‑wohog el g e‑ohg?” D hab kaij hegam, “Hegai mo d geꞌechu.” D hab hahawa ep kaij g Jesus ab ha wui, “Nt wo si shel em‑ahgi mat g em‑uhwaida chechoj ch chechpaꞌawi uꞌuwi am wo i wahp Jiosh kownaltalig ed matp ab wo hiwgad g Jiosh. Mt wabshaba ahpim pi am hu wo i wahp mamtp pi ab hu wo hiwgad. ");
INSERT INTO oodNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ha pahl wapkondam John at wa ia jiwia em‑wui k am chum em‑chehgi g s‑apkokam. Kumt pi ab hu wohoch. T wabshaba idam ab s‑wohoch. Kumt wa chum nei ihda k eda wa pi gawul juh g pi ap e‑chegitoi mamt ab wo s‑wohoch. ");
INSERT INTO oodNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Am g hema ep wo kaiham g haꞌichu wepogida,” bad kaij g Jesus. “Neh, matp hems hema g jewed enigakam am wo ei g uhdwis e‑oidag ed. T g piongaj an si kolhaidad k heg ep nahto mat hekaj am wo i wuhshad g wadgaj k am kei g uhgk kih mat heg amjed wo nuhkudad g eshaj. “T gam hu hasko chihpia g enigakam k haꞌi ha hiwigi g e‑oidag. ");
INSERT INTO oodNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","T am i e ai mat g uhdwis bai. T am haꞌi ha cheha g e‑pionag mat am wo hihim k ab wo bei hegai wadgaj mo ab d i chum wuikamaj g enigakam. “T am hihim k am dada. ");
INSERT INTO oodNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kut idam nuhkuddam an ha uꞌu k hema gewittan k hema muꞌa k hema ep maꞌichkwua. ");
INSERT INTO oodNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Kut am hahawa baꞌich i muꞌi ep ha cheha mat am wo hihi. Kut am hihim k am dada. T am hab wa masma hab ep ha juh hegam nuhkuddam. ");
INSERT INTO oodNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“T g e‑alidag am hahawa ep cheha gam hu si ha oidch no pi hab ha elid mat ab wo wa has el. ");
INSERT INTO oodNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“T wabshaba idam oidag nuhkuddam am i nei g alidaj k hab kaij ab aꞌai e wui, ‘Id o d enigakam alidag. Oi g wo, tt wo muꞌa k wehs wo bei g enigaj.’ ");
INSERT INTO oodNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Neh, t wa woho an be k gam hu si i wuhshad ab amjed g uhdwis oidag k mua. ");
INSERT INTO oodNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Pegih neh, shaht hig wo ha juh idam g enigakam hekid i jiwiak?” ");
INSERT INTO oodNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","D haꞌijj hab kaij hegam, “Hemho wa at wo ha kokda hegam si pi ap chechoj k gam hu baꞌich haꞌijj ab wo ha nuhkudach mat idam ab hi wo mah hegai mo haschu ab d i wuikamaj.” ");
INSERT INTO oodNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","D hab ep kaij g Jesus, “Heuꞌu, nat pi s‑ohhod g enigakam alidag. Kumt hab wa masma wo s‑ni‑ohhod. Id o hab ahgch hab chuꞌig g wepogida ahga Jiosh oꞌohana ed: Kihtdam at wo hema chum s‑ohhodam g hodai. T wabshaba id d wo si s‑has haꞌichu hodaik am ha‑kihta wehhejed. Id o hab d ahga mat si s‑kehg haꞌichu hab wo juh g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Neh, bo chuꞌig g Jiosh oꞌohana. T g Jiosh wo em‑wohppoꞌi g e‑kownaltalig ahpim Tutuligo k hegam ab wo ha mah mat s‑ap am wo i chikp. ");
INSERT INTO oodNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Neh, t wo e shoꞌigch hegam mat pi wo ni‑amich. Id at heg wo wa wepok mat ab wo e keiko hodai t ab. Kut hegam mat wo s‑ni‑ohhod wo bei g s‑koꞌok e‑namkidadag. Id at heg wo wa wepok mat g hodai ab ha ab wo gehsh k am wabsh wo s‑ha wia.” ");
INSERT INTO oodNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","D hegam uꞌugchu papal ch Palasi s‑mahch mo g Jesus ha wepogid hegam pi ap pion ");
INSERT INTO oodNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ch heg hekaj an chum s‑behim. D wabshaba g hemajkam hab elid mo g Jesus d hema Jiosh haꞌichu i tashogiddam. K hegam uꞌukchu papal s‑ha gihug. ");
INSERT INTO oodNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus ad am hema ep ha ahgid g haꞌichu wepogida am neokch ha wui g hemajkam ch hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Bant masma am ep wo wepogi g Jiosh kownaltalig matp hems hema g kownal am wo i apꞌech g geꞌe gegosig am wehhejed g e‑alidag nat pi wo ha hohnt. ");
INSERT INTO oodNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","T am i e ai. Kut am ha cheha g e‑pionag mat an wo ha ahgidahi hegam mam ab heki hu ha waid. Kut wabshaba idam pi ab hu i hihimim. ");
INSERT INTO oodNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Kut am hahawa haꞌi ep ha cheha g e‑pionag mat an ep wo i ha ahgidahi. K idam an ha ahgidahim ch hab kaij, ‘Heki at hu e chuama g s‑gihgim ch e gagꞌe g wipsilo ch wehs haꞌichu e nahtokch. Kumt ab wo i hihim k wo e gegos.’ ");
INSERT INTO oodNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“T wabshaba idam mam ab ha waid pi ab hu shaꞌi kaiham k gam hu hab wabsh wua g hejel e‑chikpan. Hema at gam hu hih e‑oidag wui. T hema gam hu ep hih e‑tiannaga wui. ");
INSERT INTO oodNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kut haꞌijj an ha ui idam pion k ha gewittan k ha kokda. ");
INSERT INTO oodNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kut shaꞌi si bagat hegai kownal k am ha cheha g e‑shondalig mat am wo hihim k epai wo ha kokda hegam mat ha kokda g pion k wo mehi g ha‑kihhim. T wa woho hab juh. ");
INSERT INTO oodNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“T am hahawa i ha wai g e‑pionag k hab kaij, ‘E at nahto g gegosig wehhejed g ni‑alidag hohnta. T wabshaba hegam hemajkam mant ab i chum ha wai hab e juh mo pi d hahawa ha‑wuikam. ");
INSERT INTO oodNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kumt am wo hihi wohg oidk k ab wo i ha wai gegosig wui mamtp heꞌekia i hemajkam wo ha cheh.’ ");
INSERT INTO oodNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Kut am wa woho hihi g piongaj wohg oidk k ab wehs i ha wai hegam mat ha cheh, chum hems g pi ap hemajkam. T am hahawa muꞌi dada. Kumt wehsijj ab ha mah g s‑kehg eniga heg wehhejed k am i ha wahpki. Kut shuhd g kih. ");
INSERT INTO oodNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kut am i wah g kownal k am ha nei hegam mat am dada. K am hahawa wabsh hema daha g oꞌodham mo pi ab hu wahkch hegai s‑kehg eniga. ");
INSERT INTO oodNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","K ab kakke ch hab kaij, ‘Ni‑nawoj, shahpt masma ia i wah pi ab hu wahkch g s‑kehg eniga id wehhejed?’ “T am wabsh i pi amich ihda oꞌodham mat has wo chei. ");
INSERT INTO oodNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kut ihda kownal am hahawa ha ahgi g e‑pionag k hab kaij, ‘Am g wo si wulshp k gam hu wo daꞌich s‑chuhugam k ed. Kut am hu wo shoak k ga hu wabsh wo i si e kiꞌishch nat pi wo shaꞌi si s‑koꞌok haꞌichu nakogad.’ ");
INSERT INTO oodNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Pegih, nt wo em‑ahgi mo muꞌi ab ha waid g Jiosh. K wabshaba al heꞌekia d i hemajkamgaj.” ");
INSERT INTO oodNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kutsh am i e hemapai g Palasi am i aꞌamich mat has masma wo heki himch g Jesus ab haꞌichu kakkek. ");
INSERT INTO oodNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tki am haꞌi i ha wehmt hegam mo ab si has elid g kownal Herod k am ha wehm hihi haꞌi hegam Palasi k am dada k hab kaij, “Ha mashchamdam, s‑mahch ach map s‑ap d oꞌodham ch wabsh chum hedai ha mashcham g Jiosh himdag, chum as has wo chei hedai i. ");
INSERT INTO oodNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pegih, k am wo t‑ahgi maps has elid g geꞌe kownal lial kowlanta. No hig t‑hiwgid g t‑chehanig ahchim Tutuligo matt wo ha namkid aha no pi t‑hiwgid?” ");
INSERT INTO oodNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","D wabshaba g Jesus am wa s‑ha amichud mo g pi apꞌekam hab elid ch hab ha ahg, “Ahpim s‑chu iꞌattomkam am wabsh chum heki s‑ni‑himchudamk. ");
INSERT INTO oodNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ab g wo hema ni‑chehgid hegai lial mam hekaj ha namkid.” Kumd ab hema chehgi. ");
INSERT INTO oodNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","D hab ha ahg, “Am g hig wo ni‑ahgid mo hedai wuhiosha ch hedai chehgig ab oꞌohadag id ab lial?” ");
INSERT INTO oodNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","D hab kaij idam, “Hegai mo d uhgchu t‑kownalig.” D hab hahawa ep kaij g Jesus ab ha wui, “Pegih, ab g wo i dagito kownal wui hegai matp d enigaj k am epai wo i dagito Jiosh wui mo haschu d epai enigaj.” ");
INSERT INTO oodNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kud si has i el hegam k gam hu hihi ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","D heg waꞌi tash ed am haꞌi dada g Sajusi Jesus wui. Hegam mo d Sajusi o pi wohochud mat g muhki ab uhpam wo i wuhsh muhkig t amjed. ");
INSERT INTO oodNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","D hab kaij idam, “Ha mashchamdam, Mosesbad atki an oꞌoha hegai chehanigaj g Jiosh mo hab chuꞌig matsh g am oidchkam wehngaj hegai mat wo muh pi ha aꞌalidagkch hemho wo wa bei g hohnigaj g e‑wehnagbad. Tsh g ha‑aꞌaliga hab masma wo e kuint mat d wo aꞌalidajk hegai mat muh. ");
INSERT INTO oodNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Pegih, k am hu hebai wewaꞌak d e‑wepngam ch am t‑wehm kih. Kut g si geꞌechu ge hohnt k pi ab hu ha aꞌalidt k muh k an dagito g e‑hohnig. T g am oidchkam nawojij an hahawa ep bei g hohnigaj ");
INSERT INTO oodNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","k hab waꞌap pi ab hu ha aꞌalidt k hab waꞌap muh. Kut ihda g oidchkam hab waꞌap hohnt k hab waꞌap muh pi ab hu ha aꞌalidtk. Neh, t hab masma i e oi idam wewaꞌak k wehsijj koꞌok huhug. ");
INSERT INTO oodNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","K am huꞌi hebai, t haha wabsh muh hab wa ehp ihda uwi. ");
INSERT INTO oodNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pegih, am g hig t‑ahgid mas hedai d wo hohnigkad ihda matp ep wo e chegito g koꞌi no pi wehsijj hohnigkahim.” ");
INSERT INTO oodNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","D hab kaij g Jesus ab ha wui, “Pi am ap chegito nam pi pi shaꞌi mahch g Jiosh oꞌohana ch ep pi shaꞌi mahch mo heꞌes i gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Woho at ab uhpam wo ha mah g koꞌi g doakag. T wabshaba hahawa pi wo hohontad hab masma mo g anghil pi hohont. ");
INSERT INTO oodNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mosesbad atki an oꞌoha mash wa hab kaij g Jiosh: ");
INSERT INTO oodNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ahni ani d ha‑Jioshga hegam Abraham ch Isaac ch Jacob. Neh, id o hab kaij g Jiosh, chum as heki hu koi, no pi am e wehm ha nuhkud ch ab uhpam wo i ha wuwhas muhkig amjed. Pi amt woho wo i huhug am i koꞌok matp g Jiosh d em‑Jioshga.” ");
INSERT INTO oodNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kud am i kah ihda g hemajkam k si has i el g mashchamaj. ");
INSERT INTO oodNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kud am haꞌi dada g Palasi mat wo heki himch g Jesus am i kaiok mat ab si ha chehmo g Sajusi. ");
INSERT INTO oodNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","D hema hegam d Jiosh chehanig hudawogdam ");
INSERT INTO oodNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ch hab kaij, “Ha mashchamdam, shahchu o d si baꞌiwechkim geꞌe chehanigaj g Jiosh?” ");
INSERT INTO oodNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","D hab kaij g Jesus, “Id o d si geꞌe ch baꞌich i si s‑has haꞌichu chehanig: Hemho wa amt ab wo si tatchuad g e‑kownalig Jiosh wehs e‑ihbdagkaj ch id am wo chehgidch wehs e‑doakagkaj ch wehs e‑chegitoikaj. ");
INSERT INTO oodNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","K id am oidch d si s‑has haꞌichu chehanig ch wepo chuꞌig: Hemho wa amt ab wo tatchuad g hemajkam hab masma mam ab hejel e tatchua. ");
INSERT INTO oodNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Idam gohk chehanig o ab ab wehs shohshonas g Jiosh chehanig ch wehs hegai matki kekelibad Jiosh haꞌichu i tashogiddam an oꞌoha.” ");
INSERT INTO oodNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","D am i e hemapai g Palasi. D g Jesus hab ha ahg, ");
INSERT INTO oodNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Am g wo ni‑ahgid mam hedai hab elid mat g Jiosh si Kehsha ab d wo amjedkamk?” D hab kaij hegam, “Heg atsh d wo amjedkamk t‑kownaligbad mash hab chehgig David.” ");
INSERT INTO oodNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","D hab kaij g Jesus, “Pegih, sh wa eda g Davidbad hab aꞌaga, ‘ni‑kownalig’ ch hab kaij g gewkdajkaj g Hekia S‑apꞌekam Gewkdag: ");
INSERT INTO oodNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Bo kaij g Jiosh ab ni‑kownalig wui: In g dahiwua ni‑wehm ni‑kownal daikud ed. Kunt wo ha gewito g m‑obga mat ab wabsh wo m‑wechok. ");
INSERT INTO oodNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Neh, namt hig s‑ap wo ah mat has masma d wo Davidbad amjedkamk ihda mash d geꞌe kownaligaj?” ");
INSERT INTO oodNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kud pi hedai e nako mas ab hu uhpam has wo chei Jesus wui nih hemako neꞌoki. D heg i tashkaj amjed pi hedai e nako mas ab hu haꞌichu ep wo kakke. ");
INSERT INTO oodNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Muꞌi hemajkam ad am haꞌichug t‑wehm. ");
INSERT INTO oodNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kud hab kaij g Jesus ab wehsijj t‑wui, “Hegam chehanig em‑mashchamdam ch Palasi o d hegam mo ab mahks g gewkdag mat am wo i tashogi g chehanig. ");
INSERT INTO oodNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kumt heg hekaj ab wo s‑ha wohog elidad. K wabshaba muꞌijj idam pi am hu hab junihim mo haschu em‑mashcham. Kumt hekaj pi am hu ha oidk hab wo masmak. ");
INSERT INTO oodNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Neh, muꞌi s‑hasig haꞌichu o ab em‑chehani. K id d s‑wehch haꞌichu mohtoi am em‑wehhejed. K eda pi haꞌichu hab shaꞌi wua mas hekaj em‑wehm wo moht. ");
INSERT INTO oodNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wehs haꞌichu o heg wabsh hekaj am hab junihim mamt wo ha neidad. An o uꞌa g Jiosh oꞌohana heg wabsh hekaj mamt hab wo ha elidad mo ab wohog elid. ");
INSERT INTO oodNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Si o s‑hohhoꞌid mat si s‑apko wo dadhaiwua am geꞌe gegosig ch ed ch am wa si hejelko dadaikud am cheopi ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Si o s‑hohhoꞌid mamt ab wo si has ha elidad am hemajkam ha‑shahgid ch hab wo ha aꞌagad mo d ge ha mashchamdam. ");
INSERT INTO oodNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ahpim g pi wo shaꞌi tatchuad mams hab wo em‑aꞌagad ‘ha mashchamdam’ nam pi d aꞌai e‑wepngam. Kuni ahni d waꞌi em‑mashchamdam. ");
INSERT INTO oodNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pi g hedai hab wo aꞌagad ‘ge ni‑ohg’ id dahm jewed. Heg amt waꞌi Jiosh hab wo aꞌagad mo d ge em‑ohg. ");
INSERT INTO oodNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pi g hab wo e aꞌagad mam d ha wanimeddam. Ahni ani d waꞌi em‑wanimeddam Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bamt waꞌi masma d wo si haꞌichuk mamt d wabsh wo ha‑pionagk. ");
INSERT INTO oodNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kut d wabsh wo pi haꞌichuk hegai matp hedai hab wo chum e elidad mo d si haꞌichu. Heg at d wo si haꞌichuk matp hedai ab wabsh wo i pi e haꞌichuchudch.” ");
INSERT INTO oodNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","D hab hahawa ep kaij g Jesus, “Neh, muꞌijj ahpim chehanig ha mashchamdam ch ahpim Palasi am d wabsh s‑chu iꞌattomkam. Ih, shoꞌig! Jiosh at si s‑koꞌokam wo em‑namkid heg hekaj. Pi am ha hiwgid hegam mo am i chum s‑wahpkimk Jiosh kownaltalig ed ch hab waꞌap hejel pi am hu i wahp. Heg o wa wepo mam ab si yahwidadch g kihjeg am Jiosh kownaltalig wui.  ");
INSERT INTO oodNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ha am iattogid g heheꞌejel wiꞌikam uꞌuwi ch ha ehsid g ha‑kihki ch eda am wabsh s‑e chehgidamk mam si chew e hoꞌigeꞌidahun. Id at hekaj baꞌich wo i s‑koꞌokk g em‑namkidadag. ");
INSERT INTO oodNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Am am si i e nakog mamt chum hems hemako am wo i wanchkwua pi wohokam e‑himdag ed. T ihda baꞌich i s‑gewkam wo wulshpik mam ahpim mat am wo gei Jiawul kih ed nat pi baꞌich i s‑gewkam am wo oidad g pi wohokam em‑himdag. T g Jiosh si s‑koꞌokam wo em‑namkid heg hekaj. ");
INSERT INTO oodNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Neh, am am haꞌi ep chum ha mashcham ch eda hab chechꞌe, ‘Pi att hemho wa hab wo juh g t‑neꞌoki mattp wabsh wo gewkaj chehchegch g geꞌe cheopi, heg hi wa matt wo chehcheg hegai ohla mo hekaj e heosid.’ ");
INSERT INTO oodNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","K eda g geꞌe cheopi baꞌich d i si haꞌichu mo hegai heosidakud. ");
INSERT INTO oodNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Kum hab ep chechꞌe, ‘Pi att hemho wa hab wo juh g t‑neꞌoki mattp wabsh wo gewkaj chehchegch hegai iagchulidakud mo am hab chuꞌig geꞌe cheopi t ab, heg hi wa matt wo chehcheg hegai mo an ab e iagchulid.’ ");
INSERT INTO oodNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","K eda g iagchulidakud baꞌich d i si haꞌichu mo hi hegai mo an ab e iagchulid. ");
INSERT INTO oodNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","K heg wa wepo mam heg chehcheg iagchulidakud mam eda chehcheg g iagchulida. ");
INSERT INTO oodNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kum chehcheg g Jiosh mam eda chehcheg g geꞌe cheopi no pi heg d Jiosh kih. ");
INSERT INTO oodNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kum hab waꞌap chehcheg g Jiosh mam eda chehcheg g dahm kahchim. ");
INSERT INTO oodNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Im am hu hab wabsh i juhkch hegai mo d chum si haꞌichu am Jiosh chehanig ed mamt hab wabsh wo juhkchid g al chum haꞌichu. Neh, wehs am haꞌichu hemako tahpani mahk g Jiosh mo wehst‑mahm e tahpanch, chum hems g haꞌichu hahhag ch haꞌichu kai, ch wabshaba pi ap ha lodait ch pi ha hoꞌigeꞌid ch pi ab hu wohochud g Jiosh. T g Jiosh heg hekaj si s‑koꞌokam wo em‑namkid. ");
INSERT INTO oodNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Am am wabsh s‑nenꞌoid g al chuꞌuchum haꞌichu ch g geꞌeged haꞌichu pi chegito. Id o heg wa wepo mamtp hems wo oꞌos g e‑wasib mat am eda wo gei g al chukumug k wabshaba wabsh wo bah wehnadk g ka‑mihyo matp heg am eda wo gei. ");
INSERT INTO oodNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Baꞌich at wo i s‑koꞌokk g em‑namkidadag nam pi hi wa chum si s‑ap e chehgid. K wabshaba am em‑eda haꞌichug g pi amdag ch s‑chu daꞌadag. ");
INSERT INTO oodNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Am g wo i e kegchud e‑iꞌibdag ed. T g haꞌichu hab em‑juni am haha wo s‑apꞌek. ");
INSERT INTO oodNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Neh, nat hig pi wo i e kegch g hihaꞌini an e dahm, chum as am eda wo wehchk g ohꞌo ch jewalig? Pegih, m ahpim hab sha masma mo g hihaꞌini ");
INSERT INTO oodNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","nam pi ab chum e chehgidch mam d s‑apꞌekam. K eda g em‑chegitoi pi aꞌpe. Ih shoꞌig! Jiosh at si s‑koꞌokam wo em‑namkid. ");
INSERT INTO oodNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","31","“Em‑shohshon at muꞌi ha kokda g kekelibad Jiosh haꞌichu i tashogiddam. Kum ahpim si s‑kehg ha hehosid g ha‑hihaꞌiniga hegam mamt ha kokda ch hab chechꞌe mamt ahpim hi pi wo chum ha kokda. Dam s‑chu iꞌattomkam ch ha wepo masma mash wa g em‑shohshon. Ih, shoꞌig! Jiosh at si s‑koꞌokam wo em‑namkid namt pi am ha oidk hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","S‑ap amt wo nahto hegai mat g em‑shohshonbad i shonwuich. ");
INSERT INTO oodNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Damt wo ha muꞌakamk hab masma mo g kohkꞌoi ch hekaj pi hab mahs mams wo e doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pegih, nt wo em‑ahgi mant am i ha wuwhas g haꞌichu i tashogiddam ch s‑chu aꞌamichuddam ch ha mashchamdam am em‑shahgid. Kumt haꞌi wo ha gewitta am e‑chechopi ed k haꞌi an has wo ha shahmudahim k haꞌi wo ha kokda, chum hems ab ha sisishpk kots t ab. ");
INSERT INTO oodNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","T g s‑koꞌok em‑namkidadag ab em‑ab wo gei hemu s‑hohtam. Neh, Abelbad atsh wa wehpeg e muhkid. Tsh amjed muꞌi ep e koꞌij. Tsh ga hu si ha oidch hegai Zecariabad mash d Barackiabad alidag e muhkid am ha shahgid g geꞌe cheopi ch iagchulidakud, Kum ahpim ha wepo chuꞌijig hegam matsh wa ha kokda ch ha wepo masma wo bei g s‑koꞌok e‑namkidadag mamtp hedai ha wepo elid haꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","38","K hab ep kaij g Jesus, “Ih, shoꞌig, ahpim Jerusalem t am hemajkam, nat pi g Jiosh s‑ap wo em‑dagito. Em‑shohshon ash wa ha maꞌichshulig ch muꞌi ha kokda g Jiosh haꞌichu i tashogiddam. Kumt ahpim am ha oidk hab wo e juh. Muꞌikko ani chum tatchua mant wo si s‑ap em‑nuhkud hab sha masma mat g chuchul g e‑mahmad ab e wecho wo ha hemapai. M wabshaba pi ab hu tatchua manis hab wo em‑juh. ");
INSERT INTO oodNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","K eda an hab chuꞌig Jiosh oꞌohana ed mamt ab wo chum ni‑ihmad ch hab wo chechꞌed mat g Jiosh am ni‑kehsh k si s‑ni‑hoꞌigeꞌid. Kunt ia wo i s‑ap em‑dagito am hugkam mamt hab hahawa masma hab wo e juh.” ");
INSERT INTO oodNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kud gam hu hahawa i wuhsh g Jesus ab amjed g geꞌe cheopi. Kuchd am i oid k am wui dada k am aꞌaga mo si s‑kehg hab mahs g geꞌe cheopi. ");
INSERT INTO oodNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","D hab kaij, “Heuꞌu, woho o hi wa si s‑kehg hab mahs. Nt wabshaba si shel wo em‑ahgi mo e aihim mat wehs wo i e shul ihda.” ");
INSERT INTO oodNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kuchd amjed gam hu hejelko hihi wehmaj g Jesus k ab i chehchsh k ab dadhaiwua Olive Uꞌus Kawulk t ab. Kuchd hab ahg g Jesus, “Am g hig t‑ahgid mas hekid hab wo i e juh hegai map am t‑ahgid. Kut haschu d wo chehgidak matt heg ab wo s‑mahchk mo e aihim mapt ep wo jiwia. T g jewed wo huhug.” ");
INSERT INTO oodNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","D hab kaij g Jesus, “Mt wo si s‑e nenꞌoidad mat pi hedai wo em‑iattogi. ");
INSERT INTO oodNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Muꞌi at an wo i wuwha aꞌahidag oidam k ni‑wepo wo e chehcheg hab kaijch mo d Jiosh si Kehsha. Kut muꞌijj ab wo s‑ha wohoch. ");
INSERT INTO oodNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","7","T g nahnko mahs hemajkam ch jejewed ab aꞌai wo i e checheggia. Mt wabshaba pi wo e totods. Hemho wa at hab wo e juh hab masma. K wabshaba pi hab d ahga mat e ai mat wo kuhgit. Bihugig at wo gehsh k g jewed wo uꞌugij muꞌikpa. ");
INSERT INTO oodNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Id at d wabsh wo shohshonajk g shoꞌigdag nat pi baꞌich wo i geꞌeda. ");
INSERT INTO oodNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“T wo e ai mamt am wo em‑uꞌu k wo em‑dagito mamt wo em‑shoꞌigchud k wo em‑kokda. Wehsko jejewed dakam hemajkam at wo s‑em‑kehꞌidad ni‑hekaj. ");
INSERT INTO oodNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Muꞌijj at wo ni‑dagito heg hekaj k wo aꞌai e gagda k wo s‑e kehꞌidad. ");
INSERT INTO oodNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Muꞌi at an wo i wuwha g s‑chu iꞌattomkam k hab wo e aꞌagad mo d Jiosh haꞌichu i tashogiddam. T muꞌi hemajkam ab wo s‑ha wohoch. ");
INSERT INTO oodNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pi apꞌekam at wo i geꞌeda. T muꞌijj wo huhug g pihk ha‑elidadag ab aꞌai e wui. ");
INSERT INTO oodNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","“Mt wo sha e nakog k wo gahi wuwha g e‑shoꞌigdag. T g Jiosh am wo i em‑wahpki e‑kihdag ed. ");
INSERT INTO oodNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ihda s‑kehg haꞌichu ahgaj g Jiosh ab amjed g kownaltaligaj at an wehsko wo e ah jewed dahm. T am haha wo e ai mat wo kuhgit. ");
INSERT INTO oodNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Am g wo amichud ihda mam in neꞌokchulid. Hegai Danielbad mash d Jiosh haꞌichu i tashogiddam at an oꞌoha mat g em‑obga am wo i kei g s‑uam haꞌichu ged hu si eda g geꞌe cheopi. ");
INSERT INTO oodNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kut hemho wa am wo ahhio dohdaꞌag wui hegam mat hedai ia wo haꞌichugk Judea jewed ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","18","Kut pi hedai am hu wo shaꞌi chum i wah e‑kih ed mat am wo haꞌichu ui, chum as hems imhab wo waꞌi oimmedad e‑kih wehgaj o am wo chikpanad oidag ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","S‑ta at ehbidam wo mahsk am ha wehhejed hegam mat wo chuꞌuchum mahmadk ch hegam mat wabsh wo kia woꞌok g ali. ");
INSERT INTO oodNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Mt ab wo tahnid g Jiosh mat pi eda hab wo e juh ihda em‑mihshmda tash ed o g s‑hehpichꞌed. ");
INSERT INTO oodNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Baꞌich at d wo i si geꞌe shoꞌigdagk mo pi hekid g hemajkam shaꞌi neid ch pi hekid hab masma ep wo nei. ");
INSERT INTO oodNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pi at hedai wo e nako mas am gahi wo wuhsh hegai shoꞌigdag matp tash wo hih. T g Jiosh heg hekaj wo i shopolkai am ha wehhejed g e‑hemajkamga. ");
INSERT INTO oodNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Pi g wo shaꞌi ha wohochud matp hema hab wo sha chei mo am hebai haꞌichug g Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Muꞌi at in wo i wuwhag k hab wo chei mo d ni‑ahni Jiosh si Kehsha o d Jiosh haꞌichu i tashogiddam k am hab wo wuad g s‑hasig haꞌichu mat hekaj wo i chum ha wanchshul g Jiosh hemajkamga matp wo e nako. ");
INSERT INTO oodNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Neh, ni heki hu am em‑ahgid mamt hekaj wo s‑e nenꞌoidk. ");
INSERT INTO oodNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Tp hems haꞌi hab wo chei mo am haꞌichug g Jiosh si Kehsha tohono jewed ch ed o am hebai e ehstokch. Kumt wabshaba pi wo ha wohochud k pi am hu wo chum hihi. ");
INSERT INTO oodNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wehsko ant wo ni‑chehgi mant hekid ep wo jiwia jewed dahm ahni Jiosh si Kehsha hab sha masma mat g wepgi s‑masma an gahi wo kekiwua chewagi ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Neh, s‑mahch am mat hebai wo woꞌok g haꞌichu muhkig an wabsh ha neidch g nunuwi mat am wo e chehm. Pegih, mt hab waꞌap s‑ap wo s‑mahchk mant hebai wo haꞌichugk.” ");
INSERT INTO oodNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","D hab ep kaij, “T am wabsh wo i chum kuhgi hegai jewed shuhdgim shoꞌigdag. T g tash tonlig wo huhug. T g mashad ep pi wo ha ton. T g dahm kahchim wo ugij. T g huhuꞌu wo i shul. ");
INSERT INTO oodNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nt ab haha wo i ni‑chehgi ab dahm kahchim t amjed k wo jiwia. T wehs hemajkam wo si shoanid ab i ni‑neidok. Nt si s‑masma ab wo hudunihi chewagi ch ed. Kut am wo e maskogi g ni‑gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","T ab si s‑kaidam wo e kuhu g kuikud. Kunt wo ha cheha g ni‑anghiliga mat ab wehs wo i ha hemapai hegam mant am i ha chuhcha mat wo e doꞌibia. T am wo hihi imhab siꞌal tahgio ch imhab hudunig tahgio ch imhab wakolim tahgio ch imhab juhpin tahgio k wo ha hemapai.” ");
INSERT INTO oodNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nt wo haꞌichu em‑mashcha heg hekaj suhna uhs. Mt wo s‑mahchk mo g toniabkam e aihim mamt wo nei mat ab wo i iꞌiwgi. ");
INSERT INTO oodNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pegih, mt hab waꞌap wo s‑mahchk mo e aihim mat wehs wo kuhgit mamt wo nei mat hab wo e juh hegai mani em‑ahgid. ");
INSERT INTO oodNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nt wo si shel em‑ahgi mat d wabsh wo kia dodakamk hegam mat wo nei ihda mani em‑ahgid mat hekid wehs wo kuhgit. ");
INSERT INTO oodNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Neh, wehs at gam hu hab wo i e juh ihda Jiosh nahtoi mam in neid. T wabshaba g ni‑neꞌoki pi hekid gam hu hab wo i e juh.” ");
INSERT INTO oodNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","D hab ep kaij, “Heg o waꞌi s‑mahch ni‑ohg Jiosh mant hekid ep wo jiwia. Pi o hedai ep s‑mahch, chum hems g anghil nih ahni mani d hi wa chum alidaj. ");
INSERT INTO oodNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bat wo masmak haꞌichu mant hekid ep wo jiwia mash wa hab chuꞌig mash eda g Noahbad in d doakam. ");
INSERT INTO oodNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hemajkam ash wa gam hu wabsh i si nenead ch e gegosid ch ihꞌed ch e hohont ch gam hu wabsh i pi chegito g Jiosh. T haha wabsh e ai g tash mat hegam Noahbad am i wahp geꞌe wahlko ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kut wehs ha wiꞌin g hemajkam k ha hugio. Kut hab wo wa masmak mant hekid ep wo jiwia. ");
INSERT INTO oodNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Neh, gohkajj at am wo chikpanad oidag ch ed. T hema gam hu wo i e be k hema am wo wa i e wuiok. ");
INSERT INTO oodNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Gohk uꞌuwi at am wo haꞌichu chuꞌad. T hema gam hu wo i e be k hema am wo wa i e wuiok. ");
INSERT INTO oodNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Pegih, mt wo si s‑e nenꞌoidad. Pi o ta machima am em‑wehhejed mant haschu tash ed ep wo jiwia ahni em‑kownalig. ");
INSERT INTO oodNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Neh, pi o ta machima mas hekid hema wo jiwia g s‑chu ehskam. Kum heg hekaj chum hekid nuhkud g e‑kihdag. ");
INSERT INTO oodNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pegih, k hab waꞌap pi ta machima em‑wehhejed manis hekid wo uhpam jiwia jewed wui ahni Jiosh si Kehsha. Mt heg hekaj wo si e nahtokchid chum hekid. ");
INSERT INTO oodNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Chum amt hedai wo e nahtokch mamtp wo s‑wapagimak ch wo s‑chu aꞌamichudad. S‑mahch am mat g ha‑ahmo hema wo e‑gahgi g hab mahs pion k wo nuhkudach g e‑kihdag. T heg s‑ap wo ha chikpanchudad ch wo ha dagioꞌidad g e‑wehm pion mat eda pi an hu wo haꞌichugk g ha‑ahmo. ");
INSERT INTO oodNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","T am ep wo jiwia k wo cheh mo s‑ap am hab junihim g e‑chikpan. Kut d wo si geꞌe s‑hehgigk heg wehhejed pion. ");
INSERT INTO oodNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nt wo si shel em‑ahgi mat g ahmoj am hahawa wehs dahm wo kei g e‑kihdag. ");
INSERT INTO oodNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“T wabshaba pi ap d wo ha kehshak matp hedai hab wo i e ah, ‘Pi at oi wo jiwia g ni‑ahmo,’ ");
INSERT INTO oodNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","k wo i ha shoꞌigch g e‑wehm pion k g s‑iꞌimkam ha wehm wo ihꞌed ch wo e gegosidad. ");
INSERT INTO oodNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","T haha wabsh wo jiwia g ahmoj k wo cheh mo pi ap hab wua g e‑chikpan ");
INSERT INTO oodNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","k wo si s‑koꞌokam namkid k gam hu hab wo i juh. Neh, bat wa masma hab wo e juh ha wehhejed hegam mat pi ab hu wo wohog elidad g Jiosh. Heg at s‑koꞌokam wo ha namkid. Kut heg hekaj wo shoakad ch ga hu wabsh wo i si e kiꞌishch.” ");
INSERT INTO oodNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","D hab ep kaij g Jesus, “Baꞌich ant am wo i em‑tashogi g Jiosh kownaltalig am wepogidch hegai kih mat hebai haꞌi wo e hohont. Mt am haꞌi ha wai wehst‑mahm chetcha. T am hihi ha uꞌadch g e‑lalampa k am wo i wahp g wo ha hohntam wehm mat hekid wo jiwia. ");
INSERT INTO oodNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hetasp idam o pi haꞌichu nenꞌoid ");
INSERT INTO oodNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ch ep pi ha waꞌigchug g a‑saidi. ");
INSERT INTO oodNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hetasp o s‑chu nenꞌoid ch ep ha waꞌigchug g a‑saidi. ");
INSERT INTO oodNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kut pi oi jiwia g wo ha hohntam. T wehsijj s‑ha kohksimch idam chetcha. T gam hu kohk. ");
INSERT INTO oodNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Neh, t am i e ai g eda hugkam g s‑chuhugam. T ab kaida ihda, ‘Ab o him g wo ha hohntam. Oi g wo i hihim k ab wo namkhi.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","T hegam wehst‑mahm chetcha nehnen k i ha kegchud g e‑lalampa. ");
INSERT INTO oodNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“K hab kaij hegam mo pi haꞌichu nenꞌoid, ‘Ab g wo i ha t‑mahki g e‑a‑saidiga. Chuhchkim o g t‑lalampa.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“K hab kaij hegam mo s‑chu nenꞌoid, ‘Pi att wo t‑nako. Am o wabsh i hejel t‑wehhejed ahim am shuhdagi ch pi wo em‑ai. Am amt wo hihi tianna wui k am hejel wo ha nolawt.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“T wa woho hab e juh hegam haꞌi k gam hu hihi mat wo ha nolawt g a‑saidi. Kut eda ia hu ha oidk jiwia g wo ha hohntam. Kut hegam hetasp mo e nahtokch gam hu wehmaj i wahp mat am wo e gegos wehmaj. T ab si e kuh g kihjeg. ");
INSERT INTO oodNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“T am i uhpam dada hegam haꞌi k ab chum shoani ch hab kaij, ‘Ab g si s‑t‑hoꞌigeꞌid k ab i kuhpiꞌoki matt am wo i wahp.’ “K hab kaij g wo ha hohntam, ");
INSERT INTO oodNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","‘Nt wo si shel em‑ahgi mani pi shaꞌi em‑mahch mams hedai wud,’ ch am hahawa si kuh g kihjeg.” ");
INSERT INTO oodNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Neh, d am i kuhgit g e‑wepogida g Jesus hab kaijch, “Neh, mt wo s‑e nenꞌoidad nam pi pi shaꞌi mahch mant hekid ep wo jiwia. ");
INSERT INTO oodNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Bant masma ep wo i wepogi g Jiosh kownaltalig matp hems g oꞌodham hema hasko wo him k ab i ha wai g e‑pionag mat ab wo ha nuhkudach g haꞌichu e‑eniga. ");
INSERT INTO oodNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hema at mah g hetasp mihl pihsh k hema gohk mihl pihsh k hema ep g hemako mihl pihsh no pi s‑mahch mat heꞌekia i s‑ap wo chikpanad k amjed gam hu mehk jewed wui hih. ");
INSERT INTO oodNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Hegai piongaj mat g hetasp mihl pihsh ab ui at am ha hekaj i e nakog k hekaj ihda lial mat am dahm hetasp mihl pihsh ep nahto. ");
INSERT INTO oodNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kut hegai mat g gohk mihl pihsh ab ui hab waꞌap e juh k gohk mihl pihsh am dahm nahto. ");
INSERT INTO oodNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","T wabshaba hegai mat g hemako mihl pihsh ab ui gam hu him k am hebai wagt k am ehsto. ");
INSERT INTO oodNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“K mehk amjed mat jiwia g ha‑ahmo idam k am ha ui mat wo s‑mai mat has masma hekaj g lialigaj. ");
INSERT INTO oodNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“Hegai piongaj mat g hetasp mihl pihsh ab ui at ab i wah k ab i mah g hetasp mihl pihsh am dahm hegai mat ab ui k hab kaij, ‘Ab apt wa ni‑mah g hetasp mihl pihsh. Neh, nt am baꞌich hetasp mihl pihsh ab ep wo m‑mah mant nahto.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“K hab kaij g ahmoj, ‘S‑ap aptki hab e juh, s‑apꞌekam ni‑pionag, s‑ap hekajk mant heꞌekia ab i m‑mah. Nt hekaj ab baꞌich i muꞌi wo m‑nuhkudach. Am g ni‑wehm s‑hehgigkad.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“T heg ab hahawa ep i wah piongaj mat g gohk mihl pihsh ab mah k hab kaij, ‘Neh, gohk mihl pihsh apt wa ab ni‑mah. Kunt am baꞌich gohk mihl pihsh ab ep wo m‑mah mant nahto.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“K hab kaij g ahmoj, ‘S‑ap aptki hab e juh, s‑apꞌekam ni‑pionag, s‑ap hekajk mant heꞌekia ab i m‑mah. Nt hekaj ab baꞌich i muꞌi wo m‑nuhkudach. Am g ni‑wehm s‑hehgigkad.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“T ab hahawa i wah hegai piongaj mat g hemako mihl pihsh ab mah k hab kaij, ‘Ni‑ahmo, s‑mahch ani map s‑ta keꞌidama ch s‑beihimk hegai map haschu pi ab hu chikpan. ");
INSERT INTO oodNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kunt heg hekaj gam hu s‑aꞌagko eꞌesto g m‑lialiga. Neh, m ia wehch mo haschu d m‑eniga.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“K hab kaij g ahmoj, ‘Si pi ap ch s‑padmakam ni‑pionag, kups wa chum s‑mahch mani s‑ta keꞌidama ch s‑beihimk hegai mani haschu pi ab hu chikpan. ");
INSERT INTO oodNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pegih neh, pt hems am hi wo wa chum toa g ni‑lialiga wahnko ch ed. Kunt ab wehs uhpam wo ui wehnadk mat haschu ab wo i mahmadt.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“K hab hahawa ha ahg g haꞌi ep e‑pionag, ‘Mt wo wohppoꞌid k ab wo mah hegai mo wehst‑mahm mihl pihsh edgid. ");
INSERT INTO oodNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Baꞌich at ep wo nei g e‑apꞌedag hegam mat hedai s‑ap wo hekaj. T wabshaba wo e wohppoꞌidach mo haschu al i edgid hegam mat pi ap wo hekaj. ");
INSERT INTO oodNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mt gam hu wo daꞌich hegai s‑padmakam pion s‑chuhugam k ed. T am wo si shoakad ch ga hu wabsh wo i si e kiꞌishch nat pi wo shaꞌi si s‑koꞌok haꞌichu nakogad.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“An ant wo dahiwua ni‑kownal daikud an mant hekid wo i jiwia ha wehm g ni‑anghiliga. ");
INSERT INTO oodNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","T wehs hemajkam am wo e hemapai ni‑baꞌich. Nt ab wo i ha gawulkai hegam mo d wohokam ab ha amjed hegam mo pi d wohokam hab masma mamt am wo i ha gawulkai g kahwal ch siswat. ");
INSERT INTO oodNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","Bant wo ha ahgi hegam mant ab i ha gawulkai, ‘Ab g wo i hihim. S‑em‑hoꞌigeꞌid o g Jiosh. Ni‑gegos amt mani wa d bihugimkam k ni‑wasibi mani wa d tonomkam k am i ni‑wahki e‑kih ed mani wa d wabsh ge oꞌodham k ni‑enigadad mani wa pi haꞌichu edgid k ni‑nuhkud mani wa mumku k am ni‑chechga mani wa d lihso. K g Jiosh am nahtokch g kihdag em‑wehhejed ga hu i amjed mat in i nahto g jewed. Ab g wo i wahpkid k wo edagi.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","39","“Kut hab wo chei ab ni‑wui, ‘T‑kownalig, kuchs hekid i m‑gegosid k m‑wasbid k ab i m‑wahki t‑kih ed k ab m‑enigadad k m‑nuhkud k am m‑chechga?’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Nt hab wo chei, ‘Nt wo si shel em‑ahgi mam ahni am i ni‑wehmt hekid am i ha wehmtch hegam mo d shoꞌigkam ch ab ni‑hiwig.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","43","“Kunt hab haha wo chei ab ha wui hegam mant pi ab hu i ha gawulkai, ‘Gam g hu hab wo i e juhni. Ab o em‑mohtoꞌid g Jiosh g s‑koꞌok namkidadag. Pi amt ni‑gegos mani wa d bihugimkam k pi ni‑wasibi mani wa d tonomkam k pi am hu i ni‑wahki e‑kih ed mani wa d ge oꞌodham k pi ab hu ni‑enigadad mani wa pi haꞌichu eniga k pi ni‑nuhkud mani wa mumku k pi am hu ni‑chechga mani wa d lihso. Neh, am amt wo e shul heg eda mehi mo d ha wuikam g jijawul.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kut hab wo chei hegam ab ni‑wui, ‘T‑kownalig, ch hekid i m‑neid maps d bihugimkam o d tonomkam o d ge oꞌodham o pi haꞌichu eniga o mumku o d lihso, kuchs pi am hu i m‑wehmt.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Nt hab wo chei, ‘Nt wo si shel em‑ahgi mam ahni pi am hu i ni‑wehmt, hekid pi am hu i ha wehmtch hegam mo d shoꞌigkam ch ab ni‑hiwig.’ ");
INSERT INTO oodNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kut idam am wo e shul pi ha huhugedam s‑koꞌok namkidadag ed. T g s‑apꞌekam an wo i wahp anai mat an hahawa chum hekid wo edgidad g s‑apꞌekam doakag.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","D am i haꞌasa haꞌichu ha mashcha g Jesus k hab hahawa kaij ab t‑wui, ");
INSERT INTO oodNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“S‑mahch am mo gohk tash am wiꞌis matt wo wuhshad mat g Jiosh ha doꞌibia g t‑shohshonbad. Kutki hab wo e juh mat an wo ni‑bei hegam mo ab ni‑wui gegok k ab wo ni‑naggia kots t ab mat wo ni‑mua.” Neh, heg o hab waꞌi kaij. ");
INSERT INTO oodNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kumsh eda woho aꞌaga mamtsh has masma wo be k wo mua. Si uhgchu pahl atsh am i ha hemapai hegam haꞌi uꞌugchu papal ch geꞌeged. Kutsh ab kihj ab nam ");
INSERT INTO oodNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","k am apꞌech mat s‑aꞌagi an wo bei g Jesus k wo mua, ");
INSERT INTO oodNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ash am wabsh aꞌai e ahgid, “Hi wa pi am hu heg eda mat ia wo e hemapadch g hemajkam id hekaj piast. T wo am hu e babgachud k wo t‑cheggia.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kuchd am hu hebai am dada Bethany kihhim t am. D am d kihkam hegai mad hab chehgig Simon ch wa chum mumku heg hekaj mo g chuhkugaj wabsh muhkhim. ");
INSERT INTO oodNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Id ad ab i t‑waid k t‑gegos. Kuchd am dadhak ch t‑gegosid. T ab haha wabsh hema i wah g uwi g si s‑namkig s‑ap uhw shuhdagi waꞌigchugch am al s‑toa hodai haꞌa ch ed k ab iawua Jesus moꞌo ab. ");
INSERT INTO oodNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kud haꞌi si pi hohhoꞌi g t‑wehm e mashchamdam k hab kaij, “Ih, pt wabsh heki wua ihda s‑namkig haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Eda atp huꞌi muꞌi lial wo nam sha e gagdak. T heg wo e hekaj ha wehhejed g shoꞌigkam.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kud s‑mahch g Jesus mach haschu am aꞌaga ch hab kaij ab t‑wui, “Pi g am wo shaꞌi kehꞌidad ihda uwi. Si at s‑kehg haꞌichu hab juh am ni‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mt wabsh chum hekid wo i ha wehmt g shoꞌigkam. Kunt ahni hi pi tash ia hu wo em‑shahgidk. ");
INSERT INTO oodNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ab at iawua g uhw shuhdagi mat wo i nako g ni‑honshpadag hiashpa. ");
INSERT INTO oodNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nt wo si shel em‑ahgi mat am wo s‑e chegitok mat haschu has juh ihda uwi mat hebai wo i e ahgachugad g s‑kehg haꞌichu ahgaj g Jiosh an wehsko jewed dahm.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","D am ha hekaj t‑dagito g Judas Iscariot k gam hu hih. Kuchd am i dahm s‑mai matsh am hih uꞌugchu papal ha wui ");
INSERT INTO oodNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ash hab kaij, “Heꞌekia amt wo i ni‑namkid mant an wo em‑behi g Jesus?” Kutsh am chehgid k kuint g waikko wehst‑mahm plahda pihsh matsh id wo mah. ");
INSERT INTO oodNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tsh ab i amjed g Judas am i e nako matsh wo gagda g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","D am hahawa s‑ap i e ai hegai t‑shohshonbad ha doꞌibiadag piast. K id eda pi e koꞌa hegai pahn mo jewajidas. Kud d wehpeg tash heg eda gegosig. Kuchd am dada Jesus wui k ab kakke machs hebai wo i apꞌech matt am wo huh g kahwal mad iagchulig gegosig. ");
INSERT INTO oodNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","D gohkajj hab t‑ahg, “Am amt wo hihi Jerusalem wui. K am hema d kihkam ch am wo e chehgi. Mt hab wo ah mani hab kaij mat e ai g ni‑tashga. Kutt t‑wehm wo huh g kahwal mad iagchulig gegosig am kihj am.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kud am hab e juh mad hab ha ahg g Jesus k am i apꞌech g gegosig. ");
INSERT INTO oodNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","D am i hud. Kuchd am dadhaiwua k am t‑gegosid. ");
INSERT INTO oodNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kud hab haha wabsh kaij g Jesus, “Nt wo si shel em‑ahgi mat has wo e juh hemu. Hema amt wo ni‑gagda ahpim mam ab si ni‑wecho e mashcham.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kuchd si pi ap t‑taht k gan hu hab i cheꞌiatahi, “Ih, hi wa pi ahni, ni‑kownalig.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","D hab kaij g Jesus, “Heg at hab wo juh mat hedai am ni‑wehm wo wakch g chemait hidod ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Bant masma wo ni‑muhkid mo has masma heki hu oꞌohanas Jiosh oꞌohana ed mat g si Kehshaj wo e muhkid. T wabshaba wo si s‑koꞌokam e namkid hegai mat wo ni‑gagda. Baꞌich at wo i chum s‑apꞌek heg wehhejed mat hems wabsh pi wo chum mahsi.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","D hegai Judas matki gagda hab kaij, “Aha nap ahni hab ni‑ahg, t‑mashchamdam?” D hab kaij g Jesus, “Dap ahpi.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Chd am wabsh kia t‑gegosid. D g Jesus am bei g chemait k ab hoꞌigeꞌel g Jiosh k am hahawa i hahain k ab t‑mah k hab kaij, “Oi g wo huhgi ihda. Do ni‑honshpadag.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","D am hahawa bei g tahsa k ab ep hoꞌigeꞌel g Jiosh k ab t‑mah g wasib k hab kaij, “Wehsijj g ab wo ihꞌe. ");
INSERT INTO oodNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Id o d ni‑ehꞌed. Id ani hab ahgch hab kaij mant wo ni‑muhkid em‑wehhejed. T g ni‑ehꞌed wo e iawua. T g Jiosh heg hekaj am hab wo juh hegai mo wa hab kaij mat gam hu hab wo i juh g pi ap ha‑chuꞌijig g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ia o i s‑apꞌe. Kunt pi hekid em‑wehm hab ep wo juh ihda k wabshaba em‑wehm wo si s‑hehgigk Jiosh kihdag ed.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Neh, kuchd am hahawa kuhgit am hema ahgk g mihshmda neꞌi k am wuwhag k gam hu hihi Olive Uꞌus Kawulk wui. ");
INSERT INTO oodNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","D hab t‑ahg g Jesus, “An o oꞌohanas mo hab kaij g Jiosh: Nt wo hiwigi mamt wo mua g kahwal ha nuhkuddam. T g kahwal wabsh aꞌai wo wohp. K id hab d ahga mamt wehsijj wabsh wo ni‑dagito k gam hu aꞌai wo wohp mant hekid wo ni‑muhkid. ");
INSERT INTO oodNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kunt wabshaba ep wo ni‑chegito k gam hu wo hih Galilee wui. Mt ab haꞌab wo ni‑nei.” Neh, bad kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","D g Peter hab kaij, “Ahni ant hi pi hekid wo shaꞌi m‑dagito, chum as wehsijj wo m‑dagito idam.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","D hab kaij g Jesus ab wui, “Nt wo si shel m‑ahgi mat koi wo kuhu g keli chuchul id i chuhug ab. Kupt waikko hab wo waꞌi chei map pi shaꞌi ni‑mahch.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","D hab kaij g Peter, “Pi ant hekid hab wo shaꞌi chei manis pi m‑mahch, chum anis wo ni‑muhkid m‑wehm.” Kuchd wehsijj hab waꞌap kaij. ");
INSERT INTO oodNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kuchd ged hu dada heg ab oidag mo hab e aꞌaga Gethsemane. D pi am hu t‑wehmaj g Judas Iscariot. D hab kaij g Jesus ab t‑wui, “Ia g hu wo i dadhak. Nt ahni am baꞌich wo i him k wo ni‑hoꞌigeꞌidahu.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Bad kaij ch am ha uꞌuk g Peter ch James ch John. T idam gam hu oi. Kush s‑masma si pi ap e tahtk g Jesus ch si e kudut ");
INSERT INTO oodNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ch hab kaij ab ha wui, “Ab at wabsh i si ni‑shuhd g pi ap tahhadkam ch si s‑ni‑mukima tahhadchud. Ia g wabsh wo dadk ch wo haꞌichu si nenashanad.” Kutsh am dadhaiwua. ");
INSERT INTO oodNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tsh g Jesus baꞌich ep shaꞌi him k am i gei jewedo k hab kaij ab Jiosh wui, “Ni‑ohg, matp am wo s‑apꞌek, pt im hu hab wo i juh hegai si s‑koꞌok shoꞌigdag mo ab ni‑wui him. Kuni eda tatchua mat ahpi g m‑tatchui hab wo e juh.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tsh am hahawa uhpam ep jiwia ha wui hegam waik. Kush am kohksh. Sh hab kaij ab ha wui, “Pi amtki shaꞌi e nako mamt wo ni‑wehm nenead al hemako ohla ab. ");
INSERT INTO oodNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Si g wo haꞌichu nenashanad ch ab wo tai g Jiosh g gewkdag mamt pi am hu wo shul pi apꞌekam ch ed. Chum am hi wa g s‑apꞌekam hab elid ch eda pi e nakog.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bash kaij ch amjed gam hu hahawa ep him k hab kaij ab Jiosh wui, “Ni‑ohg, am o wa s‑apꞌe ni‑wehhejed matp d wo m‑tatchuik mant hemho wa wo nako ihda si s‑koꞌok shoꞌigdag.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Neh, k am hahawa uhpam ep jiwia ha wui. Kush ep kohksh no pi shaꞌi s‑ha kohksimchud. ");
INSERT INTO oodNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tsh gam hu hahawa ep hih g Jesus k heg hab kaij ab Jiosh wui matsh wehpeg ");
INSERT INTO oodNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ch am hahawa uhpam ep jiwia ha wui k hab kaij, “Kumtki ep kohk. T eda e ai mamt ni‑gagda ahni Jiosh si Kehsha am ha wui g pi apꞌekam hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Oi g wo wahpamigi. Tt wo hihi. Neh, ia at hu jiwia hegai mat ni‑gagda.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Am ad wabsh kia neok. Kud am jiwia g Judas. D shaꞌi si muꞌijj wehmaj, haꞌijj g iꞌis‑papayo uhꞌukch ch haꞌijj g uꞌus. Idam atki g uꞌugchu papal ch geꞌeged am ha cheha matsh am wo hihim k wo bei. ");
INSERT INTO oodNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kuki eda g Judas heki hu ha ahgid idam mo am wehmaj mat ab wo chintad g Jesus kahmaj ab. T hab masma wo s‑mahchk mat hedai an wo bei. ");
INSERT INTO oodNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","D am wabsh i chum jiwia g Judas k wabsh shel i hih ab Jesus wui k hab kaij, “Jiosh at wo s‑m‑hoꞌigeꞌel, ni‑mashchamdam!” Neh, bad cheꞌe k ab chintad. ");
INSERT INTO oodNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","D hab kaij g Jesus ab wui, “Ih, ni‑nawoj, oi g s‑hohtam am hab juhni hegai mapt haschu ahgk ia jiwia.” Kud ab haꞌi hihim k an bei g Jesus k gan hu si s‑wihnam uꞌukch. ");
INSERT INTO oodNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kud hema g t‑wehm e mashchamdam am i wuhshad g e‑is‑pahyo k ab si gehg g neholigaj g uhgchu pahl k an si hikuch g nahkaj. ");
INSERT INTO oodNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","D hab kaij g Jesus ab wui ihda, “Ga g hu uhpam kehsh g e‑is‑pahyo. Hegam mat wo hekaj g is‑pahyo at heg hekaj hab waꞌap wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aha nap pi mahch mantp ab wo tai g ni‑ohg, t ha hekaj wo ha cheha g shaꞌi si muꞌi mihl anghil mat ni‑wehhejed wo ha cheggia. ");
INSERT INTO oodNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","K wabshaba an hab chuꞌig Jiosh oꞌohana ed mat hemho wa am ni‑tahgio hab wo e juh ihda mo hab e wua.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Neh, bad kaij g Jesus ch hab hahawa ha ahg hegam mat an bei, “Wehs tashkaj ani am dahiwup ch ha mashcham geꞌe cheopi t am. Kumt pi an hu ni‑be k wabshaba hahawa ia dada an uhꞌukch g iꞌis‑papayo ch uꞌus mamt wo ni‑bei. ");
INSERT INTO oodNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pegih, bat wa masma an heki hu oꞌoha g kekelibad Jiosh haꞌichu i tashogiddam mant hab masma an wo ni‑behij mat g pi ap hemajkam.” Neh, bad kaij g Jesus. Kuchd am haha wabsh i dagito k gam hu si aꞌai wohp. ");
INSERT INTO oodNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kumtsh am i bei g Jesus heg kih wui uhgchu pahl mo hab chehgig Caiaphas. Tsh eda am heki hu i e hemapai g chehanig t‑mashchamdam ch geꞌeged. ");
INSERT INTO oodNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Sh g Peter ga hu wabsh mehkjed ha oid ch am i wah kolhai ch ed. Sh am haꞌi dadha g ha‑pionag. Tsh g Peter am ha wehm i dahiwua s‑neidamkch mams has wo juh g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sh g uhgchu pahl ch hegam e jehnigiddam am chum i e nakog mat g iattogi haꞌichu ab wo abch g Jesus mat heg hekaj wo mua. ");
INSERT INTO oodNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kutsh muꞌi ehp am i gegokiwua k ab haꞌichu chum abch. Sh wabshaba pi e wepot g haꞌichu ha‑ahga. Tsh am hahawa gohkajj i gegokiwua ");
INSERT INTO oodNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","k hab kaij, “Ihda oꞌodham o hab kaij matsh wo e nako mat wo i wua g Jiosh geꞌe cheopiga. Tsh am d wo i waik tashk, tsh am uhpam ep wo kei.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tsh am hahawa kekiwua g uhgchu pahl k hab kaij ab Jesus wui, “Napt pi am hu has wo chei heg amjed mam ab m‑abchud?” ");
INSERT INTO oodNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kush wabshaba g Jesus pi has shaꞌi kaij. Tsh am ep neo g uhgchu pahl k hab kaij ab wui, “Am g t‑ahgid g wohokam am tahgio g Jiosh. Nap hab e elid map ahpi d Jiosh alidag matp am t‑dahm wo i e kei?” ");
INSERT INTO oodNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sh hab kaij g Jesus, “Dani ahni. Kunt ab ep wo em‑ahgi mat g Jiosh am wo e chehgi mo ab si has ni‑elid an e‑hugid an ni‑dahshk e‑kownal daikud ed. T am wo i e ai mant ab wo i hud chewagi ch ed k am ep wo jiwia jewed dahm. Kumt wehsijj wo s‑mai mani d ahni.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tsh g uhgchu pahl ab si wantsh g e‑eniga no pi si pi hohhoꞌid g neꞌokij k hab kaij, “Pi ach hedai ep shaꞌi tatchua mas am wo ah g chuꞌijigaj. Am am wa kah g pi kehg neꞌokij. ");
INSERT INTO oodNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Shahm i elid?” Kush hab kaij g e jehnigiddam, “Ab at moht g chuꞌijig am hugkam mat hemho wa wo e muhkid.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tsh idam ab si siswua wuhioshaj ab k an si maꞌishk wuh g wuhpuij k ab si shonikkash ");
INSERT INTO oodNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ch hab ahg, “Am g hig t‑ahgid mas hedai ab m‑shonikka, ahpi Jiosh si Kehsha e ahga.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sh eda g Peter am daha kih bahsho. Kutsh am hema jiwia g uwi piongaj g uhgchu pahl k hab kaij ab Peter wui, “Ahpi ap ep wehmaj hegai Jesus.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tsh wabshaba g Peter pi mahch k e ah g Jesus am ha tahgio hegam mo am dadha hab kaijch, “Pi ani shaꞌi mahch maps haschu hab ahg.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bash kaij ch ha hekaj gam hu hih mash am haꞌi gegok kolhai kihjeg t ab. Kush hema hab ep kaij ab ha wui, “Id o ep wehmaj hegai Jesus.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kutsh ep pi e edagi g Peter hab kaijch, “Do si wohokam mani pi shaꞌi mahch hegai oꞌodham.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kutsh shaꞌi haꞌas, tsh hegam chechoj mo am gegok am dada Peter wui k hab ahg, “Pi g shaꞌi pi e edgid. Dapki woho hema hegam Jesus. Ab ap wabsh e ahgch e‑neꞌoki ab map d ha wehm oꞌodham.” ");
INSERT INTO oodNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tsh g Peter am ha hekaj si ha ahgi, “Pi ani shaꞌi mahch ihda oꞌodham mam an aꞌaga. T g Jiosh wo si ni‑jehkaꞌich mantp em‑iattogid.” Tsh am hahawa hema si kuhu g keli chuchul. ");
INSERT INTO oodNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tsh am ha hekaj i chegito g Peter mo wa g Jesus ab wui hab kaij, “Pi at koi wo kuhu g keli chuchul. Kupt waikko hab wo waꞌi chei map pi shaꞌi ni‑mahch.” Tsh gam hu wuhsh g Peter k si pi ap e tahtk ch shoak. ");
INSERT INTO oodNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tsh am wabsh i chum mahsi. Tsh am hahawa i apꞌech g uꞌugchu papal ch geꞌeged mat wo e muhkid g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tsh am i e kuhgit g ha‑namki. Kutsh am si i maniadad g nohnhoij g Jesus k gam hu i wanim matsh am wo i bei heg wui mo d kownal heg eda chekshani ch hab chehgig Pilate. ");
INSERT INTO oodNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sh eda g Judas an himad ch ha neid. Sh am wanimed g Jesus kownal wui mat wo e muhkid. Kutsh si e tods g Judas k am him k am uhpam i ui hegai waikko wehst‑mahm plahda pihsh ha wui g uꞌugchu papal ch geꞌeged ");
INSERT INTO oodNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","k hab kaij, “Tki wo e muhkid hegai mo pi ha chuꞌijig. K d ni‑chuꞌijig nant pi ab em‑wui gagda.” Sh hab kaij hegam hahaꞌichu, “Pi ach has shaꞌi elid hegai. Heg o ahpi ab m‑ab.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tsh g Judas am si nehnich hegai lial k am shul geꞌe cheopi ch ed k gam hu hahawa wuhsh jeg ed k wabsh hejel e naggia. ");
INSERT INTO oodNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tsh g uꞌugchu papal am ui hegai lial k hab kaij, “Id o d namkigaj mat hema wo e muhkid. K g t‑chehanig pi t‑hiwgid matt am wo toa geꞌe cheopi wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bash kaij ch am apꞌech matsh heg hekaj wo hema ha nolawt g oidag mat d wo ha‑simin‑jihlok hegam mo d wabsh ge oꞌodham. Hegai mamt ha nolawt o heki hu hab e aꞌaga Hahaꞌatdam Oidag ");
INSERT INTO oodNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ch wabshaba hab hahawa e aꞌaga Ehꞌed Oidag. ");
INSERT INTO oodNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Neh, id atsh wa hab e juh hab masma mash wa g Jiosh heki hu waꞌi hab kaij matsh hab masma hab wo e juh. Hegai kelibad Jiosh haꞌichu i tashogiddam mash hab chehgig Jeremiah atki an oꞌoha mash hab kaij g Jiosh: Tutuligo at wo hema nolawt g oꞌodham g waikko wehst‑mahm plahda pihshkaj. ");
INSERT INTO oodNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kumt id am haha wo ui namkigaj k wo ha nolawt g hahaꞌatdam oidag. ");
INSERT INTO oodNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sh eda am kehk g Jesus kownal wui. Sh hegam mo s‑muꞌamk ab abchud mo chum e kownalchud. Sh g kownal ab kakke, “No wa woho mapsh hab chum e elid map d ha‑kownalig idam Tutuligo?” Sh hab kaij g Jesus, “Dani ahni.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sh g uꞌugchu papal ch geꞌeged ab muꞌi haꞌichu abchud. Sh pi am hu has shaꞌi kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sh hekaj hab kaij g Pilate ab wui, “Neh, muꞌi haꞌichu o ab m‑abchud. Napt pi ab hu wo ha kaiha?” ");
INSERT INTO oodNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kush ep pi am hu has shaꞌi kaij g Jesus. Tsh heg hekaj si has i el g kownal. ");
INSERT INTO oodNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","K am hab e wua ahid ab id eda gegosig mo g kownal hema dadagitod g lihso am ha wehhejed g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","K am hema d lihso ch hab chehgig Barabbas. K wehsijj s‑mahch ihda. ");
INSERT INTO oodNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tsh am i e hemapai g hemajkam amai mash am daha g Pilate ch hab wua g lodaita. Tsh ab ha kakke, “Nam hab elid mant wo dagito g Barabbas aha nam id hab elid Jesus mo hab e aꞌaga Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Neh, bash kaij nash pi chum s‑dagitoimk g Jesus ch hab ha elid mo hegam waꞌi hahaꞌichu s‑hehgamk ch s‑muꞌamk. ");
INSERT INTO oodNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sh am daha g Pilate lodaita daikud ed. Kutsh eda g wehmaj kihkam heki hu hema cheha matsh am wo him k wo ahgi mo hab kaij, “Pi g am hu has shaꞌi juhni hegai oꞌodham no pi pi ha chuꞌijig. Muꞌi ant haꞌichu nako chuhug chehchkch ab amjed.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sh eda hegam uꞌugchu papal ch geꞌeged ab ha chehani g hemajkam matsh ab wo tai g Pilate mat wo dagito g Barabbas k g Jesus hab wo juh mat wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pegih, sh g kownal ab ha kakke mas hedai am wo i dagito ha wui idam gohk. Sh hab kaij g hemajkam, “Barabbas”. ");
INSERT INTO oodNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sh hab hahawa ep kaij g Pilate mas has wo juh hegai Jesus mo hab e aꞌaga Jiosh si Kehsha. Sh hab kaij g hemajkam, “Muꞌani ab kots t ab.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kutsh hab chum chei g Pilate, “Haschu ahg? Shahchu at hig pi ap has juh?” Kutsh oi wa wabsh baꞌich i si s‑kaidam hab ge kaij muꞌikko, “Muꞌani! Muꞌani ab kots t ab!” ");
INSERT INTO oodNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tsh am i nei g Pilate matki heki hu i babgat g hemajkam k am hu wo e cheggia. Tsh am ge was g shuhdagi k am hemajkam ha tahgio i ha wapko g e‑nohnhoi k hab kaij ab ha wui, “Pi o haꞌichu d shaꞌi ni‑chuꞌijig matp wo e muhkid ihda oꞌodham. Ahpim o d em‑chuꞌijig.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sh wehsijj hab kaij hegam mo am haꞌichug, “Ahchim g t‑aꞌaliga ha wehm att ab wo moht g s‑koꞌok namkidadag id hekaj.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tsh g Pilate am hahawa i dagito g Barabbas ha wui k am ha cheha g shondal mat wo gewitta g Jesus k am hahawa i dagito mat ab wo naggia kots t ab. ");
INSERT INTO oodNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tsh amjed g Pilate shondaliga am i bei g Jesus k gd hu uꞌapa kownal geꞌe kih am k am wehs ha wai g e‑wehm shondal. ");
INSERT INTO oodNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kutsh am i e hemapad k nahnko wua. Msh ab abchud mash chum e kownalchud. Pegih, tsh gam si wuashul g wehschugaj k g kownal eniga ab wahkid ");
INSERT INTO oodNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","k ge hoꞌi gihkot k ab wahki moꞌoj ab k g uhs an behijel s‑apko nowij an k wabsh nahnko ahg ch ab i tohtonwua wui k hab kaij, “Tash g d ha‑kownaligk g Tutuligo.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sh ab si siswuimad k an si gewitta moꞌoj an. ");
INSERT INTO oodNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tsh am i haꞌasa nahnko juh k am wuahawua hegai kownal eniga k ab uhpam wahki g enigaj k gam hu hahawa i bei mat ab wo naggia kots t ab. ");
INSERT INTO oodNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tsh ab hema i ha nam g oꞌodham mo ab Cyrene kihhim t ab d kihkam ch hab chehgig Simon. Id amtsh ab wabsh si kushwiotach hegai kots mamt ab ab wo naggia g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kumtsh gam hu i bei g Jesus mamtsh am wo naggia. K hab e aꞌaga amai Golgotha. K id hab d ahga Koshwak. ");
INSERT INTO oodNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kumtsh ab chum iꞌich g nawait mo g kulani am wehnags mat wo hehogi g s‑koꞌok. Tsh ab chum jeh k pi ab hu ih. ");
INSERT INTO oodNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kumtsh ab hahawa sisish kots t ab k am i kei g kots. Tsh am haꞌi e chichwi g shondal k am aꞌai e gehg g wehschugaj ");
INSERT INTO oodNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","k am hahawa i dadhaiwua k nuhkud. ");
INSERT INTO oodNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kumtsh an oꞌoha mam haschu ab abchud k ab sihsh kots t ab ab dahm mo ab i moꞌokch g Jesus. Sh hab chuꞌig, “Id o d Jesus ch d Tutuligo ha‑kownalig.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tsh gohk ab ep ha nahngia kokots t ab gan hu aꞌai. Sh eda d s‑chu eꞌeskam idam. ");
INSERT INTO oodNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Sh hegam mo an bihbimhim si gahi e moꞌogid ch ab si s‑koꞌokam has ahg g Jesus ");
INSERT INTO oodNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","hab kaijch, “Naptsh woho wo i wua g geꞌe cheopi k am uhpam ep wo kei waik tash ab? Pegih, ab g hig i huduni kots t amjed k wo e doꞌibia maptp woho d wo Jiosh alidagk.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sh g uꞌugchu papal ch chehanig ha mashchamdam ch geꞌeged hab wa masma ep nahnko ahg hab kaijch, ");
INSERT INTO oodNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Id atsh haꞌi ha doꞌibia k atki wabshaba pi wo e nako mas wo hejel e doꞌibia. Nash hig pi woho d t‑kownalig? Pegih, tt ab wo s‑wohoch matp ab wo i huduni k wo e doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ab o si hiwig g Jiosh ch hab e ahg mo d alidaj. Pegih, tt hig wo nei mas hu wo doꞌibia g Jiosh hemu.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chum wa hema hegam s‑chu eꞌeskam mamt ab hab waꞌap ha nahngia kots t ab hab waꞌap s‑koꞌokam has ahg. ");
INSERT INTO oodNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","T am i dahm juh. T wehsko gei g s‑chuhugam waik ohla ab. ");
INSERT INTO oodNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kutsh am i e ai g waik ohla. Sh si s‑kaidam hab kaij g Jesus, “Eli, Eli, lama sabaktani,” mo hab d ahga, “Ni‑Jioshga, Ni‑Jioshga, shahchu apt ahgk am wabsh i ni‑dagito?” ");
INSERT INTO oodNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sh haꞌijj hab kaij hegam mo am gegok, “Elijabad o ab chum waid.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tsh ab hema ha hekaj i med k an haꞌichu usko mat am wakch nawait ch ed k am uhgk i be k ab chum iꞌich g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kush haꞌi hab kaij, “Kia koi, tt hig wo nei mas ia wo jiwia g Elijabad k wo doꞌibia.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kutsh am si s‑kaidam hab haꞌichu ep chei g Jesus k am hahawa i muh. ");
INSERT INTO oodNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kutsh hegai s‑kowk ikus kuhpadag mash am s‑tadnim naggia ged hu si eda g geꞌe cheopi ab si shel e wantsh. T g jewed uꞌugij k gam si e hahai g geꞌeged hohodai. ");
INSERT INTO oodNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kutki g hihaꞌini gam si e kuhkpiꞌo. T muꞌijj hegam mat heki hu koi ab s‑wohochudch g Jesus ab i wuwha muhkig amjed ");
INSERT INTO oodNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","i dahm mat g Jesus i wuhsh k gam hu i wahp amai mo hab e aꞌaga Si Hekia S‑apꞌekam Kihhim ch d Jerusalem. K muꞌijj ha neid amai. ");
INSERT INTO oodNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tsh idam shondal g e‑geꞌejig wehm am i nei mat g Jesus muh k taht g jewed uꞌujig k shaꞌi si e totodsid k hab kaij, “Woho oki d Jiosh alidag.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sh eda muꞌijj am haꞌichug hegam uꞌuwi mo ga hu amjed wehmaj g Jesus ab Galilee t amjed ch am haꞌichukaj i wehmaj. Idam ash ga hu wabsh mehk gegok ch ab neid. ");
INSERT INTO oodNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sh am ha wehmaj g Mary Magdalene ch hegai Mary mo d ha‑jeꞌe g James ch Joses ch heg ehp mo d Zebedeebad wehm kihkam ch d ha‑jeꞌe g James ch John. ");
INSERT INTO oodNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tsh am hahawa jiwia ihda s‑kais oꞌodham mo hab chehgig Joseph ch ab Arimathea t amjed ch ab s‑wohochud mo g Jesus d Jiosh si Kehsha. K eda e aihim mat wo i hud. ");
INSERT INTO oodNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tsh heg hekaj gam hu hih ihda Joseph ab Pilate wui k ab tahni g Jesus honshpadag. Kush g Pilate am ha chehani mamt wo mah. ");
INSERT INTO oodNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Tsh gam hu uhpam jiwia. Kumtsh am wehhejed ab i huduni g Jesus honshpadag. K am mia hab chuꞌig g Joseph hihaꞌini ch ab heki hu cheotas hodai ch ed. Kumtsh am i bei g honshpadag k am i hobino g si s‑kehg ikuskaj k am cheh heg eda cheo k ab hahawa g ge geꞌe hodai i himchud k ab hekaj kuh g hihaꞌini. Tsh gam hu hahawa uhpam hihi hegam Joseph. ");
INSERT INTO oodNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Kush am dadha g Mary Magdalene heg wehm hema Mary ch am neid mat hebai cheh. ");
INSERT INTO oodNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Baꞌich tash o d shahwai. Tsh am dada g uꞌugchu papal ch Palasi Pilate wui ");
INSERT INTO oodNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","k hab kaij, “T‑kownalig, s‑chegito ach mo wa ihda s‑chu iattomkam hab kaij matsh uhpam wo e chegito matsh d wo waik i tashk. ");
INSERT INTO oodNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Neh pt am wo ha cheha mat wo si e nuhkud g hihaꞌini waik tash ab. T hekaj hab pi wo e nako g piongaj mas ab wo ha ehs g honshpadag k hab wo ha ahgi g hemajkam matki i wuhsh ab muhkig t amjed. Neh, ihda ha‑iattogi at baꞌich wo i si pi apꞌek mo g wehpegkam.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kush hab kaij g Pilate ab ha wui, “Am g haꞌi wo ha uꞌuk g shondal k am has i masma ab wo nuhkud g hihaꞌini.” ");
INSERT INTO oodNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kutsh am ha oi g shondal. Kutsh gam hu hihim k ab si s‑wihnam i kuh g hihaꞌini k an bidsh g hodai k ab si chepos. Sh idam shondal am nuhkud g hihaꞌini tash oidam ch chuhug oidam. ");
INSERT INTO oodNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sh am e aihim g domig tash. Tsh am hihaꞌini wui hihi g Mary Magdalene heg wehm hema Mary. ");
INSERT INTO oodNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","D am hahawa si uꞌugij g jewed. Tsh g anghil ab i hud dahm kahchim t amjed k im hu hab i melch g hodai k an dahm dahiwua. ");
INSERT INTO oodNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sh g wuhioshaj si s‑masma tonod hab masma mo g wepgi. Sh g wehschugaj hab masma s‑toha mo g s‑mohoni gew. ");
INSERT INTO oodNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kutsh wabsh wohoꞌi totods hegam shondal mo ab nuhkud k si gigiwek ch amjed hab sha e juh mo d wabsh koꞌi. ");
INSERT INTO oodNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kush ab neok hegai anghil ch hab kaij ab ha wui hegam uꞌuwi, “Pi g am wo shaꞌi e totodsid. M ani wa s‑mahch mam g Jesus chuhkug an chum gahghim. ");
INSERT INTO oodNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ab g wo i hihim k wo nei mo pi ia hu haꞌichug iia mat ia e cheh. Uhpam at ep i wuhsh muhkig amjed mo wa hab wa kaij. ");
INSERT INTO oodNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kumt am s‑hohtam wo hihim k wo ha ahgi hegam mo am wehmajkahim mat uhpam e chegito k gam hu wo hih Galilee wui. Mt gam hu wo hihim k am haꞌab wo nei. Neh, am ani em‑ahgid mo has i kaij.” Bash kaij g anghil. ");
INSERT INTO oodNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kutsh si e totodsid k si s‑hohtam ga hu hihi ab amjed g hihaꞌini k eda si s‑hehgig ch ia hu chum wohp matsh wo t‑ahgi. ");
INSERT INTO oodNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tsh wabshaba haha wabsh ha nam g Jesus k hab kaij, “T wo s‑em hoꞌigeꞌel g Jiosh.” Tsh ab si i shul wui k an ui tahtdaj an k ab si ihm. ");
INSERT INTO oodNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Sh hab kaij ab ha wui, “Pi g am wo ni‑ehbenid. Am g wo hihim k wo ha ahgi g ni‑wepnag mat am wo hihi Galilee wui k am haꞌab wo ni‑nei.” ");
INSERT INTO oodNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kutsh gam hu hihi hegam uꞌuwi. Tsh hegam shondal mash am nuhkud g hihaꞌini am haꞌi hihim k ged hu dada kihhim t am k am ha ahgi g uꞌugchu papal wehs haꞌichu matsh haschu has i e juh. ");
INSERT INTO oodNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tsh g uꞌugchu papal am ha wehm e nam g geꞌeged k am e aꞌaga k am hahawa muꞌi ha mah g lial idam shondal ");
INSERT INTO oodNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","k hab ha ahg, “Bamt wo chei matki am dada g piongaj chuhug ch ed k am em‑ehs g honshpadag mam kohksh. ");
INSERT INTO oodNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kutp wo sha kah g kownal mam has i kaij, tt wo wa em‑doꞌibia.” ");
INSERT INTO oodNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kutsh am ui g lial hegam shondal k am hab e juh mam has i ha ahg. Ia o i idani hab masma am e aꞌaga am ha shahgid g Tutuligo. ");
INSERT INTO oodNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kuchd ahchim gamai hemako am hihi heg wui doꞌag am Galilee ch ed mo wa hab kaij g Jesus matt am wo hihi. ");
INSERT INTO oodNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","D g Jesus am haꞌichug. Kuchd ab si ihm. D eda hi wa haꞌi sha pi wohoch. ");
INSERT INTO oodNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","D ab si i t‑miabi g Jesus k hab kaij ab t‑wui, “Jiosh at ab ni‑mah g gewkdag wehs haꞌichu dahm an dahm kahchim ch ed ch id dahm jewed. ");
INSERT INTO oodNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gamai g wo hihim wehsko hemajkam ha wui k wo i ha mashcha g haꞌichu ni‑ahga k ab wo i ha pahl wapko am chehchegch g ni‑ohg Jiosh ch ahni ep ni‑chehcheg mani d alidaj ch heg ehp Hekia S‑apꞌekam Gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ab ani em‑chehani mamt has wo masmak. Kumt ab wo i ha mashcha g hemajkam mat ab wo s‑wohog elidad wehs haꞌichu mani haschu ab em‑chehani. Kunt chum hekid wo em‑wehmajk, chum as wo huhug g jewed.”");
INSERT INTO oodNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Id o d s‑kehg haꞌichu ahgaj g Jiosh ab amjed g alidaj Jesus Christ. Shonaj ihda haꞌichu ahgaj. ");
INSERT INTO oodNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","o an hab chuꞌig oꞌohanaj ed hegai Jiosh haꞌichu i tashogiddam mash hab chehgig Isaiah. Heg atki an oꞌoha mash g Jiosh hab kaij ab e‑alidag wui: An ant hema wo i wuhshad mat am wo i ha apꞌech g hemajkam mapt ahpi am wo i wuhsh jewed dahm. ");
INSERT INTO oodNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Id at gam hu jeg ed wo ha mihshmad g hemajkam hab kaijch: Neh, in atsh wo i wuhsh jewed dahm hegai mo d ge kownal wehs haꞌichu dahm. Kumt heg wehhejed wo i e nako. Neh, bash ahg g e‑alidag g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Kutsh wa woho am hab e juh. M atsh hema i wuhshad g Jiosh g oꞌodham. K id hab chehgig John ch am i e chehgi Judea chekshani ch ed miabidch hegai akimel mo hab chehgig Jordan. Ab ash e enigadadch g John g ka‑mihyo wopo ikuskaj ch ge hogi giwud ch heg waꞌi hekaj e gegosid kohktpul ch sitꞌol. Kush muꞌi hemajkam am wui hihim heg amjed chekshani chum hems ab Jerusalem kihhim t amjed. Sh g John am amog ch hab ha ahg, “Mamt gam hu wo s‑ohhod g pi ap e‑chegitoi k wo e pahl wapko. T g Jiosh ab wo i s‑em‑hoꞌigeꞌid k gam hu hab wo i juh g pi ap em‑chuꞌijig.” Neh, bash kaij g John ch am ep ha pahl wapkon akimel ch ed hegam mash ab wui hihimad ch am ahg g pi ap e‑chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Sh hab ha ahg g John, “Pi g hab wo ni‑elid manis ahni d si haꞌichu. Ab atsh hema wo i wuhsh ni‑oidk mat d wo si s‑has haꞌichuk. ");
INSERT INTO oodNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ahni ani hi wabsh em‑pahl wapkon. Tsh wabshaba heg ab wo em‑mah g Hekia S‑apꞌekam Gewkdag matsh heg chum hekid wo em‑wehmajk.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kush eda g Jesus wenog ab d kihkam heg eda al kihhim mash d Nazareth ch am eda g Galilee chekshani. Kutsh am i him k am jiwia mo am oimmed g John hab ahgk matsh wo e pahl wako. Tsh g John am pahl wako akimel ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tsh ab wabsh i chum wuhsh ab amjed g shuhdagi. Tsh g dahm kahchim ab si i e kuhpiꞌo. Kutsh g Hekia S‑apꞌekam Gewkdag i hud ab ab g Jesus hab sha masma mat g hohhi. ");
INSERT INTO oodNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sh ab neok g Jiosh dahm kahchim t amjed ch hab kaij ab wui g Jesus, “Ahpi ap d si ni‑tachuidch ni‑alidag ch am si ni‑tatchui oidch hab masma.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Am waꞌi hekaj, sh g Hekia S‑apꞌekam Gewkdag hab ahg g Jesus matsh gam hu hejelko wo hih. ");
INSERT INTO oodNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kutsh am hih tohono jewed wui k am haꞌichug giꞌikko wehst‑mahm tash ab mo am haꞌichug g mischini haꞌichu doakam. Sh heg i oidam g ge Jiawul am chum s‑wuimk pi apꞌekam ch ed. Sh wabshaba g anghil am nuhkud. ");
INSERT INTO oodNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sh am hu hebai, tsh e kuhpach hegai John mo am ha pahl wapkon. Tsh heg i dahm am jiwia g Jesus Galilee chekshani t am am ahgachugch g s‑kehg haꞌichu ahgaj g Jiosh ");
INSERT INTO oodNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","hab kaijch, “Gam g hu wo s‑ohhod g pi ap e‑chegitoi k ab wo i s‑wohoch idda s‑kehg haꞌichu ahgaj g Jiosh. E at ai mat am baꞌich wo i e tashogi g Jiosh kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Neh, bash kaijhim ch an him hugidaj an hegai al kahchki mo d Galilee Kahchki. Sh eda am haꞌi oiopo g waptopi ha uꞌudam ch am wuhpa g e‑chuagia shuhdagi ch ed. Tsh am ha cheh g Jesus. Kush d idam gohk e wepngam mo hab chehgig Simon ch Andrew. ");
INSERT INTO oodNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sh hab ha ahg g Jesus, “Ab g wo i ni‑oid k pi hegam waꞌi waptopi wo ha uꞌud ch wabshaba g hemajkam wo i ha wanchkwua ab Jiosh wui.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kutsh ha hekaj dagito g e‑chikpan k am i oi. ");
INSERT INTO oodNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tsh am shaꞌi hihim k haha wabsh gohk ep ha cheh. Idam ash am kegchud g e‑chuagia wahlko ch ed ch d James ch John. Kush g ohgaj hab chehgig Zebedee. ");
INSERT INTO oodNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tsh ab i ha wai g Jesus. Kutsh gam hu i oi am dagitok g e‑ohg wahlko ch ed ha wehm g ha‑pionag. ");
INSERT INTO oodNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kutsh am hihim k am dada Capernaum kihhim t am. Tsh am i e ai g shahwai mach heg eda t‑mihshmad. Kutsh am i wahp ha‑cheopi ed. Tsh g Jesus am ha mihshmad. ");
INSERT INTO oodNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kutsh g hemajkam ab si e totods ab mashchamadaj amjed nash pi baꞌich i si s‑e mamachim ha mashcham mo hi hegam mo d chum chehanig ha mashchamdam. ");
INSERT INTO oodNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kush eda am hema haꞌichug g oꞌodham mash g jiawul uꞌukch g chegitoidaj. ");
INSERT INTO oodNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Tsh heg hab juh mash am si s‑kaidam neok ch hab kaij, “Shahchu ap ahgch t‑kudut, ahpi Jesus map ab Nazareth t amjed. Napt heg hekaj ia wabsh jiwia mapt gam hu hab wo i ni‑juh id amjed oꞌodham? S‑m‑mahch ani map d hekia s‑apꞌekam ch ab d Jiosh amjedkam.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tsh g Jesus ab si s‑kehꞌel g jiawul k hab kaij, “Ab g wabsh i pi shahmuni k gam hu hab wo i e juh.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tsh g jiawul si ugij ihda oꞌodham. Kutsh si hihin. Tsh g jiawul hahawa dagito. ");
INSERT INTO oodNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kutsh wehsijj si e totodsid k ab aꞌai i e kakke, “Shahꞌo d ahga ihda? No d wechij mashchama? No pi ab kaiham g jijawul mo haschu ab i ha chehani.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kutsh an wehsko i e ahgidahi am Galilee ch ed matsh haschu s‑kehg hab juh g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kutsh ab i wuwha hegam Jesus cheopi t amjed k gam hu wa hekaj hihi ha‑kih wui hegam Simon ch Andrew. Tsh g James ch John ep i ha oi. ");
INSERT INTO oodNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kush eda am woꞌo g Simon hohnig jeꞌe ch g s‑tonjigkaj mumku. Kumsh am ahgid g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tsh am i wah mo hebai woꞌo k ab bei nowij ab k i wamigi. Kutsh ha hekaj am i apꞌet k am haꞌichu ha hihidol. ");
INSERT INTO oodNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kutsh gam hu si i juh. Tsh g hemajkam ab i ha ui hegam mo kokꞌo ch hegam ehp mo g jijawul uꞌukch g ha‑chegitoidag. ");
INSERT INTO oodNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","k am i e hemapai ha‑kih ab. ");
INSERT INTO oodNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kutsh g Jesus wehs ha dodaj idam k gam hu hab i ha juh g jijawul ab ha amjed. Sh g jijawul s‑mahch mo d Jiosh alidag. Sh wabshaba pi ha hiwgid g Jesus mas idam am wo ah mo hedai wud. ");
INSERT INTO oodNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Baꞌich siꞌalim mash wabsh kia s‑chuhugam, tsh am i wami g Jesus k gam hu hejelko him k am e hoꞌigeꞌidahun. ");
INSERT INTO oodNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kutsh idam Simon am i gahghio. ");
INSERT INTO oodNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","k am hebai chehg k am ahgid, “Muꞌi hemajkam o an m‑gahg.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kush hab kaij g Jesus, “Oi g wo. Tt hig wo hihi am baꞌich kihhim wui. Nt am ep wo ha mihshmad nant pi heg hekaj i wuhsh.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kutsh am i ha mihshmdahi ha‑chechopi ed wehsko Galilee chekshani ch ed k gam hu hab i ha juh g jijawul ab ha amjed hegam mo an ha uꞌukch. ");
INSERT INTO oodNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sh am hu hebai, tsh am hema jiwia Jesus wui k mumku heg hekaj mo hab e aꞌaga ‘leprosy’ ch chum pi ha doajig. Id ash ab wui e shoꞌigchud g Jesus ch hab kaij, “Pt wo e nako mapt wo ni‑doaj maptp wo tatchuad.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kutsh ab si i s‑hoꞌigeꞌid k ab taht k hab ahg, “Mant hab wo wa m‑juni.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kutsh ha hekaj doa. ");
INSERT INTO oodNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jesus atsh am hahawa si shel ahgid k hab kaij, “Pi g hedai shaꞌi ahgid k wabsh am wo him k am wo i e chehgi pahl wui. T am wo m‑chechga. Kupt wo ha mah hegai mo wa g Jiosh em‑chehani hab masma mat g Mosesbad oꞌoha mamt heg hekaj wo wohokamch mamt doa.” ");
INSERT INTO oodNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kutsh oi wa ihda oꞌodham wehsko i ha ahgidahi g hemajkam ab amjed. Tsh heg hekaj pi e nako g Jesus mas am ep wo i wuhsh mo am hemajkamag kihhim ch ed k wabshaba gan hu hab wabsh jegko oimmed. Sh g hemajkam am wui himto ga hu wepsko amjed. ");
INSERT INTO oodNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kush d wabsh i heꞌekia tash matsh am ep dada hegam Jesus Capernaum t am. Tsh gan hu wa hekaj kaida matsh am dada. ");
INSERT INTO oodNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kutsh shaꞌi si muꞌi e hemapai g hemajkam k am shuhdad g kih k ab kihjeg t ab ab wabsh i si s‑kawkam gegokiwua. Kush g Jesus am ha mihshmad. ");
INSERT INTO oodNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tsh am haꞌi dada hema uꞌadch g pi himidkam. Id ash ab wabsh i s‑moik ch am woꞌo e‑wahkus ch ed. Kush giꞌik oꞌodham an uꞌa. ");
INSERT INTO oodNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sh wabshaba pi am hu shaꞌi jeg nash pi shaꞌi si s‑hemajkamag. Kutsh gan hu i chehchsh kih dahm k am ge maggat g kih maꞌishpadag am hu i mash am daha g Jesus k am i huduni g pi himidkam. ");
INSERT INTO oodNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kutsh g Jesus am i nei g ha‑wohochudadag k hab kaij heg wui pi himidkam, “Ni‑nawoj, ab ani s‑m‑hoꞌigeꞌid ch gm hu hab i juh g pi ap m‑chuꞌijig.” ");
INSERT INTO oodNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kush eda am haꞌi dadha hegam mo d chehanig ha mashchamdam ch ash hab e ahg, ");
INSERT INTO oodNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ih, pi oki ap neok hab masma e wepogidch g Jiosh. Heg at waꞌi Jiosh wo e nako mat gam hu hab wo i juh g pi ap ha‑chuꞌijig.” ");
INSERT INTO oodNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kutsh ha hekaj ha amich g Jesus mo haschu am oidahim k hab kaij ab ha wui, “Pi g am wo shaꞌi oidahim ");
INSERT INTO oodNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","manis hab wabsh kaij ch pi woho edgid g gewkdag mant gm hu hab wo i juh g pi ap ha‑chuꞌijig. Bam elid mo s‑pehegim hab e kaij mat gam hu hab i e juh g pi ap chuꞌijigaj no ge hedai s‑mahch mas s‑wohom hab e juh. ");
INSERT INTO oodNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pegih, nt wo em‑chehgi mani woho ge gewkdag ch hab wua mani has i kaij ahni Jiosh si Kehsha.” K hab hahawa kaij ab wui hegai pi himidkam, ");
INSERT INTO oodNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“I g wamig k am behꞌi g e‑wahkus k gam hu hihm uhpam.” ");
INSERT INTO oodNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kutsh am ha hekaj bei g e‑wahkus k gam hu hih uhpam am wehs ha‑nena ed. Kutsh wehsijj si has i e tahtk k ab i si has elid g Jiosh ch hab kaij, “Pi ach hebai shaꞌi neid haꞌichu hab masma.” ");
INSERT INTO oodNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kutsh gam hu hahawa hihi hegam Jesus k gam hu dada ge shuhdagi bahsho. Tsh muꞌi am e chehm g hemajkam. Sh am ep ha mashcham. ");
INSERT INTO oodNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kush am hu hebai ep hihimad ch am bihbij amai mam am ha kowlant g lial kownal wehhejed. Sh am hema chikpan ch hab chehgig Levi (Matthew). Tsh g Jesus am jiwia wui k hab ahg, “Ab g i hihm k ab si ni‑wecho e mashcham.” Kutsh am ha hekaj wabsh i oi. ");
INSERT INTO oodNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","16","Tsh am hu hebai i cheka. Kutsh g Levi am hab juh g gegosig ha wehhejed hegam Jesus. Kush am dadhak ch e gegosid. Sh am haꞌi oiopo hegam mo d t‑chehanig t‑mashchamdam ch d ep Palasi. Idam Palasi o chum s‑gewkam oidchug g t‑himdag. K eda m uꞌi am oidchug g Jesus hegam mo pi am hu si oidchug g t‑shohshon ha‑himdag. Kush haꞌi idam d lial t‑kowlantdam heg wehhejed mash d geꞌe kownal wehs jejewed dahm. Kush hegam t‑chehanig t‑mashchamdam hab ha ahg hegam mo ab si wecho e mashcham g Jesus, “Ih, k haschu ahgch g em‑mashchamdam ha wehm e gegosid g pi ap hemajkam, chum hems g lial t‑kowlandam?” ");
INSERT INTO oodNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tsh am i ha kaiok g Jesus k hab kaij ab ha wui, “Idam pi ap hemajkam o s‑e doꞌibiamk hab masma mat g kokꞌodam wo s‑e doajidam. Hegam mat hab wo e elidad mo s‑apꞌe at pi wo tatchua g mahkai. Pi ant hab ahgk ia jiwia jewed dahm manis wo ha doꞌibia hegam mo pi e doꞌibiamk.” ");
INSERT INTO oodNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Hebaichuj ach heꞌekkio pi t‑gegosid matt ab wo t‑hoꞌigeꞌidahu Jiosh wui. Kutsh am hu hebai am i e ai matsh hab wo chum e juh. Sh eda idam Jesus pi hab e wua. Kumsh hab kaij ab wui g Jesus, “Hemu o heꞌekkio pi e gegosid hegam mo g Palasi ha mashcham ch hegam mo g John ha mashcham. K eda haschu ahgch idam pi hab masma hab e wua mo ab si m‑wecho e mashcham?” ");
INSERT INTO oodNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sh hab kaij g Jesus ab ha wui, “Nat hig pi wo e gegos g wo ha hohntam naipijju mat eda heg am wo ha wehmajk? ");
INSERT INTO oodNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","T am wo i e ai mat pi am hu wo ha wehmajk. T am hahawa pi wo e gegos. Pegih, bat wo wa e juh idam mant hekid pi ia hu wo ha wehmajk.” ");
INSERT INTO oodNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sh am hahawa chum ha tashogid g Jesus mat g mashchamaj pi ap wo wehnad g ha‑himdag ash hab kaijch, “Pi at hedai g wechij ikuskaj wo shohsho g hekiuchij lihwa mat wo s‑e wia nat pi wo i dahiwua k baꞌich wo i wantsh g hekiuchij. ");
INSERT INTO oodNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","K hab waꞌap pi hab mahs machs am wo toa g wechij uhdwis wadag am eda g hekiuchij haꞌichu elidag kostal. T wo am hu wantsh g hekiuchij k wo iawua. Wechij uhdwis wadag at am wo e toa wechij kokstal ch ed.” ");
INSERT INTO oodNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sh am hu hebai hihim idam Jesus t‑mihshmda tash ed. Kush am eshas g pilkani wohg huhugid an. Sh idam haꞌi ab ha wohni g pilkani ch i mohon ch koꞌa. ");
INSERT INTO oodNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kush haꞌi hegam Palasi ab ha neid ch ab kakke g Jesus, “Shahchu o ahgch hab haꞌichu junihim mo pi hab shaꞌi chum mahs t‑mihshmda tash ed?” ");
INSERT INTO oodNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kush hab kaij g Jesus ab ha wui, “Bo wabsh masma hab e wua matsh wa g Davidbad. Pi amtki chegito matsh heg has e Juh am i bihugimk. Bo chugꞌig g Jiosh oꞌohana ");
INSERT INTO oodNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","matsh wa am i wah geꞌe cheopi ch ed k am ui g pahn k huh hegam ha wehm mash am wehmaj. K d hegai pahn mo am e toꞌaw k ch hegam d waꞌi ha wuikam papal. T eda hemho wa am hab e juh. K heg hekaj am wa s‑apꞌe matsh ab mah g pahn hegai pahlibad mash am haꞌichug ch hab chehgig Abiathar. ");
INSERT INTO oodNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Id o am wohokamchud mo g chehanig d i chum ha wehmtadag g hemajkam. Em‑mihshmda tash at am e apꞌech em‑wehhejed. Kumt pi heg wehhejed e nahto e‑mihshmda tash. ");
INSERT INTO oodNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ni ahni d Jiosh si Kehsha ch gewkdag am dahm g em‑mihshmda tash.” ");
INSERT INTO oodNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sh am hu hebai, tsh am ep i wahp idam Jesus hema cheopi ch ed. Kush am hema daha g oꞌodham mash g nowij mahnikodag. ");
INSERT INTO oodNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kush am haꞌi dadha g Palasi ch am s‑nenꞌeid mas hab wo juh g doajida am ha mihshmda tash ed nash pi ab haꞌichu s‑abchudamk. ");
INSERT INTO oodNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sh g Jesus hab kaij heg wui mahnikokam, “Ia g hu i kekiwua.” Kutsh gam hu i kekiwua. ");
INSERT INTO oodNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sh ab hahawa ha kakke, “Shahchu am ahgch hab elid mo pi hiwgidas mihshmda tash ed mamt wo i ha wehmt hegam mo e shoꞌigchud? Ab o em‑ab mamt wo i ha wehmt g shoꞌigkam k am wo i e nako mamt wo ha doꞌibia hegam mat am hu wo e koꞌij. Aha namt wabsh wo ha hiwigi mat wo e koꞌij?” Kush pi hedai has shaꞌi kaij ");
INSERT INTO oodNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","nash pi pi shaꞌi pihk e elid heg wui mahnikokam. Sh heg hekaj si s‑koꞌokam an i ha nenashad g Jesus ch eda ep pi ap e tahtk ha wehhejed ch ash hab kaij heg wui oꞌodham, “Ab g si i shelin g e‑nowi.” Kutsh am wabsh i chum shelin k am waꞌi hekaj apꞌet. ");
INSERT INTO oodNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kutsh babgat g Palasi matsh ha doaj ha mihshmda tash ab k gam hu hihim k am ha wehm e nam g piongaj hegai mo wa d kownal heg eda chekshani ch hab chehgig Herod. Kush idam e wehm aꞌaga matsh has hig masma wo mua g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kutsh gam hu hahawa hihi hegam Jesus ge shuhdagi wui. Kutsh muꞌi hemajkam am i oi ab Galilee t amjed ");
INSERT INTO oodNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ch ab Judea t amjed, chum hems ab Jerusalem kihhim t amjed, ch Idumia chekshani ch gan hu aigojed g Jordan akimel ch gam hujed mash d Tyre ch Sidon kihhim. Idam muꞌi atsh am himto am kaiok mo heꞌes i geꞌe haꞌichu hab wuihim g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kush heg am ha ahgid hegam mo ab si wecho e mashcham matsh g wahlko an wo uꞌukchid am wehhejed natsh pi g hemajkam wabsh wo i si chehmo. ");
INSERT INTO oodNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kush wehs am chum s‑ahimk g kokꞌodam ch ab s‑tahtmamk mat wo ha apꞌet natsh pi muꞌijj ha dodaj. ");
INSERT INTO oodNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kutsh hekid wo sha nei g Jesus hegam mash g jijawul ha uꞌukch k ab wo i e shoꞌigch wui k wo si hihin k hab wo chei, “Ahpi ap d Jiosh alidag.” ");
INSERT INTO oodNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sh g Jesus am si ha chehani mat pi hedai wo shaꞌi ahgi mo hedai wud. ");
INSERT INTO oodNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Tsh am hu hebai, tsh ab i chesh g Jesus kawulk t ab k ab i wai hegam mash ab s‑wohochud. Tsh ab wui i hihi. Kutsh gamai gohk am i ha chuhcha ab ha wui hab kaijch, “Ahpim amt chum hekid wo ni‑wehmajkad. Kunt hebaichuj am wo em‑cheha mamt am hebai wo hihim k wo ha mihshmad. ");
INSERT INTO oodNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kumt wo edgidad g gewkdag mamt gam hu hab wo i ha juh g jijawul ab ha amjed hegam mo an ha uꞌukch.” ");
INSERT INTO oodNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Neh, bash kaij ch am i ha chuhcha hegam gamai gohk. Hema hegam o d Simon. Kutsh heg hab ep chehch Peter mo hab d ahga Hodai. ");
INSERT INTO oodNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Haꞌi ehp o d James ch John ch d Zebedee aꞌalidag. Kutsh idam hab ep ha chehch g Jesus ‘Tataniki Namkam.’ ");
INSERT INTO oodNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Haꞌi ehp o d Andrew, Philip, Bartholomew, Matthew, ch Thomas. K hema d hegai mo d James ch d alidaj hegai mo hab chehgig Alphias. K hema hab ep chehgig Simon ch d hema hegam mo tatchua matt ahchim Tutuligo hejel wo himchudad g t‑kownaltalig. K hema d Thaddaus ");
INSERT INTO oodNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","K hema d hegai mat gagda g Jesus k hab chehgig Judas Iscariot. Neh, idam gamai gohk ash d Jesus chuhchai. Kush an oidchug. ");
INSERT INTO oodNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kutsh am uhpam hih g Jesus mash am kih. Tsh hegam gamai gohk am i oi. Kutsh g hemajkam am ep i e hemapad k shaꞌi si muꞌida. Tsh heg hekaj pi e nako mas ep wo e gegos idam Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kutsh am i kah g hahajunij k ab i hihim k am chum s‑behimk hab elidch mat sha heb hu wua g e‑chegitoi. ");
INSERT INTO oodNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sh am hai gegok g chehanig ha mashchamdam ch am dada Jerusalem t amjed ch ash hab kaij, “Jijawul ha‑geꞌejig oki an uꞌukch g chegitoidaj ihda.” Sh haꞌi ep hab kaij, “Moki g jijawul ha‑geꞌejig ab mahkch g gewkdag. K id hekaj gam hu hab i ha wua g jijawul ab ha amjed hegam mo an ha uꞌukch.” ");
INSERT INTO oodNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tsh oi wa g Jesus ab i ha waid k hab masma am i ha tashogi, “Kus haschu ahgk hig g Jiawul wo i wuhshad g hejel e‑pionag? ");
INSERT INTO oodNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","S‑mahch am mat g oꞌodham wo padch g hejel e‑jewedga mat ab aꞌai wo e cheggia. ");
INSERT INTO oodNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kut g e wehm kihkam hab waꞌap wo padch g hejel e‑kihdag mat ab aꞌai wo e cheggia. ");
INSERT INTO oodNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pegih, t has hig masma g jijawul pi wo padch g hejel e‑gewkdag mat ab aꞌai wo e cheggia? ");
INSERT INTO oodNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Neh, wohppoꞌid ani g ge Jiawul hegam mo an ha uꞌukch. Kum s‑mahch mat pi hedai wo shaꞌi e nako mas am hu wabsh wo wah hema kih ed mat wo s‑haꞌahamak k am wo ui g enigaj, heg hi wa matp wehpeg wo wulsh. ");
INSERT INTO oodNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Wehs o gam hu hab i junihog g pi ap ha‑chuꞌijig g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","K wabshaba si geꞌej g em‑chuꞌijig mamtp ab wo has ah g Hekia S‑apꞌekam Gewkdag. T g Jiosh pi hekid gam hu hab wo i juh.” ");
INSERT INTO oodNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bash kaij g Jesus no pi hab ge ahg mash g ge Jiawul uꞌukch. Kush eda d Hekia S‑apꞌekam Gewkdag mo an uꞌukch. ");
INSERT INTO oodNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Kutsh am hahawa dada g jeꞌej ch wepngaj g Jesus matsh wo nei. Sh wabshaba muꞌijj an wehgaj dadha g Jesus. Sh heg hekaj gam hu wabsh gegok jeg ed ch am chum waid. Kumsh am ahgid, “Nehꞌe, m‑jeꞌe ch m‑wepnag o am gegok jeg ed ch ab m‑waid.” ");
INSERT INTO oodNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","Sh g Jesus an i nenhoghi. Kush muꞌi an wehgaj dadha hegam mo ab kaiham. Kush hab kaij, “Neh, idam mo ab ni‑kaiham o heg wa wepo mo d ni‑wepnag ch ni‑jeꞌe. ");
INSERT INTO oodNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Hegam mat hab wo junihid g Jiosh tatchui o hab a masma mo d ni‑wepnag ch ni‑jeꞌe.” ");
INSERT INTO oodNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sh am hu i hebai, sh g Jesus am ep ha mihshmad ge shuhdagi hugid an. Kush shaꞌi si muꞌi hemajkam an wehgaj. Tsh heg hekaj gan hu i chesh g Jesus wahlko ch ed k an dahiwua k amjed ha mashcham. Sh hegam gan hu wabsh gegok shuhdagi hugid an. ");
INSERT INTO oodNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kush muꞌi haꞌichu ha tashogid g wepogida ahgakaj ab amjed g Jiosh kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Id ash d haꞌichu ahgaj mo hab kaij: “Am ant heꞌes wo i em‑tashogi g Jiosh kownaltalig wepogidch mat hema an i chum gantad g e‑kaichka e‑oid ed. ");
INSERT INTO oodNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","T haꞌi gan hu wabsh shul wohg ch ed. T g uꞌuwhig am dada k koꞌito. ");
INSERT INTO oodNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kut haꞌi gan hu wabsh shul waw t ab mo pi geꞌej g jewed k ab ha hekaj hi wa chum i wuhsh no pi pi an hu juhk g jewed. ");
INSERT INTO oodNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","T oi wa hekid ab i chesh g tash. T ha hekaj wabsh gaksh no ge mehk tatk. ");
INSERT INTO oodNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","T haꞌi gan hu wabsh ep shul shaꞌi ch ed. T oi wa hekid ab i geꞌege g shaꞌi k wabsh ha kokda. T pi ab hu ha kait. ");
INSERT INTO oodNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","T wabshaba hegam mat gan hu shul moihuna ch ed an i wuhshani k ab kait. Haꞌi atp hems waikko wehst‑mahm ab kait k haꞌi ep chuhdpo wehst‑mahm ab ep kait k haꞌi siant ab ep kait. ");
INSERT INTO oodNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Neh, am g wo i oidahim ahpim mam kah ihda.” ");
INSERT INTO oodNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Neh, bash kaij g Jesus ch amjed am hahawa i e hejelkai. Kutsh ab wui i hihi g chuhchaij haꞌi ep ha wehm k ab kakke, “A tt has masma wo s‑ha amich g haꞌichu wepogida ahga?” ");
INSERT INTO oodNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kush hab kaij ab ha wui, “Nt wo em‑ahgi mo has d ahga no pi g Jiosh em‑hiwgid mamt wo s‑mai hegai mo hemu am maskogid ab amjed g e‑kownaltalig. Ni wabshaba heg waꞌi ha ahgid haꞌichu wepogida ahga hegam mo pi ab hu wohochudamk. ");
INSERT INTO oodNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","T hab pi wo amich haꞌichu ab amjed g Jiosh kownaltalig, chum as wo haꞌichu neid k wo haꞌichu kah. T g Jiosh pi gam hu hab wo shaꞌi i juh g pi ap ha‑chuꞌijig, heg hi wa mat ab wui wo i e nohnogi.” ");
INSERT INTO oodNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kush hab ha ahg g Jesus, “Muꞌi ani haꞌichu chum em‑ahgid g haꞌichu wepogida ahgakaj. Kumki eda pi amichud. Nt hemho am wo wa em‑tashogi. ");
INSERT INTO oodNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Hegai haꞌichu eshdam ani wepogid hegai mat an wo ahgachugad g Jiosh haꞌichu ahga. K g kaichkaj d Jiosh haꞌichu ahga. Id at am wo chum e ei oꞌodham amichudadag ed. ");
INSERT INTO oodNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","K eda haꞌi g ha‑iꞌibdag s‑kawpk hab masma mo g wohg. T g Jiawul am wabsh s‑pehegi wo ha wohppoꞌi mo haschu i kah. ");
INSERT INTO oodNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“K haꞌi g ha‑iꞌibdag hab sha masma mo hebai pi geꞌej g jewed ab waw t ab. T idam wo si s‑hohhoꞌi Jiosh haꞌichu ahga ab kaiok k wabshaba pi wihnam ab hu wo bebhe k ch ab hi wa al heꞌes wo s‑wohochudad. ");
INSERT INTO oodNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","T ab wabsh wo i chum hih g aꞌappema. T ha hekaj wabsh wo taꞌi i shul. ");
INSERT INTO oodNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“K haꞌi g ha‑iꞌibdag hab sha masma mo hebai s‑shaꞌig ");
INSERT INTO oodNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","no pi e shaꞌijidch heg hekaj kudutadag ch s‑kaisdag ch s‑tahhadkam. Kut pi haꞌichu hab wo juh am Jiosh wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“K haꞌi g ha‑iꞌibdag s‑moik hab masma mo g moihuna. Kut ab wo kaiha g Jiosh haꞌichu ahga k am wo si i nuhkud e‑ihbdag ed k gam hu wo i ha ahgidahi g hemajkam k haꞌakia ab wo waꞌi ep ha baꞌiha, Haꞌi atp hems waikko wehst‑mahm wo i ha baꞌiha k haꞌi chuhdpo wehst‑mahm k haꞌi siant ab ep wo i ha baꞌiha.” ");
INSERT INTO oodNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kush hab hahawa ep kaij am ha wui, “Wohokam o wepogidas mo g lahmpa tonlig. Namt hig wo ehsto g lahmpa ab mehidk aha namt an wo dai mat hebai wo em‑tonlidch. Pegih, mt hab wa masma pi wo chum ehsto g wohokam. ");
INSERT INTO oodNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wehs at wo s‑e mai matp haschu chum e ehstokch. ");
INSERT INTO oodNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Am g wo i oidahim ahpim mam kah ihda.” ");
INSERT INTO oodNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sh hab ep kaij am ha wui, “Am g wo s‑amichud mam haschu i kah. Mamt has i masma s‑baꞌama ab wo haꞌichu ha mah hedai i, t hab masma ab uhpam wo i e nodagi haꞌichu ab em‑wui ch atp hems gam hu baꞌich i. ");
INSERT INTO oodNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hegam mat s‑ap wo hekaj g e‑apꞌedag at baꞌich ep wo i nei. T hegam mat pi ap wo hekaj wabsh wo heb hu wua.” ");
INSERT INTO oodNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sh hab ep kaij g Jesus, “Jiosh kownaltalig o heg wepogidas matp hems g oꞌodham am gantad g haꞌichu kai e‑oid ed. ");
INSERT INTO oodNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","k am haha wabsh nenida heꞌekia i tash. T g eshaj am i wuhshani k hahhagt k ab hahawa mudadagt k ab kait. K eda pi mahch g oꞌodham mo has masma hab e wua ");
INSERT INTO oodNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","no pi g haꞌichu kai wabsh hejel ab i wuhshani ab jewed t amjed. ");
INSERT INTO oodNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","T am wabsh i chum bai. Kut am ha hekaj ha cheha g e‑chikpandam mat wo hihk k wo i baꞌiha.” ");
INSERT INTO oodNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kush hab ep kaij, “Am ant baꞌich wo i em‑tashogi g Jiosh kownaltalig am wepogidch g haꞌichu kai. ");
INSERT INTO oodNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Neh, heg am eꞌesha mo al chumaj ");
INSERT INTO oodNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ch oi wa am wo wuhshani k haꞌas wo i geꞌeda mo g s‑ehheg uhs. Tp hems heg ab an wo koksht g uꞌuwhig. Pegih, t hab wa masma wo geꞌe i geꞌeda g Jiosh kownaltalig, chum as al chum wo shonwua.” ");
INSERT INTO oodNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Neh, bash masma heg waꞌi hekaj am ha mihshmad wepogida ahga mat heꞌes wo i s‑amich. ");
INSERT INTO oodNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tsh gam hu wo hihi g hemajkam. Kutsh am haha wabsh baꞌich wo i ha tashogi g e‑chuhchai g haꞌichu e‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tsh gam hu si i juh. Sh hab ha ahg g Jesus, “Oi g wo. Ga att hu shuhdagi aigojed wo i chehchsh.” ");
INSERT INTO oodNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kutsh am i ha dagito g hemajkam k ab i chehchsh wahlko ch ed wehmaj g Jesus. Kutsh eda am haꞌi ep chum i ha oi g al wapalko. ");
INSERT INTO oodNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tsh ab haha wabsh i meh g s‑gewk jegos k shaꞌi si hewed. Tsh g shuhdagi shaꞌi si uhgk hab i e juh k ged hu wabsh e was wahlko ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sh eda am woꞌok ch kohsh g Jesus si baikko g wahlko. Kutsh am wuha g chuhchaij k hab ahg, “Nap pi has shaꞌi elid mattki wo wachkk.” ");
INSERT INTO oodNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tsh am hahawa wamig k ab si wui neo g hewel ch shuhdagi k hab ahg, “Am g wabsh i dodolimat k haꞌasa i hewed.” Kutsh ab wabsh si heweto k g shuhdagi gam hu wabsh i pi hoini. ");
INSERT INTO oodNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sh hab hahawa kaij ab ha wui, “Pi g am wo haꞌichu ehbidad ch ab wabsh wo ni‑hiwgad.” ");
INSERT INTO oodNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kutsh eda si s‑ehbeni k wabsh ab aꞌai i e kakke, “A kus hedai wud ihda oꞌodham mat g hewel ch shuhdagi ab kaiha.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kutsh gam hu dada miabidch mo am d Gerasa kihhim. ");
INSERT INTO oodNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tsh ab wabsh i chum hud g Jesus wahlko t amjed. Kutsh ab hema nam g cheoj mash ab e ulish cheo ch ed mash eda ab d hihaꞌini. ");
INSERT INTO oodNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Sh g jijawul an uꞌukch ihda. Kush pi hedai e nakog mas wo mahshoch. ");
INSERT INTO oodNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Muꞌikko amsh chum wulshshap g e hukshchim wapainomikaj. Sh wabshaba wabsh wanikumiak. Sh pi hedai e nakog mas wo shohbi nash pi shaꞌi si s‑gewk. ");
INSERT INTO oodNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tash oidam ch chuhug oidam ash am ulinig hihaꞌini ch ed ch am doꞌag shahgid am hihnk ch e hikkumiak g hohodaikaj. ");
INSERT INTO oodNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tsh am jiwia g Jesus. Kutsh mehkjed chehg k am med k ab i gei wui. ");
INSERT INTO oodNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","k am si s‑kaidam neok k hab ahg, “Ni‑dagitoni, ahpi alidaj g si Jiosh. Bani m‑ahgid ab si ihmch g Jiosh mapt pi ia hu wo ni‑hudawogad.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bash kaij nash pi g Jesus ab i s‑wuhshdamk g jiawul id amjed oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sh g Jesus ab hahawa kakke, “Shahp chehgig?” Sh hab kaij hegai oꞌodham, “Bani chehgig ‘Muꞌichu’ nach pi muꞌij,” ");
INSERT INTO oodNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ch ab wui si e shoꞌigchud mat pi mehk gam hu hab wo i ha juh hegam jijawul mo an uꞌukch. ");
INSERT INTO oodNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kush eda inhab shaꞌi si muꞌi kokji e nuhkud kawulk huda. ");
INSERT INTO oodNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kutsh g jijawul ab si tahni g Jesus, “Am g hig t‑hiwgid matt am wo i wahp ha eda hegam kokji.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kutsh ha hiwigi. Kutsh ab i wuwha heg amjed oꞌodham k gam hu hihim k am i wahp ha eda hegam kokji. Kutsh idam am e totodsid k am agshp i wohp k ged hu shul ge shuhdagi ch ed k wachkk k ash eda am hu d i gohk mihl. ");
INSERT INTO oodNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hegam mash am chum ha nuhkud atsh e totodsid k wohp k gan hu wehsko ha ahgid mat has e juh. Kutsh am himto g hemajkam s‑neidamk matsh haschu has e juh ");
INSERT INTO oodNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","k am hu dada. Kush am dak ch e enigadadch ch ash wabsh s‑apꞌe. Kutsh wehsijj si e totods. ");
INSERT INTO oodNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hegam mash am neid atsh an i ha ahgidahi mat has e juh hegai mo g jijawul an uꞌukch k am ep ha ahgi mat has e juh g kokji. ");
INSERT INTO oodNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kutsh ab wabsh si s‑bahbagi i ahgi g Jesus g hemajkam, “Mapt gam hig wo i e mehkod ab t‑amjed.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kush g Jesus an cheshajhim wahlko ch ed. Tsh ihda oꞌodham mash g jijawul uꞌukch ab chum ahgi, “Nt wo m‑oi.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kutsh oi wa pi hiwgid k ash hab wabsh ahg, “Pt wabsh wo wa hih am e‑kih wui k wo ha ahgi g e‑nanꞌaipijju mat haschu si s‑kehg hab m‑juni g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kutsh gam hu hih ihda oꞌodham k gan hu ha ahgidahi g hemajkam amai mash am d Wehst‑mahm Kihhim matsh heꞌes geꞌe haꞌichu hab juni g Jesus. Kutsh wehsijj ab si has i e taht hegam mash kah. ");
INSERT INTO oodNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kutsh an ep dadhaiwua idam Jesus wahlko ch ed k gn hu aigo i chehchsh. ");
INSERT INTO oodNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tsh ab hema i hih g oꞌodham k d haꞌichu amai ha‑cheopi ed ch hab chehgig Jairus. Tsh ab i hud g Jesus. Kutsh ab wui i gehsh ");
INSERT INTO oodNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","k hab kaij, “Si g s‑ni‑hoꞌigeꞌid. Ni‑chehiaga o muhkhim. Pt am wo him k wo doaj.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kutsh am i chum hih matsh wo oi ihda oꞌodham. Kush eda g hemajkam gan hu wabsh i si bihagch. ");
INSERT INTO oodNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sh eda am hema haꞌichug g uwi ch mumku gamai gohk aꞌahidagkaj. Sh heg wehs oidam g ehꞌedaj chum hekid jegwoni. ");
INSERT INTO oodNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kush muꞌi haꞌichu nakog ab ha amjed g mamakai ch wabshaba wabsh baꞌich i mumku. Kutsh g lialigaj huhug. ");
INSERT INTO oodNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Sh am hahawa i kah mash haschu has junihim g Jesus. Kutsh am s‑apkot matsh am wo jiwia wui. Kutsh ab oidk i him k an taht g wehschugaj ");
INSERT INTO oodNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","hab e ahgch, “Chum anis hems an wabsh wo taht g wehschugaj, t wo ni‑apꞌet.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tsh ha hekaj am wabsh si huh g ehꞌedaj. Tsh e taht mat apꞌet. ");
INSERT INTO oodNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kutsh g Jesus taht matsh g doajig gewkdag sha wuhsh ab ab k am ha hekaj i sikoliwua hemajkam ha wui k hab kaij, “Doht an ni‑taht?” ");
INSERT INTO oodNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kush hema hab kaij g chuhchaij, “An o si i t‑bihagch g hemajkam. Kup haschu ahgch hab kaij, Doht an ni‑taht?” ");
INSERT INTO oodNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kutsh an i nenhoghim k ab i nei hegai uwi matsh an taht. ");
INSERT INTO oodNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kutsh heg si e todsid k ab wui i gehsh k am ahgi mat doa. ");
INSERT INTO oodNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sh hab kaij g Jesus, “Pegih, ni‑uwiga, am apt wa doa nap pi ab si ni‑hiwig. Gam g s‑ap e‑taht k hihm k am wabsh s‑doakad.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kush am wabsh kia neok. Tsh am haꞌi dada ab kihj amjed hegai Jairus k hab kaij, “Muh at g m‑chehiaga. Kupt haschu hig ahgk am baꞌich wo i kudu g ha mashchamdam?” ");
INSERT INTO oodNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kush wabshaba hab kaij g Jesus ab Jairus wui, “Pi g am shaꞌi has e tahtkkad ch am wabsh i ni‑hiwgad.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bash kaij ch am hahawa ha ui g Peter ch James ch John k am i oi. ");
INSERT INTO oodNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kutsh am hihim k ged hu dada mash am kih g Jairus. Kush am wabsh si s‑nakosigam hab e wua no pi si shoani g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kutsh am i wah g Jesus kih ch ed k hab kaij ab ha wui, “Pi g am wo shoanid. Heg o wa wepo ni‑wehhejed mo wabsh kohsh g chehia.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kush wehsijj si s‑koꞌokam ash nash pi s‑mahch matsh heki hu muh. Kutsh gam hu i ha wuhwhasid k am i ha ui hegam mash am wehmaj k am i wahp amai mash am woꞌo g muhki. Tsh g jehjij am ep i ha oi. ");
INSERT INTO oodNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tsh g Jesus ab bei nowij ab k hab kaij, “I wamigi, chehia.” ");
INSERT INTO oodNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kutsh ab ha hekaj i wami g chehia k ab i hih. Kutsh si has i e taht g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sh hab kaij g Jesus, “Ab g wabsh mahki g chehia g haꞌichu hugi.” Kutsh ab mah. Sh hab ep ha ahg mat pi hedai wo shaꞌi ahgi mat has e juh. Kush d gamai gohk aꞌahidag ihda chehia. ");
INSERT INTO oodNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tsh gam hu hahawa hihi idam Jesus k ged hu dada Nazareth t am mash am d si kihkam g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kush am d i t‑mihshmda tash. Tsh am ep ha mihshmad g Jesus ha‑cheopi ed. Kush muꞌi hemajkam am haꞌichug ch am kah ch si has i e tahtam k ab aꞌai si e kakke, “Kus hebai mai wehs ihda amichudadag k has masma hab wua ihda s‑hasig haꞌichu? ");
INSERT INTO oodNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","No hig pi woho d wabsh hegai huk chikpandam mo d madaj g Mary ch d ha‑wehnag g James ch Joses ch Judas k ch Simon? No hig pi woho g uꞌuwi wepngaj ia kih?” Neh, bash kaij ch wabsh pi haꞌichuchud. ");
INSERT INTO oodNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sh g Jesus si has i e tahtk ch hab kaij, “Jiosh haꞌichu i tashogiddam at chum hebai ab si has wo e elidad. T wabshaba g si kihꞌamkam oꞌodham ch wehmaj kihkam pi ab hu has wo elidad” ");
INSERT INTO oodNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kutsh heg hekaj pi e nako mas g si s‑hasig haꞌichu hab wo junihid amai ch heg hab waꞌi juh mat al heꞌekia kokꞌodam ha dodaj. ");
INSERT INTO oodNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kutsh am hahawa i ha mihshmdahi g Jesus an wehgaj g Nazareth mo hebai i kihhimag. ");
INSERT INTO oodNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Am hu hebai, tsh am ha cheha g e‑chuhchai matsh goꞌogok e wehm am wo ha mihshmdahi g hemajkam k gam hu hab wo i ha juh g jijawul ab ha amjed hegam mo an ha uꞌukch. ");
INSERT INTO oodNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Neh, bash ha ahg, “Gm amt hu wabsh wo i hihim k heg waꞌi e‑cheowikud wo uꞌad ch pi wo bek g e‑limoshan kostal o g lial o g haꞌichu hugi o g haꞌichu eniga. ");
INSERT INTO oodNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mt ab wo i em‑wahpkid k wo em‑dagioꞌidad mamt hebai wo i ha mihshmad. ");
INSERT INTO oodNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kumt amokad k ab wo ai mamt baꞌich ep wo hihi. ");
INSERT INTO oodNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mt gam hu wabsh wo hihi mamt hebai pi ap ab hu wo i em‑nei gam hu shahmudk g e‑shuhshk. T id wo ha chehgi mamt wabsh wo ha dagito nat pi pi ap hab chuꞌi. Dohwai.” ");
INSERT INTO oodNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kutsh wa woho an aꞌai i ha ahgidahi g hemajkam matsh gam hu wo s‑ohhod g pi ap e‑chegitoi. ");
INSERT INTO oodNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kutsh ab iawua g huhudakud ha‑mohmi ab g kokꞌodam. Kutsh doda. Tsh muꞌi gam hu hab ep i ha juh g jijawul ab ha amjed hegam mo an ha uꞌukch. ");
INSERT INTO oodNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","15","An o wa wehsko hab kaidag mash has e junihim g Jesus. Kum am chum aꞌaga mas hedai wud. Haꞌi o hab kaij matp hems d Elijabad o hema ehp hegam kekelibad Jiosh haꞌichu i tashogiddam. K haꞌi hab ep kaij matp hems d hegai Johnbad mat wa am i shonwuich g pahl wakona. E atsh wa muꞌajid k atp hems uhpam e chegito k hab s‑hasig haꞌichu hab junihim. ");
INSERT INTO oodNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Sh hegai Herod mo am d wa kownal Galilee chekshani ch ed hab ep kaij, “Doki hegai John mo wa ha pahl wapkonahim. Heg ant mua. Kutki wabshaba uhpam e chegito k hekaj hab e nakog mat hab wo juh g s‑hasig haꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Ihda Herod atsh wa heg hab juh am wehhejed g e‑hohnig. Heg ash hab chehgig Herodias ch ash d chum hohnigaj g Herod wehnag. Kush heg hab chechgig Philip. Tsh g Herod ehs g hohnigaj. Sh amjed g John chum hekid hab chum aꞌaga, “Mo pi shaꞌi apꞌe maps g e‑wehnag hohnig wo ehs.” Sh g Herodias heg hekaj s‑kehꞌid ch am chehani g e‑kun mat wo mua. Tsh Herod ha cheha g e‑shondalig mat wo be k wo kuh. K wabshaba si s‑ap d oꞌodham g John. Kush heg hekaj s‑ehbid g Herod ch wabsh kuhpch ch s‑ap nuhkud. Sh hab pi e nakog g Herodias mas wo mua. Kush g Herod s‑hohhoꞌid ch kah g John mihshmda, chum as si e kudut heg amjed. ");
INSERT INTO oodNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sh g Herodias am wabsh nenida mat am wo s‑apꞌet. Kutsh am hu hebai s‑apkot wehhejed matsh e ai g Herod mahsidag tash. Kutsh g Herod ab i ha wai g e‑shondalig ha‑geꞌegeꞌejig ch hegam mo d si hahaꞌichu am Galilee ch ed. Tsh ab i hihim k am wehmaj piast. ");
INSERT INTO oodNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tsh am i wah g uwi madaj g Herodias k am e waila. Kush wehsijj s‑hohhoꞌid. Sh g Herod hab ahg, “Maptp haschu hab wo i elidad ch ab wo i ni‑tai, nt hab wo m‑juni.” Sh pi has shaꞌi kaij ihda uwi. ");
INSERT INTO oodNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kush hab hahawa ep si kaij, “Maptp haschu ab wo i ni‑tai, nt wo m‑mah, chum as hems eda hugkam g ni‑kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kutsh am hahawa him k am kakke g e‑jeꞌe, “Shahchu ant wo tai?” Sh hab kaij g jeꞌej, “John moꞌo apt wo tai” ");
INSERT INTO oodNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tsh ab uhpam i wah k hab ahg g Herod, “John moꞌo apt wo ni‑mah am hoas‑haꞌa ch ed dahshk” ");
INSERT INTO oodNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kutsh si pi ap e taht g Herod. Sh wabshaba wehsijj kah mo has i kaij. Tsh heg hekaj pi e nako mas pi am hu hab wo juh, ");
INSERT INTO oodNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","neh, k am hema cheha g shondal mat am wo him k an wo shonchk g John moꞌo k ab wo i bek. Kutsh am hih lilso ha‑kih wui k an shonch g kuswoj g John ");
INSERT INTO oodNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","k am uꞌapa g moꞌoj ab hoas‑haꞌa t ab k ab mah g uwi. Tsh g uwi am him k ab mah g e‑jeꞌe. ");
INSERT INTO oodNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kutsh am i kah hegam mo ab si wecho e mashcham g John matsh e muhkid k am hihim k am bei g honaj mat wo s‑ap juh. ");
INSERT INTO oodNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tsh am i uhpam dada g Jesus chuhchai k am wehs ahgid mat haschu has i juh k haschu ep ha mashcham. ");
INSERT INTO oodNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sh eda iaꞌi idani muꞌi am daiw g hemajkam. Tsh pi am hu shaꞌi ha apkot mas wo e gegos idam Jesus. Sh hab ha ahg g Jesus, “Am att hig wo t‑hejelkod k wo shaꞌi t‑uhꞌulinihogi.” ");
INSERT INTO oodNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kutsh gam hu hejelko hihi g wahlkokaj. ");
INSERT INTO oodNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Muꞌijj ash ha neid mat gam hu hihi ch gam hu ha baꞌich wohp k gam hu heki hu dada. Kutsh idam am hahawa i dada ");
INSERT INTO oodNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","k am i huhud. Tsh g Jesus am i ha nei. Kush hab sha masma mo g heb hu hihimkam kakawal. Kutsh ab si i s‑ha hoꞌigeꞌid k muꞌi haꞌichu ha mashcha. ");
INSERT INTO oodNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kutsh gam hu si i juh. Tsh g Jesus chuhchai am wui dada k hab chum ahg, “Neh, mehk at waꞌi juh. K eda ia hu wabsh si jegko. ");
INSERT INTO oodNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Am g ha ahgid g hemajkam mat gam hu wo hihi kihhim wui k wo ha nolawt hegai mat wo huh” ");
INSERT INTO oodNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kush hab ha ahg, “Ahpim amt wo haꞌichu ha mah mat wo huh.” Sh hema hab kaij idam, “A tt haschukaj wo ha gegos? Muꞌi lial at wo nam g haꞌichu hugi matt hekaj wo ha gegos.” ");
INSERT INTO oodNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sh ab ha kakke, “Shahchu o am i kahch? Am g wo neid.” Kutsh am neid k hab ahg, “Hetasp sismito ch gohk waptopi.” ");
INSERT INTO oodNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kush hab ha ahg mat wo ha ahgi g hemajkam mat wehsijj am wo dadhaiwua jewedo heꞌekiajj i e wehm. ");
INSERT INTO oodNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tsh am ha cheha. Kutsh am dadhaiwua heꞌekiajj i e wehm, haꞌi am hu i siant k ch haꞌi am hu i hehetaspo wepst‑mahm. ");
INSERT INTO oodNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kutsh g Jesus am ui hegai haꞌichu hugi k am e dahm i nen k ab hoꞌigeꞌel g Jiosh k am hahawa hahai hegai sismito k ab ha mah g e‑chuhchai. Tsh an i ha mahkhi g hemajkam. Kutsh g waptopi an ep i hahain k ha mah. Tsh an i ha mahkhi. ");
INSERT INTO oodNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tsh wehsijj hug k oi wa hi si s‑kokwod. ");
INSERT INTO oodNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kutsh g chuhchaij an i uꞌihim k uꞌapa g wihpiꞌidaj mat am huꞌi gamai gohk hoha wo ha shuhshud. ");
INSERT INTO oodNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kush am hu d i hetasp mihl chechoj ch muꞌijj g uꞌuwi ch aꞌal hegam matsh am e gegos. ");
INSERT INTO oodNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tsh am hahawa ha ahgi g e‑chuhchai matsh gam hu aigo wo hihi heg wui kihhim mo hab chehgig Bethsaida. Tsh heg am wo wiꞌi k am wo ha ahgi g hemajkam mat gam hu wo hihi e‑kihki wui. Tsh heg hekaj an i chehchsh wahlko ch ed k gam hu hihi. ");
INSERT INTO oodNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tsh g Jesus am ha dagito g hemajkam. Tsh gam hu himto. Tsh am hahawa hejel i chesh kawulk dahm k am e hoꞌigeꞌidahun. ");
INSERT INTO oodNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tsh am i hud. Sh am wabsh kia hejel haꞌichug. Tsh g wahlko gam hu si eda i cheka g shuhdagi. ");
INSERT INTO oodNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kush g hewel ab si s‑gewkam med ha wui. Sh hekaj pi ap him. Kush s‑ap ha neid g Jesus mash shaꞌi si s‑wihnam himchud g wahlko. Tsh koi mahsi. Kush ab him ha wui an wabsh shuhdagi dahm k hab e juh matsh an wabsh wo bij. ");
INSERT INTO oodNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tsh wabshaba am i nei s‑chuhugam k ed k am si hihnk nash pi si s‑ehbini hab e ahgch mash d wabsh kokꞌoi. ");
INSERT INTO oodNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kush hab ha ah, “Pi g wo shaꞌi ni‑ehbenid. Dani ahni. Mt oi wo s‑ap e taht,” ");
INSERT INTO oodNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","k gan hu hahawa i chesh wahlko ch ed. Kutsh am wabsh si heweto. Tsh idam si has i el ");
INSERT INTO oodNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","nash ge shaꞌi amichud mokis haꞌas edgid gewkdag. K eda d si s‑hasig haꞌichu mat ha gegos hegam muꞌi hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kutsh ga hu aigo i chehchsh k ab dada amai mo am d Gennesaret k am wulsh g wahlko. ");
INSERT INTO oodNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tsh g hemajkam ha hekaj s‑amich g Jesus ");
INSERT INTO oodNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","k gan hu aꞌai wohp k an i ha uꞌihi g kokꞌodam an ha‑wohpikud ab k ged hu ha uꞌapa Jesus wui. ");
INSERT INTO oodNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kush an oiopo hegam Jesus ch am daiw kihhim ch ed ch oidag ch ed. Kutsh g hemajkam ab wui wo ha uꞌapad g kokꞌodam ch ab wo ahgidad g Jesus mat wo ha hiwigi g kokꞌodam mat chum hems wabsh g hugidaj g enigaj an wo taht. Kush wehsijj doda an tahtamk. ");
INSERT INTO oodNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kutsh ab haꞌi hihi g Palasi ch chehanig ha mashchamdam k am e hemapai an ha wehgaj hegam Jesus. Tsh eda wo chum e gegos. ");
INSERT INTO oodNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kutsh idam am cheh matsh am haꞌi wabsh dadhaiwua pi hab masma ha wapkonk g e‑nohnhoi mo hab masma d ha‑himdag g kekelibad. ");
INSERT INTO oodNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ahchim Tutuligo ach muꞌi haꞌichu hab masma hab chum wua mo wa g t‑kekelibadga. K idam Palasi wehs t‑baꞌich i s‑gewkam oid g ha‑chehanig ch pi haꞌichu wo huh pi hab masma ha wapkonk g e‑nohnhoi mash wa g kekelibad. ");
INSERT INTO oodNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kut g haꞌichu hugi hab waꞌap wo si e wapko mamt hekid ab wo i ui tianna t amjed. T g hohas‑hahaꞌa ch hihidodakud ch chum hems g wohpikud hab masma wo e wapko mash wa g kekelibad hab wua. ");
INSERT INTO oodNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kush heg hekaj idam Palasi ch chehanig ha mashchamdam ab kakke g Jesus, “K haschu ahgch pi ab hu wohog elid g haꞌichu ha‑mashchamadag g kekelibad idam mo ab si m‑wecho e mashcham? Neh, e o gegosid pi am hu t‑himdag oidch ha wapkonk g e‑nohnhoi.” ");
INSERT INTO oodNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","8","(8) Kush hab kaij g Jesus, “Kum ahpim haschu ahgch im hu hab wabsh wua g Jiosh chehanig ch im hu haꞌab ab s‑wohochud g ha‑chehanig hegam mo d kekelibad ch d wabsh oꞌodham? (6) Isaiabad oki si s‑ap hab em‑ahg ahpim mam hab wabsh s‑e junimk mat eda an oꞌoha mash hab kaij g Jiosh: Haꞌi idam mo d chum ni‑hemajkamga o hab kaij mo ab si has ni‑elid ch ab ni‑ihm. K wabshaba g ha‑iꞌibdag si s‑kawpk ch si mehk ab ni‑amjed. (7) Pi o shaꞌi wohom ab has ni‑elid no pi wabsh g hemajkam ha‑chehanig ha mashcham hab chum masma mo d ni‑chehanig. Neh, bo kaij g Jiosh. Kum ahpim s‑wohom hab masma mo wa an oꞌohanas.” ");
INSERT INTO oodNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","K hab ep kaij g Jesus, “Si am s‑e mahch mamt has masma im hu hab wabsh wo i juh g Jiosh chehanig ch am wo wa hekajid mo haschu d hejel em‑mashchamig. ");
INSERT INTO oodNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesbad at an oꞌoha mo hab kaij g Jiosh: Ab g si has wo i ha elidad g e‑ohg ch e‑jeꞌe, ch id ehp: Mat hemho wo wa e muhkid hegai mat hedai wo sha s‑koꞌokam has ha ah g e‑jehj. ");
INSERT INTO oodNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kum eda ahpim ha mashcham mat pi ab hu has wo ha elidad ch ab ha wui hab wo chei, ‘Mah ant g Jiosh hegai mat haschu ab d wo i chum em‑wuikamk.’ ");
INSERT INTO oodNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","T hahawa pi haꞌichu hab wo ha juni g e‑jehj. ");
INSERT INTO oodNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kum hab masma im hu hab wabsh i wua g Jiosh neꞌoki ch am ha mashcham mo haschu d wabsh oꞌodham ha‑nahtoi. K muꞌi d haꞌichu mam hab masma hab ep wua” ");
INSERT INTO oodNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","16","Kutsh am hahawa ep ha wai g hemajkam k hab kaij am ha wui, “Ab g wo i ni‑kaiham wehsijj ahpim k wo s‑amich ihda. (15) Pi at im hu hab wo shaꞌi em‑juh g Jiosh heg hekaj mamt haschu wo huh k wabshaba im hu hab wo i em‑juh heg hekaj pi kehg em‑chegitoidag.” ");
INSERT INTO oodNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tsh am i ha dagito g hemajkam k im hu wah kih ch ed. Kumsh ab hahawa kakke id amjed. ");
INSERT INTO oodNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Sh hab kaij, “Pegih, kumtp ahpim hab waꞌap pi amichud. Pi at im hu hab wo shaꞌi i em‑juh ab amjed g Jiosh mamt haschu wo huh ");
INSERT INTO oodNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","nat ge am hu wo i wah em‑chegitoi ed k wabshaba ged hu em‑wohk ed wo wah k amjed gam hu wabsh wo wuhsh.” Pegih, t hab masma am ha ahgi g Jesus mo wehs g haꞌichu hugi s‑kehgaj. ");
INSERT INTO oodNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","k hab ep kaij, “Heg at im hu hab wabsh wo i em‑juh ab amjed g Jiosh pi ap em‑chegitoi ");
INSERT INTO oodNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","nat pi hab wo em‑juh mamt hab wo juh g haꞌichu pi apꞌekam. Neh, mtp hems hema haꞌichu wo ehs o wo ha mua ");
INSERT INTO oodNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","o wo ha ehs g ha‑wehm kihkam o wo tatchua g haꞌichu ha‑eniga o wo s‑chu iattomk o hab wo juh mat haschu si pi kehg hab wo mahsk o wo s‑chu hehgamk o hema wabsh wo s‑koꞌokam has ahgad o wo chum si e haschudad o wabsh pehegi has wo e wuad. ");
INSERT INTO oodNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Id at wehs ab wo i wuhsh ab amjed g pi kehg chegitoidaj g oꞌodham k im hu hab wabsh wo i juh ab amjed g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kutsh gam hu hahawa hihi hegam Jesus k am dadhaiwua hema kih am mash am miabidch g Tyre kihhim matsh wo shaꞌi e hejelkoch. Kush eda an wa s‑nenꞌoid g hemajkam ch ha hekai s‑mai mo am daha g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Kutsh am hema jiwia g uwi mash am kih heg eda jewed ch d gawul mahs oꞌodham ch gam hu d mahsikam Syria jewed ch ed. Sh g neꞌokij d Greek. Kush g jiawul an uꞌukch g chehiagaj. Tsh heg hekaj ab i hih g uwi k ab wui i gei g Jesus k ab si tahni mat gam hu hab wo i juh g jiawul ab amjed g chehia. ");
INSERT INTO oodNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sh wabshaba hab kaij g Jesus, “Heg at wo wa wepok mamt ab wo ha mah g gogogs g ha‑chechmait g aꞌal. Wehpeg ant am wo i apꞌech g pi ha‑apꞌedag g Tutuligo hemajkam no pi d chum Jiosh aꞌaliga.” ");
INSERT INTO oodNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kush hab kaij ihda uwi, “Woho o wa. T wabshaba chum hems g gogogs am wo wa huh g aꞌal ha‑haꞌichu hugi hahainig mat ab wo i shul mihsa wecho. Kunt ahni hab wa masma wo si s‑ap ni‑taht mapt id am hab wo al i ni‑juni.” ");
INSERT INTO oodNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sh hab hahawa kaij g Jesus ab wui, “M‑neꞌoki o am chehgid map ab si ni‑hiwig. Nt heg hekaj gam hu hab wo i juh g jiawul ab amjed g m‑chehiaga.” ");
INSERT INTO oodNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kutsh gam hu hih uhpam k s‑mai matki gam hu hab i e juh g jiawul ab amjed g chehiagaj. Kush an wabsh s‑ap woꞌo. ");
INSERT INTO oodNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kutsh gam hu hahawa hihi hegam Jesus k am gahi wuwha g Sidon kihhim ch Wehst‑mahm Kihhim chekshani k gam hu dada Galilee kahchki am. ");
INSERT INTO oodNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kutsh am haꞌi dada g hemajkam k am hema uꞌapa g oꞌodham mash pi chekaidag ch ep pi ap neok k ab i tahni g Jesus mat ab wo taht k wo doaj. ");
INSERT INTO oodNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kutsh imhab shaꞌi wuhshad hejelko k am i wahpki g al chuꞌuchum e‑nohnhoi am nahnkaj ed k am hahawa shaꞌi wadagi g e‑nowi g e‑siswuadagkaj k ab hekaj taht g nehnij ");
INSERT INTO oodNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","k am i neh e dahm k si i ihbhuiwua k hab kaij, “Doajini.” ");
INSERT INTO oodNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tsh hahawa chekaid. Tsh g nehnij apꞌet matsh s‑ap neo. ");
INSERT INTO oodNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kutsh g Jesus am hahawa wehs ha ahgi mat pi hedai wo shaꞌi ahgi ihda. Sh oi wa haha wabsh wehsko ahg ");
INSERT INTO oodNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","nash pi si geꞌe has elid ch hab kaij, “Shoꞌo waꞌi si s‑kehg haꞌichu hab junihim mo g pi chechkaidkam ha chechkaichud ch pi neneokdam s‑ap ha neokchud.” ");
INSERT INTO oodNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kush pi shaꞌi tash amjed. Tsh muꞌi am ep i e hemapai g hemajkam k ab kaiham g Jesus waik tashkaj. Sh hahawa pi an hu haꞌichug mas haschu wo huh. Tsh g Jesus am i ha wai g e‑chuhchai k hah ha ahg, ");
INSERT INTO oodNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Neh, waik tashkaj o in waꞌi t‑wehmaj idam hemajkam ch heki hu waꞌi pi haꞌichu huh. Ni s‑ha hoꞌigeꞌid. ");
INSERT INTO oodNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tp hems haꞌijj wo s‑e chuhugi matp gam hu wo sha hihi pi haꞌichu hugok.” ");
INSERT INTO oodNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sh hegam ab i kakke, “Kuchs hebai hig wo ui g haꞌichu hugi mat wehs wo ha aꞌahe idam?” ");
INSERT INTO oodNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sh ab ep ha kakke, “Heꞌekia at am i wih g sismito?” Sh hab kaij, “Wewaꞌak” ");
INSERT INTO oodNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesus atsh am hahawa ha ahgi g hemajkam mat am wo dadhaiwua. Kush am dadhaiwua. Tsh am ui g sismito k ab hoꞌigeꞌel g Jiosh k am hahawa hahain k ha mah g e‑chuhchai. Kutsh an i ha mahkhi g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kumsh am hi wa haꞌi al toꞌakch g waptopi. Kutsh ab ep hoꞌigeꞌel g Jiosh k am ha ahgi mat an ep wo i ha mahkhi. Tsh hab e juh. ");
INSERT INTO oodNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tsh wehsijj hug k oi wa hi si s‑kokwod, chum as am hu hebai d i giꞌik mihl chechoj ch muꞌijj g uꞌuwi ch aꞌal. ");
INSERT INTO oodNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tsh g Jesus chuhchai an i uꞌihi g wihpiꞌidaj mat am huꞌi wewaꞌak hoha wo ha shuhshud. Kutsh g Jesus am hahawa ha ahgi g hemajkam mat gam hu wo hihi. ");
INSERT INTO oodNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tsh idam Jesus am ha hekaj i chehchsh wahlko ch ed k gam hu hihi mash am Dalmanutha chekshani k am i huhud. ");
INSERT INTO oodNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kutsh am haꞌi dada g Palasi k ab neꞌowin g Jesus ch ab chum si chehani mat g si s‑hasig haꞌichu am wo ha chehgi matp woho d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kutsh g Jesus am si ihbuiwua k hab kaij, “Kus haschu ahgch ab ni‑kakke idam hemajkam mant g si s‑hasig haꞌichu am wo ha chehgi. Si ant s‑wohom hab wo chei mant pi am hu wo shaꞌi ha chehgi g si s‑hasig haꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Neh bash kaij ch am hahawa ha dagito. Kutsh an ep i chehchsh wahlko ch ed k gam hu aigo ep hihi. ");
INSERT INTO oodNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tsh eda pi chegito idam mat wo ui g sismito. Kush hemako am kahch. ");
INSERT INTO oodNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sh hab kaij g Jesus am ha wui, “Si g wo s‑e nenꞌoidk mat pi wo em‑cheawuagi g ha‑jewajidakud hegam Palasi ch hegam mo ab si has elid g Herod.” ");
INSERT INTO oodNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Sh hegam chuhchaij am hahawa aꞌaga ch hab kaij ab aꞌai e wui, “Heg oki hekaj hab kaij mach pi ha sismitoga” ");
INSERT INTO oodNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kush eda g Jesus s‑ha amichud mo has kaij ch hab ha ahg, “Pi amki koi amichud mani heꞌes edgid g gewkdag ch hekaj am aꞌaga mach pi ha sismitoga. ");
INSERT INTO oodNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Am am wa chum neid mant al hetasp sismitokaj ha gegos g hetasp mihl chechoj ch muꞌi ehp. Pegih, namt pi chegito ");
INSERT INTO oodNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","mamt heꞌekia i hoha shuhshud k ui g wihpiꞌidaj?” Kush hab kaij, “Gamai gohk.” ");
INSERT INTO oodNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sh hab ep kaij g Jesus, “Kumt heꞌekia i hoha shuhshud k ui g wihpiꞌidaj mant al wewaꞌak sismitokaj am ha gegos hegam giꞌik mihl chechoj ch muꞌi ehp?” Sh hab kaij, “Wewaꞌak.” ");
INSERT INTO oodNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kush hab kaij g Jesus, “Pegih, mt wo chum s‑mahchk mani heꞌes i edgid g gewkdag ch hab wo s‑amich mani pi heg hab ahg sismito ch wabshaba haꞌichu chum em‑tashogid ch heg am wepogid g jewajidakud.” ");
INSERT INTO oodNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kutsh gam hu dada Bethsaida t am k am i huhud. Kutsh g hemajkam am hema uꞌapa g oꞌodham Jesus wui mash pi nea k ab i e shoꞌigch wui mat ab wo taht. ");
INSERT INTO oodNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kutsh an bei g pi neadam nowij an k am i wanimed k gam hu i wuhshad ab kihhim t amjed k ab hahawa siswua wuhpuij ab k ab ep taht k ab kakke, “Shahchu ap hig neid?” ");
INSERT INTO oodNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tsh ab i nen k hab kaij, “Neid ani mo an oiopo g hemajkam ch wabshaba hab sha mahs mo g uꞌus wuhshanim.” ");
INSERT INTO oodNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tsh ab ep taht g wuhpuij. Kutsh ab ep i nea. Tsh g wuhpuij am i apꞌet. Sh hahawa wehs haꞌichu si s‑ap neid. ");
INSERT INTO oodNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sh g Jesus hab ahg matsh gam hu uhpam wo hih e‑kihdag wui k pi am hu wo kia i wah kihhim ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kutsh gam hu hahawa hihi idam Jesus am haꞌi ep ha wui g kihhim am miabidch g Cesaria Philippi kihhim. Kush g Jesus ab ha kakke ch hab kaij, “Am g wo ni‑ahgid, dohꞌo ni‑elid g hemajkam?” ");
INSERT INTO oodNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kush hab kaij, “Haꞌijj o hab m‑elid map d hegai Johnbad mo chum t‑pahl wapkonahim ch haꞌijj hab ep m‑elid map d Elijabad o hema i ehp hegam kekelibad Jiosh haꞌichu i tashogiddam.” ");
INSERT INTO oodNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sh ab ep ha kakke g Jesus, “Kum ahpim hig hedai ni‑elid?” Kush g Peter hab kaij, “Dap Jiosh si Kehsha maptsh ab wo i wuhsh si haꞌichu wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kush hab ha ahg mat pi hedai wo shaꞌi ha ahgi hemu mo hedai wud. ");
INSERT INTO oodNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Neh, tsh am i amjed am hahawa haꞌichu ha mashcha ab e amjed hab kaijch mat hemho wa muꞌi wo e shoꞌigch g Jiosh si Kehsha. Kutsh pi ab hu wo tatchua g geꞌeged ch uꞌugchu papal ch chehanig t‑mashchamdam k am wo i dagito mat wo e‑muhkid. Tsh amjed d wo i waik tashk, tsh ep wo e‑chegito. ");
INSERT INTO oodNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Neh, sh id am si tasho ha ahgid. Kutsh g Peter im hu goꞌolko i be k ab si s‑gewkam neok wui hab kaijch mat pi woho hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kutsh wabshaba g Jesus ab haꞌab i kekiwua ha wui k ab epai si s‑gewkam neo ab wui g Peter hab kaijch, “Pi g shaꞌi ni‑shohbid. Do wabsh hejel hab m‑elida ihda. Kup ab wui kehk g Jiosh hab elida hab masma mo g ge Jiawul.” ");
INSERT INTO oodNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sh eda muꞌij g hemajkam an ha wehgaj. Kutsh ab i ha waid k hab ha ahg, “Mamtp am wo s‑oidam g ni‑himdag k hemho wa gam hu wo dagito g hejel e‑tatchui k ahni ni‑tatchui hab wo junihid ni‑wehhejed e shoꞌigchudch. Heg at wo wa wepok mam ab mohto g kots ch ab ab wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pi amt wo heki wua g e‑doakag mamtp wo hekaj am ni‑wehhejed. Heg at wo heki wua g e‑doakag matp hedai wo chum s‑daꞌad. ");
INSERT INTO oodNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Pi at haꞌichu wehhejed wo s‑kehgajk matp g oꞌodham wehs wo bei mo haschu i tatchua id dahm jewed k wabshaba pi wo e doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Pi o an hu haꞌichug id dahm jewed mas heg hekaj wo e doꞌibia g oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Muꞌi hemajkam at wabsh s‑tahhadam hab wo junihid g pi apꞌekam ch wo pi em‑haꞌichuchudad. Kumt wabshaba ahpim pi wo si e elidad ni‑hekaj ch hekaj g ni‑mashchamadag. Nt ahni hab waꞌap pi wo si ni‑elidad em‑hekaj mant hekid ia ep wo jiwia. Idani at ab ni‑ab si s‑tondam wo e chehgidad g ni‑ohg gewkdag. T g muꞌi anghil ni‑wehm ab wo i hihi.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Neh, bash kaij g Jesus ch hab ep kaij, “Nt wo si shel em‑ahgi mo ia haꞌi haꞌichug hemu mat pi koi wo koi k hoꞌip nei mat baꞌich i s‑gewkam inhab wo i e juh g Jiosh kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kush am d i chuhdp tash amjed. Tsh g Jesus ab i ha wai g Peter ch James ch John. Kutsh idam am wehmaj ab i chehchsh hema uhgk doꞌag t ab k ged hu dada k haha wabsh nei. Tsh am gawul e juh g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tsh g wehschugaj hab e juh mash si s‑tondam s‑tohta mo pi hebai haꞌichu hab masma. ");
INSERT INTO oodNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kutsh ab haha wabsh i e chehgi g Elijabad ch Mosesbad k am wehmaj neneok g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Kutsh si e totods idam Peter. Tsh g Peter wabsh kohsh k daꞌiwuni k hab kaij ab wui g Jesus, “T‑mashchamdam, s‑apꞌe oki mach ia haꞌichug. Tt ia waik wo ha chuhcha g al chechopi matt hekaj ab wo si has em‑el ahpi ch Mosesbad ch Elijabad.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tsh an hahawa si ha ehkaj g chewagi. Tsh g Jiosh neꞌoki ab kaida chewagi t amjed k hab kaij, “Jesus o d si ni‑tatchuidch ni‑alidag. Heg amt ab wo si kaihamad.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tsh am hahawa i chum nenhog hegam Peter. Kush hegai waꞌi Jesus hejel am kehk. Sh pi am hu haꞌichug hegam gohk. ");
INSERT INTO oodNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sh ab hahawa i huhudkhim doꞌag t amjed. Sh ab si ha chehani g Jesus ch hab kaij, “Pi g am hedai wo shaꞌi ahgid mamt haschu i nei, nt hoꞌip kia am uhpam i wuhsh ab muhkig amjed ahni Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kutsh wa woho hab e juh k wabshaba hejel am aꞌaga mas has d ahga ihda mo hab kaij matsh am uhpam wo i wuhsh muhkig t amjed. ");
INSERT INTO oodNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Am hu hebai, sh hab kaij ab wui g Jesus, “Neh, bo chechꞌe hegam chehanig t‑mashchamdam matsh ia wehpeg wo e maskogi g Elijabad. Tsh g Jiosh si Kehsha ia haha wo e maskogi. Pegih, t haschu ahgk pi ia wehpeg m‑baꞌich e maskogi hegai Elijabad.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Sh hab kaij g Jesus, “Hema at woho wehpeg wo e maskogid k hab wo masmak mash wa g Elijabad ch wehs haꞌichu wo i apꞌech. Kunt wo em‑ahgi mat wa woho heki hu jiwia. T wabshaba g hemajkam am wui hab juh g pi ap e‑tatchui mo hab masma an oꞌohanas Jiosh heki hu oꞌohana ed mat hab wo e juh. K an ep oꞌohanas mat ep wo ni‑shoꞌigchud k wo s‑ni‑ohhod ahni Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sh ged hu ha aihim hegam mat am wih. Kush muꞌi hemajkam am oiopo. Sh haꞌi d chehanig t‑mashchamdam ch am ha neꞌowin hegam mat am waꞌi wih. ");
INSERT INTO oodNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tsh g hemajkam am i nei mo ab him g Jesus k si s‑ap i e taht k ab i wohp k ab nam. ");
INSERT INTO oodNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sh g Jesus ab ha kakke hegam e‑chuhchai mat am waꞌi wih, “Shahchu am ha wehm aꞌaga?” ");
INSERT INTO oodNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kush am hema g oꞌodham hab kaij ab Jesus wui, “Neh, ia ant heki hu chum uꞌapa g ni‑alidag m‑wui no pi g jiawul an uꞌukch ch pi hiwgid mas wo neo. ");
INSERT INTO oodNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Hebai atp am si has tahtchud ch i wuhppa. K g totshagi i chechshshaj chinij ab. K g e‑tahtami si kuhm ch ab wabsh wo i si gewka. Kuni heki hu am chum ha ahgid idam mat gam hu hab wo i juh g jiawul. T pi e nako.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sh hab kaij g Jesus am ha wui, “Shoꞌo waꞌi pi geꞌej g em‑wohochudadag. Shahag wepo mant tash ia wo em‑wehmajkad ch ab wo em‑nakogad mat hekaj wo i geꞌeda.” Sh hab hahawa kaij heg wui oꞌodham, “Ab g i bekaꞌi ni‑wui.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kutsh ab hahawa i bei wui. Tsh ab i nei g Jesus. Kutsh g jiawul ha hekaj i wua g ali. Kutsh am gehsh k am si banimmed jewedo. Tsh g totshagi i wuhsh ab chinij ab. ");
INSERT INTO oodNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus ash ab hahawa kakke g ohgaj, “K hekid i amjed hab masma ihda?” Kush hab kaij g ohgaj, “Gd hu waꞌi e‑alijk amjed o hab masma. ");
INSERT INTO oodNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Muꞌikko o waꞌi chum s‑muꞌamk ch am wuhppa shuhdagi ch ed ch am nahda ch ed. Si g s‑ni‑hoꞌigeꞌid k i wuhshad maptp wo e nako.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sh g Jesus hab kaij, “Maptp ahpi wo e nako k ab wo i ni‑hiw. Pi o haꞌichu shaꞌi wihnk am ni‑wehhejed maptp ab wo ni‑hiwgad.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kush hab kaij g ohgaj, “M ani wa heꞌes ab chum m‑hiwig. Oi g i ni‑wehmt. Nt baꞌich ab wo i m‑hiwgad.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tsh eda ab aꞌaijed i wohp g hemajkam an ha wehgaj. Kush hekaj s‑e hohtkid g Jesus ch si s‑kehꞌel g jiawul k hab ahg, “Dagitoni g ali, ahpi jiawul, k pi dahm an hu ep wo shaꞌi uꞌukchid.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsh am si s‑kaidam hihin k ab si s‑gewkam e ugij g ali. Tsh am hahawa dagito. Tsh hab wabsh e juh mat muh g ali. Sh g hemajkam hab kaij, “Muh atki.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tsh wabshaba g Jesus ab bei nowij ab k i wamigi. Tsh i wamig k kekiwua. ");
INSERT INTO oodNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kutsh ged hu i wahp kih ch ed idam Jesus. Tsh g chuhchaij am hahawa hejelko kakke, “Tt haschu ahgk ahchim pi t‑nako machs gam hu hab wo i juh g jiawul?” ");
INSERT INTO oodNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Sh hab kaij g Jesus, “Jiawul at heg waꞌi hekaj gam hu hab wo i e juh mamt ab wo e hoꞌigeꞌidahu Jiosh wui.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tsh amjed gam hu hahawa hihim k gam hu gahi wuwha g Galilee chekshani. Tsh g Jesus pi am hu e chehgi hemajkam ha wui no pi ha mashchamahim g e‑chuhchai ch hab ha ahg, ");
INSERT INTO oodNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","“E o aihim mat g s‑ni‑kehꞌiddam wo ni‑bei ahni Jiosh si Kehsha k am wo ni‑dagito haꞌi ha wui mat wo ni‑mua. Nt wabshaba ep wo ni‑chegito mat d wo i waik tashk amjed.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sh oi wa pi shaꞌi amichud mas haschu hab ahg ch wabshaba pi ab hu kakke nat pi e totods. ");
INSERT INTO oodNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kutsh am hihim k ged hu dada Capernaum t am k am i wahp kih ch ed mash hebai dadha. Sh eda haꞌi haꞌichukaj e neꞌowin hihimadch. Kush ab hahawa ha kakke ch hab kaij, “Shahchukaj am e neꞌowinahim mach ab hihim?” ");
INSERT INTO oodNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kush oi wa pi hedai has shaꞌi kaij nash pi eda e neꞌowinahim mas hedai baꞌich d wo i s‑has haꞌichuk. ");
INSERT INTO oodNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kutsh am i dahiwua g Jesus k ab i ha wai. Tsh am i e hemapai wui. Kush hab ha ahg, “Pi g wo chum ge e haꞌichuchudad mamtp hedai d wo uhgchuk am e‑shahgid ch wabshaba hab wo e junihid mamt wehs d wo ha‑pionagk.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sh am hema kehk g ali. Kutsh g Jesus an be k am kohm k hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Matp hedai hema wo ha dagioꞌidad g ali am ni‑wehhejed ch hekaj am wo e chehgidch mo ab si ni‑tatchua ch ab ep si tatchua hegai mani d kehshaj.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kush g John hab kaij ab wui g Jesus, “Hema oki gam hu hab i ha wua g jijawul heg hekaj m‑chehgig. Kuch am chum shohbid no ge m‑wecho e mashcham.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kush hab ha ahg, “Pi g am wo shaꞌi shohbid. Pi at woho has wo ni‑ah matp hedai hekaj g ni‑chehgig ch hab wua g s‑wihnk haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tki wo i t‑wehmt hegai matp hedai pi ab hu t‑wui kehk. ");
INSERT INTO oodNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nt wo si shel em‑ahgi matp hedai wo i em‑wasibi g shuhdagi ahpim mam ab si ni‑wecho e mashcham k wo bei g s‑apꞌekam e‑namkidadag.” ");
INSERT INTO oodNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Sh hab ep kaij g Jesus, “Shoꞌo waꞌi si s‑ta ehbidam hab mahs am wehhejed hegai matp hedai hema am wo i ha wanchkwua pi apꞌekam wui idam al aꞌal mo ab al ni‑hiwig. Baꞌich at wo i s‑apꞌek wehhejed matp hems wo e wachumchud k wo e muhkid mat koi hab wo juh ihda chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","48","“Pi at hedai wo e nako mas ab uhpam wo i wuhsh Jiawul kih amjed. Kut pi hekid wo huhug g ha‑shoꞌigchuda amai. Heg at wo wa wepok mat wo waptopadt k chum hekid wo e shoꞌigchudad am mei ch ed. Mt heg hekaj am wo i e nako mamt pi am hu wo gei heg eda. Baꞌich at wo i s‑apꞌek mamt chum hems wo heb hu wua g e‑nowi o g e‑tad o g e‑wuhi matp hema idam hab wo em‑juh mamt am wo gei Jiawul kih ed k pi wo bei hegai wechij doakag mo g Jiosh ab em‑makiog. ");
INSERT INTO oodNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Hemho wa at wehs wo e maskogi g pi ap ha‑chuꞌijig g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mt wabshaba hejel ab wo e abchud k wo dagito hemu. T hab pi ab hu wo em‑abch g Jiosh. Kumt haꞌichu wehhejed wo s‑kehgajk hab masma mo g on. Heg at pi has masma ep wo i e kegch mat wo onko. Kumt wo s‑e nenꞌoidad mamt pi wo heb hu wua g s‑e‑apꞌek am k wabshaba wo s‑ap e tahtkkad ab aꞌai e wui.” Neh, bash kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tsh amjed gam hu hihi hegam Jesus k am gahi wuwha g Judea chekshani k am gahi i shul g Jordan akimel k gam hu aigo dada. Kutsh g hemajkam am ep i e hemapai Jesus wui. Tsh am ep ha mashcha mash chum hekid hab e wua. ");
INSERT INTO oodNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kutsh ab haꞌi i hihi g Palasi k ab haꞌichu chum s‑abchudamk g Jesus ch ash ab kakke, “No hiwgid g t‑chehanig mat g oꞌodham wo s‑ohhod g e‑hohnig?” ");
INSERT INTO oodNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sh g Jesus ab epai ha kakke, “Nam hig pi mahch mo has chuꞌig g chehanig?” ");
INSERT INTO oodNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kush hab kaij g Palasi, “Heuꞌu, hiwgid o mat g oꞌodham wo bei g tapial k wo ha mah k gam hu wo s‑ohhod.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kush oi wa hab kaij g Jesus, “Heuꞌu, bo chuꞌig mamt wo ha mah g ohhoda tapial mamtp pi ab hu wo kaihamad g Jiosh ch pi wo pihk e elidad ha hekaj. ");
INSERT INTO oodNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","K wabshaba ged hu i shohshonkam am ahgas: Jiosh at am ha nahto g cheoj ch uwi mat d wo e wehhejedkamk. ");
INSERT INTO oodNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kut id hekaj g oꞌodham wo dagito g e‑ohg ch e‑jeꞌe k am wo i e wehmt g e‑hohnig wehm. ");
INSERT INTO oodNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kut hegam gohk hab wo e juh mat d wo hemakok. Pegih, t pi hab hahawa ep wo mahsk mat d wo gohkk ch wabshaba d wo hemakok. ");
INSERT INTO oodNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pi o hab shaꞌi mahs mas g oꞌodham wo ha gawulkai hegam mat g Jiosh ab i ha wehnad.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tsh ged hu hahawa i wahp kih ch ed. Tsh g chuhchaij ab i kakke mas haschu hab ahg. ");
INSERT INTO oodNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kush hab kaij, “Bo wua g pi apꞌekam matp hedai wo s‑ohhod g e‑wehm kihkam k hema ep wo hohnt. ");
INSERT INTO oodNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","K g uwi hab waꞌap wua g pi apꞌekam matp wo s‑ohhod g e‑wehm kihkam k hema ep wo kunt.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kutsh am haꞌi ha uꞌapa g e‑aꞌaliga Jesus wui hab ahgch mat ab wo ha taht k wo e hoꞌigeꞌidahu ha wehhejed. Kumsh chum s‑ha kehꞌid mo hab e wua. ");
INSERT INTO oodNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kutsh oi wa pi hohhoꞌi g Jesus matsh chum pi ha hiwigi k hab ha ahg, “Ab g wabsh wo i ha hiwgid g al aꞌal mat ab wo i hihi ni‑wui k pi an hu wo shaꞌi ha shohbi. Am at wabsh s‑moimam wo i wahp Jiosh kownaltalig ed ab ni‑hiwigch. ");
INSERT INTO oodNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nt wo si shel em‑ahgi mamt hab waꞌi masma am wo i wahp.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Neh, bash kaij ch an i ha kohmkahim k ab i ha tahtamahi ha‑mohmi ab k ab i s‑ha hoꞌigeꞌel. ");
INSERT INTO oodNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kutsh amjed haha wabsh i chum hihi. Kush ab hema med g oꞌodham ch ab i gei Jesus wui k ab kakke, “Ha mashchamdam map d s‑apꞌekam, shahchu ant am hab wo juh mant ab wo bei g pi ha huhugedam doakag?” ");
INSERT INTO oodNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sh g Jesus hab kaij, “Pi ap mahch map haschu ahgch hab ni‑aꞌaga mani d s‑apꞌekam. Heg o waꞌi Jiosh d s‑apꞌekam. Kup pi woho mahch mani hedai wud. ");
INSERT INTO oodNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","S‑mahch ap g Jiosh chehanig. K hab chuꞌig: Pi g am hu ha muaꞌi g oꞌodham. Pi g am hu ha ehsidad g ha‑wehm kihkam. Pi g am hu haꞌichu ha ehsidad. Pi g am hu haꞌichu ha iattogidad. Ab g si has ha elidad g e‑ohg ch e‑jeꞌe.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kush hab kaij ihda oꞌodham, “Wehs ihda ani hab junihim ged hu i ni‑alijk amjed.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tsh Jesus ab i nei ihda k ab si pihk i e el wui k hab kaij, “Hemako haꞌichu apki pi am hu hab wua. Him k gagda map haschu i eniga k ha mahki g namkigaj g shoꞌigkam k ab wo i him k ab si ni‑wecho wo e mashchamad ch an haha wo edgidad g baꞌich i s‑kehg kaisdag Jiosh kihdag ed.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kutsh ihda oꞌodham si pi ap e taht k kah mo has i kaij nash pi d s‑kais ch atsh im hu hih pi ap e tahtkk. ");
INSERT INTO oodNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tsh g Jesus an i nenhog e wehgaj k hab kaij am ha wui g e‑chuhchai, “Neh, t wo shaꞌi si s‑hasigk mas g s‑kakais am wo i wahp Jiosh kownaltalig ed.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kutsh si has i e taht hegam chuhchaij am i kaiok mash has kaij. Sh oi wa hab ep kaij g Jesus, “Ni‑naipijju, pi g hab wo elidad mat g oꞌodham wabsh s‑pehegi am wo i wah Jiosh kownaltalig ed. ");
INSERT INTO oodNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nam hig hab elid mat wo e nako g kamihyo mas am wo gahi wuhsh mo am jeg g hoꞌipad? Pegih, t hab wa masma pi wo e nako hegam mo hiwig g haꞌichu e‑eniga mas am wo i wahp Jiosh kihdag ed.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kutsh baꞌich i si has i e taht k ab aꞌai e kakke, “Pegih, kus hedai hig wo e doꞌibia?” ");
INSERT INTO oodNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kutsh ab i ha nei g Jesus k hab kaij, “Oꞌodham wehhejed o s‑hasig ch wabshaba am Jiosh wehhejed pi hasig. Jiosh at wo e nako mat wehs hab wo juh mo haschu i tatchua.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kutsh g Peter hab ha hekaj chei, “Nehꞌe, ahchim att hi wehs haꞌichu dagito k am i m‑oi.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Kush hab kaij g Jesus, “Nt wo si shel em‑ahgi mamt baꞌich i muꞌi haꞌichu wo edagi mo chum hegai mam tp haschu i dagito am ni‑wehhejed, kihki, wepnag, jehj, aꞌal, oꞌoidag. Kumt muꞌi haꞌichu wo nako mamt wo ahgahi g s‑kehg haꞌichu ahgaj g Jiosh ab ni‑amjed k am haha wo ai g pi ha huhugedam s‑hehgig. ");
INSERT INTO oodNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kut wabshaba hegam mo wabsh hejel chum si e haꞌichuchud hahawa pi d wo haꞌichuk. T hegam mo hejel pi e haꞌichuchud am hahawa d wo si haꞌichuk.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kutsh gam hu i oi g wohg Jerusalem wui. Sh gam hu ha baꞌich him g Jesus. Kush si e totodsid g chuhchaij. Kush am haꞌi ep ha wehm hihimad ch hab waꞌap e totodsid. Tsh g Jesus am i ha hemapai hegam gamai gohk k am ep ha ahgi mat haschu has wo e juh am tahgio, ");
INSERT INTO oodNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ash hab kaij, “Nehꞌe, gam att hu wo hihi Jerusalem wui. Kut an wo ni‑bei g uꞌugchu papal ch chehanig em‑mashchamdam k ab wo ni‑mohtoꞌi g chuꞌijig ahni Jiosh si Kehsha no pi s‑ni‑muꞌamk ch im hu hab hahawa ep wo ni‑dagito ha wui g gawul mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kut hegam wo nahnko ni‑ahgad ch ab ni‑ab wo siswuad ch ep wo ni‑gewittan k haha wo ni‑mua. Kut d wo waik i tashk, nt ep wo ni‑chegito.” Neh, bash kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tsh amjed ab wui dada g James ch John k hab kaij, “T‑mashchamdam, am ach haꞌichu chum s‑m‑kakkeimk mapt am hab wo t‑juni.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sh hab kaij g Jesus, “Shahchu am hab elid mant am hab wo em‑juni?” ");
INSERT INTO oodNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sh hab kaij, “Pt hig am wo i t‑chuhcha matt ahchim gohk am m‑oidch d wo hahaꞌichuk mapt hekid am wo i himch g e‑kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kush hab kaij g Jesus, “Pi am shaꞌi ap mahch mam haschu ab ni‑tahni. Wehpeg ant ab wo nako g geꞌe shoꞌigdag. Kut hegam mat am ni‑oidch d wo si hahaꞌichuk hab waꞌap wo e juh.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sh hab kaij, “Pegih, tt wo t‑nako.” Kush g Jesus hab kaij, “Pegih, woho am t wo nako hegai mant ahni wo nako. ");
INSERT INTO oodNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","K wabshaba pi ab hu ni‑ab manis ahni am wo i ha chuhcha mat hedai am ni‑oidch d wo hahaꞌichuk. Hegam at am wo i e chuhcha mat hedai i ha wehhejed am e apꞌech.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kutsh hegam haꞌi babgat ab ha wui g James ch John mash hab masma ab hejel e haꞌichuchud. ");
INSERT INTO oodNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tsh g Jesus ab hahawa wehs i ha hemapad k hab kaij ab ha wui, “S‑mahch am mo g ha‑maliomig s‑gewkam haꞌichu ha chehani g e‑pionag ch g ha wanimeddam am ha himchudahim. ");
INSERT INTO oodNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","T wabshaba pi hab masma hab wo shaꞌi chum mahsk am em‑shahgid ahpim mam ab ni‑hiwig. Mt wabsh si s‑hemajim am wo i ha wehmtad g e‑wehm wohochuddam hab sha masma mam d wabsh ha‑pionag mamtp wo tatchuad mamt wo ha wanimedad. ");
INSERT INTO oodNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ahni ani hab wa masma si s‑hemajim i em‑wehmt ch pi ab hu ni‑haꞌichuchud em‑dahm, chum anis d Jiosh si Kehsha. Ab o em‑wui him g s‑koꞌok namkidadag heg hekaj pi ap em‑chuꞌijig. Nt wabshaba ahni em‑wehhejed wo nako mamt wo e wupulꞌo.” Neh, bash kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kutsh am hihi idam Jesus k gam hu dada Jerico t am. Sh am shaꞌi heꞌes. Tsh am ep i chum hihi hasko. Kutsh shaꞌi si muꞌi hemajkam an ep i ha oidahi. Sh an hema daha wohg hugid an ch ha limoshan nash pi d pi neadam. Id amsh hab aꞌaga Bar Timaius nash pi d alidaj g Timaius. ");
INSERT INTO oodNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sh am hihim idam Jesus. Kutsh am i s‑mai ihda mash g Jesus an him k am ha hekaj si s‑kaidam hab kaij, “Ab g si i s‑ni‑hoꞌigeꞌid, Jesus, mapsh d t‑kownaligbad David amjedkam.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kush muꞌijj s‑kehꞌid ch hab chum ahg matsh am wabsh wo i pi shahmunik. Tsh oi wabsh baꞌich i e gewkai, “Ab g si i s‑ni‑hoꞌigeꞌid, ahpi Davidbad amjedkam.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kutsh am i kekiwua g Jesus k hab kaij, “Ab g wo i waid!” Kumtsh am ha hekaj wai hab ahgch, “S‑ap g e tahtam k i wuhshani. Ab o m‑waid.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kutsh heg am ha hekaj si wuahawua g e‑lihwa k am si daꞌiwuni k ab i him k am jiwia wui. ");
INSERT INTO oodNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sh hab kaij g Jesus, “Shahchu ant hab wo m‑juni?” Sh hab kaij g pi neadam, “Ni‑kownalig, ab g i ni‑doajid mant wo nent.” ");
INSERT INTO oodNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kush hab kaij g Jesus, “S‑ap g e tahtk k hihm. Doa apt nap pi ab ni‑hiwig.” Tsh am ha hekaj wabsh i apꞌet k nei haꞌichu k gam hu hahawa i oi g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sh amjed ab hihim idam Jesus Jerusalem wui. Tsh am hebai i cheka. Kutsh am ai g Olive Uꞌus Kawulk. K heg mia gohk al kihhimag ch hab chehgig Bethphage ch Bethany. ");
INSERT INTO oodNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Tsh g Jesus gohk hab ha ah g e‑chuhchai, “Am g wo hihim k ga hu wo dada kihhim t am. Kut am hema wo wulshpik g wechij wuhlu mo koi shaꞌi e chechshshaj. Mt gam wo wulꞌo. ");
INSERT INTO oodNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","T hema ab wo em‑kakke mams has wo juh. Kumt hab wo ah mani ahni d em‑mashchamdam ch tatchua ch am haha wo dagito mamt uhpam wo uꞌapa. Kut ab wabsh wo i dagito mamt ab wo i wanim.” ");
INSERT INTO oodNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Neh, tsh wa woho gam hu hihi idam gohk k am cheh mo am wulshpi g wuhlu k am wulꞌo. ");
INSERT INTO oodNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Kush eda inhab haꞌi gegok g oꞌodham ch ha neid mash am wupulꞌok. Sh hema hab kaij, “Shahchu am ahgch am wupulꞌok g wuhlu?” ");
INSERT INTO oodNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sh am i ha ahgid mash has kaij g Jesus. Kutsh heg hekaj ha hiwigi matsh am wo bei. ");
INSERT INTO oodNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kutsh am i wanimed k ged hu uꞌapa Jesus wui k an toa g e‑liliwa an ab. Tsh an dahiwua g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sh muꞌi hemajkam an ha wehgaj ch am i ha tahtdahim g e‑liliwa wohg ch ed ch haꞌijj g wechij uꞌus iꞌibhonig an hikkumiak ch am toꞌahim heg oidch wohg mash am him g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kush hegam mash an wehgaj hihim si s‑kaidam hab kaij: “T‑doꞌibiakam! Jiosh atki ia i m‑wuhshad k ab si s‑m‑hoꞌigeꞌid. ");
INSERT INTO oodNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kupt ep wo i himch kownaltaligaj g t‑kownaligbad David k ab wo i s‑t‑hoꞌigeꞌidad. T wo t‑doꞌibia g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kutsh gam hu dada Jerusalem t am. Tsh am i hud g Jesus k am i wah mo am kehk g geꞌe cheopi k an i neidahi mo an haschu has e wua. Sh am i hudunihim. Tsh hekaj am i wuwhag k gam hu hihi Bethany wui matsh am wo dadkad. ");
INSERT INTO oodNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sh am baꞌich d i tash mash ab uhpam hihim Jerusalem wui. Tsh bihugim g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kush am hu hema kehk g suhna uhs. Tsh ab wui hihi nash pi s‑hahhagag ch ab wo chum bahidagk, chum as pi koi e ai mat wo bai. Kush oi wa pi ab hu haꞌichu shaꞌi ihbdag. ");
INSERT INTO oodNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kush hekaj hab kaij, “Pi at hedai ab hu ep wo huh g bahidag.” Kush kah idam. ");
INSERT INTO oodNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kud ged hu dada Jerusalem t am k am i wahp mo am kehk g geꞌe cheopi. D eda am haꞌi dadha ch am haꞌichu gagda ch haꞌichu ha nolawt geꞌe cheopi miabidch. D g Jesus gam hu si ha shahmud k gam hu aꞌai kuhkpal si ha shul g ha‑mimsa hegam mo g lial kammialt ch g ha dadaikud hegam mo g hohhi ha gagda. ");
INSERT INTO oodNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","D wenog g hemajkam haꞌichu gahi mohto mo am kehk g geꞌe cheopi. Kud g Jesus am ha shohbid ");
INSERT INTO oodNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","k am hahawa ha mashcham g hemajkam ch hab kaij, “Bo chuꞌig an Jiosh oꞌohana ed mo hab kaij g Jiosh: Ahni o d ni‑wehhejedkam ihda geꞌe cheopi. Kut id wui ab wo hihhimad g wehs nahnko mahs hemajkam mat ab wo ni‑ihmad. Neh, bo kaij g Jiosh. Kumt eda an be k am eda hab wabsh wua g hejel e‑tatchui ch chum hems haꞌichu s‑aꞌagi ha ehsid ab ha wui haꞌichu gagdach.” ");
INSERT INTO oodNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","D muꞌijj g hemajkam ab si has elid g mashchamigaj. Kudki heg hekaj s‑ehbid g uꞌugchu papal ch chehanig t‑mashchamdam ch am i aꞌaga mas has masma wo mua. ");
INSERT INTO oodNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kud am i hud. D am hahawa i wuwha kihhim t amjed hegam Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Baꞌich mahsi, tsh am ep bihbij amai mash am kehk g suhna k nei matki gaksh. ");
INSERT INTO oodNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sh g Peter hab kaij, “Neh, t‑mashchamdam, hegai suhna mapt ab si has ah atki gaksh.” ");
INSERT INTO oodNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sh hab kaij g Jesus, “Ab g wabsh wo hiwgad g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kut wabsh chum haschu hab wo em‑juni. Mtp hems wo cheha ihda doꞌag mat gam hu wo e wua ge shuhdagi ch ed. Kut wa woho hab wo e juh mamtp ab wo hiwgad mat hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ab g wabsh wo s‑wohochudad mat g Jiosh am hab wo em‑juni hegai mamt haschu ab wo i tai. Kut wa woho hab wo em‑juni. ");
INSERT INTO oodNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mt wabshaba wehpeg wo pi chegito g pi ap ha‑chuꞌijig hegam matp hedai ab em‑wui hab juh g pi apꞌekam. T g Jiosh em‑ohg ab haha wo s‑em‑hoꞌigeꞌid k gam hu hab wo i juh g pi ap em‑chuꞌijig.  ");
INSERT INTO oodNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mtp wabshaba pi wo sha pi chegito g pi ap ha‑chuꞌijig, t g Jiosh g em‑chuꞌijig hab waꞌap pi gam hu hab wo i juh.” ");
INSERT INTO oodNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kud gam hu ep dada Jerusalem t am k ged hu i wahp mo am kehk g geꞌe cheopi. Kutsh g uꞌugchu papal ch chehanig t‑mashchamdam ch geꞌeged am dada wui g Jesus ");
INSERT INTO oodNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","k ab kakke, “Dohp amjed hab chum e elid map uꞌukch g e‑gewkdag ch am hab haꞌichu wua? Oi g am t‑ahgid.” ");
INSERT INTO oodNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kush oi wa hab kaij g Jesus, “Pegih, nt ahni wehpeg ab epai wo haꞌichu em‑kakke. Mt am wo ni‑ahgi. Nt am epai wo em‑ahgi g em‑kakkei. ");
INSERT INTO oodNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Am g hig wo ni‑ahgid mams hedai amjed hab elid mo wa g Johnbad ab uꞌukch g e‑gewkdag ch ha pahl wapkonahim. No ab Jiosh amjed aha no ab oꞌodham amjed?” ");
INSERT INTO oodNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kush idam am wabsh chum hejel si aꞌaga ch hab kaij, “Shahtt hig wo chei? T wo s‑t‑kehꞌid k ab wo t‑kakke matt haschu ahgk pi ab hu wohoch g Johnbad mattp hab wo chei mo ab Jiosh amjed uꞌukch g gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","T g hemajkam has wo t‑juh mattp hab wo chei mo ab wabsh oꞌodham amjed uꞌukch. Muꞌijj o hab elid mo d Jiosh haꞌichu i tashogiddam.” ");
INSERT INTO oodNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Neh, bash kaij ch ab hahawa uhpam i e nohnogi Jesus wui k hab kaij, “Pi ach shaꞌi mahch mas hedai amjed ab uꞌukch g e‑gewkdag.” Kush g Jesus hab epai kaij ab ha wui, “Pegih, nt ahni hab waꞌap pi wo shaꞌi em‑ahgi mani hedai amjed ab uꞌukch g ni‑gewkdag ch hab wua wehs ihda.” ");
INSERT INTO oodNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Neh, bash kaij g Jesus ch am hahawa ha ahgid ihda wepogida ahga hab kaijch, “Matp hems hema hab i e ah mat am hig wo ge ei g uhdwis. T g piongaj an ge kolhaidad k heg ep nahto mat hekaj am wo i wuhshad g wadgaj k am i kei g uhgk kih mat heg amjed wo nuhkudad g eshaj. T gam hu hasko chihpia g enigakam k haꞌi ha hiwigi g e‑oidag. ");
INSERT INTO oodNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“T am i e ai mat g uhdwis wo bai. Kut am hema ahgi g e‑pionag mat am wo him k ab wo bei hegai wadgaj mo ab d i chum wuikamaj g enigakam. ");
INSERT INTO oodNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kut am him k am jiwia. T wabshaba hegam mo am nuhkud g oidag am wabsh be k am gewittan k hab ah mat gam hu wo hih. ");
INSERT INTO oodNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“K am hu i hebai, t am hema ep cheha e‑pionag mat am wo hih. T am him k am jiwia. Kut am hab waꞌi ep juh mat hab juh g wehpegkam k s‑koꞌokam juh g moꞌoj k s‑koꞌokam has ah. ");
INSERT INTO oodNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“T g enigakam am hema ep cheha g e‑pionag mat am wo hih. T g nuhkuddam hab waꞌap juh k mua. T g enigakam am haꞌi ep ha cheha mat am wo hihi. T g nuhkuddam hab waꞌap s‑koꞌokam ha juh k haꞌi ha kokda. ");
INSERT INTO oodNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“K am hema wiꞌis ch d alidaj. T heg am cheha mat am wo hih hab elidch mat ab has wo i el. ");
INSERT INTO oodNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“T wabshaba idam oidag nuhkuddam am wabsh e wehm neneok k hab kaij, ‘Id o d ihda mat ab wui wo i wuhsh g oidag. Tt hig wo mua. T d haha wo t‑enigak.’ ");
INSERT INTO oodNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kut hab juh k muꞌa k gam hu daꞌich ab kolhai amjed. ");
INSERT INTO oodNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Neh, m ant wo i em‑tashogi mat has wo e juh g oidag enigakam. Ab at wo i him k wo ha kokda hegam mat am chum ha nuhkudach g e‑oidag k am haꞌi ep wo ha nuhkudach. ");
INSERT INTO oodNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Pi amki shaꞌi amichud mo has d ahga ihda wepogida ahga mo an hab chuꞌig Jiosh oꞌohana ed: Kihtdam at wo hema s‑ohhod g hodai. T wabshaba id d wo si s‑has haꞌichu hodaik am ha‑kihta wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Id o hab d ahga mat si s‑kehg haꞌichu hab wo juh g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Neh, bash wabsh ha ahg hegam t‑uꞌugchuga g Jesus nash pi chum s‑ohhodamk. Kush heg hekaj an chum s‑behimk mat wo kuh. K wabshaba muꞌijj g hemajkam ab si has elid g Jesus. Kush s‑ha gihug ch am wabsh i dagito k gam hu hihi hasko. ");
INSERT INTO oodNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kumtsh am hahawa haꞌi hab ha ah g Palasi ch Herod pionag matsh am wo hihi Jesus wui k wo neꞌowin k wo haꞌichu cheh mat heg ab wo abch. ");
INSERT INTO oodNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kutsh am dada wui k hab kaij, “Ha mashchamdam, s‑mahch ach map s‑ap d oꞌodham ch wabsh chum hedai ha mashcham g Jiosh himdag, chum as has wo chei hedai i. Pegih, k am wo t‑ahgi maps has elid g geꞌe kownal lial kowlanta. No hig t‑hiwgid g t‑chehanig ahchim Tutuligo matt wo ha namkid aha no pi t‑hiwgid?” ");
INSERT INTO oodNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sh wabshaba g Jesus am wa s‑ha amichud mo g pi apꞌekam hab elid ch hab ha ahg, “Ahpim, s‑chu iꞌattomkam am wabsh chum heki s‑ni‑himchudamk. Ab g wo hema ni‑chehgid hegai lial mam hekaj ha namkid.” ");
INSERT INTO oodNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kumtsh ab hema chehgi. Kush hab ha ahg, “Am g hig wo ni‑ahgid mo hedai wuhiosha ch hedai chehgig ab oꞌohadag id ab lial” Sh hab kaij idam, “Hegai mo d uhgchu t‑kownalig.” ");
INSERT INTO oodNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kush hab hahawa ep kaij g Jesus ab ha wui, “Pegih, ab g wo i dagito kownal wui hegai matp d enigaj k am epai wo i dagito Jiosh wui mo haschu d epai enigaj.” Kutsh wehsijj si has i el g neꞌokij. ");
INSERT INTO oodNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kutsh am haꞌi dada Jesus wui hegam mash d Sajusi. K idam o pi d ha‑wohochudadag mat g muhki ab uhpam ep wo i wuhsh muhkig t amjed. ");
INSERT INTO oodNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Kush hab kaij idam, “Ha mashchamdam, Mosesbad atki an oꞌoha hegai chehanigaj g Jiosh mo hab chuꞌig: Matsh g am oidchkam wehngaj hegai mat wo muh pi ha aꞌalidagkch hemho wo wa bei g hohnigaj g e‑wehnagbad. Tsh g ha‑aꞌaliga hab masma wo e kuint mat d wo aꞌalidajk hegai mat muh. ");
INSERT INTO oodNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pegih, k am hu hebai wewaꞌak d e‑wepngam. Kut g si geꞌechu hema hohnt g uwi k pi ab hu ha aꞌaligat k muh. ");
INSERT INTO oodNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kut g am oidchkam nawojij hahawa ep bei g hohnigaj k hab waꞌap pi ab hu ha aꞌalidt k hab waꞌap muh. Kut ihda g oidchkam hab waꞌap hohnt k hab waꞌap muh pi ab hu ha aꞌalidtk. ");
INSERT INTO oodNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kut hegam haꞌi hab waꞌap wehsijj i hohntahim k hab waꞌap koi pi ab hu ha aꞌalidtk. K am hu i hebai, t haha wabsh muh hab wa ehp ihda uwi. ");
INSERT INTO oodNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pegih, am g hig t‑ahgid mas hedai d wo hohnigkad ihda matp ep wo e chegito g koꞌi no pi wehsijj hohnigkahim.” ");
INSERT INTO oodNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kush hab kaij g Jesus ab ha wui, “Pi am ap chegito nam pi pi shaꞌi mahch g Jiosh haꞌichu ahga ch ep pi shaꞌi mahch mo heꞌes i gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Woho at ab uhpam wo i ha wuwhas g koꞌi. T wabshaba hahawa pi wo hohontad hab masma mo g anghil pi hohont. ");
INSERT INTO oodNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mosesbad atki an oꞌoha mash wa g Jiosh am e chehgid wui heg hekaj shaꞌi mash meihid ch pi meitto. Sh hab kaij g Jiosh: Ahni ani d ha‑Jioshga hegam Abraham ch Isaac k ch Jacob. Neh, id o hab kaij g Jiosh chum as heki hu koi, no pi am e wehm ha nuhkud ch ab uhpam wo i ha wuwhas muhkig amjed. ");
INSERT INTO oodNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pi amt wabsh woho wo i huhug am i koꞌok matp g Jiosh d em‑Jioshga. K heg hekaj pi shaꞌi woho hegai mam ahpim hab chum elid.” Neh, bash kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kush am hema kehk g chehanig ha mashchamdam ch am ha kaiham. K eda tasho mo s‑ap hab ha ahg g Jesus. Neh, tsh hab i e ah mat ab hig epai haꞌichu wo kakke, ash hab kaij, “Shahchu o d si baꞌiwechkim geꞌe chehanigaj g Jiosh?” ");
INSERT INTO oodNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Kush hab kaij g Jesus, “Si geꞌe chehanig o d ihda: Ab g wo si tatchuad g e‑kownalig Jiosh wehs e‑ihbdagkaj ch id am wo chehgidch wehs e‑doakagkaj ch wehs e‑chegitoikaj ch wehs e‑gewkdagkaj. Id g ab wo si kaihamad ahpim mam d chum hemajkamgaj no pi pi hema ep d em‑Jioshga. Neh, id o d si geꞌe chehanig. ");
INSERT INTO oodNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","K id hab waꞌap d si geꞌe chehanig ch hab chuꞌig: Ab g wo si ha tatchuad g hemajkam hab masma mam has i masma ab hejel si e tatchua. Idam gohk o d si geꞌe chehanig.” ");
INSERT INTO oodNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kush hab kaij ihda, “S‑ap ap hab kaij, t‑mashchamdam. M o wa woho mo g Jiosh si s‑wohom d Jiosh ch pi an hu hema ehp. ");
INSERT INTO oodNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kutt hemho wa ab wo si tatchuad g Jiosh wehs t‑ihbdagkaj ch id am wo chehgidch wehs t‑chegitoikaj ch wehs t‑gewkdagkaj ch ab wo si ha tatchuad g hemajkam mach has masma ab hejel si t‑tatchua. Idam gohk o baꞌich d i si haꞌichu mo hegai chehanig matt g haꞌichu t‑shoiga wo muꞌa k am wo iagchul Jiosh wui k haꞌichu si t‑eniga wo i dagito am Jiosh wui.” ");
INSERT INTO oodNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kutsh am i kah g Jesus mo s‑ap hab kaij k hab epai ahg, “Pi apki shaꞌi mehk ab Jiosh kownaltalig amjed.” Kutsh amjed hahawa pi hedai shaꞌi nako mas ab hu haꞌichu ep wo kakke. ");
INSERT INTO oodNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kush am ha mashcham g Jesus geꞌe cheopi ch ed ch hab kaij, “Am g wo oidahim mas hedai d wo Jiosh si Kehshak. Chehanig em‑mashchamdam o em‑mashcham matsh heg d wo amjedkamk hegai t‑kownaligbad mash hab chehgig David. ");
INSERT INTO oodNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kush wa eda g Davidbad hab aꞌaga ‘ni‑kownalig’ ch hab kaij g gewkdajkaj g Hekia S‑apꞌekam Gewkdag: Bo Kaij g Jiosh ab ni‑kownalig wui, In g dahiwua s‑apkojed ni‑hugid an. Kunt wo ha gewito g m‑obga mat ab wabsh wo m‑wechok. ");
INSERT INTO oodNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Neh, namt hig s‑ap wo ah mat has masma d wo Davidbad amjedkamk ihda mash d kownaligaj?” Sh muꞌijj ab kaiham ch si s‑ap e tahtk ch kah mo haschu ha mashcham. ");
INSERT INTO oodNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","39","Sh hab kaij g Jesus, “Hegam mo d chehanig em‑mashchamdam o am si s‑apko dadhaiwup mam am e hehemapad ch si s‑kehg e enigadad ch an oiopo no pi si tatchua mamt ab wo si has ha elidad. S‑e g wo nenꞌoidad mamt pi hab wo masmak. ");
INSERT INTO oodNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Chum as si chew e hoꞌigeꞌidahun am em‑tahgio ch eda haꞌichu s‑aꞌagi ha wohppoꞌid hegam mo d heheꞌejel wihpkam. T g Jiosh baꞌich i s‑koꞌokam wo ha namkid heg hekaj pi ap ha‑chuꞌijig no pi wabsh pehegia e hoꞌigeꞌidahun.” ");
INSERT INTO oodNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kutsh am dahiwua g Jesus miabidch g geꞌe cheopi. K ab e toꞌaw hegai lial mo hekaj e nuhkud g cheopi. Sh g Jesus am ha neid hegam mo am toꞌaw. Kush g s‑kakais shaꞌi si mumuꞌi am toꞌaw. ");
INSERT INTO oodNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tsh am hema jiwia g hejel wiꞌikam oks k am hi wa al toa g gohk s‑wepegchu. ");
INSERT INTO oodNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Sh g Jesus am ha ahgid g e‑chuhchai, “Nehꞌe, hegam mo haꞌichu s‑edgid o hi wa baꞌich i mumuꞌi am toꞌaw. T wabshaba ihda al oks baꞌich i si haꞌichu hab juh nat pi am al toa wehs hegai mo haschu al i edgid.” ");
INSERT INTO oodNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kutsh gam hu hahawa i wuwha idam Jesus ab amjed g geꞌe cheopi. Kush idam hema hab kaij, “Nehꞌe, t‑mashchamdam, shoꞌo waꞌi si geꞌeged hohodaikaj in kihtas g geꞌe cheopi ch si s‑kehg hab mahs.” ");
INSERT INTO oodNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kush hab kaij g Jesus, “Heuꞌu, nt wabshaba si shel wo em‑ahgi mo e aihim mat wehs wo i e shul ihda.” ");
INSERT INTO oodNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tsh amjed gam hu hejelko hihi wehmaj g Jesus k ab i chehchsh Olive Uꞌus Kawulk t ab k ab dadhaiwua geꞌe cheopi wui. Kutsh idam Peter ch James ch John ch Andrew ab i hihi Jesus wui k hab ahg, ");
INSERT INTO oodNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Am g hig t‑ahgid mas hekid am hab wo i e juh hegai map am t‑ahgid. Kut haschu d wo chehgidak matt heg ab wo s‑mahchk moki e aihim.” ");
INSERT INTO oodNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kush am ha ahgid g Jesus, “Mt wo si s‑e nenꞌoidad mat pi hedai wo em‑iattogi. ");
INSERT INTO oodNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Muꞌi at an wo i wuwha aꞌahidag oidam k ni‑wepo wo e chehcheg hab kaijch mo d Jiosh si Kehsha. Kut muꞌijj ab wo s‑ha wohoch. ");
INSERT INTO oodNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","8","T g nahnko mahs hemajkam ch jejewed ab aꞌai wo i e checheggia. Mt wabshaba pi wo e totods. Hemho at hab wo wa e juh hab masma. K wabshaba pi hab d ahga mat e ai mat wo kuhgit. An at muꞌikpa wo uꞌugij g jewed. T g bihugig an ep wo gei muꞌikpa. Id at d wabsh wo shohshonajk g shoꞌigdag nat pi baꞌich wo i geꞌeda. ");
INSERT INTO oodNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kumt wo s‑e nenꞌeidad namt pi wo em‑uꞌu k wo em‑lodait k am ep wo em‑uꞌapa kokownal ha wui heg hekaj mam ab ni‑hiwig. Mt wabshaba am wabsh wo ha ahgi g haꞌichu ni‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","T an wehsko wo i e ahgahi ihda s‑kehg haꞌichu ahgaj g Jiosh mat koi wo kuhgit g jewed. ");
INSERT INTO oodNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pi g has wo shaꞌi e tahkkad mams has wo chei mat hekid wo em‑uꞌapa k wo em‑lodai. Hekia S‑apꞌekam Gewkdag at ab wo i em‑ahgi mamt has wo chei. ");
INSERT INTO oodNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Hahaꞌichu at wo em‑kokda. Kut ab ha wui wo em‑gagda chum hems g em‑wepnag o g em‑jehj o g em‑aꞌaliga. ");
INSERT INTO oodNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Muꞌi hemajkam at wo s‑em‑kehꞌidad nam pi ab ni‑hiwig. Kumt wo sha e nakog k wo gahi wuwha g e‑shoꞌigdag. T g Jiosh ab wo i em‑wahpki e‑kihdag ed.” ");
INSERT INTO oodNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kush hab ep kaij g Jesus, “Am g wo amichud mamt haschu in wo neꞌokchul Hegai kelibad Jiosh haꞌichu i tashogiddam Daniel at an oꞌoha mat g em‑obga am wo i kei g s‑uam haꞌichu ged hu si eda g geꞌe cheopi. Kut hemho wa am haha wo ahhio dohdaꞌag wui hegam mat ia wo haꞌichugk Judea jewed ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","16","Kut pi hedai am hu wo shaꞌi chum i wah e‑kih ed k am wo haꞌichu ui, chum as hems imhab wo waꞌi oimmedad e‑kih wehgaj o am wo chikpanad oidag ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","S‑ta at ehbidam wo mahsk am ha wehhejed hegam mat wo chuꞌuchum mahmadk ch hegam mat wabsh wo kia woꞌok g ali. ");
INSERT INTO oodNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Mt ab wo tahnid g Jiosh mat pi eda hab wo e juh ihda s‑hehpichꞌed. ");
INSERT INTO oodNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Baꞌich at d wo i si geꞌe shoꞌigdagk mo pi hekid g hemajkam shaꞌi neid ch pi hekid hab masma ep wo nei. ");
INSERT INTO oodNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pi at hedai wo e nako mas am gahi wo wuhsh matp tash wo hih. T g Jiosh heg hekaj wo i shopolkai am ha wehhejed g e‑hemajkamga. ");
INSERT INTO oodNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Pi g wo shaꞌi ha wohochud matp hema hab wo sha chei mo am hebai haꞌichug g Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Muꞌi at in wo i wuwhag k hab wo chei mo d ni‑ahni, Jiosh si Kehsha, o d Jiosh haꞌichu i tashogiddam k am hab wo wuad g si s‑hasig haꞌichu mat hekaj wo i chum ha wanchshul g Jiosh hemajkamga matp wo e nako. ");
INSERT INTO oodNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ni wabshaba am heki hu em‑ahgid ihda mamt heg hekaj wo s‑e nenꞌeidad.” ");
INSERT INTO oodNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Sh hab ep kaij, “T am wabsh wo i chum kuhgit hegai jewed shuhdgim shoꞌigdag. Kut g tash tonlig wo huhug. T g mashad ep pi wo ha ton. ");
INSERT INTO oodNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","T g dahm kahchim wo ugij. T g huhuꞌu wo i shul. ");
INSERT INTO oodNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kunt ab hahawa si s‑masma wo i hud chewagi ch ed ab Jiosh kihdag amjed ahni Jiosh si Kehsha. T am wo e maskogi g ni‑gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kunt wo ha cheha g ni‑anghiliga mat ab wehs wo i ha hemapai hegam mant am i ha chuhcha mat wo e doꞌibia. T am wo hihi imhab siꞌal tahgio ch imhab juhpin tahgio ch imhab huduni tahgio k ch imhab wakolim tahgio k wo i ha hemapai. ");
INSERT INTO oodNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nt wo haꞌichu em‑mashcha heg hekaj suhna uhs. Mt wo s‑mahchk mo g toniabkam e aihim mamt wo nei mat ab wo i iꞌiwgi. ");
INSERT INTO oodNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pegih, mt hab waꞌap wo s‑mahchk mo e aihim mat wehs wo kuhgit mamt wo nei mat hab wo e juh hegai mani em‑ahgid. ");
INSERT INTO oodNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nt wo si shel em‑ahgi mat d wabsh wo kia dodakamk hegam mat wo nei ihda mani em‑ahgid mat hekid wehs wo kuhgit. ");
INSERT INTO oodNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Neh, wehs at gam hu hab wo i e juh ihda Jiosh nahtoi mam in neid. T wabshaba g ni‑neꞌoki pi hekid gam hu hab wo i e juh.” ");
INSERT INTO oodNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kush hab ep kaij, “Heg o waꞌi s‑mahch ni‑ohg Jiosh mant hekid ep wo jiwia. Pi o hedai ep s‑mahch, chum hems g anghil nih ahni mani d hi wa chum alidaj. ");
INSERT INTO oodNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kumt wo si s‑e nenꞌeidad ch ab wo neidachugad nam pi pi mahch mas hekid wo i k ihda. ");
INSERT INTO oodNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","K hab sha masma am em‑wehhejed matp hems hema wo ha hiwigi g e‑kihdag g e‑pionag k wo ha cheha mat has wo masmak hehemako k g kihjeg nuhkuddam ep wo cheha mat wo si s‑e nenꞌeidad k gam hu hahawa mehk jewed wui wo hih. T idam chum hekid wo s‑e nenꞌeidad no pi pi mahch mas hekid ep wo jiwia. ");
INSERT INTO oodNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Pegih, mt ahpim hab wa masma wo s‑e nenꞌeidad. Pi o ta machima am em‑wehhejed mas hebai hab wo i e juh g tash an aꞌai jejewed dahm mant hekid wo i uhpam jiwia. ");
INSERT INTO oodNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kuni wehs hab s‑ha ahgidamk mani haschu hab em‑ahg mat hab waꞌap wo s‑e nenꞌeidad.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","K eda gohk tash am wiꞌis matt wo wuhshad g t‑shohshon ha‑doꞌibiadag. Kush idam uꞌugchu papal ch chehanig t‑mashchamdam am chum e nakog mas has huꞌi masma s‑aꞌagim wo bei g Jesus k wo mua, ");
INSERT INTO oodNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ash am wabsh aꞌai e ahgid, “Hi wa pi am hu heg eda mat ia wo e hemapadch g hemajkam id hekaj piast. T wo am hu e babgachud k wo t‑cheggia.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tsh am hu hebai am dada hegam Jesus Bethany t am. K am hema d kihkam mo hab chehgig Simon ch wa chum mumku heg hekaj mo g chuhkugaj wabsh muhkhim. Id atsh ab i ha waid k ha gegos. Sh am dadhak ch e gegosid. Tsh ab haha wabsh hema i wah g uwi g si s‑namkig s‑ap uhw shuhdagi waꞌigchugch am al s‑toa hodai haꞌa ch ed. K hab e aꞌaga ‘spikenard’ ihda shuhdagi. Kutsh am si hai g al haꞌa k an wehs iawua Jesus moꞌo dahm. ");
INSERT INTO oodNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kutsh haꞌi babgat am i neidok matsh has e juh k s‑juꞌujpij e wehm neneok ch ash hab kaij, “T wabsh heki e wua ihda s‑namkig haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Eda atp huꞌi chum waik siant pihsh wo nam sha e gagdak. T heg wo e hekaj ha wehhejed g shoꞌigkam.” Neh, bash kaij ch si s‑kehꞌid g uwi. ");
INSERT INTO oodNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kush oi wa hab ha ahg g Jesus, “Pi g am wo shaꞌi kehꞌid ihda uwi. Si at s‑kehg haꞌichu hab juh am ni‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Chum o hekid ia em‑shahgid g shoꞌigkam. Kumt wabsh chum hekid wo i ha wehmt. Kunt ahni hi pi tash ia hu wo em‑shahgidk. ");
INSERT INTO oodNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","T ihda uwi hab juh mat haschu i e nako mat am heki hu s‑ap juh ni‑chuhkug g ni‑muhkig wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nt wo si shel em‑ahgi mat am wo e ahgahid mat haschu has ni‑juni mat hebai wo i e ahgahid g s‑kehg haꞌichu ahgaj g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kutsh am ha hekaj ha dagito g Judas Iscariot k gam hu hih uꞌugchu papal ha wui hab ahgk matsh hegam ha wui wo gagda g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sh am si s‑hohhoꞌid ch kah idam mash has i kaij, ash ab si ahgid matsh wo namkid. Kutsh am hahawa si i e nako g Judas matsh hebai wo s‑apꞌek. Kutsh ab ha wui wo gagda. ");
INSERT INTO oodNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","T am hahawa s‑ap i e ai hegai t‑shohshonbad ha‑doꞌibiadag piast. K id eda pi e koꞌa hegai pahn mo jewajidas. K d wehpeg tash mat eda wo e kokda g kahwal mahmad. Sh g Jesus chuhchai ab wui hab kaij, “Bahp hab elid matt am wo huh g ha‑doꞌibiadag gegosig?” ");
INSERT INTO oodNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kutsh am hahawa gohk hab ha ah, “Am amt wo hihi Jerusalem wui. T ab hema wo himad g cheoj ch wo waꞌigchugad ab haꞌa t ab. ");
INSERT INTO oodNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kumt am wo i oi. T am hu hebai wo him k am wo i wah hema kih ed. Kumt hab wo chei ab kihkam wui, ‘Neh, s‑mahchimk o g t‑mashchamdam mas an hebai i ha wiꞌis matt wo wuhshad g t‑shohshon ha‑doꞌibiadag.’ ");
INSERT INTO oodNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kut am wo hema em‑chehgi g kih. T id gan hu ha‑kih dahm hab wo chuꞌigk ch wo geꞌejk ch am wo apchudask. Kumt an haꞌab wo i apꞌech g t‑gegosig.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kutsh wa woho am hihi idam gohk k ged hu dada kihhim ch ed. Tsh wa woho s‑ap am hab e juh mash has i ha ahg. Kutsh am i apꞌech g gegosig. ");
INSERT INTO oodNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tsh am i hud. Tsh am hahawa dada hegam Jesus k am hu dadhaiwua k e gegosid. ");
INSERT INTO oodNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sh hab haha wabsh kaij g Jesus, “M ant wo si shel em‑ahgi mat oi am hab wo e juh mamt hema wo ni‑gagda ahpim mam ab si ni‑wecho e mashcham.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kutsh wehsijj pi ap e taht k gan hu hab i cheꞌiatahi, “Ih, hi wa pi ahni.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kush hab kaij g Jesus, “Heg at hab wo juh mat hedai am ni‑wehm wo wakch g chemait hidod ch ed. ");
INSERT INTO oodNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bant masma wo ni‑muhkid mo has masma heki hu oꞌohanas Jiosh oꞌohana ed mat g si Kehshaj wo e muhkid. T wabshaba wo si s‑koꞌokam e namkid hegai mat wo ni‑gagda. Baꞌich at wo i chum s‑apꞌek heg wehhejed mat hems wabsh pi wo chum mahsi.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sh am wabsh kia e gegosid. Tsh g Jesus am bei g chemait k ab hoꞌigeꞌel g Jiosh k am hahawa i hahain k an i ha mah k hab kaij, “Oi g wo huhgi ihda. Do ni‑honshpadag.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tsh am hahawa bei g tahsa k ab ep hoꞌigeꞌel g Jiosh k ab ha mah. Kutsh wehsijj ab ih. ");
INSERT INTO oodNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kush hab ha ahg, “Do ni‑ehꞌed ihda nawait. Id ani hab ahgch hab kaij mant wo ni‑muhkid am em‑wehhejed. T g ni‑ehꞌed wo e iawua. T g Jiosh heg hekaj am hab wo juh hegai mo wa hab kaij matsh hab wo em‑juni. ");
INSERT INTO oodNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ia o i s‑apꞌe. Kunt pi hekid em‑wehm hab ep wo juh ihda k wabshaba em‑wehm wo si s‑hehgigk Jiosh kihdag ed.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Neh, kutsh am hahawa kuhgit am hema ahgk g mihshmda neꞌi k am i wuwhag k gam hu hihi Olive Uꞌus Kawulk wui. ");
INSERT INTO oodNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kush hab ha ahg g Jesus, “An o oꞌohanas mo hab kaij g Jiosh: Nt wo hiwigi mamt wo mua g kahwal ha nuhkuddam. T g kahwal wabsh aꞌai wo wohp. Neh, id o d haꞌichu wepogida ahga ch hab d ahga mamt wehsijj wabsh wo ni‑dagito k gam hu aꞌai wo wohp mant hekid wo ni‑muhkid. ");
INSERT INTO oodNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kunt wabshaba ep wo ni‑chegito k gam hu wo hih Galilee wui. Mt am haꞌab wo ni‑nei.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kush g Peter hab kaij, “Ahni ant hi pi hekid wo shaꞌi m‑dagito, chum as wehsijj wo m‑dagito idam.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sh hab kaij g Jesus ab wui, “Nt wo si shel m‑ahgi mat koi gokko wo kuhu g chuchul id i chuhug ab, kupt eda heki hu waikko hab wo waꞌi chei map pi shaꞌi ni‑mahch.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kutsh am wa si e gewkai g Peter, ash hab si kaij, “Pi ant hekid hab wo shaꞌi chei manis pi m‑mahch, chum anis wo ni‑muhkid m‑wehm.” Kush wehsijj hab waꞌap kaij. ");
INSERT INTO oodNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kutsh ged hu dada heg ab oidag mo hab e aꞌaga Gethsemane. Sh pi am hu ha wehmaj g Judas Iscariot. Kush hab ha ahg g Jesus, “Ia g hu wo i dadhak. Nt ahni am baꞌich wo i him k wo ni‑hoꞌigeꞌidahu.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bash kaij ch am ha uꞌuk g Peter ch James ch John. Tsh idam gam hu oi. Kush s‑masma si pi ap e tahtk g Jesus ch si e kudut ");
INSERT INTO oodNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ch hab kaij ab ha wui, “Ab at wabsh i si ni‑shuhd g pi ap tahhadkam ch s‑ni‑mukima tahhadchud. Ia g wabsh wo dadk ch wo haꞌichu si nenashanad.” Kutsh am dadhaiwua. ");
INSERT INTO oodNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Tsh g Jesus gam hu hahawa him k am i gei jewedo k hab kaij ab Jiosh wui, “Ni‑ohg, wehs haꞌichu o pi shaꞌi hasig am m‑wehhejed. Pt wo e nako mapt im hu hab wo i juh hegai si s‑koꞌok shoꞌigdag mo ab ni‑wui him. Kuni eda tatchua mat ahpi g m‑tatchui hab wo e juh.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tsh am hahawa uhpam ep jiwia ha wui hegam waik. Kush am kohksh. Sh hab kaij ab wui g Peter, “Simon, pi aptki shaꞌi e nako maps am hu i hemako ohla ab wo s‑nenashank,” ");
INSERT INTO oodNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ch ab wehs ha wui hab kaij, “Si g wo haꞌichu nenashanad ch ab wo tai g Jiosh g gewkdag mamt pi am hu wo shul pi apꞌekam ch ed. Chum am hi wa g s‑apꞌekam hab elid ch eda pi e nakog.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bash kaij ch amjed gam hu hahawa ep him k heg hab kaij ab Jiosh wui matsh wehpeg ");
INSERT INTO oodNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ch am hahawa uhpam ep jiwia ha wui. Kush ep si kohksh ch pi shaꞌi nenashani ch pi shaꞌi mahch mas has wo chei ab wui. ");
INSERT INTO oodNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ash d i waikkokam, tsh am ep jiwia ha wui. Kush ep si kohksh. Kush hab kaij, “Kumtki ep kohk k e uhꞌulinihogid. T eda e ai mamt ni‑gagda k am wo i ni‑dagito ha wui g pi apꞌekam hemajkam ahni Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Oi g wo wahpamigi. Tt wo hihi. Neh, ia at hu jiwia hegai mat ni‑gagda.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sh am wabsh kia neok. Tsh am jiwia g Judas. Kush shaꞌi si muꞌijj am wehmaj haꞌijj g iꞌis‑papayo uhꞌukch ch haꞌijj g uꞌus. Idam atsh g uꞌugchu papal ch chehanig t‑mashchamdam ch geꞌeged am ha cheha matsh am wo hihim k wo bei. ");
INSERT INTO oodNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kush eda g Judas heki hu ha ahgid idam mo am wehmaj matsh ab wo chintad g Jesus kahmaj ab. Tsh hab masma wo s‑mahchk mat hedai an wo bei. ");
INSERT INTO oodNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tsh am wabsh i chum jiwia g Judas k wabsh shel i hih ab Jesus wui k hab kaij, “Ni‑mashchamdam.” Neh, bash kaij ch ab chintad. ");
INSERT INTO oodNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tsh ab haꞌi hihim k an bei g Jesus k gan hu si s‑wihnam uꞌukch. ");
INSERT INTO oodNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kutsh hema hegam chuhchaij am i wuhshad g e‑ispahyo k ab si gehg g neholigaj g uhgchu pahl k an si hikuch g nahkaj. ");
INSERT INTO oodNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Sh g Jesus hab ha ahg idam hemajkam, “Wehs tashkaj ani am dahiwup ch ha mashcham geꞌe cheopi t am. Kumt pi an hu ni‑be k wabshaba hahawa ia dada an uhꞌukch g iꞌis‑papayo ch uꞌus mamt wo ni‑bei. Pegih, bat wa masma an heki hu oꞌoha g kekelibad Jiosh haꞌichu i tashogiddam mant hab masma wo ni‑behij mat g pi ap hemajkam.” Neh, bash kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kutsh am hahawa wehsijj wabsh i dagito hegam chuhchaij k gam hu si aꞌai wohp. ");
INSERT INTO oodNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sh an hema oidahim g Jesus ch d wabsh wechij oꞌodham ch heg waꞌi sawanokaj e hobinodch. Kutsh an chum bei g shondal. ");
INSERT INTO oodNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tsh am wabsh i dagito g e‑sawano k gam hu si meh ab wabsh i s‑dahpkch. ");
INSERT INTO oodNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kumtsh am i bei g Jesus heg kih wui uhgchu pahl. Kush eda am e hemapdahim g uꞌugchu papal ch geꞌeged ch chehanig t‑mashchamdam. ");
INSERT INTO oodNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Sh g Peter ga hu wabsh mehkjed ha oid ch am i wah kolhai ch ed. Sh am ge nahdch g shondal. Kush am ha wehm e huhkalid g Peter. ");
INSERT INTO oodNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kush eda idam e jehnigiddam am i chum haꞌichu gahg mat ab wo abch g Jesus mat heg hekaj wo mua. ");
INSERT INTO oodNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Muꞌijj ash ab haꞌichu chum abchud mash pi shaꞌi woho ch oi wa pi shaꞌi e wepo haꞌichu ahg. ");
INSERT INTO oodNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kutsh am hahawa haꞌi gegokiwua k hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kah ach mo hab kaij. ‘Nt wo padch ihda geꞌe cheopi mat g oꞌodham hab juh k hema ep wo nahto waik tash ab mat pi d wo oꞌodham nahtoik.’ ” ");
INSERT INTO oodNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kush idam hab waꞌap pi shaꞌi e wepot g haꞌichu ha‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kutsh g si uhgchu pahl am i kekiwua ha shahgid k ab kakke g Jesus, “Napt pi am hu has wo shaꞌi chei id amjed mo haschu ab m‑abchud idam?” ");
INSERT INTO oodNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kush oi wa pi am hu has shaꞌi ha kaij g Jesus. Kutsh ab ep si kakke, “Nap hab e elid map ahpi d Jiosh alidag matp am t‑dahm wo e kei?” ");
INSERT INTO oodNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kush hab kaij g Jesus, “Dani ahni. T g Jiosh am wo e chehgi mo ab si has ni‑elid an s‑apkojed e‑hugid an ni‑dahshk e‑kownal daikud ed. T ab wo i e ai mant ab wo i hud chewagi ch ed k am ep wo jiwia jewed dahm. Kumt wehsijj wo s‑mai mani d Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kutsh g uhgchu pahl ab si wantsh g e‑eniga hab elidch mo pi ap neok k hab kaij, “Pi ach hedai ep shaꞌi tatchua mas am wo ah g chuꞌijigaj. ");
INSERT INTO oodNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Am am wa kah g pi kehg neꞌokij. Shahm i elid?” Kush wehsijj hab kaij matsh ab moht g chuꞌijig am hugkam mat hemho wa wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kutsh haꞌijj ab si siswuimad g Jesus. Mtsh ab hahawa si maꞌishk wuh g wuhpuij k ab si shonikkash ch hab ahg, “Am g hig t‑ahgid mas hedai ab m‑shonikka.” Tsh g shondal am hahawa be k ab si s‑kapnim shonikkash. ");
INSERT INTO oodNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sh eda g Peter am daha kih bahsho. Kutsh am hema jiwia g uwi piongaj g uhgchu pahl. ");
INSERT INTO oodNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Sh am daha g Peter ch e huhkalid. Tsh id ab si i neid k hab kaij, “Ahpi ap ep wehmaj hegai Jesus.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kutsh pi mahch k e ah g Peter hab kaijch, “Pi ani shaꞌi mahch ch pi amichud maps haschu hab ahg,” neh, k gam hu ha hekaj hih mash am haꞌi gegok kolhai kihjeg t ab. Kush eda kuhu g keli chuchul. ");
INSERT INTO oodNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tsh am ep cheh g Peter hegai ha‑pionag k hab kaij am ha wui hegam mash an gegok, “Id o d ep hema hegam Jesus.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kutsh ep pi e edagi g Peter. Kutsh shaꞌi haꞌas, sh hegam mash an gegok hab ep kaij ab wui, “Pi g shaꞌi pi e edgid. Dapki woho hema hegam Jesus napki pi ahpi hab waꞌap d Galilee t am oꞌodham.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kutsh g Peter am ha hekaj si ha ahgi, “Pi ani shaꞌi mahch ihda oꞌodham mam an aꞌaga. T g Jiosh wo si ni‑jehkaꞌich mantp em‑iattogid.” ");
INSERT INTO oodNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kutsh am ha hekaj gokko kuhu g keli chuchul. Tsh g Peter am wabsh si i chegito mash wa hab kaij g Jesus, “Koi at gokko wo kuhu g chuchul kupt eda heki hu waikko hab wo chei map pi shaꞌi ni‑mahch.” Tsh wabsh wohoꞌi pi ap e taht k s‑jupij shoak. ");
INSERT INTO oodNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tsh am wabsh i chum mahsi. Tsh am ep e nam hegam uꞌugchu papal ch geꞌeged ch chehanig t‑mashchamdam mo d e jehnigiddam k atsh am i mamche mat has hahawa ep wo e juh. Tsh am i kuhgit g ha‑namki. Kutsh am si maniadad g Jesus nohnhoi k gam hu be k am uꞌapa heg wui mo d kownal ch hab chehgig Pilate ab abchudch mo chum e kownalchud. ");
INSERT INTO oodNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kush ihda Pilate ab kakke g Jesus, “No wa woho mapsh hab chum e elid map d ha‑kownalig idam Tutuligo hemajkam?” Sh hab kaij g Jesus, “Dani ahni.” ");
INSERT INTO oodNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sh g uꞌugchu papal muꞌi haꞌichu ab abchud. Sh pi am hu has shaꞌi kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Sh g Pilate ab ep kakke, “Neh, muꞌi haꞌichu o ab m‑abchud. Napt pi am hu has wo shaꞌi chei ab amjed?” ");
INSERT INTO oodNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kush ep pi am hu has shaꞌi ha kaij g Jesus. Tsh g Pilate si has i e taht heg hekaj. ");
INSERT INTO oodNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","K am hab e wua ahid ab id eda gegosig mo g kownal am hema i dadagitod g lihso am ha wehhejed g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kush eda am haꞌi kuhpi g lilso matsh haꞌi ha kokda am i chum wushshadch g kownal. Sh hema hab chehgig idam Barabbas. ");
INSERT INTO oodNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kutsh g hemajkam ab i kakke g Pilate matsh am hab hig wo ha juni hegai mash chum hekid am hab ha wuijid. ");
INSERT INTO oodNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Sh g Pilate ab ha kakke, “Pegih, nam hab elid mant id am wo i dagito am em‑wehhejed mash d em‑kownalig?” nash pi chum s‑dagitoimk g Jesus ");
INSERT INTO oodNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ch hab ha elid mo d waꞌi idam uꞌugchu papal ch s‑hehgamk ch s‑muꞌamk. ");
INSERT INTO oodNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kutsh wabshaba g uꞌugchu papal am i ha cheha g hemajkam matsh hab wo chei matsh g Barabbas wo e dagito. Kutsh wa woho am hab e juh. ");
INSERT INTO oodNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kush hab ep kaij g Pilate, “Pegih, kunt has wo juh ihda oꞌodham mam hab aꞌaga mo d em‑kownalig?” ");
INSERT INTO oodNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kush si s‑kaidam hab kaij g hemajkam, “Muꞌani ab kots t ab!” ");
INSERT INTO oodNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kutsh hab chum chei g Pilate, “Haschu ahg? Shahchu at hig pi ap has juh?” Kush oi wa wabsh baꞌich i si s‑kaidam hab wabsh ge kaij muꞌikko, “Muꞌani! Muꞌani ab kots t ab.” ");
INSERT INTO oodNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kush g Pilate tatchua mat wo s‑hohhoꞌi g hemajkam ch atsh heg hekaj am i dagito g Barabbas am ha wui k am ha cheha g shondal mat am wo gewitta g Jesus. Kumtsh wa woho hab juh. Tsh am hahawa ha wui dagito matsh gam hu wo be k ab wo naggia kots t ab. ");
INSERT INTO oodNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kutsh gam hu hahawa i bei g shondal g Jesus kownal geꞌe kih am k am wehs ha wai g e‑wehm shondal. ");
INSERT INTO oodNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kutsh am i e hemapad k nahnko wua. Msh wa ab abchud mash chum e kownalchud. Pegih, tsh ab wahki g kownal eniga k ge hoꞌi gihkot k ab wahki moꞌoj ab. ");
INSERT INTO oodNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kush hab wabsh s‑ahgamk ch hab kaij, “Tash g d ha‑kownaligk g Tutuligo hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tsh haꞌi an si gewitta moꞌoj an g uhskaj k ab siswuimad k ab wui i shul pehegia ab has elidch. ");
INSERT INTO oodNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kumtsh am i haꞌasa nahnkogid k am si wuahawua hegai kownal eniga k ab uhpam wahki g enigaj k gam hu hahawa i bei mat ab wo naggia kots t ab. ");
INSERT INTO oodNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","D ab hema i ha nam g oꞌodham ch ab him Jerusalem wui ch ash hab chehgig Simon. Id ad an bei g shondal k ab kushwiotach hegai kots mamt ab ab wo naggia g Jesus. Ihda Simon ash ab d kihkam Cyrene kihhim t ab ch d ha‑ohg idam Alexander ch Rufus. ");
INSERT INTO oodNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kumd gam hu i bei g Jesus mam am ha nahngia. K hab e aꞌaga amai Golgotha mo id hab d ahga Koshwak. ");
INSERT INTO oodNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kumd am chum iꞌich g nawait ch kulani mat wo hehogih g s‑koꞌok. Kud pi shaꞌi ih g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kumd ab hahawa sisish kots t ab k am kei g kots. D am haꞌi e chichwi g shondal k wo nei mas hedai haschu wo bei g haꞌichu enigaj. ");
INSERT INTO oodNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","K eda ga hu i juhk madki heki hu e ai g humukt ohla mamd ab naggia kots t ab. ");
INSERT INTO oodNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","D an oꞌohanas g ha‑abchuda ab dahm mo ab i moꞌokch g Jesus ch hab chuꞌig, “Id o d ha‑Kownalig g Tutuligo Hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kumd gohk ab ep ha nahngia kokots t ab gan hu aꞌai. Sh eda d s‑chu eꞌeskam idam.  ");
INSERT INTO oodNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kum hab masma am chehgidch mam hab elid mo g Jesus hab waꞌap d pi ap hemajkam. Neh, heki o hu an oꞌohanas Jiosh oꞌohana ed mat id am hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","D hegam mo am bihbimhim nahnko ahg ch hab ahg, “Naptsh woho wo i wua g geꞌe cheopi k am uhpam ep wo i kei waik tash ab? ");
INSERT INTO oodNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pegih, ab g hig i huduni kots t amjed k wo e doꞌibia maptp wo e nako.” ");
INSERT INTO oodNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","D g uꞌugchu papal ch chehanig t‑mashchamdam am hab waꞌap nahnko ahg hab kaijch ab aꞌai e wui, “Id atsh haꞌi ha doꞌibia k atki wabshaba pi wo e nako mas wo hejel e doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nash hig pi woho d Jiosh si Kehsha ch d t‑kownalig? Pegih, tt ab wo s‑wohoch matp ab wo i huduni k wo e doꞌibia.” D hegam ehp mad ab wehmaj nahngia hab waꞌap nahnko ahg. ");
INSERT INTO oodNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","D am i dahm juh. D wehsko gei g s‑chuhugam waik ohla ab. ");
INSERT INTO oodNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","D am i e ai g waik ohla. D si s‑kaidam hab kaij g Jesus, “Eloi, Eloi, lama sabaktani.” Id o hab d ahga, “Ni‑Jioshga, ni‑Jioshga, pt haschu ahgk wabsh ni‑dagito?” ");
INSERT INTO oodNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","D haꞌijj hab kaij hegam mad am gegok, “Nehꞌe, Elijabad o ab chum waid.” ");
INSERT INTO oodNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kud am hema med k an haꞌichu usko mad am wakch nawait ch ed k am uhgk i be k ab chum iꞌich g Jesus k hab chei, “Kia koi, tt hig wo nei mas ia wo jiwia g Elijabad k ab wo i huduni.” ");
INSERT INTO oodNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kud am si s‑kaidam haꞌichu hab ep chei g Jesus k am hahawa i muh. ");
INSERT INTO oodNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kutsh hegai s‑kowk ikus kuhpadag mash am s‑tadnim naggia ged hu si eda g geꞌe cheopi ab si shel e wantsh. ");
INSERT INTO oodNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","D hegai moki d shondal ha‑geꞌejig gahab kehk kots wui ch am kah g Jesus ch am neid mat has masma muh ch hab kaij, “Ihda oki si s‑wohom d alidaj g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","D ga hu sha mehkjed g uꞌuwi ab haꞌi neid mat haschu has e juh. Haꞌi idam o d Salome ch Mary Magdalene ch hegai Mary mo d ha‑jeꞌe idam James ch Joses. ");
INSERT INTO oodNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Idam waik ash am wehmaj oiopohim g Jesus ch haꞌichukaj i wehmt mo eda gam hu oimmelhim Galilee chekshani ch ed. Kud muꞌi idam uꞌuwi am wehmaj ab i hihi g Jesus Jerusalem wui. ");
INSERT INTO oodNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","D am haꞌichug hegai e jehnigiddam mo ab Arimathea t amjed ch hab chehgig Joseph. Id o si s‑ap d oꞌodham ch ab s‑neidamk g Jiosh kownaltalig. D eda e aihim mat wo i hud. Kuchd eda am chum t‑nakog matt baꞌich i tash wo chum t‑mihshmad. D heg hekaj am hih ihda Joseph k atsh ab tai g kownal g Jesus honshpadag. ");
INSERT INTO oodNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kush g Pilate hab kaij, “A nat wa s‑wohom heki hu i muh?” atsh am hahawa wai g shondal ha‑geꞌejig. ");
INSERT INTO oodNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sh id hab kaij mat heki hu muh. Kush hab hahawa ahg g Joseph mo am wa s‑ape mat am wo bei. ");
INSERT INTO oodNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kutsh g Joseph am him k am ha nolawt g si s‑kehg ikus k am ep jiwia. Kumd am wehhejed ab i huduni g Jesus honshpadag. K am mia hab chuꞌig g hihaꞌini ch ab heki hu cheotas hodai ch ed. Kumd am i be k ged hu heg eda cheh am i hobinodk heg hekaj s‑kehg ikus. Kumd ab hahawa kuh g geꞌe hodaikaj. ");
INSERT INTO oodNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","D g Mary Magdalene ch hegai Mary mo d ha‑jeꞌe g James ch Joses am wa neid mad hebai e cheh. ");
INSERT INTO oodNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kud am bij g shahwai machd eda t‑mihshmad. Kutsh am hahawa hihi g Salome ch Mary Magdalene ch hegai hema Mary k am ha nolawt g si s‑ap uhwchu matsh hekaj wo huhu g muhki. ");
INSERT INTO oodNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","Wabsh i siꞌalim mo e aihim g domig, tsh gam hu hihi idam hihaꞌini wui k am neneokhim ch hab kaij, “Kus hedai t‑wehhejed gam hu wo i nuꞌichkwua hegai hodai mat ab hekaj e kuh g cheo?” Tsh ab i chesh g tash matsh eda ged hu dada. ");
INSERT INTO oodNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tsh chum nei matsh heki hu in hu hab i e nuꞌichkwua. ");
INSERT INTO oodNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tsh am i wahp. Kush inhab hema dak ch hab sha mahs mo g wechij oꞌodham. Sh g enigaj wabsh si s‑toa. Kutsh si e totods g uꞌuwi. ");
INSERT INTO oodNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sh wabshaba hab ha ahg, “Pi g am wo shaꞌi e totodsid. M ani wa s‑mahch mam g Jesus chuhkug chum gahghim. Am g wo neid mo pi ia hu haꞌichug iia mat ia e woi. Uhpam at ep i wuhsh muhkig t amjed. ");
INSERT INTO oodNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kumt gam hu wo hihim k wo ha ahgi g chuhchaij, chum wa g Peter, mat uhpam e chegito k gam hu wo hih Galilee wui. Mt gm hu wo hihim k am haꞌab wo nei.” Neh, bash kaij g anghil. ");
INSERT INTO oodNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kutsh i wuwhag k gam hu uhpam wohp pi hedai shaꞌi ha ahgidch wohg oidch nash pi si e totodsid. ");
INSERT INTO oodNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pi atsh wa koi mahsi domig tash matsh eda e chegito g Jesus. Tsh ab i chesh g tash. Kutsh amjed am i e chehgi Mary Magdalene wui si wehpeg. Dash ihda matsh wa ab amjed i ha wuwhas g wewaꞌak jijawul. ");
INSERT INTO oodNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kutsh am hahawa ha wui hih g Mary hegam mash am wehmajkahim g Jesus. Sh eda am si pi ap e tahtk ch shoani idam. Kush hab ahg matki e chegito. ");
INSERT INTO oodNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sh wabshaba pi shaꞌi wohochud. ");
INSERT INTO oodNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Sh am i dahm haꞌi gam hu hasko hihimad ch d gohk. Tsh g Jesus gawul masma am i e chehgi ha wui. ");
INSERT INTO oodNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kutsh idam am uhpam ep hihim k ged hu wehs ha ahgi g chuhchaij. Kush pi shaꞌi ha wohochud. ");
INSERT INTO oodNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tsh am hahawa i e chehgi g Jesus hegam ha wui gamai hemako e‑chuhchai. Sh idam am e wehm e gegosid. Tsh am s‑ha kehꞌel nash ge ha wohochud hegam mash neid mo d doakam ");
INSERT INTO oodNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ch hab hahawa ha ahg, “Am g wo aꞌai hihim k am wo i ha ahgidahi wehs hemajkam ihda s‑kehg haꞌichu ahgaj g Jiosh ab ni‑amjed. ");
INSERT INTO oodNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kut heg wo e doꞌibia matp hedai wo i s‑wohochud k wo e pahl wako. T wabshaba ab wo moht g pi ap e‑chuꞌijig k ab wo ai g pi ha huhugedam shoꞌigdag matp hedai pi ab hu wo wohoch. ");
INSERT INTO oodNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","T wo tashok mo hedai ab ni‑hiwig nant pi ab wo ha mah g gewkdag. Kut am wo i ha wuwhasidad g jijawul ni‑wehhejed ch ep wo neneokad g gawul kaidam neꞌokikaj mat pi hebai mai. ");
INSERT INTO oodNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kut pi has wo e juh matp wo ha taht g kohkꞌoi o atp wo ihꞌed g hialwui. Kut an wo ha taht g kokꞌodam. T wo doda.” ");
INSERT INTO oodNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kutsh am i haꞌas ha wehm neo g Jesus k am i dahm hahawa uhgk i e bei dahm kahchim wui k ga hu s‑apkojed dahiwua e‑ohg Jiosh hugid ab. ");
INSERT INTO oodNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","T idam gam hu aꞌai ha ahgidahi g hemajkam g s‑kehg haꞌichu ahgaj g Jiosh. Kut g Jiosh si s‑hasig haꞌichu hab ha juni mat hekaj wo s‑mahchk g hemajkam mo d wohokam g haꞌichu ha‑ahga.  (9) Kutsh am hihi g uꞌuwi k am ha ahgi idam Peter mat haschu kah. (10) Tsh heg i dahm g Jesus am hahawa ha cheha g e‑chuhchai mat gam hu wehsko wo i ahgahi g s‑kehg haꞌichu ahgaj mat g hemajkam ab wo s‑wohochud k wo e doꞌibia.");
INSERT INTO oodNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Ni-nawoj map ab si tatchua g Jiosh: Ab apsh kaiham ihda s-kehg haꞌichu ahga ab amjed g Jiosh alidag mach ab s-wohochud. Kunt am wo haꞌichu m-oꞌohani ab amjed mapt hekaj wo s-ap s-mahchk. Hegam mash am neid o am t-ahgid ab amjed. Kut muꞌi am s-ap oꞌoha hegai mo haschu am t-ahgid. Nt ahni am si i hoa wehs ihda k hekaj am wo m-oꞌohanid k am baꞌich haꞌichu wo m-ahgi ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Amjed atsh ab i shohshonwua ihda mash eda g Herodbad am d kownal Judea chekshani ch ed am ha dahm g Tutuligo hemajkam. Sh am hema d ha-pahlig ch hab chehgig Zacaria. Sh g wehmaj kihkam hab chehgig Elisabed. Idam ash ab d amjedkamaj hegai mash d ha-shohshonbad g papal ch hab chehgig Aaron. Kush g Zacaria ab hema d amjedkam mash hab chehgig Abia. ");
INSERT INTO oodNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kush idam Zacaria ch Elisabed am si oid g s-apꞌekam ch s-ap am hab junihim wehs hegai mo g Jiosh ab ha chehani g Tutuligo. ");
INSERT INTO oodNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kutsh wabsh okst ihda Elisabed k pi ha mahmadt. Tsh g Zacaria hab waꞌap kelit. ");
INSERT INTO oodNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kutsh hema tash am i e ai matsh g Abiabad amjedkam am hab wo juh g e-chikpan geꞌe cheopi ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kumtsh am i kei g Zacaria matsh am wo ha mehmhei g s-ap uhw kuhbhondakud. Tsh am i wah cheopi ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kush am jeg ed gegok g hemajkam ch e hoꞌigeꞌidahun. ");
INSERT INTO oodNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tsh am cheopi ch ed hema i e chehgi g anghil Zacaria tahgio k ash ab kehk s-apkojed abai mash ab kuhbhoni g s-ap uhw kuhbhondakud. ");
INSERT INTO oodNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tsh am i nei g Zacaria k si e todsid k si s-ehbeni ihda. ");
INSERT INTO oodNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kush wabshaba hab kaij g anghil, “Pi g am shaꞌi e todsid, Zacaria. Jiosh at kah g m-hoꞌigeꞌidahuna. T g m-wehm kihkam wo wa hema madt. T d wo cheojk. Kupt hab wo chehch John. ");
INSERT INTO oodNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Jiosh at ab a wo si has elidad. Kut pi koi wo mahsi. T g Jiosh ab wo mah g Hekia S-apꞌekam Gewkdag. Kupt heg hekaj wo si s-hehgigk. T g muꞌi hemajkam hab waꞌap wo si s-hehgigk mat hekid wo mahsi. Kut ihda em-aliga pi hekid wo ihꞌed hegai mo s-nawmdag. ");
INSERT INTO oodNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ch muꞌi ab wo i ha nohnogi g Tutuligo hemajkam ab Jiosh wui. ");
INSERT INTO oodNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","T koi in hu wo i wuhsh g Jiosh si Kehsha jewed dahm. T g em-aliga ia wehpeg wo ahgachugad mat in wo i wuhsh. T g Hekia S-apꞌekam Gewkdag ab wo mah g gewkdag heg wehhejed hab masma mo wa ab mahkch g Elijabad. Kut hab wo ha juh g hemajkam mat ab wo si pihk e elidad ha hekaj g e-aꞌaliga k hegam hab wo ha juh mo d pi apꞌekam mat ab wo kaihamad g ha-amichudadag hegam mo d s-apꞌekam. Neh, bat masma am wo i ha apꞌech g hemajkam heg wehhejed jiwhiadaj g Jiosh si Kehsha.” Neh, bash kaij hegai anghil. ");
INSERT INTO oodNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kush g Zacaria hab kaij, “Nt has hig masma wo si s-ap s-mahchk machs wo hema bei g ali natt pi kekelt?” ");
INSERT INTO oodNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sh hab kaij g anghil ab wui, “Dani Jiosh chikpandam, Gabriel. Kut ab ni-cheha mant ia wo m-ahgi ihda si s-hehgig haꞌichu ahgaj. ");
INSERT INTO oodNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kupt eda pi ab hu ni-wohoch. T heg hekaj hab wo m-juh mapt pi wo shaꞌi e nako maps wo ha neokad iaꞌi amjed am hugkam mat hab wo e juh ihda mani m-ahgid.” Neh, bash kaij hegai anghil. ");
INSERT INTO oodNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sh eda heg oidam am chum nenida g hemajkam g Zacaria ch si has i elid k hab kaij, “A t has e juh k pi oi ab hu i wuhsh?” ");
INSERT INTO oodNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tsh am hu hebai ab hahawa i wuhshani k chum neo am ha wui k wabsh pi shaꞌi e nako. Sh am ha hekaj wabsh i amich g hemajkam matki ab haꞌichu e chehgi wui no pi ab wabsh i ha magwuid g e-nowikaj ch pi ab hu has shaꞌi kaij. ");
INSERT INTO oodNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tsh am wabsh i chum huhug g tash mat heꞌes tash am hab wo juh g e-chikpan. Tsh gam uhpam hih e-kih wui. ");
INSERT INTO oodNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Kush amai i mia amjed matsh woꞌiwua g ali. Kush am wabsh s-ap e tahtk ch am e ehstokch g Elisabed e-kih ed hetasp mashad hab kaijhim, “Chum ani hekid si ni-elid mani pi ha mahmadt. Kutki wabshaba id hab ni-juni g Jiosh k hekaj gam hu hab i juh g si ni-edadag am hemajkam ha-nena ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Neh, tsh am him k am d i chuhdp mashad am i dahm matsh am woꞌiwua g Elisabed mad. Tsh g Jiosh am chea hegai anghil mash d Gabriel matsh am wo uꞌapa g haꞌichu ahgaj hema wui g chehia. Sh hab chehgig ihda chehia Mary ch am kih heg eda kihhim mash d Nazareth ch am eda g Galilee chekshani. Sh am hema ep d kihkam ch hab chehgig Joseph ch atsh wo hohnt hegai Mary. Idam ash ab hema d amjedkam mash kownalibad ch hab chehgig David. ");
INSERT INTO oodNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kutsh koi e ai matsh wo e hohont. Tsh am jiwia hegai anghil Mary wui k hab kaij, “Si g s-hehgigk Mary. Jiosh at ab i s-m-hoꞌigeꞌid k am wo i m-wehmt.” ");
INSERT INTO oodNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tsh am wabsh i pi amich mas haschu hab ahg k si e kudu heg hekaj. ");
INSERT INTO oodNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sh hab ep kaij g anghil, “Pi g am shaꞌi e todsid, Mary. Ab at i m-mah g Jiosh g hoꞌigeꞌidadag. ");
INSERT INTO oodNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kut am wabsh wo e nahto g ali m-eda k wo mahsi k d wo cheojk. Kupt hab wo chehch Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kut d wo si s-has haꞌichuk no pi d alidaj g Jiosh. T g Jiosh am wo i kei mat d wo kownalk am kehkud ed g e-shohshonbad David. ");
INSERT INTO oodNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kut chum hekid d wo ha-kownaligk g Jiosh hemajkamga. Pi at hekid wo huhug g kownaltaligaj.” Neh, bash kaij g anghil. ");
INSERT INTO oodNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Sh hab kaij g Mary ab wui, “Nt has hig masma wo ge madt mani d wabsh kia chehia ch pi koi ha kun?” ");
INSERT INTO oodNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sh g anghil ab wui hab kaij, “Jiosh at ab wo cheha g Hekia S-apꞌekam Gewkdag. T heg hab wo juh g Jiosh gewkdagkaj. Mt heg hekaj wo s-mahchk mat d wo si hekia s-apꞌekam alik ch d wo Jiosh alidagk. ");
INSERT INTO oodNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Neh, s-mahch ap mat heki hu okst g m-hajuni Elisabed k pi ha mahmadt. Kut eda g Jiosh ab s-hoꞌigeꞌel. Kut g cheoj ali wo bei. K d chuhdp mashad hemu mat am woꞌiwua g ali. ");
INSERT INTO oodNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kupt id amjed wo s-mahchk mat wo e nako g Jiosh mat am hab wo juh hegai mo haschu hab e ahgahim.” Neh, bash kaij g anghil. ");
INSERT INTO oodNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kush hab hahawa kaij g Mary, “Neh, dani piongaj g Jiosh. K am wa s-apꞌe mat am hab wo juh g e-tatchui ab ni-ab” Tsh gam hahawa hih g anghil ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Tsh ab ha hekaj i e nako g Mary mat am wo chehgim g Elisabed. Sh hegam Elisabed ch Zacaria am kih mash am hema kihhim kaꞌakwulk ch ed am Judea chekshani ch ed. Tsh am jiwia Mary ha-kih am k ab ha-ihm. ");
INSERT INTO oodNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tsh am i kah g Elisabed k ab taht matsh g madaj am si al i banimme eda. Tsh g Hekia S-apꞌekam Gewdag ab si i mah g gewdag. ");
INSERT INTO oodNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kush hekaj si s-hehgigam hab kaij ab wui g Mary, “Neh, ab atki si i s-m-hoꞌigeꞌel g Jiosh baꞌiwechkim mo chum hedai uwi. Kutki wo mahsi m-amjed hegai mash ab mahks g si geꞌe s-apꞌekam. ");
INSERT INTO oodNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kuptki d wo jeꞌejk hegai mat d wo ge t-kownalig. Kuni si s-ap ni-tahtk mapt iaꞌi ni-chehgim. ");
INSERT INTO oodNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Neh, am at si i banimme g ni-mad mant am i m-kah mapt ab ni-ihm. K heg hekaj am ni-chehgid g Jiosh mo ab si s-m-hoꞌigeꞌid. ");
INSERT INTO oodNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Woho at hab wo e juh hegai mo ab m-chehgid g Jiosh. K d si geꞌe hoꞌigeꞌidalig mapt ab i s-wohoch.” Neh, bash kaij g Elisabed. ");
INSERT INTO oodNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kush g Mary hab kaij: “Ab ani si hehgchulid g Jiosh ");
INSERT INTO oodNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ch si s-ap ni-tahtk mo d ni-doꞌibiakam. ");
INSERT INTO oodNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Dani wabsh shoꞌigkam. Kut eda ab si has i ni-elid k si geꞌe haꞌichu ab hab ni-juni g si geꞌe e-gewkdagkaj. T Hab iꞌajed chum hekid hab wo chei g hemajkam imhab aꞌahidag oidam mat ab si i s-ni-hoꞌigeꞌel g Jiosh. Do si hekia s-apꞌekam g Jiosh ");
INSERT INTO oodNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ch eda iaꞌi aꞌahidag himdam oidch si pihk e elid ab wehs ha wui hegam mo ab si has i elid. ");
INSERT INTO oodNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","T am wo chehgi g si geꞌe e-gewkdag k wo has gewito hegam mo si e hahaschud ");
INSERT INTO oodNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","53","k wo ha wohppoꞌi g kokownal g ha-gewdag k g s-kakais s-ha-kaisdag gam hu hab wo i juh k wabshaba g shoꞌigkam ab has wo i ha elid k heg ab wo i ha mah mo haschu i s-kehgaj ha wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Neh, bash wa am ha ahgid g t-shohshonbad ged hu i Abraham amjed matsh id am hab wo e juh. Ab o i t-wehmt g Jiosh ahchim mach ab d ha-amjedkam k ab wehs t-wui si pihk e elid iꞌajed chum hekid.” ");
INSERT INTO oodNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Neh, bash hahawa g Mary ch amjed am ha wehm dakahim waik mashad ab ch gam hahawa hih uhpam. ");
INSERT INTO oodNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tsh am hahawa i e ai. Tsh madt g Elisabed. Kush d cheoj ali. ");
INSERT INTO oodNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sh g hajunij ch hugidaj an kihkam si s-hehgig wehmaj am i kaiok matsh g Jiosh ab si i s-hoꞌigeꞌel. ");
INSERT INTO oodNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kush am d i gigiꞌik tash g ali. Kumtsh wo pahl hikuch mo d ha-himdag. Tsh am e chehm g hemajkam k hab wo chum chehch Zacaria am oidk g ohgaj. ");
INSERT INTO oodNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kush wabshaba hab kaij g jeꞌej, “Pi atsh g e-ohg oidk wo chehgigk ch wabshaba hab wo chehgigk John.” ");
INSERT INTO oodNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Sh hab kaij hegam, “Pi o hedai hab shaꞌi chehgig g m-hajuni,” ");
INSERT INTO oodNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ch amjed ab wabsh i chum kakke g ohgaj mat am wo ha ahgi mas has wo chehch. ");
INSERT INTO oodNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sh heg hema ha tahni g oꞌohanakud. Mtsh hema mah. Kutsh id an oꞌoha, “Bo chehgig John”. Tsh wehsijj si e totods. ");
INSERT INTO oodNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kutsh am waꞌi hekaj s-ap neok k ab si ihm g Jiosh ch ab si hoꞌigeꞌid. ");
INSERT INTO oodNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tsh wehsijj ab si has el g Jiosh hegam mo an ha wehgaj kih. Tsh gan hu aꞌai s-e mai am Judea chekshani ch ed mat has i e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ab ash si s-hoꞌigeꞌid g Jiosh ihda ali. Kush wehsijj hegam mash am kah am si i oidahim ch hab kaij, “Kus has mahs wo haꞌichuk ihda ali?” ");
INSERT INTO oodNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kutsh g Hekia S-apꞌekam Gewkdag g si geꞌe gewkdag ab i mah g Zacaria. Tsh heg am si s-hewelim neok k gam hu baꞌich ah mat haschu has wo e juh hab kaijch: ");
INSERT INTO oodNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ab ant wo si i hehgchul g s-apꞌekam t-kownalig Jiosh. E o nahtokch mat wo t-doꞌibia ahchim mach d hemajkamgaj ");
INSERT INTO oodNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ch atsh hekaj am hema wo i maskogi mat d wo t-doꞌibiakamk. Heg at ab d wo kownal Davidbad amjedkamk ch wo uꞌukch g si geꞌe gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Kekelibad Jiosh haꞌichu i tashogiddam o heki hu am ahgachug matsh g Jiosh wo t-doꞌibia ab ha amjed g t-obga ch hegam mo s-t-kehꞌid. ");
INSERT INTO oodNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ab at wo i s-t-hoꞌigeꞌel g Jiosh mash wa hab masma ha ahgid g t-shohshon. ");
INSERT INTO oodNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Bash si kaij ab Abrahambad wui mat wo t-doꞌibia ab ha amjed g t-obga. Tt hab pi hedai wo ehbidad ch ab si s-ap wo ihmad g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ch wo s-apꞌek am nenaj ed ch am hab wo junihid g s-apꞌekam chum hekid. ");
INSERT INTO oodNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","78","Ihda ni-sulijga at d wo Jiosh haꞌichu i tashogiddamk ch wo ha ahgi g Jiosh hemajkamga mat g Jiosh ab wo s-ha hoꞌigeꞌid k gam hu hab wo i juh g pi ap ha-chuꞌijig k wo ha doꞌibia ab amjed g s-koꞌok ha-namkidadag. Kut heg hekaj wo e nahtokchid mat g doꞌibiakam am wo i e maskogi. Id at am wo i wuhsh Jiosh t amjed k ab wo t-mah g amichudadag. ");
INSERT INTO oodNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","hab masma mo g tash ab i chechshshaj ch ab t-mamka g tonlig. Ab ach wa hihim t-namkidadag wui mat g Jiosh gam hu hab wo i t-juh heg hekaj pi ap t-chuꞌijig. Kut wabshaba g t-doꞌibiakam ab wo i t-chehgi matt has masma am wo i t-apꞌech Jiosh wui.” Neh bash kaij g Zacaria. ");
INSERT INTO oodNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kutsh si s-gegokim i geꞌeda g ali am e tashogid mo am Jiosh tatchui oidch him. Kush am hebai d i himdam, tsh gm hu i e gawulkai tohono jewed ch ed k am haꞌichugkahim ch ab ai mat am i e maskogi Tutuligo ha wui. ");
INSERT INTO oodNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sh am hema d si geꞌe lai wehs ha dahm g jejewed ch hab chehgig Augustus. Sha am hu hebai, tsh id am hab juh g chehanig matsh wehs wo e oꞌohan k wo e kuint g hemajkam heheꞌejel e‑kihhim ab. ");
INSERT INTO oodNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Id ash d si wehpeg kuintadag. Kush am hema d kownal Syria jewed ch ed hab chehgig Quirinius. ");
INSERT INTO oodNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tsh am himto g hemajkam ab heheꞌejel e‑kihhim wui matsh wo e oꞌohan k wo e kuint. ");
INSERT INTO oodNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tsh hegai Joseph mash wa am kih Nazareth t am ch atsh wo hohnt g Mary gam hu hih Bethlehem wui am Judea chekshani ch ed nash pi ab d kownalibad David amjedkam. Sh g Davidbad am d kihkam Bethlehem t am. ");
INSERT INTO oodNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tsh g Mary am oi g Joseph. Sh eda e aihim matsh wo bei g e‑mad. ");
INSERT INTO oodNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Tsh am dada Bethlehem t am. Sh eda pi am hu ha jeg am koksikud kih ch ed. Tsh heg hekaj am dadhaiwua haꞌichu doakam kih ch ed. Kutsh si e ai. Tsh madt g Mary. Kush heg d wehpegkam ch d cheoj. Kutsh am si i hobino s‑moik ikus ch ed k am heg eda woi mo g haꞌichu doakam am e gegosid. ");
INSERT INTO oodNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sh am haꞌi dadha g kahwal ha nuhkuddam gam hu jeg ed ch an ha nuhkud g e‑shoshoiga. ");
INSERT INTO oodNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tsh ab haha wabsh ha wui e chehgi g anghil ab dahm kahchim t amjed. Kutsh an si i ton ha wehgaj matsh am e chehgi g Jiosh gewkdag. Kutsh wabsh wohoꞌi e totods. ");
INSERT INTO oodNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sh hab hahawa kaij g anghil, “Pi g am wo shaꞌi e totodsid. Ia ant jiwia mant haꞌichu wo em‑ahgi. K id wehs hemajkam d ha wuikam. T wo si s‑ap e tahtkkad ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Idani at am mahsi Davidbad kihhim ed hegai mo d Jiosh si Kehsha mat d wo em‑doꞌibiakamk ch d wo geꞌechu em‑kownaligk. ");
INSERT INTO oodNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kumt id ab wo s‑mahchk mat am wo woꞌok heg eda mo am e gegosid g haꞌichu doakam ch g s‑moik ikuskaj wo e hobinodch.” ");
INSERT INTO oodNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tsh haha wabsh shaꞌi muꞌi anghil ab ha wui i e chehgi wehmaj hegai hema k si neꞌe ch ab hehgchulid g Jiosh ch hab kaij. ");
INSERT INTO oodNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ab ach wehsijj hehgchulid g Jiosh an dahm kahchim ch ed. T hegam mo hohhoꞌidachud g Jiosh an jewed dahm wo e doꞌibia k wo si s‑ap e tahtkkad ab aꞌai e wui.” ");
INSERT INTO oodNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Neh, bash kaij g anghil ch gam hu hahawa i himto dahm kahchim wui. Sh hab kaij a kahwal ha nuhkuddam ab aꞌai e wui, “Oi g wo hihim. Tt wo hihi am Bethlehem wui k am wo nei hegai matsh am hab e juh mo ab i t‑ahgid g anghil am wehhejed g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tsh wa woho am si s‑hohtam hihim k am i ha gahghim k ha cheh. Kush woho am woꞌo g ali heg eda mo am e gegosid g haꞌichu doakam. ");
INSERT INTO oodNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tsh hegam kahwal ha nuhkuddam am hahawa i ahgahi mash has kaij g anghil ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tsh wehsijj hegam mash ha kah ab si has i el mo haschu ha ahgid. ");
INSERT INTO oodNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kush am si oidahim g Mary ch am wabsh hejel i s‑mahch. ");
INSERT INTO oodNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tsh g kahwal ha nuhkuddam gam hu uhpam hihi ab si hehgchulidch g Jiosh natsh pi wehs nei hegai mo haschu am ha ahgid g anghil. ");
INSERT INTO oodNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kush am d i gigiꞌik tash g ali. Kumtsh an pahl hikuch mo d ha‑himdag k hab chehch Jesus matsh wa g anghil ia uꞌapa g ahga mat eda koi woꞌiwua. ");
INSERT INTO oodNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Tsh am i e ai g tash matsh g Mary am wo e chehgi mo kegchudas mat hab masma g Mosesbad an oꞌoha g Jiosh chehanig. Bo chuꞌig matsh heg hekaj gohk wo ha kokda g hohhi o g pap‑loloma k ab wo iagchul Jiosh wui. K hab ep chuꞌig matp d wo cheojk g wehpeg mahsidkam ch ab wo i e dagito Jiosh wui. Tsh heg hekaj am bei g ali k am hihi geꞌe cheopi wui ab Jerusalem t ab. ");
INSERT INTO oodNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sh am hema kih g keli ch hab chehgig Simeon ch ash d si s‑apꞌekam ch ab si has elid g Jiosh ch ash ab si nenida mat wo ha doꞌibia g Tutuligo. Sh g Hekia S‑apꞌekam Gewkdag ab si wehmaj ");
INSERT INTO oodNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ch ash am i tashogi matsh pi wo muh k ab wo ai mat wo nei g Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Neh, tsh am i e ai g tash. Tsh am hahawa i tashogi mat am wo i wah geꞌe cheopi ch ed. Kutsh g Joseph ch Mary am uꞌapa g Jesus matsh am hab wo juni mo has i masma d ha‑chehanig. ");
INSERT INTO oodNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tsh g Simeon an koh g ali k ab si e hoꞌigeꞌidahun Jiosh wui hab kaijch. ");
INSERT INTO oodNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Pegih ia o i s‑apꞌe, ni‑Jioshga. Pt ab haha wo i ni‑hiwigi mant wo si s‑ap ni‑taht k ni‑pihhu map hab masma heki hu am ni‑ahgid. ");
INSERT INTO oodNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Neh, ni‑wuhpuikaj ani hahawa neid ihda mapt hekaj wo t‑doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kut wehs hemajkam wo s‑mai ab amjed ");
INSERT INTO oodNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","nat pi d wo ha‑tonligk g nahnko mahs hemajkam ch ab wo si uhgk i ha bei g m‑hemajkamga.” Neh, bash kaij hegai Simeon. ");
INSERT INTO oodNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sh g Joseph ch Mary si has e tahtk heg hekaj mo has i kaij ab amjed g ali. ");
INSERT INTO oodNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sh hab hahawa kaij g Simeon ab ha wui, “Jiosh at wo wa s‑em‑hoꞌigeꞌel,” ch ash hab ep kaij ab jeꞌej wui, “Neh, ihda ali at g Jiosh am si i kei. Kut muꞌi wo t‑doꞌibia. T wabshaba muꞌijj g t‑wehm Tutuligo pi ab hu wo wohochud k im hu hab wo i e juh. Jiosh at ab wo e chehgi t‑wui id hekaj ali. T muꞌijj wo s‑kehꞌid ");
INSERT INTO oodNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","k hekaj wo mahsko wua g e‑chegitoidag. Kut g m‑ihbdag wo si s‑koꞌokkad hab waꞌi masma matp hems g is‑pahyo ab wo si m‑chuꞌakad m‑ihbdag ed.” Neh, bash kaij g Simeon. ");
INSERT INTO oodNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Sh hema g oks am d Jiosh haꞌichu i tashogiddam ch hab chehgig Anna. Sh g ohgajbad hab chehgig Phanuel ch ab d amjedkamaj g Asherbad. Kush g keligaj ihda Anna muh mash eda d haha wabsh i e wehm kihkam wewaꞌak aꞌahid ab. ");
INSERT INTO oodNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Sh am haha d hejel wiꞌikam gigiꞌikko gamai giꞌik (84) aꞌahid ab. Tash oidam ch chuhug oidam ash am haꞌichug geꞌe cheopi t am ch ab si has elid g Jiosh ab wui e hoꞌigeꞌidahunch ch hab al heꞌes haꞌichu koꞌa. ");
INSERT INTO oodNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sh am haꞌichug g ali ch jeꞌej g Joseph wehm. Kutsh am jiwia hegai Anna k ash ab hoꞌigeꞌelid g Jiosh ch am hahawa wehsijj ha ahgid ab amjed g ali hegam mash hab waꞌap nenida matsh g Jiosh wo ha doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Neh, kutsh wehs am hab juh hegai mo an oꞌohanas chehanig ch ed k gam hu hahawa uhpam hihi Galilee chekshani wui k am dada e-kih am Nazareth kihhim t am. ");
INSERT INTO oodNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kutsh ab si s-gegokim i geꞌelhi g ali k wabsh shaꞌi haꞌichu s-amichud. Sh g Jiosh pihk elidadag am si e tashogid wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wehs ahid ab ash am e wushshad Jerusalem t am matsh wa ha doꞌibia g Jiosh g ha-shohshon ab ha amjed g Egypt t am hemajkam. Kush g Jesus jehj chum hekid am hihhim. ");
INSERT INTO oodNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kush am d i gamai gohk aꞌahidag g Jesus. Tsh am i e ai hegai ha-doꞌibiadag wuhshda. Tsh am ep hihi bekch g Jesus k am haꞌichugkahim mo heꞌes i tash am hab e wua. ");
INSERT INTO oodNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tsh am i kuhgit. Tsh gam hu i e nohnogi uhpam. Tsh eda am waꞌi wih g Jesus Jerusalem t am. Sh g jehjij pi mahch mo pi am hu ha wehmaj ");
INSERT INTO oodNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","nash pi hab elid mash an wa hebai ha wehmaj g hihimdam mash am muꞌi e wehm hihim. Kush hekaj hemako tash waꞌi chihpia k an chum gahghi ha oidk g e-hajuni ch e-nanꞌaipijju. ");
INSERT INTO oodNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sh eda pi am hu haꞌichug. Kutsh oi wa gam hu uhpam hihi Jerusalem wui mat an wo i gahghi. ");
INSERT INTO oodNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kush am d i waik tash. Tsh ged hu hahawa cheh geꞌe cheopi ch ed. Kush am dak ch ab ha kaiham g s-chu aꞌamichuddam ch ab si haꞌichu ha kakke mash am aꞌaga g Jiosh oꞌohana. ");
INSERT INTO oodNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sh idam ab epai haꞌichu kakke. Kush si s-e mamachim neok ch si s-ap ab uhpam i nodgid g haꞌichu ha-kakkei. Sh wehsijj hegam mash kah ab wabsh i hahaꞌadka si has i e tahtk. ");
INSERT INTO oodNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Neh, tsh g Joseph ch Mary hab waꞌap si has i e taht am chehgiok. Sh g jeꞌej hab kaij, “Ni-sulijga, shahchu apt ahgk hab t-juh? Shelkam att nonda g m-ohg wehm pi m-edgidk.” ");
INSERT INTO oodNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kush hab kaij ab ha wui, “Chum am wa s-mahch mant hemho wa am wo haꞌichugk ni-ohg Jiosh kih ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sh eda pi shaꞌi amichud mo haschu ahgch hab kaij. ");
INSERT INTO oodNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kutsh gam hu hahawa uhpam hih ha wehm Nazareth wui k ab ha wechokahim. Sh g jeꞌej pi hekid shaꞌi pi chegito ihda matsh has e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Neh, kutsh ab si s-gegokam i geꞌehogatahi g Jesus k baꞌich i edagi g amichudadag k ash am si oid g Jiosh chehanig. Kush ab si s-hoꞌigeꞌid g Jiosh. Sh g hemajkam ab si has elid. ");
INSERT INTO oodNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Tsh am hebai i cheka. Kush am daha ihda John mo d Zacariabad alidag am tohono jewed ch ed. Sh wenog am hema d si uhgchu lai wehs ha dahm g jejewed ch hab chehgig Tiberius. Kush am hema ep d kownal Judea chekshani t am ch hab chehgig Pilate. Kush g Herodbad aꞌalidag hab waꞌap d kokownal. Hema ash hab waꞌap chehgig Herod ch ash am d kownal Galilee chekshani ch ed k ch hema hab chehgig Philip ch am d kownal Iturea ch ed ch Traconitis ch ed. Sh g Lisanias am d kownal Abelene ch ed. Kush iaꞌi idani hegam am d si uꞌugchu ha‑papalig g Tutuligo mash hema hab chehgig Annas ch hema hab chehgig Caiaphas. Tsh g Jiosh ab mah g John g haꞌichu e‑ahga mash eda hegai Tiberius am waꞌi daha gamai hetasp aꞌahid ab. ");
INSERT INTO oodNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Sh g John an wehsko ahgachug g Jiosh haꞌichu ahga anai Jordan akimel woꞌoshani ed hab ha ahgch, “Gam g hu wo s‑ohhod g pi ap e‑chegitoi k wo e pahl wapko. Tsh g Jiosh gam hu hab wo i juh g pi ap em‑chuꞌijig.” ");
INSERT INTO oodNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Batsh wa e juh hab masma matki an heki hu oꞌoha hegai kelibad Jiosh haꞌichu i tashogiddam mash hab chehgig Isaiah. K hab chuꞌig g oꞌohanaj: Hema atsh gam hu jeg ed wo ha mihshmad g hemajkam hab kaijch, “Neh, in atsh wo i wuhsh jewed dahm hegai mo d ge kownal wehs haꞌichu dahm. Kumt heg wehhejed wo i e nako hab sha masma mamt am wo i apꞌech g pad wohg mat am oidk wo i hih g geꞌe kownal. ");
INSERT INTO oodNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nat hig pi am wo i e apꞌech g wohg mo hebai pi apkodag mat hekid wo jiwia g geꞌe kownal? Pegih, mt am hab waꞌap wo i apꞌech g e‑doakag am e doꞌibiak. ");
INSERT INTO oodNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","T hab wehs wo nei g hemajkam mat has masma wo chum ha doꞌibia g Jiosh.” Neh, batki masma an oꞌoha g Isaiabad. Kush g John woho hab masma hab e wua. ");
INSERT INTO oodNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","8","Tsh muꞌi am wui e chehm g hemajkam matsh ab ab wo e pahl wapko. Haꞌi idam o pi am hu gawul junimk g pi ap e‑chegitoi. Kush hab ha ahg g John, “Hah, ahpim mam pi ap chegitoidag, bamki e elid mamt wo e doꞌibia ab amjed g s‑koꞌok e‑namkidadag heg wabsh hekaj mam ab d Abrahambad amjedkam. Nt wabshaba wo em‑ahgi mamt pi woho wo e doꞌibia, heg hi wa mamt am wo e chehgi am hab junihidch g s‑apꞌekam mamt gam hu s‑ohhod g pi ap e‑chegitoi. Wehs hegam mat gam hu wo s‑ohhod g pi ap e‑chegitoi at d wo Jiosh hemajkamgak ch hab masma wo e kuint mo d Abrahambad amjedkam, chum wa g nahnko mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kumt ahpim gam hu wo s‑e ohhod hab masma mat g pi kehg bahidkam uꞌus mamtp pi gam hu wo s‑ohhod g pi ap e‑chegitoi k pi am hu hab wo junihid g s‑apꞌekam.” ");
INSERT INTO oodNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kush haꞌi g hemajkam ab kakke, “Pegih, tt has hig wo chum t‑juh?” ");
INSERT INTO oodNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kush hab kaij ab ha wui, “Mt am wo i apꞌech g e‑chegitoi Jiosh wui k amjed pi wo daꞌi g e‑eniga. Neh, tp hems hema pi wo ha kotonik. Kumt ab wo hema mah. Tp hems hema pi wo haꞌichu chekk. Mt ab wo mah g haꞌichu hugi.” Neh, bash kaij g John. ");
INSERT INTO oodNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kush haꞌi hegam matsh am wui dada k wo e pahl wapko d lial ha kowlantdam am kownal wehhejed ch ash ab kakke, “T‑mashchamdam, tt ahchim has wo chum masmak?” ");
INSERT INTO oodNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kush hab ha ahg, “Pi amt gamai hu wabsh baꞌich i muꞌi wo ha kowlant mo heꞌekkia i mohtoꞌis g oꞌodham.” ");
INSERT INTO oodNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kush haꞌi d shondal ch ab epai kakke, “Tt ahchim has wo chum masmak?” Sh hab ha ahg, “Pi g hekid haꞌichu wo shaꞌi ha wohppoꞌidad ch pi ab hu hema haꞌichu wo shaꞌi abch mat pi wo wohok ch ehp mamt wabsh wo s‑ap e tahtkk ch ab uꞌu mam heꞌekkia i em‑namkid.” ");
INSERT INTO oodNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kush g hemajkam pi am hu dodolimad am oidahimch mas hu id d Jiosh si Kehsha matsh wo ha doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kush heg hekaj hab kaij g John, “Pi g hab wo ni‑elid manis ahni d si haꞌichu. Ab at hema wo i wuhsh ni‑oidk mat d wo si haꞌichuk. Ahni ani hi wa em‑pahl wapkon. T wabshaba heg ab wo em‑mah g Hekia S‑apꞌekam Gewkdag k gam hu hab wo i juh pi em‑apꞌekam hab sha masma mat g mehi wo mei g shaꞌi. ");
INSERT INTO oodNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Nam hig pi nehnichud g pilkani mamt g mohgaj gam hu wo i gawulkad k wo mehid k g pilkani ged hu wo i baꞌiha. Pegih, t hab waꞌap am aꞌai wo i ha gawulkai g hemajkam am lodaita ch ed ihda mani em‑ahgid k wo ha doꞌibia g s‑apꞌekam k g pi apꞌekam s‑koꞌokam wo ha namkid. T g ha namkidadag pi hekid wo huhug.” ");
INSERT INTO oodNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Neh, bash kaij g John ch nahnko masma am i chum ha tashogid g hemajkam g s‑kehg haꞌichu ahgaj g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sh eda hegai kownal mash hab chehgig Herod geꞌe hab junihim g pi apꞌekam ch atsh g e‑wehnag ehs g hohnigaj. Sh hab chehgig hegai Herodias. Kush g John ab s‑kehꞌid g kownal ch hab kaij mat pi hab wo chum e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tsh g Herod am baꞌich i pi ap haꞌichu hab juh matsh ged hu si kuh g John. ");
INSERT INTO oodNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tsh wabshaba koi e kuh g John k wehs ha pahl wapko hegam matsh am wui e chehm ab s‑wohochudch g Jiosh. Tsh g Jesus hab waꞌap am wui jiwia k e pahl wakon k am e hoꞌigeꞌidahun. Tsh g dahm kahchim gam i e kuhpiꞌo. ");
INSERT INTO oodNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kutsh g Hekia S‑apꞌekam Gewkdag i hud ab ab g Jesus k hab sha mahs mo g hohhi. Sh ab neok g Jiosh ab dahm kahchim t amjed ch hab kaij ab wui g Jesus, “Ahpi ap d si ni‑tatchuidch ni‑alidag ch am si ni‑tatchui oidch hab masma.” ");
INSERT INTO oodNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus ash am hu d i waikko wehst‑mahm aꞌahidag matsh eda am i himch g e‑chikpan k am i ahgahi g Jiosh haꞌichu ahga. Kush idam d shohshonaj mant g ha‑chechgig an wo ha oꞌoha. Bash masma s‑e mahch mo d Josephbad alidag. Sh g Joseph ab d Heli amjedkam. ");
INSERT INTO oodNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Kush g Heli ohgbad Matthat. Sh g Matthat ohgbad d Levi. Sh g Levi ohgbad d Melchi. Sh g Melchi ohgbad d Jannai. Sh g Jannai ohgbad d Joseph. ");
INSERT INTO oodNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Sh g Joseph ohgbad d Mattathias. Sh g Mattathias ohgbad d Amos. Sh g Amos ohgbad d Nahum. Sh g Nahum ohgbad d Esli. Sh g Esli ohgbad d Naggai. ");
INSERT INTO oodNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Sh g Naggai ohgbad d Maad. Sh g Maad ohgbad d Mattathias. Sh g Mattathias ohgbad d Semein. Sh g Semein ohgbad d Josech. Sh g Josech ohgbad d Joda. ");
INSERT INTO oodNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sh g Joda ohgbad d Joanan. Sh g Joanan ohgbad d Resa. Sh g Resa ohgbad d Zerubbabel. Sh g Zerubbabel ohgbad d Shealtiel. Sh g Shealtiel ohgbad d Neri. ");
INSERT INTO oodNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Sh g Neri ohgbad d Melchi. Sh g Melchi ohgbad d Addi. Sh g Addi ohgbad d Cosam. Sh g Cosam ohgbad d Elmadam. Sh g Elmadam ohgbad d Er. ");
INSERT INTO oodNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Sh g Er ohgbad d Joshua. Sh g Joshua ohgbad d Eliezer. Sh g Eliezer ohgbad d Jorim. Sh g Jorim ohgbad d Matthat. Sh g Matthat ohgbad d Levi. ");
INSERT INTO oodNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Sh g Levi ohgbad d Simeon. Sh g Simeon ohgbad d Judah. Sh g Judah ohgbad d Joseph. Sh g Joseph ohgbad d Jonam. Sh g Jonam ohgbad d Eliakim. ");
INSERT INTO oodNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Sh g Eliakim ohgbad d Melea. Sh g Melea ohgbad d Menna. Sh g Menna ohgbad d Mattatha. Sh g Mattatha ohgbad d Nathan. Sh g Nathan ohgbad d David. ");
INSERT INTO oodNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Sh g David ohgbad d Jesse. Sh g Jesse ohgbad d Obed. Sh g Obed ohgbad d Boaz. Sh g Boaz ohgbad d Shela. Sh g Shela ohgbad d Nashon. ");
INSERT INTO oodNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Sh g Nashon ohgbad d Amminadab. Sh g Amminadab ohgbad d Admin. Sh g Admin ohgbad d Arni. Sh g Arni ohgbad d Hezron. Sh g Hezron ohgbad d Perez. Sh g Perez ohgbad d Judah. ");
INSERT INTO oodNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Sh g Judah ohgbad d Jacob. Sh g Jacob ohgbad d Isaac. Sh g Isaac ohgbad d Abraham. Sh g Abraham ohgbad d Terah. Sh g Terah ohgbad d Nahor. ");
INSERT INTO oodNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Sh g Nahor ohgbad d Serug. Sh g Serug ohgbad d Reu. Sh g Reu ohgbad d Peleg. Sh g Peleg ohgbad d Eber. Sh g Eber ohgbad d Shelah. ");
INSERT INTO oodNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sh g Shelah ohgbad d Cainan. Sh g Cainan ohgbad d Arphaxad. Sh g Arphaxad ohgbad d Shem. Sh g Shem ohgbad d Noah. Sh g Noah ohgbad d Lamec. ");
INSERT INTO oodNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Sh g Lamec ohgbad d Methusela. Sh g Methusela ohgbad d Enoc. Sh g Enoc ohgbad d Jared. Sh g Jared ohgbad d Mahalaleel. Sh g Mahalaleel ohgbad d Cainan. ");
INSERT INTO oodNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Sh g Cainan ohgbad d Enos. Sh g Enos ohgbad d Seth. Sh g Seth ohgbad d Adam. Sh g Adambad d amjedkamaj g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus atsh gam hu hih ab amjed g Jordan akimel matsh hebai e pahl wako. Kush g Hekia S‑apꞌekam Gewkdag ab mahkch g si geꞌe gewkdag ch hab ahg mat gam hu wo hih am tohono jewed wui. ");
INSERT INTO oodNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kush am haꞌichugkahim giꞌikko wehst‑mahm tash ab. Sh heg oidam g jijawul ha‑geꞌejig am chum s‑wuimk pi apꞌekam ch ed. Jesus ash pi haꞌichu koꞌa heg oidam ch hekaj bihugim. ");
INSERT INTO oodNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sh g ge Jiawul ab wui hab kaij, “Bap chum e elid map d Jiosh alidag. Pegih, ab g hig chehani ihda hodai mat wo e pahnch naptki pi bihugim.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kush hab kaij g Jesus, “Pi ant hab wo juh. An o hab chuꞌig Jiosh oꞌohana ed: Jiosh neꞌoki o baꞌich d i si haꞌichu mo hi g haꞌichu hugi. Kut g oꞌodham hemho ab wo wa s‑wohog elidad.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Neh, tsh g Jiawul am hahawa shaꞌi si s‑hohtam wuhpuij tahgio wehs i mahsid g kokownaltalig id dahm jewed ");
INSERT INTO oodNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","k ab wui hab ep kaij, “Wehs o ab ni‑mahks ihda gewkdag ch kaisdag ch d ni‑eniga mant wo wa mah mani hedai hab i elid. Kunt wehs ab wo m‑mah mapt ab ni‑wui wo i gehsh k ab wo has ni‑el.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kush hab kaij g Jesus, “Pi ant hab wo juh. An o hab chuꞌig Jiosh oꞌohana ed: Heg amt waꞌi Jiosh ab wui wo i gehsh k ab wo ihmad ch heg ab wo waꞌi s‑wohog elidad.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kutsh am hahawa wuhpuij tahgio i mahsid hegai geꞌe cheopi mo am kehk Jerusalem t ab k hab ahg, “Maptp d wo Jiosh alidagk, pegih, am g i dahꞌi amjed mo gan hu si uhgk kihtas. ");
INSERT INTO oodNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","No hig pi an hab chuꞌig Jiosh oꞌohana ed: Jiosh at ab wo ha cheha g muꞌi anghil mat wo m‑nuhkud. ");
INSERT INTO oodNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kut an hu wo si m‑uꞌukchid mapt nih g shaꞌi e‑tahtad ab hu wo shul hohodai t ab.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sh hab kaij g Jesus ab wui, “Pi ant wo pipꞌich g Jiosh. An o hab chuꞌig oꞌohanaj ed: Pi g wo shaꞌi pipꞌichudad g e‑kownalig Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kush g Jiawul am hahawa sha dagito g Jesus am i wehs nahnko masma chum s‑wuimkk pi apꞌekam ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tsh gam hu hahawa hih g Jesus Galilee chekshani wui. Sh g Hekia S‑apꞌekam Gewkdag si geꞌe mahkch g gewkdag. Tsh gam hu aꞌai s‑e mai g haꞌichu ahga ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kush am ha mashcham ha eꞌeda g ha‑chechopi. Sh wehsijj ab si has elid g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kush am him k am hekid. Tsh gam hu hih g Jesus Nazareth kihhim wui mash wa am d si kihkam. Tsh g shahwai am i e ai. Kutsh am i e chehm g hemajkam cheopi ch ed nash pi eda e mihshmad. Tsh am jiwia g Jesus k am dahiwua hab masma mash wa chum hekid am hab e junihim. Kumtsh am hiwigi. Tsh am kekiwua matsh wo neꞌokchul g Jiosh heki hu oꞌohana. ");
INSERT INTO oodNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kumtsh ab hema mah g holiwk oꞌohana. Sh d oꞌohanaj g Isaiabad. Tsh an neꞌokchul mo an hab chuꞌig matsh g Jiosh si Kehsha hab wo chei: ");
INSERT INTO oodNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Jiosh at am i ni‑kei mant am wo ha ahgidahid g shoꞌigkam g s‑kehg haꞌichu ahgaj. K heg hekaj am ni‑wehmaj g Hekia S‑apꞌekam Gewkdag ch ab ni‑mahkch g si geꞌe gewkdag. K ab ni‑chehani g Jiosh mant am wo ha ahgidahid g doꞌibiadag hegam mo haꞌichukaj e wupulshch ch wo ha nench g pi neneadam k ab wo i ha wuwhas hegam mo haꞌichukaj e kudut ");
INSERT INTO oodNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","k wo ahgachug mat e ai mat g Jiosh wo ha doꞌibia g e‑hemajkamga. ");
INSERT INTO oodNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tsh g Jesus ab i holiwkai g oꞌohana k ab uhpam mah g nuhkuddam k am hahawa dahiwua mat haꞌichu hab wo chei. Sh wehsijj ab si kaiham mat has wo chei. ");
INSERT INTO oodNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kutsh am i neok k hab kaij ab ha wui, “Neh, hemu at e ai. Ni ahni hab wua ihda mant am neꞌokchul em‑wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tsh wehsijj ab si has i el no pi si s‑ap neok k wabshaba hab kaij, “Aha no hig pi woho d Josephbad alidag?” ");
INSERT INTO oodNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Sh hab kaij g Jesus, “No hig pi woho mamt ab ni‑wui hab wo chei hegai hab ha‑cheꞌidag mo hab chuꞌig, Am g i e maskogid maptp d ge mahkai, k hab ep wo chei, Ia g hu hig hab ep juhni g s‑hasig haꞌichu e‑kih am mapsh has masma am hab ge junihim Capernaum kihhim t am.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sh hab ep kaij g Jesus, “Mo wa woho mam pi ab hu has elid g Jiosh haꞌichu i tashogiddam amai mo hebai d i si kihkam. ");
INSERT INTO oodNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Elijabad wehm oꞌodham ash wa hab masma pi ab hu has elid. Tsh heg hekaj pi am hu hema i wehmt matsh eda pi ha juh waik eda hugkam aꞌahid ab. Tsh g bihugig i gei. Muꞌij ash g heheꞌejel wiꞌikam uꞌuwi amai. ");
INSERT INTO oodNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tsh wabshaba g Jiosh am cheha g Elijabad matsh am wo hih Seraphath kihhim wui am Sidon jewed ch ed k am wo hema i wehmt g hejel wiꞌikam uwi amai. ");
INSERT INTO oodNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kush muꞌi kokꞌo g Tutuligo heg hekaj pi ha doddakam mumkidag mo hab e aꞌaga ‘leprosy’. Tsh eda pi hema shaꞌi ha doaj hegai kelibad Jiosh haꞌichu i tashogiddam mash hab chehgig Elisha. Sh hema heg hekaj mumku g gawul mahs oꞌodham ch hab chehgig Naaman ch am kih Syria jewed ch ed. Kutsh heg waꞌi doaj g Elishabad.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tsh wehsijj hegam mash am haꞌichug cheopi ch ed si babgat am i kaiok ihda ");
INSERT INTO oodNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","k atsh gam si neꞌiopa k am i chewaim g Jesus gam hu jegko. K eda g Nazareth an kehk kawulk t ab. Kutsh am i bei mo am hu hebai ge uhgk i koa g kawulk hab chum ahgk mat amjed wo i daꞌich. ");
INSERT INTO oodNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tsh wabshaba g Jesus am wabsh ha shahgid wuhshani k gam hu hih. ");
INSERT INTO oodNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tsh gam hu hahawa hih g Jesus Capernaum wui heg eda chekshani k am ha mashcha g hemajkam cheopi ch ed mo am d i ha‑mihshmda tash. ");
INSERT INTO oodNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kutsh wehsijj si has i el kaiok mo has masma ha mashcham no pi si s‑e mamachim neok. ");
INSERT INTO oodNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sh am hema daha mo g jiawul an uꞌukch. Kush si s‑kaidam hihnk ch hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Gam g hu hihm ahpi Jesus map ab Nazareth t ab d kihkam. A napt hab ahgk ia jiwia mapt wo t‑kokda. S‑mahch ani map hedai wud. Dap Jiosh si hekia s‑apꞌekam kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tsh g Jesus ab si chehmo g jiawul k hab kaij, “Pi g shahmuni k ab i wuhshani id amjed oꞌodham.” Tsh g jiawul am si wua hegai oꞌodham wehsijj ha tahgio k ab i wuhsh amjed k pi shaꞌi koꞌokam has juh. ");
INSERT INTO oodNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kutsh wehsijj ab si has i el g Jesus k hab kaij ab aꞌai e wui, “Shaꞌi si s‑gewkdag g neꞌokij. Ab o chehani g jijawul mat ab wo i wuwha. K wa woho hab e wua.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kutsh wehsko e kah ihda anai heg oidk jejewed. ");
INSERT INTO oodNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tsh amjed gam hu hih g Jesus heg kih wui mo hab chehgig Simon. Sh eda g hohnigaj jeꞌe ihda si mumku k ch s‑toni iajidch. Kumsh am ahgid g Jesus ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tsh am him k am i kekiwua heg woꞌikud hugid an k am e hoꞌigeꞌidahu. Tsh am ha hekaj apꞌet k am i wamig k ha hihidol. ");
INSERT INTO oodNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tsh gam hu hud g tash. Tsh wehsijj hegam mo g ha‑naipijju kokꞌo g nahnko mahs mumkidagkaj am ha uꞌapa Jesus wui. Kut wehsijj ab i ha tahtmahim k ha dodaj. ");
INSERT INTO oodNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tsh muꞌi ab wui i hihi hegam mo g jijawul an ha uꞌukch. Sh idam jijawul si hihnk ch hab kaij, “Ahpi ap d Jiosh alidag.” Kush ab si s‑ha kehꞌid g Jesus ch gam hu i ha wuwhasid ch pi ha hiwgid mas am hu has wo kaijjid no pi s‑mahch idam mo heg d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sh am hu hebai wabsh i siꞌalim, tsh g Jesus gam hu jegko i wuhsh. Tsh am i gahghi g hemajkam k am i chehg k chum pi hiwigi mat wo hih ab ha amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kush wabshaba hab kaij ab ha wui, “Hemho wa ant am wo i ahgahi g s‑kehg haꞌichu ahga ab amjed g Jiosh kownaltalig an aꞌai kihhim ch ed hab wa ehp nat pi hab ahgk i ni‑kei g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tsh wa woho am i ha mihshmdahi wehsko ha‑chechopi ed amai Galilee chekshani ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sh am hu hebai g Jesus an kehk mo an i koa hegai al kahchki mo hab chehgig Galilee Kahchki. Kutsh g hemajkam ab wabsh i shodbinidahi s‑kaimkch g Jiosh haꞌichu ahga. ");
INSERT INTO oodNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Sh neid mo gohk wapalko am wupulshpi shuhdagi ch ed. Tsh g enigakam am ha dagito k ged hu ha wapkon g e‑chuchagia. ");
INSERT INTO oodNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kutsh am i chesh g Jesus hema ha eda idam wapalko. Sh heg d Simon eniga. Sh hab ahg matsh am wo shaꞌi nuꞌichkwua shuhdagi ch ed. Tsh g Simon hab juh. Tsh ab i dahiwua g Jesus wahlko ch ed k am ha mashcha g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tsh am i haꞌasa haꞌichu ha ahgid k hab ahg ihda Simon mat am wo i himch g e‑wahlko mo am s‑juhk g shuhdagi k am wo i huduni g e‑chuchagia ha wehm g e‑wehm chikpandam. ");
INSERT INTO oodNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sh hab kaij g Simon, “T‑mashchamdam, ge att chuhug shaꞌi si chikpan k pi haꞌichu shaꞌi bei. P wabshaba am t‑ahgid matt am ep wo i huduni g t‑chuchagia. Pegih, tt am hab wo t‑juh.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kutsh wa woho am hihim k am i ha huhuds ge e‑chuchagia k atsh shaꞌi si muꞌi waptopi ha ui matsh chum alo e wanikumia g ha‑chuchagia. ");
INSERT INTO oodNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kush am haꞌi ep chikpan hema wahlko ch ed. Kumtsh idam ab hahawa si ha wai mat am wo i ha wehmt. Tsh wa woho ab i himch g e‑wahlko k wehs ha shuhshud g waptopikaj mat chum alo wachkk g ha‑wapalko. ");
INSERT INTO oodNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tsh am i nei g Simon mat haschu has i e juh k ab si i gei g e‑tohtonkaj Jesus wui k hab wabsh kaij, “Ih, dani wabsh pi apꞌekam oꞌodham. K pi hab chum mahs maps wo ni‑wehmajk ahpi s‑apꞌekam ni‑kownalig.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kutsh wehsijj hegam mash wehmaj si e totods neidch mat has e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Haꞌi hegam wehmaj chikpandam g Peter ash d James ch John ch ash d aꞌalidaj hegai mash hab chehgig Zebedee. Sh g Jesus hab kaij ab Simon wui, “Pi g am shaꞌi has e tahtkkad. Iꞌajed apt imhab g oꞌodham an wo ha uꞌud ni‑wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tsh am wabsh i chum ai g shuhdagi koa idam k am i ha wuwhas g wapalko k wehs haꞌichu am wabsh i dagito k gm hu i oi g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sh am hu hebai g Jesus am hasko kihhim ch ed oimmed. Kush am hema g oꞌodham wehsko maꞌishch hegai mumkidag mo g chuhkugaj muhkhim. Tsh am jiwia g Jesus. Kutsh heg am i chehg k ab si kupal i gei wui k hab kaij, “Ab g si i s‑ni‑hoꞌigeꞌid k i ni‑doajid pej maptp wo tatchuad.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tsh g Jesus ab tahtam k hab kaij, “Am o wa s‑apꞌe. Doajini.” Tsh am ha hekaj i doa. ");
INSERT INTO oodNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tsh g Jesus ab chehani k hab kaij, “Pi g am hedai ahgid ab amjed ihda k wabshaba am ha hekaj wo hih pahl wui. T am wo m‑chechga k wo wohokamch mapt doa. Pt am hab haha wo juh hegai iagchulida mo wa g Jiosh em‑chehani Mosesbad oꞌohana ed. T hab wo s‑mahchk g hemajkam mapt woho doa.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tsh amjed gam hu hih hegai oꞌodham. Kutsh wehsko i e ahgahi ihda matsh g Jesus hab juh. Tsh hekaj muꞌi hemajkam am wui hihi mat wo kah g haꞌichu ahgaj k wo e dodaj. ");
INSERT INTO oodNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tsh g Jesus am wo ha mihshmad k wo ha dodajid k amjed gam hu hejelko wo him k wo e hoꞌigeꞌidahu. ");
INSERT INTO oodNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sh am hu hebai ehp mash g Jesus am ha mashcham. Sh am haꞌi dadha g chehanig ha mashchamdam ch hegam mo si oid g chehanig ch hab e aꞌaga Palasi. Idam atsh ga hu aꞌaijed am dada ab amjed g Galilee chekshani ch Judea chekshani ch ab Jerusalem kihhim t amjed. Tsh g Jiosh ab si mah g gewkdag g Jesus mat wo ha dodaj g kokꞌodam. ");
INSERT INTO oodNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tsh am haꞌi dada g chechoj hema uꞌadch g pi himidkam. Id ash ab wabsh i s‑moik ch am woꞌo e‑wahkus ed. ");
INSERT INTO oodNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kush am i chum s‑wahkidamk kih ch ed matsh wo chehgi g Jesus ab si hiwigch mat wo doaj. Sh wabshaba shaꞌi si s‑hemajkamag. Kutsh pi has masma am hu wo i e wahki. Tsh heg hekaj gan hu hahawa i cheshaj kih dahm k am ge maggad g kih maꞌishpadag k amjed ab i huduni g woꞌikudaj am ha shahgid g hemajkam k am woi mash am kehk g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tsh am i nei g Jesus moki ab si hiwig idam k hab kaij ab wui ihda oꞌodham, “Ni‑nawoj, ab ani s‑m‑hoꞌigeꞌid ch gam hu hab i juh g pi ap m‑chuꞌijig.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kush hegam chehanig ha mashchamdam ch Palasi wabsh hejel hab e ahg, “Ih, shaꞌi si pi ap neok ihda oꞌodham hab masma e wepogidch g Jiosh. Heg at waꞌi Jiosh wo e nako mat gam hu hab wo i juh g pi ap ha‑chuꞌijig.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sh g Jesus s‑mahch mo haschu am oidahim ch hab kaij ab ha wui, “Pi g am wo shaꞌi oidahim manis pi woho edgid g gewkdag mant gam hu hab wo i juh g pi ap ha‑chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bam elid mo s‑pehegim hab e kaij mat gam hu hab i e juh g pi ap chuꞌijigaj no ge hedai s‑mahch mas s‑wohom hab e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pegih, nt wo em‑chehgi mani woho ge gewkdag ch hab wua mani has i kaij ahni Jiosh si Kehsha.” Neh, bash kaij ch hab hahawa kaij heg wui pi himidkam, “I g wamig k am behꞌi g e‑wahkus k hihm am uhpam.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tsh am ha hekaj i wami hegai oꞌodham k am bei g e‑wahkus k gam hu uhpam hih ab si ihmch g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tsh g hemajkam si has i elid k ab ihm g Jiosh hab kaijch, “Shaꞌi si s‑kehg haꞌichu ach neid id tashkaj.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sh hema d lial kowlantdam g kownal wehhejed ch hab chehgig Levi. Tsh g Jesus am cheh. Kush am daha heg eda kih mo am chikpan. Sh hab kaij g Jesus ab wui, “Oi g i ni‑oid.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tsh g Levi am ha hekaj i wuhshani k am wabsh i dagito wehs haꞌichu k gam hu i oi. ");
INSERT INTO oodNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","30","Am waꞌi mia amjed, tsh g Levi am hab juh g geꞌe gegosig am wehhejed g Jesus. Sh am haꞌi oiopo g Palasi mash idam haꞌi d chehanig ha mashchamdam. Sh eda muꞌijj hegam mash am ha wehm e gegosid d lial kowlantdam hab masma mo g Levi. Kush hegam Palasi am ha neid ch hekaj s‑ha kehꞌid g Jesus chuhchai hab ha ahgch, “Ih, shahchu am ahgch am ha wehm e gegosid idam pi ap hemajkam, chum hems am ha wehm g lial kowlantdam?” ");
INSERT INTO oodNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sh g Jesus hab kaij ab ha wui, “Idam pi ap hemajkam o s‑e doꞌibiamk hab masma mat g kokꞌodam wo s‑e doajidam. Hegam mo hab e elid mo s‑apꞌe at pi wo tatchua g mahkai. ");
INSERT INTO oodNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pi ant hab ahgk ia jiwia manis wo ha doꞌibia hegam mo pi e doꞌibiamk.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sh haꞌi g hemajkam hab kaij ab wui g Jesus, “Neh, muꞌikko o pi e gegosid ch wabsh e hoꞌigeꞌidahun hegam mo ab wecho e mashcham g John ch hegam mo ab ha wecho e mashcham g Palasi. Kuki wabshaba ahpi g m‑wohochuddam pi hab e wua.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sh hab kaij g Jesus ab ha wui, “Nat hig pi wo e gegos g wo ha hohntam naipijju mat eda heg am wo ha wehmajk? ");
INSERT INTO oodNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","T am wo i e ai mat pi am hu wo ha wehmajk. T am hahawa pi wo e gegos. Pegih, bat wo wa e juh idam ni‑naipijju mant hekid pi ia hu wo ha wehmajk.” ");
INSERT INTO oodNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sh am hahawa chum ha tashogid g Jesus mat g mashchamaj pi ap wo wehnad g ha‑himdag ash hab kaij, “Pi at hedai g wechij ikuskaj wo shohsho g hekiuchij lihwa mat wo s‑e wia nat pi wo i dahiwua k baꞌich wo i wantsh g hekiuchij. T hab waꞌap pi wo apꞌet g hekiuchij nat ge wo wepo mahsk g wechij ikus. ");
INSERT INTO oodNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","T pi hedai g wechij nawait am wo toa hekiuchij haꞌichu elidag kokstal ch ed. Tp hab wo sha e juh, t g wechij nawait wo wantsh g haꞌichu elidag. T g nawait wo iawua k g haꞌichu elidag wo e padch. ");
INSERT INTO oodNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Neh, hemho wa at g wechij nawait am wo e toa wechij haꞌichu elidag kokstal ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Pi o hedai tatchua mat wo ih g wechij nawait hekid ab i jehkiok g hekiuchij nawait nat pi hab wo chei mo baꞌich i s‑ap hab kahk g hekiuchij.” ");
INSERT INTO oodNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sh am hu hebai hihim idam Jesus ha mihshmda tash ed. Kush am eshas g pilkani wohg huhugid an. Sh hegam mash am wehmaj g Jesus ab ha wohni g pilkani ch i mohon g e‑nohnhoikaj ch koꞌa. ");
INSERT INTO oodNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sh haꞌi g Palasi ha neid ch hab kaij, “Shahchu am ahgch hab wua hegai mo g t‑chehanig pi t‑hiwgid machs hab wo wuad mihshmda tash ed?” ");
INSERT INTO oodNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kush hab kaij g Jesus, “Bo wabsh masma hab e wua matsh wa g Davidbad. Pi amtki chegito matsh heg has e juh am i bihugimk. Bo chuꞌig g Jiosh oꞌohana ");
INSERT INTO oodNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","matsh am i wah geꞌe cheopi ch ed k am ui g pahn k huh hegam ha wehm mash am wehmaj. Kush d hegai pahn mo am e toꞌaw k ch hegam d waꞌi ha wuikam mo d papal. T eda hemho wa am hab e juh. K heg hekaj am wa s‑apꞌe mat huh.” ");
INSERT INTO oodNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sh hab hahawa ep kaij g Jesus, “Dani Jiosh si Kehsha ch gewkdag am dahm g mihshmda tash.” ");
INSERT INTO oodNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sh am hu hebai d ep mihshmda tash. Tsh am i wahp idam Jesus hema cheopi ch ed. Kush g Jesus am ha mashcham g hemajkam. Sh am hema daha g oꞌodham mash g s‑apkojed nowij mahnikodag. ");
INSERT INTO oodNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sh am haꞌi dadha g chehanig ha mashchamdam ch Palasi ch an wa s‑nenꞌoid nash pi ab haꞌichu s‑abchudamk g Jesus ch hekaj an neid mas wo hi wa ha doaj mihshmda tash ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sh g Jesus s‑mahch mo haschu am chegito ch ash hab kaij heg wui mahnikokam, “Kekiwuani k ab i hihm ia hu ha baꞌich g hemajkam.” Tsh ab i kekiwua. ");
INSERT INTO oodNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sh g Jesus ab hahawa ha kakke ch hab kaij, “Shahchu am ahgch hab elid mo pi hiwgidas mihshmda tash ed mamt wo i ha wehmt hegam mo e shoꞌigchud? Ab o em‑ab mamt wo i ha wehmt g shoꞌigkam k ep wo ha doꞌibia hegam mat am hu wo e koꞌij. Aha namt wabsh wo ha hiwigi mat wo e koꞌij?” ");
INSERT INTO oodNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Neh, bash kaij ch an hahawa wehsijj i ha neid k hab hahawa kaij ab wui hegai oꞌodham, “Ab g si i shelin g e‑nowi.” Kutsh am wabsh i chum shelin k am waꞌi hekaj apꞌet. ");
INSERT INTO oodNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tsh hegam hahaꞌichu wabsh wohoꞌi babgat matsh ha doaj ha mihshmda tash ab k am ha hekaj i e wehm aꞌaga mas has wo juh g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tsh am waꞌi mia amjed am hu hebai gam hu i chesh g Jesus kawulk dahm k ge chuhug oidam e hoꞌigeꞌidahu Jiosh wui. ");
INSERT INTO oodNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kut am i mahsi. Tsh ab hahawa i ha wai hegam mash ab si wecho e mashcham k g gamai gohk am ha ui mat d wo si chuhchaij. ");
INSERT INTO oodNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Hema hegam ash d Simon. Kutsh heg hab ep chehch Peter mo hab d ahga ‘Hodai.’ Kush hema d Andrew ch d si wehngaj g simon. Kush haꞌi d James ch John ch Philip ch Bartholomew ");
INSERT INTO oodNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ch Matthew ch Thomas. Sh hema d hegai James mash g ohgaj hab chehgig Alphias. Sh hema hab ep chehgig Simon ch d hema hegam mash tatchua mat g Tutuligo hejel wo himchudad g e‑kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Sh hema d hegai Judas mash g ohgaj hab chehgig James. Kush hema d Judas Iscariot ch d hegai matsh wa gagda g Jesus. Neh, idam gamai gohk ash am d hahawa si chuhchaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tsh ab hahawa i huhud hegam Jesus. Sh muꞌi am ep haꞌichug g hemajkam ab amjed g Judea chekshani ch Jerusalem kihhim ch ab amjed g ge shuhdagi hugidag an miabidch g Tyre ch Sidon kihhim. ");
INSERT INTO oodNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wehsijj ash s‑kaimk g Jesus. Kush ab wui hihim g kokꞌodam ch hegam mash g jijawul an ha uꞌukch. Sh g Jesus ha dodajid ch gam hu hab i ha wua g jijawul. ");
INSERT INTO oodNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kush wehsijj ab chum s‑tahtmamk g Jesus nash pi g gewkdaj ab wuhshani amjed ch wehs ha doajid. ");
INSERT INTO oodNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tsh g Jesus ab i ha nei hegam mash ab si hiwig k hab kaij: “Mt wo chum si s‑ap e tahtkkad ahpim mam ab e shoꞌigchud Jiosh wui. Ab at wo i em‑wahpki e‑kihdag ed. ");
INSERT INTO oodNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mt wo chum si s‑ap e tahtkkad ahpim mam hemuch chum haꞌichu tatchua. B at wo wa em‑mah g Jiosh mam haschu i tatchua. Mt wo chum si s‑ap e tahtkkad ahpim mam shoani hemu no pi ab him g tash mamt wo wa si s‑hehgigk. ");
INSERT INTO oodNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","T wo s‑em‑kehꞌidad g hemajkam ch wo s‑em‑ohhod ch wo s‑koꞌokam has em‑ahgad ch hab wo chei mam d wabsh pi apꞌekam. ");
INSERT INTO oodNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mt wabsh wo s‑ap e tahtkkad ch wo s‑hehgigk id hekaj. Bash wa masma e shoꞌigchud hegam mash d kekelibad Jiosh haꞌichu i tashogiddam ch hekaj bei g Jiosh mahkigdag. T g Jiosh hab waꞌap wo em‑mah g geꞌe s‑apꞌekam mo em‑wehhejed an nuhkud e‑kihdag ed. ");
INSERT INTO oodNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","T wabshaba wo si pi ap e tahtkkad hegam mo hemu d s‑kakais no pi ab heki hu neid g s‑e‑hehgig. ");
INSERT INTO oodNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","T wo si pi ap e tahtkkad hegam mo pi haꞌichu tatchua hemuch. Ab o him g tash mat wo pi haꞌichu edgidad. T wo si pi ap e tahtkkad hegam mo s‑e tahhadchud hemuch. Ab o him g tash mat wo shoanid. ");
INSERT INTO oodNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","T wo si pi ap e tahtkkad hegam mo wehs hemajkam ab si has ha elid hemuch. Em‑shohshon ash hab masma si s‑ap has ha ahg hegam mash hab wabsh s‑e junimk mo d Jiosh haꞌichu i tashogiddam. ");
INSERT INTO oodNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nt wo em‑ahgi mamt has wo masmak am ha wui. Ab g wabsh wo i si pihk e elidad ha wui g e‑obga k wabsh g s‑ap haꞌichu hab wo ha juni hegam mo s‑em‑kehꞌid. ");
INSERT INTO oodNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Idam atp hems wo pi kehg neneokad ab em‑wui ch wo em‑shoꞌigchudad. Mt wabshaba wabsh wo si s‑hemajimak am ha wui ch wo e hoꞌigeꞌidahu am ha wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tp hems s‑koꞌokam has wo em‑juh. Mt wabshaba ab wabsh wo i s‑ha hoꞌigeꞌel. Tp hems hema ab wo em‑shonihi em‑kahm ab. Kumt wabsh wo hiwigi mat aigojed ab ep wo em‑shonihi. Tp hems hema wo em‑wohppoꞌi g em‑lihwa. Kumt g e‑kotoni ep wo mah. ");
INSERT INTO oodNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tp hems hema haꞌichu wo i em‑tai. Kumt wo mah. Kutp hems hema haꞌichu wo bei mo d em‑eniga. Kumt pi uhpam wo tai. ");
INSERT INTO oodNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bamt wo ha juhkchid g hemajkam mam has i chum ha elid mat hab wo em‑juhkchid. ");
INSERT INTO oodNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Pi at wo em‑mah g s‑ap tahhadkam g Jiosh mamtp hegam ab wo waꞌi ha tatchuad mo ab uhpam em‑tatchua. Chum o hems g pi ap hemajkam ab ha tatchua hegam mo ab uhpam ha tatchua. ");
INSERT INTO oodNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pi at wo em‑mah g s‑ap tahhadkam g Jiosh mamtp hegam waꞌi ha wehhejed hab wo juh g s‑ap haꞌichu mo s‑ap haꞌichu hab em‑junid. Chum o hems g pi ap hemajkam hab wa masma hab e wua. ");
INSERT INTO oodNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pi at wo em‑mah g s‑ap tahhadkam g Jiosh mamtp hegam waꞌi haꞌichu wo ha hiwigi mam hab ha elid mat wo wa uhpam em‑mah. Chum o hems g pi ap hemajkam hab waꞌap aꞌai haꞌichu e hiwgid hab e elidch mat ab uhpam ep wo ui haꞌakia mat heꞌekia ha hiwigi. ");
INSERT INTO oodNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Neh, mt ab wo pihk e elidad ha wui g e‑obga ch am hab wo ha junidad g s‑ap haꞌichu ch wo haꞌichu ha mah mamt pi ab hu uhpam wo ge neidad. Bamt masma am wo e chehgi mam d aꞌaligaj g Jiosh. T heg muꞌi s‑kehg haꞌichu ab wo em‑mah. Jiosh o hab wa masma s‑ha hoꞌigeꞌid g pi ap hemajkam ch hegam mo pi ab hu uhpam hoꞌigeꞌelid. ");
INSERT INTO oodNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Am g hab wo juhkchid g hoꞌigeꞌidadag hab masma mo g em‑ohg Jiosh am hab juhkch. ");
INSERT INTO oodNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Pi g am hedai s‑koꞌokam has wo ahgad o ab wo ha mohtoꞌidad g pi apꞌekam. B at uhpam wo i e nodagi ab em‑wui. Gam g hu wabsh wo pi chegito mat hema s‑koꞌokam has wo em‑juh. Kut hab wa masma gam hu wabsh wo pi e chegito mamtp hems hema s‑koꞌokam has wo juh. ");
INSERT INTO oodNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ab g wo haꞌichu ha mahkad. T g Jiosh ab haꞌichu wo em‑mahkad. Ab amt baꞌich i geꞌe wo bei mamt heꞌes ab i ha mah no pi g Jiosh baꞌich i s‑hemajima matp hems g hemajkam. Ab at wo i e nodagi em‑wui mamt has i masma ab wo neidad hema. ");
INSERT INTO oodNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","“Pi at has masma wo em‑wanimedad wohokam ch ed hegai mat hedai pi wo mahchk g wohokam. Heg at wo wa wepok matp hems hema g pi neadam haꞌi ep wo i ha wanim g pi neneadam. Kutp hems wehsijj am wo i shul hiktani ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","S‑mahch am mat g ha mashchamdam ha baꞌich wo i chum s‑mahchk hegai mo haschu i ha mashcham. E mashchamdam at am hugkam wo chum s‑mahchk g e‑mashchama am i s‑ap nahtok mo hegai mat hedai i ha mashcha. ");
INSERT INTO oodNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Pi g am wo si s‑nenꞌoidad g hema chuꞌijig. Tp hems baꞌich i geꞌej g hejel em‑chuꞌijig. T heg wo wa wepok mam g chum haꞌichu ab i s‑wuhshdamk wuhij ed mo eda baꞌich i geꞌe haꞌichu ab woꞌo em‑wuhi ed. ");
INSERT INTO oodNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Do iattogi mamtp hab wo chei mamt ab wo haꞌichu i wuhshad ha‑wuhi ed mo eda baꞌich i geꞌe haꞌichu am woꞌo em‑wuhi ed. Hemho wa amt wehpeg wo i apꞌech g pi e‑apꞌedag k haha wo e nako mamt haꞌi ep wo i ha wehmt k wo i apꞌech g pi ha‑apꞌedag. ");
INSERT INTO oodNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mt wo s‑mai mas hedai d s‑apꞌekam oꞌodham hab wa masma mamt wo s‑mai mas haschu d s‑kehg uhs. S‑kehg uhs at s‑kehg wo bahidagt ch g pi kehg uhs pi kehg wo bahidagt. ");
INSERT INTO oodNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Uhs o s‑e mahch ab e‑bahidag ab. Pi amt ab hu wo ui g suhna hoꞌi t ab o g uhdwis ab shaꞌi t ab. ");
INSERT INTO oodNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","K hab waꞌap masma g oꞌodham matp wo s‑apꞌek ch s‑kehg haꞌichu hab wo wuad o wo pi apꞌek ch pi kehg haꞌichu hab wo wuad. Matp has i masma haꞌichu chegito g oꞌodham, t hab masma wo neokad.” ");
INSERT INTO oodNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Sh hab ep kaij g Jesus, “Haꞌijj am chum hekid hab ni‑aꞌaga ‘ni‑kownalig’ ch eda pi am hu hab wua mani haschu em‑ahgid. ");
INSERT INTO oodNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ab g wo ni‑hiwgad ch ab wo s‑wohog elidad g haꞌichu ni‑ahga. T hab wo s‑apꞌek g em‑doakag. ");
INSERT INTO oodNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Id at heg wo wa wepok matp hems hema wo s‑wihnam shondad g e‑kihta. T hab pi wo i gei mat hekid wo hewed k juh k wo s‑gewkam mel g shuhdagi. Pegih, mt hab wa masma s‑wihnam wo gegokkad mo ihda kih mamtp ab wo s‑ni‑wohog elidad. ");
INSERT INTO oodNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“T wabshaba pi wo apꞌek g em‑doakag mamtp pi ab hu wo wohog ni‑elidad. Id at heg wo wa wepok matp hems hema pi wihnam wo shondad g e‑kihta. T ab wo mel g shuhdagi. T ha hekaj wo i gei g kihj k am wabsh wo i e padch. Pegih, t hab wa masma wo i e padch g em‑doakag mamtp pi ab hu wo wohog ni‑elidad.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Neh, tsh am i haꞌasa haꞌichu ha mashcha g Jesus amai k gam hu hahawa hih Capernaum wui. Kutsh g chuhchaij am wehmaj hihi. ");
INSERT INTO oodNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Kush amai am hema d shondal ha‑geꞌejig ch ab d ha‑kehsha Rome t amjed ch kah ab amjed g Jesus. Sh id pionag hema muhkhim. Kush ab si tatchua g e‑pionag ch hekaj ab ha tahni g Tutuligo ha‑geꞌegedga mat ab wo i wai g Jesus. T wo doaj g piongaj. ");
INSERT INTO oodNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tsh hegam am dada k ab si e shoꞌigch Jesus wui k hab kaij, “Am g i wehmt ihda oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ab o si t‑tatchua ahchim Tutuligo ch am hema i kei g cheopi t‑wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kutsh gam hu ha oi g Jesus k am i aihi g kihj hegai shondal ha‑geꞌejig. Tsh heg am haꞌi ha ahgi g e‑naipijju matsh am wo hihim k wo haꞌichu ahgi g Jesus. Kutsh am wui hihim k hab kaij, “Bo kaij g t‑nawoj, ‘Pi ani am hu hugkam d haꞌichu maps am wo i wah ni‑kih ed ");
INSERT INTO oodNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","o manis hejel am wo hih m‑wui. Am apt hab wabsh wo chea. T wo doa g ni‑pionag. ");
INSERT INTO oodNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","S‑amichud ani g m‑gewkdag no pi g ni‑geꞌejig gewkdag am ni‑dahm. Ni ahni hab waꞌap gewkdag am ha dahm g ni‑shondalig ch ni‑pionag. T hab wo juh mant haschu ab wo i ha chea. Ni heg hekaj s‑mahch mat am hab wo e juh mapt haschu am hab wabsh wo i chei.’ Neh, bo kaij.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tsh g Jesus ab si has i el ab kaiok ihda. Sh muꞌi hemajkam an oidahim. Kush ab ha wui hab kaij, “Pi ani koi hebai shaꞌi neid mas hema haꞌas geꞌe ab si ni‑hiwig, chum hems am ha shahgid g Tutuligo,” k am hahawa ha chea hegam mat ab dada mat g m hu uhpam wo hihi. ");
INSERT INTO oodNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tsh am uhpam dada k chum nei. Kutsh doa g piongaj g shondal ha‑geꞌejig. ");
INSERT INTO oodNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kush am baꞌich d i tash. Tsh gam hu hihi hegam Jesus heg wui kihhim mash d Nain. Kutsh muꞌi hemajkam ha oi. ");
INSERT INTO oodNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tsh am wabsh i chum dada mo ab kihjeg g kolhai an wehgaj g kihhim. Sh ab g muhki e uꞌa. Sh g jeꞌej g muhki d hejel wiꞌikam. K id d si hemako madaj. Kush muꞌi ha wehmaj g hemajkam ab kihhim t amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kutsh am i nei g Jesus ihda uwi k si pi ap e taht wehhejed k hab wabsh kaij ab wui, “Pi g am shoakad,” ");
INSERT INTO oodNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","k ch amjed am him k an taht hegai mo an ab woꞌichug g muhki. Tsh ha hekaj gegokiwua hegam mo uꞌa. Kush hab hahawa kaij g Jesus, “Wechij oꞌodham, ab g i wamigi.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tsh am ha hekaj i dahiwua ihda oꞌodham k ab ha hekaj wabsh neok. Tsh g Jesus am wamgid k hab ah mat gam hu wo i oi g e‑jeꞌe. ");
INSERT INTO oodNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kutsh wehsijj si e totodsid k ab si ihm g Jiosh ch hab kaij, “Ia atki hema jiwia t‑shahgid g Jiosh haꞌichu i tashogiddam,” ch haꞌi hab ep kaij, “Jiosh atki ia jiwia t‑shahgid mat wo t‑doꞌibia mattp hedai d hemajkamgaj.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kutsh ihda mat haschu has e juh an wehsko e aꞌaga Judea chekshani oidk ch an wehgaj. ");
INSERT INTO oodNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sh eda ged hu e kuhpach hegai John mash am ha pahl wapkonahim g hemajkam. Kush am ahgid hegam mash ab si wecho e mashchamahim mash haschu has junihim g Jesus. Tsh heg gohk ab i ha waid ");
INSERT INTO oodNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","k am ha cheha mat am wo hihim k ab wo kakke g Jesus mas wa woho d Jiosh si Kehsha aha nat ab hahawa hema wo i wuhsh mat d wo hegaik? ");
INSERT INTO oodNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tsh idam am dada Jesus wui k hab kaij, “Ab o t‑chehani g John matt ab wo m‑kakke maps woho d Jiosh si Kehsha aha nat ab hahawa hema wo i wuhsh mat d wo hegaik?” ");
INSERT INTO oodNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tsh g Jesus heg i tashkaj muꞌi ha dodaj g kokꞌodam k muꞌi ha wuwhas g jijawul ab ha amjed hegam mo an ha uꞌukch k ha‑nench g pi neneadam. Kush heg wehs neid idam John chuhchai. ");
INSERT INTO oodNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sh hab hahawa ha ahg g Jesus, “Am g uhpam wo hihim k wo ahgi g John mam haschu i neid ch haschu i kah. Ha ani dodajid g pi ha dodajidam kokꞌodam ch pi neneadam ch pi hihimidkam ch pi chechkaidkam ch ha chechegitoichud g koꞌi ch am ha ahgid g shoꞌigkam mat g Jiosh wo ha doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","T g Jiosh ab wo s‑em‑hoꞌigeꞌidad mamtp hedai ab wabsh wo ni‑hiwgad ch pi wo ni‑dagito.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tsh am i gam hu hihi hegam John chuhchai. Sh g Jesus am haꞌichu ha ahgid g hemajkam ab amjed g John ch hab kaij, “Neh, am amt wa hihim k ab kaiha g John. K wa eda am oimmelhim pi apkokam jewed ch ed. Kumt pi woho am hu wo i wuwha wui matp d wabsh s‑pehegi oꞌodham ch am gawul wo wuad g e‑neꞌoki. Pi o an aꞌai e wanchkwua g John. ");
INSERT INTO oodNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kumt pi hema s‑neidam mo s‑kakaisim e enigadadch. Hegam mo hab masma e enigadadch o si s‑kakaisim kih. ");
INSERT INTO oodNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Neh, heg amt s‑kaim Jiosh haꞌichu i tashogiddam k heg wa woho kah. K g John am baꞌich haꞌichu k ed ep kehk ");
INSERT INTO oodNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","no pi d hegai mo ab amjed an oꞌohanas mo g Jiosh hab ahg ch hab kaij: Am ant hema wo i maskogi mat am wo i ha apꞌech g hemajkam am wehhejed g si ni‑Kehsha jiwhiadag am jewed dahm. Neh, bash kaij g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Kunt wo em‑ahgi mo g John wehs hemajkam ha baꞌich d i si haꞌichu am hugkam mat am i wuhsh g Jiosh kownaltalig id dahm jewed. T hahawa chum hems g si pi haꞌichukam hemajkam am Jiosh kownaltalig ed baꞌich d wo i s‑has haꞌichuk mo hegai John.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Neh, bash kaij g Jesus. Kutsh wehs ab kaiha hegam mat ab s‑wohog el g Jiosh k am e pahl wapko ab John wecho, chum hems hegam mo g lial ha kowlant g kownal wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tsh wabshaba pi ab hu wohog el g Jiosh tatchui pi e pahl wapkonk hegam mo d Palasi ch hegam mo d chehanig ha mashchamdam. ");
INSERT INTO oodNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kush heg hekaj hab kaij g Jesus, “Bo masma pi ta wepoma mo g aꞌal hegam mat pi ab hu wohog el g John k pi ab hu ni‑bei. ");
INSERT INTO oodNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Neh, tp hems am wo chichwid g aꞌal ch hab wo chei, ‘Am att em‑gehged g e hohontam ha‑piastakaj. Kumt pi e waila. Am att nei g muhki neꞌi. Kumt pi shaꞌi shoshani.’ ");
INSERT INTO oodNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Id ani hab ahg mat g John ab i wuhshani k pi ihꞌe g nawait ch muꞌikko pi e gegosid ab e hoꞌigeꞌidahunch Jiosh wui. K muꞌijj hab kaij mo g jiawul an uꞌukch g chegitoidaj. ");
INSERT INTO oodNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nt ahni ia jiwia Jiosh si Kehsha k wabsh chum hedai ha wehm ni‑gegosid. K muꞌijj hab kaij mani s‑banma ch s‑iꞌidag ch d ha‑nawoj g s‑ta kekeꞌidamakam lial ha kowlantdam ch hegam mo pi ap oid g t‑shohshon ha‑chehanig. Neh, bo masma pi ta wepoma ");
INSERT INTO oodNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ch im hu hab wabsh i juh g Jiosh amichudadag. K wabshaba hegam mo ab s‑wohochud am chehgidch mo d wohokam.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tsh hema g Palasi ab i wai g Jesus mat am wo wehmaj e gegos. Tsh am hih g Jesus kihj wui k am i dahiwua mat wo e gegos. ");
INSERT INTO oodNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kush eda am hema d uwi heg eda kihhim ch si pi ap d hemajkam. Sh am dak ch e gegosid g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tsh id am jiwia k am wehgaj i kekiwua am uꞌadch g s‑ap uhw shuhdagi al s‑toa hodai haꞌa ch ed. Sh eda am e shelinch g Jesus mo hab masma dadhaiwup ch e gegosid. K si shoak ihda uwi. Kush g ohꞌogaj an iawua tahtadaj an. Kutsh an i dagio g cheꞌechew e‑moꞌokaj k an si ha chintad k an hahawa iawua ga s‑ap uhw shuhdagi tahtadaj ab. ");
INSERT INTO oodNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kush hab wabsh hejel e ahg hegai kihkam, “T wo chum s‑mahchk mo si pi ap d uwi ihda matp woho d wo Jiosh haꞌichu i tashogiddamk ch pi wo hiwigi mas an wo taht.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sh g Jesus wabsh s‑mahch mo hab masma oidahim ch ab wui hab kaij, “Simon, ab ant wo haꞌichu m‑ahgi.” Sh heg hab kaij, “Oi g ab ni‑ahgid, ha mashchamdam.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kutsh g Jesus am ahgi ihda haꞌichu wepogida e‑ahga k hab kaij, “Matp hema ab wo e wulshch g hetasp siant pihsh heg ab mo g lial ha hiwgid ch hema ab ab wo e wulshch g hetaspo wehst‑mahm pihsh ");
INSERT INTO oodNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","k pi wo e nako mat wo uhpam namkid. Kut im hu hab wo i juh g ha‑wulshpadag. Neh, t hedai idam baꞌich ab wo i si tatchua?” ");
INSERT INTO oodNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sh hab kaij g Simon, “Naꞌas hegai mamt baꞌich i muꞌi im hu hab i juh g wulshpadaj.” Sh hab kaij g Jesus, “Pegih, ");
INSERT INTO oodNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ab g neid ihda uwi. Ia ant jiwia m‑kih am. Kupt pi ni‑mah g shuhdagi mant wo i wapko g ni‑tahtad. T wabshaba ihda am i wapko g ni‑tahtad g e‑ohꞌogkaj k am i ha dagio g cheꞌechew e‑moꞌokaj. ");
INSERT INTO oodNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Pi apt ab hu ni‑chintad mant ia jiwia. K wabshaba id g ni‑tahtad chintad. ");
INSERT INTO oodNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Pi apt ab hu i huhu g ni‑moꞌo. T wabshaba id g uhw shuhdagi an iawua ni‑tahtad an. ");
INSERT INTO oodNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Neh, nt hab wo chei mat am geꞌe chehgi mo ab si ni‑tatchua. T heg am wohokamch mat g muꞌi pi ap chuꞌijigaj im hu hab i e juh. Hegai mam hedai pi shaꞌi geꞌe im hu hab i wua g ha‑chuꞌijig o pi shaꞌi geꞌe am hu chehgid g e‑tatchuidag.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sh hab hahawa kaij g Jesus heg wui uwi, “Im ant hu hab i juh g pi ap m‑chuꞌijig.” ");
INSERT INTO oodNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","K hegam haꞌi mo ab dadha mihsa wui hab kaij ab aꞌai e wui, “K hedai e elid ihda ch im hu hab i chum wua g pi ap ha‑chuꞌijig?” ");
INSERT INTO oodNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sh hab kaij g Jesus id wui uwi, “Ab ap ni‑hiwig ch hekaj e doꞌibia. Gamai g s‑ap e tahtk hihm.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Sh amjed am hu hebai, tsh g Jesus am hih ha oidk g kihhim k am ahgahim g s‑kehg haꞌichu ahga ab amjed g Jiosh kownaltalig. Kush hegam gamai gohk chuhchaij am wehmaj. ");
INSERT INTO oodNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kutsh muꞌi am ha oi g uꞌuwi. Idam atsh wa ha dodaj g Jesus. Kush am haꞌichukaj i ha wehmt. Hema idam ash d Mary Magdalene. Id atsh g Jesus ab amjed i ha wuwhas g wewaꞌak jijawul. ");
INSERT INTO oodNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kush hema d Joanna. Sh g wehmaj kihkam ihda hab chehgig Chusa ch d haꞌichu am kownal wecho. Kush hema ehp d Susanna. Tsh idam uꞌuwi wo em‑nolawt hegai mash haschu i tatchua hegam Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kutsh muꞌi hemajkam ab hihi Jesus wui ga hu aꞌai kihhim amjed. Tsh am ha ahgi g Jesus ihda wepogida ahga: ");
INSERT INTO oodNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nt wo haꞌichu em‑mashcha ab amjed g Jiosh kownaltalig wepogidch mat hema an ei g haꞌichu e‑kaichka e‑oidag ed. T haꞌi gan hu wabsh shul wohg ch ed. T g hemajkam am keish k g uꞌuwhig am huh. ");
INSERT INTO oodNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","T haꞌi gan hu shul mo pi geꞌej g jewed ab waw t ab. T ab i chum wuhsh g eꞌes k wabsh gaksh no pi pi wadag amai. ");
INSERT INTO oodNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","T haꞌi gan hu shul g kaichkaj shaꞌi ch ed. T heg am wabsh wehnadk i geꞌege k ha kokda g esha. ");
INSERT INTO oodNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","T wabshaba hegam mat an s‑ap shul moihuna ch ed an wuhshani k siant ab kait hehemako.” Sh hab hahawa ep kaij g Jesus, “Neh, am g wo i aꞌamichud ahpim mam kah ihda.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kush g Jesus chuhchai ab kakke mas has d ahga ihda wepogida ahga. ");
INSERT INTO oodNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Sh hab kaij g Jesus, “Nt wo em‑ahgi mo has d ahga no pi g Jiosh em‑hiwgid mamt wo s‑mai hegai mo haschu hemu am maskogid ab amjed g e‑kownaltalig. Ni wabshaba heg waꞌi ha ahgid haꞌichu wepogida ahga hegam mo pi ab hu wohochudamk. T hab pi wo amich haꞌichu ab amjed g Jiosh kownaltalig, chum as wo haꞌichu neid k wo haꞌichu kah.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kush hab ep kaij g Jesus, “Neh, nt wo em‑tashogi ihda haꞌichu wepogida ni‑ahga. Jiosh haꞌichu ahga o wepogidas mo g haꞌichu kai ch am wo e gantad hemajkam ha‑iꞌibdag ed. ");
INSERT INTO oodNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","K eda haꞌi g ha‑iꞌibdag s‑kawpk hab masma mo g wohg. K g Jiawul am wabsh s‑pehegi ha wohppoꞌid hegai mo haschu i kah. T hab pi ab hu wo wohoch g Jiosh haꞌichu ahga k pi wo e doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“K haꞌi g ha‑iꞌibdag hab sha masma mo hebai pi geꞌej g jewed ab waw t ab. T idam wo si s‑hohhoꞌi g Jiosh haꞌichu ahga ab kaiok k wabshaba pi wihnam ab hu wo bebhe k ch ab hi wa al heꞌes wo s‑wohochudad. T ab wabsh wo i chum hih g aꞌappema. T ha hekaj wabsh wo taꞌi i shul. ");
INSERT INTO oodNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“K haꞌi g ha‑iꞌibdag hab sha masma mo hebai s‑shaꞌig no pi e shaꞌijidch heg hekaj kudutadag ch s‑kaisdag ch s‑tahhadkam. Kut pi haꞌichu hab wo juh am Jiosh wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“K haꞌi g ha‑iꞌibdag s‑moik hab masma mo g moihuna. Kut ab wo kaiha g Jiosh haꞌichu ahga k am wo si i nuhkud e‑ihbdag ed k am wo e nako mat am hab haꞌichu wo juh Jiosh wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Wohokam o wepogidas mo g lahmpa tonlig. Namt hig wo ehsto g lahmpa ab mehidk aha namt an wo dai mat hebai wo em‑tonlidch. Pegih, mt hab wa masma pi wo chum ehsto g wohokam. ");
INSERT INTO oodNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wehs at wo s‑e mai matp haschu chum e ehstokch. T haschu wo i chum e maꞌishchid wo e chehg k am wo i e wuhshad. ");
INSERT INTO oodNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Am g wo s‑amichud mam haschu i kah. Hegam mat s‑ap wo hekaj g e‑apꞌedag at baꞌich ep wo i nei. T wabshaba hegam mat pi ap wo hekaj wabsh wo heb hu wua.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tsh am chum dada g Jesus jeꞌe ch wepngaj. Sh wabshaba si muꞌij g hemajkam an wehgaj. Kutsh pi e nako matsh ab wo miabi. ");
INSERT INTO oodNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sh hema hab kaij ab wui g Jesus, “M‑jeꞌe ch m‑wepnag o am gegok jeg ed s‑m‑neidamkch.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sh hab ahg g Jesus, “Neh, idam mo ab ni‑kaiham ch ab s‑wohog elid g Jiosh haꞌichu ahga o heg wa wepo mo d ni‑jeꞌe ch ni‑wepnag.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sh am hu hebai hab ha ahg g Jesus g e‑chuhchai, “Am att hu hig shuhdagi aigojed wo i chehchsh.” Tsh wa woho am dadhaiwua wahlko ch ed k am gahi i shul. ");
INSERT INTO oodNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sh am hebai him g wahlko shuhdagi ch ed. Tsh g Jesus am i woꞌiwua k koi. Kutsh g hewel ab haha wabsh i meh. Tsh ab i toꞌotonkai g shuhdagi k am iawua wahlko ch ed mash s‑ta ehbidam hab mahs ha wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kutsh g chuhchaij am wui dada g Jesus k am wuhan k hab kaij, “T‑mashchamdam, ttki wo t‑koꞌij.” Tsh am i wami g Jesus k ab si cheha g hewel ch shuhdagi toꞌotonk. Tsh am i wehs haꞌasa k gam hu wabsh i pi shahmuni. ");
INSERT INTO oodNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sh hab hahawa kaij ab ha wui, “Ab g wabsh wo ni‑hiwgad.” Kutsh eda si has i elid k si s‑ehbeni k ash hab kaij ab aꞌai e wui, “Kus hedai wud ihda oꞌodham ch ab si chehani g hewel ch toꞌotonk mat wo haꞌasa. K ab s‑wohog elid.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tsh am hihim k gam hu dada ga hu aigojed g Galilee shuhdagi heg maibidch kihhim mash d Geresa. ");
INSERT INTO oodNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kush am hema oimmed g cheoj jeg ed ch am chum kih heg eda kihhim. Sh wabshaba g jijawul an uꞌukch g chegitoidaj. Kush gan hu wabsh kih mash an chehchog ch an e hihashp g koꞌi. Kutsh ab i hud g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tsh id am chehg k si s‑kaidam hihnk ch ab i meh pi haꞌichu enigadadch mash hab wa chuꞌig k ab wui i gehsh k si s‑kaidam hab kaij, “Jesus, alidaj g si uhgk Jiosh, gam g hu hihm k pi koꞌokam has ni‑juhni.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Bash kaij nash pi g Jesus ab si ha chehani g jijawul mat ab wo i wuwha amjed. Kush wa eda g jijawul muꞌikko an bebhe ihda. Kumsh gd hu chum si kukpadch ch g kakhioj ch nohnhoij g e hukshchim wapainomikaj gan hu si wupulshp. Kush wabsh ha wanikumiak g e hukshchim wapainomi. Tsh g jiawul gam hu wo i wushshad tohono jewed ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sh hab kaij g Jesus ab wui, “Shahp chehgig?” Sh hab kaij, “Bani chehgig Muꞌichu,” nash pi muꞌi jijawul an uꞌukch. ");
INSERT INTO oodNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tsh g jijawul ab si e shoꞌigch Jesus wui matsh pi am hu wo ha shul Jiawul kih ed. ");
INSERT INTO oodNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Sh eda muꞌi an oiopo g kokji kawulk bahsho ch e gegosid. Sh idam jijawul ab si tahni g Jesus matsh am wo ha dagito. Tsh am wo i wahp ha eda idam kokji. Tsh am ha hiwigi g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tsh ab i wuwha ab amjed g oꞌodham k am i wahp ha eda g kokji. Kutsh wehsijj idam kokji am agshp i wohp k gam hu shul shuhdagi ch ed k wachkk. ");
INSERT INTO oodNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tsh hegam mo am ha nuhkud gam hu uhpam wohp k am ahgahim ihda kihhim ch ed ch an ha oidk hegam mo an oꞌoidag. ");
INSERT INTO oodNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tsh g hemajkam am himto mat wo nei mat haschu has e juh. Kush ihda oꞌodham am daha Jesus wui ch ab e enigadadch ch wabsh si s‑ap haꞌichu chegito. Kutsh wabsh wohoꞌi e totods. ");
INSERT INTO oodNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kush hegam mash neid am ha ahgid mat has masma e doaj ihda oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kush wehsijj idam Geresa t am hemajkam ab ahgid g Jesus mat gam hu wo hih ab ha amjed natsh pi shaꞌi si s‑ehbeni. Tsh wa woho hab e juh k an dahiwua wahlko ch ed mat gam hu wo hih. ");
INSERT INTO oodNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kutsh hegai oꞌodham matsh ab i wuwha g jijawul amjed ab si e shoꞌigch Jesus wui k hab kaij, “Nt wo m‑oi.” K wabshaba g Jesus hab ahg, ");
INSERT INTO oodNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uhpam g hihm k am wo i ha ahgidahi mat haschu hab juh g Jiosh m‑wehhejed.” Tsh wa woho hab e juh k am i ahgahi kihhim oidk matsh haschu si geꞌe hab juh g Jesus am wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tsh ga hu aigojed hahawa ep dada hegam Jesus. Kush muꞌi hemajkam am nenida ch si s‑ap i e taht k ab i nei. ");
INSERT INTO oodNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Tsh am hema jiwia g oꞌodham k hab chehgig Jairus ch wabsh d haꞌichu am cheopi ch ed. Sh id chehiaga muhkhim ch d gamai gohk aꞌahidag. Kutsh ab wecho si i gei g Jesus k ab ahgid matsh gam hu wo oi kihj wui. Tsh gam hu chum wehmaj hih g Jesus. Tsh g hemajkam am wabsh kawod him k gan hu wabsh i biha. ");
INSERT INTO oodNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kush eda am hema haꞌichug g uwi ch gamai gohk aꞌahidag mumku heg hekaj mo g ehꞌedaj jegwoni. Tsh pi hedai e nako mas wo doaj, chum as wehs hugio g e‑lialiga ha namkidch g mamakai. ");
INSERT INTO oodNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kutsh ab i hih Jesus wehgaj k an taht g kahbaj hugidag. Kutsh am wabsh si haꞌasa g ehꞌed jegwoni. ");
INSERT INTO oodNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sh hab kaij g Jesus, “Doht an ni‑taht.” Tsh pi hedai am hu e ah. Sh hab hahawa kaij g Peter, “T‑mashchamdam, an o m‑bihagch g hemajkam ch ab m‑shodbinch.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sh wabshaba hab kaij g Jesus, “Ab at hema ni‑taht. Ni s‑mahch nat pi ab i wuhsh g gewkdag ab ni‑amjed.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tsh am i nei hegai uwi mamt s‑mai k ab hahawa i him k si gigiwek ch ab i gei Jesus wecho amai hemajkam ha tahgio k ash am ahgid g Jesus mat haschu ahgk ab taht k has masma ha hekaj doa. ");
INSERT INTO oodNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sh hab kaij g Jesus ab wui, “Pegih, ni‑uwiga, am apt wa doa napt pi ab i ni‑hiw. Gamai g s‑ap e tahtk hihm k am wabsh s‑doakad.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kush hab wabsh kia kaij ihda g Jesus. Tsh ab hema mel ab kihj amjed g Jairus k ash hab kaij, “Muh at g m‑chehiaga. Kupt pi am hu ep wo kudu g ha mashchamdam.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kutsh kah g Jesus k hab kaij ab wui g Jairus, “Pi g am shaꞌi e todsid. Ab g wabsh i ni‑hiwig. Kut wabsh wo e chegito.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kutsh ged hu dada kihj am. Tsh hegam waꞌi ha ui g Jesus Peter ch James ch John ch hegam jehjij g chehia. Tsh am e wehm i wahp. ");
INSERT INTO oodNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kush eda wehsijj shoani ch pi ap e tahtk wehhejed g chehia. Kush hab kaij g Jesus, “Pi g am wo shoanid. Heg o wa wepo ni‑wehhejed mo wabsh kohsh g chehia.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kush wabsh has ahg hegam nash pi si s‑mahch mat muh. ");
INSERT INTO oodNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tsh wabshaba g Jesus ab bei nowij ab k ab si neok wui ch hab kaij, “I wamigi, chehia.” ");
INSERT INTO oodNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kutsh uhpam e chegito k ha hekaj i wami. Sh g Jesus am ha chehani mat wo haꞌichu mah. T wo huh. ");
INSERT INTO oodNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tsh hegam jehjij am wabsh e totods matsh e chegito. Sh g Jesus am ha ahgid mat pi hedai wo ha ahgi mat haschu has e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Am hu hebai, tsh am i ha wai g Jesus g e‑chuhchai. Tsh am wui i e hemapai. Kutsh ab ha mah g gewkdag mat gam hu wo i ha wuwhas g jijawul ab ha amjed hegam mo an ha uꞌukch k wo ha dodaj g kokꞌodam ");
INSERT INTO oodNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","k am hahawa ha cheha mat am wo i ahgahi ab amjed g Jiosh kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pi atsh koi hihi, sh hab ha ahg, “Gm amt wabsh wo i hihim k pi haꞌichu wo uꞌuk, chum hems pi g cheowikud nih g limoshan kostal nih g haꞌichu hugi nih g lial nih chum hems hema ep lihwa. ");
INSERT INTO oodNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Am amt wo dadkkad heg kih am mat hedai i si s‑ap ab wo i em‑nei am hugkam mamt hekid wo i hihi ab amjed hegai kihhim. ");
INSERT INTO oodNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kutp hebai pi ap ab hu wo i em‑nei g hemajkam, mt am wo dagito hegai kihhim k ab wo si shahmud g e‑shuhshk mamt wo ha chehgi mamt wo ha dagito k pi wo ha ahgi ab amjed g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tsh wa woho am hihi idam chuhchaij ha oidk g kihhim k am ahgahim g Jiosh haꞌichu ahga ch ha doajid g hemajkam wehsko. ");
INSERT INTO oodNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Sh eda g Herod am wabsh kia d kownal Galilee ch ed ch am i kah wehs ihda mash haschu has e wua. Am amsh wehsko aꞌaga mas hedai wud ihda Jesus. Haꞌijj ash hab kaij, “Doki hegai Johnbad mo wa ha pahl wapkonahim. Heg amt mua. Kutki wabshaba uhpam e chegito.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kush haꞌijj hab kaij, “Doki Elijabad o hema ep hegam kekelibad Jiosh haꞌichu i tashogiddam.” Kutsh wa g Herod am i pi e amichud ");
INSERT INTO oodNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","k hab kaij, “Am ant wa ha cheha mat an e hikuch g John moꞌo. Kus hedai wud ihda oꞌodham mani muꞌi haꞌichu kah ab amjed?” bash kaij ch wabsh am chum i e nakog mat wo nei g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tsh am hu hebai am i uhpam dada g Jesus chuhchai k am ahgid g Jesus wehs haꞌichu mat haschu has i juh. Tsh gm hu hahawa i ha ui matsh gam hu hejelko hasko hihi maibidch hegai kihhim mo hab chehgig Bethsaida. ");
INSERT INTO oodNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tsh am i kah g hemajkam k am i ha oi s‑neidamk g Jesus. Tsh g Jesus si s‑ap ab i ha neid k am ha ahgi ab amjed g Jiosh kownaltalig k ha dodaj g kokꞌodam. ");
INSERT INTO oodNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kutsh gam hu i juh. Tsh g chuhchaij am dada wui k hab kaij, “Am g ha chehani g hemajkam mat am wo hihi kihhim wui o am hasko oꞌoidag wui k wo bei g haꞌichu hugi k an hasko wo kohk heg hekaj mo ia hu wabsh si heb hu iia.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sh wabshaba hab kaij g Jesus ab ha wui, “Ahpim amt wo haꞌichu ha mah mat wo huh.” Sh hab kaij idam, “Heg ach waꞌi hetasp pahn ch gohk waptopi edgid. Aha nap tatchua matt am wo hihim k wo ha nolawt g haꞌichu hugi ha wehhejed idam muꞌi hemajkam?” ");
INSERT INTO oodNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kush eda shaꞌi muꞌij g hemajkam mash hetasp mihl d chechoj. Sh hab kaij g Jesus, “Hab g wo ha ahgid g hemajkam mat wo dadhaiwua hehetaspo wepst‑mahm e wehm.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tsh wa woho hab e juh g chuhchaij. Kutsh wehsijj am i dadhaiwua. ");
INSERT INTO oodNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tsh g Jesus am ha ui hegam hetasp pahn ch gohk waptopi k ab i nea dahm kahchim wui k ab hoꞌigeꞌel g Jiosh k am hahawa hahain k ab ha mah g e‑chuhchai. Tsh idam ab i ha mahkhi g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tsh wehsijj e gegosid k kokwod. Tsh g chuhchaij an i uꞌihi g ha wihpiꞌidag g hemajkam ahim matsh wo shuhshud g gamai gohk hoha. ");
INSERT INTO oodNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sh am hu hebai am hejelko e hoꞌigeꞌidahun g Jesus. Tsh am wui dada g chuhchaij. Kutsh am haꞌasa e hoꞌigeꞌidahun k hab kaij, “Dohꞌo ni‑elid g hemajkam?” ");
INSERT INTO oodNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Sh hab kaij hegam, “Haꞌijj o hab kaij map d ha‑wapkondam, Johnbad. K haꞌijj hab kaij map d Elijabad. K haꞌijj hab ep kaij map d hema ehp hegam kekelibad Jiosh haꞌichu i tashogiddam ch ia uhpam e chegito.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sh hab kaij ab ha wui, “Kum ahpim hedai ni‑elid?” Sh hab kaij g Peter, “Bach m‑elid map d Jiosh si Kehsha!” ");
INSERT INTO oodNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sh hab kaij, “Dani ahni. Kumt wabshaba pi hedai wo shaꞌi ahgi hemu mani hedai wud. ");
INSERT INTO oodNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wehpeg at hemho wo wa ni‑bei g geꞌeged ch uꞌugchu papal ch chehanig em‑mashchamdam ahni Jiosh si Kehsha k muꞌi wo ni‑shoꞌigchud k am wo i ni‑dagito mant wo ni‑muhkid. Nt wabshaba uhpam wo i wuhsh muhkig amjed heg eda waik tash amjed mamt wo ni‑mua.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sh hab hahawa ep kaij ab wehsijj ha wui, “Mamtp am wo s‑oidam g ni‑himdag k hemho wa gam hu wo dagito g hejel e‑tatchui k ahni ni‑tatchui hab wo junihid ni‑wehhejed e shoꞌigchudch. Heg at wo wa wepok mam ab mohto g kots ch ab ab wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pi amt wo heki wua g e‑doakag mamtp wo hekaj am ni‑wehhejed. Heg at wo heki wua g e‑doakag matp hedai wo chum s‑daꞌad. ");
INSERT INTO oodNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Pi at haꞌichu wehhejed wo s‑kehgajk matp g oꞌodham wehs wo bei hegai mo haschu i tatchua id dahm jewed k wabshaba pi wo e doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pi g am wo si e elidad ni‑hekaj ahni Jiosh si Kehsha ch hekaj g ni‑mashchamadag. Nt ahni hab waꞌap pi wo si ni‑elidad em‑hekaj mant hekid ia ep wo jiwia. Idani at si s‑tondam ab wo e chehgi g ni‑gewkdag ch ni‑ohg gewkdag ch ha‑gewkdag g s‑apꞌekam anghil. ");
INSERT INTO oodNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Neh, ia am haꞌi haꞌichug mamt hoꞌip kia nei g Jiosh kownaltalig k haha wo koꞌok. Am g wo s‑chegitok mani id am em‑ahgid.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sh am hu d i hemako domig amjed mash hab kaij ihda. Kutsh g Jesus gan hu wo e hoꞌigeꞌidahu uhgk doꞌag t ab k ab i ha wai hegam Peter ch John ch James matsh gan hu wehmaj wo i chehchsh. Kutsh gan hu dada heg dahm doꞌag. ");
INSERT INTO oodNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tsh am i e hoꞌigeꞌidahu g Jesus k atsh am gawul i e juh. Tsh g wehschugaj hab e juh mash si s‑tondam s‑tohta. ");
INSERT INTO oodNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tsh haha wabsh am wehmaj i e chehgi g Mosesbad ch Elijabad. ");
INSERT INTO oodNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kush g Jiosh gewkdag ab ha ab e chehgid hab masma mo g tonlig. Sh idam am wehmaj aꞌaga g Jesus matsh pi shaꞌi tash amjed am hab wo e juh hegai matsh haschu g Jiosh am apꞌech matsh wo muh am Jerusalem t am. ");
INSERT INTO oodNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Sh eda hegam Peter shaꞌi si gewpkog ch s‑kohksim ch wabshaba ab si i nehnea k nei g Jesus ch hegam gohk oꞌodham mash am wehmaj gegok. ");
INSERT INTO oodNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tsh gam hu wo hihi hegam gohk. Tsh g Peter wabsh kohsh k daꞌiwuni k hab kaij, “T‑mashchamdam, s‑apꞌe oki mach ia haꞌichug. Tt ia waik hab wo em‑juni g al chechopi matt hekaj ab wo si has em‑el ahpi ch Mosesbad ch Elijabad.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tsh g chewagi ab i wuhsh mash eda wabsh kia neok g Peter k ab ehka ha dahm. Kutsh si s‑ehbeni hegam Peter matsh ab i hud g chewagi. ");
INSERT INTO oodNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tsh g Jiosh neꞌoki ab kaida chewagi t amjed k hab kaij, “Jesus o d si ni‑tatchuidch ni‑alidag. Heg amt ab wo si kaihamad.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Sh am hahawa hejel kehk g Jesus. Kush pi am hu haꞌichug hegam gohk. Sh hegam Peter pi hedai shaꞌi haꞌichu ahgid iaꞌi idani hegai mash haschu i neid. ");
INSERT INTO oodNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sh am baꞌich d i tash. Tsh ab hahawa i huhud doꞌag t amjed. Kush shaꞌi muꞌi hemajkam am nenida g Jesus ch ab nam. ");
INSERT INTO oodNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kush hema si s‑kaidam neok ch hab kaij, “Ha mashchamdam, id o d waꞌi ni‑alidag m ia kehk. ");
INSERT INTO oodNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","K g jiawul an bebhe ch am si hihnk ch am i wuhpa jewedo. K g totshagi i chechshshaj chinij ab. S‑koꞌokam o has wua g jiawul ch chum alo pi dadagitosh. ");
INSERT INTO oodNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kuni ab wa chum si ha ahgid g m‑pionag mat gam hu hab wo i juh. T wabshaba pi e nako.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sh hab kaij g Jesus ab ha wui g e‑chuhchai, “Shoꞌo waꞌi pi geꞌej g em‑wohochudadag. M im hu hab wabsh i si e juhkch ab ni‑amjed. Shahag wepo mant hemho wa tash ia wo em‑wehmajkad ch ab wo em‑nakogad mat hekaj wo i geꞌeda.” Bash kaij ch am hahawa ahgi hegai oꞌodham, “Ab g i bekaꞌi g e‑alidag.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Sh ab chum him g ali. Sh haha wabsh ep i wua hegai jiawul am jewedo. Kush am si banimmed. Tsh g Jesus ab si s‑kehꞌel g jiawul k i wuhshad k am hahawa bei g al k ab i wanim ohgaj wui. ");
INSERT INTO oodNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kutsh wehsijj si e totods g hemajkam mat g Jiosh hab masma am i chehgi g e‑gewkdag k ab si has elid wehs hegai mo g Jesus hab junihim. Sh g Jesus hab kaij ab ha wui g e‑chuhchai, ");
INSERT INTO oodNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Am g wo s‑chegitok ihda mant am wo em‑ahgi. E o aihim mat g s‑ni‑kehꞌiddam an wo ni‑bei ahni Jiosh si Kehsha k am wo ni‑gagda ha wui g hahaꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kush pi shaꞌi amichud mas haschu hab ahg ch wabshaba s‑ehbid mas ab wo kakke. ");
INSERT INTO oodNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sh am hu hebai am e neꞌowin hegam Jesus chuhchai mas hedai d wo si haꞌichuk. ");
INSERT INTO oodNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kush g Jesus s‑ha amichud mo haschu am chegito ch heg hekaj g al ali ab i kei e‑hugid an ");
INSERT INTO oodNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","k ash hab kaij ab ha wui, “Hegai mat hedai am ni‑wehhejed s‑ap ab wo neidad g al ali ch hab waꞌap s‑ap ab ni‑neid. Kutp hedai s‑ap ab wo ni‑neidad ch hab waꞌap s‑ap ab neid g Jiosh nani pi d Kehshaj. Hegai mo hedai i si pi e haꞌichuchud am em‑shahgid o d si haꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sh am hu hebai g John hab kaij, “T‑mashchamdam, hema ach neid g oꞌodham. K heg am m‑chehcheg ch gam hu hab i ha wua g jijawul ab ha amjed hegam mo an ha uꞌukch. Kuch hab ahg mat wo haꞌasa no pi pi am hu t‑wehmaj.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kush hab kaij g Jesus ab ha wui, “Pi g am wo shaꞌi shohbid. Tki wo i em‑wehmt hegai matp hedai pi ab hu em‑wui kehk.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kush s‑mahch g Jesus mo e aihim mat g Jiosh am wo uhpam i bei e‑kihdag wui ch heg hekaj am i e shelch mat am wo hih Jerusalem wui k am wo i e nako. ");
INSERT INTO oodNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sh am hihimad ch am hema miabid g kihhim Samaria chekshani ch ed. Kutsh g Jesus am haꞌi ha cheha g e‑chuhchai matsh ha baꞌich wo hihim k wo bei g koksikud ch haꞌichu hugi. Kutsh idam ha e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tsh wabshaba am i s‑mai hegam hemajkam mash d gam hu himdam g Jesus Jerusalem wui k heg hekaj pi hohhoꞌi mat am wo jiwia nash pi pi ha hohhoꞌid g Jerusalem t am hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kutsh hekid g James ch John am i s‑mai mo pi hohhoꞌid k hab kaij, “T‑kownalig, nap tatchua matt ab wo i tai g Jiosh. T ab wo i huduni g mei k wo ha kokda?” ");
INSERT INTO oodNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sh g Jesus si s‑gewkam ha shohbid. ");
INSERT INTO oodNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tsh amjed gam hu hahawa hihi hema ep kihhim wui. ");
INSERT INTO oodNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sh am hu hebai hihim. Kush hema g oꞌodham hab kaij ab Jesus wui, “Ni‑nahtokch ani ahni mant wo i m‑oid k wo i m‑wehmt.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sh hab kaij g Jesus ab wui, “Napt hig wo e nako? Neh, chum o hems g gagso ge wahpagga ch g uꞌuwhig ge koksh. Ni wabshaba ahni Jiosh si Kehsha pi shaꞌi ha kih ia jewed dahm. K heg hekaj s‑hasig maps wo ni‑oidad.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Sh hab ep kaij g Jesus ab hema wui g oꞌodham, “Oi g ni‑oid.” Kush wabshaba hab kaij, “Heuꞌu, ni‑kownalig. T hoꞌipki hekid muh g ni‑ohg. Nt wo hiashpok haha wo m‑oi.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sh hab kaij g Jesus, “Am g ha hiwgid hegam mo pi uꞌukch g wechij doakag mat wo ha hiash g koꞌi. Pt ahpi hi am wo him k wo i ahgahi ab amjed g Jiosh kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Sh hema hab ep kaij g oꞌodham, “Ni‑kownalig, am ant wo i m‑oid k wabshaba wehpeg wo hih uhpam k an wehs wo i ha neidok g ni‑hajuni.” ");
INSERT INTO oodNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sh hab kaij g Jesus ab wui, “Neh, nat hig shelinim wo moihunad hegai mat hedai am uhpam wo nea amai mo hebaijed him? Pegih, t hab wa masma pi haꞌichu wehhejed wo s‑kehgajk am Jiosh kownaltalig ed hegai mat am uhpam wo nea.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tsh amjed g Jesus am haꞌi ep i ha chuhcha wewaꞌakko gamai gohk matsh goꞌogok e wehm wo ahgahi g haꞌichu ahgaj am ha oidch hegam kihhim matsh hebai apꞌech matsh am epai wo hih. ");
INSERT INTO oodNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Sh hab kaij g Jesus ab ha wui, “Neh, muꞌij o hegam mo e nahtokch mat wo e doꞌibia. Kuch eda pi muꞌij ahchim mach am ha ahgidahim g doꞌibiadag ahga. Id o heg wa wepo mat hebai g ha‑hihka wo si geꞌejk. T g ha‑pionag pi wo muꞌijk. Ab g wo si tahnid g Jiosh mat muꞌi wo i ha chuhcha mat am wo ha ahgidahid g s‑kehg haꞌichu ahgaj ch ab wo i ha baꞌihamad hegam mo e nahtokch. ");
INSERT INTO oodNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Neh, bat masma wo s‑ta ehbidamak g hemajkam am em‑wehhejed mat g sheshꞌe am ha wehhejed g kahwal mahmad. ");
INSERT INTO oodNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mt wabshaba pi haꞌichukaj wo e kudut k pi haꞌichu wo uꞌad nih g haꞌichu eniga nih chum hems g lial. Jiosh at hab wo ha juh g hemajkam mat wo em‑dagioꞌi. Am amt wo s‑e hohtmagi kihhim wui k pi hedai wo hiwigi mas wo em‑shohbi wohg ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kumt hebai wo dada ha‑kih am k am hab wo chei, ‘Jiosh o ab em‑makiog g s‑ap tahhadkam.’ ");
INSERT INTO oodNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","7","Kut s‑ap ab wo i em‑nei matp ab wo s‑em‑wohoch k ab wo i em‑wahpki mamt am wo dadkkad. Kumt pi has wo elid k am wo dadkkad ch wo e gegosidad ch an wo i ha ahgidahid g s‑kehg haꞌichu ahgaj g Jiosh am hugkam mamt gam hu wo hihi ab amjed hegai kihhim. Chikpandam o ab d wuikam mat ab wo bei g e‑nam‑kidadag. K idam d ha wuikam mat am hab wo juh. Pi amt inhas wo wahpkid k am wo dadkkad am hugkam mamt ep wo baꞌich hihi. ");
INSERT INTO oodNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kut hebai g hemajkam s‑ap ab wo i em‑nei kihhim ch ed, mt wo huh mat haschu wo i em‑gegos ");
INSERT INTO oodNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","k wo ha doaj g kokꞌodam k wo ha ahgi g hemajkam mat ab i ha miabi g Jiosh kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Kut hebai pi ap ab hu wo i em‑nei g hemajkam, mt am wo i wuwha kahya ch ed ");
INSERT INTO oodNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","k ab wo si i shahmud g e‑shuhshk k hab wo chei, ‘Id att hekaj am wo em‑chehgi matt wo em‑dagito. Mt wabshaba wo s‑chegitok mat ab i chum em‑miabi g Jiosh kownaltalig.’ ");
INSERT INTO oodNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Neh, hegam si pi apꞌekam hemajkam mash wa am kihkahim Sodom kihhim ch ed at wo bei g s‑koꞌok e‑namkidadag mat hekid wo e ai g geꞌe lodaita tash. T wabshaba baꞌich wo i s‑koꞌokam e namkid hegam mat pi ab hu wo em‑kaiha. ");
INSERT INTO oodNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","14","“Muꞌi s‑hasig haꞌichu ant am hab juh Korasin ch Bethsaida kihhim ch ed. Kutki eda g hemajkam amai pi ab hu ni‑wohoch. T heg hekaj ab wo bei g s‑koꞌok e‑namkidadag geꞌe lodaita tash ch ed. Hegam mo am kih Tyre ch Sidon kihhim t am ch pi geꞌe mahch ab amjed g Jiosh at pi am hu hugkam wo bei g s‑koꞌok e‑namkidadag. Tp hems ab wo i e shoꞌigchud k gam hu wo s‑ohhod g pi ap e‑chegitoi matp wo nei ihda s‑hasig haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum t am hemajkam o ab si e haschud. T wabshaba g Jiosh gam hu wo i ha shul jiawul kih ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sh hab ep kaij ab e‑chuhchai ha wui, “Heg o wa wepo mo ahni ab ni‑kaiham hegai matp hedai ab wo em‑kaiha. Kut ahni s‑ni‑ohhod matp hedai wo s‑em‑ohhod. Kutp hedai wo s‑ni‑ohhod k hab waꞌap s‑ohhod g Jiosh nani pi d kehshaj.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tsh woho gam hu hihi hegam wewaꞌakko gamai gohk. Tsh am hebai i cheka. Tsh am i uhpam dada k shaꞌi si s‑hehgig ch hab kaij, “T‑kownalig, chum hems g jijawul ab s‑t‑wohog elid mach am m‑chechcheg ch ab si ha chehani mat gam hu hab wo i e juh.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","“Heuꞌu, nat pi hegai mo d ha‑geꞌejig ch d Satan heb hu wua g e‑gewkdag,” bash kaij g Jesus, “Neid ani mat ab i gei Jiosh kihdag amjed hab sha masma mat g wepgi. ");
INSERT INTO oodNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Neh, ab ant em‑mah g gewkdag mamt wo e nako mamt am wabsh wo ha keish g kohkꞌoi ch nanakshel ch wehs g gewkdag g ge Jiawul. Kut pi wo shaꞌi s‑koꞌokam em‑juh. ");
INSERT INTO oodNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mt wabshaba pi heg hekaj wo s‑hehgigk mo g jijawul ab s‑em‑wohog elid. Heg amt hekaj wo s‑hehgigk mo gan hu oꞌohanas g em‑chechgig Jiosh kihdag an mam d e doꞌibiakam.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kutsh iaꞌi idani g Hekia S‑apꞌekam Gewkdag ab mah g Jesus g si geꞌe s‑hehgig. Kush am e hoꞌigeꞌidahun ch hab kaij, “Ni‑ohg Jiosh, dap kownal wehs haꞌichu dahm. K hab d m‑elida mat pi hedai wo e nako mas hejel wo s‑amich g haꞌichu m‑ahga. E o ehstokch ab ha amjed g s‑chu aꞌamichuddam. Kup wabshaba am ha chehgid idam mo haꞌichu s‑mahchimk hab masma mo g aꞌal. Ni heg hekaj ab si m‑hoꞌigeꞌid.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Neh, bash kaij g Jesus ch am hahawa ha ahgid g hemajkam, “Ni‑ohg Jiosh at ab ni‑mah wehs haꞌichu. Pi o hedai ni‑mahch ch hegai waꞌi ni‑ohg s‑ni‑mahch. K pi hedai mahch g ni‑ohg. Ni ahni waꞌi s‑mahch ch hegam ehp mani hedai i wui tashogid.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tsh am hahawa i e hejelko hegam Jesus. Kush hab ha ahg, “Do si s‑ap tahhadkam mam am neid ch kah ihda mam haschu i neid ch kah. ");
INSERT INTO oodNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Muꞌijj g kekelibad Jiosh haꞌichu i tashogiddam ch kokownalbad o wa chum s‑neidamk hegai mam haschu i neid ch chum s‑kaimk mam haschu i kah.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tsh am hu hebai am hema jiwia g chehanig ha mashchamdam k wabsh chum heki s‑himchudam g Jesus hab kaijch, “Ha mashchamdam, shahnt wo ni‑juh. T hekaj ab wo i ni‑wahki g Jiosh e‑kihdag ed?” ");
INSERT INTO oodNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kush hab kaij g Jesus ab wui, “Nap hig pi mahch mo has chuꞌig an Jiosh oꞌohana ed heg amjed.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sh hab kaij hegai oꞌodham, “Heuꞌu. Bo chuꞌig: Matt hemho wa ab wo si pihk t‑elidad t‑kownalig Jiosh wui wehs t‑ihbdagkaj ch id am wo chehgidch wehs t‑doakagkaj ch wehs t‑gewkdagkaj ch wehs t‑chegitoidagkaj. K hab ep chuꞌig: Matt hemho wa ab wo si pihk t‑elidad t‑nawoj wui hab masma mach has i masma hejel t‑wehhejed si pihk t‑elid.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sh hab kaij g Jesus, “Heg o wud. Kut s‑ap ab wo i m‑wahki maptp heg am hab wo junihid.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kush ihda oꞌodham s‑mahch mo pi am hu hab junihim hegai chehanig ch wabshaba gam hu wabsh chum s‑e oanamk ch ash ab kakke g Jesus, “K hedai d ni‑nawoj?” ");
INSERT INTO oodNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sh g Jesus am ahgid ihda haꞌichu wepogida ahga, “Neh, matp hems am hema hih g t‑wehm Tuhligo Jerusalem t amjed gam hu Jerico wui. T am haha wabsh g s‑chu eꞌeskam am cheggia k ehs g haꞌichu enigaj k gewichkwua k chum alo mua. ");
INSERT INTO oodNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","K am woꞌo. “T ab haha wabsh g pahl hema hih wohg oidch k nei mo am woꞌo ihda oꞌodham k gam hu wabsh mehk him k an bij. ");
INSERT INTO oodNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","T hab wa masma g papal ha wehm chikpandam ab hema him k am nei hegai oꞌodham mo am woꞌo k gam hu wabsh bijim k gam hu hih. ");
INSERT INTO oodNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","T g hema Samaria t am oꞌodham am hahawa him k cheh ihda oꞌodham. Kum ab aꞌai s‑e kehꞌid g Samaria t am hemajkam ha wehm. T eda ihda si s‑hoꞌigeꞌid ");
INSERT INTO oodNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","k ab i wako g ehꞌed g nawaitkaj k ab i huhud k an i hobino g ikuskaj k an hahawa dai e‑shoiga an k gam hu i bei kihhim wui mat am hebai wo ha nuhkudach. ");
INSERT INTO oodNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“K am baꞌich d i tash. T gam hu wo hih ihda oꞌodham k wabshaba ab haꞌi ha mah g lial mat wo nuhkud k hab ha ah, ‘Am g wo nuhkud. Kunt ia ep wo jiwia k wo wa em‑namkid mamt haschu baꞌich wo i heki gei wehhejed.’ ");
INSERT INTO oodNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Neh, kup hedai hab elid idam waik mo s‑ap d nawojij hegai mamt gewichkwua?” ");
INSERT INTO oodNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sh hab kaij hegai chehanig ha mashchamdam, “Hegai mo s‑hoꞌigeꞌid.” Sh hab kaij g Jesus, “Pegih, gamai g hihm k am hab e junihid hab masma.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sh amjed am hebai hihim idam Jesus ch am dada hema kihhim t am. Sh am hema g uwi hab chehgig Marda ch ab i ha wahpki e‑kih ed. ");
INSERT INTO oodNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kush am wehmaj daha g wehngaj ch hab chehgig Mary ch id ab i dahiwua Jesus wui k ab si kaiham g haꞌichu mashchamaj. ");
INSERT INTO oodNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sh eda g Marda si chikpan ch e kudut k am jiwia Jesus wui k hab kaij, “Ni‑kownalig, nap pi shaꞌi has elid mat g ni‑wehnag am wabsh i ni‑dagito mant hejel hab wo juh g chikpan. Ab g ahgid mat ab wo i him k wo i ni‑wehmt.” ");
INSERT INTO oodNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sh hab kaij g Jesus ab wui, “Ih, Marda, muꞌi ap haꞌichukaj e kudut. ");
INSERT INTO oodNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","K eda am d waꞌi hemako haꞌichu mo d si haꞌichu. Id at g Mary ab bei. Kut pi wo shaꞌi e wohppoꞌidach.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sh am hu hebai e hoꞌigeꞌidahun g Jesus ch am i kuhgit. Sh hema hab kaij g chuhchaij ab wui, “T‑kownalig, oi g hig t‑mashcham matt has masma wo t‑hoꞌigeꞌidahu hab masma mo wa g John ha mashcham hegam mo ab si wecho e mashcham.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sh hab kaij g Jesus ab ha wui, “Id amt hab wo chei am e hoꞌigeꞌidahunch: Jiosh t‑ohg, ab ach si has m‑elid ch si haꞌichuchud g m‑chehgig ch tatchua mapt wo i geꞌedaj g e‑kownaltalig ia t‑shahgid. ");
INSERT INTO oodNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ab g i s‑t‑hoꞌigeꞌid k ab wo t‑mahkad g haꞌichu hugi wehs tashkaj. ");
INSERT INTO oodNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gam g hu hab i juhni g pi ap t‑chuꞌijig nach pi ahchim gam hu pi chechegitod g ha‑chuꞌijig hegam mat hedai i pi ap has chuꞌi ab t‑wui. Pi g am hiwgid g Jiawul mas am wo t‑shul pi apꞌekam ch ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Sh hab ep kaij g Jesus ab ha wui hegam mo ab si wecho e mashcham, “Neh, tp hems hema pi am hu geꞌe wo haꞌichu hugik. T am hema mehkjed wo jiwia hudunk ab mat ab i chehgim. Kut am wo hih g kihkam e‑hugid am kihkam wui k ab wo haꞌi tai g sismito mat wo gegos g e‑nawoj. ");
INSERT INTO oodNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“T hab haha wabsh wo chum chei g hugidaj am kihkam, ‘Pi g ia hu ni‑kudut. Heki ant hu ab yahwidad g ni‑kihjeg. Kutt heki hu wohpiwua g t‑aꞌaliga ha wehm. Nt pi wo i wamig k wo m‑mah haꞌichu.’ ");
INSERT INTO oodNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“T wabshaba pi has wo e elid k ab wabsh wo kia tahnid. T am haha wo i wamig k ab wo mah nat pi pi haꞌasa ab wo tahnid. ");
INSERT INTO oodNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","“Pegih, mt ahpim hab wa masma pi haꞌasa ab wo tahnid g Jiosh mam haschu i tatchua. T ab wo em‑mah. Am g wo haꞌichu i e gahgidad. T wo em‑chehgi. Ab g wo shontpag g kihjeg. T ab wo i e kuhpiꞌo em‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Neh, s‑mahch am mat pi hedai wabsh g wamad ab wo mah g e‑alidag mat g watopi ab wo tai. ");
INSERT INTO oodNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kut pi wabsh g nakshel ab wo mah mat g chuchul nonha ab wo tai. ");
INSERT INTO oodNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mam has i masma pi apꞌe ch wabshaba s‑mahch mamt g s‑kehg haꞌichu ab wo ha mah g e‑aꞌaliga. No hig pi g em‑ohg Jiosh baꞌich i e nahtokch mat ab wo ha mah g Hekia S‑apꞌekam Gewkdag hegam mat ab wo tai.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sh am hu hebai hema pi ha neok g cheoj nash pi g jiawul an uꞌukch. Kutsh g Jesus gam hu hab i juh g jiawul. Tsh am ha hekaj i neo. Tsh g hemajkam si has i el. ");
INSERT INTO oodNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sh eda haꞌi hab kaij, “Moki g jijawul ha‑geꞌejig ab mahkch g gewkdag. K heg hekaj gam hu hab i ha wua g jijawul ab ha amjed hegam mo an ha uꞌukch.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Sh haꞌijj wabsh chum heki s‑himchudamk g Jesus ch ab chehani mat g s‑hasig haꞌichu hab wo juh k hekaj am wo ha chehgi mo ab Jiosh t amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sh wabshaba g Jesus s‑mahch mo haschu am chegito ch hab kaij ab ha wui, “S‑mahch am mat g oꞌodham wo padch g hejel e‑jewedga mat ab aꞌai wo e cheggia. Kut g e‑wehm kihkam hab waꞌap wo padch g hejel e‑kihdag mat ab aꞌai wo e cheggia. ");
INSERT INTO oodNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pegih, t has hig masma g Jiawul pi wo padch g hejel e‑kownaltalig matp ab wo sha ni‑mah g gewkdag mant am wo i ha wuwhas g piongaj? ");
INSERT INTO oodNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Neh, em‑pionag o hab waꞌap i ha wuwhasid g jijawul. Kum eda pi hab masma hab ha elid mo g Jiawul ab ha mahkch g gewkdag. Pegih, idam at wo em‑ahgi mo pi woho hegai mam hab chum elid. ");
INSERT INTO oodNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jiosh gewkdagkaj ani gam hu hab i ha wua g jijawul. K id am wohokamchud mat heki hu in i wuhsh g Jiosh kownaltalig em‑shahgid. ");
INSERT INTO oodNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nat hig pi wo e nahtokch g si s‑gegoki kownal g e‑cheggiakudkaj mat wo nuhkud g e‑kih. T hab pi hedai wo wohppoꞌi g haꞌichu enigaj. ");
INSERT INTO oodNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tp wabshaba g baꞌich i s‑gegoki kownal wo cheggia k wo gewito k gam hu wo i ui hegai cheggiakudaj mo ab chum si hiwig k am wo aꞌai i tahp g haꞌichu enigaj am ha wehhejed g e‑shondalig. Neh, bani wa masma cheggia g ge Jiawul. ");
INSERT INTO oodNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","K hegam mat hedai pi ab hu wo i ni‑wehmajk ab ni‑wui gegok ch wabsh ha gantan hegam mani s‑ha doꞌibiamk.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kush hab ep kaij g Jesus, “Matp hems g jiawul an wo hema uꞌukch g oꞌodham ch wabsh wo dagito mat am hebai ep wo e ul. Kut hegai oꞌodham wo i chum kegch g e‑doakag. T wabshaba g jiawul pi hebai wo chehg k hekaj hab wo i e ah, ‘Mo hig woho d ni‑kih hegai oꞌodham. Nt hig am uhpam wo hih wui.’ ");
INSERT INTO oodNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kut wa woho am uhpam wo him k wo cheh mo am wabsh jeg ch si kegchudas ch hehosimhunas. ");
INSERT INTO oodNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","T am haha wo him k wewaꞌak ep wo ha uꞌapa g jijawul. T idam baꞌich wo i pi apꞌek ch am wehmaj wo i chiwia. Neh, t ihda oꞌodham hahawa baꞌich wo i pi apꞌek mo wa ga hu i heki hu.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sh an wehgaj gegok g hemajkam. Kush hema g uwi hab kaij am wui g Jesus, “Do si geꞌe s‑hehgig heg wehhejed uwi mat an m‑mahsid k m‑siꞌichudahim.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sh wabshaba hab kaij g Jesus, “Baꞌich at wo i s‑hehgigk hegam mat ab wo kaihamad g Jiosh haꞌichu ahga.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sh am i muꞌidahim g hemajkam. Kush hab kaij g Jesus, “Muꞌijj o g ha‑chegitoidag pi apꞌe. K heg hekaj s‑neidamk mant hab wo juh g s‑hasig haꞌichu k am wo wohokamch mani ab Jiosh amjed. Bant waꞌi masma am wo ha chehgi mani d Jiosh si Kehsha matsh wa hab e juh hegai kelibad Jiosh haꞌichu i tashogiddam mash d Jonah. ");
INSERT INTO oodNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Heg atsh wa am si has masma i e chehgi ha wui g Ninevah t am hemajkam. Nt ahni am si has masma wo i ni‑chehgi am ha wui g hemajkam iaꞌi idani. ");
INSERT INTO oodNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","“Hegam Ninevah t am hemajkam atsh gam hu s‑ohhod g pi ap e‑chegitoi am i kahk g Jonabad k hab pi ab hu wo e chuꞌijigch geꞌe lodaita tash ch ed. Ni ahni baꞌich d i si haꞌichu mo g Jonabad. Kum eda pi ab hu ni‑kaiham ch heg hekaj ab wo motoig g chuꞌijig lodaita tash ch ed. (31) Mehkjed atsh ab i hih g uwi kownal ab wakolim tahgio amjed mat ab wo kaiha g Solomonbad haꞌichu mahchig. Ni ahni baꞌich d i si haꞌichu mo g Solomonbad. Kum eda pi ab hu ni‑kaiham ch heg hekaj ab wo motoig g chuꞌijig lodaita tash ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kush hab ep kaij g Jesus, “Wohokam o wepogidas mo g lahmpa. Kum s‑mahch mo pi hab d ahga g lahmpa mas am wo e ehsto haꞌichu wecho. Mt an wo dai mat hebai wo ha tonlidad hegam mo ab i wahpk. ");
INSERT INTO oodNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Em‑wuhpui at s‑ap am wo i wahki g tonlig matp wo s‑mamsk k wabshaba pi am hu wo i wahki matp pi wo mamsk. Kum heg hekaj s‑ap ha nuhkud. ");
INSERT INTO oodNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pegih, wahm amt wo si s‑ap nuhkudad g haꞌichu e‑amichudadag mat heg s‑ap am wo i wahki g wohokam. ");
INSERT INTO oodNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bat waꞌi masma ab wo i shuhdad g em‑chegitoidag g wohokam.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tsh am i haꞌasa neo g Jesus. Tsh am hema jiwia g Palasi k am waid mat wo wehmaj e gegos. Kutsh wa woho am i wahk k am i dahiwua matsh wo e gegos. ");
INSERT INTO oodNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tsh hegai Palasi si has i el neidok mat pi e wako hab masma mo d ha himdag. ");
INSERT INTO oodNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kush s‑amichud g Jesus ch hab kaij ab wui, “Neh, ahpim Palasi am si kegchud g e‑honshpadag. K wabshaba g em‑chegitoi wabsh shuhdags g pi apꞌekamkaj. Heg o wa wepo mam an waꞌi wehgaj si kegchud g hohas‑hahaꞌa. K ged hu ha eda wabsh kia s‑bibtagi. ");
INSERT INTO oodNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Damt wabsh wo totontok mamtp heg wo waꞌi s‑ap nuhkud e‑honshpadag. Jiosh at hab waꞌap nahto g em‑doakag. Kumt heg ep wo chum nuhkud. ");
INSERT INTO oodNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Am g wehs wo i dagito Jiosh wui k hab wo s‑chechojimak ab shoꞌigkam ha wui ch wo nei mat wehs haꞌichu wo s‑kehgajk am em‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Neh, ahpim Palasi am ab mahk g Jiosh g hemako tahpani mo wehst‑mahm e tahpanch g em‑eniga, chum hems g nahnko mahs pi‑miandi ch haꞌichu tatk. T wabshaba g Jiosh s‑koꞌokam wo em‑namkid nam pi pi apꞌechud hegai mam haschukaj ha shoꞌigchud haꞌi ch pi ab hu tatchua g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Shaꞌam waꞌi s‑hohhoꞌid mamt si s‑apko wo dadhaiwua am cheopi ch ed ch s‑hohhoꞌid mat ab wo si has em‑elidad g hemajkam mamt an wo i wuwha kahya ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ih, shoꞌig! Mt wo si s‑koꞌokam e namkidach. Neh, pi at wo mahsk g hihaꞌini matp pi am hu wo tohnkdask. Kumtp hems am wabsh dahm wo oiopod. Pegih, bat sha masma pi wo mahchk g hemajkam mam d pi apꞌekam nam pi ehstokch g pi ap e‑chuꞌijig.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kush hema hab kaij g chehanig ha mashchamdam ab wui, “Ha mashchamdam, ahchim ap hab waꞌap has t‑ahg hab kaijch.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sh hab kaij g Jesus, “Pegih, ab em‑wui o hab waꞌap him g s‑koꞌok em‑namkidadag. Muꞌi s‑hasig haꞌichu am ab ha chehani g hemajkam. K id d s‑wehch haꞌichu mohtoi am ha wehhejed. M eda ahpim pi haꞌichu hab shaꞌi wua mams hekaj ha wehm wo moht. ");
INSERT INTO oodNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“Em‑shohshon at muꞌi ha kokda g Jiosh haꞌichu i tashogiddam. Kum ahpim ha wepo masma, chum ams ha hehosid g ha‑hihaꞌiniga hegam mamt ha kokda. K heg hekaj ab em‑wui him g s‑koꞌok em‑namkidadag. ");
INSERT INTO oodNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Heki o hu hab kaij g Jiosh, ‘Ab ant wo i ha wuwhas g haꞌichu i tashogiddam ha shahgid g hemajkam. Kut haꞌi wo ha‑kokda k haꞌi wo ha shoꞌigch.’ ");
INSERT INTO oodNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Neh, kum ha wepo chuꞌijig mamtp ha wepo haꞌichu elid. Kut wepo masma wo em‑ai g s‑koꞌok ha‑namkidadag heg hekaj wehs mat hab juh ga hu i amjed mat in i e nahto g jewed. ");
INSERT INTO oodNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelbad atsh wa wehpeg e muhkid. Tsh amjed muꞌi ep e koꞌij. Tsh g Zecariabad ga hu si ha oidch e muhkid amai shahgid g iagchulidakud ch geꞌe cheopi. Kum ahpim ha wepo chuꞌijig hegam matsh wa ha kokda ch ha wepo masma wo bei g s‑koꞌok e‑namkidadag mamtp hedai ha wepo elid haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ahpim chehanig ha mashchamdam amt wo i chum ha amichudach g hemajkam mat has masma wo s‑mahchk g Jiosh. Kum eda ahpim pi mahch ch ep ha shohbidch hegam mo s‑mahchimk. Heg o wa wepo mam ab yahwidad g kihjeg mat pi hedai am hu wo i wah. Jiosh at s‑koꞌokam wo em‑namkid heg hekaj.” ");
INSERT INTO oodNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tsh am i wuhsh g Jesus k gam hu chum hih. Tsh hegam chehanig ha mashchamdam ch Palasi ab hahawa si s‑ta keꞌidam has ahg k muꞌi haꞌichu kakke ");
INSERT INTO oodNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","hab wabsh chum ahgch mat wo heki himch mat pi ap haꞌichu hab wo chei. ");
INSERT INTO oodNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kutsh shaꞌi si muꞌi mihl hemajkam am i e hemapad k wabsh aꞌai e keishshap. Sh hab kaij g Jesus ab ha wui g e‑chuhchai, “Neh, hegam mo d Palasi o hab wabsh s‑e junimk mo d s‑apꞌekam. Mt wo s‑e nenꞌoidk mamt pi am hu ha oidk hab wo masmak. ");
INSERT INTO oodNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hegai mo chum e maꞌishch at wehs wo e maꞌishpiꞌo. Pej, wehs s‑aꞌagi haꞌichu at wo s‑e mai. ");
INSERT INTO oodNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wehs at wo mahsko e wua mamtp haschu chum s‑aꞌagi hab kaij. Kut wehs am si s‑kaidam wo e ahgad kih dahm amjed mamtp haschu i chum s‑jupij hab kaij ged hu si e‑kih ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Sh hab hahawa kaij g Jesus ab ha wui g hemajkam, “Neh, ni‑naipijju, pi g wo shaꞌi ha ehbidad hegam matp hedai wo chum s‑em‑kokdaim. Pi at wo e nako mas baꞌich s‑koꞌokam has wo i em‑juh em‑kokdak. ");
INSERT INTO oodNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Heg at waꞌi Jiosh wo e nako mat am wo em‑daꞌich Jiawul kih ed mamtp pi am hu wo wohog elidad. Kumt heg ab wo waꞌi si has elidad. ");
INSERT INTO oodNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","K wabshaba g Jiosh si s‑hemajima ch pi tatchua mas wo s‑koꞌokam em‑juh. Am g wo oidahim mo chum hems g al uꞌuwhig s‑ap ha nuhkud. K eda chum alo pi haꞌichu namkig idam. Kum ahpim wehs haꞌichu baꞌich d i haꞌichu am tahgio. Jiosh o wehs haꞌichu s‑mahch ab em‑ab. Mt heg hekaj pi haꞌichu wo shaꞌi ehbidad ab wui e dagitokch.” ");
INSERT INTO oodNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sh hab ep kaij g Jesus, “Neh, am amt wo s‑ni‑mahch k ah hemajkam ha tahgio mani d em‑doꞌibiakam. Kunt ahni hab waꞌap wo s‑em‑mahch k ah am ha tahgio g anghil ch am Jiosh tahgio. ");
INSERT INTO oodNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kutp wabshaba hedai pi wo ni‑mahch k ah am ha tahgio g hemajkam, nt ahni hab waꞌap pi wo mahch k ah am ha tahgio g anghil ch am Jiosh tahgio. ");
INSERT INTO oodNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Jiosh at gam hu hab wo i juh g pi ap chuꞌijigaj hegai mat hedai wo wa chum has ni‑ah matp gam hu wo s‑ohhod g pi ap e‑chuꞌijig. T wabshaba pi gam hu hab wo i e juh g pi ap chuꞌijigaj hegai mat hedai wo s‑koꞌokam has ah g Hekai S‑apꞌekam Gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pi g wo shaꞌi kudut ab amjed mamt has masma e wehhejed wo neo mamtp hems am wo em‑lodai chechopi ch ed o am ha tahgio g kokownal. ");
INSERT INTO oodNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Hekia S‑apꞌekam Gewkdag at wo em‑ahgi mamt has wo chei.” ");
INSERT INTO oodNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sh am hema g oꞌodham hab kaij ab wui, “Ha mashchamdam, hab g ahgid g ni‑nawoj mat am wo i ha ni‑tahpani hegai mat g t‑ohg an dagito t‑wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sh hab kaij g Jesus ab wui, “Pi ant heg hekaj ia hu jiwia manis wo em‑lodait k am wo i em‑apꞌechudach g haꞌichu em‑eniga am em‑shahgid.” ");
INSERT INTO oodNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sh am baꞌich hab ep kaij ab wehs ha wui, “Am g wo s‑e nenꞌoidk mamt pi heg wo waꞌi huꞌuidad s‑kaisdag. Pi amt d wo s‑ap doakamk heg hekaj mam haschu i eniga, chum ams d wo s‑kaisk.” ");
INSERT INTO oodNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sh id am hahawa chum ha tashogid ch hab kaij, “Tp hems hema d wo s‑kaisk. K g eꞌeshaj si geꞌe babhe. ");
INSERT INTO oodNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","K hab e ahg, ‘Pi o an hu wiꞌis mant hebai ep wo toa g haꞌichu bahidag. Shuhshud at g ni‑waptto. ");
INSERT INTO oodNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nt hig wo i ha shulig k am baꞌich i geꞌeged haꞌi wo i chuhcha k am wo baꞌiha g haꞌichu bahidag ch wehs haꞌichu ni‑eniga. ");
INSERT INTO oodNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Si at haꞌichu s‑ni‑abam. Nt muꞌi aꞌahidag ab wo hekaj ihda s‑iꞌowi haꞌichu k wo ni‑ulinihogidad ch wo ni‑gegosidad ch wo ihꞌed ch wo si s‑hehgigk.’ Neh, bo e ahg ihda s‑kais. ");
INSERT INTO oodNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“K wabshaba ab wui hab kaij g Jiosh, ‘Dap wabsh tohnto. Id i s‑chuhugam ab apt wo muh. Kut d wabsh wo hemak ch wo ui g haꞌichu m‑eniga map hejel am chum e wiꞌidch.’ ");
INSERT INTO oodNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Neh, bo wa chuꞌig ch hab waꞌap wo wa chuꞌigk wehs ha wehhejed hegam mo hejel s‑e kaischudamk ch wabshaba pi am hu Jiosh wehhejed hekaj g s‑e‑kaisdag,” bo kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sh hab hahawa ep kaij g Jesus ab ha wui g e‑chuhchai, “Heg ani hekaj am em‑ahgid ihda mamt pi wo si e kudutad ab haꞌichu e‑hugi ab o ab haꞌichu e‑eniga ab. ");
INSERT INTO oodNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Jiosh at ab em‑mah g em‑doakag, pegih, k hab waꞌap ab wo em‑mah mamt haschukaj wo e dagioꞌidad. ");
INSERT INTO oodNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“An g wo i ha neid g hahawani. Idam o pi haꞌichu eꞌeshad ch pi od g haꞌichu esha ch pi ha kihki o ha waptto mat am eda wo baꞌiha. Jiosh o ha gegosid. Kum eda ahpim baꞌich d i si haꞌichu mo g uꞌuwhig am tahgio g Jiosh. T heg s‑ap wo em‑dagioꞌidad. ");
INSERT INTO oodNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Pi amt wo e nako mams am baꞌich wo i himch g e‑aꞌahidagga am wabsh hekaj e kudutch. ");
INSERT INTO oodNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mamtp pi wo e nako mamt hab wo juh ihda al haꞌas chum haꞌichu, pegih, k haschu ahgk wo e kudutad g baꞌich i geꞌeged haꞌichukaj? ");
INSERT INTO oodNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“An g wo i ha neid hegam haꞌichu wuhshanig m an chuhch. Pi o chikpan ch pi shohshom g haꞌichu eniga. Kuki eda g ha‑heosig baꞌich i s‑kehgaj mo g haꞌichu enigaj hegai s‑kais kownalbad mash hab chehgig Solomon. ");
INSERT INTO oodNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Neh, tp hems s‑hohtam wo gaksh hegai shaꞌi m an chuhch k wo hekaj e nanda. K eda heg wa wepo mo g Jiosh si s‑kehg enigadadch g heosigkaj. Pegih, am g wo s‑wohochud mat ab s‑ap wo em‑enigadadch. ");
INSERT INTO oodNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pi g heg waꞌi hekaj wo e kudutad mamt wo e gahgi g haꞌichu hugi. ");
INSERT INTO oodNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Wehs hemajkam an jewed dahm o chum hekid id an si e gahgid. K wabshaba g em‑ohg Jiosh s‑mahch mam tatchua ihda. ");
INSERT INTO oodNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mt g Jiosh kownaltalig wehpeg am wo ul e‑doakag ed. T g Jiosh ab epai wo em‑mah mam haschu i tatchua. ");
INSERT INTO oodNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Pi g am wo shaꞌi haꞌichu ehbidad ahpim mam al heꞌekiajj ab ni‑hiwig. Em‑ohg Jiosh o ab si tatchua mat ab wo i em‑mah g e‑kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Wehs g wo gagda mam haschu i edgid k wo ha mah g namkigaj g shoꞌigkam k an haha wo edgidad g baꞌich i s‑kehg kaisdag Jiosh kihdag ed. T heg pi hekid wo huhug. T pi hedai wo em‑ehs. T g hiopch pi hekid wo padch. ");
INSERT INTO oodNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kumt am wo s‑hihimim no pi g em‑tatchuidag am ulinig mo hebai haꞌichug hegai mam haschu hab elid mo d em‑kaisdag.” ");
INSERT INTO oodNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Kush hab ep kaij g Jesus, “Mt wo si e nahtokch mat haschu has wo e juh hab sha masma mat g pion wo si e nahtokch mat g ha‑ahmo wo uhpam jiwia. Ha‑ahmo atp hems am wui wo hih g wo ha hohntam gegosig k pi oi wo uhpam jiwia. T wabshaba g piongaj ab wo s‑ap e enigadadch ch ab wo mehidch g e‑kanjel ch g e‑ahmo ab wo nenida. T am wo i jiwia k wo si shontpa. T ab ha hekaj wo i kuhpiꞌo g kihjeg wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","T wo si s‑hehgigk hegam pion mat g ha‑ahmo wo ha cheh mo nenead ch e nahtokch. Neh, t heg ab hab wo juh g bahshodag k wo si s‑ap ha dadsh k wo ha gegos. ");
INSERT INTO oodNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","T wo si s‑hehgigk hegam mat wo e nahtokch mat wo jiwia, chum as hems eda wo i huh g s‑chuhugam o i baꞌiwichkim. ");
INSERT INTO oodNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Neh, pi o ta machima mas hekid hema wo i jiwia g s‑chu ehskam. Kum heg hekaj chum hekid nuhkud g e‑kihdag. ");
INSERT INTO oodNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pegih, k hab waꞌap pi ta machima em‑wehhejed manis hekid wo uhpam jiwia jewed wui ahni Jiosh si Kehsha. Mt heg hekaj wo si e nahtokchid chum hekid.” ");
INSERT INTO oodNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sh hab kaij g Peter, “T‑kownalig, nap ahchim waꞌi hab t‑ahg aha nap wehs hab ha ahg?” ");
INSERT INTO oodNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sh hab kaij g Jesus, “Chum amt hedai wo e nahtokch mamtp wo s‑wapagimak ch wo s‑chu aꞌamichudad. S‑mahch am mat g ha‑ahmo hema wo e gahgi g hab mahs chikpandam k wo nuhkudach g e‑kihdag. T heg s‑ap wo ha chikpanchudad ch wo ha dagioꞌidad g e‑wehm pion mat eda pi an hu wo haꞌichugk g ha‑ahmo. ");
INSERT INTO oodNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","T am ep wo jiwia k wo cheh mo ihda s‑ap am hab junihim g e‑chikpan. Kut d wo si geꞌe s‑hehgigk heg wehhejed pion ");
INSERT INTO oodNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","nat pi g ahmoj am hahawa wehs dahm wo kei g e‑kihdag. ");
INSERT INTO oodNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“T wabshaba pi ap d wo ha‑kehshak matp hedai wo i ha shoꞌigchudad g e‑wehm pion ch wo si e gegosidad ch wo nawmmukad hab e ahgch mat pi oi wo jiwia g ahmoj. ");
INSERT INTO oodNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","T haha wabsh wo jiwia k wo cheh mo pi ap hab wua g e‑chikpan k wo si s‑koꞌokam namkid k gam hu hab wo i juh. ");
INSERT INTO oodNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“T wo bei g s‑koꞌok e‑namkidadag hegai pion mat wo s‑mahchk g e‑ahmo tatchui ch eda pi am hu hab wo junihid. ");
INSERT INTO oodNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","T wabshaba pi am hu i si s‑koꞌokam wo bei g e‑namkidadag hegai mo pi e mahch ch hab junihim g pi apꞌekam. Baꞌich i geꞌe haꞌichu amt uhpam wo s‑behim ab amjed hegai mamt baꞌich haꞌichu nuhkudach.” ");
INSERT INTO oodNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kush hab ep kaij g Jesus, “Ia ant jiwia jewed dahm mant wo i ha chuꞌamu g hemajkam hab sha masma mant am wo si i nai ha‑iꞌibdag ed. T hab wo s‑nenenashanik ab Jiosh wui. Mat huꞌi heki hu hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Am ant s‑ta ehbidam haꞌichu gahi wo wuhshani k si ni‑kudut heg hekaj. ");
INSERT INTO oodNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Pi g hab wo e elidad mat wo dodolimat g hemajkam mant ia jiwia. ");
INSERT INTO oodNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ab at em‑wui wo gegokiwua hegam mat pi wo ni‑tatchuad, chum hems haꞌakia em‑wehm kihkam. ");
INSERT INTO oodNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Cheoj atp hems wo s‑kehꞌidad g e‑ohg o g e‑alidag. T g uwi g e‑jeꞌe o g e‑mad o g e‑kahkma jeꞌe wo s‑kehꞌidad.” ");
INSERT INTO oodNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","56","Sh hab hahawa ep kaij g Jesus, “Neh, mt wo s‑mahchk mas wo juh o as wo tonih am neidk mas hebaijed hewed ch has mahs chewagi i wushke. M eda pi am hu i aꞌamichud mo haschu has e junihog iaꞌi idani neidch mani haschu hab wua. Shahag wepo mam pi mahchimk. ");
INSERT INTO oodNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“E o aihim mat g Jiosh wo ha lodai g hemajkam. Am g wo aꞌamichud mamt has wo chum masmak. ");
INSERT INTO oodNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","S‑mahch am mamt hemho wa s‑hohtam am wo i e apꞌech heg wehm mat ab wo haꞌichu i em‑abch. Tp hems am wo i em‑wahpki lodaita ch ed mamtp pi am hu wehmaj wo i e apꞌech. T g usagakam am wo i em‑dagito chi‑lihhi wui. T heg ged hu wo si em‑kuh. ");
INSERT INTO oodNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kumt pi wo shaꞌi i e wuhshad am hugkam mamt hekid wo i wehs ha namkid mamt heꞌekia i em‑toꞌi.” ");
INSERT INTO oodNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kush iaꞌi idani haꞌi g oꞌodham am ahgid g Jesus matsh g kownal Pilate haꞌi ha kokda g Galilee t am hemajkam mash eda idam am hab chum wua g iagchulida Jiosh wui. ");
INSERT INTO oodNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sh g Jesus hab kaij am ha wui, “Kumtp hab elid mo id am wohokamchud mo baꞌich d i si pi apꞌekam mo hedai i Galilee t am kihkam namt pi hab masma ha kokda. ");
INSERT INTO oodNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","K eda pi woho. Wehsijj am hab masma d pi apꞌekam ch wo bei g s‑koꞌok e‑namkidadag mamt wo sha pi ohhod g pi ap e‑chegitoi. ");
INSERT INTO oodNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Neh, am atsh i gei g uhgk kih Siloam woꞌo t am Jerusalem ch ed. Kutsh gamai gigiꞌik e koꞌij. Kum hab elid mo id am wohokamchud mo idam baꞌich d i si pi apꞌekam mo hedai i hegam mo am kih Jerusalem t am. ");
INSERT INTO oodNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","K eda pi woho. Wehsijj am hab masma d pi apꞌekam ch wo bei g s‑koꞌok e‑namkidadag mamt wo sha pi ohhod g pi ap e‑chegitoi.” ");
INSERT INTO oodNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sh g Jesus am ha ahgid ihda haꞌichu wepogida ahga, “Neh, matp hema g oꞌodham ge suhnaga am uhdwis e‑oidag ed ch am him k am s‑uꞌim g suhna. K pi ab hu bahidag. ");
INSERT INTO oodNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","“K hab ahg g oidag nuhkuddam, ‘Neh, waik aꞌahid ab ach am nenneid hegai suhna uhs ch pi koi haꞌichu shaꞌi bei ab amjed. Pt wo shonch. S haschu ahgk am hig wo kehkk oidag ch ed?’ ");
INSERT INTO oodNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“K wabshaba hab kaij g oidag nuhkuddam, ‘Am att hig wabsh wo dagito hemako ahidag ehp. Nt am wo si i moihun k am wo iawua g haiwani biht an wehgaj. ");
INSERT INTO oodNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kut am wo s‑apꞌek matp ab wo bahidagt. Nt wabshaba am haha wo si shonch matp pi ab hu wo bahidagt.’ ” ");
INSERT INTO oodNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sh am hu hebai mihshmda tash ch ed g Jesus am ha mashcham cheopi ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Sh am hema haꞌichug g uwi mash g jiawul an uꞌukch. Kush gamai gigiꞌik aꞌahid ab waꞌi mumku mash ab wabsh i e olatch ch pi e nako mat wo shel i kekiwua. ");
INSERT INTO oodNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tsh am i cheh g Jesus k ab si wai. Tsh ab i hih. Kush hab kaij, “Ahpi uwi, ia at wo i doa g m‑mumkidag,” ");
INSERT INTO oodNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","K ab hahawa taht. Kutsh ha hekaj shel i kekiwua k ab si ihm g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kutsh ab si bagat hegai mash d ha‑wanimeddam am cheopi ch ed matsh g Jesus ha doaj ha‑mihshmda tash ed k ash hab ha ah g hemajkam, “Am o haꞌichug g chuhdp tash matt heg eda wo chikpanad. Kunt heg oidam tash ia wo dada k wo e doaj, hi wa pi t‑mihshmda tash ed mo g Jiosh am kehshch.” ");
INSERT INTO oodNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sh hab kaij g Jesus ab wui, “Ih, pi ap shaꞌi woho ab hu has elid g Jiosh pi ab hu hoꞌigeꞌidch ihda uwi no pi d chum aligaj. S‑mahch ap mat wabsh chum hedai g e‑woiwisga o g e‑wuhluga am wo wulꞌok k am wo be k ged hu wo iꞌich, chum hems e‑mihshmda tash ed. ");
INSERT INTO oodNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pegih, tt wahm wo i wehmt ihda t‑wehm oꞌodham. Jiawul o wa ab wulshch gamai gigiꞌik ahid ab. Kutt hemho wa wo wulꞌo, chum hems mihshmda tash ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kutsh si e el hegam mo s‑kehꞌid. Sh wabshaba g hemajkam si s‑hehgig heg hekaj si s‑kehg haꞌichu mat hab juh. ");
INSERT INTO oodNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sh hab ep kaij g Jesus, “Am ant heꞌes wo i em‑tashogi g Jiosh kownaltalig ");
INSERT INTO oodNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","am wepogidch g haꞌichu kai. Neh, heg am eꞌesha mo al chumaj ch oi wa am wo wuhshani k haꞌas wo i geꞌeda mo g s‑ehheg uhs. Tp hems g uꞌuwhig an ab wo koksht. Pegih, t hab wa masma wo geꞌe i geꞌeda g Jiosh kownaltalig, chum as al chum am wo shonwua.” ");
INSERT INTO oodNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Sh hab ep kaij g Jesus, “Jiosh kownaltalig o hab waꞌap wepogidas mo g jewajidakud. Heg amt wo be k am wo wah wehnadk g chuꞌi k am heꞌes wo i dai. T g jewajidakud wo chehmo g wahga mat wehs am wo i kopodka. Pegih, t g Jiosh kownaltalig hab wa masma wo chehmo g jewed.” Neh, bash kaij g Jesus ");
INSERT INTO oodNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sh am hihimhim hegam Jesus ha oidk g kihhim. Sh g Jesus am haꞌichu ha mashcham g hemajkam ch am wabsh i si haꞌab e gewkadch Jerusalem wui. ");
INSERT INTO oodNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sh hema ab kakke ch hab kaij, “Ni‑kownalig, nat pi shaꞌi muꞌi wo e doꞌibia g hemajkam?” Sh hab kaij g Jesus ab wui, ");
INSERT INTO oodNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Heuꞌu. Kumt heg hekaj am wo si e nakogad mamt am wo i wahp Jiosh kownaltalig ed. Muꞌijj at am wo chum s‑wahpkim k pi wo e nako. Heg o wa wepo mamt am wo i wahp al aj kihjeg t amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Id ant wo wepogi g kih enigakam mat am wo i ha wahpki g e‑machiga k am haha wo si kuh g pualit. T ab haꞌi ep wo i chum s‑wahpkim. T hab wo ha ah, ‘Gam g hu wo hihim. Pi ani shaꞌi em‑mahch.’ ");
INSERT INTO oodNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Neh, bat wa masma muꞌi am wo i chum s‑wahpkim ni‑kownaltalig ed hab kaijch, ‘M‑wehm ach t‑gegosidahim. Kup am ha mashcham t‑kihhim am.’ ");
INSERT INTO oodNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Kunt hab wo ha ah, ‘Pi ani shaꞌi em‑mahch. Gam g hu wo hihim ab ni‑amjed. Dam si pi ap hehemajkam.’ ");
INSERT INTO oodNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“T haha wo si shoanid ch ga hu wabsh wo i si e kiꞌishch nat pi wo shaꞌi si s‑koꞌok haꞌichu nakogad. T eda am wo haꞌichugk g Abrahambad ch Isaacbad ch Jacobbad ch wehs g Jiosh haꞌichu i tashogiddam. ");
INSERT INTO oodNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kut g hemajkam ab wo i hihi siꞌal tahgio amjed ch huduni tahgio amjed ch ab juhpin tahgio amjed ch wakolim tahgio amjed k am wo dadhaiwua e wehm Jiosh kownaltalig ed. ");
INSERT INTO oodNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kut am d wo si hahaꞌichuk hegam mo hemuch d pi hahaꞌichu. T hegam mo hemuch d si hahaꞌichu d haha wo pi hahaꞌichuk.” ");
INSERT INTO oodNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tsh am ha hekaj haꞌi dada g Palasi k hab kaij ab Jesus wui, “Gam g hu hihm ia amjed nash pi s‑m‑muꞌamk g Herod.” ");
INSERT INTO oodNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sh hab kaij g Jesus ab ha wui, “Herod o sha ban masma ch hab kaij. Him k ahgid mant haꞌas tash am wabsh kia gam hu hab wo i ha junihid g jijawul ch wo ha doajidad g kokꞌodam ch haha wo s‑ap nahto g ni‑chikpan. ");
INSERT INTO oodNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kunt pi wo shaꞌi ni‑muhkid im hu haha wabsh i himadch. Am o waꞌi Jerusalem t am e koꞌijid g Jiosh haꞌichu i tashogiddam. ");
INSERT INTO oodNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ih, t wo si e shoꞌigch g Jerusalem t am hemajkam nat pi g Jiosh s‑ap wo ha dagito. Ha‑shohshon ash wa ha maꞌichshulig ch muꞌi ha kokda g Jiosh haꞌichu i tashogiddam. T idam am ha oidk hab wo e juh. Muꞌikko ani hab chum si ni‑tahtk mant wo si s‑ap em‑nuhkud hab sha masma mat g chuchul g e‑mahmad ab e wecho wo ha hemapai. M wabshaba pi ab hu tatchua manis hab wo em‑juh. ");
INSERT INTO oodNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","K eda an hab chuꞌig Jiosh oꞌohana ed mamt ab wo chum ni‑ihmad ch hab wo chechꞌed mat g Jiosh am i ni‑kehsh k si s‑ni‑hoꞌigeꞌid. Kunt ia wo i s‑ap em‑dagito am hugkam mamt hab hahawa masma hab wo e juh.” ");
INSERT INTO oodNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sh hema d uhgchu ch d Palasi ch hebai hab juh g geꞌe gegosig ha‑mihshmda tash ed k ash ab i wai g Jesus. Kutsh am jiwia. ");
INSERT INTO oodNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sh eda an hema haꞌichug g cheoj ch mahniko nash pi g kakhioj ch nohnhoij ge totskoni. Kumsh an si s‑nenꞌoid g Jesus mas wo doaj nash pi ab haꞌichu s‑abchudamk. ");
INSERT INTO oodNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sh hab kaij g Jesus ab ha wui hegam chehanig ha mashchamdam ch Palasi, “Shahchu am ahgch hab elid mo pi t‑hiwgid g t‑chehanig machs wo ha doaj t‑mihshmda tash ed?” ");
INSERT INTO oodNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sh pi hedai has shaꞌi kaij. Tsh g Jesus ab hahawa i wai ihda oꞌodham k doajid k am hahawa dagito. Kutsh gam hu hih. ");
INSERT INTO oodNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sh hab hahawa kaij g Jesus ab ha wui, “Neh, namt hig pi woho ab ha hekaj wo i wuhshad g e‑alidag o chum hems g e‑woiwisga matp am wo sha gei wawhia ch ed, chum as d wo em‑mihshmda tashk?” ");
INSERT INTO oodNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kush pi hedai e nako mas has wo chei. ");
INSERT INTO oodNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kutsh haꞌi hegam ha‑waida gan hu si wehpeg s‑apko dadhaiwua. Kush am ha neid g Jesus ch hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Pi g am hu si s‑apko wo dadhaiwua mamt hekid am wo hihi gegosig wui. Tp hems am hema wo jiwia mat am baꞌich d wo i s‑has haꞌichuk. ");
INSERT INTO oodNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kut am haha wabsh wo jiwia hegai mat ab i em‑wai k hab wo em‑ah mamt wo hiwigi hegai s‑has haꞌichu abai mamt ab chum dahiwua. Kumt wo si e el namt pi hahawa ga hu wabsh si ha oidk wo dahiwua. ");
INSERT INTO oodNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Baꞌich at wo i s‑apꞌek mamt ga hu wabsh mehk wo dahiwua. Kut g kihkam ab wo i him k hab wo em‑ah, ‘Ni‑nawoj, oi g i hihm k ia hu s‑apko ni‑miabidch i dahiwua.’ Neh, t id ab wo em‑mah g si has elida am ha tahgio hegam haꞌi ha‑waida. ");
INSERT INTO oodNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Mt wo pi haꞌichuch hegai mat hedai wo chum si e haꞌichuch k ab wo si haꞌichuch hegai mat wo pi e haꞌichuch.” ");
INSERT INTO oodNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sh hab hahawa ep kaij g Jesus ab wui hegai mat ab i wai, “Pi g hegam ab waꞌi ha waid e‑naipijju o g e‑wepnag o g e‑hajuni o g s‑kakais e‑hugid an kihkam mapt hekid hab wo juh g gegosig. Ab at epai wo i m‑wai idam. Kupt hab masma ab wo bei g e‑namkidadag heg hekaj mapt id hab juh. ");
INSERT INTO oodNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ab g i ha waid g shoꞌigkam ch mamaniko ch pi hihimidkam ch pi neneadam mapt hekid hab wo juh g gegosig. ");
INSERT INTO oodNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pi at wo e nako idam mat wo uhpam m‑namkid. T g Jiosh ab wo m‑mah g s‑kehg m‑mahkigdag mat hekid am wo i ha wuwhas g s‑apꞌekam hemajkam ab muhkig amjed.” ");
INSERT INTO oodNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sh am hema daha g oꞌodham ch kah ihda. Tsh am i haꞌasa neo g Jesus. Sh id ab wui hab kaij, “Ttki wo si s‑hehgigkad, am i wahpk Jiosh kihdag ed, heg wa wepo matt am wo dadhaiwua geꞌe gegosig ch ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sh hab kaij g Jesus, “Heuꞌu, mamtp woho am wo i wahp. Id o wepo masma matp hems hema hab juh g geꞌe gegosig k muꞌi ab ha waid g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","T am i e ai. Kut am hema cheha g e‑pionag. T heg am him k ha‑ahgi mo wehs haꞌichu e nahtokch. ");
INSERT INTO oodNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“K wabshaba idam am ahgid mat pi wo e nako mat am wo hihi. “Neh, tp hems hema am wo ahgi, ‘Ha ant nolawt g oidag k heg s‑neidamk ch hekaj pi am hu wo hih.’ ");
INSERT INTO oodNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Kutp hems hema am wo ahgi, ‘Wehst‑mahm woiwis ant am ha nolawt k hegam s‑ha aꞌappemimk.’ ");
INSERT INTO oodNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Kutp hems hema am wo ahgi, ‘Ha ant hohnt k hekaj pi am hu wo hih.’ ");
INSERT INTO oodNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Neh, t am hahawa uhpam hih ihda ha‑pionag k am ahgi g e‑ahmo. T g ahmoj wabsh woho i bagat k hab kaij ab e‑pionag wui, ‘S‑hohtam g am hihm kahya ch ed ch wohg ch ed k ab wo i ha ui g shoꞌigkam ch mamaniko ch pi neneadam ch pi hihimidkam.’ ");
INSERT INTO oodNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Kut wa woho hab juh k am hahawa jiwia k hab kaij, ‘Bant juh g m‑chehanig. K wabshaba am wabsh kia wiꞌis g kih.’ ");
INSERT INTO oodNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“K hab ep kaij g ahmoj, ‘Am g i wuhshani k an mehk hihm chuꞌuchum wopog oidch an shaꞌi ch ed k hab wo ha juh mat ab wo i hihi mat wo shuhd g ni‑kih. ");
INSERT INTO oodNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pi at ab hu i hihi hegam mo d chum si ni‑waida. Kunt pi hema wo shaꞌi hiwigi mas wabsh wo i jeh g ni‑gegosig.’ ” ");
INSERT INTO oodNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sh am hu hebai hihim hegam Jesus. Sh muꞌi hemajkam am ha wehm hihim. Tsh ab i ha nei g Jesus k hab kaij ab ha wui, ");
INSERT INTO oodNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Pi am ab hu shaꞌi ni‑tatchua mamtp pi baꞌich ab wo i ni‑tatchua mam hi g e‑jehj ch e‑wepnag ch e‑wehm kihkam ch e‑aꞌaliga. ");
INSERT INTO oodNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Hemho wa amt gam hu wo dagito g hejel hab e‑elida k ahni hab ni‑elida hab wo junihid ch ni‑wehhejed wo e shoꞌigchudad. Id at heg wo wa wepok mam ab mohto g kots ch ab ab wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Neh, nat hig pi am hu wo i aꞌamich hegai matp hedai am hema geꞌe wo kiht mas am hi wa ahim lialiga mat wo nahto g e‑kihta? ");
INSERT INTO oodNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mt wo ashad matp am hab wabsh wo juh g shondaj k pi wo e nako mas am hu wo i nahto g e‑kihta. ");
INSERT INTO oodNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kut hab wo e chechꞌed, ‘Ihda oꞌodham at am chum hema i kei g kih k wabshaba pi e nako mat wo nahto.’ Pegih, mt ahpim hab wa masma wo i aꞌamich mams wo e nakog k ab wo ni‑hiwgad. ");
INSERT INTO oodNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Neh, matp hems hema g kownal wo s‑cheggiam g e‑obga k eda al wehst‑mahm mihl (10,000) wo shondaligak. T g obgaj gokko wehst‑mahm mihl (20,000) wo shondaligak ch ab him. T hegai kownal am wo i chum aꞌamich mas hu hi wo wa e nako mat wo cheggia. ");
INSERT INTO oodNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tp hab wo mahsk matki pi wo e nako, t hemho wa am wo haꞌi ha cheha mat ab wo nam hegai hema kownal mat ga hu wabsh kia mehk wo himad k wo s‑mai mas heꞌekia wo i namkid. T pi wo cheggia. ");
INSERT INTO oodNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Neh, bo chuꞌig. Kumt ahpim pi wo e nako mamt ab wo ni‑hiwgad, heg hi wa mamt wehs haꞌichu wo dagito am ni‑wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sh hab ep kaij, “Mt haꞌichu wehhejed wo chum s‑kehgajk hab masma mo g on. ");
INSERT INTO oodNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Heg at gam hu wabsh wo s‑e ohhod mat wo sha kahko. Kumt wo s‑e nenꞌoidad namt pi wabsh wo s‑e ohhod mamtp pi haꞌichu wehhejed wo s‑kehgajk. Ab g wo i aꞌamichud ahpim mam kah ihda.” ");
INSERT INTO oodNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sh am hu i hebai, sh muꞌi lial ha kowlantdam ch pi ap hemajkam ab i miabi g Jesus mat ab wo kaiha. ");
INSERT INTO oodNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tsh g Palasi ch chehanig ha mashchamdam ab i s‑babgam neneok k hab kaij, “Ihda oꞌodham o wabsh s‑ap ab ha neid g pi ap hemajkam ch ha wehm e gegosid.” ");
INSERT INTO oodNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tsh heg hekaj am ha ahgi ihda haꞌichu wepogida ahga, hab kaijch: ");
INSERT INTO oodNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Id o wepo masma mamtp hems hema ahpim siant wo kahwaligak. Kut hema wo heb hu hih. Namt hig pi am wo ha dagito hegam humukto gamai humukt kolhai ch ed k am wo i gahghi hegai hema am hugkam mamt wo chehg ");
INSERT INTO oodNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","k an haha wo kushwiot k hih uhpam ");
INSERT INTO oodNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","k ab wo i ha wai g e‑naipijju. T am wo i e hemapai. Kumt hab wo ha ah, ‘Si g wo s‑hehgigk ni‑wehm. Cheh ant g ni‑shoiga mat chum heb hu hih.’ Kut am em‑wehm wo si s‑hehgigk. ");
INSERT INTO oodNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pegih, t hab wa masma d wo si s‑hehgigk an eda g Jiosh kihdag chum hems hemako em‑wehhejed mamt gam hu wo s‑ohhod g pi ap e‑chegitoi. Kum eda haꞌi hejel hab chum e elid mam d s‑apꞌekam hemajkam ch pi tatchua mams gam hu wo s‑ohhod g pi ap e‑chegitoi.” ");
INSERT INTO oodNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kush id am ep ha ahgid g Jesus ch hab kaij, “Matp hema g uwi wehst‑mahm wo enigak g lial ch hema wo heb hu wua. Tp hems wo mehi g e‑lahmpa k an wo i wosu g e‑kih k an wo i gahghi am hugkam mat wo chehg ");
INSERT INTO oodNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","k ab haha wo i ha wai g e‑naipijju. T am wo i e hemapai. T hab wo ha ah, ‘Si g wo s‑hehgigk ni‑wehm. Cheh ant g ni‑lialiga mant chum heb hu wua.’ Kut am wehmaj wo si s‑hehgigk. ");
INSERT INTO oodNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pegih, t hab wa masma wo si s‑hehgigk g anghil chum hems hemako em‑wehhejed mamt gam hu wo s‑ohhod g pi ap e‑chegitoi.” ");
INSERT INTO oodNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sh hab ep kaij g Jesus, “Matp hems hema g oꞌodham gohk wihpiopga. ");
INSERT INTO oodNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","T g chumchu ab wui i him k hab kaij, ‘Ni‑ohg, wapt wo i ni‑mah hegai mat d wo chum ni‑wuikamk.’ Kut wa woho am i gawulkai g e‑eniga k ab ha mah g e‑wihpiopga hegai mo haschu d ha‑wuikam. ");
INSERT INTO oodNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“T ihda chumchu am ha hekaj gagda g e‑eniga k bei g namkigaj k gam hu simnolt mehk jewed wui k am heki wua g e‑lialiga am hab wuadch g pi apꞌekam. ");
INSERT INTO oodNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","T am i huhug g lialigaj. T am hahawa gei geꞌe bihugig. K ihda simnoltdam pi haꞌichu edgid mas wo huh. ");
INSERT INTO oodNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","K am hahawa hema chikpanachud e‑oidag ed mat wo ha nuhkud g kokji. ");
INSERT INTO oodNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kut chum hems heg s‑hugim mo haschu g kokji koꞌa. T pi hedai haꞌichu mah mas wo huh. ");
INSERT INTO oodNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“T am hahawa haꞌichu kop moꞌoj ed. K hab e ahg, Wehs g ni‑ohg pionag o s‑edgid g haꞌichu hugi. Kuni eda ahni d bihugimkam. ");
INSERT INTO oodNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nt hig wo uhpam hih ni‑ohg wui k hab wo chei, ‘Ni‑ohg, pi ant ap has chuꞌi ab m‑wui ch ab Jiosh wui. ");
INSERT INTO oodNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","K hahawa pi d ni‑wuikam mams hab wo ni‑aꞌagad mani d m‑alidag. Chum anis hems d wabsh wo m‑pionagk.’ ");
INSERT INTO oodNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Neh, t am ha hekaj i wuhshani k am wui hih g e‑ohg. T heg cheh mo im hu wabsh kia him k ab si s‑hoꞌigeꞌid k ab wui med k gan hu kohm k ab chintad. ");
INSERT INTO oodNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“K ab wui hab kaij g alidaj, ‘Ni‑ohg, pi ant ap has chuꞌi am m‑wui ch am Jiosh wui. K hahawa pi d ni‑wuikam mams hab wo ni‑aꞌagad mani d m‑alidag.’ ");
INSERT INTO oodNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“T wabshaba g ohgaj hab wabsh ha ah g e‑pionag, ‘Ab g wo i bek g s‑kehg eniga k an wo wahkid k g anilo an wo shaꞌich nowij an k g shuhshk ab ep wo cheka ");
INSERT INTO oodNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","k wo mua g s‑gihg wisilo. Kutt hab wo juh g geꞌe gegosig k wo si s‑hehgigk. ");
INSERT INTO oodNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Uhpam at ep jiwia ihda ni‑alidag mat gam hu mehk hih. Id o heg wa wepo mat muh k ep e chegito.’ Neh, t wa woho hab e juh g si geꞌe s‑hehgig. ");
INSERT INTO oodNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“K eda gam hu chikpan g geꞌechu alidaj oidag ch ed ch pihhun k ab hih. K eda si s‑hehgig ch neꞌed ch keihin. ");
INSERT INTO oodNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kut kah k ab hema kakke g pion mas has d ahga ihda. ");
INSERT INTO oodNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“K heg hab kaij, ‘M‑wehnag at jiwia. Kumt mua g s‑gihg wisilo k hab juh g geꞌe gegosig nat pi s‑ap jiwia.’ ");
INSERT INTO oodNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Neh, t bagat ihda geꞌechu k pi am hu i wah. T am hahawa kah g ohgaj k am i wuhshani k am wabsh s‑ap ab chum waid. ");
INSERT INTO oodNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","K wabshaba ab wui hab kaij, ‘Nehꞌe, haꞌakia aꞌahidag ani ab m‑wecho ch chum hekid hab wua g m‑tatchui. Kupt eda pi hekid chum hems g siwat mad ab ni‑mah mant wo ni‑gegosid k wo s‑hehgigk am ha wehm g ni‑naipijju. ");
INSERT INTO oodNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","T wabshaba ia jiwia ihda m‑alidag mat hedai heki wua g m‑kihdag ha wehm g chechpaꞌawi. Kupt muꞌij g s‑gihg wisilo.’ ");
INSERT INTO oodNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“K g ohgaj ab wui hab kaij, ‘Ni‑alidag, ahpi ap chum hekid ni‑wehmaj. K wehs hegai mo d ni‑eniga d m‑eniga. ");
INSERT INTO oodNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","K wabshaba hemu am wa s‑apꞌe matt wo si s‑hehgigk nat pi uhpam ep jiwia ihda m‑wehnag mat am simnolt. Heg o wa wepo mat muh k ep e chegito,’ bo kaij g ohgaj.” ");
INSERT INTO oodNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Sh am ep ha ahgid g Jesus ihda wepogida ahga ch hab kaij, “Tp hems am hu hebai hema d wo s‑kais oꞌodhamk. K hegai mat am i kei mo d maliom wabsh heki wua g lialigaj. ");
INSERT INTO oodNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","T am i wai e wui k hab kaij, ‘Am ant haꞌichu sha naksh ab m‑amjed k antki hekaj hab wo chei mapt am wo i kuint k am wo oꞌoha wehs map has i masma nuhkud g haꞌichu ni‑eniga nantki pi wo m‑dagito.’ ");
INSERT INTO oodNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“T hab i e ah ihda oꞌodham, ‘Tki wo i ni‑wuhshad g ni‑ahmo. Nis has wo ni‑juh? Pi ant wo ni‑nako manis wo waikkat k si ni‑elid manis wo haꞌichu ha tahnid. ");
INSERT INTO oodNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Neh, s‑mahch ani mantki has wo ni‑juh k muꞌi wo naipijjuk. T idam ab wo i ni‑wahki e‑kihki ed mamt hekid wo i ni‑wuhshad id amjed ni‑chikpan.’ ");
INSERT INTO oodNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Bo kaij ch am hahawa hehemako ha waid hegam mo ab ab e wulshch g ahmoj. Kut am hema jiwia. K g maliom ab wui hab kaij, ‘Nap s‑mahch map heꞌekia ab ab i e wulshch g t‑ahmo?’ ");
INSERT INTO oodNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“K hab kaij ihda, ‘Heuꞌu, hemako siant waplin g a‑saidi ani ab ab ni‑wulshch.’ “K hab kaij hegai maliom, ‘Ab ant wo i huduni. Pt am waꞌi hetaspo wehst‑mahm waplin ab ab wo e wulshch.’ “T gam hu hih hegai. Kut am hema ep jiwia. ");
INSERT INTO oodNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“K g maliom ab wui hab kaij, ‘Nap s‑mahch map heꞌekia ab ab i e wulshch g t‑ahmo?’ “K hab kaij ihda, ‘Hemako mihl kokstal g pilkani.’ “K hab kaij hegai maliom, ‘Ab ant wo i huduni. Pt am waꞌi gigiꞌik siant kokstal ab ab wo e wulshch.’ ");
INSERT INTO oodNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Neh, t g ahmoj si has i el am i kahk mat has e juh ihda s‑chu banmadamkam maliom nat pi si s‑e mahch k hab e juh. Neh, hegam mo pi mahch g Jiosh o em‑baꞌich i s‑e mahch ch hab wua haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Id ani em‑ahgid mamt wo s‑ap hekaj g e‑kaisdag am ha wehhejed hegam mo tatchua g i wehmtadag. T g Jiosh s‑ap am wo i em‑wahpki e‑kihdag ed mamt hekid wo muh. ");
INSERT INTO oodNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Hegai matp hedai s‑ap wo nuhkud g al chuꞌuchum haꞌichu at hab waꞌap s‑ap wo nuhkud g geꞌeged haꞌichu. Kutp hedai wo ha banmad g al chuꞌuchum haꞌichukaj k hab waꞌap wo ha banmad g geꞌeged haꞌichukaj. ");
INSERT INTO oodNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Am g wo s‑ap nuhkudad hegai mam haschu em‑nuhkudachud id dahm jewed. T g Jiosh am wo haꞌichu em‑nuhkudach e‑kownaltalig ed. Heg o d s‑wohom kaisdag ");
INSERT INTO oodNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ch d wo em‑enigak mamtp wo s‑ap nuhkud hegai mam haschu em‑nuhkudachud id dahm jewed. ");
INSERT INTO oodNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Pion at pi wo e nako mat gohk wo aꞌamok. Hema at baꞌich ab wo i tatchuad ch baꞌich i s‑ap wo chikpanidad. Kumt ahpim hab waꞌap pi wo shaꞌi e nako mams wepo ab wo ha tatchuad g Jiosh ch ihda jewed dahm s‑kaistalig.” ");
INSERT INTO oodNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sh am haꞌi kah g Palasi wehs ihda. K eda g Palasi si pihk e elid g s‑kaisdagkaj. Kush idam heg hekaj nahnko ahg g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sh hab kaij g Jesus ab ha wui, “Ahpim am hab chum e wua mam d s‑apꞌekam am ha tahgio g hemajkam. K wabshaba g Jiosh s‑mahch g em‑iꞌibdag. Hegai mo haschu i g hemajkam hab chum elid mo d si haꞌichu o d wabsh pi haꞌichu am Jiosh nena ed. ");
INSERT INTO oodNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mosesbad ch hegam haꞌi kekelibad Jiosh haꞌichu i tashogiddam at an oꞌoha mamt has wo chum masmak. Kumt id wo chum hekaj am hugkam mat ab i wuhsh hegai John mo em‑pahl wapkonahim. K am i amjed ihda s‑kehg haꞌichu ahga ab amjed g Jiosh kownaltalig am e ahgahim. K wabsh chum hedai am chum e nakog mat am wo i wah. ");
INSERT INTO oodNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","T wabshaba pi wabsh wo huhug hegai chehanig. Baꞌich at wo i pi hasigk mat g dahm kahchim ch jewed wo huhug. ");
INSERT INTO oodNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Dat wo pi ap chuꞌijkamk hegai matp hedai wo s‑ohhod g e‑wehm kihkam k hema ep wo bei. K hab waꞌap wua g pi apꞌekam hegai matp hedai an wo bei g ha‑ohhoda.” ");
INSERT INTO oodNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sh id am ep ha ahgid g Jesus: “Tp hems hema d shaꞌi si s‑kais oꞌodham ch chum hekid g si s‑namkig eniga ab wahpkch ch wehs tashkaj si s‑kakaisim kihdag. ");
INSERT INTO oodNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","K am hema d si shoꞌigkam oꞌodham ch hab chehgig Lazarus ch wehsko hihiwog. Kum ab i bebhe ch ab dadsha s‑kais oꞌodham kihjego. ");
INSERT INTO oodNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","hab elidch mat heꞌes haꞌichu wo al huh mo ab i shulig s‑kais oꞌodham mihsa t ab. K g gogogs ab winikon g hihiwdaj. ");
INSERT INTO oodNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“T am i muh ihda shoꞌigkam oꞌodham. T g anghil am i be k an uꞌapa anai mam am ha nuhkud g s‑apꞌekam. “Kut g s‑kais oꞌodham hab waꞌap muh. Kumt ged hu cheh. ");
INSERT INTO oodNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","T am i e chegito k oki am haꞌichug mo am kuhkpi g pi apꞌekam ch shaꞌi si s‑koꞌok haꞌichu tahtk ch ab i nea e dahm. K g Lazarusbad ab wehmaj daha g t‑shohshon Abraham. ");
INSERT INTO oodNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","K ihda s‑kais oꞌodham ab si s‑kaidam hab kaij, ‘Ni‑shohshon, Abraham, geꞌe s‑koꞌok ani nakog id eda mehi. Ab g si i s‑ni‑hoꞌigeꞌid k ab wo cheha g Lazarus mat am wo wahki g e‑nowi shuhdagi ch ed k ab wo i him k ab wo iawua ni‑nehni ab.’ ");
INSERT INTO oodNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“K wabshaba hab kaij g Abrahambad, ‘Ni‑hajuni, am g i chegito map wa in d doakam ch wehs haꞌichu s‑kehg edgid. K wa g Lazarus d wabsh si shoꞌigkam ch wabshaba hemuch ab si s‑ap e tahtk iia. Kup ahpi g s‑koꞌok tahtk. ");
INSERT INTO oodNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gamai wa baꞌich o an ge sꞌtadani ch s‑juhk hiktani an t‑tahgio. Kutt pi wo t‑nako machs hedai am gahi wo i chesh em‑wui o mamt ahpim ab gahi wo i chesh t‑wui.’ ");
INSERT INTO oodNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“K hab kaij g s‑kais oꞌodham, ‘Pegih, ni‑shohshon, am ani hetasp wepnag. K idam am wabsh kia d dodakam ch am kih ni‑ohgbad kih am. Ab g si i s‑ni‑hoꞌigeꞌid k am wo cheha g Lazarus mat am wo him k am wo ha shohbi. T pi ia hu haꞌab wo dada mo ia g s‑koꞌok e tahtk.’ ");
INSERT INTO oodNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“K hab kaij g Abrahambad, ‘M‑wepnag o edgid g Moses oꞌohana ch Jiosh haꞌichu i tashogiddam ha‑oꞌohana. T heg am wo ha shohbi matp ab wo kaiha.’ ");
INSERT INTO oodNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“K hab hahawa ep kaij g s‑kais oꞌodham, ‘Ni‑shohshon, Abraham, pi at woho ab wo kaiha. Pt wabshaba hema hab wo sha juh mat ep wo e chegito. T ab wo kaiham k gm hu wo s‑ohhod g pi ap e‑chegitoi.’ ");
INSERT INTO oodNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“K hab kaij g Abrahambad, ‘Pi o ab hu kaiham g Moses oꞌohana ch Jiosh haꞌichu i tashogiddam ha‑oꞌohana. K am wa tasho mat hab waꞌap pi ab hu wo wohoch hegai matp hems ep wo e chegito.’ Neh, bo kaij ch am dagito.” ");
INSERT INTO oodNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sh hab hahawa ep kaij g Jesus ab ha wui hegam mash ab hiwig, “Chum o hekid haꞌichu hab e wua mamtp hems heg hekaj am wo i shul pi apꞌekam ch ed. T wabshaba s‑koꞌokam wo e namkid hegai mat hab wo em‑juh mamt am wo i shul. ");
INSERT INTO oodNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Baꞌich at wo i s‑apꞌek wehhejed matp hems wo e wachumchud k wo e mua. T hab pi am hu wo ha shul g al ni‑wohochuddam pi apꞌekam ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Am g wo s‑e nenꞌoidad! “Mt wo ahgi g e‑wehm wohochuddam matp pi ap wo chuꞌi ab em‑wui. Kutp hems ab s‑ap wo em‑kaiham k gam hu wo s‑ohhod g pi ap e‑chegitoi. Kumt ab wo i s‑hoꞌigeꞌel. ");
INSERT INTO oodNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tp hems muꞌikko hab wo juh g pi apꞌekam ab em‑wui hemako tash ed. Mt wabshaba chum hekid ab wo i s‑hoꞌigeꞌel mat hekid gam hu wo s‑ohhod g pi ap e‑chegitoi k ab wo em‑tai g hoꞌigeꞌelig.” ");
INSERT INTO oodNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sh hab kaij g Jesus chuhchai ab wui, “T‑kownalig, ab g i geꞌedajid g t‑wohochudadag.” ");
INSERT INTO oodNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kush hab kaij g Jesus, “Pi am tatchua g geꞌe wohochudadag. Wehs at hab wo e juh hegai mamt hab wo cheꞌe k wo s‑wohoch mat hab wo e juh. Mtp hems am wo ahgi ihda gohi uhs mat wo e huhpshan k ged hu wo e ei ge shuhdagi ch ed. Kut wa woho hab wo e juh.” ");
INSERT INTO oodNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Sh g Jesus am haꞌichu ha wepogid ch hab kaij, “Pi o ab hu shaꞌi ab g ha‑ahmo mas wo ha hihidol g e‑pionag, chum as hegam ge tash oidam am chikpan oidag ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pion at wo hihidol g e‑ahmo k wo gegosid k hahawa hejel wo e gegos. ");
INSERT INTO oodNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ab o ha ab mat am hab wo wa juh hegai mo haschu am hab i ha chehani. Kut pi hab wo chum el mas ab wo ha hoꞌigeꞌel. ");
INSERT INTO oodNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pegih, bo wa masma am em‑wehhejed. Wehs amt haꞌichu am hab wo juh mo haschu ab i em‑chehani g Jiosh k hab wabsh wo e ahgad mam d wabsh pion ch am hab wabsh juh g e‑chikpan.” ");
INSERT INTO oodNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sh am wabsh kia hihim hegam Jesus Jerusalem wui ch am hihi ha shahgid g Samaria chekshani ch Galilee chekshani. ");
INSERT INTO oodNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Sh am hema d al kihhim. Kush am haꞌi dadha jeg ed nash pi kokꞌo heg hekaj mo g ha chuhkug muhkhim ch chum pi ha doajig. Tsh am i chum wahp hegam Jesus mash em kihjeg g kolhai. Tsh idam kokꞌodam am cheh g Jesus k i wahpamig k d wehst‑mahm ch am nam k ga hu wabsh mehk gegok ");
INSERT INTO oodNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ch amjed s‑kaidam hab kaij, “Jesus, t‑kownalig, ab g i s‑t‑hoꞌigeꞌid.” ");
INSERT INTO oodNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sh ab ha neid g Jesus ch hab kaij, “Gamai g wo hihim k ab wo e‑chehgi papal ha wui.” Tsh am heꞌes i hihim k s‑mai matki ha doda. ");
INSERT INTO oodNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kutsh hema ab uhpam i hih am i s‑mahchk mat doa k ab si ihm g Jiosh si s‑kaidam ");
INSERT INTO oodNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","k atsh am si gei jewed dahm ab Jesus wecho k ab si hoꞌigeꞌel. Kush eda ihda pi d Tuhligo ch d wabsh Samaria t am oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kush hab kaij g Jesus, “A nant pi woho wehst‑mahm oꞌodham ha dodaj. ");
INSERT INTO oodNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","T eda al hemako ia uhpam jiwia k ab hoꞌigeꞌel g Jiosh k d wabsh goꞌol oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kekiwuani k gamai hihm. Ab ap ni‑hiwig ch heg hekaj doa.” ");
INSERT INTO oodNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sh haꞌi g Palasi hab si kaij ab wui g Jesus, “A pt hekid hig am wo i t‑chehgi ihda Jiosh kownaltalig map an ahgachug?” Kush hab kaij ab ha wui, “Pi amt g e‑wuhpuikaj wo nei g Jiosh kownaltalig ");
INSERT INTO oodNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","mams hab wo chei, ‘Ia o haꞌichug’ o ‘Gd o hu haꞌab haꞌichug.’ K eda am em‑shahgid.” ");
INSERT INTO oodNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sh amjed hab kaij hegam ha wui mash ab si wecho e mashcham, “Ab o him g tash mamt wo chum tatchuad mant ia wo em‑wehmajk chum hems hemako tash ab ahni Jiosh si Kehsha. Nt wabshaba pi ia hu wo haꞌichugk. ");
INSERT INTO oodNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Haꞌi at hab wo kaijjid ‘Gad g hu wo neid g Jiosh si Kehsha’ o ‘Ia g hu wo neid.’ Mt wabshaba pi am hu wo i ni‑gahghi. ");
INSERT INTO oodNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wehsko ant wo ni‑chehgi mant hekid ep wo jiwia jewed dahm hab sha masma mat g wepgi s‑masma an gahi wo kekiwua chewagi ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nt wabshaba hemu muꞌi wo ni‑shoꞌigch. T pi ab hu wo ni‑tatchua idam hemajkam aiꞌi idani.” ");
INSERT INTO oodNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kush hab ep kaij g Jesus, “Bat wo masmak mant hekid ep wo jiwia mash wa hab chuꞌig eda mash g Noahbad in d doakam. ");
INSERT INTO oodNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Hemajkam ash wa gam ha wabsh i si nenead ch e gegosid ch ihꞌed ch e hohont ch gam hu wabsh i pi chegito g Jiosh. T haha wabsh e ai g tash mat hegam Noahbad am i wahp geꞌe wahlko ch ed. Kut mel g shuhdagi k ha wiꞌin k wehs ha kokda. ");
INSERT INTO oodNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Bat ep wo masmak mash wa hab masma mash wa g Lotbad in d doakam. Wehsijj ash gam hu wabsh i si nenead ch e gegosid ch ihꞌed ch haꞌichu ha nolawt ch haꞌichu gagda ch haꞌichu eꞌesha ch kihkit. ");
INSERT INTO oodNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kutsh wa g Lotbad ab i wuhsh Sodom kihhim t amjed. Tsh g mei ch haꞌichu s‑mehidkam ab ha dahmjed i e iawua hab sha masma mo g juhki. Kutsh wehs e kokda. ");
INSERT INTO oodNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Bat wo wa masmak heg i tash mant am wo i ni‑maskogi. ");
INSERT INTO oodNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kut pi hedai am hu wo shaꞌi chum i wah e‑kih ed mat am wo haꞌichu ui, chum as hems imhab wo waꞌi oimmedad e‑kih wehgaj o am wo chikpanad oidag ch ed. ");
INSERT INTO oodNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pi at chum hems wo s‑huwi g e‑kihdag. Batsh wa e juh g Lotbad hohnigbad k hekaj e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bat wa masma wo heb hu wua g e‑doakag hegai matp hedai wo chum s‑huwidad g e‑doakag hejel e wehhejed. T wabshaba wo doꞌibia g e‑doakag hegai matp hedai wo hekaj ni‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Tp hems gohk am wo kohkshad e‑kih ed ch hema gam hu wo i e be k hema am wo wih mant hekid ep wo jiwia. ");
INSERT INTO oodNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Gohk uꞌuwi atp hems am e wehm wo chuꞌad g pilkani. T hema gam hu wo i e be k hema am wo e wuiok.  ");
INSERT INTO oodNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Gohk oꞌodham at am wo oiopod oidag ch ed. T hema gm hu wo i e be k hema am wo e wuiok.” ");
INSERT INTO oodNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sh hab kaij g chuhchaij ab wui, “A t hebai hab wo i e juh ihda?” Sh hab kaij g Jesus, “Am at wo tashok mat hebai hab e juh. Namt hig pi wo mahchk mat hebai wo kahchk g muhki am neidch mo am e hemapadch g nunuwi? Pegih, mt hab waꞌap wo s‑ap s‑mahchk mat hebai hab wo i e juh ihda mani em‑ahgid. ");
INSERT INTO oodNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","“Chum amt hekid wo e hoꞌigeꞌidahunad am Jiosh wui ch pi hekid wo dagito,” bash kaij g Jesus ch am hahawa ha ahgid ihda haꞌichu wepogida ahga: ");
INSERT INTO oodNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Tp hems am hebai hema d usagakam ch wabshaba pi ab hu has elid g Jiosh ch pi ab hu ha haꞌichuchud g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","4","T am wui hema jiwia g hejel wiꞌikam uwi k ab tai mat am wo i wehmt namsh pi s‑lodaitamk. T pi ab hu wohog el. K wabshaba id chum hekid ab wui jijiwhia. “Kut hab i e ah g usagakam, ‘Chum ani hi wa pi ab hu has elid g Jiosh ch pi ab hu ha haꞌichuchud g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","K wabshaba shaꞌi si ni‑kudut ihda uwi ch wo am hu ni‑gewkoch pi ni‑dagitok. Nt heg hekaj am hab wo juni hegai mo ab ni‑chehani.’ ” ");
INSERT INTO oodNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Sh hab hahawa ep kaij g Jesus, “Neh, bat wo ha juni g pi apꞌekam usagakam hegai mo haschu chum hekid ab tahni. ");
INSERT INTO oodNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pegih, bamt wa masma chum hekid ab wo tahnid g Jiosh g i wehmtadag. ");
INSERT INTO oodNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kut s‑hohtam am wo i apꞌech haꞌichu am em‑wehhejed. T eda muꞌi am wo e chehgi mo pi woho ab hu ni‑hiwig mant hekid ia ep wo jiwia jewed dahm.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Haꞌi ash hab e elid g hemajkam mo d s‑apꞌekam ch eda hab ha elid haꞌi ehp mo d pi apꞌekam. Sh g Jesus am ha ahgid ihda haꞌichu wepogida ahga: ");
INSERT INTO oodNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Neh, gohk oꞌodham at am hihi geꞌe cheopi wui mat wo e hoꞌigeꞌidahu. K hema d Palasi ");
INSERT INTO oodNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ch am hejelko kehk ch am e hoꞌigeꞌidahun ch hab kaij, ‘Ab ani si m‑hoꞌigeꞌid, Jiosh, mani pi s‑banma ch pi hekid haꞌichu ha iattogid ch pi am hu hab junihim g s‑uam haꞌichu hab masma mo chum hedai hab e junihim. Ab ani m‑hoꞌigeꞌid mani pi hab masma mo hegai pi ap ha kowlantdam m an kehk. ");
INSERT INTO oodNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Gohk tash ani ni‑hoꞌigeꞌidahun ch pi haꞌichu koꞌa domig ed ch ab m‑mahk g hemako tahpani mo wehst‑mahm e tahpanch mani heꞌes haꞌichu ab i neid.’ Neh, bo wa masma e haschud g Palasi. ");
INSERT INTO oodNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“K wabshaba hegai hema ga hu wabsh mehk kehk ch pi e nako mas ab wo uhgk i nea dahm kahchim wui no pi si e shoꞌigchud. Id o hab kaij, ‘Jiosh, ab g si i s‑ni‑hoꞌigeꞌid ahni pi apꞌekam hemajkam.’ Neh, bo kaij hegai hema. ");
INSERT INTO oodNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Kunt wo em‑ahgi mat id am i apꞌech g Jiosh e tahgio. T s‑ap e taht k hih uhpam. T g Jiosh pi am hu i apꞌech hegai Palasi. Do wohokam mat g Jiosh wo haꞌichuch hegai mat hedai hejel pi wo e haꞌichuch k wo pi haꞌichuch hegai mat hejel wo chum e‑haꞌichuch.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sh haꞌi g oꞌodham am ha uꞌapa g al chuꞌuchum aꞌal Jesus wui mat ab wo ha taht. Kush g chuhchaij ha neid ch chum s‑ha kehꞌid mo hab e wua. ");
INSERT INTO oodNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tsh wabshaba g Jesus ab i ha wai g aꞌal k hab kaij ab ha wui g e‑chuhchai, “Ab g wabsh wo i ha hiwgid g aꞌal mat ab wo i hihi ni‑wui k pi an hu wo shaꞌi ha shohbi. Am at wabsh s‑moimam wo i wahp Jiosh kownaltalig ed ab ni‑hiwigch. ");
INSERT INTO oodNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nt wo si shel em‑ahgi mamt hab waꞌi masma wo i wahp.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kush hema g Tutuligo ha wanimeddam ab kakke g Jesus ch hab kaij, “Ha mashchamdam map d s‑apꞌekam, shahchu ant am hab wo juh mant ab wo bei g pi ha huhugedam doakag?” ");
INSERT INTO oodNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sh hab kaij g Jesus, “Pi ap mahch map haschu ahgch hab ni‑aꞌaga mani d s‑apꞌekam. Heg o waꞌi Jiosh d s‑apꞌekam. Kup pi woho mahch mani hedai wud. ");
INSERT INTO oodNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","S‑ha ap mahch idam chehanig mo hab chuꞌig: Pi g am hu ha ehsidad g ha‑wehm kihkam. Pi g am hu ha muaꞌi g oꞌodham. Pi g am hu haꞌichu ha ehsidad. Pi g am hu haꞌichu ha iattogidad. Ab g si has ha elidad g e‑ohg ch e‑jeꞌe.” Neh, bash kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Sh hab kaij ihda oꞌodham, “Wehs ihda ani hab junihim ged hu i ni‑alijk amjed.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tsh am i kah g Jesus ihda k hab kaij ab wui, “Hemako haꞌichu o am wiꞌis mapt am hab wo juh. Wehs apt wo gagda map haschu i edgid k wo ha mah g namkigaj g shoꞌigkam k ab wo i ni‑oid k am wo ni‑wehmajk. Bapt masma wo edgidad g s‑kaistalig an dahm kahchim ch ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tsh si pi ap e taht ihda oꞌodham am i kaiok nash pi d shaꞌi si s‑kais ch si s‑huwid g s‑e‑kaisdag. ");
INSERT INTO oodNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tsh am i nei g Jesus mo pi ap e tahtk k hab kaij, “Shaꞌat waꞌi si s‑kawkam wo i wahp Jiosh kownaltalig ed hegam mo d s‑kakais. ");
INSERT INTO oodNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nam hig hab elid mat wo e nako g ka‑mihyo mas am wo gahi wuhsh hoꞌipad jeg ed. Pegih, t hab wa masma pi wo e nako hegam mo hiwig g haꞌichu e‑eniga mas am wo i wahp Jiosh kownaltalig ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sh hab kaij idam, “A t hedai wo e nako mat wo e doꞌibia.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sh g Jesus hab kaij, “Pi at hedai wo e nako mas hejel wo e doꞌibia. T wabshaba g Jiosh wo e nako mat wo ha doꞌibia.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Sh g Peter hab kaij, “Neh, ahchim att am i dagito g t‑kihdag matt wo i m‑oi.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Sh hab kaij g Jesus ab ha wui, “Woho amt hab e juh. Kunt am wo em‑ahgi mat g Jiosh baꞌich i geꞌe haꞌichu ab wo em‑mah ia jewed dahm ahpim mamt hedai wo dagito g e‑kihdag o g e‑wehm kihkam o g e‑wepnag o g e‑jehj o g e‑aꞌaliga wehhejed g Jiosh kownaltalig. T am i dahm g pi ha huhugedam apꞌedag ab wo em‑mah e‑kihdag ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kutsh am hejelko i ha ui hegam gamai gohk e‑chuhchai k hab kaij ab ha wui, “Neh, am att wo hihi Jerusalem wui. T am hab wo e juh am ni‑tahgio hegai mo wa g kekelibad Jiosh haꞌichu i tashogiddam an oꞌohan ab ni‑amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Am amt wo i ni‑dagito ha wui g gawul mahs hemajkam. T hegam wo nahnko ni‑ahgad ch ab wo ni‑siswuimad ");
INSERT INTO oodNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ch wo ni‑gewittan k hahawa wo ni‑mua. Nt wabshaba ep wo ni‑chegito mat d wo i waik tashk amjed.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kush wabshaba pi shaꞌi amichud mas haschu hab ahg g Jesus. Heg o wa wepo mo e eꞌestokch g haꞌichu ahgaj. ");
INSERT INTO oodNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sh am hihim hegam Jesus miabidch g Jerico. Sh g pi neadam am hema daha wohg hugid an ch haꞌichu ha nead. ");
INSERT INTO oodNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kutsh an bihbij. Sh id ha kah ch ab ha kakke mas haschu an has e wua. ");
INSERT INTO oodNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kumsh hab ahgid, “An o him hegai Jesus mo ab Nazareth t amjed.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Sh am si s‑kaidam hab kaij, “Jesus, ab g si i s‑ni‑hoꞌigeꞌid, ahpi map d t‑kownaligbad David amjedkam.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sh hegam mash am baꞌich hihim g Jesus si s‑kehꞌid ch hab ahg mat wo pi shahmuni. Kush wabshaba haha wabsh baꞌich i s‑kaidam hab kaij, “Ab g si i s‑ni‑hoꞌigeꞌid, ahpi Davidbad amjedkam.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tsh am hahawa i kekiwua g Jesus k ha chehani mat ab wo i e bek g pi neadam oꞌodham. Tsh am i jiwia. Sh hab kaij g Jesus ab wui, ");
INSERT INTO oodNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Shahchu ant hab wo m‑juni?” Sh hab kaij ihda, “Ni‑kownalig, chum ani tatchua mant ep wo haꞌichu neidad.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sh hab kaij g Jesus, “Haꞌichu g neid. Doa apt nap pi ab ni‑hiwig.” ");
INSERT INTO oodNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tsh am ha hekaj wabsh s‑ap haꞌichu neid k ab si i hoꞌigeꞌel g Jiosh k gam hu i oi g Jesus. Tsh am i nei g muꞌi hemajkam ihda k wehsijj ab si ihm g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tsh am dada hegam Jesus Jerico t am k am wabsh gahi wo wuwha. ");
INSERT INTO oodNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Sh am hema chum si s‑neidamk g Jesus ch d uhgchu lial kowlantdam ch d si s‑kais ch ash hab chehgig Zackias. ");
INSERT INTO oodNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sh wabshaba shaꞌi muꞌij g hemajkam. Kush eda al shopolk ihda ch pi ap neid ");
INSERT INTO oodNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ch hekaj gam hu ha baꞌich meh g hemajkam k an i chesh uhs t an. ");
INSERT INTO oodNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tsh am i ai g Jesus mo an da k ash an uhgk i neid k hab kaij ab wui, “S‑hohtam g ab i huduni, Zackias. Ab ant wo jiwia m‑kih am.” ");
INSERT INTO oodNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kutsh ha hekaj ab i hud g Zackias k si s‑hehgig ch ab i wahki e‑kih ed. ");
INSERT INTO oodNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kush wehsijj g hemajkam si s‑juꞌujpij neneok ch hab kaij, “Ihda oꞌodham atki am wo i dahiwua heg kih am mo d wabsh pi ap hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tsh am i kekiwua g Zackias k hab kaij ab Jesus wui, “Nehꞌe, eda hugkam ant wo ha mah g shoꞌigkam g haꞌichu ni‑eniga k uhpam ep wo ha namkid giꞌikko e dahm mantp heꞌes i ha banmad.” ");
INSERT INTO oodNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sh hab kaij g Jesus ab wui, “Id o am chehgidch map wepo wohochudadag mo g t‑shohshon Abraham ch hekaj e doꞌibia id i tash ab. ");
INSERT INTO oodNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Id ant hekaj ia jiwia jewed dahm ahni Jiosh si Kehsha mant an wo i ha gahghim k wo ha doꞌibia g pi ap chuꞌijkam.” Neh, bash kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pi ash shaꞌi tash matsh gam hu wo dada idam Jesus Jerusalem t am. Kush hab e ahg g hemajkam mat si e ai mat am wo i wuhsh g Jiosh kownaltalig. Tsh heg hekaj am ha ahgi g Jesus ihda haꞌichu wepogida ahga ");
INSERT INTO oodNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","k hab kaij: “Hema o d sha s‑has haꞌichu id eda haꞌichu ni‑ahga. Kum am waid mehk jewed amjed mamt wo kownalch. ");
INSERT INTO oodNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","T pi koi him k ab i ha wai g wehst‑mahm e‑pionag k wehsijj g hemako ohla lial ab i ha mahkhi mat wo hekaj k am wo i muꞌidaj mat am wo i hih. ");
INSERT INTO oodNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","K eda muꞌijj pi hohhoꞌid g wehmaj oꞌodham ch am haꞌi i e chuhcha mat am wo hihim k hab wo chei mo pi hohhoꞌid mat d wo ha‑kownaligk ihda oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Kumt wa woho hab juh hegai s‑has haꞌichu oꞌodham mamt kownalch. T am i uhpam jiwia k am ha hekaj ha wai hegam e‑pionag mat am wo dada k am wo e ah mat heꞌekia i dahm nahto g lial heg amjed mat wa ab ha mah. ");
INSERT INTO oodNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“K g wehpegkam hab kaij am jiwiak, ‘Ni‑kownalig, wehst‑mahm lial ant nahto am dahm hegai hemako mapt ni‑mah.’ ");
INSERT INTO oodNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“K hab kaij g ahmoj, ‘S‑ap apt hab e juh k d si s‑wagimakam ni‑pionag. Bant wo m‑juh mapt wehst‑mahm kihhim wo nuhkud napt pi s‑ap nuhkud g al chuꞌuchum haꞌichu.’ ");
INSERT INTO oodNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“K hema ep hab epai kaij am jiwiak. ‘Ni‑kownalig, hetasp lial ant nahto am dahm hegai hemako mapt ni‑mah.’ ");
INSERT INTO oodNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“K id hab ahg g ahmoj, ‘Bant wo m‑juh mapt hetasp kihhim wo nuhkud.’ ");
INSERT INTO oodNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“K hema ep hab epai kaij am jiwiak. ‘Ni‑kownalig, m ia kahch g m‑lialiga. Gd ant hu si wuh pa‑nihda ch ed k ged hu si ehsto. ");
INSERT INTO oodNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","S‑m‑ehbid ani heg hekaj map s‑ta keꞌidama. Am ap wabsh uꞌu hegai map haschu pi chikpan ch am bahbhiam hegai haꞌichu bahidag mo pi d m‑esha.’ ");
INSERT INTO oodNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“K hab kaij g ahmoj ab wui, ‘Hegai map has i kaij ant hab masma wo m‑mohtoꞌi g chuꞌijig, ahpi s‑padmakam pion. S‑mahch apki mani s‑ta keꞌidama ch wabsh uꞌu hegai mani haschu pi chikpan ch ab i bahbhiam hegai haꞌichu bahidag mo pi d ni‑esha. ");
INSERT INTO oodNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Pegih neh, pt haschu ahgk pi am hu cheh g ni‑lialiga wahnko ch ed mant ab uhpam wo ui wehnadk hegai mat haschu ab mahmadt.’ ");
INSERT INTO oodNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","k hab hahawa kaij ab ha wui hegam mo am gegok, ‘Gam g wo si wohppoꞌid hegai lial k heg wo mah mat g wehst‑mahm lial nahto.’ ");
INSERT INTO oodNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“K hab kaij idam ab wui, ‘T‑kownalig, heki o hu wehst‑mahm lialiga.’ ");
INSERT INTO oodNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Sh hab kaij ab ha wui, ‘Pi at has e juh nat pi baꞌich haꞌichu ab ep wo i nei hegai mat s‑ap wo nuhkud g e‑nuhkuda. T wabshaba wo e wohppoꞌidach mo heꞌes al i chum nuhkud hegai mat pi ap wo nuhkud. ");
INSERT INTO oodNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kumt ab wo i ha uꞌu k wo ha kokda am ni‑tahgio hegam ni‑obga mo chum pi tatchua mant d wo ha‑kownaligk,’ bo kaij g ha‑ahmo id eda haꞌichu ni‑ahga.” ");
INSERT INTO oodNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kutsh gam hu hahawa hihi idam Jesus Jerusalem wui. Sh g Jesus am ha baꞌich him. ");
INSERT INTO oodNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kush gohk al kihhimag ch hab chehgig Bethphage ch Bethany ch ab hugidaj ab g Olive Uꞌus Kawulk. Tsh gohk am ha cheha g e‑chuhchai ");
INSERT INTO oodNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","k hab ha ahg, “Am g wo hihim heg wui kihhim m am mia kehk k am wo i wahp. T am wo hema e wulshch g wechij wuhlu mat koi shaꞌi e chesh. Id amt wo wulꞌok k ab wo i wanim. ");
INSERT INTO oodNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kutp hema wo sha em‑kakke mams haschu ahgk wulꞌo, mt hab wo ah mani ahni em‑mashchamdam tatchua.” ");
INSERT INTO oodNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kutsh wa woho am hihi hegam gohk. Kutsh hab masma hab e juh mash hab ha ahgid g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kush am wupulꞌok hegai wuhlu. Sh hab kaij g enigakam mas haschu ahgk am wulꞌo. ");
INSERT INTO oodNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Sh hab kaij hegam, “T‑mashchamdam o tatchua.” Kutsh ha hiwigi. ");
INSERT INTO oodNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tsh gam hu i wanim g wuhlu Jesus wui k an toa g e‑liliwa wuhlu dahm k an i cheshaj g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kush am him cheshajch. Sh idam g e‑liliwa am i toꞌahim wohg oidk. ");
INSERT INTO oodNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sh am i aihim g Jerusalem. K g wohg am agshp i huduni ab amjed g Olive Uꞌus Kawulk. Sh muꞌi hemajkam an ha wehgaj ch ab i hoꞌigeꞌid g Jiosh ch ab si ihm si s‑kaidam heg hekaj si geꞌe haꞌichu mo neidchkahim ch hab kaij: ");
INSERT INTO oodNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Jiosh at wo s‑m‑hoꞌigeꞌel ahpi mapt ia jiwia wehhejed. Si geꞌe s‑hehgig o an haꞌichug dahm kahchim ch ed ch si geꞌe has elidadag ab wui g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sh am haꞌi gegok g Palasi ch hab kaij ab wui g Jesus, “Ha mashchamdam, ha g chehani mat wo haꞌasa hab chei.” ");
INSERT INTO oodNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sh hab kaij g Jesus, “Neh, matp idam wo haꞌasa hab chei, kut chum hems g hohodai si s‑kaidam ab wo ihmad g Jiosh ni‑hekaj.” ");
INSERT INTO oodNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sh am i aihi g Jerusalem. Kutsh shosha g Jesus ");
INSERT INTO oodNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","k hab kaij, “Mat hu wo i s‑mahchk g Jerusalem t am hemajkam id i tashkaj mat has wo e juh k wo e doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ab o him g tash mat wo ha biha g ha‑obga k wo ka kuh ");
INSERT INTO oodNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","k s‑ap wo ha hugio wehsijj hegam mat am wo haꞌichugk k wehs wo wuahawua g kihhim. K pi shaꞌi mahch mat idani wo chum ha doꞌibia g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kutsh am hahawa hih g Jesus k ged hu jiwia geꞌe cheopi t am. Sh eda am haꞌi dadha geꞌe cheopi wehgaj ch am haꞌichu gagda. Kutsh gam hu si i ha wuwhas ");
INSERT INTO oodNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","hab kaijch ab ha wui, “Bo chuꞌig g Jiosh oꞌohana mo hab kaij g Jiosh: ‘Ahni o d ni‑wehhejedkam ihda geꞌe cheopi. T ab wui wo hihimad g hemajkam ch ab wo si has ni‑elidad.’ Neh, bo kaij g Jiosh. Kumt eda an be k am eda hab wabsh wua g hejel e‑tatchui ch chum hems haꞌichu s‑aꞌagi ha ehsid ab ha wui haꞌichu gagdach.” ");
INSERT INTO oodNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kush wehs tashkaj am ha mashcham g Jesus geꞌe cheopi ch ed. Sh hegam uꞌugchu papal ch chehanig ha mashchamdam ch ha wanimeddam g hemajkam chum s‑muꞌamk. ");
INSERT INTO oodNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Sh wabshaba g hemajkam chum hekid ab si kaiham. Kush heg hekaj pi e nakog hegam mash chum s‑muꞌamk. ");
INSERT INTO oodNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sh am hu hebai g Jesus am ha mashcham g hemajkam geꞌe cheopi ch ed ch am ha ahgid g s‑kehg haꞌichu ahgaj g Jiosh. Kutsh am dada g uꞌugchu papal ch chehanig ha mashchamdam ha wehm g geꞌeged ");
INSERT INTO oodNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","k hab kaij ab wui, “Dohp hab chum elid map ab amjed ab uꞌukch g e‑gewkdag ch am hab haꞌichu wua. Oi g am t‑ahgid.” ");
INSERT INTO oodNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sh hab kaij g Jesus ab ha wui, “Pegih, nt ahni wehpeg ab epai haꞌichu wo em‑kakke. Am g wo ni‑ahgid ");
INSERT INTO oodNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","mams hedai hab elid mat ab mah g Johnbad g gewkdag mat wo ha pahl wapko. Nat g Jiosh ab mah aha nat wabsh g oꞌodham?” ");
INSERT INTO oodNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kush idam am wabsh hejel si aꞌaga ch hab kaij, “Shahtt hig wo chei? T ab wo t‑kakke matt haschu ahgk pi ab hu wohoch mattp hab wo chei mo ab Jiosh amjed uꞌukch g gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","T g hemajkam wo t‑maꞌichshul mattp hab wo chei mo ab wabsh oꞌodham amjed uꞌukch. Muꞌijj o hab elid mo d Jiosh haꞌichu i tashogiddam.” ");
INSERT INTO oodNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Neh, bash kaij ch ab hahawa uhpam i e nohnogi Jesus wui k hab kaij, “Pi ach shaꞌi mahch mas hedai amjed ab uꞌukch g e‑gewkdag.” ");
INSERT INTO oodNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sh hab kaij g Jesus ab ha wui, “Pegih, nt ahni hab waꞌap pi wo em‑ahgi mani hedai amjed uꞌukch g ni‑gewkdag ch hab wua wehs ihda.” ");
INSERT INTO oodNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Neh, bash kaij g Jesus ch am hahawa ha ahgid g hemajkam ihda haꞌichu wepogida ahga hab kaijch: “Neh, matp hems hema am ei g uhdwis e‑oid ed k hab hahawa i e ah mat gam hu hasko mehk wo him k pi oi wo jiwia. Kut haꞌi wo nuhkudad g oidaj ch wo namkid hegai mo haschu ab d i chum wuikamaj. Pegih, t am ha shulig k gam hu hih. ");
INSERT INTO oodNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kut am i e ai mat wo bai g uhdwis. T am hema cheha g e‑pionag mat am wo him k ab wo i uꞌidk g wuikamaj. T wabshaba g nuhkuddam gewichkwua g piongaj k pi haꞌichu shaꞌi mah. Kut gam hu uhpam hih. ");
INSERT INTO oodNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“T g enigakam hema ep cheha g e‑pionag mat am wo hih. T id ep gewichkwua g nuhkuddam k si s‑ta edam shoꞌigchud k pi haꞌichu shaꞌi mah. T gam hu uhpam hih. ");
INSERT INTO oodNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“T g enigakam hema ep cheha mat am wo hih. T hab waꞌap s‑koꞌokam has juh k gam hu si wuhshad. ");
INSERT INTO oodNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“K hab hahawa kaij g uhdwis oidag enigakam, ‘Neh, si ni‑tatchuidch ni‑alidag ant wo cheha mat am wo hih. Heg at hemho ab wo wa has el.’ ");
INSERT INTO oodNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“T heg gan hu hih. T wabshaba ab i nei hegam nuhkuddam k hab kaij ab aꞌai e wui, ‘Id o d enigakam alidag. Tt hig wo mua. T d wo t‑enigak g uhdwis oidag.’ ");
INSERT INTO oodNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","T wa woho hab e juh k gam hu si i wuhshad ab amjed g uhdwis oidag k am i mua.” K hab hahawa ep kaij g Jesus, ");
INSERT INTO oodNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Neh, nat hig pi woho wo ha kokda g oidag enigakam k am haꞌi ep wo ha hiwigi mat wo nuhkud.” Tsh am i kah ihda g hemajkam k hab kaij, “Ih, pi at woho hab wo e juh hegai map am t‑ahgid.” ");
INSERT INTO oodNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kush ab si ha neid g Jesus ch hab kaij, “Woho at hab wo e juh. K g Jiosh oꞌohana am tashogid mamt hab wa masma wo s‑ni‑ohhod. Id o hab ahgch hab chuꞌig g wepogida ahga Jiosh oꞌohana ed: Kihtdam at wo chum hema s‑ohhodam g hodai. T wabshaba id d wo si s‑has haꞌichu hodaik am ha‑kihta wehhejed. Neh, bo chuꞌig g Jiosh oꞌohana. ");
INSERT INTO oodNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kut wo e shoꞌigch hegam mat pi wo ni‑amich. Id at heg wo wa wepok mat ab wo e keiko hodai t ab. Kut wo bei g s‑koꞌok e‑namkidadag hegam mat wo s‑ni‑ohhod. Id at heg wo wa wepok mat g hodai ab ha ab wo gehsh k am wabsh wo s‑ha wia.” ");
INSERT INTO oodNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Neh, bash kaij g Jesus ch hegam hab ha ahg chehanig ha mashchamdam ch uꞌugchu papal. Kutsh hegam heg hekaj wabsh chum si s‑behim. Sh wabshaba muꞌijj g hemajkam ab si has elid g Jesus. Sh idam ha mashchamdam ch papal s‑ha ehbid ch pi am hu be ");
INSERT INTO oodNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","k wabsh am s‑nenꞌoid mat am wo ha apꞌet. Tp hems haꞌichu hab wo chei mat heg ab wo abchud k an wo be k am wo i dagito kownal wui. Tsh heg hekaj haꞌi ha namkid mat am wui wo hihim k ab wo haꞌichu kakke k wo heki himch. ");
INSERT INTO oodNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sh hab kaij idam ab wui, “Ha mashchamdam, s‑mahch ach map wabsh chum hedai ha mashcham g wohokam ab amjed g Jiosh himdag, chum as has wo chei hedai i. ");
INSERT INTO oodNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pegih, k am wo t‑ahgi maps has elid g geꞌe kownal kowlanta. No hig t‑hiwgid g t‑chehanig ahchim Tutuligo matt wo ha namkid aha no pi t‑hiwgid?” ");
INSERT INTO oodNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sh wabshaba g Jesus s‑ha amichud mo g pi apꞌekam hab elid ch hab ha ahg, ");
INSERT INTO oodNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ab g wo hema ni‑chehgid hegai lial mam hekaj ha namkid.” Kumtsh ab hema chehgi. Kush hab ha ahg, “Am g wo ni‑ahgid mo hedai wuhiosha ch hedai chehgig ab oꞌohadag id ab lial?” Sh hab kaij idam, “Hegai mo d uhgchu t‑kownalig.” ");
INSERT INTO oodNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Sh hab hahawa ep kaij g Jesus, “Pegih, ab g wo i dagito kownal wui hegai matp d enigaj k am epai wo i dagito Jiosh wui mo haschu d epai enigaj.” ");
INSERT INTO oodNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kutsh pi e nako idam mas wo heki himch am ha tahgio g hemajkam k oi wa am wabsh i pi has kaij ch si has i el mat has masma ab i nodagi g ha‑kakkei. ");
INSERT INTO oodNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsh am haꞌi dada Jesus wui hegam mash hab e aꞌaga Sajusi. Idam o d ha wohochudadag mat g Jiosh pi ep wo ha chegitoich g koꞌi. Sh ab kakke idam ch hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ha mashchamdam, an o hab chuꞌig ihda chehanigaj g Jiosh Mosesbad oꞌohana ed ch hab chuꞌig matsh g oidchkam wehngaj hegai mat wo muh pi ha aꞌaligak hemho wo wa bei g hohnigaj g e‑wehnagbad. Tsh g aꞌaligaj hab masma wo e kuint mat d wo aꞌaligajk hegai mat muh. ");
INSERT INTO oodNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pegih, k am hu hebai wewaꞌak d e‑wepngam. Kut g si geꞌechu ge hohnt k pi ha aꞌalidtok am i muh. ");
INSERT INTO oodNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","T g oidchkam an bei ihda uwi k hab waꞌap muh. ");
INSERT INTO oodNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","T amjed g waikkokam an be k hab waꞌap muh. T wehsijj hab e juh idam wewaꞌak mat pi ha aꞌalidtok koꞌo k huhug. ");
INSERT INTO oodNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","T gam hu si ha oidk heg ep muh uwi. ");
INSERT INTO oodNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pegih, k idam wehsijj hohnigkahim. Kut hedai d wo hohnigk matp g koꞌi ep wo i wuwha?” ");
INSERT INTO oodNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sh g Jesus hab kaij ab ha wui, “Ia o waꞌi e hohont g hemajkam jewed dahm. ");
INSERT INTO oodNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","K wabshaba pi hab chuꞌig an Jiosh kihdag ed. Jiosh at uhpam wo ha chegitoich g e‑doꞌibiakam k am wo i ha wahpki e‑kihdag ed. T hahawa pi wo e hohontad ch pi wo koꞌod hab masma mo g anghil hab chuꞌig. ");
INSERT INTO oodNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mosesbad atki wa an oꞌoha mash wa g Jiosh am e chehgid wui heg hekaj shaꞌi mash meihid ch pi meitto. Sh hab kaij g Jiosh: Ahni ani d ha‑Jioshga hegam Abraham ch Isaac ch Jacob. Neh, id o hab kaij g Jiosh, chum as heki hu koi, no pi am e wehm ha nuhkud ch ab uhpam wo i ha wuwhas muhkig amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pi amt wabsh woho wo i huhug am i koꞌok matp g Jiosh d em‑Jioshga.” Neh, bash kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kush haꞌi hegam mo d chehanig ha mashchamdam ab neneok ch hab kaij, “S‑ap apt hab chei, ha mashchamdam.” ");
INSERT INTO oodNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tsh amjed pi hedai e nako mas ab haꞌichu ep wo kakke. ");
INSERT INTO oodNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sh hab kaij g Jesus ab ha wui, “Am g wo oidahim mas hedai d wo Jiosh si Kehshak. Bo e aꞌaga matsh d wo amjedkamk hegai t‑kownaligbad mash hab chehgig David. ");
INSERT INTO oodNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kush wa eda g Davidbad hab aꞌaga ‘ni‑kownalig’ natsh oꞌoha ihda mo an hab chuꞌig neꞌi ed heg eda Jiosh heki hu oꞌohana: Bo kaij g Jiosh ab ni‑kownalig wui: In g dahiwua s‑apkojed ni‑hugid an. ");
INSERT INTO oodNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kunt wo ha gewito g m‑obga mat ab wabsh s‑ap wo m‑wechok. ");
INSERT INTO oodNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Neh, namt hig s‑ap wo ah mat has masma d wo Davidbad amjedkamk ihda mash d kownaligaj?” ");
INSERT INTO oodNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kush wehsijj ab si kaiham g Jesus hegam muꞌi hemajkam. Kush ab ha ahgid g e‑chuhchai ch hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Hegam mo d chum chehanig em‑mashchamdam o am si s‑apko dadhaiwup cheopi ch ed ch geꞌe gegosig ch ed. Si o s‑kehg e enigadad ch an oiopo no pi tatchua mamt ab wo si has ha elidad. Kumt wo s‑e nenꞌoidad mamt pi hab wo masmak mo hegam. ");
INSERT INTO oodNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chum as si chew e hoꞌigeꞌidahun am em‑tahgio ch eda haꞌichu s‑aꞌagi ha wohppoꞌid hegam mo d heheꞌejel wiꞌikam. T g Jiosh baꞌich i s‑koꞌokam wo ha namkid heg hekaj pi ap ha‑chuꞌijig no pi wabsh pehegia e hoꞌigeꞌidahun ch hab wua ihda pi apꞌekam.” ");
INSERT INTO oodNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sh am hu hebai dadha idam Jesus mash am e shulig g ha‑mahkigdag am wehhejed g geꞌe cheopi. Kush g s‑kakais muꞌi am shulig g lial. ");
INSERT INTO oodNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tsh am hema jiwia g al shoꞌigkam oks mash d hejel wiꞌikam k atsh gohk s‑oꞌamchu am shul. Kush am neid g Jesus ");
INSERT INTO oodNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ch hab ha ahg g e‑chuhchai, “Neh, ihda al shoꞌigkam oks at baꞌich i geꞌe mahkigdag hab juh mo hegam s‑kakais. ");
INSERT INTO oodNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hegam o ab wabsh mahk hegai mo haschu i pi tatchua no pi wabsh s‑lialiga. T wabshaba ihda al oks wehs mah mo haschu al i edgid mat hekaj wo chum kihdagk.” ");
INSERT INTO oodNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kush am haꞌi neneok ab amjed g geꞌe cheopi ch am aꞌaga mo si s‑kehg hab mahs ch si s‑kehg hohodaikaj hab junis ch si s‑kehg mahkigdagkaj e heosid. Sh hab kaij g Jesus, ");
INSERT INTO oodNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Heuꞌu. Nt wabshaba wo si shel em‑ahgi mo e aihim mat wehs wo i e shul ihda mam neid.” ");
INSERT INTO oodNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sh g chuhchaij ab kakke ch hab kaij, “Hekid at hab wo i e juh ihda? Kut haschu d wo chehgidak matt heg ab wo s‑mahchk mo e aihim matki am hab wo e juh?” ");
INSERT INTO oodNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sh hab kaij g Jesus, “Mt wo s‑e nenꞌoidad ch pi am hu wo e iattogi. Muꞌi at an wo i wuwha aꞌahidag oidam k ni‑wepo wo e chehcheg hab kaijch mo d Jiosh si Kehsha ch hab wo chei mat e ai g tash. Pi g am hu wo i ha oid idam. ");
INSERT INTO oodNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","An at wo kaida mo am hahasko aꞌai e cheggia g jejewed. Kumt wabshaba pi heg hekaj wo e kudutad, chum as hems wo wohok. Hemho wa at hab wo mahsk haꞌichu wehpeg. K wabshaba pi hab d ahga mat e ai mat wo huhug g jewed. ");
INSERT INTO oodNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jejewed at ab aꞌai wo i e cheggia. ");
INSERT INTO oodNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","T an aꞌai hab wo e juh mat g jewed shaꞌi s‑ta ehbidam wo uꞌugij. T g bihugig wo gehsh k g s‑cheawagig ab wo i hih. S‑ta ehbidam haꞌichu at am wo i e chehgi ab dahm kahchim t amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Mat koi hab wo e juh ihda, kumt an wo em‑uꞌu k wo em‑shoꞌigchud k am wo em‑uꞌapa chechopi ha wui k wo em‑kuh. Kumt wo e lodai am ha tahgio g kokownal nam pi ab s‑ni‑wohochud. ");
INSERT INTO oodNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Id at am wo em‑apꞌet mamt am wo ah g s‑kehg haꞌichu ahgaj g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pi g am heki hu wo e kudutad heg hekaj mamt has wo chei hejel e wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ab ant wo em‑mah g neꞌoki ch amichudadag. Kut pi wo e nako g em‑obga mas ab wo wui kekiwua mamt has wo chei. ");
INSERT INTO oodNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Em‑jehj ch em‑wepnag ch em‑hajuni ch em‑naipijju at am wo i em‑dagito ha wui g hahaꞌichu. Kumt haꞌijj wo e koꞌij. ");
INSERT INTO oodNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Muꞌijj at wo s‑em‑kehꞌel nam pi ab ni‑hiwig. ");
INSERT INTO oodNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mt wabshaba s‑ap am wo gahi wuwha mamtp has wo i em‑juh ");
INSERT INTO oodNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","k wabsh wo s‑ha bahbgi. T g Jiosh wo em‑doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Shondal at an wo biha g Jerusalem. Kumt hab wo s‑mahchk mo e aihim mat oi wo e padch g kihhim. ");
INSERT INTO oodNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hemho wa at am wo ahhio dohdaꞌag wui hegam mat am wo haꞌichugk Judea chekshani ch ed. T hegam mo am haꞌichug Jerusalem kihhim t am hemho wa wo ahhio ab amjed. Kut hegam mo gam hu wabsh jegko kih pi am hu wo i wahp kihhim ch ed ");
INSERT INTO oodNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","nat pi wo e ai mat wo s‑koꞌokam ha namkid g Jiosh k am wo wohokamch wehs hegai mo an oꞌohanas oꞌohanaj ed. ");
INSERT INTO oodNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ih shoꞌig! S‑ta at ehbidam wo mahsk am ha wehhejed hegam mat wo chuꞌuchum mahmadk ch hegam mat wabsh wo kia woꞌok g ali. Ab at wo i hih g geꞌe shoꞌigdag id dahm jewed. T g s‑koꞌok ha‑namkidadag ab wo gei ha ab idam hemajkam heg hekaj ha‑chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mt wo haꞌi ha kokda k wo haꞌi ha lilsochud k gam hu wo i ha ui mehk jewed wui. Kut g gawul mahs hemajkam an wo bei ihda Jerusalem k ia wo i e chiwiadad am hugkam mat wo kuhgit g ha‑apꞌedag g gawul mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","“T wo e uꞌugij mo haschu an hab chuꞌig t‑dahm. Kut s‑ta ehbidam hab wo e juh g tash ch mashad ch huhuꞌu k wo dagito g e‑wopogga. Kut g ge shuhdagi an wo wewgad ch an wo toꞌotonkad. T id wehs wo chehgi mat geꞌe haꞌichu hab wo e juh wehsko jewed dahm. T g hemajkam wo si s‑ehbidad wehs jejewed ch ed ch wo s‑e chuhug nat ge wo mahchk mat haschu has wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kunt ab hahawa si s‑masma wo i hud chewagi ch ed ab Jiosh kihdag amjed ahni Jiosh si Kehsha. Kut am wo e maskogi g ni‑gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bat masma wo e chehgi mo ab e aihim g ha‑doꞌibiadag hegam mat ab wo ni‑hiwgad. Kut heg hekaj wo chum si s‑ap e taht mat hekid wo i shonwua ihda mani em‑ahgid.” ");
INSERT INTO oodNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Tsh amjed g Jesus am ha ahgi ihda haꞌichu wepogida ahga, “Neh, mt wo s‑mahchk mo g toniabkam e aihim mamt wo nei mat g suhna jeꞌe ch nahnko mahs uꞌus ab wo i iꞌiwgi. ");
INSERT INTO oodNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","K hab wa masma hab mahs mamt wo nei mat hab wo e juh idam mani am heki hu em‑ahgid k wo s‑mahchk mo e aihim mant ep wo jiwia. ");
INSERT INTO oodNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Neh, hegam mat wo nei ihda mani em‑ahgid at d wabsh wo kia dodakamk jewed dahm mat hekid wehs am hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Wehs am gam hu hab wo i e juh ihda Jiosh nahtoi mam in neid. T wabshaba g ni‑neꞌoki pi hekid gam hu hab wo i e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Si g wo s‑e nenꞌoidad mat haha wabsh wo em‑ai hegai tash. Mt am hu pi wo mahchk. Pi g am wo shaꞌi e hiwgid mamt wabsh si muꞌi haꞌichu k ed wo e nakogad ch wo si e gegosidad ch wo nawkkoꞌod ch g e‑kihdagkaj wo e kudutad. ");
INSERT INTO oodNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hegai tash at am hab haha wabsh wo si e juh wehs hemajkam ha tahgio. ");
INSERT INTO oodNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mt wo si s‑e nenꞌoidad ch wo e hoꞌigeꞌidahunad chum hekid mamt ab wo uꞌukch g gewkdag ch s‑ap am gahi wo wuhsh wehs ihda mat am hab wo e juh. Nt pi an hu haꞌichu wo em‑abch ahni Jiosh si Kehsha mamt hekid wo ha lodai g hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Sh g Jesus wehs tashkaj am ha mashcham geꞌe cheopi ch ed. Kush muꞌijj am wui daiw wabsh i sisiꞌalimad mat ab wo kaiha. Sh am i huhuduk, sh gam hu hihhim idam Jesus Olive Uꞌus Kawulk wui ch am koksho. ");
INSERT INTO oodNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sh am i e aihim mash eda e wushshad matsh wa g Jiosh ha doꞌibia g ha‑shohshonbad. Sh heg eda pi e koꞌa hegai pahn mo jewajidas. ");
INSERT INTO oodNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sh g uꞌugchu papal ch chehanig ha mashchamdam am wabsh s‑aꞌagi e nakog matsh wo mua g Jesus ch wabshaba s‑ha ehbid g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kutsh g ge Jiawul Satan an bei g Judas Iscariot. ");
INSERT INTO oodNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tsh id am i ha dagito hegam Jesus k am him k am ha wehm aꞌaga g uꞌugchu papal ch geꞌe cheopi nuhkuddam ha‑geꞌegeꞌejig mat has masma am wo i dagito g Jesus ha wui. ");
INSERT INTO oodNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tsh si s‑hohhoꞌi idam k ab si ahgi mat wo namkid. ");
INSERT INTO oodNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tsh amjed am i e nako g Judas mat am wo neidad mat s‑aꞌagi wo gagda g Jesus ab ha wui. T pi wo mahchk g hemajkam ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tsh am hahawa s‑ap i e ai hegai ha‑shohshonbad ha‑doꞌibiadag piast. Kush d wehpeg tash matsh eda wo e kokda g kahwal mahmad. ");
INSERT INTO oodNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sh g Jesus hab ha ahg g Peter ch John, “Am g wo hihim k am wo i apꞌech g t‑gegosig matt wo wuhshad g t‑shohshon ha‑doꞌibiadag.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kush hab kaij hegam, “Bahtt hab wo juh g t‑gegosig?” ");
INSERT INTO oodNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sh hab kaij, “Neh, am amt wo hihi Jerusalem wui. T ab hema wo himad g cheoj ch wo waꞌigchugad ab haꞌa t ab. Kumt am wo i oi. Kut am hu hebai wo him k am wo i wah hema kih ed. ");
INSERT INTO oodNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kumt hab wo chei ab wui g kihkam, ‘Neh, s‑mahchimk o g t‑mashchamdam mas an hebai i ha wiꞌis matt wo wuhshad g t‑shohshon ha‑doꞌibiadag.’ ");
INSERT INTO oodNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kut am wo hema em‑chehgi g kih. T id gan hu ha‑kih dahm hab wo chuꞌigk ch wo geꞌejk ch am wo apchudask. Kumt an haꞌab wo i apꞌech g t‑gegosig” ");
INSERT INTO oodNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kutsh wa woho am hihi idam kihhim wui. Tsh wa woho s‑ap am hab e juh mash has i ha ahg. Kutsh am i apꞌech g gegosig. ");
INSERT INTO oodNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tsh am i hud. Kutsh am hahawa dada hegam haꞌi. Tsh g Jesus am i dahiwua mihsa wui. Tsh g chuhchaij am ep dadhaiwua. ");
INSERT INTO oodNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kush hab kaij ab ha wui, “Si ani tatchua mant wo em‑wehm huh ihda gegosig mant koi wo ni‑muhkid ");
INSERT INTO oodNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","nant pi pi hekid ia hu em‑wehm ep wo huh ihda hab mahs gegosig. T wabshaba ab wo e ai mat wo s‑ap e nahto g em‑doꞌibiadag. Kumt an wo ni‑wehmajk dahm kahchim ch ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mtsh ab hahawa mah g nawait am tahsa ch ed. Kutsh ab i hoꞌigeꞌel g Jiosh k hab kaij ab ha wui, “Ab g wo behꞌi ihda k wehsijj ab wo ha ih. ");
INSERT INTO oodNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Neh, ahni ant pi hekid ab hu ep wo ih ihda uhdwis wadag k ab wo ai mat wo e nahto g Jiosh kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Neh, bash kaij ch am hahawa bei g chemait k ab hoꞌigeꞌel g Jiosh k am i hahain k hab kaij, “Do ni‑honshpadag ihda mant am i em‑hahaini. Id ani hab ahgch hab kaij mant wo ni‑muhkid am em‑wehhejed. Ab g wo huhgi ihda hahainig k id chum hekid am hab wo junihid mamt hekaj wo s‑ni‑chegitok.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tsh ab hahawa ep ha mah g wasib k hab kaij, “Do ni‑ehꞌed ihda nawait. Id ani hab ahgch hab kaij mat g ni‑ehꞌed wo e iawua mat hekaj am hab wo e juh hegai mo wa g Jiosh hab kaij matsh hab wo em‑juni. ");
INSERT INTO oodNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Neh, hegai mat wo ni‑gagda o ia ni‑wehm daha mihsa wui. ");
INSERT INTO oodNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bant wa masma wo ni‑muhkid mat has masma g Jiosh am i apꞌech mat g si Kehshaj wo e muhkid. T wabshaba wo si s‑koꞌokam e namkid hegai mat wo ni‑gagda.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tsh ab ha hekaj aꞌai i e kakke mas hedai wud wok ch hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kush am e neꞌowin hegam Jesus chuhchai am aꞌagadch mas hedai d wo si haꞌichuk am ha shahgid. ");
INSERT INTO oodNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","26","Sh hab kaij g Jesus ab ha wui, “Neh, ab am si e haꞌichuchud hab sha masma mo g kokownal. S‑mahch am mo hegam si s‑gewkam an ha uꞌukch g e‑hemajkamga. Kut hemho wa am hab wo junihid mo haschu ab ha chehani. Mt wabshaba ahpim pi hab masma am wo ha dahmkad g e‑wehm wohochuddam. Si amt s‑hemajim am wo i ha wehmtad. Hegam kokownal o tatchua mat g hemajkam hab wo ha elidad mo geꞌe haꞌichu hab ha junid. Mt wabshaba ahpim pi hab masma hab wo e elidad mam geꞌe haꞌichu hab ha junid g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Aha nam hig hab chum e elid mam d ha‑aꞌamo ch am wo dadhaiwua mat g em‑pionag wo em‑gegos? Ni eda ahni pi hab masma hab ni‑wua, chum anis d em‑kownalig ch wabshaba heg ni‑wepogid mani d em‑pionag. ");
INSERT INTO oodNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ahpim amt pi hekid shaꞌi ni‑dagito am oidam g haꞌichu ni‑nakogig, ");
INSERT INTO oodNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kunt heg hekaj wo em‑kokownalch hab masma mat g ni‑ohg Jiosh ni‑kownalch. ");
INSERT INTO oodNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mt am ni‑wehm wo e gegosidad ni‑kownaltalig ed. Kunt hab wo em‑juh mamt d wo uꞌusagakamk am ha dahm hegam gamai gohk kawod dakam Tutuligo hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kush hab kaij g Jesus ab Simon Peter wui, “Ih, Simon, Jiosh at wo hiwigi g ge Jiawul mat wehsijj wo em‑aꞌappe hab sha masma mat g pilkani hihkdam wo nehnich g e‑hihka k gam hu wo i gawulkai g mohgaj. Jiawul o hab chum e ahg mat gam hu hab wo i em‑juh hab masma mo g mohg. ");
INSERT INTO oodNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nt wabshaba ab i tai g Jiosh mat wo i gewkaj g m‑wohochudadag, Simon. Kupt am wo i ha gewkemhu g e‑wehm wohochuddam mapt hekid ab uhpam wo i e nodagi ni‑wui.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Sh hab kaij g Peter, “Ni‑kownalig, ni‑nahtokch ani mant wo ni‑kuhpachud k wo ni‑muhkid m‑wehm.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Sh hab kaij g Jesus, “Neh, Peter, pi at koi am hu wo kuhu g keli chuchul id i chuhug ab, kupt waikko hab wo chei map pi shaꞌi ni‑mahch.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sh hab ep kaij g Jesus ab ha wui, “Neh, namd haꞌichu i pi edagi mam wa ahgachug g haꞌichu ni‑ahga pi uꞌuk g e‑lial kokstal o g limoshana kokstal o g shuhshk?” Sh hab kaij hegam, “Pi haꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Sh hab hahawa ha ahg, “Mt wabshaba hemu an wo uꞌad g e‑lial kih ch e‑is‑pahyo chum ams hems wo gagda g e‑lihwa k hekaj wo hema ha nolawt g is‑pahyo. ");
INSERT INTO oodNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hemho wa at am hab wo e juh ihda mo ab ni‑amjed oꞌohanas ch hab chuꞌig: Bamt masma ab wo mohtoꞌi g chuꞌijig g Jiosh si Kehsha mamt g pi ap hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sh hab kaij hegam chuhchaij, “Pegih, t‑kownalig, m ia gohk wehch g iꞌis‑papayo.” Sh hab kaij g Jesus, “Neh, e at ai matt wo hihi.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tsh amjed gam hu hih g Jesus Olive Uꞌus Kawulk t ab mash hab wa e wua. Kutsh oi hegam chuhchaij. ");
INSERT INTO oodNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tsh am i dada amai. Sh hab kaij ab ha wui, “Am g wo e hoꞌigeꞌidahun mamt s‑ap wo nako g e‑aꞌappema.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Neh, tsh am hahawa ha dagito k am baꞌich shaꞌi him k am tonwua k e hoꞌigeꞌidahun ");
INSERT INTO oodNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","hab kaijch, “Ni‑ohg, matp am wo s‑apꞌek, pt gam hu hab hig wo i juh hegai si s‑koꞌok shoꞌigdag mo ab ni‑wui him. Kuni eda tatchua mat ahpi g m‑tatchui hab wo e juh.”  ");
INSERT INTO oodNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tsh am haha wabsh hema jiwia g anghil ab wui k ab si i gewkaj. ");
INSERT INTO oodNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kutsh si e kudut k am baꞌich haha wabsh si e hoꞌigeꞌidahu. Kush g wahuddaj am e iawua jewed dahm k d wabsh ehꞌed. ");
INSERT INTO oodNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tsh am i haꞌasa e hoꞌigeꞌidahun k am hih mash am dadha hegam chuhchaij. Kush am kohksh nash pi wabsh i ha baꞌiwich g pi ap tahhadkam. ");
INSERT INTO oodNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sh hab kaij ab ha wui, “Shahchu am ahgch kohksh? Ab g wo nehnen k wo e hoꞌigeꞌidahu mamt s‑ap wo nako g e‑aꞌappema.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sh am wabsh kia neok. Sh ab haꞌi ge hihim g hemajkam. Kush heg ha wanimed Judas mash d chum hema kehshaj g Jesus ch ab wui i hih matsh ab wo chintad. ");
INSERT INTO oodNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sh hab kaij g Jesus, “Ih, Judas, pt wo ni‑gagda ab ni‑chintadk ahni Jiosh si Kehsha!” ");
INSERT INTO oodNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tsh am i nei hegam haꞌi Jesus chuhchai mo haschu has e wua k hab kaij, “T‑kownalig, natt wo ha cheggia g iꞌis‑papayokaj?” ");
INSERT INTO oodNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kutsh hema ab si i widu g is‑pahyo k g uhgchu pahl neholiga nahk an si hikuch. ");
INSERT INTO oodNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sh hab kaij g Jesus, “Am g wo wa i haꞌasa,” k an taht ihda cheoj nahk k doaj. ");
INSERT INTO oodNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tsh am wui dada g uꞌugchu papal ch cheopi nuhkuddam ha‑geꞌegeꞌejig ch g geꞌeged mat an wo bei. Sh hab kaij g Jesus ab ha wui, “Bamki ni‑elid mani d s‑chu ehskam ch hab ia dada uꞌukch g iꞌis‑papayo ch uꞌus. ");
INSERT INTO oodNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Am ani em‑wehm haꞌichug cheopi t am wehs tashkaj. Kumt pi an hu ni‑bei. T wabshaba hemu am i em‑apꞌet. Pi apꞌekam at s‑ap am hab wo e juh s‑chuhugam k ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tsh an bei g Jesus k gam hu i bei uhgchu pahl kih wui. Sh g Peter ga hu wabsh mehkjed ha oid. ");
INSERT INTO oodNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kutsh eda am ge e nai kolhai ch ed. Kutsh am i jiwia g Peter k am ha wehm dahiwua hegam mo am dadha. ");
INSERT INTO oodNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kutsh am hema jiwia g chehia pion k am nei g Peter k ab si i neid k hab kaij, “Ihda oꞌodham o wa an wehmaj hegai mamt an bei.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tsh wabshaba pi mahch k e ah g Peter hab kaijch, “Pi ani shaꞌi mahch hegai.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sh am shaꞌi haꞌas. Kutsh am hema ep cheh g Peter k hab kaij, “Ahpi ap d hema hegam Jesus.” Sh wabshaba hab kaij g Peter, “Ih, pi o woho.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Sh am hu d i hemako ohla amjed. Kush hema oꞌodham am si e gewkaj ch hab kaij, “Woho o wa mo ihda oꞌodham hab d waꞌap ha wehm oꞌodham noki pi ab d kihkam Galilee chekshani ch ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sh hab kaij, “Pi ani shaꞌi mahch maps haschu hab ahg.” Neh, sh am wabsh kia neok. Tsh g keli chuchul am si ku. ");
INSERT INTO oodNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kutsh ab si e sikolkai g Jesus k ab si i nei g Peter. Tsh am wabsh si chegito g Peter g jesus neꞌoki mo wa hab kaij, “Koi at wo kuhu g keli chuchul, kupt waikko hab wo waꞌi chei map pi ni‑mahch.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tsh gam hu hahawa i wuhsh g Peter k si pi ap e tahtk ch shoak. ");
INSERT INTO oodNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sh hegam mash am nuhkud g jesus nahnko ahg ch an si maꞌish k wuh g wuhpuij ");
INSERT INTO oodNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","k ab si shonikkash ch hab ahg, “Am g hig t‑ahgid mas hedai ab m‑shonikka.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kush muꞌi nahnko ep s‑koꞌokam ahg. ");
INSERT INTO oodNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tsh am i mahsi. Kutsh am e nam hegam geꞌeged ch uꞌugchu papal ch chehanig ha mashchamdam mash d e jehnigiddam. Kumtsh am ha wui uꞌapa g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Sh idam hab kaij, “Am g t‑ahgid maps d Jiosh si Kehsha.” Sh hab kaij g Jesus, “Pi amt woho ab hu wo ni‑wohoch mantp am wo em‑ahgi mani hedai wud. ");
INSERT INTO oodNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kumt pi woho ab hu wo i nodagi hegai mantp haschu wo em‑kakke. ");
INSERT INTO oodNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nt wabshaba wo em‑ahgi mant iꞌajed an s‑apkojed hugidaj an wo dak g Jiosh ahni si Kehshaj.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kush wehsijj hab kaij, “A kuptp d Jiosh alidag?” Sh hab kaij ab ha wui, “Dani ahni.” ");
INSERT INTO oodNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Sh hab kaij hegam, “Neh, pi ach shaꞌi hema tatchua mat wo si s‑mahch k ah. Ahchim ach hejel kah mo si pi ap neok ab Jiosh t amjed ch hekaj wo chum e muhkid.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kutsh wehsijj hegam hahaꞌichu ab si e wehmt k am i bei g Jesus heg wui mash d kownal am Judea chekshani ch ed ch hab chehgig Pilate. ");
INSERT INTO oodNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Sh ab ha kaiham. Kush ab wui ab haꞌichu abchudahim g Jesus hab kaijch, “Neh, ihda oꞌodham o im hu hab wabsh i ha wawan g t‑hemajkamga hab ha ahgch mat pi wo namkid g geꞌe kownal. Kuch kah mo hab hejel e ahg mo d jiosh si Kehsha ch d uhg kownal. Kupt hemho wa wo mua.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kush ab kakke g Pilate g Jesus ch hab kaij, “Nap d ha‑kownalig g Tutuligo hemajkam?” Sh hab kaij g Jesus, “Dani ahni.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tsh g Pilate am i mamche hegai mam ab abchud. Sh eda muꞌi an oiopo g hemajkam s‑neidamk mo has e wua. Tsh g Pilate am ha kaichudk hab ha ah g uꞌugchu papal, “Pi ant haꞌichu shaꞌi cheh mas pi ap hab juh ihda oꞌodham mat heg hekaj wo e muhkid.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kush wabshaba baꞌich i e gewpkad ch hab kaij, “Am o ha chuꞌamun g t‑wehm oꞌodham haꞌichu ha mashchamch wehsko ga hu Galilee t amjed ch ia Judea ch ed ch chum hems iia Jerusalem ch ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tsh am i kah g Pilate ihda k hab kaij ab ha wui, “Kutp ab Galilee chekshani ch ed d kihkam ihda oꞌodham?” ");
INSERT INTO oodNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kumsh am ahgid mash am haꞌab d kihkam. Sh g Herod am d ha‑kownalig Galilee chekshani ch ed ch iaꞌi idani am hab waꞌap haꞌichug Jerusalem t am. Kumtsh heg hekaj am wui uꞌapa g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kush si s‑hehgig g Herod nash pi tash waꞌi chum s‑neidamk hab chum e ahgch matp hems am tahgio hab wo juh g s‑hasig haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kumtsh am kei tahgio. Kush muꞌi haꞌichu kakke. Sh wabshaba pi has shaꞌi kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kush g uꞌugchu papal ch chehanig ha mashchamdam am gegok ch si s‑gewkam ab haꞌichu abchud g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Sh g Herod g e‑shondalig ha wehm haha wabsh nahnko ahg g Jesus ch si ash k ash g si s‑kehg kahba ab wahki. Tsh ab hahawa ha cheha g Herod mat wo uhpam bei am Pilate wui. ");
INSERT INTO oodNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kutsh heg i tash ab g Pilate ch Herod ab hahawa e nawojt k ash eda chum s‑e kehꞌid. ");
INSERT INTO oodNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tsh g Pilate am i ha hemapai g uꞌugchu papal ch ha wanimeddam g hemajkam ");
INSERT INTO oodNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","k ash hab kaij ab ha wui, “Ia amt uꞌapa ihda oꞌodham ni‑wui hab kaijch mo goꞌolko ha wanimed g hemajkam. Kunt hemuch ia em‑kaichudk am i mamche hegai mam ab abchud k pi haꞌichu shaꞌi cheh mas pi ap hab junihi m. ");
INSERT INTO oodNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kutsh Herod hab waꞌap pi haꞌichu shaꞌi cheh. T g shondaligaj ab uhpam i uꞌapa t‑wui. Pi atki haꞌichu hab juh ihda mas heg hekaj wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kunt wabsh wo ha cheha mat wo gewittan k wo dagito.”  ");
INSERT INTO oodNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Neh, bash kaij nash pi am hema i dadagitosh g lihso ha wehhejed wehs ahid ab mo eda hab e wua hegai geꞌe gegosig. ");
INSERT INTO oodNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kush wehsijj hegam muꞌi hemajkam mo am haꞌichug si s‑kaidam hab kaij, “Pi ach tatchua ihda. Barabbas apt wo i dagito t‑wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Sh eda ihda Barabbas am e kuhpch nash pi chum haꞌi ha wehm cheggia g kownal ch haꞌi ha kokda. ");
INSERT INTO oodNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Sh am ep chum ha wehm neok g Pilate nash pi chum s‑dagitoimk g jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sh wabshaba am ep si s‑kaidam hab ge kaij muꞌikko, “Muꞌani! Muꞌani ab kots t ab!” ");
INSERT INTO oodNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sh hab ep chum kaij g Pilate, “A t haschu pi ap hab juh. Pi ant haꞌichu shaꞌi cheh mas heg hekaj wo e muhkid. Ab ant wo ha cheha mat wo gewittan k wo dagito.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sh wabshaba am wabsh si s‑kaidam hab kaij matsh ab wo naggia kots t ab. Neh, tsh g ha‑hihinki gewito g Pilate. ");
INSERT INTO oodNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tsh am i apꞌech mat am hab wo e juh g ha‑tatchui. ");
INSERT INTO oodNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kumtsh gam hu i wuhshad hegai mash d ha cheggiadkam ch d ha muꞌakam k amtsh g Jesus am i dagito ha wui mat am hab wo juh mo has i elid. ");
INSERT INTO oodNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kumtsh gam hu i bei g Jesus ab kushwiotachudk g kots. Kush am hu hebai hihim. Tsh ab hema i ha nam g oꞌodham mash ab him Jerusalem wui. Id ash hab chehgig Simon ch ab d kihkam mash am d Cyrene ch ash ab him ga hu oꞌoidag amjed. Kumtsh am wabsh si be k ab kushwiotach g kots k atsh hab juh mat ab oidk wo himad g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kush muꞌi hemajkam ab oidch hihim. Sh g uꞌuwi si shoanihim wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tsh ab i ha nei g Jesus k hab kaij ab ha wui, “Pi g am ni‑wehhejed wo shoanid, ahpim Jerusalem t am kihkam, ch wabshaba hejel e wehhejed ch e‑aꞌaliga ha wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ab o him g tash mat hab wo chei g hemajkam mo si haꞌichu s‑ha abamk hegam uꞌuwi mat pi hekid shaꞌi mahmadt. ");
INSERT INTO oodNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","31","Woho o wa mat s‑ta ehbidam haꞌichu hab wo e juh am ni‑tahgio. T wabshaba baꞌich i s‑ta ehbidam haꞌichu hab haha wo juh am ha tahgio hegam mo d pi ap chuꞌijkam ch pi ab hu ni‑wui e nohnogimk. (30) Hegam at pi wo e nako mas heg wo nako k heg hekaj wo chum tatchua mat g dohdaꞌag am ha dahm wo i shulig k wo ha ehsto.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kumsh gohk ep ha uꞌa mamtsh am wehmaj wo ha kokda. Sh idam d pi ap hehemajkam. ");
INSERT INTO oodNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kumtsh an dada anai mash am hab e aꞌaga Koshwak. Tsh g shondal ab hahawa sisish g Jesus kots t ab k am i kei g kots wag ch ed k gan hu aꞌai hab waꞌap ha nahngia hegam pi ap hehemajkam kokots t ab. ");
INSERT INTO oodNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tsh ab hahawa e hoꞌigeꞌidahu g Jesus k hab kaij, “Ni‑ohg Jiosh, ab g wabsh si i s‑ha hoꞌigeꞌid hegam mat ab ni‑naggia. Pi o shaꞌi mahch mani d si m‑Kehsha ch d s‑apꞌekam.” Kutsh g shondal am e chichwi k g wehschugaj e toꞌi. ");
INSERT INTO oodNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sh g hemajkam am gegok ch neid wehs ihda. Sh g ha wanimeddam nahnko ahg g Jesus ch hab kaij, “Ha at doꞌibia haꞌi, pegih, k hejel wo e doꞌibia matp d Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kush g shondal hab waꞌap nahnko wua ch hab wabsh s‑junim k ab chum mah g nawait ");
INSERT INTO oodNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ch wabsh nahnko ahg hab kaijch, “Oi g hejel e doꞌibiad napsh pi d ge kownal.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Sh am dahm oꞌohadag ihda, “Id o d Tutuligo hemajkam ha‑kownalig.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kush hema hegam pi ap hehemajkam mash ab hab waꞌap naggia kots t ab ab si s‑koꞌokam has ahg g Jesus ch hab kaij, “Neh, kuptp d ge Jiosh si Kehsha, pegih, k wo hejel e doꞌibia k ahchim ep wo t‑doꞌibia.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kush g hema ab si s‑kehꞌid ihda ch hab kaij, “Aha nap pi ehbid g Jiosh. Ia ach t‑wehm nahngia ch ab t‑wepo mohtoꞌidas g chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kuch ahchim s‑ap ab mohtoꞌidas nach pi wa woho d pi ap chuꞌijkam. Kutsh eda ihda pi hab shaꞌi juh g pi apꞌekam.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Neh, bash kaij ihda hema ch ab Jesus wui hab hahawa ep kaij, “Jesus, ab apt wo wa al s‑ni‑chegitok hekid ab bek g e‑kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Sh hab kaij g Jesus ab wui, “Neh, ni ab si m‑ahgid mapt id i tashkaj wo ni‑wehmajk an Jiosh kihdag ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kutsh am i dahm juh. Tsh muh g tash k wehsko s‑chuhugam ch ab ai g waik ohla. ");
INSERT INTO oodNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kutsh am geꞌe cheopi ch ed g s‑kowk ikus kuhpadag ab si shel e wantsh. ");
INSERT INTO oodNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kush am si s‑kaidam e hoꞌigeꞌidahun g Jesus Jiosh wui ch hab kaij, “Ni‑ohg, ab ant i m‑mah g ni‑doakag.” Neh, bash cheꞌiok am i muh. ");
INSERT INTO oodNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kutsh am i nei g shondal ha‑geꞌejig matsh haschu has e juh k ab si ihm g Jiosh ch hab kaij, “Woho oki d s‑apꞌekam oꞌodham ihda.” ");
INSERT INTO oodNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tsh amjed muꞌijj gam hu uhpam hihi hegam mash ab neid ab wabsh e wecho wahpkch nash pi oi wa si ap e tatat. ");
INSERT INTO oodNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kush wehsijj hegam mo si s‑mahch g Jesus ga hu wabsh mehk gegok ch ab neid wehs ihda. Haꞌi idam ash d hegam uꞌuwi mash ga hu Galilee t amjed an wehmajkahim g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Sh eda wa hema hegam e jehnigiddam chum pi hohhoꞌid matsh g wehmaj e jehnigiddam s‑muꞌam k ah g Jesus. Id ash hab chehgig Joseph ch ab d kihkam mash am d Arimathea ch s‑ap d oꞌodham ch ab nenida g Jiosh kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tsh hekid am i muh g Jesus, tsh ha hekaj am wui hih g Pilate k ab si e shoꞌigchud k tahni g honshpadaj. Tsh am wa apꞌech matsh wo bei. ");
INSERT INTO oodNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tsh gam hu ep him k ab i huduni. Sh am mia hab chuꞌig g hihaꞌini ch ab heki hu cheotas hodai ch ed ch pi koi e hekaj. Tsh g Joseph am i bei g honshpadag k ged hu heg eda cheh am i hobinodk g s‑kehg ikuskaj. ");
INSERT INTO oodNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","55","Tsh hegam uꞌuwi mo wehmajkahim g Jesus ab Galilee t amjed gam hu oi g Joseph k ash neid mat hebai e cheh g Jesus k has masma ab e woi. (54) Kush d wialos. Sh g hemajkam chum e nakog no pi g shahwai d ha‑mihshmda tash. ");
INSERT INTO oodNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kutsh gam hu uhpam hihi idam uꞌuwi mash hebai dadha k am i apꞌech haꞌichu mat hekaj wo s‑ap hab juh mo hab masma hab ha wua g e‑koꞌidag k ash am hahawa e ulinihogi mihshmda tash ch ed mo hab masma d ha‑chehanig. ");
INSERT INTO oodNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sh am e aihim g domig tash. Tsh am hihi idam uꞌuwi hihaꞌini wui k ash uꞌa hegai matsh am nahto matsh hekaj wo i apꞌech g muhki. ");
INSERT INTO oodNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kush gam hu e melchudas hegai geꞌe hodai mash ab hekaj e kuhpch g hihaꞌini. ");
INSERT INTO oodNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tsh am i wahp k pi shaꞌi edagi g muhki ");
INSERT INTO oodNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","k am wabsh i gegok pi amichudch ihda. Tsh am haha wabsh gohk i e chehgi ha wui mo hab sha mahs mo g oꞌodham. Kush wabsh si tonod g haꞌichu ha‑eniga. ");
INSERT INTO oodNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kutsh si e totods idam uꞌuwi k ab si i shul jewedo. Sh hab kaij idam gohk ab ha wui, “Shahchu am ahgch ia gahg hihaꞌini t am hegai mo d doakam? ");
INSERT INTO oodNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Pi o ia hu haꞌichug g Jesus nat pi i wuhsh ab muhkig amjed. Am g wo i chegito mo wa has kaij ab em‑wui. Am am wa wabsh kia haꞌichug Galilee t am. ");
INSERT INTO oodNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","K wa hab kaij, ‘Hemho ant am wo wa i ni‑dagito pi apꞌekam hemajkam ha wui ahni Jiosh si Kehsha. T hegam ab wo ni‑naggia kots t ab mat wo ni‑mua. Nt wabshaba wo i wuhsh muhkig amjed am heg eda waik tash amjed.’ Neh, bo kaij g Jesus ab em‑wui.” ");
INSERT INTO oodNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kutsh idam uꞌuwi am i chegito mash wa hab kaij g Jesus ");
INSERT INTO oodNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","k ga hu uhpam hihim k ash am ha ahgid hegam gamai hemako Jesus chuhchai ch wehs g haꞌi mat has e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Haꞌi idam uꞌuwi mash am ha ahgid ash d Mary Magdalene ch Joanna ch hegai Mary mash g madaj hab chehgig James. ");
INSERT INTO oodNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kush hegam Jesus chuhchai pi ab hu ha wohochud nash pi hab ha elid mo wabsh pi e mahch ch hab kaij. ");
INSERT INTO oodNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tsh wabshaba g Peter am i e nakog k am meh hihaꞌini wui k ged hu meliw k am i koachsh. Kush heg am waꞌi kahch s‑kehg ikus mash heg hekaj chum e hobinodch. Tsh amjed gm hu uhpam hih am wabsh i pi amichudch matsh haschu has e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kush heg waꞌi tash gohkajj am hihim Emmaus kihhim wui. Id amt ab wo ai kihhim am hu i gohk ohla ab am hihimadch Jerusalem t amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Sh idam am hihimad ch neneok ab amjed hegai matsh haschu has e juh am tahgio g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tsh g Jesus am ha aꞌa k am ha wehm hih. ");
INSERT INTO oodNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kush hi wa chum neid ch wabsh pi amichud. ");
INSERT INTO oodNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sh hab kaij g Jesus ab ha wui, “Shahchu am am si aꞌagad ch ia hihim?” Tsh am wabsh i gegokiwua k si pi ap e tahtkam mahs. ");
INSERT INTO oodNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sh hema idam hab chehgig Cleopas ch id hab kaij ab wui, “Aha nap ahpi waꞌi hejel pi mahch mat haschu has e juh hemuch huꞌi ch eda am daha Jerusalem t am?” ");
INSERT INTO oodNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Sh hab kaij g Jesus, “Shahchu ap hab ahg?” Kush hab kaij ihda, “Hegai mat hab e juh am tahgio hegai mo hab chehgig Jesus ch ab d kihkam Nazareth t ab. Heg oki d Jiosh haꞌichu i tashogiddam. K wehsijj ab si has elid mo haschu hab junihim ch has i kaij. ");
INSERT INTO oodNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kut g uꞌugchu papal ch t‑wanimeddam am i dagito kownal wui mat wo mua. Kumt ab sisish kots t ab k mua. ");
INSERT INTO oodNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kuch eda id hab chum si elid mo d hegai matsh wa wo t‑doꞌibia ahchim Tutuligo hemajkam. K hemuch d i waik tash amjed mat hab e juh. ");
INSERT INTO oodNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kut am haꞌi hihi g uꞌuwi t‑wehm wohochuddam wabsh i siꞌalim ");
INSERT INTO oodNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","k atsh pi cheh g muhki k uhpam dada k t‑tods am t‑ahgidch matsh am haꞌi i e chehgi g anghil ha wui. Sh idam hab ha ahgid mo d doakam g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","T am haꞌi hihi g chechoj hihaꞌini wui k am s‑mai mash wa woho pi am hu haꞌichug g muhki mo hab chum kaij hegam uꞌuwi.” ");
INSERT INTO oodNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sh hab hahawa kaij g Jesus ab ha wui, “S‑wohom am hig pi haꞌichu aꞌamichud ch pi wohochud hegai mo wa g kekelibad Jiosh haꞌichu i tashogiddam am ahg. ");
INSERT INTO oodNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","No hig pi hab wa mahs mat hab masma wo e shoꞌigch g Jiosh si Kehsha k am wo i wah si s‑kehg e‑apꞌedag ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Neh, bash kaij g Jesus ch amjed am i wuhshad k am tashogi wehs hegai matki g Mosesbad ch wehs hegam kekelibad Jiosh haꞌichu i tashogiddam an oꞌoha ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kutsh am hihim k am i aihi hegai al kihhim mo am wui d hihimdam. Sh gam hu wabsh i si him g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kush wabshaba an shoshobid ch hab kaij, “Ia apt wo waꞌi jiwia t‑wehm. Hudunihim o k ch ab i s‑chuhugamhi.” Kutsh wa woho am ha wehm i jiwia. ");
INSERT INTO oodNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tsh am wo i gegos. Tsh am bei g chemait k am e hoꞌigeꞌidahun k am hahawa hahain k ab ha mah. ");
INSERT INTO oodNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kutsh am hahawa i amich. Tsh wabshaba am wabsh i piꞌata. ");
INSERT INTO oodNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sh hab hahawa kaij ab aꞌai e wui, “Neh, ab at wa si i t‑shuhdad g s‑ap tahhadkam mo wa ab t‑wehm neokhim ch am tashogid g Jiosh oꞌohana mach ab hihim wohg oidch.” ");
INSERT INTO oodNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tsh am ha hekaj i e nakog k gam hu uhpam hihi Jerusalem wui. Kush am e hemapadch hegam gamai hemako Jesus chuhchai haꞌi ha wehm g e‑wehm wohochuddam. Tsh am dada idam gohk. ");
INSERT INTO oodNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kush hegam am ha ahgid ch hab kaij, “Neh, woho atki i wuhsh g t‑kownalig Jesus ab muhkig amjed. Kutsh g Simon nei.” ");
INSERT INTO oodNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kush idam gohk am hahawa epai ha ahgid matsh haschu has e juh am wohg ch ed ch heg ehp matsh amich g Jesus matsh am hahai g chemait. ");
INSERT INTO oodNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sh am wabsh kia aꞌaga ihda. Sh am haha wabsh kehk ha shahgid g Jesus ch ash hab kaij ab ha wui, “Am g wo s‑ap e tahtkkad.” ");
INSERT INTO oodNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kutsh shaꞌi si e totods hab em‑ahgch mo d wabsh kokꞌoi. ");
INSERT INTO oodNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Sh hab kaij ab ha wui, “Pi g wo shaꞌi e kudut k ab wabsh wo s‑ni‑wohochudad. ");
INSERT INTO oodNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ab g wo i neid g ni‑nohnhoi ch ni‑tahtad k wo s‑mai mani d ahni. Ab g wo ni‑tahtam k wo nei mani pi d kokꞌoi. Kokꞌoi o pi ha chuhkug ch pi ha ohꞌo mani ahni hemuch imhab chuꞌig.” ");
INSERT INTO oodNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kush hab cheꞌiok ab ha chehgi g e‑nohnhoi ch e‑tahtad. ");
INSERT INTO oodNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kush chum si s‑ap e tahtk ch wabshaba wabsh i hahaꞌadka natsh pi wabsh i pi mai mat has wo el. Kush heg hekaj ab ha kakke mas am haꞌichu chekch mat wo hu. ");
INSERT INTO oodNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kutsh ab ge mah g watopi gaꞌi. ");
INSERT INTO oodNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kutsh ab be k huh. Sh id wehsijj neid. ");
INSERT INTO oodNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kush hab hahawa kaij ab ha wui, “Wehs ani am em‑ahgid ihda heki hu. Wehs haꞌichu at hemho wa am hab wo e juh mo an oꞌohanas ab ni‑amjed ha‑oꞌohana ed g Mosesbad ch hegam haꞌi kekelibad Jiosh haꞌichu i tashogiddam ch heg eda nenꞌei oꞌohana mo an hab chuꞌig Jiosh heki hu oꞌohana ed.” ");
INSERT INTO oodNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Neh, bash kaij ch ab hahawa i ha mah g amichudadag mat wo s‑amich g Jiosh oꞌohana ");
INSERT INTO oodNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","k ash hab kaij ab ha wui, “Bant masma hab ni‑juh mo wa hab chuꞌig an Jiosh oꞌohana ed mant hab wo wa ni‑juh. An o oꞌohanas mantsh wo ni‑shoꞌigchud k wo ni‑muhkid. Kutsh d wo i waik tashk amjed. Ntsh ep wo ni‑chegito. Neh, heg ant hab juh. ");
INSERT INTO oodNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kut ia Jerusalem t amjed am aꞌai wo i e ahgahi gam hu wehsko jejewed ha dahm mat g hemajkam ab wo i ni‑hiwig k gm hu wo s‑ohhod g pi ap e‑chegitoi. T g Jiosh im hu hab wo i juh g pi ap ha‑chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ahpim amt am wo ahgahid ihda si s‑has haꞌichu mam neid ch kah. ");
INSERT INTO oodNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","T g Hekia S‑apꞌekam Gewkdag ab wo em‑mah g gewkdag mamt hab wo junihid. Heg ant am wo cheha mat wo em‑wehmajkad hab masma mo g ni‑ohg Jiosh hab kaij mat hab wo e juh. Mt heg hekaj ia wo dadkad Jerusalem t ab ch ab wo ai mamt ab wo bei hegai gewkdag.” ");
INSERT INTO oodNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tsh am hahawa i ha wanim amai mash am miabidch g Bethany. Tsh am hu hebai i dada. Kutsh am uhgk ul g e‑nohnhoi ha dahm k ab ha hoꞌigeꞌelid, ");
INSERT INTO oodNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tsh g Jiosh gam hu i bei dahm kahchim wui. ");
INSERT INTO oodNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sh idam ab si has elid ch gam hu hahawa hihi Jerusalem wui s‑hehgigch ");
INSERT INTO oodNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","k amjed chum hekid am hihhim geꞌe cheopi wui ch ab hoꞌigeꞌelid g Jiosh.");
INSERT INTO oodNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gd hu i si wehpeg ash d doakam hegai mach hab aꞌaga Jiosh Neꞌoki. Id ash d Jiosh ch am wehmaj g e-ohg Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jiosh ash am e wehm dahshch mash eda pi koi haꞌichu shaꞌi nahtois ");
INSERT INTO oodNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ch am i kei matsh wehs haꞌichu wo nahto. Kutsh wa woho wehs haꞌichu nahto ");
INSERT INTO oodNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","k an uꞌukch g gewkdag ch wehs ha mah g haꞌichu doakam g doakag. K ihda doakag am tonlidch g hemajkam chegitoidag. ");
INSERT INTO oodNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","K wabshaba g hemajkam pi e nakog hejel mas wo s-amich mo haschu chum ha tashogid. ");
INSERT INTO oodNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Am ad hema i kei g Jiosh g oꞌodham mat wo t-mihshmad. D id hab chehgig John. ");
INSERT INTO oodNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","D g mihshmdaj hab chuꞌig matsh in wo i wuhsh jewed dahm hegai mo ab t-mahkch g t-doakag. K hab d elidaj g Jiosh mat wehs hemajkam wo kah ihda haꞌichu ahga k ab wo hiwgad hegai mat in i wuhsh. ");
INSERT INTO oodNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pi ad hejel hab e ahg g John ch wabsh heg an ahgachug mad in i wuhsh. ");
INSERT INTO oodNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Id o d wohokam tonlig ch am tonlidch g wehs hemajkam ha-chegitoidag. ");
INSERT INTO oodNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pegih, d ia haꞌichug g Jiosh Neꞌoki jewed e-nahtoi dahm. D wabshaba hemajkam nahtoij pi amichud. ");
INSERT INTO oodNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ia adki mahsi k d t-wehm oꞌodham. D eda muꞌijj g Tutuligo pi amichud ch pi ab hu hiwig. ");
INSERT INTO oodNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kuchd wabshaba haꞌijj ab i s-wohoch mo d Jiosh si Kehsha k ab hiwig. Kud heg hekaj ab t-mah g apꞌedag matt d haha wo aꞌaligajk g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pi ach heg wabsh hekaj d Jiosh aꞌaliga matt in mamsi o heg wabsh hekaj mo g t-jehj ab s-wohochud g Jiosh o heg wabsh hekaj mach hab t-elid machs d aꞌaligaj. Jiosh at hab t-juh mach d hahawa aꞌaligaj. ");
INSERT INTO oodNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","16","Hegai mo d Jiosh Neꞌoki ad e wepogi g hemajkam k woho t-wepo chuꞌig ch ia t-shahgid d doakam. D g John an aꞌaga k si s-kaidam hab kaij, “Id o d hegai mani hab ahg ch am em-ahgid mat ab hema wabsh ni-oidk wo i e maskogid k eda woho d si s-has haꞌichu nash pi chum hekid an haꞌichug.” Neh, bo kaij g John. Kuchd heg amjed s-mahch g Jesus Christ ch am hahawa s-mai moki d Jiosh alidag ch si s-hemajima ch heg waꞌi ahg wohokam ch woho ab si s-t-hoꞌigeꞌid. ");
INSERT INTO oodNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dash Mosesbad matsh wa an oꞌoha g Jiosh chehanig am ha wehhejed g hemajkam. K wabshaba d Jesus Christ mad ia uꞌapa g Jiosh hemajimatalig ch wohokam. ");
INSERT INTO oodNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Pi oki hekid hedai shaꞌi e-wuhpuikaj neid g Jiosh. K wabshaba g alidaj am wehmaj d hemako ch ab t-wui mahsko wua. ");
INSERT INTO oodNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Am ad t‑mihshmad ihda John tohono jewed ch ed. K eda am Jerusalem kihhim t am dadha g t‑geꞌegedga ahchim Tutuligo. Tsh am i ha ai g haꞌichu kaida ab amjed g John. Kutsh am haꞌi ha cheha g papal ch hegam mo d papal ha wehm chikpandam matsh wo s‑mai mas hedai wud hegai John. Tsh idam am hihim k am dada k ab s‑mahchim mas hedai chum e elid ab wui hab kaijch, “Nap hab chum e elid map d Jiosh si Kehsha?” ");
INSERT INTO oodNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","D ab wabsh si ha wehm neok g John ch am si tasho ha ahgid mo pi d hegai. ");
INSERT INTO oodNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","D ab ep kakke, “Aha nap d hegai Elijabad ch ia uhpam jiwia?” D g John hab kaij, “Piaꞌa, pi ani d hegai.” D ab ep kakke, “Nap d hegai Jiosh haꞌichu i tashogiddam matsh in wo i wuhsh?” D hab ep kaij, “Piaꞌa, pi ani d hegai.” ");
INSERT INTO oodNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","D hab hahawa kaij, “Pegih, k am wo t‑ahgi map hedai wud. Hemho wa att am wo ha ahgi g t‑geꞌegedga map has e aꞌaga.” ");
INSERT INTO oodNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","D g John hab hahawa kaij, “Ahni ani wud mo hab ni‑ahg ch an oꞌohanas: Hema atsh gam hu jeg ed wo ha mihshmad g hemajkam hab kaijch, ‘Neh, in atsh wo i wuhsh jewed dahm hegai mo d ge kownal wehs haꞌichu dahm. Kumt heg wehhejed wo i e nako am dagitok g pi ap e‑chuꞌijig.’ Neh, id o d neꞌokij hegai kelibad Jiosh haꞌichu i tashogiddam mash hab chehgig Isaiah,” bad kaij g John. ");
INSERT INTO oodNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Idam mad ab haꞌichu kakke g John o d haꞌi hegam mo hab e aꞌaga Palasi. K hegam Palasi chum si nuhkud g t‑himdag. ");
INSERT INTO oodNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","D heg hekaj hab ep kaij idam ab John wui, “Pegih, p haschu ahgch ha pahl wapkon ch eda wa chum pi d Jiosh si Kehsha ch pi d Elijabad ch pi d hegai Jiosh haꞌichu i tashogiddam matsh in wo i wuhsh?” ");
INSERT INTO oodNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","D hab hahawa kaij ab ha wui, “Ha ani pahl wapkon mat wo i e nako. Hemu at in wo i wuhsh hegai mo hig woho d si s‑has haꞌichu, pej hemu ia haꞌichug em‑shahgid. Kum pi amichud. ");
INSERT INTO oodNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Pi g hab wo ni‑elidad manis ahni d si haꞌichu. Ihda mat am ni‑oidk wo i wuhsh at wehs ha baꞌich d wo i si haꞌichuk.” ");
INSERT INTO oodNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Neh, wehs ihda ad hab e juh gan hu aigojed g Jordan akimel mo am d wahlko kih. ");
INSERT INTO oodNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Am baꞌich d i tash, d am jiwia g Jesus John wui. D heg an aꞌaga ch hab kaij, “Neh, id o d hegai mat wo e wepogi g kahwal mad k ab wo e iagchul Jiosh wui mat gam hu hab wo i juh g pi ap t‑chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Id ani hab ahg mani wa hab em‑ahgid mat ab wabsh ni‑oidk wo i wuhshani k wabshaba wehs ha baꞌich d i si haꞌichu no pi chum hekid an haꞌichug. ");
INSERT INTO oodNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Pi ani hab wa shaꞌi mahch mas hedai d wo Jiosh si Kehshak. K wabshaba g Jiosh am ni‑chehani mant wo ha pahl wapko g hemajkam. T hab wa masma am wo tashogi g si e‑Kehsha am t‑wui ahchim Tutuligo.” Neh, bad kaij g John. ");
INSERT INTO oodNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","D am hebai i cheka, d si s‑mahch ch ahg g John hab kaijch, “Bo kaij g Jiosh ab ni‑wui, ‘Ab at wo i hud g Hekia S‑apꞌekam Gewkdag k ab wo e ul si ni‑Kehsha ab. Kupt hab wo s‑mahchk mo d ihda mat wo ha mah g hemajkam g Hekia S‑apꞌekam Gewkdag.’ Neh, bo kaij g Jiosh ab ni‑wui. Kut wa woho si s‑hemajim ab i hud g Hekia S‑apꞌekam Gewkdag k ab e ul id ab Jesus hab masma mat g hohhi an hasko wo i dahiwua ab i hudunik. ");
INSERT INTO oodNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kunt wa neid k heg hekaj si s‑mahch mo ihda Jesus d Jiosh alidag.” ");
INSERT INTO oodNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Am baꞌich d i tash, d am ep haꞌichug g John. Kuchd gohkajj an wehmaj ahchim mach ab si wecho t‑mashcham. ");
INSERT INTO oodNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","D ab him g Jesus. Kud g John neidok hab kaij, “Neh, m ia him hegai matsh kahwal mad wepo wo e iagchul am t‑wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kuchd am i kah ahchim gohk k gam hu i oi g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","D ab haꞌab i e wua k ab i t‑neid k hab kaij, “Shahchu am tatchua?” Ch hab kaij, “Bahp dak ch amjed ha mashcham?” ");
INSERT INTO oodNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","D hab kaij, “Oi g wo ni‑oid k wo nei mani hebai da.” Kuchd gam hu oid k am wehmajkahim im hu i juhk amjed ch ga hu si ai g s‑chuhugam. ");
INSERT INTO oodNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Hegai mad ni‑wehm kah g John ch am i oi g Jesus o hab chehgig Andrew. K g wehngaj ihda hab chehgig Simon. ");
INSERT INTO oodNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","K g Andrew d wehpegkam mat am i gahghi g e‑wehnag k hekid am i chehg k hab ahgid, “Cheh att hegai moki d Christ.” (Id o hab d ahga ‘Jiosh si Kehsha.’) ");
INSERT INTO oodNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","D g Andrew am hahawa uꞌapa Jesus wui. T ab si shel i nei g Jesus k hab kaij, “S-mahch ahni map d Simon ch d alidaj hegai mo hab chehgig Jonas. Iꞌajed apt hab wo chehgigk Peter.” (Id o hab d ahga ‘Hodai.’) ");
INSERT INTO oodNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Am baꞌich d i tash, d hab i e ah g Jesus mat gam hu wo hih Galilee chekshani wui. K eda an oimmed hegai mo hab chehgig Philip ch am d kihkam Bethsaida t am. (Ahchim g Andrew ch Peter ha wehm ach am hab waꞌap d kihkam Bethsaida t am.) Jesus ad am cheh g Philip k hab kaij ab wui, “Ab g i ni-oid k wo ni-wehmajk.” ");
INSERT INTO oodNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","D g Philip gam hu i gahghi g Nathanael k am i chehgiok hab kaij, “Cheh att hegai matki wa ab amjed an oꞌoha hegam Mosesbad ch kekelibad Jiosh haꞌichu i tashogiddam. Heg oki wud mash d Jesus ch heg d alidag mash d Josephbad ch ab Nazareth kihhim t ab d kihkam.” ");
INSERT INTO oodNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","D ab wabsh ge i nen k hab kaij, “Ih, nat hig woho haꞌichu s-apꞌekam wo i wuhsh ab Nazareth t amjed?” D g Philip hab kaij, “Pegih, k ab wo i him k hejel e-wuhpuikaj wo nei.” ");
INSERT INTO oodNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","D ga hu haha wabsh i hihim. D g Jesus neid k hab kaij, “Neh, id o d si oꞌodham m ab him.” ");
INSERT INTO oodNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","D g Nathanael hab kaij, “P has masma s-ni-mahch?” D hab kaij g Jesus, “M ani wabsh tonlid ch m-neid map am da suhna wecho mat eda koi m-cheh g Philip.” ");
INSERT INTO oodNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","D hab kaij g Nathanael, “Ih, neh, kupki d Jiosh alidag ch d t-kownalig ahchim Tutuligo hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","D hab kaij g Jesus, “Ab ap ni-hiwig nani pi am wabsh tonlid ch m-neid. Nt wo si shel m-ahgi mapt baꞌich i s-ta neidamam haꞌichu wo nei imhab i baꞌich. ");
INSERT INTO oodNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Dani Jiosh si Kehsha ch am wo kuhpiꞌo g dahm kahchim am em-wehhejed. Kumt wo nei mat am wui wo i chehchsh g anghil ab ni-amjed k ab ni-wui ep wo i huhud.” ");
INSERT INTO oodNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Am gohk d i tash amjed, tsh am haꞌi wo e hohont Cana kihhim t am. Ihda Cana o am Galilee chekchani ch ed. K am haꞌichug g Jesus jeꞌe. ");
INSERT INTO oodNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kumd ahchim ab i t-wai. Chd am hihi g Jesus wehm k am haꞌichug. Kumd am hahawa hab juh g gegosig. ");
INSERT INTO oodNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","D wabshaba am i huh g nawait. D g Jesus jeꞌe ab wui hab kaij, “Huh at g ha-nawait.” ");
INSERT INTO oodNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","D hab kaij g Jesus, “Pi o ab hu haꞌichu ni-him heg amjed. Pi at koi chum e ai mant am wo i ni-maskogi.” ");
INSERT INTO oodNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","D wabshaba g jeꞌej hab ha ahg g pion, “Am g hab wo juhni matp haschu wo i em-ahgi mamt am hab wo juh.” ");
INSERT INTO oodNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","K eda d t-himdag ahchim Tutuligo mach muꞌi haꞌichu has masma wapkon. D g hohodai hahaꞌa chuhdp am dadha mamt ab wo chum waꞌig k am hab wo junihid g t-himdag. D idam hahaꞌa hemako am hu i waikko wehst-mahm walohn shuhdagi am wo e toa. ");
INSERT INTO oodNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","D hab kaij g Jesus am ha wui g pion, “Am g wo i ha shuhshud g shuhdagikaj.” D wa woho am si i ha shuhshud. ");
INSERT INTO oodNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","D hab hahawa ep ha ahg, “Am g wo wassibi k wo mah hegai mo nuhkud g e-hohontam piast.” D wa woho hab e juh k am i wassibi k ged hu ha mah. ");
INSERT INTO oodNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","D ab jeh mo d si s-kehg nawait k eda pi mahch mas hebai waꞌi. Hegam o hi wa s-mahch pion mat hebai waꞌi. ");
INSERT INTO oodNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","D am i cheh g ha-hohntam am i jehk g nawait k hab kaij ab wui, “Shaꞌi s-ap ab kahk ihda nawait. Haꞌi at an hi wo wa i ha wassibi g s-kehg nawait ga hu i wehpeg k wabsh g pi kehg nawait wo ha wassibi im hu i oidch. Kuptki eda ahpi im hu i oidch g si s-kehg nawait ha wassibi.” ");
INSERT INTO oodNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Neh, k id d si wehpeg s-hasig haꞌichu hab junij g Jesus. D am mahsko wua g e-gewkdag. Kuchd ab si s-wohochud mo woho d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","D am hahawa hab i e ah g Jesus matt am wo hihi Capernaum kihhim wui. D g jeꞌej ch wepngaj ep t-oi. Ch am haꞌichugkahim heꞌekia tash. ");
INSERT INTO oodNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Wehs ahid ab o am e wushshad Jerusalem t am matsh wa g Jiosh ha doꞌibia g t‑shohshon. Kud am i e ai. Kuchd gam hu hihim ");
INSERT INTO oodNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","k ged hu dada geꞌe cheopi t am. D eda am haꞌi ha gagda g haiwani ch kahwal ch hohohi ch am haꞌi kammialt g lial heg wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kud si pi hohhoꞌi g Jesus mo id am hab e wua geꞌe cheopi t am k hekaj hema gewikudt g wijinakaj k gam hu wehs si ha shahmud g haiwani ch kahwal k am gai ha shul g ha‑mimsa hegam mo g lial kammialt k gam hu si gantad g ha‑lialiga ");
INSERT INTO oodNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","k hab ha ahg hegam mo g hohohi ha gagda mat gam hu wo i ha wuwhas hab kaijch, “Pi g hab wo shaꞌi juhni g ni‑ohg kih mat d wabsh wo haꞌichu gagdakudk.” ");
INSERT INTO oodNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kuchd am hahawa i chegito mo g Jiosh heki oꞌohana hab chuꞌig: Jiosh si Kehsha at ab wo si has elidad g geꞌe cheopi. ");
INSERT INTO oodNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","D ab si chehmo g hahaꞌichu k hab ahg, “Shahchu ap ahgch hab wua ihda? Am g hig t‑chehgid g s‑hasig haꞌichu. Kutt hab wo s‑mahchk map uꞌukch g e‑gewkdag ab amjed g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","D hab kaij g Jesus, “Pegih oig, m ant wo wa em‑chehgi g s‑hasig haꞌichu. Mt wo padch ihda mo g Jiosh am eda kih. Kunt ahni ep wo i kegch mat d wo i waik tashk.” ");
INSERT INTO oodNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","D idam si e shoꞌoshodkad k hab kaij, “Giꞌikko gamai chuhdp (46) aꞌahid ab at hahawa i e nahto ihda geꞌe cheopi. Kuptp eda ahpi waik tash ab ia wo i kei.” ");
INSERT INTO oodNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","K eda g Jesus hejel hab e ahg mat wo e muhkid k uhpam ep wo e chegito. ");
INSERT INTO oodNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kutt s‑chegito g neꞌokij mat hekid uhpam e chegito am e muhkidk. Neh, bo chuꞌig g Jiosh oꞌohana mat uhpam wo e chegito g Jiosh si Kehsha. Kutt hahawa s‑amichud k ab s‑wohoch. ");
INSERT INTO oodNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","24","Am achd haꞌichugkahim Jerusalem t am wehs oidam g t‑shohshon ha‑doꞌibiadag wuhshda. Kud muꞌijj ab i s‑wohoch g Jesus. D wabshaba pi am hu i e tashogi ha wui mas hedai wud no pi s‑mahch mo heg wabsh hekaj ab s‑wohochud mo am neid mo hab juni him g s‑hasig haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pi o hedai ab hu hiwig g Jesus mas am wo ahgi g hemajkam ha‑chegitoi no pi heki hu s‑mahch. ");
INSERT INTO oodNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Am ad hema d si s‑has haꞌichu am t‑himdag ed ch d ge Palasi ch hab chehgig Nicodemas. ");
INSERT INTO oodNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kuchd am hu hebai dadha chuhug ch ed. D id am i chehgim g Jesus k hab kaij ab wui, “S‑mahch ach mat am i m‑kei g Jiosh mapt wo t‑mashcha. Pi at hedai wo e nako mas hejel hab wo juh hegai s‑hasig haꞌichu map hab junihim. Jiosh oki ab m‑mahkch g gewkdag.” ");
INSERT INTO oodNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","D hab kaij g Jesus, “Nt wo si shel m‑ahgi mat hegam d wo waꞌi Jiosh hemajkamgak mat hedai gokko wo mamsi. Bo wa chuꞌig g Jiosh kownaltalig.” ");
INSERT INTO oodNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","D hab kaij g Nicodemas, “Tt has hig masma ep wo mahsi heki hu kelitk. Aha natt am ep wo i wah t‑jeꞌe ed k ep wo mahsi?” ");
INSERT INTO oodNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","D g Jesus hab kaij, “Piaꞌa. Dam wabsh ha‑aꞌaliga ab ha ab mamsik. Bani m‑ahgid ab amjed g wechij doakag. Id at g Hekia S‑apꞌekam Gewkdag ab wo em‑mah mamt wo e chehgi g pahl wakonakaj mamt dagito g pi ap e‑chuꞌijig. Mt hab s‑ap am wo i wahp Jiosh kownaltalig ed. ");
INSERT INTO oodNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Pi g am e todsid mani hab kaij mamt hemho wa ep wo mamsi. ");
INSERT INTO oodNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Neh, kah ap g hewel m an hewelhog. Nap hig s‑mahch mas hebai amjed med ch hebai wo meh? Pegih, k hab wa masma pi ta machima hab e junihim g Hekia S‑apꞌekam Gewkdag ch an ha wechij mamsid mo hedai hab i elid.” ");
INSERT INTO oodNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","D g Nicodemas hab kaij, “A, kus has masma hab chuꞌig?” ");
INSERT INTO oodNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","D hab kaij g Jesus, “Aha, nap pi amichud ch eda d wa chum ge uhgk ha mashchamdam g Tutuligo? ");
INSERT INTO oodNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Do si wohokam ihda mani m‑ahgid. M ach ahgachug mach haschu s‑ap s‑mahch ch am em‑ahgid mach haschu neid. M eda pi wohochud g haꞌichu t‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ihda mani em‑ahgid o in hab waꞌi e junihim jewed dahm. M eda pi ni‑wohochud ch hab pi wo e nako mams wo s‑ni‑wohoch mant am wo em‑ahgi mo haschu has e junihim an dahm kahchim ch ed. ");
INSERT INTO oodNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","An ani wa kih dahm kahchim ch ed ch d Jiosh si Kehsha. Kut pi hedai ep wo e nako mas hab masma wo em‑ahgi ab amjed mant ahni.” ");
INSERT INTO oodNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","D hab ep kaij g Jesus, “An o hab chuꞌig Jiosh oꞌohana ed matsh wa g t‑shohshonbad muꞌi e keꞌij g kohkꞌoikaj mash eda am oiopo tohono jewed ch ed. Kutsh wa g Mosesbad am hema hab juh g koꞌoi g kohwlikaj k ab uhgk ul uhs t ab. T hedai ab i neid k doa. Pegih, kumt ahni hab waꞌap uhgk wo i ni‑ul uhs t ab ahni Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kutp hedai ab wo ni‑hiwig k wo e doꞌibia ab amjed g pi ap e‑chuꞌijig.” Neh, bad kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pegih neh, ab o si t‑tatchua g Jiosh ch hiwigi g e‑alidag mat am i e dagito k e muhkid am t‑wehhejed mach d pi ap chuꞌijkam. Kut pi wo bei g s‑koꞌok e‑namkidadag matp hedai ab wo hiwig k wabshaba g pi ha huhugedam doakag wo bei. ");
INSERT INTO oodNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Jiosh at am cheha g e‑alidag mat in wo i wuhsh jewed dahm k wo ha doꞌibia g hemajkam. Kut pi heg hekaj in i wuhsh mas ab wo haꞌichu t‑mohtoꞌi. ");
INSERT INTO oodNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pi o ab hu haꞌichu mohtoꞌis hegam mo ab hiwig g Jiosh alidag. Hegam o ab heki hu haꞌichu mohtoꞌis mo pi ab hu hiwig. ");
INSERT INTO oodNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","Ia at jiwia jewed dahm hegai mo woho tonlidch g t‑chegitoidag. K wabshaba hegam mo hab s‑junimk g pi apꞌekam pi tatchua g tonlig nat pi wo mahsko wua g pi ap haꞌichu hab ha‑juni. K oi wa ab him g lodaita heg hekaj pi apꞌekam. ");
INSERT INTO oodNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Hegam mo hab wua g s‑apꞌekam o tatchua g tonlig mat wo mahsko e wua mo hab wua g Jiosh tatchui. ");
INSERT INTO oodNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Am i dahm, kuchd am i wuwha Jerusalem kihhim t amjed k am oiopohim Judea chekshani ch ed ch ha pahl wapkon g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Md eda wenog koi kuh hegai John mad ha pahl wapkon. Sh am oimmed ch ha pahl wapkon Aenon t am miabidch g Salim kihhim no pi am ge shohshon ch s‑shuhdagig. ");
INSERT INTO oodNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sh am haꞌichug hegam mash ab si wecho e mashcham. Kutsh am hema jiwia g t‑wehm oꞌodham k ha wehm neꞌowi ab amjed g pahl wakona. ");
INSERT INTO oodNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tsh idam am hahawa hihi John wui k hab kaij, “T‑mashchamdam, hema at wa am m‑wui jiwia map wa am ha pahl wapkon gam hu aigojed g Jordan akimel. Kup wa am si s‑mahch ch ahg mo hig woho d si s‑has haꞌichu. Pegih, heg ash hab waꞌap ha pahl wapkon. Kush wehsijj gam hu haꞌab him wui.” ");
INSERT INTO oodNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Sh hab kaij g John, “Heg ach ab waꞌi bekch mo haschu g Jiosh ab t‑mahkch. ");
INSERT INTO oodNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Bani wa kaij mani pi d Jiosh si Kehsha ch wabsh am haꞌichu i apꞌechud g ia jiwhiadaj wehhejed. Am am wa kah mani wa hab kaij. ");
INSERT INTO oodNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jiosh si Kehsha o heg wepogidas mo g wo ha hohntam. K g hemajkam heg wepogidas mo g wo ha hohnta. T g nawojij wo si s‑hehgigk mat hekid s‑ap wo e hohont. Bani wa masma si s‑hehgig mo ab wui him g hemajkam nani pi d nawojij. ");
INSERT INTO oodNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Heg at am wo e maskogi mo hig woho d si s‑has haꞌichu. Kunt ahni im hu hab wabsh wo i ni‑junihi.” Neh, bash kaij g John. ");
INSERT INTO oodNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nt ahni hab wo chei mo g John d wabsh oꞌodham ch am t‑ahgid mo haschu i neid ch ep kah ia jewed dahm. T wabshaba g Jiosh alidag ia jiwia ab dahm kahchim t amjed k d si s‑has haꞌichu wehs haꞌichu dahm ");
INSERT INTO oodNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ch am t‑ahgid mash haschu i neid ch ep kah an dahm kahchim ch ed. K wabshaba pi shaꞌi muꞌijj ab wohochud g ahgaj. ");
INSERT INTO oodNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Jiosh at am cheha g e‑alidag mat ia wo jiwia jewed dahm k s‑baꞌama ab mah g Hekia S‑apꞌekam Gewkdag. K g alidaj heg hekaj ahg g neꞌokij. (33) Pegih, kuch heg hekaj s‑ap ab s‑wohochud g Jiosh neꞌoki ahchim mach ab s‑wohochud g alidaj ahga. ");
INSERT INTO oodNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jiosh o si pihk e elid ab e‑alidag wui ch wehs haꞌichu ab mah. ");
INSERT INTO oodNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kuch wehsijj uꞌukch g pi ha huhugedam doakag ahchim mach ab hiwig g alidaj. T hegam mat pi ab hu wo wohog el pi wo edagi g pi ha huhugedam doakag k wabshaba g s‑koꞌok e‑namkidadag wo edagi. T heg hab waꞌap pi hekid wo huhug. ");
INSERT INTO oodNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","D baꞌich i muꞌi hemajkam ab him Jesus wui mo ab wui g John kch ab wecho e mashcham. Kuchd ahchim ha pahl wapkon mach ab si wecho t‑mashcham. D am i kah hegam Palasi ihda k an si i neneo. ");
INSERT INTO oodNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","D hekaj g Jesus hab i e ah matt wo i wuwha ab Judea chekshani t amjed k gam hu uhpam wo hihi Galilee chekshani wui. ");
INSERT INTO oodNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","K eda idam ha shahgid chechkshani am hab chuꞌig g Samaria chekshani. ");
INSERT INTO oodNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Kuchd heg am gai hihimad ch gam hu ai g Sychar kihhim mat am dahm juh. K am wawhiag miabidch g kihhim. D am dahiwua g Jesus gewkok natt pi mehk waꞌi hihi. ");
INSERT INTO oodNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Kuchd ahchim gam hu hihi kihhim wui matt wo ha nolawt g haꞌichu hugi. D an hema i t‑bij g uwi waꞌigamedam k atsh am jiwia mo am daha g Jesus. Sh hab kaij g Jesus ab wui, “Ab g i ha ni‑wasbid g shuhdagi.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sh hab kaij g uwi, “Neh, dapki Tuhligo. Ni ahni d Samaria t am oꞌodham. P haschu ahgch ab ni‑tahni g wasib?” Neh, bash kaij nach pi s‑ha uhwaid ch chum hems g haꞌu pi ha wehm wo ha hekaj. ");
INSERT INTO oodNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sh g Jesus hab epai kaij ab wui, “Ahpi apt aigo ab wo haꞌichu ni‑tai maptp wo s‑mahchk mani hedai wud ch haschu i m‑makiog. Hegai mani m‑makiog o ab Jiosh d amjedkam ch heg wepogidas mo g shonkam shuhdagi.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sh hab ep kaij g uwi, “Pt has hig masma wo waꞌi map pi ha kuhwo? K eda s‑juhk g wawhia. ");
INSERT INTO oodNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Aha nap baꞌich i gewkdag mo g t‑shohshon Jacobbad. Heg at ia wawhiat e‑oid ed k ia ihꞌehim g e‑aꞌaliga ha wehm ch haꞌichu e‑shoshoiga.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Sh g Jesus hab kaij, “Huhume o g shuhdagi m‑waꞌigi. Kup ep tonommek. ");
INSERT INTO oodNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","T wabshaba pi hekid wo huhug hegai mani ahni m‑makiog. Heg at am wo m‑edak ch hab wo masmak mo g shonkam ch ab wo m‑mah g pi ha huhugedam doakag.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sh hab kaij g uwi, “Ih, pegih, si g s‑ni‑hoꞌigeꞌid k ab i ni‑mahki ihda shuhdagi mant pi hekid ep wo tonom k pi wo ge i waꞌigammedad.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Sh hab kaij g Jesus, “Pegih, k ab wo i wai g e‑kun.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Sh g uwi hab kaij, “Pi ani ha kun.” Sh hab hahawa ep kaij g Jesus, “Wohokam ap ahg map hab kaij map pi ha kun. ");
INSERT INTO oodNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Hetasp ap waꞌi ha kuhkunkahim. K hegai map hemuch an wehm kih pi d m‑kun.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tsh ab wabsh ge nen k kekiwua g uwi k hab kaij, “Ih, dapki ge Jiosh haꞌichu i tashogiddam! ");
INSERT INTO oodNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pegih neh, am g ni‑ahgid mam haschu ahgch ahpim Tutuligo hab chechꞌe mo g Jerusalem d waꞌi amai mat am wo e ihmad g Jiosh. Ch eda ahchim Samaria t am kihkam ia haꞌab ihm mo hebai g t‑shohshon ihmahim id ab doꞌag.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Sh hab kaij g Jesus, “Nt wo si shel m‑ahgi mo ab him g tash mat wabsh chum hebai wo e ihm g em‑ohg Jiosh, pi iia waꞌi id ab doꞌag o am Jerusalem t am. ");
INSERT INTO oodNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","T wabshaba g Jiosh ab i t‑gawulkai ahchim Tutuligo mat am gai t‑wuhshanim wo e maskogi am ha wui g nahnko mahs hemajkam. M ahpim Samaria t am oꞌodham pi koi am hu i si s‑mahch g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","E at ai g tash mat g hemajkam si e‑ihbdag amjed woho ab wo ihmad g e‑ohg Jiosh. Bo masma hab ha elid g Jiosh mat hab masma ab wo ihmad. ");
INSERT INTO oodNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Do wabsh doakag g Jiosh ch pi ha honshpadag mams am hebai wo kihchud k heg waꞌi eda wo ihmad. Pegih, mt wabsh chum hebai wo ihmad ch wehs e‑ihbdag amjed.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sh am wabsh shaꞌi pi amichud g uwi ch hab kaij ab wui, “Heg ani hi wa s‑mahch mat wo jiwia hegai mo d Jiosh si Kehsha ch hab e aꞌaga Christ k wehs haꞌichu wo t‑ahgi.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Sh hab kaij g Jesus, “Dani ahni Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kuchd edapk i dada. D am wabsh kia wehmaj neok hegai uwi. Kuchd si has i t‑elid k wabshaba pi has shaꞌi kaij. ");
INSERT INTO oodNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","D ihda uwi am wabsh i dagito g e‑haꞌa k gam hu si s‑hohtam uhpam hih kihhim wui k ash am ha ahgid k hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Oi g ab wo i hihim k wo nei hegai mo am wehs ni‑ahgid mani has i ni‑wua. Kutp hu d i Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kudki ab ha hekaj i hihi g hemajkam s‑neidamk g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","D koi e chehm g hemajkam, kuchd ab chum si ahgid g Jesus mat wo haꞌichu huh. ");
INSERT INTO oodNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","D wabshaba hab kaij, “Am o haꞌichug g hab mahs gegosig mam ahpim pi shaꞌi mahch.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chd hab kaij ab aꞌai t‑wui, “A nat ia heki hu hema gegos?” ");
INSERT INTO oodNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","D hab kaij g Jesus ab t‑wui, “Ni‑gegosig o d ihda mant hab wo juh g Jiosh tatchui k wo nahto hegai chikpan mo ab ni‑mohtoꞌid. ");
INSERT INTO oodNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Neh, bo e chechꞌe mat g ha‑esha wo i e baꞌiha mat d wo giꞌik i mashadk. Nt wabshaba wo em‑chehgi mat hemu si s‑hohtam wo e baꞌiha haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ahni ant am ei g Jiosh haꞌichu ahga. Kumt ahpim wo ha baꞌiha hegam mat wo bei g pi ha huhugedam doakag. Kutt hekaj t‑wehm wo s‑hehgigk. ");
INSERT INTO oodNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Id o heg wepogidas hab cheꞌidag mo hab chuꞌig, ‘Hema oꞌodham at am wo haꞌichu ei. T d wabsh wo hemak ch am wo hih g esha.’ ");
INSERT INTO oodNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ab g wo neid hegam mo ab hihim. Pi amt ha ahgi g Jiosh haꞌichu ahga k wabshaba wo ha baꞌiha hegam mat wo e doꞌibia.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kud wa muꞌijj hegam kihkam ab i s‑wohoch mo g Jesus d Jiosh si Kehsha heg hekaj mo hab kaij hegai uwi, “Heg o wehs ni‑ahgid mani has i ni‑wua.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","D heg hekaj ab si ahgid g Jesus am wui dadak mat wo si s‑ha hoꞌigeꞌid k am wo kia ha wehmajkahim heꞌekia tash. Kuchd wa woho am ha wehmajkahim gohk tash. ");
INSERT INTO oodNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","D muꞌijj ab ep i s‑wohoch ab i kaiok g ahgaj ");
INSERT INTO oodNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","k hab hahawa kaij idam heg wui uwi, “B att hahawa si hejel kah k ab s‑wohochud k s‑mahch moki woho d wehs hemajkam t‑doꞌibiakam id dahm jewed.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kuchd amjed gam hu hahawa haꞌab hihi Galilee chekshani wui ");
INSERT INTO oodNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","no pi hab kaij g Jesus, “No hu d wabsh i neida g Jiosh haꞌichu i tashogiddam amai mo hebai d si kihj am jewed.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","D wabshaba muꞌijj g hemajkam amai ab haꞌichugkahim Jerusalem t ab ch wuhshad g t‑shohshon ha‑doꞌibiadag ch am neid g Jesus. Kud wa am hab wua g s‑hasig haꞌichu. D idam si s‑hehgig ch ab neid g Jesus matt ged hu dada. ");
INSERT INTO oodNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Kuchd oi wa gam hu haꞌab hihi Cana kihhim wui mat wa am si wehpeg hab juh g si s‑hasig haꞌichu mat wa wabsh g shuhdagi nawaitt. D am hema jiwia g kownal pionag ab Capernaum kihhim t amjed am i kaiok mo am haꞌichug g Jesus. Sh id alidag muhkhim. D hab kaij ihda ab wui g Jesus mat am wo hih Capernaum wui k wo doaj g alidaj. ");
INSERT INTO oodNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","D hab wabsh kaij g Jesus ab wui, “Aha, namt pi hedai ab hu wo i s‑ni‑wohoch, mt hekid wo ipki nei mant hab wo juh g si s‑hasig haꞌichu?” ");
INSERT INTO oodNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","D am hab waꞌap kaij g s‑has haꞌichu, “Ab g si i s‑ni‑hoꞌigeꞌid k wo ni‑oi am ni‑kih wui mat koi wo muh g ni‑aliga.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","D hab hahawa kaij g Jesus ab wui, “Gamai g s‑ap e tahtk hihm. T wo doa g m‑aliga.” D si i ihbheiwua ihda s‑wohochudk k gam hu hahawa hih uhpam. ");
INSERT INTO oodNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Sh am himad ch ab haꞌi ha nam g e‑pionag mash si s‑hehgig ch hab kaij, “Tki wo doa g m‑aliga.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Sh am hahawa ha kakke, “Heꞌekia ohla k ed at ab i apꞌetahi.” Sh hab kaij g piongaj, “Do i hemako ohla tako mat jumal gei g s‑tonjig ab ab.” ");
INSERT INTO oodNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Sh am ha hekaj i chegito g ohgaj mo am d wabsh i si hegai ohla mo hab ahgid g Jesus, “T wo doa g m‑aliga.” Tsh ged hu jiwia e‑kih am k am si aꞌaga ihda g e‑wehm kihkam ha wehm. Tsh wehsijj ab i s‑wohoch mo g Jesus d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Neh, id o d i gokkokam s‑hasig haꞌichu mat hab juh g Jesus ia Galilee chekshani ch ed. ");
INSERT INTO oodNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","D am hahawa hema i e aihi g t‑mihshmda piast. Kuchd hekaj gam hu hihi Jerusalem wui. ");
INSERT INTO oodNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Am o hema woꞌog kihhim ch ed ch hab e aꞌaga Bethsada ch an miabidch hegai kolhai kihjeg mam an ha gagda g kahwal. K an hetasp wapttog heg wehgaj woꞌo. ");
INSERT INTO oodNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","K idam ha wecho shaꞌi muꞌi nahnko mahs kokꞌodam an woꞌowop ch haꞌi d pi neneadam ch haꞌi d pi hihimidkam ch haꞌi ab wabsh i s‑momoik. Kush idam nenida g shuhdagi matsh am wo i hoi ");
INSERT INTO oodNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","no pi hab elid mash hab hu g anghil am i huhuduk shuhdagi ch ed ch am i nonoig g shuhdagi. T hedai si wehpeg am wo hud shuhdagi ch ed mat am wabsh wo chum i nonoi k ash hab hu wo s‑doajima ab e‑mumkidag amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","D am hema woꞌo g oꞌodham ch waikko wehst‑mahm gamai gigiꞌik (34) aꞌahid ab waꞌi mumku. ");
INSERT INTO oodNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","D g Jesus am neid ch s‑mahch mo tash am waꞌi woꞌo ch hab kaij ab wui, “Nap tatchua mapt wo doa?” ");
INSERT INTO oodNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","D hab kaij g mumkudam, “Ni‑nawoj, pi o an hu hedaig mas am wo i ni‑huduni shuhdagi ch ed mo hekid am i hoike. Ni im hu haha wabsh i ni‑nakog mant am wo i hud, k gam hu heki hu hema ni‑baꞌiwichchek.” ");
INSERT INTO oodNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","D hab kaij g Jesus, “I wuhshani k am behꞌi g e‑wahkus k hihm!” ");
INSERT INTO oodNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Neh, d ha hekaj doa k am bei g e‑wahkus k s‑ap hih. Id ad hab e juh chum t‑mihshmda tash ed ahchim Tutuligo. ");
INSERT INTO oodNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","D haꞌi neid g t‑wehm oꞌodham ch hab ahg, “Neh, ahpi, melchkwua ap g t‑chehanig map kushwiotch g e‑wahkus. A nap pi mahch mo d mihshmda tash?” ");
INSERT INTO oodNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","D hab hahawa kaij hegai mo wa mumkuhim, “Hegai mat ni‑doaj o hab ni‑ahg mant am wo bei g ni‑wahkus k wo hih.” ");
INSERT INTO oodNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","D ab hahawa kakke mas hedai wud hegai mo hab ahg mat wo kushwiotk hih g e‑wahkus. ");
INSERT INTO oodNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","D wabshaba am wabsh i pi e amich nad pi g Jesus im hu pi e mahsid hemajkam ha shahgid no pi shaꞌi muꞌijj g hemajkam amai. ");
INSERT INTO oodNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","D am hahawa g Jesus s‑neidam k am cheh geꞌe cheopi ch ed k hab ahg, “Neh, doa apt. Pi g am hu hab i ep junihim g pi apꞌekam nat pi haꞌichu baꞌich i pi ap hab wo e juh am m‑tahgio mapt am hab ep wo i junihi g pi apꞌekam.” ");
INSERT INTO oodNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","D am i wuhshani k gam hu him k am ha ahgi moki d Jesus mat doaj. ");
INSERT INTO oodNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","D am i s‑mai idam mash d Jesus mat hab juh ihda mihshmda tash ed k heg hekaj am i kudu ab neꞌowinch. ");
INSERT INTO oodNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","D g Jesus hab kaij ab ha wui, “Ni‑ohg Jiosh o chum hekid g s‑apꞌekam chikpan. Ni ahni hab waꞌap chum hekid hab ni‑wua.” ");
INSERT INTO oodNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","D am hahawa i si e gewpkai mat wo mua nad pi am i kah mo hab masma ihm g Jiosh ch heg hekaj e wepogid g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","D hab hahawa kaij g Jesus ab ha wui, “Nt wo si shel em‑ahgi mani pi haꞌichu hejel hab wua ch wabshaba hab wua mo haschu g ni‑ohg Jiosh ni‑chehani. ");
INSERT INTO oodNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ni‑ohg o ab si pihk ni‑elid ch am ni‑chehgid mant has wo chum juni. T ab wo ni‑mah g gewkdag mant baꞌich i geꞌe haꞌichu hab wo juh mo ihda. Mt ab wabsh wo i hahaꞌadka. ");
INSERT INTO oodNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ni‑ohg o i ha wuwhasid g koꞌi ab muhkig amjed ch ab ni‑mahkch g gewkdag mant s‑ap hab wo juh. Nt hekaj ab wo i ha wuwhas mani hedai hab i elid. ");
INSERT INTO oodNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","K g ni‑ohg pi hedai ha lodait ch wabshaba ahni ab ni‑mah hegai apꞌedag mant wo ha lodai ");
INSERT INTO oodNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","no pi hab elid mat wehsijj ab wo si has i ni‑el hab masma mo ab si has i elid g ni‑ohg. Am at i ni‑kei g Jiosh. T hedai pi ab hu has wo ni‑elidad ch hab wa masma pi ab hu has elid g ni‑ohg. ");
INSERT INTO oodNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Do si wohokam ihda mant hab wo chei. T wo edagi g pi ha huhugedam doakag k am wo wehmajk g Jiosh hegam mat hedai ab wo kaihamad g haꞌichu ni‑ahga ch ab wo hiwgad g Jiosh. Pi ant ab hu wo ha mohtoꞌi g ha‑chuꞌijig mas hekaj gm hu hab wo i e juh ab amjed g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nt wo si shel em‑ahgi mo ab him g tash, pej heki hu e ai, mant ab wo i ha wai g koꞌi ahni Jiosh alidag. T hegam mat ab i kaiha g haꞌichu ni‑ahga ab wo i wuwha. ");
INSERT INTO oodNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ni‑ohg o d hegai mo ab ha mahkch g doakag ch ab ni‑mahkch g gewkdag mant hab waꞌap wo ha mah g doakag. ");
INSERT INTO oodNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","T ab ni‑mah g gewkdag mant ahni hab wo juh g lodaita nani pi d si Kehshaj. ");
INSERT INTO oodNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Pi g am wo e totodsid id hekaj mani has i kaij. Ab o him g tash mat wehs g koꞌi s‑ap wo ni‑kah k ab wo i wuwha. ");
INSERT INTO oodNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Hegam mo hab junihim g s‑apꞌekam at ab wo i e wamgid k ab wo bei g e‑apꞌedag. T hegam mo hab junihim g pi apꞌekam ab wo i e wamgid k ab wo bei g s‑koꞌok e‑namkidadag.” ");
INSERT INTO oodNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","D hab ep kaij g Jesus, “Pi ant wo shaꞌi ni‑nako mant hejel haꞌichu hab wo juh k wabshaba am si ni‑ohg oidk hab masma wo ha lodai. K hekaj hab s‑apꞌe g ni‑lodaita. ");
INSERT INTO oodNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Pi amt wo mahchk manis am ahg g wohokam mantp wabsh hejel wo ni‑wohokamch. ");
INSERT INTO oodNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","K heg hekaj am wa ni‑wehhejed neok g ni‑ohg Jiosh. Kuni s‑mahch mo d wohokam mo am ahg ab ni‑amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Neh, am amt wa haꞌi hihi heg wui John mo wa em‑pahl wapkonahim. K wa am em‑ahgid g wohokam. ");
INSERT INTO oodNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Id ani hab wabsh kaij mamt hekaj wo e doꞌibia nam pi ahpim heg tatchua mat g oꞌodham am wo i wohokamch haꞌichu mamt ab haha wo i s‑wohoch. Ni ahni hi heki hu s‑mahch mani hedai wud ch pi shaꞌi tatchua mas am hema wo ge i ni‑wohokamch. ");
INSERT INTO oodNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John o wa ahgachug g wohokam ch hekaj em‑tonlidch. Kumt wa haꞌijj ahpim heꞌes ab si s‑hohhoꞌi g haꞌichu ahgaj k an e hehemapaid wehgaj hab masma mat g huꞌul nahgi wo s‑hohhoꞌi g tonlig. ");
INSERT INTO oodNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“John o s‑ap ni‑wohokamchud. K wabshaba ahni ab ni‑mahkch g Jiosh mani g s‑hasig haꞌichu hab wua. K id baꞌich i s‑ap ni‑wohokamchud mani d ni‑ohg kehsha. ");
INSERT INTO oodNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pi am hekid neid g Jiosh. K pi hekid ab hu em‑wuhiosha neid ch neok ch wabshaba am ni‑wohokamchud mani d kehshaj. ");
INSERT INTO oodNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Am o ni‑wohokamchud g Jiosh mani d si Kehshaj. Kum eda pi ab hu ni‑tatchua nam ge wohochud. ");
INSERT INTO oodNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Am am si hoan g Jiosh oꞌohana nam pi tatchua mamt wo e doꞌibia k wo edgidad g pi ha huhugedam doakag. K g Jiosh oꞌohana am ni‑wohokamchud ");
INSERT INTO oodNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","mani ahni d em‑doꞌibiakam. M eda pi ab hu ni‑hiwig. ");
INSERT INTO oodNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Neh, pi ani heg nenꞌoid mas g hemajkam ab wo si ni‑haꞌichuch. Jiosh at ab wo si ni‑haꞌichuch. ");
INSERT INTO oodNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kuni s‑em‑amichud ch s‑mahch mam pi ab hu shaꞌi tatchua g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ia ant jiwia g ni‑ohg si wehhejed. Kum pi ab hu has ni‑elid. Hegam at ab has d wo em‑elidak matp hedam wabsh hejel e wehhejed ab wo i wuwha. ");
INSERT INTO oodNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pi amt has masma ab hu wo s‑wohoch g Jiosh nam pi heg am waꞌi s‑nenꞌoid mamt ab aꞌai wo si has i e el. K eda d chum Jiosh mamt ab wo chum hehgchul. ");
INSERT INTO oodNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ni wabshaba pi d ahni manis ab wo haꞌichu em‑abch am ni‑ohg wui. Mosesbad chehanig am ab hiwig. K d hegai mat am wo tashogi g pi ap em‑chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosesbad at haꞌichu oꞌoha ab ni‑amjed. Kumt ab wo s‑ni‑wohoch mamt hems woho ab wo s‑wohochudad g Mosesbad oꞌohana. ");
INSERT INTO oodNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pi amt has masma ab hu wo s‑wohoch g ni‑ahga namki pi woho wohochud mat haschu an oꞌoha g Mosesbad.” Neh, bad kaij g Jesus am ha mihshmadch. Am i amjed, tt gam hu hahawa hihi Jerusalem t amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Am hu hebai ep amjed machd an oiopohim Galilee Kahchki hugid an ch gam hu hahawa i chehchsh haꞌabjed k am dada. ");
INSERT INTO oodNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","D eda muꞌi hemajkam chum hekid an oidahim g Jesus neidok mo g s‑hasig haꞌichu hab wua ha doajidch g kokꞌodam. ");
INSERT INTO oodNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","D ab i chesh g Jesus kawulk t ab. Kuchd ahchim waꞌi mach ab si wecho t‑mashcham am i oid k am wehmaj dadhaiwua. ");
INSERT INTO oodNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","D eda e aihim mat wo e wuhshad g t‑shohshon ha‑doꞌibiadag. ");
INSERT INTO oodNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kud muꞌi hegam mad gam hu wo piasto ab i hihi s‑kaimkch g Jesus. D am i ha nei g Jesus k hab kaij ab Philip wui, “Neh, Philip, chs hebai hig wo ui g haꞌichu hugi matt wo ha gegos haꞌakia i hemajkam?” ");
INSERT INTO oodNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Bo kaij ch wabsh s‑aꞌappemamk g Philip no pi wa chum s‑mahch mat has masma hab wo juh. ");
INSERT INTO oodNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","D hab kaij g Philip, “Pi att wo shaꞌi t‑nako. Chum achs hems gohk siant pihshkaj wo ui g pahn, t eda pi wo ha ai g haꞌakia hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","D hegai mo d Simon Peter nawoj ch hab chehgig Andrew hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ia o hema haꞌichug g ali ch hi wa hetasp sismito ch gohk waptopi uꞌa. T wabshaba pi haꞌichu ab hu wo shaꞌi ha nako haꞌakia hemajkam ha wehhejed”. ");
INSERT INTO oodNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","D ab hahawa t‑ahgid g Jesus matt wo ha cheha g hemajkam mat wo dadhaiwua no pi an s‑washaig. D am i wehsijj dadhaiwua g hemajkam k d hetasp mihl chechoj ch muꞌi ehp g uꞌuwi ch aꞌal. ");
INSERT INTO oodNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","D g Jesus am ui g sismito k ab hoꞌigeꞌel g Jiosh k ab t‑mah. Kuchd ahchim an hahawa i ha mahkhi g hemajkam. D hab waꞌap juh hegam gohk waptopi. Kuchd wehsijj hug k si s‑kokwod. ");
INSERT INTO oodNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","D hab hahawa t‑ahg g Jesus, “An g wo i uꞌihim g ha‑wiꞌa. Kutt pi haꞌichu wo shaꞌi heki wua.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kuchd an i uꞌihim k gamai gohk wapshomi ha shuhshud heg hekaj wihpiꞌidag. ");
INSERT INTO oodNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Neh, d am i nei g hemajkam mat si s‑hasig haꞌichu hab juh g Jesus k hab kaij, “Neh, mo d wabsh i si shel moki id d hegai Jiosh haꞌichu i tashogiddam mach nenida matsh ia wo jiwia id dahm jewed.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","D g Jesus ha amich mat an wabsh wo si be k wo geꞌe kownalch k hekaj gam hu hejel baꞌich i chesh doꞌag t ab. ");
INSERT INTO oodNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hudunihim o g tash. Kuchd gam hu i huhud ");
INSERT INTO oodNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","k am chum i chehchsh g wahlkokaj Capernaum wui nad pi hab t‑ah g Jesus k hab kaij matsh pi oi gam hu wo hih. D am i s‑chuk. ");
INSERT INTO oodNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","D g s‑gewk hewel ab i med k ab i kudu g shuhdagi. ");
INSERT INTO oodNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kuchd am himchud g wahlko am hu i giꞌik mihya. D ab haha wabsh hema him t‑wui an wabsh shuhdagi dahm. Kuchd hab i neidok si t‑totods. ");
INSERT INTO oodNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","D ab hahawa t‑wui neo k oki d Jesus ch hab kaij, “Pi g am wo e totodsid. Ahni ani wud”. ");
INSERT INTO oodNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kuchd si s‑ap i t‑taht k gan hu i cheshajch wahlko ch ed. Neh chd am waꞌi hekaj gan hu aigo dada mach am haꞌab t‑tatchua. ");
INSERT INTO oodNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Baꞌich i siꞌalim, d hegam hemajkam mad ab wih s‑mahch mad pi i t‑oi g Jesus no wa pi neid mo d hemako g wahlko. Kuchd ahchim waꞌi heg ab an dadhaiwua k i hihi. ");
INSERT INTO oodNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","D idam an chum gagahim ch pi cheh g Jesus k nei matt pi am hu ep dada. D oi wa am i haꞌi dada g wapalko ab Tiberias kihhim t amjed miabidk mat am ha gegos g Jesus hegam muꞌi hemajkam. D idam hemajkam an e baꞌiham k gam hu i gahgio Capernaum wui ");
INSERT INTO oodNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","K hekid am i chehg k hab kaij ab wui, “T‑mashchamdam, hekid apt ia i jiwia?” ");
INSERT INTO oodNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","D hab kaij g Jesus, “Am ani woho ni‑chehgidch em‑wui heg hekaj s‑hasig haꞌichu mani hab wua. M wabshaba pi heg hekaj ab s‑ni‑wohochudamk. Neh am ant em‑gegos. Kumt kokwod k heg wai hekaj ni‑gahg. ");
INSERT INTO oodNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pi g am wo si e kudutad wabsh g haꞌichu hugikaj ch wabshaba heg wo chum s‑behim mo d pi ha huhugedam. Ahni ani em‑makiog g pi ha huhugedam doakag. Heg at hekaj am i ni‑kei g Jiosh k am ni‑wohokamch.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","D hab kaij g hemajkam, “Tt has wo t‑juh k ab wo bei g pi ha huhugedam doakag?” ");
INSERT INTO oodNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","D g Jesus hab ha ahg, “Ihda waꞌi mamt ab wo ni‑hiwgad ahni Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","D hab ep kaij g hemajkam, “Am g hig hab juhni g s‑hasig haꞌichu. T heg am wo t‑chehgi map woho d Jiosh si Kehsha. Tt ab wo s‑m‑wohoch. ");
INSERT INTO oodNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Neh, ab ash gegshshe dahm kahchim t amjed hegai haꞌichu hugi mash hab e aꞌaga ‘manna’. Kush heg koꞌa g t‑shohshon mash am jeg ed oiopo. Bo chuꞌig g Mosesbad oꞌohana: Ab o ha mahk hegai haꞌichu hugi mo am gegshe ab dahm kahchim t amjed. Pegih, pt ahpi has hig wo juh?” ");
INSERT INTO oodNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","D hab ep kaij g Jesus, “Pi o d Mosesbad mo wa ab ha mahk hegai haꞌichu hugi. Do ni‑ohg mo wa hab wua. K heg d wabsh haꞌichu hugi mo wa heg hekaj d dodakam jewed dahm. K g ni‑ohg baꞌich i s‑kehg haꞌichu ab em‑makiog ");
INSERT INTO oodNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","mamt heg hekaj d wo dodakamk chum hekid. Id o heg wa wepo mo d s‑kehg haꞌichu hugi. Kumt wo be k heg ab wo bei g s‑kehg doakag.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","D ab si tahni ch hab kaij idam, “Ih, pegih, ab g chum hekid t‑mahkad ihda map hab ahg.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","D hab kaij g Jesus, “Ahni ani wud mo g ni‑ohg ab em‑makiog. Ab g wo ni‑hiwig. Nt wo em‑mah g pi ha huhugedam doakag. Id at heg wo wa wepok mamt wo huh g hab mahs haꞌichu mamt chum hekid d wo dodakamk ch pi hekid ep wo bihugk. ");
INSERT INTO oodNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nehꞌe mani wa hab wa heki hu kaij mam wa chum ni‑neid ch eda pi ab hu ni‑wui e dagitokch. ");
INSERT INTO oodNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","T wabshaba wehs ab ni‑wui wo i e dagito hegam mat g ni‑ohg am ha eda wo i chikp. Nt pi hedai wo shaꞌi ohhod mat ab wo i e dagito ni‑wui. ");
INSERT INTO oodNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","40","Do ni‑ohg tatchui mamt ab ni‑wui wo i e dagito ch hab wo edagi g pi ha huhugedam doakag. Nt wo si em‑nuhkudad mamt pi hedai wo heb hu wua g e‑doꞌibiadag. Kunt ab wo i em‑wuwhas muhkig t amjed mat hekid wo huhug ihda jewed. Id o d ni‑ohg tatchui. Kunt heg hekaj ia jiwia ab dahm kahchim t amjed.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","D g hahaꞌichu si gahghai e mohmgid ch s‑babgam neneok ");
INSERT INTO oodNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ch hab kaij, “K haschu ahgch hab kaij mat ia jiwia ab dahm kahchim t amjed? S‑mahch ach ch ep s‑ha mahch g jehj. Do wabsh Jesus ch d alidaj g Josephbad.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","D hab kaij g Jesus, “Pi g am wo gahghai e mohmgid k s‑babgam neneok. ");
INSERT INTO oodNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Pi at hedai wo shaꞌi e nako mas ab wabsh hejel wo i e dagito ni‑wui. Jiosh ni‑ohg at am wo i chikp ha eda. T hekaj ab ni‑wui wo i e dagito. T ab wo i e ai g si oidchkam tash. Nt ab wo i ha wuwhas muhkig t amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kekelibad Jiosh Haꞌichu i tashogiddam atki wa an oꞌoha: Wehsijj at wo ha mashcha g Jiosh g hemajkam. Neh, t ab ni‑wui wo i e dagito matp hedai ab wo kaiha g Jiosh ni‑ohg k ab wo mai g mashchamaj. ");
INSERT INTO oodNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pi am hedai g e‑wuhpuikaj neid g ni‑ohg. Ahni ani waꞌi neid nant pi ab amjed ia jiwia. ");
INSERT INTO oodNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Neh, hegam mat ab wo i s‑ni‑wohochud k wo ni‑bei at hekaj wo edagi g pi ha huhugedam doakag. ");
INSERT INTO oodNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","49","T‑shohshon ash wa koꞌa hegai manna ch wabshaba pi heg hekaj edagi g pi ha huhugedam doakag. Mt wo edagi hegai pi ha huhugedam doakag ab ni‑bek. Id o heg wa wepo mani d haꞌichu hugi em‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Baꞌich ani d i s‑kehg haꞌichu hugi mo hi hegai manna namt pi g pi ha huhugedam doakag wo edagi ab ni‑bek. ");
INSERT INTO oodNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","I atsh gei g manna ab dahm kahchim t amjed k ab ha mahkch g doakag. Ni wabshaba d ahni mant woho ia jiwia ab Jiosh kihdag amjed k ia uꞌapa g pi ha huhugedam doakag. Nt wo dagito g ni‑chuhkug mant wo ni‑muhkid k hab wo ha doꞌibia g hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","D id kaiok am si s‑babgam e neꞌowi g hahaꞌichu hab kaijch, “Pi at has shaꞌi masma wo t‑mah g e‑chuhkug machs wo huh.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","D hab kaij g Jesus, “Pi amt wo edagi g pi ha huhugedam doakag pi ab hu ni‑bek ahni Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ab amt wo i s‑wohoch mant wo iawua g ni‑ehꞌed k wo muh em‑wehhejed k hab wo edagi g pi ha huhugedam doakag. Id at heg wo wa wepok mamt wo huh g ni‑chuhkug k wo ih g ni‑ehꞌed. Kunt ab wo i em‑wuwhas muhkig t amjed mat hekid wo kuhgit g jewed. ");
INSERT INTO oodNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ihda ni‑chuhkug ch ni‑ehꞌed o heg wa wepo mo d haꞌichu hugi ch haꞌichu iꞌidag. ");
INSERT INTO oodNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","T wo edagi g wechij doakag hegam mat ab wo ni‑bei. Am ant ha eda wo ul g ni‑doakag. ");
INSERT INTO oodNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ni‑ohg at wa am ni‑cheha mant ia wo jiwia jewed dahm. Kuni d pi ha huhugedam doakam no pi g ni‑ohg d pi ha huhugedam doakam. T hab waꞌap d wo pi ha huhugedam doakamk matp hedam ab wo ni‑bei nant pi am ha eda wo ni‑ulinid chum hekid. ");
INSERT INTO oodNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Heg ani hekaj pi hab masma mo hegai manna. Hegam mash wa koꞌa hegai at pi heg hekaj edagi g pi ha huhugedam doakag. T wabshaba wo edagi matp hedam ab wo ni‑bei.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Neh, bad kaij g Jesus mad eda am ha mashcham g hemajkam ha‑cheopi ed amai Capernaum t am. ");
INSERT INTO oodNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","D muꞌijj hegam mo am t‑wehm oid g Jesus hab hahawa kaij, “Shoꞌoki waꞌi si s‑hasig ihda mashchamaj ch pi ab hu ta kaihama.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","D g Jesus wabsh ha amich mo has kaij an s‑juꞌujpij neneokch k hab kaij ab ha wui, “Pi amki hohhoꞌid g ni‑mashchama ");
INSERT INTO oodNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ch eda wo nei mant am uhpam ep wo hih dahm kahchim wui ahni Jiosh si kehsha. ");
INSERT INTO oodNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Pi amt wo bei g pi ha huhugedam doakag ab amjed g haꞌichu hugi k wabshaba ab wo s‑wohoch g haꞌichu ni‑ahga. Kunt ab wo cheha g Hekia S‑apꞌekam Gewkdag mat am em‑eda wo i e ulin k wo em‑mahkad g pi ha huhugedam doakag. ");
INSERT INTO oodNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kum eda haꞌijj pi ab hu ni‑wohochud.” Neh, bo kaij g Jesus no pi s‑mahch mat hedam pi ab hu wo wohoch ch ep s‑mahch mat hedai wo gagda mat wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","D hab ep kaij, “Pi amt hedai wo e nako mams ab wo s‑ni‑wohochud k wo ni‑bei, heg hi wa mat g ni‑ohg am wo i chikp em‑eda.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","D muꞌijj hegam mo am t‑wehm oid g Jesus dagito am i kaiok g s‑hasig haꞌichu ahgaj k pi dahm an hu hahawa ep wehmaj. ");
INSERT INTO oodNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","D heg hekaj hab kaij g Jesus ab t‑wui ahchim gamai gohk, “Mt ahpim has wo e juh? Namt hab waꞌap wo ni‑dagito?” ");
INSERT INTO oodNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","D g Simon Peter hab kaij ab wui, “T‑kownalig, pi o an hu hedai ehp machs heg wui wo hihi. Ahpi ap waꞌi am ahgachug hegai matt hekaj wo bei g pi ha huhugedam doakag. ");
INSERT INTO oodNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ch hahawa s‑wohochud ch s‑mahch map ahpi d hekia s‑apꞌekam ch ab amjed i hih g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","D hab kaij g Jesus, “Heuꞌu, woho o wa. Kunt am i em‑chuhcha ahpim gamai gohk mamt id an wo ahgachugad. M wabshaba hema d wabsh sha jiawul.” ");
INSERT INTO oodNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Pi achd mahch mas hedai hab ahg. Kuki eda heg hab ahg Judas mo d alidaj g Simon Iscariot ch d hema ahchim gamai gohk ch atki wo gagda g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Am amsh chum s‑muꞌamk g Jesus Judea chekshani ch ed. D hekaj pi am hu himimk. Kuchd an oiopo Galilee chekshani ch ed. ");
INSERT INTO oodNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","D eda e aihim hegai piast mach ab ihm g Jiosh mo babhaijid g t‑eꞌes. ");
INSERT INTO oodNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","D heg hekaj hab kaij g Jesus wepnag ab wui, “Pt hems gm hu wo hih iꞌajed Judea wui. T wo nei g s‑hasig m‑chikpan hegam mo wa an m‑oidahim Judea ch ed. ");
INSERT INTO oodNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pi apt wo ge ehstod hegai map hab junihim maptp wo tatchuad mat ab wo i m‑mai g hemajkam. Am g ha chehgid g hemajkam map hab wua g s‑hasig haꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Neh, bad kaij noki pi koi wohochud mo d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","8","D hab kaij g Jesus ab ha wui, “Pi ant am hu wo em‑oi id wui gegosig nat pi koi e ai mant am wo si s‑ap i ni‑maskogi. Mt gamai wo hihi namt pi ahpim hi wa wabsh chum hekid am wo e chehgi. Pi o am hu haꞌichug mas heg hekaj wo s‑em‑kehꞌidad g hemajkam. K wabshaba ahni s‑ni‑kehꞌid nani pi chum hekid ab ha ahgid mo am hab junihim g pi apꞌekam.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Neh, bad kaij ab ha wui ch am wabsh i wih Galilee ch ed. ");
INSERT INTO oodNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Heg i dahm mad gam hu hihi g Jesus wepnag, d am hahawa epai him k wabshaba wabsh s‑aꞌagi. Kuchd ahchim gam hu i oi. ");
INSERT INTO oodNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sh hegam mo d hahaꞌichu am Judea ch ed an gahg ch an kaiam mas hebai has chuꞌig. ");
INSERT INTO oodNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","D eda an s‑juꞌujpij neneok g hemajkam ch hab kaij, “Do si s‑ap oꞌodham.” D haꞌi hab ep kaij, “Pi o ap d oꞌodham no pi t‑iattogid.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","K wabshaba s‑aꞌagi an aꞌaga no pi s‑ha ehbid g hahaꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kud eda hugkam waꞌi hih g piast. D am hih g Jesus geꞌe cheopi wui k am i ha mashcha. ");
INSERT INTO oodNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","D hegam hahaꞌichu si has i elid k hab kaij, “S has hig masma geꞌe haꞌichu s‑mahch ihda oꞌodham mat eda pi shaꞌi e mashcha g papal ha‑mashchama?” ");
INSERT INTO oodNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","D hab kaij g Jesus ab ha wui, “Jiosh at ab ni‑cheha mant ia wo jiwia jewed dahm. K d Jiosh mashchamadag ihda mani i ha mashcham. ");
INSERT INTO oodNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tp hedai wo i tatchuad mat am hab wo juh g Jiosh tatchui wo chum s‑mahchk mas wa woho d Jiosh amjedkam ihda mani i ha mashcham. ");
INSERT INTO oodNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Hegai mat wo ah g hejel e‑mahchig at wabsh wo chum si e haschud k atp hems d s‑chu iattomkam. Nt wabshaba ahni ab haꞌichuchud g Jiosh ch am ahg g wohokam. ");
INSERT INTO oodNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Bam chum e wua mam am hab si junihim hegai chehanig mat wa g Jiosh ab mah g Moses am em‑wehhejed. M wabshaba pi woho hab junihim nam pi s‑ni‑muꞌamk.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","D ab si neneok g hemajkam ch hab kaij, “P haschu ahgch hab kaij mam s‑m‑muꞌamk? Jiawul o an uꞌukch g m‑chegitoidag.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","D hab kaij g Jesus ab ha wui, “Woho am s‑ni‑muꞌamk. Ha ant dodaj mihshmda tash ed. Kum heg hekaj s‑ni‑muꞌamk. ");
INSERT INTO oodNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Neh, nt am wo em‑chehgi mam ahpim hab waꞌap wua g chikpan mihshmda tash ed. Mosesbad atki wa an oꞌoha mat haschu g Jiosh heki hu ab ha cheha g t‑shohshon mamt wo ha pahl hikuch g e‑chechoj aꞌaliga mat d wo i gigiꞌik tashk ab ha‑mahsidag amjed. Kum heg hab wua chum as hems d wo mihshmda tashk ");
INSERT INTO oodNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","mamt pi wo mul hegai chehanig matki g Mosesbad an oꞌoha. Pegih, mt haschu ahgk babgat mant hema s‑ap doaj am mihshmda tash ed? ");
INSERT INTO oodNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Am g wo si i aꞌamichud mamt s‑ap wo s‑mahchk haꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","D haꞌijj hab kaij g Jerusalem t am kihkam, “Aha no hig pi woho d ihda mam chum s‑muꞌamk. ");
INSERT INTO oodNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","K eda haschu ahgch pi hedai has ahg? K ia t‑jehnigid. Aha no hab elid g hahaꞌichu mo wa woho d Jiosh si Kehsha? ");
INSERT INTO oodNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","S has hig masma d wo hegaik mach eda s‑mahch mo hedai d amjedkam ch hebai d kihkam. Kutsh wa eda g Jiosh si Kehsha pi hedai wo mahchk mat hebaijed ia wo jiwia.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","D si s‑kaidam hab kaij g Jesus, “Pegih, s‑mahch am mani hedai wud ch hebaijed him. Nt wabshaba pi wabsh hejel ni‑wehhejed i hih. Jiosh o ab ni‑chehani mant ia wo i wuhsh jewed dahm. Kum pi mahch g Jiosh ch hekaj pi woho ni‑mahch. Ahni ani hi s‑mahch ch ep s‑mahch mo d wohokam nant pi ab amjed i hih.” Neh, bad kaij g Jesus am ha mashchamch geꞌe cheopi ch ed. ");
INSERT INTO oodNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kumd am hahawa chum bei. T wabshaba pi koi e ai g tashgaj. D pi e nako idam. ");
INSERT INTO oodNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kud muꞌi ab i s‑wohochud k wabsh s‑juꞌujpij hab kaij ab aꞌai e wui, “Naꞌas woho d Jiosh si Kehsha nat pi pi hedai wo shaꞌi e nako mas hab wo juh hegai hab mahs s‑hasig haꞌichu mo ihda hab wua.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","D am haꞌi oiopo g Palasi ch am i kah hegai mo hab e kaij k am hihim k atsh am ha ahgi g uꞌugchu papal. Tsh hegam am ha cheha g geꞌe cheopi nuhkuddam mat an wo bei g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","D hab kaij g Jesus, “Pi ant shaꞌi tash ia hu wo em‑wehmajkahim ch gam hu hahawa uhpam wo hih heg wui mat ia i ni‑ahꞌad. ");
INSERT INTO oodNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kumt wo chum ni‑gahgad ch wabshaba pi wo ni‑edgid k pi wo e nako mams am wo hihi mant hebai wo haꞌichugk.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","D am wabsh i pi amich g hemajkam k hab kaij ab aꞌai e wui, “A t hebai wo hih, chs hab pi wo edagi?” D haꞌi hab ep kaij, “Naꞌas gam hu wo hih goꞌol hemajkam ha‑kihhim wui mo am haꞌichug g t‑wehm oꞌodham k wo ha mashcha g goꞌol hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A shahꞌo d ahga mo hab kaij matt wo chum gahgad ch wabshaba pi wo edgid k pi wo t‑nako machs am wo hihi mat hebai wo haꞌichugk.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","D am i e ai g si oidchkam tash mo baꞌiwechkim d si geꞌe tash heg eda piast. D am e hemapadch g hemajkam. Kud g Jesus am si amog ch hab kaij, “Ab g wo i e dagito ni‑wui k ab wo bei g wechij doakag hab masma mamt hemho wa wo ih am i tonomk. ");
INSERT INTO oodNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bo chuꞌig g Jiosh oꞌohana mamtp hedai ab ni‑wui wo i e dagito k heg wa wepo mamt wo edgidad g shonkam shuhdagi am e‑ihbdag ed. T heg chum hekid ab wo daꞌiwunid.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Bo kaij g Jesus ch hab ahg matt ab wui wo i t‑dagito k hekaj wo bei g Hekia S‑apꞌekam Gewkdag. K eda wenog koi ab hu t‑mahks g Hekia S‑apꞌekam Gewkdag nat pi koi gahi wuhsh g muhkig g Jesus k koi bei g e‑kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","D muꞌi hab kaij am i kaiok, “Ihda oꞌodham oki d wa woho hegai Jiosh haꞌichu i tashogiddam mach nenida.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","D hai hab ep kaij, “Doki Jiosh si Kehsha.” D wabshaba haꞌijj hab epai kaij, “Pi oki d shaꞌi hegai no pi d Galilee t am oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","K eda an hab chuꞌig Jiosh oꞌohana ed matsh g Jiosh si Kehsha ab d wo t‑kownaligbad David amjedkamk ch ab wo amjedk g Bethlehem kihhim. Am ash d kihkam g Davidbad Bethlehem t am.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","D heg hekaj ab aꞌai e wui gegokiwua g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Haꞌijj o chum s‑kuhpamk. D wabshaba pi hedai shaꞌi e nako mas hab juh. ");
INSERT INTO oodNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","D am uhpam hihi g geꞌe cheopi nuhkuddam am ha wui g uꞌugchu papal ch Palasi. D idam ab ha kakke ch hab kaij, “Shahchu amt ahgk pi an hu bei?” ");
INSERT INTO oodNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","D hab kaij g geꞌe cheopi nuhkuddam, “Pi o hekid hedai hab shaꞌi kaidam neok mo ihda.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","D hab kaij hegam Palasi ab ha wui, “Aha nat hab waꞌap em‑iattogi? ");
INSERT INTO oodNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Pi ach hedai ab hu s‑wohochud ahchim Palasi o hegam mo d t‑wanimeddam mas d Jiosh si Kehsha ihda. ");
INSERT INTO oodNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Idam pi haꞌichu aꞌamichuddam hemajkam o ab s‑wohochud no pi pi mahch g Mosesbad chehanig. T g Jiosh s‑koꞌokam wo ha namkid.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","D am ha wehmaj hegai mat wa am hu hebai chuhug ch ed am i chehgim g Jesus k hab chehgig Nicodemas. Id o hab waꞌap d Palasi ch hab kaij ab ha wui, ");
INSERT INTO oodNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bo chuꞌig g t‑chehanig matt pi hedai ab hu wo shaꞌi haꞌichu ha abch k hoꞌipki am i mamche am lodaitk mas wa woho pi ap haꞌichu hab juh.” ");
INSERT INTO oodNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","D hab kaij idam, “Pegih, pki ahpi ab ep si ha wehmaj idam mo ab wabsh al Galilee t amjed. Am g i hoan g Jiosh haꞌichu ahga k wo s‑mai mo pi hema g Jiosh haꞌichu i tashogiddam ab hu shaꞌi Galilee t amjed.”  ");
INSERT INTO oodNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","D amjed gam hu aꞌai himto g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kuchd ahchim gam hu hihim k an kohksh Olive Uꞌus Kawulk t an. ");
INSERT INTO oodNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","D ab i chesh g tash. Kuchd ged hu uhpam dada geꞌe cheopi wui. D muꞌi am e chehm g hemajkam Jesus wui k gan hu biha. D am dahiwua k ha mashcha. ");
INSERT INTO oodNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","D ab wui haꞌi dada g chehanig ha mashchamdam ch Palasi am hema uꞌapadch g uwi. Id atsh ha ehs g ha‑kun. Kud am t‑shahgid i kehsh ");
INSERT INTO oodNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","K hab kaij ab wui g Jesus, “Neh, ahpi map ia ha mashcham, ihda uwi att s‑ap cheh mat ha ehs g ha‑kun. ");
INSERT INTO oodNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","K eda hab chuꞌig g t‑chehanig matt hemho wo wa maꞌichkwua k wo mua g uwi mat hab wo sha e juh. Pt ahpi has wo chei?” ");
INSERT INTO oodNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Neh, bo kaij no pi wabsh haꞌichu s‑kaimk ch s‑abchudamk g Jesus. D wabshaba g Jesus pi ab hu shaꞌi ha hudawog k am wabsh Haꞌichu oꞌoha jewedo g e‑nowikaj. ");
INSERT INTO oodNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","D oi wa idam pi dagito k ab ep kakke. D ab hahawa i e shel g Jesus k hab kaij ab ha wui, “Pegih, mt ahpim wehpeg ab wo maꞌihi g uwi mamt hedai pi hekid hab shaꞌi juh g pi apꞌekam.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Bo kaij ch am hahawa i e jumalkad k am ep oꞌoha jewedo. ");
INSERT INTO oodNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","D am i kah ihda g chehanig ha mashchamdam ch Palasi k wabsh sha hehemako gam hu aꞌai hihi si e elidch. D hegam mo d geꞌeged wehpegat k wehsijj himto. K heg am waꞌi wih uwi Jesus wehm. ");
INSERT INTO oodNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","D ab i e shel g Jesus k ab wui hab kaij, “Baht hihi hegam mo ab haꞌichu m‑abchud? Nat pi ia hu hema wih mat ab wo m‑maꞌihi?” ");
INSERT INTO oodNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","D hab kaij g uwi, “Pi at ia hu hema wih, ni‑kownalig.” D hab hahawa ep kaij g Jesus, “Ahni ani hab waꞌap pi ab hu haꞌichu m‑abchud. Gamai g hihm k pi hab ep juhni g pi apꞌekam.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","D hab ep kaij g Jesus ab ha wui g hemajkam, “Dani geꞌe tonlig am wehs ha wehhejed g hemajkam. Kut s‑ap am wo himad Jiosh apꞌedag ed ch pi hekid haꞌichukaj wo pi e amich hegam mat hedai ab ni‑wui wo e dagitokchid.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","D eda am haꞌi gegok g Palasi ch ab wui hab si kaij, “Ih, p wabsh chum hejel e wohokamchud ch aptp hems wabsh t‑iattogid.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","D hab kaij g Jesus, “Pi ani em‑iattogid chum anis am hi wa hejel ni‑wohokamchud. Do wohokam mani has i kaij. S‑mahch ani mant hebaijed ia jiwia k hebai wo hih. Ahpim am hi pi mahch ihda. ");
INSERT INTO oodNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Am am chum ahg mani has chuꞌig ab wabsh ni‑neidch ch eda pi woho ni‑mahch. Ni ahni hemu pi hedai em‑lodait. ");
INSERT INTO oodNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kut wabshaba d wo wohokamk g ni‑ahga mant hekid wo ah mam has chuꞌig nat pi g Jiosh am ni‑wehm wo em‑aꞌappe. ");
INSERT INTO oodNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Neh, an o oꞌohanas em‑chehanig ed mamt wo s‑ha wohoch matp gohkajj am haꞌichu wo wohokamch. ");
INSERT INTO oodNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pegih, ni ahni hejel ni‑wohokamchud. K g ni‑ohg am hab waꞌap ni‑wohokamchud.” Neh, bo kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","D ab kakke idam, “A k hebai has chuꞌig g m‑ohg?” D hab kaij g Jesus, “Pi am shaꞌi ni‑mahch ch ep pi mahch g ni‑ohg. Mt hems wo s‑ap s‑ni‑mahchk ch hab waꞌap wo s‑mahchk g ni‑ohg.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Neh, id ad wehs hab kaij g Jesus am geꞌe cheopi t am heg eda kih mo g hemajkam am shulig g e‑mahkigdag g geꞌe cheopi wehhejed. T pi hedai e nako mas an wo bei nat ge koi e ai g tashgaj. ");
INSERT INTO oodNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","D hab ep kaij g Jesus ab ha wui, “Am ant hu wo hih. Kumt an haha wo i chum ni‑gahghim k wabshaba wo koi pi e doꞌibiak. Pi amt wo e nako mamt am wo hihi mant hebai wo i hih.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","D heg hekaj hab kaij hegam hahaꞌichu, “Shahꞌo ahgch hab kaij matt pi wo t‑nako matt am wo hihi mat hebai wo i hih. Aha nat wabsh hejel wo e mua.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","D hab kaij g Jesus ab ha wui, “Ia am waꞌi amjed id dahm jewed. Ni ahni hi ab dahm kahchim amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kum eda pi ni‑wohochud mani d ge ahni. Ni heg hekaj am em‑ahgid mamt wo koi pi e doꞌibiak.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","D ab kakke, “Kup hedai wud higi?” D hab kaij g Jesus, “Ahni ani wud mani ga hu i wehpeg hab kaij mani hedai wud. ");
INSERT INTO oodNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Muꞌijj o g em‑chuꞌijig. Kunt heg wo ah. K g ni‑ahga d wohokam nani pi heg waꞌi ahg mo haschu ni‑ahgid hegai mat am i ni‑kei. K heg chum hekid ahg g wohokam.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","D idam pi amichud mo g Jiosh hab ahg. ");
INSERT INTO oodNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","D heg hekaj hab ep kaij g Jesus, “Mt wo mai mani d ge ahni mamt hekid ab uhgk wo ni‑ul mamt wo ni‑mua ahni Jiosh si Kehsha. Am amt haha wo mai mani pi hab wua g hejel ni‑tatchui ch wabshaba hegai waꞌi ni‑ohg tatchui hab wua ch g mashchamaj ahgachug. ");
INSERT INTO oodNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Chum ani hekid ab s‑wohog elid. K heg hekaj ni‑wehmaj.” Neh, bo kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","T muijj hegam mat ab kah ihda ab i s‑wohoch. ");
INSERT INTO oodNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","D heg hekaj hab kaij g Jesus ab ha wui hegam mat ab i chum s‑wohoch, “Mtki woho ab i e dagito ni‑wui mamtp am hab wo i junihi g ni‑mashchama. ");
INSERT INTO oodNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mt haha wo mai g wohokam. T heg hab wo em‑juh mamt hahawa pi d wo neneholk.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","D haꞌi hab kaij, “Pi ach hekid hedai d shaꞌi neneholiga nach pi d Abrahambad amjedkam. P haschu hab ahg ch hab kaij matt hahawa pi d wo neneholk?” ");
INSERT INTO oodNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","D g Jesus hab kaij, “Wehs am d nenehol mamtp hedai hab i junihim g pi apꞌekam nam pi heg hekaj e wulshch. ");
INSERT INTO oodNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pi o am hu ha wehm d si kihkam g nehol mo hig g ha‑aliga. ");
INSERT INTO oodNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nt ahni woho wo i em‑wulꞌo mamtp ab wo i e dagito ni‑wui. Kumt hahawa pi d wo neneholk namt pi d wo aꞌaligajk g ni‑ohg Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","S‑mahch ani mam d Abrahambad amjedkam. M eda s‑ni‑muꞌamk nam pi pi ab hu ap wohochud g ni‑mashchama. ");
INSERT INTO oodNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Heg ani am ahgahim mo haschu g ni‑ohg ab ni‑chehgid. M ahpim hi heg wa wepo mam d ge Jiawul amjedkam nam pi hab wua g tatchuij.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","D hab kaij ab wui, “Pi ach d ge Jiawul amjedkam. Abrahambad o d t‑shohshon.” D hab kaij g Jesus, “Pegih, m haschu ahgch pi hab masma hab e wua mo g Abrahambad no pi heg chum hekid hab wua g s‑apꞌekam. ");
INSERT INTO oodNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","M eda am e nakog mamt wo ni‑mua ahni mani heg waꞌi em‑ahgid wohokam mo g Jiosh ab ni‑ahgid. ");
INSERT INTO oodNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Heg am d wabsh amjedkam mam am oidch hab e junihim.” D hab kaij, “Ahchim ach hi pi d shaꞌi shaꞌi ch ed ha‑aꞌaliga. Jiosh o d si t‑ohg.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","D hab kaij g Jesus, “Ia ant jiwia ab amjed g Jiosh. Kumt heg hekaj ab wo si ni‑tatchuad mamtp woho d wo aꞌaligajk. Pi ant wabsh hejel hab i ni‑ah mant ab wo i hih. Jiosh at ab ni‑chea. ");
INSERT INTO oodNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Pi am amichud mani has i kaij nam pi s‑koꞌokod g haꞌichu ni‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Dam wabsh ge jiawul amjedkam ch s‑hohhoꞌid mamt am hab wo wuad g tatchuij. Heg o d ha muꞌakam ged hu i si wehpeg amjed ch d ep s‑chu iattomkam ch pi has shaꞌi elid haꞌichu ha iattogidch no pi wehs g iattogig ab d amjedkamaj. ");
INSERT INTO oodNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kuni ahni g wohokam ahg. Kum heg hekaj pi ni‑wohochud. ");
INSERT INTO oodNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Neh, namt hig wo e nako mamt am wo wohokamch mas haschu d i pi ap ni‑chuꞌijig? Pegih, ab o em‑ab mamt ab wo s‑ni‑wohoch nani pi em‑ahgid g wohokam. ");
INSERT INTO oodNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hegai mo ab d amjedkamaj g Jiosh o ab kaiham g Jiosh neꞌoki. Kum pi ab hu kaiham nam pi pi ab hu d amjedkamaj.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","D g hahaꞌichu ab hahawa si chehmo g Jesus ch hab kaij, “Dapki wabsh t‑obga ch d wabsh sha jiawul.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","D hab kaij g Jesus, “Pi o woho mam has i kaij. Pi ani d shaꞌi jiawul. Ab ani si haꞌichuchud g ni‑ohg. M wabshaba ahpim wabsh pi ni‑haꞌichuchud. ");
INSERT INTO oodNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pi ani heg am hu neidahim mas hedai ab wo si has ni‑elidad. K wabshaba am hema d hegai mo am ni‑gahgid g ab has elidadag ch wo ha lodai hegam mo pi ab hu has ni‑elid. ");
INSERT INTO oodNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nt wo si shel em‑ahgi mat pi hekid wo huhug hegai mat hedai ab wo si i bei g haꞌichu ni‑ahga.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","D hab kaij ab wui, “Si att hahawa s‑ap s‑mai mapki d wabsh sha jiawul. Neh, muh at g Abrahambad. T g kekelibad Jiosh haꞌichu i tashogiddam hab waꞌap koꞌok k huhug. P eda hab kaij mat pi hekid wo huhug hegai mat hedai ab wo si i bei g haꞌichu m‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Chum apki si e haꞌichuchud ch hab kaij ihda. Abrahambad atki muh. Nap hab e elid map gam hu baꞌich d i si haꞌichu mo hegai? T g Jiosh haꞌichu i tashogiddambad hab waꞌap koꞌok k huhug. Dohp hab chum e elid?” ");
INSERT INTO oodNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","D hab kaij g Jesus, “Nt wabsh wo pehegi neokad mantp ab hejel wo chum si ni‑haschudad. Heg o ab si has ni‑elid ni‑ohg mam e‑Jioshga ahg. ");
INSERT INTO oodNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pi am hekid shaꞌi woho mahch hegai. Ni wabshaba ahni s‑mahch. Kuntp hab wo chei mani pi mahch k d wabsh wo s‑chu iattomkamk mam hab chuꞌig ahpim. S‑mahch ani ch ab si uꞌukch g haꞌichu ahgaj. ");
INSERT INTO oodNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Em‑shohshon Abrahambad o si s‑ap e tahtk mat wo nei mant an wo i wuhsh. T hekid i neidok si s‑hehgig.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","D si has i el idam k hab kaij, “Ih, heki at hu waꞌi muh. Aha nap neid ch eda pi koi ai g hetaspo wehst‑mahm ahidag?” ");
INSERT INTO oodNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","D hab kaij g Jesus, “Nt wo si shel em‑ahgi mani an haꞌichug ni‑ohg kih ed mat eda koi mahsi g Abrahambad.” ");
INSERT INTO oodNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Neh, d gan hu i uꞌihi g hohodai mat hekaj wo maꞌichkwua g Jesus. D wabshaba wabsh s‑aꞌagi am ha shahgid him k gam hu i wuhsh geꞌe cheopi amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kuchd am hihim. D ab haha wabsh hema daha g oꞌodham ch e‑mahsidag amjed pi nea. ");
INSERT INTO oodNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kuchd ab kakke g Jesus, “Neh, t‑mashchamdam, dohꞌo d chuꞌijig mo d pi neadam ihda oꞌodham? No d hejel chuꞌijigaj aha no d geꞌegedgaj ha‑chuꞌijig?” ");
INSERT INTO oodNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","D hab kaij g Jesus, “Id o pi hab d shaꞌi ahga mas d ha‑chuꞌijig. Heg o hekaj pi nea mat g Jiosh am wo chehgi g e‑gewkdag ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Am att hab wo junihid g chikpanaj hegai mat ia i ni‑ahꞌad mo idani am kia wiꞌis g tash no pi ab him mamt hahawa pi wo e nako. ");
INSERT INTO oodNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Dani tonlig am em‑wehhejed mani ia em‑wehmaj.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","D hab cheꞌiok g Jesus k am siswua jewed dahm k am hab juh g bid k hekaj ab bidsh g wuhpuij hegai pi neadam ");
INSERT INTO oodNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","k hab ahg, “Am g him k ab i wakon g e‑wuhiosha heg eda woꞌo mo hab e aꞌaga Siloam.” (K hab d ahga ihda “I Ahꞌad.”) T wa woho am hih ihda pi neadam k am wako g e‑wuhiosha k am i uhpam jiwia s‑ap haꞌichu neidch. ");
INSERT INTO oodNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hegam mo s‑mahch ch hegam mo si neid mo wabsh haꞌichu ha tahni ad am i neidok hab kaij, “Aha no pi woho d hegai mo am dahiwup ch haꞌichu ha tahni?” ");
INSERT INTO oodNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","D haꞌi hab kaij mo d hegai. D haꞌi hab ep kaij, “Pi o d hegai. Ho o wabsh si wepo mahs.” D hekaj hab kaij ihda mo wa pi neakahim, “Dani ahni.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kumd ab ep kakke, “Shahpt masma nent?” ");
INSERT INTO oodNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","D hab kaij, “Hegai mash d Jesus at ab bidsh g ni‑wuhpui am jewedo siswuak k hab ni‑ahg mant wo him k wo wako g ni‑wuhiosha am Siloam woꞌo ch ed. Kunt am him k hab wabsh chum ni‑wakon k ha hekaj s‑ap haꞌichu neid.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","D hab kaij idam, “T hebai hih?” Kud hab hahawa kaij mo pi mahch mas hebai hih. ");
INSERT INTO oodNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","D am wa haꞌi bei ihda oꞌodham mo wa pi nea am Palasi ha wui. ");
INSERT INTO oodNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","K d t‑mihshmda tash mad eda g Jesus hab juh ihda. ");
INSERT INTO oodNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","D g Palasi ab hahawa kakke mas has masma nent. D hab kaij, “Hegai Jesus at ab bidsh g ni‑wuhpui am siswuak jewedo. Nt ab i wako g ni‑wuhiosha k hahawa s‑ap haꞌichu neid.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","D haꞌi hab kaij hegam Palasi, “Neh, pi o ab hu shaꞌi Jiosh amjed nat pi melchkwua g t‑chehanig hab juhk ihda t‑mihshmda tash ed.” D am aꞌai e wui gegokiwua g hemajkam nad pi haꞌijj hab epai kaij, “Pi at wo e nako g pi ap chuꞌijkam mas hab mahs s‑hasig haꞌichu hab wo juh.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","D heg hekaj ab ep si kakke hegam Palasi, “Shahp i elid hegai oꞌodham map hab kaij mat m‑nench.” D hab kaij, “Bani elid mo d ge Jiosh haꞌichu i tashogiddam.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","D wabshaba pi wohochud idam hahaꞌichu mas wa woho d pi neadam ch am ha waid g geꞌegedgaj ");
INSERT INTO oodNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ch muꞌi haꞌichu ha kakke mas d ha‑aliga ihda ch ga hu i e‑mahsidag amjed pi nea, kch ehp mas has masma hahawa haꞌichu neid. ");
INSERT INTO oodNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","D hab hahawa kaij g geꞌegedgaj mo d ha‑aliga ch ga hu e‑mahsidag amjed pi nea ");
INSERT INTO oodNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ch wabshaba pi mahch mas has masma s‑ap haꞌichu neid ch ep pi mahch mas hedai doaj ch ab ha ahgid mat wo kakke no pi d geꞌe k ch hejel am wo e ah. ");
INSERT INTO oodNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Hegam hahaꞌichu ad wa am heki hu apꞌech mat pi wo ha hiwigi mat am hu ep wo i wahp cheopi ch ed hegam mat hedam hab wo chei mo g Jesus d Jiosh si Kehsha. D heg hekaj s‑ha ehbid g geꞌegedgaj ch hab kaij mat ab wo kakke, t hejel am wo e ah. ");
INSERT INTO oodNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","D ab ep i wai g Palasi ihda mat bei g e‑nendag k hab ahg, “Am g t‑ahgid g wohokam mapt ab wo hehgchul g Jiosh. S‑mahch ach mo ihda has chehgi d pi ap chuꞌijkam.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","D hab kaij ihda mat bei g e‑nendag: “Pi ani shaꞌi mahch mas d pi ap chuꞌijkam ch wabshaba id s‑ap s‑mahch mani pi neakahim ch hemuch haha wabsh si s‑nea.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","D idam ab hahawa ep kakke, “T has m‑juh k m‑nench?” ");
INSERT INTO oodNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","D hab kaij, “M ani wa heki hu em‑ahgid. Mt pi ab hu ni‑kaiha. A m haschu ahgch ab ep ni‑kakke? Aha namt ahpim hab waꞌap ab wo i s‑wohoch mo d Jiosh si Kehsha?” ");
INSERT INTO oodNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","D idam ab si s‑kehꞌid ch hab kaij, “Ahpi apt ab i s‑wohoch hegai hemajkam. Ahchim ach hi g Mosesbad ab s‑wohochud. ");
INSERT INTO oodNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","S‑mahch ach mo g Jiosh g Mosesbad ab haꞌichu ahgid. Kuch pi shaꞌi mahch mas hebai amjed him hegai.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","D hab kaij ihda, “M haschu ahgch pi mahch mas hebai amjed him. T eda ab i ni‑nench. ");
INSERT INTO oodNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","S‑mahch ach mo g Jiosh pi ab hu kaiham g pi ap chuꞌijkam ch wabshaba ab ha kaiham hegam mo ab si has elid ch am hab junihim g tatchuij. ");
INSERT INTO oodNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pi ach hekid shaꞌi kah mas hedai i nench hegai mo e‑mahsidag amjed pi nea. ");
INSERT INTO oodNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","T hi wo wa e nako hema mat hab wo juh ihda hab mahs haꞌichu matp ab Jiosh amjed wo himad.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","D ab si s‑koꞌokam has ahg ch hab kaij, “Dap wabsh si hekia pi apꞌekam ga huꞌi e‑mahsidag amjed ch eda chum haꞌichu t‑mashcham.” D amjed gam hu si i wuhshad cheopi t amjed k pi hiwigi mas am ep wo i wah. ");
INSERT INTO oodNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","D kah g Jesus mamt i wuhshad k am i gahghim k hab kaij am i chehgiok, “Nap ab si hiwig g Jiosh si Kehsha?” ");
INSERT INTO oodNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","D hab kaij ihda oꞌodham, “A k hedai wud. Am g ni‑ahgid. Nt ab wo si i hiw.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","D hab kaij g Jesus, “Dani ahni map hahawa s‑ap ni‑neid mant wa m‑nench.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","D ab si i gei wui k hab kaij, “Ab ani si m‑hiwig, s‑apꞌekam ni‑kownalig.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","D hab hahawa kaij g Jesus, “Ia ant jiwia jewed dahm mant wo mahsko wua mo hedai pi nea ch hedai s‑nea id eda Jiosh apꞌedag.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","D haꞌi am gegok g Palasi ch si has i elid k hab kaij, “Nap ahchim hab ep chum t‑ahg mach hab waꞌap pi nenea.” ");
INSERT INTO oodNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","D hab kaij g Jesus, “Pi amt ab hu wo em‑abch mamtp wo wohokamch mam pi nenea am Jiosh apꞌedag ed. M wabshaba hab chum kaij mam s‑nenea.” ");
INSERT INTO oodNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","D hab ep kaij g Jesus, “No hig pi woho mat g s‑chu ehskam wabsh s‑aꞌagi haskojed ab wo i wah heg eda kolhai mam am ha nuhkud g kahwal k wo s‑ha ehsidam? ");
INSERT INTO oodNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","T wabshaba g si ha nuhkuddam ab wo i wah kihjeg amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","T g kihjeg nuhkuddam ab wo i kuhpiꞌoki. K g ha nuhkuddam am si ha chehcheg ch gam hu i ha wanimed. ");
INSERT INTO oodNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","T am wo i wuwhag k gam hu wo i oi no pi s‑mahch g neꞌokij. T am ha baꞌich wo himad. ");
INSERT INTO oodNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pi at hedai ep wo i oi no pi pi mahch g ha‑neꞌoki k wabsh wo e gantad.” ");
INSERT INTO oodNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Neh, id ad hekaj am chum haꞌichu ha mashcham g Jesus. D wabshaba pi shaꞌi amichud mo haschu hab ahg. ");
INSERT INTO oodNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","D heg hekaj hab ep kaij, “Ahni ani hab ni‑ahg ch ni‑wepogid g kolhai kihjeg. ");
INSERT INTO oodNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Hegam mo hab e aꞌaga mo d em‑wanimeddam ch eda pi ab hu ni‑wohochud o d s‑chu eꞌeskam ch d ha muꞌakam. K wabshaba g ni‑wohochuddam pi ab hu ha kaiham. ");
INSERT INTO oodNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Heg ani wepo mo g kihjeg. Kahwal o am wapke kolhai ch ed. K pi haꞌichu has e wua am ha tahgio. Kumt ahpim ab wo s‑ni‑wohochud k hab waꞌap wo e doꞌibia. Kahwal o ab mahks g s‑kehg haꞌichu hugi. Kum ahpim ab ep mahks mam haschu i tatchua. ");
INSERT INTO oodNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","S‑chu ehskam at wo jiwia mat wo ha uꞌu k wo ha kokda. Nt ahni ia jiwia mant s‑baꞌama ab wo i em‑mah g doakag ");
INSERT INTO oodNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","nani pi s‑wohom d em‑nuhkuddam. “Neh, kahwal ha nuhkuddam at chum hems ha wehhejed wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Hegai mo d wabsh ha‑pionag at am wabsh wo i ha dagito k wo meh mat am wo jiwia g shehꞌe. T g shehꞌe am wo wahk k wo muꞌa k wo ha gantad. ");
INSERT INTO oodNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Pion at wo heb hu meh no pi pi ha tatchua g ha‑shoshoiga. ");
INSERT INTO oodNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Nt eda ahni wo i nako g shoꞌigdag am ha wehhejed g ni‑wohochuddam hab masma mo g si ha nuhkuddam g kahwal chum anis wo ni‑muhkid am ha wehhejed. Kahwal ch ha nuhkuddam o ab aꞌai s‑e mahch. Kuch g ni‑wohochuddam ch ahni ab hab waꞌap aꞌai s‑t‑mahch. Ch ahchim g ni‑ohg wehm hab wa masma ab aꞌai s‑t‑mahch. ");
INSERT INTO oodNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ha nuhkuddam at wehs ab wo i ha hemapai g e‑kahwaliga. Nt ahni hab wa masma ab wo i ha hemapai wehs hegam mat ab wo i s‑ni‑wohoch, chum hems g gawul mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Am ant wabsh wo i ni‑dagito muhkig wui. K g ni‑ohg heg hekaj si ni‑tatchua. Nt ab uhpam ep wo i ni‑chegito. ");
INSERT INTO oodNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Pi at hedai wo shaꞌi e nako mas wabsh hejel wo e elid k wo ni‑mua. Uꞌukch ani g ni‑apꞌedag mant am wo i ni‑dagito muhkig wui k ab uhpam ep wo i ni‑chegito. Ab o ni‑chehani g ni‑ohg mant id am hab wo juh.” ");
INSERT INTO oodNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","D am ep aꞌai e neꞌowi g hemajkam heg hekaj mo has i kaij. ");
INSERT INTO oodNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kud muꞌijj hab nahnko kaij babgatk, “Doki wabsh jiawul. Pi o wehsig. Shahchu am ahgch ab kaiham?” ");
INSERT INTO oodNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","D wabshaba haꞌijj hab epai kaij, “Pi at wo e nako hegai mo d wabsh sha jiawul mas hab kaidam s‑kehg wo neokad ch wo nench g pi neadam.” ");
INSERT INTO oodNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","D am i e ai g geꞌe cheopi wakonadag tash. D eda d s‑hehpichꞌedkam. ");
INSERT INTO oodNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kuchd am oiopo anai mo hab e aꞌaga Solomonbad watto am geꞌe cheopi t am. ");
INSERT INTO oodNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","D am i e chehm g hahaꞌichu k hab kaij ab Jesus wui, “Tt heꞌes i tash wo m‑nenida mapt wo t‑ahgi maps wa woho d Jiosh si Kehsha.” ");
INSERT INTO oodNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","D hab kaij g Jesus, “Heki ani hu am em‑ahgid. M eda pi ni‑wohochud. Ni‑ohg o ab ni‑mahkch g gewkdag mant hab wo juh g s‑hasig haꞌichu. K heg am chum em‑tashogid mani hedai wud. ");
INSERT INTO oodNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","M wabshaba pi ab hu ni‑wohochud nam d ge ni‑hemajkamga. ");
INSERT INTO oodNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Neh, am o oid g e‑nuhkuddam g kahwal no pi s‑mahch am i s‑amichudk g neꞌokij. K hab waꞌap ni‑oid g ni‑wohochuddam no pi s‑ni‑mahch. Ni ahni ep s‑ha mahch. ");
INSERT INTO oodNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ab ani ha mahkch g pi ha huhugedam doakag. T hegam pi hekid wo huhug. T pi hedai wo shaꞌi ni‑wohppoꞌi. ");
INSERT INTO oodNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ni‑ohg o wehs haꞌichu dahm s‑gewkdag ch si s‑wihnam an ha uꞌukch hegam mo ab ni‑mahkch. T pi hedai wo wohppoꞌi. ");
INSERT INTO oodNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ahni g ni‑ohg wehm ach d hemako.” Neh, id ad hab wabsh chum chei g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","D g hemajkam am ep uꞌihi g hohodai mat wo maꞌichkwua. ");
INSERT INTO oodNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","D hab kaij g Jesus, “Muꞌi ant haꞌichu hab juh g s‑apꞌekam nat pi ab ni‑mah g ni‑ohg g gewkdag. K haschu d hegai mamt heg hekaj wo ni‑maꞌichkwua?” ");
INSERT INTO oodNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","D hab kaij g hemajkam, “Pi ach heg hekaj s‑m‑maꞌichkwuimk s‑apꞌekam ch wabshaba heg hekaj map pad neok. Dap wabsh oꞌodham ch eda hab chum aꞌaga g Jiosh mo d si m‑ohg ch hab ab chum e wepogid g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","D hab kaij g Jesus, “An o oꞌohanas em‑chehanig ed mo g Jiosh hab ha aꞌaga jijosh hegam mo uꞌachug g haꞌichu ahgaj, chum as d wabsh hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","T wahm ahni hig woho am si i ni‑kehsh k ia i ni‑ahꞌad id dahm jewed. M eda haschu ahgch hab ni‑ahg mani pad neok mani hab kaij mani d Jiosh alidag? ");
INSERT INTO oodNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mantp wa woho pi am hu hab wo junihid g ni‑ohg chikpan, mt s‑ap pi wo ni‑wohoch. ");
INSERT INTO oodNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ni wabshaba am hab junihim. Mt heg hekaj wo s‑mahchk mach d hemako g ni‑ohg wehm.” ");
INSERT INTO oodNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","D g hahaꞌichu am hahawa ep chum cheha g cheopi nuhkuddam mat am wo hihim k wo bei. D wabshaba ep e doꞌibia ab ha amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kuchd gam hu hahawa hihim k gam hu ai g Jordan Akimel k am aigo i chehchsh k am dada mo wa g Johnbad am ha pahl wapkon k am dadha. ");
INSERT INTO oodNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","D muꞌi hemajkam am wui dada hab kaijch, “Pi at wa haꞌichu s‑hasigam hab juh g John. Kuki wabshaba d wohokam mo haschu i t‑ahgid id amjed oꞌodham.” ");
INSERT INTO oodNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","D muꞌi hemajkam ab i s‑wohoch g Jesus amai. ");
INSERT INTO oodNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Am ad wa hema kih Bethany kihhim t am ch hab chehgig Lazarus ch am hu hebai haha wabsh mumku. Lazarusbad uꞌuwiga ad d Marda ch Mary. ");
INSERT INTO oodNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Ihda Mary o wa d hegai mad wa g uhw shuhdagi an iawua Jesus tahtad an k an i dagio wabsh g e‑cheꞌechew moꞌokaj.) ");
INSERT INTO oodNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kudki idam uꞌuwigaj am hema cheha mad am wo him k wo ahgi g Jesus, “S-apꞌekam t-kownalig, si m-nawoj at mumku.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","D am i kah g ha-ahga g Jesus k am t-ahgid, “Lazarus ash mumku. K wabshaba pi hab d ahga mat gam hu hab wo i e juh. Nt wo doꞌibia mamt hekaj ab wo ihm g Jiosh. T g Jiosh heg hekaj ab epai wo ni-ihm.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus ad wa ab wa chum si pihk e elid ha wui idam Marda ch Mary ch Lazarus ");
INSERT INTO oodNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ch wabshaba pi am hu wa hekaj i hih mo ab waid. K am d i gohk tash amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","D hab kaij ab t-wui, “M att hig ep wo uhpam hihi Judea chekshani wui.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kuchd ahchim chum pi hohhoꞌid ch hab kaij ab wui, “T-mashchamdam, pi o koi d shaꞌi tash mo wa am chum s-m-maꞌichkwuimk g hemajkam. Ttp eda am ep wo hihi!” ");
INSERT INTO oodNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","D hab kaij g Jesus, “T am wabsh s-ap wo himad g oꞌodham tash ch ed ch wabshaba wo e huchwua s-chuhugam k ed. Pegih, pi at has wo e juh mo eda ni-apꞌechudch g Jiosh mant hab wo junihid g chikpanaj.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","D hab ep kaij g Jesus, “Koi at g t-nawoj Lazarus. Nt wabshaba am wo uhpam him k wo wuha.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kuchd hab kaij, “Kohsig o s-kehgaj wehhejed. T wo wa hejel apꞌet.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","D eda g Jesus heg hab ahg mat muh g Lazarus ");
INSERT INTO oodNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ch heg hekaj hab kaij, “Neh, muh at g Lazarus. ");
INSERT INTO oodNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ni wabshaba wabsh s-ap ni-tahtk mani pi am hu wehmaj namt pi haha wo nei mant has wo ni-juh k ab baꞌich wo i s-ni-wohoch. Tt oi wo hihim k wo nei.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","D ihda Thomas mam hab aꞌaga Kuadi hab kaij ab t-wui, “Pegih, ttp wo oi g t-mashchamdam k wehmaj wo t-koꞌij.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kuchd ged hu dada Bethany t am k s-mai mash d waꞌi giꞌik tash matsh ged hu e cheh g Lazarus. ");
INSERT INTO oodNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Tki eda muꞌijj am dada g hemajkam ab Jerusalem t amjed mat am wo i ha gewkemhu g Marda ch Mary no pi d waꞌi gohk mihya. ");
INSERT INTO oodNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","D ga hu t-nam g Marda nash pi kah mo ab him g Jesus. Tki g Mary ga hu waꞌi wih ha-kih ab. ");
INSERT INTO oodNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","D hab kaij g Marda ab wui g Jesus, “Neh, ni-kownalig, mapt hems s-hohtam wo jiwia, t chum pi wo muh g t-wehnag. ");
INSERT INTO oodNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ni wabshaba s-mahch mat g Jiosh ab wo m-mah mapt haschu ab wo i tai, chum hems hemuch mat i geꞌeda g haꞌichu pi t-apꞌedag.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","D hab kaij g Jesus, “T wo uhpam e chegito g em-wehnag.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Kud hab ep kaij g Marda, “S-mahch ani mat uhpam wo e chegito mat hekid wo i huhug g jewed.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","D hab kaij g Jesus ab wui, “Ia ani haꞌichug ahni mant wo i ha wuwhas g koꞌi ab amjed g muhkig k ab wo i ha mah g doakag. Ab ani ha mahkch g pi ha huhugedam doakag hegam mo ab ni-hiwig. T wo uhpam e chechegito am i koꞌok. Nap s-wohochud ihda?” ");
INSERT INTO oodNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Kud hab kaij g Marda, “Heuꞌu, ni-kownalig, s-wohochud ani map d Jiosh si Kehsha ch d Jiosh alidag. An o oꞌohadag Jiosh oꞌohana ed maptsh ia wo jiwia jewed dahm.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kud gam hu hahawa uhpam hih g Marda k atsh am wabsh s-aꞌagi wai g Mary ash hab kaijch mo ab him g ha mashchamdam ch ab waid. ");
INSERT INTO oodNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","30","D am ha hekaj s-hohtam hih g Mary k ged hu jiwia mat am t-nam g Marda natt ge koi ai g kihhim. ");
INSERT INTO oodNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kud muꞌijj i oi g Mary hegam moki am ha wehm shoani ash hab em-ahgch mat gam hu uhpam ep wo hih hihaꞌini wui mat am wo shoakad. ");
INSERT INTO oodNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","D am i cheh g Mary g Jesus k ab i gei wecho k hab kaij, “Ni-kownalig, mapt hems s-hohtam wo jiwia, t chum pi wo muh g t-wehnag.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","D am i nei g Jesus mo shoak g Mary. D hegam ep shoani mo wehmaj. D ged hu si ai g ihbdaj. D si has e tahtk ");
INSERT INTO oodNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","k ab ha kakke mas hebai ehsto g chuhkugaj. D hab kaij idam, “Oi g t-oid k am wo nei matt am ehsto.” Kuchd am hahawa hihim k am dada k am nei mat am ehsto. ");
INSERT INTO oodNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","D am i shosha g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","D heg hekaj hab kaij g hemajkam, “Neh, kuki ab si pihk e elid wui.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","D wabshaba haꞌijj hab ep kaij, “Neh, t wa g pi neadam doaj. T haschu ahgk pi doaj g Lazarus mat pi wo muh?” ");
INSERT INTO oodNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","D am ep si has i e taht g Jesus k am i miabi g hihaꞌini. Id o ab cheho ch ed hab chuꞌig ch g hodaikaj ab kuhpi. ");
INSERT INTO oodNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","D hab ha ahg g Jesus mat gam hu wo i nuꞌichkwua g hodai. D g Marda hab kaij, “T-kownalig, heki at hu padt no pi d waꞌi giꞌik tash mat am e cheh.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","D hab kaij g Jesus ab wui, “Napt pi chegito mani wa m-ahgid mapt wo nei g s-hasig haꞌichu k wo taht g Jiosh gewkdag maptp ab wo s-ni-wohoch.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","D gam hu hab i e nuꞌichkwua g hodai. D am e dahm i nea g Jesus k hab kaij, “Ni-ohg, ab ani i m-hoꞌigeꞌelid map ab ni-kaiham. ");
INSERT INTO oodNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","S-mahch ani map chum hekid ab ni-kaiham ch wabshaba hab kaij ihda idam ha wehhejed hemajkam. T hab wo s-wohoch mapt ahpi ia i ni-ahꞌad,” ");
INSERT INTO oodNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","k am i haꞌasa e hoꞌigeꞌidahun k am hahawa si s-kaidam neok ch hab kaij, “Lazarus, ab g i wuhshani!” ");
INSERT INTO oodNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","D ab i wuhsh g Lazarus k an wabsh kia bihiwigs g iꞌikuskaj mach hekaj ha bihiwig g t-koꞌi ch ab wabsh kia maꞌishp g wuhioshaj g ikuskaj. D hab ha ahg g Jesus, “Gam g hu wo padch g iꞌikus k wo hiwigi mat wo hih uhpam.” Neh, d wa woho hab e juh. ");
INSERT INTO oodNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Muꞌijj hegam mad am i ha chehgio g Marda ch Mary ad ab i s‑wohoch mo g Jesus d Jiosh si Kehsha am i neidok mad haschu hab juh. ");
INSERT INTO oodNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tki wabshaba haꞌi ehp gam hu hihi Palasi ha wui k am ha ahgi mat haschu hab juh. ");
INSERT INTO oodNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kutsh am e nam g Palasi ch uꞌugchu papal ha wehm g geꞌe e jehnigiddam k am aꞌaga mas has wo juh ihda s‑hasig haꞌichu hab wuadam. ");
INSERT INTO oodNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","“Wehsijj at ab wo i s‑wohoch mo d Jiosh si Kehsha mattp am wabsh wo neidad. T g Rome kokownal am wo i e nakog k wo i wua g geꞌe t‑cheopi k wo wehs t‑kokda,” bad kaij idam am aꞌagadch. ");
INSERT INTO oodNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sh am haꞌichug hegai mad d si uhgchu pahl ch hab chehgig Caiaphas ch si s‑gewkam hab ha ahg, “Kaij, ahpim am shaꞌi pi haꞌichu aꞌamichud ");
INSERT INTO oodNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ch pi mahch mo baꞌich i s‑apꞌe mat hemako oꞌodham wo muh wehs t‑wehhejed kih hegai mattp wehsijj wo t‑koꞌij.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Neh, bad kaij ch eda pi mahch mo g Jiosh am tashogid heg hekaj neꞌokij mo e aihim mat g Jesus wo e muhkid ha wehhejed g Tutuligo ");
INSERT INTO oodNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ch wehs ha wehhejed g nahnko mahs hemajkam. T idam haꞌi ab wo i s‑wohoch g Jesus k ab wo i e hemakoj e wehm. ");
INSERT INTO oodNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Neh, iaꞌi amjed ad g hahaꞌichu am i e nako mat wo mua g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","D heg hekaj hahawa pi an hu s‑masma oimmed g Jesus Judea chekshani ch ed am i dagitok g Bethany. Chd gam hu hihim k am haꞌichugkahim mo am d Ephraim kihhim mo am miabidch g tohono jewed. ");
INSERT INTO oodNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kud eda e aihim mat wo e wuhshad g t‑shohshon ha‑doꞌibiadag. K muꞌijj am hihim gam hu aꞌaijed Jerusalem kihhim wui mat am wo i e nako heg wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","D chum hedai an chum neid g Jesus am i e hemapadk geꞌe cheopi t am ch hab kaij ab aꞌai e wui, “Pi atp hems ia hu wo shaꞌi jiwia. Shahm i elid.” ");
INSERT INTO oodNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kuki eda g uꞌugchu papal ch Palasi am i ha chehani g hemajkam mat hemho wa wo ha ahgi sha s‑mahchk mo hebai haꞌichug g Jesus. T an wo bei. ");
INSERT INTO oodNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Chuhdp tash o wa am wiꞌis mat wo e ai g t‑shohshon ha‑doꞌibiadag wuhshda. ");
INSERT INTO oodNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kud wa am hab e juh g geꞌe gegosig Bethany t am wehhejed g Jesus. Kuchd gam hu hihim k am ha wehm t‑gegosid. D g Lazarus am ep t‑wehmaj. Marda ad am ha wehmaj hegam mad am hihidod ch an t‑toꞌid. ");
INSERT INTO oodNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","D g Mary ged hu jiwia Jesus wui k g si s‑namkig uhw shuhdagi uꞌa ch an iawua Jesus tahtad an. K eda d hemako s‑wehch. D an i dagio wabsh g e‑cheꞌechew moꞌokaj. D wehsko uhwa ihda uhw shuhdagi am kih ch ed. ");
INSERT INTO oodNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","D hab kaij hegai t‑wehm kehshaj g Jesus mo hab chehgig Judas Iscariot, ");
INSERT INTO oodNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“T haschu ahgk pi e gagda ihda uhw shuhdagi matt wo ha mah g shoꞌigkam, natt pi ahim g waik siant pihsh namkigdag ab wo i nei g lial heg amjed.” ");
INSERT INTO oodNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","D eda pi woho s‑ha hoꞌigeꞌid g shoꞌigkam ch wabshaba s‑behimk g lial nadki pi s‑chu ehsk ch chum nuhkud g t‑lialiga ch wabsh hejel hekaj. ");
INSERT INTO oodNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","D hab kaij g Jesus ab wui, “Dagitoni. T‑himdag oidk at hab juh g ni‑muhkig wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chum o hekid ia em‑shahgid g shoꞌigkam. Nt wabshaba ahni hi pi wabsh chum hekid ia wo em‑shahgidk.” ");
INSERT INTO oodNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","D eda wehsko kaidag mad g Jesus ab i wuhshad g Lazarus muhkig amjed. Kud muꞌi am dada g Judea t am hemajkam s‑ha neidamk. ");
INSERT INTO oodNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Kud muꞌijj ab i s‑wohoch mo g Jesus d Jiosh si Kehsha k am i ha dagito g e‑wanimeddam am i neidok g Lazarus. D am i s‑mai g uꞌugchu papal k am i e nako mat g Lazarus hab waꞌap wo mua. ");
INSERT INTO oodNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","D am baꞌich i mahsi. Kuchd am i t‑nakog k gam hu hihi Jerusalem wui. D eda muꞌi am e hemapadch g hemajkam kihhim ch ed mat wo wuhshad g t‑shohshon ha‑doꞌibiadag. Chd am hihim wohg ch ed. D muꞌijj ga hu t‑nam am i kaiok mat am wo jiwia g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Idam ad ha uhꞌukch g chukud shosha uꞌus iꞌibhonig ch ab si has elid g Jesus si s‑kaidam hab kaijch, “Id o d s‑apꞌekam t‑kownalig ch ia jiwia am wehhejed g Jiosh. K g Jiosh si s‑hoꞌigeꞌid.” ");
INSERT INTO oodNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","D g Jesus am hema ha tai g wechij wuhlu k heg cheshadk. ");
INSERT INTO oodNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Heki o hu an hab chuꞌig Jiosh oꞌohana ed matsh id hab wo e juh ch hab chuꞌig: Pi g am wo e totodsid, ahpim Tutuligo! Idani at ia wo jiwia g geꞌe em‑kownalig an daichugch wechij wuhlu t an. ");
INSERT INTO oodNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kuchd pi shaꞌi amichud wehs ihda. Kut wa wabshaba hekid ab uhgk i e bei g Jesus dahm kahchim wui, tt am hahawa i chegito mo an oꞌohanas ihda Jiosh oꞌohana ed. Kutki heg hekaj hab e juh am wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Idam muꞌi hemajkam ad wa am nam g Jesus nash pi kah mat ab i wuhshad g Lazarus muhkig amjed. Hegam mo wa am neid ash am ha ahgid. ");
INSERT INTO oodNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","D hab kaij g Palasi ab aꞌai e wui am i ha neidok, “Ha g wo neid matki wehsijj am i oi. Pi attki wo t‑nako matt wo keshwua.” ");
INSERT INTO oodNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","D am haꞌi dada g Greek hemajkam Jerusalem t am mat ab wo has el g Jiosh heg eda doꞌibiadag wuhshda piast. ");
INSERT INTO oodNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kuchd am oiopo. D idam am dada k am cheh g Philip k am ahgi mo s‑neidamk g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","D g Philip am ahgi g Andrew. (Idam ad am d chum kihkam Bethsaida t am am Galilee chekshani ch ed.) Kud am hahawa e wehm hihim k am ahgi g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","D hab kaij g Jesus ab ha wui, “Idani at e ai g ni‑tashga mat g ni‑ohg wo ni‑maskogi mani d si Kehshaj. ");
INSERT INTO oodNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","T wabshaba wehpeg haꞌichu hab wo e juh am ni‑tahgio. Neh, nat hig am wo i wuhshani k ab wo muꞌida g pilkani pi am hu e eshk? Hemho wa at am wo e ei jewed wecho k wo muh k hab waꞌi masma wo i wuhshani k ab wo muꞌida. ");
INSERT INTO oodNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Id ani hab ahg mat g oꞌodham wo heki wua g e‑doakag matp wo s‑huwidad hejel e wehhejed k wabshaba wo edgidad g pi ha huhugedam doakag matp wo hugio g e‑doakag am ni‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Bat wo junihid g ni‑tatchui hegai matp hedai hab e elid mat d wo ni‑pionagk. Kunt hab wo juh mat an wo ni‑wehmajk mant hebai wo i haꞌichugk. Ni‑ohg at ab wo si has i ha el hegam mo hab junihim g ni‑tatchui.” ");
INSERT INTO oodNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","D hab ep kaij g Jesus, “Ni‑ihbdag at ab si i e kudu. Ni hab chum ni‑tahtk mant hab wo chei, ‘Ni‑ohg, pi g hiwgid mas hab wo e juh ihda am ni‑tahgio.’ Nt eda heg hekaj ia jiwia mant am wo gahi wuhsh hegai s‑koꞌok haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pegih, ni‑ohg, am g maskogid g e‑gewkdag am gahi ni‑wuhshanim.” D ab neo g Jiosh dahm kahchim t amjed k hab kaij, “Am ant heki hu i maskogid k am hab ep wo juh.” ");
INSERT INTO oodNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Muꞌi o wa am gegok g hemajkam ch kah hegai mo ab neok. Haꞌijj o hab kaij, “Ab o kaidaghim g tataniki.” Kud haꞌijj hab kaij, “Anghil at ab wui neo.” ");
INSERT INTO oodNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","D Wabshaba hab kaij g Jesus ab ha wui, “Ahpim at em‑wehhejed ab s‑kaidam neo, ch pi ahni ni‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","E at ai mat geꞌe wo bei g chuꞌijig g hemajkam. Jijawul ha‑geꞌejig o chum e kownalchud id dahm jewed. Nt wabshaba oi wo gewito. ");
INSERT INTO oodNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ab amt wo ni‑naggia uhs t ab ahni Jiosh si Kehsha. Kunt ab haha wo i ha wanchshul g hemajkam ni‑wui.” ");
INSERT INTO oodNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Neh, bo wa kaij g Jesus ch oki heg hab ahg mat has masma wo muh. ");
INSERT INTO oodNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","D hab kaij g hemajkam, “An o hab chuꞌig Jiosh oꞌohana ed mat g Jiosh si Kehsha pi hekid wo muh. P haschu ahgch hab kaij mapt ab wo e naggia uhs t ab maptp woho d Jiosh si Kehsha?” ");
INSERT INTO oodNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","D hab kaij g Jesus ab ha wui, “Ia ant heꞌes i tash wo haꞌichugk em‑shahgid ch heg wa wepo mani d tonlig em‑wehhejed. Am g s‑ap wo hihimad tonlig oidch. T hab pi wo em‑maꞌish g s‑chuhugam. Hegai matp hedai am wo himad s‑chuhugam k ed o pi mahch mas hebai him. ");
INSERT INTO oodNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ab g wo i s‑ni‑wohochud mani eda ia wabsh kia haꞌichug k hab masma tonlig ch ed wo hihimad.” Neh, bad kaij ch gam hu hahawa i e mehkod ab ha amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Muꞌikko ad wa hab juh g s‑hasig haꞌichu g Jesus am ha‑nena ed idam hemajkam. Kud wabshaba muꞌijj pi ab hu wohochud mo d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Neh, d hab wa masma hab e juh hegai matki g kelibad Jiosh haꞌichu i tashogiddam Isaiah an oꞌoha. An o hab chuꞌig: Pi o muꞌi ab s‑wohochud g haꞌichu t‑ahga ab m‑amjed. K g m‑gewkdag pi tasho am ha‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","41","Tki an ep oꞌoha g Isaiabad: Jiosh at hab ha juh mo pi ap haꞌichu neid ch pi haꞌichu amichud mat pi ab hu wui wo i e nohnogid k pi wo e doꞌibia ab pi apꞌekam t amjed. Isaiabad o wa ab amjed neok g Jesus gewkdag natsh pi Jiosh am tashogi. Kut idam hemajkam wa woho pi e nako mas ab wo s‑wohoch g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kud muꞌi ab hi wa chum s‑wohoch g hahaꞌichu. Tsh wabshaba g Palasi gam hu wo i ha wuwhas matp wo s‑mai mat ab s‑wohoch. D heg hekaj pi am hu tasho e ahg ");
INSERT INTO oodNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","no pi s‑hohhoꞌid g ab has ha‑elida g hemajkam ch g Jiosh ab has elida wabsh pi ab hu haꞌichuchud. ");
INSERT INTO oodNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus ad am ep ha jehnigid ch si s‑kaidam hab kaij, “Matp hedai ab wo i s‑ni‑wohochud k hab waꞌap s‑wohochud g ni‑ohg Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","K hedai i ni‑neid ch hab waꞌap neid. ");
INSERT INTO oodNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ia ant jiwia id dahm jewed k hab sha masma mo g tonlig am em‑wehhejed nani pi am tashogid g wohokam himdag. Kumt s‑ap wo himad g e‑doakag hab masma mam am tonlig ch ed mamtp ab wo ni‑hiwgad. ");
INSERT INTO oodNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Muꞌijj o pi ab hu ni‑kaiham ch pi ab hu ni‑hiwig. Nt wabshaba pi heg hekaj ia jiwia manis wo ha lodai. S‑ha ani doꞌibiamk. ");
INSERT INTO oodNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","T wo e lodai g ni‑neꞌokikaj mat hekid wo i huhug g jewed. ");
INSERT INTO oodNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ni‑ohg o ab ni‑chehani mant haschu hab wo chei. Ni pi g hejel ni‑neꞌoki hab kaij. ");
INSERT INTO oodNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kumt heg hekaj ab wo kaiham k hab wo bei g pi ha huhugedam doakag. Heg ani waꞌi hab kaij mo g Jiosh ab ni‑chehani.” Neh, bad kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","D am him k am i e ai matt baꞌich tash wo mua g kahwal mad k wo wuhshad g t‑shohshon ha‑doꞌibiadag. Kuki s‑mahch g Jesus mat am wa e ai matki ia wo dagito ihda jewed k wo hih am e‑ohg wui. D eda si pihk e elid wehs e‑doakagkaj ab ha wui hegam mat ab i s‑wohoch. ");
INSERT INTO oodNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","D am e apꞌech matt am wo t‑gegos hema kih am gam hu i juhk. D wa eda heki hu ab i kaiha g Judas Iscariot g ge Jiawul k am i e shelch mat wo gagda g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ab atsh Jiosh amjed ia jiwia g Jesus k ab wui ep wo i e nodagi. Kush g Jiosh ab wehs mahkch g gewkdag. D id s‑mahch g Jesus ");
INSERT INTO oodNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ch wabshaba am i kekiwua k am wuahawua g e‑lihwa k g tuayakaj ab e bahshodad ");
INSERT INTO oodNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","k am ge was wakonakud ch ed k ab i wapkonahi g t‑tahtad k heg hekaj ha dagio tuaya mat ab e bahshodad. ");
INSERT INTO oodNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","D ab i ai g Simon Peter. D heg si has e tahtk ch hab kaij, “Ih, napt wo wapko g ni‑tahtad k eda d ge ni‑kownalig!” ");
INSERT INTO oodNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","D hab kaij g Jesus ab wui, “Pi ap hi wa amichud hemuch mani haschu chum em‑tashogid id hekaj ch wabshaba wo wa amich imhab i baꞌich.” ");
INSERT INTO oodNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kud hab hahawa kaij g Peter, “Pi apt hekid wo shaꞌi wapko g ni‑tahtad.” D hab kaij g Jesus, “Pi apt d wo i ni‑wehmtdamk mant wo sha pi wapko g m‑tahtad.” ");
INSERT INTO oodNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kud hahawa si s‑hohtam hab kaij g Peter, “Ni‑kownalig, pi g heg waꞌi ni‑tahtad wapkon k wabshaba g ni‑nohnhoi ch ni‑wuhiosha ehp.” ");
INSERT INTO oodNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","11","D hab kaij g Jesus, “Heki apt hu e wako wehsko koi jiwiak. Heg at waꞌi e‑tahtad wo wapko hegai mat hedai heki hu wehsko e wako mat koi am hu wo jiwia kih t am. Id ani hab ahgch hab kaij mat g em‑dodakag wehs i e kegch, heg hi wa i hemako mat pi i e kegch.” Neh, bad kaij g Jesus no pi s‑mahch mat hedai wo gagda. ");
INSERT INTO oodNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","T am i ha wapko g ha‑tahtad k ab uhpam wah g e‑lihwa k ga hu hahawa ep dahiwua mihsa wui k ab ha kakke, “Nam s‑amichud mant haschu ahgk hab em‑juni ihda? ");
INSERT INTO oodNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Neh, bam ni‑aꞌaga mani d em‑kownalig ch d em‑mashchamdam. K am wa s‑apꞌe no pi woho ihda. ");
INSERT INTO oodNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Dani wa chum em‑kownalig ch d em‑mashchamdam ch eda am i ni‑jumalkad k heg ni‑wepogi mani d wabsh em‑pionag. Pegih, mt ahpim hab wa masma ab aꞌai wo e neidad ");
INSERT INTO oodNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","mant am em‑chehgi ch ab aꞌai wo i e wehmtad ");
INSERT INTO oodNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","nam pi d ni‑pionag. Kut pi hebai g pion hab wo chum e elidad mas baꞌich d i si haꞌichu mo hi g ahmoj. ");
INSERT INTO oodNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","M hahawa s‑mahch mamt has wo chum masmak. Kut d wo s‑ap tahhadkamk am em‑wehhejed mamtp woho hab wo masmak. ");
INSERT INTO oodNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mt wabshaba pi wehsijj ab hu wo bei ihda no pi an hab chuꞌig Jiosh oꞌohana ed mamt hema ab ni‑wui wo kekiwua ahpim mam ni‑wehm e gegosid. Kuni s‑mahch mat hedai hab wo e juh nani pi wehs s‑em‑mahch ahpim mant ab i em‑gawulkai. ");
INSERT INTO oodNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kuni heki hu ab em‑ahgid mat koi hab e juh. Kut hekid hab wo i e juh, mt ab haha wo s‑wohoch mani woho d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jiosh o ab ni‑mahkch g haꞌichu e‑ahga. Kuni ab epai em‑mahk. K heg hekaj ab s‑ap ni‑neid ch ab s‑ap neid g Jiosh hegam mat hedai ab wo s‑ap em‑neidad.” ");
INSERT INTO oodNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","D am hahawa si e kudu g Jesus k hab t‑ahg, “Pi ant ap ni‑taht k wo em‑ahgi mamt hema ahpim wo ni‑gagda.” ");
INSERT INTO oodNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kuchd si has i t‑taht k ab wabsh aꞌai si t‑neid pi shaꞌi amichudch mas hedai hab ahg. ");
INSERT INTO oodNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kunid eda an hugidaj an daha g Jesus ahni mo ni‑hekaj si pihk e elid. ");
INSERT INTO oodNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","D hekaj g Simon Peter wabsh s‑aꞌagi ab ni‑ahgid mant wo kakke mas hedai hab ahg. ");
INSERT INTO oodNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kunid wabsh s‑aꞌagi ab epai kakke g Jesus mas hedai hab ahg. ");
INSERT INTO oodNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","D hab kaij ab ni‑wui, “Hegai mant wehpeg ab wo bih o d hegai.” Kud wa woho am ge bia g hidod k ab mah g Judas Iscariot. ");
INSERT INTO oodNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","D am wabsh i chum huh g e‑bih. D g ge Jiawul am baꞌich i chikp eda. D hab kaij g Jesus ab wui, “S‑hohtam g am hab juhni hegai mapt hab wo juh.” ");
INSERT INTO oodNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kuchd pi shaꞌi amichud mas haschu hab ahg ch hab kaij ihda. ");
INSERT INTO oodNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","D eda nuhkud g t‑lialiga hegai Judas. Kuchd heg hekaj haꞌi hab t‑ahg mo hab ahg mat ep wo ha nolawt g haꞌichu hugi heg wehhejed geꞌe gegosig o haꞌichu wo ha mah g shoꞌigkam. ");
INSERT INTO oodNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","D ha hekaj i wuhsh g Judas gam hu jeg ed. Kuki eda ab wabsh i si s‑chuhugam. ");
INSERT INTO oodNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","D hab hahawa kaij g Jesus, “Neh, hemu at wehs wo e nahto hegai mat g Jiosh am i ni‑kei mant hab wo juh ia jewed dahm. Am ani wa chehgid g Jiosh gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","T g Jiosh heg hekaj am wo tashogi g ni‑gewkdag hemu s‑hohtam. ");
INSERT INTO oodNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Pegih neh, ahpim mani ab si em‑tatchua, pi ant shaꞌi tash ia hu wo e‑wehmajk nant pi gam hu wo hih. Kumt pi wo e nako mams wo ni‑cheh. Am ant hab ep wo chei em‑wui mani wa haschu ha ahgid g hemajkam mamt pi wo e nako mamt hejel am wo hihi mant hebai wo i hih. ");
INSERT INTO oodNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Hemu ant ab wo em‑mah g wechij chehanig. K d ihda mamt ab aꞌai wo si pihk e elidad hab masma mani ahni hab em‑juhkch. ");
INSERT INTO oodNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wehsijj at wo s‑mahchk mam ab i e dagitokch ni‑wui mamtp ab aꞌai wo si pihk e elidad.” ");
INSERT INTO oodNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","D hab kaij g Simon Peter, “A pt hebai wo hih, ni‑kownalig?” Kud g Jesus hab kaij, “Pi apt wo e nako mapt wo ni‑oi hemu amai mant am wo hih. K wabshaba ab him g tash mapt am haha wo i ni‑oi.” ");
INSERT INTO oodNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","D hab kaij g Peter, “Nt haschu ahgk pi wo ni‑nako mant wo m‑oi hemuch? Ni‑nahtokch ani mant wo m‑wehhejed muh.” ");
INSERT INTO oodNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","D hab kaij g Jesus, “Ab ant wo si shel m‑ahgi map pi woho e nahtokch mapt wo muh ni‑wehhejed. Neh, waikko apt hab wo waꞌi chei map pi shaꞌi ni‑mahch mat koi wo kuhu g keli chuchul.” ");
INSERT INTO oodNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","D hab ep kaij g Jesus, “Pi g wo shaꞌi e kudut. Ab g wabsh i s‑wohochud mo an haꞌichug g Jiosh k ahni ab ep wo i s‑ni‑wohoch mani d si Kehshaj. ");
INSERT INTO oodNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Am o wiꞌis ni‑ohg kihdag ed am wehs ha wehhejed g ni‑wohochuddam. Nt wo wa chum em‑ahgi matp pi am hu wo wiꞌisk. Nt am wo him k am wo i apꞌech em‑wehhejed ");
INSERT INTO oodNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","k ia ep wo jiwia k ia wo em‑ui mamt an wo ni‑wehmajk. ");
INSERT INTO oodNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","S‑mahch am mamt has masma am wo hihi amai mant am wo hih.” ");
INSERT INTO oodNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","D hab kaij g Thomas ab wui, “Ih, ni‑kownalig, pi ach shaꞌi mahch maps hebai wo hih ch hab pi mahch machs has masma wo dada.” ");
INSERT INTO oodNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","D hab kaij g Jesus ab wui, “Ab amt wo ni‑hiwgad. Nt ahni an wo waꞌi em‑uꞌapa anai ni‑ohg kihdag ed. Id o heg wa wepo mani d am wui himdam wohg em‑wehhejed ch d Jiosh wohokam ch d m‑wechij doakag. ");
INSERT INTO oodNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Matp hedai woho s‑ap wo s‑ni‑mahchk ch hab wa masma wo s‑mahchk g ni‑ohg. Neid am g ni‑ohg nam pi ni‑neid.” ");
INSERT INTO oodNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","D hab kaij g Philip ab wui, “Pegih, t‑kownalig, am g t‑chehgid g e‑ohg. Heg ach waꞌi tatchua.” ");
INSERT INTO oodNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","D hab kaij g Jesus ab wui, “Tash ani ia em‑wehmaj. Kupki eda pi woho ap ni‑mahch, ahpi Philip. Hegai mo hedai i ni‑neid ch hab masma ep neid g ni‑ohg. P haschu ahgch ab ni‑tahni mant wo em‑chehgi g ni‑ohg? ");
INSERT INTO oodNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ahni kch ni‑ohg ach d hemako. Kupki pi koi ab hu s‑wohochud ihda.” D hab ep kaij ab wehs t‑wui, “Ni‑ohg o ab ni‑ahgid mant has wo cheꞌe k has wo ni‑juh. ");
INSERT INTO oodNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ab g wo s‑wohochud mach d hemako g ni‑ohg wehm heg wabsh hekaj mani am em‑ahgid, o amtp pi wo e nako hab masma k wo s‑wohoch mach d hemako heg hekaj s‑hasig haꞌichu mani hab junihim. ");
INSERT INTO oodNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nt wo si shel em‑ahgi matp hedai ab wo s‑ni‑wohochud k wo e nako mat hab wo junihid g s‑hasig haꞌichu hab masma mani ahni, pej baꞌich i geꞌe hab wo juh g s‑hasig haꞌichu nant pi ahni hi wo hih am ni‑ohg wui. ");
INSERT INTO oodNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kunt am hab wo em‑juni mamtp haschu ab wo i tai g ni‑ohg am ni‑chehchegk. T heg hekaj g hemajkam ab wo si hehgchul g ni‑ohg Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pegih, mt haschu ab wo i tai g ni‑ohg am ni‑chehchegk, nt ahni hab wo juh. ");
INSERT INTO oodNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Am g hab wo junihid g ni‑chehanig mamtp woho ab wo si ni‑tatchuad. ");
INSERT INTO oodNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nt ab wo tai g ni‑ohg mat ab wo em‑mah g Hekia S‑apꞌekam Gewkdag. T heg chum hekid wo em‑wehmajk ch am wo i em‑tashogidad g wohokam. ");
INSERT INTO oodNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Pi o ta neidagma g Hekia S‑apꞌekam Gewkdag. T heg hekaj pi wo shaꞌi e nako mas wo s‑mahchk hegam mo pi ni‑mahch. M wabshaba ahpim hi s‑mahch no pi em‑wehmaj hemu ch am wo e ul em‑doakag ed. ");
INSERT INTO oodNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Pi ant ia hu hejel wo em‑dagito k wabshaba ia wo wa em‑wehm haꞌichugk am i dahm mant im hu wo uhpam hih. ");
INSERT INTO oodNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kumt wo s‑mahchk mant ia wo em‑wehmajk. T wabshaba hegam mo pi ab hu ni‑wohochud pi wo mahchk mani ia haꞌichug nat pi pi wo ni‑neidad. Kumt d wo wechij dodakamk ab ni‑amjed heg waꞌi hekaj mant ab wo i wuhsh muhkig amjed k d ep wo doakamk. ");
INSERT INTO oodNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Iaꞌi amjed amt wo s‑mahchk mach d hemako g ni‑ohg wehm k ch ep wo s‑mahchk mamt ahpim ab i e hemakoj ni‑wehm. ");
INSERT INTO oodNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Am o e chehgid mo ab si ni‑tatchua hegam matp hedai ab wo bei g ni‑chehanig k hab wo junihid. Kunt ab ha wui wo si pihk ni‑elidad g ni‑ohg wehm ch ab ha wui wo i ni‑tashogi.” ");
INSERT INTO oodNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","D hab kaij g Judas, hi wa pi hegai Judas Iscariot, “T‑kownalig, pt has masma ahchim waꞌi t‑wui wo i e tashogid k pi ab hu wehs hemajkam ha wui?” ");
INSERT INTO oodNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","D hab kaij g Jesus ab wui, “Hegai mo hedai ab si ni‑tatchua at wo wohog el g haꞌichu ni‑ahga. Kut hahawa ab wui wo si pihk e elidad g ni‑ohg. Kutt g ni‑ohg wehm am haha wo i t‑maskogi wui k am wo wehmajkad. ");
INSERT INTO oodNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pi at ab hu wo wohog el g haꞌichu ni‑ahga hegai mat pi ab hu wo ni‑tatchua. K eda g ni‑ohg d amjedkam ihda haꞌichu ni‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Id ani hi wa em‑ahgid hemuch mani ia em‑wehmaj. ");
INSERT INTO oodNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","T g ni‑ohg ab haha wo cheha g Hekia S‑apꞌekam Gewkdag mat heg am wo i em‑wehmajk am ni‑wehhejed ch wo em‑gewkemhunad ch wo em‑mashcha mani haschu i s‑em‑mashchamamk ch hab wo em‑juh mamt wehs haꞌichu wo s‑chegitok mani haschu i em‑ahgid. ");
INSERT INTO oodNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Am g wabsh wo i s‑ap e tahtkkad. Ab ant wo i em‑mah hegai hab mahs s‑ap tahhadkam mani ahni edgid. Pi at hedai wo e nako mat hab mahs s‑ap tahhadkam wo em‑mah. Pi g wo shaꞌi e kudutad ch pi haꞌichu wo ehbidad. ");
INSERT INTO oodNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Am am wa ni‑kah mani wa hab kaij mant gam hu wo hih ab em‑amjed k wabshaba ia wo wa ep em‑wehmajk. Ni‑ohg o baꞌich i s‑gewkdag mani ahni. Kumt heg hekaj wo chum si s‑hehgigkad mant im hu uhpam wo hih wui mamt hems g wehs e‑ihbdagkaj ab wo ni‑tatchuad. ");
INSERT INTO oodNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Id ani em‑ahgid mat koi hab e juh. Mt hab ab wo i s‑wohoch g haꞌichu ni‑ahga mat hekid hab wo i e juh. ");
INSERT INTO oodNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Hemu at am geꞌe wo chehgi g e‑gewkdag g jijawul ha‑geꞌejig no pi chum e kownalchud ia jewed dahm. K heg hekaj pi am hu geꞌe s‑ni‑apꞌe mant tash am haꞌichukaj wo em‑wehm neo. K eda pi uꞌukch g gewkdag mas hab wo ni‑juh manis ab wecho wo i ni‑ul. ");
INSERT INTO oodNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Wehs ani hab junihim mo haschu ab i ni‑chehani g ni‑ohg. K hab masma s‑mahch g hemajkam mani ab si tatchua g ni‑ohg. “Pegih neh, oi g wo, am att wo i t‑nakog k wo hihi.” ");
INSERT INTO oodNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","D hab ep kaij g Jesus, “Dach waꞌi hemako hab masma mo g uhdwis jeꞌe d hemako g e‑iꞌibhonig wehm. Ahni ani heg wepogidas mo g uhdwis shon waꞌug. M ahpim heg wepogidas iꞌibhonigaj. K g ni‑ohg t‑nuhkud. ");
INSERT INTO oodNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Hegai iꞌibhonigaj at ab wo chum bahidagt. Mt ahpim hab waꞌap s‑kehg haꞌichu hab wo chum junidahid g Jiosh. Eꞌes nuhkuddam at an wo si hikkumia hegai iꞌibhonig mat pi ab hu wo bahidagt k wo i kegch hegai mat ab wo bahidagt. T hab baꞌich i muꞌi ab wo bahidagt. ");
INSERT INTO oodNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“Heki am hu kegchudas ahpim mam ab kaiham ch ab s‑wohog elid g haꞌichu ni‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pi g gam hu hab wo shaꞌi i e juhni ab ni‑amjed. Nt ahni hab wa masma pi gam hu hab wo i ni‑juh ab em‑amjed. Mt hab s‑ap hab wo juh haꞌichu k s‑ap hab wo masmak hab masma mo hegai iꞌibhonig mat s‑ap ab wo bahidagt ab giꞌikch e‑waꞌug ab. ");
INSERT INTO oodNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Pi at ab hu wo bahidagt g iꞌibhonig pi ab hu giꞌikch e‑waꞌug ab. Mt ahpim hab waꞌap pi wo e nako mamt haꞌichu s‑kehg hab wo juh mamt gam hu hab wo i e juh ab ni‑amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hegai iꞌibhonig mat wo e hikkumia at am wo i e hemapad k wo e mei. Neh, id o hab mahs matp hedai gam hu hab wo i e juh ab ni‑amjed k ab wo e ahijidach mat hahawa pi haꞌichu wehhejed wo s‑kehgajk am Jiosh wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ab ant wo i em‑mah mamt haschu ab wo i ni‑tai mamtp ab wo s‑wohog elidad g haꞌichu ni‑ahga ch ab wo ni‑hiwgad. ");
INSERT INTO oodNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Hegam matp hedai woho ab i e dagitokch ni‑wui at muꞌi haꞌichu hab wo junihid ni‑wehhejed. T heg hekaj ab wo hehgchul g hemajkam g ni‑ohg Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","10","“Bani masma si em‑tatchua ch si pihk em‑elid mo hab masma si ni‑tatchua g ni‑ohg. Ab ani si s‑wohog elid g ni‑ohg. Ch ab aꞌai si pihk t‑elid. Kumt ahpim hab waꞌap ab wo s‑ni‑wohog elidad. Tt ab aꞌai wo si pihk t‑elidad. ");
INSERT INTO oodNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Id ani em‑ahgid mamt wo bei g s‑hehgig am hab junihidch g ni‑chehanig hab masma mani ahni s‑hehgig am hab junihidch g ni‑ohg chehanig. ");
INSERT INTO oodNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ab ani em‑chehani mamt ab aꞌai wo pihk e elidad hab masma mani ahni has i masma si pihk em‑elid. ");
INSERT INTO oodNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hegai matp hedai wo e muhkid ha wehhejed g e‑naipijju o d hegai mo woho si pihk e elid ha hekaj. ");
INSERT INTO oodNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ahpim am d ni‑naipijju mamtp hab wo junihid g ni‑chehanig. ");
INSERT INTO oodNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kuni hahawa pi hab em‑aꞌaga mam d wabsh ni‑pionag ch wabshaba hab em‑aꞌaga mam d ni‑naipijju nani pi ab em‑ahgid wehs haꞌichu mani ab kah ni‑ohg amjed. Neh, mo hema d wabsh pionag ch pi mahch mo haschu am hab i wua g ahmo. ");
INSERT INTO oodNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Pi amt hejel e elid k am wo i gegokiwua ni‑wehhejed. Ahni ant am i em‑chuhcha mamt am wo hihim k hab wo juh g geꞌe chikpan. Kut pi hekid wo huhug hegai mamt hab wo juh. T g ni‑ohg am hab wo em‑juni mamtp haschu ab wo i tai am ni‑chehchegch. ");
INSERT INTO oodNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Pegih, id ani ab em‑chehani mamt ab aꞌai wo pihk e elidad.” ");
INSERT INTO oodNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","D hab ep kaij g Jesus, “Mt wo s‑chegitok mo ahni wehpeg s‑ni‑kehꞌid hegam mo pi ab hu tatchua g Jiosh ch hab waꞌap wo s‑em‑kehꞌidad. ");
INSERT INTO oodNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ab at wo em‑tatchua mamtp hems pi ab hu wo tatchua g Jiosh. Nt wabshaba ab si em‑gawulkai ab ha amjed. Kum pi ha wepo chegito haꞌichu. K hekaj hab s‑em‑kehꞌid. ");
INSERT INTO oodNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","21","Mt wo s‑chegitok mani wa hab em‑ahgid mat pi hebai g pion hab wo chum e elidad mas baꞌich d i ge haꞌichu mo g e‑ahmo. T wo em‑shoꞌigch hegam mo ni‑shoꞌigchud. Kut ab wo s‑em‑wohog el hegam mo ab s‑ni‑wohog elid. Hegam mo pi mahch g ni‑ohg o ni‑shoꞌigchud ch hab waꞌap wo em‑shoꞌigchudad nam pi ab ni‑wui e dagitokch. ");
INSERT INTO oodNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","24","Ia ant jiwia ha wui k am ha ahgi ab amjed g ni‑ohg k am ha chehgi g s‑hasig chikpan mat pi hedai hekid hab juh. K wabshaba s‑ni‑kehꞌid. K heg hekaj tasho mo s‑kehꞌid g ni‑ohg. Kut hab masma mahsko wua g pi ap e‑chuꞌijig. ");
INSERT INTO oodNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","An o hab chuꞌig Jiosh oꞌohana ed mat wo s‑ni‑kehꞌidad pi haschu shaꞌi ahgk. Kut wa woho hab e juh. ");
INSERT INTO oodNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ab ant wo cheha g Hekia S‑apꞌekam Gewkdag mat am wo em‑wehmajk. Heg o am wehmaj g Jiosh ch ab em‑wui wo him k wo em‑wehmajkad ch am wo i em‑gewkemhunad ch am wo haꞌichu em‑tashogidad ab ni‑amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kumt ahpim wo i ahgahi ab ni‑amjed nam pi ni‑wehmajkahim ga hu i amjed mant am i shonwuich g ni‑chikpan.” ");
INSERT INTO oodNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","D hab ep kaij g Jesus, “Am ani em‑ahgid ihda mamt heg hekaj pi wo ni‑dagito. ");
INSERT INTO oodNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","T wo i em‑wuwhas ab amjed g cheopi. K ab him g tash mamt wo em‑muꞌa k hab wo e ahgad mat wehhejed hab juh g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Id amt hab wo em‑juh heg hekaj mo pi ni‑mahch ch ep pi mahch g ni‑ohg. ");
INSERT INTO oodNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mt wabshaba wo s‑chegitok mani id am em‑ahgid mat hekid hab wo i e juh.” D hab ep kaij g Jesus, “Pi ani em‑ahgid ihda ga hu i wehpeg heg hekaj mani ia em‑wehmaj. ");
INSERT INTO oodNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","K wabshaba hemu e aihim mant uhpam wo hih am ni‑ohg wui. M eda pi ab hu shaꞌi s‑ni‑kakkeimk manis hebai wo hih ");
INSERT INTO oodNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ch wabsh pi ap e tahtk s‑mahchok mant gam hu wo hih. ");
INSERT INTO oodNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","T eda pi ab hu wo i hih g Hekia S‑apꞌekam Gewkdag em‑wui nt hoꞌip gam hu hih. K heg hekaj baꞌich i s‑apꞌe mant gm hu wo hih. ");
INSERT INTO oodNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","T ab haha wo i hih g Hekia S‑apꞌekam Gewkdag k am wo i ha tashogi g hemajkam g s‑apꞌekam ch pi apꞌekam ch Jiosh lodaita. ");
INSERT INTO oodNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","10","Ni‑ohg at ab wo ni‑haꞌichuch mant am wui wo him k pi ia hu wo haꞌichugk. T g Hekia S‑apꞌekam Gewkdag heg hekaj wo wohokamch am ha wui g hemajkam mani d s‑apꞌekam am Jiosh nena ed k ep wo wohokamch mo hab junihim g pi apꞌekam mo eda pi ab hu ni‑wohochud ");
INSERT INTO oodNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","k ep wo wohokamch mat wo e lodai hegam mo hab junihim g pi apꞌekam nat pi am wa e ai mat g Jiosh wo lodai g ge Jiawul. ");
INSERT INTO oodNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Muꞌi ani haꞌichu ep s‑em‑ahgidamk. Mt wabshaba pi wo e nako mamt wo s‑amich mant wo chum em‑ahgi hemuch. ");
INSERT INTO oodNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","14","Hekia S‑apꞌekam Gewkdag at am wo i em‑tashogi g wohokam k am ep wo i em‑ahgi mat haschu has wo e juh imhab em‑baꞌich. Nt am wo ahgi mat has wo chei. Kut am wo em‑tashogid k hab ab wo si ni‑haꞌichuch. ");
INSERT INTO oodNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wehs g ni‑ohg gewkdag o d ep ni‑gewkdag. Ni hekaj hab kaij mat g Hekia S‑apꞌekam Gewkdag am wo i em‑tashogi mani haschu ab i ahgid.” ");
INSERT INTO oodNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","D hab ep kaij g Jesus, “Do shaꞌi haꞌas, mt pi an hu wo ni‑neidad, ch am ep wo shaꞌi haꞌas, mt hahawa ep wo ni‑neidad.” ");
INSERT INTO oodNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kuchd hab kaij ab aꞌai t‑wui, “Shahchu o hab ahg ch hab kaij mas wo shaꞌi haꞌas, tt pi an hu wo neidad, ch am ep wo shaꞌi haꞌas, tt ep wo neidad. K wa hab ep kaij mat wo hih am e‑ohg wui. ");
INSERT INTO oodNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Pi ach shaꞌi amichud mo haschu hab ahg ch hab kaij.” ");
INSERT INTO oodNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","D s‑mahch g Jesus machd ab s‑kakkeimk ch hekaj hab kaij, “Pi am shaꞌi amichud mani haschu hab ahg ch hab kaij mat wo shaꞌi haꞌas, mt pi wo ni‑neidad, ch am ep wo shaꞌi haꞌas, mt ep wo ni‑neidad. ");
INSERT INTO oodNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Pegih, nt wo haꞌichu em‑ahgi mat woho hab wo e juh. Mt wo si pi ap e taht k wo si shoanid. T g s‑ni‑kehꞌiddam wabsh wo si s‑hehgigk. T amjed haꞌichu hab wo e juh mat ab wo em‑mah g si geꞌe s‑hehgig. ");
INSERT INTO oodNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Neh, s‑mahch am mat has wo e juh mat hekid wo e ai mat wo mahmadho g uwi. T wo pi ap e taht mat wo nako g s‑koꞌok. T wabshaba am wo i mahsi g ali. T am wabsh wo i pi chegito g s‑koꞌok heg hekaj mo si s‑hehgig mat an i e mahsid g ali. ");
INSERT INTO oodNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Bo wa masma am em‑tahgio mam hemuch pi ap e taht. Nt wabshaba ab ep wo ni‑chehgi em‑wui. Kumt haha wo si s‑hehgigk. T pi hedai wo shaꞌi padch hegai hab mahs s‑hehgig em‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Mt hahawa pi ab hu wo ge ni‑kaiamad haꞌichu ch wabshaba ab wo e hoꞌigeꞌidahunad ch ab wo kakke g ni‑ohg am ni‑chehchegch. T wa woho wo em‑mah. ");
INSERT INTO oodNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pi am koi hekid ni‑chehcheg am e hoꞌigeꞌidahunch. Am g hab wo i e juhni. T g ni‑ohg am hab wo em‑juni. T ab wo si e shuhdad g em‑doakag g s‑hehgigkaj.” ");
INSERT INTO oodNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","D hab ep kaij g Jesus, “Am ani haꞌichu i chum em‑tashogid g haꞌichu wepogida ahgakaj. Ab o him g tash mant hahawa si tasho wo em‑ahgi ab amjed g ni‑ohg. ");
INSERT INTO oodNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","T ab haha wo em‑abk mamt ab wo i e hoꞌigeꞌidahunad ni‑ohg wui am ni‑chehchegch. Pi amt heg wo waꞌi hiwgad manis ahni am wo waꞌi ni‑hoꞌigeꞌidahunad em‑wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ni‑ohg o ab si em‑tatchua nam pi ab si ni‑tatchua ch ab s‑wohochud mant ia jiwia ab amjed g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ia ant woho jiwia ab amjed g ni‑ohg id dahm jewed. T e ai mant uhpam ep wo hih am ni‑ohg wui.” ");
INSERT INTO oodNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kuchd ab wui hab kaij, “Nehꞌe, hemuch ap si tasho am ahg haꞌichu ch pi hekaj g wepogida haꞌichu ahga. ");
INSERT INTO oodNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ch hahawa s‑mahch map wehs haꞌichu s‑mahch. Pi o hab hahawa mahs machs hedai ab wo ge haꞌichu m‑kakke. Ch hekaj hahawa s‑wohochud map ab amjed g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","D hab kaij g Jesus, “Nam hig hab elid mam id woho s‑wohochud? ");
INSERT INTO oodNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ab o e aihim mamt gam hu aꞌai wo si e gantad k gam hu uhpam wo hihi e‑kihki wui ia hejel ni‑dagitok. Ni wabshaba pi hejelig. Ni‑ohg o chum hekid ni‑wehmaj. ");
INSERT INTO oodNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Wehs ani em‑ahgid ihda mamt heg hekaj wo si s‑ap e tahtkkad. T wo em‑shoꞌigch hegam mo pi ab hu tatchua g Jiosh. Mt wabshaba am wo si e gewpkai nant pi heki hu s‑ap wo em‑gewitojel g pi apꞌekam.” ");
INSERT INTO oodNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","D am i kuhgi g Jesus g haꞌichu e‑ahga k am i nea dahm kahchim wui k am e hoꞌigeꞌidahun k hab kaij, “Ni‑ohg, ia at i e ai g ni‑tashga. Ab g uhpam ni‑mahki hegai ni‑gewkdag mani wa an uꞌukch m‑hugid an. Nt ab haha wo si has m‑elid k wo mahsko wua g m‑gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ab apt i ni‑mah g gewkdag am wehs ha dahm g hemajkam. Kut haꞌi ab ni‑wui e dagito no pi d m‑hemajkamga. K hab d m‑elida mant wo ha mah g pi ha huhugedam doakag. ");
INSERT INTO oodNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Dap wohokam Jiosh ch am i ni‑kei mant ia wo jiwia jewed dahm. Kut wehs wo bei g pi ha huhugedam doakag hegam mat wo s‑t‑mahchk. ");
INSERT INTO oodNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ia ant ha chehgi g hemajkam g m‑gewkdag k nahto hegai chikpan mapt ab i ni‑cheha mant hab wo juh. ");
INSERT INTO oodNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pegih, ni‑ohg, ab g uhpam ni‑be k ep wo ni‑mah hegai ni‑gewkdag mani wa edgid an m‑hugid an matt eda koi an hu nahto g jewed. ");
INSERT INTO oodNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ab apt ni‑wui i ha gawulkai idam chechoj mo ia ni‑wehmaj. K d m‑hemajkamga. Am ani i m‑mahtchulid ha wui ch ha ahgid g haꞌichu m‑ahga. Kut ab s‑wohog elid ");
INSERT INTO oodNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","k hahawa s‑mahch mo wehs g ni‑mahchig ab d m‑amjedkam. ");
INSERT INTO oodNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ab ap ni‑mahkch g haꞌichu e‑ahga. Kuni am ha ahgid. T ab i s‑wohochud k heg hekaj s‑mahch mani ab d m‑amjedkam. ");
INSERT INTO oodNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Idam o d m‑hemajkamga. Kuni heg hekaj am ha wehhejed ni‑hoꞌigeꞌidahun ch pi ha wehhejed hegam mat pi ab hu wo m‑tatchua. ");
INSERT INTO oodNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Hegam o d waꞌi m‑hemajkamga mat ab wo ni‑hiw mant wo ha doꞌibia. T g ni‑gewkdag ab wo e chehgi ha ab. ");
INSERT INTO oodNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","T hemuch e ai mant wo hih am m‑wui k pi ia hu haha wo haꞌichugk id dahm jewed. T wabshaba idam ia hu wo haꞌichugk. Kuni ab m‑tahni mapt wo ha nuhkudad, ni‑ohg. Dap hekia s‑apꞌekam. Kut ab wo m‑ihmad ch hab d wo hemakok hab masma mach ahchim d hemako. ");
INSERT INTO oodNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ia ani ha nuhkudahim mat ab wo m‑ihmad. Kut heg waꞌi pi e doꞌibia mo an oꞌohanas matki hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Id ani hab kaij mani ia wabsh kia ha wehmaj ch koi ab hu m‑wui hih mant hekaj ab wo si ha mah g s‑ap tahhadkam. ");
INSERT INTO oodNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ab ant ha ahgi g haꞌichu m‑ahga. T ab i s‑ni‑wohochud k ab ni‑hiwig ch ab i e gawulkai ha amjed hegam mo pi ab hu m‑tatchua. K hegam heg hekaj s‑ha kehꞌid. ");
INSERT INTO oodNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Pi ani heg hab ahg maps ia wo i ha wuwhas ab amjed g jewed ch wabshaba hab ahg mapt wo ha nuhkudad. T hab pi gm hu wo i ha nuꞌichshul g ge Jiawul. ");
INSERT INTO oodNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ab o gawulkdas idam pi apꞌekam t amjed hab masma mani ahni. ");
INSERT INTO oodNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ab g i ha gawulkad e wehhejed heg hekaj haꞌichu e‑ahga. Haꞌichu m‑ahga o d wohokam. ");
INSERT INTO oodNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Am apt i ni‑kei mant ia wo ahgad g haꞌichu m‑ahga jewed dahm. Kunt hab wa masma am i ha chuhcha. ");
INSERT INTO oodNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ab ant si i ni‑dagito m‑wui mat idam wo s‑mahchk g wohokam ch hekaj ab hab waꞌap wo i e dagito m‑wui. ");
INSERT INTO oodNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Pi ani idam waꞌi ha wehhejed ni‑hoꞌigeꞌidahun ch wabshaba hegam ehp mat ab wo i s‑wohoch g haꞌichu ha‑ahga k ab wo i e dagito ni‑wui. ");
INSERT INTO oodNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Id o d haꞌichu ni‑tahnig mat wehs am wo i e hemakoch hab masma mach ahchim d hemako. Kut hab wo s‑mai g hemajkam map d ahpi ch am i ni‑kei mant ia wo jiwia. ");
INSERT INTO oodNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","M‑gewkdag o d ep ni‑gewkdag nach pi d hemako. Kuni ab ha mahkch g t‑gewkdag mat t‑wehm d wo hemakok. ");
INSERT INTO oodNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Dani hemako ha wehm hab masma mach ahchim d hemako. T hab wehs s‑ap d wo hemakok idam. T heg hekaj wo s‑mai g hemajkam mapt am i ni‑kei mant ia wo jiwia jewed dahm k ep wo s‑mai map ab si ha tatchua idam hab masma map ahni. ");
INSERT INTO oodNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ni‑ohg, ab apt i ni‑mah idam mo ab si ni‑tatchua. Kuni si tatchua mat am wo ni‑wehmajk anai mant anai wok. An apt ni‑mah g si s‑kehg apꞌedag nap pi si ni‑tatchua mat eda koi e nahto g jewed. Kuni ab m‑tahni mat idam am wo ni‑wehmajk ch heg wo neidad map haschu ab ni‑mahkch. ");
INSERT INTO oodNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dap hekia s‑apꞌekam, ni‑ohg. K pi hi wa chum m‑mahch hegam mo pi ab hu m‑tatchua. Ni wabshaba ahni s‑m‑mahch. K idam ep s‑mahch mapt am i ni‑kei. ");
INSERT INTO oodNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Am ant m‑mahtchul ha wui k am baꞌich wo i m‑mahtchul ha wui. T hab wo si pihk e elidad ni‑hekaj hab masma map ahpi. Nt ahni am wo i ni‑hemakoch ha wehm.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","D am i haꞌasa e hoꞌigeꞌidahu g Jesus. Kuchd gam hu aigo i chehchsh hegai aki mo hab e aꞌaga Kidron k am dada mo am eshas g uꞌus. ");
INSERT INTO oodNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","3","D eda pi an hu t‑wehmaj g Judas nadki pi gam hu him k am si gagda g Jesus ha wui g uꞌugchu papal ch Palasi. Kudki idam ab muꞌi ha cheha g shondal ch cheopi nuhkuddam mat am wo oi g Judas. Dki heg ab i ha wanim no pi s‑mahch matt hebai wo haꞌichugk no pi muꞌikko am t‑wehm dahiwup amai. D idam haꞌijj ge iꞌis‑papayo ch haꞌijj ge lalamba ch haꞌijj wabsh kuhdch. ");
INSERT INTO oodNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","D eda wa chum wehs s‑mahch g Jesus mat haschu has wo e juh am tahgio ch wabshaba am i hih ha wui k hab kaij, “Dohm in gahg?” ");
INSERT INTO oodNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","D hab kaij idam, “Hegai Jesus mo ab Nazareth t ab d kihkam.” Kud hab kaij g Jesus, “Ahni ani wud.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","D haha wabsh e totods hegam k ab taꞌi si i gegokiwua k wabsh i shul. ");
INSERT INTO oodNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","D ab ep ha kakke g Jesus, “A m hedai in gahg?” D hab ep kaij, “Hegai Jesus mo ab Nazareth t ab d kihkam.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","D hab kaij g Jesus, “Am ani wa heki hu em‑ahgid mani d ahni. Mtp ahni in wo ni‑gahghid ch pi has wo ha juh idam.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Neh, bo kaij no pi s‑t‑doꞌibiamk. Kud hab masma hab e juh g neꞌokij mo wa hab kaij matt wehsijj wo t‑doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","D g Simon Peter ge is‑pahyo ch ab i huhpan k ab hu wabsh si i widut k higshp an si hikuch g s‑apkojed nahkaj hegai mo d uhgchu pahl neholiga ch hab chehgig Malcus. ");
INSERT INTO oodNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","D hab kaij g Jesus ab Peter wui, “Ga g hu uhpam hab juhni g e‑is‑pahyo. Pi apt wo e nako mapt wo ha shohbi nant pi hemho wa wo nako mo haschu g ni‑ohg apꞌechudch am ni‑wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","D ab ha cheha g shondal g ha‑geꞌejig mat am wo i ha wehmt g cheopi nuhkuddam. D am bei g Jesus k gan hu si wulsh g nohnhoij k gam hu i wanim Jerusalem wui. ");
INSERT INTO oodNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Am ad kih g uꞌugchu papal. Kud gan hu wehpeg i bei heg wui mo hab chehgig Annas. Ihda Annas o d baꞌamad ohgaj hegai mo d si uhgchu pahl ch hab chehgig Caiaphas. ");
INSERT INTO oodNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","K d ihda Caiaphas mad wa am ha shelinid g hahaꞌichu mat hemako wo muh g oꞌodham wehs ha wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kuchd gohkajj g Simon Peter wehm am i ha oi mo am bebhehim g Jesus. K eda g uhgchu pahl s‑ni‑mahch. Nid hekaj am i wah kolhai ch ed. ");
INSERT INTO oodNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","D g Peter ga hu waꞌi kehk jeg ed ab kihjeg t ab. Nid am hahawa him k ab ahgid hegai chehia mad ab nuhkud g kihjeg mat ab wo i wahki g Peter. ");
INSERT INTO oodNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","D hab kaij ihda chehia ab wui g Peter, “Nap hig pi ahpi an ep wehmaj hegai mamt an bei?” D hab kaij g Peter, “Pi ani an hu shaꞌi wehmaj.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","D eda s‑hehpid. D hekaj am ge nahdch g pion ch cheopi nuhkuddam ch am gegok ch e huhkalid. D g Peter am him k am ha wehm i kekiwua k e huhkal. ");
INSERT INTO oodNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","D g uhgchu pahl ab kakke g Jesus mas haschu ahgk ab haꞌi i ha gawulkad k haschu ha mashcham. ");
INSERT INTO oodNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","21","D hab kaij g Jesus, “P haschu ahgch ahni ab ni‑kakke? Pi ani hekid s‑aꞌagi haꞌichu ahg ch wabshaba wehs hemajkam wui hab kaij ch am ha mashcham ha‑cheopi ed ch geꞌe cheopi ch ed mach am wehs t‑hehemapad. Pegih, ab g hig ha kakke mani haschu i ha mashcham. S‑mahch o mani haschu ha ahgid.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","D hab wabsh chum chei. D ab si shonikka g cheopi nuhkuddam k hab ahg, “Pi apt hab shaꞌi kaidam wo neokad ab uhgchu pahl wui.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","D hab hahawa kaij g Jesus, “Am g hig wehs wo ha ahgi manis haꞌichu pi ap hab kaij. Wohokam ani em‑ahgid. Pt haschu ahgk ab ni‑shonikka?” ");
INSERT INTO oodNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","D g Annas am hahawa ha cheha mat am wo uꞌapa Caiaphas wui. Kud an wabsh kia wulshch g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","D eda g Peter am wabsh kia e huhkalid ha‑nahda wui. D hab kaij hegam mad am wehmaj, “Nap hig pi ahpi an ep wehmaj hegai mamt an bei?” D wabshaba g Peter pi mahch k e ah hab kaijch, “Pi ani an hu shaꞌi wehmaj.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","D am hema kehk g neholigaj g uhgchu pahl ch d hajunij hegai mat g Peter hikuch g nahkaj ch hab kaij ab wui g Peter, “Nani pi woho m‑neid amai matt am bei ihda?” ");
INSERT INTO oodNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","D hab kaij g Peter, “Ih, piaꞌa.” D edapk am i kuhu g keli chuchul. ");
INSERT INTO oodNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Wabsh i siꞌalim mad koi i chesh g tash, md gam hu i bei g Jesus kownal kih wui. D hab chehgig hegai Pilate. D pi am hu i wahp g Tutuligo kownal kih ed no pi g t‑himdag hab chuꞌig matt wo t‑uamhu mattp am wo i wahp gawul hemajkam ha‑kih ed. Kut pi wo apꞌedagk mat wo huh g kahwal mad iagchulig gegosig imhab i juhk matp am wo i wahp. ");
INSERT INTO oodNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","D heg hekaj gam hu i wuhsh g Pilate k am ha nam k hab kaij, “Shahchu am ab abchud ihda oꞌodham?” ");
INSERT INTO oodNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","D hab kaij ab wui, “Pi att woho ia wo uꞌapa ahpi m‑wui hegai matt pi koi wo s‑mai mo am hab junihim g pi apꞌekam.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","D hab kaij g Pilate, “Pegih, mt ahpim wo be k ab wo mah g s‑koꞌok namkidadag mo has i mahs g em‑himdag chehanig.” D hab kaij g Tutuligo, “Pegih, bo mahs g t‑himdag chehanig mat wo e mua heg hekaj pi ap e‑chuꞌijig. K eda pi t‑hiwgid g geꞌe kownal ab Rome t ab machs hab wo juh. Tt heg hekaj ia uꞌapa mapt ahpi am hab wo juh.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Id ad wa hab e juh mat hab masma wo e muhkid g Jesus mo wa hab kaij no pi g kownal hab masma ha muhkid. ");
INSERT INTO oodNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","D g Pilate gam hu uhpam wah e‑kih ed k ab i wai g Jesus k hab kaij ab wui, “Neh, nap hab e elid map d ha‑kownalig g Tutuligo?” ");
INSERT INTO oodNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","D hab kaij g Jesus, “Nap ab ni‑kakke ihda ab hejel e amjed, aha no haꞌijj ab haꞌichu i m‑ahgid ab ni‑amjed?” ");
INSERT INTO oodNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kud hab kaij g Pilate, “Pi ani d shaꞌi Tuhligo manis wo s‑mahchk ihda. M‑wehm hemajkam ha wehm g e‑papalig at ia m‑uꞌapa. Pt haschu has juh?” ");
INSERT INTO oodNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","D hab kaij g Jesus, “Ni‑kownaltalig o pi hab chuꞌig mo g id dahm jewed kokownaltalig, Tp hems hab wo chuꞌigk, t wo ha cheggia hegam mo ab si ni‑wecho e mashcham mamt pi am hu wo i ni‑dagito hahaꞌichu ha wui. Pi o hab mahs g ni‑kownaltalig.” Neh, bad kaij g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","D heg hekaj hab ep kaij g Pilate, “Kupki woho hab kaij map d kownal!” D hab kaij g Jesus ab wui, “Heuꞌu, dani kownal ch ia jiwia jewed dahm k ia mahsi mant wo ha ahgi g wohokam. Matp hedai ab wo tatchuad g wohokam at ab wo ni‑kaiha.” ");
INSERT INTO oodNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","D gam hu hab si e widu g Pilate k hab kaij, “Mas haschu d i wohokam.” D am hahawa uhpam i wuhsh ha wui g hemajkam k hab ha ahg, “Pi ant haꞌichu shaꞌi cheh manis ab wo abch ihda. ");
INSERT INTO oodNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","K eda wehs ahid ab am hema i e dadagitod g lihso em‑wehhejed iaꞌi idani mam wushshad g e‑shohshon ha‑doꞌibiadag. Pegih, nam tatchua mant id wo dagito mash d em‑kownalig ahpim Tutuligo?” ");
INSERT INTO oodNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","D si s‑kaidam hihnk ch hab kaij, “Pi hegai. Barabbas ach tatchua.” D eda d s‑chu ehskam ch d ha muꞌakam ihda Barabbas. ");
INSERT INTO oodNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","D am hahawa ha cheha g Pilate g shondal mat wo s‑koꞌokam gewitta g Jesus. Kud wa woho hab e juh ");
INSERT INTO oodNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","k am hahawa ge hoꞌi gihkot k ab wahki moꞌoj ab k ab wahki g kownal kahba ");
INSERT INTO oodNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","k wabsh has ahg ch hab kaij, “Wapt wo si tash d Tutuligo ha‑kownaligk,” ch ab hahawa si shonikkash. ");
INSERT INTO oodNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","D am ep i wuhsh g Pilate k hab kaij am ha wui g hemajkam, “Nehꞌe, ab ant ep wo i wuhshad k wo em‑chehgi mant pi haꞌichu shaꞌi cheh g pi ap chuꞌijig mas hekaj wo e muhkid.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Md am hahawa i wuhshad k ab wabsh kia wahkch g hoꞌi gihko ch hegai kownal kahba. D hab kaij g Pilate ab ha wui, “Ab g wo i neid mo d wabsh si shoꞌig oꞌodham.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","D am i nei g uꞌugchu papal ch cheopi nuhkuddam k si s‑kaidam hab wabsh ge kaij muꞌikko, “Muꞌani! Muꞌani ab kots t ab!” D g Pilate hab kaij, “Pegih, k wo be k ahpim ab wo mua kots t ab. Ahni ant hi pi haꞌichu shaꞌi cheh mas melchkwua g kownal chehanig mat wo e muhkid.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","D hab kaij hegam Tutuligo, “Ahchim at hi melchkwua g t‑chehanig am hugkam mat hemho wa wo e muhkid no pi hab e aꞌaga mo d Jiosh alidag.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Neh, d am i ha kah g Pilate mad hab kaij idam k baꞌich i e ebkiod ");
INSERT INTO oodNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","k gam hu uhpam i wah k hab kaij ab Jesus wui, “Bahp amjed him?” D wabshaba g Jesus pi ab hu has shaꞌi chei. ");
INSERT INTO oodNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","D hab ep kaij g Pilate ab wui, “Aha, napt pi has wo chei ab ni‑wui k eda s‑mahch mani gewkdag mant wo m‑dagito o ab wo m‑mua kots t ab!” ");
INSERT INTO oodNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","D hab kaij g Jesus ab wui, “Jiosh at ab m‑mah hegai gewkdag. K heg hekaj si pi ap hab e wua idam Caiaphas mo m‑piꞌichud mapt pi ap wo hekaj g e‑gewkdag.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","D am i kah g Pilate ihda k am ep i wuhsh ha wui k am chum si e nako mat wo dagito. D wabshaba si s‑babgam hihnk hegam hahaꞌichu ch hab kaij, “Nehꞌe, ihda hemajkam o hab e ahg mo d si geꞌe kownal ch heg hekaj ab wui kehk hegai mo d si geꞌe kownal ch ab Rome t ab. Kupki ahpi hab waꞌap ab wui kehk g si geꞌe kownal mapt wo sha dagito ihda.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","D am i kah g Pilate ihda k am hahawa i wuhshad g Jesus k heg ga hu i dahiwua usagakam daikud ed amai mach hab aꞌaga Gabbatha mo an sha uhgk i hodaitas. ");
INSERT INTO oodNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","D eda e aihim g dahm juhk. Kud wo e kokda g kahwal mahmad imhab i juhk mat wo e wuhshad g t‑shohshon ha‑doꞌibiadag. D hab kaij g Pilate ab ha wui g hahaꞌichu, “Ia g hu wo neid g e‑kownalig.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","D ab ep si s‑babgam hihnk ch hab kaij, “Muꞌani! Muꞌani ab kots t ab!” D hab kaij g Pilate, “Aha nam tatchua mant wo mua g si uhgk em‑kownalig ab kots t ab?” D hab kaij g uꞌugchu papal, “Heg o d waꞌi si uhgk t‑kownalig mo ab daha Rome t ab.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","D am hahawa i dagito g Pilate g Jesus mamt ab wo mua kots t ab. D am hab hahawa e juh g ha‑tatchui mamt ab ha mah g Jesus. D gam hu i wanim. ");
INSERT INTO oodNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","D g Jesus am kushwiot g hejel e‑kots. Kuchd am dada amai mo am e kokda. Bach aꞌaga amai Golgotha mo hab d ahga Koshwak. ");
INSERT INTO oodNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kumt gam si wuahawua g wehschugaj k ab sisish kots t ab k ab uhgk i bei. D eda gohk d ep lilso. Kumd idam hab waꞌap ab ha sisish kokots t ab k gan hu aꞌaijed ha chuhcha Jesus hugid an. ");
INSERT INTO oodNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","D an sisishp g tapial Jesus kots t ab. K an ab hab chuꞌig: “Id o d Jesus ch d ha‑kownalig g Tutuligo.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","K eda pi mehk ab kihhim t amjed amai mam am ha kokda. D heg hekaj muꞌijj g t‑wehm oꞌodham ab neꞌokchul hegai mo haschu an oꞌohanas. K an oꞌohanas g t‑neꞌokikaj ch g Rome neꞌokikaj ch g Greek neꞌokikaj. ");
INSERT INTO oodNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","D gam hu uhpam ep hihi g uꞌugchu papal Pilate wui am i neꞌokchulidk ihda k hab ahg, “Pi g hab masma an oꞌohan mo d t‑kownalig k wabshaba an oꞌohan mo heg hejel hab kaij mo d t‑kownalig.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","D hab kaij g Pilate ab ha wui, “Mant haschu an i oꞌoha, t heg an wo oꞌohadagk.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","D hegam shondal mad am naggia g Jesus d giꞌik ch hekaj am giꞌikpa e tahpad g Jesus wepschuga. K am hema d si s‑namkig haꞌichu eniga ch pi hebai ha shohmas. ");
INSERT INTO oodNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","D id hab ahg g shondal ch hab kaij ab aꞌai e wui, “Pi att am hu aꞌai wo t‑wanchid ihda k am wabsh wo t‑chichwi matt hedai wo t‑gehg k heg wo bei.” Neh, bad kaij ch woho am hab e juh. Kud hab masma am e wohokamch g Jiosh oꞌohana mo an oꞌohanas hab masma: T am aꞌai wo e tahpani g wehschugaj g Jiosh si Kehsha k am wabsh wo e chichwi k wo s‑mai mat hedai wo bei g s‑namkig haꞌichu enigaj. ");
INSERT INTO oodNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","D am gegok g jeꞌej ch jiskaj g Jesus miabidch amai mo am naggia. Kud gohk am ep ha wehmaj mo hema d hegai Mary mo g wehmaj kihkam d Clopas ch hema d ep Mary Magdalene. ");
INSERT INTO oodNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nid ahni am ha wehm kehk mo ni‑hekaj si pihk e elid g Jesus. Kud g Jesus an ni‑aꞌaga ch hab ahg g e‑jeꞌe, “Neh, id at d haha wo m‑madk m in kehk,” ");
INSERT INTO oodNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ch hab ep ni‑ahg, “Id at d haha wo m‑jeꞌek.” Neh, nid am i amjed bei g jeꞌej. Kud heg am t‑wehm kih. ");
INSERT INTO oodNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","D hahawa s‑mahch g Jesus mat wehs hab juh mat haschu hab wo chum juh mat koi wo muh ch hab kaij, “Tonom ant.” ");
INSERT INTO oodNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","D an hema daha g haꞌa mad am shuhdagi g pad nawait. D am hema g shondal haꞌichu wakch pad nawait ch ed k an haꞌichu k an uskon k ab uhgk i be k ab kams hab masma mo an oꞌohadag Jiosh heki hu oꞌohana ed. ");
INSERT INTO oodNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","D ab i winiun k hab hahawa kaij, “Ia ant i wehs haꞌichu nahto.” Neh, bad kaij ch am hahawa jumal i moꞌowua k am i muh. ");
INSERT INTO oodNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","D am e nakog g hemajkam mat wo e mihshmad nat pi g baꞌich tash d wo shahwaik ch d wo geꞌe tashk. Kutsh g hahaꞌichu ab kakke g Pilate mat wo e ohmi g ha‑kakhio hegam mad am nahngia. T hab wo e oiwigi g ha‑muhkig mat gam hu wo i e uꞌu k pi ab wabsh wo kia nahngiak t‑mihshmda tash ed, wahm mat id d wo si geꞌe t‑tashgak. ");
INSERT INTO oodNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","D ab ha chehani g Pilate g shondal mat wo ha ohmi g ha‑kakhio. Kud hab ha juh hegam gohk mo ab hugidaj ab nahngia g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","D wabshaba g Jesus heki hu muh. Kud pi ohmi g kakhioj. ");
INSERT INTO oodNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","D hema g shondal g e‑is‑pahyokaj chuꞌakad g Jesus ab hudaj ab. Kud ab ha hekaj si e iawua g ehꞌed ch shuhdagi. ");
INSERT INTO oodNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Id anid neid ch s‑mahch mat woho muh. Kuni hab masma am em‑ahgidahim mamt ahpim hab waꞌap wo s‑mahch mat woho muh. ");
INSERT INTO oodNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jiosh oꞌohana o hab chuꞌig: Pi at hema wo shaꞌi e mul g ohꞌoj. Kut wa woho hab masma hab e juh. ");
INSERT INTO oodNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","K an ep oꞌohanas ch hab chuꞌig: Hemajkam at ab wo neidad hegai mamt ab chuꞌakad. ");
INSERT INTO oodNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","K hema d Joseph ch ab Arimathea t amjed ch s‑wohochud mo g Jesus d Jiosh si Kehsha ch wabshaba s‑ha gihug hegam mo pi hohhoꞌid. D wabshaba hekid am i muh g Jesus, d id am hih Pilate wui k ab e shoꞌigchud k ab tahni g honshpadaj. D am i hiwigi. D ga hu ep jiwia k ab i huduni g muhki k gam hu i bei. ");
INSERT INTO oodNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","D heg am ep haꞌichug Nicodemus mat wa ged hu i wehpeg chehgim g Jesus chuhug ch ed. Idam atsh s‑ap wo juh g muhki. D g Nicodemus heg hekaj uꞌa g siant s‑wehch hegai mo d s‑ap uhw haꞌichu ch d myrrh ch aloes. ");
INSERT INTO oodNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","42","S‑e ad hohtkid nad pi hudunihim. D baꞌich tash d t‑mihshmda tash. K eda an mia cheotas hodai ch ed mamt am hab juh g hihaꞌini k wabshaba koi shaꞌi hekaj. K an wehgaj eshas g uꞌus. Kumd am i bei g honshpadag k am i hobino g s‑kehg ikuskaj heg wehnadk s‑ap uhw haꞌichu mach hab masma hab ha wua g koꞌi k am cheh heg eda hihaꞌini k gam hu hihi. ");
INSERT INTO oodNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domig wabsh i siꞌalim mad wabsh kia s‑chuhugam, tsh gm hu hihi hegam Mary Magdalene k am dada cheo t am. Kutsh heki hu gam hu i e nuꞌichkwua g hodai mad hekaj ab chum kuhpi. ");
INSERT INTO oodNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tsh am chum neid k am hahawa uhpam meh kihhim wui k ad gd hu t‑wui mel ahni John ch Simon Peter k am t‑ahgid ch hab kaij, “Am atki i e wuhshad g t‑kownaligbad hon heg amjed hihaꞌini mat am e cheh. Kuch pi shaꞌi mahch mas hebai has e juh.” ");
INSERT INTO oodNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kuchd g Peter wehm am ha hekaj wohp. ");
INSERT INTO oodNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nid ahni wehpeg ged hu mel nanid pi ahni baꞌich i s‑hohtam meh mad g Peter. ");
INSERT INTO oodNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nid am i koachsh k nei mo am wehch hegai s‑kehg ikus k wabshaba pi am hu i wah. ");
INSERT INTO oodNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","D am hahawa mel g Peter k am wabsh si i wah k cheh hegai ikus ");
INSERT INTO oodNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ch heg ehp mat hekaj e hobino g Jesus moꞌo. D id ged hu hab wabsh hejelko holiwek ch kahch. ");
INSERT INTO oodNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kunid ahni am hahawa epai i wah k am i neidok ab hahawa i s‑wohoch mat woho i wuhsh ab muhkig amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kuchd eda pi koi s‑amichud hegai Jiosh oꞌohana mo hab chuꞌig mat hemho wa wo i wuhsh ab muhkig amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kuchd gam hu hahawa hihi uhpam. ");
INSERT INTO oodNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Sh am ep oimmed g Mary cheo kihjego ch shoak ch atsh am i e jumalkad k am i koachsh hihaꞌini ch ed ");
INSERT INTO oodNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ch ash gohk ha neid g anghil. Idam ash s‑tohtam e enigadadch ch ga hu aꞌai dadha, hema ab moꞌoshko ch hema ga hu aigo ");
INSERT INTO oodNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ch hab kaij, “Uwi, shahchu ap ahgch shoak?” Sh hab kaij ab ha wui, “Heg hekaj matki gam hu i e bei g ni‑kownalig muhki. Kuni pi mahch mas hebai e cheh.” ");
INSERT INTO oodNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tsh hab cheꞌiok ab sikol i kekiwua k ash neid mash ab hema kehk ch ash wabshaba pi shaꞌi mahch mo hedai wud. ");
INSERT INTO oodNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Sh eda d Jesus ch ab kakke ch hab kaij, “Uwi shahchu ap ahgch shoak? Dohp in gahg?” Kush hab e ahg mo d eꞌes nuhkuddam ch hab kaij ab wui, “Ab g si s‑ni‑hoꞌigeꞌid k am ni‑ahgid mapt hebai hab cheh. Nt am wo him k am wo bei.” ");
INSERT INTO oodNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sh hab kaij g Jesus ab wui, “Mary.” Tsh ab hahawa ep i neid k hab kaij e‑neꞌoki ed, “Raboni!” mo hab d ahga “Ni‑mashchamdam!” ");
INSERT INTO oodNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Sh hab kaij g Jesus, “Pi g am hu ni‑shohbid. Koi ant am hu hih ni‑ohg wui. Pt wabshaba am wo him k am wo ha ahgi g ni‑naipijju mant wo uhpam i ni‑nodagi heg wui mo d ni‑ohg ch ahpim d ep em‑ohg. Heg o d ni‑Jioshga ch ahpim d ep em‑Jioshga.” ");
INSERT INTO oodNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","D wa woho am uhpam hih g Mary Magdalene k am t‑ahgi mo neid g t‑kownalig Jesus. K heg am ahgid ihda. ");
INSERT INTO oodNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","D gam hu si i juh domig hudunk. Kuchd am t‑nam hema kih am. D ga hu si yahwidag g kihkjeg nachd pi s‑ha ehbid g hahaꞌichu. D wabshaba am haha wabsh jiwia g Jesus t‑wui k hab kaij, “Am g wabsh wo s‑ap e tahtk,” ");
INSERT INTO oodNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ch ab hahawa t‑chehgid g e‑nohnhoi ch e‑huda. Kuchd si s‑hehgig ab i neidok. ");
INSERT INTO oodNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","D hab ep kaij ab t‑wui, “Am g wabsh wo s‑ap e tahtk. Am ant i em‑chuhcha hab masma mat g ni‑ohg am i ni‑kei. Kumt hab waꞌap am wo ahgachugad g haꞌichu ahgaj.” ");
INSERT INTO oodNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","T hab chei ihda k ab t‑dahm ihbheiwua k hab kaij, “Ab g wo i behꞌi g Hekia S‑apꞌekam Gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kumt wo s‑mahch k ah mas hedai g pi ap chuꞌijigaj gm hu hab i juni g Jiosh ch hedai pi gam hu hab i juni.” Neh, bad kaij ch am hahawa i piꞌata. ");
INSERT INTO oodNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","D g Thomas pi am hu t‑wehmaj mad wa am jiwia g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kuchd am hahawa chum ahgid matt nei g t‑kownalig. D hab kaij g Thomas, “Bant waꞌi masma wo s‑wohoch mat uhpam i wuhsh mant wo nei g nohnhoij mat ab wo s‑babaliwanik mamt ab sisish k ab wo taht abai k ab ep wo taht hudaj ab.” ");
INSERT INTO oodNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Hemako domig amjed, chd am ep i t‑hemapai kih ch ed. D am hahawa t‑wehmaj g Thomas. Chd ab ep si yahwidadch g kihkjeg. D wabshaba ab i wah g Jesus k am jiwia t‑wui k hab kaij, “Am g wabsh wo si s‑ap e tahtk.” ");
INSERT INTO oodNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","D hab hahawa kaij ab Thomas wui, “Ab g i ni‑neid k ab tahtam g ni‑nohnhoi ch ni‑huda k ab wo s‑ni‑wohochudad.” ");
INSERT INTO oodNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","D hab hahawa chei g Thomas, “Ni‑kownalig ch ni‑Jioshga!” ");
INSERT INTO oodNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","D hab ep kaij g Jesus ab wui, “Ab apt i s‑ni‑wohoch nap pi ni‑neid. Baꞌich at wo i s‑hehgigk hegam mat ab wo i s‑ni‑wohoch wa chum pi g e‑wuhpuikaj ni‑neidch.” ");
INSERT INTO oodNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Muꞌi s‑hasig haꞌichu ad hab ep juh g Jesus am t‑nena ed mant pi oꞌoha id eda oꞌohana. ");
INSERT INTO oodNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nt id in hi wa ha oꞌoha mamt ab amjed wo s‑wohoch mo g Jesus d Jiosh si Kehsha ch d alidaj k hab masma ab wo bei g wechij doakag. ");
INSERT INTO oodNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Am waꞌi hebai amjed, d am ep i e chehgi g Jesus t‑wui amai al kahchki am am Galilee jewed ch ed. ");
INSERT INTO oodNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Am achd wa oiopo g ni‑nawoj James wehm. K g Simon Peter ch Thomas Kuadi ch Nathanael ch gohk ep g t‑wehm e mashchamdam am t‑wehmaj. ");
INSERT INTO oodNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","D hab kaij g Simon Peter ab t‑wui, “Ih, nt hi wo sha ha uꞌim g waptopi.” Kuchd hab kaij, “Pegih, tt wo m‑oi.” Chd am hahawa dadhaiwua wahlko ch ed k am i himch shuhdagi oidch k ge chuhug oidam am wuakch g t‑chuagia shuhdagi ch ed ch pi haꞌichu shaꞌi bei. ");
INSERT INTO oodNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","D ab i chesh g tash. D ab hema kehk shuhdagi hugidgo. Kuchd pi shaꞌi mahch mo hedai wud. ");
INSERT INTO oodNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","D hab kaij, “Wihpiop, namt pi haꞌichu shaꞌi bei?” Chd hab kaij, “Pi haꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","D hab hahawa kaij, “An g wo daꞌichud g e‑chuagia inhab s‑apkojed g e‑wahlko k wo haꞌi ha ui.” Kuchd wa woho hab t‑juh k pi t‑nako machs ab uhpam wo i cheshaj nad pi shaꞌi si muꞌi am e baꞌiha g waptopi. ");
INSERT INTO oodNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nid hab hahawa kaij ab Peter wui, “Doki t‑kownalig Jesus!” D am i kah g Simon Peter moki d Jesus k ab wah g e‑eniga mat wuahawua k am i dah shuhdagi ch ed k am i e wachwihim k ga hu jiwia wui. ");
INSERT INTO oodNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chd ahchim haꞌi ab hahawa i himch g wahlko ab chewaimedch g chuagia waptopi shuhdch nachd pi am waꞌi waik siant keishpa ab amjed mo an i hug g shuhdagi. ");
INSERT INTO oodNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kuchd an i huhud shuhdagi koa an k nei mo g chuhdagi am wehch. D am dahm kahch g watopi. D g pahn am ep wehch. ");
INSERT INTO oodNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","D hab kaij g Jesus ab t‑wui, “Ab g wo haꞌi uꞌuk g waptopi em‑uꞌi.” ");
INSERT INTO oodNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ab ad wabsh i si shuhdags g chuagia g geꞌeged waptopikaj. Kud g Simon Peter gan hu i chesh wahlko ch ed k ab i chewaim. Kud d siant hetaspo wehst‑mahm gamai waik (153). D eda pi e wantsh g chuagia. ");
INSERT INTO oodNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","D hab t‑ahg g Jesus, “Oi g wo i hihim k e gegosid.” Kuchd pi hedai ab kakke mo hedai wud nach pi wa chum s‑mahch mo d Jesus. ");
INSERT INTO oodNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","D am hih g Jesus k am bei g pahn k an i t‑hainidahim k g watopi am ep be k an i ha t‑mahkhi. ");
INSERT INTO oodNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Id o d waꞌi waikkokam mad am i e chehgi g Jesus t‑wui amjed mad ab i wuhsh muhkig amjed. ");
INSERT INTO oodNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kuchd am i t‑nahto t‑gegosidk. D hab kaij g Jesus ab Simon Peter wui, “Simon map d Jonas alidag, nap baꞌich i si pihk e elid ni‑hekaj mo hi idam?” D hab kaij g Peter, “Heuꞌu, ni‑kownalig, s‑mahch ap mani ab si m‑tatchua.” D hab kaij g Jesus ab wui, “Am g i ha nuhkud g wechij ni‑wohochuddam no pi hab waꞌi masma mo g kahwal mahmad.” ");
INSERT INTO oodNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","D hab ep kaij g Jesus ab wui, “Simon, nap woho si pihk e elid ni‑hekaj?” D hab kaij g Peter, “Heuꞌu, ni‑kownalig, s‑mahch ap mani ab si m‑tatchua.” D hab ep kaij g Jesus, “Am g i ha nuhkud g ni‑wohochuddam.” ");
INSERT INTO oodNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","D id d i waikko mad hab kaij g Jesus, “Simon, nap ab si ni‑tatchua?” D si pi ap e tahtk g Peter mat waikko ab waꞌi kakke ch hab kaij, “Ni‑kownalig, wehs ap haꞌichu s‑mahch ch s‑mahch mani ab si m‑tatchua.” D hab kaij g Jesus, “Am g i ha nuhkud g ni‑wohochuddam. ");
INSERT INTO oodNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Neh, s‑mahch ap map hejel s‑ap an has i e wua ch am hab e junihim map has i tatchua. Nt wabshaba wo si shel m‑ahgi mapt am wo i si kelit k ab haha wo uhgk i uhꞌul g e‑nohnhoi. T wabsh hema ab wo m‑enigadad k am wo i m‑bei map hebai chum pi am hu himimk.” ");
INSERT INTO oodNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kudki heg hab ahg matki has masma wo e muhkid g Peter. T hab wo s‑mai g hemajkam g Jiosh gewkdag. Kud g Jesus hab hahawa ahg g Peter mat gam hu hasko wo oi. ");
INSERT INTO oodNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","D am wehmaj i hih g Peter. Nid ab i ha oi. Kud g Peter ab uhpam i nea k ni‑neid ");
INSERT INTO oodNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","k hab kaij ab Jesus wui, “Ni‑kownalig, kut haschu am hab wo e juh am tahgio ihda John.” ");
INSERT INTO oodNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","D hab kaij g Jesus ab wui, “Neh, mantp wo tatchuidad g John mat pi wo ha muh k ab wo ai mant ep wo jiwia, k pi ab hu haꞌichu m‑him heg amjed. Am apt wabsh wo ni‑oidad.” ");
INSERT INTO oodNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kudki an i e ahgidahi am ha shahgid g Jesus wohochuddam mantsh pi wo ha muh. D eda pi hab kaij g Jesus manis pi wo ha muh ch hab kaij, “Mantp wo tatchuidad mat pi wo ha muh k ab wo ai mant ep wo jiwia, k pi ab hu haꞌichu m‑him heg amjed.” ");
INSERT INTO oodNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ahni ani wud manid neid ch kah ch ia oꞌoha. Kuni si s‑mahch mo d wohokam. ");
INSERT INTO oodNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Neh, muꞌi ad haꞌichu hab ep juh g Jesus. Tp hems am wo i e oꞌohanahi wehs k wabsh wo shuhd g jewed.");
INSERT INTO oodNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ni-nawoj map ab si tatchua g Jiosh: Am ant ep wo i em-oꞌohani ahni Luke mant wa heki hu m-oꞌohani hegai mash wa haschu hab junihim ihda Jesus ch haschu ha mashcham eda mash am oimmelhim ha shahgid g Tutuligo hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Hekia S-apꞌekam Gewkdag ash wa ab mahkch g Jesus g gewkdag. Kutsh heg am haꞌi i ha chuhcha k am ha mashcha g e-chehanig. ");
INSERT INTO oodNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mtsh am hahawa shoꞌigchud k mua. Tsh wabshaba uhpam ep e chegito k am e chehgid ha wui g e-chuhchai ch nahnko masma wohokamchud mo d doakam. Kush idam muꞌikko neid am oidam g giꞌikko wehst-mahm tash matsh eda koi im hu i e bei dahm kahchim wui. Sh g Jesus muꞌi haꞌichu ha mashcham ab amjed g Jiosh kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Sh wa am hu hebai am e hemapadch. Sh hab kaij g Jesus ab ha wui, “Mat ab i em-mah g John g pahl wakona. T wabshaba g Hekia S-apꞌekam Gewkdag g si geꞌe gewkdag ab wo i em-mah pi shaꞌi muꞌi tash iꞌajed. Ni am wa heki hu em-ahgid mo hab kaij g Jiosh matsh id am hab wo em-juni. Kumt ia wabsh wo haꞌichugk Jerusalem kihhim t am k ab wo ai mat hab wo e juh.” ");
INSERT INTO oodNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sh am hema ep d tash. Tsh am ep i e hemapai g chuhchaij wehmaj g Jesus k ab kakke, “T-kownalig, napt ab hahawa ep wo t-mah ahchim Tutuligo hemajkam g apꞌedag matt hejel am wo i himch g t-kownaltalig?” ");
INSERT INTO oodNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Sh hab kaij g Jesus ab ha wui, “Heki at hu i apꞌech g Jiosh mat hekid am hab wo i e juh hegai mam haschu ab ni-kakke. K pi d em-wuikam mams wo s-ap s-mahchk iaꞌi idani mas hekid wo i k. ");
INSERT INTO oodNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kumt wabshaba am wo i ahgahid mam haschu i s-ap s-mahch ab ni-amjed. Hekia S-apꞌekam Gewkdag at ab wo i em-mah g si geꞌe gewkdag mamt hab wo junihid. Kumt wehpeg am wo i ahgahi Jerusalem kihhim ch ed k amjed wehsko am Judea chekshani ch ed k amjed gam hu Samaria chekshani ch ed. T amjed gam hu wehsko wo i e ahgahi aꞌai jewed dahm.” ");
INSERT INTO oodNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Neh, bash kaij ch amjed im hu hahawa i e bei dahm kahchim wui k gam hu pi e mahsid chewagi ch ed. ");
INSERT INTO oodNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sh am wabsh kia gegok ch am uhgk si nenea idam. Tsh am haha wabsh gohk i e chehgi g anghil k si s-tohtam e enigadadch ");
INSERT INTO oodNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ch hab kaij, “Pi g ia hu wabsh wo gegokk ch am uhgk nenead mat hebai hih g Jesus. Hema tash at wo wa uhpam jiwia hab masma mam hemuch am neid mat has i masma gam hu hih.” ");
INSERT INTO oodNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Id atsh hab e juh Olive Uꞌus Kawulk t ab. Sh heg d al eda hugkam mihya ab amjed g Jerusalem. Tsh ab hahawa i huhud hegam Jesus chuhchai kawulk amjed k am hihim ");
INSERT INTO oodNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","k gan hu dada mo an dadha k d idam Peter, John, James, Andrew, Philip, Thomas, Bartholomew, Matthew, ch hegai James mash g ohgaj hab chehgig Alphias, ch hegai Simon mash d hema hegam mash tatchua mat g Tutuligo hejel wo himchudad g e-kownaltalig, ch hegai Judas mash g ohgaj hab chehgig James. ");
INSERT INTO oodNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sh g Jesus jeꞌe ch wepnag ch haꞌi ehp g uꞌuwi am ha wehm e hehemapad ch am e hoꞌigeꞌidahun Jiosh wui. ");
INSERT INTO oodNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sh am heꞌekia d i tash matsh am ep i e hemapad k d siant gokko wehst-mahm (120) hegam mash ab ihm g Jesus e doꞌibiakch. Kutsh am hahawa i kekiwua g Peter k ash hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ni-wepnag, Hekia S-apꞌekam Gewkdag atsh am i tashogi g t-kownaligbad David matsh has wo e juh hegai Judasbad mo chum t-wehmaj. Kut hemho wa hab e juh mash has i kaij. Judas at am i ha wanim hegam mat am bei g Jesus, ");
INSERT INTO oodNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","chum as d ep chum kehshaj mat am wo ahgahid g s-kehg haꞌichu ahgaj.” Bash kaij g Peter. ");
INSERT INTO oodNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kumtsh wa chum namkid g Judasbad matsh gagda. Tsh wabshaba hema e nolawt g oidag heg hekaj namkidadaj. Kutsh g Judasbad am him k am e naggia heg eda k ab si wantsh g e-wohk. Tsh g hihij gam hu si e iawua. ");
INSERT INTO oodNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Sh heg hekaj hab e aꞌaga Ehꞌed Oidag. ");
INSERT INTO oodNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kush g Peter heg hekaj hab ep kaij, “An o hab chuꞌig heg eda nenꞌei oꞌohana mo an hab chuꞌig Jiosh heki hu oꞌohana ed: Pi at am hu wo haꞌichugk e-kih ed nat pi wo muh. K an ep oꞌohanas: Am at kehkud ed hema ep wo i kekiwua. ");
INSERT INTO oodNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Kut id hekaj hemho wa am hema wo i kekiwua t‑wehm mat hab waꞌap wo wohokamch mat uhpam e chegito g t‑kownalig Jesus. T hemho wa d wo hema t‑ahchimk mach ga hujed i wehmajkahim g Jesus am i amjed mat g John pahl wako am hugkam mat im hu hih dahm kahchim ch ed.” Neh, bash kaij g Peter ch am i haꞌasa neo. ");
INSERT INTO oodNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tsh am hahawa gohk i ha wuwhas. K hema hab chehgig idam Matthias. K hema d ep Joseph Justus ch hab ep e chechcheg Barsabas. ");
INSERT INTO oodNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tsh am hahawa e hoꞌigeꞌidahun k hab kaij, “Ge t‑kownalig, t am i dagito g Judas ihda chikpan k atki am ai g s‑koꞌok e‑namkidadag. Kuch ahchim pi shaꞌi mahch mo has e tatatk g hemajkam. Pt heg hekaj am wo si i t‑tashogi mapt hedai am wo i ha kei idam gohk ");
INSERT INTO oodNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mat d wo si m‑kehshak ch am wo i ahgahi g haꞌichu m‑ahga am kehkud ed g Judas.” ");
INSERT INTO oodNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tsh am hahawa i ha tashogi mat d wo Matthiask ch d wo si kehshajk. ");
INSERT INTO oodNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tsh am i e ai matsh g Tutuligo hemajkam wo e nam k am hab wo juh g hehgchulida Jiosh wui heg hekaj haꞌichu e‑bahijida. Kutsh am wehs i e hemapai hema kih ch ed hegam mash ab ihm g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tsh haha wabsh ab dahm kahchim t amjed haꞌichu hab kaida mo g s‑gewk hewel wabsh shashawuk heg eda kih. ");
INSERT INTO oodNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Sh hahawa haꞌichu ep neid mash hab mahs mo g mei. Tsh id ab aꞌai i e gantad k ab i dahiwuhi wehsijj ha ab. ");
INSERT INTO oodNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kutsh g Hekia S‑apꞌekam Gewkdag ab i ha mah g si geꞌe gewkdag. Tsh hekaj haha wabsh nahnko mahs neꞌokikaj neneo matsh eda chum pi hebai mai. ");
INSERT INTO oodNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sh eda muꞌijj ab dadha Jerusalem t ab hegam mash d Tutuligo ch ab aꞌai i hihi muꞌikpa jejewed amjed matsh ab wo ihm g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tsh an wehsko i kaida hegai mash hab kaidag mo g s‑gewk hewel. Kutsh idam am i kah k am e chehm mash hebai i kaidag. Sh idam Jesus ihmdam haha wabsh am neneok g ha‑neꞌokikaj mash hedai haschu i neꞌokikaj neok. ");
INSERT INTO oodNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kutsh si e totods idam k hab kaij, “Hab kaidam neneok ch eda d wabsh Galilee t am oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kus has masma hab chuꞌig mach wehsijj s‑ha amichud g heheꞌejel t‑neꞌokikaj? ");
INSERT INTO oodNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kuch eda muꞌikpa jejewed amjed, haꞌi ab Parthia t amjed ch haꞌi ab Media t amjed ch ab amjed g Elam ch Mesopotamia ch Judea ch Cappadocia ch Pontus ch Asia ");
INSERT INTO oodNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","ch Phrygia ch Pamphylia ch Egypt ch Crete ch Arabia ch gam hu Cyrene kihhim wehgaj am Libya jewed ch ed ch ab Rome kihhim t amjed. K ia haꞌi t‑wehmaj g gawul mahs hemajkam mat ab i wahp t‑himdag ed. Kuch wehsijj kah g heheꞌejel t‑neꞌokikaj heg amjed mat haschu si s‑hasigam hab juh g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","A t haschu ahgk hab haꞌichu e juh?” Bash kaij nash pi si has elid. ");
INSERT INTO oodNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Sh wabshaba haꞌijj wabsh nahnko ha ahg ch hab kaij, “Tki wabsh nawkk idam.” ");
INSERT INTO oodNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tsh ab hahawa i gegokiwua g Jesus chuhchai. Sh g Peter am amog, “Ni‑hajuni ch ahpim mam ia wabsh sha kih Jerusalem t am, ab g wo si i ni‑kaiham k am wo i oidahi mant haschu wo i em‑ahgi. ");
INSERT INTO oodNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Pi ach d nawkkoi. ");
INSERT INTO oodNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ihda mat haschu has i e juh o d hegai matsh g Joelbad an oꞌoha. Heg ash wa d Jiosh haꞌichu i tashogiddam ch an oꞌoha hab masma: ");
INSERT INTO oodNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Bo kaij g Jiosh: T ab wo i e aihi g si oidchkam tash. Kunt wo cheha g Hekia S‑apꞌekam Gewkdag mat am wo ha wehmajk g hemajkam ch ab wo ha mahkad g si geꞌe i wehmtadag. Kut g em‑wihpiopga ch g em‑chetchaga wo ah g haꞌichu ni‑ahga. Nt wo i ha tashogi g kekel am ha‑chehchki ed mat haschu has wo e juh imhab i dahm. T id hab waꞌap am wo e chehgi ha‑nena ed g wechij oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ab ant wehs wo ha mah g ni‑pionag g Hekia S‑apꞌekam Gewkdag, chum hems g uꞌuwi ni‑pionag, mat am wo i ahgahi g haꞌichu ni‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nt wo ha chehgi g s‑hasigam haꞌichu gan hu uhgk ha dahm ch an jewed dahm. Ehꞌed at wo e iawua. T g mei ch kuhbs wo i wuhsh. ");
INSERT INTO oodNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","T g tash pi wo ton k g mashad wo ge wegiumih hab masma mo g ehꞌed. K id wehs hab d ahga mo e aihim hegai si geꞌe tash mant heg eda wo ha lodai g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kut hedai ab wo i gei ni‑wui k wo e doꞌibia ab amjed g pi ap e‑namkidadag. Neh, bash kaij g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Kumt ab wo i ni‑kaiha, ni‑hajuni. Ihda Jesus mo ab d kihkam Nazareth t ab at hab juh g s‑hasigam haꞌichu mat pi hedai hejel wo shaꞌi e nako mat hab wo juh. T id hekaj am i t‑tashogi g Jiosh mo id am d si Kehshaj. Kum ihda am wa hejel s‑mahch heg hekaj mat wehs am hab e juh em‑shahgid. ");
INSERT INTO oodNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jiosh atsh heki hu i apꞌech matsh has masma wo e muhkid g alidaj k heg hekaj am i dagito em‑wui. Kumt an be k ha mah hegam mo pi mahch g Jiosh chehanig nam pi s‑muꞌamk. Kut idam mua ab kots t ab naggiak. ");
INSERT INTO oodNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","T wabshaba g Jiosh ab i wuhshad ab amjed g s‑koꞌok muhkig nat pi am hab waꞌap i apꞌech mat ep wo e chegito. Kut hemho wa am hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“T an wa oꞌoha g t‑kownaligbad David mat hab wo chei g Jiosh si Kehsha: Chum ap hekid ni‑wehmaj, ni‑Jioshga! Ni heg hekaj pi shaꞌi haꞌichukaj ni‑kudut ");
INSERT INTO oodNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ch wabsh si s‑ap ni‑tahtk ch s‑hehgigam haꞌichu ahg. Ab o e aihim mant wo muh. Nt wabshaba wabsh si s‑ap ni‑tahtk ch wo m‑nenida. ");
INSERT INTO oodNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Pi apt am hu wo shaꞌi ni‑dagito amai mo hebai haꞌichug g koꞌi k pi wo shaꞌi hiwigi mas wo padt g ni‑chuhkug nani pi d hekia s‑apꞌekam m‑alidag. ");
INSERT INTO oodNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Am apt i ni‑chehgi mant has masma uhpam ep wo i wuhsh ab muhkig t amjed. Chum apt hekid wo ni‑wehmajk. Nt heg hekaj wo si s‑hehgigkad. ");
INSERT INTO oodNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Neh, ni‑naipijju, batki masma an oꞌoha g Davidbad. K wabshaba si tasho mo pi hejel hab e ahg mat pi wo padt no pi g ohꞌoj am wabsh kia wehch hihaꞌinij ed id i tashkaj. ");
INSERT INTO oodNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Davidbad ash d Jiosh haꞌichu i tashogiddam ch heg hab ahg Jiosh si Kehsha matsh pi wo padt k wo uhpam i wuhsh ab muhkig amjed. Jiosh ash wa heki hu ahgid g Davidbad mat am wo hema i kei g amjedkam am kehkud ed mat d wo geꞌe kownalk. ");
INSERT INTO oodNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davidbad oki s‑mahch ihda ch heg hab ahg ch hab kaij mat pi am hu wo shaꞌi dagito amai mo hebai haꞌichug g koꞌi k pi wo shaꞌi hiwigi mat wo padt g chuhkugaj. ");
INSERT INTO oodNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Pegih, k d hegai Jesus mat g Jiosh ab i wamigi muhkig amjed. Kuch ahchim g t‑wuhpuikaj neid mach haschu ia em‑ahgid. ");
INSERT INTO oodNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jiosh at am i wahkid k an kei si e‑hugid an. Kut ab bei g apꞌedag k cheha g Hekia S‑apꞌekam Gewkdag mat ab t‑wui wo hih. Heki ash hu hab kaij g Jiosh mat hab wo e juh. K d ihda mam am neid ch kah hemuch mat hab t‑juni. ");
INSERT INTO oodNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pi o hejel hab e ahg g Davidbad ch wabshaba heg hab ahg Jiosh si Kehsha mat pi wo padt k wo uhpam hih am dahm kahchim wui nat pi an ep oꞌoha: Jiosh o hab kaij ab ge ni‑Kownalig wui: In g dahiwua si ni‑hugid an ");
INSERT INTO oodNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","k ab wo ai mant wo ha gewito g m‑obga. ");
INSERT INTO oodNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Pegih, ihda Jesus mamt ab naggia kots t ab o d Jiosh si Kehsha ch d wo t‑doꞌibiakam kownalk. Kutt id wo chum si s‑ap s‑mahchk wehsijj ahchim Tutuligo hemajkam.” Neh, bash kaij g Peter. ");
INSERT INTO oodNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kush si s‑koꞌokam pi ap e tahtk g hemajkam am i kaiok ch hab kaij ab ha wui hegam Peter, “Ih, tt has wo t‑juh, t‑naipijju?” ");
INSERT INTO oodNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Sh hab kaij g Peter ab ha wui, “Heheꞌejel g gam hu wo s‑ohhod g pi ap e‑chegitoi k wo e pahl‑wapko ab chehchegch g Jesus Christ. Kut gam hu hab wo i juh g Jiosh g pi ap em‑chuꞌijig. T amjed wo si em‑wehmajkad g Hekia S‑apꞌekam Gewkdag ");
INSERT INTO oodNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","nash pi g Jiosh hab kaij mat ab wehsijj wo ha mah g Hekia S‑apꞌekam Gewkdag hegam mat ab wo i ha wai e wui.” ");
INSERT INTO oodNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Sh tash am neok g Peter ch am chum ha ahgid ch hab kaij, “Am g wo e doꞌibia. Si s‑koꞌok namkidadag o ab ha aihim hegam t‑wehm hemajkam mat pi gam hu wo ohhod g pi ap e‑chuꞌijig.” ");
INSERT INTO oodNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kutsh waik mihl ab i s‑wohoch g haꞌichu ahgaj heg i tashkaj k e pahl‑wapkon k ab i e hemakoj ha wehm. ");
INSERT INTO oodNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sh g Jesus chuhchai am hahawa ha mashcham. Kush am ha wehm e mihshmad ch e hoꞌigeꞌidahun ch ha wehm huhuga g chemait. ");
INSERT INTO oodNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kush muꞌi haꞌichu s‑hasigam hab junihim idam Jesus chuhchai g Jiosh gewkdagkaj. Tsh heg hekaj muꞌijj ehp ab si has i el mat haschu hab juh g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Sh wehsijj g Jesus ihmdam ab si e hajunit ch wehs haꞌichu ab i aꞌai e mahk mash hedai haschu i pi edgid, ");
INSERT INTO oodNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","chum as hems wo gagda g haꞌichu e‑eniga mat heg hekaj lial am wo i ha wehmt hegam mo haꞌichu i pi edgid. ");
INSERT INTO oodNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Sh wehs tashkaj am e nanmek geꞌe cheopi ch ed ch am ep e wehm e gegosid aꞌai e‑kihki ed si s‑ap e tatatk ch ab wabsh i e shoꞌigchudch Jiosh wui ");
INSERT INTO oodNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ch ab si hehgchulid g Jiosh. Kush wehsijj g hemajkam si s‑ha hoꞌigeꞌelid. Sh g Jiosh ab i ha wahpkid ha shahgid wehs tash ab hegam mat hab waꞌap e doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kush am waꞌi hebai amjed, tsh am dada g Peter g John wehm geꞌe cheopi t am. Kush d i waik ohla gam hu i juhk mo eda e aꞌahe mat wo e hoꞌigeꞌidahu. ");
INSERT INTO oodNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Sh ab hema daha g shoꞌigkam hemajkam heg bahsho kolhai kihjeg mash hab e aꞌaga Si S‑kehg Kihjeg. Kush ihda oꞌodham ga hu e‑alijk amjed pi himdag. Kumsh wehs tashkaj am wabsh i bebhe ch ab dadsha ab kolhai kihjego. Kush wabsh haꞌichu ha tahni hegam mo am daiw. ");
INSERT INTO oodNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tsh eda am wo i wahp idam Peter ch John. Sh ab haꞌichu chum ha tahni. ");
INSERT INTO oodNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tsh ab si i nei idam Peter k hab kaij, “Ab g si i t‑neid.” ");
INSERT INTO oodNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kutsh wa woho ab si i ha nei hab e ahgch mat wo haꞌichu mah. ");
INSERT INTO oodNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Sh oi wa hab wabsh kaij g Peter, “Neh, ni‑nawoj, pi ani ha lialiga ch wabshaba haꞌichu wo m‑mah mat heg baꞌich wo i m‑wehmt. K d ihda mant hab wo m‑ah mapt ab wo i hiw g Jesus Christ k wo kekiwua k wo hih.” ");
INSERT INTO oodNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bash kaij ch ab hahawa bei g nowij k ab i wuhshad. Kutsh am wa i hekaj ab gewpka g kakhioj. ");
INSERT INTO oodNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tsh am si uhgk daꞌa k kekiwua k am wa i hekaj s‑ap hih. Kutsh idam Peter im hu i wahp cheopi kolhai ch ed. Tsh heg ha wehm i wah k si chehk dadꞌehim ch ab si hehgchulid g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Kutsh si has i el g hemajkam am i neidok mo d hegai pi himidkam mo ab dahiwup kolhai kihjego. ");
INSERT INTO oodNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Batsh e juh ihda anai mash hab e aꞌaga Solomonbad Watto. Kush ihda pi himidkam gan hu wabsh i si e uꞌukch ab ha ab g Peter ch John mat pi wo i e gawulkai ab ha amjed. Tsh ab hahawa aꞌaijed i wohp g hemajkam k gan hu ha biha si has i elidk mat e doaj. ");
INSERT INTO oodNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tsh am wabsh apꞌet g Peter mat am ha mihshmad k hab kaij: “Ni‑wehm oꞌodham, pi g am wo si e totodsid. Pi att g hejel t‑gewpkdagkaj doaj ihda oꞌodham, ");
INSERT INTO oodNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","16","Jiosh si Kehsha at hab t‑juni nach pi ab hiwig. K d hegai Jesus mam ahpim s‑muꞌamk ch ab mah g kownal Pilate. K eda g Jiosh d pionag g Jesus ch d hekia s‑apꞌekam ch pi ha chuꞌijig. T ha chum wo dagito g Pilate. M wabshaba ahpim hab ahg mat wo muꞌa k heg wo dagito mo d ha muꞌakam. K heg hekaj d em‑chuꞌijig mat e muhkid. K eda d hegai mo ab t‑makiog g pi ha huhugedam doakag. T wabshaba g Jiosh ab si haꞌichuchud k uhpam i wuhshad ab amjed g muhkig k am i bei dahm kahchim wui. Hegam t‑shohshonbad mash d Abraham ch Isaac ch Jacob ash ab si has i elid g Jiosh. Kum eda ab wui gegok g Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Pegih, ni‑wepnag, mtp hems heg hekaj s‑muꞌam g Jesus mam pi mahch mo heg am d si Kehshaj g Jiosh mat wo t‑doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","T eda heki hu waꞌi amjed an oꞌoha g kelibad Jiosh haꞌichu i tashogiddam mat g si Kehshaj wo e shoꞌigch. T idani woho am hab e juh. ");
INSERT INTO oodNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Pegih, oi g gam hu wo s‑ohhod g pi ap e‑chegitoi k ab wo i e nohnogi Jiosh wui. T heg wo s‑em‑hoꞌigeꞌid k gam hu hab wo i juh g pi ap em‑chuꞌijig k ab wo si i wechijid g em‑dodakag. ");
INSERT INTO oodNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","T ab em‑wui wo i hih g si Kehshaj Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","K hab mahs mat an wo haꞌichugk ihda Jesus dahm kahchim ch ed am hugkam mat hab wo e juh hegai mo haschu i t‑tashogid g kekelibad Jiosh haꞌichu i tashogiddam. ");
INSERT INTO oodNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Neh, bash wa kaij g Mosesbad am t‑shohshon ha wui: Em‑kownalig Jiosh at ab wo hema i kei g haꞌichu i tashogiddam hab masma mat ahni am i ni‑kei. Kut ihda d wo em‑wepo oꞌodhamk. Wehs haꞌichu amt ab wo kaiha mat haschu ab wo i em‑ahgi. ");
INSERT INTO oodNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kut wo e koꞌij matp hedai pi ab hu wo kaihamad. Neh, bash kaij g Mosesbad. ");
INSERT INTO oodNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","K wehsijj ahgachug g kekelibad Jiosh haꞌichu i tashogiddam hegai mo haschu am hab i e junihim idani. Samuelbad ash d hema hegam. ");
INSERT INTO oodNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jiosh ash wa am ha ahgid g t‑shohshonbad matsh haschu hab wo t‑juni. K heg d ep t‑wuikam ahchim mach d ha amjedkam. “Bash kaij g Jiosh am wui g Abrahambad: Am ant wo hema i kei g m‑amjedkam mant heg hekaj ab wo i s‑ha hoꞌigeꞌel g wehs nahnko mahs hemajkam id dahm jewed. ");
INSERT INTO oodNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Neh, t wa woho hab e juh mat am i kei g e‑alidag Jesus. T heg wehpeg ab i s‑t‑hoꞌigeꞌel ahchim Tutuligo k ab t‑wui him k ab i t‑mah g apꞌedag matt ab wo i t‑nohnogi ab amjed g pi apꞌekam.” ");
INSERT INTO oodNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sh am wabsh kia ha mihshmad g Peter ch John. Kutsh am haha wabsh haꞌi dada g papal ch ha‑geꞌejig g geꞌe cheopi nuhkuddam ch haꞌi ehp mash am oid g Sajusi himdag. ");
INSERT INTO oodNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sh eda wa idam Peter ch John am ha mashcham g hemajkam mat ab i wuhsh g Jesus e‑muhkig amjed. Sh idam Sajusi pi hohhoꞌid nash pi pi wohochud mat ep wo e chegito g koꞌi. ");
INSERT INTO oodNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Sh eda e aihim mat wo s‑chukk. T heg hekaj ged hu ha kuh mat wo ha lodai baꞌich tash. ");
INSERT INTO oodNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tsh wabshaba muꞌijj hegam matsh kah g Peter ch John ab i s‑wohoch g Jiosh haꞌichu ahga. Tsh am i muꞌida hegam mash ab ihm g Jesus. Kush hegam mash d chechoj d hahawa hetasp mihl. ");
INSERT INTO oodNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sh am baꞌich d i tash. Tsh am e hemapai g hemajkam ha wanimeddam ch geꞌeged ch chehanig ha mashchamdam. ");
INSERT INTO oodNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kush am ha wehmaj hegai uhgchu pahl mash hab chehgig Annas. Sh g hajunij am hab waꞌap haꞌichug mash haꞌi d Caiaphas ch John ch Alexander. ");
INSERT INTO oodNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tsh ab hahawa i ha wuwhas idam Peter kukpaikud amjed k ga hu i ha chuhcha k ab ha kakke, “Shahchu am e wepogid ch hab haꞌichu wua? Dohm hab elid mamt heg ab bei g e‑gewkdag k doaj ihda pi himidkam?” ");
INSERT INTO oodNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tsh ab baꞌich i gewkai g Peter g Hekia S‑apꞌekam Gewkdag. Sh hab kaij: “Bamki e elid ahpim t‑wanimeddam ch geꞌeged ");
INSERT INTO oodNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","matt hemho wo wa bei g apꞌedag matt hab wo juh g s‑apꞌekam. ");
INSERT INTO oodNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pegih, nt wo em‑ahgi mat g Jesus Christ ab i t‑mah hegai gewkdag matt hekaj doaj ihda oꞌodham. Ahpim amt hab juh hegai Jesus Christ mat ab e naggia kots t ab. T wabshaba g Jiosh ab uhpam i wuhshad muhkig amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Id o hab ahg Jesus g kelibad Jiosh haꞌichu i tashogiddam ch an oꞌoha ihda haꞌichu wepogida mo hab chuꞌig: Kihtdam at wo hema chum s‑ohhodam g hodai. T wabshaba id d wo si s‑has haꞌichu hodaik am ha‑kihta wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hegai waꞌi Jesus at wo ha doꞌibia g hemajkam. Do Jiosh si Kehsha mat ab wo t‑mah g pi ha huhugedam doakag. Kut pi hedai ep hab wo shaꞌi juh g doꞌibiadag.” ");
INSERT INTO oodNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sh si s‑e mahch ch neneok idam Peter. Tsh hekaj si has i ha el idam hahaꞌichu, wahm mat am i s‑mai am i ha kahkch mo d wabsh si oꞌodham ch pi hasko shaꞌi uhgk e mashchamahim. Tsh am hahawa i amich moki an wehmajkahim g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kush am ha wehm kehk hegai mamt doaj. Sh pi e nakog hegam hahaꞌichu mas has wo chei nash pi g e‑wuhpuikaj neid mat woho e doaj hegai. ");
INSERT INTO oodNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kumtsh gam hu hahawa i ha wuwhas hegam Peter matsh g hahaꞌichu am wo i aꞌaga. ");
INSERT INTO oodNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kush hab kaij, “Shahtt wo ha juh. Wehsijj o s‑mahch g Jerusalem t am kihkam mat doaj g pi himidkam. K id d si s‑hasig haꞌichu. Kutt pi wo shaꞌi t‑nako machs hab wo chei mas pi woho hab juh.” ");
INSERT INTO oodNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sh hab hahawa ep kaij, “Matt wo keshwua ihda ha‑ahga mat pi hekid am hu ep wo shaꞌi aꞌagad ihda Jesus am hema i wui.” ");
INSERT INTO oodNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kumtsh ab hahawa ep i ha wahpki. Sh hab ha ahg, “Chum as has wo chuꞌigk haꞌichu, mt pi am hu wo shaꞌi aꞌagad ihda Jesus.” ");
INSERT INTO oodNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Sh hab hahawa si kaij hegam Peter, “Am g wo i aꞌamichud machs ahpim ab wo em‑wohoch aha natt g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tt ahchim hi hemho am wo wa ahgahid mat haschu i si s‑kehg hab juh k haschu i si s‑kehg hab kaij g Jesus mach si neid ch kah.” ");
INSERT INTO oodNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Kush wa eda hegai pi himidkam i baꞌiwchkim g giꞌikko wehst‑mahm aꞌahidag. Sh g hemajkam wehs ab si i hehgchulid g Jiosh mat doaj. Kutsh heg hekaj pi shaꞌi e nako g ha wanimeddam mas has masma s‑koꞌokam wo ha namkid k am wabsh si ha ebkiod k chum ha keshwua k hahawa ha dagito. ");
INSERT INTO oodNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tsh am wa i hekaj ged hu uhpam dada e‑naipijju ha wui k am ha ahgid mo has i ha ahg g uꞌugchu papal ch geꞌeged. ");
INSERT INTO oodNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tsh am i kaiok am ha hekaj e hoꞌigeꞌidahun k hab kaij, “T‑kownalig Jiosh, wehs ap uꞌukch g gewkdag ch nahtokch g dahm kahchim ch jewed kahchim ch ge kahchki ch wehs haꞌichu mo haschu am i ha eda. ");
INSERT INTO oodNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ab aptki cheha g Hekia S‑apꞌekam Gewkdag mat wo amichudach g m‑pionagbad David. K hekaj hab kaij: Shoꞌo waꞌi si s‑babga g nahnko dakam hemajkam ch am chum e nakog mat am hab wo juh hegai mo g Jiosh pi ha hiwgid. ");
INSERT INTO oodNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","T am i e nako g kokownal k am i e wehmt mat ab wui wo gegokiwua g Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Neh, Jiosh t‑ohg, t wa woho am e hemapai g t‑wehm oꞌodham ha wehm g gawul mahs hemajkam ch hegam kokownal mo d Herod ch Pilate. Wehsijj at ab wui gegokiwua g hekia s‑apꞌekam m‑Kehsha, Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Heki apt hu am i apꞌech mapt wo ha hiwigi mat wo mua g si m‑Kehsha. Kut idam mat ab chum m‑wui gegokiwua hab wabsh juh mapt haschu heki hu i apꞌech. ");
INSERT INTO oodNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","30","Pegih, t‑ohg Jiosh, am g i ha neid mo ab si t‑ebkiod k ab wo i t‑mah g gewkdag matt s‑gewkam wo aꞌagad g haꞌichu m‑ahga ch wo ha dodaj g kokꞌodam ch si s‑hasigam haꞌichu hab wo juh g gewkdajkaj g hekia s‑apꞌekam m‑Kehsha, Jesus.” ");
INSERT INTO oodNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tsh am i haꞌasa e hoꞌigeꞌidahu. Tsh g Hekia S‑apꞌekam Gewkdag am si uꞌugij hegai kih mo am e hemapadch k ab si i ha mah g gewkdag. Tsh am hahawa baꞌich i si s‑gewkam ah g Jiosh haꞌichu ahga. ");
INSERT INTO oodNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Wehsijj ash ab aꞌai si e tatchua g Jesus ihmdam ch ab si i hemakoch g e‑chegitoi k pi hedai shaꞌi s‑daꞌa g haꞌichu e‑eniga ab aꞌai e wui. ");
INSERT INTO oodNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Sh idam Jesus chuhchai si s‑gewkam am ahgachug mat uhpam i wuhsh g Jesus muhkig t amjed k d wehs ha‑kownalig. Kush g Jiosh am si i ha wehmt. ");
INSERT INTO oodNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Sh haꞌi am ha gagda g e‑oꞌoidag ch e‑kihki ch ab i uꞌu g lial ");
INSERT INTO oodNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ch ab ha mamka g Jesus chuhchai mash hekid i e tatchua. Sh am hahawa aꞌai ha mamka hegam mash pi haꞌichu edgid. Sh hekaj pi hedai haꞌichu pi edgid. ");
INSERT INTO oodNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sh hema d Joseph ch ab Cyprus jewed t ab d kihkam ch d chum papal ha wehm chikpandam nash pi ab d Levibad amjedkam. Sh id hab ep chechcheg g Jesus chuhchai Barnabas mo hab d ahga I ha Gewkemhundam. ");
INSERT INTO oodNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Id atsh gagda g e‑oidag k ab i ui g namkigaj k wehs ha mah g Jesus chuhchai. ");
INSERT INTO oodNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sh am hema d Jesus ihmdam ch hab chehgig Ananias. Kush g wehmaj kihkam hab chehgig Sapphira ch hab waꞌap d Jesus ihmdam. Kutsh ihda Ananias epai gagda g haꞌichu e‑eniga ");
INSERT INTO oodNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","k hab masma hab chum e juh mat wehs ha mah g namkigaj g Jesus chuhchai k wabshaba ged hu haꞌi si toa e‑wohshag ed. ");
INSERT INTO oodNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Sh hab kaij g Peter ab wui, “Shahchu apt ahgk hiwigi g Jiawul mat am pad haꞌichu hab juh m‑ihbdag ed. Pt heg hekaj iattogi g Hekia S‑apꞌekam Gewkdag mapt heg wepogi mo id d wehs g haꞌichu m‑eniga namkig. ");
INSERT INTO oodNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Hegai haꞌichu m‑eniga o d m‑eniga mapt koi gagda. Pt am i gagda. K hegai namkigaj d m‑lialiga. Pt eda hab juh ihda si geꞌe pi apꞌekam. Pi apt ahchim waꞌi chum t‑iattogi mach d wabsh oꞌodham. Jiosh apt ep chum iattogi.” ");
INSERT INTO oodNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","T am wabsh i chum kaiok ihda g Ananias k muhk k i gei. ");
INSERT INTO oodNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tsh ab hahawa i wahp g wechij oꞌodham k am i apꞌech g chuhkugaj k ged hu cheh. ");
INSERT INTO oodNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Sh am ep s‑mahch g wehmaj kihkam g muhki matsh hab masma wo chum ha iattogi. Sh am d i waik ohla. Kutsh eda pi koi kah mat has e juh k hekaj am jiwia mo am daha g Peter. ");
INSERT INTO oodNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Kush heg ab wui hab kaij, “Namt haꞌakia ui g lial mamt gagda g haꞌichu e‑eniga?” Sh hab kaij, “Heuꞌu, haꞌakia att ui.” ");
INSERT INTO oodNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Sh hab kaij g Peter, “Ms haschu ahgk hig ahpi g e‑wehm kihkam wehm hab chum i e taht mamt wabsh wo piꞌich g Hekia S‑apꞌekam Gewkdag? Dada at hegam mat ged hu cheh g m‑wehm kihkam. Pegih, t hab waꞌap masma hab wo m‑juh.” ");
INSERT INTO oodNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tsh am ha hekaj muhk k i gei wecho. Tsh ab i wahp g wechij oꞌodham k am nei matki muh k gam hu i be k ged hu cheh hugidaj an g wehmaj kihkam. ");
INSERT INTO oodNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tsh wehsijj ab si s‑ehbeni g Jesus ihmdam ch hegam ehp mo hedai i kah ihda. ");
INSERT INTO oodNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kush s‑hasig haꞌichu s‑ta neidamam hab junihim g Jesus chuhchai am ha shahgid g hemajkam. Sh wehsijj si s‑ap e hehemapad hegam Jesus ihmdam heg wecho Solomonbad watto. ");
INSERT INTO oodNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Sh g hemajkam ab si has ha elid ch wabshaba si s‑e gihug mat ab wo i ha wehmt. ");
INSERT INTO oodNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tsh oi wa muꞌi ab i s‑wohoch g haꞌichu ha‑ahga ab amjed g Jesus k ab i ha wehmt. Haꞌi d chechoj ch haꞌi d uꞌuwi. ");
INSERT INTO oodNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kumtsh am i ha wuwhas g kokꞌodam am i neidok mo haschu has junihim g Jesus chuhchai k an kahya oidk ha wahpakusch hab elidch mat chum hems g Peter ehkadag ab hab wo e juh ha ab mat wo e dodaj. ");
INSERT INTO oodNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Muꞌijj atsh ab aꞌaijed i hihi Jerusalem wui ab i ha uꞌuk g e‑kokꞌodamga ch hegam mo g jijawul an ha uꞌukch. Kutsh wehs ha dodaj. ");
INSERT INTO oodNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tsh g uhgchu pahl ch hegam mash hab waꞌap am oid g Sajusi himdag si s‑koꞌokam s‑ha hehgam g Jesus chuhchai ");
INSERT INTO oodNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","k am i ha cheha g geꞌe cheopi nuhkuddam mat wo ha kuh. Tsh wa woho am ha kuh. ");
INSERT INTO oodNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tsh wabshaba heg i s‑chuhugam ab g anghil am si kuhpiꞌo g kukpaikud k ab i ha wuwhas g Jesus chuhchai k hab ha ahg, ");
INSERT INTO oodNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Am g wo uhpam hihim k am wo i gegokiwua geꞌe cheopi ch ed k wo ha ahgi g hemajkam mat has masma wo bei ihda pi ha huhugedam doakag.” ");
INSERT INTO oodNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kutsh ab wohog elid k am hihim k am i wahp geꞌe cheopi ch ed mat wabsh i chum mahsi k am ha hekaj i ha mashcha g hemajkam. Tsh eda heg waꞌi siꞌalim g uhgchu pahl ch hegam Sajusi am i ha hemapai g e jehnigiddam. Sh idam pi mahch mat haschu has e juh ch atsh am ha cheha g nuhkuddam mat ab wo i ha ui g ha‑lilsoga. ");
INSERT INTO oodNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kutsh am chum hihi g geꞌe cheopi nuhkuddam mat wo ha ui. Kush pi am hu haꞌichug. Tsh ab wabsh uhpam hihim k am ha ahgid ch hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“M att dada kukpaikud am k am chum nei. K ab wabsh kia yahwidag. K g lilso ha nuhkuddam ab ep gegok kihjeg t ab. Tt wabshaba am i chum kuhpiꞌo g kihjeg. K pi am hu hedai haꞌichug.” ");
INSERT INTO oodNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tsh am i ha kaiok am wabsh i pi amich mas hebai has e juh g ha‑lilsoga. ");
INSERT INTO oodNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tsh am hahawa hema i wahk k hab kaij, “Nehꞌe! Idani o ged hu ha mashcham g hemajkam geꞌe cheopi ch ed hegam mamt wa ha kuh.” ");
INSERT INTO oodNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tsh am hahawa hihi g geꞌe cheopi nuhkuddam k ab uhpam wabsh s‑ap i ha ui nat pi am hu wo ha maꞌichshul g hemajkam ");
INSERT INTO oodNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","k am ha uꞌapa ha wui g e jehnigiddam. Sh hab ha ahg g uhgchu pahl, ");
INSERT INTO oodNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Chum ach s‑gewkam pi em‑hiwgid mams an hu wo aꞌagad hegai Jesusbad. T eda g em‑mashchamadag ab amjed heki hu wehsko chehmo g Jerusalem. Kum ahpim ab chum t‑abchud g muhkigaj.” ");
INSERT INTO oodNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","32","Sh hab kaij hegam Peter, “K wabshaba g Jiosh am t‑ahgid matt am wo wa ahgahid ihda mach haschu i si t‑wuhpuikaj neid. Kutt hemho wo wa i hehgch g Jiosh, pi wabsh g oꞌodham. Ahpim amt bei g Jesus k hab juh mat ab e naggia kots t ab k e muhkid. T wabshaba g Jiosh ab uhpam i wuhshad muhkig amjed k am i wahki dahm kahchim ch ed k an i kei si e‑hugid an k ab i mah g gewkdag mat wo t‑doꞌibia k wo t‑wanimedad. Kut heg ab i t‑mah g apꞌedag ahchim Tutuligo hemajkam matt gam hu wo s‑ohhod g pi ap t‑chegitoi. T hekaj g Jiosh gam hu hab wo i juh g pi ap t‑chuꞌijig. Jiosh at ab cheha g Hekia S‑apꞌekam Gewkdag mat wehs wo t‑wehmajk ahchim mach ab s‑wohog elid ch am t‑gahi wuhshanim wo wohokamch g Jesus.” Neh, bash kaij g Peter. ");
INSERT INTO oodNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tsh wabsh wohoꞌi babgat hegam e jehnigiddam k wabsh chum s‑ha kokdaimk. ");
INSERT INTO oodNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sh wabshaba am da hegai mash d Gamaliel ch d chehanig ha mashchamdam ch am oid g Palasi himdag. Sh wehsijj ab si has elid g hemajkam. Kutsh am i kekiwua k am ha ahgi mat gm hu wo shaꞌi i ha wuwhas g e‑lilsoga. Tsh wa woho hab ha juh. ");
INSERT INTO oodNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Sh hab hahawa kaij ihda ab ha wui g e jehnigiddam, “Ni‑hajuni, am g wo s‑e nenꞌoidk mamt has wo ha juh idam oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Hekid o hu i mat am hema i e maskogid k hab chehgig Theudas ch hab kaij mo d ge haꞌichu s‑mahchim. Kut am hu i giꞌik siant chechoj ab i wehmt. T wabshaba e muhkid ihda. T wehsijj e gantad hegam mat wa ab wehmt. T am waꞌi huhug g ahgaj. ");
INSERT INTO oodNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","T amjed am hema ep i e maskogi eda mat g hemajkam e kuint k hab chehgig Judas ch am Galilee t am d oꞌodham. T ihda hab waꞌap muꞌi oꞌodham am i oi. T wabshaba hab waꞌap e muhkid hegai Judas. T hab waꞌap aꞌai e gantad hegam mat wa ab wehmt. ");
INSERT INTO oodNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Pegih, k hemuch hab wa mahs haꞌichu. Pi g am hu has wo shaꞌi ha juhni idam oꞌodham. Ha g wo dagito. Hemu at wo huhug ihda haꞌichu hab ha‑juni matp d wabsh wo oꞌodham hab ha‑elidak. Tp d wo sha Jiosh haꞌichu hab junik, mt pi wo shaꞌi e nako mams wo keshwua. ");
INSERT INTO oodNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mtp hems heg wabsh wo e wepogi mam g Jiosh wabsh cheggia.” Tsh oi wa ab i s‑wohog el g Gamaliel idam e jehnigiddam ");
INSERT INTO oodNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","k hab ha ahg g geꞌe cheopi nuhkuddam mat am wo i ha wahpki g lilso k wo ha gewitta. Tsh wa woho hab e juh. Kutsh ab ep si ha ahgi mat pi am hu wo shaꞌi aꞌagad g Jesus k hahawa ha dagito. ");
INSERT INTO oodNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kush wabsh si s‑hehgig idam Jesus chuhchai am i wuwhak natsh pi ab si has i ha el g Jiosh k ab i ha mah g apꞌedag matsh si e shoꞌigch wehhejed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pi atsh shaꞌi haꞌasa aꞌaga g Jesus k wabshaba wehs tashkaj am wabsh i ha mashcham g hemajkam geꞌe cheopi ch ed ch am ha‑kihki ed mo g Jesus d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kush am i muꞌidahim hegam mash am oid g Jesus himdag. Sh am haꞌi neneok g Greek hemajkam ha‑neꞌokikaj nash pi tash gam hu kihkahim ha‑jewedga ed. Kush idam hab kaij mash pi ap ha dagioꞌid hegam heheꞌejel wiꞌikam uꞌuwi mash d ha‑hajuni. Kush heg hekaj am aꞌai pi e apꞌet idam Greek neneokdam ha wehm hegam mo g hejel e‑neꞌokikaj neneok. ");
INSERT INTO oodNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tsh am i kah g Jesus chuhchai k am wehs i ha hemapad k hab kaij, “T‑wepnag, pi o apꞌe machs wabsh wo dagito g mihshmda ab amjed g Jiosh k im hu g lial wo hudawogad. ");
INSERT INTO oodNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ab oki haꞌi ep em‑mahkch g Jiosh g gewkdag ch amichudadag mamt am hab wo junihid ihda chikpan. Pegih, mt am wewaꞌak wo i ha gawulkai hegam mam s‑ha mahch mo woho hab masma. Kutt idam am wo i ha chuhcha mat wo nuhkud ihda hab mahs haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tt ahchim Jesus chuhchai am hab wo si i juh matt wo t‑hoꞌigeꞌidahunad ch wo si ha mihshmdad g hemajkam.” Neh, bash kaij. ");
INSERT INTO oodNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kumtsh ab si i s‑hohhoꞌi mo has kaij k am wewaꞌak i ha chuhcha. Hema idam ash hab chehgig Steven ch ab si s‑gewkam hiwig g Jesus. Sh g Hekia S‑apꞌekam Gewkdag ab si mahkch g gewkdag. Kush hegam haꞌi ehp hab chechgig Philip ch Prochorus ch Nicanor ch Timon ch Parmenas ch Nicolaus. Ihda Nicolaus ash ab d amjedkam g Antiok kihhim ch d gawul mahs oꞌodham ch ab i s‑wohoch g Tutuligo ha‑himdag eda mat koi s‑mai ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tsh idam ab hahawa i ha ui g hemajkam ha wui g Jesus chuhchai. Kutsh idam am e hoꞌigeꞌidahun k ab ha taht mat heg hekaj wo s‑e mahchk mo d si ha‑chuhchai. ");
INSERT INTO oodNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tsh am si i geꞌeda g Jiosh haꞌichu ahga Jerusalem t am. Kutsh baꞌich i muꞌida hegam mash am oid g Jesus himdag. Tsh muꞌijj ab i s‑wohoch hegam mo d papal Tutuligo ha‑himdag ed. ");
INSERT INTO oodNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ab ash si s‑hoꞌigeꞌid g Jiosh g Steven ch ab si i mahkch g e‑gewkdag. Kush s‑hasigam haꞌichu hab wua. ");
INSERT INTO oodNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tsh wabshaba haꞌi ab wui gegokiwua mash am hebai e wehm e mihshmad g Tuhligo e‑himdag. Haꞌi idam ash d neneholkahim Cyrene ch Alexandria kihhim t am. Tsh am haꞌi i ha wehmt ab Cilicia jewed t amjed ch haꞌi ab Asia jewed t amjed. Sh idam ab kamꞌon g Steven ");
INSERT INTO oodNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sh wabshaba g Hekia S‑apꞌekam Gewkdag ab si mahkch g Steven g amichudadag. Kutsh pi shaꞌi e nako hegam mas ab uhpam wo i nodagi g neꞌokij. ");
INSERT INTO oodNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","k heg hekaj am hahawa haꞌi ha namkid k am ha ahgid mat hab wo chei, “Kah ach ihda mo si has ahg hegai mo ab t‑chehani g Jiosh Mosesbad oꞌohana ed.” ");
INSERT INTO oodNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kush wa woho hab kaij idam ch hekaj i ha kudu g hemajkam ch geꞌeged ch chehanig ha mashchamdam. Tsh idam wabsh woho i babgat k am hihim k an bei g Steven k ged hu uꞌapa ha wui g e jehnigiddam. ");
INSERT INTO oodNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mtsh am hahawa haꞌi i ha wahpki g oꞌodham matsh am haꞌichu wo ha iattogi ab amjed. Sh hab kaij idam, “Ihda oꞌodham o chum hekid has ahg g hekia s‑apꞌekam geꞌe cheopi ch hegai mo ab t‑chehani g Jiosh Mosesbad oꞌohana ed. ");
INSERT INTO oodNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kah ach mo hab kaij mat hegai Jesusbad wo i wua g geꞌe cheopi k wo gawul juh g t‑himdag mach ga hu hebai amjed hab i junihim mat g Mosesbad an oꞌoha.” ");
INSERT INTO oodNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kush wehsijj ab si neid g Steven. Sh g wuhioshaj hab haha wabsh mahs matp hems g anghil wuhiosha nash pi si tonod. ");
INSERT INTO oodNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kush hab kaij g uhgchu pahl ab wui g Steven, “No am wa woho map hab junihim hegai mo haschu ab m‑abchud?” ");
INSERT INTO oodNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kush hab kaij g Steven: “Ni‑geꞌegedga ch ni‑hajuni, ab g wo si i ni‑kaiham. An o oꞌohadag matsh g Jiosh ab wui e chehgi g t‑shohshonbad Abraham. Kush eda am wabsh kia kih Mesopotamia jewed ch ed. ");
INSERT INTO oodNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Sh hab kaij g Jiosh ab wui: Ia g wo ha dagito g e‑hajuni ch e‑jewedga k ab wo hihi heg wui jewed mant am wo m‑chehgi. ");
INSERT INTO oodNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Tsh wa woho am dagito g Mesopotamia jewed mash am kih g Caldea hemajkam k am chihpia Haran kihhim wui. Kutsh am i muh g Abrahambad ohgbad. Tsh ab hahawa ep cheha g Jiosh mat ia wo chihpia Canaan jewed wui. Kutsh ia i chiwia mach hemuch ia kih. ");
INSERT INTO oodNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Tsh eda koi ab hu heꞌes shaꞌi mah ihda jewed k wabshaba am hi wa ahgid mat wo mah. T d wo ha‑enigak g amjedkamaj mat heꞌekiajj ab wo i oi. Kush eda pi koi ha aꞌaliga g Abrahambad mash eda hab ahg g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Kush hab kaij g Jiosh ab wui: M at hu wabsh heb hu jewed ch ed wo kihk g m‑amjedkam ch d wabsh wo ha‑pionagk. Kumt wo ha shoꞌigch giꞌik siant aꞌahid ab. ");
INSERT INTO oodNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nt wabshaba wo ha kastigal hegam hemajkam mat an wo ha uꞌukchid. T ab haha wo i wuwha heg amjed jewed k ab wo si has i ni‑elid k wo ni‑ihm iia. Neh, bash kaij g Jiosh ");
INSERT INTO oodNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ch ab mah g Abrahambad hegai himdag mat am wa has masma wo ha oꞌoha an ha hikuchk g chechoj e‑aꞌaliga. Tsh hab masma wo s‑mahchk mash hab waꞌap d ha‑wuikam hegai matsh g Jiosh am ahgi g Abrahambad. Tsh wa woho hab e juh g Abrahambad k an pahl hikuch g e‑alidag Isaacbad mo d i gigiꞌik tash amjed mat mahsi. Tsh g Isaacbad hab waꞌap juh g e‑alidag Jacobbad. Tsh g Jacobbad hab waꞌap ha juh hegam gamai gohk e‑aꞌalidag mach ab d ha amjedkam. ");
INSERT INTO oodNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Tsh idam wa s‑hehgam g e‑wehnag Josephbad k ab haꞌi ha wui gagda mat d wo ha neholigak am Egypt jewed ch ed. Sh wabshaba g Jiosh am nuhkud ");
INSERT INTO oodNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ch ab s‑ap i wuhshad wehs haꞌichu shoꞌigdaj amjed k ab i mah g si oꞌodhamdag ch amichudadag. Tsh am i nei g ha‑kownalig g Egypt t am hemajkam k am i uhgkajid k am kownalch am dahm g e‑kownaltalig ch haꞌichu e‑eniga. ");
INSERT INTO oodNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Tsh wa haha wabsh gei g bihugig k ha shoꞌigch g hemajkam wehsko Egypt jewed dahm ch iia Canaan jewed dahm. Tsh pi shaꞌi e amich hegam Abrahambad mat hebai wo bei g haꞌichu hugi. ");
INSERT INTO oodNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kush eda am s‑haꞌichu hugig Egypt jewed ch ed. Kutsh am i kah g Jacobbad k am ha cheha g e‑aꞌalidag matsh am wo hunio. Kutsh hab e juh. ");
INSERT INTO oodNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","“Tsh am ep i huhug g haꞌichu ha‑hugi. Kutsh am ep hunio. Tsh g Josephbad am hahawa ha ahgi mo d ha‑wehnag nash pi pi amichud. Tsh g ha‑kownalig g Egypt t am hemajkam ab s‑ha mai g Josephbad hajuni. ");
INSERT INTO oodNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tsh g Josephbad am hahawa wai g e‑ohgbad mat wehsijj ab wo i chihpia Egypt wui. Kush eda d wewaꞌakko gamai hetasp (75) hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tsh wa woho am i chihpia hegam Jacobbad Egypt wui k am kihkahim ch am koi. ");
INSERT INTO oodNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tsh am uhpam i e ui g ha‑ohꞌo g Abrahambad ch Josephbad Shekem kihhim wui. Abrahambad atsh wa am heꞌes ha nolawt g jewed hegam mash d Hamor amjedkam matsh am wo e toa g ha‑koꞌidag. ");
INSERT INTO oodNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Sh amjed muꞌi aꞌahidag wehgaj. Sh e aihim matsh am hab wo juh g Jiosh mash haschu i heki hu ahgid g Abrahambad. Tsh eda am i si muꞌida g t‑shohshonbad amai Egypt ch ed. ");
INSERT INTO oodNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kutsh am hema i wuhsh g kownal mash pi shaꞌi mahch matsh wa has masma am si i ha wehmt g Josephbad amai Egypt ch ed. ");
INSERT INTO oodNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kush ihda nahnko ha wua hegam t‑shohshon ch ha shoꞌigchud ch hab ha ahg mat gam hu wo ha shul g chuꞌuchum e‑aꞌaliga hab ahgch mat wo koi. ");
INSERT INTO oodNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kutsh eda mahsi g Mosesbad k si s‑kehg d ali. Kutsh am i nuhkud g jehjij waik mashad ab ");
INSERT INTO oodNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","k gam hu hahawa i wuhshad. T g kownal uwi alidag am chehg k ab i bei hab masma mo d madaj. ");
INSERT INTO oodNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kumtsh wehs haꞌichu mashcha mo haschu d i si s‑hasig haꞌichu am Egypt ch ed. Tsh ab si i mai ihda wehs k d si s‑has haꞌichu am heg eda mo haschu hab i kaij ch haschu hab i junihim. ");
INSERT INTO oodNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Batsh wa masma am i geꞌeda g Mosesbad k am i ai g giꞌikko wehst‑mahm (40) aꞌahidag. Tsh am hu hebai hab i e ah mat am wo i ha chehgim g e‑hahajuni. ");
INSERT INTO oodNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kush hema g Egypt t am oꞌodham am hema shoꞌigchud g Tuhligo. Tsh g Mosesbad am i wehmt g e‑hajuni k mua ihda Egypt t am oꞌodham mat wo agwua ");
INSERT INTO oodNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","k hab e ahg mat g hajunij wo chum s‑mahchk mat g Jiosh wo hekaj k wo ha doꞌibia. Sh wabshaba g hajunij pi hab masma hab elid haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Sh am baꞌich d i tash, sh am haꞌi e cheggia g Tutuligo. Tsh am ha neid k chum s‑ha daꞌid k hab kaij, ‘Kia, ahpim! Dam e‑wepngam ch eda haschu ahgch e cheggia?’ ");
INSERT INTO oodNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Kut hegai mo ha cheggia ab si nuꞌichkwua g Mosesbad k hab kaij: Shahchu ap ahgch hab chum e wua maps am t‑dahm. Pi o ab hu shaꞌi m‑ab maps ahpi am haꞌichu wo i apꞌechudad am t‑shahgid. ");
INSERT INTO oodNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Napt hab waꞌap wo chum ni‑mua mapt wa hab juh g Egypt t am oꞌodham tako? ");
INSERT INTO oodNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Tsh am i kah g Mosesbad ihda k ha hekaj gam hu i e mehkod ab Egypt amjed k gam hu i jiwia mash am d Midian jewed. Sh am haꞌi oꞌodhamag. Kutsh am ha hohnt k gohk chechoj aꞌalidt ");
INSERT INTO oodNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Sh am him k am d i giꞌikko wehst‑mahm aꞌahidag. Sh am hu hebai ha nuhkud g kahwal g Mosesbad am miabidch hegai doꞌag mo hab e aꞌaga Sinai. Tsh ab wui haha wabsh hema i e chehgi g anghil hab masma mo am meihim g shaꞌi ch eda pi meitto. ");
INSERT INTO oodNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tsh ab i miabi g Mosesbad mat ab si s‑ap wo i nei nash pi pi amichud matsh wa pi shaꞌi meitto g shaꞌi. Sh g Jiosh ab wui hab kaij am gahi wuhshanim g anghil: ");
INSERT INTO oodNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ahni ani d Jiosh. K wa ab has ni‑elid hegam m‑shohshon mo d Abraham ch Isaac ch Jacob. Tsh hahawa si gigiwuk g Mosesbad k si s‑ehbeni mat am wo i nei. ");
INSERT INTO oodNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Sh hab ep kaij g Jiosh ab wui: Ab g has i ni‑elid k wuashulig g e‑kaikia shuhshk nap pi ia kehk ni‑wui. ");
INSERT INTO oodNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","S‑mahch ani mam has i masma ha shoꞌigchud g m‑hajuni amai Egypt t am. Do ni‑hemajkamga. Kuni kah g ha‑shoshaki ch heg hekaj am i ni‑maskogi ab m‑wui mapt ahpi wo ha doꞌibia. Pt oi am wo i e nako mapt am wo hih Egypt wui. Neh, bash kaij g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kuni hab ep s‑cheꞌimk mo ihda Mosesbad d hegai matsh wa g hajunij pi ab hu tatchua ch hab kaij: Shahchu ap ahgch hab chum e wua maps am t‑dahm? Pi o ab hu shaꞌi m‑ab maps ahpi am haꞌichu wo i apꞌechudad am t‑shahgid. Do wa ihda Mosesbad matsh g Jiosh am i kei ha dahm g hajunij matsh wo ha wanimed k wo ha doꞌibia. Kutsh hegai anghil mash ab neok mei ch ed am uꞌapa g Jiosh neꞌoki Mosesbad wui. ");
INSERT INTO oodNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kutsh g Mosesbad am uhpam hih Egypt wui k am hab juh g s‑hasig haꞌichu chehgida k am i ha wanim g e‑hajuni mat ab i wuwha Egypt amjed. Kutsh wa am i e tahp hegai mash hab e aꞌaga Al S‑wegi Kahchki. Tsh am gahi i shul idam Mosesbad k am chipiahim giꞌikko wehst‑mahm ahidag oidam tohono jewed ch ed. “Sh g Mosesbad heg oidam s‑hasigam haꞌichu am hab junihim ");
INSERT INTO oodNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ch am ha ahgid ch hab kaij: Jiosh atsh am hema ep wo i kei g t‑hajuni hab masma mat ahni am i ni‑kei. Kut heg d ep wo Jiosh haꞌichu i tashogiddamk. Neh, bash kaij g Mosesbad. ");
INSERT INTO oodNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tsh g Jiosh ab mah g e‑neꞌoki doꞌag t ab am gahi wuhshanim g anghil. K d t‑himdag ihda neꞌoki matsh ab bei. ");
INSERT INTO oodNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Tsh pi oi jiwia g Mosesbad ab doꞌag t amjed. Tsh g t‑shohshonbad pi ab hu wohog elid k im hu hab wabsh i s‑junimk g Mosesbad ch uhpam s‑hihimimk am Egypt wui ");
INSERT INTO oodNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Sh g ha‑uhgchu pahlig d Aaronbad. Sh idam ab wui hab kaij: Pi ach mahch mas has e juh ihda Moses mat ab i t‑wuwhas Egypt amjed. Am g wabsh haꞌi ha nahto g jijosh mat hegam am wo t‑wanimedad. ");
INSERT INTO oodNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Kush wa am hema wisilot g ohlakaj k ab wui iagchul heg wepogidch mo d ha‑jioshga k am ep piast mat heg hekaj ab wo si i haꞌichuch hegai e‑jioshta. ");
INSERT INTO oodNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kutsh heg hekaj im hu hab i e juh g Jiosh ab ha amjed k am wabsh ha hiwigi mat wabsh g hejel hab e‑elida am hab wo junihid. Kush wabsh g huhuꞌu ab ha ihm mat hab masma an oꞌoha g Jiosh haꞌichu i tashogiddam mash hab kaij g Jiosh: Ab ani ha chehani g Tutuligo hemajkam mat wo mumꞌa g e‑shoshoiga k ab ni‑wui wo iagchul am wehhejed g pi ap e‑chuꞌijig. K wabshaba pi woho ab hu ni‑ihm mo eda am haꞌichug tohono jewed ch ed giꞌikko wehst‑mahm ahidag oidam. ");
INSERT INTO oodNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Do hejel ha‑nahtoi jijosh mo ab ha ihm. Bo ha aꞌaga Molok ch Rephan ch hab ha elid mo an kih huhuꞌu t an. Nt heg hekaj gam hu mehk wo em‑shul Babylon jewed t am. Neh, bash kaij g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Kuni hab ep s‑cheꞌimk mash hegam an uꞌahim hegai cheopi mash heg hekaj am ha tashogid g Jiosh mash am ha wehmaj. Sh heg d wabsh hogi ch hab masma e nahto matsh wa g Jiosh am chehgi g Mosesbad. ");
INSERT INTO oodNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Sh g ha‑amjedkam an ep uꞌahim hegai cheopi matsh hekid g Joshuabad am i e kei matsh wo i ha wanim. Kutsh g Jiosh ia i ha wahpki id eda jewed k am ha wehhejed gam hu i ha wuwhas hegam nahnko mahs hemajkam mo ia d chum kihkam. Kush am haꞌichugkahim ihda cheopi ch ab ai mash eda g Davidbad d ha‑kownalig. ");
INSERT INTO oodNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Sh ihda Davidbad d si Jiosh tatchui ch ab ahgid mat wo hiwigi mat hema wo kihch. Tsh heg eda am hab wo e junihid g hoꞌigeꞌidahuna Jiosh wui. ");
INSERT INTO oodNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kutsh g Jiosh hiwigi g alidaj Solomonbad. Tsh heg am i kei g kih am wehhejed g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“K eda g Jiosh baꞌich i geꞌej mo haschu i mo an hab chuꞌig t‑wehgaj. T pi wo shaꞌi e nako g oꞌodham mas wo kihch. Batsh wa masma an oꞌoha g kelibad Jiosh haꞌichu i tashogiddam mash hab kaij g Jiosh: ");
INSERT INTO oodNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ahni ani d Jiosh ch ab dahm kahchim t amjed ia nuhkud g jewed kahchim. Pi amt wo shaꞌi e nako mamt wo ni‑kihch mamt heg eda am wo ni‑dai ");
INSERT INTO oodNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","nant pi ahni wehs haꞌichu nahto. Neh, bash kaij g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","52","“Kush wabshaba g t‑shohshonbad si e sheshemachud ch pi chechkaidag ch pi ab hu kaiham g Jiosh haꞌichu ahga. Jiosh ash am i ha wuwhasid g haꞌichu i tashogiddam. Kush wa g t‑shohshonbad ha shoꞌigchud ch haꞌi ha kokda. Kum ahpim hab waꞌap chuꞌig ch ab wabsh wui gegok g Hekia S‑apꞌekam Gewkdag. Jiosh haꞌichu i tashogiddam ash am ahgachug mat wo jiwia g Jiosh si pionag k d wo si wehs s‑apꞌekamk. Kut wa woho jiwia. Kumt wa gagda mat wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ahpim amt ab em‑mah g Jiosh chehanig mat wa g anghil ia uꞌapa. Mt eda am wa pi wohoch.” Neh, bash kaij g Steven. ");
INSERT INTO oodNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tsh am i kah g e jehnigiddam mash has ha ahg g Steven k wabsh wohoꞌi babgat k si kuhm g e‑tahtami. ");
INSERT INTO oodNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sh wabshaba g Hekia S‑apꞌekam Gewkdag ab baꞌich i si mahkch g Steven g gewkdag. Tsh am i nea dahm kahchim wui k nei mo si s‑masma tonod g Jiosh gewkdag. Kush g Jesus an si hugidaj an kehk g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kush hab kaij g Steven, “Neido! B at e kuhpiꞌo g dahm kahchim. K ab kehk g Jiosh si Kehsha an si s‑apko hugidaj an g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tsh si hihinkiad k am si kuhkp g e‑nahnk k ab hahawa si wui i wohp ");
INSERT INTO oodNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","k an be k gam hu i wuhshad kihhim t amjed mat wo maꞌichkwua. Sh am hema ha wehmaj g wechij oꞌodham ch hab chehgig Saul. Kutsh heg nuhkudach g e‑liliwa hegam matsh wo maꞌichkwua g Steven. ");
INSERT INTO oodNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kush g Steven ab si ihm g e‑doꞌibiakam ch hab kaij, “Ni‑kownalig Jesus, ia g behꞌi ni‑doakag.” Sh eda heg oidch ab maꞌikkash g s‑kehꞌiddam. ");
INSERT INTO oodNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tsh am hahawa tohtonwua g Steven k si s‑kaidam hab kaij, “Ni‑kownalig, pi g ab hu ha abchud ihda chuꞌijig mat ihab e juh.” Bash kaij ch am i muh. ");
INSERT INTO oodNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sh g Saul am wabsh apꞌechud mamt mua. Sh amai i amjed mamtsh ab si s‑gewkam i ha shoꞌigch g Jesus ihmdam amai Jerusalem t am. Kutsh aꞌai ahhio g e shoꞌigchuddam amai Judea ch Samaria chechkshani ch ed. Tsh wabshaba hegam Jesus chuhchai pi hasko ahhio. ");
INSERT INTO oodNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tsh haꞌi hegam mo ab d si ihmdam g Jiosh ged hu cheh g Steven k si s‑kaidam shoani wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kush g Saul chum s‑padchudamk g ha‑mihshmda g Jesus ihmdam ch hekaj an wahkhim ha‑kihki oidch ch ab i ha chewaimed ch ged hu si ha kuhpahim, chum wa g uꞌuwi. ");
INSERT INTO oodNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kush wa an wehsko ahgahim g Jesus hegam matsh wa e gantad. ");
INSERT INTO oodNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Hegai Philip mash wa am d ha‑kehsha atsh am hih Samaria kihhim wui k am ha mihshmad ch am ha ahgid mat heki hu an i wuhsh g Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kush ab si kaiham hegam hemajkam mo haschu i ha ahgid ch am neid mo s‑hasigam haꞌichu hab junihim g Jiosh gewkdagkaj. ");
INSERT INTO oodNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Muꞌijj ash e dodajid hegam mash g jijawul an ha uꞌukch. Kush si hihnk g jijawul gam hu hihimadch. Kush muꞌijj ha dodajid hegam mo pi hihimdag ch hegam mo pi ab hu gewpk. ");
INSERT INTO oodNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Sh si s‑hehgig g hemajkam amai. ");
INSERT INTO oodNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Sh am hema kih g oꞌodham mash hab chehgig Simon ch heki hu waꞌi amjed am hab junihim g s‑hasigam haꞌichu ch hab chum e wua mo d ge mahkai. ");
INSERT INTO oodNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kush wehs g hemajkam am si neidachug ch ab si has elid, chum wa hegam mo d s‑chu aꞌamichuddam. Kush wehsijj hab kaij, “Heg oki d ge mahkai ch ab uꞌukch g e‑gewkdag Jiosh t amjed.” ");
INSERT INTO oodNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bash kaij ch ab si kaiham nash pi heki hu waꞌi amjed hab junihim g s‑hasigam haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tsh wabshaba am hahawa ha mihshmad g Philip ab amjed g Jiosh kownaltalig ch ab amjed g Jesus Christ. Kutsh ab i s‑wohochud k e pahl wapko. ");
INSERT INTO oodNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tsh hab waꞌap ab i s‑wohoch g Simon k e pahl wakon k amjed pi hebai dagito g Philip k ab si has elid am i neidok mo hab junihim g s‑hasigam haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tsh am i ha ai hegam Jesus chuhchai ab Jerusalem t ab matsh idam Samaria t am oꞌodham ab bei g Jiosh haꞌichu ahga. Kush am ha chehani g Peter ch John matsh am wo ha mihshmedo. ");
INSERT INTO oodNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Tsh am hihi idam k ged hu dada k am ha wehm e hemapai. Kutsh eda pi koi bei g gewkdag ab amjed g Hekia S‑apꞌekam Gewkdag hegam matsh e pahl wapko. Kutsh am e hoꞌigeꞌidahun k ab tai g Jiosh mat hab wo wa e juh am ha tahgio ");
INSERT INTO oodNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","k amjed an i ha tahtamahi ab ihmch g Jiosh. Tsh g Hekia S‑apꞌekam Gewkdag ab hahawa ha mah g gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tsh g Simon am i nei ihda k chum s‑ha namkidam ");
INSERT INTO oodNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","k hab kaij, “Ab g i ni‑mahki ihda gewkdag mant hedai ab wo i taht, t wo bei g gewkdag ab amjed g Hekia S‑apꞌekam Gewkdag.” ");
INSERT INTO oodNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Sh wabshaba hab kaij g Peter ab wui, “T wabsh wo huhug g s‑m‑kaischuda hab wa masma mapt ahpi wo huhug. Pi o hab chum chuꞌig mapt hekaj wo nolawt g Jiosh mahkigdag. ");
INSERT INTO oodNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Pi o shaꞌi apꞌe g m‑chegitoi am Jiosh tahgio. K heg hekaj pi ab hu d shaꞌi m‑wuikam ihda chikpan. ");
INSERT INTO oodNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Gan o hu wabsh i si m‑uꞌukch g pi apꞌekam napki pi s‑chu hehgamk. Pt gam hu wo s‑ohhod g pi ap e‑chegitoi k ab wo i e hoꞌigeꞌidahu Jiosh wui. Tp hems gam hu hab wo i juh g m‑chuꞌijig.” ");
INSERT INTO oodNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sh hab kaij g Simon ab ha wui, “Ab g wo si i s‑ni‑hoꞌigeꞌid k am wo e hoꞌigeꞌidahu Jiosh wui ni‑wehhejed mat pi gam hu hab wo ni‑juh.” ");
INSERT INTO oodNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tsh am hahawa ha mihshmad g Peter ch John ab amjed g Jesus k am ha ahgi mo haschu g e‑wuhpuikaj neid. Tsh am hebai i cheka. Kutsh gam hu uhpam hihi Jerusalem wui am ahgachugch g s‑kehg haꞌichu ahgaj g Jiosh am aꞌai kihhim ch ed heg eda Samaria chekshani. ");
INSERT INTO oodNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kush g anghil am hema neok ch hab kaij ab Philip wui, “Am g i e nakog k gam hu hihm k am wo i ai hegai wohg m an hims tohono jewed ch ed am ha shahgid g Jerusalem ch Gaza.” ");
INSERT INTO oodNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Tsh wa woho am i e nako g Philip k gam hu hih. Sh eda am hema med g e‑kalitkaj ch d Ediopia jewed t am oꞌodham. Id ash g kownaligaj am kehshch mash d lial nuhkuddam. Kush am e mihshmdahim Jerusalem t am ch hemu am uhpam ep wo chihpia Ediopia wui. ");
INSERT INTO oodNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kush hab kaij g Hekia S‑apꞌekam Gewkdag ab wui g Philip, “An g i miabid hegai kalit k gan hu hugidaj an wo i hih.” ");
INSERT INTO oodNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tsh am hahawa si meh g Philip k an i miabi g kalit. Kush ihda am neꞌokchulid hegai matsh g Isaiabad an oꞌoha. Kush am kah g Philip ch ab kakke, “Nap s‑amichud hegai map an neꞌokchulid?” ");
INSERT INTO oodNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Sh hab kaij ihda s‑has haꞌichu, “Pi ant has masma wo s‑amich, heg hi wa matp am hema wo i ni‑tashogi,” ch amjed ab i wai g Philip mat gan hu wehmaj wo dahiwua kalit ch ed. T wa woho an i chesh. ");
INSERT INTO oodNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kush eda id an neꞌokchulid mo hab chuꞌig an Jiosh oꞌohana ed: T am hema wo i wuhsh g oꞌodham mat wo e wepogi g kahwal. Neh, pi at wo shosha g kahwal mamt hekid wo shoꞌigchud k wo mua. Pegih, t hab wa masma pi has wo shaꞌi chei ihda oꞌodham ");
INSERT INTO oodNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","mamt hekid pi ap wo lodait k wo mua. T hab pi hedai wo e nako mas wo ah Mamt heꞌes i geꞌe pi apꞌekam hab juh ab wui. ");
INSERT INTO oodNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Sh hab kaij g s‑has haꞌichu ab Philip wui, “Am g ni‑ahgid. Dohꞌo hab ahg g Jiosh haꞌichu i tashogiddam? No hejel hab e ahg aha no wabsh hema hab ahg?” ");
INSERT INTO oodNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tsh g Philip amjed am i shonch id ab mash am neꞌokchulid k am ahgid g s‑kehg haꞌichu ahga ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Sh am wabsh kia wohpo wohg oidch ch am hu hebai neꞌibij mash am ge shuhdagi. Sh hab kaij g s‑has haꞌichu, “Neh, m ia ge shuhdagi. No am hig haꞌichu ehp manis heg hekaj pi wo ni‑pahl wako?”  ");
INSERT INTO oodNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Sh am hahawa ahgid g Philip, “Bapt waꞌi masma wo e pahl wako mapt wehskaj am wo i e dagito Jesus wui.” Sh hab kaij, “Heuꞌu, wehskaj ant am wo i ni‑dagito wui.” ");
INSERT INTO oodNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Sh am hahawa i ahgid hegai e‑pionag mo melchudahim g kalit mat wo keshwua. Tsh am huhud ab kalit t ab k am i huhud shuhdagi ch ed. Tsh am pahl wako g Philip ihda oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tsh g Hekia S‑apꞌekam Gewkdag gam hu wa hekaj i bei g Philip. Sh amjed si s‑hehgig ihda s‑has haꞌichuch gam hu uhpam meh pi hekid ep shaꞌi neidk g Philip. ");
INSERT INTO oodNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tsh g Hekia S‑apꞌekam Gewkdag gam hu uꞌapa g Philip Ashdod kihhim t am. Tsh am i ahgahi g haꞌichu ahga ab amjed g Jesus k ga hu ai g Cesaria kihhim. ");
INSERT INTO oodNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kush eda id oidam g Saul wabsh kia ha oid hegam mash am oid g Jesus himdag ch s‑gewkam ha ebkiod ch s‑ha kokdaimk. Sh am hu hebai i, sh ab si tahni g uhgchu pahl ");
INSERT INTO oodNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","matsh am wo ha oꞌohani g papal am Damascus kihhim t am. Kutsh heg wo be k am wo him k wo ha chehgi. Tsh hegam wo s‑mahchk mo uꞌukch g e‑apꞌedag. Kutsh wo ha ui hegam mo am oid g Jesus himdag k am wo uhpam i ha ui Jerusalem wui, chum wa g uꞌuwi. Tsh wa woho hab e juh g uhgchu pahl. ");
INSERT INTO oodNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tsh am hih g Saul haꞌi ha wehm g chechoj k gam hu i aihim g Damascus kihhim. Tsh haha wabsh haꞌichu si ton ab dahm kahchim t amjed an wehgaj. ");
INSERT INTO oodNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tsh am i gei g Saul jewedo. Sh ab hema si neok ab dahm kahchim t amjed ch hab kaij, “Saul, s‑wohom ap hig ni‑shoꞌigchud.” ");
INSERT INTO oodNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sh si has elid g Saul ch hab kaij, “Dohp wud ch ab neok?” Kush hab kaij hegai mo ab neok, “Dani ahni Jesus. Kup ha shoꞌigchud hegam mo am oid g ni‑himdag. ");
INSERT INTO oodNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ab g i wamig k am hihm k am wo i wah Damascus ch ed. T am haha wo hema m‑ahgi mapt haschu am hab wo chum juh.” ");
INSERT INTO oodNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tsh hegam mo am wehmaj ab wabsh i gewpka k pi has shaꞌi kaij ch ash hi wa kah g neꞌoki ch wabshaba pi shaꞌi neid mas hedai ab neok. ");
INSERT INTO oodNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tsh am hahawa i wami g Saul k ab chum si i nea. Tsh wabshaba pi ab hu mamsi g wuhpuij. Kumtsh am haha wabsh i wanimed k ged hu uꞌapa Damascus ch ed. ");
INSERT INTO oodNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kush waik tashkaj pi haꞌichu shaꞌi neid ch ep pi haꞌichu shaꞌi koꞌa ch pi haꞌichu ihꞌe. ");
INSERT INTO oodNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kush eda am hema d Jesus ihmdam amai ch ash hab chehgig Ananias. Tsh g Jiosh am haꞌichu hab juh nenaj tahgio mash heg eda g Jesus am chehcheg. Sh g Ananias hab kaij, “Shahchu ap tatchua, ni‑Jioshga?” ");
INSERT INTO oodNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kush hab hahawa kaij g Jesus, “Am g i e nakog k am hihm heg kih wui Judas mo am kih Shelini Kahya oidch. Amai o hema dak ch e hoꞌigeꞌidahun ch hab chehgig Saul ch ab d kihkam Tarsus kihhim t ab. ");
INSERT INTO oodNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Kunt am nenaj tahgio haꞌichu hab juh mapt am wo jiwia wui ahpi Ananias ch ab wo taht mat ep wo mamsi g wuhpuij.” ");
INSERT INTO oodNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Sh hab kaij g Ananias, “Ni‑kownalig, ihda oꞌodham atsh muꞌi ha shoꞌigch g m‑hemajkamga am Jerusalem ch ed. Muꞌijj o hab ni‑ahgid ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kutsh heg hekaj ia jiwia mash uꞌukch g apꞌedag ab ha amjed g uꞌugchu papal mat wo uhpam i ha ui hegam mo ab m‑ihm.” ");
INSERT INTO oodNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kush hab kaij g Jesus ab wui, “Am apt wo wa hih nant pi id am si i kei mat am ni‑wehhejed wo chikp am i ahgahimk g ni‑himdag ha wui g Tutuligo ch am ha wui g nahnko mahs hemajkam ch kokownal. ");
INSERT INTO oodNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nt ahni am wo wa chehgi ihda Saul mat has i masma wo e shoꞌigch am ni‑wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tsh wa woho am hih g Ananias heg wui kih k ab si i s‑ha hoꞌigeꞌel g kihkam. Tsh ab i wahki. Tsh ab hahawa e mahtchul g Ananias Saul wui k hab kaij, “Ni‑nawoj, Saul, am apsh neid g geꞌechu t‑kownalig Jesus ab himadch wohg oidch. T heg ab ni‑cheha mantsh ab wo i him k ab wo m‑taht. Tsh ep wo mamsi g m‑wuhpui. Kutsh ab wo m‑mah g gewkdaj g Hekia S‑apꞌekam Gewkdag.” Neh, bash kaij ch ab hahawa taht. ");
INSERT INTO oodNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tsh ab ha hekaj i mamsi g wuhpuij. Tsh hahawa ep s‑ap haꞌichu neid k am ha hekaj i e nakog k e pahl wakon ");
INSERT INTO oodNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","k ep haꞌichu hug k ab uhpam ep i gewka. Sh g Saul am heꞌekia i tash ha wehmajkahim g Jesus ihmdam amai Damascus t am. ");
INSERT INTO oodNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kush am haꞌi chechopi g Tutuligo. Sh g Saul am ha mihshmad g e‑wehm oꞌodham ab amjed g Jesus am ah ahgidch mo d Jiosh alidag. ");
INSERT INTO oodNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tsh si has i el hegam mo hedai i kah k hab kaij, “Aha no pi d ihda mash an ha kokdahim hegam mash am oid hegai himdag Jerusalem t ab ch heg hekaj ia jiwia mat in wo i ha uꞌihim k am uhpam wo i ha ui uꞌugchu papal ha wui.” ");
INSERT INTO oodNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tsh g Saul mihshmda am i si e gewkai. Kutsh wa wohokamch mo g Jesus d Jiosh si Kehsha. Tsh hekaj pi e nako g wehmaj oꞌodham mat ab hu has wo ah. ");
INSERT INTO oodNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","24","Sh am hu i hebai amjed, tsh g Tutuligo am i e nako matsh wo mua g Saul. K eda si uhgk kolhaitas g kihhim. Kumsh si nuhkud g kihjegaj tash oidam ch s‑chuhugam oidam. Tsh wabshaba s‑mai g Saul mam s‑muꞌamk. ");
INSERT INTO oodNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tsh hegam mat ab i s‑wohoch g Saul haꞌichu ahga ab amjed g Jesus am dai washomi ch ed k ab i huduni chuhug ch ed g wijinakaj ab amjed mash ab hebai ge wintani kolhai t ab. ");
INSERT INTO oodNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tsh amjed gam hu hahawa hih Jerusalem wui k ab chum ha shahgid i s‑wahkim hegam Jesus ihmdam mat ab wo i ha wehmt. Sh wabshaba s‑ehbid ch pi wohochud mas woho pi has wo ha juh ");
INSERT INTO oodNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kush oi wa am wehhejed neok g Barnabas am ha wui g Jesus chuhchai. Tsh hegam hiwigi matsh am i wahki ha shahgid. Sh am ha ahgid mash g Saul am himad ch haha wabsh neid g Jesus amai wohg ch ed ch ep kah mo ab neok. Sh am ep ha ahgid matsh has masma si s‑gewkam am i ha mihshmad ab amjed g Jesus amai Damascus t am. Tsh g Jesus chuhchai am hahawa s‑wohoch. ");
INSERT INTO oodNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sh am ha wehm dakahim ch wehsko oimmed ch am si s‑gewkam ha mihshmad g hemajkam ab amjed g Jesus Jerusalem ch ed. ");
INSERT INTO oodNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kutsh hegam Tutuligo mo neneok g Greek neꞌokikaj am i chum e nako matsh wo mua nash pi ha wehm e neꞌowin ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kutsh g Jesus ihmdam am i kah ihda k am i bei Cesaria kihhim wui k am ahgid matsh gam hu wo hih e‑kihhim wui mash d Tarsus. Neh, tsh gam hu hih. ");
INSERT INTO oodNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tsh am hahawa dodolimat haꞌichu am ha wehhejed wehsko am Judea ch Galilee ch Samaria ch ed. Kutsh muꞌi ep ab i s‑wohoch g haꞌichu ha‑ahga ab amjed g Jesus k ab si has elid g Jiosh. Kush ab si ha wehmaj g Hekia S‑apꞌekam Gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Sh eda g Peter an wehsko oimmed e‑jewedga oidk ch am i ha chehgim hegam mash ab ihm g Jesus. Sh am haꞌi dadha Lydda kihhim t am. Kutsh ged hu jiwia. ");
INSERT INTO oodNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Sh am hema kih g pi himidkam ch hab chehgig Aneus ch ab wabsh i s‑moik ch ash gigiꞌik aꞌahid ab pi shaꞌi e nako mas am wo i wami ab e‑woꞌikud amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kutsh g Peter am i chehgim k hab kaij ab wui, “Aneus, Jesus Christ at wo m‑doaj. Ab g i wamig k am i holiwkad g e‑wahpakus.” Tsh am ha hekaj i kekiwua k am hab e juh. ");
INSERT INTO oodNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kutsh muꞌijj ab i s‑wohoch g s‑kehg haꞌichu ahga ab amjed g Jesus hegam mo am kih Lydda ch Sharon kihhim t am nash pi neid matki doa ihda oꞌodham. ");
INSERT INTO oodNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Sh am hema kih g uwi Joppa kihhim t am ch d e doꞌibiakam ch chum hekid s‑ap haꞌichu am hab junihim ch am haꞌichukaj i ha wehmaj g shoꞌigkam. Sh hab chehgig ihda Tabitha mo hab d ahga Kuhwid. ");
INSERT INTO oodNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kush am wabsh kia daha g Peter Lydda t am. Tsh am wabsh si mumku ihda uwi k am i muh. Tsh am i apꞌech g chuhkugaj k am woi mash an hema kehk g kih gan hu uhgk kih dahm. ");
INSERT INTO oodNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","K eda g Joppa pi shaꞌi mehk ab Lydda t amjed. Kumtsh am i kah amai Joppa t am mo am haꞌichug g Peter k am gohk ha cheha g chechoj matsh am wo wohp k ab wo wai. Kutsh wa woho am wohp k am wai matsh s‑hohtam ab wo i hih Joppa wui. ");
INSERT INTO oodNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Tsh am wa hekaj i e nako g Peter k gam hu ha oi. Kutsh ged hu dada. Tsh g Peter gan hu i wah mash an woꞌo g muhki. Tsh wehsijj gan hu biha g heheꞌejel wiꞌikam uꞌuwi k si shoani ch ab chehgid g wehschuga matsh wa haschu hab ha juni. ");
INSERT INTO oodNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tsh gam hu wehs i ha wuwhas g Peter k am i tonwua k e hoꞌigeꞌidahu ab Jiosh wui k ab hahawa si neok wui g muhki ch hab kaij, “Tabitha, ab g i wamig.” Tsh am ha hekaj i e chegito k am i nei mash am kehk g Peter k shel i dahiwua. ");
INSERT INTO oodNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kutsh g Peter an i wehmt. Kutsh kekiwua. Tsh ab hahawa wehs i ha waid k ab ha chehgi mo d doakam. ");
INSERT INTO oodNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tsh ihda matsh haschu has e juh am wehsko kaida Joppa t am. Tsh muꞌijj ab i s‑wohoch g s‑kehg haꞌichu ahga ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Sh muꞌi tashkaj am dakahim g Peter Joppa t am heg wehm mash hab chehgig Simon ch ash g hogi chikpan hab wua. ");
INSERT INTO oodNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sh am dadha g siant shondal Cesaria kihhim t am mash ab amjed g Italy jewed. Kush g ha‑uhgchuga hab chehgig Cornelius ");
INSERT INTO oodNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ch ash si oid g Jiosh himdag ch am ep i ha wehmt g shoꞌigkam Tutuligo ch ab ihm g Jiosh. Kush g wehmaj kihkam wehsijj hab waꞌap ab si ihm g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sh hema tash mash d i waik ohla im hab i juhk, tsh am nenaj ed hab e juh matsh am jiwia g anghil k am si chehch hab kaijch, “Cornelius.” ");
INSERT INTO oodNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Sh ab hu wabsh si neid ihda anghil ch wabsh s‑ehbeni ch hab kaij, “Shahchu ap ahgahim ch ab neok?” Sh hab kaij g anghil, “Ab o kaiham g Jiosh g m‑hoꞌigeꞌidahuna ch s‑hohhoꞌid hegai map haschu am hab junihim g shoꞌigkam ha wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pegih, pt hemuch haꞌi wo ha cheha g chechoj mat am wo hihi Joppa wui k am wo nei hegai mo hab chehgig Simon Peter. ");
INSERT INTO oodNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Am o da heg kih am mo d hogi chikpandam ch hab waꞌap chehgig Simon ch am kih ge kahchki hugid an.” ");
INSERT INTO oodNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tsh amjed gam hu hahawa hih hegai anghil mash ab wui neok. Tsh g Cornelius am hahawa waik ha wai g e‑pionag. Sh hema idam d shondal ch si oid g Jiosh himdag. ");
INSERT INTO oodNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kutsh am ha ahgi idam matsh haschu has e juh k am hahawa ha cheha mat gam hu wo hihi Joppa wui. ");
INSERT INTO oodNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Sh am baꞌich d i tash matsh am dahm i juh, sh am wabsh kia hihim idam ch ab hi wa aihim g kihhim. Tsh eda g Peter gm hu hejelko him k am e hoꞌigeꞌidahun. ");
INSERT INTO oodNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","k ash am i si bihugim k chum haꞌichu s‑hugimk. Tsh eda koi bai g hihidod. Kutsh am Peter nena ed hab e juh ");
INSERT INTO oodNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","matsh ab i e kuhpiꞌo g dahm kahchim. Kutsh ab haꞌichu i e huduni jewedo k hab mahs mo g lohna ch shaꞌi si geꞌej ch an aꞌai e uꞌukch chuhchpulij an ch ab i tadanich. ");
INSERT INTO oodNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Sh id eda am haꞌichug g nahnko mahs haꞌichu doakam ch wahammad ch uꞌuwhig. ");
INSERT INTO oodNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Sh hab kaij g Hekia S‑apꞌekam Gewkdag, “Peter, i g wuhshani k am wabsh chum haschu wo ha mua idam k hekaj wo e gegos.” ");
INSERT INTO oodNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tsh wabshaba g Peter hab si chei, “Ih, pi ant am hu hab wo ni‑juh, ni‑kownalig. Pi ani hekid koꞌa hegai mo g m‑chehanig pi t‑hiwgid machs wo koꞌad.” ");
INSERT INTO oodNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sh hab hahawa kaij hegai mo ab neok, “Pi g hab shaꞌi elid mas pi apꞌe hegai mo haschu g Jiosh hemu am m‑chehgid mo s‑apꞌe.” ");
INSERT INTO oodNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tsh waikko hab e juh ihda am nenaj ed. Tsh amjed im hu hahawa uhpam i e bei ihda haꞌichu am dahm kahchim wui. ");
INSERT INTO oodNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Sh am wabsh kia oidahim g Peter hegai matsh haschu nei. Tsh heg i eda idam Cornelius pionag am i s‑mai mo hebai i kih g Simon k am dada k ab gegok kolhai kihjeg t ab ");
INSERT INTO oodNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ch ab si s‑kaidam ha kakke, “No ia hema daha mo hab chehgig Simon Peter?” ");
INSERT INTO oodNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kush eda g Peter am wabsh kia chum aꞌamichud mas has d ahga hegai mat am nei. Kush hab kaij g Hekia S‑apꞌekam Gewkdag, “Neh, ia at haꞌi dada k s‑m‑neidam. ");
INSERT INTO oodNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pt am wo i e nakog k am wo ha nei. Pi g has shaꞌi ha elid mo d ge gawul mahs hemajkam k wabsh wo ha oi. Ahni o d ni‑tatchui mat ab i hihi.” ");
INSERT INTO oodNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tsh wa woho am i hud g Peter k hab kaij ab ha wui idam oꞌodham, “Ahni ani wud mam s‑ni‑neidamk. Shahchu amt ahgk ia dada?” ");
INSERT INTO oodNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Sh hab hahawa kaij idam oꞌodham, “No pi ab t‑chehani g Cornelius. Heg o d shondal ha‑uhgchuga Cesaria t ab ch si s‑ap d oꞌodham k ch ab si ihm g Jiosh. K g Tutuligo hab waꞌap ab si has elid. Tsh g anghil ab wui i hih ab amjed g Jiosh k hab ahg mat ab wo i m‑wai e‑kih wui k wo m‑kah mapt haschu wo i ahgi.” ");
INSERT INTO oodNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tsh ab i ha wahpki g Peter idam waik oꞌodham mat am wo waꞌi kohk. Sh an baꞌich d i tash, tsh i e nakog k gam hu hahawa ha oi. Tsh haꞌi ep ha oi hegam mash d Jesus ihmdam ch ab d kihkam Joppa t ab. ");
INSERT INTO oodNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Am baꞌich d ep i tash. Tsh ged hu hahawa dada Cesaria t am. Tsh oi wa g Cornelius heki hu am i ha wai g e‑hajuni ch e‑naipijju. Kush idam am wehmaj ha nenida. ");
INSERT INTO oodNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tsh ab wabsh chum i wah g Peter. Tsh g Cornelius ab si daꞌiwuni k ab si i gei wecho ab si has elidch. ");
INSERT INTO oodNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tsh wabshaba hab ah g Peter, “Pi g shaꞌi ni‑wui i gehsh. Dani wabsh oꞌodham.” ");
INSERT INTO oodNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kush am e wehm neneokhim ch am i wahp. Sh am muꞌi dadha g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kush am ha neid g Peter ch hab kaij ab ha wui, “Am am wa s‑mahch mach ahchim Tutuligo pi shaꞌi hiwgidas ab t‑himdag amjed machs ab wo i s‑em‑hajunima ahpim mam d gawul mahs hemajkam, niꞌichs am hu wo em‑chehgim em‑kihki wui. T wabshaba g Jiosh am ni‑chehgi mant iꞌajed pi am hu has wo shaꞌi em‑elidad. ");
INSERT INTO oodNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nt hekaj ab i hih pi shaꞌi has elidk mam d ge gawul mahs hemajkam. Pegih, m haschu ahgch am ni‑waid.” ");
INSERT INTO oodNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Sh hab kaij g Cornelius, “Am ani ni‑hoꞌigeꞌidahun ni‑kih am d hu hema i tako imhab i juhk. T am haha wabsh hema jiwia g oꞌodham. K si tonod g wehschugaj. K ab kehk ni‑wui ");
INSERT INTO oodNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ch hab kaij, ‘Cornelius, ab o kaiham g Jiosh g m‑hoꞌigeꞌidahuna ch s‑hohhoꞌid hegai map haschu am hab junihim g shoꞌigkam ha wehhejed. ");
INSERT INTO oodNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pt wo haꞌi ha cheha mat am wo hihi Joppa wui k am wo wai hegai oꞌodham mo hab chehgig Simon Peter. Am wo da heg kih am mo d hogi chikpandam ch hab chehgig Simon ch an kih ge kahchki hugid an.’ Neh, bo kaij. ");
INSERT INTO oodNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Kunt am hahawa haꞌi ha cheha mat am hihim k ab i m‑wai. Kupt s‑ap e juh k ab i hih. Kuch hemuch ia dadha am nenaj ed g Jiosh ch s‑kaimk hegai mat haschu g Jiosh am wo i m‑ahgi mapt am hab wo chei.” ");
INSERT INTO oodNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tsh wa woho am hahawa haꞌichu i ahgahi g Peter k hab kaij, “Hahawa ant wa s‑mai moki woho mo g Jiosh wehs ha wepo masma ha neid g nahnko mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","K hegam d si tatchuij mo hedai ab i si has elid ch am hab junihim g s‑apꞌekam, chum as pi d wo Tutuligo hemajkamk. ");
INSERT INTO oodNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Am amki chum heki hu kah ab amjed ihda mant haschu wo i em‑ahgi nam pi ia t‑shahgid dadha ahchim Tutuligo. K ahchim am t‑ahgid g Jiosh mash s‑ha doꞌibiamk g hemajkam am gahi wuhshanim g e‑alidag Jesus Christ. Heg o wud mat g Jiosh am i kei mat wehs d wo ha‑kownaligk g nahnko mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","K wa am hema t‑jehnigid ab amjed g Jesus ch am t‑pahl wapkon ch hab chehgig John. T am i wuhsh g Jesus k am e pahl wako heg ab John. T g Jiosh ab mah g si geꞌe gewkdag am gahi wuhshanim g Hekia S‑apꞌekam Gewkdag mat hekaj hab wo junihid g e‑chikpan. T g Jesus am i shonwuich g e‑chikpan Galilee chekshani ch ed k am hahawa wehsko hab junihim Judea chekshani ch ed. Jiosh o am wehmaj. K hekaj wehsko i ha wehmt g e‑hemajkamga ch ha dodajid hegam mo g jiawul ha shoꞌigchud. ");
INSERT INTO oodNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Kuch ahchim am wehmajkahim ch g si t‑wuhpuikaj neid hegai mo haschu hab junihim am wehsko t‑jewedga ed ch am Jerusalem ch ed. Kumt an be k mua ab naggiak kots t ab. ");
INSERT INTO oodNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","T wabshaba g Jiosh ab uhpam i wuhshad muhkig amjed mo d i waik tash k am i t‑chehgi. ");
INSERT INTO oodNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","K pi wabsh chum hedai neid. Ahchim ach waꞌi neid mat heꞌekiajj g Jiosh heki hu am i t‑chuhcha. Tt wa am wehmaj t‑gegos am i dahm mat g Jiosh ab i wuhshad muhkig amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jiosh atsh am si i kei matsh wo ha doꞌibia hegam mat ab wo hiwgad k wo ha lodai hegam mat pi wo e doꞌibia. T g Jesus ab t‑mohtoꞌi matt am wo si wohokamch ihda k am wo ahgahid g s‑kehg haꞌichu ahgaj. ");
INSERT INTO oodNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jiosh at gam hu hab wo i juh g pi ap ha‑chuꞌijig wehs hegam mat ab wo i s‑wohoch g haꞌichu ahgaj ab amjed g Jesus. Id o wehsijj wohokamchud g kekelibad Jiosh haꞌichu i tashogiddam.” ");
INSERT INTO oodNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Sh am wabsh kia neok g Peter. Tsh ab i hud g Hekia S‑apꞌekam Gewkdag ha dahm hegam mo am kaiham k ab si i ha mah g gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Tsh am gawul neꞌokikaj neneo mat pi hebai mai k ab si ihm g Jiosh. Tsh am i ha kaiok ab si e totods hegam mo wehmaj g Peter natki pi g Hekia S‑apꞌekam Gewkdag ab si i ha mah g gewkdag hegam gawul mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Sh ab kaij g Peter, “Jiosh atki ab i ha mah g Hekia S‑apꞌekam Gewkdag mat hab masma ab i t‑mah. No hig pi d ha wuikam mat wo e pahl wapko?” ");
INSERT INTO oodNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kumtsh wa woho ha pahl wapko am chehchegch g Jesus Christ. Sh idam ab hahawa si ahgid g Peter mat am wo shaꞌi ha wehm dakahim heꞌekia i tash. ");
INSERT INTO oodNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tsh am i kah g Jesus wohochuddam amai Judea jewed t am matsh hegam gawul mahs hemajkam ab bei ihda Jiosh haꞌichu ahga. ");
INSERT INTO oodNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Sh eda am haꞌi d hegam mash hab si elid mat hemho wa hab wo juh g Tutuligo ha‑himdag hegam gawul mahs hemajkam matsh ab i s‑wohoch. Kutsh am hihi idam Peter k am dada Jerusalem t am. Kutsh hegam am neꞌowin k hab si ahg, ");
INSERT INTO oodNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Kah ach maptsh am ha wehm e gegos hegam mo d gawul mahs hemajkam ch pi pahl hikuchkas. P eda s‑mahch mo pi t‑hiwgidas machs chum hems am wo i wahp ha‑kihki ed.” ");
INSERT INTO oodNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tsh am hahawa ha ahgi g Peter matsh haschu has e juh gd hu i shonchudk mo wa am e hoꞌigeꞌidahun Joppa kihhim t am ch hab kaij: ");
INSERT INTO oodNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Am ani daha Joppa t am ch am hu hebai ni‑hoꞌigeꞌidahun. T am ni‑nena ed hab e juh mat ab haꞌichu i e huduni dahm kahchim t amjed k hab mahs mo g lohna ch shaꞌi si geꞌej ch an aꞌai e uꞌukch chuhchpulij an ch am ni‑tahgio i e ul. ");
INSERT INTO oodNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kunt am si i nei eda k nei g nahnko mahs haꞌichu doakam, chum hegam ehp mo s‑dodajk ch wahammad ch uꞌuwhig. ");
INSERT INTO oodNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","“K ab hahawa hema si neok ch hab kaij, ‘Peter, i g wuhshani k wabsh chum haschu am wo muꞌa k hekaj wo e gegos.’ ");
INSERT INTO oodNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Kuni hab kaij, ‘Ih, pi ant am hu hab wo ni‑juh, ni‑kownalig. Pi ani hekid koꞌa hegai mo g m‑chehanig pi t‑hiwgid.’ ");
INSERT INTO oodNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“K hab ep kaij hegai mo ab neok, ‘Pi g hab shaꞌi elid mas pi apꞌe hegai mo haschu g Jiosh hemu am m‑chehgid mo s‑apꞌe.’ Neh, bo kaij ab ni‑wui. ");
INSERT INTO oodNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kut id hab e juh waikko. T amjed im hu hahawa uhpam i e bei ihda haꞌichu am dahm kahchim wui. ");
INSERT INTO oodNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Kutki eda heki hu am haꞌi dada waik g oꞌodham. Idam ha‑geꞌejig o hab chehgig Cornelius ch am kih Cesaria t am ch ab ha cheha matsh ab wo i ni‑wai. Tki am dada mani am da. ");
INSERT INTO oodNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","K hab ni‑ahgid g Hekia S‑apꞌekam Gewkdag mant pi has wo shaꞌi ha el mo d ge gawul mahs hemajkam k wabsh wo ha oi. T idam chuhdp t‑wepnag m ia gegok am ni‑wehm hihi Cesaria wui k am ni‑wehm i wahp Cornelius kih ed. ");
INSERT INTO oodNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","“K heg am t‑ahgid matsh g anghil am jiwia kihj am k hab kaij, ‘Am g haꞌi ha chehani mat am wo hihi Joppa wui k am wo wai hegai oꞌodham mo hab chehgig Simon Peter. ");
INSERT INTO oodNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","T heg am wo em‑ahgi mamt has masma wo e doꞌibia wehsijj g e‑wehm kihkam ha wehm.’ ");
INSERT INTO oodNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Pegih, tki wa woho hab e juh. Kunt am him k am wabsh chum haꞌichu i ha ahgid. T g Hekia S‑apꞌekam Gewkdag ab i hud ha dahm mat wa hab e juh am t‑wehhejed ga hu si i wehpeg. ");
INSERT INTO oodNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nt am hahawa i chegito mo wa hab kaij g t‑kownalig Jesus, ‘Mat ab i em‑mah g John g pahl wakona. T wabshaba g Hekia S‑apꞌekam Gewkdag g si geꞌe gewkdag ab wo i em‑mah pi shaꞌi muꞌi tash iꞌajed.’ ");
INSERT INTO oodNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Neh, t id amjed am si i e tashogi mat g Jiosh ab ha mah hegam gawul mahs hemajkam hegai mahkigdag mat ahchim ab t‑mah mat hekid ab i s‑wohoch g Jiosh haꞌichu ahga ab amjed g t‑kownalig Jesus Christ. Kunt pi has masma am hu wo shaꞌi kuh g Jiosh id amjed.” Neh, bash kaij g Peter. ");
INSERT INTO oodNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tsh idam am i kah wehs haꞌichu k pi ab hu has hahawa ep ahg ch wabsh si s‑hehgigam ab ihm g Jiosh ch hab kaij, “Pegih, boki d Jiosh hab elida mat idam gawul mahs hemajkam hab waꞌap gam hu wo s‑ohhod g pi ap e‑chegitoi k wo bei g pi ha huhugedam doakag.” ");
INSERT INTO oodNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kutsh haꞌi hegam matsh wa e gantad matsh hekid i e muhkid g Steven gam hu ahgahi g Jiosh haꞌichu ahga Phenicia ch Cyprus jejewed t am ch Antiok kihhim t am k hegam an waꞌi ha mihshmad Tutuligo. ");
INSERT INTO oodNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tsh am hahawa haꞌi dada Antiok t am ab amjed g Cyprus ch Cyrene k am i ha mihshmad hegam ehp mo d gawul mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tsh g Jiosh am i gewkai g haꞌichu ha‑ahga. Kutsh muꞌijj hegam hemajkam ab i s‑ha wohochud k ab i e dagito Jesus wui. ");
INSERT INTO oodNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tsh am i kah hegam mash ab ihm g Jesus ch ab dadha Jerusalem t ab matsh has i e juh am Antiok t am k ab hahawa cheha g Barnabas matsh am wo him k wo i ha wehmt. ");
INSERT INTO oodNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Tsh ged hu jiwia k am i nei si s‑hehgigch matki wa woho g Jiosh ab si s‑ha hoꞌigeꞌel. Sh am ha ahgid mamt wehs ab wo i e dagito Jiosh wui k pi hekid wo shaꞌi dagito hegai mamt haschu ab i bei. ");
INSERT INTO oodNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Sh wa eda si s‑ap d oꞌodham g Barnabas ch si e dagitokch Jesus wui ch ab si uꞌukch g gewkdag ab amjed g Hekia S‑apꞌekam Gewkdag. Tsh muꞌijj ab i s‑wohoch g haꞌichu ahgaj ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tsh hekaj hab i e ah g Barnabas matsh am wo i bei g Saul mat heg am wo i ha wehmt. Sh eda heg am kih Tarsus kihhim t am. Tsh am him ");
INSERT INTO oodNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","k am i chehg k ab uhpam i wai Antiok wui. Tsh am uhpam hihim k am dada Antiok t am k hemako ahid ab am i ha wehmt g e wehm wohochuddam amai. Sh eda muꞌij idam. Amai ash Antiok t am mamtsh si wehpeg hab ha chehch Christian. ");
INSERT INTO oodNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tsh wa eda am haꞌi dada g Jiosh haꞌichu i tashogiddam ab Jerusalem t amjed amai Antiok t am. ");
INSERT INTO oodNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","29","Sh idam hema hab chehgig Agabus. Tsh g Jiosh am i tashogi ihda mat g bihugig wo gei an wehsko jewed dahm. Kutsh am ha ahgi g Jesus ihmdam amai Antiok t am. Tsh amai i amjed am i e nakog k am wehsijj i shuligahi g lial am ha wehhejed hegam e‑wehm wohochuddam mo am kih Judea jewed ch ed. Kutsh gei hegai bihugig mash eda g Claudius am d kownal. ");
INSERT INTO oodNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kumsh am ha chehani g Barnabas ch Saul matsh am wo i ui g lial. Tsh idam am i uꞌu k ab ha mah g ha wanimeddam g Jesus ihmdam amai Judea jewed ch ed. ");
INSERT INTO oodNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tsh eda am i ha shoꞌigch g kownal Herod hegam mash ab ihm g Jesus ");
INSERT INTO oodNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","k ab ha chehani g e‑shondalig. Tsh idam an bei hegai James mo d John wehnag k mua g is‑pahyokaj. ");
INSERT INTO oodNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kush muꞌi si s‑hohhoꞌid g Tutuligo matsh hab e juh ihda. Tsh heg hekaj wabsh baꞌich i si e gewkai g Herod k g Peter an ep bei. Kutsh eda e ai g si geꞌe mihshmda mo eda g Tutuligo pi koꞌa g hegai pahn mo jewajidas wewaꞌak tash oidam. ");
INSERT INTO oodNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tsh am ha cheha g Herod g e‑shondalig matsh wabsh wo kuh g Peter. Kumtsh am haha wo lodai am ha tahgio g hemajkam mat am wo i haꞌasa e piast. Tsh gamai chuhdp i e chuhcha g shondal matsh giꞌik e wehm wo nuhkud tash oidam ch s‑chuhugam oidam. ");
INSERT INTO oodNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Sh wabshaba heg oidam am hahasko e hehemapad g Jesus ihmdam ch am wehhejed si e hoꞌigeꞌidahun. ");
INSERT INTO oodNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kutsh am i e ai matsh baꞌich i siꞌalim wo e lodai g Peter. Tsh am i s‑chuk. Sh am woꞌo ch kohsh ha shahgid g gohk shondal mash am nuhkud. Kumsh gan hu si wupulshch g nohnhoij ch kakhioj g gohk e hukshchim wapainomikaj. Sh an gohk ep gegok g shondal ch am nuhkud g kukpaikud kihkijeg. ");
INSERT INTO oodNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tsh am haha wabsh jiwia g anghil k am wui i kekiwua g Peter. Tsh wabsh si ton am kukpaikud ch ed. Kutsh ihda anghil ab si ugij g Peter k wuhan k hab kaij, “Oi g kekiwua s‑hohtam.” Kutsh gam hu wa hekaj aꞌai shul hegai e hukshchim wapainomi mamsh an hekaj wupulshch. Tsh am i kekiwua. ");
INSERT INTO oodNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Sh hab hahawa kaij g anghil, “An g s‑wihnam i e giwuddad k ab si i wuhpud g e‑kaikia shuhshk.” Tsh wa woho hab e juh g Peter. Sh hab ep kaij g anghil, “Ab g wahki g e‑lihwa k ab i ni‑oid.” ");
INSERT INTO oodNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Tsh ab wahk k gam hu i oi. Kutsh am i wuwha ab amjed mash am kuhpikahim. Kush sha pi s‑wohoma mat woho ab i wuhshad g anghil nash pi hab e ahg mo wabsh chehchk. ");
INSERT INTO oodNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tsh am hihim k am i wuwha wehpeg kihjeg t ab. Kush am hema kehk g shondal ch wabshaba pi am hu shaꞌi ha neid. Kutsh am ep hihim k gam hu ep wuwha mash am kahya wui kihjeg. Kush am hema ep kehk g shondal ch hab waꞌap pi shaꞌi ha neid. Tsh wabsh hejel ab i e kuhkpiꞌo g kihkijeg. Tsh am waꞌi hekaj pi e haꞌichuch g anghil. ");
INSERT INTO oodNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tsh am haha wabsh si i e taht g Peter k hab kaij, “Neh, woho atki hab e juh. Jiosh atki ab cheha g anghil mat ab ni‑wui wo hih. Tki heg ab i ni‑wuhshad kukpaikud amjed ch ni‑doꞌibia ab amjed mat has wo i chum ni‑juh g ni‑wehm oꞌodham.” ");
INSERT INTO oodNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tsh amjed am hih kihj wui hegai Mary mo d John Mark jeꞌe. Kush eda muꞌijj am e hemapadch ch e hoꞌigeꞌidahun. ");
INSERT INTO oodNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kutsh ab si shontpag g pualit g Peter. Tsh am hema hih g ha‑pionag k hab chehgig Rhoda. Sh hab kaij g Peter, “Gam g i kuhpiꞌok.” ");
INSERT INTO oodNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tsh heg am i amich mo d Peter ch ab neok k si s‑hehgig ch gam hu uhpam meh pi ab hu i kuhpiꞌok g pualit k ged hu ha ahgid mo g Peter ab kehk jeg ed. ");
INSERT INTO oodNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Sh hab kaij hegam ab wui, “Ptp wabsh chehch mo ab s‑kehkadma.” Sh wabshaba am hab wabsh i kaij mo woho. Sh hab hahawa ep kaij, “Naꞌas d wabsh kokꞌoi namtsh pi wo mua.” ");
INSERT INTO oodNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","17","Kush eda ab wabsh kia shontpag. Tsh ab hahawa i kuhpiꞌo g pualit k nei mo ab kehk. Tsh am ha hekaj i wah k ab ha ihm k am i ha ahgid mat has masma g Jiosh i wuhshad ab amjed g kukpaikud. Kush si has i elid mat has e juh. Tsh hab hahawa ha ah, “Am g wo ha ahgid hegam James mat g Jiosh ab i ni‑wuhshad,” k amjed gam hu hahawa ep hasko hih. ");
INSERT INTO oodNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tsh am baꞌich i mahsi. Tsh am shaꞌi si e kudu hegam mash am nuhkud g kukpaikud. “T hebai hih g Peter?” bash kaij. ");
INSERT INTO oodNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Tsh g Herod am hahawa si ha cheha mat am wo i gahghi. Tsh wabshaba pi shaꞌi mai mas hebai hih. Sh am si i ha chehani g Herod mat ab wo ha kakke hegam shondal mas has e juh. Kush pi neid ch pi mahch mas has e juh. Kush oi wa am ha chehani mat wo ha kokda. Tsh amjed gam hu hahawa hih g Herod Cesaria kihhim wui ab Judea chekshani t amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tsh am hebai i cheka. Kutsh wabsh wohoꞌi bagat g Herod ab ha wui hegam mash am kih Tyre ch Sidon t ab. Kutsh ab wui hihi matsh wo chum apꞌech mash haschu i pi apꞌe nash pi am chum huniop. Sh am hema d kownal kehsha ch nuhkud g kihj ch hab chehgig Blastus. Kutsh heg wehpeg ab si i s‑nawojima k amjed am wui hihi g Herod k ab kakke mat wabsh ab wo i s‑ha hoꞌigeꞌel. ");
INSERT INTO oodNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tsh hema kei g tash g Herod k ab si s‑kehg e enigadad k ab dahiwua kownal daikud ab k am si s‑hasigam ha jehnigi g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kush ab si hihnk g hemajkam ch hab kaij, “Pi oki d shaꞌi oꞌodham ch ab neok noki pi d ge hema jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kutsh pi ha shohbi g Herod k pi am hu has el g Jiosh. Tsh heg hekaj g anghil ab ab hab juh g mumkidag mat waptopad k muh. ");
INSERT INTO oodNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kutsh g Jiosh haꞌichu ahga i geꞌeda. ");
INSERT INTO oodNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tsh g Barnabas ch Saul gam hu uhpam hihi ab Jerusalem t amjed mat am i ui g lial. Kutsh g John Mark am i ha oi. ");
INSERT INTO oodNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Sh am haꞌi ep d Jiosh haꞌichu i tashogiddam Antiok t am. Hema idam ash hab chehgig Simon ch wabshaba hab e aꞌaga S‑chukchu. Kush hema d Lucius ch ab Cyrene t amjed. Kush hema d Manaen ch am wehmaj geꞌeda g kownal Herod. Idam ash am ha mashcham am ha wehm g Barnabas ch Saul. ");
INSERT INTO oodNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kush am hu hebai wehsijj am heꞌekia tashkaj wabsh e hoꞌigeꞌidahun ch hab pi haꞌichu koꞌa. Kush am ha tashogid g Hekia S‑apꞌekam Gewkdag mash g Jiosh hab kaij ab ha wui, “Neh, ab ant ha mohtoꞌi g Barnabas ch Saul mat gam hu mehk wo i ahgahi g haꞌichu ni‑ahga. Kumt am wo i ha dagito mat hab wo wa e juh.” ");
INSERT INTO oodNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kush am baꞌich i himchud hegai mash wabsh e hoꞌigeꞌidahun ch pi haꞌichu koꞌa ch ab hahawa ha taht idam Barnabas ch Saul matsh hekaj am chehgi mat ha dagito heg wui mat g Hekia S‑apꞌekam Gewkdag am i ha tashogi. ");
INSERT INTO oodNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Tsh gam hu hihi g Barnabas ch Saul mash wa g Hekia S‑apꞌekam Gewkdag am i ha tashogid. Kutsh am ep i ha oi g John Mark matsh am wo i ha wehmt. Tsh idam ged hu dada Selucia kihhim t am. K id an hugidaj an g ge kahchki. K ab hihhim g wapalko. Kutsh idam Barnabas an i chehchsh wahlko ch ed k gam hu aigo i shulig k gam hu dada Cyprus jewed ch ed. Sh am hema kihhimag ch hab e aꞌaga Salamis. Kush am haꞌi chuhch g Tutuligo ha‑chechopi. Sh idam Barnabas am i wahpk ch am ha jehnigid ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Sh gam hu aigo hema ep kihhimag ch hab chehgig Paphos. Kutsh gam hu hihim k am ep ha jehnigid. Sh am da hegai mash d kownal id eda jewed ch hab chehgig Sergius Paulus. Kush am hema wehmaj g Tuhligo ch hab chehgig Barjesus ch d s‑hasigam haꞌichu hab wuadam ch ha iattogid mash d Jiosh haꞌichu i tashogiddam. Kumsh hab aꞌaga Elymas mo hab d ahga Ge Mahkai. Sh g kownal d si haꞌichu s‑amichuddam oꞌodham ch ab i ha wai g Barnabas ch Saul nash pi s‑kaimk g haꞌichu ha‑ahga ab amjed g Jesus. Tsh wabshaba ab ha wui kekiwua hegai Elymas k am i chum e nako mat hab wo juh g kownal mat pi ab hu wo ha wohoch. ");
INSERT INTO oodNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saul o hab ep e aꞌaga Paul Greek neꞌokikaj. Tsh g Hekia S‑apꞌekam Gewkdag ab ep si mah g Paul g gewkdag. Sh heg ab si shel i neid g Elymas ");
INSERT INTO oodNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ch hab kaij, “Neh, dap Jiawul pionag nap pi ab wabsh i si shuhdags g pi apꞌekamkaj. K heg hab m‑wua map ab wui kehk g s‑apꞌekam ch chum gawul s‑junimk g Jiosh haꞌichu ahga. ");
INSERT INTO oodNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Jiosh at hab wo m‑juh mapt pi wo nehnt heꞌes i tash.” Neh, bash kaij g Paul. Kutsh am wa i hekaj woho hab e juh. Tsh am taht g Elymas mat ab haꞌichu si maꞌish g wuhpuij. K am wabsh i s‑chuhugam wehhejed. Tsh an i dahdaghi an chum hema gahgch mat am wo i wanim. ");
INSERT INTO oodNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tsh ab si e tods g kownal k ab i s‑wohoch neidok mash has masma g Jiosh am chehgid g e‑gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Tsh am hahawa gahi ep i shul hegam Paul ab Paphos t amjed k gam hu dada Perga kihhim t am am Pamphylia jewed ch ed. Tsh wabshaba g John Mark am i ha dagito amai k gam hu uhpam hih Jerusalem wui. ");
INSERT INTO oodNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tsh amjed gam hu hahawa hihi idam Paul ch Barnabas Pisidia jewed wui. K am hema kihhimag ch hab chehgig Antiok. Kutsh am dada. Tsh am i e ai g ha‑mihshmda tash. Kutsh ged hu i wahp idam Paul e wehm oꞌodham ha‑cheopi ed k am i dadhaiwua. ");
INSERT INTO oodNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kumtsh am neꞌokchul g Jiosh oꞌohana. Sh hegam mash d ha wanimeddam hab hahawa kaij, “T‑naipijju, chum ach si tatchua mamt am wo haꞌichu ha ahgi g hemajkam mat heg amjed ab wo i e gewpkai.” ");
INSERT INTO oodNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tsh ga hu hahawa i kekiwua g Paul ha baꞌich k hab kaij: “T‑hajuni ch ahpim mam ia ha wehm ihm g Jiosh, ab g wo i ni‑kaiham. ");
INSERT INTO oodNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Jiosh atsh ab i ha gawulkai g t‑shohshonbad matsh d wo hemajkamgajk. Kutsh am i muꞌida mash eda am kihkahim Egypt jewed ch ed. Tsh ab hahawa i ha doꞌibia ab ha amjed g Egypt hemajkam g si geꞌe e‑gewkdagkaj. ");
INSERT INTO oodNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kush an oiopo tohono jewed ch ed giꞌikko wehst‑mahm ahid ab. Sh g Jiosh am s‑hemajim ha nakogahim ");
INSERT INTO oodNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ch am wo i ha wahpki id eda Canaan jewed. Sh eda g wewaꞌak kawod dakam hemajkam ia kih. Tsh g Jiosh ha hugio k g ha‑jewedga am aꞌai i ha tahpjel g t‑shohshonbad mash hab masma heki hu ahgid g Abrahambad. ");
INSERT INTO oodNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tsh heg i dahm am hahawa i ha chuhcha g Jiosh g s‑chu aꞌamichuddam mash am haꞌichu aꞌapꞌechud ha wehhejed. “Tsh ga hu e ai matsh am i dahiwua g Samuelbad k d Jiosh haꞌichu i tashogiddam. ");
INSERT INTO oodNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kush g t‑shohshonbad ab si tahni g Jiosh matsh am hema wo i kei mat d wo ha‑kownaligk. Tsh g Jiosh am i kei hegai Saul mash d Kishbad alidag ch ab d Benjaminbad amjedkam. Kush heg d ha‑kownalig giꞌikko wehst‑mahm ahid ab. ");
INSERT INTO oodNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tsh g Jiosh im hu hab hahawa i juh g Saulbad k g Davidbad am i kei matsh d wo ha‑kownaligk. Sh hab kaij g Jiosh ab amjed: Ihda David mo d Jesse alidag o am si ni‑tatchui oidch hab masma ch am e tashogi mat am hab wo juh hegai mant haschu ab wo i ahgi. ");
INSERT INTO oodNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Sh hab ep kaij g Jiosh matsh am hema wo i kei g Davidbad amjedkam matsh d wo t‑doꞌibiakamk. Kut wa woho hab e juh g Jiosh. K g Kehshaj hab chehgig Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","T wabshaba g Jiosh ab hema wehpeg i wuhshad g t‑wehm oꞌodham. K id hab chehgig John ch ab i ha mihshmad ch hab ha ahg mat gam hu wo s‑ohhod g pi ap e‑chegitoi k wo e pahl wapko. ");
INSERT INTO oodNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tsh ihda John id hekaj am i kuhgi g e‑chikpan mo wa hab ha ahg g hemajkam, ‘Pi g hab wo shaꞌi ni‑elidad mani ahni d hegai mam si nenida. Pi ani d ahni ch d wabsh pi haꞌichu an hugidaj an. Mt wo wa nei mat am epai wo i e maskogi hegai mo hig woho d s‑has haꞌichu.’ Neh, bash kaij g Johnbad. ");
INSERT INTO oodNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Pegih, ni‑wehm oꞌodham ch ahpim mam hab waꞌap ab si has elid g Jiosh, ab o wehsijj d t‑wuikam ihda s‑kehg doꞌibiadag ahgaj. ");
INSERT INTO oodNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Hegam kekelibad Jiosh haꞌichu i tashogiddam atki an oꞌoha matsh has wo masmak g Jiosh si Kehsha. K g ha‑neꞌoki e neꞌokchulid t‑shaꞌashagid wehs mihshmda tash. Kuki eda hegam t‑hajuni mo ab kih Jerusalem t ab pi amichud g haꞌichu ha‑ahga ch hab pi amich g Jiosh si Kehsha mat hekid am jiwia k chum s‑ha doꞌibiamk. Jiosh at am i kei g e‑alidag Jesus mat wo t‑doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","K heg pi ha chuꞌijig. T eda hegam ab chum chuꞌijigch mat g kownal Pilate wo mua. Kumt ab naggia k mua kots t ab k ab hahawa i huduni k gam hu cheh hihaꞌini ch ed. ");
INSERT INTO oodNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bat wa masma an oꞌoha g kekelibad Jiosh haꞌichu i tashogiddam mat hab wo e juh. Kut idam am wabsh wohokamch g haꞌichu ha‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","T wabshaba g Jiosh ab uhpam i wuhshad muhkig amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tsh amjed muꞌikko am si i e chehgi ha wui hegam mash an wehmajkahim ch ab wehmaj i hihi Galilee t amjed ab Jerusalem wui. K idam am si s‑mahch ch ahgahim am t‑shahgid. “Pegih, ab g wo ni‑kaiham, ni‑wehm oꞌodham mam ab d ep Abrahambad amjedkam ch ahpim mam ia ha wehm ab ihm g Jiosh. Ahpim at em‑wui gei ihda haꞌichu ahga mamt has masma wo e‑doꞌibia nat pi gam hu wabsh s‑ohhod g t‑hajuni ab Jerusalem t ab. ");
INSERT INTO oodNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Kutt hemuch ia dada k ia uꞌapa ihda s‑kehg haꞌichu ahga em‑wui. Heki ash hu am ha ahgid g Jiosh g t‑shohshonbad matsh wo uhpam i wuhshad g si e‑Kehsha ab muhkig amjed. Kutsh wa woho hab e juh. Kutki id heki hu oꞌoha g Davidbad mat eda koi hab e juh. K an wa oꞌohanas gohkkam neꞌi ed heg eda Jiosh heki hu oꞌohana mash hab kaij g Jiosh ab e‑alidag wui: Ahpi ap d si ni‑alidag. Hemuch ant am i m‑maskogi. ");
INSERT INTO oodNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","K hab ep masma an oꞌohanas mash hab kaij g Jiosh ab e‑alidag wui: B ant wo m‑mah hegai si hekia s‑kehg hoꞌigeꞌidadag mani wa am si ahgid g Davidbad. Neh, bash kaij g Jiosh ch heg hab ahg mat ab i wuhshad g Jesus muhkig amjed mat pi hekid wo shaꞌi padt g chuhkugaj. ");
INSERT INTO oodNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","K gan hu baꞌich an ep oꞌohadag ch hab chuꞌig: Pi at wo shaꞌi hiwigi g si e‑Kehsha mas wo padt g chuhkugaj. ");
INSERT INTO oodNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Neh, pi oki hejel hab e ahg g Davidbad natsh pi muh am hab juniok hegai mat haschu g Jiosh ab mohtoꞌi k am ha wehm e cheh g e‑shohshonbad. Tsh hi padt g chuhkugaj. ");
INSERT INTO oodNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Heg o hab ahg Jesus mat pi shaꞌi padt g chuhkugaj nat pi g Jiosh ab i wuhshad muhkig amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Pegih, ni‑wepnag, id amt hekaj wo chum s‑mahchk mat g Jiosh gam hu hab wo i juh g pi ap em‑chuꞌijig ");
INSERT INTO oodNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","mamt hedai ab wo i s‑wohoch g Jesus. Heg at am wo i em‑apꞌech mamt pi wo ha chuꞌijigk am Jiosh nena ed. T pi haꞌichu ep wo e nako mas hab masma am wo i em‑apꞌech, nih g chehanig. ");
INSERT INTO oodNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","“T an ep oꞌoha g kelibad Jiosh haꞌichu i tashogiddam mo hab kaij g Jiosh: S‑e g wo nenꞌoidk k am wo si i oidahi ahpim mam wabsh has ni‑ahg. Am ant haꞌichu hab wo juh em‑shahgid. Kut am hema wo si s‑ap i em‑tashogi mani d ahni ch hab wua. Mt eda pi ab hu wo ha wohoch. Nt heg hekaj gam hu hab wo i em‑juh ab ni‑amjed k pi dahm ep wo pihk ni‑el em‑hekaj. Neh, bash kaij g Jiosh. “Pegih, si g wo s‑e nenꞌoidk k ab wo s‑wohog el g Jiosh. T hab pi ab hu wo i em‑ai g s‑koꞌok em‑namkidadag.” ");
INSERT INTO oodNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tsh ab i kuhgit g ha‑namki. Tsh wo chum hihi g Paul ch Barnabas. Sh wabshaba g hemajkam ab si ha waid mat am ep wo dada baꞌich mihshmda tash k am baꞌich ep wo i ha ahgi idam haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tsh am i himto g hemajkam. Tsh haꞌi ab i ha oi hegam Paul. Kutsh ab si i ha gewkemhu ab haꞌichu ep ha ahgidk mat am wo wa e nakogad Jiosh hemajimatalig ed. Sh haꞌi idam d Tutuligo hemajkam ch haꞌi d gawul mahs hemajkam ch am ha wehm e mihshmad. ");
INSERT INTO oodNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sh am baꞌich d i mihshmda tash. Tsh chum alo wehsijj ab e hemapai g hemajkam matsh wo kah g Jiosh haꞌichu ahga. ");
INSERT INTO oodNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tsh hegam Tutuligo mash pi ab hu ha wohochud si s‑ha hehgam k hab kaij mo d wabsh s‑chu iattomkam g Paul. ");
INSERT INTO oodNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tsh wabshaba idam Paul am haha wabsh si ha ahgi, “Ni‑hajuni, bo chum mahs matt wehpeg ab wo em‑ahgi g Jiosh haꞌichu ahga ab amjed g si Kehshaj. Kumtki wabshaba s‑ohhod k hab sha e wua mam pi tatchua g pi ha huhugedam doakag am Jiosh kihdag ed. Kutt heg hekaj wo em‑dagito k hegam ha wui wo i t‑nohnogi gawul mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bo wa masma am t‑chehanig Jiosh. An o oꞌohanas mash hab kaij: Am ant i em‑gawulkai mamt am wo i ha tashogi g haꞌichu ni‑ahga g nahnko mahs hemajkam wehsko jewed dahm. T ab em‑amjed wo s‑mai mat has masma wo e doꞌibia. Neh, bash kaij g Jiosh.” ");
INSERT INTO oodNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tsh am i kah idam gawul mahs hemajkam k si s‑hehgigam ab ihm g Jiosh nash pi ab ha makiog g e‑doꞌibiadag ahga. Kutsh hegam ab i s‑wohoch mat hedai g Jiosh i ha apꞌech mat wo e doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kutsh wehsko i e ahgahi g haꞌichu ha‑ahga ab amjed g Jesus heg eda jewed. ");
INSERT INTO oodNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tsh wabshaba g Tutuligo am si i ha chuꞌamu hegam uꞌuwi mash am ha wehm e mihshmad ch hegam mash d hahaꞌichu heg eda kihhim. Kutsh idam am si i ha shoꞌigch g Paul ch Barnabas k gam hu si ha huhuꞌi ab amjed g e‑jewedga. ");
INSERT INTO oodNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tsh idam gam hu hahawa si i shahmud g jewed ab e‑tahtad ab am ha chehgidch mat wo ha dagito nat pi pi ap ab hu i ha nei. Tsh gam hu hahawa hihi Iconium kihhim wui. ");
INSERT INTO oodNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kush hegam matsh ab i s‑wohoch ab Antiok t ab si s‑hehgig ch ab si uꞌukch g gewkdag ab amjed g Hekia S‑apꞌekam Gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kutsh am hab waꞌap e juh Iconium t am matsh g Tutuligo hemajkam ab ha wui gegokiwua. Paul ch Barnabas atsh am i wahp ha‑cheopi ed k am si ha mihshmad. Kutsh muꞌi ab i s‑wohoch g Tutuligo mo g Jesus d Jiosh si Kehsha. Kutsh haꞌi hegam mash am ha wehm e mihshmad hab waꞌap ab i s‑wohoch g haꞌichu ha‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tsh wabshaba am i wuwha hegam Tutuligo matsh pi ab hu wohoch k am si i ha kudu g gawul mahs hemajkam. Kutsh idam s‑ha kehꞌel g Paul ch Barnabas ch hegam ehp matsh ab i s‑ha wohoch. ");
INSERT INTO oodNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Sh wabshaba tash am oiopo idam Jesus chuhchai ha shahgid ch am si tasho ha mihshmad ab amjed g Jesus pihk elidadag. Tsh heg ab i ha mah g gewkdag mat hab wo wuad g si s‑hasigam haꞌichu k hab masma wohokamch g ha‑ahga. ");
INSERT INTO oodNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tsh hegam hemajkam am i e gawulkai mat haꞌi ab ha wehmt g Jesus chuhchai k haꞌi g ha‑obga ab ha wehmt. ");
INSERT INTO oodNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tsh wehsijj hegam mat ab ha wui gegokiwua g Jesus chuhchai am hahawa i e apꞌech g e‑wanimeddam ha wehm mat wo ha shoꞌigchud k wo ha maꞌichshul. ");
INSERT INTO oodNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Tsh idam am i s‑mai mamtsh wo ha shoꞌigch k atsh gm hu wa hekaj baꞌich hahawa ep hihi Lystra kihhim wui. Ihda Lystra o am hab chuꞌig Lyconia jewed ch ed. ");
INSERT INTO oodNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kutsh am dada k am ha ahgid g s‑kehg haꞌichu ahga ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Sh am ha wui hema daha mash pi himdag ga hu i e‑alijk amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tsh am i nei g Paul mo hab masma ab si kaiham g ahgaj mo ab si s‑wohochud mo g Jiosh woho ha doajid. Tsh ab si shel i neid ");
INSERT INTO oodNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","k si s‑kaidam hab kaij, “Oi g kekiwua.” Tsh gam si daꞌiwush g pi himidkam k an has si oimmed. ");
INSERT INTO oodNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tsh am i nei g hemajkam matsh haschu has juh g Paul k ash am si e‑neꞌokikaj hihnk ch hab kaij, “Ia atki haꞌi dada g jijosh oꞌodham e wepogidch. ");
INSERT INTO oodNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Id oki d Zeus. Kuki heg d neokdam ch hab d Hermes.” Sh heg hab ahg Paul nash pi heg am neok. ");
INSERT INTO oodNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Sh am mia kehk g ha‑cheopi. Kush heg eda am kehshch g Zeus. Tsh am i ha wehmaj g ha‑pahlig. Kutsh am ha uꞌapa g totolo ch haꞌichu heosig mat ab ha wui wo iagchul g Paul ch Barnabas. ");
INSERT INTO oodNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kutsh id pi ha hohhoꞌidach. Tsh hab ab si wantsh g e‑wehschuga k am si wohp ha shahgid g hemajkam k si hihnk ch hab kaij, ");
INSERT INTO oodNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Pi g hab wo t‑elidad machs d jijosh. Dach wabsh oꞌodham hab masma mam ahpim. Ia att dada matt am wo em‑ahgi mamt wo haꞌasa ihm hab masma mo d Jiosh hegai mo pi d wohokam Jiosh. Heg o d wohokam Jiosh mat nahto g dahm kahchim ch jewed kahchim ch wehs haꞌichu mo an hab chuꞌig. Kumt heg wui ab wo i e dagito. ");
INSERT INTO oodNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Heki o hu am hab wabsh junihim g hejel e‑tatchui g nahnko mahs hemajkam. Kuki g Jiosh wabsh s‑hemajim ha nakogahim. ");
INSERT INTO oodNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","K wabshaba chum hekid hab chuꞌig mo am e chehgidahim no pi s‑kehg haꞌichu hab em‑junid ch ab em‑mahkch g juhki ch ab bahijid g haꞌichu em‑eꞌes mamt wo s‑kokwogk ch wo si s‑ap e tahtkkad.” ");
INSERT INTO oodNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Neh, bash kaij idam Paul ch wabshaba chum alo pi ha shohbi nash pi chum si tatchua matsh ab haꞌichu wo iagchul ha wui. ");
INSERT INTO oodNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tsh am hahawa haꞌi dada hegam mash wa am ha shoꞌigchud Antiok t am ch Iconium t am k am i ha nuꞌichkwua g hemajkam. Kutsh ab wui gegokiwua g Paul k maꞌichkwua k am i chewaimed k gam hu i wuhshad ab kihhim t amjed k am wua hab elidch mat muh. ");
INSERT INTO oodNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tsh wabshaba am e chehm hegam mo ab ihm g Jesus k an wehgaj gegok g Paul. Tsh gam si i wamig k gam hu uhpam hih kihhim wui. Am baꞌich d i tash. Tsh gam hu hahawa hihi Derbe wui hegam Paul ");
INSERT INTO oodNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","k an i ha ahgidahi g Jesus haꞌichu ahga. Kutsh muꞌijj ab i s‑wohoch. Tsh am hahawa hihi Lystra wui ch Iconium wui ch Antiok wui ");
INSERT INTO oodNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","k am si i ha gewkemhun mat am wo hihimad ch ab wo si hiwgad g Jesus. Ha‑mashchama ash hab masma matt hemho wa muꞌi haꞌichu wo nakog k am haha wo i wahp Jiosh kihdag ed. ");
INSERT INTO oodNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tsh am hahawa i ha chuhcha hegam mat d wo ha wanimeddamk am ha shaꞌashagid mo hebai i e wehm e nanmek. Sh am hahawa wehsijj wabsh e hoꞌigeꞌidahun ch hab heꞌekkio pi e gegosid. Sh idam Jesus chuhchai ab hahawa i ha dadagitod Jiosh wui. ");
INSERT INTO oodNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Neh, batsh wa masma am gahi wuwha g Pisidia jewed k gm hu dada Pamphylia jewed ch ed ");
INSERT INTO oodNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","k am ha mihshmdahim Perga kihhim ch ed ch amjed gm hu hahawa ep hihi Attalia kihhim t am. ");
INSERT INTO oodNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tsh am i e nahto g ha‑chikpan. Kutsh am gahi i shul ge shuhdagi ch ed an geꞌe wahlko ch ed k gam hu dada hegai Antiok t am mamtsh am i ha dagito Jiosh hemajimatalig ed. ");
INSERT INTO oodNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tsh am wehsijj i e hemapai hegam mash ab ihm g Jesus amai. Sh g Paul ch Barnabas am ha ahgid mat g Jiosh am si i ha wehmt k ab ha mah g nahnko mahs hemajkam g apꞌedag mat ab wo i s‑wohoch g haꞌichu ha‑ahga ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tash ash am dadkkahim ha wehm hegam mash ab ihm g Jesus amai Antiok t am. ");
INSERT INTO oodNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kutsh am haꞌi dada Antiok t ab ab Judea t amjed k hab chum ha ahg hegam matsh ab i s‑wohoch g haꞌichu ha‑ahga ab amjed g Jesus, “Jiosh o am t‑chehani Mosesbad oꞌohana ed mat g chechoj hemho wa wo e oꞌoha an e pahl hikuchk. Kumt pi wo shaꞌi e doꞌibia mamtp pi hab wo e juh.” ");
INSERT INTO oodNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Tsh wabshaba g Paul ch Barnabas pi shaꞌi hohhoꞌi ihda k am si ha neꞌowi idam Judea t am Tutuligo. Tsh am hahawa i e apꞌech matsh g Paul ch Barnabas am wo hihi Jerusalem wui haꞌi ep ha wehm k am wo s‑mai mat has wo chei hegam haꞌi ehp Jesus chuhchai ch geꞌeged. ");
INSERT INTO oodNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tsh idam am hihim k am i ha ahgidahi hegam mash ab ihm g Jesus Phenicia jewed oidk ch Samaria jewed oidk mat g gawul mahs hemajkam ab i e nodagi Jesus wui. Kutsh wehsijj ab si s‑ap i e tahtam k si s‑hehgig idam mash hedai i kah. ");
INSERT INTO oodNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kutsh ged hu dada Jerusalem t am. Tsh si s‑ha hoꞌigeꞌel g Jesus chuhchai ch geꞌeged ch wehsijj hegam mash ab ihm g Jesus amai. Tsh am hahawa ha ahgi mat haschu k ab am si i ha wehmt g Jiosh mat am hab juh. ");
INSERT INTO oodNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tsh wabshaba am haꞌi ab ha wui gegokiwua hegam mash si s‑gewkam oid g chehanig ch hab kaij, “Hemho wa at wo e oꞌoha an e pahl hikuchk g chechoj k am hab wo junihid hegai t‑chehanig mo g Jiosh ab t‑mahkch.” ");
INSERT INTO oodNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tsh am ep e nam g Jesus chuhchai ch geꞌeged k tash am aꞌaga ihda. ");
INSERT INTO oodNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tsh g Peter am i kekiwua k hab kaij: “Ni‑wepnag, s‑mahch am mant ga hu i wehpeg am ha ahgi g gawul mahs hemajkam g s‑kehg haꞌichu ahgaj g Jiosh ab amjed g Jesus nat pi g Jiosh am i ni‑gawulkai mant hab wo juh. ");
INSERT INTO oodNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Jiosh o s‑mahch g oꞌodham chegitoi ch ab ep ha mah g Hekia S‑apꞌekam Gewkdag hab wa masma mat ahchim hab t‑juh. ");
INSERT INTO oodNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kuch heg hekaj s‑mahch mo s‑ha hoꞌigeꞌelid ch gam hu hab i juh g pi ap ha‑chuꞌijig mat ab i s‑wohoch g haꞌichu ahgaj. ");
INSERT INTO oodNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Pegih, m haschu ahgch haꞌi piꞌichud g Jiosh ab s‑wehch haꞌichu ha mohtoꞌidch g wechij wohochuddam? Ahchim Tutuligo att pi shaꞌi t‑nako machs wehs am hab wo junihid g t‑chehanig. T g t‑shohshon hab waꞌap pi shaꞌi e nako. ");
INSERT INTO oodNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pi attki hab masma wo t‑doꞌibia. Heg at wo waꞌi t‑doꞌibia t‑kownalig Jesus. Ab att i s‑wohoch g haꞌichu ahgaj. T heg ab i s‑t‑hoꞌigeꞌid k t‑doꞌibia. Pegih, t hab waꞌi masma wo e doꞌibia idam gawul mahs hemajkam.” Neh, bash kaij g Peter. ");
INSERT INTO oodNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Sh am hahawa ha ahgid g Barnabas ch Paul mat haschu s‑hasigam hab juh g Jiosh gewkdagkaj am ha shahgid g gawul mahs hemajkam. Kush wehsijj ab wabsh i pi shahmuni ch am ha kaiham. ");
INSERT INTO oodNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tsh am i haꞌasa neneo. Tsh g James am i kuhgi g ha‑ahga mash hab kaij, “Ni‑wepnag, ab g wo i ni‑kaiham. ");
INSERT INTO oodNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Peter o am t‑ahgid matsh has masma g Jiosh am chehgi mo pihk e elid ha hekaj g nahnko mahs hemajkam ch am haꞌi i ha gawulkai mat d wo hemajkamgajk. ");
INSERT INTO oodNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","K id am wohokamchud mat wa has i masma an oꞌoha g kekelibad Jiosh haꞌichu i tashogiddam mash wa hab kaij g Jiosh: ");
INSERT INTO oodNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Neh, e at padch g Davidbad kownaltalig. K wabshaba ab him g tash mant am ep wo i apꞌechud k am hema wo i kei g amjedkam am kehkud ed mant heg gahi wuhshanim wo i himch g kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","T g nahnko mahs hemajkam ab wo i ni‑gahghi. Hegam ani ab i ha waid mat d wo ni‑hemajkamgak.’ ");
INSERT INTO oodNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Neh, bo kaij g Jiosh ch heg am i t‑tashogid heki hu waꞌi amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Kuni hab ep s‑cheꞌimk mani hab hi elid matt pi ab hu wo ha mohtoꞌi g t‑chehanigkaj hegam gawul mahs hemajkam mat ab i e nohnogi Jiosh wui. ");
INSERT INTO oodNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tt hi wabsh wo ha ahgi mat has wo e junihid. T hab ab ha wui wo si s‑ap e tahtkkad hegam t‑wehm oꞌodham mo am ha wehm kihdag. Tt wabsh wo ha cheha mat wo si e nuhkud g hejel e‑wehm kihkam wehhejed ch pi ab hu wo ihm hab masma mo d Jiosh hegai mo pi d Jiosh haꞌichu koꞌadch mo ab e toꞌid ha wui k pi wo koꞌad g ehꞌed ch hegai mo pi gam hu e iawua g ehꞌed e mumꞌajch. ");
INSERT INTO oodNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Id o wehsko si s‑ap s‑e mahch no pi an ahgachug wehs kihhim ch ed ch am e neꞌokchulid t‑wehm oꞌodham ha‑chechopi ed.” ");
INSERT INTO oodNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tsh idam Jesus chuhchai ch geꞌeged am i apꞌech am wehs ha wehm hegam mash ab ihm g Jesus amai matsh am haꞌi wo i ha chuhcha. Tsh idam am wo i ha oi g Paul ch Barnabas am Antiok wui. Sh idam d ha‑chuhchai Judas Barsabbas ch Silas nash pi g hemajkam ab si has ha elid. ");
INSERT INTO oodNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kutsh ab ha mah g oꞌohana matsh wo bek am Antiok wui. Sh hab chuꞌig ihda oꞌohana: “T‑naipijju mam d gawul mahs hemajkam ch ab ihm g Jesus ch ab kihdag Antiok t ab ch Syria t ab ch Cilicia t ab. B ach si em‑hoꞌigeꞌelid ahchim mach d Jesus chuhchai ch geꞌeged ia Jerusalem t ab. ");
INSERT INTO oodNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Idam Barnabas ch Paul o ab t‑ahgid mat am haꞌi hihi g t‑wehm oꞌodham k am em‑kudu am haꞌichu pi ap em‑ahgidk. Kuch eda wa chum pi shaꞌi ha apꞌechud mat hab wo e juh. ");
INSERT INTO oodNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","Kutt heg hekaj wehsijj ia t‑hemapad k am i apꞌech matt has wo t‑juh. B o si i s‑ap e dagitokch idam Barnabas ch Paul am chikpanaj ed g t‑kownalig Jesus Christ ch hekaj chum alo e koꞌij. ");
INSERT INTO oodNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kutt gohk ep i ha chuhcha mat am wo i ha oid k si s‑ap wo em‑ahgi mach haschu i em‑oꞌohanid. K d idam Judas ch Silas. ");
INSERT INTO oodNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","T am i t‑tashogi g Hekia S‑apꞌekam Gewkdag mattki pi ab hu wo i em‑mohtoꞌi g t‑chehanig ahchim Tutuligo k wabsh wo em‑ahgi ihda mamt am hab hi wo wa junihid. T hab wabsh si s‑ap wo e tahtkkad em‑wui hegam t‑wehm oꞌodham mo am em‑wehm kihdag. ");
INSERT INTO oodNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Neh, pi amt wo koꞌad g ehꞌed ch hegai mo pi gam hu e iawua g ehꞌed e mumꞌajch ch pi wo koꞌad hegai mo ab e toꞌid mo haschu hab chum e elid mo d jiosh. Mt wo si e nuhkud g hejel e‑wehm kihkam wehhejed. Mamtp wo si e nuhkud id ab k am wo wa s‑apꞌek. T g Jiosh am wo wa em‑wehmajk.” ");
INSERT INTO oodNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kutsh am hahawa gam hu hihi idam Barnabas ch Paul ch Judas ch Silas k gam hu dada Antiok t am. Tsh am i e hemapai hegam mash ab ihm g Jesus. Kutsh am i ha mah g oꞌohana. ");
INSERT INTO oodNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tsh idam am neꞌokchulid k si s‑ap i e taht natsh pi heg hekaj ab si i e gewkemhu. ");
INSERT INTO oodNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Kush g Judas ch Silas hab waꞌap d Jiosh haꞌichu i tashogiddam ch am dadkkahim heꞌes i tash ch muꞌi haꞌichukaj am i ha gewkemhu. ");
INSERT INTO oodNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kumtsh am hahawa s‑ap i ha dagito mat wo uhpam hihi. ");
INSERT INTO oodNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Tsh wabshaba g Silas hab i e ah mat wabsh ha wehm wo dakad. ");
INSERT INTO oodNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Sh g Paul ch Barnabas heꞌes i tash am dadkkahim Antiok t am am ha jehnigidch ab amjed g Jesus. Sh muꞌijj hab waꞌap ha ahgid g haꞌichu ahga ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Sh am hu hebai amjed, sh hab kaij g Paul ab Barnabas wui, “Am att ep wo hihim k am wo i ha gewkemhu wehs kihhim ch ed mach wa hebai ahgachug g Jiosh haꞌichu ahga k am wo ha nei mas has waꞌi masma.” ");
INSERT INTO oodNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Kush g Barnabas hab chum kaij mat wo bek g John Mark. ");
INSERT INTO oodNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Tsh wabshaba g Paul pi hohhoꞌi mat wo bek nat pi wa am wabsh i ha dagito Pamphylia t am k pi am hu ha wehm i nahto g chikpan. ");
INSERT INTO oodNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kutsh id am si pi ha apꞌet. Tsh hekaj i e gawulkai. Kutsh g Barnabas bek g Mark k gan hu aigo i shul geꞌe wahlkokaj Cyprus jewed t am. ");
INSERT INTO oodNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Tsh wabshaba g Paul g Silas am epai bek mat wo oi. Kumtsh am e hoꞌigeꞌidahun k am i ha dagito Jiosh hemajimatalig ed. ");
INSERT INTO oodNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tsh idam Paul am hihi Syria ch Cilicia jejewed oidk k am i ha gewkemhunahim hegam mash ab ihm g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Kutsh hegam Paul am hahawa hihi Derbe kihhim wui k amjed gam hu dada Lystra kihhim t am. Kush eda amai am hema kih g wechij oꞌodham ch am oid g Jesus himdag ch hab chehgig Timothy. K g jeꞌej hab waꞌap am oid g Jesus himdag ch d Tuhligo uwi. Sh wabshaba g ohgbadaj d Greek hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Sh wehsijj g Jesus ihmdam am Lystra t am ch Iconium t am am si wehhejed neok g Timothy. ");
INSERT INTO oodNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Tsh g Paul s‑behim g Timothy e wehm. Sh eda wehs s‑mahch g Tutuligo amai mat g ohgbadaj pi pahl hikuch g Timothy. Tsh heg hekaj g Paul an pahl hikuch k hahawa bek. ");
INSERT INTO oodNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kutsh am hihim k hebai i daiw kihhim t am ch am ha ahgid hegam mo ab s‑wohochud g Jiosh haꞌichu ahga hegai matsh ha oꞌohani g Jesus chuhchai ch geꞌeged am Jerusalem t am k hab ha ahgid mat s‑ap am hab wo chum junihid. ");
INSERT INTO oodNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tsh am i muꞌida hegam mash am e wehm e mihshmad wehs kihhim ch ed. Tsh g ha‑wohochudadag am i gewka. ");
INSERT INTO oodNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tsh am gahi wuwha g Phrygia jewed ch Galasia jewed idam Paul k am ahgahim g haꞌichu ahga ab amjed g Jesus. Tsh wabshaba pi ha hiwigi g Hekia S‑apꞌekam Gewkdag mas am wo i ahgahi am Asia jewed ch ed. ");
INSERT INTO oodNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Tsh gam hu dada mo an i chekshani g Mysia jewed k hab chum i e ah mat imhab uhpam wo hihi Bithynia jewed wui. Tsh wabshaba ep pi ha hiwigi g Hekia S‑apꞌekam Gewkdag. ");
INSERT INTO oodNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tsh hekaj gam hu gahi hihi Mysia jewed oidk k gam hu dada Troas kihhim t am. Kunt am ha nam ahni Luke. ");
INSERT INTO oodNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tsh g Jiosh am haꞌichu hab juh nenaj ed g Paul. Sh am hema neid g Macedonia jewed t am oꞌodham. Kush id ab kehk ch hab kaij, “Ab g i hihm Macedonia wui k wo i t‑wehmt.” ");
INSERT INTO oodNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","T g Paul am hahawa t‑ahgi ihda. Kuch hab kaij moki tatchua g Jiosh matt am wo hihim k am wo i ha ahgidahi g haꞌichu ahgaj. Tt am ha hekaj i t‑nako matt am aigo i chehchsh Macedonia jewed t am. ");
INSERT INTO oodNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kutt an ha hekaj gahi i shul g geꞌe shuhdagi geꞌe wahlko ch ed k ga hu dada Samothrace kihhim t ab. Am baꞌich d i tash, tt am dada Neapolis kihhim t am ");
INSERT INTO oodNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","k amjed gam hu baꞌich i wahp mo am d Philippi kihhim amai wehpeg chekshani ch ed g Macedonia jewed. Ihda Philippi o d si s‑has haꞌichu. K muꞌi am dadha g si geꞌe kownal shondalig. Kuch am heꞌes i haꞌichugkahim id eda kihhim. ");
INSERT INTO oodNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pi o am hu hema kehk g Tutuligo hemajkam ha‑cheopi. Kutt heg hekaj am hihi mo an ge akimelig kihhim aigo mach hab t‑ahg mo am hu hebai apchudas mo am e hoꞌigeꞌidahun g Tutuligo. K am hebai e hemapaidch g uꞌuwi. Kutt am i dadhaiwua k am ha wehm neneo. ");
INSERT INTO oodNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","K hema hegam uꞌuwi hab chehgig Lydia ch ab amjed g Thyatira kihhim ch d s‑ihbhaimagi lohba gagdadam ch ab si ihm g Jiosh. Jiosh at ab i mah g wohochudadag. Kut ab s‑wohog el g Paul ");
INSERT INTO oodNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","k e pahl wako. T wehs hab waꞌap e juh g wehmaj kihkam. K hab hahawa kaij g Lydia, “Oi g wo t‑oid k am t‑wehm wo i dadhaiwua t‑kih am nach pi d hahawa em‑wehm wohochuddam.” Kutt wa woho hab t‑juh heg hekaj mat pi t‑dagito k ab ep t‑waid. ");
INSERT INTO oodNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Kuch am hu hebai am hihim matt gam hu wo hihi mo am e hoꞌigeꞌidahun. T ab hema i t‑oi g uwi. Kuki g jiawul an uꞌukch ch ab mahkch g amichudadag mo gam hu baꞌich tash haꞌichu ahg. K am haꞌi si uꞌukch ch muꞌi lial uꞌu ab amjed mo am haꞌichu ha ahgid g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","T ihda uwi ab i t‑oid k si hihnk ch hab kaij, “Idam oꞌodham o d piongaj g si uhgchu Jiosh ch am em‑ahgidahim mamt has masma wo e doꞌibia.” ");
INSERT INTO oodNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Neh, bo kaij ch muꞌi tashkaj an t‑oidahim. T am hahawa pi e nako g Paul k ab si sikol i kekiwua k hab kaij ab jiawul wui, “Jesus Christ gewkdagkaj ani ab si m‑chehani mapt wo dagito ihda chehia.” T am wa i hekaj dagito g jiawul. ");
INSERT INTO oodNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","T am i nei hegam mo an uꞌukch mat hahawa pi has masma ep wo uꞌud g lial heg hekaj chehia k hekaj an ha ui g Paul ch Silas k gam hu i ha chewaim hahaꞌichu ha wui. Idam o am dadha si eda g kihhim. ");
INSERT INTO oodNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","K hegam mat am i ha ui g Paul ch Silas hab ha ahg, “Idam o d Tutuligo. Kutt ha cheh mo ha kudut g ia kihkam ");
INSERT INTO oodNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","no pi chum t‑ahgid mash hema d si geꞌe kownal mattsh ab wo chum si has elidad. K eda pi hiwgidas machs hab wo t‑wuad nach pi ab si wecho g Rome kownal. K pi d t‑wuikam ihda haꞌichu ha‑ahga.” ");
INSERT INTO oodNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","T wehsijj hegam mat ab i e hemapai ab i ha wehmt k ab ha wui gegokiwua g Paul ch Silas. T g hahaꞌichu gam hu wuashul g ha‑wehschuga k am haꞌi ha chehani mat wo ha gewitta. ");
INSERT INTO oodNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kumt am i si s‑koꞌokam ha gewittani k ged hu ha uꞌapa kukpaikud wui k hab ahgid g lilso ha nuhkuddam mat si s‑wihnam wo ha kuh. ");
INSERT INTO oodNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","T wa woho hab e juh k ged hu si chuhko ha kuh k an ha wahpki g ha‑kakhio uhs wupulshpadag ed. ");
INSERT INTO oodNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kutsh am eda i huh g s‑chuhugam. Sh g Paul ch Silas am si e hoꞌigeꞌidahun ch si neꞌed ch ab si ihm g Jiosh. Sh am haꞌi ep kuhkpi g lilso ch ha kaiham. ");
INSERT INTO oodNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","T am haha wabsh si s‑gewkam ugij g jewed. Tsh g kukpaikud am si wehs uꞌugij. Tsh gam si e kuhkpiꞌo g kukpaikud kuhkpadag. Tsh g ha‑wupulshpadag e padch. ");
INSERT INTO oodNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tsh ab si i nea g ha nuhkuddam k hab e ahg mat neꞌiopa g lilso k hekaj an bei g is‑pahyo mat wo hejel e mua. ");
INSERT INTO oodNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Sh wabshaba g Paul am si s‑kaidam hihnk ch hab kaij, “Pi g am hejel e muaꞌi. Ia ach wabsh i wehs haꞌichug.” ");
INSERT INTO oodNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tsh am hahawa bei g lahmpa k am si med k am i wahk k si gigiwuk. Sh am wabsh kia dadha g lilso. Kutsh ab i gei ha wecho g Paul ch Silas ");
INSERT INTO oodNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","k ab i ha wuwhasid k ab ha kakke, “Shahnt masma wo ni‑doꞌibia?” ");
INSERT INTO oodNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Sh hab kaij idam Paul, “B apt wo i s‑wohoch g haꞌichu t‑ahga ab amjed g t‑kownalig Jesus Christ. T heg wo m‑doꞌibia. T idam m‑wehm kihkam m ia gegok hab waꞌap wo e juh.” ");
INSERT INTO oodNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tsh idam Paul am hahawa i ha mihshmad ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tsh am ha hekaj i ha uꞌu k ab i wako g ehꞌed mat wa am ha gewitta. Tsh amjed am ha hekaj i e nakog k e pahl‑wapko g e‑wehm kihkam ha wehm ");
INSERT INTO oodNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","k gan hu hahawa i ha wahpki g Paul ch Silas e‑kih ed k ha gegos. Kush si s‑hehgig ihda wehs ha wehm g e‑wehm kihkam no pi ab hahawa wohochud g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Sh am baꞌich d i siꞌalim. Tsh g hahaꞌichu am ha ahgi g chich‑lilihi mat wo ha dagito idam Paul. ");
INSERT INTO oodNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Sh hegai lilso ha nuhkuddam ab ahgid g Paul ch hab kaij, “Ia at gei g ahga ab ha amjed g hahaꞌichu matsh wo em‑dagito. Mt gamai wabsh s‑ap e taht k wo hihi.” ");
INSERT INTO oodNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kush wabshaba g Paul hab kaij ab ha wui g chich‑lilihi, “Pi att hab wo t‑juh. Hemho wa at ab wo i hihi hegam s‑has hahaꞌichu k ia wo i t‑wuwhas am ha tahgio g hemajkam nat pi t‑gewitta am ha tahgio wa chum pi mahchch mas haschu d t‑chuꞌijig. K heg pi d chum t‑wuikam nach pi uꞌukch g t‑shel hab masma mo g Rome t am hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kush g chich‑lilihi am hahawa ha ahgid g s‑has hahaꞌichu mo has kaij. Tsh am i kah ihda k si e totodsid k am hihim ");
INSERT INTO oodNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","k ab ha ahgi mat wabsh wo i s‑ha hoꞌigeꞌel k am hahawa i ha wuwhasid k hab ha ahg mat hig gam hu wo hihi ab amjed g kihhim. ");
INSERT INTO oodNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","T g Paul ch Silas am i wuwhag k gam hu hihi Lydia kih wui. Kut am e nam hegam mat ab i s‑wohoch g haꞌichu ha‑ahga ab amjed g Jesus. T idam Paul ab si i ha gewkemhun k gam hu hahawa hihi. ");
INSERT INTO oodNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tsh idam Paul am wabsh gahi wuwha g Amphipolis kihhim ch Apollonia kihhim k gam hu dada Thessalonica kihhim t am. Sh am hema kehk g Tutuligo ha‑cheopi. ");
INSERT INTO oodNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","3","Tsh heg wui am hihi hegam Paul mo hab wa e wua chum hekid. Tsh g Paul am ha wehm aꞌaga ab amjed g Jiosh oꞌohana k id hekaj am chum wohokamch mat g Jiosh si Kehsha hemho wa wo e shoꞌigchud k wo e muꞌa k wabshaba ep wo i wuhsh ab muhkig t amjed. Sh hab ep kaij, “Ihda Jesus mani ia mahsko wua em‑shahgid d hegai Jiosh si Kehsha.” Sh waik domig oidam am ha jehnigid mihshmda tash ab. ");
INSERT INTO oodNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","5","Kutsh haꞌi ab i s‑wohochud k ab i ha wehmt hegam Paul. Tsh muꞌi hegam Greek hemajkam ch hegam s‑has haꞌichu uꞌuwi mash ab ihm g Jiosh ab hab waꞌap i s‑wohoch g haꞌichu ha‑ahga k ha wehmt. Sh hema idam hab chehgig Jason. Tsh wabshaba haꞌi s‑ha hehgam g Tutuligo. Kush am haꞌi oiopo g s‑papadmakam ch am i ha wehmt hegam Tutuligo k am i ha kudut g kihkam. Kutsh wabsh woho i babgat k am hihim k am wabsh si wahp Jason kih ed mat am wo ha ui g Paul ch Silas k am wo ha uꞌapa hemajkam ha wui. ");
INSERT INTO oodNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","7","Sh wabshaba pi am hu haꞌichug. Kush heg hi wa Jason am da. Kush haꞌi ep dadha g wehmaj wohochuddam. Kumtsh idam ha uꞌu k am i ha chewaim hahaꞌichu ha wui k si hihnk ch hab kaij, “Ia at haꞌi dada g oꞌodham k ash wa wehsko ha kudut g hemajkam ch ab wui gegok g si uhgchu kownal hab kaijch mo am hema d ep kownal ch hab chehgig Jesus. K ihda Jason ab ha toꞌakch e‑kih ab.” ");
INSERT INTO oodNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Neh, bash kaij ch hekaj ab si i ha kudut g hemajkam ch hahaꞌichu mat wabsh wohoꞌi babgat. ");
INSERT INTO oodNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Tsh g hahaꞌichu am cheha g Jason ch hegam haꞌi mat wo ha namkid haꞌakia mo haschu d i ha‑chehanig. Kutsh am hab e juh. Tsh hahawa ha dagito. ");
INSERT INTO oodNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tsh am i s‑chuk. Tsh hegam Jesus ihmdam am ha ahgi idam Paul matsh gam hu wo hihi Berea kihhim wui. Tsh ged hu dada k am ha hekaj hihi Tutuligo ha‑cheopi wui. ");
INSERT INTO oodNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tsh idam s‑ap ab i ha nei. Sh am ha mihshmad. Kush si s‑hohhoꞌid ch ab kaiham g haꞌichu ha‑ahga ch wehs tashkaj am si hoan g Jiosh heki hu oꞌohana mat wo s‑mai mas wa woho hegai mash g Paul am ha ahgid. ");
INSERT INTO oodNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tsh muꞌijj ab i s‑wohoch g Tutuligo. Tsh muꞌijj g gawul mahs hemajkam hab waꞌap ab i s‑wohoch. Haꞌi idam ash d s‑has hahaꞌichu uꞌuwi. ");
INSERT INTO oodNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tsh am wabsh i chum kah g Tutuligo am Thessalonica t am mash idam Paul am ha mihshmad Berea t am hab wa ehp k am ha hekaj i hihim k am i ha kudu g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kutsh heg hekaj am ahgi g Paul hegam mash ab s‑wohochud mat gam hu wo hih ge kahchki hugidgo. Tsh wabshaba g Silas am waꞌi wih Berea t am g Timothy wehm. ");
INSERT INTO oodNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tsh hegam matsh am i bei g Paul gam hu uꞌapa Athens kihhim t am. Tsh am hahawa ha ahgi g Paul mat wo ha ahgi g Silas ch Timothy mamt hekid wo i e nakog k ab ha hekaj wo i hihi. Tsh amjed gam hu hahawa uhpam hihi idam e‑kihhim wui. ");
INSERT INTO oodNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Sh am daha g Paul Athens t am ch am ha nenida g Silas ch Timothy. Sh eda wehsko chuhch g ha‑jijoshta. Sh g Paul am ha neid idam ch hab si pi ap e tahtk. ");
INSERT INTO oodNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","18","Tsh am wabsh apꞌet mat ha wehm wo si i aꞌaga g hemajkam am ha‑cheopi ed. Kush am haꞌi ha wehm e mihshmad g gawul mahs hemajkam. Sh g Paul am epai kuaya ch ed ha wehm haꞌichu i aꞌaga ab amjed g Jesus am ha ahgidch mat g koꞌi wo i wuwha ab muhkig t amjed. Sh am haꞌi d jewed t ab haꞌichu s‑chu aꞌamichuddam ch wabsh ab uhpam i neꞌowi g Paul. Sh haꞌijj hab kaij, “K haschu hab chum ahg ihda pi haꞌichu amichuddam oꞌodham?” Kush haꞌi hab ep kaij, “Shahag wepo mo g mehk jewed dahm jijosh am ha aꞌaga.” ");
INSERT INTO oodNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","21","Kush eda hegam kihkam ch hegam mo am wabsh sha dadha s‑hohhoꞌid mat tash oidam wo kaihamad ch wo aꞌagad hegai mo haschu d si wechij ahga. (19) Kumtsh ab i bei g Paul k ged hu uꞌapa mo am e nanmek k hab kaij ab wui, “Shahꞌo d ahga ihda wechij mashchama map ab amjed neok. (20) Pi ach am wa chum amichud.” ");
INSERT INTO oodNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tsh am hahawa kekiwua g Paul k hab kaij, “Ahpim kihkam amki ab si has ha elid g jijosh. ");
INSERT INTO oodNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Am ani neid m an chuhch g em‑jijoshta kahya oidk. Kuki am hema kehk g iagchulidakud mo id an oꞌohanas, ‘Ia amt wo haꞌichu dai heg wehhejed jiosh mattp hems pi mahch.’ Pegih, ihda pi em‑machiga o d hegai mant am haha wo em‑ahgi ab amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Do ihda Jiosh mat wehs haꞌichu nahto ch d kownal wehs haꞌichu dahm. Wehsko o an haꞌichug g Jiosh. K pi hab shaꞌi mahs mas am hebai wabsh wo e dai hab masma mam hab ha wua g e‑jijoshta. ");
INSERT INTO oodNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Jiosh o ab t‑mahkch g doakag ch wehs haꞌichu. K pi am hu haꞌichu d shaꞌi hegai mas ab i si tatchua ab amjed g oꞌodham mat ab wo mah chikpank. ");
INSERT INTO oodNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Jiosh at am hemako nahto g oꞌodham k ab amjed i wuhshad g wehs nahnko mahs hemajkam k an aꞌai i ha gantad wehsko jewed oidk mat hebai heki hu i apꞌech mat an wo kihkad. ");
INSERT INTO oodNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","K hab d elidaj mat am wo i e gahgidahi g Jiosh k atp hems wo cheh. Pi o shaꞌi mehk ab hema i t‑amjed ");
INSERT INTO oodNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ch ab t‑mahkch g doakag ch kihdag. Haꞌijj g em‑wehm oꞌodham o d haꞌichu aꞌamichuddam ch hab kaij, ‘Ahchim hemajkam ach d Jiosh aꞌaliga.’ ");
INSERT INTO oodNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Pegih neh, id o d wohokam mach d aꞌaligaj g Jiosh. Tt pi hab wo ge t‑ahgad mas g wohokam Jiosh hab mahs mo idam em‑jijoshta mat wabsh g oꞌodham am nahto g ohlakaj o g plahdakaj o g hodaikaj. ");
INSERT INTO oodNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Heki o hu pi mahch g hemajkam g Jiosh tatchui. K g Jiosh si s‑hemajim am ha nakog. Ni wabshaba hemu em‑ahgid mo hahawa ab si i ha chehani g hemajkam wehsko mat gam hu wo s‑ohhod g pi ap e‑chegitoi. ");
INSERT INTO oodNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Am at i apꞌech g tash mat wehs wo ha lodai g hemajkam k heki hu am hema si i kei mat hab wo juh g lodaita. Tsh id ia mahsi t‑shahgid k ia oimmelhim ch e muhkid. Tsh g Jiosh ab i wuhshad muhkig t amjed mat wo wohokamch mo d si Kehshaj.” Neh, bash kaij g Paul. ");
INSERT INTO oodNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tsh idam am i kah mo hab kaij matsh hema i wuhsh ab muhkig amjed. Kush haꞌijj wabsh si ash ch wabshaba haꞌi hab kaij, “Am g wa ep t‑jehnigid ab amjed ihda.” ");
INSERT INTO oodNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tsh amjed gam hu hahawa hih g Paul. ");
INSERT INTO oodNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tsh haꞌi ab s‑wohochud k ab i wehmt. Sh hema idam d Dionysius ch d hema hegam s‑chu aꞌamichuddam. Kush am hema d ep uwi ch hab chehgig Damaris. ");
INSERT INTO oodNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Tsh gam hu hahawa hih g Paul ab Athens t amjed k am him k am jiwia Corinth kihhim t am. ");
INSERT INTO oodNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Sh am hema daha g Tuhligo ch hab chehgig Aquila ch ab d mahsikam Pontus t ab. K g wehmaj kihkam hab chehgig Priscilla. Idam o d ikus kihtdam. Kutsh hab wa e juh am ha tahgio matsh g geꞌe kownal Claudius gam hu ha huhuꞌi Tutuligo ab amjed g Rome kihhim. Sh idam Aquila ch Priscilla am ahhio Corinth wui. ");
INSERT INTO oodNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Tsh g Paul am i ha chehgim k am ha wehm i dahiwua k am ha wehm chikpan no pi hab d waꞌap ikus kihtdam. ");
INSERT INTO oodNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kush wehs mihshmda tash am hihim Tutuligo ha‑cheopi wui mat am wo haꞌichu i ha tashogi ab amjed g Jesus. Kush am haꞌi ep ha wehm e mihshmad hegam mo pi d Tutuligo ch am kah g haꞌichu ahgaj. ");
INSERT INTO oodNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kutsh am i dada g Silas ch Timothy ab Macedonia jewed t amjed. Tsh g Paul am hahawa i dagito g e‑chikpan k heg am himch matsh am hahawa si i ha mihshmad am si s‑mahch ch ahg ab ha wui g Tutuligo mo g Jesus d Jiosh si Kehsha mat wo t‑doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Tsh wabshaba ab wui gegokiwua idam k am si pi ap has ahg. Tsh oi wa g Paul ab si i shahmud g e‑wehschuga ha wui mat wo ha chehgi mat ha dagito k hab kaij, “Dat wo hejel em‑chuꞌijigk mamtp wo sha pi e doꞌibia. T ahni pi ab hu haꞌichu d wo ni‑chuꞌijigk. Nt iaꞌi amjed g gawul mahs hemajkam ab wo i ha mihshmad.” ");
INSERT INTO oodNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Neh, tsh iaꞌi dagito g ha‑cheopi k ged hu hahawa ha mihshmad g hemajkam hema kih am g gawul mahs oꞌodham. Id ash ab ihm g Jiosh ch hab chehgig Titius Justus ch an kih hugidaj an g Tutuligo ha‑cheopi. ");
INSERT INTO oodNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kutsh muꞌi ep ab i s‑wohoch am i kahk k am e pahl wapko. Hema ash d chum ha wanimeddam g Tutuligo ch hab chehgig Crispus ch ab i s‑wohoch g e‑wehm kihkam ha wehm. ");
INSERT INTO oodNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Tsh am hu hebai chuhug ch ed am haꞌichu hab e juh Paul nena ed mash kah g Jesus. Kush ab wui hab kaij, “Pi g am shaꞌi haꞌichu ehbidad. Ia ani m‑wehmaj ch pi hedai wo shai hiwigi mas wo s‑koꞌokam m‑juh. Pi g shaꞌi haꞌasa ha mihshmad. Muꞌijj o ia kih id eda kihhim mat d wo ni‑hemajkamgak.” ");
INSERT INTO oodNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Sh heg hekaj hemako ahidag ch eda hugkam ehp am haꞌichugkahim ch am ha mashcham g Jiosh haꞌichu ahga. ");
INSERT INTO oodNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tsh am hahawa hema i dahiwua g kownal am Greek hemajkam ha‑jewedga am k hab chehgig Gallio. Tsh g Tutuligo am i e hemapad k an bei g Paul k am uꞌapa geꞌe kih t am ");
INSERT INTO oodNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","k hab kaij, “Ihda oꞌodham o chum ha chehani g hemajkam mat hab masma ab wo i ihmad g Jiosh mam has masma pi t‑hiwgid.” ");
INSERT INTO oodNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kutsh am haha wabsh wo i chum neo g Paul. Sh wabshaba Gallio hab ha ahg, “Pi oki ab wui kehk g geꞌe kownal chehanig. T heg hekaj pi wo ni‑apꞌet mant ab wo em‑kaiha. ");
INSERT INTO oodNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Doki wabsh haꞌichu ahga ab amjed g em‑himdag ch ab hema i amjed g em‑wehm oꞌodham. Mt heg hekaj am hejel wo i apꞌech. Pi ant am hu wo shaꞌi i hudaw hab mahs haꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Neh, bash kaij ch gam hu si i ha wuwhas geꞌe kih amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kutsh idam an wabsh si bei hegai mash d ha wanimeddam am cheopi ch ed ch hab chehgig Sosthenes k am si gewitta geꞌe kih bahsho. Tsh pi ab hu has shaꞌi e taht g Gallio. ");
INSERT INTO oodNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Sh muꞌi tash am haꞌichugkahim g Paul Corinth kihhim t am ha wehm hegam mash ab s‑wohochud g Jiosh haꞌichu ahga. Tsh amjed hab i e ah matsh gam hu uhpam wo hih Syria jewed wui. Sh eda gam hu hihhim g geꞌeged wapalko Cenchrea kihhim t amjed. Kutsh gam hu hih g Paul. Tsh g Priscilla ch Aquila gm hu oi. Tsh koi am hu i chehchsh geꞌe wahlko ch ed, tsh g Paul hih g e‑moꞌo matsh wa am heꞌes i tash pi hih mo d ha‑himdag heg hekaj mat ab haꞌichu ahꞌad g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tsh am hahawa gahi i shul g geꞌe wahlkokaj k ga hu dada Ephesus kihhim t am. Kutsh am i dadhaiwua g Priscilla ch Aquila. Tsh g Paul am hih mat am wo sha i wah Tutuligo ha‑cheopi ed k am ha wehm haꞌichu aꞌaga. ");
INSERT INTO oodNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Sh idam ab ahgid mat am wabsh wo i wih ha wehm. Tsh wabshaba pi e nako ");
INSERT INTO oodNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","k ash hab wabsh ha ahg am wo i himk, “Matp g Jiosh d wo tatchuik, nt wo wa uhpam ep jiwia.” Neh, bash kaij ch amjed ab i chesh geꞌe wahlko t ab. ");
INSERT INTO oodNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Tsh heg gam hu gahi i gei Cesaria kihhim t am. Tsh amjed gam hu hahawa hih g Paul Jerusalem wui k am i ha chehgim g e‑wehm wohochuddam. Am heꞌes i tash, tsh gam hu hahawa ep gahi i chesh Antiok t am. ");
INSERT INTO oodNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Sh am heꞌes i haꞌichugkahim amai ch am hahawa ep ha dagito k atsh gam hu hahawa ep hih ha oidk g Galasia ch Phrygia jejewed k am i ha gewkemhunahim g e‑wehm wohochuddam. ");
INSERT INTO oodNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tsh am hema jiwia g Tuhligo Ephesus kihhim t am k hab chehgig Apollos ch ab d mahsikam Alexandria kihhim t ab ch si s‑e mahch ab s‑neokimakam t ab ch ash si geꞌe s‑mahch g Jiosh oꞌohana. ");
INSERT INTO oodNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kumtsh heki hu mashcha ab amjed g Jesus. Kush si s‑hohhoꞌid ch am ahgahim ch si s‑ap ha mashcham ch eda heg waꞌi s‑mahch John pahl wakona. ");
INSERT INTO oodNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Tsh am i kah hegam Priscilla ch Aquila nash pi am si ha mihshmad Tutuligo ha‑cheopi ed. Tsh idam am i wai e‑kih wui k am s‑ap ahgid mo haschu i koi s‑mahch ab amjed g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kutsh hab hahawa i e ah g Apollos mat am wo hih Greece jewed wui. Tsh am i wehmt hegam mash ab s‑wohochud g s‑kehg haꞌich ahgaj g Jiosh ch am kih Ephesus t am k am ha oꞌohani g e‑wehm wohochuddam amai Greece ch ed k ab si ha ahgid mat s‑ap ab wo i nei g Apollos. Tsh gam hu jiwia k ab si geꞌe i ha wehmt. ");
INSERT INTO oodNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Sh am haꞌi neꞌowin g Tutuligo. Tsh wabshaba am ha gewito am ha‑kaichudch g muꞌi hemajkam k am si i wohokamch heg hekaj Jiosh oꞌohana mo g Jesus d Jiosh si Kehsha mat wo ha doꞌibia g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Tsh gam hu baꞌich ep hih g Paul k ged hu jiwia Ephesus t am mo eda g Apollos am oimmed Corinth t am. Kush am haꞌi kih ch ab chum s‑wohochud g Jiosh haꞌichu ahga. ");
INSERT INTO oodNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Sh g Paul ab ha kakke, “Namt am wa bei g gewkdag ab amjed g Hekia S‑apꞌekam Gewkdag mamt hekid ab i s‑wohoch g Jiosh haꞌichu ahga?” Sh hab kaij hegam, “Pi ach koi hebai shaꞌi kah mas am haꞌichu d Hekia S‑apꞌekam Gewkdag.” ");
INSERT INTO oodNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Sh hab hahawa kaij g Paul, “A namt koi e pahl wapko g Jesus pahl wakonakaj?” Sh hab kaij, “Pi koi. Johnbad pahl wakonakaj att t‑wapko.” ");
INSERT INTO oodNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Sh hab hahawa ep kaij g Paul, “M o wa woho mash heg am ha ahgid mat gam hu wo s‑ohhod g pi ap e‑chegitoi ch wabshaba am ep ha ahgid mat ab wo i s‑wohoch hegai mat am epai wo i e maskogi. K heg d Jesus.” ");
INSERT INTO oodNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tsh idam ab i s‑wohochud k e pahl wapko ab chehchegch g Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Tsh g Paul an i ha tahtamahim k ab ihmahim g Jiosh. Tsh ab si i bei g gewkdag ab amjed d Hekia S‑apꞌekam Gewkdag k am si gawul neꞌokikaj neneok mat pi hebai mai ch am ahg g Jiosh haꞌichu ahga. ");
INSERT INTO oodNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kush am hu d i gamai gohk idam chechoj. ");
INSERT INTO oodNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Sh am wapke g Paul Tutuligo ha‑cheopi ed ch am ha wehm haꞌichu si i aꞌaga waik mashad ab chum s‑ap s‑ha mahtchudamk ab amjed g Jiosh kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Tsh wabshaba haꞌi pi wohochud k wabsh si pi ap neneok ab amjed g Jesus himdag am ha kaichudch g hemajkam. Tsh heg hekaj am ha dagito g Paul k gam hu hih ha uꞌuk hegam mat ab i s‑wohoch. Sh am hema d Tyrannus ch ge mashchamakud ch id ha hiwigi. Kush heg eda g Paul am ha wehm aꞌaga g Jiosh kownaltalig wehs tashkaj ");
INSERT INTO oodNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","gohk ahid ab. Tsh wehsko e kah g Jesus ahga heg eda Asia jewed. ");
INSERT INTO oodNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kush g Jiosh am si i wehmaj g Paul mash am hab junihim g s‑hasigam haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Sh g hemajkam chum hems ab uꞌu g Paul haꞌichu eniga ch hekaj ab tattam g kokꞌodam. Kush ha dodad. Tsh g jijawul im hu hab wo i e juh ab ha amjed hegam mo an ha uꞌukch. ");
INSERT INTO oodNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Sh eda an haꞌi ep oiopo g Tutuligo ch hab chum e wua mo im hu hab i ha wua g jijawul ab ha amjed g hemajkam. Kush am hema g uhgchu pahl hab chehgig Sceva ch wewaꞌak aꞌalidag. Sh idam hab waꞌap chum im hu hab i ha wua g jijawul ab ha amjed g hemajkam. Am hu hebai, sh idam am hema neid g oꞌodham mash g jiawul an uꞌukch ch hab kaij, “Ab g i dagito ihda oꞌodham, ahpi jiawul. Bani si m‑ahgid heg gewkdagkaj Jesus mo g Paul ab amjed ha mihshmad.” ");
INSERT INTO oodNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Sh wabshaba hab kaij g jiawul ab ha wui, “S‑mahch ani g Jesus ch ep s‑mahch mo hedai wud hegai Paul ch wabshaba ahpim pi shaꞌi em‑mahch mams hedai wud.” ");
INSERT INTO oodNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kutsh ihda cheoj mo g jiawul an si uꞌukch haha wabsh ha dadge k s‑koꞌokam ha juh. Tsh gam hu neꞌiopa ab amjed g kihj k d wabsh i ehꞌed. K g ha‑wehschuga wantshas. ");
INSERT INTO oodNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kutsh wehsijj kah ihda amai Ephesus t am k atsh si s‑ehbeni k ab si has i el g t‑kownalig Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tsh muꞌijj hegam matsh ab i s‑wohoch s‑kehg haꞌichu ahga ab amjed g Jesus am i e hemapad k mahsko wua g pi ap e‑chuꞌijig am wehs ha tahgio g hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Tsh muꞌijj hegam mash hab chum e elid mo d mamakai am uꞌapa hegam e‑oꞌohana mo an ahgas g hihoina k am ha chehgid k ha mei. Tsh eda am i kuint g ha‑namkig idam oꞌohana mash am mei. Kutsh ai g hetaspo wehst‑mahm mihl pihsh (50,000). ");
INSERT INTO oodNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kutsh hab masma hekaj si s‑gewkam am i hih g haꞌichu ahga ab amjed g Jesus k am i e gantad. Sh g hemajkam baꞌich i s‑gewkam ab uꞌukch. ");
INSERT INTO oodNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tsh amjed hab i e ah g Paul matsh gam hu wo hih Macedonia ch Greece jejewed oidk k amjed gam hu haha wo hih Jerusalem wui k amjed am Rome wui wo hih. ");
INSERT INTO oodNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kush eda g Timothy ch Erastus am wehmaj. Kush am ha ahgid g Paul matsh am wo hihi Macedonia wui. Tsh g Paul am wih Asia ch ed heꞌes i tash. ");
INSERT INTO oodNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kutsh iaꞌi idani am i e kudu g hemajkam ab Ephesus t ab heg hekaj Jesus himdag. ");
INSERT INTO oodNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Amai ash am hema kehk g geꞌe cheopi. Kush am eda e kehshch g uwi ha‑jioshga ch hab chehgig Artemis. Kush am hema d plahda chikpandam ch hab chehgig Demetrius. Sh id pionag g plahdakaj ha nahto g al kihki mo heg wepogidas cheopi ch muꞌi nahto g lial ha gagdadch. ");
INSERT INTO oodNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kutsh g Demetrius am i ha hemapai hegam mash hab waꞌap mahs chikpan hab wua k am si s‑gewkam hab kaij ab ha wui, “Ni‑naipijju, s‑mahch am mo g s‑t‑kaistalig ab him id amjed chikpan. ");
INSERT INTO oodNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kum eda si neid ch ep kah ihda hab chehgi Paul mo hab kaij mo idam t‑jijoshga pi d shaꞌi jijosh. T hab am gawul juh g e‑chegitoi g muꞌi hemajkam ab i s‑wohochudk iia Ephesus t am ch chum alo wehsko am Asia jewed oidk. ");
INSERT INTO oodNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kut wo e padch g t‑chikpan nat pi pi ab hu hab masma wo e ihmad g Artemis mo hemuch wehsko ab si e ihm. T g cheopigaj pi ab hu wo e haꞌichuch.” ");
INSERT INTO oodNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Tsh am i kah idam mat am e hemapai k atsh si babgat k si s‑kaidam hihnk ch hab kaij, “B ach si has elid g t‑jioshga Artemis.” ");
INSERT INTO oodNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Sh wehsko kaidag g ha‑hihinki ch wehs ha babgach g kihkam. Tsh gohk ha ui hegam mash am wehmaj g Paul k am ha uꞌapa chichwikud ed. Hegam mamtsh ha ui ash d Gaius ch Aristarcas. ");
INSERT INTO oodNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Tsh g Paul am chum s‑wahkim ha shahgid. Tsh wabshaba g wehmaj wohochuddam pi hiwigi. ");
INSERT INTO oodNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Tsh haꞌi hegam mash d hahaꞌichu ch d naipijjuj g Paul hab waꞌap ahgid matsh pi am hu wo hih mamt am i ha ui idam gohk. ");
INSERT INTO oodNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tsh eda heg oidam am i si e gewkai g kudutadag. Sh haꞌijj si hihnk has i kaidam. Sh haꞌi am wa gawul haꞌichu ep hihnk heg hekaj mash muꞌijj pi shaꞌi mahch mas haschu ahgch ia e chehm. ");
INSERT INTO oodNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Tsh g Tutuligo am hema i kei mat am wo him k ab wo i kekiwua ha wehhejed k am wo ha ahgi mo pi d ha‑chuꞌijig g Tutuligo. Id ash hab chehgig Alexander ch am wabsh i chum ha baꞌich i kekiwua mat am wo neo. ");
INSERT INTO oodNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tsh am i nei g hemajkam mo d Tuhligo k pi ab hu shaꞌi kaiham k wabsh si hihnk e wehm am hu i gohk ohla ab hab kaijch, “B ach si has elid g t‑jioshga Artemis.” ");
INSERT INTO oodNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tsh g s‑has haꞌichu oꞌohandam ha shohbi g hemajkam ash hab kaijch, “Ahpim kihkam! Wehsijj am s‑mahch mo ia Ephesus t am e nuhkud g cheopigaj g si s‑has haꞌichu t‑jioshga Artemis ch ia ep e nuhkud hegai hodaigaj mat ab dahm kahchim t amjed i gei. ");
INSERT INTO oodNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","T pi hedai hab wo shaꞌi chei mas pi woho ihda. Kumt ab wabsh wo i e bahbgi k pi am hu haꞌichu wabsh wo si has juh. ");
INSERT INTO oodNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Neh, mamt i ha uꞌapa idam oꞌodham. T eda pi haꞌichu shaꞌi ha ehs ab cheopi t amjed, niꞌis am hu shaꞌi pi ap has ahg g t‑jioshga. ");
INSERT INTO oodNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Neh, k am dadha g hahaꞌichu lodaita tash ch ed. Kut idam Demetrius am haꞌab wo ha uꞌapa matp ab haꞌichu wo s‑ha abchudam. ");
INSERT INTO oodNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","K am ep e nanmek g kihkam ch haꞌichu i aꞌaga ch am i apꞌechud. Kumt am wo uꞌapa mamtp haꞌichu ep tatchua. ");
INSERT INTO oodNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","T hahawa pi ab hu wo t‑abch g kownal machs wabsh t‑cheggia heg hekaj mat haschu has i e juh id tashkaj. Kutt pi wo shaꞌi t‑nako machs wo ah mat haschu ahgk hab e juh haꞌichu.” ");
INSERT INTO oodNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Neh, bash kaij ch ha dagito. ");
INSERT INTO oodNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Tsh am i dodolimat haꞌichu. Tsh g Paul am i ha hemapai g e‑wehm wohochuddam k am si i ha gewkemhun k am hahawa ha dagito k gam hu aigo i chesh Macedonia t am ");
INSERT INTO oodNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","k am heg oidk i ha gewkemhunahi muꞌikpa ha mihshmadk. Am heꞌes d i tash, t ia jiwia Greece jewed t am ");
INSERT INTO oodNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","k ia haꞌichugkahim waik mashad. T am hebai i cheka, t am hahawa i chum e nako mat am aigo i chesh Syria jewed wui. Tsh wabshaba g Tutuligo am i e nako mat wo be k wo mua. T hekaj hab i e ah mat am uhpam ep wo hih Macedonia wui. ");
INSERT INTO oodNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tsh haꞌi oi g Paul mat gam hu hih. Hema o d Sopater ch ab Berea t amjed ch d alidaj g Pyrrus. K haꞌi ep d Aristarcas ch Secundus ch ab Thessalonica t amjed. Tki hegai Gaius mo ab Derbe t amjed ch Timothy am ha oi. Tki hegam ep ha oi Tychicus ch Trophimus mo ab amjed g Asia jewed. ");
INSERT INTO oodNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","T ia dada Philippi kihhim t am. Ni ahni Luke ia wabsh kia haꞌichug ch am hahawa oi g Paul. T wabshaba hegam haꞌi iꞌajed gam hu t‑baꞌich i chehchsh Troas kihhim wui matsh am wo t‑nenida. ");
INSERT INTO oodNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","T eda e ai mat g Tutuligo wuhshad g e‑shohshon ha‑doꞌibiadag k hab pi koꞌa hegai pahn mo jewajidas. Kutt am hahawa gahi i shul g geꞌe wahlkokaj k am ha nam Troas t am mo d hetasp tash amjed mat hegam am i t‑dagito. Kuch wehsijj am haꞌichugkahim hemako domig. ");
INSERT INTO oodNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","8","Am hu hebai d i shahwai hudunk. Tt am i t‑hemapai mo an hebai uhgk g kih k am t‑wehm t‑gegos matt am wo hehgigchul g Jiosh. K an muꞌi e mehmheidch g lalampa. T g Paul am neok k shaꞌi si tash am t‑mihshmad natsh pi wo hih baꞌich tash ed. Kut eda i huh g s‑chuhugam. ");
INSERT INTO oodNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","K an hema daha g wechij oꞌodham wintani t an ch hab chehgig Eutycus ch atsh am i s‑kohsim k kohsh k i gei ab wintani t amjed k ged hu gei jewedo. K eda waik e dahm kihki mat amjed ab i gei. T am hahawa haꞌi be k am s‑mai matki heki hu muh. ");
INSERT INTO oodNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","T wabshaba g Paul am i huduni k an si kohm k hab kaij, “Pi g am wo has e tahtkkad. Do doakam.” ");
INSERT INTO oodNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","12","T g hajunij gam hu hahawa i bei hegai wechij oꞌodham kihj wui si s‑ap e tahtkch mo d doakam. Kut gam hu hahawa uhpam ep i chehchsh mo an e mihshmad k am hab juh hegai chemait hugi mat hekaj wo s‑chegitok g Jesus muhkig. T g Paul am hahawa ep ha mihshmad k gam hu hahawa hih. ");
INSERT INTO oodNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","K am hahawa t‑ahgid g Paul mattsh gam hu wo nam mo am d Assos kihhim natsh pi wabsh wo i keish g wohg k am wo hih. Kutt heg hekaj gahi i shul g geꞌe wahlkokaj k gam hu dada. ");
INSERT INTO oodNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","T am hahawa t‑nam k an t‑wehm dahiwua. Tt am ep gahi i shulig k gam hu ai g Mitylene kihhim ");
INSERT INTO oodNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","16","k amjed gam hu ai g Chios kihhim. K am baꞌich d ep i tash, tt gam hu ai g Samos kihhim. K eda e aihim mat g Tutuligo gam hu wo hihi Jerusalem wui k am hab wo juh g hehgchulida Jiosh wui mat s‑ap i ha wehmt k am babhaijid g ha‑eꞌesha. K heg wui s‑himimk g Paul ch s‑e hohtkid ch hekaj hab kaij matt pi am hu wo i huhud Ephesus t am. Kutt hekaj am wabsh gahi wuwha. K am baꞌich d i tash, tt gam hu dada Miletus kihhim t am. ");
INSERT INTO oodNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","K oi wa s‑ha neidamk g Paul hegam mo d geꞌeged am ha shahgid g t‑wehm wohochuddam ab Ephesus t ab. Kut ab i ha wai Miletus wui. ");
INSERT INTO oodNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","T am i dada. K hab kaij ab ha wui: “Ni‑wepnag, s‑mahch am mani haschu am hab i junihim am em‑shahgid wabsh chum hekid ga hu i amjed mant hekid ia jiwia iia Asia jewed t am. ");
INSERT INTO oodNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ni ab wabsh i ni‑shoꞌigchud ch hebai ni‑ohꞌog iawua am hab junihidch g Jiosh chikpan nani pi si pihk ni‑elid em‑hekaj. Am o chum e nakog g ni‑wehm oꞌodham mat wo ni‑mua. Ni heg hekaj ab nakog g s‑wihnk haꞌichu. ");
INSERT INTO oodNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kum s‑mahch mani pi haꞌichu shaꞌi ehstohim ch wabshaba am wehs em‑ahgid mani haschu hab elid mat d wo i em‑wehmtadagk. Ni am em‑mashcham g Jiosh haꞌichu ahga mam am e hehemapad ch amai ep si heheꞌejel em‑kihki ed. ");
INSERT INTO oodNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kuni am si tasho ha ahgid g ni‑wehm oꞌodham ch gawul mahs hemajkam mat wo s‑ohhod g pi ap e‑chegitoi k ab wo i e dagito Jiosh wui k ab wo bei g t‑kownalig Jesus. ");
INSERT INTO oodNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","K hemuch hab si tahhadag g ni‑ihbdag mant am wo hih Jerusalem wui. Pi ani mahch mas haschu has wo mahsk am ni‑wehhejed amai. ");
INSERT INTO oodNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Id ani hi wa s‑mahch mani heg wui am him mantp hems wo ni‑kuhpachud k wo ni‑shoꞌigch no pi heki hu am i ni‑tashogid g Hekia S‑apꞌekam Gewkdag mani hebai i jijiwhia. ");
INSERT INTO oodNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pi o d shaꞌi haꞌichu g ni‑doakag manis wo si s‑huwidad hejel ni‑wehhejed. Heg ani waꞌi hab s‑junimk mant wo nahto hegai mo g t‑kownalig Jesus ab ni‑chehani mant am hab wo juh. K d ihda mant am wo i ahgahi g Jiosh hemajimatalig. ");
INSERT INTO oodNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Neh, pi amtki hekid ep wo shaꞌi ni‑nei. Ni heg hekaj s‑em‑ahgidamk mani wa wehs haꞌichu em‑ahgid ab amjed g Jiosh kownaltalig. ");
INSERT INTO oodNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","K pi d ni‑chuꞌijig mamtp hema i pi wo e doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Wehs ant em‑ahgi hegai mo haschu g Jiosh am hab elid k pi haschu shaꞌi ehsto ab em‑amjed. ");
INSERT INTO oodNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ab g hejel wo e nuhkudad ch ep wo ha nuhkudad g e‑wehm wohochuddam. Hegam o g Hekia S‑apꞌekam Gewkdag em‑nuhkudachud hab masma mamt wo haꞌi ha nuhkudach g kahwal e‑shoshoiga. Kumt wo s‑chegitok mat g t‑kownalig Jesus ehꞌed e iawua mat am ha wehhejed e muhkid k ha doꞌibia. ");
INSERT INTO oodNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ab at haꞌi wo i wahp em‑shahgid mat hab masma wo s‑ta ehbidamak am em‑wehhejed mo g shehꞌe am ha wehhejed g kahwal k wo chum s‑em‑uꞌim. ");
INSERT INTO oodNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Kut am haꞌi wo i e maskogi g chechoj em‑shahgid k wo haꞌichu chum em‑iattogi ahpim wohochuddam mat hab masma haꞌi im hu gawul wo i em‑wanim. ");
INSERT INTO oodNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Neh, mt wo si e nuhkudad ch wo s‑chegitokad mani em‑mashcham wehsijj waik ahid ab ch g ni‑ohꞌog iawua s‑chuhugam oidam ch tash oidam nani pi pihk ni‑elid em‑hekaj. ");
INSERT INTO oodNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Pegih neh, ab ant wa em‑ahgi ab amjed g Jiosh hoꞌigeꞌidadag k am haha wo em‑dagito Jiosh nohnhoi ed. T g Jiosh wo wa em‑nuhkudad ch ab wo i gewkai g em‑wohochudadag k wo em‑mah hegai si s‑kehg haꞌichu mo ab ha makiog g e‑hemajkamga. ");
INSERT INTO oodNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Pi ani hekid hedai ha‑lialigakaj o g wehschuga shaꞌi pihk ni‑elid. ");
INSERT INTO oodNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ni wabsh g hejel ni‑nohnhoikaj am hab junihim g chikpan ch hekaj ni‑dagioꞌid ch ep ha dagioꞌid g ni‑wehm chikpandam. ");
INSERT INTO oodNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ni hab wa masma am em‑chehgid mamt wo i ha wehmt hegam mo pi e amichud. T‑kownalig Jesus o hab kaij, ‘T wo s‑em‑hehgigch hegai mat ab wo haꞌichu em‑mah. Mt wabshaba baꞌich wo i s‑hehgigk mamt ab wo haꞌichu ha mah.’ Kumt id wo s‑chegitok mo has i kaij.” ");
INSERT INTO oodNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","I am i haꞌasa neo g Paul k am hahawa wehs ha wehm tohtonwua idam k am e hoꞌigeꞌidahu. ");
INSERT INTO oodNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","K wehsijj si shoani ch an si kokme no pi si pihk e elid hekaj ch hab ahg, “Jiosh at wo wa m‑wehmajk.” ");
INSERT INTO oodNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","K si pi ap e tahtk, wahm mat am i chegito mo hab kaij mat pi dahm ep wo nei. T am hahawa wehsijj hihi mo am daha g geꞌe wahlko. ");
INSERT INTO oodNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kutt am hahawa si wehs i ha hoꞌigeꞌel g t‑wepnag k am ha dagito k am wabsh si shel gahi i shul g geꞌe wahlkokaj k ga hu dada Cos kihhim t ab. Am baꞌich d i tash, tt ga hu ai g Rhodes kihhim k amjed ga hu aigo i dada Patara kihhim t ab. ");
INSERT INTO oodNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Neh, k am hema daha g geꞌe wahlko matsh gam hu wo hih Phenicia jewed wui. Kutt heg ab an ha hekaj i chehchsh k gm hu oi. ");
INSERT INTO oodNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tsh ab wo i e huhuds g wahlko mohtoi Tyre kihhim t am. Kutt am bihbij hugidaj an g Cyprus jewed k am dada amai Tyre t am. ");
INSERT INTO oodNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","K am haꞌi kih g t‑wehm wohochuddam. Kutt ha chehg k am ha wehm dadha hemako domig ab. T am i ha tashogi g Hekia S‑apꞌekam Gewkdag matsh am haꞌichu has wo e juh tahgio g Paul. Kum hab chum ahg mat pi am hu wo hih Jerusalem wui. ");
INSERT INTO oodNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","T wabshaba am i e ai matt wo hihi. Tt gam hu hihi. T wehsijj gam hu t‑oi ha wehm g e‑wehm kihkam ch e‑aꞌaliga matt gm hu wo i wuwha ab kihhim t amjed. Tt wehsijj am i tohtonwua ge shuhdagi bahsho k am t‑hoꞌigeꞌidahun ");
INSERT INTO oodNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","k ab hahawa aꞌai t‑ahgid mat wo t‑wehmajk g Jiosh. Tt ahchim gan hu hahawa i chehchsh geꞌe wahlko ch ed. T hegam gm hu epai hihi uhpam. ");
INSERT INTO oodNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kutt gam hu hahawa ep gahi i shul g geꞌe wahlkokaj Ptolemais kihhim wui. K am haꞌi kih g t‑wehm wohochuddam. Ch am ha wehmajkahim hemako tash ab. ");
INSERT INTO oodNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Am baꞌich d i tash, tt ga hu dada Cesaria kihhim t ab. Kuki am kih hegai Philip mo hema d hegam wewaꞌak chechoj matsh wa am e chuhcha matsh am wo i ha wehmt g Jesus chuhchai Jerusalem t ab. Kutt am hihi kihj wui. T am i t‑wahpki. ");
INSERT INTO oodNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Kuch am wehmajkahim heꞌekia i tash. Ihda Philip o giꞌik uꞌuwi aꞌalidag. K idam pi ha kuhkun ch am ahgahim hegai mo haschu g Jiosh am ha tashogid. ");
INSERT INTO oodNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kut ab Judea t amjed heg ab jiwia Jiosh haꞌichu i tashogiddam mo hab chehgig Agabus. ");
INSERT INTO oodNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ch am t‑mihshmad. T heg an bei g Paul giwud k an hekaj wuh g e‑kakhio ch e‑nohnhoi ch hab kaij, “Bamtsh masma hab wo m‑juh maptp am wo hih Jerusalem wui. T‑wehm oꞌodham atsh an wo si m‑wud k ab wo m‑dagito gawul mahs hemajkam ha wui. Id o am ni‑tashogid g Hekia S‑apꞌekam Gewkdag.” ");
INSERT INTO oodNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kutt am i kah ihda k ab chum si i ahgid g Paul mat pi am hu wo hih Jerusalem wui. ");
INSERT INTO oodNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","K wabshaba hab wabsh kaij, “Pi g am wo shoanid. Pi am ap ni‑tahtchud. Ni‑nahtokch ani mamtp wo ni‑wulsh o chum hems wo ni‑mua g t‑kownalig Jesus wehhejed.” ");
INSERT INTO oodNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kutt pi shaꞌi t‑nako machs wo shohbi k am wabsh i dagito k hab kaij, “Pegih, id ach waꞌi tatchua mat g Jiosh haꞌichu apꞌechuda am hab wo e juh.” ");
INSERT INTO oodNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kuch am ep haꞌichug heꞌes i tash ch am hahawa i t‑nakog k gam hu hihi Jerusalem wui. ");
INSERT INTO oodNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","T am haꞌi t‑oi Jerusalem wui k am i t‑ui heg kih wui matt am wehmaj wo dadhaiwua. Id o hab chehgig Mason ch ab d si kihkam Cyprus jewed t ab ch ash heki hu waꞌi s‑wohochud mo g Jesus d Jiosh si Kehsha. ");
INSERT INTO oodNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","T si s‑ap i e taht g t‑wehm wohochuddam ab i t‑neidok. ");
INSERT INTO oodNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Idam ha‑uhgchuga ash d James. Kutt heg chehgio am wehmaj g Paul. K am wehsijj dadha hegam mo d geꞌeged. ");
INSERT INTO oodNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","T g Paul ab wehs i ha hoꞌigeꞌid k am hahawa si s‑ap ha ahgid wehs haꞌichu mat g Jiosh s‑kehg am hab juh am gahi wuhshanim am ha shahgid g gawul mahs hemajkam. ");
INSERT INTO oodNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","T am i kaiok ab si ihm g Jiosh k wabshaba hab kaij ab Paul wui, “Neh, t‑wehnag, s‑mahch ap mat muꞌi mihl t‑wehm oꞌodham ab i s‑wohoch g Jiosh haꞌichu ahga k ab ihm g t‑kownalig Jesus k eda ab wabsh kia si has elid g heki hu t‑chehanig. ");
INSERT INTO oodNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Idam o kah mapsh ahpi ha mashcham hegam t‑wehm oꞌodham mo an aꞌai kih nahnko mahs hemajkam ha shahgid mat wo s‑ohhod g t‑chehanig k pi an hu wo ha oꞌoha an ha pahl hikuchk g e‑aꞌaliga. ");
INSERT INTO oodNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Do wabsh si shel mat wo kah mapt ia jiwia. Pegih, k hab chum mahs ");
INSERT INTO oodNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","mapt am hab wo e juh matt has wo i m‑ah. M o haꞌi d chechoj ch d giꞌik mat heꞌes pi hih g e‑moꞌo nat pi ab haꞌichu ahꞌad g Jiosh. ");
INSERT INTO oodNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Pt am wo ha oid k am ha wehm wo e dagito Jiosh wui geꞌe cheopi t am. Am apt ha wehhejed wo namkid mat haschu wo i chum ha namkid heg hekaj. Kumt am haha wo hih g e‑moꞌo. Pt hab masma wo ha chehgi g t‑wehm oꞌodham map am hab junihim g t‑himdag. T heg amjed wo s‑mahchk mo pi woho hegai mam haschu ab m‑abchud. ");
INSERT INTO oodNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","P am wa s‑mahch matt haschu am ha oꞌohani hegam gawul mahs hemajkam mat ab i s‑wohoch g Jiosh haꞌichu ahga. Bo chuꞌig g t‑oꞌohana mat hegam pi wo koꞌad g ehꞌed ch hegai mo pi gam hu e iawua g ehꞌed e mumꞌajch kch hegai mo ab e toꞌid hegai mo haschu hab chum e elid mo d jiosh. Kut wo si e nuhkud hab masma mat hegai waꞌi si e‑hohnig o g si e‑kun wehm wo kihk.” ");
INSERT INTO oodNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","K wa woho am baꞌich d i tash. T g Paul am i ha ui hegam chechoj k am ha wehm i e dagito Jiosh wui k am hahawa i wah geꞌe cheopi ch ed k am ha ahgid mat d wo wewaꞌak tashk, t wo kuhgit hegai mat ab ahꞌad. T am hab wo e juh hegai mat am hahawa haꞌichu wo iagchul Jiosh wui. ");
INSERT INTO oodNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","K am i e aihim mat wo kuhgit hegai wewaꞌak tash. T am hih g Paul k am i wah geꞌe cheopi ch ed. Kutsh haꞌi am chehg k an bei hegam Tutuligo mo ab Asia jewed t amjed. K eda muꞌi an oiopo g hemajkam. Kutsh am si i ha kudut ");
INSERT INTO oodNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","k ash si hihnk ch hab kaij, “T‑hajuni, ia g wo i t‑wehmt. Ihda oꞌodham o an wehsko si has ahg g t‑himdag ch t‑chehanig ch ihda geꞌe cheopi. Pi o d ha‑apꞌedag g gawul mahs hemajkam mas ia hu wo i wahp. Kutki eda ihda haꞌi i ha wahpkid k hab uamhu g geꞌe cheopi.” ");
INSERT INTO oodNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bash kaij nash pi am hu hebai neid g Paul hema wehm g gawul mahs oꞌodham ch hab e ahg mat am i wahki. Hegai mo wa am wehmaj o hab chehgig Trophimus ch ab Ephesus t ab d kihkam. ");
INSERT INTO oodNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","T am wabsh wehsko chehmo g pi ha‑apꞌedag amai kihhim t am. T ab aꞌaijed i wohp g hemajkam k an wabsh si bei g Paul k gam hu i chewaim ab amjed g geꞌe cheopi. T ab ha hekaj si e kuhkp g geꞌe cheopi kihkijeg. ");
INSERT INTO oodNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","K idam s‑babgam hemajkam chum mumꞌa g Paul. Kumtsh am ahgi g shondal ha‑geꞌejig mash am ge e cheggia. ");
INSERT INTO oodNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","T ab ha hekaj daꞌiwush muꞌi ha wehm g e‑shondalig k haꞌi ehp g ha‑geꞌegeꞌejig k ged hu woꞌi mat am e hemapai g hemajkam. T hegam am ha hekaj wabsh si haꞌasa cheggia g Paul am i ha neidk. ");
INSERT INTO oodNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","T g shondal am him k an bei g Paul. T g ha‑geꞌejig hab ha ah mat an wo si wuh g gohk e hukshchim wainomikaj. Kut hab juh. T ab hahawa ha kakke g hemajkam, “Dohꞌo wud ihda oꞌodham ch haschu has juh?” ");
INSERT INTO oodNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","K haꞌi g hemajkam am hu has i ahg. K haꞌijj ehp am wa gawul ep ahg. T am wabsh i ge nahnko e juh g haꞌichu ha‑ahga. Kut pi shaꞌi amich ihda shondal ha‑geꞌejig mat haschu has e juh k heg hekaj am wabsh ha ahgid g e‑shondalig mat ged hu wo kuh g Paul. ");
INSERT INTO oodNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","T an i bei mo an cheshajkudag. T wabshaba wabsh e nondagch g hemajkam k an chum s‑behimk ch si hihnk ch hab kaij, “Muꞌawo! Muꞌawo!” T heg hekaj wabsh uhgk i ul g shondal mat pi wo e muhkid. ");
INSERT INTO oodNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","T am haha wabsh i chum wahki g Paul e‑kolhai ed. K hab kaij g Greek ha‑neꞌokikaj ab wui g shondal ha‑geꞌejig, “M ani haꞌichu chum s‑m‑ahgidamk.” K heg hab kaij, “A kupki neok g Greek ha‑neꞌokikaj. ");
INSERT INTO oodNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ps hemsi d hegai Egypt t am oꞌodham mat wa am hu hebai ia i chum shonwuich g cheggiadag. T wa am i wehmt g giꞌik mihl chechoj ch uꞌa g cheggiakud am tohono jewed oidk.” ");
INSERT INTO oodNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","K hab kaij g Paul, “Pi ani d hegai. Dani Tuhligo ch ab d mahsikam Tarsus kihhim t ab am Cilicia jewed ch ed ch ab uꞌukch g ni‑shel ab amjed g si s‑has haꞌichu kihhim. Pt ab wo si i s‑ni‑hoꞌigeꞌid k wo ni‑hiwigi mant am wo neo ha wui g hemajkam.” ");
INSERT INTO oodNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","T wa woho am hiwigi g shondal ha‑geꞌejig. T an i kekiwua mo an cheshajkudag ab ha baꞌich g hemajkam k am neo g hejel e‑neꞌokikaj k hab kaij: ");
INSERT INTO oodNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ni‑hajuni ch ahpim geꞌeged hemajkam, ab g wo i ni‑kaiham mant am hejel ni‑wehhejed wo neo.” ");
INSERT INTO oodNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","T am i kah mo g ha‑neꞌokikaj neok k gam hu wabsh i pi shahmuni. K hab hahawa kaij g Paul: ");
INSERT INTO oodNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ahni ani d Tuhligo ch ab d mahsikam Tarsus kihhim t am am Cilicia jewed ch ed ch wabshaba ia geꞌeda Jerusalem kihhim t am k ia ni‑mashcham. K wa g Gamaliel d ni‑mashchamdam ch ab si s‑gewkam ni‑mashcham g t‑chehanig. Ni hab wa masma am chum si s‑gewkam oid g Jiosh himdag mam ahpim hemuch id i tashkaj. ");
INSERT INTO oodNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Kuni wa heg hekaj ha shoꞌigchud ch ha kokda hegam mo an uꞌukch ihda wechij haꞌichu ahga ch wa an ha uꞌu g chechoj ch uꞌuwi ch am ha shulig kukpaikud ch ed. ");
INSERT INTO oodNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","T g uhgchu pahl ch hegam e jehnigiddam am wo wohokamch ihda mani em‑ahgid. Bani wa ha ahg mant am wo hih Damascus kihhim wui. T hegam ab ni‑mah g oꞌohana am ha wui hegam mo d uꞌugchu am ha eda g t‑wehm oꞌodham amai Damascus ch ed. Nt wa am hi wa i hih mant wo ha wupulsh g e hukshchim wainomikaj hegam mo ab s‑wohochud ihda wechij haꞌichu ahga k wo uhpam i ha ui ab Jerusalem wui mat wo bei g s‑koꞌok e‑namkidadag. ");
INSERT INTO oodNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Neh, am att wa hihim k gam hu i aihim g Damascus kihhim. K wa am hu d i dahm juhk mat haha wabsh haꞌichu si ton ab amjed g dahm kahchim an wehsko ni‑wehgaj. ");
INSERT INTO oodNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nt wa am i gei jewedo. T wa ab hema si neo ni‑wui k hab kaij, ‘Saul, s‑wohom ap hig ni‑shoꞌigchud.’ ");
INSERT INTO oodNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Kuni si has elid ch hab kaij, ‘Dohp wud ch ab neok?’ “K hab hahawa ep kaij, ‘Dani ahni Jesus map ha shoꞌigchud g ni‑ihmdam.’ ");
INSERT INTO oodNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","K hegam mo am ni‑wehmaj hi wa neid hegai geꞌe tonlig ch wabshaba pi amichud g neꞌoki. ");
INSERT INTO oodNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Ni ab hahawa kakke, ‘Shahnt wo ni‑juh, ni‑kownalig?’ “K wa hab kaij, ‘Ab g i wamig k am him k am i wahki Damascus ch ed. T am hahawa hema wo m‑ahgi mapt haschu am hab wo chum wuad.’ ");
INSERT INTO oodNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","“Tki eda pi ni‑nenich heg hekaj mat wa am si s‑masma ton. T wa am wabsh i ni‑wanim hegam mo am ni‑wehmaj k ged hu ni‑uꞌapa Damascus t am. ");
INSERT INTO oodNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Kuki wa am hema kih g oꞌodham ch hab chehgig Ananias ch ab si ihm g Jiosh ch ep am si oid g chehanig. K ab si has elid g t‑wehm oꞌodham amai Damascus t am. ");
INSERT INTO oodNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Heg at wa am jiwia ni‑wui k ab kehk ch hab kaij, ‘Ni‑nawoj Saul, ab g behꞌi g e‑nentalig!’ Nt ha hekaj s‑ap haꞌichu neid k ab si i nei. ");
INSERT INTO oodNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“K wa hab kaij ab ni‑wui, ‘Neh, am antsh wo m‑ahgi matsh ahpi am i m‑kei g Jiosh mapt wo s‑mahchk g tatchuij ch wo nei g si s‑apꞌekam Kehshaj k wo kah mat am hejel wo m‑ahgi g haꞌichu e‑ahga. K d waꞌi ihda Jiosh mo an uꞌukch g t‑shohshonbad. ");
INSERT INTO oodNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","K hab d elidaj mapt d wo hema hegamk mapt am wo si i wohokamch g Jesus k am wo i ha ahgi g hemajkam mapt haschu i neid k haschu i kah. ");
INSERT INTO oodNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Pt ha hekaj wo i e nakog k wo e pahl wako ab ihmadch g Jesus. T heg gam hu hab wo i juh g pi ap m‑chuꞌijig.’ Neh, bo ni‑ahg. ");
INSERT INTO oodNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nt wa am hab juniok ab i hih Jerusalem wui k am hu hebai am ni‑hoꞌigeꞌidahun geꞌe cheopi ch ed. T wa am haha wabsh ni‑nena ed haꞌichu hab e juh ");
INSERT INTO oodNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","mani neid g Jesus. K hab kaij ab ni‑wui, ‘Ia g ha hekaj dagito g Jerusalem k hihm ab amjed nat pi g m‑wehm oꞌodham iia pi ab hu wo kaiha g haꞌichu m‑ahga ab ni‑amjed.’ ");
INSERT INTO oodNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Ni hab kaij, ‘Tp hems wo wa ni‑kaiha, ni‑kownalig, no pi s‑ap s‑mahch mani d ahni mani wa an wahkhim ha eda g ha‑chechopi ch an ha uꞌud ch ha gewittan hegam mo ab m‑ihm. ");
INSERT INTO oodNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Kuni wa am ha wehmaj ch am nuhkud g ha‑wehschuga hegam mat mua hegai Steven mat am si s‑mahch k ah ab m‑amjed.’ ");
INSERT INTO oodNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“K wabshaba hab kaij g Jesus ab ni‑wui, ‘Am g wa hihm nant pi am i m‑kei mapt am mehk wo hih ha wui g nahnko mahs hemajkam.’ ” Neh, bo kaij g Paul. ");
INSERT INTO oodNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","K wa ab hi wa s‑ap kaiham idam hemajkam. T wabshaba am hab wabsh chum chei ihda matsh g Jesus am i kei matsh am wo hih ha wui g nahnko mahs hemajkam. T am ha hekaj i hihinkiad si s‑kaidam k hab kaij, “Muꞌawo! Muꞌawo! Pi o an hu hab chum chuꞌig mas in d wo doakamk.” ");
INSERT INTO oodNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","K si hihnk ch ab si shahmud g e‑wepschuga ch g jewed shashkum ch am uhgk si nenꞌeichud nat pi am i si babgat. ");
INSERT INTO oodNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","T g shondal ha‑geꞌejig am hahawa ha cheha g e‑shondalig mat gam hu wo i wahki g Paul shondal ha‑kih ed. T am i wahki. T am ha cheha mat wo gewitta am hugkam mat am wo ha ahgi mat has e juh mo hekaj si hihnkoid g Tutuligo. ");
INSERT INTO oodNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","T an wulsh mat wo chum gewitta. K am hema kehk g shondal ha geꞌejig. K ab wui hab kaij g Paul, “Ab ani uꞌukch g ni‑shel hab masma mo g Rome t am oꞌodham. K heg hekaj pi hab chum mahs mams wo ni‑gewitta pi koi ni‑lodaidk.” ");
INSERT INTO oodNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","T heg am i kah ihda k am wui hih g si uhgk shondal ha‑geꞌejig k ab kakke ch hab kaij, “Nap s‑mahch maptki has wo chum chuꞌi? Ihda oꞌodham oki ab uꞌukch g e‑shel hab masma mo g Rome t am oꞌodham.” ");
INSERT INTO oodNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","T am hahawa hih g si uhgchu shondal ha‑geꞌejig am Paul wui k ab kakke ch hab kaij, “Am g ni‑ahgid. Nap ab uꞌukch g e‑shel hab masma mo g Rome t am oꞌodham?” Sh hab kaij g Paul, “Heuꞌu.” ");
INSERT INTO oodNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","K hab hahawa kaij g ha‑geꞌejig, “A pt has hig masma ab bei g e‑shel. Ahni ant hi ab bei muꞌi lial ha namkid.” K hab kaij g Paul, “Ni wabshaba ahni ab uꞌukch g ni‑shel mani ab d ha amjedkam hegam mo uꞌukch g e‑shel.” ");
INSERT INTO oodNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","T ga hu taꞌi si i gegokiwua hegam mo an wulshch g Paul mat wo chum gewitta. T g shondal ha‑geꞌejig ep si e tods nat pi ha cheha mat hab wo juh. ");
INSERT INTO oodNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Am baꞌich d i tash, tsh g shondal ha‑geꞌejig am i ha cheha g uꞌugchu papal mat am wo i ha hemapai g e jehnigiddam nash pi s‑mahchimk mo haschu ab abchud g Paul. T g shondaligaj gam wulꞌo g e hukshchim wainomi ab ab g Paul k am i be k am i kei ha wui. ");
INSERT INTO oodNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","K g Paul ab si ha neid g e jehnitiddam ch hab kaij, “Ni‑hajuni, chum ani hekid si ni‑nakog mant am hab wo waꞌi junihid g s‑apꞌekam ch hab pi wo shaꞌi haꞌichukaj si has ni‑elidad am tahgio g Jiosh ia i himdam tashkaj.” ");
INSERT INTO oodNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kut hegai uhgchu pahl mash hab chehgig Ananias am ha cheha hegam mo an miabidch gegok mat ab wo si shonihi g Paul chinij ab. T ab shonihi. ");
INSERT INTO oodNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","K hab kaij g Paul, “Jiosh at hemho ab wo wa uhpam i nodagi ihda am m‑wui ahpi map s‑chu iattomk. Ab ap dak ch ni‑lodait g t‑chehanigkaj ch eda ep melchkwuhim g t‑chehanig map ab ha chehani mat ab wo ni‑shonihi.” ");
INSERT INTO oodNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","K hab kaij hegam mo an miabidch gegok g Paul, “S‑koꞌokam ap has ahg g uhgchu pahl.” ");
INSERT INTO oodNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","K hab kaij g Paul, “Ni‑hajuni, mant hems wo s‑mahchk mokis d uhgchu pahl, nt pi hab wo shaꞌi chei, no pi hab chuꞌig g Jiosh oꞌohana: Pi g am wo shaꞌi pi ap has ahgad g e‑geꞌejig.” ");
INSERT INTO oodNT_vpl VALUES ("AC23_6","074_23_6","ACT","23