﻿USE sofia;
DROP TABLE IF EXISTS sofia.ons_vpl;
CREATE TABLE ons_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ons_vpl WRITE;
INSERT INTO ons_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iwa yemo ŋei wakone sari mageu Yesu Kristo wakonge, eŋe Dawit wane qerakine, eŋe Abraham wane qerakine. ");
INSERT INTO ons_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham eŋe Isak magaine, Isak eŋe Yakop magaine, Yakop eŋe Yuda eŋineso ŋolekoune eŋane magaene, ");
INSERT INTO ons_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda eŋe Pereze so Zera erane magaetne, (nagaetne Tama), Pereze eŋe Hezoron magaine, Hezoron eŋe Ram magaine, ");
INSERT INTO ons_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram eŋe Aminadap magaine, Aminadap eŋe Nason magaine, Nason eŋe Salmon magaine, ");
INSERT INTO ons_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon eŋe Boaz magaine, (nagaine Rahab,) Boaz eŋe Obet magaine, (nagaine Ruti), Obet eŋe Yese magaine, ");
INSERT INTO ons_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese eŋe ŋei waom Dawit magaine, Dawit eŋe Solomon magaine (nagaine Uria wane ŋanomine). ");
INSERT INTO ons_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon eŋe Rehoboam magaine, Rehoboam eŋe Abaeza magaine, Abaeza eŋe Asa magaine, ");
INSERT INTO ons_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa eŋe Yehosapat magaine, Yehosapat eŋe Yoram magaine, Yoram eŋe Uzia magaine, ");
INSERT INTO ons_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia eŋe Yotam magaine, Yotam eŋe Ahaz magaine, Ahaz eŋe Hezekia magaine, ");
INSERT INTO ons_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia eŋe Manase magaine, Manase eŋe Amon magaine, Amon eŋe Yosia magaine, ");
INSERT INTO ons_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia eŋe Yekonia eŋine so ŋolekoune eŋane magaene, naso yewao Israel ŋei ŋerep ebu peik one more Babilon kepeo ari warekoi. ");
INSERT INTO ons_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ŋei ŋerep Babilon kepeo ebu arikoi, ea wane ŋadino, Yekonia eŋe Sealtiel magaine, Sealtiel eŋe Zerubabel magaine, ");
INSERT INTO ons_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel eŋe Abiudu magaine, Abiudu eŋe Eliakim magaine, Eliakim eŋe Azor magaine, ");
INSERT INTO ons_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor eŋe Zadok magaine, Zadok eŋe Akim magaine, Akim eŋe Eliud magaine, ");
INSERT INTO ons_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud eŋe Eleazar magaine, Eleazar eŋe Matan magaine, Matan eŋe Yakop magaine, ");
INSERT INTO ons_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakop eŋe Yosep magaine, Maria wane ŋaone, Maria eŋe Yesu nagaine, Yesu eŋe Kristo orake. ");
INSERT INTO ons_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham wano ŋine wakon sari mageu, Dawit wakonge eŋane tegoene 14. Dawit wano ŋine wakone sari mageu, ebu peikone Babilon kepeo arikoi, eŋane tegoene 14ka okanmaike. Eso ea ŋine sari mage Mesia wakonge, tegoene 14ka. ");
INSERT INTO ons_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kristo eŋe numa iwa yale oken wakonge. Nagaine Maria eŋe Yosep wane biŋek rau geke, ŋo ere meteetne mi au au, yaupka ge more, Maria eŋe kake, medep mane mayakane Asu Koboboineŋo urata maki, ŋatkeke ea mayake. ");
INSERT INTO ons_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Eŋe Yosep wane biŋek rakoi, ŋei yewa eŋe mitirop geki paki, kine kine maineka okane geke. Ŋo eŋe siluŋ Maria ŋei eŋane kaitko donine didiwo rawakongi, gamu kutno wayakane mi detke, eso eŋe sanka eŋane biŋek rakoi, ea kitasiakane wetkeke. ");
INSERT INTO ons_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Eŋe yale wetke gegeki, Waom wane aŋelo maneŋo kulu kuluo wakonka more olale rake, “Yosep, Dawit wane qerakine, Maria ŋanomŋone makenane misuk kaetganiake, eamo Asu Koboboineŋo urata maki medep ŋatkemaike. ");
INSERT INTO ons_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Eŋe medep baŋ ŋei mayake, paki ge baŋ eŋetine Yesu orakene, onoka wane oŋo baŋ ŋei ŋerewekoune borikineeno ŋine makokoniake.” ");
INSERT INTO ons_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Masi iwa korop wakonge, yemo Waomŋo propet eŋane wetino motki don ra sari geke, ea wane wele wakoniakane yale wakonge. ");
INSERT INTO ons_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ŋerep natewen mane, ŋei mi makeŋo baŋ medep ŋatkeake, paki medep mane ŋei mayake, eso eŋe baŋ eŋetine Imanuel orakei,” kine iwa yale, “Anutu eŋe ŋenerop gemaike.” ");
INSERT INTO ons_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Eso Yosep eŋe kuluo ŋine wieki paki, Waom wane aŋeloŋo daleo okaniakane olatke, ea wane rokop okane more, ŋanomine Maria make. ");
INSERT INTO ons_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ŋo eŋe ŋao ŋanom gege ea mi geuk paki, Maria eŋe medepine make, pakiso, Yosepŋo eŋetine Yesu orake. ");
INSERT INTO ons_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu eŋe Betlehem matko, Yudia kepeo wakonge, nasoine Herot eŋe ŋei waom geke, yewao ŋei natne serekin dapot one more, kineene detone gegekoi, edo kepe sasaino ŋine Yerusalem matko sarikoi. ");
INSERT INTO ons_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Paki qesone rakoi, “Medep musele wakonmaike, Yuda ŋei eŋane ŋei waom ea diawa? Ŋene eŋane serekinine kepe sasainoken sa waki kene, eso ŋene ea wane bakomine kitokenane sarimaine.” ");
INSERT INTO ons_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ŋei waom Herot eŋe don ea dere more qiseke, so Yerusalem matko ŋine ŋei ŋerep natne eŋe yaleka dere qisekoi. ");
INSERT INTO ons_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Paki Herot eŋe Pris suaine so ra rokop don numa kito ebo ebon ŋei edoraki, sari wekuoka qeturageu qeson one rake, “Mesia eŋe mat diao wakoniake?” ");
INSERT INTO ons_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Eŋe olale rakoi, “Betlehem matko, Yuda kepeo, Propet eŋe iwa yale qeke, ");
INSERT INTO ons_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem matko, Yuda wane kepe, ge Yuda ware ware eŋane keuo ŋine ketkele midaka, ŋinano ŋine ŋetne mane baŋ sariake, oŋo naŋane ŋei ŋerewekopne Israel baŋ alakane sikan oniake.’” ");
INSERT INTO ons_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Eso Herot eŋe kepe sasaino ŋine ŋei sarikoi, eŋe edoraki ariu sanka lewage, naso diawao serekinba wakonge desiakane qesononge. ");
INSERT INTO ons_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pakiso iwa yale edaneso biraongi Betlehem matko arikoi, “Ariu paki, bororom kauluke medep ea zuaŋkakei, eso kau pakiso na nolatpi dere, so na yaleka maine ari more bakomine kitokale.” ");
INSERT INTO ons_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Don iwa edangi, so yeropka arikoi, numao ariu paki serekin kakoi, serekinba kepe sasaino wakongi kakoi, serekin weku yewaka kakoi. Serekin eaŋo alakangi, so eŋe kama kama sari mage medep pake, ea wane kutno doŋ mane metke. ");
INSERT INTO ons_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Eŋe Serekin kau paki, wetene peseki, oi bakom suaine okangoi! ");
INSERT INTO ons_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Eŋe mat koto wau paki, so Yesu medep so nagaine Maria otkoi. Eŋe wawetene qeu paki, umi qe more bakomine kitokoi, pakiso, kiteene makoke bakom okankakei wane kine kine ma sarikoi, ea mangoi, gol, eki kelokine qoune simile, so kelok qoune simile ea mangoi. ");
INSERT INTO ons_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pakiso Anutuŋo kulu kuluo Herot wano koso mi zinge arikei wane girem edange. Eso eŋe zinge more, numa maneoka mateno arikoi. ");
INSERT INTO ons_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Eŋe ariu, so Waom wane aŋelo maneŋo kulu kuluo Yosep wakonka more olale rake, “Wienom paki, medep so nagaine epunom Ezipt kepeo ariu paki, ea ge mageu, noŋo rawe dere so baŋ sarikei, Herot eŋe baŋ zuage medep qeki seukeakane ramaike.” ");
INSERT INTO ons_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yale olatki, so Yosep eŋe wie more, medep so nagaine epuki, so mat qelige goigo Ezipt kepeo arikoi. ");
INSERT INTO ons_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ari ea ge mageu, Herot seukke. Yale okangi, so don mane Waomŋo propet mane wane wetno motki don rake, ea wane wele wakonge. Don iwa yale rake, “Na medepne orawe, Ezipt kepeo ŋine wie sarike.” ");
INSERT INTO ons_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot eŋe iwa yale detke, kepe sasaino ŋine ŋei lobo sarikoi, eŋe na isinangoi yale detki paki, sotine zok osike, paki eŋe don motki kawali ŋei eŋe Betlehem matko so mat osop osop pa arike, eao medep ŋei komaene etke (2) so eŋane bane medep abubu korop engu warekoi, eŋe ŋei lobo kepe sasaino ŋine sari serekinba wakonge, ea wane nasoine olatkoi, ea detki paki, ea wane kop okange. ");
INSERT INTO ons_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Numa iwa okanbi Propet Yeremaiaŋo don mane rake, ea wane wele yewa wakonge, ");
INSERT INTO ons_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama matko ukat wakongi detmami, nem kuasuruk so aro uŋalan wakonmaike. Rakelŋo qerakkoune Yuda wane tego eŋane ra more arokmaike, eŋe arokmaike, so baŋ mi mau kopkeake, onoka wane eŋe korop seuseuneka.” ");
INSERT INTO ons_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herot seukki, ŋadino Waom wane aŋelo maneŋo kulu kuluo Yosep Ezipt eao wakonkake, ");
INSERT INTO ons_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Paki olale rake, “Ge wienom paki, medep eŋine so nagaine epunom, koso zinge more, Israel kepeo ariu, onoka wane medep qekei wane rakoi, ŋei ea mo seukkoi.” ");
INSERT INTO ons_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yale olatkiso, Yosep eŋe wieki paki, medep eŋine so nagaine epuki, so koso zinge Israel kepeo arikoi. ");
INSERT INTO ons_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ari detki, Arkelaus eŋe magaine Herot wane tungo Yuda kepeo ŋei waom geke, pakiso Yosep eŋe Betlehem matko geakane kaetkake. Aŋeloŋo koso manerop kulu kuluo wakone more olatki, so eŋe ea ŋine wie koso Galili kepeo arikoi. ");
INSERT INTO ons_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pakiso, matine maki paki, mat mane eŋetne Nazaret eao gekoi, eŋe yale okangi, propet edo don mane rakoi, ea wane wele wakonge, “Ŋei ŋererop korop eŋe baŋ raikei, ‘Eŋe Nazaret welaine.’” ");
INSERT INTO ons_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Naso Yewao Yohane doku tau tau eŋe sari more, Yuda kepe yaup papaino kieke miti edane geke. ");
INSERT INTO ons_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Paki rake, “Borikine ŋine ŋadek kau paki, wetŋine maingeu, onoka wane qeli gege togon wane Ŋei Waom mo osop sarimaike!” ");
INSERT INTO ons_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohane weku eŋane propet Isaiaŋo don iwa yale rake, “Ŋei mane kepe yaup papaino bokamaike, ‘Waom wane numa ma wesakeu, eŋe sariakane numa makoboe birakau!’” ");
INSERT INTO ons_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane takotine kamel zouneŋo mamaine ma geke, eŋe waroine osom solaineŋo mamaine, eaŋo kebaŋino ramu geke, so ŋaraine yemo sila so begok zubaine, ea ne geke. ");
INSERT INTO ons_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ŋei ŋerep eŋano sari warekoi, yemo Yerusalem matkoŋine, Yuda kepeo ŋine korop, so Yordan Doku loli lolik mat pa arike, ea ŋine. ");
INSERT INTO ons_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Eŋe borikineene ra wakone qeligeu, Yordan Dokuo tauonge. ");
INSERT INTO ons_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohane eŋe Parisi ŋei so Sadusi ŋei tego loutneŋo doku tau oniakane sariu, ongi paki edane rake, “Ŋine koma qotkoinane dokoine, maŋo ŋidangi Anutu wane busu ŋado sariakane okanmaike, ea kakakka more ŋadekka ariu rap? ");
INSERT INTO ons_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wetŋine maingeu paki, tanik manik maine okane mau, eaŋo baŋ borikine ŋine ŋadek kamami, ea wane welewa eamo sikan ŋoniake. ");
INSERT INTO ons_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","So wetŋineŋo iwa yale maine mi wetke rakei, ‘Abraham eŋe ŋenane ŋaboze.’ Na ŋidanmaile, yemo Anutu eŋe maine wesi iwaŋo maki paki, eaŋo Abraham wane ŋabokoune tego mane koso maine ebuki wakongei! ");
INSERT INTO ons_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Naka mo eki ŋodino kitatki ketkei wane eweke pamaike, eki korop wele maine mi qekei, yemo baŋ kitatki ketpi biraongi, gerepko wau ezoyake. ");
INSERT INTO ons_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Na dokurop tau ŋunmaile, eaŋo kine iwa yale sikan ŋonmaike, yemo ŋine wetŋine maingekoi, ŋo ŋei mane naŋane ŋadeno baŋ sarike, eŋe yemo zonomine togogole, eŋe naŋane zonom yuan kamaike, na ŋei maine mida, noŋo eŋane kie tabine maine tewekkalane rokop midakaka, oŋo yemo baŋ Asu Koboboine so gerep weneŋ tauŋuniake. ");
INSERT INTO ons_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Eŋe wano wanok urata ma gemaike, kito wanok maki wele eŋineka, eŋe witine wele baŋ peikki urumino wayake, ŋo solaine eamo gerep koma komaine midaine banine ze papaine, eao qakki ezowareake.” ");
INSERT INTO ons_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naso yewao Yesu eŋe Galili kepeo ŋine Yordan dokuo arike, paki Yohane wano sarike, oŋo doku taukayakane. ");
INSERT INTO ons_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ŋo Yohaneŋo yemo wetinane kine ra qelaŋaniakane wetne maingeakane liwekka rake, “Goŋo na yemo maine taunanikene, ŋo siluŋ noŋo ge tau ganikalane naŋano sarimaine me?” ");
INSERT INTO ons_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pakiso Yesuŋo mainge olale rake, “Yeine qeligenom paki, noŋo ramaile yale iwa okannom, numa iwa yale, ea yemo ŋere maine Anutuŋo detmaike, ea wane kop okanikete.” ");
INSERT INTO ons_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Eso Yohane eŋe Yesu wane don dere, so eaka doku taukake. Taukaki, Yesu eŋe dokuo ŋine saki saki, eaka qeli aŋaŋge manmaike, pakiso eŋe kaki, Anutu wane Asuŋo naŋi baluse yale okan ketki paki, Yesu eŋine kutno kitoke. ");
INSERT INTO ons_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eso qeliwo ŋine don mane iwa yale raki ketke, “Iwa eŋe nae Gipon maepne, na eŋane zok manerop similenan okanmaike.” ");
INSERT INTO ons_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pakiso Asuŋo Yesu iwenka kepe yaup papaino arike, Satanŋo liwek kayakane. ");
INSERT INTO ons_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu eŋe yewa kaiwe 40 so ruo 40 ŋaraine midaine ge mage, ŋarainane seukke. ");
INSERT INTO ons_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Eso Satanŋo eŋano lotke more rake, “Ge Anutu wane Gipole gemaineo, yemo ranom, wesi iwaŋo qeinge more bret okangep.” ");
INSERT INTO ons_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesuŋo mainge olatke, “Anutu wane papiaŋo iwa yale ramaike, ‘Ŋeiŋo ŋara waneka maine mi geulukeake, Anutu wane piwo ŋine don kine kine sari okanmaike, ea detluke more, yemo geulukeake.’” ");
INSERT INTO ons_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pakiso, Satanŋo Yesu iwenka mat suaine kobekine, Yerusalem, ea ari more, Bakom Urum wane bakine wetika weti, ea birakaki okorake. ");
INSERT INTO ons_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Pakiso olale rake, “Ge Anutu wane Gipole gemaineo, yemo goŋomka iwa ŋine sontake kepo ketnom, onoka wane Anutu wane papiaŋo iwa yale ramaike, ‘Anutu eŋe baŋ aŋelokoune geŋane ra more edaniake, eŋe baŋ meteeneŋo geu wiekei, paki kieŋone wesiŋo mane mi kitasiake.’” ");
INSERT INTO ons_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesuŋo mainge olatke, “Ŋo Anutu wane papiaŋo yaleka iwa yale ramaike, ‘Ge Waomŋone Anutu liwe liweko misuk birakakene.’” ");
INSERT INTO ons_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pakiso Satanŋo Yesu bonaga kiro qatqale yewao iwenka wa more ŋei ŋerep magune magune so kepe baŋem ea wane simile kine kine suaine zok manerop pamaike, ea sikanka wareke. ");
INSERT INTO ons_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Paki olale rake, “Ge wawetŋone qem paki, bakomne kitokene, yemo na yeye kine kine iwa korop baŋ ginwarekale.” ");
INSERT INTO ons_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Rakiso Yesu mainge olatke, “Satan, ge masikane arinom! Anutu wane papiaŋo iwa yale ramaike, ‘Waomŋone Anutu eŋe weku meŋenka more qelitine qekene.’” ");
INSERT INTO ons_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yale rakiso Satanŋo qeliŋka arike, pakiso aŋelo edo sari, so Yesu kito qesiŋ okankakoi. ");
INSERT INTO ons_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yohane mulap urumgo birakau, Yesu eŋe kisiine detki paki, wie more Galili kepeo arike. ");
INSERT INTO ons_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Eŋe Nazaret matko mi geke, eŋe qelige ari Kaperneam matko geke. Mat yewa eŋe Galili doku namuŋ wazaino, Zebulun so Naptali erane kepe saiwo metke. ");
INSERT INTO ons_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yale okangimo propet Isaiaŋo don mane rake, ea wane wele wakonge, don iwa yale, ");
INSERT INTO ons_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun wane kepe, so Naptali wane kepe, doku namuŋgo oken pamamik, Yordan nat parom, Galili qelaŋ ŋei ŋerep eŋane kepe! ");
INSERT INTO ons_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ŋei ŋerep panaman koto gemami, eŋe baŋ qelaŋan kakapa suaine mane kakei, ŋei ŋerep seu seu kepe wane panaman qekatno gemami, kuteno kiwa baŋ qelaŋaniake.” ");
INSERT INTO ons_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Naso yewao Yesuŋo kieke, donine iwa yale edange, “Borikine ŋine korop qelige ŋadekka wareu, onoka wane qeli gege togon nasoine mo bomilemaike!” ");
INSERT INTO ons_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu eŋe Galili doku namuŋ meuno ariki paki, tatiŋon etke otke, ere zawon mama ŋei, Simon, eŋetine mane Petoro, so ŋole Andrea, ere doku namugo kamagaŋo zawon ebu okorakoik. ");
INSERT INTO ons_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesuŋo etane rake, “Sariuk, narop ari more noŋo ŋei ebu ebu daleo ebukeik, ea wane kine kito ŋipongale.” ");
INSERT INTO ons_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Raki, so eaka kamaga etne qelige, so eŋerop arikoik. ");
INSERT INTO ons_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Eŋe ari ari more, koso tatiŋon etke maratotke, Yakop so Yohane, Zebedi wane gipoletkine. Ere seki etne koto magaetne Zebedirop mere kamagaene maulukkoi, pakiso Yesuŋo etorake. ");
INSERT INTO ons_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Etoraki, so eaka seki so magaetne qelige, so Yesurop weneŋ arikoi. ");
INSERT INTO ons_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu eŋe Galili kepe loli lolik ari more, Yuda lewa lewaŋ urumeno waki paki, qeli gege togon wane don kito edange, miti don maine ra edange, so ŋei ŋerep kubet kine kine enerop, so zoma kine kine enerop ebuki menaŋgoi. ");
INSERT INTO ons_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yale okangi, eŋane don kisiineŋo Siria kepeo korop sua ariki, dere more ŋei ŋerep eŋe detpi paki, zoma kubet korop so asu qotkoinerop so seuke wisikae gemaŋkoi, so mat popoine kie meteene seu seune, korop ebu Yesu wano ma sariu ma menaŋ onwareke. ");
INSERT INTO ons_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ŋei ŋerep magu suaineŋo ŋadino mogare arikoi, Galili kepeo ŋine, so Mat Suaine Ten eaŋine, so Yerusalem matko ŋine, so Yuda kepeo ŋine, so Yordan erinat kepe ea ŋine. ");
INSERT INTO ons_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu eŋe ŋei ŋerep magu suaine onge, paki meŋo mane wane kutno waki paki, ea pese ket metke, eŋine dokoine eŋe sari osino lolikka metkoi. ");
INSERT INTO ons_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pakiso eŋe kieke don iwa yale edange, ");
INSERT INTO ons_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ŋei eŋe kotoenane detpi, wanap okanmaike, onoka wane eŋe wet pesek desikei, qeli gege togon yemo eŋane biŋek! ");
INSERT INTO ons_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nem kuasuruk gemami, eŋe wet pese desikei, onoka wane Anutuŋo baŋ maganut oniake! ");
INSERT INTO ons_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wetene ma pese gemami, eŋe wet pese desikei, onoka wane eŋe baŋ Anutuŋo onoka biŋek qe ebonge, ea makei! ");
INSERT INTO ons_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Anutuŋo dere ebon maike ea wane rokopko wetene suaineŋo wikile mage okanmami, eŋe wet pese desikei, onoka wane Anutuŋo baŋ qe watke ebongi, ŋatene qeake! ");
INSERT INTO ons_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ŋei kimakopene eŋane wetene boriki, seseone okanmami, eŋe wet pese desikei, onoka wane Anutuŋo baŋ wetine boriki seseoniake! ");
INSERT INTO ons_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kotoene libeka gemami, eŋe wet pese desikei, onoka wane eŋe baŋ Anutu kakei! ");
INSERT INTO ons_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ŋei eŋane keueno peam wane urata mamami, eŋe wet pese desikei, onoka wane Anutu eŋe baŋ eŋine gipolekoune edorayake! ");
INSERT INTO ons_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ŋei mane Anutuŋo dere ebon maike, ea wane rokopko ma waremaike, miti wane ŋabaine ra more wikile kuteno wamaike, eŋe wet pese desikei, qeli gege togon eamo eŋane biŋek! ");
INSERT INTO ons_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ŋei eŋe det worik okan ŋungei, so ŋingu matali qetali okan ŋunikei, so ŋinane aŋao more isi don kine kine borikine korop ra sola ŋine matalikei, ŋine wet pese desikei, onoka wane ŋine naŋane ŋadeno mogatnane sarimami, ea wane. ");
INSERT INTO ons_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ŋine wet ŋine peseki, batne okanikei, onoka wane turuŋŋine lewine suaine qeliwo, ŋinane biŋek warekaki pamaike, ea wane. Propet ŋinane bango qei ge sakoi, miti wane ŋaba eŋe yale waka matali qetali ebukoi. ");
INSERT INTO ons_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ŋine kepe baŋem ŋei eŋane soli okanikei. Ŋo soli eŋe simileine ea mida okaniakeo, mau koso simile wako wakon wane numa eamo mi pamaike. Soli ea mo simile midaine, ea wane yeine qakeu ariki, ŋei ŋerep eŋe kutno gesoke ari okanmami. ");
INSERT INTO ons_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ŋine kepe baŋem ŋei eŋane kiwa, yale okane gekei. Mat mane suaine meŋo maneo makoi, eŋane qelaŋane kine kine maneŋo maine mi qekatkeake. ");
INSERT INTO ons_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ŋei maneŋo kiwa mane kiweke, laseŋo mi kito korauki mesiake, ea wane turuŋine yemo eŋe bosiŋino modeki okora more, ŋei ŋerep mat koto metmami, ea qelaŋane eboniake. ");
INSERT INTO ons_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Rokop yalewaka, ŋinane kiwaŋo ŋei ŋerep qelaŋane eboniake, paki eŋe ŋinane masi tanik maine okanmami, ea kau paki, Magaŋine qeliwo gemaike, eŋe bakomine kitokei. ");
INSERT INTO ons_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ŋine naŋane iwa yale misuk wetke rakei, eŋe Mose wane ra rokop don so propet eŋane don ea esopkaki ariakane ketke. Na ea esopkawe ariakane, mi ketkole, midakaka, na don ea tewekewe paki, mawe eŋane don wele okaniakane ketkole. ");
INSERT INTO ons_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na welekatne ŋidanbe detpi! Qeli so kepe ere pakeik, kop ra rokop don, me ea wane don sisine mane ra rokop don wane kotino qeqine, eaŋo mi siukeake, midakaka. Eŋe yale pamageki, qeli so kepe so yeye kine kine korop eŋane naso qoeake. ");
INSERT INTO ons_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eso ea wane, ŋei mane eŋe ra rokop don mide nigagatne mane dere qewoloŋgi paki, ŋei natne masi weku eaka okanikei wane kito edaniake, eŋe qeli gege togon kotino, eŋetine ketkele nigagatne payake. Ŋo nat paromine yemo mane eŋe ra rokop don ea dere tewekeake, so ŋei natne eŋe kop weku eaka okanikei wane kito edaniake, eŋe qeli gege togon kotine, eŋetine suaine, ŋei wawaine geake. ");
INSERT INTO ons_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ea wane na ŋidanbe detpi, ŋine Anutuŋo numa koboine mogare arikei wane wetkemaike, ea bororom teweke mogare arikeiwo, yemo ŋine ewekeu paki, qeli gege togon wane numa kotino maine wakesikei. Ŋo ŋine ra rokop don kito ebo ebon, so Parisi eŋane masi tanik ea mi yuan onbi paki, qeli gege togon kotino mi wakesikei.” ");
INSERT INTO ons_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ŋine mokaka ŋabokop ŋine don iwa yale edange, ea mo detmami, ‘Ge ŋei mi qem seukeake, ŋei mane eŋe ŋei qeki seukeake, eŋe baŋ ma ari wano wanok ŋei wane kaitko birakau okorayake.’ ");
INSERT INTO ons_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ŋo noŋo yemo iwa yale ŋidanbe detpi, ŋei mane eŋe kimainerop sot osi osi okaniake, eŋe baŋ ma more wano wanok ŋei wane kaitko birakau okorayake, ŋei mane eŋe kimaine iwa yale orayake, ‘Ge maine yemo yaup wane!’ Yale orayake, eŋe baŋ ma more Kaunsol wane kaitko birakau okorayake, so ŋei mane eŋe kimaine ‘Borikine qelaŋ togole,’ orayake, eŋe baŋ sora gerep wikile teinerop ea ari kesiake. ");
INSERT INTO ons_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Eso ea wane ge mo Anutu bakom okan kakenane, arata osino ari okorakeneo, ŋine eaka kimaŋineŋo ŋaba ŋaba ŋine payake, yewa desikene, ");
INSERT INTO ons_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","paki qeligenom, bakom kine kineŋone ea arata osino metki, esatkamde kimaŋinano arinom, ŋaba ea makoboeuk qoeki, peamgo zinge sari more, Anutu bakom okankakene. ");
INSERT INTO ons_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ŋei maneŋo geŋane kine ra more dongo geu ariakeo, yemo ge ŋaba ŋonerop ari numao maratka more, naso pamaike, eaoka eŋerop kima okan naguwik qoeki, ŋado dongo arikene. Yale mi okangeneo, yemo ge ari lotkenom, eŋe geu more, wano wanok ŋei wano biraganiake, paki oŋo geu tebe ŋei wano biragangi, tebe ŋeiŋo baŋ mulap urumgo bira gangi wakesikene. ");
INSERT INTO ons_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na welekatne golatpe, ge yewa naso kiroine wikilerop met mage, baŋ kimaŋonane sot ikop mi qoeake, ea korop qolekanom qoewareki, ge maine kesikene. ");
INSERT INTO ons_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ŋine don iwa yale raraine pamaike, ea mo detkoi, ‘Ŋao ŋanom ŋire misuk qeliŋ nagukeik, paki ŋei ge ŋerep mane misuk maikene!’ ");
INSERT INTO ons_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ŋo noŋo yemo iwa yale ŋidanbe detpi, ŋei mane eŋe ŋerep mane kayake paki, mayakane wetkeake, eŋe eŋine ŋanomine mo qeliŋkaki paki, wetineŋo eŋerop bailalaŋ okane more, sotkorop okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ea wane ge deŋone wongoken eaŋo borikine makenane tebaganiakeo, qe pitikenom saketki biranom ariake! Solaŋone sisine wekuŋo midayake, yemo zok wekumane, ŋo solaŋone koropŋo sora gerepko birau kesiake, eaŋo maine mi okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ge meteŋone wonŋo tebagangi borikine makeneo, yemo ge kitare so biranom ariake! Ge bikumŋone sisine weku qeliŋkakene, eaŋo yemo zok wekumane. Ŋo solaŋone koropŋo ari sora gerepko kesiake, eaŋo maine mi okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ŋine don iwa yale raraine pamaike, ea mo detkoi, ‘Ŋei mane eŋe ŋanomine qeliŋ kayakane okane, eŋe zokit kita kitat wane kibi mane kine desikei wane mire, ŋanomine maniake, masi ea maine okanmaike.’ ");
INSERT INTO ons_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ŋo noŋo yemo iwa ŋidanbe detpi, ŋei mane eŋe ŋanomine maineka ge mageuk paki, qeliŋkaki ari, ŋei mane koso mayakeo, yemo ŋei yewa eŋe okangi, ŋanomine eŋe bailalaŋ okanike, ea wane ŋei yewa eŋe sot korop okanmaike, so ŋei yewa eŋe ŋerep ŋaonerop, ea meke, eŋe yaleka bailalaŋ okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ŋine mokaka ŋei don iwa yale edange, ea mo yaleka detkoi, ‘Ge donŋone rakone, ea misuk kitasikene, ge makenane ranom paki, Waom wane biŋek ra togolekone, ea siluŋ makene.’ ");
INSERT INTO ons_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ŋo na iwa ŋidanbe, ŋine kine kine mane makei wane rau paki, don yau yaup eao more misuk ra togolekei, qeliwo mode more, misuk ra togolekei, onoka wane qeli yemo Anutu wane met met. ");
INSERT INTO ons_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Me kepeo misuk mode more ra togolekei, onoka wane kepe yemo Anutu wane gesoke met metine, me Yerusalem matko mode more misuk ra togogolekei, onoka wane ea yemo ŋei Waom suainane mat. ");
INSERT INTO ons_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Me leweŋino misuk mode more ra togolekei, onoka wane ŋine leweŋine zoune mane mau mi wakoeake me mi sigileake. ");
INSERT INTO ons_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ŋine rawe raso yemo ‘Okkei’ me ‘Mida’ maine rakei. Don natne yaup rakei, ea yemo ŋei borikine welainano ŋine sarimaike. ");
INSERT INTO ons_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ŋine don iwa yale raraine pamaike, ea mo detkoi, ‘Ŋei maneŋo geŋane deŋone qe pilikki, ge turuŋine eŋane deine qe pilikkene, so mane eŋe geŋane ŋetŋone kito muzuŋgi, ge turuŋine eŋane ŋetne kito muzuŋgene’ . ");
INSERT INTO ons_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ŋo noŋo yemo iwa ŋidanbe detpi, ŋei mane eŋe masi qotkoine okan ŋungi, ŋine turuŋine qotkoineka mi okankakei. Ŋo ŋei mane eŋe tagenŋine wongoken ŋinguyakeo, ŋine tagenŋine kanaoken ea weneŋ sunkau ŋinguyake. ");
INSERT INTO ons_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ŋo ŋei mane eŋe mulapko biraganiakane geu ari takotŋone mayakeo, ge momo takotŋone ea weneŋ sunkanom mayake. ");
INSERT INTO ons_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","So kawali ŋei magu eŋane keuoŋine mane eŋe aboŋine numa bamgo ea wane rokop ma arikenane soringangi, ge maine ewekine numa kiroine ea wane rokop ma arikene. ");
INSERT INTO ons_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ŋei mane kine kine mane manikenane ra gangi, eŋe maine manikene. Ŋei mane eŋe geŋano ŋine kine kine mane kulit geu mayakane raki, ge kine kine ea maine eŋe manikene. ");
INSERT INTO ons_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ŋine don mane iwa yale raraine pamaike, ea mo detkoi, “Kimakopŋine wet maep okan onikei, ŋo ŋabakopŋine yemo qaisik onikei.’ ");
INSERT INTO ons_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ŋo noŋo yemo ŋidanbe detpi, ŋabakopŋine wet maep okan ongei, paki ŋingu matali okanŋungei, eŋane Anutu meŋenkau, turuŋene bira yake. ");
INSERT INTO ons_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yale okanbi paki, ŋine baŋ Magaŋine qeliwo gemaike, eŋane gipolekoune okangei. Eŋe maki kaiweineŋo sirike, ŋei ŋerep maine so borikine eŋano rokop wekuka qe okanmaike, so koya ebon okanmaike, ŋei ŋerep masi maine okanmami, so tanik borikine okanmami weneŋ. ");
INSERT INTO ons_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ŋine ŋei ŋereppa wet maep okan ŋunmami, eŋeka weku wet maep okan ongeiwo, yemo Anutu eŋe onoka wane lewine qole ŋuniake? Takis so borikine mama ŋei eŋe yaleka ea ma okanmami! Kepe ŋei wane rokop yuankaikei! ");
INSERT INTO ons_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","So ŋine kimakop ŋine eŋeropka weku don awo nagukeiwo, yemo ŋine ŋei ŋerep natne onokaŋo tebaongei? Qelaŋ ŋei ŋerep eŋe yaleka ea ma okanmami! Kepe ŋei wane rokop yuankaikei! ");
INSERT INTO ons_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ea wane ŋine koboboine gekei, Magaŋine qeliwo eŋe koboboine gemaike, ŋine eŋane rokop magekei! ");
INSERT INTO ons_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ŋine miti urata kine kine maine ea ŋei ŋerep eŋane deeno mau, edo ŋune more, solaŋine mawakei wane, ŋine misuk maikei. Ŋine urata kine kine korop iwa ŋei ŋerep eŋane deeno mau, solaŋine mawakeiwo, yemo ŋine baŋ ea wane lewine Magaŋine qeliwo gemaike, eŋano ŋine mane mi makei. ");
INSERT INTO ons_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ea wane ŋine kine kine mane ŋei mane wanap aboŋine midaine manbe ra, yemo ŋine ukat sua didiwo, yale misuk okangei. Miti ŋei isisine edo lewa lewaŋ urumgo so numa suaino okanmami, eŋe ŋei ŋerep edo one more mawa ongei wane, yale okan okanmami. Iwa yale desikei! Eŋe ea wane lewine mo korop qoleon wareke. ");
INSERT INTO ons_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ŋo ŋine ŋei mane wanap aboŋine midaine qesiŋkawe ra, yemo ŋine sanka siu siuko qesiŋkau, kimaŋine osoŋino gemaike, eŋe ea wane kine misuk desiake. ");
INSERT INTO ons_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ea yemo baŋ geŋone bonepŋone okaniake, paki Magaŋone, eŋe kine kine onokaka bonepŋone okanmaine, ea kaki paki lewine baŋ qoleganiake. ");
INSERT INTO ons_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ŋine meŋenkawe ra, miti ŋei isisine eŋe yale misuk okangei! Eŋe lewa lewaŋ urumgo ŋei ŋerep eŋane kaitko wie okorau paki meŋenkakei wane, so numa qesik qesikino ŋei ŋerep edo one more mawa onikeiwane on okanmaike. Iwa yale desikei! Ŋei ŋerep eŋe one mawaon okanbi, eaŋo lewineene okangi, mo korop qoemaike, Anutuŋo baŋ lewineene mi qoleake. ");
INSERT INTO ons_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ŋo ge meŋenkakenane okannom paki, urumŋone koto waket more, madetŋone kitokene, paki Magaŋone deŋo mi kakaine, eŋe meŋenkakene. Eso Magaŋone eŋe onokaka bonep okanmaine, ea kaki paki, lewine baŋ qoleganiake. ");
INSERT INTO ons_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Meŋe meŋenŋino don loutne wele midaine misuk dapore meŋenkakei, yale ŋei miti midaine, qelaŋ edo meŋenka okanmami. Eŋe iwa yale wetke okan okanmami, Anutuŋo meŋe meŋenene baŋ desiake, onokawane eŋe meŋe meŋen kiroroine meŋen kamami, ea wane. ");
INSERT INTO ons_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ŋine eŋe yale meŋe meŋen kiroine misuk okangei, Magaŋine eŋe onokaka mikepka zuageu paki olatmami, ea mo detmaike. ");
INSERT INTO ons_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ea wane ŋine iwa yale ra meŋenkakei, ‘Ŋenane Magaze ge qeliwo metmaine, geŋane eŋetŋone koboboine payake, ");
INSERT INTO ons_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Sari koto baŋem kepe baŋem Waom okanŋonnom, qeliwo geŋane aŋa tewe tewek pamaike, yale waka kepeo ŋenano wakoniake. ");
INSERT INTO ons_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ge ukude ŋaraze ŋebonikene, ");
INSERT INTO ons_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ge borikineze korop qeliŋ warekene, ŋene yaleka matali ŋonmami, ŋei yewa eŋane borikineene qeliŋ waremaine. ");
INSERT INTO ons_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ge liwe liwek togolo misuk biraŋonikene, siluŋ borikino ŋine makok ŋonikene.’ ");
INSERT INTO ons_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ŋine ŋei ŋerep borikine okanŋunbi, eŋane sot turuŋ qeliŋgeiwo, yemo Magaŋine qeliwo gemaike, eŋe yaleka ŋinane sot turuŋine baŋ qelige ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ŋo ŋine natne eŋane sot turuŋ mi qeliŋgeiwo, yemo Magaŋine qeliwo gemaike, eŋe yaleka ŋinane sot turuŋ okanmami, ea mi qeligeake. ");
INSERT INTO ons_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“So ŋine miti wane sawe gekei, naso yewao kaitŋine zoileki miti ŋei isisine eŋane masi misuk okangei. Eŋe lolike ariu, ŋara wane seukmami yale kaitene onbi paki, ŋei ŋerep eŋe sawe gemami, yale dere ebongei wane yale okanmami. Ŋine iwa yale desikei! Ea wane lewine eŋe mo korop mau qoeke. ");
INSERT INTO ons_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ge miti wane sawe gege wane ŋara midaine ge arikene, naso yewao kaitŋone sauke, so leweŋone yasokene. ");
INSERT INTO ons_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yale okannom, ŋei ŋerep natne eŋe ge sawe gemaine, ea wane kine maine mi detkei. Geŋane Magaŋone deŋo mi kakaine, eŋe wekuŋo baŋ desiake. So Magaŋone eŋe ge bonepŋone kine kine daleo mamaine, ea kaki paki, lewine baŋ qoleganiake. ");
INSERT INTO ons_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ŋine aboŋ kine kine loutne iwa kepeo misuk more maguke wakei, ea sip kine kineŋo ki barakeake, so weŋemine zeki paki barakeake, so kobu mama eŋe ra barake waket kobu ma arikei. ");
INSERT INTO ons_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ea wane turuŋ, ŋine wet maep wane aboŋ kine kine, ŋine maine weti qeli kotino pamaike, ea more maguke wakei, ea yemo sip kine kineŋo mi ki barake mataliake, so weŋemine mi zeake, so kobu mama edo ra barake waket, kobu mi ma arikei. ");
INSERT INTO ons_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aboŋ kine kineŋone pamaike, yewaoka wetŋone motnom, naso baŋem pa ariake. ");
INSERT INTO ons_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Deŋo sola wane kiwa yale okanmaike. Deŋone maine payakeo, geŋane solaŋone korop qelaŋan ŋoka watke payake, ");
INSERT INTO ons_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ŋo deŋone boriakeo, yemo solaŋone korop eamo baŋ panaman koto qeka maka okaniake. Eso ea wane rokop kotoŋono qelaŋan pamaike, ea komayakeo, yemo panaman i zok manerop wakongangi, qeka maka okangene! ");
INSERT INTO ons_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ŋei wekuŋo ŋei waom etke erane qelit maine mi mayake, eŋe baŋ mane qikkaki paki, mane wet maep okan kayake, eŋe baŋ mane wano makatake more, mane ŋadekkayake. Ŋine Anutu wane qelit so wesi urata orodoŋka maine mi makei. ");
INSERT INTO ons_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ea wane na ŋidanbe detpi, ŋine ŋara so doku kine kine me takot lap lap solaŋine qekat kekeiwane ŋaŋaeu paki, onokaŋo qesiŋ ŋongi gekene ra, gege ŋinane dere mezet mi okangei. Gegeŋo manerop wele, ŋara mi yuankamaike me? So solaŋo manerop wele, takot laplap mi yuankamaike me? ");
INSERT INTO ons_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Naŋi onbi riwe ari sari gemami, eŋe ŋara mi ebot okanmami, eŋe ŋara mau waki maune ŋara urumgo mi mot okanmami, Magaŋine qeliwo gemaike, oŋo wareongi ge okanmami. Ŋine leweŋine zok manerop suaine, naŋi eŋane rokop mi yuankamaike me? Magakŋo qeliwo gemaike, wareŋuneake. ");
INSERT INTO ons_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ŋinano ŋine mane maŋo koma natne koso manerop takotke geki paki, ea wane maine dere mezet okane geake? ");
INSERT INTO ons_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“So onoka wane takot laplap wane zok dere mezet okanmami? Ŋine onbi, eki zubaine zuraune daleo sua okanmami? Eŋe takot laplapenane urataine mi ma okanmami, me edomka mi ma okanmami. ");
INSERT INTO ons_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ŋo na siluŋ ŋidanbe detpi, Solomon eŋe aboŋine suaine gekeŋo takotine kibi maep korop, eki zuraune iwa wane rokop mi ma geke. ");
INSERT INTO ons_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iwamo Anutu oŋom touk zubaine takotene biraon okanmaike. Touk eamo ukude iwa okoramami, wane qaekiwo yemo mida lele arikei, gerep koto qakeu waketpi ezoki siuk warekei. Wane eŋe ŋine takot manerop mi qorotŋuniake me? O, mali malip ŋigagatneka ma gemami! Dere mezet mi okane gekei! ");
INSERT INTO ons_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eso yalinane ŋine kieke dere mezet mi okane rakei, ‘Ŋarane dia ŋine sariki nekale? Me dokune dia ŋine maratka nekale? Me takot laplapne dia ŋine ma au gekale?’ ");
INSERT INTO ons_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kine kine iwa yemo korop qelaŋ edo ea wane naso baŋem ra okanmami. Magaŋine qeliwo gemaike, eŋe ŋine kine kine iwa korop ŋaŋaemami, ea mo det waremaike. ");
INSERT INTO ons_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ea wane turuŋine yemo, ŋine kine kine kepe wane kutno pamaike, ea wane dere mezet mi okane gekei, ŋine qeli gege togon wane aboŋ so kine kine onokaka Magakŋo wetkemaike, ea makei, pakimo eŋe kine kine natne kepe iwa korop, ea baŋ ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Eso yalinane qaeki wane dere mezet mi okangei. Qaeki wane dere mazet eŋe baŋ qaeki oŋomka rokouno dere mezet okaniake. Kaiweine kaiweine eaŋo umatpae ma sarimaike, eao misuk takotkekei.” ");
INSERT INTO ons_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ŋine ŋei natne misuk wanok ongei, eso yale okangei, yemo Anutuŋo ŋine yaleka baŋ mi wanok ŋuniake. ");
INSERT INTO ons_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Onoka wane, ŋine ŋei natne wanok ongei, ea wane rokopka Anutu eŋe ŋine wanokŋuniake, so ŋine ŋei natne numa rokop more ebongei, numa weku eaka Anutuŋo baŋ ŋine more ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Pakimo ge onoka wane kimaŋonane deino gok pamaike, eamo kamaine, ŋo geŋone deŋono eki sisine metmaike, eamo mi kamaine? ");
INSERT INTO ons_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Eki sisine geŋone deŋono metki, ge daleo kima ŋone iwa yale olasikene, ‘Kima, ge detnannom, na deŋono gok metmaike, ea kitowe saketkep?’ ");
INSERT INTO ons_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ge isi ŋei! Eki sisine geŋone deŋono pamaike, ea alakane manom sakesiake, paki ge deŋone maine pore kakene, eso ŋado kimaŋonane deino ŋine gok ea manom sakesiake. ");
INSERT INTO ons_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kine kine kobekine ea kasi misuk ebongei, eŋe yemo weku zinge mo baŋ ŋidosikei, ŋine zenam ŋine berek eŋane soteno misuk birakei, eŋe yemo weku zolipeneŋo baŋ qe pelekeu kesiake, pakimo koso zinge ŋinŋine ŋaba ŋunikei. ");
INSERT INTO ons_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Meŋenkanom paki, ge baŋ makene, zuaŋ mage ge wele baŋ maratkakene, madetko yatonom, baŋ lalage giniake. ");
INSERT INTO ons_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mane eŋe meŋen kamaikeŋo baŋ mayake, so mane eŋe zuaŋ maikeŋo wele baŋ marat kayake, ŋo mane eŋe madetko yatomaike, eŋe baŋ lalage maniake. ");
INSERT INTO ons_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ŋinano ŋine ma magakŋo gipole bret wane olatki mo, eŋe wesi wanaune maniake? ");
INSERT INTO ons_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Me ma ŋeiŋo gipole zawon wane olatki mo, eŋe koma qotkoine mane maniake? Midakaka. ");
INSERT INTO ons_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ŋine kepe ŋei borikine yalineŋo gipon borasokopŋine ŋara aboŋ maine ebon okanmami. Magaŋine qeliwo gemaike, oŋo kine kine maine manerop baŋ meŋenka okanmami, eŋe maine eboniake! ");
INSERT INTO ons_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Iwaŋo yemo Mose wane ra rokop don ea wane kine so propet eŋane don qeturaŋmaike, ŋine ŋei ŋerep natne edo yeye kine kine okanŋungei wane wetke okanmami, kop yaleka ŋei ŋerep natne eŋe ŋine okanongei. ");
INSERT INTO ons_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ŋine madet qeka qekaine eaka waketkei, onoka wane sora gerep wane madet yemo suaine, so ea wane numa yemo kakapa, yewao ŋei loutneŋo ari okanmami. ");
INSERT INTO ons_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Gege wane madet yemo qeka qekaine, so ea wane numa yemo nigagatne, so numa eaoken arikene yemo umatne so wikile teine, eso ŋei ewekine edoka ea maratka okanmami. ");
INSERT INTO ons_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Propet isisine eŋane diam seleleine makei, eŋe ŋinano sariu onbi, solaeneŋo lama sola okaniake, ŋo kotoeneŋo yemo kasi zubaine, eŋane koto yale payake. ");
INSERT INTO ons_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ŋine kineene yemo baŋ numa kine kine okangei, eao detonikei. Mulap wakelerop, eao wele nenine mi wakon okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eki maine eŋe wele maine qekimo, eki qotkoine eŋe wele qotkoine qeake. ");
INSERT INTO ons_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Eki maine mane eŋe wele qotkoine mi qeake, so eki qotkoine mane eŋe wele maine mi qeake. ");
INSERT INTO ons_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Eki natne wele maine mi qekei, yemo kitatpi ketki gerepko qakeu ezoyake. ");
INSERT INTO ons_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eso yalinao ŋine baŋ propet isisine eŋane tanik manik okangei, eao kineene detongei. ");
INSERT INTO ons_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ŋei ŋerep loutneŋo ‘Waom, Waom,’ nora okanmami, eŋe koropŋo qeli gege togon kotino mi waket warekei. Magane qeliwo gemaike, eŋane aŋaine teweke more, urata ma okanmami, edoka weku waketkei. ");
INSERT INTO ons_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kaiwe naso yewa bomile sariki, ŋei ŋerep loutneŋo baŋ iwa yale nolale rakei, ‘Waom, Waom! Geŋane eŋetko gora more, ŋene Anutu wane don edangone, geŋane eŋet gora more, ŋene asu qotkoine loutne esop onŋem saket ariwarekoi, so masi togogole loutne ma okangone!’ ");
INSERT INTO ons_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yale raumo, na baŋ iwa yale edangale, ‘Na ŋine mi detŋungole, wie biranane ari wareu, ŋine borikine mama!’ ");
INSERT INTO ons_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Eso ŋei mane eŋe naŋane don iwa dere tewekeake, eŋe baŋ ŋei mane dereretinerop yale okaniake. Ŋei dereretinerop mane oŋo matine wesi kutno maki metke. ");
INSERT INTO ons_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Paki koya suaine qeki doku qakum suaine wieke, so momo suaine togogole puane more, mat ea qe make, ŋo siluŋ mat ea mi mak maŋge, onoka wane mat ea wesi kutno make, ea wane togole metke. ");
INSERT INTO ons_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ŋo ŋei mane eŋe naŋane don iwa dere mi tewekeake, eŋe ŋei mane qelaŋ yale okaniake. Ŋei qelaŋ mane eŋe matine gumo gumo kutno make. ");
INSERT INTO ons_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Paki koya suaine qeki, doku qakum suaine wieki, momo suaine puane, mat ea togoleka qe mak maŋge. Makmaŋgi okmage ket zaŋ zuŋ make!” ");
INSERT INTO ons_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu eŋe don iwa korop rawareki qoeki, ŋei ŋerep magu suaine eŋe miti rarainane detpi paki, oŋaene qaeki welelepkekoi. ");
INSERT INTO ons_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Eŋe ra rokop don kito ebo ebonkopene, eŋane dereret wane rokopko mi edange, eŋe miti don zonominerop edange. ");
INSERT INTO ons_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu eŋe bonagao ŋine ketki, ŋei ŋerep magu suaineŋo ŋadino arikoi. ");
INSERT INTO ons_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ŋei mane kube rubet eŋe Yesu wano sari more, wawetine qe umi ketki paki rake, “Suaine, ge naŋane simile ganmaikeo, yemo maine neunom menaŋgale.” ");
INSERT INTO ons_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesuŋo metine bira, so solaino make, pakiso olatke, “Na simile nanmaike. Ge kubetŋone osikep!” Rakiso eaka kubetine piridiŋgi libe qe osike. ");
INSERT INTO ons_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pakiso Yesuŋo olale rake, “Detnom! Ge ŋei mane misuk edangene, ge siluŋ pris wano koboine ari sikankanom, solaŋone ganiake, pakiso Moseŋo rake, yale soe soep mitnom, ŋei ŋerep eŋe gane more, ge solaŋone osike, ea desikei.” ");
INSERT INTO ons_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu eŋe Kaperneam matko ari waketki, Roman kawali ŋei eŋane ware ware maneŋo maratkaki paki, mapik kayakane olale rake, ");
INSERT INTO ons_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Suaine, naŋane qelit medepne, eŋe matko zomakaki pamaike, eŋe kie metine seu seune okanmaike, wikile zok manerop detmaike.” ");
INSERT INTO ons_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Rakiso, Yesuŋo olatke, “Na baŋ ariwe paki, mawe menageake.” ");
INSERT INTO ons_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Raki, kawali ŋei eŋane ware wareŋo mainge olale rake, “O, mida suaine, na ŋei maine mida, ea wane ge naŋane matko misuk sarikene, ge yaup iwa mere donŋoka ranom menageake. ");
INSERT INTO ons_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na yaleka, ŋei suaine wawaine kiqa guruŋ guruŋ enerop eŋet biŋek suaine, eŋane bango ketkele gemaile, so na kawali ŋeikopne ebuwe, eŋe naŋane bango gemami. Wane na eŋano ŋine mane wane rakale, ‘Ari!’ Rawe eŋe ariake, so mane eriwa wane rakale, ‘Sari!’ Rawe eŋe sariake. So na qelit medep wane rakale, ‘Iwa manom!’ Rawe eŋe ea mayake.” ");
INSERT INTO ons_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu eŋe don ea dere welepke more, ŋei ŋerep ŋadino arikoi eŋe edane rake, “Na rawe delukkeu, na mali malip iwa yaline Israel ŋinane keuo ŋine mane wano mi ka okanmaile. ");
INSERT INTO ons_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ea wane iwa detpi! Ŋei ŋerep loutneŋo kepe deine samaikeo ŋine, so ketmaikeo ŋine, baŋ sari more, ŋara nene zakeo qeli gege togon kotino pese ket, Abraham, Isak, so Yakop, eŋerop weneŋ mesikei. ");
INSERT INTO ons_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ŋo ŋinano ŋine Yuda welaine natne qeli gege togon kotino gegine, eŋe mi waketkei, yemo baŋ ebu biraongi, panaman koto qeinat ket more, yewao baŋ aroke ŋet warik warik ki gekei.” ");
INSERT INTO ons_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pakiso, Yesuŋo ware ware olale rake, “Matko arinom, pakimo ge detluke malipkamaine, ea wane welewa eamo wakonganiake.” Pakiso nasomde eaka ware ware wane qelit medep menaŋkake. ");
INSERT INTO ons_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu eŋe Petoro wane matko arike, eso ea kaki Petoro sewenine eŋe zoma kaki papaino pake, zoma gereunerop qeke. ");
INSERT INTO ons_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Eŋe ka more metino maki, so zomaŋo qeliŋka arike, paki so ŋerep eŋe wieki paki, kieke ŋaraine mire mauluke Yesu mange. ");
INSERT INTO ons_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kepe qoeki, ŋei ŋerep eŋe ŋei ŋerep loutne asu qotkoineŋo kotoeno ket gekoi, ea ebu Yesu wano sarikoi. Yesu eŋe asu qotkoine ea donŋo ra esopongi saket warekoi paki, zoma onge ea korop ma menaŋon wareke. ");
INSERT INTO ons_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Eŋe yewa okange, yemo propet Isaiaŋo don mane sogino iwa yale rake, ea wane weleine wakoniakane ea make, “Eŋe oŋomka ŋenane zomaze ŋebu mawareke, so zoma kine kineze korop teweke ariwareke.” ");
INSERT INTO ons_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu eŋe ŋei ŋerep loutneŋo sari lolikkau ongi paki, eri doku namuŋ nat arikei wane dokoine edange. ");
INSERT INTO ons_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pakiso, ra rokop don wane kito ebo ebon maneŋo Yesu wano sariki paki rake, “Kito ŋebo ŋebon, na mo ewekmaile, ge yewao me yewao arikene, na weneŋ gerop arikale.” ");
INSERT INTO ons_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesuŋo mainge olatke, “Kasi zubaine eŋe aŋapenerop kulu pamami, so naŋi eŋe matenerop, ŋo Ŋei Wawainane Gipole eŋe yemo matine midaine, diawao ket paki paki zonom mayake?” ");
INSERT INTO ons_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ŋei mane, eŋine dokoine eŋane keueno ŋineŋo Yesu olale rake, “Suaine, mikepka qeliŋnanom, zinge ari magane seukkeakane okangi paki, seukke dukkawe paki, baŋ zinge ŋadeŋono koso sarikale.” ");
INSERT INTO ons_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesuŋo mainge olatke, “Yeine ŋadeno sarinom, paki seuseune gege togon qeliŋonnom, edomka seuseune kopene dukongei.” ");
INSERT INTO ons_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu eŋe seki koto waki, so dokoine eŋe eŋerop weneŋ arikoi. ");
INSERT INTO ons_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ariu yewaka momo suaineŋo sari doku namuŋ eao qe talekaki, dibom suaine tepke wie more qakki, seki somekake. Ŋo Yesu eŋe kulu pake. ");
INSERT INTO ons_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dokoine eŋe eŋano ari ma wirikkau wieki olale rakoi, “Waom qesiŋ ŋonnom, ŋene mo midakenane okanmaine!” ");
INSERT INTO ons_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesuŋo edane rake, “Ŋine mali malipŋine nigagatne onoka wane zok kaet ŋunmaike?” Yale edangi paki wie more, momo so dibom don etane rawet otke, pakiso momo ea giriŋ doŋ mane pakiso kaloŋ suaine dumene pake. ");
INSERT INTO ons_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ŋei eŋe ea kau paki welelepke more rakoi, “Yai, ŋei iwa eŋe ma? Yaline ea wane momo so dibom ere aŋaine tewekmamik!” ");
INSERT INTO ons_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu eŋe sari Gadara ŋei eŋane kepeo doku namuŋ nat paromine ea lotkeke, pakiso ŋei etke eto marat kakoik, ere ŋei dukon dukon kem ea ŋine saket sarikoik. Ŋei etke ea ere asu qotkoineŋo koto etno ket gekoi, ea wane ere zok zubaine okanbik, ŋei ŋerep maneŋo numa eaka mane mi ari okangoi, kaet okangoi. ");
INSERT INTO ons_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ere esatka aroke rakoik, “Anutu wane Gipole, ge ŋere daleo okan ŋotkene? Ge naso koboine mi bomileki, ŋere wikile alakane ŋepongenane sarimaine me?” ");
INSERT INTO ons_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Berek magu mane eŋe abaran mida, osop ŋara ne gekoi. ");
INSERT INTO ons_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Asu qotkoine eŋe Yesu togoleka olale rakoi, “Ge esopŋonnom saket keneo, yemo taleŋonnom ari berek magu yewa eŋane kotoeno kesikene.” ");
INSERT INTO ons_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesuŋo edange, “Ariu,” rakiso, eŋe saket more ari berek eŋane kotoeno ketwarekoi. Pakiso berek magu yewa eŋe sora wazaino biririke ari, so doku namuŋ koto ketpi ma qorok onwareke. ");
INSERT INTO ons_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ŋeiwa berek wareone gekoi, eŋe biririke mat suaino ari ŋei ŋerep donkisi korop edangoi, so ŋeiwa asu qotkoinerop ere daleo okangoik, ea wane don kisi weneŋ edangoi. ");
INSERT INTO ons_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Pakiso, ŋei ŋerep koropŋo mat suaino ŋine Yesu kakeiwane arikoi, Ari kau pakiso kepeene ea qelige ariakane olatkoi. ");
INSERT INTO ons_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu eŋe seki koto waki paki, zinge koso doku namuŋ yuane more eŋine matino sarike. ");
INSERT INTO ons_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pakiso ŋei natne eŋe ŋei mane kie metine bori worine eŋano ma sarikoi, eŋe supi kutno pake. Yesu eŋe mali malipene zok pake, ea detki paki, ŋei kie metine seu seune eŋe olale rake, “Togolenom, medepne! Geŋane sotŋone mo oma ganmaile.” ");
INSERT INTO ons_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Paki ra rokop don kito ebo ebon ŋei natne eŋe edomka auye rakoi, “Ŋei iwa ono ka wane eŋe Anutu ewe mabaik okan kamaike?” ");
INSERT INTO ons_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu eŋe ea wetkekoi, ea wane wetenane kine detongi paki rake, “Ŋine wetŋineŋo onoka wane borikine wetkemami? ");
INSERT INTO ons_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Diawaŋo ewekine raikene, ‘Geŋane sotŋone mo matalimaile’ , me raikene, ‘Wienom paki, arinom’ ? ");
INSERT INTO ons_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ea wane na baŋ ra qelaŋanŋunbe ŋine detpi, ŋei Wawainane Gipole eŋe kepeo ŋei sotene mataliki siukeakane zonom pa manmaike.” Eso yale edane, so ŋei mete seu seune eŋe olale rake, “Ge kaŋzaŋ wienom, lameke papaŋone manom paki, matko arinom!” ");
INSERT INTO ons_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ŋei eŋe kaŋzaŋ wie, so matko arike. ");
INSERT INTO ons_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ŋei eŋe ea kau paki kaetonge, paki Anutu eŋe zonom iwa yaline ŋei ebongane mawa kakoi. ");
INSERT INTO ons_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu eŋe mat yewa qelige arike, eso eŋe ari ariki paki, ŋei mane takis mama eŋe kake, eŋetine Mataio, eŋe takis mama urumine koto metke. Yesuŋo olale rake, “Ŋadeno sarinom.” Rakiso Mataioŋo kaŋzaŋ wie ŋadino arike. ");
INSERT INTO ons_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu eŋe eŋane matko ŋara ne metki, eaka takis mama ŋei so borikine mama ŋei loutneŋo sari, eŋe so dokoine eŋano takotke more, eŋerop ŋara zakeo weneŋ metkoi. ");
INSERT INTO ons_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisi natneŋo ea kau paki, dokoine edane rakoi, “Ŋinane kito ŋibo ŋibon eŋe onoka wane takis mama so borikine mama eŋerop mere ŋara nemaike?” ");
INSERT INTO ons_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yale rau, Yesuŋo detongi paki edange, “Ŋei ŋerep solaene maine weteno dere, edo dokta wano mi ari okanmami, ŋo zoma kubet korop edoka weku ari okanmami. ");
INSERT INTO ons_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ŋine ariu paki, Anutu wane papiaŋo don iwa daleo wane ramaike, ea wane dapotpi paki, kine maine detlukkei, ‘Anutuŋo ramaike, na osomŋo soe soep yauwine rokouneka mire nin okanmami, ea wane na zok mi simin nan okanmaike, wet borik so mauluk mauluk wane simin nan okanmaike.’ Raki paki koso rake, na ramaile, na ŋei maine eweenerop wetene detokanmami, na eŋe edora newan ongalane mida, borikine mama, borikinene ŋadekakei wane, na edora newan ongalane ketkole.” ");
INSERT INTO ons_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Naso yewao Yohane doku tau tau wane dokoine eŋe Yesu wano sari qesonka rakoi, “Onoka wane ŋene so Parisi ŋedoka sawe gamaine, ŋo geŋane dokoŋone eŋe mane kaki sawe mi ge okanmami?” ");
INSERT INTO ons_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesuŋo edange, “Ŋine ŋei lobo zokit mama wane batko sarimi, eŋe ŋerep ŋaone eŋe eŋeropka geki, eŋe wet borik okan okanmami me? Yale midakaka! Ŋo baŋ naso bomileake, yewao ŋerep ŋaone eŋe kimakoune eŋano ŋine ma arikei, eao yemo eŋe baŋ ŋara midaine, sawe ge arikei.” ");
INSERT INTO ons_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yale raki paki so koso don rokop mane rake, “Ŋei maneŋo lap lap tutu museleŋo takot suaine sogine bara warakine eao maine mi maturage qetusiake, onoka wane tutu musele eaŋo abongi, takot suaine sogine ea barakki, aŋaine koso manerop suayake. ");
INSERT INTO ons_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Me don mane wele wekuku, ŋei maneŋo wain doku musele ea qeki, wain solaine soginane eao maine mi weteake. Ŋo eŋe qeki wetemaikeo, yemo wain solaine barake, pakimo wain musele ea qake saketki solaine ea borimaike. Ea wane tungo, yemo wain musele ea wain solaine musele eao qeki weteake, pakimo eretnarek maineka pakeik.” ");
INSERT INTO ons_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu eŋe don iwa edane okoraki, Yuda ŋei eŋane ware ware maneŋo eŋano sariki paki, wawetine qeki paki olale rake, “Naŋane borasone mo seukmaike, ŋo siluŋ sarinom paki, meteŋone kutno motnom eŋe baŋ wisikae geake.” ");
INSERT INTO ons_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Eso Yesu eŋe wie more ŋadino mogare ariki, dokoine eŋe weneŋ arikoi. ");
INSERT INTO ons_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ŋo ŋerep mane eŋe ŋerep zoma qotkoine naso kiroroine zok geki, koma 12 okange, oŋo Yesu wane ŋadino sariki paki, takotinane mezeno ea make. ");
INSERT INTO ons_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Paki eŋe oŋomka wetke rake, “Na weku takotine uakakaleo, yemo na baŋ menaŋgale.” ");
INSERT INTO ons_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesuŋo zinge more, eŋe kake paki rake, “Borasone, mi kaet gangep! Geŋone mali malipŋoneŋo geuki menaŋmaine.” Rakiso yewaoka ŋerep ea solaine menaŋkake. ");
INSERT INTO ons_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Eso Yesu eŋe ware ware wane mat koto ari wake, paki onge seu seu wane mulup pua puan ŋei eŋe puangoi, ŋo ŋei ŋerep natne korop eŋe aro suaine arokkoi. ");
INSERT INTO ons_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesuŋo edane rake, “Ŋine korop ket wareu! Ŋerep ŋerep eŋe mi seukmaike, eŋe yemo kulu pamaike!” Eŋe korop kieke tenik kakoi, ea wane mo seukmaike detkakoi. ");
INSERT INTO ons_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ŋei ŋerep korop ebuwi ket wareu, Yesu eŋe eaka ŋerep wane urum koto wake, pakiso metino malipka okoraki, so eŋe kaŋzage wieke. ");
INSERT INTO ons_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pakiso ea wane don kisiŋo kepe yewao korop sua arike. ");
INSERT INTO ons_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu eŋe mat ea qelige ariki, yewaka ŋei de pilik etke ere ŋadino kieke mogare arikoik. Paki suaineka boka rakoik, “Ge Dawit wane qerakine, Anutuŋo biragangi ŋenano ketkone, ŋerane wetŋone borikep!” ");
INSERT INTO ons_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu mat koto waki, eaka ŋei de pilik etke ere eŋano sarikoik. Pakiso eŋe qeson ore rake, “Na iwa maine makale, ea ŋire malip nanmamik?” Ere mainge rakoik, “O, Suaine malip ganmaite!” ");
INSERT INTO ons_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pakiso Yesu eŋe de etno ma so rake, “Ŋire detluke malipnanimik, ea wane rokopko maine wakon ŋusiake!” ");
INSERT INTO ons_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Rakiso, de etne koso manerop pot lotkekoik, pakiso Yesuŋo don togoleka etane rake, “Iwa wane don kisi ŋei mane misuk edangeik!” ");
INSERT INTO ons_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ŋo ere don ea detpik paki, soringe ari Yesu wane donkisi ra sua ariuk, eŋane don kisiŋo kepe ea korop rokopke arike. ");
INSERT INTO ons_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ŋei yewa ere ariuk, so ŋei natne eŋe ŋei mane qelaŋ don mi raraine, ea Yesu wano ma sarikoi, onoka wane eŋe asu qotkoineŋo kotino ket geke, ea wane ma sarikoi. ");
INSERT INTO ons_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Wane asu qotkoine ea esopkaki saketki, so eaka ŋei yewa eŋe don kieke rake. Pakiso ŋei ŋerep magu suaine eŋe kau paki, oŋaene qaeki welelepke rakoi, “Masi iwa yaline Israel ŋenano mane mi wakongi ka okangone me?” ");
INSERT INTO ons_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ŋo Parisi eŋe yemo rakoi, “Iwa yemo asu qotkoine eŋane suaineene oŋo zonom mangi esopongi saket arimami.” ");
INSERT INTO ons_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Eso Yesu eŋe mat suaine so nigatne korop lolike qeare one arike. Eŋe Yuda lewa lewaŋ urum baŋem wa more don kito edange, yemo Waom wane qeli gege togon don kisi maine yewa ra qelaŋane edange, so ŋei ŋerep eŋane keueno zoma kine kineenerop ebuki menaŋwarekoi. ");
INSERT INTO ons_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Eŋe ŋei ŋerep magu suaine ongi paki, eŋane wet borikŋo qomine watkeke, onoka wane eŋe wetene yau yaup motpi paki, kito qesiŋene midaine, lama ware wareene midaine yale gekoi, ea wane ");
INSERT INTO ons_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Eso ea wane eŋe dokoine edane rake, “Ea kau, eu suaine mane yewao, ŋara mo menage pamaike, ŋo ŋara ma more urum koto mot mot wane urata ŋeine yemo ewekine mi okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ea wane ŋine ŋara eu ea wane welaine meŋenkau, eŋe urata ŋei natne biraongi, euino ŋine ŋara ma urumgo mosikei wane arikei.” ");
INSERT INTO ons_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu eŋe dokoine 12 edoraki sari qeturaŋgoi, paki eŋe zonom ebonge, asu qotkoine esoponbi saket arikei wane, so zoma kine kine enerop so kubet kine kine enerop ebuwi menaŋ ongei wane. ");
INSERT INTO ons_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iwa yemo aposolo 12 eŋane eŋetene, lewet yemo Saimon, Petoro orake, so eŋane ŋole Andrea, Yakop, so eŋane ŋole Yohane, Zebedi gipoletkine, ");
INSERT INTO ons_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip so Bartolomu, Tomas so Mataio, takis mama, Yakop, Alpius gipole, so Tadius, ");
INSERT INTO ons_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon Patriot, so Yudas Iskariot, oŋo Yesu ŋaba eŋane meto birakake. ");
INSERT INTO ons_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu eŋe dokoine 12, don iwa yale edangi paki tale ongi arikoi, “Ŋine qelaŋ ŋei eŋane kepeo, me Samaria ŋei eŋane mat maneo misuk arikei. ");
INSERT INTO ons_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ea wane tungo yemo ŋine Yuda wane lama yau yaup ket kere wete ari gemami, Israel ŋei ŋerep magu eŋano ariu. ");
INSERT INTO ons_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ariu paki don iwa yale edanbi, ‘Qeli gege togon nasoine mo bomile osop sarimaike!’ ");
INSERT INTO ons_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Zomarop ma menaŋongei, seuseune ma wisikae ongei, kubetenerop ebuwi solaene libe qe osiake, asu qotkoine ea esop onbi saket ariwarekei. Ŋine zonom yewa lewine midaine makoi, ea wane ŋine lewine midaine yaup ebongei. ");
INSERT INTO ons_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ŋine gol natne, me silwa, me wesi mane misuk malo kite ŋino more ma gekei, ");
INSERT INTO ons_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ŋine kieke arikei, naso yewao kite, gerep, ea misuk ma numa arikei, me takot etkeka, me kie tabe so maun, me qesi etkeka mane misuk magekei, urata ŋei, eŋe onoka wane ŋaŋae more ziaŋmaike, eamo yaup lewine midaine manikei. ");
INSERT INTO ons_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ŋine mat suaine maneo me mat nigatne maneo ariu paki, mat koto wau paki onikei, ŋei mane maŋo eweke more don awo ŋuniake, yemo ŋine eŋeropka mere kito okane ge mage, mat ea qelige arikei. ");
INSERT INTO ons_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ŋine mat maneo waketpi paki rakei, ‘Peamŋo gerop pakep.’ ");
INSERT INTO ons_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mat ea wane ŋei ŋereune eŋe don awo ŋunikeiwo, yemo ŋinane peam donŋo motpi eŋano payake, ŋo eŋe don mane mi awoŋunikeiwo, yemo ŋine peam don ŋine ea koso ma zinge arikei. ");
INSERT INTO ons_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","So mat natne edo me mat suaine natne edo don mi awo ŋunikei, me ŋinane don mane mi desikeiwo, yemo ŋine mat ea qeliŋgei paki, kie ŋino lube lube ea sitogeu ket ea mesiake, ŋei ŋerep ea sotene weneŋ gekei. ");
INSERT INTO ons_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na welekatne ŋidanbe detpi! Wano wanok kaiwe naso yewao Anutu eŋe Sodom so Gomora ŋei ŋerep borikine welaine, eŋe seseone more, umat ewekine eboniake, ŋo mat suaine donŋine mi detkoi, ea wane ŋei ŋerep eŋe yemo wikile so umat kakapa eboniake! ");
INSERT INTO ons_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Detpi! Na ŋine lama yale, kasi zubaine eŋane keueno biraŋunmaile. Ŋine diamŋine seleleine, koma eŋane masi yale makei, so naŋi baluse yale ŋine pelelekatne ŋei ŋerep okanonikei. ");
INSERT INTO ons_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Diamŋine togogole makei, onoka wane ŋei eŋe baŋ ŋibu ari dongo biraŋungei, so kumunamŋo Yuda lewa lewaŋeno baŋ ŋingukei. ");
INSERT INTO ons_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ŋine baŋ ŋibu ari ŋei wawaine so ŋei waom eŋane kaitko biraŋunbi, naŋane rau paki don urata makei, yemo eŋe don maine edanmami, so qelaŋ ŋei, Yuda ŋadino gemami edanmami, ea wane wikile desikei. ");
INSERT INTO ons_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ea wane, eŋe ŋibu dongo biraŋunbi, ŋine onoka don rakene, me don daleo baŋ rakene rau paki, dere mezet misuk okangei, don raikei wane naso bomile sariki, don daleo rakei, ea wane numaine yemo baŋ Anutuŋo wetŋino mosiake. ");
INSERT INTO ons_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ŋine don rakei, yemo baŋ ŋinane mi okaniake, yemo eŋe baŋ Magaŋinane Asu wano ŋine sari wetŋino more ŋidaniake. ");
INSERT INTO ons_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ŋei eŋe baŋ enŋene weŋem sotak kopene eŋane kine ra dongo biraonbi ebu ari kawali ŋei edo enguwi seukei, so magakopene eŋe rokop weku yewaka doko kopene okanongei, dokokopene eŋe baŋ zinge naga magakopene ŋabaongei paki, ebu ari engukei. ");
INSERT INTO ons_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ŋei korop eŋe baŋ onoka wane naŋane rau paki qik ŋungei, ŋo mane eŋe togogole malipka okora mageki naso qoeake mo, Anutuŋo ŋei ea baŋ mayake. ");
INSERT INTO ons_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","So eŋe mat maneo masi qotkoine okan ŋunbi, so ŋine kakakone more wie mat maneo arikei, na welekatne ŋidanbe detpi, ŋine urataŋine Israel eŋane mat pamaike, yewao korop mi mawareu qoeake, eŋe yeka paki ŋei Wawainane Gipole eŋe sari lotkeake. ");
INSERT INTO ons_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kibi medepŋo kito man maninane suaine ea mi yuankamaike, me qelit medepŋo ware wareinane suaine ea mi yuankamaike. ");
INSERT INTO ons_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Eso ea wane kibi medep mane eŋe konapkeki paki, yemo maine kito man manine yale okaniake, so qelit medep mane eŋe yaleka konapkeki paki, eŋe maine ware wareine yale okaniake. Na mat wane magaine, borikine welaine, Belzebul norakoiwo, yemo naŋane dokone eŋane eŋetene yemo zok manerop qotkoine edorakei! ");
INSERT INTO ons_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ea wane ŋine ŋei eŋane kaet misuk okangei, onoka wane kine kine kaweunerop pamaike, ea baŋ kawet lalaŋgi didiwo wakoniake, so yeye kine kine sane pamaike, ea mo korop baŋ didiwo wakongi detwarekei. ");
INSERT INTO ons_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na panaman koto don iwa ŋidanmaile, ŋine yewaka koso kaiweo didiwo rawakongei, so ŋine don bonepŋine detokangoi, yewa ŋine mat bakine kutnoka okora ra wakongei. ");
INSERT INTO ons_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Solaŋineka qeu seukeake, ŋei yewa eŋane misuk kaetŋuniake, yewa edo asuŋine maine mi qeu seukeake. Ŋo Anutu wane yemo maine kaetŋuniake, oŋo sola so oŋa oŋaŋine weneŋ orodoŋ maine sora gerepko matali osiake. ");
INSERT INTO ons_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ŋine naŋi zowoliliŋ etke ea wan toyaŋo maine qolekei, ŋo siluŋ eŋano ŋine mane Magaŋineŋo mi okki, kepo mi ket kitoyake. ");
INSERT INTO ons_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Eso ŋinane, yemo leweŋine zoune ea wane zaleine yemo korop mo dapotwareke. ");
INSERT INTO ons_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Eso ea wane ŋine kaet misuk okangei, ŋinane ra more Anutu detmaike, leweŋine yemo zok manerop lewine suaine, zowoliliŋ loutne eŋane rokop yuanmaike! ");
INSERT INTO ons_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mane eŋe na ŋei eŋane kaitko ra qelaŋan naniake, na rokop yaleka Magak qeliwo gemaike, eŋane kaitko eŋe ra qelaŋankakale. ");
INSERT INTO ons_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ŋo mane eŋe na ŋei eŋane kaitko bisopnaniake, na yaleka Magak qeliwo gemaike, eŋane kaitko eŋe baŋ bisopkakale. ");
INSERT INTO ons_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ŋine naŋane misuk wetke rakei, eŋe kepeo peam ma wakoniakane ketke, midakaka na kepeo peam ma wakongalane mi ketkole, na kawali pilaŋ mane ma wakongalane ketkole. ");
INSERT INTO ons_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na ŋei mapokonbe poripkekei wane ketkole, ea wane naŋane ra more maga gipon ere ŋaba nagukeik, so naŋane ra more naga boraso ere ŋaba nagukeik, so naŋane ra more ŋerep eŋe atolekopene ŋabaonikei. ");
INSERT INTO ons_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ŋei mane wane ŋabakoune qotkokoine, yemo baŋ eŋine weŋem sotawekoune edo okankakei. ");
INSERT INTO ons_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ŋei mane eŋe eŋine magaine me nagaine wet maep manerop okankaki paki, na nigatnemde okan naniake, eŋe naŋane biŋek mi qeake. Mane eŋe eŋine gipole me borasine wet maep manerop okankaki paki, na nigatnemde okannaniake, eŋe naŋane biŋek mi geake. ");
INSERT INTO ons_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ŋei mane eŋe kibeŋ qabeŋine ma tewekki paki, naŋane ŋadeno mi sariake, eŋe naŋane biŋek mi geake. ");
INSERT INTO ons_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ŋei mane eŋe eŋine gegeine wakoniakane urataine mayake, eŋe baŋ qeliŋgi siuke maniake. Mane eŋe gegeine naŋane raki paki qaisik kayake, eŋe baŋ wakone maniake. ");
INSERT INTO ons_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ŋei mane eŋe ŋine ŋibu mauluk ŋuniake, eŋe na mauluk naniake, so mane eŋe na mauluk naniake, eŋe talenangi sarikole, eŋe mauluk kayake. ");
INSERT INTO ons_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ŋei mane eŋe Anutu wane propet kima okanka mauluk kayake, onoka wane eŋe Anutu wane propet, ea wane eŋe baŋ propet wane lewine nat parom, eŋe mayake. So ŋei mane eŋe ŋei maine koboboine mane kima okanka maulukayake, onoka wane eŋe ŋei maine koboboine, ea wane eŋe baŋ ŋei maine koboboine lewine nat parom, eŋe mayake. ");
INSERT INTO ons_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","So iwa welekatne rawe detpi! Ŋei mane eŋe dokone ketkele iwa eŋane keuo ŋine mane doku momoine mangi neake, onoka wane eŋe naŋane dokone, ea wane eŋe baŋ welekatne lewineine mayake.” ");
INSERT INTO ons_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu eŋe don iwa korop dokoine 12 ebon wareki qoeki, ŋadino mat ea qelige, so miti don kito eboniakane so edaniakane, mat osop osop mere arike, yewa arike. ");
INSERT INTO ons_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohane Doku Tautau eŋe mulap urumgo mere, Kristoŋo urata kine kine make, ea wane don kisiine ea detke Paki eŋe dokoine natne raongi Yesu wano arikoi. ");
INSERT INTO ons_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ari qesonka rakoi, “Ŋedannom, ge sarikenane Yohaneŋo rake, ge weku mo sarikenane Anutuŋo biragangi ketkone, iwa me ŋene mane wane ra tomaka gekene?” ");
INSERT INTO ons_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesuŋo edange, “Zinge ariu paki, kine kine onokaka detmami so kamami, ea Yohane olatpi, ");
INSERT INTO ons_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","De pilikŋo deene maine potmami, kie wawetene qoi qoineŋo maine numa arimami, kubet togole eŋe solaene piridiŋgi libe qeki gemami, ketene wonwoleŋo don maine detmami, seu seuneŋo wisikae wie more gemami, so sigi maep don mayakakatne ea, ŋei ŋerep ket qeqineŋo detmami. ");
INSERT INTO ons_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mane eŋe naŋane wet etkeka mi okaniake, eŋe wet pese desiake!” ");
INSERT INTO ons_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohane dokoine eŋe koso zinge ariu, eaka Yesu eŋe Yohane wane don kisi ŋei ŋerep magu edane rake, “Ŋine kepe yaup papaino Yohane wano onokaka kakei wane arikoi? Ŋine gim mane metine momoŋo ma ari ma sari okangi kakei wane arikoi me? ");
INSERT INTO ons_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ŋine ari onokaka kakoi? Ŋei mane takotine kibi maep korop augeki, eŋe kaikei wane arikoi? Mida! Ŋei takot kibi maep korop yaline auge okanmami, eŋe ŋei waom urum eaoka ge okanmami! ");
INSERT INTO ons_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nolatpi, ŋine onokaka kakei wane arikoi? Propet mane me? O welekatne, na ŋidanbe detpi, ŋine kakoi, yemo propet mane wane rokop yuanmaike, oŋo yemo rokop mane eŋe kakoi. ");
INSERT INTO ons_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yohane eŋe weku eŋane Anutu wane papiaŋo iwa yale ramaike, ‘Iwa eŋe naŋane siron rara ŋei, Anutuŋo ramaike, na baŋ eŋe talekawe, oŋo lewine alakangi paki, geŋane numa lalageake.’ ");
INSERT INTO ons_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Iwa ŋidanbe detpi, Yohane Doku Tau tau eŋe zok kakapa suaine, eŋe kepe ŋei korop mo sogino wakonbi ge mage naso iwao gemami, eŋe yuan one more gemaike. Ŋo mane eŋe baŋ ŋado qeli gege togon wakongi, ea wane kotino ketkele geakeŋo siluŋ eŋe Yohane yuan kayake. ");
INSERT INTO ons_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yohane Doku Tautauŋo miti don kieke edange, naso yewao ŋineka sarimage, ukude kaiwe iwa qeli gege togonŋo zonom gorop wakonge wakone pamaike, pakimo ŋei sorin borin gorop, eŋe togole more ea makei wane soringemami. ");
INSERT INTO ons_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Propet korop eŋe so Mose wane ra rokop don eŋe qeli gege togon wane don rau paki qe sari mageu, Yohane wane nasoo don ea raki qoeke. ");
INSERT INTO ons_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","So ŋine eweke more propet eŋane don desikei wane ŋunmaikeo, detlutkei, Yohane eŋe Elaiya, oŋo sariakane raraine. ");
INSERT INTO ons_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Eawane ŋine ketŋineropŋo don iwa misuk ŋaŋaekei! ");
INSERT INTO ons_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Naso iwao ŋei ŋerep gemami, na eŋe onokakao kineene rokop onbe? Eŋe ŋerep medep nigatne edo nalu qole qole sobego metmami, ea yale. Magu mane edo magu mane eŋane boka iwa yale ra okanmami, ");
INSERT INTO ons_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ŋene geŋane zokit mama mulup puanmaine, ŋo ge eŋet mi oremaine! Ŋene seu seu eŋet kitomaine, ŋo ge mi arokmaine!’ ");
INSERT INTO ons_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ea wane ra more na ramaile, Yohane sarike, so eŋe sawe geke, paki eŋe wain mi neke, bat midaine geke, eso ŋei eŋe kau paki rakoi, ‘Eŋe asu qotkoineŋo kotino ket gemaike!’ ");
INSERT INTO ons_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ŋei Wawainane Gipole sarike, eŋe ŋara neke so doku neke, so ŋei ŋerep keuo ewekine geke, eso ŋei eŋe kau paki rakoi, ‘Kau ŋei iwa! Eŋe mep qot so wain nene, takis mama so borikine mama natne eŋane kimaene mane!’ Na ramaile, ŋinane dereretŋine yemo wele midaine pamaike, ŋo Anutu wane dereretŋo yemo welekatne welerop okangi, kine sikanŋon okanmaike.” ");
INSERT INTO ons_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mat natno Yesuŋo masi togogole loutne manerop maki, ŋei ŋerep eŋe kau paki wetene mainge more, sotene mi ŋadekkakoi, ea wane Yesuŋo girem don edange, ");
INSERT INTO ons_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Yai, Korazin welaine! Ŋinano umat kakapa suaine baŋ wakonŋuniake. Yai, Betsaida welaine! Ŋinano umat kakapa suaine yaleka baŋ wakon ŋuniake. Ŋinano masi togogole zok manerop makole, masi togogole eaŋo Tire So Sidon qelaŋ ŋei ŋerep eŋano mane mama ra, mokaka ŋei ŋerep yewa eŋe kau paki betŋo takot yale birau ketki, kaitko zepeŋo edomka qak naguwi paki, sotenane wet borik detpi paki, borikineene ŋadek kamami, ea wane kine yale qe wakonbirap! ");
INSERT INTO ons_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ea wane iwa yale desikei, kine ma wakon ma wakon kaiwe naso yewao, Anutuŋo Tire so Sidon qelaŋ ŋei ŋerep baŋ manerop seseoniake, paki eŋe wikile sisinimde desikei, ŋo ŋine yemo kakarauk suaine sikanŋuniake! ");
INSERT INTO ons_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","So Kaperneam welaine ŋine! Ŋine ŋinŋineka qeliwo ma wa wetika weti bira nagukei me? Yemo midakaka, na ramaile, ŋine baŋ qeu biraŋungi, qeika qei ŋei seu seune eŋane biraŋunbiso ra gerepko kesikei! Ŋei mane eŋe Sodom matko ariki paki, noŋo masi togogole ŋinane keuo makole, yalewaka masi togoleŋo ŋei ŋerep qelaŋ eŋano maki, eŋe masi ea kau paki, borikine ŋadekau ra, mat ea mi suikki paki, naso iwao eŋe mere waki rap! ");
INSERT INTO ons_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ea wane iwa yale rawe desikei, kine ma wakon ma wakon kaiwe naso suaine yewao, Anutuŋo Sodom qelaŋ ŋei ŋerep manerop baŋ seseongi paki, wikile sisinimde ebongi desikei, ŋo ŋine yemo kakarauk suaine manerop sikanŋungi, wikile suaine baŋ desikei!” ");
INSERT INTO ons_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naso yewao Yesuŋo rake, “Magak, qeli so kepe ea wane Waom! Na bakomŋone kitomaile, onoka wane ge dereretenane detpi wawaine okanmaike, eŋe miti donŋone mi sikanone more, motone okanmaine, ŋo medep nigatne yale dereretenane detpi ketkele okanmaike, eŋe yemo ra wakone ebon okanmaine. ");
INSERT INTO ons_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O Magak, iwa yemo geŋone simile so wet dereretŋonane wele yale mogatnom wakone pa ariakane, detnom mo menaŋge. ");
INSERT INTO ons_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Maganeŋo yeye kine kine korop more ninwareke, ŋei maneŋo Gipolane wet dereretinane kine mi detmaike, eamo Magakŋoka weku detkamaike. So ŋei maneŋo Magak wane wet dereretinane kine mi detmaike, Gipoleŋoka weku detkamaike. So ŋei mane Gipoleŋo Magak wane kine rawakone olatki, ŋei ea eŋe maine desiake. ");
INSERT INTO ons_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ŋei ŋerep ŋine wikile dere umatŋine kakapa suaine teweke geu, umatne ŋidotki zonomŋine mida lelemaike, ea korop naŋano sariwareu, noŋo baŋ dan gunut so riwe morian ŋibon warekale, paki so ŋine wet pesek desikei. ");
INSERT INTO ons_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ŋine naŋane umat kabut ea mau paki, ŋinŋino birau ketkep, paki naŋane kinene detlukkei, onoka wane na asuneŋo wet pesesekatne so ketkele gemailane, ŋine baŋ oŋa oŋaŋinane metmet maratkau metki, menaŋkayake. ");
INSERT INTO ons_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Na umat yewa kabut pa baŋ kutŋino more ŋibongale, eamo ewekine gemaine tewekene, so na umatpa kine kine ŋido tewekkei wane, na baŋ kutŋino motkale, yemo ewekine so ponoŋ kiridiŋ, ŋine maine baŋ tewek warekei.” ");
INSERT INTO ons_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mi azonŋgi, Yesu eŋe wit eu keuoka kitare Qezarek Nasoo arike. Eŋine dokoine eŋe ŋaraenane seukkoi, pakiso eŋe kieke more wit woune ea peikeu paki, nekoi. ");
INSERT INTO ons_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisi eŋe ea kau paki Yesu olale rakoi. “Kanom, iwa yemo ŋenane ra rokop don ea qebarakeu paki, geŋane dokoŋone eŋe Qezarek Nasoo masi iwa okanmami!” ");
INSERT INTO ons_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Rau Yesuŋo doneene turuŋine mainge iwa yale ra edange, “Ŋine don iwa Dawitŋo mo sogino daleo okange, ea ŋine mi dapore det okanmami me? Eŋe naso yewao eŋe eŋine so ŋeikoune eŋe ŋaraenane seukkoi, na yewa wane ramaile. Kine ea ŋine mi dere qelaŋanmami! ");
INSERT INTO ons_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Eŋe Anutu wane urum kotino waki paki, eŋine so ŋeikoune eŋe Anutu wane biŋek bret motpi metke, ea yemo pris edoka weku yewa ŋine nekei wane raraine, ŋo eŋe siluŋ yaleka eŋe ra rokop don qebarakeu paki, bret ea nekoi. ");
INSERT INTO ons_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Me ŋine Mose wane ra rokop don ea mi dapore det okanmami. Qezarek naso baŋem Pris eŋe urata wane Bakom Urum koto wa okanmami, eaŋo ra rokop don ea eŋe qebarak okanmami, yale okanmaike, ŋo eaŋo sot mi okanmaike me? ");
INSERT INTO ons_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","So na iwa yale ŋidanbe detpi, yeye mane iwa eaŋo yemo kakapa suaine Bakom Urum wane wawaine, kine kine yewaŋo Bakom Urum yuankamaike. ");
INSERT INTO ons_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Anutu wane papiaŋo iwa yale qe wakone ramaike, ‘Na osomŋo soe soep mire ningeiwane, mi simile nanmaike, ŋo wet maepŋo ŋinane keu ŋino korop paki gekei, na ea wane simile nanmaike.’ Ŋine welekatne iwa wane kine mane detlukeurap, yemo ŋine ŋei sotene midaine, eŋe don umat mane kuteno more mi edanbi rap, ");
INSERT INTO ons_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Onoka wane Ŋei Wawainane Gipole eŋe Qezarek Naso ea wane Waom so oŋo warekaki pamaike.” ");
INSERT INTO ons_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu eŋe ea qelige more koso eaŋine ari Yuda eŋane mat maneo lewa lewaŋ urum maneo waketke. ");
INSERT INTO ons_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ŋei mane ea metke metine seu seune, so ŋei natne eŋe yewa weneŋ metkoi, eŋe Yesuŋo sot mane okangi kau paki dongo birakakei wane, eso eŋe ea wane Yesu qesonka more rakoi, “Iwa ŋenane ra rokop don qebarake more, Qezarek Nasoo ŋei ma menaŋkakene me dale?” ");
INSERT INTO ons_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesuŋo mainge qeson one rake, “Ŋinano ŋine mane eŋe lama mane mageake, pakimo lama ea eŋe qezarek nasoo lom kiroine maneo kesiake, pakimo Qezarek Nasoo, daleo okangei? Ŋine ea baŋ qesiŋka more ma birau sayake, me ka ŋadeka more qeliŋkau yeine okorayake? ");
INSERT INTO ons_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ŋei mane eŋe lewine suaine so zok manerop wawaine okanmaike, so eŋe lama mane wane rokop yuanmaike! Eso yalinane mo, ŋenze ra rokop donzeŋo yemo ŋei natne Qezarek Naso eao mapik ongenane maine detŋonmaike.” ");
INSERT INTO ons_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yale raki paki ŋei olale rake, “Meteŋone biranom.” Rakiso eŋe metine birakiso menaŋkaki metine mane ea wane rokop okange. ");
INSERT INTO ons_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pakiso Parisi eŋe wie ari lewage, Yesu qeu seukeakane don aukoi. ");
INSERT INTO ons_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu eŋe don so ŋaba ŋaba kine kine ea Parisi edo eŋe okankaikei wane rakoi, ea detki pakiso, mat ea qelige arike, paki ŋei ŋerep loutneŋo ŋadino mogare arikoi, eŋe ŋei zomarop ea korop ebuki menaŋwarekoi. ");
INSERT INTO ons_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pakiso, eŋe ŋei ŋerep natne eŋine don kisiine ea mi edangei wane ra togoleone more rawetonge. ");
INSERT INTO ons_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Masi tanik kine kine yale rawetongi paki okangi, Anutuŋo don mane propet Isaia iwa yale olatki qeke, ea wane wele wakonge, ");
INSERT INTO ons_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Iwa eŋe naŋane qelit ŋei, eŋe noŋo ma wakonkakole, na eŋane zok manerop simin nanmaike, na eŋane ra more wet maep okanŋungale, weku na eŋane simile nanmaike, na eŋane zok detpe menaŋmaike. Na baŋ Asune eŋane kutno mosikale, paki eŋe baŋ naŋane kine ma wakon ma wakon don koboboine ea ra qelaŋane more, kepe wane kutno ŋei ŋerep korop edaniake. ");
INSERT INTO ons_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ŋo eŋe baŋ kim sorin so busu me don suaine mi okaniake, me don ukatine mane suaine numa suaino mi raki ŋei ŋerep eŋe desikei. ");
INSERT INTO ons_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ŋei ŋerep eŋe gim mane togole mida, so kuŋ kuŋine me eŋe mo dumeniakane okanmaike yale, ŋo eŋe baŋ mi dumeniake. So lam mane lawe pilik oka okane yale, eŋe mi pilik lukeake, eŋe urataine koboboine ma met mage baŋ don urata koboboineŋo yuankayake. ");
INSERT INTO ons_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","So ŋei ŋerep magu mane qelaŋ mitiene midaine, yewa korop eŋe baŋ wetene so mali malipene eŋano mot warekei.” ");
INSERT INTO ons_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Naso yewao ŋei natne eŋe ŋei mane deine pilik pilikine don mi raraine, ea Yesu wano ma sarikoi, onoka wane eŋe asu qotkoineŋo kotino geke. Yesu eŋe ŋei yewa ma menaŋkake, eso ŋei yewa eŋe eweke more, don maine rake, so deine maine potke. ");
INSERT INTO ons_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ŋei ŋerep magu suaine okorakoi, eŋe koropŋo eŋe kau paki, welelepke more qeson nagu rakoi, “Eŋe ea Dawit wane ŋaboine, Anutuŋo birakayakane rake, eŋe me?” ");
INSERT INTO ons_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisi eŋe don ea detpi paki mainge rakoi, “Eŋe asu qotkoine esopongi saketmami, yemo onoka wane Belzebul asu qotkoinane lewetŋo zonom mangimo, eŋe asu qotkoine yewa esopongi saketmami.” ");
INSERT INTO ons_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Rau, Yesu eŋe wetenane kine detki paki edane rake, “Ŋine iwa detpi, gavaman kepe mane eao ŋei eŋe edomka mapoke magu etke okane more, kawali yakuwi rap, baŋ kepe yewa naso kiroine mi okaniake, siukki rap. So mat mane me ŋei magu mane eŋe oŋomka mapoke magu etke okane, kawali yaku aito okanbi rap, baŋ poripke warekei, paki mat yewa eŋe siukkeu rap. ");
INSERT INTO ons_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Eso yalinane magu maneŋo daleo kimaine Satan magu mane esopkayakeo, mi kopkemaike, eŋe yale okaniakeo, yemo urataine maine mi pa wayake, eamo eŋe yeine suikeake! ");
INSERT INTO ons_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ŋine ramami, yale na asu qotkoine esop onikalane Belzebulŋo zonom ningi, na asu qotkoine ea esoponmaile, ea maine welekatneo, yemo na qeson ŋunmaile, ŋo ŋinŋine dokoŋine ea eŋe yemo maŋo zonom ebongimo, eŋe asu qotkoine yewa esoponbi qelige saket arimami? Ŋinŋine dokoŋine ea edo kine ŋine ma wakonmami, yemo ŋine don ŋine yewo koboine mida so ŋine sot korop okanmami! ");
INSERT INTO ons_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Belzebulŋo mi qesiŋnange, midakaka, iwa yemo Anutu wane Asu, oŋo zonom ningimo, na asu qotkoine esoponbe saket arimami, eaŋo kine ma wakonmaike, yemo Anutu wane qeli gege togon wane nasoine ŋinano mo sari saket wareke. ");
INSERT INTO ons_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ŋei maneŋo ŋei togogole mane wane mat koto kito barake waket more, aboŋ kine kineine maine yaup mi ma ariake me? Eŋe yale okaniakane ra, eŋe ŋei togogole ea mikepka ma wokomkaki paki, ŋado yemo maine matine ea kito barake, waket kine kineine ea mat koto pamaike, maine kobu mayake. ");
INSERT INTO ons_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ŋei mane eŋe na kima mi okannaniake, eŋe na ŋabananiake. Ŋei mane eŋe na qesiŋ nane more lamakopne wekuoka ebu mi biraoniake, eŋe welekatne esopongi, yau yaup ari warekei. ");
INSERT INTO ons_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ea wane na ŋidanbe detpi, ŋei eŋe borikine kine kine natne makei, so don borikine natne rakei, ea wane turuŋene yemo Anutuŋo maine bira eboniake, ŋo ŋei mane eŋe Asu Koboboine eŋane ra more don borikine rayake, yemo sotinane turuŋine mane Anutuŋo maine mi biraka maniake. ");
INSERT INTO ons_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ŋei mane eŋe Ŋei Wawainane Gipole eŋane ra more don borikine rayake, yemo turuŋine Anutuŋo maine bira maniake, ŋo mane eŋe Asu Koboboine eŋane ra more dere worik okan kayake, eŋe turuŋine ea Anutuŋo mi biraka maniake, naso iwa gemaineo, me naso ŋado sariake, yewao mi bira maniake, midakaka. ");
INSERT INTO ons_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Eki wele maine makenane dere, yemo eki maine ea mauluke magekene, ŋo ge eki zegulakine motmole ea magekeneo, yemo ge baŋ wele qotkoine qeki minakkene. Eki mane wane kine yemo wele qemaike, eao ka desikene. ");
INSERT INTO ons_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ŋine koma borikinane dokoine, ŋine borikine geu paki mo daleo don maine rakei? Wetŋine borikineŋo watke pamaike, eaka aŋaŋo ra okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ŋei maine eŋe dereretine maine kotino pamaike, ea wane eŋe masi tanik maine okan okanmaike. Ŋei borikine mane eŋe dereret qotkoine loutne kotino pamaike, ea wane eŋe masi tanik qotkoine ma okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Na iwa ŋidanbe, ma wakon ma wakon kaiwe naso, eao ŋei ŋerep korop eŋe don kine kine yau yaup raraine, korop ra gekoi, ea wane don urata makei. ");
INSERT INTO ons_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ŋinŋine donŋine eaŋoka baŋ kine ma wakoniake. Ma wakongi, sotŋine midaine okanikei, me ma wakongi sot korop okanikene.” ");
INSERT INTO ons_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yale edangiso, ra rokop don wane kito ebo ebon natne, so Parisi natne eŋe Yesu olale rakoi, “Kito ŋebo ŋebon, ŋene masi togogole mane manom kakenane ŋonmaike, ge manom kaŋem paki, ŋene raikene ge Anutu wane urata mamaine.” ");
INSERT INTO ons_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Rau, Yesuŋo edange, “Ukude naso iwa wane ŋei ŋereune yemo borikine, so eŋe weteneŋo Anutu mi malip kamami, so Anutu midaine gemami! Ŋine masi naso baŋem togogole mane mawe kakeiwane ra nan okanmami? Midaka! Masi togogole weku baŋ ŋibongale, yemo propet Yona wano masi togogole wakonge, ea wakongi kaikei. ");
INSERT INTO ons_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Numa weku yewaka Yona eŋe kaiwe karewe so goiŋ karewe zawon suainane wouine koto wete metke, wane Ŋei Wawainane Gipole eŋe yaleka baŋ kaiwe karewe so goiŋ karewe kepe koto ket mesiake. ");
INSERT INTO ons_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kine ma wakon ma wakon kaiwe naso yewao Niniwe mat welaine ŋei ŋerep eŋe baŋ wie okorau paki, kineŋine tilekkei, onoka wane Anutuŋo Yona eŋano birakake, eŋe Yonaŋo miti edangi dere borikineene ea ŋadekka warekoi, na ŋidanbe, kine kine mane iwa, ea yemo Yona wane suaineine! ");
INSERT INTO ons_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kine ma wakon ma wakon kaiwe naso, eao yemo raiwoken ŋine qelaŋ ŋerep waomŋo wie okoraki paki, kineŋine tilekeake, onoka wane eŋe kepe keuo ŋine kitare lolike numa kiroroine ari mage, Solomon wane dereret koboboine ea detke, so wetine main gemaike, na welekatne ŋidanbe detpi, yewao kine kine mane iwa pamaike, ea yemo Solomon wane suaineine!” ");
INSERT INTO ons_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesuŋo donkisi mane edane rake, “Asu qotkoine eŋe ŋei mane wane kotino ŋine sakesiake, paki eŋe kepe wetataine yewao mat mane maratka ma metpe ra, zuage ariake. Ari mat mane mi marat kayake. ");
INSERT INTO ons_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Paki eŋe oŋomka iwa yale rayake, ‘Na baŋ koso zinge ari, matna qelige sarile, eao waketkale.’ Eso eŋe koso zinge ari kaki matpa qamen, kotine sino kito mauluk mageumo, mayakatne payake. ");
INSERT INTO ons_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Pakimo, eŋe saket ariki paki, asu qotkoine natne sewen, eŋine rokop mida, qotkokoine ebuki sarikei, eŋe sariu pakimo, mat yewa wane kotino waket gekei. Eso ŋei yewa eŋe alakan borikine geke, wane iwa yemo zok manerop boriluluke geake. Numa tanik iwamo ŋei ŋerep borikine ukude naso iwao gemami, ŋinano yale wakoniake.” ");
INSERT INTO ons_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu eŋe ŋei ŋerep don yeka edane okoraki, nagaine so ŋolekoune lotkekoi, eŋe mat ŋadino qeinat okora Yesu don olatkei wane qesongoi. ");
INSERT INTO ons_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pakiso ŋei maneŋo olale rake, “Detmaine, geŋane nagaŋone so ŋolekopŋone eŋe qeinat okoramami, so eŋe gerop don aukei wane simin onmaike.” ");
INSERT INTO ons_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Rakiso, Yesuŋo mainge olatke, “Maŋo naŋane nagane? Deo edo naŋane ŋolekopne?” ");
INSERT INTO ons_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yale raki paki dokoine eŋano metine qesikane more rake, “Onnom! Iwa edo naŋane nagane so ŋolekopne okanmami! ");
INSERT INTO ons_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ŋei mane eŋe Magane qeliwo gemaike, eŋane simile mogare gema okanmaike, eŋe naŋane ŋonne, so naŋane kiarone, so naŋane nagane.” ");
INSERT INTO ons_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kaiwe weku yewaoka Yesu eŋe mat qelige, so doku namuŋ wazaino arike, ea pese ket mere, so don kito edange. ");
INSERT INTO ons_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Metki, ŋei ŋerep loutneŋo sari qeatka lolikkakoi, eŋe zok magu suaine, ea wane Yesu eŋe seki mane wane kotino ketki paki, ea wane kutno pese metke, ŋei ŋerep magu eŋe qalakko okorakoi. ");
INSERT INTO ons_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Eŋe don naŋengo rokop motki paki, kine kine loutne yale kito edan maŋke, mane iwa yale edange, “Ŋei mane geke, oŋo nene woune euo rasuyakane arike. ");
INSERT INTO ons_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Eŋe woune mapororoke euo rasuke, woune natne numao ketke, pakiso naŋi edo sari neu midake. ");
INSERT INTO ons_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Woune natne kepe tabilainerop eao ket kitoke, yewao kepe gukine etkemde pake, wane komine mo ikopka qeke, onoka wane kepe gukine qeirop mi pake, ea wane, ");
INSERT INTO ons_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kepe deine sake, naso yewao kaiweŋo sirike qeki, komine musele sake, ea kuku suluŋge, onoka wane ŋodineŋo kepe qeirop mi make, ea wane komine ea ikopka seukwarekoi. ");
INSERT INTO ons_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Woune natne touk wakelerop ea wane koto ket kitoke, wane sua wieu toukŋo kitoki siukkoi. ");
INSERT INTO ons_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ŋo woune natneŋo yemo kepe gukinerop eao kitoke, wane sua wa more wele qekoi, setne natne eao woune 100 qekoi, setne natne eao woune 60 qekoi, so setne natne eao woune 30 qekoi.” ");
INSERT INTO ons_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pakiso Yesuŋo iwa yale edange, “Mane eŋe ketneropŋo don iwa desiake, ŋine misuk ŋaŋaekei, don naŋengo yewa wetŋineŋo wetkekei!” ");
INSERT INTO ons_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dokoine eŋe Yesu wano sariu paki qesonka rakoi, “Ge ŋedannom desikene. Ge onoka wane don naŋengoka ŋei ŋerep edan okanmaine? Ea wane kine ra qelaŋan ŋonikene.” ");
INSERT INTO ons_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesuŋo mainge edane rake, “Qeli gege togon kotino wake waket ea wane dereret sane, yemo ŋidoka detkei wane ŋibonge, ŋo ŋei natne iwa edo detkei wane yemo mi ra ebonge. ");
INSERT INTO ons_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ea wane natne eŋe dereret loutne magemamiwo, yemo koso manerop qewatpi ebongi, morian loutne baŋ ma wakonka ebongi ma gekei. Ŋo natne eŋe dereret loutne ea mi magemaimiwo, yemo dereret nigagatne magemaike, ea baŋ siluŋ dereret ea omakkaki, eŋe yaup geake. ");
INSERT INTO ons_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na don naŋengoka ra edanmaile, ea wane kine yemo iwa yale, eŋe deeneŋo kine kine kaikei, ŋo siluŋ mi kaulukmami, so eŋe keteneŋo don detkei, ŋo siluŋ kine mi detlukkei, ea wane ŋaŋaemami. ");
INSERT INTO ons_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Eso ŋei ŋerep yale okanmami, eŋano propet Isaiaŋo don iwa yale rake, ea wane wele eŋe ukude wakonmaike, ‘Ŋine baŋ ketŋo don naso baŋem detkei, ŋo kine yemo siluŋ mi wet detlukkei, Ŋine baŋ deŋo ka so ka okanikei, ŋo siluŋ kine kine mane mi kaulukkei. ");
INSERT INTO ons_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Onoka wane ŋei ŋerep iwa eŋane dereretene mo siukke, so eŋe ketene mo qe wongekoi, so eŋe deene mo pilikke. Eŋe deeneŋo kine kine maine kaulukeu rap, eŋe keteneŋo kine kine wane kine maine detpi rap, eŋe wet derereteneŋo kine maine gege dere qelaŋanbi rap, yemo eŋe naŋano maine zingeu rap, Anutuŋo ramaike, pakimo na maine ma menaŋ onbe rap.’ ");
INSERT INTO ons_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ŋine yemo wet pese so bakom suaine desikei! Ŋine deŋineŋo kine kine maine kamami, so ketŋineŋo don maine detmami, ea wane. ");
INSERT INTO ons_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Na don iwa ŋidanbe detpi! Propet loutne so Anutu wane ŋei ŋerep dereret korop magu loutneŋo sogino gekoi, ŋine yeye kine kine iwa kamami, ea zok kakei wane onge, ŋo siluŋ mi kakoi, so ŋine don kine kine iwa detmami, ea zok detkei wane onge, ŋo siluŋ mi detkoi.” ");
INSERT INTO ons_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesuŋo koso takotke more rake, “Ketŋine motpi paki, nene woune rasu rasu wane don naŋengo rele, ea wane kine detpi. ");
INSERT INTO ons_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ŋei ŋerep qeli gege togon wane don dere more, kine mi detluk okanmami, eŋe yemo wit woune numao ket kitoke, yewa wane rokop. Miti don wele kotoene ket kitoki, Satanŋo sariki paki pukso, ariki eŋe yaup gemami. ");
INSERT INTO ons_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wit woune natne kepe wesi tabilainerop yewao ket kitoke, yemo ŋei ŋerep natne eŋe miti don simileka detpi paki, eaka ma nogankamami. ");
INSERT INTO ons_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ŋo siluŋ qei kotoeno ketluke more, ŋodine mi ma qotkemaike, eŋe nasomde bamgoka ma gemami, eso miti don wane ŋabaine sarimami, me don wele wane umat mane wakongi, yewao eŋe ikopka qeligeu siukmaike. ");
INSERT INTO ons_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Woune natne touk wakelerop ea wane koto ket kitoke, yemo ŋei ŋerep natne eŋe miti don detmami, ŋo iwa kepeo gege ea wane dere mezet so wesi aboŋ suaine ma gege, ea wane simileŋo kitoki, miti don mo siuk waremaike, paki eŋano wele mi wakonmaike. ");
INSERT INTO ons_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Eso woune natne kepe gukinerop ea kitoke, yemo ŋei ŋerep natne eŋe miti don ea detpi paki, kine weteeneŋo detlukmami, paki malipkau weleine maine wakonmaike, natne eŋe wele woune loutne 100 qemaike, natne wele 60 qemaike, so natne wele 30 qemaike.” ");
INSERT INTO ons_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuŋo don mane naŋengo koso iwa yale edange, “Qeli gege togon wane numa, yemo ŋei maneŋo wit woune maine euino rasuke, yale. ");
INSERT INTO ons_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Rasukimo, goiŋ maneo ŋei ŋerep eŋe kulu pawarekoi, pakimo ŋei ŋaba maneŋo sariki paki, touk qotkoine ea wane woune wit koto rasuki paki arike. ");
INSERT INTO ons_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wit woune ea komine qe suaki paki, kieke wele mo qeakane okange, pakiso touk qotkoine mo eaka wiri wiekoi. ");
INSERT INTO ons_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Pakimo ŋei yewa wane qelit medep eŋe kau paki, sari olale rakoi, ‘Suaine, ŋene detmaine, ge wit woune maine euŋono rasukone, pakimo daleo wane tomok borikine yewa diao ŋine sari wakonmaike?’ ");
INSERT INTO ons_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Eu welaine eŋe mainge edane rake, ‘Ea yemo ŋaba natne edo tanik iwa okanimi.’ Eŋe qesonka rakoi, ‘Ge detŋon so ŋedanom, ŋene ari touk qotkoine maine yewa lokake qakŋem ariake?’ ");
INSERT INTO ons_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Eŋe mainge edane rake, ‘Mida, ŋine touk qotkoine ea lokakeu paki, wit natne weneŋ lokak ongei wane. ");
INSERT INTO ons_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Qeligeu, wit so touk eŋe weneŋ orodoŋka sua ware menaŋgeik, paki na baŋ loka lokak ŋei ea edanikale, ŋine mikepka touk korop ea lokak wareu paki, gerepko peikeu ket ezoyakane, mulapŋo wokomon warekei, Pakiso ŋado wit peike more ŋara urumno magukkei.’” ");
INSERT INTO ons_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu eŋe koso don mane naŋengo more, iwa yale edange, “Qeli gege togon wane magu yemo mastet woune yale, ŋei maneŋo ma ari euino rasumaike. ");
INSERT INTO ons_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet ea wane woune yemo eki natne eŋane woune yale mida, eŋe nigagatnemde, ŋo siluŋ suamaike, eao yemo eki natne korop yuanonmaike. Eŋe sua eki kakapa okanmaike, eso naŋi eŋe sari matene qogine kutno ma okanmami.” ");
INSERT INTO ons_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu eŋe koso don naŋengo mane iwa yale edange, “Qeli gege togon wane donkisi dalino sua ariake, yemo yist yale. Ŋerep maneŋo yis ea maki paki, plaua kawet mane earop liwa geake, liwaŋ mage, plaua korop eŋe baŋ piwiwige wieake.” ");
INSERT INTO ons_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu eŋe ŋei ŋerep magu don kine kine iwa korop edaniakane, yemo don naŋengoka more edanmageke, eŋe don naŋengo me rokop kito kito midaine didiwo mane mi rawakone edanmageke. ");
INSERT INTO ons_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Eŋe yale okange, yemo propetŋo don mane iwa yale rake, ea wane wele wakoniakane yale okange, “Na don edanikalane, yemo na baŋ don naŋengoka more edangale, na baŋ edanikale, yemo yeye kine kine mi dereretne kepe ea wakonge, eao ŋineka pa sari mage iwa pamaike, ea edangale.” ");
INSERT INTO ons_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu eŋe ŋei ŋerep magu ea biraoneso, mat koto ari wake. Eŋine dokoine eŋe eŋano sariu paki olale rakoi, “Toukpa euo wieke ea wane kine ŋedannom.” ");
INSERT INTO ons_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesuŋo mainge edane rake, “Ŋeiwa waet maine euo rasuke, yemo Ŋei Wawainane Gipole, ");
INSERT INTO ons_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","eu yemo kepe baŋem pamami, woune maine yemo miti dereret magu ŋei ŋerep qeli gege togon wane biŋek gemami, eŋe, ŋo touk qotkoine, yemo ŋei ŋerep qotkoine, eŋe Satan wane biŋek, eŋane qelit qe gemagekei. ");
INSERT INTO ons_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ŋo ŋei ŋabawa waet qotkoine euo rasuke, yemo Satan, borikine welaine. Ŋo menaŋmaike, yemo qeli kepe naso qoeake, ea, so menaŋgi ma urumgo mot mot urata ŋei, yemo aŋelo edo okanmami. ");
INSERT INTO ons_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Touk qotkoine peikeu waki, gerepko pekekeu ezoyake, ea yemo baŋ naso qoeake, yewao yale wakon wareake. ");
INSERT INTO ons_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ŋei Wawainane Gipole, eŋe baŋ aŋelo magukoune taleongi, ari qeli gege togon magu eŋano ŋine, ŋei ŋerep borikine makei wane wetene qepokeu, borikine ma okanmami, ŋei yewa so ŋei ŋerep borikine mama natne weneŋ korop peikeu sari warekei. ");
INSERT INTO ons_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Paki biraonbi, gerep togogole ze pamaike, eao ketpi ezoyake. Ezoki yewao eŋe baŋ aroke ŋet warik warik ki gekei. ");
INSERT INTO ons_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ŋo Anutu wane ŋei ŋerep magu eŋe yemo baŋ kepe deine yale sirike qelaŋane more Magaenane qeli gege togon mat kotino waket gekei. Ea wane ketŋineropŋo don iwa desikei, misuk ŋaŋaekei! ");
INSERT INTO ons_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Qeli gege togon wane don numaine ea, yemo qoli zali mane euo motkekoi, pakiso ŋei maneŋo maratkaki paki, koso manerop motkeke. Eŋe zok wet pese dere more, ariki paki yeye kine kine mageke, ea korop ebon wareke pakiso, eaŋo wesi kiare mangi ma more, koso zinge ari eu ea qoleke. Pakiso eŋine biŋek okange. ");
INSERT INTO ons_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Qeli gege togon don yemo yaleka, bisnis ŋei maneŋo kikum weku mane ea wane zuaŋge, ea wane rokop. ");
INSERT INTO ons_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Zuaŋ mage mane kake yemo weku mane, yale kaki paki ari, yeye kine kine qotkoine ma geke, ea korop ŋei natne ebon wareke. Pakiso wesi manbiso, eaŋo mainge kikum ea qoleki, eŋine biŋek okange. ");
INSERT INTO ons_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Qeli gege togon daleo ŋei ŋerep ebuyakane ea yemo yaleka, ŋei maneŋo kamaga biraki doku namugo ketki, zawon kine kine loutne ebuke, ea wane rokop. ");
INSERT INTO ons_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Zawon korop kamaga watke wareu, zawon mama ŋei eŋe tebau saweko sake, pakiso ket pese mere zawon damo qekoi, zawon maine ea kelaeno qakeu ketke, ŋo qotkoine eamo qakeu arike. ");
INSERT INTO ons_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Iwamo baŋ naso qoeake eao yale wakoniake, aŋelo eŋe baŋ ariu paki, ŋei ŋerep borikine mama korop ŋei ŋerep maine eŋane keuo ŋine wanoke qeturaŋon warekei. ");
INSERT INTO ons_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Paki ebu bira onbi, gerep togole ze pamaike, eao ketpi ezoyake. Yewao eŋe baŋ aroke ŋet warik warik ki gekei.” ");
INSERT INTO ons_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesuŋo dokoine edane rake, “Ŋine kine kine korop iwa edanile, ea wane kine detlukmami? Ea nolatpi desikale.” Eŋe rakoi, “O, ŋene detmaine.” ");
INSERT INTO ons_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Rauso, eŋe mainge edane rake, “Iwa wane kine yemo yale, ra rokop don kito ebon ebon ŋei, eŋe korop qeli gege togon wane dokoine okane gekei wane, yemo eŋe mat welaine ea wane rokop, oŋo yeye kine kine miti musele so miti sogine welerop, aboŋ ŋara urumino ŋine maki ketmaike.” ");
INSERT INTO ons_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu eŋe don naŋengo iwa korop edangi qoekiso, mat yewa qelige arike. ");
INSERT INTO ons_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ariso, zinge eŋine kepe matino arike, eŋe Yuda lewa lewaŋ urumeno waki paki, Anutu wane don kito edange, pakiso eŋe detpi paki oŋaene qaeki welelepke more qeson nagu more rakoi, “Eŋe dereret iwa yaline ea diao ŋine make? So masiine togogole iwa diao ŋine make? ");
INSERT INTO ons_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Eŋe mat mama wane gipole me? Maria eŋe eŋane nagaine me? So Yakop, Yosep, Simon so Yudas eŋe eŋine ŋolekoune me? ");
INSERT INTO ons_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Eŋe eŋine kiarokoune korop iwa mi mane gemami? Eŋe masi kine kine iwa korop diao ŋine make?” ");
INSERT INTO ons_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yale rau pakiso, qaisik kakoi Yale okanbi Yesuŋo edange, “Propet mane eŋe mat natne eŋano ariki, eŋe koropŋo ewine kitomami, ŋo weku eŋine kepe matino so eŋine magukoune edo qaisik kamami.” ");
INSERT INTO ons_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eŋe masi togogole mane yewa mi make, onoka wane eŋe weteneŋo detlukka mi malipkakoi eawane. ");
INSERT INTO ons_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Naso yewao Herot, Galili wane ŋei waom eŋe Yesu wane don kisi detke. ");
INSERT INTO ons_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Paki ketkele koune edane rake, “Eŋe yemo welekatne Yohane Doku Tau Tau, oŋo koso wisikae wie more, zinge sarimaike. Yalinane zonom togogole iwaŋo eŋane kutno waki masi togole urata mamaike.” ");
INSERT INTO ons_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herot eŋe raki Yohane malipka more, meteret kine wokomgeu paki, mulap urumgo birakakoi, eŋe ea okankake yemo iwa yale, Herotŋo eŋine ŋole Pilip wane ŋanominane ŋerep ea kobu make, ŋerep ea wane eŋetine Herodias. Yohaneŋo Herot ŋanominane ra more don okankake. ");
INSERT INTO ons_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yohane Doku Tautau eŋe tako rakot Herot olale rake, “Ge ŋerep iwa mamaine eamo mi menaŋmaike!” ");
INSERT INTO ons_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot eŋe Yohane qeakane okange, ŋo siluŋ eŋe Yuda ŋei eŋane kaetkake, onoka wane Yuda ŋei eŋe Yohane wane propet mane rakoi, ea wane. ");
INSERT INTO ons_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herot wane wako wakon nasoino ŋei natne eŋe ŋara nekei wane weneŋ sari motkoi, ŋanomine Herodias wane borasine eŋe Herot wane lewet ŋei eŋane kaitko lawam tanik qorikinoken eŋet oreke. Oreki Herotŋo kaki similekake. ");
INSERT INTO ons_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Paki eŋe ra togole olale rake, “Na qeliwo more ra togolemaile, ge kine kine mane wane gangi, ranom na baŋ ginikale!” ");
INSERT INTO ons_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Eso nagaine wetno ketki ŋerep eŋe rake, “Ge Yohane Doku Tautau wane lewine iwaka peletko more ninnom kawe.” ");
INSERT INTO ons_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yale raki Herot eŋe detki zok umareke, ŋo onoka wane eŋe ŋei tatiŋon koune korop eŋane kaiteno okora weti qeliwo raki paki don ratogoleke, ea wane detki qekaki, siluŋ ŋerep wane aŋaine teweke, paki qelit ŋei koune raongi arikoi. ");
INSERT INTO ons_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ari Yohane mulap urumgo ebine kitatkoi. ");
INSERT INTO ons_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kitareso, lewine peletko more ma sariu, ŋerep yewa mangoi, pakiso oŋo ma more nagainano ma arike. ");
INSERT INTO ons_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohane dokoine eŋe sari pareŋine ma more dukkakoi, paki eŋe ari Yesu donkisi olatkoi. ");
INSERT INTO ons_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu eŋe don kisi ea detki paki, mat ea qelige seki maneo waso sai maneo eŋineka geakane arike. Ŋei ŋerep eŋe don kisiine yale detpi paki, ket matene qelige more, kepoka ŋadino esopka arikoi. ");
INSERT INTO ons_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu eŋe seki kutno ŋine ketki paki, ŋei ŋerep magu suaine yewa one more, eŋane wetine boriki zomaene maki menaŋgoi. ");
INSERT INTO ons_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kepe ketki rarapko, dokoine eŋe eŋano sari olale rakoi, “Kepe ketki naso mo qeyaumaike, so iwa yemo sai togole. Ge ra onnom, ŋei ŋerep eŋe ariu, me bira onnom, matko matko ari edomka ŋara kakiene qoleu.” ");
INSERT INTO ons_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesuŋo edane rake, “Eŋe maine mi arikei, ŋine ŋidom kine kine mane ka more ebonbi neu.” ");
INSERT INTO ons_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Edangi eŋe rakoi, “Ŋene ŋara korop mi ma gemaine, yemo bret mete mane so zawon etke.” ");
INSERT INTO ons_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesuŋo rake, “Ea iwa naŋano ma sariu.” ");
INSERT INTO ons_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Eŋe ra ongi, ŋei ŋerep eŋe qiziŋ kutno ket dara wuruk pese met warekoi, pakiso eŋe bret mete mane so zawon etke maki paki, qeliwo deine potki waki, Anutu bakomine kitoke. Eŋe bret mapokki waki, dokoine ebongiso, edo damo qe ŋei ŋerep ebon warekoi. ");
INSERT INTO ons_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ŋei ŋerep eŋe korop neu ŋatene qewareke, pakiso dokoine eŋe bret so zawon natne wouene suaki qeligeu metke, yewa mau ket kela 12 watkeke. ");
INSERT INTO ons_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ŋeiwa ŋara nekoi eŋane zaleene 5,000. Ŋerep so medep natne yemo mi dapot ongoi. ");
INSERT INTO ons_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pakiso Yesu eŋe dokoine ebuki, seki koto wau paki, edo lewine alakane matko namuŋ kitare arikoi, ariuso Yesu eŋine yemo ŋei ŋerep ea qebinongi mateno ariwarekoi. ");
INSERT INTO ons_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Qebinongi, ŋei ŋerep ariwareu, ea wane ŋadino eŋe meŋo maneo eŋineka wa more meŋenkake. Ruo kereakane okangiso, Yesu eŋe eŋineka ea meŋo geke. ");
INSERT INTO ons_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Naso yewao seki mo doku namuŋ wisino ariki, dibomŋo mawa maket maine qein make, onoka waneŋo momo suaine qeke, ea wane. ");
INSERT INTO ons_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Naso 3 kilok so 4 kilok erane keuetno sakoka, Yesu eŋe dokoine eŋano doku kutnoka gesoka ariki. ");
INSERT INTO ons_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dokoine eŋe kau doku kutno gesoke ariki kakak kakoi, paki eŋe kaetongi aroke rakoi, “Iwa mo osoŋa mane!” ");
INSERT INTO ons_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yale okanbi, Yesuŋo esatka edane more rake, “Togoleu! Iwamo noŋo, misuk kaetŋungep!” ");
INSERT INTO ons_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Rakiso Petoroŋo rake, “Waom, iwa welekatne goŋo, yemo ranom na saket uwe paki, doku kutno gesoka geŋano sariwe.” ");
INSERT INTO ons_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Raki Yesuŋo olatke, “Sarinom!” Eso Petoro eŋe sekiwo ŋine saket more, kieke doku kutno gesoke Yesu wano arike. ");
INSERT INTO ons_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Eŋe ariki momo suaine qeki detki paki, eaka kaetkake, pakiso kieke doku koto qorodoge ketke, paki boka rake, “Waom, neunom!” ");
INSERT INTO ons_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Rakiso, eaka Yesuŋo biraki ketki metino maki paki rake, “Ge mali malipŋone nigagatne magemaine! Ge onoka wane wet etkeka okanmaine?” ");
INSERT INTO ons_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pakiso ere eretnarek seki koto waketpikso, momo mo ea doŋ mange. ");
INSERT INTO ons_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dokoine eŋe seki koto mere umi qe Yesu bakomine kito mawaka rakoi, “Welekatne, ge Anutu wane Gipole!” ");
INSERT INTO ons_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Eŋe doku namuŋ yuane more, sari Genesaret ea kepo ketkoi. ");
INSERT INTO ons_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yewao ŋei ŋerep eŋe Yesu mo detkakoi, eso eŋe mo ea don motpi zoma ŋei eŋane mat loli lolik korop ariwareki ebu peik one, Yesu wano sarikoi. ");
INSERT INTO ons_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Eŋe Yesuŋo detongi, zoma ŋei eŋe takotine mezene eaka uakau paki, zomaene menaŋ oniakane ra olatkoi, pakiso eŋe detongi, takotine mezeno uakakoi, eŋe korop detonge, ea wane rokop okane more menaŋ warekoi. ");
INSERT INTO ons_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Naso yewao Parisi so ra rokop don Kito ebo ebon natne, eŋe Yerusalem ŋine sariu paki, Yesu qesonka rakoi, ");
INSERT INTO ons_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kine onoka wane geŋane dokoŋone eŋe ŋenane aso ŋabo kopze eŋane don numa ŋebongoi, ea mi tewekmami? Onoka wane eŋe numa maine mogare meteene saukeu paki, ŋara mi ma ne okanmami?” ");
INSERT INTO ons_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesuŋo mainge edane rake, “Pakimo ŋine onoka wane Anutu wane ra rokop don ea ŋadekkau paki, ŋinŋine don numa ea mogare ma gemami? ");
INSERT INTO ons_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anutuŋo iwa yale rake, ‘Ge magaŋone so nagaŋone eweetne kitokene,’ So rake, ‘Ŋei mane eŋe naga magaine erane don borikine rayake, eŋe siluŋ qeu seukeake.’ ");
INSERT INTO ons_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ŋo ŋido kito edanmami, yemo ŋei mane eŋe yeye mane mageakeo, yemo eŋe magaine me nagaine maine eaŋo qesiŋotki rap, ŋo siluŋ ramaike, ‘Iwa mo Anutu wane biŋek qekole,’ yemo yaup isioniake, ŋo yemo eŋine biŋek, ");
INSERT INTO ons_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","numa yaline eŋe magaine ewino mi kitomaike, ŋine yale okanbi paki, Anutu wane don mapapkau paki, ŋinŋine don numa ea teweke mogare ari okanmami. ");
INSERT INTO ons_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ŋine isi ŋei nau! Propet Isaia eŋe don koboboine ŋinane iwa yale maine rake! ");
INSERT INTO ons_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Anutuŋo ramaike, ŋei ŋerep iwa eŋe pieneŋoka mawa nanmami, ŋo weteneŋo yemo kakaknane more eri abaran gemami. ");
INSERT INTO ons_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Onoka wane eŋe kepe ŋeiŋo don numa motmole, ea tewekeu paki ra okanmami, Iwa Anutu wane ra rokop don. Eŋe yalineŋo na mawa nanbi rap, yemo mi menaŋgi rap’” ");
INSERT INTO ons_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu eŋe ŋei ŋerep magu edoraki, eŋano ariu edane rake, “Ketŋine motpi paki detlukeu, ŋine misuk ŋaŋaekei! ");
INSERT INTO ons_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ŋei mane eŋe nene kine kine aŋainoka neki kotino wete okanmaike, eaŋo maki kotino mi sigile okanmaike, midakaka! Kotino don kine kine qotkoine wetke mage more, koso aŋaineŋo raki saketmaike, eaŋoka maki ŋei ea kotine sigile okanmaike.” ");
INSERT INTO ons_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pakiso dokoine eŋe eaka sari qesonka rakoi, “Ge don iwa ranom, Parisi eŋe dere worik detpi, ea detmaine?” ");
INSERT INTO ons_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesuŋo edane rake, “Waet kine kine korop Magane qeliwo gemaike, oŋo mi ebotke, eamo baŋ kinerop lokak wareake, ");
INSERT INTO ons_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","eŋane ra more dere mezet mi okanbi, ŋetne magu ea eŋe deene pili pilikine, eŋe yalinane de pilik maneŋo de pilik mane iwenkaki, ari eret narek lom maneo ketmamik.” ");
INSERT INTO ons_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Raki Petoroŋo rake, “Don naŋengo ramaine, ea wane kine ŋedannom detŋem.” ");
INSERT INTO ons_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesuŋo edane rake, “Ŋine yaleka wet dereret ŋine manerop natne eŋane wet dereret mane mi yuankamaike. ");
INSERT INTO ons_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ŋine mi detmami me? Kine kine mane ŋei maneŋo aŋainoka neki, wete kobaŋino ketmaike, paki koso kainoka tetki saket arimaike. ");
INSERT INTO ons_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ŋo kine kine aŋaoka saketmaike, eamo korop wetko ŋine sari saketmaike, kine kine yalineŋo maki ŋei mane wetine sigilemaike. ");
INSERT INTO ons_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Onoka wane eŋine kotino ŋine borikinane dereret ea wetkeki, eaŋo tebaka ari biraki kawali engu seuk marat kamaike, ŋerep mane qelige mane mama, bailalaŋ okane, ŋerep yau yaup ebu ebu, aboŋ kobu mama, isi don rara, so gube qesat don natne edanikei. ");
INSERT INTO ons_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kine kine ea, edo mau ŋei mane wane wetine di kito okanmaike. Ŋo eŋe yale ramami, mete mi sau sauk yaup ŋara ma nene, eaŋo maki ŋei mane wetine sigileake, midaka, eaŋo maki mi sigile okanmaike.” ");
INSERT INTO ons_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu eŋe mat ea qelige more, kepe sai mane Tire so Sidon mat osino pake, ea arike. ");
INSERT INTO ons_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kanan qelaŋ ŋerep mane eŋe kepe ea geke, oŋo Yesu wano sariki paki, ra arok okanka rake, “Suaine, Dawit wane qerakine, Anutuŋo biragangi ketkone! Ge naŋane wetŋone borikep! Naŋane borasone eŋe asu qotkoineŋo kotino pa matalikaki, wikile zok detmaike.” ");
INSERT INTO ons_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yale raki, Yesuŋo don mane mi olatke, eŋine dokoine eŋe eŋano sari raka rakoi, “Talekanom eŋe arikep! Eŋe ŋenane ŋadezo ra aroke sarimaike!” ");
INSERT INTO ons_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesuŋo mainge rake, “Na lama yeo me yeo ket ari gemami, Israel ŋei ŋerep magu eŋaneka weku talenangi ketkole.” ");
INSERT INTO ons_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Raki eaka ŋerep eŋe osino sari wawetineŋo kino qe more umi qe rake, “Suaine, mapik nannom!” ");
INSERT INTO ons_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesuŋo olatke, “Ŋerep ŋene maine Israel medep eŋane ŋara ea ma more, koso qelaŋ kasi eaŋo qakŋem ariki nene, eamo mi menaŋmaike.” ");
INSERT INTO ons_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ŋerepŋo mainge rake, “Suaine, ea welekatne, ŋo siluŋ kasimze eŋe welakopene eŋane zakeo ŋine ne yuankau, sisinemde ketki eŋe weneŋ ne okanmami.” ");
INSERT INTO ons_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Eso Yesuŋo mainge ŋerep olale rake, “O ŋerep, ge mali malipŋone kakapa! Ge onokaka wane ganmaike paki ramaine, yale baŋ okanganiake.” Eso naso eaka borasine menaŋkake. ");
INSERT INTO ons_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu eŋe mat ea qelige more, Galili doku namuŋ ea mogare arike, eŋe ari meŋo waki paki, pese ket metke. ");
INSERT INTO ons_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Metki, ŋei ŋerep magu suaine eŋe eŋano sarikoi. Eŋe kie pekinene qoiqoine, depilik, kie mete seu seune, don mi raraine, so zoma kine kine natne loutne weneŋ ebu sari, Yesu wane kino biraongoi, pakiso Yesuŋo ebuki menaŋ warekoi. ");
INSERT INTO ons_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ŋei ŋerep eŋe welelepkekoi, onoka wane eŋe onbi donene mi raraine edo don ramaŋkoi, kie mete seu seune eŋe menaŋmaŋkoi, kie wawetene me pekinene qoqoine eŋe numa gegeene wakonmaŋke, de pilik eŋe deene potmaŋkoi, eso ea wane eŋe Israel eŋane Anutu mawakakoi. ");
INSERT INTO ons_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu eŋe dokoine edoraki ariu edane rake, “Na ŋei ŋerep iwa eŋane wetne borimaike, onoka wane eŋe narop kaiwe karewe gemami paki, ukude ŋara mane mi nemami. Na ŋara mi gumeon gumeon yaup taleonŋem arikei wane mi nanmaike, onoka wane eŋe mateno arikei wane, ari numao zonomene midayakane.” ");
INSERT INTO ons_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dokoine eŋe olale rakoi, “Ŋene ŋara sai togolo iwa maratka more, ŋei ŋerep magu iwa gumeonŋem, maine rokop oniake!” ");
INSERT INTO ons_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesuŋo edane rake, “Ŋine ŋara darap magemami sikan nanbi!” Eŋe olale rakoi, “Bret sewen so zawon mida nigatne etkemde ma gemaine.” ");
INSERT INTO ons_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Eso Yesu eŋe mo ea ŋei ŋerep magu ea raongi, kepo dara wuruk pese ket met warekoi. ");
INSERT INTO ons_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pakiso, eŋe bret sewen so zawon ea maki paki, Anutu bakomine kito more, mapokki waki dokoine ebonge, eso dokoine eŋe ma more damo qe, ŋei ŋerep ebon warekoi. ");
INSERT INTO ons_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Eŋe korop neu ŋatene qewareke, dokoine eŋe neu wokitne metke, ea mau ket rosa sewen watkeke. ");
INSERT INTO ons_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ŋei ŋara nekoi, eŋane zaleene 4, 000, ŋerep so medep nigatne yemo mi dapotongoi. ");
INSERT INTO ons_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Eso Yesu eŋe mo ea ŋei ŋerep taleongi, mateno ari wareu, eŋine seki koto waketki, pakiso Magadan kepe sai ea arike. ");
INSERT INTO ons_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi natne so Sadusi natne eŋe Yesu wano sarikoi, eŋe liwekkakei wane detkoi, eso eŋe masi togogole mane maki, eaŋo Anutu wane kine sikanongi kakei wane olatkoi. ");
INSERT INTO ons_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ŋo ŋei Yesuŋo yemo edane rake, “Ŋine kepe kesiakane okangi, ŋine ra okanmami, ‘Ŋenane kepe menage payakane okanmaike, onoka wane qeliwo aso aso kito walakmaikane.’ ");
INSERT INTO ons_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Eso sakoka yemo ŋine ra okanmami, ‘Eamo koya qeakane okanmaike, onoka wane qeliwo kup kezoŋ okane kepe takelemaike, so di okanmaikane.’ Ŋine kup so aso aso ea wane kine yemo maine tanikine qeliwo kau paki detka okanmami, ŋo ŋine naso iwa ea wane masi tanikine yemo maine mi detkakei! ");
INSERT INTO ons_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ŋine kaiwe naso ukude iwa wane ŋei ŋerep tego yemo borikine so eŋe weteeneŋo Anutu wano mi paulukmaike. Eŋe naso baŋem masi togogole mane kaikei wane ra okanmami, ŋo eŋe masi mane baŋ mi kaikei, midakaka! Ŋine masi togogole weku baŋ ŋibonbe kakei, yemo Yona wano masi wikile wakonge, eaka wakongi kakei.” Eso eŋe yale ra more qeliŋ one so wie arike. ");
INSERT INTO ons_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dokoine eŋe doku namuŋ yuane erinat arikoi, eŋe niget ongi bret mane weneŋ mi ma arikoi. ");
INSERT INTO ons_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesuŋo edane rake, “Ŋine kaulukkei, so diam ŋine seleleine makei, Parisi so Anutu wane ra rokop don welaine ŋei Sadusi, eŋane yisiŋo masi plawa maki sua okanmaike, yale ŋinane keuo eŋerop masi qotkoine suayakane, so ŋinano wakesiakane ware nagukei.” ");
INSERT INTO ons_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dokoine eŋe don ea dere edomka auye rakoi, “Eŋe iwa ramaike, yemo onoka wane ŋene bret mane mi ma sarine, ea wane mane ramaike.” ");
INSERT INTO ons_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu eŋe don daleo aukoi, ea mo detonge, paki eŋe qeson one rake, “Ŋine onoka wane ŋidomka auye ramami, bret mi ma sarine, ea wane mane ramaike, yale ramami? Ŋine mali malipŋine nigagatne ma gemami me? ");
INSERT INTO ons_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ŋine kine mi detlukmami me? Ŋine na bret mete mane(5) ea ŋei ŋerep 5 tausen eŋane mapokkole, ea mi detmami me? Ŋine rosa darap wokitne metke, ea mau ket watkeke? ");
INSERT INTO ons_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","So bret sewen eaŋo ŋei 4 tausen eŋane mapokkole eamo daleo? Ŋine rosa darap wokitne metke, ea mau ket watkeke? ");
INSERT INTO ons_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ŋine daleo wane na bret wane mi ŋidanile, ea wane kine mi detlukmami? Ŋine diamŋine seleleine makei, Parisi so Anutu wane ra rokop don welaine ŋei Sadusi, eŋane masi tanik qotkoine eaŋo yis yaleka rokop ŋuniakane!” ");
INSERT INTO ons_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Eso dokoine eŋe kine mo detkoi, eŋe yis waneka bretko motpi maki sua okanmaike, ea wane mi edange. Ŋo yemo Parisi so Anutu wane ra rokop don welaine ŋei, Sadusi, eŋane kito ebo ebon enane masi tanik kaulukkei wane eao more edange. ");
INSERT INTO ons_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu eŋe ari kepe sai mane mat suaine Sisaria Pilipai osino pake, ea lotkeke. Yewao dokoine qesonone rake, “Nolatpi desikale, ŋei ŋerep eŋe Ŋei Wawainane Gipole eŋane ra more ma oramami?” ");
INSERT INTO ons_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Eŋe olale rakoi, “Natne eŋe ramami, Yohane Doku Tautau, natne eŋe ramami, Elaiya, ŋo natne eŋe ramami, Yeremaia me propet mane.” ");
INSERT INTO ons_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu eŋe dokoine edane rake, “Nolatpi detpe, ŋine yemo daleo? Ŋine naŋane ma noramami?” ");
INSERT INTO ons_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Petoroŋo rake, “Ge Mesia, Anutu gege togon wane gipole, oŋo ge biragangi ketkone.” ");
INSERT INTO ons_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Raki Yesuŋo mainge rake, “Simon Yohane gipole, ge wekumane ramaine, wet pesek desikene! Onoka wane ge don wele iwa ramaine, yemo ŋei natne eŋano ŋine geŋano sariki mi ramaine, yemo Magane qeliwo gemaike, oŋo koboboine wetŋono motki ramaine. ");
INSERT INTO ons_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eso ea wane na iwa yale golatpe, Petoro, ge wesi mane, na doku tau tau ŋei ŋerep magune wesi yewa wane kutno mawe mesiake, paki seu seu wane zonomŋo naŋane urum me doku tau tau magu yewa mane baŋ mi maket birakayake. ");
INSERT INTO ons_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na qeli gege togon urum wane ki baŋ gingale, ge kepeo ra togolenom, qeliwo yale waka Anutu eŋe baŋ ra togoleake, ŋo ge kepeo rakokenom, qeliwo Anutu eŋe yale waka baŋ rakokeake.” ");
INSERT INTO ons_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yale raki paki, dokoine togogoleka rawetonge, eŋe Mesia ea ŋei mane mi edangei wane. ");
INSERT INTO ons_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Naso yewao ŋine kieke Yesu eŋe dokoine don didiwo kieke ra wakone edane rake, “Na mo Yerusalem matko wakale paki, ŋei suaine, pris ŋetne, so ra rokop don kito ebo ebon ŋei edo wikile zok suaine ningei. Nine more, na baŋ nekuwi seukkale, paki kaiwe karewe okangi, na baŋ koso ma wiriknangi, wisikae wiekale.” ");
INSERT INTO ons_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Edangi, Petoroŋo eŋineka bonep newanka more, busuka more rawetkaki paki rake, “Waom! Eamo midakaka, kine kine yewa mane iwa geŋano mi wakoniake!” ");
INSERT INTO ons_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesuŋo zinge Petoro olale rake, “Satan! Na biranane arinom, ge naŋane numa leŋleŋ okannanmaine, onoka wane geŋane dereret iwa yemo ge Anutu wane dereret mogare mi ramaine, midakaka, ge yemo ŋei eŋane dereretka mogare ramaine!” ");
INSERT INTO ons_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pakiso, Yesu eŋe dokoine edane rake, “Ŋei mane eŋe naŋano sariakane okaneso, koto so solainane don ŋadekka more, kibeŋ qabeŋine teweke more, naŋane ŋadeno sariake. ");
INSERT INTO ons_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Onoka waneŋo mane eŋe eŋine gegeinane simile dere mo mawaluk kayakeo, eŋe baŋ siuke maniake, ŋo mane eŋe naŋane raki paki gegeinane simile ea qaisik kayake, eŋe baŋ gege togon marat kayake. ");
INSERT INTO ons_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mane eŋe kepe baŋem ea wane kine kine korop pamaike, ea kutno kutno more mawamaŋki, gegeine mida leleki paki, ki pelelekkaki, ea wane wele yemo onokakaŋo wakonkayake? Me gegeinane turuŋine onokaka koso makimo, zinge baŋ koso qesiŋkaki maniake? Kine mane midakaka, so mane mi pamaike! ");
INSERT INTO ons_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ŋei Wawainane Gipole eŋe mo Magainane kibi qelaŋangorop aŋelo koune ebuki sarikei, pakimo eŋe baŋ ŋei koboboine so ŋei borikitne gege mageenane rokopko turuŋine mainge eboniake. ");
INSERT INTO ons_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Welekatne iwa detlukkei! Iwa okoramami, ŋinano ŋine ŋei natne eŋe baŋ mi seukwarekei, eŋe yeka geu paki kau Ŋei Wawainane gipole eŋe Ŋei waom yale okane sariake.” ");
INSERT INTO ons_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kaiwe sikis qoeki, ŋadino Yesuŋo Petoro so tatiŋon Yakop so Yohane eŋerop weneŋ arikei wane ebuke, eso eŋe iwen ongi, bonaga kiroine maneo enŋeneka wakoi. ");
INSERT INTO ons_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wau paki, kau kau eaka solaine qeingeke, paki eŋine kaitine qilaunerop kepe deine yale okange, eso takotineŋo wakokoine, kiwa yale okange. ");
INSERT INTO ons_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pakiso, dokoine karewe eŋe pore otpi, Mose so Elaiya ere Yesurop don aukoi. ");
INSERT INTO ons_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Eso Petoro eŋe Yesu olale rake, “Waom, ŋene iwa geŋem maine okanmaike, ea wane ge detnom na kise karewe iwa baŋ makale, mane geŋane, mane Mose wane, so mane Elaiya wane.” ");
INSERT INTO ons_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Eŋe yale rakiso, eaka kezoŋ qilaunerop eaŋo sari kawetonge, pakiso kezoŋ koto ŋine don boka woka mane iwa yale raki ketke, “Iwamo nae Gipon maepne, na eŋane simile nanmaike, ŋine donine desikei!” ");
INSERT INTO ons_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dokoine eŋe boka woka ea detpi paki, eŋe zok manerop zonomene oreki, kaitene kepo maingeu ketki umi qe pakoi. ");
INSERT INTO ons_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yale okanbi, Yesuŋo osoeno sari ebu more rake, “Kaŋzaŋ wieu, ŋine misuk kaetŋungep!” ");
INSERT INTO ons_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Eso eŋe wieu paki, pore ŋei mane mi kakoi, Yesu eŋineka weku okoraki kakoi. ");
INSERT INTO ons_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Eŋe bonagao ŋine ketpi paki, Yesuŋo rawetone rake, “Ŋine masi iwa wakongi kamami, ea wane donkisi ŋei mane misuk edanikei, yeine qeligeu pamageki, Ŋei Wawainane Gipole seuseuo ŋine ma wirikkaki wisikae wieake, naso yewao don disiine maine edanikei.” ");
INSERT INTO ons_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pakiso, dokoine eŋe Yesu olale rakoi, “Kine ŋedannom desikene, ra rokop don kito ebo ebon ŋei, eŋe ramami, ‘Elaiyaŋo Mesia wane alakane sariake.’” ");
INSERT INTO ons_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Rau Yesuŋo edange, “Elaiya eŋe welekatne alakane sariake, paki eŋe kine kine korop matok qetok mawareake. ");
INSERT INTO ons_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ŋo na welekatne iwa ŋidanbe, Elaiya eŋe mo sarike, pakimo ŋei ŋerep eŋe kau paki mi detkakoi, ŋo siluŋ enŋene simile ea mogare more, masi kine kine korop okankakoi. Numa yewaka, Ŋei Wawainane Gipole eŋe baŋ yaleka edo qe matali qetali okankakei.” ");
INSERT INTO ons_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yale rakiso, dokoine eŋe mo detkoi, eŋe Yohane Doku Tau Tau wane ramaike. ");
INSERT INTO ons_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Eŋe koso ŋei ŋerep magu suaine eŋano zinge lotkeu, ŋei maneŋo sari Yesu wane kino wawetine qeke. ");
INSERT INTO ons_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Paki rake, “Suaine, ge naŋane giponnane wetŋone borikep! Eŋe naso baŋem seuke wisikae okane, wikile zok det okanmaike, paki waraŋkaki gerepko me dokuo ket okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na geŋane dokoŋone eŋano ma sarikole, ŋo siluŋ edo eŋe maine mi ma menaŋkakoi, eŋe ŋaŋaekoi.” ");
INSERT INTO ons_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesuŋo mainge rake, “O mali malip midaine, so sotkorop ŋine ŋei iwa! Na naso kiroine ŋineropka ge arikale me? Na naso baŋem ŋinerop ge more umat kine kine ŋinane kau, bisi okanŋune more ŋibu gekale me? Medep ea naŋano ma sariu!” ");
INSERT INTO ons_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Raki, ma sariu, Yesuŋo asu qotkoine ea don olatki eŋe saket arike, eso medep ea eŋe naso yewaoka menaŋkake. ");
INSERT INTO ons_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pakiso dokoine eŋe bonepko Yesu wano sari olale rakoi, “Kine ŋedannom desikene, eŋe daleo wane asu qotkoine ea mogatŋem mi aŋaze teweke saket arike?” ");
INSERT INTO ons_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Rau Yesuŋo mainge rake, “Eamo onoka wane mida, ŋine mali malip zok mi ma gemami, ea wane. Wane iwa yale detpi! Ŋine mali malipŋine nigagatne mastet wounane rokop ma gekeiwo, yemo ŋine bonaga iwa maine olale rau rap, ‘Iwa ŋine eriwa arinom!’ Rau, eso eŋe baŋ ariki rap. Ŋine mali malip korop kine kine maine okangei, misuk ŋaŋaekei! ");
INSERT INTO ons_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Asu qotkoine yaline yemo numa weku meŋe meŋen so miti wane ra more sawe gegeŋo maine mogatkaki, saket ariake, kine kine maneŋo mi mogasiake.” ");
INSERT INTO ons_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dokoine eŋe korop Galili kepeo sari wareu, Yesuŋo edane rake, “Ŋei Wawainane Gipole yemo mo ŋei ŋaba eŋane meteeno birakau wayakane nasoine bomilemaike, ");
INSERT INTO ons_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","waki, ŋei edo baŋ qeu seukeake, ŋo siluŋ kaiwe karewe eao eŋe baŋ ma wirikkaki wisikae wieake.” Dokoine eŋe don ea detpi umare so wetene manerop borike. ");
INSERT INTO ons_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu eŋine so dokoine eŋe Kaperneam matko sarikoi, pakiso Bakom Urum wane takis mama ŋei eŋe Petoro wano sari olale rakoi, “Ŋinane kito ŋibo ŋibon eŋe Bakom Urum wane takis mot okanmaike me? Ŋedannom desikene.” ");
INSERT INTO ons_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petoroŋo edane rake, “O, mot okanmaike.” Petoro eŋe mat koto ari wake, naso eao Yesuŋo mikepka Petoro qesonka rake, “Saimon, ge nolatnom daleo detmaine? Maŋo opesi me takis kepe iwa wane ŋei waom qoleon okanmaike? Kepe mat welaine ŋei ŋerep ea edo me ŋei lobo edo?” ");
INSERT INTO ons_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petoroŋo mainge rake, “Ŋei lobo edo.” Yesuŋo mainge rake, “Ea mo mayakatne, ea wane kine yemo iwa yale, kepe mat welaine edo mi qolekei, ");
INSERT INTO ons_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ŋo siluŋ ŋei ŋerep iwa eŋe ŋenane misuk detpi boriake, eso ea wane ge doku namugo arinom paki, abi mane biranom ketkep paki, zawon mikepka qadekene, ea tebanom sayake, saki aŋaino ge baŋ wesi mane maratkakene, yemo lewine naŋane Bakom Urum wane takis wane rokop so geŋane, ea manom pakiso ŋerane takis ea qolekene.” ");
INSERT INTO ons_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Naso yewao dokoine eŋe Yesu wano sariu paki, olale rakoi, “Ŋedannom desikene, maŋo natne yuan one more qeli gege togon mat kotino suaine okanmaike?” ");
INSERT INTO ons_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Rau, Yesu eŋe medep nigatne mane oraki sariki birakaki kaiteno okorake. ");
INSERT INTO ons_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Paki edange, “Iwa rawe detpi! Ŋine qeinge more, medep nigatne iwa eŋane kop mi okangeiwo, yemo ŋine qeli gege togon mat kotino mi wakesikei. ");
INSERT INTO ons_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Qeli gege togon mat kotino suaine gege wane, yemo mane eŋe oŋomka ket more, ketkele medep nigatne iwa wane rokop geakeŋo suaine okaniake. ");
INSERT INTO ons_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","So mane eŋe naŋane eŋet biŋeknane raki paki, medep nigatne iwa yale ora tebakayake, eŋe na yaleka nora tebananiake. ");
INSERT INTO ons_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mane eŋe medep nigatne iwa eŋe mali malipene naŋano motpi pamaike, ea ŋinane keuo ŋine medep mane borikine mayakane sorinkaki, mali mali pine naŋano ea kitare more, borikine mayakeo, yemo ŋei yewa eŋe maine yaben mane suaine ebino qeu kiki lukkau paki, rupapkau kiwetko ketki siuki rap, yemo menaŋgi rap. ");
INSERT INTO ons_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yai, kepe ŋei eŋe ŋei ŋerep borikine makei wane sorinon okanmami, eŋe daleo okangei? Kine kine yaline ea baŋ naso baŋem wakoniake, ŋo mane eŋe borikine yaline ea sorinongi makei, eŋe daleo okaniake? Eŋe maine siukkei. ");
INSERT INTO ons_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ge meteŋoneŋo me kieŋoneŋo waraŋgangi ari borikine maneo rasukeneo, yemo ea kitare more biranom ariake! Ge gege togon matko yemo kieŋone so meteŋone midaine maine waketkene, ŋo meteretke ŋone so kieretke ŋone weneŋ sot korop magekeneo, yemo sora gerep papa togon yewao birau ketnom gaeake. ");
INSERT INTO ons_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","So geŋone deŋoneŋo borikine makenane simile wetŋono mosiakeo, qepitike biranom ariake! Eamo maine ge gege togon matko deŋone weku eaŋoka wakesikene, ŋo deŋone etkeka sot weneŋ epu gekeneo, yemo biraganbi gerep togole sorao ze pamaike, eao ketnom gaeake. ");
INSERT INTO ons_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Na don welekatne ŋidanbe detpi, ŋine kauluke more, medep nigatne kopne iwa eŋane mane mi detpi ketkele okaniake, onoka wane eŋane aŋelokopene weti qeliwo gemami, eŋe naso baŋem Magane qeliwo gemaike, eŋane kaitko gemami, ŋine mi maulukonbi, yemo aŋelo eŋe ŋine wikile ŋibonikei. ");
INSERT INTO ons_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ŋei Wawainane Gipole eŋe lama siukkoi, ea zuaŋone ebuyakane ketke. ");
INSERT INTO ons_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ŋine iwa wane detmami? Ŋei mane eŋe lamakoune 100 okorakei ea eŋano ŋine mane siukki, eŋe daleo okaniake? Eŋe dere mezet okane more qeliŋongi, lamakoune 99 ea meŋo rereŋino ŋaraene ne geu, eŋe ari lamaine mane siukike, ea wane zuaŋkayake. ");
INSERT INTO ons_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na welekatne ŋidanbe detpi, eŋe zuaŋlukmage maratkayake, paki eŋe lamakoune 99 eŋane mi detmaike, wekuwa siukike, eŋane wet pese suaine desiake. ");
INSERT INTO ons_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Numa weku yewaka, Magaŋine qeliwo gemaike, eŋe nigatnekopne iwa eŋano ŋine maneŋo siukeakane mi simin kamaike. ");
INSERT INTO ons_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ge kimaŋone maneŋo geŋano sot okangi, ge eŋano arinom paki, sotine ea sikan kakene. Ŋo siluŋ ŋire ŋiritneka bonepŋitne okangeik, eŋe olatnom donŋone detmaikeo, yemo ge kimaŋone ea mo mainka numa maine birakamaine. ");
INSERT INTO ons_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ŋo eŋe donŋone mi desiakeo, yemo ge ŋei weku me etke epunom ererop weneŋ ari kineine detkau paki, ŋei etke me kareweŋo don ra makoboe okangei. ");
INSERT INTO ons_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ŋo eŋe eŋane don mane mi desiakeo, yemo doku tau tau magu kineine edanikene, p aki eŋe doku tautau magu eŋane don mi desiakeo, yemo detkau, eŋe ŋei lobo mane so takis borikine mama mane sot korop okaniake. ");
INSERT INTO ons_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Eso na rawe korop detpi, ŋine yeye kine kine korop kepeo rawetkeu, Anutuŋo qeliwo yaleka rawetkeake, yeye kine kine kepeo rakokeu, Anutuŋo qeliwo yaleka rakokeake. ");
INSERT INTO ons_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“So na mane takotke rawe detpi, ŋire ŋei etkeŋo yeye mane wane ra more, wetŋitne weku more meŋenkauk, Magane qeliwo gemaike, eŋe baŋ ŋiponiake. ");
INSERT INTO ons_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ŋei etke me karewe eŋe naŋane eŋet biŋeknane rau paki, wekuoka qeturaŋ ge metpi, na weneŋ yewa eŋerop metkale.” ");
INSERT INTO ons_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yesu eŋe don yale raki Petoroŋo Yesu wano sariki paki, qesonka rake, “Waom, nolatnom desikale, naŋane kimane eŋe atak loutne borikine okannangi, na maine turuŋine atak darap qeliŋgale? Na maine atak sewen sot turuŋine qeliŋgale?” ");
INSERT INTO ons_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesuŋo olale rake, “Mida, atak sewen midaka, ŋo siluŋ sewenti magu sewen yale qelige man gekene, ");
INSERT INTO ons_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","onoka wane qeli gege togon wane numa ea yemo, ŋei Waom mane oŋo qelit ŋeikoune eŋine sotaene makokkei wane lolike kake, ea wane rokop. ");
INSERT INTO ons_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eŋe lolike kayakane kiekki, eaka qelit ŋei mane ma sarikoi, oŋo milion kina eŋane waom wane biŋek yale omakake. ");
INSERT INTO ons_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wane qelit ŋei ea eŋe wesi mane mi magekane, sotaine ea mi qoleke, eso ŋei waomine eŋe raki, eŋe qelit qeqe mane yale, eŋine so ŋanomine, so medewekoune, so yeye kine kineine korop mageke, ea ŋei ebongi, eŋe wesi manbi sotaine ea qeakane olatke. ");
INSERT INTO ons_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Olatki, qelit ŋei waominane kino wawetine qeki paki rake, ‘Ge naŋane wetŋone boriki, qeliŋ nannom, na baŋ korop sotane makok warekale!’ ");
INSERT INTO ons_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Raki, ŋei waom eŋe wetine boriki, sotaine ea yeine qeliŋgi paki, ŋei birakaki arike. ");
INSERT INTO ons_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Eso qelit qeqe ŋei yewa, eŋe ariki paki qelit ŋei kimaine mane wesimde ewekine 100 kine yale omakake, eŋe maratkake. Maratkaki paki, malipka more, ebine maguloke rake, ‘Ge naŋane wesi neu makone, ea wane sota ea koso turuŋine qolenanikene!’ ");
INSERT INTO ons_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Raki qelit ŋei kimaine eŋe umi ket more olale rake, ‘Ge naŋane wetŋone boriki qeligenom, na baŋ sotaŋone ea mainge qolegangale!’ ");
INSERT INTO ons_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ŋo eŋe siluŋ don raki dere mi loloŋkake, ea wane turuŋine yemo eŋe mulap urumgo birakake, ea mere sotaine ea mainge qolekawareki qoeki sakesiakane. ");
INSERT INTO ons_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Qelit ŋei kimakoune eŋe tanik yewa okangi kau borike, paki ari ŋei waomene ea donkisi korop olatwarekoi. ");
INSERT INTO ons_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Eso ŋei waom eŋe qelit ŋei oraki sari saketki olale rake, ‘Ge qelit ŋei borikine sot korop! Ge naŋano ŋine wesi suaine oma nangone, wane na turuŋone qeligewe paki sese ganile, kine onoka wane goŋom nolatnom mo na loloŋganile. ");
INSERT INTO ons_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ge qelit ŋei kimaŋonane wetŋone boriki loloŋ ganile yale, mi okanikene’ ");
INSERT INTO ons_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yale ra more sotine osiki qelit ŋei ea birakaki mulap urumgo wikile mane makoboe kakei wane waketke, ea mere sotaine ea korop makok wareki qoeki, sakesiakane.” ");
INSERT INTO ons_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Pakiso Yesuŋo don iwa yale raki qoeke, “Ŋine wetŋineŋo kimakopŋine eŋane sot turuŋene mi qeliŋgeiwo, yemo Magane qeliwo gemaike, eŋe masi tanik yewa, ea ŋine weku weku baŋ okanŋuniake.” ");
INSERT INTO ons_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu eŋe don ea korop rawareki qoeki, eŋe Galili kepe qelige more, ari Yuda kepeo Yordan doku wane eri nat paromino arike. ");
INSERT INTO ons_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ariki, ŋei ŋerep magu suaine eŋe ŋadino ariu, zomarop yewa ma menaŋonge. ");
INSERT INTO ons_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisi natne eŋe eŋano liwekakei wane eŋano sari rakoi, “Ŋenze ra rokop donzeŋo ŋei mane rakokkaki, ŋanomne qeliŋkawe ra, kine ea me ea wane ra, maine qeliŋ kayake me?” ");
INSERT INTO ons_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesuŋo mainge rake, “Ŋine Anutu wane papiao don iwa yale pamaike, ea mi dapore det okanmami me? Ramaike, ‘Mokaka qei kino ma wakon ma wakonŋo ŋei so ŋerep orodoŋka ma wakonotke.’ ");
INSERT INTO ons_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Paki Anutuŋo rake, ‘Ea wane ŋei maneŋo naga magaine qeliŋotki paki, ŋanominano takotkeake, pakimo ere koto so sola mo weku okangeik.’ ");
INSERT INTO ons_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Eso na ramaile, ere koso etke mi okane more, weku okangeik, Anutuŋo maturaŋ otkane, ŋeiŋo maine misuk mapok osikei.” ");
INSERT INTO ons_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Raki Parisi eŋe qesonka rakoi, “Pakimo, Mose eŋe onoka wane ra rokop don ebonge, ŋei mane eŋe ŋanomine qeliŋkayakane okane, kibi mane qe maneso esopkaki ariake?” ");
INSERT INTO ons_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Rau Yesuŋo edange, “Moseŋo ŋanowekopŋine qeliŋ ongei wane dere ŋibonge, yemo yaup ŋinŋine wetŋine zok togogole, daleo kito ŋibongi desikei, ea wano raki paki dere rakoke ŋibonge. Ŋo qei Anutuŋo kieke more ma wakonge, naso yewao yemo numa iwa yaline mane mi pake. ");
INSERT INTO ons_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ea wane na ŋidanbe detpi, ŋei mane eŋe ŋanomine sot midaine maine geki, qeliŋkaki paki, ŋerep natne ebuyakeo, eŋe zokit ea kitatmaike, ŋei ea eŋe sotkorop okaniake.” ");
INSERT INTO ons_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Eŋine dokoine edo dere olale rakoi, “Numa yale ŋei mane so ŋanomine erane keruetno pamaikeo, yemo ŋerep mi mama yaup maine gekene.” ");
INSERT INTO ons_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Rau Yesuŋo edange, “Don iwa ŋerep mi mama yemo ŋei ŋerep korop eŋane mi ramaile, ŋo yemo don iwa dere wetke magekei wane zonom pa ebon maike, edoka weku magekei wane Anutuŋo ebonge. ");
INSERT INTO ons_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ŋei eŋe ŋerep onoka wane mi ebukei, ea wane kine loutne pamaike, Ŋei natne eŋe yemo onoka wane yalewa oken gekei wane wakonmami, natne yemo onoka wane ŋei edom ŋerep midaine gekeiwane kitat onmami, so natne ŋerep mi ebumami, yemo onoka wane eŋe qeli gege togon don wane ra more, yemo ŋei yaline eŋane biŋek ea wane eŋe yaup gemami. Mane eŋe iwa maine okaniakeŋo don iwa dere ma nogankayake.” ");
INSERT INTO ons_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ŋei ŋerep natne eŋe medewekopene Yesuŋo metine leweeno more, meŋen kayakane eŋano ebu arikoi, ŋo dokoine edo yemo ŋei ŋerep ea rawetongoi. ");
INSERT INTO ons_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yale okanbi, Yesuŋo rake, “Ŋine qeliŋonbi medep nigatne eŋe naŋano sariu, so mi kitatonbi, onoka wane ŋei ŋerep ea medep nigatne yaline, eŋe qeli gege togon ea mo biŋek qe ebonge.” ");
INSERT INTO ons_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yale raki paki metine leweeno moreso, kepe ea qelige maneo arike. ");
INSERT INTO ons_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Naso maneo ŋei maneŋo Yesu wano sari olale rake, “Kito ŋebo ŋebon, nolatnom detpe, na onokaka maine mane okanbe paki, gege togon maratkakale?” ");
INSERT INTO ons_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Raki Yesuŋo olale rake, “Ge kine kine mainane qeson nanmaine? Maine welaine eŋe weku gemaike, ge gege togon kotino waketkenane okaneso, yemo Anutu wane ra rokop don ea tewekkene.” ");
INSERT INTO ons_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Eŋe qesone rake, “Ra rokop don diawa?” Yesuŋo olale rake, “Ge ŋei mi qem seukeake, ŋao ŋanom ŋire mi qeliŋnagukeik, ge kobu mi makene, ge isi mi rakene, ");
INSERT INTO ons_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ge naga magaŋone eweetne kitokene, so ge geŋonane ganmaike, yalewaka ŋei kimakopŋone eŋane ganiake.” ");
INSERT INTO ons_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ŋei qaluwit eŋe mainge rake, “Iwa mo korop okan warekole, onokaka mane koso okanikale?” ");
INSERT INTO ons_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesuŋo olale rake, “Ge sot midaine gekenane dereso, yemo ari yeye kine kineŋone ma gemaine, ea korop ŋei natne ebon warekene, paki wesiwa eamo, ŋei aboŋene midaine gemami, eŋe ebon warenom, pakiso ge qeliwo riwe morian pamaike, ea maratkakene, pakiso sari ŋadeno sarikene.” ");
INSERT INTO ons_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ŋei qaluwit eŋe don ea dere wetine boriki arike, onoka wane eŋe aboŋ suaine pamange, ea wane. ");
INSERT INTO ons_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pakiso Yesuŋo dokoine edane rake, “Na rawe detpi, ŋei mane aboŋine suaineŋo qeli gege togon wane numa marat kayakane, qeka makaine zok okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na koso don mane ŋidanbe, ŋei mane aboŋine suaineŋo qeli gege togon wane numa marat kayakane, eamo zok umatne qeka qekaine okan maike, ŋo rokopne yale waka, kamel maneŋo samap aŋaino wake waket ea yemo ewekine.” ");
INSERT INTO ons_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dokoine eŋe don iwa detpi paki, oŋaene zok qaeki, qesonka rakoi, “Pakimo maŋo maine qeli gege togon marat kayake?” ");
INSERT INTO ons_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Rau Yesuŋo deine pore onluke more, edane rake, “Iwamo ŋei edo oka okan yemo ŋaŋaemami, ŋo siluŋ Anutuŋo yeye kine kine mane mawe ra, yemo rokoune mawareake.” ");
INSERT INTO ons_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Rakiso Petoroŋo olale rake, “Ŋene yeye kine kineze korop qeliŋ wareŋem paki, geŋane ŋadeŋono sarikone, ea wane ŋene onokaka lewine mane maine makene?” ");
INSERT INTO ons_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Raki Yesuŋo edane rake, “Na iwa rawe detpi, ŋado yeye kine kine korop musele wakon wareake, naso yewao Ŋei Wawainane Gipole eŋe ŋei waom met metine qeli ewe zonominerop ea wane kutno pese mesiake, paki naŋane dokone 12 ŋadeno sarikoi, ŋine baŋ yaleka ŋei waom met metko pese metwareu paki, Israel magu 12 ea wane kine ma wanokonikei. ");
INSERT INTO ons_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Paki, ŋei ŋerep deo edo naŋane rau paki, matene me ŋolekopene, me kiarokopene, me magaene, me nagaene, me medewekopene, me eu menamene me kepe mateene qeliŋwarekoi eŋe baŋ lewine morian manerop maratkakei, so gege togon baŋ eboniake. ");
INSERT INTO ons_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ŋo siluŋ ŋei loutne kepe naso iwa lewine alakanmami, eŋe baŋ ŋado kitokei, ŋo ŋei loutne kepeo naso iwa ŋado kitomami, eŋe baŋ naŋane qeli kepe museleo, lewine alakangei.” ");
INSERT INTO ons_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Qeli gege togon wane numa, yemo wain eu welaine maneŋo sakoka urata ŋei natne qoleongi, sari wain urataine makeiwane arike, eawane rokop. ");
INSERT INTO ons_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Eŋe dereret okannagu more, wetene weku okangi, wesi silwa wan kina kaiwe weku, ea qoleoniakane ma togole more, biraongi wain euo urata makei wane arikoi. ");
INSERT INTO ons_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Eŋe koso manerop 9 kilok nalu sobeŋino arike, paki ongi ŋei natne yaup ea taboŋ okorakoi. ");
INSERT INTO ons_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eso eŋe edane rake, ‘Ŋine yaleka wain euo ari urata mau paki, na baŋ lewine mayakatne qoleŋunikale.’ ");
INSERT INTO ons_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Eso eŋe mo ea arikoi. Pakiso 12 kilok, so 3 kilok yaleka eŋe masi wekuka okange. ");
INSERT INTO ons_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pakiso, 5 kilok okaniakane okangi, eŋe nalu sobeŋino koso ari ŋei natne ongi, eŋe yeka okorau qesonone rake, ‘Ŋine onoka wane kaiwe korop matali iwa yaup taboŋ okoramami?’ ");
INSERT INTO ons_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Eŋe rakoi, ‘Kine yemo onoka wane, ŋei maneŋo mi qoleŋonike, ea wane iwa okoramaine.’ Yale rauso, eŋe edane rake, ‘Weku mane, ŋine yaleka ari wain euo urata mau.’ ");
INSERT INTO ons_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ruo kereki naso okangi, wain eu welaineŋo ware wareine olatke, ‘Ge urata ŋei edoranom sariu, lewine qoleonnom, ŋeiwa ŋado qoleonile, eŋano ŋine kieke arinom, alakan qoleonile, eŋano qoeake.’ ");
INSERT INTO ons_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ŋeiwa 5 kilok urata kieke makoi, eŋe wesi silwa wan kina, wan kina qoleonge. ");
INSERT INTO ons_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Eso ŋeiwa alakan qoleonge, eŋe mo ea urata wane lewine qoleoniakane sarikoi, eŋe wetke rakoi, wesi suaine mane makene, ŋo eŋe yale waka siluŋ wesi silwa wan kina, wan kinaka ebonge. ");
INSERT INTO ons_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Eŋe wesiene ma wareu paki, kieke urata welaine bokaka rakoi, ");
INSERT INTO ons_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ŋeiwa iwa ŋado ebuki sarimi, eŋe urata wan auaka weku memi, ŋo ŋedo yemo kaiwe mane korop kaiwe teleŋ telego urata mene, ŋo siluŋ ge eŋe qoleoŋine rokop weku yewaka ŋene qoleŋonmaine!’ ");
INSERT INTO ons_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yale rau, eu welaineŋo eŋano ŋine mane olale rake, ‘Detnom, kima, na mi matali ganmaile, ge kaiwe weku urata ma more, wesi wan kina makenane ra, dereret okannagune. ");
INSERT INTO ons_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ea wane ge wesiŋone manom paki, matko arinom. Na wesi ge ginile, rokop weku yewaka ŋei iwa ŋado rawe sarike, eŋe manile. ");
INSERT INTO ons_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yewa yemo naŋane aboŋ, na nae simile mogare mo na wesi biŋekneŋo rokop weku damo qile, eaŋo mi rokopkemaike me? Onoka wane noŋo masi maine ŋei ŋado sarimi ea okanonbe ge dale wane dere okanmaine me?’” ");
INSERT INTO ons_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Raki pakiso, don iwa yale raki qoeke, “Eso ŋeiwa ŋado kitomami, edo baŋ naŋane qeli kepe museleo lewine alakangei. Pakiso ŋeiwa lewine alakanmami, edo baŋ ŋado kitokei.” ");
INSERT INTO ons_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu eŋe Yerusalem matko wayakane okane, dokoine 12 ebuki enŋeneka arikoi. Numao ari more sanka don edangi edangi arikoi. ");
INSERT INTO ons_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Eŋe edan rake, “Detmami, ŋene Yerusalem matko wamaine, yewao Ŋei Wawainane Gipole baŋ ma more, Pris ŋetne so ra rokop don kito ebo ebon ŋei, eŋane meteeno birakakei. Edo baŋ dongo birakau paki seukeakane ra togolekei. ");
INSERT INTO ons_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Paki, qelaŋ ŋei eŋane meteeno birakau, edo baŋ masi worik okanka more, kumunamŋo qeu paki, biriŋŋo kibeŋ qabego qeu seukeake, paki kaiwe karewe okangi, eŋe baŋ koso ma wirik kaki, wisikae wieake.” ");
INSERT INTO ons_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedi gipoletkine erane nagaetneŋo Yesu wano gipoletkine weneŋ epuki sari, umi qe ket more yeye mane wane olatke. ");
INSERT INTO ons_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Paki Yesuŋo qesonka rake, “Ge onokaka wane ganmaike?” Eŋe rake, “Ge ranom gipoletkene etke iwa, ere ge gege togon ŋei waom gekeneo, naso yewao ere geŋane won ŋono so kana ŋono mesikeik.” ");
INSERT INTO ons_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Raki Yesuŋo mainge edange, “Ŋine kine mi detlukeu paki qesonmami. Nae laseo ŋine wikile doku ŋetzoitne nekale, ea ŋire maine mi nekeik” Ere rakoik, “O, ŋere maine okangete.” ");
INSERT INTO ons_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yale raukso, Yesuŋo etane rake, “Ŋire welekakatne naŋane laseo ŋine doku ŋetzoitne baŋ nekeik, ŋo siluŋ noŋo maine mi rawe, maŋo naŋane wonno so kanano metkeik, met met ea yemo korop naŋane Maganeŋo ŋei natne eŋane biŋek maulukke.” ");
INSERT INTO ons_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Dokoine natne 10 eŋe don iwa detpi paki, tati ŋon etke erane sotene osike. ");
INSERT INTO ons_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Eso Yesu eŋe edoraki, korop eŋino sariu rake, “Ŋine detmami, kepe ware ware eŋe ŋei ŋerep waom okanonbi, eŋe eŋane bango gemami, so eŋane ŋetne kopene edo wareonbi, eŋe baneno gemami. ");
INSERT INTO ons_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Numa iwa yaline eaŋo ŋinane keu ŋino mane misuk payake. Ŋinano ŋine maneŋo suaine okaniakane detmaikeo, yemo eŋe natne ŋinane qelit mama maine okane geake, ");
INSERT INTO ons_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","so ŋinano ŋine mane eŋe lewine okaniakane detmaikeo, yemo eŋe ŋinane urata mama ŋei maine okane geake. ");
INSERT INTO ons_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ŋei Wawainane Gipoleŋo okange yale, eŋe qelitine qekeiwane mi sarike, midakaka. Ŋo eŋe oŋom qesiŋ one more, qelitene qeakane, paki gegeine qaisikka more, ŋei ŋerep korop qoleongi, koso Anutu wano zingekei wane ketke.” ");
INSERT INTO ons_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Eŋe Yeriko mat qelige ariu, ŋei ŋerep magu suaineŋo Yesu ŋadino mogare arikoi. ");
INSERT INTO ons_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ŋei de pilik etke ere numa wazaino mere, detpik Yesu eŋe mo osoetno arike, eso eŋe kieke boka rakoik, “Dawit wane qerakine suaine, ge ŋerane wetŋone borikep!” ");
INSERT INTO ons_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ŋei ŋerep magu suaine eŋe kuroŋore more, don etne midaine tik mesikeik wane rawet otkoi. Ŋo ere siluŋ suaineka manerop boka more rakoik, “Dawit wane qerakine suaine, ge ŋerane wetŋone borikep!” ");
INSERT INTO ons_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu eŋe okoraso, etora rake, “Ŋire noŋo daleo okanŋusikalane ŋutmaike?” ");
INSERT INTO ons_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ere rakoik, “Suaine, ŋere goŋo dese malotkekenane ŋotmaike!” ");
INSERT INTO ons_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Raukso, Yesuŋo erane wetine boriki, deetno make, pakiso eaka deetne lotkeki, maine potkoik, paki Yesu ŋadino mogare arikoik. ");
INSERT INTO ons_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Eŋe ari mage, Yerusalem mat osino lotke more, sari Betpage mat Oliwa Bonaga kino metke, ea lotkekoi, ea lotke more, Yesuŋo dokoine eŋane keuno ŋine etke lewine alakane arikeik wane taleotke. ");
INSERT INTO ons_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Don iwa yale etane more taleotki arikoik, “Ŋire ari more mat mane arikeik woken, ea metmaike, eso ŋire yewa dogi mane medeunerop mulapŋo lukkau okoramaike, ea esatka marat osikeik, paki siwot ore moreso, naŋano epu sarikeik. ");
INSERT INTO ons_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ŋo ŋei maneŋo ea wane don mane rayakeo, yemo ŋire iwa yale olasikeik, ‘Suaineŋo ea wane raki sarimaite’ , rauk eŋe baŋ detŋotki, esatka epu sarikeik.” ");
INSERT INTO ons_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Masi iwa yemo propetŋo don mane iwa yale rake, ea wane wele wakonge, ");
INSERT INTO ons_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zion mat welainane suaine olatpi, ukude ŋei waomŋone geŋano umaike, eŋe wetne pesekakatneŋo dogi mane wane kutnoka umaike, eŋe dogi mane wane kutno metmaike, eŋe dogi medeune mane wane kutnoka umaike.” ");
INSERT INTO ons_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Eso medewetkine ere lewine alakane ari Yesuŋo okangeik wane etange, ea wane kop okangoik. ");
INSERT INTO ons_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ere dogi so medeune epu sariuk so, eŋe takotene kutetno lamekeuso, Yesu eŋe kutno wa metke. ");
INSERT INTO ons_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pakiso, ŋei ŋerep magu suaine eŋe takotene kito qoke numao lameke arikoi, ŋo natne eŋe komu metine kitare numao tegoke arikoi, ");
INSERT INTO ons_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","paki ŋei ŋerep magu Yesu wane qomino arikoi, so ŋadino arikoi, eŋe iwa yale rau paki, oi bakom okankakoi, “Yaiyo, Dawit qerakine mawakaŋem! Eŋe Waom wane eŋetko sarimaikane, Anutuŋo mosopkakep! Bakom mawa mawa yemo weti qeliwo Anutu wane!” ");
INSERT INTO ons_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu eŋe Yerusalem mat kotino waketki ŋei ŋerep korop mat suaine ea wane kotino ukat suaine wakonge, eŋe qeson nagu more rakoi, “Ŋei iwa ma?” ");
INSERT INTO ons_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Rau ŋei ŋerep magu iwenkakoi eŋe edane rakoi, “Iwamo propet Yesu, Nazaret matko Galili kepeoŋine.” ");
INSERT INTO ons_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu eŋe Bakom Urum koto wake, paki ŋeiwa aboŋ so osom qole qole, so amanagu qenagu okangoi, ea esop ongi qeinat ketkoi, paki eŋe wesi zakeo more mainge ebon okangoi, eŋane zake, so naŋi zonom eŋane met metene eao metpi qole nagukoi, ea kito surubaŋgi giŋ qiririŋ arike. ");
INSERT INTO ons_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Paki edane rake, “Anutu wane papiao Anutuŋo iwa yale raki qekoi, ‘Naŋane urum yemo meŋe meŋen urum orakei. (orau okangep)’ Ŋo ŋine yemo okanbi kobu mama eŋane siu siuk kise okanmaike! (mau wakongep)” ");
INSERT INTO ons_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pakiso, Yesu eŋe yewa metki ŋei depilik so kie wawetene qoi qoine eŋano sariu, ma menaŋonge. ");
INSERT INTO ons_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pris ŋetne so ra rokop don kito ebon ebon ŋei eŋe Yesuŋo urata mayakakatne ea maki kakoi, so medep nigatne edo Bakom Urum koto boka bakom kito rakoi, “Yaiyo Dawit wane qerakine!” Ea wane eŋe dere worik okankakoi. ");
INSERT INTO ons_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Pakiso eŋe Yesu olale rakoi, “Ge eŋe don ramami, ea detmaine?” Rauso, Yesuŋo rake, “O, na detmaile, ŋine Anutu wane papiao don iwa yale pamaike, ea mi dapore det okanmami me? ‘Ge medep nigatne so medep abubu eŋe ma ewek onmaine, bakom koboboine kitokei wane.’” ");
INSERT INTO ons_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesuŋo Eŋe Qeliŋoneso, Mat Suainoŋine Ari Betani Lotkeki, Ruo Kereki, Ea Pake. ");
INSERT INTO ons_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Qaeki sakoka eŋe koso zinge numaine ari mat suaine lotke more, Yesu ŋarainane seukke. ");
INSERT INTO ons_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Paki, eŋe kaki pik eki mane wele midadaine metineŋoka weku metke, eso eŋe eki ea olale rake, “Ge baŋ koso weleŋone manerop mi qekene!” Rakiso, eaka pik eki ea seuke toroge more marapkeke. ");
INSERT INTO ons_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Dokoine eŋe ea kau paki, qisekoi, so welelepke more qesone rakoi, “Eki ea daleo okane ikopka seuke marapkemaike?” ");
INSERT INTO ons_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Rau Yesuŋo kito edange, “Na welekatne ŋidanbe detpi! Ŋine wet etkeka mi okane more, mali malip korop gekeiwo, yemo ŋine wet etke mi okanikei, paki na pik eki iwa wane okanmaile yale, ŋine maine eweke more, baŋ masi togole okanikei, so ea fik waneka weku mida, ŋine maine baŋ eweke more, bonaga iwa wane yaleka olale rakei, ‘Ge wienom paki, goŋomka ari kiwetko ketnom,’ rau eŋe kine kine ea eŋe baŋ maine okaniake. ");
INSERT INTO ons_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ŋine malipka gekeiwo yemo, yeye kine kine mane wane rau paki meŋe meŋengo more qesonkau paki, ŋine wele baŋ maratkakei.” ");
INSERT INTO ons_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu eŋe koso Bakom Urumgo zinge sari miti don kito edane metki, pris ŋetne so Yuda ŋei suaine eŋe Yesu wano sari qesonka rakoi, “Ge kine kine iwa okan okanmaine, eamo zonom so dereret kine kine suaine yewa maŋano ŋine makone, so ge makenane, maŋane don wane okan okanmaine? Maŋo iwa ra ginge?” ");
INSERT INTO ons_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Rau Yesuŋo mainge edange, “Na baŋ qeso qeson mide weku qesonŋunbe, eso ŋine wele mainge nolasikeiwo yemo, na baŋ maŋane don wane masi kine kine iwa mamaile, ea ŋidanikale. ");
INSERT INTO ons_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohane doku tau tau urataine ea diao ŋine sarike, ea eŋe qeliwo Anutu wanoŋine sarike, me kepeo ŋei eŋano ŋine sarike?” Eŋe kieke edomka auye kitoqok okane rakoi, “Ŋene don diawa raikene? Ŋene olale rakene, ‘Anutu wano ŋine sarike’ , yale raikeneo, eŋe baŋ ŋedane rayake, ‘Pakimo ŋine onoka wane Yohane wane don mi malipkakoi?’ ");
INSERT INTO ons_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ŋo ŋene raikene, ‘Ŋei eŋanoŋine sarike,’ yale raikeneo yemo, ŋene kaetŋonmaike, ŋei ŋerep eŋe daleo okanikei, onoka wane eŋe koropŋo Yohane wane ramami, eŋe propet.” ");
INSERT INTO ons_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Eso eŋe yale rau pakiso, eŋe Yesu wane don mainge olale rakoi, “Ŋene mi detmaine.” Pakiso Yesu eŋe edane rake, “Na yale waka, maŋane don wane urata kine kine iwa mamaile, ea mi ŋidangale.” ");
INSERT INTO ons_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu pris wawaine ŋetne suaine so ŋei eŋane ware warekopene edange, “Ŋine donkisi iwa wane daleo wetkemami? Baŋ kine nolatpi desikale. Ŋei mane geke, eŋe medewetkine etke gekoik, magaetne eŋe ari gipole suaine olale rake, ‘Gipon, ge ukude ari wain euo urata makene.’ ");
INSERT INTO ons_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Eŋe olale rake, ‘Na baune wamaike,’ ŋo siluŋ eŋe koso wetne maingeki paki, wain euo arike. ");
INSERT INTO ons_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pakiso, magaine eŋe koso gipole mane wano ariki paki don wekuka olatke, pakiso eŋe rake, ‘O maine, suainene,’ ŋo siluŋ eŋe mi arike. ");
INSERT INTO ons_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Medep etke iwa erane keuo ŋine diawaŋo magaineŋo urata mayakane wetkeke, ea maine okange?” Eŋe rakoi, “Medep suaine oŋo!” Rauso, Yesuŋo edane rake, “Na iwa ŋidanbe detpi! Ŋei takis mama so borikine mama so bailalaŋ ŋerep eŋe Anutu wane qeli gege togon so qeli ewe zonom kotino alakane waketpi, ŋine ŋadine okangei. ");
INSERT INTO ons_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Onoka wane Yohane Doku Tau Tau eŋe ŋinano sariki paki, numa koboboine makei wane sikanŋunge, eso ŋine done dere mi malipkakoi, ŋo siluŋ ŋei takis mama so bailalaŋ ŋerep edo yemo done dere malip kakoi, ŋine iwa mo kakoi, ŋo wetŋine mane mi maingeu paki, ŋado eŋe mi malipkakoi.” ");
INSERT INTO ons_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesuŋo koso ŋei suaine kito edane rake, “Na don naŋengo mane koso iwa rawe detpi, ŋei mane eŋe kepeine suaine eao wain waetne ebot wareki paki, ŋadino sen qeare lolike make. Paki lom mane wain kizakaniakane ma more, diam metmet mat mane bakine kiroine make. Pakiso, wain eu yewa ŋei natne edo warekei wane eŋane meteeno more so, mat qelige numa arike. ");
INSERT INTO ons_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ŋado wain wele menaŋgi makeiwane naso bomile sariki, eu welaine eŋe qelit ŋeikoune raongi wain eu ware ware eŋano arikoi, wele natne eŋe eŋine ma mangei wane. ");
INSERT INTO ons_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ŋo wain urata ware ware ŋei eŋe qelit ŋeikoune ebu more, mane punpun dimekoi, mane qeu seukke, eso mane wesiŋo qekoi. ");
INSERT INTO ons_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ŋei eŋe koso qelit ŋeikoune natne alakan biraongi arikoi, eŋane rokop mida, yemo zok manerop biraongi arikoi, paki ŋei wain eu ware ware eŋe alakan okan ongoi, rokop yewaka koso okangoi. ");
INSERT INTO ons_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ŋado bisop, ea yemo eŋine gipole ea eŋano birakaki ketke, paki rake, ‘Welekatne eŋe baŋ nae medepne ea wane ewine kitokei.’ ");
INSERT INTO ons_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ŋo siluŋ wain eu ware ware eŋe eŋine gipole kau paki, edomka auye rakoi, ‘Iwa eŋe wain ea welainane gipole, sariu, ŋene eŋe qeŋem seukkep, paki, ŋene baŋ wain euine ea ŋenze maŋem!’ ");
INSERT INTO ons_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eso eŋe yale rau pakiso, kito pok masatka more wain euo ŋine ma birakau qeinat waketki, qe kito ma ari mage, qebirau seuke pake.” ");
INSERT INTO ons_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesuŋo qesone rake, “Ŋine daleo ramami, yekuat namo wain eu wane welaine, eŋe sariki paki, eu ware ware ea eŋe baŋ daleo okan oniake?” ");
INSERT INTO ons_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Eŋe mainge rakoi, “Eŋe ŋei borikine ea, baŋ engu matali ongi seukei, paki wain eu ea baŋ omakone more, ware ware natne ebongi, edo wareka geu wele menageake, naso eao eŋe baŋ wele ma more welaine eŋine mangei.” ");
INSERT INTO ons_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesuŋo takotke koso edane rake, “Ŋine Anutu wane papiao don iwa yale kito edane ramaike, ea mi mane det okanmami? ‘Wesi ea mat mama ŋei eŋe waluke qeliŋgoi, eaŋo zinge more wesi wele okange, paki eaŋo mat wane solaine ma togoleki okoramaike, Waomŋo maki kine kine iwa wakonmaike, paki ŋene kaŋem masi weku mane okanmaike!’ ");
INSERT INTO ons_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu eŋe takotke rake, “Eso ea wane na rawe detpi, Anutu wane qeli gege togon eamo, ŋinano ŋine ŋibuma more, ŋei natne baŋ ebongi edo maine urataine mau wele maine wakoniake. ");
INSERT INTO ons_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ŋei mane eŋe wesi ea wane kutno ra soroke ket kito more, baŋ din bun wiri izi muzuŋ kitoyake, so wesi eaŋo ŋei mane wane kutno ket kitomaikeo, yemo ŋei yewa kito pelekki baŋ qentake more lube lube okaniake.” ");
INSERT INTO ons_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pris ŋetne so Parisi eŋe Yesuŋo don naŋen beŋen rake, yewa detpi paki wetkeu, eŋane ramaike, yale okange. ");
INSERT INTO ons_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eso eŋe ma lukkakeiwane okangoi, ŋo siluŋ eŋe ŋei ŋerep magu eŋane kaetonge, edo Yesu wane propet ramaŋkoi, ea wane qeliŋkakoi. ");
INSERT INTO ons_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu eŋe koso manerop ŋei ŋerep don naŋengo more edane rake, ");
INSERT INTO ons_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Qeli gege togon wakesikei wane, yemo ŋei waom maneŋo gipole zokit mayakane ŋara soep maulukke newanonge, ea wane rokop. ");
INSERT INTO ons_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Eŋe qelit medewekoune taleongi ari, ŋei ŋerep newan onge, ea edangoi sari ŋara soep nekeiwane, ŋo eŋe siluŋ sarikei wane mi onge. ");
INSERT INTO ons_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Eso eŋe qelit medewekoune natne don iwa yale edane more taleonge, ‘Ŋei ŋerep newanonile eŋe edanbi, “Naŋane ŋara soep mo mauluke mot waremaile, naŋane bulamakau stia so bulamakau medeune kelokine suaine loutne, mo weneŋ engu kitare motmaile, so yeye kine kine korop mo mauluke motware maile, zokit mama wane ŋara soepko sariu!” ’ ");
INSERT INTO ons_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ŋo ŋei ŋerep newanonge, eŋe siluŋ don ea desikei wane bauene waki, urataeno urataeno ariwarekoi, mane eŋe bulamakau urataino arike, mane eŋe mere euino arike, ");
INSERT INTO ons_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ŋo natne eŋe qelit medep ea malipone more morapŋo dimeongoi, paki enguwi seukwarekoi. ");
INSERT INTO ons_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yale okanbi, ŋei waom eŋe zok sotine osike, paki eŋe kawali ŋeikoune taleongi, eŋe ari ŋeiwa enguwi seukkoi, ea engu wareu paki, matene suaine ea gerepŋo kiwakeu zewareke. ");
INSERT INTO ons_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pakiso, eŋe koso qelit medewekoune edoraki sariu edane rake, ‘Naŋane zokit mama wane ŋara soepne mo mauluke mot waremaile, ŋo siluŋ ŋei ŋereppa newan onile, eŋe ea nekei wane mi onmaike. ");
INSERT INTO ons_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ea wane, iwa yemo numa suaino ariu paki, ŋei ŋerep loutne maratongei, rokop newan onbi zokit mama wane ŋara soep pamaike, iwao sari newarekei.’ ");
INSERT INTO ons_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Eso qelit medep eŋe mo ea numa suaine pa arike, rokop arikoi paki, ŋei ŋerep korop marat ongoi, rokop ebuwi sarikoi, ŋei ŋerep maine so borikine rokop wekuka, pakiso zokit mama urum suaine ea ŋei ŋerep edo qe watke metkoi. ");
INSERT INTO ons_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ŋei waom eŋe ari ŋei ŋerep newanongi sarikoi ea onge, paki eŋe ŋei mane kaki zokit mama wane takot laplapŋo mi auki paki sari metke, ");
INSERT INTO ons_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","paki, ŋei waomŋo kaki paki, qesonka rake, ‘Kima, ge daleo wane zokit mama wane takot laplapŋo mi aunom paki saket iwa metmaine?’ Ŋo ŋei ea eŋe don mane mi rake. ");
INSERT INTO ons_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pakiso, ŋei waomŋo qelit medewekoune edane rake, ‘Ŋine wokomkau, kine so metine weneŋ paki ma birakau, qeinat solaino panaman kotino ketkep, yewao eŋe baŋ aroke, ŋet warik warik ki geake.’” ");
INSERT INTO ons_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pakiso, Yesu eŋe girem don iwa yale raki qoeke, “Ŋine mo detmami, Waom eŋe ŋei ŋerep loutne newanonge, ŋo siluŋ ewekinemdeŋoka sari ma wakon onge.” ");
INSERT INTO ons_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisi eŋe arikoi paki, Yesu qeso qesonŋo liwek kaikei wane don ra pisekoi. ");
INSERT INTO ons_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pakiso, eŋe dokoene natne so ŋei waom Herot wane magu ea ŋine ŋei natne taleonbi, Yesu wano ari qesonka more olale rakoi, “Kito ŋebo ŋebon, ŋene detmaine, ge don welekatneka ra okanmaine, ge don wele Anutuŋo ŋei ŋerep eŋane wetineŋo okankake, ea wane ŋei ŋerep kito edan okanmaine, ge ŋei ŋerep eŋane wane zok mi kaetgan okanmaike, me ea wane dere mezet mi okan okanmaine, onoka wane ge ŋei mane ŋetne suaine eŋet biŋek korop me ketkele eŋet biŋek midaine, eŋe rokop wekuka okan onmaine. ");
INSERT INTO ons_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ea wane ge ŋedannom, ge daleo wetkemaine? Ea ŋenze ra rokop don yuanka more, Roma Ŋei Waom Suaine, eŋetine Sisa, takis man okanmaine, me mida?” ");
INSERT INTO ons_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu eŋe isi donenane kine dere more rake, “Ŋine isiŋei nau! Ŋine onoka wane donŋo suba more isinanmami? ");
INSERT INTO ons_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ŋine takis mosikei wane wesi ea sikannanbi kawe!” Rakiso, eŋe wesi mane masariu kake. ");
INSERT INTO ons_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Paki qesonone rake, “Oŋa oŋa iwa maŋane kaitine so eŋetineŋo okoramaike?” ");
INSERT INTO ons_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Eŋe rakoi, “Ŋei Waom Suaine, Sisa wane.” Rau Yesuŋo edange, “Ea maine, ŋine kine kine Sisa wane biŋek, ea eŋe maine Sisa manikei, ŋo Anutu wane biŋek, ea eŋe maine Anutu manikei.” ");
INSERT INTO ons_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Eŋe don iwa detpi paki, oŋaene qaeke, pakiso eŋe qeliŋka arikoi. ");
INSERT INTO ons_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kaiwe weku yewaoka, Sadusi natne Yesu wane sarikoi. Ŋei magu yewa eŋe yale ra okangoi, ŋei seuseune eŋe koso mi wisikae wiekei. Ea wane kine eŋe Yesu liwekau paki, qesonka more iwa yale rakoi, ");
INSERT INTO ons_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Kito ŋebo ŋebon, sogino Moseŋo don mane iwa yale kito edange, ‘Ŋei mane eŋe medewekoune midaine ge more seukeakeo, ŋanomine eŋe yeka geki, ŋoleŋo tatinane malaine ea maki paki, ŋei seukke eŋane ra more medewekopetne qepokki wakonikei.’ ");
INSERT INTO ons_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tatiŋon sewen (7) yale iwa gekoi, tatene suaine eŋe ŋerep make paki, medewekoune mane mi qepokki wakonbi, yaup ge more, seukke, eso eŋe malaine ea qeliŋkaki gekimo, ŋone kebaŋineŋo make. ");
INSERT INTO ons_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ŋole kebaŋine eŋe yaleka medewekoune mane mi qepoke more, yaupka geki paki, seukke, ŋole ŋorikine eŋe yalewaka tanik wekuka okange. Tatiŋon sewen (7) eŋe korop ŋerep wekuka maso, seukokan warekoi, ŋo medewekopene mane mi qepokeu wakongoi. ");
INSERT INTO ons_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pakiso ŋado bisoppa eamo ŋereppa ea seukke, ");
INSERT INTO ons_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","wane baŋ naso suaino, ŋei seu seune wisikae wiekei yewao, ŋerep yewa eŋe maŋane ŋanomine okaniake? Eŋe koropŋo ŋerep weku yewaka makoi.” ");
INSERT INTO ons_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesuŋo mainge edane rake, “Ŋine don matalimami! Yemo onoka wane ŋine Anutu wane papiao don pamaike, ea mi detlukmami, me Anutu wane zonom ea ŋaŋaekamami, ea wane ŋine don matali ramami. ");
INSERT INTO ons_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ŋei seu seune eŋe wisikae wiekei, naso yewao, eŋe baŋ aŋelo qeliwo gemami yale gekei, paki ŋei so ŋerep eŋe ŋao ŋanom mi okane gekei, i midakaka! ");
INSERT INTO ons_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ŋo ŋei seu seuneŋo wisikae wie gege, don ea wane na qeson ŋunmaile, ŋine Anutuŋo don ŋidange, ea mane mi detlukkakoi me? Eŋe iwa yale rake, ");
INSERT INTO ons_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Na Abraham wane Anutu, Isak wane Anutu, so Yakop wane Anutu.’ Ea wane kine yemo yale, eŋe ŋei seu seune eŋane Anutu midakaka, eŋe ŋei wisikap gemami, eŋane Anutu. Abraham, Isak so Yakop mo seukoi, eŋane Anutu, ŋo eŋane ra more wisikae wiekei wane okanmami, wetkemaike.” ");
INSERT INTO ons_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ŋei ŋerep magu eŋe don iwa detpi, ewe bibiinerop okangi, oŋaene qaeke. ");
INSERT INTO ons_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Parisi eŋe detpi, Yesu wane donŋo Sadusi ŋei eŋane don rara wane aŋaene ma wongeki, eŋe wekuoka sari qeturaŋgoi, ");
INSERT INTO ons_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Paki eŋano ŋine mane eŋe ra rokop don kito ebon ebon, oŋo Yesu liwekka more iwa yale qesonka rake, ");
INSERT INTO ons_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kito ŋebo ŋebon, ra rokop don suaine diawaŋo ra rokop don wane numa natne, eao korop yuanone more, oŋo zok manerop rokop wawaine okane pamaike?” ");
INSERT INTO ons_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesuŋo iwa yale olale rake, “Yemo iwa yaleŋo ra rokop don suaine okanmaike, ‘Ŋine Anutu wane siminŋuniake, oŋo yemo suaineze, ŋine wet dereret sola so asu oŋa oŋaŋine so mali malipŋine, ea koropka Waomŋine Anutu wet maep okankaikei.’ ");
INSERT INTO ons_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yewaŋo ra rokop don suaine so wele okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","So naba tu ra rokop don mane wele okanmaike, eŋe yalineka, yemo iwa yale, ‘Ge geŋonane ganmaike, kop yalewaka ŋei kimakopŋone eŋane okanganiake’ ");
INSERT INTO ons_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mose wane Numa korop, so propet eŋane don yemo, ra rokop don etke iwa eto kine qepotkemamik.” ");
INSERT INTO ons_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi eŋe wanok nagu sari wekuoka qeturage metpi, Yesuŋo qeson one rake, ");
INSERT INTO ons_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ŋine Mesia Anutuŋo birakayake, ea wane daleo wetkemami? Eŋe maŋane qerakine?” Raki eŋe olale rakoi, “Eŋe Dawit wane qerakine.” ");
INSERT INTO ons_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Rauso, Yesuŋo qesonone rake, “Pakimo, onoka wane Asuŋo Dawit wetino motki, ‘Waom’ orake? Onoka wane Dawitŋo raki qekoi, ");
INSERT INTO ons_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Magak Waomŋo naŋane Waom Mesia olale rake, “Ge iwa naŋane wonno zonom gorop met magenom, na geŋane ŋabakopŋone kieŋonane bango bira onikale.” ");
INSERT INTO ons_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dawit eŋe Mesia wane ra more, ‘naŋane Waom’ orakeo, yemo ŋine daleo Mesai eŋe Dawit wane ŋaboine, ŋeika rau rap? Ea mi kopkeke!” ");
INSERT INTO ons_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Raki detpi, ŋei maneŋo eweke more, Yesu wane don turuŋine weku mane mi mainge olatkoi, pakiso kaiwe ea ŋine kieke, ŋei maneŋo Yesu qesonka qesonka eamo ŋado mi okangoi. ");
INSERT INTO ons_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pakiso, Yesuŋo ŋei ŋerep magu so dokoine edane rake, ");
INSERT INTO ons_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ra rokop don kito ebo ebon so Parisi eŋe Mose wane met metko mere, ra rokop don so numa wane kine mainge okanmami. ");
INSERT INTO ons_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Eso, ea wane eŋe yeye kine kine mane makei wane ŋidanbi ŋine aŋaene teweke makei, ŋo enŋene gege mageene, eamo misuk mogaton okangei, onoka wane eŋe don ra okanmami, ea edom mi magare okanmami. ");
INSERT INTO ons_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eŋe Anutu wane ra rokop don ea eŋane don takotke ratogoleu paki, so aboŋ umatne ea, nagonge mawa ŋei ŋerep eŋane romonene kutno more makatakeu met okanmaike, ŋo edom yemo mane mi ewekeu paki meteene bira more umat ea qesiŋone more tewekokanmami. ");
INSERT INTO ons_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yeye kine kine korop ma okanmami yemo, ŋei ŋerep edo deŋoka onikei wane okan okanmami, kau, eŋe Anutu Wane papiao don kebaŋine kebaŋine pamaike, ea laseine suaine eao qewatke ware mawa, meeno so kabirimeno ŋamot yale mau, wa met okanmaike, paki, kaulukkei, takotene kiroine ea wane mezeno kibi kine kine kiroine mau paki mage okanmami, ŋei ŋerep edo kau paki, eweene kitokei waneka. ");
INSERT INTO ons_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","So eŋe met met maine eaoka, epa kebu ma nene naso eao, so Yuda lewa lewaŋ urumgo mesikei wane, zok simileon okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Eŋe nalu qole nagu okanmami, ea wane sobeŋino eweene kitou paki kaiwe maine edanikeiwane, so ŋei ŋerep edo ‘Kito ŋebo ŋebon’ , yale edorakei wane, simileene zok pa ebonmaike. ");
INSERT INTO ons_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Naŋane dokone ŋine yemo, ‘Kito ŋebo ŋebon,’ ŋidorakei wane misuk wetkeki so rakei, onoka wane, ŋine kima kimaŋoka korop kima okannagu gemami, so kito ŋibo ŋibon ŋine wekuku gemaike, yemo nae, ea wane yale okangei. ");
INSERT INTO ons_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","So ŋine, nae dokone, iwa kepeo ŋei mane ‘Magak’ misuk orakei, onoka wane ŋine Magaŋine weku mo qeliwo gemaike. ");
INSERT INTO ons_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Me ‘Ŋetne mama’ ŋidorakei wane misuk rakei, onoka wane ŋinane wekuku ŋetne mamaŋine gemaike, yemo Mesia, Anutuŋo birakaki ketke. ");
INSERT INTO ons_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ŋinane keuo ŋine suaine mane geake, eŋe ŋinane qelit mama geake. ");
INSERT INTO ons_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mane eŋe oŋomka suaine ma wanaguki, eŋe baŋ Anutuŋo maket birakayake, so mane eŋe oŋomka maket bira naguki, eŋe baŋ Anutuŋo mawa suaine birakayake. ");
INSERT INTO ons_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Yai, ra rokop don kito ebo ebon, so Parisi, ŋine kaulukkei! Ŋine isi ŋei nau! Ŋine qeli gege togon wake waket wane madetine ŋei ŋerep eŋane kaiteno kito wonge okanmami, ŋo siluŋ ŋine ŋidom baŋ mi wakesikei, so ŋine ŋei ŋerep natne eŋe wakesikeiwane okanbi, ŋine rawet onbi mi waket okanmami! ");
INSERT INTO ons_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yai, ra rokop don kito ebo ebon so Parisi ŋine kaulukkei! Ŋine isi ŋei nau! Ŋine kosi mala eŋane kat matene isi one more kobu omakon okanmami, paki meŋe meŋen kiroroine meŋenkau paki, sotŋine ea kawetke okanmami, onoka wane ŋine yale okan okanmami, ea wane turuŋine yemo baŋ wikile qotkokoine maratkaikei! ");
INSERT INTO ons_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Yai, ra rokop don kito ebo ebon so Parisi ŋine kaulukkei! Ŋine isi ŋei nau! Ŋine sekiwoka kiwet kitare ariu paki, lobo kepe lolike ari more ŋeimde weku mau wetne maingemaike. Wetne maingekiwo ŋine mau ŋinŋino takotkeki paki, eŋe manerop ŋinŋinerop sora gerep wane biŋek okangei! ");
INSERT INTO ons_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Yai, numa alakan deŋine pilik pilikine, ŋine kaulukkei! Ŋine iwa yale edan okanmami, ‘Ŋei mane eŋe Bakom Urumgo mode more ra togoleakeo, yemo wele midaine, ŋo eŋe Bakom Urum koto wesi aboŋŋo mamaine metmaike, ea modeki paki, ra togoleakeo, eaŋo yemo maine wele.’ ");
INSERT INTO ons_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ŋine de pilik, so qelaŋ qeliŋine nau! Diawaŋo manerop Anutu wane deo wele okanmaike? Wesi aboŋ Bakom Urumgo metmaike ea wele me? Anutu wane Bakom Urum suaine, eaŋo wele? Ŋine mo detmami, Anutu wane Bakom Urum kotino wesi aboŋ metmaike, yewa yemo Anutu wane yaup kine kine yauwine okanmaike! ");
INSERT INTO ons_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","So ŋine yaleka iwa yale weneŋ ra edan okanmami, ‘Ŋei mane eŋe aratao modeki paki ra togoleakeo, yemo wele midaine okaniake, ŋo mane eŋe arata kutno soe soep pamaike, eao modeki paki ratogoleakeo, yemo eŋe ramaike, yale okaniake.’ ");
INSERT INTO ons_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ŋine deŋine pilik pilikine! Diawaŋo Anutu wane kaitko me deino wele okanmaike? Soe soep eaŋo wele me? Me arataŋo wele? Ŋine mo detmami, nene kine kine me soe soep aratao metmaike, yewaŋoka maki soe soep ea Anutu wane biŋek okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Eso, ea wane ŋei mane eŋe aratao mode more ra togoleake, eŋe donine ma togole more arata weneŋ ra togolekaki paki, kutno soe soep bakom pamaike ea, weneŋ korop ra togolewaremaike. ");
INSERT INTO ons_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","So ŋei mane eŋe Anutu wane Bakom Urumgo modeki paki ra togoleake, eŋe donine ea Anutu wane Bakom Urumgo ra togoleki paki, so eŋe Bakom Urumgo welaine gemaike, Anutu weneŋ ra togoleake. ");
INSERT INTO ons_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","So ŋei mane eŋe qeliwo modeki paki ratogoleake, yemo eŋe Anutu wane metmet, so metmet ea wane kutno metmaike, eŋane weneŋ ra togoleake. ");
INSERT INTO ons_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Yai, ra rokop don kito ebo ebon so Parisi ŋine kaulukkei! Ŋine isi ŋei nau, aŋaŋine etke! Ŋine euo ŋine si zaguk yauwine, arerewa, so izaŋ saiyok kine kine eu wane aboŋ eamo ŋine mapokeu paki, 10 magu mane Anutu wane biŋek met okanmami, ŋo ŋine Anutu wane ra rokop don nat paromine kakapa suaine mane, ea mo yeine qeliŋ waremami, yewa mo numa wele, ra makoboe one, mauluk qeuluk, so mali malip eamo qeligeu, yeine ket okanmaike. Ŋine iwa koropka siluŋ togole zonom gorop ra rokop don suaine pamaike, ea maine mogat warekei, so ra rokop don natne pamaike, ea eŋe yale waka misuk qeliŋgei. ");
INSERT INTO ons_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Numa alakan deŋine pilik pilikine! Ŋine zeŋet so sip kine kine nigatnemde, eamo surok ŋino ŋine ma birau yeine ari okanmaike, ŋo ŋine kamel osom suaine, surokŋine koto, eamo mi ka more, ŋine yewarop siluŋ weneŋ qotkeu, kotoŋino ket okanmaike! ");
INSERT INTO ons_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Yai, ra rokop don kito ebo ebon so Parisi ŋine kaulukkei! Ŋine isi ŋei nau! Ŋine laseŋine so pletŋine solaineka sauk okanmami, ŋo kotine yemo kobu mama wane tanik manik so sola ŋinane simile mogare gege, eaŋo qewatkeu watke pa waremaike. ");
INSERT INTO ons_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parisi, ŋine deŋine pilik pilikine! Lase kotino onokakaŋo metmaike, ea alakane saukeu qoeki, ŋado solaine ea baŋ yaleka libe qeake! ");
INSERT INTO ons_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Yai, ra rokop don kito ebo ebon so Parisi ŋine kaulukkei! Ŋine aŋa ŋine etke isi ŋei nau! Ŋine deŋesere solaino yemo touk so si zikotne kito mauluk okan mageu dun dun paki kamami yale, ŋo kotino yemo ŋei seu seunane setne so kine kine gotototneŋo watke pamaike. ");
INSERT INTO ons_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Rokop weku yewaka ŋine solaŋineŋo yemo ŋei ŋerep eŋane kaitko wakonbi maine ŋunmami, ŋo kotoŋino yemo isi so ra rokop don qepapka qepapka borikineŋo ea ŋo watke pamaike. ");
INSERT INTO ons_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Yai, ra rokop don Kito ebo ebon so Parisi ŋine kaulukkei! Ŋine aŋaŋine etke, isi ŋei nau! Ŋine propet eŋane deŋesere matene maulukei paki, maine mamami, so ŋine ŋei dereret korop eŋane deŋesere ea maine mau kibi maepinerop okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Paki iwa yale ra okanmami, ‘Ŋene aso ŋabokopze gekoi, naso yewao mokaka gekone ra, yemo ŋene eŋe okangoi, yale mi okanŋem rap, paki propet mane me enguŋem rap.’ ");
INSERT INTO ons_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Eso ŋine welekatne ra wakone ramami, ŋeiwa mo sogino propet enguwi seukkoi, eŋane ŋosa wili wiliene, eamo ŋine iwa! ");
INSERT INTO ons_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ea wane ŋine aso ŋabokopŋine sot takotki takot kutno kutno kieke okane sari gekoi, yale waka okane arimageu qoeake! ");
INSERT INTO ons_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ŋine koma suabit nau, so koma ea wane gipolekoune! Ŋine sotŋinane turuŋine sora gerepko kesikei wane, naso bomileki diawao ari siukwarekei? Ea mo numa mane mida! ");
INSERT INTO ons_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Eso ea wane na rawe detpi, na baŋ ŋinano propet so ŋei dereret korop, so kito ŋibo ŋibon taleonbe sarikei, ŋine eŋanoŋine natne baŋ enguwi seukkei, natne kibeŋ qabego engukei, so natne lewa lewaŋ urum ŋino kumanamŋo enguwi paki esop onbi, mat suaine maneo ŋine mat maneo yale ari okanikei. ");
INSERT INTO ons_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ŋei sotene midaine engukoi, eŋane turuŋene yemo baŋ ŋinane kutino wa payake. Abel sotine midaine eŋano ŋine kieke kawali qe sari mage Zekaraia, eŋe Barakia wane gipole, Bakom Urum so arata keuetno qekoi. ");
INSERT INTO ons_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na ŋidanbe detpi, so ea wane turuŋine kakarauk, yemo baŋ ŋei ea gekoi, ŋinano wakon wareake! ");
INSERT INTO ons_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalem welaine, Yerusalem welaine! Ge propet enguwi seukeu, Anutu wane qelit ŋei wesiŋo kito pelek onmaine, Anutuŋo geŋano taleongi sariu! Naso baŋem naso baŋem tiakŋo medewekoune woworap one more qingimineŋo maputulake korauton okanmaike, yale noŋo geŋane ŋei ŋerep magukopŋone meteneŋo koraut ongalane okangole, ŋo ŋine siluŋ mi qeliŋgeu, koraut ongole! ");
INSERT INTO ons_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","So detlukkei, ea wane mat urum ŋine yemo baŋ komu komune qeliŋkawe bori more, waru qetusiake. ");
INSERT INTO ons_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na welekatne iwa yale rawe detpi, ŋine koso na manerop baŋ mi nane more, ge ari mage baŋ naŋane kine kauluke more raikei, ‘Ŋei yewa eŋe Waom wane eŋetko sariake, Anutuŋo eŋe maulukka more mosopkakep,’ yale rau paki, naso yewao nanikei, so kine kine menageake.” ");
INSERT INTO ons_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu eŋe Bakom Urumgo ŋine qelige ket ariki, dokoine eŋe eŋano ari more Bakom Urum wane mat ea sikankakoi. ");
INSERT INTO ons_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Paki eŋe done iwa mainge edane rake, “Maine, ŋine mat so yeye kine kine iwa korop maine metki kawaremami, me? Ea wane na iwa welekatne ŋidanbe, wesi iwa mane qelingeu met metino mi mesiake, eŋe baŋ din bun kito pororoke man gili gala qakeu korop kesiake.” ");
INSERT INTO ons_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu eŋe Oliwa Bonagao metki, dokoine eŋe enŋeneka sariu paki, bonepko mere olale rakoi, “Ge ŋedannom detŋem, kine kine iwa korop ea baŋ dango wakoniake, so masi tanik daleo wakone paki ge sari lotkekene so, kepe nasoine qoeake?” ");
INSERT INTO ons_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yale rau, Yesuŋo edange, “Diam seleleine makei, paki ŋei natne misuk detonbi wet masiuk okan ŋunikei. ");
INSERT INTO ons_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Onoka wane ŋei loutne eŋe baŋ sariu paki, naŋane eŋetne nora rakei, ‘Na Kristo!’ yale rau paki, ŋei ŋerep loutne baŋ wetene masiuk warekei. ");
INSERT INTO ons_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ŋine kawali wane ukatne ososop sariki desikei, so kawali wane don kisiineŋo yemo eri abaran sariake, ŋo siluŋ iwa yale detpi, ŋine misuk qisekei, masi kine kine yaline yemo yaup qeqe ruruineka wakoniake, ŋo eŋe kepe nasoine qoeakane, ea mi wakoniake. ");
INSERT INTO ons_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kepe baŋem kepe baŋem ŋei eŋe edomka ŋaba nagu yaku aito okanikei, ŋei waom mane wane dokoine eŋe, ŋei waom mane wane dokoine eŋerop yaku ŋaba nagu okanikei. Yewao baŋ bodi suaine natne wakone paki, memeaŋo kepe baŋem korop rokopke ari ma sari ma okaniake. ");
INSERT INTO ons_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Masi Kine kine ea korop, yemo ŋerep maneŋo medep mikepka mayakane gae maki wikile detmaike, ea wane rokop ikopka wakoniake. ");
INSERT INTO ons_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Pakimo ŋine baŋ ŋibu lukŋune more, waraŋŋune ari biraŋunbi wikile ŋibongei, so ŋinguwi seukkei, kepe baŋem ŋei ŋerep korop eŋe baŋ naŋane rau paki ŋabaŋune qaisik ŋungei. ");
INSERT INTO ons_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Naso yewao, ŋei ŋerep loutne eŋe mali malipene korop qeliŋ warekei, eŋe baŋ edomka qom kipok okan nagu more ŋaba nagukei. ");
INSERT INTO ons_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yale okane geu, propet isisine loutne wakone more, ŋei ŋerep loutne wet masiuk okanongei. ");
INSERT INTO ons_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Masi yaline okanbi borikineŋo baŋ korop sua ariki, ŋei ŋerep korop eŋe wet maepene baŋ qelige kima kima mi okan nagukei. ");
INSERT INTO ons_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ŋo ŋine togogole more malipka okoramageu naso qoeake, ŋine baŋ koso Anutuŋo qesiŋongi gege togon maikei. ");
INSERT INTO ons_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","So qeli gege togon don iwaŋo baŋ kepe baŋem korop ra qelaŋanbi, ŋei ŋerep korop eŋe detwareu mo, kepe wane naso baŋ qoeake.” ");
INSERT INTO ons_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ŋine baŋ kine mane mado madoŋine borikine matali qetaliinerop, ea kakei, mokaka sogino propet Danielŋo rake, ea Urum Kobekine kuneŋine eao okorayake.” (Daporapot ŋeine, ge bororom dapore kine daleo pamaike, ea detlukaikene!) ");
INSERT INTO ons_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Pakiso, ŋei ŋerep Yudia kepeo gekei, eŋe wie more kaet bonagao arikei. ");
INSERT INTO ons_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ŋei mane matinane bakine kutno okorayake, eŋe zinge ket mat koto wa aboŋ kine kineine misuk mayake, wane kawali yuankayake. ");
INSERT INTO ons_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ŋei mane euo geakeo ŋine zinge matko ari takotine mi mayake eŋe yeine qelige kakaka ariake! ");
INSERT INTO ons_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Yai, naso yewao ŋerep medep ŋatkorop, so medep abubu ŋamu nenerop eŋe baŋ daleo okangei? Kawali yewao yuanoniake. ");
INSERT INTO ons_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Anutu meŋenkau detki ra, ŋine baŋ kaet wie more koya nasoo me Qezarek Nasoo maine mi ariu rap! Kawaliŋo koya naso wakoniake, ŋine wikile suaine wakon ŋuniake. ");
INSERT INTO ons_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Naso yewao, kakarauk wakoniake, yemo zok manerop mi wakone pa sari mageki, kaiwe naso imdaka baŋ wakoniake. Me koso ŋado kine kine yaline mi wakoniake. ");
INSERT INTO ons_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ŋo siluŋ Anutu eŋe wikile kaiwe naso ea wane zaleine mo ma bomile wareke, eŋe yale mi okange ra, yemo ŋei ŋerep maneŋo gege eamo mi wakongi rap, ŋei ŋerep magukoune ma wesakonge, eŋane raki paki, Anutu eŋe baŋ kaiwe naso ea ma bomileake. ");
INSERT INTO ons_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Naso yewao ŋei maneŋo ŋidane rayake, ‘Kau, Mesia iwa metmaike!’ Me, ‘Eriwa metmaike!’ Yale raki detpi, wele misuk okaniake. ");
INSERT INTO ons_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Onoka wane, Mesia isisine so propet isisine baŋ wakonikei paki, eŋe baŋ masi togogole so masi kuneŋine maikei, yemo Anutuŋo ŋei ŋerep ma wesakonge, eŋe maine isione more, wet ma siuk okanonbi eŋe yale waka ra okanonikei. ");
INSERT INTO ons_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Detmami! Na don ea naso eŋe yeka paki, alakane ŋidanmaile. ");
INSERT INTO ons_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Me ŋei natne edo ŋidane raikei, ‘Kau, Mesia eŋe kepe yaup papaino, ŋei mi gegine, ea gemaike!’ Rau, ŋine ea misuk arikei, me eŋe raikei, ‘Kau, Mesia eŋe iwa siuke metmaike!’ Rau, ea detpi wele misuk okaniake. ");
INSERT INTO ons_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ŋei Wawainane Gipole eŋe baŋ sariake, yemo qilap yale qeliwo walatakki kepe sasainoŋine kilitike ari kepe ketmaikeo, qe okanmaike yale didiwo wakoniake. ");
INSERT INTO ons_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ea wane rokoune, yemo iwa yale, yewao me yewao kine kine seuseune mane wane pareŋine pamaike, eao gaubaga eŋe sari lewaŋ okanmami, Mesiaŋo sariakane nasoine eŋe maine mi ma suikeake. ");
INSERT INTO ons_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Naso yewa, baŋ kakarauk kine kineine ea woroŋ woroŋ qe more teba ketki, ea wane ŋadino mi azoŋgika, kepe deine mupke panamaniake, meso eŋe baŋ koso menerop mi qelaŋaniake, serekin eŋe korop qeliwo ŋine baŋ buratke kepo ket warekei. Paki kine kine zonom korop qeliwo pamaike, ea baŋ ukat ma esopongi numaene qeliŋka warekei. ");
INSERT INTO ons_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pakimo, Ŋei Wawainane Gipolane kibi so qeli ewe zonom qelaŋaninane tanikine baŋ qeliwo wakoniake, pakimo, kepe baŋem ŋei ŋerep magune magune ge arimami eŋe baŋ arokkei, paki baŋ kau, Ŋei Wawainane Gipole eŋe qeliwo kezoŋ kutno togogole so qeli ewe zonomine kakapa suaine, earop sariake. ");
INSERT INTO ons_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Romon kakapa suaine baŋ arokeake, paki eŋe baŋ eŋine aŋelokoune taleongi, kepe baŋem kepe baŋem lolike ariwarekei, paki eŋe baŋ eŋine ŋei ŋerep magukoine ma wesakonge, ea korop kepe sotakine maneo ŋine, kepe sotakine maneo, yale ebu qeturaŋ onwareake. ");
INSERT INTO ons_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Qeligeu, fik eki eaŋo kine kito ŋidangi desikei, eŋe qogine korop wisika wisika okange, gunule more kieke metine motkimo, ŋine dere ramami, ‘kaiwe okorayakane’ , naso ea mo bomilemaike, ");
INSERT INTO ons_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","numa weku yewaka, ŋine kine kine korop iwa kau paki, ea ŋine baŋ desikei, naso mo bomilemaike, mo kiekeakane ewekmaike. ");
INSERT INTO ons_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iwa yale desikei! Ŋei ŋerep iwa gemami, eŋe korop mi seukwarekei, eŋe ika geu, kine kine korop iwa wakon wareake. ");
INSERT INTO ons_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Qeli so kepe ere baŋ mida lele arikeik, ŋo, naŋane don yemo baŋ mi mida lele ariake.” ");
INSERT INTO ons_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesu eŋe koso manerop iwa yale rake, “Ŋei maneŋo mi detmaike, dango kaiwe naso suaine ea baŋ bomileake, me aŋelo qeliwo gemami, eŋe mi detmami, me Gipole eŋe yaleka mi detmaike, Magak eŋe wekuŋo bonep naso ea detkamaike. ");
INSERT INTO ons_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ŋei Wawainane Gipole sariki baŋ, Noa wane nasoo masi okangoi, kop yale waka okangei. ");
INSERT INTO ons_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Eŋe Doku Qakum lotkeakane nasoine mo bomileki, yemdaka ŋei ŋerep ŋara so doku nekoi, ŋei so ŋerep mete au au okangoi, yale okane arimageu, nasomde eaka bomileki, Noa seki kotino wa ketke, ");
INSERT INTO ons_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ŋo eŋe daleo wakonmaike, eamo mi dereret gegeu, Doku Qakum eaka lotke more weŋseŋgi, korop mida sololoke ari warekoi. Ŋei Wawainane Gipole sariake, naso yewao masi yalewa eŋe baŋ wakoniake. ");
INSERT INTO ons_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Naso suaine yewao, ŋei etke ere baŋ euo urata ma okorauk, mane baŋ Anutu maine mayake, ŋo mane baŋ qeliŋkaki ŋadine okane yeine mesiake. ");
INSERT INTO ons_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ŋerep etke ere baŋ ŋara kipelek kipeleko ŋara mauluke okorauk, mane baŋ Anutuŋo ma ariake, ŋo mane baŋ yeine qeliŋkayake, paki eŋe baŋ ŋadino biŋek okaniake. ");
INSERT INTO ons_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ea wane ŋine diam togogole makei, onoka wane, ŋine mi detmami ma nasoo ŋinane Waomŋine eŋe baŋ sariake. ");
INSERT INTO ons_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Iwa ŋidanbe desikei, mat welaine eŋe kobu mama maneŋo sariakane detki paki, wisika geakeo, yemo kobu mamaŋo matine koto maine mi rabarake wakesiake. ");
INSERT INTO ons_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kine yalewa pamaike, ea wane ŋine yale waka wet wisika geu paki, diamŋine seleleine naso baŋem ma more eweke gekei, onoka wane, Ŋei Wawainane Gipole eŋe baŋ naso mane qoeki, ŋine mi detpi, eaoka eŋe sariake. ");
INSERT INTO ons_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Pakimo maŋo urata ŋei maine so dereret korop gemaike? Ea edanbe desikei! Eŋe ŋei weku yemo ware wareineŋo urata ŋei natne eŋane ŋetneene birakaki wareone geki paki, ŋaraene nasooka ebon okanmaike. ");
INSERT INTO ons_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Urata ŋei ŋetne eŋe urataine ea mayakatne ware gemaikeo, yemo ware wareineŋo zinge matko sariki paki kakimo, eŋe zok wetpesek det okanmaike! ");
INSERT INTO ons_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na welekakatne ŋidane detpi, ware wareineŋo urata ŋei yewa baŋ ŋetne birakaki, eŋine aboŋ kine kineine korop ea wane ware ware okane geake. ");
INSERT INTO ons_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ŋo mane eŋe urata ŋei qotkoine geakeo, yemo eŋe oŋomka iwa yale rayake, ‘Naŋane ware warene eŋe ikopka mi zinge sariake, eŋe baŋ naso kiroine gemage zinge sariake.’ ");
INSERT INTO ons_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Eso eŋe yale raki paki, urata ŋei kima koune baŋ kieke engu kito okaniake, so ŋara neake, so doku togole nene ŋei eŋerop doku neake, ");
INSERT INTO ons_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","eŋe yale okane more, eŋane nem niget okane nasoine mi dere gegeki, urata ŋei ea wane ware wareine eŋe naso natno baŋ mi detki zinge sariake, ");
INSERT INTO ons_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","sariki paki, ware wareŋo urata ŋei ea baŋ matalika more tiŋ tuŋ kitatkaki, sisi sisi okangi ma biraki ket isi ŋei qotkoine eŋerop sora gerepko geake. Ŋei yewa eŋe aŋaene etkeka yewao eŋe baŋ wikile suaine manerop dere, ŋet warik warik ki gekei.” ");
INSERT INTO ons_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu eŋe koso iwa yale rake, “Baŋ naso yewao, qeli ewe zonom so gege togon wane numa eamo iwa yale, ŋerep ten edo lamene dokune weneŋ mau paki, ari ŋerep mane wane ŋaone zokit muse musen mayakane, eŋe sariki, maratkaikei wane ari tomakakoi, ea wane rokop wakoniake. ");
INSERT INTO ons_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ŋerep 5 eŋe qelaŋ, ŋo 5 eŋe dereretenerop. ");
INSERT INTO ons_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ŋerep ea qelaŋ, eŋe lamene setneka makoi, ŋo dokuene mane maune weneŋ mi makoi. ");
INSERT INTO ons_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ŋo ŋerep ea dereretenerop, eŋe lamene setno dokune wat watko qeu ketki so doku beloŋ mane maune weneŋ ma arikoi. ");
INSERT INTO ons_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ŋerep ŋaone muse musen zokit mayake, eŋe esatka mi sari lotkeki, eŋe tomaka metpi, setene pelekki, umun turuk qe wete sa met mage, ket kulu seu seune yale pakoi. ");
INSERT INTO ons_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pamageu, goiŋ banine okangimo boka woka mane iwa yale sarike, ‘Ŋerep ŋaone muse musen zokit mayakane eŋe mo iwa! Sariu paki maratkau!’ ");
INSERT INTO ons_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ŋerep ten eŋe mo kiŋziŋ kaŋzaŋ wieu paki lamene maulukkoi. ");
INSERT INTO ons_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pakiso, ŋerep qelaŋine eŋe dereretenerop ea edane rakoi, ‘Ŋinanoŋine dokune natne ŋene ŋebonbi, onoka wane ŋenane lam mo koma waremaike.’ ");
INSERT INTO ons_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Rau, ŋerep dereretenerop eŋe mainge rakoi, ‘Midaka iwaŋo ŋine so ŋene weneŋ mi rokopŋoniake, ŋine merewao ariu paki, ŋine ŋidom dokune ŋine qoleu.’ ");
INSERT INTO ons_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Eso ŋerep qelaŋine eŋe mo ea mere wao dokune natne qolekeiwane arikoi. Ariu ariuso, eaka ŋerep ŋaone zokit musele mayakane eŋe sari lotkemaike, pakiso ŋerep dereretenerop 5, eŋe eweke metkoi wane, eŋerop weneŋ maratkau, ŋara soep ze paki ŋerep zokit maki nekeiwane ea arikoi. Ari mat kotino waketpi ŋei eŋe madet mo ea kitokoi. ");
INSERT INTO ons_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ŋado ŋerep qelaŋine 5 eŋe lotke more boka rakoi, ‘Suaine suaine! Madet lalage ŋebonnom uŋem!’ ");
INSERT INTO ons_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ŋo ŋerep ŋaone eŋe doneene mainge edane rake, ‘Na welekakatne ŋidanmaile, na ŋine mi detŋunbe paki, zok ŋaŋae ŋunmaile.’” ");
INSERT INTO ons_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pakiso Yesuŋo edane rake, “Ea wane ŋine wetŋineŋo diam seleleine mau paki gekei, onoka wane, ŋine eŋe ma kaiweo me ma auao suaineŋine eŋe sari lotkeake, ea ŋine zok mi detmami.” ");
INSERT INTO ons_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ŋei Wawaine Gipole sariakane nasoo, rokop iwa yale wakoniake. Ŋei maneŋo mat maneo ariakane okangi paki, urata ŋeikoune edoraki sariu, kine kineine warekei wane matoke kuteno motke. ");
INSERT INTO ons_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Eŋe urata ŋei karewe dereretene so zonom enane rokopko detone more wesi ebonge, Ŋei mane eŋe wesi 5 tausen kina (K5, 000) mange, ŋo mane eŋe tu tausen kina (K2, 000) mange, ŋo mane eŋe wan tausen kina (K1, 000) mange. Pakiso, eŋe mo ea biraone more numa arike. ");
INSERT INTO ons_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Urata ŋeiwa K5, 000 make eŋe ariki paki, ikopka wesiine ea urata mangi, eaŋo kiatki koso K5, 000 magu mane wakonge. ");
INSERT INTO ons_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Numa weku yewaka urata ŋeiwa K2, 000 make, eŋe wesiine urata mangi, eaŋo kiatki koso K2, 000 magu mane wakonge. ");
INSERT INTO ons_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ŋo urata ŋeiwa K1, 000 make, oŋo yemo ariki paki, kepeo lom maki pakiso, suainane wesi ea lomgo dukke. ");
INSERT INTO ons_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Naso kiroroine gemageki qoeki, ea wane ŋadino urata ŋei yewa eŋane suaine ene eŋe koso zinge sarike paki, eŋerop wesi ea wane don mauluke aukei wane qeturaŋ onge. ");
INSERT INTO ons_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Urata ŋeiwa K5, 000 make, eŋe koso K5, 000 magu mane earop masariki paki more rake, ‘Suaine, ge K5, 000 ningone. Kanom! Na koso urataine mawe K5, 000 magu mane iwa wakonge.’ ");
INSERT INTO ons_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Olatki, suaineineŋo rake, ‘Ge urata mauluke makone, ge urata ŋei mayakakatne, so aŋa tewe tewek korop! Ge kine kine nigatne ea wane urataine mayakakatne mauluke makone, eso ea wane noŋo baŋ kine kine suaine ea wane ware wareine biraganikale. Ge sari saketnom paki, narop wet pese detnom!’ ");
INSERT INTO ons_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Pakiso, urata ŋeiwa K2, 000 mange oŋo sari saketki paki olale rake, ‘Suaine, goŋo K2, 000 ningone. Kanom! Noŋo urataine mawe K2, 000 magu mane koso iwa wakonge.’ ");
INSERT INTO ons_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Raki ware wareineŋo olale rake, ‘Ge urata mauluke makone, ge urata ŋei mayakakatne, so aŋa tewetewek korop! Ge kine kine nigatne ea wane urataine mayakakatne mauluke makone, eso ea wane noŋo baŋ kine kine suaine, ea wane ware wareine biraganikale. Sari saketnom paki, narop wet pese detnom!’ ");
INSERT INTO ons_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Pakiso urata ŋeiwa K1, 000 make, oŋo sari saketki paki olale rake, ‘Suaine, na geŋane kine detmaile, ge ŋei togogole, ge goŋom ŋara metnom paki eaŋine mi lokak okanmaine, so goŋom wit woune yasonom paki, eaŋine mi ma sari maguk okanmaine. ");
INSERT INTO ons_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Na kaetnange, eso ea wane na ariwe paki, geŋane wesi ea kepo dukewa pake. Kanom! Geŋane wesiŋone mo iwa manom.’ ");
INSERT INTO ons_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Yale olatki, suaineineŋo iwa yale olatke, ‘Ge urata ŋei borikine so taboŋ gege! Ge iwa yale detkone, na noŋom ŋara metpe paki, ea ŋine mi lokak okanmaile, me na noŋom wit woune yasowe paki, ea ŋine mi ma maguk okanmaile, yale me? ");
INSERT INTO ons_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ea maine, ge naŋane yale detnom paki, naŋane wesi ea wesi urumgo motnom rap, pakimo edo mau sua leule okangi, na zinge sariwe paki, ea koropka sisine weneŋ mawe rap. ");
INSERT INTO ons_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Wesi iwa omakkau paki, ŋeiwa ten tausen kina (K10, 000) magemaike, eŋe manbi. ");
INSERT INTO ons_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ŋei mane eŋe kine kine mangoi, ea mageki ma leule manbi, eŋe baŋ morian manerop wakonka mangi mageake, ŋo mane eŋe kine kine mangoi, ea mi ma leule more, siluŋ nigagatnmde mageake, ea baŋ omaka ariu, eŋe yaup geake. ");
INSERT INTO ons_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Urata ŋei bau wawaine yaline yemo ma birakau, ŋadino panaman koto kesiake, yewao eŋe baŋ aroke more, ŋetneŋo warik warik ki geake.’ ");
INSERT INTO ons_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ŋei Wawainane Gipole, eŋe Ŋei Waom yale okane sariake, naso yewao, eŋe so aŋelo magukoune korop eŋerop weneŋ sarikei, paki eŋe baŋ Ŋei Waom met metine qeli ewe zonom gorop ea wane kutno pese mesiake. ");
INSERT INTO ons_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Metkimo, kepe baŋem ŋei ŋerep korop eŋe baŋ eŋane kaitko sari lewaŋgei, paki mo eŋe baŋ mapokongi, magu etke okangei, lama ware wareŋo lama noniŋ eŋane koruo ŋine mapokonmaike, ea wane rokop mapokoniake, ");
INSERT INTO ons_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","mapokone more, lama eŋine wonino biraoniake, ŋo noniŋ yemo kanaino biraoniake. ");
INSERT INTO ons_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pakimo ŋei waomŋo baŋ ŋei ŋereppa woninoken okorakei, ea iwa yale edaniake, ‘Ŋine naŋane Maganeŋo mosop ŋunge, sariu paki, qeli gege togon welaine okanbi, eamo mokaka qeli so kepe ma wakon ore more, ŋinane biŋek mauluke motke. ");
INSERT INTO ons_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na ŋara wane seukewe, ŋine ŋara gume nangoi, doku wane qomne sererekki, ŋine doku ninbi nekole, na ŋei kuneŋine yale sariwe, ŋine neu matŋine kotino biranangoi. ");
INSERT INTO ons_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na lawam gewe, ŋine takot laplap ramunangoi, na zoma nangi, ŋine warenangoi, na mulap urumgo metpe, ŋine qelipkenan okangoi.’ ");
INSERT INTO ons_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ŋei koboboine eŋe baŋ iwa yale mainge rakei ‘Waom, ŋene dango ganŋem, ge ŋara wane seukenom, ŋene ŋara gumegangone, me doku wane qomŋone sererekki, doku ginŋem nekone! ");
INSERT INTO ons_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Naso dango ŋene ganŋem, ge ŋei kuneŋine yale sarinom, geu matze kotino biragangone, me lawam sarinom, takot laplap ramu gangone! ");
INSERT INTO ons_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Naso dango ŋene gaŋem, ge zomagangi ware gangone, me mulap urumgo metnom, ŋene qelipke gan okangone!’ ");
INSERT INTO ons_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ŋei waomŋo baŋ mainge edane rayake, ‘Na welekatne ŋidanbe, kimakopne ketkele eŋane keuoŋine, ŋei wekumane kima mauluk okankakoiwo, yemo ŋine na okannangoi yale okanmaike!’ ");
INSERT INTO ons_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pakimo, eŋe baŋ ŋei ŋereppa kanaino okorakei, eŋe iwa yale edaniake, ‘Anutuŋo soakŋunge, ŋine naŋane kaitko ŋine ariwareu! Ari more, Magakŋo Satan so aŋelokoune eŋane gerep togogole dubukki zeki mauluke biraonge, yewao ket more gekei! ");
INSERT INTO ons_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na ŋara wane seukkole, ŋo ŋine siluŋ ŋara mane mi ningoi, doku wane qomne sererekki, ŋine doku mi ningoi, ");
INSERT INTO ons_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na ŋei kuneŋine yale sariwe, ŋine neu more mat ŋine kotino mi biranangoi, lawam gewe, ŋine takot laplap mane mi ramu nangoi, na zoma nange so mulap urumgo metpe, ŋine warenane more qelipke nan mi okangoi.’ ");
INSERT INTO ons_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Yale raki, eŋe baŋ iwa yale olasikei, ‘Waom, ŋene naso dango ganŋem ŋara wane seukkone, me doku wane qomŋone sererekke, me ŋei kuneŋine yale sarikone, me lawam gekone, me zoma gange, me mulap urumgo metnom, gane qewoloŋ okan gane more mi qesiŋgangone!’ ");
INSERT INTO ons_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Rau, ŋei waomŋo baŋ iwa yale mainge edaniake, ‘Na welekatne ŋidanbe, kimakopne ketkele gemami, eŋane keuo ŋine ŋeimde wekumane kima mauluk okankakei wane bauŋine waki walukkakoi, yemo naŋane bauŋine waki, na waluk nangoi okanmaike.’ ");
INSERT INTO ons_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pakimo ŋei iwa yaline, eŋe ea wane turuŋine baŋ wikile papa togon ea marat kaikei, ŋo ŋei koboboine eŋe baŋ qeli gege togon matko arikei.” ");
INSERT INTO ons_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu eŋe don iwa korop rawareki qoeki, dokoine edan rake, ");
INSERT INTO ons_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kaiwe etke, ea ŋine mo detmami, yewa qoekimo Aŋeloŋo Loloŋongi ŋara soep nemaŋkoi, ea wane taboŋ met met naso baŋ bomileake, paki naso yewao Ŋei Wawainane Gipole eŋe baŋ ŋei eŋane meteeno birakau, kibeŋ qabego biriŋŋo rasukaikei.” ");
INSERT INTO ons_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pakiso naso yewao, pris ŋetne so Yuda ŋei sele eŋe sari qeturage, Kaiapas pris suainane urumgo lewaŋgoi. ");
INSERT INTO ons_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Pakimo don pise more Yesu sanka ma lukkau paki, qeu seukeakane don aukoi. ");
INSERT INTO ons_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pakiso rakoi, “Ŋene Loloŋon Loloŋon peada naso iwao misuk okanikene, me ŋene okanŋem, ŋei ŋerep eŋe kawali yau yaup baŋ qekei.” ");
INSERT INTO ons_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu eŋe, Saimon kuku sele ŋei sogine mo menaŋge, eŋane matko Betani yewao wa metke. ");
INSERT INTO ons_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Metkimo, ŋerep mane eŋe beloŋ mane kelok qoune simileteine, lewine suaine eaŋo qewat qewale, ea ma more Yesu wano sarike. Yesu eŋe ŋara ne metki, eaka kelok ea qakki, lewino ket taukake. ");
INSERT INTO ons_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Dokoine eŋe ea kau paki, sotene osike qesone rakoi, “Onoka wane eŋe kelok iwa korop matali maike? ");
INSERT INTO ons_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kelok iwa yemo motŋem ari, wesi suaine kiatki sariki mo, ma more ŋei aboŋene midaine maine ebonŋem rap!” ");
INSERT INTO ons_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu eŋe don rakoi, ea wane kine mo detke paki edane rake, “Ŋine ŋerep iwa onoka wane ra kitat okan kamami? Iwamo maine so kine kine weku mane, ŋerep eŋe na okannanmaike. ");
INSERT INTO ons_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ŋei aboŋene midaine, eŋe yemo baŋ naso baŋem ŋinerop ge arikei, ŋo na yemo naso baŋem ŋinerop mi gekale. ");
INSERT INTO ons_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ŋerep eŋe yale okane more, kelok qoune simileteine yewa solane qakike, yemo seukewe duknangei wane, ma eweknanike. ");
INSERT INTO ons_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na welekatne iwa rawe detpi! Kepe baŋem don kisi iwa ra qelaŋane arikei rokop, ŋerep iwa okan nanmaike, eŋane weneŋ detsoroke more, don kisiine baŋ rau sua ariake.” ");
INSERT INTO ons_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Naso yewao dokoine 12 enŋenane keueno ŋine mane eŋetine Yudas Iskariot, oŋo pris ŋetne eŋano arike. ");
INSERT INTO ons_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Paki edane rake, “Na Yesu ŋinane meto birakawe, ŋine lewine onokaka ninikei?” Eŋe wesi setne, silwa 30, yale dapore mangoi. ");
INSERT INTO ons_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Naso yewaoka Yudasŋo kieke Yesu ma wakon kayakane numaine dere mauluk okange. ");
INSERT INTO ons_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bret sap saune ea wane soda weku kaiwe mane yewao dokoine eŋe Yesu wano sari qesonka rakoi, “Ŋene detmaine, ŋo diawao ari mere, Aŋeloŋo Loloŋonge ea wane Nasoo ŋara mauluke gingene?” ");
INSERT INTO ons_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Rau eŋe edane rake, “Ŋine mat suaino ariu paki, ŋei mane maratkakei, paki iwa yale olasikei, ‘Kito ŋebo ŋebonŋo ramaike, naŋane nasone mo bomilemaike, wane naŋane dokoine so na ŋene baŋ Aŋeloŋo Loloŋonge Naso eao geŋane matko mere ŋara nekene.’” ");
INSERT INTO ons_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dokoine eŋe Yesuŋo don edange, ea wane rokop okane more, Aŋeloŋo Loloŋonge Naso ea wane ŋara maulukkoi. ");
INSERT INTO ons_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kepe rarap okangi Yesu eŋine so dokoine 12, eŋe zakeo ŋara nekeiwane pese metkoi. ");
INSERT INTO ons_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ŋara ne mere, eaka Yesuŋo rake, “Na welekatne ŋidanbe, ŋinane keuŋino ŋine ŋei maneŋo na baŋ ma wakon naniake.” ");
INSERT INTO ons_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dokoine eŋe wetene boriki, kieke weku weku qesonka rakoi, “Welekatne, Waom, ge naŋane ramainane?” ");
INSERT INTO ons_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Rau Yesuŋo mainge edange, “Ŋeiwa metine biraki narop lase wekuo ketki bretine ma neake, oŋo na baŋ ma wakon naniake. ");
INSERT INTO ons_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ŋei Wawainane Gipole eŋe yemo Anutu wane papaiaŋo ramaike, yale baŋ seukeake, ŋo Ŋei Wawainane Gipole ma wakonka yake, ŋei yewa eŋe yemo turuŋine, yai, zok manerop zinge maniake! Ŋei yewa eŋe nabok kotino ŋine mi wakongirap, yemo mayakatne okangirap!” ");
INSERT INTO ons_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Raki ma wakon kayake ŋei, Yudas, oŋo qesone rake, “Kito ŋebo ŋebon, ge naŋane ramainane?” Yesuŋo mainge olale rake, “Mo ea, goŋom ramaile.” ");
INSERT INTO ons_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Eŋe ŋara ne metpi, eaka Yesu eŋe bret ma more bakom kitoki paki, dokoine ebone rake, “Mau paki neu, iwa nae bikumne.” ");
INSERT INTO ons_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pakiso, eŋe wain lase ma more, Anutu bakomine kitoki paki, dokoine ebone rake, “Ŋine korop iwa neu, ");
INSERT INTO ons_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","iwamo nae weŋemne, ea wane ra more, Anutuŋo ŋinerop tako rakot geake. Naŋane weŋemne yemo, ŋei ŋerep korop ŋinane borikineŋine saukeakane qake kesiake. ");
INSERT INTO ons_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na ŋidanbe detpi, na baŋ koso ŋinerop wain iwa manerop mi nene, yaupka ge arimage, kaiwe naso yewao na wain musele, ea ŋinerop weneŋ Maganane gege togon kotino nekene.” ");
INSERT INTO ons_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yale rakiso eŋe aŋelo loloŋon loloŋon wane eŋet so miti okanbi paki, matko ŋine ket more, Oliwa Bonagao arikoi. ");
INSERT INTO ons_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pakiso, Yesu eŋe dokoine edane rake, “Ruomde iwao, mali malip ŋine korop baŋ pelekki, na qeliŋnane kaet ari warekei, onoka wane Anutu wane papiao iwa yale ramaike, ‘Anutu eŋe baŋ lama ware ware qeki paki, qe kuruŋonbe, lama magu koropŋo baŋ kakak nagu ket yeo yeo qiŋ qiririŋ ari warekei.’ ");
INSERT INTO ons_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ŋo na seu seuo ŋine wisikae wiewe paki, na baŋ Galili kepeo alakane ŋibonikale.” ");
INSERT INTO ons_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petoroŋo aŋage olale rake, “Natne eŋe korop geŋane detpi boriki biragane ari warekei, ŋo na yemo baŋ mi biragane arikale!” ");
INSERT INTO ons_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Raki, Yesuŋo Petoro girem don olale rake, “Na welekatne iwa golatpe detnom! Tiakŋo mi bokaki, ge ruo yewao atak karewe bisopnane more raikene, ‘Na eŋe mi detkamaile’” ");
INSERT INTO ons_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petoroŋo togole mainge rake, “Na gerop weneŋ seukkaleo, na siluŋ geŋane bisopke mi raikale, na eŋe mi detkamaile!” Pakiso dokoine korop eŋe qesiŋka don don weku eaka rawarekoi ");
INSERT INTO ons_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pakiso, Yesu eŋe dokoine eŋerop rome saromat mane, eŋetine Getsemane, yewa ari more edane rake, “Ŋine iwa metpi, na eriwa ari meŋenkawe.” ");
INSERT INTO ons_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Eŋe Petoro, so Zebedi wane gipoletkine etke weneŋ ebuki arikoi. Ariu paki qomine umareki wikile suaine detke. ");
INSERT INTO ons_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Paki edane rake, “Kotono umat zok kakapa suaine, eaŋo ki pelek naniakane okanmaike, ea wane ŋine iwa narop weneŋ wet wisika mere, diam maikei.” ");
INSERT INTO ons_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yale edane more, eŋe eri ekeket biraone ariki paki, eŋe eŋineka meine ket kepo kito more iwa yale ra meŋenkake, “Magane, ge detnom iwa maine okanmaikeo, yemo wikilane lase iwa oma nannom! Ŋo siluŋ naŋane don mida, geŋane don togoleake.” ");
INSERT INTO ons_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yale ra meŋenkaki paki, zinge ari dokoine karewe metkoi, eŋe ongi kuluka pakoi, pakimo eŋe Petoro olale rake, “Ŋine ŋei karewe iwa daleo wane mi ewekeu paki, narop wan aua diam wet wisika mi gemami! ");
INSERT INTO ons_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Diam tako rakot mau paki meŋenkau, ŋine yale okan mage, baŋ peleke more, liwe liwek borikino ket qekei. Asuŋineŋo yemo eweke more kine kine okaniakane okanmaike, ŋo solaŋineŋo yemo umareki paki, zonomine midaine okanmaike.” ");
INSERT INTO ons_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Atak etke eŋe koso manerop zinge ari meŋenka rake, “Magane, wikilane lase iwa mi oma nanikeneo, yemo na maine newe mo, geŋane don ea togoleake.” ");
INSERT INTO ons_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Eŋe koso manerop zinge ari dokoine ongi kuluka pakoi, eŋe deene wareka wet wisika mi metkoi. ");
INSERT INTO ons_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu eŋe koso manerop qeliŋone ariki paki meŋenkaki atak karewe okange, don wekuka ra meŋenkake. ");
INSERT INTO ons_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pakiso, koso dokoine eŋano zinge ariki paki rake, “Ŋine yeka kulu pau paki, zonom mamami me? Kau! Naso mo bomilemaike, wane Ŋei Wawainane Gipole mo ma more, ŋei borikine mama eŋane meteeno bira kakei. ");
INSERT INTO ons_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wieu, ŋene ariŋem, kau, ŋeiwa ma wakon naniake, mo iwa sarimaike!” ");
INSERT INTO ons_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu eŋe don yale edane okoraki, dokoine 12 eŋane keuo ŋine mane Yudas, eaka lotkeke. Eŋerop weneŋ sarikoi, yemo ŋei magu suaine, Pris ŋetne so Yuda ŋei sele edo taleonbi, kawali wane pilaŋ so soba weneŋ peike sarikoi. ");
INSERT INTO ons_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Isi bela ŋei, ea eŋe ŋei magu yewa kait masi iwa yale maki kau paki, Yesu makei wane edange, “Na ari ŋei yewa ka more, lulu zam zam maweso, ŋine kau paki, Yesu iwa raso malipka lukka arikei!” ");
INSERT INTO ons_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yudas eŋe eaka lotke more, Yesu wano koboine ari rake, “Peamŋo gerop payake, kito ŋebo ŋebonze.” Yale raso, lulu zam zam make. ");
INSERT INTO ons_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesuŋo olale rake, “Kima, urata makenane wetke sarine, ea ikop manom!” Rakiso, eŋe osino sari more malipkau paki, metine wokom gekoi. ");
INSERT INTO ons_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesurop gekoi, eŋano ŋine maneŋo pilaŋ warage more, Pris Suainane qelit medep qeki paki, ketne nat kito qotki ketke. ");
INSERT INTO ons_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yale okange Yesuŋo olatke, “Ge pilaŋŋone koso biranom, matno ketkep, onoka wane ŋei korop pilaŋ ma okanmami, eŋe pilaŋ yewaŋo enguki seuk okanmami. ");
INSERT INTO ons_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ge mi detmaine, na Magane maine qesiŋ naniakane olatpe eŋe kawali ŋei aŋelo magu suaine 12 ea yuanmaike, eŋe esatka taleongi sari qesiŋ nanbirap? ");
INSERT INTO ons_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ŋo eŋe yale okanbimo, Anutu wane papiao numa yalewa oken wakoniakane raraine, ea wane wele eamo daleo wakongirap?” ");
INSERT INTO ons_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Naso yewaoka Yesu eŋe ŋei magu yewa edane rake, “Na kawali ŋei ea wane ŋine kawali wane buza so soba weneŋ mau paki, neukei wane sarimi me? Na kaiwe baŋem Bakom Urum koto pese mere, miti don kito ŋidan okane gekole, pakimo, ŋine yewao mi neu luknangoi. ");
INSERT INTO ons_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ŋo siluŋ masi iwa korop wakonmaike, yemo propet edo Anutu wane papiao don qekoi, ea wane wele wakoniakane masi iwa wakonmaike.” Yale ra edangiso, dokoine korop eŋe qeliŋkau paki, biraka ariwarekoi. ");
INSERT INTO ons_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ŋeiwa Yesu ma lukkakoi, eŋe mau paki, Pris Suaine Kaiapas wane matko iwenka arikoi, yewao ra rokop don kito ebo ebon ŋei, so ŋei sele eŋe sari lewage metkoi. ");
INSERT INTO ons_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petoro eŋe Yesu ŋadino mogare eri amaŋ Pris Suainane mat wane sen ŋadino arike. Eŋe ari sen koto waket more, tebe ŋei diam gege eŋerop pese ket mere, tanik daleo okankaikei, ea wane one modatke. ");
INSERT INTO ons_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pris Suaine eŋe so ŋei wawaine korop, eŋe Yesu wane isi don maratkau paki, gube qesat don solaino kito more, qeu seukeakane don aukoi. ");
INSERT INTO ons_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ŋei loutneŋo sariu paki, isi don zok loutne solaine qe rawarekoi, ŋo siluŋ donene eaŋo wele mi okange. Pakiso ŋei etke ere wakone saketkoik. ");
INSERT INTO ons_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Paki rakoi, “Ŋei iwaŋo iwa yale rake, ‘Na Anutu wane Bakom Urum iwa kito ra barakewe, ariki kaiwe karewe yewaka koso maulukkale.’” ");
INSERT INTO ons_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pris Suaine eŋe wie okoraki paki, Yesu olale rake, “Eŋe geŋane don ramami, ea wane turuŋine edanikenane mane ma okoramaine, me mida?” ");
INSERT INTO ons_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesu eŋe siluŋ meune qoeki okorake. Pris Suaine eŋe koso manerop olale rake. “Anutu gege togon welaine, eŋane kaitko qesonganbe, ge welekatne Mesia, Anutu wane gipole gemaineo, yemo ŋedannom.” ");
INSERT INTO ons_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesuŋo mainge rake, “Ge mo ea ramaine, ŋo na korop ŋidanbe detpi, naso iwao ŋine ge ari more, ŋine korop baŋ kau, Ŋei Wawainane Gipole, Anutu zomine kakapa suainane metine wonino metki paki, qeliwo kezoŋ kutno sariake!” ");
INSERT INTO ons_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yale raki, Pris Suaine eŋe takotine ma barake more rake, “Eŋe Anutu mabaik kamaike! Ŋene koso raŋem qesat ŋei eŋe sari, eŋane don mi rakei, yeine! Ŋine eŋane don qotkoine mo iwa raki detkamami! ");
INSERT INTO ons_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ŋine daleo detmami?” Eŋe mainge rakoi, “Eŋe sot korop, ea wane eŋe maine seukeake.” ");
INSERT INTO ons_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yale rau paki, kaitine sopotka more qekoi, paki ŋei natne qekoi, edo rakoi, ");
INSERT INTO ons_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Mesia ŋenane don saeŋine ranom! Detnom, maŋo gekumaike!” ");
INSERT INTO ons_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petoro eŋe qeinat mat wane sen kotino metki, Pris Suainane qelit ŋerep maneŋo eŋano sari more rake, “Ge yaleka Yesu Galili kepeo ŋine, eŋerop weneŋ gekone.” ");
INSERT INTO ons_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ŋo eŋe korop eŋane kaiteno bisopke more rake, “Ge don ramaine, na ea mi detmaile.” ");
INSERT INTO ons_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Yale raki paki, eŋe mat wane sen ea wane madetko ari wakesiakane okange, paki qelit ŋerep maneŋo kaki paki, ŋei yewa metkoi eŋe edane rake, “Ŋei iwa eŋe Yesu Nazaret matko ŋine, eŋerop geke.” ");
INSERT INTO ons_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petoro eŋe koso ea bisopke more rake, “Welekatne ramaile, na ŋei yewa mi detkamaile!” ");
INSERT INTO ons_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Naso nigatne azoŋgi, ea wane ŋadino ŋei yewa okorakoi, eŋe Petoro wano sariu paki rakoi, “O welekatne, ge eŋane tegoo ŋine mane iwa. Ge don tanik ŋone ramaine, eaŋo kine qe wakongi detmaine!” ");
INSERT INTO ons_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Rauso, Petoroŋo don togoleka bisopke more rake, “Welekatne, Anutu wane kaitko ramaile, na don welekatne mi ŋidanmaileo, yemo Anutuŋo wikile niniake, na ŋei yewa mi detkamaile!” Rakiso, eaka tiak bokake. ");
INSERT INTO ons_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pakiso Petoro eŋe Yesuŋo don iwa yale olatke, “Ge atak karewe, mi det kamaile, ra bisop nannom, tiakŋo atak karewe bokayake.” Ea detsoroke more, saket ariki paki, wetine tabaeki zok arokke. ");
INSERT INTO ons_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kepe qaeki ruoropka, pris ŋetne korop so Yuda ŋei suaine, eŋe Yesu qeu seukeakane don aukoi. ");
INSERT INTO ons_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Eŋe mulap togoleŋo Yesu metine wokomge more mau paki, Roma ware ware suaine Pilat wano ma ari birakakoi. ");
INSERT INTO ons_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudas, siron qeqe ŋei, eŋe ongi Yesu mo seukeakane ra togolekoi, yale kaki paki, wetne mainge more, wesi silwa 30 ea koso mazinge ari Pris ŋetne so Yuda ŋei suaine ebonge. ");
INSERT INTO ons_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Paki rake, “Na sotkorop okanbe paki, ŋei sotine midaine iwa ma wakonka seuseuo birakamaile!” Eŋe mainge rakoi, “Ea ŋenano onoka wane sari ramaine? Eamo geŋone aboŋ!” ");
INSERT INTO ons_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas eŋe wesi yewa biraki, Bakom Urumgo wakiso biraone ketke. Ket ari moreso, oŋomka ebine rapokke. ");
INSERT INTO ons_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pris ŋetne eŋe wesi yewa mau paki rakoi, “Wesi iwa yemo weŋem kiti kitine, ea wane ŋene ŋenze ra rokop donze yewa qe barake more, Bakom Urum wane wesi kiteo mi biraŋem kesiake.” ");
INSERT INTO ons_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Eŋe don auye, dereret okan naguwi paki, ea wane ŋadino wesi yewa mau paki, kap gola mama wane kepe mane ea qolekoi, eamo lobo ŋei abaran ŋine sari sarine, eŋane deŋesere mane okaniakane. ");
INSERT INTO ons_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ea wane eŋe kepe yewa eŋetne “Weŋem wane kepe” orakoi, wane naso iwao pamaike. ");
INSERT INTO ons_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yale okanbi, propet Yeremaiaŋo don mane iwa yale rake, ea wane wele wakonge, “Eŋe wesi silwa 30 ea makoi, Israel ŋei eŋe dereret okannagu more, wesi yewa ŋei ea qolekakei wane biŋek qekoi. ");
INSERT INTO ons_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Paki wesi yewaŋo ma more, kap mama wane kepe mane qolekoi, eamo Waomŋo nolatke, ea wane rokopko.” ");
INSERT INTO ons_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu eŋe Pilat wane kaitko okoraki, oŋo qesonka rake, “Ge Yuda ŋei eŋane ŋei waom me?” Yesuŋo mainge rake, “Goŋom mo ea ramaine.” ");
INSERT INTO ons_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Eŋe pris ŋetne so ŋei suaine edo gube qesat don solaine more rakoi, ea wane turuŋine mane mi mainge edange. ");
INSERT INTO ons_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Eso ea wane Pilatŋo olale rake, “Ge don iwa korop solaŋone qeu paki ramami, ea mi detmaine me?” ");
INSERT INTO ons_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ŋo Yesuŋo don mide mane nigatne mi mainge olatke, eso ea wane Pilat eŋe zok manerop oŋaine qaeke. ");
INSERT INTO ons_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aŋeloŋo Loloŋonge Naso, yewao Pilat eŋe ŋei ŋerep magu edo rauso, mulap ŋei mane siwotkaki, mulap urumgo ŋine saket okanmaŋke. ");
INSERT INTO ons_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wane, naso yewao ŋei mane eŋetine Yesu Barabas, eŋe mulap urumgo metke. ");
INSERT INTO ons_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Eso ea wane ŋei ŋerep magu eŋe sari lewageu, Pilatŋo qeson one rake, “Ŋine ma ŋei siwotka ŋibonikalane wetkemami? Yesu Barabas me Yesu, Mesia oramami?” ");
INSERT INTO ons_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilat eŋe kine mo detlukke, onoka wane eŋe Yesu wane det worik okanbi paki, ma ari eŋane meto birakakoi. ");
INSERT INTO ons_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilat eŋe wano wanok urumgoka metki, eŋine ŋanomineŋo don mane iwa yale motki arike, “Ge ŋei sotine midaine, ea kine kine mane misuk okankaikene, onoka wane na yatne ruoo kulu kulu kawe paki, eŋane ra more wikile zok suaine maratkele.” ");
INSERT INTO ons_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pris ŋetne so ŋei suaine eŋe ŋei ŋerep magu taleongoi, eŋe Pilat olatpi Barabas siwotka ebongi paki, Yesu birakaki qeu seukeakane. ");
INSERT INTO ons_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ŋo Pilatŋo yemo qeson one rake, “Ŋei etke iwa erano ŋine ŋei diawa siwotka ŋibonikalane wetkemami?” Eŋe rakoi, “Barabas!” ");
INSERT INTO ons_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Rau Pilatŋo qesonone rake, “Pakimo na Yesu, Mesia oramami, eŋe daleo okankaikale!” Eŋe rakoi, “Eŋe kibego rasu kanom!” ");
INSERT INTO ons_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatŋo yemo qesonone rake, “Onoka sot okangane?” Pakiso eŋe togoleka boka rakoi, “Eŋe kibego rasu kanom!” ");
INSERT INTO ons_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat eŋe mo kake, eŋane don eaŋo mi rokoponge, kawali suaineka wakoniakane okange, ea wane eŋe doku natne ma more, ŋei ŋerep magu eŋane kaiteno metine saukki paki rake, “Ŋei iwa seukeake, yemo noŋo rawe mi seukeake! Iwa yemo ŋinane aboŋ!” ");
INSERT INTO ons_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ŋei ŋerep magu eŋe mainge rakoi, “Eŋane seuseuinane turuŋ yemo qeligenom, ŋene so doko ŋosakopze ŋenane kutzo pa wayake!” ");
INSERT INTO ons_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pakiso, Pilat eŋe Barabas siwotka ebonge, ŋo Yesu yemo kumunamŋo qeki paki, kawali ŋei eŋane meteeno birakake, kibego rasukaikei wane. ");
INSERT INTO ons_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilat wane kawali ŋei eŋe Yesu mau paki, ware ware wane urum koto ma waketkoi, pakiso kawali ŋei korop eŋe sari qeatkakoi. ");
INSERT INTO ons_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Paki, eŋe eŋine takotine ea kito qoke more, takot weŋemka kiroine ea birakakoi. ");
INSERT INTO ons_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pakiso, eŋe sitman wakelerop, eaŋo ŋei waom marok mane mau paki, lewino birau ketkiso, kumunam mane metine wonino motkoi. Paki eŋe eŋane osino wawetene geu paki, isi bela qebela okankau paki rakoi. “Yuda ŋei eŋane Ŋei Waom, naso kiroroine ge ari arikene!” ");
INSERT INTO ons_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eŋe sopotkau paki, kumunam oma ka more, lewino rasipokkoi. ");
INSERT INTO ons_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","So eŋe isi bela qebela okankawareu qoeki, takot weŋemka kiroine ea kito qokkau paki, eŋine takotine ea koso mainge birakakoi. Pakiso eŋe kiruŋaŋo kibego rasu kakeiwane iwenka saket arikoi. ");
INSERT INTO ons_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Eŋe numao ariu paki, ŋei mane Sairini matko ŋine, eŋetine Saimon maratkau paki, qebin kau Yesu wane kibeŋ qabeŋ tewetki arikoi. ");
INSERT INTO ons_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Eŋe ari mage, kepe mane eŋetine Golgota, ea lotkekoi. Kepe eŋetine ea wane kine iwa yale, “Lewe Setne Kepe.” ");
INSERT INTO ons_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yewa rau pakiso, eŋe wain wisi tabaine teine earop mauluk maulukine ea manbi, ne detki paki, waulukke. ");
INSERT INTO ons_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pakiso, eŋe kiruŋaŋo kibeŋ qabego rasu kau paki, takot kine kineine ea wezu qe yuanbi paki, mapoke amanagukoi. ");
INSERT INTO ons_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ea wane ŋadino eŋe yewa eŋane diam metkoi. ");
INSERT INTO ons_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Lewine kutno dere worik donene dapore det okanikeiwane, don iwa yale qekoi, “Iwa Yesu, Yuda ŋei eŋane Ŋei Waom.” ");
INSERT INTO ons_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pakiso eŋe borikine mama etke Yesurop weneŋ kibeŋ qabego kiruŋaŋo rasuotkoi, mane wonino, ŋo mane kanaino. ");
INSERT INTO ons_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ŋei ŋerep osino kere pore okan lewetene kaliŋ kito ruzake, Yesu mawa maket kitou paki rakoi, ");
INSERT INTO ons_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ge Bakom Urum ra barakenom ketki, kaiwe karewe yewaoka koso maulukkenane rakone! Ge weleka Anutu Gipole gemaineo, yemo ge goŋomka qesiŋ nagunom! Kibeŋ qabego ŋine qoe ketnom!” ");
INSERT INTO ons_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Numa weku yewaka pris ŋetne so ra rokop don kito ebo ebon so Yuda ŋei suaine, eŋe isibela qebela okanka rakoi, ");
INSERT INTO ons_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Eŋe ŋei ŋerep natne qesiŋonge, ŋo eŋine yemo mi qesiŋ nagumaike! Eŋe Israel eŋane Ŋei Waom me? Ea wane eŋe kibeŋ qabego ŋine baŋ qoe iwa kesiakeo, yemo ŋene baŋ eŋe detlukka malip kaikene! ");
INSERT INTO ons_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eŋe Anutu detlukka malipkaki paki, na Anutu wane Gipole ra okanmaike, ea yemo maine, ŋo Anutuŋo wetne eŋane pamaikeo, yemo ukude eŋe qesiŋkaki, ŋene kaŋem!” ");
INSERT INTO ons_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Borikine mama Yesurop weneŋ kibeŋ qabego etkukoi, ere yalewaka mabaik qebaik okankakoi. ");
INSERT INTO ons_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kepe oŋa bango 12 kilok, yewao kepe yewa korop goiŋ suaine kere panaman kito paki, sa 3 aua okange. ");
INSERT INTO ons_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Naso 3 kilok okangi, Yesuŋo togoleka boka more rake, “Eli Eli lema sabaktani?” Don ea wane kine iwa yale, “Anutune, Anutune, ge onoka wane qeliŋ nanmaine?” ");
INSERT INTO ons_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ŋei natne yewa okorakoi, eŋe dere more, iwa yale rakoi, “Eŋe Elaiya wane bokamaike!” ");
INSERT INTO ons_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Eŋano ŋine ŋei mane eŋe ikopka biririke ari more, wain dokune tabainerop eao lap lapŋo qe muruge more, kudupko piseki paki, Yesuŋo neakane mange. ");
INSERT INTO ons_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ŋo ŋei natne eŋe rakoi, “Ŋene tomaka more Elaiya eŋe qesiŋ kayakane sarimakeo, yemo kaŋem!” ");
INSERT INTO ons_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu eŋe koso manerop togogoleka bokakiso, yewaka asuine saket arike. ");
INSERT INTO ons_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pakiso, laplap suaine Bakom Urum koto mode ket okorake, ea keuoka puntuk wiri, weti kutno ŋine sariki, qela kino qoe, etke leleke. Kepe qiseki wesi suaine korop din bun wiri, yeo yeo arikoi. ");
INSERT INTO ons_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Deŋesere poripke aŋaŋgi, so Anutu wane ŋei magu loutne koboboine ge more seukkoi, eŋane pareŋene ea ma wirikongi, wisikae wie warekoi. ");
INSERT INTO ons_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Eŋe wie wareu, Yesu wisikae wieke ea wane ŋadino eŋe Mat Koboine Suaino Yerusalem ariu, yewa ŋei ŋerep loutneŋo marat onwarekoi. ");
INSERT INTO ons_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kawali ŋei eŋane ware wareene, so kawali ŋei eŋerop weneŋ geu paki Yesu warekakoi, eŋe memea make, ea so masi kine kine wakonge, ea kakoi, paki oŋaene qaeki rakoi, “Ŋei iwa eŋe welekatne Anutu wane Gipole!” ");
INSERT INTO ons_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ŋerep loutne eŋe yewa abaran okorau paki potpi ariki kakoi, eŋe Yesu ŋadino mogatka Galili ŋine sarikoi paki, eŋe qesiŋkakoi. ");
INSERT INTO ons_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Eŋane keuo yemo Maria Magdalena, Maria mane Yakop so Yesep erane nagaetne, eŋe Zebedi gipoletkine erane nagaetne. ");
INSERT INTO ons_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kepe ketki rarapko, ŋei mane aboŋine suaine, Arimatea mat welaine mane, eŋane eŋetine Yosep, eŋe yaleka Yesu wane medep geke. ");
INSERT INTO ons_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Eŋe Pilat wane kaitko ari waketki paki, Yesu pareŋine ma ariakane qesonkake. Pakiso, Pilat eŋe Yesu wane pareŋine Yosep manikei wane ra ebonge. ");
INSERT INTO ons_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Eso Yosep eŋe Yesu pareŋine ea maki paki, laplap musele maneŋo kawetkake. ");
INSERT INTO ons_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Pakiso eŋine deŋesere biŋek mane kem koto muse musen wesi aŋaine koto yaso maulukke, eao motke. Motki paki wesi suaine rodiŋgi ari eaŋo deŋesereo wake waket aŋaine ea kito wonge metkiso, eŋe arike. ");
INSERT INTO ons_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalena so Maria mane ere yewa deŋesere ka mogare metkoik. ");
INSERT INTO ons_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kepe qaeki kaiwe maneo eamo qezareko met met ea wane naso qoeke, pris ŋetne so Parisi eŋe korop Pilatrop lewaŋgoi. ");
INSERT INTO ons_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Paki olale rakoi, “Suaine, ŋene detmaine, isi ŋei ea eŋe wisika geki paki, iwa yale rake, ‘Kaiwe karewe qoeki, ea wane ŋadino na baŋ wisikae wiekale.’ ");
INSERT INTO ons_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yale rake, ea wane ge ra edannom, eŋe deŋesere ea diam seleleine ma warekau, kaiwe karewe ea qoeke, eso eŋine dokoine eŋe maine mi eweke more, ari pareŋine ea baŋ kobu makei, paki ŋei ŋerep maine mi edane raikei, ‘Eŋe mo seu seuo ŋine wisikae wiike.’ Iwa ŋadino isi eaŋo yemo zok qotkoine, alakan isi ea yuankayake.” ");
INSERT INTO ons_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Rauso Pilatŋo edange, “Ŋine diam ŋei mane mau paki, ari deŋesere ea mauluke maine warekakei.” ");
INSERT INTO ons_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eso eŋe bira nagu ari, so wesi suaine ea ekiŋo sikatine qe makatakeu metki, so kawali ŋei natne biraonbi diam metkoi. ");
INSERT INTO ons_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Qezareko taboŋ met met ea wane naso qoeki, kepe weleleke ketki, Sodao sakoka Mari Magdalena so Maria mane ere deŋesere kaikeik wane arikoik. ");
INSERT INTO ons_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Eaka memea suaine togoleka maki, Waom wane aŋelo maneŋo qeliwo ŋine ket more wesi, suaine ea rodiŋgi masikane kereki, ea wane kutno pese metke. ");
INSERT INTO ons_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Eŋane kait togaine qilap yale, ŋo takotine yemo libe libe ais yale. ");
INSERT INTO ons_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kawali ŋei eŋe kaetongi zonomene oreki, seuke seuseune yale okane pakoi. ");
INSERT INTO ons_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pakiso, aŋeloŋo ŋerep etane rake, “Ŋire mi kaetŋutkep, na detmaile, ŋire Yesu kibeŋ qabego rasukau seukike, eŋe kaikeik wane sarimamik, ");
INSERT INTO ons_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","eŋe yemo iwa midakaka, eŋe yemo mo ŋidange, yale mo wisikae wiike, iwa sariuk paki, numaine peke ea kauk. ");
INSERT INTO ons_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ŋire ikopka ariuk paki, dokoine iwa yale edanbik, ‘Eŋe mo seu seu oŋine wisikae wiike, wane eŋe mo lewine alakane Galili arimaike, ŋine eŋe baŋ ea kaikei!’ Na mo ŋidanile, ea desikei.” ");
INSERT INTO ons_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eso ere deŋesere esatka qelige arikoik, kaetotke so wetetne oi bakomŋo watkeki, dokoine edangeik wane biririke arikoik. ");
INSERT INTO ons_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ariuk, eaka Yesuŋo numao marat ore more rake. “Peamŋo ŋirano payake.” Ere eŋane osino ariuk paki, kine masatka more bakomine kitokoik. ");
INSERT INTO ons_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pakiso Yesuŋo etane rake. “Ŋire misuk kaet ŋusiake, ŋire ariuk paki, naŋane kimakopne edanbik, eŋe Galili ariu paki, na baŋ yewa marat nanikei.” ");
INSERT INTO ons_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ŋerep etke ere numaka ariuk, kawali ŋei natne deŋesereo diam metkoi, eŋe mat suaino zinge ariu paki, pris ŋetne tanik kine kine wakonge, yewa edan warekoi. ");
INSERT INTO ons_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pakiso, pris ŋetne eŋe korop Yuda ŋei suaine eŋerop don au ma togolekoi, eŋe wesi kakapa suaine kawali ŋei ebongoi. ");
INSERT INTO ons_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Paki edane rakoi, “Ŋine rakei, ‘Ŋene kulu paŋem eŋine dokoine eŋe goigo sariu paki, pareŋine ea kobu ma arimi.’ ");
INSERT INTO ons_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","So ware ware suaine eŋe don kisi iwa mane desiakeo, yemo ŋene don natne baŋ olatkene, ŋine ea wane dere mezet baŋ mi okanikei.” ");
INSERT INTO ons_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kawali ŋei diam metkoi, eŋe wesi yewa mau paki, so don mane mi ra qelaŋangoi. Don kisi eaŋo Yuda ŋei edo rau sua arike, so naso iwao eŋe eaka ra gemami. ");
INSERT INTO ons_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Dokoine 11 eŋe Galili meŋo mane, Yesuŋo arikei wane edange ea arikoi. ");
INSERT INTO ons_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Paki, eŋe Yesu kau paki, eŋane kaitko umi qeu paki, bakomine kitokoi, ŋo natne eŋe wet etkeka okangoi. ");
INSERT INTO ons_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yale okanbi Yesuŋo osoeno sari edane rake, “Zonom kine kine qeli kotino so kepe kutno yemo korop na ninwareke. ");
INSERT INTO ons_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ea wane ŋine kepe baŋem ariu paki, ŋei magune magune dokone ebukei, paki Magak so Gipole so Asu Koboboinane eŋetko doku tau onikei. ");
INSERT INTO ons_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","So kito edanbi, eŋe don ra ŋidane okan gekole, ea tewek warekei. So ŋidanbe detpi, na naso baŋem ŋinerop ge magewe, kepe nasoine qoeake.” ");
INSERT INTO ons_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Papia iwa oŋo, eŋe Anutu wane gipole Yesu Kristo, eŋane sigi maep kieke ra wakonmaike. ");
INSERT INTO ons_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mikepka, Anutu wane qelit ŋei, Isaiaŋo, Yesu Kristo wane sigi maep kieke iwa yale qeke, “Anutuŋo rake, ‘Ge detnom! Na ŋei mane biraka more qebinkawe, oŋo naŋane don kisi ra qelaŋaniake, so geŋane numa maki wakoniake, so alakane gine more urataŋone ma ewekeake.’ ");
INSERT INTO ons_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kepe yaup papaino didi sawaŋ ŋeiine midaine, yewao ŋei yewa eŋe mere, ŋei mane wane aŋa, ŋei ŋerep boka edora more edane rake, ‘Ŋine Waom wane numaine mauluke more kito ma koboeu wesake digin qekep!’” ");
INSERT INTO ons_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Rakiso, naso kutno Yohane eŋe kepe yaup papaine didi sawaŋ ŋeiine midaine yewao wakone doku tauone more biŋek don iwa yale boka edange, “Ŋine gege mage me masi tanik kine kine ŋine qotkoine korop qeligeu paki wet mainge more ŋadekkauso na doku tauŋunikale. Pakiso, Anutu eŋe ŋinane borikine ŋine yewa yaleka qeliŋgi nigetkayake.” ");
INSERT INTO ons_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yale raki dere more, ŋei ŋerep louloutne, Yuda kepeo ŋine so Yerusalem mat suaino ŋine, warage Yohane wane don desikei wane arikoi. Eŋe dere more borikineene ra qelaŋane wet maingeuso, Yohane eŋe Yordan dokuŋo tauonge. ");
INSERT INTO ons_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohane eŋe iwa yale geokange. Takotine kamel ea wane zouneŋo mamaine, ea bira more so radeune kebaŋino makatake more, ŋaraine kubon so begok zikotno ŋine eaŋoka nemaŋke. ");
INSERT INTO ons_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohane eŋe biŋek don ŋei ŋerep iwa yale edange, “Ŋei mane ŋadeno sariake. Eŋane zonomineŋo yemo naŋane zonom yuannanmaike. Na ŋei bile mida namde eŋane qelit qeqemeine, noŋo aboŋ kite umatne kutno motpe mi rokopkeake. ");
INSERT INTO ons_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ŋo noŋo yemo doku tauŋunmaile, oŋo yemo yalewaka Anutu wane Asu Koboboineŋo tauŋuniake.” ");
INSERT INTO ons_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Naso maneo Yesu eŋe Nazaret mat qelige more, Galili kepeo ŋine Yordan dokuo sari lotkeki, Yohaneŋo Yordan dokuŋo eŋe taukake. ");
INSERT INTO ons_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Taukaki Yesu eŋe dokuo ŋine sa more, yewaka pore kaki, qeli aŋaŋgi Asu eŋe baluse naŋi yale ket Yesu eŋine kutno kitoke. ");
INSERT INTO ons_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pakiso, Waom wane boka woka mane qeliwo ŋine iwa yale bokaki ketke, “Ge naŋane gipon maepne, na wetneŋo lukgane malip ganlukmaile.” ");
INSERT INTO ons_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Eso naso yewaka Asuŋo Yesu ma birakaki, ŋei midaino kepe yaup papaino arike. ");
INSERT INTO ons_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ari more, ea goiŋ kaiwe 40 geke, naso yewa ŋei midaine kepe yaup papaineo, Ŋei Borikine, Borikine Welaine, Satanŋo sari Yesu liwekkake. Yesu eŋe osom zubaine eŋerop geke. Pakiso aŋelo edo sari qesiŋka more qelit qekakoi. ");
INSERT INTO ons_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohane eŋe mulap urumgo waketke, naso yewao, Yesu eŋe koso zinge Galili kepeo sari more Anutu wane biŋek don ra edange. ");
INSERT INTO ons_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Eŋe iwa yale rake, “Anutuŋo naso motke, ea mo iwa sari lotkemaike. Anutuŋo qeli ewe zonominane motke, iwa mo sarimaike. Ŋine borikine ŋine ŋadekka more, wet maingeu paki, biŋek don iwa dere malipkau!” ");
INSERT INTO ons_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu eŋe Galili doku namuŋ wazaino ari more, Saimon so ŋole Andrea potki ariki otke. Ere zawon wane kamaga etne doku namuŋ wazaino bira okorakoik Ere sola wane qesiŋ maratkakeik wane urataine yale naso baŋem togogoleka mamaŋkoik. ");
INSERT INTO ons_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Naso yewao Yesuŋo erano lotke mo etora etane more rake, “Ŋire sari naŋane ŋadeno mogat nanbik! Ŋire zawon ebuebu wane kine detlukkoik, pakimo, noŋo ŋei ŋerep ebu ebu wane kine kito ŋiponikale.” ");
INSERT INTO ons_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Rakiso, ere esatka kamaga qelige more, ŋadino mogare arikoik. ");
INSERT INTO ons_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu eŋe eri eri ari more, eŋe Zebedi wane medewetkine, Yakop so ŋole Yohane otke, ere seki kutno mere kamaga maulukkoik. ");
INSERT INTO ons_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu eŋe ore more boka etoraki, so ere magaetne, Zebedi so urata medewekoune qeliŋ onbik, seki kutno metpi, so ere sari more Yesu wane ŋadino mogare arikoik. ");
INSERT INTO ons_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pakiso, Yesu eŋine so dokoine ebuke, eŋe Kapaneam matko ari metkoi. Sarere kutno, zonom mama nasoo, Yesuŋo Yuda eŋane lewa lewaŋ urumgo ari more, ŋei ŋerep biŋek don kito edange. ");
INSERT INTO ons_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ŋei ŋerep edo eŋane miti kito ebo eboninane dere more, qisekoi so oŋaene qaeke. Eŋane kito ebon eboninane zonomineŋo kau, Anutu papa togon welaine ŋei, eŋetene Skribe, eŋane kito ebo ebon ea manerop yuanonge. ");
INSERT INTO ons_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Naso yewao, ŋei mane asu qotkoineŋo kotino weneŋ pake, eaŋo Yuda wane lewa lewaŋ urum koto saket more, oŋo togoleka boka rake, ");
INSERT INTO ons_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu, Nazaret matko ŋine, ge dalino okan ŋonikenane? Ge ŋene ŋengu matali ŋonikenane iwa sarimaine? Na detluk ganmaile! Ge ŋei koboboine Anutuŋo uratainane ra matoke biragangi Anutu eŋino ŋine sarimaine.” ");
INSERT INTO ons_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yale rakiso, Yesuŋo asu qotkoine yewa don okanka more olale rake, “Ge aŋaŋone ma waluke more ŋei yewa qeliŋ kanom!” ");
INSERT INTO ons_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Rakiso, asu qotkoineŋo ŋei togoleka rapap qepapkaki paki, suaine boka aro uŋanlan suaineka okane saket qeliŋka arike. ");
INSERT INTO ons_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pakiso, ŋei ŋerep eŋe oŋaene qaeki, done done au more rakoi, “Iwa onokaka? Kito ebo ebon musele me? Eŋe zonominerop ra togole asu qotkoine edangi, eŋe aŋaine tewekmami.” ");
INSERT INTO ons_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ea wane, Yesu wane don kisiŋo ari more esatka Galili kepeo korop rokopkeke. ");
INSERT INTO ons_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu eŋine so Yakop so Yohane eŋe Yuda wane lewa lewaŋ urum qelige ket more Petoro so Andrea eretne matko koboine ari waketkoi. ");
INSERT INTO ons_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon wane sewenine eŋe zoma suaine okane, papaino paki solaineŋo zok manerop gereune okangi, ŋei ŋerep edo ikopka Yesu olale rakoi, “Simon sewenine, eŋe zoma manerop okane, solaine wikile zok manerop wakonkamaike.” ");
INSERT INTO ons_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yale rau, Yesu eŋe eaka ari ŋerep metino ma qesiŋka more bukkaki wieke. Paki ŋerep ea eŋe solaine momo qe more menaŋkaki, eŋe eaka wie eŋane ŋara doku mauluke ebongi nekoi. ");
INSERT INTO ons_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Rarapko kepe deine qoe, ruo kereakane okangi, ŋei ŋerep eŋe zoma ŋei, so ŋei asu qotkoinerop, ea Yesu wano ebu sarikoi. ");
INSERT INTO ons_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mat suaine yewa wane ŋei ŋerep magu suaineŋo sari Simon wane mat tirino lewage qedugu metkoi. ");
INSERT INTO ons_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Metpi Yesu eŋe ŋei ŋerep zoma kine kineenerop ma menaŋone more, kotoeno asu qotkoinerop, ea esoponge, esopongi asu qotkoine eŋe Yesu wane kineine detluk kakoi. Pakiso Yesu eŋe eŋane kine rau mi sua ariakane, ra wetonge. ");
INSERT INTO ons_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pakimo Yesu eŋe kepe qae qae wane goigoka panaman weneŋ wie ket, mat qeliŋka more, kepe ŋei midaine yewao ari mere meŋenkake. ");
INSERT INTO ons_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Meŋenka metki, Simon eŋine so kimakoune, eŋe baŋ ŋado zuaŋka ari maratkakoi. ");
INSERT INTO ons_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Eŋe ari maratka more, iwa yale olale rakoi, “Ŋei ŋerep korop magu suaine eŋe ge zuaŋ ganmami!” ");
INSERT INTO ons_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Rauso, eŋe iwa yale mainge edange, “Iwamo ŋene mat suaine natne osop osop pamaike, ŋene ea lolike arikene, na eŋano weneŋ miti edanikalane nanmaike, na urata ea maikalane sarikole.” ");
INSERT INTO ons_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yale ra edane so, eŋe Galili kepeo lolike ge mat baŋem Yuda wane lewa lewaŋ urum metke, rokop miti edange, so asu qotkoine ea korop esoponge. ");
INSERT INTO ons_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ŋei mane kubet togonineropŋo Yesu wano wawetine qe qesonka more rake, “Ge naŋane simile ganmaikeo, yem ge maine naŋane kubetne iwa manom osiake!” ");
INSERT INTO ons_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yale rakiso, Yesu eŋe eŋane wet borik ma more metine bira solaino uaka mo olatke, “Na geŋane simile nanmaike, ea wane kubetŋone iwa osikep!” ");
INSERT INTO ons_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Olatkiso, esat naso yewaka kubet togonine ea osiki, solaine ea menage libe qeke. ");
INSERT INTO ons_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pakimo Yesuŋo ŋei ea don kukka ra qebinka more, iwa yale olatke, “Ge detlukkenom! Ge ari solaŋone menaŋmaike, ea wane donkisi ŋei mane misuk edanikene, asoze Moseŋo sogino iwa yale ra togoleke. Ŋei mane kubet togonine mo osi menaŋkakeso, eŋe mosop ŋei wano ari solaine sikankayake. Ge yalewaka mosop ŋei wano koboine ari more, solaŋone sikanka more bakom mannom paki arikene. Pakimo, ŋei ŋerep eŋe detgane raikei, eŋe solaine mo menaŋ kamaike.” ");
INSERT INTO ons_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Yale rakiso, Yesu eŋe don gereunerop olale qebinka birakaki arike. ");
INSERT INTO ons_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ŋo ŋei yewa eŋe ari more, don kisi yau yaup ra edane ariki eŋane don kisi eaŋo sua korop kepe baŋem rokopkeke. Pakiso, Yesu eŋe mat suaino ŋei ŋerep eŋane deeno koso mi ari lolikke, eŋe kepe ŋei midaino ari metke. Metkiso, ŋei ŋerep kepe baŋem ŋine edoka Yesu wano sarimaŋkoi. ");
INSERT INTO ons_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesu eŋe kaiwe mama karewe yewa geki qoekiso, Kapaneam mat suaino zinge ari lotkeke. Pakiso, naso yewao ŋei ŋerep edo don rau yauyaup ariki rakoi, “Yesu eŋe mo koso i sari matino metmaike.” ");
INSERT INTO ons_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Paki ŋei ŋerep eŋe esatka mat yewa wane kotino watke madetko so mat wazaino korop rokop ketwarekoi. Kepe ameŋine mane yaup mi pake. Naso yewao Yesu eŋe biŋek don edane okoraki, ");
INSERT INTO ons_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ŋei etke so etke eŋe zoma ŋei kie metine seuseune mane teweka sarikoi. ");
INSERT INTO ons_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mat mo ŋei ŋerep edo watke warekoi wane eŋe dalino Yesu wane osino ma waurap. Ŋaŋae more, tiriwoka teweke wa mat bakino Yesu metke kutnoken yewa kito barake more ŋei etke so etke eŋe mulapkoka mau qoroŋ qoroŋ ket zoma ŋei ea eŋe teweinerop Yesu wane osino rasu pake. ");
INSERT INTO ons_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu eŋe kaŋ qae wie pore ŋei etke so etke, eŋe one more eŋane mali malipene detone more Yesuŋo zoma ŋei olale rake, “Medepna, na geŋane masi qotkoine makone eamo ma qeliŋkawe arimaike.” ");
INSERT INTO ons_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yale ra olatkiso, Anutu papa togon welaine ŋei natne, Skribe, eŋe Yesu wane osino mere detpi, dereretene mi kopkeke, ");
INSERT INTO ons_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Dalino wane ŋei yewa eŋe don yaline ramaike? Eŋe Anutu yuanka more eŋane met met mayakane okanmaike me? Eŋe detki eŋine Anutu yale okanmaike? Ŋei maneŋo mane wane sot maine mi qeliŋkayake, Anutu wekuŋo ŋei mane wane sot turuŋ qotkoine ea makoke ma menaŋ ŋoniake!” ");
INSERT INTO ons_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu eŋe yewaka dereretene detone more, iwa yale edange, “Onoka wane ŋine dereret yaline detmami? ");
INSERT INTO ons_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Na zoma ŋei yewa don ewekine dalino yale olasikale? Na olale raikale, na sotŋone mo qeliŋkawe siukamaike, me ge wie menage more uamŋone ma more arinom? ");
INSERT INTO ons_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ea wane ŋine na detluk nanbi, na Ŋei Wawainane Gipole. Na nae tunno kepeo ŋei ŋerep eŋane sotene eamo qeliŋkawe suikwaremaike.” Yesu eŋe yale ra more, zoma ŋei olale rake, ");
INSERT INTO ons_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Wie, uamŋone ma more matŋono arinom!” ");
INSERT INTO ons_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pakiso, zoma ŋei yewa eŋe ŋei ŋerep eŋane kaiteno ikopka wie more, uamine rutupke more, kolopke ket arike. Ŋei ŋerep eŋe korop oŋaene qaekiso Anutu wane eŋetine ora bukeu waki rakoi, “Sogino kine kine mane iwa yaline mi kakone, i midakaka!” ");
INSERT INTO ons_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yale rauso, Yesu eŋe koso Galili doku namuŋ mezeno zinge arike. Ariki ŋei ŋerep magu suaine eŋe sari Yesu wano qeduguwi eŋe miti don kito edange. ");
INSERT INTO ons_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yesuŋo eŋe ea ŋine ari more, Lewi eŋe takis wesi mama mat koto metki olale ka more rake, “Lewi ge ket ŋadeno mogatnane sarinom!” Raki, Lewi eŋe yewaka wie more, wesi mama urataine ea qelige more, eaka Yesu wane ŋadino mogatka arike. ");
INSERT INTO ons_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pakiso, boaŋ Yesu eŋe Lewi wane matko ŋara mere neke. Naso yewao takis mama ŋei loutne so ŋei sotenerop natne eŋe Yesu eŋine so dokoine eŋerop weneŋ mere ŋara nekoi. ");
INSERT INTO ons_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ne metpi, naso yewao Anutu wane papa togon welaine ŋei natne, Parisi, eŋe Yesu kau takis mama ŋei so ŋei sotenerop eŋe weneŋ metki one more, Yesu eŋine dokoine qeson one more rakoi, “Eŋe eamo onoka wane ŋei qotkoine eŋerop mere ŋara nemaike?” ");
INSERT INTO ons_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Rauso, Yesu eŋe detone more rake, “Maŋo mauluk mauluk ŋei eŋane ari okanmaike? Zomaenerop, me, zomaene midaineŋo? Na ŋei yaline eŋane ra more sarikole. Ŋei sotenerop zuaŋone more ebu qesiŋ onikalane sarikole. Na ŋei dereretenane detpi koboine okanmaike, eŋe qesiŋ onikalane mi sarikole.” ");
INSERT INTO ons_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naso maneo, Yohane doku tau tau wane dokoine so Anutu papa togon welaine ŋei, Parisi, eŋane dokoene eŋe ŋara sawe gekoi. Naso yewao ŋei ŋerep natne eŋe sari Yesu qesonka rakoi, “Yohane wane dokoine so Anutu papa togon welaine ŋei, Parisi, eŋane dokoene eŋe ŋara sawe gemami. Ŋo, daleo wane geŋane dokoŋone eŋe yale mi okanmami?” ");
INSERT INTO ons_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yale rauso, Yesuŋo mainge more edane rake, “Ŋei mane eŋe zokit mayakane rayakeo, ŋei kima koune, eŋe maine ŋara sawe mesikei me? Yale mida, eŋe zokit mayakane okaniakeo, ŋei kimakoune eŋe maine eŋerop ŋara oi bakom weneŋ mesikei, so kimakoune eŋe ŋara wane sawe mane mi okanikei. ");
INSERT INTO ons_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Na ŋei qaluwit yewa eŋane rokop. Baŋ, naso maneo ŋei edo na neuwi ariwe dokone eŋe koso na mi nanikei, naso yewao eŋe maine ŋara wane sawe gekei.” ");
INSERT INTO ons_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesu eŋe koso takotke rokop don mane rake, “Takot mane toeki aŋaine okoraki laplap musele mane wane sisineŋo more maine mi qetusikene. Yewa siluŋ qetusikeneo, yemo lap lap sisine museleŋo tebakaki, takot sogine ea toe aŋap suaine wakoniake. ");
INSERT INTO ons_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ŋo mane maŋo wain musele ea qeki koso nomare sogine yewao kesiake.Eŋe yalewa okangi, yemo wainŋo ket qebinkaki, nomare ea muzugeake. Pakimo, nomare so wain ere weneŋ mida lelekeik, ea wane wain musele eŋe eŋine nomare muselo ketki, eamo menageake.” ");
INSERT INTO ons_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Qezarek naso maneo, Yesu eŋine so dokoine eŋe wit eu kotinoka ari more dokoine edo wit wele natne siwekoi. ");
INSERT INTO ons_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pakiso, Anutu papa togon welaine ŋei, Parisi, edo one more Yesu qeson kakoi, “Ge onnom! Geŋane dokoŋone eŋe wit siwe nemami. Dokoŋone eŋe masi yewa ŋenane ra rokop dongo yemo okane more sot kaukmami. Qezarek naso yewao mi maikei, yewa ŋenane ŋabozane rara togon don.” ");
INSERT INTO ons_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yale rauso, Yesuŋo donene mainge edange, “Mo sogino asoze Dawit, Israel Ware Ware, eŋine so dokoine eŋe ŋaraenane seuke more ");
INSERT INTO ons_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ari Anutu wane Bakom Urum koto waket more, bret yewao ŋine mi mamaine, eamo ra togoleke, ea ma nekoi. Bret yewa Anutu wane bakom kitokenane. Naso yewao, Abiata Anutu wane mosop ŋei eŋe lewet geke. Ŋenane ra rokop don ra togoleki mosop ŋei edoka bret yewa ne okangoi, ŋo Dawit eŋe yewa ne more dokoine ebongi nekoi.” ");
INSERT INTO ons_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu eŋe koso edange, “Anutu eŋe mikepka ŋei so ŋerep ma wakonotki paki, erane ra more ŋadino qezarek naso yewa baŋ motke. Qezarekŋo mawakongi paki, ŋei so ŋerep mi ma wakonge, naso yewaŋo ŋei ŋerep qesiŋ osiakane motke. Me naso yewaŋo ŋei ŋerep matali osiakane mi motke. ");
INSERT INTO ons_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ea wane, na Ŋei Wawainane Gipoleŋo yalewaka qezarek naso ea wane Waom, so noŋo ea wane welaine.” ");
INSERT INTO ons_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Naso maneo, Yesu eŋe koso zinge ari Anutu wane lewalewaŋ urum koto waketke. Ŋei mane yewa metke, eŋe metine nat paromineŋo setneka marap maraune. ");
INSERT INTO ons_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ŋei natne eŋe Yesu kau sariki diamine mau paki, iwa yale rakoi, “Yesu eŋe qezarek nasoo zoma ŋei metine marap maraune iwa maine ma menaŋ kayake me mida. Eŋe ma menaŋ kayakeo, yemo ŋene Yesu dongo birakaikene.” ");
INSERT INTO ons_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu eŋe zoma ŋei yewa metine borikine, eŋe olale more rake, “Ge meteŋone borikine, yalinane iwa wie sari okoranom!” ");
INSERT INTO ons_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pakiso, eŋe ŋei ŋerep qeson one rake, “Ŋenze ra rokop don eŋe qezarek naso wane don dalino mawalukke? Masi maine maikene me qotkoine? Ŋene ŋei ŋerep gegeene ma menaŋ onikene me ŋei ŋerep enguŋem seukkei?” Qesonongi, edo dere more don mane mi mainge olatkoi. ");
INSERT INTO ons_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pakimo Yesu eŋe deine pore lolike more ongi eŋe dereretene won geki doneene midaine metkoi, ea wane Yesu eŋe ikopka sotine osiki koso dere umare onge. Pakiso, Yesu eŋe zoma ŋei olale rake, “Ge meteŋone birakanom!” Eŋe metine biraki, eaka ikopka menanŋkake. ");
INSERT INTO ons_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yale okangiso, Parisi eŋe ikopka Anutu wane lewa lewaŋ urum qeliŋka more wie saket ari Herot wane tego eŋerop lewage more, Yesu eŋe numa ea me ea maratka more qeu seukeakane done aukoi. ");
INSERT INTO ons_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu eŋe dokoine eŋerop wie mat yewa qeligeu paki, Galili wane doku namuŋ pamaike, yewa arikoi. Pakimo ŋei ŋerep magu tego kakapa suaineŋo wie eŋe mogatka arikoi. Ŋei ŋerep magu suaine yewa eŋe kepe baŋem ŋine sarikoi. ");
INSERT INTO ons_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Galili kepeo ŋine, Yuda kepeo ŋine, Yerusalem mat suaino ŋine, Idumia kepeo ŋine, Yordan kepe sasaino ŋine, Tire so Sidon kepeo ŋine. Ŋei ŋerep magu suaine yewa eŋe Yesuŋo urata kine kine maki detka more eŋano sarikoi. ");
INSERT INTO ons_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Magu suaine zok manerop Yesu watke more, gitit kaikei wane okanbi eŋe dokoine eŋane rake, “Ŋine ari seki mane ikopka mauluke ma sariu, yaup warenan metkep! Ŋei ŋerepŋo magu suaine okanbi, so na ea wane kutno wa more toe, ŋei ŋerep biraone eri kere, amaŋ naeka toe mesikale.” ");
INSERT INTO ons_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sogino mo Yesu eŋe ŋei ŋerep loutne ma menaŋ onge, ea wane ŋei ŋerep zomaenerop eŋe edom meteeneŋo solaine makei wane onge, pakimo ea wane eŋe kimakopeene qepodon onbi sari, Yesu sola takotino uakaikei wane okangoi. ");
INSERT INTO ons_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Naso natneo ŋei ŋerep asu qotkoinerop eŋe Yesu ka more ari kepeo ket rasu pa more boka aroke ora rakoi, “Ge, Anutu wane Gipole!” ");
INSERT INTO ons_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yale rau, Yesu eŋe asu qotkoine togogoleka ra togole ongi paki eŋe ma, ea tingo me didiwo eŋane eŋetine zok mi rau suayakane rawetonge. ");
INSERT INTO ons_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pakiso, Yesu eŋe weti bonagao wake, naso eao wie more, ŋei natne eŋerop gekei wane ma wakononge, ŋei ea eŋe edoraki eŋano sarikoi. ");
INSERT INTO ons_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Pakimo eŋe ŋei magu 12 ma wakononge, ŋei yewaŋo eŋinerop gekei wane, ma wakon one more, eŋeteene aposolo edorake, so eŋe bira ongi ari ŋei ŋerep eŋano biŋek don ra qelaŋanikei wane rake. ");
INSERT INTO ons_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yesu eŋe ŋei 12 yewa eŋine tungo asu qotkoine esop onikei wane zonom takot onge. ");
INSERT INTO ons_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yesu dokoine eŋane eŋet tegoene iwa yale ebonge. Simon, eŋetine mane Petoro orake. ");
INSERT INTO ons_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedi wane gipole Yakop, eŋine so ŋole Yohane, erane eŋeteetne mane Boanerges etorake. Eŋet yewa wane kine, quruŋ qilap. ");
INSERT INTO ons_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrea, so Pilip, Bartolomu, Mataio, Tomas, Yakop, Alpius wane gipole, so Tadius so Saimon Zelot. ");
INSERT INTO ons_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ŋo Yudas Iskariot, ŋei yewaŋo Yesu ŋaba eŋane meteeno masi qotkoine okan kaikei wane ma wakonka birakake. ");
INSERT INTO ons_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pakiso, Yesu eŋe matko ariki ŋei ŋerep magu suaineŋo eŋano koso sari lewaŋgoi. Ea wane Yesu, eŋine so dokoine eŋe qeka more, dalino ŋara mane neurap. ");
INSERT INTO ons_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesuŋo kine kine okange so make, ea wane tego tanik manik ea ŋei eŋe ra suau dere more weneŋ tutulekoune, eŋe Yesu ma walukka more, iwenkaikei wane sarikoi. Tutulekoune eŋe iwa yale rakoi, “Eŋe mo qelaŋ qemaike!” ");
INSERT INTO ons_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Anutu papa togon welaine ŋei natne, Skribe, eŋe Yerusalem ŋine ket more rakoi, “Eŋe kotino Belzebul, eŋetine mane Satanŋo okoramaike. Eŋe Belzebul wane zonomgo so oŋo qesiŋkaki, asu qotkoine ea esoponmaike, eaŋo asu qotkoine eŋane ware ware.” ");
INSERT INTO ons_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Eŋe yale rauso, Yesu eŋe edoraki osino sari metpiso don rokop mane more edane rake, “Satan oŋomka dalino Satan osop kayake? ");
INSERT INTO ons_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ŋei ŋerep kaunsol mane wane magu eŋe wiri magu etke okane more yakukei, kaunsol ea wane zonomine eamo midayake. ");
INSERT INTO ons_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ŋo ŋei urumene weku eŋe wiri more magu etke okane more kawali yakukei, ŋei yewa eŋe koso togole qeturage maine weku mi lele gekei. ");
INSERT INTO ons_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ŋo Satan eŋe eŋine magu ŋaba okan oniake, eŋe wiri more zonomene midayake.” ");
INSERT INTO ons_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yesu eŋe koso don iwa yale takotke rake, “Satan ŋei zonomine suaine, eŋane urata wane aboŋ kine kineine yaup maine mi ari maikene, yemo midakaka. Mikep eŋine kie metine wokomka more ŋado maine eŋane mat koto wa more, urata wane aboŋ kine kineine pamaike, yewa matali onikene. ");
INSERT INTO ons_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Na ŋine don wele iwa yale ŋidanbe, Anutu eŋe ŋei ŋerep eŋane masi tanik qotkoine kine kine so don dereret borikine ramami, yewa eŋe korop qeliŋgi siukeake. ");
INSERT INTO ons_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ŋo ŋei mane eŋe Anutu wane Asu Koboboine ra matali okan kayakeo, yemo ukude Anutuŋo eŋane sot ea mi qeliŋgi siukeake. Eŋane borikinane sot turuŋ ea qoi qoine midaine motki pamageake.” ");
INSERT INTO ons_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu eŋe don yale ra edangane Anutu wane papa togon don welaine ŋei eŋe rakoi, “Yesu eŋe mo kotino asu qotkoineŋo ketke okoramaike.” ");
INSERT INTO ons_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Naso yewao Yesu wane nagaine, so ŋonqaine eŋe sari lotke more mat wazaino okora more don motpi wake, Yesuŋo saket oniakane. ");
INSERT INTO ons_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pakimo, ŋei ŋerep magu suaine eŋe Yesu lolikka metkoi, edo olale rakoi, “Ge detnom! Geŋane nagaŋone, so ŋonqakopŋone eŋe qeinat, mat wazaino okora more goŋo kesikenane ramami.” ");
INSERT INTO ons_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yalewa rau, Yesu eŋe mainge edane rake, “Maŋo naŋane nagane, so ŋonqane?” ");
INSERT INTO ons_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Eŋe deine ŋei ŋerep lolikka metkoi, eŋe one more, enanoka pore ongi paki rake, “Onbi! Iwa edo naŋane nagane so ŋonqane okanmami. ");
INSERT INTO ons_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ŋei me ŋerep mane eŋe Anutu wane don dere eŋane simile mogasikei, ea ŋo naŋane nagane so ŋonqane okanmami.” ");
INSERT INTO ons_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pakimo, Yesu eŋe koso kito ebo ebon urataine takotke more, Galili doku namuŋ wane qalakino ŋei ŋerep kito ebonge. Pakiso ŋei ŋerep zok tego suaineŋo sari eŋano manerop lewage more watke Yesu lolikkau eŋe kepo qelige ari seki mane kutno wa more ŋei ŋerep biraone weti toe namuŋgo wa eŋineka metke. Metkiso, ŋei ŋerep magu eŋe qalakino lewage okorakoi. ");
INSERT INTO ons_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Eŋe yalewa okorau, Yesu eŋe don rokop mane kito more edane rake, ");
INSERT INTO ons_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ŋine detpi! Ŋei mane eŋe euo wit ebosiakane arike. ");
INSERT INTO ons_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Eŋe wit woune natne euo ebotke, pakimo, natne ari numao kito metki naŋi edo sari nekoi. ");
INSERT INTO ons_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Woune natne ari kepe wesi tabilainerop kepe ewekine yewa wane kutno ket kito ikopka poripke wiekoi. ");
INSERT INTO ons_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wane kaiwe suaine sa more wit komine yewa ezoke. Ŋodoene yewa qei mi ketlukke kepe wesi tabilainerop ea wane komine ururuke seukkoi. ");
INSERT INTO ons_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wit woune natne touk okolerop ea wane koto ket kitokoi. Wane touk okolerop yewaŋo ikop wie more pise walip onge. Walip ongiso, wit wele maine mi qekoi. ");
INSERT INTO ons_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ŋo, wit woune natne kepe gukinerop yewao ket kitokoi. Ket kito more, komine poripke sua more wele maine qekoi. Wele natne 30, natne edo 60, natne edo zok 100 yaline qekoi.” ");
INSERT INTO ons_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ea wane Yesu eŋe edange, “Ŋei me ŋerep mane eŋe ketineropŋo yemo don iwa dere malipka more, kine detlukkayake.” ");
INSERT INTO ons_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ŋei ŋerep magu suaine eŋe biraone ari warekoi, naso yewao Yesu eŋineka metki, eŋine dokoine 12 eŋe so ŋei natne mo Yesurop weneŋ ge okangoi, eŋe Yesu wane don raki detkakoi, ea wane eŋano sari qesonka rakoi, “Ge don rokop more rene ea ra qelaŋane ŋedannom detŋem.” ");
INSERT INTO ons_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu eŋe mainge rake, “Anutuŋo don sanine so qeli ewe zonominane kine so ŋine dalino ware ŋunmaike, na ŋine ea desikei wane ŋidanmaile. Ŋei ŋerep natne ŋadino gemami eŋe naŋane don, ea don rokopkoka kito more edan edan wane raraine, ea wane rokop na korop kito edanbe, eŋe detwaremami. ");
INSERT INTO ons_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yalewa wane, ‘Eŋe deeneŋo kaikei, ŋo, eŋe kine kine maine mi kau qelaŋaniake. Eŋe keteneŋo maine desikei, ŋo, eŋe kine maine mi detlukkei, so weteeno mi maingeu, soteene pa eboniake. Ea wane eŋe wet maingeu, Anutuŋo eŋane sot qelingi siukeake.’” ");
INSERT INTO ons_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pakiso, Yesu eŋe qesonone rake, “Ŋine don rokop kito more rele, yewa koso maine weneŋ detlukkamami me? Pakimo, ŋine don rokop korop yewa wane kine dalino det lukkaikei? ");
INSERT INTO ons_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ŋei wit woune ebotmaike, ea eŋe Anutu wane don oŋom ebotmaike. ");
INSERT INTO ons_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Woune natne dumao ket kitoke, ea yemo ŋei ŋerep natne eŋe Anutu wane don detpi, kotoeno ketki, nasomde bamgoka, Satan eŋe sari Anutu wane don ea ŋei ŋerep natne eŋane kotoeno yasoke, ea ma biraki saket ariake. ");
INSERT INTO ons_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Woune natne kepe kutka, wesi tabila weneŋ, ea wane kutno ket kitoke, eamo ŋei ŋerep natne eŋe Anutu wane don ikop dere ma more bakom kitokei. ");
INSERT INTO ons_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ŋo, eŋe ŋodine qeirop mi ket ma qotke mesiake. Eŋe kutka metki, ŋaba edo biŋek don wane umat natne wikilerop ebonbi, eŋe koso Anutu ŋadekkaikei. ");
INSERT INTO ons_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Woune natne eŋe touk okolerop ea wane keune ket kitokoi, eamo ŋei ŋerep natne eŋe Anutu wane don detkoi. ");
INSERT INTO ons_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ŋo, kepe kutno gege wane umat so wesi aboŋ suaine maratka maratka, so kine kine natne, ea wane bailalaŋ, eaŋo ŋei ŋerep eŋane kotoeno waket more, Anutu wane don kotoeno piseka more ma qorokka more, ma pelek kaki siukke, ea wane wele maine mi qekoi. ");
INSERT INTO ons_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ŋo woune natne kepe kelokinerpko eao ket kitokoi, eamo ŋei ŋerep natne eŋe Anutu wane don dere more malipka lukeu paki, ma qotkakoi. Ea wane eŋe wele maine qekoi, wele natne 30, natne 60, natne 100 yale qekoi.” ");
INSERT INTO ons_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Pakiso, Yesu eŋe koso rake, “Ŋei mane kiwa kuake more diao qeki okorayake? Lase bano me rosaŋo more supaki mesiake? Mida! Eŋe kiwake more qeki zake kutno didiwo okora korop qelaŋanoniake. ");
INSERT INTO ons_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yalewaka, kine kine korop sane pamaike, ea na ŋado didiwo mawe wakon wareake. So kine kine natne supawe metmaike, ea ŋado na ma lalagewe didiwo wakon wareake. ");
INSERT INTO ons_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ŋei me ŋerep mane eŋe ketineropŋo don iwa wane kine dere more malipka lukki paki, korop detka wareake.” ");
INSERT INTO ons_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yale ra more eŋe koso edane rake, “Ŋine dere more kaulukkei! Ŋine ŋei ŋerep eŋano urata kine kine mauluke ebonikeiwo, Anutu eŋe yalewaka ŋine mauluke ŋibone more koso manerop takotke yuanka maulukŋune ŋiboniake.Ŋo, ŋine ŋei ŋerep matali ebonikeiwo, Anutu eŋe ŋine yalewaka mataliŋune more koso manerop yuanka mataliŋune ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Anutu eŋe ŋei me ŋerep mane kine kine mo mangi make, ea togoleka malipka geakeo, eŋe koso takotke mane more ma sua maniake. Ŋo, ŋei mane eŋe Anutu kine kine nigatne mange, ea mi mauluke wareka mageakeo, yemo Anutu eŋe ŋei yewa wane kine kine mange, ea koropka omaka wareake.” ");
INSERT INTO ons_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu eŋe koso rake, “Anutuŋo ware ŋunmaike, ea wane tanikine iwa yale. Ŋei mane eŋe kine kine woune euo ebore more, ");
INSERT INTO ons_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","eŋine matko ari toma geake. Ŋo eŋe mi detkamaike, wele dalino eu koto wakonmaike. Pakimo, woune ea eŋe poripke sayake. ");
INSERT INTO ons_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Saki, kepe oŋomka komine mapitkaki sua wele qeake. Mikepka kau saraine so pizulumine. Ŋadino wit wele wakone more menage laŋeniake. ");
INSERT INTO ons_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wit wele laŋengi, ŋei eŋe kieke pilaŋŋo kitatmaike.” ");
INSERT INTO ons_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu eŋe koso takotke more ŋei ŋerep qesonone more rake, “Na Anutuŋo wane miti me qeli ewe zonom wane numa ea mo kine kine mane onokakao rokop kitowe, takotke more ra qelaŋanikale? ");
INSERT INTO ons_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Eŋe eamo mastet woune yale, nigatnemde okanmaike. Mastet woune nigatnemde kine kine natnane woune me waetne yuane more zok manerop, nigatne okanmaike. Yalinane mastet woune ea ŋei manŋo euine ebotke. ");
INSERT INTO ons_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pakimo, eŋe poripke more, sua eu kotino ŋara nenine natne korop yuanone more, eŋe wie weti wa qogine qe mesiake. Pakimo, naŋi eŋe sari wa more naune koto matene kito more mesikei.” ");
INSERT INTO ons_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu eŋe don rokop kine kine loutne iwa more ŋei ŋerep ra edange. Ŋei ŋerep edo dere qelaŋanikei wane Yesu eŋe dereretene rokouno edange. ");
INSERT INTO ons_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yesu eŋe ŋei ŋerep don rokop eaka edane okange. Ŋo, eŋe dokoine eŋerop mere more, don rokop wane kine ra qelaŋane edane okange. ");
INSERT INTO ons_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Naso mane kepe qoiqoiwo, Yesu eŋe dokoine edane rake, “Ŋene sekiwo wa more, doku namuŋ kitare erinat ariŋem.” ");
INSERT INTO ons_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Raki, eŋe ŋei ŋerep magu suaine yewa qeliŋone more, Yesu alakane wa metkiso, dokoine eŋe ŋado seki yewa wane kutno wa more, eŋe weneŋ ma ariuso, seki natne eŋe weneŋ eŋerop arikoi. ");
INSERT INTO ons_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ariu, ikopka dibom suaine wie more seki koto kiwet qakki ket watke ma murugeakane okange. ");
INSERT INTO ons_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu eŋe seki sotno qaliŋan more kulu pake. Dokoine eŋe ari ma wirikka rakoi, “Kito ŋebo ŋebon ŋene zok bori more seukkenane okanmaine! Ge onoka wane mi det ŋonmaine?” ");
INSERT INTO ons_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu eŋe wie more togoleka kuroge momo olatke, “Doŋ mannom!” Ra more eŋe dibom olatke, “Ge, tikŋane doŋ mane panom!” Rakiso momo eŋe doŋ mangi, so dibom eŋe yaleka tik doŋ mane kaloŋ suaine pake. ");
INSERT INTO ons_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pakiso, Yesu eŋe dokoine edane rake, “Ŋine onoka wane kaet okanmami? Ŋine malip malipŋine mida me?” ");
INSERT INTO ons_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eŋe kaet suaine okane more, enŋene auye rakoi, “Ŋei iwa eŋe zok ŋei kine mane! Naso bano ŋei ŋerep zoma kubetenerop so asuene qotkoine ma menaŋonge, wane koso iwa momo so dibom suaine iwa don etangi, ere done detka more qeliŋmamik!” ");
INSERT INTO ons_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kaloŋ okangi, Yesu so dokoine eŋe Galili Namuŋ erinat ari lotkekoi, kepe yewa eŋetine Gerasa. ");
INSERT INTO ons_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu eŋe seki qeliŋka ketki, yewaka ŋei mane eŋe deŋesere wane kezem aŋaino ŋine sari qalakko okoraki maratkake. Ŋei yewa eŋe asu qotkoineŋo kotino pake. ");
INSERT INTO ons_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Eŋe deŋesere koto geokange, pakiso ŋei maneŋo ŋei yewa maine mi ma walukkake me mulap togogoleŋo kine metine lukkakoi, eŋe mi detke. ");
INSERT INTO ons_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Naso loutne ŋei ŋerep eŋe ma more, kie metine mulap togoleŋo wokom kamaŋkoi, ŋo, naso baŋem eŋe mulap togole metino ea romatkeki qoe okange, so eŋe mulap togole kieino ea ratokmaŋke. Ŋei ea wane zonomineŋo manerop kakapa suaine okane, ŋei korop yuanonge, ea wane ŋei maneŋo maine mi ma walukkake. ");
INSERT INTO ons_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Naso baŋem goiŋ kaiwe ŋei yewa eŋe deŋesere koto so tobo zikotne bonagao yau yaup lolike ari ari, sari sari, okorake, so bokaki paki, kuroge oŋom ari kitoki, solaine eki so wesiŋo kitat qetat mamaŋke. ");
INSERT INTO ons_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Naso eao ŋei yewa eŋe abaranka okora pore kaki, Yesu eŋe sekiwo kiroine eri sariki, eŋe ikopka biririke sari qalakko Yesu ketki, eŋano wawetine qeke. ");
INSERT INTO ons_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Asu qotkoine yewa, eŋe Yesu wano aroine suaine aroke rake, “Yesu, ge Anutu Suaine Wetika Weti, eŋane gipole! Ge na dalino okan nanikene? Na Anutu wane kaitko meŋen ganmaile. Goŋo na matalinane more wikile zok misuk ninikene!” ");
INSERT INTO ons_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Eŋe yale waka rake, ea yemo Yesuŋo asu qotkoine yewa olale rake, “Asu qotkoine, ge ŋei yewa qeliŋka arinom!” ");
INSERT INTO ons_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pakiso, Yesuŋo qesonkake, “Ge, eŋetŋone ma?” Asu qotkoine eŋe rake, “Ŋene eŋetze, kawali ŋei, ŋene magu suaine, ea wane asu qotkoine ŋene louloutneŋo ŋei iwa wane kotino metmaine.” ");
INSERT INTO ons_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pakiso, eŋe koso Yesu sorinka rake, “Kepe iwa ŋine misuk osopŋonnom arikene.” ");
INSERT INTO ons_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Berek magu suaine eŋe meŋo erinat ea ŋara ne gekoi. ");
INSERT INTO ons_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ea wane asu qotkoine eŋe Yesu togogoleka sorinka rakoi, “Ŋene ŋebu biraŋonnom ari berek eŋane kotoeno maine wakesikene!” ");
INSERT INTO ons_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu eŋe dere more, asu qotkoine edane rake, “Maine ŋine yewa arikei.” Rakiso, Asu qotkoine eŋe ŋei yewa qeliŋka more, saket ari berek eŋane kotoeno waketkoi, waketpi, berek magu suaine yewa eŋe biririke ari korop sorao sontake ket dokuo qok ne more seukwarekoi. Berek magu suaine kibiene2,000. ");
INSERT INTO ons_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Berek ware ware eŋe masi ea kau paki, kaetongi, korop ket ari more matko matko so kepe saiwo ŋei ŋerep donkisi edangoi. Pakiso ŋei ŋerep louloutne eŋe ari berek seukkoi ea ongoi. ");
INSERT INTO ons_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Eŋe koso Yesu wano ari more, ŋei yewa kau eŋe sogino asu qotkoineŋo matalikaki geke, ea eŋe maine lap lap ramu more wetine lotkeki tik ŋaneŋ metke. Naso yewao ŋei ŋerep eŋe ka more kaet onge. ");
INSERT INTO ons_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ea wane berek ware ware edo qelaŋ ŋei asu qotkoinerop eŋane so berek seu seuenane kine ra qelaŋane ŋei ŋerep magu yewa edangoi. ");
INSERT INTO ons_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ea wane ŋei ŋerep eŋe dere more, koropŋo Yesu wane don togole iwa rakoi, Yesu eŋe ikopka ŋenane kepe mat iwa qeligeso kepe mat maneo ariake. ");
INSERT INTO ons_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu eŋe seki koto waketkiso, ŋei yewa sogino asu qotkoinerop geke, eŋe Yesuerop arikeik wane sorinkake. ");
INSERT INTO ons_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ŋo, Yesu eŋe ŋei yewa ma kitatka rake, “Ge zinge matŋono ari more nabok magak so weŋem sotawekopŋone, kine kine solaŋono Waomŋo mamaike so Anutu wane wet borik suaine geŋane solaŋono wakonmaike, ea wane donkisi edannom.” ");
INSERT INTO ons_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yale olatkiso, ŋei yewa eŋe zinge ari more mat suaine mete etke, 10, yaline yewao korop lolike ge more solaine Yesuŋo maulukkake, ea wane ra qelaŋane edane arike. Ŋei ŋerep eŋe dere more oŋaene qaeke. Kepe iwa eŋetine, Mat Suaine Mete Etke. ");
INSERT INTO ons_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pakiso, Yesu eŋine so dokoine, eŋe koso doku namuŋ ratoke erinat ariuso ŋei ŋerep magu suaine eŋe mo sari qalakko lewage metkoi. ");
INSERT INTO ons_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yairus eŋe mat yewa wane Yuda wane lewa lewaŋ urum wane ŋetne, oŋo sari more Yesu wane osino kino pese ket wawetine qe more ");
INSERT INTO ons_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yesu qesonka more zok arokke. “Borasone nigatne mo bomitne seukeakane okanmaike. Ge sari more meteŋone kutno motnom, zoma yewa qeliŋkaki eŋe maine koso menageake.” ");
INSERT INTO ons_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pakiso, Yesu eŋe ŋei yewa eŋerop ariukso ŋei ŋerep louloutne eŋe watke lolikka arikoi. ");
INSERT INTO ons_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pakiso, ŋerep mane eŋe ŋerep zoma weneŋ. ");
INSERT INTO ons_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Zoma yewa naso baŋem metokangi, komaine 12 okangiso eŋe wesiine zoma yewa wane ra more mauluk mauluk eŋano biraki midakakae, ŋo, eŋe maine mi ma menaŋ kakoi. Eŋe wikile zok takotke manbi, zoma eaŋo sari suakake. ");
INSERT INTO ons_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Pakiso, ŋerep yewa eŋe Yesu wane siron dere more sari ŋei ŋerep magu suaine yewa eŋane keueno Yesu maratka osino sari more iwa yale detke. ");
INSERT INTO ons_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Na meteneŋo eŋano uakaikale me takotino maineka mosikale, pakiso nae koso menaŋgale.” ");
INSERT INTO ons_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Eso ŋerep yewa eŋe metine Yesu wane laplapko uaka more yewaka detki mo maine menaŋkake. Pakiso, ŋerep zoma yewa mo midakakae. ");
INSERT INTO ons_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu eŋe naso bomitne yemdaka detki zonomine natne ketki, ikop zinge eŋe qesononge. “Maŋo metine naŋane takotko uakeke?” ");
INSERT INTO ons_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Raki dokoine edo done mainge rakoi. “Ŋei louloutne edo wonge maguk ganbi, ge onoka wane don yaline qesonŋonmaine? Ŋene mi detmaine maŋo ŋei loutneŋo meteene laplap ŋono ua ganmami.” ");
INSERT INTO ons_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yale rau, Yesu eŋe pore lolike onge, ea maŋo laplapino make ea maratkayakane okange. ");
INSERT INTO ons_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pakiso, ŋerep yewa eŋe Yesu takotino uakaki zomaine midakakae, yewa wane dere zok zonomine oreki kaetkake. Paki, eŋe Yesu wane osino sari pese wawetine qe ket more okange, yewa wane kine olatke. ");
INSERT INTO ons_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Pakiso, Yesuŋo eŋe olatke, “Borasone, malip malipŋoneŋo zomaŋone yewa ma ewek ganmaike. Ea wane ge maine ari more wet maepko gekene. Zomaŋone mo korop midawaremaike.” ");
INSERT INTO ons_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu eŋe ŋerep don olale okoraki, naso yewaka ŋei natne eŋe Yairus wane matko ŋine mat qelige sari olale rakoi, “Ge! Borasoŋone nigatne mo seukmaike. Yesu mi iwenka sarikene yeine. Eŋe maine mi ma wirik kayake.” ");
INSERT INTO ons_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ŋo, Yesu eŋe eŋane don wane ket mi more so, eŋe Yairus olatke, “Ge misuk kaet gangep! Ge mali malipŋone togolekep!” ");
INSERT INTO ons_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu eŋe yale ra more ŋei ŋerep mawaluk one more Petoro so Yakop, so eŋane ŋole Yohane, karewe edoka eŋerop Yairus wane matko weneŋ arikoi. ");
INSERT INTO ons_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Eŋe mat yewao sari more Yesuŋo ongi, ukat suaine ma more zok manerop arokkoi. ");
INSERT INTO ons_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Eŋe ari waket more magu edange. “Ŋine mi arokeu so ukat suaine zok mi mau. Ŋerep ŋerep iwa eŋe mi seukike. Eŋe yaup kulu pamaike.” ");
INSERT INTO ons_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yale ra edangi, eŋe wawaine don olale more bokaka Yesu kuroŋ kakoi. Pakiso, Yesu eŋe mat yewao ŋino osopone moreso eŋe medep nagamagaine, eŋine so dokoine karewe enŋeneka ari more medep mat aŋaine pake, yewao ari waket kakoi. ");
INSERT INTO ons_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pakiso, Yesu eŋe ŋerep ŋerep seuseune ea wane metino ma more Yuda dongoka olatke, “Talita koumi”. Don yewa iwa yale, “Ŋerep nigatne na golatmaile. Ge wienom!” ");
INSERT INTO ons_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ŋerep ŋerep yewa eŋe ikopka wisikae wie arike. Ŋerep ŋerep komaine 12. Ea wane ŋei ŋerep eŋe masi ea ka more zok oŋaene qaeke. ");
INSERT INTO ons_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pakiso, Yesuŋo nagamagaine yewa togole etange, “Ŋire medep ŋara manbit nekep. Ŋo, ŋire kine kine iwa wane don kisi yauyaup misuk raut suayake.” ");
INSERT INTO ons_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu eŋine so dokoine eŋe mat yewa qelige more eŋine matine Nasaret arikoi. ");
INSERT INTO ons_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pakiso qezarek naso okangiso eŋe ari ŋei ŋerep Yuda eŋane miti lewa lewaŋ urum kotino metkoi, yewa kito ebonge. Paki, magu suaine metkoi, eŋe detka more dereretinane oŋaene qaeki rakoi. “Ei! Ŋei yewa eŋe don yewa diao ŋine meke? Dereret yewa maŋo manike? Eŋe eŋine masi togole iwa dalino mamaike? ");
INSERT INTO ons_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ŋei yewa eŋe matmama. Eŋe Maria wane gipole. Eŋane ŋolekoune Yakop, Yosep, Yuda so Simon so qakoune iwa ŋenerop weneŋ gemami.” Eŋe yale ra more ŋadek kakoi. ");
INSERT INTO ons_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ea wane Yesuŋo iwa yale edange. “Anutu wane qelit ŋei propet eŋe mat baŋem miti urata ma ge arimami, edo eŋane eŋetene zok mawaon okanmami. Ŋo, matkopene so weŋem sotak so matene kotino edo eŋane eŋetine maket biraon okanmami.” ");
INSERT INTO ons_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Eso yalinane Yesu matkoune ŋei ŋerep eŋane mali malipene mi pake. Ea wane Yesu eŋe pore ka more masi togogole eŋano zok mi make. Eŋe zoma ŋei ŋerep weku weku metine more ma menaŋonge. ");
INSERT INTO ons_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pakiso, Yesu eŋe Nasaret mat qelige ari, mat natne yewao lolike ge more, Anutu wane biŋek don ŋei ŋerep edange. Ŋo ŋei ŋerep ea eŋe wetŋo mi malipkakoi, eŋane yemo dere mezet okange. ");
INSERT INTO ons_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Naso yewao Yesu eŋe dokoine 12 ea naso yewao qeduguone more etkeka etkeka, matko matko biraonge. So eŋe biŋek don ra qelaŋanikei wane so ŋei ŋerep eŋano asu qotkoine esopongei wane zonom takotonge. ");
INSERT INTO ons_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pakimo edange, “Ŋine qesiŋine maine qesiŋ nagu kei wane makei, eso kine kine natne weneŋ mi ma arikei, ŋara so kite gerep me wesi kite mane misuk ma arikei, ea yeine, ");
INSERT INTO ons_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ŋine kie kulit so takot suaine weku bira arikei, takot etke eamo yeine.” ");
INSERT INTO ons_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Eŋe koso edange, “Ŋo, ŋine mat maneo ari lotke more ŋei ŋerep qeson onbi edo raikei, maine iwa saket mere pa wie okanbi, mat yewa wane kotinoka mere pa wie okanikei. ");
INSERT INTO ons_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ŋo mat mane edo ŋinane don mi dere more, ŋinerop mi mesikei wane rauso, ŋine mat yewa qelige more, kie ŋino kepe nalek yewa sauke lakokeu ket metki, so eŋe masi ea ka more desikei, Anutuŋo ŋenerop ŋaba okanmaike.” ");
INSERT INTO ons_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pakiso, dokoine eŋe matko matko ari more, mat louloutne eao biŋek don iwa yale edangoi, “Ŋine masi tanik kine kine qotkoine ea korop qelige ŋadekka more wet mainge wareu!” ");
INSERT INTO ons_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pakiso, eŋe asu qotkoine louloutne zok ŋei ŋerep eŋano ŋine osop one moreso ŋei ŋerep zomaenerop ea kelok tau more, korop ebu ma menaŋ ongoi. ");
INSERT INTO ons_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Naso yewao kepe wareware Herot eŋe Yesu wane donkisiŋo detki mo zok mat korop rokopkeke. Ŋei ŋerep natne eŋe rakoi, “Yohane doku tautauŋo mo deŋesereo ŋine wisikae wieke. Ea wane eŋe masi tanik zonominerop togogole iwa mamaike.” ");
INSERT INTO ons_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ŋo ŋei natne eŋe rakoi, “Eŋe Elaiya!” Natne eŋe rakoi, “Eŋe Anutu wane qelit ŋei propet mane, eŋe mo propet sogine gekoi, eŋe yaleka.” ");
INSERT INTO ons_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kepe ware ware Herot eŋe ea dere more rake, “Yohane doku tautau ea mo noŋo sogino ebine kitatkole. Eŋe koso yewa mo wisikae wie gemaike.” ");
INSERT INTO ons_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Mo sogino Yohane doku tau tau eŋe wisika ge more don togole Herot wano rake, “Ge ŋonŋone Pilip wane ŋanomine ea kobu makone. Masi yewa mi kopkemaike.” Sogine Herot eŋe zok Herodias ŋolane ŋanomine kobu make. Ea wane, Herot eŋe ŋei biraongi ari malipka mulap togoleŋo lukka masari more, mulap urumgo warage ari birakakoi. ");
INSERT INTO ons_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ŋo Herodias eŋe Yohane wane dere worik okanka more qeki seukeakane okange, ŋo Herot eŋe Yohane maine warekake. ");
INSERT INTO ons_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot eŋe Yohane ŋei koboine, Anutuŋo birakake, dere qeka okane more kaetkaki mauluke warekake. Herot eŋe naso natneo Yohane wane aŋaino ŋine don natne dere more naso baŋem qisemaŋke. ");
INSERT INTO ons_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Paki, Herodias eŋe Yohane qeki seukeakane numaine iwa yale maratkake. Herot eŋe ŋara suaine maki zeki eŋine wakon wakon nasoino more edoraki ŋei loutne sarikoi. Pakiso, eŋe gavaman kepe ware ware suaine so kawali ŋei eŋane ware ware suaine so Galili kotino mat suaine mere arimaike, ea wane ŋei suaine suaine qeson onge. ");
INSERT INTO ons_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias borasine eŋe sari eŋet kito oreke. Ea wane Herot so ŋei ŋara nekoi, eŋe korop eŋane simin onge. Ea wane Herot eŋe ŋerep natawen yewa qesonka rake: “Ge kine kine yewa me yewa wane ra more qeson nannom, na maine ginikale.” ");
INSERT INTO ons_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Eŋe atak loutne ra togoleke, “Na ra togolemaile. Kine kine yewa me yewa maine ginikale. So naŋane kepe aboŋ suaine ea ginikalane! Ranom na maine keuoka mapoke more ginikale.” ");
INSERT INTO ons_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pakiso, ŋerep natewen yewa eŋe ari nagaine iwa yale qesonkake, “Na Herot onoka wane qesonka rawe niniake?” Rakiso, Herodiasŋo olatke, “Ge ari Yohane doku tau tau ebine kitasiakane qesonkaikene!” ");
INSERT INTO ons_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yale olatkiso, ŋerep yewa eŋe ikopka biririke Herot wano ari qesonka rake, “Naŋane similene iwa yale. Ge ukudeka Yohane doku tautau wane ebine kitare more peletko more naŋano ma sari ninnom!” ");
INSERT INTO ons_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herot eŋe yewa dere more zok detki qomine umare lukke, ŋo mo ŋei suaine eŋane deeno atak loutne takorakot ra togole okange, ea wane eŋe dalino koso dereretine maingeki rap. ");
INSERT INTO ons_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ea wane ikopka kawali ŋei mane birakaki ari mulap urum koto Yohane wane ebine kitare more, lewetine ea make. ");
INSERT INTO ons_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pakiso, eŋe Yohane wane lewine ea pelet maneo more, so masari ŋerep natewen yewa mangi, so eŋe ma ari nagaine mange. ");
INSERT INTO ons_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pakiso, Yohane wane ŋadino dokoine gekoi, eŋe dere more sari Yohane pareŋine ea ma ari deŋesereo dukkakoi. ");
INSERT INTO ons_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ea wane Yesu eŋe dokoine mo etkeka etkeka, matko matko ari warekoi. Eŋe zinge sari koso Yesu wano lewage more, don kisi urata kine kine makoi, so biŋek don magu edangoi, ea olatwarekoi. ");
INSERT INTO ons_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pakiso, ŋei ŋerep louloutne Yesu wano ari sari okanbi, ea wane eŋe ŋara mire nene wane numaine mi wakonge. Ea wane Yesuŋo dokoine edane rake, “Wieu, kepe ŋeiine midaino, ari more ŋenzeka nigatne mere zonom maŋem.” ");
INSERT INTO ons_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Rakiso, eŋe kieke seki mane nigatne ma more wie kepe mane ŋei midaino enŋeneka arikoi. ");
INSERT INTO ons_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ŋo ŋei ŋerep korop eŋe mo onbi ariuso, eŋe ikopka detone more ŋadeeno mogatone taganka biririke qalakko yewa Yesu eŋine so dokoine arikoi, yewao alakane ari lotkekoi. Matne matne ŋei ŋerep korop yewa sarikoi. ");
INSERT INTO ons_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu eŋe seki qeliŋka ket more ŋei ŋerep magu suaine yewa one more qom borik suaine eŋane okange. Eŋe ongi maine mi metlukkoi. Eŋe medep nigatne nagamagaene seuseune, wanap yale metpi, Yesu eŋe biŋek don loutne kito ebonge. ");
INSERT INTO ons_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Kepe zinge kere qoeakane okangiso dokoine eŋe Yesu wano sari rakoi, “Ge magu iwa edane bira onnom eŋe mat osop mere arimaike. Yewao ari more ŋara maratkau, kepe iwa ŋei midaine so ruo mo kereakane okanmaike.” ");
INSERT INTO ons_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pakiso, Yesuŋo iwa yale edange, “Ŋido ŋara ebonikei.” Eŋe rakoi, “Ŋei nau! Ŋene 500 wesi setne eaŋo eŋane ŋara maine mi qolekene.” ");
INSERT INTO ons_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu eŋe koso qeson onge. “Ŋara darap ŋenzo metmaike? Ari ka more sari nolatpi!” Raki eŋe ari ka more sari olale rakoi, “Bret nigatne mete mane so zawon etke.” ");
INSERT INTO ons_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yale rauso Yesuŋo dokoine edane rake, “Ŋine ŋei ŋerep maguine maguine mapoke bira onbi pese ket touk kutno metpi.” ");
INSERT INTO ons_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Rakiso, eŋe yale ŋei ŋerep mapok onbi magu mane 100, magu mane 50 yale mere arikoi. ");
INSERT INTO ons_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Metpiso, Yesuŋo bret mete mane so zawon etke ea ma more malipka okora qeliwo potki waki mosopka more bret so zawon ea mapoke more, dokoine ebongi, damo qe ŋei ŋerep magu yewa ebonwarekoi. ");
INSERT INTO ons_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Paki, ŋei ŋerep magu yewa eŋe korop neu ŋatene qeki rokop onwareke. ");
INSERT INTO ons_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Paki dokoine eŋe ŋara nekoi, ea wane tutule ea qedugu more rosa 12 yale rosakkoi. ");
INSERT INTO ons_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ŋei ŋara yewa nekoi, eŋe 5, 000 yaline. ");
INSERT INTO ons_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ikopka, Yesuŋo dokoine qebin ongi eŋe sekiwo wa more doku namuŋ nat parom Betsaida oken alakane arikoi. Ŋo eŋine yemo yewa mere ŋei ŋerep magu yewa biraongi mateno ariwarekoi. ");
INSERT INTO ons_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesu eŋe ŋei ŋerep bira ongi korop ariwareuso, eŋe bonaga mane nigatne eao wa more meŋenka metke. ");
INSERT INTO ons_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ŋo, ruoo dokoine eŋe seki kutno doku namuŋ kebago metpi so, Yesu eŋineka tagalo metke. ");
INSERT INTO ons_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesu eŋe ruo panaman koto dokoine ongi momoŋo qebinongi, eŋe urata suaine zok pelekoi. Paki, kepe qae qae nasoo. Yesuŋo doku namuŋ kutnoka qesokma gesokma sari osoeno lotke more, yuanoniakane okange. ");
INSERT INTO ons_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Dokoine eŋe Yesu doku namuŋ kutno gesokma gesokma sariki ka more, kuroge aroke rakoi, “Ŋei seuseune eŋane oŋaeneŋo sarimaike.” ");
INSERT INTO ons_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Eŋe enŋenarek ka more kaet suaine okangoi, pakimo, Yesu eŋe yewaka done raki paki, edane rake, “Ŋine togoleu iwa yemo noŋom sarimaile! Ŋine misuk kaet ŋuniake!” ");
INSERT INTO ons_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yale ra edane more seki kutno wa metkiso momo doŋ mangi dokoine eŋe ea ka more, oŋaene qaeki metkoi. ");
INSERT INTO ons_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Eŋe Yesu wane zonomine mi detlukkakoi. So Yesu eŋe ŋei ŋerep magu suaine ŋara ebonge, ea wane eŋe deretene mi qelaŋange, eŋe dereretene zok manerop siukki qelaŋ okangoi. ");
INSERT INTO ons_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesu eŋine so dokoine, eŋe Galili doku namuŋ yuane more, ari Genesaret lotkekoi. Galili doku namuŋ nat paromino kere kito more seki qalakko lukkakoi. ");
INSERT INTO ons_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sekiwo ŋine qelige ketpi, so mat yewa wane ŋei ŋerep eŋe ikop mo Yesu ka more detkakoi. ");
INSERT INTO ons_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Eŋe Yesu wane donkisi dere more ikopka ket biririke matko matko ari zoma ŋei ŋerep zuaŋone ebu sarikoi. Ŋo natne edom numa ari ari wane konap mi okangoiwo, ea teweo pise tewekone korop Yesu wano ebu sariwarekoi. ");
INSERT INTO ons_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu eŋe korop mat nigatne kotino me mat suaino ari lotkemaŋke, rokop eŋe zoma ŋei ŋerep ebu sari sobeŋ keuno biraone more Yesu meŋenka ramaŋkoi, “Zoma ŋei ŋerep iwa eŋe maine geŋane takotŋone ea uakakei.” Rau eŋe detongi, meteene takotino ua ka more menaŋonmaŋke. ");
INSERT INTO ons_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Anutu wane papa togon welaine ŋei natne, Parisi, so Anutu papa togon welaine ŋei natne, Skribe, eŋe Yerusalem ŋine sari Yesu wano lewaŋgoi. ");
INSERT INTO ons_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Eŋe Yesu dokoine onbi meteene mi saukeu libe qeke, eŋe yaup ŋara ma nekoi. ");
INSERT INTO ons_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisi so Yuda ŋei ŋerep korop eŋe aso ŋabo eŋane masi ea mogare ge okanmaŋkoi. Eŋe ŋara nekeiwane okane more aso ŋabo ra rokop don yale rake, yalewaka eŋane rokoune ma more meteene sauke more maine ne okangoi. ");
INSERT INTO ons_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","So nalu qole qoleo ari more zinge sari ŋara nekeiwane okane more eŋe doku tau more ne okangoi. Eŋe kine kine natne aso ŋabo eŋane masi ea korop mogare okan waremaŋkoi. Eŋe lase, kap ŋara mire ne, so kulu papa wane kine kine korop sauke mauluke gemaŋkoi. ");
INSERT INTO ons_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Eŋe Yesu qesonka rakoi, “Onoka wane dokoŋone eŋe asoŋabo eŋane numa tego ea mi mogatmami. Eŋe meteene mi sauke more ŋara yaup ma nemami.” ");
INSERT INTO ons_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Rauso, eŋe iwa yale edange, “Isaiaŋo ŋine isi ŋei zok ŋidorake, ŋinane kineŋine papiao iwa yale Anutu wane dongo qeke pamaike. ‘Anutuŋo rake, Ŋei tego yewa eŋe pieneŋoka naŋane eŋetne nora bukeu waokanmaike. Ŋo, wet derereteneŋo yemo na qeliŋnane more, amaŋ okoramami. ");
INSERT INTO ons_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Eŋe nae yaup eŋetneka nora bukeu waokanmaike. Eŋe aso ŋabo eŋane numa tego yewa kito ebone more raokanmami, iwa Anutu wane don.’” ");
INSERT INTO ons_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu eŋe koso edane rake, “Ŋine Anutu wane don masi koboboine mo qeligeu siuk ŋunmaike? Pakimo, ŋine ŋei ŋinŋine aso ŋabo eŋane don eaka malipka gemami.” ");
INSERT INTO ons_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu eŋe koso edange, “Ŋine zok detluke more Anutu wane don koboboine ea matali qetali okane more ŋinŋine asoŋabo eŋane numa tego malipka gemami. ");
INSERT INTO ons_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moseŋo sogino qei bano mo rake, ‘Ŋine nabok magak ere qesiŋore more geokanikei, Ŋo, ŋei mane eŋe nabok magak don borikine etaniakeo, eŋe qeu seukeake.’ ");
INSERT INTO ons_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ŋo, ŋine, Anutu wane papa togon welaine ŋei, ŋei ŋerep masi kine mane iwa yale edanmami. Ŋei mane eŋe wesiinerop nagamagaine qesiŋ osiakane okane, ŋo, siluŋ etane raokanmaike, na mo Anutu wane biŋek qile. ");
INSERT INTO ons_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ŋine yale edanbi, eŋe naga magaene mi qesiŋone more, qeliŋ onmaŋkei. ");
INSERT INTO ons_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ŋine ŋinŋine asoŋabo kito ebo ebon ŋei ŋerep ea edanmami, ŋine Anutu wane don zonomine mau kito okanmaike. Ŋine kine kine loutne yalewa ma okanmami.” ");
INSERT INTO ons_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu eŋe koso ŋei ŋerep magu suaine edoraki sariu edange, “Ŋine koropŋo naŋane don iwa dere more wetŋineŋo motpi so detlukkeu. ");
INSERT INTO ons_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ŋine detmami, kine kine iwa diinerop ŋadino pamaike, eaŋo ŋinane kotoŋine mi maki sigileake. Ŋo kine kine natne ŋinane wet dereretŋine kotino pamaike, eaŋo saket more maki wet dereretŋine korop sigile okanmaike. ");
INSERT INTO ons_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ŋei mane eŋe wetineropŋo don iwa detlukkeake. ");
INSERT INTO ons_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yale ra more eŋe ŋei ŋerep yewa qeliŋone more eŋine so dokoine eŋe ari mat maneo wa more don rokop rake yewa wane kine desikeiwane qesonkakoi.” ");
INSERT INTO ons_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu eŋe iwa yale edange, “Ŋinane dereretŋineŋo ŋei ŋerep natne eŋane dereret mi yuan onmaike. Ŋara kine kine korop pamaike, eaŋo ne more ŋei ŋerep mi sigilekene. ");
INSERT INTO ons_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ŋara yewa wet dereretŋine mi qeduguyake. Ŋara qomŋino ket more koso kaŋinoka saket ariake.” Iwa yale Yesu eŋe ŋara kine kine yewa eŋe korop Anutu wane kaitko libekaka pamaike. ");
INSERT INTO ons_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pakiso, eŋe rake, “Kine kine ŋei wet dereret kotino pamaike, eaŋo saket more maki ŋei ŋerep wet dereretŋine korop sigile okanmaike. ");
INSERT INTO ons_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ŋei ŋerep wet dereretko pa more saket maki ŋei ŋerep dirop okan okanmaine yemo iwa, edo dereret qotkoine detokanmami, so ŋei ŋerep natewen qaluwit wenip yauyaup ma okanmami, so ŋei naka pilaŋŋo engu mamami me kine kineŋo matalionbi seuke okanmami, kobu ma okanmami, ");
INSERT INTO ons_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ŋei mane eŋe ŋei mane wane ŋanomine kobu ma okanmaike, bailalaŋ okan okanmami. Ŋine masi tanik kine kine natne korop okan okanmami, isi kine kine ma okanmami, wawaine masi kine kine okan okanmami, bau wawa masi kine kine ma okanmami, qe baik ma baik don ra okanmami, wawaine don kine kine ra okanmami, doku togole ne more qelaŋ qelaŋine okan numa kine kine mau bori okanmaike. ");
INSERT INTO ons_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Masi tanik kine kine qotkoine korop iwaŋo ŋei ŋerep wet dereretko pa more eaŋo saket maki ŋei ŋerep dienerop okan okanmami.” ");
INSERT INTO ons_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu eŋe yewa qelige ea ŋine wie Tire matko ari lotke more, mat mane wane kotino ari waket siuke metke, onoka wane ŋei ŋerep edo esatka eŋano mi sari lewaŋgei wane. Ŋo siluŋ dalino siuke metkirap. ");
INSERT INTO ons_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mida! Ŋerep mane mat yewa ŋine eŋe Yesu mo detkaki metke. Ŋerep yewa eŋe borasine asu qotkoineŋo matalikaki metke, ea wane ŋerep yewa eŋe ikopka sari Yesu wane osino kino ket pese wawetine qeke. ");
INSERT INTO ons_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ŋerep yewa eŋe tego maneo ŋine, qelaŋ ŋerep, eŋe Yuda wane tegooŋine mida. Eŋe Ponisia tegoo ŋine, kepe mat ea wane welaine, eamo Siria kepeo. Eŋe Yesu wano ari seleleine qe meŋenka more rake, “Borasone asu qotkoineŋo matalikaki metmaike. Ge esopkanom!” ");
INSERT INTO ons_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu eŋe olale rake, “Ŋene mikepka medep ŋara gumeonŋem. Ŋene medep eŋane ŋara maine mi biraŋem kasimde eŋano ariake.” ");
INSERT INTO ons_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yale rakiso, ŋerep eŋe mainge rake, “Waom, ge don wele ramaine, ŋo medep eŋe ŋara ne okanmami, naso yewao sisine kepo ketki kasi eŋe medep eŋane ŋara sisine ea ma ne okanmaŋkei.” ");
INSERT INTO ons_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pakiso, Yesu eŋe ŋerep olatke, “Ge yale ramaine, ea wane maine zinge arinom borasoŋone asu qotkoine ea mo qeliŋ kamaike.” ");
INSERT INTO ons_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yale ra olatki, ŋerep eŋe zinge matko ari kaki borasine ea asu qotkoineŋo mo welekatne qeliŋka saket ariki eŋe maine papaino kulu pake. ");
INSERT INTO ons_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu eŋe wie Tire qelige more Sidon kepe so Mat Suaine Meteetke(10) kepe keuoka ratoke ari Galili doku namugo lotkeke. ");
INSERT INTO ons_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ŋei natne eŋe ŋei mane done mi raraine so ketine won wole ea Yesu wano iwenka sari oŋo metine more ma menaŋ kayakane olatkoi. ");
INSERT INTO ons_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Pakiso, Yesu eŋe ŋei yewa maki eretneka ŋei ŋerep magu yewa qeliŋone amaŋ ari mere so Yesuŋo ŋei yewa wane ketino metine boineŋo qesikane more, mekatine boino sopotke belakamino motke. ");
INSERT INTO ons_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","More so qeliwo potki waki wetine aroke saki, rake, “Epata!” Don ea wane kine iwa yale. “Ketŋone so aŋaŋone lotkeuk!” ");
INSERT INTO ons_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yale raki ŋei yewa dereretine lotkeki korop detkake. So belakamine umareke, ea ewekki don maine rake. ");
INSERT INTO ons_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu eŋe sari ŋei ŋerep magu yewa rawetone more rake, “Masi iwa mamaile, ea wane don sigi misuk rau sua ariake.” Yale ra naso baŋem rawetone okanmaŋke, ŋo, eŋe soringe takotke eŋane don sigi rau sua arimaŋke. ");
INSERT INTO ons_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ŋei ŋerep korop eŋe oŋaene qaeki rakoi, “Urata kine kine natne welekatne wakonmaike. Ŋo, Yesu eŋe ŋei ketine won wole ea maki lotkeki don detlukmaike. So eŋe ŋei aŋaine umatne so mawon mawole, ea maki don ramaike.” ");
INSERT INTO ons_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Naso yewao ŋei ŋerep magu suaine natne eŋe Yesu wano koso lewaŋgoi, ŋo, ŋaraene mo korop midaonge, Yesu eŋe dokoine edoraki sariu edange, ");
INSERT INTO ons_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Na ŋei ŋerep magu suaine iwa eŋane qom borik suaine detmaile, eŋe zok kaiwe mama karewe naerop metpi ŋaraene mo midamaike. ");
INSERT INTO ons_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ŋo, eŋe ŋara mi nene yaup metpi, na biraonbe arikeiwo, natne eŋe ari more numao deene lolikki ket rasukei. Natne eŋe matene ameŋine sarikoi.” ");
INSERT INTO ons_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dokoine eŋe eŋane don mainge rakoi, “Kepe iwa ŋeiine midaine, ge detmaine ŋene ŋara diaoŋine ŋei ŋerep iwa ma ebonŋem neu rokoponiake?” ");
INSERT INTO ons_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yale rauso, Yesu eŋe qeson one rake, “Ŋinano bret darap metmaike?” Raki, eŋe maratka more rakoi, “Bret mete mane so mete natko zitne etke(7) metmaike.” ");
INSERT INTO ons_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Olatpiso, Yesu eŋe ŋei ŋerep edane rake, “Ŋine korop pese ket kepo metpi.” Raki eŋe korop pese metpiso, eŋine bret mete mane so mete natko zitne etke(7), yewa ma more, Anutu wano bakom kito mosopka more mapoke dokoine ebongi edo damo qe ŋei ŋerep magu suaine yewa korop ebonwarekoi. ");
INSERT INTO ons_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ŋo, eŋe zawon nigatne karewe metke, ea weneŋ manbiso eŋe yalewaka Anutu bakom kito more mosopka dokoine ebongi, eŋe yale waka damo qe korop magu yewa ebonwarekoi. ");
INSERT INTO ons_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eŋe neu rokop ongiso, Yesu dokoine eŋe ŋara tutule yewa rosa 7 yale rosakkoi. ");
INSERT INTO ons_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ŋei ŋerep magu yewa eŋe 4, 000ŋo metkoi. ");
INSERT INTO ons_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yesu eŋe ŋei ŋerep magu yewa biraongi, ariu, eŋine so dokoine ikopka sekiwo wa more Dalimanutia kepeo arikoi. ");
INSERT INTO ons_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ea ari lotkeuso Anutu wane papa togon welaine ŋei natne, Parisi, eŋe sari Yesu wano aŋa soraŋ don okane more Yesu qesonka rakoi, “Ge masi togole mane ma sikanŋonnom kaŋem, ge Anutu wano ŋine sarimaine.” Eŋe yale ra more dongo liwekkaikei wane okangoi. ");
INSERT INTO ons_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu eŋe rake, “Oo yai! Onoka wane ŋei ŋerep eŋe naso iwao noŋo masi togogole mane mawe kaikeiwane sari ramami? Midakaka! Naso iwa noŋo masi togogole mane koso ŋei ŋerep ŋinano mi ma sikan ŋunikale.” ");
INSERT INTO ons_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesu eŋe yale edane more eŋine so dokoine eŋe mat yewa qelige sekiwo wa more doku namuŋ kitare eri nat parom arikoi. ");
INSERT INTO ons_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu dokoine eŋe bret natne weneŋ mi makoi. Eŋe nigetongi yaup sekiwo wa arikoi. Bret weku seki kotino pake. ");
INSERT INTO ons_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu eŋe ea wane girem don togole edane rake, “Ŋine Anutu wane papa togon welaine ŋei, Parisi eŋane tego so Herot eŋane masi kauluk onikei. Eŋe bret maki sua okanmaike. Eŋane masi eaŋo yalewa ŋei korop rokoponmaike.” ");
INSERT INTO ons_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dokoine eŋe don yale dere more, eŋe enŋene auye rakoi, “Bret eri nigetŋongi qelige sarine, eŋe ea wane mane ramaike.” ");
INSERT INTO ons_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Rau, Yesu eŋe don yewa dere more edange, “Ŋine onoka wane ŋinŋine aumami, ŋene bret mida? Oo, ŋine wet dereretŋine midaine? Oo ŋine dereretŋine mo wongike. ");
INSERT INTO ons_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ŋine deŋine weneŋ, ŋine onoka wane kine kine mi kamami me? Ŋine ketŋinerop onoka wane don yewa wane kine mi detkamami me? Ŋine mo nigetŋunikei me? ");
INSERT INTO ons_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Naso na bret mete mane mapoke, 5 tausen(5, 000) ŋei ŋerep eŋano ŋibonbe damo qekoi, naso yewao ŋado neu, wokitne metki ŋine rosa darap rosakkoi?” Eŋe rakoi, “Rosa 12!” ");
INSERT INTO ons_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Eŋe yale raumo, Yesu eŋe koso qesononge, “Ŋo ŋine na bret 7 mapoke, ŋei ŋerep 4, 000 eŋano ŋibonbe, damo qe ebongoi, naso yewao eŋe neu, wokitne metki ŋine rosa darap rosakkoi?” Eŋe rakoi, “Rosa sewen.” ");
INSERT INTO ons_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Rau, Yesu eŋe yewaka edange, “Ŋine zok ea mi detlukkamami me?” ");
INSERT INTO ons_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pakiso, eŋe ari Betsaida lotkeu, ŋei mane deine pilik pilikine, eŋe Yesu wano ma sarikoi, ŋei ea eŋe Yesuŋo metine lewetino mosiakane. ");
INSERT INTO ons_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pakiso, Yesu eŋe ŋei de pilik yewa metino maki, ere mat ŋadino qeinat ket more, Yesuŋo ŋei yewa deino mekatine sopotke more, so metineŋo deino qesikane rake, “Ge maine pore kine kine kamaine me?” ");
INSERT INTO ons_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Rakiso, ŋei yewa eŋe pore lolike more rake, “Na ŋei natne pore onmaile. Na onbe eki yale arimami.” ");
INSERT INTO ons_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu eŋe metineŋo koso ŋei yewa wano motki, ŋei yewa eŋe deine togoleka pore kaki, deine mo maine wakongi, pore kine kine korop ka qelaŋange. ");
INSERT INTO ons_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pakiso, Yesu eŋe ŋei yewa olale biraka rake, “Ge kere more eri mat suaino misuk wakesikene. Ge koboboine ari matŋono lotkekene.” ");
INSERT INTO ons_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu eŋine so dokoine eŋe yewa ŋine wie arimage mat natne Sisaria Pilipai osino lotkekoi, numa keuno dokoine qesononge, “Ŋei ŋerep eŋe na wamo ma noramami?” ");
INSERT INTO ons_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Edo iwa yale olatkoi, “Natne edo ge Yohane doku tau tau goramami. Ŋo, natne edo ge Elaiya goramami. Ŋo, natne edo ramami, ge Anutu wane qelit ŋei propet mane sogine gekoi, eŋano ŋine.” ");
INSERT INTO ons_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yale rauso, koso enŋene qesonone rake, “Ŋo, ŋidom yemo naŋane dalino ramami?” Rakiso Petoroŋo donine turuŋine mainge olale rake, “Ge Mesia, Anutuŋo biragange.” ");
INSERT INTO ons_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yale rakiso, eŋe togoleka ra wetone rake, “Ŋine naŋane kine yewa ŋei mane misuk olasikei.” ");
INSERT INTO ons_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu eŋe kieke more, eŋine solaino wikile wakoniake ea wane dokoine kito edane more rake, “Ŋei Wawainane Gipole na wikile zok manerop peikkale. Ŋei ŋetne korop so Anutu wane mosop ŋei suaine so Anutu wane papa togon welaine ŋei, Skribe, eŋe korop ŋadeknane more, nekuwi seukkale, kaiwe mama karewe yale pa more, koso wisikae wiekale.” ");
INSERT INTO ons_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu eŋe yale ra qelaŋane edangi, Petoro eŋe Yesu maki ere qeinat ket mere more Yesu rawetka rake, “Ŋei eŋe ge mi gekukei.” ");
INSERT INTO ons_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ŋo, Yesu eŋe zinge pore dokoine one more Petoro rawetka rake, “Ŋei borikine, ge na ŋadeno arinom! Goŋo weti Anutu wane wet dereret mi detmaine! Midaka! Ge kepe ŋei wet so dereret eaka dere gemaine!” ");
INSERT INTO ons_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu eŋe eŋine dokoine so ŋei ŋerep magu korop edoraki eŋane osino sariu, iwa yale edange, “Ŋinano ŋine ŋei maneŋo na mogat naniakane raso, eŋine simileine ea korop maki ketwarekiso wikile desiakane eweke ariki eŋe na nekukei, yalewaka eŋe qekei. ");
INSERT INTO ons_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ŋei mane eŋe wikilane kaetkaki solaine mawalukayakeo, eŋe gege wane numaine korop siuklukkayake. Ŋo, ŋei mane eŋe biŋek don wane so nae wane wetkeake, paki gegeine korop qikka more, ea waneka ra more seukeake, ŋei yewa eŋe gege marat kayake. ");
INSERT INTO ons_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ŋo, ŋei mane eŋe kepe wane aboŋ kine kine korop magekeo, eŋe seuke more onoka maratkayake? Midakaka! ");
INSERT INTO ons_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Seuke more koso onokakaŋo gege wane lewine qeliŋgi sari maniake? ");
INSERT INTO ons_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ukude naso iwao kepe iwa wane ŋei ŋerep korop masi qotkoine kine kineŋo mau watke rokopkemaike. So eŋe wawaine masi kine kine ea korop Anutu wane deo okanwaremami. Ŋei mane eŋe naso iwao ŋei ŋerep magu yewa eŋane keueno ŋine eŋe nae so naŋane biŋek don rayakane gamu gamu okane geakeo, na Ŋei Wawainane Gipoleŋo ramaile, na ŋado Anutuŋo eŋine tungo biranangi, aŋelo magu eŋerop qeli qeliŋka sarikene, naso yewao na ŋei yewa don koboine maine mi olasikale.” ");
INSERT INTO ons_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu eŋe koso don takotke iwa yale edange, “Na welekatne ŋidanmaile, ŋei natne ŋine iwa okoramami, mi seuke more wisika gekei, naso eao Anutuŋo ŋine korop wareŋunmaike, eao Anutuŋo qeli ewe zonominerop wakongi kaikei.” ");
INSERT INTO ons_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kaiwe mama 6 qoikiso, Yesu eŋe Petoro, Yakop so Yohane ebuki enŋeneka bonaga mane kiroroine wetika weti yewao wakoi. Wa enŋeneka okorauso, eŋane deeno eaka Yesu wane kait sola tanikine qeinge more kine mane okange. ");
INSERT INTO ons_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Laplap kine kine korop libe libe qe qelaŋane teine okange. Kepe ŋei maneŋo okangi, eŋane laplap yale libe libe qelaŋane teine mi okaniake, so sauki yalewa maine mi wakoniake. ");
INSERT INTO ons_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Dokoine eŋe pore otpi ŋabotkine Elia so Mose ere wakone more Yesurop don auye okorakoi. ");
INSERT INTO ons_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petoro eŋe ea ka more ikopka Yesu olale rake, “Kito ŋebon ŋebon! Ŋene iwa metŋem wekumane zok okanmaike. Ŋene maine seli kise karewe(3) maikene! Mane geŋane, mane Mose wane, mane Elia wane!” ");
INSERT INTO ons_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petoro eŋine so kimatkine eŋe kaet zok okangoi. Ea wane Petoro eŋe masi tanik yewa wane kine mi detluke more don qazaŋ rake. ");
INSERT INTO ons_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Paki, eaka wakongi paki, kezoŋŋo ŋei karewe korop kawetongi so Anutu aŋaineŋo kezoŋ koto ŋine iwa yale rake, “Yewa naŋane wemedep wekuku! Na wetneŋo malipkamaile. Ŋine korop eŋane don desikei!” ");
INSERT INTO ons_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Don yale wakongi dere more so dokoine eŋe ikopka deene pore lolike ŋei mane mi kakoi. Yesu eŋineka eŋerop okoraki, kakoi. ");
INSERT INTO ons_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eŋe bonaga qeliŋka ket more, Yesu eŋe dokoine togogole rawetone rake, “Kine kine iwa wakongi kamami, ea wane ŋei ŋerep siron misuk ra qelaŋan onikei. Baŋ, na Ŋei Wawainane Gipoleŋo, deŋesereo ŋine wiekale, naso yewao maine ra qelaŋan onikei.” ");
INSERT INTO ons_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eŋe don ea dere teweke more enŋene auye rakoi, “Don yewa deŋesereo ŋine wie wie ea kine dalino wane ramaike.” ");
INSERT INTO ons_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ra more eŋe koso Yesu qesonka rakoi, “Dalino wane Anutu papa togon welaine ŋei, Skribe, eŋe ra okanmami, qelit ŋei, Elaiya eŋe alakane sari more, numa kine kine makoboeake?” ");
INSERT INTO ons_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu eŋe dokoine karewe eŋane don mainge rake, “Na ŋidanmaile. Elia eŋe mo sariki, ŋei eŋe enŋene simileene mogare more masi tanik kine kine zok okankakoi. Yale Anutu wane papa togon donŋo mo rake. ");
INSERT INTO ons_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Skribe eŋane don ea i welekatne. Elaiyaŋo mikep sari more, eŋine kine kine mo mauluk wareke. Ŋo, donba iwa yale onoka wane mo sogino Anutu wane papa togon dongo qekoi pamaike? Eŋe ramaike Ŋei Wawainane Gipole eŋe wikile zok mayake, so ŋei edo manerop ma baikkaikei.” ");
INSERT INTO ons_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Eŋe ea ŋine ket sari dokoine natne metkoi, eŋe onbi ŋei ŋerep magu suaine edo eŋano lewage lolikone mere more Anutu papa togon welaine ŋei, Skribe, eŋe dokoine eŋerop don auye kitat okangoi. ");
INSERT INTO ons_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Paki, ŋei ŋerep magu yewa eŋe kau, Yesu sariki eŋe korop qomene qise poradaŋgi biririke Yesu osino ari more kaiwe maine mangoi. ");
INSERT INTO ons_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yale rau, Yesu eŋe dokoine qesonone rake, “Ŋine onoka wane don auye kitat okanmami?” ");
INSERT INTO ons_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yale qesonongi, ŋei ŋerep magu yewa eŋane keueno ŋine maneŋo wie rake, “Kito ebon ebon na medepne mane asu qotkoineŋo kotino mere aŋaine ma won geki, ea wane na geŋano ma sarimaile. ");
INSERT INTO ons_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Naso baŋem asu qotkoine yewaŋo medep iwa togoleka ma main qein ma birakaki kepo ket rasu paki, mekalekatine libeka aŋainoka saket qakki ŋetine paŋ kilipke more solaine korop togo togon qe okanmaike. Na, ea wane dokoŋone edanbe edo asu qotkoine yewa osop kaikei wane ŋaŋaemami.” ");
INSERT INTO ons_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu eŋe don yewa dere more, ŋei ŋerep edane rake, “Ŋei ŋerep magu iwa ŋine korop mali malip ŋine mida! Na naso darap ŋinerop gekale? Na naso baŋem yalewa ŋinerop ge more, umat kine kine ŋine qesiŋŋune okangale me? Ayop ŋine medep yewa naŋano ma sariu!” ");
INSERT INTO ons_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eŋe medep yewa eŋano ma ariu asu qotkoine eŋe Yesu ka more medep yewa main qein ma birakaki kepo ket kito todi todiŋ ariki mekalekatine libeka aŋainoka saket qakke. ");
INSERT INTO ons_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu eŋe medep magaine qesonka rake, “Naso darap eŋe iwa yale okankaki geke?” Magaine eŋe rake, “Mo medepinoka yale okankaki naso kiroine gesake. ");
INSERT INTO ons_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Naso louloutne asu qotkoine eaŋo qeakane ma birakaki ari gerep kutno wa okanmaŋke. Naso natno ma birakaki ari doku koto ket okanmaŋke. Ge ŋaŋaekamaine? Ge ŋenane wet borik okane more ŋene qesiŋ ŋonikene.” ");
INSERT INTO ons_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu eŋe olatke, “Ge onoka wane qesonnane ramaine, ge ŋaŋaemaine? Ŋei mane eŋe mali malip togole malipkayakeo, eŋano kine kine korop maine mawe wakonwarekei.” ");
INSERT INTO ons_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Medep magaine ikopka boka rake, “Na ge malip ganmaile. Ŋo na mali malipne togole mida. Ge siluŋ maine mapitnanikene!” ");
INSERT INTO ons_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu eŋe ongi, ŋei ŋerep magu suaine eŋe sari lewaŋgoi. Ea wane eŋe asu qotkoine ea togoleka boka olatke, “Asu qotkoine ket rasu aŋaŋone ma won genom, na ge golatmaile, ge medep yewa qeliŋkanom! Ge ari more koso mi zinge sari eŋano wakesikene.” ");
INSERT INTO ons_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yale ra olatki asu qotkoine ea eŋe togoleka boka aroke medep yewa togoleka rapapkaki, kepeo ket pakiso saket arike. Medep eŋe seuseune yale pake, ŋei ŋerep korop eŋe rakoi, “Mo seukmaike.” ");
INSERT INTO ons_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Eŋe yale rau, Yesu eŋe medep yewa metino ma more buke qesiŋkaki eŋe wie maine okorake. ");
INSERT INTO ons_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu eŋe yale okane more matko waki, dokoine eŋe enŋeneka san qesonka rakoi, “Ŋene dalino wane asu qotkoine ea esop kaikenane ŋaŋaine?” ");
INSERT INTO ons_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Pakiso, Yesu eŋe edange, “Kine kine natneŋo asu qotkoine ea maine mi esopkayake. Meŋe meŋen wekuŋo maine esopkayake.” ");
INSERT INTO ons_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu eŋine so dokoine mat yewa qelige more Galili kepe keuoka rapoke arikoi. Ŋei ŋerep edo mi det kaikei wane eŋe sanka ket arikoi. ");
INSERT INTO ons_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Eŋe enŋeneka ari mere more dokoine kito eboniake, ea wane. Pakiso, dokoine enŋeneka don iwa yale edange, “Ŋei edo Ŋei Wawainane Gipole, ŋei ŋaba eŋane meteeno birakakei. Edo qeu seukeake. Eŋe seuke more kaiwe mama karewe yale pa more baŋ koso wisikae wieyake.” ");
INSERT INTO ons_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesu eŋe don yale ra edangi, eŋe don yewa wane kine detpi mi qelaŋanongi eŋe koso qesonka detlukkeiwane, kaetonge. ");
INSERT INTO ons_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Eŋe ari Kaperneam mat suaino lotke more mat maneo wa mere Yesuŋo dokoine qesonone rake, “Ŋine numao sari more onokaka don auye kitat nagu okanimi?” ");
INSERT INTO ons_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yale ra qesonongi, eŋe donene midaki metkoi. Onoka wane eŋe numao iwa yale ra auye sarikoi. Tego iwa ŋenano ŋine maŋo ŋetneze okanmaike. ");
INSERT INTO ons_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu eŋe ket pese mere more dokoine 12 ea edoraki sari osino metpi edane rake, “Ŋei mane eŋe ŋetne okaniakane okane more, eŋe qei ŋado kito more ŋei korop eŋane qelit qeqe okaniake.” ");
INSERT INTO ons_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yale ra more, medep mane nigatne ea ma sari qeki keueno okoraki, masatka okora edane rake, ");
INSERT INTO ons_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ŋei mane eŋe naŋane tungo medep nigatne iwa yale mapitkayakeo, eŋe na mapitnanmaike okanmaike. Ŋei mane eŋe na mapitnaniakeo, eŋe magak biranangi ketkole, eŋe weneŋ mapitkamaike okanmaike.” ");
INSERT INTO ons_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pakiso, Yohaneŋo olale rake, “Kito ŋebo ŋebon! Ŋene kaŋem ŋei maneŋo geŋane eŋetko ra asu qotkoine esopkamaike. Pakimo, eŋe ŋenane ŋadezo mi mogatŋone sarikimo ŋene ra wetkamaine.” ");
INSERT INTO ons_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesuŋo Yohane olatke, “Ŋine mi rawetkau! Ŋei mane eŋe naŋane eŋetko masi mane togogole mayakeo, eŋe don borikine naŋane ikopka maine ŋei ŋerep mi edaniake. ");
INSERT INTO ons_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ŋei mane eŋe ŋene mi ŋabaŋonmaike, ea eŋe ŋenane kimaze okanmaike. ");
INSERT INTO ons_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Naso ŋine doku wane seukeu, ŋei mane eŋe ŋine ŋune more detŋuniake, Yesu wane dokoine, yale dere more doku ore ŋibongi nekeiwo, na welegatne ŋidanmaile. Ŋei yewa eŋe lewine manikale. ");
INSERT INTO ons_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Medep nigatne iwa eŋe mali malipine naŋano pamaike. Ea ŋei maneŋo mataliakeo, Anutuŋo ŋei yewa wikile suaine maniake. ");
INSERT INTO ons_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ŋo, meteŋoneŋo qe isigangi, mali malipŋone matalikeneo, ge meteŋone nat kitare biranom ariki, meteŋone natka qeliwo wa gege maratkaikene. Ŋo, ge meteŋone nat mi kitare more etkeka gekeneo, ge sola so oŋaoŋa weneŋ gerep sora qoiqoine midaine yewao kesikene. ");
INSERT INTO ons_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Gerep ea wane koma komaineŋo ŋei ŋerep edore more mi seukkei. So gerep yewa ŋei ŋerep ezo more mi komayake. So ŋei ŋerep mi seukkei, eŋane wikile pa wayake. ");
INSERT INTO ons_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ŋo ge kieŋoneŋo isigangi, mali malipŋone matalikeneo, ge kieŋone nat kitare biranom ariake, ge kieŋone natka qeliwo wa gege maratkaikene. Ŋo, ge kieŋone nat mi kitare more etkeka gekeneo, ge sola so oŋaoŋa weneŋ gerep sora qoiqoine midaine yewao kesikene. ");
INSERT INTO ons_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Gerep ea wane koma komaineŋo ŋei ŋerep edore more mi seukkei. So gerep yewa ŋei ŋerep ezo more mi komayake. So ŋei ŋerep mi seukkei eŋane wikile pa wayake. ");
INSERT INTO ons_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ŋo, deŋoneŋo isigangi, mali malipŋone matalikeneo, ge maine deŋone nat qe koko porike biranom ariake, ge deŋone natka maine Anutuŋo wareŋoniake kepe yewa maratkaikene. Ŋo, ge deŋone nat mi qe koko porike more etkeka gekeneo, ge sola so oŋaoŋa weneŋ gerep sora qoiqoine midaine yewao kesikene. ");
INSERT INTO ons_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Gerep ea wane koma komaineŋo ŋei ŋerep edore more mi seukkei. So gerep yewa ŋei ŋerep ezo more mi komayake. So ŋei ŋerep mi seukkei, eŋane wikile pa wayake. ");
INSERT INTO ons_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Sogino Yuda ŋei ŋerep eŋe Anutu wane bakom soep korop kiwetŋo kutno mot okangoi. Yalewaka, Anutu eŋe gerepŋo ŋei ŋerep korop kuteno motki ezoyake. ");
INSERT INTO ons_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Kiwet wekumane. Ŋo, eŋane zonomine midayakeo, ge maine koso mi manom zonominerop okaniake. “Kotoŋine peamine pakep. Peamŋo gegeze maki togole pakep. Ge ŋei ŋerep korop eŋerop kima geokanikene.” ");
INSERT INTO ons_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu eŋe wie ea qelige more, Yuda kepe wane nat paromino ari more Yordan doku kitare arike. Ŋei ŋerep magu suaine eŋe koso sari eŋano lewageuso eŋe okane okanmageake yale mogare Anutu wane biŋek don edange. ");
INSERT INTO ons_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Edangiso, Anutu papa togon welaine ŋei, Parisi, eŋe sari Yesu liwekkaikei wane rakoi, “Ge ranom! Ŋenze ra rokop donze eaŋo ramaike, ŋei mane eŋe maine ŋanomine esopkayake, me mida?” ");
INSERT INTO ons_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu eŋe donene mainge qesonone rake, “Sogino, Moseŋo ra rokop don daleo ŋibonge.” ");
INSERT INTO ons_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eŋe mainge rakoi, “Mose eŋe rake, ŋei mane eŋe ŋanomine esopkayakane okane more, maine kibi mane qe more kibi yewa kot ŋei eŋano more, maine ŋanomine esopkayake.” ");
INSERT INTO ons_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesuŋo edane rake, “Ŋine so ŋinane aso ŋabokopŋine ŋinŋine wawaine ŋinane Mose eŋe ŋinane ra rokop don yewa qeke. ");
INSERT INTO ons_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Moka sogino Anutu eŋe kine kine ma wakonwareke, naso yewao yale mi rake. Anutu papa togon don iwa yale qeke paki, ‘Anutuŋo ŋei so ŋerep ma wakonore more biraotke.’ ");
INSERT INTO ons_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","So, ‘Ŋei eŋe ŋerep mayakane okane more eŋe nagamagaine qeliŋore more ŋanominerop qeturage more, weku okangeik. ");
INSERT INTO ons_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ere ŋao ŋanom okane more, solaetne qeduguwik, weku okangi gekeik.’ ");
INSERT INTO ons_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anutuŋo don yale ra more ŋaoŋanom maturaŋ otke. Ŋeiŋo maine mi mapokosikei.” ");
INSERT INTO ons_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Matko zinge ari more, dokoine eŋe koso ea wane qesonkakoi. ");
INSERT INTO ons_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Eŋe iwa yale edange, “Ŋei mane eŋe ŋanomine qeliŋka more ŋerep mane mayakeo, eŋe ŋanomine qeliŋka more, sot maratkayake, so ŋei ea bailalaŋ urata mayake. ");
INSERT INTO ons_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ŋo ŋerep eŋe yaleka ŋaone qeliŋka more, ari ŋei mane mayakeo, eŋe ŋaonano qeliŋka more, sot maratkayake, so ŋerep ea eŋe yaleka bailalaŋ urata mayake.” ");
INSERT INTO ons_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ŋei ŋerep eŋe dokoene Yesuŋo metineŋo kuteno more mosop oniakane ra more eŋano ebu sariu, dokoine edo don okanongoi. ");
INSERT INTO ons_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu eŋe dokoine edo masi yale okanbi one more wet gerep okane more edane rake, “Ŋine misuk ma walukonbi! Qeliŋonbi! Medep nigatne ea naŋane osono maine sariu! Anutu eŋe ŋei ŋerep medep nigatne iwa yaline eŋane rokopko wareoniakane siminkamaike. ");
INSERT INTO ons_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na welekatne ŋidane ramaile. Medep nigatne eŋe Anutuŋo wareoniakane siminonmaike. Ŋo ŋei natne eŋe Anutuŋo wareoniakane mi siminonmaikeo, eŋe Anutu wane ware ware kepeo mi wakesikei.” ");
INSERT INTO ons_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yale ra more medep nigatne yewa edoka ebu okora metine kuteno more mosoponge. ");
INSERT INTO ons_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu eŋe wie yewa qelige ariki numao ŋei mane eŋe biririke sari Yesu wane osino pese ket kino wawetine qe more qesonka rake, “Kito ŋebo ŋebon, maepne. Na dalino okane more naso baŋem gege togon maratka geokanikale?” ");
INSERT INTO ons_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yale raki, Yesuŋo olatke, “Ge na mayakatne onoka wane noramaine? Anutu wekuŋo mayakatne so eŋe wekuŋo koboboine. ");
INSERT INTO ons_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ge Anutu wane papa togon don detmaine. Ge ŋei mane mi qenom seukeake. Ŋire ŋaoŋanom mi biranagukeik so ŋei me ŋerep mane misuk maikeik. Ge kobu mi maikene. Ge ŋei mane mi ma baikkaikene. Ge ŋei mane mi isikaikene. Ge nabok magak erane bango ge more erane don dereretkoka ge okanikene.” ");
INSERT INTO ons_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ŋei yewa eŋe rake, “Kito ŋebo ŋebon, na mo medepnoka tego yewa mane mi yuankakole. Mo korop okane gesakole gemaile iwa.” ");
INSERT INTO ons_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu eŋe ka more eŋane simile dere more olatke, “Ge kine kine weku mi okanine. Ea makoboenom, ge ari more wesi aboŋŋone korop ea ma more ŋei aboŋene midaine eŋe sunonikene. Sunone more yalinane baŋ gege togon mat marat kaikene. Pakiso geŋone sari ŋadeno mogatnane sarikene.” ");
INSERT INTO ons_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","don yale dere more, ŋei yewa eŋe kaitine bori more zok manerop zoileke, so qomine umareki, qelige arike, onoka wane, ŋo eŋe aboŋine zok manerop umatne pamangane, eŋe yale okane so eŋe yeine qelige arike. ");
INSERT INTO ons_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ŋei yewa eŋe ariki, Yesuŋo zinge pore lolike dokoine one edane rake, “Ŋei yaline wesi aboŋene suaine, eŋe Anutu wane qeli ewe zonom koto wakesikei wane rau, eŋe zok umareake, so eŋe zok urata suaine ma more aboŋene qeliŋkamami.” ");
INSERT INTO ons_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Dokoine eŋe don yale raki dere poradageu, Yesu eŋe koso edane rake, “Oo dokone, ŋei ŋerep eŋe Anutu wane qeli ewe zonom kotino wakesikei wane rau paki, eŋe urata suaine maikei! ");
INSERT INTO ons_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel eŋe samap wane aŋaone wakesikei wane ea urata suaine zok mi okaniake. Ŋo, baliŋa ŋei eŋe Anutu wane qeli ewe zonom koto wake waket, eŋe urata suaine zok manerop ma more aboŋine qeliŋkamaike.” ");
INSERT INTO ons_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dokoine eŋe eŋane don dere more oŋaene qaeki enŋeneka auye qesonnagu rakoi, “Ge ramaine, Anutuŋo baliŋa ŋei mi wareoniake, yale okangi, ŋei ŋerep ketkele gemami, eŋe Anutuŋo mi wareoniake.” ");
INSERT INTO ons_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Eŋe yale rauso, Yesu eŋe deenoka pore one okora rake, “Kepeo ŋei ŋerep ŋine ŋaŋaemami. Ŋo Anutu wekuŋo eŋe mi ŋaŋaemaike. Anutu eŋe kine kine korop mawareakane, eŋe maine mi qekayake.” ");
INSERT INTO ons_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petoro eŋe don mane Yesu olale rake, “Detmaine! Ŋene kine kine kakize mo korop qeliŋkaware more ge mogatgangone, ge ŋene detŋonmaine.” ");
INSERT INTO ons_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesuŋo rake, “Na don wele ŋidanmaile. Ŋei mane eŋe naŋane dere more biŋek don qesiŋnane rasuakeiwane ra more matene, me tarekop, ŋon, qa, kiaro, me nabok, magak, kepe, medep, qeliŋkawareone sari na mogatnaniakeo, ");
INSERT INTO ons_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ea wane turuŋine Anutuŋo zok manerop makoke maniake. Naso iwa yaleo yemo eŋe kepe, mat, ŋon, qa, tarekop, kiaro, me nabok, magak, medep, korop maratkayake. Ŋei edo ŋei yewa wikile wakile takotke maratkaikei. Baŋ naso kutno eŋe gege togon maratka geake. ");
INSERT INTO ons_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ŋei loutne ukude tego lewine okoramami. Eŋe naso kutno mawe tego ŋadino kesikei. Ŋo ŋei loutne ukude tego ŋadino okoramami, eŋe naso kutno mawe tego lewine waikei.” ");
INSERT INTO ons_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu eŋine so dokoine Yerusalem arikei wane arikoi. Yesu eŋe alakane ariki dokoine eŋe dere mezet okangoi. So ŋei ŋerep magu ŋadeeno arikoi. Eŋe kaetonge, Yesu eŋe dokoine 12 yewa koso ebu qeduguone more, eŋine ariki masi tanik kine kine solaino wakonkayake ea wane kieke edange. ");
INSERT INTO ons_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Eŋe rake, “Detmami! Ukude ŋene wa Yerusalem lotkeŋem. Ŋei maneŋo Ŋei Wawainane Gipole ea Anutu wane mosop ŋei so Anutu papa togon welaine ŋei, Skribe, eŋane meteeno birakaki edo seukeakane ra togole more lobo ŋei eŋano birakaikei. ");
INSERT INTO ons_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Edo wawaine don olale more, sopotka kiŋ quŋ qe more, qeu seuke more deŋesereo payake, paki kaiwe mama karewe qoeki koso wisikae wieyake.” ");
INSERT INTO ons_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedi wane gipoletkine Yakop so Yohane ere Yesu wane osino sari more rakoik, “Kito ŋebon ŋebon, ŋere kine kine mane wane qeson ganiketane sarimaite. Ge kine kine yewa ŋerano weneŋ maikenane ŋotmaike.” ");
INSERT INTO ons_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Raukso, eŋe qesonore rake, “Na onokaka ŋirano weneŋ maikalane? ramamik!” ");
INSERT INTO ons_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ere rakoik, “Ge dere, ŋere ma wakone bira ŋotnom. Naso ge ŋei waom met metko mesikene, yewao ŋere weneŋ wazaŋone nat nat mesikete.” ");
INSERT INTO ons_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu eŋe etane rake, “Ŋire ea wane kine mi detlukkeuk paki, na qeson nanmamik. Na dere umat wikile kine kine zok manerop maikale. Ŋire ea maine okanikeik me?” ");
INSERT INTO ons_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ere rakoik, “Oo, ea ŋere maine okanwarekete!” Raukso, Yesuŋo etane rake, “Ŋire naŋane wikile nat parom welekatne desikeik. ");
INSERT INTO ons_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ea wane maine ŋitanikale. Ŋo wazane nat nat met met ea wane noŋo maine mi ŋitanikale. Anutu oŋomka met met yewa ŋei maŋane maulukke, ea eŋe ŋine maniake.” ");
INSERT INTO ons_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Dokoine mete etke eŋe yale dere more Yakop so Yohane erane zok sotene osike. ");
INSERT INTO ons_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu eŋe edoraki, dokoine korop sariu edange, “Ŋine detmami lobo ŋei ŋerep eŋane ware ware biraka okanmami, ŋei yewa eŋe ŋei ŋerep zonomene togogoleŋo magu ma pese one more eŋane ware ware togogole wareonmami. ");
INSERT INTO ons_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Masi yewa koso ŋinane keuo mane misuk wakoniake! Midakaka togogole! Ŋei ŋinane keuo ŋine ware wareŋine okorayakane, ra more eŋe ŋei magu eŋane qelit qeqe okaniake. ");
INSERT INTO ons_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ŋei ŋinane keuo ŋine ŋetneŋine okorayakane, ramore eŋe ŋei magu eŋane qelit qeqe okaniake. ");
INSERT INTO ons_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Na, Ŋei Wawainane Gipoleŋo sarikole, na ŋei ŋerep korop eŋane qelit qeqe okane more qesiŋ ŋunmaile. Ŋei ŋerep edo na mi qesiŋ nanmami. Na, ŋei ŋerep qesiŋone more solane qikkawe ŋei ŋerep ma menaŋ oniakane sarikole.” ");
INSERT INTO ons_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Eŋe ari Yeriko matko lotke more ea yuane arikoi, eŋine dokoine so ŋei ŋerep magu suaine weneŋ arikoi. Ŋei mane deine pilik pilikine eŋe numa wazaino metke. Eŋetine Bartimeus. Eŋe Timeus wane gipole. Eŋe mere ŋei ŋerep edo kine kine natne qesiŋ kaikeiwane boka woka metmaŋke. ");
INSERT INTO ons_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Eŋe mere detki rakoi, Yesu Nazaret ŋei, eŋe done mo sarimaike, pakimo, ŋei yewa eŋe kieke togogoleka boka rake, “Oo, Yesu, ge Dawit wane ŋaboine, ge ŋetne bira ganiakane Anutuŋo mo rake. Ge naŋane wetŋone borikep!” ");
INSERT INTO ons_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ŋei ŋerep magu yewa edo kuroŋka rakoi, “Ge aŋaŋone ma wonge metnom!” Rau eŋe soringe togoleka koso boka rake, “Dawit ŋaboine ge siluŋ naŋane wetŋone borikep!” ");
INSERT INTO ons_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yale ra bokaki, Yesu eŋe dere more paŋ lalipke okora edane rake, “Orau! Wie iwa sarikep!” Eŋe de pilik yewa ora more olale rakoi, “Wet pesek suaine dere more wie sa arinom. Yesuŋo eŋano arikenane goramaike.” ");
INSERT INTO ons_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eŋe dere esatka kaŋzaŋ wie more, momo takotine kiroine yewa makoke more, Yesu wane osino arike. ");
INSERT INTO ons_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesuŋo olatke, “Na dalino okanganikalane ramaine?” Ŋei deine pilik pilikine eŋe rake, “Kito ŋebon ŋebon na dene koso posikalane ramaile.” ");
INSERT INTO ons_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesuŋo olatke, “Ge maine koso arinom. Mali malipŋoneŋo maki deŋone potmaine.” Yale raki, ikopka deine lotkeki pore ka more, Yesu ŋadino mogare arike. ");
INSERT INTO ons_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Eŋe ari Yerusalem mat osino lotkekoi paki, ari mat etke metkoik, Betpage so Betani ere Oliwa bonaga wane wazaino metkoik. Yewa okorau so Yesu eŋe medewetkine etke matokotke. ");
INSERT INTO ons_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Matok ore more iwa yale etane rake, “Ŋire ari Betani mat eriwa meuno tingo pamaike. Ea wa more pore kauk horsi nigatne mane medeune mulapko lukkau okorayake. Horsi ea ŋei maneŋo kutno wa mi metmele, ea ka more mulap siloke so ma sarikeik. ");
INSERT INTO ons_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ŋo, ŋei maneŋo qesonŋure rayake, ‘ŋire ea onoka wane okanmamik?’ Rakiso, ŋire iwa yale olale raikeik. Suaineŋo raki sari mamaite. Urata qoekimo koso ikop birakaki sariake.” ");
INSERT INTO ons_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yale ra etane biraotki ere ari yewaka pore kauk mat mane numa meuno pake yewao horsi nigatne medeune mane mulapko luo okoraki, ere ka more silokkakoik. ");
INSERT INTO ons_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ŋei natne eŋe yewa osoetno okorakoi, eŋe ore more rakoi, “Ei, ŋire dalino okangeik wane, horsi medeune ea silokkamamik?” ");
INSERT INTO ons_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Rauso ere Yesuŋo don etange yale edanbik eŋe detpi qoeki oŋ rau, so ere ma sarikoik. ");
INSERT INTO ons_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ere horsi medeune ea Yesu wano ma sari more, eretne momo takot suaine eaŋo kutno motpik, so Yesu ea wane kutno wa metke. ");
INSERT INTO ons_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pakiso, ŋei ŋerep korop eŋe momo takotene kito qoke numao horsi kine gesoke ariakane lameke arikoi. Ŋei ŋerep natne eŋe zariŋ awak so eki metine eaŋo rutupke lamekkoi. ");
INSERT INTO ons_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yesu eŋine keuo kitoki ŋei magu natne ŋado kitou magu natne eŋe alakane more, iwa yale boka ra pezoŋka bakom kito arikoi, “Ŋene Anutu wane oraŋem! Ŋei iwa Waomŋo eŋine tungo birakaki sarimaike! Anutuŋo mosopkakep! ");
INSERT INTO ons_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ŋaboze Dawit ŋaboine sari ware ŋoniake! Aŋelo eŋe qeliwo Anutu wano orau!” ");
INSERT INTO ons_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Eŋe yale okankau, Yesu eŋe Yerusalem lotke more Anutu Wane Bakom Urum koto waket more kine kine kotino pake ea korop kawareke. Kepe mo qoeakane okangi, Yesu eŋe dokoine 12 yewa ebuki, Betani ari pakoi. ");
INSERT INTO ons_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kepe qaeki sakoka eŋe wie more Betani mat qeliŋka sari numa keuo Yesu eŋe ŋara wane seukke. ");
INSERT INTO ons_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Seuke more deine potki ariki kaki fik mane metine loutneŋo supakaki qei amaŋ okorake Yesu eŋe wele natne mayakane okane ari fik eki kino okora pore kaki wele mane mi metke. Midaka togole. Onoka wane, wele qeqe nasoino mida wane, eŋe pore metineka kake. ");
INSERT INTO ons_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Paki, Yesu eŋe fik yewa olatke, “Ge koso ŋado wele mane mi qekene! Midakaka togogole!” Dokoine eŋe ea detkakoi. ");
INSERT INTO ons_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Eŋe ari Yerusalem lotke more, Yesu eŋe ari Anutu Wane Bakom Urum kotino waket more ŋei ŋerep nalu qole qole urata ea wane kotino ma metkoi, ea kieke more osoponge. Ŋei eŋe zake yewa kutno mere wesi setne maingekoi, so met met kutno mere naŋi qole qole urata ma metkoi, ea korop kito surubage qakki ketke. ");
INSERT INTO ons_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Paki, eŋe kine kine koso Anutu Wane Bakom Urum wane sen koto mi ma waket saket okangei wane ra togoleke. ");
INSERT INTO ons_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ra togole more iwa yale edange, “Anutu wane papaiŋo iwa yale ramaike, ‘Urumne ea eŋe ŋei ŋerep kepe baŋem ŋine maguine maguine sarikei, eŋane meŋe meŋen urum okaniake.’ Ŋine yale okanbimo, kobu ŋei eŋane mat okanmaike.” ");
INSERT INTO ons_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yesu eŋe yale raki, Anutu wane papa togon welaine ŋei, Parisi, so Anutu wane mosop ŋei, Pris, eŋe dere more auye rakoi, “Ŋene dalino okane more qeŋem seukeake.” Ŋo, ŋei ŋerep eŋe korop Yesu wane kito ebo eboninane zonomineŋo detkau, zok manerop ewinerop okange, ea wane Parisi so Pris eŋe kaetongi, qeliŋkakoi. ");
INSERT INTO ons_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ruo kereki naso yewao Yesu eŋine so dokoine eŋe Yerusalem qelige so ket arikoi. ");
INSERT INTO ons_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Qaeki sakoka, eŋe ari kau, fik eki wele midaine yewa mo toroge okorake. Metine so ŋodine kaki korop marapke okorake. ");
INSERT INTO ons_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petoro eŋe Yesuŋo okange, ea detsoroke more Yesu olatke, “Kito ŋebo ŋebon, ge fik iwa kanom! Ge yatne soakkene, eŋe mo marapke okoramaike.” ");
INSERT INTO ons_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu eŋe mainge rake, “Ŋine Anutu malipkau. ");
INSERT INTO ons_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ŋine maine bonaga iwa olale raikei, Ge wie more sontake ari kiwetko ketnom! Ŋine wet etkeka mi okane more, wet weku okane raikeiwo, welekatne donŋine welerop okaniake. Ea wane na ŋidanmaile. Kine kine ŋine yewaŋo raikei, rokop mawe wakoniake. ");
INSERT INTO ons_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ŋo, ŋine kine kine natne Anutuŋo ŋiboniakane meŋenkaikei, naso yewao ŋine Anutuŋo kine kine mo ŋibonge ea togoleka dere malipka more meŋenkaikei. Na welekatne ŋidanmaile. Ŋine yale malipka more meŋenkaikeiwo, Anutuŋo kine kine ea ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Naso ŋine meŋen meŋen more okora more, ŋei maneŋo umat mane mo ŋinano make ea detsoroke more eŋane turuŋ yewa qeliŋkawarekei. Yalewaka magaŋine weti qeliwo metmaike, eŋe ŋinane turuŋŋine yewa qeliŋgi nigetkayake. ");
INSERT INTO ons_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ŋo, ŋine ŋei ŋerep eŋane sot turuŋene mi qeliŋkau niget ŋuniakeo, magaŋine weti qeliwo metmaike eŋe yalewaka ŋinane sot turuŋŋine ea mi qeliŋgi nigetkayake.” ");
INSERT INTO ons_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu eŋine so dokoine eŋe zinge ari Yerusalem lotke more Yesuŋo Anutu Wane Bakom Urum kotino ari waket lolike geki Anutu papa togon welaine ŋei so Anutu wane mosop ŋei ŋetne so Yuda ŋei ŋetne eŋe Yesu wano sarikoi. ");
INSERT INTO ons_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Sari olale rakoi, “Ge eŋet biŋek so zonom ea diao ŋine manom paki, kine kine ea korop okan waremaine? Maŋo eŋet biŋek suaine ea gingane, ge urata ea ma okanmaine? Ge yatne Anutu wane Bakom Urum koto ŋine kine kine ea ma qakenom, korop saket warike, zonom eamo maŋo gingi, ge okanine?” ");
INSERT INTO ons_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu eŋe mainge edange, “Na yaleka ŋine qeso qeson weku qeson ŋunbe, naŋane qeso qeson yewa mainge nolatpiso na masi kine kine ea maŋane dereretko mamaile ea wane kine rawe desikei. ");
INSERT INTO ons_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohane wane doku tau tau urata ea qeliwo ŋine wakonge, me ŋeiwo ŋine wakonge? Ea ŋido mainge nolatpi detpe.” ");
INSERT INTO ons_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Eŋe yale ra qeson ongi eŋe dere more enŋene auye rakoi, “Ŋene raikene ea qeliwo ŋine wakonge, yale ra olatŋem eŋe rayake, pakimo ŋine onoka wane ea mi dere malipkamami? ");
INSERT INTO ons_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Me ŋene raikene, ŋeiwo ŋine wakonge, ea raŋem maine mi konapkeake.” Ŋei ŋerep eŋe Yohane wane detkakoi, eŋe Anutu wane qelit ŋei wele, ea wane Pris eŋe dere more kaetongi, ");
INSERT INTO ons_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","don iwa yale mainge Yesu olale rakoi, “Ŋene mi detmaine.” Eŋe yale rauso, Yesuŋo edange, “Na yaleka, na maine mi maŋo qeli ewe zonom ningi, urata ea mamaile, eamo mi ŋidanikale.” ");
INSERT INTO ons_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu eŋe don rokop natne iwa yale more edane rake, “Ŋei maneŋo wain eu ebore more sen pise qeare more, lom yaso taŋ eaŋo wain woune lapelekeake, ea wane mauluke more mat bosiŋine kiroine wetika weti maki yewa waki eu yewa warelukkake. Eŋe ŋei natne eŋane meteeno motki edo urata yewa ware ma geu eŋine qelige lobo kepe yewao ari geke. ");
INSERT INTO ons_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Eŋe yewa geki wain wele mena menaŋ nasoine okangi mo qelit medepine mane birakaki eu ware ware eŋano wele natne manbi ma sariakane arike. ");
INSERT INTO ons_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pakimo, eu ware ware eŋe wie qelit medep yewa malipka more kiŋ quŋ kito osopkau, eŋe metineka zinge arike. ");
INSERT INTO ons_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ariki, eu welaine eŋe koso qelit medep mane birakaki ariki eŋe yalewaka qe lewine rasipoke manerop matalikakoi. ");
INSERT INTO ons_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Eŋe soringe koso qelit medep mane birakaki ariki, ea yemo komu komune qeu seukke. Eu welaine eŋe ŋei loutne biraongi ariu eu ware ware edo kawali ma wakone more ŋei natne ziwem engukoi ŋo, natne komu komune seuseune engukoi. ");
INSERT INTO ons_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pakimo, eŋe eŋine gipole wemedep wekuku wetineŋo malipka geke. Ea wane eu welaine eŋe iwa yale detke. ‘Ŋine nae medep iwa wane aŋaine teweke more ewine kitokei.’ Yale dere more eu ware ware eŋano birakake. ");
INSERT INTO ons_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pakimo eu wane ware ware ŋei eŋe medep yewa ka more auye rakoi, ‘Medep yewa eŋe gemage magainane eu so kine kine eu koto pamaike, iwa ŋebu ma more ea wane welaine okane wareoniake. Ea wane ŋene qeŋem seukkiso ŋedo eu iwa welaine okane warekene.’ ");
INSERT INTO ons_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yale rau paki ma more qeu seukki pareŋine ea eu ŋadino birakau ketke. ");
INSERT INTO ons_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Pakimo, eu welaine eŋe dalino okaniake? Eŋe sari eu ware ware yewa engu, rasu pelekki eŋe korop seuke midakei. Midau mo eŋe koso eu ware ware musele ma wakone biraoniake. ");
INSERT INTO ons_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Na iwa don rokop ra qelaŋanmaile. Ŋine don nat paromine mane Anutu wane papiao mi dapore det okanmami mane? ‘Mat mama urata ŋei eŋe mat wane bosiŋ mane ea eki pelekine ra more qikka yeine birakei. Wane ŋado eŋe koso kau mat wane banega bosiŋ togogole okange. ");
INSERT INTO ons_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Waom eŋe ŋado yale okangi, ŋene kaŋem wekumane okaniake.’” ");
INSERT INTO ons_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yale ra edangi, Yuda ŋetne eŋe detpi Yesuŋo don rokop ea qeki, korop eŋanoka ariki rawaeke. Pakimo, eŋe Yesu malipka wokomkaikei wane wetkekoi ŋo eŋe ŋei eŋane kaetonge, yalinane eŋe yeine qeliŋka arikoi. Ŋei ŋerep ene Yesu wane don dere siminonge yewa wane Yuda ŋetne eŋe kaetongi, Yesu qeliŋka arikoi. ");
INSERT INTO ons_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yuda ŋetne eŋe Anutu papa togon welaine ŋei, Parisi, so Herot wane tego natne biraonbi Yesu wano arikoi. Ŋei yewa eŋe Yesu dongo qe isikau, don mataliki, don uratao birakakei wane arikoi. ");
INSERT INTO ons_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Eŋe ari more Yesu olale rakoi, “Kito ebo ebon, ŋene ge detluk ganmaine. Ge isi don mane mi raraŋone, ge don wele rara wane ŋei. Ge ŋei mane wane mi kaetgan okanmaike. Ge ŋei ŋerep natne don mane edane more koso ŋei ŋerep magu natne don mane mi edane okanmaine. Midakaka! Ge don wele so Anutu wane masi koboboine kito, ŋei ŋerep iwa korop sikan ŋone okanmaine. Ŋenze ra rokop donze ea wane ge dalino detmaine? Maine ŋene takis Roma kepe ware ware suaine manikene me mida?” ");
INSERT INTO ons_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ŋo, Yesu eŋe isisienane kine ea mo detone more edane rake, “Onoka wane ŋine na liwek nanmami? Eso, yale wane ŋine wesi yewa mane ma sariu kawe.” ");
INSERT INTO ons_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yale raki, eŋe wesi mane ma more, Yesu wane osino ma sariu, eŋe qeson one rake, “Oŋaoŋa iwa so eŋet iwa maŋane?” Eŋe rakoi, “Roma kepe ware ware suaine eŋane eŋet so oŋa oŋa.” ");
INSERT INTO ons_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Pakimo, Yesu eŋe donene mainge rake, “Roma kepe ware ware suainane biŋek kine kine ea maine eŋine manikei, ŋo Anutu wane biŋek kine kine ea eŋe eŋine Anutu manikei.” Yale raki, ŋei magu yewa eŋe Yesu wane don dere oŋaene qaeke, qiselukkoi, so dereret siuke. ");
INSERT INTO ons_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yuda ŋei ŋetne, Sadusi natne, eŋe Yesu wano sarikoi. Magu yewa eŋe yale raokangoi ŋei seuseune eŋe koso mi wiekei. Ea wane eŋe Yesu qesonka rakoi, ");
INSERT INTO ons_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kito ebo ebon, sogino, Moseŋo ŋenze don mane iwa yale qeke. ‘Ŋei mane eŋe seukeake, eŋe medeune midaine, ŋo, ŋanomine eŋe yeka geake, pakimo ŋei seukke eŋane ŋole eŋe tatine qesiŋka more ŋerep yewa oŋo koso ma more medep mane ma wakoniake.’ ");
INSERT INTO ons_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ŋenane donkisi detnom. Donkisi iwa eŋe tati ŋon sewen(7) yale gekoi. Wane tatene suaine eŋe ŋerep ma ge more medep mane mi ma wakone eŋe yaup seukke. ");
INSERT INTO ons_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pakimo, ŋole kebaŋine oŋo tatinane mala ea make. Eŋe yaleka medep mane mi ma wakone more eŋe seukki, ŋole ŋorikine eŋe yalewaka okange. ");
INSERT INTO ons_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Yalewaka tati ŋon sewen(7) yewa eŋe ŋerep wekuka makoi, ŋo, medep mane mi ma wakone more, eŋe yaup seukwarekoi. Pakimo ŋerep yewa eŋe yaleka ŋado baŋ seukke. ");
INSERT INTO ons_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Boaŋ naso ŋei seuseune eŋe wisikae wiekei, yewao ŋerep yewa eŋe maŋane ŋerep biŋek okaniake? Ge detmaine. Ŋei tati ŋon sewen eŋe ŋanomene weku yewa makoi.” ");
INSERT INTO ons_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu eŋe mainge rake, “Ŋine Anutu wane papiao don pamaike, ea ŋine mi detlukmami. So ŋine Anutu wane zonomine ea ŋaŋaeka more ea wane don yewa qeyau ramami. ");
INSERT INTO ons_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ŋei seuseune eŋe deŋesereo ŋine wisikae wiekei, naso yewao eŋe koso ŋao ŋanom mi okanikei. Midakaka! Eŋe qeliwo aŋelo yale gekei. ");
INSERT INTO ons_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ŋei seuseune eŋe wisikae wiekei, eŋane don yewa Moseŋo kibi qeke. Ŋine yewa mi dapotkoi me? Naso yewao eki nigatnane kutno gerep zeke, eao yewa wane donkisi Anutuŋo Mose olatke, ‘Na Abraham wane Anutu, so Isak wane Anutu so Yakop wane Anutu okanmaile.’ ");
INSERT INTO ons_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Anutu eŋe ŋei wisika gemami eŋane Anutu. Don ea wane kine iwa yale, Abraham, Isak, Yakop kepe solaŋo seukoi, ŋo oŋaoŋaeneŋo naso yewao wisika gemami! Anutu eŋe ŋei seuseune eŋane Anutu midakaka! Ŋine don yewa qeyau rawaremami!” ");
INSERT INTO ons_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yesu eŋe yale raki, eŋe don auye kitat metpi, Anutu papa togon welaine ŋei mane eŋe sari detkaki, Yesu eŋe don koboboine mainge edangi, eŋe Yesu qesonka rake, “Ge ranom! Anutu wane ra rokop don eŋano ŋine diawaŋo ŋetne okanmaike?” ");
INSERT INTO ons_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu eŋe donine mainge rake, “Iwa yaleŋo Anutu wane ra rokop don ŋetne okanmaike. ‘Israel ŋei ŋerep detpi! Waom eŋe ŋenane Anutu okanmaike! Eŋe waom wekuku! ");
INSERT INTO ons_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ŋine wet dereretŋine, so oŋa oŋa ŋine so zonomŋine korop Waom ŋine Anutu eŋane siminŋungi ma qotkau!’ ");
INSERT INTO ons_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Anutu wane ra rokop don ŋetne yewa wane bano, koso mane etke okanmamik yemo, ‘Ŋine wetŋineŋo ŋidomka ma qot nagugekei! Yalewaka ŋei ŋerepkopŋine korop wetŋineŋo ma qotonikei.’ Anutu wane ra rokop etke yewa koso maneŋo etke iwa mi yuan otmaike.” ");
INSERT INTO ons_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Anutu papa togon welaine ŋei yewa eŋe Yesu olale rake, “Kito ŋebon ŋebon ge don maine ramaine! Oo welekatne! Waom eŋe wekuŋo Anutu okanmaike. Koso mane mi gemaike. ");
INSERT INTO ons_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ŋene wet dereretze so oŋaoŋaze so zonomze korop Anutu wane siminŋongi, ma qotkaŋem! So ŋenze wetzeŋo ma qotnagukene. Yalewaka ŋei ŋerep korop ma qotonikene. Ŋene ra rokop don etke iwa mogasikeneo, masi etke eaŋo Anutu wane bakom natne lama bulamakaŋo mire okanmami, ea korop yuan onikeik.” ");
INSERT INTO ons_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu eŋe ŋei yewa don raraine detkaki weku mane koboboine ŋei dereret koropŋo ramami, yale mainge raki, detka more ŋei yewa olale rake, “Ge Anutuŋo ŋei ŋerep wareŋuniakane kine daleo ea detkenane qou qou okanmaine.” Yesu eŋe don yale raki, ŋei ŋerep natne eŋe don natne Yesu qeson kaikeiwane kaetongi, koso don mane mi qesonkakoi. ");
INSERT INTO ons_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu eŋe Anutu Wane Bakom Urum koto mere ŋei ŋerep kito ebone more iwa yale rake, “Ŋo onoka wane Anutu wane papa togon welaine ŋei, Skribe, eŋe Mesia wane ramami, eŋe eŋineka Dawit wane ŋaboine, kepe ŋei eŋineka. ");
INSERT INTO ons_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mesiaŋo ŋei ŋerep ma menaŋ oniakane, Anutuŋo ma wakonkake. Anutu wane Asu Koboboineŋo Dawit dereret mange, pakimo, Dawit oŋom rake, ‘Magak Suaineŋo naŋane suaine Mesia iwa yale olatke, “Ge naŋane wonnoken mesikene, pakimo, noŋo ŋabakopŋone, eŋe biraonbe, geŋane banŋono mesikei.” ’ ");
INSERT INTO ons_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawit oŋom Mesia wane eŋe suainene rake, wane mo eŋe daleo wane Dawit wane ŋaboine?” Ŋei ŋerep magu suaine eŋe Yesu wane don dere more, siminongi bakom kitokoi. ");
INSERT INTO ons_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu eŋe iwa yale kito ebonge, “Ŋine Anutu wane papa togon welaine ŋei eŋane kaulukonikei! Eŋe takot kiroine kibinerop bira more arikei wane siminone okanmaike. So eŋe lewalewaŋ sobego taŋ tuŋ zarak zurak geu ŋei ŋerep edo one ma wa one more eweene kitou geokanmami. ");
INSERT INTO ons_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Eŋe Yuda lewa lewaŋ urum koto so epa kebu eao met met ŋetno mesikeiwane okan okanmami. ");
INSERT INTO ons_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eŋe yale okane more ŋerep mala eŋane mat oma one okanmaŋkei. Omakone more eŋe sari Yuda lewa lewaŋ urum koto ŋei ŋerep eŋane deo okora Anutu wano meŋe meŋen kiroroine meŋenka okanmaŋkei. Ŋei yaline yewa eŋe gemage ŋado Anutuŋo wikile suaine eboniake.” ");
INSERT INTO ons_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu eŋe Anutu Wane Bakom Urum wane wesi katapa osino metke. Mere ŋei ŋerep one metki ari wesi katapa koto birau ketke. Ŋei wesi aboŋene suaine loutne eŋe wesi suaine motkoi. ");
INSERT INTO ons_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Paki mo, ŋerep mala wesi aboŋine nigatnemde eŋe sari toea etke biraki ketke. ");
INSERT INTO ons_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ea wane Yesu eŋe dokoine edoraki sariu edange, “Na welekatne ŋidanmaile, ŋerep mala ŋaone mo seu seune, aboŋine nigatnemde eaŋo wesi manerop motmaike, eŋe ŋei ŋerep wesi aboŋene suaine eŋane bakom wane wesi motmami, ea yuanonmaike. ");
INSERT INTO ons_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ŋei ŋerep wesi aboŋene suaine pake, ea ŋine nigatnemde so natka Bakom Urum wane laseo motkoi, ŋo ŋerep mala iwa eŋe zok wesi wane ziaŋ lulukke, ŋo eŋe koropka birawareke, eŋe wesiine mane doku ŋara qoleakane maune mi motki metke.” ");
INSERT INTO ons_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu eŋe Anutu Wane Bakom Urum Suaine qeliŋka more ket ariki, dokoine eŋano ŋine maneŋo olale rake, “Kito ŋebo ŋebon, ge so Anutu Wane Bakom Urum, so eŋane urum ketkele weku mane, weku mane iwa onnom!” ");
INSERT INTO ons_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yale raki, Yesuŋo mainge rake, “Ŋine kau mat iwa zok suaine okanmaike me? Naso kutno ŋei ŋinane ŋei ŋaba eŋe mat iwa matalikeiwo, eŋe wesi mane mi qeligeu weti kutno mesiake, midakaka! Eŋe koropŋo saket din bun kitopoke qakeu ket ari wareake.” ");
INSERT INTO ons_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu eŋe Oliwa bonagao mere pore kaki Anutu Wane Bakom Urum nat metke. Yesu so Petoro so Yakop so Yohane so Andrea enŋeneka metkoi. ");
INSERT INTO ons_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Mere more eŋe Yesu qesonka rakoi, “Ge ranom detŋem, naso dango Anutu Bakom Urum ea poripkeake? Onokaka kine kine maneŋo mikep wakone sikanŋongi, ŋene ea ka more raikene, Anutu Wane Bakom Urum mo wiriakane nasoine bomilemaike?” ");
INSERT INTO ons_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu eŋe edane rake, “Ŋei loutne eŋe sari isi ŋunikeiwane ŋine kaulukkei! ");
INSERT INTO ons_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ŋei loutne eŋe sari more naŋane eŋetne nora more raikei, ‘Na Kristo.’ Yale ra more ŋei ŋerep loutne isi onikei. ");
INSERT INTO ons_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ŋine baŋ kawali suain suaine ea ukatneka desikei, so momo don, kawali natne kepe nat parom ramaike, ea dere mo qomŋine misuk umareake! Kine kine yaline korop wakoniake. Ŋo, qeli so kepe nasoine yemo ikop mi qoeake. ");
INSERT INTO ons_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mat mane eŋe wie ari mat mane eŋerop kawali yaku matali okanikei. Ŋei kepe maneo ŋine eŋane ŋei waom eŋe ari kepe mane wane ŋei waom eŋerop yaku matali qetali okanikei. Kepe loutne memea suaine ma paki, ŋara wane bodi wakoniake. Ŋerep edo medep ebukeiwane gae kieke ebumaike. Naso yewao wikile yaline kieke wakoniake. ");
INSERT INTO ons_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ŋei edo sari ŋibu ari kaunsol eŋano dongo bira ŋunikeiwane kauluk nagukei. Eŋe ŋine Anutu wane lewa lewaŋ urum koto zinge more, ŋibu ari biraŋunbi kepe ware ware eŋane deo okorakei. Yewa ŋine biŋek don ra edanikei. ");
INSERT INTO ons_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Alakan, ŋine kepe baŋem ŋei ŋerep korop eŋane biŋek don ra qelaŋane edanikei. Pakiso, kepe qeli naso etne qoeake. ");
INSERT INTO ons_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ŋei edo ŋibu ari kaunsol eŋano dongo bira ŋunikei, naso yewao ŋine dere mezet mi okane raikei, ‘Ŋene kaunsol dalino edanikene?’ Ea mida! Ŋine eŋane deo okorau, naso yewaka Anutuŋo dereret ŋino don mosiake, yewa ŋine ra qelaŋanikei, eamo ŋidom mi raikei, yemo Asu Koboboineŋo rayake. Anutu wane Asu eŋe weneŋ ŋinerop okora ŋidangi edanikei. ");
INSERT INTO ons_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Naso yewao ŋei mane eŋe tatine me ŋole ma ari kaunsol eŋano dongo birakaki qeu seukeake. Yalewaka magak eŋe dokoene ebu ari kaunsol eŋane dongo biraonbi enguwi seukkei. Yalewaka dokoetne eŋe naga magaene epu ari kaunsol eŋano dongo biraotpi etkuwi seukkeik. ");
INSERT INTO ons_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Naŋane eŋetneŋo ŋinano pamaike ea wane ŋei ŋerep korop eŋe ŋinane dere worik okanŋunikei. Ŋo, ŋei eŋe togole biŋek don malipka okorayakeo, Anutu eŋe qeli kepe qoiqoi nasoo ŋei yewa mayake.” ");
INSERT INTO ons_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesuŋo iwa yale rake, “Ŋine Ŋei Madoŋ Madoŋine so Matali Matali Kaetinerop kau Mat Kobekine, yewao wakone okorayake. Eŋe Anutu wane tun ma more isisine okorayake.” (Ŋei mane eŋe kibi iwa dapore kine detlukeake.) “Naso yewao ŋei ŋerep Yuda kepeo ŋine kaet okane biririke bonagao arikei. ");
INSERT INTO ons_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ŋei mane eŋe mat sekaino mesiake, eŋe mat koto mi wa more kine kine natne mayake, eŋe yeine qelige kaet ariake. ");
INSERT INTO ons_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ŋei mane eŋe euo geakeo ŋine, eŋe koso mi zinge ari matko momo takotine mayake, eŋe yeine qelige kaet ariake. ");
INSERT INTO ons_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ŋerep medep ŋat korop so medep abuburop, eŋe wikile suaine zok manerop desikei. ");
INSERT INTO ons_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ŋine Anutu meŋenka olatpi, ‘Kine kine yewa koya momo naso misuk wakoniake.’ ");
INSERT INTO ons_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Naso yewao umat kakapa suaine wakoniake. Anutuŋo qeli so kepe mat ma wakonge naso yewa so naso iwa gemaine, ea wane keuno umat kine kine wakonge ea korop umat iwaŋo yuanka more wakoniake.Umat iwa qoeki ŋadino umat mane yaline mi wakoniake. ");
INSERT INTO ons_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ŋo Waom eŋe naso yewa wane umatine korop mi ma bomilemaikeo, yemo ŋei ŋerep korop mida lele warekene, Waom eŋe eŋine ŋei ŋerewekoune biraonge, ea wane naso iwa ma bomilemaike. ");
INSERT INTO ons_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Naso yewao ŋei maneŋo ŋidaniake, ‘Ŋeiwa Waomŋo ŋei ŋerewekoune ŋebuyakane, ea iwa kau, Kristo iwa metmaike!’ me ‘Kau! Eriwa metmaike!’ Ŋine misuk dere malipkakei. ");
INSERT INTO ons_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ŋei natne eŋe sari isiŋune more, iwa yale raikei, ‘Na iwa Waomŋo ŋei ŋerewekoune ŋibukalane biranange’ , me raikei, ‘Na propet mane,’ yale ra, masi tanik kine kine, tanikine kine mane kine mane maikei, so isiŋunikei. Ea welekakatne, eŋe maine ŋei ŋerep Anutuŋo mo eŋine biŋek biraonge, ea isionikei. ");
INSERT INTO ons_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ea wane ŋine kaulukkei! Na don kine kine mo korop ŋidanwarile.” ");
INSERT INTO ons_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesu eŋe koso iwa yale rake, “Umat kine kine suaine yewa midaki, naso yewao kepe deine mupkeki meso eŋe yaleka mi qelaŋaniake. ");
INSERT INTO ons_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Serekin eŋe qeliwo ŋine buratke ketpi, kine kine togole qeliwo eŋe korop qise warekei. ");
INSERT INTO ons_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Naso yewao kau. Na Ŋei Wawainane Gipoleŋo kezoŋ kutno qelaŋanne suaine so zonominerop wakone sarikale. ");
INSERT INTO ons_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Naso yewao na Ŋei Wawainane Gipoleŋo aŋelokopne biraonbe, qeli so kepe wazaino ŋine nat nat qei so weti ŋei ŋerep Anutuŋo mo ma wakone biraonge, ea aŋelokopne edo korop ebu sari qeturaŋ ŋonikei. ");
INSERT INTO ons_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Na eki fik wane kine kito ŋidanbe desikei. Eŋane metine posi qake more musele yabiki ŋine ka more raikei kaiwe naso okanmaike. ");
INSERT INTO ons_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yalewaka ŋine fik kine kine qotkoine ea wakongi ŋine yale desikei, Ŋei Wawainane Gipole nasoine mo bomile osop osop madetko sarimaike. ");
INSERT INTO ons_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na welekatne ŋidanmaile, naso sariake, naso eao ŋei ŋerep naso iwao wane biŋek eŋe mi seukeu, kine kine ea korop wakon wareake. ");
INSERT INTO ons_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kepe so qeli ere midakeik, ŋo, naŋane don yemo mi midayake.” ");
INSERT INTO ons_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesu eŋe koso manerop rake, “Ŋei maneŋo ea wane nasoine mi detkamaike. So qeliwo aŋelo magu so Anutu wane Gipole eŋe yaleka mi detkamami. Magak Anutu oŋomka detmaike. ");
INSERT INTO ons_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ea wane, ŋine kauluke more ware gekei! Ŋine naso mi detkamami. Ma nasoo yewa wakoniake. ");
INSERT INTO ons_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Masi tanik iwa yemo nasoo baŋ yalewa wakoniake. Ŋei mane eŋe matine qeliŋka more mat maneo ariakane okane more eŋe mat ware ware matokone biraongi edo eŋane kine kine warekei. Paki eŋe urata bonep bonep matoke biraone more ŋei mane aŋap wake waketko metke, yewa olale rake, ‘Ŋine diam togogole ma warekaikei!’ ");
INSERT INTO ons_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yalewa wane ŋine siluŋ warelukkei! Ŋine mi detmami, ma naso mat wane welaine sariake. Ŋine mi detlukkamami. Eŋe ruo kereake nasoo me ruo keuno me kaiwe wetemaike naso eao me kepe qaeqaewo sariake. Ea ŋine mi detlukkamami. ");
INSERT INTO ons_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mat welaine eŋe gege ikop sariki, qisekeiwane ŋine wisika mesikei. ");
INSERT INTO ons_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na don iwa ŋidanmaile eamo ŋine ŋei ŋerep korop ŋinane biŋek. Ŋine koropŋo warekalukkei!” ");
INSERT INTO ons_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kaiwe etke qoeki, aŋelo loloŋon loloŋon peada naso so bret patpale peada naso okange. Anutu mosop ŋei natne so Anutu wane papa togon welaine, ŋei eŋe auye rakoi, “Ŋene dalino okane more Yesu sanka ma more qeŋem seukeake? ");
INSERT INTO ons_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Eŋe rakoi, ea peada naso suaino mi maikene. Ŋei ŋerep eŋe dere worik okane more kawali ma wakonikei.” ");
INSERT INTO ons_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu eŋe Betani matko Saimon wane matko metke. Saimon eŋe sogino ŋei kubetine weneŋ mere mo menaŋge. Yesu eŋe Saimon wane zakeo ŋara ne metki, ŋerep mane eŋe kelok qoune simlerop lewine suaine ea beloŋ gorop ma sa more beloŋ rasipoke more kelok qounerop Yesu wane lewetino qakke. ");
INSERT INTO ons_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ŋei ŋerep natne metkoi, eŋe sotene osiki auye rakoi, “Onoka wane kelok qounerop sanda iwa matalimaike? ");
INSERT INTO ons_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ŋei maneŋo kelok yewa qoleakeo wesi setne 300 yaline ma more, ŋei aboŋene midaine eboniake.” Ra more ŋerep yewa dere worik okankakoi so don manerop rakoi. ");
INSERT INTO ons_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yale rau, Yesu eŋe rake, “Qeliŋkau! Onoka wane ŋine umat suaine mane ŋerep yewa don okankamami? Eŋe masi iwa weku mane naŋano mamaike. ");
INSERT INTO ons_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ŋei aboŋene midaine eŋe naso baŋem ŋinerop gekei, ŋine naso natneo eŋe mapikonbe ra ma okanikei, ŋo na yemo ŋinerop zok naso kiroine mi gekale. ");
INSERT INTO ons_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ŋerep eŋe kine kine mawe ra more maine mayake. Eŋe kelok qounerop solano motmaike eŋe deŋesereo wane ma ewek nanmaike. ");
INSERT INTO ons_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na welekatne ŋidanmaile. Kepe baŋem korop eŋe Anutu wane biŋek don ra qelaŋane more ŋerep iwa wane don kisi edane eŋetine detsorokka more bukeu wayake.” ");
INSERT INTO ons_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Naso yewao dokoine 12 eŋane keueno ŋine Yudas Iskariot eŋe mosop ŋei ŋetne eŋane meteeno Yesu bira kayakane arike. ");
INSERT INTO ons_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Eŋe dere more bakom kito more eŋerop tako rakot don au more wesi manikeiwane olatkoi. Yudas eŋe dere more yewaka kieke Yesu ma wakon kayakane so meteeno mosiakane numaine mane dere maulukke. ");
INSERT INTO ons_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bret patpalane soda weku kaiwe mane eao Yesu wane dokoine eŋe qesonka rakoi, “Ge detnom! Ŋene diawao ari mere Aŋelo Loloŋon Loloŋon Naso wane ŋara maulukkene?” Kaiwe yewa ŋei ŋerep eŋe Aŋelo Loloŋon Loloŋon Naso lama medeune koma baŋem qe nemaŋkoi. ");
INSERT INTO ons_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesuŋo dere more dokoine etke biraore etange, “Ŋire ari Yerusalem matko waket more ŋei mane kauk doku kap teweke sari numao marat ŋusiake. Yewa mogatka ariuk, ");
INSERT INTO ons_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","eŋe ari mat wakesiake, yewa ŋire ari waket more mat welaine iwa yale olasikeik, ‘Kito ŋebo ŋebonze ramaike, naŋane mat aŋaone diawao Aŋelo Loloŋon Loloŋon Naso na mere dokone eŋerop ŋara nekene.’ ");
INSERT INTO ons_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yale ra qesonkauk, eŋe urum ea aŋaone mane suaine kutno weti met met so zake kine kine mo mauluk maulukine, ea sikanŋutkiso, yewao ŋire ŋaraze maulukkeik.” ");
INSERT INTO ons_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Medewetkine etke ere qelige mat suaino ari lotke more Yesuŋo etange yale maratka more ere Aŋelo Loloŋon Loloŋon Naso wane ŋara kine kine maulukkoik. ");
INSERT INTO ons_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Rarapko, Yesu eŋe dokoine 12 ea weneŋ sarikoi. ");
INSERT INTO ons_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Eŋe zakeo ŋara ne metpi, Yesu eŋe edange, “Na welekatne ŋidanmaile. Ŋei mane ŋinane keuoŋineŋo na ma wakonnane more, ŋabakopne eŋane meteeno bira naniake. Ŋei ea eŋe weneŋ iwa narop mere ŋara nemaine.” ");
INSERT INTO ons_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dokoine eŋe dere umare more weku weku Yesu qesonka rakoi, “Maŋo? Noŋo me?” ");
INSERT INTO ons_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesuŋo mainge rake, “Medep 12 ŋinane keuoŋine eŋe iwa narop weneŋ mere metine biraki pletko ketki ŋara ma nemaike. ");
INSERT INTO ons_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na Ŋei Wawainane Gipole seukkalane mo Anutu wane papiaŋo mo eŋe seukeake ramaike, Welekatne, ŋo ŋei yewa eŋe Ŋei Wawainane Gipole na ma wakonnane ŋaba eŋane meteeno birananiake, eŋe yemo wet borik zok umat manerop marat kayake. Ŋei yewa eŋe nabokŋo siluŋ mi makirap, paki eŋe umatine mi wakon mangirap.” ");
INSERT INTO ons_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eŋe ŋara ne metpi paki, Yesu eŋe bret nat parom ma more Anutu wane bakom kito more mapoke dokoine ebone more rake, “Ŋine mau! Iwa nae bikumne.” ");
INSERT INTO ons_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Paki, eŋe wain lase ma more Anutu wane bakom kito more ebongi eŋe korop newarekoi. ");
INSERT INTO ons_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Eŋe neu Yesuŋo edane rake, “Iwa mo nae weŋemne, eaŋo tako rakot muselane biŋek na korop qesiŋ ŋuniakane qakkale. Anutuŋo weŋemne ea wane ra more ŋinerop tako rakot geake. ");
INSERT INTO ons_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na welekakatne ŋidanbe, na koso wain mane ŋinerop mi nene gemage, naso kutno Anutu wane qeli ewe zonom sariake, naso yewao wain musele kine mane nekale.” ");
INSERT INTO ons_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yale edangi qoekiso, eŋe Anutu wane bakom eŋet mane kito more Oliwa bonagao arikoi. ");
INSERT INTO ons_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu eŋe edange, “Ŋine korop mali malip ŋine qororoŋgi, na qeliŋnane ariwarekei. Eamo Anutu wane papiaŋo iwa yale ramaike, ‘Anutuŋo lama ware ware qeki seukki naso yewao eŋane lama korop ket giŋ qiririŋ yauyaup ariwarekei.’ ");
INSERT INTO ons_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ŋo, na koso wisikae wie more Galili ari alakane ŋibonikale.” ");
INSERT INTO ons_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petoroŋo olatke, “Natne eŋe korop ge qeliŋ ganwareke, ŋo na yemo ge mi qeliŋ ganikale!” ");
INSERT INTO ons_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesuŋo Petoro olatke, “Na welekatne golatmaile. Ukude ruo iwao tiak eŋe atak etke bokaki mi qoeki goŋo atak karewe bisop nanikene.” ");
INSERT INTO ons_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petoro eŋe koso togogole mainge rake, “Geŋone gekuwi seukkenom, na nekukeiwane okanbi, na ge mi bisopganikale.” Dokoine natne korop eŋe yalewaka rakoi. ");
INSERT INTO ons_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Eŋe Getsemane sauromoo ari lotke more, Yesuŋo dokoine edange, “Ŋine iwa metpi, na ari meŋenkaikale.” ");
INSERT INTO ons_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Eŋe Petoro so Yakop so Yohane eŋerop edangi arikoi. Ari numao Yesuŋo wet borik so umat kakapa suaine dere more ");
INSERT INTO ons_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","dokoine edange, “Wetne zok boriki, seukkalane okanmaile. Ŋine iwa diam metpi!” ");
INSERT INTO ons_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Eŋe eri eri kere more kepeo ket quruŋ rasu pa more, meŋenkake. Eŋe wikile suaine ea maine yuankayake, ea wane dere more meŋenkake. ");
INSERT INTO ons_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Eŋe meŋenka rake, “Oo magak! Ge wikile lase iwa korop maine omak nanikene? Kine kine korop, ge maine mi ŋaŋaekene. Ge siluŋ naŋane simile mi mogasikene. Midaka. Ge geŋone simileŋone mogare mawarekene.” ");
INSERT INTO ons_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yale meŋenkaki qoeki, eŋe koso zinge ari dokoine karewe ongi kulu pau Petoro olale rake, “Saimon! Ge kulu pamaine me? Ge naso nigatne wet wisika maine mi gekene me?” ");
INSERT INTO ons_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Eŋe edane rake, “Ŋine sot mi marat kakeiwane kauluk nagu more meŋenkaikei. Oŋaoŋaŋo meŋen meŋen wane togole ewekmaike. Ŋo, solaŋo pelekmaike.” ");
INSERT INTO ons_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Eŋe yale ra edane more zinge koso ari mikep ra more meŋenkake yalewaka meŋenkake. ");
INSERT INTO ons_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Paki koso zinge sari ongi dokoine eŋe kulu ka pakoi ea wane wie more deene umareki, gamuongi, Yesu wane don daleo olasikei ra dere umareu paki, mi mainge olatkoi. ");
INSERT INTO ons_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesu eŋe koso atak karewe zinge sari more edange, “Ŋine yeka kulu pa zonom mamami me? Moya maine! Naŋane naso mo lotkemaike. Kau! Eŋe Ŋei Wawainane Gipole iwa mo ŋei sotenerop eŋane meteeno biranangei. ");
INSERT INTO ons_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ŋine wieu! Ariŋem! Kau, ŋei ma wakon naniake, mo iwa sari lotkemaike!” ");
INSERT INTO ons_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu eŋe yeka ra okoraki, dokoine 12 eŋane keuo ŋine Yudas eŋe magu suaine eŋerop lotkeke. Mosop ŋei ŋetne so Anutu papa togon welaine ŋei so Yuda ware ware suaineŋo ŋei yauwine biraongi koak, soba ma more sarikoi. ");
INSERT INTO ons_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ŋei Yesu ma wakonkayake, eŋe magu yewa don masi mane edane rake, “Na ari ŋei yewa ka more lulukiwe ka more raikei, Yesu mo yewa raso malipka more ma arikei.” ");
INSERT INTO ons_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudas eŋe sari more ikopka Yesu wano ari more rake, “Kito ŋebo ŋebon.” Ra more lulukike. ");
INSERT INTO ons_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Lulukiki so ŋaba eŋe ka more metino malipkakoi. ");
INSERT INTO ons_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Eŋane keueno ŋine ŋei maneŋo Mosop Ŋei Ŋetne Suaine eŋane qelit ŋei mane osoeno okoraki, ea sobaŋo qe more ketine rasu qakki ketke. ");
INSERT INTO ons_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesuŋo edane rake, “Na kobu ŋei midakaka! Onoka wane ŋine koak, so sobarop luknanikei wane sarimami? ");
INSERT INTO ons_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na kaiwe baŋem Anutu Wane Bakom Urum kotino kito ŋibone okanmaŋkole. Naso yewao ŋine mi malipnane luknangoi. Ŋo, kine kine iwa wakongi Anutu wane papiao don ea wane wele wakongep!” ");
INSERT INTO ons_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pakiso, Yesu dokoine eŋe qeliŋka more, ket giŋ qiririŋ ariwarekoi. ");
INSERT INTO ons_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ŋei qaluwit mane eŋe laplapineka Yesu mogare arike. Eŋe ma more lukkaikei wane okanbiso, ");
INSERT INTO ons_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","laplap libeka ea qelige solaineka biririke arike. ");
INSERT INTO ons_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Eŋe Yesu Mosop Ŋei Ŋetne Suaine eŋane matko iwenka ariu ŋei ŋetne suaine korop sari lewaŋgoi. Mosop ŋei ŋetne, Yuda ware ware so Anutu papa togon welaine ŋei. ");
INSERT INTO ons_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petoro eŋe Yesu ŋadino mogare, amaŋ ari Mosop Ŋei Ŋetne Suaine eŋane mat wane sen koto waket more, tebe ŋei eŋerop gerep qenagare metkoi. ");
INSERT INTO ons_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mosop ŋei ŋetne natne so ŋei ŋetne korop eŋe gube qesat ŋei natne maratka more Yesu dongo biraka more qeu seukeakane auye detokangoi. Ŋo, don mane wele koboine mi maratkakoi. ");
INSERT INTO ons_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Qesat ŋei loutne Yesu wano zok don isi qesat okankakoi. Ŋo, doneene eŋe rau numaineŋo wele so weku mi okange. ");
INSERT INTO ons_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Paki, ŋei natneŋo okora, don isi Yesu wane iwa yale solaino qe rakoi, ");
INSERT INTO ons_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ŋene detkaŋem, iwa yale rake, ‘Eŋe Anutu Wane Bakom Urum iwa meteŋo makoi, yewa rasupoke qakewe ariki, na kaiwe mama karewe yewaoka mane musele maikale. Ŋo, meteŋo mi maikale.’” ");
INSERT INTO ons_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ŋei eŋe don yewa rakoi, eamo numainoka mi rakoi, eŋe rau qebetneŋo mi kopkeke. ");
INSERT INTO ons_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mosop Ŋei Ŋetne Suaine eŋe keuo wie okora more Yesu qesonka rakoi, “Ge eŋane don turuŋine mi mainge edanikene me?” ");
INSERT INTO ons_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu eŋe donine midaki okora eŋane don turuŋine mi maingeke. Mosop Ŋei Ŋetne Suaine eŋe koso qesonka rake, “Ŋei ŋerep eŋe Anutu ewine kitomami. Ge welekatne Kristo, Anutu yewa wane Medep me mida?” ");
INSERT INTO ons_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesuŋo mainge rake, “Oo, na yewa! Ŋine korop Ŋei Wawainane Gipole, Anutu Zonomine Kakapa Suaine, eŋane metine nat wonino mere more qeliwo kezoŋ kutno sariwe kaikei!” ");
INSERT INTO ons_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mosop Ŋei Ŋetne Suaine eŋe qise qomine wieki takot kitopoke ma barake rake, “Ŋene koso qesat ŋei natne edoraŋem sari eŋane kine mi raikei, yeine! ");
INSERT INTO ons_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ŋine detkau, eŋe Anutu ma baikkamaike, ea wane ŋine dalino detmami, ŋene ŋei iwa daleo okankaikene?” Paki, eŋe koropŋo Yesu wane iwa yale ra togolekoi, “Eŋe sotinerop, eŋe maine seukeake.” ");
INSERT INTO ons_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ŋei natne eŋe Yesu kieke sopotka more deine laplapŋo piseka qe more rakoi, “Ge ra qelaŋanikene! Maŋo gekumaike?” Yale olale more tebe ŋei edo mete tabeŋo qekoi. ");
INSERT INTO ons_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petoro eŋe qei mat wane sen koto metki, Mosop Ŋei Ŋetne Suaine eŋane qelit ŋerep eŋe sari more ");
INSERT INTO ons_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Petoro kaki gerep qenagare metki deinoka olale rake, “Ge weneŋ sogino Yesu Nazaret ŋine eŋerop gekone!” ");
INSERT INTO ons_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ŋo, Petoro eŋe bisopka rake, “Na mi detmaile! Na geŋane don mi dere qelaŋanmaile.” Yale mainge ra more eŋe mat wane sen ea wane madetino ari wakesiakane okangi tiak mane bokake. ");
INSERT INTO ons_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Qelit ŋerep yewa eŋe ka more ŋei osino okorakoi edane rake, “Ŋei iwa eŋe Yesu wane tego eŋerop geke!” ");
INSERT INTO ons_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ŋo, Petoroŋo koso bisopkake. Naso nigatne azongi, ŋei osino okorakoi, eŋe koso Petoro wane rakoi, “Welekakatne, ge Yesu wane tego gekone. Ge weneŋ Galili ŋei ge yewa ŋine.” ");
INSERT INTO ons_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Rauso, Petoro eŋe togogole bisopka rake, “Welekatne weti qeliwo na ŋidanmaile. Na ŋei ea mi detkamaile. Na don welekatne mi ŋidanikaleo, Anutu eŋe na wikile niniake! Ŋei yewa mi detkamaile.” ");
INSERT INTO ons_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Eŋe yalewa rakiso, yewaka tiak eŋe atak etke bokake, pakimo, Petoro eŋe Yesuŋo don rake, yewa detsorokke. Yesuŋo iwa yale rake, “Tiak atak etke bokaki mi qoeki goŋo na atak karewe bisop nanikene.” Don yewa detsoroke more, Petoro eŋe zok manerop aro suaine aroke. ");
INSERT INTO ons_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kepe qae qaewo mosop ŋei ŋetne so Anutu papa togon welaine ŋei, Skribe, so Yuda ware ware ŋei so kaunsol korop eŋe ikopka lewage more don ma togolekoi. Eŋe Yesu metine mulap togoleŋo lukka more iwenka ari Pilat wane meteo birakakoi. ");
INSERT INTO ons_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat eŋe Yesu qesonkake, “Ge Yuda wane kepe wareware suaine me mida?” Yesu eŋe mainge rake, “Oo, mo yewa goŋom ramaine yale.” ");
INSERT INTO ons_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mosop ŋei ŋetne eŋe don qesat manerop qesatkakoi. ");
INSERT INTO ons_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ea wane Pilat eŋe koso qesonkake, “Ge don mane mi mainge raikene me? Ge detnom! Eŋe don qesat loutne rau geŋano sarimaike!” ");
INSERT INTO ons_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu eŋe eŋane don dere more koso mi mainge rake, Pilat eŋe oŋaine qaeke. ");
INSERT INTO ons_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aŋelo Loloŋon Loloŋon wane Naso, Pilat eŋe mulap ŋei mane qeliŋkamaŋke. Eŋe ŋei ŋerep edom Pilat eŋe mulap ŋei mane eŋetine oramaŋkoi, rokop qesonka eŋe simileene mogare so qeliŋkamaŋke. ");
INSERT INTO ons_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Naso yewao, ŋei mane mulap urumgo metke, eŋetine Barabas. Eŋe ŋei kawali qe more kepe ware ware yuanka more, ŋei natne enguwi seukkoi, eŋerop mulap urumgo waketkoi. Ŋei magu yewa eŋano ŋine mane eŋetine Barabas. ");
INSERT INTO ons_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Naso yewao ŋei ŋerep magu eŋe sari Pilat qesonka more, naso baŋem okanmaŋke, yale mulap ŋei mane qeliŋkayakane olatkoi. ");
INSERT INTO ons_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat eŋe qesonone rake, “Maine na Yuda wane kepe ware ware suaine iwa qeliŋkawe ŋinano sariake me mida?” ");
INSERT INTO ons_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Eŋe detke, mosop ŋei ŋetne eŋe Yesu wane umat mane suaine mida, eŋe yaup dere worik okane more eŋane kaitko kine midaine ma wakone dongo birakakoi. ");
INSERT INTO ons_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mosop ŋei ŋetne, pris, eŋe ŋei ŋerep magu wetko ketket okane taleone more, Pilat wano rau, Barabas qeliŋkaki, eŋano sariakane rakoi. ");
INSERT INTO ons_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat eŋe ŋei ŋerep magu koso qesonone rake, “Ŋine ŋei iwa Yuda kepe ware ware oramami, ea wane na dalino okanikale?” ");
INSERT INTO ons_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Eŋe mainge boka rakoi, “Eŋe kibego qeu!” ");
INSERT INTO ons_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatŋo qesononge, “Onoka sotwane? Eŋe umat dalino okange?” Eŋe zok manerop togoleka rakoi, “Eŋe kibeŋ qabego qeu!” ");
INSERT INTO ons_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatŋo ŋei ŋerep wetene ma peseakane Barabas qeliŋkaki eŋano ariki Yesu kawali ŋei magu eŋane meteo bira kaki edo qe rasu qolok qe qolok mau paki, kumunam seleineŋo dime more, masi kine kine korop okanka more ŋado kibego ma ari qekoi. ");
INSERT INTO ons_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kawali ŋei edo Yesu kepe ware ware wane mat wane sen koto iwenka ari more eŋane magu kawali ŋei korop edorau arikoi. ");
INSERT INTO ons_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Eŋe Yesu kepe ware ware takot birakakoi. Eŋe takot weŋemka so marok okolerop ea lewino motkoi. ");
INSERT INTO ons_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Eŋe Yesu wano isi bela qebela okanka ewine kito rakoi, “Oo! Ge Yuda kepe ware ware suaine naso kiroroine ge waikene!” ");
INSERT INTO ons_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eŋe zoroŋŋo lewine qe more, sotkau pakiso wawetene qe more bakom isisine kitokoi. ");
INSERT INTO ons_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eŋe eŋane isi bela qebela don olatpi qoeki, takot weŋemka yewa kitoqokka more eŋine takot eaŋo biraka more kibego qekei wane iwenka arikoi. ");
INSERT INTO ons_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Eŋe dumao ari ŋei mane eŋetne Saimon, eŋe mat suaino wayakane sariki, eŋe maratka more sorinkau Yesu wane kibeŋ qesiŋka tewekki arikoi. Saimon eŋe Sairini matko ŋine sarike, eŋane gipoletkine Alekzander so Rupus. Saimon eŋe, kawali ŋei edo ma more, qebinkau Yesu wane kibeŋ tewekke. ");
INSERT INTO ons_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Eŋe Yesu ma more kepe mane eŋetne Golgota yewa ma arikoi. Kepe eŋetne ea wane kine iwa yale, ‘Lewet Setnenane Kepe.’ ");
INSERT INTO ons_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Eŋe yewao Yesu qelaŋ qeakane ra more wain so qelaŋ qeqe wane kinin yewarop maingekoi. Ea manbi, Yesu eŋe mi neke. ");
INSERT INTO ons_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pakimo, eŋe kibego qe more takotine, laplapine so maloine yewa wezu qe more yuane damo qe amanagukoi. ");
INSERT INTO ons_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sakoka, 9 kilok, eŋe Yesu kibego qekoi. ");
INSERT INTO ons_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Eŋe kibeŋ kutno kibi isi qesat don qe motkoi, “Yuda Wane Ware Ware Suaine.” ");
INSERT INTO ons_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Eŋe kobu ŋei etke Yesu wane wazaino nat nat weneŋ kibego etkukoi. ");
INSERT INTO ons_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Anutu wane papiao don mane iwa yale pamaike, ea wele wakonge, ‘Eŋe kobu ŋei eŋerop qekei.’ ");
INSERT INTO ons_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ŋei ŋerep ari sari okane ka more, ebeene bonepke isi bela qebela okanka rakoi, “Ge Anutu Wane Bakom Urum kitopoke more, kaiwe karewe koso mane musele maikenane rakone. ");
INSERT INTO ons_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ea wane ge geŋone qesiŋnagu more kibego ŋine qelige qoe ket arinom!” ");
INSERT INTO ons_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mosop ŋei ŋetne so Anutu papa togon welaine ŋei eŋe yalewaka Yesu wano isi bela qebela don okanka more auye rakoi, “Eŋe ŋei ŋerep natne maine qesiŋonge, ŋo, eŋine maine mi qesiŋnagumaike! ");
INSERT INTO ons_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eŋe, Kristo, Israel wane kepe ware ware suaine. Eŋe kibego ŋine maine qoe ketki ŋene ka more malipkaikene.” Kobu ŋei etke ere weneŋ Yesurop etkukoi, ere yalewaka Yesu don qotkoine olatkoik. ");
INSERT INTO ons_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Oŋabango kepe korop panamane paki, ari kepe deine zingeki rarapwano 3 kilok okange. ");
INSERT INTO ons_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Okangi, Yesu eŋe togoleka boka rake, “Eloi, Eloi, lema sabaktani?” Don kine iwa yale, “Anutune, Anutune ge onoka wane qeliŋnanmaine?” ");
INSERT INTO ons_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ŋei ŋerep natne osino okorakoi, eŋe yewa dere more rakoi, “Detkau! Eŋe Elaiya oramaike.” ");
INSERT INTO ons_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ŋei mane eŋe biririke ari more wain dokune tabainerop ea laplapŋo qe muruge more kudupko pise more piino neakane qe dege more rake, “Tomaka kaŋem! Elaiya eŋe sari more makokka birakaki kesiake me mida!” ");
INSERT INTO ons_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu eŋe koso manerop togoleka boka more asuine saki, seukke. ");
INSERT INTO ons_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Seukki laplap suaine Anutu Wane Bakom Urum kotino okorake, ea keuoka buntuk wiri sari ketki qela qoeke. ");
INSERT INTO ons_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kawali ŋei eŋane ware ware eŋe Yesu wane osino okorake, eŋe kaki seukki mo rake, “Welekakatne, iwa eŋe Anutu wane Gipole okanmaike.” ");
INSERT INTO ons_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ŋerep natne eŋe amaŋ okora kakoi. Eŋane keuo Maria Magdalena, so Salome so Maria mane, Yakobo ketkele orakoi, so Yosep erane nagaetne. ");
INSERT INTO ons_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sogino Yesu eŋe Galili metke, naso yewao ŋerep yewa ere Yesu qesiŋkakoik. So ŋerep natne eŋe Yesu weneŋ Yerusalem matko wakoi. ");
INSERT INTO ons_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Rarapwano Yosep, Arimatea ŋine, eŋe sari more mi kaet okange, eŋe Pilat wano ari more Yesu wane pareŋine mayakane qesonkake. Yosep eŋe Yuda wane ware ware mane ewinerop. Eŋe Anutu wane qeli ewe zonom wakongi kayakane, ware ware gege tomaka geokange. Kaiwe yewao eŋe Qezareko met met wane bano nagapko kaiwe yewao ŋei ŋerep eŋe Qezareko met met ea wane kine kine maulukkoi. Eŋe qezareko urata mi makoi ea wane Yosep eŋe Pilat wano ari qesonkake. ");
INSERT INTO ons_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat eŋe ikke wie waki kito qokkaki, kawali ŋei ŋetne oraki sariki qesonka rake, “Welekatne Yesu mo seukike me mida?” ");
INSERT INTO ons_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Eŋe kawali ŋei ŋetne eŋano ŋine dere more Yosep olale rake, “Ge maine pareŋine maikene.” ");
INSERT INTO ons_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosep eŋe laplap mane libeka qoleke, yewao Yesu wane pareŋine makoke ket more kawetka more deŋesereo kezem koto motke. Lom yewa mo wesi weku suaine ea wano mau okorake. Paki, wesi suaine mane rodiŋkaki, ari aŋaone yewa kito won geke. ");
INSERT INTO ons_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalena so Maria, Yosep wane nagaine ere ka more wareka metpik, Yosep eŋe Yesu deŋesereo dukkake. ");
INSERT INTO ons_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sodao Yuda ŋei qezarek naso qoeki, Maria Magdalena so Salome so Maria, Yakop nagaine, eŋe kelok kine kine qounerop qolekoi, ea ma more Yesu wane pareŋine tau kaikeiwane arikoi. ");
INSERT INTO ons_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kepe qae qaewo Sodao ruoropka eŋe deŋesereo arikoi. ");
INSERT INTO ons_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Eŋe dumao ari more enŋene auye rakoi, “Maŋo qesiŋŋone more wesi suaine yewa deŋesere aŋaine kito wonge metmaike ea ma biraki saket ariki ŋene wakesikene?” Wesi yewa kakapa suaine, eŋe yale ra more ari pore kau, wesi suaine yewa mo rodigeu saket arike. ");
INSERT INTO ons_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Eŋe deŋesereo ari waket more kau ŋei qaluwit mane wongoken laplapine libekaka bira more metke. Eŋe ŋei yewa kaikei wane zok kaetonge. ");
INSERT INTO ons_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pakimo, ŋei yewaŋo edange, “Ŋine mi kaet ŋungep! Na detmaile. Ŋine Yesu Nazaret ŋine, eŋe mo kibego qimi, eŋe marat kaikei wane sarimami. Eŋe iwa mi pamaike. Mo wisikae wiike! Kau! Iwa motkoi, eŋane papaine iwa. ");
INSERT INTO ons_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ŋine ari Petoro so dokoine natne edanbi, ‘Yesu mo alakan ŋiboniakane Galili arimaike. Ŋine ari more eŋe kaikei. Yesu eŋe mo rake.’” ");
INSERT INTO ons_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ŋerep eŋe dere saket more, deŋesere qeliŋka more, qomene tiŋ taŋ qe zonomene okoraki, kaet okane more, ŋei mane mi olatkoi. ");
INSERT INTO ons_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu eŋe Sodao sakoka wie more alakane Maria Magdalena wakonkake. Sogino Yesuŋo eŋano ŋine asu qotkoine 7 esoponge. ");
INSERT INTO ons_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria eŋe ari Yesu dokoine yewa edange, eŋe mo wisikae wieke. Eŋe wet borik ma more aroke metkoi. ");
INSERT INTO ons_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Eŋe edane rake, “Yesu eŋe mo wisikae wieke, na mo maratkele.” Ŋo, eŋe Maria wane don dere more mi malipkakoi. ");
INSERT INTO ons_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Boaŋ Yesu eŋe ŋei kuneŋine so kait kine mane okane more ari Yesu eŋine medep etke erano wakonotke. Ere mat suaine qelige more arikoik. ");
INSERT INTO ons_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Naso yewao ere zinge ari more dokoine natne ea edane rakoik, “Ŋere Yesu maratkamaite.” Ŋo, eŋe erane don yewa dere more mi malipkakoi. ");
INSERT INTO ons_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Qoiqoiwo Yesu eŋe dokoine 11, eŋe ŋara ne metpi ari wakononge. Eŋe ari wakonone more don gereune okanone edane rake, “Maria so medep etke na maratnanbi, na mo wisikae wiile. Yale ra ŋidanbi ŋine onoka wane eŋane don mi dere malipkemi? Ŋine dereret ŋine mo mau siukke.” ");
INSERT INTO ons_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Eŋe koso edane rake, “Ŋine korop kepe baŋem ari more biŋek don ŋei ŋerep maguine maguine eŋano ra qelaŋanikei. ");
INSERT INTO ons_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ŋei mane eŋe dere malipka more biŋek don wane doku tauyakeo, ea Anutuŋo maki geake. Ŋo, ŋei mane eŋe mi malipkayakeo, eŋe Anutuŋo eŋane sot dere matalikayake. ");
INSERT INTO ons_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ŋei ŋerep malipka gekei, Anutu eŋe eŋane meteeno masi togogole eboniake. Eŋe asu qotkoine eŋane eŋetko osopka more eŋe don kine mane raikei. ");
INSERT INTO ons_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Eŋe koma suabit so qaru ea meteeneŋo malipkaikei me doku suŋainerop nekeiwo, eŋe mi seukkei. Eŋe maine gekei. Eŋe meteene zoma ŋei ŋerep eŋano more ebuwi menaŋoniake.” ");
INSERT INTO ons_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Boaŋ Yesu eŋe don edangi qoeke, Anutuŋo eŋe qeliwo ma wa more birakake, birakaki, Anutu eŋine wonino metke. ");
INSERT INTO ons_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pakimo, dokoine eŋe korop kepe baŋem ari more eŋane biŋek donine ra qelaŋane arikoi. Waom eŋe weneŋ mapitone more masi togogoleŋo ŋei ŋerep sikanone more, donene ea ma togoleke. Ŋerep eŋe kine kine korop ka detokangoi, ea Petoro eŋine so kimakoune edangoi. Pakiso, Yesu eŋe dokoine biŋek don ebone more biraongi, kepe baŋem ra qelaŋane arikoi, Anutu eŋe biŋek don qoiqoine midaine iwa motke. Ŋei mane dere malipkayakeo, eŋe gege togon marat kayake. ");
INSERT INTO ons_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O, Teopilus suainene. Mokaka ŋei loutne eŋe Anutuŋo kine kine wele maki keuno wakonge, ea wane don kisi tegoke more qekoi. ");
INSERT INTO ons_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Don kisi yewa mo ŋei weneŋ osop ge more, deene qomineŋo alakan wakongi, kinerop ka detka okangoi, eŋe ŋedangoi. Ŋei eao kine kine one more, Anutu wane biŋek don ra qelaŋangoi. ");
INSERT INTO ons_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pakimo noŋo yalewaka mo kino ŋineka kine kine wakone sarike, ea wane bororom ra qeson okane, kine dere detluk kawarewe, pakimo koso ge iwa sorok sorok qetitike qe ginmaile. ");
INSERT INTO ons_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Pakimo, ge iwa dapore more, iwa yale detnom qoeake. Eŋe kito gingoi, yewa mo kine kine wele! ");
INSERT INTO ons_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Naso Herot eŋe Yuda kepeo ŋei waom geke, yewao mosop ŋei mane geke, eŋetine Zekaraia, eŋe mosop ŋei Abiya wane tegoo ŋine. Ŋanominane eŋetne Elizabet, eŋe yalewaka mosop ŋei tego eŋano ŋine. ");
INSERT INTO ons_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ere Anutu wane kaitko gegeetne koboboine geuk paki, Waom wane ra rokop donine koropka tewekkoik. ");
INSERT INTO ons_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elizabet eŋe qaton gekane ere medewekopetne midaine ge mage, ŋei ŋerep sele okangoik. ");
INSERT INTO ons_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Naso maneo, Zekaraia wane nasoo, eŋe Anutu wane Bakom Urumgo urataine mayakane sarike. ");
INSERT INTO ons_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sarikiso, mosop ŋei korop urataine welaine welaine maikei wane okane weneŋ sarikoi, pakiso, Zekaraia eŋe kopu qounerop kiwakeakane rakauso Anutu Wane Bakom Urum kotino waketke. ");
INSERT INTO ons_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Waket more, kopu qounerop kiwakki, so ŋei ŋerep magu eŋe ŋadino Anutu meŋenka gekoi. ");
INSERT INTO ons_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pakiso, Waom wane aŋelo maneŋo wakone more, kopu qounerop kiwa kiwak, ea wane zake nat paromino wongoken yewa okorake. ");
INSERT INTO ons_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Okorakiso, Zekaraiaŋo kaki paki qise more, ikki kito qokkake. ");
INSERT INTO ons_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yale okangimo, aŋeloŋo iwa yale olatke, “Zekaraia, ge mi kaetgangep! Anutuŋo meŋe meŋenŋone mo detke, ea wane mo ŋanomŋone Elizabetŋo medep ŋatke more mayake, eŋane eŋetine Yohane orakene. ");
INSERT INTO ons_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ge eŋane wet pesek dere more bakom kitokene, so ŋei ŋerep korop eŋe yalewaka wakongi dere more simile oniake! ");
INSERT INTO ons_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Eŋe Waom wane kaitko ŋei suaine okane geake, eŋe wain so doku togole mi neake. Eŋe medep abubuka paki Asu Koboboineŋo eŋane kotino ket more geake. ");
INSERT INTO ons_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pakimo, eŋe Israel ŋei ŋerep korop mainongi, koso zinge more Waomene Anutu, kaitno kitokei. ");
INSERT INTO ons_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anutu wane don saeŋine rara ŋei, Elaiya wano Asu so zonom pake, rokop yalewaka pa mangi, eŋe Waom alakane geake, pakimo, ŋei ŋerep suaine so medep nigatne eŋane wetene maton tolaki weku okaniake, so wet togon ŋei eŋe mainongi, koboboine eŋane numao waketkei. Yale okangimo, eŋe Waom wane ŋei ŋerep korop maki eweke more gekei.” ");
INSERT INTO ons_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Rakimo, Zekaraiaŋo aŋelo olale rake, “Na daleo don iwa ramaine, ea detpe wele okaniake? Na mo ŋei sele okanmaile, so ŋanomne eŋe yalewaka sele okanmaike.” ");
INSERT INTO ons_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Rakimo, aŋeloŋo iwa yale olatke, “Na Gabriel, na Anutu wane kaitko ge okanmaile, oŋo talenangi sari, qom menaŋ don iwa golatmaile. ");
INSERT INTO ons_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pakimo, ge naŋane don detnom wele mi okangi, detlukmaine, ea wane turuŋine ge qelaŋ okane more, don raraŋone midaine genom, don golatmaile, iwa wele wakoniake.” ");
INSERT INTO ons_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zekaraia eŋe Anutu wane Bakom Urumgo yale okane geki, ŋei ŋerep eŋe naso kiroine tomaka more kinane ŋaŋaekoi. ");
INSERT INTO ons_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zakaria eŋe Anutu wane Bakom Urumgo ŋine saket more don edaniakane ŋaŋaeke, ea wane eŋe mo wetke rakoi, eŋe tanik mane Anutu wane Bakom Urumgo wakongi kake. Pakiso, eŋe don edaniakane ŋaŋaeso metineŋoka kait masi ma okanonge. ");
INSERT INTO ons_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yale okane geki urumgo urata mama nasoine qoekiso, Zakariaŋo matino zinge arike. ");
INSERT INTO ons_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pakiso ŋado ŋanomine Elizabet eŋe medep ŋatkeke. Ŋatke more, siu siuko geki, meso mete mane qoekiso rake, ");
INSERT INTO ons_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Waomŋo naso motke, yewa bomileki qesiŋnane more, gamune yewa ŋei ŋerep eŋane kaiteno ŋine ma biraki ariake!” ");
INSERT INTO ons_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Meso 6 qoekiso, Anutuŋo aŋelo Gabriel talekaki, Galili kepeo Nazaret matko arike. ");
INSERT INTO ons_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Eŋe ari more ŋerep natewen mane eŋetne Maria, ŋei mane eŋetne Yosep, eŋane biŋek qeu geke, eŋano lotkeke, Yosep eŋe ŋei waom Dawit wane tutule. ");
INSERT INTO ons_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pakimo, aŋeloŋo Maria wano wakone more rake, “Peamŋo gerop payake! Waomŋo gerop gemaike so suaineka mosop ganmaike!” ");
INSERT INTO ons_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aŋeloŋo don yale rakimo, Mariaŋo detki qekaki wetneŋo iwa yale wetkeke, “Don iwa onoka wane nolatmaike?” ");
INSERT INTO ons_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pakimo, aŋeloŋo olale rake, “Maria ge misuk kaet gangep, Anutuŋo gangi menaŋmaike. ");
INSERT INTO ons_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Detmaine, ge medep ŋatke more manom paki, eŋetne Yesu orakene. ");
INSERT INTO ons_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Eŋe baŋ ŋei kakapa suaine okaniake, pakimo, eŋe baŋ eŋetine qeliwo Anutu Wawaine eŋane Medep orakei. Pakimo, baŋ Waom Anutuŋo ŋaboine Dawit yale, ŋei waom birakaki geake. ");
INSERT INTO ons_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ge more, Yakop wane ŋosa wili wiliine eŋane ŋei waom okane, qoi qoine midaine wareone tako rakot ge ari more geake!” ");
INSERT INTO ons_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Rakimo, Mariaŋo aŋelo iwa yale olatke, “Na natewen, ŋeirop mane mi gemaile, yalinanemo ge don ramaine, yewa daleo wele mosiake?” ");
INSERT INTO ons_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aŋeloŋo done turuŋine mainge rake, “Asu Koboboineŋo geŋane kutko kesiake, so Anutu wane zonomŋo geŋano ket more qesiŋ ganiake, kine yalewa wane medep koboboine maikene, eŋane eŋetne baŋ Anutu wane Medep orakei. ");
INSERT INTO ons_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Detmaine, kimaŋone Elizabet eŋe ŋerep seleŋo medep ŋatke geki, meso 6 okanmaike. Eŋe ŋerep qaton, yale ora ra okanmami, ŋo eŋe siluŋ medep ŋatkemaike. ");
INSERT INTO ons_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anutuŋo kine kine mane okaniakane mi qekayake.” ");
INSERT INTO ons_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Rakiso, Mariaŋo rake, “Na waom wane qelit ŋerep, ea wane ge don ramaine, yale okannaniake.” Yale rakiso, aŋeloŋo arike. ");
INSERT INTO ons_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maria eŋe geki, mi azongi ikopka eweke more, Yuda kepe bonagaino mat mane metke, yewa arike. ");
INSERT INTO ons_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ari lotke more, Zekaraia wane matko wa more, so Elizabet kaki pakiso, oi bakom okankake. ");
INSERT INTO ons_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabetŋo Maria wane oi bakom yewa dere metkiso, medepŋo yewaka moea ŋatino uŋap make, pakiso Asu Koboboineŋo Elizabet wane kotino watkeke. ");
INSERT INTO ons_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Pakiso, Elizabetŋo mawaka so don iwa yale rake, “Ŋerep kimaze, geŋane mosop korop yewaŋo ŋerep natne eŋe yuan onwaremaike, so medep ŋatŋono metmaike, eŋe yalewaka mosop korop. ");
INSERT INTO ons_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Onoka maepnane, Waomnane nagaineŋo nanikenane sarimaine? ");
INSERT INTO ons_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Oi bakom okan nannom, ketno ketki ŋatno medepŋo uŋap mamaike, so bakom kitomaike. ");
INSERT INTO ons_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ge wet pesek suaine okanmaine, ge Waom wane biŋek don golatke, yewa detnom wele okange, ea wane wele geŋano wakoniake.” ");
INSERT INTO ons_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariaŋo rake, “Qomneŋo Waom mawa kamaike, ");
INSERT INTO ons_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","49","Anutuŋo mauluk nanmaike, eŋe qelit ŋerep meine ket qeqine naŋane wetkemaike, ea wane oŋa oŋaneŋo wet pesek okanmaike. Togole welaine Anutuŋo masi kakapa naŋano mamaike, ea wane ukude so baŋ ŋado ŋei ŋerep kepe korop maguine maguine noramaŋkei, ‘Anutuŋo mosop gange.’ Anutu ea eŋane eŋetine koboboine. ");
INSERT INTO ons_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ŋei ŋerep eŋe Anutu ewino kito okanmami, eŋe eŋano so eŋane doko ŋosa wili wiliene wet maep ebon mageake. ");
INSERT INTO ons_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Eŋe kabirimine togogoleka bira more, ŋei wawaine ge okanmami, esopongi yau yaup ari okanmami. ");
INSERT INTO ons_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Eŋe ŋei waom togogole met meteno ŋine maket biraone more, ŋei ketlele gemami, eŋe ebu wa meŋo biraon okanmaike. ");
INSERT INTO ons_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bodi so aboŋene midaine ge okanmami, eŋe kine kine mayakatne qe watke ebon okanmaike. Ŋo riwe morian so aboŋenerop ge okanmami, eŋe yemo esopongi, eŋe meteenoka qeliŋka ari okanmami. ");
INSERT INTO ons_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Eŋe ra rokop donine ŋabokopze eŋano ra togoleke, yewa ware kamaike, eŋe qelit ŋeiine Israel qesiŋ kamaike. ");
INSERT INTO ons_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Eŋe ŋaboze Abraham so eŋane doko ŋosa wili wilikoune, eŋano wet maep ebone ariake.” ");
INSERT INTO ons_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria eŋe meso karewe Elizabet korop geki, pakiso koso zinge matino arike. ");
INSERT INTO ons_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabet eŋe nasoine bomilekiso, medep ŋei make. ");
INSERT INTO ons_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pakiso, Elizabet matkoune so weŋem sotawekoune eŋe kisiine ea dere so Waomŋo wet maepinane kine eŋano ma wakonge, ea wane dere so eŋerop weneŋ bakom kitokoi. ");
INSERT INTO ons_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kaiwe urata mama 8 qoekiso, eŋe lewageu, medepinane yaine solaine kitatkoi, pakiso, medep wane eŋetne magaine Zekaraia wasekakei wane rakoi. ");
INSERT INTO ons_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Rauso, nagaineŋo kitatone more rake, “Mida! Eŋetine Yohane orakene.” ");
INSERT INTO ons_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yale rakiso, eŋe olale rakoi, “Mame asokopŋone eŋane wase wase eŋet mane yale mi pamaike!” ");
INSERT INTO ons_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ra kito qok yale okanmage, so magaine meteŋoka kait masi okanka more, medep eŋetne orayakane qesonkakoi. ");
INSERT INTO ons_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Pakiso, Zekaraia eŋe tape wane raki manbiso, iwa yale qeke, “Eŋetine Yohane.” Pakiso, eŋe korop qise nagukoi! ");
INSERT INTO ons_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mi azongiso, Zekaraia maine mo menaŋge, paki don raraine wakongiso, Anutu eŋetine ma wakake. ");
INSERT INTO ons_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pakiso, mat loli lolik ŋei ŋerep gekoi, eŋe don kisi yewa detpi kaetonge. So Yuda kepe meŋoino mat mere arike, yewao don kisi yewa weneŋ aŋaŋo aŋa auye okan warekoi. ");
INSERT INTO ons_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Don kisi detkoi, ŋei ŋerep yewa eŋe don kisi yewa wetke ge more qesone rakoi, “Medep yaline sua more daleo okaniake?” Eŋe mo detkoi, Waom wane zonomŋo mo kutno wa pake. ");
INSERT INTO ons_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Asu Koboboineŋo Yohane magaine Zekaraia wane kotino ket watkeke, paki eŋe Anutu ma waka more, iwa yale rake, ");
INSERT INTO ons_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ŋene Waom ma wakaŋem, Israel wane Anutu! Eŋe sariki paki, ŋei ŋerewekoune qesiŋ onmaike, eŋe koso siwot onmaike. ");
INSERT INTO ons_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Qelit medeune Dawit wane ŋabokoune ŋenane keuo ŋine, ŋei togogole mane ma wakonkaki, oŋo baŋ maulukoniake. ");
INSERT INTO ons_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Eŋe mokaka qelit ŋeikoune koboboine edangi, don ŋenzo ra gekoi, ");
INSERT INTO ons_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","baŋ ŋabokopze eŋane meteeno ŋine koso mainŋongi zingekene, so qaisikŋon okanmami, eŋane meteeno ŋine makok ŋoniake. ");
INSERT INTO ons_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ŋabokopze eŋerop tako rakot togon koboboine okaniakane detongi, paki masi wet maep mayakatne eŋano okanoniake. ");
INSERT INTO ons_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Eŋe ŋaboze Abraham ra togole mangane, ŋabakopze eŋano ŋine makok ŋoniake. ");
INSERT INTO ons_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","So detŋongi, kaetze midaine qelitine qekene. ");
INSERT INTO ons_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Paki, eŋane kaitko kepeo gekene, rokop naso baŋem sot turuŋze midaine koboboine gekene. ");
INSERT INTO ons_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Medepne, ge eŋe baŋ Anutu Wawainane qelit ŋei gorakei, goŋo baŋ Waom wane ŋetne kisage alakangene, eŋane numaine lapongenane. ");
INSERT INTO ons_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Goŋo baŋ ŋei ŋerewekoune kito ebon okannom. ‘Anutuŋo eŋane sotene nigetkaki qeliŋoniake, yale okane more mauluk ŋuniake.’ ");
INSERT INTO ons_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anutuze eŋe wet maepine suaine pa maikane baŋ raki, wet maepine ea kepe qae qae yale qelaŋan ŋoniake, so wet maepine eaŋo eŋe mauluk ŋongi menaŋgene. ");
INSERT INTO ons_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Anutuŋo qeliwo ŋine qelaŋanine maki sirike, seu seu wane panaman ruwitko gemami, yewa qelaŋanoniake, pakimo, sikanŋongi, peam wane numa wakongi, maine gesoke arikene.” ");
INSERT INTO ons_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pakiso, medep eŋe suakiso, Waom wano dereretineŋo yale waka suake, eŋe kepe yaup papaino gemageki, urata mamainane naso bomilekiso, Israel magu eŋano wakonge. ");
INSERT INTO ons_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Naso yewao kepe ware ware Sisa Augustusŋo raki, Roman kepeo gavaman ŋei ŋerep korop eŋetene qe dapot okanwarekoi. ");
INSERT INTO ons_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Urata yaline alakan mi mamaine. Naso yewao Kirinius eŋe Siria kepeo ware ware suaine gekimo, kuneŋine kiekkoi. ");
INSERT INTO ons_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pakimo, ea wane eŋetene qe dapot okanongei wane, ŋei ŋerep korop wakon wakon mateno ariwarekoi. ");
INSERT INTO ons_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ariwareuso, Yosep eŋe Dawit wane ŋosa wili wiliineŋo Galili kepeo, Nazaret matko ŋine, yale waka wie more, Yuda kepeo ŋei waom Dawit wane wako wakon matine Betlehem, yewa arike. ");
INSERT INTO ons_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Eŋe ŋerep biŋekine Mariarop eŋetetne qekei wane medep ŋat korop iwenkaki arikoik. ");
INSERT INTO ons_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ari Betlehem matko lotkeuk, so Maria medep mayakane nasoine bomileke, ");
INSERT INTO ons_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","pakiso, alakan medepine ma more, laplapŋo kawetka more, bulamakau kudeo birakaki pake, ŋei edo lobo mat mo watkewarekoi, wane ere qeka more, so bulamakau eŋane matko waket metkoik. ");
INSERT INTO ons_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kepe mat yewaoka ŋei natne eŋe goigo lamakopene wareone metkoi, ");
INSERT INTO ons_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","pakiso, Waom wane aŋelo maneŋo eŋano wakongi, Waom wane qilauneŋo qelaŋanonge, pakiso, eŋe ka more zok kaetonge. ");
INSERT INTO ons_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pakiso, aŋeloŋo edane rake, “Mi kaet ŋungep! Na iwa ŋinane wet maep don magemaile, ea wane weleine ŋei ŋerep korop ŋinano wet pesek wakoniake, ");
INSERT INTO ons_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ukude kaiwe iwao Dawit wane matko medep ŋei wakonmaike, eŋe ŋine ma menaŋŋuniake, eŋetine Kristo Waom! ");
INSERT INTO ons_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Pakimo, ŋidanbe detpi! Ŋine medep nigatne abubu laplapŋo kawetka kawetkaine, bulamakau kudeo paki, ari maratkaikei.” ");
INSERT INTO ons_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Yale rakiso, yewaoka qeliwo ŋine aŋelo magu edo ikopka aŋelo kimaenano lewage, eŋet kito more Anutu ma wakakoi, ");
INSERT INTO ons_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Bakom mawa mawa Anutu weti qeliwo so kepeo ŋei kima mauluk okanonmaike, eŋano peam wakonmaike!” ");
INSERT INTO ons_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aŋelo eŋe qeliwo zinge wawareuso, lama ware ware eŋe iwa yale ra more aukoi, “Ŋene Betlehem matko wa more, Waomŋo tanik wakongi ŋedanmaike, yewa kaŋem.” ");
INSERT INTO ons_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yale ra more, ikopka arikoi, ari Maria so Yosep maratore so, kau medep abubu laplapŋo kawetka kawetkaine, bulamakau kudeo pake. ");
INSERT INTO ons_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ka more, medep wane don kisi aŋeloŋo edange, yewa ra wakongoi. ");
INSERT INTO ons_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pakiso, lama ware ware eŋane piwo ŋine don kisiwa detkoi, eŋe korop welelepkekoi. ");
INSERT INTO ons_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariaŋo yemo don yewa wetke more, dere detsorok qesorok okane geke. ");
INSERT INTO ons_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pakiso, lama ware ware eŋe aŋelo edange, rokop kakoi, so detkoi, ea wane zinge more, eŋet kito more Anutu bakomine kitokoi. ");
INSERT INTO ons_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Soda qoeki, kaiwe 8 okangiso, medep yaine solaine kitareso, eŋetine Yesu orakoi, eŋet yewa mo medep eŋe mi wakongi, aŋeloŋo ra wakonge. ");
INSERT INTO ons_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pakiso, Mose wane ra rokop don pake, yewa Mariaŋo teweke more titi ge more, sola ma more Yosep korop medep Yerusalem matko ma wa more, so Waom wane biŋek qekoi. ");
INSERT INTO ons_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Waom wane ra rokop dongo iwa yale qeko, “Medep ŋei mikepka wakonbi, Waom wane biŋek qekei.” ");
INSERT INTO ons_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ere yale waka Waom wane soe soep mitkeik wane, ra rokop dongo naŋi baluse etke me baluse nigatne etke, ma more arikoik. ");
INSERT INTO ons_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Naso yewaoka, ŋei mane, eŋetne Simeon eŋe Yerusalem matko geke, eŋe koboboine Anutu ewino kito ge more, Israel ŋei magu menaŋgei wane toma geke, pakiso, Asu Koboboineŋo weneŋ kotino geke. ");
INSERT INTO ons_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ge more, don iwa yale ra wakone olatke, “Ge ikop mi seukkene, ge ge more, deŋoneŋo Waom wane Mesia wakongi kaikene.” ");
INSERT INTO ons_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pakiso, Asuŋo Simeon talekaki, Anutu Wane Bakom Urumgo wake, wakiso, Mariaŋo Yosep ere ra rokop don teweke more, Yesu medep yewaka ma more Anutu Wane Bakom Urumgo ma wakoik. ");
INSERT INTO ons_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pakiso, Simeonŋo Yesu medep ma more koaŋka okoraso, Anutu bakomine kito more rake, ");
INSERT INTO ons_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O, Waom, ge ukude donŋone rakone yewa warekamaine, ea wane qelit ŋeiŋone maine birakanom peamgo ariake. ");
INSERT INTO ons_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Na dene qomineŋo geŋane medep kaulukmaile, eŋe baŋ ŋado ŋei ŋerep ma menaŋ oniake. ");
INSERT INTO ons_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ge mauluk mauluk medep ea kepe baŋem ŋei ŋerep korop eŋane deeneŋo kaikei wane matuzupke more ma wakonkamaine, ");
INSERT INTO ons_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","medep yewaŋo qelaŋ eŋano geŋane qelaŋanŋo wetene ma qelaŋanmaike, ŋo ŋei ŋerewekopŋone Israel eŋane eŋet biŋekene ma wiemaike.” ");
INSERT INTO ons_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeonŋo medep wane don yale rakimo, naga magaine ere detpik manerop wawaine okangi, oŋaetne qaeke. ");
INSERT INTO ons_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeonŋo mosopone, so medep nagaine Maria olale rake, “Detmaine! Anutuŋo medep iwa birakake, eŋano Israel ŋei poripkekei wane raraine, natne eŋe eŋano kito sorodoge kito yau more ket rasu warekei, ŋo natne eŋe eŋano kito togole more menaŋgei. So ŋei loutne numaene leŋleŋinane ma ket biraka zok manerop okankaikei, ");
INSERT INTO ons_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ea wane ŋei loutne eŋane kineene wakoniake, so geŋone wet borik tabaineŋo qomŋone rasu tabaeake, tanik yaline wakoniake.” ");
INSERT INTO ons_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pakimo, sele ŋerep mane geke, eŋetne Ana, Panuel wane borasine, Aser wane tegoo ŋine, eŋe natewenino ŋei ma more geki, koma 7 okangi mo, ŋaone seukke. ");
INSERT INTO ons_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Seukkimo, eŋe mala okane ge ari mage komaine 84 rutupke, so sele okange, eŋe Anutu wane Bakom Urumgo tako rakot ruo kaiwe, wawa ket ket okane, so Anutu wane ra wage, so meŋen meŋen urata mageke. ");
INSERT INTO ons_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Naso, yewaoka eŋe Anutu wane Bakom Urumgo wa more so Anutu bakomine kitoke, so Yesu medep wane don kisiine ra wakone, ŋei ŋerep korop Anutuŋo Yerusalem koso siwot oniakane toma pakoi, eŋe edange. ");
INSERT INTO ons_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosep ŋo Maria ere Waom wane ra rokop dongo raraine yalewa okanbik qoekiso koso zinge more Nazaret mateno, Galili kepeo arikoik. ");
INSERT INTO ons_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yewa geukso, Anutuŋo Yesu medep kito qesiŋ okankaki, sua togole okangi, dereretine suake. Pakiso, Anutu wane mosopŋo kutino wa pake. ");
INSERT INTO ons_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Maria so Yosep ere peada baŋem aŋelo loloŋon loloŋon peada wane Yerusalem ari okanmaŋkoik. ");
INSERT INTO ons_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Pakiso, Yesu medep mo komaine 12 okangiso, weneŋ iwenkauk so aŋelo loloŋon loloŋon peada wane Yerusalem matko wakoi. ");
INSERT INTO ons_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Wa geu peada qoekiso, Maria ŋo Yosep ere Yesu medep kito qokkauk, Yerusalem matko metkiso, eretneka zinge arikoik. ");
INSERT INTO ons_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ari more ŋei ŋerep magu natne eŋerop alakane arimi ra, kimakopetne eŋane keueno zuaŋka arimageuk, ruo kereke. ");
INSERT INTO ons_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kepe qaekiso zuaŋka mageuk borikiso, koso zinge Yerusalem matko zuaŋka arikoik. ");
INSERT INTO ons_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ari zuaŋka geuk, kaiwe karewe okangiso, ari Anutu wane Bakom Urumgo metki, wa more maratkakoik. Eŋe yewa Yuda kito ebo ebon eŋane keueno mere, don rau dere so kinane ra qeson okanonge. ");
INSERT INTO ons_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pakiso, ŋei yewa weneŋ metkoi, eŋe kau paki qeso qesonene ewekineka mainge okange, yewa wane oŋaene zok qaeki, don dereretinane manerop welelepkekoi. ");
INSERT INTO ons_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eŋane keueno metki, naga magaine ere ka more oŋaetne qaeke, pakiso nagaineŋo olale rake, “Giponne, ge onoka wane yale okanŋotmaine, pakimo magaŋonerop ŋere qom sua zok okane zuaŋgane gemaite?” ");
INSERT INTO ons_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","rakiso etane rake, “Ŋire onoka wane zok zuaŋnane gemamik? Na Maganane matko gekalane raraine yewa ŋire mi detmamik me?” ");
INSERT INTO ons_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yale rakimo, ere don yewa wane kine mi detlukkoik. ");
INSERT INTO ons_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pakiso, eŋe naga magaine ererop weneŋ Nazaret matko zinge arikoi, yewa naga magaine erane aŋaetne teweke geke, ŋo nagaineŋo yemo donine detke, rokop wetino motki paki wetke geke. ");
INSERT INTO ons_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pakiso, Yesu eŋe dereretine so solaine, weneŋ sua togole okangiso, Anutu so ŋei weneŋ eŋe kau menaŋge. ");
INSERT INTO ons_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taiberius Sisa eŋe koma 15 Roman kepe ware ware suaine geke. Pakiso, eŋane ketkele, Pontius Pilat eŋe Yuda kepeo ŋei waom geke, ŋo Herot, eŋe Pilat wane ketkele, eŋe Galili kepeo ŋei waom gekiso, ŋole Pilip, eŋe Iturea so Trakonitis kepeo ŋei waom geke. Ŋo Lisanias eŋe Abilene kepeo ŋei waom geke. ");
INSERT INTO ons_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ŋo mosop ŋei ŋetne etke gekoik, Anas so Kaiapasi, naso yewao Zekaraia wane gipole Yohane eŋe kepe yaup papaino gekiso, Anutu wane donŋo ketno ketke. ");
INSERT INTO ons_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pakiso, Yohane eŋe Yordan doku erinat so inat geware more, ŋei ŋerep iwa yale edane rake, “Ŋine borikineŋine ŋadek kawareu paki, doku taukei, Anutuŋo sot turuŋŋine qeliŋwareake.” ");
INSERT INTO ons_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Anutu wane qelit ŋei, propet Isaiaŋo ea wane done iwa yale dere more qeke, “Kepe yaup papaino ŋei maneŋo boka woka mane iwa yale ramaike, ‘Waom wane numa makoboeu, numaine kitou digin qekep! ");
INSERT INTO ons_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Wagemine korop somewareu, meŋoine so bonagaine korop kito kito pelekeu digin qekep. Duma kuŋ qegoŋine kito koboeu koboekep, so kito wa kito ketine ma sorokeu, qe leleke ket sorodoŋgep. ");
INSERT INTO ons_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Paki daleo Anutuŋo ŋei ŋerep ma menaŋoniake, ea wane kine eŋe kaulukkei.’” ");
INSERT INTO ons_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ŋei ŋerep magu suaineŋo doku tau tau wane Yohane wano lotke warekoi, pakimo Yohaneŋo edange, “Ŋine koma wane doko ŋosakoune, ŋine Anutu wano ŋine borikinane turuŋine zingeakane okanmaike, yewa kakak kaikei wane maŋo ŋidange me? ");
INSERT INTO ons_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ŋine wetŋine mainge ware more, ea wane weleine maratkau, so ŋine ŋidomka misuk kieke more, ŋene Abraham wane ŋabokoune raikei, na ŋidanmaile, Anutu eŋe maine wesi iwaŋo maki Abraham wane ŋabokoune koso musele maine wakongei! ");
INSERT INTO ons_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Naka mo eki kino mot mole, ea wane eki mane eŋe wele maine mi qeki, kitare more gerepko pekekeu zeake.” ");
INSERT INTO ons_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pakiso, ŋei ŋerep eŋe qesonka rakoi, “Ŋene daleo okanikene?” ");
INSERT INTO ons_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Rauso, eŋe mainge edange, “Ŋei mane eŋe takot etke mage more, takot mane kimaine takot midaine ka more, eŋe maniake. Ŋei mane eŋe ŋaraine weneŋŋo rokop, yalewaka okaniake.” ");
INSERT INTO ons_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pakiso, takis mama eŋe yaleka doku taukei wane lotke more, qesonka rakoi, “Kito ŋebo ŋebon ŋene daleo okanikene?” ");
INSERT INTO ons_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Rauso edange, “Ŋine ŋei eŋano ŋine takis maikei wane raraine, rokop yewa yale waka ma okanikei, ŋinŋine wetŋino misuk qeyau kere koso takotke maikei.” ");
INSERT INTO ons_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kawali ŋei natneŋo yale waka qesonka rakoi, “Ŋo ŋenewa? Ŋene daleo okanikene?” Rauso, eŋe edane rake, “Ŋine ŋei engu kito, me isi more wesiene zok yaup misuk omakongei, ŋine wesiŋine ma okanmami, yewa wane rokopka maikei.” ");
INSERT INTO ons_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pakiso ŋei ŋerep eŋe weteno saqe saqe okangi, dere siuke more rakoi, “Eŋe Mesia me mida?” ");
INSERT INTO ons_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohaneŋo korop edane rake, “Noŋo dokuka tauŋunmaile, mane ŋadeno sarimaike, eŋe zonomine zok manerop pa manmaike. Eŋe naŋane rokop mida, namde eŋane qelit qeqe meine. Oŋo ŋine natne boaŋ Asu Koboboine ŋiboniake, ŋo ŋine natne gerepŋo ŋizoyake. ");
INSERT INTO ons_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Eŋe sawoliinerop sari more, ŋaraine eune ma more wele peikki urumgo wayake, ŋo ŋei sinoine yewamo peikki gerep togongo wa more ezowareake.” ");
INSERT INTO ons_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohaneŋo numa tanik kine kineo more, biŋek don ŋei ŋerep edange, so gege mageene qotkoine qeliŋkaikei wane qebinonge, so miti edange. ");
INSERT INTO ons_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pakimo ŋei waomene Herot, eŋe ŋolane ŋanomine Herodias kobu make, so borikine natne weneŋ make, ea wane Yohaneŋo girem don olatke. ");
INSERT INTO ons_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herot eŋe sot yewa okange, so koso takotke more sot mane kakapa suaine manerop okange, eamo Yohane mulap urumgo birakake. ");
INSERT INTO ons_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ŋei ŋerep loutne eŋe Yohane wano lotke more doku taukoi, pakiso Yesu eŋe yalewaka ari more tauke. Tau more meŋenka metkiso, qeli aŋaŋge. ");
INSERT INTO ons_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pakiso, Asu Koboboineŋo sola bikum gorop okane, baluse yale lele more, so Yesu wane kutno ketke. Pakiso, qeliwo ŋine don mane iwa yale raki sarike, “Ge nae gipon maepne, na geŋane zok similenan okanmaike.” ");
INSERT INTO ons_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu eŋe komaine 30 okangi, so urataine kieke make, ŋei ŋerep eŋe Yesu wane detpi, Yosep wane gipole okange. Yosep eŋe Heli wane gipole. ");
INSERT INTO ons_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli eŋe Matat wane gipole. Matat eŋe Lewi wane gipaole. Lewi eŋe Meliki wane gipole, Meliki eŋe Yanai wane gipole, Yanai eŋe Yosep wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosep eŋe Matatias wan gipole, Matatias eŋe Amos wane gipole, Amos eŋe Nahum wane gipole, Nahum eŋe Esil wane Gipole, Elis eŋe Nagai wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai eŋe Mat wane gipole, Mat eŋe Matatias wane gipole, Matatias eŋe Semen wane gipole, Semen eŋe Yesek wane gipole, Yesek eŋe Yoda wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda eŋe Yoanan wane gipole, Yoanan eŋe Resa wane gipole, Resa eŋe Zerubabel wane gipole, Zerubabel eŋe Sealtiel wane gipole, Sealtiel eŋe Neri wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri eŋe Meliki wane gipole, Meliki eŋe Adi wane gipole, Adi eŋe Kosam wane gipole, Kosam eŋe Elmadam wane gipole, Elmadam eŋe Eri wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri eŋe Yosua wane gipole, Yosua eŋe Eliezer wane gipole, Eliezer eŋe Yorim wane gipole, Yorim eŋe Matat wane gipole, Matat eŋe Lewi wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi eŋe Simeon wane gipole, Simeon eŋe Yuda wane gipole, Yuda eŋe Yosep wane gipole, Yosep eŋe Yonam wane gipole, Yonam eŋe Eliakim wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim eŋe Melea wane gipole, Melea eŋe Menna wane gipole, Menna eŋe Matata wane gipole, Matata eŋe Natan wane gipole, Natan eŋe Dawit wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawit eŋe Yese wane gipole, Yese eŋe Obet wane gipole, Obet eŋe Boaz wane gipole, Boaz eŋe Salmon wane gipole, Salmon eŋe Nason wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason eŋe Aminadap wane gipole, Aminadap eŋe Atmin wane gipole, Atmin eŋe Arni wane gipole, Arni eŋe Hezoron wane gipole, Hezoron eŋe Perez wane gipole, Perez eŋe Yuda wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda eŋe Yakop wane gipole, Yakop eŋe Isak wane gipole, Isak eŋe Abraham wane gipole, Abraham eŋe Tera wane gipole, Tera eŋe Nahor wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor eŋe Seruk wane gipole, Seruk eŋe Reu wane gipole, Reu eŋe Pelek wane gipole, Pelek eŋe Eber wane gipole, Eber eŋe Sela wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela eŋe Kainan wane gipole, Kainan eŋe Arpakasat wane gipole, Arpakasat eŋe Sem wane gipole, Sem eŋe Noa wane gipole, Noa eŋe Lamek wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek eŋe Metusela wane gipole, Metusela eŋe Enok wane gipole, Enok eŋe Yaret wane gipole, Yaret eŋe Mahalalel wane gipole, Mahalalel eŋe Kenan wane gipole, ");
INSERT INTO ons_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan eŋe Enos wane gipole, Enos eŋe Set wane gipole, Set eŋe Adam wane gipole, Adam eŋe Anutu wane gipole. ");
INSERT INTO ons_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu eŋe Asu Koboboineŋo kotino watkeki, Yordan dokuo ŋine zinge sariki, Asuŋoka qebinkaki, kepe yaup papaino arike. ");
INSERT INTO ons_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ari goiŋ kaiwe 40, yale gekiso, Satanŋo liwekkake, naso yewao ŋara midaine so ŋara mi nene yaup gemage, ŋarainane seukke. ");
INSERT INTO ons_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pakiso, Satanŋo olale rake, “Ge Anutu wane medep gemaineo, yemo ranom wesi iwaŋo ŋara okangep!” ");
INSERT INTO ons_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Rakiso, Yesuŋo mainge olatke, “Anutu wane papiaŋo iwa yale ramaike, ‘Ŋaraŋoka ŋei gegeine mi ma wakoniake.’” ");
INSERT INTO ons_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pakiso, Satanŋo bonaga kiroine maneo iwenka wa okora more, kepe wane kutno ŋei ŋerep magune magune ŋei waomkopene eŋerop ge arikoi, yewa ikopka sikan kawareke. ");
INSERT INTO ons_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Pakiso, Satanŋo iwa yale olatke, “Zonom so eŋet biŋek pa ebone arimaike, iwa na ge ginwarekale, yewamo korop naŋane kutno motwarekoi, wane mo na ŋei mane manbe ramaine mangale, ");
INSERT INTO ons_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ge wawetŋone qe meŋen nangene, ea mo na ginbe kine kine iwa korop geŋaneka okaniake.” ");
INSERT INTO ons_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Rakiso, Yesuŋo olatke, “Anutu wane papiaŋo yale ramaike, ‘Waomŋone Anutu eŋe weku meŋen kaikene, so qelitine qe mangene!’” ");
INSERT INTO ons_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pakiso, Satanŋo Yesu Yerusalem matko Anutu wane Bakom Urum wane bakine kutno mawa birakaki, pakiso olale rake, “Ge Anutu wane Gipole gemaineo, yemo iwa ŋine sontake qei kepeo ketnom. ");
INSERT INTO ons_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Anutu wane papiao yale ramaike, ‘Anutu eŋe aŋelokoune raongi mauluke wareganikei.’ ");
INSERT INTO ons_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","So mane iwa yale ramaike, ‘Eŋe meteene kutno geu ketpi, wesiŋo kieŋone mane mi kitasiake.’” ");
INSERT INTO ons_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Rakiso, Yesuŋo olatke, “Anutu wane papiaŋo iwa yale ramaike, ‘Waomŋone Anutu Wawaine okanka more, misuk liwekkaikene.’” ");
INSERT INTO ons_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan eŋe yaleŋo yale okane, Yesu liwekka wareki qoekiso, qeliŋka more, naso mane wane toma geke. ");
INSERT INTO ons_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu eŋe Asu Koboboinane zonomŋo kito qesiŋ makiso, koso Galili kepeo zinge arike, arikiso, don kisiineŋo mat ea korop sua arike. ");
INSERT INTO ons_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Eŋe Yuda wane lewa lewaŋ urumene mere arike, yewao waket kito edange, pakiso, ŋei ŋerep korop eŋe mawakakoi. ");
INSERT INTO ons_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu eŋe ge ari mage, koso sua sua matine Nazaret yewao yalewaka ari lotke more, qezarek peadao Yuda lewa lewaŋ urumgo wake, eŋe peada baŋem yale okane gegike, eŋe iwa koso Anutu wane papia dapore edaniakane wiekiso, ");
INSERT INTO ons_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Anutu wane qelit ŋei, Isaia oŋo don qeke, yewa manbi rapoke more, don iwa yale qeke yewa kake. ");
INSERT INTO ons_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Waom wane Asuŋo naŋane kutno ketmaike, na ŋei ket gegine eŋano biŋek don ma arikalane ma wakon nanmaike. Eŋe mulap ŋei yewa siwot ongalane tale nanmaike, so deene pili pilikine yewa deene matok kalane, mulap urata ma more, bori worine yewa qekok ongalane. ");
INSERT INTO ons_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","So na Waom wane naso bomileki, ŋei ŋerewekoune ma menaŋ oniake, ea wane biŋek don ra wakonmaile.” ");
INSERT INTO ons_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu eŋe kibi yewa dapotki qoekiso, qeuage more, qelit medep mangi paki, so ket pese metke. Paki, ŋei ŋereppa Yuda lewa lewaŋ urumgo metkoi, eŋe koropŋo deene Yesuka kalilip kakoi. ");
INSERT INTO ons_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pakiso, Yesuŋo edane rake, “Waom wane don iwa dapotpe ŋine mo derimi, ea wane weleine ukude eamo wakonmaike.” ");
INSERT INTO ons_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Rakiso, eŋe ebeene bonepke more, doninane weku mane detpi oŋaene qaeki rakoi, “Eŋe iwa mo Yosep wane gipole mida me?” ");
INSERT INTO ons_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesuŋo iwa yale edange, “Ŋine naŋane don naŋengo more more iwa yale mane ra okanmami, ‘Dokta, ge goŋomka ma menaŋ nagumaine.’ Ŋine dere nolasikei, ‘Kaperneam matko manom, kisiŋone detokanmaine, yalewaka iwa geŋone matŋono manom, kaŋem.’ ");
INSERT INTO ons_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yale rau, na welekatne don naŋengo ŋidanbe detpi, Anutu wane qelit ŋei eŋine kepe matino ge more done raki, ŋei ŋerep eŋe maine mi tewekkei. ");
INSERT INTO ons_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“So Welekatne ŋidanbe, Elaiya geke, naso yewao kaiwe suaine okoraki, koma karewe so nat paromine meso 6 yale paki, ŋara siukki bodi suaine wakone, kepe rokopke pake. Naso yewaoka Israel eŋane kepeo mala loutne gekoi, ");
INSERT INTO ons_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ŋo siluŋ Anutu eŋe Elaiya rakaki, Israel eŋano mi arike, eŋe rakaki qelaŋ ŋerep mala mane Zarepat matko, Sidon kepeo geke, eŋano arike. ");
INSERT INTO ons_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","So propet Elisa geke, naso yewao Israel eŋane keuo ŋine ŋei loutne kubet togon gorop gekoi, ŋo siluŋ Israel eŋane keuo ŋine ŋei mane wane kubetineŋo mi osike, yemo Naman, Siria kepeo ŋine, eŋane kubetine weku osike.” ");
INSERT INTO ons_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesu eŋe yale ra edangiso, ŋei ŋerep Yuda lewa lewaŋ urumgo metkoi, eŋe detpi sigileki, sotene osike. ");
INSERT INTO ons_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pakiso, wie more mat ŋadino Yesu ma birakau qeinat ketki ma ari more, matene metke bonaga yewa wane pupulukino iwenka wa more, sora mezeno ma ari more, sorao rupapkau kesiakane okangoi. ");
INSERT INTO ons_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ŋo siluŋ mi kauso, eŋe ŋei ŋerep keueno ŋine piŋdige more, ket siu siuko sanka arike. ");
INSERT INTO ons_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu eŋe ari mage, Galili kepeo mat mane Kaperneam, yewa lotke more, qezarek peadao ŋei ŋerep edane kito ebon okange. ");
INSERT INTO ons_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yesu wane donine ewinerop raki, ŋei ŋerep eŋe dere more welelepkekoi. ");
INSERT INTO ons_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yuda lewa lewaŋ urumgo ŋei mane asu borikinerop metke, ");
INSERT INTO ons_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","eŋe Yesu ka more, suaineka boka more rake, “Yai! Yesu Nazaret welaine, ge daleo okan ŋonikenane sarimaine? Ge matali ŋonikenane sarimaine me? Na det ganmaile, ge Anutu wane Ŋei Koboboine.” ");
INSERT INTO ons_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yale rakimo, Yesuŋo asu borikine don olale more rake, “Ge doŋ mane more, ŋei yewa qeliŋka saket arinom!” Rakiso, asu borikine eŋe ŋeiwa ma papkaki, ŋei ŋerep keueno ket rasu pakiso, eŋe saket arike, ŋei wae mi matalikake. ");
INSERT INTO ons_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pakiso, ŋei ŋerep eŋe ka more oŋaene qaeki, auye qeuye okane more rakoi, “Don iwa daleo? Eŋe ewe bibirop so zonomineropŋo asu borikine raongi, saket arimami!” ");
INSERT INTO ons_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pakiso, Yesu wane don kisi yewaŋo kepe mat yewa sua rokopke arike. ");
INSERT INTO ons_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu eŋe Yuda lewa lewaŋ urumgo ŋine ket more, Saimon wane matko wake. Saimon wane sewenine eŋe zoma gereunerop qeki pake, pakimo eŋe Yesuŋo mapik kayakane ra more olatkoi. ");
INSERT INTO ons_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pakiso, Yesu eŋe Saimon sewenine pake, mat kotine yewa waket more papainane osino okora, so zomawaeŋo qeliŋkayakane togoleka olatke, pakiso zomawae eŋe ŋerep yewa qeliŋkakiso, ŋereppae eŋe esat yemdaka wie more koso, ŋaraene mire mauluk okange. ");
INSERT INTO ons_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kepe qoekiso, ŋei ŋerep natne eŋe kimakopene zoma kine kine natneŋo ebuki pa okangoi, yewa Yesu wano ebu sarikoi, pakiso, Yesuŋo metine leweteno weku weku more, korop ma menaŋonge. ");
INSERT INTO ons_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Asu borikine eŋe yale waka, ŋei ŋerep loutne eŋane kotoeno ŋine esopongi saket more, aro suaine aroke more rakoi, “Ge Anutu wane Gipole!” Pakiso, Yesu eŋe asu borikine yewa eŋe don mi raikei wane rawetonge, onoka wane eŋe kineine iwa yale detkoi, eŋe Mesia. ");
INSERT INTO ons_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kepe qaekiso, sakoropka, Yesuŋo wie more mat yewa qelige, kepe nat paromine ŋeiine midaine pake, yewa ari geke. Pakiso, ŋei ŋerep eŋe zuaŋka ge mage, so maratkakoi, maratka more eŋerop geakane ma walukkakoi. ");
INSERT INTO ons_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pakiso, Yesu eŋe siluŋ edane rake, “Na Anutuŋo daleo ŋei ŋerep wareonmaike, ea wane biŋek donine mat baŋem ŋei ŋerep korop ra edanikalane Anutuŋo biranange ketkole.” ");
INSERT INTO ons_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yale ra edane so Yuda kepeo Yuda lewa lewaŋ urum mere arike, yewao wa more, ŋei ŋerep don edane kito ebon okane geke. ");
INSERT INTO ons_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kaiwe maneo Yesu eŋe Genesaret namuŋ sawekino geki, so ŋei ŋerep loutneŋo Anutu wane don desikei wane Yesu wano lotke more, osino lewage more lolikkakoi. ");
INSERT INTO ons_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu eŋe otki, seki etke waraŋotpi sa qalakko metkoik, zawon teba teba ŋei eŋe sekiene qeliŋore ket so kamagaene sauke okorakoi, ");
INSERT INTO ons_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","pakiso, Yesuŋo sekiwa mane Saimon wane rara, ea wane kutno waki, pakiso Saimon rakaki, seki qebinkaki, qalakko ŋine qei qei weteke, pakiso, Yesu eŋe seki kutno mere, ŋei ŋerep magu suaine don kito edange. ");
INSERT INTO ons_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Edangi qoekiso, Saimon olale rake, “Geŋone so kimatkeŋone ŋine sekiŋine esorogeu, qei namugo weteuk ma kamagaŋine zawon ebukei wane birau ketkep.” ");
INSERT INTO ons_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Rakiso, Saimonŋo olatke, “Kito ebo ebon, ŋene goiŋ kirop pae urata suaine mene, ŋo zawon mane mi ebune, ŋo siluŋ goŋo ramainane, koso kamaga birawe ketkep.” ");
INSERT INTO ons_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yale ra more, eŋe kamaga birau ketki, zawon magu suaine kamagao watkeu, kamaga toeakane okange. ");
INSERT INTO ons_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pakiso, eŋe kimakopene seki maneo gekoi, yewa meteeneŋo pakonbi sarikoi, sariu so zawon peikeu, sekiwo wamage, seki etke eretnarek watkekoik. Pakiso, zawon umatneŋo etotki, seki etke yewa oroge kiwetko ketkeik wane okangoik. ");
INSERT INTO ons_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Petoroŋo masi yewa kaki paki, Yesu wane kaitko wawetine qe more rake, “Waom! Qeliŋnane arinom, na ŋei borikine!” ");
INSERT INTO ons_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pakiso, Saimon eŋine so kimakoune weneŋ gekoi, eŋe zawon magu suaine ebukoi, yewa ka more welelepkekoi. ");
INSERT INTO ons_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon kimatkine, Yakop so Yohane, Zebedi wane gipoletkine, ere yale waka oŋaetne qaeke, pakiso, Yesuŋo Saimon olatke, “Mi kaet gangep, ge ukude zawon urata mamaine, boaŋ ŋei ŋerep yale waka eŋano urata ma more ebunom, naŋano sarikei.” ");
INSERT INTO ons_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pakiso, eŋe seki waraŋotpi qalakko wauk so, kine kineene korop qeliŋware so, Yesu ŋadino arikoi. ");
INSERT INTO ons_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Atak maneo Yesu eŋe ari ŋei mane kubetŋo solaine korop rokopkaki geke, mat yewao lotkeke, pakiso ŋei yewa eŋe Yesu kaki paki, oŋomka tamge more rake, “Suaine, ge detnom paki, maine sauk nangene!” ");
INSERT INTO ons_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesuŋo metine solaino ma more rake, “Na det ganmaile, wakoenom!” Rakiso, yewaoka kubetŋo osiki paki, ŋei qeliŋkaki menaŋge. ");
INSERT INTO ons_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pakiso, Yesuŋo ŋei wa rawetka more rake, “Ge kubetŋone osimaike, ea wane don kisiŋone ŋei mane mi edanikene, ge mosop ŋei, pris wano ari solaŋone sikankanom, kayake. Pakiso, solaŋone menaŋmaike, ea wane Mose wane don teweke more, soe soep mitnom, ŋei ŋerep eŋe ka more, solaŋone mo wakoemaike, yale desikei.” ");
INSERT INTO ons_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ŋo siluŋ Yesuŋo ŋeiwa kubetine maki osike, ea wane don kisiŋo sua arike, pakiso, ŋei ŋerep loutneŋo Yesu wane donine desikei wane, so zoma kubet korop yewa sauk oniakane sarikoi. ");
INSERT INTO ons_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesu eŋe Anutuŋo zonom maniakane, kepe ŋei me mat kine kine midaine, yaup sai pamaike, yewao eŋineka ari more, meŋe meŋen urata mamageke. ");
INSERT INTO ons_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kaiwe maneo, Yesuŋo ŋei ŋerep don kito edange, Anutu papa togon welaine ŋei, Parisi so Skribe, eŋe weneŋ yewa metkoi, eŋe Galili kepeo mat mere arike, yewa ŋine so Yuda ŋine so Yerusalem ŋine. Waom wane zonomŋo weneŋ Yesurop geki, zomaenerop ma menaŋ onge. ");
INSERT INTO ons_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pakiso, ŋei natne eŋe ŋei mane kine so metine seu seune, yewa supiwo ma birau ketkiso teweke, Yesuŋo ma menaŋ kayakane eŋano ma arikoi. ");
INSERT INTO ons_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ari more, mat koto ma wakesikei wane, ŋei ŋerep magu suaine eŋano qekakoi, pakiso, teweke weti mat bakine kutno ma wa more, mat bakine lalageso, sopiinerop birakau mat koto, ŋei ŋerep magu eŋane keuno Yesu wane kaitko ket pake. ");
INSERT INTO ons_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pakiso, Yesuŋo mali malipene korop pa ebonge, yewa kaki pakiso, ŋei wa kie metine seu seune olale rake, “Kimane, geŋane sotŋone mo matali ginmaile.” ");
INSERT INTO ons_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Anutu papa togon welaine ŋei, Skribe so Parisi, eŋe don yewa dere more, edomka auye rakoi, “Ŋei iwa eŋe ma ŋeiŋo Anutu ma baik kamaike me? Ŋei maneŋo maine borikine mi mataliake, Anutu wekuŋo maine borikine mataliake!” ");
INSERT INTO ons_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yale auwi, Yesuŋo wetenane kine dere more, edane rake, “Ŋine wetŋineŋo onoka wane yaline wetkemami? ");
INSERT INTO ons_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Diawaŋo ewekine raikene, ‘Geŋane borikineŋone mo matali ginmaile,’ me raikene, ‘Wienom paki, arinom?’ ");
INSERT INTO ons_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Na ra qelaŋan ŋunbe, Ŋei Wawainane Gipole, eŋe kepeo borikine matali matali wane zonom pa manmaike.” Yesuŋo yale edangi pakiso, ŋeiwa kie metine seu seune olatke, “Na golatpe, ge wienom! Papaŋone manom paki, matko arinom!” ");
INSERT INTO ons_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Rakiso, ŋeiwa eŋe ikopka ŋei ŋerep eŋane deene kutno wie more papaine more pake, yewa ma more, so matino ari Anutu bakomine kitoke. ");
INSERT INTO ons_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ŋei ŋerep eŋe yewa ka more, zok welelepkekoi! So kaetongi, Anutu bakomine kito more rakoi, “Masi kine mane, mi kakaze, iwa ukude wakongi kamaine!” ");
INSERT INTO ons_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ea wane ŋadino, Yesuŋo ari more kaki, ŋei mane takis mama, eŋetine Lewi, eŋe takis mama urumino metke, pakiso Yesuŋo olale rake, “Ŋadeno modatnane sarinom.” ");
INSERT INTO ons_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Rakiso, Lewi eŋe wie more, kine kineine korop ŋadekkawareso, Yesu ŋadino arike. ");
INSERT INTO ons_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pakiso, Lewiŋo Yesu wane ŋara soep suaine matino mitwarekiso, takis mama ŋei, so ŋei yauwine natne loutneŋo weneŋ ererop zakeo mere nekoi. ");
INSERT INTO ons_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Anutu papa togon welaine ŋei, Parisi so Skribe eŋane tego natne eŋe Yesu wane dokoine eŋane detpi boriki rakoi, “Ŋine onoka wane takis mama so borikine mama eŋerop ŋara doku nemami?” ");
INSERT INTO ons_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Rauso, Yesuŋo mange edange, “Ŋei ŋerep solaene maine eŋe dokta wano mi ari okanmami, zoma kubetenerop edoka weku ari okanmami. ");
INSERT INTO ons_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na ŋei ŋerep maine eŋet biŋek korop eŋe edorawe wetene maingekei wane mi ketkole, na borikine mama edorawe, wetene maingekei wane ketkole.” ");
INSERT INTO ons_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ŋei ŋerep natne eŋe Yesu olale rakoi, “Yohane wane dokoine eŋe ŋara doku wane sawe ge more, naso baŋem meŋenka okanmami. So Anutu papa togon welaine ŋei Parisi, eŋane dokoene eŋe yale waka okan okanmami, ŋo geŋane dokone yemo ŋara doku nemami.” ");
INSERT INTO ons_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesuŋo edane rake, “Ŋei mane ŋanomine mayake, eŋane lobokoune eŋane ŋara mawaulukeu, ŋerep ŋaone eŋe weneŋ eŋerop metkika ŋido maine ŋara mawalukeu, eŋe ŋara midaine arikei me? O weneŋ midaka! ");
INSERT INTO ons_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Eŋe boaŋ ŋadino ŋerep ŋaone ea ma ariu, kimakoune eŋerop weneŋ mi metki, ra togole onbi, kimakoune ea eŋe maine ŋara midaine arikei.” ");
INSERT INTO ons_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesuŋo don saeŋine iwa yale waka edange, “Man maŋo tutu mane takot muselo ŋine matoke more, takot sogine bara warakine yewao more qetusiake. Eŋe yalewa okangi, takot musele yewa barakeake, pakimo takot muselane tutuine yewaŋo takot sogine yewao mo rokopkeake. ");
INSERT INTO ons_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Me mane maŋo wain musele qeki nomare sogine yewao weteake, eŋe yalewa okangi, wain musele yewaŋo nomare sogine yewa abongi poripkeki, wain ea qakeake, pakimo, nomare ea muzugeake. ");
INSERT INTO ons_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mida! Wain musele ea qeu nomare muselo weteake! ");
INSERT INTO ons_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mane eŋe wain sogine neki similekake, eŋe wain muselane bauine wamaike, paki ramaike, ‘Wain sogine yemo weku mane.’” ");
INSERT INTO ons_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Qezarek naso maneo, Yesu eŋe wit eu keuoka kitare arike, pakiso, dokoine eŋe wit natne matoke more meteeneŋo usuke nekoi. ");
INSERT INTO ons_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yale okanbiso, Anutu papa togon welaine ŋei, Parisi natne eŋe one more rakoi, “Anutu wane ra rokop donŋo qezarek naso yewa mo okangenane ra togolemaike, yewa ŋine onoka wane okanmami?” ");
INSERT INTO ons_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesuŋo edange, “Dawit eŋine so ŋeikoune ŋaraenane seuke more daleo okangoi? Ŋine papiao ea mane dapore det okanmami me? ");
INSERT INTO ons_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dawit eŋe Anutu wane urum koto wa more, bret Anutu wane biŋek motmole, yewa ma neke. Ne more, ŋeikoune yale waka ebongi nekoi. Bret yewa ŋei natneŋo mi nekei wane, Anutu wane ra rokop donŋo ra togoleke, mosop ŋei edoka weku maine nekei.” ");
INSERT INTO ons_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu eŋe yale edane rake, “Ŋei Wawainane Gipole, eŋe qezarek naso wane Waom.” ");
INSERT INTO ons_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Qezarek naso maneo, Yesuŋo Yuda eŋane lewa lewaŋ urumgo wa more, don kito edange. Ŋei mane metine wonine seu seune, eŋe weneŋ yewa metke. ");
INSERT INTO ons_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Anutu papa togon welaine ŋei natne, Parisi so Skribe, edo qezarek nasoo Yesuŋo ŋei ma menaŋongi ka more, dongo birakaikei wane diamine makoi. ");
INSERT INTO ons_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yale okanbi, Yesuŋo eŋane wetenane kine detki paki, ŋei metine seu seune olale rake, “Wienom paki, sari iwa kaitzo okoranom.” Rakiso, ŋei wae eŋe wie more ari yewa okorake. ");
INSERT INTO ons_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pakiso, Yesuŋo edane rake, “Na qeson ŋunmaile, ra rokop donzeŋo qezarek naso onoka makenane ramaike? Ŋei qesiŋ kaikene, me wikile mangene? Ŋei ma menaŋkaŋem gegeine wakoniake, me gegeine matalikene?” ");
INSERT INTO ons_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yale raki, pakiso deineŋo pore lolike ŋei korop onge, pakiso ŋei wa olale rake, “Meteŋone biranom.” Rakiso, eŋe metine biraki, metine menaŋge. ");
INSERT INTO ons_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ŋei eŋe yale kau paki, kotoene gerep okangi, Yesu daleo okankaikei wane, edomka don auye qeuye okangoi. ");
INSERT INTO ons_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Naso yewao, Yesuŋo meŋen kayakane raki paki bonagao wake, wa more ruo mane korop Anutu meŋenkake. ");
INSERT INTO ons_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kepe qaekiso, Yesuŋo dokoine edoraki, ariuso dokoine12 ma wakonone, so eŋetene aposolo edorake. ");
INSERT INTO ons_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon, eŋetine musele Petoro orake, so ŋole Andrea, Yakop so Yohane, so Pilip so Bartolomu ");
INSERT INTO ons_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataio so Tomas, Yakop, Alpius wane gipole so Saimon, eŋetine mane Patriot, ");
INSERT INTO ons_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas, Yakop wane gipole, so Yudas Iskariot, eŋe Yesu ŋaba eŋane meteene ma wakonka birakake. ");
INSERT INTO ons_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuŋo bonagao ŋine aposolokoune eŋerop ket more, kepe digile maneo dokoine loutne eŋerop okorakoi, pakiso, ŋei ŋerep magu suaine Yuda ŋine Yerusalem ŋine so Tire so Sidon saweketno ŋine korop yewa sarikoi. ");
INSERT INTO ons_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Eŋe Yesuŋo don kito edangi desikei wane, so zomarop ma menaŋ oniakane sarikoi, so natne asu qotkoineŋo matali qetali ebuke, eŋe weneŋ sariu ma menaŋonge. ");
INSERT INTO ons_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ŋei ŋerep loutne eŋe Yesu wane zonomŋo saket more kotoeno ketki menaŋ warekoi, ea wane solaino maikei wane soringekoi. ");
INSERT INTO ons_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesuŋo dokoine ongi paki rake, “Aboŋŋine midaine ŋine wet pesek desikei, Anutuŋo kine kine korop ma wakonge, paki warekaki pamaike, ea mo ŋinane! ");
INSERT INTO ons_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ŋara wane seu seu gemami, ŋine wet pesek desikei, ŋine boaŋ neu ŋatŋine qeake! Kua suruk arok okanmami, ŋine wet pesek desikei, ŋine boaŋ tenikkei! ");
INSERT INTO ons_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ŋei Wawainane Gipole rau paki ŋaba ŋunikei, qaisik ŋunikei, dere worik ŋunikei, borikine mama ŋidorakei, ŋine ea wane wet pesek desikei! ");
INSERT INTO ons_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tanik yewa wakongi, wet pesek dere more, qeliwo lewine suaine warekaki pamaike, ea wane bakom kitokei. Eŋane aso ŋabokopene eŋe masi yewaka Anutu wane qelit ŋei okanongoi, so ea wane propet edo qekoi, ");
INSERT INTO ons_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Wesi aboŋ suainerop gemami, naso iwao, ŋine gege ewekine mo iwa gemami! ");
INSERT INTO ons_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ŋo ŋine naso iwao neu ŋatŋine qeokanmaik, ŋine boaŋ ŋaraŋinane seukkei! Naso iwao teni teniko gemami, ŋine boaŋ arokkeu, deŋine dokune kesiake! ");
INSERT INTO ons_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ŋei ŋerep korop eŋe qem mawa okanŋunikei, paki ŋine siluŋ kaulukkei, ŋabokopeene eŋe don me tanik wekuka propet isisine eŋane okangoi.” ");
INSERT INTO ons_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Donne dere ge okanmami ŋine ŋidanbe, ŋaba kopŋine eŋane siminŋunge wetŋine eŋane payake, qaisikŋune okanmami, eŋe mauluk onikei. ");
INSERT INTO ons_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Soaŋune okanmami, eŋe mosop onikei. Ŋine isibela okanŋune okanmami, eŋane meŋen kaikei. ");
INSERT INTO ons_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ŋo, ŋei maneŋo mugumŋone nat gekuki, ge mugumŋone nat yewa weneŋ sunkanom qeake. Ŋo ŋei maneŋo takotŋone suaine yewa maki, ge takotŋone nigatne yewa weneŋ sunkanom mayake. ");
INSERT INTO ons_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ŋei mane eŋe kine kine mane wane meŋengangi, ge manikene. Ŋo mane eŋe geŋano ŋine kine kine mane maki, ge mainge giniakane misuk rakakene. ");
INSERT INTO ons_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ŋine ŋei edo kine kine okanŋunikei wane ra okanmami, kop yale waka eŋe okanonikei. ");
INSERT INTO ons_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ŋo ŋine kima okanŋune okanmami, ŋei ŋereppa weku eŋeka kima okanongei, yemo ŋine turuŋine mosop mi maikei! Borikine mama eŋe yale waka kima okanonmami, yewaka kima okanonmami! ");
INSERT INTO ons_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","So ŋine masulukŋone okanmami, ŋei ŋereppa eŋeka weku masulukongei, yemo daleo turuŋine mosop mane maikei? Borikine mama eŋe yale waka okan okanmami! ");
INSERT INTO ons_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","So ŋine turuŋine mainge ŋibongei, ŋei yewa eŋeka kine kine ebongei, yemo ŋine daleo mosop mane maikei? Borikine mama eŋe yale waka kine kine turuŋine rokop wekuka mainge ebongei wane, borikine mama kimakopene ebon okanmami! ");
INSERT INTO ons_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yale mida! Ŋine ŋabakopŋine kima okanongei, so masulukongei. Kine kine ebone more koso turuŋine ŋibongei wane misuk raongei. Ŋine boaŋ lewine suaine maikei, so ŋine boaŋ Anutu Wawainane gipon borasokoune okangei. Anutu eŋe siluŋ ŋei ŋerep eŋe wet maep mi okanka qewoloŋ gemami, so borikine mama maulukone more kine kine mayakakatneka okanon okanmaike. ");
INSERT INTO ons_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Anutuŋo wetine ŋinane pamaike, yale waka ŋine wetŋine ŋei ŋerep korop eŋane payake. ");
INSERT INTO ons_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ŋine ŋei ŋerep natne eŋane kineene misuk qeu wakongei. So Anutuŋo ŋinane kine ŋine mi qeu wakoniake. Ŋine ŋei ŋerep natne sot turugo misuk biraongei, paki, Anutuŋo ŋine yale waka sot turugo mi biraŋuniake. Ŋine ŋei ŋerep eŋane sot turuŋene qeligeu, Anutuŋo ŋinane sot turuŋŋine yale waka qeligeake. ");
INSERT INTO ons_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ŋine ŋei ŋerep kine kine yaup ebonikei, paki Anutuŋo ŋine kine kine yale waka ŋiboniake, so ea wane rokop yuane qewa more, manerop magu suaine qakki meteŋino wayake, paki ŋine yewa korop rokopŋino maine malipkakei. Ŋine kine kine korop mage more, ŋei ŋerep rokopeno okanongei, rokop yewaka Anutuŋo mage more, ŋine okanŋuniake.” ");
INSERT INTO ons_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pakiso Yesu don saeŋine mane iwa yale edange, “Ŋei mane deine pili pilikineŋo de pilik kimaine iwenkaki, numao maine arikeik me? I midakaka, eŋe iwenkaki eretnarek waraŋnagu ari qeyau sorao ketkeik. ");
INSERT INTO ons_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kibi medepŋo kito man manine mi yuankayake, ŋo siluŋ kibi medep ea eŋe dereret maulukwareki qoeake, ea mo eŋe kito ebo eboninane kop okaniake. ");
INSERT INTO ons_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ge onoka wane kimaŋonane deino gok metmaike, yewa kamaine, ŋo geŋone deŋono eki sisine metmaike, yewa mo mi kamaine? ");
INSERT INTO ons_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ge geŋone deŋono eki sisine metmaike, yewa mi kaka daleo kimaŋone olale raikene, ‘Kima ge detnom na deŋono gok metmaike, yewa kitowe saketkep?’ Ge isi ŋei! Ge mikepka geŋone deŋono eki sisine metmaike, yewa kitonom saketki, deŋone pore kaulukem paki, yemo kimaŋonane deiŋo ŋine gok yewa maine kitonom sakesiake.” ");
INSERT INTO ons_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Eki maine maneŋo wele qotkoine mi qeake, me eki qotkoine maneŋo wele maine mi qeake. ");
INSERT INTO ons_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Eki eŋane kineene yemo weleŋo ma wakongi ka okanmaine, segetko wele qauk mi qeki kitokene. Me zagongo wele danam mi qeki siwekine. ");
INSERT INTO ons_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ŋei maine eŋe wet dereret maine zok kotino pamaikane, don maine aŋaino ŋine saket okanmaike. Ŋo ŋei mane borikinane dereret qotkoineŋo kotino zok pamaikane, don qotkoine aŋaino ŋine saket okanmaike. Kine kineŋo ŋei koto watke pa okanmaike, yewaŋoka koso aŋaoka sa okanmaike.” ");
INSERT INTO ons_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ŋine onoka wane piŋineŋoka nora okanmami, ‘Waomze, Waomze.’ Ŋo don ŋidan okanmaile, yewa mo mi tewek okanmami? ");
INSERT INTO ons_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ŋei mane eŋe naŋano sari more donne detki paki, aŋane tewekeake, ŋei yewa eŋane rokop don mane rokop motpe, ŋine kau. ");
INSERT INTO ons_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Eŋe ŋei maneŋo mat mane make yale, eŋe lom kiroine mawareki pakiso, simen liwage qakki ket wesi suaine lom koto metkoi, yewao makatak warekiso, kutno mat make. Pakiso, koya qe more doku qakumŋo sari mat bosiŋ qeki mi okmaŋge, mat mauluke mamainane togole more metke. ");
INSERT INTO ons_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ŋo ŋei mane eŋe naŋane don dere more aŋane mi tewekeake, eŋe yemo ŋei mane oŋo mat mane make yale. Eŋe kepe kutno lom ma more simen liwage more mat mat togoleakane mi more more yaup make. Eŋe matine yau yaup maki metki, doku qakumŋo sari mat qeki ikopka okmage ket zaŋ zuŋ make!” ");
INSERT INTO ons_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu eŋe don iwa ŋei ŋerep korop ra edanwareki qoekiso, Kaperneam matko arike. ");
INSERT INTO ons_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yewa Roman kawali ŋei ŋetne mane wane qelit medep mane geke. Kawali ŋei ŋetne yewa eŋe qelit medeunane zok wetine suaine pake, wane qelit medeune eŋe zoma suaine qeki seukeakane okane pake. ");
INSERT INTO ons_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pakiso, kawali ŋei ŋetne eŋe Yesu wane donkisi dere more, Yuda ŋei ŋetne raongi arikoi, Yesu olatpi sari qelit medeune ma menaŋ kayakane. ");
INSERT INTO ons_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Eŋe Yesu wano ari lotke more soriringe meŋenka rakoi, “Eŋe ŋei maine, ge ea wane donine dere so mapik kaikene. ");
INSERT INTO ons_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Eŋe wetine Yuda ŋei ŋerep ŋenaneka pamaike, eŋe oŋomka Yuda wane lewa lewaŋ urum ma ŋebonge.” ");
INSERT INTO ons_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pakiso, Yesuŋo eŋerop weneŋ arikoi, ari mat osino rakiso, kawali ŋei ŋetne eŋe kimakoune natne raongi, Yesu wano don iwa yale ma arikoi, “Suaine, ge urata suaine mi manom, na ŋei mainane sari matne koto sakene. ");
INSERT INTO ons_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Na nae wane detpe mi menaŋge, ŋei borikineŋo daleo geŋano sarikale ra more qekele, wane mo ge yewa ge more, donŋoneŋoka ranom qelit medepne maine menaŋ kayake. ");
INSERT INTO ons_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na yale waka, na ŋei wawaine eŋane qelit ŋei, pakimo, naŋane ketkele kawali ŋeikopne naŋane bango gemami, yale wane mo iwa wane raikale, ‘Arinom!’ Rawe eŋe ariake. Ŋo eriwa wane raikale, ‘Sarinom!’ Rawe eŋe sariake. Ŋo qelit medepnane raikale, ‘Iwa manom!’ Rawe, eŋe yewa mayake.” ");
INSERT INTO ons_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu eŋe don yewa dere more mawaka more, zinge ŋei ŋerep magu suaine ŋadino arikoi, eŋe edane rake, “Na mali malip suaine iwa yaline mane mi maratka okanmaile, na ŋidanmaile, Israel eŋano yale waka mane mi maratka okanmaile!” ");
INSERT INTO ons_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yale rakiso, ŋeiwa kawali ŋei ŋetneŋo qelit raongi, Yesu wano sarikoi, eŋe zinge ari kawali ŋei ŋetnane matko wa more kau, qelit medepine mo menaŋkake. ");
INSERT INTO ons_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nigatne gege more, ŋado Yesuŋo mat mane eŋetne Nain yewa arike, eŋine dokoine so ŋei ŋerep magu suaine weneŋ eŋerop arikoi. ");
INSERT INTO ons_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ari more, mat suainane madet osino lotkekiso, ŋei ŋerep eŋe medep seu seune mane wane pareŋ teweke sarikoi. Ŋei seu seune ea mo ŋerep mala mane wane gipole wemedep weku, eŋe seukki mo dukkei wane ŋei ŋerep magu suaineŋo weneŋ mat suaino ŋine eŋerop sarikoi. ");
INSERT INTO ons_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pakiso, Waomŋo ŋerep mala ka more, eŋane wet borikŋo kotino watkekiso, ŋerep olale rake, “Ge misuk arokenom.” ");
INSERT INTO ons_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pakiso, Yesu eŋe ari katapa yewa metineŋo makiso, ŋeiwa pareŋ katapa tewekkoi, eŋe doŋmane okorakoi. Okorauso, Yesuŋo rake, “Ŋei qaluwit! Na golatmaile! Wienom!” ");
INSERT INTO ons_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Rakiso, ŋei seu seune eŋe wie metke so kieke don rake, pakiso Yesuŋo mainge nagaine mange. ");
INSERT INTO ons_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ŋei ŋerep eŋe yewa ka more kaetongi, Anutu mawaka rakoi, “Anutu wane qelit ŋei suaine mane keuzo wakonge!” So rakoi, “Anutuŋo sari more eŋine ŋei ŋerewekoune ma menaŋ ŋonmaike!” ");
INSERT INTO ons_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu wane don kisiine iwaŋo Yuda kepeo korop rokopke more, kepe nat nat ariwareke. ");
INSERT INTO ons_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohane wane dokoine eŋe don kisi yewa olatwareu dereso, medewetkine etke etoraki sarikoik. ");
INSERT INTO ons_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Pakiso, Waom don iwa yale ra more qesonkaikeik wane eŋano taleotki arikoik, “Sarikenane raraine, ge weku mo iwa sarimaine, me ŋene mane wane tomakaikene?” ");
INSERT INTO ons_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pakiso, ere Yesu wano ari lotke more olale rakoik, “Yohane doku tau tauŋo taleŋotki, qeson gangetane sarimaite, ‘Sarikenane raraine, ge weku mo iwa sarimaine me? Me ŋene mane wane tomakaikene?’” ");
INSERT INTO ons_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nasomde yewaoka Yesuŋo ŋei ŋerep loutne zomaenerop ma menaŋonge, kubet togon gorop saukonge, asu qotkoinerop esopongi saket arikoi, deene pili pilikine ma menaŋonge. ");
INSERT INTO ons_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pakiso, Yesuŋo Yohane wane qelit ŋeitkine etane rake, “Ŋire zinge ari more, tanik kine kine daleo wakongi kamamik, so detmamik, yewa Yohane olatpik, de pilikŋo deene maine potmami, so kie wawetne seu seuneŋo numa maine gesoke arimami, so kubet togon gorop ebuki, kubetene osimaike, so ket wonŋo ketene lotkeki, don maine detmami, so seu seuneŋo koso wisikae wiemami, so ŋei ŋerep ketkeleŋo Anutu wane biŋek don detmami. ");
INSERT INTO ons_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ŋei mane eŋe naŋane wet etke mi okaniake, eŋe wet pesek desiake!” ");
INSERT INTO ons_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohane wane qelit ŋeitkine ere biraore ariuk, so ea wane ŋadino Yesuŋo kieke more Yohane wane don kisi ŋei ŋerep edane more rake, “Ŋine kepe yaup papaino Yohane wano onokaka kaikei wane arikoi? Ŋine gim metine momoŋo mapateki, kaikei wane arikoi me? ");
INSERT INTO ons_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ŋine ari more onokaka kakoi? Me ŋine ŋei mane takotine kibinerop kaikeiwane arikoi? Midakaka! Ŋei takot kibinerop wekumane au ge okanmami, eŋe ŋei waom urumgo met okanmami. ");
INSERT INTO ons_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pakimo, nolatpi, ari more onokaka kakoi? Ŋine ari Anutu wane qelit ŋei mane kakoi. Welekatne, na ŋidanbe, ŋine ŋeiwa kakoi, eŋe Anutu wane qelit ŋei natne eŋane rokop mida! Eŋe eŋineka rokop mane. ");
INSERT INTO ons_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yohane weku eŋane Anutu wane papiao iwa yale ramaike, ‘Anutuŋo gipolano ramaike, iwa eŋe naŋane qelit ŋei, detmami, na boaŋ ŋei mane talekawe, geŋane numa ma alakane more, numaŋone lalageake.’ ");
INSERT INTO ons_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na ŋidanbe, ŋerepko ŋine wakon okanmami, ŋei yewa korop eŋano ŋine maneŋo Yohane mi yuankayake. Ŋo, ŋei mane eŋe Anutuŋo eŋetne kine kine kakaine so mi kakaine ma wakonge pamaike, ea wane naso iwa kotino ketkele geakeŋo, Yohane yuankayake.” ");
INSERT INTO ons_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ŋei ŋerep korop so takis mama eŋe Yohane wane don dere more doku taukoi, yewa eŋe Anutu wane don wele dere tewekeu wele wakonge. ");
INSERT INTO ons_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ŋo, Anutu papa togon welaine ŋei, Parisi so Skribe, eŋe yemo Yohane wane doku tau tau yewa qaisikka more Anutu wane don ŋadekkau eŋano wele midaine okange. ");
INSERT INTO ons_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Pakiso, Yesuŋo takotke rake, “Ŋei ŋerep iwa diawa eŋane rokop motpe? Eŋe ma yale? ");
INSERT INTO ons_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Eŋe ŋerep medep nigatne yale. Ŋerep medep nigatne eŋe sobego mere, ŋerep medep magu mane edo magu mane iwa yale ra boka edanmami, ‘Ŋene mete au au wane wagom ŋinane ra kitoŋem, ŋine eŋet mi oremami! Ŋene seu seu eŋet kitoŋem, ŋine mi arokmami!’ ");
INSERT INTO ons_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohane doku tau tau sari more, doku togole wain mi nene tau geki, ŋine rakoi, ‘Eŋe asu qotkoineŋo kotino ket metmaike!’ ");
INSERT INTO ons_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ŋei Wawainane Gipole sari more ŋara so doku neke, pakiso ŋine rakoi, ‘Ŋei iwa kau! Eŋe ŋara so wain doku togole nene, so takis mama so borikine mama eŋane kimaene!’ ");
INSERT INTO ons_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ŋo, Anutu wane dereret suaine yemo ŋei ŋerep pa dere more ma nogankakoi, eŋano wele welekatne sikanonge.” ");
INSERT INTO ons_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Anutu wane papa togon welaine, Parisi ŋei maneŋo Yesu ŋara eŋerop nekeik wane newankake. Pakiso, Yesuŋo Parisi wane matko wa more ŋara neakane pese metke. ");
INSERT INTO ons_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pakiso, mat yewao ŋerep mane gege mageine qotkoine geke, oŋo Yesu wane kisi detki, Parisi wane matko mere ŋara neke, pakiso, ŋereppae eŋe kelok beloŋ mane qounerop yewa ma more arike. ");
INSERT INTO ons_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ari more, Yesu wane ŋadino kine osino okora more arokke. Arokki deine dokuneŋo ket more Yesu wane kine taukake. Pakiso, lewine zouneŋo Yesu wane kine ratoke so lulu kike. Ki more so kelok qounerop yewa qakki, Yesu wane kine taukake. ");
INSERT INTO ons_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pakiso, Parisi Yesu newankake, oŋo yewa ka more, oŋomka Yesu wane iwa yale rake, “Ŋei wae eŋe welekatne propet wele ra, yemo eŋe ŋereppae maŋo kine mamaike yewa detki rap, so ŋereppae gege mageine qotkoine gemaike, yewa weneŋ detkaki rap!” ");
INSERT INTO ons_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesuŋo rau wakone more olale rake, “Saimon, na don mane magemaile golatpe.” Rakiso, Saimonŋo rake, “Kito ŋebo ŋebon nolatnom.” ");
INSERT INTO ons_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Rakiso, Yesuŋo kieke rake, “Ŋei etke ere ŋei mane wano ŋine wesi sota okangoik. Ŋei maneŋo wesi setne 500 sota okange, ŋo maneŋo wesi setne 50 sota okange. ");
INSERT INTO ons_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pakiso, ŋei etke yewa ere sota ea makokkeik wane wesi wane qekakoik, pakiso, wesi welaine eŋe sota yewa yeine qeliŋge, ŋei diawaŋo wesi welainane zok simile desiake?” ");
INSERT INTO ons_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Pakiso, Saimonŋo mainge rake, “Na ramaile, sota suaine okange, turuŋ qelige mange, oŋo.” Pakiso, Yesuŋo rake, “Geŋane don turuŋine maingemaine, yewa mo wele.” ");
INSERT INTO ons_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yale raki pakiso, ŋerep wano zinge more Saimon olale rake, “Ge ŋerep iwa kamaine? Na geŋane mat koto sawe ge kiene saukkalane doku mane mi ninine, ŋo siluŋ ŋerep iwaŋo yemo deine dokuneŋo kiene sauke more, lewine zouneŋo ratokike. ");
INSERT INTO ons_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na sariwe, ge oi bakomne lulu mi kirorine, ŋo ŋerep iwaŋo yemo na sariwe, lulu tako rakot kiene kike. ");
INSERT INTO ons_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ge naŋane lewene kelok mi taukene, ŋo siluŋ ŋerep iwaŋo yemo kiene kelok qouneropŋo qakkeke. ");
INSERT INTO ons_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pakimo, na golatpe, simile kakapa suaine ŋerep iwaŋo sikan ŋonmaike, yewaŋo mo ŋerep iwa wane borikineine mo korop midawarike. Ŋei mane eŋe Anutuŋo borikineine nigatne mataliakeo, ŋei yewa eŋe simileine nigatnemde Anutu wane payake.” ");
INSERT INTO ons_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pakiso, Yesuŋo ŋerep olatke, “Geŋane borikineŋone mo mataliwe suikmaike.” ");
INSERT INTO ons_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ŋei natne zakeo metkoi, eŋe kieke more edomka auye rakoi, “Ŋei iwa maŋo borikine matalimaike?” ");
INSERT INTO ons_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ŋo, siluŋ Yesuŋo ŋerep olale rake, “Geŋone mali malipŋoneŋo ma menaŋ ganmaikane, wet peseko arinom.” ");
INSERT INTO ons_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Naso bamgo qoeki, Yesu mat suaine so nigatne lolike more biŋek don ra qelaŋange, Anutuŋo daleo waremaike ea wane kine, eŋe ŋei ŋerep edange, eŋane dokoine 12 eŋe weneŋ arikoi. ");
INSERT INTO ons_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mo sogino Yesuŋo ŋerep natne eŋano ŋine asu qotkoine esoponge, so natne zomaenerop ma menaŋonge, ŋerep ea eŋerop lolike arike. Ŋerep eŋet tegoene iwa, Maria, eŋetine mane Magdalena, eŋe mo sogine Yesuŋo asu qotkoine sewen (7) eŋano ŋine esoponge. ");
INSERT INTO ons_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ŋerep mane Yoana, ŋaone eŋetine Kuza, eŋe kepe ware ware Herot wane ŋei ŋetne mane okange. Ŋerep mane, Suzana, so ŋerep natne loutne eŋe Yesu so dokoine eŋe enŋene wesi aboŋeneŋo qesiŋongoi. ");
INSERT INTO ons_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ŋei ŋerep matko matko ŋine, eŋe Yesu wano tako rakot sari more, ŋei ŋerep magu suaine lewage metkoi, eŋe Yesuŋo don rokop iwa edane rake, ");
INSERT INTO ons_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Naso maneo, ŋei mane eŋe eu wit woune rasuiakane arike. Eŋe woune natne eŋe maine euo biraka rasuki ket qake. Ŋo natne eŋe ari numao kito metki, ea ŋei sari gesokpi, so naŋi edo sari neu qoeke. ");
INSERT INTO ons_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Woune natne eŋe ari kepe wesi tabilainerop yewa wane kutno ket kito, ikopka poripke wie more, ururuke seukkoi, ea yemo kepe yewaŋo eŋe dokune midaine. ");
INSERT INTO ons_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Woune natne touk okolerop, ea wane koto ket kitokoi, wane touk okolerop yewaŋo wie more, pise waliponge. ");
INSERT INTO ons_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ŋo, wit woune natne kepe gukinerop yewao ket kitokoi, ket kito more komine poripke sua more, wele maine qekoi, wele zok manerop qekoi.” Don ea qoeki, Yesu eŋe boka edange, “Ŋei ŋerep mane eŋe don iwa dere lukeakane okane, so eŋe don iwa wane kine maine mauluke more ma desiake.” ");
INSERT INTO ons_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesu wane dokoine eŋe Yesu wano sari eŋe maine don rokop wane kine ra qelaŋaniakane qesonka rau, ");
INSERT INTO ons_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesuŋo don mainge rake, “Anutuŋo dalino ware ŋunmaike, na ŋine ea wane don sane desikei wane ŋidanmaile. Ŋo ŋei ŋerep natne eŋe yemo ŋadino gemami, yewa eŋe yemo naŋane yaup don rokop ea korop detwaremami, ea wane eŋe kaikei, ŋo, eŋe kine maine mi derelukkei. So eŋe maine naso baŋem desikei, ŋo mi dere qelaŋangei.” ");
INSERT INTO ons_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesuŋo koso iwa yale rake, “Don rokop ea wane kine yemo iwa yale okanmaike, wit woune eamo Anutu wane donŋo okanmaike. ");
INSERT INTO ons_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ŋo woune natne dumao ket kitokoi, ea yemo ŋei ŋerep natne eŋe Anutu wane don naso bomitne so bamgoka detkoi, ŋo, Satanŋo sari more Anutu wane don ea ŋei ŋerep natne eŋane kotoeno yasoke, yewamo ma biraki saket eŋine biŋek ariake, ea wane eŋe Anutu wane don ea mi malipkau ma menaŋoniake. ");
INSERT INTO ons_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Woune natne kepe wesi tabilainerop ea wane kutno ket kitokoi, ea yemo ŋei ŋerep natne eŋe Anutu wane don ikop dere ma more bakom kitokoi, ŋo don eaŋo eŋane wet derereteno togole mi waket meki, eŋe naso bomitneka malipkau, umat natne wakongi, Anutu wane don ea ikopkamde qeliŋkaikei. ");
INSERT INTO ons_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Woune natne eŋe touk okolerop ea wane koto ket kitokoi, ea ŋei ŋerep natne eŋe Anutu wane don detkoi, ŋo kepe kutno gege wane umat so wesi aboŋ suaine maratka maratka so kine kine natne ea wane bailalaŋ, eaŋo ŋei ŋerep eŋane kotoeno waket more, Anutu wane don kotoeno piseka more walipkaki, wele maine mi qekei. ");
INSERT INTO ons_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ŋo woune natne kepe kelokinerop eao ket kitokoi, ea yemo ŋei ŋerep natne eŋe Anutu wane don dere more, ma wet wekumaneŋo nogankau paki ma more qotkakoi, ea wane eŋe togole togoleenane wele maine qekei.” ");
INSERT INTO ons_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Pakiso, Yesuŋo koso rake, “Ŋei mane kiwa kuake more diao qeki okoreake? Lase bano me kulu papainane bano supakaki mesiake? Mida! Eŋe kiwake more qeki, zake kutno didiwo okoraki, ŋei ŋerep eŋe sari qelaŋanine ea maine kaikei so mat koto saikei. ");
INSERT INTO ons_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ea wane kine kine korop sane pamaike, ea na ŋado didiwo mawe wakon wareake. So kine kine natne supawe metmaike, ea ŋado na ma lalagewe didiwo wakon wareake. ");
INSERT INTO ons_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ŋine don kine kine korop detlukka more, don maine ea malip kaikei. Anutuŋo ŋei me ŋerep mane eŋe kine kine mane mangi, maine malipka geakeo, eŋe koso takotke maniake. Ŋo Anutu eŋe ŋei me ŋerep mane eŋe kine kine mane mi mangeo, yemo ŋei ŋerep yewa eŋe baŋ matalioniake.” ");
INSERT INTO ons_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Naso yewao, Yesu wane nagaine, eŋine so ŋolekoune maratkaikei wane sari lotkekoi, ŋo, ŋei ŋerep magu suaineŋo lewage qeatka watke more okorakoi, ea wane Yesu nagaine ŋole eŋe daleo osopka ari kau rap, ");
INSERT INTO ons_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ea wane ŋei mane magukoune eŋano ŋineŋo Yesu olale rake, “Ge onnom! Geŋane nagaŋone so ŋolekopŋone marat ganikei wane sari ziaŋmami.” ");
INSERT INTO ons_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesuŋo eŋane don mainge more magu edane rake, “Ŋei ŋerep diawa eŋe Anutu wane don dere more malipkau paki, tewek kaikeiwo, ŋei ŋerep ea eŋe naŋane nagane, so ŋolekopne okanmami.” ");
INSERT INTO ons_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Naso maneo, Yesu eŋe sekiwo wa more dokoine edane rake, “Ŋene sekiwo wa more doku namuŋ erinat yuane wa kitare ariŋem.” Yale raki, eŋe kieke arikoi. ");
INSERT INTO ons_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yesu eŋe kulu wane kaki, seki kutno kulu pake. Naso yewaka ikop mide, momo kakapa suaine wie puangi dibom suaine qeke, paki namuŋŋo wa more seki koto qakki ket watke ma muruŋ oniakane okange. ");
INSERT INTO ons_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dokoine eŋe Yesu wano ari ma wirikka rakoi, “Waomze, Waomze, ŋene mo seukenane okanmaine!” Yesuŋo wie more, togoleka kuroge, momo so dibom doŋ mane more kaloŋ qekeik wane etange. Paki momo so dibom ere doŋmangoik, so kaloŋ suaine qe pake. ");
INSERT INTO ons_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pakiso, Yesu eŋe dokoine edange, “Ŋine mali malip mida!” Ŋo eŋe oŋaene qaeki, so kaet suaine okane more, enŋene auye rakoi, “Ŋei iwa eŋe zok ŋei kine mane! Eŋe momo so dibom don etangi, ere yewaka done dere teweke more, doŋ manmamik.” ");
INSERT INTO ons_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kaloŋ okangi, Yesu so dokoine eŋe Galili namuŋ erinat ari lotkekoi, kepe yewa eŋetine, Gerasa. ");
INSERT INTO ons_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu eŋe seki qeliŋka more saweko ketki, yewaka ŋei mane asu qotkoineŋo kotino pake, eŋe sari maratkake. Mo naso kiroine ŋei yewa eŋe lawam ge more, mat koto mi doŋ mane metke me kulu pake, midakaka, eŋe deŋesere wane kezem aŋaino ge okange. ");
INSERT INTO ons_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Eŋe Yesu ka more, aroine suaine aroke ket Yesu wane kino rasu pa more bokake, “Yesu, ge Wawaine Anutu wane gipole! Ge dalino okan nanikene? Na ge meŋen ganmaile, ge na wikile zok misuk ninikene!” ");
INSERT INTO ons_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Eŋe yale rake, ea wane Yesuŋo asu qotkoine yewa olale rake, “Asu qotkoine, ge ŋei yewa qeliŋka arinom!” Mo sogino ŋei ŋerep eŋe ma more, kie metine mulap togoleŋo pisemaŋkoi, ŋo eŋe naso baŋem asu qotkoineŋo qeki, eŋe mulap togole kie metino ea romatkeki toeki, so kepe yaup papaino ari mageke. ");
INSERT INTO ons_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Wanemo, Yesuŋo qesonka rake, “Ge eŋetŋone ma?” Eŋe mainge rake, “Naŋane eŋetne, ‘Magu Suaine’ .” Asu qotkoine eŋe loutneŋo eŋane kotino gekoi, ea wane eŋe yalewa rake. ");
INSERT INTO ons_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ŋo asu qotkoine eŋe Yesuŋo esopongi sorao me gerepko mi kesikei wane meŋenkakoi. ");
INSERT INTO ons_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kepe yewao berek magu suaine eŋe meŋoine ea ŋara ne gekoi, ea wane asu qotkoine eŋe Yesuŋo esopongi, eŋe berek kotoeno wakesikei wane meŋenkakoi. ");
INSERT INTO ons_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Paki Yesu eŋe esopongi, so ŋei ea qeliŋka more berek kotoeno waketkoi, waketpi so, berek magu korop ea eŋe biririke ari sorao sontake ket doku namuŋgo qok qok ne more seukwarekoi. ");
INSERT INTO ons_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Berek ware ware eŋe kine kine wakonge, ea korop ka more, ket ari matko matko so kepe saiwo ŋei ŋerep don kisi edangoi. ");
INSERT INTO ons_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ŋei ŋerep eŋe don kisi ea dere more kine kine wakonge, ea ari kakoi, eŋe Yesu wano ari more, ŋei yewa kau, eŋe sogino asu qotkoineŋo matalikaki geke, ea eŋe mo maine laplap ramu more, wetine lotkeki tikŋane Yesu osino metke, ka more kaetonge. ");
INSERT INTO ons_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yesuŋo dalino ŋei ma menaŋkake, ea ŋei ŋerep eŋe ka more kimakopene edanwarekoi. ");
INSERT INTO ons_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ŋei ŋerep eŋe koropŋo kaet suaine onge, ea wane Yesu qesonka rakoi, eŋe eŋane kepeo ŋine qelige ariake. Yesu eŋe sekiwo wa more ea qelige arike. ");
INSERT INTO ons_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ŋei ea asu qotkoineŋo mo qeliŋkake, eŋe Yesu sorinka more rake, “Na maine weneŋ, detnannom gerop arikale?” Ŋo, Yesuŋo biraka more rake, ");
INSERT INTO ons_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ge matŋono ari, Anutu eŋe kine kine geŋano maki wakonmaike, ea wane ŋei ŋerep edanikene.” Yale olatkiso, ŋei eŋe Yesu qeliŋka more, Yesuŋo kine kine eŋano maki wakonge, ea wane ari mat suaino korop ŋei ŋerep edange. ");
INSERT INTO ons_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pakiso, Yesu eŋe koso doku namuŋ ratoke, erinat ariuso, ŋei ŋerep magu suaine eŋe mo sari qalakko tomaka okora more bakom kito more rakoi, “Mo sarimaine!” ");
INSERT INTO ons_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pakiso, ŋei mane, Yairus eŋe sari lotkeke, eŋe Yuda wane lewa lewaŋ urum yewao ŋei ŋetne okange, eŋe sari Yesu wane kino ket rasu more, Yesu eŋe matino ariakane meŋenkake, ");
INSERT INTO ons_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","onoka wane eŋane borasine wekuku, komaine 12 okange, eŋe seukeakane nasoine mo bomile sarike. Yesu eŋe ŋei yewa eŋerop ariuk, so ŋei ŋerep loutne eŋe watke lolika mogare arikoi. ");
INSERT INTO ons_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ŋei ŋerep magu keuno ŋine, ŋerep mane eŋe ŋerep zoma weneŋ. Zoma ea koma 12 zok manerop okankaki, so eŋe wesiine zoma yewa wane ra more mauluk mauluk eŋano biraki midakakae, ŋo eŋe maine mi ma menaŋkakoi. ");
INSERT INTO ons_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ŋerep ea eŋe magu keueno ŋine sari Yesu ŋadino lotke more, takotine suaine uwakaki, eŋane ŋerep zoma yewa mo ikopka mida leleke. ");
INSERT INTO ons_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pakiso, Yesu qesonone rake, “Maŋo na ua nanike?” Ŋei ŋerep koropŋo bisopkau, so Petoro eŋe olatke, “Waomze, ŋei ŋerep loutne edo wonge maguk ganbi, ge onoka wane don yaline qeson ŋonmaine?” ");
INSERT INTO ons_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ŋo, Yesu eŋe edane rake, “Ŋei ŋerep maneŋo na uanangi detmaile, ea wane naŋane zonomne natne wa ketmaike.” ");
INSERT INTO ons_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yesu eŋe ŋerep wane masi detlukki paki, ea wane ŋerep eŋe zok zonomine oreki, Yesu wane kino ket rasu more, ŋei ŋerep kaiteno eŋe Yesu mo uakeke, ea wane ikopka menaŋkaki edange. ");
INSERT INTO ons_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Rakiso, Yesu eŋe olale rake, “Borasone, malip malipŋoneŋo ma menaŋ ganmaike, ea wane ge maine ari more wet maepko gekene.” ");
INSERT INTO ons_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu eŋe ŋerep don olale okorake, naso yewaka ŋei mane Yairus wane matko ŋine lotke more, Yairus olale rake, “Ge borasoŋone mo seukmaike, kito ŋebo ŋeboze mi iwenka sarikene, yeine.” ");
INSERT INTO ons_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ŋo, Yesu eŋe detka more Yairus olale rake, “Ge misuk kaet gangep! Ge naŋane don dere more malipkaikeneo, maine mawe menaŋ kayake.” ");
INSERT INTO ons_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pakiso, Yesu eŋe matko lotke more, ŋei ŋerep ma waulukone more, Petoro so Yakop so Yohane so ŋerep ŋerep naga magaine eŋerop urumgo wa ketkoi. ");
INSERT INTO ons_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ŋei ŋerep korop zok manerop arokkoi, Yesu eŋe edane rake, “Ŋine misuk arokkei, ŋerep ŋerep mi seukmaike, eŋe kulu pamaike.” ");
INSERT INTO ons_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ŋerep ŋerep eŋe seukki, eŋe mo detlukkakoi, ea wane ŋei ŋerep korop eŋe Yesu tenikkakoi. ");
INSERT INTO ons_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ŋo Yesu eŋe ŋerep ŋerep seu seune ea wane metino ma more orake, “Medepne ge wienom!” ");
INSERT INTO ons_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ŋerep ŋerep yewa eŋe asuine koso ikopka sari takotkakiso, wisikae wieke, pakiso Yesu eŋe etane raki, naga magaine eŋe maine ŋara mangoik. ");
INSERT INTO ons_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ŋerep ŋerep wane naga magaine ea eŋe oŋaetne qaeke, ŋo Yesu eŋe togoleka etane rawetore more rake, “Kine kine iwa wakonmaike, ea ŋire ŋei ŋerep mane misuk edanikeik.” ");
INSERT INTO ons_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Naso yewao, Yesu eŋe dokoine 12 edora more qeduguongi, eŋe eŋine tungo maine asu qotkoine esopone more, zoma ŋei ma menaŋonikei wane zonom ebone more biraonge. ");
INSERT INTO ons_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Anutu eŋe dalino waremaike, ea Yesu eŋe dokoine ra qelaŋane, so zoma ŋei ma menaŋonikei wane done edange. ");
INSERT INTO ons_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Eŋe iwa yale edane rake, “Ŋine kine kine iwa yale misuk ma arikei, toka, numa kite, ŋara, wesi, takot mane. ");
INSERT INTO ons_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ŋine mat maneo ari lotke more, ŋei ŋerep qesononbi, edo raikei, maine iwa saket mere pa wie okanbi, mat yewa wane kotinoka mere pa wie okanikei. ");
INSERT INTO ons_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ŋo mat maneo edo ŋinane don mi dere more, ŋinerop mi mesikei wane rauso, ŋine mat yewa qelige more, kie ŋino nalek yewa saukkeu ket metkiso, eŋe masi ea ka more eŋe desikei, Anutuŋo mo eŋerop ŋaba okanmaike.” ");
INSERT INTO ons_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pakiso, dokoine eŋe matko matko ari more, mat louloutne eao biŋek don ra qelaŋane more, zoma ŋei ma menaŋongoi. ");
INSERT INTO ons_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Naso yewao, Yesu eŋe kine kine maki wakone arike, ea kepe ware ware Herot eŋe detware more, dere qeka okange, ea wane ŋei ŋerep natne eŋe Yesu wane rakoi, Yohane doku tau tauŋo mo wisikae wieke. ");
INSERT INTO ons_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ŋei ŋerep natne eŋe rakoi, Elaiya eŋe wakonge, ŋo ŋei ŋerep natne eŋe rakoi, Anutu wane qelit ŋei propet sogine gekoi, eŋano ŋine maneŋo wisikae wieke. ");
INSERT INTO ons_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ŋo, Herot eŋe rake, “Yohane doku tau tau ea mo sogine noŋo ebine kitatkole, ŋei iwa eŋe kine kine ma wakongi detmaile, eŋe ma?” Herot eŋe numa mane Yesu marat kayakane ziaŋkake. ");
INSERT INTO ons_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pakiso, Yesu wane dokoine eŋe mo matko matko ariwarekoi, eŋe zinge sariso, koso Yesu wano lewage more, don kisi urata kine kine makoi, so biŋek don magu edangoi, ea wane olatwarekoi. Olatpi qoekiso, Yesu so dokoine enŋeneka Betsaida matko arikoi. ");
INSERT INTO ons_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ariuso, ŋei ŋerep magu eŋe don dere more mogatone arikoi, eŋe Yesu wano ariuso, eŋe maratongiso, Anutuŋo dalino waremaike, ea Yesu eŋe edane more, zoma ŋei ŋerep ma menaŋonge. ");
INSERT INTO ons_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kepe zinge kere qoeakane okangiso, dokoine 12 eŋe Yesu wano sari olale rakoi, “Kepe iwa ŋei midaino, ge magu iwa edane biraonnom, eŋe mat osop mere arimami, yewao ari more, ŋara so kulu papa marat kaikei.” ");
INSERT INTO ons_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ŋo Yesu eŋe iwa yale edange, “Ŋido ŋara ebonikei!” Eŋe mainge rakoi, “Ŋei nau! Bret nigatne 5 so zawon etke pamami, ŋene maine ari magu suaine eŋane ŋara qolekene me? Ŋedannom desikene.” ");
INSERT INTO ons_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ŋei 5 tausen yewa metkoi. Yesu eŋe dokoine edane rake, “Ŋine ŋei ŋerep maguine maguine mapoke biraonbi, pese ket touk kutno metpi, magu weku ŋei ŋerep 50 okaniake.” ");
INSERT INTO ons_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dokoine eŋe ŋei ŋerep mapoke biraonbi qoekiso, ");
INSERT INTO ons_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu eŋe bret mete mane so zawon etke ma more qeliwo potki waki Anutu wane bakom kito more, bret so zawon ea mapoke more, dokoine ebongi, damo qe ŋei ŋerep magu yewa ebonwarekoi. ");
INSERT INTO ons_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Paki, ŋei ŋerep magu yewa eŋe korop neu ŋatene qe rokoponwareke. Pakiso, dokoine eŋe ŋara nekoi wane tutule ea qedugu more rosa 12 yale mau ket watke more metke. ");
INSERT INTO ons_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Naso maneo, Yesu eŋe Anutu meŋenkake, dokoine eŋe eŋano sari maratkau, so Yesu eŋe qesonone rake, “Ŋei ŋerep magu eŋe naŋane ma noramami?” ");
INSERT INTO ons_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eŋe iwa yale mainge olale rakoi, “Natne edo ge Yohane doku tau tau goramami, ŋo natne edo ramami, ge Elaiya, ŋo, natne edo ramami, Anutu wane qelit ŋei propet mo sogino gekoi, eŋano ŋine mane eŋe mo koso wisikae wieke.” ");
INSERT INTO ons_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yale rauso, eŋe koso enŋene qesonone rake, “Ŋo, ŋidom, yemo naŋane kine dalino ramami?” Petoroŋo mainge olale rake, “Ge Mesia! Anutuŋo biragange!” ");
INSERT INTO ons_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yale raki so Yesu eŋe edangi, eŋe Petoro wane don ea ŋei ŋerep mane maine mi edanikei wane rawetonge. ");
INSERT INTO ons_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Rawetone more, Yesu eŋe koso edane rake, “Ŋei Wawainane Gipole wikile suaine desiake. Yuda ŋei suaine, so mosop ŋei ŋetne so Anutu wane papa togon welaine ŋei, eŋe korop ŋadekka more nekuwi seukeake, ŋo kaiwe mama karewe yale pa more, koso Anutuŋo ma wirikkaki, koso wisikae wieake.” ");
INSERT INTO ons_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesuŋo dokoine korop edane rake, “Ŋine natne na mogat nanikei wane raso, ŋine ŋinŋine simileŋine ea korop mau ketwarekiso, ŋine wikile desikei wane teweke ariuso, eŋe na nekukei, yale waka ŋine ŋingukei. ");
INSERT INTO ons_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ŋei mane eŋe wikilane kaetkaki, solaine ma walukeakeo, eŋe gege wane numaine siuklukkeake. Ŋo ŋei mane eŋe naŋane ra more seukeakeo, ŋei yewa eŋe gege togon marat kayake. ");
INSERT INTO ons_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ŋei mane eŋe kepe aboŋ kine kine korop ma geake, ea eŋe seuke more, mane maine mi maratkayake, i midakaka! ");
INSERT INTO ons_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ŋei mane eŋe naso iwao ŋei ŋerep magu yewa eŋane keueno ŋine, eŋe nae so naŋane biŋek don rayakane gamu gamu okane geakeo, Ŋei Wawainane Gipole eŋe ŋado Magakŋo eŋine tungo birakaki, aŋelo magu eŋerop qeli qeliŋka more sarikei, naso yewao eŋe ŋei ea don koboine maine mi olasiake. ");
INSERT INTO ons_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na welekatne ŋidanmaile. Ŋine natne mi seuke more wisikaka gekau, Anutuŋo dalino waremaike, naso yewa ea wakongi kaikei.” ");
INSERT INTO ons_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Soda weku qoekiso, Yesu eŋe Petoro, Yohane, Yakop ebukiso, enŋeneka bonaga maneo meŋenkaikei wane wa arikoi. ");
INSERT INTO ons_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yewa meŋenkaki, Yesu wane kait tanikine qeinge more, kine mane okange, so lap lapine korop libe libe qe qelaŋane teine okange. ");
INSERT INTO ons_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Pakiso eaka ŋei etke ere wakonbik, so Yesurop don aukoi, yemo Mose so Elaiya wakonbik, so ");
INSERT INTO ons_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","erane qelaŋanetne suaine zok wakonge, mo sogine Anutuŋo Yesu wane ra more eŋe Yerusalem mat suaino seukeakane birakake, ea Mose so Elaiya so Yesu aukoi. ");
INSERT INTO ons_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petoro so kimatkine eŋe mo kulu pakoi, ŋo qelaŋan eaŋo ma wirikongi wie more, Yesu qelaŋanine so ŋei etke eŋerop okorakoi, ea ongoik. ");
INSERT INTO ons_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ŋei etke ere okora Yesu birakauk, Petoroŋo Yesu olale rake, “Waomze! Ŋene iwa metŋem wekumane zok okanmaike, yale wane, ŋene siluŋ maine seli kise karewe maikene! Mane geŋane, mane Mose wane, mane Elaiya wane.” Petoroŋo yaup rake. ");
INSERT INTO ons_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pakiso, eaka kezoŋ mane sari qekatongi, so kaetonge. ");
INSERT INTO ons_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kezoŋ koto don mane iwa yale rake, “Yewa naŋane medep! Eŋe don kine kine ŋidaniake, ŋine derelukkei! Ea wane na eŋe birakakole!” ");
INSERT INTO ons_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Don ea qoekiso, Yesu eŋineka okorake, dokoine eŋe ŋei ŋerep mane kine kine ea wakonge, mi ra qelaŋan ongei wane rake. ");
INSERT INTO ons_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Qaeki Yesu eŋine so dokoine karewe bonagao ŋine ket ari, magu suaine maratongoi. ");
INSERT INTO ons_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ŋei ŋerep magu keueno ŋine ŋei mane eŋe Yesu boka olatke, “Kito ŋebo ŋebonze! Na meŋen ganmaile, naŋane giponne qesiŋkanom! Eŋe naŋane giponne wekuku! ");
INSERT INTO ons_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Asu qotkoineŋo medep iwa wane kotino naso baŋem waket okanmaike, paki naso baŋem eŋe boka kito qotkoine zok okan ma geake, paki qise more, mekalekatine libeka aŋainoka saket qakki. Asu qotkoine eaŋo zok manerop matalika okanmaike, so eŋe birakayakane rokop mi okanmaike! ");
INSERT INTO ons_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Na geŋane dokoŋone edo asu qotkoine ea esop kaikei wane togogoleka meŋenonbe, ŋo eŋe ŋaŋaemami.” ");
INSERT INTO ons_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu eŋe don yewa dere more, ŋei ŋerep edane rake, “Ŋine korop malip malipŋine mida! Ŋine masi koboine mau, kuŋ qegoŋine okanmaike. Na naso darap ŋinerop gekale? Ma naso na umatŋine tewekale?” Yesu eŋe ŋei ea olale rake, “Ge medepŋone yewa naŋano ma sarinom.” ");
INSERT INTO ons_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Medepine eŋe sariki, asu qotkoineŋo qeki kepeo ket rasuke, Yesu eŋe kaki paki, asu qotkoine esopka more, medep ma menaŋka more, medep ea magainano birakake. ");
INSERT INTO ons_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ŋei ŋerep korop eŋe Anutu wane ewe zonomine suaine ea kau, oŋaene qaeke. Pakiso, Yesu eŋe kine kine maki wakongi, ŋei ŋerep eŋe oŋaene qaekiso aukoi. ");
INSERT INTO ons_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Naso yewao, Yesu eŋe dokoine edane rake, “Na kine kine iwa ŋidanmaile, misuk nigetŋuniake, ŋei edo Ŋei Wawainane Gipole ŋei ŋaba eŋane meteeno birakakei!” ");
INSERT INTO ons_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ŋo, dokoine eŋe don ea wane kine mi detlukkoi, Anutuŋo don ea wane kine motkeke, ea wane eŋe mi detluke more, koso qesonka detlukkei wane kaetongi dere qeka okane more yeine qeliŋgoi. ");
INSERT INTO ons_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Naso maneo Yesu wane dokoine eŋe iwa yale kieke don auye kitat nagu okangoi, “Tego iwa ŋenano ŋine maŋo ŋetneze okaniake.” ");
INSERT INTO ons_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu eŋe eŋane wet dereretene dere ka more medep, nigatne mane keueno ma more birakaki okorake. ");
INSERT INTO ons_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Pakiso eŋe dokoine edane rake, “Ŋei mane eŋe naŋane naŋane dereso, naŋane tungo medep nigatne iwa yale mapik kayakeo, eŋe na yalewaka mapik nane okanmaike. Ŋei mane eŋe na mapiknan okannmaikeo, eŋe Anutuŋo biranangi ketkole, ea eŋe yalewaka mapikka okanmaike. Ŋinane keuo ŋine ŋei mane eŋe ŋinane ketkele geakeo, eŋe ŋetne okanmaike.” ");
INSERT INTO ons_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pakiso, Yohaneŋo olale rake, “Waomze, ŋene kaŋem, ŋei maneŋo geŋane eŋetko ra, asu qotkoine esopkake, pakimo, ŋenane ŋadezo mi mogatŋone sarikimo, ŋene rawet kamaine.” ");
INSERT INTO ons_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesuŋo Yohane so dokoine natne edane rake, “Ŋine misuk rawet kaikei! Ŋei mane mi ŋaba ŋunmaike, ea eŋe ŋinane kimaŋine okanmaike.” ");
INSERT INTO ons_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Anutuŋo Yesu maki qeliwo wayake nasoine mo bomile sariki so, Yesu eŋe dereretine maki togoleki, Yerusalem mat suaino ariakane okange, ");
INSERT INTO ons_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","pakimo dokoine natne eŋe biraongi alakane arikoi, eŋe Samaria mat wane nat paromine mat mane yewao kine kine maulukkaikei wane biraonge. ");
INSERT INTO ons_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ŋo mat ea wane ŋeiine eŋe Yesu mateno mi wakesiakane onge, yemo iwa yale, Yesu eŋe Yerusalem mat suaino ariakane okange, ea wane ŋei ŋerep eŋe Yesu mi qesiŋkaikei wane, ra wetkakoi. ");
INSERT INTO ons_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pakiso, Yesu wane dokoine Yakop so Yohane ere masi ea wane detpik mi menaŋgi olale rakoik, “Waomze, ŋere Anutu maine meŋenkate, eŋe ŋei ŋerep ea gerepŋo matalioniake me?” ");
INSERT INTO ons_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu eŋe erano zinge ra wetotkiso, ");
INSERT INTO ons_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yesu eŋine so dokoine eŋe mat ea qelige koso mat mane maneo arikoi. ");
INSERT INTO ons_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesu eŋine so dokoine Yerusalem arikei wane numao arikoi, ariu ŋei mane eŋe sari Yesu olale iwa yale rake, “Ge mat yewao me yewao arikeneo, na weneŋ mogat ganikale.” ");
INSERT INTO ons_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu eŋe mainge rake, “Tengo eŋe giweo pamaike, so naŋi eŋe matino pamaike. Ŋo, Ŋei Wawainane Gipole, eŋe yemo mat urum papaine midaine.” ");
INSERT INTO ons_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu eŋe ŋei mane olatke, “Ge na mogat nannom!” Ŋo ŋei eaŋo rake, “Waomne, alakane na matno zinge magane dukka more, sari mogat ganikale.” ");
INSERT INTO ons_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesuŋo mainge rake, “Ŋei eŋe gege togon mida, eŋe maine ŋei seu seuneŋo seu seune dukkaikei. Ge Anutuŋo dalino waremaike, ea goŋo ari ŋei ŋerep ra qelaŋan onikene.” ");
INSERT INTO ons_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ŋei mane eŋe Yesu iwa yale olatke, “Na ge mogat ganikale, ŋo ge maine na bira nannom alakan ari weŋem sotakne maulukone more, sari mogat ganikale.” ");
INSERT INTO ons_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ŋo, Yesu eŋe mainge olale rake, “Ŋei maneŋo seki wane wiliŋa mayake, ŋo, eŋe zinge ŋadino pot okanmaikeo, ŋei yalineŋo Anutu wane urata maine mi wareake so mayake.” ");
INSERT INTO ons_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pakiso, Yesu eŋe eŋine baŋ mat suaine me nigatne ariwareke, ea ŋei natne 72 ma wakonone more, eŋe etkeka etkeka alakane matko matko arikei wane biraonge. ");
INSERT INTO ons_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","So eŋe eŋine dokoine ea edane rake, “Euo ŋara loutne mo wele more posimaike, ŋo ŋara wele mama wane so pei peik wane urata ŋei yemo loutne midakaka, ea wane ŋei eŋe dalino ŋara wele peikwarekei? So ea wane ŋine ŋara wele mama wane meŋenkau, ŋara eu welaine oŋom urata ŋei ŋara wele peikkei wane ma wakone biraoniake. ");
INSERT INTO ons_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ŋine ariu! Na ŋine kasi qotkoine eŋane keueno boriŋunmaile, ");
INSERT INTO ons_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ŋine kine kine iwa yale misuk maikei, wesi me numa kite me kie kawet. Ŋine dumao ari ŋei ŋerep korop maratone mo kaiwe maine me sakoka rarapko yau yaup misuk edanikei. ");
INSERT INTO ons_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Naso maneo ŋine urum mane waikei wane, ari more alakane mat welaine edanikei, ‘Mat iwa wane kotino ŋei ŋerep ŋinano peamŋo payake!’ ");
INSERT INTO ons_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ŋei peamine maneŋo urum yewa geki, ŋinane peam don ea maine eŋano payake. Ŋo, ŋei peamine maneŋo urum yewa mi geki, ŋinane peam don ea yeine koso ŋinŋino zingeake. ");
INSERT INTO ons_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ŋine urum me mat peamine ea wekuoka mesikei, mat welaine eŋe ŋine kine kine ŋibonbi maine nekei. Onoka wane? Ŋo urata ma more lewine ŋei eŋe maine mayake. Urum weku yewa wane kotinoka mesikei. Ŋine urumgo urumgo misuk lolike gekei. ");
INSERT INTO ons_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Naso maneo ŋine mat suaine maneo ari lotke more, ŋei ŋerep qesononbi edo raikei, maine iwa saket mere pa wie okanbi, mat yewa metpi, so eŋe ŋara kine kine ŋibonbi nekei. ");
INSERT INTO ons_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mat yewao ŋine zoma ŋei ma menaŋone more, iwa yale edane raikei, ‘Anutuŋo dalino waremaike, ea mo ŋinane osoŋino lotkemaike.’ ");
INSERT INTO ons_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ŋo, ŋine mat mane edo ŋinane don mi dere more ŋinerop mi mesikei wane rauso, ea ŋine duma keuno okora iwa yale edanikei, ");
INSERT INTO ons_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ŋere mat wane nalek kieso ŋine saukete ketkiso, ŋine masi iwa ka more iwa yale desikei, ŋene masi iwa okanŋem mo Anutuŋo ŋinerop ŋaba okanmaike, ŋo, ŋine dere detsoroke detluke detpi, Anutu wane qeli ewe zonom so qeli qelaŋan, ea mo ŋinane osoŋino lotkemaike.’ ");
INSERT INTO ons_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na wet qelot ŋidanmaile, naso kutno, Anutuŋo ŋei ŋerep korop wanok oniake, naso ea Anutuŋo Sodom ŋei ŋerep borikine wikile nigatne eboniake, ŋo, ŋei ŋerep eaŋo ŋinane don mi detkoi, yemo Anutuŋo eŋe wikile zok manerop eboniake!” ");
INSERT INTO ons_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesu eŋe koso rake, “Korazin mat wane ŋei ŋerep ŋine qom borikine zok, so Betsaida mat wane ŋei ŋerep ŋine yaleka qom borikine, Yuda ŋei ŋerep eaŋo naŋane masi togole ka more, wet dereretene mi maingekoi. Tire mat so Sidon matko, ŋei ŋerep eŋano naŋane masi togole yale ŋei maneŋo mane maki rap, yemo eŋe yalewaka qom borik okane, ea ka more, kaura betŋo takot biraone more so zepe solaeno tau metpi rap. Masi yewa yale eŋe ŋei ŋerep korop sikanonikei, mo eŋe soteenane qom borik maratka more sotene ea ŋadekkamami. ");
INSERT INTO ons_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Naso kutno, Anutuŋo ŋei ŋerep korop wanok oniake, Tire mat so Sidon mat ŋei ŋerep ea wikile nigatne eboniake, ŋo, ŋine Korazin so Betsaida Yuda welaine, Anutuŋo baŋ wikile zok manerop eboneake. ");
INSERT INTO ons_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ŋo Kaperneam welaine, ŋine wamo Anutuŋo ŋibuki qeliwo wa arikei me? Midakaka, Anutuŋo ŋine gerep sorao biraongi kesikei.” ");
INSERT INTO ons_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu eŋe dokoine koso edange. “Ŋei maneŋo ŋinane don desiakeo, eŋe naŋane don desiake. Ŋei maneŋo ŋinane don waulukeakeo, eŋe naŋane don waulukkeake. Eŋe na wauluk naniakeo, eŋe Anutuŋo biranange ketkole, eŋe waulukkeake.” ");
INSERT INTO ons_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ŋei 72 eaŋo Yesu wano zinge arikoi so bakom kitokoi, so Yesu olale rakoi, “Waomze! Ŋene masi togole kine mane kine mane makone, so asu qotkoine yale waka eŋetŋone edane more, esoponŋem arikoi!” ");
INSERT INTO ons_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu eŋe eŋane don mainge rake, “Mo sogino na Satan eŋe qeliwo ŋine ketki kakole! ");
INSERT INTO ons_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Detpi! Na ŋine naŋane tungo biraŋune, so naŋane zonom ŋibonbe mo mawarekoi, ea wane ŋine koma so wame golaŋ maine kutene gesokei, eŋe maine ŋidotpi mi seukkei, ŋine ŋabaze Satan eŋane zonomine maine korop yuankaikei. Ŋei ŋerep me osom me kine kine wakoniake, eaŋo ŋine maine mi matali ŋuniake. ");
INSERT INTO ons_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","So ŋine asu borikineŋo donze mo dere tewekmaike, yale rau paki, mawa mawaine me batneka misuk okanikei. So yale mida. Ŋine eŋetŋine mo qeliwo, Anutuŋo gege togon wane papiao qeke, ea wane yemo maine ŋine batne okanikei.” ");
INSERT INTO ons_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Naso yewao, Asu Koboboineŋo Yesu wane kotino watke rokopkaki so bakom suaine kito more rake, “Magak! Ge qeli so kepe wane Waom okanmaine! Na dage golatmaile, ge ŋei kibi urum mi gekoi, eŋane dereretene medep nigatne yale, ea geŋone masi so kineŋo sikanon okanmaine. Ŋo, ŋei dereretene wawaine so suaine ea geŋone kine so masi tanikŋone, ea mi sikanone more moton okanmaine. O, Magak, masi ea yemo ge geŋone simile so dereretŋonane okan okanmaine. ");
INSERT INTO ons_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Magak, eŋe na kine kine korop ninwareke. Ŋei maneŋo Anutu wane Gipole mi detlukkamaike. Magak Anutu eŋe oŋom eŋineka Gipole detlukkamaike. Ŋei maneŋo Magak Anutu mi detluk kamaike. Anutu wane Gipole eŋe oŋom eŋineka Magak detluk kamaike. Ea wane Anutu wane Gipoleŋo ŋei mane eŋe eŋane simile kaki, eŋe maine Magak sikan kayake.” ");
INSERT INTO ons_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pakiso, Yesu eŋe dokoine eŋano zinge more, eŋe enŋeneka edange, “Kine kine iwa wakongi kamami, ea ŋei eŋe kaikei, yemo ŋei eŋe bakom suaine kitokei, ");
INSERT INTO ons_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ŋo Anutu wane qelit ŋei propet so King loutne sogino gekoi, eŋe kine kine iwa ŋine kamami, ea kaikei wane onge, ŋo eŋe mi kakoi, eŋe ŋaŋaekoi. Kine kine iwa wakongi, ŋine detmami, ea eŋe desikei wane okangoi, ŋo eŋe ŋaŋaekoi so mi detkakoi.” ");
INSERT INTO ons_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Naso maneo, Anutu papa togon welaine ŋei mane, Skribe, eŋe Yesu wano ari liwek kayakane okange, so iwa yale qesonkake, “Kito ebo ebon, na daleo okane more gege togon maikale?” ");
INSERT INTO ons_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu eŋe mainge qesonka rake, “Anutu wane papiao ra rokop donŋo daleo ramami? Ge papia ea mane dapore detlukka ra qelaŋanmaine?” ");
INSERT INTO ons_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ŋei ea eŋe don mainge olale rake, “‘Ŋine wet dereretŋine korop so oŋa oŋa ŋine korop so zonomŋine korop Waom Anutuŋine eŋane simin ŋungi ma qotkau!’ so ‘Ŋine ŋidomka wetŋineŋo ma qotnagu gekei, yale waka ŋei ŋerep korop wetŋineŋo ma qotonikei.’” ");
INSERT INTO ons_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu eŋe mainge rake, “Ge koboboine ramaine, ge kine kine ea makoboe more, gege togon marat kaikene.” ");
INSERT INTO ons_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ŋo, Anutu papa togon welaine ŋei eaŋo eŋine eŋetine ma wa nagu Yesu qesonkake, “Ŋene ŋei ŋerep wetzeŋo ma qotonikene, ea eŋe ma?” ");
INSERT INTO ons_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu eŋe iwa yale don kisi mane mainge rake, “Naso maneo, ŋei mane eŋe Yerusalem mat suaine qelige more, Yeriko matko ariakane ariki, so kobu ŋei natneŋo qe more, laplapine ra barake qeliŋkau, seukeakane okange. ");
INSERT INTO ons_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Paki naso yewao, Anutu wane mosop ŋei, pris mane eŋe ari kaki ŋei ea numao pake, ŋo eŋe yuanka more wazaino duma natka ket arike, ");
INSERT INTO ons_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","yale waka, ŋei mane Lewi tegoo ŋine dumao ket more, ŋei ea ka more, duma natka ket arike. ");
INSERT INTO ons_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ŋo ŋei qelaŋ Yuda ŋadino ŋine mane eŋe Samaria matko ŋine sari, ŋei ea kaki paki, qomine borike, ");
INSERT INTO ons_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","eŋe eŋano ari more, kubetine kelok so wainŋo sauke more, laplapŋo piseke, pakiso eŋe ŋei ea horsi kutno more more, lobo urum maneo iwenka ari warekake. ");
INSERT INTO ons_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Qaeki, eŋe wesi silwa etke ma more, lobo urum ware ware mane more olatke, ‘Ge ŋei ea warekaikene, na mat maneo ari urata ma more, iwa zingekale, ge eŋane ra more, aboŋ so ŋara koso takotke qolekene, ea na iwa zinge sari maine qole ganikale.’” ");
INSERT INTO ons_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesuŋo don kisi iwa raki qoekiso, eŋe koso Anutu papa togon welaine ŋei ea qesonka rake, “Ge ranom detpe, kobu ŋei eŋe ŋei qekoi, ŋei ea eŋane kimaine ma? Pris me Lewi me ŋei qelaŋ Samaria matko ŋine?” ");
INSERT INTO ons_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Anutu papa togon welaine ŋei eŋe mainge rake, “Samaria qelaŋ ŋei, eaŋo eŋe qesiŋkake.” Yesuŋo eŋe olale rake, “Ge ari eŋane masi mogat kaikene.” ");
INSERT INTO ons_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pakiso, Yesu eŋine so dokoine eŋe numaene arikoi, arimage mat maneo lotkeu, so yewao ŋerep mane, eŋetine Marta, oŋo marat one more yai ososok okanone more iwenongi matko waketkoi. ");
INSERT INTO ons_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Eŋe qaine mane, eŋetine Maria eŋe Yesu wane kino pese ket mere don miti rake, eŋe ea mere eŋane don raki detke. ");
INSERT INTO ons_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta eŋe urata suaine maki paki, dere mezet okange, pakiso Yesu wano ari olale rake, “Waomne, qaneŋo mi qesiŋnangi, naeka zok urata suaine mamaile, ea mi kamaine me? Ge olatnom sari qesiŋ nangep!” ");
INSERT INTO ons_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Waomŋo mainge olale rake, “Marta, Marta! Ge umat kine kine loutne ea wane zok dere mezet okanmaine. ");
INSERT INTO ons_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ŋo, ge kine kine weku ea wane, yemo niget ganmaike. Mariaŋo yemo yeye weku mane ea wane wetkemaike, wane mo ŋei maneŋo eŋano ŋine maine mi omakayake.” ");
INSERT INTO ons_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kaiwe maneo, Yesu eŋe maneo ari more meŋenkake. Meŋenkaki qoekiso, dokoine eŋano ŋine maneŋo Yesu olale rake, “Waom, Yohaneŋo dokoine kito ebonge, ge yale kito ŋebonnom ŋene meŋenkaŋem.” ");
INSERT INTO ons_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesuŋo edane rake, “Ŋine iwa yale meŋenkaikei, ‘Magaze, geŋane eŋetŋone koboboine mawakaikene, koto baŋem kepe baŋem Waom okan ŋonnom, ");
INSERT INTO ons_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kaiwe baŋem ŋara zuaŋ geŋem, ge ŋebonikene. ");
INSERT INTO ons_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Borikinezane turuŋ qeliŋ genom. Ŋene yalewaka ŋei borikine okan ŋonmami, eŋane turuŋ qeliŋmaine. Satanŋo ŋene liwek ŋonmaike, ge mapik ŋonikene.’” ");
INSERT INTO ons_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pakiso, Yesuŋo dokoine edane rake, “Ŋinano ŋine maneŋo ruo banino kimainane matko ari more, ma wirikka more olale rayake, ‘Kima, bret karewe ninnom, ");
INSERT INTO ons_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","naŋane kimane mane numa gemage sari naŋano lotkemaike, pakimo, na eŋane ŋara mane mi motpe metmaike!’ ");
INSERT INTO ons_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pakimo kimaŋone eŋe mat kotoka mere rayake, ‘Ge de ma wirik mi okan ŋonnom! Madet mo kito more, mo nae so ŋanom medewekopne ŋene mo papazo pawaremaine, na maine mi wie more kine kine ginikale.’ ");
INSERT INTO ons_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pakimo daleo? Na ŋidanbe detpi, mat welaine eŋe kima kima wane wie more bret mi giniake, yemo eŋe siluŋ aŋa sorinŋonane wie more, kine kine zuaŋmaine, yewa giniake. ");
INSERT INTO ons_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ea wane na ŋidanbe detpi, Anutu meŋenkau, kine kine ŋiboniake, ma zuaŋ okane more, wele maratkaikei, madetko yatou lalage ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Meŋenka okanmaikeŋo kine kine mayake, ma zuaŋ okanmaikeŋo wele kayake, madetko yatomaike, eŋe lalage maniake. ");
INSERT INTO ons_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Me ŋinano ŋine mane eŋe gipoleŋo zawon wane raki, koma qotkoine maine mi maniake. ");
INSERT INTO ons_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Me tiak wounane raki, wame golaŋ maine mi maniake. ");
INSERT INTO ons_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pakimo, ŋine ŋei bori worine yalineŋo gipon borasokop ŋine ŋara aboŋ mai maine ebone, gumeon okan okanmami, ŋo Magak qeliwo rokop mane gemaikeŋo meŋenka okanmami, eŋe Asu Koboboine ŋiboniake, ako bakom yemo zok manerop okan okanmaike!” ");
INSERT INTO ons_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesuŋo ŋei mane asu qotkoineŋo kotino ketki, done midaine geke, eŋane kotino ŋine asu qotkoine yewa esopkaki saket arike. Arikiso, ŋei yewa eŋe kieke more don rake, pakiso ŋei ŋerep magu suaine eŋe ka more oŋaene qaeke. ");
INSERT INTO ons_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pakiso, ŋei natne eŋe Yesu wane rakoi, “Eŋe Belzebul, asu qotkoine eŋane ŋetneene, oŋo zonom mangi, asu qotkoine yewa esopongi saketmami.” ");
INSERT INTO ons_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ŋo ŋei natne eŋe liwekka more, eŋe weleka Anutu wane urata mamaike me daleo kine ea ma wakongi, kaikei wane so raki, qeliwo masi tanik mane wakoniakane olatkoi. ");
INSERT INTO ons_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Eŋe yale okanbiso, Yesuŋo wetenane kine dere more edane rake, “Kepe mane eŋe mapok nagu maguine maguine ari edomka kawali yakuwi, mi kirowoniake. Weŋem sotak eŋe edomka mapok nagu more, wiriu etke okaniake. ");
INSERT INTO ons_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ŋo, Satan wane magu eŋe mapoke magu etke okane more, edomka kawali yakuwik, urataine daleo togole more payake? Pakimo, ŋine naŋane ramami, eŋe Belzebulŋo zonom mangi, asu qotkoine yewa esop onmaike. ");
INSERT INTO ons_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na Belzebulŋo welekatne zonom ningi, asu qotkoine yewa esopongaleo, yemo ŋinŋine dokoŋine eŋe maŋo qesiŋongi, asu qotkoine yewa esop onmami? Ŋinŋine dokokop ŋine edo kine ŋine ma wakon onmami, yemo ŋine sot okanmami! ");
INSERT INTO ons_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mida! Na yemo Anutu wane zomongo asu qotkoine yewa esopon okanmaileo, Anutu wane Waom qeli ewe zonomine so gege togon numa mo ŋinano sarimaike. ");
INSERT INTO ons_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Pakimo, ŋei togole mane eŋe tebe koakine ma more, eŋine matinane diamine ma warekaki, aboŋ kine kineine maineka payake. ");
INSERT INTO ons_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ŋo, siluŋ ŋei togogole maneŋo sari ge more yuankaki paki, tebe koakine kawali wane aboŋ yewa korop omakaware more, ŋei natne matoke eboniake. ");
INSERT INTO ons_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ŋei mane eŋe kima mi okan naniakeŋo, eŋe ŋaba okan naniake. Ŋo ŋei mane eŋe qesiŋnane more, lama mi qeturaŋ ŋoniakeŋo, lama esopongi, yau yaup ariwarekei. ");
INSERT INTO ons_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Asu qotkoine maneŋo ŋei mane wane kotino ŋine sakesiake, saket more ari kepe yaup papaino mat mane maratka ma mere kito okanbe ra, mat wane zuage arike, ari mageki boriki, oŋomka iwa yale rayake, ‘Na koso matne qelige sarile, yewao zinge ariwe.’ ");
INSERT INTO ons_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yale raki pakimo, koso zinge ariake, ari kakimo, mat yewa mo sino kito maulukwareu, dun dun payake. ");
INSERT INTO ons_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Pakimo, eŋe koso zinge ari more, asu zok qotkokoine sewen(7), eŋine yale mida, eŋe zok bori worine, eŋe ebuki sari mat wekuoka mere kito okangei. Pakimo, ŋei yewa eŋe alakan nigatnemde borike, wane naso yewao yemo zok manerop borilukmaike.” ");
INSERT INTO ons_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu eŋe don yale ra okorakiso, ŋei ŋerep magu suaine eŋane keueno ŋine ŋerep maneŋo boka woka olale rake, “Ŋerep pa geu more, ŋamu gumegange, eŋe oi bakomŋone okaniake!” ");
INSERT INTO ons_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Rakiso, Yesuŋo olale rake, “Mida! Ŋei ŋereppa Anutu wane don dere more, tewek okanmami, edo maine oi bakomine okanikei!” ");
INSERT INTO ons_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ŋei ŋerep magu suaine eŋe Yesu wano sari watke metpi, Yesuŋo iwa yale edange, “Naso iwa wane ŋei ŋerewekoune eŋe ŋei ŋerep qotkoine! Eŋe masi togole kaikei wane qeson okanmami. Ŋo, na masi togole mane mi sikanonbe kaikei, weku Yona wane masi togole eamo sikanongale. ");
INSERT INTO ons_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Numa yewaka, Anutu wane qelit ŋei, Yonaŋo Niniwe matko ŋei ŋerep magu eŋane qakaene okange, ŋo naso iwao ŋei ŋerep magu gemami, ŋinane qakaŋine yemo, Ŋei Wawainane Gipole okanmaike. ");
INSERT INTO ons_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wano wanok nasoo, yemo qelaŋ ŋerep waom Seba kepe nat paromine raiwo okenŋine, oŋo ŋei ŋerep magu naso iwao gemami, eŋerop wie okora more kine ŋine tilekeake. Onoka wane, ŋerep yewa eŋe kepe nat paromine lolike sari more, ket more Solomon wane dereret wele yewa detke. Ŋo kine kine maneŋo Solomon manerop yuankamaike, yemo iwa na ŋidanmaile. ");
INSERT INTO ons_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wano wanok nasoo, Niniwe matko ŋine qelaŋ ŋei ŋerep eŋe boaŋ wie okora more, naso iwao ŋei ŋerep gemami, eŋerop kineene tilekkei. Niniwe ŋei ŋerep eŋe Yonaŋo don edangi, dere more borikineene qelige more wetene maingekoi, ea wane. Ŋo, na ŋine ŋidanmaile, kine kine mane iwa, yewaŋo yemo Yona manerop yuankamaike!” ");
INSERT INTO ons_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Mane eŋe lam kiwake more, kine kine qekatno mi motki okora okanmaike, me laseŋo mi kito kurauki met okanmaike. Mida! Eŋe zake kutno kitoki, mere mat kotino qelaŋangi, ŋei eŋe qelaŋan yewa ka more mat koto maine wa okanmami. ");
INSERT INTO ons_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Deŋone yewamo wet so solaŋonane kiwaine, deŋone maine mesiakeo, wet so solaŋone yewa korop qelaŋanŋo wakesiake, ŋo, deŋone borimaike, yemo wet so solaŋone eamo korop panaman kitomaike, ");
INSERT INTO ons_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ea wane ge kotoŋono qelaŋan pamaike, yewa panaman kitoyakane diamine maikene. ");
INSERT INTO ons_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ge wet so solaŋone korop yewa qelaŋanŋoka rokopke paki, wet so solaŋone sisine mane mi panaman kitomaikeo, yemo wet so solaŋone yewamo korop lam wane qelaŋane yale qelaŋan wareake.” ");
INSERT INTO ons_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu eŋe don raki qoekiso, Parisi maneŋo ŋara eŋerop neakane newankake. Pakiso, Yesu eŋe ari eŋerop zakeo metkoik. ");
INSERT INTO ons_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yesu eŋe metine mi sau sauk, ŋara zakeo wa mere ŋara nekoik wane Parisiŋo kaki mi menaŋge. ");
INSERT INTO ons_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pakiso, Waomŋo olale rake, “Parisi ŋine laseŋine so kapŋine solaineka sauk okanmami, ŋo, kotoŋino yemo kobu, bailalaŋ, so borikineŋo watke pamaike. ");
INSERT INTO ons_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ŋine qelaŋ ŋei! Anutu eŋe kine kine solaineka make, ŋo, kotino wa mo weneŋ mi make me? ");
INSERT INTO ons_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ŋine siluŋ lase ŋine so kap kine ŋine kotino metmaike, yewa aboŋene midaine, eŋe ebonwarekeiwo, yemo ŋinano kine kine korop Anutu wane kaitko libe qewareake. ");
INSERT INTO ons_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Yai, Parisi, ŋine kaet ŋungep me? Ŋine kine kine yauwine siweŋ arerewa, garem kumusi so zaguk natne 10, yewa ŋine mane Anutu man okanmami, ŋo kine kine wele ra makoboe, so wetŋo Anutu malipka malipka, yewamo mi okan okanmami. Ŋine iwa okanbi paki, mane wa weneŋ okangeiwo, yemo manageake. ");
INSERT INTO ons_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Yai, Parisi, ŋine kaet ŋungep me? Ŋine Yuda lewa lewaŋ urumgo kito metmet lewine ŋei ŋerep kaitkoka mesikei wane ra okanmami, so sobeŋ suaino ŋei ŋerep edo ŋune more mawa ŋunikei wane wetŋine suaine pamaike. ");
INSERT INTO ons_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yai, Parisi, ŋine kaet ŋungep me? Ŋine deŋesere mane zariŋine midaine, ŋei ŋerep eŋe mi dereret keuoka gesoke arimami, yale.” ");
INSERT INTO ons_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesuŋo yale rakiso, Anutu wane ra rokop don welaine ŋei, Skribe, maneŋo olale rake, “Kito ŋebo ŋebon, ge don yewa ranom ŋene weneŋ ŋengumaike!” ");
INSERT INTO ons_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pakiso, Yesuŋo mange olatke, “Yai, Skribe ŋine weneŋ kaet ŋungep me? Ŋine aboŋ umatne suaine ŋei ŋerep eŋane kuteno motpi, edoka urata suaine tewek okanmami, ŋo ŋidom meteŋine mane bira more, aboŋ umatne yewa mi qesiŋone tewe okanmami. ");
INSERT INTO ons_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yai, Skribe, ŋine kaet ŋungep me? Ŋabokopŋine eŋe Anutu wane qelit ŋei engu matali okan onwarekoi, ŋo ŋine propet eŋane deŋesereene kibi ma okanmami. ");
INSERT INTO ons_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ŋine yale okane more, ŋabokopŋine masi qotkoine okangoi, ea wane detpi menaŋ okanmaike, yewa ŋidomka ŋei ŋerep sikan onmami, ŋabokopŋine eŋe Anutu wane qelit ŋei enguwi seukkoi, ŋo ŋine deŋesereene kemgo maulukkoi. ");
INSERT INTO ons_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kine yalewa wane, Anutuŋo mokaka Anutu wane qelit ŋei eŋane weteno motki, don iwa yale qekoi, ‘Na boaŋ eŋano qelit ŋei so aposolo biraonbe arikei, pakimo eŋe boaŋ natne engukei, ŋo natne engu esoponbi arikei.’ ");
INSERT INTO ons_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pakimo, mokaka qeli so kepe kito epotke, yewao ŋidoka Anutu wane qelit ŋei engu sakoi, ea wane turuŋine eamo ukude naso iwao ŋei ŋerep gemami, eŋano makok keake. ");
INSERT INTO ons_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mokaka, Abel seukke, yewa ŋine sari mage Zekaraia, eŋe Anutu wane zake so Anutu wane Urum Kobekine, yewa wane keuetno qeu seukke. Na welekatne ŋidanbe detpi, kawali yewa qe sarikoi, ea wane turuŋine eamo ukude naso iwao ŋei ŋereppa gemami, ŋinano korop makok wareake! ");
INSERT INTO ons_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Yai, Skribe, ŋine kaet ŋungep me? Ŋine dereret urum madetine qeko qekok wane kiine ma waluke magemami, ŋine ŋinŋine eamo madet lalagimi waket okanmami, pakiso, ŋei ŋerep natne edo wakesikei wane okanbiso, ŋine leŋon okanmami!” ");
INSERT INTO ons_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pakiso, Yesu eŋe mat qelige erinat waketke, waketkiso, Anutu papa togon welaine ŋei, Parisi so Skribe eŋe Yesu solaino qe more don gereune rakoi, so qeso qeson loutne qesonka liwekkakoi. ");
INSERT INTO ons_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Liwekka more aŋaineŋo don mane ra mataliki ka more dongo birakaikei wane lom kiririŋ makoi. ");
INSERT INTO ons_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ŋei ŋerep magu suaine tausen yalewaŋo sari lewage more, esosop nagu kieeneŋo rakukum nagukoi. Pakiso, Yesuŋo mikepka dokoine edane rake, “Ŋine Anutu papa togon welaine ŋei, Parisi, eŋane don kelokenane diam maikei, isisienane ramaile. ");
INSERT INTO ons_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kine kine kaweunerop pamaike, yewa mo boaŋ kaweune lalage didiwo wakon wareake. Ŋo kine kine sane pamaike, yewa mo boaŋ didiwo wakongi detka warekei. ");
INSERT INTO ons_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yalewa wane mo, ŋine don kine kine sanka panaman koto ra okanmami, yewa mo boaŋ kaiwe suaino wakongi desikei, ŋo, ŋine urum koto mere more don kine kine saŋepka rau, ŋei ŋerep keteno ket okanmaike, yewa mo boaŋ mat sobego okora ra suakei.” ");
INSERT INTO ons_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Kimakopne, na iwa yale ŋidanbe, ŋine solaŋine qeu seukeake, ŋo siluŋ ea wane ŋadino kine kine natne umatne maine mi okanŋungei, ŋei yewa eŋane misuk kaet ŋuniake. ");
INSERT INTO ons_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Na ŋei weku sikan ŋunikale, eŋane yemo kaet ŋuniake, Anutu wane kaet ŋuniake, eŋe kepe sola qeki seukki, ea wane ŋadino oŋa oŋa gerep sorao birakaki kesiakane zonom weneŋ ma gemaike. Na welekatne ŋidanmaile, eŋane kaet ŋuniake! ");
INSERT INTO ons_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Naŋimde nigatne mete mane yewa wesi takitne etkeŋo mi qole okanmami me? Pakimo eŋano ŋine mane Anutuŋo eŋane mi nigetka okanmaike. ");
INSERT INTO ons_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ŋo, ŋinane leweŋine zounane zaleine yemo mo dapotwareke, ea wane ŋine misuk kaet okangei, ŋinane leweŋineŋo yemo wawaine, naŋi nigatne eŋane lewetene yuankamaike!” ");
INSERT INTO ons_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Koso mane ŋidanbe, mane eŋe ŋei ŋerep eŋane kaitko, naŋane eŋetne ra wakoniake, Ŋei Wawainane Gipoleŋo yalewaka Anutu aŋelokoune eŋane kaiteno eŋetine ra wakoniake. ");
INSERT INTO ons_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ŋo, ŋei mane eŋe ŋei ŋerep eŋane kaitko na bisop naniake, eŋe Ŋei Wawainane Gipoleŋo yalewaka Anutu aŋelokoune eŋane kaiteno bisop kayake. ");
INSERT INTO ons_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ŋei mane eŋe Ŋei Wawainane Gipole don borikine olasike, eŋe Anutuŋo sot turuŋine qeliŋka niget kayake, ŋo ŋei mane eŋe Asu Koboboine don borikine olasiake, eŋe Anutuŋo sot turuŋine yewa mi qeliŋka niget kayake. ");
INSERT INTO ons_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ŋo ŋaba eŋe ŋibu ari more, Yuda wane lewa lewaŋ urumgo, me ware ware eŋano, me ŋei waom eŋano, dongo biraŋunbi, don daleo raikei ra more dere mezet misuk okanikei. ");
INSERT INTO ons_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Naso yewao don raikei, yewamo Asu Koboboineŋo kito ŋiboniake.” ");
INSERT INTO ons_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ŋei ŋerep magu eŋane keueno ŋine ŋei maneŋo Yesu olale rake, “Kito ŋebo ŋebon, tatneŋo magasane mete zamot yewa bonep magemaike, ea wane ge olatnom natne na matoke niniake.” ");
INSERT INTO ons_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesuŋo olale rake, “Ŋeiwae, maŋo na ŋinane wano wanok ŋei bira nangane, ŋinano wano wanok urata maikale, me etke ŋirane aboŋ keuoka mapoke ŋiponikale?” ");
INSERT INTO ons_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pakiso eŋe koso takotke korop edane rake, “Deŋine nat nat potkei, so diamŋine ma more, kine kine natne ea wane bailalaŋ misuk okanikei, ŋei aboŋ ŋine suaine ŋine gege togon ŋine yemo aboŋ yewa ŋine mi marat kayake.” ");
INSERT INTO ons_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pakiso, Yesuŋo don saeŋine mane iwa yale edange, “Ŋei aboŋine suainane kepe mane pake, yewao ŋara kine kine loutne suake. ");
INSERT INTO ons_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Pakimo, ŋei wae eŋe oŋomka kieke more iwa yale wetkeke, ‘Na ŋarane mosikalane matine mane mi metmaike, ea wane na daleo okanikale?’ ");
INSERT INTO ons_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yale ra more rake, ‘Na iwa yale okanikale, na ŋara urum mane yewa lalagewe ketki, koso suaine maikale. Ma more yewao ŋara so aboŋne natne weneŋ mosikale. ");
INSERT INTO ons_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pakimo, na wetneŋo iwa yale raikale, ge aboŋ kine kine korop pa ginmaike, koma zok loutne yewa wane rokop, ea wane ge mere zonom manom, ŋara ne more doku nenom, paki ea wane batne okannom!’ ");
INSERT INTO ons_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ŋo Anutuŋo yemo olale rake, ‘Ge ŋei qelaŋine! Ukude ruo iwao ge seukkene, pakimo, aboŋ kine kineŋone iwo gume sakone, eamo maŋo peikeake?’” ");
INSERT INTO ons_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pakiso, don qoi qoino Yesuŋo rake, “Ŋei natne kepeo ge more, solaenane aboŋ kine kine zok loutne yalewa gume wa okanmami, ŋo Anutu wane kaitko kotoenane morian yemo mida.” ");
INSERT INTO ons_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pakiso, Yesuŋo dokoine edane rake, “Na iwa yale wane ŋidanmaile, ŋine ŋaraŋo kaŋine qesiŋkaki, gege me takot laplapŋo solaŋine kawetka more gege, yewa wane dere mezet zok misuk okanikei. ");
INSERT INTO ons_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ŋaraŋo wele mi okanmaike, gegeŋo yemo wele okanmaike. Takot laplapŋo wele mi okanmaike, solaŋo yemo wele okanmaike. ");
INSERT INTO ons_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ŋine naŋimde gawe onbi, eŋe ŋara mi ebot okanmami, me ŋara mau urumgo mi wa okanmaike, eŋe ŋara urumene mida, so aboŋ kine kine mot mot wane urumene mida, ŋo siluŋ Anutuŋo ŋara gumeon okanmaike! Ŋei ŋerep ŋido naŋi yuan onmami. ");
INSERT INTO ons_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ŋinano ŋine mane maŋo dere mezet okangi paki, nasoine ma kiroroine more koma natne koso ge ariake? ");
INSERT INTO ons_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ŋine kine kine nigatne yalinane qeka more mo onoka wane kine kine natnane dere mezet okanmami? ");
INSERT INTO ons_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Eki zubaine qapan salakkene zurak okanmami, yewa onbi, eŋe ŋaraenane urataine mi ma okanmami, me takot laplapene edomka mi qetut okanmami, ŋo na ŋidanbe detpi! Solomon, Yuda ŋei waom suaine, eŋe takot laplappine kibinerop bira geke, ŋo siluŋ eki qapan salakene kibi maep korop zurak okanmami, yaline mane mi bira geke. ");
INSERT INTO ons_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Touk zubaine iwa eŋe ukude yalewa zurakmaike, ŋo qaekino wamo buratke okanmaike, pakimo kitaremo, gerepko birau wa ze okanmaike. Touk yauwine yaline eŋe siluŋ Anutuŋo takotene biraon okanmaike. Pakimo ŋinane takot laplap mi ma wakoniake ramami me? Yai, mali malipŋine nigagatne! ");
INSERT INTO ons_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ŋine ea wane zok wetŋine kopusutne motki, misuk raikei, onoka ŋara nekene, me onoka doku nekene. ");
INSERT INTO ons_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kepe iwa wane qelaŋ ŋei ŋerep ge arimami, edo kine kine yalinane ra okanmami. Ŋine kine kine yalinane ŋaŋaemami, ea mo ŋinane Magaŋineŋo mo detmaike, ");
INSERT INTO ons_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ea wane turuŋine eamo ŋine Anutu wane bango kine kine maine pamaike, ea wane wetŋine suaine motpi payake, pakimo ŋado Anutuŋo kine kine iwa eamo boaŋ ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Lamakopne magu nigatne, ŋine misuk kaet okangei, magaŋine eŋe eŋine bango kine kine qeli ewe zonomine pamaike, ea mo ŋiboniakane batne okanmaike. ");
INSERT INTO ons_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ŋine aboŋ kine kineŋine yewa ŋei natne ebonbi, eŋe wesi ŋibonikei, pakiso, wesi yewa mapoke, aboŋene midaine ea ebonikei. Pakiso, ŋinŋine eamo wesi kite mane bara warakine midaine, yewa maratkaikei, so qeliwo qoli zaliŋine gege togon, irima ŋosok mi kiti kitine, yewao ŋei edo kobu mi maikei so zau edo kim ki barak mi okanikei, yewa marat kaikei. ");
INSERT INTO ons_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Qeliwo asu wane gege aboŋ pamaike, yewaoka naso baŋem wetŋine motpi payake.” ");
INSERT INTO ons_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ŋine eweke more, laplapŋine ramukei, pakiso, waroŋine togoleka abonbi ari kitoki, so kiwaŋine kiwakkei. ");
INSERT INTO ons_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Pakiso, qelit medep edo suaineene eŋe ŋei ŋerep etke meteetne aukeik wane ŋara soep suaine mau wa okoramaike. Yewao ŋine qelige zinge sariki kaikei wane tomaka okanmami, ŋine yalewa okangei, eŋe sariki paki, madetko yatoki mo, dokoine eŋe eŋane madet ikopka lalaŋgei. ");
INSERT INTO ons_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ŋei suaine yewa eŋe zinge sari more, qelit dokoine yewa ongi eweke more wisika mesikei, pakimo, qelit medep eŋe zok oi bakom okanikei! Na welekatne ŋidanbe, eŋe laplapine ramu more waroine abongi ari kitokimo, qelit dokoine edangi, ŋara zakeo sari mesikei, pakimo oŋom ŋara gumeoniake. ");
INSERT INTO ons_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Eŋe ruo banino me kepe qaeqaewo sari more ongi, qelit dokoine eŋe eweke more wisika gekei, eŋe oi bakom zok okanikei! ");
INSERT INTO ons_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","So iwa weneŋ desikei, ŋei mane mat mane wane welaine, eŋe kobu mama ŋei maneŋo sariakane nasoine mo detmaike, pakimo matinane diamine maki kobu mama ŋei yewaŋo eŋane mat koto mi ra barake wayake. ");
INSERT INTO ons_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pakimo ea wane ŋine yalewaka ewekkei, onoka wane, Ŋei Wawainane Gipole naso maneo ŋine raikei, ‘Eŋe mi sariake,’ yale ra more mi detkau, eŋe baŋ sariake.” ");
INSERT INTO ons_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petoroŋo rake, “Waom, ge don saeŋine iwa ŋeneka ŋedanmaine, me ge ŋei ŋerep koropze ŋedanmaine?” ");
INSERT INTO ons_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Rakiso, Waomŋo rake, “Qelit ŋei aŋa tewe tewekinerop so dereretine maine yewa ma? Qelit ŋei yewa eŋe suaineineŋo ware ware birakaki, dokoine natne yewa wareoniake, so naso kutnoka ŋaraene matoke eboniake. ");
INSERT INTO ons_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Suaineine eŋe zinge sari more kaki, qelit ŋeiine eŋe urataine make, yalewaka maki kaki paki olatki, eŋe oi bakomine suaine okaniake! ");
INSERT INTO ons_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na welekatne ŋidanbe detpi. Ŋei suaine yewa eŋe qelit ŋeiine ea ware ware suaine birakaki aboŋ kine kineine wareake. ");
INSERT INTO ons_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ŋo, qelit ŋei wane wetineŋo yemo iwa yale wetkeake, ‘Suainene eŋe ikopka mi sariake, eŋe naso kiroine ge more, mo boaŋ sariake.’ Yale raki paki, kieke qelit ŋei natne engu more, ŋerep weneŋ enguyake, engu more ŋara neake, so doku togole ne more qelaŋ dere qeake. ");
INSERT INTO ons_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yale okane gekimo, naso maneo ŋei suaine yewa eŋe koso zinge sariake. Qelit mama eŋane ware ware yewa eŋe suaineine naso dango sariake, ea mo mi detmaike, so mi tomaka okanmaike, eŋe nigetkaki, qewoloŋ gegeki, suaine eŋe ikopka lotke more, tiŋ tuŋ kitare aŋa bira wira eŋane keueno birakaki eŋerop wikile suaine geake. ");
INSERT INTO ons_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Qelit mama eŋane ware ware mane eŋe suaineineŋo kine kine mayakane olatmaike, yewa mo detmaike, ŋo mi eweke more, suaineineŋo okaniakane me mayakane ramaike, yewamo mi okan okanmaike, eŋe aŋaine biramaikane kumunam suaineŋo qe more makoboeyake. ");
INSERT INTO ons_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ŋo qelit mama eŋane ware ware mane eŋe suainane don dere ŋaŋae more qewoloŋgi, kumunam suaineŋo qeqe wane rokop, ŋo siluŋ nigatneŋo qe more makoboe kayake. Ŋei mane eŋe kine kine manerop yoboneka man maneo, yemo eŋe weleine yoboneka maingeake.” ");
INSERT INTO ons_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Na kepeo gerep puanbe zeakane ketkole, pakimo na gerep yewa esatka lawe zeakane qomne zok nanmaike! ");
INSERT INTO ons_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na doku mane tauketane raraine, ŋo mi tauwe paki, wetne umaremaike. ");
INSERT INTO ons_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ŋine naŋane wetke ramami, na kepeo peam ma wakoniake ketkole? Na ŋidanbe, peam mida, na ŋei ŋerep ma poripone wakongalane ketkole, ");
INSERT INTO ons_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ea wane naso iwao kiekke more, iwa yale wakoniake, ŋei ŋerep mete mane, matene weku pamami, eŋe poripkekei. Poripke more karewe wa edo etke wa ŋaba osikei. Ŋo etke wa eto karewe wa ŋaba ongeik ");
INSERT INTO ons_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Magakopene edo gipolekopene ŋabaonikei, ŋo gipolekopene edo magakopene ŋabaonikei. Nagakopene eŋe borasokopene ŋabaongei. Sele ŋerep eŋe atolekopene ŋaba onikei, ŋo atolekopene eŋe sele ŋerep ŋaba onikei.” ");
INSERT INTO ons_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu eŋe yale waka ŋei ŋerep takotke edane rake, “Ŋine kezoŋ kau, kepe deine ketmaike okenka saki esatka, ra okanmami, ‘Koya mo qeakane okanmaike,’ rauso, koya eŋe qe okanmaike. ");
INSERT INTO ons_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ŋo detpi, momo suaine raiwoken ŋine sariki, dere more ra okanmami, kepe mo gereweakane okanmaike, rauso kaiwe sirik okanmaike. ");
INSERT INTO ons_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Isi welakoune! Ŋine kepeo so qeliwo masi daleo wakonmaike, ea wane kine ea mo maine detmami, ŋo, ukude naso iwa gemaine, ea wane kine mo onoka wane mi detluk okanmami?” ");
INSERT INTO ons_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ŋine onoka wane ŋidomka mi detluke more, numa koboine ma wesakmamik? ");
INSERT INTO ons_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ŋei mane eŋe dongo biraganiakane geuki arikeik, numao ari more, ŋei yewa olatnom ŋitomka esat mida don sot yewa auye ra makoboekeik. Pakiso, eŋe wano wanok ŋei wane kaitko misuk geu arikiso, oŋo tebe ŋei wane metino biragangi, tebe ŋeiŋo mulap urumgo biraganiake. ");
INSERT INTO ons_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Pakimo, na golatpe, ge mulap urumgo ŋine esatka mi sakesikene. Ge yewaka mere more, sotaŋone korop suaine so nigatne yewa weneŋ makok warenom, qoekika sakesikene.” ");
INSERT INTO ons_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Naso yewao, ŋei ŋerep natne yewa gekoi, eŋe Pilatŋo, Galili ŋei natne Anutu wane soe soep mire geuso enguke, ea wane don kisi Yesu olatkoi. ");
INSERT INTO ons_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pakiso Yesuŋo dere more edane rake, “Galili ŋei eŋe numa yalewa oken seukkoi, ea wane ŋine iwa yale wetkemami, Galili ŋei iwa eŋane soteneŋo Galili ŋei natne korop eŋane sotene yuankamaike? ");
INSERT INTO ons_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yale midakaka! Na ŋidanmaile, ŋine wetŋine mainge more sot turuŋŋine yewa mi ŋadekkaikeiwo, yemo eŋe okangoi, yale ŋine korop seukwarekei. ");
INSERT INTO ons_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ŋo ŋei 18, mokaka Siloam matko mat mane kiroroine yewaŋo dumene ket enguke, ea wane ŋine wetke raikeiŋo, ŋei yewa eŋane sot turuŋeneŋo ŋei ŋerep natne Yerusalem gemami, eŋane sot turuŋ yuankamaike? ");
INSERT INTO ons_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yale mida! Na ŋidanlukmaile, ŋine wetŋine maingeu paki, borikine ŋine yewa ŋadek kaikeiwo, yemo eŋe okangoi, yale ŋine korop seukwarekei.” ");
INSERT INTO ons_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pakiso, Yesuŋo don rokop iwa yale edange, “Ŋei maneŋo wain euine kotino eki mane pik motki suake, pakimo eŋe ari wele wane kaki mane mi qeke. ");
INSERT INTO ons_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pakiso, eŋe eu wane urata mama ŋei eŋe olale rake, ‘Kanom, na koma karewe iwa sari more, kawe pik eki iwaŋo wele mane mi qeki wele wane zuaŋgewe borike, kitonom ketkep! Eŋe onoka wane okora more kepe kelokine yaup wane waraŋ waremaike?’ ");
INSERT INTO ons_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Rakiso, eu ware wareŋo olale rake, ‘Suaine, qeliŋkanom, eŋineka koma weku iwa okorakki, na kino lom ma lolikewe pakimo, wele qeakane bulamakau kaeneŋo lom yewa more more somekale. ");
INSERT INTO ons_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pakimo, pik eki yewa eŋe koma weku ea wane kotino wele manerop maine qeake, ŋo wele mi qeakeo, yemo ge maine kitonom kesiake.’” ");
INSERT INTO ons_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Qezarek naso maneo, Yesuŋo Yuda wane lewa lewaŋ urumgo edange. ");
INSERT INTO ons_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ŋerep mane yewa metke, eŋe asu qotkoinŋo kotino ket more ma pelekkaki, zomainerop okane geki koma 18 okange, yalinane romone setne qoukki maine koboine wie mi okora okange. ");
INSERT INTO ons_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuŋo ŋerep ea kaki paki ora more rake, “Ŋerep, zomaŋone mo midamaike!” ");
INSERT INTO ons_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yale raki pakiso, metine ŋerep wane lewino motkiso, esatkamde ŋerep eŋe romone koboeki, wie more Anutu bakomine kitoke. ");
INSERT INTO ons_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesuŋo qezarek nasoo ŋerep yewa ma menaŋkake, ea wane Yuda wane lewa lewaŋ urum wane ware ware, maneŋo sotine osiki aŋage boka more ŋei ŋerep edane rake, “Kaiwe urata mama 6 pamaike, yewao ŋene urata maine ma okanmaine, wane naso yewao yemo maine sariu, ma menaŋŋuniake, ŋo qezarek naso yemo misusuk!” ");
INSERT INTO ons_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Rakiso, Waomŋo don iwa yale olatke, “Ŋine isi ŋei nau! Ŋinano ŋine maneŋo qezarek nasoo oŋo siluŋ bulamakau me donkiine sengo ŋine maine siwotka more, ma saket more ma ari doku gumekayake. ");
INSERT INTO ons_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ŋo ŋerep iwa yemo Abraham wane ŋaboine Satanŋo mulapŋo wokomkaki koma 18 metmaŋki, mulap yewa maine noŋo qezarek nasoo mi siwot kaikale me?” ");
INSERT INTO ons_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesuŋo don turuŋine edange, yewaŋo ŋabakoune zok enguki gamu onwareke, ŋo ŋei ŋerep wele korop, eŋe yemo Yesuŋo masi kine kine weku mane maki kakoi, ea wane wetene menaŋge. ");
INSERT INTO ons_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesuŋo qesone rake, “Anutu eŋe dalino waremaike, gege togon wane numa yewa tanikine dalino? Na onokakao rokop don mosikale? ");
INSERT INTO ons_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Eŋe yemo nemuyap woune nigagatne yale, ŋei maneŋo woune yewa ma more, ma ari romoino motki, mere wiri sua wa more eki suaine okange, pakimo naŋi eŋe qoginane kutno matene ma okanmami.” ");
INSERT INTO ons_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesuŋo koso manerop qesonone rake, “Anutuŋo dalino waremaike, yewa wane gege togon wane numa na onakakao rokop mosikale? ");
INSERT INTO ons_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ea yemo yis yale, ŋerep maneŋo yis nigatne yewa ma more, palauarop suaine liwage motki, mere more sua piwiwige waki, bret mit okanmaike.” ");
INSERT INTO ons_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu eŋe ari more, mat suaino so mat nigatno ŋei ŋerep don kito ebonma ebonma ari mage, Yerusalem matko ariakane arike. ");
INSERT INTO ons_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Arikiso, ŋei maneŋo qesonkake, “Suaine, ŋei ŋerep weku wekuŋo mane qeliwo waikei me?” ");
INSERT INTO ons_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesuŋo dere more edane rake, “Ŋine sorin borin okane togole more, gege togon madet qeka qekainoka wakesikei, onokawane na ŋidanmaile, ŋei ŋerep loutneŋo waketkei wane soringekei, ŋo siluŋ mi wakesikei, natne ŋaŋaekei. ");
INSERT INTO ons_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Gege togon matpae wane welaine eŋe boaŋ wie more madet legeake. Pakimo, ŋine mat ŋadino okora kieke madetko quŋ quŋ kito more raikei, ‘Suaine, madet lalagenom uŋem!’ Raumo, eŋe boaŋ ŋidane rayake, ‘Na ŋine mi detŋunmaile, ŋine dia ŋine sarimami!’ ");
INSERT INTO ons_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Rakimo, ŋine koso olale raikei, ‘Ŋene ŋara so doku gerop weneŋ mere nekone, ge ŋenane matko don kito ŋebongone!’ ");
INSERT INTO ons_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pakimo, eŋe koso manerop ŋidane rayake, ‘Na ŋaŋaeŋunmaile, wie ariwareu! Ŋine korop borikine mama nau!’ ");
INSERT INTO ons_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eŋe ŋine qeinat mat ŋadino esopŋungi ket more, wetŋine koya saki kuasuruk suaine aroke more, ŋet warik warik ki okorau paki, potpi waki onbi, Abraham, Isak, Yakop so Anutu wane qelit ŋei propet korop weti qeliwo Anutuŋo qeli gege togon ma wakonwareke, ea wane kotine mesikei! ");
INSERT INTO ons_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pakimo, ŋei ŋerep korop boaŋ sariwarekei, natne kepe sasainoken ŋine natne kepe ketmaikeoken ŋine. Sariware more, Anutuŋo kine kine wekumane ma wakonwareke, ea wane kotino zakeo mere nene maep nekei. ");
INSERT INTO ons_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pakimo, naso iwao ŋei ŋerep kepeo ŋado kitomami, eŋe qeliwo lewine alakangei, ŋo lewine kepeo alakanmami, eŋe qeliwo ŋado kitokei.” ");
INSERT INTO ons_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Naso weku yewaoka, Anutu wane papa togon welaine ŋei, Parisi natne Yesu wano sari more olale rakoi, “Ge mat iwa qelige, mat maneo ikop arinom, Herot eŋe gekuki seukkenane okanmaike.” ");
INSERT INTO ons_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesuŋo edane rake, “Ŋine ari kasi borikine zubaine isisine, Herot yewa iwa yale olatpi, ‘Detmaine, na ukude so qaeki asu qotkoine esoponbe saket ariu, zoma enerop yewa ma menaŋonmaile, ŋo qene kaiwe mama kareweo yemo uratane mawe qoeake.’ ");
INSERT INTO ons_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Na siluŋ ukude, qaeki so qene yemo mo ea numane arikale, eŋe Anutu wane qelit ŋei mane mat natneo maine mi qekoi, mida! Eŋe siluŋ Yerusalem matko weku yemo qeu seukeake. ");
INSERT INTO ons_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O, Yerusalem welaine! O, Yerusalem welaine! Ŋine Anutu wane qelit ŋei engu more, ŋinano biraongi yewa weneŋ wesiŋo engu waremami! Naso loutne na meteneŋo motpe ŋei ŋerewekopŋine koraut ŋunikalane okangole. Tiak ŋerepŋo medewekoune qimgimineŋo mapulake motki korautonge, yale na qimgiminane bango met okanmami, na ŋine koraut onikalane, ŋo ŋine ea wane bauŋine wake. ");
INSERT INTO ons_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Detmami! Anutuŋo matŋine mo komu komune qeliŋkayake, na ŋidanbe, ŋine koso na mi nanikei, ge mage naso mane bomileki, yewao ŋine iwa yale raikei, ‘Waom wane tungo sarimaikane, eŋe Anutuŋo mosopkakep!’” ");
INSERT INTO ons_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Qezarek naso maneo, Yesuŋo Parisi ŋetne mane wane matko ŋara neakane arike, pakiso ŋei ŋerep eŋe Yesu wane diamine seleleine makoi. ");
INSERT INTO ons_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pakiso ŋei mane kie mete sua sua okankake, yewa eŋe Yesu wane osino sarike. ");
INSERT INTO ons_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sarikiso, Yesuŋo ŋei wae kaki paki, Anutu papa togon welaine ŋei, Parisi so Skribe qesonone rake, “Ŋenze ra rokop don yewaŋo maine detŋongi, qezarek nasoo ŋei ŋerep zomarop ma menaŋ onikene me mida?” ");
INSERT INTO ons_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ŋo eŋe dan mane mi rakoi, pakiso Yesu eŋe ŋei wa metino ma menaŋkaki, pakiso biraki arike. ");
INSERT INTO ons_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pakiso, eŋe edane rake, “Ŋinano ŋine mane eŋe gipole me bulamakauine mane doku lomgo qezarek nasoo kesiake, pakimo ŋine qezarek nasoo wane maine ikopka mi ma birau sayake me?” ");
INSERT INTO ons_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Don ea wane yalewaka turuŋine eŋe eweke more, maine mi mainge olatkoi, eŋe ŋaŋaekoi. ");
INSERT INTO ons_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu eŋe ongi, ŋei natne eŋe ŋara zakeo ŋara nekei wane sari metmet maine lewine yewaka nogane mesikei wane okanbi, Yesuŋo one more don rokop mane iwa korop kito more edange, ");
INSERT INTO ons_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ŋei maneŋo ŋei ŋerep etke meteetne aukeik wane okanbik newanŋungi eŋane zakeo ŋara nekei wane, ari more met met maine lewine metmaike, yewao misuk mesikene. Qeŋ welaineŋo geŋane wawaine ŋei wele mane mo weneŋ newankake. ");
INSERT INTO ons_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Pakimo, baŋ welaine ŋara zake ŋirit narek newanŋurike, eŋe sariki pakimo geŋane iwa yale rayake, ‘Metmet maine lewine iwa mo ŋei wele wawaine iwa oŋo metkep.’ Pakimo, ge gamu maratkanom, pakimo metmet ketkele, yewao ket mesikene. ");
INSERT INTO ons_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ge epa kebu welaineŋo newangangi, ari more metmet wawaino mesikenane, turuŋine ea mo ge metmet ketkele yewao mesikene. Pakimo, kebu welaineŋo geŋano sariki paki rayake, ‘Iwa sanom kimane sa more metmet maine iwao metnom.’ yewaŋo yemo geŋano bakom suaine lobo natne eŋane kaiteno wakoniake. ");
INSERT INTO ons_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ŋei mane eŋe oŋomka eŋetine mawaki, yemo Anutuŋo maket birakayake, ŋo ŋei mane eŋe oŋomka eŋetine maketki, ketkele det nagumaike, ea wane Anutuŋo mawa birakayake.” ");
INSERT INTO ons_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pakiso, Yesuŋo waom ŋei kebu welaine ea olale rake, “Ge kepe oŋa bango me rarapko ŋara newan onikenane okane more, geŋone kimakopŋone, ŋon tatŋone, weŋem sotawekopŋone me ŋei aboŋene suaine, yewa korop misuk newanonikene. Onoka wane eŋe baŋ turuŋine yalewaka newanganikei, eŋe yalewa oken okane more, kine kine ebonnom nekoi, ea wane turuŋine makoke ginikei. ");
INSERT INTO ons_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ge epa waom manom paki, yemo ŋei ŋerep wanap, aboŋene midaine, mat popokine, kie wawetene qoi qoine so deene pilik pilikine yewa tebaongene. ");
INSERT INTO ons_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Paki Anutuŋo ge baŋ mosopganiake, onoka wane ŋei yaleineŋo maine mi qoleganikei, ea wane turuŋine yemo baŋ ŋei koboine seu seuo ŋine wiekei, naso yewao Anutuŋo qoleganiake.” ");
INSERT INTO ons_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ŋei mane ŋara zakeo mere ŋara weneŋ nekoi, oŋo don iwa detki paki, Yesu olale rake, “Ŋei ŋerep eŋe Anutu wane gege togon mat ma wakonge pamaike, ea wane kotino mere ŋara zakeo nekei, eŋe wet pesek manerop desikei!” ");
INSERT INTO ons_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pakiso, Yesuŋo olatke, “Ŋei maneŋo epa waom suaine maki paki ŋei ŋerep loutne newanonge. ");
INSERT INTO ons_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Epa waom nekei wane naso mo bomilekiso, waom welaineŋo qelit mamaine mane talekaki ari ŋei ŋerep edane rake, ‘Sariu, ŋara kine kine mo zakeo pamaike!’ ");
INSERT INTO ons_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yale ra edangi, eŋe korop mode mode don weku weku rakoi. Ŋei maneŋo qelit mama olale rake, ‘Na kepe mane qolile, ea wane na maine mi arikale, na ari kepe qolile yewa kaikale, siluŋ detnom misuk boriake.’ ");
INSERT INTO ons_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pakiso, maneŋo olale rake, ‘Na bulamakau 10 qolile, ea wane ari liwekone onikale, na maine mi arikale. Ge siluŋ misuk detnom boriake.’ ");
INSERT INTO ons_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pakiso, maneŋo wamo olale rake, ‘Na ŋerep musele mele, ea wane na maine mi arikale. Ge siluŋ misuk detnom boriake.’ ");
INSERT INTO ons_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pakiso qelit mama eŋe zinge ari more suaineine yewa korop olatwareke, pakiso matpae wane welaine eŋe sotine osiki, qelit mamaine olale rake, ‘Ge mat iwa wane kotino numa suaino so nigatno ikopka lolike ari, ŋei ŋerep wesi aboŋene midaine, mat popokine, kie meteene seu seune so deene pilik pilikine yewa ebunom sariwareu!’ ");
INSERT INTO ons_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mi azongiso qelit mamaŋo zinge sari more rake, ‘Suaine, na geŋane don teweke mo okanwarile, ŋo siluŋ met met sotakine yaup pamaike.’ ");
INSERT INTO ons_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Pakiso, suaineŋo qelit mamaine olale rake, ‘Ge numa suaino ari more eu wane sen pamaike, yewa mogare ari ŋei ŋerep ebunom, sari naŋane mat watke warekei. ");
INSERT INTO ons_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na iwa yale ŋedanmaile, ŋei wa newanongole, eŋano ŋine koropŋo naŋane ŋara yewa mi nekei!’” ");
INSERT INTO ons_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ŋei ŋerep magu suaineŋo Yesu ŋadino mogare arikoi, pakimo Yesuŋo zinge edane rake, ");
INSERT INTO ons_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ŋei maneŋo na mogat naniakane ramaike, eŋe naŋane simile alakane detka more, eŋine simileine ea mi ŋabakayake, eŋe yale okangi paki, naga magaine, ŋanom medewekoune, ŋon tarekoune so kiarokoune eŋane gegeinane simile maine dere more so eŋine simile detkayake, paki naŋano sariake, eŋe naŋane medep maine mi okaniake. ");
INSERT INTO ons_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ŋei mane eŋe kaiwe baŋem kibeŋ qabeŋine ea wane wikile mi dere teweke, naŋane ŋadeno mogatnane sariake, eŋe naŋane medep mi okaniake. ");
INSERT INTO ons_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ŋo ŋinano ŋine mane eŋe mat kiroroine mane ma mayakane wetkeake, eŋe mikepka pese mere lewine darapŋo kitasiake, ea wane wesi so zaleine ma wakoniake, paki eŋe kayake, wesi maine mat yewa maki qoeakane rokop okanmaike. ");
INSERT INTO ons_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ŋo eŋe mikepka yale mi okane more, ŋado bosiŋ motki qoeka, eamo mat yewa maine mi maki qoeke, pakimo ŋei loutneŋo kau paki tenikkaikei. ");
INSERT INTO ons_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Pakimo, iwa yale raikei, ‘Ŋei iwa eŋe matpae kieke make, ŋo maine mi maki qoemaike!’ ");
INSERT INTO ons_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ŋei waom mane eŋe kawali ŋeikoune 10, 000 yalewa, ŋo ŋei waom mane eŋe kawali ŋeikoune 20,000, edo engukeiwane sariu, ŋei waomba kawali ŋeikoune 10, 000 ka, eŋe mikepka pese mere dere makoboeake, eŋe maine togole more, ŋei waom mane kawali ŋeikoune 20, 000 yewa engu esoponiake, me mida. ");
INSERT INTO ons_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ŋo eŋe kaki mi kopkeakeo, yemo eŋe ŋei waom mane eŋine so kawali ŋeikoune eŋe qei abaran gemami wane, eŋe qelit mane raongi ari ŋei waom mane olatpi ere qedugu more, peam wane done qesonkaki aukeik.” ");
INSERT INTO ons_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesuŋo takotke raki qoeke, “Rokop yalewaka ŋinano ŋine maneŋo aboŋ kine kineine mi ŋadekka wareakeŋo naŋane medep mi geake.” ");
INSERT INTO ons_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Soli eŋe kine kine maine, ŋo eŋe koso simile midaine okaniake, ea mo daleo okane more, maŋem eŋe koso similerop okaniake, ");
INSERT INTO ons_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","soli yalineŋo euo kepe kelokine mosiakane mi qakane, so bulamakau kaenerop maine mi qeturaŋgene, ea kepe wane kelokine mosiakane mi qakane, ŋene yeine qakŋem numao ari okanmaike, ŋei mane eŋe ketneropŋo don iwa wane kine desiake!” ");
INSERT INTO ons_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Naso maneo takis mama so borikine mama loutneŋo Yesu wane don desikei wane sarikoi. ");
INSERT INTO ons_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pakiso, Anutu papa togon welaine ŋei, Parisi so Skribe eŋe kieke more detpi boriki, Yesu wane rakoi, “Ŋei iwa eŋe borikine mama kima okanon okanmaike, so eŋerop weneŋ mere ŋara ne okanmaike!” ");
INSERT INTO ons_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pakimo, ea wane Yesuŋo don rokop mane iwa yale edange, ");
INSERT INTO ons_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ŋinano ŋine mane eŋe lamakoune 100 okorakei, pakimo yewa ŋine weku siukeake, siukkimo, lama welaine eŋe daleo okaniake? Eŋe qeliŋongi, lama 99 yewa ŋaraene ne okorau mo, eŋine lamawa mane siukike, ea wane zuage ari mage maratkayake. ");
INSERT INTO ons_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Maratkayake, naso yewao welaine eŋe zok wet pesek suaine dere more lamaine yewa ma biraki wokine kutno wayake. ");
INSERT INTO ons_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wakimo, teweke matko ma ariake, ariki paki, kimakoune so matkoune edoraki sari lewageu edane rayake, ‘Na wet pesek suaine detmaile, lamane siukkeo ŋine koso maratkamaile, ea wane ŋene bakom kitoŋem!’ ");
INSERT INTO ons_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na ŋidanbe detpi, rokop yalewaka weti qeliwo eŋe bakom okanikei, yemo ŋei 99, eŋe menaŋgoi, ŋo wetene zok mi maingelukkei. Ŋo siluŋ borikine mama wekukurapŋo wetne maingemaike, yemo oi bakom suaine weti qeliwo wakoniake. ");
INSERT INTO ons_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Me ŋerep maneŋo wesi setne 10 ma geake, yewa ŋine weku siukki mo, ŋereppae eŋe daleo okaniake? Eŋe kiwa kiwakki lawekimo qelaŋango maine sino kitoki paki, yewao yewao kaululke zuage ari maratkayake. ");
INSERT INTO ons_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Maratka more, kimakoune so matkoune edoraki sari lewageu edane rayake, ‘Na wetne zok pesemaike, wesine setne weku siukike, ea mo marat kamaile, ea wane ŋene bakom kitoŋem!’ ");
INSERT INTO ons_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na ŋidanbe detpi, rokop yale waka Anutu wane aŋelokoune eŋe borikine mama wekukuŋo wetne maingeki, oi bakom suaine okanikei.” ");
INSERT INTO ons_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu eŋe koso takotke more rake, “Ŋei mane eŋe gipoletkine etke gekoik. ");
INSERT INTO ons_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gipole nigatneŋo magaine olale rake, ‘Magak, wesi aboŋba naŋane biŋek, yewa ukude mapoke ninnom.’ Rakiso ŋei wae eŋe wesi aboŋ yewa keuoka mapoke gipole nigatne ea mane mange. ");
INSERT INTO ons_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kaiwe urata mama ewekine mere, so gipole nigatne eŋe kine kine kakiine natne yewa matoke qolewareke, pakiso wesiine yewa ma so matine ea qelige, so kepe mane abaran yewao ari geke. Ge more wawaine okane more, wesi yewa korop qakki ariwareke. ");
INSERT INTO ons_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ari mage mida lelemaike, rakimo kepe wa geke, yewao bodi kakapa suaine wakone, kepe mat yewa rokopke pake, pakiso medeppae eŋe mo ea wesi aboŋine midaine metke. ");
INSERT INTO ons_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mere ari kepe mat yewa wane welaine ŋei mane eŋano urata mayakane wakonge. Pakiso, ŋeiwaeŋo birakaki ari berek sengo berewekoune wareonge. ");
INSERT INTO ons_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Berek eŋe bese wane solaine neu, ŋei eŋe yalewaka bese wane solaine yewa neakane wekemaŋke, ŋo ŋei maneŋo ŋara mane mi mangi neke. ");
INSERT INTO ons_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ŋado wetine lotkeki, detwareki paki rake, ‘Maganane urata mama ŋeikoune korop, eŋe ŋara zok suaine neu ŋatene qemaike, ŋo na iwa mere zok ŋara wane seukmaile, ");
INSERT INTO ons_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ea wane na baŋ wie more maganano ariwe paki olale raikale, Magak, na borikine mawe, Anutu ŋabakamaike, so ge weneŋ ŋaba ganmaike, ");
INSERT INTO ons_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","na ŋei maine mida, ea wane ge naŋane giponne misuk raikene, ge urata mama ŋeiŋone yale biranannom gekale.’ ");
INSERT INTO ons_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yale raki pakiso, wie more magainano zinge arike. Ari mat osino osino raki, magaineŋo mo potki ariki kake, ka more wet borikŋo kotino watkeki, biririke ari meterekine biraki ariki, gipole masatka more lulukike. ");
INSERT INTO ons_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pakiso gipoleŋo olatke, ‘Magak, na borikine mawe, Anutu ŋabakamaike, so ge weneŋ ŋabaganmaike, ea wane na koso geŋane giponŋone misuk norakene.’ ");
INSERT INTO ons_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ŋo magaineŋo yemo qelit ŋeikoune edoraki sariu edane rake, ‘Ikop ariu! Ari naewo ŋine takot musele kiroine mane ma sari, birakau ketkep. So metino siliwa zale mane birau wetekimo, kieretkino kie tabe weneŋ birau wakep. ");
INSERT INTO ons_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pakimo, ari bulamakau medeune mane kelokinerop yewa qe more mitpi, epa waom ma neŋem paki, bakom kitoŋem! ");
INSERT INTO ons_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Medep iwa eŋe mo seukkeo ŋine, koso siluŋ marat kamaine.’ Yale ra edangiso, epa waom ma neso, oi bakom kieke okangoi. ");
INSERT INTO ons_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Gipole suaine eŋe naso yewao euo geke, yewao ŋine koso zinge sari mat osino okora, eŋet so wagom yewa detke. ");
INSERT INTO ons_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dere more qelit ŋei mane oraki sariki qesonka rake, ‘Iwa daleo okanmami?’ ");
INSERT INTO ons_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Qelit ŋeiŋo olale rake, ‘Geŋane ŋonŋone mo matko zinge sarike, pakimo magaŋoneŋo bulamakau medeune kelokinerop mane qemaike, gipole kine kine maneŋo mi matalikake, maineka sarike, ea wane, magaŋitneŋo raki okanmami,’ ");
INSERT INTO ons_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tatine suaine eŋe sotine osiki mat koto mi wake, pakiso magaineŋo saket more, mat koto wayakane wetkelik kake. ");
INSERT INTO ons_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ŋo gipoleŋo yemo done turuŋine olale rake, ‘Detnom, na koma loutne urata ŋei yauwine yale qelitŋone qe sarikole, donŋone mane mi qekole, ge onokaka mane ningone? Ge noniŋ mida mane mi ninnom qe more kimakopne eŋerop epa waom ma neŋem paki, oi bakom okangone, midakaka! ");
INSERT INTO ons_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ŋo giponŋone iwa eŋe yemo wesi aboŋŋone korop yewa wenip ŋerep eŋerop ge more, mataliwareki mida leleki, koso zinge matko sarikimo, ge bulamakau medeune kelokinerop yewa eŋane qemaine!’ ");
INSERT INTO ons_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yale rakimo, magaineŋo mainge olale rake, ‘Giponne, ge yemo naso baŋem narop iwa ge okanmaine, yalinane mo kine kine naŋano pamaike, ea mo geŋane okanmaike, ");
INSERT INTO ons_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ŋo ŋene yemo epa waom ma neŋem paki oi bakom okanikene, ŋonŋone mo seukeo ŋine, koso siluŋ wisikaemaike, eŋe mo siukkeo ŋine, koso siluŋ wakongi marat kamaine.’” ");
INSERT INTO ons_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuŋo don mane iwa yale dokoine edange, “Baliŋa ŋei mane geke, eŋe eŋane wesi aboŋ ware wareine mane geke, pakimo ŋei natne eŋe baliŋa ŋei wano sari ware ware wane solaino don qe more rakoi, ‘Ware wareŋoneŋo wesiŋone mo matali waremaike.’ ");
INSERT INTO ons_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Rau dereso, baliŋa ŋei waomŋo ware warewa oraki sariki qesonka rake, ‘Daleo wane geŋane don iwa detmaile? Ge ari naŋane aboŋ geŋane meto pamaike, yewa wane zaleine korop dapot warekene, ge koso naŋane ware ware mane mi gekene.’ ");
INSERT INTO ons_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pakiso ware ware wa eŋe iwa yale wetkeke, ‘Suainene eŋe mo ware ware uratao ŋine esopnaniake, na daleo okanikale? Na sere maine mi kitomaile, na ŋei ŋerep natne ŋara wesi meŋen onikalane gamu nanmaike. ");
INSERT INTO ons_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Na detmaile, na siluŋ naso iwao kimakopne qesiŋonikale, ea wane waomne eŋe na esop naniake, ŋo naŋane kimakopne eŋe na maine qesiŋnankei. ");
INSERT INTO ons_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Eŋe yale dere more urata ŋei kimakoune edora more, suaineinane sotaene eŋano pake, yewa edorki, eŋano sarikoi, mane eŋe alakane sariki, eŋe ŋei alakane sarike, qesonka rake, ‘Ge naŋane waomnano sotaŋone darap qolekene?’ ");
INSERT INTO ons_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Eŋe mainge rake, ‘Na sotne kelok mitmit 100 dram qolekale.’ Ware ware eŋe olatke, ‘Sotaŋone papia iwa mo qeu pake, ge ma mere 50 dram qekene.’ ");
INSERT INTO ons_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pakiso eŋe ŋei mane qesonka rake, ‘So, ge sotaŋone darap?’ Eŋe mainge rake, ‘Na sotane wan(1) tausen kaura bet wit woune.’ Ware ware eŋe olatke, ‘Sotaŋone papia iwa pake, ge 8 handret kaura bet qekene.’ ");
INSERT INTO ons_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kine kine ea wakonge, ea ŋei waom eŋe dere more ware ware wane masi isisine ka more, eweine kitoke. Kine yewa onoka wane, kepe ŋei ŋerep eŋe kepe wane wesi aboŋ urata detlukonmami, so edo ŋine ŋei ŋerep qelaŋane ŋine qelaŋan wane urata mogare mamami, edo yewa yuanŋunmami.” ");
INSERT INTO ons_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Pakiso, Yesu eŋe takotke edange, “Na weneŋ ŋidanmaile, ŋine kepe wane wesi aboŋ ŋineŋo ŋei ŋerep ketkele qesiŋonikei, boaŋ wesi aboŋŋine ea siukeake, naso yewao Anutuŋo ŋine qeli gege togongo mauluk ŋuniake. ");
INSERT INTO ons_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ŋei maneŋo kine kine yauwine koboboine ma gemaikeo, eŋe kine kine suaine koboboine ma geake. Ŋei maneŋo kine kine nigatne isisine ma gemaikeo, eŋe kine kine suaine masi isisine ma geake. ");
INSERT INTO ons_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ŋine kepo wesi aboŋ mi wareluk kamamiwo, ŋine qeli wane aboŋ wele mi warelukkaikei. ");
INSERT INTO ons_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pakiso, ŋine ŋei mane wane aboŋ mi wareluk kaikeiwo, Anutuŋo ŋinane biŋek mi ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ŋei maneŋo ŋei suaine etke erane qelit qeqe urata maine mi mayake, eŋe ŋei mane qaisikkayake, ŋo mane wane maine siminkayake. Eŋe ŋei weku mogatkayake, ŋo mane ea detki, ŋei yauwine okaniake. Ŋine Anutu so wesi aboŋ ea maine mi mogat osikei.” ");
INSERT INTO ons_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pakimo, Anutu papa togon welaine ŋei, Parisi, eŋe don ea dere more Yesu wane tenikkakoi, ea wane eŋe kepe wane wesi ea wane zok manerop siminonge, ");
INSERT INTO ons_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ŋo Yesuŋo edange, “Ŋine ŋei ŋerep kaiteno kine kine koboine mamami, ŋo Anutu eŋe ŋinane wet dereretŋine detlukmaike. Ŋei ŋerep eŋe kine kine one more, weku mane detmami, ŋo Anutuŋo kine kine ea yemo one more detki yauwine okan okanmaike. ");
INSERT INTO ons_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ra rokop don kine kine Moseŋo qeke, so kine kine Anutu wane qelit ŋei edo qekoi, ea pa sari mageki Yohane wane naso bomileke, Yohane doku tau tau nasoine bomileki sari lotkeke, naso yewao Yohaneŋo Anutuŋo daline waremaike so eŋane gege togon numa, so qeli ewe zonom ea wane biŋek don ra qelaŋange, so ŋei ŋerep koropŋo Anutu wane gege togon numa togogole soringe wakesikei wane okanmami so natneŋo mo waket warekoi. ");
INSERT INTO ons_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ŋo qeli so kepe siukeikwo, Mose wane ra rokop don nigatnemde mane mi siukeake. ");
INSERT INTO ons_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ŋei mane eŋe ŋanomine qeliŋka more, ŋerep mane mayake, eŋe sotine maratkayake, so ŋerep maneŋo eŋe ŋaone qeliŋka more, ari ŋei mane mayakeo, eŋe sot maratkayake. ");
INSERT INTO ons_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Naso maneo, ŋei waom wesi aboŋine suaineropŋo geke, eŋe takot laplapine weku mane kibinerop. Eŋe epa waom ma kaiwe baŋem met mageke. ");
INSERT INTO ons_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Naso yewao, ŋei mane aboŋine midaine, kubetenerop geke. Ŋei ea eŋetine Lazarus, eŋe ŋei aboŋine suainane mat wane aŋaine pa mageke. ");
INSERT INTO ons_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Eŋe ŋei aboŋine suainane ŋara sisine neyakane simile dere pa mageke metki, so kasi eŋe sari more Lazarus wane kubet soŋine bozeka maŋkoi. ");
INSERT INTO ons_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Pakiso ŋei aboŋine midaine eŋe seukki, so aŋelo edo ŋei ea tewekka wa more, qeli wane epa waom pamaikeo, Abraham wane wazaino birakau metke. Ŋo ŋei aboŋine suaine eŋe seukki, so kimakoune dukkau, eŋe ari ");
INSERT INTO ons_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","gerep sorao ket okorake. Yewao eŋe wikile suaine dere more, deine potki waki Abraham wane wazaino Lazarus metki kake. ");
INSERT INTO ons_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ea wane eŋe Abraham boka ora olale rake, ‘Magane, Abraham, ge naŋane wetŋone borikep! Ge Lazarus birakanom, eŋe zoliwineŋo doku qe more sari naŋane belakamne uakayakeo, na siluŋ zonom nigatne maikale, na wikile zok suaine gerepko iwa detmaile!’ ");
INSERT INTO ons_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ŋo Abrahamŋo olatke, ‘Gifonne, ge det sorokkene, Anutuŋo ge kepe aboŋ wekumane ginge, ŋo Lazarus eŋe kine kine qotkoine mange, ŋo ukude Lazarus eŋe kine kine wekumane detmaike, so ge wikile detmaine. ");
INSERT INTO ons_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ge roo suaine kiroine keuzo iwa ka maine, na nat iwa metmaile, so ge nat yewa metmaine. Na geŋano yewa zawo yuane maine mi ukale, so ŋei natne eŋe nat yewa maine mi zawo suaine pamaike, more iwa yuane ea sarikei.’ ");
INSERT INTO ons_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ŋei aboŋine suaine eŋe Abraham olale rake, ‘Na magane Abraham ge koso meŋengamaile, ge Lazarus maganane matko birakanom arikep! ");
INSERT INTO ons_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yewao, eŋe naŋane tatne so ŋolekopne metemane gemami, eŋe girem don edaniakeo, eŋe iwa mi sari more wikile desikei.’ ");
INSERT INTO ons_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham eŋe mainge rake, ‘Don kine kine Mose so Anutu wane qelit ŋei propet, eŋe qekoi, ea tatŋone so ŋonŋone eŋe girem don ea edan okanmami, eŋe don ea maine detpi.’ ");
INSERT INTO ons_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ŋei aboŋine suaineŋo olatke, ‘Yale mida! Eŋe ŋei mane seu seuo ŋine, wisikae wie more ari edaniakeo, eŋe maine sotene ea ŋadekkaikei.’ ");
INSERT INTO ons_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ŋo Abraham eŋe rake, ‘Eŋe Mose so Anutu wane qelit ŋei propet eŋane don mi desikeiwo, eŋe ŋei seuseunane don edangi dere maine mi malipkaikei. Eŋe yewa baŋ dere ŋadekaikei.’” ");
INSERT INTO ons_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Pakiso Yesu eŋe dokoine edane rake, “Borikine kine kineŋo ŋei ŋerep mau sotene maratoniake, ea naso baŋem wakonmaike, ŋo ŋei maneŋo kimaine qebin mabin borikine mane ma more, sot marat kayakeo, Anutuŋo ŋei ea wikile maniake. ");
INSERT INTO ons_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ŋo ŋei maneŋo medep nigatne yewa maki me iwenkaki sot marat kayakeo, Anutuŋo ŋei ea wikile suaine zok maniake. ");
INSERT INTO ons_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ea wane ŋine kine kine ma more kaulukkei. “Kimaŋone eŋe masi borikine mayakeo, ge maine eŋano ari girem olale more, rawetkanom, eŋe sot ea ŋadekayakeo, ge maine sotine qelige turuŋine birakene. ");
INSERT INTO ons_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eŋe masi borikine geŋano atak sewen, kaiwe weku ma more sari more rokop atak sewen rapoke golasiakeo, me qom borik don golasiakeo, ge sot turuŋine qelige manikene, so ge iwa yale olasikene, ‘Na sot turuŋŋone mo qeliŋmaile.” ");
INSERT INTO ons_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesu wane qelit ŋei eŋe Yesu olale rakoi, “Ŋenane mali malipze togole mida, ge mali malipze manom togolekep!” ");
INSERT INTO ons_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Waomzeŋo mainge iwa yale rake, “Mastet woune eŋe nigat nigatne okanmaike pakimo ŋinane mali malipŋine eŋe woune yale waka nigatne okaniakeo, ŋine eki suaine yewao maine olasikei, ‘Ge wie lolige ŋodoŋonerop ari kiwetko okoranom!’ Ŋine yale ra olatpi, eki ea eŋe maine ŋinane don tewekeake. ");
INSERT INTO ons_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ŋinane keuo ŋine ŋei maneŋo qelit ŋei mamaike, qelit ŋei eaŋo sere kito more lama ware okanmaike. Urata ea qoeki, so eŋe euo ŋine sariki eŋe iwa yale mi olatmaike, ‘Ge ikop sari nenom!’ ");
INSERT INTO ons_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Midakaka, eŋe iwa yale olasiake, ‘Ge wie naŋane ŋara soep mauluke more, laplap libeka bira more ŋara soep ninnom nekale, na newe qoeki baŋ ŋado yemo ge ŋara dokuŋone nekene.’ ");
INSERT INTO ons_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Qelit qeqeŋone eŋe urata ma qelitŋone qeki, ge maine ewine kito mawa kaikene me? Midakaka! ");
INSERT INTO ons_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ŋine yale waka, na kine kine ŋidangole, ea korop ŋine ma more raikei, ‘Ŋene qelit qeqe ŋei, ge kine kine ŋedangone, ea ŋene mo mene, ea mo rokouno.’” ");
INSERT INTO ons_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu eŋe Yerusalem ariakane Samaria kepe so Galili kepe keuetnoka ari more, ");
INSERT INTO ons_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","mat maneo wakesiakane okane, ŋei 10 kubet togoleenerop maratonge, eŋe amaŋ okora more, ");
INSERT INTO ons_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","boka rakoi, “Yesu, waom, ge ŋenano wetŋone borikep!” ");
INSERT INTO ons_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu eŋe ŋei ea one more edange, “Ŋine ari more, mosop ŋei solaŋine ea sikanonikei.” Eŋe ariu ariu eaka kubet togon solaeno pake, ea mo osi more, libeka okange. ");
INSERT INTO ons_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ŋei maneŋo solaine kaki menaŋgi, so eŋe Yesu wano zinge ari, Anutu wane eŋetine ora mawaka more suaineze oi bakom okankake. ");
INSERT INTO ons_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Eŋe Yesu wane kino ket rasu more, ewine kitoke, ŋei yewao eŋe Samaria welaine mane, eŋe Yuda tego ŋadino ŋine. ");
INSERT INTO ons_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pakimo Yesu eŋe olale rake, “Na ŋei 10 ma menaŋonile, ŋei natne 9 eŋe diao arimami? ");
INSERT INTO ons_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Onoka wane qelaŋ lobo ŋeiŋoka iwa koso zinge Anutu wane eŋetine buke wamaike?” ");
INSERT INTO ons_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","So Yesu eŋe takotke more olatke, “Ge wie arinom, ge naŋane don mo malipkamaine, so mali malipŋonane menaŋmaine.” ");
INSERT INTO ons_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Anutu wane papa togon welaine ŋei, Parisi, eŋe sari Yesu qesonka rakoi, “Naso dango Anutu eŋe sari kepe warekayake?” Yesu eŋe mainge rake, “Anutu eŋe waremaike, ea ŋine maine mi kaikei, so ");
INSERT INTO ons_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ŋei maneŋo mi rayake, ‘I, kau!’ me, ‘Yewa pamaike!’ Anutuŋo ŋinane wetŋine koto wareŋunmaike.” ");
INSERT INTO ons_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pakiso Yesu eŋe dokoine edange, “Boaŋ ŋine Ŋei Wawainane Gipole nasoine kaikei wane wetkekei, ŋo ŋine mi kaikei. ");
INSERT INTO ons_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ŋei natne ŋinano sari ŋidanikei, ‘Ŋine eriwa kau!’ me, ‘Ŋine iwa kau!’ Ŋo, ŋine mi kaikei. ");
INSERT INTO ons_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Qilapŋo naso natne walatake wamaike, so naso natne qeli korop kilitikmaike, Ŋei Wawainane Gipolane nasoine eŋe qilap ea yale ikopka wakoniake. ");
INSERT INTO ons_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ŋo alakane eŋe wikile suaine detki, so ŋei ŋerep eŋe ŋadekaikei. ");
INSERT INTO ons_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kine kine Noa wane nasoino wakonge, ea korop Ŋei Wawainane Gipolane nasoino wakoniake. ");
INSERT INTO ons_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa wane nasoo ea, ŋei ŋerep korop ŋara doku soep ne more, zokit makoi, nasoine yale ari mage ari mageki, so Noa eŋe sekiwo kaiwe mane waketki, doku qakumŋo ket more ŋei ŋerep korop enguki seukwarekoi. ");
INSERT INTO ons_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kine kine ea Lot wane nasoino wakonge, ea korop Ŋei Wawainane Gipolane nasoino wakoniake. Lot wane nasoo ŋei ŋerep eŋe ŋara soep ne more, aboŋ qole more eu ebore more, mat makoi. ");
INSERT INTO ons_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pakiso Lot eŋe kaiwe mane Sodom qeliŋgi, so naso yewao gerep so wesi bolamineropŋo kere more, ŋei ŋerep korop enguwi seukwarekoi. ");
INSERT INTO ons_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Boaŋ Anutuŋo Ŋei Wawainane Gipole maki qelaŋankayake, naso eaŋo Lot wane nasoo yale okaniake. ");
INSERT INTO ons_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Naso yewao, ŋei mane eŋe mat sekaino mere more, mat koto mi wa more kine kineine natne mayake, eŋe yeine qelige kaet ariake. Yalewaka ŋei mane eŋe euo ge more, matko koso mi zinge ari kine kineine ea mayake, eŋe yeine qelige ket ariake. ");
INSERT INTO ons_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ŋine Lot wane ŋanominane don kisi ea dere detsorokpi, eŋe deineŋo potki ŋadino Sodom mat suaino ari kaki paki seukke! ");
INSERT INTO ons_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ŋei mane eŋe naŋane ra more wikilane kaet kaki, solaine mawaulukeakeo, eŋe gege togon wane numaine korop siuklukeake. Ŋo ŋei mane eŋe naŋane ra more seukkeake, ŋei yewa eŋe gege togon marat kayake. ");
INSERT INTO ons_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na ŋidanmaile, Ŋei Wawainane Gipole nasoine, ruo yewao ŋei etke ere mat wekuoka kulu paut, Anutuŋo ŋei weku ma more, ŋei mane qeliŋkayake. ");
INSERT INTO ons_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ŋerep etke ere ŋara soige metpik, Anutuŋo ŋerep weku ma more, ŋerep mane qeliŋkayake. ");
INSERT INTO ons_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ŋei etke ere euo uratao geuk, Anutuŋo ŋei weku ma more, ŋei mane qeliŋkayake.” ");
INSERT INTO ons_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesu eŋe yale raki qoeki, so dokoine eŋe qesonka rakoi, “Kine kine ea ramaine, diao wakoniake?” Yesu eŋe mainge rake, “Kine kine seuseune pareŋ pamaike, naso yewao gawe naŋi eŋe ari lewaŋmaŋkei.” ");
INSERT INTO ons_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pakiso Yesu eŋe dokoine don rokop iwa edange. Eŋe eŋine dokoineŋo Anutu wano naso baŋem mi pelekeu paki, togole more meŋenkaikei wane edange Eŋe meŋe meŋen urata maine mi qeliŋkaikei, ea wane eŋe don rokop ea iwa yale kito more dokoine edange, ");
INSERT INTO ons_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Mat maneo wano wanok ŋei mane geke, eŋe Anutu wane mi kaetkake, so eŋe ŋei mane wane yale waka mi kaetkake, ");
INSERT INTO ons_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","pakiso ŋerep ŋaone seuseune maneŋo mat yewao geke. Eŋe wano wanok ŋei eŋano atak loutne sari meŋenka iwa yale rake, ‘Ŋabaneŋo naŋano masi borikine make, ge na mapik nanikene!’ ");
INSERT INTO ons_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Naso kiriroine okangi, so wano wanok ŋei eŋe mi mapik kayakane rake, ŋo, naso kiroroine okangiso, eŋe iwa yale wetino detke, ‘Na Anutu wane mi kaet nanmaike, so na ŋei mane wane ewine mi kitomaile, ");
INSERT INTO ons_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ŋo ŋerep iwa, eŋe naso baŋem sari more qesonnane more, sorinnane umat suaine ninge, ea wane na eŋe mapik kaikale. Na mi mapik kaikaleo, eŋe sari meŋennan mageki, na eŋane don wane zok bauwawa okanikale!’” ");
INSERT INTO ons_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yesu eŋe don kisi ea ra more, takotke edange, “Ŋine wano wanok ŋei qeguŋ maguŋine, ea wane don detkakei. ");
INSERT INTO ons_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Yalewaka, ŋine Anutu mapik ŋuniakane eŋano kaiwe so ruo naso baŋem sorin borin aroke meŋenkaikei. Eŋe eŋine ŋei ŋerewekoune wanokone more, ikopka mapitoniake. Ŋo Ŋei Wawainane Gipoleŋo kepeo koso zinge sari more, ŋei ŋerep eŋe Anutu malip kamami, ea maratoniake, me mida?” ");
INSERT INTO ons_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Naso yewao, ŋei ŋerep natne eŋe Yesu wane don desikei wane sarikoi, eŋe weteno iwa yale detkoi, “Ŋedomka koboboine gemaine, ŋei ŋerep natne eŋe yau yaup gemami.” ");
INSERT INTO ons_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Yesu eŋe wet dereret ea dere more, don rokop iwa edane rake, “Naso maneo, ŋei etke ere Anutu wane Bakom Urumgo meŋen kaikeik wane arikoik, ŋei mane eŋe Anutu wane papa togon welaine ŋei, Parisi mane, ŋei mane eŋe takis mama. ");
INSERT INTO ons_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Parisi eŋe eŋinane detki waki, koŋka okora iwa yale ra meŋenkake, ‘Na kaŋ bap sua mida, na masi isisine mi mamaile, na ŋei mane wane ŋanomine kobu mi mamaile, ŋei ŋerep natne eŋe masi qotkoine ea ma okanmami. Na eŋe yale mi okanmaŋkale, ea wane na Anutune eŋetŋone bukewe wamaike. Na takis mama ŋei borikine yewa, eŋe yale mida! Na eŋane masi qotkoine mi mogatmaŋkale. ");
INSERT INTO ons_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Soda baŋem ea wane kotine kaiwe etkeka etkeka na ŋara sawe gemaile. Naŋane wesi aboŋne korop, ea na 10go ŋine weku geŋane biŋek qewaremaŋkale, ea wane na Anutune eŋetŋone bukewe wamaike.’ ");
INSERT INTO ons_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ŋo takis mama ŋei eŋe deine qeliwo mi potki ariki, okora more qomine boriki so rake, ‘Na ŋei qotkoine, Anutu, ge naŋane qomŋone borikep!’” ");
INSERT INTO ons_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu eŋe donkisi raki, qoekiso edange, “Na ŋidanmaile, Anutuŋo takis mama ŋei eŋane sotine qelika nigetkake. Eŋe Anutu wane kaitko koboboine okorake, ŋo Anutuŋo Parisi ea wane sotine mi qeliŋka nigetkake. Ŋei maneŋo eŋine eŋetine maki suayakane okaniake, yemo Anutuŋo ma ket birakayake. Ŋo ŋei maneŋo eŋe eŋane eŋet biŋekine ma kesiakeo, yemo Anutuŋo ŋei ea ma wa birakayake.” ");
INSERT INTO ons_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ŋei ŋerep natne eŋe dokoene Yesuŋo metineŋo kuteno more mosop oniakane ra more, eŋano ebu sarikoi, pakimo Yesu wane dokoine eŋe ŋei ŋerep one more rawetongoi. ");
INSERT INTO ons_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ŋo Yesu eŋe medep nigatne eŋano sarikei wane edorake, “Qeliŋonbi! Medep nigatne ea naŋane osono maine sariu, ŋine misuk rawetonikei, Anutu eŋe ŋei ŋerep medep nigatne iwa yaline eŋane rokopko wareoniakane siminkake. ");
INSERT INTO ons_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ŋine don iwa detsorok detlukkei, medep nigatne eŋe Anutuŋo wareoniakane siminonmaike, ŋo ŋei natne eŋe Anutuŋo wareoneakane mi siminonmaikeo, eŋe Anutu wane gege togon kepe ea wane kotino mi wakesikei.” ");
INSERT INTO ons_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yuda ŋei ŋetne mane Yesu wano sari qesonka rake, “Kito ŋebo ŋebon maepne, na dalino okane more, naso baŋem gege togon maratka gemaŋkale?” ");
INSERT INTO ons_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yale rakimo, Yesuŋo olatke, “Ge onoka wane na ‘Mayakatne’ , noramaine? Anutu wekuŋo mayakatne. ");
INSERT INTO ons_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ge Anutu wane papa togon don detmaine, ŋire ŋao ŋanom mi bira nagukeik, so ŋei me ŋerep mane misuk maikeik. Ge ŋei mane mi qenom seukeake. Ge kobu mi maikene. Ge ŋei mane mi ma baikkaikene. Ge nabok magak erane bango ge more, erane don dereret tewek okanikene.” ");
INSERT INTO ons_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ŋei yewa eŋe rake, “Kito ŋebo ŋebon, na mo medepnoka Anutu papa togon don ea mane mi qeliŋkakole, mo korop okane gesakole gemaile iwa.” ");
INSERT INTO ons_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu eŋe don ea dere more olatke, “Ge kine kine weku mi okanine, ea ge makoboenom. Ge ari more aboŋŋone korop ea ŋei natne ebonnom wesi ginbi ma more, wesi yewa ŋei aboŋene midaine eŋe qika ebonikene, eso yalinane ge baŋ qeli wane aboŋ togogole maratkaikene. Pakiso geŋone sari ŋadeno mogatnane sarimaŋkene.” ");
INSERT INTO ons_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ŋei yewa eŋe don yale dere more, wet dereretine umareki qelige arike. Eŋe wesi aboŋine maune loutne zok manerop pa mange, ea wane. ");
INSERT INTO ons_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu eŋe ŋei ea wane dereret umat dere more rake, “Ŋei yaline wesi aboŋene suaine, eŋe Anutuŋo ware oniakane raikei, ŋo eŋe zok urata suaine ma more aboŋene qeliŋka more Anutu wane qeli gege togon numa mogasikei. ");
INSERT INTO ons_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel eŋe samap wane aŋaono wakesikei wane ea mo urata suaine mida, ŋo baliŋa ŋei eŋe Anutu wane qeli ewe zonom so gege togongo wane rake, eamo eŋe zok urata suaine, zok manerop ma more aboŋine qeliŋkayake.” ");
INSERT INTO ons_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ŋei ŋerep natne eŋe don ea dere more, Yesu qesonkakoi, “Ge ramaine, Anutuŋo baliŋa ŋei maine mi wareoniake, yale okangi, ŋei ŋerep ketkele gemami, ea eŋe weneŋ Anutuŋo mi wareoniake me?” ");
INSERT INTO ons_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu eŋe mainge rake, “Kepeo ŋei ŋerep ŋine ŋaŋaemami, ŋo Anutu wekuŋo mi ŋaŋaemaike, Anutu eŋe kine kine korop ma wareakane, eŋe maine mi qekayake.” ");
INSERT INTO ons_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pakiso, Petoroŋo Yesu olatke, “Detmaine, ŋene kepe matze so kine kineze qeliŋone more, ge mogatgangone.” ");
INSERT INTO ons_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesuŋo rake, “Na don wele ŋidanmaile, ŋei mane eŋe Anutu wane ra more, mat me ŋanom medep, me tatiŋon, me nabok, me magak qeliŋonware, eŋe sari na mogat naniakeo, ");
INSERT INTO ons_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ea wane turuŋine Anutuŋo eŋe naso iwao kepeo mo geke, ea yuane more, zok manerop makoke maniake, so baŋ koso nasoo ŋado eŋe gege togon kiroine manerop maratka takotke mangi ge ari geake.” ");
INSERT INTO ons_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu eŋe dokoine 12 yewa koso ebu qeduguone more edange, “Detmami, ŋene wa Yerusalem ariŋem. Anutu wane qelit ŋeiŋo Ŋei Wawainane Gipole ra more kine kine korop kibi qekoi, ea korop wakoniake. ");
INSERT INTO ons_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ŋei natneŋo Yuda ŋadeeno eŋane meteeno birakaikei. Pakimo, ŋei ea eŋe don isi masirakinerop okane more, sopotka more ");
INSERT INTO ons_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kumunamŋo qe more, kibego qeu seuke more, kaiwe mama karewe deŋesereo pa more, eŋe koso wisikae wieake.” ");
INSERT INTO ons_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesu eŋe kine kine iwa rakiso, dokoine eŋe mi detlukwarekoi, Anutuŋo don ea wane kine motkeke, ea wane eŋe mi detlukwarekoi. ");
INSERT INTO ons_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu so dokoine eŋe Yeriko osino lotkekoi, ŋei mane deine pilik pilikine eŋe ŋei ŋerep edo wesi aboŋ natne qesiŋkaikei wane meŋenone more, boka woka metmaŋke. ");
INSERT INTO ons_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eŋe ŋei ŋerep magu eŋane don ukat dere more qesonone rake, “Ea onokaka?” ");
INSERT INTO ons_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ŋei ŋerep magu keuo ŋine natne eŋe olatkoi, “Yesu, Nazaret matko ŋine, eŋe mo iwa sarimaike.” ");
INSERT INTO ons_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Eŋe yale dere more boka rake, “Oo, Yesu, ge Dawit wane ŋaboine ŋetne, ea Anutu eŋe mo rake, yewa bira gangi ketkone, ge naŋane wetŋone borikep!” ");
INSERT INTO ons_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ŋei ŋerep magu yewa eŋe ŋei de pilik ea kuroŋka more rakoi, “Ge aŋaŋone ma wonge metnom!” Yale rau, eŋe soringe togoleka koso boka rake, “Dawit ŋaboine ŋetne, ge siluŋ naŋane wetŋone borikep!” ");
INSERT INTO ons_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yale ra bokaki, Yesu eŋe dere more, doŋ mane okora edane rake, “Ŋine ari ŋei yewa ma sariu.” Pakimo ŋei eŋe Yesu wane osino lotkekiso, Yesu eŋe qesonka rake, ");
INSERT INTO ons_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Na ge dalino okan ganikalane ramaine?” Ŋei eŋe mainge rake, “Waomne, na dene koso posikalane ramaile.” ");
INSERT INTO ons_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu eŋe olatke, “Ge deŋone pore kanom, ge naŋano mena menaŋ wane zonomne detlukka more, malipnannom paki, ea wane menaŋmaine.” ");
INSERT INTO ons_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yale raki, yewaka ŋei ea deine lotkeki pore ka more, Yesu mogatka more, Anutu wane eŋetine buke wake, pakimo, ŋei ŋerep magu eŋe masi togole ea ka more, Anutu wane eŋetine weneŋ bukeu wake. ");
INSERT INTO ons_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu eŋe ari more, Yeriko mat suainane keunoka ari mat qeliŋkayakane okangiso, ");
INSERT INTO ons_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","takis mama so baliŋa ŋei mane, eŋetine Zakius, eŋe mat suaine yewa wane kotino geke. ");
INSERT INTO ons_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zakius eŋe ŋei ŋerep magu suaine one more Yesu eŋe ma me eŋe daleo ea desiakane zok manerop wetkeke, ŋo eŋe ŋei bamgo, ea wane Yesu maine mi kake. ");
INSERT INTO ons_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pakiso, eŋe magu lewine alakane biririke ari yuanone more, Yesu kayakane eki maneo wake, ");
INSERT INTO ons_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","pakimo Yesu eŋe eki bano lotke, deine potki waki eki kutno Zakius kaki paki olatke, “Zakius, ge ikop kesikene, na matŋono ukude gerop mesikale.” ");
INSERT INTO ons_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakius eŋe aŋaine teweke ikop ket more, bakom kito Yesu iwenkaki matine koto waketkoik. ");
INSERT INTO ons_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kine kine ea wakongi, ŋei ŋerep natne eŋe kau paki, detpi boriki rakoi, “Eŋe ŋei sotinerop wane matko ea mo daleo wane waket metmaike?” ");
INSERT INTO ons_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakius eŋe mat koto wie okora Waom olale rake, “Waom, ge detnom, na aboŋne keunoka mapokkawe magu etke lelemamik, na ŋei ŋerep aboŋene midaine magu weku ebonikale, so na ŋei ŋerep natne mo sogino isione more takis wesiene setne weku kobu omaongoleo, na eŋe ukude wesi setne etke so etke ebonikale.” ");
INSERT INTO ons_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu eŋe dere more olatke, “Ukude Anutuŋo mat iwa wane kotino ŋei ŋerep eŋane wetene mo maki zingemaike. Ŋo yewa eŋane keuo ŋine ŋei iwa eŋe na malip nanmaike, ea wane na ŋidanmaile, eŋe mo Abraham wane ŋaboine solaŋoka, ŋo ukude eŋe Abraham ŋaboine sola so kotorop weneŋ wakonmaike. ");
INSERT INTO ons_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ŋei Wawainane Gipole, eŋe ŋei ŋerep siuk siukine ea ziaŋone more, wetene ma menaŋ onikalane sarimaike.” ");
INSERT INTO ons_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ŋei ŋerep eŋe don ea detkau mere edange, so Yesu eŋe takotke don rokop mane edange. Onoka wane? Yesu eŋe mo Yerusalem mat osino lotkekimo, ŋei ŋerep eŋe wetke rakoi, ‘Mo iwaka Anutu wane qeli ewe zonomine wakonlukki kaikene mane.’ ");
INSERT INTO ons_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ea wane Yesu eŋe don rokop mane edane rake, “Naso maneo ware ware mane eŋe, kepe kiroino Ŋei Waom suainano ariwe, oŋo ŋei wawaine biranangi, so koso zinge sarikale, eŋe yalewa raki paki, kepe kiroino arike. ");
INSERT INTO ons_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Eŋe ea ariakane okane more, urata medewekoune 10 qedugu one more, goli wesi set mane, so goli wesi set mane korop ebone more rake, ‘Ŋine wesi iwa mau paki, bisnis urata ma, ma suaeu na koso zinge sarikale.’ ");
INSERT INTO ons_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ŋei suaine eŋe arikimo, matkoune eŋe eŋane bauene waki, qelit biraonbi ari, Ŋei Waom suaine iwa yale olatkoi, ‘Eŋe kepe ware wareze mi geakane ŋene ramaine!’ ");
INSERT INTO ons_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pakimo Ŋei Waom eŋe siluŋ kepe ware ware birakaki zinge sarike. Zinge more qelit medep wesi ebonge, eŋe iwa yale ra more edora waraŋonge, ‘Na wesi ŋibongole, ea ŋine urataine ma more ma leuleu darap wakonge?’ ");
INSERT INTO ons_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ŋei maneŋo alakane sari rake, ‘Waomne, na geŋane goli wesi setne wekuŋo bisnis ma more goli wesi setne 10 marat ongole.’ ");
INSERT INTO ons_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ŋei suaine eŋe olatke, ‘Ge wekumane okangone, ge qelit ŋei wele, ge wesi nigatne wareluk kamaine, ea wane na ge mat suaine 10 ware onikenane biraganikale.’ ");
INSERT INTO ons_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Qelit ŋeiine mane sari olatke, ‘Waomne, na geŋane goli wesi setne wekuŋo bisnis ma more, goli wesi setne 5 marat ongole.’ ");
INSERT INTO ons_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Eŋe qelit ŋei yewao olatke, ‘Na ge mat suaine 5 ware onikenane biraganikale.’ ");
INSERT INTO ons_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ŋo, qelit ŋei maneŋo sari olatke, ‘Waomne, geŋane goli wesi setne iwamo, na laplap koto motkekole, ");
INSERT INTO ons_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ge ŋei gereune aboŋ kine kine ŋei natneŋo mau wakongi, aboŋ ea ge ma okanmaine. Ŋei maneŋo eu ebotkiso, ge eu ea wane ŋara wele omaon okanmaine, ea wane na geŋane kaetnange.’ ");
INSERT INTO ons_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ŋei suaine King eaŋo olatke, ‘Ge qelit ŋei qotkoine, na geŋone don eaŋoka mainge more, koso don uratao biraganikale. Na ŋei gereune. Na ŋei mane wane aboŋ ma okanmaile. Me ŋei mane wane euo ŋine ŋara ma okanmaile, ge ea korop detkone. ");
INSERT INTO ons_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ge wesi ea onoka wane wesi urumgo mi motkone? Wesi ea paki, ŋei maneŋo yewa ŋine ma more bisnis mayake. Maki wakone paki, na zinge sarikaleo, eŋe wesi natne kutno niniake.’ ");
INSERT INTO ons_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ŋei waom eŋe ŋei natne yewao okorakoi, ea zinge edange, ‘Ŋine eŋano ŋine wesi setne ea omaka more, ŋei wesi setne 10 pa manmaike, eŋe manbi.’ ");
INSERT INTO ons_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ŋo, ŋei eŋe olatkoi, ‘Waomze, eŋe wesi setne 10 mo pa manmaike!’ ");
INSERT INTO ons_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ŋei waomŋo mainge edane rake, ‘Na ŋidanbe detpi, ŋei mane eŋe kine kine mo man mane, ŋo eŋe maine mage more urataine ma, ma leuleki, na ŋei yewa koso takotke manikale. Ŋo ŋei mane eŋe kine kine mo man mane ea nigatnemde magemaike, na ea omakaikale. ");
INSERT INTO ons_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ŋo naŋane ŋabakopne diao gemami, ŋei ŋerep eaŋo na wareonikalane mi siminonge, paki ŋei waom wano don mo motkoi, ŋine ŋei ŋerep ea korop ebu sari more, iwa naŋane kaitno enguwi korop seukwarekei!’” ");
INSERT INTO ons_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu eŋe yale ra more, ŋei ŋerep eŋano ŋine Yerusalem goken alakane arike. ");
INSERT INTO ons_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Eŋe Betpage matko so Betani mat osino bonaga mane Oliwa ea lotke more, dokoine eŋano ŋine etke alakane biraore, iwa yale etange, ");
INSERT INTO ons_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ŋire matko eriwa wa more dogi nigatne mane medeune mulapko lukkau okoraki kaikei, dogi ea ŋei maneŋo kutno mi metmele, ŋire ea ka more mulap siloke more, ma sarikeik. ");
INSERT INTO ons_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ŋo ŋei maneŋo qesonŋure rayake, ‘Ŋire ea onoka wane okanmamik?’ Rakiso, ŋire iwa yale olale raikeik, ‘Waomseŋo raki sari mamaite.’” ");
INSERT INTO ons_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yale ra etane more biraotki, ere ari Yesu eŋe don etane more kine kine rake, ea wane rokopko korop ongoik. ");
INSERT INTO ons_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ere dogi silokkauk so dogi welaine eŋe etane rakoi, “Ei, ŋire dalino okanikeik wane dogi ea silokkamamik?” ");
INSERT INTO ons_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ere don ea dere more edangoik, “Waomzeŋo raki sari mamaite.” ");
INSERT INTO ons_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yale ra more dogi ea Yesu wano ma sarikoik. Pakiso, eŋe momo takotetne dogi kutno lameke more, Yesu qesiŋkauk dogi kutno wa metke. ");
INSERT INTO ons_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu eŋe dogi kutno arikiso, ŋei ŋerep eŋe momo takotene ea kito qoke numao dogi kine gesoke ariake, eao lameke arikoi. ");
INSERT INTO ons_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pakimo, Yesu eŋe Yerusalem osino, Oliwa bonagaoken duma ket magekoi, eao lotkeki, yewao Yesu wane dokokoune magu suaine eŋe masi kine kine togole ongoi, ea wane eŋe Anutu wane eŋetine don aro uŋalan so oi bakom suaineŋo bukeu waki rakoi, ");
INSERT INTO ons_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Kepe ware ware iwa eŋe Waomŋo eŋine tungo birakaki sarimaike! Anutuŋo mosopkakep! Qeliwo peam pakep!” ");
INSERT INTO ons_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pakiso, Anutu wane papa togon welaine ŋei natne, Parisi, eŋe ŋei ŋerep magu keueno ŋine sari Yesu olatkoi, “Kito ebo ebon, ge dokoŋone ea edannom, doŋ manbi!” ");
INSERT INTO ons_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu eŋe donene turuŋine mainge edane rake, “Na ŋidanmaile, eŋe doŋ manikeiwo, yemo wesi edo iwa koso wie boka more Waom wane eŋet ora oi bakom okane rau, naŋane eŋetne wayake.” ");
INSERT INTO ons_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu eŋe Yerusalem mat osino ari more, Yerusalem so ŋei ŋerep eŋane ra more aroke more, ");
INSERT INTO ons_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","rake, “O Yerusalem, ŋine Anutu wane duma peamine ukude detluk kaikeiwo, ŋine maine numao ea mogare arikei. Ŋo ŋine maine mi desikei! ");
INSERT INTO ons_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yemo boaŋ ŋabakopŋine eŋe mat lolike sen qeŋunbi, ŋine matko ŋine maine mi sakesikei. ");
INSERT INTO ons_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Eŋe mat so ŋei ŋerep medewekopŋine korop matali ŋunwarekei, eŋe wesi mane mi qeligeu weti wesi kimainane kutno mesiake. Anutuŋo ŋine qesiŋ ŋuniakane sarike, ŋo, ea ŋine mi detluk kakoi, ea wane ŋabakopŋine eŋe ŋine mataliŋunwareu qamen qe payake!” ");
INSERT INTO ons_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pakiso, Yesu eŋe Anutu wane Bakom Urumgo waket more, ŋei ŋerep nalu qole qole urata ma metkoi, ea kieke esopone more, ");
INSERT INTO ons_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","edane rake, “Anutu wane ra rokop donŋo iwa yale ramaike, ‘Anutu wane Bakom Urum ea mo eŋine eŋetine ora raikei, meŋen meŋen urum okaniake,’ ŋo ŋine yemo yale okanbi, mo kobu ŋei eŋane mat okanmaike!” ");
INSERT INTO ons_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Boaŋ Yesu eŋe Anutu wane Bakom Urumgo kaiwe baŋem waket more, ŋei ŋerep kito ebonge. Mosop Ŋei Suaine Ŋetne so Anutu wane papa togon welaine ŋei, Skribe so ŋei ŋerep eŋane ŋetne, eŋe koropŋo numa mane maratka Yesu qeu seukeakane zia ziaŋ urata makoi, ");
INSERT INTO ons_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ŋo numa mi maratkakoi. Ŋei ŋerep magu eŋe Yesu wane don detokangoi, eŋe don rake, yewa mi qeliŋ kawarekoi, ea wane Yesu wane ŋabakoune eŋe numa ziageu paki maine mi qekoi. ");
INSERT INTO ons_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kaiwe maneo, Yesu eŋe Anutu wane Bakom Urumgo okora more, ŋei ŋerep magu biŋek don edange, pakiso Anutu wane mosop ŋei suaine ŋetne so Anutu papa togon welaine ŋei, Skribe, so Yuda ŋei suaine eŋe sari, ");
INSERT INTO ons_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yesu qesonka rakoi, “Ge yatne Anutu wane Bakom Urum koto qole qole ŋei esoponine, ea maŋo ra golatki okanine? Ge maŋo biragange?” ");
INSERT INTO ons_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu eŋe yale waka mainge edange, “Na yaleka ŋine qeso qeson weku qesonŋunbe, nolatpi. ");
INSERT INTO ons_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohane doku tau tau wane urata, ea qeliwo ŋine wakonge, me ŋeiwo ŋine wakonge?” ");
INSERT INTO ons_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eŋe yale ra qesonongi, eŋe dere more eŋe edomka sorin nagukoi, “Daleo raikene? Ŋene raikene, ‘Ea Anutu wano ŋine wakonge,’ yale ra olatŋem, eŋe rayake, ‘Ŋine onoka wane ea mi dere malipkakoi.’ ");
INSERT INTO ons_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ŋo, ŋene raikene, ‘Ea ŋeiwo ŋine wakonge,’ eamo ŋei ŋerep magu eŋe mo detmami, Yohane eŋe Anutu wane qelit ŋei mane, ea wane ŋene wesiŋo ŋenguwi seukkene.” ");
INSERT INTO ons_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ea wane, eŋe don iwa yale mainge olatkoi, “Yohane wane urata ea diao ŋine wakonge, ŋene mi detmaine.” ");
INSERT INTO ons_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eŋe yale rauso, Yesuŋo edange, “Na yalewaka maŋo nolatki okanile, ea na maine mi ŋidanikale.” ");
INSERT INTO ons_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pakiso, Yesu eŋe don rokop iwa yale edane rake, “Naso maneo, ŋei maneŋo wain eu ebore, eu yewa ŋei natne eŋane meteeno motki, edo urata yewa ware mageu, eŋine ea qelige lobo kepe amaŋ yewao ari geke. ");
INSERT INTO ons_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Yewa ari geki wain wele menagi, eu welaine eŋe qelit medepine mane birakaki, eu ware warekoune eŋano ariki, eŋe wele natne manbi, ma sariakane arike. Ŋo eu ware ware eŋe wie qelit medep yewa malipka kiŋ quŋ qe esopkau, eŋe zinge yaup metineka arike. ");
INSERT INTO ons_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Arikiso, eu welaine eŋe qelit medep mane koso birakaki sariki, ea eŋe yalewaka manerop matalika esopkau, eŋe zinge metineka arike. ");
INSERT INTO ons_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pakiso, eŋe soringe, koso qelit medep mane birakaki ariki, eŋe koso ziwem qe esopkakoi. ");
INSERT INTO ons_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pakiso, eu welaine eŋe rake, ‘Na dalino okanikale? Na siluŋ koso giponane wekuku wemedep iwa birakaikale, eŋe naŋane medep nae kotoo ŋine, ea wane aŋaine maine teweke more ewine kitokei!’ ");
INSERT INTO ons_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ŋo eu ware ware ŋei eŋe medep yewa ka more, auye rakoi, ‘Medep yewa eŋe ge mage, magainane eu iwa ŋebu ma more, ea wane welaine okane wareoniake, ea wane ŋene qeŋem seukkiso, ŋedo eu iwa wane welaine okane warekene.’ ");
INSERT INTO ons_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ea wane eŋe ma more euo esopka ari mage qeu seukke.” Yesu eŋe raki qoeki, qesonone rake, “Pakimo eu welaine eŋe ware ware ea korop daleo okanoniake? ");
INSERT INTO ons_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eŋe sari eu ware ware yewa korop enguki seukwarekei. Pakimo eŋe koso eu ware ware musele ma wakone biraoniake.” Ŋei ŋerep eŋe don ea dere more rakoi, “Eŋe masi yale mi mayake, midakaka!” ");
INSERT INTO ons_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesuŋo eŋano lolike pore more, qesonone rake, “Ŋine Anutu wane papia iwa wane kine mi detlukkamami, ‘Mat mama urata ŋei eŋe mat wane bosiŋ mane ea edo pelekine ra more, qikka more yeine birakoi, wane ŋado Anutuŋo bosiŋ ea maki mat wane banega bosiŋ togogole mane okange.’ ");
INSERT INTO ons_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Na ŋidanmaile, ŋei maneŋo banega bosiŋ ea wane kutno ket rasuyakeo, eŋane solaine korop sisi sisi kitatwareake, so bosiŋ eaŋo ŋei mane kutno kesiakeo, eŋe rasu pelelekki siukeake.” ");
INSERT INTO ons_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesu eŋe yale ra edangi qoekiso, Anutu wane mosop ŋei suaine ŋetne so Anutu wane papa togon don wane welaine ŋei, eŋe Yesu malipka wokom kaikei wane okangoi, ea mo eŋe detpi, Yesu eŋe don rokop ea eŋano more rake, ea wane. Ŋo ŋei ŋerep eŋe Yesu wane don dere siminonge, yewa wane Yuda ŋei ŋetne eŋe kaetongi, Yesu qeliŋkakoi. ");
INSERT INTO ons_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yuda ŋei ŋetne eŋe sotene osike, paki eŋe numa mane maratka more, Yesu liewkkaikei wane zuangoi. Eŋe yale okane ŋei natne wesi ebone more edangoi, “Ŋine Yesu wano ari qeso qeson isisine liwek kaikei wane arikei.” Eŋe Yesu Roma kepe ware ware suainane, ŋei waom Yuda kepeo geke, eŋane meteo birakaikei wane okangoi. ");
INSERT INTO ons_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ŋei isisine eaŋo Yesu wano ari olatkoi, “Kito ebo ebon, ŋene ge detganmaine. Ge ŋei ŋerep koboboine kito edanmaine. Ge ŋei mane wane mi kaetgan okanmaike. Ge ŋei ŋerep natne don mane edane more, ŋei ŋerep magu natne mane mi edane okanmaine. Ge don wele so Anutu wane masi koboboine ŋei ŋerep korop sikanon okanmaine. ");
INSERT INTO ons_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ŋenze ra rokop donze ea wane ge dalino detmaine? Maine ŋene takis Roma kepe ware ware suaine manikene, me mida?” ");
INSERT INTO ons_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ŋo Yesu eŋe isisiene ea mo detone more, edane rake, ");
INSERT INTO ons_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ŋine wesi yewa mane ma sari sikannanikei.” Yesuŋo wesi ea ka more qesononge, “Oŋa oŋa wesi solaino iwa so eŋet iwa maŋane?” Eŋe rakoi, “Kepe ware ware suaine, Sisa eŋane!” ");
INSERT INTO ons_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pakimo, Yesuŋo eŋane donene mainge rake, “Ŋine kepe ware ware suainane kine kine biŋek ea maine eŋe eŋine manikei. Ŋo, Anutu wane biŋek kine kine ea maine Anutu eŋe eŋine manikei.” ");
INSERT INTO ons_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yewao ŋei ŋerep eŋane kaitko, Yuda ŋei ŋetne eŋe koso maine mi liwek kakoi, eŋe yeine oŋaene qaekiso, mepene qoeki metkoi. ");
INSERT INTO ons_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi natne eŋe Yesu wano sarikoi, tego yewa eŋe ra okangoi, ŋei seu seune eŋe koso mi wisikae wiekei, ea wane eŋe Yesu qesonka rakoi, ");
INSERT INTO ons_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Kito ebo ebon, Moseŋo don mane iwa yale qeke, ‘Ŋei mane eŋe seukkeake, eŋe medeune midaine, ŋo, ŋanomine eŋe yeka geake, pakimo, ŋei seukke eŋane ŋole eŋe tatine qesiŋka more, ŋerep yewa oŋo koso ma more, medep mane tatinane tungo geakane ma wakoniake.’ ");
INSERT INTO ons_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ŋenane dogisi iwa detnom, naso maneo, tatiŋon 7 yale eŋe gekoi, wane tatene suaine eŋe ŋerep mage more, medep mane mi ma wakone more, eŋe yaupka seukke. ");
INSERT INTO ons_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pakimo, ŋole kebaŋine oŋo tatinane mala ea make, eŋe yaleka medep mane mi ma wakone more, eŋe yaupka seukke. ");
INSERT INTO ons_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pakimo, ŋole ŋorikine eŋe yalewaka okange, yalewaka tatiŋon 7 yewa eŋe ŋerep yewa makoi, ŋo medep mane mi ma wakone more, eŋe yaup seukwarekoi. ");
INSERT INTO ons_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pakimo, ŋerep yewa eŋe yalewaka boaŋ ŋado ge mage more seukke. ");
INSERT INTO ons_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ea wane boaŋ ŋei seu seune eŋe wisikae wiekei, naso yewao ŋerep yewa eŋe maŋane ŋerep biŋek okaniake? Ŋei tatiŋone 7 eŋe ŋanomene weku yewa makoi.” ");
INSERT INTO ons_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu eŋe don kisi dere more mainge edange, “Kepo naso iwao, ŋei so ŋerep eŋe ŋao ŋanom gemami, ");
INSERT INTO ons_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ŋo ŋei so ŋerep koboine okanmami, Anutuŋo eŋe deŋesereo ŋine maki wisikae wiekei, naso yewao, eŋe koso ŋao ŋanom mi gekei. ");
INSERT INTO ons_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Eŋe qeliwo aŋelo yale gekei, eŋe maine mi seukkei, Anutuŋo ŋei ŋerep ea deŋesereo ŋine maki wisikae wiekei, naso eao eŋe Anutu wane medewekoune okanikei. ");
INSERT INTO ons_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ŋei seu seune eŋe wisikae wiekei, eŋane don mo Moseŋo kibiwo qeke eaŋo sikanŋonmaike, eki nigatne zeke, naso yewao Waom Anutu wane iwa yale ra more qeke, ‘Eŋe Abraham wane Anutu, so Isak wane Anutu, so Yakop wane Anutu gemaike. ");
INSERT INTO ons_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anutu eŋe ŋei wisika gemami, eŋane Anutu, eŋane deo ŋei ŋerep eŋe korop ge waremami. Eŋe ŋei seuseune eŋane midakaka.” ");
INSERT INTO ons_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yale rakiso Anutu papa togon welaine ŋei natne, Skribe, eŋe olatkoi, “Kito ŋebo ŋebon, ge don ea wekumane ramaine!” ");
INSERT INTO ons_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ŋo Sadusi eŋe zonomene midaki kaet okane more eŋe koso qeso qeson mane mi qesonkakoi. ");
INSERT INTO ons_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pakiso, Yesu eŋe ŋei ŋerep qesonone rake, “Ŋei natne eŋe dalino Mesia wane ramami, eŋe Dawit wane ŋaboine kepeo ŋineka? ");
INSERT INTO ons_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawit oŋomka Sam papiao qeke, ‘Anutu Magak Suaineŋo naŋane suaine Mesia iwa yale olatke, ge naŋane wonnoken mesikene, ");
INSERT INTO ons_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ŋado noŋo geŋane ŋabakopŋone, eŋe ea biraonbe, geŋane kieŋonane bano mesikei.’ ");
INSERT INTO ons_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawit oŋom Mesia iwa yale orake, ‘Naŋane Waom suaine,’ ŋo, ŋei natne naso iwao gemami, eŋe ra okanmami, Mesia eŋe Dawit wane ŋaboine kepeo ŋineka. Mi kopkemaike! Kristo eŋe Dawit wane ŋaboine so Anutu wane gipole weneŋ.” ");
INSERT INTO ons_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ŋei ŋerep magu eŋe Yesu wane don dere metpiso, Yesu eŋe zinge dokoine edange, ");
INSERT INTO ons_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ŋine Anutu papa togon welaine ŋei, Skribe, eŋane kaulukkei. Eŋe takot kiroine kibinerop bira more arikei wane siminon okanmaike. Eŋe lewa lewaŋ sobego geu ŋei ŋerep edo one mawa one more, eweene kitou ge okanmami, ea siminonmaike. So epa kebu eao, so Yuda lewa lewaŋ urum koto eŋe metmet ŋetno mesikei wane okanmami. ");
INSERT INTO ons_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yale okane more, ŋerep mala isione more, eŋane mat omaon okanmaŋkei. Omaone more, eŋe ari Anutu wane Bakom Urum koto ŋei ŋerep eŋane deo okora, Anutu wano meŋe meŋen kiroroine meŋenka okanmaŋkei. Ŋei yaline yewa eŋe ge mage ŋado Anutuŋo wikile suaine eboniake.” ");
INSERT INTO ons_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Naso yewao, Yesu eŋe Anutu wane Bakom Urum wane wesi katapa osino metke. Mere ŋei wesi aboŋene suaine ongi, eŋe wesi motkoi. ");
INSERT INTO ons_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pakimo, ŋerep mala aboŋine nigatnemde, eŋe sari toea etke biraki ketki, Yesu eŋe ka more, ");
INSERT INTO ons_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","dokoine edange, “Ŋerep mala aboŋine nigatnemde ea eŋe ŋei wesi aboŋene suaine eŋane bakom ea yuanonmaike. ");
INSERT INTO ons_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ŋei wesi aboŋene suaine pake, eŋe ea ŋine nigatnemde natka ma more motkoi, ŋo ŋerep mala iwa eŋe wesi korop loutne mane mi pamange, ŋo eŋe mo ea biraki midakakae.” ");
INSERT INTO ons_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Anutu wane Bakom Urum wane kino so solaino wesi suaine, wekumane so ŋei eŋe bakom Anutu wano mangoi, ea Yesu wane dokoine eŋe one more, weku mane rakoi, ŋo Yesu eŋe ea dere more edange, ");
INSERT INTO ons_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Naso kutno ŋei ŋaba natne eŋe sari, ŋine kine kine iwa onmami, ea eŋe korop baŋ mataliwarekei, eŋe wesi mane mi qeliŋgeu, weti kutno mesiake, midakaka! Eŋe baŋ din bun kitopok qepok mau, ket ari ware mida leleake.” ");
INSERT INTO ons_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesu eŋe yale raki, dokoine eŋe qesonka rakoi, “Onokaka kine kine maneŋo mikepka wakone sikanŋongi, ŋene ea ka more raikene, Anutu wane Bakom Urum mo wiriakane nasoine bomilemaike?” ");
INSERT INTO ons_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu eŋe edane rake, “Ŋine kaulukkei! Ŋei loutne eŋe isiŋunikei wane sarikei, eŋe sari more, naŋane eŋetko more isiu paki raikei, ‘Na Mesia’ , me ‘Naso ea mo bomilemaike.’ Ŋo, ŋine eŋe misuk mogatonikei. ");
INSERT INTO ons_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ŋine kawali wane don siron desikei, ŋo ŋine misuk kaetŋuniake. Kawali so kine kine yale alakane wakoniake, ŋo qeli kepe nasoetne ikop mi qoeake.” ");
INSERT INTO ons_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Eŋe koso edane rake, “Mat mane eŋe wie ari, mat mane eŋerop kawali yaku matali okan nagukei. Ŋei ŋerep kepe maneo ŋine, eŋe ari kepe maneo eŋerop yaku matali qetali okanikei. ");
INSERT INTO ons_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kepe loutne memea suaine ma paki, ŋara wane bodi wakoniake. zoma kine mane kine mane loutne wakoniake. Kine kine mi kakaine, ea qeliwo wakongi, ea wane ŋine misuk kaetŋuniake. ");
INSERT INTO ons_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Alakane ŋabakopŋine eŋe ŋine ŋibu ari matali ŋunikei, eŋe ŋine Yuda lewa lewaŋ urum koto dongo biraŋunbi so mulap urumgo wakesikei, so naŋane ra more ŋine kepe ware ware ŋei so ŋei waom wane matko wakesikei. ");
INSERT INTO ons_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Naso eao ŋine numaŋine wakongi ŋine naŋane biŋek don maine ra qelaŋanikei, ");
INSERT INTO ons_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ŋine ŋei ea wane deo wakesikei wane, dere mezet misuk okane raikei, ‘Ŋene dalino edanikene?’ ");
INSERT INTO ons_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Na weneŋ ŋinerop sanka don ŋidanbe edanikei, don ea weku mane dereretinerop, ŋabakopŋine maine mi rawetonikei. ");
INSERT INTO ons_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Naga magaŋine so tatŋine ŋonŋine so weŋem sotakŋine so kimakopŋine, eŋe ŋabakopŋine eŋane meteeno biraŋunbi paki, ŋine natne ŋinguwi seukkei. ");
INSERT INTO ons_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Naŋane ra more ŋei ŋerep korop ŋinane ŋabakopŋine okanikei. ");
INSERT INTO ons_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ŋo ŋinane lewetŋine zoune mane ea mi siukeake, ");
INSERT INTO ons_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ŋine togole malipka okorau paki, ŋine sora gerepko mane mi kesikei. ");
INSERT INTO ons_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kawali ŋei magu loutne eŋe Yerusalem lolikkaikei, eao raikei, ‘Yerusalem boriakane nasoine bomilemaike.’ ");
INSERT INTO ons_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pakimo, ŋei ŋerep Yuda kepeo ŋine kaet okane more, biririke ket bonagao ariu! Ŋei ŋerep natne eŋe mat suaino mere more, ket qeliŋka more wazaino ariu! Ŋei ŋerep natne eŋe mat wazaino mere more, koso matko misuk zinge koso mat koto wakesikei, ");
INSERT INTO ons_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Anutu wane papiao ramaike, ‘Wikile Naso Wakoniake, ‘ naso eao kine kine Anutu wane papiaŋo ramaike, ea weneŋ korop wakonwareake. ");
INSERT INTO ons_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ŋerep natne eŋe ŋatkekei, so ŋerep eŋe kokorop mesikei, eaŋo wikile suaine desikei, wikile suaine zok manerop kepo iwa watke rokopkayake, Anutuŋo ŋei ŋerep yewao eŋe wikile suaine eboniake. ");
INSERT INTO ons_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kawali ŋei eŋe ŋei ŋerep natne enguwi seukkei, so ŋabakopze eŋe ŋei ŋerep natne mulap urum kepe maneo biraonikei. Qelaŋ ŋei ea eŋe Yerusalem mat suainane kutno gesokpi barakeake. Anutuŋo qelaŋ ŋei nasoene mo motke, ea wane rokopko ari mage qoeake. ");
INSERT INTO ons_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Anutuŋo kaiwe, meso, serekin eŋano, kine kine mi kakaine, ma wakoniake. Ŋei ŋerep korop kepe baŋem kepe baŋem dereretene siukeake. Eŋe dibom suaine kiwetko wiriki ukatne detpi kaetoniake. ");
INSERT INTO ons_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ŋei ŋerep eŋe kine kine mi kakaine kepeo wakoniakane tomakau, so qeliwo ukatke more qiseki kaet okane, deene lolike kepeo ket rasukei. Naso eao Anutuŋo kaiwe, so meso, so serekin qeliwo pamami, eŋe ra buratkeki kesikei. ");
INSERT INTO ons_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pakimo, Ŋei Wawainane Gipole kezoŋ kutno qelaŋane suaine so qeli ewe zonominerop sariake. ");
INSERT INTO ons_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kine kine ea kieke wakoniake, ŋine wie qeliwo pore kaikei, pakimo naŋane dereret gemami, ŋine ma menaŋ ongalane nasoine ea bomileake.” ");
INSERT INTO ons_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu eŋe don ea raki qoeki don rokop mane edange, “Ŋine fik eki so eki welerop natne detmami. ");
INSERT INTO ons_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Eŋane metene posi qake more musele yabiki, ŋine ka more raikei, kaiwe naso bomilemaike. ");
INSERT INTO ons_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yalewaka ŋine kine kine mi kakaine wakongi, ka more raikei, ‘Anutuŋo wareŋonmaike, so eŋane qeli ewe zonom wakoniakane, ea wane naso bomilemaike.’ ");
INSERT INTO ons_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Detsorokkei! Ŋei ŋerep natne eŋe naso iwao mi seukeu, kine kine korop yewa wakon wareake. Wakon wareki qoeki, naso yewao seukkei. ");
INSERT INTO ons_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kepe so qeli ere mo ea nasoetne qoeki midakeik, ŋo naŋane don yemo mi midayake. ");
INSERT INTO ons_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ŋine kine kine kaulukkei, ŋine ŋara me doku loutne ne more wet niget misuk okane gekei. Ŋine gege wane misuk dere umarekei. Ŋine wet niget yale geu naŋane nosone ikopka sariki oŋaŋine qaeyakane. ");
INSERT INTO ons_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ŋei ŋerep korop kepe baŋem eŋe naŋane naso ea wakongi desikei. ");
INSERT INTO ons_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ŋine naso baŋem wisikae more diam mo okorau, so Anutuŋo zonom ŋibongi togole okorakei wane meŋenkaikei, ŋine zonomŋine weneŋ wikile naso yuanka more Ŋei Wawainane Gipole eŋane kaitko kine kine yewa korop wakon wareki togogole okorakei, ea wane meŋen kaikei.” ");
INSERT INTO ons_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Naso yewa kaiwe okangi, Yesu eŋe ŋei ŋerep Anutu wane Bakom Urum koto kito ebonge paki, kepe qoeki, eŋe mat suaine qelige, ruoo ari bonaga Oliwa yewao metke. ");
INSERT INTO ons_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kaiwe baŋem, sakoka kepe qae qae naso ŋei ŋerep korop Anutu wane Bakom Urumgo ari lewage more, Yesu wane don detkakoi. ");
INSERT INTO ons_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bret Patpale peada naso ea bomileke, peada ea wane eŋetine mane, Aŋelo Loloŋon Loloŋon peada. ");
INSERT INTO ons_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Naso yewao ŋei ŋerep korop Yesu wane siminonge, ea wane mosop ŋei ŋetne suaine so ra rokop don ware ware, so Anutu wane papa togon welaine ŋei, Skribe, eŋe numa mane maratka more Yesu sanka qeu seukeakane, nia ziaŋgoi. ");
INSERT INTO ons_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pakiso, Satanŋo Yudas wane kotino wa ketke. Yudas eŋe Yesu wane dokoine 12 eŋane keueno ŋine mane, eŋetine mane Iskariot. ");
INSERT INTO ons_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yudas eŋe Yesu dokoine qeliŋone more, mosop ŋei suaine ŋetne so Anutu wane Bakom Urum wane tebe ŋei ŋetne, eŋano ari more Yesu mawakonka more, eŋane meteeno birakayakane edange. ");
INSERT INTO ons_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eŋe detpi siminongi, wesi manikei wane olatkoi. ");
INSERT INTO ons_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas eŋe oŋ ra more, Yesu sanka ma wakonkayakane numaine mane kieke dere maulukke. ");
INSERT INTO ons_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bret patpalane soda weku, kaiwe mane Yuda edo aŋelo loloŋon loloŋon wane lama qe okanmaŋkoi, ");
INSERT INTO ons_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ea wane Yesu eŋe Petoro so Yohane biraore etange, “Ŋire ari aŋelo loloŋon loloŋon peada wane ŋara soep nekenane maulukpik.” ");
INSERT INTO ons_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ere Yesu qesonka rakoik, “Diao ŋere ŋara soep ea ari maulukete?” ");
INSERT INTO ons_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu mainge etange, “Ŋire ari Yerusalem waket more, ŋei mane kauk doku tin teweke sari numao marat ŋusiake. Ŋire ŋei ea mogatka ariuk. Eŋe ari matko wakesiake, ŋire yewa ari waket more, ");
INSERT INTO ons_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mat welaine iwa yale olasikeik, ‘Kito ŋebo ŋebonzeŋo ramaike, Naŋane mat aŋaone diawao Aŋelo Loloŋon Loloŋon Peadao na mere dokone eŋerop ŋara nekene?’ ");
INSERT INTO ons_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yale ra qesonkauk, eŋe urum ea aŋaone mane suaine kutno weti metmet so zake kine kine mo mauluk maulukine sikanŋutki, yewao ŋire ŋaraze maulukkeik.” ");
INSERT INTO ons_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ere qelika more Yerusalem ari lotke more, Yesuŋo etange, yale ŋei maratka more, kine kine korop maratkauk paki, ere Aŋelo Loloŋon Loloŋon Peada wane ŋara soep maulukkoik. ");
INSERT INTO ons_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Naso mo qoekiso, Yesu eŋineso eŋane qelit ŋeikoune aposolo magu korop mat koto waket, zakeo ŋara ne metpi, ");
INSERT INTO ons_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesu eŋe edane rake, “Na ŋinerop Aŋelo Loloŋon Loloŋon ŋara soep nekalane zok manerop simin nanmaike, qoeki na wikile desikale. ");
INSERT INTO ons_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Na ŋidanmaile, naso kutno na Aŋelo Loloŋon Loloŋon ŋara soep koso mane iwa ŋinerop mi nekale, ŋo Anutuŋo waremaike, naso eao Aŋelo Loloŋon Loloŋon Peada wane kine watke rokopkeake, paki na ŋara soep ea koso nekale.” ");
INSERT INTO ons_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pakimo Yesu eŋe wain lase ma more, Anutu bakom kito more edange, “Ŋine wain iwa ma ama naguwi, ");
INSERT INTO ons_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","na ŋidanmaile, na ŋado koso mi nene gewe, Anutu wane qeli ewe zonom wakonlukeake, naso eao koso nekale.” ");
INSERT INTO ons_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pakimo eŋe bret nat parom ma more, Anutu bakomine kito more, mapoke dokoine ebone more edange, “Iwa na bikumne, na solane ŋinane ra more qikkamaile, ŋine bret iwa ne more, naŋane seu seune detsorokkei.” ");
INSERT INTO ons_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Neu qoekiso, Yesu eŋe wain lase ma more ebone rake, “Wain lase iwa naŋane weŋemne, na weŋemne ŋinane ra more qakmaile, na weŋemne ea Anutu wane tako rakot musele ma togoleake. ");
INSERT INTO ons_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","”Ŋo ŋine detpi, ŋei na kima isisi okan nangi neu more nekukei eŋe iwa zakeo narop weneŋ metmaite! ");
INSERT INTO ons_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ŋei Wawainane Gipole, eŋe dalino seukeake, ea Anutuŋo mo ma togole rake, ŋo ŋei eaŋo Ŋei Wawainane Gipole doplukka more, wikile zok manerop baŋ desiake!” ");
INSERT INTO ons_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pakiso, dokoine eŋe don auye rakoi, “Maŋo ŋenane keuzo ŋine doplukayake?” ");
INSERT INTO ons_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesu wane dokoine eŋe donene qeu kere pora okangi, auye kitat okan nagu more rakoi “Ŋenane keuzo ŋine maŋo ŋetne me wawaineze okanmaike.” ");
INSERT INTO ons_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu eŋe detone more edane rake, “Qelaŋ ŋei waom eŋe ŋei ŋerepkopene wikilerop wareon okanmami. Ŋo ŋei ŋerewekopene eŋe ŋei waomkopene eŋane bango tamge more qelitene qe okanmami, ea wane eŋe don kelok okanka more, eŋe ‘Ŋei maine kine kine weku maneka okan okanmaike, ‘ yale ra mawaka magemami. ");
INSERT INTO ons_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ŋo ŋido masi tanik ea misuk okanikei, midakaka! Ŋinane keuo ŋine maneŋo suaine me ŋetne okanbe raso, eŋe kimakoune eŋane bango ketkele so umi qe geake, so eŋe kimakoune natne ŋinane qelit qeqe urata ma geake. ");
INSERT INTO ons_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Me ŋine rau, maŋo me diawaŋo ŋetne okanmaike? Ŋei yaup metmeleka taboŋ mere neake, oŋo ŋetne, me ŋara mire mot ma ari sari qelit qe ma okanmaike, oŋo ŋetne? Ŋei metmetkoka taboŋ mere yaup nenineka nemaike, oŋo ŋetne. Ŋo noŋo yemo ŋinane keuo qelit qeqe urata ma gemaile. ");
INSERT INTO ons_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Na liwe liwek so umat kine kine wakon nange, ŋine umat ea wane ra mi kaetŋungi, biranangoi, ŋine narop naso baŋem ge sarikoi. ");
INSERT INTO ons_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ea wane Magak eŋe na eŋine tungo qeli ewe zonom warekalane ware ware biranange, so na yale waka, ŋine naŋane tungo qeli ewe zonom warekei wane ware ware biraŋunikale. ");
INSERT INTO ons_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ea wane ŋine baŋ ŋado naso maneo qeli ewe zonomnane kotino, ŋine metmet maine mere ŋara doku maine nekei, so metmet mayakakatne mere Israel magu 12 wareonikei.” ");
INSERT INTO ons_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Pakiso Yesu eŋe Petoro iwa yale olatke. “Saimon, Saimon! Detnom! Ŋeiŋo rais me wit woune ma wanokŋem, sinoine eŋineka ŋo wele eŋine okan okanmaike, Satan eŋe mo rake, eŋe mali malipŋine liwekkayake, yemo yalewaka Anutu wano ŋine korop ŋibu more wikile kine kineŋo liwekoniakane mo ra togoleke. ");
INSERT INTO ons_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ŋo na geŋane ra more mo meŋenkakole, ge na malipnane more mi ket qe more siukene, pakiso ge umat yewa yuane more, koso zinge sari kimakopŋone eŋane zonomene manom togoleake!” ");
INSERT INTO ons_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petoroŋo mainge iwa yale olatke, “Waomne, na geŋane ra more mulap urumgo maine wakesikale, eŋe ge gekuwi seuknom, na yale waka nekukei wane okanbi, ea maine, na mo ewekmaile.” ");
INSERT INTO ons_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesuŋo dere more olatke, “Petoro, na golatmaile, ukude ruo iwao tiak ŋeiŋo bokaki mi qoeki, goŋo atak karewe bisop nanikene.” ");
INSERT INTO ons_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pakiso, Yesu eŋe dokoine qesonone rake, “Sogino, na ŋine wesi, kite, kie kulit mida arikei wane biraŋungole, naso ea ŋine ŋara wane seukkoi?” Dokoine eŋe olatkoi, “Mida! Ŋara mo rokopzo ma gekone.” ");
INSERT INTO ons_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu eŋe doneene dere more mainge rake, “Ŋo naso iwao, na ŋidanbe, ŋinane wesi me kite pamami, ŋine mau. Ŋinano ŋine ŋei maneŋo sobaine mi pamaike, eamo momo takot maine qele more, wesi ea ma more soba qoleake. ");
INSERT INTO ons_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na ŋidanmaile, Anutu wane papiaŋo naŋane iwa yale ramaike, ‘Ŋei ŋerep eŋe Mesia detkakei, eŋe mulap ŋei.’ Anutu qelit ŋei don ea naŋane ra more qeke, ea wane don rokoune ea mo baŋ wakonwareake.” ");
INSERT INTO ons_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Dokoine eŋe don ea dereluke olatkoi, “Waomze, kanom! Soba etke pamamik!” Pakiso Yesu eŋe rake, “Ŋine soba wane don ea yeine qeliŋgei!” ");
INSERT INTO ons_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu done raki qoeki, so eŋine so dokoine Yerusalem qelige Oliwa bonagao arikoi, eŋe mo arimaŋkoi, yalewaka eŋe bonaga ea arikoi. ");
INSERT INTO ons_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ari lotke more, Yesu eŋe dokoine edange, “Ŋine Satan wane isi donŋo mi matali ŋuniakane meŋenkaikei.” ");
INSERT INTO ons_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pakiso, eŋe amaŋ nigatne ari iwa yale meŋenkake, ");
INSERT INTO ons_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Magak, na wikile mane desikale, ge wikile ea maine oma nanikene me? Ŋo ge naŋane simile mi mogasikene, midaka! Ge geŋone simileŋone mogare ma warekene.” ");
INSERT INTO ons_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Meŋenkaki, so aŋelo mane qeliwo ŋine sari more maki zonomine togoleke. ");
INSERT INTO ons_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","So Yesu eŋe manerop dere umare more, togogoleka meŋe meŋen urata make, pakimo seriŋanineŋo wiri weŋem leleke so kepo ket qake arike. ");
INSERT INTO ons_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Eŋe meŋenkaki qoeki, okora more medewekoune eŋano zinge arike. Ari more ongi, eŋe qomene zok manerop umareki, kulu pakoi. ");
INSERT INTO ons_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Pakimo Yesu eŋe ari dokoine ma wirikone more edane rake, “Ŋine daleo wane kulu pamami? Ŋine wieu paki, meŋenkau. Ŋinano Satan wane liwe liwek wakongi ket gekei wane meŋenkau!” ");
INSERT INTO ons_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu eŋe yaleka ra okoraki, dokoine 12 eŋane keuo ŋine mane Yudas eŋe magu suaine eŋerop lotke more, Yesu wane osino sari muzupkake. ");
INSERT INTO ons_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ŋo Yesuŋo olatke, “Yudas, ge na muzupnane more, Ŋei Wawainane Gipole eŋe ŋabakoune eŋano dopluk kamaine!” ");
INSERT INTO ons_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pakiso, dokoine eŋe kine kine wakoniake, ea dere more Yesu qesonka rakoi, “Waomze, ŋene eŋe sobaŋo maine engukene?” ");
INSERT INTO ons_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yale rauso, dokoine eŋano ŋine maneŋo mosop ŋei suainane qelit medep mane eŋane ketine wongo sobaŋo kitatki ketke. ");
INSERT INTO ons_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesuŋo yale ka more olale rake, “Ŋine yale misuk okanikei.” Eŋe metine mawa ŋei ea wane ketine more ma menaŋkake. ");
INSERT INTO ons_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mosop ŋei suaine ŋetne, so Anutu wane Bakom Urum wane tebe ŋei ŋetne, so Yuda ŋei suaine, eŋe magu eŋerop sarikoi, Yesu eŋe eŋine so dokoine onbi edange, “Ŋine koak, sobarop luknan gekei wane sarimami, na kobu ŋei midaka, ");
INSERT INTO ons_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","na kaiwe baŋem Anutu ware Bakom Urum kotino ŋinŋinerop okorakole, naso yewao ŋine mi malipnane luknangoi. Anutuŋo kine kine ea wakoniakane rake, ea ŋine maine maikei. Naso iwao ŋine kine kine Satan wane panaman zonominerop mau wakongep!” ");
INSERT INTO ons_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yale rakiso, eŋe Yesu malipka metine wokomka more, Mosop Ŋei Suaine Ŋetne wane matko iwenka arikoi, ŋo Petoro eŋe Yesu ŋadino mogatkake. ");
INSERT INTO ons_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ŋei natne eŋe sen koto mat ea wane osine gerep mau zeki, qenagare metpi, Petoro eŋe weneŋ sari ea gerep qenagare metke. ");
INSERT INTO ons_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pakiso qelit ŋerep maneŋo Petoro gerepko metki pore ka more togogoleka boka rake, “Ŋei iwa Yesurop wetneŋ geke!” ");
INSERT INTO ons_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ŋo Petoroŋo bisopka rake, “Ŋerep, ŋei ea mi detkamaile.” ");
INSERT INTO ons_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Naso bamgo qoeki so, ŋei maneŋo Petoro ka more olatke, “Ge Yesu wane tegoo gekone!” Ŋo Petoroŋo mainge olatke, “Ge detnom, na midakaka!” ");
INSERT INTO ons_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mi azongiso, ŋei maneŋo Petoro ka more, ŋei ŋerep magu togoleka edange, “Ŋei iwa eŋe Galili ŋine, eŋe welekatne Yesurop weneŋ ge okange.” ");
INSERT INTO ons_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ŋo Petoroŋo mainge olatke, “Ge detnom! Na geŋane don ramaine ea mi dere qelaŋanmaile.” Eso yewaka, Petoro eŋe don ea raki mi qoeki, tiak eŋe bokake. ");
INSERT INTO ons_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pakiso Yesu eŋe amaŋ okora more zinge Petoro porekake, porekaki, Petoroŋo Yesu wane don detsorokke. Yesuŋo qei bano mo iwa yale rake, “Tiakŋo bokaki mi qoeki, goŋo na atak karewe bisop nanikene.” ");
INSERT INTO ons_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petoro eŋe don ea detsoroke more, ari wetine tabaeki zok manerop aro kakapa suaine arokke. ");
INSERT INTO ons_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ŋei natneŋo Yesu mau paki, wareka more Yesu wane wawaine don isi bela okanka more qe kito okankakoi. ");
INSERT INTO ons_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","So eŋe Yesu wane deine laplapŋo piseka more qesonka rakoi, “Ge Waom wane ŋei dereret korop, wawaine gemaineo, ge ra qelaŋanikene! Maŋo gekumaike?” ");
INSERT INTO ons_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Eŋe Yesu wane wawaine don so don qotkoine natne loutne manerop takotke ra okankakoi. ");
INSERT INTO ons_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kepe qaeki, Yuda ŋei suainekopene, so Mosop Ŋei Suaine Ŋetne, so Anutu papa togon welaine ŋei, Skribe, eŋe korop lewage more, tebe ŋei bira onbi, eŋe Yesu iwenkau eŋane Kaunsol kaiteno okoraki rakoi, ");
INSERT INTO ons_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ge ŋedannom, desikene, ge Mesia me mida?” Yesu eŋe mainge rake, “Na ŋidanikaleo, ŋine don ea mi malip kaikei, ");
INSERT INTO ons_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","so na ŋine qeso qeson mane qesonŋunikaleo, ŋine don ea mi mainge raikei. ");
INSERT INTO ons_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ŋo, na ŋidanmaile, naso iwa ŋine, kutno pawayake, Ŋei Wawainane Gipole, eŋe Anutu zonom welaine wonino mesiake.” ");
INSERT INTO ons_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pakiso Eŋe korop qesonka rakoi, “Ge Anutu wane Gipole me?” Yesu mainge edange, “Ŋidom mo ea ramami yale.” ");
INSERT INTO ons_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yale rakiso, magu korop rakoi, “Ŋene koso ŋei natne mi edoraŋem sari, eŋane don ŋedanbi dere dongo mi birakakene, yeine! Eŋe mo aŋaineŋo ramaike, ŋedom don ea mo ketzeŋo detkamaine.” ");
INSERT INTO ons_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kaunsol ŋei korop eŋe wie more, Yesu, Pilat kepe ŋei waom wane matko iwenka ari more, ");
INSERT INTO ons_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ea Yesu wane don iwa yale kieke rau paki birakakoi, “Ŋene ŋei ea kaŋem ŋei ŋerep magu isi don iwa yale edan okanmaike, ‘Ŋine Roma kepe ware ware suaine, Sisa, takis misuk manikei,’ so ‘Na Mesia! Na Yuda wane kepe ware ware,’ yale rake.” ");
INSERT INTO ons_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatŋo eŋane don dere Yesu qesonka rake, “Ge Yuda wane kepe ware ware me mida?” Yesu eŋe mainge rake, “Oo, mo yewa goŋom ramaine yale.” ");
INSERT INTO ons_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pakiso Pilatŋo Mosop Ŋei Suaine Ŋetne so ŋei ŋerep magu ea edange, “Ŋei iwa kine kine qotkoine mi make, ea wane na wikile mi manikale.” ");
INSERT INTO ons_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ŋo Mosop Ŋei Suaine Ŋetne so eŋane tego eŋe Pilat togole sorinka rakoi, “Eŋe welekatne ŋei ŋerep qebin mabin okane, sorin borin okanongi, donineŋo kepeze rokopke arimaike. So eŋe ŋei ŋerep kito ebongi, Galili kepeo ŋineka ra kieke sari mage iwa Yuda kepeo weneŋ yale waka rokopke wakon arimaike.” ");
INSERT INTO ons_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pakimo, Pitat eŋe don ea dere more qeson one rake, “Ŋei iwa eŋe Galili kepeo ŋine me?” ");
INSERT INTO ons_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilat eŋe naso yewao iwa yale detke, Yesu eŋe Herotŋo kepe waremaike, nat paromine yewao ŋine, ea wane Pilatŋo Yesu eŋe koso Herot wano birakake, Herot eŋe naso yewao Yerusalem matko geke. ");
INSERT INTO ons_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot eŋe naso kiroine Yesu marat kayakane dere geke, ea wane eŋe Yesu kaki paki siminkake. Yesu eŋe masi tanik kine kine kine mane make ea Herot eŋe mo loutne detke, ea wane Herot eŋe Yesu wane masi togole mane kayakane detke so wetkeke. ");
INSERT INTO ons_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yalinane Herot eŋe Yesu qeso qeson loutne manerop qesonkake, ŋo Yesu eŋe don mane mi mainge rake. ");
INSERT INTO ons_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Yale okangi Mosop Ŋei Suaine ŋetne so Anutu papa togon welaine ŋei, Skribe, eŋe sari Yesu wane don togole rau paki, don uratao birakakoi. ");
INSERT INTO ons_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Rau qoekiso, Herot so kawali ŋeikoune eŋe Yesu maket biraka more isi bela okankau paki, masi kine kine qotkoine loutne okankakoi. Pakiso eŋe Yesu wane laplap mayakakatne wekumane biraka more, Pilat wano koso mainge ari birakakoi. ");
INSERT INTO ons_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kaiwe yewao, Pilat so Herot ere kima kima okangoik, sogino yemo ere ŋaba ŋaba okan nagu gekoik. ");
INSERT INTO ons_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yesu eŋe zinge sarikiso, Pilatŋo Mosop Ŋei Suaine ŋetne so Yuda ŋei suaine so ŋei ŋerep korop edoraki lewage okorau, ");
INSERT INTO ons_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","edange, “Ŋine ŋei iwa naŋano iwenka sari remi ‘Eŋe don isisine loutne ŋei ŋerep edan okanmaike’ . Naso iwao, na ŋinane kaitko eŋe mo qesonkele, ŋo masi qotkoine mane ea ŋine mo remi, eamo na mi maratkele. ");
INSERT INTO ons_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot eŋe weneŋ yale waka kine kine qotkoine mane mi maratkeke, ea wane ŋei iwa eŋe naŋano koso birakeke, sogino eŋe kine kine qotkoine mane mi make, ea wane na eŋe maine mi qewe seukeake. ");
INSERT INTO ons_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Iwamo na kawali ŋeikopne edanbe kumunamŋoka dime more qeliŋkau ariake!” ");
INSERT INTO ons_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Aŋelo loloŋon loloŋon koma korop Pilatŋo ŋei ŋerep eŋane simile mogare mulap ŋeiene mane qelige siwotkaki ari mageke. ");
INSERT INTO ons_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ŋei ŋerep magu don ea dere more, eŋe korop boka rakoi, “Ge ŋei iwa qenom seukkep! Ŋo ge Barabas siwotkanom ŋenano sarikep!” ");
INSERT INTO ons_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Sogino, Barabas eŋe ŋei natne enguki seukkoi so Yerusalem matkoto kawali mane kepe ware ware eŋano maki wakonge, ea wane Pilat wane kawali ŋei edo mulap urumgo birakakoi. ");
INSERT INTO ons_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ŋo Pilatŋo Yesu siwotkayakane dere more, ŋei ŋerep koso sorinone rake, “Na Yesu maine qeliŋkaikale.” ");
INSERT INTO ons_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ea wane magu suaine eŋe kakapa donine boka mainge rakoi, “Ŋine kibego qeu seukkep! Ŋine kibego qeu seukkep!” ");
INSERT INTO ons_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ŋo Pilat eŋe atak karewe koso soringe edange, “Ŋine eŋane masi qotkoine make, ea nolatpi detpe! Na eŋane masi qotkoine mane mi marat kamaile, ea wane na eŋe maine mi qewe seukeyake! Na kawali ŋei kopne edanbe kumunamŋoka qe more, siwotkau ariake.” ");
INSERT INTO ons_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ŋo ŋei ŋerep magu eŋe Pilat wano togogole boka sorinka more olatkoi, “Ge Yesu kibego qem seukep!” Ŋei ŋerep eŋe yalewa boka olale more Pilat manerop yuankakoi. ");
INSERT INTO ons_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ea wane Pilatŋo ŋei ŋerep magu eŋane simile mogare kawali ŋeikoune eŋe Yesu kibego qekei wane detonge. ");
INSERT INTO ons_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Barabas eŋe sogino ŋei natne enguki seukkoi so kawali make, Pilatŋo ŋei ea mulap urumgo ŋine ma sari siwotkaki arike. So Pilatŋo Yesu eŋe ŋei ŋerep eŋane simile mogare kawali ŋei eŋane meto birakake. ");
INSERT INTO ons_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kawali ŋei eŋe Yesu iwenka Yerusalem mat ŋadino arikei wane arikoi. Ŋei mane, eŋetine Saimon, Sairini matko ŋine, eŋe Yerusalem wane saiwo ŋine sariki, kawali ŋei eŋe malipka more, Yesu wane kibeŋ manbi teweke, Yesu ŋadino mogatkake. ");
INSERT INTO ons_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ŋei ŋerep magu suaine eŋe Yesu mogatkakoi, eŋane keueno ŋerep natne eŋe Yesu wane ra more arokkoi. ");
INSERT INTO ons_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu eŋe aroene dere more mainge don edan rake, “Ŋine Yerusalem ŋine ŋerep nau! Ŋine naŋane ra more misuk arokkei. Ŋine ŋinŋine so medewekop ŋine eŋane ra more yemo maine arokkei. ");
INSERT INTO ons_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ŋine detpi, baŋ naso maneo ŋei ŋerep korop iwa yale raikei, ‘Ŋerep eŋe medep mama wane rokop mida, so ŋerep eŋe medep mane mi makoi, ŋerep eŋe medep ŋamu mi gumeongoi, ea eŋe bakom maine kitokei.’ ");
INSERT INTO ons_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Naso yewao, ŋei ŋerep eŋe bonaga edora meŋenone more raikei. ‘Ŋine ŋene maine ket supa ŋonikei.’ Eŋe bonaga nigatne edora meŋenone raikei, ‘Ŋine ŋene motŋonikei’ . ");
INSERT INTO ons_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Eŋe naŋano kine kine qotkoine manerop okannanmami, eŋe ŋinano yale waka masi qotkokoine natne baŋ okanŋunikei me daleo? Ŋaba edo kine kine qotkoine naŋano naso iwa okannanmami, yalewaka eŋe baŋ qotkokoine ŋine okanŋunikei.” ");
INSERT INTO ons_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kawali ŋei eŋe mulap ŋei etke Yesurop iwenore more, etkukei wane arikoi. ");
INSERT INTO ons_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pakiso kepe eŋetine, ‘Lewet Setne’ , ea lotke more, Yesu kine so metine kiruŋaŋo kibego qe more, so mulap ŋei etke Yesu wonino so kanaino etkukoi. ");
INSERT INTO ons_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pakimo, Yesu eŋe rake, “Magak, ge ŋei iwa eŋane masi so sot turuŋene iwa qeliŋka niget gangep! Eŋe kine kine iwa mamami, eŋe ea mi detlukkamami.” Yale rakiso, kawali ŋei Yesu wane laplap maloine yewa ma more, masisiŋo kine qe wakon masi wezu mane mau paki bare more, yuane damo qe more anagukoi. ");
INSERT INTO ons_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ŋei ŋerep eŋe okora kakoi, Yuda ŋei suaine don rau paki, isi bela okanka rakoi, “Eŋe ŋei ŋerep natne ma menaŋonge, eŋe Mesia okane, Anutuŋo eŋe birakakeo, eŋe oŋom maine ma menaŋ nagu yake!” ");
INSERT INTO ons_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kawali ŋei eŋe weneŋ don so isi bela okanka more, wain qotkoine manikei wane sari, ");
INSERT INTO ons_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","olatkoi, “Ge Yuda kepe ware ware suaine okanmaineo, ge maine kibego ŋine kesikene.” ");
INSERT INTO ons_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pilatŋo kibeŋ kutno kibi iwa yale qeke. “Iwa Yuda Kepe Ware Ware Suaine.” ");
INSERT INTO ons_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mulap ŋei mane, Yesurop weneŋ engukoi, eŋe don qotkoine Yesu olale more rake, “Ge Mesia okanmaineo! Ge geŋone qesiŋ nagu more, ŋere weneŋ qesiŋ ŋotnom me?” ");
INSERT INTO ons_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ŋo mulap ŋei maneŋo ŋei ea don okanka more rake, “Ge seu seu wane biŋek raraineŋo, Anutu wane mi kaet ganmaike me? Ge eŋe yale koboboineŋo seukene me? ");
INSERT INTO ons_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ŋere mo sogino kine kine qotkoine makote, ea wane ŋere maine seukkete, ŋo ŋei iwa eŋe kine kine qotkoine mane mi make.” ");
INSERT INTO ons_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ŋei eaŋo koso zinge Yesu olatke, “Yesu, ge zinge sari kepe ware ware suaine okanikene, naso yewao na weneŋ siluŋ mide detsorok nanikene.” ");
INSERT INTO ons_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yale raki, Yesuŋo olatke, “Na welekakatne golatmaile, ge ukudeka narop qeliwo gege togon matko weneŋ mesikete.” ");
INSERT INTO ons_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kepe deine oŋabango okangi, kaiwe mi sirike more, kepe ea korop panamane paki, ari 3 kilok kaiwe koso sirikke, ");
INSERT INTO ons_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","naso yewa laplap suaine Anutu wane Bakom Urum kotino okorake, ea keuoka buntuk wiri sari ketki qela qoeke. ");
INSERT INTO ons_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Pakiso, Yesu eŋe boka rake, “Magak, ge naŋane oŋa oŋa asune ea na mo metŋono motmaile, ge maikene!” Yale ra more asuine saki seukke. ");
INSERT INTO ons_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yesu eŋe seukkiso, kawali ŋei ŋetne mane ea ka more, Anutu eŋetine mawakaki paki rake, “Welekatne, eŋe ŋei wele koboboine so wekumane!” ");
INSERT INTO ons_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pakiso, ŋei ŋerep magu eŋe kine kine wakonge, ea kaikei wane sarikoi, eŋe Yesu seukki dere more, qom borik ongi, so mateno zinge ariwarekoi. ");
INSERT INTO ons_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ŋei ŋerep eŋe Yesu detlukkakoi, eŋe so ŋerep natne Galili ŋine mogatkakoi, ea eŋe korop osop osop okora masi tanik ea wakonge, rokop kawarekoi. ");
INSERT INTO ons_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ŋei mane, eŋetine Yosep, Arimatea mat, Yuda kepeo ŋine, eŋe ŋei koboine, ewinerop. Eŋe Anutu wane qeli ewe zonom sari sari wane toma geokange. Eŋe Yuda Kaunsol okorake, ŋo Kaunsol eŋe don kine kine ra more, Yesu togoleka makoi, eŋe mi oŋge. ");
INSERT INTO ons_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ŋei eaŋo Pilat wane kaitko ari lotke more, Yesu pareŋine maine ma ari dukkayake me daleo, ea wane qesonkake. ");
INSERT INTO ons_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilat eŋe oŋ rakiso, Yosep eŋe ari laplap mane libeka qoleke, laplap eaŋo Yesu wane pareŋine makokka more kawetkaki paki, deŋesereo ma ari kezem koto motke. Lom yewa ŋei maneŋo mo wesi weku suaine ea wane bano yasoki okorake, sogino ŋei mane yewao mi dukkakoi. ");
INSERT INTO ons_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Naso yewa mo nagapko, sogino sarereo Yuda edo qezareko metkoi, ea wane nagapko eŋe Yesu wesi kezem birakake ");
INSERT INTO ons_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pakiso ŋerep eŋe Yesu Galili ŋine mogatkakoi, eŋe Yosep mogatka more, kezem so Yesu pareŋine daline paki, ea kakoi. ");
INSERT INTO ons_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pakiso mateno zinge ari more, kelok kine kine qounerop maulukoi. Anutu ra rokop don pake, ea wane eŋe qezarek naso sarere, eamo yaup metkoi. ");
INSERT INTO ons_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kepe qae qae, Sodao ŋerep eŋe kelok qounerop mo maulukoi, ea ma more deŋesereo arikoi. ");
INSERT INTO ons_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Eŋe ari pore kau, wesi suaine kezem aŋaino metke, ea mo rodigeu saket arike. ");
INSERT INTO ons_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Eŋe kezemgo waket pore, Waomene Yesu wane pareŋine mi kakoi. ");
INSERT INTO ons_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Daleo wakonge, ea eŋe mi detluke okorau, so ikopka ŋei etke laplap libekaropŋo ŋerep eŋane ososeno okorakoik. ");
INSERT INTO ons_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ŋerep eŋe kaet suaine ongi, so kepeo ket rasu pau, so ŋei etke ere edangoik, “Ŋine onoka wane ŋei wisikaune deŋesereo seu seune eŋano ziaŋkamami? ");
INSERT INTO ons_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Eŋe iwa mi metmaike, Anutuŋo eŋe maki wisikae wiike. Detsorokeu, eŋe iwa mi pamaike, sogino Yesu eŋe Galili ge more, iwa yale edange, ");
INSERT INTO ons_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Ŋei maneŋo ŋei sotenerop eŋane meteeno, Ŋei Wawainane Gipole birakaikei. Ŋei sotenerop eŋane ra, kibego qeu seukkeake, ŋo kaiwe karewe pa more, kutno eŋe koso wisikae wieake.’” ");
INSERT INTO ons_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Pakiso, ŋerep eŋe Yesu wane don detsoroke more, ");
INSERT INTO ons_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","kezemgo ŋine zinge ari, dokoine elewen so ŋei ŋerep magukopene maratongoi, ŋei etke eŋe ŋerep edangoik, ea korop ŋerep eŋe medep enŋene so magukopene edangoi. ");
INSERT INTO ons_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ŋerep ea Maria, Magdalena matko ŋine, so Yoana, so Maria, Yakop wane nagaine. Ŋerep ea so ŋerep natne eŋe Yesu wane qelit ŋei, aposolo, don kisi edangoi. ");
INSERT INTO ons_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ŋo aposolo eŋe detkoi, ŋerep eŋe don weleka zok mi ra okanmami, eŋe don yau yaup ra okanmami, ea wane eŋane don mi malipkakoi. ");
INSERT INTO ons_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ŋo Petoro eŋe wie biririke ket deŋesereo ari potki waketki kaki, kezem koto ea mo laplapŋoka pake, eŋe yale ka more, oŋaine qaeki, koso matko zinge welepke more, kine kine wakonge, ea wane zok manerop dereret urata ma arike. ");
INSERT INTO ons_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Soda yewao Yesu wane dokoine etke Emaus mat arikeik wane arikoik. Mat ea wane duma kilomita 11 Yerusalem ŋine. ");
INSERT INTO ons_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kine kine Yerusalem matko wakonge, ea eŋe don auwik so, ");
INSERT INTO ons_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yesu oŋom erano maratore more, ererop weneŋ geke. ");
INSERT INTO ons_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ere ka more so mi detlukkakoik. ");
INSERT INTO ons_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Pakiso Yesu eŋe qesonore rake, “Dalino aumamik?” Ere doŋ mane okora more qom borik zok otke. ");
INSERT INTO ons_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ŋei mane, eŋetine Kleopas eŋe Yesu qesonka rake, “Ge Yerusalemgo kulit gemaine? Kine kine soda iwao wakonge, ea ge mi detmaine?” ");
INSERT INTO ons_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu eŋe qesonka rake, “Onokaka wakonge?” Ŋei etke ere mainge olatkoik, “Yesu, Nasaret ŋine eŋano kine kine ea wakonge, ŋei ea eŋe Anutu wane qelit ŋei mane, eŋe don zonomineropŋo ŋei ŋerep kito edange, so masi togole ŋei ŋerep so Anutu kaiteno make. ");
INSERT INTO ons_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ŋenane Mosop Ŋei Suaine ŋetne, so ŋei ŋetne natne eŋe Pilat wane meteo birakakoi. Pakimo Pilatŋo kawali ŋei eŋane meto rakoke ebongi, kibego qeu seukke. ");
INSERT INTO ons_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mo sogine qei bano Anutuŋo rake, eŋe ŋei mane baŋ Israel ŋei ŋerep qesiŋ ŋoniakane birakayake, so naso eao ŋene Yesu wane yale rakone, eŋe baŋ Yuda ŋei mapik ŋoniake ra more urata ea mayakane detkone, ŋo eŋe seukke, mo iwa kaiwe mama karewe qoemaike. ");
INSERT INTO ons_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kepe qae qaeo ŋerep natne, ŋenane magu keuo ŋine, eŋe kezemgo ari more, ");
INSERT INTO ons_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Yesu wane pareŋine mi maratka more, ŋenano zinge sari iwa yale ŋedanmami, “Ŋene aŋelo otŋem mo rakoik, ‘Yesu eŋe mo wisikae wiemaike’ .” ");
INSERT INTO ons_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ea wane oŋaze qaeki, ŋei natne ŋenane magu keuo ŋine, eŋe ari kezemgo ka more, Yesu mi kamami. Ŋerep eŋe kine kine korop remi, ea korop welekatneka.” ");
INSERT INTO ons_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pakiso Yesu eŋe etange, ”Ŋine dereretŋine midaine, sogino Anutu wane qelit ŋei eŋe kine kine qekoi, ŋine don ea ikop mi malip kamami. ");
INSERT INTO ons_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Anutuŋo rake, Mesia eŋe wikile suaine desiake, pakimo Mesia eŋe qeliwo qelaŋinerop wayake.” ");
INSERT INTO ons_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesu eŋe dokoine etke erano Anutu wane papiao don korop pamaike ea ra qelaŋange, Yesu eŋe Mose wane kibi ea ŋine kieke more, ari mage Anutu qelit ŋeikoune eŋe kibi korop Mesia wane ra more qekoi, ea ra qelaŋan otwareke. ");
INSERT INTO ons_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pakiso eŋe Emaus osino lotkeu paki, Yesu eŋe mat maneo bira ore ariakane okange. ");
INSERT INTO ons_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ŋo ere Yesu ma wauluka more rakoik, “Ruo keremaike, kaiwe qoeyake, ge ŋererop mesikene.” Yale raukso, eŋe yewa metke. ");
INSERT INTO ons_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Eŋe ererop ŋara neyakane metke, eŋe bret ma mosopka more, mapoke ere eponge. ");
INSERT INTO ons_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pakiso erane dereretetne qelaŋangi. so eŋane kine detlukkakoik, ŋo Yesu eŋe siukki, so ere mi kakoik. ");
INSERT INTO ons_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Arikiso, ere don iwa yale aukoik, ”Dumao, ŋene sarine, eao eŋe Anutu wane papia ŋerano ra qelaŋanike, naso eao qomso zok kitike.” ");
INSERT INTO ons_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Au more qoeki, ikopka eŋe wie more, Yerusalem zinge ari more, dokoine 11, so ŋei ŋerep natne maratonbik lewaŋgoi. ");
INSERT INTO ons_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ŋei ŋerep magu eŋe edanbik rakoi, “Waomze welekatne wisikae wiike, eŋe Saimon mo wakonkeke!” ");
INSERT INTO ons_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ŋei etke ere kine kine dumao wakonge, ea korop ra qelaŋangoik, Yesu eŋe dalino bret mapoke, ea wane ere eŋane kine detlukkakoik, ea korop ra edangoik. ");
INSERT INTO ons_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ŋei etke ere don kisi ea edanbik, mi qoeke, naso yewaoka Yesu eŋe eŋane keueno wakone okora more edange, “Peamŋo ŋinano pawayake!” ");
INSERT INTO ons_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Eŋe Yesu ka more oŋaoŋa kamaine ra manerop zok kaetonge. ");
INSERT INTO ons_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ŋo Yesuŋo edange, “Ŋine misuk kaet ŋungep! Nine dere mezet mi okanikei! ");
INSERT INTO ons_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ŋine naŋane kie metene kau, noŋom sarimaile. Ŋine solane uanane kau. Oŋa oŋa eŋe bikumine setine mida. Na bikumne so setnerop.” ");
INSERT INTO ons_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yale ra more eŋe kie metine ea kawali ŋei edo kiruŋaŋo qekoi lopot ea korop sikanonge. ");
INSERT INTO ons_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Eŋe bakom zok suaine manerop kitokoi, ŋo eŋe weteneŋo yemo mi malipkakoi. Eŋe dere qeka okane ŋaŋaekakoi. Pakiso Yesu eŋe qesonone rake, “Ŋara natne pamaike me?” ");
INSERT INTO ons_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Eŋe zawon zezine nat manbi, ");
INSERT INTO ons_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ma more, eŋane kaitko neke. Neki qoeki edange, ");
INSERT INTO ons_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","“Sogino na ŋinano gekole, naso ea na kine kine ŋidankole, ea korop mo wakonge. Mose wane ra rokop don so Anutu qelit ŋeikoune eŋane papia so Sam papia, kine kine korop papia ea wane kotino pamaike, eamo naŋane ra more wakonge.” ");
INSERT INTO ons_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pakiso qesiŋone more ra qelaŋane edangi, dokoine eŋe Anutu wane kine papiao pamaike, ea detlukkoi. ");
INSERT INTO ons_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","So Yesu eŋe dokoine edange, “Anutu wane papiao pamaike, ‘Mesia eŋe wikile dere more seuke kaiwe mama karewe pa more koso wisikae wieyake. ");
INSERT INTO ons_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ŋine ari ŋei ŋerep kepe baŋem kepe baŋem naŋane biŋek don ra qelaŋanbi, wetene maingekei. So ŋine urata eamo Yerusalem mat kotine kieke more ra qelaŋanikei. Pakimo ŋei ŋerep eŋe kimakopene eŋane sot turuŋene ea ŋadekaikei, ea wane rokop Anutuŋo yale waka eŋane sot turuŋene ea qeliŋge nigetkayake. Ŋine don ea ra qelaŋangei. ");
INSERT INTO ons_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ŋine kine kine wakongi, deŋineŋo kakoi so ketŋineŋo detkoi, ea ŋei ŋerep kito edane more ra qelaŋonikei. ");
INSERT INTO ons_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","So ŋine koso detpi sogino, Magakŋo kine kine ra togole ŋibonge, eamo koso noŋo ŋibonikale. So ŋine Yerusalem matko toma metpi, zonomne ea qeliwo ŋine ŋinano kesiake.” ");
INSERT INTO ons_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pakiso, Yesu eŋe dokoine Yerusalem ŋine iwenon ari more, Betani lotkekoi, yewao Yesuŋo meteene ma more mosoponge. ");
INSERT INTO ons_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mosop ea mi qoeki, Anutuŋo Yesu qeliwo maki wake. ");
INSERT INTO ons_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dokoine eŋe Yesu eŋetine bukeu waki koso Yerusalem matko zinge arikoi, Yesu eŋine magu koropŋo bakom suaine kito more, ");
INSERT INTO ons_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","so eŋe naso baŋem Anutu wane Bakom Urumgo ari yewao Anutu eŋetine takorakot ora bueku waki meŋenka gewamaŋkoi. ");
INSERT INTO ons_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pidon eŋe mokaka qei kino, kepe mi wakongi, yewao ŋineka ge sari geke. So Pidon eŋe gegeine Anuturop ge sa geke. So Pidon eŋe Anutuka geke. ");
INSERT INTO ons_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pidon eŋe mokaka qei kino Anuturop geke. ");
INSERT INTO ons_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","So Pidon eŋe Anutu wane meteo ge more, kine kine korop ma wakon wareke. Eŋe midaine kine kine mane Anutu eŋineka mi ma wakonge. ");
INSERT INTO ons_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pidon eŋe gege yewa wane welaine okane geke. Paki gege yewaŋo kiwa waraŋkaki, ŋei eŋano sari more qelaŋan onge. ");
INSERT INTO ons_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kiwa yewaŋo panaman kotino ma qelaŋangi, so panamanŋo kiwa yewa qe pilikkeakane qekake. ");
INSERT INTO ons_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anutuŋo urata ŋeiine mane birakake, ŋei yewa eŋetine Yohane. ");
INSERT INTO ons_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Eŋe qelaŋan wane don kisiine ra wakongi, ŋei korop eŋe qelaŋan welaine detluk kau paki, weteneŋo malip kaikei wane raki paki Anutuŋo birakake. ");
INSERT INTO ons_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohane eŋe oŋom qelaŋan wane welaine mi okane geke, eŋe yaup qelaŋan welainane don kisi ra wakoniakane sarike. ");
INSERT INTO ons_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Qelaŋan welaineŋo kepe baŋem ŋei ŋerep korop qelaŋan ma wakonon ebon okanmaike, oŋo naso yewao eŋe weneŋ kepo ket wakone geke. ");
INSERT INTO ons_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pidon eŋe kepeo wakone geke, eŋe Anutu wane Pidon geki paki, kepeo kine kine iwa ma korop oŋom wakon wareke. Paki ŋado kepeo sari lotkeki kepe ŋeiŋo korop eŋe kau paki ŋaŋae kakoi. ");
INSERT INTO ons_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Eŋe eŋine kepe matino sari lotkeke. Ŋo siluŋ eŋine ŋei ŋerep magukoune edo kima mi okankakoi. ");
INSERT INTO ons_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ŋei ŋerep natne eŋe welekatne kima okankau paki, donine dere weteneŋo malipkakoi, eŋe Anutu wane ŋerep medep okanikei wane numa ma wakone ebonge, eŋane eŋet ma noganka okanmami, eŋe yale okanon okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Eŋe nabok magak eŋane weŋem bikumgo ŋine wakone more, Anutu wane ŋerep medep mi okangoi, me sola wane simile so ŋei wane simile yewa ŋine midakaka. Eŋe Anutu eŋino ŋine wakongoi, wane eŋe Anutu wane dokoine. ");
INSERT INTO ons_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pidon eŋe ŋei okane more, sola bikum gorop wakongi paki, keuzo mere wie okange, paki ŋene Waom qeli ewe zonom so kibi maepine mo kaulukkone, eaŋo Magak wane Medep me qom bapine wekuku, eŋane Waom kibi maep so zonom so don wele woune so masi tanik manik bile, eaŋo wat watko rosarop ea weneŋ ma sarike. ");
INSERT INTO ons_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohaneŋo eŋane kineine ea ŋei ŋerep ra wakone more edane rake, “Na ŋei iwa wane mo ŋidane iwa yale rakole, ŋei mane naŋane ŋadeno sarimaike, eŋe mokaka geke, eŋe naŋane rokop mida, eŋe kakapa suaine so naŋane wawaine, oŋa na yuan nanmaike, onoka wane oŋo mokaka ge sari geki na eŋane ŋadino wakongole.” ");
INSERT INTO ons_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pakimo, wet maepine rosarop wat watko mo pa sarike, yewa ŋine ŋene korop ra wakone mauluk ŋone more ŋebongi weneŋ ma warekone. ");
INSERT INTO ons_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Anutuŋo ra rokop don yemo Mose wano ra wakone more metino more ŋebonge, ŋo wet pesek so don wele, yemo Yesu Kristo wano ŋine sarike. ");
INSERT INTO ons_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ŋei maneŋo Anutu mane mo mi kake, midakaka, ŋei weku, eŋe oŋom ea Anutuka, ea wane eŋe Anutu Magak wane osino metmaike, oŋo Anutu ŋine kine kine korop ma sari more, ra wakone ŋedange. ");
INSERT INTO ons_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yuda ŋei wawaine eŋe Yerusalem matko ŋine Pris, mosop ŋei so Lewi, mosop ŋei tegoo ŋine mane tale onbi, Yohane wano ari qesonka rakoi, “Ge ma?” ");
INSERT INTO ons_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ra qesonkau Yohane eŋe kineine mi motkeke, eŋe didiwo ra wakonge. Paki iwa yale rake, “Na Mesia mida, ŋeiwa ŋei ŋerep korop turuŋene mayakane ra more, Anutuŋo ma wakonka birakake, na ea mida.” ");
INSERT INTO ons_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Raki mo eŋe koso qesonka rakoi, “Paki mo daleo ge ma? Ge propet Elaiya kakip mane me?” Yohane eŋe edange, “Na eŋe mida.” Eŋe qesonka rakoi, “Ge propet mane ŋene tomakamaine, eŋe me?” Eŋe mainge edange, “Mida.” ");
INSERT INTO ons_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Eŋe koso qesonka rakoi, “Paki mo ŋedannom, ge koboboine ma? Ŋene eriŋine raŋonbi sarine zinge ari turuŋine daleo edanikene? Ge geŋonane daleo ramaine?” ");
INSERT INTO ons_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Pakimo Yohaneŋo iwa yale rake, propet Isaiaŋo don iwa yale ra edange, “Naŋane kine iwa yale, na ŋei mane wane aŋa, kepe yaup papaino boka more iwa yale ramaike, ‘Waom wane numa koboine laponbi.’” ");
INSERT INTO ons_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ŋei eŋe yemo Parisi edo taleonbi sarikoi. ");
INSERT INTO ons_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Eŋe Yohane qesonkakoi, “Ge Mesia mida, me Elaiya mida, me propet mida, ŋo ge onoka wane ŋei doku tauon okanmaine me?” ");
INSERT INTO ons_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohaneŋo edane rake, “Na dokuka tau onmaile, keu ŋino mane okoramaike, ŋo ŋine eŋe mi detluk kamami. ");
INSERT INTO ons_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Eŋe ŋei yewa naŋane ŋadeno sarimaike, ŋo siluŋ na yalineŋo eŋane kie kaweune yewa maine mi qekokkale, me naŋane rokop mida, na eŋane qelit qeqe gemaile.” ");
INSERT INTO ons_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Masi iwa yemo Betani matko, Yordan Doku wane wazaino, kepe deine sasainoken, yewa wakonge. Kepe mat yewao Yohaneŋo ŋei ŋerep doku tauonge. ");
INSERT INTO ons_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kepe qaeki kaiwe maneo Yesuŋo Yohane wano ariki Yohaneŋo kaki paki rake, “Anutu wane Lama iwa kau, oŋo kepe baŋem ŋei eŋane borikine oma on wareyakane sarike. ");
INSERT INTO ons_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na ŋei weku yewa eŋane don kisi mo ŋidane iwa yale rakole, ‘Ŋei mane naŋane ŋadeno sarimaike, eŋe siluŋ naŋane suaine, na yuan nanmaike, onoka wane, na mi wakonbe oŋo mokaka kino kieke geke.’ ");
INSERT INTO ons_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na noŋom alakan, eŋe mane mi detlukka more kakole, ŋo siluŋ sari more, ŋei ŋerep doku tau ongole, yemo Israel ŋei ŋine don kisiine ra wakone sikan ŋunbe, ŋine eŋe ka more wetkaikei wane doku tau ŋungole.” ");
INSERT INTO ons_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohane eŋe yale edangi paki rake, “Na kawe Asuŋo baluse yale qeliwo ŋine ket more kutino kito metke. ");
INSERT INTO ons_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ŋo na noŋom eŋe mi det kakole. Ŋo siluŋ Anutuŋo ŋei ŋerep doku tau onikalane talenange. Paki so nolale rake, ‘Ge baŋ kanom Asuŋo ket more ŋei mane wane kutino kito mesiake. Eso yewa oŋo Asurop ŋei ŋerep doku tau oniake.’ ");
INSERT INTO ons_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yohane eŋe rake, “Na ŋei yewa kakole, wane ŋidane ramaile, eŋe Anutu wane Gipole.” ");
INSERT INTO ons_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kepe qaeki kaiwe mama maneo Yohane eŋine so dokoine eŋane keuo ŋine medewetkine etke eŋe koso yewaka okorakoi, ");
INSERT INTO ons_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Okorau Yesu eŋe ari lotkeki Yohaneŋo kaki paki rake. “Kauk, oŋo Anutu wane Lama!” ");
INSERT INTO ons_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yohaneŋo yewa raki medewetkine ere detkoik. Pakiso ere Yesu ŋadino mogare arikoik. ");
INSERT INTO ons_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu eŋe zinge otki ŋadino ariuk qeson ore rake, “Ŋire onoka wane zuage sarimamik?” Ere rakoik, “Rabai, ge diawao gemaine?” Rabai wane kine Ono dongo, kito ŋebo ŋebon. ");
INSERT INTO ons_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Paki so Yesuŋo etange, “Sariuk paki kauk.” Paki so ere Yesurop weneŋ ari more mat geke yewa kakoik. Kauk paki kaiwe korop yewa eŋerop gekoik. Iwa mo po(4) kilok rarapko naso yewao mapikkoi. ");
INSERT INTO ons_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yohane wane don dere more Yesu ŋadino mogare arikoik, erano ŋine mane eŋetine Andrea, Saimon so Petoro wane ŋole. ");
INSERT INTO ons_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Paki so Andreaŋo qeliŋone more ari eaka tatine Saimon maratka more olale rake, “Ŋere Mesia Anutuŋo birakaki ketke, ea marat kamaite, Mesia yemo kine iwa yale, ŋeiwa Anutuŋo borikino ŋine ebu sayakane birakake.” ");
INSERT INTO ons_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yale raki paki so Saimonŋo Yesu wano iwenkaki arikoik. Yesuŋo kaki paki rake, “Ge Saimon, Yohane wane gipole, geŋane eŋetŋone Sipas.” Eamo eŋet kine weku Petoro yale, ŋo ea wane kine Ono dongo, “wesi”. ");
INSERT INTO ons_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kepe qaeki Yesuŋo Galili kepeo ariakane ewekke. Paki Pilip maratkaki paki olale rake, “Na sari mogat nannom!” ");
INSERT INTO ons_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip eŋe Betsaida matko ŋine, Andrea so Petoro mat gekoik, yewa ŋineka, eŋe matene weku. ");
INSERT INTO ons_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipŋo Nataniel maratka olale rake, “Ŋene ŋei mane wane Moseŋo ra rokop dongo qeke, so propet edo yale waka qekoi, ea mo maratka maine. Eŋe yemo Yesu, Yosep wane gipole, Nazaret matko ŋine.” ");
INSERT INTO ons_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanielŋo qesone rake, “Nazaret mat ketkele eŋano ŋine kine kine mayakatne mane maine wakoniake me?” Pakimo Pilipŋo mainge olatke, “Sari kanom.” ");
INSERT INTO ons_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanielŋo Yesu wano sariki, Yesuŋo kaki paki, iwa yale rake, “Eŋe kau, ŋeiwa iwa sarimaike, eŋe ŋei wele, eŋano isi don me tanik manik qotkoine mane mi pamaike, Israel kine pokaine, eŋano isi mane mi pamaike!” ");
INSERT INTO ons_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Pakimo, Natanielŋo Yesu qesonka rake, “Ge daleo okane more, naŋane kine detmaine?” Yesuŋo olale rake, “Ge Pilipŋo mi iwen gangi sari more, nemuyap bano merine, na naso eao mo ganile.” ");
INSERT INTO ons_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanielŋo don ea dere more, eŋe iwa yale rake, “Kito ŋebo ŋebon, ge Anutu wane gipole! Ge Israel wane ŋei waom!” ");
INSERT INTO ons_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Pakimo Yesuŋo donine turuŋine mainge olale rake, “Na iwa yale golalile, ge nemuyap bano metnom na sanka ganile, na ea golatpe detnom paki, ge don kine ea waneka na detluk nanmaine me? Ge kine kine zok suaine iwa wane rokop yuanmaike ea baŋ kaikene!” ");
INSERT INTO ons_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Paki so Yesuŋo koso edane rake, “Naŋane don iwa ŋidanbe detpi! Ŋine baŋ kau qeli aŋaŋgi Anutu wane aŋelo magu edo ŋei wane Gipolano wawa ketket okanikei.” ");
INSERT INTO ons_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kaiwe etke qoeki ŋei mane Kana matko Galili kepeo zokit kakoi. Naso yewao Yesuŋo Pilip so Nataniel weneŋ raki arikoik, so Yesu eŋine nagaine eŋe weneŋ ŋei ŋerep maturaŋ otkoi, erane zokit makoik, ea eŋe weneŋ mere kake. ");
INSERT INTO ons_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Eŋe Yesu eŋine so dokoine weneŋ newan onbi sari ŋei ŋerep zokit makoik yewa weneŋ metkoi. ");
INSERT INTO ons_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wain newareu mida leleki, Yesu nagaineŋo Yesu olale rake, “Eŋe wainene mo mida lelemaike.” ");
INSERT INTO ons_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pakimo, Yesuŋo mainge olatke, “Nabok, iwa mo geŋane naso, naŋane naso mi okanmaike, na kine kine yewa makalane goŋo misuk nolasikene, naŋane nasone mi bomile sarimaike.” ");
INSERT INTO ons_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yale raki so Yesu nagaineŋo qelit medewekoune edane rake, “Yesuŋo kine kine yewa me yewa maikei wane ŋidangi, ŋine maine maikei.” ");
INSERT INTO ons_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yuda ŋei eŋane kie meteene sau sauk ea mo Mose wane ra rokop don kotino masi yewa pake. Yalinane doku beloŋ 6, wesi ŋo mamaine, yewa metkoi. Beloŋ weku weku yewao doku otnom ket more 100 lita yewa wane keuetno watke mesiake. ");
INSERT INTO ons_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesuŋo urata medep edane rake, “Beloŋ iwa korop doku otpi ket watkekep.” Raki so eŋe doku otpi ket watke wareke. ");
INSERT INTO ons_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Watkeki Yesu eŋe edane rake, “Yekuat namo doku beloŋ natne ŋara soep waremaike, ŋei eŋano ma ariu.” Edangi urata ŋei eŋe natne eŋano ma arikoi. ");
INSERT INTO ons_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Doku yewa eŋe mo wain okange paki, ariu ŋara soep ware ware ŋei, eŋe doku ea ne kaki paki rake, “Wain iwa yaline ea dia ŋine?” Eŋe ea Yesuŋo raki dokuŋo qeinge wain okange, ea wane kine mane mi detki lotkeke so mi dere qelaŋange. Ŋo qelit medep doku otkoi edo yemo mo detkoi, ea wane ŋara ware ware ŋei eŋe ŋei zokit make eŋe oraki sarike. ");
INSERT INTO ons_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Sariki olale rake, “Ŋei korop eŋe wain maine yewa mikepka ebon okanmami. Paki ŋei lobo eŋe korop loutneka neu qoeki, koso ŋado wain simile midaine yewa ebon okanmami. Ŋo goŋo yemo wain mai maine yewa motkenom metmaŋkimo, yekuat iwa ma wakonmaine!” ");
INSERT INTO ons_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iwa yemo masi togogole Yesuŋo Kana matko Galili kepeo mikepka make. Maki paki, kine kine korop eŋane kutko pamaike, ea wane qeli ewe zonomine maputulaki, dokoine eŋe ka more, wet mali malipeneŋo malip kakoi. ");
INSERT INTO ons_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Paki so, ea wane ŋadino Yesu eŋe Kana mat qelige more, Kaperneam matko eŋine nagaine so ŋolekoune so dokoine arikoi, ari nasomde bamgoka yewa gekoi. ");
INSERT INTO ons_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yuda ŋei Waomŋo Loloŋonge, ea wane kaiwe suaine mane zonom ma peadaine mere eŋet miti okane mesikei wane naso, yewa mo bamgo bomileke, ea mo Naso Suaine Waomŋo kaiwe yewao loloŋongi, Yuda ŋei eŋe weku mane umat wane turuŋene mi wakone ea wane wetke metmaŋkoi. Naso yewao Yesu eŋe Yerusalem matko wa more, ");
INSERT INTO ons_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Bakom Urumgo waket ongi, sen ŋadino ŋei eŋe bulamakau, so lama, so naŋi baluse qole amanagukoi, ari ari sari sari okorau, wesi mai main ŋei eŋe yale waka zakeeno mere wesi maingekoi. ");
INSERT INTO ons_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Paki so Yesu eŋe abiŋo morap mane maulukki paki, ŋei so osom kopene korop lama bulamakau, ea esopongi Bakom Urumgo ŋine qeinat ket warekoi, paki so wesi mai main ŋei eŋane zake maingeki ketki, wesiene yewa giŋ qiririŋ ari wareke. ");
INSERT INTO ons_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ŋeiwa korop naŋi qole qoleo metkoi, yewa mo edane rake, “Bakom Urumgo ŋine ebu saket ariwareu! Ŋine maganane urum iwa mau nalu qole qole urum mi okangep!” ");
INSERT INTO ons_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesu eŋe yale okangi, dokoine eŋe Anutu wane papiao Dawitŋo qeke iwa yale ramaike eŋe yewa detkoi, “Na geŋane Bakom Urum wane zok simin nanmaike, ea wane na urataine togogole mawe menaŋluke more mesiake.” ");
INSERT INTO ons_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Paki so Yuda ŋei wawaine eŋe yewa kau paki Yesu qesonka rakoi, “Ge onokaka masi togole mane manom paki, kine ŋone sikan ŋonnom ŋene kaŋem paki iwa yale desikene, eŋe masi yewa okaniakane mo maine raraine, ea wane kine kine ea eŋe mo maine okanmaike.” ");
INSERT INTO ons_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesuŋo mainge edane rake, “Ŋine Anutu wane Bakom Urum iwa ra barakeu ketki na kaiwe kareweka koso mawe wieki ma wonge warekale.” ");
INSERT INTO ons_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yale ra edangi, Yuda ŋei eŋe Yesu qesonka rakoi, “Ge kaiwe karewe yewaoka Bakom Urum iwa ma warekenane ramaine me?, ŋo ŋenane ŋabo kopze eŋe Bakom Urum iwa mo ma geu komaine 46 qoeke!” ");
INSERT INTO ons_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ŋo Yesuŋo Bakom Urum wane rake yemo eŋine solainane yaup yewao rokop kito more rake. ");
INSERT INTO ons_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ea wane ŋado baŋ Anutuŋo eŋine seu seu oŋine ma wisikae kaki wieke, naso yewao dokoine eŋe Yesu oŋom alakan don rake, yewa koso detkoi. Paki Anutu wane papiao eŋane don natne qeqine, so Yesu oŋom Bakom Urum wane don alakan rake, yewa wane weneŋ detpi wele okangi malip kakoi. ");
INSERT INTO ons_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu eŋe Yerusalem matko Anutuŋo Israel magu Loloŋonge yewa wane peadainane naso suaine mane naso baŋem metmaŋkoi, yewao Yerusalem matko geki paki, masi togogole maki ŋei ŋerep korop eŋe kau paki, masi so don dereretine so eŋetine ea dere malip kakoi. ");
INSERT INTO ons_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ŋo Yesu oŋom yemo ŋei mo detonluk onwarekane Yuda ŋei eŋano mi pelekke, me detki, eaŋo don me mali malip wele mi okange. ");
INSERT INTO ons_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Eŋe daleo wane ŋei eŋane kine me tanik manik maine detwareke, eŋe ŋei natne eŋane kineene desiakane ŋei maneŋo mi olatke, onoka waneŋo eŋe koto kaka ea wane ŋei maneŋo kineene olatki mi detonge, eŋe oŋom kotoenane kine ea mo korop deton wareke. ");
INSERT INTO ons_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ŋei mane yewa geke eŋetine Nikodemus, eŋe Yuda ŋei eŋane ŋetne, eŋe Parisi magu eŋane keuo ŋine. ");
INSERT INTO ons_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ŋei wa yewaŋo ruo maneo, Yesu wano ari more qesonka rake, “Kito ŋebo ŋebon, ŋene kineŋone detmaine, ge kito ŋebo ŋebon mane, Anutuŋo biragangi ketkone. Ge masi togogole mamaine iwa ŋei maneŋo Anutu midaine ge more maine mi mayake.” ");
INSERT INTO ons_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesuŋo donine mainge olale rake, “Naŋane don iwa welekakatne golatpe, detlukkanom! Ŋei mane eŋe soringe more wako wakon musele mi wakoniake, eŋe Anutu wane ŋadino gege togon me qeli ewe zonom, ea maine mi marat kayake.” ");
INSERT INTO ons_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Raki mo, Nikodemusŋo qesonka rake, “Ŋei mo sua more, sele okane gegineŋo koso daleo wako wakon musele ea manerop koso wakoniake? Eŋe maine welekatne koso nagainane kotino ketki paki wakongi koso atak mane okaniake me?” ");
INSERT INTO ons_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesuŋo koso iwa yale mainge olatke, “Naŋane don iwa welekakatne golatpe detluk kanom! Mane eŋe doku so Asu wane ŋatko ŋine wako wakon musele mi wakoniakeŋo Anutu wane ŋadino gege togon me qeli ewe zonom kotino maine mi wakesiake. ");
INSERT INTO ons_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ŋei mane nabok wane ŋatko ŋine wakonge, eŋe ŋei kaitka, ŋo mane eŋe Asu wane ŋatkoŋine wakonge, eŋe Asu wane kaitka. ");
INSERT INTO ons_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na golatmaile, ea wane ge misuk detnom qe kayake, ‘Ŋine korop koso wako wakon musele ea manerop wakonikei.’ ");
INSERT INTO ons_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Momo eŋe numaine ariakane wetke okanmaike, ea wane rokop puan okanmaike. Paki mo, ge ukatne mamaike, eamo ge det okanmaine, ŋo kine diawao ŋine sarimaike, me diawao arimaike, yemo ge mi detmaine. Ŋei Asu wane ŋatkoŋine wakon wakon musele wakon okanmami, eŋane numa weku yale waka pamaike.” ");
INSERT INTO ons_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Raki mo, Nikodemusŋo qesonka rake, “Kine kine yewa ge ramaine, eamo daleo wakoniake?” ");
INSERT INTO ons_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesuŋo doninane turuŋine koso mainge iwa yale olatke, ge Israel ŋei eŋane kito ebon ebon suaine, ŋo ge daleo wane don iwa wane kine ŋaŋae maine me?” ");
INSERT INTO ons_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Naŋane don iwa welekakatne golatpe detluk kanom! Ŋene kine kine mo det okanmaine yewa wane ra okanmaine, so kine kine mo okangone yewa ŋidan okanmaine, ŋo siluŋ ŋinano ŋine maneŋo ŋenane donze yewa mi dere ewekki paki tewek okanmaike, ŋine yemo ŋenane don yewa dere more, siluŋ ŋadekka okanmami. ");
INSERT INTO ons_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na kepeo kine kine wako wakone, ea wane ŋidanbe ŋine detpi paki, siluŋ mi malipka okanmami. Paki mo na qeliwo ŋine sanka wako wakone, ea wane ŋidanbe, ŋine dere onoka ŋineŋo malip kaikei? ");
INSERT INTO ons_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","So ŋei maneŋo qeliwo mi wake, i midakaka, Ŋei Wawainane Gipole, eŋe wekuŋo qeliwo ŋine qelige kepo ketke.” ");
INSERT INTO ons_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mokaka kepe yaup papaino Moseŋo aen sisineŋo koma oŋaine maki paki, mawa ekiwo rasikki okorake, rokop weku yale waka eŋe Ŋei Wawainane Gipole mawa rasikkei, ");
INSERT INTO ons_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Paki ŋei koropŋo eŋe malipkakei, eaŋo eŋe maine gege togon marat kakei, so naso baŋem ge arikei. ");
INSERT INTO ons_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anutu eŋe kepe baŋem ŋei ŋerep korop eŋane simileine zok manerop pakane, Gipole Wemedep wekuku, ea siluŋ qikka ebonge, ea wane ŋei ŋerep koropŋo eŋe malip kaikeiwo, eŋe maine mi seukke more suikkei, midaka, eŋe maine gege togon maratka naso baŋem ge wakei. ");
INSERT INTO ons_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anutuŋo gipole wano wanok urata mayakane raki paki kepeo mi birakaki ketke, eŋe ŋei borikino ŋine ebu more mainone eŋino takot oniakane raki paki birakaki ketke. ");
INSERT INTO ons_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ea wane mane eŋe Gipole malip kayakeo, mo eŋe sotinane turuŋine mi maniake. Ŋo ŋei mane eŋe Gipole mi malip kayakeo, eŋe sotkorop okanmaike, onoka wane eŋe Anutu Gipole Wemedep Weku mi malip kamaike ea wane. ");
INSERT INTO ons_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sot turuŋ wane don urata ma ma ea wane kine iwa yale pamaike, qelaŋanŋo kepeo wakonge, ŋo siluŋ ŋei eŋe qelaŋan wane simile oniake yalemo panaman wane siminonge, onoka wane eŋe borikine kine kine makoi, ea wane yale okangoi. ");
INSERT INTO ons_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ea wane mane eŋe masi tanik qotkoine okaniake, eŋe qelaŋan ŋadek kayake, paki eŋe qelaŋango mi wakoniake. Onoka wane, eŋe tanik manikine qotkoine, ea wane kine qelaŋango wakongi mi kaikei wane, yale okaniake. ");
INSERT INTO ons_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ŋo mane eŋe masi tanik maine so don welekatne teweke geake eŋe qelaŋango wakoniake, eamo Anutu wane don tewekki paki, eŋane zonomgo urataine wekumane make, ea wane kine qelaŋanŋo maine sikan okangi, ŋei ŋerep eŋe kaulukkei. ");
INSERT INTO ons_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ea wane ŋadino Yesu eŋine so dokoine eŋe Yuda kepe nat paromino arikoi. Ari naso natne yewa eŋerop gekoi, paki ŋei ŋerep doku tau onge. ");
INSERT INTO ons_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohane eŋe yale waka Ainon matko, Salim mat osino ŋei ŋerep doku tauonge, onoka wane, yewao doku loutne pake ea wane. Ŋei ŋerep eŋe eŋano doku tauoniakane sarikoi. ");
INSERT INTO ons_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yohane eŋe naso yewao mulap urumgo mi birakakoi. ");
INSERT INTO ons_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yohane wane dokoine natne eŋe so Yuda ŋei manerop doku tau tau diawaŋo Anutu wane kaitko masi koboineso qelaŋanerop, ea wane aŋa soraŋ aukoi. ");
INSERT INTO ons_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Paki eŋe Yohane wano ari more olale rakoi, “Kito ŋebo ŋebon, ge Yordan eri woken ŋei mane sogino gerop geki ge sikan ŋonnom paki kineine ra wakone ŋedangone ea detmaine? Ŋei yewa oŋo naso iwao doku tauongi ŋei ŋerep korop mo eŋano ari waremami!” ");
INSERT INTO ons_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yale olatpi mo, Yohaneŋo edane rake, “Anutuŋo qeliwo ŋine oŋo kine kine mane ŋei yewa mi mangi, oŋomka daleo mayake? ");
INSERT INTO ons_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ŋine ŋidom don iwa alakan ŋidangole mo detkoi, ‘Na Mesia mida, na ŋeiwa ŋei ŋerep turuŋeno ŋine ebuyakane Anutuŋo birakake, yewa mida, ŋo siluŋ Anutuŋo eŋane numa makalane biranangi lewine alakangole.’ ");
INSERT INTO ons_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ŋei ŋerep biŋek qe man mane oŋo ŋerep welaine. Paki mo ŋei yewa wane kimaine eŋe osop osop okoraki paki ketine more donine desiake. Eŋe ŋerep ŋaonane done detki paki wetine zok peseake. Rokop yale waka wet pesekŋo nae kotono mo watkemaike. ");
INSERT INTO ons_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Eŋane eŋetine ŋo manerop sua wayake, ŋo naŋaneŋo nigale kesiake.” ");
INSERT INTO ons_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Weti qeliwo ŋine ketke oŋo kakapa suaine, kine kine korop yuanon waremaike. Ŋo ŋei kepeo ŋine wakonge, eŋe kepe wane biŋek, so eŋe kepeo kine kine pamaike, ea wane don ra okanmaike. Ŋei weti qeliwo ŋine ketke, eŋe kine kine korop ea wane suaine. ");
INSERT INTO ons_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Eŋe kine kine deineŋo kake, so ketneŋo detke, yewa ra okanmaike, pakimo, kepe ŋei maneŋo don kisi ra okanmaike, yewa mi dere malipka okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ŋei mane eŋe eŋane donkisi wetineŋo ma nogan ka more malip kamaikeo, yemo Anutu wane kine iwa yale qe wakonmaike, “Anutu eŋe don wele ra okanmaike.” ");
INSERT INTO ons_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anutuŋo ŋei weku birakaki ketke, oŋo Anutu wane donka ra wakone okanmaike. Onoka wane Anutuŋo Asuine wat watko ra man okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Magaineŋo Gipolane zok similekaki kine kine korop eŋane metino motwareke. ");
INSERT INTO ons_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mane eŋe Gipole wetneŋo malip kayakeo, eŋe gege togon marat kayake, so mane eŋe gipolane don dere ŋadek kayakeo, eŋe gege togon mane mi marat kayake, paki mo ŋei yalinane kutko Anutu wane busuŋo tako rakot pa ariake. ");
INSERT INTO ons_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisi eŋe Yesu wane iwa yale detkoi, “Eŋe dokoine zok loutne ebuki paki doku tau ongi Yohane wane magu yuanonmami.” ");
INSERT INTO ons_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Iwa, Yesu oŋom ŋei mane doku mi taukake. Dokoine edoka weku tauongoi. ");
INSERT INTO ons_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu eŋe Parisi don rakoi, yewa detki paki, Yuda qelige more koso Galili kepeo zinge arike. ");
INSERT INTO ons_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Eŋe numaine ari more Samaria kepeo lotkeake. ");
INSERT INTO ons_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Eŋe ariki paki Samaria wane matine suaine mane, eŋetne Sikar, yewa lotkeke. Mat yewa yemo mo sogino Yakopŋo gipole Yosep kepe mane mange, yewa wane osino pamaike. ");
INSERT INTO ons_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakop wane doku lom mane eŋe yewa okoramaike. Yesu eŋe numa arikane zonomine midaki, doku lom meuno pese ket metke, kepe deine mo oŋa bango metki, naso yewao. ");
INSERT INTO ons_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaria ŋerep maneŋo doku osiakane sarike, paki mo Yesuŋo olale rake, “Doku mane ninnom newe.” ");
INSERT INTO ons_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yesu dokoine eŋe ŋara qolekei wane matko ariu, Yesu eŋineka mere ŋerep yewa doku wane qesonkake. ");
INSERT INTO ons_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ŋerepŋo olale rake, “Ge Yuda ŋei, ŋo na Samaria ŋerep, daleo wane noŋo doku ginbe nekenane nolatmaine?” Yuda ŋei so Samaria ŋei eŋe lase pelet wane titiine okane lase weku oka mi ne okane gekoi, ea wane ŋerep eŋe yalewa ra Yesu olatke. ");
INSERT INTO ons_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Raki mo Yesuŋo mainge olatke, “Ge siluŋ Anutuŋo onokaka kine kine manerop wawaine gin okanmaike, so ŋei iwa maŋo doku mannom neakane golatmaike, yewa detkene ra, yemo ge maine doku wane qeson kanom, mo eŋe doku gege togoninerop maine gingi nenom rap.” ");
INSERT INTO ons_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Raki mo ŋerepŋo olatke, “Suaine, ge lase ŋone midaka, ŋo doku lom yemo kiroroine, ŋo gege togon doku wamo dia ŋine osikene? ");
INSERT INTO ons_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ŋenane qerakze Yakopŋo doku lom iwa ŋebonge, eŋine so gipolekoune, so lama bulamakau koune eŋe korop doku iwa ŋine ne gekoi. Goŋo Yakop wane rokop maine yuankaikene me?” ");
INSERT INTO ons_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesuŋo mainge olatke, “Mane eŋe doku iwa neake, eŋe baŋ koso doku wane manerop seukeake. ");
INSERT INTO ons_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ŋo mane eŋe doku ea noŋo baŋ manbe neake, eŋe baŋ ŋado koso doku wane manerop mi seukeake, Midakaka. Doku ea noŋo baŋ ŋei mane manikale yewaŋo kotino gege wane doku deine malotke maniake, so gege togon maniake.” ");
INSERT INTO ons_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yale olatki mo ŋerepŋo rake, “Suaine, doku yewa ninnom! Paki na koso doku wane manerop mi seukkale, me doku osikalane iwa koso mi sari okanikale.” ");
INSERT INTO ons_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Raki Yesuŋo olatke, “Ari ŋaoŋone olatnom paki mo koso iwa zinge sarinom.” ");
INSERT INTO ons_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ŋerepŋo rake, “Na ŋaone midaine.” Yesuŋo mainge olatke, “Ge ŋaoŋone midaine ramaine, eamo welekatne ramaine. ");
INSERT INTO ons_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ge ŋaokopŋone mete mane 5 ebukone, so ŋeiwa mane eŋerop ukude gemamik, eamo welekatne geŋane ŋaoŋone me mida. Ge don welekatne nolaline.” ");
INSERT INTO ons_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ŋerepŋo rake, “Suaine, na mo detmaile, ge propet. ");
INSERT INTO ons_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Naŋane esep milop kopne Samaria ŋei eŋe bonaga iwao Anutu meŋenka okangoi, ŋo Yuda ŋei ŋido wa mo ramami, ŋene Yerusalem matko yewaoka Anutu meŋenka okanikene.” ");
INSERT INTO ons_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesuŋo ŋerep olale rake, “Ŋerep, ge naŋane don iwa dere malip kanom. Naso mane pamaike yewa bomileki ŋei eŋe bonaga iwao me Yerusalem matko Anutu Magak mi meŋenkakei. ");
INSERT INTO ons_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria ŋei ŋine ma meŋenka okanmami, eamo mi detlukmami. Ŋo Yuda ŋei yemo detlukka more meŋenka okanmaine. Onoka wane Anutuŋo ŋei ŋerep ma menaŋ oniakane numa yemo Yuda ŋei ŋenano sarike. ");
INSERT INTO ons_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ŋo naso mane baŋ sariake, yemo mo iwa bomilemaike, yewao ŋei ŋerep meŋe meŋen gorop gemami, eŋe baŋ Magak wele meŋenka lukkei paki, eŋe weteneŋo Asu wane zonomgo so don welekatne, ea wane rokopko Magak baŋ meŋenkaikei. Meŋe meŋen korop yewa ŋei ŋerep yaline edo Magak meŋenkakei wane eŋe ra okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anutu eŋe Asu, ea wane meŋenkaikei wane raso, ŋei ŋerep yewa eŋe weteneŋo Asu wane zonom weneŋ don welekatne ea wane rokopko okan okan me masi mayakatne okane more meŋenkakei.” ");
INSERT INTO ons_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ŋerepŋo Yesu olale rake, “Na detmaile, Mesia, eŋetine mane Kristo baŋ sariake. Eŋe sariake naso yewao kine kine korop baŋ oŋo ŋedan wareake.” ");
INSERT INTO ons_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Raki so, Yesuŋo olatke, “Na mo iwa! Noŋo don iwa golat maile.” ");
INSERT INTO ons_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yale olale okoraki so dokoine eaka zinge sarikoi paki, so maratkau ŋerep don olatke, ea wane zok oŋaene qaeke. Ŋo siluŋ eŋano ŋine maneŋo olale mi rake, “Ge onokaka makenane?” Me qesonka rakoi, “Ge onoka wane eŋerop don aumamik?” ");
INSERT INTO ons_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Paki so ŋerep eŋe doku laseine yewa qeliŋgi metkiso zinge matko ari ŋei ŋerep edane rake, ");
INSERT INTO ons_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ŋine sari ŋei mane kau, eŋe sogino kine kine okangole makole, yewa korop ra wakone nolat waremaike, Anutu eŋe sogino ra rokop donine ŋei mane sariakane rake, ea wane wele, eŋe Mesia mane?” ");
INSERT INTO ons_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yale ra edangi so eŋe mat qelige so, Yesu wano sarikoi. ");
INSERT INTO ons_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Naso yewaoka dokoine eŋe Yesu taleka rakoi, “Kito ŋebo ŋebon, ge siluŋ ŋara mane nenom!” ");
INSERT INTO ons_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yesuŋo mainge edange, “Na ŋara natne nekalane ma gemaile, ŋine ea wane kine mi detmami.” ");
INSERT INTO ons_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Raki so dokoine eŋe edomka auye qeson nagu rakoi, “Ŋei maneŋo ŋara kaki mane mo masari manimi mane?” ");
INSERT INTO ons_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesuŋo dokoine edane rake “Naŋane ŋara yemo talenange, eŋane aŋaine tewekkale so urata makalane ninge yewa ma warewe qoeake. ");
INSERT INTO ons_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ŋidom iwa yale ra okanmami, ‘Meso etke so etke (4) qoeki, ŋara wele wakoniake.’ Noŋo ŋidanbe, ŋine kaŋ qae more deŋine pore eu kauluke kau, ŋara wele mo menaŋmaike paki, qesoŋgenane naso mo bomilemaike! ");
INSERT INTO ons_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ŋei ŋara wele lokakeake, eŋe ea wane lewine mayake, Paki mo ŋara wele peike magukeake, yewa mo gege togon wane biŋek okaniake. Yale okangi, ŋeiwa ŋara metke, eŋe so ŋara wele lokake magukke ere weneŋ orodoŋ oi bakom kitokeik. ");
INSERT INTO ons_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yale okangi mo, don iwa yale welekatne okaniake, ‘Ŋei maneŋo ŋara qe met okan okanmaike, ŋo maneŋo ŋara wele lokak okanmaike.’ ");
INSERT INTO ons_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na euo ŋine ŋara wele lokakkei wane taleŋunbe arikoi, ŋara yewa ŋidom waetnane urataine mi makoi. Ŋei natne edo ŋara urataine yewa makoi ŋo ŋine yemo yaup eŋano ŋine ŋara wele lokak okanmami.” ");
INSERT INTO ons_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mat yewa ŋine Samaria ŋei ŋerep loutneŋo ŋerep wane donkisi dere more Yesu malip kakoi, onoka wane ŋerep eŋe edane rake, “Eŋe tanik kine kine mo sogino okane gekole, eamo korop nolat waremaike.” ");
INSERT INTO ons_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Eso Samaria ŋei ŋerep eŋe mo ea Yesu wano sari more eŋerop geakane ma walukkakoi. Paki so Yesuŋo eŋerop mat yewao kaiwe etke geke. ");
INSERT INTO ons_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Paki so Yesu eŋe wet menaŋ don edangane ŋei ŋerep loutneŋo dere malipkakoi. ");
INSERT INTO ons_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Paki ŋerep olale rakoi, “Ŋene ukude malip kamaine, ea mo goŋoka don kisiine ra ŋedanine ea wane ka mida, yemo ŋene ŋedom ketzeŋo donine detkamaine, so ŋene iwa yale weneŋ detlukmaine, eŋe welekatne kepe baŋem ŋei ŋerep korop ma menaŋon wareake.” ");
INSERT INTO ons_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kaiwe etke yewa geki qoeki ea wane ŋadino Yesuŋo ea qelige Galili kepeo arike. ");
INSERT INTO ons_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu oŋom iwa yale rake, “Propet mane eŋe eŋine kepe matino geki ewine mi kitokei.” ");
INSERT INTO ons_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesu Galili kepeo ari lotkeke naso yewao ŋei ŋerep eŋe kima okankakoi, onoka wane eŋe Waomŋo Loloŋonge, ea wane peadaino zonom mama nasoo peada mesikei wane Yerusalem matko, masi so urata kine kine zonom mama peada nasoo maki kakoi, ea wane yale okankakoi. ");
INSERT INTO ons_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Eso Yesu eŋe mo koso zinge Kana matko Galili kepeo alakan dokuŋo raki qeinge wain okange yewa arike. Ware ware mane yewa geke, eŋane gipole zoma suaine okankaki, Kaperneam matko pake. ");
INSERT INTO ons_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ware ware eŋe detki Yesu mo Yuda kepeo ŋine Galili kepeo arike. Eso eŋe moya Yesu wano ariki paki, Kaperneam matko weneŋ ari, gipole ma menaŋ kayakane olatke. Gipole mo seukeakane okane pake. ");
INSERT INTO ons_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesuŋo olale rake, “Ŋine masi suaine so urata kuneŋineka kau paki, malip nangei, ŋo mi kau paki, yemo mi malip nanbi rap, ŋo yaup yemo midakaka.” ");
INSERT INTO ons_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ware wareŋo mainge olatke, “Suaine, narop esat arite, medepne mo seukeakane okanmaike.” ");
INSERT INTO ons_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesuŋo olale rake, “Arinom, medep ŋone baŋ wisikaeyake!” Paki so ŋei eŋe Yesu wane don dere malipka so arike. ");
INSERT INTO ons_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Matko ariakane ariki qelit medewekoune mo numao don ma ari olale rakoi, “Medepŋone mo maine okane gemaike!” ");
INSERT INTO ons_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Eŋe qesononge, “Ma nasoo gipone zoma qeliŋkeke?” Eso eŋe rakoi, “Yemo wan kilok yatne kepe zingeki, eao zoma qeliŋkeke.” ");
INSERT INTO ons_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yale rau magaine eŋe detke nasomde yewaoka Yesuŋo olale rake, “Geŋane giponŋone baŋ wie geake.” Paki so eŋine so magukoune eŋe korop Yesu malipka warekoi. ");
INSERT INTO ons_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iwa yemo urata togogole Yesu ŋo Yuda kepeo ŋine Galili kepeo sariki paki maki atak etke okange. ");
INSERT INTO ons_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ea wane ŋadino Yuda ŋei eŋane zonom ma taboŋ met met wane nasoine bomileki, Yesuŋo Yerusalem matko wake. ");
INSERT INTO ons_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ŋo Yerusalem mat wane kotino, Lama Madet wane osino doku namuŋ mane pake. Hebru eŋane dongoka Betsaida ora okanmami. Doku namuŋ ea wane meuno mat mete maneŋo(5) lolike metkoi. ");
INSERT INTO ons_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ŋei zomaenerop eŋe magu suaineŋo mat yewa wane kotino pa arikoi, ŋei natne deene pilik pilikine, natne kie wawetene qoi qoine so, seu seune, eŋe dokuŋo uŋalanine mayakane tomaka pamaŋkoi. ");
INSERT INTO ons_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Onoka wane naso natno Waom wane aŋelo maneŋo doku namuŋ koto ket kitoki, doku uŋalan geki detkei wane. Uŋalane dere more, zoma ŋei mane eŋe alakane doku namuŋ yewao ket maŋke, eŋe zoma kine kine daleoŋo mamaŋke, yewa qeliŋkayakane. ");
INSERT INTO ons_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ŋei mane yewa metke, eŋe zoma kaki koma 38 yale zomarop metke. ");
INSERT INTO ons_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu eŋe kaki ŋei yewa eŋe papa set pake, eso Yesu eŋe detke ŋei yewa eŋe zoma kaki naso kiroroine geke, ea wane Yesu eŋe ŋei yewa qesonka rake, “Ge menaŋ ganiakane simin ganmaike me?” ");
INSERT INTO ons_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Zoma ŋeiŋo mainge rake, “Suaine, doku uŋalane ma okanmaike, naso yewao ŋei maŋo neu biranangi doku namugo kesikale, rawe paki kesikalane ma kororoge metpe ŋei natne edo mo lewine yuannane dokuo ket okanmami.” ");
INSERT INTO ons_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Raki so Yesuŋo olatke, “Wie okora, uam lameke me supanagu papaŋone manom, paki ma arinom.” ");
INSERT INTO ons_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ŋei yewa eŋe esatkamde menaŋkaki, uam lameke papaine puk maso arike. Masi iwa yemo zonom ma taboŋ met met wane kaiwe naso yewao wakonge. ");
INSERT INTO ons_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ea wane Yuda ŋei ŋetne eŋe Yesuŋo ŋei ma menaŋkake, ea olale rakoi, “Iwa yemo zonom ma taboŋ met met ea wane naso, ge ŋenane ra rokop don yewa qebarake more, uamŋone manom paki arimaine.” ");
INSERT INTO ons_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Rau mo edange, “Ŋei mane neuki menaŋ nanike oŋo nolale ramaike, ‘uamŋone mam paki mo arinom.’” ");
INSERT INTO ons_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Edangi eŋe qesonka rakoi, “Ŋei yewa maŋo uamŋone mam paki arikenane golalike?” ");
INSERT INTO ons_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Paki mo ŋeiwa menaŋge, eŋe ŋei maŋo ma menaŋkake eamo eŋe mi detkake, onoka wane yewao ŋei ŋerep magu suaine okorakoi, yalinane Yesu eŋe eŋane keueno siuke arike. ");
INSERT INTO ons_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ŋado Yesuŋo ŋei yewa Bakom Urumgo maratkaki paki olale rake, “Kanom, ge mo ukude menaŋ maine. Borikineŋone qeliŋka warekene, midao yemo kine kine umatne koso maine wakonganiake.” ");
INSERT INTO ons_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Paki so ŋei yewa eŋe Yesu qeliŋka ari Yuda ŋei ŋetne edane rake, “Ŋeiwa na ma menaŋnanike yemo Yesu.” ");
INSERT INTO ons_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kine iwa yale wane Yuda ŋei eŋe kieke Yesu ŋabakakoi. Yesu eŋe zonom ma taboŋ met met naso yewao zoma ŋei yewa ma menaŋkake ea wane eŋe ŋabakakoi. ");
INSERT INTO ons_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesuŋo mainge edange, “Naŋane Magane eŋe urata naso baŋem ma okanmaike, eso na yale waka weneŋ mamaile.” ");
INSERT INTO ons_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Don yale rake, ea wane Yuda ŋei ŋetne eŋe zok manerop det worikkau paki, qekei wane rakoi, eŋe zonom ma taboŋ met met wane ra rokop don qe barakke, so ea waneka mida, Yesu eŋe Anutu wane eŋine Magaine rake, eso eŋe yalewa raki paki, oŋomka Anuturop rokop weku takotkeke, ea wane eŋe detpi, sigileki, qekei wane rakoi. ");
INSERT INTO ons_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Paki so Yesuŋo edane rake, “Na ŋidanbe detpi, Magak mane wane Gipole eŋe oŋomka kine kine mane eŋine wetno mi okaniake. Midaka. Eŋe kaki Magaineŋo kine kine okaniake, eŋe yewaka mogare okaniake. ");
INSERT INTO ons_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Magak eŋe Gipolane zok similekaki, masi kine kine korop oŋom ma okanmaike yewa sikanka okanmaike. Eŋe baŋ masi kine kine kakapa suaine iwa kepo wane rokop mida ea yale, waka mayakane sikan kayake. Paki mo ŋine baŋ korop oŋaŋine qaeake. ");
INSERT INTO ons_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Magak eŋe ŋei seuseune ma wisikae one more, gege togon ebon okanmaike, rokop yale waka medep eŋe eŋine simileinane ŋei mane gegeine maratka more, gege togon manbe ra maniake. ");
INSERT INTO ons_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Me Magak oŋomka ŋei turuŋine eboniakane don mi rakoke ebon okanmaike, eŋe turuŋine rakoke ebo ebon wane urata yemo korop Gipole manwareke. ");
INSERT INTO ons_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ea wane ŋei ŋerep korop eŋe Magak ewine kito okanmami, rokop yale waka Gipole ewine kitokei. Ŋei mane eŋe Gipole ewine mi kitoyake, eŋe Magakŋo birakaki ketke, eŋe yale waka bakomine mi kitoyake. ");
INSERT INTO ons_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Na ŋidanbe detpi, ŋei mane eŋe naŋane don desiake, mo talenangi ketkole, eŋe weneŋ malip kayake, eŋe gege togon mo eaka marat kamaike, so eŋe sot turuŋ wane don urata mi mayake, midakaka. Eŋe seu seu mo ŋadekkake, wane ukude yemo gegeo waketke gemaike, so naso baŋem ge wayake. ");
INSERT INTO ons_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na ŋidanbe detpi, naso mo bomileake, naso mokaka bomilike wane ŋei seu seune eŋe baŋ Anutu Gipolane don desikei, paki mo eŋe done desikei, so eŋe wisikae wie, gege togon ge arikei. ");
INSERT INTO ons_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Magak eŋe gege ma wakone ebo ebon wane zonom eŋino pake, rokop yale waka Gipole eŋe gege ma wakone ebo ebon wane zonom mange. ");
INSERT INTO ons_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Eŋe Ŋei Wawainane Gipole, ea wane Magak eŋe turuŋ wane don ŋei rakoke eboniakane zonom mange. ");
INSERT INTO ons_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ŋine oŋaŋine misuk qaeki, naŋane don ea wane dereret urata maikei, naso mo bomilemaike, yewao ŋei seu seune deŋesereo pamami, eŋe korop eŋine boka wokaine desikei, ");
INSERT INTO ons_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","paki, eŋe baŋ deŋesereeno ŋine wie saket warekei, ŋei natne tanik manik mayakatne okangoi, eŋe baŋ wie more gege togon maratkaikei, ŋo ŋei natne tanik manik qotkoine okangoi, eŋe baŋ wie more, sotenane turuŋine don urata maikei.” ");
INSERT INTO ons_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Na nae wetno bonepnane urata mane maine mi makale, Anutuŋo nolatmaike, ea wane rokopkoka turuŋ wane don rakoke ebonmaile, eso noŋo, turuŋ wane don rakoke ebo ebon, yemo koboboine, onoka wane, na nae similene mogare urata yewa mi mamaile, na Magakŋo talenangi sarikole, eŋane donka teweke more mamaile. ");
INSERT INTO ons_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ŋo na noŋomka nae kinene ra wakongale, yemo don yewa ra wakonmaile, ea mo wele midaine okaniake. ");
INSERT INTO ons_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ŋo siluŋ ŋei mane yewa oŋo naŋane kine ra wakonmaike, paki na detmaile, eŋe naŋane kinene ra wakonmaike eamo welekatne. ");
INSERT INTO ons_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ŋine alakan Yohane wano don motpi arike, paki so oŋo don wele yewa ra wakonge. ");
INSERT INTO ons_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ŋei ŋido naŋane kinene ra wakongei wane na mi ra okanmaile, midaka, na iwa yale ra okanmaile, yemo weku, naŋane kinene detpi paki, gege togon ma wakon ŋuniakane ŋinŋinane ra okanmaile. ");
INSERT INTO ons_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane eŋe welekatne kiwa yale geke. Gemore laweke so qelaŋan ŋunge, paki so ŋine nasomde bamgoka eŋane qelaŋaninane simile detkoi. ");
INSERT INTO ons_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ŋo siluŋ naŋane tungo, maneŋo naŋane kinene ra wakon okanmaike, eŋe Yohaneŋo kinene ra wakone ŋibonge, ea wane rokop midakaka, eŋe zok manerop kakapa suaine. Na urata korop ma okanmaile, yemo Maganeŋo makalane ra ningane yewa ma okanmaile, wane urata ma okanmaile, yewaŋo nae tungo kinene ra qelaŋangi wakon okanmaike, so Magakŋo biranangi ketkole, yewa urataneŋo ŋei ŋerep sikanon okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","So Magakŋo biranangi ketkole, oŋom naŋane kine yale waka ra wakonge, ŋine eŋine aŋaino ŋine don mane mi detkoi, me eŋine kaitine mane mi kakoi, midakaka, ");
INSERT INTO ons_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","so ŋine eŋine donine yewa koto ŋino motpi paki, warekau mi pa okanmaike, onoka wane, ŋine birakaki ketke, eŋe wetŋineŋo mi malipka okanmami, yewa wane ŋine yaleoken okan okanmami. ");
INSERT INTO ons_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ŋine Anutu wane papiao pamaike yewa dapot okanmami, onoka wane, ŋine iwa yale det okanmami, yewa wane kotino ŋinŋine baŋ gege togon maratkaikei, so papia yewaŋoka naŋane kinene ra wakone okanmaike! ");
INSERT INTO ons_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ŋo onoka wane ŋine eweke more gege togon maratkaikei wane naŋano mi sari okanmami? ");
INSERT INTO ons_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Na ŋei edo sola mawa mawa kine kine okannanikei wane ma zuaŋ mi okane ramaile. ");
INSERT INTO ons_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ŋo na ŋinane kine mo detlukmaile, ŋinane kotoŋino yemo Anutu wane simileŋo mi paulukmaike. ");
INSERT INTO ons_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na Magak wane eŋetko eŋine tungo biranangi sarikole, ŋo ŋine siluŋ kima mi okan nanmami, gemage ŋei yauwine mane eŋine eŋetko sariki ŋine baŋ kima okankaikei. ");
INSERT INTO ons_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ŋine ŋidomka sola mawa mawa, ea wane yemo simile ŋun okanmaike, ŋo ŋine Anutu weku eŋano ŋine mawa mawa yewa mi togole more yuane mamami paki, mo daleo ŋine wetŋineŋo maine malipkaikei? ");
INSERT INTO ons_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ŋine naŋane iwa yale misuk desikei, oŋo ŋenane kineze eŋe baŋ Magaine ra wakone olasiake, i midakaka. Mose eŋe wekuŋo baŋ ra wakon ŋuniake. Moseŋo qesiŋ ŋoniake rau paki, eŋe mogatmami, oŋo baŋ ra wakon ŋuniake. ");
INSERT INTO ons_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ŋo ŋine welekatne Mose wane don dere malip kakoi ra, yemo naŋane don yale waka dere malip kaurap, onoka wane, Mose eŋe naŋane ra more don ea qeke. ");
INSERT INTO ons_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ŋo Moseŋo don qeke, yewa ŋine mi dere malip kakoi, paki mo daleo noŋo don ramaile, iwa maine dere malipkaikei me?” ");
INSERT INTO ons_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesu eŋe don yewa rawareki qoeki, zinge Galili Doku Namuŋ, eŋetine mane Tiberius Namuŋ, yuane eri woken arike. ");
INSERT INTO ons_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ariki ŋei ŋerep magu suaine edo ŋadino mogatka arikoi, onoka wane, eŋe zomarop eŋano urata togole maki paki ma menaŋ ongi kakoi, ea wane ŋadino arikoi. ");
INSERT INTO ons_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu eŋe meŋoine maneo wa more, pese ket dokoine eŋerop metke. ");
INSERT INTO ons_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Anutuŋo Yuda ŋei Loloŋonge, ea wane zonom ma taboŋ met met naso mo bomileke. ");
INSERT INTO ons_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu eŋe deine pore lolikke, paki ongi, ŋei ŋerep magu suaineŋo eŋano sarikoi, eso eŋe Pilip olale rake, “Ŋene diawao ŋine ŋara mane maine ŋei ŋerep magu suaine iwa eŋane rokop qole gume onikene?” ");
INSERT INTO ons_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Eŋe don iwa rake, yemo eŋe yaup Pilip liwekkake, ŋo Yesu eŋine kine kine dalino okaniake yemo mo detke. ");
INSERT INTO ons_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipŋo mainge olatke, “Ŋene beret 200 kina wane rokopŋo qole more, ŋei ŋerep magu suaine iwa gume onŋem neu, mi rokop oniake.” ");
INSERT INTO ons_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dokoine eŋane keuo ŋine mane Andrea, Saimon Petoro wane ŋoleŋo rake, ");
INSERT INTO ons_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Medep mane iwa oŋo beret mete mane (5) mamaike so zawon etke (2) magemaike, ŋo yalineŋo daleo ŋei ŋerep magu iwa maine rokop oniake?” ");
INSERT INTO ons_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesuŋo dokoine edange, “Ŋine ŋei ŋerep edanbi pese ket met wareu.” Yewao qiziŋ loutne pake, eso ŋei ŋerep korop eŋe mo ea pese met warekoi, metkoi ŋei ŋerep yewa eŋane zaleene 5, 000. ");
INSERT INTO ons_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu eŋe beret maki paki, Anutu meŋenka more mosopkaki paki ma louleke, eso damo qe, ŋei ŋerep mere arikoi, yewa ebonge. Eŋe rokop weku yewaka zawon etke yewa wane okange, pakiso eŋe koropŋo nekeiwane onge, ea wane rokop nekoi. ");
INSERT INTO ons_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Eŋe nemageu korop ŋatene qeke paki, Yesuŋo dokoine edane rake, “Ŋara natne qeligeu metmaike, yewa meikeu wakep, neneene tutule natne mane misuk mataliŋem payake.” ");
INSERT INTO ons_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Eso eŋe neu ŋateene qeki tutule pake, yewa korop mau ketmage kela 12 watkeke. ");
INSERT INTO ons_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Paki mo ŋei ŋerep yewa eŋe masi togogole ea Yesuŋo make, yewa kau paki rakoi, “Welekatne, iwa eŋe propet mane kepeo sari wakoniakane rakoi, ea mo iwa!” ");
INSERT INTO ons_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu eŋe mo detonge, eŋe sari mete togon mau paki, ŋei waomene birakaikei wane okangoi, yale okanbi, Yesu eŋe koso eŋineka zinge bonagao wake. ");
INSERT INTO ons_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kepe ketki rarapko Yesu dokoine eŋe doku namugo ketkoi. ");
INSERT INTO ons_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ket more seki kutno wakoi paki, koso zinge doku namuŋ yuane Kaperneam matkoken arikoi. Ruo kereki Yesu eŋe dokoine eŋano mi ari lotkeke. ");
INSERT INTO ons_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Paki so, dokoine enŋeneka geu momo togogole puangi dibom suaine wieke. ");
INSERT INTO ons_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yesu dokoine eŋe puli kito ariu 6 kilomita ea wane rokop okangi eŋe kau, Yesu eŋe doku kutno gesokma gesokma sarike. Sari seki osino lotkeki dokoine eŋe oŋaene qaeke. ");
INSERT INTO ons_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yale okanbi Yesuŋo edange, “Ŋine mi kaet okanbi. Iwamo noŋom sarimaile!” ");
INSERT INTO ons_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pakiso eŋe mo ea eweke more Yesu ma birakau seki koto wake, Eso mo mat arikei wane rakoi, yewaka sekiŋo ari lotkeke. ");
INSERT INTO ons_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kepe qaeki ŋei ŋerep magu eri doku namuŋ nat metkoi, eŋe kau seki weku qeliŋkau yewa metke. Ŋei ŋerep eŋe mo detkoi, Yesu eŋe dokoine eŋerop sekiwo weneŋ mi wa arikoi, ŋo eŋe Yesu qeliŋka enŋeneka arikoi. ");
INSERT INTO ons_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Seki natne Taiberias ŋine sarikoi edoka sari Waomŋo beret meŋenka more ŋei ŋerep magu suaine ebongi nekoi, qezarek ea wane osino sari kitokoi. ");
INSERT INTO ons_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ŋei ŋerep magu eŋe onbi, Yesu eŋine so dokoine yewa mi metkoi, pakiso, seki kutno wa so, koso zinge Kaperneam matko Yesu zuaŋka arikoi. ");
INSERT INTO ons_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ŋei ŋerep eŋe doku namuŋ nat paromino Yesu maratkau paki olale rakoi, “Ge naso dango iwa sarine?” ");
INSERT INTO ons_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesuŋo mainge edange, “Na ŋidanbe detpi, ŋine na nanikei wane zuaŋ nanmami, yemo bret gumeŋunbe korop neu ŋatŋine qike, kine ea wane zuaŋ nanmami, ŋo ŋine noŋo urata mawe zonom togogole ka ma okanmaile, ea wane kine detlukeu paki, mi zuaŋ nanmami. ");
INSERT INTO ons_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ŋine ŋara esatka bori okanmaike, yalinane urataine misuk maikei, ea wane turuŋine yemo ŋara bori worine midaine banine paki gege togon marat kaikene, ea wane urataine maikei. Ŋara iwa yemo baŋ Ŋei Wawainane Gipoleŋo ŋiboniake, onoka wane Magak Anutuŋo eŋet biŋek mo gege togon wane ŋara ŋiboniakane naŋane kutno motke.” ");
INSERT INTO ons_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Eŋe Yesu qesonka rakoi, “Ŋene daleo okane more Anutu wane urata maine maikene?” ");
INSERT INTO ons_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Pakimo Yesuŋo doneene turuŋine mainge more edane rake, “Weku ŋeiwa birakaki ketke eŋane don dere malipkaikei.” ");
INSERT INTO ons_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Eŋe mainge rakoi, “Ge onokaka masi togogole mane baŋ manom, ŋene yewa maine kaikene paki donŋone dere malipganikene? Ge onokaka urata mane maikene? ");
INSERT INTO ons_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ŋenane aso ŋaboze eŋe kepe yaup papaino Anutu wane ŋara ne gekoi. Anutu wane Papiao iwa yale ramaike ea wane kop, ‘Eŋe qeliwo ŋine ŋara nekeiwane ebonge.’” ");
INSERT INTO ons_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Rau so Yesuŋo iwa yale edange, “Na ŋidanbe detpi! Moseŋo ŋibonge, yewa yemo qeli wane ŋara mi ŋibonge, ŋo naŋane Maganeŋo yemo welekatne qeli wane ŋara ŋibon okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Anutuŋo sogino kepe yaup papaino yemo kepe wane ŋara ŋibonge, koso naso iwao yemo ŋei mane mo birakaki ketke, eŋe ŋei ŋerep kepe baŋem gege togon wane ŋara wele ma wakone ŋiboniakane.” ");
INSERT INTO ons_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Raki mo eŋe olale rakoi, “Suaine, ge siluŋ ŋara yewa naso baŋem ŋebon okanikene.” ");
INSERT INTO ons_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yale raumo Yesuŋo iwa yale edange, “Na gege togon wane ŋara, mane eŋe naŋano sariake, eŋe baŋ ŋara wane mi seukeake. Ŋo mane eŋe na malipnaniake, eŋe baŋ doku wane mane mi seukeake. ");
INSERT INTO ons_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na ukude mo ŋidanbe ŋine mo nanimi, ŋo siluŋ baŋ mi malip nanikei. ");
INSERT INTO ons_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Maganeŋo ŋei ŋerep nin okanmaike, korop yewa eŋe baŋ naŋano lotke warekei, mane eŋe naŋano lotkeake na baŋ mi mainkawe ariake. ");
INSERT INTO ons_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na qeliwo ŋine kepo ketkole, yemo onoka wane mida, Magakŋo talenange, paki na eŋane don dereret mogare ketkole, ŋo na nae don dereret mogare mi ketkole. ");
INSERT INTO ons_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na Magak wane simile mogare ketkole, yemo Maganeŋo ŋei ŋerep korop ninwareke, yewa eŋano ŋine natne qeliŋ onbe mi siukkei, ŋo siluŋ naso qoeki na korop ma wirik onbe wisikae wie warekei, ");
INSERT INTO ons_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Maganane simile yemo iwa yale, ŋei ŋerep korop eŋe Gipole ka okanmami so malipka okanmami, eŋe gege togon marat kawarekei. Paki mo na baŋ naso qoeki ma wirik onbe wisikae wie warekei.” ");
INSERT INTO ons_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesu eŋe don iwa yale Yuda eŋe detpi rake, “Na ŋara qeliwo ŋine ketkole.” Eŋe yale rakane Yuda ŋei eŋe kieke dere worik kau paki eŋane don rakoi. ");
INSERT INTO ons_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Paki so eŋe iwa yale rakoi, “Ŋei iwa eŋe Yesu, Yosep wane gipole me? Ŋene eŋane magaine so nagaine mo det otmaine me? Paki mo eŋe onoka wane eŋe qeliwo ŋine ketke ramaike?” ");
INSERT INTO ons_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesuŋo mainge edane rake, “Ŋine ŋidomka don zok ramami yewa qeligeu. ");
INSERT INTO ons_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ŋei mane eŋe oŋomka simileinane naŋano maine mi sari lotkeake. Midakaka! Magakŋo talenangi ketkole oŋo tebakaki yemo naŋano lotkeake, paki mo na baŋ naso qoeyake, naso yewao deŋesereo ŋine ma wirik kawe wisikae wieake. ");
INSERT INTO ons_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Propet eŋane papiao don iwa yale qekoi, ‘Ŋei ŋerep korop eŋe baŋ Anutu oŋom miti don kito edaniake.’ Mane eŋe Magak wane don desiake so eŋano ŋine dereret mayakeŋo, naŋano sari lotkeake. ");
INSERT INTO ons_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ŋei maneŋo Magak mane mi kake, eŋe mo kake ea mane mi ramaike, midakaka, Anutu wanoŋine ketke, eŋe weku oŋoka Magak kakane ramaike. ");
INSERT INTO ons_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Na ŋidanbe detpi! Ŋei mane eŋe na malipnaniake, eŋe gege togon marat kayake. ");
INSERT INTO ons_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na gege togon wane ŋara. ");
INSERT INTO ons_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ŋinane aso ŋabokop ŋine eŋe kepe yaup papaino Anutu wane ŋara ne gekoi, ŋo siluŋ seukwarekoi. ");
INSERT INTO ons_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ŋo ŋara mane qeliwo ŋine ketke, ŋei mane eŋe ŋara yewa neake eŋe mane mi seukeake. ");
INSERT INTO ons_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na ŋara gegeinerop qeliwo ŋine ketkole, ea wane ŋei mane eŋe ŋara yewa neake, eŋe naso baŋem ge ariake, ŋara yewa na baŋ eŋe manikale, yemo nae bikumne. Yewa kepe baŋem ŋei ŋerep eŋe gege togon ma wakone ebongi ge arikei.” ");
INSERT INTO ons_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Don iwaŋo Yuda ŋei eŋano sot osi osi ma wakongi edomka auye kito qok okane qesone rakoi, “Ŋei iwa eŋe daleo okangi paki bikumine iwa ŋebongi nekenane ramaike?” ");
INSERT INTO ons_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Rauso Yesuŋo edane rake, “Na ŋidanbe detpi! Ŋine Ŋei Wawainane Gipole wikile detke, bikumine ea mi detluka nekei, so eŋane weŋemine, ea mi malipka nekei, ŋinane wetŋino gege togon wane numa mane mi wakone payake. ");
INSERT INTO ons_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ŋei mane eŋe naŋane bikumne so weŋemne neake eŋe gege togon marat kayake. Paki mo na baŋ naso qoeki ma wirik kawe wisikae wieake. ");
INSERT INTO ons_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Naŋane bikumne yewaŋo ŋara wele, naŋane weŋemne yewaŋo doku wele. ");
INSERT INTO ons_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ŋei mane eŋe naŋane bikumne neake so weŋemne neake eŋe naŋane kotono geake, ŋo noŋo eŋane kotino gekale. ");
INSERT INTO ons_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Magak gegeinerop ŋo talenangi ketkolane, eŋane ra more na yale waka gege togon gorop gemaile. Rokop yale waka ŋei mane naŋane bikumne neake, eŋe baŋ naŋane raki paki gege togon gorop okaniake. ");
INSERT INTO ons_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iwa yemo ŋara weti qeliwo ŋine ketke, ŋara ea ŋinane aso ŋabokop ŋine kepe yaup papaino ne gekoi, ŋo siluŋ koso seukwarekoi, yaline midakaka! Ŋei mane eŋe ŋara weti qeliwo ŋine ketke, yewa neake, eŋe baŋ gege togon naso baŋem ge ariake.” ");
INSERT INTO ons_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu eŋe don iwa raki paki, Yuda eŋane miti lewa lewaŋ urumgo Kaperneam matko kito edange. ");
INSERT INTO ons_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dokoine eŋe Yesu wane don ea detkoi paki, loutneŋo don yewa detpi paki rakoi, “Don iwa yemo zok umatne okanmaike. Maŋo maine desiake?” ");
INSERT INTO ons_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu eŋe dokoine don edange, eŋe ea dere umareu paki, ea wane maneŋo Yesu mainge mi olatkoi, Yesu eŋe wetineŋo mo oŋomka detki paki, qeson one rake, “Don iwa detpi ŋibumaikane qeliŋgei me? ");
INSERT INTO ons_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pakimo, Ŋei Wawainane Gipole eŋe koso zinge kere alakan gekeo, waki ŋine kau paki detpi daleo okaniake? ");
INSERT INTO ons_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anutu wane Asuŋo ŋei gege ma wakone ebon okanmaike. Ŋei wane sola bikumŋo gege ma wakone ebo ebon yemo mi paulukmaike. Na don iwa ŋidanmaile, yemo Asurop so gegeinerop. ");
INSERT INTO ons_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ŋo siluŋ ŋinano ŋine natne eŋe dere mi malip kamami!” Yesu eŋe mo qei kino kieke more detke, ŋei diawa edo donne dere mi malipkaikei, ŋei yewaŋo ŋaba eŋano siron qeki neukei, ŋei yewa eŋe modatkake. ");
INSERT INTO ons_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Paki koso takotke edange, “Na kine yalewa wane ŋidane rakole, ‘Ŋei mane eŋe Magakŋo mi ma ewekkaki naŋano sari lotke gege, ea mo mi pamaike.’” ");
INSERT INTO ons_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Naso yewaoka dokoine eŋane keueno ŋine loutneŋo eŋe ŋadekka more arikoi, eŋane ŋadino koso mi arikoi. ");
INSERT INTO ons_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Pakiso Yesuŋo dokoine 12 edane rake, “So ŋine yale waka qeliŋnane ariwarekei me?” ");
INSERT INTO ons_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Petoroŋo olale rake, “Waom ŋene ge qeliŋgane koso maŋano arikene? Ge don kito ŋedan okanmaine, yewaŋoka weku gege togon ŋeboniake. ");
INSERT INTO ons_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","So ŋene mo malip ganmaine, so mo detlukmaine, ge Koboboine Weku Anutu wano ŋine ketkone.” ");
INSERT INTO ons_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesuŋo mainge edange, “Na ŋine ŋei magu 12 mo ma wakon ŋungole, ŋo siluŋ ŋinane keu ŋino ŋine maneŋo asu qotkoinane biŋek okanmaike!” ");
INSERT INTO ons_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Eŋe Yudas Iskariot wane rake, eŋe Saimon Iskariot wane gipole. Yudas Iskariot eŋe dokoine 12 ebuke, eŋane keueno ŋine, eŋe baŋ siron qeki, ŋaba edo Yesu ma more qeu seukke. ");
INSERT INTO ons_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ea wane ŋadino kaiwe mama natne Yesu eŋe Galili kepeo lolike arike. Eŋe Yuda kepeo ariakane mi kake, onoka wane, Yuda ŋei ŋetne eŋe qekei wane okangoi, ea wane. ");
INSERT INTO ons_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yuda ŋei eŋane Seli Kise ea wane taboŋ met met wane nasoine mo bomileke. ");
INSERT INTO ons_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Pakiso, Yesu ŋolekoune eŋe olale rakoi, “Ge mat iwa qeligenom paki Yuda kepeo arinom paki, geŋone dokoŋone eŋe urata korop kuneŋine ge mamaine, ea kaikei. ");
INSERT INTO ons_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ŋei mane eŋe ŋei ŋerep koropŋo detkaikei wane raki paki, urata sanka mi ma okanmaike. Ge kine kine yaline makenane ramaine, yemo ge didiwo okoranom paki, kepe baŋem ŋei ŋerep eŋane deo manom, eŋe geŋane kine desikei!” ");
INSERT INTO ons_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Eŋine ŋolekoune eŋe yale waka done dere mi malip kakoi, paki eŋe yale wane eŋe don ea rakoi. ");
INSERT INTO ons_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ea wane Yesuŋo doneene turuŋine mainge edane rake, “Naŋane naso yemo mi bomile sarimaike. Naso natne korop yemo ŋinane naso. ");
INSERT INTO ons_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kepe ŋei ŋerep eŋe ŋine maine mi qaisik ŋunikei, ŋo na yemo qaisik nanmami, onoka wane gege mageene borikine yewa tako rakot ra wakone edanbe, ea wane qaisik nanmami. ");
INSERT INTO ons_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ŋine ŋidom ari taboŋ met met wane naso yewa kau, ŋo na yemo taboŋ met met iwao mi arikale, onoka wane naŋane nasone mi bomile sarimaike, ea wane.” ");
INSERT INTO ons_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu eŋe don yalewa edange, Pakiso eŋe Galili kepeoka toma geke. ");
INSERT INTO ons_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu ŋolekoune eŋe Seli Kise wane taboŋine met met ea mesikei wane alakane arikoi. Pakiso Yesu eŋe yale waka ŋado eŋineka arike, eŋe didiwo mi arike, eŋe sanka arike. ");
INSERT INTO ons_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yuda ŋei ŋetne eŋe Seli Kise taboŋine metkoi, yewao Yesu zuaŋkakoi. Paki qesone rakoi, “Eŋe diao gemaike?” ");
INSERT INTO ons_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ŋei ŋerep magu suaine eŋe eŋane donka saŋepka zok ra wakoi. Pakiso, ŋei ŋerep natne edo rakoi, “Eŋe ŋei maine.” Rauso natne eŋe rakoi, “Mida, eŋe ŋei wet ma siuk okan okanonmaike.” ");
INSERT INTO ons_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ŋo siluŋ maneŋo eŋane don suaineka didiwo mi rake, onoka wane eŋe Yuda ŋei ŋetne eŋane kaetongi yale okangoi. ");
INSERT INTO ons_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Seli Kise wane taboŋine metpi, keuno okangi Yesuŋo Bakom urumgo waki, paki kieke ŋei ŋerep miti kito edange. ");
INSERT INTO ons_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pakiso, Yuda ŋei ŋetne eŋe zok manerop oŋaene qaeki rakoi, “Ŋei iwa eŋe kibi urumgo mi wake, ŋo daleo okane more, miti wane kine zok detlukmaike?” ");
INSERT INTO ons_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Rauso Yesuŋo edane rake, “Na miti wane kine kito ŋidan maile, yemo naewo ŋine mida. Iwamo talenangi ketkole, Anutu wano ŋine sarimaike. ");
INSERT INTO ons_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ŋei mane eŋe eweke more, Anutu wane don dere tewekeakane, naso eŋe baŋ na miti don kito ŋidanmaile, ea wane kine iwa desiake, na don kito ŋidanmaile, yewa mo Anutu wano ŋine sarimaike, me na nae dereretko ŋine sarimaike. ");
INSERT INTO ons_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ŋei mane eŋine dereretino ŋine don ŋidaniake, eŋe oŋomka eŋine eŋet biŋekine ora mawakaikei wane okaniake, ŋo ŋei mane eŋe talekaki ketke, eŋane eŋet biŋekine ora mawa kayake, ŋei yewa eŋe wawaineine midaine. So eŋano isi don mane mi pamaike. ");
INSERT INTO ons_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ŋine sogino Moseŋo ra rokop don ŋibonge, ŋo siluŋ ŋinane keuo ŋine maneŋo ra rokop don yewa mane mi tewek okanmaike, paki mo ŋine onoka wane na nekukei wane okanmami me?” ");
INSERT INTO ons_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ŋei ŋerep magu eŋe mainge olale rakoi, “Ge asu qotkoineŋo koto ŋono ket gemaike, maŋo gekuki seukkenane okanmaike me?” ");
INSERT INTO ons_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesuŋo edane rake, “Na urata kakapa weku ŋei mane ma menaŋ kakole, paki mo ŋine korop oŋaŋine qaeke. Pakimo, ea wane ŋine na nekukei wane okanmami? ");
INSERT INTO ons_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Onoka wane Moseŋo gipolekop ŋine solaene sisine kitatkei wane ra ŋunge mane, yemo Moseŋo mida, yemo ŋinŋine aso ŋabokopŋine edo masi ea mo kiekkoi, ea wane ŋine baŋ medewekopŋine baŋ zonom ma taboŋ met met naso yewao solaene sisine kitasikei. ");
INSERT INTO ons_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Medep mane zonom ma taboŋ met met naso yewao solaine sisine kitasikeiwo, Mose wane ra rokop don yewa baŋ mi qe barakkei me? Paki mo ŋine onoka wane noŋo zonom mama nasoo ŋei mane mawe menaŋge, ea wane ŋine naŋane sotŋine osimaike? ");
INSERT INTO ons_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ŋine deŋineŋo kine kine one more, misuk one wanok onikei, ŋine kine kine one wanok onikei, yemo masi tanik bile me koboboine gege, eaŋo wele okaniake.” ");
INSERT INTO ons_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ŋei ŋerep natne Yerusalem ŋine eŋe kau Yesuŋo kine kine make so okange, ea wane eŋe rakoi, “Ŋei iwa ŋei ŋetne edo suaine qekei wane zok ra okanmami, iwa mo daleo? ");
INSERT INTO ons_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kau! Eŋe lewa lewago don ra okanmaike, paki mo eŋe don olale mi rawetka okanmami! Ea welekatne ŋei ŋetne eŋe detkamami, eŋe Mesia kaki wane? ");
INSERT INTO ons_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ŋo ŋei iwa wane wako wakon matinane kine ŋene koropŋo detka waremaine, ŋo Waomŋo ŋeiwa Mesia birakaki sariakane ra rokop donine rake, ea wakongi, ŋei maneŋo eŋane kine ea maine mi desiake.” ");
INSERT INTO ons_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu eŋe Bakom Urumgo miti don kito edane okora don suaineka iwa yale ra edange, “Ŋine welekatne na detnanmami, so na matne dia ŋine sarikole ea detmami me? Ŋo siluŋ na noŋomka mi sarikole, na maganeŋo talenangi sarikole, ea mo welekatne, ŋo ŋine ea mo maine mi detluk kamami. ");
INSERT INTO ons_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ŋo na yemo, na eŋe detluk kamaile, onoka wane, na eŋerop gema gewe mo, oŋo talenangi sarikole.” ");
INSERT INTO ons_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Paki, eŋe don ea dere more ma lukkakei wane okangoi, ŋo siluŋ ŋei maneŋo metine bira solaino mi uakake, onoka wane makei wane nasoineŋo mi bomileke. ");
INSERT INTO ons_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ŋo siluŋ ŋei ŋerep magu suaine eŋano ŋine loutneŋo malipka rakoi, “Mesia sariakane, Anutuŋo nasoine mo sogino ra more ra rokop donine rake, wane yewaŋo sariakeo, eŋe ŋei iwaŋo masi kine kine togogole mamaike, ea korop baŋ oŋo yuanka more, masi kine kine natne wawaineka ma wareake me?” ");
INSERT INTO ons_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ŋei ŋerep magu eŋe Yesu wane don kine kine loutne saŋepka auye qeuye okane ramageu, Parisi eŋe detkoi, paki eŋe so Pris Ŋetne Suaine, eŋe au more tebe ŋei natne taleongoi, eŋe ari Yesu ma lukkakei wane. ");
INSERT INTO ons_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pakiso Yesuŋo rake, “Na nasomde nigatne bamgoka ŋinerop gekale, ŋo na baŋ zinge Magak talenangi ketkole, eŋano koso arikale. ");
INSERT INTO ons_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ŋine baŋ zuaŋnanikei, ŋo ŋine baŋ mi marat nanikei, onoka wane na mat gekale, yewao ŋine mi arikei.” ");
INSERT INTO ons_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yuda ŋei ŋetne eŋe edomka auye rakoi, “Eŋe diawao ariki ŋene zuaŋka mi marat kaikene? Eŋe Grik eŋane mat suaine pa arimaike, yewao Yuda ŋei gemami eŋano ariake, paki mo Grik ŋei miti don kito edaniake me? ");
INSERT INTO ons_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Eŋe ramaike, ‘Ŋine baŋ zuaŋ nanikei, so ŋine baŋ mi marat nanikei,’ so, ‘Na mat gekale, yewao ŋine mi arikei,’ kine daleo wane don yewa ramaike?” ");
INSERT INTO ons_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Taboŋ mere eŋet miti oko okan naso yewa kaiwe qoi qoine metkoi. Naso yewaŋo naso suaine okanmaike. Kaiwe yewao Yesuŋo wie okorake paki, suaineka boka rake, “Ŋei mane eŋe dokuinane seukki paki naŋano sari doku neake. ");
INSERT INTO ons_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Anutu wane Papiaŋo iwa yale ramaike, ‘Ŋei mane eŋe na malip naniakeo, yemo eŋane kotino ŋine gege togon wane doku deine matkine qake ket sik salalak qe payake.’” ");
INSERT INTO ons_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu malip kakoi, ŋei yewa edo Asu maikei wane don iwa rake, naso yewao Asu mi ebonge, yemo onoka wane mida, Yesuŋo don ea rake, eŋe qeli ewe zonomine kotino mi wake, so Asu mi birakaki ketke, mida, baŋ seukki paki qeliwo wake, naso yewao, Asuŋo doku tau tau magu eŋano ket zonom ebonge. ");
INSERT INTO ons_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ŋei ŋerep magu suaine eŋano ŋine loutne edo don iwa raki detkoi, paki eŋe rakoi, “Ŋei iwa, eŋe welekatne propet Anutuŋo birakaki, kepo sariakane rake, tomaka gemaine, eŋe mo iwa!” ");
INSERT INTO ons_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Natne eŋe rakoi, “Iwa mo Mesia welekatne!” Ŋo natne eŋe rakoi, “Mesia eŋe baŋ Galili kepeo mi wakoniake! Eŋe mat yauwine okanmaikane, ea maine mi wakoniake, midakaka. ");
INSERT INTO ons_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Anutu wane papiaŋo ramaike, yemo baŋ Mesia eŋe Dawit wane ŋosa wili wiliine eŋane keuo ŋine, so eŋe baŋ Betlehem matko, Dawit mat geke, yewao wakoniake.” ");
INSERT INTO ons_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Eso ŋei ŋerep eŋe wetene wiri poripke magu etke okangoi, yemo Yesu wane rau paki, ");
INSERT INTO ons_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","natne eŋe ma lukkakei wane okangoi, ŋo siluŋ ŋei maneŋo metine bira solaine mi uakake. ");
INSERT INTO ons_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tebe ŋei eŋe koso zinge Pris Ŋetne Suaine so Parisi eŋano arikoi. Pakiso, eŋe qeson one rakoi, “Ŋine onoka wane mi ma sarimami?” ");
INSERT INTO ons_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tebe ŋei eŋe mainge edane rakoi, “Ŋei maneŋo sogino ŋei iwa don ramaike, yalewa mi rake!” ");
INSERT INTO ons_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Rauso, Parisi eŋe qeson one rakoi, “Eŋe ŋine yale waka wet masiuk okanŋunike me? ");
INSERT INTO ons_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ŋine detpi, ŋenano ŋine ŋetne mane, me Parisi maneŋo eŋane don dere malip kamaike me? I Midakaka. ");
INSERT INTO ons_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ŋei ŋerep magu eŋe malip kamami iwa, eŋe Mose wane ra rokop don yewa mi detmami, ea wane eŋe Anutu wane soa yewa wane bano waketmami!” ");
INSERT INTO ons_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Eŋano ŋine mane Nikodemus, ŋei yewa oŋo alakan Yesu kayakane arike, oŋo edane more rake, ");
INSERT INTO ons_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ŋenze ra rokop don wane rokopko, ŋene ŋei mane yaup dongo mi birakaikene, ŋene mikepka kineine detkaikene, so eŋe sot okange yewa kaulukkene.” ");
INSERT INTO ons_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Eŋe mainge rakoi, “Ea maine, ŋo ge yale waka Galili ŋine me? Papia dapot lukenom paki, kine desikene, propet mane Galili kepeo ŋine sari arine, ea mo mane mi pamaike.” ");
INSERT INTO ons_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ŋei ŋerep korop eŋe mateno ariwarekoi, ŋo Yesu eŋe Oliwa Bonagao wake. ");
INSERT INTO ons_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kepe qaeki sakoka eŋe koso zinge ari Bakom Urumgo wake, ŋei ŋerep korop eŋe sari qeatkakoi, pakiso, Yesu eŋe pese ket mere so kieke miti kito edange. ");
INSERT INTO ons_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ra rokop don kito ebo ebon so Parisi eŋe bailalaŋ ŋerep mane yau yaup geki marat kakoi, yewa Yesu wano ma ari birakau keueno ŋei ŋerep deeno okorake. ");
INSERT INTO ons_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Pakiso, Yesu olale rakoi, “Kito ŋebo ŋebon, ŋerep iwa eŋe bailalaŋ maki kakoi, ");
INSERT INTO ons_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","so ŋenze ra rokop dongo Moseŋo mo ra togole ŋebonge, ŋerep mane yaline okangi, eŋe maine wesiŋo qeu seukeake. Paki mo goŋo daleo ramaine?” ");
INSERT INTO ons_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Eŋe don iwa rakoi yemo liwekkakoi, don mataliki don urata bira kaikei wane. Ŋo siluŋ Yesu eŋe kuge ket more metineŋo kepo kibi qeke. ");
INSERT INTO ons_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Eŋe yewaka okorau paki, qeso qeson zok qesonkau eŋe kaŋ qae wieki paki edane rake, “Ŋinane keu ŋino ŋine mane borikine mi ma okanmaike, oŋo maine mikep alakane more wesiŋo qeake.” ");
INSERT INTO ons_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Eŋe koso kuge ket kepo metineŋo kibi manerop qeke. ");
INSERT INTO ons_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Eŋe yale detpi paki, korop saket weku weku ariwarekoi, ŋetne edo alakane saketpi so, ŋei natne eŋe ŋado saket ari warekoi, biraka ari wareu Yesu eŋineka okorake, ŋo ŋerep eŋe yewa eŋineka Yesu wane kaitko okorake. ");
INSERT INTO ons_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu eŋe kaŋ qae wieki paki ŋerep qesonka rake, “Ŋerep, ŋei iwa eŋe diao ari waremami? Maneŋo mi qeliŋkau, iwa okora dongo mi bira ganmaike?” ");
INSERT INTO ons_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ŋerepŋo rake, “Suaine, maneŋo iwa mi okoramaike.” Raki so Yesuŋo olatke, “Ea maine, noŋo yale waka sot turuŋŋonane dongo mi bira ganikale. Arinom paki, borikine koso manerop misuk maikene.” ");
INSERT INTO ons_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu eŋe koso manerop ŋei ŋerep edane rake, “Na kepe baŋem eŋane kiwa qelaŋaninerop, mane eŋe naŋane ŋadeno mogatnane sariake, eŋe gegeinane kiwa togogole marat kayake, so eŋe panamango mane mi geake.” ");
INSERT INTO ons_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Raki so Parisi eŋe Yesu olale rakoi, “Ge goŋomka geŋone kineŋone ea ra wakone, urata so tanik manikŋone, ea ra qelaŋanmaine, yalinane ŋei eŋe geŋane don ramaine, yewa maine mi malip kaikei.” ");
INSERT INTO ons_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesuŋo mainge edane rake, “Mida, ŋo na noŋomka nae kinene welekatne ra wakone ramaile, yemo wele, ea wane ŋei ŋerep eŋe naŋane don dere maine malip kaikei, onoka wane, na diao ŋine wie sarikole, yewa detmaile, so diao arikale, yewa weneŋ detmaile. Ŋine yemo diao ŋine sarikole, me diao arikale, yewa mo mi detmami. ");
INSERT INTO ons_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ŋine yemo kepe ŋei eŋane kine tile tilek urata yewa ma okanmami, ŋo na yemo ŋei mane wane kine mi tilek okanmaile. ");
INSERT INTO ons_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ŋo na ŋei mane wane kine tile tilek urata makaleo, ŋei eŋe naŋane don ramaile maine, ea malipkaikei, ea yemo, naŋane kine tile tilek urata yewa wele okaniake, onoka wane, na noŋomka urata iwa mi mamaile, Magak talenangi ketkole, eŋe weneŋ narop ge more qesiŋ nanmaike. ");
INSERT INTO ons_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ŋinŋine ra rokop dongo iwa yale qekoi pamaike, ŋei etkeŋo don wekuka dere raikeik, yewaŋo don wele. ");
INSERT INTO ons_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na noŋomka nae kine ra wakonmaile, paki, Magak talenangi ketkole, eŋe yale waka naŋane kine ra wakon okanmaike, so ŋere etkeŋo don wele wekuka ra wakonmaite yewaŋo wele.” ");
INSERT INTO ons_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yale raki Parisi eŋe qesonka rakoi, “Magaŋone ramaine, eamo eŋe diao gemaike?” Yesuŋo mainge iwa yale edange, “Ŋine na mi detluk nanmami, wane ŋine yale waka Magak weneŋ mi detluk kamami, ŋo ŋine na detluk nanikei, yemo ŋine Magak yale waka detluk kaikei.” ");
INSERT INTO ons_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu eŋe Bakom Urumgo wesi katapa metkoi, urum yewao miti kito edangi paki, don iwa korop rake, pakiso eŋano ŋine maneŋo mi ma lukkake, onoka wane, eŋe ma lukkaikei wane nasoineŋo mi bomilekane yeine qeliŋ kakoi. ");
INSERT INTO ons_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu eŋe koso manerop ŋei ŋerep edane rake, “Na biraŋune arikale, ŋo ŋine baŋ zuaŋ nanikei paki, borikine ŋinerop ge mage baŋ seukeu paki, sora gerep wane biŋek okanikei. Na arikale, mat yewao ŋine maine mi arikei.” ");
INSERT INTO ons_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Raki so Yuda ŋei ŋetne eŋe edomka enŋene au rakoi, “Eŋe ramaike, ‘Na arikale mat yewao ŋine maine mi arikei, ‘ eŋe oŋomka solaine yaku seukeakane ra ramaike me?” ");
INSERT INTO ons_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesuŋo mainge edange, “Ŋine qei kepe wane kutno ŋine wakongoi, ŋo na yemo weti qeli welaine qeliwo ŋine ketkole. Ŋine kepe iwa ŋine sarikoi, ŋo na yemo kepe iwa ŋine mi sarikole. ");
INSERT INTO ons_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kine yale wane na ŋidane ramaile, ŋine baŋ borikine ŋinerop ge mage seuk warekei. So na mat yewa ŋine ra more mi dere malip kaikeiwo, yemo ŋine baŋ borikine ŋinerop ge mage seuk warekei.” ");
INSERT INTO ons_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pakiso eŋe qesonka rakoi, “Ge ma?” Rauso Yesuŋo edane rake, “Na ma? Yemo qei kino ŋidangole, ŋeiwa yewa yemo na iwa, ");
INSERT INTO ons_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","na ŋinane sot kine kine zok loutne, ea wane don ra okanmaile, so na sot kine kine ŋine yewa dere wanok okangale, so na maine mi ra wakon warekale, Magakŋo talenangi ketkole, eŋe wekuku, eŋane don yemo wele, na eŋane piino ŋine don kine kine korop detkole, na don weku yewa kepeo ŋei ŋerep korop ra edan okanmaile.” ");
INSERT INTO ons_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Magainane don yalewa ra edangi, eŋe mi detlukkoi. ");
INSERT INTO ons_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ea wane, Yesuŋo takotke edane rake, “Baŋ ŋado ŋine Ŋei Wawainane Gipole kibego mawa qe kaikei, naso yewao, ŋine iwa yale desikei, na noŋomka Magakŋo biranangi ketkole, na noŋomka yalewa gemaile, ea baŋ detlukkei, so na nae dereretko ŋine kine kine mi ra ma okanmaile, ea midakaka! Ŋo siluŋ kine kine ra ma okanmaile, yemo Magakŋo kito ninge, yewa ra wakon okanmaile. ");
INSERT INTO ons_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","So magakŋo talenangi ketkole, eŋe narop ge okanmaike, eŋe qeliŋnangi naeka mi ge okanmaile, midakaka, eŋe naso baŋem urata kine kine ma okanmaile, yewaŋo Magak wet pesek ma okanmaike.” ");
INSERT INTO ons_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu eŋe don yale raki, ŋei ŋerep loutne eŋe dere malip kakoi. ");
INSERT INTO ons_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ea wane Yesu eŋe Yuda ŋei donine dere malip kakoi, yewa edane rake, “Ŋine naŋane don dere togogoleka tewekkei, yemo ŋine naŋane dokone aposolo wele okanikei. ");
INSERT INTO ons_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Paki mo ŋine don welekatne ea wane kine desikei, detpi don welekatne yewaŋo siwot ŋungi, sot wane mulap midaine gekei.” ");
INSERT INTO ons_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Raki mo, eŋe don iwa yale mainge olale rakoi, “Ŋene Abraham wane doko ŋosa ŋabokoune, ŋene ŋei mane wane qelit qeqe mane mi okane gekone, wane ge onoka wane don iwa yale ramaine, ‘Ŋine mulap midaine gekei?’” ");
INSERT INTO ons_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Rauso, Yesuŋo edange, “Na ŋidanbe detpi, ŋei korop eŋe borikine ma okanmami paki, eŋe borikinane qelit qeqe yauwine okan okanmami. ");
INSERT INTO ons_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Qelit qeqe ŋei yauwineŋo Magak wane mat koto naso baŋem mi geake, midakaka, Gipole eŋine kotino ŋineŋo yemo naso baŋem yewa ge okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ea wane Gipoleŋo siwot ŋungi, mulap midaine gekei, yemo ŋine mo welekatne sot wane mulap midaine gekei. ");
INSERT INTO ons_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ŋine Abraham wane ŋosa ŋabokoune na yewa detmaile, ŋo ŋine koso siluŋ nekukei wane okanmami, onoka wane, naŋane don ŋidan okanmaile, yewaŋo ŋinane koto ŋino mi ketmaike, ea wane. ");
INSERT INTO ons_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na maganeŋo kine kine sikannange, ea wane done ra wakon okanmaile, ŋo ŋine yemo maga ŋineŋo don so kine kine ŋidange, yewa okan okanmami.” ");
INSERT INTO ons_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Raki so Yuda eŋe Yesu wane don mainge olale rakoi, “Ŋenane asoze yemo Abraham,” Yesuŋo mainge edane rake, “Ŋine welekatne Abraham wane ŋosakoune ra, yemo ŋine Abraham wane numa mogare urata make, ea wane rokop okanbi rap. ");
INSERT INTO ons_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na Anutu wano ŋine don welekatne detkole, don yewa ŋine ŋidan okanmaile, paki mo, ŋine nekukei wane okanmami, Abraham wane masi mane yaline mi okange, midakaka! ");
INSERT INTO ons_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ŋine yemo magaŋinano masi tanik manik pa okanmaike, yale waka okanmami.” Eŋe mainge rakoi, “Ŋene Magaze Anutu eŋe weku, ŋene eŋine gipole koune wele.” ");
INSERT INTO ons_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesuŋo edane rake, “Anutu eŋe welekatne ŋinane magaŋine ra, yemo ŋine naŋane simileŋungi rap, onoka wane na Anutu wano ŋine ketkole, so ukude na iwa gemaile, na nae wetno mi ketkole, Anutuŋo talenangi ketkole. ");
INSERT INTO ons_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Na don ŋidan okanmaile, yewa mo onoka wane detpi koto ŋino mi ketpa okanmaike? Kine yemo iwa yale wane, ŋine naŋane don dere tewekkei wane mi ewek okanmami. ");
INSERT INTO ons_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ŋine magaŋine Satan, eŋane dokoine ea wane ŋine magaŋinane simile yewa dere, eŋane tanik manik yewa mogare arikei wane ŋun okanmaike. Mokaka qei kino eŋe ŋei matali matali geke, eŋe don welekatne yewa ŋadekkake, ea wane eŋane kotino don welekatne yewa mane mi pamaike, eŋe isi don ra okanmaike, yewa yemo eŋane don, eŋe isi ŋei so isi don ea wane magaine. ");
INSERT INTO ons_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na don welekatne ŋidan okanmailane, ŋine naŋane don dere mi malipka okanmami. ");
INSERT INTO ons_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ŋinane keuo ŋine ŋei maneŋo naŋane sot maine marat kayake me? Ŋo na don welekatne ŋidan okanmaileo, yemo onoka wane donne yewa dere mi malipka okanmami? ");
INSERT INTO ons_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mane eŋe Anutu wano ŋine sarikeo, yemo ketine motki paki, Anutu wane don desiake, ŋo ŋine yemo Anutu wano ŋine mi sarikoi, ea wane ŋine ket ŋine motpi paki, Anutu wane donine ea mi detokanmami.” ");
INSERT INTO ons_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yuda ŋei eŋe don mainge Yesu olale rakoi, “Ge Samaria ŋei, Yuda ŋadino qelaŋ gemaine, asu qotkoine yewaŋo geŋane kotoŋono ket gemaike, ea welekatne me?” ");
INSERT INTO ons_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesuŋo mainge edane rake, “Na asu qotkoine yewaŋo kotono mi gemaike. Na Magane ewine kitomaile, ŋo ŋine yemo naŋane ewene mi nitomami. ");
INSERT INTO ons_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na nae eŋet biŋekne ra mawa nagu kalane urataine mi mamaile, eŋet biŋekne ra mawa naniakane ŋei gemaike, Ŋei Weku, eŋe wano wanok ŋei. ");
INSERT INTO ons_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na ŋidanbe detpi, mane eŋe naŋane don dere teweke mageake, eŋe mane mi seukeake, midakaka!” ");
INSERT INTO ons_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yale raki mo, Yuda ŋei eŋe olale rakoi, “Ŋene ukude mo detlukmaine, ge asu qotkoineŋo kotoŋono gemaike! Abraham mo seukke, so propet eŋe yale waka mo seukkoi, ŋo ge iwa yale ramaine, ‘Mane eŋe naŋane don dere teweke mageake, eŋe mane mi seukeake.’ ");
INSERT INTO ons_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ŋenane magaze Abraham seukke, goŋo Abraham wane rokop yuan kakenane ramaine me? So propet eŋe yale waka seukkoi, ge daleo okangenane ramaine me?” ");
INSERT INTO ons_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Rauso, Yesuŋo mainge edane rake, “Na noŋomka eŋet biŋekne ra mawa naguwe, naŋane mawa mawaneŋo wele midaine okaniake, Weku mawa nan okanmaike, eŋe yemo naŋane Magane, eŋe wekuku, ŋine eŋane Anutu ra okanmami. ");
INSERT INTO ons_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ŋine eŋe mi detkakoi, ŋo na yemo eŋe mo detka okanmaile. Ŋo na eŋe mi detkamaile, yale rawe rap, yemo na isi ŋei yale ŋinane kimaŋine okanbe rap. Ŋo na welekatne eŋe detluk kamaile paki, eŋane don dere aŋaine tewek okanmaile. ");
INSERT INTO ons_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ŋinane ŋaboŋine Abraham eŋe naŋane nasone bomileki kayakane batne okange, wane nasone bomileki yewa kake, so wet pesek suaine detke.” ");
INSERT INTO ons_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yale raki Yuda ŋei eŋe rakoi. “Ge komaŋone 50 mi okange, ŋo ge Abraham mo kakone me?” ");
INSERT INTO ons_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesuŋo mainge rake. “Na rawe detpi, mokaka Abraham eŋe mi wakone geke, naso yewao na ge sari gekole.” ");
INSERT INTO ons_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yale raki, so eŋe wesi ma more qekei wane okanbiso, siuke more Bakom Urumgo ŋine saket arike. ");
INSERT INTO ons_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu eŋe numa ariki paki ŋei mane nagainane kotino ŋine depilik wakonge, eŋe maratkake. ");
INSERT INTO ons_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Eŋine dokoine edo qesonka rakoi, “Kito ŋebo ŋebon, maŋane sotŋo maki, ŋei iwa eŋe de pilik wakonge? Eŋine sotŋo me naga magaine erane sotŋo maki de pilik wakonge?” ");
INSERT INTO ons_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesuŋo mainge edane rake. “Eŋe deine pilikke, yewa eŋine sot wane me naga magaine erane sot wane mida. Eŋe de pilik wakonge, yemo Anutu wane zonom togogole, ea wane kine de pilik yewa wane solao wakongi kaikei wane yale wakonge. ");
INSERT INTO ons_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ŋene na ukude mo kepe qaemaike, ea wane ŋene Waom wan urata maikene, na oŋom tale nangimo, na sarikole, ruo kereakane okanmaike, ŋeiŋo ruo urata maine mi maikei. ");
INSERT INTO ons_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na kepo gemaile, naso yewaoka noŋom kepe baŋem eŋane kiwa okane qelaŋan onikale.” ");
INSERT INTO ons_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu eŋe don iwa raki paki ea wane ŋadino mekatine kepo sopotkeke paki, mekatine yewa keperop manigingi, nalek okangiso, nalek yewa mawa de pilik ŋei mane wane deino qedeŋge. ");
INSERT INTO ons_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Pakiso, olale rake, “Ari kaitŋone Siloam Namugo saukenom.” Doku namuŋ wane eŋet ea wane kine Ono dongo, “Talekake.” Raki so, ŋei yewa eŋe ari dokuwo kaitine saukke, paki zinge sariki, deine toeki potki lotkeki, kine kine korop kawareke. ");
INSERT INTO ons_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Eŋine kimakoune so ŋei natne mo alakan kau mere, ŋei ŋerep wesi aboŋ kine kine mangei wane meŋen one geke, eŋe rakoi, “Ŋeiwa mere wesi wane ŋei ŋerep meŋen one geke, iwa me? Eŋe daleo?” ");
INSERT INTO ons_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Natne eŋe rakoi, “Eŋe weku ea,” ŋo natne eŋe rakoi, “Mida eŋe midakaka, iwa mo eŋe qou qouka, ŋei mane kamaine, eŋe eŋine mida!” Yale rauso ŋei yewa eŋe oŋom edane rake, “Na welekakatne, nae iwa.” ");
INSERT INTO ons_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eŋe qesonka rakoi, “Deŋone daleo okane lotkike?” ");
INSERT INTO ons_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Rau so eŋe edane rake, “Ŋei eŋetne Yesu oŋo nalek liwage more mawa deno qedengi paki, nolale reke, ‘Ari Siloam doku lomgo kaitŋone saukenom.’ Raki so na arile, ari kaitne saukewe, yewaka dene iwa toeki potlotke porile.” ");
INSERT INTO ons_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Eŋe qesonka rakoi, “Ŋei yewa eŋe diao gemaike?” Eŋe edane rake, “Na mi detmaile.” ");
INSERT INTO ons_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pakiso, eŋe ŋeiwa de pilik pilikine geke, eŋe ma Parisi eŋano arikoi. ");
INSERT INTO ons_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesu eŋe nalek liwage more, de pilik wane deine qedeŋgi lotkeke, kaiwe ea yemo zonom ma taboŋ met met naso yewao. ");
INSERT INTO ons_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Parisi eŋe koso daleo okangi paki deine lotkeke, ea wane manerop qesonkakoi, qesonkau edane rake, “Eŋe nalekŋo deno qedeŋgi, na namugo ari kaitne saukile, ea wane na dene iwa maine pore kamaile.” ");
INSERT INTO ons_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisi natne eŋe rakoi, “Ŋei yewa urata iwa meke, eŋe Anutu wano ŋine mi sarike, yalinane eŋe zonom ma taboŋ met met, ea wane ra rokop don yewa mi mogatmaike.” Ŋo natne eŋe rakoi, “Ŋei mane eŋe borikine mamaŋo kait masi togogole iwa yaline Anutu midaine daleo makirap? ea midaka!” Pakiso eŋe edomka poripke magu etke okangoi. ");
INSERT INTO ons_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Eso Parisi eŋe ŋeiwae deine pilik pilipine geke, eŋe koso manerop qesonka rakoi, “Ŋeiwa yewa geŋane deŋone maki menagi, ge eamo eŋane daleo wetkemaine?” Pakimo eŋe doneene turuŋine mainge edane rake, “Eŋe propet mane.” ");
INSERT INTO ons_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ea welekatne Yuda ŋei ŋetne eŋe ŋei yewa eŋe welekatne de pilik wakone gekeŋo, koso deine maine potki lotkeke, ea eŋe kau paki, ea wane eŋe detpi wele mi okangi malipkakoi. Paki eŋe ŋei yewa de pilik wane naga magaine etorau sarikoik. ");
INSERT INTO ons_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Pakiso qeson ore rakoi, “Iwa ŋirane medep me? Ŋire ramamik, eŋe de pilik wakonge, ea mayakatne. Ŋo eŋe daleo okangi paki mo, koso iwa deine maine potmaike?” ");
INSERT INTO ons_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Eŋane naga magaine ere rakoik, “Ŋere detmaite, eŋe ŋerane giponse, so ŋere detmaite, eŋe de pilik wakonge, ");
INSERT INTO ons_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ŋo daleo okangi paki, deine maine pore kamaike, ea yemo ŋere mi detmaite, me maŋo deine ma lotkike, yewa ŋere yale waka mi detmaite. Eŋine qesonkau, eŋe mo medep suaine, so eŋe oŋom kineine maine ŋidaniake!” ");
INSERT INTO ons_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Naga magaine ere Yuda ŋei ŋetne eŋane kaet otki, don yewa rakoik, onoka wane, Yuda ŋei eŋe doneene iwa yale rau paki, mo ra togolekoi, “Ŋei mane eŋe Yesu wane eŋe Mesia Anutuŋo kepe ŋei turuŋze qekokeakane ra birakake rayakeo, eŋe Yuda miti lewa lewaŋ urumgo ŋine esopkaŋem sen ŋadino kesiake.” ");
INSERT INTO ons_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kine yalinane naga magaine ere rakoik, “Eŋe mo medep suaine okangane, eŋe eŋine qesonkau!” ");
INSERT INTO ons_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Eŋe koso atak mane qesonkau atakine etke(2) okange, eŋe ŋei ea de pilik wakonge eŋe orau, sariki olale rakoi, “Ge ra togolenom, Anutu wane kaitko, so ge don welekatne raikene! Ŋene detmaine, ŋei iwa eŋe borikine mama.” ");
INSERT INTO ons_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ŋeiwa eaŋo mainge edange, “Na mi detmaile, eŋe borikine mama, me mida. Na weku detmaile, yemo na dene pilik pilikine gekole, ŋo ukude mo dene pore kamaile.” ");
INSERT INTO ons_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Eŋe qesonka rakoi, “Eŋe daleo okanganike? Eŋe daleo okane more deŋone malotkike?” ");
INSERT INTO ons_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Eŋe mainge edane rake, “Na mo ŋidanile, ŋo ŋine don ea desikei wane bauŋine wamaike. Pakimo ŋine koso onoka wane don manerop loutne desikei wane ramami? Ŋine yale waka eŋane dokoine okangei me?” ");
INSERT INTO ons_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Parisi eŋe sorinka rakoi, “Ge geŋoneka ŋei yewa wane medepine mane, ŋo ŋene yemo Mose wane dokoine. ");
INSERT INTO ons_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anutuŋo Mose don olatke, ea mo ŋene detmaine, ŋo ŋei yewa ea mo ŋene mi detkamaine, eŋe diao ŋine sarike!” ");
INSERT INTO ons_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ŋeiwa de pilikŋo deine menaŋge, eaŋo doneene turuŋine mainge edane rake, “Iwa mo ŋine don kine mane ramami! Ŋei eaŋo naŋane dene malotkeke, ŋo ŋine ramami, ŋene mi det kamaine, eŋe diao ŋine wakonge. ");
INSERT INTO ons_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ŋene iwa yale detmaine, Anutu eŋe ŋei borikine mama eŋane doneene mi det okanmaike, ŋo ŋei maine eŋe eŋane ewine kitoki paki, eŋane aŋaine teweke more, eŋe modat kayakeo, eŋe Anutuŋo donine maine desiake. ");
INSERT INTO ons_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mokaka qei kino kepe wakonge naso yewao ŋineka pa sake gemage ukude naso iwao eŋe yale waka, ŋei mane nagaine kotino ŋine de pilik wakone geki, ŋei maneŋo deine malotkeke, ea wane don kisi mane mi paki, det okanmaine. ");
INSERT INTO ons_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ea wane, ŋei yewa eŋe Anutuŋo mi birakake me Anutu wano ŋine mi ketke ra, eŋe urata yaline mane mi makirap.” ");
INSERT INTO ons_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Eŋe Parisi eŋe don ea dere more mainge olale rakoi, “Ea daleo? Ge nagaŋoneŋo borikinerop geukane, ge borikine mama gekone, ge sari ukude weneŋ yale waka gemaine, paki mo ge ŋene kito ŋedangenane okanmaine me? Midakaka!” Yale rau paki, Yuda wane miti lewa lewaŋ urumgo ŋine ma birakau qeinat ketke. ");
INSERT INTO ons_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ma birakau qeinat ketki, Yesu eŋe detke, paki ari maratka more olale rake, “Ge Ŋei Wawainane Gipole detka more, malip kamaine me mida?” ");
INSERT INTO ons_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Raki ŋeiŋo mainge rake, “Suaine, Ŋei Wawainane Gipole yewa ma? Nolatnom detpe paki, na eŋe maine malip kaikale!” ");
INSERT INTO ons_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesuŋo olale rake, “Ge eŋe mo kamaine, ge eŋerop don iwa aumamik.” ");
INSERT INTO ons_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ŋeiŋo yewaŋo rake, “Waom, na malip ganmaile!” Yale raki pakiso, Yesu wane kiino wawetine kepo qe umi ketke. ");
INSERT INTO ons_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Pakiso Yesuŋo rake, “Na ŋei kineene ma wakonikalane kepo ketkole, ea wane, de pilikŋo deene potpi maine lotkeake, ŋo deene maine pore gemamiŋo, weteenane deine pili pilikine okangei.” ");
INSERT INTO ons_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisi natne eŋe weneŋ Yesu osino okorau paki detpi, Yesu eŋe don yewa rake, paki eŋe qesonka rakoi, “Ge ŋenane weneŋ de pilik ramaine me?” ");
INSERT INTO ons_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesuŋo edane rake, “Ŋine sot wane de pilik gege ra, yemo borikine midaine geu rap, ŋo ŋidom ramami, ‘Ŋene deze weneŋ maine potmaine,’ yewa wane kine yemo ŋine sot korop gemami.” ");
INSERT INTO ons_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuŋo koso takotke more rake, “Na welekakatne ŋidanbe detpi, ŋei mane eŋe lama eŋane sen koto madetkoka mi wakesiake, eŋe yaup tewinoka sen yuane wakesiake, eŋe kobu ŋei so ŋei mane wane aboŋ kine kine kobu teba waraŋ ŋei. ");
INSERT INTO ons_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ŋo ŋei mane eŋe madetkoka wakesiake, eŋe yemo lama eŋane ware ware. ");
INSERT INTO ons_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Madet wane ware ware eŋe oŋom ŋei yewa wane madet ea lalageake paki, eŋine lamakoune eŋe eŋine donine ea maine desikei paki, eŋe eŋeteene ea maine weku weku edora iwenongi, inat sakesikei. ");
INSERT INTO ons_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Eŋe lamakoune koropka inat ebu saket ware more, oŋom ŋetne kisage alakangi, lamakoune eŋe welaenane don mo det okanmami, wane ŋadino mogare arikei. ");
INSERT INTO ons_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Eŋe ŋei mane wane ŋadino mi arikei, midakaka, eŋe ŋei mameŋo edorayakeo, yemo lama eŋe ŋei yewa kakakka ari warekei, onoka wane, eŋe ŋei natne eŋane doneene mi det okanmami, ea wane, eŋe donine kuneŋine dere more, kaetongi rakake arikei.” ");
INSERT INTO ons_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu eŋe don naŋengo kito edange, ŋo eŋe kine onoka wane don yalewa ra ŋedanmaike, ea wane kine mane dere kaŋem, eŋe yalewa ra mi dere qelaŋangoi. ");
INSERT INTO ons_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Paki, Yesu eŋe koso manerop edane rake, “Na ŋidanbe detpi, welekakatne na noŋom lama eŋane madet, ");
INSERT INTO ons_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ŋei korop naŋane numa alakane sarikoi, ŋei yewa eŋe korop kobu mama so kobu teba teba, paki ea wane lama eŋe doneene mi detkoi. ");
INSERT INTO ons_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na madet, ea wane ŋei mane eŋe naŋanoka sariki paki, sen koto wakesiake, eŋe baŋ Anutuŋo mayake, paki eŋe baŋ ululuŋ sari sakesiake, so waket ariake, yale okane, Asu wane ŋara morian maine marat kayake. ");
INSERT INTO ons_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kobu mama ŋei eŋe yemo kine kine mane bile mayakane mi sarimaike, eŋe yemo lama kobu ebu more enguyakane, so matali qetali ebuyakaneka sarimaike. Na yemo lama eŋe gegeene wakongi, gege togon so Asu Koboboine eŋano wat watko paki geulukkei, ea wane na sarikole. ");
INSERT INTO ons_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Na noŋom yemo lama eŋane ware ware maine, lama ware ware maine eŋe lama eŋane raki paki, gegeine maine qaisikka more seukeake. ");
INSERT INTO ons_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ŋo ŋei eŋe lewine qolekaikei wane raki paki, eŋe lama maine mi ware oniake, so oŋo lama eŋane magak maine zok mida, yewa wane eŋe kaki, kasi zubaine mane sariakeo, eŋe kakakka more, lama qeliŋongi paki, kaet ariake paki, kasi zubaine eŋe lotke more, lama ea korop edore more esopongi, yau yaup ket giŋ qiririŋ ari warekei. ");
INSERT INTO ons_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ŋeiwa yewa eŋe yale okaniake, eŋe yemo onoka wane mida, eŋe yemo lewine mayakaneka urata ma ge okanmaike, ea wane eŋe kaet arimaike paki, eŋe lama wareoniakane mi desiake. ");
INSERT INTO ons_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Na lama eŋane ware ware maine, na lama magukopne na eŋe detluk onmaile, ŋo lama magukopne eŋe yalewaka na maine detluk nanmami. ");
INSERT INTO ons_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Rokop yale waka Magak eŋe na detluk nanmaike, ŋo na Magak so lama eŋane ra more gegene qik kaikale, so lamakopne qesiŋonikale. ");
INSERT INTO ons_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na lamakopne natne gemami, eŋe Yuda wane sen iwa wane kotino mi gemami, na eŋe weneŋ yale waka ebu sarikale, paki eŋe naŋane donne desikei paki, eŋe lama magu weku okanbi, ware wareene eamo weku noŋomka baŋ wareonikale. ");
INSERT INTO ons_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Magak eŋe naŋane okankamaike, onoka wane yemo na gegene kepe ŋei eŋane ra more, qaisikkawe paki, seu seu makale paki, na koso wie gege manerop makale, ea wane. ");
INSERT INTO ons_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ŋei maneŋo naŋane gege maine mi maki mida leleake, midakaka, na nae similenane noŋomka gegene qaisikka ebonikale. Na gegene qaisik kakalane zonom pa ninmaike, so na gegene koso manerop makalane zonom weneŋ pa ninmaike. Magakŋo na yale wa okangalane raki paki nolatke.” ");
INSERT INTO ons_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu eŋe don iwa rakane, Yuda ŋei eŋe koso manerop wiri magu etke okangoi, ");
INSERT INTO ons_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","paki eŋe ŋei loutneŋo iwa yale rakoi, “Eŋe asu qotkoine magemaike! Eŋe qelaŋ! Ŋine onoka wane done raki ket more detmami!” ");
INSERT INTO ons_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ŋo natne eŋe rakoi, “Ŋei mane eŋe asu qotkoineropŋo don iwa yale maine mi rayake! Asu qotkoineropŋo ŋei deene pilik pilikine eŋane deene daleo ma lotkekei? Ea midakaka!” ");
INSERT INTO ons_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Iwamo Yerusalem matko Bakom Urum mosop kakoi, ea wane zonom ma mesikei wane naso mo bomileke, eŋe sogino miti urum Anutu wane biŋek qe eŋane eŋetko rakokkoi, ea wane wetke metmaŋkoi, ea wane nasoine bomileke, naso yewa mo momo nasoo. ");
INSERT INTO ons_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu eŋe Bakom Urum koto waket Solomon wane Tougo arike. ");
INSERT INTO ons_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ariki Yuda ŋei eŋe sari lolikkau paki olale rakoi, “Ge naso dango ŋene ra qelaŋane ŋedangene, ge welekakatne ma? Ge Mesia me? Anutuŋo ŋei ŋerep ebukenane biragange, yemo ge ŋene ra qelaŋane ŋedannom.” ");
INSERT INTO ons_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesuŋo mainge edane rake, “Na mo ŋidan okanmaile, ŋo ŋine siluŋ naŋane don yewa dere mi malipka okanmami, na urata kine kine ma okanmaile, yewa yemo Magak wane don teweke ma okanmaile, yewaŋo naŋane kine ra wakon okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ŋo ŋine yemo naŋane lama magu midakaka, ea wane ŋine na wetŋineŋo mi malip nanmami. ");
INSERT INTO ons_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Naŋane lama eŋe naŋane donne detokanmami, na eŋe detonmaile, eŋe na mogatnane ŋadeno sari okanmami. ");
INSERT INTO ons_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na gege togon ebon okanmailane, eŋe mi seukei, eŋe gege togon ge arikei, geu ŋei maneŋo naŋane meteno ŋine mi neuma ebu ariake. ");
INSERT INTO ons_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Maganeŋo ŋei magu more ninge, ea yemo manerop kakapa suaine kine kine natne korop yuanka waremaike, wane ŋei maneŋo Maganane metino ŋine maine mi oma nane ebu ariake. ");
INSERT INTO ons_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Magane so na ŋere mo kinese weku, ŋere koso wiri etke mi okanmaite.” ");
INSERT INTO ons_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yale raki, so Yuda ŋei eŋe koso manerop wesi peikeu paki qeu seukeakane okangoi, ");
INSERT INTO ons_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","okanbi, Yesuŋo edane rake, “Na Maganane urata maine loutne sikan ŋunbi kemi, paki mo ŋine urata mane diawa wane rau paki, mo na wesiŋo nekukei wane okanmami?” ");
INSERT INTO ons_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yuda ŋei eŋe mainge olale rakoi, “Ge urata maine mamaine, ea wane ŋene ra more wesiŋo gekukenane mi okanmaine, midakaka, ŋo yemo ge goŋom Anutu wane numa ma okora ewe mabaik okan kamaine, kine ea wane raŋem paki, wesiŋo gekukenane okanmaine, ge ŋei yauwine, ŋo ge siluŋ geŋonane iwa yale ramaine, ‘Na Anutu!’” ");
INSERT INTO ons_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesuŋo mainge edange, “Ŋinŋine ra rokop don bonepŋino don mane qekoi, yewao Anutuŋo iwa yale rake, ‘Na iwa yale ramaile ŋine Anutu’ ");
INSERT INTO ons_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Eŋet eamo sogine Anutuŋo ŋei eŋano ra wakonge, eŋe rake, ‘Ŋine Anutu,’ paki mo Anutu wane papiao don ea mo mane mi koso qein geke paki tanik mane okanmaike ");
INSERT INTO ons_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ŋo na yemo Maganeŋo ma wakon nange paki talenangi iwa kepo ketkole, ea wane na Anutu wane Gipole yale ramaile, paki mo, ŋine numa dalino kau, na Anutu ewe mabaik okankamaile? ");
INSERT INTO ons_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ŋo na Maganane urata mi makaleo, yemo ŋine naŋane donne dere misuk malip kaikei. ");
INSERT INTO ons_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ŋo na urataine mawe, ŋine naŋane donne dere mi malip kaikeiwo, yemo ŋine urata mamaile yewa kaso, malip kaikei, yale okanbi paki, naso baŋem iwa yale detlukkei, Magakŋo narop gemaike, so noŋo Magak korop gemaile.” ");
INSERT INTO ons_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yale raki, eŋe koso manerop ma lukkaikei wane okangoi, ŋo eŋe keueno ŋine siukke sau saungo saket arike. ");
INSERT INTO ons_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu eŋe koso zinge ari, Yordan doku yuane erinat wa ari mage, Yohaneŋo ŋei ŋerep doku tauone geke, yewa lotkeso ea geke. ");
INSERT INTO ons_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Gekiso, ŋei ŋerep loutneŋo eŋano sarikoi, sari olale rakoi, “Yohane eŋe masi togogole mane mi make, ŋo eŋe ŋei iwa wane don kine kine korop rake, yemo wele mo welekatne wakon waremaike.” ");
INSERT INTO ons_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Eso yewao ŋei ŋerep loutneŋo Yesu wane done dere malip kakoi. ");
INSERT INTO ons_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ŋei mane eŋetne Lazarus, Betani matko geke, eŋe zomakake, Betani ea mat suaine Maria so tatine Marta ere yewa gekoik. ");
INSERT INTO ons_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria ŋerep yewa oŋo kelok qoune teine yewa Waom wane kieretkino qakki, taukaki so, lewine zouneŋo ratokke, ŋerep yewa wane ŋole Lazarus eŋe zoma kake, eŋe mateene Betani yewao gekoi. ");
INSERT INTO ons_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tati qa ere Yesu wano don iwa yale ra motpik arike, “Waom, geŋane kima maepŋone eŋane naso baŋem simingan mageake, mo zoma kamaike.” ");
INSERT INTO ons_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu eŋe don yewa dere more rake, “Lazarus wane zoma ea wane wele yemo seu seu midakaka, zoma yewa wakonmaike, yemo waraŋkaki, ŋei ŋerep eŋe Anutu wane zonom kau paki, bakomine kitokei, paki numa yewaoka Anutu wane Gipole eŋe qeli ewe zonomine mayake. ");
INSERT INTO ons_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu eŋe Marta so qaine so Lazarus eŋane zok simile kaki wetineŋo malipon lukke. ");
INSERT INTO ons_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesu eŋe Lazarus zoma kake, ea wane donkisi ariki detki paki, mat geke yewaka koso takotke kaiwe etke metke. ");
INSERT INTO ons_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mere so, dokoine edane rake, “Ŋene koso Yuda kepeo zinge ariŋem.” ");
INSERT INTO ons_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Raki dokoine eŋe olale rakoi, “Kito ŋebo ŋebon, nasomde bamgo yewaoka Yuda ŋei eŋe wesiŋo gekukei wane okanimi, pakimo, ge koso yewaka zinge arikenane wetkemaine me?” ");
INSERT INTO ons_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesuŋo doneene mainge more edane rake, “Kaiwe mama wane aua 12 pamaike, pakimo yewao qelaŋan mi okaniake me? Eso ŋei mane eŋe kepe qelaŋane paki numa ariake, eŋe kineŋo daŋaŋ qeki paki, mi ket qeake, onoka wane, eŋe kepe kine kine korop deinane qelaŋano maineeka ka more arimaike. ");
INSERT INTO ons_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ŋo eŋe ruoo numa ariake, eŋe daŋaŋ qeki paki, ket qeake, onoka wane eŋano qelaŋan mane mi pamaike, ea wane qeake.” ");
INSERT INTO ons_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu eŋe don iwa raki paki, koso mane takotke rake, “Ŋenane kimaze Lazarus eŋe yaup kulu peke, wane na mo ea ari more ma wirikkawe wisikae wieyake.” ");
INSERT INTO ons_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Dokoine eŋe don ea dere more iwa yale olale rakoi, “Waom, eŋe kulu pamaikeo, eŋe baŋ menaŋ kayake.” ");
INSERT INTO ons_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ŋo iwa yale mi detkoi, Yesu eŋe Lazarus mo seukke, ea wane don yewa ramaike, pakimo, eŋe mi dere qelaŋane more yaup wetke rakoi, Lazarus eŋe yaup kulu paki, mo welekatnane mane ramaike. ");
INSERT INTO ons_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Eso Yesu eŋe didiwo ra qelaŋane more edane rake, “Lazarus eŋe mo seukike, ");
INSERT INTO ons_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ŋo na ŋinane rawe paki, wetne pesemaike, yemo na eŋerop yewa weneŋ mi gile, ea wane ŋine baŋ mali malip korop okanikei, ŋene eŋano ariŋem.” ");
INSERT INTO ons_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, eŋetine wase wase Atiksipo, oŋo kimakoune natne edane rake, “Ŋene korop weneŋ kito ŋebo ŋebon gorop ariŋem paki, eŋinerop maine weneŋ seukkene!” ");
INSERT INTO ons_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu eŋe ari lotkeki paki detke, Lazarus eŋe mo dukkau deŋesereo paki, kaiwe mama etke so etke (4) okange. ");
INSERT INTO ons_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ea mo Yerusalem mat osino metke, 3 kilomitaka ea wane rokop. ");
INSERT INTO ons_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yuda ŋei ŋerep loutneŋo Marta so Maria ŋon etne seukkane nasoine mere more, qom etne romatkekei wane arikoi. ");
INSERT INTO ons_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta eŋe detki Yesu sariki, eŋe marat kayakane numao arike, ŋo Maria eŋe yemo matko metke. ");
INSERT INTO ons_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martaŋo Yesu olale rake, “Waom, ge iwa merine ra, yemo naŋane ŋonne eŋe maine mi seukkirap! ");
INSERT INTO ons_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ŋo siluŋ na detmaile, ge ukude iwa Anutu kine kine ea me ea wane meŋen kaikene, eŋe donŋone maine dere more giniake.” ");
INSERT INTO ons_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Rakiso Yesuŋo olatke, “Geŋane ŋonŋone eŋe baŋ maine wisikae wieyake.” ");
INSERT INTO ons_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martaŋo olale rake, “Na detmaile, eŋe baŋ qeli so kepe naso etne qoeyake, yewao wisikae wieyake.” ");
INSERT INTO ons_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yale raki, Yesuŋo olale rake, “Na wisikae wie wie so gege ea wane welaine, ŋei mane eŋe na malipnane geake, eŋe seukeakeŋo siluŋ koso wisikae wie geake. ");
INSERT INTO ons_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ŋo mane eŋe wisika geki paki, na malip nane gemaike, eŋe baŋ mali malipine mi seukluke more, eŋe qeli gege togon maratkayake, ge don iwa maine detluke malip kamaine?” ");
INSERT INTO ons_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martaŋo mainge rake, “O, Waom, na mo wetneŋo malip ganmaile, ge Mesia, Anutu wane Gipole, Anutuŋo ketkenane rakane kepo ketkone.” ");
INSERT INTO ons_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta eŋe don yalewa raki paki, koso zinge ari, qaine Maria eŋineka oraki sarike paki, eŋe iwenka kere eretneka olale rake, “Kito ŋebo ŋebon mo sarike iwa, so eŋe geŋane ramaike!” ");
INSERT INTO ons_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria eŋe don ea dere kaŋzaŋ wieki paki, biririke Yesu wane marat kayakane arike. ");
INSERT INTO ons_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu eŋe matko mi sari lotkeke, eŋe mikep metki Marta ari maratkake, yewaoka yewa metke. ");
INSERT INTO ons_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yuda ŋei Mariarop weneŋ matko wetne kito pese metkoi, eŋe kau kaŋzaŋ wie biririke qeinat ket arikiso, eŋe ŋadino mogare arikoi, eŋe wetke rakoi, “Maria eŋe deŋesereo mane arokeakane arimaike.” ");
INSERT INTO ons_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria eŋe ari mat wazaino Yesu metke, yewa lotke more Yesu maratkake, pakimo kino umi qe ketki paki olale rake, “Waom, ge iwa ginera, yemo naŋane ŋonne eŋe mi seukkirap!” ");
INSERT INTO ons_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yale raki paki arokki, Yesu eŋe kake, so Yuda ŋei eŋerop sarikoi, eŋe weneŋ yale waka arokkoi, paki eŋane qomino maki qom borik zok make, so manerop qiseke. ");
INSERT INTO ons_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Paki qeson one rake, “Ŋine diawao dukkemi?” Eŋe olale rakoi, “Waom.sari kanom!” ");
INSERT INTO ons_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu eŋe kaki paki arokke. ");
INSERT INTO ons_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yale okangi, Yuda ŋei eŋe kau paki rakoi, “Kau, eŋe ŋeiwae wane simileine zok manerop pake!” ");
INSERT INTO ons_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ŋo natne edo rakoi, “Oŋo ŋei loutne de pilik deene malotkeke, eŋe onoka wane weneŋ maine mere Lazarus warekaki, mi seukkirap me?” ");
INSERT INTO ons_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu eŋe wetne koso manerop tabaeki, qom borik okangi paki, deŋesereo arike. Deŋesere yewa yemo weti bonagao wesi aŋaino, kemgo maulukkoi, aŋaine yewa mo wesiŋo kito wongeu metke. ");
INSERT INTO ons_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ea wane Yesuŋo rake, “Wesi yewa mau arikep!” Marta, seu seunane kiarine, oŋo olale rake, “Waom yewa baŋ qoune borikine ŋenguyake, eŋe seukki dukkaŋem, kaiwe etke so etke okanmaike!” ");
INSERT INTO ons_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yale rakiso Yesuŋo olatke, “Ge malip nannom paki, Anutu zonominane kibi maine suaine wakongi kaikenane, done na mi golalile me?” ");
INSERT INTO ons_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Eŋe wesi mau masikange, pakiso Yesuŋo deine potki qeliwo waki rake, “Magak, ge meŋe meŋenne mo derine, ea wane na eweŋone kitomaile. ");
INSERT INTO ons_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na detmaile, ge naso baŋem ketŋone more, naŋane meŋe meŋenne det okan maine, ŋo na don iwa ramaile, yemo yaup mida, ŋei ŋerep iwa okoramami, edo goŋo talenannom ketkole, naŋane yale detluke malipkaikei wane, eŋane rawe paki ramaile.” ");
INSERT INTO ons_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Don iwa raki qoeki, ea wane ŋadino Yesuŋo suaineka togogole bokaki paki rake, “Lazarus, ge wie sari saketnom!” ");
INSERT INTO ons_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yale rakiso, ŋei seu seuneŋo aŋaine teweke wie sari saketke, meteretkine so kieretkine ea mo deŋesere wane lap lapŋo kawe kawetne, so lap lap mane de kaitine kawe kawetne, pakiso Yesuŋo edane rake, “Lap lap yewa lalageu paki, birau kau, eŋe oŋom arikep.” ");
INSERT INTO ons_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yuda ŋei loutne eŋano ŋineŋo Maria kakei wane weneŋ sarikoi, eŋe Yesuŋo masi kine kine make, yewa kakoi paki eŋe malip kakoi. ");
INSERT INTO ons_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ŋo natne edo yemo zinge Parisi eŋano ariu paki, Yesuŋo masi kine kine make, yewa edangoi. ");
INSERT INTO ons_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Eso Parisi so Yuda ŋei suaine eŋe kepe ware ware ŋetne natne eŋerop qeturage lewageu paki, eŋe edane rakoi, “Ŋene daleo okanikene? Ŋei iwa eŋe masi togogole korop mamaike! ");
INSERT INTO ons_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ŋene qeliŋ kaŋem, eŋe numa tanik iwaka okane ariakeo, ŋei ŋerep loutne manerop eŋe baŋ eŋe malipka warekei, paki eŋe naso eao Roma ŋei qelaŋ edo gavaman okane, ware ongoi, ea wane rakoi, Roma kawali ŋei eŋe sariu paki, Bakom Urumze kitopokeu paki, ŋei ŋerep magu kopze weneŋ korop matali qetali ŋebu ma ket biraŋongei.” ");
INSERT INTO ons_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Eŋane keueno ŋine ŋei mane eŋetine Kaiapas, eŋe koma yewao Bakom Kito Kito wane Pris Ŋetne Suaine geke, oŋo rake, “Ŋine dereretŋine midaine, ŋine kine kine mane mi detluk kamami! ");
INSERT INTO ons_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ŋine kine kine mane iwa yale eamo mayakakatne, ŋine eamo mi detmami, ŋei ŋerep korop matali ŋonbi mida warekenane, turuŋine yemo ŋei weku mau, oŋo maine seukki paki, ŋei ŋerep mapik ŋongirap me?” ");
INSERT INTO ons_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapas iwa eŋine wetino ŋine mi rake midakaka, eŋe koma naso yewao Bakom Kito Kito Pris Suaine geke, ea wane eŋe propet don saeŋine yewa Yesuŋo baŋ seukki paki, Yuda ŋei mapik oniakane rake. ");
INSERT INTO ons_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","So eŋe seukki paki, Yuda ŋei eŋeka bonep mi mapik oniake midakaka, eŋe seukeake, yemo Anutu wane dokoine korop kepe baŋem yeo yeo ket ari ge waremami, eŋe ebu more qe worongi, magu so wet dereret weku okane gekei wane rake. ");
INSERT INTO ons_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kaiwe mama yewaoka Yuda ŋei ŋetne eŋe numa mane maratka more, Yesu qeu seukeakane don kieke rakoi. ");
INSERT INTO ons_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ea wane, Yesu eŋe Yuda kepeo Yuda ŋei eŋane kaitko didiwo ari sari mi okange. Eŋe mat yewa qeliŋgi paki, ari kepe mat mane ŋei midaine kepe yaup papaine ea wane osino metke, mat suaine mane, eŋetine Epraim, yewao dokoine eŋerop weneŋ gekoi. ");
INSERT INTO ons_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yuda ŋei Anutuŋo Loloŋonge, so qeliŋongi weku mane solaene peseki metkoi, ea wane detsoroke metmet ea wane peadaine mesikei wane naso mo bomileke, eso ŋei ŋerep korop mat nigatno ŋine qelige, Yerusalem matko ariwarekoi. Eŋe Mose wane ra rokop don mogare, sot kine kineene sauke masuluk naguwi paki, Anutu wane kaitko koboe more, ŋadino peada mesikei. ");
INSERT INTO ons_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Eŋe bakom urumgo lewage mere, Yesu zuaŋkau paki, auye rakoi, “Ŋine daleo wetkemami? Eŋe peadao sariake me mida?” ");
INSERT INTO ons_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bakom Kito Kito Pris Suaine so Parisi, eŋe donene mo ra togolekoi, ŋei maneŋo Yesu wane met met wie wieine desiakeo, yemo ikop ari ra wakone edangiso, eŋe maine ma lukkaikei. ");
INSERT INTO ons_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Peada bano kaiwe 6 paki, Yesuŋo Betani matko Lazarus geke, yewa arike, ŋei yewa mo alakan Yesuŋo seu seuoŋine ma wirikkaki, wisikae wieke. ");
INSERT INTO ons_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Eŋe yewa Yesu wane ŋara maulukkoi, Marta eŋe qesiŋone ŋara suluke zakeo motke, Lazarus eŋe Yesurop zakeo metke. ");
INSERT INTO ons_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pakiso, eŋe Yesu wet peseke oi bakom okankaikei wane ŋara surok mau zeke, naso yewao Maria eŋe doku beloŋ mane, lewine suaine, sanda libekaŋo mamaine, yewa ma qakki, Yesu wane kieretkine tau kaki paki, eŋine lewine zouneŋo ratokke, doku maine qoune simimile teine, ea wane qouneŋo mat yewa wane kotino korop pise watke rokopke pake. Paki Martaŋo ŋara motki, Yesu so Lazarus eao ŋei natne eŋe wekuoka weneŋ mere ŋara nekoi. ");
INSERT INTO ons_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yesu dokoine eŋane keueno ŋine ŋei mane Yudas Iskariot, oŋo weku baŋ siron qeki, ŋaba edo Yesu maikei, oŋo rake, ");
INSERT INTO ons_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ŋene onoka wane mi doku qounerop iwa motŋem, ari wesi 300 kina kiatki sariki, wesi yewaŋo ŋei aboŋene midaine madu wanap, ea maine ebonŋem rap me?” ");
INSERT INTO ons_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Eŋe don iwa rake, yemo eŋe madu wanap qesiŋ oniakane midakaka, eŋe kobu mama geki paki, wesi kite mageke, wane yewa ŋine maki paki, eŋine qesiŋnagu okaniakane wetke more rake. ");
INSERT INTO ons_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ŋo Yesuŋo yemo rake, “Ŋine ŋerep yewa qeliŋkau! Eŋe kelok yewa ma geke, yemo naŋane solane taukaki duk nangei wane ra more mageke. ");
INSERT INTO ons_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Madu wanap aboŋene midaine eŋe ŋinerop naso baŋem ge arikei, ŋo na yemo ŋinerop naso baŋem mi gekale.” ");
INSERT INTO ons_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ŋei ŋerep magu suaine eŋe detpi, Yesu eŋe Betani matko metke, eso eŋe yewa arikoi. Eŋe arikoi, yemo weku Yesu kaikei waneka mi weke arikoi, eŋe Lazarus seu seuo ŋine ma wirikkaki wieke, eŋe weneŋ yalewaka kaikei wane arikoi. ");
INSERT INTO ons_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Eso Bakom Kito Kito Pris Suaine Ŋei eŋe Lazarus weneŋ qeu seukeakane don urata makoi, ");
INSERT INTO ons_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","onoka wane, eŋane rau paki Yuda ŋei loutneŋo suainekopene qeliŋ one, Yesu detlukka malipkakoi, ea wane. ");
INSERT INTO ons_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kepe qaeki kaiwe maneo ŋei ŋerep magu suaine Anutuŋo Loloŋongane Peada mesikei wane sarikoi, eŋe detpi, Yesu mo Yerusalem matko sarimaike. ");
INSERT INTO ons_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Eso, eŋe don yale detpi paki, marat kaikei wane geleqat metine so komu so geru metine korop rutupke, eaŋo eŋet kito rusu birakei wane numao peike arikoi, paki boka rakoi, “Anutu ma wakaŋem! Anutuŋo mosopkakep, eŋe Waom wane eŋetko sarimaike, Anutuŋo Israel eŋane Ŋei Waom mosopkakep!” ");
INSERT INTO ons_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu eŋe dogi mane maratka eŋane kutno metke, Anutu wane Papiaŋo iwa yale ramaike, ea wane rokopko okangoi, ");
INSERT INTO ons_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mi kaet gangep, mat suaine Zion, iwa sarimaike, geŋane Ŋei Waom, dogi medeunane kutnoka umaike.” ");
INSERT INTO ons_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Eŋine dokoine eŋe naso yewao masi yewa wane kine mi detlukkoi, ŋo ŋado Yesu eŋe Magaineŋo qeli ewe zonominane kotino mawa birakake, naso yewao eŋe kine detkoi, yemo Anutu wane papiaŋo don iwa yale rake, eso eŋe ea wane rokopka okankakoi. ");
INSERT INTO ons_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ŋei ŋerep magu ea Yesurop weneŋ ge more ka okorau, Lazarus deŋesereo ŋine ora ma wirikkaki, seu seuo ŋine wieke, eŋe ea wane don kisiine ŋei ŋerep natne kine kine wakonge, ea wane ra wakone edan warekoi. ");
INSERT INTO ons_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yesu eŋe masi togogole maki kisiine detkoi, kine ea wane ŋei ŋerep magu yewa eŋe ari numao maratkakoi. ");
INSERT INTO ons_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ea wane Parisi eŋe edomka auye rau kere pora okange, iwa yale rakoi, “Ŋine kamami, ŋene don urata ma more, korop mabotop onwaremaine! Kau, ŋei ŋerep korop mo eŋane ŋadino ariwaremami!” ");
INSERT INTO ons_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Grik natne eŋe peada nasoo ŋei magu Yerusalem matko Anutu meŋen kaikei wane arikoi, eŋerop keueno weneŋ mere meŋenkakoi. ");
INSERT INTO ons_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Eŋe Pilip wano sarikoi, eŋe Betsaida matko Galili kepeo ŋine, paki qesonka rakoi, “Suaine, ŋene Yesu kaikenane ŋonmaike.” ");
INSERT INTO ons_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Rauso, Pilipŋo ari Andrea olatke, olatkiso eretnarek ari Yesu olatkoik. ");
INSERT INTO ons_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Pakiso, Yesuŋo mainge etane rake, “Ŋei Wawainane Gipolane qeli ewe zonomine suaine mayakane nasoine mo bomilemaike. ");
INSERT INTO ons_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Na ŋidanbe detpi, wit woune kepo mi ketki paki wekuoka witaino mere, eŋe weku yewaŋoka mesiake. Ŋo eŋe kepo kesiake, yemo solaineŋo gotosiake, ŋo kotino woune eamo yemo komine qelotke saki paki sua more, wele loutne qeake. ");
INSERT INTO ons_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mane eŋe eŋine gegeinane siminkaki kima maki siuke maniake, ŋo mane eŋe eŋine gegeine naŋane ra more kepe iwao geki paki ŋabaka more ŋadekayake eŋe baŋ Magakŋo warekaki, gege togon wane biŋek pamaniake. ");
INSERT INTO ons_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mane eŋe naŋane qelit mama geakane okaneso, naŋane ŋadeno sariake, eso naŋane qelit mama eŋe baŋ narop na gekale yewao weneŋ gekete. Mane eŋe naŋane urata mageake eŋe baŋ naŋane Maganeŋo eŋetine manerop mawa kayake.” ");
INSERT INTO ons_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu eŋe koso iwa yale rake, “Qomne qiseki zonomne oremaike, eso na daleo raikale? Na maine iwa yale rakale, ‘Magak, naso iwa misuk wikileŋo detkanom sari kutno wayake’ ? Yale mida. Naso iwao mo na wikile koto waket arikale, na yalinane sarikole. ");
INSERT INTO ons_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Magak, manom eŋet biŋek ŋonane qeli ewe zonom gorop wakone arikep!” Yesuŋo yale rakiso qeliwo ŋine don mane iwa yale raki ketke, “Na mawe eŋet biŋeknane so qeli ewe zonomne mo wakone sua arimaike, wane koso manerop mawe sua ariake.” ");
INSERT INTO ons_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ŋei ŋerep magu yewa okorakoi, eŋe don yewa dere rakoi, “Ea quruŋŋo mane kitomaike!” Ŋo natne eŋe rakoi, “Aŋelo maneŋo don olatmaike!” ");
INSERT INTO ons_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Rauso, Yesuŋo edane rake, “Don iwa noŋo desikalane raki paki mi wakonike, midakaka, yemo ŋido desikei wane, ŋinane raki paki ŋine qesiŋŋune more wakonmaike. ");
INSERT INTO ons_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ukude yemo kepeo ŋei ŋerep kineene Anutuŋo dere wanokeakane naso, ukude yemo kepe iwa wane Ŋei Waom mo mainka ra pelekkaki ketmaike. ");
INSERT INTO ons_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na kepeo ŋine neu wiekei, naso yewao na baŋ ŋei ŋerep korop waraŋonbe naŋano lotke warekei.” ");
INSERT INTO ons_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Eŋe don ea rake, yemo seu seu daleo seukeake, ea wane don naŋengo motki paki rake. ");
INSERT INTO ons_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Raki ŋei ŋerep magu eŋe mainge olale rakoi, “Ŋenane ra rokop donŋo ŋedanmaike, yemo ŋei yewa Anutuŋo birakayake, yemo ŋei ŋerep magukoune ebu naso baŋem naso baŋem wareoneake, so Mesia eŋe mi seuke more, banine ge ariake. Daleo wane ge ramaine, Ŋei Wawainane Gipole eŋe yemo baŋ ma wie birakau kibego seukeake? Ŋei Wawainane Gipole eamo ma?” ");
INSERT INTO ons_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Rauso Yesuŋo edange, “Qelaŋan eŋe nasomde nigatne kiro kirop ŋinane keu ŋino geake, ea wane ŋine takotke numaŋine qelaŋangoka gekei, pakiso panamanŋo misuk sari koraut ŋuniake. Onoka wane, ŋei mane panaman togolane, kotino ari more diawao arikale, ea mo mi detmaike. ");
INSERT INTO ons_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Naso iwao mo qelaŋanŋo ŋinerop gemaike, ea wane ŋine detlukka malipkaikei, qelaŋan pa ŋibonmaike, eaŋo mo ŋine baŋ qelaŋan wane ŋei ŋerep magu so dokoine okanikei.” Yesu eŋe don iwa raki qoeki, ea wane ŋadino yemo qeliŋone ari siuke geke. ");
INSERT INTO ons_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu eŋe masi kine kine togogole ea korop eŋane deene kutno maki deene qomineŋo kamaŋkoi, ŋo siluŋ mi malipkalukkoi. ");
INSERT INTO ons_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yale okanbiso, propet Asiaŋo don qeke ea wele okange, “Waom, biŋek donŋone ŋene edanŋem maŋo donze detluke malipkake? Ea mane midakaka! Waom eŋe oŋom zonomine sikanonge, ŋo maneŋo mi malipkake.” ");
INSERT INTO ons_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kine iwa yale wane eŋe maine mi detluke malipkakoi, onoka wane Asia eŋe yale waka iwa yale qeke, ");
INSERT INTO ons_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Anutu noŋo iwa yale ramaile, na ŋei ŋerep deene ma pilikale, so dereretene leŋongale, eso eŋe deeneŋo kine kine mane misuk kaulukkaikei, so wet derereteneŋo don wane kine maine mi detlukkaikei. Anutu noŋo yalewa ramaile.” ");
INSERT INTO ons_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Asia eŋe don iwa rake, yemo onoka wane eŋe Yesu wane qeli ewine zonom gorop kaki paki, eŋane rake. ");
INSERT INTO ons_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yewaoka Yuda ŋei ŋetne loutneŋo Yesu malipkakoi, ŋo siluŋ Parisi eŋane kaet ongi mali malipene yewa didiwo mi rawakongoi, yemo onoka wane, eŋe detpi paki Yuda lewa lewago ŋine so eŋane tego yewa ŋine esoponbi qeinat sen ŋadino qelaŋ tegoo kesikei wane rau paki kaetongi motkekoi. ");
INSERT INTO ons_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Eŋe Anutuŋo eŋetene edora mawa oniakane yemo zok mi simile ongi sorin gekoi. Ŋo ŋei edo edora mawa ongei wane yemo zok simile detkoi, so wetene suaine pake ");
INSERT INTO ons_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu eŋe suaineka bokaki paki rake, “Mane eŋe na malip naniakeo, eŋe naka weku mi malip naniake, eŋe siluŋ Magak talenangi ketkole, ea eŋe weneŋ yale waka malip kayake. ");
INSERT INTO ons_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mane eŋe na nan okanmaikeŋo Magak talenangi ketkole eŋe yale waka weneŋ ka okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na qelaŋanŋo kepeo ketkole, eamo ŋei ŋerep koropŋo na malip nanikei wane, ŋo mane eŋe na malip naniakeo, eŋe panaman koto mi geake. ");
INSERT INTO ons_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mane eŋe naŋane don detki paki mi tewekeake, mo na eŋe turuŋine mi manikale so eŋano noŋo wano wanok urata mi maikale. Na kepeo ŋei turuŋine ebonikalane mi ketkoleso eŋano wano wanok urata makalane mi ketkole, na ebuwe menaŋgei wane ketkole. ");
INSERT INTO ons_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mane eŋe na ŋadeknangi paki donne mi desiake, eŋe maneŋo turuŋine baŋ maniake. Na don ra okanmaile yewaŋo baŋ gemage naso qoeki turuŋine rakoke maniake so eŋane yewaŋoka baŋ wano wanok urata mayake! ");
INSERT INTO ons_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na don iwa nae wetno ŋine mi ra okanmaile. Midakaka. Yemo Magak talenangi ketkole, oŋom don rawe paki ra wakonikalane so ra qelaŋanikalane matoke ninge. ");
INSERT INTO ons_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","So na detmaile, eŋane pi donŋo gege togon ma wakon okanmaike, na don korop ra okanmaile, yemo Magakŋo ra matoke nolale ninge, rokop ra okanmaile.” ");
INSERT INTO ons_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kaiwe weku mere mo Waomŋo Yuda ŋei Loloŋonge, ea wane Peada mesikei wane naso mo bomileke. Yesu eŋe iwa yale detke. Eŋine nasoine mo bomile maikane eŋe kepe iwa qeliŋgi paki Magak wano koso ariake. Oŋo naso baŋem eŋine ŋei ŋerep magukoune iwa kepeo gekoi, eŋane zok okankake. So eŋe dokoine eŋane okankake, eamo baŋ arimage, eŋine seu seu yewao sikan ongi qoeke. ");
INSERT INTO ons_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu eŋine so dokoine eŋe rarapko ŋara mire ne metkoi. Satanŋo Yudas, Saimon Iskariot, eŋane gipole eŋe Yesu liweka don isisi okanka more ŋaba eŋane meto birakaki maikei wane kotino don mo motke. ");
INSERT INTO ons_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","So Yesu eŋe iwa yale detke, Magakŋo zonom korop mo nae meteno ninge, ea eŋe mo detke. So eŋe koso iwa yale weneŋ detke, eŋe Anutu wano ŋine ketke, so eŋe koso Anutu wano zinge wayake. ");
INSERT INTO ons_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Eso Yesu eŋe zakeo ŋara qelige wieki paki momo takotine solaino suaine yewa kito qokke. Pakiso sola rato ratok kebaŋino piseke. ");
INSERT INTO ons_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pakiso doku qakki simen kude maneo ketkiso kieke dokoine eŋane kieene saukki paki sola rato ratokine kebaŋino pake yewaŋo makoke ratokonge. ");
INSERT INTO ons_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yale okan one Saimon Petoro wano sariki oŋo olale rake, “Waom, ge naŋane kiene yale waka saukkenane okanmaine me?” ");
INSERT INTO ons_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Rakiso Yesuŋo mainge olale rake, “Ge ukude na okanmaile iwa mi detmaine, ŋo siluŋ baŋ ŋado detlukkene.” ");
INSERT INTO ons_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petoro rake, “Ge naŋane kiene mi saukkene, ea mida so midakaka togogole!” Rakiso Yesuŋo mainge olatke, “Na geŋane kieŋone mi saukkale, yemo ge naŋane medep so ge narop maine mi gekene.” ");
INSERT INTO ons_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Olatkiso Saimon Petoro ŋo rake, “Waom, kieneka weku misuk saukkene! Meteretkene so lewene weneŋ saukenom!” ");
INSERT INTO ons_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesuŋo olale rake, “Mane eŋe doku tauyakeŋo yemo koso misuk takotke, tauyake so eŋe kineŋoka tauyake, ŋo solaine ea korop mo qelaŋan wareake, pakimo diine mida leleake. Ŋine koropŋo diŋine midadaine. Korop ŋine maine. Ŋo ŋei wekuŋo yemo maine mida.” ");
INSERT INTO ons_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu eŋe ŋei maŋo isikaki maikei, ea mo detke, yalinane eŋe rake, “Korop ŋine diŋine midaine libeka. Wekuŋo dirop.” ");
INSERT INTO ons_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu eŋe dokoine eŋane kieene saukki qoeki ea wane ŋadino momo takotine solaine ea koso biraki waki zinge ari zakeo metmetino pese ket metke. Metki paki qeson one rake, “Ŋine na musele iwa kine kine okanŋunmaile ea wane kine maine detmami me? ");
INSERT INTO ons_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ŋine kito ŋibo ŋibon so Waom nora okanmami, ea yemo maine. Onoka wane, ŋo na yeŋina gemailane maine nora okanmami. ");
INSERT INTO ons_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na ŋinane Waom so Kito ŋibo ŋibon, eso ea wane na kieŋine saukmaile, ea wane ŋine ŋidomka yale waka kie sau sauk okannagu gekei. ");
INSERT INTO ons_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Noŋo numaine okanbe paki sikan ŋunmaile, ŋine yale waka ea wane rokop okane gekei. ");
INSERT INTO ons_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na ŋidanbe detpi, qelit medep maneŋo Ŋei Waominane rokop yuanka gege ea mo mi pamaike, me qelit urata mayakane biraka birakaine, maneŋo talekake eŋane rokop mi yuan kayake. ");
INSERT INTO ons_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ukude ŋine kine kine na okanmaile, ea wane kine welekatne iwa mo detkamami, ŋine yewa okan nagu gekeiwo yemo ŋine baŋ wet pese maratkaikei! ");
INSERT INTO ons_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Na korop ŋinane mi ramaile, na ŋei diawa mo ma wakon ongole eŋe detonmaile. Ŋo Anutu wane papiao iwa yale ramaike ea wane weleine welekatne wakoniake, ‘Ŋeiwa narop mere ŋara nike, oŋo zinge koso kine ma wie ŋabanane more ebene lagulok naniake.’ ");
INSERT INTO ons_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Na don iwa kine kine ea mi wakongi, na ukude ŋidanmailane ŋado wakoniake. Eso ŋado baŋ welekatne wakoniake, naso yewao ‘Ŋine na ma, ea mo detluknanikei, yemo iwa yale, na noŋomka yalewa gewakale!’ ");
INSERT INTO ons_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na welekatne ŋidanbe detpi, ŋei mane eŋe noŋo talekawe ariki, eŋe ma kima okan kayakeŋo, na yale waka kima okannaniake, so mane eŋe na kima okan naniakeŋo, talenangi ketkole eŋe weneŋ kima okaniake.” ");
INSERT INTO ons_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu eŋe don iwa raki qoeki, ea wane ŋadino asuineŋo zok manerop umareke. Paki suaineka didiwo ra wakone rake, “Na rawe detpi, ŋinane keuo ŋine maneŋo na neu ŋei ŋaba nanmami, eŋano bira naniake.” ");
INSERT INTO ons_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yale raki dokoine eŋe deeneŋo weku weku aekeu kere pora okangi, don iwa maŋane ramaike rau paki ŋaŋae metkoi. ");
INSERT INTO ons_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Dokoine eŋane keuo ŋine medep mane Yesuŋo eŋane simile kamageke, ea mo Yohane eŋe Yesu wane osino metke. ");
INSERT INTO ons_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Eŋe Saimon Petoroŋo eŋe lewetineŋo qesikane kait masi okanka rake, “Qesonkanom, eŋe don iwa ŋei maŋane ramaike.” ");
INSERT INTO ons_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Rakiso Yohane eŋe sorodoge kere Yesu wane osino mere qesonka rake, “Waom ŋei yewa ma?” ");
INSERT INTO ons_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Qesonkakiso Yesuŋo rake, “Na beret suroko qe muruge manbe neake, ŋei yewa wane ramaile.” Yale raso beret sisine mane maso suroko qe muruŋgi paki Yudas, Saimon Iskariot wane gipole mange. ");
INSERT INTO ons_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mangi nekiso, yewaoka Satanŋo Yudas wane wetino ketke. Pakiso Yesuŋo olale rake, “Kine kine okangenane wetkemaine, yewa esatkamde okannom!” ");
INSERT INTO ons_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ŋara zakeo metkoi, eŋano ŋine maneŋo Yesu eŋe daleo wane don iwa Yudas olatke ea wane kine eŋe mi detkoi. ");
INSERT INTO ons_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudas eŋe wesi kite ware geke, yalinane dokoine natne eŋe wetke rakoi, eŋe ari peada wane ŋara mane qole sariakane Yesu eŋe olatmaike, me kine kine natne ŋei ŋerep aboŋene midaine eboniakane olatmaike. ");
INSERT INTO ons_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas eŋe beret neki paki, yewaoka wie arike. Pakiso goiŋ kereke. ");
INSERT INTO ons_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas eŋe biraone ariki, ea wane ŋadino Yesuŋo rake, “Ukude Ŋei Wawainane Gipolane kibi qelaŋanine wakonmaike, Paki eŋane ramo Anutu wane kibi qelaŋan ukude wakonmaike. ");
INSERT INTO ons_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","So eŋane ramore Anutu wane kibi qelaŋan wakonmaikeo yemo Anutu oŋom Ŋei Wawainane Gipolane kibi qelaŋanine wakoniake, mi azoŋgi ikopka ma wakoniake. ");
INSERT INTO ons_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Medewekopne, na naso kiroine ŋinerop zok mi gekale. Ŋine na baŋ zuaŋnanikei, Yuda ŋei edangole yewaka koso siluŋ iwa ŋine ŋidanbe, “Na arikale yewaka ŋine maine mi sarikei. ");
INSERT INTO ons_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na ra rokop don mane musele ŋine ŋibonmaile, wet maep okannagu gekei, noŋo wet maep okan ŋungole yale waka ŋidomka wet maep okan nagukei.’ ");
INSERT INTO ons_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ŋine wet maep oka okan nagu geu, ŋei ŋerep korop eŋe ŋune detpi naŋane dokone okanikei.” ");
INSERT INTO ons_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Petoroŋo Yesu qesonka rake, “Waom, ge diao arikene me?” Rakiso Yesuŋo olatke, “Na arikale numa yewao ge maine mi mogatnane sarikene. Ŋo baŋ ŋado yemo mogatnane sarikene.” ");
INSERT INTO ons_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Yale olatki Petoro qesonka rake, “Waom, na onoka wane iwaka geŋane ŋadeŋono mi sarikale? Na geŋane rawe paki seukkalane mo ewekmaile!” ");
INSERT INTO ons_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesuŋo donine turuŋine mainge olatke, “Ge welekatne naŋane ranom paki seukkenane ewekmaine me? Na welekatne golatpe detnom, ge atak karewe na mi detkamaile, ra bisopkenom tiak bokayake.” ");
INSERT INTO ons_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuŋo edane rake, “Ŋine misuk qiseu paki oŋaŋine qaeake, ŋine Anutu malipkaikei, so na yale waka malipnanikei. ");
INSERT INTO ons_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Naŋane Maganane matko urum kotine loutne pamaike, ea wane na mo ea ariwe paki ŋinane numa ma sulukkale. Yewaŋo mi pakirap yemo na don iwa yale mi ŋidanberap. ");
INSERT INTO ons_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na ari ŋinane numa ŋine ma sulukewe qoeki, ŋado zinge sariwe paki ŋibu iwenŋune ariwe, ŋine na gekale, yewaoka gekei. ");
INSERT INTO ons_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mat na arikale, yewao ari lotke lotke wane numaine yemo ŋine mo detmami.” ");
INSERT INTO ons_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasŋo olale rake, “Waom, ge diao arikene, ŋene yewa mi detmaine. Ŋene mat yewa ari lotke lotke wane numa daleo detkaikene?” ");
INSERT INTO ons_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Rakiso Yesuŋo olatke “Numa, so don welekatne, ea wane kine na, so gege welaine, ŋei mane eŋe numa naeoka Magak wano sari sari, eamo numa mane mi pamaike, midakaka, naŋanoka wekuku. ");
INSERT INTO ons_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Iwa yemo ŋine mo det nanmami, wane Magane baŋ yale waka detkaikei. Ukude mo ŋine kieke more, eŋe welekatne detkamami, so ŋine mo detkemi.” ");
INSERT INTO ons_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipŋo olale rake, “Waom, Magak sikan ŋonnom kaŋem. Pakimo yewaŋo dereret so simileze rokopke warekep, ŋene ea wane korop zok ŋaŋaemaine.” ");
INSERT INTO ons_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Rakiso Yesuŋo mainge olatke, “Pilip, na naso kiroroine ŋinerop zok ge sarimaile, ŋo ge siluŋ na mi detluknanmami me? Mane eŋe na nan okanmaike, eŋe Magak kamaike. Paki mo ge onoka wane ramaine, ‘Sikanŋonnom Magak kaŋem’ ? ");
INSERT INTO ons_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ge na mi mane malip nanmaine, Pilip, noŋo Magak wano gemaile, eso Magakŋo naŋano gemaike. Na don ŋidan okanmaile, yewa nae wetnoŋine mi ŋidan okanmaile, Magak, eŋe naŋano gemaikeŋo eŋine urataine ma okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ŋine don iwa dere malipnanikei, na Magak wano gemaile, eso Magak eŋe naŋano gemaike. Ŋo midao yemo na urata kine kine korop ma okanmaile, yaline ea detsoroke so malip nanikei. ");
INSERT INTO ons_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na welekakatne ŋidanbe detpi, ŋei mane eŋe naŋane don dere malip kayake, eŋe baŋ na urata mamaile yewa mayake. Welekatne, eŋe baŋ urata kakapa suaine, na mamaile ea wane rokop yuane mayake. Onoka wane na Magak wano arikale ea wane. ");
INSERT INTO ons_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ŋine kine kine yewa me yewa wane rau paki naŋane eŋetne nora meŋenkau na baŋ maikale, paki Magak wane qeli ewe zonom so qelaŋan Gipolano baŋ ma wakoniake. ");
INSERT INTO ons_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ŋine kine kine mane wane rau paki naŋane eŋetne nora meŋenkau na detŋune more makale. ");
INSERT INTO ons_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ŋine naŋane simile dere wetŋine naŋane motmamiwo, yemo ŋine naŋane don mogare aŋa tewekkei. ");
INSERT INTO ons_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Paki na Magak meŋenka more olatpe, eŋe Qesi Qesiŋ mane baŋ ŋiboniake, yemo don welekatne ea wane Asu, oŋo naso baŋem ŋinerop banine ge ariake. ");
INSERT INTO ons_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Qesi Qesiŋ yewa yemo don wele so mainane Asu Koboboine, kepe ŋei ŋerep eŋe maine mi maikei, onoka wane eŋe maine mi kaikei, me mi detkaikei. Ŋo ŋine yemo eŋe det kamami, yalinane eŋe ŋinerop metmaike, so ŋinane kotoŋino baŋ geake. ");
INSERT INTO ons_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Na maine mi biraŋune more qeliŋunbe, ŋinŋineka bonep ŋerep medep naga magaene seu seune magak midaine yale ŋinŋineka gekei, midakaka, na baŋ koso zinge ŋinano sarikale. ");
INSERT INTO ons_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nasomde bamgo nigatne ŋei ŋerep kepeo ŋine eŋe koso na manerop takotke more, mi nanikei, ŋo ŋine yemo baŋ nanikei, so na gege togon gemaile, yale waka ŋine baŋ gege togon gekei. ");
INSERT INTO ons_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Naso yewao ŋine na Magak wano gemaile, yewa ŋine baŋ desikei, so na Maganano gemaile, so ŋine naŋano gemami, ŋo noŋo yale waka ŋinano gemaile. ");
INSERT INTO ons_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mane eŋe naŋane pi so ra rokop donne dere malip kayake so teweke ma geake, ŋei yewa oŋo na wet maep okannaniake. Mane eŋe na wet maep okannan okanmaike, eŋe naŋane Maganeŋo baŋ wet maep okan kayake, Na yale waka eŋe baŋ wet maep okankaikale, so nae kinene sikanka more, ra wakone manikale.” ");
INSERT INTO ons_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesu eŋe don yalewa raki, Yudas mane, Yudas Iskariot, ea mida, eŋane wasine oŋo Yesu qesonka rake, “Waom, ge daleo wane geŋone kineŋone ea ŋenanoka ma wakonikene, ŋo ge geŋone kineŋone yewa mo kepe ŋei ŋerep natne eŋano yemo maine mi ma wakonikene?” ");
INSERT INTO ons_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Pakimo, Yesuŋo donine turuŋine ea mainge olatke, “Mane eŋe na wet maep okannan okanmaike, eŋe baŋ naŋane don dere teweke mageake, paki naŋane Maganeŋo eŋe baŋ ŋei yewa wane siminkaki, wet maep okan kayake. Eso naŋane Magane so na, ŋere baŋ eŋano sarite eŋerop naso baŋem weneŋ mere kito okane gekene. ");
INSERT INTO ons_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mane eŋe naŋane simile dere wet maep mi okan nanmaike, eŋe naŋane don dere tewek mi okanmaike. Don ŋidanbe det okanmami, yewa mo naewo ŋine midakaka, yemo Magakŋo talenangi ketkole, eŋano ŋine sari okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Na ŋinerop gewe paki don kine kine iwa yemo mo ŋidane warekole. ");
INSERT INTO ons_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Qesi Qesiŋ ŋine, Asu Koboboine eŋe Magakŋo baŋ talekaki naŋane eŋetko zonom ŋiboniakane kesiake, oŋo baŋ kine kine korop ŋidane kito ŋibon okaniake, so wetŋine malotkeki noŋo don kine kine korop ŋidan okanmaile, yewa detwarekei. ");
INSERT INTO ons_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Na biraŋunbe wet pesek ŋinano payakane na qeliŋka ŋibonmaile, na nae wet pesek ŋine ŋibon maile. Na peam wet pesekŋine ŋibonmaile yemo kepeo ŋei ŋerep edo ŋibon okanmami yale okane mi ŋibonmaile. Ŋine qiseu paki oŋaŋine misuk qaeyake, Ŋine misuk kaet okanikei. ");
INSERT INTO ons_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na don iwa yale ŋidanbe ŋine mo derimi, ‘Na mo biraŋune arimaile, ŋo siluŋ ŋinano baŋ koso zinge sarikale.’ Ŋine wet maep okan nanbirap, yemo na Magak wano arikale, ea wane ŋine wetpese detpirap, onoka wane Magakŋo naŋane wawainene gemaike ea wane eŋe wet pese suaine ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kine kine iwa wele korop mi wakongi, na don iwa alakane ŋidanmaile, wane welekatne wakongi ŋine maine malipnanikei. ");
INSERT INTO ons_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na don kiroine zok ŋine mi ŋidanikale, onoka wane, kepe iwa wane ŋei waom mo sarimaike, eŋe zonomine midaka, naŋane kutno maine mi wayake. ");
INSERT INTO ons_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ŋo siluŋ kepe ŋei ŋerep eŋe na Magak wet maep okanka okanmaile, yewa detluk warekei. Kine yalinane na urata don ra ninge, ea wane korop ma waremaile. “Eso maine ŋine weiu, ŋene mat iwa qelige ariŋem.” ");
INSERT INTO ons_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Na welekatne wain ekiine, ŋo nae Magane eŋe wain eu welaine. ");
INSERT INTO ons_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Qogine kopne me mulaune me metine bori worine natne naŋano seu seune wele midaine okane pau, eamo yeine magakŋo kitare qakki arikei, ŋo mulaune natne wele maine, eamo wareongi, wele manerop qekei. ");
INSERT INTO ons_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ŋine yemo mitidon mo ŋidanbe detkoi, paki yewaŋo ŋibuki qelaŋangoi gemami, ");
INSERT INTO ons_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ŋine na wet mali malipŋineŋo na ma qotnane gekei, eso na ŋine baŋ yale waka wetneŋo ma qotŋune gekale. Ŋo wain bogine mane eŋe eŋineka pa more wele mi qeake, eŋe weku wain kinerop tako rakot pa more, yemo wele maine qeake. Rokop yale waka ŋine weleŋine maine mi qekei, na wetŋineŋo neu qotnane, narop tako rakot geu paki, yemo weleŋine maine qekei. ");
INSERT INTO ons_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Na wain ekiine, ŋo ŋine qogine kopne, mane eŋe narop takorakot geake, eso na eŋerop takorakot gekale, eŋe weleine zok manerop wakoniake. Ŋine na midaine geu, paki kine kine mane maine mi maikei. ");
INSERT INTO ons_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mane eŋe na mi ne qotnane geake, eŋe eki qogine kitare biraki ari seukeake. Eki qogine yaline yemo korop meik ware gerepko peikki wau gerepŋo zeki solokki paki, korop mida lelekei. ");
INSERT INTO ons_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ŋo ŋine na ne qotnane geu, naŋane donŋo ŋinane koto ŋino payakeo yemo ŋine kine kine mane wane ŋungi meŋenkau paki ŋine maine maratkaikei. ");
INSERT INTO ons_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yale waoken okane more naŋane Maganane eŋet biŋek mawa sikan onikei, so ŋine weleŋine zok manerop qekei. Numa yalewa okanikei yemo ŋine naŋane dokone okangei. ");
INSERT INTO ons_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Magakŋo na wet maep okannan okanmaike yale waka noŋo ŋine wet maep okanŋun okanmaile, ea wane ŋine naŋane wet maepkoka gekei. ");
INSERT INTO ons_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na Maganane aŋa donne so ra rokopine tewekewe paki eŋane wet maepko gemaile, ŋine naŋane aŋa don eso ra rokop donne tewekeu paki, naŋane wet maepko gekei, ");
INSERT INTO ons_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Na don iwa ŋidan waremaile, yemo naŋane wetpeseŋo ŋinane kotoŋino maine kesiake, paki ŋinano wetpeseŋo maine watwatko rokopke payake. ");
INSERT INTO ons_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Naŋane aŋa donne me ra rokop donne, yemo iwa yale, noŋo wet maep okanŋun okanmaile, yale waka ŋine ŋidomka wet maep okan nagu gekei. ");
INSERT INTO ons_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sogino daleo wet maep okan nagu gekoi? Iwa yale, ŋine ŋinŋine simile ea misuk mogatka gekei. Ŋine doku tau tau magu kima kopŋine ea eŋane simile zok manerop dere gekei. Ŋinano ŋine maneŋo kimkoune eŋane ra more gegeine ma qaisikkaki paki, yeine seukeakeo, eŋe kimakoune wetŋo qotone more malipone okarayake, ea mo menageake. ");
INSERT INTO ons_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na don ŋidanmaile yewa tewekkeiwo, yemo na ŋunbe naŋane kimakopne okangei, ");
INSERT INTO ons_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","qelit mama eŋe suaineineŋo kine kine onokaka mamaike, ea mo mi detlukmaike, ea wane turuŋine yemo na ŋine urata medep mi ŋidora more, na kimakopne ŋidoramaile, onoka wane na Maganano ŋine don kine kine detkole, yewa korop mo ŋidan waremaile, ea wane na kimakopne ŋidoramaile. ");
INSERT INTO ons_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ŋido na mi ma wakonnangoi, noŋo ŋine ma wakonŋungole, so ari geu paki wele loutne maratkau baninine payakane uratao biraŋungole. So ŋine kine kine yewa me yewa Magak wanoŋine maikei wane rau paki naŋane eŋetne nora meŋenkau eŋe baŋ ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iwa yemo na ra rokop me aŋa donne iwa yale ŋidanmaile, ŋine ŋidomka wet maep okan nagu gekei.” ");
INSERT INTO ons_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kepe ŋei mitiene midaine eŋe qaisikŋunbi ŋine iwa yale desikei, eŋe alakan na yale waka qaisiknangoi. ");
INSERT INTO ons_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ŋine kepe iwa wane biŋek ra yemo kepeo ŋine ŋei eŋe enŋene biŋek wane kima maine okan ŋunbirap, yemo noŋo ma wakonŋunbe kepe iwa wane tanik manik qeliŋgoi wane ŋine ea wane biŋek mi gemami. Kine yalinane kepeo ŋine ŋei ŋerep eŋe qaisikŋunmami. ");
INSERT INTO ons_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na iwa yale ŋidangole yewa detmami, ‘Qelit mama maneŋo suaineine mi yuan kayake,’ eŋe na ŋaba okan nangoiwo, yemo ŋine baŋ yalewaka okan ŋungei. ");
INSERT INTO ons_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Eŋe siluŋ tanik kine kine iwa baŋ okanŋun warekei, onoka wane, na Magakŋo ŋinane ra biranangi ketkole, ŋine naŋane biŋek gemami, ea wane kine eŋe mi detkamami. ");
INSERT INTO ons_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na eŋano sariwe paki, kine kine mane mi edangole ra, yemo eŋe borikine midaine geurap. Iwa yemo eŋe koso borikineene manerop motkekei wane numaine mane mi pamaike. ");
INSERT INTO ons_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mane eŋe na qaisiknan okanmaike, eŋe Magane yale waka qaisikka okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na eŋane keueno masi kine kine, ŋei maneŋo mi mamaine, yewa mawe mane mi kaurap yemo eŋe borikineene midaine geurap. Iwa yemo mawe eŋe mo kauluk warekoi, ŋo koso siluŋ na so Magak weneŋ qaisikŋot okanmami. ");
INSERT INTO ons_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yale okanbi, enŋene ra rokop Dongo don mane qekoi, ea wane wele wakonge, ‘Eŋe kine midaine naŋenka qaisiknangoi.’ ");
INSERT INTO ons_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Qesi Qesiŋ baŋ sariake, don wele ea wane Asu, oŋo Magak wanoŋine sariake. Noŋo baŋ Magak wanoŋine talekawe ŋinano sariake. Sariki paki naŋane kine ra suayake. ");
INSERT INTO ons_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","So ŋine weneŋ yale waka naŋane don ra qelaŋanikei, onoka wane ŋine mo qei kino kieke narop gekoi, ge sarimage iwa gemami. ");
INSERT INTO ons_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ŋine wet mali malipŋine mi qororogeakane na don iwa ma togole ŋune ŋidanmaile. ");
INSERT INTO ons_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Eŋe baŋ Yuda lewa lewaŋ urumeno ŋine esopŋunbi qeinat kesikei, so baŋ ŋado naso bomileki, ŋei maneŋo ŋingu more iwa yale desiake, na tanik yale okanbe paki Anutu wane urata qesiŋka mamaile, yale desiake. ");
INSERT INTO ons_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Eŋe masi tanik iwa ŋine korop baŋ okanŋun warekei. Onoka wane eŋe Magak me na mi det lukŋot okanmami ea wane. ");
INSERT INTO ons_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ŋo na don iwa ŋidanmaile, yemo baŋ ŋado eŋe masi tanik iwa korop okanŋungei wane nasoine bomileki, ŋine baŋ don ŋidanmaile iwa, wetkekei. “Na sogine mikep kieke ŋinerop gekole, yalinane kine kine iwa korop mi ŋidanwarekole. ");
INSERT INTO ons_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ŋo iwa yemo maŋo talenangi sarikole eŋano arimaile, paki mo, ŋinano ŋine maneŋo mi qesonnane ramaike, ‘Ge diawao arikene?’ ");
INSERT INTO ons_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wane iwa yemo noŋom don iwa ŋidanmailane, ŋinano zok wet borikŋo qom ŋine watkemaike. ");
INSERT INTO ons_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na siluŋ ŋidanbe detpi, iwamo mayakatne na ŋinane arikale, onoka wane na mi arikale yemo Qesi Qesiŋŋo ŋinano mi sariake. Ŋo na welekatne arikaleo, yemo na eŋe baŋ talekawe ŋinano sariake. ");
INSERT INTO ons_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","So eŋe sariki paki, ŋei ŋerep kepe baŋem ge arimami, eŋe kine ma qelaŋane ebongi iwa yale desikei, eŋe borikine mau paki sotkorop okangei, so koboboine gege pamaike, so borikineene turuŋine Anutuŋo ma wesake wanokeake ea pamaike. ");
INSERT INTO ons_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Eŋe borikine mau paki sotkorop okangei, ea wane kine iwa yale desikei, eŋe na mi malip nanluk okanmami. ");
INSERT INTO ons_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Koboboinane kine iwa yale desikei, na Magak wano ariwe ŋine koso manerop mi nanikei. ");
INSERT INTO ons_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Anutu wane turuŋ mako makok wane kine iwa yale desikei, kepe iwa wane ŋei waomine eŋe turuŋinane don zonomine mo rakoke ma ket birakaki zonomine mida leleke. ");
INSERT INTO ons_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na don loutne ŋidangalane ma gemaile, ŋo naso iwaoka ŋidanbe ŋine maine mi malipka more det warekei. ");
INSERT INTO ons_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ŋo naso iwao don wele ea wane Asu sarimaike, yewao eŋe baŋ iwenŋungi don wele korop ea wane kotino waket warekei. Eŋe eŋine wetkoŋine don mi ra wakoniake, midakaka. Eŋe oŋomoka detmaike yewa ra wakoniake, so kine kine ŋado wakoniake yewa wane ŋidaniake. ");
INSERT INTO ons_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Oŋo na qeli ewe zonomine niniake, onoka wane eŋe don yewa yemo nae wet dereretnane torango ŋine maki paki ŋidaniake.Masi so tanik yewa okane more naŋane zonom so eŋet biŋekne maki suayake. ");
INSERT INTO ons_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kine kine korop Magakŋo ma gemaike, yemo naŋane, na ea wane rele, Asu eŋe naŋane torangoŋine maki paki ra qelaŋane ŋidaniake.” ");
INSERT INTO ons_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu eŋe koso rake, “Nasomde nigatneka ŋine na koso manerop mi nanikei, eso koso nasomde nigatne mane wane ŋadino ŋine koso nanikei.” ");
INSERT INTO ons_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Eŋine dokoine natne edo natne edane rakoi, “Don iwa wane kine daleo? Eŋe ŋedane ramaike, ‘Nasomde nigatneka ŋine na mi nanikei, eso koso nasomde nigatne mane wane ŋadino ŋine koso na nanikei’ , eso eŋe koso yale waka ramaike, onoka wane na Magak wano arimaile.’ ");
INSERT INTO ons_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Eŋe qesone rakoi, ‘nasomde nigatneka mane, ea wane kine daleo? Ŋene mi detmaine eŋe ea onoka wane ramaike!” ");
INSERT INTO ons_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu eŋe qeson kakeiwane okangoi, ea mo detongi paki edane rake, “Na rele, ‘Nasomde nigatne ŋine koso na mi ninikei, eso koso nasomde nigatne mane wane ŋadino ŋine koso na ninikei.’ Ŋine don iwa na rawe ea wane ŋine ŋidomka qeson nagumami? ");
INSERT INTO ons_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na ŋidanbe detpi, ŋine suaine arokkei so posik aro arokkei, ŋo kepeo ŋei ŋerep eŋe yemo batneka gekei, ŋine yemo baŋ wet borik desikei, ŋo ŋinane wet borikŋo qein geki batneka so wet pesek kutno gekei. ");
INSERT INTO ons_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ŋinane wet borikŋine yemo iwa yale wane kop, ŋerep mane eŋe medep mayakane nasoine bomileki, wikile detmaike, onoka wane eŋane naso mo bomilemaike ea wane, eŋe wikile desiake, so eŋe nasoine medep mayake ea mi detmaike. Ŋo baŋ medep wakonmaike, yewao ŋerep eŋe wikileine yewa mo nigetkakimo, wetine pesemaike, onoka wane medepŋo inat sari wakonmaike, ea wane. ");
INSERT INTO ons_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ŋinanoken numa yale waka pamaike, ukude ŋine wikile detmami, ŋo na baŋ koso manerop ŋine ŋunikale, eso yewao yemo ŋinane qomŋine wet pese so batneka gege yewaŋo watke payake. Pakimo batneka gege yaline yewa yemo ŋei maneŋo ŋinano ŋine maine mo omakŋune ma ariake. ");
INSERT INTO ons_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Kaiwe naso yewa sariake, yewao ŋine kine kine mane wane maine mi qeson nanikei. Na ŋidanbe detpi, ŋine kine kine yewa me yewa ŋiboniakane naŋane eŋetko meŋenkau Magakŋo baŋ ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ŋine alakan kine kine mane naŋane eŋetko maikei wane mi meŋenkakoi, ŋine meŋenkau paki, baŋ kine kine makei, yale okanbi, ŋinane wet peseŋo sua more, wat watko payake.” ");
INSERT INTO ons_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesu eŋe koso rake, “Na don kine kine iwa korop yemo yaup naŋengo more ŋidane sarikole. Ŋo baŋ ŋado naso bomile sariake, yewao na koso don naŋengo manerop mi rakale, midakaka, na baŋ siluŋ Magak wane kine didiwo ra wakone ŋine ŋidanwarekale. ");
INSERT INTO ons_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kaiwe naso yewao ŋine baŋ naŋane eŋetko eŋe meŋenkaikei, so noŋo ŋinane rawe paki Magak meŋenkakalane mi ramaile, midakaka, ");
INSERT INTO ons_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","onoka wane, Magak eŋe oŋom ŋine wet maep okanŋun okanmaike, ea wane. Ŋine wet maep okannan okanmami, so na Anutu wanoŋine sarikole ŋine don yewa detluke malipnane okanmami ea wane eŋe wet maep okanŋun okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sogino na Magak korop gekole, wane na Magak wanoŋine kepo ketkole, so na kepeo sarikole, wane iwa yemo na kepe mo qeliŋkamaile paki, koso Magak wano arimaile.” ");
INSERT INTO ons_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Eŋine dokoine eŋe olale rakoi, “Kanom, ge iwa yemo ukude don naŋengo mane mi ramaine ge didiwoka ramaine. ");
INSERT INTO ons_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Iwa yemo ŋene mo detmaine, ge ŋei maneŋo ra qeson okaniakane, mi ganmaike, midakaka, ge goŋomka kine kine korop mo det waremaine, masi yalewa wane mo ŋene malipgane more, ramaine, ge Anutu wano ge more, yewa ŋine sarikone, ŋene yewa detlukmaine.” ");
INSERT INTO ons_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Rauso Yesuŋo doneene turuŋine mainge more edange, “Ŋine ukude wamo malip nanluke more detlukmami me? ");
INSERT INTO ons_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ŋine detmami, naso mo bomileakane okanmaike, mo iwa qe more sarimaike, ŋine korop baŋ bira nagu yeo yeo ket weku weku wela wela, matŋino matŋino ariwarekei. Biranane ari wareu naeka baŋ gekale, ŋo siluŋ na naeka zok mi gekale, onoka wane, Magakŋo baŋ narop weneŋ gemaike, ea wane naeka mi gekale. ");
INSERT INTO ons_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Na don iwa ŋidanmailane ŋine naŋano qeturageu wet menaŋŋo ŋinano baŋ payake. Kepeo liwe liwek pamaikane baŋ ŋibuki umat so wikile manerop desikei. Ŋo ŋine siluŋ wet mali malip ŋine togogole okorakei! Na kepe iwa wane ŋetne kine kine yemo mo qe ari mage yuanka waremaile!” ");
INSERT INTO ons_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuŋo don iwa rawareki qoeki ea wane ŋadino deine potki qeliwo waki iwa yale rake, “Magak, naso mo bomilemaike, ge Giponŋonane qeli ewe zonomine mannom, ea wane Giponŋoneŋo ge yale waka qeli ewe zonomine maine giniake. ");
INSERT INTO ons_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Onoka waneŋo goŋo kepe baŋem ŋei ŋerep korop eŋane welaene geakane eŋet biŋek mo ra mangone, ea wane eŋe ŋei ŋerep korop geŋone biŋek sunka mangone, yewa eŋe maine gege togon ma wakone ebongi, naso baŋem ge wakei. ");
INSERT INTO ons_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Eso gege togon wane kine yemo iwa yale, geŋone biŋek sunka mangone, ŋei magu yewa maine geŋone kine koboboine detluk ganikei, ge Anutu wele weku, so ge talekanom ketke, Yesu Kristo, eŋe weneŋ detkaikei. ");
INSERT INTO ons_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Na geŋane eŋet biŋek so qeli ewe zonomŋone mo kepeo ŋei ŋerep korop sikan onwaremaile, na urata makalane ra ningone, yemo mo mawe qoe waremaike. ");
INSERT INTO ons_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Magak! Kepe mi wakonge, naso yewao, na gerop gewe paki, na eŋet biŋek korop okangole, na geŋone qeli ewe zonomŋone yewa ukude kaitŋono koso iwa ninnom. Paki na qeli ewe zonom wekuka mokaka gerop ge more magekole, ea koso ninom mawe paki, na koso gerop gekale. ");
INSERT INTO ons_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Na geŋane eŋet biŋekŋone yewa kepeo ŋei magu suaine eŋane keuo ŋine ŋei sikan one more rawakone, kepeo ŋei magu suaine edanbe, ge ebu wanok okane ningone, eŋe mo sikan one more, ra wakone geŋone kine edan waremaile. Eŋe ebu wanok okannom, geŋane biŋek okane more, eŋe geŋane donŋone dere tewekkoi. ");
INSERT INTO ons_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Eso ukude eŋe iwa detmami, yemo iwa yale, kine kine korop na ninwarekone, yemo geŋano ŋineka sari waremaike. ");
INSERT INTO ons_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Biŋek donŋone na ningone, yewa korop eŋe ebonwarewe eŋe dere malipka okangoi. Paki biŋek don ea wele okange, yewa detlukkoi, so eŋe goŋo welekatne talenannom ketkole yewa weneŋ dere malip kakoi. ");
INSERT INTO ons_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Na eŋe qesiŋ ongenane rawe paki eŋane meŋen ganmaile, na kepeo ŋei ŋerep eŋe qesiŋ onikenane me eŋane rawe paki mi meŋen ganmaile, ge ŋei ebu wanok okane ningone, yewa eŋaneka meŋen ganmaile, yemo onoka wane, eŋe mo geŋane biŋek. ");
INSERT INTO ons_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Naŋane ŋei ŋerep magu ebu gemaile yewa yemo korop geŋane, so geŋone ŋei ŋerep magu ge ma gemaine, yewa yemo korop naŋane, eso eŋe naŋane qeli ewe zonomne kepe ŋei ŋerep sikan onbi kamami. Paki kepe ŋei ŋerep eŋe ŋei ŋerep tego yewa one more, eŋe naŋane eŋet biŋekne mawakei. ");
INSERT INTO ons_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na koso kepeo manerop mi gekale, eso iwa yemo geŋano umaile, ŋo eŋe naŋane magu kepo gekei, eŋane ra more meŋen ganmaile. Magak ge koboboine eŋet biŋek ŋonane zonomineŋo wareonnom maineka gekei, eŋet yemo goŋo na ningone, ea wane eŋe wet so magu weku okanikei, ge so na ŋere wet weku ea wane rokop. ");
INSERT INTO ons_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na eŋerop gekole, naso yewao na geŋane eŋet biŋek ŋonane zonomineŋo wareonbe eŋe maineka gekoi, eŋet yewa yemo goŋo na ningone. na kawet ongole, eso eŋano ŋine maneŋo mi siukke, ŋei weku Yudas eŋe gerep sora wane biŋek raraine. Yemo Anutu geŋane Papiao don qeqine yewa wane wele wakoniakane yale okange. ");
INSERT INTO ons_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na iwa mo geŋano umaile, ea mo naŋane wet peseŋo eŋane kotoeno ket more maine naewo wat watko pamaike, rokop eaka eŋano payake. ");
INSERT INTO ons_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na geŋane don ebonbe mageu kepe wane biŋek ŋei edo qaisikon okanmami. Onoka wane, na kepe wane biŋek me wet dereret mane mi magemaile, ea wane, eŋe yale waka kepe wane biŋek, me wet dereret mane mi magemami wane eŋe yale okanonmami. ");
INSERT INTO ons_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na kepeo ŋine ebukenane rawe paki mi ramaile, me ea wane mi meŋen ganmaile, ge qesiŋone more wareonnom, maineka geu, ŋei borikineŋo mi matali oniake, na ea wane ra more meŋen ganmaile. ");
INSERT INTO ons_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Eŋe kepe wane biŋek me wet dereret mi magemami, na yale waka kepe wane biŋek me wet dereret mane mi magemaile. ");
INSERT INTO ons_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Geŋane don yemo welerop na ea wane ramaile, donŋone yewaŋo weteno motnom, eŋe koboine geŋone biŋek okangei, geŋane don yewaŋo yemo wele. ");
INSERT INTO ons_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Goŋo na talenannom kepeo sarikole, so na ŋei ŋerep eŋane keueno urata makalane ketkole, yale waka noŋo eŋe kepeo ŋei ŋerep eŋane keueno ge urata mau, geŋane eŋet biŋekŋone wakoniakane taleonmaile. ");
INSERT INTO ons_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ŋo na qesiŋ ongalane na noŋomka eŋane rawe paki, gegene genano motmaile, ea yemo eŋe welekakatne yale waka don wele yewaŋo ebuki geŋane qiŋek ŋei wele, okane gekei. ");
INSERT INTO ons_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“So na ŋei yewa eŋaneka rawe paki mi meŋen ganmaile, midakaka, na meŋen ganmaile yemo geŋone biŋek donŋone kepe ŋei ŋerep edanbi eŋe don ea dere more na malipnanikei wane ra more weneŋ meŋen ganmaile. ");
INSERT INTO ons_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Na eŋe wetene koropka weku more, ge Magak weku yalewa ra gekei wane meŋen ganmaile. Magak! Goŋo na wetŋoneŋo qotnan okanmaine, ŋo noŋo ge yale waka wetneŋo qotgan okanmaile, yale waka eŋe ŋere ŋetsarek weteneŋo qotŋosikei wane meŋen ganmaile. Eŋe wet weku okane gekei, yale okane kepeo ŋei ŋerep kito edanbi eŋe goŋo na tale nannom ketkole, yewa baŋ detluke malip nanikei. ");
INSERT INTO ons_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ge qeli ewe zonomŋone so eŋet biŋek suaine na ningone, na qeli ewe zonom weku yewaka eŋe ebongole, ea wane eŋe wet dereret wekuka gekei, ge so na ŋere wet dereret wekuka gemaite yale waka eŋe gekei. ");
INSERT INTO ons_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na eŋano ge more, wetŋo qot onmaile, eso goŋo na yale waka qotnan mainane eŋe weteneŋo edomka yale waka siwap nagu weku okanbi paki, eŋe kepeo ŋei ŋerep kito edanbi, eŋe goŋo talenannom ketkole, ea maine desikei, so goŋo na wet maep okan nanmaine, yale waka eŋe wet maep okan onmaine. ");
INSERT INTO ons_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Magak! Ŋei ŋerep yewa eŋe goŋo na ningone, edo na gekale mat yewaoka narop weneŋ gekei wane nanmaike, paki eŋe naŋane qeli ewe zonom qelaŋan maine kaikei, qeli ewe zonom qelaŋan so kibi maep ge na ningone yewa, onoka wane, ge kepe mi ma wakongone, naso yewao na wet maep okan nangone. ");
INSERT INTO ons_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Magak ge koboboine! Kepe baŋem ŋei ŋerep eŋe ge mi det ganmami, ŋo noŋo yemo ge detganmaile, so dokone iwa eŋe detmami, goŋo na talenannom ketkole. ");
INSERT INTO ons_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na geŋane eŋet biŋek so don kisiŋone ra qelaŋane edanbe detkoi, so na baŋ koso eŋerop takotke ge more, ma wakon lukkale. Paki eŋe edomka kimakopene wet maep okan nagukei, onoka wane, geŋone wet maepŋone naŋano pamaike, eaka sikanonbe, eŋano pa wareake, so na weneŋŋo qotone more eŋerop gekale.” ");
INSERT INTO ons_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu eŋe meŋe meŋen iwa meŋenkaki qoeki mat yewa qelige dokoine eŋerop arikoi. Eŋe ari Kidron doku roino yuane ket kito erinat wakoi. Kepe yewao eu mane pake, eso Yesu eŋine so dokoine eŋe eu yewa wane kotino waketkoi. ");
INSERT INTO ons_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas Yesurop kima isi isi okangi makei, eŋe eu yewa mo detke, onoka wane naso baŋen Yesu eŋe eu yewa ari dokoine marat onmaŋke. ");
INSERT INTO ons_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yalinane Yudas eŋe eu koto arike. Eŋerop ebuki arikoi, yemo kawali ŋei magu mane so bakom urum wane diam gege tebe ŋei, eŋe pris suaine edo biraonbi arikoi, so Parisi natne, eŋe kawali aboŋ weneŋ peike arikoi, eso lam so kiwa weneŋ makoi. ");
INSERT INTO ons_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu eŋe masi kine kine korop daleo wakon kayake ea mo korop detwareke. Eso ea wane eŋe osoeno ari qesonone rake, “Ŋine ma zuaŋkamami?” ");
INSERT INTO ons_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eŋe donine mainge more rakoi, “Ŋene Yesu Nasaret welaine zuaŋ kamaine.” Yesu eŋe doneene turuŋine mainge edane rake, “Na iwa.” Ŋo Yudas, walik matiwan, kima isisi ŋei, eŋe yewa eŋerop weneŋ okorake, ");
INSERT INTO ons_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Eŋe dere okorau, Yesu eŋe edane rake, “Na iwa.” Raki eŋe ŋade ŋade ari more kepo ket rasu pakoi. ");
INSERT INTO ons_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yale okanbi Yesu eŋe koso manerop qeson one rake, “Ŋine ma zuaŋkamami?” Eŋe rakoi, “Yesu Nazaret mat welaine.” ");
INSERT INTO ons_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesuŋo edange, “Na mo ŋidanile, na iwa. Ŋine na zuaŋ nanmamiwo yemo natne iwa eŋe qeliŋonbi ariu.” ");
INSERT INTO ons_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu eŋe iwa rake yemo alakan meŋenka rake, ea wane wele wakoniakane iwa rake. “Magak, ge ningone eŋano ŋine weku mane mi qeliŋkawe siukke.” ");
INSERT INTO ons_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Petoro eŋe pilaŋ mageke, Ea wane eŋe maki paki Pris Suainane qelit medep qe more ketne woninoken yewa kito qokke. Qelit medep ea eŋetine Malkus. ");
INSERT INTO ons_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yale okangi, Yesuŋo Petoro olatke, “Pilaŋ ŋone yewa koso biranom kaweuno wetekep! Ge Maganeŋo wikile naso more ninike, yewa mi makalane wetkemaine me?” ");
INSERT INTO ons_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kawali ŋei magu enŋene so ware wareene weneŋ so Yuda ŋei eŋane tebe ŋei edo Yesu ma muga mugaŋo lukkakoi. ");
INSERT INTO ons_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pakiso mikepka Anas wano ma arikoi. Eŋe Kaiapas wane atpine, eŋe koma yewao Pris Wawaine geke. ");
INSERT INTO ons_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas oŋo Yuda ŋei edane rake, “Ŋei weku oŋo maine ŋei ŋerep korop eŋane turuŋene seukeake.” ");
INSERT INTO ons_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Petoro so medepine mane ere Yesu ŋadino mogare arikoik, medepine mane yemo Pris Wawaineŋo eŋe mo det lukkake, ea wane ere Yesurop Pris Wawainane sen koto waketkoik. ");
INSERT INTO ons_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ŋo Petoroŋo yemo mat ŋadino madet osino metke, medepine mane, Pris Wawaineŋo detlukkamaike, eŋe koso zinge sari sen ŋadino saket more madetko ŋerep mane okorake, eŋe olatki paki Petoro wetinat senkoto iwenka waketke. ");
INSERT INTO ons_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ŋerep madet ware ware oŋo Petoro olale rake, “Ge ŋeiwa eri wat na eŋane dokoine eŋaneo ŋine mane iwa ge me?” Petoroŋo rake, “Midaka, na mida.” ");
INSERT INTO ons_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kepe momoine okangane qelit medep so tebe ŋei eŋe koropŋo gerep puanbi zeki, lolikka more qenagare okorakoi, Petoro eŋe waketki pakiso, eŋerop okora gerep qenagatke. ");
INSERT INTO ons_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pris Wawaine eŋe Yesu dokoine eŋane so ŋei ŋerep don dereret natne kito ebo okanmaŋke, yewa wane qesonkake. ");
INSERT INTO ons_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Qesonkaki, Yesuŋo iwa yale mainge olatke, “Na naso baŋen don didiwo ra ŋei ŋerep edan okanmaŋkole, naŋane kito ebo ebonne yemo korop lewa lewaŋ urumgo so bakom urumgo Yuda ŋei sari qeturaŋ maŋkoi, yewao didiwo edan maŋkole. Na don mane sanka qe wazae mane siu siuko mi ramaŋkole. ");
INSERT INTO ons_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Paki mo ge onoka wane na qesonnan maine? Ŋei ŋerep pa edanbe det okangoi, eŋe qeson onnom. Na donba edan okangole, eŋe qeson onnom, na don ra okangole yemo korop edo mo detmami.” ");
INSERT INTO ons_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu eŋe don iwa raki, diam gege eŋano ŋine tebe ŋei mane yewa okorake, oŋo mete tabeŋo qeki paki rake, “Goŋo Pris Wawaine don yaline olatmaine me?” ");
INSERT INTO ons_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesuŋo mainge olale rake, “Na don qotkoine ramaileo, yemo ŋei ŋerep iwa daleo ramaile ea edannom. Ŋo siluŋ na don rele yemo don maine, Paki mo ge onoka wane nekumaine?” ");
INSERT INTO ons_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Eso Anasŋo taleongi, Yesu mulap wokom kakoi, siloke more so iwenka Kaiapas, Pris Wawaine eŋano ma arikoi. ");
INSERT INTO ons_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Petoro eŋe yewaka gerep qenagale okorake, eso natne eŋe qesonka rakoi, “Ge ŋeiwa eriwat wane medep mane iwa ge me?” Ŋo Petoro eŋe bisopkeki paki rake, “Midaka, na eŋane medep mida.” ");
INSERT INTO ons_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pris Wawainane eŋane qelit mama medep mane, eŋane weŋem sotak ŋei mane, ea Petoroŋo ketne nat pilaŋŋo kito qokke, oŋo rake, “Ge eŋerop euo genom na mi ganile me?” ");
INSERT INTO ons_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Koso manerop Petoroŋo rake, “Midaka, na mida.” Yale rakiso yewaka tiak mane bokake. ");
INSERT INTO ons_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Eŋe Yesu Kaiapas wane matko ŋine mau paki Pilat wane matko ma arikoi, ea mo tutupko so sakoka yewao, Yuda ŋei eŋe ware ware wane matkoto mi wakoi, onoka wane eŋe edomka sauke mauluknaguwi paki Anutuŋo loloŋ onge ea wane Peadaino ŋara weneŋ maine mere nekeiwane yale okangoi. ");
INSERT INTO ons_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Eso Pilat eŋe qeinat ketki paki qeson one rake, “Ŋine ŋei iwa onoka wane dongo birakamami?” ");
INSERT INTO ons_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Eŋe iwa yale mainge rakoi, “Eŋe sot mane mi okangirap yemo ŋene eŋe geŋano mi ma sariŋemrap.” ");
INSERT INTO ons_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatŋo edane rake, “Ŋine ŋidomka mau paki ŋin ŋine ra rokop Don ŋinane rokopko dongo birakau.” Yuda ŋei eŋe mainge rakoi, “Ŋene ŋei mane mi qeŋem seukeakane mo rawet ŋonge.” ");
INSERT INTO ons_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Masi iwa wakonge, yemo Yesu eŋe seu seu daleo seukeakane rake, don ea wane weleine wakoniakane yale wakonge. ");
INSERT INTO ons_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilat eŋe mat koto zinge waketke, paki Yesu oraki waki qesonka rake, “Ge Yuda ŋei eŋane Ŋei Waom me?” ");
INSERT INTO ons_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesuŋo mainge olatke, “Qeso qeson iwa geŋono ŋine sarimaike me ŋei natne edo naŋane ra golatmami?” ");
INSERT INTO ons_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Raki Pilatŋo olatke, “Ge naŋane ramaine eŋe Yuda ŋei? Iwa yemo geŋone ŋei kopŋone so ŋetne kopene pris edo ge naŋano geu sari biraganimi. Ge onokaka makone?” ");
INSERT INTO ons_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesuŋo rake, “Naŋane ŋei waom gegene yemo kepe iwa wane biŋek mida, naŋane ŋei waom gegene kepe iwa wane biŋek yemo urata ŋeikopne eŋe kawali maine qeu ŋei maneŋo neu more Yuda ŋei eŋane meteeno mi bira nangirap. Midakaka, naŋane ŋei waom gegene yemo kepe iwa wane biŋek mida!” ");
INSERT INTO ons_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Eso Pilatŋo qesonka rake, “Paki mo ge ŋei waom me?” Yesuŋo mainge olatke, “Mo goŋom ramaine, na ŋei waom. Na wakonbe paki kepeo sari lotkekole, yemo kine weku iwa yale wane, don wele ra qelaŋan galane ketkole. Ŋei mane eŋe don wele kima okanka okanmaikeŋo yemo naŋane don det okanmaike.” ");
INSERT INTO ons_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatŋo qesonka rake, “Don wele ea mo onokaka? Kepe ŋeika ea wane don wele mane daleo det kayake? Don korop wele midaine!” Pakiso Pilat eŋe koso qeinat Yuda ŋei eŋano ketki paki edane rake, “Na eŋane sot mane dongo birakaikenane mi marat kamaile. ");
INSERT INTO ons_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ŋo ŋinane masiŋine mane ma ge okan okanmami, yemo na loloŋon loloŋon Peadao naso baŋem mulap ŋei mane ŋinane siwotka ŋibon okan okan maŋkale. Wane ŋine Yuda ŋei waom siwotka ŋibonikalane ŋunmaike me?” ");
INSERT INTO ons_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Eŋe arok suaine okane more, qazom romatkeu dumengi mainge olale rakoi, “Mida, eŋe midaka! Ŋene Barabas siwotka ŋebonikene!” Barabas eŋe ŋei enguki paki aboŋene kobu mamaŋke. ");
INSERT INTO ons_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pakiso Pilatŋo raki, Yesu ma ari kumunamŋo qekoi. ");
INSERT INTO ons_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kawali ŋei eŋe sitman qogine wakelerop, yewaŋo ŋei waom marok oŋaine mane mau pakiso lewino birakau ketke, eso takot suaine kiroine weŋemka mane ma birakau ketke. ");
INSERT INTO ons_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Paki eŋe Yesu wano sari rakoi, “Yuda ŋei eŋane Ŋei Waom naso kororoine ge arinom!” Eso eŋe wau paki metetabeŋo qekoi. ");
INSERT INTO ons_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat eŋe koso manerop zinge qeinat ŋei ŋerep magu eŋano waketki paki edane rake, “Kau, na eŋe baŋ iwa ŋinano ma saketpe ŋine kaikei, na dongo birakaikei wane kine mane mi maratkamaile.” ");
INSERT INTO ons_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Eso Yesu eŋe mat koto ŋine inat ketke, marokine sitman wakelerop so takotine weŋemka yewaŋo biraso, Pilatŋo edane rake, “Kau! Ŋeimde iwa!” ");
INSERT INTO ons_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pris ŋetne so tebe ŋei diam gege eŋe kau paki qazom mane rakoi, “Kibeŋ qabego qenom seukkep! Kibeŋ qabego qenom seukkep!” Pilatŋo edane rake, “Ŋidom ma ariu paki, kibeŋ qabego qeu, na sotine mane mi marat kamaile.” ");
INSERT INTO ons_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yuda ŋei eŋe mainge olale rakoi, “Ŋenane ra rokop don mane pamaike. Yewaŋo ramaike yemo ŋei yewa eŋe seukeake, onoka wane eŋe eŋinane na Anutu wane Gipole ra okanmaike ea wane.” ");
INSERT INTO ons_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilat eŋe don iwa rau detongi paki zok manerop kaetkake. ");
INSERT INTO ons_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Paki eŋe koso matkoto zinge waket Yesu qesonka rake, “Ge deoŋine sarikone?” Ŋo Yesu eŋe don mane mi mainge olatke. ");
INSERT INTO ons_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatŋo olale rake, “Ge mi nolasikene me? Detmaine, na siwot ganbe arikenane, so rakok ganbe kibeŋ qabego gekuwi okorake nane zonom weneŋ kutno pamaike.” ");
INSERT INTO ons_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesuŋo mainge olatke, “Ge zonom yewa weku, yemo onoka wane Anutuŋo gingane na maket bira nanmaine, ea wane ŋei waom maŋo na neuki paki, geŋane meto bira nanike, eŋane sotino yemo zok suaine.” ");
INSERT INTO ons_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilat eŋe don iwa detki paki numa mane maratka Yesu siwotkayakane okange. Ŋo Yuda ŋei eŋe mo qazom okane mainge rakoi, “Ge ŋei yewa siwot kanom ariakeo, yemo ge Sise wane kimaine mi gekene! Ŋei mane eŋe na ŋei waom rayake, eŋe Sisa wane ŋabaine!” ");
INSERT INTO ons_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilat eŋe don iwa korop detwareki paki, Yesu ma qeinat waketke. Paki ket don wano wanok wane kito met met mane eŋetne “Wesi Surawet” yewao metke, Hebru eŋane dongo eŋetne “Gabata.” ");
INSERT INTO ons_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kepe deine mo oŋabango okaniakane okange qaekimo Yuda ŋei eŋe Loloŋon Loloŋon Peada mesikei. Pilatŋo Yuda ŋei edane rake, “Iwa ŋinane Ŋei Waom!” ");
INSERT INTO ons_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Eŋe qazom manbi paki mainge rakoi, “Eŋe qenom seukkep! Eŋe qenom seukkep! Eŋe kibeŋ qabego biriŋŋo rasukanom!” Pilatŋo qeson one rake, “Ŋine ŋei waomŋine noŋo kibeŋ qabego biriŋŋo rasu kakalane ŋunmaike?” Pris ŋetne eŋe mainge rakoi, “Ŋene ŋei waomze weku gemaike, yemo Sisa!” ");
INSERT INTO ons_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pakiso Pilat eŋe Yesu kibeŋ qabego qekei wane eŋane meteeno birakake. ");
INSERT INTO ons_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Eso eŋe Yesu mau paki, warekau erinat waket more, eŋine kibeŋ qabe tewekke, paki ari kepe mane, eŋetne “Lewe Setne”, yewa lotkekoi, Hebru eŋane dongo “Golgota.” ");
INSERT INTO ons_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yewa eŋe kibeŋ qabego rasukakoi paki, eŋe yale waka ŋei etke kibeŋ qabeŋo weneŋ rasuotkoi, mane nat, mane nat, ŋo Yesu eŋe keuetno. ");
INSERT INTO ons_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatŋo don mane iwa yale dapore desikei wane qeki paki, kibeŋ qabego rasuki okorake, “Yesu Nazaret matko ŋine, Yuda eŋane ŋei waom.” ");
INSERT INTO ons_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yuda ŋei loutneŋo don yewa dapore det okangoi, onoka wane Yesu kibeŋ qabego qekoi, kepe yewa yemo mat suainane osino pakane, eŋe yale okangoi. Don qeke yewa yemo Hebru dongo, Latin so Grik dongo. ");
INSERT INTO ons_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yuda ŋei ŋetne eŋe Pilat olale rakoi, “‘Yuda eŋane Ŋei Waom’ yale mi qenom, ge iwa yale qenom, ‘Ŋei iwa eŋe rake, na Yuda eŋane ŋei waom.’” ");
INSERT INTO ons_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatŋo mainge rake, “Na don mo qile, wane siluŋ don yewaŋoka payake.” ");
INSERT INTO ons_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kawali ŋei eŋe Yesu kibeŋ qabego qeu paki, ŋadino eŋe takotine ma more, mapokeu sisine etke so etke okange, kawali ŋei eŋe weku weku makoi, eŋe takot suaine lap lap wekuŋo mamaine, samapine midaine ea yaleka makoi. ");
INSERT INTO ons_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Pakiso kawali ŋei eŋe auye rakoi, “Ŋene takotine suaine iwa misuk kito barakkene, ŋene wezu qezem paki kaŋem, eŋe kaŋem maŋo mayake.” Masi iwa yemo Anutu wane papiao don mane iwa yale pamaike, ea wele okaniakane yale wakonge, “Eŋe naŋane sola qekatne damo qe ama nagukoi so naŋane takotne suaine yewa wane wezu qekoi.” Eso kawali ŋei eŋe iwa yale okangoi. ");
INSERT INTO ons_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu wane kibeŋ qabeŋ osino okorakoi yemo Yesu eŋine nagaine, qaine, Maria, Kelopas ŋanomine, so Maria Magdalena. ");
INSERT INTO ons_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu eŋe eŋine nagaine so medeune eŋaneka simile kamageke, yewa okorakoik paki, Yesuŋo nagaine olale rake, “Ŋerep, iwa geŋane giponŋone.” ");
INSERT INTO ons_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Paki koso medepine olale rake, “Iwa geŋane nagaŋone.” Naso yewaoka medepine eŋe Maria ma ari eŋine matko biraka more warekake. ");
INSERT INTO ons_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu eŋe mo detke, ukude wamo urata kine kine mo korop qoe waremaike, eso Anutu wane papiao don mane pamaike, ea wele okaniakane Yesuŋo rake, “Na doku wane seukmaile.” ");
INSERT INTO ons_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lase mane ea metke, kotine wain lewine ketkeleŋo watke metke, eŋe wain doku yewa lap lapŋo qe muruge more, eki qogino piseu paki, ma wie piino kitokoi. ");
INSERT INTO ons_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu eŋe wain yewa neki paki rake, “Mo qoemaike!” Yale rakiso, ebine qasieki so seukke. ");
INSERT INTO ons_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pakiso Yuda ŋei eŋe Pilatŋo detongi, ŋeiwa kibeŋ qabego engukoi, eŋane kieene rutupkeu paki, kibeŋ qabego ŋine makok one kesikei wane olatkoi, eŋe yewa okangoi, yemo onoka wane ea nagapko, eso yalinane eŋe pareŋene yewa Peadao taboŋ met met nasoo, kibeŋ qabego okorakei wane mi onge. Peada naso yewa mo naso koboboine. ");
INSERT INTO ons_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eso kawali ŋei eŋe ari more, ŋeiwa mane wane alakane kine rutupkekoi, pakiso koso ŋeiwa mane Yesurop weneŋ etkukoi, eŋane kine rutupkekoi. ");
INSERT INTO ons_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Paki eŋe Yesu wano sari kakoi, eŋe mo ikopka seukke, ea wane eŋe kine mi rutupkekoi. ");
INSERT INTO ons_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kawali ŋei maneŋo bozamineŋo Yesu wane ŋorok ŋorokino qebarakkiso yewaoka weŋem so doku qake saketke. ");
INSERT INTO ons_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ŋei mane masi iwa kaki wakonge, oŋo don iwa detluke ra wakonmaikane, ŋine yale waka detluke maine malip kaikei, eŋe don rake yemo welekatne, so eŋe detmaike, eŋe don wele ra okanmaike. ");
INSERT INTO ons_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Masi iwa wakonge, yemo Anutu wane papiao don mane iwa yale pamaike, ea wele okaniakane wakonge, “Eŋane setne weku mane baŋ mi rutupkekei.” ");
INSERT INTO ons_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Eso Anutu wane papiao don mane iwa yale weneŋ ramaike, “Ŋei ŋerep eŋe potpi waki, ŋeiwa ŋorok ŋorokine qe barakkoi, eŋe baŋ kaikei.” ");
INSERT INTO ons_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yewa wane ŋadino Yosep, Arimatea matko ŋine, oŋo Pilat wano ari Yesu wane pareŋine mayakane olatke. Yosep eŋe Yesu wane medep geke, ŋo eŋe didiwo mi geke, onoka wane eŋe Yuda ŋei ŋetne eŋane kaetkaki, siu siuko geke. Pilatŋo olale rake, Yesu wane pareŋine maine mayake, eso Yosep eŋe ari Yesu wane pareŋine makoke ma arike. ");
INSERT INTO ons_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, eŋe mo alakanka goigo Yesu kayakane arike, oŋo Yosep korop weneŋ arikoik. Eŋe doku mane qoune teine, eki etke erane weŋem etneŋo maturagemamine, umatneine 30 kilogram, yewa weneŋ ma arike. ");
INSERT INTO ons_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ŋei etke ere Yesu pareŋine maut paki, lap lap libekaŋo doku qoune teine yewarop kawet kakoik. Yuda ŋei eŋe pareŋ duk onikei wane yalewa okane gekoi. ");
INSERT INTO ons_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu qeu seukke, kepe yewaoka eu mane pake, yewao kem mane musele mau kuneneŋ pake, yewao ŋei mane mi dukongoi. ");
INSERT INTO ons_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yuda eŋane peada taboŋ met naso mo bomileke, ea wane so kem eŋe ososop pake, yalinane ere Yesu wane pareŋine ea motkoik. ");
INSERT INTO ons_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sodao sakoropka, kepe mi qaelukke, eŋe panamanka paki, Maria Magdalena eŋe deŋesereo arike, paki kaki wesi kem aŋaine numa wake, waketko kito wongeu metke, yewa mo ma qe rodigeu arike. ");
INSERT INTO ons_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Eŋe yale kaki paki biririke, Saimon Petoro so Yesu medeune mane eŋaneka simile kamaŋke, erano ari etane rake, “Eŋe Waom mo kemgo ŋine ma arimi, paki mo ŋene mi detmaine, eŋe diawao ma ari birakemi!” ");
INSERT INTO ons_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yale etangiso, Petoro so medep kimaine ere mat qelige deŋesereo arikoik. ");
INSERT INTO ons_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ŋei etke eretnarek biririkkoik, ŋo medeppa mane oŋo yemo togogoleka biririke, Petoro biraka ari deŋesereo esatka lewine lotkeke. ");
INSERT INTO ons_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Paki eŋe kuge ket pore kaki, laplappa ea ka metke, ŋo eŋe kem koto mi waketke. ");
INSERT INTO ons_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Eŋane ŋadino Saimon Petoro arike, eŋe oŋo wa yemo koboboineka ariso, kem koto waketke. Waket kaki lap lappa kawet kakoi, eaka yewa pake, ");
INSERT INTO ons_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","so lap lap mane Yesu wane lewino kawetkakoi, yewa pake. Lap lap yewa yemo lap lap natne kawet kakoi, yewarop mi pake, midaka, eŋe oŋomka walipkawareso pake. ");
INSERT INTO ons_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pakiso medeune mane mikepka deŋesereo lotkeke, eŋe yaleka kem koto waketke, waket kaki paki detluke malip kake. ");
INSERT INTO ons_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ere Anutu wane papiao don mane iwa yale rake, yewa mi detkoik, “Eŋe seu seuoŋine wisikae wieake.” ");
INSERT INTO ons_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pakiso medewetkine ere zinge matko arikoik. ");
INSERT INTO ons_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria eŋe deŋesere wazaino aroke okorake. Arokma arokmaso kuge kem koto potki waketke. ");
INSERT INTO ons_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Eso pore otki aŋelo etke yewa metkoik, takot etne libekaŋo auwik paki, Yesu wane pareŋine pake yewa metkoik, mane lewine pake yewa metkiso, mane kine pake yewa metke. ");
INSERT INTO ons_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ere qesonka rakoik, “Ŋerep, ge onoka wane arokmaine.” Eŋe etane rake, “Eŋe naŋane Waom mo ma arimi, paki mo na mi detmaile, eŋe diao ma ari birakemi!” ");
INSERT INTO ons_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maria eŋe don iwa raki paki, zinge pore kaki Yesu yewa okorake, ŋo eŋe Yesuŋo okorake, ea mo mi detke. ");
INSERT INTO ons_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesuŋo qesonka rake, “Ŋerep, ge onoka wane aroke gemaine? Ge maŋane zuaŋka gemaine?” Ŋerep eŋe wetke rake, eŋe eu ware wareŋo mane, raki paki mo qesonka rake, “Suaine, goŋo ma arineo, yemo ma ari diao birakene, nolatnom detpe paki mo baŋ ari mawe.” ");
INSERT INTO ons_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesuŋo olale rake, “Maria!” Eŋe zinge Yesu wanoken ari Hebru dongo rake, “Raboni!” Kine ea “Kito ŋebo ŋebon.” ");
INSERT INTO ons_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesuŋo olale rake, “Solano misuk neukene, onoka wane na zinge Magak wano mane mi wele, ea wane. Ŋo naŋane kimakopne eŋano arinom paki, naŋane edannom, na mo zinge eŋano wamaile, eŋe naŋane Magane so ŋinane Magaŋine, naŋane Anutu.” ");
INSERT INTO ons_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Eso Maria Magdalena eŋe ari Waom marat kaki don iwa olatke, ea wane dokoine edange. ");
INSERT INTO ons_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Soda rarap yewao Yesu dokoine eŋe wekuenoka ari qeturage more, mat mane wane kotino wa madet togole mau kiki metkoi, onoka wane eŋe Yuda ŋei ŋetne eŋane kaet ongi, yale okangoi. Pakiso Yesu eŋe sariki paki keueno okora edane rake, “Peamŋo ŋinano payake.” ");
INSERT INTO ons_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Don iwa raki paki, ea wane ŋadino meteretkine so ŋorok ŋorokine ea sikanonge. Paki dokoine eŋe Waom kau paki, oi bakomŋo kotoene watkeke. ");
INSERT INTO ons_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Pakiso Yesu eŋe koso manerop edane rake, “Peamŋo ŋinano payake, Magakŋo na talenange, eso noŋo ŋine yaleka tale ŋunmaile.” ");
INSERT INTO ons_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Eŋe don iwa raki paki, asuine puangi kotoeno ketki rake, “Ŋine Asu Koboboine mau. ");
INSERT INTO ons_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ŋine ŋei eŋane borikineene ra mataliu, eŋe mo siuke eboniake, ŋo mi ra matalikeiwo, eŋe pa eboniake.” ");
INSERT INTO ons_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Dokoine 12 eŋano ŋine mane Tomas, eŋetine mane Aitiksipo, eŋe eŋerop mi metki, Yesu eŋe wakononge. ");
INSERT INTO ons_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Eso dokoine natne eŋe Tomas olale rakoi, “Ŋene Waom mo kene!” Tomasŋo edane rake, “Na deneŋo biriŋ lopotne meteretkino mi kaikale, so zolipneŋo lopot yewa mi uakakale, so metene ŋorok ŋorokino mi ma desikaleo, na baŋ mi malip kaikale.” ");
INSERT INTO ons_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kaiwe mama sewen(7) qoeki ŋadino soda mane, Yesu dokoine eŋe koso sari mat koto lewage metkoi, eso yewao wamo Tomas weneŋ metkoi. Eŋe madet togole kitokoi, ŋo siluŋ Yesu eŋe sariki paki, keueno okora more rake, “Peamŋo ŋinano payake.” ");
INSERT INTO ons_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pakiso Tomas olale rake, “Zolipŋone iwa motnom paki, naŋane mete retkene kanom paki, meteŋone bira more ŋorok ŋorokno motnom, wetŋone etkeka yewa qeligenom paki, malip nannom!” ");
INSERT INTO ons_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas olale rake, “Naŋane Waomne so naŋane Anutune!” ");
INSERT INTO ons_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesuŋo olale rake, “Ge malip nanmaine, yemo onoka wane mida, yemo ge mo nanmaine, ea wane me? Ŋei ŋerep eŋe mi nanbi paki, malipnan okanmami, eŋe wetpese desikei!” ");
INSERT INTO ons_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu eŋe urata togogole loutne natne dokoine ŋenane kaitzo ma okange, yewa buk iwa wane kotino mi qewarekole. ");
INSERT INTO ons_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Qekole, iwa korop yemo ŋine Yesu eŋe Mesia, eŋe Anutuŋo ŋei ŋerewekoune borikino ŋine ebuyakane birakaki sarike, eŋe Anutu wane Gipole, ŋine don iwa maine detluk kaikei, paki malipkakei ŋine ea wane ra more, ŋine maine eŋine eŋetko gege togon marat kaikei. ");
INSERT INTO ons_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Iwa wane ŋadino Yesu eŋe koso atak mane Galili Namuŋ osino dokoine wakon onge. Eŋe iwa yale okange. ");
INSERT INTO ons_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Petoro, Tomas, eŋetine mane Aitiksipo, Nataniel, eŋe weku Kana matko, Galili kepeo ŋine, Zebedi wane gipoletkine, so Yesu medewetkine etke eŋe korop metkoi. ");
INSERT INTO ons_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Petoroŋo natne edane rake, “Na zawon tebakalane arimaile.” Natne eŋe rakoi, “Ŋene baŋ gerop weneŋ arikene.” Eso eŋe mo ea ariu paki seki kutno wawarekoi, ŋo ruo yewa korop eŋe kine kinemde mane mi marat kakoi. ");
INSERT INTO ons_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kepe deine pintike waki waki yewaka kau, Yesu eŋe doku mezeno okorake. Ŋo dokoine eŋe Yesuŋo okoramaike, ea mo mi detkoi. ");
INSERT INTO ons_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Pakiso eŋe edane rake, “Medep, dokone, ŋine zawon mane mo ebuwi me?” Eŋe mainge rakoi, “Midakaka, manemde mane mi mene.” ");
INSERT INTO ons_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Eŋe edane rake, “Kamaga ŋine seki wazaine wongoken birau ketkep, ŋine yewaoken zawon natne baŋ maine marat kaikei.” Eso eŋe kamaga birau yewaka ketki warageu, seki osino maine mi sarike, so eŋe mau sekiwo kesiakane zok manerop qekake, onoka wane, eŋe zawon zok loutne manerop ebukoi, ea wane umareke. ");
INSERT INTO ons_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesu eŋe medep mane wane siminka okan mageke, oŋo Petoro iwa yale olatke, “Iwa yemo Waom oŋom!” Saimon Petoro eŋe takotine kito qoke more, ge urata make paki, baŋ eŋe don yalewa detke, yewa mo Waom oŋom. Eŋe mo yale takotine biraki ketki sontake namugo rasu more, logone gemage sa weko tagan weti lotkeke. ");
INSERT INTO ons_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Dokoine natne edo wamo seki woka kamaga zawon watke pake, yewa warage ari qalakko wakoi. Eŋe togolo ŋine kiwetko eamo kiroine mi gekoi, eŋe 100 mita, ea wane rokopka gekoi. ");
INSERT INTO ons_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wane eŋe qalakko ketpi paki kau gerep sigitne mane yewa zawon weneŋ kutno ze pake, so bret natne weneŋ. ");
INSERT INTO ons_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesuŋo edane rake, “Ŋine zawon yewa ukude ebumi, yewa ŋine natne iwa ma sariu.” ");
INSERT INTO ons_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon Petoro eŋe seki kutno wake paki, kamaga waraŋgi saki, zawon suaine watke pake yewarop qalakko maki ketke. Zawon korop yewa 153. Yewa eŋe loutne ŋo siluŋ kamaga yewa mi toeke. ");
INSERT INTO ons_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Paki Yesuŋo yale rake, “Ŋine sari neu.” Dokoine eŋe mane mi qesonka rakoi, “Ge ma?” Onoka wane eŋe kaetonge, ŋo maneŋo mane mi qesonka rake, ge ma? Eŋe mo detkoi, eŋe Waom. ");
INSERT INTO ons_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Eso Yesu eŋe kere biraki ketki, bret mane maki paki ebonge, eŋe zawon yale waka maki paki ebonge. ");
INSERT INTO ons_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iwa yemo seu seuoŋine wisikae wieki paki, ea wane ŋadino dokoine oŋom atak karewe wakononge. ");
INSERT INTO ons_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yesu eŋine so dokoine ŋara neu qoeki, ŋadino Yesuŋo Saimon Petoro olale rake, “Saimon, Yohane gipole, ge iwa eŋane simileene ea yuane more, wetŋone so simileŋoneŋo naŋane zok okan ganmaike me?” Saimon Petoroŋo mainge rake, “O, Waom, ge detmaine, na geŋane okan nanmaike.” Yesuŋo olale rake, “Ge lamakopne medeune ware onikene.” ");
INSERT INTO ons_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Atak etke Yesuŋo koso olale rake, “Saimon, Yohane gipole, ge wetŋoneŋo naŋane ganmaike?” Saimon Petoroŋo mainge rake, “O, Waom, ge detmaine, na wetneŋo geŋane nanmaike.” Yesuŋo olale rake, “Ge lamakopne wareonikene.” ");
INSERT INTO ons_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Atak karewe Yesuŋo koso rake, “Saimon, Yohane wane gipole, ge wetŋoneŋo naŋane ganmaike?” Petoro eŋe wetne borike, so dere umareke, onoka wane eŋe Yesuŋo atak karewe qesonka rake, “Ge naŋane ganmaike?” Eso Petoro eŋe mainge rake, “Waom, ge kine kine korop det waremaine, so ge detmaine, na geŋane nanmaike!” Rakiso Yesuŋo olatke, “Ge lamakopne ware onikene. ");
INSERT INTO ons_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Na welekatne golatpe detnom, ge qaluwit gekone yewao letŋone ramu gekone paki, diawao arikenane gangi arimaŋkone, ŋo baŋ ŋei sele okanikene, naso yewao yemo ge baŋ meteretkeŋone yewa birakene paki, mo ŋei maneŋo letŋone ramu gane more, geu numa mi arikenane wetkekene, yewa ariake.” ");
INSERT INTO ons_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu eŋe don iwa rake, yemo Petoro eŋe seu seu numa dale oken seukeake paki, Anutu eŋet biŋekinane so qeli ewe zonom so qelaŋan ma wakoniake, ea wane don iwa naŋengo more rake. Pakiso olatke, “Ŋadeno sari modat nannom!” ");
INSERT INTO ons_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petoro eŋe zinge ŋadino pore kaki, Yesu medepine mane arike, Yesu eŋe medep eŋane manerop simin kamaŋke. Medep weku yewa oŋo ŋara nekoi, yewao Yesu wane osino weneŋ usumka mere qesonka rake, “Waom, ŋei maŋo siron qeki geukei?” ");
INSERT INTO ons_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petoro eŋe medep ea kaki paki, Yesu qesonka rake, “Waom, ŋei iwa wane mane daleka?” ");
INSERT INTO ons_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Raki Yesuŋo mainge olatke, “Ŋo siluŋ eŋe paki, na koso zinge sarikalane naniakeo, ge daleo wane ramaine? Ŋadeno sari mogat nannom!” ");
INSERT INTO ons_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Eso don yewaŋo Yesu magukoune eŋano iwa yale rokopke arike, medep iwa eŋe baŋ mi seukeake, ŋo siluŋ Yesuŋo eŋe mi seukeake yale mi rake, eŋe rake, “Ŋo siluŋ eŋe geki, na koso zinge sarikalane naniakeo, yemo ge daleo wane ramaine?” ");
INSERT INTO ons_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Medep yewa oŋo don iwa korop ra wakonwareke, medep weku oŋoka don iwa yaleka ge wareke. Eso ŋene detlukmaine, eŋe don rake, yewa don wele. ");
INSERT INTO ons_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iwa, yemo kine kine natne korop yewa Yesuŋo okan wareke. Yewa eŋe korop papiao bonep bonep qekoi ra, yemo na yale wetkemaile, kepe baŋem eŋe buk yewa korop mi maurap. ");
INSERT INTO ons_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Thiopilus, na papia alakan qe gingole, ea mo Yesuŋo urataine kiekki paki, urata kine kine korop make, so miti don kito edange, ea wane don kisiine okan gangole. ");
INSERT INTO ons_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Yesu eŋe urataine kieke ma ari mageki, nasoine bomileki Asu Koboboineŋo talekaki, aposolo koune ebuke, eŋe don zonomine qoi qoine urata ŋei koune edane ebon wareke, qoeki Anutuŋo qeliwo ma wake, don kisi yewa ma korop qe gin warekole. ");
INSERT INTO ons_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Eŋe wikile dere ari mage seukki paki koso wisikae wie more urata ŋeikoune aposolo, edo kineine ka more Yesu eŋe welekatne wisikae wieke, yale detlukkaikei wane eŋe kaiwe 40 wakon ongi kakoi, qoekiso eŋe Anutu wane qeli ewe zonominane kine ra qelaŋane edange. ");
INSERT INTO ons_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pakiso eŋe wekuoka lewage metpi Yesuŋo edane rake, “Ŋine Yerusalem mat misuk qeliŋ kaikei, Magakŋo ŋinane kine kine mane biŋek qe rake, ea wane wele wakoniake wane ŋine yewa toma gekei. Na ea wane don kisi mo ŋidanbe detkoi. ");
INSERT INTO ons_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohane eŋe dokuka tauŋunge, ŋo noŋo yemo geu mi azongi Asu Koboboine qe wat ŋunikale.” ");
INSERT INTO ons_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Eso naso yewa aposolo eŋe wekuoka lewage mere Yesu qesonka rakoi, “Waom, ge naso dango zinge more, Israel ŋei ŋene qedugu ŋone more, ŋei waom okan ŋonnom, ŋene naso yewao koso kepe wane ŋei waomzerop okanikene me?” ");
INSERT INTO ons_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Raumo Yesuŋo edane rake, “Magakŋo eŋine zonominane naso so kaiwe urata mama kiroine me bamgo motke, eamo ŋido desikei wane rokop midaka. eamo eŋe oŋomka ware kamaike. ");
INSERT INTO ons_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ŋo ŋine yemo baŋ Asu Koboboineŋo kutŋino ket more zonom qewatke ŋibongi ŋine naŋane don kisi ra wakonikei. Pakimo ŋine baŋ Yerusalem matko ŋine kieke don kisine korop ra wakone edane more Yuda kepeo so Samaria kepeo korop ra edane ari mageu kepe sotakino qoewareake.” ");
INSERT INTO ons_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Eŋe don iwa raki qoeki, dokoine eŋe ka okorau, so eŋe yewaka qeliwo kere wake, pakiso kezoŋŋo kawet kaki eŋe koso mi kakoi. ");
INSERT INTO ons_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesu eŋe wa ariki, dokoine eŋe deene qeliwoka pore kalilipka okorau, yewaka ŋei etke takotetne libekaŋo eŋane osoeno wakone okorakoik. ");
INSERT INTO ons_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Paki eto edane rakoik, “Galili ŋei ŋine onoka wane deŋine qeliwoka pore okoramami? Ŋine ukude Yesu iwa kau, Anutuŋo qeliwo mawamaike, eŋe zinge sariake naso yewao, eŋe ukude kau qeliwo wamaike, eŋe ea wane rokopka koso zinge sariake.” ");
INSERT INTO ons_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pakiso aposolo eŋe Oliwa Bonagaoŋine zinge ket more, koso Yerusalem matko arikoi. Oliwa bonaga eamo Yerusalem mat wane osino, kilomita weku, sabat nasoo maine ari lotkekei ea wane rokop. ");
INSERT INTO ons_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Eŋe ari Yerusalem matko lotkeu paki, mat koto waket more urum kutno weti wa mere ge okan maŋkoi, yewao wakoi. Eŋane eŋetene yem iwa yale, Petoro, Yohane, Yakop so Andrea, Pilip so Tomas, Bartolomu so Mataio, Yakop Alpaiu wane gipole, Simon Zelot so Yudas, Yakop wane gipole. ");
INSERT INTO ons_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ŋei magu yewa edo wet weku okane more, meŋe meŋen urata tako rakot ma gekoi. Yale okanbi ŋerep natne, so Yesu nagaine Maria, so Yesu ŋolekoune, eŋe weneŋ qesiŋ onbi meŋe meŋen urata ma gekoi. ");
INSERT INTO ons_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Eso naso Yewao Petoroŋo kimakoune so ŋei ŋerep zaleene 120 eŋane keueno wie okora more don iwa yale edange, ");
INSERT INTO ons_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Kimakopne, Asu Koboineŋo Dawit wane wetne ma eweke more aŋaino don motki Yudas wane don mane mokaka rake, papiao pamaike, don ea wane wele wakoniakane Yudasŋo ŋaba iwenone more sikanongi, Yesu makoi. ");
INSERT INTO ons_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas eŋe alakan ŋenerop geke, eŋe ŋenane maguo ŋine, so miti urata iwa, eŋe weneŋ mayakane ra mange.” ");
INSERT INTO ons_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yudas eŋe siron qeki Yesu makoi, paki lewine wesi mangoi, sot wesi, yewaŋo kepe mane qoleke, eŋe yewao ari more, wouineŋo alakangi mapilage ket qeki, woune quluŋgi kaine korop qake saket wareke. ");
INSERT INTO ons_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Pakiso, Yerusalem matko ŋei ŋerep gekoi eŋe korop don kisi yewa dere more kepe ea wane eŋetine enŋene dongoka “Akeldame” orakoi, don ea wane kine yem, “Weŋem kepe.” ");
INSERT INTO ons_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ea wane kibi yemo Sam wane Papiao Dawitŋo iwa yale qeke. ‘Eŋane mat yewa maine yaup okorayake, ŋei maneŋo yewao misuk geake.’ Eso Sam maneo iwa yale ramaike, ‘Ŋei maneŋo eŋane tungo urata yewa mayake.’ ");
INSERT INTO ons_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Eso ea wane mo ŋene ŋei mane Waom Yesu eŋe ŋenerop geki, ge okanŋem ŋabaŋonmaŋkoi, so ŋene naso baŋem eŋerop ari sari okane gekone, ŋei magu yewa ŋenze keuzo ŋine mane ma wakonka birakaŋem. ");
INSERT INTO ons_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","So alakan mo Yohaneŋo ŋei ŋerep doku tau one ge samaŋki, koso Yesuŋo doku yale waka tau more urata kiekke. Paki ma ge sari mageki ukude kaiwe iwa okanmaike, so Anutuŋo Yesu ŋenanoŋine koso ma more qeliwo mawake, ŋei yaline keuzo ŋine mane kaŋem paki, ma wakonka birakaŋem, eŋe ŋene qesiŋŋongi urata ma more, Yesu seuke more wisikae wieke, ea wane sigi maep yewa weneŋ ŋenzarek ra qelaŋanikene.” ");
INSERT INTO ons_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Petoro eŋe yale rakiso eŋe ŋei etke ma wakonotkoi. Mane Yosep, eŋe Basabas ramami, so eŋetine mane Yustus. so ŋei mane yemo Matias. ");
INSERT INTO ons_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ma wakon ore more eŋe yewaka meŋenka rakoi, “O Waom, ge ŋei ŋerep eŋane kotoenane kine det luk waremaine. Ŋei etke iwa erano ŋine mane ma wesakka more ma wakonkamaine, ea sikanŋonnom kaŋem. ");
INSERT INTO ons_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Oŋo Yudas wane tungo aposolo urata iwa takotke ŋenerop mageyake. Yudas eŋe urata iwa mo qelige eŋe eŋine numaine maneo arike.” ");
INSERT INTO ons_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Eŋe yale ramore wezu qeu Matias wakonge. Pakiso eŋe ma wakonka birakau aposolo 11 eŋano takotkeke. ");
INSERT INTO ons_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Penticost peada naso suaine mo bomileki, ŋei ŋerep Yesu malipka lukkoi, eŋine magukoune eŋe korop sari, mat maneo waket qeturage metkoi. ");
INSERT INTO ons_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Meregeu so yewaka qeliwo ŋine momo togogole puangi, ukatne suaine wakon okanmaike, ea wane rokop weti ŋine aroke ketke. Ket more sari mat metkoi, kotine yewa korop watkeke. ");
INSERT INTO ons_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pakiso eŋe kau gerep bolamine yale lawe tiŋ tuŋ matokki toe ari ŋei ŋerep kuteno kuteno kito more lawe arike. ");
INSERT INTO ons_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Eso eŋe korop Asu Koboboineŋo kotoeno ket ŋei ŋerep yewa qe watongi paki ma ewek ongi aŋaene ewekki kieke don kine kine pa arimaike, ea Asu Koboboineŋo welaine welaine weteeno motki, eŋe yewaoka don ra edangoi. ");
INSERT INTO ons_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Naso yewao Anutu meŋenkakei wane Yuda ŋei miti dereret natne korop eŋe kepe baŋem ea ŋine sari qeqe lewa lewaŋ okangei wane qeturage Yerusalem matko gekoi. ");
INSERT INTO ons_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Eso eŋe ukat suaine yewa wakongi dere more ŋei ŋerep zok maneropŋo sari lewage more oŋaene qaeke. Pakimo detpi, aposolo magu edo kepe baŋem don kine kine pa arimaike, yewaoka ŋei weku weku eŋe enŋene donenoka ra edan okanbi, eŋe detkoi. ");
INSERT INTO ons_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Paki Yuda ŋei eŋe zok manerop welelepke more, dereret urata ma rakoi, “Ŋei ŋerep iwa don ramami, eŋe korop Galili ŋineka! ");
INSERT INTO ons_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Daleo wane, ŋene koropŋo det onŋem, eŋe koropŋo ŋenze dongoka koboboine welaine welaine, ŋene ŋedom welaineŋo rarainane, rokop ra ŋedanbi, ŋene welaineŋo detmaine? ");
INSERT INTO ons_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ŋene iwamo Patiaŋine, Mediaŋine, so Elam ŋine, Mesopotamiaŋine, Yudaŋine, so Kapadosiaŋine, Pontusŋine, so Asiaŋine, ");
INSERT INTO ons_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prigian ŋine, so Pampilia ŋine, Ezipti ŋine, so Libia nat parom Sairini osino ŋine, natne ŋene Roman ŋeiŋo iwa kulit sari gemaine. ");
INSERT INTO ons_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ŋene Yuda ŋei, mat welaine so lobo sari sarine, Yuda ŋei eŋane tanik manik ma gemaine. So natne ŋene Kerataŋine, so Arabiaŋine. Ŋene yalewaŋo ge more, donzane rokopko Anutu masiine kakapa meke ea wane don kisiine ra qelaŋanbi detmaine!” ");
INSERT INTO ons_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ŋei eŋe yale ramore oŋaene qaeki, dere qeka okane au rakoi, “Iwa onokaka masi?” ");
INSERT INTO ons_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ŋo natne eŋe aposolo don masirakinerop okan one more edane rakoi, “Eŋe wain musele loutne neu paki qelaŋ qe more don yaup qazaŋ ramami.” ");
INSERT INTO ons_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pakiso Petoroŋo wie more, kimakoune aposolo elewen(11), eŋerop okora togoleka boka ŋei ŋerep magu yewa korop ra qelaŋane edane rake, “Yuda ŋei kimakopne, so Yerusalem gemami, so ŋei lobo, ŋine korop ketŋine motpi na masi iwa wakonmaike ea wane kine ra qelaŋane ŋidanbe detpi. ");
INSERT INTO ons_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ŋine dere ramami, ŋei iwa eŋe doku ne more qelaŋ qemami, Yale midaka. Kepe yekuat 9 kilok sako rokop okanmaike. ");
INSERT INTO ons_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ŋo masi iwa yemo propet Yoelŋo don mane mo qeke, ea wane wele wakonmaike. ");
INSERT INTO ons_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Anutuŋo iwa yale ramaike, gemage kepe wane naso dagoine qoe yakane okangi, na baŋ Asune ŋei ŋerep korop qe watŋun warekale. Ŋinane gipolekopŋine so borasokopŋine, eŋe baŋ naŋane don propet yale ra wakonikei, ŋo ŋei qaluwit kopŋine eŋe baŋ deene lotkeki kine kine kuneŋine kulu kulu yale kaikei, so ŋei sele eŋe baŋ kulu kaikei. ");
INSERT INTO ons_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","So, naso yewao Na Asunane zonom motpe ket more qelit ŋeikopne wikile urata ma okanmami, ŋei so ŋerep, ma ewek ongi, eŋe baŋ propet yale don ra qelaŋanikei. ");
INSERT INTO ons_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pakimo na masi kuneŋine so tanik mane qeli kebago mawe wakoniake, so qela kepeo masi natne oŋa qaqaine wakoniake. Yewao weŋem, so gerep, so kopu umatne sayake. ");
INSERT INTO ons_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Eso kepe deine eŋe panamaniake, so meso eŋe weŋe weŋem qe more weŋemka okaniake. Pakimo ŋado Waom wane naso maep bomileake. Naso maepine eamo qelaŋane zok manerop kakapa suaine. ");
INSERT INTO ons_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Eso naso yewao ŋei ŋerep eŋe Waom wane eŋetine ora malipka newanka gemami, eŋe borikinane ŋetne ŋetnane kotino ŋine mapik oniake, so baŋ Waom oŋom ebuki, koso eŋine ŋei okane weku mane gekei.’ Yewa yemo propet don Yoelŋo mo ra wakonge ");
INSERT INTO ons_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel ŋei, na don iwa ŋidanbe ŋine ket more detpi, Yesu Nazaret matko ŋine eŋe Anutuŋo nabok okanka more, qesiŋkaki keuŋino ge more, zonomine kakapa yewaŋo masi so tanik manik kine kine de kune ŋine maki paki, Anutu wanoŋine ketke, ea wane kineine ma qelaŋangi ŋine korop kawarekoi. ");
INSERT INTO ons_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Eŋe Anutuŋo mokaka detki paki, don mo ra togoleka mange, ea wane rokopko ŋinane met birakaki paki, numa mangi, ŋine mau paki, masi kine kine korop okanka more, borikine mama eŋano birakau edo ma more kibeŋ qabego qeu seukke. ");
INSERT INTO ons_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ŋo Anutu ŋo yemo Yesu seu seuoŋine ma wirikkaki wisikae wieke paki, seu seu wane wikile qotkokoine eaŋine mainka more makokkake, onoka wane seu seuŋo eŋe maine mi ma qorokkake. ");
INSERT INTO ons_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ea wane Dawitŋo iwa yale Yesu wane ra qelaŋan don rake, ‘Na Waom kakole, eŋe naŋane kaitno naso baŋem ososop okora okanmaike Eŋe naŋane wonno okora okanmaike, ea wane kine kine maneŋo na maine mi mapap nangi qise more, kaet okangale. ");
INSERT INTO ons_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ea wane na qomne menaŋmaike, so na belakamneŋo bakom kitomaile. Na kepe ŋei, ŋo solaneŋo yale waka kine kine maine ea wane tomaka more pa wie okaniake. ");
INSERT INTO ons_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ge asu oŋa oŋane mi qikka qeliŋkanom ŋei seu seune eŋane kepeo payake, me ge Ŋeiŋone Koboboine Wekumane eŋe mi qeliŋ kanom gotosiake. ");
INSERT INTO ons_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ge wisika gege wane numa yewa na mo sikan nangone, wane ge baŋ narop genom na geŋane kaitŋono oi bakom zok manerop okanikale.’ Dawitŋo yale rake. ");
INSERT INTO ons_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kimakopne, na ŋaboze Dawit, ŋenze ware ware suaine, eŋane kine ra wakone ŋidanbe. Eŋe mo seukki dukkakoi, deŋesereine ŋenze keuzo mere sa gemageki ukude naso iwa ukude okanmaike. ");
INSERT INTO ons_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Eŋe propet geke so eŋe Anutuŋo don mane iwa yale ratogole olatke yewa detke, ‘Dawit, na geŋane ŋabokopŋone eŋano ŋine mane baŋ ma birakawe oŋo geŋane tungo ŋei Waom metmet yewa ma more mesiake.’ ");
INSERT INTO ons_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawit eŋe Anutuŋo kine kine daleo mayake, yewa mo kake, pakiso eŋe Kristo wisikae wie wieinane don iwa yale rake, ‘Anutu eŋe pareŋine mi qeliŋkaki, ŋei seu seune natne yale kepo pa more gotosiake.’ ");
INSERT INTO ons_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Pakimo Yesu eŋe Anutuŋo ma wirik kaki, wisikae wieki, ŋene korop weneŋ deze weleŋo kauluk kakone. Eso ŋene yewa wane kisi ine ramaine. ");
INSERT INTO ons_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Eŋe mo zinge wa more, Anutu wane wonino metmaike. Eŋe Magakŋo Asu Koboboine mo biŋek qeke, yewa sunka mangi, Magak wane meto ŋine Asu Koboboine ma more, qe wat ŋongi, ŋine mo iwa kineine kamami, so detmami. ");
INSERT INTO ons_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Onoka wane, Dawit eŋe oŋom qeliwo mi wake, eŋe iwa yaleka yemo rake, ‘Waomŋo naŋane Waom olale rake, “Ge iwa naŋane wazano wonno metnom, ");
INSERT INTO ons_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Met magenom na ŋabakopŋone baŋ ebu ket biraonbe, geŋane kietabe ŋonane bano gesoke togole togoleŋone okane waket mesikei.” ’ ");
INSERT INTO ons_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ea wane Israel ŋei, ŋene korop iwa yale detluk warekene, ŋine Yesu ma more kibeŋ qabego qeu seukke, pakimo Anutuŋo maki paki Waom so Kristo birakaki gemaike.” Petoroŋo yalewa ra edange. ");
INSERT INTO ons_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ŋei ŋerep eŋe don yewa detpi korop qomene kitopokke. Pakiso Petoro so aposolo natne ra qeson okane edane rakoi, “Kimakop, ŋene daleo okanŋem menageake?” ");
INSERT INTO ons_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Rauso, Petoroŋo edane rake, “Ŋine ŋei ŋerep bonep bonep wetŋine maingeu paki, Yesu Kristo wane biŋek okane more, eŋane eŋetko miti doku tauwi mo, Anutuŋo sotŋine yewa qelige ŋibone more, mataliki siukwareake. Pakimo, Anutu wano ŋine bakom, Asu Koboboine ŋiboniakane biŋek qeke, ea ŋibongi maikei. ");
INSERT INTO ons_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Anutu eŋe mokaka Asu Koboboine, yewa ŋiboniakane mo rake, ŋo ŋine ŋinŋine so ŋosa ŋabokopŋine, so ŋei ŋerep natne suaine korop ŋine abaran eri eri zok ge sarimami, ŋine korop Waomze Anutuŋo ŋidora newan ŋungi eŋino sariu Asu Koboboine ŋiboniakane biŋek yemo mo qe ŋibonge.” ");
INSERT INTO ons_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petoro eŋe yale ra more don natne loutne edane qebin mabin okanonge, paki girem don edane rake, “Ŋine ŋei ŋerep matali qetalienerop eŋane maguo ŋine kakakone zinge sariu ŋibuyake.” ");
INSERT INTO ons_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pakiso, ŋei ŋerep eŋe Petoro wane miti don dere detluke malipkau paki, kaiwe naso yewaoka ŋei ŋerep 3 tausen miti doku tauonbi, Yesu wane magu eŋano takotkekoi. ");
INSERT INTO ons_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eŋe sorin borin okane aposolo eŋane don detkoi, paki kito qesiŋ okane weteneŋo malip nagu more ruo ŋara nene weku okane gekoi. So wetene qeturage more meŋe meŋen urata ma gekoi. ");
INSERT INTO ons_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pakimo, Anutuŋo aposolo qesuŋongi, eŋe masi kine kine loutne mau ka more oŋaene qaeki, ewe kito kito okane gekoi. ");
INSERT INTO ons_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pakiso, ŋei ŋerep loutneŋo Yesu malipkakoi, paki doku tau tau magu mali malip korop gekoi, eŋe weteneŋo malip nagu more aboŋ kine kineene korop owoeno pa ebongi magekoi. ");
INSERT INTO ons_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Eŋe kepeene so yeye kine kineene natne ŋei natne sunka ebonbi, eaŋo wesi kiare ebongi, kine kine wane zuage gemaŋkoi, rokop eŋe wesi yewa damo qe ebonmaŋkoi, paki yewaŋo ŋara doku qole ne okanmaŋkoi. ");
INSERT INTO ons_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Eŋe wet weku okane more kaiwe baŋem Bakom Urumgo lewage gekoi, so ruo ŋara yemo enŋene mateno maneo maneo lewage mere ne gekoi, paki solaoken ŋara ea yemo wetene ketkele paki, batneka mapoke bororom rokopko ne gekoi. ");
INSERT INTO ons_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Paki naso baŋem eŋe Anutu eŋetine ora mawakakoi, pakiso, ŋei ŋerep korop eŋe eŋane tanik manikene kau simileonge, eso Waom eŋe kaiwe baŋem ŋei ŋerep mali malipenerop ebu takoton mageki, zaleene kirowone manerop weti weti wake. ");
INSERT INTO ons_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kaiwe mane Petoro so Yohane ere kepe zinge(3 kilok) rarapko, meŋe meŋen naso okangi, Bakom Urumgo wakoik. ");
INSERT INTO ons_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pakimo ŋei mane kine bori worine nagaine kotino ŋine mo yaline wakonge, eŋe naso baŋem ma ari birakau, Bakom Urum wane madetine mane eŋetne “Madet Tasigaine,” yewa met mageke. Metki, ŋei ŋerep eŋe Bakom Urumgo wawa ketket okanbi, eŋe wesi aboŋ manikei wane ra meŋen okan one met maŋke. ");
INSERT INTO ons_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ŋei yewa eŋe otki, Petoro so Yohane ere Bakom Urumgo wakesikeik wane okanbik, eŋe kine kine natne manikeik wane qeson otke. ");
INSERT INTO ons_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Eso Petoro ŋo Yohane ere deetneŋo qoŋ qoŋ rora papapka okorakoik, pakimo, Petoroŋo olale rake, “Ge deŋone ŋere ŋotnom!” ");
INSERT INTO ons_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Rakiso, ŋei eŋe kine kine mane ninikeik ra more erano deine potke. ");
INSERT INTO ons_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pakimo, Petoroŋo olale rake, “Na wesi aboŋ mi pa ninmaike, ŋo na kine kine weku ma gemaile, iwa ginikale, yemo Jesu Kristo, Nazaret ŋine, na eŋane eŋetko golatmaile, Ge wie gesoke arinom.” ");
INSERT INTO ons_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yale ra olale more, metine wongoka ma qesiŋ kaki wieke, pakiso eaka ŋei yewa wane kie metine qeluetine ea koropka koliki menage more, togoleki maine wie okorake. ");
INSERT INTO ons_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Eso eŋe sontake wa more, ket kineŋo gesoke okora more lolike arike, pakiso, eŋe ererop Bakom Urum koto weneŋ ari waket more, Anutu bakomine kito eŋetine ora mawakake, so batne basi wasine okane more gesoke det okangi menaŋgi wet pese detke. ");
INSERT INTO ons_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ŋei ŋerep korop eŋe kau Anutu wane eŋetine ora mawaka bakomine kito more, eaka numa arike. ");
INSERT INTO ons_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Pakimo, eŋe mo detkakoi, “Ŋei iwa oŋoka Bakom Urum wane ‘Madet Tasigaino’ mere naso baŋem wesi aboŋ wane ra meŋen okane met mageke, oŋo mo iwa menaŋmaike.” Yale ra more oŋaene qaeki, welelepkekoi. ");
INSERT INTO ons_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Eso ŋei yewa eŋe Petoro so Yohane erano makatake more malilip otki, ŋei ŋerep eŋe one oŋaene qaeki, korop eŋano ari Bakom Urum kotine mane eŋetne, “Solomon Wane Touŋ,” ora okanmami, yewa biririke lewaŋgoi. ");
INSERT INTO ons_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Yale okanbi, Petoro eŋe one more ŋei ŋerep yewa edane rake, “Israel ŋei ŋine onoka wane iwa ka more oŋa ŋine qaemaike, pakimo, ŋine ramami, ŋere ŋetze zonomgo mate, ŋei iwa menaŋmaike, ŋine yale ramami me? Midakaka! ");
INSERT INTO ons_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham wane Anutu, Isak wane so Yakop wane Anutu, eŋe ŋenane sakon qerakopze eŋane Anutu, oŋo Qelit ŋeiine Yesu wane kibi so zonom qelaŋan ŋei iwa wane kutno ma wakongi, ŋine kamami. Ŋine yemo ŋei yewa qaesikkau paki, ma more ŋaba eŋane meteeno birakakoi. Pakimo, Pilat eŋe loloŋka more birakaki ariakane raki, ŋine eŋane kaitko qik kakoi. ");
INSERT INTO ons_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ŋine Anutu wane ŋei Koboboine so Maine Weku, mane yewa mogare iwenŋonge paki, ŋine eŋe qaisik kakoi so ŋadekkakoi paki, eŋane tungo ŋine Pilat boka olatpi, eŋe ŋei mane yewa, eŋe ŋei mane mo qeki seukki mulap urumgo birakaki metke, yewa seseka more siwotka ŋibonge. ");
INSERT INTO ons_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pakimo, ŋine Ŋei Maine, gege togon numao iwenŋonge, eŋe gege togon wane Ŋetne, yewa qeu seukke. Ŋo Anutuŋo yemo seu seuo ŋine ma wirik kaki wisikae wieke. Pakimo, ŋere ŋetom deseŋo kakote, ea wane eŋane don kisi iwa ra qelaŋanmaite. ");
INSERT INTO ons_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ŋere yemo Yesu Kristo malipka lukka more, detluk kamaite, ea wane ŋei iwa yemo Yesu wane zonom so eŋane eŋetŋo ŋei matko met met wawetine qoqoine, iwa zonom mangi togolemaike. Ŋere Yesu Kristo malipka more, eŋe detluk kamaite, ea wane ŋei iwa eŋe Yesu eŋetine detlukkaki, eŋane eŋetinane ra more, mali malipineŋo ŋei ŋerep korop ŋinane deŋino qesiŋka more maki menaŋmaike. ");
INSERT INTO ons_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Welekatne kimakop, na mo detmaile, ŋine so ŋetne kopŋine ŋine wet qelaŋŋinane mi detluke more, masi yewa Yesu wano okangoi. ");
INSERT INTO ons_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ŋo siluŋ ŋine yale okanbi mo, mokaka Anutu eŋe propet koune eŋane weteno don motki, dere ra qelaŋangoi, ea wane rokopko maki, wele wakonge. Paki Kristo eŋe baŋ wikile dere more seukke, wane ŋine don so numa yewa mo Anutu oŋom rake, rokop okanwarekoi. ");
INSERT INTO ons_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ea wane ŋine wetŋine maingeu paki dereret ŋine qotkoine, ea matalikei, so wetŋine maingeu, Anutuŋo baŋ koso borikine ŋine ea korop sauk wareake. ");
INSERT INTO ons_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Pakimo, yale okanbi, koso Waom wano zonom musele ŋine yewa maine ma wakone ŋiboniake, so Yesu eŋe Kristo ŋine, Anutuŋo mokaka ma wakonka biraka ŋibonge, eŋe talekaki ŋinano sariki, maine gege wane naso bomile ŋiboniake. ");
INSERT INTO ons_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iwa yemo Yesu eŋe qeliwo toma gema geki, Anutuŋo yeye kine kine musele korop ma wakon wareakane nasoine bomileake, mokaka Anutuŋo qelit ŋeikoune koboine, propet eŋane aŋaeno don motki ra qe okangoi, ea wane kop. ");
INSERT INTO ons_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moseŋo mo iwa yale rake, ‘Waom, ŋinane Anutuŋo na biranange, ea wane rokop ŋinŋine keu ŋino ŋine propet mane na yale ma birakaki, Anutu wane qelit ŋei okane mere more, don kine kine ra ŋidan okaniake. Yewa ŋine korop dere teweke okan warekei. ");
INSERT INTO ons_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ŋei mane eŋe propet yewaŋo don rayake, ea dere aŋaine mi tewekeake, yemo Anutu wane ŋei ŋerep magu Israel eŋane keuo ŋine mapokka more, eŋineka bira kayake, paki qeki seukeake.’ ");
INSERT INTO ons_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","So propet natne, Samuel so eŋane ŋadino propet natne wakone ge sarikoi, eŋe koropŋo Anutu wane don rakoi, so ukude naso iwao pamaike, ea wane done yaleka mo raso qe okan warekoi, ukude iwa mo wakone pamaike. ");
INSERT INTO ons_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","So ŋine propet gekoi, eŋane gipon boraso me ŋosa ŋabokopene, so Anutuŋo sakon qerakopŋine eŋerop tako rakot so ra rokop don ra mot okange, ea wane welakoune ŋine. Anutuŋo Abraham gorop tako rakot okane iwa yale olatke, ‘Na geŋane ŋosa ŋabokopŋone mosop onbe, mosop mayakatne yewaŋo kepe baŋem ŋei ŋerep korop rokop onwareake.’ ");
INSERT INTO ons_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Eso ea wane mo Anutu eŋe qelit ŋeiine ma wie birakaki, mikep ŋinano sari wakonge, ŋibuki ŋine korop weku weku gege mageŋine borikine yewa ŋadek kawareu mauluk ŋune more, mosop ŋuniakane birakaki sari wakonge.” ");
INSERT INTO ons_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petoro so Yohane ere ŋei ŋerep don yeka edane okorauk, pris so Bakom Urum wane tebe ŋei ware wareene so Sadusi ŋei eŋe erano sarikoi. ");
INSERT INTO ons_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Eŋe sot osi osi okangoi, yemo onoka wane mida, Petoro so Yohane ere ŋei ŋerep miti edane more Yesu eŋe seu seuo ŋine wisikae wieke, ea wane kine, so ŋei seu seune eŋe baŋ ge mage korop wisikae wie warekei, ea wane kine korop ra qelaŋane edan warekoik, ea wane eŋe erane detpi borike. ");
INSERT INTO ons_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pakiso eŋe epu lukore more, dongo biraotkoi, ŋo kepe mo qoekane mulap urumgo bira otpi pauk, kepe qaeke. ");
INSERT INTO ons_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ŋo Petoroŋo miti don edangi detkoi, eŋano ŋine ŋei ŋerep loutneŋo don yewa detluke malipka warekoi, ŋei ŋerep yewa eŋane zaleene 5 tausen. ");
INSERT INTO ons_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kepe qaeki, Yuda ŋei wawaine, ŋei ŋetne, so don ra rokop wane kine dereret ŋei, eŋe Yerusalem lewaŋgoi. ");
INSERT INTO ons_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pris suaine eŋetene Anas so Kaiapas, Yohane so Alekzander, so natne Pris Suaine eŋane magu, eŋe weneŋ korop lewaŋgoi. ");
INSERT INTO ons_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Paki rau, aposolo etke ere epu ari kaiteno biraotpi okorauk, so qeson ore rakoi, “Ŋire ma zonomgo kine kine yewa okanmamik? So ma eŋetko masi yewa mamamik?” ");
INSERT INTO ons_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pakiso, Petoro eŋe Asu Koboboineŋo kotino watkeki edane rake, “Yuda ŋei wawaine, so ŋei ŋetnekopze korop rawe detpi, ");
INSERT INTO ons_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ŋere ŋei mane kine boriworine iwa qesiŋka more mate menagike, ea wane ŋine iwa ŋere qeson ŋotmami, ŋei yewa eŋe daleo okane menage numa gegeine wakonike, ŋine ea wane kine desikei wane zok pidiŋ ŋotmami. ");
INSERT INTO ons_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ea wane yemo rawe ŋine so Israel magu korop detwareu, ŋei iwa ŋinane kait ŋino okoramaike, yemo Yesu Kristo Nazaret matko ŋine, eŋe ŋido kibeŋ qabego qeu seukke, pakimo, Anutuŋo ma wirik kaki, wisikae wieke, eŋane eŋetinane zonomŋo maki menagike. ");
INSERT INTO ons_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu eŋe weku, mokaka Dawitŋo Yesu wane ra more Anutu wane papiao iwa yale qeke, ‘Mat mama ŋei ŋine Yesu eŋe bosiŋ qotkoine ra qikkau, eaŋo qeinge more bosiŋ togogole okange okoramaike.’ ");
INSERT INTO ons_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Qesi qesiŋ yemo eŋano weku paki kamaine, kepe baŋem ea ŋine Anutuŋo eŋet kuneŋine mane mi ma wakone sikan ŋonmaike, oŋo koso ŋebuyakane. Miti don yemo ŋeiwo mi pamaike, me ŋei mane wane eŋetko lipaŋka more mena menaŋ eamo kepeo mi pamaike.” ");
INSERT INTO ons_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kaunsol eŋe otpi, Petoro so Yohane ere ŋei yauwine, ere kibi urumgo mi gekoik ŋo kaet etne midaine don togoleka ra qelaŋane edanbik, eŋe dere more ze qokonge, so ere Yesurop mo weneŋ gekoi, yewa eŋe mo detluk otkoi. ");
INSERT INTO ons_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","So ŋei solaine mauk menaŋge, numa gegeine wakonge, eŋe mo yewa ererop okoraki kakoi, ŋo siluŋ ea wane don turuŋine mainge etanikei wane numa zuaŋgoi. ");
INSERT INTO ons_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Zuage more, Petoro so Yohane ra otpi, ere Kaunsol urum qelige qeinat ketpik so eŋe enŋeneka don urata suaine zok auye more rakoi, ");
INSERT INTO ons_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ŋene ŋei etke iwa daleo okan osikene? Ere masi kine mane memik, ea wane don kisiineŋo mo Yerusalem ariki, ŋei ŋerep koropŋo detwaremami, ea ŋene maine mi motkekene. ");
INSERT INTO ons_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ŋo ge mage don yewaŋo sua ŋei ŋerep eŋano yau yaup ariakane, ŋene togoleka ra togole otŋem ere koso ŋei ŋerep natne Yesu wane eŋet mane mi ra qelaŋane edane arikeik.” ");
INSERT INTO ons_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Eŋe yale rau paki, koso etorau, ere urum koto wauk, eŋe Yesu wane don kisi mane mi ra qelaŋane edanikeik wane, so eŋet yewa ŋei ŋerep natne koso mi kito edanikeik wane ra togole otkoi. ");
INSERT INTO ons_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ŋo Petoro so Yohane eto yemo mainge edane rakoik, “Ŋine ŋidom ra detpi, ŋere ŋinane don tewekete paki, Waom wane don qeligete Waomŋo detki menageake me? ");
INSERT INTO ons_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Iwa yale wane, ŋere kine kine mayakatne mo wakongi, deseŋo kakote, so ketseŋo det warekote, yewa ma waluke ma gege eamo mi okanikete.” ");
INSERT INTO ons_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Paki, Kaunsol eŋe don togoleka etane more bira otpi arikoik, iwa yale wane, ŋei ŋerep eŋe masi wakonge, Waom bakomine kitokoi, ea wane etkukei wane numaine zuage more qeliŋgoi ");
INSERT INTO ons_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ŋei kine borikine Petoro ŋo Yohane eto mauk menaŋge, eŋe komaine mo 40 yuange. ");
INSERT INTO ons_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petoro ŋo Yohane ere zinge kimakopetne eŋano ari more pris suaine so ŋei ŋetne edo donba etangoi, yewa wane don kisi korop edan warekoik. ");
INSERT INTO ons_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pakiso, eŋe detwareu qoeki, wetene qeturage more, iwa yale rau paki, Waom meŋenkakoi, “O Waom, ge qeli so kepe so kiwet so yeye kine kine ea wane kotino pamaike, korop ma wakon warekone! ");
INSERT INTO ons_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Goŋo Asu Koboboine tale kanom oŋo ŋaboze Dawit, geŋane qelit ŋei, eŋane wetino don motki, iwa yale rake, ‘Qelaŋ ŋei eŋe onoka wane koto gerep zok okane gekoi, ŋei ŋerep eŋe onoka wane wet yau yaup motkoi? ");
INSERT INTO ons_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kepe baŋem ŋei waom eŋe mo aboŋene makoi, ware ware eŋe mo wekuoka qeturaŋgoi, Waom so Mesiaine ŋaba osikei wane.’ ");
INSERT INTO ons_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Welekatne, Herot so Potius Pilat ere mo mat suaine yewao qelaŋ ŋei so Israel ŋei ŋerep eŋerop qeturage more, Yesu geŋane qelit ŋei koboboine, ge Mesia bira kakone, eŋe ŋaba kakei wane lewaŋgoi. ");
INSERT INTO ons_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Eŋe qeturage lewaŋgoi, yemo ge mokaka geŋone zonomŋonane so wetŋonane don togonŋone ra togole motkone, wele ŋado wakoniakane, yewa korop ma wakon wareke. ");
INSERT INTO ons_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Waom, iwa yemo ge eŋane qom sua don gereunerop ramami, yewa dere ma papap kaikene, paki, qelit medewekopŋone ŋene qesiŋ ŋonnom togole more, don kisiŋone kaet midaine ra qelaŋanikene. ");
INSERT INTO ons_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Okanŋem, ge meteŋone ma wie more, zoma ŋei ŋerep ebunom menaŋgei, so masi kine kine togole korop qelit ŋeiŋone koboboine, Yesu wane eŋetko ma warekene.” ");
INSERT INTO ons_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yale ra meŋenkau qoeki, matpa lewage metkoi, yewa qiseke, pakiso, Asu Koboboineŋo ket more korop qe watone rokop ongi, Waom wane don kisi yewa kaet midaine togole more ra qelaŋane arikoi. ");
INSERT INTO ons_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Doku tau tau magu mali malip korop eŋe wetene so dereretene wekuku motpi paki gekoi, maneŋo kine kineine mane ea wane iwa nae bonepne yale mi ramaŋke, midakaka, eŋe yeye kine kineene bonep bonep yewa korop qeturaŋene pa ebongi, ma poke amanagu okane gekoi. ");
INSERT INTO ons_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Pakimo, aposolo eŋe Waom Yesu seu seuo ŋine wisikae wieke, ea wane don kisiine zonom gorop ra qelaŋane ariu, enŋene don so dereretene ea manerop sua ariki paki, Waomŋo doku tau tau magu yewa eŋane zok manerop siminkaki, qesiŋone more mauluk one mosoponge. ");
INSERT INTO ons_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Eŋane keueno ŋine ŋei maneŋo aboŋ kine kineine midaine ma zuaŋ mane mi okane geke. Ŋei natne kepe saienerop me matenerop, eŋe ŋei natne sunonbi, edo ea wane lewine wesi ebon okangoi. ");
INSERT INTO ons_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Pakimo, eŋe wesi yewa mainge ma sari aposolo ebon okangoi, eso aposolo edo wesi yewa mage more ŋei ŋerep yeye kine kine mane wane zuaŋgoi, yewa ma poke qesiŋone gekoi. ");
INSERT INTO ons_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Eso ŋei mane geke, eŋetine Yosep, aposolo eŋe Barnabas oramaŋkoi, ŋenze dongo, “ŋei wetze ma togole,” eŋe Lewi, Yuda wane magu maneo ŋine, Saiprus Siao wakonge, ");
INSERT INTO ons_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","eŋe kepeine sisine nat ŋei mane mangi, oŋo lewine wesi mangiso, wesi yewa koropka mainge ma sari aposolo ebonge. ");
INSERT INTO ons_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ŋei mane geke, eŋetne Ananias, ŋanomine eŋetne Sapira. Ananias eŋe kepeine natne ŋei mane mangimo, oŋo lewine wesi mange. ");
INSERT INTO ons_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pakimo, eŋe wesi natne eŋine ma walukki metke, yewa ŋanomine eŋe mo weneŋ detke, Ananias eŋe wesi natneka ma ari isi one more rake, “Na wesi mo iwa korop ma sarimaile,” yale ra more aposolo ebonge. ");
INSERT INTO ons_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pakimo, Petoroŋo olale rake, “Ananias ge onoka wane Satanŋo detkanom, wetŋone waket more ma siukki, Asu Koboboine isika more kepeŋonane lewine natne geŋone motkenom metmaike? ");
INSERT INTO ons_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ge alakan kepe yewa ebonine, yemo geŋone simileŋonane, ŋo wesi mene, ea eŋe geŋane biŋek, paki onoka maikenane wetke simileŋone yewa mogare maine manom rap, ŋo onoka wane dereret qotkoine yewa mene? Ge misuk raikene, na ŋeika isionmaile, midakaka, ge yewa mo Waom eŋine isikene!” ");
INSERT INTO ons_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Yale raki, Ananias eŋe don dere, eaka ket rasu more seukke, pakiso ŋei ŋerep korop eŋe Ananias wano masi wakonge, ea detwarekoi paki, oŋaene qaeki zok kaet onge. ");
INSERT INTO ons_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pakimo, ŋei medep edo wie sari more, pareŋine yewa lap lapŋo kawetka wokomge so tewekka ma ari dukkakoi. ");
INSERT INTO ons_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Naso nigatne aua karewe(3) wane rokop qoeki, ŋadino Ananias ŋanomine eŋe sari saketke, eŋe tanik manik pa daleo ŋaone wakonge, yewa mi detke. ");
INSERT INTO ons_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pakimo, Petoroŋo iwa yale qesonka rake, “Ge nolatnom, kepe ea wane lewine ge so ŋaoŋone ŋire memik, mo korop rokouno iwa me, mida?” Ŋerepŋo rake, “O, mo korop rokouno yewa.” ");
INSERT INTO ons_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Eso Petoroŋo olale iwa yale rake, “Ge so ŋaoŋone ŋire onoka wane Waom wane Asu liwek kaikeik wane wet qeturage don ma togolimik? Detmaine ŋei medep ea ŋaoŋone ma ari dukemi, eŋe mo madetko sari saket okoramami, wane mo ge koso yaleka geu ari koso eŋe weneŋ yewaka duk ganikei!” ");
INSERT INTO ons_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Rakiso, eaka ŋerep eŋe Petoro wane kino ket rasu more seukke, pakiso ŋei medep eŋe mat koto wa kau, eŋe mo seuke pake, eso eŋe ma teweke ari more ŋaonane wazaino dukkakoi. ");
INSERT INTO ons_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Eso doku tau tau magu so ŋei ŋerep natne korop eŋe don kisietne yewa korop dere, kaet suaine zok manerop okangoi. ");
INSERT INTO ons_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposolo eŋe masi togole kine mane kine mane ŋei ŋerep eŋane keueno makoi, pakiso doku tau tau magu mali malip korop wet qeturage more, Solomon wane Touŋ, Bakom Urum wane kotino, yewao lewage gekoi. ");
INSERT INTO ons_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Lewage geu, ŋei ŋerep natne eŋane tego mi takotke gekoi, eŋe ewe kito kitoinerop okane mawa one gekoi, ŋo ŋei ŋerep yewa eŋe kaet okangoi, yalinane eŋe eŋerop lewa lewaŋ wane mi sariu weneŋ lewaŋ maŋkoi. ");
INSERT INTO ons_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pakiso, ŋei ŋerep zok manerop eŋe Waom detlukka malip kakoi, eŋe sari eŋane maguo takotkekoi. ");
INSERT INTO ons_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aposolo eŋe masi kine kine ŋei ŋerep keueno makoi, ea wane ŋei ŋerep eŋe zoma ŋeikopeene tewekone sari numao yaup tewino uam kine kineene lameke mauluke biraonbi pa arikoi, so eŋe wetke rakoi, Petoroŋo eŋane osoenoka sa ariki, so oŋa lulupineŋo qoe ket eŋane kuteno wa rokop ongi, so menaŋgei eŋe yale rau paki okangoi. ");
INSERT INTO ons_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","So Yerusalem mat loli lolik yewao ŋei ŋerep gekoi, eŋe korop yaleka sari aposolo eŋano watkekoi, eŋe zoma ŋei so asu borikineŋo kotoeno ket matali ongi gekoi, yewa ebu sariu, korop solaene koso menaŋ onwareke. ");
INSERT INTO ons_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ŋo Pris Wawaine so eŋane magukoune Sadusi korop, eŋe onbi, aposolo edo kine kine ea korop mau, eŋe manerop dere worikongoi, paki mulapko bira onikei wane rakoi. ");
INSERT INTO ons_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","So eŋe wie more, aposolo malip one ebu ari mulap urum suaino, ŋei borikine eŋerop biraongoi. ");
INSERT INTO ons_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ŋo ruo yewao yemo Waom wane aŋelo maneŋo mulap urum wane madetine lalage more, inat ŋadino ebu saket biraone more, edane rake, ");
INSERT INTO ons_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ŋine ari Bakom Urum koto wa okorau paki, ŋei ŋerep korop gege musele iwa wane don tanik manikine ebu kito edanbi.” ");
INSERT INTO ons_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aposolo eŋe don yewa dere more kepe qaeki ruoropka Bakom Urumgo wa more ŋei ŋerep sigi maep don ra qelaŋane edangoi. Pris Wawaine eŋine so kimakoune, eŋe sari Israel suaine so Kaunsol korop edorau sariu qeturage lewaŋgoi, paki don edane qebinonbi, mulap urumgo ari edanbi aposolo ebu eŋano sarikei wane arikoi. ");
INSERT INTO ons_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ŋo tebe ŋei eŋe mulap urumgo ari lotke more, onbi aposolo eŋe mi metkoi, eŋe zuaŋonbi boriki, eŋe koso zinge sari more Kaunsol edane rakoi, ");
INSERT INTO ons_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ŋene ari mulap urumgo lotke more kaŋem, madet mo togoleka ki okora warike, so diam ŋei eŋe korop madetko diam okora warimi, ŋo ŋene madet lalagine naso yewao ŋei mane urum kotino mi metpi onine!” ");
INSERT INTO ons_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bakom Urum wane diam gege tebe ŋei suaine, so pris ŋetne suaine, eŋe don yewa dere more, dereret urata loutne mau paki rakoi, “Iwa daleo wakonmaike? Ŋei ea eŋe daleo siukmami?” ");
INSERT INTO ons_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pakimo, ŋei mane oŋo wa more edane rake, “Detmami! Ŋine ŋei ea mulap urumgo bira onimi, eŋe mo Bakom Urum kotino okora ŋei ŋerep sigi maep don ra qelaŋane edanmami!” ");
INSERT INTO ons_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yale edanbiso, Bakom Urum wane diam gege, tebe ŋei suaine so ŋeikoune eŋe ari koso aposolo ebu sarikoi, eŋe engu kito mi okangoi, onoka wane eŋe ŋei ŋerep edo wesiŋo engukei wane kaetonge. ");
INSERT INTO ons_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tebe ŋei eŋe aposolo ebu ari biraonbi Kaunsol eŋane kaiteno okorakoi, pakiso, Pris Wawaine maneŋo edane rake, ");
INSERT INTO ons_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ŋine ŋei yewa wane eŋetine ŋei ŋerep eŋano mi ra qelaŋane kito edanikei wane, ŋene mo togogoleka rawetŋune more, mi ra togole ŋungone me? Ŋo ŋine yemo siluŋ don yewa Yerusalem matko ra suae motpi, sua arimaike, pakimo, ŋenane solazo qe more, ŋei yewa ŋedo qeŋem seukkane weŋeminane turuŋ so sot yewa baŋ ŋenane kutzo payake, yale ra ŋei ŋerep edanmami.” ");
INSERT INTO ons_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Rakimo, Petoro so aposolo natne eŋe iwa yale mainge olatkoi, “Lewine, Anutu wane don tewekkene! Ŋei don yewaŋo ŋado kitomaike! ");
INSERT INTO ons_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ŋine Yesu kibeŋ qabego rasukoi so qeu seukki, ŋenze ŋabokopze eŋane Anutuŋo ma wirikkaki wisikae wieke. ");
INSERT INTO ons_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wieki, Anutuŋo mawa more, eŋine metine wonino Ŋetne so Mapi Mapik Ŋeize birakake, oŋo Israel ŋene qesiŋ ŋongi, wetze maingeŋem borikineze ŋebu mayake. ");
INSERT INTO ons_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ŋene kaŋem, Waomŋo urata ea mamaike, paki ŋene sigi maep don ea ra qelaŋanmaine, so Asu Koboboine eŋe yale waka kine kine korop ea wane ra qelaŋanmaike, so Anutu eŋe mo eŋane don tewek okanmami, eŋe Asu Koboboine sunka ebon okanmaike.” ");
INSERT INTO ons_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kaunsol magu eŋe Petoroŋo don yale edangi detpi, qomene kito poke ebu ket biraongi, dere worik suaine okane more, aposolo ebu engukei wane okangoi. ");
INSERT INTO ons_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ŋo Kaunsol eŋane keuo ŋine ŋei mane eŋetine Gameliel, eŋe Parisi, ra rokop don wane kito ebo ebon, eŋe ŋei ŋerep koropŋo ewino kitou geke, oŋo Kaunsol eŋane keuo wie okora more ra ongi, aposolo ebuwi nigatne qeinat waketkoi. ");
INSERT INTO ons_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Eŋe qeinat ŋadino ketpiso, Gamelielŋo Kaunsol natne edane rake, “Israel ŋei, ŋine ŋei iwa kine kine daleo okan ongei, wane rau paki, ŋine siluŋ mikep detluke more kauluke okan onikei. ");
INSERT INTO ons_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ŋine mo detmami, naso natne mo arike, ea wane bano qei, Teudas mane eŋe wakone more rake, na ŋei waom eŋane suaineene, yale raki, ŋei 400 eŋe eŋano takotke ŋadino mogare arikoi, ŋo gavaman eŋe qeu seukki, ŋeikoune eŋane don detpi wele okangi aŋaine teweke gekoi, eŋe korop din bun wiri ket yeo yeo ari wareu, urataene wele midaine okange. ");
INSERT INTO ons_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","So ea wane ŋadino ŋei mane Yudas, Galili ŋine, oŋo kepe ware wareŋo ŋei ŋerep natne ebu waraŋ ongi, eŋane don teweke ŋadino mogare arikoi, paki kepe ware ware esopkaikei wane kawali ma wakone qekoi. Ŋo eŋe yaleka qeu seukki, so ŋeikoune aŋaine teweke ŋadino mogare gekoi, eŋe kakakone ket yeo yeo ari warekoi. ");
INSERT INTO ons_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Eso na kine yalewa, wane na ukude don iwa ŋidanmaile, ŋine ŋei yewa sulu kine kine mane misuk okanongei, midakaka, ŋine qeliŋonbi enŋeneka geu, onoka wane dereret so urata yewa ŋei enŋene dereretko ŋine sarimaikeo, yemo baŋ bori more siukeake. ");
INSERT INTO ons_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ŋo Anutu oŋom ea wane kine okangi paki wareki, eŋano ŋine sarimaikeo, yemo ŋine maine mi kitat onikei, pakimo ŋine kawali qekeimo, ŋine Anutu ŋaba kamami, yale okaniake!” ");
INSERT INTO ons_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kaunsol eŋe Gamalielŋo yale ra edangi detpi menaŋgi, so eŋane don dere, aposolo edorau sariu, ŋei edo kumunamŋo dime ongoi. Pakiso, Yesu wane eŋetine ora don kisiine ŋei ŋerep koso manerop mi ra edanikei wane togoleka rawet one more biraonbi arikoi. ");
INSERT INTO ons_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposolo eŋe Kaunsol qeliŋ one more qeinat mat ŋadino ketkoi, paki, eŋe Anutuŋo detongi, Yesu wane eŋet wane ra more wikile wane gamu marat kakoi, ea wane wetene peseki, bakom kitokoi. ");
INSERT INTO ons_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","So kaiwe baŋem Bakom Urumgo me enŋene mateno eŋe ŋei ŋerep sigi maep don kito eda edan urata ea mane mi qeliŋkoi, midakaka, eŋe Yesu Mesia wane sigi maep don, yewaŋo tako rakot iwa yale ra qelaŋane edane gekoi. Anutu eŋe ra rokop donine mo rake, yewa teweke more, Yesuŋo birakaki, ŋei okangi paki, ŋei ŋerewekoune koso borikino ŋine mainone sa biraonge. ");
INSERT INTO ons_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Naso yewao Yesu wane dokoine doku tau tau magu zok loutne wakone sua leule okane arikoi, Yuda doku tau tau magu natne eŋe Grik don ra gekoi, eso Yuda natne eŋe Hebru doku tau tau magu enŋene don ra gekoi, ea wane Grik don ra gekoi, eŋe Hebru don ra gekoi, eŋane detpi boriki rakoi, “Ŋine naso baŋem Yuda ŋei ŋerep ŋara wane seuke ma zuaŋ okanmami, eŋe ŋara maine qesiŋon okanmami, ŋo Grik ŋenane ŋerep mala iwa ŋaokopene seu seune, eŋe yemo ŋara mi qesiŋon okanmami.” ");
INSERT INTO ons_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Eso ea wane aposolo 12, eŋe doku tau taune magukopene korop edorau sari lewageu edane rakoi, “Ŋene Anutu wane don miti rara yewa qelige more solaoken ŋara mato matok urata maŋem mi menageake, ");
INSERT INTO ons_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ea wane kimakop, ŋine ŋei sewen(7) ŋinŋine keuŋino ŋine, eŋe eŋet biŋekene maine, mitirop so Asuŋo kotoeno watke pamaike, so eŋe dereretene maine, onbi menaŋgi ma wakon onbi. Pakimo, ŋene ŋei yewa eŋe bira onŋem urata yewa naso baŋem warekei, ");
INSERT INTO ons_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ŋo ŋedom yemo naso baŋem meŋe meŋen urata maikene so Waom wane miti don yewaka ŋei ŋerep ra edan okanikene.” ");
INSERT INTO ons_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Don yewa rau, ŋei ŋerep korop eŋe aposolo eŋane don yewa detpi menaŋ wareke, pakiso, eŋe Stiwen ma wakonka bira kakoi, eŋe mali malipine togogole so Asu Koboboineŋo kotino waket pake, so Pilip, Prokorus, Nikanor, Timon, Parmenas so Nokolaus, eŋe Antiok matko ŋine, eŋe lobo, ŋo eŋe mo sogino sari Yuda doku tau taune eŋane maguo takotkeke. ");
INSERT INTO ons_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Eŋe ŋei ea ma wakon one more, aposolo eŋane kaiteno bira onbi okorakoi, paki eŋe meteene leweteno ma wa motpi paki, meŋenka mosop ongoi. ");
INSERT INTO ons_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pakiso, Anutu wane miti donŋo ket sua nat nat rokopke arike, eso ŋei ŋerep maguine maguine, eŋe Yerusalem yewao aposolo eŋane ŋadeeno doku tau tau magu loutneŋo ari takotke warekoi, so Yuda wane pris magu suaine natne eŋe miti don dere teweke malip kakoi. ");
INSERT INTO ons_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stiwen eŋe Anutuŋo qesiŋka more, mosop zok manerop mosopkake, so zonomine manerop wat watko qe watke mange, ea wane eŋe ŋei ŋerep eŋane keueno masi kine kine suaine so togogole zok make. ");
INSERT INTO ons_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ŋo ŋei natne eŋe wieu paki, Stiwen gorop donŋo yakukoi, ŋei yewa eŋe Yuda eŋane lewa lewaŋ urum ea wane magu, eŋetene, “Yuda Ŋei Yaup gegine eŋane Lewa Lewaŋ Urum,” yale orakoi. Ŋei yewa eŋe Sairin matko ŋine, Alekzandria matko ŋine, Silisia kepeo ŋine so Asia kepeo ŋine. ");
INSERT INTO ons_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ŋo Asuŋo yemo Stiwen dereret maine so koboboine zok manerop mangane, eŋe don raki, ŋei eŋe donŋo qekei wane zok manerop makararapkakoi. ");
INSERT INTO ons_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Paki, eŋe isiu paki, ŋei natne sanka wetko ket okanonbi rakoi, “Ŋei yewa eŋe Mose so Anutu don qotkoine ra etoraki, ŋene det kakone.” ");
INSERT INTO ons_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Eŋe tanik yale okane ŋei ŋerep magu so ŋetne mama, so ra rokop don kito ebo ebon wane ŋei, wetene qe pokkoi, pakiso, eŋe Stiwen wano ari kitatka malipka tebaka Kaunsol eŋano ma arikoi. ");
INSERT INTO ons_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Eso eŋe ŋei natne isi don Stiwen wane aŋao more raikei wane bira ongoi, eŋe iwa yale rakoi, “Ŋei iwa eŋe naso baŋem ŋene detkaŋem Anutu wane Mat Kobekine iwa so ra rokop don erane don borikine ea naso baŋem qik ore more ra okanmaike, ");
INSERT INTO ons_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ŋene detkaŋem, eŋe iwa yale rake, ŋeiwa yewa Yesu Nazaret welaine, oŋo mat Kobekine iwa baŋ mataliki siukeake, so Moseŋo ra rokop donba ŋebonge, yewa baŋ weneŋ ma papkayake, yale rake!” ");
INSERT INTO ons_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pakiso, ŋei korop Kaunsol urum kotino metkoi, eŋe deene Stiwenka kalilip kakoi paki, eŋe kau de kaitine yewa korop aŋelo mane wane de kait yale qelaŋane arike. ");
INSERT INTO ons_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pakimo Pris Ŋetne Suaineŋo Stiwen qesonka rake, “Don iwa ŋei eŋe geŋano qe more ramami, ea welekatne me?” ");
INSERT INTO ons_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Paki mo Stiwen eŋe donine mainge more iwa yale rake, “O, magakop tarekop, ŋine detpi, sogino ŋaboze Abraham eŋe Haran mi ari ari Mesopotamia kepeo metke, naso yewao Anutu qelaŋan gorop qeli welaine so Anutu zonomine kakapa suaine eŋe Abraham wano sarike, ");
INSERT INTO ons_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Anutu eŋe sari more iwa yale olatke, ‘Ge kepe matŋone so ŋon tarekopŋone iwa qeliŋone more, noŋo kepe mane sikan ganikale, yewao wie arikene.’ ");
INSERT INTO ons_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yale wane Abraham eŋe Kaladia kepeine yewa qelige more wie ari Haran metke. Paki mo magaine seuki so ŋado baŋ Anutuŋo birakaki sari kepe iwa ukude gemami, iwao metke. ");
INSERT INTO ons_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Anutu eŋe Abraham eŋine kepe biŋek mane malipka geakane wan(1) mita, ea wane rokop nigatnemde mane mi mange. Me kepe sisikatnemde mane mi sunkake, midakaka, ŋo Anutu eŋe rake, Abraham eŋe ŋado eŋine kepe biŋekine malipka geake, ea manikale. Pakimo ŋado ŋosa ŋabokoune eŋe yaleka wie more kepe yewa malipka gekei. Abraham eŋe medeune midaine geke, ŋo naso yewao Anutu eŋe don yewa siluŋ rake. ");
INSERT INTO ons_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Anutu eŋe don maine iwa yale rake, ‘Doko ŋosa ŋabo tegokopŋone eŋe ŋei tego natne eŋane kepeo gekei. Pakimo ŋei tego natne yewa edo geŋane doko ŋosa ŋabokopŋone, ea biraonbi eŋe eŋane qelit qeqe okane eŋane urata ma geke. Paki, eŋe koma 400, ea wane rokop, manerop matalione gekei. ");
INSERT INTO ons_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ŋo baŋ ŋado, na ŋei ŋerep tego masi yewa okanmami, ea wane na dongo biraonikale, doko ŋosa ŋabo tegokopŋone, eŋe eŋane qelit qeqe gekei, paki eŋe kepe yewa qelige more sa arikei, eŋe sari naŋano kepe iwa wane bakom kito qelitne qe gekei.’ ");
INSERT INTO ons_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Paki Anutu eŋe Abraham doko ŋosa ŋaboine eŋe Waom gorop tako rakot okane gekei wane, rara togon don ra more, eŋe yaene solaine kitasikei wane rakoke mange. Wane ŋado Abraham eŋe gipole Isak wakongiso, eŋe kaiwe mama 8 yewao, yaine solaine kitatke. Isak eŋe Yakop wane magaine, ŋo Yakop eŋe ŋei waomkopze 12 eŋane magaene. ");
INSERT INTO ons_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Yakop wane gipolekoune eŋe Yosep wane dere worik okan more, eŋe ŋei natne eŋano biraka more urata medep yauwine yale wesi makoi, pakimo, eŋe Ezipt kepeo ma arikoi. Ŋo, Anutu eŋe weneŋ eŋerop geke. ");
INSERT INTO ons_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Wane oŋo mapitka more umat kine kine korop eao ŋine ma birakaki saki, wet maep so dereret wekumane mangi, eŋe Ezipt ŋei waom Parao wane kaitko kine kine okangi menaŋ menaŋine okan mageke. Parao, eŋe Ezipt wane ware ware suaine, wane Yosep mawakonka birakaki, Ezipt wane kepe ware ware ŋetne okange, pakimo, eŋe Parao wane matkotino kine kine korop ea wane ware ware okange. ");
INSERT INTO ons_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ŋado ŋara wane bodi suaine Ezipt kotino so Kanan kotino korop wakongi, ŋei ŋerep eŋe umat suaine zok maratkakoi, pakimo, aso ŋabokopze eŋe ŋara maine mi maratkakoi. ");
INSERT INTO ons_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ŋo Yakop eŋe yale detki ŋara eri Ezipt metke, paki Yakop eŋe aso ŋabokopze biraongi, mikep atak weku arikoi. ");
INSERT INTO ons_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ŋado koso ariu atak etke okange, pakimo, Yosep eŋe tarekoune eŋine kineine ra qelaŋane edane rake, ‘Na Yosep’ Naso eao Parao eŋe Yosep wane tego ea eŋe eŋine tarekoune, yale detonge. ");
INSERT INTO ons_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Wane ŋado Yosep eŋe magaine Yakopŋo eŋano sariakane don raki ariki, magaine eŋe eŋine so, ŋei ŋerewekoune 75 ea wane rokopŋo sarikoi. ");
INSERT INTO ons_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Paki Yakop eŋe Eziptwo ket ge more ea seukke, wane gipolekoune aso ŋabokopze eŋe weneŋ yalewaka eŋe weneŋ yewa ket ge more seukwarekoi. ");
INSERT INTO ons_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pakiso pareŋene ea ebu tewe one zinge koso Sekem ari dukongoi, deŋesere yewa mo sogino Abraham eŋe wesiŋo Hamor wane dokoine, Sekem matko, qole one more ebu make. ");
INSERT INTO ons_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Anutu eŋe ŋado eŋine nasoo kine kine baŋ mayakane sogino Abraham rara togon don olatke, ea togoleakane okangi, nasoine bomile sariki, Ezipt kepe Israel wane tego eŋe zok manerop wakone sua loule okangoi. ");
INSERT INTO ons_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pakimo, ŋado Ezipt wane ŋei Waom mane wakonge, ŋo eŋe Yosep ea mi detkake. ");
INSERT INTO ons_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ŋei yewa eŋe ŋenane tego ea isione masi borikine okan one geke, eŋe raki dokoene ŋei abubuo wakonbi, qela ŋadino touko me doku namugo biraonbi yeine seukmaŋkoi me engumaŋkoi. ");
INSERT INTO ons_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Paki Mose eŋe naso yewao wakonge, eŋe medep wekumane paki Anutu eŋe eŋane siminkake, naga magaine eto meso karewe (3) ea wane rokop wareka gekoik. ");
INSERT INTO ons_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Paki eŋe ŋadino tomoko birakau, Parao wane borasineŋo ma more eŋine medep yale bororom mauluke wareka geke. ");
INSERT INTO ons_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Paki, Mose eŋe Ezipt eŋane papia urumgo wa more eŋane dereretene korop manerop detwareke, wane eŋe don togole zonom gorop raraino me urata mamaine, yewao ŋei ŋerep eŋe ka more eŋet biŋekine ora bukeu manerop wake. ");
INSERT INTO ons_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ŋado Mose eŋe komaine(40) qoeki, eŋe Israel ari tegokoune oniakane wetkeke, ");
INSERT INTO ons_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","eŋe kaki, Ezipt maneŋo Israel mane qe matali kake, paki eŋe Israel yewa qesiŋkake, paki eŋe Ezipt ŋeiŋo Israel ŋei yewa komu komune zok qe matalikake, ea wane Mose eŋe kimaine Israel ŋei yewa ka more, Ezipt ŋei yewa qeki seukke. ");
INSERT INTO ons_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Paki, Mose iwa yale detke, ‘Naso iwa naŋane tego edo dere raikei, “Anutuŋo Mose qesiŋ kaki, ŋene qelit qeqe wikile uratao ŋine makok ŋonmaike.” ‘Ŋo Israel edo yale mi detkoi, eŋe yale mi dere qelaŋangoi. ");
INSERT INTO ons_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ea wane ŋadino kaiwe maneo Israel ŋei etke yakuwik, Mose eŋe erane osoetno sari otki paki, kito pese ma momoe osiakane okane more rake, ‘Ai, kimatke, ŋire tati ŋon, eamo onoka wane ŋiritne matali nagumamik me?’ ");
INSERT INTO ons_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ŋo ŋei mane kimaine matali kake, eŋe Mose kito papkaki zinge arike paki, eŋe rake, ‘Yai, ge maŋo ŋenane ware ware ra biragangi okoramaine? ");
INSERT INTO ons_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ge yatne Ezipt ŋei mane qenom seukike, yalewa koso na nekukenane okanmaine me?’ ");
INSERT INTO ons_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Eŋe yale raki, Mose eŋe don ea dere kaet okane wie arike, eŋe ari mage Midian eŋane kepeo lotke more yewa lobo ŋei okane geke. Ŋado eŋe ŋerep mane make, paki medewetkine ŋei etke wakongoik. ");
INSERT INTO ons_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Pakimo koma 40 ari qoeki, kepe yaup papaine ŋei midaino aŋelo maneŋo wakonkake, eamo Sainai Bonaga osino, eki nigatne mane wakelerop, ea wane naune kotino gerep bolamine yale laweke, ea wane kotino agelo eao metke, ");
INSERT INTO ons_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose eŋe ea ka more dereret urata ma mage rake, ‘Iwa onokakaŋo wakonmaike,’ yale ra osinoka kaulukeakane ra arike, pakimo Waom suaineŋo boka iwa yale olale rake, ");
INSERT INTO ons_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Na geŋane aso ŋabokopŋone eŋane Anutu, na Abraham so Isak so Yakop eŋane Anutu,’ raki, Mose eŋe qomine poradangi qise more kayakane kaetkake. ");
INSERT INTO ons_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pakimo, Waom suaineŋo olatke, ‘Kieŋonane kaweune kie kulitŋone, ea makokenom, kepe yewa okoramaine, ea kepe kobekine, eŋe naŋane kepe biŋek. ");
INSERT INTO ons_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Na masi kine kine qotkoine Ezipt edo ŋei ŋerewekopne eŋano mamami, na nia ea mo korop ka waremaile, na Yuda ŋei ŋerep aroene mo derile, pakimo na ukude iwa Ezipt eŋane meteeno ŋine qesiŋ onikalane ketmaile, so umatene yewa ma birawe ariake, ea wane ge wienom, na biraganbe Ezipt arinom.’ ");
INSERT INTO ons_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Eŋe sogino Mose kito papka more olale rakoi, ‘Ge maŋo ŋenane ware ware so wano wanok ŋeize ra more biraganike?’ Pakimo, ŋei wa yewa Mose, eŋeka Anutuŋo aŋelo birakaki, eŋano ket more olatke. ‘Na ge bira ganbe, Israel wane ŋetne okora more tegoŋone zonom gorop qesiŋone more qelit qeqe wikile uratao ŋine makok one more ebu sakene.’ Waom eŋe aŋelo wane metino more gerep bolamino eki nigatno wakonkake ");
INSERT INTO ons_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mose eŋe ebu ari more, masi tanik kine kine togogole Ezipt make, so Kiwet Takitne so kepe yaup papaine ŋei midaino eŋe masi korop mawareke, eŋe koma 40 yale, kepe ŋei midaino geke. ");
INSERT INTO ons_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","So Mose eŋe oŋoka Israel ŋei ŋerep ra edange, ‘Baŋ Waomŋo kimaŋine ŋei mane ma birakaki, na yale propet okane mesiake.’ ");
INSERT INTO ons_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Baŋ Mose eŋe aso ŋabokkopze Israel ŋei ŋerep eŋerop kepe yaup papaine, ŋei midaino gekoi, ŋado koso Mose weku oŋoka, eŋe ŋabokopze eŋerop gekoi, paki eŋe Sinai Bonagao yewa waki aŋeloŋo don olatke, naso yewao aŋeloŋo Mose Anutu wane ra rokop don togoninerop olatke, wane Moseŋo don yewa papiao qeke, wane ukude ŋene don yewa dapore detmaine. ");
INSERT INTO ons_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ŋo ŋabokopze eŋe Mose wane don desikei wane bauene waki mi detkoi, midaka, eŋe ma papka more wet mali malipeneŋo koso Ezipt kepeo zinge arikei wane simile zok detkoi. ");
INSERT INTO ons_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Eŋe Aron olatkoi, ‘Ŋene mi detmaine, Mose wano mo daleo wakonike, ŋei oŋo Ezipt kepeo ŋine iwen ŋone sarike, yale wane ge ŋenane waomkopze natne ebunom, pakimo edo ŋene alakane ŋebonbi, ŋene numa arikene.’ ");
INSERT INTO ons_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Aron eŋe aŋaene teweke naso yewao bulamaka ŋei oŋa oŋaine maki motpi okoraki, eŋe waom isisine edom meteeneŋo makoi, ea wane kino ŋara soep engu mire mau zeki, ea wane epa kebu suaine ma more bulamaka oŋainane ewine kitokoi. ");
INSERT INTO ons_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Eŋe yale okanbi, Anutu eŋe ea wane ra more ŋadekongi, eŋe kepe deine so meso serekin ea bakom kito meŋenone gekoi, wane propet eŋane papiaŋo iwa yale ramaike, ‘Israel magu ŋine sogino koma 40 yale kepe yaup papaine ŋei midaino ge more, ŋine bulamakau so lama engu ŋara soep mire epa kebu suaine mama ea ŋine maŋano ŋine dere more makoi? Naŋano ŋine, yem midakaka, ");
INSERT INTO ons_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ŋine Molek anutu isisinane seli kise ea ma tewekkoi, eamo naŋane seli kisi midakaka, ea yemo nemu Rapan wane serekin oŋaine ea bakom kito tewekau paki, meŋenkamami, ŋine oŋa oŋa ea makoi so ŋine wet dereret ŋine anutu isisine eŋano motpi paki, ŋine wetŋineŋo naŋane ewene mi kitokoi, ea wane na ŋibu biraŋunbe kepe mat ŋinŋine ea qelige more Babilon eŋane kepe mat nat paromino ari yewa gekei.’ ");
INSERT INTO ons_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Sogino mokaka aso ŋabokopze eŋe kepe mat ŋei midaino gekoi, naso yewao eŋe Anutu Wane Seli Kise magekoi, Seli Kise yewa mo Anutu eŋe donine wele ma wakonge, Seli Kise yewa makoi, naso yewao yemo anutuŋo maikei wane rake, rokop eŋe makoi, ea yemo Moseŋo oŋa oŋa mo kake, ea wane rokop makoi, Anutu eŋe mo Mose yalewaka mayakane olatke. ");
INSERT INTO ons_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ŋado aso ŋabakopze eŋane dokoene eŋe Seli Kise ea ma more Yosuarop sari, ŋei tego natne eŋane kepe mat natne makoi, pakimo Waomŋo aso ŋabokopze eŋane kaitko ŋine esoponge. Naso yewao Anutu wane Seli Kise birau ket kepe yewao metke, mere sari mageki, ukude Dawit wane naso okanmaike. ");
INSERT INTO ons_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Waomŋo Dawit wet maep okankake, paki Dawitŋo meŋenkaki, oŋo detkaki, Yakop wane dokoŋosaine eŋane urum mayakakatne mane maine mayakane, okange. Eŋe baŋ ea wane kotino waket Anutu meŋenka gekei wane, ");
INSERT INTO ons_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","pakiso Solomonŋo eŋane Bakom Urum ea baŋ make. ");
INSERT INTO ons_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ŋo propet maneŋo iwa yale ramaike, Waom suaine wetika weti, eŋe ŋei meteŋo urum mamaine, eao mi waket met okanmaike, ");
INSERT INTO ons_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Waom suaineŋo iwa yale ramaike, ‘Qeli eaŋo naŋane ŋei waom met metne okanmaike, ŋo kiene yemo kepe kutno more mere zonom makale, yale wane mo, ŋine naŋane mat dalino maikei wane okanmami? Na diawao mere zonom maikale? ");
INSERT INTO ons_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ea yemo na noŋom meteneŋo kine kine yewa korop ma warekole.’ ");
INSERT INTO ons_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ŋo Stiwen eŋe Kaunsol korop koso edange, “Ŋine wawaine ŋei, ŋine ket wetŋine midaine, qelaŋ magu eŋane rokop, naso baŋem ŋine ketŋine wongeki, Waom wane don mi det okanmami, ŋine Asu Koboboinane don mi dere, ea ma papka okanmami, ŋine aso ŋabo kopŋine eŋe okane gekoi, gegeŋine weku eaka okanmaike. ");
INSERT INTO ons_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sogine propet mane maŋo geki, eŋe masi maine okankakoi? Ea midakaka, ŋinane aso ŋaboŋine, eŋe Anutu wane don naŋene rara ŋei, propet korop wikile ebone more, natne enguwi seukkoi, ge mage koso Anutu eŋine qelit ŋei koboboine sariakane ra wakongoi, ŋei yewa weneŋ enguwi seukoi, pakimo, ŋine koso eŋine Waom Koboboine wetko ket okan nagu more qeqe ea ŋido okangoi. ");
INSERT INTO ons_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ŋine Waom wane ra rokop don, ea agelo eŋane meteo ŋine makoi, ŋo ŋine ea mi mogat kamami.” ");
INSERT INTO ons_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kaunsol magu korop eŋe don ea detpi, qomeno qeki begiriŋgi, eŋe koto so sola weneŋ ŋet kitipke more, Stiwen wane koto gerep yemo manerop zok okangoi. ");
INSERT INTO ons_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ŋo Stiwen eŋe Asu koboboineŋo watka okorakane, eŋe qeliwo pore togoleka kalilipka okora potlotke, Anutu qelaŋane kake, so Yesu eŋe Anutu wane wazaino wonoken qeli ewe zonom so kibi maepine weneŋ metke, ea weneŋ kake. ");
INSERT INTO ons_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Paki Stiwen eŋe rake, “Ŋine detmami, na qeli potlotke ŋei Welaze, Ŋei Wawainane Gipole, ea Waom wane wazaino wonoken metki kamaile.” ");
INSERT INTO ons_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ea wane eŋe togoleka boka kuroge more, ketene qewonge orodoŋ wie biririke ari Stiwen malip kakoi. ");
INSERT INTO ons_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Pakimo eŋe esopkau, mat suainane ŋadino erinat ari waketki, eŋe kieke more wesi lewino seukeakane birakoi, mikep eŋe qesat don ra olale more, takotine ea kito qoke more, ŋei medep qaluwit mane eŋetine Saul eŋane kine magukkeu metke. ");
INSERT INTO ons_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Paki, eŋe wesiŋo Stiwen kiŋ quŋ qekoi, Stiwen eŋe iwa yale meŋen kake, “O Waom Suaine Yesu, ge asu oŋa oŋane manom!” ");
INSERT INTO ons_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Koso pese ket wawetine qe mere more, togoleka manerop boka rake, “O Waom suaine ge eŋane sot ea qelige ebonnom niget ganiake!” Stiwen eŋe yale ra more, so eaka seukke. Masi tanik ea mo Saul wane deino koboboineka eŋe Stiwen wano okangoi. ");
INSERT INTO ons_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Stiwen qeu seukke, ea wane doku tau tau magu eŋe Yerusalem osino metkoi, wane naso yewaoka kieke ŋabakopene edo zok manerop matali qetali okan ongoi, ea wane doku tau tau magu eŋe korop kaet ket nat nat Yuda so Samaria ari warekoi, pakimo aposolo enŋeneka Yerusalem metkoi. ");
INSERT INTO ons_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ŋei natne eŋe Waom wane masi koboine mogare gekoi, Waomŋo eŋane detki menaŋge, ea edo Stiwen dukka more, eŋe aro suaine zok manerop eŋane arokkoi. ");
INSERT INTO ons_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ŋo Saul eŋe doku tau tau magu zok manerop yeka matali oniakane geke, eŋe mat koto ari waket more, ŋei so ŋerep ebu waraŋ one sari, mulap urumgo bira onmaŋke. ");
INSERT INTO ons_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Doku tau tau magu eŋe ŋaba eŋane kaetongi, kakakone ket mat maneo maneo ari more sigi maep ra qelaŋangoi, ");
INSERT INTO ons_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip eŋe Samaria wane mat mane suaine yewao ket more, Kristo wane eŋetine ora more, ea wane sigi maep, ea ra qelaŋan onge. ");
INSERT INTO ons_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ŋei ŋerep loutne manerop eŋe Pilip wane don detkoi paki, eŋe masi tanik togogole maki kakoi, ea detka more, eŋe ketene eŋanoka more metpi edange. ");
INSERT INTO ons_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ŋei ŋerep loutne manerop eŋe asu qotkoine kotoeno pake, wane asu qotkoine yewa eŋe togoleka aroke more, qeliŋ one saket arikoi. Paki ŋei loutne setene seu seune me kie meteene qotkoine, ea eŋe korop mo maine menaŋ warekoi. ");
INSERT INTO ons_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ea wane ŋei ŋerep eŋano bakom suaine zok manerop mat suaine yewa eŋano wakonge. ");
INSERT INTO ons_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ŋei mane mat suaine yewao metke, eŋetine Simon, eŋe sogino suŋa qare kine kine ma okanmaŋke, eŋe yale okangi, Samaria ŋei ŋerep korop eŋe wet dereret loutne detkoi, yale okangi so Simon eŋe ramaŋke, “Na, nae ŋei suaine mane.” ");
INSERT INTO ons_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Paki, ŋei ŋerep eŋetenerop, so ŋei ŋerep eŋetene midaine, eŋe korop Simon wane don desikei wane sorin gekoi, eŋe rakoi, “Ŋei yewa eŋe Anutu wane zonom gorop gemaike, eŋe, ‘zonomine suaine’,” eŋe yale ramaŋkoi. ");
INSERT INTO ons_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Pakimo, eŋe eŋane don desikei wane sorin gekoi, onoka wane, naso loutne eŋe masi kine mane maki, eŋe kau masi togogole yale okangi, eŋe wet dereret loutne detkoi. ");
INSERT INTO ons_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ŋo baŋ Pilipŋo sigi maep, Anutu wane qeli ewe zonom wane don kisi maine ea so Yesu Kristo wane sigi maep, ea ra qelaŋane edangi, eŋe naso yewao malipka more ŋei so ŋerep doku tau warekoi. ");
INSERT INTO ons_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pakiso, Simon eŋe yaleka malipka more, doku tau more, Pilip korop gekoik, eŋe kaki masi tanik kine kine togogole Pilipŋo maki wakongi, ka more oŋaine qaeki, dereret urata zok manerop make. ");
INSERT INTO ons_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aposolo eŋe Yerusalemka mere detpi, Samaria eŋe Waom wane don mo mamami, ea dere more, eŋe Petoroŋo Yohane biraotpi, ere eŋano ketkoik. ");
INSERT INTO ons_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ere ket more, Waomŋo qesiŋongi, Asu Koboboine makei, ea wane meŋen kakoik. ");
INSERT INTO ons_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Eŋe Yesu wane eŋetko doku taukoi, ŋo Asu Koboboineŋo eŋane kuteno mi ket kitoke, ");
INSERT INTO ons_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ea wane ere meteetne kuteno motpik, so eŋe Asu Koboboine korop makoi. ");
INSERT INTO ons_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon eŋe otki aposolo etke, ere meteetne kuteno motpik, eŋe Asu Koboboine makoi, ea wane eŋe wesi erano ma sari more rake. ");
INSERT INTO ons_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Ŋire zonom yewa naŋano weneŋ motpik, pakimo na yale waka metene ŋei mane wane kutino motpe so, eŋe yale waka Asu Koboboine ea, eŋe maine mayake” ");
INSERT INTO ons_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Yale rakimo Petoroŋo olatke, “Waomŋo kine kine ea wet pesek wane ŋebonmaike, ea ge maine wesiŋo mi qolekene, ea midakaka, ea wane wesiŋone ea mo geŋonerop sola gerepko weneŋ ŋisoki rap. ");
INSERT INTO ons_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Geŋane wet dereretŋone ea Waom wane deino koboboine zok mi okanmaike, ea wane ge zonom so urata i wane kotino maine mi wakesikene, ea midakaka, ");
INSERT INTO ons_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ea wane ge siluŋ wetŋone mainge more, masi tanikŋone qotkoine ea qelige more ŋadekkanom, paki, ge Waom suaine meŋen kanom, oŋo maine wet dereret ŋonane bailalaŋ so sot turuŋŋone ea ma biraki ariake. ");
INSERT INTO ons_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na yalewa ramaile, onoka wane na ganbe, ge naso baŋem Waom wane zonom iwa maikenane bailalaŋ det maŋkene, ea wane umat suaine kaukmaine, so dereretŋonane zoma qotkoine eaŋo borikine ma wakone more walip ganmaike.” ");
INSERT INTO ons_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pakimo, Simonŋo don iwa yale ra more main geke, “Ŋire siluŋ Waom suainano naŋane meŋenkauk, eŋe wet maep okane more qesiŋnangi, ŋire kine kine ea ramamik, ea naŋano koso mi wakoniake.” ");
INSERT INTO ons_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pakiso aposolo etke ere Waom Suainane sigi maep don ŋei ŋerep ra edanbik paki, Waomŋo kine kine erano make, ea wane ra wakone edane more, so ere koso zinge Yerusalem arikoik, ere numao Samaria wane mat loutne ea sigi maep don ra edane arikoik. ");
INSERT INTO ons_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pakimo, Waom Suainane aŋeloŋo Pilip iwa yale olatke, “Ge wie more, kepe nat paromino rai woken arinom, numa yewa Yerusalem yuane qei Gaza ketmaike.” Numa ea ŋei midaine, yaup togole pamaike. ");
INSERT INTO ons_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Eso Pilip eŋe wie more ari numao Etiopia ŋei mane kake, ŋei ea eŋe kepe ware ware suaine mane, eŋe Etiopia ware ware ŋerep waom Kwin eŋane wesi mat ware ware, eŋe labine mo kitokoi, oŋo Yerusalem sari Anutu ewine kito more, koso zinge Etiopia ariakane numao horsi kare kutno mere more propet Asia wane papia, ea dapore arike. ");
INSERT INTO ons_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pakimo Asuŋo Pilip olatke, “Ge horsi kare yewa wane osino ari ikop maratkanom.” ");
INSERT INTO ons_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Paki, Pilip eŋe biririke osino ari more detkaki, eŋe propet Asia wane papia dapore metke, eŋe yale okangi, Pilipŋo rake, “Ge don yewa dapore kineine maine detkamaine me mida?” ");
INSERT INTO ons_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Pakimo, ŋei yewa eŋe don iwa yale mainge rake, “Na ŋei maneŋo numa mi ra wakone sikan nangi, na noŋomka ea wane kineine dalino desikale? Ge sanom narop weneŋ horsi kare kutno mette.” ");
INSERT INTO ons_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Waom Wane kibi nat parom dapotke, ea yemo iwa yale weneŋ ramaike, “Eŋe don mane mi rake, eŋe aŋaine kilipkeki, lama yale qeu seukeakane ma sarikoi, eŋe lama medeune zoune kitatpi mi arok maŋkei, yale waka ŋei yewa eŋe aŋaine mi aŋaŋge ");
INSERT INTO ons_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Eŋe maket biraka more zok manerop mabaik kakoi, paki eŋe dongo biraka more eŋano don mane koboine mi rakoi, so eŋine tego me dokoine mane maŋo ŋei ŋerewekoune eŋano don kisi maine okangi rap? Midakaka, ea wane eŋe gegeine mau siukke, paki eŋe kepeo gegine ea koso mi geke.” ");
INSERT INTO ons_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ŋei yewa eŋe papia ea dapotki qoeki, eŋe Pilip olatke, “Na qeson ganbe, propet eŋe maŋane ra more don yewa rake? Eŋe eŋinane rake, me eŋe ŋei mane wane rake?” ");
INSERT INTO ons_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ea wane Pilip eŋe ŋei yewa don dapotke, ea wane kine ra wakone olatke, ea wane ŋadino yemo eŋe Anutu wane sigi maep ra qelaŋane more, Yesu wane kine natno kito olat wareke. ");
INSERT INTO ons_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Eŋe numaka ari mage doku mane yewao ari lotkekoik, paki ŋei yewaŋo rake, “Doku kanom pamaike, ŋo na onokaŋo numane leŋnangi, na miti doku mi taumaile?” ");
INSERT INTO ons_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pakimo Pilipŋo rake, “Ŋo ge wetŋoneŋo korop malip kakeneo, ea yemo ge maine taugangale.” Eŋe don mainge rake, “Na Yesu Kristo malip kamaile, eŋe Waom wane medep.” ");
INSERT INTO ons_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pakimo, eŋe horsi kare ware ware olatki, ma walukkaki okorake, paki Pilip so ware ware ŋei yewa ere dokuo ket more so Pilipŋo eŋe taukake. ");
INSERT INTO ons_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pakimo, ere doku qeliŋka more sauk, eaka ikop Waom suainane Asuŋo Pilip ma arike, so ŋei ware ware eŋe koso mi kake, eŋe bakom kito more so numaine eaka mogare arike. ");
INSERT INTO ons_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ŋo Pilip eŋe Asdot matko lotke more, mat suaine loutne yewa ari korop Yesu wane sigi maep don ra qelaŋane ari mage ŋado baŋ Sisaria matko ari lotkeke. ");
INSERT INTO ons_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Naso yewao Saul eŋe Waom suainane dokoine engu mataliongi, seukei wane don togogole rake, ea wane eŋe Mosop Ŋei Ŋetne Suaine eŋano ari, ");
INSERT INTO ons_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","olale rake, “Ge kibi mane Yuda magu Damaskus matko gemami, eŋane qe ninnom, ge iwa yale qekene, ‘Ŋene Saul iwa bira kaŋem ŋinano umaike, eŋe ŋei so ŋerep magu Yesu mogat kamami, ea ziaŋge ebu ma waraŋone, Yerusalem sari mulap urumgo biraoniake, ea wane birakamaine.’” ");
INSERT INTO ons_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Eso Saul eŋe Yerusalem mat qelige more, moea Damaskus arike, eŋe ari Damaskus osino lotkeki, ikop eaka qelaŋan mane qeliwo ŋine yewaka eŋano ket more qelaŋan kake. Qelaŋan yewa mo zok manerop togogole. ");
INSERT INTO ons_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Paki Saul eŋe mo eaka kepo ket rasu pa more, detki ŋei maneŋo don mane iwa yale olale rake, “Saul, Saul, ge onoka wane na neku matali qetali okan nanmaine me?” ");
INSERT INTO ons_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul eŋe rake, “Waom, ge maŋo?” Pakimo eŋe rake, “Na Yesu, ge na zok manerop matali qetali okan nanmaine. ");
INSERT INTO ons_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ŋo ge siluŋ wie more, Damaskus mat suaino waketnom, pakimo baŋ ŋado ŋei maneŋo ge kine kine mane onokaka makene, ea eŋe golasiake.” ");
INSERT INTO ons_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ŋo ŋei natne eŋe Saulrop weneŋ arikoi, eŋe doneene midaki, zonomene ketki okorakoi, so eŋe don rake, ea detkoi, ŋo eŋe ŋei eŋine mane mi kakoi, ");
INSERT INTO ons_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul eŋe wie deine pore kaki, deine zok mupke panamange, ea wane eŋe qesiŋka more, metino malipka ma ari Damaskus matko waketkoi. ");
INSERT INTO ons_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Eŋe kaiwe karewe yale deine yeka mupke metki, eŋe ŋara doku mi neke yaupka pake. ");
INSERT INTO ons_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Yesu wane qelit ŋei mane eŋe Damaskus matko geke, ŋei ea eŋetine Ananias, eŋe kulu kulu mane kaki, Waomŋo Ananias orake, paki eŋe olale rake, “Ananias!” Ananias eŋe dere more mainge rake, “Waom, na iwa metmaile.” ");
INSERT INTO ons_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Waom eŋe Ananias olale rake, “Ge wie, numa eŋetine, ‘Numa Koboine,’ yewaka ari Yudas wane matko wa more, ŋei mane eŋetine, Saul, eŋe Tarsus matko ŋine, eŋe ka more, eŋine eŋetinane qesonnom, so eŋe yewa meŋenka metmaike, ea marat kam paki, eŋine kanom, ");
INSERT INTO ons_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Saul eŋe solainane deine ea mo welekatne mupkeke, ŋo eŋe kulu kulu mane iwa yale kake, eŋe kaki ŋei mane eŋetine, Ananias, eŋe sari saket metine mawa eŋane kutno motke, paki eŋe deine ea koso mo maine menaŋkake.” ");
INSERT INTO ons_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias eŋe Waom wane don dere mainge rake, “Waom, ŋei ŋerep loutne eŋe ŋei ea wane donkisi nolatkoi, eŋe Yerusalem mat kotino geŋane ŋei ŋerep magu masi kine kine qotkoine okan one more zok manerop matalionge, so koso, ");
INSERT INTO ons_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Mosop Ŋei Suaine eŋano ŋine rako rakok kibi maki, ŋei ea iwa Damaskus birakake, eŋe ŋei ŋerep iwa geŋane eŋet gora magemami, ŋei yewa oŋo geŋone magu ea ebu ari mulap urum togole bira oniakane sarimaike.” ");
INSERT INTO ons_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pakiso Suaineŋo iwa yale olatke, “Ge arinom, na ŋei ea naŋane qelit qeqe uratane mayakane mo birakakole, oŋo Israel kotino ŋei ŋerep, so ŋei ŋerep Israel ŋadino qelaŋ gemami, so kepe ware ware suaine, eŋane kaiteno naŋane eŋetne ra qelaŋoniake, ea wane ge arinom, ");
INSERT INTO ons_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","eŋe naŋane ra more wikile desiake, na noŋom wikile kine kine mo ea sikan kaikale.” ");
INSERT INTO ons_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Waomŋo yale raki, Ananias eŋe ari more mat ea wane kotino waket more, metine mawa Saul wane kutno more rake, “Saul kimane, ge iwa sari dumao Yesu kene, Waomze Yesu oŋomka na geŋano bira nanmaike, ea wane Yesu eŋe deŋone ma menaŋgane more, Asu Koboboine qe watke more rokop ganiake.” ");
INSERT INTO ons_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananias eŋe don olatki qoekiso, ikop yewaka kine kine natne, zawon lesoine yaleŋo Saul wane deino ŋine qoe qake ketpi, deine menaŋge, so eŋe wie okoraki mo Ananiasŋo doku taukake. ");
INSERT INTO ons_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Saul eŋe ŋara neki ŋado zonomine koso motke. Saul eŋe malip malip ŋei ŋerep eŋerop Damaskus matko kaiwe kareweka geke, ");
INSERT INTO ons_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","so eŋe Yuda lewa lewaŋ urumgo koboine ari more, Yesu eŋe Anutu wane gipole ea ra qelaŋange. ");
INSERT INTO ons_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ŋei ŋerep korop eŋe Saul wane don ea dere more, oŋaene qaeki, auye rakoi, “Ŋei yewaŋo ŋei ŋerep loutne eŋe Yesu wane eŋet ora bukeu wake, yemo korop mo Yerusalem mat kotino ŋine enguki seuke siukwarekoi, wane eŋe koso ŋei ŋerep ea yaline eŋe ebu more Mosop Ŋei Suaine, eŋano bira oniakane matzo iwa sarike.” ");
INSERT INTO ons_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ŋo Saul wane don raraineŋo yemo zok manerop zonominerop, ea Yuda eŋane Damaskus matko ra qelaŋange, so Yesu eŋe Kristo eŋe kepe ŋei magu borikino ŋine makok ŋoniakane, Magakŋo birakaki ketke, eŋe Saul wane don ea dere more Yuda ŋei Damaskus gekoi, oŋaene qaeki qiseu paki, don natne ra maket birakakei wane mi okangoi. ");
INSERT INTO ons_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kaiwe loutne qoekiso, Yuda edo lewage more Saul qeu seukeakane don numaine ra ma togolekoi, ");
INSERT INTO ons_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ŋo ŋei maneŋo Saul don dereret ea mo olatke, paki Yuda ŋei eŋe mat suainane madet baŋem ea mo korop warekoi, ea mo ruoo so kaiweo Saul qeu seukeakane ra more yale okangoi. ");
INSERT INTO ons_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ŋo ruo mane Saul wane dokoine, eŋe Saul ma more mat wane wesi sen aŋaine mau lotkeki iwenka ari rosa suaine kotino birakau waket metki, so dokoine eŋe rosa mulapŋo bororom bororom mau qoroŋ qoroŋ ket kepo kitoki, Saul eŋe saket arike. ");
INSERT INTO ons_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul eŋe Damaskus qelige more, Yesu wane dokoine marat oniakane Yerusalem arike, eŋe Yesu dokoine eŋerop weneŋ lewaŋgoi wane ra arike, ŋo Yesu wane dokoine eŋe Saul mo Yesu wano takotkike, ea wane donkisi yewa dere mi malip kakoi, yemo eŋe koropŋo manerop zok kaetonge. ");
INSERT INTO ons_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pakiso, Barnabasŋo Saul qesiŋka more, aposolo eŋano iwenka ari edange, “Waomzeŋo Saul Damaskus matko numao maratka more olatke, Saul eŋe Yesu wane eŋetko Damaskus kaet midaine ra qelaŋange.” ");
INSERT INTO ons_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Yale raki, so Saul eŋe aposolo eŋerop weneŋ geke, eŋe Yerusalem mat korop ari sari ge more, Waomzane eŋet kaet midaine ra qelaŋange, ");
INSERT INTO ons_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ea wane Yuda ŋei natne eŋe Grik don rakoi ea Yerusalem gekoi, Saul eŋe ŋei ea don ra kitat okane aukoi, ŋo ŋei eaŋo Saul qekei wane ra numa dale maratka more qeŋem seukeake ra okangoi. ");
INSERT INTO ons_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pakimo, doku tau tau magu eŋe don kisi ea dere more, Saul Sisaria matko iwenka ari more birakau, Tarsus matko arike. ");
INSERT INTO ons_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Saul eŋe ariki, so doku tau tau magu korop Yuda kepeo, Galili kepeo so Samaria kepeo eŋe ŋei maneŋo mi borikine kine kine mane okanongi, eŋe korop peamine gekoi, Asu Koboineŋo doku tau tau magu qesiŋongi togolekoi, maguo ŋei ŋerep zaleene suakiso ŋei ŋerep korop eŋe Waomze ewino kito gekoi. ");
INSERT INTO ons_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petoroŋo mat baŋem mat baŋem ari sari okange, so Anutu wane ŋei ŋerep natne Lida matko gekoi, atak mane Petoroŋo ŋei ŋerep ea eŋano ari geke. ");
INSERT INTO ons_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Naso yewao ea ge more, ŋei mane eŋetine, Ainias maratkake, Ainias wane kie metine yemo zok seu seune pake, ea wane Ainias eŋe koma eit(8) yaline kulu papainoka naso baŋem pageke. ");
INSERT INTO ons_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petoroŋo Ainias olatke, “Ainias, Yesu Kristoŋo ma menaŋ ganmaike, ge wie kulu papaŋone maulukenom!” Raki, ikopka Ainias eŋe aŋaine teweke, yewa kamde eweke more wieke. ");
INSERT INTO ons_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lida matko ŋine ŋei ŋerep korop so Saron kepe mat digin togogole ŋei ŋerep yewa gekoi, eŋe Ainias kau, mo menage wekumane okange, yale ka more, eŋe wet maingeu paki, zinge Waomze mogat kakoi. ");
INSERT INTO ons_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Naso yewao, mali malip ŋerep mane, eŋetine Tabita Hebru dongo, Yopa matko geke, eŋane eŋetine mane Grik dongo ea mo Dorkas, eŋet ea wane kineine, yemo noniŋ zuba, ŋerep ea Yesu mogat ka more naso baŋem naso baŋem masi weku mane ma more, ŋei ŋerep aboŋene midaine qesiŋonge, ");
INSERT INTO ons_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","naso yewao Petoro eŋe Lida wane matko geke, naso maneo yemo Tabita zoma suaine zok manerop kaki pa eaka seukke. Seuki so kimakoune eŋe pareŋine ea saukka more, mat aŋaone mane kutno weti yewao birakau pake. ");
INSERT INTO ons_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa ea mat amaŋ mida, bamgo Lida osino metke, ea wane doku tau tau ŋei ŋerep Yopa gekoi, eŋe Petoro wane don kisi dere more don more more ŋei etke Yopa biraotpi, Petoro wano ari olatkoik, so eŋe rakoi, “Ge siluŋ mi mesikene, ge ikop ŋenano sarinom, ŋerep mane eŋe mo seukeakane okanmaike, ge siluŋ ikop mide biririke sarinom!” ");
INSERT INTO ons_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petoro eŋe aboŋine mauluke more, ererop weneŋ ari Yopa matko lotkeke, pakiso eŋe Petoro iwenka ari mat kutno weti aŋaine mane yewao wakoi. Ŋerep mala loutne eŋe urum eao watke rokopkekoi, Dorkas eŋe wisika geke, naso ea eŋe takot suaine so nigatne loutne ma more, ŋei ŋerep aboŋene midaine ebonge, ŋerep mala yewa eŋe takot ea Petoro sikanka more arokkoi. ");
INSERT INTO ons_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petoroŋo ŋerep korop urumgo ŋine raongi ket wareu eŋe wa wetine qe meŋenka more zinge pareŋ olatke, “Tabita wienom!” Yale raki so deine pore Petoro kaki paki mo eaka wie more metke. ");
INSERT INTO ons_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petoroŋo metino ma qesiŋkaki wie okorake, pakiso, eŋe doku tau tau ŋei ŋerep so ŋerep mala edora more, Tabita mo wisikae wie more, koso gege maratkamaike, ea edane sikanongi pakiso, birakaki metke. ");
INSERT INTO ons_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Don kisi yewa Yopa mat Petoroŋo make, ea wane korop lolike watke rokopkeke, ea wane ŋei ŋerep loutne eŋe Waom detlukka malipka more mogat kakoi. ");
INSERT INTO ons_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pakiso, kaiwe loutne Petoro eŋe Yopa matko geke, so ŋei mane, eŋe bulamakau so osom solaine natne ma urata natne eaŋo mamaŋke, ŋei yewa wane eŋetine Saimon, eŋe ŋei ea eŋerop eŋane matko geke. ");
INSERT INTO ons_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ŋei mane Sisaria matko geke, eŋetine Kornilius, eŋe Roma kawali ŋei magu(100) eŋane ŋetne. Kawali ŋei magu ea eŋane eŋetene “Italian wane kawali ŋei magu.” ");
INSERT INTO ons_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornilius eŋe Anutuŋo onokaka wane simin kamaike, ea malipka more ewine kitoke, eŋine so dokoine korop eŋe Anutu wane bango tamge more, eŋetine ma bukeu wake, so eŋe Yuda ŋei aboŋene midaine qesiŋ onmaŋke, ŋo meŋe meŋen yemo Anutu wano meŋenka mageke. ");
INSERT INTO ons_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Rarap maneo 3 kilok, kepe qoe qoe naso, eao eŋe kulu kuluo yale kine kine mane kake, eŋe Anutu wane aŋeloŋo tingo kaki, aŋeloŋo eŋe sari mat koto saket olale iwa yale rake, “Kornilius!” ");
INSERT INTO ons_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pakimo, Kornilius eŋe eŋano pore kalilipka more, kaetkaki siluŋ rake, “Waomne daleo?” Aŋelo eŋe donine mainge rake, “Anutuŋo geŋane masi weku mane ŋei ŋerep wesi aboŋene midaine geu, ge qesiŋ onmaine so kine kine wane qekau, ge mapik onmaine, ea mo Waomŋo ka more meŋen meŋenŋone dere more, siminkaki qesiŋ ganiake. ");
INSERT INTO ons_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ge nasomde iwaka ŋei mane bira onnom ari, ŋei mane eŋetine Saimon, ŋo maneine Petoro, eŋe Yopa gemaike, iwa iwenka sarikei wane bira onikene. ");
INSERT INTO ons_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Petoro eŋe Saimon osom solaineŋo kine kine mama eŋane matko kulit gemaike, Saimon eŋe matine yemo kiwet mezeno gemaike.” ");
INSERT INTO ons_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aŋelo, eŋe yale ra more Kornilius don olatki qoeki arike, pakimo Kornilius eŋe ŋei etke etoraki sarikoik, ŋei mane eŋe Anutu ewine kito more Kornilius wane matino geke, eŋe Kornilius maulukka mageke. Kornilius eŋe ŋei ea so kawali ŋei mane so qelit qeqe ŋei etke edoraki sarikoi. ");
INSERT INTO ons_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Sariu so Kornilius eŋe kine kine wakonge ea wane done edane more mauluke, so Yopa biraongi arikoi. ");
INSERT INTO ons_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Korniliusŋo ŋei biraonge, eŋe ari mage numao pakoi, kepe qaeki, ŋei etke so etke ea eŋe Yopa osino ariuso, kepe deine mo oŋa bango okangi, mo Yopa matko lotkekoi, pakiso naso yewao Petoro eŋe tiri woka mat bakino kutno meŋen kayakane wake. ");
INSERT INTO ons_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Yewa meŋenka more ŋara wane seuke more, qelit qeqe ŋei mane ŋara maulukeakane olatke. Qelit ŋei eŋe ari ŋara maulukki, so Petoro eŋe kulu kulu yale kine kine mane de kuneŋine kake. ");
INSERT INTO ons_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Petoro eŋe kaki qeli aŋaŋgi, kine kine mane ketke, ea yemo lap lap kakapa suaine mane yale wakonge, eamo wazaine etke so etke pise pisiine ea yale waka metki, laplap ea bira qesuŋkaki, kepeo qeredege ket sarike. ");
INSERT INTO ons_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Osom kine mane kine mane, koma, logum, parewa, naŋi zubaine, ea eŋe korop laplap ea wane kotino watke pakoi. ");
INSERT INTO ons_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ŋei maneŋo Petoro olatke, “Petoro, ge wie qe nenom!” ");
INSERT INTO ons_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pakimo, Petoroŋo mainge rake, “Waomne, na maine mi okanikale, Mose eŋe osom kine kine iwa pamami, ea korop qotkoine, Yuda tegoŋo mi nenine rake, sogino na osom yaline mane mi nekole.” ");
INSERT INTO ons_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ŋei eaŋo Petoro koso olatke, “Anutuŋo kine kine ra sauk okangi libeka okange, ge maine misuk raikene, ‘mi nenine’ . ");
INSERT INTO ons_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Laplap ea atak karewe ket wakongiso, koso ikopka qeliwo mainge more waraŋgi kerewake.” ");
INSERT INTO ons_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Waki, so Petoro eŋe dereret urata so dere qeka okane more rake, kulu kulu iwa kele, ea wane kine yemo daleo? Eŋe dereret urata yale ma metkiso, ŋei magu natne Korniliusŋo biraonge, eŋe lotkekoi, eŋe sari lotke more, ra qeson okane rakoi, Simon wane mat, eamo diawao metmaike? Eŋe yale ra qesone ari mageso, madetko lotke more yewa okorakoi. ");
INSERT INTO ons_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","So eŋe qesone more iwa yale rakoi, “Ŋei mane eŋetine Simon Petoro eŋe iwa kulit gemaike, ŋei ea eŋe iwa metmaike me mida?” ");
INSERT INTO ons_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ŋo Petoroŋo yemo eŋe kulu kulu kake ea wane kine desiakane ziaŋka mat kutno weti metke, naso yewao Asu Koboboine eŋe Petoro olatke, “Detnom, ŋei karewe eŋe qelawa sari ge ziaŋ ganmami. ");
INSERT INTO ons_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yale wane ge wie ketnom, na ŋei ea biraonbe sarimami, ea wane ge aboŋone mauluke more ikop ket eŋerop arinom, ge dereret urata koso misuk maikene, ŋei yewa noŋom biraonbe sarimami.” ");
INSERT INTO ons_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Rakiso, Petoro eŋe ŋei ea eŋano ket ŋei ea edange, “Ŋei iwa ŋine na ziaŋ nanmami, yemo na iwa, ŋo ŋine onoka wane sarimami?” ");
INSERT INTO ons_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yale rakiso, ŋei ea eŋe mainge olatkoi, “Kawali ŋei magu(100) eŋane ŋetne, eŋetine Kornilius, oŋo bira ŋongi sarimaine, oŋo ŋei wele, eŋe Anutu eŋetine ora mawa kamaike, so Yuda ŋei ŋerep Kornilius ewine kito okanmami. Anutu wane aŋelo mane oŋo Kornilius olatke, eŋe goŋo don mane daleo ra qelaŋane olatnom desiakane newan ganmaike.” ");
INSERT INTO ons_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petoro eŋe don ea dere more, ŋei ea eŋe mat yewao ruoo kulu paikei wane newanonge. Kepe qaeki, Petoro eŋe aboŋ mauluke more, eŋerop arike, doku tau tau ŋei ŋerep natne, Yopa ŋine eŋe eŋerop weneŋ arikoi. ");
INSERT INTO ons_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Petoro so ŋei magu ea eŋe ari mage numao pakoi, qaekiso kaiwe maneo Petoro eŋe Sisaria matko lotkeke, Kornilius eŋe weŋem sotakkoune so kimakoune natne newan ongi, sari matino Petoro toma kakoi. ");
INSERT INTO ons_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petoro eŋe matko wayakane okoraki, Korniliusŋo maratka more Petoro wane kino kepeo ket rasu more, umi ket kaitne kepeo uakake. ");
INSERT INTO ons_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ŋo, Petoro eŋe maki wieki olatke, “Wienom! Na kepe ŋeika.” ");
INSERT INTO ons_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petoro eŋe Kornilius don olatki, ari mat koto wakoik, ŋei ŋerep loutne lewage more erane toma metkoi. ");
INSERT INTO ons_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petoro eŋe yale edange, “Ŋidom detlukmami, Yuda ra rokop don togonŋo iwa yale ramaike, Yuda ŋei mane eŋe Yuda tego ŋadino, qelaŋ ŋei, eŋerop maine kulit mi geake, so Yuda mane eŋe tego ea eŋane osoeno mi ariake, ŋo na yemo Anutu oŋom mo sikan nanike, Anutu wane deino me kaitko, na mi raikale, Anutu wane zonom me deinane qelaŋanŋo ŋei mane wane sot turuŋ me panaman mane mi mataliki siukeake, ea midakaka. ");
INSERT INTO ons_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ea wane na ŋinane don dere mi qile, na ŋinane don boka woka ea dere iwa sarile, ea wane na qeson ŋunmaile, ŋine onokaka wane rau na sarile? Eaka rau na detpe.” ");
INSERT INTO ons_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pakimo, Kornilius eŋe mainge iwa yale rake, “Kaiwe karewe bano, naso yewao, 3 kilok na matne koto mere meŋen kakole, ikopka ŋei mane laplap qelaŋinerop eŋe naŋane kaitno okora more, ");
INSERT INTO ons_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","nolatke, ‘Kornilius! Anutuŋo geŋane meŋe meŋen dere more geŋane masi weku mane kake, ");
INSERT INTO ons_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ea wane ge ŋei mane Yopa bira kanom, eŋe ari Saimon Petoro maratka more, iwa sariakane olatkep, Petoro eŋe Saimon, osom solaine mama eŋerop metmaike, eŋe matine kiwet osino kulit gemaike’ . ");
INSERT INTO ons_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yale raki, so na ikopka ŋei natne biraonbe sariu mo, ge masi weku mane okane more sarimaine. Naso iwao, ŋene korop Anutu wane kaitko mere geŋane don desikenane tomamaine. Anutuŋo ge kine kine ginge, ge ea korop ra qelaŋannom desikene.” ");
INSERT INTO ons_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kornilius eŋe yale rakiso, Petoro eŋe kieke rake, “Na iwa mo detlukmaile, Anutuŋo ŋei ŋerep korop eŋano masi tego wekuka raki paki detongi, magu weku okanmami. ");
INSERT INTO ons_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ŋei ŋerep kepe baŋem maguine maguine, eŋe Anutu ewine kitokeiwo, so koboine ge okanikeiwo, Anutuŋo ŋei ŋerep ea eŋane simin kaki qesiŋ oniake. ");
INSERT INTO ons_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ŋine don iwa yale eamo detmami, Anutuŋo Israel tego ŋebonge, eŋe sigi maep don iwa yale ra qelaŋange, Yesu Kristo eŋe kepe baŋem ŋinane Suaine, oŋo ŋebuki, ŋene Anuturop wet weku okangone, ŋine ea korop detlukmami. ");
INSERT INTO ons_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ŋine ŋidom kine kine korop wakonge, eamo detka waremami, eamo Israel kepeo Yohaneŋo ŋei ŋerep doku tauonge, sigi maep ra qelaŋange, ea wane ŋadino mo korop wakon wareke, Yesuŋo urata eamo Galili kepeo kieke more, maki takotke kepe baŋem rokopke ari wareke, ŋine eamo korop detlukmami. ");
INSERT INTO ons_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Anutuŋo Yesu, Nasaret ŋine Asu Koboboine zonominerop qe watke rokopkake, Yesu eŋe kepe baŋem lolike korop masi weku mane ma more, ŋei ŋerep Satan wane asu qotkoinerop ma menaŋ onge. Anutuŋo Yesurop geke, ea wane, eŋe kine kine maki, ea wakonge, ŋine ea korop detlukmami. ");
INSERT INTO ons_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yesu eŋe kine kine Israel eŋane kepeo so Yerusalem kotine make, ŋene ea korop kakone, pakiso eŋe Yesu kibego qeu seukke. ");
INSERT INTO ons_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ŋo, kaiwe mama karewe kutno Anutuŋo eŋe ma wisikaekaki, wie more ŋei ŋerep eŋano wakonge. ");
INSERT INTO ons_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ŋei ŋerep korop eŋe mi kakoi, Yesu eŋe seuseuo ŋine koso wisikae wieke, Anutuŋo ŋene bira ŋongi, ŋene koso Yesurop weneŋ doku so ŋara nekone. ");
INSERT INTO ons_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","So Yesu eŋe ŋene urata don ŋebone more ŋedange, ŋene ŋei ŋerep eŋano miti don iwa yale ra qelaŋanikenane ra ŋedange, Anutuŋo Yesu eŋe ŋei ŋerep wisikaune so seuseune kineene ma wanokoniakane birakake, ŋene don ea ŋei ŋerep edangene. ");
INSERT INTO ons_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Anutu wane qelit ŋei propet eŋe korop Yesu wane don ra qelaŋangoi, paki, eŋe iwa yale rakoi, ŋei mane eŋe Yesu wane don dere mogat kayakeo, eŋe Anutuŋo ŋei ea wane sot turuŋine ea korop Yesu wane eŋet malipka maikane, qeliŋka maniake.” ");
INSERT INTO ons_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petoro eŋe sigi maep don ra okoraki, eaka Asu Koboboineŋo ŋei ŋerep korop Anutu wane don dere metkoi, eŋane kuteeno ketke. ");
INSERT INTO ons_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Yuda tegoo ŋine doku tau taune Petororop weneŋ sarikoi, yewa eŋe detpi don kuneŋine kine mane kine maneoka, Anutu bakom kito eŋetine ore ma wiekoi, paki eŋe dereretene qeyauki qise more, iwa yale rakoi, “Kau, Anutu eŋe qelaŋ ŋei ŋerep Asuine Koboboine ebone more, mainongi eŋane biŋek mo okanmami.” Pakimo, Petoroŋo iwa yale rake, ");
INSERT INTO ons_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ŋei ŋerep tego iwa Asu Koboboine mo mamami, eŋe mo ŋenze rokop okanmami, ea wane mo koso maŋo mane doku taukei wane rawetoniake?” ");
INSERT INTO ons_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","So Petoro eŋe koso ŋei ŋerep yewa eŋe edange, “Ŋine ukude mo iwa Yesu Kristo wane eŋetko doku taukei!” Eŋe doku tauwi qoekiso, eŋe koso eŋerop kaiwe mama natne weneŋ gekei wane ra olatkoi. ");
INSERT INTO ons_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Petoro eŋe qelaŋ ŋei ŋerep Yuda ŋadino Anutu wane don edange, aposolo natne so mali malip magu Yuda kepe korop Anutu wane don kisi ea detkakoi. ");
INSERT INTO ons_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Naso yewao mali malip magu keueno ŋine ŋei natne edo iwa yale rakoi, “Ŋei qelaŋ natne Yuda ŋadino eŋe Yesu mogat kakei wane, yaene solaine kitasikei.” Pakimo, Petoro eŋe Yopa ŋine zinge Yerusalem ari lotkeki paki, Yuda ŋei edo Petoro ra wetkakoi, ");
INSERT INTO ons_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Eŋe iwa yale rakoi, “Ŋei ea eŋe yaene solaine mi kitatkoi, ge eŋane matko arikone, ari ŋei yewa eŋe yaene solaene mi kitatkoi, ge eŋerop mere ŋara nekone!”. ");
INSERT INTO ons_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Yale rau so Petoro eŋe kine kine wakonge, ea korop ra qelaŋane edange. ");
INSERT INTO ons_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Kaiwe mane na Yapa matko meŋenka more kulu kulu mane kakole, laplap suaine wakonge, kine kine natne eŋe laplap ea nat parom etke so etke piseke so yale waka laplap qeliwo ŋine qeredege ket more, naŋane osono lotkeke, ");
INSERT INTO ons_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","na mat osomine, osom zubaine, koma, logum, parewa so naŋi zubaine laplap kotino ongole. ");
INSERT INTO ons_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Pakiso, ŋei maneŋo nolatke, ‘Petoro, ge wie more engu nenom!’ ");
INSERT INTO ons_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ŋo, na mainge rakole, ‘Waom, na mi okanikale midakaka! Mose eŋe osom kine kine mi nenine rake, sogino na osom ea mi nekole’ . ");
INSERT INTO ons_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ŋei ea qeliwo ŋineŋo koso nolatke, ‘Anutuŋo kine kine ea mo raki libeka okange, ge maine misuk raikene, ‘mi nenine.’ ");
INSERT INTO ons_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Atak karewe laplap ket wakongi kawe, so koso qeliwo wake. ");
INSERT INTO ons_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Naso yewao Kornilius wane ŋei karewe Sisaria ŋine Simon wane matko lotkekoi. ");
INSERT INTO ons_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Asu Koboboineŋo naŋano wakonnane rake, ‘Ge eŋerop ikop arinom.’ Ŋei 6 ŋenze mali malip magu, Yopa ŋine eŋe narop weneŋ Siraria arikoi, paki ŋene koropŋo Kornilius matko wa ketkone. ");
INSERT INTO ons_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Eŋe eŋine donkisi ŋedange, eŋe aŋelo maneŋo matine koto wakonkaki paki olatke, ‘Ge ŋei mane Yopa birakanom, eŋe ari Saimon Petoro maratka more, iwa iwenka sariake. ");
INSERT INTO ons_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Petoroŋo don welerop ŋidaniake, ea wane Anutuŋo ge so dokoŋone baŋ korop ma menaŋ ŋuniake’ ");
INSERT INTO ons_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Pakiso, na eŋe don kieke edanbe, so Asu Koboboineŋo eŋane kuteno ketke, Asuŋo sogino ŋenane kutzo ketke, masi yaleka okane ketke. ");
INSERT INTO ons_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ketki, so na don mane detsorokkole, Waomzeŋo rake, ‘Yohane eŋe ŋei ŋerep doku tauonge, ŋo, noŋo ŋine Asu Koboboine ŋibonikale.’ ");
INSERT INTO ons_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Sogino ŋene Waomze Yesu Kristo mogatkaŋem so Anutuŋo ŋene Asu Koboboine ŋebonge, naso iwa na kaulukmaile, yalewaka, Anutuŋo qelaŋ ŋei ŋerep Yuda ŋadino, Asu Koboboine ebonge, na Anutu maine mi rawetkakole!” ");
INSERT INTO ons_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Petoro eŋe raki qoeki, mali malip magu eŋe dere more, Petoro mi rawetka more, Anutu wane eŋetine mau waki rakoi, “Anutuŋo rake, ‘Ŋei ŋerep qelaŋ, Yuda ŋadino, eŋe sotene ŋadek kaikeiwo, na eŋe ebuwe gege togongo wakesikei.’” ");
INSERT INTO ons_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Naso sogino Kaunsol eŋe Stiwen qeu seukki, so mali malip ŋei ŋerep wikile suaine detkoi, ea wane kakak nagu arikoi, eŋe Yerusalem ŋine Ponisia kepe, Saiprus sia so Antiok matko arikoi. Eŋe Yuda ŋei ŋerep eŋanoka don kisi maine ra qelaŋane edangoi. ");
INSERT INTO ons_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ŋo mali malip ŋei natne, Saiprus sia so Sairin matko ŋine eŋe qelaŋ ŋei ŋerep, Yuda ŋadino gekoi, eŋano yaleka ra qelaŋane edangoi, eŋe Waomze Yesu wane don kisi maine Antiok matko ra qelaŋane edangoi. ");
INSERT INTO ons_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Waomzeŋo ŋei ea zonom ebonge, ea wane ŋei ŋerep loutne eŋe Waom malipka more, Waom wano wetene maingekoi. ");
INSERT INTO ons_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mali malip magu Yerusalem kotino gekoi, eŋe donkisi ea dere more Barnabas, Antiok matko birakau arike. ");
INSERT INTO ons_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabas eŋe Antiok ari lotke more, so Anutuŋo dalino ŋei ŋerep mosop onge, eŋe ea ka more bakomine kitoke. Eŋe ŋei ŋerep qebinone rake, “Ŋine Waomze wetŋineŋo naso baŋem malip kaikei.” ");
INSERT INTO ons_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas eŋe ŋei wele, mali malip so Asu Koboboineŋo eŋano watke rokop kake, ea wane ŋei ŋerep loutne eŋe Waom mogat kakoi. ");
INSERT INTO ons_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Urata ea qoeki so Barnabas eŋe Tarsus matko ari Saul ziaŋkake. ");
INSERT INTO ons_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Barnabas eŋe maratka more, Saul iwenkaki ere Antiok arikoik. Koma weku Saul so Barnabas mali malip magu eŋerop lewaŋgoi, ere ŋei ŋerep magu suaine kito ebongoik. Antiok mat welaine eŋe malip malip magu eŋane masi ka more, eŋetene “Kristen” edorakoi. Eŋet iwa sogino mi wakonge. ");
INSERT INTO ons_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Naso yewao propet ŋei natne eŋe Yerusalem ŋine Antiok arikoi. ");
INSERT INTO ons_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ŋei mane, eŋetine Agabus, eŋe mali malip magu keueno wie okora more, Asu Koboboine eŋane zonomineŋo olatki rake, “Ŋara wane bodi suaine kepe baŋem kepe baŋem wakoniake”. Naso Klaudius, Roma kepe ware ware geke, naso ea ŋara wane bodi wakonge. ");
INSERT INTO ons_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mali malip magu, eŋe lewage rau togoleke, “Ŋene bonep bonep wesi aboŋze wane kop qeturage more, mali malip kimaze Yuda kepeo birakakene.” ");
INSERT INTO ons_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Yale ra more wesi aboŋ qeturage more, Barnabas so Saul eponbi, so Barnabas so Saul ere Yerusalem ma ari more, mali malip magu ŋei suaine ebongoik. ");
INSERT INTO ons_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Naso yewao kepe ware ware Herot eŋe mali malip magu wikile kieke ebonge. ");
INSERT INTO ons_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Eŋe kawali ŋei koune edangi eŋe Yakop, Yohane wane tatine pilaŋŋo qeu seukke. ");
INSERT INTO ons_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herot eŋe masi ea maki, so Yuda ŋei ŋerep eŋe kau siminonge, ea wane eŋe kawali ŋei koune biraongi, so eŋe Petoro mulap urumgo birakakoi, Yuda eŋane zonom ma met met nasoo so mere bret sap saune ne okangoi, naso yewao. ");
INSERT INTO ons_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Eŋe Petoro malipkaki paki, mulap urumgo birakaki waketke, paki kawali magu etke so etke, eŋe Petoro ea eŋane meteo birakake, paki eŋe eŋane diam okorakoi, paki tego etke so etke ea ŋine mapok ongi, kawali ŋei eŋe koso etke so etke so etke so etke okangoi. Paki Herot eŋe detke, ŋado Aŋelo Loloŋon Loloŋon Naso qoeki, eao Petoro ma ari more ŋei ŋerep eŋane kaitko qewe seukeake. ");
INSERT INTO ons_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Herot eŋe Petoro mulap urum koto birakaki metke, ŋo mali malip ŋei ŋerep eŋe Petoro wane ra more Anutu wano togole meŋenkakoi. ");
INSERT INTO ons_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Qaeki Herot eŋe Petoro iwenka ari dongo birakayakane wetkeke, ŋo qei kino mi okangi, ruoo Petoro eŋe kawali ŋei etke erane keuetno kulu pake, eŋe mulap senŋo lukkakoi, ŋo kawali ŋei eŋe mulap ŋei eŋane mat madetko diam okorakoi. ");
INSERT INTO ons_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ikopka, Anutu wane aŋelo maneŋo mulap urum koto okoraki, so qelaŋaneŋo mulap urum koto qelaŋange. Aŋelo eŋe Petoro wokino ma wirikaki wieki olatke, “Ikop! Wienom!” Raki eaka ikopka mulap metino ŋine qoe ketke. ");
INSERT INTO ons_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Pakiso aŋeloŋo olatke, “Ge radepŋone ramu more kie kulitŋone bira makatakenom.” Petoro eŋe yale okangi, aŋeloŋo koso olatke “Ge momo takotŋone bira more na mogat nanikene”. ");
INSERT INTO ons_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petoro eŋe aŋelo mulap urumgo ŋine mogatka saketke. Kine kine iwa wakonge, Petoro eŋe mi detlukkake. Eŋe wetke rake, “Kulu kulu mane kamaile,” yale ra wetkeke. ");
INSERT INTO ons_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ere kawali ŋei magu mane ea yuan ongoik. Paki ere koso ari kawali ŋei magu mane ea yuanone more, mulap urum wane madet suaino lotke more, mat suaino wakesikeik wane ariuk, so madet ea oŋomka qoe lalaŋgi, mat ŋadino waketkoik. Ere numa maneo ketpik paki, ikopka aŋelo eŋe Petoro qeliŋkake. ");
INSERT INTO ons_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pakiso, kine kine wakonge, ea Petoro eŋe detlukka more rake, “Welekatne, Herot so Yuda ŋei ŋerep eŋe na wikile ninikei wane detkoi, ŋo Waomnane aŋeloineŋo birakaki, ket na mulap urumgo ŋine iwennane ketmaike, Herot so Yuda ŋei ŋerep eŋe mi matali nanikei.” ");
INSERT INTO ons_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Petoro eŋe yale dere more Maria wane matko arike, Maria eŋe Yohane Mareko wane nagaine. Ŋei ŋerep loutne mat eao lewage meŋenkakoi. ");
INSERT INTO ons_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petoro eŋe mat madetko lotke more madet ŋadino yatoke. Paki so qelit ŋerep mane eŋetne Roda, oŋo don turuŋine maingeakane sarike. ");
INSERT INTO ons_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ŋerep eŋe Petoro wane done mo detkake, ŋo eŋe qom sua so kaet ŋerep, ea wane eŋe Petoro wane nigetkaki, eŋe madet mi lalage, eŋe zinge ari don kisi ea ŋei ŋerep edange. ");
INSERT INTO ons_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ŋei ŋerep eŋe dere more olale rakoi, “Ge qelaŋ okanmaine!” Ŋo eŋe koso sorinone edangi, ŋei ŋerep eŋe rakoi, “Aŋelo maneŋo sarimaike.” ");
INSERT INTO ons_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Don yale auye rauso, Petoroŋo takotke edoraki, eŋe sari madet lalage more, kau paki, oŋaene qaeke. ");
INSERT INTO ons_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petoro eŋe metineŋo ma zop onge, ea wane ŋei ŋerep eŋe donene midaine metkoi, yale metpiso Anutuŋo dalino okane more, eŋe mulap urumgo ŋine iwenka ketke, Petoro eŋe ea wane korop raqelaŋane more edange paki rake, “Don kisi iwa Yakop so mali malip magu natne korop edan warekei.” Yale ra more eŋe Yerusalem qelige more mat maneo arike. ");
INSERT INTO ons_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kepe qaeki so mulap urum wane diam gege ŋei eŋe kaet suaine ongi, dere mezet okane qesonnagukoi. “Petoro eŋe diao arike?” ");
INSERT INTO ons_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herot eŋe ware ware ŋei loutne edangi, eŋe ari Petoro ziaŋka more mi maratkakoi. Herot eŋe ware ware ea wanokone more kawali ŋei natne edoraki, so eŋe ware ware enguwi seukkoi. Herot eŋe kine kine ea ma more Yuda kepeo qelige more Sisaria matko arike. ");
INSERT INTO ons_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herot eŋe Tire so Sidon mat welaine eŋane sotine osike, paki mat welaine eŋe Herot korop lewaŋgei wane arikoi. Mikepka eŋe Blastus mau eŋane ŋadeeno arike, eŋe Herot wane mat ware ware oŋo qesiŋoniakane eŋe qesonkakoi. Pakiso, eŋe Herot wano ari peam dume niakane, ea wane eŋe Herot olatkoi. Onoka wane Sidon Tire mat welaine eŋe Herot wane kepeo ŋine ŋara aboŋ korop qole okangoi, ea wane eŋe Herot sot osi osiine ea qoeakane sorinka meŋenkakoi. ");
INSERT INTO ons_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herotŋo kaiwe naso mane motke, paki kaiwe naso yewao eŋe ware ware wane kibi auke, paki eŋe ari ware ware met met wane kutno pese metke, eŋe mere don suaine edange. ");
INSERT INTO ons_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ŋei ŋerep eŋe don dere more boka rakoi, “Iwa mo Anutu mane wane aŋa don me ŋei mane wane aŋa don mida!” ");
INSERT INTO ons_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ikopka Anutu wane aŋelo maneŋo Herot qeke. Qeki koma koma eŋe Herot qomine ki lotke neu, so seuke. Onoka wane Herot eŋe Anutu ewino mi kitoke, ea wane aŋeloŋo qeki seukke. ");
INSERT INTO ons_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Naso yewa Anutu wane don takotke more sua matko matko arike. ");
INSERT INTO ons_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas so Saul ere urataetne Yerusalem matko mauk qoeke paki, ere koso zinge arikoik, ari Yohane Mareko ebuwik ererop arikoi. ");
INSERT INTO ons_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiok mali malip magu eŋane keueno ŋine propet ŋei natne so kito ebo ebon ŋei natne eŋe gekoi. Eŋane eŋet tego iwa yale Barnabas, Simeon, eŋetine mane, “sigitne” orakoi, Lusius, eŋe Sairini matko ŋine, Manain, eŋe Herot Antipasrop matetne weku, so Saul ");
INSERT INTO ons_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mali malip magu eŋe Waom qelitine qeu paki, so ŋara wane sawe gekoi. Naso yewao, Asu Koboboineŋo magu ea edane rake, “Na Barnabas so Saul naŋane urata wane mo biraotkole, ea wane ŋine ere bira osikei.” ");
INSERT INTO ons_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Don ea qoeki so eŋe ŋara sawe mere more meŋenkakoi paki, meteene kutetno more so Barnabas so Saul biraotkoi. ");
INSERT INTO ons_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Asu Koboboineŋo Barnabas so Saul biraotki so ere seki zakeo Selusia matko ari seki mane ma more Saiprus siao arikoik. ");
INSERT INTO ons_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ere Salamis matko lotke more, Anutu wane don Yuda eŋane lewa lewaŋ urumgo wa more ra qelaŋangoik. Yohane Mareko eŋe urata qesiŋ osiakane ererop metke. ");
INSERT INTO ons_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Eŋe sia korop kitare ari more, Papos matko lotke more, ŋei mane eŋetine Baryesu marat kakoi, ŋei ea eŋe propet ŋei isisine, eŋe suŋa qare ŋei Yuda tego ŋine. ");
INSERT INTO ons_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Baryesu so sia ware ware ere kima okangoik. Ware ware ea, eŋetine Sergius Paulus eŋe dereretine suaine ea wane eŋe Barnabas so Saul ere eŋane kaitko sarikeik wane etorake, eŋe Anutu wane don desiakane detke. ");
INSERT INTO ons_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ŋo suŋa qare ŋei mane, eŋetine Elimas oŋo kitat otke. Baryesu eŋetine mane Grik dongo rakoi, Elimas. Eŋe Sergius Paulus kitatka rake, “Ge erane don mi dere malip kanom.” ");
INSERT INTO ons_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pakiso, Saul, eŋetine mane Paulo, wie okorake, Asu Koboboineŋo Paulo wane kotoo watke rokopkake, ea wane Paulo eŋe suŋa qare ŋei ea pore kalilipka ");
INSERT INTO ons_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","olatke, “Ge Satan wane gipole! Ge yeye kine kine mayakatne koboboine, ea wane ŋabaine ge matalion okanmaine, masi kine kine qotkoine, eaŋo geŋano watke rokop ganmami. Ge Waom wane don welekatne koboboine, ea naso baŋem maingenom isisine wakon mageake! ");
INSERT INTO ons_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ge detmaine, ukude mo Waom wane meteŋo gekuyake paki, deŋone mo pilikeake paki, ge kepe deine mane mi kaikene. Ge nasomde kirop kirop yale deŋone pilik pilikine gekene.” Raki qoeki, so eaka kine kine mane kezoŋ panaman yale, eaŋo Elimas deine kawetkeke paki, eŋe yau yaup lolike more, ŋei mane maratkaki oŋo metino ma iwen kayakane ziaŋkake. ");
INSERT INTO ons_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pakimo, kepe ware ware eŋe Elimas, ka more Waom wane don detke, ea wane oŋaine qaeke paki, don ea dere malipkake. ");
INSERT INTO ons_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo so kimatkine eŋe Papos qelige more, seki kutno wa more Perga matko Pampilia kepeo ari lotkekoi. Lotke so Yohane Mareko eŋe ere qeliŋore more, Yerusalem matko zinge arike. ");
INSERT INTO ons_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ere Perga mat qelige more Antiok matko, Pisidia kepeo ari lotke more, Yuda eŋane zonom mama naso yewao kaiweo Yuda eŋane lewa lewaŋ urumgo waket metkoik. ");
INSERT INTO ons_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Urum welaineŋo Mose wane ra rokop don so propet edo don qekoi, ea dapotpi qoeki, so eŋe Paul so Barnabas erano don more more rakoi, “Kimatkeze, ŋire don natne ŋene togolekenane ŋedanikeik wane magemamikwo, yemo ŋire ŋei ŋerep maine edanikeik.” ");
INSERT INTO ons_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo eŋe wie more metine ma wake, pakimo, ŋei ŋerep eŋe don midaine metkoi. Yale metpi, Paulo eŋe kieke edange. “Israel ŋei so Israel ŋadino qelaŋ gemami, ŋine korop Anutu ewine kitomami. Ŋine korop naŋane don detpi! ");
INSERT INTO ons_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel wane Anutu eŋe ŋenane ŋabokopze ma wakon ongi, Ezipt kepeo gekoi, Anutu eŋe Israel mosop ongi, so ŋei ŋerep magu suaine wakongoi, Anutuŋo eŋe eŋine zonominerop Ezipt kulit kepeo ŋine ebu iwenone sarike, ");
INSERT INTO ons_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","paki, eŋe koma 40 eŋane masi qotkoine ea wane kepe yaup papaino tewekone geke. ");
INSERT INTO ons_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Anutuŋo ŋei ŋerep magu 7 Kanan kepeo mataliongi siukkoi, pakiso eŋe eŋine ŋei ŋerep Israel magu koune ebu biraongi, Kanan kepe ea wane welaine okangoi. ");
INSERT INTO ons_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Paki, kepe ea eŋe koma 450 yale malipkka gekoi. “Naso ea qoeki, so Anutu eŋe Israel eŋane wano wanok ŋei waom natne biraonge, paki eŋe ge sari mageu, propet Samuel wakonge. ");
INSERT INTO ons_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Naso yewao Israel ŋei eŋe Anutuŋo kepe ware ware suaine mane mawakone birakaki ware oniakane qesonkakoi. Anutuŋo dere more Saul, Kis wane gipole, Benyamin wane tegoo ŋine ma wakone birakake, paki eŋe kepe ŋei waom eŋane ware ware geki koma 40 okange. ");
INSERT INTO ons_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Anutu eŋe Saul maki ketki so eŋe Dawit kepe ŋei eŋane ware ware ma wakonkake. Anutu eŋe Dawit wane iwa yale rake, ‘Na Dawit, Yese gipole, detlukkamaile. Na ŋei yaline eŋane simin nanmaike, eŋe naŋane simile eŋe baŋ kine kine korop maki qoe wareake, me na kine kine mayakane olatpe, eŋe korop tewek wareake.’ ");
INSERT INTO ons_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Anutuŋo Yesu, Dawit wane ŋaboine, Israel ŋei ŋerep ma menaŋoniakane birakake. Anutuŋo mo sogino ea ra togoleke. ");
INSERT INTO ons_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu eŋe urataine mi kiekke, naso yewao Yohane eŋe Israel ŋei ŋerep s