﻿USE sofia;
DROP TABLE IF EXISTS sofia.ong_vpl;
CREATE TABLE ong_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ong_vpl WRITE;
INSERT INTO ong_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mete fei pepei pe manre pite Jisas Krais. Le ninge palyenelite Devit, le Devit le ninge paliene lite Abraham. ");
INSERT INTO ong_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","16","Nange pite yaire le eple men so pepei: Abraham le lila Aisak, le Aisak le lila Jekop le Jekop le lila Juda lire ilim re winkem pele. Leye lo Juda lotei le lilange eple winges nange pelnge Peres lire Sera le te rounge nimou pelnge nange pene Tamar. Peres le lila Esron, le Esron le lila Ram. Ram lila Aminadap, le Aminadap le lila Nason. Leye lo Nason le lila Salmon. Salmon le lila ninge lele Boas le nimou pele nange pene Rahap. Leye lo Boas le lila Obed le Obed nimou pele Rut. Obed lila Jesi. Jesi le yaitei lite metine ili liti lontoluwepe mete wuru nange lele Devit. Le Devit lila Solomon, le Solomon nimou pele nepe ne ninu naisi Uria. Solomon lila Rehoboam. Le Rehoboam lila Abisa, le Abisa le yaitei lite Asa. Le Asa le yaitei lite Jehosafat, le Jehosafat le yaitei lite Jehoram, le Jehoram le yaitei lite Usia. Leye le Usia le lila Jotam, le Jotam le lila Asas, le Asas le lila Hesekia. Le Hesekia lila Manase. Fei Manase le yaitei lite Emon. Leye lo Emon le lila Josaia, le Josaia le lila Jekonia lire winkem pele. Le wem fei lepe mete pite Babilon pau kesipe mete pite Israel pilape pe Bapilon. Pe paule kesipe pilape pe pe pratei Bapilon re fei, Jokonia le lila ninge lele Seltiel. Seltiel le lila Serupapel, le Serupapel le lila Abiut. Leye le Abiut le lila Eliakim, le Eliakim le yaitei lite Asor, le Asor le yaitei lite Setok leye le Setok le lila Akim, le Akim le lila Eliut, le Eliut le lila Eliyaisa. Eliyaisa le lila ninge lele Matan, le Matan le lila Jekop. Leye lo Jekop le lila Josep. Leye lo Josep le laisine Maria leye lo ne nila ninge lene Jisas pinawo Krais, wusoli Ma Ili lotei laisi laule. ");
INSERT INTO ong_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Fei ku mulwepe manre fei pepei karipe maptei wai lelpe lelpe. Abraham pau fale metine ili liti lontoluwepe mete wuru nange lele Devit, pe esi plen le esi plen te winges te winges (14) manre. Ku koponape watafei pinu pepei re (14) pe peilo Devit pau fale wem pe pau kesipe pilape pe Bapilon pe re (14). Pile wem fei lepei le pe pau fale wem nimou nila ninge, nange lele Jisas pinawo Krais, manre pepe re pe koponape fale (14). ");
INSERT INTO ong_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wem nimou nila Jisas Krais, il pato polpepei. Nimou pele Maria pe topwepe il papiri piti ne ma naisi Josep, wolo ne wala naisi Josep kolo, wolo olo, le ne nulu notei yofu piti ma nilape eple, wuso Riri Teingi laptene pratei yofu lene lepe. ");
INSERT INTO ong_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep le metine wuso pe topwepe il papiri piti Maria ma naisi lepe, le metine piti wem oli oli lingiepe il teingipe tuwopou. Wolo le linaulo piti ma kesi topo tapune laltene Maria liso le onposi piti ma kotire lirpene lirpolo le olo linaulineye, ma laisine kolo. ");
INSERT INTO ong_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wem Josep wala kapi il laptei onposisi, riri lite Ma Ili fale lalpo yongou lirpowo Josep lolpepei, “Josep, ninge palyene lite Devit, ye ma turiye piti ma aisine Maria kolo. Wusoli Riri Teingi le watene eple piti ma nilape. ");
INSERT INTO ong_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ne ma nila ninge tulei le ye ma inawo Jisas, wusoli le ma kaniepe mete piti ma tounga pesipe il olpe pelpe.” ");
INSERT INTO ong_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Fei il pepei fale piti ma paptei il wuso Ma Ili lirpei fale nemi lite metine nimou lepe, il pepe ma fale punkom. Il pirpei polo, ");
INSERT INTO ong_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Moto lainou nenpe ne ma yofu le ne ma nila ninge tulei le ninge fei lepe pe ma pinawo Emanuel.” Il pal piti nange fei lepei - Ma Ili lirouku ratei. ");
INSERT INTO ong_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Liso wem Josep leilo, le lingiepe il wuso riri lite Ma Ili lirpowo pepe le le laisine Maria. ");
INSERT INTO ong_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wolo wem Maria wala yofu lultei piti ma nila ninge lepe, Josep olo lirine roum metei kolo. Wem Maria nila ninge lepe, Josep kali linawo Jisas. ");
INSERT INTO ong_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria nila Jisas ratei uf kumpu Betlehem lato tef lite Juda. Maria nila Jisas wem Herot wala metine il piti luntoluwepe mete. Maria nila Jisas ne fei so mete ilepe piti epli fale, pe mete piti enke pire wuru, pe pau fale Jerusalem. ");
INSERT INTO ong_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Lo pe pepletei mete pite Jerusalem, pepletei pirpeiye, “Ninge kumpu wuso pile piti ma fale lire metine ili piti luntoluwepe mete pite Juda pepe, le linei? Ku muluwo tauru lele fale loli teplai yuwei le liti epli fale le ku so mau pepei piti ma rautuwo.” ");
INSERT INTO ong_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","4","Wem Herot lingitepe il pepei, le onom onetei le le loteteiye kolo, mete piti ratei Jerusalem re pe yeflipiye enke olpe. Herot linape mete piti pinuwepe mete piti peptawio Ma Ili siye, le mete piti peptalo mete nemple pire il lipi pite Moses, Herot linape pau panfinemple le le lepleteiye, “Krais ma pila ratei fei linei?” ");
INSERT INTO ong_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pe namti pirpowoye, “Pe ma pila ratei uf kumpu Betlehem lato tef lite Juda. Metine nimou laptei il pepei, ");
INSERT INTO ong_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem, ye ato tef lite Juda, ye uf kumpu, nange neiyei kolo, wusoli ye ma metine nele ili fale le le ma luntoluwepe mete peiki Israel’.” ");
INSERT INTO ong_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Liso Herot linape mete wuso pato tef liti epli fale le pe paule Jerusalem pepe, Herot linape pe poteteiye le le lepletei lire wem wuso tauru fale lepe. ");
INSERT INTO ong_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Leye lo le laisipe pe Betlehem le le lirpepe lolpepei, “Ise ye le ise telpalo yintawo ninge kumpu lepe, le wem ise yerengawo, ise yirpeiki soma ki re ma ke rautuwo.” ");
INSERT INTO ong_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Fei pe pingitepe il pite Herot re fei, pe peye, le wem pe wala pualo tisi, pe nou puluwo tauru. Tauru elpesi wuso pe puluwo fale loli le liti epli fale lepe le tauru lepe le linuwepe le. Tauru le le lultei lapuluwo tulum wuso Maria nila ninge kumpu Jisas ratei lepe. ");
INSERT INTO ong_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mete piti enke pire wuru le pe wuso paule tef liti epli fale pepe, pe enke teingipitei wem pe puluwo tauru lepe. ");
INSERT INTO ong_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pe pinki pe winem le pe puluwo ninge kumpu Jisas lire nimou Maria. Pe yaru yamkelem pratei le pe rautuwo. Leye lo pe nempipe tenge pelpe le pe nampli oweli yini watowo ninge kumpu Jisas, oweli yini watafei kol, le oweli nemple wopu piti pire yini. ");
INSERT INTO ong_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma Ili lalpo yongou lirpei il polwepe piti pe ma nou pe falowo Herot kolo, liso pe pinge tisi nele nou pe uf tef lelpe. ");
INSERT INTO ong_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wem mete piti epli fale pepe pe pe re fei, riri lite Ma Ili lalpo yongou lirpowo Josep lirpeiye, “Eifale kesine nimou nire ninge kumpu lepe le ise yantu ye Isip le ise ratei lepe ma wem ki kirpei soma ise yusa Isip. Herot ma lintawo ninge kumpu lepe piti letesi la. ");
INSERT INTO ong_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Fei Josep leilo kesine moto re ninge kumpu lilame pire mulpou pusa Betlehem le pe pe Isip. ");
INSERT INTO ong_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Le pe pratei Isip pe pe fale wem Herot la. Pe polpepei piti ma paptei il wuso Ma Ili lirpei fale nemi lite metine nimou le il pepe ma fale punkom. Il pirpei polo, “Ki kinawo ninge leiki lau tani Isip.” ");
INSERT INTO ong_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wem Herot retai lolpepei mete wuso paule epli fale pepe pe pempesi wusoli pe nou pe falowo Herot kolo, pe peinei tisi nele pe, liso Herot onom kotu. Le lirpepe mete pele piti ma petesipe eple tuleingi pite Betlehem le uf walem pratei malfem pepe, pe ma petesipe yeflipiye pa. Eple kumpu eringi pelpe fale eringi twinges, le pe pitipi wusoli Herot nausi lasi wem wuso mete piti epli fale pe pirpowo pire wem wuso tauru fale lepe. ");
INSERT INTO ong_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Herod lolpepei piti ma laptei il wuso metine nimou Jeremaia lirpei pepe, pe ma fale punkom. Le lirpeiye, ");
INSERT INTO ong_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Pe pingitowo ipli fale Rama, ipli liti pailolo re poutiti olpetei. Resel nouti onetei nire eple pene. Ne nouti le pe miso pailelene onom pene kolo wusoli eple olo yeflipiye pa.” ");
INSERT INTO ong_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod la re fei liso riri lite Ma Ili lalpo yongou lirpowo Josep ratei Isip, ");
INSERT INTO ong_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","le le lirpowo Josep lolpepei, “Eifale kesi kumpu lepe lire nimou pele le ise ma nou ye tef lite Israel wusoli mete wuso pirpolo pe ma petesi la lepe, pe olo paye.” ");
INSERT INTO ong_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Liso Josep leilo kesi ninge Jisas lire nimou pele Maria le pe nou pe Israel. ");
INSERT INTO ong_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wem Josep lingitei lolpepei, Arkelaus namti lesio towa lite yaitei lele Herot. Arkelaus namti fale lire metine ili piti luntoluwepe mete pite Juda liso Josep turuwo piti ratei tef fei lepe. Riri lite Ma Ili nou lalpo yongou lirpowo Josep le Josep le tef lite Galili. ");
INSERT INTO ong_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Le Josep leila winem lele ratei uf pinawo Nasaret. Le lolpepei piti ma laptei il wuso mete emare pinu pirpei pepe, il pepe ma fale punkom. Il pirpei polo, “Mete ma pinawo pirpolo le metine lite Nasaret.” ");
INSERT INTO ong_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wem fei lepe Jon, le metine liti kaptetei mete, le le leptalo ilpite Ma Ili linge tef minim lite Juda. Tef oli era re telmane ye yawi. ");
INSERT INTO ong_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Le le lirpeiye, “Ise yusape il olpe wusoli wem liti Ma Ili ma luntolise olo lau lire malfemye.” ");
INSERT INTO ong_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon, le metine wuso metine nimou Aisaia sungoi liye lirpei liri lepe wem le lirpeiye, “Metine nele linanai linge tef oli era re telmane ye yawi, linanai lirpeiye, ‘Nali tisi lite Ma Ili, yaltei tisi tuwopou liti Ma Ili ma lingiyo.” ");
INSERT INTO ong_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon lafo olongou olpetei pele lire kamel tipli lengleleipe, le le leltalo morou topo luwo pau, le lafo olongou pele liniyepe mete emarengi piti sungoi. Jon oweli pele teingipe kolo olo le laplei siye tinglape pire epe. ");
INSERT INTO ong_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mete pite Jerusalem le pite Juda le pite tef ili yefliye lite Jodan, pe karowo Jon pe. ");
INSERT INTO ong_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pe pirpei nomnaipe il olpe pelpe, le Jon kaptetei ratei wof Jodan. ");
INSERT INTO ong_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wolo wem Jon luluwepe mete wuru pite Farasi pire mete pite Sadyusi, pe pe fale piti le ma kaptetei, Jon luluwepe le le lirpeiye, “Ise mete piti nel loli ilo ilo, ise yirpolo ise miso yantu tani moingi fei Ma Ili ma watepe mete olpe lom? Ma olo. ");
INSERT INTO ong_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yesi towa men teingi ma kusauku ise olo yusape il olpe peiseye. ");
INSERT INTO ong_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Le ise ma onposi piti ma yirpei nemple yirpolo ise eple palye pite Abraham le Ma Ili ma laileleise lom, ma olo. Ki kirpeise, Ma Ili miso liripe era fei pepei laptei fale pire eple palye pite Abraham. ");
INSERT INTO ong_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ma Ili olo loporo lotei piti ma leplele nimpe wuso pilape fouri teingipe kolo, le le ma liripe pualo weli. ");
INSERT INTO ong_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ise yusape il olpe peise, le ki kire tipe keiteteise. Wolo metine nele ma lingi lau, le le ma keiteteise lire Riri Teingi le lire weli. Le singetei, le ki olo, le ki olo teingi kolo piti ma kilape men kumpu watafei ire topungou pele kolo. ");
INSERT INTO ong_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Le ma karipe mete teingipe taniepe piti olpe. Min watafei wit mete karipe le pe kapi wit fouri teingipe taniepe wit emare. Karipe paptei winem le emare yaupe pusape weli, weli ma loli wem oli oli laplei. ");
INSERT INTO ong_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wem fei lepe Jisas lato Galili so le, le le le falowo Jon ratei wof Jodan piti ma Jon kaltetei. ");
INSERT INTO ong_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Wolo Jon lirpolo le miso weisine onom pite Jisas lirpeiye, “Ki onom nuwoye piti ye ma keiteteiki le ye aule ki lom?” ");
INSERT INTO ong_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jisas namti lirpeiye, “Fei, usape pato polpepe, pe poporo piti ku ma wingiepe il pite Ma Ili wailelepe.” Leye lo Jon lulpowo. ");
INSERT INTO ong_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Wem Jon kaltetei Jisas re fei, Jisas lusa wof tipe le le fale le mingo, teplai lawo frou yo fei le le luluwo Riri Teingi lite Ma Ili watafei nafle malpu lualo lifowo oru lele. ");
INSERT INTO ong_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Le il nemple fale teplai yuwei pirpeiye, “Fei lepei, le ninge leiki. Ki onom nuwowo le ki onom teinginetei kasio.” ");
INSERT INTO ong_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Leye lo Riri Teingi lite Ma Ili lunkuwo Jisas le le kesi Jisas lila le tef oli era re telmane ye yawi piti ma towa lempesesi, luluwo wai piti Jisas singe lo olo. ");
INSERT INTO ong_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jisas laplei oweli kolo, lato yawi le epli re mulpou wurutei (40) re fei, le nimpi nalei. ");
INSERT INTO ong_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Leye lo towa le falowo Jisas le le lirpeiye, “Wuso ye ninge lite Ma Ili, ye irpepe era fei pepei, le pe ma weitei pire luom.” ");
INSERT INTO ong_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jisas namti lirpeiye, “Olo sungoi pe paptei il pite Ma Ili pirpei polpepei, luom yawi miso kanio metine kolo, olo. Wolo le ma lingiepe il piti fale nemi lite Ma Ili, le le soma ratei.” ");
INSERT INTO ong_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Leye lo, towa kesi Jisas lila le uf ili Jerusalem le le laltei lile tupe lite winem lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Towa lirpowo Jisas-ye, “Wuso ye ninge lite Ma Ili, ye iri yotei ualo, wusoli il pite Ma Ili paptei pirpei polpepei, ‘Ma Ili ma lirpepe ririm pele lireye ye, le pe ma pire esi pelpe pesiye peilaiye soma ye eplangu ire peiye asi era kolo’.” ");
INSERT INTO ong_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisas namti lirpowoye, “Il pite Ma Ili re, pe paptei pirpei polpepei, ‘Le metine minele le ma lempesesi Ma Ili piti kosawo singe pele kolo, olo le Ma Ili leise.” ");
INSERT INTO ong_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Fei towa nou kesi Jisas lila le tumun yuweitei le le kusawo lire uf walem lipi lipi pinge tef pire oweli yini men nange teingipitei pelpe. ");
INSERT INTO ong_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Le le lirpowo Jisas-ye, “Fei pepei yeflipiye, ki ma waiye wuso ye ma aute oru le ye rautuki.” ");
INSERT INTO ong_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisas lirpowoye, “Towa, ye e taniki. Il pite Ma Ili paptei pirpei polpepei, ‘Ye ma rautuwo Ili, le Ma Ili leiye le ye ma esio towa lele loteteiye’.” ");
INSERT INTO ong_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Leye lo towa lepe lusa Jisas-ye le ririm pite Ma Ili paule kanio Jisas. ");
INSERT INTO ong_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wem Jisas lingitei lolpepei Jon olo paltei lifei winem oliye, Jisas nou le tef Galili. ");
INSERT INTO ong_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jisas lusa Nasaret le le le ratei Kaperneam lato malfem lire tuluple lite Galili, tef lite alpe lite Sebulun re Naptali. ");
INSERT INTO ong_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas le ratei Kaperneam piti ma il wuso metine nimou Aisaia sungoitei liye lirpei pepe ma fale punkom, ");
INSERT INTO ong_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tef lite Sebulun le tef lite Naptali, tisi liti le peryai, lingio wof Jodan, Galili lite mete nemple, pe pite Israel kolo, olo. ");
INSERT INTO ong_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mete fei pepe wuso pratei munkunum pire il olpe ma puluwo weli ili lite Ma Ili luwalipe mete wuso pratei tef liti pire nemple olpe. Singe lite Ma Ili ma weisipe il olpe pelpe.” ");
INSERT INTO ong_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Wem fei lepe, le le le Jisas leptalo il lirpeiye, “Yusape il olpe peise wusoli wem liti Ma Ili ma luntolise olo lau lire malfemye.” ");
INSERT INTO ong_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas wala le linge lunko liti tuluple ili lite Galili le le luluwo Saimon (pinawo Pita) lire winke Andru. Te rounge tireri taimere leingalo tuluple wusoli te tesio towa lelnge piti tengleipe ningu. ");
INSERT INTO ong_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas lirpengeye, “Rounge yau yulteiki le ki ma keitaloise rounge piti yengleipe mete.” ");
INSERT INTO ong_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Saimon lire winke Andru frou tusape taimere pelnge pato, le te rounge tulsi Jisas. ");
INSERT INTO ong_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jisas wala lilele le le le luluwo line nele lire winke lele. Le luluwo Jems lire winke Jon, yaitei lelnge Sebedi. Te rounge tire yaitei Sebedi pepi pifei nimpe teingo lelpe le pe poporipe taimere pelpe. Jisas linange, ");
INSERT INTO ong_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","le te rounge frou tusa nimpe teingo lire yaitei lelnge le te rounge tulsi Jisas. ");
INSERT INTO ong_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas lingio tef lite Galili le laltuye le le le angli pal pelpe le le leptalo mete lire il pite Ma Ili ma lailelepe re luntoluwepe, le le kapi kainu olpe polomen polomen re le kapi taniepe. ");
INSERT INTO ong_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Il rofro pe tef lite Siria yefliye, le mete pilape wuru pelpe wuso kainu polomen polomen re, pilape pe Jisas. Pe wuso kainu pire flis lipitei, towa punkuwepe re wumun weisesipe re ire esi pa re, le Jisas kapi taniepe oloye. ");
INSERT INTO ong_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mete wurutei pite Galili, Dekapolis, Jerusalem, Juda le pite wof Jodan plen liti epli fale, pe pulsi Jisas. ");
INSERT INTO ong_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Fei wem Jisas luluwepe mete wuso wurutei pepe, le lunwei lifei tef lupai linpei lifei. Pupam pele pe pirowo malfem, ");
INSERT INTO ong_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","le Jisas leptalo lire il pite Ma Ili lirpeiye, ");
INSERT INTO ong_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mete piti pe enke pelpe kumputei, pe miso pingepe il pite Ma Ili, pe ma enke teingipe, Ma Ili lailelepe re luntoluwepe. ");
INSERT INTO ong_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mete piti enke olpe le pe pouti, pe ma enke teingipe, Ma Ili laptuwepe enke pelpe. ");
INSERT INTO ong_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mete piti pire yape, pe ma enke teingipe wusoli pe ma pratei poporo pingi wem wem. ");
INSERT INTO ong_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mete piti onom kerowo towa teingi liti Ma Ili piti ma pesio, pe ma enke teingipe, Ma Ili ma liripe teingipe. ");
INSERT INTO ong_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mete piti onom manepe re pailelepe mete nemple pe ma enke teingipe, Ma Ili ma namti onom manepe re lailelepe. ");
INSERT INTO ong_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mete pire wouye pretape il olpe kolo, pironom, pe ma enke teingipe, pe ma puluwo Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mete piti pire il yaruwepe mete nemple le pe kete wem teingi paltei, pe ma enke teingipe, Ma Ili ma linape pe eple pele. ");
INSERT INTO ong_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mete piti pesio towa teingi liti Ma Ili wolo mete nemple watepe moingi, mete fei pila moingi pepe, pe ma enke teingipe, Ma Ili ma lailelepe re luntoluwepe ratei uf lele. ");
INSERT INTO ong_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ise ma enke teingipe wem mete paileleise kolo, pilaise re posise le pe pamtuse pirpolo ise mete olpe wusoli ise yulteiki. ");
INSERT INTO ong_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ise ma enke teingipe wusoli Ma Ili laptei men teingipetei peise puwo yuwei. Mete piripe nemple mete emarengi piti sungoi le ise re pe ma paileleise kolo. ");
INSERT INTO ong_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ise watafei tor liti mete palei pasi mere, le wuso tor fei lepe, le losio mere la kolo olo, tor fei lepe oli is. Tor ma nou fale teingi weli fei lolomen, olo olesa isye, le mete ma kali piri le pe poluwo rofrereiye. ");
INSERT INTO ong_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ise nongo weli piti nainuwepe mete watafei uf ili lifei tef lupai linpei lifei. Le miso kotire kolo, mete ma puluwo. ");
INSERT INTO ong_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mete ma peltei nongo weli le pe palingi lato poi tef kolo. Pe ma paltei luwo poi yuwei soma weli nainuwepe mete piti pifei winem leinginim. ");
INSERT INTO ong_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ise watafei nongo weli. Yusa weli leise lini luwo nainuwepe mete le pe ma puluwo towa teingi ise yesio, pe ma rautuwo Yaitei leise liti yuwei. ");
INSERT INTO ong_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ise ma onposi yirpolo ki kaule piti ma kiripe nemple il lipi pite Moses lo mete emarengi, olo; ki kaule ma kiripe nemple kolo, wolo ki kaule piti ma kingiepe il fei pepe ke kapuluye. ");
INSERT INTO ong_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ki kirpeise punkom, wem teplai yuwei lire tef wala tato, il lipi pite Moses, kumputeitei pelpe fei polomen re, miso kotire kolo, ma puwo polpepe pe pe ma il fei pepe ma fale punkomye. ");
INSERT INTO ong_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Il lipi pite Moses, kumputeitei pelpe singe kolo, le metine nele lingiepe kolo, le le leptalo mete nemple piti ma pingepe il fei pepe kolo, metine fei lolpepe le ma Ma Ili liti yuwei leila nange lele kolo. Wolo metine minele le lingipe il lipi pite Moses le le leptalo mete nemple piti pe ma pingiepe, metine fei lepei Ma Ili ma leila nange lele. ");
INSERT INTO ong_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ki kirpeise, mete pite Farasi pire mete piti peptalo mete nemple pire il lipi pite Moses, pe olo pingiepe il lipi pepe poporo kolo, le wuso ise namti fale raptei le ise yingiepe il lipi fei pepe yoporotei, Ma Ili ma laileleise re luntolise. ");
INSERT INTO ong_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ise retai, mete sungoi pingitepe il pirpei polpepei, ‘Ise ma yetesi metine nele la kolo olo. Le wuso metine nele letesi metine nele la, metine fei lepe pe ma kesi pila pe falepe mete lipi, le pe ma kapi il paptei piri, le pe ma namti watowo moingi.’ ");
INSERT INTO ong_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wolo fei ki kirpeise, minele leise le onom kotu lire nele leise, metine fei onom kotu lepe le oli, le ma lila moingi. Le wuso minele leise le linawo nele leise lirpolo ‘Ye kowine oli,’ metine fei lirpei lepe, le ma le falepe mete lipi piti pingitepe moingi le pe ma kapi paptei. Le minele leise le lilawo koropowo nele leise, metine fei lilawo lepe, le moingi ma falowo, le le ma le weli oli. ");
INSERT INTO ong_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Le wuso ye oporo yotei piti ma aptei oweli pifei tile piti ma watowo Ma Ili le ye ile tulum fei lepe onposio nele leiye, le le onom one lireye, ");
INSERT INTO ong_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","usape oweli peiye pratei tile onom le ye ma frou e yaruwepe il afo ire metine fei lepe wo, le ye so nou au le ye aptei oweli peiye watowo Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Wuso metine nele le lirpepe moli lipi lireye, le le ma keteiye lilaiye le piti pe ma pingitepe re kapi paptei pire il peise rounge, ye ma inu ire il yaruwo le ise rounge ma yaru il yafo taniye. Wuso olo, le keteiye lilaye le falepe moli lipi, le moli lipi ma peiteiye e esi pite yali pal, le pe ma peiteiye ifei winem oli. ");
INSERT INTO ong_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ki kirpeiye punkom, ye ma naro e towa yawi kolo, wala ma aptei mole ire aisipe il olpe peiye e ma yalipe wo, ye soma naro e towa yawi. ");
INSERT INTO ong_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ise yingitepe il lipi pite Moses pirpei polpepei, ‘Ye ma auleline moto pite metine nele kolo.’ ");
INSERT INTO ong_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Wolo fei ki kirpeise, wuso metine nele le luluwene moto nenpe yaune, le le onom falene, Ma Ili ma kapi il lusapowo lope lirpolo metine fei lepe olo lauleline moto fei nepe punkom. ");
INSERT INTO ong_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Wuso lutepe leiye, lite eti tilpi, leiteiye uwalo tisi oli, kotuwo iri tani. Ye ma ailele yotei wuso ye kotuwo lutepe oli lepe iri tani, olo ma Ma Ili lireiye yefliye inki weli ili. ");
INSERT INTO ong_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Le wuso eti tilpi leiye leiteiye uwalo tisi oli, alowi iri tani. Ye ma ailele yotei, wuso ye alowi eti oli lepe iri tani, olo ma Ma Ili leiteiye yefliye e weli ili. ");
INSERT INTO ong_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Il lipi pite Moses pirpei polpepei, ‘Wuso metine nele, le linauline moto pele le le lirpolo ma laisine ne tanio, metine fei lepe, le ma laptei il paitei yousi le le ma watene moto soma ne ne tanio.’ ");
INSERT INTO ong_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wolo ki kirpeise, wuso moto pite metine nele ne ne nire metine nele roum metei kolo, wolo munge lene laisine ne tanio, metine fei lepe le metine oli piti lantei moto pele nualo tisi oli wuso ne nou ne naisi munge nele. Le metine nele fei laisine moto fei nepe, le re lualo tisi oli, le laisine moto pite metine nele. ");
INSERT INTO ong_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ise nou yingitepe il lipi pite Moses sungoi pirpepe manre pouku polpepei, ‘Il pite ye topwepe apiri ire Ma Ili, ye ma yaruwepe kolo wolo ye ma ingiepe il wuso eisi nange lite Ma Ili le ye topwepe apiri pepe.’ ");
INSERT INTO ong_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Wolo fei ki kirpeise, wem ise topwepe il yapiri, ise ma yeisipe nange men lipi kolo olo. Ise ma yeisi yuwei kolo olo, wusoli lepe le tulum liti Ma Ili lifei, ");
INSERT INTO ong_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","lo yeisi yire tef re ma olo, wusoli tef le tulum liti Ma Ili laptei ire pele poli, wo Jerusalem re ma yeisi kolo wusoli Jerusalem le uf ili lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Le ise ma yeisi falo leise kolo wusoli ise miso weisine oru nenpe kumpu fale fiyu lo aroro kolo. ");
INSERT INTO ong_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ise ma yirpei iyoye le oloye, fei, il men nange piti yirpei reresipe, fei pepe ma pau towa oli. ");
INSERT INTO ong_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ise yingitepe il lipi pite Moses pirpei polpepei, ‘Wuso metine nele letesi kotuwo lutepe leiye, ye ma namti etesi kotuwo lele lotei. Le wuso le letesi yaruwo nilpe leiye, le ye ma namti etesi yaruwo nilpe lele.’ ");
INSERT INTO ong_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Wolo fei ki kirpeise, Minele piti waiye moingi, ye ma namti watowo moingi pato. Wuso metine nele leteteiye yifa pite eti tilpi, yifa plen pite eti enkau re ye ma usa letesipe lapwonou. ");
INSERT INTO ong_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Le wuso metine nele lirpepe moli lipi lire olol leiye piti le ma kali, ye ma usa kali olol fei lepe wuso ire era kumpu aisi le nele piti ire era lipi aise re ye ma usa metine fei lepe kali lalwonou. ");
INSERT INTO ong_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Le wuso yalu pau nele reituye piti ma ila tom lele e nele malfem lepei (1 kilomita), ye ma ila tom lele namti e fiyen taise (2 kilomita). ");
INSERT INTO ong_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wem metine nele leiteiye lire men piti ye ma watowo, ye watowo. Wem metine nele leiteiye piti ma kali menele leiye le liri lesio towa lele wo le so nou leiye lau waiye, ye kali watowo le liri wo, ye ma empesi pato, watowo. ");
INSERT INTO ong_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ise yingitepe il lipi pite Moses pirpei polpepei, ‘Ise ma enke puwope numuwi peise, le ise ma enke kotu yire mete piti yire nemple eringi.’ ");
INSERT INTO ong_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Wolo fei ki kirpeise, Ise ma enke puwope mete piti yire nemple eringi le ise ma yeletei Ma Ili piti ma lailelepe mete wuso pireise olpe pepe. ");
INSERT INTO ong_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ise ma yolpepei soma ise fale yire eple pite Yaitei leise liti yuwei. Le laltei epli lele loli luwope mete piti prautuwo Ma Ili le le luwope mete piti prautuwepe weni ririm olpe. Le le lantei nef nualipe mete piti pailelepe mete nemple, le ne nualipe mete piti piripe olpe mete nemple. ");
INSERT INTO ong_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Piti men ma Ma Ili laileleiye wuso ye onom puwope mete wuso pe namti onom puwoye pepe? Mete olpe re pe onom puwope potei wane watafei ise pepe. ");
INSERT INTO ong_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Le wuso ise ma yiripe numuwi peise yaupe yepi yirpei, ise yesi menele wala yefli kolo olo. Mete piti pratuwepe weni ririm olpe, pe re, piripe ilepe wane pelpe pepi pirpei nemple watafei ise pepe. ");
INSERT INTO ong_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ise ma onom puwope mete eryai watafei Yaitei leise liti yuwei, le onom puwope mete eryai pepe. ");
INSERT INTO ong_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Wem ise yingiepe il pite Ma Ili leise, le ise kaniepe mete nemple yire oweli, ise ma kotopa isotei. Ise ma watepe yile alepe nimin le mete wuru ma pulise pato. Wuso ise kaniepe mete nemple yile alepe nimin, Yaitei leise liti yuwei ma laileleise kolo. ");
INSERT INTO ong_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Le wem metine nele le oweli men nange olo le ye watowo, ye ma rautu yotei watafei mete piti nel loli ilo ilo kolo, wem pe pifei angli pau liti Ma Ili, le pe watowo metine lepe era, le wem pe pile tisi, pe pinape mete wuru pau puluwepe watowo metine lepe oweli. Pe prautu potei yaupe, pe pingio tisi lite Ma Ili poporo kolo, le ye ma rautu yotei watafei pe pepe kolo olo. Pe prautu potei soma mete peilape nange pelpe. Ki kirpeise punkom mete peilape nange pelpe fei, le Ma Ili ma nou watepe men kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wolo wem ye watowo metine wuso le oweli men nange olo pepe, ye ma aplingi watowo soma line lo winke leiye re ma retai kolo. ");
INSERT INTO ong_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Le fei pepe ma kotire pato, le Eiya leiye liti yuwei le luliye wuso ye aplingi men watowo metine nele lepe le le miso laileleye. ");
INSERT INTO ong_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Wem ise yeletei Ma Ili, ise ma watafei mete piti nel noli ilo ilo pepe kolo, olo. Pe onom puwo piti ma pifei angli pau lite Ma Ili le pe ma peilo pile peletei Ma Ili le pe ma pe pile tisi angoleingi soma pe peletei Ma Ili le mete wuru ma pulwepe. Ki kirpeise punkom, mete pilape nange pelpe yaupe, Ma Ili ma lingitepe kolo, olo. ");
INSERT INTO ong_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Le wem ye ma eletei Ma Ili, ye e elpeingo leiye, amsi wingi, le ye eletei Eiya leiye, ye uluwo kolo, le kotire. Le Eiya leiye lepe, ye esi menele kotire re le luliye fei, le le miso laileleye. ");
INSERT INTO ong_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Wem ise yeletei Ma Ili, ise ma yire il wuru teingelem yaupe yaupe kolo, watafei mete piti pretawo Ma Ili kolo, pe onposi pirpolo Ma Ili ma lingitepe wusoli pe pire il ulepe peletei. ");
INSERT INTO ong_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ise ma watafei pe pepe kolo. Eiya leise le linu retape men piti ise ma yeletei yiri. ");
INSERT INTO ong_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ise ma yeletei Ma Ili yolpepei, ‘Ma Ili, ye Eiya louku liti yuwei. Mete ma kelelaiye kolo, le ku ma meila nange leiye, ye Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ye ma au untoluku, ku ma mingepe il peiye watafei ririm piti yuwei, pe pingepe il peiye. ");
INSERT INTO ong_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ye wauku oweli piti fei ku ma maplei. ");
INSERT INTO ong_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ye ma onposiepe il olpe pouku kolo watafei ku re ma onposiepe il olpe pite mete nemple kolo. ");
INSERT INTO ong_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ye ma usauku mingio tisi oli kolo, wolo ye ma kanouku tanio towa.’ ");
INSERT INTO ong_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wuso ise onposiepe il olpe pite mete nemple kolo, Yaitei leise liti yuwei re miso onposiepe il olpe peise kolo. ");
INSERT INTO ong_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Le wuso ise onposiepe il olpe pite mete nemple, Yaitei leise liti yuwei re, le ma onposiepe il olpe peise. ");
INSERT INTO ong_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Le wem ise onposio Ma Ili le ise ma yaplei oweli kolo, masi peise ma olpe kolo, ma yiniepe mete piti nel loli ilo ilo pepe kolo. Pe pemtetei weisipe masi olpe soma mete wuru ma pulwepe pirpolo pe onposio Ma Ili le pe paplei oweli kolo. Ki kirpeise punkom, Ma Ili olo lailelepe kolo. ");
INSERT INTO ong_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wem ye aplei oweli kolo, ato yawi, ye ma kaltetei mati leiye le ye ketete oru, ");
INSERT INTO ong_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","soma mete nemple pretaiye pirpolo ye olo onposio Ma Ili le ye aplei oweli kolo, pe ma pretai fei polpepei kolo. Ma Ili, le Eiya leiye, le loteteiye ma retai le ye olo uluwo kolo. Le Ma Ili, le Eiya leiye wuso luliye olpepe le mete nemple pretai kolo, le ma laileleye. ");
INSERT INTO ong_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ise ma kapi mole yini wuru yaptei isotei wem ise ratei tef fei lepei kolo. Oweli fei pepe ma olpe kerere, mou fale losiepe le nampringe fale lengleipe, le mete ma yaruwo winem, pinki pe pire ausi kapi. ");
INSERT INTO ong_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wolo ise ma yolpepe kolo, ise ma weisipe enke yaptowo Ma Ili, le ise yingiepe il pele, le le ma lapteise oweli fei pepe pifei yuwei soma pe olpe kerere kolo, mou ma fale losiepe kolo le nampringe fale lengleipe kolo le mete re ma yaru winem le pe pire ausi kapi kolo, olo. ");
INSERT INTO ong_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Wusoli tulum liti oweli yini peiye pratei teingipe poporo tulum fei lepe soma ye onom puwowo lepe ko. ");
INSERT INTO ong_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lutepe, pe nongo weli pite topo tale. Wuso lutepe peiye pe teingipe, uluwo menele ye onom falowo kolo, topo tale leiye yefliye ma teingi lini. ");
INSERT INTO ong_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Le wuso lutepe peiye pe olpe, uluwo menele teingi ye onom falowo frouye, topo tale leiye ma oli olfutuwo. Le wuso topo tale leiye lepe le teingi lini kolo, le oli olfutuwo, ye metine olitei piti onom kerepe il olpe. ");
INSERT INTO ong_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Metine niliyeye miso lesio towa lite moli twinges kolo. Le ma onom kotu lire nele le le onom puwol nele. Le ma laptowo mingim moli nele le moli nele lepe ma metine fei lepe ma linpim il pele. Ye miso esio towa lite moli twinges oporo kolo min watafei towa lite Ma Ili le towa liti inta mole yini wuru, ye ma esienge autuwonou kolo. ");
INSERT INTO ong_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Min fei polpepei, ki kirpeise piti ma enke olpe kolo yire tipe re oweli piti yaplei le ise ma ya kolo, le olongou piti yafo. Ise ma enke olpe yiripe fei pepe kolo. Ise onposi men le teingitei, nempi liti ratei yingi wem wem lo oweli? Le topo tale peise, pe teingipetei lo olongou piti yafo, pe teingipetei? ");
INSERT INTO ong_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yulwepe naflepem peifalele eryai pinge teplai yuwei. Pe olo papiri oweli kolo, le pe olo kotuwepe oweli paptei pifei winangou kolo. Wolo Ma Ili, le Eiya leise liti yuwei, le luntoluwepe. Ma Ili luntoluwepe naflepem wolo ise, le luntolise loporotei. ");
INSERT INTO ong_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Minele leise ma onom one lire wem piti le ma la, le le miso kete wem ulel laltei lotei piti le wala ma namin ratei, miso olotei. ");
INSERT INTO ong_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Le piti men ma ise enke olpe yire olongou? Yulwepe wolo piti towa yawi, pe peilo lipi polomen? Pe pesi towa lo pe pengleleipe olongou pelpe, kuna olotei. ");
INSERT INTO ong_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Wolo ki kirpeise, metine ili Solomon, le mole yini pele teingipe wolo pe teingipe watafei wolo tafe pepe kolo. ");
INSERT INTO ong_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Le wuso Ma Ili lailelepe wolo piti towa yawi le pe pilape tafe teingipetei, pe fei ma nampir pile, le nolowi epli ma lapo paye le mete ma paplowi peplesi weli. Ma Ma Ili laileleise kolo lom? Ko ise mete piti yulpowo Ma Ili yirkilau kolo ise yirpolo Ma Ili miso laileleise kolo, olo le ma laileleise. ");
INSERT INTO ong_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ise onposi yirpolo, ‘ku ma kapi oweli, tipe le olongou pouku molomen?’ Olo ise ma onposi yolpepe kolo. ");
INSERT INTO ong_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mete piti prautuwepe weni ririm olpe, pe wem oli oli onposiepe oweli fei pepe. Ma Ili, le Eiya leise liti yuwei, le retai ise ma kapi oweli fei pepe. ");
INSERT INTO ong_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Iso ise ma onposiepe tipe, oweli re olongou pato, ise ma onposio yirkilautei yire wem liti Ma Ili ma luntoluku, le ise ma onposio towa men Ma Ili waise piti yesio, le Ma Ili lotei miso waise oweli men nange, piti yafo, le piti yaplei. ");
INSERT INTO ong_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Iso ise ma enke olpe yire moingi piti nolowi kolo. Moingi piti fei, fei, moingi piti nolowi, nolowi. Epli niliyeye niliyeye moingi ma fale, le ise ma yinu onposiepe kolo. ");
INSERT INTO ong_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ye ma kapi il aptei ire mete nemple kolo soma ye re, Ma Ili ma namti kapi il laptei lireye kolo. ");
INSERT INTO ong_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wusoli Ma Ili ma kapi il laptei lireye linge tisi elpesi watafei ye kapi aptei ire mete nemple pepe. ");
INSERT INTO ong_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Piti men ma ye kotuwene tuwi kumpu noli lutepe liti metine nele le ye usa nimpe talpe ili loli lutepe leiye yotei? ");
INSERT INTO ong_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Olomen ma ye irpowo metine nele irpolo, ‘Usaiki kotuwene tuwi kumpu noli lutepe leiye wo,’ le ye yotei wem oli oli nimpe talpe ili loli lutepe leiye yotei. ");
INSERT INTO ong_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ye metine liti nel loli ilo ilo, ye ma inu kotuwo nimpe talpe ili loli lutepe leiye yotei wo, leye lo ye soma untoli oporo piti ma kotuwene tuwi kumpu noli lutepe liti metine nele. ");
INSERT INTO ong_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Men men teingipetei pite Ma Ili le mete nemple pretape kolo, men men teingipetei fei pepe ye ma watepe mete piti pelem enke poluwepe pepe, ye ma watepe kolo, olo pe ma nou weitei pau posiye. Mangou peiye, ye ma ailelepe, ye ma iripe pratei pinuwepe songou kolo, songou ma pe poluwepe pasi tef. ");
INSERT INTO ong_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Eletei Ma Ili, le le ma waiye, intata le ye ma erengawo, amwewe wingi le le ma kamunuye wingi. ");
INSERT INTO ong_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wuso minemple peletei Ma Ili, le ma watepe, le minemple pintawo, pe ma perengawo, le minemple pamwewe wingi, le ma kamunuwepe wingi. ");
INSERT INTO ong_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ise minemple fei yire yaire pepe, ye ma watowo ninge leiye erau wem le leiteiye lire luom lom? ");
INSERT INTO ong_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Lo ye ma watowo wirkiri wem le leiteiye lire ni lom? ");
INSERT INTO ong_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Wuso ye metine piti ire il olpe, ye retai piti watepe eple peiye men men teingipe, Ma Ili, le Eiya leise liti yuwei, le re retai loporotei piti watepe mete wuso peletei pire men men teingipe. ");
INSERT INTO ong_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ye ma ailelepe mete watafei ye onom puwope piti pe ma namti paileleiye pepe. Fei pepei pe il pal pite il lipi pite Moses le il pal pite mete emarengi pelpe peptalo. ");
INSERT INTO ong_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ise ma yinki wingi kumpu, wusoli wingi piti pe uf oli, pe lipi pina, le tisi liti pingio pe re, le ili loporo le mete wuru pingio tisi fei lepe. ");
INSERT INTO ong_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wolo wingi piti pe uf teingi, pe kumpu paungei le tisi oli yumpru, le mete yaipiyeye perengawo tisi fei lepe. ");
INSERT INTO ong_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ise ma yoporo isotei yire mete ma pemtetei pirpolo pe mete emarengi teingipe. Pe ma pau peptalo il watafei mete emarengi pepe wolo enke pelpe olo pretape il olpe pengleipetei, le pe ma pireise nemple. ");
INSERT INTO ong_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ise miso yuluwo retawo towa lelpe liti pesio. Foiye fape miso lilape foulungu kolo le menpeleingu singu miso pilape yumko kolo. ");
INSERT INTO ong_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nimpe teingi ma lilape fouri teingipe, wolo nimpe oli ma lilape fouri olpe. ");
INSERT INTO ong_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nimpe teingi ma lilape fouri olpe kolo, le nimpe oli ma lilape fouri teingipe kolo. ");
INSERT INTO ong_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Le nimpe wuso pilape fouri teingipe kolo, Ma Ili ma leplele liripe pe weli. ");
INSERT INTO ong_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Liso mete piti pemtetei peptalo il watafei mete emarengi pepe, ise miso retape yire towa lelpe liti pesio. ");
INSERT INTO ong_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mete wurutetei wuso pinaiki ‘Apa, Apa’ pepe, ma yeflipiye pe pire Ma Ili pepi pratei pingi wem wem lom, ma olo. Wolo ilepe pelpe piti pingiepe il pite Ma Ili, le Eiya leiki liti yuwei, fei pepe miso pe pire Ma Ili pepi pratei pingi wem wem. ");
INSERT INTO ong_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wem liti Ma Ili lingitepe re kapi laptei liripe moingi pite mete pite tef, mete wuru ma pirpeiki pirpolo, ‘Apa, Apa, ku mire singe lite nange leiye, ku mirpei il pite Ma Ili. Ku mire singe lite nange leiye, ku maptu towa naro pe taniepe mete, le ku mirpei, men nange wuru potei pire tute fale.’ ");
INSERT INTO ong_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Leye lo ki ma kirpepe kolpepei, ‘Ki olo kretaise kolo. Ise ye taniki, ise mete piti yire il olpe.’ ");
INSERT INTO ong_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Liso fei minemple piti pingitepe il peiki pepei le pe pingiepe, pe ma watafei metine liti onom nire wuru le le leila winem lele lifei tef mingo tangu. ");
INSERT INTO ong_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nef nalolo le esingu pa pinge nengeliom pelpe pe, le yuf lini singe laltetei winem fei lepe. Wolo winem fei lepe le lualo kolo, wusoli le lile tef mingo tangu. ");
INSERT INTO ong_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wolo minemple pingitepe il peiki pepei le pe pingiepe kolo, pe ma watafei metine piti lironom le le leila winem lifei nengeliom piti esingu pa pe. ");
INSERT INTO ong_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nef nalolo le esingu pa lipi pinge nengeliom lepe pe le yuf lini singe laltetei winem lepe. Le winem fei lepe le lualo laututu oliye. ");
INSERT INTO ong_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wem Jisas lirpei il fei pepei re fei, mete wurutei pepe, pe pinlele potei pire il wuso Jisas leptalo pepe, ");
INSERT INTO ong_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","wusoli Jisas leptalo il watafei mete piti peptalo il lipi pite Moses kolo, le leptalo il lire singe pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wem Jisas lusa tulum wuso lifei laitei alu le le leptalo il pepe, mete wurutei pulsi pitipi alu lepe pe. ");
INSERT INTO ong_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Metine nele, le pape olpe poluwo, le lau yaru yamkelem ratei linuwo kani onom lantowo Jisas le le lirpeiye, “Ili leiki, wuso ye onom maneiki, ye ma kapi pape fei pepei taniki.” ");
INSERT INTO ong_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisas kete eti lele le lesio metine wuso pape poluwo lepe, le le namti lirpowoye, “Ki onom maneiye piti kaneiye, pape olpe ma pe taniye le ye topo leiye ma nou fale teingi.” Frou yo fei, pape olpe wuso poluwo metine lepe oloye le topo teingi falowoye. ");
INSERT INTO ong_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Leye lo Jisas lirpowo metine lepeye, “Ingitei, ye ma irpepe mete nemple pato, ye ma karowo metine liti leptawio siye piti Ma Ili, ye ma karowo metine fei lepe e le ye kusawo le le ma luliye. Leye lo ye ma kusape mete wuru olpepei, ye topo leiye olo nou teingiye le ye ma watowo oweli piti leptawio Ma Ili, ingiepe il lipi pite Moses.” ");
INSERT INTO ong_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Wem Jisas le fale uf Kaperneam, metine nele piti luntoluwepe yali pal pite moli lipi pite Rom, le lau falowo Jisas le le leletei Jisas piti ma kanio. ");
INSERT INTO ong_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Le lirpeiye, “Ili leiki, metine liti lesio towa leiki, le olo letei luwo winem, kainu lire meli, le ire re esi pele pa.” ");
INSERT INTO ong_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Fei Jisas lirpeiye, “Ki ma kau kapi kainu pele tanio.” ");
INSERT INTO ong_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wolo metine piti luntoluwepe yali pal, le nou lirpowo Jisas-ye “Kyei olo, ki olo teingi kolo, le ye ma au winem leiki pato. Ye irpeiye le metine piti lesio towa leiki, le miso nou fale teingi. ");
INSERT INTO ong_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wusoli ki re, ki kesio towa leiki kunkunguwepe mete lipi nemple, le ki namti kuntoluwepe yali pal. Ki kirpowo yalu pau fei lepei piti le ma le, le le, le kirpowo nele piti le ma lau, le lau. Le ki kirpowo yalu pau piti le ma lesio towa fei lepei, le lesio.” ");
INSERT INTO ong_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas linlele lotei wem le lingitepe il fei pepei, le le lirpepe mete wuso pulsesi pe pepe, lirpepeye, “Ki kirpeise punkom, ki kerengawo metine nele lite Israel watafei metine fei lepei kolo, metine fei lepei le lulpope il peiki lirkilautei. ");
INSERT INTO ong_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Le ki kirpeise, mete wuru piti epli fale le piti epli lautile pe pite alpe nemple nemple pe ma paule pire Abraham, Aisak re Jekop pepi paplei oweli lipi pifei uf lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wolo eple palye pite Israel, potei piti ma pire Ma Ili pratei uf lele pepe, pe ma Ma Ili liripe pe towa yawi munkunum, le pe ma poutiti re paplei rofrereipe nilpe pelpe.” ");
INSERT INTO ong_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Leye lo Jisas lirpowo metine piti luntoluwepe yali pal lepe, Jisas lirpowoye, “Ye nou e winem leiye. Metine liti lesio towa leiye lepe le miso nou fale teingi wusoli ye ulpope il peiki.” Le wem fei lepeye, metine wuso kainu lepe olo nou lironomye, kainu oloye. ");
INSERT INTO ong_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Wem Jisas linki le winem lite Saimon Pita, le lulwene nimou pite Pita moto pele, ne kainu, le ne netei nuwo poi. ");
INSERT INTO ong_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisas lesiene eti lene le ne kainu olo, nironomye. Le ne neifale kapi oweli watowo Jisas laplei. ");
INSERT INTO ong_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wem epli lautile, mete pilape wuru pelpe wuso towa punkuwepe, pe pilape pe Jisas. Jisas lirpei le towa olpe pepe, pe naro pe taniepe mete wuso punkuwepe pepe, le mete wuso kainu polomen re, Jisas kapi kainu pelpe taniepe. ");
INSERT INTO ong_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jisas lolpepei piti ma laptei il pite metine nimou Aisaia fale punkom; metine nimou Aisaia sungoi liye lirpei lolpepei, “Ili lotei kapi kainu pouku lilape le tanuku.” ");
INSERT INTO ong_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wem nele, wem Jisas lulwepe mete wurutei pile neinowo, le lirpepe pupam pele piti ma pepi pe tuluple mingo plen. ");
INSERT INTO ong_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Fei metine nele piti leptalo mete lire il lipi pite Moses, le le falowo Jisas, le le lirpowoye, “Ye metine ili, ki koporo kutei piti ma ye linei linei e, ki ma kulteiye ke.” ");
INSERT INTO ong_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisas namti lirpowoye, “Morou seikir, pe era namplungu pelpe piti pinki puwo, le naflepem piti yuwei, pe onkotu pelpe piti pautile pawo, wolo Ninge lite Metine Wape, le tulum nele lele piti laltei falo lele luwo re kolo, olo.” ");
INSERT INTO ong_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Fei metine nele, le pupam lite Jisas, le lirpowo Jisas lirpeiye, “Ili leiki, ki ma kulteiye, wolo ye ma inu usaiki nou ke kaltei eiya leiki wo.” ");
INSERT INTO ong_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Wolo Jisas lirpowoye, “Ulteiki le ye usape mete pelpe piti ma pa, pe ma paptei pule pelpe potei.” ");
INSERT INTO ong_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Leye lo Jisas longlo nimpe teingo le pupam pele re pe pepi ponglo peye. ");
INSERT INTO ong_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yuf lire nampune fale frou yo fei losiepe le tipe loungongo leingalolo nimpe teingo lepe, mulfiye. Wolo Jisas letei luwo nimpe teingo lepe. ");
INSERT INTO ong_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pupam pele pe kumsasi le pe pirpowoye, “Ili louku, ye kanouku. Ku ma mautileye ko.” ");
INSERT INTO ong_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jisas namti lirpepeye, “Ise turise yire tekeke piti men? Ise yulpope il peiki yirkilau lo olo?” Leye lo Jisas leifale lirpei le yuf kere le tipe lirkir luwo. ");
INSERT INTO ong_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Pupam wuruye pinlele potei le pe pirpeiye, “Metine men so lolpepei? Yuf re tipe wuso loungongo lepe pe paptowo mingim, yuf kere le tipe lirkir luwo.” ");
INSERT INTO ong_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wem Jisas le fale tuluple mingo plen le liti epli fale, tef lite mete pite uf Gadara, mete twinges, towa punkuwenge, te rounge tato era namplungu piti paplingi towa puwo, te tato fei lepe so tau terengawo Jisas. Te rounge tirkirau tratei tulum fei lepe, le mete olo turwepe, le pe pingio tisi fei lepe pe kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Fei te rounge tailolo tirpeiye, “Ninge lite Ma Ili, ye ma kali men irouku? Wem liti Ma Ili ma wauku moingi wala olo, le ye au piti ma wauku moingi lom?” ");
INSERT INTO ong_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Fei songou wurutei pile paplei oweli pe fiyen taise. ");
INSERT INTO ong_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Le towa wuso tunkuwenge mete walem twinges tepe, te tirpowo Jisas tirpeiye, “Wuso ye ma eituku naro we tanienge mete walem fei tepei, ye eitouku we songou wurutei piye.” ");
INSERT INTO ong_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisas lirpenge towa tepeye, “Rounge ye.” Liso towa tepe naro tusange mete walem twinges tepe le te te tunkuwepe songou wurutei wuso pile paplei oweli pepe. Songou wurutei pepe, yeflipiye pantu pufro nemple pitipi alu pe pautile tuluple, pa yalipeye, pa pratei tipe. ");
INSERT INTO ong_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mete piti puntoluwepe songou pepe pantutu pe fale uf pirpepe pire men wuso falepe songou pelpe pepe, le mete walem twinges wuso pretange te towa punkuwenge tepe. ");
INSERT INTO ong_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Leye lo mete pite uf Gadara yefliye, naro pe perengawo Jisas. Le wem pe puluwo Jisas, pe pirpowo piti le ma le tani tef lelpe. ");
INSERT INTO ong_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas longlo nimpe teingo le le nou le tuluple mingo plen liti epli lautile, le le fale uf lele Kaperneam. ");
INSERT INTO ong_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mete nemple pila metine nele, le ire re esi pele pa. Pe pila metine fei lepe luwo flenge, le pe pila pe falowo Jisas. Jisas lulwepe mete fei pepe, pe pulpope il pele pe so pila metine wuso ire re esi pele pa, le pe pila pe falowo Jisas. Jisas lirpowo metine wuso ire re esi pele pa pepe, Jisas lirpowoye, “Ninge leiki, ye onom teingine. Ki ma onposiepe il olpe peiye kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Leye lo mete piti peptalo mete nemple pire il lipi pite Moses, pe pirpei nempleiye, “Metine fei lepei, le lirpei kelelawo Ma Ili, wusoli Ma Ili loteteiye ma onposiepe il olpe pite mete kolo olo. Metine yawi ma olo.” ");
INSERT INTO ong_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas retape enke pelpe le le lirpepeye, “Piti men ise onposiepe il olpe? ");
INSERT INTO ong_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Il flo fei polomen ma kirpei. Ki ma kirpei kolo, ‘ki onposiepe il olpe peiye kolo olo’, lo ki ma kirpei kolo, ‘eifale ilele e?’ ");
INSERT INTO ong_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wolo ki ma kusaise kire singe lite Ma Ili le ise ma retai yolpepei Ninge lite Metine Wape ma onposiepe il olpe kolo wusoli le lau lire singe pite Ma Ili.” Leso Jisas lirpowo metine wuso ire re esi pa lepe, Jisas lirpowoye, “Eifale kapi flenge peiye le ye e winem leiye.” ");
INSERT INTO ong_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Le metine lepe leifale le winem lele leye. ");
INSERT INTO ong_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wem mete wurutei pepe pulwepe fei pepei, pe turwepe le pe rautuwo Ma Ili piti le watepe mete walem singe watafei le watowo Jisas. ");
INSERT INTO ong_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas lusa tulum fei lepe le le wala lilele le, le le luluwo metine nele piti kapipi era ilepe pite mete wuso paptetei re paisesipe oweli, le le ma kapi era pepe ma watepe moli lipi pite Rom. Metine fei lepe le nange lele Matyu, le le lifei winem kumpu piti mete ma paule watotowo era pire kari towa lelpe liti pesio, le Jisas lirpowoye, “Ye ulteiki.” Le Matyu leifale lulsi Jisas leye. ");
INSERT INTO ong_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wem Jisas wala laplei oweli lifei winem lite Matyu, mete wuru wuso pesio towa watafei Matyu le mete nemple piti pire il olpe, pe pau pire Jisas re pupam pele pepi paplei. ");
INSERT INTO ong_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wem mete pite Farasi puluwo Jisas lolpepei, pe pepletei pupam peleye, “Piti men metine piti leitaleise, le liripe mete piti kapiepe mete era le mete piti pire il olpe, le liripe pepi paplei oweli?” ");
INSERT INTO ong_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas lingitepe le le lirpeiye, “Mete piti kainu kolo ma pe puluwo metine nimou kolo, pe piti kainuye miso pe puluwo. ");
INSERT INTO ong_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wolo ise ma ye yintape il pal piti il wuso pirpei polpepei, ‘Ma Ili onom natoise piti ise ma yeptawio siye kolo olo, le onom natoise piti ise ma kapi enke yaptepe mete nemple.’ Ki kaule piti ma kinape mete piti pire il olpe, le mete piti pirpei polo pe pingiepe il lipi pite Moses, pepe ma kinape kolo.” ");
INSERT INTO ong_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Leye lo pupam pite Jon pele pe pe le pe peletei Jisas pirpeiye, “Piti polomen so ku mire mete pite Farasi, ku ma wem ku onposio Ma Ili, ku ma maplei oweli kolo, wolo pupam peiye pe paplei oweli?” ");
INSERT INTO ong_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas namti lirpepeye, “Wem metine nele ma lire moto pele roum maiteneme le le linape numuwi pele pau ma piri pepi paplei oweli, numuwi pele pepe ma pouti kolo, pe ma rautunemple. Wolo wem metine fei lire moto roum maiteneme meme, mete nemple ma petesi la, is numuwi pele ma poutuwo le pe pirowo nimpi, pato yaupe, paplei oweli kolo.” ");
INSERT INTO ong_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Minele miso kali takor oli punko le le lalwewe lasi teingi namin, miso olo. Takor oli punko lepe ma kerere frou. ");
INSERT INTO ong_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Le minele ma lire wengle tipio lire lalfo luom lali. Wuso le lolpepe, weli ma lalei kareri wengle tipio lepe le luom ma wala namin, weli lalei kolo. Olo ma metine lepe le ma lalfo luom wengle teingi yefli soma wem le lali weli, weli ma lalei wengle linge topo yuwei le luom ratei wengle leinginim miso weli lalei loporo.” ");
INSERT INTO ong_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wem Jisas wala lirpepe lire il fei pepe, metine nele ili lite Juda, le lau falowo Jisas le le yaru yamkelem ratowo Jisas onom le le lirpeiye, “Ningio peiki wala fei lepei na wolo ye ma au eptalo esi peiye puwone le ne ma nou neilo.” ");
INSERT INTO ong_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Liso Jisas leifale le le pupam pele re pepi pe. ");
INSERT INTO ong_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Moto nenpe, ne nilala notei ne eringi wuru (12). Ne ningowo Jisas tounga ne, le ne nesio um lite olol lite Jisas. ");
INSERT INTO ong_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ne nirpepei notei nolpepei, “Wuso ki kesio olol lele yawi, ki ma nou kilala teluwi kolo oloye.” ");
INSERT INTO ong_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisas weitei luluwene moto fei nepe le le lirpeiye, “Ningio peiki, ye onom teingine. Ye ma nou teingine wusoli ye ulpope il peiki.” Le wem fei lepeye, moto fei nepe ne nou nilala teluwi kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Fei Jisas linki le winem lite metine ili lite Juda. Wem le luluwepe mete piti pireripe angelpuwi pire paplelene towa, le mete wuru wuso panfine towa le pe pire ipli pratei winem pepe, ");
INSERT INTO ong_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jisas lirpeiye, “Ise naro ye tani. Ningio kumpu nepei, ne olo na kolo, ne netei.” Wolo mete wuru pepe pe palwe oli le pe pinyalio Jisas. ");
INSERT INTO ong_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wem mete wuru pepe naro pe tani winem, Jisas linki le elpeingo lite ningio kumpu wuso na nuwo lepe, le le lesiene eti lene, le kumpu nepe nou neilo nile. ");
INSERT INTO ong_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Il pene rufro pingene tef yefliye lite Galili. ");
INSERT INTO ong_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas lusa winem fei le leilane ningio kumpu nepe, le le wala lilele le. Mete twinges te lutepe pelnge olpe le te rounge tulsi Jisas te, le te rounge tailolo tirpeiye, “Ninge palyene lite Devit, onom manouku.” ");
INSERT INTO ong_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wem Jisas le linki winem, mete twinges wuso lutepe pelnge olpe pepe, te rounge te tirowo malfem, le le louteteiye, “Ise rounge yulpo yirpolo ki miso nenfaripe lutepe peise rounge lom?” “Iyo, ili louku.” Te namti tirpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Leye lo Jisas lesiepe lutepe pelnge le le lirpeiye, “Wusoli ise rounge yulpo yirpolo ki miso nenfaripe lutepe peise rounge le fei ise rounge ma nou yuntolili.” ");
INSERT INTO ong_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Le lutepe pelnge nenfaro le te rounge nou tuntolili. Jisas lire il singe lirpengeye, “Ise rounge ma yirpepe mete nemple yire isotei rounge fei nou yuntolili lepe, ma yirpepe pato.” ");
INSERT INTO ong_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wolo te rounge naro te tirpepe, le il rufro pinge tef yefliye lite Galili. ");
INSERT INTO ong_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wem mete twinges fei tepei, te naro te tani, mete nemple pila metine nele pau falowo Jisas. Metine fei lepe olo lirpepei kolo, towa kapi il namplio. ");
INSERT INTO ong_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Wem Jisas laltu towa lepe naro le tanio metine wape lepe, metine lepe nou lirpepei. Mete wuru pepe pe pinlele potei le pe yafei pirpeiye, “Sungoi ku pite Israel, ku muluwo metine nele lesio towa watafei le lepei kolo.” ");
INSERT INTO ong_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wolo mete pite Farasi, pe pirpeiye, “Jisas, le lire singe pite towa nimou laptu towa kumpu pepe, pe so naro pe taniepe mete.” ");
INSERT INTO ong_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas le uf walem lipi kumpu, le le leptalo mete lifei angli pal pelpe. Le leptalo lire il teingipe piti wem Ma Ili ma luntoluwepe, le le kapi kainu men nange taniepe mete. ");
INSERT INTO ong_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wem Jisas luluwepe mete wurutei, le onom manepetei wusoli pe enke olpe, le pe fupepletei pire tisi men ma pingio. Pe fupepletei watafei sipsip wem metine piti luntoluwepe, le lusape pratei ire pelpe le pe fupepletei pepe. ");
INSERT INTO ong_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Leye lo Jisas lirpepe pupam pele lirpeiye, “Oweli piti poungo olo wurutei wolo mete piti kotuwepe oweli pepe, pe olo yaipiyeye. ");
INSERT INTO ong_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ise ma yeletei Ma Ili, le yaitei lite liom fei lepe le le ma laisipe mete pele pe kotuwepe oweli wuso poungo pepe.” ");
INSERT INTO ong_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas linape pupam pele pire esi plen le plen te twinges (12), le le watepe singe piti kapi kainu eryai pepe taniepe mete le le watepe singe piti paptu towa ririm olpe pepe le pe naro pe taniepe mete. ");
INSERT INTO ong_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pupam fei pepei Jisas keiniepe laptei lotei. Pe pire esi plen le plen te twinges, Jisas linu keinio Saimon (pinawo Pita) lire winke lele Andru, Jems lire winke lele Jon, te eple winge titi Sebedi. ");
INSERT INTO ong_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip lire Bartolomyu le Tomas re Matyu (le metine piti kapiepe mete era piti watepe moli lipi pite Rom.) Jems le ninge lite Alfius, le Tadius, ");
INSERT INTO ong_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon Selot (le metine lite linaulipe mete pite Rom piti ma puntoluwepe mete pite Juda kolo), le Judas lite Iskariot, le laltei Jisas le eti pite mete, le pe penglei. ");
INSERT INTO ong_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pupam pire esi plen le plen te twinges wuso Jisas keiniepe pepe, le laisipe pe le le lirpepe lamtetepe lolpepei, “Ise ma ye uf kumpu pite mete pite Samaria kolo, le tef liti mete piti rautuwepe weni ririm olpe, mete fei pepe re ise ma ye falepe kolo, olo. ");
INSERT INTO ong_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ise ma ye falepe mete pite Israel wuso kotire watafei metine piti luntoluwepe sipsip wolo le lusape pe ire pelpe le pe kotire pepe. ");
INSERT INTO ong_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ise ma ye yeptalo il yolpepei, ‘Wem liti Ma Ili ma luntoluku olo lau lire malfemye.’ ");
INSERT INTO ong_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ise ma kapi kainu pelpe taniepe, mete pelpe pa ise ma nou yeilape, pape olpe poluwepe ise ma yaptu taniepe, towa olpe punkuwepe ise ma yaptu taniepe. Singe fei lepei ki waise yawi, le ise re ma kaniepe mete yaupe, pe ma paiteise kolo, olo. ");
INSERT INTO ong_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ise ma yilape mole pratei tenge eple peise kolo, ");
INSERT INTO ong_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","le ise ma yilape tenge lipi ye kolo, lo olol nele lo ire topungou lo efle, ma olo, yilape pepe ye kolo. Wusoli metine wuso lesio towa piti kaniepe pe ma namti pailelowo.” ");
INSERT INTO ong_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Wem ise ye fale uf kumpu lo ili, ye lupkarepe mete piti pe enke teingipe pireise le pe keteise pilaise pe winangou pelpe, ise ma yiripe ratei ye ye ma fale wem liti ise ma yusa uf fei lepe le ise ye nele. ");
INSERT INTO ong_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wem ise yinki ye winem lepe, ise ma yirpeiye, ‘Ma Ili laileleise.’ ");
INSERT INTO ong_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wuso mete pite winem lepe, pe paileleise, il wuso yinu yeisipe yirpolo Ma Ili lailelepe pepe, Ma Ili ma lupingiepe il fei pepe le le ma lailelepe mete fei pepe punkom. Le wuso mete pite winem lepe pe paileleise kolo, il wuso yinu yeisipe yirpolo Ma Ili lailelepe pepe, il fei pepe ma kere yaupe, Ma Ili ma lupingiepe le le lailelepe mete pepe kolo. ");
INSERT INTO ong_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Le wuso mete pite winem lo uf nele, pe enke teingipe peireise le pe keteise pilaise pe winangou pelpe kolo, lo pe papteise mingim kolo, ise ma yapiri il teingipe pite Ma Ili ma yirpei kolo, wolo ise yirpepe Ma Ili ma watepe moingi ilitei, le ise ma ye taniepe le ise ma yusape pratei pire il olpe pelpe. ");
INSERT INTO ong_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ki kirpeise punkom, wem liti Ma Ili kapi il laptei lire moingi pite mete, mete pite uf fei ise ye le pe paileleise lo papteise mingim kolo pepe, pe ma pila moingi ilitei, le mete pite Sodom re Gomora, pe ma namti pila moingi kumpu.” ");
INSERT INTO ong_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ki kaiteise ye watafei sipsip, ye yeingalope pelem olpe nimin. Ise ma kotopa isotei watafei tutungu le ise ma yire yape watafei naflepem malpum. ");
INSERT INTO ong_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wolo ise ma kotopa isotei yire mete, pe ma pengleise pilaise pe fale moli lipi le pe ma pire foiye posise pifei angli pal pelpe. ");
INSERT INTO ong_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pe ma keteise pilaise pe falepe moli lipi piti puntoluwepe mete wusoli ise yulteiki ki, le ise yirpepe yire il teingipe piti wem Ma Ili ma luntolise. ");
INSERT INTO ong_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Wem pe keteise pilaise pe falepe moli lipi piti ma pingitepe re kapi paptei pire il peise, ise ma enke olpe kolo yire il men piti yirpei, le piti ma yirpei yolomen, olo ise ma enke olpe kolo. ");
INSERT INTO ong_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wusoli il men piti yirpei il fei pepe ma peise kolo, Riri lite Eiya, le Ma Ili leise, le ma lirpei il fale nemi peise.” ");
INSERT INTO ong_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ilim ilepe ma watepe winkem pelpe moingi, yaitei nele ma watowo ninge lele moingi, le eple ilepe ma pire yaire pelpe pepi pura nemple, le ilepe pelpe ma pa. ");
INSERT INTO ong_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mete wuru ma enke kotu pireise wusoli ise yulteiki ki, wolo minele piti lire lotei singe le le lila moingi le le fale wem liti Ma Ili ma luntolise, metine wuso lire lotei singe le le lila moingi lireiki, Ma Ili ma kanio metine fei lepe. ");
INSERT INTO ong_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wem mete pite uf nele pe waise moingi, ise ma yantu ye uf nele. Ki kirpeise punkom, ise wala ma yeptalo il pite Ma Ili yinge uf walem pite Israel wem Ninge lite Metine Wape ma nou lau.” ");
INSERT INTO ong_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Pupam nele ma namti fale raltei metine piti leltalo kolo, lo metine piti lesio towa, le ma namti fale raltei metine piti watowo towa lesio lepe kolo, ma olo. ");
INSERT INTO ong_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pupam lepe le ma kapi il pite metine wuso leltalo le le ma retape yo fei, rounge toparu nouteye. Le metine piti lesio towa, le re ma lesio towa fei lepe le le ma retawo fei, le ma fale watafei metine piti linu watowo towa piti lesio lepe, rounge toparu nouteye. Le wuso metine lila moingi pupane lele ma roungesye ma tila moingi. Wuso pe pinawo yaitei lite winem, pinawo pirpolo le ‘towa nimou’ eple pite metine fei lepe, pe ma pinape nange olpetei peptalipe.” ");
INSERT INTO ong_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ise ma turise yiripe kolo. Il pite kotire pato, pe ma fale alepe nimin, le il kumpu piti loule piri nemple, il fei pepe, pe ma yirpei yirkilau le mete wuru ma pretape. ");
INSERT INTO ong_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Il men piti ki kirpeise mulpou, ise ma yirpei epli. Il men piti ki kirpeise kafoise mingim, ise ma yile winangou tupelengi le ise yirpei il lipi.” ");
INSERT INTO ong_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Ise ma turise yiripe mete piti petesi topo yawi la wolo pe miso petesi riri la kolo, ise ma turise yiripe kolo. Ise ma turise yire Ma Ili, le ma letesi topo la lorworo le riri le ma liri le weli lalei. ");
INSERT INTO ong_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Minemple re miso pire eifingu maltou twinges pire paisime nafle elalwongou wiem le nafle nenpe ma na yaune kolo, ma Ma Ili lirpei soma ne na. ");
INSERT INTO ong_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Le Ma Ili, le retape oru fei polomen pe poli falo leiye. ");
INSERT INTO ong_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","So ise ma turise pato, Ma Ili litipise lirkilautei le naflepem olo, le litipiepe watafei ise pepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Minele lirpepe mete wuru lirpolo le lulteiki ki, ki re ma namti kirpowo Eiya leiki liti yuwei, kirpowo kire metine fei lepe. ");
INSERT INTO ong_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Le minemple piti pulteiki ki, wolo pe pirpepe mete wuru kolo, pe peingi potei, ki re ma namti kolpepe. Ki ma kirpowo Eiya leiki liti yuwei kiripe mete fei pepe kolo, ma olo.” ");
INSERT INTO ong_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ise ma onposi yirpolo ki kaule piti ma kalteise wem teingi lom? Olo, ki kaule piti ma kalteise wem teingi kolo, olo ki kila werau kau. ");
INSERT INTO ong_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ki kaule piti ma kaltei ninge tulei lire yaitei lele rounge ma tura noute, ningio feri ma nire nimou pene roum ma mura neme le ningio yenkio ma nire nimou piti nila munge lene, me roum ma mura neme. ");
INSERT INTO ong_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Metine piti lulteiki, ilim winkem pele piti nimou yaitei nemiyeyeye ma weitei piri le pepi pire nemple eringi.” ");
INSERT INTO ong_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Metine minele piti le onom kereme nimou re yaitei pele lirkilautei le ki olo, le onom kereiki wisyauye, metine fei lepe ma ki kulpowo kolo. ");
INSERT INTO ong_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Le metine minele piti lila moingi lele le le lingeiki kolo, le le linaulo piti ma la lire il peiki, ki ma kinawo metine fei lepe le pupam leiki kolo. ");
INSERT INTO ong_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Metine minele piti litipi lotei le le lila moingi lireiki kolo, le ma lalingou nempi lele. Le metine minele piti lila moingi lireiki, metine fei lepe ma nou kali nempi lele piti ratei lingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Metine minele piti kani onom lanteiye, le ma watafei le kani onom lanteiki ki, le le kani onom lantowo Metine piti laiteiki kau. ");
INSERT INTO ong_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Metine minele piti kani onom lantowo metine liti leptalo il pite Ma Ili, wusoli le metine liti leptalo il pite Ma Ili, metine fei lepe lire metine liti leptalo il pite Ma Ili lepe, te roungesye ma Ma Ili lailelenge lautuwonou. Le metine minele piti kani onom lantowo metine nele piti lulpope il pite Ma Ili, le lingiepe, wusoli le lulpope il pite Ma Ili, te roungesye ma Ma Ili lailelenge lautuwonou. ");
INSERT INTO ong_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Le wuso metine nele, le kali men kumputei watafei le lalfo wengle pau lire tipe, le le watowo metine nele kumpu fei lulteiki lepei, wusoli le pupam leiki, ki kirpeise pumkom Ma Ili ma lailolowo metine wuso lire fai, le le lalfo tipe watowo pupam leiki lepe.” ");
INSERT INTO ong_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wem Jisas il poluwepe pupam pele pire esi plen le plen te twinges, Jisas il poluwepe re fei, le lusa tulum fei lepe, le le leptalo il le uf nemple pingene tef lite Galili. ");
INSERT INTO ong_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wem Jon lifei winem oli le lingitepe pirpei pire towa wuso Krais lesio. Krais le metine wuso Ma Ili laltei lau lepe. Jon lingitepe le le laisipe pupam pele pe falowo Jisas, ");
INSERT INTO ong_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Pe peletei Jisas polpepei, “Ye irpouku, ye lepe so Jon lirpouku lireye piti ye ma au lepe lo ku wala ma mungario nele?” ");
INSERT INTO ong_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisas namti lirpepeye, “Ise nou yilape il ye yirpowo Jon yire men nange wuso ise yingitepe re yulwepe pepe. ");
INSERT INTO ong_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mete piti lutepe pelpe olpe wolo pe nou puntolili, mete ire pa wolo pe nou peifale pilele pe, mete wuso pape olpe poluwepe wolo pe nou fale teingipe, mete wuso mingim pelpe olpe wolo pe nou pingitei poporo, mete wuso pa wolo pe nou peilo le mete wuso pe oweli yini men nange olo pepe wolo pe pingitepe il teingipe pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Metine piti lulpope il peiki pire towa fei ki kesio, le le onom nenpe nenpe kolo, le ma onom teingine, Ma Ili ma lailolowo.” ");
INSERT INTO ong_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Fei pupam pite Jon pele pe wala so pe le Jisas lirpepe mete wurutei pepe, lirpepe lire Jon. Jisas lirpepeye, “Ise naro ye tef oli era re telmane ye yawi lepe le ise ma yuluwo mi? Ise ma yuluwo metine le linge le yuwei yawi watafei wolo wuso yuf lini lalpopo lepe lom? ");
INSERT INTO ong_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wuso olo, le ise ye yuluwo men? Ise ma yuluwo metine lafo olongou teingipe lom? Mete piti pafo olongou teingipe, pe ma pratei winangou teingipe lipi. ");
INSERT INTO ong_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yirpeiki, ise naro ye yuluwo men? Ise yuluwo metine nimou lom? Iyo, ki kirpeise, ise yuluwo metine nimou lepei le namti linuwepe mete emarengi wuru pepe. ");
INSERT INTO ong_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon lotei so il pite paitei yousi, pe pirpei piri polpepei, Ma Ili lirpeiye, ‘Ki ma kaltei metine piti lilape il linuye le, le ma linu le naliye tisi.’ ");
INSERT INTO ong_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ki kirpeise punkom, Jon liti kaptetei mete, le nange lele ili, metine nele le nange ili watafei le kolo. Wolo fei metine minele piti lulpope il peiki piti wem Ma Ili luntolise, metine fei lepe le namti fale linuwo Jon. ");
INSERT INTO ong_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Wem Jon liti kaptetei mete, le le lau fale fei, il pite wem Ma Ili ma luntoluwepe mete pite tef olo rufro pirkilautei pe, le mete pirkilau pirpolo ma paploupe il fei pepe karipe. ");
INSERT INTO ong_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mete emarengi wuruye, le il lipi pite Moses pau pau fale wem liti Jon, pe pirpei pire wem liti Ma Ili ma luntoluwepe mete pite tef. ");
INSERT INTO ong_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Le wuso ise yulpope il fei pepe wuso pirpei polo Ilaija ma nou lau, Jon so namti lau lepe. Le lilowo Ilaija tulum. ");
INSERT INTO ong_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wuso ise minemple piti mingim poli, ise ma yingitei.” ");
INSERT INTO ong_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","“Mete piti wala nampir pratei pepe, pe ma ki kaptei poungai mi? Pe ma watafei eple kumpu pratei uf nimin. Pe paptei nemple minim le wem pe pirpei nemple piti ma puro ilepe pelpe pinaulo. Le wem pe pirpei nemple piti ma pouti ilepe pelpe wala pinaulo. ");
INSERT INTO ong_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Wusoli Jon laule le le laplei oweli teingipe kolo, le le lalei wain tipe kolo, le le lini lurungo kolo olo. Le mete wuru pinaulo pirpei polo, ‘Le towa lunkuwo.’ ");
INSERT INTO ong_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Wolo Ninge lite Metine Wape, le lau laplei oweli re tipeluwi le mete pinaulo pirpeiye, ‘Le metine piti laplei oweli lipi le le laplei tipeluwi, lini lurungotei. Le numu liti mete piti kapiepe mete era piti watepe moli lipi pite Rom, le le liripe mete piti pire il olpe pepi panfo nemple pifei.’ Wolo mete piti Ma Ili watepe enke pire wuru, pe ma puluwepe matufwepe pe mete pite Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Leye lo Jisas lingiepe il lirpei liripe uf lipi wuso le lirpei le men nange wuru potei pire tute fale yaupe. Jisas lirpei liripe wusoli mete pite uf lipi pepe pe pusape il olpe pelpe kolo, wala olo. Jisas lirpeiye, ");
INSERT INTO ong_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ye uf ili Korasin, moingi ilitei ma faleiye. Ye uf ili Betsaida, ye re moingi ili ma faleiye. Wuso ki kirpei le men nange potei pire tute faleise pepe, pe ma faleise kolo oloye, le pe falepe mete pite uf lingi Saidon lire Tair, mete pite uf lingi tepe, pe ma sungoi liye pualo fanke le pe pouti pire il olpe pelpe le pe ma pusape il olpe pelpe patoye. ");
INSERT INTO ong_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wolo ise ma retai yolpepei, wem piti Ma Ili ma lingitepe le le kapi il laptei liripe moingi pite mete pite tef, ise mete pite uf lingi Korasin re Betsaida, ise ma yila moingi ilitei le mete pite Tair re Saidon, pe ma namti pila moingi kumpu. ");
INSERT INTO ong_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Le ye uf Kaperneam, ye onom puwope men nange pite tef ma kapi aptei yotei le ye ma fale ili lom? Ma olo, Ma Ili ma lireiye uwalo weli. Wuso ki kirpei le men nange potei pire tute faleiye pepe, pe falepe mete pite uf Sodom, uf Sodom fei wala ma lato. ");
INSERT INTO ong_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ise mete pite Kaperneam, ise ma retai yolpepei wem liti Ma Ili ma lingitepe le le kapi il laptei liripe moingi pite mete pite tef, ye uf Kaperneam ma ila moingi ili, le uf Sodom ma lila moingi kumpu.” ");
INSERT INTO ong_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wem fei lepe Jisas lirpeiye, “Eiya, ye ili liti yuwei re tef. Ki rautuye wusoli ye kusape mete piti pire wouye, ye kusape ire il men men wuso ye aplingi iripe mete pe enke pire wuru. ");
INSERT INTO ong_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iyo Eiya, ye onom peiye ye aptei men nange le ye onom teingine aisepe.” ");
INSERT INTO ong_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Eiya leiki le waiki men nange yeflipiye. Minele re retawo yaitei kolo, ninge loteteiye retawo le minele re retawo ninge kolo, Yaitei loteteiye retawo. Yaitei retawo ninge le mete wuso ninge lotei keiniepe piti pe ma pirpepe mete piri Yaitei lotei.” ");
INSERT INTO ong_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ise wuruye wuso yila men ili moingi le ise yef ili yalfo nemi, le ise enke olpe, ise yau ki, le ki ma kali men ili moingi lepe tanise le ise ma yaltei yef. ");
INSERT INTO ong_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ise kapi il peiki yingiepe, le ise ma retape wusoli ki kire yape, le ki keitaloise kire il malye, le ise ma yerengawo tisi liti yingio ye, le ise ma ratei yaltei yef ratei lire enke malye. ");
INSERT INTO ong_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Il peiki piti keitaloise kiripe olo pautu le ise retape frou, le towa leiki piti waise yesio olo flo, moingi kolo.” ");
INSERT INTO ong_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wem nele Jisas lingio tisi linge liom liti pari wit. Wem fei lepe le wem liti mete pite Juda, pe ma pifei onposio Ma Ili. Fei Jisas pupam pele pe nimpi naplei, le pe karipe wit paplelei. ");
INSERT INTO ong_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Wolo wem mete ilepe pite Farasi, pe pulwepe polpepei pe pirpowo Jisas-ye, “Untoli, pupam peiye pe yaruwepe il lipi pite Moses. Ku wem piti mifei onposio Ma Ili ku ma mesio towa men kolo, ma olo mifei yaupe.” ");
INSERT INTO ong_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisas namti lirpepeye, “Ise yungunape il lipi pite Ma Ili ko? Il pite wem metine ili Devit liripe mete pele pe nimpi naplei le pe kali men? ");
INSERT INTO ong_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deifit liripe mete pele, le le linki winem lite Ma Ili, le le kali luom liti paltei watowo Ma Ili, le pe palei luom lepei. Mete piti peptawio Ma Ili siye, pe poteteiye ma palei luom fei lepe, wolo Devit liripe mete pele pe palei luom fei lepe, le pe yaruwepe il, wolo Ma Ili onom one liripe kolo. ");
INSERT INTO ong_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ise yungunape il lipi pite Moses ko? Il wuso pirpei polo wem liti pe ma pifei onposio Ma Ili pe ma pesio towa men kolo, wolo mete piti peptawio Ma Ili siye, pe pesio towa lelpe wem fei lepe, le pe yaruwepe il, wolo Ma Ili onom one liripe kolo. ");
INSERT INTO ong_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ki kirpeise, towa fei ki kesio lepei le ilitei linuwo towa liti ise yesio yifei winem lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Il lipi pite Ma Ili pe paptei pirpei polpepei, ‘Ki onom puwoise piti ise ma kapi enke yaptepe mete nemple le piti yeptawiki siye ma olo, ki onom puwoise piti ise ma yolpepe kolo.’ Wuso ise retape il fei pepei yailelepetei, ise ma yamtuwepe mete yaupe kolo. Wusoli wem Ma Ili onom manepe mete pepe fei, ise ma yamtuwepe yaupe kolo. ");
INSERT INTO ong_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wusoli Ninge lite Metine Wape, le ili piti luntoluwo wem liti ise yifei onposio Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas lusa tulum fei lepe le le le fale lifei angli pau nele lelpe. ");
INSERT INTO ong_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Le metine nele ratei uf fei lepe, le eti tilpi lele la. Fei mete nemple, pe pinta tisi piti ma pamtuwo Jisas, pe peleteiye, “Il lipi pite Moses pe pirpei piti wem ku ma mifei yaupe onposio Ma Ili, le ku ma kapi kainu taniepe mete lo ma olo?” ");
INSERT INTO ong_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisas namti lirpepeye, “Le wuso nele leise le sipsip lele lualo lautile oi wem liti ise yifei onposio Ma Ili. Ma metine fei lepe, le ma le nalwe sipsip lele tani oi wem fei lepe ko? ");
INSERT INTO ong_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ma Ili onom puwotei liri metine wape le sipsip olo, le onom puwowo kumputei. Min polpepei so il lipi pouku pirpei polo wem piti ku mifei onposio Ma Ili, ku ma kaniepe mete.” ");
INSERT INTO ong_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Leye lo Jisas lirpowo metine wuso eti tilpi lele la lepe, Jisas lirpowoye, “Kesi eti leiye altei ire ulel.” Fei metine lepe kesi eti lele laltei, le eti lele nou fale teingiye watafei eti lele plen liti enkau lepe. ");
INSERT INTO ong_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Wolo mete pite Farasi pe naro pe yaruwepe il pafo piti ma petesi Jisas la. ");
INSERT INTO ong_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Wem Jisas retai pe ma polpepe, le le tani uf fei lepe. Mete wuru pulsi pe, le kainu men eryai pepe Jisas kapi taniepe, ");
INSERT INTO ong_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","le le lirpepe piti pe ma pirpepe mete nemple piri le pato. ");
INSERT INTO ong_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jisas lolpepe piti ma laptei il wuso Ma Ili lirpei fale nemi lite metine nimou Aisaia le il fei pepe ma fale punkom. Ma Ili lirpeiye, ");
INSERT INTO ong_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ki keinio metine fei lepei, le le ma lesio towa leiki. Ki onom puwowo, le ki onom teingine kasio. Ki ma kaltei Riri Teingi leiki linkio, le le ma lirpepe mete eryai pingene tef, le ma lirpepe lire il tuwopou peiki piti kaniepe mete pite tef. ");
INSERT INTO ong_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Le ma liripe mete pepei pire il pura nemple kolo, le le ma lailolo kolo, leptalo il lire tangu kolo, ma olo. Le le ma lile tisi lipi pepe kolo, ma olo. ");
INSERT INTO ong_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mete piti pire wouye lo piti pire yape, le ma lire il singe lirpepe kolo. Le ma lesio towa fei lepe, le le yo ma weisipe mete ma pingiepe il pite Ma Ili, ");
INSERT INTO ong_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","le mete eryai pite tef pe ma kani onom pantowo le loteteiye, le le ma kaniepe.” ");
INSERT INTO ong_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Leye lo mete nemple pila metine nele le lutepe olpe le le lirpepei kolo wusoli towa oli lunkuwo. Pe pila metine fei lepe, pila pe falowo Jisas. Jisas kapi kainu fei pepe tanio metine lepe, le le nou luntolili le le nou lirpepei. ");
INSERT INTO ong_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mete wurutei pepe pe pinlele le pe yafei pirpeiye, “Metine fei lepei, le ninge palyene lite Devit lom? ");
INSERT INTO ong_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Wolo wem mete pite Farasi pingitepe pirpei polpepe, pe pirpeiye, “Le laptu towa kumpu pepe taniepe mete wusoli le lire singe pite towa nimou.” ");
INSERT INTO ong_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas retape enke pelpe le le lirpepeye, “Mete pite tef, wuso pe kere pusa nemple le pe plolpo, pe ma pile singe kolo olo. Le mete pite uf nele lo pite alpe nele pe kere pusa nemple le pe posinemple, uf lo alpe fei lepe ma pratei kolo ma pa pelengi. ");
INSERT INTO ong_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wuso towa leite lotei, le losi lotei. So towa fei lepe, le ma lile singe fei lolomen? ");
INSERT INTO ong_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Le wuso ki kire singe pite towa nimou kaptu towa kumpu pepe, le mete peise pe pire singe pite mi so pe paptu towa taniepe mete pepe? Mete ilepe peise pite Farasi pe ma kusaise ise yamtuki yawi. ");
INSERT INTO ong_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Olo, Riri Teingi lite Ma Ili le waiki singe piti kaptu towa taniepe mete le ise ma yuluwo retawo wem liti Ma Ili ma luntolise olo faleiseye. ");
INSERT INTO ong_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Winem liti metine singetei le metine nele miso yaruwo winem lele le le linki le kapio oweli men nange pite metine singetei lepe lo ma olo? Ma olo. Le ma linu topuwo metine singetei lepe wo, le soma yaruwo winem lele le le kapio oweli men nange pite metine singetei lepe pele. ");
INSERT INTO ong_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Minemple piti ki peiki kolo, pe ma pire ki mepi mire nemple eringi. Le minemple piti kaneiki mengleipe mete maptei nemple kolo, pe mete piti paptu mete pire fla. ");
INSERT INTO ong_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Min fei polpepei so ki kirpeise, metine minele piti lirpei il olpe, le le kelelawo metine nele, lo le lirpei il olpe liri Ninge lite Metine Wape, le le kelalawo, wolo metine fei lirpei lepe le nou onposi lotei, le le leletei Ma Ili piti ma onposiepe il olpe wuso lirpei pepe kolo, Ma Ili ma onposiepe il olpe pite metine fei lepe kolo, ma olo. Wolo metine minele piti lirpowo il olpe re, kelelawo Riri Teingi lite Ma Ili, le metine fei lepe wuso le onposi lotei piti ma leletei Ma Ili piti ma onposiepe il olpe wuso lirpei pepe kolo, wolo Ma Ili ma lingitowo kolo, Ma Ili wala ma onposiepe il olpe pite metine fei lepe, le le ma watowo metine fei lepe moingi wem oli oli. ");
INSERT INTO ong_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nimpe teingi, le ma lilape fouri teingipe piti maplei, le nimpe oli, le ma lilape fouri olpesa. Wusoli ise miso yulwepe fouri le ise retai nimpe fei lepe le teingi lo oli. ");
INSERT INTO ong_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ise mete piti yire il olpe yirkilautei, enke peise onposiepe il olpe le fei polomen ma il teingipe nou fale nemi peise. ");
INSERT INTO ong_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Metine piti il teingipe pratei onom pele, le ma lirpei il teingipe fale nemi lele, le metine piti il olpe pratei onom pele, metine fei lepe ma lirpei il olpe fale nemi lele. ");
INSERT INTO ong_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ki kirpeise il fei pepei, wem piti Ma Ili ma lingitepe le le kapi il laptei lire moingi piti mete pite tef, mete yeflipi ma pirpei nomnaipe pire il karaitei pelpe wuso pirpei karaitei pepe. ");
INSERT INTO ong_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wusoli il peiye yotei soma Ma Ili kapi il laptei lireiye ye metine teingi lo ye metine oli.” ");
INSERT INTO ong_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Leye lo mete ilepe piti peptalo mete pire il lipi pite Moses le mete pite Farasi, pe pirpowo Jisas pirpeiye, “Ye metine piti eptalo mete, ku muliye piti ye ma irpei le men men ma lotei lire tute fale.” ");
INSERT INTO ong_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Fei Jisas yafeipe lirpeiye, “Ise mete piti fei, ise mete piti yire il olpe le ise tounga pesi Ma Ili. Ise yeiteiki piti ma kirpei le men men ma lotei lire tute fale lom? Olo, men men lotei wuso sungoi falowo metine nimou Jona lepe, soma ise retawo lepe le fei ma olo, ki ma kusaise kire men nele kolo. ");
INSERT INTO ong_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Min watafei metine nimou Jona. Sungoi liye le ratei fango lite ni ili epli twinges niliyeye, le mulpou twinges niliyeye, le fei Ninge lite Metine Wape, le re ma la palingi luwo erau nample lato epli twinges niliyeye le mulpou twinges niliyeye le le ma nou leilo. ");
INSERT INTO ong_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Wem piti Ma Ili ma lingitepe le le kapi il laptei lire moingi pite mete pite tef, mete pite uf Ninive ma pamtuse. Wusoli wem pe pingitepe il wuso metine nimou Jona leptalo pepe pe pulpope le pe pusape il olpe pelpe. Wolo fei metine nele, nange lele ilitei, le Jona olo, metine ili lepei le lau lirpeise, wolo ise yingitowo kolo. Liso mete pite Ninive ma pamtuse pirpei polpepei ‘Ise mete olpe. Wem Jona lau lirpouku ku yeflipiye weitei onom, le ku musape il olpe pouku. Wolo metine ilitei lau lirpeise, le ise yingitowo re yulpowo kolo, olo.’ ");
INSERT INTO ong_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wem piti Ma Ili ma lingitepe le le kapi il laptei lire moingi pite mete pite tef, moto ine ma namtuse. Ne moto ine sungoi ratei, le ne nuntoluwepe mete, ne pite tef minim. Wem fei lepe ne ma namtuse wusoli ne nusa uf lene, le ne naule tisi ulel piti ne ma ningitowo metine ili Solomon. Le Solomon le leptalo il pele piti onom nire wuru. Ne nau ma ningitowo Solomon. Wolo fei metine nele laule faleise, le nange ilitei, le Solomon olo. Le le lau lirpeise lire onom pele nire wurutetei. Le fei ise yingitowo kolo. Moto ine nepe ne ma namtuse nirpei ‘Ise mete olpe, ki kato fiyen kaule piti kingitowo Solomon, wolo ise yinau piti yingitowo metine ili fei wuso lileise malfem, le ise yingitowo kolo.’ ");
INSERT INTO ong_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Wem riri oli naro le tanio metine wape nele riri oli lepe ma le lato linge towa yawi linta tulum piti ratei. Wuso le lerengawo tulum nele piti ratei kolo, ");
INSERT INTO ong_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","le ma lirpei loteiye, ‘Ki ma nou ke winem leiki wuso kusa, le ki kau lepe.’ Liso riri oli lepe, le nou le winem wuso lepe le le luluwo winem fei lepe lato yawi potupuwo re pailolowo. ");
INSERT INTO ong_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Leye lo riri oli lepe le naro le yawi le le lengleipe esi ririm olpe nemple, pe pire esi plen te twinges pe olpe singetei pinuwo riri oli piti linu lepe, le pe ma pau pepi pratei winem fei lepe. Metine fei lepei, linu lepe le wala ausi teingi, wolo fei ririm olpe pepe pe pau punkuwo pe pirowo nele olesatei. Min fei pepe miso falepe mete piti fei wala nampir pratei, le pe pingiepe il olpe.” ");
INSERT INTO ong_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas wala lirpepe mete wem nimou nire winkem pele pau fale. Pe pile towa yawi le pe pepletei mete pepe, pepletei piri Jisas piti ma piri le pepi pirpei. ");
INSERT INTO ong_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Liso metine nele lepe le lirpowo Jisas lolpepei, “Untoli, nimou nire winkem peiye, pe pile towa yawi, le pe ma pire ye yepi yirpei.” ");
INSERT INTO ong_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wolo Jisas namti lirpeiye, “Minenpe ne ema peiki? Minemple pe winkem peiki?” ");
INSERT INTO ong_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Leye lo Jisas eti tunongo lenesipe pupam pele le le lirpeiye, “Yuntoli ema nire winkem peiki min so pepei. ");
INSERT INTO ong_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Minemple piti pingiepe il men pite Eiya leiki liti yuwei le pe pesio towa lele, mete fei pepe pe winkem peiki, pe eri peiki, pe ema peiki.” ");
INSERT INTO ong_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Epli elpesi fei lepe Jisas lusa winem wuso le lifei leptalo mete pepe, Jisas lusa winem fei lepe le le le lifei tuluple mingo. ");
INSERT INTO ong_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mete wurutei pau panfi le so longlo le lifei nimpe teingo nele wuso laitei tuluple linko lepe, le mete wurutei pepe, pe pile re pratei pingene tuluple mingo. ");
INSERT INTO ong_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jisas lire il kauro yuwei, le lirpepe mete wuso pratei pingene tuluple mingo pepe. Le lirpepe lire men nange wuru. Jisas lirpeiye, “Metine nele, le ma le lusasape wit fouri linge liom. ");
INSERT INTO ong_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wem metine fei lepe le lusasape wit fouri pepe, le lusape ilepe linge tisi piti linge liom, le le naflepem fale paplei wit fouri pepe, paplei yalipeye. ");
INSERT INTO ong_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wit fouri ilepe le lusape linge tef era le pe falele frou wusoli tef tale lepe olo kumpu luwo era yuwei yawi. ");
INSERT INTO ong_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wem epli fale lapo wit wuso falele pepe, pe talpelipe yo frou pire punkoye wusoli tef oli lire era le wit nalem olo, pe tef kolo, puwo pinge era yuwei. ");
INSERT INTO ong_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wit fouri ilepe lusape pingepe wolo singu le wit pepe, pe peilo wolo, wolo singu pepe fale pafo. ");
INSERT INTO ong_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Wolo wit fouri ilepe lusape linge tef teingi, le pe peilo pilape fouri, ilepe pilape wurutei (100), ilepe pilape wuru (60) le ilepe pilape wuru taise (30).” ");
INSERT INTO ong_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Le Jisas lirpei il lapulu lolpepei, “Ise ma yingitei wuso ise mingim poli.” ");
INSERT INTO ong_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Leye lo pupam pite Jisas pele pe pau le pe peletei Jisas, “Piti men ye ire il kauro yuwei irpepe mete wem ye irpepe pepe?’” ");
INSERT INTO ong_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisas namti lirpepe pupam pele, Jisas lirpepeye, “Ma Ili waise enke piti ise ma retape il punkom piti wem Ma Ili ma luntoluwepe mete pite tef, le mete nemple, pe olo Ma Ili watepe enke piti pretape il punkom pepe kolo, olo. ");
INSERT INTO ong_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Minele piti retape il yaipiyeye, Ma Ili ma watowo onom nire wuru le metine fei lepe ma retape wurutei. Le minele piti lironomtei, Ma Ili ma kani onom nanio le le ma onposiepe il men kumpu pite Ma Ili kolo, oloye. ");
INSERT INTO ong_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Min fei polpepei so ki kirpepe kire il kauro yuwei yaupe pepe, pe piti lus pato, puntoli wolo pe puluwo matufuwo towa fei ki kesio lepe, pe puluwo matufuwo kolo olo. Le pe minkim pato, pingitei wolo pe pretai kolo, olo pironom. ");
INSERT INTO ong_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Il pite Ma Ili lirpei falowo metine nimou Aisaia, il Ma Ili lirpei liripe mete fei pepe, il fei pepe ma fale punkom. Ma Ili lirpeiye, ‘Pe ma pingitei re pingitei wolo pe ma pretai kolo. Pe ma puntoli re puntoli wolo pe ma pulwepe kolo. ");
INSERT INTO ong_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wusoli mete fei pepei pe enke lipi le pe popopo mingim, le pe lus konti. Wuso olo lutepe pelpe ma pulwepe, mingim pelpe ma pingitei, enke pelpe ma onposiepe pretape le pe ma weisipe enke pelpe papteiki ki le ki ma kapi kainu, flis moingi re men nange taniepe.’ ");
INSERT INTO ong_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Le ise olo, yoporotei, le ise enke teingipe, wusoli ise lutepe peise miso yulwepe le mingim peise miso yingitei. ");
INSERT INTO ong_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ise ma retape fei pepei, sungoi mete emarengi wuru pire mete wuru piti Ma Ili pele, pe onom keretei piti ma pulwepe men fei ise yulwepe pepei, wolo olo pe pinu paye, le pe pulwepe kolo. Le pe ma pingitepe il men ise fei yingitepe pepei, wolo pe olo, pe pinu paye, le pe pingitepe kolo. ");
INSERT INTO ong_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ise yingitei le ise ma retape il pal piti il kauro yuwei wuso kirpei kire metine piti laptetei wit fouri. ");
INSERT INTO ong_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mete wuso pingitepe il pite Ma Ili ma luntoluwepe mete pite tef, pe pingitepe wolo pe pretape kolo, pe ma watafei wit fouri wuso laptei linge tisi. Towa oli laule kapi il pite Ma Ili, kapi taniepe mete pepeye. ");
INSERT INTO ong_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wit fouri wuso laptei tef oli lire era, pe pilepe mete wuso pingitepe il pite Ma Ili pailelepetei le pe kapi frou wem pe pingitepe. ");
INSERT INTO ong_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wolo il pepe posiepe pengleipe enke pelpe kolo, le pe pile singe wem ulel kolo. Liso wem moingi fale wusoli pe pingitepe il pite Ma Ili, pe frou pusape il fei pepeye. ");
INSERT INTO ong_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wit fouri wuso laptei pingepe wolo singu, pe pilepe mete wuso pingitepe il pite Ma Ili, wolo pe onposiepe oweli men nange piti fei, le pe onom puwope mole yini le il pite Ma Ili olo pe pirepe onomye, le pe pesio towa men pite Ma Ili kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Le wit fouri wuso laptei tef teingi, pe pilepe mete wuso pingitepe il pite Ma Ili le pe pretape. Pe pesio towa lite Ma Ili, ilepe pirkilautei pesio towa lite Ma Ili, ilepe pesio towa ili taise lite Ma Ili, le ilepe pesio towa lite Ma Ili wolo kumpu.” ");
INSERT INTO ong_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas nou lire il kauro yuwei lirpepeye, “Ma Ili ma luntoluwepe mete pite tef, le ma luntoluwepe watafei metine le laptei oweli fouri teingipe linge liom lele. ");
INSERT INTO ong_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mulpou nele mete olo petei oloye, le metine nele piti lire yaitei lite liom lepe te rounge tepi tire noute eringi, metine fei lepe le lau lusape wolo tafe pingepe oweli fouri pepe le le leye. ");
INSERT INTO ong_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wem oweli fouri pepe pe falele lipi pila yousi, wolo tafe pepe, pe re falele. ");
INSERT INTO ong_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Fei mete piti pesio towa liti yaitei lite liom lepe, pe pau pirpowoye, ‘Ili louku, ye wuso aptei oweli fouri teingipe pepe le wolo peinei fei polomen so pau pile liom pepe?’ ");
INSERT INTO ong_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Metine piti wepi wire noute eringi, le lapiri wolo pile liom.’ Yaitei lite liom lepe le namti lirpepe mete pele piti pesio towa lele. Le pe nou peleteiye, ‘Ku ma me kotuwepe wolo olpe pepe lo ma olo?’ ");
INSERT INTO ong_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Le namti lirpepeye, ‘Olo wusoli wem ise kotuwepe wolo olpe pepe ise ma rotopa kotowepe oweli ilepe teingipe pepe, ise kotuwepe yapwonou. ");
INSERT INTO ong_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yusape oweli pire wolo olpe pepe, yusape pepi peilo pileye ma wem oweli poungo wo. Wem fei lepe soma ki kirpepe mete piti kotuwepe oweli piti ma pinu kotuwepe wolo olpe tani wo, le pe ma topwepe pire tepu piti ma piripe pe weli. Le yo le ise ma tonwipe oweli kapi yaptei pifei winem leiki liti kaptei oweli pifei.” ");
INSERT INTO ong_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Fei Jisas nou lirpepe pupam pele lire il nemple kauro yuwei, Jisas lirpepe lolpepei, “Ma Ili ma luntoluwepe mete pite tef, le ma luntoluwepe fale watafei nimpe fouri wuso metine nele le kali lari liom lele. ");
INSERT INTO ong_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nimpe fouri kumputei wolo wem le leilo le ili, le ma fale lire nimpe ilitei le naflepem ma paule paptei onkotu pelpe pultei ine piti nimpe fei lepe.” ");
INSERT INTO ong_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas nou lirpepe il nemple kauro yuwei. Jisas lirpeiye, “Wem teingi liti Ma Ili ma luntoluwepe mete pite tef, le ma luntoluwepe fale watafei yis. Moto nenpe ne kali yis lepe nire weisi luom ili, nire weisi ne ne yo luom lepe namti linpei le ilitei.” ");
INSERT INTO ong_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas lire il kauro yuwei yaupe lirpepe mete wurutei pepe, lirpepe lire men nange wuru. Il men piti lirpepe le ma lirpepe yaupe kolo, le ma lire il kauro yuwei soma lirpepe. ");
INSERT INTO ong_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jisas lirpei lirerim piti ma laptei il wuso metine nimou lirpei pepe, pe ma fale punkom. Metine nimou lirpeiye, “Wem ki kirpepe ki ma kire il kauro yuwei yaupe kirpepe. Ki ma kirpepe kire il men pe wala pretape kolo, il pite wem Ma Ili laltei tef le pe pau pau fale fei.” ");
INSERT INTO ong_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Leye lo Jisas lusape mete wurutei pepe le le le winem. Pupam pele pe falowo le pe pirpeiye, “Ye irpouku il pal pite il wuso irpei kauro yuwei ire wolo olpe wuso fale pile liom pepe.” ");
INSERT INTO ong_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisas namti lirpepeye, “Metine piti lusape oweli fouri teingipe pepe, le Ninge lite Metine Wape, ");
INSERT INTO ong_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","liom lepe le lilowo tef fei lepei, oweli fouri teingipe pepe pe pilepe mete piti Ma Ili pele ma luntoluwepe pratei uf teingi lele, wolo olpe pepe pe pilepe eple pite towa oli. ");
INSERT INTO ong_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Le metine oli piti lapiri wolo olpe pepe, le towa. Wem piti kotuwepe oweli pepe, le lilowo wem piti Ma Ili ma lingitepe le le kapi laptei lire moingi pite mete pite tef. Le mete piti kotuwepe oweli, pe pilepe ririm pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Min watafei wolo olpe pe tonwipe paptei nemple le pe piripe pe weli laplei, pe ma watafei wem piti Ma Ili lingitepe le le kapi laptei lire moingi pite mete pite tef. ");
INSERT INTO ong_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ninge lite Metine Wape, le ma laisipe ririm pite Ma Ili pele pe, le pe ma pengleipe paptei nemple mete piti paptei mete nemple pualo tisi oli, le mete piti pire il olpe pepe, ririm pite Ma Ili pele, pe ma kesipe mete fei pepe paptei pe tani uf lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Le pe ma piripe mete olpe pepe, piripe pinki weli ili, le pe ma poutiti re paplelei nilpe pelpe. ");
INSERT INTO ong_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Leye lo mete pite Ma Ili pele, pe ma pratei uf teingi lele le pe ma fale teingipetei pinini watafei epli linini lepe. Ise ma yingitei wuso ise mingim paitei.” ");
INSERT INTO ong_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ma Ili ma luntoluwepe mete pite tef, le il pele piti watepe pe teingipe ma watafei mole wurutei pe paplingi pratei tef. Metine nele lerengape le so nou laisi tef mulfipe. Metine fei lepe le onom teinginetei le le le laptei oweli men nange pele pe le mete nemple paisipe. Le kapi mole wuso le kapi piti oweli pele pepe le le nou le yaitei lite tef wuso mole wurutei kotire pratei lepe le le laisi tef fei lepe.” ");
INSERT INTO ong_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jisas nou lirpei il nemple kauro yuwei. Le lirpeiye, “Ma Ili ma luntoluwepe mete pite tef, le il pele piti watepe, pe teingipe watafei fouye malpim teingipetei metine lintape, le lintape piti ma laisipe. ");
INSERT INTO ong_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wem metine fei lepe le le lerengawo fouye malpim nele, le watafei malpim nemple wuso pele lulwepe retape pepe kolo, fouye malpim fei le lerengawo lepei le kuna nele yeflitei. Metine lepe ma le laptei oweli pele wuruye le mete paisipe, le le kapi mole pite oweli pele pepe le liripe laisi fouye malpim yeflitei wuso luluwo lepe.” ");
INSERT INTO ong_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Il nemple nou kauro yuwei yaupe pe polpepei, “Ma Ili ma luntoluwepe mete pite tef watafei mete piri taimere pe tuluple le pe ma pengleipe ningu eryai pepe. ");
INSERT INTO ong_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wem ningu pautile taimere lepe pe fale, mete piti pesio towa liti pengleipe ningu, pe peipi taimere lire ningu pepe, peipi pila pe mingo le pe pungura pratei piti ma karipe ningu. Pe karipe ningu paptei teingipe pepe pe pafo pe ufal pelpe le olpesa pepe pe piripe tani. ");
INSERT INTO ong_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Le ma watafei wem piti Ma Ili ma lingitepe le le kapi laptei lire moingi pite mete pite tef. Ma Ili ma laisipe ririm pele pe le pe ma pengleipe paptei nemple mete piti pire il olpe. Pengleipe taniepe mete piti pingiepe il pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Le ririm pite Ma Ili, pe ma piripe mete piti pire il olpe, pe ma piripe pe weli ili le pe ma poutiti re paplelei nilpe pelpe.” ");
INSERT INTO ong_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisas lepletei pupam peleye, “Ise retape il fei pepe lo olo?” “Iyo” pe namti pirpowo. ");
INSERT INTO ong_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Liso Jisas namti lirpeiye, “Il pal piti il fei pepe, pe pato polpepei. Mete wuru wuso peptalo mete nemple pire il lipi pite Moses, le pe fale pupam peiki, le pe kanio Ma Ili peptalo mete pite tef, pe ma watafei numu nele leise, ise ye fale yuluwo, le le ma lafoise siye punkelem piti nempis laptei pifei, le le ma lafoise siye piti wala fei lepei losiepe, le ma lafoise lapwonou.” ");
INSERT INTO ong_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wem Jisas lirpei il kauro yuwei pepe le lirpei le lapulu, le lusa winem fei lepe, ");
INSERT INTO ong_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","le le nou le uf lele, Nasaret. Le leptalo mete lifei angli pau lelpe le mete wuso pingitowo pepe pe pinlele potei le pe peite nempleiye, “Le lolomen so le onom nire wuru, le kapi il fei pepei pato fei linei? Le men nange wuso potei pire tute fale wem le lirpei pepe, pepe ma polomen? ");
INSERT INTO ong_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Metine piti leilape winangou lepe, le ninge lele so lepei lepe lom? Maria, ne nimou pele lom? Le Jems, Josep, Saimon re Judas, pe winkem pele lo olo? ");
INSERT INTO ong_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Eri pele yeflipi pepe, pe pratei lepei lo olo? Le kapi il fei pepe pato fei linei?” ");
INSERT INTO ong_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Le pe pinauli. Jisas lirpepeye, “Mete pite uf walem nemple pe ma paptowo minkim pire il pite metine nimou lepe, le uf lite metine nimou lele lotei, mete pele pepe pe ma olo paptowo minkim kolo.” ");
INSERT INTO ong_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jisas lirpei le men nange potei pire tute fale uf Nasaret wolo pe olo wuru kolo, wusoli mete pite uf fei lepe pe olo pulpope il pite Jisas kolo, olo. ");
INSERT INTO ong_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Wem fei lepe Herot Antipas, le metine ili piti luntoluwepe mete piti Galili re Perea, le lingitepe il mete pirpei pire Jisas. ");
INSERT INTO ong_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Fei Herot lirpepe mete pele piti kanio pesio towa lele piti puntoluwepe mete, Herot lirpepeye, “Metine fei lepei kuna Jon liti kaptetei mete wuso la lepe le le nou leilo. Min fei polpepei so le kapi singe piti lirpei le men men potei pire tute fale pepe.” ");
INSERT INTO ong_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tisi liti wem Jon la lolpepei, Herot lotei lirpepe mete pele le pe penglei Jon le pe topupuwo paltei lifei winem oli wusoli Jon lirpopowo Herot piti ma laisine Herodias pato. Herodias, ne moto piti Herot winke lele Filip, le Filip wala namin ratei. ");
INSERT INTO ong_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jon liti kaptetei wem oli oli lirpopowo Herot lolpepei, “Herot, ye ma aisine moto pite winke leiye pato, fei pepe olo pato tuwopou kolo.” ");
INSERT INTO ong_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod onom natowo Jon piti ma letesi la wolo le turuwo lire mete pite uf walem pite Herot pele wusoli pe onposi pirpolo le metine nimou liti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Wem nele, wem Herot ma onposio wem liti nimou nila, mete wuru pau pire Herot pepi pifei le Herodias ningio pene ne nuro nilepe onom pelpe. Herot onom teinginetei lirine, ");
INSERT INTO ong_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","le topwepe il lapiri lirine ne piti le ma watene menele eryai wuso ne ma neletei niri. ");
INSERT INTO ong_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Fei nimou Herodias frou nirpene ningio pene piti ne ma neletei Herot nolpepei, “Fei lepei ye ma alowi falo lite Jon liti kaptetei le ye ma altei falo lele luwo waifile le ye waiki.” ");
INSERT INTO ong_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Fei metine ili Herot, le onom one wolo le onposiepe il wuso linu topwepe lapiri lire Herodias ningio pene le mete wuru wuso pepi pifei pepe re pe pingitowo fei, liso Herot lirpepe mete pele piti ma pe palowio Jon falo lele, le pe ma paltei luwo waifile pila pau watene ningio pite Herodias. ");
INSERT INTO ong_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Le mete pite Herot pele, pe pe fale winem oli le pe palowio Jon falo. ");
INSERT INTO ong_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pe paltei falo lite Jon luwo waifile le pe watene kumpu fei nepe le ne kali nila ne nimou pene Herodias. ");
INSERT INTO ong_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pupam pite Jon pele, pe pe kali pila pe paltei re fei pe so pila il pe pirpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wem Jisas lingitepe il wuso Jon pupam pele, pe pirpowo pire Jon wuso mete pite Herot pe palowio falo le le la lepe, Jisas lusa tulum fei lepe le le lire pupam pele poteteiye ponglo nimpe teingo le pe pe towa nele yawi, mete pratei kolo. Mete pingitei polpepei, pe pusape uf pelpe le pe pulsi pingene tef tangu pe. ");
INSERT INTO ong_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wem Jisas lusa nimpe teingo le le kotu lualo le, le lulwepe mete wuso wurutei pepe, le onom manepe le le kapi kainu pelpe taniepe. ");
INSERT INTO ong_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ningli lepe pupam pele, pe pe falowo le pe pirpowoye, “Tulum fei lepei olo yawi, le mulpou olo lau lire malfemye. Aisipe mete fei pepei pe uf walem eryai pepe le pe ma paisipe oweli nemple pelpe.” ");
INSERT INTO ong_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wolo Jisas namti lirpepe pupam peleye, “Pe ma pe kolo. Ise ma watepe oweli men piti pe ma paplei.” ");
INSERT INTO ong_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pe namti pirpowoye, “Ku oweli olo wimye, lufe wengli pire eti plen poungo le ningu twinges.” ");
INSERT INTO ong_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Yilape yau waiki.” Jisas lirpei lepe. ");
INSERT INTO ong_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Fei Jisas lirpepe mete wuru pepe piti ma pratei pinge wolo pepe. Leye lo le kapi lufe wengli pire eti plen poungo pepe le ningu twinges, le luntoli le teplai yuwei le le leletei Ma Ili liripe oweli fei pepe. Jisas yaruwepe lufe watepe pupam pele le pe pilape pe watetepe mete wuso pratei pingene wolo pepe. ");
INSERT INTO ong_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pe yeflipiye paplei oweli fei pepe le pe yefi tangupu. Leye lo Jisas pupam pele pe tonwipe oweli ilepe pepe, pe pafo porangou pire esi plen le plen te twinges, pora pire oweli pepe fale poparuye. ");
INSERT INTO ong_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Oweli olo kumpu wimye wolo mete wurutei (5,000) pe paplei oweli fei pepe le pe yefi tangupu. Nimoure re eple kumpu pe pepi paplei wolo olo, pe koponape papwonou kolo. ");
INSERT INTO ong_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Leye lo Jisas laisipe pupam pele ponglo nimpe teingo le pe pinuwo pe tuluple mingo plen le Jisas lotei wala laptetei mete wuso paule pingitowo, le laptetei pe uf pelpe. ");
INSERT INTO ong_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jisas laptei mete pe tani re fei le loteteiye lunwei le tef nele alo linpei lifei le le leletei Ma Ili. Wem munkunum lirkilau Jisas wala loteteiye ratei leletei Ma Ili, ");
INSERT INTO ong_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","le nimpe teingo wuso lilape pupam pite Jisas pele pepe, pe olo pe fale tuluple nimin fiyinye le tipe weisesipe re, leilalape lusasape wusoli yuf lini lile onom lau. ");
INSERT INTO ong_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nolowi nau piti ma ifili Jisas lilele linge tipe yuwei le falepe pupam pele wuso pifei nimpe teingo pepe. ");
INSERT INTO ong_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wem pupam pele, pe puluwo Jisas wuso lilele linge tipe yuwei le lepe, pe turwepe olpe. Pe punwewipe le pe pailolo pirpeiye, “Kuna towa, towa.” ");
INSERT INTO ong_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Wolo Jisas frou lirpepeye, “Singe, kuna ki Jisas. Ise turise pato.” Le lirpepe pepe. ");
INSERT INTO ong_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Leye lo Pita lirpowo Jisas lolpepei, “Ili leiki, wuso ye Jisas yoteiye, ye irpei le ki re ma kolili kingi tipe yuwei kareiye ke.” ");
INSERT INTO ong_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Au,” Jisas namti lirpowo Pita. Liso Pita lusa nimpe teingo le le kotu lualo lolili linge tipe yuwei karowo Jisas le. ");
INSERT INTO ong_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wem Pita luluwo yuf, le turuwo liso le luwalolo lautile wisyau wisyau leingalo tipe. Le lailo lirpeiye, “Ili leiki, kaneiki.” ");
INSERT INTO ong_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jisas frou kesi eti lele laltei le lesio Pita le le lirpeiye, “Ye ulpope il peiki irkilau kolo. Piti men ye onposi irpolo ki ma kaneiye kolo lepe?” ");
INSERT INTO ong_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Fei te roungesye tonglo nimpe teingo lepe le yuf kere. ");
INSERT INTO ong_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pupam yeflipi wuso pifei nimpe teingo pepe, pe rautuwo Jisas. Pe yafei pirpeiye, “Punkomtei, ye ninge lite Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pe puwowo tipe pe fale tuluple mingo plen, pe fale uf Genesaret. ");
INSERT INTO ong_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mete pite uf fei lepe pe puluwo matufuwo Jisas. Pe so paptei il pe pirpepe mete pingene tef lite Genesaret piti ma pilape mete wuso kainu pepe, pe ma pilape pau puluwo Jisas. ");
INSERT INTO ong_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mete fei pepe pe peletei Jisas piti ma lusape mete wuso kainu pepe Jisas ma lusape pesio um lite olol lele le pe kainu pepe, minemple pelpe wuso pesio olol um lite Jisas le pe nou fale teingipeye. ");
INSERT INTO ong_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Leye lo mete ilepe pite Farasi le mete piti peptalo mete pire il lipi pite Moses, pe pato Jerusalem so paule le pe peletei Jisas polpepei, ");
INSERT INTO ong_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Piti men so ye pupam peiye pepe pe yaruwepe il lipi wuso manre piti sungoi, pe paptouku pato piti ku fei fei re ma mingiepe pepe? Pe ma pinu kaptetei esi pelpe wo pe soma paplei oweli wolo pe olo pingiepe fei pepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas namti lirpepeye, “Le piti men ise yaruwepe il pite Ma Ili le ise yingiepe il wuso manre peise peitaloise pepe? ");
INSERT INTO ong_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wusoli Ma Ili le lirpei lolpepei, ‘Ye ma kanieme re rautuweme yaitei lire nimou meiye, le minele piti lirpei il olpe lirime yaitei lo nimou pele, pe ma petesi metine fei lepe la.’ ");
INSERT INTO ong_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wolo ise yeptalo mete yolpepei, ‘Wuso metine nele le kanio yaitei lo nimou pele, le ma kanieme lire oweli men nange pele, le wuso metine fei lepe le lirpeiye, ‘Oweli men wuso ki waise roum meme olo ki kaptei piti ma watowo Ma Ili le ki min so waise roum pepe? Ma olo.’ ");
INSERT INTO ong_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Le onom puwo piti ma kanieme re rautuweme nimou re yaitei mele kolo, me roum ma ratei olme. Min fei polpepei so ise yusape il pite Ma Ili le ise yingiepe il wuso manre peise peitaloise pepe. ");
INSERT INTO ong_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ise mete piti nel loli ilo ilo. Il wuso Ma Ili lirpei fale nemi lite metine nimou Aisaia, le lirpei lireise pepe olo punkomye. ");
INSERT INTO ong_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ma Ili lirpeiye, mete fei pepei pe pirpolo pe pingiepe il peiki, Wolo enke pelpe olo pato fiyen. ");
INSERT INTO ong_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pe pirpolo pe rautuki wolo ki kulpope kolo wusoli pe peitalo potei pire il pite mete pite tef. Pe pingiepe il pelpe potei le pe pirpolo il pite Ma Ili so pepe wolo olo, pepe na il pelpe potei’.” ");
INSERT INTO ong_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Leye lo Jisas linape mete wuru pepe linape paule le le lirpepeye, “Yingitei le ise retape. ");
INSERT INTO ong_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Oweli re tipe wuso metine wape laplei le pe pautile pe pratei fango lele, pe ma pirowo metine wape lepe, pirowo oli kolo olo, wolo il men olpe wuso pratei onom pele le le lirpei, pepe soma pirowo metine wape fei lepe oli lepe ko.” ");
INSERT INTO ong_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Leye lo Jisas pupam pele, pe pau pirpowoye, “Ye retai lo olo? Mete pite Farasi pe enke olpe pire il wuso irpei pepe.” ");
INSERT INTO ong_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Le Jisas namti lirpepe pupam peleye, “Nimpe yeflipi wuso Eiya leiki liti yuwei, le lapiri kolo pepe le ma kotuwepe tani.” ");
INSERT INTO ong_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ise onposiepe pato, pe piti ma kusape mete nemple pire tisi wolo pe lutepe olpe. Le wuso metine nele le lutepe olpe le le linunuwo nele, le re lutepe olpe, te roungesye ma tualo tautile oi.” ");
INSERT INTO ong_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Fei Pita lirpowo Jisas lolpepei, “Ye irpouku ire il pal piti il kauro yuwei wuso irpei pepe.” ");
INSERT INTO ong_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisas lirpepeye, “Ise wala enke lipi watafei mete nemple pepe. ");
INSERT INTO ong_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ise retai lo olo? Oweli re tipe men nange piti yaplei nemi, pe pautile pe pratei fango ma fei ise yopyoyope re namtiri naro pe yaupe peye. ");
INSERT INTO ong_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wolo il pite yirpei fale nemi peise, pe fale onom peise le il fei pepe soma pirowo metine wape oli lepe ko. ");
INSERT INTO ong_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Wusoli il olpe pe paitei onom peiye, ye inu onposiepe soma ye ingiepe piti etesi alwe metine nele la, auleline moto pite metine nele, ire ausi irpepe nimoure, ire ausi kapi oweli pite metine nele, empesipe mete le ye amtuwepe yaupe. ");
INSERT INTO ong_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Il olpe fei pepei soma pirowo metine wape oli lepe ko. Wolo mete pite Farasi pe pirpolo pe ma pinu kaptetei esi wo pe soma paplei, wuso ise yaruwepe il pepei pite Farasi ise ma yaruwepe il pite Ma Ili kolo.” ");
INSERT INTO ong_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas lusa tef lite Genesaret lato le le tef lite uf lingi Tair re Saidon, te uf lingi tepe tite mete nemple. ");
INSERT INTO ong_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Moto nenpe olo pite Israel kolo, ne pite mete nemple pinape Kainan, ne nratei nele fei lepe, ne nau falowo Jisas le ne nouti nirpowoye, “Ili leiki, ye ninge lite Devit, ye onom maneiki. Ningio peiki olo towa punkuwene pirkilautei.” ");
INSERT INTO ong_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Wolo Jisas lingitene yauneye, il men re lirpene kolo. Liso pupam pele pau pirpowoye, “Aisene ne tani, ne nultotouku le ne kete ipli naltouku.” ");
INSERT INTO ong_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Leye lo Jisas namti lirpeiye, “Ma Ili laiteiki piti ma karepe eple palyepe pite Israel wuso kotire watafei sipsip pepe, ki so karepe kau.” ");
INSERT INTO ong_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Moto pite Kanan nepe ne ningitowo Jisas lirpei lolpepe, ne nusape il pele naule nualo ratei ire pele le ne nirpowoye, “Ili leiki, ye kaneiki.” ");
INSERT INTO ong_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisas lirpeiye, “Pe olo tuwopou kolo piti ma kapi oweli pite eple kumpu pelpe le ku miripe maptepe pelem paplei.” ");
INSERT INTO ong_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ne namti nirpeiye, “Ili leiki, il fei pepe punkom. Wolo pelem re pe paplei oweli flengi piti puwalolo wem yaitei lelpe lifei ponu laplei le oweli flengi puwalolo pepe.” ");
INSERT INTO ong_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Liso Jisas namti lirpeneye, “Ye moto piti ulpope il pite Ma Ili irkilautei. Ye onom natoiki piti ma kaneiye, le ningio peiye ma nou fale teingine.” Le wem fei lepeye ningio pene wuso towa punkuwene nepe olo towa naro pe taniene le ne nou fale teingineye. ");
INSERT INTO ong_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas lusa tulum fei lepe le le lilele le linge mingo lite tuluple Galili. Le le lunwei tef nele lupai linpei lifei, le le lifei yuwei. ");
INSERT INTO ong_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mete wurutei pau falowo. Pe pilape ilepe pelpe wuso ire pa, lutepe olpe, ire esi poungo, mete piti pirpepei kolo pepe le mete piti kainu polomen polomen re, pe pilape mete fei pepe pe paptowo pratei Jisas malfem. Le Jisas kapi kainu pelpe taniepe le pe nou fale teingipe. ");
INSERT INTO ong_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mete fei pepe pe pinlele potei wem pe pulwepe mete wuso pinu pirpepei kolo pepe wolo pe nou pirpepei, mete ire esi pelpe wuso poungo wolo pe nou singe le pe pilele pe le mete wuso lutepe olpe wolo pe nou puntolili, mete fei pepe pe peila nange lite Ma Ili lite Israel. ");
INSERT INTO ong_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas linape pupam pele pau pirowo malfem le le lirpeiye, “Ki onom manepe mete fei pepei wusoli pe pireiki mratei epli twinges le niliyeye le fei pe oweli piti paplei olo. Ki ma kaisipe pire nimpi pe kolo wusoli pe ma lus peinei le pe pualo tisi.” ");
INSERT INTO ong_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Pupam pele peleteiye, “Tef oli era re telmaneye yawi fei lepei le ku ma kapi oweli wuru pratei fei linei soma ku watepe mete wurutei fei pepei pepe?” ");
INSERT INTO ong_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Ise lufe wengli polomen?” Jisas lepletei pupam pele. “Ku lufe wengli pire eti plen te twinges, le ningu kumpu yaipiyeye,” pupam pele namti pirpowo. ");
INSERT INTO ong_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Liso Jisas lirpepe mete wurutei pepe piti ma pungura pratei pinge tef. ");
INSERT INTO ong_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Leye lo Jisas kapi lufe wengli pire eti plen te twinges le ningu le le leletei Ma Ili liripe, le le yaruwepe watepe pupam pele le pe watetepe mete. ");
INSERT INTO ong_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mete wurutei pepe paplei le pe yefi tangupuye. Pupam pite Jisas, pe tonwipe oweli ilepe pepe pafo porangou pire eti plen te twinges fale. ");
INSERT INTO ong_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mete wurutei (4,000) pe paplei oweli fei pepe le nimoure re eple kumpu, pe pepi paplei wolo koponape papwonou kolo. ");
INSERT INTO ong_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisas laisipe mete pepe pe tani re fei le longlo nimpe teingo, le le le tef lite Magadan. ");
INSERT INTO ong_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mete ilepe pite Farasi le pite Sadyusi pe pau falowo Jisas. Pe pemtetei peletei pirpolo le ma lirpei le men men ma potei pire tute fale, le pe ma puluwepe, le lire singe pite Ma Ili lo olo. ");
INSERT INTO ong_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Wolo Jisas namti lirpepeye, “Wem epli le piti ma lautile le ise yuluwo teplai lire yalei ise yirpeiye, ‘Teplai olo lire yalei, nolowi ma epli teingi.’ ");
INSERT INTO ong_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Le nolowi ire mul ye uluwo teplai lire yalei le aroro lire lalolowi, ye irpeiye, ‘Fei ma nef wusoli teplai olo lire yalei le aroro lire lalolowi.’ Ise yuluwo teplai le ise miso retai wem fei lepe le ma epli lo ma nef. Fei ise yulwepe men nange wuso potei pire tute fale pepe, wolo ise men faleise kolo olo. Ise yire moingi piti kapi yaptei. ");
INSERT INTO ong_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ise mete piti fei, ise mete piti yire il olpe le ise tounga pesi Ma Ili. Ise yeiteiki piti ma kirpei le men men ma lotei lire tute fale le ise ma yuluwo lom? Ma olo. Men wuso falowo Jona lepe, soma ile men watafei lepe ma nou faleiki, le ki ma kusaise kire men nele kolo. Liso Jisas lusape le le le taniepe. ");
INSERT INTO ong_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wem Jisas liripe pupam pele pe fale tuluple mingo plen, pupam pele onom pete il pire lufe piti pilape pe ma paplei. ");
INSERT INTO ong_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Le Jisas lirpepeye, “Ise ma kotopa isotei yire yis piti mete pite Farasi re Sadyusi.” ");
INSERT INTO ong_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Fei pupam pele kapi il paptei pirpei nempleiye, “Le lirpei il fei pepei wusoli ku olo milape oweli men maule kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas retai il men wuso pupam pele pirpepei pepe liso lepleteiye, “Piti men ise kapi il yaptei yirpei nemple yire oweli olo pepe? Ise yulpope il pite Ma Ili yirkilau kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ise wala retai kolo olo lom? Ise onposi wem ki kapi lufe pire eti plen le ki karipe watepe mete wurutei (5,000) pepe le ise tonwipe oweli ilepe yafo porangou polomen? ");
INSERT INTO ong_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Le lufe pire eti plen pongo te twinges wuso ki karipe watepe mete wurutei (4,000) pepe. Ise yafo oweli ilepe pire porangou polomen? ");
INSERT INTO ong_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Piti yolomen ise wala yironom yire il pepe? Ki olo kirpeise kire luomtei lepe kolo olo. Le ise ma kotopa isotei yire yis pite mete pite Farasi re Sadyusi.” ");
INSERT INTO ong_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Leye lo pupam pite Jisas, pe pretai Jisas lirpei lire yis liti pire weisi luom kolo, wolo le lirpei piti pe ma kotopa potei pire il wuso mete pite Farasi re Sadyusi pelpe peptalo. ");
INSERT INTO ong_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas le tef malfem lire uf Sisaria lato tef ili pinawo Filipai le le lepletei pupam peleye, “Ise yingitepe mete pirpei piri Ninge lite Metine Wape, le minele?” ");
INSERT INTO ong_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pupam pele namti pirpowoye, “Mete ilepe pirpei pirpolo le Jon liti kaptetei, mete nemple pirpei polo le Ilaija le ilepe pirpei polo le Jerimaia lo mete emarengi eryai pepe.” ");
INSERT INTO ong_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Le ise?” Jisas lepletei pupam peleye. “Ise yirpei yolo ki minele?” ");
INSERT INTO ong_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita namti lirpeiye, “Ye Krais, Ma Ili leiteiye au piti ma untoluwepe eple palye pite Israel. Ye ninge lite Ma Ili piti ratei lingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisas namti lirpowo Saimon Pita lolpepei, “Saimon, ninge lite Jona. Ye ma onom teingine wusoli metine minele liti tef fei lepei le lirpeiye il fei pepe kolo, wolo Eiya leiki, le Ma Ili liti yuwei, le lirpeiye il fei pepe. ");
INSERT INTO ong_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Le fei polpepei so ki kinaiye ye Pita, Il pal piti nange Pita, mete pite Juda pe pinawo erau le mete wuso pulpope il peiki pe ma pile erau fei lepei le pe ma pile singe. Singe pite towa miso weisipe kolo le pe re miso pa pelengi kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ki waiye singe piti keiniepe mete aptowo, mete wuso ye keiniepe piti Ma Ili ma luntoluwepe Ma Ili ma luntoluwepe. Le il wuso ye aptei piti mete ma pingiepe il pepei, Ma Ili re ma laptei pile singe. Le il wuso ye irpepe kolo Ma Ili re ma kapi il laptei liripe kolo. ");
INSERT INTO ong_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Leye lo Jisas il poluwepe pupam pele piti ma pirpepe mete nemple pirpolo le Krais, olo, ma pirpepe kolo. ");
INSERT INTO ong_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Wem fei lepe le le le Jisas lirpei lamtetepe pupam pele lirpeiye, “Ki ma ke Jerusalem le mete lipi pire mete piti pinuwepe mete piti peptawio Ma Ili siye le mete piti peptalo mete pire il lipi pite Moses, mete fei pepe pe ma waiki moingi ilitei. Pe ma peteteiki ka le epli twinges le niliye kareiki fei Ma Ili ma nauyou leilaiki.” ");
INSERT INTO ong_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Fei Pita kesi Jisas lila le taniepe pupam wuru pepe le le lire il singe lirpowo Jisas lolpepei, “Apa, Ma Ili lirpei lolpepei kolo. Moingi fei lepe ma faleiye kolo.” ");
INSERT INTO ong_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisas weitei lirpowo Pita lolpepei, “Ye metine eringi leiki, ye irpei il pite towa. Ye opopo tisi leiki, wusoli ye onposiepe il pite mete pite tef le il pite Ma Ili olo, ye onposiepe kolo. Le ki ma kingitepe il peiye kolo.” ");
INSERT INTO ong_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Leye lo Jisas lirpepe pupam peleye, “Wuso metine minele le lirpolo le ma lulteiki ki, le ma onposi lotei kolo olo, le le ma lila moingi wem le lulteiki ki. ");
INSERT INTO ong_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wusoli metine minele piti kotopawo nempi lele, le le linaulo piti la lire il peiki, metine fei lepe le ma lalingou nempi lele. Le metine minele piti lulteiki ki le le lalingou nempi lele, le le la lire il peiki, metine fei lepe le ma nou lerengawo nempi lele. ");
INSERT INTO ong_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Metine minele miso litipiepe oweli men nange piti tef fei lepei le le lirowo nele nempi lele le le ma nou kali menele teingi lo ma olo? Ma olo. Menele lato fei linei ma metine miso laltei watowo Ma Ili le le nou kali nempi lele, olotei. ");
INSERT INTO ong_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wusoli wem lire malfemye wem Ninge lite Metine Wape, le ma lau lire singe pite Yaitei lele liti yuwei, le Ma Ili, le liripe ririm pite Ma Ili, pe ma paule le Ninge lite Metine Wape le ma lailelepe mete lire towa pe pesio. ");
INSERT INTO ong_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ise ma onposiepe il fei pepei, mete ilepe piti fei pile lepei, pe wala ma pa kolo, wala pratei le pe ma puluwo Ninge lite Metine Wape le ma lesio towa lele piti luntoluwepe mete.” ");
INSERT INTO ong_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Epli lire eti plen le niliyeye fei Jisas kesi Pita lire Jems re winke Jon, Jisas kesipe pe poteteiye pe le le linuwepe punwei tumun nele yuweitei. ");
INSERT INTO ong_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wem Pita lire Jems re winke Jon, pe puluwo Jisas le fale nele. Pe puluwo mati lele lini watafei epli, le olongou pele fale fiyutei watafei epli if. ");
INSERT INTO ong_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Le frou yo fei pe pulwenge Moses lire Ilaija te fale tile tire Jisas pepi pirpei. ");
INSERT INTO ong_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Liso Pita lirpowo Jisas lolpepei, “Apa, teingipe ku fei mau lepei, le wuso ye irpei ki ma kaptu winangou twinges le niliyeye, kaptu pratei lepei, nele leiye nele lite Moses le nele lite Ilaija.” ");
INSERT INTO ong_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wem Pita wala lirpepei, nopom lini luwowo lire Jems re winke Jon le il nemple pirpei fale nopom lepe pirpeiye, “Ninge fei lepei ki leiki le ki onom nuwoltei kiri. Ki onom teinginetei kasio. Ise ma yaptowo mingim.” ");
INSERT INTO ong_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wem pupam pingitepe il fei pepe pe turwepe re punwewipe olpetei le pe puwalo pratei paptei mi re mati poli tef. ");
INSERT INTO ong_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisas lau falepe le le lesiepe lirpepeye, “Yeifale yile, ise turise pato.” ");
INSERT INTO ong_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pe so peila lus puntoli wolo pe puluwo Jisas loteteiye lile. ");
INSERT INTO ong_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wem pe wala pitipi tumun lepe pe, Jisas lirpepe Pita lire Jems re winke Jon, Jisas lirpepe lamtetepe lolpepei, “Men men fei ise yulwepe pepei, ise ma yirpepe mete nemple pato ma yungari wem Ninge lite Metine Wape la le Ma Ili ma nauyou leila wo, leilo wo, ise soma yirpepe.” ");
INSERT INTO ong_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Leye lo pupam pepe pe namti peletei Jisas polpepei, “Piti polomen so mete piti peptalo mete pire il lipi pite Moses, pe pirpei polo ‘Ilaija ma linu lau lepe’?” ");
INSERT INTO ong_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisas namti lirpepeye, “Pepe punkom, Ilaija linu lau fei le le lirpepe mete piti pe ma nou onposio Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Le ki kirpeise, Ilaija linu lau fei wolo mete puluwo matufuwo towa lele piti lesio kolo olo. Pe rotope il olpe piti ma pingiepe le pe namplio uru. Min fei polpepe, Ninge lite Metine Wape re pe ma watowo moingi ili.” ");
INSERT INTO ong_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Leye lo pupam pele pe pretai polpepei Jisas lirpepe lire Jon liti kaptetei. ");
INSERT INTO ong_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wem Jisas lire Pita le Jems re winke Jon, pe nou pe falepe mete wurutei pepe, metine nele le lau falowo Jisas le le yaru yamkelem ratei linuwo, ");
INSERT INTO ong_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","le le lirpeiye, “Ili leiki, ye onom manowo ninge leiki. Le towa wumun lunkuwo lirkilautei le kumpu lepe ma loli nele le tuwamou ma fale mi nemi lele, le le ma wem oli oli re weisesi kumpu lepe leltawi weli lo liri luwalo tipe. ");
INSERT INTO ong_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ki kila kumpu lepe kau falepe pupam peiye wolo pe kapi kainu pele tanio kolo.” ");
INSERT INTO ong_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisas namti lirpeiye, “Ise mete fei pepei, piti yolomen ise yulpope il pite Ma Ili kolo, le ise wala onposiepe il tuwopou piti yirpei kolo olo? Wem fei polomen ma ki kireise ratei? Wem fei polomen ma ki onom maneise? Yila kumpu lepe yau yalteiki lepei.” ");
INSERT INTO ong_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisas lire il singe lirpei laltu towa wumun lepe le le naro le tanio kumpu lepe. Liso kumpu lepe le nou fale teingi wem fei lepeye. ");
INSERT INTO ong_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Leye lo pupam pite Jisas pe poteteiye pau le pe peletei Jisas polpepei, “Piti polomen so ku maltu towa wumun naro le tanio kumpu fei lepe kolo olo lepe?” ");
INSERT INTO ong_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Ise yolpepe kolo wusoli il pite Ma Ili ise yulpope kumputei.” Jisas namti lirpepe pupam pele. “Ise ma retai yolpepei, wuso ise yulpope il kumputei watafei yumko tingeni, ise ma yirpowo tumun fei lepei yirpolo, ‘Tintiri yotei e ifei liye.’ le tumun lepe ma tintiri le. Wuso ise yulpope il pite Ma Ili towa men ise ma yesio ise ma yesio yire wanketei kolo. ");
INSERT INTO ong_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Wolo ise ma yaplei oweli kolo, yato yaupe le ise yeletei Ma Ili piti ma kaneise soma towa wumun oli fei lolpepei re ise miso yaltu naro le taniepe mete. Men nange pepe ma kaneise kolo.” ");
INSERT INTO ong_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wem pupam pite Jisas, pe yeflipiye pe pualo nemple uf Galili, Jisas lirpepeye, “Pe ma paltei Ninge lite Metine Wape le esi pite mete. ");
INSERT INTO ong_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pe ma petesi la wolo epli twinges niliyeye fei le Ma Ili ma nou leila.” Wem pe pingitowo pe enke olpe. ");
INSERT INTO ong_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wem Jisas lire pupam pele pau fale uf Kaperneam, mete piti tonwipe era pite winem lite Ma Ili pe pau peletei Pita polpepei, “Metine piti leitaleise lepe le laisipe era pite winem lite Ma Ili lo olo?” ");
INSERT INTO ong_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Iyo, le laisipe ko.” Pita namti lirpepe. Wem Pita linki le winem, Jisas linu lirpeiye, “Saimon, ye onposi polomen? Minemple paisipe era pe moli lipi piti puntoluwepe mete pite tef fei lepei? Eple tuleingi pelpe lo mete nemple? ");
INSERT INTO ong_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita namti lirpeiye, “Mete nemple.” Jisas namti lirpeiye, “Isou, fei polpepe ma eple pelpe ma paisipe era kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wolo ku ma minpipe il pelpe kolo. Pita ye e tuluple le ye ireri huk le ni wuso ye inu eipi lepe, ye nempe nemi lele le ye ma erengape era pratei nemi lele. Era fei pepe ma pirouku ku, piti ye le ki le ye ma kapi ilape e aite winem lite Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wem fei lepeye Jisas pupam pele pe pau peleteiye, “Wem piti Ma Ili ma luntoluwepe mete pite tef, minele ma fale lire metine ili?” ");
INSERT INTO ong_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jisas linawo ninge nele kumpu, le le laltei lilepe pupam pele nimin, ");
INSERT INTO ong_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","le Jisas lirpeiye, “Ise ma retai yolpepei, wuso ise fale watafei eple kumpu kolo, Ma Ili ma luntolise kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Metine piti lire yape le le fale kumpu watafei ninge kumpu lepei, wem Ma Ili luntoluwepe mete pite tef le ma leila nange piti metine fei lepei. ");
INSERT INTO ong_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Le metine minele piti lesio re luntoluwo ninge kumpu fei lolpepei, metine fei lepe le laileleiki ki. ");
INSERT INTO ong_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Le wuso ninge kumpu fei lolpepei le lulpope il peiki wolo metine nele ma laltei lualo tisi oli, metine fei lolpepei lepe le ma olo, le miso laltei erau ili lultei ilyongo lele le le ma lualo lautile peryai krutei le fei pepe ma olpe. Wolo le laltei ninge kumpu fei lepei lualo tisi oli, moingi ili oli ma falowo. ");
INSERT INTO ong_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mete pite tef pe men olpe wusoli il olpe pite tef fei lepei, pe weisipe mete pualo tisi oli. Moingi fei lepei ma fale wolo mete piti weisipe mete nemple pualo tisi oli, mete fei polpepei pepe pe men olpe, pe ma pila moingi ilitei. ");
INSERT INTO ong_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Wuso eti lo urou leiye, le leiteiye ualo tisi oli, alowi kotuwo le ye iri tani. Urou lo eti leiye wuso leiteiye ualo tisi oli lepe, alowi kotuwo le ye iri tani le ye ma ailele yotei piti ma e uf teingi liti ratei ingi wem wem. Le wuso urou lo eti leiye le leiteiye ualo tisi oli le ye itipiyo leiye loli Ma Ili ma lireiye inki weli piti loli wem oli oli. ");
INSERT INTO ong_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Le wuso lutepe leiye le leiteiye ualo tisi oli, kotuwo le ye iri tani. Lutepe wuso leiteiye ualo tisi oli lepe, kotuwo iri tani le ye ma ailele yotei piti ma e uf teingi liti ratei ingi wem wem. Le wuso lutepe leiye le leiteiye ualo tisi oli le ye kotuwo kolo, ye itipiyo leiye loli, Ma Ili ma lireiye inki weli piti loli wem oli oli. ");
INSERT INTO ong_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ise ma kotopa isotei piti ma kelelawo kumpu nele fei lolpepe lepe kolo olo. Ki kirpeise, kumpu fei polpepei pepe pe ririm pelpe wem oli oli pire Ma Ili pepi pratei uf lele yuwei. ");
INSERT INTO ong_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ninge lite Metine Wape laule piti kaniepe mete wuso pingi tisi oli lepe, le ma weisipe laptei pingio tisi teingi. ");
INSERT INTO ong_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ise onposi men? Wuso metine nele le sipsip pele wurutei (100), le sipsip nele le kotireye. Metine fei lepe, le ma lolomen? Le ma lusape sipsip wurutei (99) pepe, lusape palei wolo pile tef nele alo lupai linpei lifei le le ma le lintatawo sipsip nele wuso le kotire lepe. ");
INSERT INTO ong_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wem le lerengawo sipsip wuso kotire lepe, ki kirpeise, le ma onom teinginetei liri sipsip niliyeye wuso kotire le le nou lerengawo lepe le sipsip wuru pepe (99) olo, le ma onom teinginetei liripe fei lolpepe kolo wusoli pe olo pe kotire kolo. ");
INSERT INTO ong_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Min watafei Yaitei leise, le Ma Ili liti yuwei le linaulo piti nele kumpu watafei ninge kumpu lepei le ma lingio tisi oli, ma lingio kolo, olo Ma Ili linau.” ");
INSERT INTO ong_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Wuso line winke leiye le waiye moingi, ye e uluwo le ye kusawo ire tisi oli wuso le lualo liri lepe. Wolo ye ma kotire irpowo le loteteiye. Wuso line winke fei lepe le lapteiye mingim, ye olo kanowo lingowo tisi teingiye. ");
INSERT INTO ong_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Le wuso le lapteiye mingim kolo olo, ye ma kesi metine niliyeye lo twinges yepi ye soma ise twinges lo twinges niliyeye pepe yepi yenete nemple le ise ma kusawo tisi oli wuso line winke fei lepe le lualo liri lepe, le le soma lapteise mingim. ");
INSERT INTO ong_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Le wuso mete twinges tepe te re line winke fei lepe le laptenge mingim kolo olo, ise ma yirpepe ilim winkem wuru wuso pau panfi nemple, pe wuso pulpope il pite Ninge lite Metine Wape pepe. Le wuso pe re line winke fei lepe le laptepe mingim kolo olo, ise ma tounga pesi watafei le lite uf mete nemple lo watafei le metine piti kapise era.” ");
INSERT INTO ong_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Il wuso ise yulpope piti mete ma pingiepe Ma Ili ma lulpope. Le wuso ise il karipe yire men kolo Ma Ili ma karipe kolo. ");
INSERT INTO ong_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Le ki ma nou kirpeise il nemple polpepei, wuso ise mete twinges, te ratei tef lepei le te rounge tulpope il nempleiyeye le te rounge teletei Ma Ili tire il fei pepe, Eiya leiki liti yuwei le ma kanienge. ");
INSERT INTO ong_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Wusoli wem mete twinges lo twinges niliyeye, pe pau panfi nemple le pe pire nange leiki prautuwo Ma Ili, ki re keingalope nimin.” ");
INSERT INTO ong_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Leye lo Pita lau falowo Jisas le le leleteiye, “Apa, wem line winke nele leiki le lireiki oli, wem fei polomen ma ki kirpowo kirpolo ki ma onposiepe il olpe pele kolo olo. Wem fei polomen ma ki kirpopowo? Wem pire eti plen poungo te twinges (7) lom?” ");
INSERT INTO ong_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisas namti lirpowo Pita, “Olo, wem pire eti plen poungo te twinges pepe kolo olo. Wolo ye ma irpopowo wem oli oli. ");
INSERT INTO ong_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Wusoli Ma Ili ma luntoluwepe mete le ma watafei metine ili nele le onposi piti ma laplowi mete tani towa lelpe wuso pe kanowo pesio lepe. ");
INSERT INTO ong_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Metine ili lepe le loporo lotei piti ma laploupe mete pepe tani towa lelpe le pe pila nele lelpe pau falowo. Metine ili lepe le utu pele lipitei patowo metine fei pila pau lepe (10,000,000 kina). ");
INSERT INTO ong_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Metine lepe le mole pele olo yaipiyeye, le ma nou watowo metine ili lepe utu pele kolo. Liso metine ili lepe le lirpei piti pe ma paltei le mete nemple paisi le metine fei lepe le ma lesio towa lelpe yawi. Metine fei lepe le lire moto re eple le tef re oweli men nange pele re mete nemple paisipe papwonou le pe weisipe era pepe watowo metine ili lepe. ");
INSERT INTO ong_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Fei metine piti lesio towa lepe, le le yaru yamkelem lualo ratei onom pite metine ili lepe. Le le louti lirpeiye, ‘Ye onom malye ireiki le ki miso nou waiye men nange peiye yeflipiye.’ ");
INSERT INTO ong_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Fei metine ili lepe le onom manowo metine fei lepe liso utu pele wuso patowo metine fei lepe wolo metine ili lepe le onposiepe kolo oloye le le lusa metine lepe le yawiye. ");
INSERT INTO ong_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Wolo wem metine lepei naro le, le le luluwo metine nele piti pepi pesio towa niliyeye lepe. Le le lesio lari lirpei yeftutuwo metine fei lepe lire utu pele piti le ma nou watowo. Metine linu lepe le utu pele kumputei patowo metine wuso le lesio lari le le lirpei yeftutuwo lepe. Metine linu lepe le lire il singe lirpowo metine lingi lepe, ‘Utu peiki patoye pepe ye ma nou waiki.’ ");
INSERT INTO ong_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Fei metine piti rounge kanowo metine ili pepi pesio towa lepe le yaru yamkelem lualo ratei le le louti lirpowo metine linu lepe lirpowoye, ‘Ye onom malye ireiki le ki miso nou waiye utu peiye.’ ");
INSERT INTO ong_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Wolo metine linu lepe le linaulo. Le lirpepe kesi metine wuso utu pele patowo pepe pe kesi pila pe paltei lifei winem oli ma wem le nou watowo utu piti metine linu lepe tani wo, le soma naro le towa yawi. ");
INSERT INTO ong_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wem mete nemple wuso kanowo metine ili pepi pesio towa lele pepe, pe pulwenge te fei tolpepe pe pe nampli pirpowo metine ili lotei pire mete twinges tepe. ");
INSERT INTO ong_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Leye lo metine ili lepe le linawo metine wuso utu lipitei patowo lepe, metine ili linawo metine fei lepe linki le. Le lirpeiye, ‘Ye metine oli fupeiteteiye. Utu lipitei peiki patoye wolo ye eiteiki piti ma onposiepe kolo olo, wusoli ye outi irpeiki piti ma kusaiye lope ye. ");
INSERT INTO ong_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ye ma onom manowo metine nele leise watafei ki onom maneiye lepe ko.’ ");
INSERT INTO ong_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Metine ili lepe le onom kotu oli le le lirpepe kesi metine fei lepe pila pe paltei lifei winem oli ma wem le nou watowo metine ili lepe utu pele yeflipiye, le ma nou watowo tani wo le soma naro le yawi.” ");
INSERT INTO ong_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Le Jisas lirpei il lapulu lolpepei, “Eiya leiki liti yuwei le re ma lolpepei lireise. Wuso ise onposiepe il olpe pite ilim winkem nemple peise le ise yusape kolo olo, Ma Ili re ma onposiepe il olpe peise. Ilim winkem peise ise ma onom manepe yeliwo yengleipetei. ");
INSERT INTO ong_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wem Jisas lirpei il fei pepe le lapulu, le lusa Galili le le le Juda lato wof Jodan plen le liti epli fale. ");
INSERT INTO ong_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mete wurutei pulsi pe le le kapi kainu pelpe taniepe. ");
INSERT INTO ong_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mete ilepe pite Farasi, pe pau falowo Jisas le pe pemtetei peletei polpepei, “Il lipi pouku pirpei polo il pal fei polomen re metine miso laisine moto pele ne tanio lo ma olo?” ");
INSERT INTO ong_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisas namti lirpeiye, “Ise yungunape il paitei yousi lo olo? Wem linutei Ma Ili laltei metine le le lantei moto, ");
INSERT INTO ong_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","le le lirpeiye, ‘Il pal fei pepei so metine ma lusame nimou re yaitei le le ma lompetene moto pele le me roum ma maiteneme.’ ");
INSERT INTO ong_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Liso fei me roum olo ire pelme kolo olo, ma roum nemiyeye. Menemple pite Ma Ili pele laptei lapwonou, metine ma karipe laptei kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mete pite Farasi, pe peletei Jisas-ye, “Piti men Moses wauku il lipi pite metine ma laptei il paitei yousi le soma watene moto le le ma laisine tanio lepe?” ");
INSERT INTO ong_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisas namti lirpeiye, “Moses waise il pite ise miso yaisipe nimoure peise pe tanise wusoli ise mete piti enke konowatei. Wolo wem Ma Ili linutei laptei men nange pepe, pe pingiepe fei polpepei pepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ki kirpeise, minele piti laisine moto pele ne tanio wolo ne nire metine nele roum metei kolo olo, le le laisine yaune, le munge nou laisine moto nenpe, metine fei lepe le metine oli piti laisipe nimoure lusasape.” ");
INSERT INTO ong_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Fei pupam pite Jisas pirpowoye, “Wuso il fei pepei ma patome munge re moto, ku ma mailele kutou wuso ku ma maisipe nimoure kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisas namti lirpeiye, “Il fei keptalo pepei pepe mete wuru pepe pe ma paptepe mingim kolo olo. Mete pite Ma Ili pele keiniepe, pe poteteiye miso paptepe mingim. ");
INSERT INTO ong_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wusoli il pal olo pire wuru le polomen so mete ma paisipe nimoure kolo olo. Mete ilepe wusoli emare pilape le pe pal yaupe pe miso paisipe nimoure kolo, le mete ilepe wusoli mete nemple nampliepe yilfi le mete ilepe paisipe nimoure kolo olo, wusoli pe enke patowo Ma Ili piti ma luntoluwepe. Metine piti onposi lotei le miso lingowo tisi fei lepe le ma laptei mingim lire il wuso ki keptalo pepe.” ");
INSERT INTO ong_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Leye lo mete ilepe pilape eple pelpe pau paptowo Jisas piti le ma leptalo esi pele puwope le le ma leletei Ma Ili piti ma lailelepe eple kumpu pepe wolo pupam pite Jisas pele, pe pirkilau pirpei il karipe mete pepe. ");
INSERT INTO ong_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Fei Jisas lirpeiye, “Yusape eple kumpu pepe paule ki, le ise il karipe kolo olo, wusoli Ma Ili luntoluwepe mete watafei eple kumpu pepei.” ");
INSERT INTO ong_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jisas laptei esi puwope eple kumpu pepe le le leletei Ma Ili piti ma lailelepe. Jisas lolpepe re fei, le so le tani tulum fei lepe. ");
INSERT INTO ong_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Fei metine nele le lau falowo Jisas le le leletei Jisas lolpepei, “Metine liti eptalo mete lepe, ko towa men teingi ma ki kesio soma ki namti kali nempi liti kratei kingi wem wem?” ");
INSERT INTO ong_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisas namti lirpowoye, “Piti men ye eiteiki ire towa men teingi lepe? Ma Ili loteteiye le teingi. Wuso ye onom natowo nempi liti ratei ingi wem wem ye ma ingiepe il lipi pele.” ");
INSERT INTO ong_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Metine lepe namti leletei Jisas-ye, “Il lipi pepe men?” Fei Jisas nou lirpowoye, “Ye ma etesi metine nele la kolo olo, ye ma irine moto pite metine nele pele roum yetei kolo olo, ye ma ire ausi kapi oweli men nange pite metine nele kolo olo, ye ma emtetei amtuwo metine nele yawi kolo olo, ");
INSERT INTO ong_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ye ma aileleme nimou re yaitei meiye le ye ma kani onom antepe mete nemple watafei ye kani onom antei yotei.” ");
INSERT INTO ong_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Metine lainouwo lepe le namti lirpowo Jisas-ye, “Il lipi fei pepei pepe ki kingiepe le menemple so ki wala olo pepe?” ");
INSERT INTO ong_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Fei Jisas lirpowoye, “Wuso ye onposi piti ye ma fale metine teingi tuwopou, ye e aptetei oweli men nange wuru peiye pepe le mete nemple paisipe, ye kapi era fei pepe watepe mete wuso pe oweli yini olo pepe, le ye ma oweli yini peiye wurutei pifei uf teingi lite Ma Ili. Leye lo ye ma au ulteiki.” ");
INSERT INTO ong_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wem metine lainouwo lepe le lingitepe il fei pepei le onom one le le leye wusoli oweli yini pele wurutei. ");
INSERT INTO ong_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Leye lo Jisas lirpepe pupam peleye, “Ki kirpeise punkom, metine piti oweli yini pele wurutei pepe le ma lire uru weli linta tisi piti Ma Ili ma luntoluwo. ");
INSERT INTO ong_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ki ma nou kirpeise kolpepei, nample kumpu pite si liti miri mengleleipe olongou pepe, nample kumpu fei nepe kamel miso linki wolo metine wuso oweli yini pele wurutei pepe le miso linki le uf teingi lite Ma Ili kolo olo, le ma lire uru weli piti ma le.” ");
INSERT INTO ong_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wem pupam pite Jisas pele pe pingitepe il fei pepei pe pinlele potei olpe le pe peletei Jisas, “Wuso mete piti oweli yini wuru pe ma pire uru weli pe, mete minemple ma pratei pingi wem wem?” ");
INSERT INTO ong_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisas lus poluwepe le le namti lirpepe pupam peleye, “Mete walem miso pesio towa men pire wanketei wolo Ma Ili miso olo, lesio men lire wanketei kolo, olotei.” ");
INSERT INTO ong_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Leye lo Pita namti lirpowo Jisas lolpepei, “Untoli, ku musape oweli men nange pouku, le ku multeiye. Menele ma ku louku?” ");
INSERT INTO ong_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Fei Jisas lirpepeye, “Ki kirpeise punkom, wem Ma Ili nou laltei tef lire teplai yefli, wem fei lepe Ninge lite Metine Wape ma lifei flenge teingipetei piti luntoluwepe mete, leye lo ise piti yulteiki re miso yifei flenge pire esi plen le plen te twinges (12) le ise ma kapi il yaptei yiripe mete pite Israel, alpe pelpe pire esi plen le plen te twinges (12). ");
INSERT INTO ong_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Le mete yeflipi wuso pusape winangou pelpe lo ilim winkem lo eri lo nimou lo yaitei lo eple lo liom pelpe wusoli pe pulteiki ki, men nange pelpe pepe Ma Ili miso nou watepe lasi le wem wurutei le pe ma kali nempi liti pratei pingi wem wem. ");
INSERT INTO ong_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wolo mete wuru wuso pinu pulteiki pepe pe ma weitei pingi le mete wuru wuso pingi pulteiki pepe pe ma namti fale pinu.” ");
INSERT INTO ong_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ma Ili ma luntoluwepe mete watafei yaitei lite liom, le ma naro lire mul ili le laisipe mete piti ma pesio towa lele lite liom. ");
INSERT INTO ong_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Le lulpo piti le ma laisipe mete fei pepe era pantenemple (1 kina) piti epli niliyeye wem pe pesio towa lele. Leye lo le laisipe pe liom lele. ");
INSERT INTO ong_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Wem ulel taise yaitei lite liom lepe le le lulwepe mete ilepe pile tulum liti paptetei re paisesipe oweli. Pe pile yaupe. ");
INSERT INTO ong_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Le lirpepeye, ‘Ise re ye yesio towa leiki liti liom le ki miso kaiteise koporo.’ ");
INSERT INTO ong_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pe so pe.” “Leye lo epli nimin le nou le tulum liti paptetei re paisesipe oweli le nou kesipe mete laptei pe karipe nemple wuso wala pesio towa lele liti liom. Le epli weitei le nou lolpepeye. ");
INSERT INTO ong_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Epli weitei le lire malfem piti ma lautile, yaitei lite liom lepe le nou le tulum liti paptetei re paisesipe oweli le le lulwepe mete ilepe wala pile yaupe. Le lepleteiye, ‘Piti men ise yile yaupe pepe le ise kali epli yaltei yawi?’ ");
INSERT INTO ong_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Ku mile yaupe wusoli minemple ma wauku towa liti mesio, olo.’ Pe namti pirpowo. Fei yaitei lite liom lepe le lirpepeye, ‘Fei so ise re ye yesio towa leiki liti liom’.” ");
INSERT INTO ong_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ningli fei yaitei lite liom lepe le lirpowo metine piti luntoluwepe mete wuso pesio towa pepe, lirpowoye, ‘Inape mete wuso pesio towa pepe le ye watepe era pelpe ire kare towa fei pe pesio. Ye ma aisipe ile mete wuso pingi pau pesio towa lepe soma ilape e e falepe piti pinu pau pesio towa.’ ");
INSERT INTO ong_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mete wuso wem epli weitei le lire malfem piti ma lautile le pe so fale pe pesio towa lepe, pe metine niliyeye niliyeye kapi era pantenemple (1 kina). ");
INSERT INTO ong_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Liso wem mete wuso pinu pe pesio towa pepe pe pe piti ma kapi era pelpe, pe onposi pirpolo pe miso kapi era lipi, wolo olo. Pe re kapi era pantenemple (1 kina) metine niliyeye niliyeye. ");
INSERT INTO ong_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pe kapi era pelpe le pe pire yaitei lite liom lepe, pe pepi pire il pura nemple. ");
INSERT INTO ong_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Pe pirpeiye, ‘Mete wuso ye ingi kesipe aptei piti ma pesio towa leiye pepe pe pesio towa wem kurau, le ku epli ulel lepe, ku mila meletei, epli weli lenke miri nemple wolo ye aisipe pe le ye aitouku ku era nempleiyeye mantei nemple.’ ");
INSERT INTO ong_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wolo yaitei lite liom lepe le namti lirpowo metine nele lelpe lolpepei, ‘Numu leiki ki kempeteiye kolo olo. Ye ulpo piti ye ma esio towa leiki epli niliyeye le ki ma waiye era pantenemple (1 kina) kire kare towa wuso ye esio lepe. ");
INSERT INTO ong_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Fei ye kapi era peiye le ye e winem leiye. Metine wuso lingi lau lesio towa leiki lepe le ye piti inu esio towa leiki, ise roungesye ki ma kaiteise rounge era nempleiyeye yantei nemple. ");
INSERT INTO ong_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Era peiki kutei le ki ma kolomen kolomen kirpe lo ma olo? Lo ye onom one wusoli ki teingi lom?’” ");
INSERT INTO ong_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Le Jisas lirpei il lapulu lolpepei, “Mete piti pingi pe ma namti pinu le piti pinu pepe, pe ma namti weitei pingi.” ");
INSERT INTO ong_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas le Jerusalem le wem le wala le, le kesipe pupam pele pire esi plen le plen te twinges, Jisas kesipe pe ire pelpe le le lirpepeye, ");
INSERT INTO ong_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ku ma munwei me Jerusalem, le Ninge lite Metine Wape ma pe paltei le esi pite mete lipi piti pinuwepe mete piti peptawio Ma Ili siye le mete piti peptalo mete pire il lipi pite Moses. Pe ma paptei il singe pirpei polo “Le oli le le ma la.” ");
INSERT INTO ong_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Le pe ma kesi paltepe mete pite alpe nemple piti pe ma palwe oli piri, petesi le pe ma pire singu palwe paltei laitei nimpe. Le epli twinges le niliyeye fei Ma Ili ma nou leila.” ");
INSERT INTO ong_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Leye lo Sebedi moto pele nire eple winge, pe pe falowo Jisas, le pe yaru yamkelem le nimou notei neletei Jisas piti ma watene menele teingi. ");
INSERT INTO ong_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisas leneteiye, “Ki ma waiye menele?” Le ne namti nirpowoye, “Ye ma topwepe il apiri ireiki ki olpepei, Wem ye fale ire metine ili liti untoluwepe mete, ye ma autetei eple winge teiki tepei, nele ye ma altei lifei eti tilpi le nele lepe ye ma altei lifei eti enkau.” ");
INSERT INTO ong_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisas namti lirpepeye, “Ise yironom yire men wuso ise yeiteiki yiri lepe. Ise rounge miso yila moingi wuso ki ma kila lepe lo ma olo?” “Ku miso wila,” Jems lire Jon rounge namti tirpei. ");
INSERT INTO ong_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jisas lirpengeye, “Punkomtei ise rounge miso yila moingi leiki. Wolo ki ma keiniepe minemple piti ma pifei eti tilpi lo eti enkau leiki lepe kolo, olo, ki ma kolpepe kolo olo. Tulum fei pepei pe piti mete wuso Eiya leiki, le keiniepe piti pe ma pifei tulum fei pepe.” ");
INSERT INTO ong_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wem pupam nemple pire esi plen le plen, pe pingitei polpepei pe enke kotu piringe line re winke, Jems re Jon. ");
INSERT INTO ong_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Liso Jisas linape pupam pele pau panfinemple le le lirpepeye, “Ise retai yolpepei, mete lipi piti puntoluwepe mete wuso pulpope il pite Ma Ili kolo olo pepe, il men mete lipi fei pepe pe pirpei mete yaupe pepe pe ma paptepe minkim le mete lipi pelpe pepe pe puntoluwepe. ");
INSERT INTO ong_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tisi fei lepei lepe ise ma yingio kolo, olo. Wuso nele leise le lirpei lolo le ma fale lire metine ili, metine fei lepe le ma linu lesio towa leise wo, le soma fale lire metine ili. ");
INSERT INTO ong_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Le minele lirpolo le ma linu, metine fei lepe le ma lesio towa leise yawi. ");
INSERT INTO ong_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Le ma watafei Ninge lite Metine Wape, le lau piti mete nemple ma pesio towa lele kolo olo, wolo le ma lesio towa lelpe le le ma la lungwipe mete wuru. ");
INSERT INTO ong_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wem Jisas lire pupam pele pe pusa Jeriko le pe pe, mete wurutei pulsi Jisas pe. ");
INSERT INTO ong_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mete twinges, te lutepe olpe. Te rounge tifei tisi lunko lepe, le wem te tingitei tolpepei Jisas ma le rautetei le, te tailo tirpeiye, “Ninge lite Devit, ili louku, ye onom manouku.” ");
INSERT INTO ong_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mete wurutei pepe pe pirpei lange le pe pirpenge piti te ma pos tato. Wolo te rounge tirkilau tailolo tirpeiye, “Ninge lite Devit, ili louku ye onom manouku.” ");
INSERT INTO ong_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas lile le le linange louteteiye, “Ise rounge yirpolo ki ma kolomen kireise rounge?” ");
INSERT INTO ong_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Te rounge namti tirpowo Jisas-ye, “Ili louku, ku wirpeiye piti ye ma nenfaripe lutepe pouku.” ");
INSERT INTO ong_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisas onom manenge le le lesiepe lutepe pelnge le frou yo fei te rounge tuntoliliye. Le te rounge teifale tulsi Jisas. ");
INSERT INTO ong_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Pe pe fale malfem pire Jerusalem le wem pe pe fale uf kumpu Betfasi lifei tef alo lupai linpei lifei liti nimpe oliv pile, Jisas laisinge pupam twinges tele tinuwo te, ");
INSERT INTO ong_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","le le lirpenge lolpepei, “Rounge ye uf kumpu lato linuse lepe le ise rounge miso frou yerengane donki nimou pe topuwene nile nire ninge kumpu lene. Nenfarime le ise rounge yeipime yilame yau waiki. ");
INSERT INTO ong_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Le wuso minemple pirpei il men, ise rounge ma yirpowo yolpepei, ‘Apa ili lirpei ku so waule weipime wilame we ma wamtowo le le miso nou frou lamtei mau’.” ");
INSERT INTO ong_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Fei pepei fale piti ma paptei il wuso metine nimou linu lirpei pepe pe ma fale punkom. Metine nimou lirpei il polpepei, ");
INSERT INTO ong_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Yirpepe uf ili Jerusalem, yuluwo metine ili leise laule ise. Le lire yape le le lifei donki lau, le lifei donki ninge kumpu.” ");
INSERT INTO ong_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Fei pupam twinges wuso Jisas lirpenge lamtetenge tepe, te te tingiepe il wuso Jisas lirpei pepe. ");
INSERT INTO ong_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Te tilane donki nimou nire ninge meme, tilame tau le te tiripe olongou pelnge piti tapiri pifei yuwei, te tiripe pifeme donki nimou nire ninge, le Jisas longlo lifei yuwei. ");
INSERT INTO ong_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mete wurutei nomplei olongou pelpe piti pafo pifei yuwei pepe, pe kesipe paptetei pinge tisi le mete ilepe pepe pe paploupe oflongelem le pe so paptetei pato pinge tisi. ");
INSERT INTO ong_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mete wurutei piti pinuwo Jisas pe le pe piti pulsesi pingi pepe, pe pailolo pirpeiye “Hosana, meila nange lite ninge lite Devit. Ma Ili ma kani onom lantowo re lailolowo piti laule lire nange lite Apa Ili. Meila nange lite Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wem Jisas le fale Jerusalem, mete piti uf ili lepe pe kete ipli ili paltei. Pe peite nempleiye, “Le minele?” ");
INSERT INTO ong_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mete wurutei pepe pe namti pirpeiye, “Lepei lepe le metine nimou Jisas lite uf Nasaret lato tef lite Galili.” ");
INSERT INTO ong_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Fei Jisas linki le winem lite Ma Ili le le laptu mete piti paptetei re paisesipe oweli pifei winem lite Ma Ili lepe. Jisas lesi weisipe ponu piti mete wuso kapi era pite uf mete nemple le pe ma namti watepe era pelpe pite uf tef lelpe potei le le lesi weisipe tile pite mete wuso paptetei naflepem malpum pite mete ma paisipe pepe. ");
INSERT INTO ong_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Le Jisas lirpepeye, “Il pite Ma Ili lirpei le pe paptei paitei yousi, pe pirpei polpepei, ‘Winem leiki liti mete ma pifei peletei Ma Ili’, wolo fei ise weisi fale lire ‘winem liti mete wuso pire ausi le pe ma pau kotire pifei’.” ");
INSERT INTO ong_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mete wuso lutepe pelpe olpe le ire olpe, pe pau falowo Jisas lifei winem lite Ma Ili lepe le le kapi kainu pelpe taniepe. ");
INSERT INTO ong_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mete lipi piti pinuwepe mete piti peptawio Ma Ili siye, pe pire mete piti peptalo mete nemple pire il lipi pite Moses, mete fei pepe pe enke kotu pire Jisas wem pe pulwepe men men teingipetei le laptei fale, le eple kumpu pailolo re poutiti pratei winem lite Ma Ili leinginim, pailolo pirpeiye, “Meila nange lite ninge lite Devit.” ");
INSERT INTO ong_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mete lipi piti peptawio Ma Ili siye le mete piti peptalo mete nemple pire il lipi pite Moses, mete fei pepei pe pirpowo Jisas-ye, “Ye ingitepe il pite eple kumpu pepei lo olo?” “Iyo, ki kingitepe punkom.” Jisas namti lirpepe. “Le, il pepei paitei yousi le pe pirpei polpepei, ‘Ye eptalo eple lipi re kumpu piti pe ma peila nange lite Ma Ili poporotei’.” ");
INSERT INTO ong_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisas lusape le le le tani uf ili lepe. Le le Betani le mulpou lepe Jisas letei lato Betani. ");
INSERT INTO ong_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nolowi lire mul ili Jisas nou le uf ili Jerusalem le le nimpi nalei. ");
INSERT INTO ong_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Le luluwo ifau lile tisi lunko le le karowo le fale luntoli wolo olo yawi, yumko olo pultei kolo. Liso Jisas lirpowo ifau lepe, lirpeiye “Ye nauyou ma ilape fouri kolo oloye.” Frou yo fei ifau lepe yousi weitei pire punko le ifau laye. ");
INSERT INTO ong_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pupam pite Jisas, pe puluwepe fei pepei le pe pinlele potei. Pe peletei Jisas polpepei, “Ifau yousi pire punko le le frou la lolomen?” ");
INSERT INTO ong_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisas namti lirpepeye, “Ise ma onposiepe il pepei, wuso ise yulpope il pite Ma Ili le ise enke nemple nemple kolo olo, ise miso yesi menele watafei ki kolpepe kire ifau lepei. Le fei pepei poteteiye kolo, ise miso yirpowo tef alo lupai linpei lifei lepei yirpeiye, ‘Kotu e ire yotei autile peryai.’ Le le ma lolpepe. ");
INSERT INTO ong_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Wuso ise yulpope il pite Ma Ili, ise ma yeletei yire men nange pepe le Ma Ili ma waise.” ");
INSERT INTO ong_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Fei Jisas nou le winem lite Ma Ili le wem le wala leptalo mete lire il pite Ma Ili, mete lipi piti pinuwepe mete piti peptawio Ma Ili siye, pe pire mete lipi piti pinuwepe mete pite Juda, pe pepi pau peletei Jisas polpepei, “Minemple pirpeiye piti ye ma aptu mete piti paptetei re paisesipe oweli, ye ma aptu tani winem lite Ma Ili lepe? Minemple waiye il?” ");
INSERT INTO ong_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisas namti lirpepeye, “Ki ma keiteise kire il nempleiyeye pepei, le wuso ise nou yirpeiki il pal so ki re ma kirpeise kire minemple so pe waiki il pite ki ma kaptu mete tani winem lite Ma Ili lepe. ");
INSERT INTO ong_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Minemple pirpowo Jon piti ma kaptetei mete, il paule pinei? Il paule Ma Ili lo pe paule mete pite tef?” Pe pire il pura nempleiye, “Ku ma mirpei il men? Wuso ku nou mirpowo molpepei, ‘Il paule Ma Ili,’ le ma lirpouku lolpepei ‘Piti men ise yulpope il pite Jon kolo lepe?’ ");
INSERT INTO ong_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Le wuso ku mirpeiye, ‘Il paule mete pite tef,’ ku turuku mire mete wusoli pe yeflipiye pe pesiepe il pirpolo Jon le metine nimou.” ");
INSERT INTO ong_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pe so namti pirpowo Jisas polpepei, “Ku olo mretai kolo.” Le Jisas lirpepeye, “Ki re ma kirpeise kolo, kirpeise kire minemple so pe waiki il pite ki ma kaptu mete tani winem lite Ma Ili lepe, ma olo, kirpeise kolo.” ");
INSERT INTO ong_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ise fei onposi men? Metine nele le eple tuleingi tele twinges. Le le line oru lepe le le lirpowoye, ‘Ninge leiki, ye fei ma e esio towa liti liom wain.’ ");
INSERT INTO ong_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ninge namti lirpeiye, ‘Ki kinaulo.’ Wolo wem ulel re fei le nou weisine onom le le le liom wain lepe. ");
INSERT INTO ong_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Leye lo yaitei le ninge nele lepe le le nou lirpowo il nempleiyeye watafei le linu lirpowo ninge oru lepe. Ninge lepe namti lirpeiye, ‘Iyo ili leiki, ki miso ke.’ Wolo le olo le liom wain kolo. ");
INSERT INTO ong_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Te rounge, minele so lingiepe il pite yaitei lepe?” “Line oru,” pe namti pirpei. Fei Jisas lirpepeye, “Le ki kirpeise il pepei, mete piti kapiepe mete era le nimoure piti tisi, mete fei pepei Ma Ili ma linu lailelepe re luntoluwepe. ");
INSERT INTO ong_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon liti kaptetei mete, le laule kusaise tisi piti ise ma ratei tuwopou wolo ise yulpowo kolo. Le mete piti kapiepe mete era le nimoure piti tisi, pe pulpowo. Le ise yulwepe re fei wolo enke peise olo weitei kolo le ise yulpowo kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas lirpeiye, “Yingitepe il nemple kauro yuwei. Yaitei lite tef le lapiri wain, le lantei lom neinowo liom wain lepe le le lalwe oi liti kenpipi wain. Le le lire era leilape tile piti lifei rourepe mete piti ma paule pire ausi le naflepem piti ma paule paplei wain fouri. Leye lo yaitei lite liom wain lepe le laltei liom wain lepe le esi piti mete nemple piti pe ma puntoluwo le pe ma paisi era kumpu kumpu pire kari wain wuso pe ma kari lepe, le yaitei lite liom wain lepe le lusa uf lele le le laule le uf mete nemple leye. ");
INSERT INTO ong_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wem liti pe ma kari wain fouri, yaitei lite tef re liom wain lepe le laisipe mete pele piti pesio towa lele, le laisipe pe piti ma kapi wain fouri wuso mete piti puntoluwo liom wain lepe, pe ma paptei ilepe watowo yaitei lite tef re liom wain lepe. ");
INSERT INTO ong_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wolo mete piti puntoluwo liom wain lepe, pe pesiepe mete wuso yaitei lite tef re liom wain lepe le laisipe pe piti ma kapio wain fouri ilepe pele pepe. Mete wuso puntoluwo liom wain pepe, pe pesiepe mete fei pepe le pe petesi nele, pe petesi nele la, le pe pire era posio nele. ");
INSERT INTO ong_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yaitei lite tef re liom wain lepe le nou laisipe mete nemple pele piti pesio towa lele, le laisipe pe le wem fei lepei le laisipe wuru taise pe. Wem linu le laisipe yaipiyeye pe, le fei le laisipe wuru taise wolo mete piti puntoluwo liom wain lepe pe posiepe re petesipe watafei pe polpepe piripe nemple pinu pepe. ");
INSERT INTO ong_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Linglitei yaitei lite tef re liom wain lepe le laisi ninge lele le. Le lirpeiye, ‘Pe miso pailolowo ninge leiki.’ ");
INSERT INTO ong_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Wolo wem mete piti puntoluwo liom wain lepe pe puluwo ninge, pe pirpei nempleiye, ‘Yaitei lite tef re liom wain lepe, ninge lele min lepei. Iso, ku metesi la le ku ma kapio men nange pele.’ ");
INSERT INTO ong_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pe so pesio pari, pe piri le yawi tani liom wain le pe petesi la. ");
INSERT INTO ong_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Fei, wem yaitei lite liom wain lepe le lau, le ma lolomen liripe mete wuso puntoluwo liom wain pepe?” Jisas lepletei mete piti pinuwepe mete piti peptawio Ma Ili siye le mete piti peptalo mete nemple pire il lipi pite Moses. ");
INSERT INTO ong_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pe namti pirpowo Jisas polpepei, “Yaitei lite liom wain lepe le ma lire punkom losiepe mete olpe pepe pa, le liom wain lepe le ma laltepe mete nemple puntoluwo, le wem pe karipe wain fouri pe miso paptei ilepe pele watowo.” ");
INSERT INTO ong_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas lirpepeye, “Ise yungunape il pite paitei yousi lo olotei? Il pirpei polpepei, ‘Nimpe lotei wuso mete piti peilape winangou pe pinauli lepe, wolo le nimpe teingitei. Ma Ili lotei kali lari lile lire tupe le fei pepe olo teingipitei’.” ");
INSERT INTO ong_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Le ki so kirpeise,” Jisas lirpei lapwonou lolpepei, “Wem teingi liti Ma Ili ma luntoluwepe mete, Ma Ili ma kali wem fei lepe tanise le le ma watepe mete nemple piti pe ma pesio towa lele poporo. ");
INSERT INTO ong_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Metine minele piti lualo letesi nimpe fei lepe, metine lepe ma laututu lire kumpu kumpu. Le wuso nimpe lepe le lualo letesi metine nele, le ma raltipi lire tuwiye.” ");
INSERT INTO ong_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mete lipi piti pinuwepe mete piti peptawio Ma Ili siye le mete pite Farasi, pe pingitepe il kauro yuwei wuso Jisas lirpei pepe, le pe pretai Jisas lirpei liripe pe. ");
INSERT INTO ong_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pe so pinta tisi piti ma penglei. Wolo pe turwepe pire mete wurutei pepe wusoli pe pirpei polo Jisas le metine nimou. ");
INSERT INTO ong_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas nou lirpei il kauro yuwei lirpepe mete, Jisas lirpepeye ");
INSERT INTO ong_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ma Ili ma luntoluwepe mete watafei metine nele ili, le lapli oweli piti ninge lele ma laisine moto. ");
INSERT INTO ong_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Le laisipe mete pele piti pesio towa lele pepe, le laisipe pe pirpepe mete wuso pinu kapi il pite pe ma paule pire metine ili lepe pepi paplei oweli wuso le lapli pepe, wolo pe paule kolo oloye, pe pinaulo. ");
INSERT INTO ong_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Liso metine ili lepe le laisipe mete ilepe pele piti pesio towa lele lepe, le laisipe pilape il polpepei pe, ‘Yirpepe mete wuso kirpepe piti pe ma pau pireiki mepi maplei oweli pepe. Ki kapli oweli fei. Bulmakau epem lipi le bulmakau eple teingipe piti ma kaptepe mete paisipe, pe olo fei kosiepe pa le ki kaptutu re kaploloupe elpesipe kaptei pifei le oweli men nange pepe olo fei elpesipe pifei. Ise yaule ma maplei oweli pepe.’ ");
INSERT INTO ong_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Wolo mete wuso kapi il pite ma paule pire metine ili lepe pepi paplei oweli, mete pepe pe pingiepe il pite metine ili lepe kolo, olo, le pe pe pesiepe towa men pelpe fi fi peye. Metine nele le liom lele, le nele le lesio towa lele piti laptetei oweli le mete nemple paisipe. ");
INSERT INTO ong_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Le mete ilepe pepe pe pesiepe mete piti pesio towa liti metine ili lepe le pe posiepe re petesipe paye. ");
INSERT INTO ong_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Metine ili lepe le onom kotu oli, le laisipe mete pele piti plolpo, pe pe posiepe mete olpe pepe pa, le pe paltei weli lalei uf ili liti mete olpe pepe. ");
INSERT INTO ong_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Leye lo metine ili lepe le linape mete pele piti pesio towa lele le le lirpepeye, ‘Oweli piti kaplio ninge leiki ma laisine moto, oweli olo fei elpesipe pifei wolo mete wuso kaptei il pe piti pe ma pau pepe olo ma pau paplei koloye. ");
INSERT INTO ong_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ise fei ma ye tisi lipi pepe le ise yirpepe mete wurutei wuso yerengape pepe le ise ma yirpepe paule paplei oweli pepei.’ ");
INSERT INTO ong_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Liso mete piti pesio towa liti metine ili lepe, pe pe tisi lipi le pe kesipe mete paptei nemple, mete wurutei wuso pe perengape pepe. Mete olpe re teingipe pualo kari nemple le winem lite metine ili lepe, mete piri poungaiye. ");
INSERT INTO ong_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Metine ili lepe le linki le piti ma lulwepe mete wuso linape paule pepe le le luluwo metine nele le lafo olongou piti ma rautuwo wem ili fei lepe kolo, olo, le lafo olongou nemple. ");
INSERT INTO ong_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Fei metine ili lepe le leletei metine lepeye, ‘Numu leiki, ye afo olongou piti ma rautuwo wem fei lepei lepe kolo olo, ye einei fei olomen so inki au lepei?’ Wolo metine lepe lirpei il men re kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Leye lo metine ili lepe le lirpepe mete pele piti pesio towa lele pepe, le lirpepeye, ‘Topuwo ire pire esi pele le ise yiri le towa yawi munkunum. Le ma loutiti re laplelei nilpe pele’.” ");
INSERT INTO ong_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Le Jisas lirpei il lapulu lolpepei, “Ma Ili laptei il pe mete wuru wolo mete yaipiye le keiniepe.” ");
INSERT INTO ong_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Fei mete pite Farasi, pe peye le pe onposi pirpolo pe ma peletei Jisas pire il nemple le le ma fupeletei lire il pepe. ");
INSERT INTO ong_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Leye lo pe paisipe pupam ilepe pelpe pire mete ilepe piti pulsi metine ili Herot. Pe paisipe mete fei pepe pe falowo Jisas. Pe pirpeiye, “Ye metine liti eptalo mete, ku mretai ye metine piti irpei punkom. Ye ingio tisi lite Ma Ili le ye eptalo mete ire il punkom. ");
INSERT INTO ong_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mete miso weiteiye kolo olo wusoli ye uluwo matufuwo metine ile topo yuwei kolo olo, ye uluwo matufuwo ile onom pele leinginim. Ye onposiepe fei polomen ye ma irpouku. Wem ku maisipe era pe moli ili lite Rom, ku yaruwepe il lipi pite Ma Ili lo olo?” ");
INSERT INTO ong_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisas retai pe onposiepe il olpe le so lirpepeye, “Ise mete piti nel loli ilo ilo. Ise onposi yirpolo ise ma weiteiki kualo tisi oli lom? ");
INSERT INTO ong_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kusaiki erau liti ma yaltei watowo moli ili lepe.” Pe pila erau lepe pau watowo Jisas, ");
INSERT INTO ong_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","le le lepleteiye, “Minele mati re nange lele so paitei pepei?” ");
INSERT INTO ong_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pe namti pirpeiye, “Pe pite moli ili lite Rom.” Liso Jisas lirpepeye, “Iso, menemple pite moli ili lite Rom pele, ise ma pele watowo le menemple piti Ma Ili pele, ise ma pele watowo.” ");
INSERT INTO ong_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wem pe pingitepe il pite Jisas, pe pinlele potei le pe pusa le pe pe tanio. ");
INSERT INTO ong_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Epli niliyeye lepe mete ilepe pite Sadyusi, pe paule falowo Jisas. Sadyusi, pe mete piti pirpei polo wem mete pa, pe ma nou peilo kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Pe pirpeiye, “Ye metine piti eptalo mete. Moses lirpouku lirpolo wuso metine nele le lilape eple kolo, le le la yawiye, winke ma laisine towa moto nepe soma me roum milape eple pilowo tulum liti line wuso la lepe. ");
INSERT INTO ong_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sungoi liye, ilim winkem nemple, pe pire eti plen poungo te twinges, pe pratei lepei. Line oru laisine moto wolo le lilape eple kolo, la yawiye, le winke piti luwowo line oru lepe, le namti weisine laisine. ");
INSERT INTO ong_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Winke piti luwol line oru lepe le re so lolpepeye, la yawi, eple olo. Winke nele piti luwol, le namti weisine towa moto elpesine nepe, wolo le re la, pa pe pe yalipeye. ");
INSERT INTO ong_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Towa moto nepe ne na ningi. ");
INSERT INTO ong_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Le wem pe ma nou peilo, ne ma moto piti minele lelpe? Pe yeflipiye wuso paisine nepe?” ");
INSERT INTO ong_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisas namti lirpepeye, “Ise onposi yoporo kolo olo wusoli ise yironom yire il pite paitei yousi, le singe pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wem mete wuso pinu pa pepe le pe nou peilo, pe ma watafei ririm piti yuwei pepe le mete re nimoure ma paite nemple kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Le lire il pite mete wuso pinu pa le pe ma nou peilo ise re yironom. Ise yungunape il wuso Ma Ili lirpeise pepe lo olo? Le lirpeiye, ");
INSERT INTO ong_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ki fei Ma Ili lite Abraham, Ma Ili lite Aisak, le Ma Ili lite Jekop.’ Il pepe pato polpepei, mete paye wolo pe pa pelengi kolo olo, wusoli Ma Ili lirpei, le Ma Ili lelpe. Wuso pe pa pelengi le ma wala Ma Ili lelpe kolo. Wolo le lirpei le wala Ma Ili lite pe, leso ku ma retai mete wuso pa pe ma nou peilo.” ");
INSERT INTO ong_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wem mete wurutei pepe pe pingitepe il pepe, pe pinlele potei pire il pele piti leptalo. ");
INSERT INTO ong_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Wem mete pite Farasi pingitei wuso Jisas lirpei le mete pite Sadyusi pe pos pato pepe, mete pite Farasi pepe pe pau panfi nemple. ");
INSERT INTO ong_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Le nele lelpe, le metine piti leptalo mete nemple lire il lipi pite Moses, metine lepe le lirpolo le ma lemtetei leletei Jisas le Jisas ma fupeletei. ");
INSERT INTO ong_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Le leletei Jisas-ye, “Ye metine liti eptalo mete, il lipi pite Moses pepe, il men so pe lipitei?” ");
INSERT INTO ong_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisas namti lirpowoye, ‘ “Ise ma onom kerowo ili, le Ma Ili leise. Ise ma onom kerowo yire enke peise, singe peise, le ise ma onom kerowotei.’ ");
INSERT INTO ong_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Il lipi pinu pepei pe lipitei le pe teingipetei. ");
INSERT INTO ong_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Le il nemple teingipetei puwope piti pinu pepe pe pirpei polpepei, ‘Ise ma onom kerowo metine nele watafei ise onom kere isotei.’ ");
INSERT INTO ong_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Il lipi yeflipiye, pite Moses le pite mete emare, pe poluwepe il lipitei twinges fei pepei.” ");
INSERT INTO ong_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wem mete pite Farasi pe pau peifonemple Jisas lepleteiye, ");
INSERT INTO ong_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ise onposio Krais, le minele? Le ninge palyene lite mi?” Le pe namti pirpowoye, “Le ninge palyene lite Devit.” ");
INSERT INTO ong_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisas nou lepleteiye, “Piti polomen so Riri Teingi lite Ma Ili lunkuwo Devit le le linawo Krais le ili lele? Wusoli Devit lirpei lolpepei, ");
INSERT INTO ong_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ma Ili lirpowo ili leiki, ‘Ifei eti tilpi leiki lepei ungari wem ki ma kaptei mete eringi peiye pratei ire yepe peiye tef.’ ");
INSERT INTO ong_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Le wuso Devit linawo Krais le ‘ili lele’ le polomen ma Krais le ninge palyene lite Devit?” ");
INSERT INTO ong_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Minemple ma nou peletei Jisas pire il men, oloye, le wem fei lepe le le le, nele lelpe re nou leletei Jisas lire il men kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Leye lo Jisas lirpepe mete wurutei pepe le le lirpepe pupam pele lirpeiye, ");
INSERT INTO ong_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mete piti peptalo mete nemple pire il lipi pite Moses le mete piti Farasi, pe pilowo Moses tulum le pe weisipe re pirpeise pire il lipi pepe. ");
INSERT INTO ong_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","So ise ma yaptepe mingim le ise yingiepe il men pe pirpei piti ise ma yingiepe. Wolo tisi men pe pingio piti pesio towa men, ise ma yingiepe pato wusoli il men pe peptalo wolo pe pingiepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pe kete moingi paltepe mete nemple le pe kete ire esi taniepe mete fei pepeye, pe ma nou kaniepe kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pe pesiepe towa men wuru piti mete nemple ma pulwepe re yafeipe. Yulwepe morou topungou pe paptei il pite Ma Ili paitei le pe topwepe pifei masi re esi pelpe le olongou pelpe piti pafo pifei yuwei, mingelem pelpe pepe pe pengleipe pe ulepe. Pe polpepei wusoli mete ma pirpei polo ‘Pe pirkilau pingiepe il pite Ma Ili,’ wolo olo. ");
INSERT INTO ong_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pe onom kerepe tulum teingipe piti pe pifei wem mete papli oweli lipi le pe pinape pe le angli pal re pe ma pompetepe tulum teingipe soma pe pifei. ");
INSERT INTO ong_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pe onom kerepe mete wuso pratei tulum piti paptetei re paisesipe oweli piti pe ma peisipe poporo le mete ma pinape pe mete piti peptalo mete. ");
INSERT INTO ong_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ise ma yusape mete nemple pinaise pirpolo ise mete piti yeptalo mete nemple kolo olo, pe ma pinaise polpepe kolo wusoli ise ilim winkem le metine niliyeye le leitaleise. ");
INSERT INTO ong_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Le ise ma yinawo metine nele lite tef fei lepei lepe, yinawo yirpolo eiya kolo, olo, wusoli ise Yaitei niliyeye leise le ratei yuwei. ");
INSERT INTO ong_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Le pe ma pinaise pirpolo ise mete piti yinuwepe mete nemple pe ma pinaise polpepe kolo wusoli metine niliyeye piti linuse le Krais. ");
INSERT INTO ong_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Metine ilitei leise le ma lesiepe towa leise. ");
INSERT INTO ong_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Metine minele wuso leila lotei lirpolo le metine ili, Ma Ili ma kari laltei lire metine kumpu lire yape le metine minele wuso leite lotei lirpolo le metine kumpu lire yape, metine fei lepe Ma Ili ma laltei lire metine ili.” ");
INSERT INTO ong_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Moingi ilitei ma faleise ise mete piti yeptalo mete nemple pire il lipi pite Moses le ise mete pite Farasi. Ise mete piti nel loli ilo ilo. Ise yamsi wingi karipe mete piti ma pe uf teingi lite Ma Ili. Ise isotei re miso yinki ye kolo olo, le mete nemple pirpolo pe ma pinki pe pepe wolo ise yusape pe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Moingi ilitei ma faleise ise mete piti yeptalo mete nemple pire il lipi pite Moses le ise mete pite Farasi. Ise mete piti nel loli ilo ilo. Ise yempesipe towa nimoure le ise yire ausi kapiepe oweli men nange pelpe piti winangou pelpe le ise rautu isotei yaupe wem ise yire il ulepe tengelem yaupe yeletei Ma Ili. Wusoli ise fei yolpepei, Ma Ili ma waise moingi ilitei.” ");
INSERT INTO ong_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Moingi ilitei ma faleise ise mete piti yeptalo mete nemple pire il lipi pite Moses le ise mete pite Farasi. Ise mete piti nel loli ilo ilo. Ise yinge peryai ye uf tef nemple nemple le ise yirkilau ma weisipe mete yaptei pulteise. Le wem pe papteise mingim ise isotei yingowo tisi oli wolo ise yingowo wisyauye le mete wuso ise weisipe pingeise pepe, pe pirkilautei pingowo tisi oli lepe pe weli ili peye.” ");
INSERT INTO ong_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ise mete piti naliepe mete nemple tisi, wolo ise lutepe olpe, ise retawo tisi yoporo kolo, wolo yirpei yolo, ise ma naliepe tisi, moingi ili ma faleise. Ise yeptalo mete nemple yolpepei, ‘wuso metine nele le topwepe il lapiri le le leisi nange lite winem lite Ma Ili lele, il wuso le topwepe lapiri pepe pe ma pile singe kolo olo. Le wuso le leisipe kol wuso pifei winem lite Ma Ili leinginim pepe, il wuso linu topwepe lapiri pepe pe ma pile singe.’ ");
INSERT INTO ong_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ise lutepe olpe, fupeiteteise. Menemple pe teingipetei, gol lo winem lite Ma Ili wuso laptei gol fale teingipetei pepe? ");
INSERT INTO ong_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ise yeptalo yapwonou yolpepei, ‘Wuso metine nele le topwepe il lapiri le le leisi nange lite tile, il wuso le topwepe lapiri pepe, pe ma pile singe kolo olo. Le wuso le leisipe nange piti oweli men wuso pifei tile piti ma paptei watowo Ma Ili, il wuso linu topwepe lapiri pepe pe ma pile singe.’ ");
INSERT INTO ong_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ise lutepe olpe. Menemple pe teingipetei oweli piti paptei watowo Ma Ili lo tile wuso oweli pifei le pe fale teingipetei pepe? ");
INSERT INTO ong_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","So wem metine nele le topwepe il lapiri le le leisipe nange piti tile leptalipe, le leisipe tile yaupe kolo olo, le leisipe tile le wata pirpolo le leisipe lapwonou, tile le oweli piti pifei, le leisipe lapwonou. ");
INSERT INTO ong_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Le wem metine nele le topwepe il lapiri le le leisi nange lite Ma Ili winem lele leptalipe, le leisi winem yawi kolo olo, le leisi Ma Ili winem lele wata pirpolo le leisinge lautuwonou Ma Ili lire winem lele, wusoli Ma Ili ratei winem lele. ");
INSERT INTO ong_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Le wem metine leisi teplai yuwei, le leisi tulum liti Ma Ili lifei le le leisi Ma Ili lotei wuso lifei tulum fei lepe.” ");
INSERT INTO ong_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Moingi ili ma faleise ise mete piti yeptalo mete nemple le ise mete pite Farasi. Ise mete piti nel loli ilo ilo. Ise yingiepe il kumpu pite Moses watafei kapi oweli wopu watafei furfongou, le ise yaptei tulum pire esi plen le plen le oweli piti tulum niliyeye pepe ise yaptei watowo Ma Ili le piti pire esi plen le twinges te twinges pepe peise isotei. Ise yolpepe, wolo il teingipetei pite il lipi pite Moses pepe, il pite ratei teingi tuwopou, onom manepe mete nemple le piti empesipe mete nemple kolo olo. Il pepei ise yingiepe kolo olo. Wolo il pepei ise ma yingiepe yirkilau le il nemple pepe piti watowo Ma Ili oweli re ise ma yingiepe yapwonou. ");
INSERT INTO ong_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ise mete piti naliepe mete nemple tisi wolo ise lutepe olpe. Il kumpu flo le ise yingiepe yailelepetei wolo il lipi singe ise yingiepe kolo olo, ise yaruwepeye.” ");
INSERT INTO ong_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Moingi ili ma faleise ise mete piti yeptalo mete nemple pire il lipi pite Moses le ise mete pite Farasi. Ise mete piti nel loli ilo ilo. Minki paingelem peise ise kaptetei toungalemye, le leinginim olo wala pire oweli wuso yire ausi kapi le ise yire fila yasiepe. Oweli olpe pepe wala pratei leinginim. ");
INSERT INTO ong_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ise mete pite Farasi, ise lutepe olpe. Minki paingelem peise ise ma kaptetei leinginim yailelepe wo soma toungalem re miso fale teingipe.” ");
INSERT INTO ong_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Moingi ili ma faleise ise mete piti yeptalo mete nemple le ise mete pite Farasi. Ise mete piti nel loli ilo ilo. Ise watafei era namplungu piti paplingi towa puwo, le towa yawi pe teingipe fi le lus pulwepe pariepe wolo leinginim olo fale poparu pire towa emingelem re talu wuso porworo pepe. ");
INSERT INTO ong_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Min watafei ise, mete nemple pulise topo yawi pe pirpolo ise mete teingipe wolo leinginim peise ise mete piti nel loli ilo ilo le il olpeye pirkilau pratei.” ");
INSERT INTO ong_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Moingi ili ma faleise ise mete piti yeptalo mete nemple pire il lipi pite Moses le ise mete pite Farasi. Ise mete piti nel loli ilo ilo. Ise yaploupe era namplungu yailelepetei piti ma yaptei mete emare le mete wuso pinu pratei teingipe tuwopou le wem pe pa, ise yaptei pato era namplungu le era namplungu pelpe pepe ise ma yiripe yini piti ise ma onposiepe. ");
INSERT INTO ong_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Le ise yirpeiye, ‘Wuso ku minu mratei watafei eiya mani pouku pinu sungoi pepe, ku miso mosiepe mete emare pa watafei pe posiepe pa pepe kolo olo. Ku miso molpepe kolo olo.’ ");
INSERT INTO ong_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wolo wem ise yinape pe eiya mani, ise min so yirpei nomnaipe yire isotei yirpolo ise onom nenpeiyeye yire yaire manre peisi piti sungoi wuso pe posiepe mete emare pa pepe. ");
INSERT INTO ong_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","So ise wala ma yingiepe il olpe pite yaire manre peise wuso pe pinu papteise pato pepe le ise ma yingiepe ye yapuluye. ");
INSERT INTO ong_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ise eple pite tutungu. Ma Ili ma laiteise ye weli ili le ise miso yeinei nautowo moingi fei lepe yolomen? ");
INSERT INTO ong_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Le ki min so kirpeise, ki ma kaisipe mete emare le mete piti enke pire wuru le mete piti peptalo mete nemple, ki ma kaisipe paule ise. Ise ma yetesipe ilepe pa, ilepe ise ma yire singu tingelipe paitei nimpe le ilepe pelpe ise ma yire foiye yetesipe pifei angli pal peise, le ise yaptu pe uf lepe lepe peye. ");
INSERT INTO ong_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ise fei yolpepei, ise ma yila moingi yiripe mete teingipe tuwopou wuso ise yetesipe yeflipiye pa pepe. Moingi ma yila yire Abel, le metine teingi tuwopou, yila yau yau fale Barakaiya ninge lele Sekaraia wuso ise yetesi la lato nimin liti winem lite Ma Ili le tile piti peptawio Ma Ili siye. ");
INSERT INTO ong_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ki kirpeise punkom, mete piti wem fei lepei pe ma pila moingi piripe mete teingipe tuwopou wuso yaire manre pelpe petesipe pa pepe.” ");
INSERT INTO ong_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem, mete peiye pe petesipe mete emare pa le pe piripe era posiepe mete wuso Ma Ili laisipe pilape il pele paule ise pepe. Wem wuru ki onposi piti ma kaungipe mete peiye yeflipiye watafei woflu nimou naungipe eple pene pratei flingu tef pepe wolo mete peiye pe ma pusaiki kolpepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Le fei, uf leiye ma lato yawi. ");
INSERT INTO ong_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Fei le wem lingi lingi re lepe, ki kirpeiye, mete peiye ma nou puliki kolo oloye, pe pe ma fale wem liti pe ma pirpei polo, ‘Ma Ili lailolowo metine wuso laule lire nange lite Ma Ili.’ Pe ma pirpei wo, ki so kau.” ");
INSERT INTO ong_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas lusape le le wala so le tani winem lite Ma Ili lele, wem pupam pele pe pau falowo le pe kusawo pire winem ili lepe. ");
INSERT INTO ong_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jisas lirpepeye, “Iyo, yuluwo yoporoye. Ki kirpeise punkom, era ma poli nemple polpepe kolo olo, pe ma paututu re poungongo pire kumpu kumpu pratei tefye.” ");
INSERT INTO ong_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wem Jisas le lifei tef alo lupai linpei lifei liti nimpe oliv pile, pupam pele poteteiye pe pe falowo. Pe peleteiye, “Ye irpouku wem liti men soma winem lite Ma Ili lepe le ma loungongo re laututu lire kumpu kumpu lepe, le men ma fale piti ma kusauku lire wem piti ye ma nou au le il wuso mete pite tef pingiepe ma pelesesa. Wem lepe ma fale lolomen?” ");
INSERT INTO ong_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisas namti lirpepeye, “Ise ma kotopa isotei le ise ma yusape mete nemple pempeteise pato. ");
INSERT INTO ong_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wusoli mete wuru ma pau pirpei nomnaise pire nange leiki pirpeiye, ‘Ki Krais so lepei, Ma Ili laiteiki kau.’, le pe ma pempesipe mete wuru. ");
INSERT INTO ong_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ise ma yingitowo ipli liti mete plolpo uf tef malfem pireise le il pite mete plolpo uf tef nemple fiyen, wolo yingitei, ise ma enke olpe pato. Men nange fei pepe pe ma fale, wolo ki ma kau wala olo, le il wuso mete pite tef pingiepe ma pelesesa kolo olo, wala ma olo. ");
INSERT INTO ong_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mete pite uf tef nele ma plolpo piripe mete pite uf tef nele, mete pite alpe nele pe ma fale posiepe mete pite alpe nele. Oweli ma olotei, mete nimpi naplei kere pultetei le maiyene ma lini laptetei uf walem liye liye re le. ");
INSERT INTO ong_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Men nange fei pepei pe ma watafei flis piti pinu falene moto le ne ma nilape eple pepe.” ");
INSERT INTO ong_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Leye lo pe ma pengleise pilaise ye piti pe ma waise moingi le pe ma peteteise ya. Mete walem eryai pite tef lepei lepe pe ma enke olpe pireise wusoli ise yirpei nomnaipe yire nange leiki. ");
INSERT INTO ong_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wem fei lepe mete wuso pinu pulteiki pepe, wuru pelpe ma nou pulpope il peiki kolo oloye. Pe ma wai nemple moingi le pe ma enke olpe pire potei wane. ");
INSERT INTO ong_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Leye lo mete piti pemtetei pirpolo pe mete emare, pe ma fale pempesipe mete wuru. ");
INSERT INTO ong_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pe fei polpepei, il olpe ma rufro pe le mete ma onom kerowo Ma Ili kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wolo metine minele piti onposio Ma Ili le le lile singe le le fale wem moingi pepe pe kere, metine fei lepe Ma Ili ma kanowo. ");
INSERT INTO ong_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Le il teingipe piti wem Ma Ili ma luntoluwepe mete pite tef, il fei pepe ma yeptalo pe piri tef poparuye le mete ma pretape il fei pepe wo, soma il olpe wuso mete pite tef pingiepe pepe pe ma pelesesa oloye.” ");
INSERT INTO ong_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jisas nou lirpepeye “Ise ma yuluwo men olitei wuso metine nimou Daniel lirpei liri lepe, le ma lile winem lite Ma Ili leinginim. Metine piti lungunape il pepei, le miso retai il pal pato polomen. ");
INSERT INTO ong_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Leye lo mete wuso pratei Juda lepe, pe ma pantutu pe tef alo lupai linpei lifefei lepe peye. ");
INSERT INTO ong_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Metine wuso lifei winem tupe lele, le ma nou litipi le kapi oweli men nange pele piti winem lepe kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Metine wuso lile liom lele, le ma nou le winem kali olol lele piti lalfo lifei yuwei lepe, le ma le kali kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wem fei lepe ma olitei liti nimoure pire yefi le nimoure pire eple kumpu wala paplei nimer. ");
INSERT INTO ong_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yeletei Ma Ili yire wem piti ise ma yantutu ye pepe, wem fei lepe le ma nef is kolo olo, le le ma wem liti ise pos yifei uf peise onposio Ma Ili kolo olo, le ma wem yawi. ");
INSERT INTO ong_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Wusoli moingi liti wem fei lepe le ma olitei. Wem Ma Ili linu laltei tef le le lau lau fale fei, moingi wuso falele pepe pe olo kumpu le moingi piti ma fale wem lingi lepe le olo ma olitei. Moingi olitei fei lepe ma fale yo oloye, nele lolpepe re ma nou fale kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wolo Ma Ili laptei epli wem kuraupe le wuso le lolpepe kolo, minemple re miso nampir pratei kolo olo. Ma Ili laptei epli wem kuraupe piti moingi fei lepe ma fale wusoli le onposiepe mete pele wuso keiniepe pepe.” ");
INSERT INTO ong_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Leye lo wem metine nele ma lirpeise lolpepei, ‘Yuntoli, Krais min lepei,’ lo, ‘Le min liye.’ Ise ma yulpope il pele pato. ");
INSERT INTO ong_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wusoli mete piti pemtetei pirpolo pe Krais le pe pemtetei pirpolo pe mete emare, mete fei pepe ma fale. Pe ma pirpei le men nange ma potei pire tute fale piti ma pempesipe mete le mete wuso Ma Ili pele keiniepe pepe re wuso pe pualo, pe ma pualo. ");
INSERT INTO ong_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yingitei, wem lepe walo lato le ki kinu kirpeiseye.” ");
INSERT INTO ong_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Le wuso mete ma pirpeise polpepei, ‘Yuntoli, Krais lau ratei tef oli era re telmane ye yawi liye.’ Ise ma ye lepe pato. Le wuso pe pirpei polpepei, ‘Yuntoli, Krais kotire lifei lepei.’ Ise ma yulpope pato. ");
INSERT INTO ong_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wusoli Ninge lite Metine Wape, le ma lau watafei teplai nesi mil ninge teplai, nile epli fale le ne nau ne liti epli lautile.” ");
INSERT INTO ong_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tulum liti metine la lato, naflepem tuwalfo ma pau panfi. ");
INSERT INTO ong_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Wem moingi olitei liti wem fei lepe le kere, epli ma weitei lire munkunum, ane ma lini kolo olo, tauru ma pualo tani teplai yuwei le Ma Ili ma nenyeyipe men nange piti teplai yuwei le pe ma weitetei.” ");
INSERT INTO ong_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Leye lo men men ma fale laitei teplai yuwei piti ma kusaise Ninge lite Metine Wape ma lau. Mete pite alpe yeflipi pite tef lepei pe ma pouti le pe ma puluwo Ninge lite Metine Wape linge nopom lau lire singe lipi pele le ma lini watafei epli. ");
INSERT INTO ong_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Le le ma laisipe ririm pele pau putupa wengle pinape mete pite tef, mete pele wuso keiniepe pepe. Tonwipe pile tef um ilo pe paltu um ilo, le tef yuwei pe paltu tef minim le pe ma paule panfi.” ");
INSERT INTO ong_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ise yuluwo wengle le ise ma retai. Wengle ario lepe, lus pautu le upou ma falele ise miso retai le wem lire malfem piti epli ma loli. ");
INSERT INTO ong_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Min so lolpepe, wem ise yulwepe moingi men nange pepe ise miso retai wem lire malfemye. ");
INSERT INTO ong_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ise ma retai yolpepei, moingi men nange fei pepei ma pinu fale wo soma mete piti fei pratei pepei pepe pe ma pa pingi. ");
INSERT INTO ong_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tef re teplai ma pelesesa le il peiki ma pelesesa kolo, pe ma pile pingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Minemple re pretawo wem kolo olo. Ririm piti yuwei olo, le ninge re lironom, Yaitei loteteiye le retai. ");
INSERT INTO ong_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Wem liti Ninge lite Metine Wape ma lau, le ma watafei wem piti Noa. ");
INSERT INTO ong_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Min watafei epli wem pinu le so tipe ili fale walolo. Wem fei lepe mete paplei oweli tipeluwi re, mete nimoure paitenemple pe pe fale wem liti Noa linki nimpe teingo. ");
INSERT INTO ong_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wolo mete piti wem fei lepe pe pretai men re kolo, pironom pe pe yo tipe ili fale keraisipe, yeflipiye pa. Wem piti Ninge lite Metine Wape ma lau re le ma lolpepe. ");
INSERT INTO ong_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wem fei lepe, mete twinges ma tesio towa liti liom. Ririm pite Ma Ili ma kesi nele le nele ma pusa. ");
INSERT INTO ong_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nimoure wiem ma malwewe wit mile tulum liti palwewe wit. Ririm pite Ma Ili ma kesine nenpe le nenpe ma pusane nile. ");
INSERT INTO ong_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ise ma kotopa isotei wusoli wem piti Ili leise ma lau lepe ise olo retai kolo. ");
INSERT INTO ong_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ise ma retai yolpepei, wuso yaitei lite winem le retai wem piti metine oli piti lire ausi le ma lau, yaitei lite winem lepe le ma rapungo le le ma lusa metine oli lepe yaruwo winem lele kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Il pal fei pepei so ise re ma yoporo isotei wusoli Ninge lite Metine Wape ma lau wem wai yawi, wem ise yoporo isotei kolo, wem fei lolpepe le ma lau.” ");
INSERT INTO ong_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Metine minele wala lingiepe il pite ili lele, le le onom nire wuru? Metine fei lepe moli ili laltei luntoluwepe mete nemple piti pesio towa liti moli ili le wem piti le ma watepe oweli, le ma watepe. ");
INSERT INTO ong_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Metine fei lepe le ma onom teinginetei wem moli ili nou lau luluwo wala lingiepe il pele. ");
INSERT INTO ong_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ki kirpeise punkomtei, metine fei lepe moli ili ma laltei luntoluwepe oweli men nange pele. ");
INSERT INTO ong_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Le wuso metine fei lepe le metine oli, le ma lirpei lotei lolpepei, ‘moli ili wala ma lato wem ulel le soma nou lau.’ ");
INSERT INTO ong_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Le metine fei lepe le ma losiepe mete ilepe piti pepi pesio towa liti moli ili le le le liripe mete nemple pepi paplei oweli re tipe luwi, le pe pini purungo. ");
INSERT INTO ong_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Leye lo moli ili ma nou lau wem nele wem metine fei lepe le lironom. Metine fei lepe le lire wouye lire wem piti moli ili ma nou lau. ");
INSERT INTO ong_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Moli ili ma losio olitei kere lultetei metine fei lepe, le le ma laltei le lila moingi liripe mete olpe piti nel loli ilo ilo pepe. Metine fei lepe ma ratei tulum oli lepe loutiti re laplelei nilpe pele.” ");
INSERT INTO ong_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Wem fei lepe Ma Ili ma linape re luntoluwepe watafei nimoure raine nemple pire esi plen le plen. Pe kapi nongo weli pelpe so pilape pe piti ma perengawo metine piti ma laisene moto. ");
INSERT INTO ong_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nimoure raine piti eti plen pepe pe fupepletei, le piti pire eti nemple plen pepe pe enke pire wuru. ");
INSERT INTO ong_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nimoure wuso fupepletei pepe pe kapi nongo weli elpesipe wuso weli loli pepeye, le nemple yeflipi olo pe kapi kolo. ");
INSERT INTO ong_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Le nimoure wuso enke pelpe pire wuru pepe pe kapi nongo nemple yeflipi pelpe pilape pe. ");
INSERT INTO ong_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Fei metine piti ma laisene moto nepe, le wala lato, le nimoure raine pepe, pe yepe paplei le pe peteiye.” ");
INSERT INTO ong_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Mulpou niminye wem mete pailo pirpei polpepei, ‘Metine piti ma laisene moto nepe min lepei, yaule yenglowo esi.’ ");
INSERT INTO ong_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Fei nimoure raine pire esi plen le plen pepe, pe peifale pepletetei nongo weli pelpe. ");
INSERT INTO ong_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Leye lo nimoure wuso fupepletei pepe, pe pepletei piti enke pire wuru pepe pepleteiye, ‘Ise wauku nongo ilepe peise, ku nongo olo le weli ma paye.’ ");
INSERT INTO ong_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Wolo nimoure piti enke pire wuru pepe pe namti pirpepe piti fupepletei pepeye, ‘Olo ku nongo olo yaipiyeye. Ise ma ye yintape nemple peise.’ ");
INSERT INTO ong_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Liso nimoure raine wuso fupepletei pepe pe pe pinta nongo nemple. Le wem pe wala pinta nongo pato, metine piti ma laisene moto nepe, le lau fale. Nimoure raine pire esi plen wuso pe poporo potei pepe, pe piri pepi pinki pe winem peye, le pe kete wingi pamsi.” ");
INSERT INTO ong_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Nimoure wuso pe pinta nongo pato pepe, pe pau fale le pe pirpeiye, ‘Ili louku, ye kapunuku winki.’ ");
INSERT INTO ong_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Wolo metine piti ma laisene moto nepe, le lirpepeye, ‘Ki olo kireise onomtei’.” ");
INSERT INTO ong_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Le Jisas lirpei il lapulu lolpepei “Ise ma kotopa isotei. Ise retai wem fei lepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Le ma watafei metine nele le ma lusa uf lele le le ma laulo le uf mete nemple. Le linape mete pele piti pesio towa lele le le laptei puntoluwepe oweli men nange pele. ");
INSERT INTO ong_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Le karipe oweli watepe mete pele piti pesio towa lele pepe, watepe piripe singe pelpe fi fi. Watowo metine nele faiv tausen kina (K5,000), nele tu tausen kina (K2,000) le nele le watowo wan tausen kina (K1,000). Leye lo metine lepe le laulo leye. ");
INSERT INTO ong_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Fei metine wuso kapi faiv tausen kina pepe, le le liripe lesio towa le le nou kapi faiv tausen kina nemple laptei lapwonou piti pinu pepe. ");
INSERT INTO ong_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Le nele wuso kapi tu tausen kina pepe re, le lolpepe. Le liripe lesio towa le le so nou kapi tu tausen kina nemple, yeflipi. ");
INSERT INTO ong_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wolo nele wuso kapi wan tausen kina pepe, le le lalwe oi le le laplingi era piti metine ili pele pepe, le laplingi prateiye.” ");
INSERT INTO ong_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Wem ulel re fei metine ili lotei wuso laulo le lato lepe, le nou lau, le mete pele piti pesio towa lele pepe pe pau nampli pirpowo pire era pele wuso le watepe pepe, le pe piripe pesio towa men. ");
INSERT INTO ong_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Metine wuso kapi faiv tausen kina pepe le linki le watowo metine ili lepe faiv tausen kina nemple yeflipi pepe. Le le lirpowo metine ili lele lepe lirpeiye, ‘Ili leiki, untoli, faiv tausen kina nemple yeflipi wuso ki kesio towa le ki kapi pepe min pepei.’ ");
INSERT INTO ong_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Metine ili lepe le namti lirpowoye, ‘Teingipe, ye metine teingi le ye onposiki. Ye onposi le ye telpalo untoluwepe menemple kumpu le ki ma keiteiye untoluwepe menemple lipi. Inki aule le ye ireiki rautu noute.’ ");
INSERT INTO ong_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Leye lo metine wuso kapi tu tausen kina pepe, le linki le, le le lirpeiye, ‘Ili leiki untoli, ye waiki tu tausen kina le ki kesio towa le ki nou kapi tu tausen kina nemple yeflipi min pepei.’ ");
INSERT INTO ong_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Metine ili lele lepe lirpowoye, ‘Teingipe, ye metine teingi le ye onposiki. Ye onposi le ye untoluwepe menemple kumpu le ki ma keiteiye untoluwepe menemple lipi. Inki au ireiki rautu noute.’ ");
INSERT INTO ong_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Leye lo metine wuso kapi wan tausen kina pepe le linki le lirpeiye, ‘Ili leiki, ki kretai, ye metine oli, onom kuraune. Ye kotuwepe oweli piti mete nemple pelpe papiri, le ye kapi oweli piti mete nemple pelpe paptei. ");
INSERT INTO ong_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ki turiki, ki so ke kaplingi era peiye pratei tef. Ulwepe era peiye pepe min pepei.’ ");
INSERT INTO ong_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Fei metine ili lele lepe lirpowoye, ‘Ye metine oli kerin. Ye retai ko? Ki kotuwepe oweli piti mete nemple pelpe papiri le ki kapi oweli piti mete nemple pelpe paptei. ");
INSERT INTO ong_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Fei polpepe re ye ma aptei era peiki pe benk le wem ki kau fei kolpepei ki miso nou kapi era peiki kutei, le benk ma waiki nemple yeflipi kaptei kapwonou peiki kutei pepe. ");
INSERT INTO ong_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Le fei era pepe ma ki kapi taniye le ki ma watowo metine wuso lesiepe ten tausen kina pepe. ");
INSERT INTO ong_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wusoli metine minele piti lesiepe men kumpu, Ma Ili ma nou watowo nemple lipi laptei lapwonou le le ma lesiepe men nange wurutei. Le metine minele piti olotei lepe men kumputei pele re Ma Ili ma kapi tanio. ");
INSERT INTO ong_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Le metine oli kowine yawi lepe, ise yiri le uf oli munkunum le le ma loutiti re laplelei nilpe pele’.” ");
INSERT INTO ong_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Wem Ninge lite Metine Wape laule watafei metine ili piti luntoluwepe mete, le ririm pele re pepi pau, le ma lifei tulum piti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Le mete piti tef ma panfinemple pile onom pele. Leye lo le ma karipe laptei pe tulum twinges min watafei metine piti luntoluwepe sipsip, le karipe laptei pe taniepe meme pepe. ");
INSERT INTO ong_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Le ma laptei sipsip pau pe eti tilpi lele, le le laptei meme pe eti enkau lele.” ");
INSERT INTO ong_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Leye lo metine ili piti luntoluwepe mete pepe, le ma lirpepe mete wuso pile eti tilpi lele pepe lirpeiye, ‘Ise eiya leiki le laileleise, yaule kali uf teingi wuso Ma Ili lalteise lepe, wem le wala laltei tef re teplai kolo olo, le linu lalteise uf teingi fei lepei. ");
INSERT INTO ong_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ki nimpi neiyeiki le ise waiki oweli kaplei, ki yif punko le ise waiki tipe kalei. Ki kau wata pirpolo ki liti mete nemple le ise keteiki yilaiki ye winangou peise, ");
INSERT INTO ong_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ki pau yawi le ise waiki olongou kafo, ki kainu le ise yuntoliki, ki kifei winem oli le ise ye yuliki.’ ");
INSERT INTO ong_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Le mete piti teingipe tuwopou pepe pe ma namti pirpowoye, ‘Ili louku, wem piti men ku muliye nimpi neiyei le ku waiye oweli aplei lo ye yif punko le ku waiye tipe alei lepe? ");
INSERT INTO ong_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wem piti men ku muliye wata pirpolo ye liti mete nemple le ku keteiye milaiye me winangou pouku lo ye pau yawi le ku waiye olongou afo pepe? ");
INSERT INTO ong_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Wem piti men ku muliye kainu lo ye ifei winem oli le ku me muliye?’ ");
INSERT INTO ong_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Le metine ili lepe le ma namti lirpepeye, ‘Ki kirpeise punkom, wem ise yolpepe yire ilim winkem peiki pepei, pe mete yaupe wolo ise yailelepe watafei ise yaileleiki ki’.” ");
INSERT INTO ong_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Leye lo le ma lirpepe piti pile eti enkau pepe lirpeiye, ‘Ye taniki, ise piti Ma Ili ma waise moingi. Ise ye weli ili piti loli wem oli oli wuso Ma Ili laltei liti towa lire ririm pele. ");
INSERT INTO ong_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ki nimpi neiyeiki wolo ise waiki oweli kolo. Ki yif punko wolo ise waiki tipe kalei kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ki liti mete nemple wolo ise keteiki yilaiki ye winangou peise kolo, ki pau yawi wolo ise waiki olongou kafo kolo. Ki kainu wolo ise yuntoliki kolo, le ki kifei winem oli wolo ise ye yuliki kolo olo.’ ");
INSERT INTO ong_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Leye lo pe namti pirpowoye, ‘Ili louku, wem piti men ku muliye nimpi neiyei, lo yif punko, lo ye liti mete nemple, lo ye pau yawi, lo kainu, lo ye ifei winem oli, le ku kaneiye kolo olo lepe?’ ");
INSERT INTO ong_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Le metine ili lepe le ma namti lirpepeye, ‘Ki kirpeise punkom, wem ise yinaulo piti ma kaniepe mete yaupe fei pepei, ise yinaulo piti ma kaneiki ki.’ ");
INSERT INTO ong_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mete fei polpepei, Ma Ili ma laisipe pe piti ma pila moingi wem oli oli, le mete piti teingipe tuwopou pepe pe pe uf teingi liti pratei pingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wem Jisas leptalo lire il fei pepe re fei, le lirpepe pupam pele lolpepei, ");
INSERT INTO ong_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ise retai epli twinges wala tato wem mete piti Juda ma papli oweli lipi piti onposio wem Ma Ili kesipe manre yaire pelpe pe tani Isip. Le wem fei lepe pe ma kesi Ninge lite Metine Wape paltepe moli lipi piti Rom le pe ma pire singu tingeli laitei nimpe.” ");
INSERT INTO ong_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Leye lo mete piti pinuwepe mete piti peptawio Ma Ili siye le mete piti pinuwepe mete piti Juda, pe pau panfi nemple pifei winem ili lite Kaiafas. Le metine ili piti linuwepe mete piti peptawio siye paptowo Ma Ili. Pe pau pifei winem lele. ");
INSERT INTO ong_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Le pe pinta tisi piti ma penglei Jisas kotire le pe ma petesi la. ");
INSERT INTO ong_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pe pirpeiye, “Wem piti ku maplei oweli lipi pepe ku ma menglei pato waipiti mete ma kamio il le pe plolpo.” ");
INSERT INTO ong_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Wem Jisas wala lifei winem lite Saimon le metine pape poluwo le le ratei Betani. Jisas lifei winem lite Saimon lepe ");
INSERT INTO ong_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","wem moto nenpe ne nau falowo. Ne nila mili olo kumpu, lire tipe wopu teingitei liti pire yini le pe ma pire era lipitei paise tipe wopu fei lepe. Ne kalulu tipe wopu lepe neltali falo liti Jisas wem le wala laplei oweli. ");
INSERT INTO ong_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pupam pele pulwene ne fei nolpepei, pe enke kotu le pe peneteiye, “Piti men ye kalulu tipe wopu lepei yawi? ");
INSERT INTO ong_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tipe wopu lepei ye ma altepe mete paise le ye ma kapi era lipitei le era fei pepe ma ye weisipe watepe mete wuso pe oweli yini re olotei pepe.” ");
INSERT INTO ong_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas retai il men pupam pele pirpei pepe le le lirpepeye, “Piti men ise il karine moto nepei? Ne fei nolpepei nireiki nepe, pepe olo teingipetei poporo. ");
INSERT INTO ong_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mete piti oweli yini olotei pepe pe miso pireise ratei wem oli oli wolo ki miso kireise mepi ratei wem oli oli kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ne kalulu tipe wopu neltaleiki lepei lepe, ne rautuki, le ne nopori topo tale leiki piti ma peiteiki. ");
INSERT INTO ong_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Fei ise ma onposiepe il pepei, tef ili yefliye, yeptalo il pite Ma Ili linei linei ye, ise ma onposi men wuso ne fei nolpepe nireiki lepei le ise ma nampli yirpepe yirine ne.” ");
INSERT INTO ong_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Leye lo pupam pite Jisas pele wuso pire esi plen le plen te twinges pepe, niliyeye lelpe nange lele Judas lite Iskariot, le le falepe mete piti pinuwepe mete piti peptawio Ma Ili siye. ");
INSERT INTO ong_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Le le lepletei lolpepei, “Ise ma waiki menele wuso ki ma kaltei Jisas lau esi peise?” Pe koponape era fale watafei 30 kina, le pe watowo Judas. ");
INSERT INTO ong_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Wem fei lepe le le le Judas lutepe patotowo Jisas piti ma laltei le esi pelpe. ");
INSERT INTO ong_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Epli wem pire eti plen te twinges mete pite Juda ma papli oweli lipi piti ma onposiepe wem wuso Ma Ili kesipe manre yaire pelpe pe tani Isip le pe pali luom yawi, pire yis weisi kolo olo, epli piti linu fei lepe Jisas pupam pele pau falowo le pe peleteiye, “Oweli piti onposio wem piti Ma Ili kesipe manre yaire pouku pau tani Isip pepe, oweli fei pepe ma mapliye lope mifei fei linei?” ");
INSERT INTO ong_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Fei Jisas lirpepeye, “Ise metine nele ratei uf ili lepe le ise ma yirpowo yolpepei ‘Metine piti leitalouku le lirpei lolpepei, wem lele olo fei lau lire malfemye le le ma lirouku mifei winem leiye mapli oweli lipi piti onposio wem wuso Ma Ili kesipe manre yaire pouku pau tani Isip pepe. Ku ma mapli re maplei oweli lipi fei pepe mifei winem leiye’.” ");
INSERT INTO ong_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Liso pupam pele pepe pe pingiepe il pite Jisas le pe papli oweli lipi pepe. ");
INSERT INTO ong_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ninglitei so Jisas liripe pupam pele pepi pifei paplei. ");
INSERT INTO ong_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wem pe wala paplei Jisas lirpepeye, “Ki kirpeise, nele leise ma leiteiki ke esi piti mete olpe.” ");
INSERT INTO ong_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Fei pupam pele pe enke olpetei le pe niliyeye niliyeye pulte nemple so peletetei polpepei, “Ili leiki, ye irpei punkom ireiki ki lom?” ");
INSERT INTO ong_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisas namti lirpepeye, “Minele piti lireiki wepi walfo luom leingalo waifile lepe soma leiteiki ke esi piti mete olpe pepe. ");
INSERT INTO ong_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Il paitei yousi pe pirpei piti Ninge lite Metine Wape ma la wolo metine minele wuso laltei Ninge lite Metine Wape le esi piti mete olpe pepe, metine fei lepe le ma lila moingi ili oli. Metine fei lepe wuso nimou nila kolo oloye, le miso lila moingi fei lepei kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Fei Judas, le metine piti ma laltei Jisas le esi piti mete olpe pepe, le lirpeiye, “Ye metine piti eitalouku, ye irpei punkom ireiki ki lom?” le leletei Jisas. Le Jisas namti lirpowoye, “Iyo, ki kirpei kireye ye.” ");
INSERT INTO ong_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pe wala paplei le Jisas kali luom le le leletei Ma Ili liri re fei, le so kareri watepe pupam pele. Le lirpepeye, “Kali le ise yalei. Lepei le topo tale leiki.” ");
INSERT INTO ong_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Leye lo le kali wengle lire wain tipe le le leletei Ma Ili liri re fei le so watepe pupam pele. Le lirpepeye, “Ise yeflipiye yalei. ");
INSERT INTO ong_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Lepei teluwi leiki piti ma topwepe il pite Ma Ili liripe mete piti tef. Teluwi leiki lungwise mete wuru piti tef piti ma kaptetei il olpe peise. ");
INSERT INTO ong_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ki kirpeise, ki ma nou kalei wain tipe fei lepei kolo olo, kato ke ke ma wem piti Ma Ili ma luntoluwepe mete piti tef, wem fei lepe soma ki kireise mepi malei wain tipe nele yefli, malei mratei uf teingi lite Eiya leiki.” ");
INSERT INTO ong_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Leye lo Jisas lire pupam pele puro weni piti Ma Ili le pe naro pe tef alo lupai linpei lifei piti nimpe oliv pile. ");
INSERT INTO ong_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Leye lo Jisas lirpepeye, “Mulpou fei lepei ise yeflipiye ma yuru ye tani le ise yusaiki wusoli il pite paitei yousi pe pirpei polpepei, ‘Ma Ili ma letesi metine piti luntoluwepe sipsip le sipsip ma kere pire fla.’ ");
INSERT INTO ong_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wolo ki ma nou keilo re fei, ki ma kinuse ke Galili.” ");
INSERT INTO ong_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita namti lirpowo Jisas lolpepei, “Ki miso kusaiye kolo olotei. Pupam wuru pepe miso pusaiye le ki ma kusaiye kolo.” ");
INSERT INTO ong_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Fei Jisas lirpowo Pita lolpepei, “Ye ma onposiepe il pepei, fei mulpou wem woflu wala ma koro kolo olo, ye ma inu irpei wem twinges niliyeye irpolo ye ireiki onom.” ");
INSERT INTO ong_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Wolo Pita nou lirpowoye, “Ki miso kirpei kirpolo ki kireye onom kolo olo, le wuso ki ma kireye rounge wa, ki miso rounge wa. Le pupam wuru pepe pe pirpei il nempleiyeye pepe. ");
INSERT INTO ong_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Leye lo Jisas liripe pupam pele pepi pe tulum pinawo Getsemani, le Jisas lirpepe pupam pele lolpepei, “Ratei lepei le ki ma ke liye keletei Ma Ili wo.” ");
INSERT INTO ong_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Le kesi Pita le eple winge titi Sebedi, le kesipe pepi pe. Jisas onom one le le onom moingine. ");
INSERT INTO ong_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Le le lirpepe Pita lire eple winge titi Sebedi tepe lirpepeye, “Ki onom onetei le ki ma ka kasiene. Ratei lepei le ise yireiki mepi meletei Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jisas le fiyen taise le le luwalo ratei mi noli tef le le leletei Ma Ili lolpepei, “Eiya leiki, wuso ye miso kaneiki, ye ma kali moingi fei lepei taniki. Wolo ye ma ingiepe il peiki kolo, ye ma ingiepe il ye onom peiye yotei.” ");
INSERT INTO ong_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Leye lo le nou karepe Pita lire Jems re Jon lau wolo le lulwepe peteiye le le lirpowo Pita lolpepei, “Polomen so ise twinges niliyeye pepei ma yireiki mepi meletei Ma Ili wem kurau re kolo olo lepe? ");
INSERT INTO ong_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Rapungo le ise yeletei Ma Ili soma ise yuwalo tisi oli kolo olo. Riri leilaise enke wolo topo tale peise olo toulipi.” ");
INSERT INTO ong_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jisas nou le taniepe le le leletei Ma Ili lolpepei, “Eiya leiki, wuso moingi fei lepei ki ma kila le ye miso kali taniki kolo, il peiye ma ki kingiepe.” ");
INSERT INTO ong_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Le nou karepe lau le le lulwepe pupam pele pe nou petei. Pe olo rapungo kolo. ");
INSERT INTO ong_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jisas nou lusape le le le taniepe. Le nou leletei Ma Ili le le leletei lire il nempleiyeye wuso linu lirpei pepe. Wem twinges niliyeye Jisas le leletei Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Leye lo le nou karepe pupam pele lau le le lirpepeye, “Ise wala yetei yaltei yef lom? Yuntoli, wem fei lau lire malfemye piti Ninge lite Metine Wape ma paltei le esi piti mete olpe. ");
INSERT INTO ong_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yeilo le ku me. Yuntoli, metine piti leiteiki ke esi piti mete olpe pepe, le min liplau.” ");
INSERT INTO ong_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas wala lirpepei wem Judas, le pupam nele piti lire esi plen le plen te twinges, le le falowo Jisas lire Pita, Jems re winke Jon. Judas liripe mete wurutei wuso mete piti pinuwepe peptawio Ma Ili siye le mete piti Juda, pe paisipe pire Judas pepi pe pepe. Pe pilape werau re nimpe teingelem piti plolpo. ");
INSERT INTO ong_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas linu lirpepe mete wurutei wuso piri pepi pe pepe, lirpepe lolpepei, “Metine wuso ki kenesi mi, metine fei lepe so ise ma yenglei.” ");
INSERT INTO ong_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Wem Judas le fale le karowo Jisas le, le le lirpowoye, “Ye metine piti eptalo mete, onom malye.” Le Judas lenesi Jisas mi. ");
INSERT INTO ong_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisas namti lirpowo Judas lolpepei, “Numu leiki, ire frou olpepe men wuso ye onom puwowo ye so au lepe.” Leye lo mete wurutei pepe fale pe pesio Jisas pari le pe penglei. ");
INSERT INTO ong_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Fei pupam nele piti lire Jisas pepi pile pepe, le kesi werau lele liri lalowi mingi lite metine piti lesio towa, towa lite metine ili piti linuwepe peptawio Ma Ili siye. Le lalowi mingi kereye. ");
INSERT INTO ong_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Leye lo Jisas lirpowo pupam lele lepe lirpeiye, “Nou alfo werau le tulum lele wusoli mete wuru wuso piripe werau plolpo pe ma pa piripe werau. ");
INSERT INTO ong_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ye retai lo olo? Ki miso kinawo Eiya leiki piti ma kaneiki le le ma frou laisipe ririm wurutetei piti plolpo, pe ma puwalo nemple pau kaneiki. ");
INSERT INTO ong_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wolo fei polpepe, il wuso paitei yousi pepe ma fale punkom polomen? Il wuso pirpei piti fei pepei pepe ma fale soma il pite paitei yousi pepe ma fale punkomye. ");
INSERT INTO ong_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Leye lo Jisas lirpepe mete wurutei pepe lirpeiye, “Ise yilape werau re nimpe teingelem. Yau piti ma yengleiki wata pirpolo ki metine liti kapwe il yaruwepe lom? Epli wem oli wuso lepe ki kifei winem lite Ma Ili keptalo mete le ise yengleiki kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wolo fei pepei fale piti ma paptei il wuso mete emare paptei paitei yousi pepe pe ma fale punkom.” Leye lo pupam yeflipiye pusa Jisas le pe pantu tanioye. ");
INSERT INTO ong_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mete wuso penglei Jisas pepe pe kesi pila pe fale winem lite Kaiafas, le metine ili piti linuwepe mete piti peptawio siye piti Ma Ili. Le mete piti peptalo mete pire il lipi pite Moses le mete lipi piti Juda, pe pau panfi nemple pifei winem lite Kaiafas. ");
INSERT INTO ong_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita lulsesi Jisas lingingi wolo le le liri malfem kolo, le luwalolo fiyen taise, le so lus ye patotowo Jisas piti pe kesi pila pinunu pe. Pita lulsi le fale uf teingo lite winem ili lite Kaiafas. Le liripe yali pal piti winem lite Ma Ili, le liripe pepi pifei uf teingo yawi lepe piti ma lulwepe pe polomen piri Jisas. ");
INSERT INTO ong_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Fei mete lipi piti pinuwepe mete piti peptawio Ma Ili siye, le mete wuru piti pifei pingitepe re kapi paptei pire moingi piti mete piti Juda, mete fei pepei pinta tisi piti ma pemtetei pamtuwo Jisas yawi le pe ma paltei la. ");
INSERT INTO ong_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wolo pe perengape il men piti pe ma pirpei pamtuwo yawi kolo olo, le mete wuru fale pe pemtetei pirpei pamtutuwo wolo olo. Pe pirpei re fei, mete twinges namti fale te, ");
INSERT INTO ong_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","le te tirpei tolpepei, “Metine fei lepei le lirpei lolpepei, ‘Ki miso kaltutu winem lite Ma Ili le epli wem twinges niliyeye ki ma nou keila’.” ");
INSERT INTO ong_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Fei metine ili piti linuwepe mete piti peptawi siye paptowo Ma Ili, le leilo lile le le lirpowo Jisas lolpepei, “Il men ma ye nou irpei ire il wuso mete tepei te tirpei tamtuye lepe lo olo?” ");
INSERT INTO ong_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wolo Jisas pos lile. Fei metine ili piti linuwepe mete piti peptawi siye pepe le nou lirpowo Jisas lolpepei, “Ki fei kire nange lite Ma Ili piti ratei lingi wem wem ki kapi il kaptei kireye, Ye irpouku wuso ye Krais, ninge lite Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisas namti lirpowo lolpepei, ‘Ye min irpei lepe. Wolo ki kirpeise ise wuruye, wem fei lepei le le le ise ma yuluwo Ninge lite Metine Wape lifei eti tilpi lite Ma Ili singetei, le le ma linge nopom lau teplai yuwei.” ");
INSERT INTO ong_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Wem Kaiafas lingitepe il fei pepei, le lesi karipe olongou pele le le lirpeiye, “Le lirpei kelelawo Ma Ili. Ku ma nou mingitepe il nemple piti pirpei poluwo kolo olo, fei ise min yingitowo lile lepei lirpei il olpe pepe. ");
INSERT INTO ong_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ise onposi men?” Le mete wuru pepe pe namti pirpowo Kaiafas polpepei, “Le ma la lire il olpe pele.” ");
INSERT INTO ong_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Leye lo pe paruwo tunku mati lele le pe yaruwepe esi palwe. Le ilepe wuso papowo lope pepe ");
INSERT INTO ong_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","pe pirpeiye, “Krais, wuso ye metine nimou, ye ma irpouku, minele leteteiye.” ");
INSERT INTO ong_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Fei Pita olo lifei uf teingo towa yawi lepe wem moto nenpe piti nesio towa lite Kaiafas ne nau falowo Pita le ne nirpeiye, “Ye re ye piti ire Jisas lite Galili.” ");
INSERT INTO ong_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wolo mete wuru pepe pe pifei le Pita lirine yef lirpeiye, “Ki kironom kire il men wuso ye irpei pepe.” Pita namti lirpene moto nepe. ");
INSERT INTO ong_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Le Pita naro le towa yawi leye. Moto nenpe piti nesio towa lite Kaiafas lepe, ne re nuluwo Pita le ne nirpepe mete wuso pile pepe nirpeiye, “Ki kuluwo lire Jisas lite Nasaret.” ");
INSERT INTO ong_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita nou lirine yef le le namti lirpeneye, “Ki keisi nange lite Ma Ili, metine fei lepe ki kirowo onom.” ");
INSERT INTO ong_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wem ulel re fei mete wuso pile pepe pe karowo Pita pau le pe pirpeiye, “Punkomtei, ye nele lelpe. Il re wai leiye piti irpei, ku mretaiye alepe nimin.” ");
INSERT INTO ong_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Leye lo Pita leisi nange lite Ma Ili lirpeiye, Ma Ili waiki moingi wuso ki kirpei punkom kolo olo. Ki kretawo metine fei lepe kolo olo.” Fei woflu koroye, ");
INSERT INTO ong_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","le Pita onposi men wuso Jisas linu lirpowo lepe. Jisas linu lirpowo Pita lolpepei, “Woflu wala ma koro kolo le wem twinges niliyeye ye ma ire yef irpolo ye ireiki onom.” Pita naro le yawi le le louti olitei. ");
INSERT INTO ong_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nolowi mul ili mete piti pinuwepe mete piti peptawio Ma Ili siye, pe yeflipiye le mete lipi piti pinuwepe mete piti Juda, pe pepi pinta tisi piti ma paltei Jisas la. ");
INSERT INTO ong_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pe pire foiye kimplipitei pire topuwo Jisas le pe kesi pila pe fale paltowo Pailat. Le metine ili lite Rom laule piti ma luntoluwepe mete pite Juda, le le lesio towa liti moli lipi piti Rom. ");
INSERT INTO ong_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Wem Judas, le wuso laltei Jisas le esi piti mete olpe fei pepe, le luluwo Jisas wuso pe ma paltei la, Judas nou onposi le le onom manowo Jisas. Le nou kapi era watafei 30 kina pepe nou lilape le watepe mete piti pinuwepe mete piti peptawio Ma Ili siye pire mete lipi piti Juda. ");
INSERT INTO ong_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas lirpeiye, “Ki kingiepe il olpe le ki kaltei metine teingi le esi piti mete olpe piti le ma la.” Le pe namti pirpowo Judas polpepei, “Ku ma molomen? Fei pepe ma ye peiye yotei.” ");
INSERT INTO ong_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Fei Judas liripe era pe winem lite Ma Ili leinginim, le le le taniepe mete pepe. Leye lo Judas le kumkeri lotei lultei laye. ");
INSERT INTO ong_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mete piti pinuwepe mete piti peptawio Ma Ili siye, pe kapi era pepe le pe pirpeiye, “Era fei pepei olo piti mire maite teluwi le il lipi pouku pirpei polo era olpe fei polpepe ku ma mafo pratei mole ufau lite winem lite Ma Ili kolo, olo.” ");
INSERT INTO ong_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pe yaruwepe il pafo re fei, pe piripe era fei pepe paise tef lite metine piti lire tef lesiepe minki re men nange pepe. Pe paise tef fei lepe liti ma paptei towa piti mete alpe nemple le Juda potei ma olo. ");
INSERT INTO ong_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Min fei polpepei so pe pinawo tef fei lepe pirpolo “Tef liti Teluwi” le fei re pe wala pinawo nange fei lepe. ");
INSERT INTO ong_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Leye lo il wuso metine nimou Jeremaia sungoi lirpei pepe, pe fale punkom. Le lirpei lolpepei, “Pe kapi era watafei 30 kina wuso mete piti Israel pe pirpei piti pe ma paise piri lepe, ");
INSERT INTO ong_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","le pe piripe paise tef liti metine piti lire tef lesiepe minki re men nange pepe wusoli Ma Ili lirpei fei.” ");
INSERT INTO ong_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas lile kani onom lantowo Pailat, le metine ili piti luntoluwepe mete le le leletei Jisas-ye, “Ye metine ili piti untoluwepe mete piti Juda lom?” Le Jisas namti lirpowoye, “Iyo il min ye irpei pepe.” ");
INSERT INTO ong_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Le il wuso mete lipi piti pinuwepe mete piti peptawio Ma Ili siye le mete piti pinuwepe piti Juda, il pelpe wuso pirpei pamtutuwo Jisas pepe wolo olo, Jisas nou lirpepe lire il men re kolo olo. ");
INSERT INTO ong_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Liso Pailat lirpowo Jisas lolpepei, “Ye ingitepe il men wuso pe pirpei pamtutuye pepei lo olo?” ");
INSERT INTO ong_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wolo Jisas linaulo piti ma nou lirpowo lire il men, liso Pailat wala linlele lotei. ");
INSERT INTO ong_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Eringi nempleiyeye nempleiyeye wem mete piti Juda papli oweli lipi piti onposio wem wuso Ma Ili kesipe manre yaire pelpe pe tani Isip, wem fei lepe, metine ili lelpe piti luntoluwepe pepe le ma kesi metine nele wuso lifei winem oli lepe le ma laltei naro le yawi. Metine ili lepe le ma lingiepe il wuso mete wuru pepe pe pirpei peisi nange lite metine minele wuso lifei winem oli lepe soma le lirpepe kesi metine fei lepe paltei naro le yawi leye. ");
INSERT INTO ong_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wem fei lepe metine nele lifei winem oli. Le nange lele Jisas Barabas, le metine olitei le mete wuru pretawo. ");
INSERT INTO ong_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Liso wem mete wurutei pepe pe pau panfi nemple, Pailat lepleteiye, “Minele ma ki kesi kaltei le yawi? Jisas Barabas lo Jisas wuso pe pinawo Krais lepe?” ");
INSERT INTO ong_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailet retai loporotei wuso pe pila Jisas pe paltowo lepe wusoli pe enke olpe piri Jisas. Pe enke olpe piri wusoli le nange lele olo fale ili. ");
INSERT INTO ong_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wem Pailat wala lifei tulum piti lingitepe le le kapi laptei lire moingi piti mete, le wala lifei tulum lepe wem moto pele naptei il nirpowo nolpepei, “Ye ma olomen ire metine fei lepe kolo, le metine teingi wusoli nemul mulpou ki ketei yongou le ki kulu kutei kila moingi ili kiri.” ");
INSERT INTO ong_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Fei mete lipi piti pinuwepe mete piti peptawio Ma Ili siye le mete piti pinuwepe mete piti Juda, pe pirepe kilau mete wuru pepe piti pe ma peletei Pailat piti ma kesi Barabas laltei le yawi le le ma laltei Jisas la. ");
INSERT INTO ong_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wolo Pailat lepletei lolpepei, “Ise yirpei ma ki kaltei minele le yawi?” Le pe namti pirpowoye, “Barabas.” ");
INSERT INTO ong_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Le ki ma kolomen kire Jisas wuso pinawo pirpolo Krais lepe?” Pailat lepletei. Le pe yeflipiye namti pirpowo polpepei, “Ire singu tingeli laitei nimpe.” ");
INSERT INTO ong_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Wolo Pailat lepleteiye, “Le lingiepe il men olpe?” Leye lo pe pirkilau pailolo pirpeiye, “Tingeli laitei nimpe.” ");
INSERT INTO ong_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Wem Pailat luntoli wuso le miso weisipe enke pelpe kolo olo, le pe ma waipiti plolpo, le kali tipe kaptetei esi pele alepe nimin piti mete wuru pepe ma puluwo le le lirpepeye, “Metine fei lepei lepe ki kaltei la kolo olo. Ise isotei yaltei la.” ");
INSERT INTO ong_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Le mete wurutei pepe pe nou pirpowo Pailat polpepei, “Moingi piti le la lepe ye ma usauku ku mire eple pouku mila.” ");
INSERT INTO ong_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Leye lo Pailat kesi Barabas laltei naro le yawi le le lirpepe petesi Jisas le le laltei le esi pelpe piti pe ma tingeli laitei nimpe. ");
INSERT INTO ong_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Leye lo Pailat mete pele piti plolpo, pe kesi Jisas pila pinki pe winem ili, le pe leinginim le pe wuruye pau pile neinowo. ");
INSERT INTO ong_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pe nomplei olongou pele tanio le pe palfowo olol nele teingitei yalei. ");
INSERT INTO ong_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Leye lo pe yaruwepe foiye singu ponwipe pire wi le pe reptapowo pifei falo lite Jisas le pe watowo nimpe lesio lire eti tilpi lele. Pe polpepe piri piti ma kelelawo pirpolo le metine ili. Leye lo pe yaru yamkelem pratowo onom le pe palwe oli piri. Pe pirpei polpepei “Metine ili piti untoluwepe mete piti Juda, ye ma ratei wem ulel.” ");
INSERT INTO ong_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pe paruwo tunku le pe kali nimpe wuso lesio lepe pe piri petesi falo lele. ");
INSERT INTO ong_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wem pe palwe oli piri Jisas re fei, pe nou kotuwo olol teingi yalei wuso palfowo lepe le pe nou palfowo olongou pele lotei. Leye lo pe kesi pila pe towa yawi piti ma pire singu tingeli laitei nimpe. ");
INSERT INTO ong_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wem pe wala naro uf pe, pe perengawo metine nele nange lele Saimon. Le lite Sairini. Le pe yeftuwo kali nimpe lite Jisas. ");
INSERT INTO ong_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pe pe fale tulum pinawo Golgota, il pal piti nange fei lepe pirpei polo, ‘Tulum lite oru weingampi.’ ");
INSERT INTO ong_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tulum fei lepe pe watowo Jisas wain tipe piti ma lalei wolo pe pire menele le pire palupu wain tipe lepe, le le molou. Jisas lalei kumputei lingitowo wolo molou lolpepe, le olo lalei kolo, linauye wusoli ire esi pele ma pa, ma lingitei flis kolo. ");
INSERT INTO ong_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pe pire singu tingeli Jisas laitei nimpe re fei, pe so paptetei nimpe fouri piti ma kapi olongou piti Jisas pele, pe ma kapi wai nemple. ");
INSERT INTO ong_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pe polpepe re fei pe so pratei lupila Jisas. ");
INSERT INTO ong_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nimpe lite Jisas yuwei pe paptei il pirpei polpepei, “Metine lepei le Jisas, le metine ili piti luntoluwepe mete piti Juda.” Il pepei wuso pe pirpei pamtuwo Jisas pepe, le pe paptei paitei nimpe yuwei wuso Jisas laitei lepe. ");
INSERT INTO ong_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Leye lo pe tingelinge mete twinges piti tire ausi. Nele paltei laitei nimpe lele lile plen lite eti tilpi lite Jisas le nele laitei nimpe nele lile eti enkau lite Jisas. ");
INSERT INTO ong_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mete pe pau praltetei Jisas le pe papleipe eri pelpe le pe pirpei kelelawo pirpeiye, ");
INSERT INTO ong_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ye wuso ma altutu winem lite Ma Ili, le epli twinges niliyeye ye miso nou eila lepe. Ye kane yotei, wuso ye ninge lite Ma Ili so itipi au tani nimpe.” ");
INSERT INTO ong_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mete lipi piti pinuwepe mete piti peptawio Ma Ili siye, le mete piti peptalo mete nemple pire il lipi pite Moses le mete piti pinuwepe mete piti Juda, pe re palwe oli piri Jisas le pe pirpeiye, ");
INSERT INTO ong_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Le kaniepe mete nemple wolo le miso kane lotei kolo olo. Le metine ili piti luntoluwepe mete piti Israel lom? Wuso le fei litipi lau tani nimpe, ku ma mulpope il pele. ");
INSERT INTO ong_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Le lulpowo Ma Ili, le le lirpei lolo le ninge lite Ma Ili. So ku fei ma muluwo Ma Ili ma kanowo lo olo.” ");
INSERT INTO ong_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Le mete twinges piti tire ausi le pe tingelinge taitei nimpe tepe re te tolpepe, te kelelawo Jisas. ");
INSERT INTO ong_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wem epli lile nimin, tef lite Juda yefliye munkunum fale keraisi le le fale ningli wem epli weitei le piti ma lautile. ");
INSERT INTO ong_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ningli lepe Jisas louti linai il lipi lirpeiye, “Eli, Eli, lama sabaktani?” Le il pal pepe pirpei polpepei, “Ma Ili leiki, Ma Ili leiki piti men ye usaiki?” ");
INSERT INTO ong_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mete ilepe wuso pile pepe pe pingitowo le pe pirpeiye, “Le linawo Ilaija.” ");
INSERT INTO ong_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Fei nele lelpe frou lantu le kali namalou, lepe lelpe lite piri poltoto tipe le tipe ma lingio le wem pe pesi kenpi, tipe ma naroro. Metine nele lelpe lepe le le kali nele watafei namalou lire loltoto wain tipe yawi wala pulou le metine fei lepe leltei namalou lire tipe lepe, leltei loli nimpe um le le leila yeftuwo Jisas piti ma lalei. ");
INSERT INTO ong_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wolo mete wuru pepe pirpeiye, “Wala mungariwo, muntoli waipiti Ilaija ma lau kanowo lo olo.” ");
INSERT INTO ong_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Fei Jisas nou louti linai il lipi le le kete yef. ");
INSERT INTO ong_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Leye lo ranguwom ili piti lultei winem lite Ma Ili lepe lawo lile um yuwei le noro tef, plen kere le laitei le plen le laitei. Tef lintire le era poungongo, ");
INSERT INTO ong_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","tef wuso paptei towa pato pepe, tef lepe lungo le mete wuru piti Ma Ili pele wuso pinu pa pepe pe nou peilo. ");
INSERT INTO ong_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pe pusape tulum wuso pinu paptei pato pepe le wem Jisas nou leilo re fei, mete wuso pinu le pe nou peilo pepe pe pe Jerusalem le mete wuru pulwepe. ");
INSERT INTO ong_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Wem metine piti luntoluwepe mete piti plolpo, le liripe mete pele piti plolpo pepe, pe wuso pile puntoluwo Jisas, pe puluwo maiene wuso lini lepe le men nange wuru wuso fale pepe, pe turwepe le pe pirpeiye, “Punkomtei, le ninge lite Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nimoure wuru pile fiyen pe so puntolili. Pe wuso pulsesi Jisas pato Galili so pau le pe kanowo. ");
INSERT INTO ong_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nimoure pepei pe peingalope nimin pile pe so puntolili, Maria Makdala, Maria, ne nimou piti Jems re Josep, le nimou piti Jems re Jon, te eple winge titi Sebedi. ");
INSERT INTO ong_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wem epli lautile, metine nele le oweli re yini pele wurutei, le ratei Arimatea, so lau. Le nange lele Josep, le le re le pupane lite Jisas. ");
INSERT INTO ong_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Josep linki le falowo Pailat le le leletei liri topo lite Jisas. Fei Pailat lirpepe piti pe ma kali watowo Josep. ");
INSERT INTO ong_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Liso Josep kali topo lite Jisas le le lire ranguwom teingi yefli lire weisi, ");
INSERT INTO ong_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","le le lalingi luwo erau nample lele. Josep wala nempisye lepei lalowi erau nample fei lepe. Leye lo Josep weisi erau ili lalfo lopopowo erau nample lepe le le leye. ");
INSERT INTO ong_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdala nire Maria nenpe, me roum mratei kani onom mantowo erau nample lepe. ");
INSERT INTO ong_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nolowi, mete piti pinuwepe mete piti peptawio Ma Ili siye le mete piti Farasi, pe pe puluwo Pailat ");
INSERT INTO ong_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","le pe pirpeiye, “Ili louku, ku onposiepe il wuso metine piti lempesipe mete pepe, wem le wala namin ratei le lirpei lolo, ‘Epli wem twinges le niliyeye fei ki ma nou keilo.’ ");
INSERT INTO ong_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ye ma irpepe rourowo erau nample lepe poporo ma epli wem twinges le niliyeye lepe pe kere wo waipiti pupam pele ma pe pire ausi kali. Le pe ma pirpepe mete pirpolo le olo nou leiloye. Il pite fei pingi pempesipe mete pepe, pe ma olpetei le il pite pinu pepe olo olpe wisyauye. ");
INSERT INTO ong_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Le Pailat lirpepe lolpepei, “Rourowo, kesipe yali pal yilape ye yuntoluwo re rourowo yailolowotei.” ");
INSERT INTO ong_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pe so pusa Pailat le pe pe prourowo erau nample lepe. Pe topuwo erau wuso loli wingi piti erau nample lepe le pe paptei mete pratei rourowo erau nample lepe. ");
INSERT INTO ong_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pe pifei onposio Ma Ili re fei, if ili kerere Sandei mul Maria Makdala le Maria nenpe, me roum me muluwo erau nample lepe. ");
INSERT INTO ong_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Frou you fei, maiene ili lini le riri lite Ma Ili lato yuwei so litipi lau. Le weisi erau wuso lufro lopopo erau nample lepe le le lualo lifei erau lepe. ");
INSERT INTO ong_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mati lele lini watafei teplai nesi mil le olongou pele fiyutei watafei nopom. ");
INSERT INTO ong_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Le mete wuso pratei prourowo erau nample lepe pe turwepe olpe pire tekeke le pe naro punkuwo oloye watafei pe pa pepe. ");
INSERT INTO ong_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Riri lepe lirpeme nimoure wiem meme lirpolo, “Ise roum turise pato ki kretai ise roum yintawo Jisas wuso tingeli laitei nimpe lepe. ");
INSERT INTO ong_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Le olo luwo lepei kolo olo, le nou leiloye. Min watafei le linu lirpei lepe. Roum yau le ise roum yuluwo tulum wuso paltei luwo lepe. ");
INSERT INTO ong_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Roum frou ye yirpepe pupam pele yolpepei le nou leiloye, le le fei linuse le Galili le ise miso ye yuluwo. Roum onposiepe il wuso ki kirpeise roum pepe.” ");
INSERT INTO ong_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Me roum musa erau nample lepe le me roum turweme wolo me enke teingime le me mantu me mirpepe pupam pite Jisas. ");
INSERT INTO ong_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jisas piryo fei fale lerengame le le lirpeiye, “Roum enke maleye.” Me roum me falowo, mesiepe ire yepe pele le me roum rautuwo. ");
INSERT INTO ong_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Fei Jisas lirpemeye, “Ise roum turise pato. Roum ye yirpepe ilim winkem peiki piti pe ma pe Galili le pe ma puliki lepe.” ");
INSERT INTO ong_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wem nimoure wiem meme me wala me mato tisi, mete ilepe piti plolpo, pe wuso pratei rourowo erau nample lepe, pe nou pe uf ili lepe le pe pirpepe mete piti pinuwepe mete piti peptawio Ma Ili siye. Pe pirpepe pire men wuso fale pepe, pirpepe yalipeye. ");
INSERT INTO ong_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Fei mete piti pinuwepe mete piti peptawio Ma Ili siye pepe, pe pe panfipe mete lipi piti Juda le pe pirpei pinta tisi. Pe watepe mete piti plolpo pepe, pe watepe era lipi, ");
INSERT INTO ong_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","le pe pirpepeye, “Ise ma yirpei yolpepei, pupam pele pau mulpou wem ise yetei le pe pire ausi kali. ");
INSERT INTO ong_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Le wuso Pailat lingitepe il pepei, le le onom kotu ku miso weisi le ise ma enke olpe yire men re kolo, miso olo.” ");
INSERT INTO ong_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Fei mete piti plolpo pepe pe kapi era pepe le pe pingiepe il wuso mete piti pinuwepe mete piti peptawio Ma Ili siye le mete lipi piti Juda, pe pirpepe pepe. Le il fei pepe, fei re mete piti Juda wala nampli pirpepei. ");
INSERT INTO ong_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Fei pupam piti Jisas pele, pe pire esi plen le plen le niliyeye, pe pe tef alo lupai linpei lifei lite Galili wuso Jisas lirpei piti pe ma pe lepe. ");
INSERT INTO ong_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wem pe puluwo Jisas pe rautuwo wolo ilepe pelpe wala enke moingipe. ");
INSERT INTO ong_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas lau liripe malfem le le lirpepeye, “Ma Ili waiki singe piti kuntoluwepe men nange piti yuwei le piti tef. ");
INSERT INTO ong_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Leso ise ma ye mete walem eryai piti tef ili yefliye le ise weisipe fale pire pupam peiki. Ise ma kaptetei yire nange lite Eiya, Ninge, le Riri Teingi, ");
INSERT INTO ong_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","le ise ma yeptalo piti pe ma pingiepe men nange yeflipi wuso ki kirpeise piti ma yingiepe pepe. Le ise ma retai punkomtei, ki ma kireise ratei wem oli oli ke ke fale wem il olpe pite mete pite tef ma pelesesa.” ");
INSERT INTO ong_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Il teingipe pepei piti pirpei pire Jisas Krais, le ninge liti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Metine nimou Aisaia, le linu laptei il pirpei polpepei, “Ma Ili lirpeiye, metine lepei piti lilape il peiki, ki ma kaltei linuye le piti ma naliye tisi. ");
INSERT INTO ong_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Metine nele linanai ratei tef oli era re telmane ye yawi, le lirpeiye ‘Nali tisi lite Ili, yaltei tisi tuwopou piti le ma lingio le’.” ");
INSERT INTO ong_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Liso Jon fale ratei tef oli era re telmane ye yawi, kaptetei mete le le leptalo il lirpeiye, “Ise yusape il olpe peise le ki ma keiteteise le Ma Ili ma onposiepe il olpe peise kolo olo.” Jon lirpepe mete pepe. ");
INSERT INTO ong_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mete yeflipiye piti tef ili liti Judia le pe piti uf ili Jerusalem, pe pe pingitepe il piti Jon. Pe pirpei nomnaipe il olpe pelpe le Jon kaptetei ratei wof Jodan. ");
INSERT INTO ong_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon lafo olongou pele lire kamel tipli lengleleipe. Le leltalo morou topo luwo pau le le laplei siye tinglape pire hani liti towa yawi. ");
INSERT INTO ong_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jon lirpepe mete lolpepei, “Metine piti lulteiki lingi lau, le olo, singetei le ki olo singe kolo. Ki teingi piti ma kungutu kuwo nenfaripe foiye piti ire topungou pele kolo olo, ki teingi kolo. ");
INSERT INTO ong_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ki keiteteise tipe nimou yawi wolo le ma keiteteise lire Riri Teingi liti Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wem fei lepe Jisas lato Nasaret tef liti Galili, le lato lepe so lau le Jon kaltetei ratei wof Jodan. ");
INSERT INTO ong_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wem Jisas lusa tipe le Le fale le mingo, le luluwo teplai lawo le Nempi liti Ma Ili luwalo lau watafei nafle malpu le le lifei falo lele. ");
INSERT INTO ong_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Le il nemple pirpei fale teplai yuwei pirpeiye, “Ye ninge nange leikitei, ki onom teinginetei kireye.” ");
INSERT INTO ong_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Frouyo fei Nempi liti Ma Ili lalpopo Jisas lila le tef oli era re telmane ye yawi lepe, lila leye. ");
INSERT INTO ong_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jisas le lato epli wem wuru (40 dei) le towa fale lempesesi. Siye piti towa yawi re pratei wolo ririm piti Ma Ili pele pe pau kanowo Jisas. ");
INSERT INTO ong_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pe paltei Jon lifei winem oli re fei, Jisas le Galili le le leptalo il teingipe piti paule Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jisas lirpeiye, “Wem fei fale ye le wem piti Ma Ili ma luntoluwepe mete piti tef, wem fei lepe olo lau lire malfemye. Yusape il olpe peise le ise yulpope il teingipe pepei.” ");
INSERT INTO ong_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wem Jisas lilele le linge mingo liti tuluple Galili, le lulwenge mete twinges piti tengleipe ningu. Te Saimon lire winke lele Andru, te tire taimere tengleipe ningu tifei tuluple lepe. ");
INSERT INTO ong_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas lirpengeye, “Rounge yau yireiki mepi me le ki ma keitaloise rounge piti yengleipe mete.” ");
INSERT INTO ong_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Te frou tusape taimere pelnge le te tire Jisas pepi peye. ");
INSERT INTO ong_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jisas le fiyen taise le le lulwenge line lire winke noute, Jems re Jon. Te eple winge titi Sebedi. Te tifei nimpe teingo lelnge toporipe taimere pelnge. ");
INSERT INTO ong_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Wem Jisas lulwenge le linange. Te tusa yaitei Sebedi liripe mete wuso le laisipe piti pe ma kanowo pepe, pe pifei nimpe teinge lepe le Jems lire Jon tusape le te te tire Jisas pepi peye. ");
INSERT INTO ong_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pe pe fale uf kumpu Kaperneam le wem piti pe ma pifei onposio Ma Ili, wem fei lepe Jisas le angli pau le le leptalo mete. ");
INSERT INTO ong_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Le mete wuso pingitowo pepe pe pinlele potei pire il wuso le leptalo pepe. Le leptalo il watafei mete piti peptalo mete nemple pire il lipi piti Moses pepe kolo olo, le leptalo watafei le metine piti retaitei. ");
INSERT INTO ong_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Fei metine nele le riri oli lunkunguwo, le linki lau angli pau lepe le le lailolo lirpeiye, ");
INSERT INTO ong_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas liti Nasaret, ye ma olomen irouku? Ye au lepei piti ma irouku nemple lom? Ki kretai ye minele, ye metine teingitei piti ilape il piti Ma Ili au.” ");
INSERT INTO ong_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisas lirpowo riri oli lepe lirpeiye, “Ye pos ato le ye naro tani metine fei lepe.” ");
INSERT INTO ong_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Riri oli lepe nenyeyi metine lepe lirkilautei, le lailolo lirkilau le le naro tanio metine lepe. ");
INSERT INTO ong_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mete yeflipiye pe pinlele potei le pe peitei nemple pirpeiye, “Ko men fei pepei? Le leitalouku lire il nemple yeflipi lom? Metine fei lepei le lire singe pele lirpepe ririm olpe le pe paptowo minkim.” ");
INSERT INTO ong_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Le il pirpei piri Jisas pepe pe rufro frou liye liye re pe pinge tef liti Galili. ");
INSERT INTO ong_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas liripe pusa angli pau le pe karowo winem liti Saimon re Andru pe le Jems lire Jon re pepi pe. ");
INSERT INTO ong_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon nimou pele piti nilane moto, ne kainu nire topo weli le wem Jisas le fale pe pirpowo pirine ne. ");
INSERT INTO ong_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Le karene le lesiene eti lene le le kaniene neilo nifei. Fei kainu pepe naro taniene le ne nuntoluwepe nire tipe re oweli. ");
INSERT INTO ong_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wem ninglitei epli re lautileye, mete pilape mete wuso kainu le mete wuso towa ririm olpe punkuwepe pepe, pe pilape pau paptowo Jisas. ");
INSERT INTO ong_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mete piti uf kumpu lepe pe yeflipiye pau panfi nemple pile winem wingi piti winem liti Saimon re Andru. ");
INSERT INTO ong_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mete wuru wuso kainu polomen polomen re Jisas kapi kainu pelpe taniepe le le laptu towa ririm olpe taniepe mete wuso punkuwepe pepe. Jisas lusape towa ririm olpe pepe piti ma pirpei il men re kolo olo, wusoli pe pretawo le minele. ");
INSERT INTO ong_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nolowi lire mul ili, wala if ili kerere lirkilau kolo olo, Jisas leifale lusa winem le le le. Le lusa uf kumpu lepe re le naro le towa yawi, le le tulum nele kotire minkim pa le le so leletei Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Wolo Saimon liripe ilepe pele pe naro pintatawo pe, ");
INSERT INTO ong_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","le wem pe perengawo pe pirpowoye, “Mete yeflipiye pintataye.” ");
INSERT INTO ong_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wolo Jisas namti lirpepeye, “Ku ma me uf walem nemple piti pratei peinei tef fei lepei. Ki ma keptalo il pe mete piti uf pepe re wusoli ki kaule piti ma kesio towa fei lepe.” ");
INSERT INTO ong_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Liso Jisas le linge tef liti Galili le laltuye, le leptalo il lifei angli pal le le laptu ririm olpe taniepe mete. ");
INSERT INTO ong_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Metine nele le pape olpe poluwo. Le lau falowo Jisas, yaru yamkelem ratei le le louti lirpowo piti Jisas ma kanowo. Le lirpeiye, “Wuso ye onposiki ye ma nou eiteiki fale teingi.” ");
INSERT INTO ong_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Fei Jisas onom manowotei le le kete eti laltei le lesio, le le namti lirpowo metine lepe lirpeiye, “Ki ma kaneiye, ye nou fale teingi.” ");
INSERT INTO ong_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Frou yo fei pape olpe pepe pautuye le metine lepe le nou fale teingiye. ");
INSERT INTO ong_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Leye lo Jisas lire il singe lirpowo metine fei lepe, le le laisi frou le tanio. ");
INSERT INTO ong_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Jisas lirpeiye, “Ingitei, ye ma irpepe mete nemple pato wolo ye ma e metine piti leptawio Ma Ili siye le ye ma usa le luliye. Le ye lo ye ma eptawio Ma Ili siye ingiepe il lipi piti Moses wuso pirpei piti ye ma kusai yotei wuso ye nou fale teingi lepe.” ");
INSERT INTO ong_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wolo metine lepe le tani le le nempipe il lirpepe liye liye re leye. Il rufro pirkilau polpepeyo, Jisas ma alepe nimin le fale uf kumpu nele re kolo olo. Le latoto linge tulum piti mete olo pratei kolo, mingim pa le mete piti uf walem eryai pepe pe wala pau falowo. ");
INSERT INTO ong_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Epli wem wuru kari kolo olo, Jisas nou lau Kaperneam le il rufro pirpolo Jisas olo nou lau winemye. ");
INSERT INTO ong_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Liso mete wuru pau panfi le tulum nele re lato yawi kolo olo, winki towa yawi lepe re olo mete piri poungaiye. Jisas wala leptalo il piti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wem mete twinges te twinges, pe pila metine nele le ire esi pele pa, pe pila pau paltowo Jisas. ");
INSERT INTO ong_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pe pila metine lepe pe paltowo Jisas kolo olo wusoli mete olo wurutei. Pe so punwei pe peila winem tupe le pe paltei metine lepe luwo flenge le pe palfo le karowo tulum wuso Jisas lifei lepe. ");
INSERT INTO ong_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas lulwepe wuso pe pulpope il pele pirkilautei pepe, le so lirpowo metine wuso ire esi pele pa pepe lirpeiye, “Ninge leiki, il olpe peiye ma ki onposiepe kolo oloye.” ");
INSERT INTO ong_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Fei mete piti peptalo mete nemple pire il lipi piti Moses, ilepe pelpe wuso pifei pepe pe enke pirpepei poteiye, ");
INSERT INTO ong_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Piti polomen metine fei lepei le lirpei lolpepei? Ma Ili loteteiye miso onposiepe il olpe kolo olo, le metine minele re miso lolpepe kolo olotei.” ");
INSERT INTO ong_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Le Jisas frou retape enke pelpe liso le lirpepeye, “Piti men ise onposiepe il pepe? ");
INSERT INTO ong_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Il men flo ma ki kirpowo metine wuso ire esi pele pa pepe? Ki ma kirpowo kirpolo, ‘Il olpe peiye ma ki onposiepe kolo oloye, lo ma ki kirpowo kolo, ‘Eilo ile kapi flenge peiye le ye ilele e.’ ");
INSERT INTO ong_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ki ma kusaise punkom, Ninge liti Metine Wape, le kapi singe piti le ma onposiepe il olpe piti mete piti tef kolo, le ma onposiepe il olpe pelpe kolo olo.” Liso Jisas lirpowo metine wuso ire esi pele pa pepe lirpeiye, ");
INSERT INTO ong_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ki kirpeiye eifale ile kapi flenge peiye le ye e winem leiye.” ");
INSERT INTO ong_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wem pe yeflipiye pile puntoli, metine lepe leifale lile, kapi flenge pele le le frou leye. Pe pinlele potei le pe peila nange liti Ma Ili pirpeiye, “Ku wala mulwepe men fei fale pepei kolo, olotei.” ");
INSERT INTO ong_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas nou le mingo liti tuluple Galili. Mete wurutei pau falowo le le leptalo lire il piti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wem Jisas wala lilele le, le luluwo metine piti kapiepe mete era, nange lele Livai, le ninge liti Alfius, le le lifei winem lele piti kapipi era. Jisas lirpowoye, “Ulteiki.” Le Livai leifale lulsi Jisas leye. ");
INSERT INTO ong_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wem Jisas wala laplei oweli lifei winem liti Livai, mete wuru piti kapiepe mete era le mete piti pire il olpe pe pulsesi Jisas, le wuru pelpe pe pire Jisas re pupam pele pepi pifei paplei. ");
INSERT INTO ong_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jisas liripe mete piti pire il olpe le mete piti kapiepe mete era, le liripe pepi paplei oweli liso mete ilepe piti peptalo mete nemple pire il lipi piti Moses le pe piti Farasi, pe puluwo Jisas lolpepe pe so pepletei pupam piti Jisas polpepei, “Piti men so Jisas liripe mete fei pepe pepi paplei?” ");
INSERT INTO ong_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Fei Jisas lingitepe le le namti lirpepeye “Mete piti kainu kolo, pe ma pe puluwo metine nimou kolo, wolo pe piti kainuye yaupe, pe miso pe puluwo. Ki kaule piti ma kinape mete teingipe kolo olo, ki kaule piti ma kinape mete piti pire il olpe.” ");
INSERT INTO ong_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wem nele pupam piti Jon liti kaptetei mete le pe piti Farasi, pe paplei oweli kolo, olo pato yaupe. Fei mete nemple pau peletei Jisas polpepei, “Piti polomen so pupam piti Jon le pe piti Farasi, pe olo paplei oweli kolo olo pato yaupe, wolo ye peiye olo paplei oweli, pe pato yaupe kolo, olo pepe?” ");
INSERT INTO ong_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Fei Jisas namti lirpepeye, “Mete wuso pau puluwo metine piti ma lire moto roum maplei oweli pepe, pe ma pirowo nimpi lo ma olo? Ma olo. Wem metine lotei piti laisene moto nepe le wala ratei, pe ma pirowo nimpi kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wolo wem wala lato wem pe ma kesi metine piti laisene moto nepe taniepe, wem fei lepe-ye lo pe ma pirowo nimpiye. ");
INSERT INTO ong_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Minele miso lalwewe takor oli kerere, lalwewe lasio liti teingi, miso olo. Wuso le lolpepe, takor oli lepe ma kerere frou le nef ma konunu. ");
INSERT INTO ong_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Le minele miso lire wengle tipio lalfo luom lali. Wuso le lolpepe, weli ma lalei karerei wengle tipio lepe le luom ma weli lalei loporo kolo. Olo wengle teingi namin soma luom weli lalei loporo. ");
INSERT INTO ong_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wem nele, wem lelpe piti ma pifei onposio Ma Ili, Jisas lilele le linge liom pelpe piti papiri wit. Le wem pupam pele piri pepi pe, pe kareripe wit fouri. ");
INSERT INTO ong_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Liso mete piti Farasi pirpowo Jisas polpepei, “Untoli, pupam peiye ma polpepe kolo. Il lipi piti Moses, pe pirpei polo wem piti ku ma mifei onposio Ma Ili, ku ma mifei yaupe, ma mesi towa men re kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Le Jisas namti lirpepeye, “Ise yungunape il wuso pirpei polo wem Devit nimpi nalei, le le kali men lo olo? Le liripe mete pele pe nimpi naplei, ");
INSERT INTO ong_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","liso Devit linki le winem liti Ma Ili le le lalei luom wuso paltei watowo Ma Ili lepe, Devit leletei metine nange lele Abiatar, le wuso ili liti peptawio Ma Ili siye pepe, le le so watowo lufe pepei paplei.” ");
INSERT INTO ong_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Le Jisas lirpei il lapulu lolpepei “Wem piti mifei onposio Ma Ili lepe, wem fei lepe Ma Ili laltei piti ma lirowo metine wape teingi, le metine wape olo, Ma Ili lotei piti ma lirowo wem fei lepe teingi kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Liso wem piti mifei onposio Ma Ili lepe, wem fei lepe Ninge liti Metine Wape le luntoluwo.” ");
INSERT INTO ong_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Le ye lo Jisas nou le angli pau le metine nele, le eti lele la. Le lifei angli pau lepe. ");
INSERT INTO ong_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mete ilepe wuso pifei lepe pe pirpolo pe ma pamtuwo Jisas pirpolo le lire il olpe, pe so lusye patotowo piti ma puluwo waipiti Jisas ma kanowo metine wuso eti lele la lepe lo ma olo, wusoli wem fei lepe, le wem piti pe ma pifei onposio Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Fei Jisas lirpowo metine wuso eti lele la lepe lirpeiye, “Eilo au ilepe onom lepei.” ");
INSERT INTO ong_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Leye lo Jisas lepletei mete pepe lolpepei, “Il lipi pouku pe pirpei piti wem ku mifei onposio Ma Ili le ku ma mesio towa men lo ma olo? Ku ma kaniepe mete nemple lo ku ma watepe moingi? Ku ma kanowo metine nele piti ratei lo ku ma mirowo nele?” Wolo pe il men re pirpei kolo. ");
INSERT INTO ong_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas lulwepe leinei leinei le le onom kotu wolo le onom manepe wusoli pe enke lipi le pe fupepletei. Leye lo Jisas lirpowo metine wuso eti lele la lepe lirpowoye, “Kesi eti leiye altei lire ulel.” Fei metine lepe kesi eti lele laltei le eti lele nou fale teingiye. ");
INSERT INTO ong_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Liso mete piti Farasi, pe pusa angli pau lepe le pe frou pe piripe mete ilepe piti pingowo Herot, pe pepi pifei le pe pinta tisi piti ma petesi Jisas la. ");
INSERT INTO ong_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas lire pupam pele pe tuluple Galili peye, le mete wurutei pulsesi pe. Pe mete piti pau Galili, pe pau Judia, ");
INSERT INTO ong_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","pe piti pau Jerusalem, pe pau tef liti Idumea, pe piti pau tef lato plen liti wof Jodan, le pe piti uf walem malfem pire uf lingi Tair re Saidon. Mete wurutei fei pepe pe pau Jisas wusoli pe pingitepe il pire men nange wuso le laptei falele pepe. ");
INSERT INTO ong_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pe mete wurutei polpepe yo Jisas lirpepe pupam pele piti ma kesi nimpe teingo nele paltowo elpesi laitei waipiti mete ma fale keraisi oloye. ");
INSERT INTO ong_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Le kapi kainu taniepe mete wuru le mete wuso kainu pepe pe paisesipe mete tani potei piti ma pe malfem pesio Jisas. ");
INSERT INTO ong_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Le mete wuso ririm olpe punkuwepe pepe, wem pe puluwo Jisas pe ma pualo pratei pinuwo le pe ma pailolo pirpeiye, “Ye ninge liti Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wolo Jisas lire il singe lirpepe ririm olpe pepe piti pe ma pirpei nomnai piri le minele kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Leye lo Jisas lunwei tef nele alo lupai linpei lifei le le linape mete wuso pele onom puwope pepe le pe karowo pe. ");
INSERT INTO ong_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Le le keiniepe pire esi plen le plen te twinges le le linape pe apostel. Jisas lirpepeye, “Ki keinise piti ma yireiki ki le il piti Ma Ili re ki ma kaiteise ye yeptalo, ");
INSERT INTO ong_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","le ise ma kapi singe piti yaptu towa olpe taniepe mete.” ");
INSERT INTO ong_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mete pire esi plen le plen te twinges wuso Jisas keiniepe pepe min pepei, Saimon (Jisas watowo nange nele Pita), ");
INSERT INTO ong_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems lire winke lele Jon, te eple winge titi Sebedi. (Jisas watenge nange Boanerges, il pal pirpei polo te teplai eple winge titi teplai loungongo.) ");
INSERT INTO ong_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Filip, Bartolomyu, Matyu, Tomas, Jems, le ninge liti Alfius, Tadius, Saimon nele (le piti mete wuso pinaulipe Rom piti pontoluwepe mete piti Judia) ");
INSERT INTO ong_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","le Judas liti uf Iskariot, le metine wuso laltei Jisas le esi piti mete olpe. ");
INSERT INTO ong_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Leye lo Jisas nou le winem leye. Le mete wurutei nou pau panfi polpepe yo, Jisas lire pupam pele pe oweli re paplei kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wem nimou re winkem piti Jisas pingitei polpepei, pe pe piti ma kesi Jisas wusoli mete pirpei polpepei, “Le olo, falo lele linini.” ");
INSERT INTO ong_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mete ilepe piti peptalo mete nemple pire il lipi piti Moses, pe pato Jerusalem so pau le pe pirpeiye, “Le olo towa nimou lunkuwo.” Le ilepe pirpeiye, “Le towa nimou watowo singe piti laptu towa kumpu pepe ma naro taniepe mete wuso punkuwepe pepe.” ");
INSERT INTO ong_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Liso Jisas linape mete pau le le lirpepe il nemple piti kauro yuwei lirpeiye, “Towa ma laltu towa lolomen? ");
INSERT INTO ong_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wuso mete piti uf tef nele, pe kare peite nemple alpe kumpu kumpu le pe posi nemple, mete piti uf tef fei lepe pe ma pile singe polomen. ");
INSERT INTO ong_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wuso eple pire nimou re yaitei, pe kare peite nemple le pe posi nemple, pe ma pile singe polomen. ");
INSERT INTO ong_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Le wuso towa lire towa wane pele pe kare peite nemple pe ma pile singe kolo olo. Singe pelpe ma pelesesa oloye.” ");
INSERT INTO ong_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Winem liti metine singe le minele miso yaruwo linki le kapio oweli men nange pele? Ma olo, metine lepe le ma linu topuwo metine singe lepe, topuwo lari wo, le soma linki laltu winem.” ");
INSERT INTO ong_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ki kirpeise punkom, il olpe piti yirpei yiri metine wape, il olpe pepe Ma Ili miso onposiepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wolo minele piti lirpei il olpe liri Riri Teingi, il olpe pepe Ma Ili ma onposiepe wem oli oli wusoli il olpe wuso metine lepe lirpei liri Riri Teingi, il olpe pepe pe ma pile pingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Jisas lirpepe lire il pepei wusoli ilepe pelpe pirpei polpepei, “Le olo, riri oli lunkuwo.”) ");
INSERT INTO ong_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Leye lo Jisas nimou pele nire winkem pele, pe pau fale. Pe pile towa yawi pe so paptei il pe winem leinginim peletei Jisas piti ma naro lau lulwepe. ");
INSERT INTO ong_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mete wurutei pifei neinowo Jisas, le pe pirpowoye, “Untoli, nimou re winkem peiye pile towa yawi, le pe peitouku pireye ye.” ");
INSERT INTO ong_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Le Jisas namti lepletei lolpepei, “Minenpe ne nimou peiki? Minemple pe winkem peiki?” ");
INSERT INTO ong_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Le lulwepe mete wuso pifei neinowo pepe, lulwepe leinei leinei fei lirpeiye, “Yuntoli, nimou nire winkem peiki min pepei. ");
INSERT INTO ong_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Minemple pingiepe il piti Ma Ili, le winke leiki, ne oru peiki, ne nimou peiki.” ");
INSERT INTO ong_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wem nele Jisas le leptalo il lile mingo liti tuluple Galili. Mete wuso pile neinowo pepe olo wurutei polpepeyo le longlo lifei nimpe teingo. Nimpe teingo lepe le luwo tipe le mete wurutei pepe pe pilele pinge tipe lunko re tuluple mingo lepe. ");
INSERT INTO ong_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jisas lire il kauro yuwei leptalo mete lire men nange wuru le le leptalo lirpeiye, ");
INSERT INTO ong_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yingitei, metine nele le le laptetei wit fouri linge liom. ");
INSERT INTO ong_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wem le laptetei wit fouri pepe, le laptetei ilepe linge tisi le naflepem fale paplei yalipeye. ");
INSERT INTO ong_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kon fouri ilepe le laptei linge tef era le pe falele frou wusoli tef tale lepe olo kumpu luwo era yuwei yawi. ");
INSERT INTO ong_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Le wem epli fale lapo wit wuso falele pepe, pe frou talpelipe yo paye wusoli wit nalem pepe olo pe kru kolo, olo puwo pinge era yuwei yawi. ");
INSERT INTO ong_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kon fouri ilepe le laptei pinge wolo singu le wit pepe pe peilo wolo wolo singu fale pafo le pe pilape fouri kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wolo le laptei wit fouri ilepe linge tef teingi. Kon falele, peilo pe lipi le pe pilape fouri. Ilepe pilape wuru taise (30), ilepe pilape wuru (60) le ilepe pilape wurutei (100).” ");
INSERT INTO ong_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Le Jisas lirpei il lapulu lolpepei, “Yingitei, wuso ise mingim paitei ise ma yingitei.” ");
INSERT INTO ong_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wem Jisas loteteiye, mete ilepe wuso pingitowo pepe pe pire pupam pele pire esi plen le plen te twinges, pe pepi pau falowo Jisas le pe peletei piti le ma lirpepe nomnaipe lire il pal piti il kauro yuwei pepe. ");
INSERT INTO ong_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Fei Jisas namti lirpepeye, “Ise kapi il kotire piti wem Ma Ili ma luntoluwepe mete piti tef wolo mete piti pinge towa yawi pepe pe pingitepe il kauro yuwei yaupe, ");
INSERT INTO ong_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","soma pe puntoli re puntoli wolo pe ma puluwo men re kolo, pe ma pingitei re pingitei wolo pe miso pretai kolo, le wuso pe pretai pe ma kani onom pantowo Ma Ili le le ma onposiepe il olpe pelpe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Leye lo Jisas lepleteiye, “Il kauro yuwei pepe, ise retape lo olo? Il nemple kauro yuwei re ise ma retape fei yolomen? ");
INSERT INTO ong_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Metine wuso laptetei kon fouri pepe, le leptalo il piti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wem nele le leptalo il linge tisi watafei le laptetei kon fouri linge tisi lepe. Mete pingitei wolo towa frou lau nampli il pepe taniepe. ");
INSERT INTO ong_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mete ilepe pe watafei kon fouri wuso laptetei linge tef era lepe. Wem pe pingitepe il, pe frou enke teingipe pasiepe le pe kapi pesiepe. ");
INSERT INTO ong_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wolo il pepe pe posiepe enke pirkilau kolo olo, le pe pesiepe wem ulel kolo olo. Liso wem moingi men fale wusoli pe pingitepe il fei pepe, pe frou pusape le pe pingiepe kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mete ilepe pe watafei kon fouri wuso laptetei pinge wolo singu pepe. Mete pepei pe pingitepe il, ");
INSERT INTO ong_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wolo pe enke puwope oweli yini re men nange piti tef fei lepei le il pepe pe pirepe onomye le pe peptalo mete nemple kolo. ");
INSERT INTO ong_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wolo mete ilepe pe watafei kon fouri wuso le laptei linge tef teingi lepe. Pe pingitepe il, pe kapi pesiepe le pe peptalo mete nemple. Ilepe peptalo mete wuru taise (30), ilepe peptalo mete wuru (60) le ilepe peptalo mete wurutei (100).” ");
INSERT INTO ong_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas nou lirpepe lolpepei, “Minele miso lila nongo weli linki lau le le kali ufau lire muntuwo lo le lalingi lato poi tef lo ma olo? Le le ma laltei nongo weli lepe, laltei luwo poi yuwei lo ma olo? ");
INSERT INTO ong_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Menemple piti paplingi kotire pato, pe ma paptei alepe nimin le menemple piti muntuwepe, pe ma nampli paptei towa yawi. ");
INSERT INTO ong_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yingitei, wuso ise mingim paitei ise ma yingitei.” ");
INSERT INTO ong_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jisas nou lirpepe lasi lolpepei, “Il men ise yingitepe, ise ma onposiepe yoporo wo. Tisi wuso ye ingio piti ma kapi il aptei ire mete nemple pepe, tisi elpesi fei lepe soma Ma Ili liri piti le ma namti kapi il laptei lireye, wolo le ma lirkilautei waiye. ");
INSERT INTO ong_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Metine piti retape il men kumpu piti Ma Ili, Ma Ili ma lirkilau lafofowo il pele le metine fei lepe le ma retape wurutei. Le metine piti lironom lire il piti Ma Ili, Ma Ili ma kani onom nanio metine fei lepe le le ma fupeletei lire il piti Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas wala lirpei lolpepei, “Wem piti Ma Ili ma luntoluwepe mete piti tef, le ma watafei metine lapiri oweli linge liom lele. ");
INSERT INTO ong_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Metine lepe, wem mulpou le letei le epli le leilo laulolo le, le oweli piti liom pepe pe peilo pila yousi re wangli, le pe wala so peilolo ma pe lipi. Wolo metine lepe le lironom lire oweli wuso peilo pe lipi pepe, pe peilo polomen wolo olo, le retai kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tef lotei lilape oweli pepe pe lipi le pe pilape eple. Oweli ungou ma pinu falele, leye lo pe pila yousi pe pe yo ma pire nole fei, oweli poungoye. ");
INSERT INTO ong_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Le wem oweli poungo, metine fei lepe le ma nou kali wem laltetei piti men, olo ma lofleipeye wusoli oweli olo poungo fei.” ");
INSERT INTO ong_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas lepletei lolpepei, “Ku ma mirpei molomen miri wem piti Ma Ili ma luntoluwepe mete piti tef, le ma watafei men? Il men piti kauro yuwei ma ku miripe mirpei nomnaipe mire il pal pepe? ");
INSERT INTO ong_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Le ma watafei nimpe fouri, le kumputei le metine nele kali lari. ");
INSERT INTO ong_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wem ulel re fei, nimpe lepe leilo le ili laptetei angoleingi lipi, le naflepem paule paptetei onkotu pelpe pultei nimpe fei lepe.” ");
INSERT INTO ong_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas leptalo il pele pe mete le le liripe il wuru piti kauro yuwei watafei pepei, le lirpepe il wuru piti pe ma pretai. ");
INSERT INTO ong_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jisas ma lirpepe lire il yaupe kolo olo, le ma liripe il kauro yuwei soma lirpepe wolo wem le loteteiye lire pupam pele, le ma lirpepe nomnaipe lire men nange wuruye. ");
INSERT INTO ong_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Epli wem nele, wem ningli Jisas lirpepe pupam pele lolpepei, “Ku monglo me tuluple mingo plen.” ");
INSERT INTO ong_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pe so pusape mete wurutei pepe, pupam pepe pe ponglo nimpe teingo elpesi wuso Jisas linu longlo lifei lepe le pe pire Jisas pepi peye. Nimpe teingelem nemple re paitei. ");
INSERT INTO ong_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yuf ilitei fale le tipe loungongo leingalolo nimpe teingo lepe le le ma faleye. ");
INSERT INTO ong_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Le Jisas olo lire tili renkowo falo lele le le letei luwo nimpe teingo le tounga. Fei pupam pele kumsasi le pe pirpeiye, “Ye metine piti eitalouku, ko ku ma maye ko, le ye onposuku re lo olo?” ");
INSERT INTO ong_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisas leifale le le lire il singe lirpowo yuf lolpepei, “Pos ato.” Le le lirpowo tipe wuso loungongo lepe lirpeiye, “Irkir uwo.” Fei yuf kere le tuluple tipe lepe le lirkirtei piti luwo. ");
INSERT INTO ong_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Leye lo Jisas lirpepe pupam pele lolpepei, “Piti men ise turise? Ise wala yulpope il piti Ma Ili kolo olo lom? ");
INSERT INTO ong_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wolo pe olo turwepe olpe pire tekeke le pe pirpepei nempleiye, “Metine minele fei so lepei? Yuf re tipe wuso loungongo lepe, pe paptowo mingim.” ");
INSERT INTO ong_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas lire pupam pele pe fale plen liti tuluple Galili, tef liti Gerasa. ");
INSERT INTO ong_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wem Jisas konko lualo nimpe teingo le, metine nele lau lerengawo. Metine lepe lato ilingi piti paptei towa, le lato lepe so lau fale lerengawo Jisas. ");
INSERT INTO ong_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Metine lepei le riri oli lunkuwo le le ratetei ilingi piti paptetei towa pepe. Minele re miso lire foiye singetei pepe lire topuwo metine lepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wem wuru ire re esi piti metine lepe, pe topwepe papiri wolo wem oli oli, le lesi karipe foiye pepe le le lire ire loluwepe ain lasi tef. Le olo singetei le mete minemple re miso pesio pari kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Epli mulpou, le laulo linge ilingi piti paptetei towa pepe, le le le linge tef alo lupai linpei lifei lepe le, lailolo re leilu lotei lasi era. ");
INSERT INTO ong_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Le wala lualo fiyen taise wem le luluwo Jisas le so lantu lau lualo yaru yamkelem ratei linuwo, kani onom lantowo Jisas, ");
INSERT INTO ong_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","le le lirkilau lailo il lipi lirpeiye, “Jisas, ninge liti Ma Ili yuweitei ye ma olomen ireiki ki? Eisi Ma Ili le ye ma waiki moingi pato.” ");
INSERT INTO ong_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Metine lepe le lirpei il pepei wusoli Jisas lirpowo riri oli lepe lirpolo, “Riri oli, ye naro au tanio metine fei lepei.”) ");
INSERT INTO ong_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Liso Jisas leletei riri lepe lolpepei “Ye nange leiye mi?” Le riri lepe le namti lirpowoye, ‘Ki nange leiki Mob le ku olo wurutei.” ");
INSERT INTO ong_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Le le lirpopowo Jisas piti ma laisipe ririm olpe pe tani tef fei lepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Songou wurutei paplei oweli pile tef nele alo lupai linpei lifei. ");
INSERT INTO ong_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Fei ririm olpe pepe pe pirpowo Jisas polpepei, “Aitouku me munkuwepe songou piye.” ");
INSERT INTO ong_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Liso Jisas laisipe pe. Ririm olpe pepe pe naro tanio metine lepe le pe pe punkuwepe songou pepe. Songou wurutei pepe, (2,000) pe yeflipiye pantu pitipi alu lepe pe pautile tuluple, pa yalipeye. ");
INSERT INTO ong_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Le mete piti puntoluwepe songou pepe, pe pantu pe pirpepe mete piti uf lepe le il rufro pe falepe mete piti pratei pinge liom, le pe pratei uf kumpu malfem. Mete naro pau puluwo men wuso fale lepe. ");
INSERT INTO ong_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pe pau falowo Jisas le pe puluwo metine wuso ririm olpe wuru wuso punkuwo lepe. Metine lepe le lungura ratei, onom teingine falowoye, le pe yeflipiye turwepe. ");
INSERT INTO ong_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Le mete wuso pulwepe men men wuso fale pepe, pe pirpepe mete wuru pepe, pe pirpepe pire metine wuso ririm olpe punkuwo lepe, le songou wuso pantu pe peingalo tuluple, le pe pa pepe. ");
INSERT INTO ong_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Liso mete pepe pe pirpowo Jisas piti ma le tani tef lelpe. ");
INSERT INTO ong_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wem Jisas wala so longlo nimpe teingo lepe, le metine wuso ririm olpe punkuwo lepe, le lirpowo Jisas lolpepei, “Usaiki kireye rounge we.” ");
INSERT INTO ong_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wolo Jisas lusa liripe pepi pe kolo olo. Le Jisas lirpowo lolpepei, “Nou e winem re nimou yaitei, ilim winkem peiye le ye irpepe ire men men teingipe wuso Ma Ili laptei faleye pepe le le onom maneiye re laileleye lepe.” ");
INSERT INTO ong_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Liso metine lepe le le lirpepe linge Dekapolis, lirpepe lire Jisas wuso kanowo lepe le mete yeflipi wuso pingitowo pepe, pe pinlele potei. ");
INSERT INTO ong_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas nou le tuluple mingo plen le mete wurutei pau neinowo pile tuluple mingo lepe. ");
INSERT INTO ong_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Fei Jairus, le metine piti luntoluwo angli pau lelpe, le lau le wem le luluwo Jisas le lualo ratei ire yepe piti Jisas, ");
INSERT INTO ong_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","le le lirkilautei piti louti lirpowo Jisas lolpepei, “Ningio kumpu peiki olo kainu onetei. Au eptalo esi peiye puwone le ne ma nironom le ne ma namne ratei.” ");
INSERT INTO ong_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Leye lo Jisas liri rounge teye. Mete wurutei piri pepi pe le mete plen plen re keraisi oloye le Jisas linge niminye le. ");
INSERT INTO ong_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Moto nenpe, ne nilala teluwi ili ne eringi wuru (12 yia). ");
INSERT INTO ong_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mete emare wuru kaniene pire kainu pene wolo olo ne wala nilala teluwi. Ne nampli mole pene yalipeye wolo ne olo nou fale teingine kolo, ne wem oli oli nilala teluwi ili iliye. ");
INSERT INTO ong_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ne ningitepe il piri Jisas ne so nulsesi ningi niripe mete wuru pepe. ");
INSERT INTO ong_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ne nirpepei notei nolpepei, “Wuso ki kesiepe olongou pele yaupe, ki miso nou fale teingine.” ");
INSERT INTO ong_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ne nesio olol lele liti lalfo lifei yuwei lepe le ne frou yo fei ningitei notei teluwi lene fei kereye, le moingi lene lepe re fei oloye. ");
INSERT INTO ong_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Wem fei lepeye, Jisas lingitepe singe pele naro pe tanio. Liso le weitei, le lile leingalipe mete wuru pepe le le lirpeiye, “Minemple pesiepe olongou peiki?” ");
INSERT INTO ong_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Fei pupam pele namti pirpowo polpepei, “Ye ulwepe mete wurutei min pile neineye pepei le piti men ye epletei irpolo minemple pesiye?” ");
INSERT INTO ong_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wolo Jisas wala lile luntolili piti ma luluwo mi wuso lolpepe lepe. ");
INSERT INTO ong_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Fei moto nepe ne nulu notei wuso teluwi lene kere lepe, ne so nau falowo Jisas. Ne turwene re punwewine le ne nualo ratei ire piti Jisas le ne nirpowo nire men men punkom wuso falene pepe. ");
INSERT INTO ong_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisas lirpene lolpepei “Ningio peiki, ye ulpope il piti Ma Ili ye so nou fale teingine nepe. E ire onom malye le moingi leiye miso kere.” ");
INSERT INTO ong_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wem Jisas wala lirpepei il fei pepei mete nemple pato winem liti Jairus so pau le pe pilape il pau pirpowo Jairus lotei polpepei, “Ningio peiye olo naye. Piti men ma ye kesi metine piti leptalo mete le ye kali wem altetei lepe?” ");
INSERT INTO ong_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisas lingitepe il pelpe wolo le lirpowo Jairus lolpepei, “Ye ma turiye pato, ulpope il piti Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Leye lo Jisas lusape mete nemple piti pepi pe kolo olo. Le kesi Pita lire Jems re winke Jon, pe poteteiye pire Jisas pepi pe. ");
INSERT INTO ong_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pe pe fale winem liti metine piti luntoluwo angli pau lelpe, Jisas lulwepe mete wuso punwei fale nemple le le lingitepe pailolo re poutiti olpetei pepe. ");
INSERT INTO ong_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Le linki le winem le le lirpepe mete pepe lolpepei, “Ise yunwei fale nemple piti men? Piti men ise youtiti? Ningio kumpu nepe ne olo na kolo, ne netei.” ");
INSERT INTO ong_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Fei pe palwe oli piri Jisas liso le laisipe naro pe towa yawi. Le kesime nimou re yaitei miti ningio nepe, le pupam pele twinges niliyeye pepe, pe poteteiye pire Jisas pepi pinki pe elpeingo wuso ningio kumpu na nuwo lepe. ");
INSERT INTO ong_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jisas leila eti lene le le lirpene lolpepei, “Talita koum,” il pal pirpei polo, “Ningio kumpu, ki kirpeiye, ye eiloye.” ");
INSERT INTO ong_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ne neilo frou yo fei le ne nilele neinenei ninge elpeingo lene lepe. (Ne eringi pene pire esi plen le plen te twinges.) Wem pepei fale, nimou nire yaitei le pupam twinges niliyeye piti Jisas pele pepe, pe pinlele potei olpetei. ");
INSERT INTO ong_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wolo Jisas lire il singe lirpepe piti ma pirpepe mete nemple kolo olo le le lirpeiye, “Watene menemple piti ma naplei.” ");
INSERT INTO ong_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas lusa tulum fei lepe le le nou le uf lele le pupam pele re pepi pe. ");
INSERT INTO ong_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Wem piti pe ma pifei onposio Ma Ili, Jisas le leptalo mete lifei angli pau lelpe. Mete wuru pifei angli pau lepe le wem pe pingitowo pe pinlele potei. Pe peite nempleiye, “Le kapi il pepei pato fei linei? Le onom nire wuru fei lolomen? Le lolomen so le lirpei le men nange potei pire tute falele pepe? ");
INSERT INTO ong_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Le metine piti lesiepe winangou ko? Le ninge liti Maria le le line liti Jems, Josep, Judas re Saimon ko? Eri pele pratei lepei lo olo?” Le pe so pinauli Jisas. ");
INSERT INTO ong_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisas lirpepe lolpepei, “Mete piti uf eryai pepe pe ma pailolowo metine nimou wolo mete piti uf lele lotei le ilim winkem re nimou yaitei pele, pe miso pailolowo kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jisas kaniepe mete yaipiyeye wuso kainu pepe, le leptalo esi pele puwope le pe pironom. Le piti le lirpei le men nange potei pire tute fale yaupe pepe, olo le lolpepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jisas linlele lotei olitei wusoli mete pepe pe pulpope il piti Ma Ili kolo olo. Leye lo Jisas le leptalo mete piti uf walem pingene tef fei lepe. ");
INSERT INTO ong_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Le linape pupam pele wuso pire esi plen le plen te twinges pepe le le laisipe pe twinges twinges. Le watepe singe piti weisipe towa olpe, ");
INSERT INTO ong_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","le le lirpepe lamtetepe lolpepei “Ise ma kali men yila ye kolo olo, kali efle yawi piti yausesi. Luom olo, tom piti yila ma olo, era piti yilape pratei tenge eple peise re ma olo, yire esi yaupe ye. ");
INSERT INTO ong_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ise ma yafo ire topungou peise, wolo olol nele piti yalfo ma olo, yalfo kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Le nou lirpei lolpepei, “Minemple piti keteise pilaise pe winangou pelpe, ise ma ratei winangou elpesipe pepe ye ye yo ma fale wem piti ise ma yusa uf fei lepe le ise ye nele. ");
INSERT INTO ong_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Le wuso mete piti uf nele pe keteise pilaise pe winangou pelpe kolo olo, lo pe papteise mingim kolo olo, yusa uf fei lepe le pe ma pratei pire il olpe pelpe. Fei pepe ma kosape, Ma Ili ma watepe moingi.” ");
INSERT INTO ong_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Liso pupam pepe pe pe peptalo il piti mete ma pusape il olpe pelpe. ");
INSERT INTO ong_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pe paptu ririm olpe wuru, le pe pire oliv tipe preltasipe mete wuso kainu pepe le pe nou fale teingipe. ");
INSERT INTO ong_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Fei metine ili piti luntoluwepe mete, pinawo Herot, le lingitepe il piti Jisas wusoli nange lele mete pungunana re pirpepei piri liye liye re peye. Mete ilepe pirpei polpepei, “Jon liti kaptetei mete pepe, le nou leilo. Min fei polpepei so le kapi singe piti lirpei le men nange potei pire tute fale pepe.” ");
INSERT INTO ong_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ilepe pirpei polpepei, “Le Ilaija.” Ilepe pirpeiye, “Le kuna metine nimou watafei mete emare nemple piti sungoi pepe.” ");
INSERT INTO ong_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wem Herot lingitepe il pepe, le lirpeiye, “Le kuna Jon liti kaptetei mete. Ki kirpepe palowio falo lele, wolo le nou leilo.” ");
INSERT INTO ong_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herot lotei lirpepe piti penglei Jon le pe topuwo paltei lifei winem oli. Herot lirpepe palowio Jon falo wusoli Herot laisene Herodias, ne moto piti winke lele Filip. ");
INSERT INTO ong_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon liti kaptetei mete, le wem oli oli lirpopowo Herot lolpepei, “Ye aisine moto piti winke leiye, fei pepe olo pato poporo kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Liso Herodias onom flis nire Jon le ne nirpolo ma naltei la wolo Herot lusane nolpepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot turuwo lire Jon wusoli le retawo Jon le metine teingi tuwopoutei le le so karowo lope. Herot onom kere piti ma lingitowo Jon lirpepe wolo wem oli oli il piti Jon pele posisio Herot olitei. ");
INSERT INTO ong_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wem Herot lapli oweli piti ma onposio wem piti nimou nila, wem fei lepe Herodias nerengawo tisi piti ma naltei Jon la. Herot lapli oweli le le linape mete lipi piti kanowo pepi pesio towa liti puntoluwepe mete, le mete lipi piti pinuwepe mete piti plolpo le mete lipi piti Galili pepe, Herot linape pe pepi paplei. ");
INSERT INTO ong_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Fei Herodias ningio pene ninki ne nuro, le Herot liripe mete lipi pepe pe enke teingipe pasiene. Liso Herot lirpene lainou nepe lolpepei, “Ye eiteiki ire menele le ki miso waiye.” ");
INSERT INTO ong_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Le le topwepe il lapiri lirine moto lainou nepe lolpepei, “Ki kirpei punkom, ye eiteiki ire menele le ki miso waiye. Menemple lipitei watafei tef oweli re wuso ki peiki pepei, ki miso karipe kile nimin waiye.” ");
INSERT INTO ong_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Liso ningio nepe ne naro ne nentei nimou nolpepei, “Ki ma keletei kiri men?” Le nimou namti nirpeneye, “Falo liti Jon liti kaptetei mete, le ma waiye falo lele.” ");
INSERT INTO ong_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Fei moto lainou nepe ne nou frou ne nirpowo Herot nolpepei, “Ye ma fei lepei altei falo liti Jon liti kaptetei mete, altei falo lele luwo waifile le ye waiki.” ");
INSERT INTO ong_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herot weitei onom one lire il pene, wolo le ma weisipe il pene lolomen, olo wusoli le topwepe il lapiri le mete lipi wuso le linape pau pepi paplei oweli pepe pe pingitowo fei. ");
INSERT INTO ong_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Liso Herot frou laisi metine piti luntoluwo winem oli, Herot laisi le piti ma lalowio Jon falo lila lau. Metine piti luntoluwo winem oli lepe, le lusape Herot liripe le le le winem oli lepe le le lalowio Jon falo lele. ");
INSERT INTO ong_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Leye lo le laltei falo lepe luwo waifile le le lila lau watene ningio piti Herodias nepe le ne kali watene nimou pene. ");
INSERT INTO ong_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wem Jon pupam pele pingitei wuso pe palowio Jon falo lele lepe, pe pau kali pila pe palowi oi paltei. ");
INSERT INTO ong_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Fei pupam piti Jisas pele, pe nou pau fale panfi Jisas le pe nampli pirpowo pire towa wuso pe pe pesio lepe le il men men wuso pe peptalo mete piripe pepe. ");
INSERT INTO ong_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mete wurutei peye pauye, polpepeyo Jisas liripe pupam pele oweli re paplei kolo oloye. Liso Jisas lirpepe pupam pele lolpepei, “Ku kutotouye me nele yawi le ise ma ratei yaltei yef wo.” ");
INSERT INTO ong_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pe so ponglo nimpe teingo nele le pe pe tulum nele yawi mingim pa. ");
INSERT INTO ong_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mete wuru pulwepe Jisas liripe pupam pele wuso pusape le pe pe pepe, pe frou pretai pe minemple pe so pantu pinge tef mingo pe. Pe piti uf walem wuru le pe pantu pinuwo Jisas liripe pupam pele le pe pinu pe fale tulum wuso Jisas lire pupam pele ma pe lepe. ");
INSERT INTO ong_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wem Jisas konko lualo nimpe teingo lepe le lulwepe mete wurutei le le onom manepetei wusoli pe watafei sipsip yaupe le metine piti luntoluwepe pepe, le olo. Liso Jisas leptalo mete pepe, le leptalo lire men men wuru. ");
INSERT INTO ong_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wem ninglitei Jisas pupam pele pau pirpowoye, “Ningli munkunumye le tulum fei lepei re olo yawitei. ");
INSERT INTO ong_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Aisipe mete pe tani le ye usape pe uf re liom nemple malfem pepei le pe ma paisepe oweli men pelpe paplei.” ");
INSERT INTO ong_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“Ise isotei watepe oweli men men piti paplei.” Jisas namti lirpepe. Le pe nou peletei polpepei, “Ku ma mire era lipitei 600 kina mire maise luom piti ma watepe palei lom?” ");
INSERT INTO ong_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Liso Jisas lepletei pupam pele lolpepei, “Ise lufe polomen? Ye yuntoli.” Wem pe pe puntoli re fei pe pirpowoye, “Lufe pire esi plen poungo le ningu re twinges.” ");
INSERT INTO ong_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Leye lo Jisas lirpepe pupam pele piti ma karipe mete paptei pratei tulum fi fi, pratei pinge wolo pepe. ");
INSERT INTO ong_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Liso mete pepe pe pratei pinge nemple nemple, pratei wai kari kari, 100 mete pratei tulum lepe le 50 mete pratei lepe polpepeye pe. ");
INSERT INTO ong_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Leye lo Jisas kapi lufe wuso pire esi plen poungo pepe le ningu twinges tepe, le luntoli lato teplai yuwei le le leletei Ma Ili. Le kareripe lufe watepe pupam pele le pe namti pilape pe watetepe mete. Ningu twinges tepe re Jisas yaruwenge watetepe le liripe loungaiye. ");
INSERT INTO ong_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mete yeflipiye paplei le pe yefi tangupu. ");
INSERT INTO ong_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Leye lo Jisas pupam pele, pe tonwipe lufe re ningu ilepe wuso watepe mete paplei le ilepe wala pratei pepe, pe pafo pora pire esi plen le plen te twinges, fale pire pora nemi poparu. ");
INSERT INTO ong_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mete wuso paplei pepe pe wurutei (5,000). ");
INSERT INTO ong_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Fei Jisas frou laisipe pupam pele ponglo nimpe teingo le pe pinuwo pe Betsaida, lato le tuluple mingo plen. Le Jisas lotei wala laptetei mete wuso wurutei pepe, le laptetei pe. ");
INSERT INTO ong_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jisas laptei pupam pele pe re fei, le le tef nele alo lupai linpei lifei le le leletei Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wem munkunum lirkilau, nimpe teingo wuso lilape pupam pepe olo le fale tipe niminye le Jisas loteteiye wala ratei tef mingo plen. ");
INSERT INTO ong_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jisas olo lulwepe pupam pele fei, le lulwepe wuso pe praltutuwe nimpe teingo lepe pe wolo yuf lini lilepe onom lau le pe piri plolpo pepe. Liso nolowi nau Jisas le falepe. Le lilele linge tipe yuwei so le. Jisas ma le raptei le, ");
INSERT INTO ong_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Wolo pupam pele puluwo wuso lilele linge tipe yuwei le lepe, pe so onposi pirpolo le towa le pe pailolo pirpeiye, “Yoi towa - towa.” ");
INSERT INTO ong_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wusoli pe yeflipiye puluwo le pe turwepe olpe pire tekekeye. Jisas frou lirpepeye, “Topo weli, turise pato, kuna ki.” ");
INSERT INTO ong_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Leye lo Jisas longlo lingepe le nimpe teingo lepe le yuf kere. Pupam pele pinlele potei olpe, ");
INSERT INTO ong_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","wusoli pe wala pironom pire lufe wuso le karipe watepe mete wurutei pepe lo pe enke pelpe olo kapi nampliepe oloye. ");
INSERT INTO ong_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pe pe fale plen liti Genesaret le pe topuwo nimpe teingo laitei lepe. ");
INSERT INTO ong_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wem pe konko pualo nimpe teingo, mete frou puluwo matufuwo Jisas-ye. ");
INSERT INTO ong_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pe so pantutu pe tef ili yefliye, le pe pilape mete wuso kainu pepe, paptei puwo poi, pe so pilape pau paptowo Jisas. Le le lifei lo ratei tulum fei lepe, pe ma karowo pe. ");
INSERT INTO ong_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Le Jisas linei linei le, le uf walem kumpu eryai pepe, lo liom pelpe, mete ma pilape mete wuso kainu pepe, pe pilape pe fale tulum piti paptetei re paisesipe oweli le pe ma pirpowo Jisas piti ma lusape mete wuso kainu pepe, pe ma pesiepe olongou us pele. Le mete wuso kainu pepe, pe pesiepe olongou us piti Jisas pele le pe yeflipiye nou fale teingipe. ");
INSERT INTO ong_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mete piti Farasi le mete piti peptalo mete nemple pire il lipi piti Moses pe pato Jerusalem so pau, pe pau panfi Jisas. ");
INSERT INTO ong_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Pe pulwepe pupam ilepe piti Jisas pele pe pire esi opinge paplei oweli. Mete piti Farasi pe pingio tisi lelpe piti ma pinu kaptetei esi wo pe soma paplei oweli pelpe le pe pirpei piti mete nemple re pe ma pingiepe. ");
INSERT INTO ong_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Wusoli mete piti Farasi le mete yeflipi piti Juda re pe pingiepe il wuso manre yaire pelpe peptalo. Pe ma paplei oweli kolo, wala ma kaptetei esi pelpe poporo wo pe soma paplei oweli, ");
INSERT INTO ong_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","lo oweli men piti pau tulum liti paptetei re paisesipe, pe ma pinu kaptetei wo. Le pe pingiepe il wuru wuso pe kapi piti manre yaire pelpe pepe. Il watafei pe ma pingio tisi loporo, wai lelpe piti kaptetei wengle esi pelpe, minki, waifilengi le poi pelpe piti petei. ");
INSERT INTO ong_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Liso mete piti Farasi le mete piti peptalo mete nemple pire il lipi piti Moses, pe peletei Jisas polpepei, “Piti polomen so pupam peiye pe pingiepe il wuso manre yaire pouku nampli pirpouku pepe, pe pingiepe kolo olo. Wolo pe paplei oweli pasiepe esi opinge pepe?” ");
INSERT INTO ong_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisas namti lirpepeye, “Ma Ili lirpei punkom lireise wem le lirpei il falowo nemi liti metine nimou Aisaia. Ise mete piti nel loli ilo ilo, min watafei Aisaia sungoi laptei il lirpei lolpepei, ‘ “Ma Ili lirpeiye, mete pepei pe rautuki pire nemi pelpe, wolo enke pelpe olo pato fiyintei. ");
INSERT INTO ong_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pe ma rautuki yaupe kolo olo, wusoli pe peptalo mete nemple pire il piti mete piti tef pelpe le pe pirpolo pe il piti Ma Ili pele.’ ");
INSERT INTO ong_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Il lipi piti Ma Ili pele ise weisipe paiteiye le ise yulpope il piti mete piti tef pelpe peitaloise piripe pepe.” ");
INSERT INTO ong_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Le Jisas wala lirpei lasiepe lolpepei “Ise retawo tisi yoporotei piti yinaulipe il lipi piti Ma Ili, le ise yolpepe piti ma yirkilau yingiepe il wuso peise yeitalo isotei yiripe pepe. ");
INSERT INTO ong_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Wusoli Moses lirpei lolpepei, ‘Ye ma rautuweme nimou nire yaitei meiye,’ le ‘Minele piti lirpei il olpe lirime nimou re yaitei mele, metine fei lepe ma petesi la.’ ");
INSERT INTO ong_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wolo ise yeptalo mete yolpepei, wuso metine nele le oweli men nange pele le miso liripe piti kanieme nimou lo yaitei mele wolo ise ma yirpei yolo, fei pepe le laptei watowo Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Metine fei lepe le kanieme nimou re yaitei mele kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ise fei yolpepe, ise tounga pesipe il piti Ma Ili le ise yeptalo mete yire il peise isotei. Le il wuru watafei il pepei, ise yingiepe.” ");
INSERT INTO ong_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Leye lo Jisas linape mete wurutei pepe pe pau panfi le le lirpepeye, “Ise yeflipiye yingiteiki le ise ma retape. ");
INSERT INTO ong_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Menele piti lato towa yawi le le lautile nemi liti metine wape, menele fei lepe le miso lirowo metine oli kolo olo. Menemple piti pratei leinginim le pe naro pau, men fei pepe miso pirowo metine wape lepe oli. ");
INSERT INTO ong_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yingitei, wuso ise mingim paitei piti ma yingitei.” ");
INSERT INTO ong_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wem Jisas lusape mete wurutei pepe le le linki le winem, pupam pele peletei pire il kauro yuwei wuso linu lirpei pepe. ");
INSERT INTO ong_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jisas lirpepeye, “Ise wala fupeiteteise watafei mete nemple pepe lom? Ise wala retai kolo lom? Menemple piti pato towa yawi le pe peingalo pe nemi liti metine wape, pe miso pirowo metine lepe oli kolo olo, ");
INSERT INTO ong_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","wusoli pe pautile pe onom pele kolo olo, pe pratei yofu yawi le pe nou naro pe yawi peye.” (Jisas lirpei il pepei le le laptei oweli eryai pepe pe teingipe piti maplei.) ");
INSERT INTO ong_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Le Jisas wala lirpei lasiepe lolpepei, “Menemple piti pratei metine leinginim le pe noro pau, fei pepe soma pirowo metine oli lepe. ");
INSERT INTO ong_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wusoli piti pato leinginim, pato onom piti metine soma il olpe falele, peilawo onom piti laulelipe nimoure ausi, piti ma lire ausi, piti ma letesi metine nele la, ");
INSERT INTO ong_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lauleline moto piti metine nele, lire filau le le lingiepe il olpe eryai pepe. Le lempesisipe mete, le telpalo ratei loporo watafei mete wuru pepe kolo olo, le onom kotu lire mete nemple yaupe, il punkom kolo olo, wolo le ma kesipe le lirpepe mete nemple, le ma leila nange lele lotei, le il men le lirpei il pele ma yuwas ye yaupe. ");
INSERT INTO ong_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Il olpe yeflipi fei pepei, pe pratei metine wape leinginim so falele le pe pirowo metine wape lepe oli.” ");
INSERT INTO ong_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Leye lo Jisas lusa tulum fei lepe le le le tef malfem lire uf ili Tair. Le le linki winem nele le le lirpolo mete nemple miso pretai le lifei winem lepe kolo olo, wolo olo pe paltei alepe niminye. ");
INSERT INTO ong_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Moto nenpe ne ningio pene riri oli lunkuwene. Moto nepe ne ningitepe pirpei piri Jisas le ne so frou ne falowo le ne nualo ratei ire pele. ");
INSERT INTO ong_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Moto nepe ne piti uf tef nele. Nimou pene nilane ratei Fonisia lato tef liti Siria. Ne nirpowo Jisas piti ma laltu riri oli lepe taniene ningio pene. ");
INSERT INTO ong_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Wolo Jisas namti lirpeneye, “Usauku watepe eple kumpu oweli paplei pinu wo. Oweli piti eple kumpu pelpe le ku ma kapi watepe pelem kolo olo, fei pepe olo wanketei.” ");
INSERT INTO ong_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ne namti nirpowo Jisas nolpepei, “Ili leiki, pelem piti pato ponu tef, pe ma paplei oweli ilepe wuso eple kumpu paplei le ilepe puwalolo pepe.” ");
INSERT INTO ong_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Liso Jisas lirpeneye, “Ye nou irpeiki il pepe so ye ma e winem leiye. Riri oli lepe olo naro le taniene ningio peiye ye.” ");
INSERT INTO ong_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Fei moto nepe ne nou ne winem lene le ne nulwene ningio pene netei nuwo poi, le punkomtei, riri oli lepe olo naro le tanieneye. ");
INSERT INTO ong_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Leye lo Jisas lusa tef piti lire malfem lire uf ili Tair lepe, lusa le le le linge tef liti Saidon re Dekapolis le le fale tuluple Galili. ");
INSERT INTO ong_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mete nemple pila metine nele le mingim olpe le il re lirpei kolo, il palelei. Pe pila pau paltowo Jisas le pe pirpowo piti ma laltei eti lele luwowo metine wuso mingim olpe re il palelei lepe. ");
INSERT INTO ong_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Liso Jisas kesi metine lepe lila le taniepe mete wuru pepe le le lafo esi niringi pautile mingim piti metine lepe pele. Le le larwepe esi pele tunku le le lesio noni liti metine lepe. ");
INSERT INTO ong_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Leye lo Jisas luntoli le teplai yuwei le le lirpei narwi lotei le le lirpowo metine lepe lolpepei, “Efata.” Il pal pirpei polo “Il falele.” ");
INSERT INTO ong_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Frou yo fei metine lepe mingim pele pautu lingiteiye le noni nou lirpepei il loporoye. ");
INSERT INTO ong_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Leye lo Jisas lirpepe mete yeflipi pepe piti ma pirpepe mete nemple kolo olo wolo, wem Jisas lirpei, pe pirkilau kete il pirpepe mete nemple piri le. ");
INSERT INTO ong_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Le mete wuso pingitepe il piri Jisas lepe pe yeflipiye pinlele potei. Pe yafei pirpeiye, “Men nange yeflipiye, le lesiepe loporotei. Le laptei mete wuso pe mingim olpe, pe nou pingitei le mete wuso il nemi paplei pe nou pirpepei.” ");
INSERT INTO ong_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wem nele mete wurutei nou pau panfi nemple, le pe oweli men piti paplei pepe olo, Jisas linape pupam pele pau le le lirpeiye, ");
INSERT INTO ong_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ki onom manepe mete pepei wusoli pe pireiki mratei epli wem twinges le niliyeye fei, le pe fei oweli piti paplei pepe olo. ");
INSERT INTO ong_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wuso ki watepe oweli men piti paplei kolo olo, le ki kaisipe pe uf pelpe, pe ma lus peinei le pe pualo tisi wusoli ilepe pelpe, pe pau uf fiyen.” ");
INSERT INTO ong_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Pupam pele pirpowoye, “Tef oli era re telmane ye yawi fei lepei, minemple miso perengape oweli wuru piti watepe mete wurutei pepei?” ");
INSERT INTO ong_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisas lepleteiye, “Ise lufe polomen?” Le pe namti pirpowoye, “Lufei pire eti plen te twinges.” ");
INSERT INTO ong_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jisas lirpepe mete wurutei pepe piti ma pungura pratei pinge tef. Leye lo le kapi lufe wuso pire eti plen te twinges pepe, le leletei Ma Ili liripe le le karipe watepe pupam pele piti ma pilape pe watepe mete wurutei pepe le pupam polpepeye. ");
INSERT INTO ong_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pe ningu re pelpe kumpu yaipiyeye. Jisas leletei Ma Ili liripe le le lirpepe pupam pele piti ma kapi pilape pe watetepe mete. ");
INSERT INTO ong_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mete wurutei pepe paplei lufe re ningu kumpu pepe le pe yefi tangupu. Mete wuso paplei pepe pe wurutei (4,000). ");
INSERT INTO ong_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Leye lo pupam pepe pe tonwipe oweli ilepe pafo pora pire eti plen te twinges faleye. Fei Jisas laisipe mete pe tani, ");
INSERT INTO ong_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","le le frou longlo nimpe teingo liripe pupam pele pe tef liti Dalmanuta. ");
INSERT INTO ong_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mete ilepe piti Farasi pe pau falowo Jisas le pe pire il pura nemple. Pe pirpolo ma puluwo waipiti le fupeletei pe so peletei piti ma lirpei le men nange pepe potei pire tute fale piti ma kosape le lire singe piti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisas lusa nempi lirkilau le le lirpei lolpepei, “Piti men so mete piti wem fei lepei, pe peiteiki piti ma kirpei le men nange potei pire tute fale pepe? Olo, ki kirpeise. Mete pepe ki ma kosape kire men kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jisas lusape le le nou longlo nimpe teingo lepe, nou le tuluple mingo plen leye. ");
INSERT INTO ong_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jisas pupam pele pe onpete il piti pilape lufe wuru pe le pe pila luom niliyeye pe nimpe teingo lepe. ");
INSERT INTO ong_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisas lirpepeye, “Kotopa isotei yire yis liti mete piti Farasi le yis liti Herot.” ");
INSERT INTO ong_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Fei pupam pepe pe pirpei nempleiye, “Le lirpei il pepei wusoli ku luom olo.” ");
INSERT INTO ong_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas retai il men pe pirpei le so lepleteiye, “Piti men ise yirpeinemple yirpolo ise luom olo pepe? Ise wala yironom lom? Enke peise olo lipitei lom? ");
INSERT INTO ong_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ise lutepe peise poli le ise yuntoli lo olo? Ise mingim peise paitei lo olo? Ise retai lo olo, ");
INSERT INTO ong_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wem ki karipe lufe pire eti plen watepe mete wurutei (5,000) pepe? Oweli ilepe wuso ise tonwipe pepe le ise yafo pire pora polomen?” Le pe namti pirpowoye, “Pora pire eti plen le plen te twinges.” ");
INSERT INTO ong_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jisas nou lepleteiye, “Le wem ki karipe lufe pire esi plen te twinges watepe mete wurutei (4,000) pepe le oweli ilepe pepe ise yafo pire pora polomen?” Le pe namti pirpowoye, “Pora pire esi plen te twinges.” ");
INSERT INTO ong_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Fei Jisas lepleteiye, ‘Le ise wala yironom lom?” ");
INSERT INTO ong_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jisas lire pupam pele pau fale Betsaida le lepe mete nemple pe pila metine nele lutepe olpe. Pe pila pau paltowo Jisas le pe pirpowo piti ma lesio metine lepe. ");
INSERT INTO ong_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisas lesio eti liti metine wuso lutepe olpe pepe le le kesi rounge te tani uf lepe. Jisas larwepe tunku lutepe piti metine lepe re fei, Jisas leptalo esi pele puwo metine lepe le le leletei lolpepei, “Ye miso uluwo men lo olo?” ");
INSERT INTO ong_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Fei metine lepe le leila oru luntoli le le lirpeiye, “Iyo, ki miso kulwepe mete wolo pe watafei nimpe kotu pilele peinenei pau pe pepe.” ");
INSERT INTO ong_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisas nou laptei esi pele puwo lutepe piti metine lepe. Wem fei lepei metine lepe le luntoli lirkilau le lus filim kere le le lulwepe men nange pepe loporoye. ");
INSERT INTO ong_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Leye lo Jisas laisi le winem lele le Jisas lire il singe lirpowo metine lepe lolpepei, “Ye ma nou e uf kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Leye lo Jisas liripe pupam pele pe uf walem pingene Sisaria, lato tef liti Filipai. Wem pe wala pe pualo tisi, Jisas lepletei pupam pele lolpepei, “Yirpeiki, mete pirpei ki minele?” ");
INSERT INTO ong_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Le pe namti pirpowo polpepei, “Mete ilepe pirpei polo ‘Ye Jon liti kaptetei mete.’ Ilepe pirpei polo, ‘Ye Ilaija,’ le ilepe pirpei polo, ‘Ye metine nimou nele’.” ");
INSERT INTO ong_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jisas lepleteiye, “Le ise? Ise yirpei yolo ki minele?” Pita namti lirpowoye, “Ye Mesaia.” ");
INSERT INTO ong_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Leye lo Jisas lire il singe lirpepeye, “Ma yirpepe mete nemple yireiki ki kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Leye lo Jisas leptalo pupam pele lolpepei, “Ninge liti Metine Wape le ma lila moingi ili le mete lipi piti pinuwepe mete piti Juda le mete lipi piti pinuwepe mete piti peptawio Ma Ili siye le mete piti peptalo mete nemple pire il lipi piti Moses, mete fei pepe pe ma pinauli. Pe ma paltei la le epli wem twinges niliyeye kari, le ma nou leilo.” ");
INSERT INTO ong_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas lirpei il pepei nomnaipe oloye. Liso Pita kesi lila le taniepe pupam yeflipi pepe le le lirkilau lampowo Jisas piti nou lirpei il pepe kolo. ");
INSERT INTO ong_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wolo Jisas lile weitei, lulwepe pupam pele le le lirkilau lirpei lawo Pita lolpepei, “Metine eringi leiki, ye e taniki. Ye onposiepe il watafei metine liti tef, Ma Ili olo, le onposiepe lolpepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Leye lo Jisas linape pupam re mete wurutei pepe paule le le lirpepe lolpepei, “Wuso minele lirpolo le ma lingeiki lau, le ma onposi lotei kolo olo. Le ma lila moingi lele le le lulteiki ki. ");
INSERT INTO ong_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wusoli metine minele lirpolo le miso kane lotei, le ma lalingou nempi lele. Le metine minele wuso lalingou nempi lele lireiki ki le il piti Ma Ili, metine fei lepe le ma lirowo teingi nempi lele. ");
INSERT INTO ong_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wuso metine le rotope oweli men nange piti tef fei lepei le nempi lele olo le lailolowo kolo, le ma kali menele teingi lo ma olo? Ma olo. ");
INSERT INTO ong_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Metine ma laltei men watowo Ma Ili piti le ma nou kali nempi lele, olo. ");
INSERT INTO ong_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mete piti fei pe mete piti pingiepe il olpe le wuso metine nele le topo tapune lireiki ki le il peiki wuso keptalo pepe, metine fei lepe Ninge liti Metine Wape ma namti topo tapune liri wem le lire ririm teingipetei piti Ma Ili, pe ma paule pire singe lipi piti Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Le Jisas lirpei lasiepe lolpepei, “Ki kirpeise punkom, mete ilepe fei pile lepei pe wala miso pa kolo le pe ma puluwo wem teingi piti Ma Ili ma laule lire singe pele piti ma luntoluwepe mete piti tef.” ");
INSERT INTO ong_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Epli wem pire eti plen le niliyeye fei Jisas kesi Pita, Jems re Jon pepi pe. Pe poteteiye le Jisas linuwepe pe punwei tumun nele yuweitei. Wem pe puntoli pato, Jisas weitei lire metine nele, ");
INSERT INTO ong_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","le olongou pele weitei pire fiyu olo pininiye, metine nele liti tef re miso kaptetei olongou pele le pe fale teingipe fiyutei fei polpepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Leye lo pupam twinges le niliyeye pepe pe pulwenge Ilaija lire Moses rounge tire Jisas pepi pirpei. ");
INSERT INTO ong_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita nempi nemi lirpowo Jisas lolpepei, “Ye metine piti eitalouku, pe teingipe piti ku fei mratei lepei. Ku ma kaptu winangou pal kumpu twinges le niliyeye, nele leiye, nele liti Moses le nele liti Ilaija.” ");
INSERT INTO ong_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita lire Jems re Jon olo turwepe olpetei pire tekekeye, il men ma pe onposiepe piti pirpei olo pos pratei yaupe. ");
INSERT INTO ong_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nopom nele fale lapulwepe le il nemple fale nopom lepe pirpei polpepei, “Ninge lepei, le leiki neleiyeyetei, yaptowo mingim.” ");
INSERT INTO ong_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pe frou puntoli lupkarere wolo puluwepe minemple re kolo olo, Jisas loteteiye liripe pile. ");
INSERT INTO ong_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wem pe wala pititipi tumun lepe pe, Jisas il polwepe lolpepei, “Ise ma yirpepe mete nemple yire menemple wuso ise yulwepe pepe, ma yirpepe pato wala ma yungario Ninge liti Metine Wape ma la le le ma nou leilo wo.” ");
INSERT INTO ong_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pe paptowo mingim wolo pe poteteiye yaupe, pe pirpei nemple pire il wuso Jisas lirpei pepe. Pe peite nemple polpepei, “Il pal piti pa le pe nou peilo pepe, pe pato fei polomen?” ");
INSERT INTO ong_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Le pe peletei Jisas polpepei, “Piti men so mete piti peptalo mete nemple pire il lipi piti Moses pepe, pe pirpei polo Ilaija ma linu lau lepe?” ");
INSERT INTO ong_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jisas namti lirpepe lolpepei, “Ilaija linu lau punkom piti ma kesipe men nange laptei elpesipe pratei. Wolo piti men so il piti paitei yousi, pe pirpei polo Ninge liti Metine Wape ma lila moingi ili le mete ma pinauli lepe? ");
INSERT INTO ong_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ki kirpeise, Ilaija olo linu lauye le mete pauli onom pirowo niliye, min watafei il piti paitei yousi pe pirpei pepe.” ");
INSERT INTO ong_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wem Jisas liripe Pita, Jems re Jon, pe nou pe puwalipe pupam yeflipi pepe, pe pulwepe mete wurutei panfipe pupam pepe. Mete ilepe piti peptalo mete nemple pire il lipi piti Moses, pe piripe pupam pepe pepi pire il pura nemple. ");
INSERT INTO ong_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wem mete pepe pe puluwo Jisas, pe pinlele potei olpe le pe pantu pe peisi. ");
INSERT INTO ong_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisas lepletei pupam pele lolpepei, “Ise yiripe yepi yire il yura nemple yire men?” ");
INSERT INTO ong_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Fei metine nele wuso leingalope mete wurutei pepe, le namti lirpowo Jisas lolpepei, “Ye metine piti eitalouku, ki kila ninge leiki kau kalteiye wusoli le riri oli lunkuwo le le kapi il namplio. ");
INSERT INTO ong_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wem riri oli lepe lunkuwo, le ma liri kumpu lepe lualo tef, tuwamou falele nemi lele, nilpe pentei nemple le le loli niliye. Ki kepletei pupam peiye piti ma paltu riri oli lepe naro tanio kumpu lepe wolo pe polpepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Fei Jisas lirpepeye, “Ko polomen so ise mete pepei, ise yulpope il piti Ma Ili kolo olo pepe? Wem fei polomen ma ki kireise mratei? Wem fei polomen ma ki kila moingi leise. Yila kumpu lepe yau yalteiki.” ");
INSERT INTO ong_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Fei pe pila pau paltowo Jisas. Wem riri oli lepe le luluwo Jisas, le lunkuwo kumpu lepe le kumpu lepe punwewi, le lualo lato weitetei linge tef le tuwamou falele nemi. ");
INSERT INTO ong_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Le lolpepei lato wem fei polomen?” Jisas leletei yaitei liti kumpu lepe. Le yaitei liti kumpu lepe le namti lirpowo Jisas lolpepei, “Wem le wala kumpu so lau. ");
INSERT INTO ong_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wem wuru, riri oli lepe le liri kumpu lepe linki weli le le liri leingalo tipe piti ma la. Ye onom manouku le ye kanouku, wuso ye miso olpepe.” ");
INSERT INTO ong_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Fei Jisas lirpeiye, “Iyo, wuso ye miso olpepe. Metine wuso lulpope il piti Ma Ili, le miso lesiepe men nange eryai.” ");
INSERT INTO ong_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yaitei liti kumpu lepe le frou lirpowo Jisas lolpepei, “Ki kulpope il piti Ma Ili wolo wisyauye. Ye kaneiki piti ma kirkilau kulpope.” ");
INSERT INTO ong_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisas lulwepe mete wuso pirkilau neinenge tepe le so lire il singe lirpowo riri oli lepe lirpeiye, “Ye riri oli piti watepe mete mingim olpe le ye kapi il nampliepe, ki kirpeiye ye naro tani kumpu lepe le ye ma nou unkuwo kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Riri oli lepe lailolo, le lunkuwo kumpu lepe le kumpu lepe punwewi lirkilautei le riri oli lepe naro tanioye. Kumpu lepe olo la lire pulouye liso mete yeflipiye pirpei polo, “Le olo laye.” ");
INSERT INTO ong_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Wolo Jisas lesio eti liti kumpu lepe le le kanowo piti ma leilo, le kumpu lepe leilo lile. ");
INSERT INTO ong_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jisas linki le winem re fei, pupam pele poteteiye yaupe, pe peleteiye, “Piti polomen so ku maltu riri oli lepe le le naro le kolo olo lepe?” ");
INSERT INTO ong_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Le Jisas namti lirpepeye, “Ise ma yeletei Ma Ili le le loteteiye miso laltu riri oli watafei lepei le tani, men nange ma olo.” ");
INSERT INTO ong_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Pe pusa tulum fei lepe le pe pinge tef liti Galili pe. Jisas linaulo piti ma mete nemple pe pretai tulum piti le ratei kolo olo, pe ma pretai kolo olo, ");
INSERT INTO ong_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","wusoli le wala leptalo pupam pele lolpepei, “Ninge liti Metine Wape ma pe paltei le esi piti mete le pe ma petesi la. Epli wem twinges le niliyeye kari, le ma nou leilo.” ");
INSERT INTO ong_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pupam pele pe pire wouye pire il wuso le leptalo liripe pepe le pe turwepe piti peletei pire il fei pepe. ");
INSERT INTO ong_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pe pe fale Kaperneam le wem pe pinki pe pifei winem re fei, Jisas lepletei pupam pele lolpepei, “Wem ku wala mau mualo tisi le ise yire il yura nemple yire men?” ");
INSERT INTO ong_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wolo pe namti pirpowo kolo olo wusoli wem pe wala pato tisi pe pire il pura nemple pire minele le linuwepe. ");
INSERT INTO ong_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisas lungura lifei, le linape pupam pele wuso pire esi plen le plen te twinges pepe le le lirpepeye, “Minele lirpolo le ma linu lepe le ma leite lotei le lingi le ise yeflipiye, le ma lesio towa leise.” ");
INSERT INTO ong_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jisas kesi ninge kumpu nele le le laltei lile onom pelpe. Leye lo Jisas kesipe esi pele laungi kumpu lepe le le lirpepe pupam pele lolpepei, ");
INSERT INTO ong_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Metine minele le onposiki le le lailolowo nele kumpu watafei lepei, metine fei lepe le laileleiki ki. Le metine minele wuso laileleiki lepe, le laileleiki ki kuteteiye kolo olo, minele wuso laiteiki kau lepe re metine fei lepe le lailolouku roungesye.” ");
INSERT INTO ong_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon lirpowo Jisas lolpepei, “Ye metine piti eitalouku, ku muluwo metine nele le lire nange leiye laptu ririm olpe le ku mirpowo piti ma nou lolpepe kolo olo wusoli le louku kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisas lirpepeye, “Ise il kari kolo olo wusoli metine minele wuso lire nange leiki lirpei le men nange potei pire tute fale pepe le miso nou frou lirpei il men olpe lireiki kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wusoli minele piti lirouku mepi mire nemple eringi kolo olo, metine fei lepe le louku. ");
INSERT INTO ong_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ki kirpeise punkom, metine minele wuso waise tipe liti yalei wusoli ise piti Krais, metine fei lepe Ma Ili ma lailolowo.” ");
INSERT INTO ong_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Wuso kumpu nele watafei kumpu lepei le lulpope il peiki, wolo metine nele le weisi linge tisi oli, pe ma pato poporo wuso metine fei lolpepe lepe ku ma maltowo erau ili lultei ilyongo lele le ku ma miri lautile peryai. ");
INSERT INTO ong_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Le wuso eti leiye le weiteiye ingi tisi oli, alowi tani. Ye ma ailele yotei piti ma ratei ingi wem wem wuso eti oli lepe ye alowi tani, olo ma e uf oli, e weli piti loli ratei lolpepe. ");
INSERT INTO ong_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tulum lepe yemnuwongou pelpe miso pa kolo olo le weli re miso palu kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Le wuso urou leiye le weiteiye ingi tisi oli, alowi tani. Ye ma ailele yotei piti ma ratei ingi wem wem wuso urou oli lepe ye alowi tani, olo ma e uf oli. ");
INSERT INTO ong_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tulum lepe yemnuwongou pelpe miso pa kolo olo le weli re miso palu kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Le wuso lutepe leiye leiteye ingi tisi oli, kotuwo iri tani. ye ma ailele yotei wuso ye ila lutepe niliyeye e uf teingi liti Ma Ili olo ma lireiye e uf oli. ");
INSERT INTO ong_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tulum lepe yemnuwongou pelpe miso pa kolo olo le weli re miso palu kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wusoli mete wuruye pe ma fale teingipe watafei sol. ");
INSERT INTO ong_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sol teingi flou le wuso flou lele lepe le naro tanio, ye ma nou weisi fale teingi flou fei olomen? Ye ma oungai sol, teingi, il flou le ye miso iripe mete nemple yepi ratei yire onom malye.” ");
INSERT INTO ong_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Leye lo Jisas lusa tulum fei lepe le le le tef liti Judia le le le lalowi wof Jodan. Mete wurutei nou pualo nemple pau panfi le wai lele, le leptalo watafei wem oli oli wuso lepe, le leptalo pepe. ");
INSERT INTO ong_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mete ilepe piti Farasi pe pau falowo Jisas le pe pirpolo ma puluwo waipiti le fupeletei lo olo. Pe so peleteiye, “Ye irpouku, il lipi pouku pe pirpei polo metine nele le miso laisine moto pele ne tanio lo ma olo?” ");
INSERT INTO ong_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisas namti lepletei lolpepei, “Il lipi men so Moses waise pepe?” ");
INSERT INTO ong_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pe namti pirpowo Jisas polpepei, “Moses lirpouku lirpolo metine nele le miso laptei il paitei yousi le le laisine moto pele ne tanio.” ");
INSERT INTO ong_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Fei Jisas lirpepeye, “Moses lapteise lope il lipi pepei wusoli ise mete piti enke lipi. ");
INSERT INTO ong_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","wolo wem linutei, wem Ma Ili laptei tef, teplai re men nange pepe, il pirpei polo le lamtei metine wape le moto wape. ");
INSERT INTO ong_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Le min fei polpepei so metine ma lusame nimou re yaitei le le ma lompetene moto le me roum ma maiteneme. ");
INSERT INTO ong_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Le me roum ma fale nemiyeye. Me roum ire pelme fi fi kolo olo, me roum nemiyeye. ");
INSERT INTO ong_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Menemple Ma Ili laptei lapwonou, metine miso karipe laptei ire pelpe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wem pe nou pinki pe winem, Jisas pupam pele peletei pire il wuso linu lirpepe pepe. ");
INSERT INTO ong_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jisas lirpepeye, “Metine minele wuso laisine moto pele ne tanio le le laisene moto nenpe, metine fei lepe le metine piti laisepe nimoure lusasape. ");
INSERT INTO ong_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Le wuso moto nenpe ne re nusa munge lene le ne nou naise munge nele, ne moto piti naisepe mungarem nusasape.” ");
INSERT INTO ong_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Fei mete nemple pe pilape eple kumpu pau paptowo Jisas piti ma lesiepe wolo pupam pele pirpei lape. ");
INSERT INTO ong_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wem Jisas lulwepe polpepe le onom kotu le le lirpepe pupam pele lolpepei, “Yusape eple kumpu pepe pau ki, le ise il karipe kolo olo, wusoli wem Ma Ili luntoluwepe mete piti tef, le ma luntoluwepe mete watafei eple kumpu pepei. ");
INSERT INTO ong_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ki kirpeise punkom, minele piti weitei lire ninge kumpu kolo olo, le ma le uf teingi liti Ma Ili kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Leye lo le kapi eple kumpu pepe lesiepe le le leptalo esi pele puwope pe fi fi le le leletei Ma Ili piti ma luntoluwepe re lailelepe. ");
INSERT INTO ong_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wem Jisas lilele le, metine nele lantu lau falowo. Le yaru yamkelem ratei le le leletei Jisas lolpepei, “Ye metine teingi piti eitalouku, ki ma kesio towa men piti ma ki kali nempi liti kratei kingi wem wem lepe?” ");
INSERT INTO ong_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisas namti leleteiye, “Piti men so ye inaiki ki metine teingi lepe? Metine minele re teingi kolo olo, Ma Ili loteteiye le teingi. ");
INSERT INTO ong_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ye retape il lipi wuso pirpei polpepei “Ye ma etesi metine nele la kolo olo, ye ma auleline moto piti metine nele kolo olo, ye ma ire ausi kolo olo, ye ma empesipe mete nemple kolo olo, ye ma rautuweme nimou nire yaitei meye le ye ma apteme mingim.” ");
INSERT INTO ong_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Fei metine lepe le namti lirpeiye, “Ye metine piti eitalouku, wem ki wala kumpu ki kingiepe il lipi fei pepe’.” ");
INSERT INTO ong_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas lupoluwo le le onom teingine lasio le le lirpowo metine lepe lolpepei, “Menele niliyeye fei lepei ye ma kali altei yotei. Ye e kapi oweli men nange peiye aptei yeflipiye pe mete nemple paisepe le ye ma kapi era weisipe watepe mete wuso pe oweli yini re olo pepe, le ye miso kapi men nange wurutei pratei uf teingi liti Ma Ili. Leye lo ye ma au ulteiki.” ");
INSERT INTO ong_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wem metine fei lepe le lingitepe il fei pepei, le mati lele weitei oli, onom re one le le leye wusoli le oweli re yini pele olo wurutei. ");
INSERT INTO ong_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisas lulwepe pupam pele leinei leinei le le lirpeiye, “Mete wuso pe oweli yini wurutei pepe, pe ma pau uf teingi liti Ma Ili kolo olo, pe ma pinu pila moingi ilitei wo pe soma pau.” ");
INSERT INTO ong_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pupam pele pe pinlele potei pire il pepe wolo Jisas nou lirpei lasiepe lolpepei “Eple peiki, tisi piti le uf teingi liti Ma Ili lepe olo kumputei. ");
INSERT INTO ong_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Metine wuso oweli yini pele wurutei pepe, le miso le uf teingi liti Ma Ili kolo olo, wolo kamel, ne miso ninki nample liti si piti miri mengleleipe olongou pepe.” ");
INSERT INTO ong_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jisas pupam pele olo pinlele potei olpetei le pe peite nempleiye, “Minele miso Ma Ili kanowo?” ");
INSERT INTO ong_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Fei Jisas lupoluwepe le le namti lirpepeye, “Metine miso lolpepe kolo olo wolo Ma Ili, le miso lolpepe. Ma Ili miso lesiepe men nange eryai.” ");
INSERT INTO ong_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Leye lo Pita nempe nemi lirpeiye, “Untoli, ku musape men nange pouku le ku multeiye.” ");
INSERT INTO ong_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisas lirpepeye, “Iyo, le ki kirpeise punkom, metine minele wuso lusa winem lele lo ilim winkem pele, lo eri pele lo nimou lo yaitei mele, lo eple lo liom lele wusoli le lulteiki ki le le leptalo il piti Ma Ili, ");
INSERT INTO ong_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","metine fei lepe wem le wala namin ratei, le ma kapi men nange wurutei, winangou, ilim winkem, eri, emare, eple le liom le le ma lila moingi. Le wem le la, le ma nou kali nempi liti ratei lingi wem wem. ");
INSERT INTO ong_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wolo mete wuru wuso fei pinu pepe pe ma nou weitei pingi le mete wuru wuso fei pingi pepe pe ma namti pinu.” ");
INSERT INTO ong_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pe pingio tisi liti punwei pe Jerusalem. Jisas linuwepe pupam pele le le pe pulsesi pingi, lus ye patoto le mete wuso pulsesi Jisas pingi pepe re pe turwepe. Jisas nou kesipe pupam pele pe ire pelpe taniepe mete wuru pepe le le lirpepe lire men nange wuso ma falowo pepe. ");
INSERT INTO ong_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jisas lirpepeye, “Yingitei, ku ma munwei me Jerusalem le pe ma paltei Ninge liti Metine Wape le esi piti mete lipi piti pinuwepe mete piti peptawio Ma Ili siye le mete piti peptalo mete nemple pire il lipi piti Moses. Pe ma pamtuwo yawi piti ma la le pe ma paltei le esi piti mete piti alpe nemple. ");
INSERT INTO ong_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mete piti alpe nemple pepe pe ma palwe oli piri, paruwo tunku, pire foiye petesi le pe ma petesi la. Le epli wem twinges le niliyeye kari le ma nou leilo.” ");
INSERT INTO ong_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Leye lo Jems lire Jon, eple winge titi Sebedi, te tau falowo Jisas le te tirpei tolpepei, “Ye metine piti eitalouku, ku ma wirpeiye men fei pepei le ye ma ingiepe.” ");
INSERT INTO ong_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Ki ma kingiepe il men peise rounge?” Jisas loutetei. ");
INSERT INTO ong_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Le te namti tirpowoye, “Wem ye ifei tile teingipetei piti Ma Ili, ye ma usauku ku wireye mepi mifei, nele lifei eti tilpi leiye, le nele lifei eti enkau leiye.” ");
INSERT INTO ong_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisas lirpengeye, “Ise rounge retai men fei rounge yeiteiki yiri lepe kolo olo. Moingi wuso ki ma kila lepe, ise rounge miso yila lo ma olo? Ise rounge miso yungungu watafei ki ma kungungu lepe lo ma olo?” ");
INSERT INTO ong_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Le te namti tirpowoye, “Ku miso wolpepe.” Fei Jisas lirpengeye, “Moingi wuso ki ma kila lepe, ise rounge re miso yila le tipe wuso ki ma kungungu lepe re, ise rounge miso yungungu. ");
INSERT INTO ong_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wolo piti rounge ma nele lifei eti tilpi le nele lifei eti enkau lepe, ki ma kirpei kolo olo. Ma Ili lotei soma watepe tulum fei pepe pe mete wuso pele keineipe piti ma laptei pifei pepe.” ");
INSERT INTO ong_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wem pupam yeflipi pepe pe pingitepe il pepei, pe enke kotu piringe Jems re Jon. ");
INSERT INTO ong_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Liso Jisas linape pupam pele yeflipiye paule le le lirpepeye, “Ise retai, mete wuso paptei piti ma puntoluwepe mete nemple pepe, pe ma puntoluwepe le mete nemple pepe, pe ma paptepe mingim ");
INSERT INTO ong_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ise ma yolpepe kolo olo. Wuso nele leise lirpolo le ma luntolise, le ma lesio towa leise wuruye, ");
INSERT INTO ong_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","le wuso nele leise lirpolo le ma linuse, le ma lesio towa leise wuruye, lesio yawi. ");
INSERT INTO ong_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wusoli Ninge liti Metine Wape le laule piti ma mete pesio towa lele kolo olo, le laule piti ma lesio towa lelpe le le ma la lungwipe mete wuru.” ");
INSERT INTO ong_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pe pau fale Jeriko. Wem Jisas lire pupam pele le mete wuru pepe, pe pusa Jeriko le pe pe, metine nele lutepe pele olpe. Le nange lele Batimaes, ninge liti Timeus, le ratei tisi lunko le le linanape mete piti ma kanowo. ");
INSERT INTO ong_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wem le lingitepe pirpei peisi Jisas liti Nasaret, le lailolo lirpeiye, “Jisas, ninge liti Devit, ye onom maneiki.” ");
INSERT INTO ong_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mete wuru pirpei lawo le pe pirpowo piti ma pos lato. Wolo le lirkilau lailolo lirpeiye, “Ninge liti Devit, ye onom maneiki.” ");
INSERT INTO ong_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisas lile le le lirpeiye, “Yinawo.” Liso pe pinawo metine lutepe olpe pepe, le pe pirpowo polpepei, “Onom teingine, ye eilo Jisas linaiye.” ");
INSERT INTO ong_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Metine lepe le kotuwo olol lele piti lalfo lifei yuwei lepe, le kotuwo liri lifei konko lile le le karowo Jisas lau. ");
INSERT INTO ong_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisas leleteiye, “Ye onom natoiki ki piti ma kesi men leiye?” Fei metine lutepe olpe pepe lirpowo Jisas lolpepei, “Ye metine piti eptalo mete, ki onom nato piti ma nou kuntolili.” ");
INSERT INTO ong_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisas lirpowoye, “E, ye ulpope il piti Ma Ili le il pepe pe peiteiye nou fale teingi.” Frou yo fei, metine lepe le nou luntolili le le lulsi Jisas linge tisi lepe le. ");
INSERT INTO ong_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wem pe pe malfem pire Jerusalem, pe pe fale uf kumpu Betfasi re Betani pifei tumun liti nimpe oliv pile. Jisas laisinge pupam twinges tele tinu te, ");
INSERT INTO ong_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","le le lirpenge lolpepei, “Rounge ye uf kumpu lato linuse liye. Wem ise rounge ye fale, ise miso yulwene donki ninge nele wala yefli, pe topuwo laitei. Rounge nenfari le ise rounge yeipi yila yau. ");
INSERT INTO ong_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Le wuso minemple peiteise polpepei ‘Ise rounge yolpepe piti men?’ Ise rounge ma yirpei yolpepei, ‘Apa ili lirpei le ku so waule weipi wila we ma watowo le le miso nou frou laltei lau’.” ");
INSERT INTO ong_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Liso pupam tepe teye le te te terengawo donki lepe lile tisi, pe topuwo laitei wingi piti winem nele. Wem pupam tepe te wala so nenfari donki ");
INSERT INTO ong_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mete nemple wuso pile pepe pe pouteteiye, “Ise rounge yesi men, nenfari donki lepe?” ");
INSERT INTO ong_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Le te rounge nou tirpepe il elpesipe wuso Jisas linu lirpenge piti ma tirpei pepe, liso mete pepe pusange teye. ");
INSERT INTO ong_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Te tila donki ninge lepe te fale taltowo Jisas le pe piripe olongou pelpe piti pafo pifei yuwei pepe, pe piripe puwo donki tounga le Jisas longlo lifei yuwei. ");
INSERT INTO ong_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mete wuru pepe pe nomplei olongou pelpe wuso pafo pifei yuwei pepe, pe paptetei pinge tisi le ilepe paploupe oflongelem le pe paptetei pinge tisi. ");
INSERT INTO ong_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mete piti pinu le piti pulsesi pingi, pe pailolo pirpeiye, “Meila nange liti Ma Ili. Ma Ili ma kani onom lantowo re lailolowo piti laule lire nange liti Apa Ili. ");
INSERT INTO ong_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ma Ili lailolowo wem piti eiya Devit ninge lele ma nou luntoluwepe mete piti tef. Meila nange liti Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas le fale Jerusalem, le linki le winem liti Ma Ili le le luntoli leinei leinei, lulwepe men nange wuso pifei winem pepe. Wolo olo ningliye le so liripe pupam pele wuso pire esi plen le plen te twinges pepe pe pe Betani. ");
INSERT INTO ong_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nolowi wem pe pusa Betani le pe pau Jisas nimpi nalei. ");
INSERT INTO ong_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Le luluwo ifau lile fiyen taise le ifau lepe le lilape yousi wurutei. Liso Jisas karowo le piti ma luntoli waipiti yumko nemple pultei lo olo. Wolo wem le le fale malfem le luluwo ifau lilape yousi yaupe le yumko olo wusoli wem pele piti lilape yumko fouri pepe wala olo. ");
INSERT INTO ong_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jisas lirpowo ifau lepe lirpolo, “Mete nemple ma nou paplei yumko fouri peiye kolo oloye.” Le pupam pele pe pingitowo lirpei il pepe. ");
INSERT INTO ong_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wem pe pe fale Jerusalem, Jisas linki le winem liti Ma Ili le le laptu mete wuso paptetei re paisesipe oweli pifei winem liti Ma Ili lepe. Jisas lesi weisipe ponu piti mete wuso kapi era piti uf mete nemple le pe namti watepe era pelpe piti uf tef lelpe potei le le lesi weisipe tile piti mete wuso paptetei naflepem malpum piti mete ma paisepe pepe. ");
INSERT INTO ong_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Le Jisas ma lusape mete pilape men nange pinki pe uf teingo liti winem liti Ma Ili lepe, lo pilape men naro pau yawi, olo le lusape mete polpepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Leye lo le leptalo mete pepe lolpepei, “Il piti Ma Ili pe paptei paitei yousi pirpei polo, ‘Winem leiki ma pinawo pirpolo le winem liti mete wuruye, pe ma pifei peletei Ma Ili.’ Wolo ise weisi yaltei lire winem liti yaplingi mete piti pire ausi, ise ma yaplingi pifei.” ");
INSERT INTO ong_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mete lipi piti pinuwepe mete piti peptawio Ma Ili siye le mete piti peptalo mete nemple pire il lipi piti Moses, pe pingitepe il wuso Jisas lirpei pepe pe so pintata tisi liti ma petesi Jisas la. Pe turwepe piri wusoli mete wurutei pepe pe yeflipiye pinlele potei pire il pele wuso leptalo pepe. ");
INSERT INTO ong_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wem ninglitei, Jisas liripe pupam pele pusa uf ili lepe le pe pe. ");
INSERT INTO ong_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nolowi pire mul ili, wem pe pinge tisi pe, pe puluwo ifau elpesi wuso lepe. Le la lile ine yuwei le noro nalem tef. ");
INSERT INTO ong_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Fei Pita onposiepe il wuso Jisas lirpei liri ifau lepe le le lirpowo Jisas lolpepei, “Untoli, ye metine piti eitalouku, ifau wuso ye irpei piti le ma la lepe olo laye.” ");
INSERT INTO ong_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisas namti lirpepeye, “Ki kirpeise punkom, wuso ise yulpope il piti Ma Ili, ");
INSERT INTO ong_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ise miso yirpowo tef alo lupai linpei lifei lepei, yirpowo yolo, ‘Eilo le ye e ire yotei engalo peryai.’ Le wuso ise enke nemple nemple kolo olo, wolo ise yulpo yirpolo il men wuso yirpei pepe pe ma fale punkom, pe ma pire punkom fale. ");
INSERT INTO ong_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Min fei polpepei so ki kirpeise, wem ise yeletei Ma Ili yire men, ise ma yulpo yirpolo ise olo kapi fei le Ma Ili miso waise men wuso ise yeletei yiri lepe. ");
INSERT INTO ong_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Le wem ise yile yeletei Ma Ili, il olpe peise piti yire metine nele ise ma onposiepe kolo olo soma Eiya leise, le Ma Ili liti yuwei, le re ma onposiepe il olpe peise kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wuso ise onposiepe il olpe peise yire mete nemple, Eiya leise, le Ma Ili liti yuwei, le re ma onposiepe il olpe peise.” ");
INSERT INTO ong_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pe nou pau Jerusalem. Wem Jisas wala lilele le linge winem liti Ma Ili, mete lipi piti pinuwepe mete piti peptawio Ma Ili siye, pe pire mete piti peptalo mete nemple pire il lipi piti Moses le mete lipi piti pinuwepe mete piti Juda, pe pau falowo Jisas ");
INSERT INTO ong_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","le pe peleteiye, “Minemple pirpeiye piti ye ma aptu mete piti paptetei re peisesipe oweli, ye ma aptu tani winem liti Ma Ili lepe? Minemple waiye il?” ");
INSERT INTO ong_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisas namti lirpepeye, “Ki ma keiteise kire il nempleiyeye pepei le wuso ise nou yirpeiki il pal so ki re ma kirpeise kire minemple so pe waiki il piti ki ma kaptu mete tani winem liti Ma Ili lepe. ");
INSERT INTO ong_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ise yirpeiki, minemple pirpowo Jon piti ma kaptetei mete, il paule Ma Ili lo pe paule mete piti tef?” ");
INSERT INTO ong_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Fei pe pire il pura nempleiye, “Il men ma ku mirpei? Wuso ku nou mirpowo molpepei, ‘Il paule Ma Ili,’ le ma lirpouku lolpepei, ‘Piti men so ise yulpope il piti Jon kolo lepe?’ ");
INSERT INTO ong_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Le wuso ku mirpei molpepei, ‘Il paule mete piti tef...’.” (Ma olo. Pe turwepe pire mete wusoli pe yeflipiye pe pesiepe il pirpolo Jon le metine nimou liti Ma Ili.) ");
INSERT INTO ong_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pe so namti pirpowo Jisas polpepei, “Ku olo mretai kolo.” Le Jisas lirpepeye, “Ki re ma kirpeise kolo, kirpeise kire minemple so pe waiki il piti ki ma kaptu mete tani winem lepei, ma olo kirpeise kolo.” ");
INSERT INTO ong_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Leye lo Jisas lirpepe lire il kauro yuwei, lirpepe lolpepei, “Metine nele le lari liom wain. Le lantei lom neinowo liom wain lepe le le loflei oi piti kenpipi wain fouri le le leilape tile piti lifei rourepe mete olpe. Leye lo le laltepe mete nemple liom wain lepe piti ma pe puntoluwo le pe ma paise era kumpu kumpu pinge wem wuso pe ma kareri wain fouri lepe. ");
INSERT INTO ong_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wem mete piti puntoluwo liom wain lepe pe ma karipe wain fouri, yaitei liti liom lepe le laisi metine lele piti lesio towa lele le lulwepe piti ma kapi wain fouri ilepe wuso pe ma paptei watowo yaitei liti liom lepe. ");
INSERT INTO ong_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Metine piti lesio towa yawi, towa liti yaitei liti liom lepe, metine lepe le, wolo mete piti puntoluwo liom pepe pe pesio pari le pe petesi, le pe nou paisi lire esi le yawi. ");
INSERT INTO ong_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Leye lo yaitei liti liom lepe le nou laisi metine nele lele piti lesio towa lele, laisi le, wolo mete piti puntoluwo liom wain lepe pe petesi metine fei lepe laye. ");
INSERT INTO ong_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mete wuru wuso yaitei liti liom laisipe pe pepe, wolo mete piti puntoluwo liom wain lepe pe piripe olpe watafei metine wuso pe petesi la lepe. Pe posiepe ilepe le ilepe pe petesipe pa. ");
INSERT INTO ong_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Fei yaitei liti liom lepe le laisipe mete pele piti pesio towa lele pepe, le laisipe pe pe yalipeye, le metine niliyeye so ratei piti le ma laisi le. Le ninge neleiyeyetei lele lotei. Liso yaitei liti liom wain lepe le laisi ninge lele lingi le piti ma lulwepe mete piti puntoluwo liom wain liti yaitei lele lepe. Yaitei lirpeiye, ‘Ki kretai punkom, pe miso pailolowo ninge leiki.’ ");
INSERT INTO ong_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wolo mete piti puntoluwo liom wain pepe pe pirpei nempleiye, ‘Yaitei liti liom lepe le ninge lele min lepei. Iso ku ma metesi la le oweli men nange pele ma ku kapi miripe pouku.’ ");
INSERT INTO ong_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pe so kesi ninge lepe pila pe petesi la le pe piri le towa yawi tani liom.” ");
INSERT INTO ong_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Fei Jisas lepletei lolpepei, “Le yaitei liti liom wain lepe le ma lesi men? Le ma le letesipe mete piti puntoluwo liom wain pepe, letesipe pa, le le ma kesipe mete nemple laptei puntoluwo liom wain lepe. ");
INSERT INTO ong_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Punkomtei, il piti paitei yousi pepe ise yungunape ko? Il pirpei polpepei, ‘Nimpe lotei wuso mete piti peilape winangou, pe pinauli lepe wolo le nimpe teingitei. ");
INSERT INTO ong_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ma Ili lotei lolpepe le fei pepe olo teingipitei’.” ");
INSERT INTO ong_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Fei mete lipi piti pinuwepe mete piti Juda, pe pirpolo ma penglei Jisas wusoli pe pretai il kauro yuwei pepei, Jisas lirpei liripe pe. Wolo pe turwepe piripe mete wurutei pepe pe so pusa le pe pe tanio. ");
INSERT INTO ong_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mete ilepe piti Farasi le mete ilepe piti alpe liti Herot, pe paisipe pe piti ma peletei Jisas pire il nemple le pe pirpolo ma puluwo waipiti le fupeletei lo olo. ");
INSERT INTO ong_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pe paule falowo Jisas le pe pirpeiye, “Ye metine piti eptalo mete, ku mretai ye irpei il men, ye irpei punkom le il men mete pelpe onposiepe wolo pe miso weiteiye kolo olo. Ye eila metine nange lo ye altu altowo kolo olo wolo ye ingio tisi liti Ma Ili le ye eptalo mete ire il punkom. Ye irpouku, il lipi pouku pe pirpei piti ku ma maisipe era pe moli ili liti Rom lo ma olo? Ku ma maisipe lo ma olo?” ");
INSERT INTO ong_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wolo Jisas lulwepe pe pempesi le le namti lirpepeye, “Ise yemtetei yeiteiki piti kali men? Yila eifi maltou nele yau le ki kuluwo.” ");
INSERT INTO ong_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Pe pila nele pau le Jisas lepleteiye, “Mati re nange pepei pe pite mi?” “Pe pite moli ili liti Rom,” pe namti pirpowo. ");
INSERT INTO ong_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Liso Jisas lirpeiye, “Iso, men nange piti moli ili pele, ise ma yaptei watowo moli ili, le men nange piti Ma Ili pele, ise ma yaptei watowo Ma Ili.” Le pe olo pinlele potei olpe pire il pele. ");
INSERT INTO ong_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Fei mete ilepe piti Sadyusi pe pau Jisas. (Pe mete piti pirpei polo mete wuso pa pepe pe miso nou peilo kolo olo.) ");
INSERT INTO ong_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Pe pirpeiye, “Ye metine piti eptalo mete, Moses laptouku lope il lipi pepei lirpolo, ‘Wuso metine nele la le le lusane moto ratei wolo eple re olo, winke ma laisene towa moto nepe soma me roum milape eple pilowo tulum liti line wuso la lepe.’ ");
INSERT INTO ong_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sungoi liye, ilim winkem nemple pire eti plen poungo te twinges pratei. Line oru laisene moto wolo eple olo lilape kolo, le la yawiye. ");
INSERT INTO ong_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Leye lo winke piti luwol line oru wuso la lepe le namti laisene le le re la yawiye, eple olo lilape kolo. Winke nele piti luwonge re so lolpepe. ");
INSERT INTO ong_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Le pe yeflipiye, pe paisene moto fei nepe le pe pa yaupeye, eple olo pilape kolo. Le moto nepe ne na ningi. ");
INSERT INTO ong_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Le wem fei mete wuso pa pepe pe ma nou peilo, wem fei lepe ne ma moto piti minele lelpe pepe? Pe yeflipiye wuso paisene nepe?” ");
INSERT INTO ong_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas namti lirpepeye, “Ise onposi yoporo kolo olo. Le ise retai fei polomen lo olo? Ise onposi yoporo kolo wusoli ise yironom yire il piti paitei yousi le singe piti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wem mete wuso pinu pa pepe le pe nou peilo, pe ma watafei ririm piti yuwei pepe le mete re nimoure ma paite nemple kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Le mete wuso pinu pa le pe nou peilo pepe wolo ise yungunape il wuso Moses laptei lirpei lire weli wuso fale loli nimpe namin lepe, ise yungunape lo olo? Il pepe Moses laptei lirpei lolpepei, Ma Ili lirpowo Moses lolo, ‘Ki fei Ma Ili liti Abraham, Ma Ili liti Aisak le Ma Ili liti Jekop.’ ");
INSERT INTO ong_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Il pepe pato polpepei, mete wuso pa pelengi pepe pe olo, le Ma Ili lelpe kolo olo. Wolo le Ma Ili liti mete piti nampir pratei le piti pa pe ma nou peilo. Ise olo onposi yoporo kolo, olotei.” ");
INSERT INTO ong_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Metine nele liti leptalo mete lire il lipi piti Moses, le lau fale lingitepe wuso pirpei fale reite nemple pepe. Le luntoli wuso Jisas namti lirpei il teingipe poporo pe mete piti Sadyusi pepe, le so leletei Jisas lolpepei, “Il lipi men so pe teingipetei pepe?” ");
INSERT INTO ong_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Fei Jisas lirpeiye, “Il pepei so teingipetei pepe. Yingitei, ise Israel, Ili, le Ma Ili louku le loteteiye le Ili. ");
INSERT INTO ong_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ise ma onom kerowo Ili le Ma Ili leise, ise ma onom kerowo yire enke peise, le ise ma onposiotei.’ ");
INSERT INTO ong_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Il nemple piti puwope le pe re teingipetei pepe min pepei, ‘ise ma enke kerepe mete nemple watafei ise enke kere isotei pepe.’ Il lipi eryai pepe pe teingipetei watafei il lipi twinges pepe kolo olo, il lipi twinges fei pepei pe teingipetei pinuwepe il lipi wuru pepe.” ");
INSERT INTO ong_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Fei metine piti leptalo mete lire il lipi piti Moses pepe, le lirpowo Jisas lolpepei, “So, ye metine piti eptalo mete. Il wuso ye irpei pepe pe punkom. Ili le Ma Ili le ma lipi nemple re kolo olo, le loteteiye le Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Le metine ma onom kerowo Ma Ili, onom kerowo lire onom pele le le ma onposiotei. Le le ma onom kerowo metine nele watafei le onom kere lotei lepe. Ili lipi twinges fei pepei pepe ku ma minu mingiepe le piti maptei oweli men nange pifei tile le ku maptei watowo Ma Ili lepe, pepe olo teingipe, wolo ku ma mingiepe mingi.” ");
INSERT INTO ong_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas luntoli wuso metine piti leptalo mete lire il lipi piti Moses lepe, le namti lirpei wata pirpolo le metine piti onom nire wuru, liso Jisas lirpowo lolpepei, “Ye ato fiyen kolo olo, ye irowo malfem ire wem teingi liti Ma Ili ma luntoluwepe mete piti tef.” Jisas lirpei il pepe re fei, mete nemple re nou peletei pire il men re kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Wem Jisas wala leptalo mete lifei winem liti Ma Ili, le lepletei lire il pepei, “Fei polomen so mete piti peptalo mete nemple pire il lipi piti Moses pepe pe pirpei polo Mesaia, le ma ninge palyene liti Devit lepe? ");
INSERT INTO ong_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Riri Teingi le lunkuwo Devit le so lirpei lolo, Ili le lirpowo Ili leiki ‘Ifei eti tilpi leiki e e fale wem ki ma kaptei mete piti pireye yepi yire nemple eringi, ki ma kaptei pratei ire yepe tef peiye.’ ");
INSERT INTO ong_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit lotei linawo lirpolo le Ili, le fei polomen ma Mesaia le ninge palyene liti Devit?” Mete wurutei pepe pe enke teingipetei piti pingitepe il piti Jisas. ");
INSERT INTO ong_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wem le wala leptalo, le lirpeiye, “Ise ma kotopa isotei yire mete piti peptalo mete nemple pire il lipi piti Moses, pe onom kere piti ma pafo olongou ulepe le pe pilele peinenei pau pe le mete piti pratei tulum piti paptetei re paisesipe oweli pepe pe ma peisipe pailelepetei. ");
INSERT INTO ong_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pe keiniepe poi teingipe piti poli angli pau le wem mete nemple papli oweli lipi le pe pinape pe, mete piti peptalo mete pire il lipi piti Moses pepe pe ma pompetepe poi teingipe piti ma pifei. ");
INSERT INTO ong_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pe ma pempesipe towa nimoure le pe kapiepe oweli men nange piti pifei winangou pelpe, leye lo pe ma rautu potei yaupe wem pe peletei Ma Ili, pe ma peletei pire il wuru. Moingi liti pe ma pila olo ma ilitei.” ");
INSERT INTO ong_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas lifei malfem lire ufau liti pafofo era paisesi winem liti Ma Ili lepe, le so lulwepe mete piti pafofo era pelpe. Mete wuru wuso pe mole re yini wurutei pepe pe pafofo era wuru. ");
INSERT INTO ong_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Leye lo towa moto nenpe ne mole yini re nange panei, ne nau nafo era kumpu yalei meme (2 toea.) ");
INSERT INTO ong_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Fei Jisas linape pupam pele pau panfonemple le le lirpepeye, “Ki kirpeise punkom, towa moto nepei ne mole yini nange panei wolo ne nafo era wurutei pautile ufau liti pafofo era paise winem liti Ma Ili le mete wuru pepe pe olo pafo yaipiye. ");
INSERT INTO ong_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pe era ilepe pelpe wala pratei le pe pilape ilepe pau pafo ufau liti winem liti Ma Ili lepei wolo ne, mole yini re nange panei, ne nafo pene yeflipiye. Era kumpu pene piti ma nuntoli notei wolo ne nau naptei yalipeye.” ");
INSERT INTO ong_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wem Jisas lusa winem liti Ma Ili le le le, pupam nele lele lirpowoye, “Ye metine piti eitalouku, untoli, era re winangou teingipe. Era tangupe re winangou teingipe.” ");
INSERT INTO ong_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Le Jisas namti lirpowoye, “Ye ulwepe winangou teingipetei fei pepeiye lom? Erau nele re ma lifei tulum lele kolo olo, pe ma pualo tef yalipeye.” ");
INSERT INTO ong_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas le lifei alo liti nimpe oliv pile le winem liti Ma Ili lifei le plen. Jisas lifei lepe wem Pita lire Jems, Jon re Andru, pe poteteiye pe fale peletei polpepei, ");
INSERT INTO ong_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ye irpouku, wem piti men soma men men wuso inu irpei pepe pe ma fale? Le men ma linu fale piti ma kosauku lire wem piti men men wuso inu irpei pepe pe ma fale punkom?” ");
INSERT INTO ong_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Fei Jisas lirpepeye, “Kotopa isotei le ise yusa metine nele lempeteise pato. ");
INSERT INTO ong_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mete wuru ma pau pire nange leiki pirpeiye, ‘Ki so le lepei,’ le pe ma pempesipe mete wuru. ");
INSERT INTO ong_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Le ise ma enke olpe kolo olo wem ise yingitowo ipli liti mete plolpo malfem pireise le il yaupe piti pirpei pire mete nemple plolpo uf tef nele fiyen. Men nange fei pepei pe ma fale wolo pe ma kosaise pire wem liti Ma Ili ma lau luntoluwepe mete piti tef kolo olo, wem fei lepe wala olo. ");
INSERT INTO ong_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mete piti alpe nemple ma plolpo piripe piti alpe nemple le mete piti uf tef nemple pe ma pualo nemple le pe plolpo piripe mete piti uf tef nemple. Tef liye liye re ma maiene lini le oweli ma olo, mete ma nimpi naplei olpetei. Men nange fei pepei pe ma watafei flis piti pinu falene moto wem ne ma nilape eple pepe.” ");
INSERT INTO ong_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ise ma kotopa isotei. Mete ma pengleise le pe ma keteise pilaise ye falepe moli lipi piti pe ma kapi il paptei pireise. Pe ma posise yifei angli pal le ise ma yilepe onom piti mete lipi piti puntoluwepe mete le ise ma yirpepe yire il teingipe piti Ma Ili wusoli ise yila nange leiki. ");
INSERT INTO ong_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mete yeflipiye ma pinu pingitei il teingipe piti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Le wem pe pengleise le pe keteise pilaise ye falepe moli lipi piti ma kapi il paptei pireise, ise ma yinu enke olpe yire il men piti ma yirpei pepe, ise ma yinu enke olpe kolo olo. Wem fei lepeye, il men Ma Ili waise piti yirpei ise ma yirpei il pepe pe peise kolo olo, Riri Teingi le waise il pepe. ");
INSERT INTO ong_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mete ma kesipe ilim winkem pelpe potei le pe ma paptei alepe nimin piti ma petesipe pa, le yaire ma polpepe piripe eple pelpe. Le eple ma papwe il yaruwepe pire emare yaire pelpe le pe ma paptei pe piti ma petesipe pa. ");
INSERT INTO ong_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mete yeflipiye pe ma enke kotu pireise wusoli ise pupam peiki, wolo minele piti lire lotei singe le le lila moingi, metine fei lepe Ma Ili ma kanowo.” ");
INSERT INTO ong_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ise ma yuluwo men olitei le ma fale lile tulum piti le lele kolo olo.” (Minele lungunape il pepei le ma retape il pal loporo wo le soma lungunape.) “Leye lo mete wuso pratei Judia pepe pe ma pantutu pe tef alo lupai linpei lifefei lepe peye. ");
INSERT INTO ong_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Metine piti lifei winem tupe lele lepe le ma kali wem laltetei kolo olo, le ma litipi frou le kapi men nange pele piti ma kapi lilape le. ");
INSERT INTO ong_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Metine piti lile liom le ma nou le winem lele piti ma kali olol lele liti lalfo lifei yuwei lepe, le ma nou le kali kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wem fei pepe pe ma olpetei piti nimoure wuso pire yefi le piti emare wuso eple pelpe wala kumpu pultei nimer pepe. ");
INSERT INTO ong_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ise ma yeletei Ma Ili yire wem oli fei lepe, le ma fale wem piti nef is kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wusoli moingi piti ma fale wem fei pepe pe ma olpetei pinuwepe piti pinu falepe mete piti tef le pe pretape pepe. Wem linutei wem Ma Ili linu laltei tef lire teplai re men nange pepe le le lau lau fale fei, moingi wuso fale pepe olo kumpu le piti fei pingi ma fale pepe pe ma olpetei. Moingi olpe pepei pe ma fale yo oloye, nauyou nauyou re moingi nemple olpetei ma nou fale kolo oloye. ");
INSERT INTO ong_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wolo Ma Ili le tintiriepe epli wem pau kuraupe le wuso le lolpepe kolo, metine minele re miso namin ratei kolo olo, ma pa yalipeye. Wolo Ma Ili onposiepe mete pele wuso le lotei keiniepe pepe le so tintiriepe epli wem pau kuraupe.” ");
INSERT INTO ong_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Leye lo wem fei lepe wuso metine nele le lirpeise lolo, ‘Yuntoli, Mesaia min lepei,’ lo le ma lirpei lolo, ‘Yuntoli, le min liye,’ ise ma yulpowo kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wusoli mete ma fale le pe ma pemtetei pirpolo pe Mesaia le pe mete emare. Pe ma pirpei le men nange ma potei pire tute fale piti ma pempesipe mete wuso Ma Ili pele keiniepe pepe le wuso pe singe kolo olo, pe ma pualo. ");
INSERT INTO ong_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ise ma kotopa isotei. Moingi olpetei pepe pe wala fale kolo olo le ki fei kinu kirpeise kire men nange oloye.” ");
INSERT INTO ong_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Moingi olpe pepe pe ma fale re fei, epli wem pingi pepe epli ma weitei lire munkunum le ane ma lini kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Taurungu ma kotu pualo tani teplai yuwei le men nange piti paitei pinge teplai yuwei pepe pe ma weitetei re piyoyo polomen polomen re peye. ");
INSERT INTO ong_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Leye lo Ninge liti Metine Wape le ma luwowo linge nopom yuwei lau lire singe lipi pele. ");
INSERT INTO ong_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Le ma laisipe ririm pele pe tef um ilo ilo le pe ma papwonou mete wuso Ma Ili pele keiniepe pepe, papwonou paptei nemple, kesipe pile tef um ilo pe paltu ilo.” ");
INSERT INTO ong_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ise yuluwo wengle le ise miso retai. Wem wengle ario lepe lus pautu le upou ma falele le ise miso retai wem piti epli olo lau lire malfemye. ");
INSERT INTO ong_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Min watafei wengle lepe, wem moingi olpe pepe pe fale, ise miso retai wem lepe olo lau lire malfemye, Ninge liti Metine Wape olo loporo lotei piti ma laptu faleye. ");
INSERT INTO ong_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ki kirpeise punkom, men nange fei pepe pe ma fale wo soma mete wuso fei wala nampir pratei pepei pepe pe ma pa pingi. ");
INSERT INTO ong_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Men nange piti teplai yuwei le piti tef lepei pe ma pelesesa le il peiki ma olo, pelesesa kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Minele re retawo wem fei lepe kolo olo, ririm piti yuwei lo Ninge lotei re olo pironom, Yaitei loteteiye le retai. ");
INSERT INTO ong_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ise ma rourei isotei le ise kotopa isotei wusoli wem fei lepe olo ise yirowo onom yiri. ");
INSERT INTO ong_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Wem fei lepe le ma watafei metine nele, le laulo le uf mete nemple le le laptei mete pele piti pesio towa lele pepe, le laptei puntoluwepe oweli men nange pele. Le watowo metine niliyeye niliyeye towa lele piti lesio, le le lirpowo metine nele piti ma lifei wingi luntoli. ");
INSERT INTO ong_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ise re ma lus patoto wusoli ise yironom yire wem piti Yaitei liti winem le ma nou lau. Le ma lau ningli lo mulpou wem nimen lo lire mul ili lo wem epli fale. ");
INSERT INTO ong_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wuso le lato yo laptu fale frou yo fei, le ma lerengaye etei kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Il men ki kirpeise, ki kirpepe mete wuruye. Ise ma lus pato yuntolili.” ");
INSERT INTO ong_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Epli wem twinges wala tato, wem piti mete piti Juda pe ma papli oweli lipi piti ma onposio wem wuso Ma Ili kesipe manre yaire pelpe pau tani Isip pepe, le wem fei lepe, luom re pe ma pali palei yawi, yis pire weisi kolo olo. Wem fei lepei lepe wala olo le mete lipi piti pinuwepe mete piti peptawio Ma Ili siye le mete piti peptalo mete nemple pire il lipi piti Moses, pe pintata tisi piti ma penglei Jisas kotire le pe ma paltei la. ");
INSERT INTO ong_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pe pirpeiye, “Wem piti ku ma mapli oweli lipi pepe, wem fei lepe ku ma molpepe pato waipiti mete ma kamio il le pe plolpo.” ");
INSERT INTO ong_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas le lifei winem liti Saimon ratei Betani, Saimon linu pape olpe poluwo. Wem Jisas wala lifei laplei oweli, moto nenpe ne ninki ne. Ne nila mili lire tipe wopu fale lire mili nemi loparuye. Tipe teingi woputei le pe ma pire era lipitei paise. Moto nepe ne rapu mili le ne kalulu tipe wopu lepe neltali falo re oru liti Jisas. ");
INSERT INTO ong_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mete ilepe wuso pifei lepe pe enke kotu pirine ne le pe pirpei nempleiye, “Tipe wopu teingitei lepe ne kalulu yawi piti kali men? ");
INSERT INTO ong_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ne naltepe mete nemple paise pire era lipitei (500 kina) le era fei pepe ne ma kapi weisipe watepe mete wuso pe mole yini re nange naplei pepe.” Le pe pirpeilane onetei. ");
INSERT INTO ong_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wolo Jisas lirpeiye, “Ise yusane. Piti men ma ise watene moingi! Ne nolpepe men teingitei nireiki ki. ");
INSERT INTO ong_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mete wuso pe oweli yini re nange naplei pepe pe ma wem oli oli re miso pireise yepi ratei le wem ise enke fale piti ma kaniepe, ise miso kaniepe. Wolo ki ma kireise ratei wem oli oli kolo. ");
INSERT INTO ong_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ne ma nolomen nireiki ki lepe, ne min so nolpepei lepe. Ne ninu kalulu tipe wopu neltali topo leiki nopori elpesiye piti ma peiteiki. ");
INSERT INTO ong_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Fei ki kirpeise punkom, il teingipe piti Ma Ili pele, mete ma peptalo liye liye re pe pinge tef ili yefliye le pe ma nampli pirpepei pire men wuso ne fei nolpepei nireiki ki lepe.” ");
INSERT INTO ong_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Leye lo Judas Iskariot, le pupam nele piti lire esi plen le plen te twinges pepe, le le falepe mete lipi piti pinuwepe mete piti peptawio Ma Ili siye pepe, Judas le lulwepe piti ma laltei Jisas le esi pelpe. ");
INSERT INTO ong_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pe enke teingipitei piti ma pingitowo Judas lirpepe lire il men le pe topwepe il papiri piti ma watowo era. Liso Judas lus patoto piti ma wem nele loporotei le ma laltei Jisas le esi pelpe. ");
INSERT INTO ong_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Epli wem linu piti ma papli oweli lipi piti ma onposio wem wuso Ma Ili kesipe mete piti Juda pau tani Isip pepe. Pe papli lufe yaupe, pire yis weisipe kolo, olo le wem fei lepe pe ma posiepe sipsip eple papli piti ma paplei onposio wem fei lepe. Fei Jisas pupam pele peleteiye, “Ye irpei piti ku ma me pinei le ku ma mapliye oweli piti ma onposio wem wuso Ma Ili kesipe mete piti Juda pau tani Isip pepe?” ");
INSERT INTO ong_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Leye lo Jisas laisinge pupam twinges tele te le le lirpenge lamtetenge lolpepei, “Rounge ye uf ili lepe le metine nele le ma lila mili oplou lire tipe, le ma lau lerengaise rounge. Rounge yulsi ");
INSERT INTO ong_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ye winem wuso le ma le linki le lepe le ise rounge ma yirpowo yaitei liti winem yolpepei, ‘Metine piti leitalouku, le lirpei lolo, ‘Elpeingo leiki linei piti ma ki kire pupam peiki mifei maplei oweli piti ma onposio wem wuso Ma Ili kesipe mete piti Juda pau tani Isip pepe?” ");
INSERT INTO ong_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Leye lo yaitei liti winem lepe le ma kosaise rounge lire elpeingo piti lato winem tuluwim nemple yuwei, elpeingo lepe olo potupuwo re pailolowo elpesi lato le elpeingo lepe soma ise rounge yapli oweli elpesipe yaptouku pifei lepe.” ");
INSERT INTO ong_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Fei pupam twinges tepe te teye. Te te fale uf ili lepe le te terengape men men wuso Jisas lirpei liripe pepe pe fale pingepe il pele wuso linu lirpenge tepe, le te rounge tapli oweli taptei elpesipe pifei elpeingo lepe. ");
INSERT INTO ong_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wem ningli Jisas liripe pupam pele wuso pire esi plen le plen te twinges pepe pe pau elpeingo lepe. ");
INSERT INTO ong_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wem pe wala pifei ponu paplei oweli, Jisas lirpeiye, “Ki kirpeise punkom, nele leise le ma leiteiki ke esi piti mete olpe. Metine lepe le fei lireiki wepi waplei lepei.” ");
INSERT INTO ong_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Fei pupam pepe pe enke olpe le pe niliyeye niliyeye puwo nemple peletei polpepei, “Ye ire punkom irpei ireiki ki lom?” ");
INSERT INTO ong_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Fei Jisas namti lirpepeye, “Ise pupam peiki wuso yire esi plen le plen te twinges pepe nele leise le ma lolpepe. Metine fei lepe le ma lireiki woltoto luom linge oweli tipe piti lire waifile niliyeye. ");
INSERT INTO ong_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ninge liti Metine Wape le ma la lingiepe il wuso paptei paitei yousi le pe pirpei pepe wolo metine wuso laltei Ninge liti Metine Wape le esi piti mete olpe pepe, metine fei lepe le men oli, moingi ili ma falowo. Metine fei lepe le miso lailele lotei wuso nimou pele ne nila kolo olo.” ");
INSERT INTO ong_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wem pe wala paplelei, Jisas kali luom, le leletei Ma Ili liri re fei le kareri watepe pupam pele le le lirpeiye, Kali luom lepei, le topo tale leiki.” ");
INSERT INTO ong_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Leye lo le kali wengle pau lire wain tipe, le leletei Ma Ili liri re fei le so watepe le pe yeflipiye pe palei wain tipe lire wengle pau lepe. ");
INSERT INTO ong_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jisas lirpeiye, “Wain tipe lepei le teluwi leiki ki kalulu keltalipe mete wuruye. Teluwi leiki le lesiepe lapiri il wuso Ma Ili topwepe lapiri lire mete piti tef pepe. ");
INSERT INTO ong_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ki kirpeise punkom, ki ma nou kalei wain tipe nele kolo olo, kato ke ke ma fale wem piti Ma Ili ma luntoluwepe mete piti tef, wem fei lepe soma ki ma kalei wain tipe nele yefli.” ");
INSERT INTO ong_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Leye lo pe puro weni piti rautuwo Ma Ili le pe naro pe alo liti nimpe oliv pile. ");
INSERT INTO ong_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas lirpepe pupam pele lolpepei, “Ise yeflipiye ma yusaiki le ise ma yuru taniki wusoli il piti paitei yousi pepe pe pirpei polpepei, ‘Ma Ili ma letesi metine piti luntoluwepe sipsip, Ma Ili ma letesi la le sipsip pele ma pantutu pire fla.’ ");
INSERT INTO ong_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wolo wem ki ma nou keilo re fei ki ma kinuse ke Galili.” ");
INSERT INTO ong_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Fei Pita namti lirpowoye, “Ki miso kusaiye kolo, olotei. Pe wuru pepe pe ma pantu taniye le ki miso olo.” ");
INSERT INTO ong_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisas lirpowo Pita lolpepei, “Ki kirpeiye punkom, fei mulpou lepei wem woflu wala ma koro wem twinges kolo olo, ye ma wem twinges niliyeye ye irpei irpolo ye olo ireiki onom.” ");
INSERT INTO ong_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita nou lirpei lirkilau lolpepei, “Ki ma kirpei kolo ki kireye onom kolo olotei, le wuso ki ma kireye rounge wa, ki ma kireye roungesye wa.” Le pupam yeflipiye pe pirpei il nempleiyeye pepe. ");
INSERT INTO ong_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pe pau fale tulum pinawo Getsemani, le Jisas lirpepe pupam pele lolpepei, “Ise ratei lepei wem ki keletei Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Leye lo Jisas kesi Pita lire Jems re Jon pepi pe. Jisas onom moinginetei, ");
INSERT INTO ong_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","le le lirpepe Pita lire Jems re Jon lolpepei, “Ki onom onetei le ki ma ka kasiene. Ise ratei lepei, le ise yeletei Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jisas le fiyen taise le le liri lotei lualo lato tef le le leletei Ma Ili lirpolo wuso Ma Ili lirpei le ma lila moingi kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jisas leletei Ma Ili lirpeiye “Eiya, ye Eiya leiki. Ye miso esio menele ire wanketei kolo olo. Ye kali moingi fei lepei taniki. Wolo ye ma ingiepe il peiki pato, ye ingiepe il peiye yotei.” ");
INSERT INTO ong_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Leye lo Jisas nou lau falepe pupam twinges niliyeye pepe le le lulwepe petei le le lirpowo Pita lolpepei, “Saimon, ye etei lom? Ye miso rapungo wem nele kurau re kolo olo lom?” ");
INSERT INTO ong_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Le Jisas lirpepeye, “Ise ma rapungo le ise yeletei Ma Ili piti ise ma yualo tisi oli kolo olo. Riri leilaise enke wolo topo tale peise olo toulipi.” ");
INSERT INTO ong_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jisas nou le taniepe le le liripe il elpesipe wuso linu lirpei leletei Ma Ili pepe, le liripe il elpesipe pepe nou leletei Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Leye lo le nou karepe pupam pele pepe lau wolo le lulwepe pe nou petei, pe rapungo kolo olo. Le pe pretai il men piti ma pirpowo re kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jisas le lau wem twinges niliyeye le wem fei lepe le nou karepe lau le le lirpepeye, “Ise wala yetei yapteitopungou peise lom? Yetei fei, wem fei lepe olo lau faleye, yuntoli, Ninge liti Metine Wape ma pe fei ma paltei le esi piti mete olpe. ");
INSERT INTO ong_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yeilo le ku me. Yuluwo metine piti ma leiteiki ke esi piti mete olpe pepe, le min liplau.” ");
INSERT INTO ong_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas wala lirpepei wem Judas, le pupam nele piti lire esi plen le plen te twinges pepe, le le falepe. Le liripe mete wurutei, pe pilape werau re nimpe teingelem piti plolpo. Mete lipi piti pinuwepe mete piti peptawio Ma Ili siye, pe pire mete piti peptalo mete nemple pire il lipi piti Moses le mete lipi piti pinuwepe mete piti Juda, pe paisipe mete wurutei wuso paule piti ma penglei Jisas pepe. ");
INSERT INTO ong_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Fei metine piti ma laltei Jisas le esi piti mete olpe pepe, le linu lirpepe mete wuso pau piti ma penglei Jisas lepe, le lirpepe lolpepei, “Metine wuso ki ma kenesi mi, metine fei lepe soma ise yenglei lepe. Yenglei, kesi yila ye le ise rourowo.” ");
INSERT INTO ong_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Wem Judas le falowo Jisas, le le lirowo Jisas malfem le le lirpeiye, “Ye metine piti eitalouku,” le Judas lenesi Jisas mi. ");
INSERT INTO ong_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pe so penglei Jisas le pe pesio pirkilau. ");
INSERT INTO ong_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wolo metine nele wuso lile malfem lepe le kesi werau lele le le liri lalowi kari mingi liti metine piti lesio towa liti metine ili piti linuwepe peptawio Ma Ili siye. ");
INSERT INTO ong_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Leye lo Jisas lirpepe mete wurutei pepe lirpeiye, “Ise ma yau yire werau re nimpe teingelem piti ma yengleiki wata pirpolo ki metine liti kapwe il yaruwepe pepe lom? ");
INSERT INTO ong_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Epli wem oli oli wuso lepe ki kireise mepi mifei winem liti Ma Ili le ki keptalo il wolo ise yengleiki kolo. Wolo il piti paitei yousi pe ma fale punkom.” ");
INSERT INTO ong_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Leye lo pupam pele pepe pe yeflipiye pantu tanio. ");
INSERT INTO ong_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Metine lainouwo nele le lari ranguwom yalpe kumpu, le lulsesi Jisas lingi. Mete pirpolo ma penglei, ");
INSERT INTO ong_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wolo le lantu taniepeye le ranguwom yalpe lepe re le ketowo eti pe pesioye le le lantu pau yawi leye. ");
INSERT INTO ong_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pe kesi Jisas pila pe fale winem liti metine ili piti linuwepe mete piti peptawio Ma Ili siye, pe pe fale winem lele, le winem lepe mete lipi piti pinuwepe mete piti peptawio Ma Ili siye, pe pire mete piti peptalo mete nemple pire il lipi piti Moses le mete lipi piti pinuwepe mete piti Juda, mete fei pepei pe pau panfi nemple pifei winem fei lepe. ");
INSERT INTO ong_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita lulsesi Jisas lingingi, le liri Jisas malfem kolo olo le le linki le uf teingo liti winem liti metine ili piti linuwepe mete piti peptawio Ma Ili siye. Pita le liripe mete piti prourowo winem lepe, le liripe pepi pifowo weli pifei uf teingo. ");
INSERT INTO ong_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mete lipi piti pinuwpe mete piti peptawio Ma Ili siye le mete lipi yeflipiye piti pifei pingitepe re kapi paptei pire moingi piti mete piti Juda, mete fei pepei pe pirpolo ma pinta tisi liti ma paltei Jisas la. Wolo pe perengawo tisi men kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mete wuru pemtetei pirpei pamtutuwo Jisas wolo il pelpe olo pulpo nemple kolo. ");
INSERT INTO ong_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Leye lo mete nemple peilo pile le pe pemtetei pirpei il pepei piri Jisas, pe pemtetei pirpei polpepei, ");
INSERT INTO ong_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ku mingitowo lirpei lolo, ‘Ki ma kaltutu winem liti Ma Ili lepei wuso mete peila lepe le epli wem twinges niliyeye kari re fei ki ma nou keila nele wuso mete re miso pesio kolo olo’.” ");
INSERT INTO ong_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pe re il pelpe olo pulpo nemple kolo. ");
INSERT INTO ong_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Fei metine ili piti linuwepe mete piti peptawi siye paptowo Ma Ili, le leilo lile onom pelpe yeflipiye le le leltei Jisas lolpepei, “Ye ingitepe il wuso pe pirpei pamtutuye pepe le ye ma namti irpei il men lo olo?” ");
INSERT INTO ong_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wolo Jisas lanri nemi le il men re lirpei kolo. Metine ili piti linuwepe peptawi siye paptowo Ma Ili lepe, le nou leletei Jisas lolpepei “Ye Mesaia, ninge liti Ma Ili, Ma Ili wuso mete rautuwo lepe lom?” ");
INSERT INTO ong_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisas namti lirpeiye, “Ki so lepe le ise yeflipiye ma yuluwo ninge liti Metine Wape lifei eti tilpi liti Ma Ili. Singetei le le ma luwowo linge nopom yuwei lau.” ");
INSERT INTO ong_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Fei metine ili piti linuwepe mete piti peptawi siye paptowo Ma Ili lepe, le lesi rapupe olongou pele le le lirpeiye, “Mete nemple piti ma pirpei pamtutuwo Jisas pepe, ku ma mingitepe il pelpe kolo, olo fei. ");
INSERT INTO ong_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ise yingitepe il olpe pele fei. Ise onposi men yiri?” Pe yeflipiye pilape il pusapowolope pirpolo le metine oli le le ma la. ");
INSERT INTO ong_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mete ilepe pelpe pe paru tunku peptali Jisas le pe pari ranguwom yalpe lifei lopopo lutepe pele le pe petesesi. Pe pirpeiye, “Eisi minele leteteiye.” Le mete piti puntoluwo winem liti metine ili piti linuwepe peptawi siye paptowo Ma Ili lepe, mete fei pepe pe kesi Jisas le pe pire esi fila papowo lope. ");
INSERT INTO ong_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita wala lifei uf teingo lepe wem moto nenpe piti nesio towa liti metine ili piti linuwepe peptawi siye paptowo Ma Ili, moto nepe ne nau fale. ");
INSERT INTO ong_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wem ne nuluwo Pita wuso lifowo weli lepe, ne nautuluwo malfem le ne nirpeiye, “Ye re ye piti ire Jisas liti Nasaret.” ");
INSERT INTO ong_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wolo Pita lire yef. Le namti lirpei lolo, “Ki olo kironom. Ki olo kire wouye kire il men ye irpei pepe.” Le Pita naro lile tisi liti pinkingi pe pau towa yawi le wem fei lepeye woflu koro. ");
INSERT INTO ong_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wem moto piti nesio towa liti metine ili piti linuwepe peptawi siye paptowo Ma Ili, moto fei nepe ne nuluwo Pita le ne nou nirpepe mete wuso pile pepe, ne nirpeiye, “Le re le nele lelpe.” ");
INSERT INTO ong_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wolo Pita nou lire yef. Pe pile wem ulel taise le mete wuso pile pepe pe nou pirpei pamtuwo Pita polpepei “Ye ma ire yef irpolo ye nele lelpe kolo olo, wusoli ye re ye liti Galili.” ");
INSERT INTO ong_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Leye lo Pita leisi nange liti Ma Ili lirpeiye, “Ma Ili ma waiki moingi wuso ki kirpei punkom kolo olo. Metine wuso ise yirpei yiri lepe ki olo kirowo onom.” ");
INSERT INTO ong_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wem fei lepeye woflu nou koro, wem fei lepei le wem twinges wem woflu koro lepe, linu koro le fei le nou koro le Pita onposiepe il wuso Jisas linu lirpowo pepe. Jisas linu lirpowo Pita lolpepei, “Woflu wala ma koro wem twinges kolo, le ye ma inu irpei ireiki yef wem twinges niliyeye irpolo ye olo ireiki onom.” Le Pita louti olitei. ");
INSERT INTO ong_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nolowi pire mul ili, mete lipi piti pinuwepe mete piti peptawi Ma Ili siye pe frou pe panfipe mete lipi piti pinuwepe mete piti Juda pire mete piti peptalo mete nemple pire il lipi piti Moses le mete lipi yeflipiye piti pifei pingitei re kapi paptei pire moingi piti mete piti Juda, mete fei pepei pe frou pe panfinemple piti ma pinta tisi liti ma paltei Jisas la. Pe pire foiye singe topupuwo le pe kesi pila pe paltowo Pailat. ");
INSERT INTO ong_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat leletei Jisas lolpepei, “Ye metine ili piti untoluwepe mete piti Juda lom?” Jisas namti lirpowoye, “Iyo, il min ye irpei pepe.” ");
INSERT INTO ong_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mete lipi piti pinuwepe mete piti peptawio Ma Ili siye, pe pirpei pamtutuwo Jisas pire men men wuru. ");
INSERT INTO ong_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Liso Pailat nou leletei Jisas lolpepei, “Ye ma nou irpei il men lo olo? Untoli men men wuru pe pirpei pamtutuye piripe pepe.” ");
INSERT INTO ong_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jisas nou lirpei il men, olo pos lile yawi le Pailat linlele lotei oli liri. ");
INSERT INTO ong_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Eringi nempleiye nempleiye wem oli oli, wem mete piti Juda pe papli oweli lipi piti ma onposio wem wuso Ma Ili kesipe manre yaire pelpe pe tani Isip pepe. Wem fei lepe, mete piti Juda ma pirpei peisi nange liti metine minele wuso lifei winem oli lepe le Pailat ma lirpepe kesi paltei naro le yawi. ");
INSERT INTO ong_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wem fei lepe metine nele, nange lele Barabas, le lifei winem oli lepe. Le liripe mete wuso plolpo le pe petesipe mete nemple pa, pe pepi pifei winem oli lepe. ");
INSERT INTO ong_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wem mete wurutei pepe pe pau panfinemple le pe peletei Pailat pire metine minele ma pe kesi paltei naro le yawi. ");
INSERT INTO ong_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Liso Pailat lepleteiye, “Ise yirpei ma ki kaltei metine ili piti luntoluwepe mete piti Juda pepe, ki ma kaltei Jisas le yawi lom?” ");
INSERT INTO ong_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat le retai loporotei wuso mete lipi piti pinuwepe mete piti peptawio Ma Ili siye pepe, pe kesi Jisas pila pau paltowo wusoli pe enke olpe piri Jisas. Pe enke olpe piri wusoli le nange lele olo fale ili. ");
INSERT INTO ong_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wolo mete lipi piti pinuwepe mete piti peptawio Ma Ili siye pepe, pe peilape enke piti mete wurutei pepe piti ma peletei Pailat le le ma kesi Barabas laltepe le yawi. ");
INSERT INTO ong_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Fei Pailat nou lirpepe mete wurutei pepe lirpeiye, “Ise yirpei piti ki ma kolomen kiri metine wuso ise yinawo yirpolo le metine ili piti luntoluwepe mete piti Juda pepe, ki ma kolomen kiri?” ");
INSERT INTO ong_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pe nou pailolo pirpeiye, “Yire singu tingeli laitei nimpe.” ");
INSERT INTO ong_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Fei Pailat lepleteiye, “Wolo le lirpei lo lingiepe il men olpe pepe?” Le pe pirkilau pailo pirpeiye, “Yire singu tingeli laitei nimpe.” ");
INSERT INTO ong_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat lirpolo ma lailelepe enke piti mete wurutei pepe, liso kesi Barabas laltepe le yawi. Leye lo pe pire foiye petesi Jisas le pe kesi paltepe piti ma pire singu tingeli laitei nimpe. ");
INSERT INTO ong_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Fei yali pal kesi Jisas pila pinki pe uf teingo leinginim le pe pinape ilepe pelpe yeflipiye pau panfinemple. ");
INSERT INTO ong_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pe pario Jisas ranguwom mul, le ye lo pe kapi foiye singu yaruwepe pire nongo wi le pe reptapowo pifei falo lele. ");
INSERT INTO ong_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Leye lo pe pemtetei routuwo pirpeiye, “Metine piti luntoluwepe mete piti Juda, ye ma ratei wem ulel.” ");
INSERT INTO ong_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pe pire nimpe teingo petesi Jisas falo lele, pe paruwo tunku, pe yaru yamkelem pratei le pe paute eri pemtetei rautuwo. ");
INSERT INTO ong_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wem pe palwe oli piri re fei, pe nolei ranguwom mul lepe tanio le pe nou pafowo olongou pele lotei. Leye lo pe kesi pila naro pe piti ma pire singu tingeli laitei nimpe. ");
INSERT INTO ong_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wem pe wala pe pualo tisi pe perengawo metine nele nange lele Saimon. Le wala lato towa nele so lau piti ma le uf ili lepe. Le pe yeftuwo piti ma kali nimpe liti Jisas lele piti tingeli laitei lepe. (Saimon lepei le liti Sairini, le eple winge tele Aleksander lire Rufus.) ");
INSERT INTO ong_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pe kesi Jisas pila pe fale tulum nele pinawo Golgota, il pal pinawo tulum lepe pirpolo, “Tulum liti oru weingampi.” ");
INSERT INTO ong_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tulum fei lepe yali pal pepe pe pirpolo pe ma watowo wain tipe wuso pire nimpe maira tipe pire weisi piti ma losisio ire esi, pe pirpolo ma watowo Jisas tipe fei lepe lalei wolo le linaulo. ");
INSERT INTO ong_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pe so pire singu tingeli laitei nimpe le pe karipe olongou pele wai nemple. Pe pirerime nimpe fouri piti ma pulu minemple soma kapi olongou menmen piti Jisas pele. ");
INSERT INTO ong_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Epli fale iliye wem yali pal pepe pe tingeli Jisas laitei nimpe. ");
INSERT INTO ong_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Il wuso pirpei pamtutuwo pepe pe paptei paitei nimpe pirpei polo, “METINE ILI PITI LUNTOLUWEPE METE PITI JUDA.” ");
INSERT INTO ong_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mete twinges piti tire ausi, te re pe tingelinge taitei nimpe pelnge fi fi, nele laitei nimpe lile eti tilpi liti Jisas le nele laitei nimpe piti lile eti enkau liti Jisas. ");
INSERT INTO ong_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Min fei polpepei so il piti paitei yousi pe pirpei punkom, il wuso pirpei polpepei, ‘Le liripe mete piti pingiepe il olpe.’ ");
INSERT INTO ong_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mete praltei pe pau, pe weitete eri pelpe le pe kelelawo pirpeiye, “Kwa, ye wuso ma altutu winem liti Ma Ili lepe le epli wem twinges niliyeye fei ye ma nou eila. ");
INSERT INTO ong_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Fei so itipi au tani nimpe le ye kane yotei e yawi.” ");
INSERT INTO ong_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mete lipi piti pinuwepe mete piti peptawio Ma Ili siye le mete piti peptalo mete nemple pire il lipi piti Moses pe re polpepe, pe palwe oli piri Jisas le pe pirpei nemple polpepei, “Le kaniepe mete nemple wolo le miso kane lotei kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ku ma muluwo Mesaia, le metine ili piti luntoluwepe mete piti Israel, ye fei ma itipi au tani nimpe le ku ma mulpope il pele.” Le mete twinges wuso tingelinge taitei nimpe watafei Jisas, te re te kelelawo Jisas. ");
INSERT INTO ong_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Epli wem nimin, tef ili yefliye munkunum fale keraisi le wem ulel taise. ");
INSERT INTO ong_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wem epli weitei Jisas louti linai il lipi lirpeiye, “Eloi, Eloi, lama sabaktani?” Le il pal pirpei polo, “Ma Ili leiki, Ma Ili leiki, piti men ye usaiki?” ");
INSERT INTO ong_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mete ilepe wuso pile lepe pe pingitowo le pe pirpeiye, “Yingitei, le linanawo Ilaija.” ");
INSERT INTO ong_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nele lelpe lantu le kali namalou loltoto wain tipe pulou yawi le le leltei loli nimpe um. Leye lo le lesio leila laltowo Jisas nemlipe le le lirpeiye, “Wala mungariwo. Ku ma muluwo waipiti Ilaija ma laule kanowo litipi tani nimpe.” ");
INSERT INTO ong_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jisas lailo lirkilautei le le kete yef. ");
INSERT INTO ong_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ranguwom wuso lultei winem liti Ma Ili lepe le lawo ratei niminye, plen kere le laitei le plen kere le laitei. Ranguwom lepe lawo lile um yuwei le noro tef. ");
INSERT INTO ong_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Fei metine ili piti linuwepe mete piti plolpo, le wuso lile linu kani onom lantowo nimpe wuso Jisas laitei lepe, le luluwo Jisas wuso lailo olitei le le la lepe le so lirpeiye, “Metine fei lepei le ninge liti Ma Ili punkomtei.” ");
INSERT INTO ong_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nimoure ilepe pile fiyen pe so puntolili pe. Piti pepi pile puntolili pe pepe, Maria Makdala, Maria, ne nimou piti Jems, kumpu lainouwo lepe le Josep re Salome. ");
INSERT INTO ong_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Pe pulsesi Jisas pau wem le ratei Galili le pe kanowo. Nimoure wuru wuso pire Jisas pepi pau Jerusalem pepe re pe pile so pulwepe paltei Jisas laitei nimpe. ");
INSERT INTO ong_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Epli weitei le piti ma lautile wem Josep liti Arimatea, le lau fale. Le nele lelpe piti liripe pingitepe le pe kapi paptei pire moingi piti mete piti Juda, le pe pretawo le metine piti lupatoto wem piti Ma Ili ma luntoluwepe mete piti tef. Epli wem fei lepe pe ma paplili oweli elpesipe paptei pifei piti ma nolowi pe ma pifei onposio Ma Ili, liso Josep lire maye linki le falowo Pailat le le leletei liri topo liti Jisas. ");
INSERT INTO ong_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat linlele lotei wem le lingitepe il wuso pirpei polo Jisas olo laye. Pailat linawo yalu pau ili piti luntoluwepe yali pal nemple pepe le leletei liri Jisas, le la wem ulel lo wala fei lepei la. ");
INSERT INTO ong_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailat lingitepe il piti yalu pau ili lepe re fei le so lirpowo Josep lirpolo le miso le kali topo liti Jisas. ");
INSERT INTO ong_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep laise olol teingi le le nalpo topo liti Jisas lele tani nimpe le le lire olol wala teingi yefli lepe lire weisi topo liti Jisas. Le kali topo liti Jisas lele lepe lila le lalingi luwo erau nample wuso palowi elpesi lato lepe. Leye lo Josep weisi erau ili laltei lufro lopopo erau nample lepe. ");
INSERT INTO ong_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Makdala le Maria ne nimou piti Josep, me roum muluwo erau nample wuso Josep lalingi olol liti Jisas luwo lepe. ");
INSERT INTO ong_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Epli wem piti pe pifei onposio Ma Ili lepe le kere re fei, Maria Makdala nire Maria, ne nimou piti Jems re Salome, me roum milape oweli wopu piti ma me mire kaltei topo liti Jisas. ");
INSERT INTO ong_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sande mul ili wem epli fale, me roum me erau nample wuso palingi topo liti Jisas luwo lepe. ");
INSERT INTO ong_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Wem me roum wala mualo tisi me roum meite neme molpepei, “Minemple miso weitouku lol erau wuso laitei lopopo erau nample lepe?” (Erau lepe olo ilitei.) Leye lo me roum meila oru le me muluwo erau lepe olo pe weisi tani erau nampleye. ");
INSERT INTO ong_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Me so roum minki me erau nample leinginim le me muluwo metine lainouwo nele le lafo olongou fi le le lifei le liti eti tilpi. Le me roum minlele motei olme. ");
INSERT INTO ong_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“Roum yinlele isotei roum kolo olo,” le lirpeme. “Ki kretai ise roum yintawo Jisas liti Nasaret wuso tingeli laitei nimpe lepe. Le luwo lepei kolo olo, le nou leiloye. Yuntoli, tulum lepei so paltei luwo lepe. ");
INSERT INTO ong_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Fei ma roum yilape il pepei ye yirpepe pupam pele le Pita re ma roum yirpowo liripe yolpepei, “Jisas olo linuse le Galili, ise ye miso yuluwo, min wuso lirpeise pepe.” ");
INSERT INTO ong_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Maria ye yaume meme, me roum turweme olme, roum naro me tani erau nample lepe le me roum mantu mratei erau nample lepeye me. Me roum mirpepe mete nemple mire il men re kolo wusoli me roum olo turweme. ");
INSERT INTO ong_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande mul ili wem Jisas nou leilo re fei, le linu falene Maria Makdala, ne wuso Jisas laptu ririm olpe pire eti plen te twinges, Jisas laptu taniene nepe. ");
INSERT INTO ong_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ne ne nirpepe pupam piti Jisas pele. Pe wala poututuwo re pirowo nimpi, ");
INSERT INTO ong_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","le wem pe pingitene nirpei nolo Jisas olo nou leiloye le ne nuluwo fei, wolo pe olo pulpope il pene kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jisas lato re fei le nou fale nemtei, le falenge mete noute twinges. Te tato uf ili lepe so wala tingenge tisi te. ");
INSERT INTO ong_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Te rounge nou tau fale uf ili lepe tirpepe ilepe pelnge pepe wolo pe pulponge kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Linglitei, Jisas falepe pupam pele wuso pire esi plen le plen le niliyeye, Jisas falepe wem pe wala paplei oweli. Le lirpei lape wusoli pe pulpope il pele kolo olo le wusoli pe enke lipi, pe pulpope il piti mete wuso puluwo le nou leilo namin ratei lepe, mete fei pepe pe pirpei wolo pupam wuru pepe pe pulpope il pelpe kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jisas lirpepeye, “Ye yinge tef ili yefliye le ise yeptalo mete yire il teingipe piti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Minele piti lulpope il le ise kaltetei, metine fei lepe Ma Ili ma kanowo le minele piti lulpope il kolo olo, metine fei lepe Ma Ili ma kanowo kolo olo. ");
INSERT INTO ong_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mete wuso pulpope il, Ma Ili ma watepe singe piti pe ma pire nange leiki paptu towa ririm olpe taniepe mete, pe ma pirpei il nemple. ");
INSERT INTO ong_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wuso pe kali tutu pesio lo pe palei foiyou fape, pe ma pa kolo olo. Pe ma paptei esi pelpe puwope mete wuso kainu pepe le pe ma nou pire wouye.” ");
INSERT INTO ong_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Apa Ili Jisas lirpepe pupam pele lire il fei pepe re fei, Ma Ili kesi lunwei le teplai yuwei le le lifei eti tilpi liti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pupam pele kere pe peptalo il liye liye re peye, le Ma Ili kaniepe piti ma kosape mete lire il wuso pupam peptalo pepe pe punkom, le Ma Ili laptei men nange fale pingiepe il wuso pupam peptalo pepe. ");
INSERT INTO ong_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Metine ili Tiofilus, mete wuru pirkilau pirpolo ma paptei il pirpei pire men nange wuso fale pirouku pepe. ");
INSERT INTO ong_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Pe paptei il wuso ku mingitepe mete nemple nampli pirpouku pire men nange wuso pinu fale le mete wuso pirpouku pepe pe potei pulwepe lutepe pelpe le pe peptalo il piripe menmen wuso pulwepe fale pepe. ");
INSERT INTO ong_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Metine ili leiki, min polpepe so ki kapi il kaptetei kintatape ke ke fale wem piti men nange fei pepei pe pinu fale pepe le ki so onposi kirpolo ma teingipe wuso ki kapteiye lope puwo yousi, kaptei kingi wem piti pe falele pepe. ");
INSERT INTO ong_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ki kolpepei soma ye ma retape il punkom piti pirpei pire men nange wuso ye ingitepe mete nemple pirpeiye piripe pepe. ");
INSERT INTO ong_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wem metine ili pinawo Herot le luntoluwepe nimoure mete piti tef lite Israel, wem fei lepe metine nele nange lele Sekeraia, le re ratei. Le metine liti leptawio Ma Ili siye le le lite alpe liti Abiya. Sekeraia moto pele nange pene Elisabet le ne re ne nite alpe liti Aron, alpe lelpe piti ma peptawio Ma Ili siye. ");
INSERT INTO ong_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sekeraia lire moto Elisabet me roum ratei teingime, Ma Ili lulpome le me mirkilau mulpope il pite Ma Ili le me roum mingiepe moporo. ");
INSERT INTO ong_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Me roum eple olo wusoli Elisabet olo wilyaine le me roum re olo olme mire moteiye. ");
INSERT INTO ong_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Epli wem nele, le wem lite mete piti alpe lite Abiya pe ma pesio towa lelpe liti peptawio Ma Ili siye le Sekeraia re le ma kaniepe pesio towa lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mete piti peptawio Ma Ili siye pepe pe wai lelpe piti ma keinio metine nele lelpe, keinio piti ma leptawi oweli wopu pifei tile pite Ma Ili. Liso Sekeraia linki le winem lite Ma Ili, ");
INSERT INTO ong_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","wem nimoure mete wurutei pepe pe pratei towa yawi le pe ma peletei Ma Ili wem Sekaraia leptawi oweli wopu pifei tile pile winem leinginim. ");
INSERT INTO ong_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sekeraia leptawi oweli wopu re fei, le le lile tile plen le liti eti tilpi, le wem fei lepe riri lite Ma Ili falowo. ");
INSERT INTO ong_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Wem Sekeraia luluwo, le linlele re turuwo. ");
INSERT INTO ong_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wolo riri lepe le lirpowoye, “Sekeraia, ye turiye pato. Ye eletei Ma Ili le le lingiteiye fei le moto peiye Elisabet, ne ma nilaye lol ninge tulei. Ye ma inawo Jon. ");
INSERT INTO ong_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Onom peiye ma nire flo le ye ma onom teingine le nimoure mete nemple wuru pepe re pe ma onom teingine piri wem nimou nila. ");
INSERT INTO ong_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Le ma fale metine ili lite Ma Ili. Le ma laplei wain tipeluwi lo tipeluwi nemple singe pepe kolo olo. Wem nimou nila tani notei, Riri Teingi ma lunkuwo. ");
INSERT INTO ong_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Le ma kesipe nimoure mete wuru pite Israel, kesipe nou laptowo Ili, le Ma Ili lelpe. ");
INSERT INTO ong_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Le ma linuwo Ili le, le Ma Ili ma watowo singe re longo watafei metine nimou Ilaija. Le ma kesipe yaire re eple tuleingi nou laptei-nemple le nimoure mete piti pinpim il, le ma nou weisipe laptei pingowo tisi liti pratei teingipe tuwopou, le le ma loporipe nimoure mete piti pratei pungario Ili.” ");
INSERT INTO ong_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Fei Sekeraia lirpowo riri lolpepei, “Wuso il pepei pe punkom, ki ma kretai kolomen? Ki oli kire kutei le moto peiki re ne one nire noteiye.” ");
INSERT INTO ong_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Le riri lepe le namti lirpeiye, “Ki Gebriel, ki kile malfem kire Ma Ili le le laiteiki kau piti ma kirpeiye kire il teingipe pepei. ");
INSERT INTO ong_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wolo ye ulpope il peiki kolo olo, le wem lelpetei, il fei pepei pe ma fale punkom. Wusoli ye ulpope il kolo olo, ki ma kapi il nampliye. Ye ma irpepei kolo olo e e fale wem il wuso ki topwepe kapiri kireye pepei pe ma fale punkom, wem moto peiye nila ninge ye ma nou irpepei.” ");
INSERT INTO ong_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wem Sekaraia wala lato winem leinginim, mete wuso pratei towa yawi pepe pe onposisi piti polomen so le lato wem ulel lepe. ");
INSERT INTO ong_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wem Sekeraia noro le towa yawi, le il men re lirpepe nimoure mete kolo le pe so pretai polpepei le lus kere lulwepe men falowo wem le lato winem lite Ma Ili leinginim. Sekeraia il olo lirpei koloye, le lire esi kosape lirpolo pe miso pretai le il olo kapi namplioye. ");
INSERT INTO ong_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wem Sekaraia lesio towa lele liti winem lite Ma Ili lepe, lesio le laltu le nou le uf lele. ");
INSERT INTO ong_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wem re ulel kolo le moto pele Elisabet ne yofu, le ne naro ne towa yawi kolo, ne nato ninge winem leinginim ne anongou twinges te twinges niliyeye (5). ");
INSERT INTO ong_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ne nirpeiye, “Fei onomtei Ma Ili kaneiki lire tisi fei lepei. Ki kilape eple kolo le ki topo oli wolo fei Ma Ili kapi taniki.” ");
INSERT INTO ong_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet wala yofu lultei ne anongou pire esi plen poungo le nele lire eti kera (6), wem fei lepe Ma Ili laisi riri, nange lele Gabriel, Ma Ili laisi riri lepe le uf pinawo Nasaret lato tef liti Galili. ");
INSERT INTO ong_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Riri lepe le lilape il pite moto lainou nenpe wuso pe topwepe il papiri piti ne ma naise metine nele nange lele Josep le le ninge palyene lite metine ili piti luntoluwepe mete piti Israel sungoi liye, nange lele Devit. Le moto lainou nepe ne nange pene Maria. ");
INSERT INTO ong_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Riri lepe le le falene le le lirpeiye, “Onom malye, Ma Ili lireye ratei, le le lirkilau laileleiye.” ");
INSERT INTO ong_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Fei, Maria olo onom moingine nire il pite riri lepe le ne wala onposiepe il pele pe pato polomen. ");
INSERT INTO ong_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Riri lepe le lirpeneye, “Maria, ye turiye pato, wusoli Ma Ili onom teingine lireye. ");
INSERT INTO ong_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ye ma yofu le ye ma ila ninge tulei le ye ma inawo Jisas. ");
INSERT INTO ong_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Le ma fale metine ili le pe ma pinawo pirpolo le ninge lite Ma Ili yuweitei. Ma Ili, le Ili, le ma laltei fale lire metine ili piti luntoluwepe mete watafei mantei lele Devit. ");
INSERT INTO ong_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Le le ma metine ili piti luntoluwepe eple palye pite Jekop, le ma luntoluwepe wem oli oli, le towa lele ma kere kolo, ma lato lingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Fei Maria nirpowo riri lepe nolpepei, “Ki wala moto yefline le fei pepei ma fale polomen?” ");
INSERT INTO ong_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Riri lepe le namti lirpeneye, “Riri Teingi ma lunkiye le singe pite Ma Ili pele puwaleye. Il pal pepei so ninge lepe onom pele ma felkele le pe ma pinawo le ninge lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ye onposiene itatei peiye Elisabet. Pe pirpei polo ne miso nilape eple kolo, wolo ne fei yofu ne anongou pire esi plen poungo le nele piti lire eti kera (6). Ne one nire noteiye wolo, ne fei yofu. ");
INSERT INTO ong_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ma Ili miso lesio men lire wanketei kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Fei Maria nirpeiye, “Ki moto piti kesio towa lite Ma Ili, men wuso irpei pepe ye ma usape faleiki.” Le riri lepe le lusane, le le le taniene. ");
INSERT INTO ong_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wem ulel kari wem wuso riri fale lirpene Maria nepe kolo olo, wem ulel kari kolo, le Maria neifale frou ne uf kumpu lifei tef lupai linpei lifefei, tef lite Judia. ");
INSERT INTO ong_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Maria ne fale ninki ne winem lite Sekeraia le ne neisine Elisabet. ");
INSERT INTO ong_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Wem Elisabet ningitene Maria wuso neisine nepe, eple pratei yofu lite Elisabet nepe pe weitetei pratei leinginim. Riri Teingi lunkuwene Elisabet, ");
INSERT INTO ong_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","le ne nirpei il lipi nirpeiye, “Nimoure eryai pepe pe olo, le ye yoteteiye Ma Ili laileleiye loporotei, le ninge wuso ye ma ila lepe re, Ma Ili lailolowo. ");
INSERT INTO ong_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Piti men ma men lipitei fei pepe pe faleiki le nimou piti ili leiki ne nau nuliki? ");
INSERT INTO ong_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wem ki kingiteiye eiteiki, eple frou weitetei re rautu potei pratei yofu leiki leinginim. ");
INSERT INTO ong_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ye ma onom teingine wuso ye ulpo irpolo il pite Ma Ili pele wuso lirpeiye pepe pe ma fale punkom.” ");
INSERT INTO ong_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Fei Maria nirpeiye, “Onom peiki neila nange lite Ma Ili, ");
INSERT INTO ong_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","le onom peiki teingine niri Ma Ili, le metine piti kaneiki, ");
INSERT INTO ong_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","wusoli le onposiki, ki moto yaune piti kesio towa lele. Fei le le le, mete yeflipiye pe ma pinaiki pirpolo ki onom teingine, ");
INSERT INTO ong_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","wusoli Ma Ili singetei le laptei men lipitei faleiki. Nange lele olo teingitei, ");
INSERT INTO ong_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","le le onom manepe mete wuso turwepe piri lepe, le onom manepe manre le eple palye piti pingi pingi re pepe. ");
INSERT INTO ong_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Le lire eti lele lesio towa ilitei le mete wuso onposi piti ma pesio towa men le pe rautu potei pepe, le laptu pire fla. ");
INSERT INTO ong_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mete lipi piti puntoluwepe mete nemple, le ma laptei pe tef watafei pe mete yaupe, le mete yaupe pepe, le ma namti leilape pe yuwei watafei pe mete lipi. ");
INSERT INTO ong_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mete wuso nimpi naplei pepe, le ma watepe men nange teingipe le mete wuso pe oweli men nange pelpe wurutei pepe, le ma laisipe pire esi yaupe pe. ");
INSERT INTO ong_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Il wuso le topwepe lapiri lire manre yaire pouku pepe, le ma lesiepe lapiri le le ma kanowo Israel, le metine piti lesio towa lele. ");
INSERT INTO ong_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Le onposi piti ma kosawo Abraham le onom manowo le eple palye pite Abraham re le ma onom manepe wem oli oli.” ");
INSERT INTO ong_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Fei Maria nire Elisabet roum ratei anongou twinges niliyeye, le ye lo ne nusane le ne nou ne uf lene. ");
INSERT INTO ong_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wem Elisabet nilape eple, ne nila ninge tulei. ");
INSERT INTO ong_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mete wuso pratei malfem pirine pepe, le nimoure mete piti pepi teluwi alpe niliyeye, pe pingitei wuso Ma Ili lirine teinginetei nepe, le pe pantene pepi enke teingipe pasio. ");
INSERT INTO ong_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wem ninge kumpu lepe le epli wem pire esi plen poungo le twinges niliyeye pite eti plen (8), wem fei lepe pe ma palowi topo lele le pe ma pinawo Sekeraia, nange lite yaitei lele. ");
INSERT INTO ong_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Wolo nimou pele nirpeiye, “Olo, nange lele ma minawo Jon.” ");
INSERT INTO ong_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pe pirpeneye, “Wolo ise pite teluwi alpe niliyeye pepe ise nele leise re le nange lele fei lolpepei lepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Leye lo pe pire esi kosawo yaitei piti ma lirpepe lire nange men le ma linawo kumpu lepe. ");
INSERT INTO ong_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Liso Sekeraia lepletei lire erau yalpe piti ma laltei nange laitei le le so laptei lolpepei, “Nange lele Jon.” Le pe pinlele potei olpe. ");
INSERT INTO ong_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wem fei lepeye Sekeraia nou lirpepei le le leilala nange lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mete wuso pratei malfem piri pepe pe turu potei pire men wuso fale pepe le il rofro pinge tef lupai linpei lifefei lite Judia. ");
INSERT INTO ong_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mete yeflipiye wuso pingitepe il pepe pe onposiepe le pe peite nemple polpepei, “Ninge kumpu fei lepei lepe le ma lolomen?” Le singe pite Ma Ili punkuwo kumpu fei lepe. ");
INSERT INTO ong_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Fei Jon yaitei lele Sekeraia lepe, le Riri Teingi lunkuwo le le lirpei il pite Ma Ili lirpeiye, ");
INSERT INTO ong_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ku meila nange lite Ili, le Ma Ili lite Israel. Le laule kaniepe mete pele le le kesipe laptei pe yawi tanio moingi lite il olpe pelpe. ");
INSERT INTO ong_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Le wauku metine nele singetei, le metine piti ma kanouku. Metine fei lepe le ninge palyene lite Devit, le metine piti lesio towa lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sungoi liye Ma Ili lirpei il fale nemi pite mete emarengi wuso pe enke pelpe olo felkele pepe, le lirpei il pepei: ");
INSERT INTO ong_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Le topwepe il lapiri piti ma kanouku taniepe mete eringi pouku, le le ma kanouku taniepe singe pite mete wuso enke olpe pirouku pepe. ");
INSERT INTO ong_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Le lirpei lolo “Le ma onom manepe manre yaire pouku, le le ma onposiepe il tuwopou pele wuso topwepe lapiri pepe. ");
INSERT INTO ong_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Le topwepe il lapiri lire mani louku Abraham, le le lirpei punkom le ma kanouku taniepe mete eringi pouku, le ku miso mesio towa lele mire topo weli. ");
INSERT INTO ong_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ku enke pouku ma felkele le ku ma mratei teingipe tuwopou le le ma lirouku mratei wem oli oli.” ");
INSERT INTO ong_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Ninge leiki, ye ma pinaye pirpolo ye metine nimou lite Ma Ili yuweitei. Ye ma inuwo Ili e piti ma nalio tisi, ");
INSERT INTO ong_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","le piti ye ma irpepe mete pele irpolo le ma kaniepe le il olpe pelpe le ma onposiepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ma Ili louku, le metine piti onom manepe mete le le metine piti onom malye. Le ma lini luwouku watafei epli, ");
INSERT INTO ong_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","le le ma lini luwo teplai yuwei lau luwoku mete piti mratei tulum munkunum liti ma, le le lini luwouku piti ma kosauku tisi liti ratei mire enke malye.” ");
INSERT INTO ong_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Fei, ninge kumpu lepe le leilo le lire metine ili le Riri Teingi re lirkilau lunkuwo. Le ratei linge tef oli era re telmane ye yawi, ratei le le fale epli wem piti le ma falepe mete piti Israel alepe nimin. ");
INSERT INTO ong_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wem fei lepe metine ili piti luntoluwepe mete pe pinawo Sisar Ogastas, le metine ili lite Rom. Le le lirpepe nimoure mete pele wuso luntoluwepe pepe, le lirpepe piti pe ma paptei nange pelpe le pe ma koponape. ");
INSERT INTO ong_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Wem linutei liti pe paptei nange le pe koponape pepe metine ili piti luntoluwepe mete piti Siria, le nange lele Kwirinius, le lesio towa lunkuwo Sisar Ogastas. ");
INSERT INTO ong_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mete yeflipiye, pe niliyeye niliyeye pe uf tulum wuso emare pilape pepe le pe paptei nange pelpe. ");
INSERT INTO ong_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Fei, Josep lusa uf Nasaret lato tef liti Galili le le le uf nele kumpu Betlehem lato tef liti Israel. Uf kumpu lepe so pila metine ili piti luntoluwepe mete piti Juda sungoi liye, nange lele Devit. Josep le uf kumpu Betlehem wusoli le ninge palyene lite Devit. ");
INSERT INTO ong_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep le laptei nange pele lire moto Maria wuso pe topwepe il papiri piti ma naise. Maria yofu, ");
INSERT INTO ong_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","le wem me roum wala ratei Betlehem, ne ningitei notei piti ma nilape eple. ");
INSERT INTO ong_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ne nila ninge piti linu, ninge tulei, nire olongou weisi le ne nalfo lawo paingo liti paltepe sipsip re bulmakau oweli wusoli elpeingelem pite winem liti mete petetei pepe olo piripe mete poparuye liso Josep lire Maria roum mete mato tulum liti paptepe sipsip re bulmakau oweli. ");
INSERT INTO ong_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mulpou nele mete piti puntoluwepe sipsip, pe pratei puntoluwepe sipsip pelpe pratei tef nele malfem pire uf kumpu Betlehem. ");
INSERT INTO ong_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Fei riri liti Ma Ili lele falepe le singe pite Ma Ili pele fale pini puwope watafei weli. Pe turwepe olpetei, ");
INSERT INTO ong_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","wolo riri lepe le lirpepeye, “Ise turise pato. Ki kilape il teingipe peise kau piti ma piripe enke pite mete yeflipiye teingipe. ");
INSERT INTO ong_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Fei mulpou lepei nimou nila metine piti ma kaneise, le ne nila ratei uf kumpu lite Devit. Metine fei lepe, le Krais, Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ki ma kosaise kire il fei pepei, ise ma yerengawo ninge kumpu nele pe pire olongou weisi le pe palfo lawo paingo lite paltepe sipsip re bulmakau oweli.” ");
INSERT INTO ong_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Frou yo fei, ririm pite yuwei twinges lo niliyeye, kuna wurutei olpe fale pire riri wuso linu fale lepe, pe piri pepi puro weni piti peila nange lite Ma Ili. Pe puro pirpei polo, ");
INSERT INTO ong_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ma Ili yuweitei, singe pele olo lipitei, le mete piti tef wuso le onom teingine lasiepe pepe pe ma pratei pire onom malye.” ");
INSERT INTO ong_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wem ririm nou pe yuwei taniepe mete piti puntoluwepe sipsip pepe, mete pepe pe pirpei nemple polpepei, “Ku me Betlehem muluwo men wuso fale lepe, men wuso Ma Ili lirpouku liri lepe.” ");
INSERT INTO ong_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Liso pe frou pe fale perengame Josep lire Maria le pe puluwo ninge kumpu lawo paingo liti paltepe sipsip re bulmakau oweli. ");
INSERT INTO ong_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wem mete piti puntoluwepe sipsip pepe pe puluwo ninge lepe re fei, pe pirpeme Josep re Maria le mete wuru pepe, pirpepe pire il wuso riri lite yuwei le lirpei liri kumpu fei lepei lepe. ");
INSERT INTO ong_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mete wuso pingitei pepe pe yeflipiye pinlele potei pire il wuso mete piti puntoluwepe sipsip pe pirpepe pepe. ");
INSERT INTO ong_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria naptei men nange fei pepei, naptei pultei onom pene le ne onposiepe neli wo nengleipetei. ");
INSERT INTO ong_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Fei mete piti puntoluwepe sipsip pepe pe nou pe le pe puro weni piti peila nange lite Ma Ili, peila nange lele pire men nange wuso pingitepe re pulwepe pepe le men nange wuso fale pingiepe il wuso riri lite yuwei lirpepe pepe. ");
INSERT INTO ong_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Epli wem pire eti plen poungo le twinges niliyeye piti eti plen (8) wem fei lepe le wem piti pe ma palowi topo lite ninge kumpu lepe le pe pinawo nange Jisas. Nange wuso nimou wala nila kumpu lepe kolo, le riri lite yuwei lele linawo fei. ");
INSERT INTO ong_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Josep lire Maria roum mingiepe il lipi pite Moses wuso pirpei piti nimou re ninge ma mungungu kaptetei opinge pelme tani le wem me roum molpepe re fei, wem fei lepe Josep re Maria me roum mila ninge Jisas me Jerusalem. Roum mila me ma maltei watowo Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Min il lipi pite Ma Ili pe paptei pirpei polo, “Eple tuleingi pite emare pilape pinu pe ma paptei watowo Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Josep lire Maria roum me Jerusalem piti ma memtawio Ma Ili naflepem malpum twinges, epen le longowo lo naflepem fongoi twinges wala so teilo, me roum me mingiepe fei pepei wusoli il lipi pite Ma Ili pirpei. ");
INSERT INTO ong_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Fei metine nele ratei Jerusalem nange lele Simion. Le metine teingi tuwopou le le metine piti turuwo lire Ma Ili, le ratei lungario wem piti Ma Ili ma kaniepe mete pite Israel. Riri Teingi liri ratei, ");
INSERT INTO ong_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","le Riri Teingi lepe le lirpowo Simion lirpolo Simion wala ma la kolo, wala ma ratei luluwo Krais wuso Ma Ili topwepe il lapiri piti ma laltei lau lepe, Simion ma luluwo wo le soma la lingi. ");
INSERT INTO ong_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Riri lite Ma Ili lunkuwo Simion le Simion linki le winem lite Ma Ili. Wem nimou re yaitei mila ninge Jisas minki me winem lepei piti ma mingiepe il wuso il lipi pirpei pepe, ");
INSERT INTO ong_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion kali ninge kumpu lepe laungi le le lirpowo Ma Ili lire onom teingine pele Simion lirpei lolo, ");
INSERT INTO ong_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Fei, Ma Ili ye ingiepe il peiye wuso topwepe apiri pepe, le ye ma usa metine leiye liti lesio towa leiye, usa le lire onom malye. ");
INSERT INTO ong_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Lutepe peiki kutei ki kuluwo metine piti ma kaniepe mete piti tef. ");
INSERT INTO ong_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ye altei fale, lutepe pite mete yeflipiye piti pe ma puluwo. ");
INSERT INTO ong_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Le weli piti ma nainu tisi lite mete piti alpe nemple pe ma pingowo le pe ma peila nange lite mete peiye Israel.” ");
INSERT INTO ong_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Fei kumpu lepe nimou re yaitei mele me roum minlele motei mire il men nange wuso Simion lirpei liri lepe. ");
INSERT INTO ong_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simion leletei Ma Ili piti ma laileleme re luntoluweme le le lirpene Maria, nimou pite kumpu lepe, Simion lirpeneye, “Ninge lepei Ma Ili keinio piti ma kaniepe mete wuru pite Israel le mete wuru pite Israel le ma liripe nemple. Ma Ili laltei piti ma mete puluwo le pe ma pire il purawo. ");
INSERT INTO ong_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Le pe polpepe soma il men piti kotire pato enke pelpe re pe miso kotuwepe paptei alepe nimin. Le ye onom peiye ma onetei wata pirpolo werau leiweye rapune onom peiye yotei nepe.” ");
INSERT INTO ong_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Moto nenpe re ratei, nange pene Ana. Ne nesio towa lene watafei metine nimou le ne yaitei lene Fanuel. Ne piti alpe lite Aser. Ne naise munge le me roum ratei me eringi pire eti plen poungo le twinges tite eti plen le munge lene la le ne noteteiye ratei, ne ne fei ne one nire noteiye. ");
INSERT INTO ong_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Le ne eringi pene wurutei (84). Ne nusa winem lite Ma Ili kolo olo, wem oli oli ne naitire nile winem lepe, epli mulpou ne rautuwo Ma Ili. Ne nire nimpi nato yaune le ne neletei Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Wem Simion wala laungi ninge kumpu Jisas, wem fei lepeye Ana re ne fale winem lepei, le ne nirpowo Ma Ili nire onom teingine pene. Le ne nirpei niri kumpu lepe, nirpepe mete yeflipi wuso pratei pungario wem piti Ma Ili ma kaniepe mete piti Jerusalem. ");
INSERT INTO ong_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wem Josep lire Maria roum mingiepe il wuso paitei il lipi pite Ma Ili pepe, roum mingiepe me maptu re fei, me roum nou me Galili, roum me uf lelme Nasaret. ");
INSERT INTO ong_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Fei ninge kumpu lepe le leilo le ili singe, le le onom pele nire wuru, onom ulene, le Ma Ili lailolowo re luntoluwo. ");
INSERT INTO ong_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Eringi nempleiyeye nempleiyeye nimou re yaitei mite Jisas roum me Jerusalem piti ma rautuwo re onposio wem ili wuso Ma Ili kaniepe manre yaire pelpe piti Israel pau tani Isip. ");
INSERT INTO ong_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wem Jisas eringi pele fale pire esi plen le plen te twinges (12), le lire nimou re yaitei nou pe Jerusalem watafei eringi pinu pinu re pepe. ");
INSERT INTO ong_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Epli wem piti rautuwo wem ili lepe pe kere re fei, Josep lire Maria re ninge Jisas ma nou pe uf wolo ninge kumpu Jisas wala lato Jerusalem. Nimou re yaitei mele olo roum retai kolo, ");
INSERT INTO ong_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","me roum onposi mirpolo le liripe mete wuru pepe pepi pe liso epli ulel lepe me roum mironom meye. Leye lo me roum mintatawo, roum mepletetei numuwi re ilim winkem pelme miri. ");
INSERT INTO ong_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Me roum merengawo kolo olo liso me roum nou mintatawo me Jerusalem. ");
INSERT INTO ong_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Epli wem twinges niliyeye kari re fei me so roum merengawo lifei winem lite Ma Ili, lifei lire mete lipi pite Juda, pe mete piti peptalo mete il. Le lifei lingitepe pirpepei le le lepletetei. ");
INSERT INTO ong_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mete yeflipi wuso pingitowo pepe pe pinlele potei pire il pele wuso le namti lirpei pepe wusoli le lirpei watafei le metine piti retaitei. ");
INSERT INTO ong_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nimou re yaitei mele me roum minlele motei wem me muluwo le nimou pele nirpowoye, “Ninge leiki, piti men so ye olpepe irouku lepe? Ki kire yaitei leiye onom re onetei piti wintaiye.” ");
INSERT INTO ong_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Le ninge Jisas namti lirpemeye, “Piti men ma ise roum yintaiki? Ise roum retai piti ki ma kifei winem lite Eiya leiki lo olo?” ");
INSERT INTO ong_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wolo me roum mironom mire il wuso le lirpeme meme. ");
INSERT INTO ong_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Liso Jisas nou lirime nimou re yaitei pepi pe Nasaret le le lapteme mingim. Nimou pele Maria, ne naptei men nange fei pepei pultei onom pene. ");
INSERT INTO ong_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Le Jisas leilo le ili, onom pele re nawowo, Ma Ili lulpowo le mete piti tef re pe onom teingine pasio. ");
INSERT INTO ong_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Metine ili liti Rom, le metine ilitei, nange lele Taiberius, le lesio towa lele piti lontoluwepe tef re mete wuru. Eringi pele piti lesio towa fei lepei lepe, eringi pele fale pire eti plen poungo le plen poungo le pe nou piti eti poungo (15), wem fei lepe mete lipi piti pesio towa punkukuwo metine ili Taiberius lepe, Pontius Pailat le luntoluwepe mete piti Judia. Herot luntoluwepe mete piti Galili, le winke lele Filip le luntoluwepe piti tef lite Ituria re Trakonitis. Lisanias le luntoluwepe mete piti tef lite Abilene, ");
INSERT INTO ong_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","le Anas re Kaiafas te rounge tesio tinuwepe mete piti peptawio Ma Ili siye. Wem fei lepe il pite Ma Ili pe falowo Jon ratei tef oli era re telmane-ye yawi. Jon le ninge lite Sekeraia. ");
INSERT INTO ong_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Liso Jon leptalo il linge tef ili yefliye linge wof Jodan, leptalo il lirpei lolo, “Yusape il olpe peise le ise yungungu, le Ma Ili ma onposiepe il olpe peise kolo.” ");
INSERT INTO ong_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Min watafei metine nimou Aisaia laptei il paitei yousi lirpei lolo, “Metine nele lailolo ratei tef oli era re telmane-ye yawi, lailo lirpeiye, ‘Nali tisi lite Ili elpesi latowo yaltei tisi tuwopou piti le ma lingowo. ");
INSERT INTO ong_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tef towile ma yalwe yalfofo le tumun re tef lupai linpei lifefei lepe, ise ma rarupu yire filau. Tisi piti peinenei, ise ma kesipe yaptei pire tuwopou le tisi piti fale pifefei, ise ma rarupu yire filau. ");
INSERT INTO ong_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mete eryai, pe yeflipiye ma puluwo wem piti Ma Ili ma kaniepe.” ");
INSERT INTO ong_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mete wurutei pau falowo Jon piti le ma kaptetei, wolo le lirpepeye, “Ise eple pite tutungu, minemple pirpeise pirpolo ise miso yantu tanio moingi lite Ma Ili piti ma faleise lepe? ");
INSERT INTO ong_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Towa men ma ise yesio piti ma kosai isotei yirpolo ise olo weitei yofu fei. Le ise ma yirpei nemple yirpolo Abraham le mani leise, olo ki kirpeise, Ma Ili miso weisipe era fei pepei laptei fale pire eple palye pite Abraham. ");
INSERT INTO ong_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tomoiye olo elpesi luwo piti ma piri peplele nimpe, peplele pratei nalem tef, nimpe yeflipiye wuso pilape fouri teingipe kolo, olo pepe, pe ma peplele piripe pinki weli.” ");
INSERT INTO ong_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Leye lo mete wurutei pepe pe peletei Jon polpepei, “Le ku ma molomen?” ");
INSERT INTO ong_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Le Jon namti lirpepeye, “Minele piti lesienge olol twinges piti lafo pifei teingo yuwei, le ma kali nele watowo metine nele wuso le olo lepe. Le minele piti lesiepe oweli, le ma nempipe laptepe mete nemple.” ");
INSERT INTO ong_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Fei mete piti kapiepe mete era pe paule piti ma Jon kaptei le pe peletei Jon polpepei, “Ye metine piti eptalo mete, ku ma molomen?” ");
INSERT INTO ong_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Ise ma kapiepe mete era ye yile wai lelpe wuso moli lipi pirpei piti ise ma kapipi pepe, le ise ma kapi nemple yaupe kolo olo.” Jon lirpepe. ");
INSERT INTO ong_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Leye lo yali pal piti plolpo, ilepe pelpe re peletei Jon polpepei, “Le ku, ku ma molomen?” Le Jon namti lirpepeye, “Ise ma yire singe peise piti kapi era taniepe mete nemple kolo olo, lo ise ma yamtuwepe mete nemple yaupe kolo olo. Ise ma onom teingine yasiepe era wuso moli lipi peise paiteise pepe.” ");
INSERT INTO ong_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Fei mete enke pelpe peilo le pe onposisi re pirpei potei enke leinginim, pirpei piri Jon, onposi pirpolo le so Krais lepe. ");
INSERT INTO ong_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Liso Jon lirpepe pe yeflipiye lirpolo, “Ki keiteteise kire tipe wolo metine nele le ilitei linuki le miso laule. Ki olo teingi kolo piti ma nenfaripe foiye pite ire filengi pele. Le ma keiteteise lire singe pite Riri Teingi le lire weli. ");
INSERT INTO ong_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Le ma karipe mete teingipe taniepe piti olpe. Min watafei wit wuso mete kari lepe. Wit fouri teingi pe kari tani le wit emare oli lepe pe palowi pelesi weli piti loli wem oli oli.” ");
INSERT INTO ong_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon lirpepe mete lire il wuru wem le leptalo lire il teingipe pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wolo Jon il poluwo metine ili piti luntoluwepe mete, pinawo Herot, Jon il poluwo wusoli Herot laisene Herodias. Ne moto pite winke lele, le Herot lotei re le lingiepe il olpe wuru. ");
INSERT INTO ong_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Leye lo Herot lirkilau lingowo tisi oli, le laltei Jon lifei winem oli. ");
INSERT INTO ong_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mete yeflipiye pungungu re fei le Jisas re lungungu. Wem Jisas wala leletetei Ma Ili, teplai lungo, ");
INSERT INTO ong_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","le Riri Teingi lualo lifowo oru lite Jisas watafei nafle malpu. Le il nemple fale teplai yuwei pau pirpei polpepei, “Ye ninge nange leikitei. Ki onom teinginetei kasiye.” ");
INSERT INTO ong_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Wem linu piti Jisas lesio towa lele, le eringi pele wuru (30). Le ninge tulei liso mete onposio yaitei Josep wuso le ninge lite Heli. ");
INSERT INTO ong_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli le ninge lite Mathat, Mathat le ninge lite Livai, Livai le ninge lite Melki, Melki le ninge lite Janai, le Janai le ninge lite Josep. ");
INSERT INTO ong_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep le ninge lite Matias, Matias le ninge lite Amos, Amos le ninge lite Nahum, Nahum le ninge lite Esli, Esli le ninge lite Nagai. ");
INSERT INTO ong_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai le ninge lite Mat, Mat le ninge lite Matias, Matias le ninge lite Semein, Semein le ninge lite Josek, Josek le ninge lite Joda. ");
INSERT INTO ong_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda le ninge lite Joanan, Joanan le ninge lite Resa, Resa le ninge lite Serubabel, Serubabel le ninge lite Sealtiel, Sealtiel le ninge lite Neri. ");
INSERT INTO ong_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri le ninge lite Melki, Melki le ninge lite Adi, Adi le ninge lite Kosam, Kosam le ninge lite Elmadam, Elmadam le ninge lite Er. ");
INSERT INTO ong_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er le ninge lite Josua, Josua le ninge lite Elieser, Elieser le ninge lite Jorim, Jorim le ninge lite Matat, Matat le ninge lite Livai. ");
INSERT INTO ong_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai le ninge lite Simion, Simion le ninge lite Juda, Juda le ninge lite Josep, Josep le ninge lite Jonam, Jonam le ninge lite Eliakim. ");
INSERT INTO ong_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim le ninge lite Melea, Melea le ninge lite Mena, Mena le ninge lite Matata, Matata le ninge lite Natan, Natan le ninge lite Devit. ");
INSERT INTO ong_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit le ninge lite Jesi, Jesi le ninge lite Obed, Obed le ninge lite Boas, Boas le ninge lite Salmon, Salmon le ninge lite Nason. ");
INSERT INTO ong_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason le ninge lite Aminadap, Aminadap le ninge lite Admin, Admin le ninge lite Arni, Arni le ninge lite Hesron, Hesron le ninge lite Peres, Peres le ninge lite Juda. ");
INSERT INTO ong_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda le ninge lite Jekop, Jekop le ninge lite Aisak, Aisak le ninge lite Abraham, Abraham le ninge lite Tera, Tera le ninge lite Nahor. ");
INSERT INTO ong_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor le ninge lite Seruk, Seruk le ninge lite Reu, Reu le ninge lite Pelek, Pelek le ninge lite Eber, Eber le ninge lite Sela. ");
INSERT INTO ong_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela le ninge lite Kainan, Kainan le ninge lite Arpaksat, Arpaksat le ninge lite Siem, Siem le ninge lite Noa, Noa le ninge lite Lamek. ");
INSERT INTO ong_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek le ninge lite Metusala, Metusala le ninge lite Enok, Enok le ninge lite Jaret, Jaret le ninge lite Mahalalel, Mahalalel le ninge lite Kainan. ");
INSERT INTO ong_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan le ninge lite Enos, Enos le ninge lite Set, Set le ninge lite Adam, Adam le ninge lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisas lusa wof Jodan le le nou le le Riri Teingi lirkilau lunkuwo le Riri kesi lila le tef oli era re telmane ye yawi. ");
INSERT INTO ong_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tulum fei lepe towa fale lempesesi epli wem wuru (40). Le epli wem fei pepe Jisas lalei men re kolo, lato yawi le wem epli wem fei pepe pe kere, le nimpi nalei. ");
INSERT INTO ong_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Fei towa lirpowo Jisas lolpepei, “Wuso ye ninge lite Ma Ili, irpowo erau lepei le le ma weitei lire luom.” ");
INSERT INTO ong_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisas namti lirpowoye, “Il paitei yousi pirpei polpepei, ‘Luom yawi ma kanowo metine kolo olo’.” ");
INSERT INTO ong_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Leye lo towa kesi Jisas lila le tulum nele yuwei le le frou kosawo Jisas lire men nange pite tef. ");
INSERT INTO ong_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Ki ma waiye singe re yini yeflipiye pepei. Ma Ili waiki men nange yeflipiye le metine minele ki keinio, ki ma watowo men nange fei pepei. ");
INSERT INTO ong_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Men nange yeflipiye fei pepei pe ma peiye wuso ye ma yaru yamkelem rautuki.” towa lirpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas namti lirpowo towa lolpepei “Il paitei yousi pirpei polpepei, ‘Ye ma rautuwo Ili, le Ma Ili leiye le ye ma esio towa lele loteteiye’.” ");
INSERT INTO ong_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Leye lo towa kesi Jisas lila le fale Jerusalem laltei lile tupe lite winem lite Ma Ili, le le lirpowo Jisas lolpepei, “Wuso ye ninge lite Ma Ili, ile lepei le ye iri yotei uwalo e tef. ");
INSERT INTO ong_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Wusoli il paitei yousi pirpei polo, ‘Ma Ili miso lirpepe ririm pele piti ma puntoliye paileleiye.’ ");
INSERT INTO ong_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Il pepe re pirpei polo, ‘Ririm pepe pe miso pire esi pelpe pesiye yuwei soma ire peiye re ye miso eplangu asi era kolo olo’.” ");
INSERT INTO ong_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisas nou lirpowo towa lolpepei, “Il paitei yousi pirpei polpepei, ‘Ili, le Ma Ili leiye, le ye ma empesesi kolo olo’.” ");
INSERT INTO ong_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wem towa lempesesi Jisas lire il fei pepei re fei, le lusa Jisas le le le tanio, le lato lungario wem nele. ");
INSERT INTO ong_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Leye lo Jisas nou le Galili le singe pite Riri Teingi piri ratei. Mete kete il pirpei piri le il rofro pinge tef ili yefliye lite Galili. ");
INSERT INTO ong_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jisas leptalo mete lifei angli pal pelpe le mete pepe pe yeflipiye peila nange lele. ");
INSERT INTO ong_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Leye lo Jisas le Nasaret, uf wuso nimou yaitei roum muntoluwo ratei le le leilo le ili lepe, le epli wem piti pe ma pifei onposio Ma Ili le Jisas wem lele piti ma le angli pau liso epli wem fei lepe le le angli pau. Jisas leilo lile piti ma lungunape il wuso paitei yousi pepe, ");
INSERT INTO ong_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","le pe watowo yousi pite metine nimou Aisaia. Jisas nempipe yousi le le lerengape il wuso paptei paitei yousi pepe pe pirpei polpepei, ");
INSERT INTO ong_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Riri lite Ma Ili lireiki ratei wusoli Ma Ili keiniki piti ma keptalo il teingipe pele pe mete wuso pe oweli yini nange naplei pepe. Le laiteiki kau piti ma keptalo il piti kaniepe mete wuso pingiepe il olpe le moingi ma falepe pepe, le mete wuso lutepe pelpe olpe pepe pe ma nou puntolili, le mete wuso pila moingi pe ma peinei nautowo moingi fei lepe. ");
INSERT INTO ong_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Le ki ma keptalo il kirpei kire eringi pite wem Ma Ili ma kaniepe mete pele.” ");
INSERT INTO ong_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Fei Jisas nou laptei yousi paitei nemple, weisipe watowo metine piti kanowo le le lungura lifei. Mete wuso pifei angli pau pepe pe yeflipiye lus poluwo Jisas. ");
INSERT INTO ong_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jisas lirpepeye, “Il kumpu wuso paitei yousi pepei pepe pe fei fale punkom wem ise yingiteiki kungunape.” ");
INSERT INTO ong_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pe yeflipiye enke teingipe pasio le pe yafei pire il teingipe wuso lirpei pepe. Pe pirpeiye, “Le ninge lite Josep lom?” ");
INSERT INTO ong_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Le Jisas lirpepe lolpepei, “Ki kretai punkom ise ma yirpeiki yire il pite mete emare yolpepei, ‘Metine nimou, ye kapi kainu peiye tani yotei.’ Le ise re ma yirpeiki yolpepei, ‘Men nange wuso ye esiepe fale Kaperneam, le ku mingitepe mete pirpei piripe pepe, men fei pepe soma ye esiepe fale uf kumpu leiye yotei ko’.” ");
INSERT INTO ong_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Le Jisas nou lirpei lasiepe lolpepei, “Metine nimou uf nange lele lotei ma pinauli. ");
INSERT INTO ong_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yingitei, ki kirpeise punkom, towa nimoure wuru pratei Israel wem Ilaija ratei le wem fei lepe eringi twinges niliyeye le anongou pire esi plen poungo le niliyeye nef olo nalolo kolo. Le wem fei lepe tef ili yefliye oweli olotei, le mete nimpi naplei. ");
INSERT INTO ong_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Wolo Ma Ili laisi Ilaija le towa nimoure wuru pepe kolo olo, le laisi le towa moto pite uf Sarepat lato tef lite Saidon. ");
INSERT INTO ong_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Le mete wuru wuso pape olpe polwepe pepe pe pratei Israel wem metine nimou Elisa ratei wolo nele lelpe re nou fale teingi kolo olo, Naman lite Siria le loteteiye nou fale teingi.” ");
INSERT INTO ong_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Fei mete wuso pifei angli pau pepe pe yeflipiye enke kotu wem pe pingitepe il wuso Jisas lirpei pepe. ");
INSERT INTO ong_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pe peifale peipi Jisas pila naro pe yawi tani uf kumpu lepe le pe kesi pila pe tef lupai linpei lifei wuso pe peila uf lepe lifei lepe, pe pe kesi Jisas pila pe tulum fei lepe piti ma piri lualo alu wanketei. ");
INSERT INTO ong_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wolo Jisas lilele le linge nimin lite mete wurutei pepe leye. ");
INSERT INTO ong_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Leye lo Jisas le Kaperneam, uf lato Galili le uf fei lepe Jisas leptalo mete epli wem nele piti onposio Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mete pepe pe yeflipiye pinlele potei pire wai lele piti leptalo il wusoli il pele olo singe rasipe. ");
INSERT INTO ong_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Metine nele lifei angli pau lepe le riri oli lunkuwo. Le lailolo lirkilau lirpei lolo, ");
INSERT INTO ong_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Kwa Jisas lite Nasaret, ko ye ma olomen irouku? Ye ma irouku nemple lom? Ki kretai ye minele, ye metine piti onom felkeletei wuso Ma Ili laiteiye ilape il pele au lepe.” ");
INSERT INTO ong_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisas lire il singe lirpowo riri wuso lunkuwo metine wape lepe lirpeiye, “Pos ato le ye naro tanio metine lepe.” Fei riri oli lepe le liri metine lepe lualo lato lutepe pelpe wolo le watowo metine wape flis kolo olo, le naro le tanio yawiye. ");
INSERT INTO ong_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mete pepe pe yeflipiye pinlele potei le pe pirpei nemple polpepei, “Il menemple so polpepei? Le lirpei le il pele olo singe rasipe liso ririm olpe re pe paptowo mingim le pe naro pe yawi.” ");
INSERT INTO ong_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Le mete kete il pirpei piri Jisas, il rofro liye liye re pe pinge uf walem wuso pratei neinowo uf Kaperneam pepe. ");
INSERT INTO ong_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas lusa angli pau, le le le winem lite Saimon. Saimon nimou pite moto pele, ne kainu nirkilau nire topo weli le pe pirpowo Jisas pirine ne. ");
INSERT INTO ong_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jisas le lile poi mingo pene le le lire il singe lirpepe kainu pepe. Fei kainu pepe oloye le ne frou neifale kapi oweli watepe. ");
INSERT INTO ong_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Epli lautile re fei, mete yeflipiye wuso numuwi pelpe kainu polomen polomen re pe kapi pilape pau paptowo Jisas. Le leptalo esi pele puwope le pe yeflipiye nou fale teingipe. ");
INSERT INTO ong_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ririm olpe pepe re naro taniepe mete wuru wuso punkuwepe pepe, pailolo pirpeiye, “Ye ninge lite Ma Ili.” Jisas lire il singe lirpepe le le il karipe piti ma pirpei kolo wusoli pe pretai le Krais. ");
INSERT INTO ong_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nolowi mul Jisas lusa uf Kaperneam lepe le le le tulum nele yawi mete pratei kolo. Mete peifale pintatawo le wem pe perengawo pe malfefi piti ma lusape le le le taniepe kolo. ");
INSERT INTO ong_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wolo Jisas lirpepe lolpepei, “Il teingipe pite wem Ma Ili ma luntoluwepe mete pele, il fei pepe ki ma keptalo ke uf walem nemple nemple re ke, wusoli Ma Ili laiteiki kau piti ma kolpepe.” ");
INSERT INTO ong_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Liso Jisas leptalo il lifei angli pal pelpe pinge tef ili yefliye lite Judia. ");
INSERT INTO ong_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Epli wem nele Jisas lile mingo lite tuluple Genesaret le mete wurutei fale panfi piti ma pingitepe il pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jisas lulwenge nimpe teingelem twinges taitei telmane lite tuluple mingo lepe le mete piti pengleipe ningu pe pusape nimpe teingelem tepe le pe pe kaptetei taimere pelpe. ");
INSERT INTO ong_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Fei Jisas longlo nimpe teingo nele lepe, le lite Saimon lele, le Jisas lirpowo Saimon piti ma raltuwe nimpe teingo le fiyen taise lire tuluple mingo. Jisas lifei nimpe teingo lepe le le leptalo mete. ");
INSERT INTO ong_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wem Jisas lirpei il lapulu re fei, le lirpowo Saimon lolpepei, “Raltuwe nimpe teingo le tipe nimin taise le ye iripe lainiyongou wane peiye yiripe taimere peise piti ma yengleipe ningu.” ");
INSERT INTO ong_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon namti lirpowo Jisas, “Ili leiki, mulpou ulel lepe ku mirkilau mesio towa piti ma mengleipe ningu wolo olo, ku mengleipe nemple kolo. Le wuso ye irpei, ki ma kiripe taimere.” ");
INSERT INTO ong_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Fei pe piripe taimere pautile le pe pengleipe ningu wurutei olpe, le taimere re ma kere pasiepe ningu. ");
INSERT INTO ong_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Liso pe penyope eti lainiyongou wane ilepe pelpe wuso pifei nimpe teingo nele lepe piti ma paule kaniepe. Pe paule kaniepe le pe pafo ningu nimpe teingele twinges tepe, ningu pirkilau pafo, nimpe teingelem re moingi ma tautile tulupleye ko. ");
INSERT INTO ong_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wem Saimon lulwepe men wuso fale pepe, le lualo yaru yamkelem ratei onom pite Jisas le le lirpeiye, “Ili, ye e taniki, ki metine oli piti kingiepe il olpe.” ");
INSERT INTO ong_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimon re lainiyongou wane pele wuso pepi pifei nimpe teingo pepe pe pinlele potei pire ningu wurutei wuso pengleipe pepe. ");
INSERT INTO ong_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon lainiyongou wane tele Jems re Jon, te eple winge tite Sebedi, te re tinlele totei. Jisas lirpowo Saimon lolpepei, “Ye turiye pato, wem fei lepei le le le ye ma engleipe mete watafei ye engleipe ningu pepe.” ");
INSERT INTO ong_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Fei, pe peipipe nimpe teingelem paptei paitei telmane lite tuluple mingo lepe, pusape men nange yeflipiye le pe pulsi Jisas. ");
INSERT INTO ong_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wem nele Jisas lifei uf kumpu nele le metine nele le pape olpe poluwo, le ratei uf kumpu fei lepe. Wem metine lepe le luluwo Jisas, le liri lotei lualo lato tef le le malfefi Jisas lolpepei, “Ili leiki, wuso ye onom maneiki, ye ma kaneiki nou fale teingi.” ");
INSERT INTO ong_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Fei Jisas kete eti laltei le lesio le le namti lirpowo metine lepe lolpepei, “Ki onom maneiye soma kolpepe, ye nou fale teingi.” Fro you fei, pape olpe pepe pautuye. ");
INSERT INTO ong_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Le Jisas lire il singe lirpowo metine lepe lolpepei, “Irpowo metine nele ire men wuso faleye lepe kolo olo, ye karowo metine piti leptawio Ma Ili siye, karowo e le ye usa le ma luliye. Leye lo ye ma eptawi siye aptowo Ma Ili ingiepe il wuso Moses lirpei pepe. Ye olpepe soma ye kosape mete wuruye olpepei ye olo nou fale teingiye.” ");
INSERT INTO ong_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wolo mete kete il pirpei piri Jisas le il rofro pe uf mete fiyen fiyen re pe le mete wurutei pau pingitepe il pele le piti le ma kapi kainu pelpe taniepe. ");
INSERT INTO ong_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wolo Jisas ma le tulum nele yawi piti le ma leletei Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Epli wem nele wem Jisas leptalo mete, mete ilepe piti Farasi le mete piti peptalo mete pire il lipi pite Moses, mete fei pepei re pe pifei. Pe pite uf walem kumpu pite Galili re Judia le pe pite Jerusalem. Le singe pite Ma Ili pele olo piri Jisas pratei piti le ma kapi kainu taniepe mete. ");
INSERT INTO ong_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Fei, mete nemple pila metine nele ire esi pa, pila luwo flenge le pe pirpolo ma pila pingi pe winem piti ma paltei ratei onom pite Jisas. ");
INSERT INTO ong_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wolo pe pinki pe winem kolo olo wusoli mete olo wurutei. Pe so kali pila punwei pe winem yuwei, peila winem tupe le pe palfo leingalo, pusa malye malye luwo flenge pele pepe, pusa le karipe mete nimin le ratei onom pite Jisas. ");
INSERT INTO ong_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wem Jisas lulwepe mete wuso kanowo metine lepe pe pirkilau pulpowo, le lirpowo metine wuso ire esi pa lepe lirpowoye, “Numu leiki, il olpe peiye ma ki onposiepe kolo oloye.” ");
INSERT INTO ong_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Fei, mete piti peptalo mete pire il lipi pite Moses le mete piti Farasi, pe pirpepei nempleiye, “Metine mi so lepei wuso lirpei kelelawo Ma Ili lepe? Ma Ili loteteiye miso onposiepe il olpe pite metine nele kolo olo, metine nele yawi miso lolpepe kolo olotei.” ");
INSERT INTO ong_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisas retape enke pelpe le le so lepletei lolpepei, “Piti men so ise onposiepe men nange fei pepe? ");
INSERT INTO ong_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Il men flo ma ki kirpei, ki ma kirpei kolo, ‘Il olpe peiye ma ki onposiepe kolo, lo ki ma kirpei kolo, eifale ilele e, ki ma kirpei kolpepe lom?’ ");
INSERT INTO ong_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ki ma kosaise kire Ninge Lite Metine Wape, le kapi singe piti ma onposiepe il olpe pite mete kolo olo, wem le ratei tef fei lepei.” Liso Jisas lirpowo metine wuso ire esi pa lepe lirpowo lolpepei, “Ki kirpeiye, eilo ile, kapi flenge peiye le ye e uf leiye.” ");
INSERT INTO ong_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Frou yo fei metine lepe leilo lile enke pelpe yeflipiye. Le kapi flenge wuso letei luwo pepe le le le uf, leilala nange lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pe yeflipiye pinlele potei olpe. Pe turwepetei le pe peila nange lite Ma Ili pirpeiye, “Menemple wala yeflipitei so ku fei mulwepe pepei pepe. Wem linu linu re ku mulwepe kolo olo, feiye ku mulwepe.” ");
INSERT INTO ong_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jisas kanowo metine wuso ire esi pa lepe, kanowo re fei, le naro le le le luluwo metine liti kapiepe mete era, nange lele Livai. Le lifei winem kumpu lele piti ma kapiepe mete era. Jisas lirpowoye, “Eifale ulteiki.” ");
INSERT INTO ong_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Livai leilo lusape men nange yeflipiye le le lulsi Jisas. ");
INSERT INTO ong_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leye lo Livai laplio Jisas oweli lipi lifei winem lele le mete piti kapiepe mete era, pe pesio towa niliyeye watafei Livai lotei lepe, wuru pelpe le mete nemple re pe pepi pifei paplei. ");
INSERT INTO ong_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mete ilepe pite Farisi le mete piti peptalo mete pire il lipi pite Moses, pe wuso pite Farasi pepe, pe yaru mi pirpepe pupam pite Jisas. Pe pepletei polpepei, “Piti men so ise yaplei oweli re tipeluwi yire mete piti kapiepe mete era le mete piti pire il olpe pepe?” ");
INSERT INTO ong_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Fei Jisas namti lirpepe lolpepei, “Mete teingipe, pe ma pe puluwo metine nimou kolo olo, wolo pe piti kainu soma pe puluwo. ");
INSERT INTO ong_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ki kaule piti ma kinape mete teingipe kolo olo, wolo ki kaule piti ma kinape mete piti pingiepe il olpe, kinape piti pe ma weitei yefi.” ");
INSERT INTO ong_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mete ilepe pirpowo Jisas polpepei, “Pupam pite Jon wem wuru pe paplei oweli kolo, pato yaupe le pe peletei Ma Ili, le pupam pite Farasi re pe polpepe watafei pupam pite Jon pepe. Wolo ye pupam peiye pe paplei oweli re tipeluwi.” ");
INSERT INTO ong_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisas namti lirpepe lolpepei, “Ise onposi yirpolo wem metine piti laisene moto nepe wem le wala ratei le mete wuso linape paule panfi pepe ise ma watepe oweli kolo lom? Miso olo. ");
INSERT INTO ong_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wolo wem wala lato, wem fei lepe, metine piti laisene moto nepe le ma pe kesi taniepe le wem fei lepe soma pe pirowo nimpi pato yaupe.” ");
INSERT INTO ong_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Il nemple kauro yuwei pepei re Jisas lirpepe lasiepe lolpepei, “Metine nele re miso kali takor oli punko lalwewe lasio piti teingi namin lo ma olo? Miso olo. Takor oli punko ma kerere frou. ");
INSERT INTO ong_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Lo metine minele miso lire wengle tipio lalfo luom lali le weli miso lalei luom loporo lo olo? Miso olo, weli ma lalei kereri wengle tipio le luom leinginim wala ma namin. ");
INSERT INTO ong_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Luom ma alfo wengle teingi yefli soma weli lalei luom loporo. ");
INSERT INTO ong_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Metine laplei oweli le le lingitepe kare nemi, le ma onom kerepe oweli pinu pepe le nemple yeflipi ma lentelepe re linaulipe, le ma lirpei lolo, ‘Oweli piti kinu kaplei pepe pe teingipe kare nemi’.” ");
INSERT INTO ong_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jisas lilele le linge liom lite pari wit le wem fei lepe le wem liti pe ma pifei onposio Ma Ili. Pupam pite Jisas karipe wit fouri le pe pesipipe paplei. ");
INSERT INTO ong_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fei mete ilepe pite Farasi pe pepletei pirpeiye, “Piti men ise yolpepe? Il lipi pite Moses pirpei polpepei, epli wem piti ku ma mifei onposio Ma Ili lepe, wem fei lepe ku ma mifei yaupe, ma mesio towa men kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisas namti lirpepe lolpepei, “Ko ise yungunape il lo olo? Devit lesi men wem le liripe mete pele nimpi naplei? ");
INSERT INTO ong_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Le linki le winem lite Ma Ili kali luom wuso paltei watowo Ma Ili lepe, lalei ile le le watepe mete pele re palei. Wolo il lipi pouku pe pirpei il karouku pirpolo ku mete nemple yaupe ma malei luom fei lepe kolo, mete piti peptawio Ma Ili siye, pe poteteiye miso palei.” ");
INSERT INTO ong_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Le Jisas lirpei il lapulu lolpepei, “Ninge liti Metine Wape le luntoluwo wem liti pifei onposio Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Epli wem nele liti pifei onposio Ma Ili, Jisas linki le lifei angli pau nele le le leptalo mete. Metine nele eti tilpi lele oli, le re lifei angli pau lepe. ");
INSERT INTO ong_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mete ilepe piti peptalo mete pire il lipi pite Moses le mete pite Farasi, pe pinta tisi piti ma pamtuwo Jisas pirpolo le lingiepe il olpe le pe so lupoluwo waipiti le ma kapi kainu taniepe mete wem pe pifei onposio Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wolo Jisas retape enke pelpe le le so lirpowo metine wuso eti oli lepe, le lirpowo lolpepei, Eilo ile le ye au ile onom pelpe lepei.” Fei metine lepe leilo le le le lile onom pelpe. ");
INSERT INTO ong_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Leye lo Jisas lepletei lolpepei, “Ki keiteise, il lipi pouku pirpei piti ku ma molomen wem ku mifei onposio Ma Ili? Ku ma kaniepe mete lo ku ma watepe moingi? Ku ma kanowo metine piti le ma namin ratei lo ku ma mirowo nele?” ");
INSERT INTO ong_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Fei Jisas lulwepe yeflipiye, lulwepe leinei leinei, leye lo le lirpowo metine wuso eti lele oli lepe, lirpowo lolpepei, “Kesi eti leiye altei lire ulel.” Metine lepe le lolpepe le eti lele nou fale teingi. ");
INSERT INTO ong_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wolo pe enke kotu le pe pirpei nemple piti pe ma polomen piri Jisas. ");
INSERT INTO ong_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wem fei lepe Jisas lunwei le tef lupai linpei lifei piti ma leletei Ma Ili le mulpou yefli lepe le ratei leletei Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wem if ili kerere le linape mete wuso pulpowo pepe, linape pau le le keiniepe pire eti plen le plen te twinges le le linape lirpolo pupam pele. ");
INSERT INTO ong_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon (Jisas linawo nange nele Pita), le winke lele Andru, Jems re Jon, Filip lire Bartolomyu, ");
INSERT INTO ong_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu lire Tomas, Jems ninge lite Alfius, le Saimon lite alpe pinape Selot. ");
INSERT INTO ong_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ninge lite Jems le Judas lite uf Iskariot, le metine piti ma laltei Jisas le esi pite mete olpe. ");
INSERT INTO ong_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas liripe pupam pele pitipi tef alo lupai lepe pitipi pe le Jisas lile tef lele luwowoye le. Mete wuru wuso pulpowo pepe pe pile tulum fei lepe le mete wurutei re pile, pe pite uf walem eryai piti tef lite Judia le pe pite Jerusalem le pe pite uf lingi Tair re Saidon, pratei pinge peryai mingo. ");
INSERT INTO ong_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pe paule piti ma pingitowo Jisas lirpei le piti le ma kapi kainu pelpe taniepe. Mete wuso towa ririm olpe puntoluwepe pepe re, pe re pau le Jisas laptu towa ririm olpe pepe taniepe. ");
INSERT INTO ong_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mete yeflipiye pirpolo ma pesio Jisas wusoli singe pele naro pe kapi kainu pelpe taniepe pe yeflipiye. ");
INSERT INTO ong_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas lulwepe mete wuso pulpowo pepe le le lirpeiye, “Ise mete piti oweli yini nange neiyeise pepe, ise enke teingipe, Ma Ili ma luntolise ratei uf teingi lele. ");
INSERT INTO ong_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ise minemple piti fei nimpi neiyeise pepe ise enke teingipe, Ma Ili ma waise oweli yaplei peilaise. Ise minemple fei youti olpetei pepe ise enke teingipe, Ma Ili ma lireise enke teingipe le ise yinyalili. ");
INSERT INTO ong_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ise ma enke teingipe wem mete enke kotu pireise le pe pinauleise le pe pirpei kotise enke pirpolo ise mete piti yingiepe il olpe wusoli ise yulsi Ninge liti Metine Wape. ");
INSERT INTO ong_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wem moingi pepe faleise ise ma enke teingipe le ise rautu isotei wusoli menemple teingipetei Ma Ili lapteise pifei uf teingi lele yuwei. Pe waise moingi watafei manre yaire pelpe wuso sungoi pe watepe mete emarengi moingi.” ");
INSERT INTO ong_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Wolo ise mete piti fei ise oweli yini wurutei pepe ise moingi ilitei ma faleise, ise fei ratei yoporo wolo wem lingi ma olo, ratei yoporo kolo. ");
INSERT INTO ong_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ise mete piti fei ise yaplei oweli peilaise pepe, ise moingi ilitei ma faleise, ise ma namti nimpi neyeise. Ise piti fei yinyalili pepe, ise moingi ilitei ma faleise. Ise ma namti youti olpetei. ");
INSERT INTO ong_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Moingi ilitei ma faleise wem mete yeflipiye pirpei peilaise nange peise wusoli yaire manre pelpe pe pingiepe il nempleiyeye watafei eple palye pelpe pepe. Yaire manre pelpe pinu pirpei peilape nange pite mete wuso pemtetei pirpei polo pe mete emare.” ");
INSERT INTO ong_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Wolo ise wuso yingiteiki pepe ki kirpeise, ise kani onom yantepe mete eringi peise le mete wuso enke kotu pireise pepe, ise ma yiripe teingipe. ");
INSERT INTO ong_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mete wuso koropoise, ise ma yailelepe le pe wuso pireise olpe pepe, ise ma yeletei Ma Ili piti ma liripe teingipe. ");
INSERT INTO ong_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wuso metine nele leteteiye yifa plen, plen re ma usa letesipe lapwonou. Le wuso metine nele kaliye olol liti alfo lifei yuwei, olol nele kumpu liti alfo lifei leinginim lepe re ye ma usa metine lepe kali lalwonou. ");
INSERT INTO ong_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mete wuso peiteye pire menemple piti ye ma watepe, ye ma watepe, itipiepe kolo, le wem metine nele kaliye lol menele leiye, ye ma nou eletei iri piti ma nou kali kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ye onposi piti pe ma paileleye, ye re ma namti ailelepe.” ");
INSERT INTO ong_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Wuso ye kani onom antepe mete wuso pe kani onom panteye pepe, piti men ma Ma Ili laileleye re luntoliye? Ma olo. Mete piti pingiepe il olpe pepe pe re kani onom pantepe potei wane. ");
INSERT INTO ong_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Le wuso ye ailelepe mete wuso pe paileleye pepe, piti men ma Ma Ili laileleye re luntoliye? Ma olo. Mete piti pingiepe il olpe, pe re polpepe. ");
INSERT INTO ong_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Le wuso ye watepe mete nemple menmen le ye onposi irpolo pe re miso namti waiye, piti men ma Ma Ili laileleye re luntoliye? Ma olo. Mete piti pingiepe il olpe pepe pe re wai nemple men nange le pe nou kapi taniepe potei wane. ");
INSERT INTO ong_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Olo, ise ma kani onom yantepe mete eringi peise, le ise yailelepe, watepe menemple le ise ma onposi piti ma pe ma namti waise kolo olo. Ma Ili ma waise menele teingitei le ise ma fale yire eple pite Ma Ili yuweitei. Wusoli le teingi liripe mete piti tounga peteise wem ise yailelepe le mete piti pingiepe il olpe, Ma Ili olo teingi liripe. ");
INSERT INTO ong_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ise ma onom manepetei watafei Eiya leise, le onom maneisetei.” ");
INSERT INTO ong_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ise ma kapi il yaptei yire mete nemple kolo olo, le Ma Ili re ma kapi il laptei lireise kolo olo. Ise ma yirpei yamtuwo metine nele yawi kolo olo, le Ma Ili re ma lamtuse yaupe kolo olo. Ise ma onposiepe il olpe pite metine nele kolo olo le Ma Ili re ma onposiepe il olpe peise kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Men nange peise, ise ma watepe mete nemple le Ma Ili re ma waise. Ma Ili ma lirkilau waise liri onom malye le ise ma kapi men nange wurutei. Oweli men nange peise, ise kapi wuru watepe mete nemple, Ma Ili re ma namti waise wuru. Le wuso ise watepe yaipiyeye, Ma Ili re ma waise yaipiyeye.” ");
INSERT INTO ong_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Le Jisas lirpepe lire il kauro yuwei pepei lirpeiye, “Metine lutepe pele olpe, le ma linunuwo nele piti lutepe olpe lom? Ma olo. Wuso le lolpepe, te rounge ma tuwalo tautile oi. ");
INSERT INTO ong_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Pupane ma fale raltei metine nimou wuso leltalo lepe kolo olo. Wolo wem metine nimou lepe le leltalo pupane lele lepe, leltalo le le ma pupane lepe le kere langlo yo fei, te rounge ma fale tantei nouteye. Pupane miso fale raltei metine nimou lele piti leltalo lepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Piti men ma ye ulwene tuwi kumpu noli lutepe pite line winke leiye le ye yotei olo uluwo nimpe talpe ili loli lutepe peiye yotei kolo olo lepe? ");
INSERT INTO ong_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ye olomen ma irpowo line winke leiye lepe, irpowo olpepei, ‘Line winke leiki, usaiki kotuwene tuwi kumpu noli lutepe peiye wo.’ Wolo ye yotei uluwo nimpe talpe ili loli lutepe peiye kolo olo. Ye metine piti nel loli ilo ilo. Ye ma inu kotuwo nimpe talpe ili wuso loli lutepe peiye pepe wo ye soma untoli oporo le ye miso kotuwene tuwi kumpu noli lutepe pite line winke leiye lepe.” ");
INSERT INTO ong_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nimpe teingi ma lilape fouri olpesa kolo olo, le nimpe oli, le re ma lilape fouri teingipe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nimpe niliyeye niliyeye ku miso mretawo wem ku mulwepe fouri pele. Ye miso karipe yumko pultei menpeleingu singu lo ma olo? Lo ye miso karipe laulau fouri pultei foiyou fape lepe lo ma olo? ");
INSERT INTO ong_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Metine teingi, le ma nampli il teingipe wuso pultei onom pele pepe, nampli lirpei. Le metine oli, le ma nampli il olpe wuso pultei onom pele pepe, nampli il olpe pepe lirpei. Wusoli il men wuso pirkilau pultei onom leinginim pepe, il pepe so metine ma nampli lirpei fale nemi lele ko.” ");
INSERT INTO ong_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Piti men ise yinaiki ‘Apa Apa,’ le ise yingiepe il wuso ki kirpeise piti ma yingiepe pepe, ise yingiepe kolo pepe? ");
INSERT INTO ong_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Metine wuso laule ki le le lingitepe il peiki le le lulpope. Metine fei lepe ki ma kosaise, le ma watafei mi. ");
INSERT INTO ong_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Le ma watafei metine nele piti leila winem. Le leila winem lifei tef mingo tangu le wem nef nalolo le yuf ili lini le fomnongelem pa pe wolo olo winem lepe lifei teingi wusoli metine lepe le onposi loporo le le leila winem lifei tef mingo tangu. ");
INSERT INTO ong_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wolo metine wuso lingitepe il peiki le le lulpope kolo pepe, le ma watafei metine nele, le leila winem lifei tef nengeliom. Wem nef nalolo le yuf ili lini le fomnongelem pa pinge nengeliom lepe pe kotuwo winem le le kotu lualo olitei wusoli metine lepe le fupeletei, le le lesio winem lifei tef nengeliom.” ");
INSERT INTO ong_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Wem Jisas lirpepe mete lire men nange fei pepei re fei, le le Kaperneam. ");
INSERT INTO ong_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yalu pau ili lite Rom wuso ratei Kaperneam lepe le metine lele piti lesio towa lele le kainu olitei piti ma la. Yalu pau ili lepe le kani onom lantowotei liri metine lele lepe. ");
INSERT INTO ong_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Wem yalu pau ili lepe le lingitei pirpei piri Jisas, le laisipe mete lipi ilepe pite Juda, yalu pau ili lepe le laisipe pe peletei Jisas piti ma laule kapi kainu tanio metine lele piti lesio towa lele lepe. ");
INSERT INTO ong_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pe pe falowo Jisas le pe pirkilau malfefi pirpeiye, “Ku enke teingipe masio yalu pau ili lepe le ye ma kanowo. ");
INSERT INTO ong_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Le kani onom lantepe mete pouku le le lotei leilauku lol angli pau.” ");
INSERT INTO ong_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Liso Jisas liripe pepi pe. Jisas le lualo malfem lire winem lite yalu pau ili lepe wem yalu pau lotei lepe le laisipe numuwi pele pilape il pele pe piti ma pirpowo Jisas polpepei, “Metine ili, ye wai yotei moingi pato. Ki onom teingine piti ye ma inki au winem leiki kolo olo, ");
INSERT INTO ong_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","lo ki re olo teingi kolo piti ma ke kireye malfem. Ye ire il singe irpeiye le metine piti lesio towa leiki lepe le miso nou fale teingi. ");
INSERT INTO ong_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ki re peiteiki kesio towa kunguwepe moli nemple lipi le ki namti kuntoluwepe yali pal nemple kumpu. Wem ki kirpowo nele kirpolo, ‘E,’ le le ma le, le wem ki kirpowo nele kirpolo, ‘au’ le le ma lau. Le wem ki kirpowo metine piti lesio towa leiki lepe, kirpowo kirpolo, ‘Esio towa lepei,’ le le ma lesio.” ");
INSERT INTO ong_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas linlele lotei wem le lingitepe il pepei. Le lile weitei le le lirpepe mete wurutei wuso pulsesi pe pepe, lirpepeye, “Ki kerengawo minele re lirkilau lulpope il peiki watafei yalu pau ili lepei kolo olo. Nele lite Israel re kolo olotei, le loteteiye.” ");
INSERT INTO ong_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Fei, mete wuso pilape il pau pirpowo Jisas pepe, pe nou pe winem lite yalu pau ili lepe le pe puluwo metine piti lesio towa lite yalu pau ili lepe, metine lepe le nou fale teingiye. ");
INSERT INTO ong_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jisas lolpepe re fei, le le uf pinawo Nain. Pupam pele pire mete wurutei pepe re pe piri pepi pe. ");
INSERT INTO ong_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wem Jisas le fale wingi piti pinki pe uf lepe, nimoure re mete pila metine nele la le pe pila poutiti naro pau. Metine wuso la lepe le ninge niliyeye le yaitei re olo la tanio lire nimou roum moteteiye. Nimoure mete wurutei pite uf Nain lepe pe pantene nimou pite ninge wuso la lepe, pe pirine pepi poututuwo so naro wingi pepe pau. ");
INSERT INTO ong_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wem Apa ili Jisas lulwene, le onom manenetei le le lirpeneye, “Outi pato.” ");
INSERT INTO ong_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Leye lo Jisas kotu le lesiepe flenge wuso paltei metine la lepe le mete wuso pila pepe re pe pila pileye. Fei Jisas lirpei lolpepei, “Metine lainouwo, ki kirpeiye ye eilo.” ");
INSERT INTO ong_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Metine wuso la lepe le nou leilo lifei le le lirpepei, le Jisas kali watene nimou pele. ");
INSERT INTO ong_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mete yeflipiye turwepe le pe peila nange lite Ma Ili pirpeiye, “Metine nimou nele ili fale leingalouku,” le “Ma Ili olo lauleye piti ma kaniepe mete pele.” ");
INSERT INTO ong_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Il wuso mete pirpei piri Jisas wuso kanowo metine lainouwo wuso la lepe, il pepe rofro pinge tef ili lite Judia le uf walem wuso pratei neinowo pepe. ");
INSERT INTO ong_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon pupam pele pirpowo pire men nange wuso Jisas laptei fale pepe. Fei, Jon linange pupam twinges tele, ");
INSERT INTO ong_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","le le laisinge te falowo Apa ili Jisas piti ma teletei tolpepei, “Ye so Jon lirpei lireye piti ye ma au lepe lo ku wala ma ratei mungario nele?” ");
INSERT INTO ong_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wem pupam tepe te te falowo Jisas te tirpowo tolpepei, “Jon liti kaptetei, le laitouku wau piti ma weiteye wolpepei, ye so le lirpei lireye piti ye ma au lepe lo ku wala ma ratei mungario nele?” ");
INSERT INTO ong_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wem fei lepe Jisas kapi kainu taniepe mete wuru, kainu eryai pepe le towa ririm olpe re le laptu taniepe nimoure mete le pe wuso lutepe pelpe olpe pepe re Jisas kaniepe le pe nou puntolili poporo. ");
INSERT INTO ong_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jisas nou lirpenge pupam twinges wuso Jon laisinge te tepe. Jisas lirpenge lolpepei, “Rounge nou ye le ise rounge yirpowo Jon yire men nange wuso isotei rounge yulwepe re yingitepe pepe. Mete lutepe pelpe olpe wolo pe nou puntolili, ire pelpe pa wolo pe nou peilo pilele pe, pape olpe polwepe wolo pe nou fale teingipe. Mete mingim olpe wolo pe nou pingitei poporo, mete pa wolo pe nou peilo, le il teingipe ku meptalo pe mete wuso oweli yini nange naplei pepe. ");
INSERT INTO ong_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Metine minele wuso lirkilau lulpoiki lepe, metine fei lepe le ma onom teingine.” ");
INSERT INTO ong_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon pupam tele tepe te tusa Jisas le te te tanio re fei, Jisas lirpepe mete wurutei pepe, lirpepe liri Jon. Jisas lirpepe lolpepei, “Wem ise ye Jon ratei tef oli era re telmane ye yawi lepe, ise onposi piti ma yuluwo men? Yuluwo wolo wuso weitei luwo le yuf lini lalpopo lepe lom? ");
INSERT INTO ong_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ise naro ye piti ma yuluwo men? Yuluwo metine lafo olongou teingipe lom? Olo, mete piti pafo olongou teingipe le pe oweli yini pelpe wuru, pe ma pratei winangou teingipe lipi. ");
INSERT INTO ong_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yirpeiki, ise naro ye piti ma yuluwo menele? Yuluwo metine nimou lom? Iyo, ki kirpeise, ise yuluwo metine nimou yawi kolo olo, Ise yulwepe menemple lipitei. ");
INSERT INTO ong_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wusoli Jon lotei so il piti paitei yousi pe pirpei piri polpepei ‘Ma Ili lirpei lolo, metine piti lilape il peiki lepe ki ma kaisi linuye le piti naliye tisi’.” ");
INSERT INTO ong_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jisas nou lirpei lasiepe lolpepei, “Ki kirpeise, mete wuso pilape pepe pe nange pelpe lipi watafei Jon kolo, Jon nange lele olo ilitei. Wolo minele piti fei lulpope il peiki piti wem Ma Ili ma luntolise, metine fei lepe le ma namti fale linuwo Jon.” ");
INSERT INTO ong_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mete yeflipi pepe le mete piti kapiepe mete era, pe pingitowo Jisas wuso lirpei lepe le pe pulpowo Jisas pire il wuso lirpei lire tisi lite Ma Ili ma kaniepe mete, le pe potei olo Jon kaptetei fei. ");
INSERT INTO ong_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wolo mete pite Farasi le mete piti peptalo mete pire il lipi pite Moses, pe pinauli tisi liti Ma Ili ma kaniepe le pe pinaulo piti Jon ma kaptetei. ");
INSERT INTO ong_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Mete piti wem fei lepei lepe ki ma kaptei poungai mi? Pe ma watafei minemple? ");
INSERT INTO ong_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pe ma watafei eple kumpu pratei uf nimin. Pe paptei nemple mingim le wem pe pirpei nemple piti ma puro wolo ilepe pelpe wala pinaulo. Le wem pe pirpei nemple piti ma pouti wolo ilepe pelpe wala pinaulo. ");
INSERT INTO ong_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jon liti kaptetei, le laule le le laplei oweli kolo, lato yawi le le lalei wain tipe kolo olo, le ise yirpei yolo le ‘towa lunkuwo.’ ");
INSERT INTO ong_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ninge lite Metine Wape laule, le laplei oweli re tipeluwi piti wain, le ise yirpeiye, ‘Yuluwo metine fei lepei. Le laplei oweli lipi le le laplei tipeluwi pire wain le le lini lurungotei. Le numu lite mete piti kapiepe mete era le mete piti pingiepe il olpe.’ ");
INSERT INTO ong_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wolo mete piti Ma Ili watepe enke pire wuru, pe ma pulwepe matufwepe pe mete piti Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fei, metine nele lite Farasi, le laptei il lirpowo Jisas piti ma le liri rounge taplei oweli. Jisas le fale winem lite metine lite Farasi lepe, le le lungura lifei piti ma laplei oweli. ");
INSERT INTO ong_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Moto nenpe ratei uf lepe, ne wem oli oli ningiepe il olpe. Ne ningitei wuso Jisas laplei oweli lifei winem lite metine liti Farasi lepe, le ne so nila mili lire tipe wopu, fale lire mili nemi loparu. Nila ninki ne winem. ");
INSERT INTO ong_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","le ne nilowo Jisas tounga, nile ire yepe pite Jisas le ne noutiti le lus orungu pene pualo kaptetei ire yepe pite Jisas. Leye lo ne nire oru lene niri naplele ire yepe pite Jisas wuso lus orungu pene puwalipe pepe, nire oru lene naplele, ne nensipe mi le ne kalulu tipe wopu lepe neltalipe. ");
INSERT INTO ong_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wem metine lite Farasi wuso linawo Jisas le piti ma liri rounge taplei tepe, le lulwene moto wuso kaptetei ire yepe pite Jisas, metine lite Farasi lepe le lirpepei lotei lolpepei, “Wuso metine fei lepei, le metine nimou punkom, le ma retai moto fei nepei ne minenpe so nesisio lepe. Le ma retai ne moto piti wem oli oli ningiepe il olpe.” ");
INSERT INTO ong_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Leye lo Jisas leilape il lirpowo metine lite Farasi lepe. Lirpowoye, “Saimon, ki onposiepe menmen ma kirpeiye.” Fei Saimon, metine lite Farasi lepe lirpeiye, “Iyo, ye metine liti eptalo mete, ye irpeiki.” ");
INSERT INTO ong_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Fei, Jisas lirpowo lolpepei, “Metine nele watenge mete twinges era le te ma namti watowo. Nele lelnge kapi era lipitei, (500 kina) le nele lepe le kapi kumpu, (50 kina). ");
INSERT INTO ong_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Utu wuso patonge pepe te rounge miso nou watowo metine wuso linu watenge tepe kolo olo, wusoli te rounge olo era olo liso metine wuso linu watenge era pepe le loporo il, lusape rounge lopeye. Mete twinges fei tepe, minele lelnge ma lirkilau onom kerowo metine wuso onposiepe utu pele wuso patonge kolo pepe?” ");
INSERT INTO ong_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon namti lirpei lolpepei, ‘Ki onposi kolpepei, metine wuso utu lipitei patowo lepe.” “Iyo, ye irpei punkom,” Jisas lulpowo. ");
INSERT INTO ong_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Leye lo Jisas weitei kani onom lantene moto nepe le le lirpowo Saimon lolpepei, “Ye ulwene moto nepei lo olo? Ki kinki kau winem leiye le ye waiki tipe piti kaptetei ire peiki kolo, wolo ne nire lus orungu pene kapteteiki ire yepe peiki le ne nire oru lene naplele. ");
INSERT INTO ong_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ye aptei il irpeiki piti kau wolo ye eneteiki mi kolo, le moto fei nepei, wem ki kau fale kifei winem leiye ne pos ratei yaune kolo, wem wuru ne nenesipe mi ire yepe peiki. ");
INSERT INTO ong_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ye waiki wom nangis piti keltalo oru leiki kolo, wolo ne nire tipe wopu kaptetei ire yepe peiki. ");
INSERT INTO ong_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Leso ki kirpeiye, ne kani onom nanteikitei le ne kosaiye nolpepei, il olpe pene wuso wuru pepe Ma Ili ma nou onposiepe koloye. Minele piti lingiepe il olpe kumputei le Ma Ili nou onposiepe koloye, wolo metine fei lepe le ma onom kereiki kumputei.” ");
INSERT INTO ong_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Leye lo Jisas lirpene moto nepe lirpeiye, “Il olpe peiye ma Ma Ili nou onposiepe kolo oloye.” ");
INSERT INTO ong_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Fei, mete nemple wuso pepi pifei ponu pepe pe pirpei nempleiye, “Minele so lepei. Il olpe re le ma nou onposiepe kolo pepe?” ");
INSERT INTO ong_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Wolo Jisas lirpene moto nepe lirpeiye, “Ye ulpope il peiki le fei pepe kaneye, ye e ire onom malye.” ");
INSERT INTO ong_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wem kari re fei, Jisas lilele le linge uf walem kumpu re lipi re, le le leptalo il teingipe piti wem Ma Ili ma luntoluwepe nimoure mete piti tef. Pupam wuso pire esi plen le plen te twinges pepe (12) pe piri pepi pe, ");
INSERT INTO ong_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","le nimoure ilepe re wuso Jisas laptu towa ririm olpe taniepe pepe le le kapi kainu eryai pepe taniepe, nimoure pepe pe piri Jisas pepi pe. Nimoure watafei Maria (pinane Makdala), ne wuso Jisas laptu towa ririm pire esi plen te twinges (7), laptu taniene nepe. ");
INSERT INTO ong_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, ne moto pite Kusa le le lesio towa piti luntoluwo winem re oweli men nange pite metine ili Herot. Le moto nenpe Susana le nimoure nemple wuru pepe, pe wuso piripe men nange pelpe piripe kanowo Jisas liripe pupam pele pepe. ");
INSERT INTO ong_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mete pite uf nele nele re poli nemple paule falowo Jisas le wem pe panfi nemple pirkilau wurutei, Jisas lirpepe lire il kauro yuwei pepei lirpeiye, ");
INSERT INTO ong_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Metine nele lusasape wit fouri pele. Wem le lusasape linge liom, wit fouri ilepe pualolo pinge tisi lite linge liom le mete poluwepe pasi tef le naflepem fale paplei wit fouri pepe, paplei oloye. ");
INSERT INTO ong_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wit fouri ilepe pualo pinge tef oli era le wem pe falele pe weitei pire punko, wusoli tef oli lire era le le oli punko. ");
INSERT INTO ong_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wit fouri ilepe pualo pingepe wolo singu le wit fouri pepe falele, wolo wolo singu pepe pirkilau peilo pafo. ");
INSERT INTO ong_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Le wit fouri ilepe pualo pinge tef teingi. Wit peilo le pe pilape fouri wuru (100) pultei wit nimou niliyeye niliyeye.” Le Jisas lirpei il lapulu lolpepei, “Yingitei wuso ise mingim paitei piti ma yingitei.” ");
INSERT INTO ong_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pupam pele peletei Jisas pire il pal pite il kauro yuwei pepe. ");
INSERT INTO ong_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Le Jisas namti lirpepe lolpepei, “Ma Ili waise enke piti ise ma retape il punkom piti wem Ma Ili ma luntoluwepe mete piti tef, le mete nemple pepe pe olo wolo pe ma pingitepe il kauro yuwei yaupe soma pe puntoli wolo miso pulwepe kolo, le pe pingitei wolo miso pretai kolo.” ");
INSERT INTO ong_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Il kauro yuwei pepe, il pal pato so polpepei, wit fouri pepe pe il pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wit fouri wuso pualo pinge tisi pepe pe pilepe mete wuso pingitepe il wolo towa laule kapi il pepe taniepe enke pelpe le le lolpepe liripe piti ma il karipe piti ma pulpope il pepe kolo, le il pite Ma Ili re ma kaniepe kolo. ");
INSERT INTO ong_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wit fouri wuso pualo pinge tef oli era lepe pe pilepe mete wuso pingitepe il le pe frou kapi pesiepe. Wolo pe paptei il pirkilau pultei enke pelpe kolo, pe pulpope wem kurauye le pe pualo wem men kumpu fale pempesipe. ");
INSERT INTO ong_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wit fouri wuso pualo pingepe wolo singu pepe pe pilepe mete wuso pingitepe il, wolo pe onposiepe oweli yini le wai lelpe piti rautunemple pire nempi liti tef lepei le fei pepe pirkilau peilape enke pelpe, le il pite Ma Ili olo pirepe onomye. ");
INSERT INTO ong_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Wit fouri wuso pualo pinge tef teingi pe pilepe mete wuso pingitepe il, enke pelpe teingipe le pe pesiepe papiri, paptei pultei enke pelpe le pe pirkilau pile singe le pe weisipe enke pite mete nemple le pe pulpope il pite Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Metine minele miso leltei nango weli le le kali waifile lire muntuwo lo le lalingi lato poi tef lo ma olo? Ma olo. Wolo le ma laltei nango weli lepe laltei luwo poi yuwei soma mete puluwo wem pe pinki pe winem. ");
INSERT INTO ong_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Men nange piti kotire pato pe ma nampli paptei alepe nimin, le men nange piti paplingi pe ma perengape le pe ma pretape pile alepe nimin.” ");
INSERT INTO ong_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kotopa isotei wem ise yingitepe il, wusoli minele piti lesiepe men kumpu le ma nou kapi nemple lapwonou, wolo minele piti lesiepe men kumpu kolo, men kumputei wuso le onposi lirpolo le lesiepe re wolo Ma Ili ma kapi tanio.” ");
INSERT INTO ong_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Fei, Jisas nimou nire winkem pele pau falowo wolo pe pe piri malfem kolo olo wusoli mete wurutei. ");
INSERT INTO ong_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Metine nele lirpowo Jisas lolpepei, “Nimou nire winkem peiye pile towa yawi piti ma puliye.” ");
INSERT INTO ong_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jisas lirpepe pe yeflipiye lirpeiye, “Mete piti pingitepe il pite Ma Ili le pe pulpope, mete fei pepe pe emare re winkem peiki.” ");
INSERT INTO ong_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Epli wem nele Jisas longlo nimpe teingo nele le pupam pele re piri pepi ponglo le Jisas lirpepe lolpepei, “Ku malowi tuluple monglo me mingo plen.” Pe so praltutuwe nimpe teingo lepe pila pe. ");
INSERT INTO ong_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yuf wala so lapopo pire nimpe teingo lepe, yuf lapopo lilape le, le Jisas lualo letei luwo nimpe teingo lepe. Yuf ilitei lini lirkilau lalpopo tuluple le tipe leingalolo nimpe teingo lepe fale loparuye, le pe ma pautile tulupleye ko. ");
INSERT INTO ong_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pupam pepe pe Jisas le pe kumtasi pirpeiye, “Ili louku, Ili louku, ko ku ma maye ko.” Jisas leifale le le lire il singe lirpowo yuf lire tipe wuso lalpopo lurorowo lepe, fei yuf kere le tuluple lirkir luwo. ");
INSERT INTO ong_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Leye lo Jisas lepletei pupam pele lolpepei, “Ise yulpope il pite Ma Ili, lo ise yolomen?” Wolo pe pinlele potei le pe turwepe, le pe pirpei nemple pirpeiye, “Metine minele so lepei? Le lirpepe yuf re tipe wuso yuf lini lurorope pepe, le pe paptowo mingim.” ");
INSERT INTO ong_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yuf lapopo lilape le fale tef lite Gadara lato tuluple mingo plen le uf Galili lifei plen. ");
INSERT INTO ong_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wem Jisas konko le tuluple mingo, metine nele lau falowo. Le lite uf lepe le le ririm olpe punkuwo. Wem ulel le lafo olongou nemple kolo, pau yawi le le miso ratei uf kolo, wolo le ma ratei lingene ilingi piti paptei towa puwo. ");
INSERT INTO ong_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wem le luluwo Jisas, le lailolo lirkilautei, lualo ratei onom pite Jisas le le lirpei lirkilau lolpepei, “Jisas, ninge lite Ma Ili yuweitei. Ye onposi piti ma olomen ireiki? Ki keiteiye, waiki moingi pato.” ");
INSERT INTO ong_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Metine lepe le lirpei il pepei wusoli Jisas linu lirpei piti riri oli lepe le ma naro tanio metine lotei fei lepe. Wem wuru riri oli lepe lirkilau lunkuwo le wem pe pire foiye singetei pire topuwo ire re esi pele le mete pile puntoluwo wolo le ma karipe foiye singetei pepe, le riri oli lepe le ma lalpopo lila le tef oli era re telmane ye yawi. ");
INSERT INTO ong_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisas leleteiye, “Nange leiye minele?” “Nange leiki Wurutei,” le namti lirpowo Jisas, wusoli ririm olpe wuru pe punkuwoye. ");
INSERT INTO ong_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Le ririm olpe pepe pe peletei Jisas piti ma laisipe pe nample nele krutei, pau lele re olo, pe peletei Jisas piti ma laisipe pe nample fei lepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Songou wurutei paplei oweli pile malfem, pile tef lele lire orou. Fei, ririm olpe pepe pe peletei Jisas piti ma laisipe pe punkuwepe songou pepe, le Jisas lusape pe. ");
INSERT INTO ong_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Liso ririm olpe pepe pe naro tanio metine lepe le pe pe punkuwepe songou. Songou wurutei pepe pe yeflipiye pantu pitipi alu wanketei pe pautile tuluple, pa oloye. ");
INSERT INTO ong_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mete piti puntoluwepe songou pepe pe pulwepe men wuso fale pepe, le pe so pantu pe pirpepe mete pite uf lepe, le pe kete il pe fale mete piti pratei liom. ");
INSERT INTO ong_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mete naro pe pulwepe men wuso fale pepe. Pe pe falowo Jisas le pe puluwo metine wuso ririm olpe naro tanio le le pos ratei ire yepe pite Jisas. Le lafo olongou le le telpalo lotei le mete wuso pau puluwo pepe, pe yeflipiye turwepe. ");
INSERT INTO ong_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mete wuso pinu pulwepe men wuso fale pepe pe pirpepe mete wuso pingi pau pepe, pirpepe pire metine lepe, Jisas kanowo lolomen. ");
INSERT INTO ong_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Leye lo mete yeflipiye pite tef lite Gadara, pe peletei Jisas piti ma le taniepe wusoli pe olo turwepe olpetei. Liso Jisas nou longlo nimpe teingo le le le. ");
INSERT INTO ong_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Metine wuso ririm olpe naro tanio lepe le malfefi Jisas lirpeiye, “Usaiki kireye we.” Wolo Jisas laisi le tani le le lirpowoye, ");
INSERT INTO ong_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ye nou e uf, le ye irpepe ire men wuso Ma Ili lolpepe lireye lepe.” Fei, metine lepe le uf lepe lirpepe le laltuye, lirpepe lire men wuso Jisas lolpepe liri lepe. ");
INSERT INTO ong_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wem Jisas nou le fale tuluple mingo plen, mete wurutei enke teingipe pasio wusoli pe pinu pratei pungario. ");
INSERT INTO ong_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Leye lo metine nele pinawo Jairus, le lau fale. Le metine piti kaniepe puntoluwo angli pau lelpe. Le liri lotei lualo lato ire yepe pite Jisas le le malfefi piti ma le winem lele, ");
INSERT INTO ong_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","wusoli ningio nenpiyeyetei pele, eringi pene pire esi plen le plen te twinges (12), ne wem lirine malfem piti ma na. Wem Jisas lilele le, mete wurutei fale panfi pinge plen le plen. ");
INSERT INTO ong_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Moto nenpe ne neingalope nimin. Eringi pire esi plen le plen te twinges (12) moto fei nepe ne nilala teluwi. Mole kumpu pene re ne nampli naisepe mete emare oloye wolo nele lelpe re kaniene kolo. ");
INSERT INTO ong_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ne niripe mete wurutei pepe pulsesi Jisas pingi le ne nesio olol um lite Jisas le teluwi pene pepe pe kere wem fei lepeye. ");
INSERT INTO ong_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Fei, Jisas lepletei lolpepei, “Minemple pesiki?” Wolo pe yeflipiye pire yef le Pita lirpei lolpepei, “Ili louku, mete wurutei pau panfeiye le pe neineye kotuye.” ");
INSERT INTO ong_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wolo Jisas lirpeiye, “Mete nemple pesiki le ki kretai wusoli singe naro pe taniki.” ");
INSERT INTO ong_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Fei, moto nepe nuntoli wuso ne miso kotire kolo, ne so nau nire notei nualo ratei ire yepe pite Jisas, punwewine, mol re kaniniye. Mete wurutei pepe pile pulwene wem ne nirpowo Jisas nire piti polomen ne nesio le ne nolomen so teluwi pene kere frou pepe. ");
INSERT INTO ong_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisas lirpeneye, “Ningio peiki, ye ulpope il pite Ma Ili le ye min so nou fale teingine nepe. Ye e ire onom malye.” ");
INSERT INTO ong_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas wala so lirpei il pepei wem metine nele lato winem lite Jairus so lilape il lau fale. Jairus, le metine liti kaniepe puntoluwo angli pau lelpe lepe. Fei, metine wuso lilape il lau lepe le lirpowo Jairus lolpepei, “Ningio peiye olo naye. Ye usa metine piti leptalo mete pepe, usa leye.” ");
INSERT INTO ong_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wolo Jisas lingitei fei le le lirpowo Jairus, “Ye turiye kolo, ulpope il pite Ma Ili le ne ma nou fale teingine.” ");
INSERT INTO ong_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wem Jisas le fale winem lite Jairus, le il karipe minemple re ma piri pepei pinki pe winem kolo. Pita loteteiye lire Jon re Jems le nimou re yaitei pite ningio wuso na nepe, pe yaupe pire Jisas pepi pinki pe winem. ");
INSERT INTO ong_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nimoure mete wuso pifei winem leinginim lepe, pe yeflipiye poutuwene ningio kumpu nepe. Jisas lirpeiye, “Ise youti pato, kumpu nepe olo na kolo, ne netei.” ");
INSERT INTO ong_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pe penyali re palwe oli piri wusoli pe pretai ne olo naye. ");
INSERT INTO ong_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wolo Jisas lesiene eti le le lirpeiye, “Ningio, eilo.” ");
INSERT INTO ong_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nempi lene nou lau lunkuwene le ne neilo wem fei lepeye, le Jisas lirpepe piti ma watene oweli men naplei. ");
INSERT INTO ong_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nimou re yaitei pene, me roum minlele motei wolo Jisas lirpeme piti me roum ma mirpepe mete nemple mire men wuso fale lepe kolo, olo. ");
INSERT INTO ong_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas linape pupam wuso pire eti plen le plen te twinges pepe. Jisas linape laptei nemple, le le watepe singe piti ma paptu towa ririm olpe le pe kapi kainu taniepe mete. ");
INSERT INTO ong_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Leye lo le laisipe pe piti ma peptalo il pire wem liti Ma Ili ma luntoluwepe mete le pe ma kapi kainu taniepe mete. ");
INSERT INTO ong_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jisas lirpepe pupam pepe lirpeiye, “Kali menele yesio yila ye kolo olo, eflei olo, tom oplou olo, oweli olo, era olo, olol nele yawi re ma kali kolo. ");
INSERT INTO ong_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Minemple keteise pilaise ye winem lelpe, ise ma yusa winem lepe kolo, ratei ye ye fale wem liti ise ma yusa uf fei lepe le ise ye nele. ");
INSERT INTO ong_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Le wuso mete keteise pilaise pe winangou pelpe kolo olo, yusa uf fei lepe le ise nenyi olfom lite ire yepe peise le fei pepe ma kosape, pe ma pratei pire il olpe pelpe.” ");
INSERT INTO ong_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Liso pupam pepe pe pe pinge uf walem eryai, peptalo il teingipe pite Ma Ili, le pe kapi kainu taniepe mete pite uf walem eryai pepe. ");
INSERT INTO ong_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herot, le metine ili piti luntoluwepe mete re tef lite Galili, le lingitepe il wuso pirpei pire men nange wuso fale pepe le le fupeletei liripe wusoli mete ilepe pirpei polo Jon liti kaptetei mete lepe le nou leilo. ");
INSERT INTO ong_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mete ilepe pirpei polo Ilaija nou fale le ilepe pirpei polo metine nimou nele lite sungoi liye lepe, le nou leilo. ");
INSERT INTO ong_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herot lirpeiye, “Ki kalowi Jon falo lele wolo metine minele so ki kingitepe il pirpei piri lepei?” Le le lirkilau reitu lotei piti ma luluwo Jisas. ");
INSERT INTO ong_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wem pupam nou pau fale, pe pirpowo Jisas pire towa men nange yeflipiye, pe nampli pirpowo Jisas. Le kesipe pe poteteiye le pe piri pepi pe uf pinawo Betsaida. ");
INSERT INTO ong_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Wem mete wurutei pepe pe pingitei polpepei, pe peifale pulsi. Jisas kani onom lantepe, lirpepe lire wem liti Ma Ili ma luntoluwepe nimoure mete pele pratei uf teingi lele le le kapi kainu taniepe mete wuso pirpowo piti le ma kaniepe pepe. ");
INSERT INTO ong_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wem epli weitei le piti ma lautile, pupam wuso pire eti plen le plen te twinges pepe (12), pe pau Jisas le pe pirpeiye, “Aisipe mete pe uf walem kumpu le liom wuso pato neinouku pau pe pepe, le pe ma pintape oweli piti ma paplei le tulum piti ma petei wusoli tulum fei lepei lepe olo yawitei.” ");
INSERT INTO ong_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wolo Jisas lirpepeye, “Ise isotei watepe menemple piti ma paplei.” Pe namti pirpowoye “Ku luom wengle twinges te twinges le niliyeye le ningu twinges. Ye irpei piti ku ma me maisepe oweli watepe mete wurutei pepe lom?” ");
INSERT INTO ong_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Mete wurutei pratei lepe 5,000.) Jisas lirpepe pupam pele lolpepei, “Karipe mete yaptei pratei tulum fi fi (50), pratei tulum niliyeye niliyeye.” ");
INSERT INTO ong_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pupam pepe pe pingiepe il pite Jisas le pe karipe mete paptei pratei tulum fi fi. ");
INSERT INTO ong_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisas kapi lufe wengle wuso pire eti plen poungo pepe le ningu twinges, le luntoli le teplai yuwei, leletei Ma Ili liripe le le yaruwepe watepe pupam pele piti ma kapi watetepe mete wurutei pepe. ");
INSERT INTO ong_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mete wurutei pepe pe yeflipiye paplei le pe yefi tangupe le pupam tonwipe oweli ilepe wuso mete paplei le ilepe pratei pepe, pupam tonwipe pafo pora pire eti plen le plen te twinges (12), pafo fale. ");
INSERT INTO ong_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wem nele wem Jisas loteteiye ratei leletei Ma Ili, pupam pele pau falowo. Fei Jisas lepletei lolpepei, “Mete wurutei pepe pe pirpei polo ki minele?” ");
INSERT INTO ong_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Le pupam pepe pe namti pirpowoye, “Mete ilepe pirpei polo, ye Jon liti kaptetei. Ilepe pirpei polo ye Ilaija, le ilepe pelpe pirpei polo metine nimou nele lite sungoi liye lepe, le nou leilo.” ");
INSERT INTO ong_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Fei, Jisas lepletei pupam pele lolpepei, “Le ise, ise yirpei yolo ki minele?” Pita namti lirpowoye, “Ye Krais lite Ma Ili lele.” ");
INSERT INTO ong_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Leye lo Jisas lire il singe lirpepe piti ma pirpepe mete nemple piri kolo olo, ");
INSERT INTO ong_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","le le nou lirpepe lasi lolpepei, “Ninge lite Metine Wape ma lila moingi ilitei le mete lipi pite Juda le mete piti pinuwepe mete piti peptawio Ma Ili siye le mete piti peptalo mete pire il lipi pite Moses, mete fei pepei pe ma pinauli. Pe ma petesi la le epli wem twinges niliyeye kari fei, le ma nou leilo. ");
INSERT INTO ong_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Le Jisas lirpepe pupam yeflipiye lirpeiye, “Wuso minele lirpolo ma lau lireiki ki, le ma onposi lotei kolo olo, le ma lila moingi epli wem oli oli, le le ma lulteiki. ");
INSERT INTO ong_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Wusoli minele lirpolo ma kanei lotei piti ma namin ratei, metine fei lepe le ma lalingou nempi lele. Wolo minele piti lalingou nempi lele, wusoli le la lungweiki ki, metine fei lepe le ma nou kali nempi lele. ");
INSERT INTO ong_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wuso metine nele onposi lirpolo ma kali tef re men nange pepei laptei lotei wolo le miso kanei lotei kolo olo, metine fei lepe le ma kali menele teingi lo ma olo? Ma olo. ");
INSERT INTO ong_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wuso metine nele le topo tapune lireiki ki le le topo tapune lire il wuso ki keptalo pepe, Ninge lite Metine Wape re ma topo tapune liri metine fei lepe wem le lau lire singe lipi pele le singe pite Yaitei le piti ririm teingipetei pite yuwei. ");
INSERT INTO ong_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ki kirpeise punkom, mete ilepe fei pile lepei, pe wala ma pa kolo, le pe ma puluwepe singe piti Ma Ili ma luntoluwepe mete piti tef. Pe ma puluwepe men fei pepe wo, pe soma pa pingi.” ");
INSERT INTO ong_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Epli wem wuru (1 wik) kari wem wuso Jisas lirpei lire wem piti le la le le ma nou leilo, wem fei lepe kari re fei le so kesi Pita lire Jems re Jon, Jisas kesipe lilape punwei pe tumun nele piti ma peletei Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wem Jisas wala leletei Ma Ili, mati lele weitei fale nele, le olongou pele re weitei pinini watafei epli linini lepe. ");
INSERT INTO ong_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Frou yo fei, mete twinges fale tile tire Jisas pepi pirpepei pile. Te rounge Moses lire Ilaija, ");
INSERT INTO ong_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","le te rounge fale tire singe pite yuwei le te tire Jisas pepi pirpei. Pe pirpei pire wem Jisas ma la lolomen, ma la lato Jerusalem so ma laptei il pite Ma Ili fale punkom. ");
INSERT INTO ong_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita lire lainuwongou wane tele pepe olo petei pautiletei wolo pe peifale pulwepe singe lipi pite Jisas le mete twinges wuso piri pepi pile pepe. ");
INSERT INTO ong_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wem mete twinges tepe te tusa Jisas, Pita lirpowo Jisas lolpepei, “Ili louku, teingipetei ku fei mireye ratei lepei. Ku ma meilape wingou pal twinges niliyeye, nele leiye, nele lite Moses le nele lite Ilaija.” Pita retai men wuso lirpei pepe kolo, olo lironom. ");
INSERT INTO ong_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wem Pita wala lirpei, nopom fale keraisipe le pupam pepe pe turwepe wuso nopom fale mulfipe pepe. ");
INSERT INTO ong_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Il nemple fale nopom lepe pirpei polo, “Ninge lepei ki leiki wuso keiniyo lepe. Yaptowo mingim.” ");
INSERT INTO ong_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wem il pepe pirpei pe kere, pupam pepe pe puluwo Jisas loteteiye lile. Pe papiri pato pelpe potei, pe pirpepe mete nemple pire men wuso fale pepe kolo, pe pulwepe wolo, wem fei lepe, pe paplingi pato potei. ");
INSERT INTO ong_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nolowi, Jisas liripe pupam pele pitipi tumun lepe pe le mete wurutei pau perengawo Jisas. ");
INSERT INTO ong_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Metine nele wuso leingalope nimin lepe le linawo Jisas lirpeiye, “Metine liti eitalouku lepe, untoli, ki keiteiye piti ma uluwo ninge leiki wo. Le ninge neleyetei leiki. ");
INSERT INTO ong_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Towa nele oli lunkuwo, lailolo re ire esi poli nemple le tuwamou falele mi nemi re, le lirkilau lunkuwotei le le ma lusa koloye. ");
INSERT INTO ong_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ki kepletei pupam peiye piti ma paltu naro tanio, wolo pe polpepe kolo.” ");
INSERT INTO ong_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisas namti lirpowoye, “Ko ise mete piti yulpope il pite Ma Ili kolo le ise wala onposi yoporo kolo. Wem polomen ma ki kireise ratei? Wem polomen ma ki kaneise?” Leye lo le lirpowo metine lepe lirpeiye, “Ila ninge leiye au lepei.” ");
INSERT INTO ong_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wem ninge kumpu lepe wala so lau, towa oli lepe leila lalangu lasi tef, lirkilau lunkuwo, kumpu lepe loli nele oloye. Jisas lire il singe lirpowo towa oli lepe le le naro tanio ninge kumpu lepe, le Jisas nou watowo yaitei lele. ");
INSERT INTO ong_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mete yeflipiye pinlele potei wem pe pulwepe singe lipi pite Ma Ili. Mete wala yafei pirpei pire men wuso Jisas lolpepe lepe wem le lirpepe pupam pele lolpepei, ");
INSERT INTO ong_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ise ma onom pete il yire menemple piti fei ki ma kirpeise pepei pepe kolo olo, onom petepe il kolo. Ninge lite Metine Wape ma pe paltei le singe pite mete.” ");
INSERT INTO ong_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wolo pupam pele pepe pe pironom pire il pal pite il wuso Jisas lirpei pepe. Il pal olo Jisas lirpei kolo le pe so pretai kolo le pe olo turwepe piti ma peletei pire il pal pite il pepe. ");
INSERT INTO ong_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pupam potei pire il pura nemple pire minele lelpe ma linuwepe. ");
INSERT INTO ong_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisas retape enke pelpe le so kesi ninge kumpu nele laltei lile lapi plen pele, ");
INSERT INTO ong_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","le le lirpepe pupam pepe lolpepei, “Minele piti onposiki le le lailolowo kumpu lepei, metine fei lepei laileleiki. Le minele piti laileleiki ki, le lailolowo minele wuso laiteiki kau lepe. Wusoli minele piti weitei lingi le le lesio towa lite ise yeflipiye, metine fei lepe le ma linuse.” ");
INSERT INTO ong_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Fei, Jon nempe nemi lirpeiye, “Ili louku, ku muluwo metine nele le lire nange leiye liri laptu towa ririm olpe le ku mirpowo piti ma nou lolpepe kolo, wusoli le lite alpe louku kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisas lirpowo lire pupam nemple pepe lirpeiye, “Ise ma il kari kolo olo, wusoli minele piti luraise kolo olo, metine fei lepe le leise.” ");
INSERT INTO ong_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Epli wem pintire pau pire wem malfem piti ma Ma Ili kesi Jisas lila le yuwei, Jisas onposi loporo re fei le so leifale le Jerusalem. ");
INSERT INTO ong_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Le laisipe mete pilape il pinuwo pe le mete wuso pilape il pinu pe pepe pe pe uf nele lite mete pite Samaria piti ma papli oweli paptei elpesipe pifowo Jisas. ");
INSERT INTO ong_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wolo mete pite uf lepe pe kesi Jisas kolo wusoli pe pretai le olo ma le Jerusalem. ");
INSERT INTO ong_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wem pupam tepe, Jems lire Jon, te rounge tulwepe pe fei polpepei, te rounge tirpeiye, “Ili louku, irpei so ku winawo weli litipi yuwei lau laplei mete pepei, laplei liripe nempleiye, lo ma olo?” ");
INSERT INTO ong_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jisas weitei lirpeilange, ");
INSERT INTO ong_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","le pe pe uf nele. ");
INSERT INTO ong_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wem pe wala so pe, metine nele lirpowo Jisas lolpepei, “Ye linei linei e, ki ma kulteteiye we.” ");
INSERT INTO ong_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisas namti lirpowo metine lepe lirpeiye, “Siye pe era namplungu lo nimpe mini pelpe piti ma pautile pratei le naflepem pe onkotu pelpe piti ma pautile pawo, wolo Ninge lite Metine Wape, le tulum nele lele piti ma letei luwo laltei yef kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jisas lirpowo metine nele lepe, lirpowo lolpepei, “Ye ulteiki.” Wolo metine lepe le lirpei lolo “Ili leiki, inu usaiki ke le eiya leiki ma la le ki ma kaltei eiya leiki wo.” ");
INSERT INTO ong_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisas namti lirpeiye, “Usape mete piti pa pe ma peitei potei wane. Ye e eptalo il pite wem Ma Ili ma luntoluwepe mete pele pratei uf teingi lele.” ");
INSERT INTO ong_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Metine nele lirpei lolo, “Ki ma kulteiye, ili leiki, wolo ye ma inu usaiki ke keisime ema re eiya meiki le ki keipime esi wo, ki soma kau kulteiye.” ");
INSERT INTO ong_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisas lirpepeye, “metine minele wuso lale liom wolo le lapiri oweli kolo lusa lato yo falele yawiye, metine fei lepe le olo teingi kolo, wusoli le onom twinges le wem Ma Ili lontoluwepe mete, le ma watowo towa piti lesio kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jisas lirpei il pepei re fei, le keiniepe pupam nemple wuru (72), le le laisipe pinuwo pe. Jisas laisipe pe twinges twinges te, laisipe pinuwo pe uf re tulum wuso le ma le lulwepe pepe. ");
INSERT INTO ong_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jisas lirpepe lolpepei, “Oweli wuso poungo pepe olo wurutei wolo mete piti kotuwepe oweli pepe, pe olo yeipiyeye, liso ise ma yeletei yaitei lite liom lepe piti le ma laisipe mete pe kotuwepe oweli pele. ");
INSERT INTO ong_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ise ye wolo ise retai, ki kaiteise ye watafei sipsip eple ye yeingalope pelem olpe nimin. ");
INSERT INTO ong_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tenge eple ma yilape ye kolo olo, tenge lipi re ma kapi kolo olo, ire filengi re ma olo, yilele ire yaupe ye. Wem ise raptei mete tisi, ise ma yeisipe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wem mete pite winem nele pe keteise pilaise ye winem lepe, ise ma yinu yirpei yolpepei, ‘Onom malye nireise ratei winem lepei.’ ");
INSERT INTO ong_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Le wuso metine piti onposi piti ma ratei yire onom malye, le ratei winem fei lepe, il peise wuso yinu yirpei piti onom malye ma niripe ratei lepe, il fei pepe miso kere yaupe kolo olo. Le wuso minele re ratei winem lepe le olo ratei lire onom malye kolo, il peise ma piri pratei kolo, peise ma nou kapi. ");
INSERT INTO ong_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Winem wuso yinu ye fale le pe keteise pe peiteise ratei lepe, winem elpesi lepe ise ma ratei, yaplei oweli re tipe men nange wuso mete pite winem lepe pe waise pepe, wusoli metine wuso ise yesio towa lele lepe, le ma namti laiteise. Ise ma yaulo ye winangou nemple nemple kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wem ise ye fale uf nele le mete pite uf lepe pe keteise pilaise pe, oweli men nange pe waise, ise yaplei. ");
INSERT INTO ong_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ise kapi kainu taniepe mete pite uf fei lepe, le ise ma yirpepe mete pepe yirpolo, ‘Wem liti Ma Ili ma luntoluwepe mete piti tef, wem fei lepe olo lau lireise malfemye.’ ");
INSERT INTO ong_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wolo wem ise ye fale uf lepe le pe keteise kolo olo, ise ye yile tisi kumpu piti pato pinge uf lepe, le ise ma yirpei yolpepei, ");
INSERT INTO ong_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Olfom lite uf leise isotei lepei wuso laitouku ire yepe pepe, ku ma nou nenyi meltaleise ise isotei, wolo ise ma retai yolpepei, wem liti Ma Ili ma luntoluwepe mete piti tef, wem fei lepe olo lau lireise malfemye.’ ");
INSERT INTO ong_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ki kirpeise, wem Ma Ili kapi il laptei liripe mete piti tef, wem fei lepe Ma Ili ma watepe mete pite uf Sodom moingi, le pe pite uf wuso ye fale le pe paileleise kolo pepe Ma Ili ma watepe moingi ili oli.” ");
INSERT INTO ong_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ye uf Korasin, moingi ilitei ma faleye. Ye uf Betsaida re, moingi ilitei ma faleye. Wuso ki kirpei le men nange potei pire tute faleise pepe, pe ma faleise koloye le pe falepe mete pite uf lingi Tair re Saidon, mete pite uf lingi tepe, pe ma sungoi liye pualo fanke le pe pouti pire il olpe pelpe le pe ma pusape il olpe pelpe patoye. ");
INSERT INTO ong_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Wem Ma Ili kapi il laptei lire moingi pite mete piti tef, wem fei lepe, Ma Ili ma watepe mete pite Tair re Saidon moingi, le ye uf Korasin re Betsaida, le ma waise moingi ili oli. ");
INSERT INTO ong_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Le ye uf Kaperneam, ye onom puwope men nange pite tef ma kapi aptei yotei le ye ma fale ili lom? Ma olo, Ma Ili ma lireiye uwalo weli.” ");
INSERT INTO ong_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Fei, Jisas lirpepe pupam pele lolpepei, “Minemple piti pingiteise pepe pe pingiteiki ki. Minemple piti pinauleise pepe pe pinauleiki ki, le pe pinauli minele wuso laiteiki kau lepe.” ");
INSERT INTO ong_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pupam nemple wuru (72) wuso Jisas laisipe pe peptalo il pepe, pe nou rautu nempleiye pau falowo Jisas. Pe pirpeiye, “Ili louku, ririm olpe re pe paptouku mingim wem ku miri nange leiye mirpei le pe naro pe taniepe mete.” ");
INSERT INTO ong_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisas namti lirpepeye, “Ki kuluwo towa lualo teplai yuwei lau watafei teplai nesi mil. ");
INSERT INTO ong_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yingitei, ki waise singe piti ma yoluwepe tutungu re ilma le ise ma weisipe singe pite towa le menele re miso waise moingi kolo olotei. ");
INSERT INTO ong_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ise enke teingipe wusoli towa ririm olpe re pe papteise mingim, wolo ise ma enke teingipe yasiepe fei pepe kolo olo, ise ma enke teingipe wusoli nange peise olo Ma Ili laptei puwo yuwei.” ");
INSERT INTO ong_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wem fei lepe Riri Teingi lirkilau leilawo Jisas onom le le onom teinginetei le le lirpei lolpepei, “Eiya, ye ili lite yuwei re tef. Ki onom teingine kireye, wusoli mete wuso pretai kolo pepe, ye kosape ire menmen wuso ye aplingi taniepe mete piti enke pire wuru le pe pretaitei pepe. Iyo, Eiya, onom peiye yotei ye aptei fei pepei fale le ye onom teingine asiepe.” ");
INSERT INTO ong_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Eiya leiki waiki men nange yeflipiye. Minemple re pretawo ninge kolo olo, Yaitei loteteiye le retawo, le minemple re pretawo yaitei kolo olo, ninge loteteiye retawo le mete wuso ninge onposi piti ma kosape pepe, pe poteteiye so pretai.” ");
INSERT INTO ong_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Leye lo Jisas weitei kani onom lantepe pupam pele le le lirpepe pe poteteiye lirpeiye, “Ise yoporotei le ise yulwepe men nange wuso ise yulwepe pepe. ");
INSERT INTO ong_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ki kirpeise, mete emare le mete lipi piti puntoluwepe mete, wuru pelpe pirpolo ma pulwepe menmen wuso ise yulwepe pepe wolo pe pulwepe kolo, le pe pirpolo ma pingitepe menmen wuso ise yingitepe pepe wolo pe olo pingitepe kolo.” ");
INSERT INTO ong_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Fei, metine nele piti leptalo il lipi pite Moses, le lau fale le le lirpolo ma lempesesi Jisas piti ma lualo tisi oli, le so leletei Jisas lolpepei, “Metine liti eptalo mete pepe, ki ma kolomen soma ki kali nempi liti kratei kingi wem wem lepe?” ");
INSERT INTO ong_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisas namti lirpowo lolpepei “Il wuso paitei yousi pepe pe pirpei polomen? Ye ungunape fei polomen?” ");
INSERT INTO ong_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Metine lepe namti lirpowo Jisas lolpepei, “Ye ma onom kerowotei ire Ili, le Ma Ili leiye, onom kerowo Ma Ili ire riri leiye, singe peiye le onom peiye, le ye ma kani onom antowo metine nele watafei ye kani onom antei yotei lepe.” ");
INSERT INTO ong_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisas nou lirpowo metine lepe lirpeiye, “Il peiye irpei pepe pe tuwopou, ye olpepei le ye ma namin ratei.” ");
INSERT INTO ong_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wolo metine liti leptalo mete lire il lipi pite Moses lepe, le onposi lirpolo ma leite lotei fale teingi tuwopou le so leletei Jisas lolpepei, “Ki ma kani onom kantowo metine nele, metine nele lepe le minele?” ");
INSERT INTO ong_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisas namti lirpei lolpepei, “Metine nele lato Jerusalem so litipi le Jeriko. Le wem le le, mete olpe fale posio, nomplei olongou pele le pe petesi olitei la lununwei le pe pusa lato tisi. ");
INSERT INTO ong_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Fei, metine liti leptawio Ma Ili siye, le lingowo tisi elpesi lepe le. Wem le luluwo metine wuso mete olpe petesi le pe pusa la lununwei lato tisi lepe, metine liti leptawio Ma Ili siye lepe le kali laltei leinei linge tisi plen, lusa metine lepe lato le le leye. ");
INSERT INTO ong_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Metine nele lite alpe lite Livai, le re so lolpepe. Le le fale luluwo metine lepe le le lusa lato le le weitei leinei tisi plen leye. ");
INSERT INTO ong_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Wolo metine nele lite Samaria, le lingowo tisi lepe le. Le le falowo metine wuso lato tisi lepe le wem le luluwo, le onom manowotei liri. ");
INSERT INTO ong_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Le karowo le, le le kalulu oliv nangis lire wain tipe leltalipe pape pite metine lepe le le topwepe. Leye lo le kali laltei lifei donki lele le le lila le winem nele lite mete paise le pe petetei, le laltei lifei winem lepe le le luntoluwo. ");
INSERT INTO ong_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nolowi, metine lite Samaria lepe le nampli era winges (2 kina) laise metine piti luntoluwo winem liti petetei lepe. Le le lirpowo lolpepei, ‘Untoluwo le wem ki nou lepei kau, menemple wuso ye kanowo iripe pepe ki miso namti waiye’.” ");
INSERT INTO ong_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Le Jisas lirpei lapulu lolpepei “Ye onposi polomen. Mete twinges niliyeye pepe, minele lelpe so lingiepe wata pirpolo le kani onom lantowo metine nele watafei metine wuso mete olpe petesi le pe pusa lato tisi lepe?” ");
INSERT INTO ong_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Fei, metine liti leptalo mete lire il lipi pite Moses lepe le namti lirpowo Jisas lolpepei, “Metine wuso onom manowo liri lepe.” Jisas nou lirpowo metine liti leptalo mete lire il lipi pite Moses lepe Jisas nou lirpowo lolpepei, “Ye re e ingiepe watafei le lepe.” ");
INSERT INTO ong_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Wem Jisas liripe pupam pele wala so pinge tisi pe le pe pe fale uf nele le moto nenpe, nange pene Marta, ne kesi Jisas nila ne winem lene. ");
INSERT INTO ong_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta winke pene Maria, ne nungra ratei ire yepe pite Apa Ili le ne ningitowo leptalo il. ");
INSERT INTO ong_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta onom one nire towa lite winem wuso ne nesio lepe le ne so ne nirpei nolpepei, “Ili leiki, ye onposi lo olo? Winke peiki nusaiki kesio towa kire yefli. Irpene piti ma nau kaneiki.” ");
INSERT INTO ong_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Wolo Apa Ili nou lirpene Marta lolpepei, “Marta, Marta, ye onom one le ye onposiepe men nange wurutei. ");
INSERT INTO ong_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wolo ye ma onposio menele niliyeye. Maria, ne keinio menmen teingitei le minemple re miso kali taniene kolo olotei.” ");
INSERT INTO ong_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Epli wem nele Jisas le ratei tulum nele, le le leletei Ma Ili. Wem Jisas leletei Ma Ili re fei, pupane nele lele lirpowo lolpepei, “Apa Ili, ye eitalouku piti meletei Ma Ili, min watafei Jon, le leptalo pupam pele pepe. ");
INSERT INTO ong_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jisas lirpepeye, “Wem ise yeletei Ma Ili, ise ma yirpei yolpepei, ‘Eiya, nimoure mete piti tef ma pailolowo nange teingi leiye. Ye frou au piti ma untoluwepe nimoure mete piti tef. ");
INSERT INTO ong_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ye wauku oweli piti maplei epli wem wem. ");
INSERT INTO ong_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Il olpe pouku ye ma onposiepe kolo wusoli ku re onposiepe il olpe pite mete yeflipi wuso pirouku olpe pepe kolo olo. Le ye ma usauku mualo tisi oli kolo’.” ");
INSERT INTO ong_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Le Jisas lirpepe pupam pele lolpepei, “Wuso nele leise, le ma le winem lite numu lele mulpou wem nimin le le ma lirpowo numu lele lepe lirpeiye, ‘Numu leiki, ye waiki lufe wengle twinges niliyeye le nolowi men ki miso namti waiye. ");
INSERT INTO ong_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Numu nele leiki wala lato so fei lepei lau fale winem leiki le ki oweli men piti watowo pepe olo.’ ");
INSERT INTO ong_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Le wuso numu leiye lepe lato winem leinginim le le ma namti lirpeiye lolpepei, ‘Kumtataiki pato. Wingi olo kalfo wingi teingoye, le ki kire eple peiki re olo metei. Ki ma keilo kali menele waiye kolo olo.’ ");
INSERT INTO ong_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ki kirpeiye, punkomtei le ma leilo waiye luom kolo olo wusoli le numu leiye wolo le ma leilo kapi men nange wuso ye olo pepe, le ma kapi yeflipiye waiye wusoli ye topo tapune piti eletei ire men nange pepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Le ki ma kirpeise, eletei Ma Ili le le ma waiye, intata le ye ma erengawo, amwewe wingi le le ma kapunuye wingi. ");
INSERT INTO ong_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Wusoli mete yeflipiye wem pe peletei Ma Ili, le ma watepe, minele piti lintata, le ma lerengawo, le minele piti lamwewe wingi Ma Ili ma kapunuwo. ");
INSERT INTO ong_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ise minemple fei yire yaire pepe, ye ma watowo ninge leiye wangu wem le leiteye lire ni lom? ");
INSERT INTO ong_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Lo ye ma watowo ilma pele wem le leiteye lire nafle yulum lom? ");
INSERT INTO ong_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Wuso ye metine pite ire il olpe, ye retai piti watepe eple peiye men teingipe Eiya lite yuwei re le ma watepe mete Riri Teingi wem pe peletei piri.” ");
INSERT INTO ong_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisas laltu riri oli piti lirpepei kolo olo, laltu tanio metine nele. Wem riri oli lepe le naro le tanio metine lepe, metine lepe le lirpepei. Mete wurutei pepe pe pinlele potei, ");
INSERT INTO ong_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wolo mete ilepe pirpei polpepei, “Le lire nange lite towa nimou liri laptu towa kumpu pepe le pe naro pe taniepe mete.” ");
INSERT INTO ong_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mete ilepe pirpolo ma puluwo waipiti le ma lualo tisi oli lo ma olo, le pe so peletei piti ma lirpei le menmen ma potei pire tute fale le fei pepe ma kosape polpepei, le lire singe pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wolo Jisas retape enke pelpe le le lirpepe lolpepei, “Wuso mete pite uf tef nele, pe kare peite nemple alpe kumpu kumpu le pe posinemple, pe ma pratei wem ulel kolo. Le wuso yaitei lire nimou re eple, pe kare peite nemple, pe ma pile singe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Le wuso towa kare leite lotei kumpu kumpu le pe posinemple, singe pele ma pratei wem ulel lo ma olo? Ise yirpei yolo ki kaptu ririm olpe taniepe mete wusoli towa nimou waiki singe piti ma kolpepei. ");
INSERT INTO ong_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wuso ki kingowo tisi fei lepe, le mete peise wuso pulteise pepe, pe polomen so pe paptu ririm olpe pepe? Mete peise isotei wuso pulteise pepe pe kosaise ise fupeiteteise. ");
INSERT INTO ong_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Olo, ki kire singe pite Ma Ili ki kaptu ririm olpe taniepe mete, le fei pepe ma kosaise polpepei, wem liti Ma Ili ma luntoluwepe mete piti tef, wem fei lepe olo lau faleiseye.” ");
INSERT INTO ong_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Wem metine kimplitei, le kapi men nange piti lolpo le le lopori lotei le le luntoluwo winem lele lotei, men nange pele piti winem ma teingipe pifei. ");
INSERT INTO ong_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wolo wem metine nele singetei, le fale losio le le lirkilau weisi, metine singetei lepe le kapi men nange piti lolpo wuso yaitei lite winem lepe le loporipe piti ma liripe lolpo pepe, metine singetei lepe le kapi lilape le le le ma karipe laptei kumpu kumpu watepe mete nemple. ");
INSERT INTO ong_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Minele piti lau lireiki kolo olo, metine fei lepe le luraiki, le minele piti kaneiki wengleipe mete waptei nemple kolo olo lepe, le metine piti laptu pire fla.” ");
INSERT INTO ong_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Wem riri oli naro tanio metine le ma laulo le linge tef oli punko lintata tulum piti ma ratei laltei yef. Wuso le lerengawo tulum nele kolo, le ma lirpei lotei lolpepei, ‘Ki ma nou ke winem wuso kusa le ki kau lepe.’ ");
INSERT INTO ong_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Liso riri oli lepe le nou le winem wuso linu ratei lepe le winem lepe pe pailolowo re pirowo teingitei. ");
INSERT INTO ong_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Leye lo riri oli lepe le naro le kesipe ririm olpe pire eti plen poungo te twinges (7), pe olo olpetei pinuwo lotei piti kesipe pepe le pe pau pepi pratei winem lepe. Metine fei lepe, linu le ausi oli wisyou wolo fei le weitei olitei.” ");
INSERT INTO ong_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Wem Jisas lirpei il fei pepei re fei, moto nenpe wuso neingalope mete wurutei nimin lepe ne nirpowo Jisas nolpepei, “Moto wuso nilaye re nuntoliye lepe, ne ma onom teinginetei.” ");
INSERT INTO ong_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wolo Jisas namti lirpene lolpepei, “Mete wuso pingitepe il pite Ma Ili le pe pulpope, mete fei pepe pe ma enke teingipe.” ");
INSERT INTO ong_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wem mete wurutei fale panfi, Jisas reresipe il lirpei lolpepei, “Mete piti wem fei lepei, pe olo olpetei. Pe peiteiki piti ma kirpei le menmen ma potei pire tute fale wolo ma olo. Menmen ma potei pire tute fale wolo ma olo. Menmen wuso sungoi falowo Jona lepe, menmen falepe soma kosape, le pe ma pretai. ");
INSERT INTO ong_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Min watafei metine nimou Jona, sungoi liye le kosape mete pite Ninive, le Ninge liti Metine Wape, le ma kosape mete piti wem fei lepei. ");
INSERT INTO ong_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wem piti Ma Ili ma lingitepe le le kapi il laptei lire moingi pite mete piti tef, moto ine ma namtuse ise mete piti fei. Ne moto ine sungoi ratei le ne nuntoluwepe mete, ne piti tef minim. Wem fei lepe ne ma namtuse wusoli ne nusa uf lene, le ne naule tisi ulel piti ne ma ningitowo metine ili Solomon. Le Solomon, le leptalo il pele piti onom nire wuru. Ne nau ningitowo Solomon. Wolo fei metine nele laule faleise, le nange ilitei, le Solomon olo. Le le lau lirpeise lire onom pele nire wurutei. Le fei ise yingitowo kolo. Moto ine nepe ne ma namtuse nirpeiye, ‘Ise mete olpe, ki kato fiyen kaule piti kingitowo Solomon, wolo ise yinau piti yingitowo metine ili fei wuso lileise malfem lepe, le ise yingitowo kolo.’ ");
INSERT INTO ong_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wem piti Ma Ili ma lingitepe le le kapi il laptei lire moingi pite mete piti tef, mete pite uf Ninive ma pamtuse. Wusoli wem pe pingitepe il wuso metine nimou Jona leptalo pepe, pe pulpope le pe pusape il olpe pelpe. Wolo fei metine nele, nange lele ilitei le Jona olo, metine ili lepei le lau lirpeise wolo ise yingitowo kolo. Liso mete pite Ninive ma pamtuse pirpei polpepei, ‘Ise mete olpe. Wem Jona lau lirpouku, ku yeflipiye weitei onom le ku musape il olpe pouku. Wolo metine ilitei lau lirpeise le ise yingitowo re yulpowo kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Minemple miso peltei nongo weli le pe palingi lato poi tef lo pe kali waifile pire muntuwo, ma olo. Wolo pe ma paltei luwo poi yuwei soma mete puluwo le pe pinki pau winem leinginim. ");
INSERT INTO ong_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lutepe peise pe watafei nongo weli lite topo tale. Wem lutepe peise teingipe felkele, topo tale yefliye ma lini watafei weli. Wolo wem lutepe peise olo olpe pire munkunum, topo tale yefliye ma oli olfutuwo. ");
INSERT INTO ong_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ise ma kotopa isotei yolpepei, weli wuso yesio lepe le ma weitei lire munkunum kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wuso topo tale leiye yefliye le lini lirkilau watafei weli le topo tale ile leiye re olo olfutuwo kolo olo, is topo tale yefliye ma lini yali niliye, watafei wem weli lini luwoye lepe.” ");
INSERT INTO ong_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wem Jisas lirpei re fei, metine nele lite Farasi lirpowo Jisas piti ma rounge taplei oweli. Liso Jisas linki le winem le le lungura lifei piti ma laplei. ");
INSERT INTO ong_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Metine lite Farasi lepe le linlele lotei wem le luluwo Jisas wuso kaptetei esi pele kolo olo. (Mete piti Farasi, pe wai lelpe piti ma pinu kaptetei esi wo pe soma pesiepe oweli paplei.) ");
INSERT INTO ong_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Liso Apa Ili lirpowo lolpepei, “Ise mete piti Farasi, ise kaptetei minki paingelem re wengle esi piti yalelei tipe, ise kaptetei yinge toungalem re mingelem piti towa yawi, wolo leinginim peise, il olpe pirkilautei pratei. ");
INSERT INTO ong_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ise fupeiteteise ko. Ma Ili wuso lesiepe linge towa yawi pepe, leinginim pelpe re le lesiepe lo olo? ");
INSERT INTO ong_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wolo menemple piti pratei leinginim peise, ise ma nampli watepe mete wuso oweli yini olo, nange naplei pepe. Ise yolpepei le men nange peise yeflipiye ma fale teingipe.” ");
INSERT INTO ong_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ise mete piti Farasi, moingi ilitei ma faleise. Ise kapi oweli wopu piti pire weisipe oweli watafei yefeingu re yaipuwi yousi le ise yaptei tulum pire eti plen poungo le piti eti plen. Leye lo ise kapi piti tulum niliyeye pepe ise yaptei watowo Ma Ili, wolo ise ratei teingipe tuwopou kolo olo le ise onom kerowo Ma Ili kolo olo. Ise olo ma weitei le ise ma ratei teingipe tuwopou, ise ma onom kerowo Ma Ili, ise yingiepe il fei pepei, le nemple watafei ise karipe oweli yaptei watowo Ma Ili re, ise ma yingiepe yapwonou. ");
INSERT INTO ong_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ise mete piti Farasi, moingi ilitei ma faleise. Ise onom kerepe tulum teingipe piti angli pal, onom kerepe piti ma ye yifei le tulum piti paptetei re paisesipe oweli pepe, ise onposi yirpolo mete ma peiteise poporo. ");
INSERT INTO ong_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Moingi ilitei ma faleise. Ise watafei teliyom piti paptei towa wolo teliyom pepe pe kotire pato tef le mete pironom pilele pe pau pinge yuwei pe pretai kolo.” ");
INSERT INTO ong_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Metine nele piti leptalo mete lire il lipi pite Moses, le lirpowo Jisas lolpepei, “Metine liti eptalo mete, wem ye irpei il pepei, ku re ye irkilau amtuku.” ");
INSERT INTO ong_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Fei, Jisas namti lirpowoye, “Ise mete piti yeptalo mete yire il lipi pite Moses, ise re moingi ilitei ma faleise. Ise kapi menemple lipi moingi watepe mete piti ma pilape wolo ise isotei ma kete eti yaltei piti ma kaniepe yila moingi fei lepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Moingi ilitei ma faleise. Ise yaploupe era namplungu le ise yiripe yini piti ma onposiepe mete emarengi wuso sungoi liye yaire manre peise petesipe pa le pe paptei pepe. ");
INSERT INTO ong_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ise isotei min kosai isotei alepe nimin yirpolo ise yulpope manre yaire peise wuso petesipe mete emarengi pa pepe, ise onom nenpiyeye watafei manre yaire peise wusoli pe petesipe mete emarengi pa le ise yaploupe era namplungu le ise yiripe yini piti ma onposiepe mete emarengi pepe. ");
INSERT INTO ong_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Min polpepe so Ma Ili, le onom ulene le le so lirpei lolpepei, Ki ma kaisipe mete emarengi le mete piti pilape il peiki pe, ki ma kaisipe pe le mete pepe ma petesipe ilepe pa le ilepe pe ma posiepe olpetei.’ ");
INSERT INTO ong_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mete piti wem fei lepei pe ma pila moingi piripe mete emarengi wuso manre yaire pelpe petesipe pa pepe, pe ma pila moingi piripe pile wem linutei wuso Ma Ili laptei tef teplai re men nange pepe le le lau lau fale fei. ");
INSERT INTO ong_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Pe ma pila moingi pile wem pe petesi Abel la le le lau lau fale Sekaraia wuso pe petesi la lato nimin lite tile pite peptawio Ma Ili siye le winem leinginim lite Ma Ili. Iyo, ki kirpeise, mete piti wem fei lepei pe ma pila moingi piripe mete emarengi yeflipiye wuso manre yaire pelpe petesipe pa pepe.” ");
INSERT INTO ong_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ise mete piti yeptalo mete yire il lipi pite Moses, ise moingi ilitei ma faleise. Ise yesio wingi teingo liti lufro lapiri wingi. Wem ise kesi tani, wingi ma pungo le mete ma pinki pe winem leinginim piti ma kani onom nire wuru. Ise isotei yinki ye kolo olo, le ise il karipe mete wuso pirpolo ma pinki pe pepe, wolo ise il karipe.” ");
INSERT INTO ong_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Wem Jisas lusa tulum fei lepe, mete piti peptalo mete pire il lipi pite Moses le mete piti Farasi, pe pirpei kelelawo olpetei le pe peletetei pire men nange wuru. ");
INSERT INTO ong_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pe onposi pirpolo ma pempesi lualo tisi oli le wem il menemple olpe fale nemi lele, pe ma pirpei pamtuwo pirkilau. ");
INSERT INTO ong_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wem mete wurutei pau panfinemple kir oli, pe wurutei le pe poli nemple ire yepe tef, tulum nele re lato yawi kolo. Wem fei lepe Jisas linu lirpepe pupam pele lolpepei, “Ise ma kotopa isotei yire il tipe pite Farasi. Pe mete piti nel loli ilo ilo. ");
INSERT INTO ong_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Menemple piti paplingi pato, pe ma paptei alepe nimin le il menemple kumpu, pe ma fale lipi mete wuru ma pretape. ");
INSERT INTO ong_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Liso il menemple ise yire mulpou yirpei, mete ma pire epli pingitepe. Le il menemple wuso ise yamsi wingi kare isotei yato leinginim le ise yirpei loule loule, yirpei yafo nemple mingim, il fei pepe ma yifei winangou tupelengi le ise ma yirpei yirkilautei.” ");
INSERT INTO ong_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Numuwi peiki ki kirpeise, ise ma turise yiripe mete wuso petesi topo yawi la wolo moingi men ma pe nou waise, oloye. Ise ma turise yiripe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ki ma kosaise kire minele piti ise ma turise yasio. Ise turise yasio Ma Ili, wem le letesi topo la, le miso lire singe pele liri riri le weli ili. Iyo, ki kirpeise ise turise yasio.” ");
INSERT INTO ong_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Nafle elalwongou pire eti plen poungo, ye miso ire eifungu maltou twinges ire aisipe ko? Wolo nenpe pelpe re Ma Ili lirene onom kolo. ");
INSERT INTO ong_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Min watafei oru leiye liti falo, Ma Ili koponape oloye. So ise turise pato. Naflepem elalwongou wuru Ma Ili onposiepe wolo ise mete, ise niliyeye niliyeye Ma Ili onposise lirkilautei.” ");
INSERT INTO ong_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ki kirpeise, minele wuso lirpepe mete wuru lirpolo le lite ki, Ninge liti Metine Wape ma namti lolpepe. Le ma lirpepe ririm pite Ma Ili, lirpepe lire metine fei lepe. ");
INSERT INTO ong_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wolo minele wuso lile onom pite mete wuru le le lirpei lire yef lirpolo le leiki kolo, metine fei lepe Ninge liti Metine Wape re ma namti lirowo yef liri, wem le lile onom pite ririm pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Minele wuso lirpei il olpe liri Ninge lite Metine Wape, wuso metine fei lepe weitei lusape il olpe pele, Ma Ili ma onposiepe il olpe pele kolo olo. Wolo minele wuso lirpei il olpe liri Riri Teingi, metine fei lepe Ma Ili ma onposiepe il olpe pele le le ma watowo moingi.” ");
INSERT INTO ong_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Wem pe keteise pilaise pe angli pal piti ma kapi il paptei pireise lo ye falepe moli lipi piti puntoluwepe mete, ise ma onom one yire il men piti yirpei kane isotei lo piti ma namti yirpepe, olo ise ma onom one kolo. ");
INSERT INTO ong_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Wusoli wem fei lepe Riri Teingi ma leitaloise lire il men piti ma yirpei.” ");
INSERT INTO ong_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Fei, metine nele wuso leingalope mete wurutei nimin lepe lirpowo Jisas lolpepei, “Ye metine liti eptalo mete, ye irpowo apa leiki piti ma karipe oweli men nange wuso eiya louku lusapouku lope pepe, irpowo piti ku ma karipe wainoute.” ");
INSERT INTO ong_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisas namti lirpowo lolpepei, “Ko ye metine, minemple waiki il piti ki ma kapi il kaptei kireise rounge lo piti ki ma karipe oweli men nange waise rounge?” ");
INSERT INTO ong_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Le Jisas reresipe il lirpepe mete yeflipiye lirpepe lolpepei, “Ise ma kotopa isotei yire tisi wuru piti yire filai, wusoli oweli men nange wuso metine kapi laptei lotei pepe, pe ma watowo nempi liti ratei wem ulel kolo olo. Wuso le oweli yini men nange wurutei re miso olo, pe ma kanowo kolo olotei.” ");
INSERT INTO ong_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Leye lo Jisas lirpepe lire il kauro yuwei pepei, lirpei lolo, “Metine nele le oweli yini wurutei le le tef nele lele olo teingi lilape oweli teingipe. ");
INSERT INTO ong_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Metine lepe le onposi lotei leinginim lirpolo ‘Ki tulum nele piti kaptei oweli peiki pifei kolo olo. Ki ma kolomen? ");
INSERT INTO ong_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ki ma kolpepei,’ le lirpepei lotei, ‘Ki ma kaptutu winangou wuso kaptei oweli pifei pepe le ki ma keilape nemple lipi le ki ma kaptei wit re oweli nemple pepe pifei winangou lipi pepe. ");
INSERT INTO ong_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Leye lo ki ma kirpei kutei kolpepei, ye oporotei, ye men nange peiye wurutei piti ma kaneiye ratei eringi wuru. Ifei ratei oporo, aplei oweli re tipeluwi, le ye onom teingine asi yotei.’ ");
INSERT INTO ong_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wolo Ma Ili lirpowo metine lepe lolpepei, ‘Ye fupeiteteiye, fei mulpou lepei, ki ma kesi nempi taniye le men nange wuso kapi aptei yotei pepe minemple ma kapiye lope?’” ");
INSERT INTO ong_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Le Jisas lirpei il lapulu lolpepei, “Moingi fei lepe ma falepe mete wuso kapi men nange wurutei paptei potei wolo pe pirkilau kapi il pite Ma Ili kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Leye lo Jisas lirpepe pupam pele lolpepei, “Min polpepei so ki kirpeise piti ma onom one kolo yire oweli piti yaplei le ise nampir ratei lo olongou piti yafo muntuwo topo leise, olo, ise ma onom one yiripe kolo. ");
INSERT INTO ong_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nempi wuso lungise le ise nampir ratei pepe, nempi fei lepe le teingi linuwepe oweli, le topo tale leise, le teingi linuwepe olongou. ");
INSERT INTO ong_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ise yulwepe naflepem krau, pe papiri oweli fouri kolo lo pe kotuwepe oweli paptei pifei kolo. Pe winangou lipi piti paptei oweli pifei kolo olo, wolo Ma Ili watepe oweli piti paplei. Ma Ili onposise lirkilautei le naflepem olo, le onposiepe kumputei. ");
INSERT INTO ong_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Minele leise miso reresi wem lele piti ma namin ratei wem le onom one, le miso lolpepe lo olo? ");
INSERT INTO ong_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Wuso towa men kumpu fei lolpepei ye miso esio kolo, piti men ma ye onom one iripe men nange eryai pepe? ");
INSERT INTO ong_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ise yulwepe wolo tafe pite towa yawi, pe peilo polomen? Wolo ki kirpeise, Solomon le oweli yini pele wurutei wolo olongou pele piti lire yini pepe pe teingipe watafei wolo tafe pepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ma Ili lirepe yini wolo tafe pite towa yawi, pe fei pile wolo nolowi pe pa le pe ma peplesi weli. Ma Ili ma onposi piti ma waise olongou piti yafo lo ma olo? Ise yulpope il pite Ma Ili yirkilau kolo. ");
INSERT INTO ong_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ise onom one yire oweli re tipe piti ma yaplei kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Wusoli mete piti tef wuso pulpowo Ma Ili kolo pepe, pe wem oli oli onposiepe men nange fei pepei le ise ma olo. Eiya leise le retai piti le ma waise men nange fei pepei. ");
INSERT INTO ong_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wolo ise ma onom natowo wem piti le ma luntoluwepe mete pele piti tef le le ma waise men nange fei pepei.” ");
INSERT INTO ong_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ise kumpu yaipiyeye wolo ise turise pato wusoli Eiya leise le onom teingine piti ma waise wem teingi lele piti le ma luntolise. ");
INSERT INTO ong_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Oweli men nange peise ise kapi yaptepe mete nemple paisepe le ise kapi era le era fei pepe ise ma watepe mete wuso pe oweli yini nange naplei pepe. Ise yintape tenge eple teingipetei piti kapi wusoli pe ma kerere kolo, le mole yini teingipe peise ise yaptei pifei uf lite Ma Ili yuwei. Tulum fei lepe pe ma yalipe frou kolo olo wusoli minele piti lire ausi, le miso le kapi kolo olo, le mou re miso fale losiepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wusoli tulum wuso menmen teingipetei peiye pifei pepe, tulum fei lepe ma ye onom peiye natowo.” ");
INSERT INTO ong_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ise yopori isotei wusoli menmen ma faleise le weli peise ma yeflipetei poli. ");
INSERT INTO ong_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ise yolpepe watafei mete piti pesio towa lite moli nele ili, pe popori potei pifei pungario moli ili lelpe wuso le lulwepe papli oweli lipi piti metine nele lire moto roum maiteneme. Pe popori potei pifei pungario piti le ma nou lau. Wem le lau lamwewe wingi, pe ma frou kamunu. ");
INSERT INTO ong_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mete pite pesio towa lite moli ili lepe pe ma onom teingine wem moli ili lelpe lepe le lerengape pe petei kolo, pe popori potei pifei pungario piti le ma nou lau. Ki kirpeise, le ma lopori lotei piti kaniepe, le le ma lirpepe mete pele piti pesio towa lele pepe, lirpepe pifei le le ma kapi oweli watepe. ");
INSERT INTO ong_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mete piti pesio towa lite moli ili lepe, pe ma onom teingine wem le lau fale le le lerengape pe popori potei pifei. Wuso le ma lau fale mulpou wem nimin lo nolowi nau piti ma ifili wolo le lerengape pe popori potei pifei. ");
INSERT INTO ong_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Le ise ma retape fei pepei, wuso yaitei lite winem le retai wem piti metine piti lire ausi lepe le ma lau, yaitei liti winem ma lusa yaruwo winem lele kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Le ise re ma yopori isotei wusoli wem piti Ninge liti Metine Wape ma lau lepe, wem fei lepe olo ise retai kolo.” ");
INSERT INTO ong_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Fei Pita leltei Jisas lolpepei, “Ili louku, il kauro yuwei pepei ye irpouku ku lo ye onposi piti ma irpepe mete wuruye?” ");
INSERT INTO ong_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Apa ili nou lirpowo Pita lolpepei, “Ise mete piti yesio towa lite moli ili le minele leise le onom pele nire wuru le le telpalo lesio towa lele loporo, minele leise fale lolpepei? Metine fei lepe moli ili ma laltei luntoluwepe men nange pele. Le ma luntoluwo winem re men nange pite moli ili lepe le le ma watepe oweli mete nemple wuso pepi pesio towa lite moli ili lepe, wem liti le ma watepe oweli, wem leletei, le ma watepe. ");
INSERT INTO ong_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Metine piti lesio towa lepe le ma onom teingine wem moli ili lele nou lau fale winem le le luluwo lesio towa fei lepe loporo. ");
INSERT INTO ong_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Punkomtei ki kirpeise, metine fei lepe moli ili lepe ma laltei luntoluwepe men nange pele yeflipiye. ");
INSERT INTO ong_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Le wuso metine piti lesio towa lepe le ma lirpepe lotei lolpepei, “Moli ili leiki wala ma lato wem ulel le soma nou lau.’ Le le losiepe mete re nimoure wuso pepi pesio towa lite moli ili niliyeye lepe, le le laplei oweli re tipeluwi le le lini lurungo. ");
INSERT INTO ong_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Leye lo moli ili lepe le ma nou lau wem nele wem metine lele piti lesio towa lele lepe le lironom lire wem fei lepe. Moli ili lepe le ma lalolowi metine wuso telpalo lesio towa loporo kolo lepe, lalolowi lire kumpu kumpu le le ma lila moingi ili watafei mete piti paptei mingim kolo pepe.” ");
INSERT INTO ong_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Metine piti lesio towa lepe, wuso le retai lire towa men moli ili lele lirpowo piti le ma lesio, wolo le lopori lotei piti ma lingiepe il pite moli ili lele lepe kolo olo. Metine fei lepe, ma moli ili lele lire ningo teingo lirkilau letesi wem wuru taise. ");
INSERT INTO ong_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wolo metine minele piti lesio towa lepe wuso le retai lire towa men moli ili lele lirpowo piti ma lesio kolo, olo lironom le le lesio towa oli piti ma lila moingi. Metine fei lepe ma moli ili lele letesi wisyauye. Liso wem metine nele waiye menemple lipi taise piti ye ma namti watowo, ye re ma namti watowo lipi taise. Le wuso le waiye menemple lipitei, ye re ma namti watowo lipitei.” ");
INSERT INTO ong_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ki kaule piti ma kaltei weli loli tef, le ki onposi kirpolo weli olo ma loli frou. Weli lepei le moingi lite Ma Ili lele piti ma watepe mete wuso pulpope il pele kolo pepe. ");
INSERT INTO ong_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Moingi nele wala lato piti ki ma kila watafei pe porweiki kinki tipe lepe le fei moingi lepe wala kila kolo, le ki onom moinginetei. ");
INSERT INTO ong_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ise yirpolo ki kila wem teingi kaule piti ma kaltepe mete piti tef lom? Olo, ki kirpeise, wem teingi kolo wolo ki kaule piti ma karipe mete kaptei. ");
INSERT INTO ong_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Wem fei lepei le le le, mete pire eti plen poungo, pe pite winem niliyeye, pe ma kare peitei nemple. Pe twinges niliyeye pepe, pe ma onom one pire twinges pelpe, le twinges tepe te ma namti onom one tire twinges niliyeye pepe. ");
INSERT INTO ong_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yaire ma onom one pasiepe eple tuleingi pelpe le eple tuleingi ma namti onom one piripe yaire pelpe. Emare ma enke olpe pasiepe eple feri pelpe, le eple feri ma namti polpepe piripe emare pelpe. Emare ma enke olpe pasiepe eple yerem pelpe le eple yerem ma namti polpepe piripe emare piti mungarem pelpe.” ");
INSERT INTO ong_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mete wurutei pepe re Jisas lirpepe lolpepei, “Wem ise yuluwo nopom fale laitei le liti epli lautile, ise frou yirpei yolo, ‘Le ma nef,’ le punkomtei, nef nalolo. ");
INSERT INTO ong_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Le wem ise yingitowo yuf lini lile tef minim lau, ise yirpei, ‘epli ma welitei,’ le le lolpepe. ");
INSERT INTO ong_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ise fupeiteise. Ise miso yuluwo tef lire teplai le ise retai men ma fale, le piti polomen so menmen wuso fale wem fei lepei lepe, wolo ise yironom yasiepe pepe?” ");
INSERT INTO ong_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Menmen teingipe piti ma yingiepe wolo piti polomen so ise isotei ma kapi yaptei kolo pepe? ");
INSERT INTO ong_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wuso metine nele lirpepe moli lipi lireye piti ye ma e falepe, ye ma frou inta tisi piti ma amtuwo il wem ise rounge wala yato tisi. Wuso ye olpepe kolo, soma metine lepe le ma leipeye lilaye le falowo moli ili piti kapi il laptei lireye le moli ili fei lepe le ma leiteye e eti pite yalu pau, le yalu pau lepe le ma leiteye ifei winem oli. ");
INSERT INTO ong_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ye ma naro e yawi tani winem oli lepe kolo, ki kirpeiye, ye wala ma aisipe moingi peiye yalipe wo, ye soma naro e yawi.” ");
INSERT INTO ong_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wem fei lepe mete nemple wuso pile pepe pe pirpowo Jisas pire mete pite Galili wuso Pailat letesipe pa wem pe wala peptawio Ma Ili siye. ");
INSERT INTO ong_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisas namti lirpepe lolpepei, “Wusoli pe pa pinge tisi fei lepe le ise onposi yirpolo fei pepe ma kosaise polpepei, pe olo mete piti pingiepe il olpetei le mete nemple piti Galili pepe pe olo olpe watafei pe pepe kolo lom? ");
INSERT INTO ong_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Olo, ki kirpeise, wuso ise tounga pesipe il olpe peise kolo, ise yeflipiye ma ya watafei pe pepe. ");
INSERT INTO ong_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Le mete wuru (18) wuso winem ulel yuweitei, le lualo lenfariepe pa pato Siloam pepe, ise onposi yirpolo fei pepe ma kosaise polpepei pe olo mete olpetei piti pire il olpe le mete nemple yeflipi wuso pratei Jerusalem pepe pe olo olpe watafei pe pepe kolo lom? ");
INSERT INTO ong_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Olo, ki kirpeise wuso ise tounga pesipe il olpe peise kolo, ise yeflipiye ma ya watafei pe wuso winem lenfariepe pa pepe.” ");
INSERT INTO ong_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Leye lo Jisas lirpepe lire il kauro yuwei pepei, “Metine nele lari ifau lile liom lele liti lari wain. Metine lepe le luntoli lirpolo yumko pultei, wolo olo pultei kolo. ");
INSERT INTO ong_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Le so lirpowo metine lele liti luntoluwo liom wain lepe, lirpowo lolpepei, ‘Ye untoli, eringi twinges niliyeye ki ke kau kintatape yumko piti ifau lepei le ki kulwepe nemple kolo. Elele lualo tani, piti men ma le lile leipepi tipe liti tef yawi?’ ");
INSERT INTO ong_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wolo metine liti luntoluwo liom lepe le namti lirpei lolpepei, ‘Ili leiki, usa lile eringi nempleiyeye fei pepei wo. Ki ma koflei tef neinowo le ki ma kalfofo olfom weli. ");
INSERT INTO ong_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Le wuso eringi nemple le yumko pultei ifau lepei, pepe ma teingipe, wuso oloye, lo ki ma kelele taniye’.” ");
INSERT INTO ong_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Epli wem nele piti pifei onposio Ma Ili, Jisas leptalo mete lifei angli pau nele. ");
INSERT INTO ong_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Moto nenpe niripe pepi pifei angli pau lepe, riri oli lunkuwene le le watene moingi eringi wuru (18). Riri oli lepe le yaruwene tounga pene nani le ne nungutu nuwowo, miso neilo nile tuwopou kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Wem Jisas lulwene, le linane, “Moto, kainu peiye ma pe taniye.” ");
INSERT INTO ong_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jisas leptalo esi pele puwone le frou yo fei, moto nepe kete notei nile tuwopou le ne neila nange lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Metine piti luntoluwo angli pau lepe le onom kotu wusoli epli wem fei lepe le wem piti pifei yaupe onposio Ma Ili, le pe ma pesio towa men kolo, wolo Jisas kapi kainu taniene moto fei nepe. Liso metine piti luntoluwo angli pau lepe le onom kotu le le nempe nemi lirpepe mete wuso pifei angli pau pepe, lirpepe lolpepei, “Epli wem wuso pire eti plen poungo le nele piti lire eti kera plen, epli wem fei pepe pe wem piti ku ma mesio towa le wem fei pepe soma ise yau piti le ma kapi kainu tanise le wem piti mifei onposio Ma Ili lepe, le ma lolpepe kolo.” ");
INSERT INTO ong_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Apa Ili namti lirpowo lolpepei, “Ise mete piti nel loli ilo ilo. Wem piti ise yifei onposio Ma Ili, wem fei lepe ise minele re ma nenfari bulmakau lo donki lele tani tulum piti topuwo laitei lepe le le ma kesi lila le watowo tipe lo olo? ");
INSERT INTO ong_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Le fei, ningio palyo pite Abraham nepei, ne wuso towa lirkilau lesiene lanri le eringi wuru (18), le wem piti ku mifei onposio Ma Ili lepe ku ma kaniene ne yaune taniepe singe pite towa lo ma olo?” ");
INSERT INTO ong_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wem Jisas lirpei lolpepei, mete yeflipiye wuso enke olpe piri pepe pe topungou olpetei pasi potei, wolo mete nemple pepe pe enke teingipe pasiepe men nange teingipe wuso Jisas laptei fale pepe. ");
INSERT INTO ong_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Leye lo Jisas lepletei lolpepei, “Wem teingi liti Ma Ili ma luntoluwepe mete pele pepe, wem fei lepe le ma watafei men? Ki ma nausi kire men? ");
INSERT INTO ong_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Le ma watafei yumko tingeni wuso metine nele laptei liom lele lepe, yumko uwol fale le le leilo le ili lire nimpe ifau, laptei angoleingi le naflepem pepe, pe pau paptei onkotu pelpe pultei.” ");
INSERT INTO ong_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisas nou lepletei lolpepei, “Wem teingi liti Ma Ili ma luntoluwepe mete pele pepe, wem fei lepei lepe, ki ma nausi kasi men? ");
INSERT INTO ong_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Le ma watafei yis wuso moto nenpe ne ma kali nire weisi luom ili le luom lepe le ma linpei le ilitei.” ");
INSERT INTO ong_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas le linge uf walem kumpu re lipi re, le le leptalo il le le yo ma fale Jerusalem-ye. ");
INSERT INTO ong_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Fei mete nemple peletei Jisas polpepei, “Ili louku, Ma Ili ma kaniepe mete yaipiyeye lom?” Le Jisas namti lirpepe lolpepei, ");
INSERT INTO ong_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ise yire isotei kilau piti ma yinki wingi kumpu wusoli ki kirpeise punkom, mete pirpolo ma pinki pe wolo pe pinki pe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yaitei liti winem le ma leifale lamsi wingi, leye lo wem ise yile towa yawi yamwewe wingi le ise yirpei yolo, ‘Ili louku, ye kamunuku wingi.’ wolo le ma namti lirpeise lolpepei, ‘Ise minemple le ise yato pinei yau? Olo, ki kireise onom.’ ");
INSERT INTO ong_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Leye lo ise ma nou yirpowo yolpepei, ‘ku mireye mepi maplei oweli re tipe le ye eptalo il ifei uf louku.’ ");
INSERT INTO ong_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wolo le ma nou lirpeise lolpepei, ‘Ise minemple le ise pite pinei yau? Olo, ki kretaise kolo. Ise ye taniki, ise mete piti yire il olpe.’ ");
INSERT INTO ong_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ise ma youtiti re yaplelei nilpe wem ise yulwepe manre peise, Abraham lire Aisak re Jekop le mete emarengi yeflipiye, ise ma yulwepe pratei uf teingi lite Ma Ili lele wolo ise isotei, Ma Ili ma lireise ye ratei towa yawi. ");
INSERT INTO ong_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mete pite epli fale le pite epli lautile, pe pite tef yuwei le pe pite tef minim, pe ma paule pifei poi piti Ma Ili pele pratei uf teingi lele, le pe ma pepi paplei oweli lipi. ");
INSERT INTO ong_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Leye lo mete wuso fei pingi pepe, pe ma namti fale pinu, le mete wuso fei pinu pepe pe ma namti weitei pingi.” ");
INSERT INTO ong_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wem elpesi lepe, mete ilepe pite Farasi pe pau falowo Jisas le pe pirpowo polpepei, “Ye ma usa tulum fei lepei le ye e nele tani, wusoli Herot lirpolo ma leiteiye a.” ");
INSERT INTO ong_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisas namti lirpepe lolpepei, “Ise ye yirpowo morou lepe. ‘Ki kaptu ririm olpe taniepe mete le ki kapi kainu taniepe, fei, le nolowi, le nolowi nele ki ma kesio towa yali.’ ");
INSERT INTO ong_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wolo ki wala ma ke, fei, nolowi le nolowi nele. Pe pato poporo kolo piti metine nimou ma la lato tulum nele yawi kolo, wolo Jerusalem soma le ma le la.” ");
INSERT INTO ong_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem, ye aptei mete emarengi pa, le ye iripe era osiepe mete wuso Ma Ili laisipe pilape il pele pau pepe. Wem wuru ki kirpolo ma kengleipe eple peiye kapte nemple watafei woflu nimou naungipe eple pene pratei flingu tef pepe, wolo ye usaiki kolpepe kolo. ");
INSERT INTO ong_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Fei, ye uf leiye ma minemple re pratei kolo, olo ma pinlele pantutu taniye. Ki kirpeiye, ye ma nou uliki kolo, e e fale wem ye ma irpei olo, ‘Ma Ili lailolowo metine wuso laule lire nange lite Ma Ili lepe’.” ");
INSERT INTO ong_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Epli wem nele liti pe ma pifei onposio Ma Ili, wem fei lepe Jisas le winem lite metine nele ili lite Farasi, le le piti ma laplei oweli. Le mete olo lutepe ye patotowo, lupoluwo poporotei. ");
INSERT INTO ong_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Metine nele wuso ire re esi pele plankengei pepe, le lau falowo Jisas. ");
INSERT INTO ong_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Le Jisas nempe nemi lepletei mete piti peptalo mete pire il lipi pite Moses le mete pite Farasi, Jisas lepletei lolpepei, “Il lipi pouku pirpei piti epli wem piti ku mifei onposio Ma Ili le ku ma kapi kainu taniepe mete lo ma olo?” ");
INSERT INTO ong_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wolo pe il men re pirpei kolo. Liso Jisas kesi metine lepe, kapi kainu pele tanio, le le laisi le. ");
INSERT INTO ong_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Leye lo Jisas lepletei lolpepei, “Wuso minele leise, le ninge lele lo bulmakau lele lironom lualo lautile tipe oi epli wem liti yifei onposio Ma Ili, ise ma frou ye kesi tani tipe oi lepe lo ma olo?” ");
INSERT INTO ong_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wolo pe miso namti pirpowo pire il pele wuso lepletei pepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas lulwepe mete wuso pinape paule pepe, pe keiniepe tulum teingipe piti pifei, liso Jisas lirpepe pe yeflipiye, lirpepe lire il kauro yuwei pepei, ");
INSERT INTO ong_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wem mete nemple pinaiye e piti ma ulwepe papli oweli lipi pite metine nele lire moto ma roum maiteneme, ye ma e ifei tulum teingi kolo olo. Waipiti metine nele ili, lesio towa ili linuye, le re pe pinawo piti ma lau lulwepe. ");
INSERT INTO ong_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Le mete wuso pinaise ye pepe, pinaiye ye le metine nele ili linuye lepe, pe ma pau pirpeiye polpepei, ‘Usa le lifei tulum leiye.’ Leye lo ye ma topo tapune asi yotei le ye ma e ifei tulum nele teingi loporo kolo. ");
INSERT INTO ong_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wolo wem mete pinaiye e, ye ma e ifei tulum teingi loporo kolo, lepe soma mete wuso pinaiye pepe, pe ma pau le pe pirpeiye polpepei, ‘Numu louku, eilo e ifei tulum teingi liye.’ Fei pepei ma peila nange leiye, le mete nemple wuso pinape pau pepe re, pe ma onposi pirpolo ye metine ili. ");
INSERT INTO ong_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Wusoli metine piti leila nange lele lotei, Ma Ili ma laltu laltei linge tef. Le metine minele wuso lautu lultei lire yape lepe, metine fei lepe Ma Ili ma leila nange lele.” ");
INSERT INTO ong_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Leye lo Jisas lirpowo metine wuso linawo le piti ma rounge taplei tepe, Jisas lirpowo lolpepei, “Wem ye apli oweli pite epli wem nimin lo pite mulpou, ye ma inape numuwi peiye kolo, lo ilim winkem peiye, lo ilepe peiye piti teluwi alpe niliyeye lo mete wuso pratei malfem pireye le pe oweli yini men nange wurutei pepe, ye ma inape mete fei pepei kolo. Wusoli pe ma namti pinaiye, le ye ma kali menele re kolo oloye. ");
INSERT INTO ong_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wolo wem ye apli oweli lipi, ye ma inape mete wuso oweli yini nange naplei pepe, ire esi olpe, ire esi pa le mete piti lutepe olpe, ye ma inape fei pepei, ");
INSERT INTO ong_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","le Ma Ili ma laileleye re luntoliye wusoli mete fei pepe pe miso namti papli oweli pinaiye kolo. Ma Ili ma laiteiye wem mete teingipe tuwopou wuso pa pepe, pe ma nou peilo.” ");
INSERT INTO ong_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Fei, metine nele wuso lifei poi pepe le lingitepe il pepei le le lirpowo Jisas lolpepei, “Mete wuso pire Ma Ili pifei paplei oweli lipi pifei uf teingi lele lepe, mete fei pepe pe ma enke teingipe.” ");
INSERT INTO ong_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisas namti lirpowoye, “Metine nele lapli oweli lipitei le le linape mete wuru. ");
INSERT INTO ong_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wem piti ma paplei, le laisi metine lele piti lesio towa lele lepe, laisi le piti ma lirpepe mete wuso metine ili lele linu lirpepe pepe, lirpepe lirpolo, ‘Yaule, oweli men nange olo fei elpesipe pifei.’ ");
INSERT INTO ong_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Wolo pe yeflipiye, puwo nemple pirpei pirpolo ma pe paplei oweli lipi pepe kolo. Metine wuso linu lirpowo metine piti lesio towa lite metine ili lele piti lapli oweli pepe, metine linutei lepe le lirpowo lolpepei, ‘Ki kaise tef nele, le ki ma ke nali kuluwo. Ye onom teingine asiepe il peiki.’ ");
INSERT INTO ong_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Metine nele lirpei lolo, ‘Ki kaisepe bulmakau pire eti plen poungo le ki ma ke keptalo kulwepe. Ye usaiki ke.’ ");
INSERT INTO ong_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nele lirpei lolo, ‘Ki nempis ye lepei kaisene moto, le il pal fei pepei so ki ma ke kolo.’ ");
INSERT INTO ong_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Metine piti lesio towa lepe, le nou le lirpowo metine ili lele lire men nange fei pepei. Yaitei lite winem lepe le onom kotu le le lirpowo metine piti lesio towa lele lepe, lirpowo lolpepei, ‘Naro frou e tisingu lipi re kumpu piti uf kumpu lepe le ye kesipe mete piti oweli yini nange naplei pepe, mete ire esi olpe, mete ire esi pa le mete piti lutepe olpe, kesipe yepi nou yau.’ ");
INSERT INTO ong_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Metine piti lesio towa lepe, le nou frou lau lirpowo metine ili lele lirpeiye, ‘Ili leiki, ki kingiepe il peiye wolo tulum ile wala lato yawi.’ ");
INSERT INTO ong_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Liso metine ili lepe le lirpowo metine lele liti lesio towa lele lepe, lirpowoye, ‘Naro e tisingu lipi re kumpu piti pe pinge towa yawi, le ye kesipe mete aptei pinki pau winem soma winem leiki ma fale liripe mete.’ ");
INSERT INTO ong_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ki kirpeiye, ‘Mete wuso kaptei il kinape pepe, nele lelpe re ma laplei oweli peiki lingitepe kolo olotei’.” ");
INSERT INTO ong_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mete wurutei pulsesi Jisas pepi pe. Le le weitei lirpepe lolpepei, ");
INSERT INTO ong_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Wuso minele lirpolo ma laule ki wolo le onom pinaulime nimou re yaitei mele kolo, le onom pinauline moto re eple pele kolo, le le onom pinaulipe ilim winkem re eri pele kolo, le le lotei re, le onom pinauli lotei kolo, metine fei lepe le ma fale lire metine piti lulteiki kolo. ");
INSERT INTO ong_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Metine ma lila moingi lele lotei watafei ki, le le lulteiki ki. Wuso olo, metine fei lepe ma lulteiki pato. ");
INSERT INTO ong_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wuso nele leise onposi lirpolo ma leila winem ulel lunwei le teplai yuwei. Le ma linu lifei kapi laptei lire era polomen le ma nampli lirepe lesio winem fei lepe le le ma retai era pepe, miso pire winem poungai lo olo. ");
INSERT INTO ong_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wuso olo, winem ulel lepe ma yali kolo wem le lapiri tiringou pite tef yaupe le mete yeflipi wuso puluwo lolpepe lepe, pe ma palwe oli piri. ");
INSERT INTO ong_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Pe ma pirpei polo, ‘metine lepei leila winem wolo le lesio yali kolo.’ ");
INSERT INTO ong_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wuso metine nele ili piti luntoluwepe mete, le liripe mete wurutei piti plolpo (10,000) pe pe piti ma plolpo pire metine nele ili. Metine nele ili lepe, le mete pele olo wurutei (20,000). Metine ili piti linu lepe, le ma linu lifei kapi laptei, wuso le lire mete pele pepe, pe miso pe plolpo pire metine ili nele lepe lo ma olo. ");
INSERT INTO ong_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wuso le lulwepe mete pele olo singe kolo, metine ili piti linu lepe le ma laisipe mete pele pilape il pe falowo metine ili nele lepe wem le wala lualo fiyen le pe ma pamtuwo il, peletei piti ma plolpo kolo oloye.” ");
INSERT INTO ong_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Fei Jisas lirpei il lapulu lolpepei, “Tisi niliyeye lepe, wuso minele leise le tounga pesipe men nange pele kolo olo, metine fei lepe le ma fale lire metine piti lulteiki kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tipe flou le teingi. Le wuso flou lele lepe le lelesesa, ye ma nou weisi tipe lepe fale teingi flou fei olomen? Olo, le oli pulouye. ");
INSERT INTO ong_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tipe flou ma teingi piti ire weisi tef lo pulmakau fes liti ma apiri oweli, le tipe pulou ma olesa, kali iri yawiye. Wuso ise mingim paitei ise ma yingitei.” ");
INSERT INTO ong_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wem nele mete wuru piti kapiepe mete era le mete wuru piti pingiepe il olpe, mete fei pepei pe pau pingitowo Jisas. ");
INSERT INTO ong_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mete piti Farasi le mete piti peptalo mete pire il lipi pite Moses, pe pirpei narwi potei pirpei polo, “Metine fei lepei le kesipe mete piti pire il olpe, kesipe laptei lotei le le liripe pepi paplei.” ");
INSERT INTO ong_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Liso Jisas lirpepe lire il kauro yuwei pepei, ");
INSERT INTO ong_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Wuso nele leise luntoluwepe sipsip wuru (100) le nele lelpe kotire, yaitei lite sipsip lepe ma lolomen? Le ma lusape wuru (99) pepe, lusape palei wolo pile, le le ma le lintatawo nele wuso kotire lepe, lintata le ma lerengawo wo. ");
INSERT INTO ong_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Wem le lerengawo, le ma onom teinginetei lasio le le ma lirari luwo eti yoli lele, ");
INSERT INTO ong_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","le le lila nou le winem. Leye lo le ma linape numuwi pele pire mete wuso pratei malfem piri pepe, linape pau panfinemple le le ma lirpepe lolpepei, ‘Sipsip wuso kotire lepe olo kerengawoye, le ki onom teinginetei kasio. Ku ma rautunemple miri.’ ");
INSERT INTO ong_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ki kirpeise tisi niliyeye so lepe, ririm pite yuwei pe enke teingipe pasiepe mete teingipe wuru (99) pepe, wolo wem metine niliyeye piti lingiepe il olpe le le weitei yofu, ririm pite yuwei ma enke teingipetei le pe ma rautunemple pasio.” ");
INSERT INTO ong_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Lo moto nenpe, wuso ne nesiepe era kumpu pene pire esi plen le plen (1 kina) le nenpe kumpu nualo kotire, moto nepe ne ma nolomen? Ne ma neletei weli nainu, notupu winem lene, le ne ma ninta noporotei, liye liye re ne ne ma nerengane fei, naltei yef. ");
INSERT INTO ong_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wem ne nerengane erau kumpu pene nepe, ne ma ninape numuwi re mete wuso pratei malfem pirine pepe, pe ma pau panfinemple le ne ma nirpepe nolpepei, ‘Ki onom teingine kasiene erau kumpu peiki wuso kotire nepe, olo ki nou kerenganeye. Ku ma rautunemple mirine.’ ");
INSERT INTO ong_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ki kirpeise, tisi niliyeye so lepe, wem metine niliyeye liti lingiepe il olpe wolo le weitei yofu, ririm pite yuwei pe ma enke teingipe re rautunemple pasio.” ");
INSERT INTO ong_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas nou lirpei lapwonou lolpepei, “Metine nele, le eple tuleingi tele twinges. ");
INSERT INTO ong_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Winke you lepe le lirpowo yaitei lolpepei, ‘Eiya, oweli men nange pouku pepe, ye karipe ki peiki waiki.’ Liso metine lepe le karipe oweli laptenge eple winge tele. ");
INSERT INTO ong_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Epli wem yaipiyeye kari wem wuso yaitei karipe oweli watenge tepe, winke you lepe le laptei oweli pele le mete paisepe le le kapi era yo fei, lusa uf lele le le laulo leye. Le le uf tef nele fiyintei le le liripe era pele keraitei, laplei oloye. ");
INSERT INTO ong_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Era olo liripe oloye. Leye lo wem piti oweli olotei fale uf tef fei lepe. Mete pite tef yefliye lepe, pe nimpi naplei olpetei le lainouwo lepe, le men re lesio kolo. ");
INSERT INTO ong_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Le so le lesio towa lite metine nele lite uf tef fei lepe, le metine lepe le laisi lainouwo lepe, laisi le luntoluwepe songou pele pratei tulum lele piti laptei songou pratei. ");
INSERT INTO ong_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Metine lainouwo lepe, le onposi lirpolo ma laplei manwei topungou wuso songou paplei pepe, wolo minemple re watowo oweli men piti laplei re kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Onomtei fei, lirpeiye ‘Mete piti pesio towa lite eiya leiki, pe oweli pelpe olo wuru piti paplei, le ki fei ratei lepei, ki ma ka kire nimpi. ");
INSERT INTO ong_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ki ma keilo nou ke eiya leiki le ki ma kirpowo kolpepei, ‘Eiya, ki tounga peteiye ire Ma Ili le ki kingiepe il olpe. ");
INSERT INTO ong_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ki olo teingi kolo piti ye ma inaiki irpolo ki ninge leiye. Olo, ye ma eiteiki kesio towa leiye watafei metine nele leiye liti lesio towa leiye lepe.’ ’ ");
INSERT INTO ong_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Le so leifale nou karowo yaitei lele le. “Metine lainouwo lepe, le wala lualo tisi fiyen wem yaitei lele luluwo. Yaitei onom manowotei liri ninge lele lepe, le le lantu le fale laungi ninge le le lenesesi mi. ");
INSERT INTO ong_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Fei ninge lepe lirpowo yaitei, ‘Eiya, ki tounga peteiye ire Ma Ili le ki kingiepe il olpe. Ki olo teingi kolo piti ye ma inaiki irpolo ki ninge leiye.’ ");
INSERT INTO ong_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wolo yaitei lele linape mete pele piti pesio towa lele pepe, le le lirpepe lolpepei, ‘Frou kali olol nele teingitei lepe le ise yalfowo lol. Kali yilye reltapowo lifei eti tupu lele le ise yafowo ire topungou. ");
INSERT INTO ong_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Leye lo ise ye kali bulmakau ninge teingitei lepe le ise yalowi falo, le ku ma mapli oweli maplei rautunemple. ");
INSERT INTO ong_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wusoli ninge leiki lepei, le olo laye wolo le fei wala namin ratei, le le kotire wolo ki nou kerengawo.’ Le pe so papli oweli paplei rautunemple. ");
INSERT INTO ong_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Wem fei lepe, ninge oru wala lato liom. Wem le lau lualo tisi malfem lire winem, le lingitepe wuso petesipe angelpuwi, le pe puroro pepe. ");
INSERT INTO ong_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Le linawo metine nele piti lesio towa lepe, le le leleteiye, ‘Fei pepei pato polomen?’ ");
INSERT INTO ong_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Le metine liti lesio towa lepe, le namti lirpowoye, ‘Winke leiye nou lau fale winem, le yaitei leiye kali bulmakau ninge teingitei lepe lali wusoli ninge olo nou lau fale teingi.’ ");
INSERT INTO ong_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Line oru lepe onom kotu oli le winem re linki le kolo olo, liso yaitei naro le malfefi piti ma linki le. ");
INSERT INTO ong_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wolo le nou lirpowo yaitei lele lolpepei, ‘Eringi wuru pepe, ki kesio towa watafei ki metine liti kesio towa leiye yawi, le ki wem nele re kinpim il peiye kolo olo. Menele fei linei so ye waiki lepe? Meme nele re waiki piti ma kapli oweli lipi le ki kiripe lainiyongou wane peiki mepi maplei re kolo oloye yawi. ");
INSERT INTO ong_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wolo ninge leiye lepei laplingou men nange peiye, liripe pe nimoure pite tisi, le wem le nou lau winem, ye alpo bulmakau ninge teingitei alio.’ ");
INSERT INTO ong_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Ninge leiki,’ yaitei namti lirpowo, ‘Ye wem oli oli ireiki ratei, le men nange yeflipiye ye peiye. ");
INSERT INTO ong_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wolo ku ma mapli oweli lipi maplei rautunemple le ku ma enke teingipe wusoli winke leiye, le olo laye wolo fei wala namin ratei, le olo kotireye wolo fei ku nou merengawo’.” ");
INSERT INTO ong_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas lirpepe pupam pele lolpepei, “Metine nele piti oweli yini, men nange pele wurutei, le laltei metine nele luntoluwepe pele lope. Le mete nemple pirpowo yaitei lite oweli yini, men nange pepe, pirpowo pirpolo metine wuso laltei luntoluwepe pepe, le laplowo lope era. ");
INSERT INTO ong_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Fei, yaitei lite oweli yini men nange wurutei pepe, le linawo metine wuso laltei luntoluwepe pepe, linawo linki le le le leletei lolpepei, ‘Il menemple so kingitepe pirpei pireye pepe? Aptei youti irpeiki ire towa leiye piti untoluwepe oweli yini men nange peiki wusoli ye ma esio towa lite untoluwepe men nange peiki kolo, oloye.’ ");
INSERT INTO ong_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Metine lepe lirpei lotei lolo, ‘Metine ili leiki ma laiteiki tani towa leikiye ko. Ki ma kolomen? Ki singe piti koflelei tef kolo olo, le ki ma topo oli piti kaituwepe mete. ");
INSERT INTO ong_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Fei ki kretai, ki ma kolomen soma wem ki kusa towa leiki, ki numuwi peiki pepe miso keteiki pilaiki pe winangou pelpe.’ ");
INSERT INTO ong_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Le so linape mete yeflipiye wuso utu pite metine ili lele patope pepe. Le leletei metine piti linu lepe, leletei lolpepei, ‘Utu piti metine ili leiki lepe, fei polomen so patoye pepe?’ ");
INSERT INTO ong_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Metine linu lepe le namti lirpei lolpepei, ‘Ki kali oliv tipe lire minki wuru (100).’ Fei metine piti luntoluwepe men nange pite metine ili lepe, le lirpowo metine linu wuso utu patowo pepe, lirpowo lolo, ‘Yousi peiye pepei, ifei aptei piti ilepe (50).’ ");
INSERT INTO ong_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Le nou leletei metine nele, ‘Le ye, utu polomen patoye?’ Metine wuso utu patowo lepe, le namti lirpei lolo, ‘Ki kali wit lire ufal wurutei (1,000).’ Fei metine piti luntoluwepe oweli men nange pepe lirpowoye, ‘Yousi peiye pepei, ifei aptei piti wuru taise (800).’ ");
INSERT INTO ong_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Metine piti luntoluwepe oweli yini men nange pepe, le linu onposi piti ma kane lotei le le so lempesi metine ili lele lirpolo utu pele wuso patope mete pepe olo kumpu, liso metine ili lepe le lirpolo ‘Ye metine liti retaitei le ye kani yotei.’ wusoli mete piti tef, pe pretaitei piti pailele potei wane le eple piti Ma Ili pele olo polpepe kolo.” ");
INSERT INTO ong_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Le Jisas nou lirpei lasiepe lolpepei, “Ki kirpeise, mole yini peisi piti tef lepei lepe, ise yiripe piti ma yailelepe mete nemple le pe ma fale pire numuwi peise. Ise yolpepe soma wem mole yini peise yalipe, Ma Ili ma keteise ye ratei uf teingi lele piti ratei yingi wem wem. ");
INSERT INTO ong_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Metine minele piti telpalo luntoluwo towa kumpu, towa ili re ma telpalo luntoluwo wolo metine minele wuso luntoluwo towa kumpu loporo kolo, towa ili re ma lirowo nele. ");
INSERT INTO ong_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Wuso mole yini peiye piti tef lepei, ye telpalo untoluwepe oporo kolo, ye olomen ma untoluwepe men teingipetei pite Ma Ili pele? Ma olo. ");
INSERT INTO ong_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Le wuso ye telpalo untoluwepe men nange pite metine nele oporo kolo, minele ma waiye menmen peiye yotei? Ma olo.” ");
INSERT INTO ong_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Metine piti lesio towa, le ma lesio towa lite moli twinges kolo olo. Le ma onom one liri nele le le ma kani onom lantowo nele. Le ma telpalo lesio towa lite moli nele lepe loporo, le le ma lire foringou lasio towa lite moli nele. Ye ma esio towa lite Ma Ili, le eti plen, ye esio towa liti kapi mole, ye ma esienge autuwonou kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mete piti Farasi pe pingitepe il pepei le pe palwe oli piri Jisas, wusoli pe mete piti enke puwope mole. ");
INSERT INTO ong_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisas lirpepe lolpepei, “Ise isotei so yingiepe pepe le mete pulise, pe pirpei polo ise yingiepe yoporo, wolo Ma Ili, le retape enke peise leinginim. Menemple wuso mete onposiepe pirpolo pe teingipetei pepe, Ma Ili lulwepe pe olpesa.” ");
INSERT INTO ong_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Il lipi pite Moses le il wuso mete emarengi sungoi paptei pepe, il pepe ise yingiepe yau yau fale wem Jon liti kaptetei, le fale leptalo il. Wem Jon fale leptalo il le le lau lau fale fei, ise yingitepe il teingipe pirpei piri wem Ma Ili ma luntoluwepe mete pele piti tef, le mete yeflipiye pire potei kilau piti ma pinki. ");
INSERT INTO ong_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wolo tef lire teplai yuwei ma telesesa, le il men kumputei wuso paitei il lipi pepe, nemple pelpe re miso pelesesa kolo olotei.” ");
INSERT INTO ong_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Metine minele wuso laisine moto pele ne tanio le le nou laisene nenpe, metine fei lepe, le metine piti laisepe nimoure lusasape. Le metine piti laisene moto wuso ninu naise munge nele wolo le lantu nepe, metine fei lingi laisene nepe, le metine piti lire ausi laisene moto pite metine nele.” ");
INSERT INTO ong_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Metine nele le oweli yini men nange pele wurutei, le lafo olongou teingipetei wuso lire mole lipi laisepe pepe, le epli wem oli oli, le lifei ratei loporotei. ");
INSERT INTO ong_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Metine nele le oweli yini nange nalei, le re ratei, nange lele Lasarus. Pape pirkilau poluwo le pe ma pila pe paltei lifei wingi pite metine wuso oweli yini wurutei pepe. ");
INSERT INTO ong_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lasarus onposi lirpolo ma laplei oweli flengi wuso metine oweli yini wurutei lepe, le laplei lifei poi le flengi pualolo pepe. Pelem re ma paule pungutape pape pite Lasarus. ");
INSERT INTO ong_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Metine oweli yini nange nalei lepe, wem le la ririm pite yuwei kali pila pe paltei lifei lire Abraham. Metine piti oweli yini wurutei pepe, le re la le pe paltei. ");
INSERT INTO ong_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Le le ratei tulum liti pila moingi le le lailolo lire moingi wuso falowo lepe. Le weitei luntoli le yuwei le le luluwo Abraham lifei fiyintei liye le Lasarus lifei malfem liri. ");
INSERT INTO ong_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Liso le lailo linawo Abraham lolpepei, ‘Mani Abraham, onom maneiki. Le ye aisi Lasarus le lalfo eti tunongo lele linge tipe le le kaltei noni leiki is wo, wusoli ki kila moingi ilitei kratei tulum oli welitei lepei.’ ");
INSERT INTO ong_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Wolo Abraham namti lirpowo lolpepei, ‘Paliyene leiki, ye onposi wem ye wala teingi ratei, ye kapi men nange teingipe le Lasarus kapi men nange olpe. Wolo fei, le rautu lotei lifei lepei, le ye ailolo ire flis re moingi. ");
INSERT INTO ong_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Le fei pepe poteteiye kolo olo, oi ili olo lato nimin karouku mireye ye, le minemple piti pratei lepei le pe pirpolo ma ponglo pe plen lepe wolo pe miso pe kolo, le ise minemple piti pirpolo ma ponglo pau lepei lepe, wolo pe re miso ponglo pau kolo.’ ");
INSERT INTO ong_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Metine piti oweli yini wurutei pepe, le namti lirpowo Abraham lolpepei, ‘Sou mani, ki keiteiye, ye aisi Lasarus le winem lite eiya leiki, ");
INSERT INTO ong_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ki ilim winkem peiki pire eti plen poungo, pe pratei, le ye ma aisi Lasarus le piti ma il polwepe soma pe re ma pau tulum lepei kolo olo, tulum oli liti pila moingi.’ ");
INSERT INTO ong_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham nou lirpowo lolpepei, ‘Il lipi pite Moses le il pite mete emarengi, il fei pepe miso pirpei il polwepe ilim winkem peiye ko.’ ");
INSERT INTO ong_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Le metine piti oweli yini wurutei lepe, le nou lirpowo Abraham lolpepei, ‘Il yaupe pepe ma kaniepe kolo olo. Metine nele wuso la lepe, le ma nou le falepe soma pe weite yefi.’ ");
INSERT INTO ong_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wolo Abraham lirpowo lolpepei, ‘Wuso pe pingitepe il lipi pite Moses le il pite mete emarengi, pe pingitepe kolo olo, metine piti la le le ma nou le lepe re, fei pepei re miso weisipe enke pelpe kolo olotei.” ");
INSERT INTO ong_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas lirpepe pupam pele lolpepei, “Menmen olpe ma fale pempesipe mete piti ma pualo tisi oli, wolo minemple wuso polpepe pepe, pe men olpe, moingi ili ma falepe. ");
INSERT INTO ong_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wuso pe paltei erau ili lultei ilyongo lite metine nele le pe piri leingalo peryai, metine fei lepe olo lila moingi kumpu. Le wuso metine nele lempesi nele kumpu fei lepei lualo tisi oli, metine fei lepe le ma lila moingi ilitei. ");
INSERT INTO ong_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ise ma kotopa isotei.” “Wuso line winke nele leise, le lingiepe il olpe, ise yirpeilawo. Le wuso le nou weitei onom, ise ma onposiepe il olpe pele kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Le wuso line winke lepe, epli niliyeye, le lingiepe il olpe lire leptaleise wem pire eti plen poungo te twinges (7), le wem fei pepe (7), le nou lau lirpeise lirpolo, ‘Ki onom one kire il olpe peiki,’ sou il olpe pele ise ma onposiepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Fei, pupam pepe pe pirpowo Apa Ili polpepei, “Ye ma weisipe enke pouku le ku ma mirkilau mulpope il peiye.” ");
INSERT INTO ong_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Apa Ili nou lirpepe lolpepei, “Wuso ise yulpope il kumputei watafei yumko tingeni, ise miso yirpowo nimpe piti lilape fouri teingipe piti maplelei pepe, ise miso yirpowo nimpe lepe yolpepei, ‘Ye kotu asi nalem le ye e fale ile peryai,’ le nimpe lepe ma lapteise mingim.” ");
INSERT INTO ong_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Wuso nele leise, le metine lele piti lesio towa lele, le wala le lalolowi tef lite liom, lo le le luntoluwepe sipsip. Wem le nou lau winem, ye ma irpowo irpolo, ‘Frou au ifei aplei oweli peiye.’ Ye ma irpowo olpepei lo ma olo? ");
INSERT INTO ong_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma olotei, wolo ye ma irpowo olpepei, ‘Apli oweli peiki, ye alfo olol nele muntuwepe olongou peiye le ye apwe oweli apteiki kinu kaplei wo, ye soma aplei peiye ingli.’ ");
INSERT INTO ong_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Metine leiye piti lesio towa leiye lepe, le lingiepe il peiye le ye ma onom teingine asio lo ma olo? ");
INSERT INTO ong_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Sou, ise re ma yolpepe. Wem ise kapi il piti ma yingiepe yesio towa menele le ise yingiepe, ise ma yirpei yolo, ‘Ku mete yaupe piti mesio towa le ku ma mesio towa louku.” ");
INSERT INTO ong_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas lingowo tisi piti ma le Jerusalem, le le le linge yeli lite Samaria re Galili pau pire nemple. ");
INSERT INTO ong_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wem Jisas wala so le fale uf nele kumpu, mete nemple pire eti plen le plen poungo (10), pe pau falowo. Pe pape olpe polwepe. Pe pile fiyen, ");
INSERT INTO ong_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","le pe pailo pirpei polo, “Jisas, ili louku, ye onom manouku.” ");
INSERT INTO ong_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisas lulwepe le le lirpepe lolpepei, “Ise ye falepe mete piti peptawio Ma Ili siye le ise kosape yire isotei.” Wem pe wala pe pualo tisi, pe nou fale teingipe. ");
INSERT INTO ong_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nele lelpe, wem le lulu lotei wuso nou fale teingi lepe, le nou le uf, lirkilau lirpepei leilala nange lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Le lire lotei lualo ratei ire yepe pite Jisas, le le lirpowo lire onom teingine pele. Metine lepe, le lite Samaria. ");
INSERT INTO ong_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Fei, Jisas lepleteiye, “Mete piti pire eti plen le plen poungo, pape olpe pautu taniepe le pe nou fale teingipe, wolo pe piti pire eti plen poungo le twinges te twinges pepe (9), pe pinei? ");
INSERT INTO ong_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Piti men ma metine lite uf mete nemple, le loteteiye nou lau lirpowo Ma Ili lire onom teingine pele?” ");
INSERT INTO ong_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Le Jisas lirpowo metine lepe lirpeiye, “Eilo ile le ye e, ye ulpope il pite Ma Ili le ye min so nou fale teingi lepe.” ");
INSERT INTO ong_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mete ilepe pite Farasi, pe peletei Jisas pire wem piti Ma Ili ma luntoluwepe mete pele piti tef, peletei pire wem men soma wem fei lepe fale. Jisas nou lirpepe lolpepei, “Wem piti Ma Ili ma luntoluwepe mete pele piti tef pepe, wem fei lepe ma fale wolo lutepe peise miso puluwo matufuwo kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Minele re miso lirpei lolo, ‘Yuntoli, le min lepei,’ lo ‘Le min liye.’ Ma olo, wusoli wem liti Ma Ili ma luntoluwepe mete pele pepe, wem fei lepe olo fale leingaloise nimin ye.” ");
INSERT INTO ong_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Leye lo le lirpepe pupam pele lolpepei, “Wem wala lato, wem ise ma onom fale yirpolo ise ma yuluwo epli wem nele lite Ninge lite Metine Wape, wolo ise ma yuluwo kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mete nemple ma pirpeise pirpolo, ‘Yuluwo, le min liye,’ lo ‘Yuluwo, le min lepei.’ Wolo ise ma naro yulsipe ye pato. ");
INSERT INTO ong_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Min watafei teplai nesi mil le teplai lini lile um ilo le le lau le fale um ilo lepe, Ninge liti Metine Wape re, epli wem lele ma fale lolpepe wem le lau. ");
INSERT INTO ong_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wolo le ma linu lila moingi ili le mete piti wem fei lepei lepe, pe re ma pinauli. ");
INSERT INTO ong_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Min watafei Noa, sungoi liye mete pinpim il pele, le fei re, pe ma polpepe piri Ninge lite Metine Wape. ");
INSERT INTO ong_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mete rautu nemple paplei oweli re tipeluwi. Pe paite nemple, pe pe fale epli wem piti Noa linki nimpe teingo le tipe ili fale mulfipe mete pepe, pa yalipeye. ");
INSERT INTO ong_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Min watafei wem liti Lot sungoi liye. Mete paplei oweli re tipeluwi, pe paptetei re paisesipe oweli, pe papiri oweli le pe peilape winangou. ");
INSERT INTO ong_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Epli wem piti Lot lusa uf Sodom le le le, Ma Ili liri weli lire era nemple weli nempi lingiepe leinginim, Ma Ili liripe pualo teplai yuwei pau watafei nef le weli re era weli pepe pe paplei nimoure mete pa yalipeye. ");
INSERT INTO ong_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Epli wem piti Ninge lite Metine Wape ma lau, wem lele ma fale lolpepe wem nimoure mete pire wouye pirpolo le wem teingi piti ma rautu nemple, wolo wem fei lepe pe ma pinlele potei re turwepe olpetei. ");
INSERT INTO ong_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Wem fei lepe, metine wuso lifei winem tupe yuwei lepe, le ma nou litipi le linki winem lele piti ma kapi men nange pele wuso pifei pepe lom? Ma olo. Min watafei metine piti lesio towa lile liom, le re ma nou le winem kolo oloye. ");
INSERT INTO ong_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ise onposiene moto pite Lot, ne nusa uf Sodom wolo nou weitei nuluwo uf le ne so naye. ");
INSERT INTO ong_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Metine minele lirpolo ma kane lotei, le ma lalingou nempi lele. Le minele piti lirowo nele lire nempi lele lotei lepe, le ma nou kali nempi lele. ");
INSERT INTO ong_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ki kirpeise, mulpou lepe mete twinges ma tetei tuwo poi nempleiyeye, wolo Ma Ili ma kali nele le nele ma lusa luwo. ");
INSERT INTO ong_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nimoure wiem ma malwewe wit mile, wolo Ma Ili ma kani nenpe le nenpe nepe ma lusane nile. ");
INSERT INTO ong_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mete twinges ma tile liom, wolo Ma Ili ma kali nele le nele ma lusa lile.” ");
INSERT INTO ong_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pupam pele peletei polpepei, “Apa Ili, fei pepei ma fale linei?” Jisas namti lirpepeye, “Tulum wuso metine la lato lepe, tulum lepe soma naflepem tuwalfengi pau pintarou.” ");
INSERT INTO ong_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Leye lo Jisas lirpepe lire il kauro yuwei pepei, leptalopiti ma pe wem oli oli peletei Ma Ili le pe pire foringou kolo olo. Jisas lirpepe lolpepei, ");
INSERT INTO ong_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Metine nele piti lifei lingitepe le le kapi il laptei lire moingi pite mete, le ratei uf nele kumpu. Le olo turuwo lire Ma Ili kolo, le mete piti tef re, le onposiepe lirkilau kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Le towa moto nenpe, ne re ratei uf elpesi lepe le ne wem oli oli naitire nilowo metine liti lingitepe re kapi il laptei lire moingi pelpe pepe. Ne naitire nile nirpopowo piti le ma kaniene, nirpowo nolpepei, “Mete eringi peiki pirpolo ma waiki moingi le ki kirpeiye piti ma kaneiki.” ");
INSERT INTO ong_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Metine piti lingitepe re kapi il laptei lire moingi pelpe pepe, wem wuru le linaulo piti ma kaniene moto fei nepe. Wolo onomtei, le lirpei lotei lolo, ‘Ki turiki kire Ma Ili kolo olo, lo mete piti tef re, ki onposiepe kirkilau kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Wolo towa moto nepei, ne naitire nile nirpeiki nire moingi lene le ki re so kire wilfingou kasiene ye ko. Men topo ki ma kanieneye le ki ma karine kantei, olo ma ne wem oli oli nau waiki moingi.” ");
INSERT INTO ong_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Le Apa Ili nou reresipe il lirpei lolo, “Ise yingitepe il pite metine oli piti kapi il laptei lire wanketei. ");
INSERT INTO ong_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Le mete wuso epli mulpou, pouti pirpowo Ma Ili pire moingi lelpe lepe, Ma Ili ma kapi il laptei lire mete pele le le ma kaniepe lo ma olo? Le ma frou kaniepe lo le wala ma kali wem laltei? ");
INSERT INTO ong_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ki kirpeise, le ma kapi il laptei liripe le le ma frou kaniepe. Wolo wem Ninge lite Metine Wape ma nou lau, le ma lerengape mete nemple wala pulpowo Ma Ili pratei tef lepei lo ma olo?” ");
INSERT INTO ong_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mete ilepe wuso onposi potei pirpolo pe olo teingipe tuwopou le pe ma tounga pesipe mete nemple wuru pepe, liso Jisas lirpepe lire il kauro yuwei pepei lirpei lolo, ");
INSERT INTO ong_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Mete twinges tunwei te winem lite Ma Ili, te piti ma teletei Ma Ili. Metine nele lite Farasi le nele, le metine piti kapiepe mete era. ");
INSERT INTO ong_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Metine lite Farasi lepe, le lile ire pele le le so leletei Ma Ili lolpepei, ‘Ki onom teingine kireye Ma Ili, ki kire filau kolo olo, ki kemtetei kempesipe mete nemple kolo olo, lo ki onom falepe nimoure nemple kolo olo, ki watafei mete wuru pepe kolo olo. Ki onom teingine kireye wusoli ki watafei metine piti kapiepe mete era pepe, ki watafei le lepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Epli wem pire eti plen poungo te twinges pepe (7), epli wem twinges pelpe, ki kaplei oweli kolo, kato yawi piti ma onposiye, le era wuso ki kapi pite towa wuso kesio lepe, era pepe ki kaptei tulum pire eti plen le plen poungo, le ki ma kapi pite tulum niliyeye pepe waiye’.” ");
INSERT INTO ong_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Wolo metine piti kapiepe mete era pepe, le lile fiyen le mati lele re ma leila le teplai yuwei kolo olo. Wolo le lile letesine onom popo pele le le lirpeiye, ‘Ma Ili, ye onom maneiki, ki metine oli piti kingiepe il olpe’.” ");
INSERT INTO ong_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ki kirpeise,” Jisas lirpepe lepe, “Metine piti kapiepe mete era pepe, Ma Ili lulpowo, le metine teingi wem le nou le winem, le metine liti Farasi lepe, le olo Ma Ili lulpowo kolo. Wusoli minemple pirpolo ma peilape nange pelpe potei, Ma Ili ma laptu laptei pe tef, le minemple wuso pire yape pepe, Ma Ili ma namti leilape nange pelpe pe yuwei.” ");
INSERT INTO ong_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mete nemple pilape eple pelpe pau paptowo Jisas piti le ma laptei esi pele puwope. Wolo pupam pulwepe polpepei, le pe pirpeilape. ");
INSERT INTO ong_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wolo Jisas linape eple kumpu pepe paule le le lirpei lolo, “Yusape eple kumpu pepe paule ki le ise il karipe pato, wusoli wem piti Ma Ili ma luntoluwepe mete pele, le ma luntoluwepe mete watafei eple kumpu pepei. ");
INSERT INTO ong_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ise ma retape fei pepei, minele wuso weitei lire ninge kumpu kolo olo, metine fei lepe Ma Ili ma luntoluwo ratei uf teingi lele kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Metine nele ili lite Juda, le leletei Jisas lolpepei, “Metine teingi liti eptalo mete, ki ma kesio towa men soma ki ma kali nempi liti ratei kingi wem wem lepe?” ");
INSERT INTO ong_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Piti men so ye inaiki irpolo ki teingi lepe?” Jisas namti leletei. Le Jisas lirpei lolo, “Metine minele re teingi kolo olo, Ma Ili loteteiye, le teingi. ");
INSERT INTO ong_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ye retape il lipi wuso pirpei polo, ‘Ye ma auleline moto pite metine nele kolo olo, ye ma etesi metine nele la kolo olo, ye ma ire ausi kolo, ye ma empesi metine nele kolo olo, ye ma aileleme nimou re yaitei meiye’.” ");
INSERT INTO ong_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Fei, metine lepe le namti lirpei lolo, “Il lipi yeflipiye pepe, ki kingiepe wem ki wala kumpu, kau kau fale fei.” ");
INSERT INTO ong_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Wem Jisas lingitepe il pepei, le lirpowo metine lepe lolpepei, “Menemple nempleiyeye fei pepei ye wala ma ingiepe. Men nange peiye, ye ma aptepe mete paisepe le ye kapi era watepe mete wuso pe oweli yini nange naplei pepe, le ye ma men nange peiye wurutei pifei yuwei. Le ye lo ye ma au ulteiki.” ");
INSERT INTO ong_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wolo wem metine lepe le lingitepe il pepei, le onom onetei wusoli oweli yini men nange pele olo wurutei. ");
INSERT INTO ong_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas luluwo wuso onom pele one nepe, le lirpeiye, “Mete piti oweli yini pelpe wurutei pepe, pe ma pire uru weli pinta tisi liti ma pinki pe uf teingi lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Metine piti oweli yini pele wurutei pepe, le ma lire uru weli linta tisi piti ma linki le uf teingi lite Ma Ili, wolo kamel, le miso lingi nample kumpu pite si liti piri pengleleipe olongou pepe.” ");
INSERT INTO ong_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mete wuso pingitowo Jisas lirpei lepe, pe peletei polpepei, “Le minemple soma Ma Ili kaniepe pepe?” ");
INSERT INTO ong_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisas nou lirpepeye, “Towa men mete miso pesio pire wanketei, le Ma Ili, le miso lesio towa men lire wanketei kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Leye lo Pita lirpei lolo, “Untoli ku musape men nange pouku le ku multeiye mau.” ");
INSERT INTO ong_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisas lirpepeye, “Iyo, le ki kirpeise pepei, minele wuso lusa winem lele lo moto pele lo ilim winkem lo nimou re yaitei lo eple pele, le lusape wusoli le onposi wem piti Ma Ili ma luntoluwepe mete pele, ");
INSERT INTO ong_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","metine fei lepe, wem le wala namin ratei, le ma kapi men nange wuru le wem le la, le ma nou leilo kali nempi nele liti ratei lingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas kesipe pupam wuso pire eti plen poungo le plen te twinges pepe (12), kesipe pe poteteiye pe le le lirpepe lolpepei, “Yingitei, ku ma me Jerusalem le il men nange wuso mete emarengi paptei pirpei pire Ninge lite Metine Wape lepe, fei pepe ma fale punkom. ");
INSERT INTO ong_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pe ma paltei le esi pite mete piti alpe nemple. Pe ma palwe oli pelesi, kelelawo le pe ma paruwo tunku. ");
INSERT INTO ong_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pe ma pire foiye petesi le pe ma petesi la, wolo epli wem twinges niliyeye kari, le Ma Ili ma nou leila namin ratei.” ");
INSERT INTO ong_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pupam pepe pe fupepletei pire men fei pepei, il pal pite il wuso Jisas lirpei pepe olo pato kotire wusoli Jisas kani onom naniepe, le pe pironom pire il wuso le lirpei pepe. ");
INSERT INTO ong_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas le fale malfem lire uf Jeriko, le metine nele lutepe pele olpe, le lifei tisi lunko lepe le le kaituwepe mete. ");
INSERT INTO ong_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wem le lingitepe mete wurutei wuso praltetei pau pe pepe, le lepleteiye, “Menemple so pepei?” ");
INSERT INTO ong_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Jisas lite Nasaret min laule lepei.” Pe namti pirpowo. ");
INSERT INTO ong_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Fei, le lailo lirpeiye, “Jisas, ninge paliyene lite Devit, ye onom maneiki.” ");
INSERT INTO ong_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mete piti pinuwo Jisas pe pepe, pe pirpei lawo le pe pirpowo piti ma pos lato. Wolo le lirkilau lailolo lirpeiye, “Ninge paliyene lite Devit, ye onom maneiki.” ");
INSERT INTO ong_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Liso Jisas weitei lile le le lirpepe piti ma pila metine lepe pau paltowo. Wem metine lepe lau fale malfem, Jisas leletei lolpepei, ");
INSERT INTO ong_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ye irpei piti ki ma kolomen kireye?” Le namti lirpei lolo, “Ili leiki, ki onposi piti ma nou kuntolili.” ");
INSERT INTO ong_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Leye lo Jisas lirpowo lolpepei, “Lutepe nenfaro le ye untolili, ye ulpope il pite Ma Ili le fei pepe min so kaneye nou fale teingi lepe.” ");
INSERT INTO ong_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Frou yo fei, metine lepe lutepe pele nenfaro le le nou luntolili, le le lulsi Jisas, onom teingine le le leilala nange lite Ma Ili. Wem mete wurutei pepe pe pulwepe menmen fei pepei, pe yeflipiye peila nange lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas laule linki lifei uf Jeriko. ");
INSERT INTO ong_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Le metine nele nange lele Sakias, ratei uf Jeriko lepe, le yini wurutei. Le lesio towa lele piti linuwepe mete piti kapiepe era piti watepe mete lipi piti Rom. ");
INSERT INTO ong_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sakias onom natowo Jisas ma luluwo matufuwo, wolo le kumpu kurautei le mete nimoure wurutei pile popopowo. ");
INSERT INTO ong_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Le so lantu linu le lunwei lifei ifau lile tisi piti ma lifei luluwo Jisas loporo, wusoli Jisas re ma linge tisi lepe le. ");
INSERT INTO ong_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wem Jisas le fale ifau pau leila oru luluwo Sakias lifei ifau yuwei lepe le lirpowo ye “Sakias itipi frou, ki fei ma ke winem leiye.” ");
INSERT INTO ong_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Fei Sakias lingitei lolpepei le onom teingineteiye. Litipi frou lau kesi Jisas liripe pepi pe winem lele pe ye. ");
INSERT INTO ong_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nimoure mete re puluwo fei lolpepei pe enke re olpe, pirpei narwi nempleiye “Liye, le lifei winem liti metine oli.” ");
INSERT INTO ong_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wolo Sakias leifale lile lirpowo Jisas ye, “Apa leiki, ingiteiki, ki ma kapi mole, yini ilepe peiki watepe mete wuso pe mole, yini re olo pepe. Le mete wuso kinu kempesipe le ki kapiepe mole lipi pelpe yaupe, ki ma nou watepe pire wem twinges te twinges.” ");
INSERT INTO ong_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisas lirpowo Sakias ye, “Fei, iripe ratei winem lepei yerengawo tisi liti ratei yingi wem wem. Sakias lepei re le ninge paliene liti mani louku Abraham. ");
INSERT INTO ong_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Wusoli Ninge liti Metine Wape laule piti lintape kesipe mete wuso pratei olpe, le le ma laptei pingio tisi teingi liti pratei poporo pingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wem mete wala pingitepe il pepei, Jisas nou reresipe il lirpepe lire il nemple kauro yuwei. Jisas le fale malfem lire Jerusalem le mete wuso pulsesi pe pepe, pe onposi pirpolo wem olo lau lire malfemye piti Ma Ili ma luntoluwepe mete pele piti tef, le singe pite Ma Ili pele ma fale alepe nimin. ");
INSERT INTO ong_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Liso Jisas lirpei lolpepei, “Metine nele, yaitei lele le metine ili piti luntoluwepe mete, ninge lele lepe le le uf tef nele lato fiyintei piti ma mete pite tef fei lepe pe ma paltei fale lire metine ili piti luntoluwepe mete, le ye lo le soma nou lau. ");
INSERT INTO ong_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Le so linu linape mete pele piti pesio towa lele, pe pire eti plen le plen poungo (10). Pe niliyeye niliyeye, le watepe era lipi (400 kina), le le lirpepe lolpepei, ‘Wem ki ke kato, ise ma yiripe era pepei yesio towa.’ ");
INSERT INTO ong_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wolo mete pele pite uf tef lele, pe enke olpe pasio le pe so paisipe mete nemple pilape il pingowo pe piti ma pirpei polo, ‘Olo, metine lepe ku minauli piti ma fale lire metine ili piti luntoluku’.” ");
INSERT INTO ong_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Metine lepe, pe paltei fale lire metine iliye, paltei fei, le so nou lau. Leye lo le linape mete pele piti pesio towa lele, pe wuso le watepe era fi fi piti pe ma piripe pesio towa pepe. Le linape piti ma lulwepe waipiti pe piripe era fei pepe, piripe pesio towa le pe nou kapi nemple paptei papwonou lo olo. ");
INSERT INTO ong_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Metine piti linu lepe, le lau fale le le lirpei lolo, ‘Era (400 kina) wuso ye waiki pepe, ki kiripe kesio towa le ki nou kapi nemple lipi (4000 kina) kaptei kapwonou.’ ");
INSERT INTO ong_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Metine ili lele lepe, le lirpowoye, ‘Teingipe, ye metine teingi piti esio towa. Ye telpalo untoluwepe men kumpu fei polpepei, le ki fei ma keiteiye untoluwepe uf lipi pire eti plen le plen poungo (10).’ ");
INSERT INTO ong_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Metine nele piti lesio towa lepe, le luwowo tounga piti linu lepe, le linki le lirpei lolo, ‘Ili leiki, era (400 kina) wuso waiki pepe, ki kiripe kesio towa le ki kapi nemple yeflipi (2000 kina) kaptei kapwonou.’ ");
INSERT INTO ong_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Metine lepei, metine ili lele lepe lirpowo lolpepei, ‘Ye ma untoluwepe uf lipi pire eti plen poungo (5).’ ");
INSERT INTO ong_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Metine nele piti lesio towa lepe, le linki le lirpowo metine ili lepe, lirpei lolo, ‘Ili leiki, era (400 kina) peiye pepe min so pepei. Ki kire ranguwom yalpe weisipe le ki kaplingi puwo. ");
INSERT INTO ong_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ki turiki kireye wusoli ye metine piti ire il singe. Menmen peiye kolo, wolo ye kapi le oweli ye apiri kolo, wolo ye kotuwepe.’ ");
INSERT INTO ong_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Metine ili lele namti lirpowo lolpepei, ‘Ye metine oli, il peiye yotei ma ki kapi kaptei kireye. Ye retai ki metine piti kire il singe le menmen peiki kolo wolo ki kapi, le oweli ki kapiri kolo, wolo ki kotuwepe. ");
INSERT INTO ong_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ye aptei era peiki puwo benk ko. Le wem ki nou kau, ki ma nou kapi era peiki pepe le benk ma waiki nemple kaptei kapwonou.’ ");
INSERT INTO ong_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Leye lo metine ili lepe le lirpepe mete wuso pile pepe, lirpeiye, ‘Kapi era (400 kina) pepe tanio le ise watowo metine piti lesiepe era lipi (4000 kina) pepe.’ ");
INSERT INTO ong_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Le pe pirpowo metine ili lepe pirpolo, ‘Ili louku, era lipi (4000 kina) le lesiepe fei.’ ");
INSERT INTO ong_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wolo metine ili lepe le namti lirpepe lolpepei, ‘Ki kirpeise, minele piti lesiepe menmen kumpu, le ma nou kapi nemple laptei lapwonou. Le minele piti lesiepe menmen kumpu kolo olo, men kumpu wuso le onposi lirpolo le lesiepe pepe re wolo Ma Ili ma kapi tanio. ");
INSERT INTO ong_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Le fei, mete eringi peiki wuso pinauleiki pirpolo ki ma fale kire metine ili lelpe kolo lepe, mete eringi peiki pepe, ise kesipe yilape yau lepei le is yetesipe pa pratei onom peiki lepei’.” ");
INSERT INTO ong_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas lirpei il fei pepei re fei, le fale linuwepe le Jerusalem. ");
INSERT INTO ong_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wem le le fale malfem lire uf Betfage re Betani, pifei tef lupai alo liti nimpe oliv pile, le laisinge pupam twinges tinuwo te. ");
INSERT INTO ong_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Le lirpenge lamtenge lolpepei, “Rounge ye uf lato linuse lepe, le wem ise rounge yinki ye, ise rounge ma yuluwo donki ninge nele wala yefli le pe topuwo laitei. Rounge nenfari le ise kesi yila yau lepei. ");
INSERT INTO ong_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wuso metine minele leiteise rounge lirpolo, Piti men ise rounge nenfari?’ Rounge yirpei yolo, ‘Apa Ili lirpei piti ma wila we watowo’.” ");
INSERT INTO ong_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Fei, pupam tepe rounge te fale le te tulwepe men nange pepe fale pingiepe il wuso Jisas linu lirpenge tepe. ");
INSERT INTO ong_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wem te wala nenfari donki ninge lepe, yaire pite donki lepe pe poutetei pirpeiye, “Piti men so ise rounge nenfari?” ");
INSERT INTO ong_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Apa Ili lirpei piti ma kesi wila we waltowo,” te rounge namti tirpepe. ");
INSERT INTO ong_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Le te kesi donki ninge lepe tila te taltowo Jisas. Leye lo te rounge tiripe olongou pelnge puwo donki tounga le te kanowo Jisas longlo lifei. ");
INSERT INTO ong_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wem Jisas lifei donki yuwei le le le, mete pepe pe kesipe olongou pelpe piti pafo pifei yuwei pepe, pe kesipe paptetei pato pinge tisi. ");
INSERT INTO ong_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wem Jisas le fale malfem lire Jerusalem, le piti ma litipi orou pite tef lupai linpei lifei liti nimpe oliv pile, Jisas le fale piti ma litipi tisi orou lepe le mete wurutei wuso pulsesi pe pepe, pe pailolo pirpei pire enke teingipe pelpe pasio Ma Ili le pe pirkilau peilala nange lele, le pe rautuwo pire men nange wuso laptei fale le pe pulwepe pepe. ");
INSERT INTO ong_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Ma Ili lailolowo metine ili wuso laule lire nange lite Ma Ili. Ma Ili wauku onom malye pele le ku meila nange lite Ma Ili yuweitei.” ");
INSERT INTO ong_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Leye lo mete ilepe pite Farasi wuso pile peingalope mete wurutei nimin lepe pe pirpowo Jisas polpepei, “Metine liti eptalo mete pepe, ye irpepe mete peiye piti pulteiye pepe, irpepe piti pe ma pos pato.” ");
INSERT INTO ong_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisas namti lirpepe lolpepei, “Wuso mete pepei pe pos pato, ki kirpeise era pepei ma potei peifale pailolo.” ");
INSERT INTO ong_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas le lire uf ili Jerusalem malfem le wem le luluwo uf ili lepe, le loutuwo, wusoli le onom manepe mete wuso pratei lepe, ");
INSERT INTO ong_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","le le lirpei lolo, “Wuso ye fei retawo tisi liti ma kaneiye ratei teingi, pepe ma pato poporo. Wolo ye fei ma uluwo kolo oloye. ");
INSERT INTO ong_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Epli wem wala pato wem mete eringi peiye ma fale neineye kotuye, tisi men lato yawi ma mete peiye pingowo pantutu pe tani, olo. Le mete eringi peiye pepe pe ma pirkilau plolpo pinge plen plen re le pe ma kere pato kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pe ma pireye nele olitei le mete peiye re ma posiepe pa yalipeye. Era nemple re ma pifei nemple toungalem kolo olo, ma paptutu pire nemple, pualo pratei pinge tef, wusoli wem wuso Ma Ili laule piti ma kaneiye, wolo ye uluwo matufuwo ire wem fei lepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas linki le winem lite Ma Ili le le laptu mete wuso paptetei re paisesipe oweli pepe, ");
INSERT INTO ong_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","le le lirpepe lolpepei, “Il paptei paitei yousi pirpei pire Ma Ili wuso lirpei lolo, ‘Winem leiki, le winem liti mete ma pifei peletei Ma Ili.’ Wolo ise weisi fale lire winem liti mete wuso pire ausi pepe, pe ma pau kotire pifei.” ");
INSERT INTO ong_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Eple wem oli oli, Jisas leptalo il lifei winem lite Ma Ili. Mete piti pinuwepe peptawio Ma Ili siye, pe pire mete piti peptalo mete pire il lipi pite Moses le mete lipi pite pinuwepe mete pite Jerusalem pepe, pe pirpolo ma petesi Jisas la. ");
INSERT INTO ong_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wolo pe perengawo tisi nele piti ma polpepe kolo olo, wusoli mete yeflipiye onom kere piti ma pifei pingitowo lirpepei le il nemple pele re ma kere yaupe kolo. ");
INSERT INTO ong_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Epli wem nele, wem Jisas lifei winem lite Ma Ili, leptalo mete le le leptalo il teingipe pite Ma Ili. Le mete piti pinuwepe peptawio Ma Ili siye, le mete piti peptalo mete pire il lipi pite Moses, pe piripe mete lipi piti pinuwepe mete pite Jerusalem pepe, pe paule, ");
INSERT INTO ong_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","le pe pirpowo Jisas polpepei, “Ye irpouku, minemple waiye il piti ye ma aptu mete wuso paptetei re paisesipe oweli pepe, minemple waiye il piti ye ma aptu tani winem lite Ma Ili lepe?” ");
INSERT INTO ong_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jisas namti lirpepeye, “Fei ki ma namti keiteise, ise yirpeiki, ");
INSERT INTO ong_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","minemple pirpowo Jon piti ma kaptetei mete, Ma Ili lo mete piti tef?” ");
INSERT INTO ong_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pe pire il pura nempleiye, “Ku ma mirpei il men? Wuso ku mirpei molo, ‘Ma Ili lirpowo’, le ma leitouku lirpolo, ‘Piti men ise yulpowo Jon kolo?’ ");
INSERT INTO ong_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Le wuso ku mirpei molo ‘Mete piti tef pirpowo’, mete wurutei pepei, pe yeflipiye ma kapi era posuku wusoli pe pulpowo Jon, le metine nimou.” ");
INSERT INTO ong_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Liso pe namti pirpowo Jisas polpepei, “Olo, ku mironom mire minemple so pe watowo Jon il piti ma kaptetei mete pepe.” ");
INSERT INTO ong_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Le Jisas lirpepeye, “Ki re ma kirpeise kolo, kirpeise kire minemple so pe waiki il piti ki ma kaptu mete tani winem lite Ma Ili lepe, olo ki ma kirpeise kolo.” ");
INSERT INTO ong_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Leye lo Jisas lirpepe mete lire il kauro yuwei pepei, “Metine nele lari liom wain, le laltei liom wain lepe le esi pite mete nemple piti pe ma puntoluwo le pe ma paise era kumpu kumpu pire kari wain fouri wuso pe ma kareri lepe. Leye lo yaitei lite liom wain lepe, le lusa uf lele le le ma le lato nele fiyen wem ulel. ");
INSERT INTO ong_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wem liti mete wuso puntoluwo liom wain lepe, pe ma kari wain fouri, wem fei lepe yaitei lite liom wain lepe, le laisi metine nele lele piti lesio towa lele, le laisi le piti ma kali wain wuso mete piti puntoluwo liom lepe, pe ma kari paltowo yaitei lite liom lepe. Wolo mete piti puntoluwo liom lepe, pe posio metine wuso yaitei lite liom laisi lau lepe, posio le pe paltei nou lire esi le yawiye. ");
INSERT INTO ong_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yaitei liti liom lepe le nou laisi metine nele lele piti lesio towa lele, laisi le wolo mete piti puntoluwo liom lepe, posio le re le pe pirowo oli kete topo oli paltowo, le pe nou paisi lire esi le yawiye. ");
INSERT INTO ong_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yaitei lite liom lepe le nou laisi nele piti lire eti twinges le niliyeye lepe, wolo le re so mete piti puntoluwo liom pepe, pe posio le pe piri le towa yawi. ");
INSERT INTO ong_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Leye lo yaitei lite liom wain lepe lirpeiye, ‘Ki ma kolomen? Sou, ki ma kaisi ninge nange leikitei, kaisi, le le pe miso pailolowo.’ ");
INSERT INTO ong_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wolo wem mete piti puntoluwo liom wain pepe, pe puluwo ninge lepe, pe pirpei nempleiye, ‘Yaitei lite liom lepe, ninge lele min so lepei. Ku metesi la le liom lepei ku ma kali mire loukuye.’ ");
INSERT INTO ong_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Le pe so piri naro le yawi tani liom wain lepe le pe petesi la.” “Le yaitei lite liom wain lepe, le ma lolomen liripe mete piti puntoluwo liom pepe?” Jisas lepletei. ");
INSERT INTO ong_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Yaitei lite liom wain lepe le ma lau le le ma letesipe mete pepe pa, le liom lepe le ma kali watepe mete nemple puntoluwo.” Wem mete pepe pe pingitepe il pepei, pe pirpeiye, “Olo fei pepei miso fale kolo.” ");
INSERT INTO ong_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisas lulwepe le le lepletei lolpepei, “Le il fei pepei wuso paptei paitei yousi pepe, il pal pirpei polomen? Wem pe paptei pirpei polo, ‘Nimpe lotei wuso mete piti peilape winangou pe pinauli lepe, wolo le nimpe teingitei.’ ");
INSERT INTO ong_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Metine minele wuso lualo letesi nimpe fei lepe, metine lepe ma laututu lire kumpu kumpu. Le wuso nimpe lepe le lualo letesi metine nele, le ma raltipi lire tuwiye.” ");
INSERT INTO ong_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mete piti peptalo mete pire il lipi pite Moses le mete piti pinuwepe peptawio Ma Ili siye, pe pinta tisi piti ma penglei Jisas wem fei lepeye, wusoli pe pretai le lirpei il kauro yuwei pepe, le lirim lirpei liripe pe, wolo pe turwepe piripe mete. ");
INSERT INTO ong_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pe so lusye patotowo, puntoli piti wem nele loporotei pe ma penglei. Pe paplingi era watepe mete nemple piti pe ma pemtetei pirpolo pe mete teingipe le pe paisipe mete pepe pe peletetei Jisas piti ma pempesi lualo tisi oli le pe ma penglei paltei le esi pite metine ili piti luntoluwepe. ");
INSERT INTO ong_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mete piti prasipe lus pepe, pe pirpowo Jisas polpepei, “Ye metine liti eptalo mete, ku mretai molpepei, il peiye piti irpei le piti ye eptalo, pe tuwopou. Ku mretai molpepei, ye onposio metine lire towa lele piti lesio kolo olo, wolo ye eptalo il punkom ire wai lite Ma Ili lele piti kaniepe mete. ");
INSERT INTO ong_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ye irpouku, wem ku maisipe era pe moli ili lite Rom, ku yaruwepe il lipi pite Moses lo olo?” ");
INSERT INTO ong_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Wolo Jisas lulwepe wuso pe pempesesi lepe, le le so lirpepe lolpepei, ");
INSERT INTO ong_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kosaiki erau nele, mati re nange pite minemple so min pipaitei?” “Pe pite moli ili lite Rom.” Pe namti pirpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Liso Jisas lirpepe lolpepei, “Menemple pite moli ili lite Rom le pele, ise ma pele watowo, le menemple pite Ma Ili pele, ise ma watowo Ma Ili pele.” ");
INSERT INTO ong_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jisas lirpei il men wanketei ma pe penglei pile lutepe pite mete wuru wuso pile pepe, olo, le lirpei poporotei. Le mete wuso pemtetei peletei pepe pe pinlele potei pire il pele le pe pos pile yaupeye. ");
INSERT INTO ong_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mete ilepe pite Sadyusi, pe pau falowo Jisas. (‘Pe mete piti pirpei polo mete wuso pa pepe, pe ma nou peilo kolo.’) Pe peletei Jisas polpepei, ");
INSERT INTO ong_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ye metine liti eptalo mete, Moses laptouku lope il lipi pepei lirpei lolo, ‘Wuso metine la taniene moto, le eple olo, winke lite metine wuso la lepe, le ma namti laisene towa moto nepe, le me roum soma milape eple pite metine wuso la lepe.’ ");
INSERT INTO ong_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sungoi ilim winkem nemple, pe pire eti plen poungo te twinges, pe pratei lepei. Line oru lepe le laisene moto wolo lilape eple kolo, la yawiye. ");
INSERT INTO ong_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Leye lo winke piti luwol lepe le namti laisene moto nepe, ");
INSERT INTO ong_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","leye lo winke nele piti nimin. Pe yeflipiye pa yaupeye, eple olo pilape kolo. ");
INSERT INTO ong_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Fei, moto nepe ne na ningli. ");
INSERT INTO ong_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Le piti mete wuso pa pepe, wuso pe ma nou peilo, moto fei nepe ne ma pite minele lelpe? Pe pire eti plen poungo te twinges, pe yeflipiye wuso paisene nepe.” ");
INSERT INTO ong_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisas namti lirpepeye, “Nimoure mete re piti wem fei lepei lepe, pe paitenemple. ");
INSERT INTO ong_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wolo nimoure mete wuso pa le Ma Ili nou leilape piti ma nou nampir pratei pepe, pe ma paitenemple kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pe ma fale watafei ririm pite yuwei pepe le pe ma pa kolo olo. Pe eple pite Ma Ili pele, wuso pe pa wolo Ma Ili nou leilape. ");
INSERT INTO ong_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Le Moses kosaise alepe nimin lolpepei, mete wuso pa pepe, Ma Ili nou leilape nampir pratei. Il paitei yousi wuso pirpei pire weli wuso loli nimpe natungo lepe, le lirpei lire il lirpolo, ‘Le Ma Ili lite Abraham, le Ma Ili lite Aisak, le le Ma Ili lite Jekop.’ ");
INSERT INTO ong_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Fei pepei pato polpepei, mete paye wolo pe pa pelengi kolo olo, wusoli Ma Ili lirpei le Ma Ili lelpe. Wuso pe pa pelengi le ma wala Ma Ili lelpe kolo. Wolo le lirpei le wala Ma Ili lite pe, leso ku ma retai mete wuso pa pe ma nou peilo.” ");
INSERT INTO ong_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mete ilepe piti peptalo mete pire il lipi pite Moses pepe, pe nempe nemi pirpeiye, “Metine liti eptalo mete, ye irpei il teingipe poporotei.” ");
INSERT INTO ong_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Le minemple re nou peletei pire il men re kolo, oloye. ");
INSERT INTO ong_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisas lirpepe lolpepei, “Polomen so pe pirpei polo Krais, le ninge palyene lite Devit? ");
INSERT INTO ong_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Devit lotei laptei il lirpei paitei yousi pite Sam, lirpei lolo, ‘Ma Ili lirpowo Ili leiki, ifei etei tilpi leiki lepei, ");
INSERT INTO ong_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ungari wem ki ma kaptei mete eringi peiye pratei ire yepe peiye tef.’ ");
INSERT INTO ong_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit linawo le ‘Ili’, le polomen ma Krais le ninge palyene lite Devit?” ");
INSERT INTO ong_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wem mete yeflipiye pile pingitowo, le lirpepe pupam pele lolpepei, ");
INSERT INTO ong_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ise kotopa isotei yire mete piti peptalo mete pire il lipi pite Moses. Pe pirpolo ma pafo olongou ulepe pelpe le pe pilele pau pe, le pe onom puwope mete wuso pratei tulum liti paptetei re paisesipe oweli pepe, pe onom puwope piti pe ma peisipe poporo. Pe ma keiniepe tulum teingipe piti pifei angli pal, le oweli lipi re, pe ma pompetepe tulum teingipe. ");
INSERT INTO ong_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pe mete piti pirkilau weisipe towa nimoure enke le pe pire ausi kapiepe men nange pelpe piti pifei winangou pelpe, leye lo pe rautu potei wem pe pire il ulepe peletei Ma Ili. Mete fei polpepei pepe, pe ma pila moingi ilitei.” ");
INSERT INTO ong_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas luntoli leinenei lau le le le lulwepe mete wuso pe oweli yini pelpe wurutei pepe, le le lulwepe pe pafofo era pelpe piti paptei watowo Ma Ili le pe pafo ufau wuso lultei winem lite Ma Ili lepe. ");
INSERT INTO ong_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Le le luwene towa moto nenpe, ne oweli yini nange nanei, ne ne namfo era kumpu wiem mautile ufau lite winem lite Ma Ili lepe. ");
INSERT INTO ong_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Fei, Jisas lirpeiye, “Ki kirpeise punkom, towa moto nepei, ne oweli yini nange nanei wolo ne nafo era lipitei ninuwepe pe yeflipi pepe. ");
INSERT INTO ong_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mete nemple yeflipi pepe, pe esi papo mole ilepe pelpe pratei le pe pilape ilepe pau paptei watowo Ma Ili, wolo ne mole yini nange nanei, era kumpu mene piti ma nuntoli notei wolo ne namwe watowo Ma Ili yalimeye.” ");
INSERT INTO ong_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pupam ilepe pele pirpei piri winem lite Ma Ili lepe, yafei pirpolo pe pire era teingipetei piripe peila winem lepe, le oweli re yini men nange wuso paptei watowo Ma Ili lepe, pe paptei pifei winem lepe, le pe pirowo yini pailolowotei. Le Jisas lirpei lolo, ");
INSERT INTO ong_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Men nange yeflipiye wuso yulwepe pepei pepe, wem lele wala lato, ma wem fei lepe, erau nele nele re ma lifei tulum lele lom? Olo, ma piripe yeflipiye pualo pratei tef.” ");
INSERT INTO ong_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Fei, pe peleteiye, “Ye metine liti eptalo mete pepe, wem liti men soma fei pepei fale? Le menele ma linu fale kosauku lire wem piti moingi lepe ma fale lepe?” ");
INSERT INTO ong_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisas lirpeiye, “Kotopa isotei. Ise ma yusape pempeteise kolo olo. Wusoli mete wuru ma pemtetei paule pire nange leiki pirpei polo, ‘Ki so le lepe,’ le pe ma pirpei polo, ‘Wem olo lau lire malfemye.’ Wolo ise ma yulsipe kolo. ");
INSERT INTO ong_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ise ma turise kolo wem ise yingitepe plolpo le mete wai nemple moingi, menmen fei pepei ma pinu fale, wolo pe ma kosaise pire wem malfem piti ki ma nou kau lepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Le nou reresipe lirpei lolpepei, “Mete pite uf tef nele ma plolpo piripe pite uf tef nele, le mete pite alpe nele ma peifale posiepe piti alpe nele. ");
INSERT INTO ong_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Maiyene lipi ma falele, oweli ma pelengi, le pape re kainu olpe ma falepe mete liye liye re pe, le menmen olpetei ma fale paitei teplai yuwei. ");
INSERT INTO ong_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wolo moingi men nange fei pepei pe wala ma fale kolo, le pe ma pinu pengleise re posise wo. Pe ma keteise pilaise ye angli pal piti ma kapi il paptei pireise le pe ma peiteise yifei winem oli. Pe ma keteise pilaise ye falepe moli lipi lipi wusoli ise yirpei nomnaipe yire nange leiki. ");
INSERT INTO ong_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Wem fei lepe, le wem loporo piti ise ma yirpei nomnaipe yire nange leiki. ");
INSERT INTO ong_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Wem pe keteise pilaise ye piti ma kapi il paptei pireise, ise ma yinu onposiepe il men piti ma namti yirpepe yolomen re kolo olo, ");
INSERT INTO ong_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","wusoli ki miso waise il re onom nire wuru le mete eringi peise ma weiteise lope kolo olo, lo il wuso yirpei pepe re, pe ma pire yef pasiepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Emare yaire peise ma peiteise ye esi pite mete eringi peise, ilim winkem, ilepe peise piti teluwi alpe niliyeye le numuwi peise, pe ma paptei ilepe peise ya. ");
INSERT INTO ong_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mete yeflipiye ma enke kotu pireise wusoli ise pupam peiki. ");
INSERT INTO ong_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wolo Ma Ili onposisetei, le eri wuso poli falongou peise pepe, oru nenpe re miso kotire kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ise yile singe wusoli tisi fei lepe soma kaneise pepe.” ");
INSERT INTO ong_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Wem ise yulwepe mete piti plolpo fale neinowo Jerusalem, ise ma retai wem lire malfem liti pe ma pirowo nele. ");
INSERT INTO ong_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Leye lo mete piti pratei Judia pepe, pe ma pantutu pe tef lupai linpei lifefei liye pe, le pe piti pratei uf ili Jerusalem lepe, pe re ma pusa, le pe pe. Le pe piti pratei pinge liom re pepe, pe ma pe uf ili lepe kolo oloye. ");
INSERT INTO ong_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Epli wem fei pepe, pe wem piti moingi ma falowo uf ili lepe, le il wuso paitei yousi pepe, pe ma fale punkom. ");
INSERT INTO ong_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wem fei lepe ma olitei liti nimoure pire yefi le emare pire eple kumpu wala paplei nimer. Moingi ilitei ma falowo tef lepei le mete pepei, pe ma pingitene onom flis pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mete ilepe ma pa pire werau, le ilepe ma topwepe pilape pe uf tef nemple, le mete pite alpe nemple, pe ma kali Jerusalem piri lelpe pe pe ma fale wem Ma Ili ma nou kali taniepe.” ");
INSERT INTO ong_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Menmen ma fale paitei epli, ane re tauri. Tef lepei, mete pite uf tef liye liye re, pe yeflipiye ma pinlele potei re fupepletetei nangeye, turwepe pire peryai wuso ma lirkilau loungongo le ipli re minu pireri lepe. ");
INSERT INTO ong_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wem moingi lepe fale linge tef ili yefliye, mete ma turwepe le lus pelpe ma peinei le pe ma pualo, wusoli men nange piti paitei teplai yuwei, pe ma weitetei re piyoyo. ");
INSERT INTO ong_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Leye lo Ninge lite Metine Wape ma laptu fale alepe nimin luwowo nopom lau lire singe lipi pele. ");
INSERT INTO ong_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wem men nange fei pepei fale, yeifale yile le ise yeilape falongou peise pe yuwei, wusoli wem olo lau lire malfemye piti Ma Ili ma luntoluwepe mete pele.” ");
INSERT INTO ong_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Leye lo Jisas lirpepe lire il kauro yuwei pepei lirpepe lolo, “Ise onposio wengle. ");
INSERT INTO ong_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wem wengle ario lepe, lus pautu le upou ma falele, ise miso retai le wem lire malfem piti epli ma loli. ");
INSERT INTO ong_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Min polpepei so wem ise yulwepe men nange fei pepe fale, ise miso retai le wem lire malfem piti Ma Ili ma luntoluwepe mete pele. ");
INSERT INTO ong_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ki kirpeise punkom, moingi men nange fei pepei ma pinu fale wo soma mete piti fei pratei pepei pepe pe ma pa pingi. ");
INSERT INTO ong_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tef re teplai ma lelesesa wolo il peiki ma pelesesa kolo, pe ma pile pingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ise kotopa isotei. Ise ma onom kere piti yifei yaplei oweli lipi lipi kolo le tipeluwi singe pepe re ise ma onom kere piti yaplei kolo olo. Le men nange piti tef lepei re ise ma yirkilau onposiepe piti kapi yire yailele isotei kolo olo, wusoli wem ise yire wouye rautu isotei yiripe men nange fei pepe yato, wem lite Ili lele ma fale frou le ise ma yinlele. ");
INSERT INTO ong_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Wusoli wem fei lepe ma falepe mete yeflipiye piti tef watafei supoli piti kapipi siye pepe. ");
INSERT INTO ong_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lus patoto le wem oli oli ise ma yeletei Ma Ili piti ma kaneise yile singe wem moingi men nange fei pepei fale, le ise ma fale yile onom pite Ninge lite Metine Wape.” ");
INSERT INTO ong_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jisas epli ma leptalo mete lifei winem lite Ma Ili le mulpou ma le letei lato tumun liti nimpe oliv pile. ");
INSERT INTO ong_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mete yeflipiye ma pire mul pe winem lite Ma Ili piti ma pingitowo Jisas lirpei. ");
INSERT INTO ong_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wem lire malfem liti mete pite Juda ma papli oweli lipi piti ma onposio wem wuso Ma Ili kesipe manre yaire pelpe pe tani Isip. ");
INSERT INTO ong_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mete piti pinuwepe peptawio Ma Ili siye le mete piti peptalo mete pire il lipi pite Moses, pe pinta tisi liti ma petesi Jisas la, wusoli pe turwepe pire mete. ");
INSERT INTO ong_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Leye lo towa, le lunkuwo Judas lite uf Iskariot. Le pupane nele lite Jisas wuso lire eti plen le plen poungo te twinges pepe. ");
INSERT INTO ong_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Liso Judas le falepe mete piti pinuwepe peptawio Ma Ili siye pepe le yali pal lipi piti puntoluwo winem lite Ma Ili, Judas le fale lirpepe lire tisi men le ma kaniepe piti ma laltei Jisas le esi pelpe. ");
INSERT INTO ong_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pe enke teingipe le pe pulpo piti ma watowo Judas era. ");
INSERT INTO ong_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas lulpope il pelpe le le lintata tisi piti ma laltei Jisas le esi pelpe kotire le mete re ma pretai kolo, wusoli pe turwepe pasiepe mete. ");
INSERT INTO ong_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Epli wem pire eti plen poungo te twinges, pe wem piti mete pite Juda ma papli oweli lipi piti onposio wem wuso Ma Ili kaniepe manre yaire pelpe pe tani Isip. Le epli wem nele fei lepe, pe ma posiepe sipsip eple papli piti ma paplei pire pauli wem ili fei lepe. ");
INSERT INTO ong_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisas laisinge Pita lire Jon le le lirpenge lamtetenge lolpepei, “Rounge ye yapli oweli elpesipe piti ku ma maplei onposio wem ili lepe.” ");
INSERT INTO ong_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Te rounge teletei tolpepei, “Ku ma we wapli oweli waptei elpesipe pifei fei linei?” ");
INSERT INTO ong_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Le lirpengeye, “Rounge yingitei, wem ise rounge yinki ye uf ili lepe, metine nele lila mili lire tipe, le ma lau fale lerengaise rounge. Rounge yulsi ye yinki winem wuso le le linki le lepe, ");
INSERT INTO ong_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","le ise rounge yirpowo yaitei lite winem lepe yolpepei, ‘Metine liti leptalo mete lepe, le leiteye lirpolo, elpeingo linei soma ki kire pupam peiki mifei maplei oweli piti onposio wem wuso Ma Ili kaniepe manre yaire pouku pau tani Isip lepe?’ ");
INSERT INTO ong_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Le le ma kosaise elpeingo nele ili lato winem tuluwim yuwei, pe olo pirowo teingi elpesi. Rounge yapli oweli re yaptei elpesipe pifei elpeingo fei lepe.” ");
INSERT INTO ong_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Fei, pupam twinges tepe, te te le te tulwepe menmen wuso Jisas lirpenge pepe, pe fale pingiepe il pele wuso linu lirpenge liripe pepe. Le te rounge tapli oweli taptei elpesipe pifei. ");
INSERT INTO ong_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wem leletei piti ma paplei oweli piti onposio wem ili lepe, Jisas liripe pupam pele pe pifei neinepe ponu pire oweli. ");
INSERT INTO ong_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Le Jisas lirpepe pupam pele lolpepei, “Ki onposi kirkilautei piti ma kireise mepi maplei oweli piti onposio wem ili lepei wo, ki soma kila moingi kingi. ");
INSERT INTO ong_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wusoli ki kirpeise, ki ma nou kaplei nemple kolo olo, kato ke ke ma fale wem piti Ma Ili ma luntoluwepe mete pele le il pal pite oweli lipi fei pepe, wem fei lepe pe ma fale punkom.” ");
INSERT INTO ong_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Leye lo Jisas kali wengle pau lire wain tipe, le leletei Ma Ili liri re fei, le lirpepe pupam pele lolpepei, “Kali wain tipe lepei le ise yaltei wainemple yalei. ");
INSERT INTO ong_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Wusoli ki kirpeise, ki ma nou kalei wain tipe nele kolo olo, kato ke ke ma fale wem piti Ma Ili ma luntoluwepe mete pele wo, ki soma nou kalei wain tipe.” ");
INSERT INTO ong_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Leye lo le kali luom, leletei Ma Ili re fei, yaru watetepe le le lirpepeye, “Lepei topo tale leiki, ki waise piti ma kaneise. Ise ma yingiepe yolpepei piti ma onposiki.” ");
INSERT INTO ong_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Le lolpepe lire wengle pau lire wain tipe lepe re, wem pe paplei re fei, le lirpepeye, “Ma Ili topwepe il nemple yeflipi liripe mete le wengle pau lire wain tipe lepei, le teluwi leiki piti lesiepe il fei pepe lapiri le ki ma kalulu piti ma kaneise.” ");
INSERT INTO ong_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Wolo yuntoli minele piti ma leiteiki ke esi pite mete olpe pepe, le min lireiki wepi wifei ponu pepei. ");
INSERT INTO ong_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wusoli Ninge lite Metine Wape ma la lingiepe il wuso Ma Ili pele linu laptei pato pepe, wolo metine wuso laltei le esi pite mete olpe pepe, metine fei lepe le men oli, moingi ilitei ma falowo.” ");
INSERT INTO ong_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Leye lo pupam pepe pe peifale peite nemple pirpolo pe minele lelpe soma lolpepei lepe. ");
INSERT INTO ong_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pupam pepe pe pire il pura nemple pire minele lelpe lepe soma fale ili linuwepe pe nemple pepe. ");
INSERT INTO ong_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Fei, Jisas lirpepe lolpepei, “Mete lipi piti puntoluwepe mete pite alpe nemple pepe, pe pire singe pelpe puntoluwepe piti ma watepe mete pelpe moingi wolo mete lipi pepe pe peilape nange pelpe potei pirpolo pe mete lipi piti puntoluwepe mete pelpe poporo. ");
INSERT INTO ong_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wolo ise ma yingiepe wai lelpe kolo olo. Minele lirpolo le ili piti linuse, le ma weitei lire ninge kumpu wo, le minele wuso lirpolo le ma luntolise lepe, le ma weitei lire metine piti lesio towa leise wo. ");
INSERT INTO ong_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Minele le ili, metine piti lifei laplei oweli lo metine piti laplio oweli? Punkomtei, metine piti lifei laplei oweli pepe, le metine ili. Wolo ki keingaloise nimin watafei ki metine piti kaplise oweli. ");
INSERT INTO ong_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ise yireiki mepi ratei le ise yulwepe moingi wuso faleiki pepe, ");
INSERT INTO ong_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","le min watafei Eiya leiki waiki singe piti kuntoluwepe mete, le ki re ma namti waise singe elpesipe pepe. ");
INSERT INTO ong_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ise ma yaplei oweli re tipe yifei ponu peiki piti pile uf teingi leiki, le ise ma yifei poi teingipetei piti ise ma kapi il yaptei yiripe mete pite alpe pite Israel wuso pire eti plen poungo le plen te twinges (12) pepe.” ");
INSERT INTO ong_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas lirpeiye, “Saimon, Saimon, ye ingitei. Ma Ili watowo towa il piti ma lempeteise ise yeflipiye, lulise waipiti ise ma yuwalo lo ma olo. Le ma lesi nenyeyise watafei metine piti lari wit, le ma nenyeyipe wit fouri pualo tani emare olpe pepe. ");
INSERT INTO ong_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wolo ki keletei Ma Ili kireye fei, Saimon, keletei piti ma il wuso ye ulpope pepe pe ma kere yaupe kolo olo. Le wem ye nou kani onom anteiki, ye ma namti kaniepe ilim winkem peiye piti ma pile singe.” ");
INSERT INTO ong_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita namti lirpei lolo, “Ili leiki, ki kopori kutei piti ma kireye rounge we wifei winem oli le piti ma kireye rounge wa.” ");
INSERT INTO ong_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Ki kirpeiye Pita,” Jisas namti lirpowoye, “Woflu wala ma koro kolo, wala ma lungari wem ye ma irpei ireiki yef wem twinges niliyeye, irpolo ye olo retaiki kolo, wem fei lepe le ma koro.” ");
INSERT INTO ong_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Leye lo Jisas lirpepe pupam pele lolpepei, “Wem wuso ki kaiteise ye yeptalo il pepe, ise yila tom pau lo tom nele ili kolo olo, lo ire topungou re olo, ki kaiteise yire esi yaupeye ye le mete ma re pe kaneise lo olo?” “Iyo, pe kanouku,” pe namti pirpowo. ");
INSERT INTO ong_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Fei Jisas lirpepeye, “Wolo fei, minele wuso tom oplou lo tom ili lele, le ma kali lila, le minele wuso werau olo lepe, le ma laltepe olol lele piti lalfo lifei yuwei lepe, laltepe mete paise le le ma kapi era lire laise werau nele lele. ");
INSERT INTO ong_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Wusoli ki kirpeise, il wuso paptei paitei yousi pirpei pireiki pepe pe ma fale punkom. Il pirpei polo, ‘Le nele lelpe liti lire il olpe,’ le il fei pepei pe ma fale punkom.” ");
INSERT INTO ong_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Pe pirpowoye, “Ili louku, werau twinges olo min tepei.” Le le lirpeiye, “Pepe fei.” ");
INSERT INTO ong_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Leye lo Jisas naro le tef lupai linpei liti nimpe oliv pile, wai lele piti le lau tulum fei lepei, le pupam pele re naro pepi pe. ");
INSERT INTO ong_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wem pe pe fale tulum lepe, Jisas lirpepeye, “Ise yeletei Ma Ili soma ise yualo tisi oli kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Leye lo le le taniepe, le tulum nele fiyen taise le le lualo yaru yamkelem ratei le le leletei Ma Ili lolpepei, ");
INSERT INTO ong_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Eiya, wuso ye miso kaneiki, ye kali moingi fei lepei taniki. Wolo ye ma ingiepe il peiki pato, ye ingiepe il pite onom peiye yotei.” ");
INSERT INTO ong_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Leye lo riri nele lite yuwei lau falowo Jisas piti ma watowo singe. ");
INSERT INTO ong_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Onom pele olo moinginetei le le lirkilau leletei Ma Ili le lenke falele, konunu pualolo tef watafei teluwi. ");
INSERT INTO ong_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wem Jisas leletei Ma Ili re fei, le leilo nou karepe pupam pele, le le le lulwepe petei oloye. Wusoli pe enke pelpe olo moingipetei. ");
INSERT INTO ong_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Piti men so ise yetei pepe?” Le lirpepe, “Yeilo ratei yeletei Ma Ili soma ise yualo tisi oli kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas wala lirpei wem mete nemple pire Judas pepi fale pe. Judas, le pupane nele lite Jisas piti lire eti plen poungo le plen te twinges pepe. Judas linuwepe le fale lenesi Jisas mi. ");
INSERT INTO ong_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Wolo Jisas leletei lolpepei, “Ye altei Ninge lite Metine Wape le esi pite mete olpe le ye ma enesi mi lom?” ");
INSERT INTO ong_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wem pupam pite Jisas pulwepe men wuso fale pepe, pe pirpeiye, “Ili louku, ku ma mire werau pouku mosiepe lo olo?” ");
INSERT INTO ong_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Le nele lelpe lalowi metine piti lesio towa lite metine piti linuwepe peptawio Ma Ili siye, lalowi mingi lite eti tilpi lepe, lalowi laltuye. ");
INSERT INTO ong_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wolo Jisas il karipe pupam pele lirpeiye, “Fei, ise nou yolpepe kolo.” Le lesio mingi lite metine lepe le mingi lele nou fale teingi. ");
INSERT INTO ong_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Leye lo Jisas lirpepe mete piti pinuwepe peptawio Ma Ili siye, le yali pal lipi piti puntoluwo winem lite Ma Ili, le mete lipi pite Jerusalem pepe, pe wuso pe piti ma penglei lepe, Jisas lirpepeye, “Ise yilape werau re nimpe teingelem piti lolpo, yau piti ma yengleiki wata pirpolo ki metine liti kapwe il yaruwepe lom? ");
INSERT INTO ong_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Epli wem oli wuso lepe ki kireise mifei winem lite Ma Ili, le ise yengleiki kolo. Wolo wem leise fei lepei soma ise yolpepe, wem towa ma lirine pite le pele wo.” ");
INSERT INTO ong_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pe penglei Jisas le pe kesi pila pe pinki winem lite metine piti linuwepe peptawio Ma Ili siye, le Pita lulsesipe lingi, le le liri Jisas malfem kolo, le lualolo fiyen taise, lulsesi lingingi. ");
INSERT INTO ong_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pe paltei weli lato nimin lite uf teingo le pe pifowo, le Pita le liripe pepi pifei neinowo weli lepe. ");
INSERT INTO ong_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Moto nenpe piti nesio towa lite winem fei lepe, ne nuluwo Pita wuso lifowo weli lepe, ne nuluwo nautuluwo re fei, ne nirpeiye, “Metine lepei re piti lulsesi Jisas.” ");
INSERT INTO ong_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wolo Pita lire yef lirpeiye, “Ko ye moto, ki fei lom kretawo metine fei lepei.” ");
INSERT INTO ong_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wem kurauye, metine luluwo Pita le le lirpeiye, “Ye re nele lelpe liti yulsesi Jisas.” Wolo Pita namti lirpowoye, “Ko ye metine, ki olo.” ");
INSERT INTO ong_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Wem ulel re fei, metine nele lirkilau lirpei liri Pita lolpepei, “Punkomtei, metine lepei re lulsesi Jisas, wusoli le re le metine lite Galili.” ");
INSERT INTO ong_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wolo Pita nou lire yef lirpeiye, “Ko ye metine, ye irpei ire men pepe, ki olo kironom.” Wem fei lepeye wem Pita wala lirpepei, woflu koro. ");
INSERT INTO ong_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Apa Ili weitei lupoluwo Pita, le Pita onposiepe il pite Apa Ili wuso lirpowo pepe, “Woflu wala ma koro kolo, wala ma lungari wem ye ma irpei ireiki yef wem twinges niliyeye, irpolo ye olo retaiki kolo, wem fei lepe le ma koro.” ");
INSERT INTO ong_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita naro le towa yawi le le louti olitei. ");
INSERT INTO ong_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mete wuso pile puntoluwo Jisas pepe, pe palwe oli piri Jisas le pe petesesi. ");
INSERT INTO ong_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pe topwepe lutepe pele le pe peletei polpepei, “Irpei, minemple peteteiye?” ");
INSERT INTO ong_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Le pe pirpei il olpe wuru, pirpei piri Jisas. ");
INSERT INTO ong_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wem ifili kerere, mete lipi piti pinuwepe mete pite Juda, mete piti pinuwepe peptawio Ma Ili siye, le mete piti peptalo mete pire il lipi pite Moses, pe pau panfinemple pifei le pe kesi Jisas pila pe paltei lilepe onom. ");
INSERT INTO ong_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Pe pirpowoye, “Ye irpouku, ye Krais lom?” Jisas namti lirpepeye, “Wuso ki kirpeise ise ma yulpoiki kolo, ");
INSERT INTO ong_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","le wuso ki keiteise kire il menemple, ise miso namti yirpeiki kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wolo wem fei lepei le le le, Ninge lite Metine Wape ma lungura lifei eti tilpi lite Ma Ili singetei.” ");
INSERT INTO ong_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pe yeflipiye peletei, “Ye ninge lite Ma Ili lom? Jisas namti lirpepeye, “Iyo, ise min yirpei yirpolo ki ninge lele ko.” ");
INSERT INTO ong_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Le pe pirpeiye, “Piti men ma ku nou mintape il nemple piti pirpei pamtuwo? Fei, ku kutou min mingitowo lirpei fale nemi lele lepe.” ");
INSERT INTO ong_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pe yeflipiye peilo kesi Jisas pila pe falowo Pailat. ");
INSERT INTO ong_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Le pe pamtuwo pirpei polo, “Ku merengawo metine lepei le weisipe enke pite mete, lirpepe lirpolo pe ma paisipe era pe metine ili Sisar kolo, le le lirpei lire lotei lirpolo le Krais, le metine ili piti luntoluwepe mete.” ");
INSERT INTO ong_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailat leletei Jisas lolpepei, “Ye metine ili lite Juda lom?” “Iyo, ye min irpei lepe.” Jisas namti lirpowo Pailat. ");
INSERT INTO ong_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Leye lo Pailat lirpepe mete piti pinuwepe peptawio Ma Ili siye le mete wurutei pepe, lirpei lolo, “Ki kerengape il pal nemple kolo piti ma kapi il kaptei kiri metine fei lepei, olo.” ");
INSERT INTO ong_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wolo pe pirkilau pirpei polo, “Olo, le leptalo il le mete pite tef ili yefliye lite Judia pe enke pelpe peilo piti ma plolpo. Le linu lolpepei liripe mete pite Galili le fei, le lau fale lepei.” ");
INSERT INTO ong_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Wem Pailat lingitepe il pepei, le lepleteiye, “Le metine lite Galili lom?” ");
INSERT INTO ong_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wem Pailat retai lolpepei, Jisas laule tef wuso Herot lele luntoluwo lepe, le laisi Jisas le falowo wusoli wem fei lepe, Herot re lau ratei Jerusalem. ");
INSERT INTO ong_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot onom teinginetei wem le luluwo Jisas, wusoli le lingitepe pirpei piri le wem ulel le onposi lirpolo ma luluwo. Le onposi piti ma luluwo Jisas lirpei le menmen ma lotei lire tute fale. ");
INSERT INTO ong_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Liso Herot leltei Jisas lire il wuru, wolo Jisas nou lirpowo lire il men re kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mete piti pinuwepe peptawio Ma Ili siye le mete piti peptalo mete pire il lipi pite Moses, pe peifale pirpei pirkilau pamtuwo Jisas. ");
INSERT INTO ong_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herot liripe mete pele piti plolpo, pe palwe oli pelesi Jisas le pe pirowo olitei. Pe so kali olol nele teingitei lite metine ili lepe palfowo le Herot nou laisi le Pailat. ");
INSERT INTO ong_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Epli wem fei lepe Herot lire Pailat rounge nou tailele noute watafei te numu numu, wem linu olo, te tire noute eringi. ");
INSERT INTO ong_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat linape mete piti pinuwepe peptawio Ma Ili siye, mete lipi piti pinuwepe mete le mete yeflipi pepe, Pailat linape pau panfinemple pile, ");
INSERT INTO ong_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","le le lirpepe lolpepei, “Ise kesi metine lepei yila yau yalteiki le ise yirpei yolo le leilape mete enke piti ma pingowo tisi oli. Le fei ise isotei yile yuliki re yingiteiki kapi il kaptei kiri wolo ki kerengape il nemple re poluwo pire il wuso yirpei yamtuwo pepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Lo Herot re le lamtuwo lirpolo le metine oli kolo olo, wusoli Herot nou laisi lau falouku lepei. Metine lepei, le lingiepe il men olpe ma le la lasiepe, olo le teingi. ");
INSERT INTO ong_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ki ma kirpepe petesi le ki ma kaltei le yawi.” ");
INSERT INTO ong_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Wem oli oli, wem mete pite Juda papli oweli lipi piti onposio wem wuso Ma Ili kesipe manre yaire pelpe pe tani Isip, wem fei lepe Pailat ma kesi metine nele wuso lifei winem oli lepe, Pailat ma kesi laltepe le yawi. ");
INSERT INTO ong_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mete wurutei pepe, pe yeflipiye pailo pirpei polo, “Altei la. Ye kesi Barabas altouku le yawi.” ");
INSERT INTO ong_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas lifei winem oli wusoli le leilape mete enke piti plolpo pratei uf ili Jerusalem lepe, le le letesi metine nele la.) ");
INSERT INTO ong_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat lirpolo ma lusa Jisas le yawi, le so nou malfefipe mete wurutei pepe. ");
INSERT INTO ong_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wolo pe nou pailolo pirpei polo, “Tingeli, tingeli laitei nimpe.” ");
INSERT INTO ong_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wem fei lepei, le wem twinges niliyeye wem Pailat lirpepe, lirpepe lirpolo, “Piti polomen? Il men olpe so metine lepei lingiepe pepe? Ki kerengape il men olpe poluwo kolo olo, le le ma la yawi lom? Olo, ki ma kirpepe petesi le ki ma kusa le yawi.” ");
INSERT INTO ong_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wolo pe pirkilau pailolo il lipi pirpolo pe ma tingeli Jisas laitei nimpe, le onomtei, Pailat lanlepe oru. ");
INSERT INTO ong_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Liso Pailat lirpei piti Jisas ma la, lirpei lingiepe il pelpe wuso peletei piri lepe. ");
INSERT INTO ong_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pailat kesi metine wuso pe pirpei piti ma pusa le yawi lepe, Pailat kesi laltepe le yawi. Metine wuso leilape mete enke le pe plolpo le le letesi metine nele la, le lolpepei so pe paltei lifei winem oli. Pailat kesi metine lepei laltei le yawi le le kesi Jisas laltepe mete pepe piti ma pingiepe il pelpe wuso onposiepe piti ma paltei la lepe. ");
INSERT INTO ong_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pe kesi Jisas pila peye. Wem pe wala pe pualo tisi, pe perengawo metine nele, nange lele Saimon. Le lite uf Sairini le le wala lato so lau piti ma laule uf ili Jerusalem lepe. Pe pesio pari, pe kali nimpe wuso Jisas lele lila lepe le pe paltei luwo esi yoli pite Saimon, le pe yeftuwo piti ma lila lulsesi Jisas. ");
INSERT INTO ong_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mete wurutei pulsesi Jisas pingingi le nimoure ilepe wuso piripe pepi pe pepe, pe poututuwo Jisas. ");
INSERT INTO ong_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisas weitei lulwepe le le lirpepeye, “Ise nimoure pite Jerusalem, ise youtiki kolo, wolo ise youti isotei re eple peise. ");
INSERT INTO ong_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Wusoli wem wala lato, ma wem fei lepe, moingi ilitei faleise le mete ma pirpei polo, ‘Nimoure wuso wilyaipe pepe, nimoure wuso pilape eple kolo pepe, pe watepe eple nimer re kolo, pe ma enke teingipe.’ ");
INSERT INTO ong_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wem fei lepe soma mete ma pirpepe tumun pirpolo, ‘Ise yualo yenfaruku.’ Le tef lupai pinpei pifefei pepe, mete ma pirpepe pirpolo, ‘Ise yopopouku.’ ");
INSERT INTO ong_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wuso metine teingiye yawi, il menemple olpe re paisi topo kolo olo, le ma lila moingi fei lolpepei, le mete wuso pire il olpe pepe, pe ma pila moingi fei lolomen? Pe men olpe, moingi ilitei ma pe pila.” ");
INSERT INTO ong_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pe kesinge mete noute twinges re, te rounge tire ausi kapi oweli, te re ma petesinge tire Jisas pepi pa. ");
INSERT INTO ong_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wem pe pe fale tulum pinawo pirpolo ‘Oru weingampi’, tulum fei lepe, pe pratei tingeli Jisas laitei nimpe. Le mete twinges wuso te rounge tire ausi kapi oweli pepe, te re pe tingeli nele laitei nimpe piti laitei le eti tilpi, le nele laitei nimpe piti laitei lau eti enkau. ");
INSERT INTO ong_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisas lirpei lolo, “Eiya, ye onposiepe il olpe pelpe kolo olo, wusoli pe pironom pire men fei pe polpepei lepei.” Pe kapi olongou pite Jisas pele paptei pratei le pe pe paptetei nimpe fouri piti ma pulwepe minemple pelpe ma kapi olongou fei pepe. ");
INSERT INTO ong_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mete pile puntoli wem mete lipi piti pinuwepe mete pite Juda, pe palwe oli pelesi Jisas pirpei polo, “Le kaniepe mete nemple, yusa le ma kane lotei, wuso le Krais Ma Ili keinio lepe.” ");
INSERT INTO ong_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mete piti plolpo pepe re, pe palwe oli pelesi. Pe pe malfem le pe watowo wain tipe wala pulou, pe watowo pirpolo ma lalei, ");
INSERT INTO ong_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","le pe pirpeiye “Ye kane yotei, wuso ye metine ili lite Juda.” ");
INSERT INTO ong_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pe paptei il pepei paitei nimpe yuwei pirpei polo, “Metine lepei, le metine ili lite Juda.” ");
INSERT INTO ong_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Metine nele wuso lire ausi kapi oweli le pe tingeli laitei nimpe nele lepe, le kelelawo Jisas lirpei lolo, “Ye Krais lom? Ye kane yotei le ku re, ye ma kanouku ko.” ");
INSERT INTO ong_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wolo nele lepe le lirpeilawo lirpolo, “Ye turiye asio Ma Ili lo olo? Ku mepi mila moingi niliyeye. ");
INSERT INTO ong_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ku wingiepe il olpe le fei ku wila moingi lepei, pe pato poporo. Wolo metine lepei, le olo lingiepe il nemple olpe re kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Le le lirpowo Jisas lolpepei, “Jisas, ye onposiki wem ye fale ire metine ili.” ");
INSERT INTO ong_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisas lirpowoye, “Ki kirpeiye punkom, ye fei ma ireiki wepi wifei uf teingi.” ");
INSERT INTO ong_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Epli wem nimin wem epli weitei lire munkunum le tef ili yefliye, munkunum fale keraisi le le fale ningli (3 kilok). ");
INSERT INTO ong_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Le ranguwom wuso lultei winem lite Ma Ili lepe, le kere plen plen. ");
INSERT INTO ong_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jisas lailo il lipi lirpeiye, “Eiya, ki kaltei riri leiki le esi peiye.” Le lirpei il pepei le le kete yef. ");
INSERT INTO ong_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yalu pau ili piti luntoluwepe mete piti plolpo pepe, le lulwepe menmen wuso fale pepe le le leila nange lite Ma Ili, lirpeiye, “Punkomtei, le metine teingi.” ");
INSERT INTO ong_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mete yeflipi wuso panfi nemple pile pulwepe piti tingeli Jisas laitei nimpe lepe, wem pe pulwepe menmen wuso fale pepe, pe esi papopo onom popo pelpe le pe nou pe winangou pelpe. ");
INSERT INTO ong_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mete piti pretawo Jisas poporotei pepe, pe yeflipiye pire nimoure wuso pulsesi Jisas pile Galili so pau pau fale Jerusalem pepe, pe pile tulum nele fiyen le pe so lus ye patoto, pulwepe men nange wuso fale pepe. ");
INSERT INTO ong_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Metine nele, nange lele Josep, le lite uf pinawo Arimatia. Le metine teingi le le metine piti lingiepe il pite Ma Ili, le le ratei lungario wem piti Ma Ili ma luntoluwepe mete pele piti tef. Le nele lelpe piti linuwepe mete piti Juda, wolo le lulpope il pite mete lipi nemple pepe kolo olo. Pe pirpei piti ma paltei Jisas la, le Josep olo lulpope kolo. ");
INSERT INTO ong_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Josep le falowo Pailat le le leletei Pailat liri topo lite Jisas. ");
INSERT INTO ong_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Leye lo Josep nalpo topo lite Jisas wuso laitei nimpe lepe, nalpo laltei lato tef, le kali ranguwom lire weisi re fei, kali lila le lalingi luwo erau nample nele wala palowi yefli, towa nemple re wala paplingi puwo kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Epli wem fei lepe le wem liti mete pite Juda ma pesiepe oweli poporipe elpesipe pifei le wem epli lautile le nolowi nenpe, pe ma pifei yaupe piti ma onposio Ma Ili. Wem piti epli ma lautile lepe olo lire malfemye, le Josep onposi piti ma lire frou lalingi Jisas luwo erau nample lepe. ");
INSERT INTO ong_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nimoure pite Galili wuso pulsi Jisas pepi pau pepe, pe piri Josep pepi pe le pe puluwo erau nample wuso Josep lalingi Jisas luwo lolomen. ");
INSERT INTO ong_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Leye lo nimoure pepe pe nou pe winem piti ma poporipe wilfengi tenglanu re nimpu kurei re piti ma pire wopu lepe weisi topo lite Jisas. Epli wem liti pifei onposio Ma Ili lepe, pe pifei paltei yef, pifei yaupe, pingiepe il wuso paitei il lipi pite Moses pepe. ");
INSERT INTO ong_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Epli wem linu piti mete pite Juda ma naro pesiepe towa pelpe, epli wem linu lepei, nimoure wuso popori wopu liti ma pire paltu topo lite Jisas lepe. Pe peifale pire mul ili, kali wopu lepe le pe so pila pe erau nample wuso palingi Jisas luwo lepe. ");
INSERT INTO ong_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nimoure pepe, pe puluwo erau liti palfo pire popopo wingi pite erau nample lepe olo weisi taniye, le erau nample lato yawi, ");
INSERT INTO ong_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","liso pe pinki pe leinginim, wolo pe puluwo topo lite Apa Ili Jisas olo, luwo kolo. ");
INSERT INTO ong_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pe wala pile onposisi wem mete twinges tafo olongou olo pininiye, te fale frou yo fei, tile malfem tiripe. ");
INSERT INTO ong_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nimoure pepe, pe turwepe olpe le pe pautenge eri, puntoli mi noli tef. Wolo mete twinges tepe, te tirpepe tolpepei, “Tulum liti mete pa le pe paptei pato lepe, metine piti namin ratei, le miso ratei tulum fei lepe kolo olo. Le piti men so ise yau yintawo metine piti namin ratei, yau yintawo yato tulum lepei lepe? ");
INSERT INTO ong_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Le olo luwo lepei kolo, le nou leiloye. Ise onposiepe il men wuso lirpeise pepe wem le wala ratei Galili. Le lirpeise lolo, ");
INSERT INTO ong_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Ninge lite Metine Wape ma paltei le esi pite mete piti pire il olpe, pe ma tingeli laitei nimpe le epli wem twinges niliyeye fei, le ma nou leilo’.” ");
INSERT INTO ong_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Leye lo nimoure pepe, pe onposiepe il pite Jisas. ");
INSERT INTO ong_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pe pusa erau nample lepe le pe nou pe pirpepe pupam wuso pire eti plen poungo le plen le niliyeye (11) pepe, le mete nemple yeflipi wuso pepi panfinemple pifei onposio Jisas wuso la lepe. ");
INSERT INTO ong_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nimoure wuso pilape il pe pirpepe pupam pire men nange wuso pulwepe fale pepe, nimoure pepe, Maria Makdala, Joana le Maria, ne nimou pite Jems, pe pire nimoure nemple pepe. ");
INSERT INTO ong_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wolo pupam pepe pe pulpope il pite nimoure pepe kolo olo, wusoli pe onposi pirpolo il pelpe olo yuwas ye yaupe. ");
INSERT INTO ong_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Wolo Pita leifale lantu le fale erau nample lepe, lungutuluwo laplingi lus luntoli wolo le lulwepe olongou yaupe puwo. Leye lo le nou le winem, onposisi lire men wuso fale pepe. ");
INSERT INTO ong_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Epli wem niliyeye fei lepe, pupam twinges te uf pinawo Emeus, fiyen taise lire uf ili Jerusalem (11 kilomita). ");
INSERT INTO ong_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Le te rounge tirpepei noute tire men nange yeflipiye wuso fale pepe. ");
INSERT INTO ong_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wem te rounge wala orwesi noute piti tirpepei, Jisas lau fale malfem liringe le le liringe pepi pilele pe. ");
INSERT INTO ong_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Te rounge tuluwo wolo rounge tuluwo matufuwo kolo olo. ");
INSERT INTO ong_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisas loutetei lolpepei, “Ko ise rounge yirpepei noute yire men wem ise rounge yilele yau lepe?” Te rounge tirkir tile le mati pelnge re weitei olnge, wusoli te onom one. ");
INSERT INTO ong_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nele lelnge, nange lele Kliopas, le leltei lolpepei, “Ye yoteteiye piti ratei Jerusalem so ironom ire men nange wuso nempisye lepei fale pepe lom?” ");
INSERT INTO ong_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Menemple so fale pepe?” Le loutetei. Le te namti tirpowo tolpepei, “Menmen wuso falowo Jisas lite Nasaret lepe. Metine lepei, le metine nimou. Il pele piti lirpei le towa lele piti lesio, singe rasipe le mete yeflipiye pe pulpowo, le kapi singe pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mete lipi pouku pire mete piti pinuwepe mete piti peptawio Ma Ili siye, pe paltei le esi pite moli lipi piti ma petesi la le pe tingeli laitei nimpe. ");
INSERT INTO ong_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Le ku minu onposi mirpolo le lepe soma kaniepe mete pite Israel. Le fei pepe poteteiye kolo olo, fei ma epli wem twinges niliyeye kari wem wuso pe petesi la lepe. ");
INSERT INTO ong_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nimoure ilepe pouku pirpouku pire il nemple le ku wala minele kutou masiepe. Pe pire mul naro pe erau nample wuso topo lite Jisas luwo lepe, ");
INSERT INTO ong_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","wolo pe puluwo kolo olo. Pe nou pau pirpei polo pe pulwenge ririm tite yuwei le ririm tepe te tirpepe tirpolo Jisas olo namin ratei. ");
INSERT INTO ong_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mete ilepe pouku pe fale erau nample lepe le pe pulwepe menmen pepe fale punkom watafei il pite nimoure wuso pinu pirpouku piripe pepe. Wolo pe puluwo Jisas kolo olo.” ");
INSERT INTO ong_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Leye lo Jisas lirpenge lolpepei, “Rounge fupeiteteise ko, le onom peise re malye kir oli piti yulpope men nange wuso mete emarengi pirpei piripe pepe. ");
INSERT INTO ong_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ise rounge yironom lom, Krais ma linu lila moingi wo, le soma le lifei eti tilpi lite Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Le Jisas lirpei namlienge lire il yeflipiye wuso pirpei piri le pe paptei paitei yousi pepe, lirpei nampli lile yousi pite Moses le pite mete emarengi yeflipiye. ");
INSERT INTO ong_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pe pe fale malfem pire uf wuso pupam twinges tepe te ma te lepe, le Jisas olo kapi lapsisi lotei le le lilange lusange lempetete lirpolo le wala ma le. ");
INSERT INTO ong_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wolo te rounge tirkilau malfefi tirpolo, “Au irouku mepi me metei, olo ningliye le munkunum re lau lire malfemye.” Le so liringe pepi pe. ");
INSERT INTO ong_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jisas liringe pepi pifei poi, le kali luom leletei Ma Ili re fei, le kari watenge rounge. ");
INSERT INTO ong_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lus pelnge kere le te rounge tuluwo matufuwoye, wolo Jisas frou lelesesa taniengeye. ");
INSERT INTO ong_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Te rounge tirpei noute tolpepei, “Wem ku wala wilele winge tisi wau lepe, le lirpouku namuku lire il piti paitei yousi le ku min wingitene onom fale fale nepe.” ");
INSERT INTO ong_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pupam tepe, te teifale nou frou te Jerusalem. Te fale terengape pupam wuso pire eti plen poungo le plen le niliyeye (11) pepe, pe panfinemple pifei pire mete nemple wuso pau panfipe pepe. ");
INSERT INTO ong_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Le pupam wuru pepe pirpenge polpepei, “Punkomtei, Apa Ili olo nou leiloye le le falowo Saimon.” ");
INSERT INTO ong_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Leye lo te rounge tirpepe tire menmen wuso falenge tisi wem te rounge tilele te uf Emeus, le te tolomen te tuluwo matufuwo Jisas wem le yaruwo luom watenge. ");
INSERT INTO ong_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wem te rounge wala tirpepe tire il fei pepei, Apa Ili lotei frou fale lile nimin lelpe le le lirpepeye, “Onom malye pite Ma Ili nireise ratei.” ");
INSERT INTO ong_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pe pinlele re turwepe, mol re kapipiye, pe onposi pirpolo pe puluwo towa so lepe. ");
INSERT INTO ong_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wolo Jisas lirpepe lolpepei, “Piti men ise turise, le piti men ise kapi enke yaptetei pepe? ");
INSERT INTO ong_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yulwepe esi re ire peiki. Kuna ki kutei so lepei. Yesiki yingiteiki le ise ma retai, towa miso leltei topo tale re emingelem pingowo watafei ki lepei lo olo, ma olo.” ");
INSERT INTO ong_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jisas lirpepe il pepei re fei, le kosape esi re ire pele. ");
INSERT INTO ong_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pe enke pelpe teingipetei piti puluwo wolo pe wala pulpowo kolo olo, wusoli enke pelpe wala moingipe le pe wala kapi enke paptetei. Liso Jisas lepletei lolpepei, “Ise menele re yaltei luwo lepei liti yalei lo olo?” ");
INSERT INTO ong_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Fei, pe kali ni ile weli lalei elpesi, watowo, ");
INSERT INTO ong_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","le le kali lalei lile lutepe pelpe. ");
INSERT INTO ong_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Leye lo le lirpepeye, “Il wuso kinu kirpeise wem ki wala kireise ratei lepe, il pepe pe paptei pirpei pireiki ki. Il paptei paitei il lipi pite Moses le pe paitei yousi pite mete emarengi le pe paitei yousi pite Sam, il pepe fei fale punkom.” ");
INSERT INTO ong_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Leye lo Jisas weisipe enke pelpe le enke pelpe pautu le pe pretape il wuso paitei yousi pepe, ");
INSERT INTO ong_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","le Jisas lirpepe lolpepei, “Il wuso paptei paitei yousi pepe, pe pirpei polo Krais ma la le epli wem twinges niliyeye fei, le ma nou leilo, ");
INSERT INTO ong_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","le pupam pele ma peptalo il pire nange lele, pirpepe mete piti ma weite yefi, kani onom pantowo Ma Ili le Ma Ili ma onposiepe il olpe pelpe kolo olo. Il pepei pe ma pinu peptalo pile Jerusalem soma pe uf mete liye liye re pe, le mete yeflipiye piti tef ma pingitepe. ");
INSERT INTO ong_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Men nange wuso yulwepe re yingitepe pepe, ise ma nampli yirpepe mete nemple. ");
INSERT INTO ong_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Menmen wuso Eiya leiki topwepe il lapiri piti ma waise lepe, ki kutei miso kaisi lau ise. Wolo ise ma ratei uf ili lepei yungari wem singe pite yuwei ma pau pungise wo.” ");
INSERT INTO ong_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Leye lo Jisas linuwepe pusa uf ili Jerusalem lepe, le pe pe fale Betani, pile lepe Jisas leptalo esi pele puwope le le leletei Ma Ili piti ma lailelepe re luntoluwepe. ");
INSERT INTO ong_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wem le wala leletei Ma Ili piti ma lailelepe re luntoluwepe, le lusape le Ma Ili kesi lila le yuwei. ");
INSERT INTO ong_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pe pile lepe rautuwo re fei, pe nou pe Jerusalem, le pe pingitei potei enke teingipetei. ");
INSERT INTO ong_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Le pe wem oli oli pifei winem lite Ma Ili, peilala nange lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Wem Ma Ili wala laptei men nange pite yuwei re tef lepei kolo olo, il olo pinu pratei fei. Il wata pirpolo pe metine le le liri Ma Ili ratei, le le watafei Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Wem linutei, il wata pirpolo pe metine lepe, le liri Ma Ili rounge ratei. ");
INSERT INTO ong_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Il potei pepe so Ma Ili liripe piti lirpei le men nange yeflipiye pepe pe fale pratei, le menemple re fale pratei pinge tisi nele kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Il potei olo nempi rasipe le wem Ma Ili liripe piti lirpei, nempi lepe naro lunkuwepe men nange pepe piti pe ma nampir pratei, le nempi lepe le lunkuku ku mete walem wata pirpolo weli piti loli nainuku tisi lepe. Le lus re enke pouku kere piti ku ma onposi le ku lupingio tisi men ku ma mingowo me piti ma mratei moporo. ");
INSERT INTO ong_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Weli lepe, le lini luwouku ku mete piti mratei mire munkunum le minemple re miso palu kolo olotei. ");
INSERT INTO ong_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ma Ili laisi metine lele piti lilape il pele lau, nange lele Jon liti kaptetei. ");
INSERT INTO ong_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Le lau piti lirpepe mete lire weli fei lepe. Jon liti kaptetei, le lau piti lirpepe mete soma pe yeflipiye ma pingitepe il pele le pe ma pulpope. ");
INSERT INTO ong_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon liti kaptetei, le lila weli lau piti ma laltepe mete kolo olo, wolo le linu lau piti lirpepe lire weli fei lepe. ");
INSERT INTO ong_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Weli fei lepei Le teingitei, Le lau lini luwope mete yeflipiye pite tef lepei. ");
INSERT INTO ong_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Il wuso weitei pire metine lepe, le fale ratei tef lepei le le lotei so Ma Ili liri piti laptei mete re men nange pite tef lepei lepe, wolo mete olo puluwo matufuwo kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Le lau falepe mete pite uf tef lele lotei, wolo mete nange peletei pepe, pe olo kesi paltei potei kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mete ilepe ausi kesi paltei potei le pe pulpowo, le le so lulpope lirpolo pe miso fale pire eple pite Ma Ili pele. ");
INSERT INTO ong_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pe fale pire eple pite Ma Ili pele pingowo tisi liti ku mete pite tef lepei lepe lom? Olo. Tisi liti yaire emare piti tef lepei lepe, pe pilape eple pelpe pingowo tisi nele, le ku mete wuso fale mire eple pite Ma Ili pele pepe, ku mingowo tisi nele, wusoli Ma Ili lotei le kanouku piti ma fale mire eple pele le le lotei ma yaitei ili piti luntoluku. ");
INSERT INTO ong_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Il weitei pire metine wape, le le ratei leingalouku. Ku mulwepe singe pele le wai pele piti onom manoukutei le wai pele piti lingiepe il punkom pite Ma Ili pele. Ma Ili watowo singe fei pepei wusoli Le ninge neleiyeyetei lele. ");
INSERT INTO ong_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon liti kaptetei, le lirpei nomnaipe liri le. Jon lirkilau lirpei liri lolpepei, “Metine lepei so ki kirpeise kiri lepe wem ki kirpei kolo, ‘Le lulteiki lingi lau, wolo le olo singetei le ki olo wusoli ki wala ema nilaiki kolo olo, le le olo linu ratei fei.’” ");
INSERT INTO ong_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Le olo onom manoukutei le le so lirkilau lailolouku re luntoluku epli wem oli oli. ");
INSERT INTO ong_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Il lipi pite Moses pepe, Ma Ili watowo Moses le le kanowo piti il polwepe mete piti pe ma pingiepe il lipi fei pepe le pe ma pratei poporo. Wolo Jisas Krais laule kusauku lire wai pite Ma Ili pele piti onom manouku, le wai pele piti ku ma mingiepe il punkom pele. ");
INSERT INTO ong_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Minemple re puluwo Ma Ili kolo olotei. Ninge neleiyeyetei lele lepe, le watafei Ma Ili lotei, le le lire yaitei rounge tifei tire noute malfem, le so laule kosauku lire Ma Ili lepe. ");
INSERT INTO ong_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Fei, mete lipi pite Juda, pe paisipe mete ilepe pelpe piti peptawi siye paptowo Ma Ili, le ilepe pite alpe lite Livai, pe pe falowo Jon liti kaptetei le pe peletei polpepei, “Ye minele?” ");
INSERT INTO ong_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon lirepe mingim kolo olo, wolo le lirpei nomnaipe liri lotei lolpepei, “Ki Krais kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Ye minele? Ye Ilaija lom?” Pe peletei. Jon namti lirpepe lolpepei, “Olo, ki Ilaija kolo olo.” Fei pe nou peletei, “Ko ye metine nimou wuso ku ratowo lepe lom?” “Olo,” le nou lirpepe. ");
INSERT INTO ong_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Leye lo pe pirpei polpepei, “Ye ma irpouku ire yotei, ye minele? Ku ma kapi il nou me mirpepe wuso paitouku mau pepe. Ye irpei ire yotei, ye minele?” ");
INSERT INTO ong_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon liripe il pite metine nimou Aisaia namti lirpepe lolpepei, Aisaia lirpei lireiki ki lirpolo “Metine nele lailolo ratei tef oli era re telmane ye yawi, lirpei lolo, ‘Ise kesi tisi yaltei tuwopou piti Apa Ili ma lingowo.’” ");
INSERT INTO ong_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Fei mete ilepe pite Farisi wuso mete lipi pelpe paisipe pe falowo Jon lepe, ");
INSERT INTO ong_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","pe peletei polpepei, “Wuso ye Krais, lo Ilaija lo metine nimou nele kolo olo, le piti men ye kaptetei mete?” ");
INSERT INTO ong_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon namti lirpepe lolpepei, “Ki kaptetei kire tipe yawi, wolo metine nele piti lile leingaloise nimin lepe, ise olo yirowo onom. ");
INSERT INTO ong_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Le ma lulteiki lingi lau wolo ki metine teingi piti nenfaripe foiye pite ire filengi pele kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Menmen fei pepei, pe fale Betani lato wof Jodan plen lau liti epli fale, tulum wuso Jon kaptetei mete ratei lepe. ");
INSERT INTO ong_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Fei, nolowi Jon luluwo Jisas wuso karowo le lepe, le le lirpeiye, “Sipsip ninge lite Ma Ili lele min lepei wuso Ma Ili laltei lau piti ma la lungwipe il olpe pite mete piti tef. ");
INSERT INTO ong_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Le lotei fei lepei so ki kirpei kiri lepe, wem ki kirpei kirpolo, ‘Metine nele ma lulteiki lingi lau wolo le olo singetei le ki olo, wusoli ki wala ema nilaiki kolo olo le le olo linu ratei fei.’ ");
INSERT INTO ong_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ki kutei re kirowo onom wolo ki ke kaptetei mete kire tipe piti ma mete pite Israel ma puluwo matufuwo le minele.” ");
INSERT INTO ong_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon liti kaptetei le nampli lirpei lire menmen wuso le lulwepe pepe, lirpei lolo, “Ki kuluwo Riri Teingi lato teplai yuwei le le litipi lau watafei nafle malpu, le le luwalo lifowo. ");
INSERT INTO ong_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ki wala kirowo onom wolo Ma Ili wuso laiteiki kau piti kaptetei mete kire tipe lepe, Ma Ili lepe, le lirpeiki lolpepei, ‘Ye ma uluwo Riri Teingi litipi lau lifowo metine nele, metine fei lepe soma kaptetei mete lire Riri Teingi lepe.’ ");
INSERT INTO ong_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ki kuluwo fei le ki kirpeise, le ninge lite Ma Ili.” Jon lirpepe pepe. ");
INSERT INTO ong_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nolowi nenpe Jon liti kaptetei nou le lile tulum fei lepe liringe pupam twinges tele, ");
INSERT INTO ong_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","wem le luluwo Jisas lilele lau le, le lirpeiye, “Sipsip ninge lite Ma Ili lele min lepei.” ");
INSERT INTO ong_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pupam twinges tele wuso tingitowo lirpei il pepei, le te tulsi Jisas. ");
INSERT INTO ong_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas weitei lulwenge wuso tulsi te lepe, le le loutetei lolpepei, “Ko ise rounge yau yinta men?” Le te rounge namti tirpowo tolpepei, “Rabai, ye ratei fei linei?” (Il pal piti Rabai pirpei polo le metine piti leptalo mete.) ");
INSERT INTO ong_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Rounge yau yuntoli.” Jisas namti lirpenge. So te rounge tiri Jisas pepi pe le te rounge tuluwo winem wuso Jisas ratei lepe le te tiri Jisas pepi petei wusoli epli weitei le piti ma lautile le le olo ningliye. ");
INSERT INTO ong_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Pupam twinges tite Jon liti kaptetei, te wuso tingitowo Jon lirpei le te tulsi Jisas te tepe, nele lepe nange lele Andru. Le winke lite Saimon Pita. ");
INSERT INTO ong_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru frou le lintawo line lele Saimon Pita le le lirpowoye, “Ku werengawo Mesaia fei.” (Il pal piti Mesaia pirpei polo Krais, metine Ma Ili keinio piti laltei lau.) ");
INSERT INTO ong_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Leye lo Andru kesi Saimon lila le falowo Jisas. Jisas luluwo Saimon le le lirpeiye, “Ye Saimon, ninge lite Jon. Nange nele leiye ma pinaiye pirpolo Sifas.” (Il Grik pirpei polo Pita, le il pal pelpe pirpei polo “Erau”.) ");
INSERT INTO ong_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nolowi Jisas onposi piti ma le Galili. Le lerengawo Filip le le lirpowoye, “Ye au ireiki we.” ");
INSERT INTO ong_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Filip lite uf Betsaida, le Andru re Saimon, te rounge re ratei uf fei lepe.) ");
INSERT INTO ong_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip lintawo Nataniel le le lirpowo lolpepei, “Ku merengawo metine wuso Moses laptei il lirpei liri paitei Il Lipi pepe, le mete emarengi re wuso paptei il pirpei piri lepe. Le Jisas, ninge lite Josep, le le lite uf Nasaret.” ");
INSERT INTO ong_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Menele teingi miso fale uf Nasaret?” Nataniel leletei. “Au weli le ye ma uluwo.” Filip namti lirpowo Nataniel. ");
INSERT INTO ong_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Wem Jisas luluwo Nataniel le fale lirowo malfem, Jisas lirpei liri lolpepei, “Metine lepei le lite Israel punkom, le le metine piti lirpei lempesipe mete kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Fei Nataniel leletei Jisas lolpepei, “Ko ye olomen so ye retaiki lepe?” Jisas namti lirpowo Nataniel lolpepei, “Filip wala linaye kolo olo, le ki olo kinu kuliye fei wem ye ratei ifau pau.” ");
INSERT INTO ong_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel namti lirpeiye, “Ye metine piti eptalo mete, ye Ninge lite Ma Ili. Ye metine ili piti untoluwepe mete pite Israel.” ");
INSERT INTO ong_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Fei Jisas lirpeiye, “Ye ulpoiki wusoli ki kirpeiye kirpolo ki kinu kuliye fei wem ye ratei ifau pau lepe lom? Ye ma ulwepe menmen lipi, le il fei kirpeiye pepei pepe olo kumpu.” ");
INSERT INTO ong_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Le Jisas lirpepeye, “Ki kirpeise punkom, ise miso yuluwo teplai yuwei lungo le ririm pite Ma Ili pele ma punwei pe teplai yuwei le pe pitipi pau Ninge lite Metine Wape. ");
INSERT INTO ong_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Epli wem twinges re fei, mete pite uf Kana, lato tef ili lite Galili, pe papli oweli lipi piti metine nele lire moto roum maiteneme. Nimou pite Jisas re ne nulwepe, ");
INSERT INTO ong_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","le Jisas liripe pupam pele re, mete pite Kana paptei il pirpepe piti ma pe piripe pepi paplei oweli lipi pepe. ");
INSERT INTO ong_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wem pe paplei wain tipeluwi pepe pe yalipe, nimou pite Jisas nirpowo nolpepei, “Pe wain tipeluwi oloye ko, paplei yalipeye.” ");
INSERT INTO ong_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Fei Jisas namti lirpene nimou pele lolpepei, “Ko ye moto, ye ma irpeiki piti kesio towa menele kolo olo, wusoli wem fei lepei olo, loporo piti ki ma kolomen re kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Leye lo nimou pele nirpepe mete piti paltei wain tipe watepe nimoure mete piti palei lepe, nirpepe nolpepei, “Il menemple le lirpeise, ise ma yingiepe.” ");
INSERT INTO ong_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Fei mete pite Juda, pe pingiepe il wuru piti pungungu re kaptetei men nange pelpe wusoli pe onposi pirpolo pe ma pingiepe fei polpepe soma Ma Ili ma onom teingine lasiepe. Min polpepei so winem wuso Jisas liripe paplei oweli lipi pifei lepe, yaitei lite winem lepe le laptei paingelem lipitei pire eti plen poungo le niliyeye (6), laptei pire tipe pifei. Paingelem pepe, mete pite Juda pelpe paploupe era le pe narwipe pinge leinginim le pe so palfo tipe liripe lifei piti pe ma pungungu re kaptetei men nange pelpe. ");
INSERT INTO ong_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas lirpepe mete piti paltetei wain tipe lepe, lirpepe lolpepei, “Yalili tipe yalfo era paingelem pepei.” Le pe palfo tipe era paingelem pepe, palfo tipe le fale lire era paingelem nemi loparu. ");
INSERT INTO ong_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Leye lo Jisas lirpepeye, “Ise fei ma yalfo tipe wuso lifei era paingo nele lepe le ise yila ye watowo metine piti linuse re luntolise watepe nimoure mete oweli re wain tipe piti paplei pepe, yalfo tipe lepe ye watowo lalei lingitowo wo.” Pe palfo tipe lepe pila pe watowo metine piti linuwepe re luntoluwepe pepe, ");
INSERT INTO ong_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","le le lalei tipe lepe lingitowo, le tipe lepe olo weitei lire wain tipe fei. Le lironom piti pe kali wain tipe lepe lato fei linei, (wolo mete wuso palfo tipe watowo lepe, pe pretai.) So metine piti linuwepe re luntoluwepe mete piti paptei oweli re wain tipe watepe nimoure mete piti paplei pepe, le linawo metine lotei piti laisene moto nepe, ");
INSERT INTO ong_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","le le lirpowo lolpepei, “Mete yeflipi pepe pe ma pinu paltei wain tipe teingitei lepe, pinu paltei watepe nimoure mete wuso pinape pau pepe, ma palei tani wo le wem pe pini purungo, pe soma paltepe wain pulou lepe palei pingi. Wolo ye olpepe kolo, wain tipe teingitei lepe ye inu watepe kolo olo, leiye wala lifei.” ");
INSERT INTO ong_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisas linu lolpepe menmen fei pepei ratei Kana lato tef lite Galili wem le lirpei le tipe nimou weitei lire wain tipe, le fei pepei le kusape pupam pele lire singe lipi pele le pupam pele pulpowo. ");
INSERT INTO ong_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pe paplei oweli lipi pepe re fei, Jisas lire nimou pele, winkem re pupam pele pepi pe Kaperneam, le pe pratei epli wem yaipiyeye. ");
INSERT INTO ong_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Wem lire malfem piti mete pite Juda ma papli oweli lipi piti onposio wem wuso Ma Ili kaniepe manre yaire pelpe pau tani Isip lepe, wem fei lepe olo lau lire malfemye, liso Jisas le Jerusalem. ");
INSERT INTO ong_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jisas le winem lite Ma Ili le le lulwepe mete paptei bulmakau, sipsip re naflepem malpum pepe, le mete paisepe, le mete piti kapi era pite uf mete nemple le pe namti watepe era pite mete piti Juda. ");
INSERT INTO ong_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jisas kapi foiye kumpu pepe yaruwepe pingi nemple le le topwepe lapiri piti ma lesiepe watafei foiyou teingo niliyeye ili lepe. Le Le liri foiyou lepe laptu siye pepe, laptu naro pe tani winem lite Ma Ili. Jisas laptu sipsip re bulmakau naro pe yawi tani winem lite Ma Ili lepe, le ponu pite mete wuso kapi era pite uf mete nemple le pe namti watepe pite mete piti Juda, pe re ponu pelpe Jisas lesi weisipe le era pelpe pepe puwalo pire flaye. ");
INSERT INTO ong_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Le le lire il singe lirpepe mete piti paptei naflepem malpum pepe, Jisas lirpepe mete fei pepe lolpepei, “Kapi naflepem peise yilape ye yawi tani winem fei lepei. Winem lepei, le lite Eiya leiki, le ise ma weisi fale lire winem liti yaptetei re yaisesipe oweli men nange pepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Fei pupam pele pe onposiepe il piti paitei yousi wuso pirpei polo, Ma Ili, winem leiye ki onom puwoltei kiri le onom peiki olo nireiki flistei wem mete pirowo oli.” ");
INSERT INTO ong_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mete lipi pite Juda pepe pau peletei Jisas polpepei, “Ye irpei le menmen ma lotei lire tute fale soma ku mretai ye kapi il piti ye ma aptu mete piti paptetei re paisesipe oweli pepe, ye ma aptu tani winem lite Ma Ili lepe?” ");
INSERT INTO ong_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisas namti lirpepe lolpepei, “Wuso ise yaltutu winem lepei, le epli wem twinges niliyeye fei ki miso nou keila.” ");
INSERT INTO ong_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mete lipi pite Juda pepe nou peletei Jisas polpepei, “Ye miso nou eila winem lepei yali ire epli wem twinges niliyeye lom? Ku meila winem lite Ma Ili lepei eringi wurutei (46) fei ku so meila yali.” ");
INSERT INTO ong_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wolo winem lite Ma Ili lele wuso Jisas lirpei liri lepe, le lirpei liri topo tale lele lotei. ");
INSERT INTO ong_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Liso wem Jisas la le Ma Ili nou leila, pupam pite Jisas pele nou onposiepe il pele wuso lirpei pepe le pe pulpope il piti paitei yousi pepe le il wuso Jisas lirpei pepe. ");
INSERT INTO ong_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Wem mete piti Juda papli oweli lipi piti onposio wem wuso Ma Ili kaniepe manre yaire pelpe pau tani Isip lepe, wem fei lepe Jisas wala ratei Jerusalem le mete wuru pulpowo wem pe pulwepe menmen wuso potei pire tutu fale wem Jisas lirpei. ");
INSERT INTO ong_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wolo Jisas retape enke pite mete yeflipiye le le lulpope kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Metine minele re lirpowo lire enke pite mete kolo olo, wusoli Jisas lotei retape enke pelpe leinginim. ");
INSERT INTO ong_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Metine nele nange lele Nikodemus, le metine ili piti liripe ilepe wane pele pepi pesio towa liti pinuwepe mete pite Juda, le le lite alpe liti Farisi. ");
INSERT INTO ong_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mulpou nele Nikodemus le falowo Jisas le le lirpowo Jisas lolpepei, “Rabai, ku mretai molpepei Ma Ili laiteiye au piti eptalo mete. Wuso Ma Ili liri metine nele rounge ratei kolo olo, metine fei lepe le miso lirpei le menmen potei pire tute fale watafei ye olpepe lepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisas namti lirpowo Nikodemus lolpepei, “Ki kirpeiye punkom, wuso metine nou fale teingi yefli kolo olo, Ma Ili miso lailolowo re luntoluwo metine fei lepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Fei Nikodemus nou leltei Jisas lolpepei “Metine ili lire lotei re fei le ma nou fale teingi yefli fei lolomen? Le miso nou linki yofu lite nimou pele le ne ma nou nila kolo olotei.” ");
INSERT INTO ong_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Wolo Jisas nou lirpowo Nikodemus lolpepei, “Ki kirpeiye punkom kolpepei, wuso metine nou fale teingi yefli lire tipe re Riri Teingi kolo olo, metine fei lepe Ma Ili miso lailolowo re luntoluwo kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Metine fale wem nimou re yaitei mele miti tef lepei roum mila, wolo le ma fale teingi yefli wem Riri Teingi lite Ma Ili lau lunkuwo. ");
INSERT INTO ong_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","So ye ma inlele yotei kolo olo wem ki kirpei kolo ise yeflipiye ma nou fale teingipe yeflipi. ");
INSERT INTO ong_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yuf lini liye liye re le lire onom pele. Ise yingitowo minu lele wolo ise yironom le lini lile fei linei lau lo le ma lini fei linei le. Min watafei Riri Teingi piti lunkuwepe mete pepe, ise olo yuluwo kolo. Wolo Le miso leilape mete enke piti pe ma tounga pesipe wai olpe le pe pingiepe piti teingipe.” ");
INSERT INTO ong_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Fei pepei ma fale polomen?” Nikodemus leletei Jisas. ");
INSERT INTO ong_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Le Jisas namti lirpowo lolpepei, “Ye metine ili piti eptalo mete pite Israel, wolo ye ironom iripe menmen fei pepei lom? ");
INSERT INTO ong_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ki kirpeiye punkom, ku mirpei miripe menmen wuso ku mretape pepe le ku mirpeise miripe menmen wuso ku mulwepe pepe, wolo nemple peise re paptei mingim pire il pouku kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Wuso ye ulpoiki kolo olo wem ki kirpeiye kire menmen piti tef lepei, ye olomen ma ulpoiki wem ki kirpeiye kire menmen pite yuwei? Miso olo. ");
INSERT INTO ong_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Metine nele re lunwei le yuwei kolo olotei, Ninge lite Metine Wape, le loteteiye lato yuwei so litipi lau lepe.” Jisas lirpei lapulu. ");
INSERT INTO ong_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses ratei tef oli era re telmane ye yawi le le kali kapa lesio fale lire tutu, le le so kali topuwo laitei nimpe le le leila nimpe lire tutu kapa lepe, leila lari lile tef oli era re telmane ye yawi lepe. Le Ninge lite Metine Wape re, pe ma tingeli laitei nimpe le pe ma peila lire nimpe lile watafei Moses leila tutu kapa lire nimpe lile lepe. ");
INSERT INTO ong_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Pe ma peila Ninge lite Metine Wape soma mete yeflipiye wuso pulpowo pepe, pe miso kali nempi liti pratei pingi wem wem. ");
INSERT INTO ong_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ma Ili, le ninge neleiyeyetei lele, wolo le onom puwotei liripe mete yeflipiye piti tef le le so watepe ninge neleiyeyetei lele lepe. Ma Ili lolpepe soma wem mete yeflipi wuso pulpowo lepe, pe yeflipiye miso pa pelengi kolo olo, wolo pe miso kali nempi liti pratei pingi wem wem. ");
INSERT INTO ong_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wusoli Ma Ili laisi ninge lele lau tef lepei piti ma kapi il laptei liripe mete kolo olo, wolo Ma Ili laisi ninge lele lau piti ma kanouku ku mete piti tef. ");
INSERT INTO ong_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Metine minele wuso lulpowo Ninge lite Ma Ili lepe, metine fei lepe Ma Ili miso kapi il laptei liri kolo olo. Wolo metine minele wuso lulpowo Ninge lite Ma Ili kolo olo, metine fei lepe Ma Ili olo kapi il laptei liri fei, wusoli metine lepe le lulpowo Ninge neleiyeyetei lite Ma Ili lele lepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ma Ili kapi il laptei liripe mete lolpepei, weli lele olo lau loli ratei tef lepei fei, wolo mete onom puwol wai oli lelpe liti pratei pire munkunum le pe pinauli weli fei lepe, wusoli pe pingiepe il olpe. ");
INSERT INTO ong_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Metine minele liti lingiepe il olpe, metine fei lepe ma onom pesi weli le le ma laplingi il olpe pele wusoli le linaulo piti laptei fale alepe nimin. ");
INSERT INTO ong_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wolo metine minele piti lingiepe il teingipe punkom, metine fei lepe ma fale lile weli alepe nimin, le le lolpepe soma le kosai lotei alepe nimin piti le lingiepe il pite Ma Ili le le lesio towa teingi. ");
INSERT INTO ong_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Wem kari re fei, Jisas liripe pupam pele pepi pe tef lite Judia. Jisas ratei lepe epli wem wuru, le le kaptetei mete. ");
INSERT INTO ong_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon liti kaptetei, le re kaptetei mete ratei Ainon, lato malfem lire uf Salim wusoli tipeluwi wuru pifei tulum fei lepe. Mete pe falowo le le kaptetei. ");
INSERT INTO ong_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Wem fei lepe pe wala paltei Jon lifei winem oli kolo, wala olo.) ");
INSERT INTO ong_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Fei, Jon liti kaptetei lepe, pupam ilepe pele pire metine nele lite Juda, pe pepi pire il pirpei pura nemple pire wai liti pungungu le pe miso fale teingipe pire Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Le pe so pe falowo Jon liti kaptetei le pe pirpowo polpepei, “Ko ye metine piti eitalouku lepe, ye retawo metine wuso nempis linu lireye ratei wof Jodan plen liye lepe le ye wuso irpouku iri lepe? Le fei re kaptetei mete le mete yeflipiye karowo pe piti le ma kaptetei.” ");
INSERT INTO ong_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Fei, Jon liti kaptetei namti lirpepe lolpepei, “Menmen re miso falowo metine yawi kolo olo, Ma Ili liri ratei soma menmen fei polpepe pepe pe miso falowo metine fei lepe. ");
INSERT INTO ong_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ise isotei yingiteiki kirpeise kolpepei, ‘Ki Krais kolo olo, wolo Ma Ili laiteiki kinuwo kau.’ ");
INSERT INTO ong_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Wem metine laisene moto, lotei piti moto pau lepe soma laisene moto nepe, le numu lele ma lile laptowo mingim. Le wem moto pau lepe le lirpei, numu lele miso onom teingine piti lingitepe il pele. Ki re, onom peiki teingine so nolpepe. ");
INSERT INTO ong_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Metine piti lingeiki lau lepe, nange lele ma fale ili, mete wurutei ma paptowo mingim, le ki ma olo. Nange leiki ma fale ili watafei le lepe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Le piti lato yuwei lau lepe, nange lele ma ili linuwepe mete yeflipiye piti tef lepei. Le metine liti tef lepei lepe, le liti tef lepei le le ma lingiepe il piti tef lepei lirpei. Metine piti lato yuwei lau, nange lele ma ili linuwepe mete yeflipiye piti tef. ");
INSERT INTO ong_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Metine piti lato yuwei lau lepe, le ma lirpei lire men nange wuso lulwepe re lingitepe pepe, wolo minemple re pingitepe il pele kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Metine minele piti lingitepe il pele le le lulpope, le ma kosape nimoure mete nemple pepe lirpolo il wuso Ma Ili lirpei pepe olo punkom. ");
INSERT INTO ong_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Metine wuso Ma Ili laisi lau lepe, le lirpei il pite Ma Ili pele, wusoli Ma Ili lusa riri lele lirkilau lunkuwo metine fei lepe. ");
INSERT INTO ong_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yaitei olo onom puwoltei liri ninge lele le men nange re, yaitei watowo ninge singe piti ma luntoluwepe. ");
INSERT INTO ong_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Metine minele piti lulpowo ninge, metine fei lepe le miso kali nempi liti ratei lingi wem wem. Le metine minele piti linpim il pite ninge lepe, metine fei lepe le miso kali nempi liti ratei lingi wem wem kolo olo wusoli onom kotu pite Ma Ili pele ma niri ratei wem oli oli, le le ma lila moingi ili. ");
INSERT INTO ong_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mete piti Farasi, pe pingitei wuso Jisas lirkilau weisipe enke pite mete wuru le le kaptetei piti ma pulsi, wolo Jon liti kaptetei olo, le lolpepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Jisas lotei kaptetei mete kolo olo, pupam pele so kanowo piti kaptetei pepe.) ");
INSERT INTO ong_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Liso wem Jisas lingitepe il wuso mete piti Farasi pirpei pepe, le lusa tef lite Judia le le nou le tef lite Galili. ");
INSERT INTO ong_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jisas ma le raltei tef lite Samaria, le le soma le fale tef lite Galili. ");
INSERT INTO ong_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jisas le fale uf nange lele Sikar, lato tef lite Samaria. Uf lepe le lato malfem lire tef kumpu wuso Jekop lalowi watowo ninge lele Josep lepe. ");
INSERT INTO ong_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tipe oi lite Jekop lele re lato tef kumpu fei lepe. Le Jisas wuso lilele linge tisi ulel le lepe le le weitei lifei mingo lite tipe oi lepe, lifei laltei yef. Wem fei lepe epli olo lau lile niminye. ");
INSERT INTO ong_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Fei moto nenpe pite Samaria, ne nau piti ma nalfo tipe. Le Jisas lirpene lolpepei, “Ye alfo tipe waiki kalei.” ");
INSERT INTO ong_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Wem fei lepe pupam pele olo pe uf Sikar lepe piti ma paisepe oweli piti paplei. ");
INSERT INTO ong_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Moto piti Samaria nepe, ne namti nirpowo Jisas nolpepei, “Ye lite Juda le ki pite Samaria. Ye olomen so eiteiki ire tipe piti waiye alei lepe?” (Pe wai lelpe, minki paingelem re pite mete pite Samaria pelpe, mete pite Juda miso kapi piripe kolo olo.) ");
INSERT INTO ong_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Fei Jisas nou lirpene moto pite Samaria nepe lolpepei, “Wuso ye retai menmen teingipe piti Ma Ili ma watepe mete le ye retai ki metine minele so keiteiye piti waiki tipe liti kalei lepe, ye miso eiteiki le ki ma waiye tipe liti waiye nempi le ye ma ratei ingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Leye lo moto nepe ne namti nirpeiye, “Ili leiki, ye mili liti ire englei tipe kolo olo, le tipe oi re olo lautiletei. Le tipe liti waiki nempi liti ratei kingi wem wem lepe, ye ma kali lato fei linei? ");
INSERT INTO ong_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ku mani louku Jekop so wauku tipe oi fei lepei le le lotei, eple tuleingi pele le sipsip pele re, pe yeflipiye palei tipe oi fei lepei. Le ye onposi irpolo ye ili inuwo Jekop lom?” ");
INSERT INTO ong_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisas namti lirpene lolpepei, “Minele piti lalei tipe lite oi fei lepei, le ma nou yif punko. ");
INSERT INTO ong_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wolo minele piti lalei tipe wuso ki ma watowo lepe, le miso nou yif punko kolo olo. Tipe wuso ki ma watowo lepe, le ma falele wata pirpolo etingi lepe le le ma watowo metine lepe nempi liti ratei lingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Fei moto pite Samaria nepe, ne nirpowo Jisas nolpepei, “Ili leiki, ye waiki tipe fei lepe soma ki ma nou yif punko kolo olo, lo tipe oi fei lepei re ki ma nou kau kalfo tipe kolo oloye.” ");
INSERT INTO ong_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Leye lo Jisas lirpeneye, “E irpowo munge leiye le ye so nou au.” ");
INSERT INTO ong_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Olo, ki munge olo.” moto nepe ne namti nirpowo Jisas. Le Jisas nou lirpene lolpepei, “Ye irpei tuwopou wem ye irpei irpolo ye munge olo. ");
INSERT INTO ong_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ye inu aisipe mungarem pire esi plen poungo (5), le metine wuso ye fei iri roum ratei meme, le olo munge nange leiye kolo olo. Ye irpeiki punkom.” ");
INSERT INTO ong_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Fei moto pite Samaria nepe, ne namti nirpowo Jisas nolpepei, “Ili leiki, ki fei kretai ye metine nimou. ");
INSERT INTO ong_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Eiya mani peiki piti Samaria, pe rautuwo Ma Ili pratei tumun fei lepei. Wolo ise pite Juda, ise yirpei yolo uf ili Jerusalem soma ku ma me rautuwo Ma Ili lepe.” ");
INSERT INTO ong_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Leye lo Jisas lirpene lolpepei, “Ko ye moto, ye ulpoiki. Wem wala lato, ma wem fei lepe fale, is mete ma rautuwo Eiya Ili ratei tumun fei lepei kolo olo, lo pe ma pe Jerusalem piti rautuwo re kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ise pite Samaria, ise retawo minele piti ise ma rautuwo re kolo olo. Ku pite Juda, ku mretawo minele piti ku ma rautuwo wusoli ku pite Juda miso kaneise retawo tisi piti Ma Ili ma kaniepe nimoure mete. ");
INSERT INTO ong_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wolo wem ma lau, le wem fei lepe olo fale fei wem nimoure mete piti rautuwo Eiya Ili punkomtei pepe, pe ma rautuwo pire onom re il punkom. Eiya Ili lirpei piti nimoure mete ma rautuwo polpepe. ");
INSERT INTO ong_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ma Ili, le Riri, le nimoure re mete wuso rautuwo pepe, pe ma rautuwo pire onom re il punkom.” ");
INSERT INTO ong_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Fei moto pite Samaria nepe ne nirpowo Jisas nolpepei, “Ki kretai kolpepei, Mesaia, pinawo pirpolo Krais lepe, le miso lau. Wem le lau, le miso lirpouku lire il yeflipiye.” ");
INSERT INTO ong_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Leye lo Jisas namti lirpene lolpepei, “Ki kutei so lepe, ki min kireye roum wirpepei lepei lepe.” ");
INSERT INTO ong_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wem me roum wala mirpepei mile, pupam pite Jisas pele pau fale le pe pinlele potei olpe piti puluwo lirine moto nenpe roum mirpei. Wolo pe nele lelpe re lentei lirpolo, “Ko ye inta menele?” Olo. Lo pe peletei Jisas pirpolo “Piti men so ye irine roum yirpepei lepe?” Olo, pe peletei polpepe re kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Leye lo moto pite Samaria nepe ne nusa mili lite tipe ratei le ne nou ne uf Sikar lepe, nirpepe nolpepei, ");
INSERT INTO ong_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ise yaule yuluwo metine nele wuso lirpeiki lire men nange yeflipiye wuso ki kinu kingiepe pepe. Le so Krais lepe lom?” ");
INSERT INTO ong_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Liso mete pite uf kumpu lepe pe naro pe karowo Jisas. ");
INSERT INTO ong_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wem fei lepe pupam pite Jisas pele malfefi Jisas pirpei polo, “Ko ye metine piti eitalouku lepe, ye kapi oweli aplei wo.” ");
INSERT INTO ong_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wolo Jisas namti lirpepe lolpepei, “Ki oweli piti kaplei pepe, ise olo retape kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Liso pupam pele pepe, pe peite nempleye, “Minemple so pau watowo oweli pepe?” ");
INSERT INTO ong_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Fei Jisas lirpepeye, “Ki oweli peiki piti kaplei pepe, ki ma kingiepe il pite metine wuso laiteiki kau lepe, le ki ma kesio towa wuso le waiki piti ma kesio lepe, ki ma kesio ke yaliye. ");
INSERT INTO ong_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Il peise isotei yirpei yolo, ‘anongou twinges te twinges wala pato wem oweli ma poungo.” Ki kirpeise, ise wala yuluwo liom yoporo wo. Oweli olo poungo fei, le ise ma kotuwepe. ");
INSERT INTO ong_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Metine piti kotuwepe oweli, le miso kapi era pele le le miso kotuwepe oweli piti kanowo ratei lingi wem wem. Le lolpepei soma metine piti lapiri oweli le metine piti kotuwepe oweli, te rounges tepiye miso onom teingine. ");
INSERT INTO ong_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Il wuso pirpei polo, ‘metine nele lapiri oweli le nele kotuwepe’, il fei pepe pe pirpei punkom. ");
INSERT INTO ong_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ki kaiteise ye kotuwepe oweli pite liom mete nemple pelpe papiri. Ise yapiri kolo, wolo ise kotuwepe oweli piti mete nemple pelpe papiri.” ");
INSERT INTO ong_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mete wuru pite Samaria wuso pratei uf Sikar lepe, pe pulpowo Jisas wusoli moto wuso niri roum minu mirpei lepe, ne nirpepe nolpepei, “Le lirpeiki lire men nange yeflipiye wuso ki kinu kingiepe pepe.” ");
INSERT INTO ong_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Liso wem mete pite Samaria pe falowo Jisas pe pirpei malfefi piti ma liripe pepi pratei. Le Jisas liripe pepi pratei epli wem twinges. ");
INSERT INTO ong_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mete nou nemple wuru pite Samaria pepe, pe pulpowo Jisas wusoli pe pingitepe il pele wuso leptalo pepe. ");
INSERT INTO ong_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Le pe pirpene moto wuso ninu nire Jisas roum mirpei meme, pe pirpene polpepei, “Ku fei mulpowoye. Ku mulpowo wusoli ye irpouku iri lepe lom? Olo ku mulpowo wusoli ku kutou mingitepe il pele, le ku mretai molpepei le lotei punkom piti kaniepe nimoure mete piti tef.” ");
INSERT INTO ong_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisas liripe mete pite Samaria pepi pratei epli wem twinges re fei, le lusape le le so le Galili. ");
INSERT INTO ong_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jisas lotei linu lirpei nomnaipe lolpepei, metine nimou uf mete nange peletei ma olo pinauli. ");
INSERT INTO ong_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wem Jisas le fale Galili, mete pite Galili pepe pe kesi paltei potei wusoli wem pe pe Jerusalem piti papli oweli lipi piti paplei onposio wem Ma Ili kesipe manre yaire pelpe pau tani Isip, wem fei lepe, pe pulwepe men nange yeflipiye wuso Jisas laptei fale pepe. ");
INSERT INTO ong_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jisas nou le uf Kana lato tef lite Galili, uf wuso Jisas linu lirpei le tipe nimou weitei fale lire wain tipe lepe. Metine nele piti lesio towa lite moli lipi pite Rom, le re lau lifei uf Kana lepe, le ninge kumpu lele olo kainu lato uf Kaperneam. ");
INSERT INTO ong_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wem le lingitei wuso Jisas re olo lato Judia so lau fale Galili ye, metine lepe karowo Jisas le fale luluwo, le le leletei piti ma le Kaperneam le le ma kapi kainu tanio ninge kumpu lepe wusoli le olo kainu olitei piti ma la. ");
INSERT INTO ong_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Fei Jisas lirpowo metine piti lesio towa lite moli lipi piti Rom pepe, Jisas lirpowo lolpepei, “Minemple peise re miso pulpoiki kolo olo, ma pulwepe menmen lipi potei pire tute fale pepe, ma pulwepe wo pe soma pulpoiki.” ");
INSERT INTO ong_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wolo metine lepe namti lirpowo Jisas lolpepei, “Ili leiki, ye ma au ireiki wepi we wo, ninge leiki ma laye.” ");
INSERT INTO ong_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Fei Jisas nou lirpowo metine lepe lolpepei, “Ye e, ninge leiye miso namin ratei.” Liso metine lepe lulpope il pite Jisas, le le leye. ");
INSERT INTO ong_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wem metine lepe, le wala le luwalo tisi ile, mete pele piti pesio towa lele lepe, pe pau fale perengawo le pe pirpowo polpepei, “Ninge leiye teingi ratei.” ");
INSERT INTO ong_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Leye lo metine lepe lepletei liri wem piti ninge kumpu lele lepe, le nou fale teingi lepe. Le pe namti pirpowo polo, “Ninge leiye nou lironom nemul ningli wem epli lile weitei.” (1 kilok) ");
INSERT INTO ong_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Fei yaitei lotei onposi wuso wem fei lepe so Jisas lirpowo lirpolo ninge lele miso teingi ratei lepe. Liso metine lepei lire moto re eple le mete piti piri pepi pratei winem lele pepe, pe yeflipiye pulpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Menmen lipi fei pepei Jisas laptei fale pingi, puwope piti pinu wem le lirpei le tipe nimou weitei lire wain tipe lepe. Jisas laptei menmen fei pepei fale wem le lato Judia lau fale Galili. ");
INSERT INTO ong_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wem kari re fei, Jisas lunwei le Jerusalem piti ma lulwepe papli oweli lipi piti paplei rautuwo Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Uf ili Jerusalem lepe, tipe oi nele lifei laitei wingi piti mete pilape sipsip pelpe pinki pe uf ili Jerusalem lepe. Le tipe oi lepe mete pite Hibru pinawo pirpolo Betesda, le pe pepletei tuluwim twinges te twinges niliyeye pepletei polinemple neinowo tipe oi lepe. ");
INSERT INTO ong_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mete wurutei wuso kainu polomen polomen re pepe, pe paptei pifei tuluwim pepe. Mete piti lutepe pelpe olpe, ire esi pa, ire olpe. Pe pifei pungario tipe ma luroro lotei, ");
INSERT INTO ong_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","wusoli wem niliyeye niliyeye, riri lite Ma Ili ma litipi lau lile tipe oi lepe le le ma lunpiyoyo tipe. Le mete wuso kainu pepe, wem nele lelpe linu lautile le tipe oi lepe wem tipe lururu lotei, metine fei lepe miso nou fale teingi. Metine kainu fei lolomen re wolo le miso nou fale teingi wem le linu lautile le tipe oi fei lepe. ");
INSERT INTO ong_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Metine nele liripe pepi pifei tuluwim pite tipe oi fei lepe, le le olo kainu lato eringi wurutei (38). ");
INSERT INTO ong_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas luluwo wuso letei luwo tuluwim pepe le le retai metine fei lepe olo kainu lato wem uleltei. Liso Jisas leletei metine fei lepe lolpepei, “Ye onposi piti ma nou fale teingi lom?” ");
INSERT INTO ong_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Fei metine wuso kainu lepe, le namti lirpowo Jisas lolpepei, “Ili leiki, ki minemple re pifei lepei piti ma kaneiki peiteiki kautile ke tipe oi re kolo olo. Wem tipe luroro lotei lepe ki keilo piti ma ke, metine nele ma kelautu linu leye le ki olo keinenei katoye.” ");
INSERT INTO ong_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Leye lo Jisas lirpowo metine lepe lolpepei, “Ye eilo kali poyu leiye le ye ilele e.” ");
INSERT INTO ong_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Frouyo fei, metine lepe nou fale teingiye. Le kali poyu lele le le lilele leye. Menmen fei pepei fale epli wem piti mete pite Juda ma pifei yaupe piti onposio Ma Ili, ");
INSERT INTO ong_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","liso mete lipi pite Juda pepe, pe pirpowo metine wuso Jisas kanowo kapi kainu pele tanio lepe, pirpowo polpepei, “Epli wem fei lepei lepe, le wem piti ku ma mifei yaupe onposi Ma Ili le ye ma yaruwepe il lipi pouku wuso ye ma ila poyu leiye.” ");
INSERT INTO ong_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wolo le namti lirpepe lolpepei, “Metine wuso kaneiki nou fale teingi lepe, le lirpeiki lolpepei, “Ye kali poyu leiye le ye ilele e.” ");
INSERT INTO ong_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pe so peletei polpepei, “Metine minele so lirpeiye piti ye ma kali poyu leiye le ye ilele e lepe?” ");
INSERT INTO ong_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wolo metine wuso Jisas kapi kainu tanio lepe, le olo lirowo Jisas onom wusoli mete wurutei pile tulum fei lepe le Jisas frou kotire leye. ");
INSERT INTO ong_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wem kari re fei, Jisas lerengawo metine lepe lifei winem lite Ma Ili, le Jisas lirpowo lolpepei, “Ye untoli, ye fei nou fale teingiye. So ye ma nou ingiepe il olpe kolo olo. Wuso ye nou ingiepe il olpe, moingi men nange olpetei ma faleye.” ");
INSERT INTO ong_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Leye lo metine lepe lusa winem lite Ma Ili lepe le le le lirpepe mete lipi pite Juda pepe, lirpepe liri Jisas wuso kapi kainu pele tanio lepe. ");
INSERT INTO ong_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Min polpepei so pe watowo Jisas moingi wusoli le kapi kainu tanio metine fei lepe epli wem piti pe ma pifei yaupe onposio Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisas namti lirpepe mete lipi pite Juda pepe lolpepei, “Eiya leiki wem oli oli re lesio towa, le ki re ma kesio towa.” ");
INSERT INTO ong_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Il fei pepei pe pirkilau kotuwepe enke pite mete lipi pite Juda le pe onposi piti ma petesi Jisas la. Jisas yaruwepe il lipi piti mete pite Juda wuso pirpei polo pe ma pifei yaupe epli wem piti pe ma pifei onposio Ma Ili, Jisas yaruwepe il lipi pepe poteteiye kolo olo, wolo le nou lirpei lasiepe lirpolo Ma Ili, le yaitei nange leletei. Wem Jisas lirpei il fei pepei, le wata pirpolo le lire Ma Ili rounge tante noute tepe. ");
INSERT INTO ong_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Liso Jisas namti lirpepe mete lipi pite Juda pepe, Jisas lirpepe lolpepei, “Ki kirpeise punkom, towa lolomen lolomen re ninge miso lesio lire esi lus pele lotei kolo olo. Le luluwo yaitei lele lotei lesio towa fei lepe liso ninge re ma lingowo piti lesio towa fei lepe. Yaitei lesio towa menmen, ninge re ma lesio towa fei lepe. ");
INSERT INTO ong_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yaitei lotei onom puwol ninge leletei le le kosawo lire men nange pele yeflipiye wuso yaitei lotei lesiepe pepe. Yaitei miso kosawo ninge lire menmen lipitei watafei le kusawo lire menmen kumpu min ise fei yulwepe pepe wolo ise ma yinlele isotei yasiepe. ");
INSERT INTO ong_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Min watafei yaitei lotei, le nou leilape mete wuso pa pepe le le nou watepe nempi liti nampir pratei, so tisi niliyeye fei lepe ninge re ma lingowo piti watepe mete nempi liti pratei. Ninge lotei onom pele, le keiniepe mete piti ma watepe nempi liti pratei. ");
INSERT INTO ong_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yaitei lotei lesio towa piti kapi il laptei liripe nimoure mete kolo olo. Le watowo ninge singe piti lesio towa fei lepe, ");
INSERT INTO ong_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","le yaitei lolpepei soma nimoure mete yeflipiye ma peila nange lite ninge lele watafei pe peila nange lite yaitei lotei lepe. Minemple wuso peila nange lite ninge kolo olo, yaitei wuso laisi ninge lau lepe re, pe peila nange lele kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ki kirpeise punkom, minele piti lingitepe il peiki le le lulpowo metine wuso laiteiki kau lepe, metine fei lepe le ma kali nempi liti ratei lingi wem wem. Metine fei lepe Ma Ili miso kapi il laptei liri kolo olo, wolo le ma wata pirpolo le lusa tisi oli piti la le le nou weitei lingowo tisi teingi piti ma namin ratei. ");
INSERT INTO ong_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ki kirpeise punkom, wem wuso ise wala ratei yungario lepe, le olo fei faleye, wem mete wuso pa pepe pe miso pingitepe il manu pite ninge lite Ma Ili. Le pe piti pingitowo lepe, pe miso nou peilo nampir pratei. ");
INSERT INTO ong_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Min watafei yaitei lotei, le watepe mete nempi liti pratei, so ninge re le kapi singe elpesipe pite yaitei lele piti ma watepe mete nempi liti pratei. ");
INSERT INTO ong_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Le yaitei lotei watowo ninge singe piti kapi il laptei liripe mete piti tef wusoli le Ninge lite Metine Wape. ");
INSERT INTO ong_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ise yinlele isotei yasiepe il fei pepei kolo olo. Wem ma fale, wem mete wuso pa le pe paptei pepe, pe ma pingitepe il manu pele. ");
INSERT INTO ong_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Le pe ma nou peilo tani tef wuso paptei pato pepe, pe wuso pingiepe il teingipe pepe, pe ma nou peilo piti ma nou nampir pratei. Le pe piti pingiepe il olpe pepe, pe ma nou peilo wolo pe ma pila moingi ilitei.” ");
INSERT INTO ong_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Towa menmen re ki kesio kire onom peiki kutei kolo olo. Ki kingitepe il piti Eiya le ki so kingiepe piti kapi il kaptei kiripe mete. Le wem ki kapi il kaptei kiripe mete, ki kingiepe tuwopou wusoli ki kingiepe il wuso ki kutei onposi piti kingiepe pepe kolo olo, wolo ki kingiepe il pite metine lotei wuso laiteiki kau lepe.” ");
INSERT INTO ong_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Wuso ki kirpei re kingiepe il peiki kuteteiye, ise ma yingiteiki kolo olo, le il peiki re ma kere yaupe. ");
INSERT INTO ong_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wolo metine nele le lirpeise lireiki ki le ki kretai, il pele wuso lirpei lireiki ki pepe olo punkom. ");
INSERT INTO ong_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ise yaisipe mete peise pilape il pe falowo Jon liti kaptetei, le le lirpei il punkom lireiki ki. ");
INSERT INTO ong_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ki onposi piti metine nele ma lirpei lireiki ki lom? Olo. Ki keilape il pite Jon liti kaptetei lepe, keilape kirpeise soma ise ma yulpope le Ma Ili ma kaneise. ");
INSERT INTO ong_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon liti kaptetei, le wata pirpolo nongo weli nele loli nainunuse lepe. Le il pele wata pirpolo pini nainunuse pepe le ise enke teingipe yasiepe wem kurauye. ");
INSERT INTO ong_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Wuso ise yulpope il wuso Jon lirpeiki ki kolo lepe ise ma onposio towa leiki piti kesio lepe, ise yuluwo le ise miso retai, ki kesio towa ilitei so ise ma yulpoiki. Towa wuso Eiya waiki piti kesio lepe, ise yuluwo le ise miso retai Eiya laiteiki le ki so kau. ");
INSERT INTO ong_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Eiya wuso laiteiki kau lepe, le lirpei il punkom lireiki ki. Ise yingitepe il manu pele re kolo olotei, le mi mati pele re, ise olo yuluwo kolo. ");
INSERT INTO ong_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Le il pele re ise yesiepe pultei enke peise kolo olo wusoli ki kutei so Eiya laiteiki kau lepe, wolo ise yulpoiki kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ise yungunape il piti paitei yousi wusoli ise onposi yirpolo il fei pepe miso waise nempi liti ratei yingi wem wem le il potei pepe so pirpei pireiki ki lepe. ");
INSERT INTO ong_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wolo ise yinaulo piti yulteiki ki le ise ma kali nempi liti ratei.” ");
INSERT INTO ong_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ki onposi piti mete ma peila nange leiki kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wolo ki kretaise, ki kretai kolpepei, ise enke peise leinginim, ise onom puwol Ma Ili kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Eiya leiki laiteiki le ki so kau wolo ise tounga peteiki. Le wem metine nele lau lire onom pele, ise ma kesi yaltei isotei. ");
INSERT INTO ong_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ise onposi piti yeila nange pite isotei wane, wolo Ma Ili niliyeye lepe, ise onposi piti le ma leilape nange peise kolo olo. Ise yolpepei le ise yolomen ma yulpoiki ki? Ma olo. ");
INSERT INTO ong_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ise ma onposi yolpepei kolo olo, onposi yirpolo ki ma kirpowo Eiya leiki kire il olpe peise lom? Olo. Moses lotei lepe soma lirpowo Eiya leiki lire il olpe peise pepe. Moses so ise onom natowo yirpolo le miso kaneise lepe. ");
INSERT INTO ong_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Le wuso ise yulpowo Moses punkom, ise fei ma yulpoiki, wusoli le laptei il lirpei lireiki ki. ");
INSERT INTO ong_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Wolo il wuso Moses laptei pepe, ise yulpope kolo olo, so ise yolomen ma yulpope il wuso ki kirpei pepe?” ");
INSERT INTO ong_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Wem kari re fei, Jisas nou le mingo plen lite tuluple Galili (nange nele pinawo tuluple Taiberias). ");
INSERT INTO ong_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mete wurutei pulsi wusoli pe pulwepe menmen lipi wuso Jisas laptei fale wem le kapi kainu taniepe mete. ");
INSERT INTO ong_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisas liripe pupam pele pepi punwei pe pifei tef nele lupai linpei lifei. ");
INSERT INTO ong_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Le epli wem piti mete pite Juda ma papli oweli lipi paplei onposio wem wuso Ma Ili kesipe manre yaire pelpe pau tani Isip, epli wem fei lepe olo lau lire malfem ye. ");
INSERT INTO ong_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas luntoli wuso mete wurutei pau falowo, le so lirpowo Filip lolpepei, “Ku ma kapi oweli lipi pato fei linei soma watepe mete wurutei fei pepei pepe?” ");
INSERT INTO ong_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jisas lirpei il pepei piti lila Filip lusa le Jisas lotei olo linu retai fei piti ma lolomen liripe mete fei pepe. ");
INSERT INTO ong_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip namti lirpowo Jisas lolpepei, “Piti mete wurutei fei pepei ma paplei oweli men kumpu, ku ma miripe era lipi watafei wan tausen tu huntret kina mire maise luom piti watepe palei.” ");
INSERT INTO ong_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Fei Jisas pupam nele lele lepe, Andru, Saimon Pita winke lele, le lirpei lolpepei, ");
INSERT INTO ong_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ninge kumpu nele lepe, le lilape lufe twinges te twinges niliyeye le ningu twinges. Wolo pe miso piripe mete fei pepei, lo olo?” ");
INSERT INTO ong_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Liso Jisas lirpepe pupam pele lolpepei, “Yirpepe mete pepe pungura pratei.” Tulum fei lepe wolo yefli loli. Liso mete wurutei pepe, pe yeflipiye pungura pratei, pe wurutei watafei 5,000. ");
INSERT INTO ong_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisas kapi lufe, leletei Ma Ili liripe re fei, le karipe watepe mete wuso pratei pinge wolo pepe. Ningu re, Jisas leletei Ma Ili liripe re fei, le so yaruwepe watepe mete pepe, le pe pirkilau paplei peilape fangelem. ");
INSERT INTO ong_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wem pe paplei peilape re fei, Jisas lirpepe pupam pele lolpepei, “Ise tonwipe oweli ilepe, ku miripe nemple kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pe so tonwipe oweli ilepe pepe pafo pora pire eti plen le plen poungo, te twinges (12) fale. Mete wurutei wolo lufe twinges te twinges niliyeye pepe, pe piripe poungai le ilepe pratei yaupe liso pupam pite Jisas pele nou tonwipe pafo pora wuso pire eti plen le plen poungo, te twinges pepe (12). ");
INSERT INTO ong_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mete wuso pratei lepe, wem pe pulwepe menmen lipi wuso Jisas laptei fale pepe, pe pirpeiye, “Punkomtei, metine lepei, le metine nimou wuso Moses lirpei liri piti ma lau lepe.” ");
INSERT INTO ong_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisas retai fei piti mete pepe ma pau kesi le pe ma pirkilau yeftuwo piti fale lire metine ili piti luntoluwepe. Liso Jisas loteteiye nou lunwei le tef lupai linpei lifefei lepe leye. ");
INSERT INTO ong_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wem ningli, pupam pite Jisas pele pitipi pe tuluple mingo lepe, ");
INSERT INTO ong_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","pe ponglo nimpe teingo le pe nou palowi tuluple ponglo pe Kaperneam. Mulpou lirkilauye wolo Jisas lau falepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wem fei lepe, yuf ili fale lalpopo tuluple le tipe lirkilau loungongo. ");
INSERT INTO ong_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pupam pepe, pe raltutuwe nimpe teingo lepe pe fiyen taise wem pe puluwo Jisas lilele linge tipe yuwei karepe le. Jisas le liri nimpe teingo malfem le pupam pepe, pe pinlele potei olpe. ");
INSERT INTO ong_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jisas lirpepeye, “Ise turise pato kuna ki.” ");
INSERT INTO ong_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pe pirpowo piti longlo lingepe pifei nimpe teingo, le frou yo fei, nimpe teingo lepe le le fale tuluple mingo plen wuso pe ma pe lepe. ");
INSERT INTO ong_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Le mete wurutei wuso Jisas watepe oweli paplei le pe pratei tuluple mingo plen lepe, pe nolowi mul peilo puntoli wuso nimpe teingo niliyeye ye laitei. Pe pretai polpepei, Jisas olo liripe pupam pele pepi ponglo nimpe teingo pe kolo olo, wolo pupam poteteiye ponglo pe. ");
INSERT INTO ong_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Fei, nimpe teingelem nemple pato Taiberias so pau fale paitei tuluple lunko malfem pire tulum wuso Apa Ili leletei Ma Ili lire luom re fei, le so karipe watepe mete wurutei paplei pratei lepe. ");
INSERT INTO ong_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mete wurutei pepe, wem pe puntoli wuso Jisas olo liripe pepi pratei kolo, le pupam pele re olo, le pe so ponglolo nimpe teingelem pepe le pe pintawo Jisas pe Kaperneam. ");
INSERT INTO ong_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wem mete pepe pe fale tuluple mingo plen, pe perengawo Jisas le pe so peletei polpepei, “Ye metine piti eitalouku lepe, ye wem liti men so au fale lepei?” ");
INSERT INTO ong_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Fei Jisas namti lirpepe lolpepei, “Ki kirpeise punkom, ise yintataiki wusoli ise retape menmen lipi singe wuso ki kirpei le pe potei pire tute fale pepe lom? Olo, ise yintataiki wusoli ise yirkilau yalei luom lireise fangelem. ");
INSERT INTO ong_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Oweli piti frou olpe porworo pepe, ise ma yesio towa piti yintape kapi kolo olo, wolo ise ma yesio towa liti kapi oweli piti kaneise ratei yingi wem wem. Oweli fei pepei, Ninge lite Metine Wape ma waise wusoli Ma Ili, le yaitei lele, le lulpowo fei piti le ma waise oweli fei pepei.” ");
INSERT INTO ong_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pe so peletei Jisas polpepei, “Ku ma molomen soma ku miso mesio towa lite Ma Ili?” ");
INSERT INTO ong_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisas namti lirpepeye, “Towa fei lepei so Ma Ili onposi piti ise ma yesio, ise yulpowo metine wuso le laisi lau lepe.” ");
INSERT INTO ong_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Le pe namti pirpowo Jisas polpepei, “Menmen lipi singe fei polomen ma ye irpei le pe potei pire tute fale soma ku mulwepe le ku ma mulpouye. Ye ma olomen? ");
INSERT INTO ong_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Eiya mani pouku, pe palei mana pratei tef oli era re telmane ye yawi lepe, min watafei il piti paitei yousi, pe pirpei pepe. Pe pirpei polo, ‘Le watepe luom lite yuwei palei.’” ");
INSERT INTO ong_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Leye lo Jisas lirpepeye, “Menmen wuso Moses waise lepe, le luom piti laule yuwei kolo olo. Eiya leiki lotei so waise luom punkom piti laule yuwei lepe. ");
INSERT INTO ong_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Wusoli luom wuso Ma Ili waise lepe, le metine piti lato yuwei so litipi lau, le le ma watepe mete piti tef nempi liti pratei.” ");
INSERT INTO ong_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Fei pe peletei Jisas polpepei, “Ili louku ye wauku luom fei lepei wem oli oli.” ");
INSERT INTO ong_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Leye lo Jisas nomnaipe lirpei lolpepei, “Ki kutei so watafei luom lepe piti ma watepe mete nempi liti pratei. Metine minele wuso laule ki lepe, le miso nou nimpi nalei kolo olo. Le metine wuso lulpoiki ki, le miso yif punko re kolo olotei. ");
INSERT INTO ong_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ki fei kirpeise kirpolo ise yuliki fei, wolo ise yulpoiki kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mete yeflipi wuso eiya leiki waiki pepe, pe miso paule ki. Le minemple wuso paule ki lepe, ki miso kaisipe nou pe kolo olo, ");
INSERT INTO ong_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","wusoli ki kusa yuwei le ki kitipi kau tef lepei fei piti kingiepe il pite metine lotei wuso laiteiki kau lepe. Ki ma kingiepe il peiki kutei kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Le lotei wuso laiteiki kau lepe, le onposi piti ki ma kingiepe fei kolpepei le mete yeflipi wuso le laptei pau ki pepe, ki ma kusa nele lelpe re ma le kotire kolo olo. Wolo ki ma nou keilape pe yeflipiye wem Ma Ili kapi il laptei liripe mete piti tef. ");
INSERT INTO ong_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wusoli eiya leiki onposi lolpepei, mete yeflipiye wuso puluwo ninge le pe pulpowo, pe miso kali nempi liti pratei pingi wem wem, le ki miso nou keilape nampir pratei wem Ma Ili kapi il laptei liripe mete piti tef.” ");
INSERT INTO ong_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Il pepei weisipe enke pite mete piti Juda le pe pirpei narwi nemple piri Jisas wusoli le lirpei lolpepei, “Ki kutei so watafei luom lite yuwei le le litipi lau lepe.” ");
INSERT INTO ong_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pe so pirpei polpepei, “Metine lepe, le Jisas, ninge lite Josep ko? Ku mretame nimou re yaitei mele. Le fei, le lolomen ma lirpei lolo le lato yuwei so litipi lau lepe?” ");
INSERT INTO ong_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Fei, Jisas namti lirpepe lolpepei, “Ise yirpei narwi nemple pato. ");
INSERT INTO ong_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Metine minele re miso lau ki yawi kolo olo. Wuso Eiya piti laiteiki kau lepe, Le kesi metine fei lepe lau lalteiki, metine fei lepe ki miso nou keila namin ratei wem Ma Ili kapi il laptei liripe mete piti tef. ");
INSERT INTO ong_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mete emarengi sungoi paptei il pirpei polpepei, ‘Mete yeflipiye ma Ma Ili leptalo.’ So mete wuso pingitowo Eiya le Le leptalo pepe, pe yeflipiye ma paule ki. ");
INSERT INTO ong_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Minele re luluwo Eiya kolo olo, metine lotei wuso Eiya laisi lau lepe, le loteteiye so luluwo. ");
INSERT INTO ong_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ki kirpeise punkom, metine piti lulpoiki ki, le ma kali nempi liti ratei lingi wem wem. ");
INSERT INTO ong_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ki watafei luom liti watepe mete nempi liti pratei. ");
INSERT INTO ong_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yaire manre peise, pe palei mana pratei tef oli era re telmane ye yawi lepe, wolo pe pa. ");
INSERT INTO ong_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wolo luom lite yuwei wuso litipi lau lepe, le nemtei, le minemple piti palei lepe pe miso pa kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ki watafei luom liti watepe mete nempi liti pratei, le ki kato yuwei so kitipi kau. Wuso minele lalei luom fei lepei, le miso ratei lingi wem wem. Luom wuso ki ma watowo lepe, le topo tale leiki piti watepe mete piti tef le pe ma nampir pratei.” ");
INSERT INTO ong_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Il pepei, pe weisipe enke pite mete piti Juda le pe pire il pura nemple. Pe peite nemple pirpei polo, “Metine fei lepei, le lolomen ma wauku topo tale lele piti malei?” ");
INSERT INTO ong_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisas lirpepe lolpepei, “Ki kirpeise punkom, wuso ise yalei topo tale lite Ninge lite Metine Wape kolo olo, le teluwi lele re ise yalei kolo olo, ise ma kali nempi liti ratei yingi wem wem kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Metine minele piti lalei teluwi re topo tale leiki, le ma kali nempi liti ratei lingi wem wem, le ki ma nou keila namin ratei wem Ma Ili kapi il laptei liripe mete piti tef. ");
INSERT INTO ong_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Topo tale leiki, le watafei owelitei. Le teluwi leiki re, le watafei tipe nimoutei piti yalei. ");
INSERT INTO ong_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Metine minele piti lalei topo tale leiki, le le lalei teluwi leiki, metine fei lepe, le rateiki ki le ki re ratowo leinginim lele. ");
INSERT INTO ong_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Eiya liti wauku nempi lepe, le laiteiki kau le ki namin ratei wusoli le re namin ratei. Liso metine minele piti leiyeiki lepe, le miso namin ratei wusoli ki ma kanowo piti namin ratei. ");
INSERT INTO ong_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","So luom fei lepei, le lite yuwei so litipi lau. Le watafei luom wuso manre yaire peise palei wolo pe pa pepe, le luom fei lepe kolo olo. Luom fei lepei wem metine nele lalei, le ma ratei lingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas lirpei il pepei wem le leptalo il lifei angli pau lite uf Kaperneam. ");
INSERT INTO ong_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pupam wuru pite Jisas pele, pe pingitepe il pepei le pe pirpei polo, “Il wuso le leptalo pepe, olo moingipetei. Minemple miso pingitepe il pepei?” ");
INSERT INTO ong_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Minemple re pirpowo Jisas kolo olo, wolo le retai lolpepei, pupam pele olo pirpei narwi nemple. Le so lirpepe lolpepei, “Il pepei olo kotise enke piti ise ma yire wilfingou lom?” ");
INSERT INTO ong_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Le wuso ise ma yuluwo Ninge lite Metine Wape ma nou lunwei le tulum lele piti lato yuwei wuso le lusa le le litipi lau lepe, le ise ma onposi yolomen? ");
INSERT INTO ong_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ko riri lite Ma Ili lele so watepe mete nempi liti nampir pratei. Singe pite metine pele lotei kolo olo. Il wuso ki kirpeise kiripe pepe, pe il pite riri pele le pe miso waise nempi liti nampir ratei. ");
INSERT INTO ong_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Wolo ilepe peise olo yulpoiki kolo.” Jisas olo linu retai fei, mete minemple ma pulpowo kolo olo, le metine minele ma laltei le esi pite mete olpe. ");
INSERT INTO ong_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Fei Jisas nou reresipe il lirpei lolpepei, “Il pal potei pepei so ki kirpeise kirpolo, metine minele re miso kareiki lau yawi kolo olo. Ma Eiya lotei weisine onom pite metine lepe pele soma le ma kareiki lau. Olo ma olo.” ");
INSERT INTO ong_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Il fei pepei weisipe enke pite pupam pite Jisas le wuru pelpe nou pulsi piri pepi pe kolo oloye. ");
INSERT INTO ong_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jisas lepletei pupam pele wuso pire eti plen le plen te twinges pepe, lepletei lolpepei, “Le ise, ise re ma yusaiki le ise ye ko?” ");
INSERT INTO ong_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Leye lo Saimon Pita namti lirpowo Jisas lolpepei, “Ili louku, minele ma ku karowo me? Olo, ye so esiepe il piti wauku nempi liti mratei mingi wem wem. ");
INSERT INTO ong_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Le ku fei mulpouye le ku mretai molpepe, ye metine teingitei wuso Ma Ili laiteiye au lepe.” ");
INSERT INTO ong_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Leye lo Jisas namti lirpepe pupam pele lolpepei, “Ise piti yire eti plen le plen te twinges pepe, ki keinise kolo olo ko? Ki keinise, wolo nele leise olo towa lunkuwo.” ");
INSERT INTO ong_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jisas lirim lirpei liri Judas ninge lite Saimon, le liti uf Iskariot. Judas, le pupane nele lite Jisas wuso pire eti plen le plen te twinges pepe, le soma laltei Jisas le esi pite mete olpe pepe. ");
INSERT INTO ong_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wem kari re fei, Jisas lilele le linge tef lite Galili. Le linau piti leptalo il linge tef lite Judia, wusoli mete lipi pite Juda pepe, pe onposi pirpolo ma petesi la. ");
INSERT INTO ong_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Epli wem piti mete pite Juda ma papli oweli lipi rautu wem piti oweli poungo le pe ma kaptu winangou pal kumpu kumpu le pe pratei rourepe siye wasem piti fale paplei oweli pelpe. Epli wem fei pepe olo pau piri malfemye. ");
INSERT INTO ong_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Liso Jisas winkem pele pirpowo polpepei, “Ye usa tulum lepei le ye e Judia soma pupam peiye ma pulwepe menmen lipi wuso ye irpei le pe potei pire tute fale pepe. ");
INSERT INTO ong_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wuso metine nele onposi lirpolo nange lele ma fale ili, le miso lesio towa lele kotire kolo olo. So ye ma esio towa leiye ile alepe nimin le mete yeflipiye ma puliye ");
INSERT INTO ong_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jisas winkem pele re olo pulpowo kolo. ");
INSERT INTO ong_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisas lirpepe lolpepei, “Wem leiki loporotei wala fale kolo olo. Wem yaupe pepe, pe wem poporo peise. ");
INSERT INTO ong_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mete pititef miso enke olpe pireise kolo, wolo pe enke olpe pireiki ki wusoli ki wem oli oli kirpepe kirpolo pe wai lelpe olo oli liti pingiepe il olpe. ");
INSERT INTO ong_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ise ye yiripe rautuwo wem ili fei lepe. Ki ma ke kolo wusoli wem leiki loporotei wala lato.” ");
INSERT INTO ong_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jisas lirpei il pepei re fei, le wala ratei tef lite Galili. ");
INSERT INTO ong_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wem Jisas winkem pele pe pulwepe rautuwo wem ili lepe, Jisas re lingepe le lingi. Le le alepe nimin kolo, wolo le kotire le. ");
INSERT INTO ong_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Wem pe rautuwo wem ili lelpe lepe, mete lipi pite Juda pintawo Jisas. Pe pepletei mete pirpolo, “Ko Jisas linei?” ");
INSERT INTO ong_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mete wurutei pepe, pe loule pirpei nemple liye liye re peinei kotuye, pirpei polo “Ko le metine teingi.” Le ilepe pirpei polo, “Olo le metine oli piti lempesipe mete.” ");
INSERT INTO ong_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wolo nemple pelpe re pirpei il lipi, alepe nimin kolo olo, wusoli pe turwepe piripe mete lipi pite Juda. ");
INSERT INTO ong_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mete pite Juda wuso rautuwo wem ili liti oweli poungo le pe pratei pinge winangou pal kumpu kumpu, pe prautuwo wem fei lepe so pe pile niminye, wem Jisas le fale winem lite Ma Ili le le leptalo il lifei. ");
INSERT INTO ong_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Fei, mete lipi pite Juda pepe, pe pinlele potei olpe le pe peite nemple polpepei, “Metine lepei, mete nemple re peltalo kolo, wolo le lolomen so retaitei lepe?” ");
INSERT INTO ong_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisas namti lirpepe lolpepei, “Il wuso ki keptalo mete kiripe pepe, il pepe olo peiki kolo. Wolo pe il piti paule Ma Ili wuso laiteiki kau lepe. ");
INSERT INTO ong_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Metine minele wuso onposi lirpolo ma lingiepe il pite Ma Ili, metine fei lepe, le miso retai lolpepei, il wuso ki keptalo mete kiripe pepe, pe paule Ma Ili lo ki kutei onposiepe le ki kirpei kire singe peiki. ");
INSERT INTO ong_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Metine piti lotei onposiepe il le le lirpei lire singe pele, metine fei lepe, le onposi piti ma leila nange lele lotei. Wolo metine piti onposio metine lotei wuso laisi lau lepe, le onposi piti ma leila nange lite metine wuso laisi lau lepe. Le metine fei lepe, le metine piti lirpei punkom, le ma lempetei kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Il lipi pite Moses pepe, Moses waise ko? Iyo, le waise wolo nele leise re lingiepe il lipi pepe kolo olo. Le piti men ise onposi piti ma yeteteiki ka?” ");
INSERT INTO ong_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Fei, mete wurutei pepe, pe namti pirpowo Jisas polpepei, “Ye olo towa lunkiye. Minemple so onposi pirpolo ma peteteiye a lepe?” ");
INSERT INTO ong_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Wolo Jisas nou lirpepe lolpepei, “Ki kirpei le menmen ili lotei lire tute fale, le ise yinlele isotei yiri. ");
INSERT INTO ong_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses lirpei piti ise ma yaploupe topungou pite eple tuleingi peise. Moses lotei lolpepei kolo, wolo manre yaire peise isotei so pinu pingiepe piti paploupe topungou pelpe pepe. Le epli wem piti ise ma yifei yaupe onposio Ma Ili, epli wem fei lepe, ise yalowi topo lite ninge tulei nele. ");
INSERT INTO ong_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Le wuso epli wem piti ise ma yifei yaupe onposio Ma Ili le ise yalowi topo lite ninge kumpu nele, wolo ise yirpei yolo il lipi pite Moses pepe, ise yaruwepe kolo. Le piti men ise enke kotu yireiki ki wusoli epli wem piti ku ma mifei yaupe onposio Ma Ili le ki kapi kainu tanio metine nele? ");
INSERT INTO ong_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ise kapi il yaptei yiri metine yile yinge topo yuwei kolo olo, wolo ise yulwepe menmen wuso fale punkom pepe soma ise kapi il yaptei yiripe pepe.” ");
INSERT INTO ong_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Leye lo mete ilepe pite Jerusalem pirpei polpepei, “Metine fei lepei lepe, so pe pirpei pirpolo ma petesi la lepe lom? ");
INSERT INTO ong_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yuntoli, le lirpei lile alepe nimin le minemple re namti pirpowo pire il men re kolo. Ko mete lipi pepe, pe pretai le Krais punkom lom? ");
INSERT INTO ong_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wolo wem Krais lau, minemple re miso pretawo uf lele kolo olo. Le metine fei lepei, ku yeflipiye olo mretawo uf lele.” ");
INSERT INTO ong_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Wem Jisas leptalo il lifei winem lite Ma Ili, le lirpei il lipi lirpei lolo, “Iyo, ise retaiki le ise retai ki lite uf mete mi so kaule lepei lepe. Wolo ki kaule kire onom peiki kutei kolo olo. Metine lotei wuso laiteiki kau lepe, le lirpei punkom le ise ma yulpope il pele. Ise retawo kolo olo, ");
INSERT INTO ong_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","wolo ki kretawo wusoli ki kiri wepi ratei le le so laiteiki kau.” ");
INSERT INTO ong_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Leye lo mete ilepe pepe, pe onposi pirpolo ma penglei Jisas wolo nele lelpe re lesio kolo olo, wusoli wem loporotei lele wala lato. ");
INSERT INTO ong_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wolo mete wuru pelpe, pe pulpope il pite Jisas le pe pirpei polpepei, “Wem Krais lau, le miso lirpei le menmen lipi wuru potei ma pire tute fale yaupe le le ma fale linuwo metine lepei lo olo?” ");
INSERT INTO ong_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mete pite Farasi, pe pingitepe mete wuso loule piri nemple, pirpei piri Jisas lepe. Le pe so pire mete lipi piti peptawio Ma Ili siye, pe pepi paisipe yali pal piti puntoluwo winem lite Ma Ili lepe, pe paisipe pe piti ma penglei Jisas. ");
INSERT INTO ong_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Fei, Jisas lirpei lolpepei, “Ki ma kireise ratei wem kurauye le ki ma nou ke metine wuso laiteiki kau lepe. ");
INSERT INTO ong_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ise ma yintaiki wolo ise miso yerengaiki kolo olo, wusoli tulum liti ki ke kratei lepe, ise miso ye kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Fei, mete lipi pite Juda pepe, pe pirpei nemple polpepei, “Le ma le pinei le so ku miso merengawo kolo olo lepe? Le ma le uf lipi pite mete piti Grik wuso mete ilepe pite Juda pe pratei pepe le le ma leptalo mete pite Grik lom? ");
INSERT INTO ong_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Le lirpei lolo, ‘Ise ma yintaiki wolo ise miso yerengaiki kolo olo.’ Le le lirpei lolo, ‘Ise miso ye tulum liti ki ke kratei lepe kolo olo.’ Il pele pepei pepe, pal pelpe pato polomen?” ");
INSERT INTO ong_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Epli wem linglitei liti mete pite Juda ma rautuwo wem ili lelpe lepe le kere, epli wem fei lepe, le wem ilitei lelpe. Epli wem fei lepe, Jisas leilo lile le le lirpei il lipi, lirpei lolpepei, “Metine minele piti yif punko, le ma laule ki, le ki ma watowo menmen piti lalei laltu yif. ");
INSERT INTO ong_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Min watafei il piti paitei yousi pe pirpei pepe, ‘Minele piti lulpoiki ki, il teingipe ma pultei onom pele le pe ma falele watafei etingi tipe falele le lepe, le tipe lepei ma watepe nempi liti ratei lingi wem wem.’” ");
INSERT INTO ong_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas lirpei il pepei liri Riri Teingi wuso mete piti pulpowo, pe ma kali Riri fei lepei. Wem linu linu re lepe, lau lau fale wem fei lepe, Ma Ili wala watepe mete Riri fei lepe kolo olo, wusoli Jisas wala la kolo olo, le Ma Ili re wala nou leila lire singe lipi pele kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mete wuru wuso pile peingalope mete wurutei pepe, wem pe pingitowo Jisas lirpei il pepei, pe pirpeiye, “Punkomtei, metine lepei le metine nimou wuso ku ratowo lepe.” ");
INSERT INTO ong_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ilepe pelpe pirpei polo, “Le kuna Krais.” Wolo ilepe pirpei polpepei, “Krais ma lato Galili lau lom? Olo. ");
INSERT INTO ong_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Il piti paitei yousi pe pirpei polo Krais ma ninge palyene lite Devit, le le ma nimou nila Betlehem, uf kumpu wuso Devit linu ratei lepe.” ");
INSERT INTO ong_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Fei, mete ilepe kere piri Jisas le ilepe weitowo lope re kelelawo. ");
INSERT INTO ong_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mete ilepe pirpolo ma penglei Jisas wolo nemple pelpe re pesio kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yali pal piti puntoluwo winem lite Ma Ili lepe, pe nou pe falepe mete lipi piti pinuwepe peptawio Ma Ili siye le mete pite Farasi. Yali pal pe falepe mete lipi pepe le mete lipi pepe pe pepletei yali pal pepe polpepei, “Piti men so ise yenglei yila yau kolo olo lepe?” ");
INSERT INTO ong_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Le yali pal namti pirpepe mete lipi pepe polpepei, “Metine nele re lirpei watafei metine fei lepei kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fei, mete pite Farasi pepe, pe nou pepletei yali pal polpepei. “Ise re, le lilaise lusaise ko? ");
INSERT INTO ong_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ise retawo metine ili nele lo ku, nele louku lite Farasi, metine nele lolpepei re ise retawo piti lulpowo Jisas lo olo? ");
INSERT INTO ong_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mete wurutei fei pepei, pe pretape il lipi pite Moses kolo olo, so Ma Ili ma watepe moingi.” ");
INSERT INTO ong_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus, le nele lelpe lite Farasi. Le lotei so linu le luluwo Jisas. Nikodemus lirpepe ilepe wane pele pite Farasi pepe lolpepei, ");
INSERT INTO ong_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Il lipi pouku pirpei polpepei, ku ma watowo metine moingi kolo olo. Ku wala ma minu mingitepe il pele wo soma ku ma kapi il maptei miri towa men le lesio.” ");
INSERT INTO ong_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wem mete lipi pire mete pite Farasi pepe, wem pe pingitepe il pepei, pe namti pirpowo Nikodemus polpepei, “So ye re lite Galili ko? Ye ungunape yousi le ye miso retai olpepei, metine nimou nele re miso fale lile Galili kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Fei, Mete yeflipi pepe pe pe winangou pelpe fi fi peye, ");
INSERT INTO ong_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Wolo Jisas le tumun lite nimpe oliv pile. ");
INSERT INTO ong_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nolowi lire mul ili, Jisas nou le winem lite Ma Ili. Mete wurutei pepe, pe yeflipiye pau pifei neinowo le Jisas lifei leptalo lire il pite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Leye lo mete piti peptalo mete pire il lipi pite Moses, pe pire mete pite Farasi, pe pepi kesine moto nenpe pilane pinki pe winem lite Ma Ili. Moto nepe, pe perengane nire metine nele roum metei. Pe kesine moto nepe pilane pe pantei nile onom pelpe yeflipiye. ");
INSERT INTO ong_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Le pe pirpowo Jisas polpepe, “Ye metine piti eitalouku lepe, moto nepei ku merengane nire metine nele roum metei. ");
INSERT INTO ong_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Il lipi pouku, Moses wauku il singe lirpei lolo, moto fei nolpepei nepe, ku ma mire era mosiene na tani. Le fei, ye ma irpei il men?” ");
INSERT INTO ong_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pe pirpei il pepei pirpolo ma pempesi Jisas lualo tisi oli le pe soma pamtuwo. Wolo Jisas lungutu luwo le le lire eti tunongo kareri tef. ");
INSERT INTO ong_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Wem pe wala pile peletetei Jisas, Jisas leilo tuwopou lile le le lirpepe lolpepei, “Ise minele leise piti lingiepe il olpe kolo olo, le ma linu liri erau lanpo.” ");
INSERT INTO ong_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Leye lo Jisas nou lungutu luwo kareri tef. ");
INSERT INTO ong_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Wem pe pingitepe il wuso Jisas lirpei pepe, pe yeflipiye kere pusa nemple, niliyeye niliyeye naro pe yalipeye, le pe pusa Jisas loteteiye lire moto nepe roum mile. Mete lipi pire potei pepe, pe naro pinuwepe piti peilo pingi pepe. ");
INSERT INTO ong_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas nou leilo tuwopou lile le le lenetei moto nepe lolpepei, “Le pe pinei? Nele lelpe re lile piti ma lamtuye lo olo?” ");
INSERT INTO ong_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Le ne namti nirpowo Jisas nolpepei, “Ili leiki, olo.” Liso Jisas nou lirpene lolpepei, “So ki re ma kamtuye kolo olo. Ye e wolo ye ma nou ingiepe il olpe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Fei Jisas nou lirpepe mete wurutei wuso pau panfi pifei winem lite Ma Ili lepe, Jisas lirpepe lolpepei, “Ki weli liti nainuwepe mete piti tef. Metine minele piti lulteiki ki, le ma ratei lire munkunum kolo olo, wolo le ma kali weli liti kanowo ratei loporo.” ");
INSERT INTO ong_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mete pite Farasi pirpowo Jisas polpepei, “Ye fei irpei lepei lepe, ye yotei irpei ire yotei le minemple re pulpope il peiye kolo olo, il peiye olo teingelem yaupe.” ");
INSERT INTO ong_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Fei Jisas namti lirpepe lolpepei, “Olo, wuso ki kuteteiye kirpei kire ki kutei re, il peiki piti kirpei pepe olo punkom, wusoli ki kretai ki lite linei kau, le uf men ma ki nou karowo ke. Ki kato fei linei kau le uf mi ma ki nou karowo ke lepe, olo ise retai kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ise kapi il yaptei yiripe mete nemple yinge tisi re wai lite ise mete piti tef. Wolo ki olo kapi il kaptei kire metine nele re kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Le wuso ki ma kapi il kaptei kiri metine nele, il peiki ma tuwopou wusoli ki kuteteiye kapi il kaptei kiri metine fei lepe kolo olo. Eiya wuso laiteiki kau lepe, le lireiki wepi kapi il waptei wiri metine fei lepe. ");
INSERT INTO ong_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Il wuso paptei paitei Il Lipi peise pepe, pe pirpei polo, wem mete twinges tulpo noute tire il menmen, il wuso te rounge tirpei pepe ma punkom. ");
INSERT INTO ong_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ki kirpei kire ki kutei, le eiya leiki wuso laiteiki kau lepe, le re lirpei lireiki ki.” ");
INSERT INTO ong_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","“Le eiya leiye linei?” Pe peletei Jisas. Liso Jisas namti lirpepe lolpepei, “Ise retaiki ki lo eiya leiki re olo, ise retauku kolo. Wuso ise retaiki ki, eiya leiki re ise miso retawo wolo ise olo yironom.” ");
INSERT INTO ong_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Il pepei, Jisas lirpei lifei winem lite Ma Ili, lifei elpeingo wuso paptei ufal pifei piti nimoure mete ma pafo era piti watowo Ma Ili le pe pafo pratei pepe. Le minemple re penglei Jisas kolo olo, wusoli wem leletei wala lato. ");
INSERT INTO ong_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas nou lirpepe lolpepei, “Ki ma ke tanise. Ise ma yintataiki wolo ise ma ya yasiepe il olpe peise. Tulum piti ki ke lepe, ise miso ye kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Liso mete lipi pite Juda pepe, pe pirpei polo, “Ko, le lirpei lolo, tulum piti ki ke lepe, ise miso ye kolo olo. Le lirpei piti le ma leipo lotei la lom?” ");
INSERT INTO ong_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Fei Jisas namti lirpepe lolpepei, “Ise pite tef lepei, le ki olo, ki lite yuwei kau. Ise pite tef lepei, le ki olo lite tef lepei kolo. ");
INSERT INTO ong_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Min polpepei so ki kirpeise pepe, ise ma ya yasiepe il olpe peise. Le ise ma ya yasiepe il olpe peise wuso ise yulpo kolo olo, yulpo yirpolo ‘Ki kutei so lepe.’ Wuso ise yulpo yolpepe kolo olo, ise ma ya yasiepe il olpe peise. ");
INSERT INTO ong_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Leye lo pe peletei Jisas polpepei, “Le ye minele?” Jisas namti lirpepe lolpepei, “Il min wuso kinu kirpeise pepe. ");
INSERT INTO ong_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Menmen wuru piti ki ma kirpei le ki ma kapi il kaptei kireise kiripe menmen fei pepe. Metine lotei wuso laiteiki kau lepe, le lirpei punkom le ki kirpepe nimoure mete piti tef, kirpepe kiripe menmen potei wuso ki kingitowo lirpeiki liripe pepe.” ");
INSERT INTO ong_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisas lirpei liri yaitei lele lite yuwei, wolo pe olo pironom pire il pele. ");
INSERT INTO ong_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Liso Jisas lirpepe lolpepei, “Wem ise yeila Ninge lite Metine Wape le yuwei, wem fei lepe, ise miso retai yolpepei, ‘Ki kutei so lepe.’ Leye lo ise miso retai yolpepei, ki kesiepe towa menmen kire onom peiki kolo olo, wolo ki kirpei il menmen wuso eiya leiki leitaloiki piti ma kingiepe kirpei pepe. ");
INSERT INTO ong_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Le metine lotei wuso laiteiki kau lepe, le lireiki ratei. Le lusaiki kolo olo, wusoli menmen piti pailelene onom pele nepe, ki olo wem oli oli kingiepe re kesiepe koporotei.” ");
INSERT INTO ong_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wem Jisas lirpei il pepei, mete wuru pulpowo. ");
INSERT INTO ong_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Liso Jisas lirpepe mete pite Juda wuso pulpowo pepe, Jisas lirpepe lolpepei, “Wuso ise yulpope il peiki wuso keitaloise pepe, ise pupam peikitei. ");
INSERT INTO ong_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ise miso retape il punkom, le il punkom pepe miso kaneise ye yawi, menele re miso lesise leireise kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Fei pe namti pirpowo Jisas polpepei, “Ku eple palye pite Abraham, le ku mesio towa lite metine nele yawi re kolo olotei. Wem ye irpei irpolo, ‘Ise miso ye yawi, menele re miso lesise leireise kolo olo,’ il pal pelpe pato polomen?” ");
INSERT INTO ong_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisas namti lirpepe lolpepei, “Ki kirpeise punkom, metine minele piti lingiepe il olpe, il olpe pepe olo pesio pariye, le pe peilawo onom piti ma lirkilau lingiepe wem oli oli. ");
INSERT INTO ong_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Metine liti lesio towa lite metine nele yawi lepe, metine lepe le miso ratei winem lite nimou yaitei mele wem oli oli kolo olo. Ninge lotei soma ratei winem lite nimou yaitei mele wem oli oli. ");
INSERT INTO ong_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Le wuso ninge lotei kaneise ye yaupe, is menele re miso lesise leireise kolo olotei. ");
INSERT INTO ong_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ki kretai ise eple palye pite Abraham pele. Wolo ise onposi yirpolo ma yeteteiki ka, wusoli ise ma kapi il peiki wuso keptalo pepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Menmen wuso eiya leiki kusaiki liripe pepe so ki min kirpei kiripe pepe, wolo ise olo yingiepe il pite yaitei nele leise.” ");
INSERT INTO ong_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Fei, pe namti pirpowo Jisas polpepei, “Ko ku eiya louku so Abraham lepe.” Wolo Jisas nou lirpepeye, “Wuso ise eple pite Abraham punkom, ise ma yesiepe towa elpesipe watafei Abraham lotei lesiepe pepe. ");
INSERT INTO ong_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ki kuna kirpeise punkom kire il menmen wuso kingitowo Ma Ili lirpeiki liripe pepe. Wolo ise onposi yirpolo ma yeteteiki ka. Abraham lingiepe watafei ise pepei kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ise yingiepe watafei yaitei leise lotei, le lingiepe pepe.” Fei pe namti pirpowo Jisas polpepei, “Ku Ma Ili loteteiye, le eiya louku. Ku eple pite tisi kolo olo, ku eple pite Ma Ili pele lotei punkom.” ");
INSERT INTO ong_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Leye lo Jisas lirpepe lolpepei, “Wuso Ma Ili, le yaitei leise punkom, ise ma onom puwoiki, wusoli Ma Ili lotei laiteiki kaule ki fei min kireise mepi mifei lepei. Ki kau kire onom peiki kutei kolo olo, wolo le laiteiki le ki so kau. ");
INSERT INTO ong_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Le piti men so ise yironom yire il wuso kirpei pepe? Ise yironom wusoli ise miso yapteiki mingim kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ise eple pite yaitei leise Towa, le ise onposi piti ma yingiepe il menmen wuso le leilaise enke piti yingiepe pepe. Wem linutei, sungoitei liye, le oli piti letesipe mete pa. Le wem nele re, le lirpei il nemple punkom re kolo olotei, wusoli il punkom nemple re pultei onom pele kolo olo. Wem le lirpei lempesipe mete, le lingiepe il pele piti wem oli oli pele lingiepe pepe, wusoli le metine liti lempesipe mete le le nimoutei piti lempetetei. ");
INSERT INTO ong_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ki kirpei punkom, le min polpepei so ise yulpoiki kolo olo lepe. ");
INSERT INTO ong_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Minele leise miso kusaiki lirpolo ki metine oli liti kingiepe il olpe? Le wuso ki kirpei punkom, piti men so ise yulpoiki kolo olo lepe? ");
INSERT INTO ong_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Metine wuso Ma Ili lotei laisi lau lepe, metine fei lepe miso lingitepe il pite Ma Ili pele. Ise olo yaule Ma Ili kolo olo, le min polpepei so ise miso yaptei mingim kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Fei, mete pite Juda, pe namti pirpowo Jisas polpepei, “Ko ku mirpei tuwopou kolo lom? Ye lite Samaria, le ye olo towa lunkuye.” ");
INSERT INTO ong_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Ki towa lunkiki kolo olo.” Jisas namti lirpepe. “Wolo ki onposi piti keila nange lite eiya leiki, le ise olo yireiki teingi kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ki onposi piti mete ma peila nange leiki kutei kolo olo. Wolo metine nele, le onposi piti leila nange leiki, le il menmen le kapi laptei lireiki ki, le lirpei punkom. ");
INSERT INTO ong_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ki kirpeise punkom, metine minele piti lingiepe il peiki, le miso la kolo olotei.” ");
INSERT INTO ong_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jisas lirpei il pepei re fei, mete pite Juda nou pirpowo polpepei, “Ku fei mretai punkom molpepei, ye olo towa lunkiye. Abraham la, le mete emarengi re pa. Wolo ye irpei irpolo, ‘Metine minele piti lulpope il peiki pepe, le miso la kolo olotei.’ ");
INSERT INTO ong_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ku eiya louku Abraham lepe, le la, le mete emarengi re, pe pa. Wolo ye irpei irpolo ye ili inuwo Abraham lom? Le ye onposi yotei irpolo ye minele?” ");
INSERT INTO ong_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Leye lo Jisas namti lirpepe lolpepei, “Wuso ki onposi piti keila nange leiki kutei, nange leiki kutei miso fale ili kolo olo. Metine lotei piti leila nange leiki lepe, le eiya leiki. Le lotei wuso ise yirpei yirpolo le Ma Ili leise lepe. ");
INSERT INTO ong_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ise retawo kolo olotei, wolo ki olo kretawo. Le wuso ki ma kirpei kirpolo ki olo kirowo onom, ki ma kempetei watafei ise pepe. Wolo ki olo kretawo, le ki kingiepe il pele. ");
INSERT INTO ong_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Eiya leise Abraham lepe, le onom teingine lasio wem piti ki ma kau lepe, le le luluwo wem lepe fei, le le onom teingine.” ");
INSERT INTO ong_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Fei, mete pite Juda pepe, pe pirpowo Jisas polpepei, “Ye eringi peiye olo wurutei kolo (50), le ye irpei irpolo ye uluwo Abraham lom?” ");
INSERT INTO ong_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Le Jisas namti lirpepe lolpepei, “Ki kirpeise punkom, Abraham nimou pele wala nila kolo olo, ki olo kinu kratei fei.” ");
INSERT INTO ong_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Wem pe pingitepe il pepei, pe kapi era piti ma piripe posio, wolo Jisas leingi lotei le le naro le yawi tani winem lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Wem Jisas lilele le, le luluwo metine nele lutepe pele olpe. Nimou nila lasiepe. ");
INSERT INTO ong_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Fei, pupam pite Jisas pele peleteiye, “Ko ye metine liti eitalouku lepe, il olpe pite minemple pelpe so pire peptali metine fei lepei liso nimou pele nila nasiepe lutepe olpe pepe? Il olpe pele lotei lo pite nimou re yaitei mele?” ");
INSERT INTO ong_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Le Jisas namti lirpepe pupam pele lolpepei, “Ise ma onposi yirpolo il olpe pele lotei so nimou nila nasiepe lutepe olpe pepe lom? Olo. Lo il olpe pite nimou re yaitei mele kolo olo. Nimou nila nasiepe lutepe olpe soma singe pite Ma Ili pele ma fale alepe nimin wem le kanowo. ");
INSERT INTO ong_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ku wala ma mesio towa lite metine lotei wuso laiteiki kau lepe wem epli wala lultei. Mulpou ma lau wem minemple re miso pesio towa kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wem ki wala ratei tef lepei, ki watafei weli piti lini nainuwepe nimoure mete piti tef.” ");
INSERT INTO ong_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jisas lirpei il pepei re fei, le laruwo tunku lualo tef nief le le lumpyowo. Jisas lumpyowo tef nief lepe re fei, le kali fanke lepe relta lutepe pite metine wuso lutepe olpe lepe. ");
INSERT INTO ong_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Le Jisas lirpowo lolpepei, “Ye e tipe oi Siloam le ye kaltetei mati leiye.” (Nange Siloam lepe, il pal pirpei pirpolo, “Paisi le”.) Liso metine lutepe olpe lepe, le le kaltetei mati lele, le le nou lau, lutepe penfaro le le luntoli loporoye. ");
INSERT INTO ong_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mete wuso pratei malfem piri le pe piti pinu puluwo wuso wem le wala lutepe pele olpe le le kaituwepe lire era re oweli men nange pepe, pe peite nemple ye, “Ko metine lepe so nempis linu lifei le le kaitutu lire oweli yini pepe lom?” ");
INSERT INTO ong_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ilepe pirpeiye, “Iyo, le min so lepe.” Wolo ilepe pelpe pirpei polo, “Olo, le fei lepe kolo, Metine lepei mi mati pele so watafei metine lutepe olpe lepe.” Liso metine lotei lepe, le lirpei lolpepei, “Ki kutei so lepe.” ");
INSERT INTO ong_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Le pe peletei polpepei, “Ko ye lutepe peiye pe naro fei polomen?” ");
INSERT INTO ong_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Le le namti lirpepe lolpepei, “Metine nange lele Jisas, le lumpyowo tef le le kali fanke lepe relta lutepe peiki, le le lirpeiki lolpepei, ‘Ye e tipe oi Siloam le ye kaltetei mati leiye.’ Le ki so ke, le wem ki kaltetei mati leiki, lutepe peiki penfaro le ki kuntolili koporo.” ");
INSERT INTO ong_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Le le linei?” Pe peletei metine lepe. Fei, le namti lirpepe lolpepei, “Kunei, ki olo kretai kolo.” ");
INSERT INTO ong_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Leye lo pe kesi metine wuso wem linu lutepe pele olpe lepe, pe kesi pila pe falepe mete pite Farasi. ");
INSERT INTO ong_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Le epli wem wuso Jisas lumpyowo tef le le kali fanke repta lutepe pite metine lepe, le lutepe pele penfaro, epli wem fei lepe le wem piti pe ma pifei yaupe piti onposio Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Leye lo mete pite Farasi pepe, pe nou peletei metine wuso wem linu lutepe pele olpe, pe peletei pirpolo le lolomen so lutepe pele penfaro le le nou luntoli loporo lepe. Le metine lepe namti lirpepe lirpolo “Le kali fanke relta lutepe peiki, le ki kaltetei mati leiki le ki fei min kuntoli koporo lepe.” ");
INSERT INTO ong_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fei, mete ilepe pite Farisi pepe, pe pirpei polpepei, “Metine wuso lolpepei lepe, le metine piti laule Ma Ili kolo olo, wusoli le yaruwepe il lipi piti pirpei piri wem liti ku mifei onposio Ma Ili.” Wolo ilepe pelpe pirpei polpepei, “Ko metine liti lingiepe il olpe, le lolomen ma lesio towa men ili fei lolpepei lepe? Ma olo.” Le pe kare peite nemple, ilepe kani onom pantowo Jisas le ilepe onom flis pasio. ");
INSERT INTO ong_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Liso mete pite Farasi nou peletei metine lepe polpepei, “Ye irpei irpolo le nenfaripe lutepe peiye ko, le ye ma irpei olomen iri?” “Ko le metine nimou,” metine lepe namti lirpepe mete pite Farasi. ");
INSERT INTO ong_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mete lipi pite Juda, pe wala pulpo pirpolo metine lepe nimou pele nila nasiepe lutepe olpe kolo olo. Le le min fei nou luntoli loporo lepe re, pe pulpo kolo olo. Le pe so piname nimou re yaitei mite metine lepe, ");
INSERT INTO ong_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","le pe pemetei polpepei, “Metine lepei, le ninge leise roum lom? Ise roum yirpei yolo ise roum yila yasiepe lutepe olpe ko? Le le lolomen so le fei nou luntoli loporo lepe?” ");
INSERT INTO ong_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Fei, yaitei re nimou mele namti mirpepe mete lipi pite Juda pepe, roum mirpepe molpepei, “Ku retai le ninge louku, le ku retai ku wila wasiepe lutepe olpe. ");
INSERT INTO ong_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Wolo le fei luntoli loporo, le minemple nenfarowo lope, olo ku olo wironom. Ise yeletei, le iliye, le le lotei miso nou lirpeise.” ");
INSERT INTO ong_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nimou re yaitei mite metine lepe, me roum mirpei il pepei wusoli me roum turweme mire mete lipi pite Juda pepe. Pe pinu pulpo nemple pirpolo minemple piti pirpei nomnaipe pirpolo Jisas le Krais, mete fei pepe, mete lipi piti Juda ma paplowi pato yaupe le pe ma pe rautuwo Ma Ili pifei angli pau lelpe kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Min polpepei so nimou re yaitei mite metine lepe roum mirpei mirpolo, “Ise yeletei lotei, le iliye.” ");
INSERT INTO ong_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Fei, mete lipi pite Juda pepe, pe nou pinawo metine wuso nimou nila nasiepe lutepe olpe pepe. Pe pinu pinawo liti peletei le fei pe nou pinawo, le wem tire twinges. Pe pirpowo metine lepe polpepei, “Ye eisi nange lite Ma Ili le ye ma irpei punkom iri metine wuso kaneiye lepe. Ku mretai molpepei, ‘Le metine oli piti lingiepe il olpe.’” ");
INSERT INTO ong_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Leye lo metine lepe namti lirpepe lolpepei, “Wuso metine lepe, le lingiepe il olpe lo le lingepe il olpe kolo olo, ki kretai fei pepei kolo, olo kironom. Wolo menemple nempleiyeye fei pepei so ki kretai pepe. Ki lutepe olpe wolo fei ki kulwepe men nange koporo.” ");
INSERT INTO ong_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Fei, mete lipi pite Juda pepe, pe nou peletei metine lepe polpepei, “Ko le lolomen lireye? Le nempipe lutepe peiye fei lolomen?” ");
INSERT INTO ong_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Le metine lepe namti lirpepeye, “Ki kirpeise fei wolo ise yapteiki mingim kolo. Piti men ma ki nou kirpeise kasi? Ise onposi piti ma fale yire pupam pele lom?” ");
INSERT INTO ong_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Leye lo pe pirpei lawo le pe pirpowo polpepei, “Ye so pupane lite metine lepe lele, ku olo. Ku pupam pite Moses pele. ");
INSERT INTO ong_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ku mretai molpepei, Moses, Ma Ili lirpowo. Wolo metine fei lepei, ku mretai piti le lato fei linei lau re kolo olo, ku mirowo onom.” ");
INSERT INTO ong_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Metine lepe namti lirpepe lolpepei, “So fei pepei olo nempletei. Ise retai piti le lato fei linei lau kolo olo, wolo le nenfaripe lutepe peiki. ");
INSERT INTO ong_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ku mretai molpepei, mete piti pingiepe il olpe, Ma Ili miso laptepe mingim kolo olo. Wolo mete piti paptowo mingim le pe pingiepe il pele, Ma Ili miso laptepe mingim. ");
INSERT INTO ong_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Wem linutei liti Ma Ili laptei men nange pite yuwei re tef, le le lau lau fale fei, il men re ku mingitepe pirpei piri metine nele piti nenfaripe lutepe pite metine nele wuso nimou nila nasiepe lutepe olpe pepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wuso metine lepei, le laule Ma Ili kolo olo, menmen fei lolpepei lepe, le miso lesio kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Fei, pe namti pirpowo metine wuso linu lutepe pele olpe pepe, pirpowo polpepei, “Ye nimou nilaye le ye eilo asiepe il olpe, le ye olomen ma eitalouku?” Le pe kesi piri naro le yawi tani angli pau. ");
INSERT INTO ong_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas lingitei wuso pe piri metine lepe naro le yawi tani angli pau, le wem Jisas lerengawo, le lirpowo lolpepei, “Ye ulpowo Ninge lite Metine Wape lo olo?” ");
INSERT INTO ong_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Le metine lepe namti lirpowo Jisas lolpepei, “Ili leiki, ye irpeiki le minele soma ki ma kulpowo.” ");
INSERT INTO ong_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisas lirpowo lolpepei, “Ye olo uluwo fei, le le lotei min lireye rounge yirpepei lepei lepe.” ");
INSERT INTO ong_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Leye lo metine lepe lirpowo Jisas lolpepei, “Ili leiki, ki kulpoye.” Le le yaru yamkelem luwalo ratei onom pite Jisas. ");
INSERT INTO ong_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisas lirpei lolpepei, “Ki kau tef lepei piti kapi il kaptei kiripe mete soma pe piti lutepe olpe, pe ma nou puntoli poporo. Le pe piti lutepe teingipe pepe, pe ma namti lutepe olpe.” ");
INSERT INTO ong_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mete pite Farasi wuso piri Jisas pepi pile le pe pingitowo lirpei il pepei pepe, pe peletei polpepei, “Ye irpei irpolo ku re lutepe olpe lom?” ");
INSERT INTO ong_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Le Jisas namti lirpepe lolpepei, “Wuso ise lutepe olpe, is ki ma kamtuse kirpolo ise yingiepe il olpe kolo olo. Wolo ise yirpei yirpolo ise lutepe teingipe le ise miso yuntoli yoporo, fei pepei ma pato polpepei, ise wala yingiepe il olpe le ki ma kamtuse kirpolo ise mete olpe piti yingiepe il olpe.” ");
INSERT INTO ong_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas lirpei lolpepei, “Ki kirpeise punkom, metine minele wuso linki wingi pite sipsip kolo olo, wolo le longlo lunsuwene lom le le so linki le leinginim, metine fei lepe, le metine oli piti lire ausi. ");
INSERT INTO ong_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Metine piti linki wingi, le metine teingi piti luntoluwepe sipsip. ");
INSERT INTO ong_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Metine piti luntoluwepe sipsip wingi pepe, le ma kapunuwo wingi le sipsip miso pingitepe il manu pite metine piti luntoluwepe pepe. Sipsip nange peletei pepe, wem le lungunape nange pelpe fi fi, le ma naro linuwepe le, le pe ma pulsi pingi. ");
INSERT INTO ong_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wem le kesipe naro pe yawi, le ma linuwepe le sipsip ma pulsesi pingi wusoli pe pretape il manu pele. ");
INSERT INTO ong_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pe miso pulsi metine nele kolo olo wolo pe ma pantu tanio wusoli pe pironom pire il manu pele.” ");
INSERT INTO ong_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas lirpepe lire il kauro yuwei pepei wolo pe pironom pire il pele wuso lirpepe pepe. ");
INSERT INTO ong_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Liso Jisas nou lirpei lolpepei, “Ki kirpeise punkom, ki watafei wingi piti sipsip pinkingi. ");
INSERT INTO ong_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mete yeflipi wuso pinuki pau pepe, pe olo olpe piti pire ausi, wolo sipsip re olo paptepe mingim kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ki watafei wingi. Metine minele piti lau linkiki, le ma teingi ratei. Le ma linki re naro le lau watafei sipsip naro le lau piti laplei wolo pepe. ");
INSERT INTO ong_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Metine piti lire ausi lepe, le lau piti ma lire ausi yo, letesipe pe yo liripe nemple ye. Ki kau piti ma kaneise kali nempi liti ratei, nempi liti kaneise lire men nange yeflipiye le ise miso ratei yoporotei.” ");
INSERT INTO ong_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ki metine teingi liti kuntoluwepe sipsip koporo. Metine teingi piti luntoluwepe sipsip pepe, le onposi piti ma la lungwipe sipsip pele. ");
INSERT INTO ong_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Metine wuso lesio towa piti kapi era pepe, le sipsip yaitei kolo olo, le sipsip re, le pele kolo olo. Le wem le luluwo morou pele laule, metine fei lepe ma luru le taniepe sipsipye le morou pele lepe ma lengleipe re laptu sipsip pire flaye. ");
INSERT INTO ong_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Metine wuso lesio towa piti kapi era pepe, le linlele lantu taniepe sipsip wusoli le lesio towa piti kapi era yaupe le le onposi piti luntoluwepe sipsip loporo kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ki metine teingi liti kuntoluwepe sipsip koporo. Min watafei Eiya retaiki ki le ki re min kretawo lepe. So ki re kretape sipsip peiki le pe re pretaiki. Le ki onposi piti ma ka kungwipe piti kaniepe. ");
INSERT INTO ong_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sipsip nemple pepe re ki peiki wolo pe wala pau pratei lom nepei kolo olo. Pe re ki ma kesipe kilape kau kapteinemple tulum niliyeye, metine niliyeye ma luntoluwepe le pe ma pingitepe il manu peiki.” ");
INSERT INTO ong_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Eiya kani onom lanteikitei wusoli nempi leiki ki kutei onposi piti kusape mete ma pirowo nele, le ki kolpepei soma ki ma nou kali. ");
INSERT INTO ong_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Minemple re kali nempi leiki taniki kolo olo. Ki kutei kire onom peiki ki kalingou nempi leiki. Ki miso kalingou nempi leiki le ki miso nou kali. Eiya leiki lirpeiki piti ki ma kingiepe fei kolpepei.” ");
INSERT INTO ong_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Fei, mete pite Juda nou kare peite nemple wusoli Jisas lirpepe lire il fei pepe. ");
INSERT INTO ong_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wuru pelpe pirpei polpepei, “Le kuna towa lunkuwo. Le olo onposi loporo kolo olo. So piti men ma ise yaptowo mingim?” ");
INSERT INTO ong_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wolo ilepe pirpei polo, “Ko, metine piti towa lunkuwo lepe, le miso lirpei fei lolpepei kolo olo. Le metine piti lutepe pele olpe lepe, towa lolomen ma nenfaripe lutepe pele? Ma olo.” ");
INSERT INTO ong_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Wem piti is fale le mete pite Juda ma rautunemple piti onposio wem pe nou kali winem lite Ma Ili lele taniepe esi pite mete eringi pelpe. Wem ili fei lepei ma fale uf ili Jerusalem. ");
INSERT INTO ong_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Wem fei lepe, Jisas lilele le lau linge elpeingo pinawo pirpolo “Elpeingo lite Solomon.” Elpeingo lepei lato mingo plen lite winem lite Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Fei, mete pite Juda fale panfi Jisas le pe peletei polpepei, “Ye usauku piti onposisi re kapi enke maptetei mireye kolo olo. Wem piti men soma ye irpouku il punkom ire yotei, ye Krais punkom lo olo?” ");
INSERT INTO ong_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisas namti lirpepe lolpepei, “Ki kirpeise fei wolo ise yulpoiki kolo olo. Eiya leiki lirpeiki le ki min so kesiepe menmen lipi fale pepe, le fei pepe miso kosaise pireiki ki. ");
INSERT INTO ong_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Wolo ise yulpoiki kolo olo wusoli ise sipsip peiki kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip peiki pingitepe il manu peiki, ki kretape le pe pulteiki. ");
INSERT INTO ong_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ki watepe nempi liti pratei pingi wem wem, le pe miso pa kolo olotei. Le minemple re miso kapi taniepe esi peiki kolo olotei. ");
INSERT INTO ong_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Eiya leiki wuso waiki menmen fei pepe, le olo singetei le minemple re miso kapi taniepe esi pele kolo olotei. ");
INSERT INTO ong_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Eiya lireiki ki olo wunku noute fale wire metine niliyeye.” ");
INSERT INTO ong_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Leye lo mete pite Juda pepe, pe nou kapi era piti ma piripe posio Jisas. ");
INSERT INTO ong_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Wolo Jisas lirpepe lolpepei, “Ki kosaise kire towa teingipe wuru wuso Eiya waiki piti kesiepe pepe, le towa men fei pepe so ise yirpolo ma yiripe era yosiki yiripe pepe?” ");
INSERT INTO ong_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Le mete pite Juda pepe, pe namti pirpowo Jisas polpepei, “Ku mirpolo ma miripe era mosiye miripe towa teingipe wuru wuso ye esiepe pepe lom? Olo. Ku mirpolo ma miripe era mosiye wusoli ye kelelawo Ma Ili. Ye kuna metine yawi lite tef lepei wolo ye irpolo ye Ma Ili liso ku ma miripe era mosiye.” ");
INSERT INTO ong_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisas namti lirpepe lolpepei, “Il wuso paptei paitei Ili Lipi peise isotei pepe Ma Ili lirpei lolo “Ise Ma Lipi.” ");
INSERT INTO ong_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ku mretai molpepei, il pite Ma Ili pele wuso paptei paitei yousi pepe, pe olo pirpei punkomtei. Le mete wuso kapi il pite Ma Ili pele pepe, le linape lirpolo pe Ma Lipi. ");
INSERT INTO ong_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Le ki, Eiya keiniki le le laiteiki kau tef lepei, so ise yolomen ma yirpei yirpolo ki kelelawo Ma Ili wem ki kirpei kirpolo ki ninge lite Ma Ili? ");
INSERT INTO ong_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wuso ki kesiepe towa pite Eiya pele kolo olo, is ise ma yulpoiki pato. ");
INSERT INTO ong_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Le wuso ki kesiepe towa fei pepe, wolo ise yulpoiki kolo olo, ise wala ma ausi yulpope towa peiki wuso kesiepe pepe. Le ise yolpepe soma ise ma retai yoporotei yolpepei, Eiya lunkiki ki le ki kunkuwo Eiya.” ");
INSERT INTO ong_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pe nou pirpolo ma penglei Jisas wolo le naro le yawi taniepe. ");
INSERT INTO ong_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisas nou lalowi wof Jodan longlo le plen wuso Jon liti kaptetei mete, le nempis linu kaptetei mete ratei lepe. Jisas le ratei tulum fei lepe. ");
INSERT INTO ong_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mete wuru karowo pe le pe pirpei polpepei, “Jon liti kaptetei, le lirpei le menmen lipi nemple potei pire tute fale yaupe kolo olo, wolo il pele yeflipiye wuso lirpei liri metine fei lepei lepe olo punkom.” ");
INSERT INTO ong_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Le mete wuru pepe, pe pulpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Metine nele nange lele Lasarus, le ratei uf kumpu pinawo Betani. Le lire eri wiem mele, Maria re Marta pepi pratei uf Betani le Lasarus kainu. ");
INSERT INTO ong_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Maria notei fei nepei so kalulu nimpe wopu tipe neltalipe ire pite Apa Ili le ne nire oru lene naplolowo lope. Ne umo lene Lasarus so kainu lepe.) ");
INSERT INTO ong_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Eri wiem meme, me me maptei il pe Jisas mirpowo molpepei, “Apa Ili, numu leiyetei lepe olo kainu.” ");
INSERT INTO ong_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Wem Jisas lingitepe il fei pepei, le lirpeiye, “Lasarus ma la lasiepe kainu fei pepei kolo, kainu pepei ma kosape mete pire singe lipi pite Ma Ili pele, le ninge lite Ma Ili re ma kali nange ili.” ");
INSERT INTO ong_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas onom keremetei Marta nire winke Maria le umo Lasarus. ");
INSERT INTO ong_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Wem Jisas kapi il piti Lasarus wuso kainu lepe, Jisas wala ratei tulum elpesi lepe epli wem twinges. ");
INSERT INTO ong_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Leye lo Jisas lirpepe pupam pele lolpepei, “Ku ma nou me Judia.” ");
INSERT INTO ong_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Fei, pupam pele namti pirpowo Jisas polpepei, “Ko, ye metine piti eitalouku lepe, nempisye lepei mete pite Juda pirpolo ma posiye era le ye onposi piti ma nou e lom?” ");
INSERT INTO ong_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Liso Jisas lirpepe pupam pele lolpepei, “Wem epli fale le le lau le piti ma lautile, le wem ulel ko? Iyo. So wuso metine nele lire epli alepe niminye lilele le lepe, le miso nautesipe men nange le le lualo kolo olo wusoli epli lini luwowo fei, le le miso luntoli loporo. ");
INSERT INTO ong_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Le wuso metine lepe le lire mulpou le, is le ma nautesipe men nange le le ma lualo wusoli le olo lesio weli kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas lirpei il pepei re fei, Le nou reresipe lirpei lolpepei, “Numu louku Lasarus olo lualo letei luwo wolo ki ma ke kumtasi.” ");
INSERT INTO ong_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Le pupam pele namti pirpowo polpepei, “Ili louku, wuso Lasarus letei, le miso nou leilo.” ");
INSERT INTO ong_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Wolo Lasarus olo la fei, le Jisas lempetei lirpei lirerim lirpolo le olo letei. ");
INSERT INTO ong_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Liso Jisas lirpei nomnaipe pupam pele lolpepei, “Lasarus olo laye, ");
INSERT INTO ong_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","wem le la lepe, ki olo kiri kratei kolo. Le fei pepei ma kaneise piti yulpoiki so ki onom teingine. So ku ma me muluwo.” ");
INSERT INTO ong_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, (nange nele pinawo pirpolo “taunge noute”) le lirpepe ilepe wane pele, pupam pepe, lirpepe lolpepei, “Ku yeflipiye ma mire metine piti leitalouku lepe, miri mepi me soma ku ma miri mepi ma.” ");
INSERT INTO ong_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wem Jisas le fale, le kapi il pirpei pirpolo pe olo paltei Lasarus ye, epli wem twinges te twinges kari fei. ");
INSERT INTO ong_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Uf Betani olo lato malfem lire uf ili Jerusalem, ");
INSERT INTO ong_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","le mete wuru pite Juda olo pe piti pulweme Marta nire Maria le pe malfefime piti ma mirkilau onposio umo lelme wuso la lepe. ");
INSERT INTO ong_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Wem Marta ningitei wuso Jisas lau lepe, ne naro ne nuluwo le Maria olo nifei winem. ");
INSERT INTO ong_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta nirpowo Jisas nolpepei, “Apa Ili, wuso ye nempis liye au fale, umo leiki miso la fei lolpepei kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Wolo ki kretai, wuso ye fei eletei Ma Ili ire menmen, le ma waiye.” ");
INSERT INTO ong_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Fei, Jisas lirpene lolpepei, “Umo leiye miso nou leilo namin ratei.” ");
INSERT INTO ong_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Le Marta namti nirpowo Jisas nolo, “Ki kretai wem Ma Ili nou leilape mete, Lasarus re miso liripe nou peilo nampir pratei.” ");
INSERT INTO ong_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisas lirpeneye, “Ki kutei so nou keilape mete le ki watepe nempi liti pratei. Minele piti lulpoiki, le la wolo le ma nou namin ratei. ");
INSERT INTO ong_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Le metine minele piti wala namin ratei le le lulpoiki, le miso la kolo olotei. Marta, ye ulpope il fei pepei lo olo?” ");
INSERT INTO ong_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Fei, Marta namti nirpowo Jisas nolpepei, “Iyo, ili leiki, ki kulpoye kirpolo ye Krais, ninge lite Ma Ili lele wuso le lirpei piti ye ma au tef lepei lepe.” ");
INSERT INTO ong_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta nirpei il pepei re fei, ne ne nirpene winke pene Maria, nirpene louleye. Ne nirpene nolo, “Metine piti leptalo mete pepe, le olo lauleye le le lirpolo ma luliye.” ");
INSERT INTO ong_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wem Maria ningitei nolpepei, ne neilo frou naro ne yawi piti nuluwo Jisas. ");
INSERT INTO ong_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas wala le fale uf Betani kolo olo le wala so lile tulum elpesi wuso Marta naro nau falowo lepe. ");
INSERT INTO ong_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Le mete pite Juda wuso pirine Maria pepi pifei winem le pe malfefine nepe, wem pe pulwene wuso neifale frou naro ne yawi, pe re peifale pulsine. Pe onposi pirpolo Maria ma ne erau nample wuso palingi umo Lasarus luwo lepe le ne ma noutuwo. ");
INSERT INTO ong_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wem Maria ne fale nuluwo Jisas, ne nualo ratei ire yepe tef pele le ne nirpeiye, “Apa Ili, wuso ye nempis liye au fale, umo leiki miso la fei lolpepepi kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas lulwene noutiti le mete pite Juda wuso pirine pepi pau pepe, pe re pouti, le onom manepetei le onom pele re olo, onetei. ");
INSERT INTO ong_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Le ise yaltei linei?” Jisas lepletei. Fei, pe namti pirpowoye, “Ili louku, au untoli.” ");
INSERT INTO ong_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisas lus tipe falele. ");
INSERT INTO ong_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Liso mete pite Juda pepe pirpei nempleiye, “Yuntoli, le olo onposiotei.” ");
INSERT INTO ong_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wolo ilepe pelpe pirpeiye, “Le nempipe lutepe pite metine wuso lus olpe lepe ko? Le piti men ma le lusa Lasarus la fei lolpepei?” ");
INSERT INTO ong_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas onom pele nou onetei, le le erau nample wuso palingi Lasarus luwo le pe palfo erau filau laitei wingi. ");
INSERT INTO ong_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisas lirpeiye, “Weisi erau fei lepe tani.” Wolo Marta, umo lene Lasarus wuso la lepe, ne nirpeiye, “Ko ku maltei epli wem twinges te twinges kari fei, le wuso ku weisi erau filau lepe tani, nane olitei ma fale.” ");
INSERT INTO ong_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Leye lo Jisas lirpeneye, “Ko ki kirpeiye fei, wuso ye ulpoiki, ye ma ulwepe singe lipi pite Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pe so weisi erau lepe tani wingi. Jisas luntoli le teplai yuwei le le lirpeiye, “Eiya, ki onom teingine kireye piti ye apteiki mingim. ");
INSERT INTO ong_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ki kretai ye wem oli oli apteiki mingim, wolo ki kirpei il pepei wusoli ki onposiepe mete fei pile lepei piti pe ma pirkilau pulpo pirpolo ye yotei so aiteiki kau lepe.” ");
INSERT INTO ong_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jisas lirpei il pepei re fei, le lirkilau linai lirpeiye, “Lasarus-o, ye naro au.” ");
INSERT INTO ong_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Fei, Lasarus wuso la le pe paltei luwo erau nample lepe, le naro lau towa yawiye, ire re esi pele wuso pire olongou weisi, le pe paltei papwonou pepe, pele pifei kirye, le ranguwom wuso topuwo falo re mi mati lele re wala laitei lopopo mi mati pele. Jisas lirpepeye, “Nenfaripe yini pepe tanio le ise yusa le.” ");
INSERT INTO ong_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mete wuru pite Juda wuso pau pulwene Maria nepe, pe pulwepe menmen wuso Jisas lolpepe lepe le pe pulpowo. ");
INSERT INTO ong_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wolo mete ilepe pite Juda pepe, pe nou pe pirpepe mete ilepe pite Farasi, pirpepe pire Jisas wuso nou leila Lasarus lepe. ");
INSERT INTO ong_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Liso mete ilepe pite Farasi pepe, pe pire mete lipi piti pinuwepe mete piti peptawio Ma Ili siye, mete lipi pepei pe pau panfinemple le pe pirpei polpepei, “Ko ku ma molomen? Metine lepei, le lirpei le menmen lipi potei pire tute fale yaupe. ");
INSERT INTO ong_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wuso ku musa lolpepei le wem ulel, mete yeflipiye ma pulpowo le moli lipi pite Rom ma pau paltutu winem lite Ma Ili pe pe kali uf re tef towa louku tanuku.” ");
INSERT INTO ong_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Leye lo metine ili nele lelpe, nange lele Kaiafas, eringi fei pepe le ili piti linuwepe mete piti peptawio Ma Ili siye. Kaiafas lepe, le lirpepe ilepe wane pele lolpepei, “Ko ise retai men re kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ise yulwepe retape ko, pe ma pato poporo piti metine niliyeye ma la karipe lope le mete yeflipiye miso pratei teingipe, moli lipi pite Rom miso piripe nemple kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wolo Kaiafas onposiepe il fei pepe le le so lirpei yaupe lom? Olo. Eringi wem fei pepe le lesio towa linuwepe mete piti peptawio Ma Ili siye, le le linu lirpei piti menmen punkom ma fale pingi. Le linu lirpei piti Jisas ma la lungwipe mete pite Juda. ");
INSERT INTO ong_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jisas ma la lungwipe pe poteteiye kolo olo, wolo le la piti kaniepe eple pite Ma Ili pele wuso kere pratei eryai pepe, kaniepe eple pite Ma Ili pele wuso kere pratei eryai pepe, kaniepe piti ma nou pau pratei peifonemple watafei pe pite alpe niliyeye lepe. ");
INSERT INTO ong_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Epli wem fei lepe le le le, mete lipi pite Juda kapi il paptei piti ma petesi Jisas la. ");
INSERT INTO ong_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Liso Jisas le lulwepe mete pite Juda alepe nimin kolo olo. Le kotire le fale uf kumpu pinawo Ifrem, lato tef oli malfem, tef oli era re telmane ye yawi. Jisas liripe pupam pele pe pratei uf fei lepe. ");
INSERT INTO ong_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wem ili liti mete pite Juda ma onposio wem Ma Ili kaniepe manre yaire pelpe pau tani Isip, wem fei lepe olo lau lire malfemye. Le mete wuru pusape uf pelpe le pe punwei pe Jerusalem, piti popori potei soma Ma Ili ma onom teingine lasiepe wem pe rautuwo wem ili fei lepe. ");
INSERT INTO ong_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pe pintatawo Jisas le wem pe panfinemple pifei winem lite Ma Ili, pe peite nemple pirpeiye, “Ise onposi yolomen? Wem ili fei lepei, Jisas ma lau lo olo?” ");
INSERT INTO ong_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wem fei lepe mete lipi piti pinuwepe peptawio Ma Ili siye, le mete pite Farasi, pe pinu watepe mete il piti wem pe puluwo Jisas, pe ma frou pe pirpepe soma pe ma penglei. ");
INSERT INTO ong_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Epli wem pire eti plen poungo le niliyeye, epli wem fei pepei wala pato piti mete pite Juda ma papli oweli lipi piti onposio wem wuso Ma Ili kaniepe manre yaire pelpe pau tani Isip. Jisas le uf kumpu Betani, uf lite Lasarus wuso linu la le Jisas nou leila lepe. ");
INSERT INTO ong_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pe paplio Jisas oweli. Marta napwe oweli naptetei wem Lasarus lire Jisas tepi tifei ponu. ");
INSERT INTO ong_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Leye lo Maria nila mili pau lire nimpe tipe, le nimpe tipe fei lepei olo teingi woputei le pe ma pire era lipi paise. Maria kalulu nimpe tipe lepei neltalipe ire yepe pite Jisas le ne nire oru lene nou naplolowo lope. Wopu lite nimpe tipe lepe loungo linkingi winem, winem re wopuye. ");
INSERT INTO ong_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Fei, pupam nele lite Jisas, pinawo Judas lite Iskariot, le metine piti laltei Jisas le eti pite mete olpe. Le lirpei lolpepei, ");
INSERT INTO ong_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nimpe tipe teingi woputei fei lepei, ise yaltepe mete nemple paise ko, le era lipi (1200 kina), le era fei pepe ise ma weisipe watepe mete wuso pe oweli yini nange naplei pepe.” ");
INSERT INTO ong_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas lite Iskariot lirpei il pepei wusoli le onposiepe mete wuso oweli yini nange naplei pepe lom? Olo. Le lirpei wusoli le olo metine oli piti lire ausi, le le luntoluwo mole ufau lelpe liso le onposi piti ma kane lotei. ");
INSERT INTO ong_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Wolo Jisas lirpowo Judas lolpepei, “Ye usane. Ne fei nolpepei lepe, ne ninu noporiki piti wem pe ma peiteiki le ne miso nou onposiepe. ");
INSERT INTO ong_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wem oli oli mete wuso oweli yini nange naplei pepe pe miso pireise ratei. Wolo ki olo, ki miso kireise mepi ratei wem oli oli kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mete wurutei pite Juda wuso pingitepe il pirpei pirpolo Jisas olo lau lifei uf Betani, pe poli nemple pe piti ma puluwo. Pe pe puluwo Jisas loteteiye kolo olo, wolo pe pe piti ma puluwo Lasarus re wuso la wolo Jisas nou leila lepe. ");
INSERT INTO ong_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Liso mete lipi piti pinuwepe peptawio Ma Ili siye, pe pepletei nemple il piti ma petesi Lasarus re la, ");
INSERT INTO ong_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","wusoli le lotei so mete wuru pite Juda pepe, pe pusape mete lipi pelpe le pe weitei pulpowo Jisas wem pe pingitepe il piti Jisas nou leila Lasarus. ");
INSERT INTO ong_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mete wurutei wuso pau pratei Jerusalem piti ma rautuwo wem ili piti Ma Ili kaniepe manre yaire pelpe pau tani Isip, nolowi pe so pingitepe il pirpei piri Jisas ma le Jerusalem. ");
INSERT INTO ong_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pe so kapi oflongelem pilape naro pe penglei esi, le pe pailolo pirpei polo, “Meila nange lite Ma Ili. Ma Ili lailolowo metine piti lau lire nange lite Ili. Ma Ili ma lailolowo re luntoluwo metine ili lite Israel.” ");
INSERT INTO ong_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas lerengawo donki nele le le longlo lifowo tounga, min watafei il piti paitei yousi pe pirpei pepe. Il pirpei polo, ");
INSERT INTO ong_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Eple pite Jerusalem, ise turise pato. Metine ili leise min liplau, lifei tounga lite donki ninge.” ");
INSERT INTO ong_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wem fei lepe, Jisas pupam pele olo pire wouye pretai men re kolo. Wolo wem Jisas la le Ma Ili nou leila, wem fei lepe so pupam pepe pe onposiepe menmen wuso falowo pepe, le pe so pretai polpepei, il piti paitei yousi pe pirpei liso mete pingiepe piti polpepei piri Jisas. ");
INSERT INTO ong_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mete wurutei wuso pile puluwo Jisas linawo Lasarus naro lau tani erau nample wuso paltei luwo lepe le Jisas nou leila namin ratei, mete fei pepe, pe kete il pirpepe mete wurutei pite Jerusalem pepe. ");
INSERT INTO ong_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Min polpepei so mete wurutei fale panfi Jisas wusoli pe pingitepe il fei piti le laptei menmen lipi fei pepei fale. ");
INSERT INTO ong_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Le mete pite Farasi, pe pirpei nempleiye, “So ise yulwepeye lom? Ku miso weisi kolo oloye. Yuntoli, mete piti tef ili yefliye olo weitei pulsiye.” ");
INSERT INTO ong_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mete ilepe pite Grik, pe peingalope mete wuso pe Jerusalem piti rautuwo wem ili liti Ma Ili kaniepe manre yaire pite Juda pau tani Isip. Mete ilepe pite Grik peingalope mete fei pepe. ");
INSERT INTO ong_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mete ilepe pite Grik pepei, pe pe falowo Filip. Le lite uf Betsaida lato tef lite Galili. Le pe pirpowo Filip polpepei, “Ili louku, ku mintawo Jisas piti ma muluwo.” ");
INSERT INTO ong_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fei, Filip le lirpowo Andru le te rounge te tirpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisas namti lirpepe lolpepei, “Wem leletei fei faleye piti Ninge lite Metine Wape ma kali nange ili. ");
INSERT INTO ong_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ki kirpeise punkom, wit fouri nenpeiye, le wuso ne nualo ne tef kolo olo, ne ma fale nilape fouri nemple kolo olo. Wolo ne ma nualo ne tef le tef lanpo soma uwol fale nile le ne ma nilape fouri wuru. ");
INSERT INTO ong_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Metine minele piti onom puwol lotei, le ma lalingou nempi lele. Le metine minele piti onom pinauli lotei wem le ratei tef fei lepei, le ma lailele lotei piti ratei lingi wem wem. ");
INSERT INTO ong_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Metine minele lirpolo ma lesio towa leiki, le ma lulteiki soma uf liti ki kratei, uf fei lepe so metine piti lesio towa leiki lepe re ma le lireiki ratei. Metine piti lesio towa leiki, Eiya leiki ma lailolowo metine fei lepe.” ");
INSERT INTO ong_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jisas nou lirpei lolpepei, “Fei ki onom peiki one le ki ma kirpei il menemple? Ki ma kirpei kirpolo, ‘Eiya, ye usa wem fei lepe lau faleiki kolo olo,’ ki ma kirpei kolpepe lom? Olo. Il pal min pepei so ki kau piti ma kila moingi kiri wem fei lepe. ");
INSERT INTO ong_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Eiya, ye kosape mete ire singe lipi peiye.” Leye lo il nemple pirpei fale teplai yuwei pau pirpei polpepei, “Ki kosape mete kire singe lipi peiki fei, le ki ma nou kosape.” ");
INSERT INTO ong_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mete wurutei wuso pile pepe, pe pingitepe il wuso fale teplai yuwei pau pepe le pe pirpeiye, “Kuna teplai loungongo.” Le ilepe pirpei polo, “Olo, riri lite yuwei lirpowo.” ");
INSERT INTO ong_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Wolo Jisas lirpepe lolpepei, “Il wuso pirpei fale teplai yuwei pau pepe, pe pirpei piti kaneiki ki lom? Olo. Pe pirpei piti kaneise ise. ");
INSERT INTO ong_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Wem fei lepei, le wem liti Ma Ili ma kapi il laptei liripe mete piti tef. metine oli wuso ratei luntoluwo tef fei lepei lepe, singe pele fei ma Ma Ili kapi weisipe. ");
INSERT INTO ong_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wem pe peilaiki ke yuwei tani tef, mete yeflipiye piti tef lepei ma ki keipipe kaptei kutei.” ");
INSERT INTO ong_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Wem Jisas lirpei il fei pepei, le lirpei lirerim lire tisi piti le ma la lolomen.) ");
INSERT INTO ong_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Fei, mete wurutei pepe, pe namti pirpowo Jisas polpepei, “Ku Il Lipi pouku pirpouku polpepei, ‘Krais miso la kolo olo, le ma ratei lingi wem wem. Ye olomen so irpei irpolo pe ma peila Ninge lite Metine Wape le yuwei lepe? Ninge lite Metine Wape lepe, le minele?” ");
INSERT INTO ong_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Leye lo Jisas nou lirpepe lolpepei, “Weli ma lini nainuse wem kurauye. Wem weli wala lini, ise kotopa isotei le ise yingowo tisi tuwopou soma munkunum ma fale keraiteise kolo olo. Wusoli wem metine nele lire munkunum lilele le, tisi piti lingowo le lepe olo ma lirowo onom, le le ma fupeletei. ");
INSERT INTO ong_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ise yulpowo metine piti lesio weli fei lepei wem le wala lireise ratei. Ise yolpepe soma ise fale yire mete piti ratei weli alepe nimin.” Wem Jisas lirpei il pepei re fei, le le leingi lotei kotire taniepe. ");
INSERT INTO ong_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pe pire lutepe pelpe potei pulwepe menmen lipi wuso Jisas lirpei le pe potei pire tute fale yaupe pepe, wolo olo, mete pite Juda pepe, pe pulpowo Jisas kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Liso il wuso metine nimou Aisaia linu lirpei pepe, pe fale punkom. Il pele pirpei polpepei, “Ma Ili, minemple re pulpope il wuso ku mirpei pepe kolo olo. Le mete minemple so ye kosape ire singe peiye pepe?” ");
INSERT INTO ong_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Men polpepei so pe pulpo kolo olo wusoli Aisaia linu reresipe il lirpei liripe fei. Aisaia lirpei lolpepei, ");
INSERT INTO ong_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ma Ili kapi lapsisiepe le pe so pulwepe kolo olo, le le kapi enke pelpe namiepe le pe so pretai kolo olo. Le pe miso nou weitei kani onom panteiki piti ki ma kapi moingi pelpe taniepe kolo olo, Ma Ili lirpei lolpepei.” ");
INSERT INTO ong_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Metine nimou Aisaia lirpei il pepei liri Jisas wusoli le wata pirpolo le linu lulwepe singe pite Jisas. ");
INSERT INTO ong_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Wem fei lepe mete lipi pite Juda, wuru pelpe pulpowo Jisas, wolo pe turwepe pasiepe mete pite Farasi le pe pirpei alepe nimin kolo olo. Pe turwepe piti pirpei alepe nimin wusoli mete pite Farasi ma paptu tani angli pau lelpe. ");
INSERT INTO ong_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pe onposi piti pailelene onom pite Ma Ili lom, olo pe onposi piti pailelepe mete enke. ");
INSERT INTO ong_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas lirpei il lipi lirpeiye, “Metine minele piti lulpoiki ki, le lulpoiki ki kuteteiye kolo olo, wolo le lulpowo metine wuso laiteiki kau lepe re, le lulpowo. ");
INSERT INTO ong_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Metine minele piti luliki, le luliki ki kuteteiye kolo olo, wolo le luluwo metine wuso laiteiki kau lepe re, le luluwo. ");
INSERT INTO ong_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ki kila weli kau tef lepei, le minemple piti pulpoiki ki, pe yeflipiye miso pratei pire munkunum kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Metine minele piti lingitepe il peiki le le laptei mingim kolo olo, ki ma kapi il kaptei kiri metine fei lepe kolo olo. Ki kau tef lepei piti kapi il kaptei kiripe mete kolo olo, wolo ki kau piti kaniepe mete piti tef pratei pingi wem wem. ");
INSERT INTO ong_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Metine minele piti linauleiki le le tounga pesipe il peiki, minemple ma kapi il paptei piri? Il potei wuso ki keptalo pepe, il pepe soma pirpei nomnaipe piri metine fei lepe, le teingi lo le oli. Wem Ma Ili nou leilape mete, il pepei ma pirpei piri. ");
INSERT INTO ong_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Iyo, ki kirpei kire onom peiki kolo olo, wolo Eiya wuso laiteiki kau lepe, le waiki il piti ki kingiepe kirpei. ");
INSERT INTO ong_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Le ki kretai, il singe pele ma kanowo metine piti ratei lingi wem wem. So il menmen piti ki kirpei pepe, Eiya lotei lirpeiki piti kirpei.” ");
INSERT INTO ong_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Epli wem niliyeye lato piti mete pite Juda ma papli oweli lipi piti rautuwo wem wuso Ma Ili kaniepe yaire manre pelpe pau tani Isip. Jisas retai piti wem leletei so faleye piti le ma lusa tef lepei le le ma nou le yaitei lele. Jisas wem oli oli onom puwope pupam pele piti tef lepei, le fei le kosape le onom kerepetei. ");
INSERT INTO ong_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisas lire pupam pele pifei paplei oweli. Le Towa olo onposi fei piti ma leilawo Judas onom le le ma laltei Jisas le eti pite mete olpe. Judas, le ninge lite Saimon lite uf Iskariot. ");
INSERT INTO ong_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas retai lolpepei, yaitei lele olo lirkilau watowo singe fei, le watowo singe piti luntoluwepe menmen pite tef le yuwei, le le retai le laule Ma Ili le le ma nou le Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jisas lusape pupam pele pifei ponu le le leilo lile. Le kotuwo olol piti lalfo lifei yuwei lepe, kotuwo tani le le kali ranguwom liti pire paltu tipe, kali lari lifei pau lele. ");
INSERT INTO ong_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Leye lo le kali tipe weisi lalfo waifile le le so kaptetei ire yepe pite pupam pele, le le lire ranguwom wuso lari lifei pau lele lepe, lire laplele tipe tani ire yepe pelpe. ");
INSERT INTO ong_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jisas kaptetei ire yepe pite pupam wuru pepe, kaptetei leinei leinei lau falowo Saimon Pita. Fei, Saimon Pita lirpowo Jisas lolpepei, “Ili leiki, ye ma kaptetei ire yepe peiki lom?” ");
INSERT INTO ong_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Le Jisas namti lirpowo lolpepei, “Menmen fei ki kolpepei lepei lepe, ye olo retai kolo, wolo wem wala lato piti ye ma retai.” ");
INSERT INTO ong_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Wolo Pita lirkilau lirpowo Jisas lolpepei, “Olo, ye ma kaptetei ire yepe peiki kolo olotei.” Fei, Jisas nou lirpowo Pita lolpepei, “Wuso ki kaptetei ire yepe peiye kolo olo, is ye ma pupane leiki kolo oloye.” ");
INSERT INTO ong_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Liso Saimon Pita namti lirpowo Jisas lolpepei, “Ili leiki, ye kaptetei ire yepe peiki poteteiye kolo olo, esi pire falo leiki re ye ma kaptetei apwonou.” ");
INSERT INTO ong_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Wolo Jisas nou lirpei lolpepei, “Metine minele wuso lungungu fei lepe, le olo teingiye, le le ma nou keitete lotei kolo. Ire yepe poteteiye miso le nou kaptetei. Le ise yeflipiye olo teingipe wolo niliyeye leise so oli, teingi kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Jisas olo retai fei piti metine minele ma laltei le eti pite mete olpe le min polpepei so le lirpei lolo, “Ise yeflipiye olo teingipe le niliyeye leise so metine oli.”) ");
INSERT INTO ong_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas kaptetei ire yepe pite pupam pele re fei, le nou kali olol lele piti lalfo lifei yuwei lepe, kali lalfo le le lifei tulum lele piti lifei ponu pepe. Fei, le lepletei pupam pele lolpepei, “Ki fei kolpepe kireise pepe, ise retai lo olo? ");
INSERT INTO ong_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ise yinaiki yirpolo ki metine piti keitaloise le ise yinaiki yirpolo ki ili leise. Iyo, ise yingiepe tuwopou piti yinaiki fei yolpepe wusoli ki kutei so lepe. ");
INSERT INTO ong_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ki ili leise le ki metine piti keitaloise, le ki min kaptetei ire yepe peise pepe. Le ise re ma kaptetei ire yepe pite isotei wane. ");
INSERT INTO ong_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ki kalteise tisi lato fei piti ise ma yingiepe watafei ki kolpepe kireise pepe. ");
INSERT INTO ong_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ki kirpeise punkom, metine piti lesio towa yawi, le ma onposi lotei lirpolo le metine ili linuwo moli ili lele kolo olo. Le metine piti lilape il, le ma onposi lotei lirpolo le metine ili linuwo metine wuso laisi le lepe kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ise fei retape il punkom pepei le wuso ise yingiepe, ise ma enke teingipe.” ");
INSERT INTO ong_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ki kirpeise kire ise yeflipiye kolo olo, ki kretaise ise minemple ki kutei keinise. Wolo il wuso paptei paitei yousi pepe ma fale punkom. Il wuso pirpei polpepei, ‘metine piti lireiki wepi waplei ma weitei luraiki.’ ");
INSERT INTO ong_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ki kinu kirpeise kire il fei pepei le menmen pepe wala fale pingiepe il pepei kolo, wala olo. Le wem menmen fei pepe fale, ise miso yulpo yirpolo ‘ki kutei so lepe piti kratei kingi wem wem’. ");
INSERT INTO ong_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ki kirpeise punkom, metine piti lailolowo metine minele wuso ki kaisi le lepe, le lailolowo metine wuso ki kaisi le lepe le ki re le laileleiki. Le metine piti laileleiki, le laileleiki le le lailolowo metine lotei wuso laiteiki kau lepe.” ");
INSERT INTO ong_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas lirpei il pepei re fei, onom pele weitei onetei le le lirpei nomnaipe lolpepei, “Ki kirpeise punkom, nele leise ma leiteiki ke eti pite mete olpe.” ");
INSERT INTO ong_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Fei, pupam pele pepe pinlele potei olpe le pe lupilai nemple, enke pirpei potei piti minele so le lirpei liri lepe wusoli pe wala pire wouye. ");
INSERT INTO ong_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pupam nele lelpe wuso Jisas onom kerowotei liri lepe, le olo lifei malfem lire Jisas. ");
INSERT INTO ong_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Liso Saimon Pita kanowo mi le le lirpeiye, “Eletei, minele so le lirpei liri lepe.” ");
INSERT INTO ong_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Liso pupam lepe lintire le lirowo Jisas malfem, lifei laitowo lapi plen le le so leletei Jisas lolpepei, “Ili leiki, ye irpei iri minele?” ");
INSERT INTO ong_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisas namti lirpowo pupam lepe lolpepei, “Ki ma kolto luom linge oweli tipe le ki ma watowo metine fei lepe.” Leye lo Jisas kari luom ile lolto linge oweli tipe le le watowo Judas, le ninge lite Saimon lite uf Iskariot. ");
INSERT INTO ong_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Wem Judas kali luom wuso Jisas watowo lepe, frou yo fei towa lunkuwo Judas-ye. Jisas lirpowo Judas lolpepei, “Ye frou e olpepe menmen wuso ye ma olpepe lepe.” ");
INSERT INTO ong_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pupam wuso pifei ponu pepe, nele lelpe re retai piti polomen so Jisas lirpowo Judas lire il fei pepe, olo pironom. ");
INSERT INTO ong_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas luntoluwo mole ufau lelpe le pupam ilepe pepe onposi pirpolo Jisas lirpowo Judas piti ma le laisepe oweli menmen piti pe ma papli piti rautuwo wem ili lite Juda, lo Jisas lirpowo piti ma lilape era le watepe mete wuso pe oweli yini nange naplei pepe. Pupam ilepe onposi fei polpepe. ");
INSERT INTO ong_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas kali luom, leifale frou naro le yawi leye. Wem fei lepe olo mulpou. ");
INSERT INTO ong_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas naro le re fei, Jisas lirpei lolpepei, “Fei Ninge lite Metine Wape ma kosape mete lire nange ili lele, Ma Ili re kali nange ili. ");
INSERT INTO ong_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Le wuso Ninge lite Metine Wape ma kosape mete lire nange ili lite Ma Ili, is Ma Ili ma kali nange ili wem le kosape mete lire nange ili lite Ninge lite Metine Wape le le ma frou lolpepe. ");
INSERT INTO ong_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Eple peiki, ki ma kireise ratei wem ulel kolo olo. Ise ma yintataiki wolo ki fei ma kirpeise kire il wuso nempis kinu kirpepe mete pite Juda pepe, kirpepe kirpolo, ‘tulum piti ki ma ke lepe, ise miso ye kolo olo.’ ");
INSERT INTO ong_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Il yeflipi pepei ki il polise piti ise ma kani onom yante nemple. Min watafei ki kani onom kanteise, so ise re ma kani onom yante nemple. ");
INSERT INTO ong_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wuso ise kani onom yante nemple, mete yeflipiye ma pretai piti ise yulpoiki. ");
INSERT INTO ong_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Leye lo Saimon Pita leletei Jisas lolpepei, “Ili leiki, ye ma epinei?” Le Jisas namti lirpowo lolpepei, “Tulum liti ki ma ke lepe, ye fei ma ulteiki e kolo olo, wolo wem wala lato piti ye ma ingeiki e.” ");
INSERT INTO ong_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita nou leletei Jisas lolpepei, “Ili leiki, piti polomen so ki fei ma kulteiye ke kolo olo lepe? Ki koporo kutei fei piti ma ka kareye lope.” ");
INSERT INTO ong_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisas namti lirpowo Pita lolpepei, “Ye opori yotei punkom piti ma a kareiki lope lom? Ki kirpeiye punkom, wem woflu wala koro kolo olo, wem twinges niliyeye ye ma irpei ireiki yef irpolo ye olo retaiki kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas lirpepe pupam pele lolpepei, “Ise enke moingipere enke olpe kolo olo. Ise yulpowo Ma Ili le ki re ise yulpoiki. ");
INSERT INTO ong_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Elpeingo wuru pato winem lite Eiya leiki, le ki ke piti ma koporise tulum. Wuso pepei olo punkom kolo olo, ki ma kirpeise kolo. ");
INSERT INTO ong_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Le wem ki ke kopori tulum leise re fei, ki ma nou kau le ki ma keteise kilaise ye ki kutei soma ise ma ratei tulum wuso ki kratei lepe. ");
INSERT INTO ong_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ise retawo tisi liti ye uf wuso ki ma ke lepe.” ");
INSERT INTO ong_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas lirpowo Jisas-ye, “Ili louku, tulum liti ye ma e lepe, ku olo mretai kolo. Ku molomen ma mretawo tisi liti me lepe?” ");
INSERT INTO ong_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisas namti lirpowo lolpepei, “Ki kutei so watafei tisi liti mete ma pe Eiya, le ki kosaise il punkom pite Ma Ili, le il fei pepe ma kaniepe mete piti pratei pingi wem wem. Tisi nele nele re kolo olo, ki kutei so tisi liti mete ma pingowo pe Eiya. Mete ma pau ki wo, pe soma pe Eiya. ");
INSERT INTO ong_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ise fei retaiki, Eiya leiki re ise retawo le wem fei lepei le le le, ise retawo Eiya le ise olo yuluwo fei.” Jisas lirpepe pupam pele pepe. ");
INSERT INTO ong_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip lirpowo Jisas lolpepe, “Ili louku, ku onposiepe menmen nempleiye fei pepei, ye kosauku Eiya.” ");
INSERT INTO ong_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisas namti lirpowo Filip, “Ko Filip, wem ulel ki kireise yeflipiye mratei wolo ye wala ireiki onom lom? Metine piti luliki fei, Eiya re metine lepe luluwo. Piti men so ye irpei irpolo ki ma kosaise Eiya lepe? ");
INSERT INTO ong_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ki kunkuwo Eiya le Eiya lunkiki, le Filip, ye ulpope il pepei lo olo? Il wuso i kirpeise fei pepe, il pepe ki peiki kutei onposiepe, le ki kirpei lom? Olo. Eiya wuso lunkiki lepe, le so waiki il piti kingiepe kirpei pepe. ");
INSERT INTO ong_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ise yulpoiki wem ki kirpei kirpolo ki kunkuwo Eiya, le Eiya lunkiki. Wuso ise yulpoiki kolo olo, men nange wuso ki kingiepe kesiepe fale alepe nimin pepe soma ise yulpope pepe ko. ");
INSERT INTO ong_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ki kirpeise punkom, metine minele piti lulpoiki, le miso lesio towa wuso ki kesio lepe. Iyo, ki miso kanowo lirkilau lesio towa ili linuki ki, wusoli ki ma ke Eiya. ");
INSERT INTO ong_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Le wuso ise yiri nange leiki yiri yeiteiki yire men nange, ki ma waise wusoli ise peiki. Ki kolpepe soma ninge ma kosape mete lire nange ili lite yaitei lele. ");
INSERT INTO ong_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Wuso ise yiri nange leiki yiri yeiteiki yire men nange, ki ma waise wusoli ise yulteiki ki.” ");
INSERT INTO ong_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jisas reresipe il lirpepe pupam pele lolpepei, “Wuso ise onom puwoiki, ise ma yingiepe il peiki. ");
INSERT INTO ong_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ki ma keletei Eiya le le ma waise singe nele, le Riri piti lirpei il punkom, le le ma lireise ratei wem oli oli. ");
INSERT INTO ong_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mete eryai piti tef miso kali kolo olo, wusoli pe miso puluwo lo pretawo kolo olo. Wolo ise olo retawo fei, wusoli le lireise ratei le le ratei leinginim peise.” ");
INSERT INTO ong_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ki ma kusaise isoteiye ratei kolo olo, ki ma nou kareise kau. ");
INSERT INTO ong_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wem kurauye mete piti tef miso puliki kolo olo, wolo ise miso yuliki wusoli ki namin kratei le ise re ma nampir ratei watafei ki. ");
INSERT INTO ong_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wem epli wem fei lepe fale, ise miso retai yolpepei, ki kire Eiya, ku mete twinges kolo olo, ku niliye watafei metine niliye lepe, le ise yireiki ki re, ku nemple nemple kolo olo, ku nempleiye watafei metine niliye lepe.” ");
INSERT INTO ong_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Metine minele piti kapi il peiki le le lingiepe, le metine piti onom puwoiki. Eiya leiki ma onom puwol metine minele wuso onom puwoiki lepe, le ki re ma onom puwol metine fei lepe, le ki ma kosawo kire ki kutei.” ");
INSERT INTO ong_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Fei, Judas nele, (Judas lite Iskariot lepe olo), Judas nele fei lepei, le leletei Jisas lolpepei, “Ili louku, piti polomen so ye ma kosauku ku ire ye yotei le mete eryai piti tef pepe ma ye kosape ire ye yotei kolo olo lepe?” ");
INSERT INTO ong_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas namti lirpowo lolpepei, “Metine minele piti onom puwoiki, le ma lingiepe il peiki. Eiya leiki ma onom puwol metine fei lepe, le ki kire Eiya ma wau falowo le ku ma wiri metine lepe mepi ratei. ");
INSERT INTO ong_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Metine minele piti onom puwoiki kolo lepe, le ma lingiepe il peiki kolo olo, ma linaulipe. Il wuso ise yingitepe fei pepe pe peiki kolo olo, pe il piti paule Eiya wuso laiteiki kau lepe.” ");
INSERT INTO ong_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ki kirpeise kire menmen fei pepei fei wem ki wala kireise ratei. ");
INSERT INTO ong_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Wolo singe piti kaneise lepe, le Riri Teingi, le Eiya ma laisi lau lire nange leiki. Le ma leitaloise lire men nange yeflipiye le le ma leilaise enke piti ise ma nou onposiepe il yeflipiye wuso ki kirpeise pepe.” ");
INSERT INTO ong_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ki kusaise ratei yire enke malye, onom malye peiki kutei ki waise. Ki waise onom malye watafei mete piti tef waise nepe kolo olo. Ise enke moingipe re enke olpe pato, le ise turise pato. ");
INSERT INTO ong_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ise yingiteiki kirpeise kirpolo, ‘Ki ma kusaise, le ki ke, wolo ki ma nou kareise kau.’ Le wuso ise onom puwoiki, enke peise ma teingipe piti ki ma nou karowo Eiya ke, wusoli le olo singetei linuki ki. ");
INSERT INTO ong_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Menmen pepe wala fale kolo le ki kinu kirpeise fei soma wem pe fale, ise ma yulpo yirpolo il peiki olo punkom. ");
INSERT INTO ong_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ki ma kireise mepi mirpei me wem ulel kolo olo, wusoli metine piti luntoluwo tef lepei olo lauye. Le miso weiteiki kolo olo, ");
INSERT INTO ong_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","wolo mete piti tef ma pretai polpepei, ki onom puwol Eiya, le min polpepei so ki ma kesiepe men nange yeflipiye kingiepe il wuso Eiya lirpeiki piti kingiepe pepe.” “Ise yau, ku ma me tani tulum fei lepei.” ");
INSERT INTO ong_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ki watafei nimpe wain teingi liti lilape fouri teingipe, le Eiya leiki, le watafei metine piti lari liom wain. ");
INSERT INTO ong_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nimpe wain ine yeflipiye wuso pilape fouri kolo olo pepe, Eiya leiki ma yaruwepe tani wain nimou. Le ine yeflipiye wuso pilape fouri pepe le ma laptutu loporipe soma pe ma fale teingipe le pe ma pilape fouri wuru. ");
INSERT INTO ong_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ise fale teingipe fei, wusoli il wuso ki kirpeise pepe, pe pireise teingipe. ");
INSERT INTO ong_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ise ma kani onom yanteiki le ki re ma kani onom kanteise. Nimpe wain unou loteteiye ire pele miso lilape fouri kolo olo, le ma loli wain nimou soma le ma lilape fouri. Ise watafei wain ine pepe, wuso ise yile ire peise, le ise kani onom yanteiki kolo olo, ise ma yesiepe towa men teingipe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ki watafei wain nimou le ise watafei wain ine. Metine minele piti kani onom lanteiki le ki re kani onom kantowo, metine fei lepe ma lesiepe towa teingipe wuru. Le wuso ki kaneise kolo olo, ise miso yesiepe towa men re kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Metine minele piti kani onom lanteiki kolo olo, le ma watafei wain unou wuso yaruwo le pe piri le towa yawi piti ma lire punko lepe. Ine olpe pire punko fei polpepei, pe ma papwonou kapi pilape pe piripe pinki weli le weli ma laplei. ");
INSERT INTO ong_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Le wuso ise kani onom yanteiki le il peiki prateise leinginim, men nange wuso ise onposiepe le ise yeiteiki yiripe pepe, ise ma kapi. ");
INSERT INTO ong_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wem ise yesiepe towa teingipe wuru le mete pretaise pirpolo ise pupam peiki, towa teingipe peise ma kosape mete pire nange ili lite Eiya leiki. ");
INSERT INTO ong_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ki onom puwoise watafei Eiya, le onom puwoiki lepe le ise yingiepe il peiki soma ki ma onom puwoise. ");
INSERT INTO ong_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Min watafei ki, ki kingiepe il pite Eiya le le so onom puwoiki, le ise re ma yingiepe il peiki soma ki ma onom puwoise.” ");
INSERT INTO ong_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ki kirpeise fei kire menmen fei pepei soma enke peise ma teingipe watafei ki, le ise ma yirkilau enke teingipe. ");
INSERT INTO ong_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ki kire il singe kirpeise kolpepei, ise ma onom puwo nemple, min watafei ki onom puwoise pepe. ");
INSERT INTO ong_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Metine piti lirkilau onom puwope mete numuwi pele, le ma la lungwipe. ");
INSERT INTO ong_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Le ise ma numuwi peiki, wuso ise yingiepe il peiki. ");
INSERT INTO ong_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ki ma kinaise kirpolo ise mete piti yesio towa lite metine nele yawi lom? Olo. Ki ma kinaise fei kolpepe kolo, wusoli metine piti lesio towa yawi lepe, le lironom lire towa wuso moli ili lele lesio lepe. Wolo ki kinaise kirpolo ise numuwi peiki wusoli il men nange wuso Eiya leiki lirpeiki liripe pepe, ki nampli kirpeise yalipeye. ");
INSERT INTO ong_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ise keiniki kolo olo, ki keinise le ki waise towa piti ye yesio, le towa fei lepe ma fale ili le le ma lualo kolo olo. Le wem ise yiri nange leiki yeletei Eiya piti ma waise menmen, le ma waise. ");
INSERT INTO ong_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Il singe pepei ki kirpeise, ‘Ise onom puwo nemple.’” ");
INSERT INTO ong_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Wuso mete piti tef lepei pe enke olpe pireise, ise ma retai yolpepei, pe pinu enke olpe pireiki. ");
INSERT INTO ong_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Wuso ise pite tef lepei mete ma onom puwoise watafei ise nange pelpetei pepe. Ise pite tef lepei wolo ki keinise le ise piti tef lepei kolo oloye, min polpepei so mete ma enke olpe pireise. ");
INSERT INTO ong_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ise ma onposiepe il wuso kirpeise kirpolo, ‘metine piti lesio towa yawi lite moli ili nele, metine piti lesio towa yawi lepe le ma onposi lotei lirpolo le lesio towa ili linuwo moli ili lele kolo olo, le ma onposi lolpepe kolo.’ Wuso mete piti tef lepei pe waiki moingi, ise re pe ma waise moingi. Le wuso pe pingiepe il peiki wuso keptalo pepe, is ise re pe miso pingiepe il peise. ");
INSERT INTO ong_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Wolo pe ma waise moingi wusoli ise peiki, le pe polpepei pireise wusoli pe olo pironom pire metine wuso laiteiki kau lepe. ");
INSERT INTO ong_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Wuso ki kau kirpepe kire il pite Ma Ili kolo olo, is pe ma pirpei pirpolo pe olo pingiepe il olpe kolo olo. Wolo fei pe pingitepe il pite Ma Ili wuso ki keptalo pepe le pe ma pire yef polomen, olo pe ma pila moingi. ");
INSERT INTO ong_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Metine minele piti onom one lasiki, le onom one lasio Eiya leiki re. ");
INSERT INTO ong_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ki kaptei menmen lipi fale peingalope nimin le metine nele re lolpepe watafei ki kolo olo. Le wuso ki kaptei menmen fei pepei falepe kolo, is pe miso pirpei pirpolo pe olo pingiepe il olpe kolo olo. Wolo pe fei potei pire lutepe pelpe pulwepe menmen lipi wuso ki kaptei falepe nimin pepe, le pe olo wala enke olpe pasiki ki kire Eiya leiki. ");
INSERT INTO ong_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Menmen fei pepei fale piti ma paptei il wuso paitei Il Lipi pelpe pepe ma fale punkom. Il wuso pirpei pirpolo, ‘Il pal re olo, wolo pe enke olpe pasiki yawi.’” ");
INSERT INTO ong_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Singe liti kaneise miso lau, le Riri liti lirpei il punkom le le ma laule Eiya. Le lire Eiya ratei le ki ma kaisi lau ise, le le ma lirpei lireiki ki. ");
INSERT INTO ong_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Le ise re ma lirpepe mete yireiki ki wusoli wem linutei piti ki keptalo il, ise yulteiki mepi me mau.” ");
INSERT INTO ong_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ki kirpeise fei kire il pepei soma ise ma yire wilfingou piti yulpoiki kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pe ma peituse tani angli pal pelpe. Le wem wala lato, wem metine minele piti leteteise ya, le ma onposi lirpolo le lingiepe tuwopou piti rautuwo Ma Ili wolo olo. ");
INSERT INTO ong_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mete ma waise moingi fei polpepei wusoli pe pironom pire Eiya re ki. ");
INSERT INTO ong_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Wolo ki kirpeise fei soma wem pe polpepe menmen fei pepei pireise, ise ma onposiepe il wuso kirpeise pepe.” “Wem linutei piti ki keptalo il, ki kirpeise kire menmen fei pepei kolo olo wusoli ki wala kireise ratei.” ");
INSERT INTO ong_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Wolo fei ki ma nou karowo metine wuso laiteiki kau lepe, ki ma nou karowo ke le minele leise re leiteiki lirpolo, ‘Ko ye ma e pinei?’ Olo, nele leise re leiteiki fei lolpepe kolo. ");
INSERT INTO ong_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Le fei ki kirpeise kire menmen fei pepei, enke peise leinginim ma olpe. ");
INSERT INTO ong_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Wolo ki kirpeise punkom, piti kaneise, ki ma ke tanise wusoli wem ki ke kolo olo, singe liti kaneise lepe ma lau kolo olo. Le wuso ki ke soma ki ma kaisi lau ise pepe. ");
INSERT INTO ong_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Le wem le lau, le ma kosape mete piti tef, kosape lire il olpe pe menemple wuso pe olo fupepletei pasiepe. Le le ma kosape lire metine minele le teingi tuwopou, le le ma kosape lire wai pite Ma Ili piti kapi il laptei liripe mete. ");
INSERT INTO ong_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pe fupepletei pasiepe il olpe wusoli pe pulpoiki kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Pe olo fupepletei pasi metine le teingi tuwopou wusoli ki ma karowo Eiya ke le ise ma yuliki kolo. ");
INSERT INTO ong_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Le pe olo fupepletei pire wai pite Ma Ili piti kapi il laptei liripe mete wusoli metine piti luntoluwo tef lepei olo Ma Ili kapi il laptei liri fei.” ");
INSERT INTO ong_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Il wuru wala pato piti ma kirpeise wolo fei ise olo yesiepe wurutei. ");
INSERT INTO ong_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Le wem Riri piti lirpei il punkom pepe, wem le lau, le ma lirkilau leilaise enke piti retape il punkom pite Ma Ili yoporotei. Le ma lirpeise lire il pele lotei kolo olo, wolo le ma lirpeise lire il wuso le lingitowo Ma Ili lirpowo piti ma waise pepe le le ma lirpeise lire menmen piti ma fale wem lingi. ");
INSERT INTO ong_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Le ma leila nange leiki le yuwei wusoli le ma kapi il wuso ki ma kirpowo pepe, le le ma lirpeise. ");
INSERT INTO ong_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Men nange yeflipiye wuso pite Eiya pele pepe olo ki peiki, min polpepei so ki kirpei kirpolo Riri lepe le ma kapi il peiki le le ma lirpeise.” ");
INSERT INTO ong_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Wem kurauye ise ma yuliki kolo olo, leye lo wem kurauye ise ma nou yuliki.” ");
INSERT INTO ong_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Fei pupam ilepe pirpepe pupam nemple pepe pirpeiye, “Il pal fei polomen so le lirpei lirpolo, ‘Wem kurauye ise ma yuliki kolo olo, leye lo wem kurauye ise ma nou yuliki?’ Le le lirpei lolpepei re, lirpolo, ku ma muluwo kolo wusoli le ma karowo Yaitei lele le. ");
INSERT INTO ong_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Le lirpei lire wem kurau lepe, ko le lirpei fei lolomen?” pupam pepe peite nemple. “Le lirpei liri menele so ku wala mironom pepe.” ");
INSERT INTO ong_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas retai fei piti pe ma peletei, le le so lirpepe lolpepei, “Ki kirpei kirpolo wem kurauye ise ma yuliki kolo, leye lo wem kurauye ise ma nou yuliki. Il pepei so ise yeite nemple yiripe pepe lom? ");
INSERT INTO ong_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ko ki kirpeise punkom, ise ma youti re enke olpetei wolo mete piti tef ma enke teingipe. Enke peise ma olpe wolo pe ma nou weitei teingipe. ");
INSERT INTO ong_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wem moto nenpe piti nire yofu, ne ningitei pau pene kotu piti ma nilape eple, ne onom pene ma one wusoli wem olo lau lire malfem piti flis re moingi ma falene. Wolo wem ne nilape tani notei, ne onom pete il nire moingi pene wusoli ne nilape eple fei, le ne onom teingine. ");
INSERT INTO ong_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ise re ma yolpepe, fei ise enke olpe wolo wem ki nou kulise, ise ma nou enke teingipetei le minemple re miso nou weisipe enke peise olpe kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Wem epli wem fei lepe fale, ise ma yeiteiki fei yolomen yolomen re kolo, ma olo. Ki kirpeise punkom, wem ise yiri nange leiki yeletei Eiya yire men nange pepe, le ma waise. ");
INSERT INTO ong_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Wem linu piti ise yulteiki le le lau lau fale fei, ise yiri nange leiki yeletei Eiya yire menmen kolo olo. Ise yeletei Eiya le le ma waise menmen wuso yeletei yiripe pepe, le ise ma enke teingipetei.” ");
INSERT INTO ong_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ki kiripe il kauro yuwei kirpeise kire menmen fei pepei. Wolo epli wem wala lato, ma wem fei lepe fale ki ma kiripe il kauro yuwei kirpeise kolo olo, wolo ki ma kirpei namise koporotei kire Eiya leiki. ");
INSERT INTO ong_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wem epli wem fei lepe fale, ise ma yiri nange leiki yeletei Eiya, le ki kirpei kirpolo ki kapi il peise le ki ma keletei Eiya piti kaneise lom? Olo, ki ma kolpepe kolo. ");
INSERT INTO ong_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ki ma kile nimin piti kapi il peise le ki keletei Eiya kolo olo, wusoli Eiya lotei le onom puwoise. Le onom puwoise wusoli ise onom puwoiki le ise yulpo yirpolo ki kaule Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Eiya laiteiki kau tef lepei le fei ki ma kusa tef lepei le ki ma nou karowo Eiya ke.” ");
INSERT INTO ong_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Leye lo Jisas pupam pele pirpowo polpepei, “Ye fei irpei aptutu, ye irpei kauro yuwei kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ku fei mretai molpepei ye olo retape menmen wurutei le minemple re miso peiteye kolo olo. Min pepei so ku mulpouye mirpolo ye aule Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisas namti lirpepe lolpepei, “Ise fei yulpoiki ye lom? ");
INSERT INTO ong_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wem ma lau, le wem fei lepe olo faleye wem pe ma peituse yire fla, nou yantu karepe uf peise fi fi ye ye. Le ise ma yusaiki ki kuteteiye kile. Wolo ki olo kuteteiye kolo olo wusoli Eiya olo lireiki. ");
INSERT INTO ong_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ki kinu kirpeise il pepei soma enke peise ma malye, le ise kani onom yanteiki. Mete piti tef ma waise flis re moingi wolo ise ma topo weli, yirkilau yile singe. Singe olpe pite tef lepe olo ki kapi weisipeye.” ");
INSERT INTO ong_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas lirpei il pepei re fei, le luntoli le teplai yuwei le le lirpei lolpepei, “Eiya, wem lepe olo faleye. Ye waiki ki ninge leiye nange ili soma ki ma namti kosape mete kire nange ili leiye. ");
INSERT INTO ong_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ye waiki singe piti kuntoluwepe mete yeflipiye piti tef le ye olpepe soma mete yeflipiye wuso ye kesipe apteiki pepe, ki ma watepe nempi liti pratei pingi wemwem. ");
INSERT INTO ong_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Le wuso mete pretaiye, ye Ma Ili niliye punkom, le pe pretaiki ki wuso ye aiteiki kau lepe, pe miso kali nempi liti pratei pingi wemwem. ");
INSERT INTO ong_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ki kosape mete piti tef kire nange ili leiye, le towa wuso ye waiki piti kesio lepe olo ki kesio yaliye. ");
INSERT INTO ong_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Eiya, ye fei lepei ma ire eti peiye waiki nange ili, nange ili elpesi wuso kinu kesio wem ye wala aptei men nange pite tef lepei kolo olo pepe.” ");
INSERT INTO ong_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Mete piti tef wuso ye kesipe apteiki pepe ki kosape fei piti pe ma pretaiye. Pe peiye le ye so waiki. Pe pulpope il peiye, ");
INSERT INTO ong_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","le fei pe pretai polpepei men nange yeflipiye wuso ye waiki pepe, pe paule ye yotei. ");
INSERT INTO ong_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Il wuso ye waiki pepe ki watepe fei le pe kapiye. Pe pretai polpepei ki kaule ye punkom, le pe pulpo pirpolo ye aiteiki kau.” ");
INSERT INTO ong_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ki keiteiye piti ma ailelepe mete eryai piti tef kolo olo, wolo ki keiteiye piti ailelepe wuso ye kesipe apteiki pepe wusoli pe peiye. ");
INSERT INTO ong_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mete yeflipiye wuso ki peiki pepe olo ye peiye le fei ye peiye pepe olo ki peiki, le pe kosape mete piti tef pire nange ili leiki. ");
INSERT INTO ong_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Le fei ki ma kareye ke lepe, ki ma kratei tef koloye wolo pe wala pratei tef lepei. Eiya, nange leiye olo ili le ye singetei, ye kaniepe pratei poporo pire singe peiye, singe wuso ye waiki pepe. Ye kaniepe ire singe peiye soma pe ma pratei puwo nemple mete nempleiye watafei ki kire ye, ku metine niliye lepe. ");
INSERT INTO ong_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Wem ki wala kiripe mepi ratei ki kaniepe kire singe peiye, singe wuso ye waiki pepe. Ki kuntoluwepe koporo le nele lelpe re kotire kolo wolo niliyeye lelpe so lila moingi lingiepe il wuso paitei yousi pepe piti pe ma fale punkom. ");
INSERT INTO ong_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Le fei ki ma kareye ke lepe, le ki kirpei fei pepei wem ki wala kratei tef lepei soma pe ma onom teingine pirkilau watafei ki onom teingine nepe. ");
INSERT INTO ong_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ki keptalo kire il peiye le mete piti tef olo enke kotu pasiepe wusoli pe pite tef lepei kolo olo, min watafei ki kutei re, ki liti tef lepei kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ki keiteiye piti ma kesipe tani tef lepei lom? Olo, wolo ki keiteiye piti kaniepe peinei nautepe singe pite metine oli lite tef lepei. ");
INSERT INTO ong_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Min watafei ki, ki lite tef lepei kolo olo le pe re, pe pite tef lepei kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ye ma kapi aptei ye yotei piripe il punkom, il peiye il punkom pepe. ");
INSERT INTO ong_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ki kaisipe pe pinge tef lepei watafei ye aiteiki kau tef lepei lepe. ");
INSERT INTO ong_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ki onposiepe pe potei pepe so ki min wai kutei ke ye piti ma kesio towa leiye, le ki kolpepe soma pe re ma pire punkom piti wai potei pe ye piti ma pirkilau pesio towa leiye.” ");
INSERT INTO ong_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ki keiteiye piti ailelepe pe poteteiye kolo olo, wolo mete wuso pingitepe il pelpe le pe pulpoiki pepe re, ki keiteiye piti ma ailelepe apwonou. ");
INSERT INTO ong_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Eiya, ki keiteiye piti kaniepe pratei puwo nemple wata pirpolo pe mete nempleiyeye pepe. Pe ma pratei pire singe louku watafei ye ireiki ratei le ki kireye ratei lepe. Pe ma pratei puwo nemple wata pirpolo pe mete nempleiyeye pepe soma mete piti tef ma pulpo pirpolo ye aiteiki kau tef lepei punkom. ");
INSERT INTO ong_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ki watepe nange ili watafei ye waiki lepe le ki kolpepe soma pe ma pratei puwo nemple wata pirpolo pe metine niliye lepe, min watafei ye ireiki ki, ku noutiyeye. ");
INSERT INTO ong_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ki kiripe ratei le ye ireiki ratei le pe ma pratei puwo nempletei soma mete piti tef ma pretai polpepei, ye aiteiki kau tef lepei le ye onom puwope pupam peiki pepei watafei ye onom puwoiki lepe.” ");
INSERT INTO ong_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Eiya, ye yotei kesipe apteiki le tulum piti ki kratei, pe re ma pireiki mepi ratei soma pe ma puluwo nange ili leiki, nange ili wuso ye inu waiki wem ye wala altei tef re men nange kolo olo. Nange ili fei lepe ye waiki wusoli ye onom puwoiki. ");
INSERT INTO ong_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Eiya, ye teingi tuwopoutei. Mete piti tef olo pretaiye kolo, olo pireye onom, wolo ki kretaiye le pupam peiki pepei pe pretai polpepei ye aiteiki kau tef lepei. ");
INSERT INTO ong_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ki kosape kire ye fei, le ki ma kolpepe wem oli oli soma pe ma onom puwo nemple watafei ye onom puwoiki lepe le ki re ma kiripe ratei.” ");
INSERT INTO ong_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Wem Jisas leletei Ma Ili re fei, le liripe pupam pele naro pe panlowi etingi fomnongo kumpu nato tef towile pinawo pirpolo Kidron. Pe ponglo pe liom nele lato plen lite tef towile lepe. ");
INSERT INTO ong_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, le metine oli piti laltei Jisas le eti pite mete olpe, le retai liom fei lepe wusoli wem wuru Jisas liripe pupam pele pe pratei tulum fei lepe. ");
INSERT INTO ong_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas kesipe yali pal ilepe piti puntoluwo winem lite Ma Ili, yali pal wuso mete lipi piti pinuwepe peptawio Ma Ili siye le mete pite Farasi, pe paisipe pe pepe. Judas kesipe yali pal fei pepei le yali pal ilepe piti pesio towa lite moli lipi pite Rom, Judas kesipe pepi pe. Pe pilape werau piti plolpo le pe pesiepe nango weli. ");
INSERT INTO ong_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas olo retai fei piti menmen pepei ma falowo, le so fale le lepletei yali pal pepe lolpepei, “Ko ise piti yintatawo minele?” ");
INSERT INTO ong_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Ko ku mintatawo Jisas lite Nasaret,” pe namti pirpei. Fei Jisas lirpeiye, “Le ki min lepei.” Judas, le metine oli piti laltei Jisas le eti pite mete olpe pepe, le re liripe pile. ");
INSERT INTO ong_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Wem Jisas lirpepe lirpolo, “Ki min lepei.” yali pal pepe nou pire nimpi pe le pe pualo pratei tef. ");
INSERT INTO ong_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Fei, Jisas nou lepletei, “Ko minele so ise yintatawo lepe?” “Ko ku mintawo Jisas lite Nasaret,” pe namti pirpei. ");
INSERT INTO ong_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Le ki kirpeise fei kirpolo ki min lepei,” Jisas lirpepe. “Le wuso ise yintataiki, mete fei pireiki pepei ise ma yusape pe.” ");
INSERT INTO ong_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jisas lirpei il pepei piti ma laptei il pele wuso linu lirpei pepe ma fale punkom. Il wuso lirpei lirpolo, “Eiya, mete wuso ye waiki pepe, ki kusa nele re kotire kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita lila werau lele laitei pau le le so kotuwo lire lalowi mingi lite metine piti lesio towa yawi lite metine ili piti linuwepe peptawio Ma Ili siye. Saimon Pita lalowi mingi lite eti tilpi lepe kereye. Metine piti lesio towa yawi le mingi lele wuso Pita lalowi lepe, nange lele Malkus. ");
INSERT INTO ong_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisas lirpowo Pita lolpepei, “Ye nou alfo werau leiye le laitei tulum lele. Ye onposi irpolo moingi wuso Eiya waiki lepe ki ma kila kolo lom? Olo, ki ma kila.” ");
INSERT INTO ong_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yali pal pire ili lelpe piti luntoluwepe le yali pal pite Juda piti puntoluwo winem lite Ma Ili, pe penglei Jisas, topuwo pari, ");
INSERT INTO ong_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","le pe kesi pila pe falowo Anas linu. Anas, le yaitei piti lilane moto wuso Kaiafas laisene, le Anas yenetei lele Kaiafas lepe, eringi fei pepe le lesio towa linuwepe mete piti peptawio Ma Ili siye. ");
INSERT INTO ong_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafas lotei so lirpepe mete lipi pite Juda lirpolo pe ma pato poporo piti metine niliye ma la lungwipe mete. ");
INSERT INTO ong_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita lire pupam nele, te rounge tulsesi Jisas tingi. Pupam nele lepe, le olo Kaiafas retawo loporotei le le so lire Jisas tepi tinki te uf teingo lite winem lite metine ili piti linuwepe peptawio Ma Ili siye. ");
INSERT INTO ong_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita lile laitei wingi pite towa yawi. Pupam nele wuso Kaiafas retawo loporotei lepe, le nou noro le lirpene moto lainou nenpe piti nile nuntoluwepe wingi pepe, le ne nusa Pita linki le leinginim. ");
INSERT INTO ong_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Fei, moto lainou piti nile nuntoluwepe wingi pepe, ne neletei Pita nolpepei, “Ye re ye pupane lite metine lepe ko?” “Olo, ki olo.” Pita namti lirpene. ");
INSERT INTO ong_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wem fei lepe yuf is fale le mete piti pesio towa yawi le yali pal, pe is pe so pasupu weli lato uf teingo lepe le pe pile neinowo piti papopo topungou pelpe. Pita karepe le liripe pepi pilowo weli lepe. ");
INSERT INTO ong_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Wem fei lepe metine ili piti linuwepe peptawio Ma Ili siye pepe, le leletei Jisas liripe pupam pele le towa lele piti leptalo. ");
INSERT INTO ong_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisas namti lirpowo lolpepei, “Ki wem oli oli kile alepe nimin kirpepe mete yeflipiye, ki keptalo il kifei angli pal le winem lite Ma Ili wuso mete yeflipi pite Juda pau panfinemple pifei lepe. Ki wem nele re kirpei il nemple kotire kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Le piti men ma ye eiteiki? Ye epletei mete wuso pingitepe il peiki pepe. Ye epletei ire il wuso ki kirpepe pepe, pe pretai il menemple ki kirpepe.” ");
INSERT INTO ong_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wem Jisas lirpei il pepei, yalu pau nele wuso lile lepe le lapowo Jisas yifa le le lirpei lolpepei, “Ko ye olomen ma irpowo fei olpepei, le metine ili piti linuwepe peptawio Ma Ili siye.” ");
INSERT INTO ong_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisas namti lirpowo yalu pau lepe lolpepei, “Wuso ki kirpei il nemple peinei, ye irpepe mete yeflipiye pepei, irpepe ire il fei pepe. Le wuso ki kirpei il tuwopou, piti men ye eteteiki?” ");
INSERT INTO ong_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Leye lo Anas laisi Jisas le piti luluwo Kaiafas, le metine ili piti linuwepe peptawio Ma Ili siye. Jisas esi pele wala topwepe papiri. ");
INSERT INTO ong_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita wala lilowo weli, wem mete wuso piri pepei pile pepe, pe peletei polpepei, “Ye pupane nele lite metine lepe ko?” Wolo Pita lire yef lirpolo, “Olo, ki olo.” ");
INSERT INTO ong_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Fei, metine nele piti lesio towa yawi lite metine ili piti linuwepe peptawio Ma Ili siye pepe, metine lepe le lite alpe lite metine wuso Pita lalowi mingi lele kere, le leletei Pita lolpepei, “Ki kuliye iri rounge yile liom ko?” ");
INSERT INTO ong_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Wolo Pita nou lirpei lire yef lirpolo “Ko olo.” Wem fei lepeye woflu koro. ");
INSERT INTO ong_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pe pusa winem lite Kaiafas le pe kesi Jisas pila pe fale winem lite moli ili lite Rom. Wem fei lepe olo nolowi nau piti ma ifili. Mete pite Juda olo pinki pe winem ili lepe kolo wusoli pe onposi piti ma pire potei teingipe le pe soma paplei oweli piti onposio wem wuso Ma Ili kaniepe manre yaire pelpe pau tani Isip. ");
INSERT INTO ong_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Liso Pailat naro le yawi lulwepe le le lepletei lolpepei, “Ko ise yamtuwo metine lepei yire men?” ");
INSERT INTO ong_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Le pe namti pirpei pirpolo, “Wuso le lingiepe il menemple olpe kolo olo, piti men ma ku kesi mila mau malteiye? Ma olo.” ");
INSERT INTO ong_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat lirpepeye, “Ise isotei ma kapi il yaptei yiri yingiepe il lipi peise.” Fei, mete pite Juda pepe namti pirpei pirpolo, “Ise piti Rom il karouku piti ma maltei metine nele la kolo.” ");
INSERT INTO ong_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Il pepei fale punkom pingiepe il wuso Jisas linu lirpei lire tisi men ma le la. ");
INSERT INTO ong_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailat nou linki le winem ili lepe le le linawo Jisas leletei lolpepei, “Ye metine ili lite Juda lom?” ");
INSERT INTO ong_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisas namti lirpowo lolpepei, “Ye yotei onposiepe le ye so eiteiki fei olpepe lo mete nemple pirpeiye pireiki ki.” ");
INSERT INTO ong_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat nou lirpei lolpepei, “Ye onposi irpolo ki lite Juda lom? Mete peiye yotei, pe pire mete lipi pelpe piti pinuwepe peptawio Ma Ili siye, pe so keteiye pilaiye pau faleiki lepe. Ye ingiepe il menemple olpe?” ");
INSERT INTO ong_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisas namti lirpei lolpepei, “Ki metine ili watafei mete lipi piti puntoluwepe mete piti tef lepei kolo olo. Wuso ki fei kolpepe, pupam peiki ma plolpo kareiki lope le mete piti Juda miso pengleiki olo. Wolo olo, ki metine ili watafei mete lipi piti puntoluwepe mete piti tef lepei kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Liso Pailat leletei Jisas lolpepei, “Ko ye metine ili lom?” Jisas namti lirpowoye, “Ye irpei irpolo ki metine ili, ki kau tef lepei le ema nilaiki piti ma kingiepe menmen nempleiye fei pepei, ki ma kirpepe mete kire il punkom. Mete piti pingiepe il punkom, pe pingiepe il peiki.” ");
INSERT INTO ong_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Fei, Pailat leletei Jisas, “Le il punkom pepe pe menemple?” Leye lo Pailat nou noro le yawi lulwepe mete pite Juda le le lirpepe lolpepei, “Ki kerengape il pal nemple piti ma watowo metine lepei moingi kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“Wolo ise mete piti Juda, ise wai leise piti wem ise rautuwo wem ili wuso Ma Ili kesipe manre yaire peise pau tani Isip, ise ma yeiteiki piti kesi metine nele piti lifei winem oli lepe ma kaltei naro le yawi. Ise yirpei piti ki ma kusa metine ili lite Juda lepei le yawi lom?” ");
INSERT INTO ong_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wolo pe namti pailo pirpei polpepei, “Olo, le olo. Ku mirpei ma ye kesi Barabas altei lau yawi.” Barabas, le metine oli piti letesipe mete pa. ");
INSERT INTO ong_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Leye lo Pailat lirpepe yali pal piti ma kesi Jisas pila pe le pe ma pire foiye petesi. ");
INSERT INTO ong_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yali pal pepe pe kapi foiye singu yaruwepe pire wi le pe reptapo pifei falo lite Jisas. Leye lo pe kali ranguwom yalei pario lifei esi yoli le le lualo lultei tounga lele le noro ire asingu tef. ");
INSERT INTO ong_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Le pe pe pau palpowo mati le pe pirpei polpepei, “Ye metine ili lite Juda, ye ma ratei ingi wem wem.” ");
INSERT INTO ong_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Fei, Pailat nou noro le yawi lirpepe mete wurutei wuso pile towa yawi pepe, lirpepe lirpolo, “Ise yingitei, ki ma kesi kila kau yawi lepei le ki ma kosaise kirpolo ki kerengape il pal nemple piti ma watowo moingi kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Leye lo Jisas naro le yawi, foiye singu wuso yaruwepe pire wi pepe, reptawowo pifei falo lele le pe pario ranguwom yalei. Fei, Pailat lirpepeye, “Ise yuluwo, metine min lepei.” ");
INSERT INTO ong_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mete lipi piti pinuwepe peptawio Ma Ili siye le yali pal piti puntoluwo winem lite Ma Ili, wem pe puluwo Jisas, pe pailo pirpei pirpolo, “Tingeli laitei nimpe, tingeli laitei nimpe.” Le Pailat lirpepe lolpepei, “Ise kesi yila ye le ise tingeli laitei nimpe. Ki kerengape il pal nemple piti ma watowo moingi kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mete wurutei pite Juda pepe, pe nou pirpowo Pailat polpepei, “Ku il lipi pouku pirpei pirpolo le ma la wusoli le leite lotei lirpolo le ninge lite Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wem Pailat lingitepe pirpei il pepei, le olo turuwo oli. ");
INSERT INTO ong_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Le nou linki le winem ili lepe le le leletei Jisas lolpepei, “Ye lite linei au?” Wolo Jisas namti lirpowo kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Le Pailat lirpowo Jisas lolpepei, “Ye ma irpeiki kolo lom? Ye retai, ki kapi il piti ki ma kusaiye e yawi lo ki ma kirpepe yali pal piti tingeleiye aitei nimpe.” ");
INSERT INTO ong_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisas namti lirpowo Pailat lolpepei, “Ye kapi il piti untoliki wusoli Ma Ili waiye il fei pepe. Le metine piti leiteiki kau eti peiye lepe, le ma lila moingi ilitei linuye ye.” ");
INSERT INTO ong_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Wem Pailat lingitepe il pepei, le linta tisi piti ma lusa Jisas le yawi. Wolo mete wurutei pepe pe nou pailolo pirpeiye, “Wuso ye usa le yawi, pe ma pato polpepei, ye olo numu lite moli ili lite Rom kolo olo. Metine minele piti leite lotei lirpolo le metine ili piti luntoluwepe mete, le metine oli piti yaruwepe il pite moli ili lite Rom, le te rounge ma tire noute eringi.” ");
INSERT INTO ong_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Wem Pailat lingitepe il pelpe pepei, le kesi Jisas lila naro le yawi le le longlo lifei flenge piti lifei kapi il laptei liripe mete. Tulum fei lepe il Hibru pinawo pirpolo “Gabata”, tulum paptetei era piti pesio tisi teingi. ");
INSERT INTO ong_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Epli olo le lile nimin ye le wem lire malfem piti mete pite Juda ma paplei oweli piti onposio wem wuso Ma Ili kaniepe manre yaire pelpe pau tani Isip. Liso Pailat lirpepe mete pepe lolpepei, “Metine ili leise min lepei.” ");
INSERT INTO ong_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pe nou pailo pirpowo Pailat polpepei, “Etesi la, etesi la, tingeli laitei nimpe.” Pailat lepletei lolpepei, “Ise yirpei piti ki ma tingeli metine ili leise laitei nimpe lom?” Wolo mete lipi piti pinuwepe peptawio Ma Ili siye pepe, pe namti pirpei pirpolo, “Ko ku metine ili niliyeye piti luntoluku pepe, le moli ili lite Rom.” ");
INSERT INTO ong_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Leye lo Pailat kesi Jisas laltepe piti pe ma tingeli laitei nimpe. Fei, yali pal kesi Jisas pila peye. ");
INSERT INTO ong_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisas lotei lila nimpe lele le le naro liripe pe fale tulum pinawo pirpolo Oru Weingampi. Il Hibru pinawo pirpolo Golgota. ");
INSERT INTO ong_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tulum lepe, pe tingeli Jisas laitei nimpe. Pe tingelinge mete noute twinges, nele laitei nimpe nele pite lile eti tilpi lite Jisas le nele laitei nimpe nele piti lile eti enkau. Le Jisas laitei nimpe piti lile nimin. ");
INSERT INTO ong_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat laptei il paitei nimpe yalpe le pe papsi paitei nimpe wuso Jisas laitei lepe. Il pirpei polo, “Jisas lite Nasaret, le metine ili lite Juda.” ");
INSERT INTO ong_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mete wuru pite Juda, pe pungunape il pepei wusoli tulum wuso pe tingeli Jisas laitei lepe olo malfem lire uf ili Jerusalem. Il pinu paptei il Hibru, leye lo pe paptei il Latin le pe paptei il Grik pingi. ");
INSERT INTO ong_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mete lipi pite Juda piti pinuwepe peptawio Ma Ili siye pepe, pe pirpowo Pailat polpepei, “Ye ma aptei il irpei irpolo ‘le metine ili lite Juda’ olo, ye ma aptei olpepe kolo. Wolo ye ma aptei irpei irpolo, ‘metine lepei, le lirpei lirpolo le metine ili lite Juda.’” ");
INSERT INTO ong_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Wolo Pailat namti lirpepeye, “Il menemple ki kaptei fei, pe ma paitei polpepe.” ");
INSERT INTO ong_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wem yali pal tingeli Jisas laitei nimpe re fei, pe kapi olongou pele karipe paptei tulum twinges te twinges piripe yali pal fi fi. Pe kali olol lele piti lalfo lifei leinginim, olol lepe olo nele teingi yefli. ");
INSERT INTO ong_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yali pal pepe pirpei nempleiye, “Ku ma mesio kari pato. Ku mantetei nimpe fouri le muluwo minele ma kali olol fei lepe.” Pepei fale punkom pingiepe il wuso pirpei pirpolo, “Pe karipe olongou peiki wai nemple, le pe pantetei nimpe fouri piti kali olol leiki.” Yali pal pingiepe fei polpepe. ");
INSERT INTO ong_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Piti pile malfem pire nimpe wuso tingeli Jisas laitei lepe, Jisas nimou pele, Jisas nimou winke pene, le Maria, ne moto pite Klopas, le Maria Makdala. ");
INSERT INTO ong_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisas lulweme nimou pele nire pupane lele wuso le onom puwoltei liri lepe, Jisas luweme roum mile le le so lirpene nimou pele lolpepei, “Ema, ninge leiye min lepe.” ");
INSERT INTO ong_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Leyelo Jisas lirpowo pupane lepe lirpeiye, “Ema peiye min nepe.” Wem fei lepe le le le, pupane lepe kesine Jisas nimou pele lilane le lantei pepi pratei winem lele. ");
INSERT INTO ong_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas retai lolpepei, wem fei lepe towa lele piti lau lesio lepe ma yali le piti ma laptei il wuso paitei yousi pepe ma fale punkom, le lirpei lolpepei, “Ki yif punko.” ");
INSERT INTO ong_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Waifile nele lire wain tipe wala pulou, pe palfo fale lire waifile lepe ratei. Pe so kali namalou poltoto wain tipe lepe re fei, pe kali peltei loli ilyau um le pe peila le peltowo nemi. ");
INSERT INTO ong_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisas keisi wain tipe lepe lalei lelangu re fei, le lirpei lolpepei, “Fei towa olo yaliye.” Leye lo le laute oru yo fei, laye. ");
INSERT INTO ong_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Fei, mete pite Juda peletei Pailat piti ma lusape yaruwepe ire pite mete wuso petesipe pepi pa pepe, le pe ma karipe tani nimpe pelpe wuso tingelipe paitei pepe. Pe polpepei wusoli epli wem fei lepe, le wem liti mete pite Juda ma pesiepe oweli poporipe elpesipe pifei piti nolowi pe ma pifei yaupe onposio Ma Ili. Le pe pinau piti pusape mete pepe paitei nimpe wusoli nolowi ma wem ili lelpe piti pifei onposio Ma Ili. ");
INSERT INTO ong_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Liso yali pal pe petesipe yaruwepe ire pite metine linu lepe, petesipe yaruwepe re fei, pe petesipe pite nele lepe. Te rounge wuso yali pal petesinge tire Jisas pepi pa pepe. ");
INSERT INTO ong_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Wolo wem pe weisi Jisas puluwo, le olo la fei le pe so yaruwepe ire pele kolo olo. ");
INSERT INTO ong_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yalu pau nele lire nuwi lele lalwe rapu Jisas lapi plen le frou yo fei, teluwi re tipe fale pualo tef. ");
INSERT INTO ong_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Metine piti lulwepe menmen fei pepei pepe, le lingiepe lirpei piti ise ma yulpope il pele. Il pele wuso lirpei pepe olo punkom le le lirpei lire menmen piti fale punkom. ");
INSERT INTO ong_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Pe yaruwepe ire emingelem pite Jisas kolo olo, le fei pepei fale piti ma paptei il wuso paitei yousi pepe ma fale punkom. Il wuso pirpei pirpolo, “Emingo nele lele re ma loungo kolo olo.” ");
INSERT INTO ong_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Le il nemple wuso paitei yousi pepe re, pe pirpei pirpolo, “Mete ma puluwo liti pe pire nuwi palwe rapu lapi plen.” ");
INSERT INTO ong_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yali pal yaruwepe ire emingelem pite mete twinges petesinge tire Jisas pepei pa pepe, yali pal polpepe re fei, liso Josep lite uf kumpu Arimatia, le le leletei Pailat piti ma kali Jisas le laltei. Josep, le pupane lite Jisas wolo le leingi lotei wusoli le turuwo lasiepe mete lipi pite Juda. Pailat lirpowo Josep lirpolo le miso kali Jisas lila le laltei. Liso Josep le kali Jisas. ");
INSERT INTO ong_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, le wuso linu lire mulpou le luluwo Jisas wem Jisas wala namin ratei lepe. Nikodemus lepei, le lulsi Josep rounge te le le lilape nimpu repinge re youlupeingi yousi piti ma tire wopu talpo topo lite Jisas, le lilape wuru leye. ");
INSERT INTO ong_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mete twinges tepei te kali ranguwom teingi tire weisi Jisas lirepe nimpu repinge re youlupeingi yousi pepe piti ma wopu lalpo topo lele wusoli mete pite Juda, pe pingowo tisi lepei wem pe paptei towa pelpe. ");
INSERT INTO ong_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Liom nele lato malfem lire tulum wuso pe petesi Jisas la lato lepe, le liom fei lepe erau nample nele wala palowi yefli, le lato liom fei lepe. Pe wala palingi towa nele re luwo kolo olo, wala yeflitei. ");
INSERT INTO ong_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Epli wem fei lepe, mete pite Juda poporipe oweli men nange pelpe elpesipe pifei piti ma nolowi pe ma pifei yaupe onposio Ma Ili. Liso Josep lire Nikodemus nenyetei kali Jisas talingi luwo erau nample lepe wusoli le olo lato liom malfem. ");
INSERT INTO ong_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sandei mul ili, wala munkunum pesi, Maria Makdala ne fale erau nample wuso palingi Jisas luwo lepe le ne nuluwo erau filau liti palfo lufro wingi pite erau nample lepe olo weisi taniye. ");
INSERT INTO ong_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ne nou nantu ne falowo Saimon Pita lire pupane nele wuso Jisas onom puwoltei liri lepe, le ne nirpengeye, “Pe kali ili louku tani erau nampleye, le ku mirowo onom piti pe ma pila pe paltei fei linei.” ");
INSERT INTO ong_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Liso Pita lire pupane nele lepe, te rounge teifale te erau nample lepe. ");
INSERT INTO ong_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Te rounge tantu te wolo pupane nele lepe, le lirkilau lantu fale raltei Pita le le linu le fale erau nample. ");
INSERT INTO ong_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pupane lepe, le lungutu luwo laplingi lutepe lulwepe ranguwom yaupe pifei erau nample leinginim wolo le olo linki le kolo. ");
INSERT INTO ong_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita lantu luwol le fale le le linki le erau nample leinginim. Le lulwepe ranguwom yaupe pifei, ");
INSERT INTO ong_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","le ranguwom yalpe wuso pari lifei falo lite Jisas. Ranguwom yalpe lepei le luwo liripe ranguwom nemple pepe kolo olo, wolo le olo yaruwo linge nele le pe paltei luwo ire pele. ");
INSERT INTO ong_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Leye lo pupane nele wuso linu le fale erau nample lepe, le re linki le lulwepe ranguwom yaupe pifei le le lulpo lirpolo fei pepe olo fale punkom. ");
INSERT INTO ong_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Te rounge wala tire wouye tire il piti paitei yousi wuso pirpei pirpolo le la wolo le ma nou leilo. ");
INSERT INTO ong_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Leye lo Pita lire pupane nele lepe rounge nou te uf teye. ");
INSERT INTO ong_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria noutiti nile erau nample towa yawi. Wem ne wala noutiti ne nungutu nuwo naplingi lutepe nuntoli ne erau nample leinginim, ");
INSERT INTO ong_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","le ne nulwenge ririm twinges tifei leinginim. Te rounge tafo olongou fiyu le te tifei tulum wuso paltei Jisas luwo lepe, nele lifei liti oru luwo, le nele lifei liti ire puwo. ");
INSERT INTO ong_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Fei, ririm tepe te tenetei Maria tolpepei, “Ko ye moto nepe, piti men so ye outi?” Le ne namti nirpenge nirpolo, “Pe kali ili leiki pila peye, le ki olo kironom piti pe ma paltei luwo fei linei le.” ");
INSERT INTO ong_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wem ne nirpei il pepei re fei, ne weitei nuluwo Jisas lile wolo ne olo nuluwo matufuwo kolo. ");
INSERT INTO ong_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Ko ye moto nepe, piti men so ye outiti?” Jisas lenetei. “Le ye intawo minele?” Fei, Maria onposi nirpolo le metine piti luntoluwo liom lepe, le ne so nirpowo nolpepei, “Ili leiki, wuso ye kali tani, ye irpeiki ire tulum piti ye ila e altei luwo le ki ma ke kali.” ");
INSERT INTO ong_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisas linane nange pene lirpeiye, “Ko Maria.” Ne weitei karowo ne le ne nire il Hibru nirpei nirpolo, “Rabonai.” Il pal pirpolo metine piti leptalo mete. ");
INSERT INTO ong_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisas il karine lirpeiye, “Ye esiki pato wusoli ki wala nou kunwei ke Eiya kolo olo. Wolo ye ma nou e irpepe winkem peiki irpolo ki ma nou karowo eiya ke yuwei, le Eiya leiki le ise leise, le Ma Ili leiki le le Ma Ili leise.” ");
INSERT INTO ong_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Liso Maria Makdala ne falepe pupam pepe le ne nirpepe wuso ne nuluwo ili lelpe le il pepei wuso le lirpene pepe. ");
INSERT INTO ong_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sandei ningli loltopuye wem pupam pepe, pe panfi nemple pifei winem leinginim, le wingi olo pafo wingi teingelem pire papiri wusoli pe olo turwepe pasiepe mete lipi pite Juda. Jisas fale lirpepeye, “Ise ratei yire onom malye.” ");
INSERT INTO ong_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jisas lirpei il pepei re fei, le kosape pape yipalwongou pite esi re lapi plen pele. Pupam enke teingipetei piti puluwo ili lelpe. ");
INSERT INTO ong_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Leye lo Jisas nou lirpepe lolpepei, “Ise ratei yire onom malye. Min watafei Eiya laiteiki kau tef lepei lepe, le ki re kaiteise ye yinge tef lepei.” ");
INSERT INTO ong_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jisas lirpei il pepei le le lutupa nempi lelesipe le le lirpei lolpepei, “Ise kali Riri Teingi. ");
INSERT INTO ong_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Wuso ise wala onposiepe il olpe pite mete nemple, Ma Ili re ma wala onposiepe il olpe pelpe. Le wuso ise onposiepe il olpe pite mete nemple kolo, Ma Ili re ma nou onposiepe il olpe pelpe kolo.” ");
INSERT INTO ong_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pupane nele piti lire eti plen le plen te twinges tepe, (12) nange lele Tomas (nange nele pinawo Didimus), le olo liripe pupam wuru pepe pepi pifei kolo wem Jisas lau falepe. ");
INSERT INTO ong_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Liso pupam nemple pepe pirpowo Tomas polpepei, “Ko ku muluwo ili.” Wolo Tomas weitepe lope lirpolo, “Wuso ki kulwepe pape yipalwongou pite esi pele kolo olo, le ki kesiepe kingitepe tulum wuso pire singu palwe lepe, le lapi plen pele re ki kesiepe kingitepe kolo olo, ki ma kulpope il peise kolo.” ");
INSERT INTO ong_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Epli wem pire eti plen poungo te twinges kari fei, pupam pepe nou pau panfi nemple pifei winem leinginim, le wingi re olo pafo wingi teingelem. Le wem fei lepe Tomas re liripe pepi pifei. Wingi teingelem olo pafo papiri wingi wolo Jisas lau fale lile leingalope nimin le lirpeiye, “Ise ratei yire onom malye.” ");
INSERT INTO ong_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Leye lo le lirpowo Tomas, “Alfo eti tunongo leiye lepei le ye ulwepe esi peiki, le ye ma esi eti leiye altei linge lapi peiki ingitepe. Ye onom twinges kolo, ye ulpoiki.” ");
INSERT INTO ong_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas namti lirpowo Jisas lolpepei, “Ye ili leiki le ye Ma Ili leiki.” ");
INSERT INTO ong_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisas lirpowoye, “Ye ulpoiki wusoli ye uliki ko? Mete piti puliki kolo pepe, pe olo pulpoiki le pe so enke teingipe.” ");
INSERT INTO ong_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Pupam pite Jisas potei pire lutepe pelpe puluwo piti le laptei menmen lipi wuru fale le pe olo paptei paitei yousi pepei kolo. ");
INSERT INTO ong_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Wolo ki kaptei fei pepeiye paitei piti ise ma yulpo yirpolo Jisas, le Krais, le ninge lite Ma Ili. Le wem ise yulpowo Jisas ise ma kali nempi liti ratei yingi wemwem. ");
INSERT INTO ong_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Wem kari re fei, Jisas nou falepe pupam pele wem pe pireri taimere pifei tuluple Taiberias. Jisas falepe lolpepei, ");
INSERT INTO ong_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (nange nele pinawo Didimus), Nataniel (le lite uf kumpu Kana lato tef lite Galili), eple winge tite Sebedi, le pupam noute twinges, pe ponpete nemple. ");
INSERT INTO ong_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita lirpepe pupam pepe lirpolo, “Le ise, ki ma ke kireri taimere kapi ningu.” “So ku re ma mepi me.” Pe pirpowo Pita. Le pe so ponglo nimpe teingo pe wolo mulpou ulel lepe pe penglei men re kolo. ");
INSERT INTO ong_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ifili kere lirkilau le epli laptu fale, Jisas fale lile tuluple linko plen wolo pupam pepe olo puluwo matufuwo kolo. ");
INSERT INTO ong_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Leye lo Jisas linape lepletei lirpolo, “Ko ise lainiyongou pepe ise yenglei men lo olo?” “Olo.” Pe namti pirpowo. ");
INSERT INTO ong_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Fei, Jisas lirpepeye, “Ise yiri taimere leise lualo nimpe teingo plen liti eti tilpi le ise ma yengleipe ningu nemple.” Le pe so piri taimere lualo tipe wolo pe miso nou peipi lau yuwei kolo wusoli ningu olo wurutei le pe pire taimere moingi. ");
INSERT INTO ong_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Pupane wuso Jisas onom puwoltei liri lepe, le lirpowo Pita lolpepei, “Ko le kuna ili louku.” Wem Saimon Pita lingitepe il wuso pirpei pirpolo, “Le kuna ili louku,” le frou kapi olongou pele lafo, (wusoli le nomplei tani, pau yawi) le le konko lualo tipe. ");
INSERT INTO ong_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pupam nemple pepe, pe pifei nimpe teingo le pe peipepi taimere lire ningu pila pe fale telmane plen. Pe puwo tipe fiyen kolo, olo pe malfem pire telmane lite tuluple mingo plen. ");
INSERT INTO ong_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wem pupam pepe kotu pualo pe telmane mingo, pe puluwo weli nele loli lato le ni nele lire luwom tuwo weli lepe. ");
INSERT INTO ong_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Le Jisas lirpepe lolpepei, “Kapi ningu nemple wuso fei yengleipe pepe yilape yau.” ");
INSERT INTO ong_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon Pita longlo nimpe teingo le le leipi taimere lire ningu lilape le telmane mingo. Taimere lepe fale lire ningu, lipiye yaupe le pe wurutei (153) wolo taimere re olo kere kolo. ");
INSERT INTO ong_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Fei, Jisas lirpepe pupam pepe lolpepei, “Ise yau yaplei.” Pupane nele re leletei Jisas lirpolo le minele, olo wusoli pe pretai le ili lelpe. ");
INSERT INTO ong_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas le kali luom lire ni lepe watepe. ");
INSERT INTO ong_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Wem fei lepei, le wem twinges niliye piti Jisas falepe pupam pele, wem le la fei le Ma Ili nou leila. ");
INSERT INTO ong_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pupam pepe paplei re fei, Jisas lirpowo Saimon Pita lolpepei, “Saimon, ninge lite Jon, ye inuwepe pupam pepei piti ye onom puwoikitei lom?” Le Saimon Pita namti lirpowo Jisas lolpepei, “Iyo, ili leiki. Ye retai piti ki onom puwoye.” Jisas nou lirpowo lolpepei, “Mete peiki wuso watafei sipsip eple peiki pepe ye ma untoluwepe.” ");
INSERT INTO ong_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisas nou lirpowo Saimon, linu lirpowo le le fei nou lirpowo le ma wem twinges, lirpowo lolpepei, “Saimon, ninge lite Jon, ye onom puwoiki lo olo?” Le Saimon Pita namti lirpowoye, “Iyo, ili leiki, ye retai ki onom puwoye.” Fei, Jisas lirpowoye, “Ye untoluwepe sipsip peiki.” ");
INSERT INTO ong_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisas nou lirpowo, wem fei lepei le wem twinges niliye piti Jisas lirpowo Saimon Pita. Jisas lirpowoye, “Saimon, ninge lite Jon, ye onom puwoiki lo olo?” Pita onom one wusoli wem twinges niliye fei Jisas leletei lirpolo, “Ko ye onom puwoiki lo olo.” Liso Saimon Pita lirpowo Jisas lolpepei, “Ili leiki, ye retape men nange yeflipiye. Ye retai piti ki onom puwoye.” Jisas lirpowoye, “Ye untoluwepe sipsip peiki. ");
INSERT INTO ong_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ki kirpeiye punkom, wem ye wala kumpu, ye eltalo morou topo leiye luwo pau le ye aulolo e ire onom peiye. Wolo wem ye ma oli ire metine, ye ma kesipe eti peiye aptei le mete nemple ma topwepe papiri le pe ma keteiye pilaiye pe tulum nele wuso ye inau piti e lepe. Wolo pe ma keteiye pilaiye pe.” ");
INSERT INTO ong_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jisas lirim lirpei lire tisi liti Pita ma la lolomen le le ma leila nange lite Ma Ili.) Leye lo Jisas lirpowo Pita lolpepei, “Ye ulteiki.” ");
INSERT INTO ong_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita weitei luntoli tounga le le luluwo pupane nele lulsi luwo tounga lau. Pupane lepei wuso Jisas onom puwoltei liri lepe, le le wuso lifei lulu Jisas malfem wem pe paplei le le leletei Jisas lire minele soma laltei le eti pite mete olpe pepe. ");
INSERT INTO ong_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Wem Pita luluwo pupane lepe le lirpowo Jisas lolpepei, “Ili leiki, metine lepei ma lolomen?” ");
INSERT INTO ong_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisas namti lirpowo Pita lolpepei, “Wuso ki kirpei piti le wala ma namin ratei lungari wem piti ki ma nou kau, piti men ma ye onom one? Olo, ye ulteiki ki.” ");
INSERT INTO ong_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Min polpepei so pupam pite Jisas pele kete il pirpei nemple piri pupane lepe pirpolo le miso la kolo olo. Wolo Jisas lirpei lolpepe kolo. Le lirpei lirpolo, “Wuso ki kirpei piti le wala ma namin ratei lungari wem piti ki ma nou kau, piti men ma ye onom one?” ");
INSERT INTO ong_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Le pupane lotei piti lirpei liripe menmen fei pepei, le le lotei piti laptei il pepei, le ku mretai molpepei, il menemple le lirpei, le lirpei punkom. ");
INSERT INTO ong_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Menmen wuru Jisas laptei fale. Wuso pe paptei il pirpei piripe menmen yeflipiye fei pepe, ki onposi tef lepei ma fale loparu lire yousi piti paptei il paitei. ");
INSERT INTO ong_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ise mete peiki piti yingowo Ma Ili, yousi peiki fei ki kinu kaptei kirpeise kire il piti wem Jisas leilo lesio towa lele, re leptalo il, ");
INSERT INTO ong_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","le le fale wem piti Ma Ili nou kali lila le yuwei. Wem le wala le yuwei kolo le lire singe piti Riri Teingi il poluwepe mete pele wuso linu kesipe laptei lotei pingowo tisi lele. ");
INSERT INTO ong_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wem le la, le nou leilo ratei tef fei lepei wem wuru (40). Wem wuru le falepe mete piti pingowo. Le falepe kosa le lotei piti pe ma puluwo retawo le metine wape, le le liripe pirpe il piti Ma Ili lotei ma lontoluwepe mete fei pe kani onom pantowo lepe. ");
INSERT INTO ong_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Le wem pe pau peifo nemple pire Jisas paplei oweli wo, le lirpepe il fei pepei, “Ise ma yusa Jerusalem kolo. Yiratei ma Riri Teingi lau lunkise wo, wusoli il fei kinu ki kirpeise pepe, Eiya leiki le lirpei punkom ma waise. ");
INSERT INTO ong_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Wuso Jon kaptetei lire tipe nimou le ise, fei ma, wem ulel kolo, ise ma yungungu yire Riri Teingi.” ");
INSERT INTO ong_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Wem mete pele piti pingowo pau panfi Jisas, pe peletei “Ye, Ma Ili, ye wem piti men soma ye watowo metine liti Israel nange liti le lontoluku re tef pouku, le ma watafei mani louku Devit lom? Fei lo olo wem nele?” ");
INSERT INTO ong_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Leye lo Jisas namti lirpepe “Olo, ise miso retai wem il fei pepe ma fale punkom kolo, ma olo. Wusoli Eiya lotei laltei lalingi lire singe pele. ");
INSERT INTO ong_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wolo ise ma wem piti Riri Teingi lau lunkise, le ise ma kapi singe pele soma ise kaneiki yeptalo il yilele ye yinge Jerusalem le Judia, ye ratei tef liti Samaria le uf walem piti pratei tef ili eryai lepe.” ");
INSERT INTO ong_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Wem le lirpei il pele lapulu pe pile puluwo, Ma Ili kali lila le yuwei, pile puluwo le, le lire kumputei, nopom fale lau keraisi le pe puluwo koloye. ");
INSERT INTO ong_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","11","Fei, le le kotire, pe wala pile pontoli tisi fei le lunwei le lepe, leye lo mete winges tafo olongou fiyu fale frouye tau tiripe pile le te tirpepe, “Ise mete piti Galili piti polomen so ise yile yontoli yunwei ye teplai lepe? Metine fei lepe nange lele Jisas, wuso Yaitei kali lila le yuwei tanise lepe ma nou lau watafei yuluwo lunwei le yuwei lepe. Fei ise ma yile kolo, olo ye uf leise.” ");
INSERT INTO ong_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Leye lo mete pingowo Jisas pusa tumun liti nimpe oliv pile le pe nou pe uf ili Jerusalem, wusoli fien kolo. ");
INSERT INTO ong_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wem pe pe fale Jerusalem pe punwei pe winem yuwei lelpe wuso pratei lepe. Mete nange pelpe men so pepei Pita lire Jon, Jems re Andru, Filip lire Tomas, Bartolomyu re Matyu, Jems ninge liti Alfius re Saimon (metine liti linaulipe mete piti pau uf nemple pontoluwepe mete pele pire uf lele) lire Judas ninge liti James. ");
INSERT INTO ong_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pe pire nimoure wuso kani Jisas pepe pire Maria nimou piti Jisas nire winkem pele, pe panfi nemple wem wem piti pire Ma Ili pirpei. ");
INSERT INTO ong_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Wem nele mete piti pulpope il piti Jisas wurutei (120) pau panfi nemple. Pita leilo lile lirpepe lolpepei. ");
INSERT INTO ong_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Wingem peiki il pinu wuso Riri Teingi lirpei fale nemi liti Devit lirpei le Judas, le linuwepe mete olpe piti penglei Jisas ma fale punkom. ");
INSERT INTO ong_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Metine fei lepei nange lele Judas le metine alpe louku wusoli le metine liti lesio towa ile louku. ");
INSERT INTO ong_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Le mangou wuso Judas kapi piti lesio towa oli lepe, le liripe laise tef fei lepe wuso le luwalo la, fango lele lawo le nilim pele naro wem le lankei. ");
INSERT INTO ong_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Leye lo mete wuru pratei Jerusalem pingitei il fei pepei, le pe pinawo tulum fei lepe pire il pelpe ‘Akeldama.’ Il pal piti nange fei lepei ‘Tulum liti Teluwi.’ ");
INSERT INTO ong_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Wusoli Devit laptei paitei yousi piti Sam lirpei lolpepei ‘Metine fei lepe winem lele ma yawi. Nele ma ratei kolo.’ Le le nou laptei lirpei lolpepei ‘Metine nele miso luwalo lile tulum lele lesio towa lele.’ ");
INSERT INTO ong_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Liso metine nele ma fale watafei ku, lau lirouku mirpepe mete il piti Jisas nou leilo lepe. Le le ma metine liti lirouku wem oli wem Jisas le mepi me, mau wem fei Jon kaltetei lau fale wem Ma Ili kali le yuwei.” ");
INSERT INTO ong_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Leye lo pe pautetei mete winges nange pelnge Josep pinawo pirpolo Barsabas (nange nele pinawo Jastus) lire Matais. ");
INSERT INTO ong_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Fei le pe peletei “Ili louku, ye Apa. Ye retape enke piti mete, le fei ye ma kosauku metine minele piti mete fei tepei wuso ye yotei altei ma luwalo lile tulum liti Judas watafei metine liti lingeiye lesio towa wuso Judas lusa le le tulum wuso Ma Ili lirpei lepe.” ");
INSERT INTO ong_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Leye lo pe paptei nange pelnge paitei era fila kumpu le pe pirime muwalo tef, le nange liti Matias weitei luwo yuwei. Fei metine liti pe paltei lepe, le Matais, le leingalipe mete piti pingowo Jisas (12 Aposel). ");
INSERT INTO ong_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Wem fei lepei fale, pinawo pirpolo Pentikos, wem piti Juda lelpe. Leye lo mete wuru piti pulpowo pau peifo nemple pifei winem niliyeye. ");
INSERT INTO ong_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Frou yo fei, pe pingitowo ipli fale teplai watafei yuf ili singe lini laltei minu lepe. Ipli fei lepei le lau liri winem fei pe pifei lepe loungai. ");
INSERT INTO ong_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Leye lo pe puluwo menele watafei weli kete noni kere longlolope. ");
INSERT INTO ong_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Le Riri Teingi lunkuwepe le pe pirpepei il nemple nemple wusoli Riri Teingi lirpei fale nemi liti metine niliyeye niliyeye. ");
INSERT INTO ong_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Wem fei lepe mete piti pingowo Ma Ili wem wem pe piti uf nele nele pau pratei Jerusalem. ");
INSERT INTO ong_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Le wem pe pingitowo ipli fei lepei mete wuru oli, paule, le pe puronom ye pile wusoli metine niliyeye niliyeye lingitei mete piti pulpowo Jisas pirpepei il pelpe pelpe. ");
INSERT INTO ong_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Le pe il re olo pos pile yaupe, leye lo pe peifale pirpei, wem pe pingitei il pelpe. Mete fei pirpei pepei “Pe piti Galili, le piti polomen so ku mete wuru fei pepei mingitepe pe pirpei il pouku piti mani re eiya. ");
INSERT INTO ong_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ku piti Partia, Midia re Ilam le piti Mesopotemia, Juda re Kapadosia le piti Pontus re Esia. ");
INSERT INTO ong_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Piti Frigia, Pamfilia re Isip le fale yeli liti Libia lato lau lire uf kumpu Sairini malfem, le ilepe pouku piti Rom. ");
INSERT INTO ong_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ku eple palie piti Israel le mete nemple wolo pe weitei pau pirouku mingiepe il piti Moses, le ilepe pouku piti Krit re Arebia wolo ku wuru ye fei mingitepe pirpepei il pouku piti men nange lipi Ma Ili le lesiepe laptei.” ");
INSERT INTO ong_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wusoli pe pire wouye le fupepletei, pe pile peite nemple ye “Pepi piti polomen.” ");
INSERT INTO ong_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Wolo ilepe pe palwe oli pelesipe pirpei polpepei “Mete fei pepei pe paplei tipeluwi.” ");
INSERT INTO ong_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Leye lo Pita leilo lile lire mete pele (11) le lirpei il lipi le mete wuso pile pepe. “Ise mete piti yingowo Ma Ili wem oli le ise mete wuru wuso yiratei Jerusalem yingiteiki le ki ma kirpeise il pal piti il fei pepei. ");
INSERT INTO ong_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","So mete fei pepei pe paplei tipeluwi kolo, wuso ise enke peise yirpolo pe paplei tipeluwi, fei wala mul. ");
INSERT INTO ong_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wusoli pepei wuso ise yulwepe le yingitepe pepe, sungoi metine nimou liti Ma Ili, le lirpepe mete, nange lele Joel lirpei lolpepei ");
INSERT INTO ong_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Ma Ili le lirpei lolpepei, Wem piti ku fei pepi lire malfem ma le tani, ki kaltei Riri Teingi leiki le ma lunkuwepe mete wuru le eple tuleingi re feri peise ma peptalo il peiki pe mete le mete peise mete lainuwongou re mete olpe piri potei ma petei yongou ma pingitei il peiki. ");
INSERT INTO ong_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Le mete nimoure piti pesio towa leiki re wem fei lepe ma kaltei Riri Teingi leiki le lunkuwepe, le pe ma peptalo il. ");
INSERT INTO ong_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Le ki ma kaltei weli lire teluwi re tuwange ili kimpli fale paitei teplai le pratei tef, le epli ma weitei lire mulpou re ane ma weitei lire yalei watafei teluwi. Pepei ma fale pinu soma wem ili liti Metine Ili louku ma fale. ");
INSERT INTO ong_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Leye lo wem le lau fale mete piti pingowo re pesiepe il pele, le ma kaniepe pire le lotei pratei poporo. Il piti Joel so pepeye. ");
INSERT INTO ong_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Fei ise mete piti Israel yingitepe il fei pepei. Metine fei lepei nange lele Jisas liti Nasaret wuso Ma Ili Lotei laltei piti ma laule ise lepe menso lapteise tafe pire singe lipi wuso laptei faleise alepe nimin, le ise yulwepe wusoli Ma Ili laptei fale le lotei. Le ise yire mete piti pesiepe towa peise retape men nange fei pepei wuso oli pe fale tulum le tef piti ise, le ise yulwepe. ");
INSERT INTO ong_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Fei Ma Ili lire onom pele laltei tisi lato lirpei lolpepei, Jisas ma pesio paltei le eti piti mete olpe, le ise ma yalpo, le yusape kali pila pe paltei lultei nimpe. ");
INSERT INTO ong_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wolo Ma Ili nou leila wem le la, le le kapi flis re moingi piti la tanio. Wem le la miso weitei lire towa kolo. ");
INSERT INTO ong_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Wusoli Sungoi Devit lirpei il pele lolpepei, ‘Ki kuluwo Metine Ili leiki linuki wem oli le lireiki malfem, le lontoliki miso ki turiki kolo. ");
INSERT INTO ong_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Wusoli fei ki onom rautuwepe kire il peiki. Le ki kretai ki ma kaye, wolo wem ki ka, ki ketei koporo ye kato kengarie. ");
INSERT INTO ong_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Le wusoli ye yotei Ma Ili miso ile weitei tounga peteiki kolo, Le ye miso esio topo tale leiki lato tulum oli piti pa kolo. Le ye miso usa metine teingi leiye liti lingepe il peiye miso lorworo kolo. ");
INSERT INTO ong_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fei ye yotei kosaiki tisi teingi liti ke kratei wem oli. Le wuso ye yotei ratei ireiki, ki kratei koporotei.’ ");
INSERT INTO ong_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Fei ise mete piti Israel, ki ma kirpeise il kauro yuwei piti mani louku Devit. Wem le la, pe paltei, le oi lele piti paltei lepe wala min liplato le. ");
INSERT INTO ong_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Le Ma Ili lirpei il singe lolpepe le ma laltei metine nele ninge paliene liti Devit ma fale metine ili watafei Devit lotei lepe. Wuso Devit lotei le metine nimou so le retape Ma Ili il punkom pele. ");
INSERT INTO ong_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Fei Devit le lontoli lolpepei Ma Ili miso lolpepe. Leye lo leptalo il piti Metine Ili wuso Ma Ili lotei laltei, Metine Ili fei lepei ma nou leilo wem le la (Mesaia metine ili Ma Ili lotei laltei). Le lirpei lolpepei ‘Le miso pusa lato tulum oli liti pa kolo, le topo tale lele miso lorworo kolo.’ ");
INSERT INTO ong_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Fei ku kutou, mete piti mingowo montoli molpepe, Ma Ili le leila Jisas fei lepei wem le la! ");
INSERT INTO ong_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Le Ma Ili leila laltei lifei eti tilpi lele watowo singe le le kali Riri Teingi liti Yaitei wusoli Yaitei linu lirpei. Le ise men fei yontoli le yingitei pepe wusoli le lotei laptei wauku. ");
INSERT INTO ong_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Wusoli Devit lotei lunwei le yuwei kolo, wolo le lirpeiye, ‘Ma Ili lirpowo Metine Ili leiki, ‘Ye ifei eti tilpi leiki lepei wo, e ma ki kutei kaptei mete eringi peiye pinki ire peiye wo.’ ");
INSERT INTO ong_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Fei ise ma retawo metine fei lepei nange lele Jisas yoporo, wusoli isotei yaltei lultei nimpe. Le Ma Ili lotei laltei le apa louku le metine ili liti lontoluwepe mete.” ");
INSERT INTO ong_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Leye lo wem mete pingitepe il fei pepei, pe il re pirpei kolo. Le pe peletei Pita lire mete ilepe piti pingowo pepe “Ilim pouku, fei ma ku kali men?” ");
INSERT INTO ong_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Leye lo Pita namti lirpepeye “Ise metine niliyeye niliyeye ma yile weitei kani onom yantowo Ma Ili le ise ma yusape olpe piti tef lepei pato le ku ma keiteteise mire nange liti Jisas Krais soma le kapi olpe peise tanise le ise ma kali Riri Teingi Ma Ili ma waise. ");
INSERT INTO ong_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Wusoli Ma Ili lirpei il lipi pumkom pe isotei re eple peise le mete piti pe fiyen wuso pe re Ma Ili louku linape ma kerowo paule.” ");
INSERT INTO ong_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita lire il singe re il wuru pele lirpepe lasi “Ma Ili ma watepe mete olpe pepei moingitei, le wuso ise kani onom watowo le ma waise moingi kolo.” ");
INSERT INTO ong_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wem pe pingitei il fei pepei wuru pe pulpope le pe pungungu. Le wem fei lepe mete wurutei watafei 3,000 wusoli Ma Ili lotei weisipe enke pelpe piti pulpowo le pe pingowo. ");
INSERT INTO ong_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Leye lo pe waipotei pe il piti mete piti pingowo, le piti peila nange lele. Le pe pepi paplei oweli piti apa re peletei Ma Ili ma kaniepe. ");
INSERT INTO ong_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mete piti pingowo pire Riri Teingi liti Ma Ili pesiepe towa lipi. Mete puluwepe le pe pinlelepe pirpei polpepei “Mete fei pepei piti Ma Ili, pe pesio towa lele.” ");
INSERT INTO ong_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","45","Leye lo pe paptei men nange pelpe pe mete nemple paisepe le pe kapi era soma pilape wainemple wuso metine nele olo pe ma watowo. ");
INSERT INTO ong_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wem oli wuso lepe pe polpepe ye pato pau peifo nemple pile towa yawi liti winem liti Ma Ili, le pe paplei oweli piti Apa pifei winem liti metine niliye niliye le pe paplei pire onom malye le onom nenpeiye. ");
INSERT INTO ong_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Lepe pe peila nange liti Ma Ili, le mete wuru pulwepe pe polpepe, pe enke teingipe pire mete piti pulpowo Apa lire Ma Ili. Le wem niliye niliye Jisas weisipe mete enke, le pe weitei pulpowo laptei lasi mete wuso linu kaniepe pepe. ");
INSERT INTO ong_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wem nele, wem epli weitei piti ma lautile Pita lire Jon te winem liti Ma Ili wusoli wem fei lepei wem piti pe ma pifei peletei. ");
INSERT INTO ong_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Winem fei lepe wingi lipi pinape pirpolo wingi teingipetei pato le metine nele ire olpe wem nimou ne nila ma kali pila pe paltei ratei wingi lipi fei pepei, soma le linape mete piti pinki pe ma watowo era. Wem oli lepe polpepeye pato. ");
INSERT INTO ong_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wem le luluwenge Pita lire Jon rounge tinki te le linange piti te ma watowo men nemple. ");
INSERT INTO ong_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","5","Te rounge weitei lopoluwo tirkilautei. Le Pita lirpowoye “Ye uluku.” Fei le weitei luluwenge lirpolo ma kapi men nemple ma te rounge watowo. ");
INSERT INTO ong_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Wolo Pita lirpowoye “Ki era olotei. Le ki miso waiye oweli nemple. Ki kire singe piti Jisas Krais liti Nasaret, ki kirpeiye eilo ilele e.” ");
INSERT INTO ong_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Leye lo le lesio eti tilpi lele le le kanowo piti ma leilo. Le wem fei lepeye ire elenge piti metine lepe fale kimplipe le le leifale lifei kongongo le le lilele le, leye lo liringe pepi pinki winem liti Ma Ili lepe, le le lifei konkongo leila nange liti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Fei le mete wuru wuso pinki pe pile winem liti Ma Ili lepe pe puluwo wuso le leilo lilele le, le le leila nange liti Ma Ili. Leye lo pe puluwo pario le pe pirpei polpepei, “Lepei le ire olpe le so ratetei wingi lipi teingitei linanai era re men nange piti ma watowo lepe.” Wolo fei pe il re olo pirpei kolo, pos pile yaupeye pasio. ");
INSERT INTO ong_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Leye lo mete wuru pontoli wuso metine ire olpe lesienge Pita lire Jon, pe il re olo le pe pantu karape pe winem tuluwom yawi pinawo pirpolo Solomon winem tuluwom lile winem liti Ma Ili malfem. ");
INSERT INTO ong_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Wem Pita le luluwepe mete nimoure le le lirpepeye “Ise mete peiki piti Israel, piti polomen ise il re yirpei kolo? Le piti polomen so ise lopoluku pepe? Le ise yirpolo ‘Pepei ku teingipeye yuape liso Ma Ili wauku singe men so ku weila metine fei lepei lom?’ Le ise yirpolo, ‘Ku weila metine fei lepei wire singe pouku lom?’ ");
INSERT INTO ong_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Fei ise ma retai Ma Ili wuso Abraham lire Isak re Jekop pingowo le le Ma Ili liti manre pouku. Le so laisi Jisas lau piti ku ma muluwo le ku onposio. Ise yenglei kesi yila ye watepe esi piti mete piti pontolise le ise yinauli wem Pailat, metine ili re lile le wem le lirpei piti ma watowo moingi kolo. ");
INSERT INTO ong_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Le metine liti Ma Ili le le teingiye yawi. Wolo ise yinauli le ise yirpowo Pailat ma kani onom lantowo metine oli liti letesipe lapuwe ma watowo moingi pato lusa le. ");
INSERT INTO ong_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Leye lo isotei so yalpo metine liti linuwepe kaniepe mete piti pratei wem oli. Wolo Ma Ili nou leila wem le la, le ku kutou muluwo. ");
INSERT INTO ong_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Le fei singe liti nange Jisas lele minso watowo metine ire olpe lepei singe. Le ise retape pepei fale wusoli ku wulpowo Jisas le le lotei kapi moingi tanio metine fei lepei menso isotei yuluwo lepei. ");
INSERT INTO ong_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Le fei mete peiki, ki retai polpepei ise yire mete lipi piti pinuse yolpepeye Jisas, wusoli ise yironomye. ");
INSERT INTO ong_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ma Ili lotei laptei il fale nemi piti mete amare pele so pe pirpei polpepei ‘Metine lotei laltei ma lila moingi. Le il fei pepei fale punkom polpepeiye.’ ");
INSERT INTO ong_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Fei le lolpepei soma laisepe wai olpe peise le ise ma yile weitei le yusape il olpe peise pato le ise ma kani onom yantowo Ma Ili. ");
INSERT INTO ong_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Soma wem piti ise ma onom malye, le wem teingi ma laule Ma Ili lotei, le fei lolpepe so le laisi Jisas le so metine le lotei laltei laule ise pepe. ");
INSERT INTO ong_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wolo le ma ratei yuwei longari wem piti men men ma fale poporo wo. Wusoli Ma Ili lirpepe mete emare pele wuso enke pelpe felkele piti peptalo il pirpei sungoi liye. ");
INSERT INTO ong_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sungoi Moses lirpei lolpepei ‘Ma Ili, leise miso laltei metine nimou lau watafei le laiteiki kau lepe. Le metine fei lepe le ma nele piti ise le ise ma yingiepe il pele wem le lirpeise. ");
INSERT INTO ong_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Le wuso metine nele le lingitei il piti metine nimou lepei kolo, metine le lusa il ma la, le le metine liti Ma Ili kolo.’ ");
INSERT INTO ong_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Le mete emarengi pele, Samuel liripe piti pingi pau pesiepe il pele le pe pirpei nomnaipe piti wem fei pepei. ");
INSERT INTO ong_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Fei le il punkom piti Ma Ili wuso lirpei fale nemi piti mete emarengi pele, pe piti ise le ise ma yirpei onposiepe il wuso Ma Ili lapuwe il lire manre peise pepe le le lirpowo Abraham lolpepei ‘wusoli eple palie peiye pepe ki so ma kailelepe mete piti tef fei lepei.’ ");
INSERT INTO ong_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Leye lo Ma Ili le lotei laltei metine liti lesio towa lele linu lau fale ise mete piti Israel piti laileleise, le lingli le mete nemple, le le ma keteise leiteise ye tisi teingi, le ise ma yusape olpe peise pato. ");
INSERT INTO ong_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Wem fei lepe, wem Pita lire Jon wala tirpepe mete, mete piti peptawio Ma Ili siye, pire yalu pau liti lontoluwo winem liti Ma Ili pire Sadyusi pe pepi pau. Pe pau falenge. (Mete piti Sadyusi linaulipe il piti mete nou peilo wem pe pa.) ");
INSERT INTO ong_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","3","Pau falenge fei, pe enke olpe pasienge wusoli te rounge teptalo mete tire il piti Jisas wem le nou leilo le pe ma retai polpepei, pa ma nou peilo. Le pe pengeleinge pautingi tifei winem oli ma nolowi wo, wusoli ningli ma mulpouye. ");
INSERT INTO ong_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Wolo mete wuru fei pingitepe il pepe pe pulpope le mete fei pepe wurutei pe fale watafei 5,000. ");
INSERT INTO ong_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nolowi pire mul mete lipi piti peptawio Ma Ili siye pire mete piti pinuwepe re mete piti peptalo il lipi pau peifo nemple pifei Jerusalem. ");
INSERT INTO ong_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Le mete fei pepei pau pire metine ili liti leltawio Ma Ili siye nange lele Anas. Le lau lire Kaiafas re Jon lire Aleksander le ilepe pe alpe piti metine ili lepei. ");
INSERT INTO ong_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Leye lo pe pautetei mete titi tingowo Jisas tile. Leye lo pe pouteteiye “Ise rounge yeila metine ire olpe lepei yolomen? Le singe peise rounge fei polomen so ise rounge yingepe pepe? Le nange liti mi so ise rounge yiri lepe?” ");
INSERT INTO ong_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Riri Teingi lau lunkuwo Pita lirkilau, leye lo le namti lirpepeye “Fei ise mete amare lipi yire mete piti yinuwepe mete, ");
INSERT INTO ong_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","wuso ise fei yeitouku yire towa teingi fei falowo metine ire olpe, le piti polomen le fale teingi. Le fei ise yire mete piti Israel ma yiretai yolpepei, metine fei lile lepei, singe piti Jisas Krais liti Nasaret wuso isotei yaltei laitei nimpe, wolo Ma Ili nou leila tani tulum liti pa lepe. So le weisi metine lepei fale teingi. ");
INSERT INTO ong_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Wuso il paitei yousi piti Ma Ili pirpeiye, ‘Nimpe liti yaltei winem tupe lifei, wolo ise yinauli lepe, fei le fale nimpe teingitei liti lila winem.’ Le fei Ise yinauli Jisas watafei nimpe lepei wolo Ma Ili laltei le Metine Ili louku. ");
INSERT INTO ong_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wusoli le loteteiye miso kanouku mratei mingi wem wem, le nange fei lepei so Ma Ili laltei watepe mete pepe. Wusoli metine nele liti tef lepe ma watafei le, soma le kanouku wolo olotei.” ");
INSERT INTO ong_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wem pe puluwenge Pita lire Jon tirkilau tirpei le pe puluwenge retange polpepei, te mete titi uf, leye lo pe retai te rounge tire Jisas pepi pesio towa le pe il re pirpei koloye. ");
INSERT INTO ong_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wolo pe ma pirpei il men, wusoli pe puluwo metine wuso fale teingi lepe lire Pita re Jon pepi pile. ");
INSERT INTO ong_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Leye lo pe pirpepe Pita lire Jon re metine fei lepe naro pe tani winem leinginim fei mete lipi pifei pepe, leye lo pe poteteiye pifei pirpei nemple. ");
INSERT INTO ong_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Fei ku ma kali men mire mete fei pepei?” pe pifei peite nemple ye. “Wusoli mete wuru pratei uf ili Jerusalem pretai towa ili fei lotei fale lepei te kanio metine ire olpe. Ku mire metine fei kanio fale teingi lepe, le ku ma maplingi molomen? ");
INSERT INTO ong_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Wuso ku mirpolo towa lepei ma loungo rufro kolo le mete wuru pretawo kolo, ku ma mirpenge mete fei tepei ma nou tirpepe mete tire il piti Jisas kolo, oloye. Ma tusa towa fei lepe latoye.” ");
INSERT INTO ong_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Leye lo pe nou pinange tinki te, le pe pirpenge il singe polpepei, te ma nou tirpepe lo teptalo il tire nange liti Jisas pato. ");
INSERT INTO ong_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wolo Pita lire Jon namti tirpepeye, “Kuna isotei yirpei yingitei isotei. Le ise yirpolo ku ma wingiteise lo, ku ma wingitowo Ma Ili? ");
INSERT INTO ong_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wusoli ku ma wusa towa fei ku kutou lutepe le ku wingitepe ma pato kolo.” ");
INSERT INTO ong_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Leye lo mete lipi pirpenge il singe piti ma te rounge tolpepe pato, leye lo pe pusange te. Le pe miso perengape il pal piti ma watenge moingi kolo wusoli mete wuru pe peila nange liti Ma Ili pire towa teingi fei fale lepe. ");
INSERT INTO ong_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Le metine wuso le fale teingi lepe, le ratei le taurungu pele wurutei punwei fale watafei 40. ");
INSERT INTO ong_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Wem fei lepeye, wem pe paisinge rounge te Pita lire Jon nou karepe mete pelnge piti pulpowo te, le te tirpepe il wuso mete lipi piti peptawio Ma Ili siye pire mete piti pinuwepe pirpei pepe. ");
INSERT INTO ong_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","25","Leye lo wem pe pingitepe pe mete wuruye fei pepe peletei Ma Ili piti kaniepe le pe pirpei polpepei “Ye Yaitei liti altei teplai lire tef re periai fale pire men nange pasiepe, le ye asi Riri Teingi lau lirpei fale nemi liti metine liti lesio towa leiye mani louku Devit, le lirpei lolpepei, ‘Piti polomen mete piti pingowo Ma Ili kolo enke olpe? Piti polomen so pe pirpei pinta tisi piti pe ma pire Ma Ili posinemple? Wolo pe miso polpepe kolo. ");
INSERT INTO ong_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Leye lo mete lipi piti pontoluwepe uf wuru pau peifo nemple, wainemple menpe, soma pire Ma Ili re metine lotei laltei pepi posi nemple.’ ");
INSERT INTO ong_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Fei il piti mani louku Devit fale punkomye, wusoli Herot lire Pontius Pailat rounge tau tire mete piti Israel re mete nemple peifo nemple pifei uf ili pirpei il pingio Jisas piti ma palpo, le metine teingi liti lesio towa leiye. Le ye yotei altei watafei metine ili. ");
INSERT INTO ong_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Wolo mete lipi pau peifo nemple pingi tisi wuso ye yotei altei lire singe peiye, pe palpo la. ");
INSERT INTO ong_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wolo fei, Ma Ili, ye yotei ma ingitouku le ku mirpeiye piti pe polomen polomen pirouku le ye altei singe leiye lau ku mete peiye piti mesio towa leiye, soma il pal pile yaupe wem ku meptalo. ");
INSERT INTO ong_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Fei ye yotei ma kaniepe mete kaninu re moingi falepe eilape pe fale teingi. Ye kaniepe nomnaipe soma mete puluwepe singe peiye. Le ye ma aptei singe lipi fale ire nange teingi liti metine liti lesio towa leiye nange lele Jisas.” ");
INSERT INTO ong_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Wem pe peletei Ma Ili ma kaniepe fei le, pe puluwo tulum fei pifei lepe watafei maiene lini. Leye lo Riri Teingi lau lunkuwepe, le pe peifale pirkilau pile peptalo il piti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Fei le mete piti pulpowo, enke pelpe fale nenpeiyeye le metine nele miso leifale lirpolo men nange pele kolo, pe kapi wainemple. ");
INSERT INTO ong_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Le mete piti pingowo Jisas pire singe lipi pe pile peptalo il piti Jisas le nou leilo lepe. Le Ma Ili le lailelepetei, le mete re paptepe mingim. ");
INSERT INTO ong_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Le mete wuso winangou wuru pire tef pe paptei pe le mete paisepe, leye lo pe kapi mole pilape pau weisipe paptei pe watepe mete piti pingowo. Leye le, mole fei pepe pe kapi watepe mete piti pe mole yini olo. Pe fei polpepei metine miso men nange olo kolo. ");
INSERT INTO ong_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Fei Josep ninge paliene liti Livai, pila ratei Saiprus, le mete piti pingowo pinawo polpepei Barnabas (il pal piti nange fei lepei, metine liti lalpope weli). Le laltei tef lele le mete paise le le kapi mole lilape lau weisipe watepe mete piti pingowo, watepe yalipe. ");
INSERT INTO ong_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wolo metine nele nange lele Ananias lire moto pele nange pene Safaira me roum maltei tef ile lelme le mete paise. ");
INSERT INTO ong_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wem me kapi mole munge watepe mete piti pingowo Jisas ilepe, le le lirpeiye “Era so pepeye.” Wolo ilepe wuso oli moto re retai, me roum mesiepe piti pelme motei. ");
INSERT INTO ong_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Leye lo Pita lirpowo ye, “Ananias piti polomen so ye usa towa lau lunkiye? Le leilaye onom, liso ye irpolo ma empesi Riri Teingi ire mole ilepe piti tef wuso kapi pepe? ");
INSERT INTO ong_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Wem ye wala altei le piti paise kolo, tef leiye, le wem ye altei pe paise mole re peiye. Piti polomen ye so onposi le onom peiye weitei piti ye ma olpepei? Ye fei olpepei lepe, ye empetouku ku kutou kolo, wolo olo ye empesi Ma Ili-ye.” ");
INSERT INTO ong_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Wem Ananias lingitepe il fei pepei, le luwalo laye, men re lalei kolo, loteiye la yawi. Le wem il pe mete wuru pingitepe pe turwepe olpe. ");
INSERT INTO ong_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Fei mete lainuwongou pinki pau pire olongou weisi, leye lo pe kali pila pe palingi erau nample. ");
INSERT INTO ong_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Wem pe kali pila pe paltei pato, leye lo moto pele ninki nau. Wem ne nau ne retai piti pe kali munge pila pe paltei kolo. ");
INSERT INTO ong_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Leye lo Pita lirpene ye “Fei ye irpeiki mole pepei, pepe so ye ire munge roum kapi piti tef leise roum lepe lom?” Ne namti nirpowoye “Iyo mole yeflipe so pepe.” ");
INSERT INTO ong_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Fei, Pita namti lirpene “Piti polomen so ye ire munge leiye roum yempesi Ma Ili Riri Teingi lele yingitowo? Fei, mete piti pe paltei munge pato so pau pile winki ye, le pe ma keyeye re pilaye pe teraiye.” ");
INSERT INTO ong_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wem fei lepe ye, ne kere nualo na nato ire piti Pita. Le mete lainuwongou pinki pau pulwene wolo naye, leye lo pe kani pilane naro pe pantei nato nasi munge lene. ");
INSERT INTO ong_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Fei le mete piti pulpowo pire mete wuru pepe pingitepe il fei pepei le pe turwepe olpe. ");
INSERT INTO ong_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Le mete piti pingowo paptei towa men nange potei pire tute falepe mete le mete piti pulpowo pe pau winem liti Ma Ili, pe pau peifonemple pifei winem tuluwom. Le winem tuluwom fei lepe pinawo pirpolo Solomon winem tuluwom wuso pe pesio lautu yawi lepe. ");
INSERT INTO ong_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Le mete piti pulpowo kolo, pau piripe pepi pifei kolo. Wolo mete piti Israel onposiepe mete piti pulpowo pe teingipe ye yaupe. ");
INSERT INTO ong_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wolo wem oli wuso lepe Ma Ili lotei weisipe enke piti mete nimoure wuru le pe weitei pau pingepe le mete wurutei olpe pulpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Leye lo mete yaupe wuso puluwepe mete piti pingowo pesio towa fei polpepei, pe kapi mete piti kainu paptei puwo poi olpe pelpe le pe pilape pilele pinge tisi soma wem Pita lilele ma lesiepe fale teingipe wuso olo soni lele ma luwalo luwope ilepe pe ma pironom kainu pelpe. ");
INSERT INTO ong_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pe fei polpepei mete wuru oli piti uf kumpu pratei neinowo uf ili Jerusalem paule pilape kainu le mete piti ririm olpe punkuwepe, pe paule le pe yeflipeye fei nou fale teingipe. ");
INSERT INTO ong_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Leye lo metine ili liti leltawio Ma Ili siye lire mete pele, pe mete piti Sadyusi, le pe enke olpe pasi mete piti pingowo Jisas. Leye lo pe pirpe nemple ma watepe moingi. ");
INSERT INTO ong_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Fei pe pengleipe mete piti pingowo pilape pe paptei pifei winem oli piti wem pe pengleipe mete ma pe paptei pratei winem oli fei lepe. ");
INSERT INTO ong_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wolo mulpou fei lepeye, riri liti Ma Ili kamunu winki lipi piti winem oli, le le kesipe mete piti pingowo lilape le yawi le le lirpepe lolpepe, ");
INSERT INTO ong_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ise ye yile winem liti Ma Ili le ise yirpepe mete yire towa teingi piti pratei poporo lepei.” ");
INSERT INTO ong_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Leye lo mete piti pingowo paptowo mingim. Le wem if ili kerere, pe pinki pe winem liti Ma Ili pile peptalo il. Fei le wem metine ili liti leltawio Ma Ili siye lire mete pele, pinape Israel mete piti pinuwepe, paptei nemple ma pirpei. Leye lo pe paisipe yali pal pe winem oli ma kesipe mete piti pingowo pilape karepe pau. ");
INSERT INTO ong_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wolo wem yali pal pe fale pontoli mete piti pingowo, olo pratei kolo. Pe nou pau pirpepe mete lipi polpepei, ");
INSERT INTO ong_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Wem ku me fale winem oli ku mulwepe yali pal piti pile pontoluwepe pepe re pile le winki re pe pamsi menpe. Wolo wem ku mirape winki ku mulwepe pratei kolo.” ");
INSERT INTO ong_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Leye lo wem yalu pau liti lontoluwepe mete piti pontoluwo winem liti Ma Ili le metine ili liti leltalio Ma Ili siye pingitepe il fei pepei, pe il re kapi nampliepe, pe pirpeiye, “Mete fei pepei ma polomen?” ");
INSERT INTO ong_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Fei metine nele linki lau lirpepe mete lipi wuso pifei pepe “Ise yingiteiki wo, mete piti pingowo wuso ise yaptei pifei winem oli lepe, wala fei lepei pe pila winem liti Ma Ili peptalo il.” ");
INSERT INTO ong_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Leye lo yalu pau liti lontoluwepe yali pal piti pontoluwo winem liti Ma Ili lire mete pele pe pirpepe, le pe kesipe pilape pau. Wem pe pe pirpepe, le pe kesipe pilape pau lepe, pe pire il malye pirpepe, pe petisipe le pe topwepe papri kolo, wusoli pe turwepe ma mete piti Israel posiepe era, wusoli pe onposiepe mete piti pulpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wem pe pilape pau fale tulum fei mete lipi pifei lepe, leye lo yalu pau ili lire yali pal pele piti pontoluwo winem liti Ma Ili kesipe pilape pinki pe paptei pile kapi enke paptepe mete lipi. Leye lo metine ili liti leltawio Ma Ili siye lepletei, ");
INSERT INTO ong_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ku mire il singe mirpeise molpepei, ‘Ise ma yeptalo il yire nange liti metine fei lepe pato’.” Le lirpepe, “Wolo fei ise yeptalo il pe mete wuru piti Jerusalem pe kapi oloye, le ise yirpepe yirpolo, ‘Ku so malpo metine fei lepe so la lepe’.” ");
INSERT INTO ong_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Leye lo mete piti pingowo pire Pita namti pirpepeye “Wem mete pirpouku piti ku ma mingowo Ma Ili kolo, ku ma mingitepe il pelpe kolo, ku ma mingowo tisi liti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ise yalpo, le ise kali yaltei laitei nimpe la. Wolo Ma Ili liti manre yaire pouku, le nou leila Jisas wem le la. ");
INSERT INTO ong_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Le Ma Ili kesi lila le laltei le eti tilpi lele watafei metine ili. Le metine liti kaniepe mete piti Israel soma pe ma pusape wai olpe pelpe pato le il olpe pelpe ma le kapi taniepe. ");
INSERT INTO ong_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Le ku so meptalo il piti men nange wuso fale pepe le Riri Teingi piti Ma Ili wauku lepe re lirpepe mete piti paptowo Ma Ili mingim.” ");
INSERT INTO ong_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wem mete lipi pingitepe il fei pepei, pe enke kotuwepe pasiepe mete piti pingowo le pe pirpei ma papo pa. ");
INSERT INTO ong_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wolo metine nele lelpe, nange lele Gamaliel, le metine liti lingepe il piti Moses lirkilautei le mete re pe peila nange lele, le leilo lile lirpepe yali pal piti pe ma kesipe pilape pe towa yawi. ");
INSERT INTO ong_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Leye lo le lirpepe mete lipi lolpepei, “Ise mete piti Israel, ise ma onposi yoporo so ise kali men yire mete piti pingowo pepe. ");
INSERT INTO ong_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Le ise ma retai wem taurungu wuru pe kolo metine nange lele Teudas fale lau lirpei lirpolo ‘Le metine ili’, le mete wuru fale watafei (400) mete wurutei peifale pingowo wolo pe palpo la, le mete pele piti pingowo kere pinkingi pire siye naflepe le towa lele lelesa oloye. ");
INSERT INTO ong_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Wem metine lire towa lele lepei le tani, le wem pe koponape mete nimoure, metine nange lele Judas liti Galili lau fale, le le re so lolpepeye, wolo le re palpo la le mete piti polsi kere pinkingiye. ");
INSERT INTO ong_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Le fei ki kirpeise ise ma kali men yire mete fei pingowo pepe pato. Keteti yusape. Wuso pe mete piti tef paltei towa lepei fale pire enke pelpe, towa lelpe miso lelesa. ");
INSERT INTO ong_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wuso Ma Ili lotei laltei lau, ise miso weisipe puwalo alu kolo, wusoli ise ma weitei fale mete eringi Ma Ili pele.” ");
INSERT INTO ong_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Leye lo pe pingepe il piti Gamaliel, le pe pinape mete piti pingowo pinki paule, le yali pal kali nungo teingo pire petesipe. Le pe pirpepe il singe polpepei, “Fei ise ma nou yirpepe mete yire nange liti Jisas kolo, olo.” Leye lo pe kesipe paptei pe. ");
INSERT INTO ong_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wem mete piti pingowo Jisas pusape mete lipi pifei, le pe enke teingipe rautunemple peye. Wusoli Ma Ili onposiepe pe pile singe, pe miso pila moingi fei lepei pungwi Jisas. ");
INSERT INTO ong_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Le wem oli wuso lepe pe pusape il pato kolo, pe pe winem liti Ma Ili, re winangou wuru pifei peptalo le pirpepe il teingipe piti Jisas, metine Ma Ili lotei laltei. ");
INSERT INTO ong_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Fei wala wem ulel kolo, le mete piti pingowo Jisas fale wurutei. Le mete pe eple palie liti Israel wolo pe pirpei il Grik pire mete nemple pe eple palie piti Israel pirpei il Hibru, pepi pilainemple le mete piti pirpei il Grik pirpei polpepei towa nimoure pelpe wem pe kapi oweli piti wem oli paptei wainemple pe onposiepe kolo olo, pe pifei yaupe paplei kolo. ");
INSERT INTO ong_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mete piti pinu pingowo Jisas pinape mete piti pulpowo wuruye fei paule peifonemple le pe pirpeiye, “Ku ma musa towa louku liti meptalo il kolo. Olo ma wanketei. Mete nemple ma pailelepe watepe oweli piti papli. ");
INSERT INTO ong_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Le fei, winkem, yingitei ise ma yaptei mete pire eti plen te winges (7) piti ise, le mete fei pepei ise ma yulwepe teingipe le enke pelpe ma pire wuru le Riri Teingi re ma lunkuwepe. Mete fei polpepei soma ku maptei pesio towa fei lepei. ");
INSERT INTO ong_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Le ku kutou wem oli ma mifei meletei Ma Ili le mesio towa liti meptalo il pele.” ");
INSERT INTO ong_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Fei le mete wuru wuso pile lepe enke teingipe pire il piti mete piti pingowo. Leye lo pe paltei Stiven, metine fei lepei le lulpope il lirkilautei lire Riri Teingi, Filip Prokorus re Nikanor lire Timon re Parmenas re Nikolas le metine liti Antiok wolo le weitei fale lingiepe il piti Moses. ");
INSERT INTO ong_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Leye lo mete piti pulpowo, kesipe pilape paptei pe eti piti mete piti pingowo. Pe peptalo esi puwope kosape mete pe mete piti pesio towa fei lepei, le pe peletei Ma Ili ma kaniepe. ");
INSERT INTO ong_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Le pe fei polpepei, il piti Ma Ili, poungo rufro, le mete piti pulpowo pratei Jerusalem fale pire wurutei. Le mete piti peptawio Ma Ili siye pe wurutei pelpe pingowo Jisas. ");
INSERT INTO ong_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Le metine lepei nange lele Stiven, Ma Ili lontoluwo lailolowo le le watowo singe piti laptei towa men nange potei falepe mete. ");
INSERT INTO ong_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wolo mete ilepe pe pinauli, le mete fei pepei pe pinu pratei fien pesio towa yawi piti mete nemple kapi mole kolo, wolo fei pe pusape taniepe, le pe pratei poporo. Fei pe piti angli pau lelpe le pe mete piti Israel pilape uf Sairinia re Aleksandria paule. Pe pire Israel ilepe piti pratei pinkene Silisia re Esia pepi pire Stiven pura nemple. ");
INSERT INTO ong_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Wolo Riri Teingi watowo Stiven onom nire wuru piti wem le lirpei pe miso weisi kolo. ");
INSERT INTO ong_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Leye lo pe peplesipe mete nemple il pirpei polpepei “Ku mingitowo lirpei kelalange Moses lire Ma Ili il. ");
INSERT INTO ong_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Fei pe polpepei mete piti kapi il paluwe Stiven pire mete piti pinuwepe re mete piti peptalo il lipi pintawo pau pesio pari le pe kesi pila pe falepe mete lipi. ");
INSERT INTO ong_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pe kesipe mete ilepe piti pempesi pirpei pamtuwo pirpei polpepei “Metine fei lepei, le wem oli wuso lepe, le kelalape il lipi piti Moses re winem fei maltei watowo Ma Ili lepe. ");
INSERT INTO ong_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ku mingitowo lirpepei lolpepei ‘Metine fei lepei nange lele Jisas liti Nasaret, ma laltu winem liti Ma Ili, le le ma weitouku minge tisi nele, le tisi fei Moses laltouku lepe ma oloye’.” ");
INSERT INTO ong_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Fei le mete lipi wuso pifei lepe lopoluwo Stiven le pe puluwo mimati liti Stiven lele watafei mati liti riri liti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Fei metine ili liti leltawio Ma Ili siye leifale leletei Stiven ye “Il fei pepei punkom lom?” ");
INSERT INTO ong_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Wolo Stiven namti leifale lirpepeye “Ise winkem re yaire, ise yingiteiki wo. Wusoli sungoitei liye Ma Ili lire singe falowo mani louku Abraham wem le linu ratei Mesopotemia liso leilo le ratei Haran. ");
INSERT INTO ong_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Le le lirpowo lolpepei ‘Fei ye ma usape alpe pire uf peiye le ye ma e e tef fei ki ma kosaiye.’ ");
INSERT INTO ong_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Le leilo lusa tef liti Kaltia lato le le ratei Haran. Le wem Abraham yaitei la Ma Ili laisi le ratei uf fei ise ratei lepei lepe. ");
INSERT INTO ong_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wolo Ma Ili le watowo Abraham tef ile piti le lire lele kolo, nenpe kumpu re oloteiye. Wolo Ma Ili le lirpowo punkom lirpolo le miso watowo tef fei lepe, tef liti Kainan. Watowo piti lele lire eple palie pele piti pingi pau. Le wem fei Ma Ili lapuwe il fei pepei, Abraham, le eple olo.” ");
INSERT INTO ong_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Il fei pepei so Ma Ili lirpowo pepe ‘Eple palie peiye miso pratei tef piti mete nemple le pe ma pesio towa yawi piti mole olo le pe ma pila moingi wem ulel le taurungu wurutei olpe (400). ");
INSERT INTO ong_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Wolo ki miso watepe moingi le mete fei pe pesio towa yawi lelpe lepe, pe miso pusa uf lepe le pe ma paule pifei onposiki rautuki ratei tulum fei lepei’.” ");
INSERT INTO ong_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Leye lo Ma Ili lapuwe il lire Abraham piti ma paploupe topungou soma pe kosape pe potei watafei pe pulpope il wuso Ma Ili lapuwe pepe, liso Abraham lalowi topo liti Aisak wem nimou nila le ne nungungu. Fei le Aisak lila Jekop le Jekop lilape eple pele (12) manre pouku. ");
INSERT INTO ong_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Le Jekop eple ilim, pe enke olpe pasi winke kumpu lelpe Josep. Le pe pe paltei le lesio towa yawi ratei Isip. ");
INSERT INTO ong_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Wolo Ma Ili le lontoluwo le le kanowo wem le moingi falowo. Wem Josep le falowo metine ili Fero liti Isip Ma Ili watowo onom malye le onom nire wuru, leye lo Fero laltei le metine liti lontoluwepe uf pire mete re oweli men nange pele.” ");
INSERT INTO ong_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Leye lo wem oli piti oweli olo falepe mete piti Isip pire Kainan, le moingi ili piti nilim paplei falepe mete wuru, le manre pouku ma paisepe oweli pato linei, olotei. ");
INSERT INTO ong_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Leye lo wem Jekop kapi il pirpei polpepei luom telmane pifei Isip, le laisipe eple tuleingi pele, manre pouku, pe peifale pe. ");
INSERT INTO ong_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Le wem pe nou pe pasi, winke lelpe Josep leite lotei alepe nimin le ilim pele lire winke lelpe, leye lo Fero retape alpe piti Josep. ");
INSERT INTO ong_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Fei le Josep laptei il pe yaitei lele Jekop lirpowo piti ma le lire alpe pele ma paule Isip. Wem pe paule Isip pe mete wuru (75). ");
INSERT INTO ong_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jekop lire alpe pele pe pratei Isip lepe, pe pa. ");
INSERT INTO ong_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pe kapi pilape pau Sekem leye pe paptei pato erau nample liti Hamor lire eple pele wuso Abraham lire mole lipi laise lepe.” ");
INSERT INTO ong_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Fei le wem lau lire malfem piti Ma Ili ma onposiepe il wuso le lapuwe lire Abraham pepe so ma le watepe tef liti Kainan. Le mete piti Israel wuso pratei Isip pepe pe fale wurutetei. ");
INSERT INTO ong_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Wolo metine ili nele, fale lile lontoluwo Isip, le retawo Josep kolo. ");
INSERT INTO ong_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Le lempesipe mete pouku, lirpei lilape manre pouku, le le lirpepe il singe piti pe ma kapi eple kumpu wem emare pilape paptei pratei yaupe le pe ma pa. ");
INSERT INTO ong_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Le wem fei le lolpepei, wem lepe nimou nila Moses le ninge fei lepei lepe, le teingi lailele lotei yawi wem Ma Ili luluwo. Le pe pontoluwo kotopawo pailolowo pifei winem pe fale anongou winges niliye. ");
INSERT INTO ong_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Wem pe kali pila pe towa yawi tani winem, ningio feri piti Fero kali nila nire ninge nange lene. ");
INSERT INTO ong_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Le le fale metine ili piti lirpepei le piti lesio towa wuso oli pe peltalo le le kapi il piti Isip.” ");
INSERT INTO ong_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Wem Moses taurungu pele fale wuru (40) le onom pele weitei ma nou le lulwepe ilim re winkem pele, mete piti Israel. ");
INSERT INTO ong_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wem lepe metine liti Isip losio metine liti Israel. Leye lo le kanowo metine teluwi nempleiye lele, le le letesi metine liti Isip la. ");
INSERT INTO ong_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Fei le lirpolo mete pele miso puluwo retai polpepei Ma Ili miso laltei le ma kali moingi taniepe wolo pe puronom.” ");
INSERT INTO ong_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Fei nolowi le lulwenge mete titi Israel tosinoute, le le lirpolo ma kareringe, le le lirpeiye ‘Ise rounge yingitei, Ise rounge teluwi nempleiye, le piti polomen so ise yosinoute?’ ");
INSERT INTO ong_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Wolo metine piti losio metine nele lepe laisi Moses le tanienge rounge le le leletei Moses lirpepei lolpepei ‘Minele leiteiye piti ye ma ontoluku le ye ma ulwepe moingi pouku?’ ");
INSERT INTO ong_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Ye irpolo ma eteteiki ka watafei nomul ye etesi metine liti Isip la lepe’?” ");
INSERT INTO ong_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Fei le wem Moses le lingitepe il fei pepe le leifale linlele luru le ratei tef piti Mitian tani Isip. Lepe le lilange eple winges.” ");
INSERT INTO ong_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Wem taurungu wurutei pe (40), riri liti Ma Ili lire weli loli nimpe wala namin falowo Moses ratei tef yawi lato lire Sainai tumun malfem. ");
INSERT INTO ong_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Wem Moses le lontoli lolpepei le il re olo, lirpei kolo. Le posiye le malfem ma luluwo weli wuso loli nimpe namin lepe. Wolo le lingitowo Ma Ili il peleye. ");
INSERT INTO ong_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ki Ma Ili liti manre peiye Abraham lire Aisak re Jekop. Ki so Ma Ili lelpe lepe.’ Wem Moses le lingitei le punwewi le le turuwo ma weitei lontoli lolomen olo touliye. ");
INSERT INTO ong_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Fei le Ma Ili lirpowoye ‘Ye kotuwepe ire fila peiye tani wuso oli ye au tulum fei lepei ki kutei kile teingitei.’ ");
INSERT INTO ong_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Fei le le lirpowoye ‘Ki kulwepe mete piti Isip posiepe mete piti Israel olpetei. Le ki kingitepe pailo pinanaiki, ki so kaule ma kaniepe, fei ye aule le ki ma kaiteiye e Isip’.” ");
INSERT INTO ong_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses le so mete piti Israel pinauli le pe peleteiye ‘Minemple peiteiye piti ye ma ontoluku le ingitepe moingi pouku.’ Le so Ma Ili laltei watafei metine liti lontoluwepe le metine piti kaniepe. Wuso Ma Ili lirpei fale nemi liti riri wem le lire weli loli nimpe namin.” ");
INSERT INTO ong_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","“Wem fei lepe Moses le laptei towa lipi potei fale lire singe liti Ma Ili pratei Isip re Peryai Yalei. Lepe so le kesipe mete lilape le tani Isip, pe pratei tef yawi taurungu wurutei (40). ");
INSERT INTO ong_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Le Moses elpesi lepe lirpepe lolpepe ‘Ma Ili ma laisi metine nimou lau lirpepei ma laule ise watafei le laitei ki kau lepei. Le metine fei lepe ma teluwi piti ise.’ ");
INSERT INTO ong_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Fei le Moses lotei so lire mete piti Israel pepe peifonemple pile tef yawi lepe. Le lile lire manre pouku re riri wuso lirpowo ratei Sainai tumun, le le so kapi il piti Ma Ili piti pratei wem oli pepe so laptei pau ku. ");
INSERT INTO ong_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Wolo manre pouku paptowo mingim kolo, pinauli le pe weisi le lire plen laitei le pe pirpolo ma nou pe Isip. ");
INSERT INTO ong_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Le pe pirpowo Aron, Moses line lele, pirpowoye, Ye osiepe men nemple wauku soma ku mulwepe watafei ma lipi pouku pepe. Wusoli metine, Moses fei le lau tani Isip lepe olo ku mretawo kolo, leinei linei le, lo menele lalei le.’ ");
INSERT INTO ong_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Leye lo pe pesio ma ili lelpe watafei senge pulmakau, le pe papo yuri peptawi paptei watowo. Pe pesiepe purowo wusoli pe potei peletei Aron le le lesio fale. ");
INSERT INTO ong_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wolo Ma Ili kani onom lantepe kolo, le so laptei pe prautuwepe taurungu piti yuwei watafei il paptei paitei yousi piti mete amare polpepei, ‘Fei ise mete piti Israel, wem ise yile yeinenei yinge tef yawi lepe, ise yosiepe yuri yeptawi yaptei pau ki kolo. ");
INSERT INTO ong_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Le winem fei ise yila lepe weni liti towa lelpe Molek lire tauru piti towa nele Refan so ise yingowo lepe. Liso fei ki ma kaiteise ye tani uf peise ye Babilon le ise ma wala ye tani’.” ");
INSERT INTO ong_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Fei ise retai manre pouku pe pilane winem kumpu le winem fei nepe Ma Ili lotei ratei, wem pe pile peinenei pinge tef yawi. Pe pesiene pingepe il piti Ma Ili wuso le lirpowo Moses le le lirpepe pepe. Pe pingepe il wuso Ma Ili lirpowo Moses piti pe ma posiene, pe so posiene. ");
INSERT INTO ong_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Wolo wem fei pe pire Josua, pe manre pouku, yaire pelpe watepe winem pila pe so pe kali tef piti mete nemple lelpe wuso oli Ma Ili lotei laptu taniepe. Winem ratei le. Le fale wem metine ili Devit le fale. ");
INSERT INTO ong_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Le Ma Ili re onom rapowo, liso le leletei Ma Ili ma lusa lesio winem nele piti Ma Ili liti Jekop lele. ");
INSERT INTO ong_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wolo ninge lele Solomon le so lesio winem lepe.” ");
INSERT INTO ong_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Wolo Ma Ili liti Yuwei le ratei winem fei motwalem pesio kolo. Metine nimou lirpepei lepe, lirpei lolpepei, ");
INSERT INTO ong_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Teplai yuwei, le poi lipi peiki piti kifei kontolili le tef piti ma kapiri ire pile. Winem fei lolomen soma ye yesio ki lol lepe? Le tulum fei linei soma kaltei yef lepe. ");
INSERT INTO ong_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Men nange fei pepei ki kutei kaptei lo olo’?” ");
INSERT INTO ong_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Fei ise mete piti Israel piti polomen so, ise yingitepe il piti Ma Ili kolo, kuna yire moingi olpe le enke peise, ise yire yef yire il piti Ma Ili. Ise kuna watafei manre peise. Ise wem oli yinauli Riri Teingi. ");
INSERT INTO ong_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Le manre peise pe watepe mete emarengi moingi. Pe posiepe mete piti kapi il Ma Ili pele, il piti le ma laisi metine teingitei lele ma lau, la liti lesio towa lele. Le fei ise yingio tisi liti manre peise, ise yalpo metine elpesi wuso pe pirpei ma lau. Ise yesio yaltei laitei nimpe le la. ");
INSERT INTO ong_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Fei ise isotei so kapi il lipi piti Ma Ili lepe wuso riri liti Ma Ili wauku wolo ise yulpope kolo.” ");
INSERT INTO ong_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wem mete lipi piti peptawio Ma Ili siye pingitepe il piti Stiven pe enke kotuwepe pasio. ");
INSERT INTO ong_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Wolo Riri Teingi lunkuwo Stiven le le leila oru lontoli lunwei le yuwei, le le luluwo if piti Ma Ili lire Jisas lile eti tilpi liti Ma Ili lele. ");
INSERT INTO ong_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Leye lo le lirpepe “Ise yontoli. Ki kulwepe winki piti teplai kere polowi le Jisas lile eti tilpi piti Yaitei lele.” ");
INSERT INTO ong_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Leye lo pe peifale pailolowo le pe pire esi pelpe popopope mingim pelpe. Yo pe mete wuru ye pantu karowo Stiven pe. ");
INSERT INTO ong_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Le pe pirpeye, “Kesi yila ye ratei tisi teingo yawi tani uf soma yiripe era yosio.” Le mete piti piripe pamtuwo kotuwepe olongou lipi pelpe piti yuwei, paptei pratei le metine lainouwo, nange lele Sol, le lile lontoluwepe. ");
INSERT INTO ong_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wem pe piripe era palpopo, Stiven leletei Ma Ili, “Jisas ye ili leiki, ye kali nempi leiki.” ");
INSERT INTO ong_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Le yaruwepe yamkelem ratei le le lailo lirkilau lolpepe, “Apa ye ma onposiepe moingi fei pe waiki lepe pato.” Wem le lirpei il pepei pe poungo kotu, yo le laye. Le il fei Stiven pe palpo la lepe, Sol lotei re onom nempleiye watafei pe pepei le so lile luluwo liso pe piri era palpo la. ");
INSERT INTO ong_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Wem fei lepeye pe watepe mete piti pulpowo Jisas moingi, le mete piti pulpowo pratei Jerusalem. Pe kere pinkingi pire siye naflepe pe tef liti Judia re Samaria, karipe mete piti pingowo ye, pe olo pratei. ");
INSERT INTO ong_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Fei le mete ilepe piti wem oli pingowo Jisas poutuwo Stiven pirkilau olpe wem pe kali pe paltei. ");
INSERT INTO ong_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wolo metine nange lele Sol, le ma losiepe mete piti pulpowo. Le linki le winem niliyeye niliyeye lisiepe mete nimoure piti pingowo leipipe laptei pau pe winem oli liti moingi ili. ");
INSERT INTO ong_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Fei le mete piti pulpowo wuso kere pinkingi pe uf wuru pepe pe peptalo il. ");
INSERT INTO ong_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Le Filip, le le uf ili liti Samaria, lepe le leptalo il piti metine Ma Ili lotei laltei lau lepe, le mete piti uf lepe. ");
INSERT INTO ong_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Fei le mete wuru paptowo mingim le pe kapi il wem le lirpepei. Pe mete wuruye pingitowo le pe pulwepe men nange wuso le laptei fale pepe. ");
INSERT INTO ong_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ririm olpe rapo nenglati naro pe taniepe mete, le mete piti ire esi olpe pire mete piti pirkir pifei pe re fale teingipe. ");
INSERT INTO ong_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Leye lo mete piti Samaria enke pelpe teingipe olpe. ");
INSERT INTO ong_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wem fei lepe, metine nange lele Saimon le ratei uf ili fei lepe lempesipe mete lirpolo le metine ili, kuna le lesio towa lire singe piti ririm re towa piti tef. ");
INSERT INTO ong_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Le mete lipi re kumpu wuso pratei uf ili lepe weitei paptowo le mingim, le pe pirpei, ‘Lepei lepe so singe piti Ma Ili falowo le pe pretai polpepei singe lipi piti Ma Ili so pepe.’ ");
INSERT INTO ong_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Le pe weitei pingowo wuso olo le kusape towa lele singe pele wem ulel le pe paptowo le mingim poporotei. ");
INSERT INTO ong_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wolo wem pe pulpowo Filip wem le leptalo il, le il piti Filip, il teingipe piti Jisas, le metine Ma Ili lotei laltei lau lire Ma Ili lotei ma lontoluwepe mete fei pe kani onom pantowo pepe. Le pe kaptetei nimoure mete wusoli pe pulpope il fei pepei. ");
INSERT INTO ong_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon lotei re lungungu wusoli le lulpope il fei Filip leptalo pepe. Wem le lungungu, le weitei lulsi Filip rounge teye. Le wem te rounge te, le le luluwo towa men nange lipi wuso Filip laptei fale pepe le il re olo, lirpei kolo. ");
INSERT INTO ong_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Fei le mete piti pingowo pratei Jerusalem kapi il polpepei, mete piti Samaria pe pulpope il piti Ma Ili. Leye lo pe paisinge Pita lire Jon rounge te tulwepe. ");
INSERT INTO ong_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wem te rounge te fale, leye lo te teletei Ma Ili soma Riri Teingi ma lau lunguwepe mete piti pulpowo. ");
INSERT INTO ong_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Wem pinu pulpowo Riri Teingi lau lunkuwepe kolo. Wusoli pe pire nange liti Apa Jisas lotei pungungu. ");
INSERT INTO ong_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Leye lo Pita lire Jon rounge teptalo esi puwo eri falongou pelpe le Riri Teingi lau lunkuwepe. ");
INSERT INTO ong_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Fei le Saimon lulwepe wuso pe kali Riri Teingi, wem mete titi tingowo teptalo esi puwo eri falongou pelpe. Leye lo kapi mole ma watenge mete titi tingowo, ");
INSERT INTO ong_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","le le lirpenge lolpepei, “Ise rounge waiki singe fei pepe soma ki re, wem ki keptalo esi puwo pe re miso kali Riri Teingi.” ");
INSERT INTO ong_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Wolo Pita namti lirpowoye “Wuso ye onposi irpolo ye ma ire mole aisi Riri Teingi liti Ma Ili, ye ire mole peiye miso ya. ");
INSERT INTO ong_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Le ye metine fei olpepei, onom peiye watafei ku pouku kolo, le Ma Ili re luliye metine teingi kolo, ye ma esio towa irouku pato. ");
INSERT INTO ong_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Fei ye ma usape il olpe peiye pepe pato le ye ma eletei Ma Ili ma onom teingine lireye. ");
INSERT INTO ong_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Wusoli ki kontoli watafei ye onom onetei, irpolo singe watafei pepei ma faleiye, le ye oli olpe piti tef lepei pesiye pirkilautei. ");
INSERT INTO ong_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Leye lo Saimon lirpenge Pita lire Jon ye “Polpepe ma ise rounge yeletei Ma Ili yireiki, soma men nemple fei rounge yirpei pepe ma faleiki pato.” ");
INSERT INTO ong_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Wem te rounge teptalo il pe mete tire nange liti Jisas, metine Ma Ili lotei laltei lire il piti Ma Ili leye lo te rounge nou te Jerusalem. Le wem te nou te te teptalo il teingipe te uf wuru piti uf ili Samaria. ");
INSERT INTO ong_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Fei riri liti Ma Ili lirpowo Filip ye, “Ye eilo kapi men nange peiye, le ye ma usa tulum lepei wem epli lau lile nimin ingowo tisi fei leilo Jerusalem le le le Gasa, tisi fei lepei lato tef yawi.” (Fei tisi fei lepe olo ku mingowo koloye, lato yawi.) ");
INSERT INTO ong_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Leye lo Filip leilo kapi le le lilape le. Fei le wem le lilele le, metine ili piti Itiopia ma lau le uf lele. Le metine fei lepei le metine piti lontoluwepe oweli teingipe piti moto ine piti Itiopia. Le le rautuwo Ma Ili lato Jerusalem so nou lifei nongo wingelem pele laule. Le wem le lifei linge tisi le, le lungunape yousi piti metine nimou nange lele Aisaia. ");
INSERT INTO ong_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Leye lo Riri Teingi lirpowo Filip lolpepei “Ye e iripe nongo wingelem (karis) piye malfem.” ");
INSERT INTO ong_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Fei le Filip lantu frou le liripe malfem, leye lo le lingitowo metine ili lepe lungunape yousi piti Aisaia metine nimou liti Ma Ili. Wem le lingitowo le le leleteiye “Ye retape il pal fei ye ungunape pepe lo olo?” ");
INSERT INTO ong_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Fei le metine ili namti lirpowo lolpepei “Ki ma retape kolomen? Wuso nemple nampli pirpei so?” Leye lo lirpowo Filip longlo le rounge tifei nongo wingelem. ");
INSERT INTO ong_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Le il wuso fei le lungunape pepe men so pepei, “Le watafei sipsip, pe kesi pila pe ma palpo. Le le watafei sipsip ninge, wem pe palowi tipli le le lailolo kolo. Le lirpei il nemple kolo. ");
INSERT INTO ong_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pe pirpei il piti le ma tapune le minele ma kanowo olotei. Minele ma luwalo lile tulum lele soma pe retai polpepei le ninge paliene liti le. Wusoli wem liti le ratei tef lepei le oloye.” ");
INSERT INTO ong_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Leye lo metine ili leletei Filip ye “Ye irpeiki metine nimou lepe, minele so lirpei il fei pepei? Le lirpei le lotei lo lirpei le mi?” ");
INSERT INTO ong_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Fei le Filip le lirpei il pal piti il fei pepe lasi il teingipe piti Jisas lirpowo metine ili liti Itiopia. ");
INSERT INTO ong_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Wem te tirpepei tinge tisi te, te rounge te fale wof kumpu nato tisi, wolo epli lanpo nongere le kumpu nire wolom nifei. Leye le metine ili lirpowoye, “Tipe kumpu nepei le piti fei polomen so ki ma kungungu kolo?” ");
INSERT INTO ong_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip lirpowo, “Ye miso ungungu wuso ye ulpowo Jisas metine Ma Ili lotei laltei, ire onom peiye” “Iyo,” le lirpowo ye, “Ki kulpowo Jisas metine Ma Ili lotei laltei le le ninge lele lotei” ");
INSERT INTO ong_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Fei le, metine ili lirpowo metine piti lesiepe nongo wingelem ma lesiepe lapiri pratei. Leye lo Filip lire metine ili rounge ye kotu tuwalo titipi te wof, te tile tipe leye lo Filip kaltetei. ");
INSERT INTO ong_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Le wem te nou fale tau tani tipe, Riri Teingi liti Ma Ili tousio Filip. Le metine Ili ma nou luluwo lolomen. Fei le longlo le lifei nongo wingelem pele le le rautu lotei leye. ");
INSERT INTO ong_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Le Filip lulu le lotei le fale Astot, leye lo leifale le uf kumpu, kumpu leptalo il teingipe le le, le fale Sisaria. ");
INSERT INTO ong_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Wem fei lepe Sol wala watepe mete piti pingowo Jisas moingi ili. ");
INSERT INTO ong_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Le le luluwo metine ili piti leltawio Ma Ili siye ma kapi yousi piti kosape mete piti peptawio Ma Ili siye pratei Damaskus soma pe retai piti Sol ma lengleipe mete piti pulpowo Jisas pepe. Soma wem le lerengawo metine lo moto piti pingowo Jisas pratei lepe le ma lengleipe kesipe lilape nou pau Jerusalem. ");
INSERT INTO ong_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Wem le linge tisi le Damaskus, lepe le lau fale lirowo uf ili malfem, leye lo if ili fale teplai frouye lau luwali watafei teplai nesi mil. ");
INSERT INTO ong_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Le lusane hos le le kere luwalo le lato tef, le le lingitei il, ye yaupe pirpowo polpepei “Sol, Sol, piti fei polomen so ye osiki ilaiki lepe?” ");
INSERT INTO ong_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Leye lo Sol namti leletei “Metine Ili, ye minele?” “Ki Jisas, ki so ye ilaiki osiki lepe.” Le lingitepe il ye yaupe metine olo. ");
INSERT INTO ong_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Fei, ye eilo ile, le ye inki e uf ili lepe. Fei pe miso pe pirpeiye piti ye ma esio towa menele.” ");
INSERT INTO ong_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Le mete wuso pire Sol pepi pe lepe pontoli polpepe, pe il re pirpei kolo. Le wem pe pingitepe il, pe pingitei, le mi mati lire metine topo olo puluwo kolo. ");
INSERT INTO ong_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Leye lo Sol leilo lile tani tef, le le lonfaripe lus lontoli wolo olo ma lulwepe men nange lolomen. Leye lo pe pesio eti, pesisio pila pinki pe Damaskus. ");
INSERT INTO ong_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Wem fei lepe le oweli, tipe re laplei kolo lontoli loporo kolo le fale wem winges niliyeye. ");
INSERT INTO ong_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Fei le uf ili Damaskus lepe metine nele piti lingowo Jisas le ratei, nange lele Ananaias. Wem fei lepe le lontoli watafei letei yongou, leye lo Apa lirpowoye “Ananaias.” “Menele, Apa ki lepei.” Ananaias lirpei ");
INSERT INTO ong_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Leye lo Jisas lirpowo lolpepei “Ye eilo kapi men nange peiye le ye e tisi pinawo pirpei polpepei ‘Tisi Tuwopou’ e fale winem liti Jutas, ye ma epletei ire metine nange lele Sol liti uf ili Tarsus. ");
INSERT INTO ong_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Le leletei Ma Ili le le lulwepe watafei letei yongou luluwo metine nange lele Ananaias linki laule leptalo esi puwowo soma le nou lontoli loporo.” ");
INSERT INTO ong_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Leye lo Ananaias namti lirpowo “Apa ye, metine fei lepe, mete wuru pirpeiki pire towa oli lele fei le lesio lepe lire mete peiye piti pingeiye wuso pratei Jerusalem. ");
INSERT INTO ong_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Le fei laule Damaskus lire il, mete lipi piti leitaloiye siye lirpowo, le miso lengleipe mete fei pe rautuye le pe peila nange leiye pepe.” ");
INSERT INTO ong_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wolo Apa lirpowoye “Ki kirpei, ye e wusoli ki kutei kesio kirpowo ma lesio towa leiki, piti ma leptalo il peiki, le mete piti Israel pire mete nemple re mete lipi pelpe. ");
INSERT INTO ong_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Le ki kutei ma kosawo towa moingi leiki soma pe puliki retaiki.” ");
INSERT INTO ong_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Leye lo Ananaias linki le winem leptalo esi puwo Sol lus pele. Le le lirpeiye “Winke leiki Sol, Apa lotei laiteiki kau, ye retaiye Jisas lotei so ye uluwo wem ye ingi tisi au lepei, le, le so laiteiki kau soma ye nou ontoli oporo le Riri Teingi ma lunkuye lire kilautei.” ");
INSERT INTO ong_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wem fei lepe, tuwi wuso puwo lus pele pungo puwalo, leye lo laltei lotei yef, le le nou lontoli loporo le le leilo lile, le pe kaltetei. ");
INSERT INTO ong_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Leye lo wem le laplei oweli singe pele nou pau. Fei Sol lire mete piti pingowo pratei Damaskus wem wuru kolo. ");
INSERT INTO ong_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Le leifale karowo winem liti peila nange liti Ma Ili le lile leptalo il piti Jisas. Le lirpei lolpepei “Metine fei lepei, le ninge liti Ma Ili.” ");
INSERT INTO ong_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Fei mete wuru pingitowo, pe il re olo, pos pile peitete nempleiye, “Metine fei lepei le metine liti losiepe mete piti peila nange liti Jisas ratei Jerusalem lepe lom? Le lau piti lengleipe mete fei pepe piti ma nou lilape le mete lipi piti peptawio Ma Ili siye kolo lom?” ");
INSERT INTO ong_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Wolo il piti Sol wem le leptalo, lipi kimplipe. Le lile lirkilautei lesio towa fei lepei, le wem le lesio towa le laptei singe lipi fale kosape lirpei lolo, Jisas le metine ili Ma Ili lotei laltei. Le mete piti Israel wuso pratei Damaskus pepe ma nou weisipe il pirpei polomen olo, wusoli pe pulwepe il pal poporotei, wolo pe pinaulo piti pulpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Fei Sol leptalo il le le wem ulel. Leye lo mete piti Israel pirpei piti ma palpo Sol. ");
INSERT INTO ong_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Wolo Sol lingitepe pirpowo piti pe ma polpepe, mulpou epli pe pratei pato winki lipi piti uf ili pontoli pirpolo Sol naro lau pe ma palpo. ");
INSERT INTO ong_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Wolo mulpou mete piti pingowo paltei litipi lom piti uf lire pora le naro tef, le le leye. ");
INSERT INTO ong_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wem le le fale Jerusalem, le le lirpolo le ma lulsipe mete piti pingowo, wolo pe pulpowo kolo. Piti polomen pe pulpowo kolo? Le re so metine liti lingowo lepe, wolo pe wala turwepe pasio. ");
INSERT INTO ong_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Leye lo Barnabas lau kanowo kesi lila le falepe mete piti pingowo. Fei Barnabas le lirpei nomnaipe il pal piti polomen so Sol luluwo Apa, wem le linge tisi le. Le il wuso Apa lirpowo pepe lasi towa piti Sol wuso leptalo il lire nange liti Jisas linge Damaskus lirkilautei. ");
INSERT INTO ong_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Leye lo Sol liripe pratei le pe pe pau Jerusalem peptalo il pire nange liti Apa pirkilautei. ");
INSERT INTO ong_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Le Sol lirpepe mete piti Israel wolo pe pirpei il Grik le le liripe pilainemple il fei le leptalo. Wolo pe pirpe nemple ma palpo. ");
INSERT INTO ong_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wolo wem mete pele piti pepi pesio towa pingitepe il fei pepei, pe kesi Sol pila pe Sisaria paltei le uf lele Tarsus tani. ");
INSERT INTO ong_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Wem pe kesi paltei le tani, mete piti pulpowo pratei tef liti Judia lire Galili re Samaria pratei poporo. Le mete fale pulpowo Jisas pe fale wurutei wusoli Riri Teingi lotei lalpope weli le le menpipe pile singe piti puluwo Ma Ili pretawo le pe ma onposio le loteteiye. ");
INSERT INTO ong_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Fei le Pita le le uf wuru piti Samaria lato wem nele le le lulwepe mete piti Ma Ili wuso pe pratei Lida pepe. ");
INSERT INTO ong_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Wem le le fale lepe, le lerengawo metine nele nange lele Ainias, le ire esi olpe le le miso leilo tani poi kolo, le taurungu pele wuru (8) piti le luwo. ");
INSERT INTO ong_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Leye lo Pita lirpowo ye “Ainias fei Jisas metine Ma Ili lotei laltei le kaneye fale teingi. Ye eilo kapi poi pire olongelem peiye piti iri renke oru yaruwepe le ye topwepe apiri.” Leye lo wem fei lepeye Ainias nou fale teingi. ");
INSERT INTO ong_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wem mete wuru wuso pratei Lida re Saron puluwo, pe weitei kani onom pantowo Jisas. ");
INSERT INTO ong_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Le Jopa, moto nenpe nange pene Tabita, ne re ne nulpowo Jisas. (Le nange nenpe pene pinane il Grik Dorkas). Le ne wem oli ne nailelepe mete ye, ratei, wuso mete piti oweli yini olo ne ne kanepe. ");
INSERT INTO ong_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Le wem fei lepe ne kainu, le ne naye. Leye lo pe kantetei topo lene le pe pentalo nuwo winem yuwei. ");
INSERT INTO ong_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Le ise ma retai yolpepe, Jopa le lire Lida malfem, fiyen kolo. Fei le wem mete piti pingowo pratei Jopa pingitei il pirpei polpepei “Pita le ratei Lida” pe paisinge mete winges tilape il te tirpowo “Ye ma frou aule, towa men leiye liti fei ma esio re usa, le ye au eli ku wo.” ");
INSERT INTO ong_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Leye lo Pita leifale kapi men nange pele lafofo le le liripe pepi pe. Wem Pita le fale pe pesio kesi pila punwei pe winem yuwei. Lepe, towa nimoure pile peinowo Pita pouti le pe kosawo olongelem wuso wem Dorkas ne ratei le ne naptu watepe pepe. ");
INSERT INTO ong_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Fei Pita laisipe mete nimoure naro pitipi pe tanio. Leye lo yaru yamkelem ratei leletei Ma Ili. Fei le nou weitei karene towa le, le le lirpeiye “Tabita, ye eilo ile!” Nempi lene nou lau lunkuwene, le ne nonfaripe lus frouye fei, le ne nuluwo Pita. Le ne nou neilo ye. ");
INSERT INTO ong_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Fei le luluwene le kesi eti lele laltei le lesiene lilane nile. Leye lo linape mete piti Ma Ili pire nimoure pelpe re towa nimoure pinki pau. Fei laneine lantei ne eti pelpe. ");
INSERT INTO ong_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Fei le mete wuso pratei Jopa pepe pingitepe il fei pepei leye lo pe re pulpowo Apa. ");
INSERT INTO ong_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita lire metine liti lesiepe morou topungou, nange lele Saimon, rounge ratei Jopa wem wurutei, ratei winem liti Saimon lele. ");
INSERT INTO ong_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Fei, le metine nele nange lele Kornilius le metine liti linuwepe yali pal piti Rom, le mete lipi piti Rom paisipe pratei Sisaria. Yali pal nange pelpe pinape polpepei, Itali Yali Pal. Metine ili lelpe lepei le ninge paliene liti Israel kolo. ");
INSERT INTO ong_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Le lire moto eple re mete piti pesio towa lele lepe, mete wuru ye fei pe piti Ma Ili loteteiye. Le mete piti oweli olo le kaniepe. Le le lile singe leletei Ma Ili. ");
INSERT INTO ong_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wem epli weitei lau le lultei piti ma lautile, wem fei lepe piti pe ma pifei onposio Ma Ili. Leye lo lontoli watafei le letei yongou. Le yongou fei lepei le luluwo riri liti Ma Ili lau falowo, le le lirpowo ye “Kornilius.” ");
INSERT INTO ong_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Le weitei lopuluwo le le turuwo lasio riri liti Ma Ili. Le le lirpeiye, “Ili, menele lepe?” Fei le riri liti Ma Ili namti lirpowoye, “Il peiye pire towa leiye wuso aptei pe Ma Ili lepe olo le kapiye, le le onposiye. ");
INSERT INTO ong_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Le fei ye ma aisipe mete ilepe pe Jopa le pe ma pinawo metine nange lele Saimon, wolo le ma Saimon Pita. ");
INSERT INTO ong_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Le lire metine piti lesiepe morou topungou nange lele Saimon le ratei periai mingo.” ");
INSERT INTO ong_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Fei le riri liti Ma Ili wuso rounge tirpei lepe lusa Kornilius le le leye. Kornilius leifale linange mete winges tele piti tesio towa piti winem tire yalu pau le metine piti Ma Ili watafei Kornilius lotei. Le yalu pau fei lepe le lesio towa Kornilius lele. ");
INSERT INTO ong_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Leye lo nampli yongou lirpepe fei le laisipe pe Jopa. ");
INSERT INTO ong_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Fei pire mul, nolowi nenpe wem pe pilele pe pire Jopa malfem, Pita lunwei le winem tuluwom yuwei wem epli lultei nimin piti ma leletei Ma Ili. ");
INSERT INTO ong_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Wolo le nimpi nalei le le linta oweli ma laplei. Wem pe wala papli oweli le lontoli watafei le letei yongou. ");
INSERT INTO ong_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Wem fei lepe le luluwo teplai kere lolowi le men nele watafei ufau pe pesienge um winges te winges le pe pusa luwalo lau tef. ");
INSERT INTO ong_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Fei le ufau fei lepe morou nafle tutu re ilepe pelpe wuso pratei ufau fei lepe. ");
INSERT INTO ong_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Leye lo lingitepe il pe pirpowoye, “Pita eilo lo olo, ye osiepe yuri fei pepei aplei.” ");
INSERT INTO ong_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Wolo Pita lirpowoye, “Olo, ki ma olo, Ma Ili ye retai ki ma kaplei yuri pepei pato. Wusoli Moses lirpei yuri pepei ku ma maplei kolo, ma olo, pe opinge.” ");
INSERT INTO ong_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Wolo le nou lingitei pirpeiye, “Ye ma onposiepe irpolo pe olpe kolo, wusoli Ma Ili laptei le pe teingipeye yaupe.” ");
INSERT INTO ong_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Il fei pepei Ma Ili lirpowo Pita ma lapo yuri fei pepe laplei wem winges niliye. Leye lo pe nou peipipe punwei pe yuwei tanioye. ");
INSERT INTO ong_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","18","Wem Pita leilo lifei onposiepe il pal piti yongou fei lepei pe polomen? Wem fei lepeye mete wuso Kornilius laisipe pe lepe pretawo winem liti Saimon, le pe pe pile wingi lipi le pe pinai pepleteiye, “Metine nange lele Saimon Pita ratei lepe lom?” ");
INSERT INTO ong_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita wala lifei onposiepe ma kapi il pal piti yongou fei lepe wo, wolo wem le lifei onposi Riri Teingi lirpeiye, “Pita aptei mingim mete winges niliye pau pile yawi pintaiye. ");
INSERT INTO ong_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Fei ye eilo itipi frou e. Le ye ma iripe yepi ye wusoli ki Riri Teingi kutei kaisipe pau le ye ma inaulo pato.” ");
INSERT INTO ong_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita nou litipi le, le le lirpepeye, “Ki metine lepei so ise yintaiki lepe. Le piti polomen so ise yaule lepei.” ");
INSERT INTO ong_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Fei le pe namti pirpowoye “Metine piti lontoluwepe yali pal laitouku maule le le metine teingi, le metine piti Ma Ili le mete piti Israel pe onom kerowo pirpolo le teingitei. Le Ma Ili riri nele lele lirpowo piti ma laptei il le ye e winem lele soma le lingitei il men nange piti ye ma irpei.” ");
INSERT INTO ong_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Leye lo Pita lirpepe ye, “Yau metei olo mulpou ye.” Pire mul Pita kapi men nange pele lafofo lire mete ilepe piti pulpowo Jisas piti Jopa pe piripe pepi pe. ");
INSERT INTO ong_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Fei pe pe, pe nolowi nenpe, le pe fale Sisaria, lepe so Kornilius le lifowo lepe lire alpe pele re nimoure mete pele wuso le lirpepe pau pepe. ");
INSERT INTO ong_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Wem Pita ma linki le Kornilius naro lau leisi le le lungura ratei ire pele le le luwalo mi noli tef piti ma leila nange liti Pita. ");
INSERT INTO ong_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Wolo Pita lirpei lolpepei, “Ye eilo wusoli ki metine yawi.” ");
INSERT INTO ong_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Le Pita lirpowo Kornilius lolpepei, wem le linki le winem lepe le lulwepe mete wuru pe peifo nemple pifei leinginim. ");
INSERT INTO ong_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Le Pita lirpepe ye, “Ise wuso retai yolpepei, il lipi piti Israel pe pirpei ku mete piti Israel ma me mire mete alpe nemple mepi maplei mifei mratei lo me mulwepe kolo. Wolo wem ki kontoli watafei ketei yongou Ma Ili lotei kosaiki piti ki ma retai kolpepei, ki ma onposio metine nele le metine oli kolo, le ma weiteiki fale opinge kolo. ");
INSERT INTO ong_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Liso wem ye aptei il pe ma ki kaule, ki keiteiye il wuru kolo. Ki keiteiye kolpepei piti polomen ye aptei il pauleiki?” ");
INSERT INTO ong_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Leye lo Kornilius namti lirpowoye, “Wem winges niliye pe le fei lepei, wem fei lepe ki konposio Ma Ili kifei winem leiki wem epli weitei lau le piti ma le lautile ningli, wem lepe kuluwo riri liti Ma Ili lafo olongou fiyu fale frouye lau lile onom peiki. ");
INSERT INTO ong_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Le le lirpeiye, “Kornilius, Ma Ili oli lingitepe il peiyeye, le le onposiepe towa peiye piti ailelepe mete. ");
INSERT INTO ong_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Fei ye ma aisi metine nele ma le Jopa lirpowo metine nange lele Saimon Pita, le lire metine liti lesiepe morou topungou nange lele Saimon rounge ratei periai mingo.” ");
INSERT INTO ong_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Liso ki keifale kaisipe pe pirpeiye ma au frou. Le ye eifale aptei mingim frou ye au. Fei ku meifo nemple mifei lepei mire Ma Ili le lirouku mifei. Le ku moporo kutou piti ma mingitei il men nange wuso Ma Ili le lirpeiye piti ma irpei.” ");
INSERT INTO ong_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Fei le Pita le nempe nemi lirpeiye, “Ki retai punkom kolpepei Ma Ili le onposiepe mete wuruye fei lirpolo pe ma pratei pantenempleye fei. ");
INSERT INTO ong_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pe turwepe pasio le pe pesiepe towa teingipe piti le onom teingine liripe. Pe polpepe wuso pe piti alpe nele nele re Ma Ili le onom teingine liripeye yaupe. ");
INSERT INTO ong_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ise retai il wuso Ma Ili laptei pau mete piti Israel lirpepe retai il teingipe piti ratei yoporo lire metine lotei laltei Jisas. Le Ili piti lirpepe mete piti tef lepei. ");
INSERT INTO ong_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Le ise ma retai towa ili wuso fale linge tef liti Judia lelpe lepe, towa fei lepei le falepe Galili linu wem Jon le leptalo il piti kaptetei mete. ");
INSERT INTO ong_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Le ise retawo metine fei lepei Jisas liti Nasaret, le Ma Ili lalfowo Riri Teingi lire singe rasi. Le le le liye liye re le lesio towa teingi le le leilape mete piti fei pe pifei eti piti towa wuso Ma Ili lotei liri rounge. ");
INSERT INTO ong_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Le ku so mete piti mulu towa teingi fei le laltei fale Jerusalem lire tef piti Israel lepe. Le pe palpo la pire singu pengleipe esi pire ire pasi nimpe le pe pusa laitei. ");
INSERT INTO ong_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Wolo Ma Ili nou leila wem pe palpo la le pe paltei lato wem winges niliyeye kari. Wolo le kesi laltei le mete wuru pepe kolo, olo. Le le falouku mete fei Ma Ili lotei leitouku piti ku ma mile mulu towa ili fei lepei. Le ku miri le mepi maplei oweli wem le nou leilo tani tulum liti pa. ");
INSERT INTO ong_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Leye lo Jisas le lirpouku il singe piti ku ma meptalo il pele pe mete le ku mirpei punkom piti Jisas le so Ma Ili laltei liti lingitepe moingi piti mete yeflipe piti pa re ilepe piti pratei. ");
INSERT INTO ong_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Wusoli mete emarengi yeflipe pirpei polpepei, mete piti pe pulpowo metine fei lepe Ma Ili miso laisipe il olpe pelpe taniepe.” ");
INSERT INTO ong_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wem Pita wala lirpepei Riri Teingi lau lunkuwepe mete wuso fei pe pifei pingitepe il pepe. ");
INSERT INTO ong_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Leye lo mete piti Israel piti pulpowo wuso pratei Jopa le pe piri Pita pepi pau pepe pontoli Riri Teingi lau lunkuwepe mete nemple pe il re pirpei kolo. Wusoli Ma Ili laltei Riri Teingi lele le mete nemple pe piti Israel kolo. ");
INSERT INTO ong_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Wusoli pe pingitepe mete nemple pepe pirpei il nemple nemple le pe rautunemple peilape singe lipi piti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Wem Pita lingitepe le leifale lirpei lirkilau lolpepei “Mete fei pepei pe kali Riri Teingi watafei ku mete piti Israel. Le minele miso il karouku ma mire tipe kaptetei kolo wusoli Riri Teingi lunkuwepeye?” ");
INSERT INTO ong_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Fei lirpepe piti pe ma pungungu pire nange liti Jisas metine Ma Ili lotei laltei. Le pe pirpowo pirpolo le ma liripe ratei wem nele so le. ");
INSERT INTO ong_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Fei le mete piti pingowo pire mete piti pulpowo wuso pratei tef liti Judia lepe pingitepe il polpepei mete piti mete nemple alpe nemple re pe kapi il piti Ma Ili-ye. ");
INSERT INTO ong_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Leye lo wem Pita le le fale Jerusalem mete piti pulpowo pau peifo nemple. Mete ilepe pelpe onposi mete wuso ma pulpowo pe moso paploupe topungou pelpe. Liso pe peifale pamtuwo pirpeiye “Piti polomen ye e ire mete piti paploupe topungou kolo yepi yaplei?” ");
INSERT INTO ong_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Wolo Pita leifale lirpei nomnaipe il pal le pe pingitei. ");
INSERT INTO ong_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Wem nele lepe wem ki kratei uf ili liti Jopa le ki kifei keletei Ma Ili, leye lo onom peiki weitei le ki kulwepe men teingipe piti Ma Ili faleiki. Ki kuluwo menele watafei ufau pe pesiepe minkelem pele le pe pusa litipi naro teplai yuwei lau faleiki malfem, le le lirkir lultei. ");
INSERT INTO ong_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ki kontoli koporo le ki kulwepe yuri fei pepei pratei leinginim watafei morou tutu re naflepem pe pratei ufau fei lepe. ");
INSERT INTO ong_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Le ki kingitepe il pe pirpei polpepei, ‘Ye eilo, Pita le ye osiepe yuri fei pepei aplei.’ ");
INSERT INTO ong_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Wolo ki kirpei, ‘Olo, ki ma olo, Ma Ili ye retai yuri pepei il piti Moses lirpei ma maplei pato. Ki miso kaplei kolo.’ ");
INSERT INTO ong_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","10","Wolo ki nou kingitei il paule teplai pirpei, ‘Olo, ye ma onposiepe irpolo pe olpe kolo wusoli Ma Ili laptei le pe teingipe ye yaupe.’ Il fei pepei Ma Ili lirpeiki ma kapo yuri fei pepei kaplei, lirpei wem winges niliye. Leye lo pe nou peipipe pe teplai yuwei taniki. ");
INSERT INTO ong_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Wem fei lepe mete piti Sisaria wuso pe paisipe pau pe fale pile winem fei ki ratei lepe. ");
INSERT INTO ong_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Le Riri Teingi lirpei ki piti ki ma kiripe me. Ki ma kinaulo pato. Le wem ki keilo mete piti pulpowo piti Jopa pire eti plen le niliye (6) peilo pireiki me Sisaria le ku mepi me minki me winem liti Kornilius. ");
INSERT INTO ong_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Le le lirpouku piti fei le luluwo riri liti Ma Ili lau lile winem lele, le le lirpowoye, ‘Ye ma aisi metine nele ma le Jopa lirpowo metine nange lele Saimon Pita. ");
INSERT INTO ong_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Le miso lirpei il leptalo pe ye. Ye miso ire moto eple re mete piti pesio towa leiye miso yire yisotei teingipe.’ ");
INSERT INTO ong_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Wem ki nempe nemi kirpepe Riri Teingi lau lunkuwepe watafei le lau lunkuku ku kutou linu lepe. ");
INSERT INTO ong_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Leye lo ki onposiepe il piti Apa wuso lirpei pepe, lirpei lolpepei, ‘Jon keiteteise lire tipe nimou. Wolo fei ki ma keiteteise kire Riri Teingi.’ ");
INSERT INTO ong_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","So fei ise yontoli il pal pile yaupe polpepei Ma Ili le linu wauku mete piti Israel Riri Teingi, liso mete alpe nemple wem pe pulpowo Jisas, le metine Ma Ili lotei laltei, le watepe Riri Teingi. Le ki metine fei kolomen liso ki ma kusape mete fei Ma Ili watepe Riri Teingi pepe. ");
INSERT INTO ong_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Wem pe pingitepe il fei le lirpei pepe, pe pos pato le pe peila nange liti Ma Ili pirpeiye, “Sungoi mete alpe nemple, pe pulpowo Ma Ili kolo, singe piti pe ma ausi kani onom pantowo soma pe pirouku mratei moporo wem oli. Wolo fei Ma Ili le watepe.” ");
INSERT INTO ong_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Fei le mete piti pulpowo wuso turwepe pasi moingi pinu fale wem pe palpo Stiven. Ilepe pelpe kere pinlele puru pe fale watafei Fonisia, Saiprus re Antiok pirpepe mete piti Israel potei pire il piti Jisas, Apa louku. ");
INSERT INTO ong_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Le mete ilepe piti pulpowo pe piti Saiprus re Sairini pe fale Antiok le pe peptalo il pe mete piti mete alpe nemple, pirpei il teingipe piti Jisas Apa louku. ");
INSERT INTO ong_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Le Singe liti Ma Ili lele lunkuwepe le mete wuru olpe fale pulpowo le pe weitei kani onom pantowo Apa. ");
INSERT INTO ong_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Leye lo il fei pepei pe falepe mete piti pulpowo Apa pratei Jerusalem, le pe peifale paisi Barnabas le fale Antiok. ");
INSERT INTO ong_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wem le le fale, le lulwepe mete pe oli Ma Ili le lailelepetei. Le onom teingine liripe, le le lirpepe lalpope weli piti pe pile singe pulpowo Apa polpepeye, pato pire enke pelpe ma peila nange liti Ma Ili. ");
INSERT INTO ong_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Le Barnabas, le metine teingi, le Riri Teingi lunkuwo lirkilau le le lulpowoye, leye lo mete wuru pe weitei pau pulpowo Apa. ");
INSERT INTO ong_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Fei le Barnabas le Tarsus lintawo Sol. ");
INSERT INTO ong_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wem le lintawo le, le lerengawo te rounge nou tau Antiok. Lepe te rounge tratei tauru niliyeye, le te tire mete piti pulpowo pepi peptalo il pe mete wurutei. Le Antiok, uf fei lepe so mete piti pingowo pinu pinape Kristen pirpolo pe mete piti pulpowo Jisas Krais. ");
INSERT INTO ong_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Le Wem fei lepe mete amare ilepe peilo Jerusalem le pe pe Antiok. ");
INSERT INTO ong_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Leye lo metine nimou nele nange lele Akapus, leilo lile le Riri Teingi liti Ma Ili watowo singe le le leptalo il lirpei piti epli le taurungu olpe piti, oweli olo ma falepe. (Towa oli fei lepei fale wem Klodius le metine ili liti Rom.) ");
INSERT INTO ong_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Fei le mete piti pingowo pirpei papwe il piti ma metine niliye niliye, le ma laptei oweli teingipe pele pe ma kaniepe mete piti pulpowo pratei tef liti Judia. ");
INSERT INTO ong_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Leye lo pe paptei nemple mingim le pe paptei mole pe watenge Barnabas lire Sol, le te rounge tilape te Jerusalem watepe mete piti pinuwepe mete piti pulpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wem fei lepe metine ili nange lele Herot, le re so lolpepeye, le watepe moingi le mete piti pulpowo Jisas. ");
INSERT INTO ong_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Le lirpepe yali pal pele pire ila palowi Jems line liti Jon falo. ");
INSERT INTO ong_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Le wem Herot lulwepe mete piti Israel pe enke teingipe pire Jems la, le lirpepe yali pal, piti pe ma pesio Pita re teraiye (moingi fei lepei fale wem mete piti Israel pe pos pifei onposio wem piti luom lankengei kolo.) ");
INSERT INTO ong_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wem le lenglei Pita le lalingi lifei winem oli, lepe le laltei le eti piti yali pal wuru (16) pe kani nemple wem niliye niliye winges winges (4) pau pontoluwo Pita poporoye pato. Leye lo metine ili Herot le onposi ma laltei Pita le lile lutepe piti mete wuru soma pe pingitei piti polomen so le ma la lepe. Wem pe pifei onposiepe wem piti sungoi Ma Ili kesipe yaire pelpe pilape pe tani Isip. Wem lepe pe ma paltu. ");
INSERT INTO ong_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita lifei winem oli wolo mete piti pulpowo wem oli peletei Ma Ili piti le ma kanowo. ");
INSERT INTO ong_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mulpou piti fei pire nolowi Herot ma kesi lila le falepe mete wuru, mulpou fei lepe pe topuwo Pita pire foiye lingi kimplinge winges. Le le letei lato yali pal winges nimin. Wingi lipi piti winem oli lelpe re yali pal pile pontoluwepe wusoli wem lepe piti pe ma pile posio towa. ");
INSERT INTO ong_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Fei le riri liti Ma Ili fale frouye lau lile, le if lele le nainu winem oli lepe. Le riri lesio Pita eti yoli le le kumtasi lirpowo ye “Ye eilo frou lolo.” Wem Pita le leilo, foiye lingi kimplinge wuso toli esi pele tepe poteiye potopo tanio. ");
INSERT INTO ong_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Fei riri nou lirpowo lasi “Ye eipi mongopo leiye englei alpo nampi asi olongou ili leiye liti towa yawi lepe menpe, le ye topupuwepe ire fila peiye piti ire le ye aule wepi weli.” ");
INSERT INTO ong_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Leye lo Pita kotu lolsi rounge naro winem oli lepe te towa yawi. Fei Pita lirpolo le letei yongou, le le olo retai men kolo. ");
INSERT INTO ong_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wem te rounge raptei yali pal tulum nele le nele, leye lo te rounge te fale wingi lipi piti winem oli ma naro pe uf ili le wingi lipi fei pepe potei pungo tanienge. Le te rounge naro te. Wem te rounge tilele te tisi ulel taise, riri liti Ma Ili lusa Pita le le kotire frouyo fei. ");
INSERT INTO ong_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Fei Pita retai, le le lirpei lolpepei, “Fei ki kretai pepei punkomtei wusoli Ma Ili laisi riri lele laule le le kaneiki leteiki kau tani singe piti Herot le men nange fei mete piti Israel wuso pe pirpei piti pe ma fale pepe.” ");
INSERT INTO ong_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Wem le retai lotei loporoye, le le winem liti Jon Mak nimou pele. Le winem fei lepe mete piti pulpowo wurutei pe peifonemple pifei peletei Ma Ili piti le ma kanowo Pita. ");
INSERT INTO ong_