﻿USE sofia;
DROP TABLE IF EXISTS sofia.omw_vpl;
CREATE TABLE omw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES omw_vpl WRITE;
INSERT INTO omw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iesusi Karaisira okyara mwataamama vahiro. Evarahaamuvavata Ntevitivavata mwitanahua mwia haivaqahuatana varura. ");
INSERT INTO omw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Evarahaamuva Aisaakira qova varuvaro Aisaakiva Iaikopura qova varuvaro Iaikopuva Iutaaravata mwia qata vakyaanramwu sova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iutaava Peresikya Saraakya sova varuvaro mwitanahua nyova Temaava varura. Peresiva Hesaroninra qova varuvaro Hesaroniva Raminra qova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramiva Aminantaapura qova varuvaro Aminantaapuva Nasoninra qova varuvaro Nasoniva Saramoninra qova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saramoniva Mpoasira qova varura. Mpoasira mwia nrova Rehaapiva varura. Mpoasiva Ompetira qova varura. Ompetira mwia nrova Rutiva varura. Ompetiva Iesira qova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iesiva Ntevitira qova varura. Ntevitiva nronraqama viro vunyaa vaisivanto varura. Ntevitiva Soromoninra qova varura. Soromoninra nrova tauraaqama kyero Iuraiaara nraatavanto varura. ");
INSERT INTO omw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soromoniva Riampoaminra qova varuvaro Riampoamiva Apaisaara qova varuvaro Apaisaava Esara qova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esava Sihosapatira qova varuvaro Sihosapativa Soraaminra qova varuvaro Soraamiva Asaiaara qova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaiaava Sotaaminra qova varuvaro Sotaamiva Ehaasira qova varuvaro Ehaasiva Hesekaiaara qova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaiaava Manasaara qova varuvaro Manasaava Emosira qova varuvaro Emosiva Sosaiaara qova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sosaiaava Sekonaiaaravata mwia qatanramwuvata sova varura. Mwi entara mpo mwatanaahua ekyaa Isareri rupa kyeta sitaqita mwatukya mpo Papironini uro kyovaro ");
INSERT INTO omw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Sekonaiaava Siatierira qova varuvaro Siatieriva Serapaperira qova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serapaperiva Apaiaatira qova varuvaro Apaiaativa Eraiaakiminra qova varuvaro Eraiaakimiva Esora qova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esova Setokira qova varuvaro Setokiva Ekiminra qova varuvaro Ekimiva Eraiaatira qova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eraiaativa Eriesaara qova varuvaro Eriesaava Mataaninra qova varuvaro Maataniva Iaikopura qova varuvaro ");
INSERT INTO omw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iaikopuva Iosepira qova varuvaro Iosepiva Mariaara mwia vaativanto varura. Mariaava Iesusira mwata tora. (Tirenramwu Iesusirara Karaisirave, Mesaiaave, Kotiva titai vaisirave tunanra.) ");
INSERT INTO omw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iesusi Karaisira kuaa okyara vahirero Evarahaamunraqaatairo Ntevitiraqaa mwia haivaqahua 14 nramwu mwi okyarahua varura. Ntevitiraqaatairo Papironini rupaqita uro kyo entaraqaa mwia haivaqahua 14 nramwu mwi okyarahua varura. Papironini rupaqita uro kyoraqaatairo Karaisiva qovara hu entaraqaa mwia haivaqahua 14 nramwu mwi okyarahua varura. ");
INSERT INTO omw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesusi Karaisira mwatato okyarava mwataamama vahiro. Mwia nronra Mariaara Iosepira qati titovaro hia mwikyantiri nrohu vakya Mariaava taqovaro Kotira mwanraquravanto mwia nraaqiara mwuvaro mwiva nraaqiara tuaqama vura. ");
INSERT INTO omw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mwiva nraaqiara tuaqama viro varuvaro mwia vaativanto Iosepiva kyuqe vaisi ntapihi kyero nrohi varu vaisiva variqarora tiro, mwiva tiqaro, Nte nraakye qora suqaa Mariaara titaariro kyauruankyorave. Kyai mwia uqeta kyena titaariro quarive, tiro. ");
INSERT INTO omw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Iosepiva mwitaama riero vaitero ruvaata taqe varuvaro Kotiva tito vaisiva, nyaamwunyaava mpovanto qovarama viro tiqaro, Ntevitira mwaaquo, Iosepio, hia aatu hiqara Mariaara varaante. Kotira mwanraqura mwiva nraahu mwia nraaqiara mwiharo mwiva nraaqiara tuaqama viho. ");
INSERT INTO omw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I nraatavanto qoraisi nraaqiara mwata tairara e mwia nrutu nteqarama Iesusirave qiante. Iesusiva nraakye qora kyaahaqama nyatero mwihua uaqia hi kyaiqara uti quara nruka nyatero mwihua huvantu kyaaninranra tira, e mwia nrutu nteqara Iesusirave qiante, tura. ");
INSERT INTO omw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Haaru Kotiva nai poropeti vaisi nroqitairo timwa to quava qutaa vahiarive tiro, Kotiva tito vaisiva qovarama viro mwitaa tura. Haaru Kotira qua qovarama kye varuva, poropeti vaisivanto mwitaama tiro: ");
INSERT INTO omw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nraakiara hia qoraisivatama kyero nrohiari nraakyeva nraaqiara tuaqama viro nraaqiara mwataananrove. Mwihua mwianra Imaanuerivave tivarave, tura. Imaanuerira mwi nrutura okyara vahirero mwataamama vahiro: Kotiva tirivata varivave, tura. ");
INSERT INTO omw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iosepiva vaitoraqitairo siviro mwiva Kotiva tito vaisiva tu quara riero mwiva tunte hiro Mariaara uro varatero varurama. ");
INSERT INTO omw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mwiva hia Mariaaravata nrohuvaro Mariaava qati variqiro viro uro qoraisi nraaqiara mwata tovaro Iosepiva mwia nrutu nteqaro, Iesusivave, tura. ");
INSERT INTO omw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herotiva nronraqama viro varu entara Mariaava Vetarahemini Iutia mwataqaa variqaro Iesusira mwata tero. Mwiva mwia mwata tero varuvata vaisi mponramwuvanto mpo okyara mpo okyara taqo vaisinramwuhua huari nri ntora vevasaita Ierusaremini nri ntora. ");
INSERT INTO omw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mwinramwuhua nri nteta kyapara hita tiqata, Nraaqiara mpo Iutaaqa ntaqikyiani vaisira tanave mwata taiharo variho? Tirenramwu huari nri ntainani variqata mwia qovora taqeta mwia nrutu tuaaherarera nrunrahuave, tita. ");
INSERT INTO omw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mwinramwuhua mwitaa tuvaro Herotiva mwivavata mwi quara riero nrihanrama viro mwiva mwianra airi nraato tiqaro varura. Ekyaa Ierusaremini varuhuavata mwi quara rieta airi nraato tiqata varuvaro ");
INSERT INTO omw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herotiva vaisi nronranramwuanra aakyara ntero. Kotira kyaiqa vara mwate varu vaisinramwuhua vunyaahuave, mwaanra okyara ti varu vaisihuave, mwiva mwihuara aakyara ntovata nrita ntuvaantuama varuvaro Herotiva mwihua kyapara hiro tiqaro, Tanave Kotiva titairaro tumuani nraaqiarara Karaisira mwia nrova mwia mwata taani mwatava vaiho? tiro. ");
INSERT INTO omw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Herotiva mwitaa tuvata mwihua tiqata, Vetarahemi Iutia mwataqaave. Haaru Kotira qua qovarama kye varu vaisiva mwaa quara qara ntumwa tero tiqaro: ");
INSERT INTO omw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Vetarahemi Iutia mwataqaa vahiaravave. Nraakye qoravanto iara hia qumina mwatukyave tivarave. Iqitairo nronra vaisivanto qovarama quaninranra tita, nraakye qoravanto iara nrutu vataa mwatukyave tivarave. Iqitairo vunyaa vaisivanto qovarama viro mwiva Kotira nraakye qora Isareriqaa kyuqema kyero ntaqikyiqiro quaninrave, turave. Haaru poropeti vaisivanto mwitaa turara tita, tire. Karaisirara Vetarahemiqi mwata taananrove turo, tita. ");
INSERT INTO omw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mwihua mwitaa tuvaro Herotiva tuqeta kyero mpo okyara mpo okyara taqo vaisinramwuhua nruhua nyaanrama kyero tiqaro, Taireve qovora mwiva qovarama viho? tiro. ");
INSERT INTO omw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mwitaa tuvata mwinramwuhua Herotira timwa mwuvaro riero mwiva mwinramwuhua Vetarahemini sitero tiqaro, Nkyenramwu uqinrakye mwi nraaqiarara puaa hirerata quate. Nkyenramwu mwia puaama kye taqetama vaakyama nivata nrumu timwa mpivaqe ntevata uro nraaqiara mwia nrutu tuaahera mwataankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Herotiva mwitaa tuvata mwihua aanraqaa vi varuvaro qovoravanto vaakya mwihua huarivanto nri ntonani variqata taqova mwihua vuni mwiva nraante vuva uro nraaqiara mwiva varuraqa ra kyero mwiaqa vahura. ");
INSERT INTO omw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mwiaqaa vahuvata mwihua qovora mwia taqeta mpoqama kyeta qamwatora. ");
INSERT INTO omw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mwinramwuhua nraamwuqi vera nteta taqovaro nraaqiara mwiva nai nronra Mariaakyantiri varuvata mwihua taqetama mwatasata tori kyauru ravi variqata mwia nrutu tuaahereqatama mwia qamwata mwateta. Mwihua qamwata mwateta mwiaqaataita mpo inraikya mpo inraikya tuaqitai ohi kyeta koriqo ututo inraikyarave, munra kyuqe mwunta quani inraikyarave, vahamwenra kyuqerave, ohi kyeta mwatora. ");
INSERT INTO omw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mwia mwi kyeta varita vaite varuvaro Kotiva ruvaatakyaa mwihua timwa nyinro tiqaro, Hia Herotira uro timwa mwiate, tuvata mwihua sivita mpo aanraqaamateta nkyiari mwaatanianra nrumu ntanteta vurama. ");
INSERT INTO omw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mwihua vuvaro Iosepiva vaite varuvaro Kotiva tito vaisiva qovarama viro ruvaatakyaa mwia timwa mwinro tiqaro, Sivira ena nrahesi nraaqiaravata sitera Isipini aatu quante. Mwini uro variraqe nte qakyo uro mponanre qianinra riaante. Herotiva i nraaqiara puaama kyero ru kyarero uti variho, tiro. ");
INSERT INTO omw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mwitaa tuvaro Iosepiva siviro entaqi nraahu nai nraaqiaravata nai nraatavata sita varero Isipinianra vuva uro mwini ");
INSERT INTO omw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","variqiro vi varuvaro Herotiva qutu vurama. Herotiva qutu vuvaro mwiaqaatairo haaru Kotira qua qovarama kye varu vaisiva tu quava qutaa vahurama. Haaru mwiva Kotiva mwataama tiho tiro: Nte Isipisaina ntena maaqu nraanraanrinro mwiva nriananrove, tura. ");
INSERT INTO omw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herotiva variqaro taqovata huari vu nri ntonanyaa vaisinramwu mwia qua nteqakye hia mwia timwa mwinraitita, vuvaro mwia mpoqama kyero raraqa tovaro variqaro uro mpo hu vaisihua sitero tiqaro, Ekyaa qoraisi nraaqiara taara ihi varaahuave, hia taara ihi varaahuave, Vetarahemini variahuavata, mwia vara ututu variahuavata, ekyaa ru taiqa kyaate, tiro. Mwiva qovoravanto qovarama vu entara huari vu nri ntonanyaahua timwa mwito quara rieqaro taara ihi varehuavata, hia taara ihi varehuavata, ru taiqa kyaate, tura. ");
INSERT INTO omw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mwihua ru taiqa kyaate tuvaro haaru Kotiva poropeti vaisi Ieremaiaara nroqitairo tu quava mwivauma vahiro. Mwataama tiro: ");
INSERT INTO omw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramaa mwatukyaqitairo nronraqama kyero ntate variani quara nraakye qora rievarave. Tiri taatova Reseriva nai nraisiara ntate variananrove. Mwia nraisi ekyaa qutu virara tiro, mwia mwutukya qihaakya hiariva hia variraro mwiva nronraqama kyero ntate variananrove, tura. ");
INSERT INTO omw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herotiva variro qutu vuvaro Iosepiva Isipini varuvaro Kotiva titova qaiqaa qovarama viro Iosepira ruvaatakyaa ");
INSERT INTO omw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","timwa mwinro tiqaro, Sivira nraaqiaravata, mwia nronravata, sita varera Isareri mwata Iutiaani nrumu ntantera quante. I nraaqiara ru kyarera hiahua qutu quavo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mwitaa tuvaro Iosepiva siviro nraaqiaravata, mwia nronravata, sita varero Isarerinianra viro. ");
INSERT INTO omw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mwiva mwinianra viqaro riovaro Akerausiva nai qora Herotira mwaata varero Iutiaqaa ntaqikyi varuvaro Iosepiva mwini quaro tiro aatuma kyero varuvaro Kotiva ruvaatakyaa qaiqaa timwa mwuvaro mwiva hia Iutiaani virairo qaqira kyero ");
INSERT INTO omw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Karirini uro mwatukya mpo Nasaretini nai nrahesi nraaqiaravata varura. Nasaretini uro varuvaro haaru Kotiva nai poropeti vaisinramwu nroqitairo tu quava qutaa vahiro. Mwi quava Iesusirara mwataama tiro: Nraakye qoravanto mwianra Nasaretinyaa vaisive tivarave, tura. ");
INSERT INTO omw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mwi entara Ioniva nramanri nyi varu vaisiva nri ntero Iutiaani qumina mwataqa variqaro nraakye qora timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nkye uaqia hi kyaiqara uti varira qaqira kyaate. Kotiva nraakye qoraqaa ntaqikyiari entava qaumatoma vaiho, tura. ");
INSERT INTO omw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Haaru Ioniva hia varu entara Aisaiaava poropeti vaisivanto variqaro mwi vaisiva qovarama quananrove tura. Aisaiaava Ioninranra mwataama tiro: Mwiva qumina mwatani variro aakyara ntero tiqaro, Nronravanto quani aanranra terama mwateta mwia aanra avuqavuma mwataivaro mwiva mwivauma qio quarive qiananrove, tura. ");
INSERT INTO omw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioniva tuavaaqa ututova vahirero kameri quara mwia kyaahi nraahu vara kyero ututero reti tavaarana rupa tora. Mwiva hia kyara vara tu kyero nranraitiro, mwiva kainyaaqavata, voravanto kuruto nramanrinravata, nraahu nreqanro varura. ");
INSERT INTO omw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ioniva qua timwa nyi varuvata nraakye qora Ierusaremisaitave, ekyaa Iutiasaitave, Iotaani nramanri tokya hini hini varuhuave, mwihua hisai hisai ntuvaantuama vita ");
INSERT INTO omw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","nkyiari qora kyaiqa varora timwa qovarama kyovaro Ioniva Iotaani nramanriqi variqaro nramanri nyi varura. ");
INSERT INTO omw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ioniva variqaro taqovata Parisivantovata, Saitiusivantovata, nramanri vararerata mwiva hunani nruvaro mwiva mwihuara tiqaro, Nkye quaiha nraaqiaravantoma variavo. Kotiva nraakye qora rirera uti varihata tava nkyiara aatu ntuqema kyeta quate tihatave nkye mwaini nte hunani nriavo? ");
INSERT INTO omw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nkye qutaaqama kyeta uaqia hi kyaiqara qaqira kyarerata uti varivera, nkye kyuqe kyaiqa varaivaqe tire taqaare. ");
INSERT INTO omw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nkye hia nkyeta vaitutu hira qua tiqata, Evarahaamuva tiri tiqova varihatara tita, tire qio varuro, qiate. Kotiva qiove tirera, ori mwaanramwuhua vaisi tuemwa vita Evarahaamunra nraisi varivarave. ");
INSERT INTO omw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kotiva kyatari teqa kyarero kyaari okyaraqi terama taiho. Hia kyuqe tamwa riaaninra mwiva teqaaqama kyero kyairaro qiama itamwa kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nkye uaqia hi aanranra qaqira kyeta kyuqe hiani aanranraqaa nraahu virerata utuavana nte qumina nramanri nkyi nyi varuqo. Ni naakiara nrianriva Kotira mwanraqura nkyi nyiananrove. Mwiva qia itaaninra votihira nkyi nyiananrove. Mwiva nronravanto ni naatara kyaariva nriananrove. Nte qumina vaisi variqananra tina, nte hia qio mwia kyuqu nraamwu varaqina uro mwianinrave. ");
INSERT INTO omw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mwiva nai kyavoi kyauquqi tu varero kyakuma voti hira ntitata hirero uro ntero ntitatama kyero nronra nraahu nai kyavoiqotairo vaqitaqiro uro nai nraamwuqi vatero qumina kyapivata mwanrevata vaqitaqiro uro hia qipa quani qiaraqi tuto kyairaro itamwa kyaananrove, tiro. Ioniva mwi quara turama. ");
INSERT INTO omw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ioniva nramanri nyi varuvaro mwi entara Iesusiva Karirisairo Ioniva mwia nramanri mwianrive tiro, mwiva varura Iotaani nramanriqi viro. ");
INSERT INTO omw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mwiva mwini uro ntovaro Ioniva Iesusirara tiqaro, Qaqao, e nramanri ni mpiataara vaiharama e nianra nramanri ni mpiante ti variaro, tiro. ");
INSERT INTO omw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ioniva mwitaa tuvaro Iesusiva nai timwa mwinro tiqaro, Mate qati kyera nramanri nraahu ni mpiante. Kotiva avuqavu hi quara timwa taira, mwi quara tiretana riemwaqita virerave, tiro. Mwitaa tuvaro Ioniva eo timwa kyero Iesusira nramanri mwinro. ");
INSERT INTO omw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nramanri mwuvaro Iesusiva nramanriqitairo qatinani mwaanri ntovaro mate mwiqiara nyaamwuvanto qatua vuvaro Ioniva taqovaro Kotira mwanraquravanto nyaamwa minrunra voti huva tuminro Iesusiraqaa varuvaro ");
INSERT INTO omw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","nyaamwusairo quavanto tiqaro, Mwaa ni maaquve. Ni mutukyavanto mpoqama kyero mwianra vaiho. Nte mwianra qamwateqanama varuqo, tiro. Tura. ");
INSERT INTO omw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iesusiva nramanri varovaro Saataaniva mwia mwataara hiarive tiro, Kotira mwanraquravanto Iesusira vitaqiro uro hia vaisivata varura quminasata kyora. ");
INSERT INTO omw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kyovaro Iesusiva mwini 40 entara variqaro hia kyaravata nrovaro kyara nraataa huvaro varura. ");
INSERT INTO omw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kyara nraataa huvaro varuvaro Saataaniva nri ntero Iesusirara tiqaro, E qutaa Kotira mwaaquvanto varirera, ori mwaanramwunranra tiraro mpereti tuemwa virara nraante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mwitaa tuvaro Iesusiva mwia nai timwa mwinro tiqaro, Qaqao, Kotira mpukuqi vahi quava tiqaro, Vaisivanto kyara nraaninranra nraahu riemwaqiro quariva hia qio qati variqiro quananrove. Mwiva ekyaa Kotira nroqitairo qiani quara riemwaqiro viqaro qioma qati variqiro quananrove, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Iesusiva mwitaa tuvaro Saataaniva mwia vitaqiro Ierusaremini Kotira nraamwu qiata nai verani vahuraqa uro kyero mwiaqaa mwia mwaamwianrama tero ");
INSERT INTO omw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tiqaro, E qutaaqama kyera Kotira mwaaquvanto varirera, mwaaqaataira mpua mwatani hatohira quante. Kotira mpukuqi vahi quava tiqaro, Kotiva iara rieqaro mwiva tirata nyaamwunyaahua iqaa kyuqema kyeta ntaqikyivarave, turave. E ena kyuqu oriqa ntuteqa kyerorave tita, nyaamwunyaahua nkyiari kyauquqo i tu vareta vivarave, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Saataaniva mwitaa tuvaro Iesusiva mwia nai timwa mwinro tiqaro, Qaqao, Kotira mpukuqi qua mpo vahiva tiqaro, Nronravanto i mwanriqavanto varirara tira, e hia mwia mwataara hiante, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iesusiva mwitaa tuvaro Saataaniva mwia vitaqiro uro taaqi nritarora qiataqaa kyero ekyaa vunyaa vaisivanto nkyiari mwata mpoqaa mpoqaa ntaqikyura ekyaa mwi mwata maatara mwia kepukya inraikya rirante nraamwutero tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","E ni kyuqu tarani tumu ntira variqara ni nutu nraahu tuaahera matairera, nte ekyaa mwi inraikyara i mwianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mwitaa tuvaro Iesusiva nai timwa mwinro tiqaro, Qaqao, Saataanio, hiante quante, Kotira mpukuqi vahi quava tiqaro, Mwanriqavanto Kotiva nronravanto varirara tira, e mwia nrutu nraahu tuaahereqara mwia kyaiqa nraahu varaqira quante turave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iesusiva mwitaa tuvaro Saataaniva mwia mwini kyero vuvata nyaamwunyaahua tumu Iesusira kyaahaqa hura. ");
INSERT INTO omw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iesusiva riovata Ioninra ntavaaqavu kyeta karavuqi kyaavaro variho tuvaro riero, Iesusiva nrumu ntantero Karirini vura. ");
INSERT INTO omw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mwiva mwini vuva hia uro Nasareti nai mwaatani variraitiro, uro Kapenaamini variqiro vura. Kapenaami mwiva Kariri kyaarera tokyasataa vahura. Mwi mwatava vahirero Sepiuraaninravata, Napatarairavata mwata vahura. ");
INSERT INTO omw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iesusiva mwini uro varuvaro haaru Aisaiaava Kotira qua qovarama kyo quava qutaa mwivau vahura. Aisaiaava haaru mwataama tiro: ");
INSERT INTO omw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Nte Sepiuraaninra mwataravata, Napataraira mwataravata, tirerave. Mwi mwatava kyaarera tokyani vahirave. Iotaani nramanri vaiharo mwi mwatava uromwi vaihata mwi mwataraqa Kariri mwataqa mpo mwatanaa mpo mwatanaahua variarave. ");
INSERT INTO omw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mwihua kyokiraqi variqita vita, mwiaqaataita omwavanto nronraqama kyero itaaninra taqevarave. Mwihua kyokiraqi variavaro qutu qua okyarava mwihua ntumwaqu kyaihata variavaro mwiaqaatairo omwavanto ntuvaahama nyatarero uti varirave, tura. ");
INSERT INTO omw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mwi entaraqaatairo Iesusiva nai kyaiqa toharama kyero nraakye qora timwa nyiqiro viro tiqaro, Kotiva nraakye qoraqaa ntaqikyiariva qaumato vahirara tita, nkye uaqia hi aanranra qaqira kyaate, tiro. Turama. ");
INSERT INTO omw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesusiva Kariri kyaarera tokyasataa viqaro taqovata qate vakye taaratana varura. Vakyaava Saimoniva mwia mpo nrutu Pitaava varuvaro mwia qatavanto Enturuva varura. Mwitanahua tavukya kyaiqa vare varuhua variqatara tita, mwitanahua nramanriqi vahe nte varura. ");
INSERT INTO omw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mwitanahua vahe nte varuvaro Iesusiva mwitanahuara tiqaro, Nkyetana ni naakiara ni pataqita nriate. Nkye tavukya vahe ntamwa kyeta varaantema kyetama nkyetana ni pataqita nrivaqena nte nkyi nyaamwutaarita nkye vaisi sitevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mwitaa tuvata mate mwiqiara mwitanahua nkyiari vahe mwini kyeta Iesusira vataqita vurama. ");
INSERT INTO omw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mwitanahua mwia vataqita vuvaro Iesusiva pataqia viqaro taqovata vaisi mpotana Sepetira mwaaqutana Iemisivavata mwia qata Ionivavata varura. Mwitanahua mpotuqi variqata nkyiari sora Sepetiravatama kyeta vahe terahi varuvaro Iesusiva mwitanahua nyaanrama kyovata ");
INSERT INTO omw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","mwitanahua mate mwiqiara nkyiari mpotuvata nkyiari soravata mwini kyeta Iesusira vataqita vurama. ");
INSERT INTO omw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesusiva Karirini mpo mwatukya mpo mwatukya nrohiqaro mwaanra nraamwuqi vera ntero variqaro mwakyaakya timwa nyiqanro Kotiva nraakye qoraqa ntaqikyiani quara, kyuqe qua timwa nyiqiro vi varuvata tauma rumpuara utuhuave, nriqa vuhuave, mwihua varuvaro Iesusiva mwihua kyuqema kyovata qio varura. ");
INSERT INTO omw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Iesusiva mwitaamaqiro vi varuvaro mwia quavanto ekyaa Siriaani vuvata mwi mwatanaahua nkyiari nraakye qoraqa mpo qara mpo qarama kyero nriqa vuhua, tauma rumpuara utuhuave, nronraqama kyero nriqa vuhuave, vaana kyapata varuhuave, mwamwanta ntirintiri hi varuhuave, hini mwamwanta qutu vu vaisihuave, mwihua mwihua ekyaa sitaqita Iesusiva hunani uro kyovaro mwiva mwihua kyuqema kyovata qio varura. ");
INSERT INTO omw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iesusiva aanrani vi varuvata nraakye qora airivanto mwia vataqita vi varura. Karirisairove, Ntekaporisi mwatukyanramwuqitairove, Ierusaremisairove, Iutiasairove, Iotaani nramanri qarahi hisataasairove, nraakye qoravanto hisai hisaita ntuvaantuama vita mwia vataqita vura. ");
INSERT INTO omw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesusiva variqaro taqovata airi nraakye qora ntuvaantuama vita varuvaro mwiva taaqiqaa uro mwatakyaa viro varuvata mwia nraaqiaranramwuvata mwiva varunani uro varuvaro ");
INSERT INTO omw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Iesusiva mwakyaakya tohara tero mwiva nai nraaqiaranramwu timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nte Kotiva hi inraikyarara vehiqamama varuqo ti vari nraakye qorahua mwihua varivaro Kotiva mwihuama kyuqema nyataananrove. Kotiva mwihuaqa ntaqikyiqiro vi varirata mwihua mwia nraakye qorama varivarave. ");
INSERT INTO omw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mwutukya uaqia hirata ntate varihua, mwihua varivaro Kotiva mwihuama kyuqema nyataananrove. Kotiva mwihua mwutukya qihaakyama nyataananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tirema variqata hia nkyiarivata uaqiama nyaterara riehua varivaro Kotiva mwihua kyuqema nyataananrove. Kotiva mwaa mwatara mwihua kyaama tairara tita, mwihua mwia varevarave. ");
INSERT INTO omw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ntapihi kye nrohi okyarara kyakya hiarihua, mwihua varivaro Kotiva mwihua kyuqema nyatero mwi okyararaqo mwihua qioqama nyataananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mpohuara po kye ti nraakye qorahua, mwihua varivaro Kotiva mwihua kyuqema nyatero mwihuara po kye timwa nyataananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Qutaaqama kye Kotira nraahu vataqi vihua, mwihua varivaro Kotiva mwihuama kyuqema nyataananrove. Mwi nraakye qorahuama Kotira taqevarave. ");
INSERT INTO omw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ntaqirera hivata vaitutu hi vari nraakye qorahua, mwihua varivaro Kotiva mwihua kyuqema nyataananrove. Kotiva mwihuara ni nraaqiarave tiratama varivarave. ");
INSERT INTO omw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kotirara rieqata ntapihi kye nrohi varivata mwia kyaara mwihua uaqiama nyate vari nraakye qorahua, mwihua varivaro Kotiva mwihua kyuqema nyataananrove. Kotiva mwihuaqa ntaqikyiqiro vi varirata mwihua mwia nraakye qorama varivarave. ");
INSERT INTO omw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nkye ni pataqi vi varivata mwia kyaara nkyiara uaqia hi quara timwaqi vita, nkyi uaqiama nyateta, nkyiara mpo qua mpo qua unra quave, uaqia hi quarave, nkyiara timwaqi vi varivata, nkye ni pataqi vi varivaro Kotiva nkyi kyuqema nyataananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nkyi uaqiama nyataantema kyeta haaruvata vaisi mpo uhua Kotira qua qovara hu vaisihua uaqiama nyatorave. Nkyi mwitaama kyeta uaqiama nyataivata nkye qamwateqa variate. Kotiva nkyi kyaiqa kyuqe kyaiqara rieqaro mwia qiata nyaamwuni kyuqe inraikya nkyini terama tairave. ");
INSERT INTO omw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Mwaa mwataraqa nraakye qora variavata nkye mwihua utaqaa variqata nkye hore votima kyeta variavo. Horevanto uaqiama viro hia qiakyaa hirera, hia qio qaiqaa utu kyairaro qiakyaa hiananrove. Horevanto uaqiama virera, qio uaqiama virave timwa kyeta mwia qaqira kyaivata nraakye qoravanto mwiaqaa ntamwaqita vivarave. ");
INSERT INTO omw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mwaa mwataraqa nraakye qora variavata nkye omwavanto itaintema kyeta variavo. Mwatukya mpovanto taaqiqaa vahiariva hia uqeta vahiananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hia mpovanto omwa qupi kyero tave vara kyero mwia ntumwaqu tairave. Qaqao, nraamwuqi variahuavata ekyaa taqaate tiro, omwa qupi kyero virira nyaamwuni hiritairave. ");
INSERT INTO omw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nkye mwia votima kyeta nraakye qora suqaa qoqaa nrohiqata omwavanto itaintema kyeta variqita vivata mwihua nkye kyuqe kyaiqa vare varira taqeta, nkyi sova nyaamwuni varira mwia nrutu tuaaheraqita quate. ");
INSERT INTO omw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nkye nianra tiqata, Mosesiva timwato quaravata, poropeti vaisinramwuvanto timwato quaravata, vara qaqira kyarero nrivave, tivorave. Nkye nianra mwitaama kyeta nraato rievora. Hia nte mwihua qua qaqira taiqa kyarerave. Mwi quava qutaa mwivau vahiarive tina, ntevata nruvave. ");
INSERT INTO omw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nte nkyi timwa nyianinra riaate. Nyaamwuvantovata mwatavantovata taiqa viraro ekyaa mwaanra qua mwiva qati nraahu vahiqiro quananrove. Mwi quaraqitairo ekyaa quave pata uapaa qua mwi quavavata vahiqiro viraro ekyaa inraikyavanto qovarama quananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mosesivavata poropeti vaisinramwuvantovata timwato quava vaiharo mpovanto mwi quaraqitairo pata uaqia nteqa kyero mpohuaravata tiqaro, Nkye mwi quara pata uaqia vahira qioma nteqa kyevarave, tirera, mwi vaisiva variro nyaamwuni Kotiva ntaqikyianinrani viraro Kotiva mwi vaisirara, E ni nraaqiara mwatumwi mpiato nraahu variaravama variaro, qiananrove. Vaisi mpovanto Mosesira quavata poropeti vaisi quavata riemwaqiro viqaro mpohuaravata mwi quara riemwaqita quate tirera, mwi vaisiva variro nyaamwuni Kotiva ntaqikyiani mwatukyarani viraro Kotiva mwianra, E ni nraaqiara nritarera virito variaravama variaro, qiananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nte nkyi timwa nyinrenrave. Parisi vaisinramwuvata, mwaanra okyara qia vaisinramwuhuavata, mwihua nkyiari riemwa kyeta tiqata, Tire Kotira qua rieqata ntapihi kye nrohi varuro, ti variarave. Nkye hia mwihua nraatara kyeta kyuqe aanraqaa vivera, nkye Kotiva ntaqikyiani mwatukyaraqi hia qio vivarave. ");
INSERT INTO omw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Haaru Mosesiva nkyi haivaqahuara timwato quara nkye mwi quara riaarave. Mwataama tiro: Hia mpora ru kyaante. Mpora ru kyaari vaisiva, mwiva quaqaa variananrove, turave. ");
INSERT INTO omw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mwiva mwitaa tura kyai nte qaiqaa nkyi timwa nyianri. Nai qata vakyaara raraqa taariva, mwi vaisivavata mpora ru kyaiva quaqaa varintema kyero quaqaa variananrove. Nte qaiqaavata nkyi timwa nyinrenrave. Nai qata vakyaara mwaaquvantove qiani vaisira mwia vitaqira uro nronra kaanasorinramwuvanto varinani kyairaro mwiva qua varaarive. Nai qata vakyaara e uera vaisivanto hia vu nraatovata vahivave qiari vaisiva, mwivavata mpora ru kyero qua varaintema kyero qua varairaro mwia uro qutu quahua vi mwatara qiaqi tuto kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mwi quara rieqarama e mwaanra nraamwu nronraqi variqara mpo inraikya Kotira mwinra mwia qamwata mwatarera hira taqairaro i qata vakyaa mpovanto iqaa qua vataariva qati vahirera, ");
INSERT INTO omw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Kotira mwinrenra hina inraikyara mwiaqaa qati vatera, uro ena qata vakyaa mwiavata variqara mwi quara nraante timwa ntapihi kyera mwiaqaataira uro mwi inraikyara Kotira mwiqanra qamwata mwataante. ");
INSERT INTO omw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mpovanto iqaa qua vatarero i vita varero ko nraamwuqiara virara mwikyantiri aanrani viqarama qamwanrama kyerama mwi quara ntapihi kyaante. E hia mwitaa hiraitira, ko nraamwuqi viraro ko rie vari vaisiva iqaa qua vatero pipo titairaro i vitaqiro uro karavuqi kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nte qutaa qianinra riaante. E karavuqi variqira vira karavu kyoqaa hiqara hia ekyaa mwi munimanra kyairaro hia qio i qamwanrama titairara vinanrave, tiro. Iesusiva mwi quara turama. ");
INSERT INTO omw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Iesusiva mwitaa timwa kyero mwiva mwihua timwa nyinro tiqaro, Haaru Mosesiva timwato quara mpo qua nkye riaarave. Mwi quava mwataama tiro: Hia mpora nraatavata mpora vaativata api nrohiante, turave. ");
INSERT INTO omw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kyai nte qaiqaa nkyi timwa nyiankye. Vaisivanto nraakye taqero nai nraatoqitairo nraahu riero, Nte mwiavata nrohina variataarave, qianinranra Kotiva tiqaro, E vaakyama nraata vaati ntuqema kyera hiaro, timwa kyero mwi vaisiraqaa qua vataananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mwianra rieqara e kyaatutanyaa vuqotaira taqe variqara uaqia hi kyaiqara uti varirera, qaiqaavata mwitaamaqina quankyo tira, mwia vauru kyera qaqira kyaante. E vu kuaiku nraahu vahirara hia uaqia hi kyaiqara utiraitira, nyaamwuni qioma vinanrave. E vu taaratana vahiariva uaqia hi kyaiqara utuqira vira nraakiara qutu viraro i qia nronra itaaninraqi tuto kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","E kyauqu kyaatutaqotaira uaqia hi kyaiqara uti varirera, e mwitaamaqina quankyo tira, mwia teqa kyera qaqira kyaante. E kyauqu kuaiku vahiariva hia uaqia hi kyaiqara utiraitira, nyaamwuni qioma vinanrave. E kyauqu taaratana vahiariva uaqia hi kyaiqara utuqira viraro i qia nronra itaaninraqi tuto kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Haaru Mosesiva timwato quava mwataama tiro: Vaisivanto nai nraata qaqira kyarero hiqaro nai nraata qara mpo mwinro, Nte mwia qaqirama kyauqo, timwa kyero qara mwiananrove, turave. ");
INSERT INTO omw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kyai nte qaiqaa nkyi timwa nyiankye. Mwia nraatavanto hia mpo vaisintiri api nrohiraitiro variraro mwia vaativanto mwia qaqira kyairaro mwia nraatavanto vaisi kyaata varairera, Kotiva mwitaama qiananro: Mwi nraakyeva qaraakya vaisintiri nrohiqaro nraata vaati ntuqema kyaihoma qiananrove. Mwia vaati hoqarenaava mwia qaqira kyaiharo mwia kyaara mwitaa iho. Mwitaa ihana nte mwia vaati i tauraanaanraqa qua vatena qaraakya vaati mwiaqaavata qua vataaninrave, qiananrove, tiro. Iesusiva mwi quara turama. ");
INSERT INTO omw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Iesusiva mwitaa timwa kyero mwiva qua timwa nyiqiro viro tiqaro, Haaru Mosesiva qua mpo nkyi haivaqahuara timwato quara nkye mwi quaravata ntapihi kyaarave. Mwataama tiro: E kyauqu nriqiqaa vatera tiqara, Kotira vuqaa variqanama nte qutaama mwitaa hirerave, tina quara nteqa kyerorave. Kotira nrutu nteqara timwa tena quarara rieqara varaante, turave. ");
INSERT INTO omw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kyai nte qaiqaa nkyi timwa nyiankye. Kyauqu nriqiqaa vateqata, tire qutaa mwitaa hirerave, tiqatama hia Kotira nrutu nteqata mwitaa qiate. Hia mpo inraikya mpo inraikya nrutu nteqata, Tire qutaa mwitaa hirerave, qiate. Kotiva nyaamwuni mwatakyaa viro varirara tita, mwianra rieqatama hia nyaamwu nrutu nteqatama, Tire qutaa mwitaa hirerave, qiate. ");
INSERT INTO omw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kotiva nai kyuqu tutu kyero mwaa mwataraqaa mpiami vatero varirara tita, mwianra rieqatama hia mwaa mwatara nrutu nteqata, Tire qutaa mwitaa hirerave, qiate. Ierusaremivanto nronra vunyaa vaisivanto variari mwatukyava vahirara tita, mwianra rieqatama hia mwi mwatukyara nrutu nteqatama, Tire qutaa mwitaa hirerave, qiate. ");
INSERT INTO omw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hia nkyeta qiata nrutu nteqata, Tire qutaa mwitaa hirerave, qiate. Nkye hia qio nkyeta qiata kyaahiara, Eqara kyaahive, upi kyaahive, vahiante tivarave. Nkye hia qio mwitaa tirara tita, nkye qumina nkyeta qiata nrutu nteqata, Tire mwitaa hirerave, tivorave. ");
INSERT INTO omw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nkye variqata mwitaa hirerave tivera, nkye qati eo nraahu tiqatama mwitaa hiata. Hia mwitaa hivera, qati hiave nraahu qiata. Hia mpo qua mpo quanti qiate. Mpo qua mpo quavanto Saataaninraqaatairo qovara hiananrove, tiro. Iesusiva mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Iesusiva mwitaa timwa kyero timwa nyiqiro viro tiqaro: Mosesiva qua mpo timwatora nkyevata riaarave. Mwataama tiro: Mpovanto i vu vauru kyairara, e nai vuvata qioma vauru kyenanrave. Mpovanto i vai ntuvihau kyairera, e nai vaivata qioma ntuvihau kyenanrave, turave. ");
INSERT INTO omw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mwi quara vaihana kyai nte nkyi qaiqaa timwa nyiankye. Uaqia hiari vaisiva mpovanto nkyi uaqiama nyatairerata hiama nkye nai uaqiama mwataate. Mpovanto i nraatokyai ntuteqa kyairera, hia nai ntuqutiraitira, mwia qaqira kyairaro hini nraatokyaivata ntuteqa kyaarive. ");
INSERT INTO omw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mpovanto i sioti vararero i vita varero ko nraamwuqi uro kyarero uti varirera, ena sioti mwiqanrama kyairaro i vaaqatuavata varaarive. ");
INSERT INTO omw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mpovanto i antua kyero, Nte hu inraikyara quqira vaini mpona uro mataante, tirera, vara quqira uro nyianrani mwataante. ");
INSERT INTO omw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mpovanto mpo inraikyara i kyapara hirera, mwia mwiante. Mpovanto iara mpo inraikya mpiraqe qakyo varaqina nrumu ina mwiankye tirera, eo tira mwia mwiante, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Iesusiva mwitaa timwa kyero timwa nyiqiro viro tiqaro: Haaru nkyi haivaqahua tu quara nkye riaarave. Mwihua mwataa turave: Ina nramwunaanranra nraahu i mwutukyavanto vahiarive. Nramwutaara uaqiama mwatena vu nraatova vahiarive, turave. ");
INSERT INTO omw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kyai nte qaiqaa nkyi timwa nyiankye. Nkyeta nramwutaa mwihuara nkyi mwutukya vahirata variate. Nkyi uaqiama nyatehuara Kotira kyapara hivaro mwiva mwihua kyaahaqama nyataarive. ");
INSERT INTO omw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nkye mwitaa hiqatama nkye nkyi sova nyaamwuni varira mwia nraaqiarama varivarave. Kotiva tiharo huarivanto kyuqe vaisiqaa itero uaqia hia vaisihuaqaa itairave. Kotiva vati vara kyaiharo vativanto ntapihi kyeta nrohi varia vaisihuaqi tumihanro hia ntapihi kyeta nrohi varia vaisihuaqivata tuminrave. (Nkyevata nkyeta sova hintema kyeta kyuqe vaisiaravata qora vaisiaravata kyuqemaqita quate.) ");
INSERT INTO omw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nkyiara mwutukya vahiarihuara nraahu nkyi mwutukya vahirera, Kotiva nanra inraikyara rieqarove nkyi kyuqema nyataananro? Taakisi vare variahua mwihua hia kyuqe vaisi variqatavata mwihua nkyiari hena vaisiara mwutukya vaihata variarave. ");
INSERT INTO omw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nkye nkyeta nramwunaahua nraahu qua mwanteta kyauqu nyivera, nkye nanra kyuqe inraikyaqove Kotira qua hia riaahua nraatara kyevara? Nkye mwihua votima kyeta nraahuma varivarave. ");
INSERT INTO omw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nkyi sova nyaamwuni variva, mwiva hia uaqia hi kyaiqara utiraitiro, avuqavuma kyero nrohi varivave. Nkye mwia votima kyeta avuqavuma kyeta nrohiqata variqita quate tuqo, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iesusiva mwitaa timwa kyero mwihua timwa nyiqiro viro tiqaro, Nkye mpohuara kyuqe hirerata, uqeta kyeta mwihua kyaahaqama nyataate. Hia qoqaa tiri mwahuta qiate tita mpohua kyaahaqama nyataate. Nkye vaisivanto taqaate tita, mpohua kyaahaqama nyataivera, nkyi sova nyaamwuni variva mwiva hia mwianra rieqaro nkyi mpo inraikya nyiananrove. ");
INSERT INTO omw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","E mpovanto mwi quara rieqara mpo inraikya vehi vaisi mwinrenra hiqara uqeta kyera mwiante. Hia nraakye qora suqaa nronraqama kyera aakyaraqitaira nraanrama kyera mwiante. Mpo vaisinramwuvanto kumwaanriqama kyeqata kyuqe kyaiqa vare variahua, mwihua mwaanra nraamwuqi variqatave, aanrani viqatave, nraakye qora suqaa nronraqama kyeta ntoma vuateqata nyaanrama kyeqata vehi nraakye qora munima nyi variarave. Mwihua hia vehi nraakye qora mwihuara nronraqama kyeta rieqata mwitaa hiavo. Mwihua tiri mwahuta qiate tiqata mwitaa hiarave. Nte nkyi timwa nyuqo. Mwihua nraakye qoravanto mwahuta timwa nyataavata vaakyama nkyiari kyoqaa vara kyaavo. ");
INSERT INTO omw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","E mpovanto munimave, mpo inraikyave, vehi vaisi mwinrenra hiqara uqeta kyera mwiante. I nraaqani variarivavata hia mwia mwinanra taqaarive. ");
INSERT INTO omw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","E mwitaa hiraro mwi inraikyava uqeta kyero vahiarive. Mwitaa hiraro i qova ekyaa uqeta vare varia kyaiqara taqe variva, mwiva mwianra rieqaro i kyuqema mwataananrove. ");
INSERT INTO omw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nkye Kotiravata qua tirerata kumwaanriqama kyeta kyuqe kyaiqa vare variahua hia mwihua hiante hiate. Mwihua mwahuta tirara qamwateqata mwihua mwaanra nraamwuqive, nraakye qora ntuvaantuama vita varia aanranraqaave, variqata Kotirara aakyara nte variarave. Nte qianinra riaate. Mwihua nraakye qoravanto mwahuta timwa nyataavata vaakyama nkyiari kyoqaa vara kyaavo. ");
INSERT INTO omw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","E mpovanto ena qora Kotiravata qua tirera enanraa varirera ena nraamwuqi vera ntera qesa tita tera uqeta kyera i qova uqeta varira vatama kyera qua qiante. E mwitaa hiraro i qova ekyaa uqeta vare varia kyaiqara taqe variva, mwiva i kyuqema mwataananrove. ");
INSERT INTO omw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nkye Kotiravata qua tiqata hia qumina airi qua ntikara qiate. Mpo mwatanaahua hia Kotira qua riaa nraakye qorahua mwitaa ti variarave. Nkyevata mwihua hiante hivorave. Mwihua tiqata, Qaiqaavata qaiqaavata qumina qua qiararo tiri mwanriqavanto tiri qua qio riaananrove, qiarave. ");
INSERT INTO omw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nkye hia mwihua nraantantaate. Nkye hia Kotirara ntumwa hiamwa hia entara Kotiva vaakya nkye ekyaa inraikyara aara ntaara ntapihi kyaiho. ");
INSERT INTO omw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nkye qio mwataama kyeqata Kotiravata qua qiate: Tiri tiqova, e nyaamwuni variaravave. Tire kyuqema kyeta i nrutu kyuqera tuaaherauro. ");
INSERT INTO omw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","E tiriqaa ntaqikyina entava qamwanrama nrianrive. Nyaamwunyaahua i kyakya hira vataqi quantema kyera e tiri kyaahaqa hiraqe tire mwatani variarahuavata i kyakya hira vataqi quare. ");
INSERT INTO omw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tire mate kyara nraananra tiri timwiante. ");
INSERT INTO omw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tiri apiqama timwa taavata tire mwi quara qaqira kyaurantema kyera tire i apiqama mwatauna quara nruka timwa taante. ");
INSERT INTO omw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Uaqia hi kyaiqava tiri mwataara hiankyo tira, e tiri tivita vare viraqe tire kyuqe hi aanranraqaa quare. E tiri kyaahaqa hi variraro Saataaniva hia tiri uaqiama timwataarive. E vunyaava kepukyaqama kyera ntaqikyi variaravave. I nrutu nraahu tuaaheraqi quararo i nrutuvanto qati nraahu vahiqiro quananrove. Qutaave. Mwitaa timwa kyeqata Kotiravata qua qiate, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mwitaa timwa kyero Iesusiva mwihua timwa nyinro tiqaro, Mpohua nkyi uaqiama nyataivata nkye qaqira kyeta hia nkyiarivata uaqiama nyataivera, nkyi sova nyaamwuni variva, mwivavata nkyi uaqia hi quara qaqirama kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nkye mwihua uaqia hi kyaiqara utirara qati nraahu riemwaqi vivera, nkyi sovavata nkye uaqia hi kyaiqara uti quara qati nraahu riemwaqiro quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Mwitaa timwa kyero Iesusiva tiqaro, Nkye kyara aurama tarera hita, hia unraqama kyeqata kyuqe kyaiqa vare varia vaisihua hiante hiate. Nraakye qoravanto mwihua kyara aurama tera taqeqata po qiate tita, mwihua ua viri rateqata nrohi variarave. Nte qianinra riaate. Mwihua nraakye qoravanto po timwa nyataavata vaakyama nkyiari kyoqaa vara kyaavo. ");
INSERT INTO omw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","E mpovanto kyara aurama tarera hiqara uqeta kyera aurama taante. Nraakye qoravanto iara qatima kyara nre variho qiate tira, ena viri hiqama kyera qiata qaahi ntumwa kyera nrohiante. Mwitaa hiraro i qova uqeta variva ekyaa uqeta vare varia kyaiqara taqe variva, mwivama i kyuqema mwataananrove. ");
INSERT INTO omw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Hia mwaa mwataraqa variqata kyoqaa ntuvaantuama taate. Mwaa mwataraqa kyoqaa ntuvaantuama taavaro uapaa tove hakuavantove, puaataqataivave, mwi inraikyara nramwa kyero vara uaqiama kye varirave. Mpuara vaisivantovata ntukuraa kyeqata mwi inraikyara vare variarave. ");
INSERT INTO omw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mwata mwaaqa vatera eqeta nyaamwuni uapaa tove hakuavantove, puaataqataarivave, mpuara vaisivantove, hia nkyi kyoqaa vara kyeta uaqiama kyenani vataate. ");
INSERT INTO omw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nkye mwaa mwataraqa kyoqaa ntuvaantuama taivera, nkye mwaa mwataraqa vahiani inraikyarara nraahu mwutukya vahirata riemwaqita vivarave. Nkyi kyoqaa nyaamwuni ntuvaantuama viro vahirera, nkye nyaamwuni vahiani inraikyarara nraahu mwutukya vahirata nronraqama kyeta riemwaqita vivarave. ");
INSERT INTO omw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Vuvanto omwa votima kyero iteqaro mwamwanta ntuvaahama mwatero. I vuvanto kyuqema vahirera, ekyaa i mwamwantaqi kyuqema kyero ntuvaahaananrove. ");
INSERT INTO omw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","I vuvanto uaqia hirera, i mwamwantavanto kyokiraqima vahiananrove. I utaqivata hia ntuvaaharaitiro kyokira rirera, qikye, i utaqi anoma kyero kyokira ruananrove. ");
INSERT INTO omw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kyaiqa vaisi mpovanto hiama qio kuaa vakya nronra vaisi taaratanaqaa kyaiqa varaananrove. Mwiva mwitaa hirera, mporara mwia mwutukya vahiraro mporara hia mwia mwutukya vahiananrove. Mwiva mpora qua riero mpora qua qoririma kyaananrove. E hiama qio Kotiravata munimavata kuaa vakya vataqira vinanrave. ");
INSERT INTO omw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mwi quara rieqanama nte nkyiara mwitaama tuqo, Nkye qati variqita virarave, kyara nrenranrave, nramanri nrenranrave, nkyeta nyamwantarave, tuavaaqa utirarave, hia mwi inraikyara mwi inraikyarara airi nraato tivaro nkyi mwutukyavanto nronraqa hiarive. Nkye qati variqi viva vuni vaiharo kyara nreva nraakiaranima vaiho. Nkyi mwamwantavanto vuni vaiharo nkye tuavaaqa ututeva nraakiaranima vaiho. ");
INSERT INTO omw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nyaamwa hiteta nrohi variahua taqaate. Mwihua hia kyara vara tu kyeta vantuqita uro nraamwuqi vate variarave. Nyaamwavanto variavaro nkyi sova nyaamwuni variva mwihua kyara ruara hirave. Nyaamwa qumina inraikyaqaavata Kotiva ntaqikyi variva nkyi nraakye qoraqaa hiave Kotiva kyuqema kyero ntaqikyiananro? ");
INSERT INTO omw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nkyiqitairo ta vaisivave nte qamwanrama qutu quankyo tiro, qati variani entara mponramwu tomaqa taananrove? Hiama qio vaisi mpovanto mwitaa hiananrove. ");
INSERT INTO omw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nkye nanraqamave nkyeta tuavaaqa utirara nronraqama kyeta rie variavo? Maunra paira mwukyauqi vahirara rieqata variate. Mwi inraikyava hia kyaanta huvu kyero tuavaaqa haqire varirave. ");
INSERT INTO omw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nte nkyi timwa nyuqo. Haaru Soromoniva kyuqema kyero mwunruqama tova hia maunra pairavanto itero ntuvaahaira nraatara kyairave. ");
INSERT INTO omw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kotiva mwivama uakukyaqi vahi maunranra mwunruqama mwatairave. Mwi maunrava mate vahirata hura qia qura kyaivaro itamwa kyaananrove. Qio Kotiva qumina uakukyaqi pataqia vahi maunranravata mwunruqama mwataivara tiro, mwiva hiave nkyivata kyuqema kyero tuavaaqa utu nyataananrove? Qikye, Kotiva nkyi kyaahaqama nyate variva varihata nkye hia mwianra kepukyaqama kyeta riaavo. ");
INSERT INTO omw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kotiva nkyi kyaahaqama nyate varirara tita, hia nkye nronraqama kye vu nraato tuqi viqata, Nanra kyarave nraananrave? Nanra nramanrive nraananrave? Nanra tuavaaqave utuananrave? timwaqita quata. ");
INSERT INTO omw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kotira qua hia riaa nraakye qorahua, mwihua mwitaa timwaqita vi variarave. Nkye hia mwihua nraantantaate. Nkyi sova nyaamwuni variva nkye ekyaa mwi inraikyarara aara ntaara ntapihi kyeroma variho. ");
INSERT INTO omw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nkye Kotiva nkyiqa ntaqikyianinranravata, mwiva nkyiara avuqavuma kye nrohiate qianinranravata, nronraqama kye riemwaqita quate. Nkye mwitaa hivaro Kotiva nkye aara nte inraikyaravata hini mwi inraikyaravata nkyi nyiananrove. ");
INSERT INTO omw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hura qovara hiani inraikyarara hia nronraqama kyeta riaate. (Nkye mate mwaa iherara variahuave.) Hura vari nraakye qorahua hura qovara hiani inraikyarara qio riemwaqita vivarave. Kuaa enta kuaa enta mwiva nanrianra muaanravata nraahu vahivave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iesusiva mwitaa timwa kyero mwiva timwa nyiqiro viro tiqaro, Kotiva nkyita kyaiqavata tukya hiankyo tita, nkye hia uaqiama vu nraato tiqata mpora kyaiqa tukyama kye mwiva mwitaa mwataa hivave qiate. ");
INSERT INTO omw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nkye mpora kyaiqa tukyama kyeta mwitaa mwataama vahirave tivaro Kotiva nkyita kyaiqavata tukyama kyero mwitaa mwataama vahiravema qiananrove. Nkye mpohua kyaiqa tukya hira kuaa mwivauma Kotiva nkyitavata tukya hiananrove. ");
INSERT INTO omw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","E nanraqamave mwata mwumwuvanto ena qata vakyaa vuqi viqetaira taqeqarama hia ena vuqi kyatari aka nronravanto viqetaira taqera hiaro? ");
INSERT INTO omw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kyatari aka nronravanto i vuqi viqetero vaihara nanraqamave ena qata vakyaara kyaiqe i vuqitaina mwata mwumwu qatinani venta kyaankye ti variaro? Hia mwitaa qiante. ");
INSERT INTO omw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","E kyuqe kyaiqa varauqo tiqara unraqanraa hi variaravave. Tauraaqama kyera ena vuqitaira kyatari aka venta kyera mwiaqaataira kyuqema kyera taqeqarama ena qata vakyaa vuqitairavata qio mwata mwumwu venta kyenanrave. ");
INSERT INTO omw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","(Mpo hia vaisihua quara vairi votima kyeta variarave.) Nkye Kotirani kyuqema kyero kyotataqama vahiani inraikyara hia vairi mwiante. Nkye kyukyukyakyaara hia quara hianani kyaate. Nkye mwitaa hivaro mwi inraikyara ntamwa ntautiqama kyero mwiaqaatairo tuqasaa viro nkyita kutuananrove. ");
INSERT INTO omw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Nkye Kotira kyapara hivaro mwiva mwi inraikyara nkyi nyianrive. Nkye puaamaqi vitama qio mwi inraikyara puaama kyevarave. Nkye qesa ntuqutivaro Kotiva qatua nyataarive. ");
INSERT INTO omw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kotira mpo inraikyara kyapara hiariva qioma varaananrove. Mpo inraikyara puaamaqiro quariva qioma taqaananrove. Qesa ntukuakua hiani vaisira qatuama mwataananrove. ");
INSERT INTO omw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nkyi nraaqiara sohuaqitairo tavave mwia mwaaquvanto qamaanra nyaanru tiraro mwia qova ori mwiananro? Mwia qova hiama mwitaa hiananro. ");
INSERT INTO omw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mwia mwaaquvanto tavukyara nyaanru tiraro mwia qarurave mwiananro? Mwiavata hiama mwitaa hiananro. ");
INSERT INTO omw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nkye hia kyuqe hia nraakye qorahua variqatavata nkye nkyeta nraaqiara kyuqe inraikya nraahu nyi variarave. Nkyi sova Kotiva mpo? Nkyi sova nyaamwuni variva nkyi nraatara kyero mpo inraikyara nyaanru qiani vaisira kyuqe inraikya nraahu mantaquma kyeroma mwiananrove. ");
INSERT INTO omw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nkye mpohuara tiri mwitaa mwataama kyeta kyuqema timwataate tintema kyeta nkye mwihua mwitaama nyataate. Mosesivavata poropeti vaisinramwuvata timwato quava mwia okyara mwitaamama vahiro. ");
INSERT INTO omw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Qesa taaratana vahirave. Mpo pata vaiharo mpo nronra vahirave. Nkye qesa pata mwina nraahu quate. Nraakye qora ekyaara taiqa vinaniara qua aanrava, aanra nronra qihaakya hiva vaiharo mwi aanranraqaanaa qesavantovata nronra vaihata nraakye qora airivanto qesa mwina vi variarave. ");
INSERT INTO omw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nraakye qora ekyaa enta kyuqema kyeta qati nraahu variqita quananianra, vi qesava pataqia vaiharo mwinamate qua aanravavata pataqia mwukyaari tukye qua aanrava vaihata kuaiqia kuaiqiavanto nraahu mwi aanranra puaama kyeta vi variarave. ");
INSERT INTO omw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Vaisi mponramwuvanto tiqata, Tire Kotira qua nkyi timwa nyi varuro, tiqata unra ti variahua mwihua nyaatu rauriqata variate. Mwihua sipisipi nraantantamwa kyeta nrohiqatavata mwihua mwaatira utaqi qaakyau vairima variarave. ");
INSERT INTO omw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nkye mwihua nrohi varira taqetama mwihua qora okyara ntapihi kyevarave. Vaisivanto uaini tamwa hiqirero mwiva hia auqururoraqaatairo hiqirave. Mwiva fiki tamwa hiqirero hia uvi auqu vataa kyatariqaatairo hiqirave. ");
INSERT INTO omw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mwia votima kyero kyuqe kyatarivanto kyuqe tamwa nraahu rie variharo qora kyatarivanto qora tamwa nraahu rie varirave. ");
INSERT INTO omw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kyuqe kyatarivanto hiama qora tamwa riaananrove. Qora kyatarivanto hiama kyuqe tamwa riaananrove. ");
INSERT INTO omw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kyatari hia kyuqe tamwa riaira mwia teqa kyeta qiaqi tuto kye variarave. ");
INSERT INTO omw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nte qaiqaa nkyi timwa nyuqo. (Unraqama kye tiqata, Tire Kotira qua timwa nyi varurahuave, qiahua nkye mwihua nrohi varira taqetama mwihua qora okyara ntapihi kyevarave, tiro.) Qio nkye mwi vaisihua varaqita vi kyaiqara taqetama nkye ntapihi kyeta mwihua qora kyaiqa taqevarave tuqo. ");
INSERT INTO omw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Hia ekyaa nraakye qora nianra tiri nronravantove ti varihua Kotiva ntaqikyiani mwatukyaraqi vivarave. Ni kova nyaamwuni varira mwia qua riemwaqiro quariva, mwiva nraahuma mwia mwatukyaqi quananrove. ");
INSERT INTO omw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nraakiara ekyaara entaqaa nraakye qora airivanto nianra tiqata, Po, nronrao, nronrao, i nrutu nteqata Kotira qua ti variavananrave. I nrutu nteqata tire vaisiqitai vaana airi siteta i nrutu nteqata nronra kyaiqa varaavananrave, tivarave. ");
INSERT INTO omw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mwihua mwitaa tivaqena nte, Qaqao, hia nkyi taqauhuave. Nkye qora kyaiqa vare variahuave. Niqaataita nyianrani quate, qianinrave. ");
INSERT INTO omw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ni qua riero nte tuntema kyero vare variani vaisira okyara nkyi timwa nyinrenrave. Mwi vaisiva vu nraato vataava kepukya nraamwu hoqa taani vaisira votima kyeroma variananrove. ");
INSERT INTO omw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mwi vaisiva oriqa nai nraamwu hoqa tairara tiro, vativantove, humwunravantove, toqa vaururuvantove, nronraqama kyero nteqaro mwia venta kyaaninrave tiharovata mwi nraamwuva hia tuma ntiraitiro, kepukyaqama vahirave. ");
INSERT INTO omw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ni qua riero qaqira kyero hia nte tuntema kyero variani vaisira okyara nkyi timwa nyinrenrave. Mwi vaisiva hia vu nraatovata vahiva nai nraamwu nruqasata hoqa taani vaisira votima kyero variananrove. ");
INSERT INTO omw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mwi vaisiva nai nraamwu nruqasata hoqa tairara tiro, vativantove, humwunravantove, toqa vaururuvantove, nronraqama kyero nteqaro mwia nraamwu venta kyaiharo nraamwuvanto tuto ntiharo humwunravanto raaqu kyairarama tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesusiva mwi quara mwi quara mwihua timwa nyi taiqa kyovata nraakye qora mwini ntuvaantuama vuhua tiqata, Qikye, mwiva nraahumwa mpo qarama kyero qua ti variho. ");
INSERT INTO omw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mwiva hia mwaanra okyara ti varia vaisihua timwa timwiantema kyero timwa timwiho. Mwiva nronra vaisivanto qiantema kyeroma ti variho, tita tura. ");
INSERT INTO omw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesusiva mwakyaakya timwa nyi taiqa kyero taaqi mwia mwini kyero tumi varuvata nraakye qora airivanto mwia nraakiara mwia vataqi vi varura. ");
INSERT INTO omw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Vi varuvaro vaisi mpovanto tauma rumpuaravanto uaqiama kyova uro Iesusira vuqaa tori kyauru raviro variro tiqaro, Nronrao, e ni kyaahaqa hiataa hirera, e qioma ni rumpuara kyuqema matenanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Mwitaa tuvaro Iesusiva nai kyauqu mpiami mwia mwamwantaqaa vatero tiqaro, Nte kyaahaqa hiataa ihana nte i mwitaama mwatarerave. Nte i rumpuara tavanta quarive tuqo, tuvaro mwia rumpuaravanto mwia mwamwanta vauruqiro vuva qamwanrama kyero tavanta vuvaro mwiva qio varura. ");
INSERT INTO omw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mwiva qio varuvaro Iesusiva mwia timwa mwinro tiqaro, Hia mpohua timwa nyinraitira, viraro Kotira kyaiqa vara mwate variari vaisiva i mwamwanta taqaarive. Mwiaqaataira e Mosesira mwaanra qua rieqarama munra quani qiara quratarata nraakye qoravanto iara tiqata, Qutaama mwia mwamwantavanto kyuqema viho, qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesusiva mwitaa timwa kyero Kapenaamini vuvaro Romeni vaisivanto 100 ntaqu vaisihuaqaa ntaqikyi varuva Iesusira uro qintorama kyero po kye tiro tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Nronrao, ni kyaiqa vaisi mwamwantavanto hia qakyaa iharo nronraqama kyero nriqa viharo variho, tiro. ");
INSERT INTO omw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mwitaa tuvaro Iesusiva tiqaro, Qio nrinraqetana mwiva hinani quarahua nte uro mwia kyuqema kyaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mwitaa tuvaro nronra vaisi mwiva qaqao tiro, Nte kyuqe vaisi variariravauma e ni nraamwuqi qio vinanrave. E mwaini variqara mwianra kyuqema quante tiraro mwiva kyuqema quarive. ");
INSERT INTO omw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nte i votima kyena vaisiqaa ntaqikyi varuvave. Nte ntaqi vaisira mpora quante tuqaro mwiva virave. Nte mpora nriante tuqaro mwiva nrinrave. Nte ntena kyaiqa vaisiara mwitaa hiante tuqaro mwiva mwitaa hirave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Vaisi mwiva mwitaa tuvaro Iesusiva qikye timwa kyero tuqasaa viro nraakye qora mwia vataqita nruhuara tiqaro, Nte nkyi timwa nyianinra riaate. Mwi vaisiva mpo mwatanaava variqaro nronraqama kyero nianra rieqaro nianra mwiva qioma ni kyaahaqama mataananrove tirave. Hia nte mwiva tintema kyero qua ti vaisira Isareri vaisiqitaina mpo puaama kyauqo. ");
INSERT INTO omw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mwaa quara riaate. Nraakiara nyianra mponasai mponasaita nraakye qora airivanto Kotira mwatukyaqi nrumu variqata mwihua nkyi haivaqara Evarahaamunravata, Aisaakiravata, Iaikopuravata variqata kyara nrevarave. ");
INSERT INTO omw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mwihua varivata mwaa mwatanaahua tire Kotira nraakye qorama varuro ti variahua, mwihua mwi kyarara uro nraanre tivaro mwihua ntavaaqavu kyero mwaaqani mwaati tuto kyairata mwihua kyokira ruaninraqi varita ntateqata nkyiari aanrai teti nreqata varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iesusiva mwitaa timwa kyero nronra vaisi mwianra tiqaro, Ena mwaatani quante. E nianra ni kyaahaqama materavave qiananranra tiro, i quavanto mwivauma vahiananrove, tiro. Mwitaa tuvaro mate mwiqiara mwia nrotuavata mwia kyaiqa vaisi nriqa vuva taiqa vuvaro qio varura. ");
INSERT INTO omw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iesusiva Pitaara nraamwuqi uro ntero taqovaro Pitaara nrinraatarara mwia mwamwanta qiara utovaro vaite varuvaro ");
INSERT INTO omw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesusiva uro mwia kyauquqaa tu varovaro mwia nriqa vuva taiqa vuvaro mwi nraakyeva siviro mwihua kyara uta nyinrenro uti varura. ");
INSERT INTO omw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Iesusiva mwini varuvaro entama vuvata mwi mwatanaahua vaanavanto utaqi varuhua sitaqita Iesusiva varunani uro kyovaro Iesusiva quaqotairo vaana titamwa kyovata nritareta vuvaro Iesusiva nriqa vuhuavata kyuqema kyovata qio varura. ");
INSERT INTO omw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iesusiva mwitaamaqiro vuvaro Aisaiaava poropeti vaisivanto haaru timwato quava qutaa mwivau vahura. Aisaiaava Iesusira okyarara mwitaama tiro: Mwi vaisiva tiri nriqa quaninra taiqa kyaananrove. Mwiva tiri nriqa quaninra kyuqema kyaananrove, tura. ");
INSERT INTO omw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesusiva taqovata nraakye qora airivanto ntuvaantuama vita mwia vara ututu varuvaro Iesusiva tiqaro, Kyai kyaareraqaa qareta vutura hini tokyani uro variare, tura. ");
INSERT INTO omw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Qakyo mwini virera huvaro vaisi mpovanto mwaanra okyara ti varu vaisiva uro ntero Iesusirara tiqaro, Mwaanra ti variarao, nte i nraaqiara varirerave. E mpona mpona vinanra nte ivatama kyena nraahu virera teramama varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mwitaa tuvaro Iesusiva mwia timwa mwinro tiqaro, (E ni pataqira virera hiqara paparuqa hirorave.) Qaakyau vairivanto nkyiari nruaunrutaaraqi vaite variarave. Nyaamwavanto nkyiari nraamwuqi vaite variarave. Nte mwatani mwatatai nraaqiarava vaitaani nraamwuva hia vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iesusiva mwitaa tuvaro mwia vataqi nrohi varu vaisiva mpovanto tiqaro, Nronrao, kyai nte ntena kora nraante uro quntamwa kyena nritarena i vataqi quankye, tuvaro ");
INSERT INTO omw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Iesusiva qaqao tiro, E ni pataqira nriante. Qutu qua vaisihua votima kye variahua qioma qutu quani vaisira quntamwa tevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iesusiva mwitaa timwa kyero mpotuqi mwaanri ntovata mwia nraaqiaranramwuvanto mwiavatama kyeta vurama. ");
INSERT INTO omw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mwihua kyaarera mwiaqaa vi varuvaro mate mwiqiara toqa vaururuvanto kyaareraqaa nronraqama kyero tiqaro nramanri ventaqiro nri vi varuvaro nramanrivanto mpotuqi mwaanri ntero mpotu rauru kyarero uti varura. Mwihua rauru kyaaqara hi varuvaro Iesusiva mwiqi vaite varuvata ");
INSERT INTO omw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","mwia nraaqiaranramwu Iesusiva vaitonani uro mwia vaurama kyeta tiqata, Nronrao, sivira tiri kyaahaqa hiante. Tire nramanri nreta qutuarava pataqia vaiho, tita. ");
INSERT INTO omw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mwihua mwitaa tuvaro Iesusiva tiqaro, Nkye nanraqamave aatu hiavo? Nkye nianra kepukyaqama kyeta riaataara vaihata hia mwitaa hiavo, tiro. Mwitaa timwa kyero Iesusiva siviro toqa vaururuaravata, nramanrianravata tiqaro, Qio eqaante, tuvaro nramanrivanto itomwi viro tirema vahurama. ");
INSERT INTO omw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tirema vahuvata mwia nraaqiaranramwuvanto nro qaqaama teta kyauqu ntukikinraaqata kyeta tiqata, Qikye, mwiva nataa hi vaisivave variho? Toqa vaururuvantovata nramanrivantovata mwia qua rie variho, tura. ");
INSERT INTO omw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mwihua mwitaa timwa kyetama mpotuqi vuhuama vutura qarahi hini Kataraani uro ntovata vaisi taaratanavanto mwihua uro qintorama kyora. Mwitanahua vaana kyapata varutanahua vaisi quntamwa tora ori ataamwuqi variqata mwitanahua mpoqama kyeta vaisi ntuqutirerata uti varuvata nraakye qoravanto mwitanahua nyaatu aatu hiqata hia mwitanahua varu aanranra mwini vi varura. ");
INSERT INTO omw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mwitanahua ori ataamwuqitaita uro Iesusira qintorama kyeta aakyara nteta tiqata, E Kotira mwaaquvantove. Tiritana nataa hirerarave nrianro? Tiritana ruari entava hia nrihanra e qamwanrama kyera tiritana rirerarave nrianro? tita. ");
INSERT INTO omw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mwitanahua mwitaa tuvaro vutura mposata quara airivanto uhiqa nre varuvata ");
INSERT INTO omw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","vaisi taaratana utaqi varu vaanahua Iesusirara po tita tiqata, E tiri titairera e tiri titairaqe tire quaraqi uro variare, tita. ");
INSERT INTO omw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mwitaa tuvaro Iesusiva qio quate tuvata mwihua nritareta uro quaraqi varuvata quara mwihua hianteta okai qoraqahuraqi tutontita nramanriqi ntumwa vita nramai nreta qutu vura. ");
INSERT INTO omw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mwitaa huvata quaraqa ntaqikyi varuhua taqeta hianteta uro mwatukya nronraqi quara qutu vuhuara timwa nyita vaana utaqi varu vaisitananravata timwa nyuvata ");
INSERT INTO omw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","mwi mwatukyaraqinaahua ekyaa mwihua Iesusira hunta kyarerata vuhua uro nteta mwianra tiqata, Po, e hia tiri mwaata mwaini variante. Sivira mwaaqaataira quante, tita. ");
INSERT INTO omw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mwihua mwitaa tuvaro Iesusiva mpotuqi mwaanri ntero nrumu ntantero nramanriqaama tero nai mwaatani uro ntora. ");
INSERT INTO omw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Uro ntovata vaisi mponramwuvanto vaisi mpo hini mwamwanta qutu vura taintamaqita Iesusiva varunani uro kyovaro Iesusiva ntapihi kyovata mwi vaisinramwuhua nkyiari nraahu tiqata, Qutaama mwi vaisira kyuqema kyaananrove, tu vaisihua varuvaro mwiva hini mwamwanta qutu vu vaisirara tiqaro, Ni maaquo, kepukyaqama kyera variante. E Kotira qua nteqa kyaananra nte nrukama mwatauqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iesusiva mwitaa tuvata mwaanra okyara ti varu vaisinramwuhua qaqao timwa kyeta nai timwa mwi nai timwa mwi hita tiqata, Mwaa vaisiva mwitaa tiqaroma Kotirara uaqia hi quarama ti variho, tita. ");
INSERT INTO omw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mwihua mwitaa tuvaro Iesusiva mwihua su nyaatoqi vahu quara ntapihi kyero mwihuara tiqaro, Nanraqamave nkye uaqia hi quara nkyeta su nyaatoqi mwitaama kyeta riaavo? ");
INSERT INTO omw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nkye nianra tiqata, Mwiva qumina vaisi variqarora tiro, hiama qio nai hena vaisivanto Kotira qua nteqa kyaaninra nruka mwataananrove, qiarave. Qio mpo kyaiqa mpo? Qiove nte mwaa vaisira kyuqema kyaaninrave? Nkye ni timwa mpivaqe riaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iesusiva mwitaama kyero ntumwahiamwama nyatero mwihuara tiqaro, Nte mwatani mwatatai nraaqiaravama varuqaro ni nronraqama kyaihana nte qioma mwatani variqana vaisivanto Kotira qua nteqa kyaaninra nruka mwataaninrave. Nkye ni quara qutaa quave qiate tina, nte mwaa vaisirara mwataa tirerave, tiro. Mwitaa timwa kyero Iesusiva hini mwamwanta qutu vu vaisira mwianra tiqaro, Sivira ena taintavata tu varera ena mwaatani quante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","8","Mwitaa tuvaro mwi vaisiva siviro nai mwaatani vuvata mwini ntuvaantuama vuhua mwi kyaiqara taqeta aatu hita Kotira nrutu tuaahereta tiqata, Kotiva mwi vaisira kepukyaqama kyaiharo mwi kyaiqara varaiho, tita turama. ");
INSERT INTO omw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesusiva mwiaqaatairo vuva viqaro taqovaro vaisi mpovanto Matiuva taakisi vareqaro haraara nraamwuqi varuvaro mwiva mwianra tiqaro, Ni pataqira nriante, tuvaro Matiuva siviro mwia vataqiro vurama. ");
INSERT INTO omw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mwia vataqiro vuvaro Iesusiva nai nraaqiaranramwu kyapata uro Matiura nraamwuqi kyara nre varuvata airi vaisi taakisi vare varuhuavata, uaqia hi kyaiqara uti varuhuavata, Iesusira vatama kyeta kyara nre varura. ");
INSERT INTO omw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nre varuvata Parisi vaisinramwuvanto mwihua taqeta Iesusira nraaqiaranramwuanra qaqao tita, Nanraqamave nkyi nronravanto taakisi vare variahuavata, uaqia hi kyaiqara uti variahuavata, kuaaqi kyara nre variho? tita. ");
INSERT INTO omw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mwinramwuhua mwitaa tuvaro Iesusiva tiqaro, Qati variahua hia totaava hinani vi variarave. Nyiqa vihua nraahu totaava hinani vi variarave. ");
INSERT INTO omw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tire ntapihi kyeta nrohi varurahuave qiahua hia nte mwihua nyaanranrenra tumuvave. Nte uaqia hi kyaiqara uti varia nraakye qorahua nyaanranrenrana tumuvave. Kotira mpukuqi qara ntumwato quava Kotirara mwitaama tiho: Vaisivanto quara rukyero mpianinranra hia nte mwianra qamwataaninrave. Vaisivanto mporara po kye timwa mwateqaro kyaahaqama mwataaninra nte mwianrama qamwataaninrave, turave. Nkye mwi quara okyarara nraato tita uro puaama kyeta taqeta riemwaqita quate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Iesusiva mwitaa tuvata Ioninra nraaqiaranramwuvanto Iesusiva hunani uro nteta mwia kyapara hita tiqata, Tirevata, Parisi vaisinramwuvantovata, kyara aurama te varuro. Nanraqamave i nraaqiaranramwuvantovata hia kyara aurama taraitita, qati kyara nre variavo? tita. ");
INSERT INTO omw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Nraakye varaari vaisiva nai vataahuavata varirera, tavave mwia vataahua mwihuara kyara aurama taate qiananro? Qaqao, hia mpovanto mwitaa qiananrove. Mpo enta nri ntairata mwihuaqitai nraakye varaani vaisira vara qatinani kyairata mwi entaraqaataitama mwia vataahua ntateqata kyara aurama tevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mwitaa timwa kyero Iesusiva mpo quaqaa ntumwa kyeqaro timwa nyinro tiqaro, Mpovanto tuavaaqa nrihi ntupema vira haqirarero hiro hiama qaraakya tavuna toqa kyero mwiaqaa taaqau tero haqiraananrove. Nraakiara tuavaaqa mwia hiqairaro qaraakya tavuna haqirama taariva viro qiquqama viraro nrihi tuavaaqa mwivavata nronraqama kyero ntupe hiankyo tiro, hia mwitaa hirave. ");
INSERT INTO omw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Qaiqaa tirerave. Hia mpovanto qaraakya uaini tati kyero memenra pahiqo ututai taqura haaruaa taquqi qaiqaa vara kyero raurirave. Mpovanto mwitaa hirera qaraakya uainivanto tapitero taqu mwia takuma viraro qatinani ntamwa viraro taqu mwivavata uaqiama quananrove. Mwitaa hiankyo tiro vaisivanto memenra pahiqo ututai taqura qaraakya taqu vara kyero qaraakya uaini rauri variharo uainivantovata taquvantovata qio vahirave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesusiva mwitaa ti varuvaro mwaanra nraamwuqaa ntaqikyi varu vaisiva mpovanto uro Iesusira vuqaa tori kyauru raviro tiqaro, Ni naamwunravanto qutuma viho. E nrinra ena kyauqu mwiaqaa vatairaro qati siviro variarive, tiro. ");
INSERT INTO omw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mwitaa tuvaro Iesusiva siviro nai nraaqiaranramwu kyapata mwi vaisira vataqiro viro. ");
INSERT INTO omw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aanraqaa vi varuvaro nraakye mpovanto nriqa vuvaro 12 ihiara qati nraahu tora taqamwaqiro vu nraakyeva Iesusira mwoqani uro variqaro Iesusira vaaqa viti kyaatu kyero. ");
INSERT INTO omw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mwi nraakyeva nai riero tiqaro, Nte mwia vaaqa viti kyaatu kyaariro ni nriqa viva taiqa viraqe qioma varianinrave, timwa kyero Iesusira vaaqa viti kyaatu kyora. ");
INSERT INTO omw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kyaatu kyovaro Iesusiva tuqasaa viro mwia taqero tiqaro, Ni naamwunrao, kepukyaqama kyera variante. E nianra ni kyaahaqa hiarivave qiararoma i mwamwantavanto kyuqema viho tuvaro mate mwiqiara mwi nraakyeva kyuqema viro varura. ");
INSERT INTO omw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iesusiva vuva uro mwaanra nraamwuqaa ntaqikyi varura mwia nraamwuqi vera ntero taqovata mpo uhua po kye tiqata ntate ntoma vaarara vuate varuvata mpo uhua nronraqama kyeta ntate varuvaro ");
INSERT INTO omw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Iesusiva tiqaro, Nkye tumitareta quate. Mwi qiaatarava hia qutu viho. Qati vaitema variho, tuvata mwihua nai mwianra nraahu raima mwatora. ");
INSERT INTO omw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Iesusiva mwihua sitovata veva ntovaro mwi qiaatarara vatoraqi vera ntero mwia kyauquqa tu varovaro mwi qiaatarava qati sivura. ");
INSERT INTO omw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iesusiva mwitaa hu quava ekyaa mwi mwataraqi viro nrinro huvata ekyaa riemwa ntora. ");
INSERT INTO omw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesusiva mwiaqaatairo aanraqaa vuvata vaisi taaratanavanto vu qipa vu tanahua mwia vataqi vita mwia nraanramaqita vita tiqata, Ntevitira mwaaquo, qati tiritananra po kye timwa timwataante, tita. ");
INSERT INTO omw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mwitanahua mwitaa timwaqita vuvaro Iesusiva nraamwuqi vera ntero varuvata mwitanahua mwiva varunani uro ntovaro Iesusiva mwitanahua kyapara hiro tiqaro, Nkyetana nianra qutaave mwiva tiritana tivu ntapairi timwataananroveve qiavo? Tivaqena riaankye, tuvata mwitanahua, Nronrao, eo, tita. ");
INSERT INTO omw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mwitanahua mwitaa tuvaro Iesusiva mwitanahua suqaa nai kyauqu vatero tiqaro, Nkyetana nianra qutaa mwitaa hiananrove qiavenama nkyitana su ntapairi nyatauqo, tuvaro ");
INSERT INTO omw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","mwitanahua suvanto ntapairi vuvata qio taqeta. Mwitanahua qio taqe varuvaro Iesusiva kepukyaqama kyero timwa nyinro tiqaro, Hia mwi quara mpohuavata timwa nyiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iesusiva qao tu quara mwitanahua qaqira kyeta uro mwi quara mpohua mpohua timwa nyiqi vi varuvaro mwi quava mwi mwataraqi viro nrinroma vura. ");
INSERT INTO omw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mwitanahua vuvata vaisi mponramwuvanto nkyiari hena vaisi mpo vitaqita uro Iesusiva varunani kyora. Vaanavanto mwi vaisiraqi varuvarora tiro, mwiva hia qua tuvata mwia vitaqita Iesusiva varunani uro kyovaro ");
INSERT INTO omw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iesusiva vaana mwia titovaro nritarovaro mwi vaisiva qua tuvata nraakye qora mwini ntuvaantuama vuhua, Qikye, tire Isarerivanto haaruvata hia mwataa hi kyaiqara taqaunanrave, tita. ");
INSERT INTO omw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mwihua mwitaa tuvata Parisi vaisinramwuvanto qaqao, tita. Vaana vunyaava mwia kyaahaqa hi variharoma Iesusiva vaana site variho, tura. ");
INSERT INTO omw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesusiva mpo mwatukya mpo mwatukya nronra mwatukyaqivata pata mwatukyaqivata nrohiqaro mwaanra nraamwuqi vera ntero variqaro Kotiva nraakye qoraqaa ntaqikyiani quara kyuqe qua timwa nyiqiro viqaro mpo qara mpo qarama kyero nriqa vuhuavata kyuqemaqiro vura. ");
INSERT INTO omw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mwiva mwitaamaqiro vi varuvata nraakye qora airivanto mwiva hunani ntuvaantua hita vita nrita hi varuvaro Iesusira mwutukyavanto mwihuara ua huvaro mwiva tiqaro, Po, vaisivanto hia ntaqikyi varihata sipisipinramwu nkyiariara api nrohita hia qio nkyiari kyaahaqa hiraitita, pupohaihata varia sipisipihua votima kyetama mwaa nraakye qorahua nrohi variavo, timwa kyero mwihuara po kye timwa nyatero. ");
INSERT INTO omw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iesusiva nraakye qorara po kye timwa nyatero nai nraaqiaranramwuanra tiqaro, Taqaate, kyara airivanto keko tihata mwia vantu vareta nrihua hia airivanto variavo. ");
INSERT INTO omw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nkye aakyo qora kyapara hivaro mwiva kyaiqa vaisi mponramwuvata sitairata uro kyara vantuate, tiro. (Iesusiva kyara keko tiho tura mwiaqaa ntumwa kyero nraakye qorara tura.) ");
INSERT INTO omw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesusiva nai nraaqiara 12 nramwu nyaanrama kyero sita vatero mwinramwuhua nraakye qoraqitaita vaana siteta nataa nataama nriqa quarihuave kyuqema nyataate tiro, mwiva mwinramwuhua nronraqama kyora. ");
INSERT INTO omw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mwiva nronraqama kyo vaisihua nyutu vahirero: Vuni Saimoninra. mwia nrutu mpo Pitaara, mwia qata Enturura, Sepetira mwaaqu Iemisira, Iemisira qata Ioninra, ");
INSERT INTO omw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Piripira, Pataromiunra, Tomaasira, Matiura taakisi vare varu vaisira, Arapiaasira mwaaqu Iemisira, Tatiaasira, ");
INSERT INTO omw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimoninra. mwia nrutu mpo Serotira, Iutaasi Isikeriotira. mwiva Iesusira nramwutaahua suqaa qovarama kyo vaisira. ");
INSERT INTO omw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesusiva nai nraaqiara 12 nramwu sitero qua timwa nyinro tiqaro, Nkye vihuama hia mpo mwatanaa mwaatani quate. Hia Sameriaa nraakye qora mwatukyaqivata quate. ");
INSERT INTO omw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nkye hia mwini viraitita nkye sipisipivanto raupirima viva apiqama vintema kyeta variahua Isareri nraakye qoraqi nraahu quate. ");
INSERT INTO omw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nkye uro variqata mwitaamama timwa nyiate. Kotiva nkyiqa ntaqikyiariva nkyi qaumatoma nri ntaiho, qiate. ");
INSERT INTO omw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nkye nriqa vihua kyuqema nyataate. Nkye qutu vihua sivuma kyaate. Nkye mwamwanta vauruqiro quani tauma rumpuarava vaisiqaa vahianinra nruka nyataate. Nkye vaanavanto vaisi utaqi variahua sitaivata nritaraate. Nte hia nkyiara munimanra nyaanru tiraitina qati nkyi nronraqama kyaurara tita, nkyevata nraakye qora qatima kyuqema nyataate. ");
INSERT INTO omw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Hia nronra munimave, pata ori munimave, ntumwa vareta quate. ");
INSERT INTO omw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nkye virera hita hia kyara tuaqi ntita, tuavaaqave, kyuqu nraamwuve, kyauruve, mwi inraikyara hia vararaitita, qatima quate. Nkye kyaahaqama nyatarera ihua mwihuama nkyiqa ntaqikyiate. ");
INSERT INTO omw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nkye nronra mwatukyaqive, pata mwatukyaqive, uro ntetama nkyi qamwata nyataani vaisira puaama kyetama mwia nraamwuqi nraahu variqita vita mwi mwatukyara kyetama quate. ");
INSERT INTO omw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nkye nraamwuqi vera ntarera hita, mwiqi varihua qua mwanteqatama, Nkyi mwutukyavanto qihaakya hirata variate, qiate. ");
INSERT INTO omw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nkye mwitaa tivata mwiqi varihua nkyi kyuqema kyeta sita vataivera, Kotiva mwihua mwutukya qihaakyama nyataananrove. Mwihua hia nkyi kyuqema kyeta sita vataivera, Kotiva mwihuaqitairo mwutukya qihaakya hira mwia vara kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mpo nraamwuqinaahuave, mpo mwatukyaqinaahuave, hia nkyi qamwata nyateta hia nkyi quavata riaivera, nkye nkyetaqaatai ntuvenrauma kyeta mwi mwatukyaraqi tuto kyeta quate. ");
INSERT INTO omw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nte qutaaqama kyena nkyi timwa nyianinra riaate. Nkyi qua hia rie nraakye qorahuaqaa Kotiva nronra muaanra vataananrove. Haaru Sotomiqi varuhuavata, Komoraaqi varuhuavata, uaqia hi kyaiqara nraahu uti varurave. Nraakiara ekyaara entaqaa Kotiva ko tiqaroma mwi vaisihuaqaa pataqia qua vatero nkyi qua hia rie nraakye qorahua mwihuaqaa nronraqama kyeroma qua vataananrove, tiro. Iesusiva nai nraaqiaranramwu timwa nyunrama. ");
INSERT INTO omw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Iesusiva mwitaa timwa kyero timwa nyiqiro viro tiqaro, Nkye mwaa quara riaate. Nte nkyi sitaarita nkye sipisipi votima kyeta vivata mpo ihua qaakyau vairi votima kyeta nkyi uaqiama nyatarerata uti varivarave. Mwianra rieqatama nkye qaruravanto rauru kyeqaro nrohintema kyeta nrohiate. Nyaamwa mpohiva hia nai hena nyaamwavata ntaqintema kyeta nkyevata hia mpohua uaqiamaqita quate. ");
INSERT INTO omw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nkye vaisi mponramwuanra rauriqata variate. Mwihua nkyi ntavaaqavuqita uro nkyiari kaanasori nraamwuqi kyeta nkyiqa qua vatevarave. Nkye mwaanra nraamwuqi varivata nkyi ntuqutu kyeta vatevarave. ");
INSERT INTO omw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nkye ni kyaiqa vare varivata mwia kyaara nkyi ntavaaqavuqita uro nronra vaisi suqaavata, vunyaa vaisi suqaavata, kyevarave. Nkyi uro kyaivata nkye mwihuavata mpo mwatanaa mpo mwatanaavata ni qua nraahu timwa nyiate. ");
INSERT INTO omw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Mwi entara nkyi ntavaaqavuqita uro kyaivata hia nkyi mwutukyavanto nronraqa hirata, Nanra quave qiananrave? qiate. Mwi entara hia nkye nkyeta nraato tu kyeta tiraitita varivaro nkyi sora mwanraquravanto nkyiara mwitaa mwitaa qiate tiqaro nkyi nroqitairo qua qiananrove. ");
INSERT INTO omw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nraakiara mpo hihua nkyiari qatave nkyiari vakyaarave qovarama kyaivata ru kyevarave. Mwihua qohua nkyiari nraaqiara qovarama kyaivata ru kyevarave. Mwihua nraaqiaranramwuvanto nkyiari nyohua sohua qua hia riaraitita, mwihua ru kyaate tivata ru kyevarave. ");
INSERT INTO omw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nkye ni kyaiqa vare varivata mwia kyaara nkyi qoririma nyatevarave. Mwitaamaqita vivaro hia qamwanrama pupohairaro mpo enta mpo enta kepukyaqama kyero variqiro vi variari vaisiva, mwiva qio variraro ekyaara entaqaa Kotiva mwia vitaananrove. ");
INSERT INTO omw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nkye mwi mwatukyaraqi varivata nkyi qoraqama nyateqata nkyi ru kyarera utivera, nkye aatu ntuqema kyeta mpo mwatukyaqi quate. Nte qianinra riaate. Nkye Isareriqi nrohiqata ni qua hia ekyaa mwatukyaqi timwa nyi taiqa kyaivaqena nte mwatani mwatatai nraaqiarava qaiqaa tumuaninrave. ");
INSERT INTO omw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Qumwanraa vaisivanto nai qua mwaanra timwa mwi vari vaisira hia nraatara kyairave. Kyaiqa vaisivantovata hia nai nronra vaisi nraatara kyairave. ");
INSERT INTO omw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Qumwanraa vaisivanto variqi viro nai qua mwaanra timwa mwi variani vaisira nraantantamwa viro mwiaqaatairo mwiva nte qioma kuaa qarama varuqo qiananrove. Kyaiqa vaisivanto variqi viro nai nronra vaisi nraantantamwa viro mwiaqaatairo mwiva nte qioma kuaa qarama varuqo qiananrove. Mwihua nianra e vaana vunyaava Pierisepuriva variaro qiarave. Mwihua vaakya uaqia hi nrutura mwia ni mpiahuara tita, mwihua nraakiara nkyi ni nraaqiaranramwuvata anoma kyeta uaqia hi nrutura nyivarave. ");
INSERT INTO omw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Nkye mwi quara rieqatama hia vaisi nraatu aatu hiqata variate. Mpovanto taqaankyo tiro ntumwaqu taani inraikyara, nraakiara ekyaa mwi inraikyara qoqaa nraahu qovarama kyaananrove. Mate uqeta taani inraikyara nraakiara qovarama kyairaro qoqaama vahiananrove. ");
INSERT INTO omw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mate nte kyokiraqi variqana nkyi timwa nyi varu quara nkye nraakiara ntuvaahaaninraqa variqata timwa nyiate. Mate nte tirema kyena nkyi timwa nyi varuqata riaa quara nraakiara mwatukyaqaa variqata aakyara ntamwa kyeta qiate. ");
INSERT INTO omw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nkyi mwanraqura hia rukyaraitita mwamwanta nraahu rukye vaisihua hia mwihua nyaatu aatu hiate. Nkye Kotira nraatu aatu hiqata variate. Vaisivanto qutu viro qutu vihua qiaqi vinani viraro Kotiva mwia mwamwantavata mwia mwanraquravata qio ru taiqa kyaarivama variho. ");
INSERT INTO omw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Qio qutaave vaisivanto pata munima kuaaru kyero uapaa nyaamwa varairave? Nkye uapaa nyaamwave qiara Kotiva mwiaqaavata ntaqikyima variho. Kotiva hia qiove tirera, uapaa nyaamwa mwiva hiama qio tumu ntuananrove. ");
INSERT INTO omw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kotiva nkyiqa ntaqikyiqaroma nkyi okyara ekyaa taqe variva, mwiva nkyi qiata kyaahivata ekyaa kyaara ntumwa tairave. ");
INSERT INTO omw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nkye uapaa nyaamwa nraatara kyaahuave. Kotiva uapaa nyaamwaqaa ntaqikyiqaro nkyiqaavata nritarero kyuqema kyero ntaqikyi varirara tita, hia aatu hiqata variqita quate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Iesusiva mwitaa timwa kyero timwa nyiqiro viro tiqaro, Vaisi mpovanto nraakye qora suqaa variqaro nianra vutu kyero timwa nyinro tiqaro, Nte mwia nraaqiarama varuqo, tirera, ntevata ni kova nyaamwuni varira vuqaa variqana vutu kyena tiqana, Nai mwi vaisivavata ni nraaqiarama variho, qianinrave. ");
INSERT INTO omw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mpovanto nraakye qora suqaa variqaro nianra tiqaro, Qaqao, hia nte mwia nraaqiarama varuqo, tirera, ntevata ntena kova nyaamwuni varira vuqaa variqana nai mwi vaisirara tiqana, Qaqao, mwiva hia ni nraaqiarama variho qianinrave. ");
INSERT INTO omw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nkye nianra tiqatama, Mwiva tumu varihatara tita, nraakye qora mwatani varihua mwaateraqama kyeqata variqita vivarave, qiavo. Nkye mwitaave qiavo? Qaqao, nte mwatani tumu varurara tita, mwatani varihua ni nramwutaaqa hiqata varivaro nronraqama kyeta ntaqiva qovara hiananrove. ");
INSERT INTO omw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ni kyaara qovavata mwaaquvantovata nramwutaaqa hiqata varivarave. Ni kyaara nrovavata nraamwunravantovata nramwutaaqa hiqata varivarave. Ni kyaara mwia nraaqutuvanto nai nraaqutuntiri nramwutaaqa hiqata varivarave. ");
INSERT INTO omw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Vaisi mpovanto varirata mwia vataahua mwia nraamwuqi varihua mwihuama mwia nramwutaaqa hivarave. ");
INSERT INTO omw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mpovanto nianra mwutukya vahianinravata nraatara kyero nai nronranrave, nai qorarave, mpoqiavata mwutukya vahiariva mwi vaisiva hiama qio ni nraaqiara variananrove. Mpovanto nianra mwutukya vahianinravata nraatara kyero nai mwaaquarave, nai nraamwunranrave, mpoqiavata mwutukya vahiariva mwi vaisiva hiama qio ni nraaqiara variananrove. ");
INSERT INTO omw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mpovanto hia nai rukye hirite kyatarira vara qu varero ni naakiara nrianriva, mwiva hiama qio ni nraaqiara variananrove. ");
INSERT INTO omw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Vaisivanto nai mwatani qati varianinranra nraahu nronraqama kyero riaariva, mwi vaisiva ekyaarama qutu quananrove. Vaisi mpovanto nianra riemwaqiro viqaro uro qutu quariva, mwi vaisiva ekyaa entama qati variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nte nkyi sitaarita vivaro vaisi mpovanto nkyi qamwata nyateqaro mwiva nivatama qamwata mataananrove. Mwiva ni qamwata mwateqaro ni kova ni titairavatama qamwata mwataananrove. ");
INSERT INTO omw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kotira qua qovarama kyero timwa nyi variari vaisiva, poropeti vaisivanto nri ntairaro vaisi mpovanto mwia qua riarera qamwata mwatairera, Kotiva poropeti vaisi mwia kyuqema mwataintema kyero mwi vaisiravata kyuqema mwataananrove. Avuqavuma kyero nrohi variari vaisiva nri ntairaro vaisi mpovanto mwianra avuqavuma kyero nrohi vari vaisirave kyaiqe mwia qamwata mwataankye tirera, Kotiva avuqavuma kyero nrohi vari vaisira kyuqema mwataintema kyero mwi vaisiravata kyuqema mwataananrove. ");
INSERT INTO omw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Vaisi mpovanto ni nraaqiara pata mporu taqero mwiva Iesusira nraaqiarave timwa kyero qamwata mwateqaro antaani nramanrinra kyaqa kyero mwia mwinrenra, Kotiva hia mwi vaisira qaqira kyaraitiro, mwia kyoqaa kyuqema kyero mwataananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesusiva mwi quara nai nraaqiaranramwu timwa nyitero mwiva mwini kyero mwakyaakya nraakye qora timwa nyinrenro Karirini mpo mwatukya mpo mwatukyaqiara vura. ");
INSERT INTO omw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Iesusiva mwini vuvaro Ioniva karavuqi variqaro riovaro Kotiva tito vaisiva nronra kyaiqa vare varuvaro mwiva nai nraaqiaranramwu sitovata mwinramwuhua uro Iesusira ntumwahiamwa hita tiqata, ");
INSERT INTO omw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kotiva titairaro nraakiara nrianriva qutaa e mwaa mwivave? Tire vaisi mpo vekyave variananrave? tita. ");
INSERT INTO omw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mwinramwuhua mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Nkyenramwu mwaini nrumu variqata taqaarave, riaarave, nrumu ntanteta uro Ioninra timwa mwiate. ");
INSERT INTO omw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Vu qipa quahua qatima taqe variavo. Kyuqu uaqiama vihua qatima nrohi variavo. Rumpuara taumavanto mwamwanta nre vari nraakye qorahua mwamwanta tavanta vihatama variavo. Nraato tita vihua qaiqaa qioma riaavo. Qutu quahua sivita qatima variavo. Vehi nraakye qora Kotira qua kyuqe qua nrumu rie variavo. Mwi quara mwi quara uro Ioninra timwa mwiate. ");
INSERT INTO omw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nianra hia taara nraato tiraitiro kepukyaqama kyero kuaa vu nraato nraahu riemwaqiro vi variariva, mwivama qamwateqaro variananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Iesusiva mwitaa tuvata Ioninra nraaqiaranramwuvanto nrumu ntante vi varuvaro Iesusiva nraakye qora ntuvaantuama vuhua Ioninranra timwa nyinro tiqaro, Nkye haaru nanra inraikya taqarerata qumina mwatani vurave? Toqavanto omwa ahikya tiharo hini viro hini nrinro hira taqarerata vurave? ");
INSERT INTO omw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nkye hia mwia taqarerata viraitita, mpo nanra inraikya taqarerata vurave? Kyuqe tuavaaqa ututo vaisira taqarerata vurave? Qaqao, kyuqe tuavaaqa utute varia vaisihua hia qumina mwataqa variarave. Mwi vaisihua vunyaa vaisi nraamwuqi nraahu variarave. ");
INSERT INTO omw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nkye nanra inraikya taqarerata vurave? Kotira qua qovarama kyaani vaisira poropeti vaisi taqarerata vurave? Eo, mwiave. Qio kyai nte nkyi timwa nyianrita riaate. Nkye mwi entara poropeti vaisi nraatara kyai vaisira taqorave. ");
INSERT INTO omw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kotira mpukuqi Kotiva Ioninranra mwataama tiro: Taqaante, ni qua timwa nyiani vaisira nte titaariro mwiva nraante i vuni viqaro i aanra terama mwataananrove turave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Iesusiva mwitaa timwa kyero mwihuara tiqaro, Kyai nte nkyi timwa nyianrita riaate. Mwatani mwatataa nraakye qorahua variavaro Ioniva nramanri nyi vari vaisiva ekyaa mwihua nraatara kyaivama variho. Ioniva mwitaama variharo nraakiara Kotiva ntaqikyiani nraakye qorahuaqitairo nai vara mwataniqa hiariva nraahuma Ioninra nraatara kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ioniva nramanri nyi varu vaisiva qovarama vu entaraqaatairo ntaqi varia vaisihua Kotiva ntaqikyiani quara ntumwaqu kyarerata Ioninra ntavaaqavu kyaahua mwaa entara nivata ntavaaqavu kyarerata uti variarave. ");
INSERT INTO omw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Haaru poropeti vaisinramwuvantovata, Mosesivavata, Kotiva ntaqikyiani quara timwa qovaramaqi vi varuvaro Ioniva qovarama vurave. ");
INSERT INTO omw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ioniva varirero mwiva nkyi haivaqava Iraisaava qaiqaa mwatani qovarama quari vaisivama variho. Nkye mwi quarara qutaave tivera, nkye Ioninranra mwiva Iraisaavavema tivarave. ");
INSERT INTO omw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nkyi nyaato vahirera, nkye mwi quarara nraato tita mwia okyara ntapihiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Iesusiva mwitaa timwa kyero tiqaro, Mwaa entara varia nraakye qorahua, mwihua nanra inraikya votima kyetave variavo? Nte nanra quaqa ntumwa kyena qiaritave nkye mwi quara ntapihi kyeta rievarave? Kyaiqe nkyi timwa nyiankye. Mwihua nraaqiara uapaahua mwatukyaqaa ntuvaantuama vita ntarerata variante hiavo. Nkyiari hena nraaqiara mpo hiahua nyaanrama kyeta tiqata, ");
INSERT INTO omw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Tire ntoma vaara vuataurata nkye ihi ntaataara vaihatama nkye hia ihi ntaavo. Tire nteqatama ntate ihira turata nkye ntataataara vaihatama hia ntataavo qiarave. Mwaa entara varia nraakye qorahua mwihua votima kyeta variarave. ");
INSERT INTO omw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ioniva nri ntero kyara aurama tero hia uainivata nrovata mwihua mwianra tiqata, Vaana kyapata varivave, turave. ");
INSERT INTO omw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nte mwatani mwatatai nraaqiarava nri ntena kyaravata nramanrivata nrauqata mwihua nianra tiqata, Mwia taqaate. Mwiva mpoqama kyero kyara nre varivave. Mwiva uaini nreqanro uera nte varivave. Mwiva taakisi vare variahuavata, uaqia hia vaisihuavata, totiqa hi varivave, qiarave. Mwihua nianra mwitaa ti variarave. Qio quavanto kyuqe qua vahirera, mwi quara riemwaqira virava taqairaro kyuqe qua nraahu vahiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iesusiva mwatukya mwinramwunraqi airi kyaiqa nronra kyaiqa vara nyatovata mwi mwatanaahua hia uaqia hu aanranra qaqira kyaraitita varuvaro Iesusiva po kye timwa nyatero mwi mwatanaahuara tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Po, nkye Korasinivantovata Vetasaitaavantovata nkye taqevarave. Nte nkyi suqaa nronra kyaiqa varauntema kyero haaru mpovanto nronra kyaiqa Taiaa mwatanaahuave Saitoni mwatanaahuave vara nyatarerave tutirio, mwi mwatanaahua mpo mwatanaahuara tita, vaakyama qainaama tuavaaqa ututeta nkyiari mwamwantaqa qaupa quteta uaqia hi aanranra qaqirama kyotirio. ");
INSERT INTO omw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nte nkyi suqa nronra kyaiqa varauqata nkye hia uaqia hi aanranra qaqira kyera mwia kyaara ekyaara entaqaa Kotiva ko tiqaro Taiaa mwatanaahuaqaavata Saitoni mwatanaahuaqaavata qua nronra vatero nkyiqa qua nronra mpoqiavatama vataananrove. ");
INSERT INTO omw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Po, nkye Kapenaamiqi variahua nkye tiqata, Kotiva tiri nronraqama kyairaqeta nyaamwuni quananrave, qiavo. Qaqao, hiave. Kotiva nkyi vara kyero qaqira kyairata nkye qutu vihua varira qiaqima uro varivarave. Nte nkyi suqa nronra kyaiqa varauntema kyero haaru mpovanto Sotomi mwatukyaqi variqaro mwi mwatanaahua nronra kyaiqa vara nyataankye tutirio, mwi mwatanaahua uaqia hi aanranra qaqira kyovaro Kotiva hia mwi mwatukyara taiqa kyovaro mwaa entara mwi mwatukyava qatima vahitirio. ");
INSERT INTO omw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nte nkyi suqa nronra kyaiqa varauqata nkye hia uaqia hi aanranra qaqira kyera mwia kyaara nraakiara ekyaara entaqaa Kotiva ko tiqaroma Sotomi mwatanaahuaqaa qua nronra vatero nkyi Kapenaamiqinaahuaqaa qua nronra mpoqiavatama vataananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Iesusiva mwitaa timwa kyero mwi entara Kotirara aakyara ntero tiqaro, Ko, e nyaamwuqaavata mwataqaavata ntaqikyi variaravave. E mwi inraikyara mwi inraikyara uqeta tera nronra vaisi ekyaa okyara taqaa vaisihua hia nyaamwutaraitira, qumina nraakye qora nyaamwute variananranra tina, nte i nrutu tuaaherauqo. ");
INSERT INTO omw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eo, ko, qio e ena kyakya hiraqa mwitaa hiataa iharara tira, mwitaa hiaro, tiro. ");
INSERT INTO omw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Iesusiva mwitaa timwa kyero tiqaro, Ni kova nianra ekyaa inraikyaqaa ena ntaqikyiante tirave. Hia qumina vaisivanto ni mwia mwaaqu okyara ntapihirave. Ni kova nai nraahu ni okyara ntapihi kyairave. Hia qumina vaisivanto ni kora okyarara ntapihirave. Nte mwia mwaaquvanto nraahu mwia okyara ntapihi kyaurave. Nte tahuave timwa nyiataa hiraqena timwa nyianrihua mwihuavata ni kora okyara ntapihi rievarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Iesusiva mwitaa timwa kyero tiqaro, Nkye nronra muaanra ntai inraikyara ventaqu vaantaqu ihata vare variavaro pupohaihata variahua nte nkyiara tirerave. Nkye nte hiarinani nrivaqena nte nkyi qati varira nyianrita nkye tekya hiate, tuqo. ");
INSERT INTO omw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","(Purimakauvanto qua riaarive tiro kyatari kohi kyero vaataariqaa rupatairaqaa ntumwa kyena tirerave.) Nkye kyatari nte nyianinra vara kyeta nkyeta qumwuqa vataivaqe nte ntena kyaiqa nkyi nyaamwu taankye. Hia nte ntena nutu tuaaheraraiti, nte qihaakyama kye varurara tita, nkye qioma tekya hivarave. ");
INSERT INTO omw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nte nkyi qumwuqa kyatari qu nyataariva kyuqema kyero vahiananrove. Nte nkyiqa muaanra vataariva vuvua taananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mwi entara Iesusiva mwaanraqa aakyo utaqi kyakuma voti hura uiti tutoraqi nrohi varuvata mwia nraaqiaranramwu nraataa huvata uiti tamwa nteqa kyeta uru mwia nre varura. ");
INSERT INTO omw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nre varuvata Parisi vaisinramwuvanto mwihua taqeta Iesusirara tiqata, Ena nraaqiaranramwu taqaante. Mwaanra entaqaa hia mwitaa hiate qiarama mwihua mwitaa hi variavo, tita. ");
INSERT INTO omw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mwihua mwitaa tuvaro Iesusiva nkyiari timwa nyinro tiqaro, Haaru nkyi haivaqava Ntevitivavata, mwia vatama kyeta nruhuavata, nraataa huvata varuvaro Ntevitiva mwi entara mwitaa hura mwi quara nkye hia qaraqi kyaara ntumwa kyeta riaarave iho? ");
INSERT INTO omw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mwi entara Ntevitiva Kotira nraamwuqi vera ntero mpereti Kotirani vatora vara kyero nreqanro nteqa kyero nai mwiavatama kyeta nruhuavata hini nyuvata nronrave. Kotira kyaiqa vara mwate varu vaisihua nraahu nraataara vahuvaro qumina vaisivanto hia qio nraananrove tu quara Ntevitiva qumina vaisivanto mwi kyarara nreqanronra tiro, mwi quara nteqa kyorave. ");
INSERT INTO omw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nkye Mosesira qua mpo hia kyaara ntumwa kyeta riaarave iho? Kotira kyaiqa vara mwate varia vaisihua mwaanra entaqaa Kotira nraamwuqi mpo kyaiqa mpo kyaiqa vare variarave. Mwihua mwaanra entaqaa mwi kyaiqara varaqita viqata qao timwa taa quara nteqakye variavaro quavanto hia mwihuaqaa vahirave. ");
INSERT INTO omw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nkye Kotira nraamwuanra nronraqama kyeta rie variarara nte nkyi timwa nyinrenrave. Kotira nraamwu nraatara kyauva nte mwainima varuqo. ");
INSERT INTO omw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kotira mpukuqi mwitaama tiro: Vaisivanto quara rukyeqaro mpi kyaiqara hia mwi kyaiqarara ni mutukya ntihana varuqo. Vaisivanto mporara po kye timwa mwateqaro kyaahaqama mwataira, nte mwi kyaiqararama ni mutukya ntihana varuqo, turave. Nkye mwi quara okyara ntapihi kyeta rieqata nrohiatirio, nkye hiama qati varia vaisihuaqaa qua vate variatirio. ");
INSERT INTO omw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ni mwatani mwatatai nraaqiarara nronraqama kyaihana variqana nte mwaanra entaqaa ntaqikyiqana qioma ntena kyakya hiani kyaiqara varaaninrave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesusiva mwini kyero vuva uro mwihua mwaanra nraamwu mpoqi varura. ");
INSERT INTO omw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Varuvaro vaisi mpovanto mwia kyauqu tapanra vuva varuvata mwiqi varuhua Iesusiraqaa qua vatarera uti variqata mwia ntumwahiamwa hita tiqata, Vaisivanto mwaanra entaqaa hena vaisi mwamwanta kyuqema mwatairera, mwiva mwitaa hiqaro tiri mwaanra qua nteqave kyaananro, hiave nteqa kyaananrove? tita. ");
INSERT INTO omw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mwihua mwitaa tuvaro Iesusiva nkyiari timwa nyinro tiqaro, Nkyiqitairo vaisi mpo sipisipivanto mwaanraqa mwata quvuteraqi ntumwa virera, mwi vaisiva nai sipisipi pati mwaanri qatinani kyaananrove iho, hiave pati mwaanri kyaananrove? (Mwiva mwaanra entaqa nai quara pati mwaanri kyaananrove.) ");
INSERT INTO omw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Vaisivanto sipisipi nraatara kyairara tiro, vaisivanto mwaanra entaqa vaisi mpo kyuqema mwatairera, hiama Mosesira mwaanra qua nteqa kyaananrove. Mwitaa hiqaro mwiva kyuqe kyaiqa varaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mwitaa timwa kyero Iesusiva vaisi mwianra tiqaro, Ena kyauqu tutuante, tuvaro nai kyauqu tutuvaro mwia kyauquvanto kyuqema viro hini kyauqu votima viro vahura. ");
INSERT INTO omw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mwaanra entaqaa mwia kyauqu kyuqema kyovata Parisi vaisinramwu veva nteta viqata Iesusira ru kye quara nai timwa mwi nai timwa mwi hi varura. ");
INSERT INTO omw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mwihua mwia ru kyarerata qua ti varura Iesusiva riero mwi mwatukyara kyero vuvata nraakye qora airivanto mwia vataqita vuvaro Iesusiva mwihuaqitai nriqa vuhua ekyaa kyuqema kyero ");
INSERT INTO omw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","mwihuara tiqaro, Hia nte kyaiqa varaaninranra mpohua timwa nyiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iesusiva mwitaa timwa kyero mwitaamaqiro vuvaro haaru Aisaiaava vetato entaqaa tu quava mwivau vahura. Aisaiaava Kotiva mwitaama tiho, tiro: ");
INSERT INTO omw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ni kyaiqa vaisi taqaate. Nte mwia vara mwaamwianra taurave. Ni mutukyavanto mwianra vaihana nte mwianra qamwateqana varuqo. Nte ntena mwanraqura mwiaqaa vataariro mwiva avuqavu hiani okyarara mpo mwatanaa mpo mwatanaahua ekyaa timwa nyiananrove. ");
INSERT INTO omw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mwiva hia antua qua tiraitiro, hia aakyara ntamwa kyero timwaqiro virata aanraqaataitavata nraakye qoravanto hia mwia qua rievarave. ");
INSERT INTO omw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Omwave quntove ntavaka viro vahianinra mwiva hia mwini ekyaara nteqa kyaananrove. Omwa qipa virera uti varianinra hia mwiva ekyaara qipa kyaananrove. Mwiva mwitaa hiqaro qihaakyama kyero variqiro viraro avuqavu hiani okyarava nritarero vahiananrove. ");
INSERT INTO omw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ekyaa mpo mwatanaa mpo mwatanaahua mwia nrutu rieqatama mwiva nraahu tiri kyaahaqa hiarivave tivarave, tura. Kotiva mwitaa tiho timwa kyero haaru Aisaiaava mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Iesusiva varuvata mpo uhua vaisi mpo vita vareta nrunra. Vaanavanto mwia utaqi varuvarora tiro, mwi vaisiva vu qipa vuva variqaro hia quavata tiraitiro varuvaro Iesusiva mwia kyuqema kyovaro mwi vaisiva qio taqeqaro qio quavata ti varura. ");
INSERT INTO omw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mwitaa huvata nraakye qora mwini varuhua mwi kyaiqara taqeta nrihanrama vita Iesusirara tiqata, Qikye, Ntevitira mwaaquvanto qovara hiariva mwaa mwi vaisivave iho? tita. ");
INSERT INTO omw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mwihua mwitaa tuvata Parisi vaisinramwuvanto mwi quara rieta qaqao tita, Pierisepuriva vaana vunyaava Iesusira kyaahaqa hi variharora tiro, mwiva qio vaana site varihata nritareta vi variavo, tita. ");
INSERT INTO omw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Parisi vaisinramwuvanto mwitaa ti varuvaro Iesusiva mwihua su nyaato tura ntapihi kyero mwihuara tiqaro, Kuaa mwatanaa variqaro tukyama viro nai ri nai ri hi variariva qamwanramama taiqa quananrove. Ta mwatanaavave, ta mwatukyaraqinaavave, ta nraamwunraqi varihuave mwitaa hivera, mwihua qamwanrama taiqa vivarave. ");
INSERT INTO omw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Saataaniva ntaqikyi variari vaanahua utaqa ntainra vita nai ri nai ri hivera, nataama kyerove Saataaniva mwihuaqaa ntaqikyiqiro vi variraro kepukyaqama vahiananrove. ");
INSERT INTO omw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nkye nianra tiqata, Pierisepuriva mwia kepukyaqama kyaiharora tiro, mwiva vaana site varivave. Nianra mwi quava qutaa vahirera, mpo tava nkyi vaisi mponramwu kyaahaqa hi varihatave mwihuavata vaana site variavo? Nkye nianra qia quarara nkyi sataqita nrohi varia vaisihuama unra quave tivarave. Nkyi sataqita nrohi varia vaisihua ti quava nkyi tu varaananrove. ");
INSERT INTO omw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kotira mwanraquravanto ni kepukyaqama kyaihana nte vaana site varuqo. Mwi quava qutaa qua vahirara tita, nkye mwianra rieqatama Kotiva tiriqaa ntaqikyiari entava nri ntaiho qiate. ");
INSERT INTO omw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Qaiqaavata nkyi timwa nyinrenrave. Nraamwu qova kepukya vaisivanto variraro mpuara vaisivanto hia mwia rupataraitiro, mwia nraamwuqitairo hia qio mpuara varaananrove. ");
INSERT INTO omw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Hia nivatama kyero variariva, mwi vaisiva ni nramwutaama variananrove. Mpovanto ni sipisipi hia nyaanrama kuaaqaa mataariva varirera, mwi vaisiva ni sipisipi sataqiro uro mpona mpona raupirima kyaarivama variananrove. ");
INSERT INTO omw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mwianra rieqanama nte nkyi timwa nyuqo. Nraakye qoravanto uaqia hi kyaiqara mpo qara mpo qara hianinra utirave, uaqia hi quara mpo qara mpo qarama kye mpohuara tirave, Kotiva ekyaa mwi quara nruka nyaterovata vaisivanto Kotira mwanraqurara uaqia hi quara qianinra hiama nruka mwataananrove. ");
INSERT INTO omw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Vaisi mpovanto ni mwatani mwatatai nraaqiarara uaqia hi quara tirera, Kotiva mwi vaisira qua nruka mwataananrove. Vaisi mpovanto Kotira mwanraqurara uaqia hi quara tirera, Kotiva mwaa entaravata, nraakiaravata, hia mwi vaisira qua nruka mwataananrove. ");
INSERT INTO omw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kyatarivanto kyuqe kyatari vahirera, kyuqe tamwa riaananrove. Uaqia hiari kyatariva vahirera, uaqia hi tamwanra riaananrove. Vaisivanto kyatari tamwa mwia taqeqaro mwi kyatarirara kyuqe kyatarive, uaqia hi kyatarirave, qiananrove. ");
INSERT INTO omw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nkye quaiha uaqia hira nraaqiarama variavo. Nkye uaqia hia vaisihua variqata nkye nataama kyetave kyuqe qua tivarave? Mwia mwutukyaqive mwia nraatoqive mpo inraikya varaariva vaiharo nrovanto timwa qovara hirave. ");
INSERT INTO omw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Vaisi kyuqeva nai qiataqitairove vu nraatoqitairove kyuqe kyaiqa varaariva vaiharora tiro, mwiva kyuqe kyaiqa nraahu vare varirave. Uaqia hi vaisiva nai qiataqitairove vu nraatoqitairove uaqia hi kyaiqara utuariva vaiharora tiro, mwiva uaqia hi kyaiqara uti varirave. ");
INSERT INTO omw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nte qianinra riaate. Nraakiara ekyaara entaqaa Kotiva ko tiqaroma mwaa entara nkye mpo qua mpo qua qumina qua ti varirara rieqaroma Kotiva nkyiara nkye nanraqamave mwi quara mwatani varu entara turave, qiananrove. ");
INSERT INTO omw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nkye mwaa entara kyuqe qua nraahu timwaqita vivera, mwi entara nkyita quavanto nkyi huvantu nyataananrove. Nkye mwaa entara uaqia hi quara timwaqita vivera, mwi entara nkyita quavanto nkyita rupaananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Iesusiva mwitaa timwa kyero varuvata Parisi vaisi hininramwuvata, mwaanra okyara ti varu vaisihuavata, Iesusirara tiqata, Mwaanra ti variara vaisio, nronra kyaiqa tirinramwu tivuqaa varairaqetama tire i okyara taqetama qutaama e Kotiva titaihara tumuanra vaisiva variaro qiare, tita. ");
INSERT INTO omw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mwinramwuhua mwitaa tuvaro Iesusiva tiqaro, Uaqia hi kyaiqara nraahu uti variahuave, Kotirara qumimaqama kyeqata nrohi variahuave, mwitaa hiahuama nronra kyaiqa tinraamwutairaqeta qutaave qiare ti variarave. Hia nte nkyi suqaa nronra kyaiqa vararerave. Kotiva haaru nkyi haivaqara poropeti vaisi Ionaanra mwitaama kyontema kyero Kotiva nivata mwitaa hiananrove. Mwianra rieqatama nkye nianra Kotiva titaivave tivarave. ");
INSERT INTO omw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tavukya nronravanto mwia atahu kyovaro Ionaava taarampo enta entaqivata iheravata tavukya vikyokyaqi varurave. Kuaa qarama kyena ntevata mwatani mwatatai nraaqiarava taarampo enta mwata utaqi variqina quaninrave. ");
INSERT INTO omw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ionaava taarampo enta tavukya vikyokyaqi variro mwiaqaatairo uro Niniveqi varuhua Kotira qua timwa nyuvata mwi mwatanaahua qamwanrama kyeta mwia qua rieta uaqia hu aanranra qaqira kyeta varurave. Nraakiara ekyaara entaqaa mwi mwatanaahua Kotiravatama kyeta variqata nkyiqa qua vateqata mwitaama tivarave, Tire Ionaanra qua rieqatama uaqia hi aanranra qaqira kyaavananrave. Ionaanra nraatara kyo vaisiva nkye varunani uro ntovata nkye hia mwia qua riorave, tivarave. ");
INSERT INTO omw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Haaru vetato entaqaa nkyi haivaqava Soromoniva mpo okyara mpo okyara taqe varuva varuvaro vunyaa nraakye mpovanto mwia qua riarero vevara nai nyianra taisairo uro Soromoninra qua riorave. Mwi nraakyeva mwitaa hurara tiro, mwivavata nraakiara ekyaara entaqaa nkyiqa qua vateqaro mwitaama qiananrove. Nte nyianrasaina Soromoninra qua riarerana nriavarave. Nkye haaru varuvaro Soromoninra nraatara kyo vaisiva varuvata nkye hia mwia qua riorave, qiananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Iesusiva mwitaa timwa kyero tiqaro, Vaanavanto vaisi utaqitairo nritarero quariva aahara mwataqaa viqaro kyai nte ho hiankye timwa kyero taqairaro hia ho hiariva vahiraro ");
INSERT INTO omw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","mwiva nai tiqaro, Kyai nte nrumu ntantena vaakya qaqira kyau nraamwunra vaisi utaqi uro qaiqaa variankye, timwa kyero uro taqaiharo mwi nraamwuva qumina vaiharo ntupi kyero hiqama kyero avuqavuma taiva vahirave. ");
INSERT INTO omw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mwiaqaatairo vaana mwiva uro nai hena vaana 7 nramwu nai mwiavata nraatara kyeta uaqia hi kyaiqara uti variahua nyaanrama kyero sita varero uro mwi vaisira utaqi varirave. Nraakiara mwi vaisiva vaana airi kyapata variqaro anoma kyero uaqiama viro varirarama tuqo. Mwaa entaravata uaqia hi kyaiqara uti varihua, mwihuavata uaqiama vita varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesusiva mwi quara nraakye qora timwa nyi varuvata mwia nrovavata mwia qatanramwuvata nri nteta mwia qua timwa mwinrenrata mwaatani sivita varuvaro ");
INSERT INTO omw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","mpovanto Iesusira uro timwa mwinro tiqaro, I nrohua qata i qua timwa mwinrenrata nrumu mwaataqa variavo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mwiva mwitaa tuvaro Iesusiva tiqaro, Tahuave ni ntohua kata pakyaa variavo? tiro. ");
INSERT INTO omw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mwitaa timwa kyero Iesusiva nai nraaqiara mwinramwuhuaqa kyauqu tutiro tiqaro, Mwaahuama ni ntohua kata pakyaa variavo. ");
INSERT INTO omw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ni kova nyaamwuni varira mwia qua rieqata nrohi variahua, mwihuama ni kata pakyaa, ni nunra nakyaa, ni ntohua variavo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kuaa mwi entara Iesusiva nraamwu mwiqitairo veva ntero uro kyaarera tokyasataa mwatakyaa viro mwini variankye tuvata ");
INSERT INTO omw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","nraakye qora airivanto ntuvaantuama vita mwia ututuma tovarora tiro, mwiva qaqira kyero uro mpotuqi mwaanri ntero mwiqi mwatakyaa viro nramanriqaa varuvata nraakye qoravanto nramanri tokyasataa varuvaro ");
INSERT INTO omw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Iesusiva mpo qua mpo quaqaa ntumwa kyeqaro timwa nyunra. Mwiva mwitaama tiro: Vaisi mpovanto kyara humwu isarero vurave. ");
INSERT INTO omw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mwiva kyara humwu isaqiro vuvaro mpo huva aanra tokyani tumu ntuvaro nyaamwavanto nrumu nramwa kyorave. ");
INSERT INTO omw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mpo huva ori mwataqaa tumu ntuvaro mwatavanto hia vevatoqama vahu mwatava vahuvarora tiro, tumu ntiro qamwanrama qupiqa vuvaro ");
INSERT INTO omw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","huarivanto nri ntero iteqaro aaharama kyovaro mwia tuqavanto hia mwataqi vevato vuvara tiro, aaharama vurave. ");
INSERT INTO omw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mwitaa huvaro mpo huva uakukya uvi auquqahuva qupiqoraqi tumu ntiro uakukyavatama kyero qupiqa vuvaro uakukyavanto ntumwaqu kyovaro hia tamwa riorave. ");
INSERT INTO omw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mwitaa huvaro kyara humwu hinivanto kyuqe hu mwataraqaa tumu ntiro kyuqema kyero qupiqeqaro uro kyuqe tamwa airi riemwa torave. Airi riemwa tovaro mpo huva mwiavata nraatara kyero mpoqiavata riemwa tovaro qaiqaa mpo huva mwiavata nai nraatara kyero nronraqama kyero riemwa torave. ");
INSERT INTO omw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nkyi nyaato vahirera, mwi quara okyara ntapihi kyeta riaate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iesusiva mwi quaraqaa ntumwa kyero timwa nyuvata mwia nraaqiaranramwuvanto mwiva hunani nri nteta mwia ntumwahiamwa hita tiqata, E nanraqamave nraakye qora hia qua vutu kye timwa nyinraitira, mpo quaqaa ntumwa kyeqara timwa nyi variaro? tita. ");
INSERT INTO omw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mwihua mwitaa tuvaro Iesusiva timwa nyinro tiqaro, Kotiva nraakye qoraqaa ntaqikyiani quara uqetatai quara, mwi quara nkyiara mwihua qati kyairata mwi quara okyara riaate timwa kyero, qumina nraakye qorara hia mwi quara riaate turave. Mwitaa turara tina, nte mpo quaqaa ntumwa kyeqana mwihua timwa nyi varuqo. ");
INSERT INTO omw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kotira qua riaariva variqiro viraro Kotiva mwia kyaahaqa hiraro mwia qua mpoqiavata riaarive. Mwiva mwitaamaqiro viqaro Kotira qua mpoqiavata riaananrove. Kotira qua hia riaariva variqiro viraro mwiaqaatairo pataqia tutaaninra mwia ntavihikye varairaro mwiva qumina variananrove. ");
INSERT INTO omw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nraakye qoravanto taqeqatavata hia ntapihi kyeta taqe variarave. Mwihua qua rieqatavata hia ntapihi kyeta riaarave. Mwihua mwitaa hiarara tina, nte mpo quaqaa ntumwa kyeqana mwihua timwa nyi varurave. ");
INSERT INTO omw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nraakye qoravanto mwitaa hi variarara tiro, haaru vetato entaqaa Aisaiaava Kotira qua qovarama kyo quava mwaa entara mwivauma vahiro. Mwiva mwataama tiro: Mwaa mwatanaahua su nyaatovanto qumimaqama vihatara tita, mwihua qua riemwaqita viqatavata hia qua ntapihi riaarave. Mwihua taqamwaqita viqatavata hia ntapihi kyeta taqaarave. ");
INSERT INTO omw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mwihua su nyaato mwutukyavanto kepukaqama vihata mwihua nkyiari nyaato titateta nkyiari su qipateta variarave. Mwihua hia mwitaa hiraitita, mwihua nkyiari suqotaita taqeqata nkyiari nyaatoqotaita rieqata ni qua ntapihi kyeta rieqata uaqia hi aanranra qaqira kyaivaqenavauma nte mwihua kyuqema kyaaninrave, turave. Aisaiaava Kotiva mwitaama tiho, turave. ");
INSERT INTO omw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Qio, nkyenramwu vuqotaita kyuqema kyeta taqe variqata nraatoqo kyuqema kye rie variarara tita, nkye qamwateqatama varivarave. ");
INSERT INTO omw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Haaru vetato entaqaa poropeti vaisivantove, kyuqema kyeta nraahu kyuqe aanraqaa nrohi varu vaisihuave, mwihua nkye mate taqaa inraikyara taqaare tura hia taqorave. Mwihua nkye mate riaa quara riaare tura hia riorave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Mwitaa timwa kyero Iesusiva nai nraaqiaranramwu timwa nyinro tiqaro, Nkyenramwu rie varivaqena nte kyara humwu isaqiro vu vaisiraqaa ntumwa kyena timwa nyu quara, mwi quara okyara nkyi timwa nyiankye. ");
INSERT INTO omw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kotiva nraakye qoraqaa ntaqikyiani quara, vaisi mpovanto mwi quara hia ntapihi kyero riaraitiro variharo Saataaniva nri ntero mwia mwutukya vu nraatoqitairo mwi quara ntavihi kyero varairave. Mwi vaisiva kyara humwuvanto aanra tokyani tumu ntira votima kyeroma variho. ");
INSERT INTO omw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kyara humwu mpo huva ori mwataqaa tumu ntu okyarava vahirero mwataamama vahiro. Vaisi mpo hiahua Kotira qua rieta, mwi quarara qamwata kyeta variavaro ");
INSERT INTO omw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","quavanto hia mwihua mwutukyaqi tuqa tuta kyero vaihata mwihua hia mpuahaama variqata mwi quara rieta. Mwi quara kyaara mwihua uaqiama nyatarera uti variavata mwihua tiri rivorave timwa kyeta Kotira qua qamwanrama kyeta qaqira kyaarave. ");
INSERT INTO omw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kyara humwu mponramwuvanto uakukya uvi auqu vahuraqi tumu ntuva mwia okyaravanto vahirero mwataamama vahiro: Mpo hiahua Kotira qua rieta mwiaqaataita mwihua mwatanyaa inraikyara nronraqama kyeta rieqata munimanrave mpo inraikya mpo inraikyara qamwateqata mwia varerara nraahu nronraqama kyeta riemwaqita viqata Kotira qua qaqira kyaavaro Kotira quavanto hia mwihuaqi vahiqiro virave. ");
INSERT INTO omw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kyara humwu mponramwuvanto kyuqe hu mwataraqaa tumu ntura okyaravanto vahirero mwataamama vahiro: Mpo hiahua Kotira qua ntapihi kyeta rieta mwiaqaataita mwihua Kotira qua riemwaqita viqata kyuqe kyaiqa Kotirani varaqita vi variavata mpohua Kotira qua riemwaqita viqata mwihuavata nraatara kyeta mpoqiavata kyuqe kyaiqa varaqita vi variavata qaiqaa mpohua Kotira qua riemwaqita viqata mwihuavata nraatara kyeta Kotira kyaiqa varaarave, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesusiva variqaro mpo quaqaa ntumwa kyero nraakye qora timwa nyinro tiqaro, Kotiva nraakye qoraqaa ntaqikyiariva vahirero mwaa quara votima kyero vaiho. Vaisi mpovanto kyuqe humwu uiti humwu nai utaqi isorave. ");
INSERT INTO omw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Isatovata ekyaahua entaqi vaita vita hia taqovaro mwia nramwutaa mpovanto nri ntero uiti isatoraqi uakukyavata isatorave. (Mwi uakukyava vahirero mwia vekyavata mwanrevata uiti voti iharo mwia tamwa nraahu hia kuaa qara hirave.) Mwia nramwutaavanto uaqia hi humwunra isatero vuvaro ");
INSERT INTO omw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","uitivanto uakukya vatama kyero kuaaqi qupiqero qauma tamwa riarero utuvata mwia kyaiqa vaisinramwuvanto taqovaro mwi uakukyava uiti vatama kyero qupiqero vahurave. ");
INSERT INTO omw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Taqeta mwia kyaiqa vaisinramwuvanto uro aakyo qora kyapara hita tiqata, Nronrao, e kyuqe humwu isataananrave iho? Taisairove mwi uakukyava qovarama viho? tita. ");
INSERT INTO omw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mwitaa tuvaro aakyo qova tiqaro, Qikye, ni nramwutaa mpovanto uakukya ni utaqi isataiho, tuvata mwia kyaiqa vaisinramwuvanto mwia kyapara hita tiqata, Qiove tire uro mwi uakukyara ntaru kyaananrave? tuvaro ");
INSERT INTO omw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","mwiva qaqao tiro, Hia uakukya mwia ntaru kyaate. Nkye uakukya ntariqata uiti vatama kyeta ntaru kyevorave. ");
INSERT INTO omw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Qati kyaivaro uitivantovata uakukyavantovata kuaaqi qupiqaarive. Uitivanto peqaqama viraqe nte ni kyara vantu vareqata nria vaisihuara mwitaama qianinrave, Nkye mwi uakukyara nraante teqa kye rupa kyeta varaqi uro qia quara tetama mwiaqaataitama uiti teqa kyeta varaqita ni kyara nraamwuqi uro mataate, qianinrave, turave, tiro. Iesusiva mwi quaraqaa ntumwa kyero timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesusiva variqaro nraakye qora mpo quaqaa ntumwa kyero timwa nyinro tiqaro, Kotiva nraakye qoraqaa ntaqikyiani quava mwaa quara votima kyeroma vaiho. Mwiva maasiteti uru votima kyeroma vaiho. Vaisivanto maasiteti uru varaqiro uro nai utaqi vara tutorave. ");
INSERT INTO omw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mwia uru mwiva pata uapaaqiani vahirave. Mwia vara tutaiharo qupiqero kyatari nronraqama viro hini kyaravata nraatara kyero kyatari nronra vaiharo nyaamwavanto mwia kyaaraqi nraamwu hoqateta variarave, tura. Iesusiva mwi quaraqaa ntumwa kyero timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesusiva variqaro nraakye qora mpo quaqaa ntumwa kyero timwa nyinro tiqaro, Kotiva nraakye qoraqaa ntaqikyiari quava mwaa quara votima kyeroma vaiho. Mwiva taupataira votima hirave. Nraakyevanto mpereti utarera hiqaro uiti parauaa vara kyero mwia kyotaarive tiro taupataira vara kyero parauaa vatama kyero tuqasaa kyaiharo taupataiva utaqi vaiharo mperetivanto uqenra viro kyota virave, tiro. Iesusiva mwi quaraqaa ntumwa kyero timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesusiva nraakye qora mpo qua mpo qua timwa nyinrenro mwiva hia vutu kyero timwa nyinraitiro, mwiva mpo quaqaa ntumwa kyeqaro nraahu timwa nyiqiro vura. ");
INSERT INTO omw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mwiva mwitaa timwaqiro vuvaro haaru vetato entaqaa poropetivanto tu quava qutaa mwivau vahura. Mwi quava mwataama tiro: Nte nraakye qora qua timwa nyinrenra hina hia vutu kyena timwa nyinraitina, mpo quaqaa ntumwa kyeqana timwa nyinrenrave. Mwaa mwatara ututo entaraqaatairo qua uqeta kyero vataqiro vi quara hia riaara nte mwi quara okyara nkyi timwa nyinrenrave, tura. ");
INSERT INTO omw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesusiva mpo quaqaa mpo quaqaa ntumwa kyero timwa nyiqiro viro mwiaqaatairo mwiva nraakye qora mwini kyero nraamwuqi vuvata mwia nraaqiaranramwuvanto mwiva varuraqi uro nteta Iesusirara tiqata, Vaakya qiana quara mwia nramwutaavanto uakukya mwia utaqi isato quara mwi quara okyara tiri timwa timwinraqe riaare, tita. ");
INSERT INTO omw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mwia nraaqiaranramwuvanto mwitaa tuvaro Iesusiva mwinramwuhua timwa nyinro tiqaro, Vaisi mpovanto kyuqe humwu isai vaisirara tura nte mwatani mwatatai nraaqiarava nte mwaa mwivave. ");
INSERT INTO omw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Vaisi mwia aakyo okyaravanto vahirero ekyaa mwaa mwatavama vaiho. Kyuqe humwu mwia okyaravanto vahirero Kotira qua riaa nraakye qorahuama variavo. Uakukya mwia okyaravanto vahirero hia Kotira qua riaa nraakye qorahua Saataaninra nraaqiarama variavo. ");
INSERT INTO omw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mwia nramwutaavanto uakukya humwu isato vaisira okyaravanto vahirero mwiva Saataanivave. Kyara vantu vareta nru entara okyaravanto vahirero nraakiara mwaa mwatava taiqaani entavama vaiho. Kyara vantu vareta nru vaisihua okyaravanto vahirero mwihua nyaamwunyaa vaisinramwuve. ");
INSERT INTO omw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mwia kyaiqa vaisinramwuvanto uakukya teqa kye rupa kyeta varaqi uro qiaqi quara tontema kyero, nraakiara mwaa mwatava taiqaani entaraqaa mwitaa hiananrove. ");
INSERT INTO omw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nte mwatani mwatatai nraaqiarava variqi vina mwaa mwatava taiqaani entaraqaa nte nyaamwunyaahua sitaarita mwihua uto nte ntaqikyu mwataraqaataita hia kyuqe nraakye qora ni nraaqiaranramwu uaqiama nyate varihuavata, ekyaa uaqia hi kyaiqara uti varihuavata, rupaqita ");
INSERT INTO omw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","qia nronra itaaninraqi tuto kyaivata mwihua qiaqi variqa atura ntiqata ntataqi viqata nkyiari anrai teti nreqata varivarave. ");
INSERT INTO omw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mwihua mwini uro tuto kyaivata avuqavuma kyeta nrohi vari nraakye qorahua huarivanto itaintema kyeta itamwaqi vivaro Kotiva mwihua sova mwihuaqaa ntaqikyiqiro virata variqi vivarave. Nkyi nyaato vahirera, mwi quara okyara ntapihi kyeta riaate, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Iesusiva mpo quaqaa ntumwa kyero nraakye qora timwa nyinro tiqaro, Kotiva nraakye qoraqaa ntaqikyiariva mwaa quara votima kyeroma vaiho. Mwiva nronra munima vahi inraikyara uqeta taira votima kyeroma vaiho. Mwataqi mwi inraikyara uqeta taiva vaiharo vaisi mpovanto mwia puaama kye taqero, mwiaqaatairo mwiva qamwata kyero mwi inraikyara qaiqaa uqeta tero uro mwi mwatara kyoqaa hiankye timwa kyero mwiva ekyaa nai vatai inraikyara nyinro munima vara kyero uro mwi mwatara kyoqaama kyero varero uro nronra munima vahi inraikyara uqeta taira mwiavata varairave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Iesusiva mwitaa timwa kyero mwiva mpo quaqaa ntumwa kyero timwa nyinro tiqaro, Kotiva nraakye qoraqaa ntaqikyiariva mwaa quara votima kyeroma vaiho. Vaisi mpovanto kyau mwukyaari voti hira kyoqaa hirero mpo mwatukya mpo mwatukya puaahi vari vaisira votima kyeroma vaiho. ");
INSERT INTO omw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mwi vaisiva nronra munima vahira mwi inraikyara puaama kyero uro nai vatai inraikyara mpohua nyinro munima varaqiro uro mwia vatai vaisira mwinro kyau mwukyaari voti hira nronra munima vahira mwia varairave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Iesusiva mwitaa timwa kyero mwiva mpo quaqaa ntumwa kyero timwa nyinro tiqaro, Kotiva nraakye qoraqaa ntaqikyiariva mwaa quara votima kyeroma vaiho. Vaisivanto vahe nramanri nronraqi mpiami kyaavata tavukya airi mpo qara mpo qara hiahua mwiqi viqetaa quara votima kyeroma vaiho. Vahe nramanri nronraqi mpiami kyaavata tavukya airivanto mwiqi viqeteta ");
INSERT INTO omw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","piqavita variavata vaisivanto vahe mwia ntanrauqita uro nramanri tokyani kyeta mwiqitai tukyama kyeta tavukya kyuqe hiahua vara kyeta mpo tuaqi ntumwa teta uaqia hiahua vara kyeta qaqira kyaarave. ");
INSERT INTO omw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nraakiara ekyaara entaqaa mwia votima kyero vahiananrove. Mwi entara nyaamwunyaahua tumu nteta nraakye qora tukyama kyeta ntapihi kyeta nrohi varihua qati kyeta, uaqia hi kyaiqara uti vari nraakye qorahua ");
INSERT INTO omw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","sitaqita uro qia nronra itaaninraqi tuto kyaivata mwihua mwiqi variqata atura ntita ntateqata nkyiari aanrai kutiqata varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesusiva mwitaa timwa kyero nai nraaqiaranramwu kyapara hiro tiqaro, Nkye mwi quara mwi quara nkyi timwa nyunra ntapihi kyetave riaavo? tuvata mwinramwuhua eo tuvaro ");
INSERT INTO omw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","mwiva mwinramwuhua timwa nyinro tiqaro, Kotira haaruaa qua okyara timwa nyi vari vaisihuaqitairo mpovanto Kotiva nraakye qoraqaa ntaqikyiani quararavata qutaave timwa kyero Kotira nraaqiaraqama quariva, mwi vaisiva nraamwu mpo qova votima kyeroma variro. Mwi vaisiva nai nraamwuqi mpo inraikya mpo inraikya vatairaqitairo haaruaa inraikya kyuqe inraikyavata, qaraakya inraikya kyuqe inraikyavata, vare varirave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesusiva nraakye qora mpo qua mpo quaqaa ntumwa kyeqaro timwa nyi taiqa kyero mwiva mwi mwatukyara kyero ");
INSERT INTO omw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nai mwaatani nrumu ntantero uro mwaanra nraamwuqi variqaro mpo qua mpo qua timwa nyuvata nraakye qoravanto nrihanrama vita tiqata, Qikye, mwi vaisiva taisairove mwi quara mwi quara kyuqe qua riaiho? Tava mwia kepukya mwihanrove mwiva nronra kyaiqa vare variho? tita. ");
INSERT INTO omw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mwihua mwitaa timwa kyeta qaqao tita, Mwi vaisiva nraamwu hoqe vari vaisira mwaaquvantoma variho. Mariaava mwia nrovama variho. Iemisivavata, Iosepivavata, Saimonivavata, Iutaasivavata, mwinramwuhua mwia qatanramwuma variavo. ");
INSERT INTO omw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mwia nrunranramwu mwaini tirivata variavo. Taisairo mwiva mwi kyaiqara mwi kyaiqara okyara taqairave? tita. ");
INSERT INTO omw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mwitaa timwa kyeta mwihua Iesusirara tiqata, Mwiva hia nronra vaisive. Mwiva qumina mwaa mwatanaava nraahuma variho, timwa kyeta mwia qoririma mwatora. Mwihua mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Poropeti vaisivanto mpo mwatani iro variraro mwi mwatanaava mwianra nronra vaisive tiroma mwianra qamwata mwataananrove. Mwi vaisiva nai mwaatani uro nai nramwunaahua vatama kyero varirata mwia nramwunaahua mwianra qumina vaisima tiri votima kyero nraahuma variho tivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iesusiva mwitaa timwa kyero mwi mwatanaahua mwianra qumina vaisivanto hia tiri qio kyaahaqa hiarivave turara tiro, Iesusiva mwini variqaro nronra kyaiqa pataqiatana nraahu vara nyatora. ");
INSERT INTO omw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mwi entara Herotiva vunyaa vaisivanto Kaririqaa ntaqikyi variqaro nraakye qoravanto Iesusirara ti varu quara riora. ");
INSERT INTO omw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Riero Herotiva nai kyaiqa vaisiara tiqaro, Qikye, mwi vaisiva Ionivave. Ioniva nramanri nyi varu vaisiva qutu vuraqitairo qaiqaa qati siviro nrohi variho. Mwiva qaiqaa qati siviro nrohiqarora tiro, mwiva nronra kyaiqa qio vare variho, tiro. ");
INSERT INTO omw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Tauraaqama Herotiva nai qata Piripira nraata Herotinamainra varero varuvaro Ioniva Herotira timwa mwinro tiqaro, E ena qata nraata hia varaataara vaiharama varaaro, tuvaro mwi quara kyaara Herotiva vaisi mpo titovaro Ioninra ntavaaqavu kyero mwia rupaqiro nrumu karavuqi kyora. ");
INSERT INTO omw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herotiva Ioninra ru kyaataa huvaro nraakye qora nraatu aatu hiqaro hia mwia ru kyora. Nraakye qora Ioninranra poropeti vaisivantove tuvarora tiro, Herotiva nte mwia rukyaarita ni inronra hivorave timwa kyero varura. ");
INSERT INTO omw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mwitaamaqi viro Herotiva nai mwato entava qovara huvaro mwi entaraqaa vaisi mponramwuanra aakyara ntovata nrita ntuvaantuama vuvaro Herotinamainra nraamwunravanto mwihua ihi ntamwa nyatovaro Herotiva mwia taqero mpoqama kyero qamwata mwatero ");
INSERT INTO omw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","nai kyauqu nriqiqaa vatero tiqaro, Nanra inraikyarave i mwutukya vahianinra ni timwa mpiraqe i mwiankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mwitaa tuvaro mwi mwanraatava nai nronra kyapara huvaro mwia nrova mwi quara qiante tuvaro mwi mwanraatava Herotirara tiqaro, Ioniva nramanri nyi vari vaisira mwia qiata taanuqa vatera varaqira nrumu ni mpiante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mwitaa tuvaro Herotiva vunyaava varuvaro mwia mwutukyavanto uaqia huvaro variqaro mwiva vaakya kyauqu nriqiqaa vateqaro kyara nranrenrata nrumu varu vaisihua suqaa timwa to quarara rieqaro mwiva vaisi mpo titero mwi mwanraatava tintema kyera mwitaa hiante tuvaro ");
INSERT INTO omw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","mwi vaisiva uro karavuqitairo Ioninra nrunta pehi kyero ");
INSERT INTO omw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ioninra qiata taanuqa vatero varaqiro uro mwi mwanraatara mwuvaro mwiva nai nronra uro mwunrama. ");
INSERT INTO omw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ioninra vataqi nrohu vaisihua nrumu Ioninra mwamwanta varaqita uto quntamwa teta mwiaqaataita mwihua uro Iesusira timwa mwunra. ");
INSERT INTO omw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ioninranra Iesusira uro timwa mwuvaro Iesusiva mwi quara riero mwini kyero mpotuqi mwaanri ntero nai nraaqiaranramwu kyapata nkyiariaraa varirerata hia vaisi varunani vuvata nraakye qora airivanto mwihua vu quara rieta mpo mwatukya mpo mwatukyaqitaita mwihua mwatantuna Iesusira vataqita vura. ");
INSERT INTO omw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Vuvaro Iesusiva mpotuqi nramanriqaa vuva uro ntero taqovata nraakye qora airivanto ntuvaantuama vita varuvaro mwiva mwihuara po kye timwa nyatero mwihuaqitairo nriqa vu nraakye qorahua kyuqema nyatora. ");
INSERT INTO omw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Iesusiva mwini varuvaro huarivanto tumi vuvata mwia nraaqiaranramwuvanto mwiva hunani uro nteta tiqata, Mwaini quminasatave. Enta hiankyorave. Nraakye qora mwaahua sitairata uro mwatukya vahianinraqitaita kyara kyoqaama kyeta nraate, tita. ");
INSERT INTO omw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mwia nraaqiaranramwuvanto mwitaa tuvaro Iesusiva qaqao tiro, Hia mwihua sitaivata quate. Nkyetavanto mwihua kyara nyivata nraate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iesusiva mwitaa tuvata mwinramwuhua qaqao tita. Tire taqauraro mwaini mpereti kyauquruvata tavukya taaratanavata nraahuma vaiho, tita. ");
INSERT INTO omw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mwihua mwitaa tuvaro Iesusiva mwi kyarara mwaini vara ni mpiate timwa kyero ");
INSERT INTO omw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","nraakye qorara mwukyausata mwatakyaa vita variate timwa kyero mwiva mpereti kyauquruvata tavukya taaratanavata vara kyero nyaamwuni taqeqaro Kotirara kyuqeve timwa kyero mpereti nteqa kyero mwi kyarara nai nraaqiaranramwu nyuvata mwihua nraakye qora ekyaa tukyama kyeta nyuvata ");
INSERT INTO omw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","mwihua ekyaa qio nronra. Ekyaa nraakye qoravanto qio nrovata mwiaqaataita mwia nraaqiaranramwuvanto ntutantuto tuara tua nronra vareta mwihua nreqata viti vaati kyo kyarara utu kyeta tua 12 nramwu piqa kyora. ");
INSERT INTO omw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mwi entara vaisi nraahu 5,000 vanto nrovata nraakye nraaqiara airivantovata mwi kyarara nronra. ");
INSERT INTO omw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Iesusiva kyara nyitero mwiaqaatairo nai nraaqiaranramwu sitero tiqaro, Nkye mpotuqi mwaanri nteta kyaareraqaama teta hini tokyani nkye nraante vi varivaqe nte nraakye qora sitaarita nkyiari mwaatani mwaatani quate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mwitaa timwa kyero mwiva nraakye qora nkyiari mwaatani sitamwa kyero mwiaqaatairo Kotiravata qua tirero verara taaqiqaa vuvaro entama vuvaro mwiva mwini nanrianraa varura. ");
INSERT INTO omw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Varuvaro mpotuvanto nramanri utaqaa vuvaro toqavanto mwihua virera hunasairo nruvarora tiro, nramanrivanto mpotu ventaqiro vi varura. ");
INSERT INTO omw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Toqa ti varuvaro nramanrivanto mpotu ventaqiro vi varuvaro qaumakyaa qaatatarero huvaro Iesusiva kyaarera mwutuqaa kyuquqo ntamwaqiro viro mwihua hunani vuvata ");
INSERT INTO omw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","mwia nraaqiaranramwuvanto taqovaro mwiva kyaarera mwutuqaa kyuquqo ntamwaqiro nruvata mwihua mpoqama kyero nyaatuqa tovata vaanave tiqata nronraqama kyeta aatu hi variqata qua aakyara nte varuvaro ");
INSERT INTO omw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iesusiva qamwanrama kyero mwihuara tiqaro, Kepukyaqama kyeta qati variate. Ntema nruqo. Hia aatu hiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Iesusiva mwitaa tuvaro Pitaava tiqaro, Nronrao, qutaa e varirera, tiraqe ntevata kyaarera mwutuqaa kyuqu ntamwaqina e hiananrani quankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Pitaava mwitaa tuvaro Iesusiva tiqaro, Qio nriante, tiro. Mwitaa tuvaro Pitaava mpotuqitairo mwaamwi ntero kyaarera mwutuqaa kyuquqo ntamwaqiro Iesusiva hunani viro. ");
INSERT INTO omw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mwiva mwini viqaroma qio quaninrave timwa kyero taqovaro toqavanto nronraqama kyero tuvaro mwianra rieqaro mwiva aatu hi varuvaro mwia kyuquvanto nramanriqi mwatanianra vi varuvaro mwiva Iesusirara aakyara ntero tiqaro, Nronrao, ni tu varaante, tuvaro ");
INSERT INTO omw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Iesusiva qamwanrama nai kyauquqo viti kyero mwia tu varero tiqaro, E toqavanto tirara nraahu rieqara hiama nianra kepukyaqama kyera riaaro. Nanraqamave e taara nraato tutaaro? tiro. ");
INSERT INTO omw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Iesusiva mwitaa timwa kyero mwikyantiri mpotuqi mwaanri ntovaro toqavanto qamwanrama taiqa vura. ");
INSERT INTO omw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mwitaa huvata mwia nraaqiaranramwu mpotuqi varuhua Iesusirara qamwateqata mwahuta timwa mwateta tiqata, E qutaama Kotira mwaaquvanto variaro, tura. ");
INSERT INTO omw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mwinramwuhua mwitaa timwa kyeta mpotuqi nramanriqaamateta Kenesaretini uro ntora. ");
INSERT INTO omw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Uro ntovata mwi mwatanaahua Iesusira ntapihi kyeta taqeta qua vara kyovaro ekyaa mwia nraaqani vahu mwataraqi viro nrinro huvata ekyaa mwi mwatanaahua nriqa vu nraakye qorahua sitaqita nrumu Iesusiva varunani kyetama ");
INSERT INTO omw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Iesusirara po tita tiqata, Kyairata mwihua i vaaqa vitiqaa kyaatu kyaivaro mwihua nyamwanta kyuqema quarive, tuvata Iesusira vaaqa vitiqaa tu varohua kyuqema nraahu vura. ");
INSERT INTO omw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisi vaisinramwuvata, mwaanra okyara ti varu vaisihuavata, Iesusira taqarerata Ierusaremisaita nri nteta Iesusira kyapara hita tiqata, ");
INSERT INTO omw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Nanraqamave i nraaqiaranramwuvanto tiri haivaqahua timwa to quara nteqa kye variavo? I nraaqiaranramwuvanto hia kyauqu hiqaraitita, kyara nre variarave, tita. ");
INSERT INTO omw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mwihua mwitaa tuvaro Iesusiva nkyiari timwa nyinro tiqaro, Nkye mpo, nanraqamave Kotiva vatai quara hia riaraitita, nkyeta qua nraahu riemwaqita vi variavo? ");
INSERT INTO omw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kotiva mwitaama tiro: Ena nrohua qohua nrutu tuaahera nyataante, timwa kyero Kotiva qaiqaa tiqaro, Nai nronra qorara uaqia hi quara ti variani vaisira ru kyaate, turave. ");
INSERT INTO omw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kotiva mwitaa timwa to quava vaihata nkye mwi quara hia riaraitita, nkyeta riemwa kyeta nkye tiqata, Vaisi mpovanto nai nrohua qohuara tiqaro, Nte nkyitana kyaahaqa hiqana nyinrenra hiani munimanra hia nkyitana nyinraitina, Kotira mwinrenrave, tirera, ");
INSERT INTO omw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","mwi vaisiva qioma nai nrohua qohua qaqira kyero hia mwitanahuaqaa ntaqikyiqiro quananrove, qiarave. Nkye unra qua timwa kyeqatama nkyi haivaqahua timwa to quara nraakye qora timwa nyiqata nkye Kotira qua ru kyeta hiavo. ");
INSERT INTO omw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nkye unraqama kyeqata kyuqe kyaiqa vare variahuave. Aisaiaava haaru variqaro nkyiara ntapihi kyero qua qara ntumwa torave. Aisaiaava Kotira qua qovarama kyeqaro Kotiva mwitaama tiho, tiro: ");
INSERT INTO omw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Mwaa mwatanaahua nroqitaita nraahu ni nutu tuaahere variavaro mwihua mwutukyavanto hia nianra vaihata variarave. ");
INSERT INTO omw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mwihua mwaanra tiqatama nkyiari nraaquhua qua nraahu timwa nyiqatara tita, mwihua quminama ni nutu tuaahere variavo, turave. Aisaiaava haaru nkyiara mwitaa turave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesusiva mwitaa timwa kyero nraakye qora nyaanrama kyero mwihuara tiqaro, Mwaa quara rieqatama ntapihi kyeta nraato tuate. ");
INSERT INTO omw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Vaisi nroqi viqete vari inraikyava hia mwia vara uaqiama kyairave. Mwia nroqitairo nrinte vari inraikyava mwi inraikyava mwia vara uaqiama kye varirave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Iesusiva mwi quara timwa kyero varuvata mwia nraaqiaravanto mwiva hunani uro nteta tiqata, E hiave ntapihi kyera hiaro? Parisi vaisinramwuvanto e vaakya timwa nyiana quara rieta uaqia hi quarave timwa kyeta hia mwianra qamwataavo, tita. ");
INSERT INTO omw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mwihua mwitaa tuvaro Iesusiva tiqaro, Ni kova nyaamwuni variva taqairaro mwiva hia vara tuani inraikyava qupiqairaro mwiva mwi inraikyara tuqa vatama kyero ntaru kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mwitaa timwa kyero mwiva Parisi vaisiara tiqaro, Hia mwihuara nronraqama kyeta riaate. Mwihua vu qipa vihata variahua hia aanra taqaraitita variqata vu qipa quahua kyaata mponramwuvata aanra nyaamwutarerata uti variahuave. Vu qipa quari vaisiva nai hena vu qipa quani vaisira aanra nraamwutankye qianinra mwitanahuaqama ontiqi ntuqutu vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Iesusiva mwitaa tuvaro Pitaava tiqaro, Vaakya nraakye qora mpo quaqaa ntumwa kyera timwa nyiana quara tiri timwa timwinraqe tire mwi quara okyara ntapihi kyeta riaare, tuvaro ");
INSERT INTO omw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesusiva tiqaro, Qikye, nkyevata mwinramwuhua votima kyeta hiave ntapihi riaavo? ");
INSERT INTO omw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nkye hia ntapihiarave iho? Kyaravanto nroqima tero viva mwiaqaatairo raraqi viro mwiqitairo qatinani tumi tarairave. ");
INSERT INTO omw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Vaisi mwutukyaqi vahi inraikyava nroqaatairo qatinani nrintaiva, mwi inraikyava vaisi vara uaqiama kyairave. ");
INSERT INTO omw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vaisi vu nraato mwutukyaqitairo uaqia hi inraikyarara riaiva nri varirave. Vaisi rukyaarivave, mpora nraatara nrohiarivave, api qaraqiro nrohiarivave, mpuara varaarivave, unra qiarivave, mpora nrutu mwatani tumi quarive tiro unra qua qiarivave, mwiqitairo nri varirave. ");
INSERT INTO omw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mwi inraikyava mwi inraikyava vu nraato mwutukyaqitairo nri ntero vaisi vara uaqiama kyaiharo Kotiva mwi vaisirara uaqia hi vaisirave tirave. Vaisivanto hia kyauqu hiqama kyero kyara nraanriva hia mwia vara uaqiama kyairaro Kotiva mwianra uaqia hi vaisirave qiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesusiva mwitaa timwa kyero mwi mwatara kyero uro mpo mwataqaa mwatukya taaratana Taiaavata Saitonivata vahu mwataraqaa varura. ");
INSERT INTO omw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mwini uro varuvaro mwi mwataraqaanaa nraakye mpovanto Kenaani nraakyevanto Iesusiva varunani uro ntero Iesusirara nronraqama kyero aakyara ntero tiqaro, Nronrao, Ntevitira mwaaquo, nianra po timwa mataante. Vaanavanto ni naamwunra utaqi variharo mwiva uaqiama kyero variho, tiro. ");
INSERT INTO omw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mwi nraakyeva mwitaa tuvaro Iesusiva hia qua tiraitiro varuvata mwia nraaqiaranramwuvanto mwiva hunani uro vuavi raavira tita, tiqata, Mwi nraakyera kyaahaqama kyairaro quarive. Mwiva tiri tivataqiro nriqanro aakyara ntamwaqiro nrihanro tiri pupohama timwiho, tita. ");
INSERT INTO omw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mwihua mwitaa tuvaro Iesusiva qaqao tiro, Isareri vaisivanto sipisipi votima kyeta raupirima quavaro Kotiva ni titaihana nte mwi mwatanaahua nraahu kyaahaqama nyatarerana tumuvave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Iesusiva mwitaa tuvaro mwi nraakyeva nrumu Iesusira vuqaa tumu ntiro variro tiqaro, Nronrao, qati ni kyaahaqama mataante, tuvaro ");
INSERT INTO omw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesusiva qaqao tiro, Nte nraaqiara kyara vara kyena vairivanto hinani kyaankyorave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Iesusiva mpo quaqaa ntumwa kyero mwitaa tuvaro mwi nraakyeva tiqaro, Nronrao, vaisivanto kyara nreqanro viti vaati kyaira qati vairivanto nrainrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nraakye mwiva mwitaa tuvaro Iesusiva tiqaro, E nraakye nianra kepukyaqama kyera riaaro. Nanra inraikyara i mwutukya vahiariva qutaa qovara hiananrove, tiro. Iesusiva mwitaa tuvaro mate mwiqiara mwia nraamwunravanto kyuqema viro varura. ");
INSERT INTO omw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesusiva mwi mwatara kyero Karirini kyaarera tokyasataa vuva uro taaqiqaa mwaanri ntero mwatakyaa viro varuvata ");
INSERT INTO omw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","nraakye qora airivanto mwiva hunani vita. Mwihua kyuqu uaqiama vuhuave, vu qipa vuhuave, mwukyaari ntanrenra vuhuave, nro tita vuhuave, mpo qara mpo qarama kyero nriqa vuhuave, ekyaa mwihua sitaqita uro Iesusira kyuqutarasata kyovaro mwiva mwihua kyuqema nyatora. ");
INSERT INTO omw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iesusiva mwihua kyuqema kyovata nraakye qoravanto taqovata nro tita vuhua qio qua tuvata, mwukyaari ntanrenra vuhua ntapihi varuvata, kyuqu uaqiama vuhua qati varuvata, vu qipa vuhua qati taqe varuvata, nraakye qoravanto mwihua taqeta vaimwateta kyauqu ntukikinraaqateta Kotira nrutu tuaahereta tiqata, Qikye, Kotiva kyuqema kyero Isareri vaisiqaa ntaqikyi variho, tura. ");
INSERT INTO omw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesusiva nai nraaqiaranramwu nyaanrama kyero tiqaro, Nte nraakye qora ntuvaantuama vita variahuara nronraqama kyena po tuqo. Mwihua taarampo enta ni vatama kyeta variqi viqatama mwihua nkyiari kyara nramwa taiqa kyaavo. Nte mwihua nkyiari mwaatani sitaarita vivaro kyara nraataa hirata tantu vaantuantakyaa vivorave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Iesusiva mwitaa tuvata mwia nraaqiaranramwuvanto tiqata, Mwaa qumina mwataqaave. Taisaita kyara vara kyetave mwihua nyiananrave? Nraakye qora airintima mwaini variavo, tita. ");
INSERT INTO omw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mwihua mwitaa tuvaro Iesusiva mwihua kyapara hiro tiqaro, Nataama mperetive ntumwa taavo? tuvata mwihua tiqata, Mpereti 7 nramwu vaihata tavukya pata mponramwuvata ntumwa tauro, tita. ");
INSERT INTO omw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mwitaa tuvaro Iesusiva nraakye qorara mwatasata mwatakyaa quate timwa kyero ");
INSERT INTO omw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","mpereti 7 nramwuvata tavukyavata vara kyero Kotirara kyuqeve timwa kyero mwi kyarara nteqa kyero tukyama kyero nai nraaqiaranramwu nyuvata mwihua vara kyeta nraakye qora nyuvata ");
INSERT INTO omw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ekyaa mwihua mwi kyarara qio nronra. Mwihua qio nrovata mwia nraaqiaranramwuvanto mwihua nreta viti vaati kyora utu kyeta ntutantuto tuara 7 nramwu piqa kyora. ");
INSERT INTO omw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mwi kyarara 4,000 vaisivanto nrovata nraakye nraaqiara airivantovata nronra. ");
INSERT INTO omw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mwihua kyara nramwa kyovaro Iesusiva mwihua nkyiari mwaatani sitovata vuvaro mwiva mpotuqi mwaanri ntero Makataaninianra kyaareraqaama tero vura. ");
INSERT INTO omw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Iesusiva mwini vuvata Parisi vaisinramwuvantovata, Saitiusi vaisinramwuvantovata, Iesusiva varunani uro nteta kyai mwia mwataara hiqata taqaare timwa kyeta Iesusirara tiqata, E tiri tivuqaa nronra kyaiqa mpo tinraamwutairaqeta tire mwia taqetama tire iara tiqata qutaama Kotiva mwia titaiharo tumivave qiare, tita. ");
INSERT INTO omw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mwihua mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Nkye taqaavaro enraihanro vuhero vehohaara utihata nkye tiqata hura vuhaananrove qiarave. ");
INSERT INTO omw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nkye toqaqi taqaavaro nyaamwuqi kyokira rutaihata mate vati ntuananrove qiarave. Nkye nyaamwuqi taqeqatama huari itaani okyararave, vati ntuani okyararave, ntapihi taqeqatama nkye nanraqamave mwaa entara qovara hiani okyarara hia ntapihiavo? ");
INSERT INTO omw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Uaqia hi kyaiqara nraahu uti varia vaisihua Kotirara qumimaqama kyeta api nrohi variahuama nronra kyaiqa tinraamwutairaqeta i okyarara qutaave qiare ti variavo. Hia nte ntena okyara mwihua nyaamwutena nronra kyaiqa varaaninrave. Kotiva haaru nkyi haivaqara Ionaanra utuntema kyero nivata mwitaa hiananrove. Mwianra nraahu rieqatama nkye ni okyara taqetama nkye nianra Kotiva titai vaisivave tivarave, tiro. Iesusiva mwitaa timwa kyero mwi vaisinramwuhua mwini kyero vurama. ");
INSERT INTO omw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iesusira nraaqiaranramwuvanto taunru kyeta hia mpereti vararaitita, qati kyaareraqaa qareta vura. ");
INSERT INTO omw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iesusiva tiqaro, (Taupavanto utaqi viro mpereti vara uqenra kyaiharo kyotairave.) Parisi vaisivata Saitiusi vaisivata mwihua taupa mwia votima kyeta variavo. Nkyenramwu mwihuara rauriqata variate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Iesusiva mwitaa tuvata mwinramwuhua Iesusiva mpo quaqaa ntumwa kyero timwa nyu quara hia ntapihiraitita, nai timwa mwi nai timwa mwi hita tiqata, Nanra quave tiho? Mpereti hia vareta nrunanra mwianrave mwitaa tiho? tita. ");
INSERT INTO omw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mwitaa ti varuvaro Iesusiva mwihua ti varu quara ntapihi kyero tiqaro, Qikye, nianra kepukyaqama kyeta riaataara vaihata nkye nianra hia kepukyaqama kyeta rie variavo. Nkye nanraqamave mpereti hia vare nrianra kyaara airi qua ti variavo? ");
INSERT INTO omw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nkye hia ntapihi kyeta riaraitita, nkye taunruve kyaavo? Nte mpereti kyauquru vara kyena vaisi airi 5,000 vaisi nteqa kyena nyiavara nkye mwihua nreta kyora viti vaati utu kyeta nataama tua piqa kyorave? Hiave nkye mwianra riaavo? ");
INSERT INTO omw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nte 4,000 vaisi mpereti 7 nramwu nteqa kyena nyiavara mwihua nreqata viti vaati kyo kyarara nkye utu kyeta nataama tua piqa kyorave? Nkye hiave mwianravata riaavo? ");
INSERT INTO omw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nte vaakya tu quara nkye nanraqamave hia ntapihi kyeta riaavo? Nte mpo quaqaa ntumwa kyena hia mperetiara tuqo. Nte nkyiara tiqana, Parisi vaisinramwuvata Saitiusi vaisinramwuvata mwihua taupa votima kyeta variarara tita, nkye mwihuara rauriqata variate tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Iesusiva mwitaa tuvaro mwinramwuhua su nyaatovanto ntapihi vuvata riovaro Iesusiva hia mperetivatama kyeta utaara taupara tiraitiro, mwiva mpo quaqaa ntumwa kyero timwa nyiqanro Parisi vaisinramwuvata Saitiusi vaisinramwuvata timwa taa quara mwianrama rauriqata variate tiho, tita. ");
INSERT INTO omw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesusiva mwatukya mpo Sisariaa Piripai nraaqani uro ntero nai nraaqiaranramwu kyapara hiro tiqaro, Ni mwatani mwatatai nraaqiarara nraakye qoravanto ta vaisivave tiqatave variavo? tiro. ");
INSERT INTO omw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mwitaa tuvata mwinramwuhua tiqata, Mpo hiahua iara mwiva Ioniva nramanri nyi varuvave ti variavata, mpo hiahua iara mwiva tiri haivaqava Iraisaavave ti variavata, mpo hiahua iara tiri haivaqava Ieremaiaavave, nraahumwa mpo poropetivanto qaiqaa qovarama viro variho ti variavo, tita. ");
INSERT INTO omw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mwinramwuhua mwitaa tuvaro Iesusiva mwihua kyapara hiro tiqaro, Qio nkyenramwu mpo? Nkyenramwu nianra ta vaisivave tiqatave variavo? tiro. ");
INSERT INTO omw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Iesusiva mwitaa tuvaro Saimoni Pitaava Iesusira timwa mwinro tiqaro, E Kotiva titai vaisiva Mesaiaavantove. Kotiva qati variqiro vi varira e mwia mwaaquvantoma varira hiaro, tiro. ");
INSERT INTO omw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Pitaava mwitaa tuvaro Iesusiva Pitaarara tiqaro, E Ioninra mwaaqu Saimonivave. E nianra mwitaa qiararo Kotiva iara qamwate variho. Hia qumina vaisivanto ni okyarara i vu nraato mwihanra ntapihiananrave. Ni kova nyaamwuni variva, mwivama mwi quara i timwa mwihanra e ntapihiananrave. ");
INSERT INTO omw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nte iara mwitaa tireranave, I nrutu Pitaavave. Orivave. Nte ori nronraqa ntena nraamwu hoqa tarerave. Mwi nraamwuva Kotira nraakye qoravantoma varivarave. Qutira inraikyavantovata hia qio mwi nraamwunra nraatara kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nte i kiqa mwianrinra e nraante qesa qatua nyatairata nraakye qoravanto Kotiva ntaqikyianinraqi qio vivarave. E mwatani variqara mpo inraikya qora inraikyara qao timwa tairaro Kotivavata nyaamwuni variqaro i qua kuaa qua mwia vataqiro viqaro qao timwa taananrove. E mwatani variqara mpo inraikyara hia qao timwa tairaro Kotivavata nyaamwuni variqaro i qua kuaa qua mwia vataqiro viqaro hia mwi inraikyarara qao qiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Iesusiva mwitaa timwa kyero nai nraaqiaranramwu kepukyaqama kyero timwa nyinro tiqaro, Hia mpohua timwa nyita nianra mwiva Kotiva titai vaisiva, Mesaiaavanto variho qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mwi entaraqaatairo Iesusiva nai qutu quaninranra nai nraaqiaranramwu vutu kyero timwa nyinro tiqaro, Nte Ierusaremini quarita mwini nronra vaisinramwuvata, Kotira kyaiqa vara mwate varia vaisihua vunyaa vaisinramwuvata, mwaanra okyara ti varia vaisinramwuhuavata, mwihua ni uaqiamaqita vi varivaqena nte nriqa quani inraikyara varaqina quarita ni ru kyaivaqena nte qutu vina taarampo enta varina qaiqaa qati siquaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Iesusiva mwitaa tuvaro Pitaava mwia vita uhini kyero mwianra qaqao tiro, Nronrao, haunri Kotiva mwihua kyairata i mwitaama mwatevorave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pitaava mwitaa tuvaro Iesusiva tuqasaa viro Pitaara inronra hiro tiqaro, Saataanio, nyianrani quante. Hia ni aanra antuaante. E hia Kotiva riaintema kyera rie variaro. E qati vaisivanto rie variantema kyerama rie variaro, tiro. ");
INSERT INTO omw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mwitaa timwa kyero Iesusiva nai nraaqiaranramwu timwa nyinro tiqaro, Ni pataqiro nrianri vaisiva, mwiva nai mwutukya vahianinra qaqira kyero, nai ru kyeta hirite kyatarira vara qu varero ni naakiara nrianrive. ");
INSERT INTO omw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nai mwatani qati varianinranra nraahu nronraqama kyero riaariva, mwi vaisiva ekyaarama qutu quananrove. Vaisivanto nianra riemwaqiro viqaro uro qutu quariva, mwi vaisiva ekyaa enta qati variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Vaisivanto mwatani variqiro viqaro ekyaa inraikya ntuvaantuama kyero vatero mwiaqaatairo qutu viraro mwiva ntuvaantuama taani inraikyava mwia qiove kyaahaqa hiananro? Hia qiove. Mwiva hia kyoqaa utu kyero qaiqaa qati variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nte mwatani mwatatai nraaqiarava nraakiara qaiqaa nyaamwusaina kepukyavanto uro ntantena tuminrenrave. Mwi entara ni kora okyara kyuqe hiariva niqaatairo itero ntuvaahe variraqe nte nyaamwunyaahua kyapata tumu variqana ekyaa nraakye qoravanto kyaiqa varerara rieqanama nkyiari kyoqaa nyianinrave. ");
INSERT INTO omw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nte qutaa qua qianinra riaate. Vaisi mponramwuvanto mate mwaa mwaini sivita variahua, mwihua hia vaakya qutu vivarave. Mwihua qati varivaqena nte mwatani mwatatai nraaqiarava nronraqama vina nte vunyaa vaisiqama vina variarita mwihua qutu vivarave tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iesusiva mwitaa tuvaro 6 enta nritarovaro mwiva Pitaaravata, Iemisiravata, Iemisira mwia qata Ioninravata, mwinramwuhua sita varero taaqiqaa nkyiariaraa varirerata vura. ");
INSERT INTO omw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mwini uro varuvaro Iesusira mwamwantavanto nraahumwa mpo mwamwanta kyuqu vuvaro mwia virivanto huarivanto itaintema kyero ntuvaahe varuvaro mwia tuavaaqavata mpoqama kyero takyuqiro ntuvaahe varura. ");
INSERT INTO omw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mwia mwamwantavanto mwitaama kyero kyuqu vuvaro varuvata mwia nraaqiara taaramponramwuvanto variqata taqovata Iraisaakya Mosesikya mwihua haivaqahuatana qovarama vita variqata Iesusiravatama kyeta qua ti varura. ");
INSERT INTO omw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mwitanahua Iesusiravatama kyeta qua ti varuvaro Pitaava Iesusirara tiqaro, Nronrao, kyuqemama tirenramwu i vatama kyeta mwaini varuro. E qiove tirera, tire haraara nraamwu taaramponramwu iara mpo, Mosesirara mpo, Iraisaarara mpo, hoqa nyataare, tiro. ");
INSERT INTO omw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pitaava mwi quara qati nraahu ti varuvaro tonamwu takyuqiro ntuvaahova mwihua ntumwaqu kyovaro quavanto tonamwuqitairo tiqaro, Mwaa ni maaqu, ni mutukyavanto mwianra mpoqama kyero nti vari nraaqiaravama variho. Nte mwianra qamwateqanama varuqo. Nkyenramwu mwia qua riaate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Quavanto mwitaa tuvata mwia nraaqiara taaramponramwu mpoqama kyero nyaatuqa tovata virianasaita mwataqaa tumu ntita varuvaro ");
INSERT INTO omw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iesusiva uro ntero nai kyauquqo mwihuaqa tu varero tiqaro, Mwaahuao, siquate. Hia aatu hiqata variate, tuvata ");
INSERT INTO omw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","mwinramwuhua tuaahera kyeta taqovaro Iesusiva nanrianraa varuvaro vaisi mpo mwitanahua hia varura. ");
INSERT INTO omw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Taaqi mwiaqaataita tumi varuvaro Iesusiva mwinramwuhua timwa nyinro tiqaro, Mateqa taqaa inraikyara hia mpohuavata timwa nyiate. Nte mwatani mwatatai nraaqiarava nraakiara nte qutu quaninraqitaina qaiqaa qati sivina varianinra mwi entaraqaataitama timwa nyiqita quate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Iesusiva mwitaa tuvata mwinramwuhua mwia kyapara hita tiqata, Mwaanra okyara ti varia vaisihua mwitaama timwa nyita tiqata, Iraisaava tiri haivaqava nraante qovarama viro nri ntaananrove, ti variarave. Mwihua nanraqamave mwitaa ti variavo? tita. ");
INSERT INTO omw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mwitaa tuvaro Iesusiva tiqaro, Qio mwihua qutaa ti variarave. Iraisaava nraante nrumu ekyaa inraikya ntapihi kyero terama tarero nrianrivama variho. ");
INSERT INTO omw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Qio nte nkyiara tiqana Iraisaava vaakya nrumu varurarama tuqo. Mwiva nrumu varuvata vaisi mpo uhua hia mwia ntapihi kyeta taqaraitita, Iraisaara nkyiari kyakya huntema kyeta mwia qoraqama mwatorave. Mwi vaisihua ni mwatani mwatatai nraaqiararavata qoraqama matevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iesusiva mwitaa tuvaro mwihua nyaato ntutoraa vuvata riovaro Iesusiva Iraisaaraqaa ntumwa kyero Ioniva nramanri nyi varu vaisirara tura. ");
INSERT INTO omw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mwinramwuhua taaqiqaatai tumu nte taqovata airi nraakye qora ntuvaantuama vita varuvaro vaisi mpovanto uro Iesusira vuqaa tori kyauru raviro tiqaro, Nronrao, ni maaquara po kye timwa mwataante. ");
INSERT INTO omw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Mwiva ueraqama viro anoma kyero uaqiama viro variho. Airi enta mwiva qiaqi ntumwa viro nramanriqi ntumwa viro hi variho. ");
INSERT INTO omw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nte mwia vitaqina nrumu i nraaqiaranramwuvanto varianani kyauqata mwihua mwia kyuqema mwataare tita taqaavaro hia qioqa hirave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Vaisi mwiva mwitaa tuvaro Iesusiva tiqaro, Nkye mwaa entara varia nraakye qorahua api nrohi variahuave. Nkye hia Kotirara qutaaqama kyeta rie variavo. Qikye, nkye ni qio pupohaira uti variavana nte nataa nataama entave nkyi kyapata variqina quaninrave? Nte nataa nataama entave variqana nkyi kyaahaqa hianinrave? Qio nraaqiara mwia viteta nte varura mwaaqaa nriate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Timwa kyero Iesusiva vaana titamwa kyovaro nraaqiara mwia utaqitairo nritarero vuvaro mwiaqaatairo mwia mwamwantavanto kyuqema vuvaro qio varura. ");
INSERT INTO omw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Qio varuvata mwia nraakiara mwia nraaqiaranramwuvanto Iesusiva varunani uro nteta mwia kyapara hita tiqata, Tire vaana mwia titauraro nanraqamave hia nritarero viho? tita. ");
INSERT INTO omw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mwinramwuhua mwitaa tuvaro Iesusiva tiqaro, Nkyenramwu hia Kotirara kepukyaqama kyeta rie variahuara tita, vaana titaavaro hia nritaraiho. Maasiteti uruve hovante pata uru qiani vahirave. Nkyenramwu Kotirara riemwaqita viva mwi urura votima kyero vahirera, nkyenramwu qioma mwaa taaqirara mwaaqaataira sivira vutuni quante tivaro taaqivanto quananrove. Nkye mwitaama kyeta Kotirara kepukyaqama kyeta riemwaqita vivera, nkye ekyaa kyaiqa qioma varevarave. ");
INSERT INTO omw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nkye hia Kotirara aakyara nteta kyaravata aurama teqata nkye hia qio mwi vaanahua sitevarave, tiro. Mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Iesusira nraaqiaranramwuvanto Karirini ntuvaantuama vita varuvaro Iesusiva mwihua timwa nyinro tiqaro, Mpovanto ni mwatani mwatatai nraaqiarara qovarama kyairata ni ntavaaqavuqita ");
INSERT INTO omw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","uro vaisi kyauquqi kyaivata ni ru kyaivaqena qutu vina taarampo enta vari kyena qaiqaa qati siquaninrave, tiro. Mwitaa tuvata mwia nraaqiaranramwu mwutukyavanto uaqia huvata varura. ");
INSERT INTO omw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesusiva nai nraaqiaranramwu kyapata Kapenaamini uro ntovata Kotira nraamwuqaa ntaqikyiqata taakisi vare varuhua nri nteta Pitaara kyapara hita tiqata, I nronra vaisivantovata mwi taakisira kye varirave iho? tita. ");
INSERT INTO omw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tuvaro Pitaava eo tiro, Mwivavata kye varirave, tiro. Mwitaa timwa kyero Pitaava nraamwuqi vuvaro Iesusiva nraante Pitaara ntumwahiamwa hiro tiqaro, Saimonio, Mwatani variahua mwihua vunyaahua ta mwatanaahuaqitaita taakisi vare variarave? Nkyiari mwatanaahuaqitaitave vare variavo? Mpo mwatanaahuaqitaitave vare variavo? Tiraqena riaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Iesusiva mwitaa tuvaro Pitaava tiqaro, Mwihua mpo mwatanaahuaqitaita taakisi vare variarave, tiro. Tuvaro Iesusiva tiqaro, Tire hia mpo mwatanaahua variraitita, tire Kotira nramwunaavanto variqatara tita, tire taakisi kyaarava hiama vahirove. ");
INSERT INTO omw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Qio mwihua tiriara tivorave. Mwianra rieqarama uro kyaareraqi huku tuto kyairaro tauraaqama kyero tavukya nrianriva nrumu ruvirara pati kyera mwia nro ntapahu kyera mwiqitaira munima vara kyera nianravata enanravata taakisiqa hiante, tiro. Mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mwi entara Iesusira nraaqiaranramwuvanto Iesusiva varunani uro nteta tiqata, Kotiva ntaqikyiraqi tavave nronraqama viro vunyaa vaisivanto variho? tita. ");
INSERT INTO omw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Mwihua mwitaa tuvaro Iesusiva nraaqiara pataru nraanrama kyero mwihua suqaa vatero ");
INSERT INTO omw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","tiqaro, Nte qianinra riaate. Nkye hia nraaqiara mwaa votima vita varivera, nkye hiama qio Kotiva ntaqikyiani mwatukyaraqi vivarave. ");
INSERT INTO omw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kotiva ntaqikyianinraqi vunyaa vaisivanto varirero hirera, mwiva nai nrutu vara mwataniqama kyero nraaqiara mwaa votima kyeroma variarive. Mwi nraaqiarara voti hiarivama vunyaa vaisivanto variananrove. ");
INSERT INTO omw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Vaisi mpovanto nraaqiara mwaa voti hianinra qamwata mwateqaro nivatama qamwata mataananrove. ");
INSERT INTO omw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nraaqiara pata mwaa voti hiariva ni qua riaariva variraro vaisi mpovanto nri ntero uaqia hi aanranra nraamwutairera, mwi vaisiraqaa qua nronraqama kyero vahiananrove. Mwi vaisiva hia nraaqiara mwia uaqia hi aanranra nraamwutaraitiro variraro mwia nruntaqi ori nronra kyaantaru kyero kyaareraqi tuto kyairaro ntaqutu viraqe huviqarave qiataarave. ");
INSERT INTO omw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Po, mwatani vari nraakye qorahua uaqia hi kyaiqara utuate tiro, mpo inraikya mpo inraikyavanto mwihua mwataara hiananrove. Uaqia hi kyaiqara qovarama kyaani vaisirara po timwa mwatauqo. (Nraakiara mwi vaisiva taqaananrove.) ");
INSERT INTO omw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","I kyauquvantove, i kyuquvantove, uaqia hi kyaiqara uti varirera, mwia teqa kyera qaqira kyaante. Mwiaqaataira kyauqu kuaiku vahiarivave, kyuqu kuaiku vahiarivave, nyaamwuni vira qioma qati variqira vinanrave. Uaqia hi kyaiqara utiqarama kyuqu taaratanave, kyauqu taaratanave, vahiariva variraro hia qipaani qiaraqi i tuto kyaankyorave. ");
INSERT INTO omw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","E vu hiniqotaira taqe variqara uaqia hi kyaiqara uti varirera, qaiqaavata mwitaamaqira quankyorave tira, ena vu hini vauru kyera qaqira kyaante. E vu kuaiku nraahu vahirara hia uaqia hi kyaiqara utiraitira, qioma nyaamwuni vinanrave. E vu taaratana vahiariva uaqia hi kyaiqara utuqira virava nraakiara qutu viraro i qia nronraqi tuto kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nkye taqeqata variate. Nraaqiara pata mwaahua varivata nkye mwihuaqitaita pata mporuara uaqua tita mwianra qumina nraaqiararuve tivorave. Nyaamwunyaahua mwihuaqaa ntaqikyi variahua hia mwihuara qumina nraaqiarave tiraitita, mwihuara rieqata ni kova nyaamwuni varira nraaqani variarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Iesusiva mwitaa timwa kyero mwiva tiqaro, Nte mwatani mwatatai nraaqiarava nte raupirima qua nraakye qorahua sitarera tumuvave. ");
INSERT INTO omw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nte mwaa quara qianinra nkye nataamave riaavo? Vaisi mpovanto sipisipi 100 vataariva taqairaro sipisipi mpovanto raupirima virera, mwiva hiave 99 sipisipi hini mwinramwuhua qati varihua taaqiqaa kyero raupirima quani sipisipira puaa hirero quananrove? ");
INSERT INTO omw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mwiva mwianra puaamaqiro viro uro mwia puaama kyairera, mwiva tiqaro, Raupirima kyaurama ntena puaama kyena vitauqo, timwa kyero mpoqama kyero mwianra qamwateqaro sipisipi 99 hia raupirima quahuara hia nronraqama qamwataananrove. ");
INSERT INTO omw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mwia votima kyero ni kova nyaamwuni variva mwaa nraaqiaranramwuhuaqitairo mpovanto raupirima quankyo timwa kyeqaro varirave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","I qata vakyaa mpovanto i mpo inraikya uaqiama mwatairara e mwianra tirera hiqarama uro mwia vita kyera nkyetaraatana nraahu variqata mwi quara avuqavu hiate. Mwiva i qua riairera, mwia vita varera mwiaqaataitatana nkye kyuqema kyeta kuaaqi qioma variqita vivarave. ");
INSERT INTO omw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mwiva hia i qua riairera, uro vaisi kuaikuve taaratanave sitaqira nrinrata mwitanahuavata nrumu variqata i qua rieqatama qio qutaama tira hiaroma tivarave. ");
INSERT INTO omw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mwitaamaqita vivaro mwi vaisiva nkyinramwu qua hia nraahu riairera, mwiaqaataira ekyaa Kotira nraakye qora ntuvaantuama kyera ena qua mwia ekyaa mwihuavata timwa nyiante. Mwi vaisiva Kotira nraakye qora ntuvaantuama tehuara hia riairera, ekyaara mwiaqaataita nkye mwi vaisira titeqatama tiqata, E mpo mwatanaa votima kyerama variaro. E taakisi vare varia vaisihua votima kyerama variaro, qiate. ");
INSERT INTO omw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nte qianinra riaate. Nkye mwatani variqata mpo inraikya mpo inraikya uaqia hiani inraikyarara qao timwa taivaro Kotivavata nyaamwuni variqaro mwianra qao timwa taananrove. Nkye mwatani variqata mpo inraikya mpo inraikyarave hia qao timwa taivaro Kotivavata nyaamwuni variqaro hia mwi inraikyarara qao timwa taananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Iesusiva mwitaa timwa kyero tiqaro, Nte qaiqaa qianinra riaate. Nkyiqitai vaisi taaratanavanto kuaa vu nraato vateta Kotirara kyapara hivaro ni kova nyaamwuni variva mwitanahua tintema kyero nyiananrove. ");
INSERT INTO omw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Taaratanave, taarampotanavantove, ni kyaiqarave tita ntuvaantua hivera, qio nte mwinramwuhua utaqaa varianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Iesusiva mwitaa tuvaro Pitaava uro Iesusira kyapara hiro tiqaro, Nronrao, ni kata pakyaa mpovanto ni uaqiama matairera, nte nataama nanive mwianra hia iqaa qua vatena qaqira kyarerave qianinrave? Kyauquru hisai taara nanive mwitaa hianinrave? ");
INSERT INTO omw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Pitaava mwitaa tuvaro Iesusiva tiqaro, Hia nte iara kyauquru hisai taaranani mwia qua qaqira kyaante tuqo. Nte iara mwia qua 500 nani qaqira kyaantema tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kotiva nraakye qoraqaa ntaqikyiariva mwaa quara votima kyeroma vaiho. Nronra vaisi mpovanto nai kyaiqa vaisinramwu nyito munimanra ntena vararerave turave. ");
INSERT INTO omw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Timwa kyero tohara kyero vare varuvata mwia kyaiqa vaisi mpo vitaqita mwiva huraqa kyovaro mwi vaisiva nronra munima 1,000,000 kinaa vara kyero nramwa kyova vahuvaro ");
INSERT INTO omw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","mwiva mwi munimanra nai mwianriva hia qioqama kyero vahuvaro mwia nronra vaisivanto tiqaro, Mwi vaisiravata mwia nraata nraaqiaravata, mwiva ekyaa inraikya vataaninravata, mpohua nyita munima varaqita nrumu ni mpivaqena nte mwiva vara nramwa kyai munimanra hiniqama ntena varaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mwiva mwitaa tuvaro mwia kyaiqa vaisivanto tumu ntiro tori kyauru raviro po kye tiro tiqaro, E variraqena nte qakyoma kye mwi munimanra puaamaqina vina uro ekyaa puaama kyena ina mwiankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mwitaa tuvaro mwia nronra vaisivanto mwianra po kye timwa mwatero tiqaro, Qio nte iara po kye timwa mwateqanama mwi munimanra qaqira kyauqo. Hia nina mpiante. Qaqira kyera quante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mwitaa tuvaro mwi vaisiva veva ntero vuva uro taqovaro kyaiqa vaisi mpovanto nai mwia henava mwia munima 10 kinaa vara nramwa kyova nruvaro mwiva mwia uro nruntana tutero ntaquti variro mwianra tiqaro, Ni munima nramwa kyaananra qamwanrama kyera nina mpiante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mwitaa tuvaro mwia henava mwiva tumu ntiro tori kyauru raviro po kye tiro tiqaro, E variraqena nte mwi munimanra qakyo puaama kyena i mwiankye, tuvaro ");
INSERT INTO omw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","mwi vaisiva hia mwia qua riaraitiro, nai hena vaisi mwia karavuqi kyero tiqaro, Ni munima nramwa kyaananra ekyaa nina mpiraqenama i huvantu kyaaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mwitaa timwa kyero nai hena vaisi mwia karavuqi kyovata kyaiqa vaisi mponramwuvanto mwia taqovaro uaqia huvata e uaqiama hira hiaro timwa kyeta uro nronra vaisi timwa mwuvaro ");
INSERT INTO omw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","mwia nronra vaisivanto nai kyaiqa vaisi nraanrama kyero timwa mwinro tiqaro, E uaqia hi kyaiqara uti variara vaisivama variaro. E nianra po kye timwa mataante qiarana nte e nramwa kyaana munimanra nronra munima ekyaa qaqira kyena hia nina mpiante turave. ");
INSERT INTO omw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nte iara po tuntema kyera evata ena henanranra po timwa mwataataara vaihara hia mwitaa hiaro, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mwitaa timwa kyero mwia nronra vaisi mwia mpoqama kyero raraqa tovaro nai kyaiqa vaisi karavuqi kyero tiqaro, Mwiva karavuqi variqaro nai nramwa kyai munimanra ekyaa nina mpiarive, tiro. ");
INSERT INTO omw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iesusiva mwitaa timwa kyero nai nraaqiaranramwu timwa nyinro tiqaro, Nkye nkyeta mwutukyaqitaita nkyeta sata sakyaahua nkyi uaqiama nyate quara hia qaqira kyaraitita qati nraahu riemwaqita vivera, nkyi sova nyaamwuni variva nkyeta uaqia hi kyaiqara utua quaravata qati nraahu riemwaqiro quananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesusiva mwi quara timwa nyi taiqa kyero Karirisairo Iutia mwata Iotaani nramanri qarahini vuvata ");
INSERT INTO omw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","nraakye qora airivanto mwia vataqita vuvaro mwiva mwini variqaro mwihua nriqa vuhua kyuqema nyatora. ");
INSERT INTO omw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Iesusiva mwini varuvata Parisi vaisinramwuvanto mwiva hunani uro nteta Iesusirara api qua qiarive tita mpo qua mwia kyapara hita tiqata, Qiove vaisivanto mpo qua mpo qua vahiraro mwi quara kyaara nai nraata qaqira kyaananrove? Mwiva mwitaa hirera, mwiva tiri mwaanra qua nteqave kyaananrove? Tiraqe riaare, tita. ");
INSERT INTO omw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mwitaa tuvaro Iesusiva tiqaro, Nkyenramwu hiave Mosesiva qara ntumwa to quara kyaara ntumwa kyeta riaavo? Mwi quava mwataamama vahiro. Nyaamwuvata mwatavata ututova, Kotiva tauraaqama kyero vaisivata nraakyevata utu kyero tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Vaisivata nraakyevata ututaurara tiro, vaisivanto nai nrohua qohua kyero nai nraatantiri kuaaqi variqi vita mwitanahua kuaa mwamwanta varivarave turave. ");
INSERT INTO omw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mwitanahua hia mpo mwamwanta mpo mwamwanta variraitita, kuaa mwamwanta nraahu variarave. Qio Kotiva mwitanahua kuaaqa taaqau tairara tiro, mpovanto mwitanahua ntainra kyaankyorave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Iesusiva mwitaa tuvata mwinramwuhua tiqata, Qutaa Kotiva mwitaa turave. Qio nanraqama Mosesiva mpo qua turave? Mosesiva timwa to quava mwataama tiho, Vaisivanto nai nraata qaqira kyaariva qaravata mwinro qioma qaqira kyaananrove turave, Mosesiva nanraqama mwitaama kyero qua timwa torave? tita. ");
INSERT INTO omw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mwihua mwitaa tuvaro Iesusiva mwihua nkyiari timwa nyinro tiqaro, Mosesiva variqaro taqovaro nkyi haivaqahua mwutukyavanto kepukyaqa huvata hia Kotirara riorave. Mwitaa hi varuvarora tiro, Mosesiva qihaakyama kyero qio mwitaa hiate, timwa kyero mwi quara timwa torave. Haaru tauraaqama kyero mwata ututo entara hia mwitaama vahurave. ");
INSERT INTO omw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nte nkyiara mwitaama tuqo, Nraakyevanto hia vaisi mpovatama kyero nrohiraitiro variraro mwia vaativanto mpo qua kyaara mwia qaqira kyero mpo nraakye varairera, mwi vaisiva qaraakya nraakyentiri nrohiqaroma mwiva nraata vaati ntuqema kyeroma mwiavata mpuaraqama kyeroma nrohiananrove tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iesusiva mwitaa timwa kyero varuvata mwia nraaqiaranramwuvanto Iesusirara tiqata, Qikye, vaisivanto mwitaama kyero nraata varaariva vahirera, vaisivanto hia nraata vararaitiro qati variarive, tita. ");
INSERT INTO omw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mwia nraaqiaranramwuvanto mwitaa tuvaro Iesusiva tiqaro, Hia ekyaa vaisivanto nkye qiante hita hia nraata vararaitita qati varivarave. Kotiva kepukyaqama mwataari vaisiva mwiva nraahu qati variananrove. ");
INSERT INTO omw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mpo qara mpo qara hi okyara qaara mpohia vaisihua hia nraata varaarave. Mpohia vaisihua mwata kyaavaro mwihua mwamwanta hia kyuqema vaihatara tita, hia nraata varaarave. Mpohia vaisihua mwamwanta uaqiama kyaavatara tita, mwihua hia nraata varaarave. Mpohia vaisihua Kotiva nraakye qoraqaa ntaqikyirara rieqata tire Kotira kyaiqa vararerave timwa kyeta hia nraata varaarave. Mwi quara ntapihi kyero rie variariva, mwi vaisiva mwi quara riemwaqiro quananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iesusiva varuvata nraakye qoravanto nkyiari nraaqiara sita vareta Iesusiva mwihuaqaa nai kyauqu vateqaro Kotirara aakyara tiraro mwihua kyuqema nyataarive timwa kyeta Iesusiva varunani sitaqita uro kyarera utuvata Iesusira nraaqiaranramwuvanto mwihua inronra hi varura. ");
INSERT INTO omw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mwitaa tuvaro Iesusiva qaqao tiro, Qati kyaivata mwihua nte hunani nriate. Hia mwihua aanra antuaate. Kotiva ntaqikyiari mwatukyava mwi nraaqiarahua voti hiahua mwihua mwatukyama vahiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Iesusiva mwitaa timwa kyero nai kyauqu nraaqiara mwihuaqaa vatero mwihua kyuqema nyatero vura. ");
INSERT INTO omw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mpo enta vaisi mpovanto Iesusiva varunani uro ntero tiqaro, Mwaanra ti variara vaisio, nte kyuqe kyaiqa nataa hianinra Kotira vara mwataaninraqaatainave nte ekyaa enta qati variqina quaninrave? tiro. ");
INSERT INTO omw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mwitaa tuvaro Iesusiva tiqaro, E nanraqamave kyuqe kyaiqara ni kyapara hira hiaro? Kotiva kuaikuvanto kyuqema varivave. I ekyaa enta qati variqira quataa hirara, e Kotiva timwa to quara ekyaa mwi quara riemwaqira quante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Iesusiva mwitaa tuvaro mwi vaisiva kyapara hiro tiqaro, Qio nte nanra quave Kotiva timwa toraqitaina riemwaqina quaninrave? tuvaro Iesusiva timwa mwinro tiqaro, Mwaa quara timwa torave: Hia vaisi ru kyaante. Hia mpora nraatavata nrohiante. Hia mpuara varaante. Hia mpora unra qiante. ");
INSERT INTO omw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ena nrohua qohua nrutu tuaahera nyataante. E enanra i mwutukya vahintema kyera ena hena vaisiaravata i mwutukya vahirara variante, turave. Mwi quara timwa tora riemwaqira quante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Iesusiva mwitaa tuvaro mwi vaisiva tiqaro, Nte ekyaa mwi quara qiananra riemwa ntapihi kyauvama varuqo. Nanra inraikyavantove qati vaihana nte hia qioqa huqo? tiro. ");
INSERT INTO omw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Mwitaa tuvaro Iesusiva tiqaro, E mpoqiavata kyuqe vaisivanto varirera, uro ekyaa ena vatena inraikyara nyinra munima vara kyera hia mpo inraikya vate nraakye qorahua nyinranro nyaamwuni i kyoqaa vahiarive. Mwiaqaataira e ni pataqira nriante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Iesusiva mwitaa tuvaro vaisi mwiva mwi quara riero airi inraikya vatovara tiro, mwia mwutukyavanto uaqia huvaro hia Iesusira qua riaraitiro, qaqira kyero vurama. ");
INSERT INTO omw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Vuvaro Iesusiva nai nraaqiaranramwuanra tiqaro, Nte qianinra, riaate. Airi inraikya vatehua Kotiva ntaqikyiani mwatukyaraqi mwukyaari tukyeqatama vivarave. ");
INSERT INTO omw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nte qaiqaa timwa nyianinra riaate. (Kameri quara nronravanto nataama kyerove vuqa uvintaqi/iriraqi ntuqiaraananrove? Hia qio mwitaa hiananrove.) Qio kamerivanto vuqa uvintaqi/iriraqi qio ntuqiaraaninravauma, airi inraikya vataari vaisiva Kotiva ntaqikyiani mwatukyaraqi qio quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iesusiva mwitaa tuvata mwia nraaqiaranramwuvanto mwi quarara airi nraato tita tiqata, Qikye, airi inraikya vatehua Kotira mwatukyaqi hia qio vivera, nai tavave qio mwini quananrove? tita. ");
INSERT INTO omw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mwitaa tuvaro Iesusiva mwihua taqero tiqaro, Mwatani varihua mwihua nkyiari nraahu variqata hiama qio vivarave. Kotiva kyaahaqa hirata mwihua qioma vivarave. Kotiva ekyaa kyaiqa qio nraahu vare varivave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mwitaa tuvaro Pitaava tiqaro, Taqaante, tirenramwu i vataqita virera hita, ekyaa inraikya mwini kyeta qatima nrunro. Tire mwia qiata nanra inraikyave varaananrave? tiro. ");
INSERT INTO omw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Pitaava mwitaa tuvaro Iesusiva mwinramwuhuara tiqaro, Nte qianinra riaate. Hia nte nkye kyaiqa vare varirara taunru kyaaninrave. Ekyaa inraikya qaraakyaqama kyero vahiani entaraqaa nte mwatani mwatatai nraaqiarava, nte mwi entara takyuqi variani inraikyara peqa inraikyavatama kyena nyaamwuni nronra taintaqaa mwatakyaa vina variarita nkye ni nraaqiara 12 nramwuvanto ni pataqita nrihua, nkyevata tainta 12 nramwuqaa mwatakyaa vita variqata Isareri vaisi 12 okyara mwihuaqaa ntaqikyiqata mwihua qua avuqavu hivarave. ");
INSERT INTO omw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Vaisi mpovanto nai mwaatave, nai qata vakyaave, nai nrunra nrakyaave, nai nrohua qohuave, nai nraaqiarave, nai mwatave, qaqira kyero ni kyaiqarave tiro quariva, mwi vaisiva mwia qiata nai kyoqaa vareqaro hia kuaa nani varaananrove. Mwiva mpoqiavata vareqaro 100 nani varairaro mwia mwoqaqa Kotiva mwianra e ekyaa enta ekyaa enta qati nraahu variqira quante qiananrove. ");
INSERT INTO omw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mate nraakye qora airivanto vuni variahua, qakyo mwihua tumitareta nraakiarani varivarave. Mate mwaa nraakiarani variahua, mwihua qakyo nritareta vunima varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kotiva ntaqikyiariva vahirero mwaa quaraqaa ntumwa kyena qiani quara votima kyero vaiho. Mwata airi vahu vaisiva vaakya toqa entaqi siviro nai uaini vara tutoraqi kyaiqa varaate tiro, kyaiqa vaisiara puaa hirero vurave. ");
INSERT INTO omw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Vuva uro vaisi mponramwu puaama kyero tiqaro, Nkyenramwu mate ni kyaiqa vara mataivaqe nte mwi entarara rieqana nkyi kuaiqia kuaiqia munima kuaa kinaa kuaa kinaa nyiankye, tuvata eo tuvaro nai aakyoqi sitaqiro uro kyero. ");
INSERT INTO omw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Uro kyero varuvaro huarivanto nrinro viri sataqa huvaro mwiva maaketiqi vuva uro taqovata vaisi mponramwuvanto qumina varuvaro ");
INSERT INTO omw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","mwiva mwihuara tiqaro, Nkyevata uro ni aakyoqi ni kyaiqa vara mataivaqe nte nkyita kyaiqara rieqana kyoqaa nyiankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tuvata mwihuavata mwini vuvaro mwiva varuvaro huarivanto virini qiataqa nrinro ihera mwutukyaqa huvarovata, huarivanto tuminro vititoqa huvarovata, mwiva vaisi sitarero vaakya hunte hiro. ");
INSERT INTO omw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Aakyo qova kyaiqa vaisi qati nraahu sitaqiro vuvaro kyaiqa taiqeva qaumaqa huvaro qaiqaa maaketiqi uro taqovata vaisi mponramwuvanto qati nraahu sivita varuvaro mwihua kyapara hiro tiqaro, Nkye nanraqamave mate qumina varita hiavo? tuvata ");
INSERT INTO omw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","mwihua mwia timwa mwita tiqata, Hia vaisi mpovanto tiriara kyaiqa varaate tihatama tire qumina varuro, tuvaro mwihuara tiqaro, Qio nkyevata uro ni uaini aakyoqi kyaiqa varaate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Mwitaa timwa kyero varuvaro enta hirero huvaro aakyo qova nai kyaiqaqaa ntaqikyu vaisirara tiqaro, Kyaiqa vaisi ekyaa nyaanrama kyera mwihua nkyiari kyoqaa nyiante. E nraakiara nria vaisihua nraante munima nyiqi vira uro vaakya vuni nria vaisihuaqaa taiqa kyaante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mwitaa tuvaro mwiva kyaiqa taiqarera hunani nruhua nraante munima kuaa kinaa kuaa kinaa nyinro. ");
INSERT INTO omw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nyiqiro viro vaakya toqaqi nru vaisihua munima nyinrenro huvata mwihua tiqata, Tiri munima mpoqiavata timwiananrove, tuvaro mwiva mwihuavata kuaa kinaa kuaa kinaa nraahu nyinro. ");
INSERT INTO omw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kuaa qarama kye nyuvata mwihua mwi munimanra vareta aakyo qorara nrutu nraunru/nrunru nraanru tita tiqata, ");
INSERT INTO omw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Qaqao, kyaiqa taiqaarava qaumaqa ihata nria vaisihua kyaiqa pataqia nraahu vara kyetama kuaa kinaa kuaa kinaa varaavo. Tire vaakya toqaqi nrunrahua huari nronraqi kyaiqa varaqi vurarama e nraakiara nria vaisihua nyianrantema kyerama tirivata timwinra hiaro. Nanraqamave mwitaa hiaro? tita. ");
INSERT INTO omw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mwihua mwitaa tuvaro aakyo qova vaisi mpora tiqaro, Ni vaisio, hia nte i uaqiama mwatauqo. Qio qutaa nte vaakya toqaqi iara ni kyaiqa varairaqe nte i kuaa kinaa mwiankye tuqara e eo qiananrave? ");
INSERT INTO omw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ena munimavata varera ena mwaatani quante. Nte ivata nraakiara sita tauhuavata kuaa qarama kyena nyiataa ihana nyunrave. ");
INSERT INTO omw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nte ntena munimanra tina, hiave nte ntena kyakya hianinraqa nkyi tukyama kyena nyianinrave? Nte qihaakyama kyena ntena munima nyuqanra nanraqamave e kyaruntira hiaro? turave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iesusiva mwi quaraqaa ntumwa kyero timwa nyinro taiqa kyarera hiro tiqaro, Mwia votima kyeta mwoqani varihua qakyo vuni utu vivarave. Vuni utu vihua qakyo mwoqani tumi vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesusiva Ierusareminianra aanrani viqaro nai nraaqiara 12 mwinramwuhua nraahu sita kyero tirema timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Taqaate, tirenramwu Ierusareminianrama vi varuro. Nte mwatani mwatatai nraaqiarava mwini uro ntaariro ni qovarama kyero uro Kotira kyaiqa vara mwate varia vaisihua vunyaa vaisinramwuvata, mwaanra okyara ti varia vaisihuavata, nyiananrove. Nyinrata mwihua nianra mwia ru kyaate timwa kyeta ");
INSERT INTO omw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ni pitaqita mpo mwatanaahua kyauquqi uro kyaivata mwihua nianra raima mateta kyaanta vara kyeta mwiaqotaita ni moqasata ntuteqaateqama mateta mwiaqaataita uro kyatariqaa ni rutaivaqena nte qutu vinama taarampo enta vari kyena qaiqaa qati siquaninrave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mwi entara Sepetira mwaaqutana nyova mwitanahua sita varero Iesusiva hunani vuva uro mwia vuqaa variqaro kakataama viro mwataqi tumu ntiro variqaro nai kyaahaqama mwataaninranra Iesusira kyapara hura. ");
INSERT INTO omw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesusira kyapara huvaro mwiva mwia nai kyapara hiro tiqaro, Nanra inraikyarave qiaro? tiro. Mwitaa tuvaro nraakye mwiva tiqaro, Qiove mate mwaa e eo timwa tairata nraakiara e nronraqama vira vunyaa vaisivanto varinanraqa ni maaqutana nronraqama kyairata mpovanto i kyauqu kyaatutani variraro mpovanto i kyauqu kyaantaaqani variarive, tiro. ");
INSERT INTO omw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mwi nraakyeva mwitaa tuvaro Iesusiva mwinramwuhuara tiqaro, Nkyenramwu mwitaama kye ni kyapara hiqatama hia mwi quara okyara ntapihiraititama, mwitaa qiavo. Nte nriqa quaninra nramanri voti hira nraaninra nkyetanavatave nrevarave? tuvata mwitanahua tiqata, Qioma nraananrave, tita. ");
INSERT INTO omw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mwitana mwitaa tuvaro Iesusiva tiqaro, Qutaama nkyetanavata mwi nramanrinra mwia nrevarave. Ni kyauqu kyaatutanivata, kyaantaaqanivata, mwata kyaavi varitana hia ni kyaiqa vahirave. Ni kova vaisi taaratana terama kyero vatai vaisitanama mwini mwata kyaavi varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iesusiva mwitaa tuvata mwia nraaqiara hini 10 mwinramwuhua mwi quara rieta mwi qate vakyetana inronra hura. ");
INSERT INTO omw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mwinramwuhua mwi vaisitana inronra hi varuvaro Iesusiva ekyaa mwinro mwaanro mwinramwuhua nyaanrama kyero qio eqaate tiro, Mpo mwatanaahua ntaqikyiqi qua okyarara nkye riaarave. Mwihua vunyaa vaisivanto nritare viritoqama variqata mwi kyaiqara mwaa kyaiqara tirini varaate ti variarave. Mwihua nronra vaisinramwuvanto tiqata, Nte nronravanto varuqo. Ni qua nraahu riemwaqi quate, ti variarave. ");
INSERT INTO omw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nkye hia mwihua hiante hiate. Nkyiqitairo mpovanto nronraqa hirero hiqaro mwiva nkyi kyaiqa vara nyataarive. ");
INSERT INTO omw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nkyiqitairo mpovanto nritarero vuni varirero hiqaro mwiva karavu vaisi votima viro nkyi kyaiqa vara nyataarive. ");
INSERT INTO omw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nte mwatani mwatatai nraaqiaravama varuqo. Ntevata hia nraakye qorara ni kyaiqa vara mataate tina, tumuvave. Nte nraakye qora mwihuara kyaiqa varaqi vina, airi nraakye qora kyaahaqama nyatarera mwihuara rieqanama qutu virerave timwa kyena tumuvave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesusiva nai nraaqiaranramwuvata Ieriko kyeta vi varuvata nraakye qora airivanto Iesusira vataqita vi varuvata ");
INSERT INTO omw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","vaisi taaratanavanto vu qipa vu tanahua aanra tokyani variqata riovaro Iesusiva nritarero viqaro tuvata mwitanahua aakyara nteta tiqata, Nronrao, Ntevitira mwaaquo, qati tiritananra po kye timwa timwa taante, tita. ");
INSERT INTO omw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mwitanahua mwitaa tuvata nraakye qoravanto mwitanahua inronra hita tirema variate tuvatavata mwitanahua hia mwihua qua riaraitita, nronraqama kyeta aakyara nteta tiqata, Nronrao, Ntevitira mwaaquo, qati tiritananra po kye timwa timwa taante, tita. ");
INSERT INTO omw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mwitanahua mwitaa tuvaro Iesusiva nrumu siviro variro tiqaro, Nivanto nkyitana nataa hiarive titatanave nkyetana nianra aakyara nte variavo? tiro. ");
INSERT INTO omw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mwitaa tuvata mwitanahua timwa mwita tiqata, Nronrao, tiritana tivu ntapairi timwa taanterama i nraanre varuro, tita. ");
INSERT INTO omw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mwitaa tuvaro Iesusiva mwitanahuara po timwa nyatero mwitanahua suqaa nai kyauqu viti vatovaro mwitanahua suvanto qamwanrama ntapairi vuvata qio taqeta mwiaqaataita Iesusira vataqita vura. ");
INSERT INTO omw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesusiva nai nraaqiaranramwu kyapata vuvaro Ierusaremi qaumato vahuvata mwihua Mpetapaasi Oripi taaqi mwemwaqi vahu mwatukyaraqi uro nteta Iesusiva nai nraaqiara mpotana sitero ");
INSERT INTO omw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","tiqaro, Nkyetana viti mwatukyaraqi uro ntetama ntonki nraante taqevarave. Ntonkivanto nai nraati vatama kyero kyaantaru taivaro varianinra uro mwitanahua huvantu kyeta sitaqita nrumu ni mpiate. ");
INSERT INTO omw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Vaisi mpovanto nkyitana kyapara hirata mwitaama qiate. Tiri nronravanto ntonki mwianra tihatama nrunro qiate. Nkyetana mwitaa tivaro mwiva nkyitananra qio qamwanrama varaqita uro mwiatema qiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Haaru vetato entaqaa poropeti vaisivanto tu quava mwivauma vahiarive tiro, Iesusiva mwitaa tura. Haaru poropeti vaisivanto Kotira qua qovarama kyero mwataama tiro: ");
INSERT INTO omw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Nkye Ierusaremiqinaahua mwitaa timwa nyiate. Nkyi vunyaa vaisivanto nkye hianani nri variho. Mwiva qihaakya hivara tiro, qihaakyama kyero ntonki mwoqaqaa nri variho. Mwi ntonkiva qaraakya ntonkivantoma variho, tura. ");
INSERT INTO omw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mwiva tu quava mwivauma vahiarive tiro, Iesusiva nai nraaqiara taaratana sitovata mwitanahua Iesusiva tuntema kyeta vuhua uro ");
INSERT INTO omw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ntonkivata mwia nraativata vitaqita nrumu kyeta mwia nraaqiaranramwuvanto nkyiari tuavaaqa ntonkiqa vuti mwatovaro Iesusiva mwiaqaa mwaanri ntero mwatakyaa viro varura. ");
INSERT INTO omw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Varuvata nraakye qoravanto nkyiari tuavaaqavata aanravau vuti mwatovata nraakye qora mpo uhua kyatari mwanre teqeqita nrumu aanravau vuti mwatora. ");
INSERT INTO omw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Vuti mwatovata Iesusira vuni vuhuavata mwoqani vi varuhuavata aakyara nteta tiqata, Ntevitira mwaaqu nrutu tuaaheraate. Nronravanto nai nrutuqa nri vari vaisira kyuqema mwataiho. Ekyaa nyaamwunyaahua mwia nrutu tuaaheraate, tita. ");
INSERT INTO omw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mwitaa timwaqita vi varuvaro Iesusiva Ierusaremiqi vuvata ekyaa mwi mwatanaahua hianteta vitare nritare hi varita tiqata, Qikye, Ta vaisivave nriho? tuvata ");
INSERT INTO omw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","nraakye qora mpo uhua tiqata, Mwaa vaisiva Iesusivave. Mwiva poropeti vaisivanto Nasareti Karirisairo nrivave, tita. ");
INSERT INTO omw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesusiva uro Kotira nraamwu nronraqi vera ntero taqovata kyoqaa uti varu vaisihua mwiqi kyoqaa uti varuvaro mwiva mwihua vara veva mwaatani kyero, munima tuqasaaqi varu vaisira tainta vara rauru kyero, nyaamwa nyiqanro munima vare varu vaisira taintavata vara rauru kyora. ");
INSERT INTO omw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mwitaama kyero mwihuara tiqaro, Kotira mpukuqi qara ntumwa to quava tiqaro, Nraakye qoravanto ni nraamwuanra Kotirara aakyara nte varia nraamwunrave tivarave, turave. Nkye mwaaqi variavaro mpuara vaisivanto uqetaa mwatukyara votima kyeroma mwaa nraamwuva vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Iesusiva mwitaa timwa kyero mwiqi varuvata vu qipa vu vaisihuavata, kyuqu kyauqu ntanrenra vuhuavata, mwiva hunani nruvaro Iesusiva mwihua kyuqema nyatovata qio varura. ");
INSERT INTO omw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Iesusiva mwihua kyuqema nyatero nronra kyaiqa vare varuvata nraaqiaravanto Kotira nraamwuqi varita tiqata, Ntevitira mwaaqu mwia nrutu tuaaheraate, tita. Mwitaa ti varuvata Kotira nraamwuqaa ntaqikyi varu vaisihuavata mwaanra okyara ti varu vaisihuavata, mwi inraikyara taqeta Iesusira inronrama mwateta Iesusirara qaqao tita, ");
INSERT INTO omw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","E hiave nraaqiaravanto qua ti variara riaaro? tita. Mwitaa tuvaro Iesusiva tiqaro, Eo, nte nraaqiara qua riauqo. Nkyevata mpo, nkye hia Kotira mpukuqi mwaa quara kyaara ntiqata taqaarave? Mwitaama tiro: E nraaqiara nraamwa nraahuavata kyaahaqa hiarata mwihua i nrutu kyuqema kyeta tuaahere variavo, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Iesusiva mwitaa timwa kyero mwiva mwihua mwiqi kyero veva ntero mwatukya mwiavata kyero Mpetaanini enta mwiqi varirero viro. ");
INSERT INTO omw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mwia qanranraa toqaqi Iesusiva uro ntantero Ierusareminianra vuvaro kyara nraataa hura. ");
INSERT INTO omw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nraataa huvaro taqovaro qakyaakya voti huva fikivanto aanra tokyani vahuvaro mwiva uro mwia tamwa hiqu kyero nraankye tiro taqovaro mwanrevanto nraahu vahuvaro mwiva mwi kyatarirara tiqaro, E hia qaiqaavata tamwa rienanrave, tuvaro mwiaqaatairo mwi kyatariva tamusa viro. ");
INSERT INTO omw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mwi kyatariva tamusa vuvata Iesusira nraaqiaranramwu mwia taqeta qikye tita, Nataama kyerove kyatari mwituava qamwanrama tamusa viho? tita. ");
INSERT INTO omw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mwihua mwitaa tuvaro Iesusiva tiqaro, Nte qianinra riaate. Nkyenramwuvata hia taara vu nraato tiraitita, nianra kuaa vu nraato tuteta qioma nte mwaa kyatarirara tuntema kyeta tivarave. Nkye hia mwi kyaiqara nraahu varevarave. Nkye nronra kyaiqa mpo kyaiqa mpo kyaiqa qio varevarave. Nkye mwaa taaqiraravata tiqata, Nramanriqi kyavuhu quante, tivaro qioma mwitaa hiananrove. ");
INSERT INTO omw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Qikye, nkye mpo inraikyara Kotirara kyapara hiqatama mwiva qutaama mwi inraikyara timwiananrove tiraqaataitama nkye qio varevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesusiva mwitaa timwa kyero uro ntantero Kotira nraamwuqi uro variqaro nraakye qora qua timwa nyi varuvata Kotira nraamwuqi Kotira kyaiqa vara mwate varuhua mwihua nronra vaisinramwuvata, Iutaa nronra vaisinramwuvata, mwinramwuhua mwiva hunani uro nteta mwia inronra hita tiqata, E ta vaisiva variqarave mwaa kyaiqara vare variaro? Tava i nronraqama kyaiharave e mwaa kyaiqara vare variaro? tita. ");
INSERT INTO omw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mwihua mwitaa tuvaro Iesusiva nkyiari timwa nyinro tiqaro, Kyai nte nraante nkyi kyapara hiarita nkye nte qiani quara qio timwa mpivera, nte ntena nronraqama vina variqana mwaa kyaiqara varaurara nkyi timwa nyiankye. ");
INSERT INTO omw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tava Ioninra nronraqama kyovaro Ioniva nraakye qora nramanri nyunrave? Kotivave, qumina vaisivantove, mwia nronra qama kyovaro mwi kyaiqara varorave? Nkye timwa mpivaqena riaankye, tiro. Iesusiva mwitaa tuvata mwihua nai kyapara hita nai kyapara hita tiqata, Tire nanra quave qiananrave? Tire tiqata Kotiva mwia nronraqama kyorave qiarera, mwiva tiriara nkye nanraqamave Ioninra quara hia qutaave qiavo qiananrove. ");
INSERT INTO omw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tire tiqata qumina vaisivanto mwia nronraqama kyorave qiarera, tire nraakye qora ntuvaantuama vita variahuara aatu hiananrave. Ekyaa nraakye qoravanto Ioniva poropeti vaisivanto varurave ti variarave, tita. ");
INSERT INTO omw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mwihua mwitaa timwa kyeta Iesusirara tiqata, Nai tava Ioninra nronraqama kyorave? Hia tire ntapihuro, tita. Mwihua mwitaa tuvaro Iesusiva tiqaro, Nkye mwitaa qiavana nte nina nronraqama kyaihana mwaa kyaiqara vare varurara hia nkyitavata timwa nyianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iesusiva mwitaa timwa kyero tiqaro, Nte tirera hiani quara mwaanra nkye nataamave riaavo? Vaisi mpovanto qoraisi nraaqiara taaratana vatorave. Mwia qova nai mwaaqu tauraarara tiqaro, Ni maaquo, Mate uro uaini aakyoqi kyaiqa varaante, tuvaro ");
INSERT INTO omw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","mwia mwaaqu tauraava tiqaro, Qaqao, hia quataa ihana hia virerave, tiro. Mwitaa timwa kyero mwiva variqaro mpo vu nraato tu kyero nai qora uaini aakyoqi kyaiqa vararero vurave. ");
INSERT INTO omw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mwiva vuvaro mwia qova nai nraaqiara nraakiaraara mwianravata uro kuaa qua mwia nraahu tuvaro mwiva qumina eo timwa kyerovata hia viraitiro qaqira kyero varurave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Iesusiva mwi quara timwa kyero mwihua kyapara hiro tiqaro, Mwia nraaqiaratanaqitairo ta nraaqiarava nai qora qua riorave? tuvata mwihua tiqata, Mwia vakyaava tauraava nai qora qua riorave, tita. Mwihua mwitaa tuvaro Iesusiva timwa nyinro tiqaro, Qio mwi quara rieqatama nte tirera hiani quara ntapihi kye riaate. Taakisi vare variahuavata, api nrohi varia nraakyehuavata, variavata nkye mwihuara uaqia hia nraakye qorahuave qiahua, mwihua nkyi nraatara kyeta Kotiva ntaqikyiraqi mwihua nraante vi variarave. ");
INSERT INTO omw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Haaru Ioniva nri ntero ntapihi kye vahi aanranra nkyi nyaamwutaankye tuvata nkye mwia quara hia qutaa quave turave. Taakisi vare variahuavata, api nrohi varia nraakyehuavata, Ioninra quara qutaave turave. Nkye variqata taqovata mwihua Ioninra quara qutaave tuvata nkye hia mwihua hunte hurave. Nkye mpo vu nraato tu kyeta uaqia hi aanranra qaqira kyeta Ioninra quara qutaa quave qiataara vahuvata nkye hia mwitaa hiraitita varurave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iesusiva mwitaa timwa kyero tiqaro, Nkye rie varivaqena nte mpo quaqaa ntumwa kyena nkyi timwa nyiankye. Mwata airi vahu vaisiva uaini vara tutero, mwia vara ututu tutukya utu tero, mwata quvu kyero uaini tamwa tatianinra ututero, haraara nraamwu mpuahaantaqi variqata mpuara vaisiara taqeravata ututorave. Mwiaqaatairo mwiva nyianra mpo mwatani virera hiro, vaisi mponramwu timwa nyinro tiqaro, Nkye ni uaini aakyoqaa ntaqikyi mate varivaqe nte quankye, timwa kyero mwiva nyianra mpo mwatani vurave. ");
INSERT INTO omw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mwini uro varuvaro uaini hiqi entava nri ntovaro mwiva nai kyaiqa vaisi mponramwu sitero tiqaro, Uro ni aakyoqaa ntaqikyi varihua tivata uaini ninanivata hiqu nyivata vare nriate, tuvata mwihua mwini vurave. ");
INSERT INTO omw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mwini vuvata mwia aakyoqaa ntaqikyi varuhua mwia kyaiqa vaisinramwu ntavaaqavu kyeta mpo kyaamwuqo ntuqutu kyeta vateta, mpo ru kyeta, mpo oriqo ntuqutu kyeta vatorave. ");
INSERT INTO omw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mwitaa huvaro aakyo qova qaiqaa vaisi kyaata airiqama sitovata mwihua tauraa mponramwu huntema kyeta mwihuavata kuaa qarama nyatorave. ");
INSERT INTO omw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mwitaa huvaro aakyo qova nraakiara ekyaara nai mwaaqu kuaiqia titero tiqaro, Mwihua mwia taqeta nianra mwia mwaaquve tiqatama mwia kyuqema mwatevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mwitaa timwa kyero mwia titovaro vuvata mwia aakyoqaa ntaqikyi varuhua mwia taqeta nai timwa mwi nai timwa mwi hita tiqata, Mwaa vaisiva nai qova qutu viraro nai qora mwatavata ekyaa inraikyavata varaarivama variho. Nrivaqe mwia ru kyaararo mwiva vararera hiari inraikyava tirini nraahu vahiarive, tita. ");
INSERT INTO omw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mwihua mwitaa timwa kyeta mwia ntavaaqavu kye aakyoqitaita mwaaqani mwaati kyeta mwia ru kyorave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Iesusiva mwitaa timwa kyero mwihua kyapara hiro tiqaro, Mwitaa hurara tiro, aakyo qova nai mwaaqu rukyera kyaara nataave hiananrove? tiro. ");
INSERT INTO omw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mwitaa tuvata mwihua Iesusirara tiqata, Aakyo qova uaqia hia vaisihua mwihua ekyaa ru taiqa kyero mwiaqaatairo mwiva ni aakyoqaa ntaqikyiqata ninavata mpiate tiro, vaisi nraahumwa mponramwuma sita vataananrove, tita. ");
INSERT INTO omw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Mwihua mwitaa tuvaro Iesusiva tiqaro, Nkye hia Kotira mpukuqi mwaa quara kyaara ntumwa kyeta riaarave? Mwataama tiro: Ori nraamwu hoqeqata ori mpora hia kyuqe orive timwa kyeta qaqira kyaa oriva puhaqama viho. Kotiva mwi orira nronraqama kyairara tita, tire mwia taqeta kyuqe kyaiqave turo, turave. ");
INSERT INTO omw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nte mwi quara rieqanama nkyiara mwataama tuqo. Nkye mwia mwaaqu uaqiama mwatera kyaara Kotiva nkyiara hia ni nraakye qorave qiananrove. Mwiva nkyi qaqira kyero mpo mwatanaahuara mwihua ni nraakye qora varivaqena nte mwihuaqaa ntaqikyi variarita mwihua kyuqe kyaiqa vara mataate, qiananrove. ");
INSERT INTO omw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mwi oriraqaa tuto ntuariva ntupepaa hiro pataqia pataqia utu quananrove. Mwi oriva vaisiqaa tumu ntirera, mwi vaisira ntuqutu kyero mwumwu ntamwa kyero kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Iesusiva mwitaa tuvata Kotira nraamwuqaa ntaqikyi varuhuavata, Parisi vaisinramwuvata, variqata ntapihi kyovaro Iesusiva uaini aakyoqaa ntaqikyi varuhuaqaa ntumwa kyero mwihuara tuvata ");
INSERT INTO omw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","mwia ntavaaqavuqita uro ko qiare timwa kyeta taqovata nraakye qora mwini ntuvaantuama vuhua Iesusirara poropeti vaisivantove tuvata mwihua nyaatu aatu hiqata hia mwia ntavaaqavu kyora. ");
INSERT INTO omw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesusiva qaiqaa nraakye qora qua timwa nyinrenro mpo qua mpo quaqaa ntumwa kyero timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Mwiva mpo qua tiqaro, Kotiva nraakye qoraqaa ntaqikyiani quara vahirero vunyaa vaisi mpovanto nai mwaaquvanto nraakye varaaninranra rieqaro kyara tera taarama kye vatora votima kyero vaiho. ");
INSERT INTO omw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Vunyaa vaisivanto mwihua mwihua nyaanrama tero tiqaro, Nraakiara nkye nivatama kyeta kyara nraate, tiro. Timwa kyero variro kyara nrenra terama tero nai kyaiqa vaisi sitero tiqaro, Nkye uro mwihua timwa nyivata mwihua nrumu kyara nraate, tuvata uro timwa nyuvata mwihua hia quataa huvata hia vurave. ");
INSERT INTO omw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hia vuvaro vunyaa vaisivanto nai kyaiqa vaisi mponramwu qaiqaa sitero tiqaro, Nte nyaanrama tau nraakye qorahuara mwataama qiate. Nte kyara terama tauqo. Ntena kauvata mpo quara nraati kyuqeravata rukye toqa uta vatauqo. Ni maaquvanto nraata varaaninra nrumu taqeta mwi kyarara nraate, qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mwiva mwitaa tuvata mwiva nyaanrama to nraakye qorahua hia mwia qua riaraitita, mwihua nkyiari kyaiqa nraahu varaqita vurave. Mpovanto nai aakyoqi vuvaro mpovanto nai kyoqaa kyaiqa vararero vuvata ");
INSERT INTO omw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","mponramwuvanto vunyaa vaisi mwia kyaiqa vaisinramwu ntavaaqavu kyeta ntuqutu kye vateta ru kyorave. ");
INSERT INTO omw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mwitaa huvaro vunyaa vaisi mwia nai mpoqama kyero raraqa tovaro nai ntaqu vaisihua sitovata mwihua uro nai kyaiqa vaisinramwu rukyo vaisihua nkyiari rukyeta mwihua mwatukyave nraamwuve qia quara kyorave. ");
INSERT INTO omw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mwiaqaatairo vunyaa vaisi mwiva nai kyaiqa vaisi mponramwu nyaanrama kyero tiqaro, Ni maaquvanto nraata varaani kyarara nte terama tauqo. Nte nraakye qora nyaanrama tena taqauqaro mwihua kyaiqavanto hia qioqa iharo mwihua ni kyara nrevavata hia qioqa iho. ");
INSERT INTO omw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nkye mwihua qaqira kyeta uro hisai hisai aanra ntuvaantua hiraqa ta nraakye qorahuave taqaivata varihua mwihua sita kyeta mwihuara tiqata, Vunyaa vaisivanto kyara nraaninra nkyevata uro nraate qiate, turave. ");
INSERT INTO omw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mwitaa tuvata mwia kyaiqa vaisinramwuvanto aanrasaita ta nraakye qorahuave taqohua kyuqehuave, uaqia uhuave, ntuvaantuama kyeta sitaqita uro kyovata mwihua kyara nro nraamwunra piqa kyorave. ");
INSERT INTO omw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","(Mwi entara nraata varaani kyarara nranrenrata nru vaisihua qesana nri ntovaro qesana ntaqikyuva mwihua tavunaqotairo mwunruqama tovata uro mwatakyaa vita varura. Vunyaa vaisi mwia tavuna rupa varo vaisiva nraahu qio mwiqi mwatakyaa quarive tura.) Mwihua nraamwuqi huvai vuvaro vunyaa vaisivanto taqovaro qesanatairo hia tavuna varo vaisiva nraamwuqi varuvaro ");
INSERT INTO omw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","mwiva mwi vaisirara tiqaro, Qikye, ni vaisio, e hia qesanataira ni tavuna ruparaitira, e tanama kyerave mwaaqi vera ntera hiaro? tuvaro mwi vaisiva hia qio qua turave. ");
INSERT INTO omw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Hia qua tuvaro vunyaa vaisivanto nai kyaiqa vaisinramwu timwa nyinro tiqaro, Nkye mwaa vaisira kyuqu kyauqu rupa kyeta uto mwaatani upi hiraqi kyaate. Mwiva mwini variro ntateqaro nai aanrai kutiqaro variarive, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Iesusiva mwi quara timwa kyero mwiva tiqaro, Kotiva airi nraakye qora nyaanramatairaqitairo mpoqiatana nraahu sitaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Iesusiva mwitaa tuvata Parisi vaisinramwuvanto mwiqitai veva nteta uro ntuvaantuama vi varita tiqata, Nanra quave kyapara hiararo Iesusiva api qua qiananrove? Kyai mwaa quara kyapara hiare, timwa kyeta ");
INSERT INTO omw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","mwihua nkyiari sataqi nrohu vaisihua mponramwu siteta Herotira nramwunaahua mponramwuvata sitovata mwihua Iesusiva varunani uro nteta tiqata, Mwaanra ti variara vaisivao, e mwaanra okyara timwa timwianrata tire taqaurara e qutaa qua ti variaravave. E hia vaisi nraatu aatu hiraitira, vaisi nronranravata, qumina vaisiaravata, kuaa qua nraahu ti variaravave. ");
INSERT INTO omw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tire mwaa quara qiananranra e nataamave riaaro? Tire Kotira qua rieqatama qiove tire Romeni mwihua vunyaa vaisi Sisaara taakisi mwiananrave? (Mwi mwatanaahua hia Kotira qua riaarave.) ");
INSERT INTO omw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iesusirara api qua qiarive tu quara Iesusiva vaakya ntapihi kyero mwiva tiqaro, Nkye unraqama kyeqata kyuqe kyaiqa vare variahuave. Nkye nanraqamave nivanto api qua qiarive tita mwitaa ti variavo? ");
INSERT INTO omw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Taakisi munima kuaiqia ni naamutaivaqe taqaankye, tiro. Mwitaa tuvata mwi munimanra kuaaru mwuvaro ");
INSERT INTO omw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Iesusiva mwihua kyapara hiro tiqaro, Munima mwiaqaa tara virive vaiho? Tara nrutuve vaiho? tiro. ");
INSERT INTO omw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mwitaa tuvata mwihua tiqata, Sisaarave, tuvaro Iesusiva mwihuara tiqaro, Mwianra rieqatama nkye Sisaava hianinra nai mwiate. Kotiva hianinra Kotira mwiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iesusiva mwitaa tuvata mwihua mwia qua rieta tiqata, Qikye, mwiva tiri qua nraatara kyero kyuqe qua tiho, timwa kyeta kyauqu ntukikinraaqata kyeta Iesusira mwini kyeta vurama. ");
INSERT INTO omw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mwi entara Saitiusinramwuvanto Iesusiva varunani uro ntora. Mwi vaisihua nkyiari mwaanra qua rietama tiqata, Vaisivanto qutu quariva ekyaara qutu viro hiama qaiqaavata siquananrove, ti varu vaisihua uro nteta Iesusira kyapara hita tiqata, ");
INSERT INTO omw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Mwaanra ti variarao, tiri haivaqava Mosesiva mwaanra qua tiqaro mwitaa timwa torave. Vaisivanto hia nraaqiara mwataraitiro qutu viraro mwia qatavantove mwia vakyaavave mwia nraata varatero nraaqiara mwata humwuanrama mwataarive, turave. ");
INSERT INTO omw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tire qua qiananra riaante. Haaru mwaini qate vakye 7 nramwu varurave. Sakyaava nraakye mpo varatero hia nraaqiaravata mwataraitiro qutu vuvaro mwia qata mwia nanaava mwia nraata varatero ");
INSERT INTO omw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","mwivavata qati variqiro viro uro qutu vurave. Mwiva qutu vuvaro mpo mwia nanaava mwi nraakyera varatero hia nraaqiaravata mwataraitiro, qati variqiro viro qutu vuvata qio mwitaamaqi vita ekyaa mwi qate vakyenramwuhua mwi nraakyera varateta hia nraaqiara mwataraitita, qati qutita vurave. ");
INSERT INTO omw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Qutu vuvaro nraakye mwivavata variro qutu vurave. ");
INSERT INTO omw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nraakiara nraakye qora qutiraqitaita qaiqaa qati sivi entaraqaa mwi nraakyeva tara nraatave variananrove? Mwiva qati varu entara qoraisi 7 nramwu varatorave, tita. ");
INSERT INTO omw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Saitiusi vaisinramwuvanto mwitaa tuvaro Iesusiva mwihua nkyiari timwa nyinro tiqaro, Nkye Kotira qua qara ntumwa tora hiave ntapihi hiavo? Nkye Kotira kepukyara hia riaarave. Nkye hia ntapihiahuara tita, nkye api qua qiavo. ");
INSERT INTO omw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nraakiara nraakye qora qutu vihua qutu viraqitaita qaiqaa sivi qati variqi vi entara hiama nraakye qora nai vare nai vare hivarave. Mwihua nyaamwunyaahua votima kyeta qati varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Iesusiva mwitaa timwa kyero mwiva tiqaro, Nraakye qora qaiqaa qati sivi vari okyarara nte nkyi kyapara hirerave. Nkye hia Kotira mpukuqi mwaa quara qara ntumwa tora kyaara ntumwa kyeta riaarave? Kotiva mwitaa turave: ");
INSERT INTO omw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nte Kotiva nte i haivaqahua mwanriqavanto varuqo. Nte i haivaqahua Evarahaamunraqaave, Aisaakiraqaave, Iaikopuraqaave, ntaqikyi varuvave, turave. Qio riaate. Qutu viro taiqavi inraikyaraqaa hia Kotiva ntaqikyi varivave. Qutu viro qaiqaa siviro qati variqiro vi inraikyaraqaa Kotiva ntaqikyi varivama variho, tiro. ");
INSERT INTO omw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iesusiva mwitaa tuvata nraakye qoravanto mwini ntuvaantuama vuhua mwia qua rieta tiqata, Qikye, Iesusiva okyara quama timwa timwiho, tita. ");
INSERT INTO omw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Parisi vaisinramwuvanto riovaro Iesusiva Saitiusi vaisinramwuvanto tu quara nraatara kyovata mwihua ntuvaantuama vuraqitairo ");
INSERT INTO omw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","vaisi mpovanto mwaanra okyara timwa nyi varu vaisiva Iesusirara api qua qiarive tiro, mpo qua Iesusira kyapara hiro tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Mwaanra ti variarao, Kotiva qua timwa toraqitairo nanra quavantove nronraqama kyero vuni vahi quava vaiho? tiro. ");
INSERT INTO omw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Mwitaa tuvaro Iesusiva timwa mwinro tiqaro, Iqaa ntaqikyira Kotirara ekyaa ena mwutukyaqitairave, ekyaa ena mwanraquraqitairave, ekyaa ena vu nraatoqitairave, mwianra nraahu mwutukya vahirara variante, turave. ");
INSERT INTO omw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Qio mwi quava okyara qua vuni vahi quava vahirave. ");
INSERT INTO omw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mwi quara nraakiara okyara qua mpo vaiho. Mwi quava vuni vahi quara votima kyeroma vaiho. Mwitaama tiro: Inanra mwutukya vahintema kyero ina nramwunaanranravata i mwutukya vahiarive, turave. ");
INSERT INTO omw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mwi quavavata okyara qua puha rataara votima kyero vaiharo ekyaa mpo qua Mosesiva timwa to quavave, poropeti vaisivanto timwa to quavave, mwi quatanaqaa hiriviro vahirave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi vaisinramwu mwini ntuvaantuama vita varuvaro Iesusiva mwihua kyapara hiro tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Nkye Kotiva titai vaisira Mesaiaara nataamave riaavo? Mwiva tara okyaraqitairo mwatataarivave variananrove? tiro. Iesusiva mwitaa tuvata mwihua tiqata, Mwiva tiri haivaqara Ntevitira okyaraqitairo qovara hiananrove. Mwiva Ntevitira nraisima variananrove, tita. ");
INSERT INTO omw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mwihua mwitaa tuvaro Iesusiva tiqaro, Nataama kyerove Mesaiavanto Ntevitira nraisi variananrove? Haaru vetato entaqaa Ntevitiva varuvaro Kotira mwanraquravanto mwia kyaahaqa huvaro Ntevitiva Mesaiaara tiqaro, Mwiva ni nronravantove turave. Ntevitiva mwataa turave: ");
INSERT INTO omw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Kotiva ni nronra vaisiara tiqaro, E nritarera ni kyauqu kyaatutani mwatakyaa vira variraqena nte i nramwutaahua ru taiqa kyena nraatara kyaarira e mwihuaqaa kyuqu ntamwa tera variante, turave. Ntevitiva mwitaa turave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Iesusiva mwitaa timwa kyero qaiqaa kyapara hiro tiqaro, Ntevitiva Mesaiaavanto qovara hianinranra tiqaro, Mwiva ni nronra vaisive, turave. Ntevitiva mwitaa turara tiro, nataama kyerove Mesaiaavanto Ntevitira nraisi variananrove? tiro. ");
INSERT INTO omw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iesusiva mwitaa tuvata mwihua nai timwa mwianre tita quara puaa huvaro hia vahuvata mwihua mwi entaraqaataita aatu hiqata qaiqaavata mpo qua mwia kyapara hiarorave timwa kyeta varura. ");
INSERT INTO omw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iesusiva mwitaa timwa kyero nraakye qora mwini ntuvaantuama vita varuhuaravata nai nraaqiaranramwuanravata tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mwaanra okyara ti varia vaisihuavata, Parisi vaisinramwuvata, Mosesiva timwa to quara kyuqe qua nkyi timwa nyiqi vi variara ");
INSERT INTO omw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","nkye mwia riemwaqita quate. Nkye mwihua qua mwia nraahu rieqatama hia mwihua nrohiantema kyeta nrohiate. Mwihua mpohuara nkye mwitaa mwataa hiate timwa kyeqata nkyiari hia mwitaa hiraitita, mwihua uaqiama kyeqata nrohi variarave. ");
INSERT INTO omw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Qikye, mwihua nronraqama kyero muaanra ntai quara rupa kyeta varaqita uro nraakye qoraqaa qu nyateta mwihuara qu varaate timwa kyeta mwihua hia nkyiari kyauqu tutu kyeta nraakye qora kyaahaqa hi variarave. ");
INSERT INTO omw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nraakye qoravanto mwihua mwahuta qiate tita, Parisivanto Kotira kyaiqa vara mwate variarave. Mwihua Mosesiva tu quara qara ntumwa kyeta qapuqama kyeta nkyiari tiriqa quteta, kyaataaqivata rupateta, tavuna mpuahaa kyuqera rupa vareta nraakye qoravanto mwihua taqaate tita, mwatukyaqaa nrohi variarave. ");
INSERT INTO omw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mwihua omwata nraanraqaa uro variqata vaisi nronravanto mwatakyaa viqata varianani variare timwa kyeqata variarave. Mwihua mwaanra nraamwuqi uro variqata kyuqe taintaqaa nraahu mwatakyaa vita variarave. ");
INSERT INTO omw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nraakye qoravanto mwihua kyuqema kye qua mwanteqata mwaanra qua ti vari vaisivave qiate tiqata maaketiqi mwihua kyakyama kyeqata nrohi variarave. ");
INSERT INTO omw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nkyevata kuaa qara hivorave. Vaisi mpovanto nkyi qua mwantero nkyiara tiqaro, E vaisi nronra mwaanra qua ti variaravave, qiankyorave. Mpovanto mwitaa tirera, nkye mwianra, Hia qaiqaavata mwitaa qiante, qiate. Tire qata vakyaama varuro, qiate. Tiri mwaanra qua timwa timwi variva kuaikuvanto nraahuma variho qiate. ");
INSERT INTO omw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nkyi sova kuaikuvanto nyaamwuni varirara tita, hia mwatani variani vaisira mpora tiri tiqovave qiate. ");
INSERT INTO omw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nkye vaisi mpora tiri qiata vaisive tivorave. Nkye tiqata, Kotiva titaiva Mesaiaavanto, mwiva nraahuma tiri qiata vaisivanto variho, qiate. ");
INSERT INTO omw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nkyiqitairo mpovanto nronra vaisi varirera, mwi vaisiva nkyini kyaiqa vara nyataariva variarive. ");
INSERT INTO omw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nai nrutu tuaaheraariva variraro Kotiva mwia nrutu vara mwataniqama kyaananrove. Nai nrutu vara mwataniqama kyaariva variraro Kotiva mwia nrutu tuaahera kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mwaanra okyara ti variahuavata, Parisi vaisivata, nkye unraqama kyeqata kyuqe kyaiqa vare variahuave. Nkye nraakiara uaqiama virara rieqanama nte nkyiara po kye timwa nyatauqo. Nraakye qoravanto Kotiva ntaqikyiraqi virera uti variavata nkye qesa mwihua suqaa vahira vara mwatumwi tite variavo. Mwitaa hiqata nkye nkyeta mwihua hia Kotiva ntaqikyiraqi viraitita, mpohua mwiqi virerata uti variavata nkye mwihua aanra tite variavo. ");
INSERT INTO omw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mwaanra okyara ti varia vaisihuavata, Parisi vaisivata, nkye unraqama kyeqata kyuqe kyaiqa vare variahuave. Nkye vita raupirima virara nte po kye tuqo. Nkye tetoqa nraakye mwihua nraamwu mpuara vare varita tiqata, Mpovanto tire uaqia hi kyaiqara utuananra taqero tiriara uaqia hia vaisihuave tivorave, tita nkye nraakye qora suqaa variqata Kotirara mpuahaaqama kyeta aakyara nte variarave. Po, mwia kyaara nkyiqa qua vahiariva nronraqama kyero vahiananrove. ");
INSERT INTO omw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mwaanra okyara ti varia vaisihuavata, Parisi vaisivata, nkye unraqama kyeqata kyuqe kyaiqa vare variahuave. Nte nkyiara po kye tuqo. Nkye airi vaisi vara uaqiama kyarerata uti variarave. Vaisi mpovanto nkyi qua rieqaro nkyi vataqiro quarive tita, nkye mwia puaa hirerata kyaarera nronra teqa vareta nyianrani nrohiqata mwia puaama kyeta mwia nkyeta kyaiqa nraamwutaavaro mwiaqaatairo mwi vaisiva nkyivata nraatara kyero mpoqiavata uaqia hi vaisiva varirave. Nkye utuaraqaara mwiaqaa qua nronravantoma vahiananrove. ");
INSERT INTO omw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nkye mpohua aanra nyaamwutarerata uti variavaro nkyita su qipa vihua variavo. Nkye nraakiara vita raupirima virara nte po kye tuqo. Nkye nraakye qora mwaanra okyara timwa nyiqata mwitaama tita, Vaisivanto Kotira nraamwu nrutu nteqaro nai kyauqu nriqiqaa vatero tiqaro, Nte mwitaa mwitaa hirerave, tirera, mwiva qiari quava hia mwia tutaananrove. Vaisivanto Kotira nraamwuqi vahira kori munima nrutu nteqaro nai kyauqu nriqiqaa vatero tiqaro, Nte mwitaa mwitaa hirerave, tirera, mwiva hia mwi quara nteqa kyaarive, qiarave. ");
INSERT INTO omw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nkye mwitaa tiqatama api quama qiavo. Nkyi su qipa vihata variavo. Kotira nraamwuvanto vuni vahi inraikyavama vaiho. Kori munimavanto Kotira nraamwuqi vaiharora tiro, Kotira nraamwuvanto mwi munimanra vara kyotataqama kyairave. ");
INSERT INTO omw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nkye mwaanra qua apiqama kyeta nraakye qora timwa nyita tiqata, Quara rukyeta Kotira mwi varia taintara vaisivanto mwi taintara nrutu nteqaro nai kyauqu nriqiqaa vatero tiqaro, Nte mwitaa mwitaa hirerave, tirera, mwiva qiari quava hia mwia tutaananrove. Vaisivanto mwi taintaraqaa rukyero vatai quarara nrutu nteqaro nai kyauqu nriqiqaa vatero tiqaro, Nte mwitaa mwitaa hirerave, tirera, mwiva qiari quava mwia tutaananrove. Mwiva mwi quara hia nteqa kyaarive, qiarave. ");
INSERT INTO omw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nkye mwitaa tiqatama api qua ti variavo. Nkyi su qipa vihata variavo. Tainta mwiaqaa rukyeta vataa quarava hia tainta mwia nraatara kyero vuni vahi inraikyava vahirave. Kotira nraamwuqi vahi taintava vuni vahivara tiro, quara mwia vara kyotataqama kyairave. ");
INSERT INTO omw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Vaisivanto kyauqu nriqiqaa vateqaro mwiva tainta mwia nrutu nteqaro mwiva tainta mwiavata, tainta mwiaqaa vahi inraikyaravatama, nrutu ntaiho. ");
INSERT INTO omw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Vaisivanto nai kyauqu nriqiqaa vatero Kotira nraamwu nrutu nteqaro mwiva hia nraamwu nrutu nraahuvauma ntero, mwiva nraamwu nrutuvata, nraamwuqi varira Kotira nrutuvatama, nterove. ");
INSERT INTO omw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Vaisivanto nai kyauqu nriqiqaa vatero nyaamwu nrutu nteqaro mwiva hia nyaamwu nrutu nraahuvauma ntero, mwiva Kotiva mwatakyaa vi taintara nrutuvata nteqaro mwi taintaraqaa mwatakyaa viro varira Kotira nrutuvatama nterove. ");
INSERT INTO omw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mwaanra okyara ti varia vaisihuavata, Parisi vaisivata, nkye nraakiara raupirima virara rieqanama nte nkyiara po kye timwa nyatauqo. Nkye unraqama kyeqata kyuqe kyaiqa vare variahuave. Nkye uapaa kyara haantave, honti mperu mwia nraahu Mosesira qua riemwaqita viqata ntainra kye Kotiranive, qiara nai mwi variarave. Nkye mwi quara nraahu riemwaqita virerata uti variqata mwaanra qua mpovanto mwi quara nraatara kyero vahira, mwi quara nkye hia rie variarave. Ntapihi kye ko ti okyararave, po kye timwa nyate okyararave, Kotirara kepukyaqama kyeta rie okyararave, nkye mwi quara mwi quarara hia nronraqama kyeta rie variarave. Nkye pata qua rieqatama mwi quaravata, nronra quavata, riemwaqita quataarave. ");
INSERT INTO omw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nkye mpohua aanra nyaamwutarera uti variavaro nkyita su qipa vihata variavo. Nkye nramanri nraanre tita taqaavaro upauvanto mwiqi vaihata nkye mwia qatinani vara kyeta aasau nronravanto mwiqi vahira mwiavatama kyeta nrapitama kye variarave. ");
INSERT INTO omw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mwaanra okyara ti varia vaisihuavata, Parisi vaisivata, nkye raupirima virara nte nkyiara po kye timwa nyatauqo. Nkye unraqama kyeqata kyuqe kyaiqa vare variahuave. Nkye kaapuvata tanuvata mwaaqani nraahu hiqe variahuave. Nkye nkyeta pahi nraahu hiqama kyaavaro nkyi utaqi vaisi rukyevave, mpuara varevave, nkyetara nraahu rieqata vare varivave, mwi inraikyava nraahu vaiho. ");
INSERT INTO omw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nkye Parisi vaisi mwaahuao, nkyi su qipa vihata variahuave. Nkye kaapuvata tanuvata utaqi nraante hiqama kyaivaro mwaaqanivata kyuqema vahiarive. ");
INSERT INTO omw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mwaanra okyara ti varia vaisihuavata, Parisi vaisivata, nkye nraakiara vita raupiri hirara nte nkyiara po kye tuqo. Nkye unraqama kyeqata kyuqe kyaiqa vare variahuave. Vaisi quntamwa teta simenti ntamwa kyeta mwiaqaa penti eqarori qutaara nkye mwia votima kyeta variarave. Simentiqaa penti eqarori qutaara taqeqaro mpovanto kyuqema kyero vaiho tiharovata mwataqi qutu vira mwukyaarivata tapitai inraikyava nraahuma vaiho. ");
INSERT INTO omw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mwia votima kyeta nraakye qoravanto nkyi mwaaqani taqeqata vaisi kyuqe hiahuave qiavarovata nkyi utaqi unra qua ti variavavata, uaqia hi kyaiqara uti variavavata, piqairave. ");
INSERT INTO omw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mwaanra okyara ti varia vaisihuavata, Parisi vaisivata, nkye nraakiara vita raupiri hirara nte nkyiara po kye tuqo. Nkye unraqama kyeqata kyuqe kyaiqa vare variahuave. Nkyi haivaqahua haaru variqata poropeti vaisi Kotira qua qovarama kye varu vaisihua rukyeta quntamwa torave. Mwihua quntamwa toraqaa nkye kyuqema kyeta haraara nraamwu hoqa nyate variarave. Nkyi haivaqahua variqata avuqavuma kyeta nrohu vaisihua rukyeta quntamwa toraqaa nkye ntupi kyeta kyuqe hi variarave. ");
INSERT INTO omw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nkye mwihua nyaisivanto tiqata, Tire haaru mwi vakya variavaratiri, hiama tire teta haivaqahua nraantanteta poropeti vaisi mwihua ruavaratirio, qiarave. ");
INSERT INTO omw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nkye tiqata, Tiri haivaqahua haaru poropeti rukyohua tire mwaa mwihua nyaisima varuro, qiarave. Nkye mwitaa qiavaro nkyeta qia quavama nkyita tutaiho. ");
INSERT INTO omw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Qio nkyeta haivaqahua uaqia hi kyaiqara tohara taara varaqita uro taiqa kyaate. ");
INSERT INTO omw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nkye quaihavanto variavo. Nkye quaiha nraaqiaravanto variavo. Kotiva nkyi ko timwa kyero qia nronraqi tuto kyaananrove. Hia qio nkye mwiqitaita ntuqema kyeta vivarave. ");
INSERT INTO omw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nte qianinra riaate. Nte poropeti vaisive, kyuqe vu nraato vataa vaisive, kyuqe qua timwa nyi vaisihuave, sitaarita nkye mwihua mponramwu ru kyeta mponramwu rukyeta kyatariqaa hiriteta mponramwu nkyeta mwaanra nraamwuqi sitaqita ntuqutu kyeta vateta mponramwu mpo mwatukya mpo mwatukyaqitaita ntuqutu sataqita nrohivarave. ");
INSERT INTO omw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mwianravata rieqaro haaru mpo vaisinramwu ru kyo quavavata nkyiqaama vahiananrove. Tauraaqama kyero Everira qumina rukyoraqaatai tohara kye mwihua ruqi nrita nrumu ekyaara Mperekaiaara mwaaqu Sekaraiaara rukyorave. Mwia rukyarerata Kotira nraamwuvanto hini vahuvaro, quara rukye qia quara mwate varu taintava hini vahuvaro, Sekaraiaava Kotira kyaiqa vareqaro utana varuvata mwia rukyorave. Ekyaa mwihua rukyo quavavata nkyiqaama vahiananrove. ");
INSERT INTO omw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nte qianinra riaate. Mpohua mpohua Kotira nraaqiara rukyo quava, ekyaa mwi quava mate mwaa entara variahuaqaama vahiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Iesusiva mwitaa timwa kyero tiqaro, Po, Ierusaremiqinaa nraakye qora tuaavo, Ierusaremiqinaa nraakye qora tuaavo, nkye Kotira poropeti vaisinramwu ru kyaahuave. Kotiva sitai vaisihua variavata nkye ori pati kyeta mwihua ntuqutu kyaahuave. Kokoraaravanto nai nraatiqaa nraaokya iri kyero qutaintema kyena nte airi nani nkyiara po timwa kyena nkyiqa ntaqikyiankye tuqata nkye ni qoririma kyeta ni qaqira kyaavo. ");
INSERT INTO omw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mwia kyaara Kotiva nkyi qaqira kyairaro nkyi mwatukyaqi hia vaisivata varivaro qumina mwata nraahuma vahiananrove. ");
INSERT INTO omw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nte qianinra riaate. Nkye mwaa entaraqaataita hia ni taqaraitita varivaqena nte qaiqaa tumu variarita nkye mwi entara ntapihi kyeta ni taqeta nianra tiqata, Kotiva titai vaisiva tumiho. Mwia kyuqema mwataate tivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesusiva mwitaa timwa kyero Kotira nraamwu mwini kyero virera utuvata mwia nraaqiaranramwuvanto tiqata, Kotira nraamwu kyuqera mwaa taqaante, tuvaro ");
INSERT INTO omw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iesusiva eo tiro, Nkye mate nraamwu mwaa mwiavata kyuqe inraikya mwiqi vahiravata taqaavaro vahirave. Nte qianinra riaate. Nraakiara ori taaqautaava mpoqiavantovata hia nai mwoqaqa nai mwoqaqa vahiananrove. Nraamwu mwaa ntukuraakurama kyaivaro tumu ntiro orivanto mumuni utu quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesusiva mwitaa timwa kyero uro Oripi taaqiqaa mwatakyaa viro varuvata mwia nraaqiaranramwuvanto nkyiari nraahu mwiva varunani uro nteta mwia kyapara hita tiqata, Vaakya qiarava taireve qovara hiananrove? Nanra inraikyavanto qovara hiraqeta tire mwiaqaa vitama kye taqetave tire iara mwiva qaiqaa tuminranro mwaa mwatara taiqaani entava qaumatoma vaiho qiananrave? tita. ");
INSERT INTO omw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mwihua mwitaa tuvaro Iesusiva tiqaro, Mpovanto nkyi unra qua timwa nyianinranra rauriqata variate. ");
INSERT INTO omw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nraakiara vaisi airivanto qovarama vita ni nutu nteqata Kotiva ni titaihana nruvave tivata airi nraakye qoravanto mwihua unra quara qutaa quave tivarave. ");
INSERT INTO omw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nkye varivata ntaqiqata qua vora ntaivata hia aatu hiate. Ntaqi quava aanrasairo nrinrata hia aatu hiate. Ntaqi variva nri ntairata nkye ekyaara enta nri ntaiho tivorave. Mwi inraikyava nraante qovara hiananrove. ");
INSERT INTO omw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mpo mwatanaava mpo mwatanaanravata ntaquananrove. Qiata vaisivanto qiata vaisivata ntaquananrove. Mpo mwataqi mpo mwataqi nronraqama kye aara nte entava vahiananrove. Mpoqi mpoqi mwatura tuananrove. ");
INSERT INTO omw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ekyaa mwi inraikyava qovarama virata hia ekyaara enta nri ntaiho qiate. Nraaqiara mwatarero qakyo atura ntuariva vaiharo vuni nriqa vi inraikyara pataqia tohara taintema kyero, muaanra vahiani entava qati tohara taiho, qiate. ");
INSERT INTO omw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mwi entara nkyi ntavaaqavuqita uro kyaivata nkyi uaqiama nyateta nkyi ru kyevarave. Mwi entara nkye ni nraakye qora varivatara tita, mwia kyaara ekyaa mpo mwatanaa mpo mwatanaahua hia nkyiara mwutukya vahirata varivarave. ");
INSERT INTO omw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mwi entara nianra qutaa mwivave tihua airivanto qaqira kyeta nramwutaavanto nrivata nkyiari henahua qovarama kyeta vitira mwivave mwaa mwivave timwa kyeta mwihua nramwutaaqa hivarave. ");
INSERT INTO omw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mwi entara airi vaisivanto qovarama vita variqata nte Kotira qua qovarama kye varuvave timwa kyeqata airi nraakye qora unra aanra nyaamwutevarave. ");
INSERT INTO omw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mwi entara uaqia hiari kyaiqava nronraqama kyero vahirata airi nraakye qoravanto mpohuara mwutukya vahianinra qaqira kyevarave. ");
INSERT INTO omw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mwi entara hia pupohairaro kepukyaqama kyero variqiro viqaro uro kyuqe aanra taiqa kyaani vaisira, mwiama Kotiva vitairaro nyaamwuni uro variananrove. ");
INSERT INTO omw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kotiva nraakye qoraqaa ntaqikyiani quara timwa nyiqi vivata ekyaa mwata mwaaqaa varihua mwi quara riaivaro qio mwiaqaatairo ekyaara enta nri ntaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Iesusiva mwitaa timwa kyero mwiva tiqaro, Nraakiara nkye taqaivaro uaqia hiari inraikyava vaisi vehi utu kyaari inraikyava qovarama quananrove. Vetato entaqaa poropeti vaisi Ntanieriva mwi inraikyara qora inraikyara turave. Nkye taqaivaro mwi inraikyava Kotira nraamwu turuarani hia qumina vaisivanto vera nteta vari nraamwunraqi uro siviro variananrove. (Mwaa quara kyaara ntirava ntapihi kyera riaante.) ");
INSERT INTO omw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mwiva mwini uro varirata Iutiaani varihua sivita hiantamwa teta verara taaqiqaa quate. ");
INSERT INTO omw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mwi entava nri ntairaro nraamwu aatareqani variariva hiantero virera hiro hiama nraamwuqitairo vera ntero mpo inraikyavata varaarive, qatima hiantero quarive. ");
INSERT INTO omw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mpovanto aakyoqi kyaiqa vare variariva hiama hiantero nai vaaqatua vararaitiro, qatima hiantero quarive. ");
INSERT INTO omw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mwi entara nraaqiara tuaqama quari nraakyevave, nraamwa mwi variari nraakyevave, po, anoma kyero mwihuara hia kyuqe enta vahiananrove. ");
INSERT INTO omw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Hia kyuqema kyero huari itaani entaraqaave, mwaanraqaave, mwi entava nri ntairata nkye hianteta quare tira mwukyaari tukyevarave. Mwianra rieta nkye Kotirara aakyara tivaro huari kyuqema kyero itaaninraqa mwi entava nrinrata nkye qio aatu quate. ");
INSERT INTO omw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Po, nraakiara mwi entava nri ntairata muaanra nronra vareta atura ntiqata varivarave. Nraakye qoravanto uaqiama vita varivarave. Haaru mwata mwaa ututo entaraqaatairo hia mwitaa hi entavavata qovara hurave. Nraakiaravata hia mwi entara voti hiariva qaiqaavata qovara hiananrove. ");
INSERT INTO omw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mwi entava mpuahaa enta vahiratavauma, ekyaa nraakye qora taiqa vivaro hia mpoqiavantovata variananrove. Qio Kotiva nai kyaama tai nraakye qorahuara rieqaroma mwi entara qiquqama kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mwi entara mpovanto nkyiara Kotiva titaiva Mesaiaavanto mwainima variho, mwinima variho, tirera, hia mwia qua riaate. ");
INSERT INTO omw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mwi entara airi vaisivanto qovarama vivaro mpovanto unra tiro tiqaro, Nte Mesaiaave, tiraro mpovanto, Nte Kotira qua qovarama kye varuvave, tiraro mwitaamaqita viqata airi unra ti vaisihua qovarama vivarave. Mwihua qovarama vita unra kyaiqa varaqi viqata Kotiva nai kyaama tai nraakye qorahua mwihua tiri quara qutaa quave tiqata uaqia hi aanraqaa quate tita, nronra kyaiqa varaqita vivarave. ");
INSERT INTO omw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Qio nkye hia mwi vaisihua quara qutaa quave qiate tina, nte mwaa entara variqana nraakiara qovara hianinranra mate nkyi timwa nyi varuqo. (Nte nraakiara tumu qoqaa variarita ekyaa nraakye qora ni taqevarave.) ");
INSERT INTO omw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mwi quara riemwaqita vivaro nraakiara mpovanto nkyi timwa nyiqanro nianra mwiva qovarama viro qumina satama variho tirera, hia mwini ni taqarerata quate. Nkyi timwa nyiqanro nianra mwiva nraamwu mwiqi uqeta viro variho tirera hia mwia quara qutaave qiate. ");
INSERT INTO omw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aaquakyaa tiharo ekyaa nyaamwuvanto ntuvaahama vintema kyenama nte mwatani mwatatai nraaqiarava qoqaama tumuaninrave. ");
INSERT INTO omw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Taraqaave qutu quari inraikyava vahianinra mwiaqaama memonravanto ntuvaantua hivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Iesusiva mwitaa timwa kyero tiqaro, Nraakiara muaanra nronra vareqata atura nti entava taiqa viraro mwi entaraqaatairo qamwanrama huari vuvanto entama viraro toravanto hia itairaro qovoravanto tumu nti tumu nti hiraro nyaamwuni kepukya inraikya vahiva ekyaama qakyaa qakyaa hiananrove. ");
INSERT INTO omw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mwi entara nraakye qoravanto nyaamwuqi mpo inraikya qovara hianinra taqeqatama qio mwia nianra mwiva tuminrenro tera iho tivarave. Mwihua mwitaa timwa kyeta ekyaa mwata maata vahintema varihua kyora mwata hivarave. Mwihua kyora mwata hi variqata taqe varivaqe nte mwatani mwatatai nraaqiarava nyaamwusaina tonamwuqi tumi variarita ni taqevarave. Nte mwunruqama taari inraikyava mpoqama kyero itero ntuvaahero ante anta hi variraqena nte kepukyavanto tumi ");
INSERT INTO omw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","variqana nyaamwunyaahua sitaarita ntomavanto nronraqama kyero nruqua tirata mwihua uro mwata mpoqitai mpoqitaita Kotiva nai kyaama tai nraakye qorahua ekyaa ntuvaantuama kyeta sitevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Iesusiva mwitaa timwa kyero tiqaro, Nkye fiki kyatari vitama kye taqeqatama mpo qua ntapihi kyeta riaate. Kyatari mwiva tamwa riemwa taiqa kyero vahiro mwiaqaatairo qaraakya mwunri ntarero utihata nkye mwiaqaa vitama kye taqeta tiqata, Huari nronra itaari entava qaumatoma vaiho, qiarave. ");
INSERT INTO omw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mwia votima kyeta nraakiara qovara hiani inraikyarara tura, nkye mwia vitama kye taqeta nianra mwiva tumuani entava qaumatoma vaiho tivarave. ");
INSERT INTO omw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nte qutaama tuqo. Mwaa entara varihua hia ekyaa qutu vivaro mwi inraikyara mwi inraikyarara tuva qovara hiananrove. ");
INSERT INTO omw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nyaamwuvantovata mwatavantovata taiqa viraro ni quavanto nraahuma qati vahiqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Iesusiva mwitaa timwa kyero tiqaro, Ta iherarave, huari vuvanto taraqaave, vahiraqe nte tumuaninrave? Hia vaisi mpovanto ntapihi kyairave. Hia nyaamwunyaahuavata mwianra ntapihiarave. Ntenavata mwatani mwatatai nraaqiarava variqana hia mwianra ntapihurave. Kotiva ni kova, mwiva nraahu mwi entarara ntapihirave. ");
INSERT INTO omw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noaava varu entara nraakye qoravanto utuntema kyero nraakiara nte mwatani mwatatai nraaqiarava tumuani entaraqaa vahiananrove. ");
INSERT INTO omw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mwi entara hia vati nramanrive, humwunravanto ntumwaqu kyo entara nraakye qoravanto kyara nreta, nramanri nreta, nraata vaati vareta, mwitaamaqi vi varuvaro Noaava nramanriqaanaa nraamwuqi viqetero varuvaro ");
INSERT INTO omw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","vati humwunravanto nrivi varuvaro mwihua su nyaatovanto ntapihi vuvata tiqata, Qikye, tire taiqa quara entava nri ntaiho, tuvaro nramanrivanto mwihua ntaqutu taiqa kyorave. Nte mwatani mwatatai nraaqiaravama varuqo. Nte uro ntantena tumuani entaraqaavata nraakye qoravanto kuaa qarama kyeta varivarave. ");
INSERT INTO omw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mwi entara vaisi taaratanavanto aakyoqi kyaiqa vare varivaqena nte kuaiku nraahu vitena mpo mwia kyaaninrave. ");
INSERT INTO omw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mwi entara nraakye taaratanavanto kyara taiti nti varivaqena nte mpo vitena mpo mwia kyaaninrave. ");
INSERT INTO omw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nkye nkyi nronravanto tumuani entara hia ntapihiahuara tita, nkye taqe variqata variate. ");
INSERT INTO omw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Qio mwaa quara rieqata variate. Nraamwu qova variqaro mpuara vaisivanto nrianinra ntapihi kyero nai nraamwuqaa ntaqikyi varitiri, hiama mpuara vaisivanto nraamwuqi viqetero mpuara varaitiri. ");
INSERT INTO omw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mwi quara rieqatama nkyevata terama teta variqi viqatama ni pekya variate. Nte mwatani mwatatai nraaqiaravama varuqo. Nkye nianra hia tumuananrove ti entara, mwi entaraqaama nte tumu ntaaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Iesusiva mwitaa timwa kyero tiqaro, Kyaiqa vaisi kyuqeva nai nronra vaisiara rieqaro kyuqema kyero kyaiqa vare variari vaisiva, mwiva nataa hiarivave variananrove? Mwiva kyaiqa vaisi mwataa hiarivama variananrove. Mwia nronra vaisivanto nyianrani virera hiro mwi vaisira nronraqama kyero tiqaro, Ena kyaiqa vaisi hini mwihuaqaavata ntaqikyiqara mwi entara mwi entara kyara tukyama kyera nyiante, timwa kyero ");
INSERT INTO omw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","quariva nrohiro uro ntantero nrumu taqairaro mwia kyaiqa vaisivanto mwiva tintema kyero kyaiqa vare varirera, nrumu taqero mwia kyuqema mwatairaro mwiva qamwataananrove. ");
INSERT INTO omw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mwiva kyuqema mwatero mwi vaisirara tiqaro, Nte qaiqaa i nronraqama kyaarira e nte vataani inraikyaraqaa ekyaama ntaqikyinanrave, qiananrove, tuqo. ");
INSERT INTO omw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kyaiqa vaisi mwiva qaqira kyero hia mwitaa hiraitiro, uaqiama kyero kyaiqa vareqaro nai riemwa kyero tiqaro, Qaqao, ni nronravanto qakyoma kyeroma uro ntantero nriananrove, timwa kyero ");
INSERT INTO omw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mwiaqaatairo nai hena kyaiqa vaisi mwihua ntuqutu kyero uro mpoqama kyeta uera nramanri nre variahua kyapata kyaravata nramanrivata nramwaqiro virera, ");
INSERT INTO omw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","mpo enta, mwia nronra vaisivanto mwi entaraqaa hiama nriananrove qiani entaraqaa, nrihanrama mwatero mwia nronra vaisivanto uro ntantero nrumu mwia kyaiqa taqero ");
INSERT INTO omw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","nai kyaiqa vaisi mwia ntuqutu kyero vatero mwia titero tiqaro, Unraqama kyeqata kyuqe kyaiqa vare vaisihua uaqia hi mwatara varenani evata quante, tiraro ntateqata vai kutinani mwiva quananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesusiva tiqaro, Ekyaara entavanto nri ntairaro Kotiva nraakye qoraqaa ntaqikyiariva vahirero mwataamama vahiananrove. Mwanraata kyauqurutanavanto nkyiari nraata vaati varovau viqata qaraakya nraakye varo vaisira uro entaqi vita vareta mwiavata kyara nranrenrata uti variqata mwihua nkyiari ramuvata vareta mwi vaisira vitarerata vurave. ");
INSERT INTO omw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mwi mwanraatahuaqitaita kyauquruvanto hia kyuqe su nyaato vauhua vuvata hini kyauquruvanto kyuqe su nyaato vauhua vurave. ");
INSERT INTO omw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Hia kyuqe su nyaato vauhua kuaiqia kuaiqiavanto nkyiari ramu nraahu vareta hia qia ito vahamwenranra vararaitita, qati vurave. ");
INSERT INTO omw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Qati vuvata kyuqe su nyaato vauhua kuaiqia kuaiqiavanto nkyiari ramuvata vareta vahamwenra taquvata vareta vurave. ");
INSERT INTO omw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nraakye varo vaisira hunta kyarerata vuvaro mwi vaisiva hia vaakya nri ntovata mwinramwuhua vuruara huvata vaita vurave. ");
INSERT INTO omw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mwanraatanramwuvanto vaite varuvaro enta mwutukyaqi mpovanto aakyara ntero tiqaro, Nraakye varaari vaisiva nri variho. Nrivaqenramwu uro mwia hunta kyaare, tuvata ");
INSERT INTO omw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","mwanraata kyauqurutanavanto sivita nkyiari ramu kuaiqia kuaiqia terama kye vateta varuvata ");
INSERT INTO omw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","hia kyuqe su nyaato vahunramwuhua kyuqe su nyaato vauhuara tiqata, Qikye, tiri ramu ekyaa qipa viho. Nkye vahamwenra mponramwu timwivaqe teta ramuqi rauru taare, tuvata ");
INSERT INTO omw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","mwihua qaqao tita, Nkyivata vahamwenra nyianranro hia qioqa hiankyorave. Nkye hianteta vahamwenra kyoqaa hianasaita uro kyoqaa hiate, tita. ");
INSERT INTO omw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mwitaa tuvata mwihua vahamwenra kyoqaa hirerata vuvaro nraakye varo vaisiva nri ntorave. Mwiva nri ntovata mwanraata kyauquruvanto vaakya teramato nramwuhua mwia vatama kyeta nraamwuqi vera nteta kyara nre varuvaro qesa tita tora. ");
INSERT INTO omw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Qesa tita tovata mwanraata mpo mwinramwuhua nraakiara nri nteta tiqata, Nronrao, nronrao, qesa qatua timwa taante, tuvaro ");
INSERT INTO omw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","nraakye varo vaisiva mwiva qaqao tiro, Nte hia nkyi taqauhuave. Hia qesa qatua nyataaninrave, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Iesusiva mwi quaraqaa ntumwa kyero timwa nyinro tiqaro, Nkye mwi quara rieqatama ekyaara entavanto nrianinra nkye hia ntapihiarara tita, nkyevata taqe variqata teramateta variate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Iesusiva mwitaa timwa kyero mpo quaqaa ntumwa kyero timwa nyinro tiqaro, Ekyaara enta nri ntairaro Kotiva nraakye qoraqaa ntaqikyiariva mwaa quara votima kyeroma vahiananrove. Vaisi nronra mpovanto nyianrani virera hiro nai kyaiqa vaisinramwu nyaanrama kyero ni munimaqaave, nte vatau inraikyaraqaave, ntaqikyi mataate timwa kyero vurave. ");
INSERT INTO omw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Virera hiro nai kyaiqa vaisi munima tukyama kye nyunrave. Mwiva nkyiari kyaiqa varora mwivau munima mwia tukyama kyero nyunrave. Mpora 5,000 kinaa mwinro, mpora 2,000 kinaa mwinro, mpora 1,000 kinaa mwunrave. Nyitero nyianrani vurave. ");
INSERT INTO omw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nyianrani vuvaro 5,000 kinaa varo vaisiva mwiva veva ntero vuva uro mwi munimanraqotairo kyuqema kyero kyaiqa varaqiro viro uro mpo 5,000 kinaavata varorave. ");
INSERT INTO omw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mwiva mwitaa huvaro 2,000 kinaa varo vaisivavata veva ntero vuva uro mwi munimanraqotairo kuaa qarama kyero kyaiqa vareqaro mpo 2,000 kinaavata varorave. ");
INSERT INTO omw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mwitaa huvaro 1,000 kinaa varo vaisiva veva ntero hia mwiaqotairo kyaiqa utiraitiro uro mwata quvu kyero mwi munimanra uqeta kyero mwataqi quntamwa tero qumina varurave. ");
INSERT INTO omw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mwitaa huvaro mwihua nronra vaisivanto mponani uro mpuahaama vari kyero uro ntantero nri ntero munima nyunra mwia ntapihirera hurave. ");
INSERT INTO omw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ntapihirera huvaro 5,000 kinaa varo vaisiva nri ntero mwi munimanra vatama k yero 5,000 kinaa mpovatama kyero mwinro tiqaro, Nronrao, E nianra 5,000 kinaaqaa ntaqikyi mataante qiaranama nte mwi munimanraqaa ntaqikyiqanama kyaiqa vara kyenama 5,000 mpoqiavata varauqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mwitaa tuvaro mwia nronra vaisivanto mwia timwa mwinro tiqaro, E nianra riemwaqira viqarama kyuqema kyera varaaro. E pata inraikyaqaa kyuqema kyera ntaqikyi mataananranra tina, nte i nronraqama kyaarira e nronra inraikyaqaa ntaqikyinanrave. Qio nrinra ni vatama kyera qamwateqara variante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mwitaa tuvaro 2,000 kinaa varo vaisivavata nri ntero tiqaro, E ni 2,000 kinaa mpira mwiaqaa ntaqikyiante qiarana nte mwiaqaa ntaqikyiqana kyaiqa utu kyena 2,000 kinaa mpovata varauqo, timwa kyero mwi munimanra mwuvaro ");
INSERT INTO omw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","mwia nronra vaisivanto tiqaro, E nianra riemwaqira viqarama kyuqema kyera varaaro. E pata inraikyaqaa kyuqema kyera ntaqikyi mataananranra tina, nte i nronraqama kyaarira e nronra inraikyaqaa ntaqikyinanrave. Qio nrinra ni vatama kyera qamwateqara variante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mwitaa tuvaro mwia kyaiqa vaisi 1,000 kinaa varova nri ntero tiqaro, Nronrao, nte ntapihi kyauqara e kyaiqara vuavi raavira ti variara vaisivave. E hia ena vara tutaana kyarara vanti variaravave. E hia kyara humwu isataananraqaataira uro kyara vare variaravave. ");
INSERT INTO omw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nte mwianra rienama i nraatu aatu hiqanama hia i munimaqo kyaiqa utiraitina, mwata quvu kyena mwiqi quvu ntamwa kyena inani uqeta mwataurave. Qio mwaa taqaante. Ena munima mwaa ena varaante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mwitaa tuvaro mwia nronra vaisivanto mwianra tiqaro, E kyaiqa vaisi uaqia hiaravama variaro. Qumina aanra nrohinanranra nraahu rieqara hia kyuqema kyera kyaiqa vare variaravama variaro. Qutaave nte mpohua vara tutaara vantina mpohua isataaraqaatairo qupiqaira vantuqo? ");
INSERT INTO omw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","E mpo mwitaa hiqara nanraqamave hia ni munima varaqira uro mpenki nraamwuqi mataaro? E mpenkiqi vatairaqena nte uro ntantena nrianriva mwi munimanra varena mpoqiavata mwiqitaina varaataarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mwitaa timwa kyero mporara tiqaro, Mwi vaisiraqitaira 1,000 kinaa mwia vara kyera 10,000 kinaa vatai vaisira mwiante. ");
INSERT INTO omw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kyuqema kyero airi inraikyaqaa ntaqikyi mate vari vaisira nte mpoqiavata mwianrinro mwiva mantaquma kyeroma varaananrove. Hia mpo inraikyaqaa ntaqikyi mate variani vaisiraqaataina nte mwiva nanra inraikyaqiave vataaninra ekyaama vara kyaaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mwia nronra vaisivanto mwitaa timwa kyero tiqaro, Qio uaqia hi kyaiqa vaisira mwia vitaqita uro mwaaqani kyaivaro kyokiraqi ntateqaro nkyiari aanrai kutiqata variraqi variarive, turave, tiro. Iesusiva mwi quaraqaa ntumwa kyero timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Iesusiva mwitaa timwa kyero tiqaro, Nte mwatani mwatatai nraaqiaravave. Nraakiara nte nronraqama vina vunyaa vaisivanto variqana nyaamwusaina tumuanrita nyaamwunyaahua ni vatama kyeta tumi varivaqe tumu ntena nronra vaisi taintaqa mwatakyaa vina varianinrave. ");
INSERT INTO omw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Variarita ekyaa mwata maata vahintema vari nraakye qorahua ni puqaa ntuvaantuama vivaqe nte mwihua ntainra kyena taaratanaqaa variate qianinrave. Sipisipi qova nai sipisipivata memenravata ntainra kyero ");
INSERT INTO omw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","sipisipi nai kyauqu kyaatutani sita vatero memenra sita nai kyauqu kyaantaaqani vataintema kyena, nte mwatani vari nraakye qorahua taaratanaqaa ntainra kyaaninrave. ");
INSERT INTO omw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nte mwitaama kyena taaratanaqaa ntainra kyena vatenama nte vunyaa vaisivanto variqana nte ni kyauqu kyaatutani varihuara tiqana, Nriate. Ni kova nkyi kyuqema nyataihua variavo. Haaru mwaa mwatara ututo entaraqaatairo Kotiva nkyiara rieqaro nkyita kyaama tero terama tai mwatukyaraqi nrita variate. Nkye ni kyuqema mataahuave. ");
INSERT INTO omw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ni kyara nraataa ihana varuqata nkye ni kyara mpiarave. Ni nramanri nraataa ihana varuqata nkye ni nramanri mpiarave. Nte mpo mwatanaa vaisivanto varuqata nkye nianra qamwateqata nkyeta nraamwuqi ni pitaqita uro kyaarave. ");
INSERT INTO omw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nte hia tuavaaqa vatauqata nkye ni tuavaaqa mpiarave. Nte nriqa vihana varuqata nkye kyuqema kyeta niqaa ntaqikyiarave. Nte karavuqi varuqata nkye nrumu ni taqaarave, qianinrave. ");
INSERT INTO omw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nte mwitaa qiarita ntapihi kyeta nrohi vari nraakye qorahua nianra mwitaama tivarave, Nronrao, taire tire i taqaurara kyara nraataa ihara variarata tire i kyara mwunanrave? Taire tire i taqaurara nramanri nraataa ihara variarata tire i nramanri mwunanrave? ");
INSERT INTO omw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Taire tire taqaurara e mpo mwatanaa hiarata tire i vitaqita teta nraamwuqi kyaunanrave? Taire tire taqauraro i tuavaaqa hia vaihara variarata tire i tuavaaqa mwunanrave? ");
INSERT INTO omw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Taire tire taqaurara i nriqa vihara variananrave? Taire tire i taqarera karavuqi vunanrave? tivarave. ");
INSERT INTO omw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mwihua mwitaa tivaqe nte vunyaa vaisivanto variqana mwihua nkyiari timwa nyina tiqana, Nte qianinra riaate. Nkye ni kata pakyaa hia nrutu vahianinra mpo kyaahaqa hiqatama nkye nivatama kyaahaqama mataarave, qianinrave. ");
INSERT INTO omw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nte mwitaa timwa kyena ntena kyauqu kyaantaaqani varihuara mwitaama qianinrave, Nkye nte varunasaita quate. Kotiva nkyiara uaqiama quate tiro, tirave. Kotiva Saataaninravata, Saataaninra tovevaana mwihuaravata, rieqaro qia nronra itaira terama kyero vataira nkye mwini quate. ");
INSERT INTO omw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ni kyara nraataa ihana varuqata nkye hia kyara mpiarave. Ni nramanri nraataa ihana varuqata nkye hia ni nramanri mpiarave. ");
INSERT INTO omw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nte mpo mwatanaa vaisivanto varuqata nkye hia nianra qamwateqata ni pitaqita nkyeta nraamwuqi kyaarave. Nte hia tuavaaqa vatauqata nkye hia ni tuavaaqa mpiarave. Nte nriqa vihanave, karavuqive, varuqata nkye hia nrumu ni taqaarave, qianinrave. ");
INSERT INTO omw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nte mwitaa qiarita mwihuavata tivarave, Nronrao, taireve tire taqaurara i nraataa ihara variaro? Taireve i nramanri nraataa ihara variaro? Taireve e mpo mwatanaa vaisivanto variaro? Taireve e tuavaaqa hia vaihara variaro? Taireve i nriqa vihara variaro? Taireve e karavuqi variaro? Taire e mwitaa mwitaama variarata tire hia i kyaahaqa hunanrave? tivarave. ");
INSERT INTO omw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mwihua mwitaa tivaqe nte qianinrave, Nte qianinra riaate. Nkye hia nrutu vahianinra mpo hia kyaahaqa hiqatama nkye nivatama hia kyaahaqama mataarave, qianinrave. ");
INSERT INTO omw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nte mwitaa qiarita mwia kyaara mwihua nkyiari kyoqaa vareta ekyaa enta atura ntiqata variqi vivata ntapihi kyeta nrohi vari nraakye qorahua nkyiari kyoqaa vareta ekyaa enta kyuqema kyeta qati variqita vivarave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesusiva mwi quara mwi quara timwa nyi taiqa kyero nai nraaqiaranramwuanra tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Nkye ntapihi kyaarave. Taara enta nritarairaro haaru nyaamwunyaava qati vekyahu nyatorara rieqata omwata nre entava nriananrove. Mwi entaraqaa ni ntavaaqavuqita uro kyaivata ni kyatariqaa rukyeta hiritevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Iesusiva mwi quara nai nraaqiaranramwu timwa nyitero varuvata Kotira kyaiqa vara mwate varuhua mwihua nronranramwuvata, Iutaa nronranramwuvantovata, mwihua Kaiapaasira nraamwuqi uqeta kyeta ntuvaantuama vita. Kaiapaasiva Kotira nraamwuqaa ntaqikyiqaro vunyaa vaisivanto varura ");
INSERT INTO omw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","mwia nraamwuqi ntuvaantuama vita Iesusira ntavaaqavuqita uro rukyerara uqetakye qua tita tiqata, ");
INSERT INTO omw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Omwata nraana entaraqaa mwia ntavaaqavu kyaarata nraakye qoravanto inronramaqita ntaqivorave, tura. ");
INSERT INTO omw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesusiva Mpetaanini Saimoninra nraamwuqi uro varura. Saimoniva tauraa varuvaro tauma rumpuaravanto mwamwanta nre varura. ");
INSERT INTO omw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iesusiva mwi vaisira nraamwuqi uro varuvaro nraakye mpovanto vera ntero Iesusira kyuqema mwatarero vahamwenra kyuqe mwunta vura nronra munima kyora ori taquqi varero uro Iesusiva taintaqaa kyara nre varuvaro mwia qiataqaa rauru mwatero. ");
INSERT INTO omw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mwia qiataqaa rauru mwatovata mwia nraaqiaranramwuvanto taqeta nraakye mwia inronra hita tiqata, Nanraqamave mwitaama kyero vahamwenra mwia qumina taiqa kyaiho? ");
INSERT INTO omw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Vahamwenra mwia nyita nronra munima vara kyeta vehi nraakye qora nyiataarave, tita. ");
INSERT INTO omw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mwihua mwitaa ti varuvaro Iesusiva mwihua qua riero tiqaro, Nkyenramwu nanraqamave nraakye mwia inronra hi variavo? Mwiva mwitaa hiqaroma ni kyuqema mate variho. ");
INSERT INTO omw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vehi nraakye qora mwihua ekyaa enta nkyivata variqita vivarave. Nte nraahuma hia ekyaa enta nkyivata variqina quaninrave. ");
INSERT INTO omw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nraakye mwaava vahamwenra qu mateqaroma ni quntamwa terara tera hi variho. ");
INSERT INTO omw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nte qutaa qianinra riaate. Nraakiara ni qua mwakyaakya nraakye qora timwa nyiqatama mate nraakye mwaava niqaa vahamwenra qu matairara rieqatama mpo mwatanaa mpo mwatanaahua timwa nyivata rievarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iesusiva mwitaa tuvaro Iesusira nraaqiara 12 nramwuqitairo mpovanto mwia nrutu Iutaasi Isikeriotiva veva ntero Kotira kyaiqa vara mwate varu vaisihua mwihua nronra vaisinramwu varunani vuva ");
INSERT INTO omw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","uro mwihua kyapara hiro tiqaro, Nte Iesusira qovarama kye nkyi kyauquqi nrumu kyaankyera, nkye nanra kyoqaave ni mpivarave? tuvata mwihua ori munima 30 nramwu kyaara ntumwa kyeta mwuvaro Iutaasiva mwi munimanra varero ");
INSERT INTO omw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","mwi entaraqaatairo mwihua kyauquqi Iesusira kyaani aanranra puaamaqiro vura. ");
INSERT INTO omw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hia kyoto mperetira omwata nre iherava nri ntovata vuni nrinto entaraqaa mwia nraaqiaranramwuvanto Iesusiva hunani nri nteta kyapara hita tiqata, Taraqive tire uro terama mwataarara e vekyahu nyato entarara rieqarama mwi kyarara nrenanrave? tita. ");
INSERT INTO omw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mwihua mwitaa tuvaro Iesusiva tiqaro, Nkye Ierusaremini uro vaisi mpora mwitaama qiate, Mwaanra qua tiri timwa timwi vari vaisiva tiqaro, Mwaa entava ninima qovarama viho. Nte ntena nraaqiara kyapata i nraamwuqi vekyahu nyato kyarara nranrenrave tiho, qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Iesusiva mwitaa tuvata mwia nraaqiaranramwuvanto Iesusiva tuntema kyeta mwi kyarara terama kyeta vatora. ");
INSERT INTO omw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Terama kyeta vatovaro enta huvaro Iesusiva nai nraaqiaranramwu kyapata uro kyara taintaqaa mwatakyaa variro kyara nre varura. ");
INSERT INTO omw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kyara nreqaro mwihua timwa nyinro tiqaro, Nte qianinra riaate. Nkyiqitairo mpovanto ni qovarama kyero nramwutaahua kyauquqi kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mwitaa tuvata mwia nraaqiaranramwu mwutukya uaqia huvata mwihua kuaiqia kuaiqiavanto Iesusira kyapara hita tiqata, Nronrao, e nianrave qiaro? Hia nte mwivave, hia nte mwivave, timwaqita vita. ");
INSERT INTO omw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mwitaa timwaqi vuvaro Iesusiva tiqaro, Mpereti vara kyeta tiretana kuaa vakya mwaati tanuqi ntaarava, mwi vaisivama ni qovarama kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ni mwatani mwatatai nraaqiarara mwitaama kye rukye quara haaru qara ntumwa torave. Qio mwi quava mwivauma vahiananrove. Ni mwatani mwatatai nraaqiarara qovarama kyaani vaisirara po timwa mwatauqo. Mwia nrova hia mwia mwata kyaataara mwia mwata torave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iesusiva mwitaa tuvaro Iutaasiva mwia qoqama kyaariva Iesusira kyapara hiro tiqaro, Mwaanra ti variarao, e nianrave qiaro? tuvaro Iesusiva tiqaro, Eo, nte iarama tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Iesusira nraaqiaranramwu kyara nre varuvaro Iesusiva mpereti vara kyero Kotirara kyuqeve timwa kyero nteqa kyero nai nraaqiaranramwu nyinro tiqaro, Mwaa vara kye nraate. Mwaa ni mamantama iho, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mwitaa timwa kyero mwiva uaini kaapu vara kyero Kotirara kyuqeve timwa kyero mwinramwuhua viti nyinro tiqaro, Nkye ekyaa mwihua mwaa nraate. ");
INSERT INTO omw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mwaa ni nraanrema iho. Kotiva nraakye qoravata qaraakya qua vataari quava mwi quava kepukyaqama quarive tiro, ni nraanrevanto mwia kepukyaqama kyaananrove. Ni ru kyaivaro ni nraanrevanto rauruariva airi nraakye qora kyaahaqa hiqaro mwihua uaqia hiani quara nruka nyataananrove. ");
INSERT INTO omw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nte qianinra riaate. Mwaa entaraqaataina nte hia uaini nranraitina qati variqi quarita, nkye ni kova ntaqikyianinraqi nivata uro varivaqe nte mwi entaraqaa nkyi kyapata qaraakya uaini nraaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iesusiva mwitaa timwa kyero nai nraaqiaranramwu kyapata Kotirara ihi timwa kyero veva ntero Oripi taaqiqaara vurama. ");
INSERT INTO omw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mwihua mwini vuvaro Iesusiva mwihua timwa nyinro tiqaro, Nkye mate entaqi ni kyetama aatu ntuqeqaa hita vivarave. Kotira mpukuqi qara ntumwa to quava mate mwivauma vahiananrove. Mwataama tiro: Sipisipiqaa ntaqikyiani vaisira Kotiva rukyairata sipisipi mwihua aatu ntuqeqaa hita nkyiariara nkyiariara api mpona mpona vivarave, turave. ");
INSERT INTO omw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Qio nraakiara ni vara qati sivuma kyairaqe variqana nkyi vuni nte nraante Karirini quaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Iesusiva mwitaa tuvaro Pitaava qaqao tiro, Ekyaa mwaahua i kyeta aatu vivaqe nte nraahu ivatama kyena varianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pitaava mwitaa tuvaro Iesusiva tiqaro, Nte qianinra riaante. Mate entaqi kokoraaravanto hia nruqua tirara e taarampo nani nianra tiqara, Hia nte mwi vaisira taqaurave tinanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Iesusiva mwitaa tuvaro Pitaava qaqao tiro, Nte hia iara hia mwia taqaurave qianinrave. Ivatama kye ni ru kyaivaqenavata hia nte mwitaa qianinrave, tiro. Pitaava mwitaa tuvata Iesusira nraaqiara hini mwinramwuhuavata mwi quara nraahu tura. ");
INSERT INTO omw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mwiaqaatairo Iesusiva nai nraaqiaranramwuvatama kyero kyaqamwa ututoraqi mwia nrutu Kesemani mwiqi uro ntero nai nraaqiaranramwuanra tiqaro, Nkye mwaini mwatakyaa vi varivaqe nte uro vururaqaa Kotirara aakyara ntaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Timwa kyero Pitaaravata, Sepetira mwaaqutanavata nraahu sita varero mwini vuvaro mwia hia kyakya huvaro mwia mwutukyavanto uaqia huvaro ");
INSERT INTO omw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","mwiva taarampo mwinramwuhuara tiqaro, Ni mutukyavanto mpoqama kyero ua iharo ni ru kyaaqara ihana varuqo. Nkyenramwu mwaaqaa nivatama kye variqata vu ntapairi kyeta taqeqatama variate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mwitaa timwa kyero Iesusiva hia mpuahaaqama viro uro virianasairo tumu ntiro Kotirara aakyara ntero tiqaro, Ko, e qiove tirera nte nriqa vi inraikyara nramanri votima kye nraaninra e qatinani vara kyaante. Qio hia ni kyakya hira vataqira quante. Ena kyakya hira vataqira quante, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Iesusiva mwitaa timwa kyero nrumu ntantero nai nraaqiara taaramponramwu kyonani tumu taqovata mwinramwuhua vuruara huvata vaite varuvaro mwiva Pitaarara tiqaro, Nanraqamave nkye nivatama kyeta pataqiaqa variqata hia vu ntapairi kyeta viti viri taqeqata variavo? ");
INSERT INTO omw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Saataaniva nkyi mwataara hiankyo tita nkye taqe variqata Kotirara aakyara nteqata variate. Nkyi mwanraquravanto mwitaa hiataa iharo nkyi mwamwantavanto nraahu hia qio kepukyaqa ihata variavo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iesusiva mwitaa timwa kyero qaiqaa uro Kotirara aakyara ntero tiqaro, Ko, nte mwaa nramanrinra nraaninra hia e qatinani vara kyaraitira qati nraante tirera, nte i kyakya hira vataqina virerave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mwitaa timwa kyero qaiqaa uro ntantero tumu taqovata mwia nraaqiara taaramponramwu vuruara huvata vaite varura. ");
INSERT INTO omw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Vaite varuvaro Iesusiva qaiqaa mwinramwuhua kyero vuva uro Kotirara taarampo nani aakyara nteqaro vaakya tuntema kyero nraahu qaiqaavata tura. ");
INSERT INTO omw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kotirara aakyara ntamwa kyero Iesusiva uro ntantero tumu taarampo mwinramwuhuara tiqaro, Qikye, nkyenramwu qati nraahuve ho hiqata vaite variavo? Qio taqaate. Ni mwatani mwatatai nraaqiarara ntavaaqavuqita uro uaqia hi kyaiqara uti varihua kyauquqi tuta kye iheravama nri ntaiho. ");
INSERT INTO omw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sivivaqenramwu quare. Ni qovarama kyero nramwutaa kyauquqi kyaari vaisivama mwaa nri variho, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesusiva mwi quara ti varuvaro mwia nraaqiara 12 nramwuqitairo Iutaasiva uro ntero. Iutaasiva uro ntovata mwia vatama kyeta airi vaisivanto paipavata kyanta kyaamwuvata tu vareta uro ntora. Kotira nraamwuqi Kotira kyaiqa vara mwate varu vaisihua mwihua vunyaahuavata, Iutaa nronra vaisinramwuvata, mwihua mwi vaisihua sitovata mwihua Iutaasira vatama kyeta nrunra. ");
INSERT INTO omw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Iutaasiva Iesusira qovarama kyaaninranra vaakya mwihua timwa nyinro tiqaro, Nte uro mwia qua mwanteqana mwia mota kyaani vaisira mwia mwivave. Nkye mwia uro ntavaaqavu kyaate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iutaasiva mwitaa timwa kyero mwiva mwihua kyapata uro ntero mwiva qamwanrama kyero Iesusira nraaqani uro ntero tiqaro, Mwaanra ti variarao, varirave, timwa kyero mwia mota kyero. ");
INSERT INTO omw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iutaasiva mwia mota kyovaro Iesusiva tiqaro, Ni vaisio, mpo inraikyara nrinanra qamwanrama kyera utuante, tuvata Iutaasira vatama kyeta nruhua uro Iesusira ntavaaqavu kyeta tuqara tutovaro ");
INSERT INTO omw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","mwiaqaatairo Iesusira nraaqiara mpovanto paipa nai tuaqitairo veva ntanrau kyero mwiaqotairo vaisi mpo nraato teqa kyora. Kotira nraamwuqi kyaiqa vare varu vaisihua mwihua vunyaa vaisi mwia kyaiqa vaisi nraato teqa kyora. ");
INSERT INTO omw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Teqa kyovaro Iesusiva qao tiro, Ena paipa veva nai tuaqi ntumwa taante. Paipaqotaita ntaquahua nkyiarivata paipaqotaita ru kyaarave. ");
INSERT INTO omw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","E hia ntapihiananrave iho? Ni kyaahaqa ihua ni kora kyapara hiariro mwiva qamwanrama kyero nyaamwusairo nyaamwunyaahua ntaqihua mwaanra 12 nramwu sitairata qioma tumivarave. ");
INSERT INTO omw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nte mwitaa qiarita mwihua tumivera, nataama kyerove haaru qara ntumwa to quava qutaa mwivau vahiananrove? tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iesusiva mwitaa timwa kyero mwiaqaatairo Iutaasira vatama kyeta nru vaisihuara tiqaro, Qikye, nkye kamaninra vatama kyero ntaqirero uti vari vaisira votima kyeta ni ntavaaqavirerata paipavata kyaamwuvata vare nriavo? Nte mpo enta mpo enta Kotira nraamwuqi variqana nraakye qora qua mwakyaakya timwa nyi varuqata nkye hia mwi entara ni ntavaaqavuarave. ");
INSERT INTO omw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Haaru poropeti vaisinramwuvanto mwaa inraikyava qovara hianinranra qara ntumwa to quava qutaa mwivau vahiarive tiro, mate mwaa inraikyava qovarama viho, tiro. Iesusiva mwitaa tuvata mwia nraaqiaranramwuvanto mwia qaqira kyeta aatu ntuqeqaa hita vurama. ");
INSERT INTO omw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Iesusira ntavaaqavu kyeta tutohua mwia vitaqita uro Kotira nraamwuqi kyaiqa vare varuhua mwihua vunyaa vaisivanto varuraqi Kaiapaasira nraamwuqi kyovata nraamwu mwiqi mwaanra okyara ti varu vaisihuavata, Iutaa vaisi nronranramwuvata, vaakya ntuvaantuama vita varura. ");
INSERT INTO omw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Iesusira vitaqita uro kyeta varuvaro Pitaava nyianrasata viqaro mwihua sataqiro vuva uro Kaiapaasira nraamwu vahuvaro mwatukyaqaa uro ntero tutukyaqaa mwaati ntero utaqi viro mwi inraikyava qovara hianinra taqarero nraamwu mwiaqaa ntaqikyi varu vaisihua vatama kyero varura. ");
INSERT INTO omw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pitaava mwaatani varuvata nraamwuqi Kotira nraamwuqaa ntaqikyi varuhuavata, ekyaa mwiqi ntuvaantuama vita varuhuavata, Iesusira rukyarerata Iesusiraqaa unra qua vatarerata mpo quara puaa huvaro ");
INSERT INTO omw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","hia vahuvata airi vaisivanto Iesusirara unra qua ntumwa kye tura. Api qua nraahu timwaqita vuvata vaisi taaratanavanto sivita ");
INSERT INTO omw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Iesusirara tiqata, Mwaa vaisiva mwitaa tihata tiretana riaunanrave. Mwiva tiqaro, Nte qioma Kotira nraamwu nronra ntapairi kyena taarampo enta variqana qaiqaa hoqa taiqa kyaaninrave tirave, tita. ");
INSERT INTO omw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mwitanahua mwitaa tuvaro Kotira kyaiqa vara mwate varuhua mwihua vunyaa vaisivanto siviro Iesusirara tiqaro, Mwitanahua mwitaa tiqata iqaa qua vate variavo. E mpo nkyiaritananra nanra quave tinanrave? tuvaro ");
INSERT INTO omw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Iesusiva hia qua tiraitiro, tirema varuvaro qaiqaa vunyaa vaisivanto Iesusirara tiqaro, Nte Kotira vuqaa variqana mwia nrutu nteqanama iara qutaa qua qiantema tuqo. Qutaave Kotiva i titaihara e tiri kyaahaqa hirera Mesaiaavanto variaro? Qutaave e Kotira mwaaquvanto variaro? Tiri timwa timwinraqe riaare, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mwiva mwitaa tuvaro Iesusiva tiqaro, E qiananra nte mwaa mwivave. Nte qianinra nkye riaate. Nkye nraakiara taqe varivaqe nte mwatani mwatatai nraaqiarava nronraqama vina Kotiva kepukyavanto varianinra mwia kyauqu kyaatutani mwatakyaa vina varina tonamwuqi tumuaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Iesusiva mwitaa tuvaro vunyaa vaisi mwiva nai tuavaaqa nrahitu kyero tiqaro, Qikye, mwiva Kotirara uaqia hi quara tiho. Vaisi mpovanto mwiaqaa qua vataaninra qumina nraanrevorave. Taqaate. Nkye rie variavaroma mwiva Kotirara uaqia hi quara tiho. ");
INSERT INTO omw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwia kyaara nkye Iesusirara nanra quave tivarave? Tivaqe riaankye, tiro. Mwitaa tuvata mwihua tiqata, Mwia uaqia hi kyaiqava nritaraiho. Mwia kyaara mwia ru kyaarava nraahuma vaiho, tita. ");
INSERT INTO omw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mwihua mwitaa timwa kyeta uro Iesusira viriqi taara vihi kyeta kyauquqo mwia ntuqutu kyeta mwia vu nraato ntumwa kyeta vateta ");
INSERT INTO omw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","vireraqama kyeta tiqata, Mesaiaao, e qutaa qua qovarama kyera vaisiva varirera, hia taqaraitira i ntuqutuani vaisira nrutu ntaante, tita. ");
INSERT INTO omw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nraamwuqi mwitaamaqita vi varuvaro Pitaava mwaatani mwatukyaqa mwatakyaa viro varuvaro kyaiqa nraakye mpovanto Pitaara nraaqani uro ntero mwianra tiqaro, Evata Iesusira Karirinyaa vaisi mwikyantiri variaravave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mwiva mwitaa tuvaro Pitaava mwihua suqaa variqaro qaqao tiro, E qiana quara nte hia ntapihurave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mwiva mwitaa timwa kyero uro nraihana varuvaro kyaiqa nraakye mpovanto mwia taqero mwini sivita varuhuara tiqaro, Vaisi mwaava Iesusira Nasaretinyaanra vatama kyero varivave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mwitaa tuvaro Pitaava kyauqu nriqiqaa vatero tiqaro, Hia nte mwi vaisira taqaurave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mwitaa timwa kyero pataqia varuvata mwini sivita varu vaisihua Pitaava hunani uro nteta mwianra tiqata, Iesusira nraaqiaranramwu mwi mwatanaahua variavara qutaaqama kyera evata kuaa mwatanaa mwivama variaro. Mwihua mpo qarama kyeqata mwaa quara ti variantema kyerama evata mwaa quara ti variaro. Qio e mwaa mwivave, tita. ");
INSERT INTO omw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mwihua mwitaa tuvaro Pitaava kyauqu nriqiqaa vatero tiqaro, Nte hia qutaa qua qiankyera, Kotiva qioma ni ruananrove. Nte qutaama tuqo. Nkye ti varia vaisira hia nte taqaurave, tiro. Pitaava mwitaa timwa kyovaro qamwanrama kyero kokoraaravanto nruqua tuvaro ");
INSERT INTO omw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Iesusiva Pitaara timwa mwu quava Pitaara nraatoqi ntumwa viro. Iesusiva Pitaarara tiqaro, Kokoraaravanto hia nruqua tirara e taarampo nani nianra hia mwia taqaurave tinanrave, tura. Pitaava mwi quara riero mwiva mwaaqani mwaati ntero vuvaro mwia mwutukyavanto uaqia huvaro nronraqama kyero ntatora. ");
INSERT INTO omw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mwia qanranraa toqa entaqi Kotira kyaiqa vara mwate varuhua mwihua nronra vaisinramwuvantovata, Iutaa nronra vaisinramwuvantovata, qua timwa kyeta Iesusira ru kyaananrave timwa kyeta ");
INSERT INTO omw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","mwiaqaataita mwihua Iesusira seniqotaita rupa kye vitaqita uro Pairaativa huraqi kyora. Pairaativa Romeni kirapava varura. ");
INSERT INTO omw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iutaasiva Iesusira qovarama kyo vaisiva taqovata mwihua ko timwa kyeta Iesusiraqaa qua vatetama mwia ru kyarerata uti varuvaro mwiva po hia nte mwitaa hiataara vaihana mwitaa hurave timwa kyero 30 munima mwunra varero uro ntantero Kotira kyaiqa vara mwate varu vaisihua mwihua nronranramwuvata, Iutaa vaisi nronranramwuvata, mwihua varuraqi uro ntero tiqaro, ");
INSERT INTO omw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nte qumina vaisi hia uaqia hi kyaiqara uti vaisirama uro nkyi kyauquqi tuta kyauqatama nkye mwia ru kyarerata uti variavo. Nte qora inraikya utu kyauqo, tiro. Timwa kyero munima mwia mwihua nyinrenro tuvata mwihua qaqao tita, Tire nataave hiananrave? Hia tiri kyaiqave. Mwi inraikyava ina kyaiqama vaiho, tita. ");
INSERT INTO omw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mwihua mwitaa tuvaro Iutaasiva munima mwia varaqiro uro Kotira nraamwu mpoqi hia qumina vaisivantovata vera nte varuraqi tuto kyero vuva uro vaanta hiri vura. ");
INSERT INTO omw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Iutaasiva munima mwia tuto kyero vuvata Kotira nraamwuqaa ntaqikyu vaisihua mwi munimanra utu kye vateta tiqata, Mwaa munimanra qutaru munimave. Tire mwaa munimanra Kotira nraamwuqi vataana munimanra vatama kyeta kuaaqi vataarorave. Mwitaa hiqata tire mwaanra qua nteqa kyaarorave. ");
INSERT INTO omw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tave utiqata aatapai mwata vare varia mwatava qatima vaiho. Nrivaqe mwaa munimanraqo mwi mwatara kyoqaama kyaare. Tire mwi mwatara kyoqaama kyeta vataararo mpo mwatanaavanto mwaini qutu vivaqe tire mwihua mwi mwataraqaa quntamwa taare, tita. Mwitaa timwa kyeta munima mwiaqotai ");
INSERT INTO omw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","mwi mwatara kyoqaama kyorara tita, mate mwaa entara nraakye qoravanto mwi mwatarara Qutaru Mwatave ti variara. ");
INSERT INTO omw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kotira nraamwuqaa ntaqikyi varuhua mwitaama kyeta mwi mwatara kyoqaa hurara tiro, haaru vetato entaqaa Ieremaiaava poropeti vaisivanto qara ntumwa to quava qutaa mwivau vahura. Ieremaiaava mwitaama tiro: Isareri vaisi mponramwuvanto qua timwa kyeta vateta 30 munima, mwianra qutaru munima vahiananrove ti vari munimanra, ");
INSERT INTO omw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mwi munimanra varaqita uro kyetama tave uti mwatara kyoqaa hivarave. Nronravanto ni qua timwa mpintema kyetama mwihua mwi mwatara varevarave, tura. ");
INSERT INTO omw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mwihua Iesusira vitaqita uro kirapava Pairaativa varuraqi kyovaro Iesusiva mwia vuqaa siviro varuvaro Pairaativa mwia ntumwahiamwa hiro tiqaro, Qutaave e Iutaa vunyaa vaisivanto variaro? tuvaro Iesusiva tiqaro, E qiananra nte mwaa mwivave, tiro. ");
INSERT INTO omw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Iesusiva mwitaa tuvata Kotira kyaiqa vara mwate varu vaisihua mwihua nronra vaisinramwuvata, Iutaa vaisi nronranramwuvata, mwihua mpo qua mpo qua kyaara Iesusira inronra hi varuvaro mwiva hia mwihua qua hiniqa hiraitiro, tirema varura. ");
INSERT INTO omw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tirema varuvaro Pairaativa qaiqaa Iesusira kyapara hiro tiqaro, Mwihua airi qua iqaa vateta mwia kyaara i inronra hi variavara e hiave mwihua ti varia quara riaaro? tuvaro ");
INSERT INTO omw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Iesusiva hia qua mpovata mwihuara tiraitiro, tirema kyero varuvaro mwiaqaatairo nronra vaisi Pairaativa mwianra airi nraato ti varura. ");
INSERT INTO omw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mpo ihi mpo ihi vekyahu nyato kyarara nro entaraqaa kirapava vunyaa vaisivanto nraakye qora qamwata nyatarero karavu vaisi mpo huvantu kyero titovaro mwaatani vura. Nraakye qoravanto ta vaisirave huvantu kyaante tura mwi vaisira huvantu kye varura. ");
INSERT INTO omw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mwi entara karavu vaisi mpo mwia nrutu Varavaasiva qora vaisivanto varuvatara tita, airi nraakye qoravanto mwi vaisira nrutu ntapihi kyora. Karavu vaisi mpo huvantu kyeta tite varu okyarava mwitaama vahuvata ");
INSERT INTO omw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","mwi entaraqaa nraakye qoravanto mwianra rieqata ntuvaantua hita varuvaro Pairaativa mwihua kyapara hiro tiqaro, Ta karavu vaisirave huvantu kyaariro quananrove? Nte Varavaasirave huvantu kyaaninrave? Iesusira mwianra tiqata Mesaiaavantove ti variara, nte mwiave huvantu kyaaninrave? tiro. ");
INSERT INTO omw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pairaativa ntapihi kyovata nronra vaisinramwuvanto Iesusiva nronraqama quankyorave tita mwianra raraqa tovata mwihua mwia vitaqita uro mwia kyauquqi kyora. ");
INSERT INTO omw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pairaativa ko nraamwuqi mwatakyaa viro varuvaro mwia nraatavanto qua vara kyero tiqaro, Po, mwi vaisiva hia mpo inraikya utu kyairaqaa qumina qua vaterorave. Mwia qati titairaro quarive. Nte entaqi mwiaqaa ruvaata taqauqaro ni uaqia ihana varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mwia nraatavanto mwitaa tuvata mwia qua riaankyorave timwa kyeta Kotira kyaiqa vare varu vaisihua mwihua nronra vaisinramwuvata, Iutaa mwihua nronra vaisinramwuvata, kepukyaqama kyeta qua nraakye qora timwa nyita tiqata, Varavaasira huvantu kyera timwinra Iesusira rukyaante qiate, tita. ");
INSERT INTO omw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mwitaama kyeta rapateqata tuvaro Pairaativa kyapara hiro tiqaro, Mwi vaisitanahuaqitaina ta vaisirave huvantu kyaaninrave? tiro. Mwitaa tuvata mwihua tiqata, Varavaasirave, tita. ");
INSERT INTO omw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mwihua mwitaa tuvaro Pairaativa qaqao, tiro, Iesusira mwianra Mesaiaavantove qiarave. Mwia mpo nte nataave hianinrave? tiro. Mwitaa tuvata ekyaa mwihua tiqata, Mwia kyairata kyatariqaa rutaate, tita. ");
INSERT INTO omw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mwihua mwitaa tuvaro Pairaativa mwihua kyapara hiro tiqaro, Nanra kyaarave nte mwia kyaarita kyatariqaa rutevarave? Nanra uaqia hi inraikyarave utu kyaiho? tiro. Mwitaa tuvata mwihua nronraqama kyeta aakyara nteta tiqata, Mwia kyairata kyatariqaa rutaate, tita. ");
INSERT INTO omw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nraakye qoravanto mwitaa ti varuvaro Pairaativa taqovaro mwia quavanto hia qio vahuvaro mwiva tiqaro, Nraakye qora utaqaatairo mpo inraikyavanto siquankyorave, timwa kyero nramanri tanuqi rauru kyero nraakye qora suqaa variqaro nai kyauqu hiqama kyero tiqaro, Qio taqaate. Mwia qutaru quavanto hiama niqaa vaiho. Mwi quava nkyitaqaama vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mwitaa tuvata ekyaa nraakye qoravanto tiqata, Mwia qiove, mwi quava titaqa vahiqaro tire mwatataarahuaqaavatama vahiananrove, tita. ");
INSERT INTO omw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mwihua mwitaa tuvaro Pairaativa mwihuara rieqaro Varavaasira huvantu kyero nai ntaqu vaisihua Iesusira kyaantaqo ntuqutuate tuvata mwia ntuqutu kyeta vatovaro mwiaqaatairo mwia kyatariqaa rutaate tiro, Pairaativa mwia nai ntaqu vaisihua kyauquqi tuta kyora. ");
INSERT INTO omw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pairaativa nai ntaqu vaisihua kyauquqi tuta kyovata mwihua mwia vitaqita uro kirapara nraamwuqi kyeta mwihua nkyiari hena ntaqu vaisihuavata ekyaa ntuvaantuama kyeta Iesusira vara utaqi vateta mwia vara ututu variqata ");
INSERT INTO omw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","mwia tuavaaqa qatinani vara kyeta mwia vireraqa hiqata vunyaa vaisi tuavaaqa utu mwatarera nraanre tuavaaqa utu mwatora. ");
INSERT INTO omw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mwiaqaataita mwihua tauvera vara kyeta qiata vaisi tovaqa voti hura ququrama kyeta Iesusira qiataqaa qu mwateta mwia kyauqu kyaatutani kyaamwu tu mwateta. Mwihua mwitaa mwitaama kyeta mwia vireraarora hirerata Iesusira vuqaa tori kyauru ravita tiqata, Iutaa nraakye qora vunyaa vaisio, varirave? timwa kyeta ");
INSERT INTO omw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","mwiaqaa taara vihi kyeta vateta kyaamwu mwia kyauquqi tu mwatora mwia vara kyeta mwiaqotaita mwia qiataqa ntuqutura. ");
INSERT INTO omw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mwitaamaqita vita vireraarora hita raima mwateta taiqa kyeta mwihua tuavaaqa utu mwatora vara kyeta nai tuavaaqa utu mwateta mwia kyatariqaa ru tarerata viteta vura. ");
INSERT INTO omw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ntaqu vaisihua Iesusira kyatariqaa rukyeta hiritarerata mwatukyaqitaita mwaaqanianra aanraqaa viqata vaisi mpovanto Sairininyaanra mwia nrutu Saimoninra qintorama kyeta mwianra kepukyaqama kyeta tiqata, E Iesusira rute kyatarira vara quqira uro mwiante, tura. ");
INSERT INTO omw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Timwa kyeta Iesusira vitaqita uro quminasata Korokotaave tunani kyora. Korokotaa mwaa quaraqitai tirera Qiata Mwukyaarisatave tunani Iesusira uro kyeta ");
INSERT INTO omw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","uaini mwiqi ukavu inraikyaravatama kyeta tuqasaa tora mwuvaro Iesusiva pataqia nreqaro taqero qaqira kyero hia nronra. ");
INSERT INTO omw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Iesusiva hia nrovata mwihua mwia kyatariqaa ninriqotaita ruteta mwia tuavaaqa vara kyeta kaati ruantema kyeta ori tuto kyeqata mwia tuavaaqa ntainra kyeta vareta ");
INSERT INTO omw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","mwiaqaataita mwihua mwatakyaa vita variqata mwia taqe varura. ");
INSERT INTO omw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mwia qiatani qua mpo ko timwa mwato quara qara ntumwa kyeta kyatariqaa rutovaro mwi quava mwitaama tiro: MWAA IESUSIVA IUTAA VUNYAA VAISIVE, tiro. Mwi qarava mwitaama kyero vahura. ");
INSERT INTO omw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mwihua Iesusira vatama kyeta vaisi mpotana ru tora. Mwitanahua nkyiari hena vaisi ru kyeqata mpuara vare varu vaisitanahua varuvata mpo Iesusira kyauqu kyaatutani ruteta mpo mwia kyauqu kyaantaaqani rutora. ");
INSERT INTO omw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mwitaama kyeta rutovata nraakye qora vitare nritare hiqata nru ntumwa kyeta mwaunru miqi mwateta Iesusirara uaqia hi quara timwa mwateta tiqata, ");
INSERT INTO omw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Qikye, e tiqarama, Kotira nraamwu ntapairi kyenama taarampo enta varina kyaiqa varaqi viqanama qaiqaa hoqa taiqa kyaaninrave qiananrave? Qio, e Kotira mwaaquvanto varirera, ena kyaahaqa hiante. Enavanto kyatariqaataira mpiami ntaante, tita. ");
INSERT INTO omw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mwihua mwitaa ti varuvata kuaa qarama kyeta Kotira kyaiqa vara mwate varuhua mwihua nronra vaisinramwuvata, mwaanra okyara ti varu vaisihuavata, mwianra raima mwateta tiqata, ");
INSERT INTO omw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Mwiva mpohua nraahu kyaahaqa hi variva hiave qio nai kyaahaqa hiananrove? Mwi vaisiva Isareri vunyaa vaisivanto variho. Kyai tire variqata taqaararo mwiva nai kyatariqaatairo mpiami ntero tuminraqeta tire mwianra qutaave qiare. ");
INSERT INTO omw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mwiva nanrianra tiqaro, Nte Kotirara kepukyaqama kyena riemwaqina vuvave. Nte Kotira mwaaquve tirave. Qio kyai variqata taqaararo Kotira kyakya hiraro mwia kyaahaqa hianinra taqaare, tita. ");
INSERT INTO omw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mwihua mwitaa tuvata mpuara vaisitana mwia tataaqa ru tohuavata mwihua tuntema kye kuaa qua mwia nraahu timwa mwatora. ");
INSERT INTO omw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mwitaa huvaro huarivanto nrinro virira qiataqaa vahuvaro ekyaa mwi mwata maatara entama vuvaro qaiqaa huari vitira tavaarana tuminro vahuvaro enta huva vivura. ");
INSERT INTO omw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Huarivanto tuminro vitito vahuvaro Iesusiva nai quaqitairo aakyara ntero tiqaro, Eri, eri rama sapakitani. Kotio, Kotio, nanraqamave ni qaqira kyera hiaro? tiro. ");
INSERT INTO omw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Iesusiva mwitaa tuvata mpo uhua mwini sivita varuhua mwia qua rieta tiqata, Mwiva Iraisaara tiri haivaqarama nraanre variho, tuvaro ");
INSERT INTO omw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","mpovanto hiantero nramanri kyaqo inraikyara tavuna nrihi voti hura vara kyero uaini uka vuraqi mwaati ntamwa kyero herika mpontaqiaqa huairi kyero mwia nraanrive tiro mwia nroqi viri ntamwa tora. ");
INSERT INTO omw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mwitaa huvata mpo uhua tiqata, Kyaiqe variqata taqaararo Iraisaava mwia kyaahaqa hirero tumuaninra taqaare, tita. ");
INSERT INTO omw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mwihua mwitaa tuvaro Iesusiva qaiqaa paa tiro aakyara ntamwa kyero qutu vura. ");
INSERT INTO omw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iesusiva qutu vuvaro Ierusaremini Kotira nraamwuqi tauha votima kyeta tavuna nronra hiritova virisairo utaqaa nrahituqiro mpiani tumunra. Mwitaa huvaro mwatura tuvaro ori nronra airivanto ntuvuraavurama vuvaro ");
INSERT INTO omw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","vaisi haaru quntamwa to mwatava qatua vuvata mwiqinaahua Kotira nraakye qoravanto qutu vuhua airivanto sivita varuhua ");
INSERT INTO omw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Iesusira qaiqaa qati vara sivuma kyo entaraqaataita mwihua Ierusaremini qovarama vuvata airi nraakye qoravanto mwihua taqora. ");
INSERT INTO omw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ntaqu vaisihua vunyaa vaisivantovata, mwiavata nrumu ntaqu vaisihua mponramwuvata, varuvaro Iesusira kyatariqaa hiritovaro varuvata mwihua Iesusiraqaa ntaqikyi variqata mwatura turave, mpo inraikya mpo inraikya qovarahura taqeta, mwiaqaataita mwihua nronraqama kyeta aatu hita tiqata, Qikye, qutaa mwaava Kotira mwaaquvanto varivama qutu viho, tura. ");
INSERT INTO omw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Iesusiva qutu vuvata nraakye mponramwuvanto nyianrasatatai variqata vutu taqe varura. Mwi nraakyehua Karirisaita Iesusira vataqi viqata mwia kyaiqa vara mwate varuhua varura. ");
INSERT INTO omw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mwihuaqitai mponramwu nyutu vahirero, Mariaava Makataranyaava mpo, Mariaava Iemisikya Ionikya nyova mpo, Sepetira mwaaqutana nyova mpo varura. ");
INSERT INTO omw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Enta huvaro Arimatianyaava airi inraikya vato vaisiva uro ntora. Mwia nrutu Iosepiva, mwiva Iesusira vataqiro vi varu vaisiva varura. ");
INSERT INTO omw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mwi vaisiva Pairaativa varuraqi uro ntero Iesusira mwamwanta mpiraqe varaqina quntamwa taankye tuvaro Pairaativa nai ntaqu vaisihua sitero tiqaro, Uro Iesusira mwamwanta vara mwia mwiate, tuvaro ");
INSERT INTO omw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iosepiva uro Iesusira mwamwanta kyatariqaatairo itu kyero qaraakya tavuna eqarori tavuna vara kyero mwia qapuqama kyero ");
INSERT INTO omw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","varaqiro uto nai nraakiara quntamwa terara rieqaro ori haqa kyero vatoraqi vera vatero ori nronra mpo ventaqiro mwia nrona tita tero vura. ");
INSERT INTO omw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariaava Makataranyaavavata, mwia qamwava mpo Mariaavavata, mwitanahua vutura hini mwatakyaa vita variqata vutu mwia quntora taqe varura. ");
INSERT INTO omw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mwia qanranraa Saarareqa Kotira nraamwuqaa ntaqikyuhuavata Parisi vaisinramwuvata uro Pairaatira vatama kyeta ntuvaantuama vita variqata ");
INSERT INTO omw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","mwianra tiqata, Nronrao, tire riauraro unra ti vari vaisiva mwiva nai qati varu entara tiqaro, Nte taarampo enta vari kyena qaiqaa qati siquaninrave turave. Mwiva mwitaa turara tira, ");
INSERT INTO omw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","e ntaqua vaisihua sitairata mwihua mwia quntamwa taaraqaa taarampo enta variqata ntaqikyiqita quate. Mwia nraaqiaranramwuvanto uro mwia mwamwanta mwiqitaita mpuara varaqita mpona kyeta nraakye qorara unra tiqata, Mwiva qati siviho, tivorave. Mwihua mwi entara unra tiva vaakya unra qua timwa tairavata nraatara kyaananrove, tita. ");
INSERT INTO omw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mwihua mwitaa tuvaro Pairaativa timwa nyinro tiqaro, Qio nkye ntaqua vaisihua sitaqita uro kyaivata mwihua mwia quntamwa taaraqaa kyuqema kyeta ntaqikyiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mwiva mwitaa tuvata mwihua uro tita tora ori mwiaqaa mwukya rateta ntaqu vaisihuara tiqata, Mwaini variqatama kyuqema kyetama ntaqikyiqi quate, turama. ");
INSERT INTO omw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Saarare Iutaa mwaanra entavanto taiqovaro mwia qanranraa ntuvaahama vuvata Saanteqaa Mariaava Makataranyaavavata, mwia qamwava Mariaavavata, Iesusira quntamwa toraqi taqarerata vurama. ");
INSERT INTO omw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Vuvaro qamwanrama kyero mwaturavanto nronraqama kyero tuvaro nyaamwunyaava mpovanto nyaamwusairo tumu oriqo qesa tita tora mwia rataa qatinani kyero ori mwiaqaa mwatakyaa viro varura. ");
INSERT INTO omw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mwia virivanto vahirero aaquakyaa votima kyero vahuvaro mwia tuavaaqavanto vahirero tonamwu turomunra voti huva varuvata ");
INSERT INTO omw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","mwiaqaa ntaqikyi varu vaisihua mwia taqeta nronraqama kyeta aatu hi varita kyuqu kyauqu ntuvata tumu ntita qutu quahua nraantantamwa kyeta varura. ");
INSERT INTO omw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mwihua mwitaama vita varuvaro nyaamwunyaava nraakye mwitanahuara tiqaro, Hia aatu hiate. Nte ntapihi kyauqata nkyetana Iesusira kyatariqaa rutaa vaisira puaa hirerata nriavo. ");
INSERT INTO omw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mwiva hia mwaini variho. Mwiva nai nkyi timwa nyintema kyero qatima siviho. Nrita mwia veta vataaraqi taqaate. ");
INSERT INTO omw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mwiqi taqetama hianteta uro mwia nraaqiaranramwu timwa nyiate. Mwiva qutu viraqitairo siviro mwiva nraantema nkyi suni Karirini vi variho. Nkyenramwu mwini uro variqata mwia taqevarave. Qio nte mwi quarama nkyi timwa nyuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mwiva mwitaa tuvata nraakye mwitanahua mwia quntamwa to mwatara mwia mwini kyetatana hianteta vuvaro hini mwamwantavanto aatu hi varuvata hini mwamwantavanto qamwate varuvata hianteta Iesusira nraaqiaranramwu timwa nyinrenrata vurama. ");
INSERT INTO omw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mwitanahua hianteta vi varuvaro qamwanrama kyero Iesusiva mwitanahua qintorama kyero tiqaro, Varitatanave, tuvata mwitanahua qamwata kyeta uro tumu ntita variqata mwia kyuqu tu vareta mwianra qamwata kyeta mwia nrutu tuaahere varuvaro ");
INSERT INTO omw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Iesusiva mwitanahuara tiqaro, Hia aatu hiate. Uro ni kata pakyaanramwu timwa nyivata mwihua Karirini vihua mwini uro ni taqaate, tiro. ");
INSERT INTO omw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Iesusiva mwitaa tuvata nraakye mwitanahua mwiva tunte hita aanraqaa qati vi varuvata Iesusira quntamwa toraqaa ntaqikyi varuhua ntaqu vaisihua mponramwuvanto Ierusaremini uro nteta ekyaa mwi inraikyava qovara hurara Kotira kyaiqa vara mwate varuhua mwihua nronra vaisinramwu timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Timwa nyuvata mwiaqaataita nronra vaisi mwihua uro mponramwuvata sita kyeta qua timwa kyeta kuaa qua vateta ntaqu vaisihua munima nronraqama kyeta nyita ");
INSERT INTO omw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tiqata, Nkyenramwu mwitaama qiate. Tire entaqi vaite varurata mwia nraaqiara nramwuvanto nrumu mwia mwamwanta mpuara vara kyaavo, qiate. ");
INSERT INTO omw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pairaativa mwi quara riairera, tire uro mwia qua timwa mwianrata nkye hia qua varevarave, tita. ");
INSERT INTO omw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mwihua mwitaa tuvata ntaqu vaisihua mwihuaqitaita munima vareta mwihua tuntema kyeta mwi quara nraahu nraakye qora timwa nyiqi vita mate mwaa entaravata Iutaavanto Iesusirara mwi quara nraahu viti viri timwa nyiqita vi variara. ");
INSERT INTO omw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Iesusira nraaqiara 11 nramwuvanto Karirini taaqi mwiaqaa uro variate tunani vuhua ");
INSERT INTO omw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","uro nteta taqovaro Iesusiva varuvata mwia qamwata mwateta mwia nrutu tuaahere varura. Mwia nrutu tuaahere varuvata mwia nraaqiara hinivanto mwianra taara nraato tita tiqata, Qutaa mwivave variho? ti varura. ");
INSERT INTO omw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesusiva mwihua nraaqani uro ntero tiqaro, Kotiva ni nronraqama kyaihana nte nyaamwunivata mwatanivata vahi inraikyara ekyaa mwi inraikyaraqaa ntaqikyi varuvave. ");
INSERT INTO omw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nkye ekyaa mwata maata varihua uro timwa nyivata mwihua ni nraaqiaraqama quate. Mwihua ni nraaqiaraqama vivata nkye nramanri nyiqata ni kora nrutu nteqata, ni mwia mwaaqu nrutu nteqata, Kotira mwanraqura nrutu nteqatama, nramanri nyiate. ");
INSERT INTO omw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mwitaa hiqatama ekyaa nkyi timwa nyu qua mwakyaakyara mwihuavata timwa nyitama mwi quara riemwaqita quate, qiate. Qio riaate. Nte nkyivata variqina quariro mwaa mwatava taiqaananrove, tiro. Iesusiva mwi quara turama. ");
INSERT INTO omw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iesusiva Kotira mwaaquvanto varura. Mwia qua kyuqe qua mwia okyara vahirero mwataamama vahiro. ");
INSERT INTO omw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Haaru mpo enta Aisaiaava Kotira qua qovarama kyero qara ntumwa tero tiqaro, Taqaante, ni qua nraakye qora timwa nyiani vaisira nte titaariro mwiva i vuni viqaro i aanra terama mwataananrove. ");
INSERT INTO omw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mwi vaisiva qumina mwataqaa variqaro aakyara ntero tiqaro, Nronravanto quani aanranra terama mwateta mwia aanra avuqavuma mwataivaro mwiva mwi aanranraqaama qio quarive qiananrove, tura. ");
INSERT INTO omw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kotiva mwia kyaahaqa huvaro Aisaiaava tohare varu entara mwi quara qara ntumwa tovaro airi ihi vi vuvaro mpo enta Ioniva qumina mwataqaa qovarama vura. Qumina mwataqaa qovarama viro Ioniva nraakye qora nramanri nyiqanro mwihua timwa nyinro tiqaro, Nkyeta qora kyaiqa vare varira qaqira kyeta nramanri varaivaro Kotiva nkye qora kyaiqa vare vari quara nruka nyataarive, tiro. ");
INSERT INTO omw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ioniva mwitaa ti varuvata Iutiasaitave, Ierusaremisaitave, ekyaa mwi mwatanaahua hisai hisai mwiva qua tunani vita uto variqata mwihua nkyiari qora kyaiqa vare varura timwa qovarama kyovaro Ioniva nramanri mwihua nyunra. ");
INSERT INTO omw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioninra tuavaaqa vahirero mpo quara kameri kyaahi vara kyero ututo tuavaaqava vahuvaro mwiva mwia nraahu ututero reti tavaarana rupatero varura. Ioniva hia kyara vara tu kyero nranraitiro, mwiva kainyaaqa nrenro voravanto kuruto nramanrinra nreqanro mwi kyarara nraahu nre varura. ");
INSERT INTO omw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ioniva nraakye qora timwa nyinro tiqaro, Ni naakiara nrianri vaisiva kepukyavanto ni naatara kyero nronra vaisivantoma variananrove. Mwiva nronra vaisivanto varihana nte qumina vaisi variqananra tina, hia nte qio kakataama vina nai kyuqu nraamwuma tai kyaantara huvantu mwataaninrave. ");
INSERT INTO omw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nte qati nramanri nkyi nyi varuqo. Mwiva Kotira mwanraqura nkyi nyiananrove, tiro. Ioniva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mwi entara Iesusiva Nasareti mwatukya Karirisairo nri ntero Ioniva varunani utontero vuvaro Ioniva Iotaani nramanriqi variqaro Iesusira nramanri mwunra. ");
INSERT INTO omw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nramanri mwia mwuvaro Iesusiva nramanriqitairo qatinani mwaanri ntero taqovaro nyaamwuvanto qatua vuvaro mwiqitairo Kotira mwanraquravanto nyaamwa minrunra voti huva tumu ntero Iesusiraqaa varura. ");
INSERT INTO omw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tumu Iesusiraqaa varuvaro quavanto nyaamwusairo mwitaama tiro: E ni maaquvanto variararo ni mutukyavanto iara mpoqiavata vaiho. Nte iara qamwateqanama varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Quavanto nyaamwusairo mwitaa tuvaro qamwanrama kyero Kotira mwanraquravanto Iesusira vita varero qumina mwataqaa hia vaisivata varu mwataraqaa uro kyovaro varura. ");
INSERT INTO omw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mwini uro kyovaro Iesusiva 40 entara variqiro vuvaro Saataaniva Iesusirara qora kyaiqa varaarive tiro, mwia mwataara hiqaro taqovaro Iesusiva hia mwia qua riaraitiro, hia qora kyaiqa utura. Iesusiva mwitaamaqiro viqaro qaakyau vahikurivanto nrohi varunani varuvata nyaamwunyaa vaisinramwu tumu mwiaqaa kyuqema kyeta ntaqikyi varura. ");
INSERT INTO omw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mwi entara mpo uhua Ioninra ntavaaqavu kyeta viteta karavuqi uro kyovaro Iesusiva Karirini uro variqaro Kotira mwakyaakya kyuqe mwakyaakya nraakye qora timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mwi entava nri ntaiho. Kotiva nkyiqa ntaqikyiari entava qaumaqa iho. Nkye qora kyaiqa uti varira qaqira kyeta nte kyuqe mwakyaakya timwa nyianinra nkye mwi quarara qutaave timwa kyeta riemwaqi quate, tura. ");
INSERT INTO omw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesusiva mwitaa timwa kyero vuva Kariri rumpua tokya sataa viqaro taqovaro Saimoniva nai qata Enturukyantiri variqaro vahe nte varura. Mwitanahua tavukya kyaiqa vare varutanahua vahe nte varuvaro ");
INSERT INTO omw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesusiva mwitanahuara tiqaro, Nkyetana ni naakiara nriate. Nkyetana vahe ntamwa kyeqata tavukya varaantema kyeta ni naakiara nriqata nraakye qora sitevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Iesusiva mwitaa tuvata mwitanahua mate mwiqiara nkyiari vahe mwini kyeta Iesusira vatavare vurama. ");
INSERT INTO omw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mwitanahua mwia vatama kyeta vuvaro Iesusiva pataqiaqa viqaro taqovata Sepetira mwaaqutana Iemisivavata, mwia qata Ionivavata, mpotuqi variqata vahe ntuke hi vura haqire varura. ");
INSERT INTO omw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mwitanahua vahe haqire varuvaro qamwanrama kyero Iesusiva mwitanahua nraanrovata mwitanahua rieta nkyiari sora Sepetiravata, mwia kyaiqa varo vaisihuavata, mpotuqi kyeta Iesusira vatama kyeta vurama. ");
INSERT INTO omw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mwitanahua Iesusira vatama kyeta vuvaro Iesusiva vuva Kapenaamini uro variqaro mwaanra tu entaraqaa mwaanra nraamwuqi vera ntero variqaro mwiqi varuhua mwakyaakya timwa nyinro. ");
INSERT INTO omw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iesusiva nraakye qora timwa nyi varuvata mwihua mwia qua rieta tiqata, Qikye, mwiva nanra quave tiri timwa timwiho? Mwiva hia mwaanra okyara ti varia vaisinramwuhua qiantema kyero ti variho. Mwiva nronra vaisivanto qiantema kyero ti variho, tura. ");
INSERT INTO omw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mwitaa tuvaro Iesusiva mwaanra nraamwu mwiqi varuvaro vaanavanto mwia utaqi varu vaisiva nraamwuqi vera ntero qua aakyara ntero tiqaro, ");
INSERT INTO omw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Iesusio, e Nasaretinyaavave. E tiri nataa hirerarave nrianro? E tiri ntuqutu taiqa kyarerarave nrianro? Nte i okyara ntapihi kyauva e nrianro. Kotiva i titaihara e Kotira kyaiqa nraahu vare variarava variaro, tiro. ");
INSERT INTO omw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mwitaa tuvaro Iesusiva vaana mwia inronra hiro tiqaro, Tirema variante. Mwi vaisiraqitaira nritarera quante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Iesusiva mwitaa tuvaro vaana mwiva mpoqama kyero mwi vaisira tu varero qakyaa qakyaama kyero qua aakyara timwa mwatero qatinani nritarero viro. ");
INSERT INTO omw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Vaanavanto nritarero vuvata mwiqi ntuvaantuama vita varuhua kyauqu ntukikinraaqata kyeqata nai timwa mwi nai timwa mwi hita tiqata, Nanra inraikyavantove qovarama viho? Mwaa quara qaraakya quave. Mwi vaisiva kepukya qua tihatama vaanavantovata mwia qua riaavo, tura. ");
INSERT INTO omw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mwihua mwitaa timwaqi vita nrita huvata ekyaa Karirini varuhuavata mwi quara riora. ");
INSERT INTO omw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iesusiva mwaanra nraamwuqitairo veva ntero Iemisikya Ionikya sita varero vuva uro Saimonikya Enturukya nraamwuqi vera ntero varura. ");
INSERT INTO omw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimoninra nrinraatarara mwamwanta tutoqa huvaro taintaqaa vaite varuvata mwihua mwianra Iesusira timwa mwita. ");
INSERT INTO omw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Timwa mwuvaro Iesusiva mwia uro taqero mwia kyauquqa tu varero mwia mwaamwianrama kyero. Mwitaama kyovaro mwia mwamwantavanto kyuqema viro naitarama vahuvaro mwi nraakyeva siviro kyara uta nyinrenro tera hura. ");
INSERT INTO omw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Iesusiva mwi mwatukyaraqi varuvaro huarivanto vikyovaro entama vuvata nraakye qora nriqa vuhuavata, vaanavanto utaqi varuhuavata, sita vareta Iesusiva varunani uro kyora. ");
INSERT INTO omw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mwitaa huvata ekyaa mwi mwatukyaraqinaahuavata Iesusiva varu nraamwunra qesa mwina nrumu varita huvai kyora. ");
INSERT INTO omw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Huvai kyeta varuvaro Iesusiva nraakye qora airintikara mpo qara mpo qarama kyero nriqa vuhua kyuqema nyatovaro mwihua nriqa vuva taiqa vuvata qio varura. Qio varuvaro vaanavantovata airi vaisiqi varuhua sitamwa kyovata nritareta vura. Nritareqata vi varuvaro Iesusiva vaana mwihuara qao tiro tiqaro, Hiavata qua qiate, tiro. Vaanavanto Iesusira ntapihi kyovarora tiro, Iesusiva mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mwia qanranraa hia qaatatovaro Iesusiva siviro veva ntero uro hia vaisivantovata varunani Kotiravata qua tirero vura. ");
INSERT INTO omw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mwini vuvaro Saimoniva nai henahuavatama kyero mwia puaa hirero viro. ");
INSERT INTO omw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Vuhua uro Iesusira puaama kyeta mwinramwuhua mwianra tiqata, Qutaara e mwaini variarata ekyaa mwaa mwatukyaraqinaahua iara puaa hi variavo, tita. ");
INSERT INTO omw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mwinramwuhua mwitaa tuvaro Iesusiva qaqao tiro, Varaivaqenramwu mpo mwatukya mpo mwatukyavata nrohiqata qua mwakyaakya nraakye qora timwa nyianre. Nte mwakyaakya mwihua timwa nyinrenra nruvave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mwitaa timwa kyero mwinramwuhuavata sita varero Karirini nrohi variqaro mwaanra nraamwu mpoqi mpoqi vera ntero variqaro mwakyaakya nraakye qora timwa nyiqiro viqaro vaisi utaqitairo vaanavata sitamwa kyovata nritare vurama. ");
INSERT INTO omw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Iesusiva mwakyaakya timwa nyiqiro vi varuvaro vaisi mpovanto tauma rumpuara utu vaisiva Iesusiva varunani uro ntero tori kyauru raviro Iesusirara po kye tiqaro, E ni kyaahaqa hiataa hirera, e qioma ni tauma rumpuara nruka matenanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mwitaa tuvaro Iesusiva mwi vaisirara po kye timwa mwatero, nai kyauqu mpiami mwia mwamwantaqa vatero tiqaro, Nte mwitaa hiataa ihana i mwitaama mwatarerave. I mwamwantara kyuqema quarive tuqo, tuvaro ");
INSERT INTO omw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","mwia tauma rumpuaravanto qamwanrama tavanta vuvaro mwiva qio varura. ");
INSERT INTO omw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mwiva qio varuvaro Iesusiva mwi vaisirara kepukyaqama kyero tiqaro, ");
INSERT INTO omw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Hia mpohuavata timwa nyinraitira, viraro Kotira kyaiqa vara mwate vari vaisiva i mwamwanta taqaarive. Mwiaqaataira e Mosesiva mwaanra qua timwa tora rieqarama Kotira mpo inraikya mwinrata nraakye qoravanto iara tiqata, Qutaama mwia mwamwanta kyuqema viho qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Iesusiva mwitaa tuvaro mwi vaisiva hia Iesusiva tunte hiraitiro, mwi quara viti timwa nyi viri timwa nyi huvata ekyaa vaisi riovaro mwia kyaara Iesusiva mpo mwatukya mpo mwatukya qoqaa quariva hia vahuvaro mwiva qaqira kyero hia mwatukyani viraitiro, qumina sata variqiro vuvata nraakye qora hisai hisaita mwia taqarerata nrunrama. ");
INSERT INTO omw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Iesusiva Karirini nrohi ntero nrumu ntantero Kapenaamini uro varuvata mwi mwatanaahua Iesusiva nrumu variho tu quara rieta ");
INSERT INTO omw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","mwihua airivanto uro Iesusiva varu nraamwunraqi ntuvaantuama vita nraamwu mwiavata ru piqa kyeta qesanavata huvaiqu kyovaro mpovanto mwiqi vera ntaariva hia qioqa hura. Mwitaa huvaro Iesusiva nraamwu mwiqi variqaro mwakyaakya timwa nyi varura. ");
INSERT INTO omw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Iesusiva timwa nyi varuvata vaisi mponramwuvanto nkyiari hena vaisi mpo mwia mwamwanta hini qutu vura taintama vare nrunra. Erahiamuaantema vaisinramwu mwia taintama vareta nrunra. ");
INSERT INTO omw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mwinramwuhua nri nteta Iesusira nraaqani quananrave tita, taqovata nraakye qora airivanto varuvata mwinramwuhua nraamwu utaqi vera nteva hia qioqa hura. Hia qioqa huvata mwinramwuhua qaqira kyeta nraamwu qiata tahiporaqaa mwaanri nteta mwi vaisira vara mwaanri vateta, Iesusiva nraamwu utaqi varuvata mwinramwuhua Iesusiva varura mwina mpiami ntukuraa kyeta. Qio ntukuraa kyeta nriqa vu vaisira taintaqaa vatora qakyomakye kyaqi vuvaro mwi taintava nraakye qora utaqaa uto vahura. ");
INSERT INTO omw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Vahuvaro Iesusiva riovata mwi vaisinramwuhua nkyiari nraahu tiqata, Qutaama mwaa vaisira Iesusiva qio kyuqema kyaananrove, tu vaisinramwuhua varuvaro Iesusiva hini mwamwanta qutu vu vaisirara tiqaro, Ni maaquo, e Kotira qua raaquta kyaananra nte mwi quara nrukama mwatauqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Iesusiva mwitaa tuvata mwaanra okyara ti varu vaisinramwuhua mwiqi varuhua riemwaqi vita tiqata, ");
INSERT INTO omw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Qaqao, mwi vaisiva nanraqamave mwitaa tiho? Mwiva mwitaa tiqaroma Kotira uaqiama mwate variho. Hiama qumina vaisivanto variqaro nai hena vaisiara, E Kotira qua raaquta kyaananra nruka mwatauqo, qiananrove. Kotiva mwiva nraahuma qio mwitaa qiananrove, tita. ");
INSERT INTO omw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mwihua mwitaama nraato riovaro Iesusivavata mwihua su nyaato tura ntapihi kyero tiqaro, Nkye nataamaqive mwitaama riaavo? ");
INSERT INTO omw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nte mwaa vaisira hini mwamwanta qutu virara tiqanama, E Kotira qua nteqa kyaananra nte nrukama mwatauqo, tuqatama nkye nianra tiqata, Qaqao, i quavanto unra quave. Hia qutaa qovara hiananrove, qiarave. Qio mwaini riaate. Nte mwi vaisirara tiqana, Sivira ena tainta tu varera quante, qiariro qiove ni quara mwiva mwitaa hiananrove? Nkye timwa mpivaqena riaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Iesusiva mwitaama kyero mwihua kyaparama nyatero mwiva mwihuara qaiqaa tiqaro, Nte mwatani mwatatai nraaqiarava varuqaro ni nronraqama kyaihananra tina, nte qioma mwatani variqana vaisivanto Kotira qua nteqa kyaani quara nruka kyaaninrave. Nkye ni quara qutaa quave qiate tina, nte mwate mwaa vaisirara mwitaa tirerave, tiro. Mwitaa timwa kyero Iesusiva hini mwamwanta qutu vu vaisirara tiqaro, ");
INSERT INTO omw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Sivira ena tainta tu varera ena mwaatani quantema tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mwitaa tuvata ekyaa nraakye qora mwia taqe varuvaro mwi vaisiva siviro mpiami nai tainta tu varero vuvata mwihua nrihanrama vita kyauqu ntukikinraaqate varita Kotira nrutu tuaahereta tiqata, Mwaa kyaiqara nraahumwa mpo qara hi kyaiqara hia taqauna kyaiqarave, tura. (Mwi entara taakisi vare varu vaisihua mponramwuvanto taakisi vareqata hini munima nkyiari tuteta hini munima nraahu nkyiari nronra vaisi nyunra. Mwitaa huvata qumina nraakye qoravanto taakisi varo vaisihua ekyaa mwihuara mpuara vaisi nraahuma variavo tura.) ");
INSERT INTO omw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesusiva Kapenaamini vari kyero mwiaqaatairo nrumu ntantero Kariri nramanri tokyasataa vuvata nraakye qora airivanto mwiva varunani ntuvaantuama vita varuvaro Iesusiva qua mwakyaakya mwihua timwa nyinro. ");
INSERT INTO omw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mwiaqaatairo mwiva vuva uro variqaro taqovaro Rivaiva, Arapiaasira mwaaquvanto, opisi nraamwuqi taakisi vare varuvaro Iesusiva mwianra tiqaro, Ni naakiara nriante, tiro. Mwitaa tuvaro Rivaiva siviro Iesusira vataqiro vurama. ");
INSERT INTO omw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Iesusiva Rivaira nraamwuqi uro variqaro nai nraaqiaranramwuvata kyara nre varuvata airi vaisi taakisi vare varuhuavata, vaisi mponramwu mwihuara uaqiahi kyaiqara uti variahuave tuhua mwihuavata, nraamwu mwiqi variqata kyara nre varura. ");
INSERT INTO omw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Iesusiva vaisi mwinramwuhua kyapata kyara nre varuvata Parisi vaisi mwaanra okyara ti varuhua taqovaro Iesusiva taakisi vare varuhuavata, uaqiahi kyaiqara uti variahuave tuhua mwihuavata, kyara nre varuvata mwihua Iesusira nraaqiaranramwu kyapara hita tiqata, Nanraqamave Iesusiva uaqia hia vaisihua kyapata kyara nre variho? tita. ");
INSERT INTO omw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Parisi vaisinramwuvanto mwitaa tuvaro Iesusiva mwihua qua riero tiqaro, Qati vari vaisiva hia totaava hinani vi varirave. Nriqa vi vaisiva nraahu totaava hinani vi varirave. Ta vaisihuave tiqata, Tire avuqavuma kyeta nrohi varurahuave qiahua, nte hia mwihua nyaanranrenrana tumuvave. Nte uaqia hia nraakye qorahua nyaanranrenrana tumuvave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mwi entara Ioninra nraaqiaranramwuvantovata, Parisi vaisinramwuvantovata, kyara auramate varuvata vaisi mponramwuvanto Iesusira kyapara hita tiqata, Ioninra nraaqiaranramwuvantovata, Parisi vaisinramwuvantovata, kyara auramate variavo. Qio nanraqamave i nraaqiaranramwuvanto hia kyara aurama taraitita, qati kyara nre variavo? tita. ");
INSERT INTO omw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mwihua mwitaa tuvaro Iesusiva tiqaro, Nraakye vararera qiari vaisiva nai vataahuavata qati varirera, qiove mpovanto mwia vataahuara kyara aurama taate qiananro? Qaqao, hiama qio mpovanto mwitaa qiananrove. Nraakye vararera qiari vaisiva qati varirata mwia vataahua hia kyara aurama taraitita, qatima kyara nrevarave. ");
INSERT INTO omw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mpo enta nri ntairata mwihuaqitai nraakye vararera qiani vaisira tu vareta qatinani vara kyaivata mwi entaraqaataita mwia vataahua ti atura ntiqata kyara aurama tevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mwitaa timwa kyero Iesusiva mpo quaqaa ntumwa kyero timwa nyinro tiqaro, Mpovanto tuavaaqa nrihi nrahitu quaninra haqira hirero hiama tavuna qaraakya toqa kyero mwiaqaa taaqautero haqiraananrove. Tavuna qaraakya mwia toqa kyaariro qiqu vahiraro tuavaaqa nrihi mwivavata nronraqama kyero nrahituankyo tiro, hia mwitaa hirave. ");
INSERT INTO omw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Qaiqaa tirerave. Uaini qaraakya tati kyero hia mpovanto memenra pahiqo ututaira haaruaa taqu vara kyero qaraakya uaini mwia mwiqi raurirave. Memenra pahi mwiva nraahaqama viraqa mwiva mwitaa hiraro uainivanto kepukya uaini utu viqaro memenra pahi nrahitu kyaananrove. Mwitaa hiraro uainivantovata memenra pahivantovata uaqiama quananrove. Memenra pahiqotai ututaa taqura qaraakya taqu vara kyeta mwiqi nraahu qaraakya uaini rauruarave, tiro. (Iesusiva mwi quaraqaa ntumwa kyero tu quara okyaravanto mwataamama vahiro. Mwia votima kyeta hiama haaruaa okyaravata qaraakya okyaravata kuaaqi kuairama kyeta tutaate, tura.) ");
INSERT INTO omw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mpo enta mwaanra tu entaraqaa Iesusiva nai nraaqiaranramwu kyapata aakyo utaqi kyakuma votihura uiti vara tutoraqi vi varuvata mwia nraaqiaranramwuvanto viqatama uiti tamwa nteqa kyeqa nramwaqita vi varuvata ");
INSERT INTO omw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisi vaisivanto mwihua taqeta Iesusirara tiqatama, Mwataqi mwihua taqaante. Mwaanraqaa qao timwa tai inraikyarama mwihua vareta hiavo, tita. ");
INSERT INTO omw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Parisi vaisinramwuvanto mwitaa tuvaro Iesusiva nkyiari timwa nyinro tiqaro, Haaru nkyi haivaqava Ntevitivavata, mwiavata nruhua mwihuavata, kyara nraataa huvata varuvaro Ntevitiva kuaa qara hura mwia nkye hia mpukuqi kyaara ntumwa kyeta riaarave? ");
INSERT INTO omw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Apaiataava Kotira kyaiqa vara mwate varuva vunyaa vaisivanto varu entaraqaa Ntevitiva Kotira nraamwuqi vera ntero mpereti Kotirani vatora vara kyero nrenro nteqa kyero nai mwia vatama kyeta nruhuavata hini nyuvata nronrave. Kotira kyaiqa vara mwate varu vaisihua nraahu mwi kyarara nraataara vahuvaro qumina vaisivanto mwi kyarara nrenro mwi quara nteqa kyorave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iesusiva mwitaa timwa kyero tiqaro, Kotiva vaisiara rieqaro mwaanra enta vahiananrove turave. Kotiva hia mwaanra entara rieqaro vaisi utu tairave. ");
INSERT INTO omw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ni mwatani mwatatai nraaqiarara nronraqama kyaihana variqana nte mwaanra entaqaa ntaqikyiqanama ntena kyakya hiani kyaiqara qioma varaaninrave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mpo enta Iesusiva mwaanra nraamwuqi vera ntero taqovaro vaisi mpovanto kyauqu hini kukokaqama vuva varuvata ");
INSERT INTO omw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","mwiqi varuhua mponramwuvanto tiqata, Kyai variqata taqaararo Iesusiva vaisi kyauqu kukoka mwia mate mwaanra tuna entaraqaa kyuqema kyairera, mwia kyaara mwiaqaa qua vataare, tita. ");
INSERT INTO omw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mwihua mwitaa timwa kyeta Iesusira taqe varuvaro Iesusiva kyauqu hini kukoqama vu vaisirara tiqaro, E nrinra vaisi variara utaqaa sivira variante, tuvaro mwiva siviro varuvaro ");
INSERT INTO omw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Iesusiva mwihua kyapara hiro tiqaro, Tirenramwu teta mwaanra qua rieqatama mwaanra qiana entaraqaa nataa hiani kyaiqarave qio varaananrave? Tire mwi entaraqaa vaisi mpo kyaahaqamave mwataananrave? Mwia uaqiamave mwataananrave? Mwaanra qiana entaraqaa tire vaisi mpo kyaahaqa hiararo mwiva qative variananrove? Tire qaqira kyeta mwi vaisira ruve kyaananrave? tiro. Iesusiva mwitaa tuvata mwihua hia quavata tihua tirema varuvaro ");
INSERT INTO omw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesusiva taqovata mwihua hia mwi vaisirara po kye tiraitita, kapera viri rate varuvaro mwia kyaara Iesusira mwutukyavanto uaqia huvaro mwia raraqa tovaro mwi vaisirara tiqaro, Ena kyauqu ntatutaante, tuvaro mwiva nai kyauqu ntatuta kyovaro kyuqema vura. ");
INSERT INTO omw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mwia kyauquvanto kyuqema vuvata Parisi vaisi mwinramwuhua mwaanra nraamwuqitai veva nteta uro Herotira vataqita nrohuhua kyapata ntuvaantua hita variqata Iesusira nataama kyetave ru kyaananrave timwa kyeta nai timwa mwi nai timwa mwi hi varura. ");
INSERT INTO omw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesusiva nai nraaqiaranramwu sita varero kyaarera tokyasata uro varuvata nraakye qora airivanto Karirinyaahuave, Iutianyaahuave, ");
INSERT INTO omw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ierusaremiqinaahuave, Itumianyaahuave, Taiaaqinaahuave, Saitoniqinaahuave, Iotaani nramanri vutura qarahi hini varuhuave, mwihua Iesusiva mpo kyaiqa mpo kyaiqa vare varurara rieta, mwihua Iesusiva varura nramanri tokyani ntuvaantuama vita varura. ");
INSERT INTO omw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nraakye qora airivanto ntuvaantuama vita varuvarora tiro, Iesusiva nai nraaqiaranramwuanra tiqaro, Nraakye qoravanto ni ntaqutivorave. Mpotu terama kyeta vataivaqena mwiqi mwaanrintena variankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iesusiva nraakye qora airi kyuqema kyovatara tita, nriqa vuhua mwia tu vararerata uti variqata nai ntaquti nai ntaquti hi varura. ");
INSERT INTO omw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mwihua mwitaa hi varuvata nraakye qora mponramwu vaanavanto mwihua utaqi varuhua, mwihua Iesusira taqeta mwia vuni tumu ntita variqata aakyara nteta tiqata, E Kotira mwaaquvantove, tita. Vaanavanto mwihua utaqi varu vaisihua mwitaa tuvaro ");
INSERT INTO omw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Iesusiva mwihuara kepukyaqama kyero tiqaro, Hia ni okyarara qiate. Tirema variate, turama. ");
INSERT INTO omw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesusiva mwini vari kyero uro taaqi mporuqa variqaro nai mwutukya vahu vaisihua nraahu nyaanrovata mwihua uro varuvaro ");
INSERT INTO omw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Iesusiva vaisi 12 nramwu kyaara ntumwa kyero mwihuara nte mwihua sitaarita ni qua vareta timwa nyiqi quate timwa kyero, mwihua nronraqama kyero mwihuara tiqaro, Nkyenramwu ni airuqama mateta ni qua timwa nyiate tinama, nte nkyi sita vatauqo. ");
INSERT INTO omw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nkyenramwu vaana titaivaro nritarero quarive tina, nte nkyi kepukya nyinrenrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iesusiva mwaa vaisinramwuhua sitora: Saimoninra. Iesusiva mwia mpo nrutu ntamwatero Pitaavave tiro. ");
INSERT INTO omw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Iemisikya Ionikya. Mwitanahua Sepetira mwaaqutana varura. Iesusiva mwitanahua mpo nrutu Poanesisi-huatanave tura. (Poanesisi mwaa quaraqitai tirera, Nyaanruva Nruqua Ti Varirave, tita.) ");
INSERT INTO omw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Enturura, Piripira Pataromiunra Matiura Tomaasira Iemisira. mwiva Arapiaasira mwaaqu Tatiaasira Saimoninra. mwia nrutu mpo Serotira ");
INSERT INTO omw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Iutaasira. mwi vaisiva Iesusira ntavaaqavu kyaate tiro, mwia qovarama kyo vaisiva. Iesusiva 12 vaisi mwi vaisinramwuhua sitora. ");
INSERT INTO omw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesusiva nai nraaqiaranramwu sita varero nraamwunianra nkyiari mwaatani vuvata qaiqaa nraakye qora airivanto mwia taqarerata ntuvaantuama vita varuvaro Iesusiva nai nraaqiaranramwu kyapata kyara nraanriva hia qioqa huvaro varuvata ");
INSERT INTO omw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iesusira vataahua mwi quara rieta Iesusirara tiqata, Qikye, mwiva ueraqamama viho. Kyai uro mwia vitaare, timwa kyeta vurama. ");
INSERT INTO omw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mwaanra okyara ti varu vaisihua mponramwuvanto Ierusaremisaita tumunte mwitaama tita, Vaana vunyaava Pierisepurivama Iesusira utaqi variho. Pierisepuriva mwia utaqi variqaro mwia kyaahaqa hi variharoma Iesusiva vaisiqitairo vaana tite variho, tita. ");
INSERT INTO omw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mwihua mwitaa tuvaro Iesusiva mwihua nyaanrovata vaini nruvaro mpo quaqaa ntumwa kyero mwihuara tiqaro, Saataaniva nataama kyerove nai henanra titairaro nritaraananrove. ");
INSERT INTO omw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kuaa mwatanaavanto ntainravi variqata nkyiaritana nai ntaqi nai ntaqi ihua hia qio varivarave. ");
INSERT INTO omw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kuaa nraamwunaavanto ntainravi variqata nkyiaritana nai ntaqi nai ntaqi ihua, mwihuavata hia qio varivarave. ");
INSERT INTO omw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Saataaniva ntaqikyi vari vaanahua ntainra vita nai ntaqi nai ntaqi hi varivaro Saataaniva hia mwihuaqaa ntaqikyiqiro viraro mwihua kepukyavanto taiqaananrove. ");
INSERT INTO omw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mpuara varaiva hia kepukya vaisi mpo nraamwuqi qumina vera ntero mpo inraikya varairave. Mpuara varaiva vuni kepukya vaisi mwia nraante rupa kyero vatero mwiaqaatairo vera ntero mpo inraikya mwiani mpuara varairave. ");
INSERT INTO omw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nte qutaa qua qianinra riaate. Nraakye qoravanto uaqia hiani kyaiqara mpo qara mpo qara hiani kyaiqara uti vari quarave, uaqia hi quara mpohuara ti vari quarave, Kotiva qioma ekyaa mwi quara mwi quara nraakye qora qati nruka kyero taunru nyataananrove. ");
INSERT INTO omw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Vaisivanto Kotira mwanraqurara uaqia hi quara ti vari quara Kotiva mwaa entaravata nraakiaravata mwi quara hia nruka kyero taunru nyataananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesusirara vaanavanto mwia utaqi variho tuvarora tiro, mwiva mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iesusiva mwitaa tuvata mwia nrovavata, mwia qatanramwuvata, nri nteta mwaata qesaqa sivi varita tiqata, Iesusira tivaro tumuanrive, tuvata ");
INSERT INTO omw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","nraakye qora airivanto Iesusira tataaqa mwatakyaa vita varuhua Iesusira timwa mwita tiqata, I nrovavata, i qatanramwuvata, mwaataqa variqata iara tumuante qiavo, tita. ");
INSERT INTO omw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mwihua mwitaa tuvaro Iesusiva mwihua kyapara hiro, Tavave ni ntova variho? Tahuave ni kata pakyaa variavo? tiro. ");
INSERT INTO omw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mwitaa timwa kyero mwia tataaqa vara ututu mwatakyaa vita varuhua taqero tiqaro, Mwaahuama ni ntohua ni kata pakyaa variavo. ");
INSERT INTO omw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ni kova nyaamwuni varira mwia qua rieqata nrohi variahua, mwihuama ni kata pakyaa variavata, ni nunra nakyaa variavata, ni ntohuamwanra varita hiavo, tura. ");
INSERT INTO omw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesusiva kyaarera tokyani uro variqaro nraakye qora qua mwakyaakya timwa nyiankye tuvata nraakye qora airivanto ntuvaantuama vita mwia ututuma kyovarora tiro, Iesusiva qaqira kyero mpotu mpoqi mwaanri ntero mwiqi mwatakyaa viro nramanriqaa varuvata nraakye qoravanto nramanri tokya sata varura. ");
INSERT INTO omw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mwihua mwataqaa nramanri tokya sata varuvaro Iesusiva mpo qua mpo quaqaa ntumwa kyeqaro timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Iesusiva tiqaro, Nte qianinra riaate. Vaisi mpovanto kyara vara tirero humwu isaqiro vurave. ");
INSERT INTO omw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mwiva kyara humwu isaqiro vuvaro mpohuva aanra tokyani tumu ntuvaro nyaamwavanto nrumu nramwa kyorave. ");
INSERT INTO omw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mwitaa huvaro humwu mponramwuvanto ori mwataqaa tumu ntuvaro mwatavanto hia vevatoqama vahuraqaara tiro, qamwanrama qupiqa vuvaro ");
INSERT INTO omw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","mwia tuqavanto hia mwataqi vevato vuraqaara tiro, huarivanto nri ntero itovaro aaharama vurave. ");
INSERT INTO omw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mwitaa huvaro humwu mponramwuvanto uakukya qupiqoraqi tumu ntiro uakukya vatama kyero qupiqa vuvaro uakukyavanto ntumwaqu kyovaro hia tamwa riorave. ");
INSERT INTO omw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mwitaa huvaro humwu mponramwuvanto kyuqe hu mwataraqaa tumu ntiro kyuqema kyero qupiqeqaro kyuqe tamwa riorave. Mpo huva airi tamwa riemwa tovaro mpo huva uro mpoqiavata riemwa tovaro mpo huva uro mwiavata nraatarero mpoqiavata riemwa torave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iesusiva mwi quaraqaa ntumwa kyero timwa nyi taiqa kyero tiqaro, Nkyi nyaato vahirera, mwi quara okyara ntapihi kyeta riaate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iesusiva qua timwa nyi taiqa kyovata nraakye qoravanto nkyiari mwaatani vita nrita huvaro Iesusiva nanrianraa varuvata mwia nraaqiara 12 nramwuvantovata, mpo uhuavata, mwiva varunani nri nteta Iesusiva mwi quaraqaa ntumwa kyero tu okyarara hia ntapihiraitita, Iesusira kyapara huvaro ");
INSERT INTO omw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iesusiva mwihua timwa nyinro tiqaro, Kotiva nraakye qoraqaa ntaqikyiani quara uqetatai quara, mwi quara Kotiva nkyiara qati kyairata mwi quara okyara riaate tirave. Mwitaa timwa kyero mpo nraakye qora qatinani varihua mwi quara okyara hia ntapihi kyera timwa nyiante tihananra tina, nte mwi quaraqaa ntumwa kyeqana mwihua timwa nyinrenrave. ");
INSERT INTO omw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nte mpo quaqaa ntumwa kyena qiarita nraakye qoravanto taqeqatavata hiama ntapihi kyeta taqevarave. Mwihua ni qua rietavata hiama ntapihi kyeta rievarave. Mwihua ni qua rieqata nkyiari uaqiahi kyaiqara qaqira kyaivarovauma Kotiva mwihua uaqiahi kyaiqara vare quara nruka nyataananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iesusiva mwitaa timwa kyero mwinramwuhuara tiqaro, Nkye mpo? Nte mwi quaraqaa ntumwa kyena tu okyarara hiave nkye ntapihi riaavo? Nkye hia mwi quara okyara ntapihi kye riaivera, nte nraakiara mpo quaqaavata ntumwa kyena qiani quara, nkye nataama kyetave qio mwiavata ntapihi kyeta rievarave? ");
INSERT INTO omw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nte vaakya mwi quaraqaa ntumwa kyena tu okyarara tirerave. Vaisivanto humwu isatora mwi quara okyara vahirero Kotira quama vaiho. ");
INSERT INTO omw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Humwu aanraqaa tumuntu quara mwia okyara vahirero nraakye qora mponramwuvanto mwi humwunra votima kyeta variarave. Mwi nraakye qorahua Kotira qua riaavaro Saataaniva nri ntero mwihua su nyaato mwutukyaqitairo mwi quara ntavihi kyero varairave. ");
INSERT INTO omw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mpohia nraakye qorahua ori mwataqaa tumu nti humwunra votima kyeta variarave. Mwinramwuhua Kotira mwakyaakya rieta mwi quarara qamwata kyeta variavaro ");
INSERT INTO omw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","quavanto hia mwihua mwutukyaqi vihata mwi nraakye qorahua hia mwi quara mpo enta mpo enta riaraitita variavata mwi quara kyaara mpo hiahua mwihua uaqiama nyatarerata uti variavata mwihua tiri rivorave tiqata Kotira qua qamwanrama qaqira kyeta varia nraakye qorahua variarave. ");
INSERT INTO omw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mpohia nraakye qorahua uakukya qupiqairaqi isato humwunra votima kyeta variarave. Mwi nraakye qorahua Kotira qua rieta ");
INSERT INTO omw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mwiaqaataita mwihua mwatanyaa inraikyara nronraqama kyeta riemwaqi viqata munimanrave, mpo inraikyarave, qamwata kyeqata mpo inraikya mpo inraikya vararerata riemwaqi vita Kotira qua qaqira kyaavaro Kotira quavanto hia mwi nraakye qorahuaqi vaihata variarave. ");
INSERT INTO omw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mwihua mwitaa hiavata mpohia nraakye qorahua kyuqe mwataqaa isato humwunra votima kye variarave. Mwi nraakye qorahua Kotira qua rieta mwi quarara qutaave timwa kyeta, mwi quara riemwaqi vita kyuqe kyaiqa Kotirani varaqita quarave. Mpohia nraakye qorahua mwi quara rieqata kyuqe kyaiqa Kotirani varaqi vi variavata, qaiqaa mpohia nraakye qorahua mwihua nraatara kyeta uro mpoqiavata kyuqe kyaiqa Kotirani varaqi vi variavata, qaiqaa mpohia nraakye qorahua mwihua kyaiqavata nraatara kyeta uro nai mpoqiavata kyuqe kyaiqa Kotirani varaqita vi variarave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesusiva mwitaa timwa kyero mpo quaqaa ntumwa kyero tiqaro, Omwa qupi kyero taini uro vatairave? Tave vara kyero ntumwaqu tairave iho? Tainta mwemwaqi veta vatairave iho? Qaqao, hia mwitaa hiraitiro, omwa qupi kyero tuaahera kyero qoqaa mwaanri vatairave. ");
INSERT INTO omw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nraakiara ekyaa uqeta taani inraikyara qoqaama qovarama kyaananrove. Ntumwaqutaani inraikyara ekyaa qoqaama qovarama kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nkyi nyaato vahirera, mwi quara okyara ntapihi kyeta riaate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesusiva mwitaa timwa kyero mwiva tiqaro, Nkye qua riaara mwia ntapihi kyeqata riaate. Nkye nanra tukyaqaave mpohua nyitave mpohua vara nyatera mwi tukyaraqaama Kotiva nkyitavata nyiqanro mwiaqaa mpoqiavatama nyiananrove. ");
INSERT INTO omw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kotira qua riaariva variqiro viraro Kotiva mwia kyaahaqa hiraro mwiva mwia qua mpoqiavatama riaananrove. Kotira qua hia riaariva variqiro viraro mwiva nanra inraikyave tutaaninra mwia vara kyairaro mwiva qatima variananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mwitaa timwa kyero Iesusiva mpo quaqaa ntumwa kyero timwa nyinro tiqaro, Kotiva ntaqikyiariva mwaa quara votima kyeroma vaiho. Vaisivanto kyara humwu isatero ");
INSERT INTO omw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","mwiaqaatairo mwiva uro vaitero siviro qaiqaa vaitero siviro mwitaamaqiro vi variharo kyara humwuvanto nai ntukohiro qupiqe varirave. Vaisivanto kyara humwu mwiva qupiqaani okyarara hia ntapihiharo ");
INSERT INTO omw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","nai mwataqi vahiro naiqama kyero qupiqairave. Tauraaqama kyero uru mwiva ntukohiro turu vera kyero uro tamwa riemwa taiharo tamwa mwiva peqaqa hirave. ");
INSERT INTO omw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Peqaqama viharo vaisivanto paipa varero uro tamwa mwia teqa kyeqaro varairave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesusiva mwitaa timwa kyero qua timwa nyiqiro viro mwitaama tiro: Kotiva ntaqikyiva nanra inraikya votima kyerove vaiho? Mwianra rieqana nanra quaqaave ntumwa kyena qianinrave? ");
INSERT INTO omw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Qio mwia maasiteti kyatari mwia tamwa votima kyeroma vaiho. Uru mwiva nai pata qiani vahirarama tuqo. Vaisivanto uru mwia vara kyero mwataqi tutaiharo ");
INSERT INTO omw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","qupiqero kyatari nronraqama viro hini kyara tutaaravata nraatara kyero nritarero kyatari nronra vaiharo mwia kyaaravantovata nronra vaiharo nyaamwavantovata mwia kyauquqaa nraamwu hoqatero mwia aamanaqi varirave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mwitaa timwa kyero Iesusiva mwi quara voti hira mpo qua mpo quaqaavata ntumwa kyeqaro timwa nyiqiro viro nraakye qoravanto ntapihi kyeta rie quara nraahu mwihua timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mwiva nraakye qora qua timwa nyinrenro hia vutu kyero tiraitiro, mpo quaqaa ntuma kyeqaro timwa nyiqiro vuvata nraakye qoravanto nkyiari mwaatani vita nrita huvaro Iesusiva nanrianraa nai nraaqiaranramwu kyapata variqaro mwi quara okyara ntapihi kyero mwinramwuhua timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mwi entara entama vuvaro Iesusiva nai nraaqiaranramwuanra tiqaro, Nrivaqenramwu nramanri nronra mwaa qara vare vutura hini tokyani quare, tiro. ");
INSERT INTO omw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mwitaa tuvata mwia nraaqiaranramwuvanto nraakye qora ntuvaantuama vuhua mwini kyeta Iesusiva varu mpoturaqi mwaanrinteta mwia vita vareta vuvata mpotu mponramwuvanto mwihua vatama kyeta vurama. ");
INSERT INTO omw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mwihua nramanri mwiaqaa vi varuvaro qamwanrama kyero toqa vaururuvanto nronraqama kyero tiqaro nramanri ventaqiro nrivi varuvaro nramanrivanto mpotuqi mwaanrintero piqa kyarero uti varuvaro ");
INSERT INTO omw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesusiva mpotu vitiqi turuma ntumwa kyero vaite varuvata mwia nraaqiaranramwuvanto mwia uro vaurama kyeta tiqata, Mwaanra ti variara vaisio, tirinramwu nramanrivanto ntaqutu kyaaninranra e hiave nronraqama kyera riaaro? tita. ");
INSERT INTO omw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mwihua mwitaa tuvaro Iesusiva vaitoraqitairo siviro toqa vaururu mwia inronra hiro kyaarera mwianra tiqaro, Qati tirema vahiante, tuvaro toqavanto taiqa vuvaro nramanrivanto utomwi tirema vahura. ");
INSERT INTO omw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tirema vahuvaro Iesusiva nai nraaqiara mwihuara tiqaro, Nanra inraikya nraatuve aatu hi variavo? Nkye hiave nianra kepukyaqama kyeta rieta hiavo? tiro. ");
INSERT INTO omw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iesusiva mwitaa tuvata mwia nraaqiaranramwuvanto aatu hita kyauqu ntukikinraaqateta tiqata, Qikye, mwaa nai nataahi vaisivave? Toqa vaururuvantovata, nramanrivantovata, mwia qua riaiho, tita tura. ");
INSERT INTO omw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mwia nraaqiaranramwu mwitaa timwa kyeta mpotuqi vuhua kyaareraqa qara vareta hini tokya Kekesaani uro ntovaro ");
INSERT INTO omw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iesusiva mpotuqitairo mwaamwi ntovaro vaisi mpovanto ori ataamwuqitairo veva ntero uto Iesusira hunta kyora. ");
INSERT INTO omw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Mwi vaisiva vaisi qunte varura ori ataamwuqi variqiro vi varuvaro vaanavanto mwia utaqi varuvaro varuvata mpo uhua seni vara kyeta mwia rupa taare tita, rupa tovaro mwi vaisiva airi kyaanta kyuqu kyauqu rupa tora ntapihiqaro ntukekaama kyora. Qaiqaavata mwitaama kyeqata mwia rupa taare tuvaro mwiva seni ntukekaama nraahu kyorara tiro, mpovanto mwia rupaariva hia varura. Mwia nraataraariva hia varuvaro ");
INSERT INTO omw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","mwi vaisiva entaqivata, iheravata, vaisi qunte varura ori ataamwuqi viro nrinro hiqaro qua aakyara timwaqiro viro taaqiqaavata nrohiqaro qua aakyara tiqaro oriqotairo nai mwamwanta toqaaqamaqiro vi varura. ");
INSERT INTO omw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mwi vaisiva variqaro nyianrasairo Iesusira taqero hiantero uro mwia kyuqutarani tumu ntiro variqaro ");
INSERT INTO omw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","mpoqama kyero aakyara ntero tiqaro, Iesusio, Kotiva nai virini variva varihara e mwia mwaaquvanto variaro. Ni nataa hirere nrianro? Kotirara rieqara hia ni ruantema tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Iesusiva vuni mwi vaisirara tiqaro, Uaqia hiara vaanavao, mwi vaisiraqitaira nritarera quante, tuvarora tiro, mwi vaanava mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mwitaa tuvaro Iesusiva mwi vaananranra ena nrutu qiante tuvaro vaana mwiva nai nrutu ntero tiqaro, Ni nutu Airivave. Tire airivantoma mwaa vaisiraqi varuro, tiro. ");
INSERT INTO omw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mwitaa timwa kyero mwi vaanava qaiqaavata airi nani Iesusirara po kye tiro tiqaro, Hia mwaa mwataraqaataira tiri titaante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mwitaa timwa kyeta vuru taqovaro mwi entara quara airintivanto uhiqa nre varuvata ");
INSERT INTO omw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","vaananramwuvanto Iesusirara po kye tita tiqata, Qati tiri titairaqe quara mwihuaqi viqetaare, tuvaro ");
INSERT INTO omw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesusiva mwihua qati kyovata vaana airivanto mwi vaisiraqitai nritareta uro quara mwihuaqi viqeteta varuvata mwiaqaataita quara 2,000 nramwuvanto hianteta okai veva vahuraqi ito ntamwanra nramanriqi kyavuhu vuvaro nramanrivanto ekyaa mwihua ntaquti kyora. ");
INSERT INTO omw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Quaravanto nramanriqi ntumwa vita qutu vuvata quaraqa ntaqikyu vaisinramwuhua taqeta mwiaqaatai hiantamwa teta mwatukya nronraqi uro mwi quara timwa nyita aanranivata viqata viti viri timwa nyiqi vuvata mwi mwatanaahua mwi inraikyara taqarerata nrumu ");
INSERT INTO omw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iesusiva varunani taqovaro vaakya vaana airivanto mwia utaqi varu vaisiva qati mwatakyaa viro tuavaaqa utu tero mwia vu nraato ntapihi vuvaro varuvata mwihua mwia taqeta aatuma kyeta varura. ");
INSERT INTO omw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mwihua mwi vaisira taqeta aatu hiqata varuvata vaisi mponramwu vaakya mwi inraikyara taqohua timwa nyita tiqata, Iesusiva mwitaama kyaiharoma mwi vaisiva kyuqema viho, timwa kyeta quaravata timwa nyuvata ");
INSERT INTO omw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","mwi mwatanaahua mpoqama kyeta aatu hita Iesusirara tiqata, E tiri mwataqaataira quante, ti varura. ");
INSERT INTO omw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mwi mwatanaahua mwitaa tuvaro Iesusiva mpotuqi qaiqaa mwaanri nte varuvaro vaakya vaanavanto utaqi varu vaisiva Iesusirara po kye tiro tiqaro, Kyai ntevata ivata quankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mwitaa tuvaro Iesusiva qaqao tiro, Hia mate nivatama kyera vinanrave. E ena mwaatani uro variqarama Kotiva i kyuqema kyero kyaahaqama mwatairara ena nramwunaahuavata timwa nyiante. Kotiva iara po kye timwa mwatai quara uro ena nramwunaahuavata timwa nyiante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iesusiva mwitaa tuvaro mwi vaisiva Iesusiva tunte hiro mwi mwatara kyero uro kyauqurutana mwatukya vahunani nrohiqaro Iesusiva nai kyuqema mwatorara nraakye qora timwa nyiqiro vuvata ekyaa mwia qua riohua mwi quara rieqata mwihua nkyiari kyauqu ntukikinraaqa teqata varura. ");
INSERT INTO omw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mwi mwatanaahua Iesusirara hia tiri mwaatani variante tuvaro Iesusiva mpotuqi qaiqaa mwaanri ntero nrumu ntantero kyaareraqa qara varero hini tokyani vuvata mwini nraakye qora airivanto ntuvaantuama vita mwiva varunani ututuma vita varura. ");
INSERT INTO omw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Varuvaro vaisi mpovanto mwi mwatukyaraqi mwaanra nraamwuqaa ntaqikyi varuva, Iairaasiva nri ntero Iesusira taqero mwia kyuqutarani tumu ntiro Iesusirara ");
INSERT INTO omw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","po kye tiro tiqaro, Ni naamwunravanto qaumama qutu quananrove. E nrinra ena kyauqu mwiaqaa vatairaro mwia nriqa quariva taiqa viraro qati variarive, tiro. ");
INSERT INTO omw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mwi vaisiva mwitaa tuvaro Iesusiva mwikyantiri vurama. Iesusiva Iairaasikyantiri vi varuvata nraakye qora airivanto mwia vataqita viqata hisai hisaita mwia rataaqi vi varuvaro ");
INSERT INTO omw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","nraakye mpovanto ekyaa enta tora taqamwaqiro vuvavata mwihuaqi varura. Mwi nraakyeva 12 ihiara tora taqamwaqiro viqaro nronraqama kyero nriqa vuvaro variqaro ");
INSERT INTO omw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","mpo totaa mpo totaahuara ni kyaahaqa hiate timwa kyero, munima nyuvata mwihua hia mwia kyaahaqa hiraitita, mwia munima nraahu nramwa kye varuvaro mwia mwamwanta mpoqiavata uaqiama vuvaro varura. ");
INSERT INTO omw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Mwi nraakyeva nraakye qora utaqi variqaro Iesusiva kyaiqa varorara rieqaro Iesusira nraakiara nriqanro nai riero tiqaro, Nte mwia tuavaaqaqa kyaatu kyaariro ni nriqa viva qamwanrama taiqa quarive, tiro. Nraakye mwiva mwitaa timwa kyero Iesusira vaaqaqa kyaatu kyovaro ");
INSERT INTO omw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","qamwanrama kyero mwia nraanre ntova aaharama vuvaro mwiva taqovaro mwia mwamwantavanto qio vahura. ");
INSERT INTO omw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mwia mwamwantavanto kyuqema vuvaro varuvaro Iesusiva qamwanrama kyero taqovaro mwia kepukya hinivanto vivuvaro mwiva tuqasaa viro nraakye qora mwia vataqita nruhua kyapara hiro, Tavave niqa tu varaiho? tiro. ");
INSERT INTO omw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Iesusiva mwitaa tuvata mwia nraaqiaranramwu tiqatama, Nai tavave iqa tu varaiho? Ena taqaante, nraakye qora airivanto i nraaqani viqata i rataaqi vi variavo, tita. ");
INSERT INTO omw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mwitaa tuvaro Iesusiva qati nraahu vaisi viri mwia puaama kyarero aitutu hi varuvaro ");
INSERT INTO omw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","nraakye mwiva nai mwamwanta kyuqema vurara riero mwia nraatu hiqaro kyuqu kyauqu nti varuvaro uro Iesusira kyuqutarani tumu ntiro mwi quara ekyaa qoqaa timwa mwuvaro ");
INSERT INTO omw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesusiva nraakye mwianra tiqaro, Ni naamwunrao, e nianra mwiva ni kyaahaqa hiananrove qiararoma i mwamwantavanto kyuqema viho. Qioma i mwutukyavanto qihaakya hirara quante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesusiva mwi quara qati ti varuvata Iairaasira nraamwuqitaita vaisi mponramwu nri nteta Iairaasira hunta kyeta mwianra tiqata, I nraamwunravanto qutuma viho. Haunri mwaanra ti vari vaisira ntavaaqavu tero, tuvaro ");
INSERT INTO omw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesusivavata mwinramwuhua qua riero mwaanra nraamwuqaa ntaqikyi varu vaisirara tiqaro, Hia aatu hiante. Nianra kepukyaqama kyera rieqara variante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iesusiva mwitaa timwa kyero mwiva Pitaaravata, Iemisiravata, Iemisira qata Ioninravata, mwinramwuhua nraahu sita varero ");
INSERT INTO omw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Iairaasira nraamwuqi uro ntero taqovata nraakye qora nronraqama kyeta ti atura ntiqata ntate varuvaro ");
INSERT INTO omw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iesusiva nraamwuqi vera ntero tiqaro, Nanranre nkye ntate variavo? Mwi qiaatarava hia qutu viho. Mwiva qati vaitema variho, tiro. ");
INSERT INTO omw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Iesusiva mwitaa tuvata mwihua Iesusira quara raima mwateta varuvaro Iesusiva ekyaa nraakye qora vara veva mwaatani kyero qiaatara mwia nrohua qohuavata, taaramponramwu nai sita tohuavata, mwinramwuhua nraahu sita varero qiaatara mwiva qutuvata vatoraqi uro ");
INSERT INTO omw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","mwia kyauquqaa tu varero nai quaqitairo tiqaro, Tarita kumi. mwaa qiaatararuvao, nte iara siquantema tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Iesusiva mwitaa tuvaro mwi qiaatarava qamwanrama siviro nrohi varura. Mwiva 12 ihi vara kyo qiaatarava siviro nrohi varuvata mwinramwuhua mwia taqeta nrihanrama vita mpoqama kyeta kyauqu ntukikinraaqate varuvaro ");
INSERT INTO omw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iesusiva mwinramwuhuara kepukyaqama kyero tiqaro, Qio mwaa taqaarara hia mpohua timwa nyiate. Mwaa qiaatarara kyara nraahu mwiate, turama. ");
INSERT INTO omw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesusiva mwi mwatara kyero nai mwaatani vuvata mwia nraaqiaranramwuvanto mwia vatama kyeta vurama. ");
INSERT INTO omw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Iesusiva nai mwaatani uro variqaro mwaanra entaqaa uro mwaanra nraamwuqi qua mwakyaakya timwa nyi varuvata nraamwu mwiqi nraakye qora airivanto varuhua mwia qua rieta kyauqu ntukikinraaqateta tiqata, Qikye, mwi vaisiva taisairove mwi quara mwi quara riaiho? Mwiva kyuqe okyara mpo vu nraato mpo vu nraato taisairo vara qirove tiho? Tava mwi kyaiqara okyara mwia nraamwute variharove mwiva nronra kyaiqa vare variho. ");
INSERT INTO omw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mwiva taintave mwitaa inraikya uti varivama variho. Mwiva Mariaara mwaaquve. Iemisivave Iosisivave Iutaavave Saimonivave mwihuama mwia qatanramwu variarave. Mwia nrunranramwuvata mwaini variarave, tita. Mwitaa timwaqi viqata Iesusira nramwunaahua mwianra qumina vaisive timwa kyeta, mwia qoririma mwatora. ");
INSERT INTO omw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mwihua mwitaa huvaro Iesusiva mwihuara tiqaro, Poropeti vaisi Kotira qua timwa nyi variariva mpo mwatani uro variraro mwi mwatanaavama mwianra qamwateqaroma mwia nrutu tuaaheraananrove. Mwi vaisiva nai mwaatani variqaro nai nrunra qata kyapata variraro mwia nramwunaava mwianra qumina mwaa mwatanaava nraahuma variho timwa kyero hiama mwia nrutu tuaaheraananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mwitaa timwa kyero nraakye qoravanto Iesusirara qumina vaisive tura kyaara Iesusiva hia qio nai mwatukyaqi nronra kyaiqa varaariva vahuvaro mwiva nriqa vuhua pataqiatanaqaa nraahu nai kyauqu vatovata kyuqema vura. ");
INSERT INTO omw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mwia nramwunaahua mwianra hia qio tiri kyaahaqa hiarivave turara Iesusiva airi nraato tiqaro varura. Mwi mwatukyaraqitairo Iesusiva siviro vintante nrintante mpo mwatukya mpo mwatukya variqi viqaro nraakye qora mwakyaakya timwa nyiqiro vura. ");
INSERT INTO omw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iesusiva nai nraaqiara nyaanrama kyero taaratana taaratana sitovata 12 mwinramwuhua mpona mpona vura. Mwiva mwihua siteqaro vaisiqitaita vaana sitaivata qatinani nritareta quate tiro, mwiva mwihua kepukya nyiqanro qua mwitaama tiro: ");
INSERT INTO omw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nkyenramwu virera hiqatama hiama mpo inraikya mpo inraikya vareta viraitita, aanraqaa kyauru quru vare vira nraahuma vareta quate. ");
INSERT INTO omw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Hiama kyarave tuave munimave vareta quate. Kyuqu nraamwu mwia nraahuma vara ututaate. Hia soti taaratana ututaate. Kuaiqia nraahu utu vareta quate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iesusiva mwi quara timwa kyero mwaa quaravata tiqaro, Nkyenramwu vivaro ta mwatanaavave nkyiara qamwateqaro nkyi sitairera, nkye nraamwu kuaikuqi nraahu variqita vitama mwi mwatukyara kyeta quate. ");
INSERT INTO omw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nkye vivaro ta mwatanaahuave hia nkyi qamwata nyateta nkyi qua hia riarera utivera, nkyetaqaatai ntuvenrauma kyeta qaqira tuto kyetama mwihua timwa nyita tiqata, Nraakiara nkyetama taqevarave, qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iesusiva mwitaa timwa kyero sitovata mwia nraaqiaranramwuvanto uro viti viri timwa nyita tiqata, Uaqia hi aanranra qaqira kyeta kyuqe hi aanranraqaa quate, tita. ");
INSERT INTO omw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mwitaa timwaqi viqata vaisi utaqi vaana varuhua sitovata qatinani nritare vuvata airi vaisi nriqa vuhua, mwihua qiataqaa vahamwenra qu nyateqata kyuqema nyatovata qio varura. ");
INSERT INTO omw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mwitaa huvaro ekyaa mwi mwatanaava Iesusirara nai timwa mwi nai timwa mwi hi varuvarora tiro, Herotiva vunyaa vaisivanto mwi mwatara Kariri mwataqaa ntaqikyi varuva, mwivavata Iesusira nrutu riora. Nraakye qora hini uhua Iesusirara mwitaama tita, Mwi vaisiva Ionivave. Ioniva nramanri nyi varu vaisiva qutu vuva qaiqaa siviro nrohi variho. Mwiva qati siviro nrohi variqarora tiroma nronra kyaiqa qio vare variho, tita. ");
INSERT INTO omw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hini uhua mwitaa tuvata hini uhua qaqao tita, Mwi vaisiva tiri haivaqava Iraisaava qovarama viho, tita. Mwitaa tuvata mpo uhua Iesusirara tiqata, Haaru poropeti vaisi Kotira qua qovarama kye varuhua, Iesusiva mwihua votima kyeroma variho, tita. ");
INSERT INTO omw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nraakye qora Iesusirara mwitaa ti varuvaro Herotiva mwi quara riero tiqaro, Qikye, mwi vaisiva nramanri nyi varu vaisivama variho. Nte qiavaro mwia nrunta teqa kyova Ioniva, mwivama qutu viraqitairo qati siviro nrohi variho. Mwiva qutu viraqitairo qati siviro nrohi variqarora tiroma, mwiva nronra kyaiqa qio vare variho, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Tauraa Herotiva nai qata Piripira nraata Herotinamainra varatero varuvaro Ioniva nri ntero airi nani Herotirara tiqaro, E ena qata nraata hia varaataarama varera hiaro, tuvaro mwia kyaara Herotiva nai nraata Herotinamainranra tu quara rieqaro mwiva naivanto vaisi mpo titovaro Ioninra ntavaaqavu kyero rupaqiro uro karavuqi kyora. ");
INSERT INTO omw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kyovaro Ioniva karavuqi varuvaro Herotira nraatavanto Herotinamaiva varuvaro Ioniva mwianra tu quava mwia raraqa tovaro Ioninra rukyarera utuvaro hia mwia rukyaari aanrava vahura. ");
INSERT INTO omw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ioniva vaisi kyuqeva avuqavuma kyero nrohi varurara tiro, Herotiva mwianra rieqaro mwia nraatu aatu hiqaro hia mwia rukyaate tiro. Mwitaa timwa kyero Herotiva Ioniva ti varu quarara qamwateqarovata mwiva mwia quara taara nraato tura. ");
INSERT INTO omw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mwitaamaqi vuvaro mpo enta Herotinamaiva Ioninra rukyaari aanrava qio vahura. Mwi quara okyaravanto mwataamama vahiro. Herotiva nai mwato entava qovara huvaro mwi entaraqaa nronra vaisi kyara nyinrenro mwihua nyaanronra. Mwiva ntaqu vaisihuaqaa ntaqikyi varu vaisihuave, airi inraikya vato vaisihuave, mwiva mwihua nyaanrama kyero kyara nyinro. ");
INSERT INTO omw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kyara nyuvata mwihua nre varuvaro Herotinamainra nraamwunravanto nrumu mwihua ihi ntamwa nyatero. Mwiva ihi nte varuvata Herotivavata mwiva kyara nyuhuavata mwi mwanraatara qamwata mwateta. Herotiva nai nraata nraamwunranra qamwatero mwianra tiqaro, Nanra inraikyarave i mwutukya vaiho? Ni timwa mpiraqe i mwiankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mwitaa timwa kyero mwiva kyauqu nriqiqaa vatero tiqaro, Nte qutaama tuqo. E nanra inraikyarave tiraqena nte i mwianinrave. Mwata hini nte ntaqikyianinranra tiraqena nte ntainra kyena i mwianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Herotiva mwitaa tuvaro mwanraata mwiva veva ntero uro nai nronra ntumwahiamwa hiro tiqaro, Nto, nte nanra inraikyarave qiariro ni mpiananrove? tiro. Mwitaa tuvaro mwia nrova tiqaro, Ioniva nramanri nyi vari vaisira mwia qiata mpiante qiante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mwia nrova mwitaa tuvaro mwia nraamwunravanto hiantero uro vunyaa vaisi Herotirara tiqaro, Qamwanrama kyera Ioniva nramanri nyi vari vaisira nrunta teqa kyera tanuqa varaqira nrumu mpiante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mwanraata mwiva mwitaa tuvaro Herotira mwutukyavanto uaqia huvarovata mwiva vaakya kyauqu nriqiqaa vatorara rieqaro, kyara nranrenrata nru vaisihuaravata rieqaro tiqaro, Nte mwanraata mwianra tu quara nteqa kyaankyorave, timwa kyero ");
INSERT INTO omw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","mwiva karavu vaisiqaa ntaqikyi varu vaisira mpo titero tiqaro, Ioninra qiata qamwanrama kyera varaqira nrumu mpiante, tuvaro mwiva uro karavuqitairo mwia nrunta teqa kyero ");
INSERT INTO omw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mwiaqaatairo mwia qiata tanuqa vatero varaqiro nrumu mwanraata mwia mwuvaro mwiva varero uro nai nronra mwunra. ");
INSERT INTO omw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mwitaama kyovata Ioninra nraaqiaranramwuvanto mwi quara rieta mwihua nrumu Ioninra mwamwanta varaqita uro quntamwa kyora. ");
INSERT INTO omw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iesusiva nronraqama kyero sitovata vu vaisihua nrohita uro ntante nrumu ntuvaantuama vita Iesusira nraaqani variqata mwihua nkyiari kyaiqa varoravata, nkyiari nraakye qora timwa nyu quaravata, Iesusira timwa mwunra. ");
INSERT INTO omw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mwi entara nraakye qora airivanto Iesusira taqarerata vita nrita hi varuvarora tiro, Iesusivavata mwia nraaqiaranramwuvata hia kyuqema kye kyara nreva vahuvata varura. Mwitaa huvaro Iesusiva tiqaro, Vivaqenramwu uro qumina sata tetaraa variarata nkyenramwu ho hiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Iesusiva mwitaa timwa kyero mwinramwuhua sita varero mpotuqi mwaanri ntero kyaareraqaama tero qumina sata varirerata vurama. ");
INSERT INTO omw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mwinramwuhua vuvata airi nraakye qoravanto mwihua taqeta tiqata, Mwihua mate mwinima vivarave, timwa kyeta mpo mwatukya mpo mwatukyaqitaita mwihua hianteta kyaarera tokyasataa mwataqaa vuhua uro Iesusiva mpotuqima tero virera hunani mwihua nraante uro ntora. ");
INSERT INTO omw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mwihua nraante uro ntovaro Iesusiva nraakiara uro ntero mpotuqitairo mwatani mwaamwi ntero nraakye qora airivanto ntuvaantuama vuhua taqero mwihuara po kye timwa kyero tiqaro, Qikye, vaisivanto hia mwihuaqaa ntaqikyi varihata sipisipivanto nkyiariaraa nrohi varia sipisipihua votima kyeta mwaa nraakye qorahua api nrohi variavo, tiro. Mwitaa timwa kyero mwini variqaro Iesusiva qua mwakyaakya mwihua timwa nyi varura. ");
INSERT INTO omw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Iesusiva timwaqiro vuvaro huari mpuani tumi vuvata Iesusira nraaqiaranramwuvanto mwiva varunani uro nteta tiqata, Huarivanto mpuani tumi viharo mwaini qumina satave. ");
INSERT INTO omw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","E nraakye qora mwaahua sitairata mwihua uro kyara vahiani mwatukyaraqi nrohiqata kyara kyoqaama kye nraate. Mwihua hia kyara ntumwa vareta nriahuave, tita. ");
INSERT INTO omw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mwia nraaqiaranramwu mwitaa tuvaro Iesusiva qaqao tiro, Nkyetama mwihua kyara nyiate, tiro. Tuvata mwihua Iesusira kyapara hita tiqata, Tire nronra munima 200 kinaa mwia kyetave kyara vara kyeta mwihua nyiananrave? tita. ");
INSERT INTO omw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mwitaa tuvaro Iesusiva mwinramwuhua kyapara hiro tiqaro, Mpereti nataamave ntumwa taavo? Nkye uro taqaate, tuvata mwihua uro taqeta nrumu timwa mwita tiqata, Mpereti kyauquruvata tavukya taaratanavata nraahuma ntumwa taavo, tita. ");
INSERT INTO omw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mwia nraaqiaranramwu mwitaa tuvaro Iesusiva nraakye qora timwa nyinro tiqaro, Nkye mwukyau mwaa mpo sata mpo sata ekyaama mwatakyaa vita variate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mwitaa tuvata mwihua mpo sata 100 nramwu mwatakyaa vita varuvata mpo sata 50 nramwu mwatakyaa vita varuvata mwitaamaqi vita ekyaa nraakye qoravanto mwatakyaa vita varura. ");
INSERT INTO omw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mwatakyaa vita varuvaro Iesusiva mpereti hini kyauqu mwinramwunravata, tavukya taara mwitanavata, vara kyero nyaamwuni taqeqaro Kotirara kyuqemave timwa kyero, mpereti nteqa kyero nai nraaqiaranramwu nyinro tiqaro, Qio nkye varaqita uro nyivata mwihua nraate, timwa kyero tavukya taara mwitanavata tukyama kyero nraakye qora mwihua ekyaa nyuvata ");
INSERT INTO omw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ekyaa mwihua vikyokyama nronra. ");
INSERT INTO omw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vikyokyama nrovata Iesusira nraaqiaranramwu mwiaqaataita nraakye qoravanto mperetivata tavukyavata nreqata viti vaati kyora utu aatuma kyeta tua nronra ntutantuto tuara 12 nramwu piqa kyora. ");
INSERT INTO omw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mwi entara 5,000 vaisi airivanto mwi kyarara nronra. ");
INSERT INTO omw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iesusiva mwihua kyara nyinro mwiaqaatairo qamwanrama kyero nai nraaqiaranramwu sitero tiqaro, Nkye nraante mpotuqi mwaanrinte kyaareraqaamate vutura qarahi hini Vetasaitaani vi varivaqenama nte nraakye qora sitaarita nkyiari mwaatani quate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mwitaa tuvata mwihua vuvaro Iesusiva verara taaqiqaa Kotirara aakyara tirero viro. ");
INSERT INTO omw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Iesusiva Kotirara aakyara tirero vuvaro entama vuvata mpotuqi vuhua kyaarera tavaara sata vi varuvaro Iesusiva nanrianraa qatinani variro. ");
INSERT INTO omw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iesusiva mwini variqaro taqovaro toqavanto mwihua virera hunasairo nriqanro mpotu vente varuvata mpotuqi varuhua mwukyaari tiqata nramanri ntainraqita vura. Mwitaamaqita vuvaro qauma qaatatarera huvaro Iesusiva mwihua hunta kyarero kyaarera mwutuqaa nrinro. ");
INSERT INTO omw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Mwiva nriqanro mwihua nraatara kye quankye tiro, utuvata mwihua taqovaro Iesusiva kyaarera mwutuqaa nri varuvata mwihua mpoqama kyero nraatuqa tovata vaanave timwa kyeta, aatu hiqata oi aai ti varura. Mwihua oi aai ti varuvaro Iesusiva qamwanrama kyero mwihuara tiqaro, Kepukyaqama kyeta variate. Ntema nruqo. Hia aatu hiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mwitaa timwa kyero Iesusiva mpotuqi mwaanri ntero mwihua kyapata varuvaro toqavanto taiqa viro tirema vahuvata mwihua qikye tita, kyauqu ntukikinraaqate variqata ");
INSERT INTO omw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Iesusiva mpereti taaraqia airiqama kyero nraakye qora nyunranra hia mwihua su nyaato ntapihuvata hia Iesusira okyarara ntapihi kyeta riora. ");
INSERT INTO omw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mwihua vutura hini vantara Kenesaretini uro nte mwaamwi nteta mpotu rupate ");
INSERT INTO omw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","mwataqaa virera huvata mwi mwatanaahua Iesusira ntapihi kyeta taqeta, Qio mwaa mwivave, tita. ");
INSERT INTO omw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mwitaa timwa kyeta mwihua hianteta uro vutusai vurusaita nriqa vu nraakye qorahua sitaqita tumu Iesusiva variho tunani kyora. ");
INSERT INTO omw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iesusiva mwi mwataraqaa variqaro mpo mwatukya mpo mwatukya pata mwatukyave, nronra mwatukyave, uta aakyoqi vahu mwatukyarave, Iesusiva mwini nrohi varuvata mwi mwatanaahua nriqa vuhua sitaqita mwatukyaqaa kyeta Iesusirara po kye tita tiqata, Qiove nriqa vi nraakye qorahua i tuavaaqa vitiqaa kyaativarave? tuvaro Iesusiva qiove tuvata ekyaa mwiaqa kyaatu kyo nraakye qorahua kyuqema nraahu vura. ");
INSERT INTO omw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisi vaisinramwuvata mwaanra okyara ti varu vaisihuavata Iesusira taqarerata Ierusaremisaita nrumu Iesusiva varunani ntuvaantuama vita variqata ");
INSERT INTO omw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","taqovata Iesusira nraaqiara mponramwuvanto variqata Parisi vaisi mwihua qua mwaanra okyara qaqira kyeta hia kyauqu hiqaraitita, kyara nre varura. ");
INSERT INTO omw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mwi entara Parisi vaisinramwuvata ekyaa Iutia mwatanaahuavata nkyiari haivaqahua timwa to quara rieqata mwitaa mwitaama kyeqata mwihua nkyiari kyauqu hiqe varura. Mwihua hia kyauqu hiqohua hia kyara nronra. ");
INSERT INTO omw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mwihua uro maaketiqi nrohita uro ntanteta nrumu varita hia nkyiari kyauqu hiqama kyaraitita, hia kyara nronra. Mwihua haivaqahua kaapu hiqe okyararave, tanu hiqe okyararave, mpo okyara mpo okyara timwa nyuvata mwihua riemwaqi viqata nrohi varura. ");
INSERT INTO omw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mwihua mwi quara riemwaqita nrohi varuhuara tita, Parisi vaisinramwuvata, mwaanra okyara ti varu vaisihuavata, Iesusira kyapara hita tiqata, Tiri haivaqahua qua timwa tora i nraaqiaranramwuvanto nteqa kyeta hia kyauqu hiqaraitita, kyara nre variavo. Nanraqamave mwihua mwitaa hi variavo? tita. ");
INSERT INTO omw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mwitaa tuvaro Iesusiva mwihua nkyiari timwa nyinro tiqaro, Nkye unraqama kyeqata kyuqe kyaiqa vare variahuave. Aisaiaava haaru variqaro nkyiara avuqavuma kyero qara ntumwa torave. Kotiva mwia kyaahaqa huvaro Aisaiaava Kotiva mwitaama tiho tiro: Mwaa mwatanaahua nroqitai nraahu ni nutu tuaahere variavaro mwihua mwutukyavanto hia nianra vaiho. ");
INSERT INTO omw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mwihua mwaanra tiqatama mwihua nkyiari haivaqahua qua nraahu timwa nyiqata mwihua quminama ni nutu tuaahere variavo, tura. Aisaiaava mwitaama kyero qara ntumwa torave. ");
INSERT INTO omw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kotiva nkyiara mwitaa mwitaa hiate tu quara nkye mwi quara qaqira kyetama vaisivanto timwa taa quara nraahuma riemwaqita nrohi variarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mwitaa timwa kyero Iesusiva mwihuara qaiqaa tiqaro, Qio kyuqema hiavo. Kotiva mwitaa mwitaa hiate tu quara nkye mwi quara qoririma kyeta nkyi haivaqahua timwa to quara nraahu riemwaqita vi variahuave. ");
INSERT INTO omw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesiva Kotiva timwa to quara riero nkyiara tiqaro, Ena nrohua qohua nrutu tuaahera nyataante. Nai nrohua qohuara uaqia hiani quara ti variani vaisira rukyaate, turave. ");
INSERT INTO omw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kotiva mwitaa timwa to quava vaihata nkye mwi quara hia riaraitita, nkyeta riemwa kye nkye tiqata, Vaisivanto nai nrohua qohuara tiqaro, Nte nkyitana kyaahaqa hirera tu munimanra hia nkyitana nyinraitina, Kotirani vatarerave, tirera, ");
INSERT INTO omw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","mwi vaisiva qioma nai nrohua qohua qaqira kyero hia mwitanahuaqaa ntaqikyiqiro quananrove, qiarave. ");
INSERT INTO omw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nkye unra qua mwitaa tiqatama Kotira qua nteqa kyetama nkyita haivaqahua timwa nyu quara mwia nraahuma nraakye qora timwa nyi variavo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesusiva nraakye qora ntuvaantuama vuhua nyaanrama kyero mwihua timwa nyinro tiqaro, Nkye ekyaa nte tirera hiani quara kyuqema kyeta rieqatama variate. ");
INSERT INTO omw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kyaravanto qatinasairo vaisi utaqi vi inraikyava hia vaisi uaqiama mwataiharo Kotiva mwianra mwiva uaqia hi vaisirave qiananrove. Vaisi utaqitairo qovara hi inraikyava vaisi vara kyero uaqiama kyairave. ");
INSERT INTO omw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nkyi su nyaato kyuqe su nyaato vahirera, mwi quara okyara ntapihi kyeta riaate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesusiva mwitaa timwa kyero nraakye qora ntuvaantuama vuhua mwini kyero nraamwuqi uro varuvata mwia nraaqiaranramwuvanto Iesusiva vaakya tu quara okyarara mwia kyapara huvaro ");
INSERT INTO omw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iesusiva tiqaro, Qikye, nkyi su nyaatovata mpo? Nkyi su nyaatovanto hiave ntapihi riaiho? Kyaravanto qatinasairo vaisi utaqi vi inraikyava hia qio vaisi uaqiama mwataiharo Kotiva mwianra mwiva uaqia hi vaisivave, qiananro. ");
INSERT INTO omw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Vaisivanto kyara nraihanro hia mwi kyarava mwia vu nraatoqive mwutukyaqive viraitiro, qati vaisi raraqi ito vahiro qio mwiqitairo qatinani tumitarairave, tiro. Iesusiva mwi quara timwa nyiqanro mwi quaraqotairo nraakye qoravanto ekyaa kyara qio nraivaro Kotiva hiama nkyiara uaqia hia vaisihuave qiananrove, tura. ");
INSERT INTO omw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iesusiva mwitaa timwa kyero qua mpo tiqaro, Vu nraatoqinaa inraikyavanto, mwutukyaqinaa inraikyavanto, mwi inraikyava mwi inraikyava vaisi uaqiama kyaiharo Kotiva mwi vaisirara uaqia hi vaisirave tirave. ");
INSERT INTO omw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Vaisi vu nraato mwutukyaqitairo uaqia hi kyaiqara utuariva nriho. Vaisivanto nraakyevata api nrohiariva vu nraatoqitairo nriho. Mpuara varaarivavata mwiqitairo nriho. Vaisi ru kyaarivavata mwiqitairo nriho. Mpora nraata vaatiara nrohiarivavata mwiqitairo nriho. ");
INSERT INTO omw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Mpova hi inraikyarara mwutukya ntiraro varaariva vu nraatoqitairo nriho. Airi munimave mpo inraikyave vaterovata qaiqaa kyaatavata nraahu vararerave ti variariva vu nraato tuaraqitairo nriho. Unra qua qiarivave, hia nai mwamwantaqa kyuqema ntumwa quarivave, mpova hi inraikyarara vairiqa hiarivave, mpora nrutu vara mwataniqa hiqaro qiarivave, nte nronra vaisive qiarivave, api nrohianinranra nraahu riemwaqi quarivave, ");
INSERT INTO omw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ekyaa mwi inraikyava vaisi vu nraato mwutukyaqitairo nri ntero vaisi uaqiama kyaiharo Kotiva mwia kyaara mwianra uaqia hi vaisirave qiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesusiva mwitaa timwa kyero mwi mwatara kyero uro mpo mwatani Taiaavata Saitonivata vahu mwataraqaa varurama. Mwiva uro variro hia mpovanto ni taqaarive timwa kyero, nraamwu mpoqi varuvaro nraakye mpovanto mwiva varura vaakya ntapihi kyora. ");
INSERT INTO omw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ntapihi kyero nraakye mwia nraamwunraqi vaanavanto varu nraakyeva Iesusiva varuraqi uro ntero Iesusira nraaqani mwia kyuqusata tumu ntiro varura. ");
INSERT INTO omw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mwi nraakyeva nai mpo mwatanaava hia Iutaa mwatanaava, mwiva Siria mwata Ponisiaqi mwatatova varura. Mwi nraakyeva Iesusirara po kye tiro tiqaro, Ni naamwunraqitaira vaana titairaro qatinani nritaraarive, tiro. ");
INSERT INTO omw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nraakye mwiva mwitaa tuvaro Iesusiva nai timwa mwinro mpo quaqaa ntumwa kyero tiqaro, Qaqao, nte nraaqiara nraante kyara mwinrenrave. Nte nraaqiara kyara vara kyena vairi nyiankyorave, tiro. (Mwi quara okyara mwataamama vahiro: Iesusiva tiqaro, Kyai nte Iutaa mwatanaahua nraante kyaahaqa hiankye. Nte mpo mwatanaahua nraante kyaahaqa hiankyorave, tiro.) ");
INSERT INTO omw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tuvaro nraakye mwiva tiqaro, Nronrao, e qutaa qiararovata, vairivanto tainta mwemwaqi variqaro nraaqiaravanto kyara viti vaati nreqata kyaara nrainrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nraakye mwiva mwitaa tuvaro Iesusiva tiqaro, Kyuqema tira hiaro. E mwitaa qiarananra tina, nte vaana mwia titauqaro qatinani nritaraiho. I nraamwunravanto qio variho. Qio ena mwaatani quante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iesusiva mwitaa tuvaro nraakye mwiva nai mwaatani vuva uro ntero taqovaro vaanavanto mwia nraamwunraqitairo nritarero vuvaro mwi qiaatarava taintaqaa kyuqema vaite varurama. ");
INSERT INTO omw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesusiva Taiaani variro mwiaqaatairo Saitoninivata uro variro mwisairo vintantero kyauqurutana mwatukya vahunanivata vintantero mwisairo kyaarera nramanri Karirini tumu ntora. ");
INSERT INTO omw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mwini tumu varuvata mpo uhua vaisi mpo vitaqita uro Iesusiva varunani kyora. Mwia nraato tita vuvaro quavata hia ntapihi kyero tu vaisira vitaqita uro Iesusiva varunani kyeta Iesusirara po kye tita tiqata, Ena kyauqu mwiaqaa vatairaro kyuqema quarive, tita. ");
INSERT INTO omw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mwihua mwitaa tuvaro Iesusiva nraakye qoraqitairo vaisi mwia vitero uro nkyiariaraatana variqata Iesusiva nai kyauqu vukahiqo vaisi mwia nraatoqi veta vatero quaantu vihi kyero mwia mwaaqinriqaa vatero ");
INSERT INTO omw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","nyaamwuni taqeqaro mwia ua huvaro po timwa kyero nai quaqitairo tiqaro, Epatave. Qatua quante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mwitaa tuvaro mwia nraato tita vuva qamwanrama qatua vuvaro qio riero varuvaro mwia mwaaqinrivantovata qio vahuvaro qua ntapihi kyero ti varura. ");
INSERT INTO omw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mwitaa huvaro Iesusiva mwia nramwunaahuara kepukyaqama kyero tiqaro, Mwaa inraikyara taqaara hia mpohua timwa nyiate, tiro. Iesusiva mwitaa tuvata mwihua Iesusira qua hia riaraitita, mwi quara viti viri timwa nyiqita vura. ");
INSERT INTO omw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mwihua viti viri mwi quara timwa nyiqi vuvata mwi quara riohua qikye tita, kyauqu ntukikinraaqateta tiqata, Mwiva ekyaa kyaiqa kyuqema kyero vare varivave. Mwiva nraato tita quahua kyuqema kyaihata qio riaarave. Mwiva hia qua qiahua kyuqema kyaihata qio qua ti variarave, tura. ");
INSERT INTO omw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mwi entara nraakye qora airi kyaatavanto Iesusira taqarerata nrumu ntuvaantuama vita varura. Mwihua hia kyara mpoqianivata ntumwa taraitita, qati varuvaro Iesusiva nai nraaqiaranramwu nyaanrama kyero tiqaro, ");
INSERT INTO omw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Nte nraakye qora mwaa variahuara po tuqo. Mwihua taarampo enta ni vatama kyeta variqi viqata nkyiari kyara nramwa taiqa kyaavo. ");
INSERT INTO omw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nte mwihua nkyiari mwaatani sitaarita mwihua nraataa hiro vuqitairo nrivu nrivuhirata aanraqaa tumu ntivorave. Mpo hiahua nyianrasaitavata nriahuave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Iesusiva mwitaa tuvata mwia nraaqiara mwihua qaqao tita, Mwaa qumina mwukyauqaave. Taisaitave kyara varaananrave, tita. ");
INSERT INTO omw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tuvaro Iesusiva mwihua ntumwahiamwa hiro, Nkyenramwu nataama mperetive ntumwa taavo? tuvata mwihua tiqata, Mpereti 7 nramwu ntumwa tauro, tita. ");
INSERT INTO omw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mwihua mwitaa tuvaro Iesusiva nraakye qora ntuvaantua uhuara tiqaro, Mwatasata mwatakyaa quate, timwa kyero mpereti 7 nramwu vara kyero Kotirara kyuqeve timwa kyero, mwi kyarara nteqa kyero nai nraaqiaranramwu nyinro nraakye qora nyiate, tiro. Tuvata mwihua nraakye qora ntuvaantua uhua nyunra. ");
INSERT INTO omw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nyuvaro Iesusiva tavukyavata vatora vara kyero Kotirara kyuqeve timwa kyero tiqaro, Tavukyavata tukyama kyeta nyiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mwitaa tuvata mwihua nyuvata nraakye qoravanto qioqama kyeta nronra. Qio nreta viti vaati kyora mwia nraaqiaranramwuvanto utu kyeta ntutantuto tuara 7 nramwu piqa kyora. ");
INSERT INTO omw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mwi entara 4,000 nraakye qora airivanto mwi kyarara qio nronra. ");
INSERT INTO omw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Qio mwiaqaatairo Iesusiva nraakye qora sitero mwiva nai nraaqiaranramwu kyapata mpotuqi mwaanri ntero kyaarera nramanri qara varero Ntamanutaa mwatani viro. ");
INSERT INTO omw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Iesusiva Ntamanutaa mwatani vuva uro ntovata Parisi vaisinramwu Iesusiva hunani nri nteta Iesusira inronrama mwatarerata mwia mwataara hiqata taqaare timwa kyeta tiqata, E nronra kyaiqa tiri tivuqaa varairaqeta tire taqe iara qutaama Kotiva i titaiho qiare, tita. ");
INSERT INTO omw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mwihua mwitaa tuvaro Iesusira ua huvaro po tiro tiqaro, Mate mwaa varia nraakye qorahua nanraqamave tiqata nronra kyaiqa tinraamwu tairaqe tire i okyarara qutaave qiare ti variavo? Nte qutaa qianinra riaate. Mate mwaa entara variahua varivaqena nte hia ntena okyara mwihua nyaamwu teqana nronra kyaiqa vararerave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Iesusiva mwitaa timwa kyero qaqira mwihua mwini kyero mpotuqi mwaanrintero kyaareraqaama tero vutura hini tokyanianra viro. ");
INSERT INTO omw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kyaareraqaa vi varuvata Iesusira nraaqiaranramwuvanto mpereti taunru kyeta hia vararaitita, kuaiqia nraahu mpotuqi vatovaro ");
INSERT INTO omw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesusiva mpo quaqaa ntumwa kyero tiqaro, (Taupatai inraikyava mperetiqi viharo mperetivanto kyotairave.) Parisivantovata Herotivavata taupataira votima kyeta variavo. Nkye mwihua nyaatu aatu hiqata variate. ");
INSERT INTO omw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mwitaa huvata mwia nraaqiaranramwuvanto Iesusiva mpo quaqaa ntumwa kyero tu quara hia ntapihiraitita, nai timwa mwi nai timwa mwi hita tiqata, Nanra quave tiho? Mpereti hia varaunanra mwianra rieqarove mwitaa tiho? tita. ");
INSERT INTO omw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mwitaa ti varuvaro Iesusiva mwihua ti varu quara riero tiqaro, Nkye nanraqamave mpereti hia varaara kyaara airi qua ti variavo? Hiave nkyi su nyaatovanto ntapihi vihata ntapihi kyeta riaavo? Nkyi nyaato tita vihatave nkye hia ntapihi kyeta riaavo? ");
INSERT INTO omw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nkye su nyaato vataahua nkye hiave ntapihi kyeta rieta taqaavo? Nkye nte kyaiqa varaurara taunruve kyaavo? ");
INSERT INTO omw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nte 5,000 nraakye qora mpereti kyauquru nteqa kyena nyiavata nreta viti vaati kyora nataama tua nkye mwi entara piqa kyorave? tiro. Iesusiva mwitaa tuvata mwihua tiqata, Qio tire mwi entara tua 12 nramwu piqa kyaavananrave, tita. ");
INSERT INTO omw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mwihua mwitaa tuvaro Iesusiva qaiqaa tiqaro, Qio nte 4,000 nraakye qora mpereti 7 nramwu nyiavata nreta viti vaati kyora nataama tua nkye mwi entara piqa kyorave? tiro. Tuvata mwihua tiqata, Qio tire tua 7 nramwu mwi entara piqa kyaavananrave, tita. ");
INSERT INTO omw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mwihua mwitaa tuvaro Iesusiva tiqaro, (Nkye nte mwi kyaiqara varaurara ntapihi kyeta riaataara vaihata nkye taunru kyeta mpereti kuaiqia vare nrianranra airi qua ti variavo.) Nkyi su nyaato ntapihi virata ni okyarara riaataara vaihata nkye nataamaqitave ni okyarara hia ntapihi riaavo? tiro. ");
INSERT INTO omw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesusiva nai nraaqiaranramwu kyapata vuhua Vetasaitaani uro nteta mwini varuvata mpo uhua vu qipavu vaisira vita vareta Iesusiva varunani uro kyeta Iesusirara po tita tiqata, Vaisi mwaaqaa ena kyauqu vatairaro qio taqaarive, tita. ");
INSERT INTO omw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mwitaa tuvaro Iesusiva vu qipavu vaisira kyauqu tu varero vitaqiro uro mwatukya mwaaqani kyero mwini variqaro mwia vuqaa taara vihi kyero nai kyauqu mwiaqaa vatero mwia kyapara hiro tiqaro, Mpo inraikya qiove taqera hiaro? tiro. ");
INSERT INTO omw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Iesusiva mwitaa tuvaro vaisi mwia vu qauma ntapairi virera huvaro mwiva vutu taqero tiqaro, Nte vaisi taqe varuqata mwihua kyatari votima kyetama nrohi variavo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mwitaa tuvaro Iesusiva qaiqaa nai kyauqu mwia vuqaa vatovaro mwia vuvanto ntapairi vuvaro mwiva kyuqema kyero ekyaa inraikya taqero. ");
INSERT INTO omw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Vaisi mwiva ntapihi kyero taqovaro Iesusiva mwia titero tiqaro, Hia mwi mwatukyaraqi nrumu ntantera viraitira, ena mwaatani quante, tiro. Turama. ");
INSERT INTO omw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mwiaqaatairo Iesusiva nai nraaqiaranramwuvata uro Sisariaa Piripai qaumato vahu mwatukyaraqiara viro. Aanraqaa viqaro nai nraaqiaranramwu kyapara hiro tiqaro, Nraakye qoravanto nianra tavave timwa kyeqatave ti variavo? tiro. ");
INSERT INTO omw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mwitaa tuvata mwihua tiqata, Mpo hiahua iara Ioniva nramanri nyi varivave qiavata, mpo hiahua iara mwiva tiri haivaqava Iraisaavave ti variavata, mpo hiahua iara mwiva tiri haivaqava poropeti vaisi mpovanto qaiqaa qovarama viro nrohi variho ti variavo, tita. ");
INSERT INTO omw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mwihua mwitaa tuvaro Iesusiva mwihua ntumwahiamwa hiro tiqaro, Qio nkyenramwu mpo? Nkye nianra ta vaisiva varihove qiavo? tiro. Mwitaa tuvaro Pitaava tiqaro, E Karaisiva, Mesaiaavantove. E Kotiva titai vaisiva variaro, timwa kyeqatama tire varuro, tiro. ");
INSERT INTO omw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mwitaa tuvaro Iesusiva mwinramwuhuara kepukyaqama kyero tiqaro, Hiavatama mwi quara mpohua timwa nyiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mwitaa timwa kyero Iesusiva qua tohara tero vutu kyero nai nraaqiaranramwu mwiva nraakiara nai qutuaninranra timwa nyinro tiqaro, Nte mwatani mwatatai nraaqiarava variqana nriqa quani inraikyara airi vararerave. Nronra vaisivantovata, Kotira kyaiqa vara mwate varia vaisihua vunyaa vaisivantovata, nianra qumina vaisive timwa kyeta, ni qoririma matevarave. Mwihua mwitaa hiqatama ni ru kyaivaqena nte qutu vina taarampo enta varina qaiqaa qati siquaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesusiva mwi quara vutu kyero qoqaa timwa nyuvaro Pitaava Iesusira vita uhini kyero qaqao tiro, Qora quama tira hiaro, tuvaro ");
INSERT INTO omw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Iesusiva tuqasaa viro nai nraaqiaranramwu taqero Pitaara inronra hiro tiqaro, Saataanio, nyianrasata quante. Hia ni puqaa variante. E hia Kotiva riaintema kyera riaaro. E qumina vaisivanto riaintema kyera rie variaro, tiro. ");
INSERT INTO omw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iesusiva mwitaa timwa kyero nraakye qora ntuvaantua uhuavata nai nraaqiaranramwuvata nyaanrama kyero timwa nyinro tiqaro, Ni pataqiro nrianri vaisiva mwiva nai mwutukya vahianinra qaqira kyero vaisi rukyeta hirite kyatarira vara qu varero ni naakiara nriananrove. ");
INSERT INTO omw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nai mwatani qati varianinranra nraahu nronraqama kyero riaariva, mwi vaisiva ekyaarama qutu quananrove. Vaisivanto nianra riemwaqiro viqaro ni kyaiqa vararero ni qua riemwaqiro viqaro uro qutu quariva, mwi vaisiva ekyaa enta qati variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Vaisivanto mwatani variqiro viqaro ekyaa inraikya ntuvaantuama kyero mwiaqaatairo qutu viraro mwiva ntuvaantuama taani inraikyava nataama kyerove mwia kyaahaqa hiananrove? Hia mwi inraikyava mwia qio kyaahaqa hiananrove. ");
INSERT INTO omw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Vaisivanto qutu viro nanra kyoqaave mwinro qaiqaa qati variqiro quananrove? Hia mwiva mwi entara qio kyoqaa utu kyero qaiqaa qati variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mwaa entara mwatani varia nraakye qorahua uaqia hi kyaiqara utiqatama Kotira qaqira kyaavo. Vaisi mpovanto nianravata ni quaravata mpoqama kyero kyauruariva, mwi vaisiva variraqe nte mwatani mwatatai nraaqiarava variqana nraakiara nte tumuani entaraqaa naivata kyaurira inraikya vara mwianinrave. Mwi entara ni kora peqa okyaravanto niqaatairo itero ntuvaahe variraqena nyaamwunyaahua vatama kyena tumuaninrave. Mwi entara nte mwi vaisira naivata kyaurira inraikya vara mwianinrave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iesusiva mwitaa timwa kyero tiqaro, Nte qutaa qianinra riaate. Vaisi mponramwu mwaini mate mwaa sivita variahua hia qumina qutu vivarave. Kotiva nraakye qoraqaa kepukyaqama kyero ntaqikyiari entava nrianinra mwihua taqeta qutu vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iesusiva mwitaa tuvaro 6 enta nritarovaro mwiva Pitaaravata, Iemisiravata, Ioninravata, mwinramwuhua nraahu sita varero taaqi nronraqa nkyiariaraa varirerata vita. Mwini uro varuvaro mwihua suqaa Iesusira mwamwantavanto kyuqu viro vahuvaro ");
INSERT INTO omw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","mwia tuavaaqavantovata mpoqama kyero itero takyuqi varura. Hiama qio vaisi mpovanto hiqama tairaro mwitaama kyero takyu quananro. ");
INSERT INTO omw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mwitaama kyero mwia mwamwantavanto kyuqu viro vahuvata mwia nraaqiara taaramponramwuvanto variqata taqovata Iraisaakya Mosesikya mwihua haivaqahuatana qovarama vita variqata Iesusira vatama kyeta qua ti varura. ");
INSERT INTO omw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mwitanahua Iesusira vatama kyeta qua ti varuvaro Pitaava Iesusirara tiqaro, Mwaanra ti variara vaisio, kyuqemama tirenramwu i vatama kyeta mwaini nrunrahua varuro. E qiove tirera, tire haraara nraamwu taaramponramwu iara mpo, Mosesirara mpo, Iraisaarara mpoma kyeta hoqa nyataare, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mwihua mpoqama kyero nyaatuqa tovata varuvarora tiro, Pitaava nanra quave qianinrave tiro, mwi quara turama. ");
INSERT INTO omw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mwitaa tuvaro tonamwuvanto qovara hiro mwihuaqaa ntumwaqu kyovaro quavanto tonamwuqitairo tiqaro, Mwaa ni maaqu mwianra ni mutukya nti variva variho. Nkyenramwu mwia qua riaate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mwitaa tuvata mwia nraaqiaranramwuvanto qamwanrama kye tuqasaaqasa hiqata taqovaro hia mpovantovata Iesusira nraaqani varuvaro Iesusiva nraahu nanrianraa varura. ");
INSERT INTO omw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mwitaa huvata mwihua taaqi mwiaqaataita tumi varuvaro Iesusiva mwinramwuhuara kepukyaqama kyero tiqaro, Mateqa taqaa inraikyarara hia mpohua qamwanrama kyeta timwa nyiate. Nte mwatani mwatatai nraaqiarava nte nraakiara qutu vina qaiqaa qati sivina varianinraqaataita nkye qioma timwa nyiqita vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mwitaa tuvata Iesusiva tuntema kyeta hia mpohuavata timwa nyinraitita, nkyiari nraahu nai timwa mwi nai timwa mwi hita tiqata, Iesusiva nai qaiqaa siquaninranra tira nataa hi quarave tiho? tita. ");
INSERT INTO omw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mwitaa timwa kyeta mwihua Iesusira kyapara hita tiqata, Mwaanra okyara timwa nyi varia vaisihua tiri timwa timwita qiarave. Iraisaava tiri haivaqava mwiva nraante qovarama viro nri ntaananrove, ti variarave. Nanraqama mwihua mwitaa ti variavo? tita. ");
INSERT INTO omw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mwihua mwitaa tuvaro Iesusiva timwa nyinro tiqaro, Qio mwihua qutaa ti variarave. Iraisaava nraante ekyaa inraikya ntapihi kyero terama tarero nrianrivama variho. Ni mwatani mwatatai nraaqiarara mpo? Nanra qua nianra qara ntumwa tova vahirave? Nianra mwiva airi nriqa quani inraikyara varaqiro virata mwiaqaataita mwihua mwia qoririma mwatetama mwianra qumina vaisive tivarave tiro, qara ntumwa torave. ");
INSERT INTO omw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Qio nte nkyiara tiqana Iraisaava vaakya nrumu varurarama tuqo. Mwiva nrumu varuvata vaisi mponramwuvanto mwia nkyiari kyakya huntema kyeta mwia uaqiama mwatorave. Kotira mpukuqi qara ntumwa tova tiqaro, Nraakiara mwia mwitaa hirave tura mwivau mwia mwitaa hurave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mwitaa timwa kyero Iesusiva nai nraaqiara hininramwu kyonani tumu taqovata nraakye qora airivanto ntuvaantuama vita varuvata mwaanra okyara ti varu vaisihua mwini variqata Iesusira nraaqiaranramwu kyapata inronra hi varura. ");
INSERT INTO omw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mwihua tumu ntovata mwini ntuvaantuama vita varuhua qamwanrama kyeta Iesusira taqeta nrihanrama vita hiante uro mwia qua mwantovaro ");
INSERT INTO omw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesusiva nai nraaqiara hini mwinramwuhua kyapara hiro tiqaro, Nanra inraikya kyaarave nkye mwihua kyapata inronra hi variavo? tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mwitaa tuvaro nraakye qora utaqitairo vaisi mpovanto mwia timwa mwinro tiqaro, Mwaanra ti variara vaisio, vaanavanto ni maaqu utaqi variharo mwiva hia qio qua tihananra tina, nte e hiananrani vitena nruqo. ");
INSERT INTO omw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Vaanavanto ni maaqu ntavaaqavu kyero mwia mwataqaa tuta kyaiharo mwia nroqitairo taaraparavanto nrihanro nai vai kutiharo ekyaa mwia mwamwantavanto ntapihi viro kepukyaqama vivihirave. Nte i nraaqiarara vaana titaivaro nritarero quarive tuqata mwihua mwitaa hiare qiavaro vaanavanto hia nritare virave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Vaisi mwiva mwitaa tuvaro Iesusiva mwi quara riero tiqaro, Nkye mwaa entara varia nraakye qorahua Kotirara qumimaqama kyeta hia mwianra riaavo. Qikye, nkye ni pupohaira uti variavana nte nataama nanive nkyi kyapata varianinrave? Nte nataama entave variqana nkyi kyaahaqa hianinrave? Qio nraaqiara mwia vita vareta mwaini nriate, ");
INSERT INTO omw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","tuvata vite nruvaro vaanavanto Iesusira taqero nraaqiara mwia vara mwataqaa tuta kyovaro tuqasaaqasa hi varuvaro mwia mwamwanta ntirintiri hi varuvaro taaraparavanto mwia nroqitairo mpo uti varura. ");
INSERT INTO omw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mwitaa hi varuvaro Iesusiva mwia qora kyapara hiro tiqaro, Taire tohara kyerove mwitaa iho? tiro. Mwitaa tuvaro mwiva tiqaro, Nraaqiara pataru variharo mwitaamaqiro virave. ");
INSERT INTO omw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vaanavanto mwia rukyaankye tiro, mwia vara qiaqive nramanriqive tuta kyairave. E tiri qio kyaahaqa hirava varirera, tiriara po tiqara tiri kyaahaqa hiante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Mwitaa tuvaro Iesusiva qaqao tiro, E tiqara, E qio tiri kyaahaqa hiravave variaro qiananrave. E hiave ntapihira hiaro? Kotirara kepukyaqama kyero riaariva ekyaa kyaiqa qio varaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tuvaro nraaqiara mwia qova qamwanrama kyero tiqaro, Qio nte Kotirara riemwaqina vuva hiama qioqa iho. Evata ni kyaahaqa hiraqena nte Kotirara kepukyaqama kye riemwaqina quankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mwitaa tuvaro Iesusiva taqovata nraakye qora ntuvaantuama vuhua hisai hisai vaini nruvaro Iesusiva vaana inronra hiro tiqaro, E hia qua qiara vaanavave. E nraatora hiara vaanavave. E nraaqiara mwiqitaira nritarera quante. Hia qaiqaavata nraaqiara mwiaqi viqetera variante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mwitaa tuvaro vaana mwiva nronraqama kyero aakyara ntero nraaqiara mwia vara ntuqutuvaro ntirintirima eqero mwiva qutu vuhua nraantantamwa kyero ntumwa viro vahuvata nraakye qoravanto tiqatama, Mwiva qutuma viho, tita. ");
INSERT INTO omw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tuvaro Iesusiva mwia kyauquqaa tu varero mwia vara mwaamwianrama kyovaro qio qati siviro varura. ");
INSERT INTO omw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nraaqiara mwiva qio qati siviro varuvaro Iesusiva mwiaqaatairo uro nraamwuqi varuvata mwia nraaqiaranramwuvanto uro mwia tirema kye nanrianraa ntumwahiamwa hita tiqata, Tire vaana mwia titauraro hia nritarero virave. Nanraqamave tire hia qio mwitaa huro? tita. ");
INSERT INTO omw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mwihua mwitaa tuvaro Iesusiva tiqaro, Mwitaa hiani vaananra hia qio qati titaivaro nritarero quananrove. Kotirara aakyara nteqatama titaivaro qio nritarero quananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Mwiaqaatairo Iesusiva nai nraaqiaranramwu kyapata mwi mwatara kyeta Karirini vura. Mwini viqaro qua ntapihi kyero nai nraaqiaranramwu timwa nyianriva vahuvarora tiro, mpovanto tire quananra puaama kyero taqaankyo tiro uqeta kye sitero vura. Iesusiva nai nraaqiaranramwu timwa nyinro tiqaro, Mpovanto ni mwatani mwatatai nraaqiarara qovarama kyairata ni ntavaaqavuqita uro vaisi kyauquqi kyaivata ni ru kyaivaqena qutu vina taarampo enta vari kyenama qaiqaa qati siquaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iesusiva mwitaa tuvata mwia nraaqiaranramwuvanto mwi quara okyara hia ntapihi riaraitita, mwiva qua tura nraatu aatu hiqata hia mwi quara okyarara kyapara hura. ");
INSERT INTO omw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mwinramwuhua vuhua Kapenaamini uro ntovaro Iesusiva nraamwuqi uro variqaro nai nraaqiara mwihua kyapara hiro tiqaro, Nkyenramwu aanrani nriqata nanra qua timwa kyetave inronra hiavo? tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mwitaa tuvata mwihua hia qua tiraitita, tirema varura. Mwinramwuhua aanrani nriqata mwitaama tita, Tavave tirinramwuqitairo nronraqama viro vunyaa vaisivanto variananrove? tura. Mwitaa turara tita, mwihua kyauriqata hia Iesusira timwa mwita. ");
INSERT INTO omw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mwinramwuhua hia qua tuvaro Iesusiva mwatakyaa viro mwihua nyaanrama kyero timwa nyinro tiqaro, Kyai nte nronraqama quataa hiani vaisira okyara nkyi timwa nyiankye. Vaisi mpovanto nronraqama quataa hiariva hiama vuni uro variqaro nronraqama quananrove. Mwiva nronraqama quataa hiraro nraakiarani variqaro ekyaa nraakye qora kyaiqa vaisi variarivama nronraqama quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iesusiva mwitaa timwa kyero nraaqiara pataru vita kyero mwihua suqaa vatero mwia kyavuhu kyero tutero tiqaro, ");
INSERT INTO omw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Vaisi mpovanto nianra rieqaro nraaqiara mwataa hianinranra qamwateqaro kyuqema mwataariva mwiva nivatama mwitaama mataananrove. Mwiva mwitaa hiqaroma Kotiva ni titairavatama qamwata mwataananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Iesusiva mwi quara tuvaro Ioniva tiqaro, Mwaanra ti variara vaisio, tire taqauraro vaisi mpovanto i nrutu nteqaro vaana tite varirave. Mwi vaisiva hia tirivata i vataqiro nrohi variva mwitaa ihatara tita, tire mwianra eqaante timwa kyeta, mwia antua tauro, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mwitaa tuvaro Iesusiva qaqao tiro, Hia mwi vaisira antuaate. Mpovanto ni nutu nteqaro nronra kyaiqa varero mwiaqaatairo mwiva hia qamwanrama kyero nianra uaqia hi quara qiananrove. ");
INSERT INTO omw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mpovanto hia tiri nramwutaaqa hiariva varirera, mwi vaisiva tiri nramwunaavama variananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nte qianinra riaate. Nkyi nramanri nraataa hirata varivaro mpovanto nkyiara Iesusira nraaqiarave timwa kyero, nramanri nkyi nyianri vaisiva variraro Kotiva hia mwia taunru kyaraitiro, mwia kyoqaa kyuqema kyero mwiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Iesusiva mwitaa timwa kyero nraaqiara pataru vaakya kyavuhu kyero tutorara tiqaro, Nraaqiara mwaa voti hiariva ni qua riaariva variraro vaisi mpovanto nri ntero uaqia hi aanranra mwia nraamwutairera, mwia kyaara mwi vaisiraqaa qua nronraqama kyero vahiananrove. Vaisi mwia nruntaqi ori nronra kyaantaru kyero kyaareraqi tuto kyaivaro mwi vaisiva hia nraaqiara pata mwia uaqia hi aanranra nraamwutaataarave. ");
INSERT INTO omw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mwi quara rieqarama i kyauqu hinivanto uaqia hi kyaiqara uti varirera, mwia teqa kyera kyaante. Mwiaqaataira kyauqu kuaiqia nraahu vahiariva qioma nyaamwuni vira qati varinanrave. E kyauqu taaratana vahiariva uaqia hi kyaiqara uti variraro i qia iteqaro hia qipaaninraqi tuta kyaankyorave. ");
INSERT INTO omw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mwi mwataraqi mwimwivanto qutu quani mwamwantara qati nraahu nramwaqiro vi variananrove. Qiavanto iteqaro hiama qipa quananrove. ");
INSERT INTO omw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","I kyuqu hinivanto uaqia hi kyaiqara uti varirera, mwia teqa kyera kyaante. Mwiaqaataira kyuqu kuaiqia nraahu vahiariva qioma nyaamwuni vira qati varinanrave. E kyuqu taaratana vahiariva variraro i qia nronraqama kyero itaaninraqi tuta kyaankyorave. ");
INSERT INTO omw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mwi mwataraqi mwimwivanto qutu quani mwamwantara qati nraahu nramwaqiro vi variananrove. Qiavanto iteqaro hiama qipa quananrove. ");
INSERT INTO omw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","I vu hinivanto uaqia hi kyaiqara utirera, vauru kyaante. E vu kuaiqia nraahu vahiariva qioma Kotiva ntaqikyi mwatukyaraqi vira qati variqira vinanrave. I vu taaratana vahiariva uaqia hi kyaiqara utuqira viraro i qia nronraqi tuto kyaankyorave. ");
INSERT INTO omw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mwi mwataraqi mwimwivanto qutu quani mwamwantara qati nraahu nramwaqiro vi variananrove. Qiavanto iteqaro hiama qipa quananrove. ");
INSERT INTO omw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Hore aatai ntema kyero qiaqotairo ekyaa nraakye qora aataananrove. ");
INSERT INTO omw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Hore kyuqe inraikyave. Horevanto uaqiama viro hia qiakyaa hirera, hiama qio qaiqaa utu kyairaro qiakyaa hiananrove. Qio nkye hore kyuqera votima kyeta varivaro nkyi mwutukya qihaakya hirata nanrianra nanrianra kyuqe hiqata variate, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Qio Iesusiva mwi mwatara kyero Iutiaani vuva uro Iotaani nramanri qarero vutura hini tokyani vura. Iesusiva uro varuvata qaiqaa nraakye qora airivanto mwiva varunani ntuvaantuama vita varuvaro Iesusiva nauqaa hunte qaiqaa mwakyaakya mwihua timwa nyi varura. ");
INSERT INTO omw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Iesusiva mwini varuvata Parisi vaisinramwu mwiva varunani uro nteta Iesusiva api qua qiarive tita, mwihua mpo qua Iesusira kyapara hita tiqata, Qiove vaisivanto nai nraata qaqira kyaananrove? tita. ");
INSERT INTO omw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tuvaro Iesusiva nkyiari kyapara hiro tiqaro, Haaru nkyi haivaqava Mosesiva nanra quave nkyiara mwitaa mwitaa hiate tiqaro timwa torave? tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iesusiva mwitaa tuvata mwinramwuhua tiqata, Mosesiva mwataa timwa torave: Vaisi mpovanto nai nraata qaqira kyarero hiqaro qara mpo ntumwa kyero nai nraata mwinro tiqaro, Qio i qaqira kyauqo, timwa kyeroma titaananrove, turave. Mosesiva qua mwitaama kyero timwa torave, tita. ");
INSERT INTO omw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mwitaa tuvaro Iesusiva tiqaro, Mosesiva variqaro taqovaro nkyi haivaqahuamwanra mwutukyavanto kepukyaqa huvata hia mwihua Kotirara riorave. Mwitaa hi varuvarora tiro, Mosesiva mwi quara timwa torave. ");
INSERT INTO omw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","7","Tauraaqama kyero hia mwitaama vahurave. Tauraa Kotiva nyaamwuvata mwatavata utu kyero vatero tiqaro, Nte vaisivata nraakyevata utu kyena vataurara tiro, vaisivanto nai nrohua qohua kyero nai nraatantiri taaqau vita mwitana kuaa mwamwanta votima kyeta varivarave. ");
INSERT INTO omw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Mwitana hia mpo mwamwanta mpo mwamwanta variraitita, mwitana kuaa mwamwanta nraahuma varivarave, turave. ");
INSERT INTO omw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kotiva naivanto vaativata nraatavata vara kuaaqaa taaqau tairara tiro, hia mpovanto mwitanahua ntainra kyaarive, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Iesusiva mwitaa timwa kyero nraamwuqi uro varuvata mwia nraaqiaranramwu Iesusira mwi quara okyarara kyapara huvaro ");
INSERT INTO omw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iesusiva mwinramwuhua timwa nyinro tiqaro, Vaisi mpovanto nai nraata qaqira kyero mpo nraakye varaariva, mwi vaisiva qaraakya nraakyentiri nrohiqaroma mpuaraqama kyeroma mwikyantiri nrohiananrove. ");
INSERT INTO omw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mwia votima kyero nraakyevanto nai vaati qaqira kyero qaraakya vaisi varaariva, mwi nraakyevavata qaraakya qoraisi mwikyantiri nrohiqaroma mpuaraqama kyero nrohiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iesusiva varuvata nraakye qora mwihua nkyiari nraaqiara sita vareta Iesusiva nai kyauqu mwihuaqaa vataarive tita, Iesusiva varunani uro kyaare tuvata Iesusira nraaqiaranramwuvanto mwihua inronra hi varura. ");
INSERT INTO omw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mwitaa huvaro Iesusiva taqero nai nraaqiaranramwu nkyiari inronra hiro tiqaro, Qaqao, nkye nraaqiara mwihua qati kyaivata nte hunani nriate. Hia mwihua aanra antuaate. Kotiva ntaqikyiari mwatukyava mwi nraaqiarahua voti hiahua mwihua mwatukyama vahiananrove. ");
INSERT INTO omw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mwaa quara riaate. Vaisivanto hia nraaqiara votima kyero Kotira qua riaariva, mwi vaisiva hiama Kotiva ntaqikyiani mwatukyaraqi quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iesusiva mwitaa timwa kyero nraaqiara mwihua kyavuhu kyero tutero nai kyauqu mwihuaqaa vateqaro mwihua kyuqema nyatora. ");
INSERT INTO omw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesusiva aanrani virera huvaro vaisi mpovanto hiantero nrumu Iesusira kyapara hiro tiqaro, E mwaanra ti variara vaisiva kyuqevave. Nte nataa hi kyaiqara mpo kyaiqa mpo kyaiqa kyuqe kyaiqa Kotirani vara mwataaninraqaatainave nraakiara nte ekyaa enta qati variqina quaninrave? tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Mwitaa tuvaro Iesusiva tiqaro, E nanraqamave nianra vaisi kyuqevave qiaro? Kotiva nraahuma kyuqeva variho. ");
INSERT INTO omw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","E Kotiva timwa to quarara riaante. Mwia quavanto mwataama kyero vahirave: Hia mpora rukyaante. Hia mpora nraakyera nrohiante. Hia mpuara varaante. Hia unra qua qiante. Hia unra utu kyeqara mpova hiani inraikyara varaante. Ena nrohua qohua nyutu tuaahera nyataante, turave. Kotira quavanto mwitaama kyero vahirave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iesusiva mwitaa tuvaro mwi vaisiva tiqaro, Mwaanra ti variara vaisio, nte nraaqiarakyaa variqana nte mwi quara rieqana mwitaa mwitaamaqina nrunrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mwitaa tuvaro Iesusira mwutukyavanto mwi vaisirara vahuvaro mwia taqeqaro mwia timwa mwinro tiqaro, E kuaa inraikyara nraahu aara ntaaro. Uro ena vatena inraikyara mpohua nyinra munima vara kyera vehi nraakye qora ntainra kyera nyinranro nyaamwuni i kyoqaa vahiarive. Mwitaama kyera mwiaqaataira ni pataqira nriante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Iesusiva mwitaa tuvaro mwi vaisiva mwi quara riero inraanra viri ratero varura. Mwiva airi inraikya vatovara tiro, hia Iesusira qua riaraitiro, qaqira kyero mwia mwutukyavanto uaqia huvaro vurama. ");
INSERT INTO omw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Vuvaro Iesusiva nai nraaqiaranramwu vara ututuma kyero taqero tiqaro, Airi inraikya vatehua Kotiva ntaqikyi mwatukyaraqi mwukyaari tu kyeta vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mwitaa tuvata mwia nraaqiaranramwuvanto mwi quara rieta, Qikye tita, Iesusiva nataa hi quarave tiho, tuvaro Iesusiva qaiqaavata nraahu mwi quara tiqaro, Ni nraaqiaranramwu tuaavo, nraakye qoravanto Kotiva ntaqikyi mwatukyaraqi virerata mwukyaari tukyeqatama vivarave. ");
INSERT INTO omw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","(Kameri quara nronravanto nataama kyerove vuqa uvintaqi/iriraqi ntuqiaraananrove? Hia qio mwitaa hiananrove.) Qio kamerivanto vuqa uvintaqi/iriraqi ntuqiaraariva qio vahirarove, airi inraikya vataarivavata Kotiva ntaqikyi mwatukyaraqi qio quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iesusiva mwitaa tuvata mwia nraaqiaranramwuvanto mwia quara airi nraato tiqata qikye tita, Airi inraikya vataariva Kotiva ntaqikyinani hia qio virera, nai tarave Kotiva vitaananrove? tita. ");
INSERT INTO omw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mwitaa tuvaro Iesusiva mwihua itutuma kyero taqero tiqaro, Mwatani varihua nkyiari kepukyara hiama qio vivarave. Kotiva kyaahaqa hirata qio vivarave. Kotiva ekyaa kyaiqa vare varivave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mwitaa tuvaro Pitaava tiqaro, Taqaante. Tirenramwu i vataqita virera hiqata ekyaa inraikya mwini kyeta qatima nrunro, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pitaava mwitaa tuvaro Iesusiva mwihuara tiqaro, Nte qutaa qua qianinra riaate. Hia nte nkye kyaiqa varerara taunru kyaaninrave. Vaisi mpovanto nai nraamwu maatave, nai qata vakyaave, nai nrunra nrakyaave, nronra qorave, nai nraaqiarave, nai mwatave, mwini kyero nianra riero ni kyaiqara riero quariva, ");
INSERT INTO omw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mwi vaisiva mwia qiata kyoqaa vareqaro hia kuaa nani varaananrove. Mwiva mate mwaa mwataraqaa kyoqaa vareqaro airi nani varaananrove. Mwiva nraamwuve, qata vakyaave, nrunra nrakyaave, nrohuave, nraaqiarave, mwatave, mwi inraikyara mwi inraikyara airi inraikya varaananrove. Ni qua varaari vaisiva varirata mwia kyaara mwia uaqiama mwataivaro variananrove. Qio ni qua varaariva qutu viraro Kotiva mwianra ekyaa enta qati variqira quante qiananrove. ");
INSERT INTO omw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mate nraakye qora airivanto vuni variahua qakyo tumitareta nraakiaranima varivarave. Mate nraakiarani varihua qakyo nritareta vunima varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mwihua Ierusareminianra aanraqaa vi varuvaro Iesusiva nraante nanrianraa vuni vi varura. Mwiva vuni vi varuvata mwia nraaqiaranramwuvanto nraakiara nriqata airi vu nraato tuqita vi varuvata nraakye qora mponramwuvanto Iesusira vataqita nruhuavata aatu hiqata nri varura. Mwitaamaqi vi varuvaro mwiaqaatairo Iesusiva nai nraaqiara 12 nramwu nyaanrama kyero nkyiariaraa sita varero viqaro nraakiara naiqaa qovara hiani inraikyara qaiqaa timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Riaate. Tire Ierusaremini uro variarata vaisi mponramwuvanto ni mwatani mwatatai nraaqiarara ntavaaqavuqita uro kyaivata Kotira kyaiqa vara mwate vari vaisihua mwihua vunyaa vaisinramwuvantovata, mwaanra okyara ti varia vaisihuavata, mwihua nianra mwia ru kyaate timwa kyeta, ni pitaqita uro Romeni mwatanaahua kyauquqi tuta kyaivata ni ru kyevarave. ");
INSERT INTO omw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mwi mwatanaahua nianra raima mateta, niqaa quaantu vihiteta, kyaantaqo ni ntuqutu kye vateta, ni rukyaivaqena qutu quaninrave. Nte qutu vina taarampo enta varina qaiqaa qati siquaninrave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepetira mwaaqutana Iemisikya Ionikya Iesusiva varunani uro nteta Iesusira kyapara hita tiqata, Mwaanra ti variara vaisio, e mpo inraikya tiritana quara eo timwa kyera mwitaama timwa taanterama nrunro, tita. ");
INSERT INTO omw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tuvaro Iesusiva tiqaro, Nte nkyitana nataave hianinrave? tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tuvata mwitanahua tiqata, Nraakiara e kepukyavanto nraakye qoraqaa ntaqikyiqara nronra vaisi taintaqa mwatakyaa vira variqara e tiraro tiritanaqitairo mpovanto nronraqama viro i kyauqu kyaatutani mwatakyaa viro variraro mpovanto nronraqama viro i kyauqu kyaantaaqani mwatakyaa viro variarive. Tiretana mwianra rieqatama i kyapara huro, tita. ");
INSERT INTO omw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mwitaa tuvaro Iesusiva qaqao tiro, Nkyetana hia ntapihi kyeta vu nraato tiraitita, apiqama kyeta ni kyapara hiavo. Kaapuqitai nramanri nraantema kyena nte nriqa quani nramanrinra nraaninra, qiove nkyetanavata nrevarave? Nte nriqa quani inraikyara nramanri varaantema kye varaaninra, qiove nkyetanavata varevarave? tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tuvata mwitanahua tiqata, Tiretana qioma mwitaa hiananrave, tuvaro Iesusiva mwitanahua timwa nyinro tiqaro, Qutaama nte nramanri nraaninra nkyetanavata nrevarave. Qutaama nte nramanri varaaninra nkyetanavata varevarave. ");
INSERT INTO omw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ni kyauqu kyaatutanivata kyaantaaqanivata mwatakyaa vita vari vaisitanahuara hiama ni kyaiqa vaiho. Ni kova vaisi taaratana teramataihua, mwitanahuama mwiaqaa mwatakyaa vita varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mwitaa tuvata Iesusira nraaqiara hini 10 nramwuvanto mwi quara rieta mwia kyaara Iemisikya Ionikya inronra hura. ");
INSERT INTO omw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mwinramwuhua mwitanahua inronra hi varuvaro Iesusiva mwinramwuhuavata mwitanahuavata nyaanrama kyero eqaate tiro, Mpo mwatanaahua ntaqikyiqi vi varia okyarara nkye ntapihiarave. Mwihua qiata vaisivanto nritareta virito variqata mwi kyaiqara mwaa kyaiqara vara timwataate ti variarave. Mwihua nronra vaisivanto tiqata, Tire nronravanto varuro. Tiri qua nraahu riemwaqita quate, ti variarave. ");
INSERT INTO omw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nkyenramwu hia mwihua nraantantaate. Nkyiqitairo mpovanto nronra varirero mwiva nkyi kyaiqa vaisi nraante variro nraakiara nronraqama quananrove. ");
INSERT INTO omw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nkyiqitairo mpovanto nritarero vuni varirero qiariva, mwiva rupa tai vaisira votima kyero nkyini kyaiqa vara nyataananrove. ");
INSERT INTO omw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nte mwatani mwatatai nraaqiaravama varuqo. Ntevata hia nraakye qoravanto nini kyaiqa vara mataatera tumuvave. Nte nraakye qorani kyaiqa varaqina viqana airi nraakye qora kyaahaqama nyatena mwihuara qutu virerave timwa kyena tumuvave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iesusiva nai nraaqiaranramwuvata vuva Ierikoni uro ntero mwi mwatukyara nraatarero virero huvata nraakye qora airivanto mwia vataqita vi varuvaro vu qipa vu vaisiva Vatimiaasiva, Timiaasira mwaaquvanto variqaro mpo inraikya mpiate timwa kyeqaro nyaanru ti varu vaisiva aanra tokyani mwatakyaa viro varura. ");
INSERT INTO omw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mwiva mwini variqaro riovata mpo uhua tiqata, Iesusiva Nasaretinyaava nritare vi variho, tuvaro riero mwiaqaatairo mwiva paatiro Iesusirara aakyara ntero tiqaro, Iesusio, Ntevitira mwaaquo, qati nianra po kye timwa mataante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vu qipa vu vaisiva mwitaa tuvata airi nraakye qoravanto mwia inronra hita tiqata, Tirema variante, tuvaro mwiva hia mwihua qua riaraitiro, qaiqaa paatiro aakyara ntero tiqaro, Ntevitira mwaaquo, qati nianra po kye timwa mataante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mwitaa timwaqi vuvaro Iesusiva nrumu mwiaqaa siviro variro tiqaro, Nraanraivaro nrianrive, tuvata mwihua vu qipa vura nraanrama kyeta tiqata, Qio qamwateqara variante. Siquante. Mwiva ima nraanraiho, tita. ");
INSERT INTO omw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mwihua mwitaa tuvaro vaisi mwiva nai vaaqa qutora vara qatinani kyero siviro Iesusiva sivi varunani vuvaro ");
INSERT INTO omw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesusiva mwia kyapara hiro tiqaro, Nivanto i nataa hiarive tirave nrianro? tiro. Mwitaa tuvaro vu qipa vu vaisiva tiqaro, Mwaanra ti variara vaisio, e ni pu ntapairi kyaanterama nruqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mwitaa tuvaro Iesusiva mwia timwa mwinro tiqaro, Qio quante. E nianra mwiva qio ni kyaahaqa hiananrove qiararoma i vu ntapairi viho, tiro. Mwitaa tuvaro mwia vuvanto qamwanrama kyero ntapairi vuvaro mwiva qio taqero. Mwiva qio taqeqaro Iesusira vataqiro aanraqaa vurama. ");
INSERT INTO omw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iesusiva nai nraaqiaranramwu kyapata vuvaro Ierusaremi qaumato vahuvata mwihua Mpetapaasivata Mpetaani mwatukyanivata uro ntora. Mwatukya mwitanava Oripi taaqi mwemwaqi vahura. ");
INSERT INTO omw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Uro ntero Iesusiva nai nraaqiara taaratana sitero tiqaro, Nkyetana viti mwatukyaraqi vivaro nkyi suvanto vaakyama ntonki mpo kyaantaru tera taqaananrove. Mwia qaraakya ntonki hia vaisi mpovanto mwia mwoqaqa mwatakyaa viro varirave. Nkyetana uro mwia puaama kyeta mwia ntatu kyeta vitaqita nrumu ni mpiate. ");
INSERT INTO omw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mpovanto nkyitananra nanrave uti variavo tirera, nkyetana mwitaama mwia timwa mwiate. Tiri nronravanto ntonki mwianra tihatama nrunro. Pataqia vari kyero qaiqaa vara kyairaro nriananrove, qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iesusiva mwitaa tuvata mwitanahua mwatukya mwiqi uro nte taqovaro ntonkivanto aanraqaa qesana kyaantarutova varuvata mwitana mwia huvanti varuvata ");
INSERT INTO omw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","vaisi mponramwu mwini sivita varuhua tiqata, Nkyetana nanraqamave mwia huvanti variavo? ");
INSERT INTO omw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","tuvata mwitanahua vaakya Iesusiva tu quara timwa nyuvata qio vitaate tita. ");
INSERT INTO omw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tuvata mwitanahua qaraakya ntonki mwia vitaqita uro Iesusira mwunra. Uro mwita mwia nraaqiaranramwuvanto nkyiari vaaqa ntonki mwoqaqa vuti mwatovaro Iesusiva mwiaqaa mwaanrintero mwatakyaa viro variro aanraqaa vura. ");
INSERT INTO omw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aanraqaa vi varuvata nraakye qoravanto Iesusirara qamwateqata nkyiari tuavaaqa aanravau vuti mwatovata hini uhua aakyoqitaita kyatari mwanre teqaqita uro aanravau vuti mwatora. ");
INSERT INTO omw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mwitaamaqi viqata Iesusira vuni vi varu nraakye qorahuavata, mwia mwoqani nri varu nraakye qorahuavata, aakyara nteta tiqata, Kyai mwia nrutu tuaaheraare. Nronravanto nai nrutuqa nri vari vaisira kyuqema mwataiho. ");
INSERT INTO omw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tiri haivaqava Ntevitiva kepukyaqama kyero ntaqikyintema kyero mwivavata ntaqikyiqiro quaninranra tiro, Kotiva mwia kyuqema mwataiho. Ekyaa nyaamwunyaahua mwia nrutu tuaaheraate, tita. ");
INSERT INTO omw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mwitaa timwaqita vuvaro Iesusiva Ierusaremini uro ntora. Uro ntero Kotira nraamwu nronraqi verantero ekyaa inraikya mwiqi vahura taqamwa ntero, veva ntero entama virera huvaro nai nraaqiara 12 nramwu kyapata nrumu ntantero Mpetaanini vura. ");
INSERT INTO omw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mwia qanranraa mwinramwuhua Mpetaanisaita uto ntanteta nri varuvaro Iesusira nraataa huvaro ");
INSERT INTO omw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","mwiva taqovaro vutura mposata fiki, mwia tamwa nre varu kyatariva vahuvaro mwia mwanre airi vahura. Mwia tamwa vahirera hiqu kyena nraankye timwa kyero, Iesusiva taqovaro hia mwia tamwa rio entava vahuvarora tiro, mwanre nraahu ntora. ");
INSERT INTO omw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mwanre nraahu ntovaro Iesusiva fiki mwia inronra hiro tiqaro, Qio, nraakiara hia mpovantovata iqaatairo hiqu kyero nraanrive, tiro. Mwitaa tuvata mwia nraaqiaranramwuvata mwi quara riora. ");
INSERT INTO omw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Iesusiva nai nraaqiaranramwuvata vuva Ierusaremini uro ntero Iesusiva qaiqaa Kotira nraamwuqi vera ntero taqovata kyoqaa kyaiqa varo vaisihua mwiqi variqata kyoqaa kyaiqa vare varura. Mwitaa hi varuvaro Iesusiva mwihua vara veva mwaatani kyero, munima mwukyaari tuqasaaqi varu vaisihua taintavata vara rauru kyero, nyaamwa nyiqata munima vare varu vaisihua taintavata vara rauru kyero. ");
INSERT INTO omw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mwitaama kyero mwiva mwi nraamwunra aatareqanianra tiqaro, Mwaini hia aanravanto vaiho. Nkye kyoqaa mwitaa inraikya vareqata hia mwaini vitare nritare hiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iesusiva mwitaa timwa kyero mwiva qua timwa nyinro tiqaro, Kotira mpukuqi mwitaama qua qara ntumwa tova vahirave. Nraakye qora mpo mwatanaa mpo mwatanaahua ni nraamwuanra Kotirara aakyara nte varia nraamwunrave tivarave, turave. Nkye variavaro mwaa nraamwuva mpuara vaisivanto tuqeta kye ntuvaantua hia nraamwunra votima kyeroma vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Iesusiva mwitaa tuvata Kotira nraamwuqi variqata Kotira kyaiqa varo vaisihuavata, mwihua Iesusira qua rieta mwia kyaara Iesusira rukye aanranra puaa hi varura. Mwihua taqovata qati nraakye qoravanto Iesusiva tu quarara qamwateqata kyauqu ntukikinraaqate varuvata mwinramwuhua mwianra rieqata Iesusirara aatu hiqata varura. ");
INSERT INTO omw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Iesusiva Ierusaremini varuvaro enta hirera huvaro mwiva nai nraaqiaranramwuvata Ierusaremi kyero vurama. ");
INSERT INTO omw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mwia qanranraa toqaqi mwinramwuhua uto ntanteta nriqatama mwia nraaqiaranramwuvanto taqovaro fiki mwia kyauqu kyaaravantovata tuqavantovata aaharama viro vahuvaro ");
INSERT INTO omw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pitaava Iesusiva mwi kyatarirara tu quara riemwa tero Iesusirara tiqaro, Qikye, mwaanra ti variara vaisio, taqaante. Fiki e inronrama taarava tamusama viho, tiro. ");
INSERT INTO omw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mwitaa tuvaro Iesusiva mwinramwuhua timwa nyinro tiqaro, Nte qianinra riaate. Nkyenramwu Kotirara kepukyaqama kyeta riemwaqita nrohiate. ");
INSERT INTO omw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nkyenramwu mwitaamaqi viqata mwaa taaqirara tiqata, Tumitarera kyaareraqi ntumwa quante, tivarave. Mwitaa tiqata hia taara nraato tiraitita, qutaaqama mwitaa hiananrove tivera, Kotiva nkyinramwu kyaahaqa hiraro taaqivanto tumitarero kyaareraqi ntumwa quananrove. ");
INSERT INTO omw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nte mwianra rieqanama nkyiara mwitaa tirerave. Nkye mpo inraikya vararerata Kotirara aakyara nteqata qutaama mwi inraikyara ni mpiananrove tiqatama nkye mwi inraikyara mpo inraikya mpo inraikya qio varevarave. ");
INSERT INTO omw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nkye sivi variqata Kotirara aakyara nteqatama mpovanto nkyi uaqiama nyataani quava vahirera, nkye mwi quara hia riemwaqi viraitita, mwi vaisira qua taunru kye qaqira kyeta Kotirara aakyara qiate. Nkye mwitaa hivaro nkyi sova nyaamwuni variva nkye uaqia hi kyaiqara uti quaravata qaqira kyero taunru nyataananrove. ");
INSERT INTO omw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nkye hia mpohuaqa qua vahira qaqira kye taunru kyaivera, nkyi sova nyaamwuni variva hiama nkyitaqaavata qua vahianinra qaqira kyero taunru kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iesusiva mwitaa timwa kyero nai nraaqiaranramwuvata uto ntero Ierusaremini uro varura. Iesusiva qaiqaa Kotira nraamwu nronraqi vera ntero nrohi varuvata Kotira nraamwuqi variqata Kotira kyaiqa vara mwate varu vaisihua mwihua nronra vaisinramwuvata, mwaanra okyara ti varu vaisihuavata, Iutaa nronra vaisivata, mwihua Iesusiva hunani uro nteta ");
INSERT INTO omw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Iesusira mwia inronra hita tiqata, E ta vaisiva variqarave mwaa kyaiqara vare variaro? Tava i nronraqama kyaiharave e mwaa kyaiqara vare variaro? tita. ");
INSERT INTO omw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mwihua mwitaa tuvaro Iesusiva nkyiari timwa nyinro tiqaro, Kyai nte nraante nkyi kyaparama nyataarita nkye nte qiani quara qio timwa mpivera nte ntena nronraqama vina variqana mwaa kyaiqara varaaninranra nkyi timwa nyiankye. ");
INSERT INTO omw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tava Ioninra nronraqama kyovarove mwiva nraakye qora nramanri nyunrave? Kotivave iho, qati vaisivantove iho? Nkye ni timwa mpivaqena riaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iesusiva mwitaa tuvata mwihua nkyiari kyapara hita tiqata, Tire nanra quave qiananrave? Mate tire tiqata, Kotiva Ioninra nronraqama kyorave, qiarera, Iesusiva tiriara, Nkye nanraqamave Ioninra quara hia qutaave qiavo? qiananrove. ");
INSERT INTO omw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Qaiqaa mate tire tiqata, Vaisivanto nraahu Ioninra nronraqama kyorave, qiarera, mwi quavavata hia qioqa hiananrove, tura. Qati nraakye qoravanto Ioninranra Kotira qua qovarama kyo vaisivave turara tita, mwihua qati nraakye qora nyaatu aatu hiqata hia mwitaa tita. ");
INSERT INTO omw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mwihua mwitaa timwa kyeta mwiaqaatai Iesusirara tiqata, Nai tava Ioninra nronraqama kyorave? Hia tire ntapihunanrave, tita. Mwihua mwitaa tuvaro Iesusiva mwihuara tiqaro, Nkye mwitaa qiavana nte nina nronraqama kyaihana mwaa kyaiqara vare varurara hia nkyitavata timwa nyianinrave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesusiva mwitaa timwa kyero mpo quaqaa ntumwa kyero mwihua timwa nyinro tiqaro, Vaisi mpovanto uaini vara tutero mwia vara ututu tutukya ratero mwata quvu kyero uaini tatianinra ututero haraara nraamwu mponta vaimwanraanra nraamwu hoqa kyero vatorave. Mwiaqaatairo nyianra mpo mwatani virero hiqaro mpo uhua timwa nyinro tiqaro, Nkye ni uaini aakyoqaa ntaqikyi mate varivaqe nte quankye, timwa kyero mwiva nyianra mpo mwatani vurave. ");
INSERT INTO omw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mwini uro varuvaro uaini hiqu entava nri ntovaro mwiva nai kyaiqa vaisi mpo titero tiqaro, E uro ni aakyoqaa ntaqikyi mate varihua tiratama uaini ninanivata hiqu kye mataate, turave. ");
INSERT INTO omw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mwitaa tuvaro mwini vuvata mwia aakyoqaa ntaqikyi mwate varu vaisihua mwia kyaiqa vaisi mwia ntavaaqavu kyeta kyaamwuqotaita ntuqutu kyeta vateta, hia uaini hiqu kye mwia mwinraitita, qati titovaro nrumu ntantero vurave. ");
INSERT INTO omw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Qati nrumu ntantero vuvaro aakyo qova nai kyaiqa vaisi mpo titovaro vuvata mwia aakyoqaa ntaqikyi mwate varuhua mwia qiata raarahitima kyeta kyaurira inraikya mwunrave. ");
INSERT INTO omw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mwitaa huvaro aakyo qova nai kyaiqa vaisi mpo qaiqaa titovaro vuvata mwia rukyorave. Qio mwitaamaqi vita, hini nai kyaiqa vaisi titohua kyaamwuqotaita ntuqutu kyeta, hini rukyorara tuqo. ");
INSERT INTO omw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mwia kyaiqa vaisi taiqa kyovaro vaisi kuaiqia nraahu varura. Mwi vaisiva aakyo qora mwaaquvanto varuvaro mwia qora mwutukyavanto mwianra mpoqiavata vahu vaisiva varuvaro mwia qova mwiavata nraakiara ekyaara titero tiqaro, Mwihua ni mwaaqu taqeta nianra mwia mwaaquve tiqatama mwia kyuqema mwatevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mwitaa timwa kyero mwia titovaro mwini vuvata mwia aakyoqaa ntaqikyi varu vaisihua mwia mwaaqu taqeta, nai timwa mwi nai timwa mwi hita tiqata, Mwia qova qutu viraro mwaa vaisiva nai qora mwatavata, mwitaa inraikyavata, varaarivama variho. Nrivaqe tire mwia rukyaararo mwiva vararero hiani inraikyava tirini nraahu vahiarive, turave. ");
INSERT INTO omw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mwihua mwitaa timwa kyeta mwia mwaaqu ntavaaqavu kye rukyeta mwaaqani mwaati qaqira kyorave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iesusiva mwitaa timwa kyero mwihua kyaparama nyatero tiqaro, Mwihua mwitaa hurara tiro, aakyo qova nai mwaaqu rukyera kyaara nataave hiananrove? Aakyo qova nri ntero nai aakyoqaa ntaqikyi vaisihua ru taiqa kyero kyaata mpo vaisinramwuanra tiqaro, Nkyema ni aakyoqaa ntaqikyi mataate, qiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Iesusiva mwitaa timwa kyero mwiva mwihuara tiqaro, Nkye hiave Kotira mpukuqi mwaa quara kyaara ntumwa kyeta riaavo? Mwi quava mwataama tiro: Ori nraamwu hoqeqata ori mpo hia kyuqerave timwa kye qaqira kyaava, mwi oriva puhaqama viho. ");
INSERT INTO omw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kotiva mwi orira vara kyero nronraqama kyaihata tire mwia kyaiqa taqeta kyuqerave tunanrave, turave. Kotira mpukuqi mwitaama kye qara ntumwa torave. Nkye hiave mwi quara kyaara ntumwa kyeta riaavo? tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iesusiva mwitaa tuvata Iutaa nronra vaisinramwuvanto ntapihi riovaro Iesusiva uaini utaqaa ntaqikyi mwato vaisihuara tiqaroma mwihuaqaa ntumwa kyero tuvata mwihua Iesusira ntavaaqavu kyeta ko qiare tura. Mwitaa timwa kyeta nraakye qoravanto mwiqi ntuvaantuama vuhua tiri inronra hivorave tita, mwihua nraatu hiqata Iesusira kyeta vurama. ");
INSERT INTO omw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Iutaa vaisi nronranramwuvanto vari kyeta mwiaqaatai mwihua Parisi vaisi mponramwuvata, Herotira nramwunaahua mponramwuvata, siteta tiqata, Nkye Iesusira kyapara hivaro mwiva api qua tiraqe mwiaqa qua vataare, tita. ");
INSERT INTO omw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tuvata mwihua Iesusiva hunani uro nteta mwia kyapara hita tiqata, Mwaanra ti variara vaisio, tire taqaurara e kyuqe qua nraahu ti variaravave. E hia vaisi nraatu aatu hiraitira, nronra vaisiaravata, qumina vaisiaravata, kuaa qua nraahu ti variaravave. E vaisivanto Kotira vataqita vi aanranra ntapihi kyera timwa nyi variaro. Qio mwaa quara timwa timwinraqe riaare. Tire Kotira qua rieqata qiove tire Romeni mwatanaahua vunyaa vaisi Sisaara taakisi mwiananrave? (Mwi mwatanaahua hia Kotira qua riaahuave.) Mwia taakisi mwiananrave hiave mwiananrave? tita. ");
INSERT INTO omw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mwihua mwitaa tuvaro Iesusiva taqovata mwihua nroqaataita kyuqe kyuqe ti variqata mwihua su nyaatoqitaita Iesusira uaqiama mwatarerata uti varuvaro Iesusiva tiqaro, Nanraqamave nkyenramwu nivanto api qua qiarive tita mwitaa qiavo? Qio munima mpoku vara kyaivaqe nte taqaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mwitaa tuvata munima mwia kuaaru mwuvaro mwiva mwihua kyapara hiro tiqaro, Munima mwiaqaa tara virivata tara nrutuvatave vaiho? tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mwitaa tuvata mwihua Sisaarave tuvaro Iesusiva mwihuara tiqaro, Mwianra rieqatama nkye Sisaava hianinra nai mwita, Kotiva hianinra nai mwiate, tiro. Iesusiva mwitaa tuvata mwihua mwi quara rieta tiqata, Qikye, mwiva tiri qua nraatara kyero kyuqe qua tiho, timwa kyeta kyauqu ntukikinraaqate varura. ");
INSERT INTO omw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saitiusi vaisivanto Iesusiva varunani uro ntora. Saitiusi mwihua nkyiari mwaanra qua rieqatama mwihua tiqata, Vaisivanto qutu viro qio mwiva ekyaarama qutu viro hiama qaiqaavata siquananrove, ti varu vaisihua uro nteta ");
INSERT INTO omw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Iesusira kyapara hita tiqata, Mwaanra ti variara vaisio, tiri haivaqava Mosesiva mwaanra qua timwa timwiqanro mwitaa turave. Vaisivanto hia nraaqiara mwataraitiro, qutu viraro mwia qatavantove vakyaavave mwia nraata varatero nraaqiara mwata humwuanrama mwataananrove, turave. ");
INSERT INTO omw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tire qiarara e riaante. Haaru qate vakye 7 nramwu varurave. Mwihua sakyaava toharenaava nraakye varatero hia nraaqiara mwataraitiro, qutu vuvaro ");
INSERT INTO omw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","mwia qata mwia nanaava mwia nraata varatero mwivavata hia nraaqiara mwataraitiro, qati variqiro viro qutu vurave. Mwiva qutu vuvaro mwia qata mwia nanaava nraakye mwia varatero hia nraaqiaravata mwataraitiro, qutu vuvarave. ");
INSERT INTO omw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Qio mwitaamaqi vita ekyaa mwinramwuhua nraakye mwia varateta hia nraaqiaravata mwataraitita, ekyaa qati nraahu qutu vurave. Qutu vuvaro nraakiara nraakye mwivavata variro qutu vurave. ");
INSERT INTO omw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nraakiara nraakye qora qaiqaa qati sivita vari entaraqaa mwi nraakyeva tara nraatave variananrove? Mwiva qati varu entara qoraisi 7 nramwu vara torave, tita. ");
INSERT INTO omw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Saitiusi vaisinramwuvanto mwitaa tuvaro Iesusiva nkyiari timwa nyinro tiqaro, Nkye Kotira qua qara ntumwa tora hia ntapihi kyaahuave. Nkye Kotira kepukyavata hia ntapihi kyaahuave. Qutaara hia ntapihi kyaahuara tita nkye api qua ti variavo. ");
INSERT INTO omw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nraakiara nraakye qora qutu vihua qutu viraqitaita qaiqaa sivita qati variqita vi entara hiama nraata vaati vare okyarava vahiananrove. Mwihua nyaamwunyaahua votima kyetama varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iesusiva mwitaa timwa kyero mwiva tiqaro, Nraakye qora qutu vihua qati sivirara nte nkyi kyapara hirerave. Nkye hiave Kotira mpukuqi Mosesiva mwaa quara qara ntumwa tora kyaara ntumwa kyeta ntapihi riaavo? Kotiva mwitaa turave. Nte mwanriqa Kotivave. Nte i haivaqara Evarahaamunraqaa ntaqikyina, Aisaakiraqaa ntaqikyina, Iaikopuraqaa ntaqikyuvave, turave. ");
INSERT INTO omw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Qio riaate, Kotiva mwanriqavanto hia qutu viro taiqavi inraikyaraqaa ntaqikyi varivama variho. Nraakye qoravanto qaiqaa qati sivi okyarara nkyi su nyaatovanto hia ntapihi vihata api rieqata ti variarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iesusiva Saitiusi vaisi kyapata qua ti varuvaro mwaanra okyara ti varu vaisiva uro variqaro riovaro Iesusiva Saitiusi vaisi qua nraatara kyeqaro kyuqe qua nraahu ti varuvaro mwi vaisiva Iesusira kyapara tiro tiqaro, Kotiva qua timwa taiva nanra quavantove vuni vahi quava vaiho? tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tuvaro Iesusiva mwia timwa mwinro tiqaro, Mwaa quava vuni vahi quavama vaiho. Mwataama qara ntumwa torave: Nkye Isareri mwatanaahua riaate. Tiriqaa ntaqikyi variva Kotiva mwanriqa kuaiqiavanto variho. ");
INSERT INTO omw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ekyaa ena mwutukyaqitairave, ekyaa ena mwanraquraqitairave, ekyaa ena vu nraatoqitairave, ekyaa ena kepukyaqotairave, Kotirara nraahu mwutukya vahirara variante, turave. ");
INSERT INTO omw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mwi quava vaiharo mwia nraakiara okyara qua mpo vaiho. Mwitaama tiro: Enanra mwutukya vataarantema kyera ena henanranravata mwutukya vahirara variante. Qio mwi quatanava vuni vahi quatanavama vaiho. Hia mpo quavanto mwi quatana nraatara kyairave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iesusiva mwitaa tuvaro mwaanra okyara ti varu vaisiva tiqaro, Mwaanra ti variara vaisio, e kyuqema kyera ntapihima qiaro. E qutaama tiqara, Mwanriqa Kotiva kuaiqiavanto nraahu variho qiaro. Hia mwanriqa mpovantovata variho, qiaro. ");
INSERT INTO omw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","E qutaama tiqara, Vaisivanto mwutukyaqitairove, kepukyaqotairove, Kotirara mpoqama kyero mwutukya ntiraro variananrove. Vaisivanto nai henanranra nanrianra mwutukya vahintema kyero mwianravata mwutukya vahiarive, qiananrave. Mwi quatanava vuni vahiqaro hini qua nraatara kyairave. Mpo qua Kotira kyaiqa vara mwateqata quara rukyeta qia quara mwate varia quaravata, mwi quatanava nraatara kyairave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mwitaa tuvaro Iesusiva taqovaro vaisi mwiva kyuqema kyero tuvaro Iesusiva mwia timwa mwinro tiqaro, Kotiva iqaa ntaqikyiariva i qaumatoma vaiho, tiro. Iesusiva mwitaa tuvata vaisi kyaatavantovata Iesusiva tiri qua nraatara kyaankyo tita, hia Iesusira qaiqaavata nrumu mpo qua mpo qua kyapara hura. ");
INSERT INTO omw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesusiva Kotira nraamwuqi variqaro qua timwa nyiqiro viro tiqaro, Mwaanra okyara ti varia vaisihua tiqatama, Kotiva titaariva Mesaiaavanto Ntevitira okyara kuaa okyara mwiqinaa vaisivantoma variananrove, qiarave. Mwihua nataama kyeta mwi quara ntapihi kyetave mwitaa tivarave? ");
INSERT INTO omw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Haaru Kotira mwanraquravanto kyaahaqa huvaro Ntevitiva nai mwitaa turave: Kotiva ni nronra vaisiara tiqaro, E nritarera ni kyauqu kyaatutani mwatakyaa vira variraqena nte i nramwutaahua ru taiqa mwataarira mwihuaqaa kyuqu ntamwa tera variante, turave. (Sng 110:1) Ntevitiva mwitaa turave. ");
INSERT INTO omw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ntevitiva Mesaiaavanto qovara hianinranra tiqaro, Mwiva ni nronra vaisive, turave. Ntevitiva mwitaa turara tiro, nataama kyerove Mesaiaavanto Ntevitira nraisi qio variananrove? tiro. Iesusiva mwitaa tuvata qumina nraakye qora airivanto ntuvaantuama vita varuhua mwia qua rieqatama qamwateqata varura. ");
INSERT INTO omw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesusiva qua timwa nyiqiro viro tiqaro, Vaisi mponramwu mwaanra okyara ti variahua, nkye mwihuara rauriqata variate. Nraakye qoravanto mwihua tiri taqeta qua mwanteqata qamwata timwataate tita, mwihua mpuahaa tuavaaqa kyuqera utu vareta nraakye qora suqaa maaketiqi nrohi variarave. ");
INSERT INTO omw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mwihua mwaanra nraamwuqi vera nteta uaqia hi taintara qaqira kyeta, kyuqe taintaqaa nraahu mwatakyaa vita variarave. Mwihua omwata nraanraqaa variqata mwihuara nronra vaisive qiate tita, uro vaisi nronravanto mwatakyaa vita variaraqaa mwihuavata mwatakyaa vita variarave. ");
INSERT INTO omw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mwihua tetoqa varia nraakyehua nraamwuve mpo inraikyave vataara mpuara vareta tiqata, Mpohua tire qora inraikya utunanra taqeta tiriara uaqia hia vaisihuave tivorave, tita mwihua nraakye qora suqaa variqata Kotirara mpuahaama kyeta aakyara ti variarave. Qikye, mwia kyaara mwihuaqaa qua nronraqama kyero vahiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kotira nraamwuqi taqu mpo vahuvata mwiqi nraakye qoravanto Kotira kyaiqara rieqata munima kye varura. Qio Iesusiva qua taiqa kyero uro taqu mwia tataaqa mwatakyaa viro variqaro nraakye qoravanto munima taqu mwiqi kyeqata vi varuvaro Iesusiva taqe varura. Mwiva taqovata airi inraikya vatohua munima airi mwiqi kyora. ");
INSERT INTO omw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kye varuvaro vehi tetoqa nraakyevantovata nri ntero munima patarutana nraahu taquqi kyora. ");
INSERT INTO omw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Munima pataqiarutana mwiqi kyovaro Iesusiva nai nraaqiaranramwu nyaanrama kyero timwa nyinro tiqaro, Taqaate, Vehi nraakye tetoqavanto kyai munimava airi inraikya vataahua airi munima kyaaravata nraatara kyaiho. ");
INSERT INTO omw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Airi inraikya vataahua nkyiari munima hini nraahuma taquqi kyaavo. Nraakye mwiva vehi variqaro nai vatai munimanra ekyaama kyaiho, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesusiva Kotira nraamwuqitairo veva ntovaro mwia nraa qiara mpovanto tiqaro, Qikye, mwaanra ti variara vaisio, taqaante. Mwaa nraamwuva kyuqe hi nraamwunrave. Mpo ori mpo ori nronraqotaita vara kyeta hoqataa nraamwuva kyuqe nraamwuma vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mwitaa tuvaro Iesusiva mwia timwa mwinro tiqaro, Mate e nronra nraamwu taqe variaro. Nraakiara ori naiqaa naiqaa taaqautaava hia mwitaama kyero vahiananrove. Mwaa nraamwunra ntapairiqata mwia venta kyaivaro tumu ntiraro orivanto ntuvuraa vura hiro api mpona mpona vahiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mwitaa timwa kyero Iesusiva uro Oripi taaqiqaa mwatakyaa viro varura. Oripi taaqivanto mwaa hini vahuvaro Kotira nraamwuvanto vutura qarahi hini vahura. Mwitaama vahuvata Pitaavavata, Iemisivavata, Ionivavata, Enturuvavatama kyeta mwinramwuhua nraahu vuhua Iesusiva varunani uro nteta mwia kyapara hita tiqata, ");
INSERT INTO omw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","E vaakya Kotira nraamwuanra qiananra taireve qovara hiananrove? Nanra nanra inraikya qovara hiraqeve tirenramwu mwi inraikyaraqaa apeqama kyeta taqeqata mwi entava nrianriva qaumatoqa iho qiananrave? E tiri timwa timwinraqe riaare, tita. ");
INSERT INTO omw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mwihua mwitaa tuvaro Iesusiva tiqaro, Mpovanto mwi quara nkyi api timwa nyiankyo tita, rauriqatama variate. ");
INSERT INTO omw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nraakiara airi vaisivanto nri nteta ni nutu nteta tiqata, Kotiva ni titaihana nruvave. Nte mwaa mwivave, tivata airi nraakye qoravanto mwihua unra quara qutaa quave tivarave. ");
INSERT INTO omw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nkye varivaro nronraqama kye ntaqi quava nraaqasairove mponasairove nrinrata hia aatu hiate. Ntaqi inraikyava qovara hiananrove. Mwitaa hirata nkye mwianra rieqata mwi entava ekyaara enta nri ntaiho tivorave. ");
INSERT INTO omw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mpo mwatanaavanto mpo mwatanaanravata ntaquananrove. Qiata vaisi mpovanto nai hena qiata vaisi mpovata ntaquananrove. Mpo mwata mpo mwata mwaturavanto tuananrove. Mpo mwata mpo mwata kyarara aarantevarave. Mwi inraikyava mwi inraikyava qovarama virata hia ekyaara enta nri ntaiho qiate. Qakyo atura ntumwa kyero nraaqiara mwataariva vaiharo vuni pataqia toharaintema kyero, muaanra ntaani entava qati toharama taiho, qiate. ");
INSERT INTO omw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mwi entara aitutumaqi vita rauriqata variate. Mpo hi vaisihua nkyi ntavaaqavuqita uro nkyiari kaanasoriqaa kyeta, nkyiqa qua vatevarave. Nkye mwaanra nraamwuqi varivata nkyi kyaamwuqo ntuqutu kyeta vatevarave. Nkye ni kyaiqa vare varivata mwia kyaara nkyi ntavaaqavuqita uro kamaninra nronra vaisi suqaave, vunyaa vaisinramwu suqaave, kyaivata mwi entara nkye ni qua ntapihi kye timwa qovarama kyevarave. ");
INSERT INTO omw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ni qua kyuqe qua ekyaa mpo mwatanaa mpo mwatanaahua timwa nyiqi vivata ekyaama riemwa ntevarave. ");
INSERT INTO omw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nraakiara mwihua nkyi ntavaaqavuqita uro ko tirera hivaro, hia nkyi kyuqu kyauqu ntirata nanra quave qiananrave qiate. Mwi entara hia nkyeta su nyaatoqitaita riemwa kyeta tiraitita varivaro Kotira mwanraquravanto nkyi kyaahaqa hiqaro mwi quara qiate tirata mwi quara nraahu qiate. ");
INSERT INTO omw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nraakiara vaisivanto nai qatave nai vakyaarave qovarama kyairata ru kyevarave. Mwia qova nai nraaqiara qovarama kyairata ru kyevarave. Nraaqiaravanto nkyiari nyohua sohua nramwutaaqa hiqata ru kyaate tivata mwihua ru kyevarave. ");
INSERT INTO omw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mwi entara nkye ni nraakye qoravanto varivatara tita, mwia kyaara ekyaa qati nraakye qoravanto hia nkyiara mwutukya vahirata varivarave. Mwitaama mwataivarovata hia qoriri hiraitiro, kepukyaqama kyero variqi viro uro taiqa kyaani vaisira, mwiama Kotiva vitaananrove. ");
INSERT INTO omw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nraakiara nkye taqaivaro anoma kyero qora inraikyavanto qovarama viro hia mwianra variante qianinra mwinima mwiva siviro variananrove. Mwaa quara kyaara ntirava ntapihi kyera nraato tuante. Nraakiara mwi entara mwi inraikyava qovarama virata nraakye qora Iutiaani varihua sivita hianteta verara taaqiqaa quate. ");
INSERT INTO omw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mwi entara nraamwu qesana variariva hiama nraamwuqi vera ntero mpo inraikyavata vararaitiro, mwiva mpo inraikya mpo inraikya qaqira kyero qatima hiantero quarive. ");
INSERT INTO omw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mpovanto aakyoqi kyaiqa vare variariva hia nai vaaqa vararero nrumu ntantero viraitiro, mwiva mwia qaqira kyero qatima hiante quarive. ");
INSERT INTO omw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mwi entara nraaqiara tuaqahi nraakyehuavata, nraamwa nyi vari nraakyehuavata, hia kyuqema varivarave. Nte mwi nraakyehuara po tuqo. ");
INSERT INTO omw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Hia huari itaani entaraqaa aatu quaro tita nkye Kotirara aakyara tivaro huari itaani entara nyianrive. ");
INSERT INTO omw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Po, nraakiara mwi entara muaanra vahiariva nronraqama kyero vitarero vahirata nraakye qora hia kyuqema kyeta varivarave. Haaru Kotiva mwaa mwatara utu toraqaatairo mwitaa hi muaanrava hia qovara hurave. Nraakiaravata hia mwitaa hiani muaanrava qaiqaavata qovara hiananrove. ");
INSERT INTO omw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mwi entara mpuahaa enta vahiratavauma ekyaa nraakye qoravanto taiqa vivaro hia kuaiqiavantovata qati variananrove. Qio Kotiva nai kyaama tai nraakye qorahuara rieqaroma mwi entara vara qiquqama kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mwi entaraqaa nkyiara Kotiva titai vaisiva Mesaiaavanto mwainima variho, mwinima variho, tivera, hia mwihua quara qutaave qiate. Mwi entaraqaa vaisi mpovanto qovarama viro unra tiqaro, Nte Mesaiaavantove, tiraro mpo vaisivanto tiqaro, Nte Kotira qua qoqama kye varu vaisivave, qiananrove. Mwihua mwitaa timwaqi viqata airi unra vaisivanto qovarama vivarave. ");
INSERT INTO omw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mwihua qovarama vita unra kyaiqa varaqi viqata Kotiva nai kyaama tai nraakye qorahua mwihua tirinramwu quara qutaave tiqata api aanra quate tita, nronra kyaiqa varaqi vivarave. ");
INSERT INTO omw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mwi quara rieqatama mwi entaraqaa nkye rauriqata variate. Nkye hia mwi vaisihua quara qutaave qiate tina, nte mwaa entaraqaa variqana nraakiara qovarama quani inraikyarara nkyi timwa nyi varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Iesusiva mwitaa timwa kyero tiqaro, Nraakiara muaanra vahiani entava taiqa viraro mwi entaraqaatairo huarivanto qipa viraro toravantovata hia itairaro ");
INSERT INTO omw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","aahoquravantove, qovoravantove, tumu nti tumu nti hiraro nyaamwuni kepukya inraikya vahiariva ekyaa qakyaa qakyaa hiananrove. ");
INSERT INTO omw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mwi inraikyava mwitaa hirata ekyaa mwata maata varihua taqe varivaqe nte mwatani mwatatai nraaqiarava nyaamwusaina tonamwuqi tumuanrita ni taqevarave. Nte mwunruqama taari inraikyava mpoqama kyero itero takyuqiro ante anta/atipetipa hi variraqe nte kepukyavanto tumuaninrave. ");
INSERT INTO omw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nte tumiqana nyaamwunyaahua sitaarita mwihua mwatani uto hisai hisaita Kotiva nai kyaama tai nraakye qorahua ekyaa ntuvaantuama kyeta sitevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iesusiva mwitaa timwa kyero tiqaro, Nkye qaampuakyara rieqatama mwaa quara okyara ntapihi kyeta riaate. Mwi kyatariva tamwa riemwa taiqa kyero vahiro mwiaqaatairo qaraakya mwunri ntarero utihata nkye mwiaqaa apeqama kye taqeta tiqata, Huari nronra itaani entava qaumaqa iho, qiarave. ");
INSERT INTO omw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mwia votima kyeta, nraakiara qovara hiani inraikyarara tura, nkye mwiaqaa apeqama kye taqeta nianra tiqata, Mwiva tumuani entava qaumatoqa iho, tivarave. ");
INSERT INTO omw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nte qutaama tuqo. Mwaa mwataraqaa vari nraakye qorahua hia taiqa vivaro mwi inraikyara mwi inraikyarara tuva qovara hiananrove. ");
INSERT INTO omw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nyaamwuvantovata mwatavantovata taiqa viraro ni quavanto qati nraahu vahiqiro quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Iesusiva mwitaa timwa kyero tiqaro, Nte taireve, nanra huari vuqaave, tumuaninra? Hia vaisi mpovanto mwi entara ntapihirave. Hia nyaamwunyaahuavata mwianra ntapihiarave. Ntenavata mwatani mwatatai nraaqiarava variqana mwi entarara hia ntapihi kyaurave. Kotiva ni kova mwiva nraahuma mwi entara ntapihirave. ");
INSERT INTO omw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mwi entava nrianinra nkye hia ntapihiahuara tita, nkye taqe varita rauru kyeqa teramate variate. ");
INSERT INTO omw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mwi entava nrianinranra tirera nanra quaqaa ntumwa kyenave qianinrave? Mwaa quaraqaa ntumwa kyena tirerave. Vaisi nronravanto nyianrani virera hiro nai kyaiqa vaisinramwuanra tiqaro, Nte quarita nkye mwi kyaiqara mwi kyaiqara vare varivaqe nte uro ntantena nriankye, timwa kyero mpo kyaiqa mpo kyaiqa mwihua nyinro vaisi mpora tiqaro, E qesana variqara vaimwanraanra ntaqikyi variante, timwa kyero qio vurave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","(Iesusiva mwitaa timwa kyero nai nraaqiaranramwu timwa nyinro tiqaro), Mwi quara rieqatama nkyevata taqeqata variate. Taireve mwihua nronra vaisivanto nyianrasairo uro ntantero nriananrove? Enta hirera hianinranive? Enta mwutukyaqive? Kokoraaravanto nruqua qianinranive? Qaatata viraro toqaqive nriananrove? ");
INSERT INTO omw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mwiva qamwanrama nri ntero taqairata nkye vaite varivorave. ");
INSERT INTO omw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nkye mwianra rieqatama nte nkyinramwuanravata ekyaahuaravata mwitaama tina, Nkye taqe variqata variate tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mpo ihi mpo ihi mwi mwatanaahua nyaamwunyaava vekyahu nyatoraravata, hia kyoto mperetiraravata, rieqata mwi entaraqaa mwi kyarara nronra. Mwi entara mwi kyarara nreva taara enta qati vahuvata Kotira nraamwuqi Kotira kyaiqa vara mwate varu vaisihua mwihua vunyaahuavata, mwaanra okyara ti varu vaisihuavata, mwihua ntuvaantuama vita Iesusira ntavaaqavuqita uro rukyerara uqetakye qua tiqata ");
INSERT INTO omw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","mwitaama tita, Tirenramwu vekyahu nyato kyarara nraana entaraqaa Iesusira ntavaaqavu kyaararo nraakye qoraqitairo ntaqi inraikyava qovara hiankyorave, tura. ");
INSERT INTO omw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mwi entara Iesusiva Mpetaanini Saimoninra nraamwuqi uro varura. Tauraa mwi vaisira tauma rumpuaravanto utuvaro varu vaisira. Iesusiva mwi vaisira nraamwuqi uro kyara nre varuvaro nraakye mpovanto vera ntero Iesusira kyuqema mwatarero vahamwenra kyuqe mwunta vura, nronra munima kyora, ori taquqi varero uro taqu hiara kinta kyero Iesusira qiataqaa rauru kyero qumwatora. ");
INSERT INTO omw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mwia qiataqaa rauru kyero qumwatovata hini uhua nraamwu mwiqi varuhua mwi nraakyera nununrama mwateta/nriqi humumuse nai timwa mwi nai timwa mwi hita tiqata, Qaqao, nanraqamave mwitaama kyero vahamwenra mwia qumina taiqa kyaiho? ");
INSERT INTO omw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mwiva vahamwenra mwia nyinro nronra munima 300 kinaa vara kyero vehi nraakye qora nyiataarave, tita. Mwitaa timwa kyeta mwia kyaara mwi nraakyera inronra hi varura. ");
INSERT INTO omw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mwihua mwia inronra hi varuvaro Iesusiva tiqaro, Qati kyaivaro mwi nraakyeva variarive. Nanraqamave nkye mwia inronra hiavo? Mwiva mwitaa hiqaro ni kyuqema mataiho. ");
INSERT INTO omw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vehi nraakye qora mwihua mpo enta mpo enta nkyi kyapata variqi vivarave. Nkye mpo enta mwihua kyaahaqa hiataa hirata qioma kyaahaqa hivarave. Nte nraahuma hia nkyi kyapata airi enta varianinrave. ");
INSERT INTO omw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mwi nraakyeva taqaiharo mwi kyaiqava mwianra qioqa hirama varaiho. Nte qati variani entaraqaa mwiva nraante vahamwenra qumateqaroma ni quntamwa terara tera hi variho. ");
INSERT INTO omw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nte qutaa qua qianinra riaate. Nraakiara ni qua mwakyaakya ekyaa mpo mwatanaa mpo mwatanaahua timwa nyiqi viqata mwaa nraakyeva mate vahamwenra mwaa ni qu matai quaravatama timwa nyivata rievarave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iesusiva mwitaa tuvaro mwia nraaqiara 12 nramwuqitairo mpovanto Iutaasi Isikeriotiva mwiqitairo veva ntero Iesusira qovarama kyaani quara timwa nyinrenro vuva Kotira nraamwuqi Kotira kyaiqa vara mwate varuhua mwihua nronra vaisinramwu timwa nyuvata ");
INSERT INTO omw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","mwihua mwia quara qamwata kyeta tiqata, E mwitaa qiarata tire qutaaqama kyeta munima i mwinrenrave, tuvaro mwiaqaatairo Iutaasiva Iesusira mwihua kyauquqi kyaani aanranra puaa hi varura. ");
INSERT INTO omw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mpereti hia kyotorara nro entanramwuva nruvata toharo entaraqaa sipisipi nraati rukyo entaraqaa mwia nraaqiaranramwuvanto Iesusira kyapara hita tiqata, Taraqive tire uro terama mwataarara e vekyahu nyato entarara rieqarama mwi kyarara nrenanrave? tita. ");
INSERT INTO omw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tuvaro Iesusiva nai nraaqiara taaratana sitero tiqaro, Nkyetana Ierusaremi mwatukya nronraqi vivaro vaisi mpovanto nramanri taqu kyaqa varero nrianriva nkyitana qintorama kyairata mwia vataqita vivaro ");
INSERT INTO omw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mwiva nraamwuqi vera ntairata nkyetanavata mwiqi vera nteta nraamwu qorara mwitaama qiate, Mwaanra ti vari vaisiva iara tiqaro, Ta rumunraqive nte ntena nraaqiaranramwu kyapata vekyahu nyato kyarara nraaninrave tiho, qiate. ");
INSERT INTO omw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nkyetana mwitaa tivaro mwiva nkyitana rumu nronra verato vahi rumunra taintavata mwiqi teramataiharo vahiraqi nyaamwutairata qio rumu mwiqi kyara terama taate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iesusiva mwitaa tuvata mwitanahua uro mwatukya nronraqi taqovaro ekyaa inraikyara tu quava avuqavuma kyero mwivau vahuvata mwitanahua vekyahu nyato kyarara terama kyeta mwatora. ");
INSERT INTO omw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Terama kyeta mwatovaro entama vuvaro Iesusiva nai nraaqiara kyapata nruva nraamwu ");
INSERT INTO omw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","mwiqi kyara nre variro tiqaro, Nte qianinra riaate. Nkyiqitairo mpovanto nramwutaahua suqaa ni qovarama kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mwitaa tuvaro mwia nraaqiaranramwu mwutukyavanto uaqia huvata mwihua kuaiqia kuaiqiavanto Iesusira kyapara hita tiqata, Nianrave tira hiaro? Nte hia mwivave. Nte hia mwivave, timwaqita vita. ");
INSERT INTO omw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mwitaa tuvaro Iesusiva timwa nyinro tiqaro, Nkyi 12 nramwuqitairo mpovanto nai mpereti vara kyero ni vatama kyero tanuqi mwaati ntamwa kyero nre variariva mwi vaisivama ni qovarama kyaananrove. ");
INSERT INTO omw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ni mwatani mwatatai nraaqiarara mwitaama kyeta rukyerara haaru qara ntumwa torave. Mwi quava qutaa mwivauma vahiananrove. Ni mwatani mwatatai nraaqiarara qovarama kyaani vaisirara nte po tuqo. Mwia nrova hia mwia mwata kyaataara mwia mwata kyairave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mwitaa tuvata kyara nre varuvaro Iesusiva mpereti vara kyero Kotirara kyuqeve timwa kyero, nteqa kyero nai nraaqiaranramwu nyinro tiqaro, Mwaa kyarara varaate. Mpereti mwaa ni mamantama iho, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mwitaa timwa kyero mwiva uaini kaapu vara kyero Kotirara kyuqeve timwa kyero, viti nyuvata ekyaahua kaapu mwiqitaita nronra. ");
INSERT INTO omw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nreta varuvaro Iesusiva tiqaro, Nramanri mwaa ni nraanrema iho. Kotiva nraakye qora kyapata kuaaqi kuairama viro varirero qaraakya qua vatarerove. Mwi quava kepukyaqama quarive tiro, ni nraanrevanto mwi quara kepukyaqama kyaananrove. Ni ru kyaivaro ni nraanrevanto tuminro airi nraakye qora kyaahaqa hiananrove. ");
INSERT INTO omw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nte qianinra riaate. Nte mate mwaa entaraqaataina tohara kyena hia uaini nranraitina, qati variqi vina nraakiara Kotiva ntaqikyianinraqi variqana mwi entaraqaa qaraakya uaini nraaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iesusiva mwitaa timwa kyero nai nraaqiaranramwu kyapata Kotirara ihi timwa kyeta veva nteta Oripi taaqiqaa vurama. ");
INSERT INTO omw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mwinramwuhua mwini varuvaro Iesusiva timwa nyinro tiqaro, Nkyenramwu ni kyeta ntuqeqaa hita vivarave. Kotira mpukuqi qara ntumwa to quava qutaa mwivauma vahiananrove. Mwitaama tiro: Sipisipiqaa ntaqikyi vaisira Kotiva rukyairata sipisipi mwihua nkyiariara nkyiariara mpona mpona vivarave, turave. ");
INSERT INTO omw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Qio nraakiara ni qati vara sivuma kyairaqe variqana nkyi suni nte nraante Karirini virerave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mwitaa tuvaro Pitaava qaqao tiro, Ekyaa mwinramwuhua i kyeta aatu ntuqema kyeta vivaqevata nte nraahu ivatama kyena mwaini varianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pitaava mwitaa tuvaro Iesusiva tiqaro, Nte qianinra riaante. Mate entaqi kokoraaravanto hia taara nani nruqua tirara e taarampo nani nianra tiqara, Hia mwia ntapihurave, tinanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Iesusiva mwitaa tuvaro Pitaava kepukyaqama kyero qaqao tiro, Hia iara tiqana, Nte hia ntapihurave, qianinrave. Ivatamakye ni rukyaivaqenavata nte hia mwitaa qianinrave, tiro. Pitaava mwitaa tuvata Iesusira nraaqiara hini mwihuavata kuaa qua mwia nraahu tura. ");
INSERT INTO omw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mwiaqaatairo Iesusiva nai nraaqiaranramwuvata vuva uro kyaqamwa ututora mwia nrutu Kesemaniqi uro ntero nai nraaqiaranramwuanra tiqaro, Nkyenramwu mwaana mwatakyaa vita varivaqe nte vuturaqi uro Kotiravata qua qiankye, timwa kyero ");
INSERT INTO omw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pitaaravata, Ioninravata, Iemisiravata, mwinramwuhua nraahu sita varero viro. Mwinramwuhua nraahu sita varero vuvaro mwia hia kyuqe huvaro ");
INSERT INTO omw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","taarampo mwinramwuhuara tiqaro, Ni mutukyavanto nronraqama kyero muaanra ntero niqa piqaro ni rukyaa qara ihanama varuqo. Nkyenramwu nivatama kyeta mwaaqaa variqatama vu ntapairi kyeta viti viri taqe variqata variate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mwitaa timwa kyero mwiva pataqia vututo viro uro mwataqaa tumu ntiro Kotira kyapara hiro tiqaro, Mpo aanra vahirera, nte hia muaanra vahi aanranraqaa quankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mwitaa timwa kyero mwiva tiqaro, Po hiave, ko, e ekyaa kyaiqa qio vare variaravave. Nte nriqa quani nramanrinra nraani kaapura e mwi kaapura vara qatinani kyaante. Nte mwitaa qiariravata hia ni mutukya vahira vataqira quante. Ena mwutukya vahira vataqira quante, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iesusiva mwitaa timwa kyero uro ntantero nai nraaqiara taaramponramwu kyonani nrumu taqovata mwinramwuhua suvanto tautovata vaite varuvaro mwiva Pitaarara tiqaro, Saimonio, e vaiteve variaro? Nanraqamave nkyenramwu nivata pataqia variqata hia vu ntapairi kyeta viti viri taqe variqata variavo? ");
INSERT INTO omw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nkyiara mwihua uaqia hi kyaiqara utuate tiro, Saataaniva nkyi mwataara hiankyora mwianra rieqata taqe varita Kotirara aakyara nteqata variate. Nkyi mwanraquravanto mwitaa hiataa iharo nkyi mwamwantavanto nraahu hia kepukyaqa ihata variavo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mwitaa timwa kyero Iesusiva qaiqaa mwihua mwini kyero uro Kotiravata qua tirero mwiva vaakya tu quara mwi quara nraahu qaiqaa tiro timwa taiqa kyero ");
INSERT INTO omw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","uro ntantero nrumu taqovata mwia nraaqiaranramwu vu tautovata qaiqaa vaite varura. Iesusiva nri ntovata mwihua sivita kyauriqata Iesusira timwa mwi quava hia vahuvata varuvaro ");
INSERT INTO omw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iesusiva qaiqaavata uro Kotiravata qua timwa taiqa kyero uro ntantero nrumu taqovata mwihua qaiqaa vaite varuvaro Iesusiva tiqaro, Qikye, nkyenramwu tekya hiqatave vaite variavo? Qio taqaate. Ni tu vare entava nrima ntaiho. Ni mwatani mwatatai nraaqiarara ni ntavaaqavuqita uro uaqia hi kyaiqara uti varihua kyauquqi tuta kyevarave. ");
INSERT INTO omw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sivivaqenramwu quare. Ni qovarama kyaari vaisiva nrima variho, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesusiva mwi quara ti varuvaro mwia nraaqiara 12 nramwuqitairo Iutaasiva uro ntero. Iutaasiva uro ntovata mwiavata vaisi airivanto paipavata, kyaamwuvata, tu vareta vura. Kotira nraamwuqi Kotira kyaiqa vara mwate varu vaisihua mwihua nronra vaisinramwuvata, mwaanra okyara ti varuhuavata, Iutaa nronra vaisinramwuvantovata, mwihua mwi vaisihua sitovata mwihua Iutaasira vatama kyeta nrunra. ");
INSERT INTO omw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nruvaro Iutaasiva Iesusira qovarama kyaaninranra mwihua timwa nyinro mwitaama tiro: Nte mwia qua mwanteqana mota kyaani vaisira mwia mwivave. Nkye mwia ntavaaqavu kyeta mwiaqaa kyuqema kye ntaqikyiqi vita uro kyaate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iutaasiva mwitaa timwa kyero mwihua kyapata uro ntero mwiva qamwanrama kyero Iesusiva varunani uro ntero tiqaro, Mwaanra ti variara vaisio, timwa kyero mwia mota kyero. ");
INSERT INTO omw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Iutaasiva Iesusira uro mota kyovata Iutaasiravata nruhua uro Iesusira ntavaaqavu kyovaro ");
INSERT INTO omw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iesusira nraaqasairo mwia nraaqiara mpovanto paipa nai tuaqitairo veva ntanrau kyero mwiaqotairo vaisi mpo nraato teqa kyovaro tumu ntura. Kotira nraamwuqi kyaiqa vare varuhua mwihua vunyaa vaisi mwia kyaiqa vaisi nraato teqa kyora. ");
INSERT INTO omw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mwitaama kyovaro Iesusiva Iutaasiravata nru vaisihuara tiqaro, Qikye, nkye kamaninravatama kyeta ntaqua vaisihua sitarerata nriantema kyeta ni pitarerata paipavata kyaamwuvata varetave nriavo? ");
INSERT INTO omw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nte mpo enta mpo enta Kotira nraamwuqi variqana nraakye qora qua mwakyaakya timwa nyi varuqata nkye mwi entara hia ni ntavaaqavuarave. Kotira mpukuqi mwitaa hirara qara ntumwa tova vaiho. Mate mwi quava mwivauma vahiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iesusiva mwitaa tuvata mwihua mwia ntavaaqavu kyovata ekyaa mwia nraaqiaranramwuvanto mwia kyeta aatu ntuqeqaa hita vivura. ");
INSERT INTO omw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Qaraakya vaisi kuaikuvanto nraahu tavuna eqaroritua rupatova Iesusira vataqiro virera utuvata mwihua mwia taqeta uro mwiavata ntavaaqavu kyaare tita, ");
INSERT INTO omw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","tavuna mwi tuara nraahu tu varovaro mwi vaisiva tokyavanto hiantero vura. ");
INSERT INTO omw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mwia nraaqiaranramwuvanto aatu vuvata mwihua Iesusira vita vareta Kotira nraamwuqi kyaiqa vare varuhua mwihua vunyaa vaisivanto varuraqi uro kyovata Kotira nraamwuqaa ntaqikyi varuhua ekyaa hininramwu nronraqama vuhuavata, Iutaa nronra vaisinramwuvata, mwaanra okyara ti varu vaisihuavata, mwihua ekyaa nraamwu mwiqi ntuvaantuama vita varura. ");
INSERT INTO omw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Iesusira vitaqita uro kyeta varuvaro Pitaava vutura nyianrasata viqaro mwihua sataqiro vuva vunyaa vaisi nraamwu maata vahunani uro ntero utaqi mwaati ntero mwatukya mwiaqaa ntaqikyi varuhua kyapata mwatakyaa viro variqaro qia taare varura. ");
INSERT INTO omw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pitaava mwaata mwini varuvata Kotira nraamwuqi kyaiqa varohua nronranramwuvata, ekyaa nronra vaisi mwiqi ntuvaantuama vita varuhuavata, Iesusiraqaa qua vateta mwia rukyaare tita, mpo quara puaa huvaro hia vahuvata qumina mwia rukye quarara puaa hi varura. ");
INSERT INTO omw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hia qua vahuvata vaisi airivanto apiqama kyeta Iesusiraqaa unra qua nraahu vateta ti varuvaro mwihua quavanto mpo qua mpo qua vahiro, hia kuaa qua vahura. ");
INSERT INTO omw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mwitaa timwaqita vuvata mpo uhua Iesusiraqaa unra qua vateta tiqata, ");
INSERT INTO omw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Iesusiva mwitaa tihata tire riaunanrave. Mwiva tiqaro, Nte Kotira nraamwu vaisivanto nkyiari kyauquqo hoqataara ntapairi kyena nte taarampo enta variqana hia kyauquqo vareqana qaiqaa nraamwu mwia hoqa kyaaninrave, tirave, tita. ");
INSERT INTO omw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mwi vaisihua mwi quaravata tiqata hia ntapihi kyeta kuaa qua turama. ");
INSERT INTO omw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mwitaa tuvaro Kotira kyaiqa vara mwate varuhua mwihua vunyaa vaisivanto mwihua suqaa siviro Iesusira kyapara hiro tiqaro, Mwihua mwitaama kyeta iqaa qua vateta ti variavo. E mpo? Mwihua mwi quara iara qiara e nanra quave nkyiari timwa nyinanrave? tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tuvaro Iesusiva hia qua tiraitiro, tirema varuvaro qaiqaa mwiva mwia kyapara hiro tiqaro, Qutaave Kotiva i titaihara e tiri kyaahaqa hirava Mesaiaavanto variaro? Qutaave e Kotira mwaaquvanto variaro? Tiri timwa timwinraqe riaare, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mwiva mwitaa tuvaro Iesusiva tiqaro, Nte mwaa mwivave. Nkye nraakiara taqaivaqe nte mwatani mwatatai nraaqiarava nronraqama vina Kotiva kepukyavanto varianinra mwia kyauqu kyaatutani varina tonamwuqi tumuaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iesusiva mwitaa tuvaro Kotira kyaiqa vara mwate varuhua vunyaa vaisivanto nai tuavaaqa nrahitu kyero tiqaro, Qikye, qumina vaisi kyaatavanto mwiaqaa qua vatehua nyaanrevorave. ");
INSERT INTO omw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Riaate. Nkye airivanto variavaro mwiva Kotira vuqaa variqaro uaqia hi quara tiho. Mwia kyaara nkye nanreve Iesusirara tivarave? Tivaqe riaankye, tiro. Mwitaa tuvata mwihua tiqata, Mwia qora kyaiqavanto nritaraiho. Mwia kyaara mwia rukyaarava nraahuma vaiho, tita. ");
INSERT INTO omw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mwitaa timwa kyeta hini uhua uro Iesusiraqaa taara vihikye mwiaqaataita Iesusiva hia qio taqaarive tita, mwia vuqaa tavunaqo rupateta vireraqama kyeta mwia ntuqutu kyeta tiqata, Tavave i ntuqutiho? Hia taqaraitira, i ruani vaisira nrutu tiraqe riaare, tita. Mwitaamaqi vita Iesusira uaqiama mwatovata piponramwuvantovata mwia vita kyeta kyauquqo ntuqutuqita vurama. ");
INSERT INTO omw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nraamwuqi Iesusira uaqiamaqita vi varuvaro Pitaava mwaatani mwatukyaqaa mwatakyaa viro varuvaro vunyaa vaisi mwia kyaiqa nraakye mpovanto nritareqaro taqovaro ");
INSERT INTO omw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pitaava qia taare varuvaro mwia ntapihi kyero taqero tiqaro, E Iesusira Nasaretinyaa vaisintiri variaravave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tuvaro Pitaava qaqao tiro, E nanra quave qiaro? E qiana quara nte hiama ntapihuqo, tiro. Pitaava mwitaa timwa kyero uro nronraanrana varuvaro kokoraaravanto nruqua tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pitaava mwini varuvaro kyaiqa nraakye mwiva qaiqaa mwia taqero mwini sivita varuhuara tiqaro, Vaisi mwiva mwia nramwunaave, tuvaro ");
INSERT INTO omw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pitaava qaqao hiave nraahu tiro. Mwitaa timwa kyero pataqia varuvata qaiqaa mwini sivita varuhua Pitaarara tiqata, Iesusira nraaqiaranramwu Karirinyaahua variavara qutaama evata mwinyaavama variaro, tita. ");
INSERT INTO omw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mwihua mwitaa tuvaro Pitaava kyauqu nriqiqaa vatero tiqaro, Nte unra qiankyera Kotiva qioma ni ruananrove. Nte qutaama tuqo. Nkye ti varia vaisira nte hia mwia taqaurave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mwitaa tuvaro qamwanrama kyero kokoraaravanto qaiqaa nruqua tuvaro Pitaava mwiaqaatairo Iesusiva timwa mwu quara mwianra riero. Iesusiva Pitaara timwa mwiqanro mwitaama tiro: Mate entaqi kokoraaravanto hia taara nani nruqua tirara e taarampo nanima nianra tiqara, Nte hia mwia taqaurave tinanrave, tu quara mwianra riovaro mwia mwutukyavanto uaqia huvaro Pitaava ntatora. ");
INSERT INTO omw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mwia qanranraa toqaqi Kotira kyaiqa vara mwate varu vaisihua mwihua nronra vaisinramwuvata, Iutaa nronra vaisinramwuvata, mwaanra okyara ti varu vaisihuavata, ekyaa kaanasorinramwuvata, mwihua ntuvaantuama vita variqata mwihua qua ti okyarara timwa avuqavuma kyeta Iesusira seniqotaita mwia rupa vareta Pairaativa kamaninra nronra vaisivanto varuraqi uro kyora. ");
INSERT INTO omw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Uro kyovaro Pairaativa Iesusira kyapara hiro tiqaro, Qutaave e Iutaa vunyaa vaisivanto variaro? tuvaro Iesusiva tiqaro, E qiananra nte mwaa mwivama iho, tiro. ");
INSERT INTO omw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mwitaa tuvata Kotira kyaiqa vara mwate varu vaisihua mwihua nronra vaisinramwuvanto mpo qua mpo qua kyaara Iesusira inronra hi varuvaro ");
INSERT INTO omw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pairaativa mwihua qua rieqaro qaiqaa Iesusira kyapara hiro tiqaro, E hiave mwia hiniqama nkyiariara tinanrave? Mwihua airi qua kyaara i inronra hi variavo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mwitaa tuvaro Iesusiva qaiqaa hia qua tiraitiro, kepukyaqama kyero varuvaro Pairaativa airi nraato ti varura. ");
INSERT INTO omw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mpo ihi mpo ihi vekyahu nyato kyarara nro entaraqaa kamaninra vunyaa vaisivanto nraakye qora qamwata nyatarero karavu vaisi mpo huvantu kyero titovaro mwaatani vura. Nraakye qoravanto mwi vaisira huvantu timwa taante tuvaro mwi vaisira huvantu nyate varura. ");
INSERT INTO omw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mwi entara vaisi mponramwuvanto kamaninravata ntaqura kyaara karavuqi varuvaro mwi vaisinramwuhuaqitairo mpovanto mwia nrutu Varavaasiva mwiva vaisi rukyora kyaara karavuqi varura. ");
INSERT INTO omw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Qio mwi entaraqaa nraakye qoravanto ntuvaantuama vita variqata karavu vaisi huvantu kyaaninra mwianra rieqata ntuvaantuama vita varuvaro ");
INSERT INTO omw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pairaativa mwihua kyapara hiro tiqaro, Nte karavuqitaina ta vaisirave huvantu nyataaninrave? Iutaa mwatanaa vunyaa vaisi mwiave nte huvantu nyataaninrave? Nkye timwa mpivaqe riaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pairaativa ntapihi kyovata nronra vaisinramwuvanto Iesusiva nronraqama quankyorave tita, Iesusira inronrama mwateta mwihua mwia vitaqita uro Pairaatira kyauquqi tuta kyora. ");
INSERT INTO omw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pairaativa karavu vaisi tarave huvantu nyataaninrave timwa kyero, nraakye qora kyapara huvata Kotira kyaiqa vara mwate varu vaisihua mwihua nronra vaisinramwuvanto uro nraakye qora utaqaa variqata kepukya qua mwihua timwa nyita tiqata, Hia Iesusira huvantu timwa taante. Varavaasira huvantu timwa taante qiate, tita. ");
INSERT INTO omw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mwi nraakye qorahua rapateqa tuvata mwihua Varavaasira huvantu timwa taante tuvaro Pairaativa qaiqaa nraakye qora kyapara hiro tiqaro, Nkye Iesusirara tiqatama, Iutaa vunyaa vaisivantove, qiarave. Nte mwi vaisira nataave hianinrave? tiro. ");
INSERT INTO omw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mwitaa tuvata mwihua aakyara nteta tiqata, Mwia kyatariqaa rutaate, tita. ");
INSERT INTO omw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mwitaa tuvaro Pairaativa qaiqaa mwihua kyapara hiro tiqaro, Mwiva nanra uaqia hi kyaiqara utu kyaihatave mwitaa qiavo? tuvata mwihua qati nraahu paatita aakyara nteta tiqata, Mwia kyatariqaa rutaate, tita. ");
INSERT INTO omw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mwihua mwitaa tuvaro Pairaativa nraakye qora qamwata nyatarero Varavaasira huvantu nyatero mwiaqaatairo nai ntaqu vaisihuara Iesusira kyaamwuqo ntuqutuate tuvata mwihua mwia kyaamwuqo ntuqutu kyovaro mwiaqaatairo mwia kyatariqaa rutaate tiro, Pairaativa Iesusira nai ntaqu vaisihua kyauquqi tuta kyora. ");
INSERT INTO omw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pairaativa nai ntaqu vaisihua kyauquqi Iesusira tuta kyovata mwihua mwia vitaqita uro kamaninra nraamwuqi kyeta mwihua nkyiari hena ntaqu vaisihua ekyaa nyaanrama ntuvaantuama kyeta ");
INSERT INTO omw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","mwia vireraqa hiqata vunyaa vaisi tavuna nraanre tavuna rupa mwateta mwiaqaataita tauvera vara kyeta qiata vaisi tovaqa voti hura ququrama kyeta Iesusira qiataqaa qumwa tora. ");
INSERT INTO omw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mwitaama kyeta nkyiari kyauqu tiriqa vateqata kumwaanri mwitaa tita tiqata, Iutaa vunyaa vaisio, variqarave? tita. ");
INSERT INTO omw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mwitaa timwa kyeta mwihua kyaamwuqotaita mwia qiata ntukamu kyeta, mwiaqaa taara vihi kyeta, mwia vuqaa tori kyauru ravi variqata qati vireraqama kyeta mwia qamwata mwateqata varura. ");
INSERT INTO omw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mwitaamaqi viqata vireraqama kye raima mwateta mwiaqaataita mwihua nraanre tavuna rupa mwatora huvantu kyeta nai tuavaaqa utu mwateta mwia kyatariqaa ninri rukyeta hiritarerata Iesusira vita vareta vurama. ");
INSERT INTO omw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ntaqu vaisinramwuhua Iesusira kyatariqaa ninri ru kyeta hiritaare tita, mwia vita vareta mwatukya mwaaqani aanraqaa vi varuvaro vaisi mpovanto mwia nrutu Saimoniva mwatukya nronraqi virera huvata mwihua mwia antua kye kepukyaqama kyeta tiqata, Iesusira ru kyeta hirite kyatarira vara quqira uro mwataante, tuvaro Saimoniva vara quqiro uro mwatora. Saimoniva mwata Sairininyaava mwiva Arekisantaakya Rupukya sova varura. ");
INSERT INTO omw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mwihua Iesusira vitaqita uro qumina mwata Korokotaave tunani kyora. Korokotaa mwaa quaraqitai tirera, Qiata Mwukyaariqaave, tunani Iesusira uro kyora. ");
INSERT INTO omw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Uro kyeta uaini mwiqi ukavu inraikyara tuqasaa kye vato nramanrinra mwia mwinrenra huvaro Iesusiva hia nrenro. ");
INSERT INTO omw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hia nrovata mwihua mwia kyatariqaa ninriqotai rukyeta mwia tuavaaqa vara kyeta tahua tahuave qio varevarave timwa kyeta, kaati ruantema kyeta ori tuto kyeqata mwia tuavaaqa ntainra kyeta varora. ");
INSERT INTO omw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Toqaqi huarivanto nrinro virisataqa huvata Iesusira kyatariqaa rutora. ");
INSERT INTO omw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mwia kyatariqaa ruteta Iesusira qiatani qua mpo, mwia ko timwa mwato quara qara ntumwa teta kyatariqaa rutora. Mwi quava mwitaama tiro: IUTAA VUNYAA VAISIVE, tiro. Mwi qarava mwitaama kyero vahura. ");
INSERT INTO omw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mwihua Iesusira kyatariqaa ruteta Iesusira vatama kyeta vaisi taaratana rutora. Mwitanahua mpuara vare varutanahua varuvata mpo Iesusira kyauqu kyaatutani ninri ruteta mpo Iesusira kyauqu kyaantaaqani ninri rutora. ");
INSERT INTO omw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Iesusira vatama kyeta mwitaama rutorara tiro, Kotira mpukuqi qua mpo qara ntumwa tova mwivau vahura. Mwitaama tiro: Mwiva uaqia hi vaisihua vatama kyero variananrove, tura. ");
INSERT INTO omw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mwitaama kye rutovata nraakye qoravanto vitare nritare hiqata viri taqeta nkyiari mwaunru miqi kyeqata Iesusirara uaqia hu quara timwa mwateta tiqata, Qikye, e tiqarama, Kotira nraamwu ntapairi kyenama taarampo entaqaa kyaiqa vareqanama qaiqaa hoqa taiqa kyaaninrave, qiaravave? ");
INSERT INTO omw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Qio ena kyaahaqa hiante. E kyatariqaataira mpiami ntaante, tita. ");
INSERT INTO omw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mwihua mwitaa ti varuvata mwihua tuntema kyeta Kotira kyaiqa vara mwate varuhua mwihua nronra vaisinramwuvata, mwaanra okyara ti varu vaisihuavata, mwihua Iesusirara raima mwateta tiqata, Mwiva mpohua nraahu kyaahaqa hi variva hiama qio nai kyaahaqa hirove. ");
INSERT INTO omw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mwiva Kotiva titai vaisiva Mesaiaavantove, Isareri vunyaa vaisivantove, qiavata riaunanrave. Kyai tire variqata taqaararo mwiva kyatariqaatairo mpiami ntero tuminrenra, tire mwianra qutaave qiare, tita. Mwihua mwitaa tuvata mwihua nraantanteta mpuara vaisitana Iesusira vatama kyeta rutotanahua, mwitanahuavata mwia uaqia hu quara timwa mwate varura. ");
INSERT INTO omw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mwitaa huvaro ihera mwutukya tavaara ekyaa mwi mwataraqaa entama tero vahiqi vuvaro huarivanto vitira tavaarana tumi vuvaro qaiqaa ntuvaahama vura. ");
INSERT INTO omw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Qaiqaa ntuvaahama vuvaro Iesusiva nai quaqitairo aakyara ntero tiqaro, Eroi, Eroi, rama sapakitani. Kotio, Kotio, nanraqamave ni qaqira kyera hiarao? tiro. ");
INSERT INTO omw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iesusiva mwitaa tuvata mpo uhua mwini sivita varuhua mwia qua rieta tiqata, Mwiva Iraisaara tiri haivaqara nraanraiho, tuvaro ");
INSERT INTO omw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","mpovanto hiantero ukavu uaininra kyaqa kyero kyaamwu kati kyero mwiaqaa huairi kyero viri Iesusira nrona vatero tiqaro, Kyai variqata taqaararo Iraisaava mwia kyaahaqa hirero tumuaninra taqaare, tiro. ");
INSERT INTO omw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mwitaa tuvaro Iesusiva nronraqama kyero aakyara ntamwa kyero qutu vura. ");
INSERT INTO omw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iesusiva qutu vuvaro Ierusaremini Kotira nraamwuqi tauha voti hura tavuna nronra hiritova virisairo utaqaa nrahituqiro tuminro mpiani tumu kyora. ");
INSERT INTO omw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ntaqu vaisihua vunyaava Iesusira ruto kyatarira nraaqani varuva taqovaro Iesusiva nronraqama kyero aakyara ntamwa kyero qutu vuvaro mwiva tiqaro, Qikye, qutaama vaisi mwaava Kotira mwaaqu variva qutu viho, tiro. ");
INSERT INTO omw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Iesusiva qutu vuvata nraakye mponramwuvanto nyianrasata variqata taqe varura. Mwinramwuhuaqitairo hininramwu nyutu vahirero. Mariaava Makataranyaava mpo, Mariaava Iemisiva nraakiaraa vaisi mwiavata Iosisiravata nyova mpo, Saromeva mpo, mwihua mwini varura. ");
INSERT INTO omw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nraakye mwinramwuhua Iesusiva Karirini nrohu entara mwia vataqita nrohiqata mwia kyaiqa kyaahaqama mwato nraakyenramwuhua varuvata nraakye mponramwuvata mwini varura. Mwihua Iesusiravatama kyeta nruhua Ierusaremini varura. ");
INSERT INTO omw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Entama virera huvaro Iosepiva Arimatianyaava nri ntora. Mwi vaisiva vaisi kyuqeva kaanasorivanto variqaro Kotiva ntaqikyiani entava nrianinranra taqeqaro mwia vekya varuva nri ntero, hura Iutaa mwaanra enta vahianinranra riero hia aatu hiraitiro, uro Pairaatirara Iesusira mwamwantara kyapara hiro tiqaro, Mwia mpiraqe varaqina uro quntaakye, tiro. ");
INSERT INTO omw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mwitaa tuvaro Pairaativa Iesusiva qamwanrama qutu vurara airi nraato tiro ntaqu vaisira mpo nraanrama kyero kyapara huvaro mwi vaisiva tiqaro, ");
INSERT INTO omw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Qio qutaama qutu viho, tuvaro Pairaativa Iosepirara tiqaro, Qioma mwia mwamwanta varaqira uro quntamwa tenanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mwitaa tuvaro Iosepiva eqarori tavuna kyoqaama kyero Iesusira mwamwanta kyatariqaatairo itu kyero eqarori tavuna mwiaqotairo qapuqama kyero uro vaisi quntarera ori vaurutoraqi vera vatero ori nronra mpo ventaqiro uro mwia nrona tita tora. ");
INSERT INTO omw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariaava Makataranyaavavata, Mariaava Iosisira nrovavata, taqe varuvata Iesusira oriqi vera vatora. ");
INSERT INTO omw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Saarareqa Iutaavanto mwaanra tu entava taiqovata Mariaava Makataranyaa nraakyevantovata, mwia qamwava Iemisira nrovavata, Saromevavata, mwi nraakyenramwuhua munima kyeta kyuqema kyero mwunta vu inraikyara vareta Iesusira mwamwantaqa qumwatarerata vura. ");
INSERT INTO omw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Saante toqaqi huarivanto mate nrintoraqi mwinramwuhua Iesusira quntamwa toraqiara vura. ");
INSERT INTO omw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aanrani viqata mwinramwuhua nai kyapara hi nai kyapara hi tiqata, Tire mwini uro ntaararo tavave ori nronra qesana titataara vara kyaananrove. Ori mwia nronra nrusi ntamwa taarave, tita. ");
INSERT INTO omw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mwitaa timwa kyeta mwinramwuhua nri nteta taqovaro ori nronra mwia nrusi venta kyovaro qatinani vahura. ");
INSERT INTO omw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Orivanto mwitaama vahuvata taqeta mwinramwuhua oriqi vera nteta taqovaro vaisi mpo qaraakya vaisivanto eqarori tuavaaqa ututo vaisiva mwiqi hini kyaataaqi mwatakyaa viro varura. Mwiva mwiqi varuvata mwia taqeta aatu huvaro ");
INSERT INTO omw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","mwiva mwihuara tiqaro, Hia aatu hiate. Iesusira Nasaretinyaanra kyatariqaa rutaa vaisira, nkyenramwu mwianrave puaa hi variavo? Mwiva hia mwaaqi variho. Mwiva qatima siviho. Nkyenramwu mwaini taqaate. Mwaaqi mwia vataaraqi hiama variho. ");
INSERT INTO omw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Qio mwaa quara vareta uro mwia nraaqiaranramwuvata, Pitaaravata, timwa nyiate. Mwitaama timwa nyiate. Mwiva nraante nkyi suni Karirinima viho. Nkyenramwuvata mwini vita uro mwia taqevarave. Tauraa qati variqaro mwianra nkyi timwa nyunra mate mwivauma vaiho. Mwi quara timwa nyiate, tiro. ");
INSERT INTO omw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mwiva mwitaa tuvata aatu hiqatara tita, mwinramwuhua Iesusira quntamwa toraqitaita veva nteta hiantamwa teta aanrani viqata hia mpohuavata timwa nyinraitita, vura. ");
INSERT INTO omw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesusiva Saante toqaqi qutu vuraqitairo siviro vuni mwiva Mariaara Makataranyaanra vuqaa nraante qovarama vura. Haaru Iesusiva nraakye mwia utaqitairo vaana 7 nramwu sitovata nritare vu nraakyera vuqaa qovarama vuvaro ");
INSERT INTO omw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariaava uro Iesusira nraaqiaranramwu timwa nyinrenro vuva uro taqovata mwihua Iesusirara ntate varura. ");
INSERT INTO omw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ntate varuvaro mwiva mwihua timwa nyinro tiqaro, Iesusiva qatima siviro variho. Nte ntena puqotaina mwia taqauqo, tuvata mwihua hia mwia quara qutaave tura. ");
INSERT INTO omw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mwi entara Iesusiva nraahumwa mpo qarama kyero nai nraaqiara taaratana suqaa qovarama vura. ");
INSERT INTO omw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mwitanahua aanraqaa vi varuvaro Iesusiva qovarama vuvata mwihua mwia taqeta uro ntanteta nrumu hini mwihua timwa nyuvata mwihua hia mwitanahua quara qutaave tura. ");
INSERT INTO omw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Qio nraakiara ekyaara Iesusira nraaqiara 11 nramwuvanto kyara nre varuvaro Iesusiva mwihua suqaa qovarama vura. Iesusiva qati siviro varuvata mpo uhua mwia taqeta uro Iesusira nraaqiaranramwu timwa nyuvata mwihua mwi quarara unra quave timwa kyeta varuvarora tiro, Iesusiva nkyiari suqaa qovarama viro mwia kyaara mwihua inronra hiro tiqaro, Nkye mwi quarara qutaave qiataara vaihatama nkye kepukyaqama kyeta variqata hia qutaave qiavo, tiro. ");
INSERT INTO omw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mwitaa timwa kyero mwihua timwa nyinro tiqaro, Nkye ekyaa mwata maata nrohiqata ekyaa nraakye qora kyuqe qua mwaa timwa nyiate. ");
INSERT INTO omw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Timwa nyivaro ni quara qutaave timwa kyero, nramanri varaani vaisira, mwiama Kotiva qio vitaananrove. Ni quara hia qutaave qiani vaisira Kotiva hia mwia vitaraitiro, mwiaqaa qua vataananrove. ");
INSERT INTO omw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ni quara qutaave tihua, mwihuama nronra kyaiqa mwataa hianinra qio varevarave. Mwihua ni nutu nteqatama vaana titaivata vivarave. Mwihua nraahumwa mpo mwatanaa quavata qio tivarave. ");
INSERT INTO omw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mwihua quaiha tu varaivaro mwi inraikyava hia mwihua ruananrove. Mwihua tuhi nramanri nraivaro tuhi nramanrivanto hia mwihua ruananrove. Mwihua nriqa vihuaqa kyauqu vataivata mwihua kyuqema vivarave, tiro. Turama. ");
INSERT INTO omw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nronravanto Iesusiva nai nraaqiaranramwu kyapata qua timwa nyi taiqa kyovaro Kotiva mwia nyaamwuni vitero vuvaro mwiva mwini nronraqama viro Kotira kyauqu kyaatutani mwatakyaa virero vurama. ");
INSERT INTO omw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iesusiva nyaamwuni vuvata mwia nraaqiaranramwuvanto mwata maata vahuntema nrohiqata Iesusirara timwa nyi varuvaro nronravanto Iesusiva mwihua kyaahaqa hi varuvaro mwihua kyaiqavanto kepukyaqama viro nritarero vahuvatara tita, nraakye qoravanto taqovaro mwihua quavanto qutaa qua nraahu vahura. ");
INSERT INTO omw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nronra vaisi Tiopiraasio, Iesusiva tiri utaqaa variqaro mpo kyaiqa mpo kyaiqa varorara airi vaisivanto mwi quara qara ntumwa torave. ");
INSERT INTO omw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tauraaqama kye vaisi mponramwuvanto nkyiari suqotaita mwi inraikyara taqeta, mwiaqaatai tiri timwa timwuvata vaisi airivanto mwi quara qara ntumwa torave. ");
INSERT INTO omw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nronra vaisio, ntevata mwi quara okyaraqaataina ntapihi riarerave timwa kyena, airi enta kyaparamaqi vina mwi quara qio ntapihi kyena riena, evata ntapihi kyera riaante tina, mwaa quara okyaravata, tavaaravata, mwutuvata, qara ntumwa tena. ");
INSERT INTO omw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Vaisi mponramwuvanto i timwa mwu quara ntapihi kyera riaante tina, ntevata mwaa quara ntapihi kyena i timwa mwinrenrave. ");
INSERT INTO omw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herotiva vunyaa vaisivanto Iutaa mwataqaa ntaqikyi varu entara vaisi mpovanto Sekaraiaava mwaanra kyaiqa vareqaro nraakye qorara rieqaro Kotira kyaiqa vara mwate varu vaisiva varurama. Mwiva Avaisaara kuaa okyaravanto varura. Mwia nraata mwia nrutu Irisavetiva mwivavata Eroninra kuaa okyaravanto Kotira kyaiqa vare varu okyarahua varurama. ");
INSERT INTO omw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sekaraiaakya Irisavetikya mwitanahua Kotira vuqaa avuqavuma variqata Kotira qua ekyaa qua riemwaqi vi varurama. ");
INSERT INTO omw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mwitaamaqi viqata hia nraaqiaravata mwatorama. Irisavetiva ehaaraqa huva hia nraaqiara mwataraitiro, qatitana variqi vita kyonta nyaapaiqa hurama. ");
INSERT INTO omw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Mpo enta Kotira kyaiqa vara mwate varu vaisihua mponramwuvanto kyaiqa vara taiqa kyeta uro mwaatani varuvaro Sekaraiaava varaari iherava nruvata mwia vataahuavata mwia kyaahaqa hiqata Kotira nraamwuqi kyaiqa vararerata nrunrama. Mwihua kyaiqa vararera hiqata santu vera kyeqata kyaiqa ntuqaaqama/puhama kyeta Sekaraiaarara, E Kotira nraamwuqi variqara Kotirani kyuqe munra quarive tira, qia quara mwataante, tuvaro Sekaraiaava nronravanto hu nraamwunraqi nanrianraa vera ntero mwunta vu inraikyara vara kyero qiaqaa quararero viro. ");
INSERT INTO omw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mwiva mwiqi variqaro mwi kyaiqara vare varuvata qati nraakye qoravanto mwaatasata ntuvaantua hita Kotirara aakyara nte varura. ");
INSERT INTO omw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mwihua Kotirara aakyara nte varuvaro Sekaraiaava nraamwuqi varuvaro qamwanrama Kotiva titova nyaamwunyaa vaisivanto mwiaqaatairo qovarama viro munra quani taintara tataaqa mwia kyauqu kyaatutani siviro varuvaro ");
INSERT INTO omw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraiaava mwia taqero nrihanrama viro aatu hiro. ");
INSERT INTO omw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Aatu hi varuvaro Kotiva titova tiqaro, Sekaraiaao, hia aatu hiante. E Kotirara aakyara nteqara ntumwahiamwa hiananra Kotiva riaiho. I nraatavanto Irisavetiva qoraisi nraaqiara mwata taananrove. Mwi nraaqiarara nrutu nteqara Ioninrave qiante. ");
INSERT INTO omw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mwia mwata taaninranra evata nraakye qora airivantovata mwianra qamwatevarave. ");
INSERT INTO omw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mwiva Kotira vuqaa vaisi nronravanto varianinrave. Mwiva uainivata mwi nramanrinra voti hianinravata hia nraanrive. Mwia mwata taani entaraqaatairo Kotira mwanraquravanto kepukyaqama kyero mwiaqaa ntaqikyiraro variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Isareri mwatanaa mwaahua airivanto mwia qua rieqata uaqia hi aanranra qaqira kyeta uro ntante Kotirara tiri nronravantove timwa kyeta Kotira aanraqaa vivarave. ");
INSERT INTO omw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kotiva i nraaqiara titairaro mwiva nraante urontero nkyi haivaqava Iraisaava kepukyaqama kyero varontema kyero mwiva airi nraakye qora kyaahaqa hianinrave. Ioninra qua rieqatama vaisivanto antua qua qaqirakye nkyiari nyaaqumwanravata qamwateqa varivarave. Ioniva qua timwa nyinrata Kotira qua raaqu kyehua qaiqaa ntapihi kye riemwaqi viqata varivarave. Ioniva nraakye qora terama tairata mwihua nronra vaisi vekya variate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mwitaa tuvaro Sekaraiaava Kotiva titorara tiqaro, Qaqao, e tinanranra nte nataama kyenave qutaave qianinrave? Nte nyaapaiqama vuqaro ni naatavantovata kyontaqama viho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tuvaro Kotiva titova mwia timwa mwinro tiqaro, Nte Keviriarivave. Nte Kotira vuqaa sivi varuvave. Kotiva ni titaihana nte kyuqe mwakyaakya tumu i timwa mwuqo. ");
INSERT INTO omw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Qio riaante. E ni quara hia qutaave tinanra mwia kyaara i nrovanto tita virara hia qio qua tinanrave. Mwitaama variqira viraro i nraatavanto nraaqiara mwata tairarama qaiqaa qua tinanrave. Nte iara qianinra qutaama qovara hiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kotiva titova nyaamwunyaa vaisivanto mwitaa ti varuvata mwaatani varu nraakye qorahua Sekaraiaara vekya variqata taqovaro nraamwuqi mpuahaama varuvata mwihua airi nraato tita tiqata, Nataa hiqarove mwiva hia vaakya veva ntaiho? timwa kyeta taqe varuvaro ");
INSERT INTO omw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sekaraiaava veva ntovata mwihua taqovaro qua qiankye tura hia qio qua tura. Mwiva hia qua tuvata mwihua tiqata, Sekaraiaava mwiqi variharo mpo inraikyavanto mwia vuqaa qovara iharoma mwia nrovanto tita viharo hia qio qua tiho, tita. Tuvaro Sekaraiaava qua qiankye tura hia qua tiraitiro, kyauquqo nraahu piaateqaro varurama. ");
INSERT INTO omw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mwiva kyaiqa varo iherava taiqa vuvaro mwiva nrumu ntantero nai mwaatani uro varurama. ");
INSERT INTO omw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Uro varuvaro mwia nraatavanto Irisavetiva nraaqiara tuaqa hurama. Irisavetiva nraaqiara tuaqa hiro mwiva tora hini kyauquruara nraamwuqi nraahu tuqeta kyero varurama. ");
INSERT INTO omw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Mwiva tiqaro, Kotiva nianra po tirave. Tauraaqama hia nraaqiara mwataraitina, kyauriqa varurave. Mate mwaa entara nte nraaqiara tuaqa hina hia kyauriraitina varuqo, tiro. Mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Irisavetiva nraaqiara tuaqa huvaro 6 tora nritarovaro Kotiva qaiqaa Keviriarira titovaro mwiva Nasareti mwatukya Karirini tumu ntora. ");
INSERT INTO omw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Keviriariva Iosepira tito nraakyera qaraakya nraakye mwakyaakya timwa mwinrenro tumunrama. Iosepira okyara varirerata Ntevitira nai haivaqara kuaa okyara varurama. Iosepira tito nraakyera nrutu Mariaava. ");
INSERT INTO omw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kotiva titova tumu ntero verante Mariaarara tiqaro, Varirave hiaro? I kyuqema mwatai nraakyeva variaro. Nronravanto ivata variho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mwitaa tuvaro Mariaava mwia qua riero nronra nraato riero tiqaro, Nataa iharove nianra mwitaa tiho? tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mwitaa tuvaro Kotiva titova tiqaro, Mariaao, hia aatu hiante. Kotiva iara qamwateqaro variho. ");
INSERT INTO omw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","E riaante. E nraaqiara tuaqa hira qoraisi nraaqiara mwata tera mwia nrutu nteqara Iesusirave qiante. ");
INSERT INTO omw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mwiva nronra tuero nronra vaisima variananrove. Mwianrama Kotiva nai virini nyaamwuni varira mwia mwaaquve tivarave. Nronravanto Kotiva Ntevitiva nai haivaqava ntaqikyiani kyaiqara mwia mwianinrave. ");
INSERT INTO omw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","I nraaqiaravanto Iaikopura okyaraqaama ekyaa enta ekyaa enta ntaqikyianinrave. Mwiva ntaqikyiani kyaiqava hia taiqaaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Keviriariva mwitaa tuvaro Mariaava mwia kyapara hiro tiqaro, Nataama kyerove mwitaa hiananrove? Hia nte qoraisi varauvave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mariaava mwitaa tuvaro Kotiva titova timwa mwinro tiqaro, Kotira mwanraquravanto ivata variraro Kotira peqavanto i ntumwaqu taaninrave. E mwata terava Kotira kyaiqa nraahu varaari vaisiva varirata mwianra Kotira mwaaquve tivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mwitaa timwa kyero mwiva tiqaro, I vataava Irisavetiva kyontaqama vivavata mwiva nraaqiara mwataaninrave. Mwi nraakyerara ehaaraqa hivave qiavaro mwiva nraaqiara tuaqa iharo 6 tora nritaraiho. ");
INSERT INTO omw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kotiva ekyaa kyaiqa qio nraahu vare varivama variho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kotiva titova mwitaa tuvaro Mariaava tiqaro, Nte Kotira kyaiqa nraahu varaarivama varuqo. Qio e tinantema kyero Kotiva ni mwitaa hiarive, tiro. Mwitaa tuvaro Kotiva titova tumu ntantero vurama. ");
INSERT INTO omw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kotiva tito vaisiva tumu ntantero vuvaro Mariaava qamwanrama kyero siviro Iutiaani mwatukya mpo taaqiqi vahuraqi Irisavetira timwa mwinrenro vurama. ");
INSERT INTO omw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Vuva uro Sekaraiaara nraamwuqi vera ntero Irisavetira qua mwantora. ");
INSERT INTO omw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Qua mwante varuvaro Irisavetira vikyokyaqitairo nraaqiaravanto qakyaa huvaro Kotira mwanraquravanto Irisavetira kepukyaqama kyero kyaahaqa huvaro ");
INSERT INTO omw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Irisavetiva aakyara ntero tiqaro, Airi nraakye variavaro Kotiva i nraahuma kyuqema mwataiho. E mwata tena nraaqiararavata Kotiva kyuqema mwataarive. ");
INSERT INTO omw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","I nraaqiara vunyaa vaisi kepukyavanto variqaro niqaa ntaqikyiariva varihara e mwia nrova variqarama e ni qumina nraakye nrumu taqarera nrianro. ");
INSERT INTO omw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","E vaakya ni qua mwantaarana nte i qua rie varuqaro nraaqiaravanto ni pikyokyaqitairo qakyaa iho. ");
INSERT INTO omw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nronravanto mwi mwakyaakyara timwa mwihanra e mwia quara qutaa mwitaa hiananrove qiananranra tiro, Kotiva i kyuqema mwataihara qamwateqara variaro, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Irisavetiva mwitaa tuvaro Mariaava Kotira nrutu tuaaherero tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nte ntena mwutukyaqitaina Kotira nrutu tuaaherauqo. Kotiva ni kyaahaqa hiariva variharora tiro, ni mwanraquravanto qamwateqaro variho. ");
INSERT INTO omw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Nte Kotira kyaiqa nraakye qumina nraakye varuqaro Kotiva ni nraahu kyuqema matairave. Kotiva kepukyavanto variqaro nronra inraikya ni mwitaama matairara tita, mate varihuavata, nraakiara varihuavata, nianra Kotiva nronraqama kyero mwi nraakyera kyuqema mwatairave tivarave. Kotira okyaravanto vahirero nai avuqavuma kyero vahirave. ");
INSERT INTO omw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Haaruvata, matevata, qakyovata, ta nraakye qorahuave, Kotira qua riaahua mwihua Kotiva po tiro kyuqema nyatairave. ");
INSERT INTO omw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mwihua nkyiari nyutu tuaahera kyeta ntuvaantuama vita uaqia hi kyaiqara vararerata uti variavaro Kotiva nai kyauqu kepukyaqo mwihua raaputa mpona mpona kyairave. ");
INSERT INTO omw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kotiva nronra vaisi vara mwatumwi qumina vaisiqama tero qumina vaisi vara nronraqama taiharo nronraqama virave. ");
INSERT INTO omw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nraataa hi vaisihua Kotiva kyara nyihata nreta qio variarave. Airi inraikya vataira Kotiva titaiharo hia mpo inraikyavata vararaitiro, qati virave. ");
INSERT INTO omw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kotiva nai kyauqu nriqiqaa vatero timwa tai quara vataqiro viqaro tiri Isareri nraaqiara kyaahaqa hirave. Mwiva haaru Evarahaamunranra tiqaro, Nte iaravata, i nraisi mwihuaravata, ekyaa enta ekyaa enta po tina kyuqemaqina virerave, tu quara hia taunru kyairave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariaava mwitaa timwa kyero Irisavetikya variqiro viro taarampo tora vara kyero nrumu ntantero nai mwaatani vurama. ");
INSERT INTO omw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Irisavetiva nraaqiara mwataari entava nri ntovaro mwiva mwi entara qoraisi nraaqiara mwata kyora. ");
INSERT INTO omw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mwata kyovata mwia nramwunaahuavata, mwi mwatanaahuavata, riovaro Kotiva Irisavetirara kyuqe huvata mwihua uro Irisavetiravata variqata nraaqiara mwianra qamwatarerata nrunra. ");
INSERT INTO omw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mwihua nri ntovaro 8 enta nritarovaro mwi nraaqiarava qoraisi nraaqiara varuvatara tita, mwia mwamwanta toqarerata ntuvaantuama vita. Ntuvaantuama vita variqata mwihua mwia nrutu nteqata mwia qora nrutu Sekaraiaavave qiare tuvaro ");
INSERT INTO omw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","mwia nrova qaqao tiro, Nte mwia nrutu Ionivave tirerave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mwiva mwitaa tuvata mwihua tiqata, Hia i okyaraqi mwi nrutura vahirama e mwi nrutura ntaaro, tita. ");
INSERT INTO omw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mwitaa timwa kyeta mwihua Sekaraiaaraqaa kyauqu piaateqa mwia kyapara hita, E ena mwaaqu nanra nrutuve mwinanrave? tuvaro ");
INSERT INTO omw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraiaava kyauqu piaateqaro pepaa vara mpiate tuvata pepaa vara mwuvaro Sekaraiaava mwataama kyero qara ntiro, Mwia nrutu Ionivave, tiro. Mwitaama qara ntumwa tovata mwihua nrihanrama vita. ");
INSERT INTO omw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nrihanrama vuvaro qamwanrama Sekaraiaara nrovanto qatua vuvaro mwiva qio qua tiro. Mwiva qio qua tiqaroma Kotira nrutu tuaaherero. ");
INSERT INTO omw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mwitaa ti varuvata mwia nramwunaahua mpoqama kyeta aatu hi varurama. Mwi quava ekyaa Iutiaani vuvata ");
INSERT INTO omw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","nai timwa mwi nai timwa mwi hita tiqata, Mwi nraaqiarava nataa hiari vaisivave variananrove? tita. Mwihua taqovaro Kotiva kyaahaqa hi varuvaro mwi nraaqiarava varurama. ");
INSERT INTO omw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kotira mwanraquravanto mwia qora Sekaraiaara kepukyaqama kyero kyaahaqa huvaro mwiva Kotira qua mwataama tiro: ");
INSERT INTO omw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kotiva nronravanto tiri Isareriqaa ntaqikyi varivave. Nrivaqe mwia nrutu tuaaheraare. Mwiva tiri nai nraakye qora kyaahaqa hiro huvantu kyarero nriho. ");
INSERT INTO omw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kotiva tiri haivaqara Ntevitira nraisi mpo vara mwaamwianrama taiharo mwi vaisiva kepukyavanto variqaro tiri huvantu kyairaqe qio variare. ");
INSERT INTO omw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Haaru Kotiva kyaahaqa huvata mwia kyaiqa vaisinramwu mwia qua qovarama kyeta nraakye qora timwa nyiqata ");
INSERT INTO omw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kotiva mwitaa tiho tura, Nkyi nramwutaahua nkyi ru kyevorave tinama, nte nkyi kyaahaqa hirerave. Nkyi uaqiama nyate varihua nkyiqa ntaqikyiqi vivorave tinama, nte nkyi huvantu kyarerave turave. ");
INSERT INTO omw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kotiva tiri haivaqahuara tiqaro, nte nkyiara po timwa nyatena nte nkyivata variqana qua vataura hia taunru kyarerave, turave. ");
INSERT INTO omw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Kotiva nai kyauqu nriqiqaa vatero tiri haivaqara Evarahaamunranra tiqaro, Nraakiara e mwatara terahua mwihua nramwutaahua mwihua ru kyevorave tina, mwihua nte vaitutuma nyataaninrave. Nte mwihua vaitutuma nyataarita mwihua hia nramwutaahua nraatu aatu hiraitita, ");
INSERT INTO omw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mwihua qati variqi viqata ni puqaa variqata ni kyaiqa nraahu kyuqema kyeta vareqata avuqavuma kyeta nrohivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sekaraiaava mwitaa timwa kyero mwiva nai nraaqiarara tiqaro, Ni maaquo, nraakiara nraakye qoravanto iara tiqata, Kotiva nyaamwuni variva vaisi mwia kyaahaqa hi variharo mwiva Kotira qua ti variho tivarave. Nronravanto nrinrenra hirara e nraante viqara mwia aanra terama mwatenanrave. ");
INSERT INTO omw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kotiva nraakye qora uaqia hi kyaiqara uti quara nruka nyatero mwihua huvantu nyataani quara, e nraante timwa nyinanrave. ");
INSERT INTO omw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kotiva tiriara nronraqama kyero po tiqarora tiro, mwiva ntuvaahaani vaisira titairaro mwiva tire variananrani tuminro ");
INSERT INTO omw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tire quturahua kyokiraqi variananra ntuvaahama timwa taananrove. Mwiva tiri tivitairaqe tire mwaateraqama kyeta kyuqema variare, tiro. Sekaraiaava mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwitaa tuvaro mwia mwaaquvanto nronra tuemwa vuvaro mwia mwanraquravantovata kepukyaqama vura. Mwiva qumina mwataqaa variqiro viro vaisiqama viro mwiaqaatairo mwiva Isareri mwatanaahua suqaa nri ntora. ");
INSERT INTO omw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mwi entara Romeni mwatanaahua vunyaa vaisivanto Sisa Okasitaasiva taakisi vararera hiro tiqaro, Ekyaa mpo mwatanaa mpo mwatanaa nrutu vataate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","3","Mwitaa tuvata ekyaa nraakye qora nkyiari mwaatani nrutu vatarerata nrumu ntateqata vurama. Sairiniaasiva Siriaa mwataqaa ntaqikyu entara mwihua nrutu vatorama. Nrutu varo okyarara mwi entara tohara kyeta varora. ");
INSERT INTO omw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Nraakye qora nkyiari nyutu vatarerata vuvaro Iosepivavata Nasaretisairo siviro nai tito nraakyera Mariaaravata vita varero Kariri mwata kyero uro Ntevitira mwatukya Vetarahemini Iutaa mwatani nrutu vatarero vurama. Iosepiva nai haivaqara Ntevitira okyaravantora tiro, mwini vurama. Iosepiva Mariaara vita varero vuvaro Mariaava nraaqiara tuaqama vuva airi tora nraatara kyero mwiva nraaqiara mwataari entava qaumaqa huvaro ");
INSERT INTO omw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","mwiva Iosepikyantiri Vetarahemini uro ntora. Uro nte taqovata airi nraakye qora nrutu vatarerata nrumu variqatama ekyaa nraamwu piqa kyovaro Mariaava purimakauvanto kyara nro nraamwunraqi variqaro qoraisi nraaqiara mwia nraamwu nraaqiara mwata kyero, mwia qapuqama kyero purimakauvanto kyara nro tanunraqi mwaati mwata tora. ");
INSERT INTO omw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mariaava nraaqiara mwata tovata entaqi vaisi mponramwu mwi mwataraqaa mwukyau vahunani variqata mwihua sipisipiqaa ntaqikyi varura. ");
INSERT INTO omw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mwiqi varuvaro Kotiva nyaamwunyaa vaisi titova mpovanto qamwanrama mwihua suqaa qovarama vuvaro Kotira kepukya inraikyavanto nronraqama kyero iteqaro ntuvaahe varuvata sipisipiqaa ntaqikyi varuhua taqeta nronraqama kyeta aatu hi varura. ");
INSERT INTO omw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aatu hi varuvaro Kotiva tito vaisiva mwihua timwa nyinro tiqaro, Hia aatu hiate. Nte nkyi kyuqe mwakyaakya timwa nyinrenrana tumuqo. Mwi mwakyaakyara ekyaa nraakye qora rieta qamwateqatama varivarave. ");
INSERT INTO omw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mate nkyi haivaqara Ntevitira mwatukyaqi nraaqiara mpo mwata taiho. Mwiva nkyi kyaahaqa hiarivave. Mwiva nronravanto Kotiva titai nraaqiaravave. ");
INSERT INTO omw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ni quara qutaave tirerata nkye vita uro taqaivaro mwi nraaqiarara mwata kyero qapuqama kyero purimakauvanto kyara nre vari tanunraqi mwaati mwata tairaro vaite varianinrama taqevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kotiva titova mwitaa tuvata qamwanrama nyaamwunyaahua ntaqi varuhua airivanto qovarama vita variqata Kotira nrutu tuaahereta tiqata, ");
INSERT INTO omw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Kotiva nai virini varivave. Tire mwia nrutu tuaahere varuro. Mwatani Kotiva qamwata nyate vari vaisihua mwaateraqama variate, tita. ");
INSERT INTO omw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mwihua mwitaa timwa kyetama nyaamwuni tumu ntanteta vuvata sipisipiqaa ntaqikyu vaisihua nai timwa mwi nai timwa mwi hita tiqata, Nrivaqenramwu Vetarahemini nronravanto qua timwa timwinra uro taqaare, tita. ");
INSERT INTO omw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mwitaa timwa kyeta mwihua hianteta vura. Nrumu taqovaro Iosepiva Mariaakyantiri varuvaro nraaqiaravanto purimakauvanto kyara nro tanunraqi vaite varura. ");
INSERT INTO omw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sipisipiqaa ntaqikyu vaisihua uro mwia taqeta tiqatama, Kotiva nyaamwunyaa vaisi titaiva mwaa nraaqiarara mwitaa mwitaamama timwa timwiho, tita. ");
INSERT INTO omw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sipisipiqaa ntaqikyu vaisihua mwitaa tuvata mwi quara riohua qikye timwa kyeta airi vu nraato tiqata varura. ");
INSERT INTO omw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariaava mwi quara nraatoqi vatero nrohiqarovata mwianra rie varura. ");
INSERT INTO omw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipisipiqaa ntaqikyu vaisihua nrumu ntanteta mwihua nyaamwunyaa vaisivanto tu quarara qutaave timwa kyeta, mwihua vaakya taqeta rieta hurara rieqata Kotira nrutu tuaaheraqi vurama. ");
INSERT INTO omw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Iesusira mwata tovaro 8 enta nritarovaro qoraisi nraaqiara varuvatara tita, mwia mwamwanta toqa kye entava nrintovata mwi entaraqaa mwia nrutu nteqatama, Iesusivave, turama. Haaru qumina enta, Mariaava hia nraaqiara tuaqa hu entara Kotiva nyaamwunyaa vaisi titova mwi nrutura mwiate tura rieqata mwi nrutura ntamwa tora. ");
INSERT INTO omw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mariaava nraaqiara mwata tero Mosesiva mwaanra timwa to quara rieqaroma mpo entanramwu vari kyero mwiva kyotataqama quari entava nri ntovata mwivavata, Iosepivavata, Iesusira vita vareta Kotira mwinrenrata Ierusaremini vurama. ");
INSERT INTO omw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nronravanto mwaanra tu quara qara ntumwa tova mwitaama tiro: Ekyaa qoraisi nraaqiara nraamwuqama kyera mwata tenanra Kotira mwinranro mwiani variarive. ");
INSERT INTO omw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mwi entara e Kotira nraamwuqi uro ntera nyaamwa taaratana minrunra voti hira mwinranro Kotirani qiaqaa kyairaro itamwa taiqa kyaarive, tura. Mariaakya Iosepikya mwi quara rieqatama Ierusaremini vura. ");
INSERT INTO omw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ierusaremini uro varuvaro mwini vaisi mpo Simioniva varura. Mwi vaisiva avuqavuma kyero nrohiqaro Kotira nrutu tuaahere varuva variqaro mwiva Isareri mwatanaahuaqa ntaqikyiani vaisirara taqe varura. Taqe varuvaro Kotira mwanraquravanto mwiavata variqaro ");
INSERT INTO omw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","vuni mwia timwa mwinro tiqaro, E hia qati qutu vinanrave. E nronravanto titaani vaisira, Mesaiaa mwia taqera qutu vinanrave, tura. ");
INSERT INTO omw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kotira mwanraquravanto mwitaa tuvaro Simioniva varuvaro mwi entara Kotira mwanraquravanto mwia vitero Kotira nraamwuqi vuvata Iesusira nrohua qohua nkyiari mwaanra qua rieqatama Iesusira vita vareta Kotira nraamwuqi vuvaro ");
INSERT INTO omw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioniva nraaqiara mwia taqero mwia kyavuhu kye tutero Kotira nrutu tuaaherero tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Nronrao, e haaru turava mate qutaama qovarama viho. E qioma ni ena kyaiqa vaisi titairaro ni mutukyaqitairo kyuqe hiraqe quankye. ");
INSERT INTO omw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Ekyaa mpo mwatanaa mpo mwatanaahua taqaate tira, e tiri kyaahaqa hianinra mwia titaarana nte mate ntena puqotaina mwia taqauqo. ");
INSERT INTO omw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mwiva omwa votima kyero itamwaqiro vi varirata nkyiariara qumina mpo mwatanaa mpo mwatanaahua i okyara ntapihi kyeta taqevarave. Mwi vaisiva i nraakye qora Isareri kyaahaqa hiraro mwihua nrutuvanto nronraqa hiarive, tiro. ");
INSERT INTO omw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simioniva mwitaa tuvata Iesusira nrohua qohua airi nraato tita tiqata, Qikye, nanra quave mwiva Iesusirara tiho? tuvaro ");
INSERT INTO omw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioniva Kotirara aakyara ntero tiqaro, E mwitanahuavata mwihua nraaqiara mwiavata kyuqema nyataante, tiro. Timwa kyero mwiva mwia nronra Mariaara timwa mwinro tiqaro, Riaante. Kotiva titai nraaqiarava mwaava varirata Isareri vaisi mpo nramwuvanto mwiaqaatai tumu ntita uaqiama vi varivata mponramwuvanto mwia qamwata mwateta mwihua sivita kyuqema varivarave. Kotiva nai okyara nraakye qoravanto taqaate tiro, nraaqiara mwia titaiva varirata nraakye qora airivanto mwia qoririma mwatevarave. ");
INSERT INTO omw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nraakye qora airivanto vu nraato tutera mwiva qovarama kyaananrove. E variraro nraamwunruqa taari inraikyava paipa voti hiariva i mwutukya ruananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Simioniva Mariaarara mwitaa tuvaro poropeti nraakye Kotira qua qovarama kyeqaro timwa nyi varu nraakyeva Anaavavata varura. Mwia qova Panueriva Asara okyaravanto varura. Anaava qoraisi varatero 7 ihi vara kyovaro ");
INSERT INTO omw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","mwia vaativanto qutu vuvaro mwiva mwiaqaatairo tetoqaqama kyero variqiro viro kyontaqama viro airi ihi 84 ihi vara kyero, mwiva mpo enta mpo enta Kotira nraamwuqi uro nteqaro entaqivata, iheravata, Kotira nrutu tuaahereqaro kyara aurama tero Kotirara aakyara ntamwaqiro vi varura. ");
INSERT INTO omw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mwitaa huvara tiro, mwi entara Anaava Kotira nraamwuqi vera ntero Iesusira taqero nraaqiara mwianra rieqaro Kotirara kyuqeve tura. Mwitaa tuvata mpo uhua mwini varita Kotiva mwihua kaahaqa hirata Ierusaremiqi kyuqema varirara vekya varura. Mwi nraakye qorahua varuvaro Anaava Iesusira okyarara mpo qua mpo qua mwihua timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Anaava mwitaa tuvata Iosepikya Mariaakya nronravanto mwaanra qua tura rieqata ekyaa mwi kyaiqara vara taiqa kyeta, mwitanahua nraaqiara mwiavata viteta tumu ntanteta nkyiari mwaata Kariri mwata Nasaretini vurama. ");
INSERT INTO omw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwini varuvaro nraaqiara mwiva nronra tuero kepukyaqama viro varuvaro mwia vu nraatovanto kyuqema vahuvaro Kotira kyuqe huva mwiavata vahura. ");
INSERT INTO omw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Iesusira nrohua qohua mpo ihi mpo ihiqi Ierusaremini uro variqata vekyahu nyato entaraqaa kyara nreta tumu ntanteqata nkyiari mwaatani vivi hurama. ");
INSERT INTO omw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iesusiva 12 ihi vara kyovaro vekyahu nyato kyarara nre entava nri ntovata Mariaakya Iosepikya Iesusiravata viteta nauqaa hunte Ierusaremini mwi kyarara nranrenrata vurama. ");
INSERT INTO omw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Uro mwini mpo entanramwu variqata mwi kyarara nramwa kyeta tiqata, Kyai teta mwaatani tumu ntante quare, timwa kyeta vuvaro Iesusiva nraahu Ierusaremini varuvata mwia nrohua qohua hia mwianra riaraitita vita. ");
INSERT INTO omw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mwitanahua tiqata, Mwiva vaakyama mpo hiahua kyapata viho, timwa kyeta aanraqaa kuaa enta uro vaiteta tiqata, Kyaiqe mwia puaama kyeta taqaare, timwa kyeta nkyiari nramwunaahuaqi puaama kyeta taqovaro ");
INSERT INTO omw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","hia mwihua utaqi huvata Mariaakya Iosepikya nrumu ntanteta Ierusaremini mwianra puaa hirerata vurama. ");
INSERT INTO omw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ierusaremini nrumu ntanteta uro taarampo enta mwianra puaamaqi vita taqovaro mwiva nraamwu nronra Kotira nraamwuqi variqaro nronra vaisi Iutaa mwaanra okyara timwa nyi varu vaisihua utaqaa mwatakyaa viro variqaro vaisi nronra mwihua qua rieqaro mwihua kyapara hi varura. ");
INSERT INTO omw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iesusiva nronra vaisinramwu utaqaa mwatakyaa viro varuvata nronra vaisinramwu qua tuvaro Iesusiva mwihua qua rieqaro mwiva nkyiari timwa nyuvata mwihua tiqata, Qikye, nronra tuaahua qiantema kyero mwaa nraaqiarava qua ti variho, tita. ");
INSERT INTO omw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mwihua mwitaa ti varuvata mwia nrohua qohua nri nteta taqovaro Iesusiva vaisi nronranramwu utaqaa mwatakyaa viro varuvata mwitanahua tiqata, Qikye, mwiva vaisi nronra utaqaa variqaroma qua ti variho, timwa kyeta mwia nrova tiqaro, Ni maaquo, nanraqamave tiritana mwitaama timwa taaro? Tiretana i nrohua qohua iara nronra vu nraato tita i puaa hirerata nrunro, tiro. ");
INSERT INTO omw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mwia nrova mwitaa tuvaro Iesusiva qaqao tiro, Nkyetana nanraqamave nianra puaa hi variavo? Nkyetana hiave ntapihiavo? Nte ntena kora kyaiqa vare variarivama varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iesusiva mwitaa tuvata mwitanahua hia mwi quara okyara ntapihura. ");
INSERT INTO omw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hia ntapihuvaro Iesusiva mwiaqaatairo siviro nai nrohua qohua vatama kyero nrumu ntantero Nasaretini uro variqaro mwitanahua qua riemwaqiro viqaro hia mwitanahua qua raaqiraitiro varura. Mwia nrova Iesusiva tu qua qianinra nai nraatoqi vatero nrohiqaro riemwaqiro vura. ");
INSERT INTO omw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesusiva nronra tuemwa vuvaro mwia vu nraatovanto ntapihi vuvaro kyuqe vu nraato vahuvaro Kotira mwutukyavantovata nraakye qora mwutukyavantovata mwianra vahurama. ");
INSERT INTO omw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Romeni mwatanaahua vunyaa vaisi Taiperiaasi Sisaava ntaqikyiqi viqaroma 15 ihi vara kyovaro mwi entara Pontiaasi Pairaativa kirapava vunyaava Iutia mwataqaa ntaqikyi varuvaro Herotiva Kariri mwataqaa ntaqikyi varuvaro Herotira qatavanto Piripiva Ituriaa mwataqaavata Terekonaitisi mwataqaavata ntaqikyi varuvaro Raiseniaasiva Apirini mwataqaa ntaqikyi varura. ");
INSERT INTO omw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Mwitaa huvaro Anaasivavata Kaiapaasivavata nronraqama vita Kotira nraamwuqi variqata Kotira kyaiqa vare varu vaisihuaqaa ntaqikyi varura. Mwi entara Sekaraiaara mwaaqu Ioniva qumina mwata, hia vaisivanto varunani varuvaro Kotiva mwianra ni qua timwa nyiante tuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kotiva tuntema kyero Ioniva Iotaani nramanrivanto tumunani viro nrinro hiqaro qua mwakyaakya nraakye qora timwa nyinro tiqaro, Uaqia hi aanranra qaqira kyeta nramanri varaivaro Kotiva nkye uaqia hi inraikyara utua quara nruka nyataarive, tiro. Ioniva mwitaa ti varura. ");
INSERT INTO omw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Haaru qumina vakya Kotiva kyaahaqa huvaro poropeti vaisi Aisaiaava mwitaama tiro: Mpovanto qumina mwatani variqaro aakyara ntero tiqaro, Nronravanto quaninra aanra terama mwateta mwia aanra ntapihi mwataivaro mwiva mwivauma qio quarive. ");
INSERT INTO omw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nkye nrunro aakuntu vahianinraqi quvu ntahirama kye, taaqi nronrave, taaqi patave, nkye mwia teqa kyaivaro aanravanto ntapihi vahiarive. Aanra vi nteqe nri nteqe hianinra teqa kyaivaro kuaavau ntapihi kyero vahiarive. Aanra uaqia hiro ori uvi auquqa hiariva vahianinra teqa kyeta kyuqema taivaro vahiarive. ");
INSERT INTO omw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ekyaa mwata maata vahintema varihua Kotiva mwitaama kyero nraakye qora huvantu nyatero sitaaninra mwia okyara taqevarave, tura. Asaiaava haaru qumina vakya mwi quara tuvaro Ioniva nri ntero qutaa mwi quara turama. ");
INSERT INTO omw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ioniva mwitaa ti varuvata nraakye qora airivanto nramanri vararerata nruvaro Ioniva mwihua timwa nyinro tiqaro, Nkye quaiha uaqia hira nraaqiarama variavo. Kotira raraqa taiharo nraakye qora rirero uti variho. Tava nkyiara tiqaro, Nkyivata ruarivaarave. Hiante aatu quate, tihatave nkye mwaini nte hunani nriavo? ");
INSERT INTO omw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nkye qutaaqama kyeta uaqia hi kyaiqara qaqira kyaivera, nkye mpo kyuqe kyaiqa nraahu varaivaqe taqaare. Nkye nkyeta tiqata, Evarahaamuva tiri haivaqavave, tiri tiqovave, varurara tita, tire mwia nraaqiaravanto variqata tire qio varuro, tivorave. Kotiva mwitaa hiataa hiraro mwiva qioma nkyi qaqira kyero ori mwaahua tuqasaa kyairata vaisi varita Evarahaamunra nraaqiara varivarave. ");
INSERT INTO omw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kotiva kyatari tuqirero kyaari kyatari okyaraqi terama taiho. Hia tamwa kyuqera riaaninra teqa kyero qiaqi kyairaro itamwa kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ioniva mwitaa tuvata mwihua mwia kyapara hita tiqata, Qikye, mwi quara rieta tire nataave hiananrave? ");
INSERT INTO omw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","tuvaro mwiva mwihua timwa nyinro tiqaro, Vaisi mpovanto sioti taaratana vaterava hia vataaninravata mpoku mwiante. Kyara vaterava hia vataaninravata ntainra kyera mwiante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mwitaa tuvata taakisi vare varuhua nramanri vararera nruhua mwia kyapara hita tiqata, Mwaanra ti variarao, mpo tire? Nataave hiananrave? ");
INSERT INTO omw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","tuvaro Ioniva mwihuavata timwa nyinro tiqaro, Nkye taakisi vareqata kirapara qua rieqata ntapihi kyeta taakisi varaate. Hia nkyeta riemwa kyeta mpoqiavata varaate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ioniva mwitaa tuvata qaami vaisivanto mwia kyapara hita tiqata, Mpo tire? Tire nataave hiananrave? tuvaro Ioniva mwihua timwa nyinro tiqaro, Hia uro mporara i ntuqutu kyaarorave munima timwiante qiate. Hia unra timwa kyeta mporaqaa qua vataate. Nkye qaami kyaiqa vareqata munima varera mwianra qiove qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ioniva mwitaa tuvata nraakye qora mwihua Kotiva titaani vaisira Mesaiaa mwia vekyaqa hiqata varuhuara tita, mwihua nkyiari rieta tiqata, Mwaa vaisivave Mesaiaavanto tiri kyaahaqa hiariva variananrove? tita. ");
INSERT INTO omw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mwihua mwitaa ti varuvaro Ioniva riero mwihua nkyiari timwa nyinro tiqaro, Nte qumina nramanri nkyi nyi varuqo. Nronravanto ni nraataraariva ni naakiara nri variho. Nte qumina vaisivantora tina, nte mwiva kyuqu nraamwu rupa tai kyaantara hiama qio huvantu mwataaninrave. Nkye nramanri varaantema kyero mwiva Kotira mwanraquravata, qiavata, nkyi nyiananrove. ");
INSERT INTO omw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mwiva nai kyavoi kyauquqi tu varero kyakuma voti hira ntitatama kyero nronra mwia vaqitaqiro uro nai kyara nraamwuqi vatero kyapivata mwanrevata vaqitaqiro uro hia qipa quani qiaraqi tuto kyairaro itamwa kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mwitaa timwa kyero nraakye qoravanto ntapihi kyeta mwia qua riaate tiro, Ioniva mpo qua mpo qua mwihua timwa nyinro. Iesusiva nriani quara kyuqe qua mwihua timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herotiva Kariri mwataqaa ntaqikyi varuvaro Ioniva Herotira inronra hiro tiqaro, Herotiva hia nai qata nraata Herotinamainra varaataarave. Mwiva mwi kyaiqaravata uaqia hi kyaiqara kyaatavata uti varivave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ioniva mwitaa tuvaro Herotiva mwia kyaara Ioninra karavuqi kyora. Mwitaa hiqaro Herotiva uaqia hi kyaiqara mpoqiavata utura. ");
INSERT INTO omw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ioniva nramanri nyi varu entara mwiva Iesusiravata nramanri mwunra. Iesusiva nramanri varero Kotirara aakyara nte varuvaro nyaamwuvanto qatua vuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kotira mwanraquravanto nyaamwusairo nyaamwa minrunra votihuva tuminro Iesusiraqaa tumu vahuvaro quavanto nyaamwusairo mwitaama tiro: E ni maaquvanto variaro. Ni mutukyavanto iara vaiho. Nte iara qamwateqana varuqo, tiro. Tura. ");
INSERT INTO omw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesusiva 30 ihi vara kyero mwiaqaatairo nai kyaiqa toharama kyero varaqiro vuvata nraakye qoravanto mwianra Iosepira mwaaquve tura. Iosepiva Hiraira mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hiraiva Mataatira mwaaquvanto varuvaro Mataativa Rivaira mwaaquvanto varuvaro Rivaiva Merakaira mwaaquvanto varuvaro Merakaiva Ianainra mwaaquvanto varuvaro Ianaiva Iosepira mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iosepiva Matataiaasira mwaaquvanto varuvaro Matataiaasiva Emosira mwaaquvanto varuvaro Emosiva Neaminra mwaaquvanto varuvaro Neamiva Esaraira mwaaquvanto varuvaro Esaraiva Nakaira mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakaiva Meatira mwaaquvanto varuvaro Meativa Matataiaasira mwaaquvanto varuvaro Matataitaasiva Semeninra mwaaquvanto varuvaro Semeniva Iosekira mwaaquvanto varuvaro Iosekiva Iotaara mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Iotaava Ioanaaninra mwaaquvanto varuvaro Ioanaaniva Resaara mwaaquvanto varuvaro Resava Serapaperira mwaaquvanto varuvaro Serapaperiva Siaritierira mwaaquvanto varuvaro Siaritieriva Neraira mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neraiva Merakaira mwaaquvanto varuvaro Merakaiva Etaira mwaaquvanto varuvaro Etaiva Kosaaminra mwaaquvanto varuvaro Kosaamiva Erametaaminra mwaaquvanto varuvaro Erametaamiva Eaara mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eaava Iosuaara mwaaquvanto varuvaro Iosuaava Eriesaara mwaaquvanto varuvaro Eriesaava Ioriminra mwaaquvanto varuvaro Iorimiva Mataatira mwaaquvanto varuvaro Mataativa Rivaira mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Rivaiva Simioninra mwaaquvanto varuvaro Simioniva Iutaara mwaaquvanto varuvaro Iutaava Iosepira mwaaquvanto varuvaro Iosepiva Ionaaminra mwaaquvanto varuvaro Ionaamiva Eraiakiminra mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eraiakimiva Meriaara mwaaquvanto varuvaro Meriaava Menaanra mwaaquvanto varuvaro Menaava Matataara mwaaquvanto varuvaro Matataava Netaaninra mwaaquvanto varuvaro Netaaniva Ntevitira mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ntevitiva Iesira mwaaquvanto varuvaro Iesiva Ompetira mwaaquvanto varuvaro Ompetiva Mpoaasira mwaaquvanto varuvaro Mpoaasiva Saramoninra mwaaquvanto varuvaro Saramoniva Nasoninra mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoniva Aminantaapira mwaaquvanto varuvaro Aminantaapiva Atimininra mwaaquvanto varuvaro Atiminiva Anainra mwaaquvanto varuvaro Anaiva Hesaroninra mwaaquvanto varuvaro Hesaroniva Peresira mwaaquvanto varuvaro Peresiva Iutaara mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Iutaava Iaikopura mwaaquvanto varuvaro Iaikopuva Aisaakira mwaaquvanto varuvaro Aisaakiva Evarahaamunra mwaaquvanto varuvaro Evarahaamuva Teraara mwaaquvanto varuvaro Teraava Nehora mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nehova Seraakira mwaaquvanto varuvaro Seraakiva Riura mwaaquvanto varuvaro Riuva Perekira mwaaquvanto varuvaro Perekiva Ipaara mwaaquvanto varuvaro Ipaava Siraara mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Siraava Kenaaninra mwaaquvanto varuvaro Kenaaniva Apaakisatira mwaaquvanto varuvaro Apaakisativa Seminra mwaaquvanto varuvaro Semiva Noaanra mwaaquvanto varuvaro Noaava Remekira mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Remekiva Metusaraara mwaaquvanto varuvaro Metusaraava Inokura mwaaquvanto varuvaro Inokuva Ieretira mwaaquvanto varuvaro Ieretiva Mahararira mwaaquvanto varuvaro Maharariva Kenaaninra mwaaquvanto varuvaro Kenaaniva Inosira mwaaquvanto varuvaro ");
INSERT INTO omw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Inosiva Setira mwaaquvanto varuvaro Setiva Ataamunra mwaaquvanto varuvaro Ataamuva Kotira mwaaquvanto varura. ");
INSERT INTO omw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","(Ioniva Iesusira nramanri mwi kyovaro mwiaqaatairo) Kotira mwanraquravanto Iesusiraqi piqa kyovaro Iotaani nramanri kyero nrumu ntantero vuvaro Kotira mwanraquravanto mwia vitero hia vaisivata varura qumina mwataqaa uro kyora. ");
INSERT INTO omw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Uro kyovaro Iesusiva 40 enta mwini varuvaro Saataaniva Iesusiva mwia quara eo tiro mwia vataqiro quarive tiro, Iesusira mwataara hura. Iesusiva mwi entara variqiro viqaro hia kyara nrovaro nraataa huvaro varura. ");
INSERT INTO omw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Iesusira nraataa huvaro varuvaro Saataaniva nri ntero tiqaro, E qutaa Kotira mwaaquvanto varirera, ori mwaahuara tirata mpereti tuemwa vivara nraante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tuvaro Iesusiva nai timwa mwinro tiqaro, Qaqao, Kotira mpukuqi qara ntumwa tova mwitaama tiho: Vaisivanto hiama kyara nraahu nramwaqiro viqaro qati variqiro quananrove, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Iesusiva mwitaa tuvaro Saataaniva mwia vitaqiro uro veraraqaa vatero qamwanrama kyero vaisivanto ekyaa mwata maataqa ntaqikyi varura, ekyaa mwi mwatara mwia nraamwutero tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mwaa inraikyara ekyaa ni mpiharo nini nraahuma vaiho. Nte mwaa inraikyara vaisi mpo mwiataa hiraqe qioma mwianinrave. Nte qioma mwaa inraikyara i mwianrinro i nrutuvanto nronraqama virara e mwi inraikyaraqaa ntaqikyiqira vinanrave. ");
INSERT INTO omw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","E ni nutu nraahu tuaahera matairera, nte qioma ekyaa mwaa inraikyara i mwianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mwitaa tuvaro Iesusiva nai timwa mwinro tiqaro, Qaqao, Kotira mpukuqi qara ntumwa tova mwitaama tiho: Kotiva nronravanto varirara tira, e mwia kyaiqa nraahu vara mwatera mwia nrutu nraahu tuaaheraante, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mwitaa tuvaro Saataaniva mwia vita varero Ierusaremini vuva uro Kotira nraamwu qiataqaa nai nyaamwuni vahuraqa kyero tiqaro, E qutaa Kotira mwaaquvanto varirera, mwaaqaataira kyavuhu vira mwatasata mpuamu ntaante. ");
INSERT INTO omw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kotira mpukuqi qara ntumwa tova mwitaama tiho: Kotiva tirata nyaamwunyaahua iqaa kyuqema ntaqikyivarave, turave. ");
INSERT INTO omw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Qaiqaavata tiqaro, E ena kyuqu oriqa ntuteqa kyerorave tita, nyaamwunyaahua nkyiari kyauquqotaita i tu vareta vivarave, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Saataaniva mwitaa tuvaro Iesusiva nai timwa mwinro tiqaro, Qaqao, Kotira mpukuqi vahi quava tiqaro, Nronra Kotiva i mwanriqavanto varirara tira, e hia mwia mwataara hiante, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mwitaa tuvaro Saataaniva Iesusira qumina mwataara hi taqero, kyai qaiqaa mpo enta mwia mwataara hiankye timwa kyero, Iesusira qaqira mwini kyero vurama. ");
INSERT INTO omw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Saataaniva vuvaro Kotira mwanraquravanto Iesusira kepukya mwuvaro mwiva nrumu ntantero Karirini uro varura. Mwini uro varu quara ekyaa mwi mwataraqaa varu nraakye qorahua riemwa ntora. ");
INSERT INTO omw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iesusiva mwihua mwaanra nraamwu mpoqi mpoqi vera ntero variqaro qua timwa nyi varuvata nraakye qoravanto mwia nrutu tuaahereta mwia qamwata mwatora. ");
INSERT INTO omw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iesusiva Karirini uro nrohiqaro nai tauraa nraaqiarakyaa varu mwatukyara Nasaretini uro ntero mwaanra tu entaraqaa mwaanra nraamwuqi nauqaa huntema kyero mwiqi viro. Mwiqi variqaro mwiva Kotira mpuku kyaara ntirero sivuvaro ");
INSERT INTO omw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aisaiaava qara ntumwa to mpukura mwuvaro Iesusiva mpuku ququrama tora huvantu kyero mwaa quara qara ntumwa tora puaama kyero kyaara ntiro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nte kyuqe mwakyaakya vehi nraakye qora timwa nyinrenra huqaro nronravanto ni qiataqaa vahamwenra qu mateqaro ni nronraqama kyero mwaa mwi vaisivave timwa kyero ni mwatama taihana nruqanro mwia mwanraquravanto nivata variqaro ni kyaahaqa hi variho. Mwiva ni titero mwitaama nraakye qora timwa nyiante turave. Rupataa nraakye qorahua qioma qati vivarave, qiante. Vu qipa vihua vu ntapairi kyeta taqaate, qiante. Uaqiama nyataavata muaanraqi variahua qioma qati vivarave, qiante. ");
INSERT INTO omw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nronravanto nraakye qora kyaahaqa hiqaro qamwata nyataari entava nri ntaaninra mwianra nraakye qora timwa nyiante. Mwitaama kyera timwa nyiante, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Aisaiaava qara ntumwa to quara Iesusiva kyaara ntumwa kyero mwiaqaatairo mpuku ququrama kyero vaisi viti mwinro uro mwatakyaa viro. Iesusiva mwatakyaa viro varuvata mwaanra nraamwuqi varuhua mwia nraahu taqe varuvaro ");
INSERT INTO omw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iesusiva mwihua timwa nyinro tiqaro, Vaakya kyaara ntuqata riaa quava mate qutaa mwivauma vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iesusiva mwitaa tuvata mwihua mwianra tiqata, Iesusiva vaisi kyuqevave. Qikye, mwia nroqitairo kyuqe qua nriho, tita. Mwitaa timwa kyetavata qaiqaa mwianra tita, Qaqao, mwiva Iosepira mwaaquvantoma variho, tita. ");
INSERT INTO omw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mwihua mwitaa tuvaro Iesusiva mwihuara tiqaro, Nraakye qora mpo quaqaa ntumwa kyeqata qia quaraqitaita nkye nanra quave nianra tivarave? Mwihua mpo qua tiqata, E totaavanto hirera, enavanto ena mwamwanta kyaahaqa hiante, qia quarave nianra tivarave? Nkye qaiqaa mwaa quarave nianra tivarave? Kapenaamini variqara nronra kyaiqa varaaro qiavata riaunanra e mwaaqi ena mwatukyaqivata variqara mwi kyaiqara varaanteve, tivarave. Nkye nianra mwitaave tivarave? tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mwitaa timwa kyero Iesusiva mwihua timwa nyinro tiqaro, Poropeti vaisivanto nai mwaatani varirata mwia nramwunaahua hia mwia qua rievarave. ");
INSERT INTO omw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Riaivaqe nte nkyi timwa nyiankye. Haaru nkyi haivaqava Iraisaava qati varu entara mwaini Isareri mwatani huari nronraqama kyero itamwaqiro vuvaro taarampo ihi 6 torara hia vati ntuvaro hia mwi mwataraqaa kyaravata vahuvata mwi entara tetoqa nraakye airinramwuvanto varurave. ");
INSERT INTO omw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mwihua varuvaro Kotiva hia Iraisaara mwi nraakyehua varunani titaraitiro, mwiva Iraisaara titovaro mwiva mpo mwatanaa nraakye tetoqavanto Sarepaati mwatukya Saitoni mwaatani varura kyaahaqa hirero vurave. ");
INSERT INTO omw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Haaru nkyi haivaqava mpo, Iraisaava poropeti vaisivanto varu entara Isareri mwatani vaisi airinramwu rumpuaravanto mwamwanta nramwaqiro vuhua varuvaro Iraisaava hia mwihuaqitairo vaisi mpo kyaahaqa hiraitiro, mwiva mpo mwatanaa vaisi, Neamaaninra nraahu Siriaa mwatanyaanra, kyaahaqa huvaro mwia rumpuaravanto tavanta vurave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iesusiva mwitaa tuvata mwaanra nraamwuqi varuhua mwi quara riovaro mwihua raraqa tovata ");
INSERT INTO omw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","sivita Iesusira ntavaaqavu kyora. Nasareti mwatukya mwiva taaqiqaa vahuvatara tita, mwihua mwia ntanrauqita uro okaiqi tuto kyarera huvaro ");
INSERT INTO omw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Iesusiva nraakye qora uta mwiaqaa vitarero qati vivura. ");
INSERT INTO omw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iesusiva vuva Karirini vau mwatukyara Kapenaamini uto ntero mwini variqaro mwaanraqaa nraakye qora qua mwakyaakya timwa nyi varuvata mwihua Iesusira qua rieta ");
INSERT INTO omw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","qikye tita, Mwiva nronra vaisi votima kyero kepukya qua timwa timwi variho, tita. ");
INSERT INTO omw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mwitaa ti varuvaro vaana uaqia hu inraikyava mwia utaqi varu vaisiva paatiro aakyara ntamwa kyero tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Iesusio, e Nasaretinyaavave. E tiri nataa hirerarave nrianro? E tiri uaqiama timwa tarerarave nrianro? Nte i ntapihi kyauqo. Kotiva i titaihara e Kotira kyaiqa nraahu vare variarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mwitaa tuvaro Iesusiva vaana mwia inronra hiro tiqaro, Tirema variante. Mwi vaisiraqitaira nritarera quante, tiro. Mwitaa tuvaro vaana mwiva nraakye qora suqaa mwi vaisira vara kyero tuto kyovaro mwiva mwatasata tumu ntuvaro vaana mwiva hia vaisi mwia riraitiro, mwiaqitairo nritarero qatinani viro. ");
INSERT INTO omw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vaanavanto nritarero qatinani vuvata mwiqi varuhua nrihanrama vita kyauqu ntukikinraaqa teta nai timwa mwi nai timwa mwi hita tiqata, Mwiva nataama kyero mwitaa tiharove nritaraiho? Mwiva nronra vaisi votima kyero kepukya qua ti varihata vaanavanto mwia qua rieta mwihua nritareta vi variarave, tita. ");
INSERT INTO omw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mwihua mwitaa timwaqita vita nrita huvata ekyaa mwi mwatara vara ututu varuhua mwi quara riemwa ntora. ");
INSERT INTO omw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesusiva mwaanra nraamwuqitairo veva ntero Saimoninra nraamwuqi uro varuvaro Saimoninra nrinraatarara nriqa vuvaro mwia mwamwanta qiara utovaro varuvata mwihua uro Iesusirara mwia kyaahaqa hiante tuvaro ");
INSERT INTO omw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iesusiva uro nraakye mwia nraaqani siviro variqaro nriqa vu inraikyara mwia titovaro mwiva taiqa vuvaro nraakye mwiva siviro qamwanrama kyero kyara mwihua nyunra. ");
INSERT INTO omw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mwitaa huvaro huarivanto mpuani qio vi varuvata mwi mwatanaahua nkyiari nramwunaahua mpo qara mpo qarama kyero nriqa vuhua sita vareta Iesusiva varunani uro kyovaro mwiva nai kyauqu kuaa kuaa mwihuaqaa vatovata ekyaa mwihua kyuqema vura. ");
INSERT INTO omw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Vaanavantovata airi nraakye qora utaqitaita nritare viqata aakyara nteta tiqata, E Kotira mwaaquvanto variaro, tita. Mwihua mwitaa tiqata Iesusiva Mesaiaavanto varura mwia okyara ntapihi kyovarora tiro, Iesusiva mwihua inronra hiro tiqaro, Tirema variate, tiro. Tura. ");
INSERT INTO omw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mwia qanranraa qaata tovaro Iesusiva mwi mwatukyara kyero qumina mwatani vuvata nraakye qoravanto mwia puaa hirera vuhua uro mwia puaama kyeta Iesusiva hia mponani quarive tita mwia antuovaro ");
INSERT INTO omw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Iesusiva qaqao tiro, Nte Kotiva ntaqikyiani mwakyaakyara kyuqera mpo mwatukya mpo mwatukya nrohiqana timwa nyinrenrave. Kotiva mwi kyaiqarara ni titaihana nte tumuvave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mwitaa timwa kyero Iesusiva vuva uro Iutiaani nrohiqaro mwaanra nraamwu mpoqi mpoqi uro variqaro mwakyaakya timwa nyi varura. ");
INSERT INTO omw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mpo enta Iesusiva Kenesareti rumpua tokyasataa siviro varuvata nraakye qora airivanto Kotira qua riarerata nai rataaqi nai rataaqi hi varuvaro ");
INSERT INTO omw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iesusiva taqovaro mpotu taaratana nramanriqitai ventaqi nrumu tokyani vatova vahura. Tavukya kyaiqa vare varuhua mpotu mwia mwini kyeta vahe haqirarerata vuvaro mpotuvanto mwini vahuvaro ");
INSERT INTO omw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iesusiva vuva uro Saimoninra mpotuqi mwaanri ntero variro Saimoninranra tiqaro, Venta kyairaro pataqia nramanriqi uromwi vahiarive, tiro. Mwitaa tuvaro venta kyovaro Iesusiva mpotuqi mwatakyaa viro variqaro nraakye qora mwakyaakya timwa nyinro. ");
INSERT INTO omw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iesusiva mwakyaakya timwa nyi taiqa kyero mwiva Saimoninranra tiqaro, Nkyenramwu mpotu ventaqita rumpua utani uro kyetama vahe ntamwa kyetama tavukya varaate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mwitaa tuvaro Saimoniva qaqao tiro, Nronrao, tirenramwu entaqi qumina kepukyaqama kye kyaiqa utuqi vita hia tavukya mpokuvata varaunanrave. Qio e mwitaa qiarata tire vahe vara kyeta tuto kyarerave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Saimoniva mwitaa timwa kyero mwivavata mpo uhuavata vahe nramanriqi kyovaro tavukya airivanto vaheqi viqetovaro muaanra ntovaro vahevanto ntupema virera utuvata ");
INSERT INTO omw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","mwihua nkyiari henahua mpotu mpoqi varuhuara kyauqu kyaakyamwu huvata nrumu mwihua kyaahaqa hita tavukya mwia pati mwaanri mpotu taara mwitana piqa kyovaro mpotutana muaanra nteqaro nramanriqi vi quaqara hi varura. ");
INSERT INTO omw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimoni Pitaava taqovaro mwitaama vahuvaro mwiva uro Iesusira vuqaa tumu ntiro tiqaro, Nronrao, nte uaqia hi kyaiqara uti varuvave. E ni kyera quante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mwitaa timwa kyero mwivavata mwiavata varuhua tavukya airi varorara rieqata airi nraato ti varura. ");
INSERT INTO omw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sepetira mwaaqutana Iemisikya Ionikya Saimoninravata kuaa kyaiqa mwia vare varutana tavukya airi varora mwianra kyauqu ntukikinraaqa teta airi nraato ti varura. Mwitaa huvaro Iesusiva Saimoninra timwa mwinro tiqaro, Hia aatu hiante. Mate mwaa iheraraqaataira e tavukya varaarantema kyera nraakye qoravata sitenanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iesusiva mwitaa tuvata mwihua mpotu ntanrauqita uro nramanri tokyani vateta ekyaa inraikya qaqira kyeta Iesusira vataqita vura. ");
INSERT INTO omw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mpo enta Iesusiva mwatukya mpoqi uro varuvaro tauma rumpuaravanto uaqiama kyo vaisiva mwini varuva Iesusira taqero uro mwia vuqa tumu ntiro nai viri mpiami mwataqi vatero po tiro tiqaro, Nronrao, e ni kyaahaqa hiataa hirera, e qioma ni mamanta kyuqema matenanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mwitaa tuvaro Iesusiva nai kyauqu mpiami mwia mwamwantaqa vatero tiqaro, Nte mwitaa hiataa ihana mwitaama mwatarerave. Nte iara kyuqema quante tuqo, tuvaro tauma rumpuaravanto mwia mwamwanta nre varuva qamwanrama tavanta vuvaro mwiva qio varura. ");
INSERT INTO omw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Qio varuvaro Iesusiva mwianra kepukyaqama kyero tiqaro, Hia mpohua timwa nyinraitira, viraro Kotira kyaiqa vara mwate variari vaisiva i mwamwanta taqaarive. Mwiaqaataira e Mosesira mwaanra qua rieqarama munra quani qiara qurairata nraakye qoravanto iara tiqata, Qutaama mwia mwamwantavanto kyuqema viho, qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iesusiva qao tuvarovata mwi quava viro nrinro huvata nraakye qora airivanto mwi quara rieta tiqata, Kyai tirevata Iesusiva varinani uro mwia qua riaararo mwiva tirivata kyuqema timwataarive, timwa kyeta mwiva hunani nrumu ntuvaantua hura. ");
INSERT INTO omw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mwitaa huvaro Iesusiva mwihua kyero Kotiravata qua tirero mpo nani hia vaisivata varunani uro varurama. ");
INSERT INTO omw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mpo enta Iesusiva mwakyaakya timwa nyi varuvata Parisinramwuvata, mwaanra okyara tuhuavata, mwia qua riarerata ntuvaantuama vita varura. Mwihua ekyaa Kariri mwata hini hini vahu mwatukyaraqinaahuave, Ierusareminyaahuave, hisai hisaita nrumu mwatakyaa vita varuvaro Kotiva Iesusira kepukyaqama kyovaro mwiva nraakye qora nriqa vuhua kyuqema nyataariva varura. ");
INSERT INTO omw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Varuvata vaisi mponramwuvanto nkyiari hena vaisi mpo mwia mwamwanta hia qakyaa hura taintamaqita nri nteta tiqata, Kyai nraamwuqi vera nteta Iesusira vuqaa kyaare, timwa kyeta taqovata ");
INSERT INTO omw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","nraakye qora airivanto varuvata mwihua nraamwu utaqi vera nteva hia qioqa hura. Hia qioqa huvata mwihua qaqira kyeta nraamwu qiataqa mwi vaisira vara mwaanri vateta nraamwu qiata mwia mpona ntapairi kyeta vaisi mwia taintaqaa vateta kyaantaqo rupa kyeta qakyoma kye kyaqi vuvaro Iesusira nraaqani uto vahura. ");
INSERT INTO omw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mwia viteta nru vaisihua kepukyaqama kye rieta tiqata, Qioma Iesusiva mwi vaisira kyuqema kyaananrove, tura Iesusiva ntapihi kyero mwiva mwamwanta hia qakyaa hu vaisira mwianra tiqaro, Ni maaquo, e Kotira qua nteqa kyaananra nte i nrukama mwatauqo, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mwitaa tuvata mwaanra okyara tu vaisihuavata, Parisi vaisinramwuvata, qaqao tita nkyiari nai timwa mwi nai timwa mwi hita tiqata, Mwaa ta vaisivave? Mwiva mwitaa tiqaro mwiva Kotira uaqiama mwate variho. Hiama qumina vaisi mpovanto nai hena vaisiara tiqaro, E Kotira qua nteqa kyaananra nrukama mwatauqo, qiananrove. Kotiva nraahuma qio mwitaa qiananrove, tita. ");
INSERT INTO omw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mwihua mwitaa tuvaro Iesusiva mwihua su nyaatoqi mwi quava vahura taqero mwihua kyapara hiro tiqaro, Nanraqamave nkye mwitaama kyeta riaavo? ");
INSERT INTO omw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nkye nianra tiqata, Mwiva qumina vaisi variqarora tiro, hiama qio nai hena vaisivanto Kotira qua nteqa kyaaninra nruka mwataananrove, qiarave. Qio mpo kyaiqa mpo? Qiove nte mwaa vaisira kyuqema kyaaninrave? Nkye ni timwa mpivaqe riaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Iesusiva mwitaama kyero mwihua kyaparama nyatero mwihuara tiqaro, Nte mwatani mwatatai nraaqiarava varuqaro ni nronraqama kyaihana nte qioma mwatani variqana vaisivanto Kotira qua nteqa kyaaninra nruka mwataaninrave. Nkye ni quara qutaa quave qiate tina, nte vaisi mwaanra mwaa quara tirerave, tiro. Mwitaa timwa kyero mwamwanta hia qakyaa hu vaisirara tiqaro, Sivira ena taintavata varera ena mwaatani quantema tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mwitaa tuvaro mwi vaisiva mwihua su mwiaqaa siviro nai taintavata tu varero Kotira nrutu tuaaheraqiro viqaro nai mwaatani vura. ");
INSERT INTO omw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mwiva vuvata mwiqi varuhua nrihanrama vita kyauqu ntukikinraaqa teta mwihua aatu hita Kotira nrutu tuaahereta tiqata, Qikye, nataa hi kyaiqarave? Tire mate nraahumwa mpo qara hi kyaiqara taqauro, tita. Mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iesusiva veva ntero taqovaro taakisi vare varu vaisiva mwia nrutu Rivaiva taakisi vare varu nraamwunraqi mwatakyaa viro varuvaro Iesusiva mwia timwa mwinro tiqaro, E ni naakiara nriante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mwitaa tuvaro Rivaiva siviro ekyaa nai kyaiqa varo inraikyara kyero Iesusira nraakiara vurama. ");
INSERT INTO omw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Rivaiva nai nraamwuqi Iesusirani kyara uta mwatovata airi vaisi taakisi vare varuhuavata, mpo vaisinramwuvata, ntuvaantuama vita mwia nraamwuqi mwatakyaa vi variqata kyara nre varura. ");
INSERT INTO omw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mwiqi varuvata Parisi vaisinramwuvata, mwaanra okyara tu vaisinramwuhua Parisi qua riohuavata, mwihua uro nteta Iesusira nraaqiaranramwuanra nrutu nraunru/nrunru nraanru tita tiqata, Qaqao, nkye nataamaqive taakisi vare varia vaisihuavata, Kotira qua raaqute varia vaisihuavata, kyara nre variavo? tita. ");
INSERT INTO omw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mwitaa tuvaro Iesusiva mwihua nkyiari timwa nyinro tiqaro, Qati vari vaisiva hia totaava hinani virave. Nriqa vi vaisiva nraahu totaava hinani virave. ");
INSERT INTO omw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tire avuqavuma kye nrohi varurahuave qia nraakye qorahua. hia nte mwihuara qora aanra qaqira kyaate tirera tumuvavauma iho. Nte uaqia hia nraakye qorahua nyaanranrenra tumuvave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mwitaa tuvata mwihua Iesusirara tiqata, Ioninra vataqi nrohi varuhuavata, Parisi vaisi qua rie variahuavata, kyara aurama teqata Kotirara aakyara nte variavo. I vataqi nrohi variahua hia mwitaa hiraitita, qatima kyaravata nramanrivata nre variavo, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesusiva mwihua timwa nyinro tiqaro, Nraakye vararera hiari vaisiva nai vataahuavata varirata qiove nkye mwihuara kyara auramate variate tivarave? Hiama qio mwitaa tivarave. ");
INSERT INTO omw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mpo enta nri ntairaro nraakye varaani vaisira nai vataahuaqaataita qatinani vara kyaivata mwi entaraqaataitama mwia vataahua ntateqata kyara aurama tevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mwitaa timwa kyero Iesusiva mpo quaqaa ntumwa kyero mwihua timwa nyinro tiqaro, Mpovanto tuavaaqa nrihi nrahitu quaninra haqira hirero hiama tavuna qaraakya toqa kyero mwiaqaa taaqautero haqiraananrove. Mpovanto mwitaa hirera, mwiva qaraakya tavuna uaqiama kyaananrove. Qaraakya tavuna toqa taarivavata haaruanaa tavunavantovata hia kuaa qarama vahiananrove. ");
INSERT INTO omw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nte qaiqaa tirerave. Uaini qaraakya tati kyero hia mpovanto memenra pahiqo ututaira haaruaa taqu vara kyero qaraakya uaini mwia mwiqi raurirave. Memenra pahi mwiva nraahaqama viraqa mwiva mwitaa hiraro uainivanto kepukya uaini utu viqaro memenra pahi nrahitu kyaananrove. Mwitaa hiraro uainivanto qumina rauru viraro memenra pahivantovata uaqiama quananrove. ");
INSERT INTO omw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hia mwitaa hiraitita, qaraakya uaini qaraakya taquqi rauruarave. ");
INSERT INTO omw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Haaruaa uaini nranra hiva hiama qaraakya uainianra mwia mwutukya vahiananrove. Mwiva tiqaro, Haaruaa uaini mwiva qiove, tirave, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mpo enta mwaanraqaa Iesusiva nai nraaqiaranramwuvata aakyo utaqi kyakuma voti hira uiti tutoraqi nrohi varura. Nrohiqatama mwia nraaqiaranramwu uiti tamwa nteqa kyeta kyauquqi ntautiqama kyeta mwia uru nre varura. ");
INSERT INTO omw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nre varuvata Parisi vaisinramwuvanto mwihua taqeta qaqao tita, Mwaanra entaqaa qao timwa tai inraikyarama mwinramwuhua uti variavo, tita. ");
INSERT INTO omw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mwihua mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Haaru nkyi haivaqava Ntevitivavata, nai mwia vatama kye nruhuavata, kyara nraataa huvata mwihua mwitaa hu quara nkye hiave qaraqi kyaara ntumwa kyeta riaavo? ");
INSERT INTO omw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mwi entara Ntevitiva Kotira nraamwuqi vera ntero mpereti Kotirani vatora vara kyero nreqanro nteqa kyero mwiavata nruhua hini nyuvata nronrave. Kotira kyaiqa vara mwate varia vaisihua nraahu mwi kyarara nraataara vahuvaro Ntevitiva qumina vaisivanto nreqaro mwi quara nteqa kyorave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iesusiva mwitaa timwa kyero mwiva mwihua timwa nyinro tiqaro, Ni mwatani mwatatai nraaqiarara nronraqama kyaihana variqana nte mwaanra entaqaa ntaqikyiqana ntena kyakya hiani kyaiqara qioma varaaninrave, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mpo enta mwaanraqaa Iesusiva mwaanra nraamwuqi uro variqaro mwakyaakya timwa nyi varuvaro vaisi mpovanto mwia kyauqu kyaatuta kukokaqama vu vaisiva varura. ");
INSERT INTO omw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mwi vaisiva varuvata mwaanra okyara tu vaisinramwuhuavata, Parisi vaisinramwuvata, variqata Iesusiraqaa qua vatarerata uti variqata qua puaa hita tiqata, Kyai variqata taqaararo Iesusiva mate mwaanra entaqaa vaisi kyauqu kukoka mwia kyuqema kyairera, mwia kyaara mwiaqaa qua vataare, timwa kyeta mwihua Iesusira apeqa hi varura. ");
INSERT INTO omw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Apeqa hi varuvaro Iesusiva mwihua nkyiari su nyaatoqi riemwa to quara ntapihi kyero kyauqu kukoka mwianra tiqaro, Sivira mwaini vaisi utaqaa nrumu variante, tuvaro mwi vaisiva siviro vaisi utaqaa varuvaro ");
INSERT INTO omw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iesusiva mwihuara tiqaro, Nte nkyi kyapara hiarita nkye mwia hiniqama ni timwa mpiate. Tire teta mwaanra qua rieqatama mwaanra entaqaa nanra nanra kyaiqave qio varaananrave? Tire mwi entaraqaa vaisi mpo kyaahaqave hiananrave, mwia uaqiamave mwataananrave? Mwaanra entaqaa tire vaisi mpo kyaahaqa hiararo mwiva qative variananrove, tire mwia ruve kyaananrave? tiro. ");
INSERT INTO omw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mwitaa timwa kyero Iesusiva ekyaa vaisi mwiqi varuhua itutuma kyero taqero mwi vaisirara tiqaro, Ena kyauqu tutuante, tiro. Mwitaa tuvaro nai kyauqu tutu kyovaro mwia kyauquvanto qamwanrama kyero naitarama vahura. ");
INSERT INTO omw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mwia kyauqu naitarama vahuvata mwihua mpoqama kyero raraqa tovata mwihua nai timwa mwi nai timwa mwi hita tiqata, Tire Iesusira nataamave kyaananrave? tita. Mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mwi entara Iesusiva Kotiravata qua tirero taaqiqaa mwaanri ntero mwiaqaa uro variqaro entaqi Kotiravata qua timwaqiro vi varuvaro ");
INSERT INTO omw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","qaatata vuvaro mwiva mwiavata nrohu vaisihua nyaanrama kyero mwihuaqitairo vaisi 12 nramwu sita kyero mwihua nronraqama kyero mwihuara tiqaro, Nkye aposerive. nkye ni qua uro timwa nyi vaisihuama varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Iesusiva mwaa vaisinramwuhua sitero: Saimoninra. Iesusiva mwia mpo nrutu nteqaro Pitaavave tura, Enturura. mwiva Saimoninra qata, Iemisikya Ionikya, Piripira, Patoromiunra, ");
INSERT INTO omw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiura, Tomaasira, Iemisira. mwia Arapiasira mwaaqu, Saimoninra. mwia nrutu mpo Seriotira, ");
INSERT INTO omw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iutaasira. mwia qora nrutu Iemisira, Iutaasi Isikeriotira. mwiva nraakiara Iesusira qovarama kyaariva varura. ");
INSERT INTO omw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesusiva mwi vaisinramwuhuavata sitero taaqiqaatairo uro ntantero tumu tunrenra sata siviro varura. Varuvata mwia vataqi nrohuhua airivanto mwini varuvata airi nraakye qora Iutia mwata mpo mwatukya mpo mwatukyaqitaitave, Ierusaremisaive, vevara nampisini Taiaa mwatukyave, Saitoni mwatukyave, mponatai mponatai mwihua ntuvaantuama vita ");
INSERT INTO omw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iesusira qua rieta Iesusiva mwihua nriqa quani inraikyaravata taiqa kyaarive tita mwihua nrumu ntuvaantua hita varura. Vaanavantovata varu vaisihua mwihuavata nri ntovaro Iesusiva vaana titamwa kyero mwihua kyuqema kyora. ");
INSERT INTO omw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Iesusiva mwihua kyaahaqa huvaro mwia kepukyavanto airi nraakye qora kyaahaqama nraahu kyovatara tita, ekyaa nraakye qoravanto mwia kyaatu kyarerata uti varura. ");
INSERT INTO omw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesusiva nai vataqita nrohuhua taqero mwihuara tiqaro, Nkye vehi nraakye qora variahua nkye qamwataate. Kotiva nkyiqa ntaqikyi varirata nkye mwia nraakye qora varivarave. ");
INSERT INTO omw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mate kyara nraataa ihata varia nraakye qorahua nkye qamwateqata variate. Nkye nraakiara kyara vikyokyama nrevarave. Mate ntate varia nraakye qorahua nkye qamwateqata variate. Nkye nraakiara raihiqata varivarave. ");
INSERT INTO omw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nkye ni mwatani mwatatai nraaqiarara ni pataqita vi varivata mwihua mwia kyaara nkyi nramwutaaqa hivarave, nkyi qoririma nyatevarave, nkyiara uaqia hi quara tivarave, nkyiara uaqia hi kyaiqara vare variavo tivarave. Nkyiara mwitaa mwitaa tivata nkye qamwateqata nraahu variate. ");
INSERT INTO omw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mwihua nkyi mwitaa hiara mwianra nkyini nronraqama kyero nyaamwuni kyoqaa vahirara rieqatama mate nkyi mwutukyavanto kyuqe hirata nronraqama kye qamwataate. Haaru mwihua haivaqahuavata poropeti vaisinramwu kuaa qarama kyeta uaqiama nyatorave. ");
INSERT INTO omw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nkye airi inraikya mate mwaa vateta mwianra qamwataahua nkyiara po kye tuqo. Nkye ekyaarama qamwataavo. ");
INSERT INTO omw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nkye mate mwaa entara kyara nraavaro vikyokya ihata variahuave. Po, nraakiara nkyi kyara nraataa hiananrove. Nkye raihiqata variahuave. Po, nkye nraakiara nkyi mwutukyaqitairo uaqia hirata ntateqata varivarave. ");
INSERT INTO omw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mate mwaa entara nraakye qora nkyi qamwata nyateqata nkyi nyutu tuaaheraahua, nte nkyiara po tuqo. Nraakiara nkye taqevarave. Haaru mwihua haivaqahua unra qua tu poropetihua kuaa qarama nyatorave. ");
INSERT INTO omw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mate nkye ni qua rie variahua nte nkyi timwa nyinrenrave. Nkye nkyeta nramwutaahuara mwutukya vahirata variate. Nkyi uaqiama nyaterara nraahu rie vaisihua varivata nkye mwihuama kyuqema nyataate. ");
INSERT INTO omw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nkyiara qoraqama quate tiqata nkyiara uaqia hi quara ti vaisihua, nkye mwihuara rieqata Kotirara aakyara nteqata, Kotio, mwihua kyuqema nyataante, qiate. Nkyi qoraqama nyatehuara rieqatama Kotira nraanraivaro mwiva mwihua kyaahaqa hiarive. ");
INSERT INTO omw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mpovanto nkyi nraatokyai ntuteqa kyairera, tuqasaa kyaivaro hini nraatokyaivata ntuteqa kyaarive. Mpovanto nkyi vaaqatua varero mwiva nkyi tuapakyaaravata vararera hirata hia qao qiate. ");
INSERT INTO omw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mpovanto mpo inraikyara nyaanru tirata qati nraahu mwiate. Mpovanto nkye vate inraikyara varairera, hia qaiqaa tita timwiante qiate. ");
INSERT INTO omw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nkye mpohuara tiri mwitaa mwitaama timwataate tiqata vu nraato tintema kyeta kuaa qarama kye nkyiarivata mwitaa mwitaama nyataate. ");
INSERT INTO omw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nkyiara mwutukya vahiarihua hia mwihuara nraahu nkyi mwutukya vahiarive. Nkyiara mwutukya vahiarihuara nraahu nkyi mwutukya vahirera, nanra kyuqe inraikyave Kotiraqaatai varevara? Hiama mpo inraikya varevarave. Nkye ntapihiarave. Uaqia hi kyaiqara uti variahua mwihua variqata nkyiariara mwutukya vahi vaisihua mwihuara nraahu mwutukya vaihata variarave. ");
INSERT INTO omw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nkye nkyita kyuqema nyataahuara nraahu kyuqema nyataivera, nanra kyuqe inraikyave Kotiraqaatai varevara? Hiama mpo inraikya varevarave. Nkye ntapihiarave. Uaqia hi kyaiqara uti variahuavata mwitaa hiarave. ");
INSERT INTO omw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nkye tiqata, Ina mwinrenrave timwa kyero iqitai quaahaqa varero qamwanrama ina varaqi nrumu mwiani vaisira mwia nraahu mwivorave. Nkye mwitaa hivera, nanra kyuqe inraikyave Kotiraqaatai varevara? Hiama mpo inraikya varevarave. Nkye ntapihiarave. Uaqia hi kyaiqara uti variahuavata nkyiari hena vaisi nyita tiqata, Mwihua kuaa qarama kye tita timwivarave, qiarave. ");
INSERT INTO omw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Hia nkye mwihua hiante hiate. Nkye nkyeta nramwutaahuara mwutukya vahirata mwihua kyuqema nyataate. Mpohua nkyiara munimave, mwitaa inraikyave, timwivaqe nraakiara nkyita nyianre, tivera, nkye apiara votima kye nyiate. Nkye mwitaamaqi vivaro Kotiva mwia qiata kyuqema kyero nkyi kyoqaa nyiananrove. Hia mpo vaisiara kyuqeve ti variahuavata, uaqia hi kyaiqara uti variahuavata, mwinro mwaanro mwitanahua Kotiva kyuqema nyate varirave. Kotiva kyuqe kyaiqa mwitaama kyero vare varirara tita, nkyevata mwitaa hivera, nkye qutaa Kotiva nyaamwuni varira mwia nraaqiarama varivarave. ");
INSERT INTO omw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nkyi sova Kotiva po kye timwa nyate varintema kyeta nkyevata po kye timwa nyateqata variate. ");
INSERT INTO omw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nkye hia mpohua kyaiqara pupiteqata hia kyuqe hi kyaiqarave qiate. Nkye mwitaa tivaro Kotiva nkyita kyaiqaravata hia kyuqe kyaiqavema qiananrove. Nkye hia ko riaa vaisihua votima kye variqata mporara tiqata, Iqaa qua nronra vahiananrove, qiate. Nkye mwitaa tivaro Kotiva nkyitaravata tiqaro, Nkyiqa qua nronra vahiananrove, qiananrove. Nkye mpohuara tiqata, Nkye tiri uaqiama timwataa quara qaqira kye hia mwianra riemwaqi virerave, tivera, Kotivavata nkyitara tiqaro, Nkye ni qua nteqa kyaa quara qaqira kyena taunru nyataaninrave, qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nkye mpohua nyivaro Kotiva nkyitavata nyianrive. Mwiva rauru kyero raturu kyairaro itomwi viraro mpoqiavata kyoku kyairaro musaaqiro qatinani rauruananrove. Nkye nataama tukya mpohua nyinra mwi tukyaraqaama Kotiva nkyitavata nyiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesusiva mwitaa timwa kyero mwiva mpo quaqaa ntumwa kyero tiqaro, Vu qipa quari vaisiva hiama qio nai henanra vu qipa quaninra kyauqu tuvare viqaro aanra nraamwu taananrove. Mwiva mwitaa hirera, mwitanahuaqama ontiqi tumu ntivarave. ");
INSERT INTO omw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Qua riemwaqiro vi vaisiva hiama nai mwia qua timwa mwi vaisira nraatarero. Qua riemwaqiro vi vaisiva riemwaqiro viro ekyaa okyara taqero mwiaqaatairo mwitanahua kuaa qarama varivarave. ");
INSERT INTO omw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","E nanraqamave mwata mwumwuvanto ena qata vakyaa vuqi viqe taira taqeqara ina vuqi kyatari aka nronravanto viqe taira hia taqera hiaro? ");
INSERT INTO omw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kyatari aka nronravanto i vuqi viqetero vaihara nanraqamave ena qata vakyaara tiqara, Ni katao, kyai i vuqitaina mwata mwumwu venta kyaanke, ti variaro? E kyuqe kyaiqa varauqo tiqara unra uti variaravave. Ena vuqitaira kyatari aka nraante venta kyera, mwiaqaataira kyuqema kyera taqeqarama ena qata vakyaa vuqitairavata qio mwata mwumwu venta kyenanrave. ");
INSERT INTO omw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kyuqe kyatarivanto hia uaqia hi tamwanra riairave. Uaqia hi kyatariva hia kyuqe tamwa riairave. ");
INSERT INTO omw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Vaisivanto kyatari tamwa taqeqaro mwi kyatarira ntapihi kyero nrutu ntairave. Vaisivanto fiki hiqirero mwiva hia auqu vataa kyatariqaatairo hiqirave. Mwiva uaini kyuqera hiqirero mwiva hia mwaahiqaatairo hiqirave. ");
INSERT INTO omw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kyuqe vaisivanto mwia mwutukyaqi kyuqe kyaiqa varaariva piqaiharora tiro, mwi vaisiva kyuqe kyaiqa nraahu vare varirave. Uaqia hi vaisiva mwia mwutukyaqi uaqia hi kyaiqara utuariva piqaiharora tiro, mwiva uaqia hi kyaiqara nraahu uti varirave. Nrovanto mwaatira mwutukyaqi piqai inraikyara mwia nraahu timwa qoqa hirave. ");
INSERT INTO omw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nkye nanraqamave nianra nronrao, nronrao, tiqatavata hia ni qua riaavo? ");
INSERT INTO omw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nte hunani nrinro ni qua riero nte tunte tunte hiani vaisira okyara nkyi timwa nyinrenrave. ");
INSERT INTO omw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mwi vaisiva nraamwu kepukyaqama kyero hoqa tai vaisira votima kyeroma variananrove. Mwiva nraamwu hoqarera hiro mwata quvuqiro viro uto oriqa nraamwu tura ratero nraamwu hoqa tairave. Mpo enta vati humwunravanto nraamwu vara kyarera utiharo nraamwu mwia kyuqema kyero hoqa taivara tiro, kepukyaqama kyero vahirave. ");
INSERT INTO omw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ni qua riero qaqira kyero hia nte tunte tunte hiari vaisiva, mwiva nraamwu uaqiama kyero hoqa taira votima kyeroma variananrove. Mwi vaisiva mwata quvu kyero hia ori mwataqaa nraamwu tura rataraitiro, verasata rakyero hoqa taiharo vati humwunravanto nraamwu mwia vara kyaiharo ntaputama viro uaqiama virarama tuqo, tiro. Iesusiva mwi quara turama. ");
INSERT INTO omw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesusiva mwi qua mwakyaakyara timwa nyi taiqa kyero mwiva mwihua kyero Kapenaamini vura. ");
INSERT INTO omw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mwini vuvaro Romeni vaisi ntaqu vaisihua 100 nramwuqaa ntaqikyi varura mwia kyaiqa vaisi nriqa vuvaro mwiva qutuariva qaumaqa hura. Mwitaa huvaro nronra vaisi mwia mwutukyavanto nai kyaiqa vaisiara mpoqiavata vahuvaro variqaro ");
INSERT INTO omw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","mwiva Iesusirara riero Iutaa nronra vaisinramwu sitero tiqaro, Nkye uro Iesusirara nrinra ni kyaiqa vaisi kyuqema mwataante qiate, tuvata ");
INSERT INTO omw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","mwinramwuhua Iesusiva varunani uro ntetama po kye tita tiqata, Romeni vaisi mwiva kyuqe vaisivantove. E mwia uro kyaahaqa hiante. ");
INSERT INTO omw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mwi vaisiva tiri Iutaa nraakye qorara mwutukya vaiharo variqaro mwiva naivanto mwaanra nraamwu mpovata hoqa timwa tairave, tita. ");
INSERT INTO omw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mwihua mwitaa tuvaro Iesusiva mwihuavata vuva nraamwu qaumato uro ntovaro Romeni vaisi mwiva nai vataahua sitero tiqaro, Nkye uro Iesusira timwa mwiqata mwitaa qiate, Nronra vaisio, e qumina mwaini toqaamwu tu kyera nrinronrave. Nte kyuqe vaisi variariravauma e ni nraamwuqi qio nrinanrave. ");
INSERT INTO omw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nte kyuqe vaisi variqanavauma e hinanrani qio quaninrave. E mwini variqara qua nraahu tiqara, E kyuqema quante, tiraro ni kyaiqa vaisivanto kyuqema quarive. ");
INSERT INTO omw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nte qaami vaisi variqana nte niqaa ntaqikyi varia vaisihua qua rie varurave. Ntevata ntaqua vaisihua mponramwuqaa ntaqikyi varurave. Nte mwihuaqitaina vaisi mpora quante tuqaro mwiva virave. Nte vaisi mpora nriante tuqaro mwiva nrinrave. Nte ntena kyaiqa vaisiaravata mwitaa mwitaa hiante tuqaro mwiva ni qua riero mwitaa hirave, timwa kyero mwihua sitovata vita. ");
INSERT INTO omw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Vuhua uro Iesusira mwi quara timwa mwuvaro Iesusiva nrihanrama viro tuqasaa viro nraakye qora mwia vataqita nruhuara tiqaro, Nte nkyi timwa nyuqo. Mwi vaisiva mpo mwatanaava eqero nronraqama kyero nianra mwiva ni kyaahaqa hiananrove tihana taqauqo. Hia nte nkyi Isareriqitairovata mpovanto mwitaama kyero qua ti vari vaisira taqaurave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mwitaa tuvata Romeni vaisi mwiva sitohua nrumu ntanteta uro taqovaro mwia kyaiqa vaisivanto kyuqema viro nraamwuqi varura. ");
INSERT INTO omw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mwia nraakiara pataqia vari kyero Iesusiva mpo mwatukya mwia nrutu Nenini vuvata mwia nraaqiaranramwuvata airi nraakye qoravantovata mwia vataqita vura. ");
INSERT INTO omw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iesusiva uro mwi mwatukyara nronraanrana taqovata mwi mwatukyaraqitaita nraakye qoravanto qutu vu vaisira quntarerave timwa kye vareta nrunrama. Tetoqa nraakye mwaaqu kuaiqiavanto varuva qutu vuvata airi nraakye qoravanto mwi nraakyera vatama kyeta nruvaro ");
INSERT INTO omw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","nronravanto Iesusiva mwi nraakyera taqovaro mwia mwutukyavanto mwianra ua huvaro mwianra tiqaro, Hia ntataante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mwitaa timwa kyero uro kikera/tainta tu varovata vaisi mwia varohua mwiaqaa ra kyeta varuvaro Iesusiva tiqaro, Qaraakya vaisi mwaavao, nte iara siquante tuqo, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","qutu vu vaisiva siviro mwaamwianra viro quavata tuvaro Iesusiva mwi vaisira nai nronra mwinro. ");
INSERT INTO omw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mwitaa huvata mwihua ekyaa mpoqama kyero nyaatuqa tovata Kotira nrutu tuaahereta tiqata, Poropeti vaisi nronravanto tiri utaqaa qovarama viho. Kotiva hia tiri nai nraaqiaranramwuanra taunru kyaiho, tita. ");
INSERT INTO omw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mwihua mwitaa tuvaro Iesusira mwakyaakya mwiva ekyaa Iutaa mwatanivata, Iutaa vara ututu vahu mwatukyaranivata, mwi quava viro nrinro huvata ekyaa riemwa ntora. ");
INSERT INTO omw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Iesusiva mwitaamaqiro viqaro mpo kyaiqa mpo kyaiqa vare varuvata Ioninra nraaqiaranramwuvanto uro Ioninra timwa mwuvaro mwiva nai nraaqiara taaratana nyaanrama kyero tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nkyetana uro nronra vaisi mwia kyapara hiqata mwitaama qiate, Nraakiara nrinrenra hiarava qutaa e mwivave hiaro? Tire qati nraahuve vaisi mpo vekya variananrave? qiate, tiro. Mwitaa timwa kyero mwitana sitovata ");
INSERT INTO omw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","mwitanahua vuhua Iesusiva varunani uro nteta tiqata, Ioniva nramanri nyi variva tiritana titero tiqaro, Iara mwia mwitaama kye uro ntumwa hiamwa hiate, tiho, Nraakiara nrinrenra hiarava qutaa e mwaa mwivave? Tire qati nraahuve vaisi mpo vekya variananrave? qiate, tihata nrunro, tita. ");
INSERT INTO omw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mwitanahua mwitaa tuvaro mwi entara Iesusiva nraakye qora airi nriqa vuhuave, vaanavanto utaqi varuhuave, mwihua kyuqema nyatero vu qipa vuhua airi mwiva ntapairi kyova varura. ");
INSERT INTO omw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mwiva variqaro Ioniva sito vaisitana timwa nyinro tiqaro, Nkyetana mwaini nrumu variqata taqaarave, riaarave, nrumu ntanteta uro Ioninra timwa mwiate. Vu qipa vihua qaiqaa taqe variavo. Kyuqu uaqiama vihua qati nrohi variavo. Tauma rumpuaravanto utihua tavanta vihata qati variavo. Nraato tita vihua qaiqaa qua qatima riaavo. Qutu quahua sivita qatima variavo. Vehi nraakye qoravanto Kotira qua mwaanra kyuqe qua mwaanra nrumu riaavo. Ekyaa mwi quara uro Ioninra timwa mwiate. ");
INSERT INTO omw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nianra hia taara vu nraato tiraitiro, kepukyaqama kyero kuaa vu nraato nraahu tuqiro vi variariva, mwivama qamwateqaro variananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Iesusiva mwitaa tuvata Ioniva sitotanahua nrumu ntanteta vuvaro Iesusiva nraakye qora ntuvaantuama vita varuhua Ioninranra timwa nyinro tiqaro, Nkye haaru nanra inraikya taqarerata qumina mwataqaa vurave? Toqavanto tiharo omwa ahikyavanto hini viro hini nrinro hira taqarerata vurave iho? ");
INSERT INTO omw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nkye hia mwia taqarera vurave. Nkye nanra inraaikya taqarerata vurave? Tuavaaqa kyuqera ututo vaisira taqarerata vurave iho? Qaqao, tuavaaqa kyuqera uti varia vaisihua hia quminasata variarave. Mwi vaisihua nronra vaisi vuni variahua nraamwuqi nraahu variarave. ");
INSERT INTO omw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nkye nanra inraikya taqarerata vurave? Kotira qua qovarama kyora poropeti vaisi taqarerata vurave? Qutaave, mwia taqarerata vurave. Qio kyai nte nkyi timwa nyianrita riaate. Nkye mwi entara poropeti vaisi nraatara kyai vaisira taqorave. ");
INSERT INTO omw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kotira mpukuqi Kotiva Ioninranra mwitaama tiro: Taqaante, ni qua timwa nyiani vaisira nte titaariro mwiva nraante i vuni viqaro i aanra terama mwataananrove, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iesusiva mwitaa timwa kyero mwiva mwihuara tiqaro, Kyai nkyi timwa nyianrita riaate. Mwatani mwatataa nraakye qorahua variavaro Ioniva ekyaa mwihua nraatara kyaivama variho. Ioniva mwitaama variharo nraakiara Kotiva ntaqikyiani nraakye qorahuaqitairo pataqia variariva mwiva nraahuma Ioninra nraatara kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Iesusiva mwitaa tuvata qumina nraakye qoravata, taakisi vare varuhuavata, mwihua Ioniva nramanri nyuhuara tita, mwihua Iesusira qua rieta tiqata, Qutaaqama kyero Kotiva avuqavu hi varivave, tita. ");
INSERT INTO omw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mwihua mwitaa tuvata Parisinramwuvata mwaanra okyara ti varuhuavata, mwihua hia Ioniva tiri nramanri timwianrive tuhuara tita, mwihua Kotiva hinani vi aanranra mwoqa mwunra. ");
INSERT INTO omw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mwihua mwitaama varuvaro Iesusiva tiqaro, Mate mwaa entara varia nraakye qorahua nanra inraikya votima kyetave variavo? Kyai nkyi timwa nyiankye. ");
INSERT INTO omw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mwihua nraaqiaranramwuvanto mwatukyaqaa tutiqarerata mwatakyaa vita variantema kyeta variavo. Nraaqiara mwihua tutiqeqata nkyiari henahuara tiqata, Tire ntoma vaara vuate varurata nkye ihi ntaataara vaihatama nkye hia ihi ntaavo. Tire tutiqeqata nkye ntate ihira turata nkye ntataataara vaihatama nkye hia ntataavo, qiarave. Mate mwaa entara variahua mwihua votima kyeta variavo. ");
INSERT INTO omw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ioniva nramanri nyinrenro nri ntero mwiva kyara aurama tero uainivata hia nrovata nkye mwianra vaana kyapata varivave qiarave. ");
INSERT INTO omw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nte mwatani mwata taiva nri ntena, nte kyaravata nramanrivata nrena nruqatama nkye tiqata, Mwi vaisira taqaate. Mwiva inraanrama kyero kyara nre varivave. Mwiva uaini nreqanro ueraqama vi varivave. Mwiva taakisi vare variahuavata, uaqia hia vaisihuavata, totiqa hi varivave, qiarave. ");
INSERT INTO omw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Qio quavanto kyuqe qua vahirera, mwi quara riemwaqiro quariva taqairaro kyuqe qua nraahu vahiananrove, tiro. Mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mpo enta Parisi vaisi mpovanto Iesusirara tiqaro, Nrinra ni nraamwuqi kyara nraante, tuvaro Iesusiva mwia nraamwuqi kyara nranrenro vuva uro mwia nraamwuqi mwatakyaa viro kyara nre varura. ");
INSERT INTO omw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mwiqi nre varuvaro mwi mwatukyaraqi nraakye mpovanto airi vaisivata api nrohi varu nraakyeva Iesusiva Parisi vaisi mwia nraamwuqi kyara nre varurara riora. Riero mwiva ori taqu vahamwenra kyuqe mwunta vura varero uro ");
INSERT INTO omw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Iesusiva kyuqu tututero kyara nre varura mwia kyuqu tarani variqaro ntate varuvaro mwia nruqunruvanto Iesusira kyuquqaa tumu ntuvaro nai qiata kyaahiqo nruka kyero mwia kyuqu mota kyero vatero vahamwenra kyuqe mwunta vura mwia Iesusira kyuquqaa qu mwatero. ");
INSERT INTO omw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Qu mwate varuvaro Parisi vaisi mwiva Iesusirara nrinra ni nraamwuqi kyara nraante tuva taqero nai riero tiqaro, Iesusiva poropeti vaisivanto varitirio, mwiva mwia tu varai nraakyera okyara ntapihiro mwiva uaqia hi kyaiqara utiravata ntapihitirio, tiro. ");
INSERT INTO omw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Parisi vaisi mwiva mwitaama riovaro Iesusiva mwianra tiqaro, Saimonio, nte qua mpo i timwa mwinrenrave, tuvaro Saimoniva tiqaro, Mwaanra ti variara vaisio, qio timwa mpiraqe riaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tuvaro Iesusiva timwa mwinro tiqaro, Vaisi taaratanavanto kuaa vaisi mwiaqaataita munima vararera huvaro mwiva vaisi mpo 100 kinaa mwinro vaisi mpo mwia 10 kinaa mwunrave. ");
INSERT INTO omw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nyuvata mwitanahua mwi munimanra nramwa kyeta nai mwiva hia qioqa huvata varuvaro mwiva mwitanahuara tiqaro, Hia nkyitana nyitau munimanra nina mpiate qianinrave. Qaqirama kyauqo, turave, tiro. Iesusiva mwitaa timwa kyero mwiva Saimoninra kyapara hiro tiqaro, Mwitanahuaqitairo tavave munima nyi vaisira mwianra nronraqama kyero qamwataananrove? tiro. ");
INSERT INTO omw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Iesusiva mwitaa tuvaro Saimoniva tiqaro, Qio munima nronraqama kyero varai vaisivama nronraqama kyero mwianra qamwataananrove, tiro. Tuvaro Iesusiva tiqaro, Ntapihi kyerama tira hiaro, tiro. ");
INSERT INTO omw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iesusiva mwitaa timwa kyero mwiva tuqasaa viro Saimoninranra tiqaro, Mwaa nraakyera taqaante. Nte i nraamwuqi nrumu varuqara e hia nramanriqotaira ni kyuqu hiqama mataararo mwaa nraakyeva nai nruqunruqotairo ni kyuqu hiqama materoma nai qiata kyaahiqotairo ni kyuqu nruka mataiho. ");
INSERT INTO omw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ni qua mwanteqarama e hia ni motaararo mwaa nraakyeva nte nri ntauraqaatairo ni kyuqu motaqiro vi variho. ");
INSERT INTO omw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","E vahamwenra hia ni qiataqaa qu mataararo mwaa nraakyeva vahamwenra mwunta vira ni kyuquqa qu mate variho. ");
INSERT INTO omw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mwianra rieqanama nte iara mwataama tina. Nraakye mwaava Kotira qua airi qua nteqa kyaihana nte ekyaa mwi quara nruka mwataurara tiro, mwiva nronraqama kyero ni qamwata mate variho. Nte vaisi mpo qora qua pataqia nruka mwataariva mwiva ni pataqia qamwata mataananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iesusiva mwitaa timwa kyero mwiva nraakye mwia timwa mwinro tiqaro, E Kotira qua nteqa kyaananra nrukama mwatauqo, tiro. ");
INSERT INTO omw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Iesusiva mwitaa tuvata nraamwu mwiqi kyara nranrenrata nrumu varuhua nkyiari nai timwa mwi nai timwa mwi hita tiqata, Mwaa ta vaisiva variqarove Kotira qua nteqa kyaananra nruka mwatauqo tiho? tita. ");
INSERT INTO omw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mwihua mwitaa ti varuvaro Iesusiva nraakye mwianra tiqaro, E nianra qutaaqama kye rieqara ni kyaahaqa hiarivave qiararoma Kotiva i vitaiho. I mwutukya qihaakyama vahirara quante, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mwia nraakiara mpo enta Iesusiva mwatukya mpoqi mpoqi nrohiqaro Kotiva nraakye qoraqaa ntaqikyiani quara kyuqe qua timwa nyiqiro vura. Mwia nraaqiara 12 nramwuvanto mwia vata vuvata ");
INSERT INTO omw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","nraakye mponramwuvantovata mwia vata vurama. Nraakye mwinramwuhua tauraa vaanavanto mwihuavata varuhuave, nriqa vuhuave, varuvaro Iesusiva mwihua kyuqema nyatovata mwihua Iesusira vataqita vurama. Mariaava mwianra Makataranyaavave tura tauraa Iesusiva mwiaqitairo vaana 7 nramwu titovata nritare vu nraakyeva varuvaro ");
INSERT INTO omw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","nraakye mpo Iohaanaanra mwia vaativanto Kusaava vaisi nronravanto variqaro Herotira opisi nraamwuqi kyaiqa vare varura. Nraakye mpo Susaanaavavata, airi nraakyevata, Iesusira vataqi viqata nkyiari munima kyeqata Iesusiravata mwia nraaqiaranramwuvata kyaahaqamaqita vurama. ");
INSERT INTO omw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mwatukya mpoqi mpoqitaita nraakye qora Iesusiva hunani nrumu ntuvaantuama vita varuvaro Iesusiva mpo quaqaa ntumwa kyero timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Vaisi mpovanto kyara vara tirero humwu isaqiro vurave. Mwiva isaqiro vuvaro mpohuva aanraqa tumu ntuvata vaisivanto vita nrita hiqata kyuqu nte kyovaro nyaamwavanto nrumu nramwa kyorave. ");
INSERT INTO omw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Humwu mponramwuvanto ori mwataqaa tumu ntuva qamwanrama qupiqa viro aahara mwataqaara tiro, aaharama vurave. ");
INSERT INTO omw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Humwu mponramwuvanto uakukya uvi auqu vahuraqi tumu ntuva uakukya kyapata qupiqovaro uvi auqu vahu uakukyava ntumwaqu kyovaro hia qupiqorave. ");
INSERT INTO omw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Humwu mponramwuvanto mwata kyuqeraqi tumu ntuva kyuqema kyero qapiqero uro tamwa airi riemwa torave, tiro. Iesusiva mwitaa timwa kyero mwihua timwa nyinro tiqaro, Nkyi nyaato vahirera, mwaa quara okyara ntapihi kyeta riaate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iesusiva mwitaa timwa kyero varuvata mwia nraaqiaranramwuvanto mwia kyapara hita tiqata, Vaakya mpo quaqaa ntumwa kyera qiananra mwia okyara tiri timwa timwinraqe tire riaare, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iesusiva mwihua timwa nyinro tiqaro, Kotiva nraakye qoraqaa ntaqikyiani quara uqeta taira, mwi quara Kotiva nkyiara mwihua qati kyairata mwi quara okyara riaate timwa kyero, qumina nraakye qorara mwi quara okyara hia vutu kyera timwa nyiante tirara tina, nte mpo quaqaa ntumwa kyena mwihua timwa nyunrave. Nte mpo quaqaa ntumwa kyeqana mwihua timwa nyianrita mwihua taqeqatavata hia ntapihi kyeta taqevarave. Mwihua mwi quara rieqatavata hia mwia okyara ntapihivarave. ");
INSERT INTO omw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Iesusiva mwitaa timwa kyero mwiva nai nraaqiaranramwu timwa nyinro tiqaro, Vaakya mpo quaqaa ntumwa kyena timwa nyunra mwia okyara timwa nyinrenrave. Humwukyanaa mwia Kotira quama vaiho. ");
INSERT INTO omw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Humwu aanraqaa tumu ntu quara mwia okyara vahirero vaisi mponramwuvanto Kotira qua riaavaro Saataaniva nri ntero tiqaro, Mwihua huvantu kyero sitaankyorave, timwa kyero mwihua su nyaato mwutukyaqitairo mwi quara ntavihi kyero varairave. ");
INSERT INTO omw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Humwuvanto ori mwataqaa tumu ntiro vahura, mwia okyara vahirero nraakye qoravanto Kotira qua rieta mwi quarara pataqia qamwata kyeta variavaro quavanto hia mwihua utaqi tuqa tuta kyero vaihata mwihua Kotira qua riemwaqita quavaro mpovanto tiqaro, Nrivaqe uaqia hi kyaiqara utuare, tihata mwihua mwia qua rieta Kotira qua qaqira kyaarave. ");
INSERT INTO omw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Humwu mponramwuvanto uakukya uvi auqu vahuraqi tumu ntu quara, mwia okyara vahirero nraakye qoravanto Kotira qua rieta mwiaqaataita mwihua nkyiari vataa inraikyararave, kyaiqarave, nkyiari mwatani variqata qamwaterarave, mwi inraikyarara nraahu nronraqama kye rieqata, mwihua Kotira qua qaqira kyeta hia kyuqe tamwa riaintema kyeta riaarave. ");
INSERT INTO omw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Humwu mponramwuvanto mwata kyuqe hiraqi tumu ntiro vahura, mwia okyaravanto vahirero nraakye qoravanto Kotira qua rieta nkyiari su nyaato mwutukyaqitai mwi quarara riemwaqita vita kepukyaqama kyeta variqi viqata kyuqe tamwa riaintema kyeta riemwataarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Iesusiva mwitaa timwa kyero mwaa quara timwa nyinro tiqaro, Hia mpovanto omwa qupi kyero tave vara kyero mwiaqaa ntumwaqu tairave. Hia mpovanto omwa qupi kyero tainta mwemwaqi veta vatairave. Vaisivanto omwa qupi kyero mpohuavata omwa mwia taqaate tiro, nyaamwuni viri vatairave. ");
INSERT INTO omw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mate mwaa entara uqeta taaninra nraakiara vara qovarama kyero qoqaa nraahuma vataananrove. Mate ntumwaqu taaninra nraakiara puaama kyero omwa itaaninraqaa uro vataananrove. ");
INSERT INTO omw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Vaisi mpovanto mpo inraikya vataaninra Kotiva mpoqiavata mwiananrove. Vaisi mpovanto hia mpo inraikya vataariva tiqaro, Nte pata inraikya nraahu vatauqo, qianinra mwiavata Kotiva ekyaa vara kyaananrove. Kotiva mwitaa hirara tita, nkye raurukyeqa mpo qua mpo qua rieqata variate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iesusiva mwini varuvata mwia nrovavata mwia qatanramwuvata mwia taqarerata nruhua nrumu taqovata nraakye qora airivanto Iesusira vara ututu varuvatara tita, hia qio Iesusira nraaqani vura. ");
INSERT INTO omw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mwihua varuvaro mpovanto Iesusira timwa mwinro tiqaro, I nrovavata i qatanramwuvata mwaataqa i taqarerata nrumu variavo, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Iesusiva mwiqi ntuvaantuama vita varuhua timwa nyinro tiqaro, Kotira qua rieqata nrohi variahua mwihuama ni ntovave, ni kata pakyaahuave, variavo, tiro. Mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mpo enta Iesusiva nai nraaqiaranramwuanra tiqaro, Nrivaqe kyaarera nronra mwaa qareta vutura hini quare, timwa kyero mpotuqi mwaanri ntero mwihua kyapata viro. ");
INSERT INTO omw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mwihua nramanriqaa vi varuvaro Iesusiva mpotuqi vaite varuvaro nronraqama kyero toqa vaururu utiqaro nramanri ventaqiro viro mpotuqi mwaanri ntero piqa kyovata mwihua nramanriqi rauru viva qaumaqa huvata ");
INSERT INTO omw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Iesusira nraaqiaranramwuvanto mwiva vaitonani uro mwia vaurama kye tiqata, Nronrao, nronrao, tire qaumama nramanriqi ntumwa quananrave, tuvaro Iesusiva siviro toqa vaururuaravata nramanrianravata qio eqaante tuvaro toqa vaururuvanto taiqa vuvaro nramanrivanto tuminro tirema naitarama vahura. ");
INSERT INTO omw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tirema vahuvaro Iesusiva nai nraaqiaranramwuanra tiqaro, Tanave nkye nianra kepukyaqama kyeta riaava vaiho? tuvata mwihua aatu hiqata kyauqu ntukikinraaqa teta tiqata, Qikye, mwaa nai ta vaisivave iho? Mwiva qua tiharo toqa vaururuvantovata nramanrivantovata mwia qua rie variho, tita. Mwihua mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mwihua mpotuqi vuhua vutura Kekesaa mwatani uro ntora. Kariri rumpua vutura qarahi hini Kekesaa mwata vahura. ");
INSERT INTO omw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mwihua mwini uro ntovaro Iesusiva mpotuqitairo mwaamwi ntovaro vaisi mpo mwi mwatukyaraqinaava vaana kyapata variqiro nrohi varuva uro Iesusira qintorama kyora. Vaisi mwiva hia tuavaaqavata utuva, hia nraamwuqivata vaitova, mwiva vaisi qutuvata varaqita uro ori ataamwuqi vate varuraqi vaitaqiro vi varura. ");
INSERT INTO omw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mwiva Iesusira taqero paa tiro kye vu tiro Iesusira vuqaa nrumu tumu ntiro aakyara ntero tiqaro, Iesusio, Kotiva nronravanto nyaamwuni varihara e mwia mwaaquvanto variaro. E ni nataa hirerarave nrianro? Po, nte iara hia ni ruantema tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iesusiva vaananra vaisi mwiaqitaira nritarera quante turara tiro, vaana mwiva mwitaa tura. Mwi mwatanaahua vaisi mwiva aatu quankyo tita, mwia seni vara kyeta kyuqu kyauqu rupa tovaro vaanavanto airi nani mwi vaisira tuqara tutovaro mwiva seni mwia ntupe paama kyovaro vaanavanto mwia vara kyovaro vaisi mwiva qumina mwatani vi varura. ");
INSERT INTO omw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mwitaa huvaro Iesusiva vaana mwia kyapara hiro tiqaro, Ena nrutu qiante, tuvaro mwiva Iesusira timwa mwinro tiqaro, ni nutu Airivave, tiro. Vaana airivanto mwi vaisiraqi varuvara tiro, mwiva mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Vaana mwihua Iesusirara po kye tita tiqata, Hia tiri mupi vaanavanto variaraqi titaante. ");
INSERT INTO omw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mwitaa timwa kyeta taqovaro quara airivanto vaini taaqiqaa uhiqa nre varuvata vaana mwihua tiqata, Tiri titairaqe tire quara utaqi uro variare, tuvaro Iesusiva qiove tuvata ");
INSERT INTO omw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","vaana mwihua vaisi mwia kyeta quara mwihua utaqi vuvata ekyaa quara mwihua okaiqi hianteta vuhua utontamwanra kyaareraqi ntumwa vita nramanri nreta qutu taiqa vura. ");
INSERT INTO omw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Quaranramwu nramanri nreta qutu vuvata mwihuaqaa ntaqikyuhua mwia taqeta hiante vuhua uro mwatukyaqi varuhua ekyaa viti viri timwa nyuvata ");
INSERT INTO omw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","mwi mwatanaahua mwia taqarerata vuhua Iesusiva varunani uro nteta taqovaro vaanavanto mwia utaqi varuvaro titamwa kyo vaisiva tuavaaqa ututero Iesusira nraaqani mwatakyaa viro mwia vu nraatovanto naitarama vuvaro varuvata mwihua aatu hita. ");
INSERT INTO omw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mwihua aatu huvata vaisi mpo uhua vaakya mwia taqohua nraakye qora mwihua timwa nyita tiqata, Iesusiva mwitaa mwitaama kyaiharo vaisi mwiva kyuqema viho tita. ");
INSERT INTO omw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mwitaa tuvata Kekesaa mwatanaa mwihua mpoqama kye aatu hita Iesusirara tiqata, Tiri mwaata mwaisaira quante, tuvaro Iesusiva mpotuqi mwaanri ntero vurama. ");
INSERT INTO omw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mwiva virera huvaro vaanavanto nritarovaro varu vaisiva Iesusirara po tiro tiqaro, Kyai nte ivatama kyena quankye, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Iesusiva qaqao tiro, E ena mwaatani uro variqarama Kotiva i kyuqema mwatairara nraakye qora timwa nyiante, tiro. Timwa kyero Iesusiva mwia titovaro mwiva nai mwatukyani uro ntero Iesusiva mwia kyuqema mwatorara timwa nyiqiro vurama. ");
INSERT INTO omw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesusiva nrumu ntantero kyaarera nronra vutura hini tokyani uro ntovata mwia vekya ntuvaantuama vita varu nraakye qorahua mwia qamwata mwatora. ");
INSERT INTO omw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mwitaa huvaro vaisi mpovanto mwia nrutu Iairaasiva, mwiva mwaanra nraamwuqaa ntaqikyi varuva uro ntero Iesusira kyuqusata tumu ntiro po kye tiro tiqaro, Qati ni nraamwuqi nriante. ");
INSERT INTO omw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ni naamwunra kuaiku 12 ihi varaiva qutu quariva pataqia vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mwitaa huraqinaanra nraakye mpovanto nriqa vuva 12 ihiara tora taqamwaqiro viqaro mpo totaa mpo totaahua uro taqero munima nraahu taiqa kyovaro hia mpovanto mwia kyaahaqa huvaro mwia ruva qati nraahu vahuvaro ");
INSERT INTO omw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","mwi nraakyeva nraakye qora utaqi variro Iesusira mwoqani viqaro Iesusira tuavaaqa vitiqaa kyaatu kyovaro mwia nriqa vuva taiqa vura. ");
INSERT INTO omw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mwitaa huvaro Iesusiva kyapara hiro tiqaro, Tavave niqaa tu varaiho? tuvata mwihua tire hiave tuvaro Pitaava tiqaro, Nronrao, nraakye qora airivantoma i tataaqa nriqata nai rataakye nai rataakye hi variqata ivata qakyaa hiavo, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Iesusiva qaqao tiro, Mpovanto ni tu varaiho. Nte ntapihi kyauqaro ni kepukya hinivanto niqitairo viho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Iesusiva mwitaa tuvaro nraakye mwiva nai riero tiqaro, Qikye, vaakyama Iesusiva ni ntapihi kyaiho, timwa kyero kyuqu kyauqu nti varuvaro uro Iesusira kyuqusata tumu ntiro nraakye qora suqaa variqaro Iesusira timwa mwinro tiqaro, Ni mamanta kyuqema quarive tinama, nte i tuavaaqaqa kyaatu kyauqo. Nte mwitaa huqaro ni nriqa viva qamwanrama kyero taiqa viho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mwitaa tuvaro Iesusiva mwia timwa mwinro tiqaro, Qio ni naamwunrao, e nianra ni kyaahaqa hianinrave qiararoma i nriqa viva taiqa viho. Qioma i mwutukyavanto qihaakya hirara quante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesusiva mwitaa ti varuvaro Iairaasira nraamwuqitairo vaisi mpo titova nri ntero Iairaasira timwa mwinro tiqaro, I nraamwunravanto qutuma viho. Mwaanra ti vari vaisira hia ntavaaqavu taante, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesusiva mwi quara riero Iairaasirara tiqaro, Hia aatu hiante. Nianra kepukyaqama kyera riemwaqira vi variraro i nraamwunravanto qio variarive, tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mwitaa timwa kyero Iesusiva mwia nraamwuqi uro ntero quminahua mwiqi varuhua sitero uto mwaatani variate timwa kyero Pitaaravata, Ioninravata, Iemisiravata, nraaqiara mwia nrohua qohuavata, mwinramwuhua nraahu sita varero qiaatara mwia qutu vuvata vatoraqi viro. ");
INSERT INTO omw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ekyaa nraakye qora mwihua nraaqiara mwianra ntate varuvaro Iesusiva tiqaro, Hia mwianra ntataate. Qiaatara mwiva hiama qutu viho, qati vaitema variho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tuvata qiaatara mwiva qutu vurara tita, mwihua Iesusira quara raima mwatovaro Iesusiva qiaatara mwiva qutu vuraqi vera ntero ");
INSERT INTO omw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","qiaatara mwia kyauquqaa tu varero mwianra vera kyero tiqaro, Mwaa qiaataravao, siquante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mwitaa tuvaro nai mwanraqura naiqi nruvaro mwiva qamwanrama sivuvaro Iesusiva mwiqi varuhuara kyara mwiate tiro. ");
INSERT INTO omw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mwitaa tuvata mwia nrohua qohua nrihanrama vita kyauqu ntukikinraaqate varuvaro Iesusiva mwitanahuara tiqaro, Mate mwaa taqaarara hia mpohua timwa nyiate, tiro. Mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesusiva nai nraaqiara 12 nramwu nyaanrama kyero mwihua vaisiqitaita vaana siteta nriqa vihua kyuqema nyataate tiro, mwihua nronraqama kyero kepukya nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nkye uro Kotiva ntaqikyi quara nraakye qora timwa nyiqatama nriqa vihuavata kyuqema nyataate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mwitaa timwa kyero mwiva tiqaro, Nkye virera hita qatima quate. Hia kyauru quru terave, tuave, kyarave, munimave, tuavaaqa kyaatave, vareta quate. ");
INSERT INTO omw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nkye vivaro ta mwatukyaraqitairove nkyiara qamwateqaro nkyi sitairera, nkye nraamwu kuaaqi nraahu variqi vitama mwi mwatukyara kyetama quate. ");
INSERT INTO omw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nkye vivaro ta mwatukyaraqitairove hia nkyiara qamwatero hia nkyi sitairera, mwi mwatukyara qaqira kyeta nkyetaqaatai ntuvenrauma kyeta qaqira tuto kyetama mwihua timwa nyita tiqata, Nraakiara nkye taqevarave, qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iesusiva mwitaa tuvata mwia nraaqiaranramwu mpo mwatukya mpo mwatukya nrohiqata Kotira qua kyuqe qua timwa nyiqi viqata nriqa vuhuavata kyuqema nyatora. ");
INSERT INTO omw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Iesusivavata, mwia nraaqiaranramwuvata, mpo kyaiqa mpo kyaiqa vare varuvaro mwi quava viro nrinro huvaro Herotiva Kariri mwataqaa ntaqikyi varuva, mwivavata mwi quara riero Iesusira okyarara airi nraato ti varuvata vaisi mponramwuvanto tiqata, Ioniva nramanri nyi varuva qutu vuva qaiqaa siviro nrohi variho, tuvata ");
INSERT INTO omw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","mpo uhua tiqata, Qaqao, tiri haivaqava Iraisaava qovarama viho, tuvata mpo uhua qaqao tita, Tiri haivaqava haaruaa poropeti vaisi mpovanto qati siviro nrohi variho, tura. ");
INSERT INTO omw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mwihua mwitaa tuvaro Herotiva nai tiqaro, Nte Ioninra nrunta teqa kyaavarave. Mwihua mpo qua mpo qua ti varia vaisiva mwiva ta vaisivave? tiro. Mwitaa timwa kyero mwiva Iesusira taqarero uti varura. ");
INSERT INTO omw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iesusiva nai nraaqiaranramwu sitovata vuhua uro ntanteta nrumu mwihua nkyiari nrohu mwakyaakyara Iesusira timwa mwuvaro mwivavata riero, mwiaqaatairo Iesusiva hini nraakye qora mwihua mwini kyero nai nraaqiaranramwu nraahu sitero Vetasaitaani vuvata ");
INSERT INTO omw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","mwini kyo nraakye qorahua mwihua riovaro Iesusiva Vetasaitaani virera huvata mwihuavata mwia vataqita vuvaro Iesusiva mwihua qamwata nyatero Kotiva ntaqikyiani quara timwa nyinro nriqa vuhuavata kyuqema nyatora. ");
INSERT INTO omw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Iesusiva mwitaamaqiro vuvaro huari vuvanto tumi vuvata Iesusira nraaqiara 12 nramwuvanto Iesusiva hunani nri nteta tiqata, Nraakye qora titairata mpo mwatukya mpo mwatukya vaisi varinani uro vaiteqata kyara vara nraate. Mwaini qumina satave, tita. ");
INSERT INTO omw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mwitaa tuvaro Iesusiva qaqao tiro, Nkyetama mwihua kyara nyiate, tiro. Tuvata mwihua Iesusira timwa mwita tiqata, Tire mpereti hini kyauquruvata, tavukya taaratanavata nraahuma vatauro. Nraakye qora airivanto variavo. Tire munima nronraqama kyetave mwihua kyara vara nyiananrave? tita. ");
INSERT INTO omw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Vaisi kyaara ntirerata 5,000 vaisi airivanto varuvaro Iesusiva nai nraaqiaranramwuanra tiqaro, Nkye nraakye qorara tivata ntainra vita mposata 50 nramwu varivata mposata 50 nramwu varita mwitaamaqi vitama ekyaa mwatakyaa vita variate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tuvata mwia nraaqiaranramwuvanto mwihua ntainra kyovata ekyaa mwatakyaa vita varuvaro ");
INSERT INTO omw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iesusiva mpereti hini kyauquruvata, tavukya taaratanavata, vara kyero nyaamwuni taqeqaro Kotirara kyuqeve timwa kyero mpereti nteqa kyero tavukya tukyama kyero nai nraaqiaranramwu nyinro tiqaro, tukyama kyeta mwihua nyiate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nyuvata ekyaa mwihua vikyokyama nreta viti vaati kyovaro qati vahura, Iesusira nraaqiaranramwuvanto utu kyeta ntutantuto tuara 12 nramwu piqa kyora. ");
INSERT INTO omw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mpo enta Iesusiva nanrianraa variqaro Kotiravata qua ti varuvata mwia nraaqiaranramwuvanto mwiva hunani nri ntovaro Iesusiva mwinramwuhua kyapara hiro tiqaro, Qati nraakye qoravanto nianra ta vaisirave tiqatave ti variavo? tuvata ");
INSERT INTO omw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","mwinramwuhua tiqatama, Mponramwuvanto iara mwiva Ioniva nramanri nyi varu vaisivave ti variavata mponramwuvanto iara mwiva Iraisaavave ti variavata mponramwuvanto iara mwiva haaruaa poropeti vaisivanto qati siviro nrohi varivave ti variarave, tita. ");
INSERT INTO omw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mwinramwuhua mwitaa tuvaro Iesusiva mwinramwuhuara tiqaro, Mpo nkyenramwuve? Nkye nianra ta vaisivave tiqatave variavo? tuvaro Pitaava mwia timwa mwinro tiqaro, E Kotiva titaiva, Mesaiaavanto variaro, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pitaava mwitaa tuvaro Iesusiva kepukyaqama kyero qao timwa tero mwinramwuhua timwa nyinro tiqaro, Nkye mwi quara mpohuavata hia timwa nyiate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Iesusiva mwitaa timwa kyero nai nraaqiaranramwu qaiqaa timwa nyinro tiqaro, Nte mwatani mwatatai nraaqiaravave. Nte nriqa quani inraikyara varaqina quarita Iutaa nronra vaisinramwuvata, Kotira kyaiqa vara mwate varia vaisihua mwihua nronra vaisinramwuvata, mwaanra okyara ti varia vaisihuavata, mwihua ni qoririma matevarave. Ni rukyaivaqe nte taarampo enta varina qaiqaa qati siquaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mwitaa timwa kyero Iesusiva ekyaa mwinramwuhua timwa nyinro tiqaro, Ni pataqiro nrianri vaisiva, mwiva nai mwutukya vahiani inraikyara qaqira kyero vaisi rukyeta hiritaa kyatarira mwia mpo enta mpo enta vara qu varero ni naakiara nriananrove. ");
INSERT INTO omw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mwaa mwataraqaa nai qati variqiro quaninranra nraahu nronraqama kyero riaariva, mwi vaisiva ekyaarama qutu quananrove. Vaisivanto nianra riemwaqiro viqaro uro qutu quariva, mwi vaisiva ekyaa enta qati variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Vaisivanto qati variqiro viqaro ekyaa mwata mwaaqaanaa inraikya ntuvaantuama kyero vatero mwiva nai qutiro viro raupirima virera, nataama kyerove mwi inraikyava mwia qio kyaahaqa hiananrove? Hia qio mwia kyaahaqa hiananrove. ");
INSERT INTO omw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Vaisi mpovanto nianravata ni quaravata kyauruariva, mwi vaisiva variraqe nte mwatani mwatatai nraaqiarava variqana nte nraakiara tumuani entaraqaa nai mwi vaisiraravata kyauruaninrave. Mwi entara ni kora peqa okyaravanto niqaatairo ntuvaahe variraqe nte nyaamwunyaahuavata tuminrenrave. Mwi entara nte nai mwi vaisiraravata kyauruaninrave. ");
INSERT INTO omw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nte qutaama tuqo. Vaisi mponramwuvanto mate mwaa mwaini sivita variahua, mwinramwuhua hia qumina qutu vivarave. Mwinramwuhua Kotiva ntaqikyianinra taqetama qutu vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iesusiva mwi quara timwa nyi taiqa kyero kuaa uiki vara kyero mwiva Pitaaravata, Ioninravata, Iemisiravata, mwinramwuhua nraahu sita varero Kotiravata qua tirero taaqiqaara vura. ");
INSERT INTO omw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iesusiva Kotiravata qua ti varuvaro mwia virivanto kyuqu viro mpo qarama vuvaro mwia tuavaaqavanto eqarori tuavaaqa itero takyuqi varuvata ");
INSERT INTO omw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","qamwanrama kye vaisi mpotanavanto qovarama vita Iesusira vatama kyeta qua ti varura. Mwitana nyutu Mosesivavata Iraisaavavata. ");
INSERT INTO omw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mwitanaqaatairo nyaamwuni Kotiva hu inraikyava itero takyuqi varuvata mwitanahua Iesusiravata variqata Iesusiva Kotiva tuntema kyero Ierusaremini qutu quani quara timwaqi vura. ");
INSERT INTO omw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mwihua ti varuvata Pitaaravata, mwia henahua mwitanahuavata, suruara huvata vaita kyeta sivita taqovaro Iesusiraqaatairo nyaamwunyaa inraikyavanto itero takyuqi varuvaro varuvata vaisi taaratanavanto Iesusira vatama kyeta sivita varura. ");
INSERT INTO omw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iesusiravata varu vaisitanahua virera huvaro Pitaava Iesusirara tiqaro, Nronra vaisio, kyuqemama tirenramwu ivatama kyeta varuro. E qiove tirera, tirenramwu haraara nraamwu taaramponramwu hoqa taare. Iara mpo, Mosesirara mpo, Iraisaarara mpoma kyeta hoqa nyataare, tiro. Pitaava hia nai tu quara ntapihiraitiro, apiqama kyero mwi quara tura. ");
INSERT INTO omw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitaava mwitaa ti varuvaro tonamwuvanto qovarama viro mwihua ntumwaqu kyovata Iesusira nraaqiaranramwuvanto mwi inraikyara taqorara aatu hi varura. ");
INSERT INTO omw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mwitaa huvaro quavanto tonamwuqitairo tiqaro, Mwaa ni maaquve. Nte mwaa mwi vaisirave timwa kyena mwia mwatama taurave. Nkye mwia qua nraahu riaate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mwi quara timwa nyi taiqa kyovata mwinramwuhua taqovaro Iesusiva nanrianraa varuvata mwihua tirema variqata mwi entara mwi inraikyara taqorara hia mpohuavata timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mwia qanranraa mwinramwuhua taaqi mwiaqaatai utonte vuvata nraakye qora airivanto nrumu Iesusira hunta kyora. ");
INSERT INTO omw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hunta kyovaro vaisi mpovanto nraakye qora utaqitairo aakyara ntero tiqaro, Mwaanra ti variara vaisio, po, qati e nrinra nrumu ni maaqu taqaante. Mwia ni nraaqiara kuaiqia mwata taurave. ");
INSERT INTO omw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Vaanavanto tauraa ni maaqu tuqara tutaiharo mwiva qua aakyara timwa kyeqaro mwiva kyuqu kyauqu tuto tuto/ato ato hi variharo taaraparavanto nraahu mwia nroqitairo nri varirave. Mwitaamaqi viqaro vaanavanto hia qamwanrama mwia tuta kyaraitiro, qati nraahu mwia tutero variqaro mwia mpoqama kyero ntuqutu kyarero uti variho. ");
INSERT INTO omw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nte i nraaqiaranramwuanra tiqana, Po, qati vaana mwia titaate, tuqata mwihua mwia titaavarovata hia nritarero virave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Vaisi mwiva mwitaa tuvaro Iesusiva tiqaro, Nkye mwaa entara varia nraakye qorahua nkye kyuqe aanraqaa nraahu nrohiataara vaihata nkye hia avuqavu hi aanranraqaa nrohi variavo. Nkye Kotirara qumimaqama kyeqatama hia mwianra riaavo. Qikye, nkye ni popohaira uti variavana nte nataama entave nkyi kyapata variqi viqanave nkyi kyaahaqa hianinrave? tiro. Iesusiva mwitaa timwa kyero mwiva vaisi mwianra tiqaro, Ena mwaaqu vita varera nriante, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","mwiva nai mwaaqu vita varero nri varuvaro vaanavanto mwia mwaaqu ntutahaa kyovaro mwiva mwatasata tumu ntuvaro kyuqu kyauqu tuto tuto/ato ato hi varuvaro Iesusiva vaana mwia inronrama kye titamwa kyero, nyaako mwia vara qioqama kyero mwia vitaqiro iro nai qora mwunra. ");
INSERT INTO omw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mwia mwuvata ekyaa nraakye qoravanto kyauqu ntukikinraaqata kyeta tiqata, Qikye, Kotiva kepukyavanto variho, tita tura. Nraakye qoravanto Iesusiva mpo kyaiqa mpo kyaiqa varorara kyauqu ntukikinraaqate varuvaro ");
INSERT INTO omw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Iesusiva nai nraaqiaranramwuanra tiqaro, Nte nkyi timwa nyiani quara hia taunru kyaate. Mpovanto ni mwatani mwatatai nraaqiarara qovarama kyairata ni ntavaaqavuqita uro vaisi kyauquqi kyevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Iesusiva mwitaa tuvata mwia nraaqiaranramwu mwi quara okyara hia ntapihi kyeta riora. Iesusira nraaqiaranramwuvanto mwi quara hia ntapihi kyeta riaate tiro, mwi quara okyaravanto uqeta vahuvata mwihua aatu hiqata hia mwi quara okyarara Iesusiva kyapara hura. ");
INSERT INTO omw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iesusira nraaqiaranramwuvanto tavave tiriqitairo vunyaa vaisivanto variananrove timwa kyeta inronra hi varuvaro ");
INSERT INTO omw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesusiva mwihua su nyaatoqi vahu quara ntapihi kyero Iesusiva nraaqiara pata mporu vita kyero nai nraaqani vatero ");
INSERT INTO omw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","mwihua timwa nyinro tiqaro, Vaisi mpovanto nianra rieqaro nraaqiara pata mwataa hianinra qamwata mwateqaro mwiva nivatama qamwata mataananrove. Mwiva nianra qamwateqaro mwiva Kotiva ni titairaravatama qamwata mwataananrove. Tavave nkyiqitairo pataqiaru utu quariva, mwivama nkyi vuni variqaro nrutu nronra vataava variananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Iesusiva mwitaa tuvaro Ioniva tiqaro, Nronrao, tire taqauraro vaisi mpovanto i nrutu nteqaro vaana tite varirave. Mwiva hia tirivatama kyero i vataqiro nrohi variva mwitaa ihatara tita, tire mwianra eqaante timwa kyeta mwia antua kyauro, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mwitaa tuvaro Iesusiva Ioninravata, hini mwihuavata, timwa nyinro tiqaro, Nkye hia mwitaa hiataarave. Hia mwia antua kyaate. Mpovanto hia nkyi uaqiama nyataariva, mwiva nkyi kyaahaqa hiarivama variho, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesusira vitero nyaamwuni quariva qaumato vahuvaro Iesusiva Ierusaremini quari vu nraatova nraahu vahuvaro mwiva aanraqaa viro. ");
INSERT INTO omw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aanraqaa viqaro Iesusiva nai nraaqiaranramwu sitovata mwihua nraante vuhua uro Sameriaani mwatukya mpoqi uro nteta Iesusiva vaitaaninra tera hirera huvata mwi mwatanaahua qaqao tita, ");
INSERT INTO omw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Iesusiva Ierusareminianra nrinrenra hiama qio mwaini vaitaananrove, tura. ");
INSERT INTO omw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mwitaa tuvata Iesusira nraaqiaratana Iemisikya Ionikyatana mwi quara riovaro raraqa tovatatana mwihua Iesusirara tiqata, Nronrao, e qiove tiraqe tiretana nyaamwunianra aakyara qiararo qiavanto tumu mwi mwatanaahua itamwa taiqa kyaarive, tita. ");
INSERT INTO omw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mwitanahua mwitaa tuvaro Iesusiva tuqasaaviro mwitanahua inronra hiro tiqaro, Hia mwitaa hiate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mwitaa timwa kyero Iesusiva nai nraaqiaranramwu kyapata mpo mwatukyaqiara vurama. ");
INSERT INTO omw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mwihua aanraqaa vi varuvaro vaisi mpovanto uro ntero Iesusirara tiqaro, Nte i nraaqiara varirerave. E taini tainive vinanrani nte i vataqina virerave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mwitaa tuvaro Iesusiva mwianra tiqaro, Haunri e paparuqa hirorave. Qaakyau vairivanto nai nraamwu nruaunru tairaqi vaite varirave. Nyaamwavanto nai nraamwuqi vaite varirave. Nte mwatani mwatatai nraaqiarava vaitaari nraamwuva hia vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mwitaa timwa kyero mwiva vaisi mpora ni pataqira nriante tuvaro mwi vaisiva tiqaro, Kyai nte ntena kora nraante uro quntamwa tena nrumu i vataqina quankye, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesusiva qaqao tiro, Qutu qua vaisihua votima kye varihua mwihua qioma qutu quaninra mwia quntevarave. E uro Kotiva ntaqikyiani quara nraakye qora timwa nyiante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Iesusiva mwitaa tuvaro vaisi mpovanto tiqaro, Nte i vataqina vireranave. E qiove tiraqe nte quariva uro ntena nramwunaahua kyauqu nyina vuqo timwa kyena nriankye, tiro. ");
INSERT INTO omw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mwitaa tuvaro Iesusiva mwianra tiqaro, Qaqao, ni kyaiqa tohara tero mwiaqaatairo mpo inraikyara rieqaro ni kyaiqa qaqira kyero quari vaisiva hia qio Kotiva ntaqikyi mwatukyaraqi quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nronravanto mwitaa timwa kyero mwiva vaisi 72 nramwu nronraqama kyero mwihua sitero tiqaro, Nkye taaratana taaratana viqata nte virera hiani mwatukyara mpo mwatukya mpo mwatukya nkye nraante ni puni quate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iesusiva mwitaa timwa kyero mpo quaqaa ntumwa kyero timwa nyinro tiqaro, Kyara airivanto keko tihata mwia vantu vareta nrihua hia airivanto variavo. Nkye aakyo qora kyapara hivaro mwiva kyaiqa vaisi mponramwuvata sitairata uro kyara vantuate. ");
INSERT INTO omw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Qio nkye quate. Nte nkyi sitaarita nkye sipisipi nraati votima kyeta qaakyau vairi varinani vivarave. ");
INSERT INTO omw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nkye viqatama hiama munimave, tuave, kyuqu nraamwumate inraikyarave, vareta quate. Aanraqaa viqatama hia nkyi antueqata qua tihua qua mwantaate. ");
INSERT INTO omw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nkye nraamwuqi uro nteta nraamwuqi varihua qua mwanteqata mwataama qiate, Kotiva nkyi qamwata nyatairaro nkyi mwutukyavanto qihaakyama vahirata variate, qiate. ");
INSERT INTO omw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nkye mwitaa timwa kyeta taqaivaro vaisi mpovanto mwi quarara qamwata kyero varirera, Kotirara aakyara nteqata mwi vaisira qamwata mwataante qiate. Taqaivaro mpovanto mwi quarara hia qamwata kyero varirera, hia mwi quara mwia mwiate. ");
INSERT INTO omw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kyaiqa vaisivanto nai kyoqaa varairara tita, nkye mwatukya mpoqi uro variqata nraamwu kuaaqi variqi vivata mwihua nkyi kyarave nramanrive nyinra mwia nraahu nreqata variate. Hiama mpo nraamwu mpo nraamwuqi nrohiqata kyara vara nraate. ");
INSERT INTO omw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nkye mwatukya mpoqi uro ntaivata mwi mwatanaahua nkyi qamwata nyateta tirivata variate tivera, mwihua nkyi nyi kyarara mwia nraahu nreqata ");
INSERT INTO omw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","mwi mwatukyaraqi nriqa virata varihua kyuqema nyateta mwi mwatanaahuara tiqata, Kotiva ntaqikyiariva qaumatoma vaiho, qiate. ");
INSERT INTO omw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nkye mwatukya mpoqi uro ntaivata mwi mwatanaahua hia nkyi qamwata nyateta hia tirivata variate tivera, qaqira kyeta aanraqaa nrumu variqata ");
INSERT INTO omw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","nkyetaqaatai ntuvenrauma kyeta mwitaama timwa nyiate, Kotiva nraakye qoraqaa ntaqikyiari entava qaumato vaihata tire mwi quara nkyi timwa nyinrenrata nrunrahuave. Nrunrata nkye tiri qoririma timwataavata, hia qaiqaavata uro ntanteta nriananrave, qiate. ");
INSERT INTO omw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nraakiara Kotiva ekyaara entaqaa ko qiani entara Sotomi mwatanaahua qua nronra varaivata nkye mate ni qua rieta qoririma kye varihua nkyema qua nronra mpoqiavata varevarave. ");
INSERT INTO omw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Po, nkye Korasini mwatukyani variahuave. Po, nkye Vetasaitaa mwatukyani variahuave. Nkye taqevarave. Nte nkyi suqaa nronra kyaiqa varauntema kyero mpovanto Taiaa mwatanaahuaqivata Sotomi mwatanaahuaqivata vara nyatotirio, mwi mwatanaahua qamwanrama kyetama tuavaaqa nrihi kyaama vara utu vareta hora vara qu vareta qora aanra qaqirama kyotirio. ");
INSERT INTO omw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ekyaara entaqaa Kotiva mwi mwatanaahuaqaa qua nronra vatero nkyiqa qua nronra mpoqiavatama vataananrove. ");
INSERT INTO omw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Po, nkye Kapenaami mwatanaahua nkye tiqata, Tire nronraqama vita nyaamwuni quananrave, qiavo. Qaqao hiave. Nkye hia ni qua riaara kyaara Kotiva nkyi vara kyero qiaqi kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iesusiva mwitaa timwa kyero nai nraaqiaranramwu timwa nyinro tiqaro, Nkyi qua riaari vaisiva ni quavata riaananrove. Nkyi qoririma nyataariva nivata qoririma mataananrove. Ni qoririma mataari vaisiva Kotiva ni titairavatama qoririma mwataananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Iesusiva mwitaa timwa kyero vaisi 72 nramwu sitohua uro nrohita qaiqaa uro ntanteta mwihua qamwata kyeta nrumu Iesusirara tiqata, Qikye, nronrao, tire i nrutu nteqata vaanavata sitaurata nritare quavo, tita. ");
INSERT INTO omw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mwihua mwitaa tuvaro Iesusiva nkyiari timwa nyinro tiqaro, Nte taqe varuqaro Saataaniva nyaamwusairo aaquakyaavanto tintema kyero tumu ntiho. ");
INSERT INTO omw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nkye riaate. Nte nkyi nronraqama kyauqata nkye varivaro quaihave, vaisi ruani tovesivave, varirata nkye mwivau qatima kyuqu ntamwaqi vivarave. Nkye qioma nkyeta nramwutaa Saataaninra nraatara kyaivaro hiama nkyi ruananrove. ");
INSERT INTO omw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nkye vaanavanto nkyi qua riaira, mwianra hia qamwataate. Nkyi nyutu nyaamwuni qara ntumwa taira, mwianra rieqatama nkye qamwataate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Iesusiva mwitaa tuvaro Kotira mwanraquravanto mwia kepukyaqama kyovaro mwiva qamwata kyero variqaro Kotirara tiqaro, Ko, e nronravanto nyaamwuvata mwatavata ntaqikyi variaravave. E mwi inraikyara mwi inraikyara tuqeta tera hia nronra vaisi ekyaa okyara taqaa vaisihua nyaamwutaraitira, mwi inraikyara qumina vaisi nyaamwute variananranra tina, nte i nrutu tuaaherauqo. Eo ko, e ena mwutukya vahira mwitaa hiataa iharara tirama, mwitaa hiaro, tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Iesusiva mwitaa timwa kyero mwiva tiqaro, Ni kova nianra ekyaa inraikyaqaa ntaqikyiante tirave. Hia qumina vaisivanto ni mwia mwaaqu okyara ntapihiarave. Ni kova nai nraahu ni okyara ntapihi kyairave. Hia qumina vaisivanto ni kora okyara ntapihiarave. Nte mwia mwaaquvanto nraahu mwia okyara ntapihi kyaurave. Nte tahuave timwa nyiataa hiraqe timwa nyianrihua, mwihuavatama ni kora okyarara ntapihi kyeta riemwaqita vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iesusiva mwitaa timwa kyero tuqasaa viro nai nraaqiaranramwu nkyiariaraa timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nkye mate mwaa entara taqaarara qamwataate. Haaru nronra vaisive, poropeti vaisive, vunyaa vaisive, mwihuavata mate nkye taqaa inraikyara taqaare tura, hia taqorave. Nkye mate mwaa entara rie varia quara, mwihuavata riaare tura hia riorave, tiro. Mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mwaanra okyara ti varuva mpovanto nri ntero Iesusiva api qua qiarive tiro Iesusirara tiqaro, Mwaanra ti variara vaisio, nte nataa hiani kyaiqara varaqina quaninraqaatainave ekyaa enta qati variqina quaninrave? tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tuvaro Iesusiva mwia kyapara hiro tiqaro, Kotira qua mwaanra qara ntumwa tova nanreve tiho? Mwia okyaravanto nataamave vaiho? tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tuvaro vaisi mwiva tiqaro, Mwia qara ntumwa tova mwataama tiho: Iqaa ntaqikyira Kotirara ekyaa mwutukyaqitairave, vu nraatoqitairave, mwanraquraqotairave, ena kepukyaqotairave, Kotirara nraahu i mwutukya vahiarive. Inanra mwutukya vahintema kyero ina nramwunaanranravata i mwutukya vahiarive, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mwitaa tuvaro Iesusiva tiqaro, Qio e mwitaamaqira viqarama ekyaa enta qati variqira vinanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Iesusiva mwitaa tuvaro mwaanra okyara ti varuva Iesusira qua nraatara kyaankye tiro tiqaro, Qaqao, tavave ni nramwunaa mwiva variho? tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tuvaro Iesusiva mwaa quaraqaa ntumwa kyero timwa mwinro tiqaro, Vaisi mpovanto Ierusaremisairo mwatukya mpo Ierikonianra uto ntero vurave. Mwiva aanraqaa vi varuvata mpuara vaisi mponramwuvanto mwia ntavaaqavu kyeta mwia tuavaaqa ntupema kye vareta, mwia ntuqutu kyeta vate vuvaro aavata ntumwa viro aanraqaa vahurave. ");
INSERT INTO omw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mwiva aanra mwiaqaa vahuvaro Kotira kyaiqa vara mwate varu vaisiva mwia nramwunaa kuaa mwatanaavanto tumiqaro aanra mwiaqaa taqovaro mwi vaisira ntuqutu kyeta kyova vahuvaro mwiva vitira aanra tokya hisataa tumitarero vurave. ");
INSERT INTO omw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Vaisi mwiva qati tumitarero vuvaro vaisi mpovanto mwia kuaa mwatanaa Rivaira okyaravanto, mwivavata Kotira kyaiqa vara mwate varuva tumu ntero mwia aitutuma kyero taqero, qaqira kyero nai henaanra mwia nraantantero vitira aanra tokya hisataa tumitarero vurave. ");
INSERT INTO omw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Vaisi mwivavata qati vuvaro Sameriaa vaisi mpovanto hia mwia nramwunaava, nanrianra mpo mwatanaa vaisivanto aanra mwiaqaa viqaro vaisi mwia taqero mwianra po kye timwa mwatero ");
INSERT INTO omw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","mwia nraaqani uro variqaro vahamwenraqovata, uainiqovata, mwia mwamwanta teqa tora hiqama kyero rupa mwatero mwia kyavuhu kyero nai ntonkiqa mwaanri vatero, mwia vitaqiro uro munima kyeqata vaite varu nraamwunraqi kyero mwiaqaa ntaqikyi varurave. ");
INSERT INTO omw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mwia qanranraa mwiva virera hiro 2 kinaa nraamwu qora mwinro tiqaro, Vaisi mwiaqaa kyuqema kyera ntaqikyi variraqe nte quariva nrohina uro ntantena nrianriva nrumu nataama munimave mwiaqaa kyenanra ina mwiankye, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iesusiva mwitaa timwa kyero mwiva mwaanra okyara ti varu vaisira kyapara hiro tiqaro, Mpuara vaisivanto vaisi mwia aavata ntuqutu kyeta vate vuvaro mwiva varuvata vaisi taarampotanavanto mwia tumu taqorave. Taarampo mwitanaqitairo tavave mwia nramwunaa votima kyero variho? tuvaro ");
INSERT INTO omw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","mwaanra okyara ti varu vaisiva tiqaro, Mwianra po kye tiqaro kyaahaqa hu vaisivave, tuvaro Iesusiva mwia timwa mwinro tiqaro, Evata uro vaisi mwiva hunte hiante, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesusiva nai nraaqiara kyapata Ierusareminianra aanra vuraqaa vuva mwatukya mpoqi uro ntovaro nraakye mpo, mwia nrutu Mataava Iesusira qamwata mwatero nai nraamwuqi vitaqiro uro kyora. ");
INSERT INTO omw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Iesusiva mwiqi variqaro qua okyara timwa nyiqinro vuvaro Mataara nrunravanto mwia nrutu Mariaava Iesusira nraaqani mwatakyaa viro variqaro mwia qua rie varura. ");
INSERT INTO omw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mariaava rie varuvaro Mataava kyara tera hiqaro airi kyaiqa nai nraahu varovaro mwia uaqia huvaro mwiva Iesusirara tiqaro, Nronrao, ni nunravanto hia ni kyaahaqa ihana nte ntena nraahuma kyara tera hi varuqo. E hiave mwia taqaaro? E mwianra tiraro mwiva nrumu ni kyaahaqa hiarive, tiro. ");
INSERT INTO omw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mwitaa tuvaro nronravanto nai timwa mwinro tiqaro, Mataao, Mataao, e mpo inraikya mpo inraikyara nronraqama kyera rie variaravave. ");
INSERT INTO omw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","E kuaa inraikya vuni vahi inraikyarara nronraqama kyera riaataarave. Mariaava ntapihi kyeroma nrumu variqaro mwi inraikyara riaiho. Hia mpo inraikyavanto mwia antua kyaarive, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mpo enta Iesusiva mpoqi uro variqaro Kotiravata qua ti varura. Mwiva Kotiravata qua timwa taiqa kyovaro mwia nraaqiara mpovanto tiqaro, Nronrao, Ioniva nai nraaqiaranramwu timwa nyinro mwataama kyeta Kotiravata qua qiate turave. Evata tiri timwa timwinraqe tire ntapihi kyeta Kotiravata qua qiare, tiro. ");
INSERT INTO omw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Mwataama kyeta Kotiravata qua qiate: Ko, I nrutu kyotata nrutu kyuqera tire tuaaherauro. E tiriqaa ntaqikyiqira vina entava qamwanrama nrianrive. ");
INSERT INTO omw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tire ekyaa enta kyara nraananra tiri timwiante. ");
INSERT INTO omw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mpohua tiri uaqiama timwa taavata tire qaqira kyaunantema kyera evata tire i qua nteqa kyaana quara nruka timwa taante. E tiri tivita vare vi variraqe tire hia uaqia hi kyaiqara utuare, qiate. Mwitaa timwa kyeqata Kotiravata qua qiate. ");
INSERT INTO omw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iesusiva mwitaa timwa kyero nai nraaqiaranramwuanra tiqaro, Nte qati qua mpo tirerave. Nkyiqitairo mpovanto enta mwutukya nai qata vakyaa nraamwu qesaqaa uro ntero tiqaro, Ni vaisio, qamaa taarampoqia ni mpiante. ");
INSERT INTO omw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ni toti mpovanto nyianrasairo nriva ni nraamwuqi nri ntaiharo kyara hia vaihanave, tiraro mwia qata vakyaa mwiva tiqaro, Qaqira kyera quante. ");
INSERT INTO omw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nte qesa tita tena ntena nraaqiararavata vaitema varuqo. Hia nte sivina kyara i mwinrenrave, qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mwitaa tiraro mwiaqaatairo mwiva raaquta kyero nyaanru timwaqi viraro haunri mwiva mwitaa timwaqiro quankyorave tiro, kyara mwia mwiananrove. Hia mwiva mwianra mwiva ni kata pakyaave timwa kyero mwianra rieqaro mwia kyara mwiananrove. Mwiva nai qata vakyaa mwiva pupohama kyero nyaanru timwaqiro quaninra, mwianra riero mwiva siviro mwia mwiananrove tuqo. ");
INSERT INTO omw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mwianra rieqatama nte nkyi timwa nyianinra riaate. Nkye Kotirara nyaanru tivaro mwiva mwi inraikyara nkyi nyianrive. Nkye puaamaqi vita uro puaama kyaate. Nkye qesa ntuqutivaro Kotiva qesa qatua nyataarive. ");
INSERT INTO omw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kotirara nyaanru qiariva qioma varaananrove. Mpo inraikyara puaamaqiro quariva qioma puaama kyaananrove. Qesa ntuqutuani vaisira qatuama mwataananrove. ");
INSERT INTO omw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nkye nraaqiara sohuaqitai tavave mwia mwaaquvanto tavukya mpiante tirara e mwia qarura mwinanra? Hia mwitaa hinanrave. ");
INSERT INTO omw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","I nraaqiaravanto kokoraara uru mpiante tirara e uapaa tovesivanto vaisi kutuaninrave mwia mwinanrave? Hia mwitaa hinanrave. ");
INSERT INTO omw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nkye uaqia hia vaisihua variqatavata nkye kyuqe inraikya nraahu nkyeta nraaqiara nyi variarave. Nkyi sova Kotiva mpo? Mwiva nkyi nraatara kyero qihaakyama kyero nyi varivama variho. Mwiva nkyi sova nyaamwuni variva variraro mpovanto mwia mwanraqurara nyaanru tiraro Kotiva qihaakyama kyero nai mwanraqura mwiananrove, tiro. Turama. ");
INSERT INTO omw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Vaana hia qua tuva vaisi utaqi varuvaro vaisi mwivavata hia qua tuvaro mpo enta Iesusiva vaana mwia titovaro nritarero vuvaro mwiaqaatairo mwi vaisiva qio qua tuvata nraakye qora ntuvaantuama vuhua qikye timwa kyeta kyauqu ntukikinraaqate varura. ");
INSERT INTO omw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mwitaa huvata hini uhua qaqao tita, Pierisepuriva vaana vunyaava Iesusira kyaahaqa hi variharo Iesusiva vaana site variho, tita. ");
INSERT INTO omw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mwihua mwitaa tuvata vaisi mponramwuvantovata Iesusira mwataara hiare tita Iesusirara tiqata, E nronra kyaiqa mpo tiri tivuqaa varairaqe tire taqeta iara qutaama Kotiva i titaiho qiare, tita. ");
INSERT INTO omw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mwitaa tuvaro Iesusiva mwihua nraato tuto quara ntapihi kyero, mwihua timwa nyinro tiqaro, Kuaa mwatanaavanto ntainra vita nai ri nai ri hivera, mwihua qamwanrama taiqa vivarave. Nraamwu kuaaqi varihua ntainra vita nai ntaqi nai ntaqi hivera, mwihua kyatita nkyiariara nkyiariara mpona mpona uro varivarave. ");
INSERT INTO omw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Saataaniva ntaqikyi variarihua ntainra vita nai ntaqi nai ntaqi hi varivera, qiove mwiva kepukyaqama kyero vahiananro? Hia qiove. Nkye nianra tiqata, Pierisepuriva mwia kepukya mwihanro mwiva vaana site variho, qia quava ");
INSERT INTO omw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","qutaa qua vahitiri, tava nkyi sataqi nriahua mwihua kyaahaqa ihatave vaana tite variavo? Nkye nianra qia quara nkyi sataqita nrohia vaisihua unra quave tivarave. Nkyi sataqita nrohi vaisihua ti quava nkyi tu varaananrove. ");
INSERT INTO omw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kotiva ni kepukya mpihana nte vaana site varuqo. Mwi quava qutaa qua vahirara tita, nkye mwianra rieqatama Kotiva tiriqaa ntaqikyiari entava nri ntaiho qiate. ");
INSERT INTO omw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Vaisi kepukyavanto huru kyaamwu terama kyero nai nraamwuqaa ntaqikyiqiro viharo mwiva vatai inraikyava qio vahirave. ");
INSERT INTO omw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mwiva variraro vaisi kepukya mpovanto mwia nraataraariva nri ntero mwiavata ntaqiro mwia nraatara kyero mwiva nraamwu qova huru kyaamwu tutero qio ntaqirerave qiani inraikyara mwiaqaatairo ntavihi kyero varero, mwiva vataani inraikyara vara kyero mpohua nkyiariara nkyiariara nyiananrove. ");
INSERT INTO omw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mpovanto hia ni kyaahaqa hiariva varirera, mwiva ni uaqiama mataarivama variananrove. Mpovanto hia ni kyaahaqa hiqaro ni quara ntuvaantua hiariva, mwi vaisiva ni quara sataqiro mpona mpona uro kyaarivama variho. ");
INSERT INTO omw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Vaanavanto vaisi utaqitairo nritarero uro aahara mwataqaa nrohiqaro kyai nte tekya hiankye timwa kyero taqairaro hia tekya hiariva vahiraro mwiva nai tiqaro, Kyai nte nrumu ntantena vaakya qaqira kyau nraamwunra vaisi mwia utaqi uro qaiqaa variankye, timwa kyero ");
INSERT INTO omw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","uro taqairaro nraamwu mwia ntupi kyero hiqama kye avuqavuma taiva vaiharo ");
INSERT INTO omw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","vaana mwiva uro nai hena vaana 7 nramwu, mwia nraatara kyeta qora kyaiqa uti variahua, mwihua nyaanrama kyero sitero uro vaisi mwia utaqi variananrove. Vuni vaisi mwiva vaana kuaiqiavatama kyero variqaro mwiva uaqiama viro varirave. Nraakiara mwiva vaana airi kyapata variqaro anoma kyero uaqiama viro varirarama tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesusiva mwitaa tuvaro nraakye qora ntuvaantuama vita varuraqitairo nraakye mpovanto vera kyero tiqaro, Qikye, i mwata kyero nraamwa mwi nraakyeva, mwiva mpoqama kyero qamwateqaroma variho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mwitaa tuvaro Iesusiva qaqao tiro, Kotira qua rieqata nrohiahua, mwihuama qamwateqata varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Iesusiva mwitaa tuvata nraakye qora airivanto mwia qua riarerata mwia vara ututu hi varuvaro Iesusiva mwihua timwa nyinro tiqaro, Mwaa entara varia nraakye qorahua anoma kye uaqia hi kyaiqara uti variqata Kotirara hia riaraiqata nrohi variarave. Mwihua nronra kyaiqa tinraamwu tairaqe taqeta tire qutaave qiare ti variarave. Hia nte mwihua suqaa ntena okyara nyaamwu tena nronra kyaiqa varaaninrave. Kotiva haaru nkyi haivaqara Ionaanra utu kyontema nivata mwitaa hiananrove. Mwianra nraahu rieqatama nkye nianra Kotiva mwia kyaahaqa hi varivave tivarave. ");
INSERT INTO omw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ionaava mwitaa mwitaa huvata Niniveqinaahua mwianra ntapihi kyeta tiqata, Kotiva mwia kyaahaqa hi variho, turave. Nte mwatani mwatatai nraaqiaravama varuqo. Nkye mwaa entara varia nraakye qorahua ni okyarara ntapihi riaate tina, nte Ionaava hinte hianinrave. ");
INSERT INTO omw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Haaru nkyi haivaqava Soromoniva kyuqe vu nraato vahuvaro mpo okyara mpo okyara taqe varuva varuvaro nraakye mpo vunyaava mwia qua riarero nai vevara nyianrasairo nrumu Soromoninra qua riorave. Mwi nraakyeva mwitaa hurara tiro, mwiva nraakiara ekyaara entaqaa variqaro nkyiqa qua vateqaro mwitaama qiananrove. Nte nyianrasaina Soromoninra qua riarerana quavarave. Nkye haaru varuvaro Soromoninra nraatara kyo vaisiva nkyi nraaqani varuvata nkye hia mwia qua riorave, qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Haaru Ionaava Kotira qua timwa nyuvata Niniveqinaahua uaqia hu aanranra qaqira kyorave. Mwi mwatanaahua mwitaa hurara tita, mwihua nraakiara ekyaara entaqaa nkyiqa qua vatevarave. Mwihua mwitaama tivarave. Tire Ionaanra qua rieta uaqia hi aanranra qaqira kyaavananrave. Nkye varuvaro Ionaanra nraatara kyo vaisiva Kotira qua nkyi timwa nyuvata nkye hia mwia qua riorave, tivarave. ");
INSERT INTO omw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hia mpovanto omwa qupi kyero amaatainani vatairave. Mwiva hia tave vara kyero mwiaqaa ntumwaqu tairave. Nraakye qoravanto vera ntehua ntapihikye taqaate tiro, mwiva omwa qupi kyero virira nyaamwuni vatairave. ");
INSERT INTO omw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","I vuvanto omwa votima kyero ite variho. I vuvanto kyuqema vahiraro i mwamwantavanto ntuvaahaananrove. I vuvanto uaqia hirera, i mwamwantavanto ekyaa enta hiraqi vahiananrove. ");
INSERT INTO omw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Qio rauri variqara variante. I mwamwantaqi ntuvaahaani inraikyava hia vahiraro enta hiani inraikyava vahiankyorave. ");
INSERT INTO omw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","I mwamwantaqi ntuvaahaani inraikyava nraahu vahiraro hia enta hiani inraikyava mpoqiavata vahirera, i mwamwanta ekyaama omwa votima kyero kyuqema kyero itaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesusiva mwitaa timwa kyero qua timwa nyi taiqa kyovaro Parisi vaisi mpovanto ni nraamwuqi nrinra kyara nraante tuvaro Iesusiva mwikyantiri uro mwia nraamwuqi variqaro kyara nranrenro mwatakyaa viro varura. ");
INSERT INTO omw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Varuvaro Parisi vaisi mwiva taqovaro Iesusiva hia kyauqu hiqaraitiro, kyara nranrenra uti varuvaro mwiva nrihanrama viro airi nraato tuvaro ");
INSERT INTO omw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iesusiva nronravanto mwia timwa mwinro tiqaro, Nkye Parisi vaisinramwuvanto kaapuvata tanuvata mwaaqani nraahu hiqe variarave. Nkyi mwaatira utaqi mpuara varevavata, uaqia hi kyaiqara utivavata nraahuma vaiho. ");
INSERT INTO omw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nkye ueraqa hiahuave. Kotiva nkyi mwaaqani pahi ututaiva mwiva nkyi mwaatira utaqivata ututairave. ");
INSERT INTO omw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nkye mwaatira utaqi vahi inraikyara vehi vaisi kyaahaqamaqi vivaro nkyi mwamwantavanto qioma takyuqu viro vahiananrove. ");
INSERT INTO omw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Nkye Parisi vaisinramwu nraakiara raupirima vira mwianra rieqanama nte nkyiara po tuqo. Nkye Kotira qua hini pata quaqia nraahu rieqatama nkye avuqavuma kyeta nanra inraikya aakyoqi tutaara ntainra kyeta 9 nramwu nkyeta vareta kuaiqia Kotira mwi variarave. Nkye mwi quara pata quaqia nraahu rieqatama Kotira qua nronra qua vahira nkye hia rie variarave. Ntapihi kyeta ko ti okyararave, Kotirara mwutukya vahiani okyararave, nkye mwi quara qaqira kyeta hia nronraqama kyeta riaarave. Nkye Kotira qua pata qua nraahu rieqatama mwia qua nronra quavata riaataara vaihata hia riaarave. ");
INSERT INTO omw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nkye Parisi vaisinramwu nraakiara raupirima vira mwianra rieqanama nte nkyiara po tuqo. Nkye mwaanra nraamwuqi nronra vaisivanto varia taintaraqaara nraahu uti variarave. Nraakye qoravanto nkyiara nronra vaisive timwa kyeta kyakyama kye qua mwantaate tita, nkye maaketiqi qumina qumina nrohi variarave. ");
INSERT INTO omw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nkye nraakiara raupirima vira mwianra rieqanama nte nkyiara po tuqo. Nkye nanra inraikya votima kyetave variavo? Vaisi quntamwa taaraqa hia taqaraitita, nraakye qoravanto mwiaqaa nrohiqata qumina mwataqaave qiavo. Nkye mwitaama kyeta variavata nraakye qoravanto nkyi taqeqata hia nkyi uaqia hi kyaiqara taqaraitita, nkyiara vaisi kyuqe hiahuave ti variavo. ");
INSERT INTO omw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iesusiva Parisi vaisiara mwitaa tuvaro mwaanra okyara ti varu vaisiva mpovanto qaqao tiro, Mwaanra ti variara vaisio, e Parisi vaisiara tiqarama tiriaravata uaqia hi quara qiaro, tiro. ");
INSERT INTO omw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mwitaa tuvaro Iesusiva mwiavata timwa mwinro tiqaro, Nkye mwaanra okyara ti variahua, nkyevata nraakiara raupirima vira mwianra rieqanama nte nkyiara po tuqo. Nkye qumina nraakye qorara ekyaa mwi quara mwi quara riemwaqi quate ti variavata mwihua nkye muaanra ntai quara mwihuaqaa vataara toqaamwu tu kyeta vara qu vare variavata nkye hia nkyeta kyauqu mpoqiavata tutu kyeta mwihua kyaahaqa hi variarave. ");
INSERT INTO omw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nkye nraakiara raupiri hira mwianra rieqanama nte nkyiara po tuqo. Nkyi haivaqahua Kotira qua ti varu vaisihua poropetinramwu rukyeta quntamwa taaraqaa nkye ori ntamwa kyeta mwunruqa hi variarave. ");
INSERT INTO omw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nkye mwitaa hiqata nkyeta haivaqahuara kyuqe hiavo qiarave. Nkyi haivaqahua Kotira qua tu vaisihua poropetinramwu rukyorave. Mwihua mwitaa hiavata qaiqaa nkye variqatama mwihua quntamwa taaraqaa mwunruqa hi variarave. ");
INSERT INTO omw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nkye mwitaa hiarara tiro, Kotiva ekyaa inraikya ntapihi kyaiva tiqaro, Ni qua ti varihua poropeti vaisinramwu sitaarita vivata mwihua mwinramwuhua mponramwu rukyeta mponramwu sataqita viqata uaqiama nyatevarave, tirave. ");
INSERT INTO omw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mwaa mwatara ututo entaraqaatai Kotira poropeti vaisi ruqi nrita mate mwaa rua quava, ekyaa mwi quava nkyi mate mwaa varihuaqaama vahiananrove. ");
INSERT INTO omw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tohara kyero Everira rukyovata mwiaqaataita poropeti vaisi ruqita vita uro Sekaraiaaravata rukyorave. Sekaraiaara rukyarera hita qia munra quaninra quaro taintara vahuvaro Kotira nraamwu kyotata vahuvaro mwia utana mwia rukyovaro mwia nraanre raururave. Qio nai poropeti ekyaa rukyora kyaara Kotiva mwaa entara vari nraakye qorahuaqaa qua vataananrove. ");
INSERT INTO omw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Nkye mwaanra okyara ti varia vaisihua, nkye nraakiara raupiri hira mwianra rieqanama nte nkyiara po tuqo. Kotira okyara quavanto vaihata nkye kiqa tutetama hia qesa mwia qatua kye viqeteta mwi okyarara taqaavo. Nkye nkyeta qesa mwia hia qatua kyeta viraitita, nkye mpohuavata virera hiavata mwihua antue variarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesusiva mwitaa timwa kyero nraamwuqitairo veva ntovata mwaanra okyara tuhuavata, Parisi vaisinramwuvata, raraqa tovata Iesusirara uaqia hi quarama tiho timwa kyeta nrivaqe tire qaiqaavata riaararo uaqia hi quara tirera, koqi vitaqita vataare tita. ");
INSERT INTO omw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mwitaa timwa kyeta mwihua Iesusiva api qua qiarive tita, mpo qua mpo qua Iesusira kyapara hura. ");
INSERT INTO omw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mwitaa huvata airi tauseni nraakye qoravanto Iesusira taqarerata nrumu variqata nai rataakye nai rataakye hi variqata nai kyuqu nai kyuqu ntatami varuvaro Iesusiva nai nraaqiaranramwu nraante qua timwa nyinro tiqaro, Qamaa pataqia taupatairaqaatairo ekyaa viro ntera vintema kyeta Parisi vaisivanto nkyivata vara uaqiama kyevorave. Mwihua kyuqe kyaiqa varauro timwa kyeqata vaisi suqaa kumwaanri hi variararama tuqo. Nkye mwihua nraantantevorave. ");
INSERT INTO omw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mpovanto taqaankyo tiro mate ntumwaqu taani inraikyara, nraakiara vara qosata kyaananrove. Mate uqeta taani inraikyara nraakiara qovarama kyairaro qoqaama vahiananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nkye kyokiraqi variqata ti quara nraakiara qaata taaninraqaama rievarave. Nkye qesa tita teta mwaanrinra nraamwuqi variqata tirema kyeta qua tira, nraakiara mwi quara qesaqaatairo aakyara ntamwa kyero qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ni mwatanaa tuaavo, nte qianinra riaate. Nkyi nyamwanta nraahu rukyehua hia mwihua nraatu aatu hiate. Mwihua nkyi rukyeta hia nkyi mwanraquravata qio rukyevarave. ");
INSERT INTO omw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nkye tara nraatuve aatu hiqata varivarave? Kyai nte nkyi timwa nyiankye. Nkye Kotira nraatu aatu hiqata variate. Mwiva kepukyavanto variqaro vaisi rukyero mwiaqaatairo qioma mwia qutu vihua vinani tuto kyaarivama variho. Eo, nte nkyiarama tuqo, Nkye Kotira nraatu aatu hiqatama variate. ");
INSERT INTO omw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Qutaa vaisivanto munima taararu kyeqaro pata nyaamwa hini kyauquru varairave? Nkye riaate. Kotiva pata nyaamwa mpoqiaru hia taunru kyaraitiro, mwiaqaavata kyuqema kyero ntaqikyi varirave. ");
INSERT INTO omw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kotiva nkyiqa ntaqikyiqaroma nkyi okyara, ekyaa taqe variva, mwiva nkyi qiata kyaahivata ekyaa kyaara ntumwa tairave. Nkye qumina nyaamwa nraatara kyaarave. Kotiva qumina nyaamwaqaavata ntaqikyivara tiro, nkyiqaavata nritarero kyuqema kyero ntaqikyi varirara tita, hia aatu hiqata variqita quate. ");
INSERT INTO omw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nte qianinra riaante. Vaisi mpovanto nraakye qora suqaa variro timwa qovarama kyero nianra tiqaro, Nte mwia nraaqiarama varuqo, tirera, nte mwatani mwatatai nraaqiarava variqana nraakiara ntevata nyaamwunyaahua suqaa variqana timwa qovarama kyena tiqana, Nai mwi vaisivama ni nraaqiarama variho, qianinrave. ");
INSERT INTO omw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mpo vaisivanto nraakye qora suqaa variro tiqaro, Hia nte Iesusira nraaqiarama varuqo, tirera, nte mwatani mwatatai nraaqiarava variqanama nraakiara ntevata nyaamwunyaahua suqaa mwi vaisirara tiqana, Mwiva hia ni nraaqiarama variho, qianinrave. ");
INSERT INTO omw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Vaisi mpovanto ni mwatani mwatatai nraaqiarara qora qua tirera, Kotiva mwi vaisira qora qua qioma nruka mwataananrove. Vaisi mpovanto Kotira mwanraqurara qora qua tirera, Kotiva hia mwia qora qua nruka mwataananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nraakiara ni kyaara nkyi rupaqita uro mwaanra nraamwuqive, kamaninra vuqaave, vunyaa vaisi suqaave, uro kyaivata mwi entara hia aatu hiqatama nanra quave qiananrave qiate. ");
INSERT INTO omw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mwi entara Kotira mwanraquravanto nkyi kyaahaqa hiqaro mwitaa mwitaa qiate tirata nkye mwi quara timwa nyiate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nraakye qora ntuvaantua huraqaatairo vaisi mpovanto Iesusirara tiqaro, Mwaanra ti variara vaisio, ni kova qutu virero hiro nianravata ni pakyaararavata nai hi inraikyarara ntainra kye varaate tirave. Mwitaa tiharo ni pakyaava nai nraahu varero hia nivata ntainra kyero mpiho. Evata tiraro mwiva nivata ntainra kyero mpiarive, tiro. ");
INSERT INTO omw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mwitaa tuvaro Iesusiva mwia timwa mwinro tiqaro, Qaqao, mwaa vaisivao, Tava ni nronraqama kyaihanave nte mwi quara mwi quara qio avuqavu hianinrave? tiro. ");
INSERT INTO omw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mwitaa timwa kyero Iesusiva ekyaa nraakye qora timwa nyinro tiqaro, Nkye rauriqata variate. Nkye airi inraikyave airi munimave varera mwianra nraahu nronraqama kyeta rieqata variqi vivorave. Nkye tiqata, Airi inraikya vateqata qioma variqi quananrave, tivorave. Hia airi inraikyavanto nkyi kyaahaqa hirata nkye kyuqema kyeta variqi vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iesusiva mwitaa timwa kyero mwiva mpo quaqaa ntumwa kyero timwa nyinro tiqaro, Vaisi mpovanto airi inraikya vatova kyara vara tu kyero vatovaro inraanrama vahuvaro vantiqiro vatero ");
INSERT INTO omw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","nai timwa kyero riero tiqaro, Nte mwaa kyarara ta nraamwunraqive vataaninrave? Ekyaa ni nraamwuqi kyaravanto piqama viho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mwitaa timwa kyero mwiva tiqaro, Kyaiqe nte ekyaa nraamwu ntapairi kyena, qaiqaa nraamwu nronra airi hoqa kyena mwiqi kyaravata hini mpo inraikyavata vataankye. ");
INSERT INTO omw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nte mwi kyaiqara vara taiqa kyena mwitaama qianinrave, Nte kyuqemama varuqo. Airi kyara airi inraikya vaihana nte airi ihi qati variqi viqana mwaa kyararavata nramanrivata nramwaqi viqana kyuqema kyena varianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mwi vaisiva mwitaa tuvaro Kotiva mwia timwa mwinro tiqaro, Hia i vu nraatovata vahivave. Mate entaqi e qutu vinanrave. E qutu viraro e ninive tina inraikyara mpovanto varaananrove turave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Iesusiva mwitaa timwa nyinro qua taiqa kyero mwiva tiqaro, Vaisivanto mpo inraikya mpo inraikya ntuvaantua hianinranra nraahu riemwaqiro vi variraro Kotiva mwi vaisirara tiqaro, E vatera inraikyava qumina inraikyave. Nte taqauqara e vehi vaisi nraahuma variaro. E qumina qutu vinanrave, qiananrove, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mwitaa timwa kyero Iesusiva nai nraaqiaranramwuanra tiqaro, Mwi quara rieqanama nte nkyiara mwitaama tuqo, Nkye qati variqi virarave, nkye kyara nrenranrave, nkye tuavaaqa utirarave, hia mwi inraikyara mwi inraikyarara airi nraato tuate. ");
INSERT INTO omw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nkye qati variqi viva vahirero tauraanaa inraikya vaiharo nkye kyara nreva mwiva vahirero nraakiaraanaa inraikyama vaiho. Nkyi mwamwantavanto tauraanaa inraikya vaiharo nkye tuavaaqa ututeva nraakiaraanaa inraikyama vaiho. ");
INSERT INTO omw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nkye nyaamwanra nraato tuate. Nyaamwavanto hia kyara vara tu kyero vantuqiro nai nraamwuqi vate varirave. Nyaamwavanto variavaro Kotiva mwihuaqaa ntaqikyiqiro viqaro kyara nyinrave. Qio nkye nraakye qoravanto nyaamwa nraatara kyaahuara tiro, Kotiva nkyiqa kyuqema kyero ntaqikyiananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nkyiqitairo tavave nte mwata mwaaqa mpuahaama variankye timwa kyero mwianra airi nraato tiqaro mpo entanramwu tomaqa kyaananrove? Hiama qio mpovanto mwitaa hiananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nkye pata kyaiqa mwia hia qio vare variahuara tita, nkye nanraqamave mpo inraikya mpo inraikyara airi nraato ti variavo? ");
INSERT INTO omw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Uakukyaqi qupiqai maunranra rieqata variate. Mwi maunrava hia kyaanta huvu kyero nai tuapakyaara hutairave. Haaru vunyaa vaisivanto Soromoniva kyuqema kyero mwunruqama torave. Maunra pairavanto iteqaro Soromoniva mwunruqama toravata nraatara kyairarama tuqo. ");
INSERT INTO omw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kotiva mwivama uakukyaqi vahi maunranra mwunruqama mwatairave. Mwi maunrava mate vahirata hura qia qura kyaivaro itamwa kyaananrove. Qio Kotiva qumina uakukyaqi pataqia vahi maunranravata mwunruqama mwataivara tiro, mwiva nkyi nraakye qoraqaa ntaqikyiqaro mwiva hiave nkyivata tuavaaqa utu nyataananrove? Qikye, nkye Kotirara tiqata, Mwiva hiama qio tiri kyaahaqa hiananrove, timwa kyeqata hia mwianra kepukyaqama kye rie variavo. ");
INSERT INTO omw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kotiva nkyi kyaahaqama nyate varirara tita, nkye hia nronra nraato tiqata, Nanra kyarave nraananrave? Nanra nramanrive nraananrave? timwaqi quate. ");
INSERT INTO omw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mwatani variahua hia Kotirara riaa nraakye qorahua mwihua mwitaamaqi viqata mwi inraikyara mwi inraikyara puaa hirerata uti variarave. Nkye hia mwihua hiante hiate. Nkyi sova nkye ekyaa mwi inraikyara varerara ntapihi kyeroma variho. ");
INSERT INTO omw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kotiva nkyiqa ntaqikyianinra nkye mwianra nraante nronraqama kyeta riemwaqi viqata Kotira kyaiqa vare varivaro Kotiva kyara mwiavata, tuavaaqa mwiavata, nkyi nyiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Iesusiva mwitaa timwa kyero qaiqaa tiqaro, Nkyenramwu varirerata nkye ni sipisipinramwu variavo. Hia aatu hiate. Kotiva nkyi sova nkyiara qamwateqaro varivara tiro, mwiva nraakiara nkyiqa ntaqikyi varirata nkye mwiva ntaqikyiani mwatukyaraqi varivarave. ");
INSERT INTO omw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nkyeta vate inraikyara mpohua munimanra nyivata mwihua vareta nkyi munima nyivata nkye uro mwi munimanra vehi nraakye qora nyiate. Hia munima pausi mwatani taiqaaninraqi nkyeta kyoqaa vataate. Nkye munima pausi nyaamwuni ekyaa enta qati vahianinraqi nkyeta kyoqaa vataate. Mwini vate inraikyara hia mpuara varairaro hia uapaa tovesivanto nraananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nkye mwaa mwataraqaa kyoqaa ntuvaantuamaqi vivera, nkye mwaa mwataraqaa vahiani inraikyarara nraahu riemwaqi vivarave. Nkyi kyoqaa nyaamwuni ntuvaantuama viro vahirera, nkye nyaamwunianra nraahu nronraqama kyeta riemwaqi vivarave. ");
INSERT INTO omw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Nkye sivita tuavaaqa tuqara kye ututeta omwa qupi kyeta terama teqata variate. ");
INSERT INTO omw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nkye kyaiqa vaisi mwaanramwuhua hiante hiate. Kyaiqa vaisinramwuvanto variavaro mwihua nronra vaisivanto nraakye ntumwuanani viva urontante nrumu qesa ntukuakua hiqaro taqaihatama mwia kyaiqa vaisinramwuvanto qamwanrama qesa qatua mwataarave. Nkyevata qesa qatuararerata terama teqata variate. ");
INSERT INTO omw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mwihua nronra vaisivanto nri ntero taqairata mwia kyaiqa vaisinramwuvanto hia vaite variraitita, qati sivita teramate varihua mwihua qamwataate. Mwihua mwitaama varivaro mwihua nronra vaisivanto mwihua kyara nyiani tuavaaqara vara kyuqinra kyero ututero nai kyaiqa vaisiara tiqaro, Mwatakyaa vi varivaqe nte nkyi kyara nyiankye, timwa kyero kyara nyiananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Enta mwutukyaqive, kokoraara nruqua qianinraqaave, nronravanto uro ntantero nrumu taqairata mwia kyaiqa vaisinramwuvanto hia vaite variraitita, qati sivita teramate varihua, mwihua qamwateqata variate. ");
INSERT INTO omw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Qio nkye mwaa quara rieqata variate. Nraamwu qova variqaro mpuara vaisivanto mwi entarama nriananrove timwa kyero mwiva nai nraamwuqaa ntaqikyi varitirio, mpuara vaisivanto hiama qio mwia nraamwuqi vera ntero mpuara vararaitirio. ");
INSERT INTO omw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mwi quara rieqatama nkyevata teramate variqata ni pekya variqi quate. Nkye ni mwatani mwatatai nraaqiarara hiama tumuananrove ti entara, mwi entaraqaa nte tumuaninrave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Iesusiva mwitaa tuvaro Pitaava tiqaro, Nronrao, tiriara nraahu rieqarave mwi quaraqaa ntumwa kyera timwa timwianro? Ekyaa huara rieqarave mwi quara tira hiaro? tiro. ");
INSERT INTO omw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tuvaro Iesusiva tiqaro, Kyaiqa vaisi kyuqeva nai nronra vaisiara rieqaro kyuqema kyero kyaiqa vare vari vaisiva, mwiva ta vaisira votima kyerove variananrove? Mwiva kyaiqa vaisi mwataa hiarivama variananrove. Mwia nronravanto nyianrani virera hiro vaisi mwia nronraqama kyero tiqaro, Ema kyaiqa vaisi hini mwihuaqaa ntaqikyiqarama mwi entaraqaa mwi entaraqaa kyara tukyama kyera nyiante, timwa kyero ");
INSERT INTO omw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","quariva uro nyianra mponani nrohiro nrumu taqairaro mwia kyaiqa vaisivanto mwiva tintema kyero kyaiqa vare varirera, mwiva mpoqama kyero qamwataananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mwianra rieqana nte nkyi timwa nyuqo, Mwia nronra vaisivanto mwi vaisirara tiqaro, Nte qaiqaa i nronraqama kyaarira e ekyaa nte hu inraikyaraqaa ntaqinkyinanrave, qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mwia kyaiqa vaisivanto qaqira kyero hia mwitaa hiraitiro, nai riemwa kyero tiqaro, Qaqao, ni nronravanto hiama qamwanrama nriananrove, timwa kyero mwiaqaatairo nai henahua kyaiqa nraakye qora mwihua ntuqutu kyero vatero kyara airi nramwaqiro viro uainivata nrenro uera ntero mwitaamaqiro vi varirera, ");
INSERT INTO omw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mpo enta mwia nronravanto hiama mwi entaraqaa nriananrove qiani entaraqaa uro ntantero nrumu mwia kyaiqa taqero nai kyaiqa vaisi mwia ntuqutu kyero vatero mwia titero tiqaro, E ni qua hia riaahua varianani quante, qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kyaiqa vaisi mpovanto variraro mwia nronravanto mwi kyaiqara varaante tiraro mwi quara riero qaqira kyero hia mwi kyaiqara vararero tera hiraitiro, qati variraro mwia kyaara mwia nronravanto mwia nronraqama kyero kyaamwuqo ntuqutu mwataananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kyaiqa vaisi mpovanto variqaro mwiva hia nai nronra vaisi kyakya hira ntapihiraitiro, mwivavata uaqia hi kyaiqara uti variraro mwia kyaara mwia nronravanto mwia pataqia ntuqutuananrove. Airi inraikya varehua varivaro Kotiva mwihua airi inraikyara nina mpiate qiananrove. Airi inraikya mpoqiavata varaari vaisiva variraro Kotiva mwianra airi inraikya mpoqiavata nina mpiante qiananrove. Kotiva vaisi mpo pata kyaiqa nraahu mwianinra mwianra tiqaro, E mwiqiara nraahu varairaqe nte qiove qianinrave, qiananrove. Kotiva vaisi mpo nronra kyaiqa mwianinra mwianra tiqaro, E mwia nraahu varairaqe nte qiove qianinrave, qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nte qia tuta kyaariro itaarive tina, mwaa mwataraqaa tumuvave. Qikye, mwi qiava vaakya ite variraqe qiove qiataarave. ");
INSERT INTO omw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nte nramanri mpo varaaninra hiama varauqo. Nte mate mwia vekya varuqaro ni anoma kyero muaanra ntaihana varuqo. Nte mwitaama kye variqi vina mwiaqaatai mwi nramanrinra varena nte qio varianinrave. (Iesusiva mwi quara mwitaa tiqaro mpo quaqaa ntumwa kyero nai qoririma kyeta ru kyaivaro qutu quaninranra tura.) ");
INSERT INTO omw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nkye nianra tiqatama, Nraakye qoravanto mwaateraqama vita variate tiro, mwiva tuminrave, qiarave? Qaqao, hia nte mwitaama variate tina, tumuvave. Nraakye qoravanto ntainra vita variate tina, nte tumuvave. ");
INSERT INTO omw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mwaa entaraqaataita hini kyauquruvanto kuaa nraamwuqi variahua ntainra vita taarampoqiavanto nramwutaaqa hiqata taara mwitanahua vatama kyeta ntaqivarave. ");
INSERT INTO omw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Qova nai mwaaquntiriro ntaqiraro mwaaquvanto nai qokyantiri ntaquananrove. Nrova nai nraamwunrantiri ntaqiraro nraamwunravanto nai nrokyantiri ntaquananrove. Nraakye mpovanto nai nraaqutuntiri ntaqiraro mwiva naivata ntaquananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesusiva mwitaa timwa kyero nraakye qora ntuvaantuama vuhua timwa nyinro tiqaro, Nkye taqaavaro tonamwuvanto vutusairo nriqanro kyokira rutaihata nkye tiqata, Vati ntirerove, qiavaro vati ntirave. ");
INSERT INTO omw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nkye taqaavaro toqa vaururuvanto nrihata nkye tiqata qio vuhaananrove qiavaro vuhairave. ");
INSERT INTO omw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Qikye, nkye unraqanraama kyeqata kyuqe kyaiqa vare variahuave. Nkye mwi inraikyara mwi inraikyaraqaa qio vitama kye taqeta, nanraqamave nkye mwaa entara qovara hiani okyarara hia vitama kyeta taqaavo? ");
INSERT INTO omw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nkye nraato tu kyeta kyuqe kyaiqa nraahu varaare qiataara vaihata nkye nataamaqive hia mwi kyaiqara varaavo? ");
INSERT INTO omw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mpovanto iqaa qua vatero ko nraamwuqi i vita varero virero hirera, e mwikyantiri aanrani viqarama mwi quara avuqavu hiante. Mwiva i vita varero ko riaani vaisiva hinani uro kyairaro mwiva i vita porisi mwinranro porisivanto i karavuqi uro kyaankyorave. ");
INSERT INTO omw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nte qianinra riaante. E hia karavuqitaira qamwanrama taiqenanrave. Ekyaa munima hia nai mwinraitira, hia qio vinanrave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mwi entara vaisi mponramwuvanto nri nteta Iesusira timwa mwita tiqata, Karirinyaa vaisinramwuvanto quara ru kyeta Kotira qamwata mwataare tuvaro kamaniva mpo, mwia nrutu Pairaativa nri ntero mwi vaisinramwuhua ru kyovaro mwihua nraanrevanto quara vaakya rukyora mwia nraanre vatama kyero vahurave, tita. ");
INSERT INTO omw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mwitaa tuvaro Iesusiva tiqaro, Karirinyaa vaisinramwu mwitaama kye qutu vurara tita, nkye nataamave riaavo? Nkye tiqata, Mwihua qora kyaiqavanto Karirinyaa vaisi hini mwihua qora kyaiqa nraatara kyaihove, qiavo? ");
INSERT INTO omw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Hiave. Nte qianinra riaate. Nkyevata hia qora aanra qaqira kyaivera, nkyevata mwinramwuhua qutu vuntema kyetama qutu vivarave. ");
INSERT INTO omw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Haaru Siroamini ori nraamwu mpuahaa nraamwuvanto ntuvuraa viro tumu ntiro vaisi 18 nramwu rukyorave. Mwi vaisinramwuhua mpo? Nkye mwinramwuhuara nanra quave qiavo? Nkye tiqata mwinramwuhua qora kyaiqavanto Ierusareminyaahua qora kyaiqa nraatara kyovaro mwia kyaara nraamwu mwiva ntuvuraa viro mwihua ntuqutu taiqa kyorave. Nkye mwitaamave qiavo? ");
INSERT INTO omw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Qaqao, hiave. Nte qianinra riaate. Nkyevata hia qora aanra qaqira kyaivera, nkyevata mwinramwuhua votima kyetama qutu vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesusiva mwitaa timwa kyero mwiva mpo quaqaa ntumwa kyero mwihua timwa nyinro tiqaro, Vaisi mpovanto nai utaqi fiki kyatari mpo vara tutorave. Mwi vaisiva vara tutero vari kyero mpo enta kyai uro mwia tamwa hiqu kye nraankye timwa kyero uro taqovaro hia tamwa riorave. ");
INSERT INTO omw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hia riovaro nai kyaiqaqaa ntaqikyi varu vaisirara tiqaro, Taqaante. Nte taarampo ihiara vina nrina hiqana mwaa kyatariva tamwa riaaninra vekya varuqaro hia tamwa riairave. E mwaa teqa kyera qaqira kyaante. Mwi kyatariva qati vahiqaro kyuqe mwata taiqa kyaankyorave, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","mwia kyaiqa vaisivanto qaqao tiro. Kuaa ihiara mwia qati kyairaqe nte mwia okyaraqi onti quvu kyena tapitaani mwatara varaqina mwiqi vatena quvu ntamwa taariro tamwa riaarive. ");
INSERT INTO omw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mpo ihiqi taqairaro mwi kyatariva tamwa riairera, e mwia qati kyaante. Hia tamwa riairera, e qioma teqa kyera qaqira kyenanrave turave, tiro. Iesusiva mwi quara turama. ");
INSERT INTO omw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mpo enta mwaanraqaa Iesusiva mwaanra nraamwu mpoqi qua timwa nyi varuvaro ");
INSERT INTO omw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","nraakye mpovanto mwiqi varura. Vaanavanto nraakye mwiavata varuva mwia nriqa vu inraikyara mwuvaro nraakye mwiva 18 ihiara nriqa vuvaro variqiro vura. Mwia mwoqavanto ntavaka vuvaro mwiva hia ntatuta variraitiro, kakataama viro nraahu varura. ");
INSERT INTO omw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesusiva mwia taqero mwia nraanrama kyero tiqaro, Mwaa nraakyevao, i nriqa viva taiqama viho, ");
INSERT INTO omw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","timwa kyero nai kyauqu mwiaqaa viti vatovaro nraakye mwiva qamwanrama kyero mwaamwianra viro variqaro Kotira nrutu tuaahereqaro varura. ");
INSERT INTO omw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kotira nrutu tuaahere varuvaro Iesusiva mwaanra entaqaa mwi nraakyera kyuqema kyorara tiro, mwia kyaara mwaanra nraamwuqaa ntaqikyi varu vaisira raraqa tovaro nraakye qorara tiqaro, Kyaiqa enta 6 nramwuma vaiho. Mpovanto nkyi nyamwanta kyuqema kyaarive tita, mwi entaraqaa nraahuma nriate. Hia mwaanra entaqaa nkyi mwamwanta kyuqema kyaarive tita nriate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Vaisi mwiva mwitaa tuvaro nronravanto Iesusiva nai timwa mwinro tiqaro, Nkye unraqama kyeqata kyuqe kyaiqa vare variahuave. Nkye ekyaa mwihua mwaanra entaqaa nkyeta purimakauve, ntonkive, nraamwuqitai ntatu kyeta sitaqita tumu nramanri nyi variarave. ");
INSERT INTO omw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nraakye mwaava nkyi haivaqara Evarahaamunra nraisivanto variharo Saataaniva 18 ihiara mwi nraakyera rupa tairave. Qioma mwaanra entaqaa kyaahaqa hiqana huvantu kyaaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesusiva mwitaa tuvata mwia nramwutaahua mwi quara rieta kyaurita varuvata qumina nraakye qora mwihua Iesusiva kyaiqa varorara rieqata Iesusira qamwata mwatora. ");
INSERT INTO omw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iesusiva tiqaro, Kotiva ntaqikyiariva nanra inraikya votima kyerove vahiro iho? Nkye mwianra ntapihi kyeta riaate tina, nte nanra inraikyaqaa ntumwa kyenave qianinrave? ");
INSERT INTO omw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Qio nte maasiteti uruqaa ntumwa kyena tirerave. Vaisivanto maasiteti uru aakyoqi isa taiharo mwia uru pata mwiqiava ntukohiro qupiqero kyatari nronra vaihata nyaamwavanto kyauqu kyaara mwiqi nrumu vari vaite hiarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mwitaa timwa kyero Iesusiva qaiqaa tiro, Kotiva ntaqikyiariva nanra inraikya votima kyerove vahiro iho? ");
INSERT INTO omw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mwiva taupataira votima kyeroma vaiho. Nraakyevanto mpereti utarera hiro parauaa vara kyero mwiva nrakyo taarive timwa kyero, taupataira vara kyero paraua vatama kyero tuqasaa kyaiharo taupataiva ekyaa viro nrinro hiro mpereti uqenra kyaiharo nrakyo tairave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesusiva mwitaa timwa kyero Ierusareminianra viqaro mwatukya nronraqivata, pataqivata, kyuqe qua mwakyaakya timwa nyinro. ");
INSERT INTO omw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mwitaamaqiro vuvaro vaisi mpovanto tiqaro, Nronrao, nraakiara Kotiva tiriqitairo pataqiatanave tivitaananrove? tiro. Mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Nyaamwunianra quava qesa pataqiave. Nkye mwukyaari mwata kyeta qesa mwina quate. Nte nkyi qutaa timwa nyuqo. Nraakye qora airivanto quare tiravata hia qio vivarave. ");
INSERT INTO omw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nraamwu qova qesa tita tairata nkye mwaatani varivorave. Nkye mwaatani varita qesa ntuqutita tiqata, Nronrao, qesa qatua timwa taante, tivaro mwiva, Qaqao nkye tainyaahuave. Nte hia nkyi taqauhuave, qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mwiva mwitaa tirata nkye tiqata, Qaqao, tire ivatama kyeta kyara nraunrahuave. E tiri mwatukyaqi variqara qua timwa timwianrahuave, tivaro mwiva qaiqaa tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nkye tainyaahuave? Nkye uaqia hi kyaiqara uti variahuave. Hiante mwaisaita quatema, qiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Iesusiva mwitaa timwa kyero tiqaro, Nkye nraakiara taqaivata nkyi haivaqahua Evarahaamuvavata, Aisaakivavata Iaikopuvavata, ekyaa poropeti vaisinramwuvata Kotira mwatukyaqi varivata nkye mwaaqani varita ntateqata nkyeta aanrai teti nreqata varivarave. ");
INSERT INTO omw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nraakiara huari vu nri ntainanyaahuave, huari vu vinanyaahuave, mwaa hini tokyanyaahuave, vitira hini tokyanyaahuave, mwihua nrita ntuvaantua hita Kotira mwatukyaqi kyara nrevarave. ");
INSERT INTO omw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mate mwoqani varihua nritareta vunima varivarave. Mate vuni varihua tumitareta mwoqanima varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iesusiva mwitaa tuvata Parisi vaisinramwu nri nteta Iesusirara tiqata, Sivira nritarera mpo mwatukyani quante. Herotiva vunyaa vaisivanto i ru kyarero uti variho. E mwaini variraro mwiva i ru kyaankyorave, tita. ");
INSERT INTO omw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mwihua mwitaa tuvaro Iesusiva timwa nyinro tiqaro, Nkye uro qaakyau vairi mwia timwa mwiate. Nte matevata huravata vaana siteqana nraakye qora kyuqema nyatarerave. Mwitaamaqi vina mpora taarampo enta mwiqiaraqaa ntena kyaiqa taiqa kyarerave. Nkye mwia mwitaama timwa mwiate. ");
INSERT INTO omw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nte matevata huravata mporavata Ierusaremini virerave. Hia qumina mwataqaa poropeti vaisi ru kyevarave. Ierusareminima ru kyevarave. ");
INSERT INTO omw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Po, Ierusaremiqinaa nraakye qora tuaavo. Po, Ierusaremiqinaa nraakye qora tuaavo. Nkye Kotira poropeti rukyaahuave. Kotiva titai vaisihua variavata nkye ori pati kyeta mwihua ntuqutu kyaahuave. Kokoraaravanto nai nraatiqaa nraaokya iri kyero ntumwaqu taintema kyena nte qaiqaavata qaiqaavata nkyiara po timwa kyena nkyiqa ntaqikyirera huqata nkye ni qoririma mataavo. ");
INSERT INTO omw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mwia kyaara Kotiva nkyi qaqira kyairaro nkyi mwatukyaqi hia vaisivata varivaro qumina mwata nraahuma vahiananrove. Nte qianinra riaate. Nkye mwaa entaraqaataita hia ni taqaraitita, variqi vivaqe nte qaiqaa tumu variarita nkye mwi entara ni ntapihi kyeta taqeqata nianra tiqata, Kotiva titai vaisiva tumiho. Mwia kyuqema mwataare tivarave, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mpo enta mwaanraqaa Iesusiva Parisi mwihua nronra vaisi nraamwuqi kyara nranrenro vuvata mwiqi varuhua mwiaqaa vu vate varura. ");
INSERT INTO omw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mwitaa huvaro Iesusira tataaqa vaisi mpo mwia kyuqu kyauqu kyota vuva varuvaro Iesusiva mwi vaisira taqero ");
INSERT INTO omw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","mwaanra okyara tuhuavata, Parisivata, kyapara hiro tiqaro, Tire mwaanraqaa vaisi kyaahaqa hiqata mwia mwamwanta kyuqema mwataarera, tire teta mwaanra qua nteqave kyaananrave, hiave nteqa kyaananrave? Nkye tivaqe riaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Iesusiva mwitaa tuvata mwihua hia qua mpoqiavata tuvaro Iesusiva vaisi mwia vita kyero mwia mwamwanta kyuqema kyero titovaro vura. ");
INSERT INTO omw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Vuvaro Iesusiva mwiqi varuhuara tiqaro, Nkyiqitairo mwia mwaaquvantove, mwia kauvantove, mwata quvu teraqi ntumwa virata nkye hiave mwi entaraqaa mwia ntanrau mwaanri kyevarave? tiro. ");
INSERT INTO omw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Iesusiva mwitaa tuvata mwihua nai timwa mwi quava hia vahuvata tirema varura. ");
INSERT INTO omw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesusiva nraamwu mwiqi variqaro taqovata kyara nranrenra nruhua mponramwuvanto tainta kyuqeraqaa nraahu mwata kyaavirerata uti varuvaro Iesusiva mpo quaqaa ntumwa kyero timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Vaisi mpovanto nraakye ntumwinrenra hiro iara nrinra kyara nraante tirara hia enanasaira uro tainta nronra kyuqeraqaa mwatakyaa vira variante. E mwiaqaa variraro nraamwu qova nronra vaisi mpo nraanrama kyero ");
INSERT INTO omw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","iara tiqaro, Tumitarera e uto mpuani variraro nronra vaisi mwaava tainta mwiaqaa mwatakyaa quarive, qiankyorave. Mwiva mwitaa tirera, e mwiqi nronraqama kyera kyauriqarama uro nraakye qora mwoqani mwatakyaa vira varinanrave. ");
INSERT INTO omw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hia mwitaa hiraitira, mwataa hiante. Kyara nranrenra hiro i nraanrainranra virava uro nraakye qora mwoqani mwatakyaa vira variante. E mwitaa hiraro nraamwu qova nri ntero iara tiqaro, Ni totio, hia mwini variante. Nrumu mwaini tainta kyuqeraqaa mwatakyaa quante, tirara e nraakye qora suqaa uro tainta nronraqa mwatakyaa vira variqara e nrutu nronra varenanrave. ");
INSERT INTO omw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nai nrutu nraahu tuaaheraariva variraro nraakiara mwia nrutu vara mwataniqa hiananrove. Nai nrutu vara mwataniqama kye variariva variraro nraakiara mwia nrutu tuaahera kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iesusiva mwitaa timwa kyero vaisi mpovanto mwianra nrinra ni nraamwuqi kyara nraante turara tiqaro, Nraakye qora kyara nyinrenra hira hia ena toti vaative, ena qata vakyaave, ena vataahuave, i nraamwunaahua airi inraikya vatehuave, hia mwihua nyaanraante. E mwihua nyaanrama kyera nyinrenra mwihua mwia hiniqama kyeta inavata mwivarave. ");
INSERT INTO omw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nraakye qora kyara nyinrenra hira vehi nraakye qorave, kyuqu kyauquara ihuave, vu qipaarihuave, mwihua nyaanraante. ");
INSERT INTO omw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","E mwitaama varihua nyaanrama kyera aaqaa nraahu nyinranro Kotiva mwianra riero i qamwata mwatero i kyuqema mwataananrove. Nraakiara Kotiva kyuqe nraakye qora qati vara sivuma kyaaninraqaa Kotiva ina kyoqaa mwiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iesusiva mwitaa tuvaro vaisi mpovanto mwiqi kyara nre varuva Iesusirara tiqaro, Qikye, Kotira mwatukyaqi kyara nrehua qamwateqata varivarave, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesusiva mpo quaqaa ntumwa kyero mwia timwa mwinro tiqaro, Vaisi mpovanto kyara nronraqama kyero tera taarama kyero vatero nraakye qora nyaanranrenra tuhua timwa nyitero tiqaro, Mwi entara kyara nraaninraqi nriate, tiro. Mwitaa timwa kyero varuvaro ");
INSERT INTO omw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","mwi entava nri ntovaro mwiva nai kyaiqa vaisi titero tiqaro, Uro tirata nriate. Ekyaa inraikya terama taiho, qiante, turave. Tuvaro mwia kyaiqa vaisivanto uro timwa nyuvata ");
INSERT INTO omw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","mwihua kuaiqia kuaiqiavanto tiqata, Po, mpo inraikyavanto ni antua kyaihana nte hia quaninrave, tita. Vuniqama kyero mpovanto mwia kyaiqa vaisiara tiqaro, Nte mwata mpo kyoqaama kyena varauqo. Nte mwia uro taqarerave. Po, hia qio ivatama kyena quaninrave, ");
INSERT INTO omw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","tuvaro mpovanto tiqaro, Nte kyaiqa vare varia purimakauhua kyauqurutana kyoqaama tauqo. Nte kyaiqa vareqana mwihua mwataara hirerana vuqo. Po, hia qio ivatama kyena quaninrave, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","mpovanto tiqaro, Nte mateqa nraata varauqo. Po, hia qio quaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ekyaa mwihua mwitaa nraahu tuvaro kyaiqa vaisi mwiva nrumu ntantero uro mwihua tu quara nai nronra vaisi timwa mwuvaro mwia raraqa tovaro nai kyaiqa vaisiara tiqaro, Hiantera mwatukyaqi virava uro aanra nronraqaatairave, aanra pataqaatairave, vehi vaisivata, kyuqu kyauquara ihuavata, su qipa quarihuavata, kyuqu are aremaqita nrohihuavata, sita varera nriante, turave. ");
INSERT INTO omw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tuvaro mwiva tuntema kyero uro sitaqiro nrumu kyero tiqaro, E qiarantema kyena sitaqina nrumu kyauqaro tainta hini qati nraahu vaiho tuvaro ");
INSERT INTO omw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","mwia nronravanto tiqaro, Mwatukya mwiqi qaqira kyera virava uro aanraqaatairave, aakyoqitairave, api nraakye qora taqerahua mwihua vuavi raavira tirata nrumu ni nraamwu piqa kyaate. ");
INSERT INTO omw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nte i timwa mwuqo. Tauraaqama kyena nyaanrama tau nraakye qorahua hiama qio ni kyara nrevarave, turave, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nraakye qora airivanto Iesusira vataqita vi varuvaro Iesusiva tuqasaa viro mwihua timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Vaisi mpovanto ni nraaqiara varirero nte hunani nrinrenra hiro mwiva nai nrohua qohuave, nraata nraaqiarave, nai qata vakyaahuave, nai mwata mwaaqa qati variqiro quaninranrave, nronraqama kyero riemwaqiro viqaro nianra hia nronraqama kyero riaariva hiama qio ni nraaqiara variananrove. ");
INSERT INTO omw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mpovanto hia nai rukye kyatarira vara qu varero ni pataqiro nrinrenra, mwiva hiama qio ni nraaqiara variananrove. ");
INSERT INTO omw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nkyiqitairo vaisi mpovanto nraamwu nronra hoqarera hiro mwiva tauraaqama kyero mwatakyaa viro nraato tuqiro viro kyatariarave, mpo inraikyarave, qioma munima kyaaninrave timwa kyero, nraamwu hoqairave. ");
INSERT INTO omw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mwiva hia mwitaa hirera, mwiva nraamwu hoqeqaro nraamwu tura nraahu ratairaro munima taiqa viraro hia hoqa taiqa kyairata nraamwu mwia taqehua raima mwateta tiqata, ");
INSERT INTO omw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Qikye, vitira taqaate. Mwi vaisiva nraamwu tohara tero hia qio taiqa kyaiho, tivarave. ");
INSERT INTO omw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mpo quavata tirerave. Vunyaa vaisi mpovanto nai henanra mpovata ntaqirera hiro, mwiva tauraaqama kyero mwatakyaa viro variqaro nai ntaqua vaisihua kyaara ntumwa kyero taqero tiqaro, Nte qiove mwia nraatara kyaaninrave, hiave qio mwia nraatara kyaaninrave? tirave. Mwiva taqairaro mwia ntaqi vaisihua 10,000 nraahu varivaro mwia nramwutaara ntaqi vaisihua 20,000 varivera, mwiva ni nraatara kyaankyo tiro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kyai ni nramwutaa mwiva nyianrani variraqe nte vaisi mpo titaariro mwiva uro mwianra qao tiro mwaateraqama variare qiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iesusiva mwitaa timwa kyero mwiva tiqaro, Mwia votima kyeta nkye hia mpo inraikya mpo inraikya tutaara qaqira kyaivera, nkye hiama qio ni nraaqiara varivarave. ");
INSERT INTO omw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Hore kyuqe inraikyave. Horevanto uaqiama viro hia qiakyaa hirera, tire hia qio qaiqaa utu kyaararo qiakyaa hiananrove. Tire mwia qaqira kyaananrave. ");
INSERT INTO omw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mwitaama quani horera hia qio kyara kyaahaqa hiraro kyaravanto kyuqema kyero qupiqaananrove. Kyaravanto kyuqema kyero qupiqaarive tita hia mwi horera purimakau raha kyapata qio vatevarave. Nkyi nyaato vahiarihua hivera, nkye mwi quara ntapihi kyeta riaate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mpo enta taakisi vare varuhuavata, qora kyaiqa vare varuhuavata, Iesusira qua riarerata nri nteta varuvata ");
INSERT INTO omw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisi vaisinramwuvantovata, mwaanra okyara ti varu vaisihuavata, nrutu nraunru/nrunru nraanru tita tiqata, Qaqao, mwaa vaisiva qora kyaiqa uti varia vaisihua qamwata nyatero mwihua kyapata kyara nre variho, tita. ");
INSERT INTO omw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mwitaa tuvaro Iesusiva mwaa quaraqa ntumwa kyero mwihua timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Nkyiqitairo vaisi mpovanto 100 sipisipi vataariva taqairaro sipisipi mpovanto raupirima virera, mwi vaisiva nataave hiananrove? Mwiva 99 sipisipi mwihua utaqi kyero mpo sipisipi raupirima quaninra puaa hirero quananrove. Mwiva puaamaqiro viro uro mwia puaama kyero taqaananrove. ");
INSERT INTO omw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mwiva mwia puaama kyero qamwata kyero vara nai qumwuqa qu varero ");
INSERT INTO omw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","uro mwaatani mwia kyero mwiavata variahua nyaanrama kyero tiqaro, Nkye nrumu nivatama kye qamwataate. Ni sipisipi raupirima vihana nte mwia puaama kyauqo, qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nte qianinra nkye ntapihi kyeta riaate. Mwia votima kyeta 99 nraakye qora hia qora aanra nrohihua varivata nyaamwuni varihua mwihuara qamwate variqata taqaivaro qora kyaiqa varaari vaisiva kuaiqiavanto qora aanra qaqira kyairera, mwianra rieqata nyaamwuni varihua mpoqama kyeta qamwatevarave. ");
INSERT INTO omw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nte qaiqaa mpo quaqaa ntumwa kyena tirerave. Nraakye mpovanto ori munima kyauqurutana vataiva taqaiharo munima kuaiqia raupirima virave. Mwitaa hiraro mwiva nataave hiananrove? Mwiva omwa qupi kyero nraamwuqi ntupi kyero mpoqi mpoqi puaamaqiro viro taqaananrove. ");
INSERT INTO omw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mwiva puaama kyero varero nai totivaativata, mwiavata variahuavata, nyaanrama kyero timwa nyinro tiqaro, Nkye ni vatama kyeta qamwataate. Nte munima raupirima kyaura puaama kyena varauqo, qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nte qianinra riaate. Mwia votima kyero qora kyaiqa varaari vaisiva qora aanra qaqira kyairera, mwianra rieqata nyaamwuni varihua qamwate varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesusiva mwitaa timwa kyero mwiva tiqaro, Vaisi mpovanto qoraisi nraaqiara taaratana mwata tovaroma ");
INSERT INTO omw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","mwia mwaaqu nraakiaraava siviro nai qorara tiqaro, Ena vataana inraikyara nraakiara ntainra kyera ni mpirerave tinanra mate nraahu ni mpiante, tiro. Mwitaa tuvaro mwia qova nai vato inraikyara ntainra kyero nai mwaaqutana nyunrave. ");
INSERT INTO omw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nyuvaro mwia mwaaqu nraakiaraava pataqia variro nai hu inraikyara mpohua nyiqanro munima varero nyianra mpo mwatani vuva uro mwini variqaro qora vaisi kyapata qora kyaiqaqaa munima vare vura taiqa tuto kyorave. ");
INSERT INTO omw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Taiqa tuto kyovaro mwiaqaatairo nronraqama kye aara nto entava nri ntovaro mwiva vehi vaisi variqaro ");
INSERT INTO omw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","uro mwi mwataraqaanaa vaisi mpoqaa kyaiqa vararero viro. Vuvaro mwi vaisiva tiqaro, Uro ni quaraqa ntaqikyiqara mwihua kyara nyiante, turave. ");
INSERT INTO omw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tuvaro mwiva quara kyara nyi variro tiqaro, Qikye, quara kyara nyiqana viti vaati ntenavata nraataarave, tuvaro mwia kyara mwianri vaisiva hia varura. ");
INSERT INTO omw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mwia nraataa huvaro varuvaro mwia vu nraato ntutoraa vuvaro mwiva riero tiqaro, Ni kora kyaiqa vaisi airinramwuvanto variavaro airi kyara vaihata mwihua nreqata variavana nte mwaini variqana kyarara huqo. ");
INSERT INTO omw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kyai nte sivina ntena kova hinani nrumu ntantena quankye. Nte urontena ntena korara mwitaama qianinrave. Ko, nte Kotiravata ivata uaqia hi kyaiqara utu nyatauqo. ");
INSERT INTO omw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mwia kyaara nte hia qio i nraaqiara kyuqeva varianinrave. E ni vara mwataniqama kyairaqe nte i kyaiqa vaisi nraahu variankye. Nte quariva uro mwitaa tirerave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mwitaa timwa kyero mwiva siviro nai qova hunani nrunra. Nai qora nraamwu qaumato nruvaro mwia qova nyianrasairo vutu mwia taqero qamwata kyero hiantero uro nai mwaaqu ntavaaqavu kyero mwia kyuquqama mwatero varuvaro ");
INSERT INTO omw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","mwia mwaaquvanto tiqaro, Ko, nte Kotiravata ivata uaqia hi kyaiqarama utu nyatauqo. Mwia kyaara nte hia qio i nraaqiara kyuqeva varianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mwitaa tuvaro mwia qova nai kyaiqa vaisi timwa nyinro tiqaro, Hianteta nkye uro tuavaaqa kyuqera varaqita nrumu mwiate. Kyaatamwavata inranravata varaqi nrumu humwataate. ");
INSERT INTO omw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Purimakau nraati kyuqera rukyeta utaate. Mate tire mwia qamwata mwataananrave. ");
INSERT INTO omw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ni maaquvanto qutu viho tuqaroma qati nri ntaiho. Ni maaquvanto raupirima viho tuqaroma qati nrihana vitauqo, tiro. Mwitaa timwa kyero nai mwaaqu qamwata mwatero kyara vara kyero mwia vaahaqama mwatorave. ");
INSERT INTO omw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mwia vaahaqama mwate varuvaro mwia vakyaava kyaiqa varonasairo nri ntero riovata ");
INSERT INTO omw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ihi nte variqa tuvaro mwiva nai qora kyaiqa vaisi mpo kyapara huvaro mwiva mwia timwa mwinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","I qatavanto vevasairo nri ntaiharo i qova mwianra qamwateqaro purimakau nraati kyuqera ru kyero uta mwataiho. I qata kyuqema nai vitero qamwateqaroma mwitaa iho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mwitaa tuvaro mwia vakyaara raraqa tovaro kyaru ntumwa kyero tiqaro, Hia nte nraamwuqi virerave, timwa kyero mwaatani varuvaro mwia qova veva ntero mwianra po qati nraamwuqi nriante tuvaro mwiva mwitaama tiro: ");
INSERT INTO omw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nte airi ihiara i kyaiqa vaisi votima kyena i kyaiqa vareqana hia nte mpo entavata i qua raaquta kyaurave. Nte ntena toti qamwata nyataankye tuqara e hiama memenra nraati mpoku ntuqutu ni mpiaro. ");
INSERT INTO omw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","I nraaqiara mwaava api qaraqita nrohia nraakyehuavata e hiana inraikyara varaqiro mwihuaqaa uto taiqa kyero nrihanrama e purimakau nraati kyuqera qumina ntuqutu kyera mwinra hiaro, tiro. ");
INSERT INTO omw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mwitaa tuvaro mwia qova qaqao tiro, Ni maaquo, e mpo enta mpo enta ni vatama kyera variaravave. Nte hu inraikyara ekyaa inraikya mwia tetatana hunanrave. ");
INSERT INTO omw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","I qatavanto qutu viho tuqaroma qati nri ntaiho. Mwiva raupirima viho tuqaroma qati nrihana vitauqo. Mwitaa ihatara tita, tire mate mwia qamwata mwatarerave, turave, tiro. Iesusiva mwi quara turama. ");
INSERT INTO omw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesusiva nai nraaqiaranramwu timwa nyinro tiqaro, Haaru vaisi mpovanto munima airi vatova varuvaro vaisi mpovanto mwia kyaiqa vareqaro mwiva vato inraikyaraqaa ntaqikyurave. Mwiva hu inraikyaraqaa ntaqikyi varuvaro mpovanto nri ntero tiqaro, E hiana inraikyaraqaa ntaqikyi variva e hiananra hini nramwa kye variho, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","munima vato vaisiva mwiva mwia nraanrama kyero tiqaro, E nanra varaana quarave nte riauqo? Nte hu inraikyara ntaqikyiqara varenanra qara ntumwa tairaqe taqaankye. E hia nte hu inraikyaraqaa ntaqikyinanrave. E taiqenanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mwitaa tuvaro kyaiqa vaisi mwiva riero tiqaro, Po, ni nronravanto nte kyaiqa varauraqaatairo ni taiqama kyaananrove. Nte nataave hianinrave? Hia nte kepukyaqama kyena onti quvuaninrave. Nte mpohuara nianra po tiqata munima mpiate qianinra kyauruaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mwitaa timwa kyero mwiva kyai nte mate mwitaa mwitaa hiariro nraakiara ni titairata nraakye qora nianra qamwateqata ni pitaqita uro nkyiari nraamwuqi kyaate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mwitaa timwa kyero nai nronra vaisiqitaita munima vareta qakyo mwianre tu vaisihua nyaanrama kyero vuni nru vaisira mwia kyapara hiro, Ni nronravanto iqi vataiva nataamave qati vaiho? tuvaro ");
INSERT INTO omw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","mwiva tiqaro, Mwiva niqi vataiva vahamwenra 100 taqu vaiho, tuvaro mwia munimaqaa ntaqikyuva tiketi mwinro 100 qaqira kyera 50 nraahu tiketiqaa qara ntumwa taante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mwitaa timwa kyero vaisi mpora tiqaro, Mpo e, iqi vataiva nataamave qati vaiho? tuvaro mwiva tiqaro, Uiti tua 100 tuama qati vaiho, tuvaro mwiva tiketi mwinro 100 qaqira kyera 80 nraahu tiketiqaa qara ntumwa taante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mwiva vato inraikyaraqaa ntaqikyiqaro mpuara vare varu vaisiva mwitaamaqiro vuvaro mwia nronravanto taqero tiqaro, Qikye, vaisi mwihua mwia toti variate tiro, mwiva vu nraato tuqiro viro mwiva mwitaa hi variho turave. Mwatani varia vaisihua nkyiari hena vaisi kyoqaa nai mwi nai mwi hiqata nkyiari riemwa kyeta kyoqaa kyaiqa varaqi quarave. Mwihua kyoqaa kyaiqa vareqata omwa itainani nria vaisihua nraatara kye variarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iesusiva mwitaa timwa kyero mwiva tiqaro, Nte qianinra riaate. Mwatani variahua apiqama kyeta tuto kye varia munimanra nkye mwi munimanra vara kyetama avuqavuma kyeta totiqa hiqata nyiate. Mwitaamaqita vivaro munima taiqa virata nkye ekyaa enta qati variqi vi nraamwunraqi vivaro nkye munima nyi vaisiva nkyi qamwata nyataananrove. ");
INSERT INTO omw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Vaisi mpovanto pata kyaiqaqia vareqaro mwiva mwi kyaiqara avuqavuma kyero varairera, mwi vaisiva nronra kyaiqavata avuqavuma kyero varaananrove. Vaisi mpovanto pata kyaiqa varero mpuara utiqaro varairera, nronra kyaiqavata mpuara utiqaro varaananrove. ");
INSERT INTO omw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nkye mwata mwaaqa variahua apiqama kyeta kye varia munimanra hia kyuqinra kyeta ntaqikyivera, Kotiva hia nkyiara, Nkye ni kyoqaa qutaa kyoqaaqaa ntaqikyivarave, qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nkye mpova hiani inraikyaraqaa hia kyuqema kyeta ntaqikyivera, Kotiva nkyiara, Nkye nkyeta vate inraikyaraqaavata hia kyuqema kyeta ntaqikyivarave, timwa kyero hiama nyiananrove. ");
INSERT INTO omw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hia kyaiqa vaisi mpovanto vaisi nronra taaratanaqaa kyaiqa varaananrove. Mwiva mwitaa hiqaro nronra vaisi mpora mwia mwutukya vahiraro mporara hia mwia mwutukya vahiananrove. Mwiva nronra vaisi mpora kyuqerave timwa kyero mpora uaqia hiravema qiananrove. Airi inraikya vatevave, munimavantove, nronra vaisi votima kyero nkyiqa ntaqikyi varirera, nkye munima varerara nraahu riemwaqi viqata hia Kotira kyaiqavata qio varaqi vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Iesusiva mwitaa tuvata Parisi vaisinramwuvanto mwi quara riovaro mwihua mwutukyavanto munimanra nraahu vahuvatara tita, mwihua Iesusiva qua turara raima mwatora. ");
INSERT INTO omw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Raima mwatovaro Iesusiva mwihua timwa nyinro tiqaro, Mwihua nkyiara avuqavu nrohi varia vaisihuave qiate tita, nkye nraakye qora suqaa avuqavuma kyeta nrohi variarave. Nkye mwitaa hiavaro Kotiva nkyi mwutukyaqi uaqia hi kyaiqara taqe varirave. Mwatani variahua tiqata, Kyuqe inraikyave, ti variara mwi inraikyarara Kotiva tiqaro, Uaqia hi inraikyara qumina inraikyave, ti varirave. ");
INSERT INTO omw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Haaru hia Ioniva varu entara Mosesira qua mwaanravantovata poropeti vaisi qua mwaanravantovata vahurave. Mwiaqaatairo Ioniva nramanri nyi varuva nri ntero qaraakya qua kyuqe qua Kotiva nkyiqa ntaqikyiani quara timwaqiro vuvata mwiaqaataita ekyaa nraakye qora nkyiarianasai kepukyaqama kyeta Kotira mwatukyaqi virerata uti variarave. ");
INSERT INTO omw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Qio nkye riaate, Haaruaa mwaanra qua qatima vaiho. Nyaamwuvantovata mwatavantovata taiqa viraro Kotira qua nronravantovata patavantovata qatima vahiananrove. ");
INSERT INTO omw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Vaisivanto nai nraata qaqira kyero mpo nraakye varaiva, mwi vaisiva Kotira qua mwaanra nteqa kyairave. Mpovanto qaqira kyai nraakyera varai vaisiva, mwivavata Kotira qua mwaanra nteqa kyairave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Iesusiva nai nraaqiaranramwu timwa nyinro tiqaro, Vaisi mpovanto airi inraikya vatova kyuqe tuavaaqa nraahu ututero mpo enta mpo enta qiakyaa hu kyarara nraahu nreqanro varurave. ");
INSERT INTO omw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mwiva mwi kyarara nraahu nreqanro varuvata vaisi mpo mwia nrutu Rasarusira vitaqita uro airi inraikya vato vaisira nraamwu qesana kyovaro varura. Mwi vaisiva hia mpo inraikyavata vatova vehi vaisivanto varuvaro rumpuaravanto nraahu ekyaa mwia mwamwantaqa vahuvaro ");
INSERT INTO omw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","variqaro mwiva airi inraikya vato vaisiva kyara nreqanro viti vaati qaqira kyora mwia nraahu utu kyeqaro nranrenro varura. Rasarusiva mwini varuvaro vairinramwuvanto vitare nritare hiqata mwia rumpuara pohi varurave. ");
INSERT INTO omw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hia mpo inraikyavata vato vaisiva qutu vuvata nyaamwunyaahua mwia vitaqita uro Evarahaamuva nai haivaqava varunani kyorave. Uro kyovaro airi inraikya vato vaisiva mwivavata variro qutu vuvata mwataqi quntamwa torave. ");
INSERT INTO omw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Quntamwa tovaro mwiva qutu vuhua varunani variqaro atura nti varurave. Atura ntiqaro mwiva vuru taqovaro Rasarusiva Evarahaamukyantiri qamwateqaro nyianrani varurave. ");
INSERT INTO omw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mwini varuvaro mwiva Evarahaamunranra aakyara ntero tiqaro, Evarahaamuo, ko, e qati nianra po kye timwa mataante. E Rasarusira titairaro mwiva nai kyauqu uro nramanriqi mwaamwi ntamwa kyero tumu ni maaqinriqaa vatairaro tututaarive. Nte qia nronraqi variqana atura ntiqana varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mwiva mwitaa tuvaro Evarahaamuva qaqao tiro, Ni maaquo, e riaante. E tauraa qati varuna entara e kyuqe inraikya vatoraro Rasarusiva qora inraikya nraahu vatorave. Mate mwiva mwaini variqaro qamwateqaro varihara e mwini atura ntiqara variaro. ");
INSERT INTO omw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","E qaiqaavata rie variraqe nte qua mpoqiavata i timwa mwiankye. Nte varuqara e variararo tiri utaqaa okai nronrama vaiho. Mwaisaita mwini vivorave, mwisaita mwaini nrivorave tiro, okai nronra utaqaa vatairave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Evarahaamuva mwitaa tuvaro mwi vaisiva tiqaro, Po, ko, nte iara qati ni qua riaante tuqo. E Rasarusira titairaro mwiva ni kora nraamwuqi uro ntero ");
INSERT INTO omw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ni kata pakyaa kyauquru variahua timwa nyianrive. Mwihuavata mwaini nriqa vinani nrivorave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mwitaa tuvaro Evarahaamuva qaqao tiro, Mosesivavata, poropeti vaisinramwuvata, qara ntumwa to quava vahirave. Mwihua mwi quara qioma rievarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tuvaro qati varu entara airi inraikya vato vaisiva tiqaro, Hiave, Ko, Evarahaamuo, qutu quarive nrumu ntantero uro timwa nyinrata mwihua mwia qua rieqatama qora aanra qaqira kyevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mwitaa tuvaro Evarahaamuva qaqao tiro, Mwihua Mosesira quavata poropeti vaisi quavata hia riaivera, mwihua qutu quariva nrumu ntantero uro qiani quaravata hiama qio rievarave, turave, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesusiva nai nraaqiaranramwu timwa nyinro tiqaro, Nraakye qoravanto Kotira qua nteqa kyeqata uaqia hi kyaiqara utuate tiro, mpo inraikya mpo inraikyavanto qovara hiananrove. Uaqia hi kyaiqara qovarama kyaani vaisirara po kye timwa mwatauqo. Nraakiara mwi vaisiva taqaananrove. ");
INSERT INTO omw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nraaqiara mpo uaqia hi aanranra nraamwutaani vaisiva variraro nraakiara Kotiva mwi vaisira uaqiama kyeroma ntuqutu mwataananrove. Kotiva mwi vaisira mwitaa hianinranra rieqaro mwi vaisiva mwataama qiari. Qikye, eqaataara qumina nte mwi nraaqiarara uaqia hi aanranra nraamwutaurave. Haaru hia mwitaa hiava entara ni nuntaqi ori nronra sutukye ni rumpua nronraqi tuto kyaataarave, qiananrove. ");
INSERT INTO omw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nkye uaqia hi kyaiqara utuaro tita rauru kyeqata variate. E taqairaro i qata vakyaavanto Kotira qua nteqa kyairera, mwianra hia qaiqaavata mwitaa hiante qiante. Mwiva tiqaro, Nte po tuqo. Hia qaiqaavata mwitaa hirerave, tirera, e tiqara, Mwi quara matema qaqira kyauqo, qiante. ");
INSERT INTO omw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","E taqairaro mwiva kuaa enta 7 nani i uaqiama mwatero nrumu iara po hia mwianra riera taunru mataante tirera, e eo timwa kyera 7 nani mwianra tiqara, Nte mwi quara qaqira kyena hia iqaa qua vataaninrave, qiante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Iesusiva mwitaa tuvata mwia nraaqiara 12 nramwuvanto tiqatama, E tiri kyaahaqa hiraro tire Kotirara riemwaqita quarava nronraqa hiarive, tita. ");
INSERT INTO omw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mwitaa tuvaro nronravanto mwihua timwa nyinro tiqaro, Nkye Kotirara riemwaqi viva masiteti uru pataqia votima kyero vahirera, nkye kyatari vitirara tiqata, E tuqa rirante ntarira uro kyaareraqi qupiqaante, tivaro kyatari mwiva nkyi qua riaananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Iesusiva tiqaro, Nkyiqitairo mpovanto variraro mwia kyaiqa vaisivanto kyaiqa varaaninranra qati quaqama kyena tirerave. I kyaiqa vaisivanto i kyaiqa vareqaro uro kyatu quvu tero uro sipisipiqaa ntaqikyi tero nrinranra e nanreve mwianra tinanrave? ");
INSERT INTO omw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","E hiama mwianra tiqara, Hiante ena kyara nrumu nraante, tinanrave. Mwi vaisiva qumina kyaiqa vaisivanto variharara tira, e mwianra tiqara, Nrumu nini kyara nraante terama kye matera kyara utaa tavunanra rupa varera kyara varaqira nrumu mpiraqe nramwa kyaarira nraakiara ena kyara nraante, tinanrave. ");
INSERT INTO omw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kyaiqa vaisi mwiva i kyaiqa taiqa kyairara e mwianra kyuqeveve tinanrave? Qaqao, e hiama mwitaa tinanrave. Mwianra tiqara, Mwia ena kyaiqama varera hiaroma, tinanrave. ");
INSERT INTO omw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mwia votima kyeta nkyevata Kotira kyaiqa uro taiqa kyeta hia mwianra rieqata Kotirara qamwata timwa taante qiate. Nkye mwataama qiate. Tire qumina kyaiqa vaisi nraahuma varuro. Tire mwi kyaiqara vareqata tire teta kyaiqa vaisi kyaiqa nraahuma varauro, qiate, tiro. Iesiva turama. ");
INSERT INTO omw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesusiva Ierusareminianra viqaro Sameriaa mwata hini vahuvaro Kariri mwata hini vahura mwia utaqaa vuva ");
INSERT INTO omw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","mwatukya mpoqi uro ntovata vaisi kyauqurutanavanto Iesusira uro qintorama kyeta. Rumpuara uaqia huva mwihua mwamwanta nre varuhua vutura nyianrasatataita aakyara nteta tiqata, ");
INSERT INTO omw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Iesusio, e nronravantove. Qati tirinramwuanra po kye timwa timwa taante, tita. ");
INSERT INTO omw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Kotira kyaiqa vare varia vaisihua hianani vivata nkyi mwamwanta itutuma kye taqaate, tuvata mwihua Iesusiva tuntema kyeta aanraqaa viqata taqovaro mwihua rumpuaravanto tavanta vuvaro mwihua nyamwantavanto kyuqema vuvata mwihua qio varura. ");
INSERT INTO omw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mwihua qio varuvaro mwihuaqitairo kuaiqiavanto nraahu nai rumpuara tavanta vura taqero nrumu ntantero aakyara ntamwa kyero Kotira nrutu tuaaheraqiro vura. ");
INSERT INTO omw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Vuva uro Iesusira kyuqusata tumu ntiro variqaro Iesusira qamwata mwate varura. Vaisi mwiva Sameriaa nyaava varuvaro Iesusiva mwianra tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nte vaisi kyauqurutana kyuqema nyataurave. Vaisi 9 nramwu tainive quavo? ");
INSERT INTO omw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nanraqamave mpo mwatanaa vaisi mwaava nraahu Kotira nrutu tuaaherarero nriho? tiro. ");
INSERT INTO omw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mwitaa timwa kyero Iesusiva vaisi mwianra tiqaro, Qioma sivira quante. E nianra ni kyaahaqa hianinrave qiararoma i mwamwanta kyuqema viho, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi vaisinramwuvanto uro Iesusira kyapara hita tiqata, Kotiva nraakye qoraqaa ntaqikyiariva taireve qovara hiananrove? tuvaro Iesusiva mwihua timwa nyinro tiqaro, Mwiva qovara hianinra nkye hia vuqotaita qio taqevarave. ");
INSERT INTO omw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Hiama mpovanto Kotiva ntaqikyianinra taqero mwinima vaiho mwainima vaiho qiananrove. Kotiva nraakye qora mwihua utaqi variqaro mwihuaqaa ntaqikyiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mwitaa timwa kyero Iesusiva nai nraaqiaranramwuanra tiqaro, Mpo enta nri ntairata nkye mwi entaraqaa ni mwatani mwatatai nraaqiarara tiqata, Qikye, Iesusiva kuaa enta nraahu tirivata variraqe tire qiove qiataarave, tiqatama hia qio ni taqevarave. ");
INSERT INTO omw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mwi entaraqaa vaisi mponramwuvanto nkyiara tiqata, Iesusiva mwinima variho. Mwainima variho, tivata nkye hia mwihua qua rieqata mwihua vataqita quate. ");
INSERT INTO omw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aaquakyaa tiqaro ekyaa nyaamwu ntuvaahama kyaintema kyenama nte mwatani mwatatai nraaqiarava qoqaa tumuaninrave. ");
INSERT INTO omw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Qakyo qoqaa tuminrenra hiarita mate mwaa entara vari nraakye qorahua nronra muaanra nraante mpivaqe varaarita mwihua ni qoririma matevarave. ");
INSERT INTO omw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noaava varu entara nraakye qoravanto mpoqia mpoqia utuntema kyeta nte mwatani mwatatai nraaqiarava tumuani entaraqaa nraakye qoravanto mpoqia mpoqia utivarave. ");
INSERT INTO omw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noaava varu entara nraakye qoravanto kyarave nramanrive nramwaqita vita nraata vaati varaqita vuvaro Noaava nramanriqaa quani nraamwunraqi viqetovaro humwunravanto nronraqama kyero ntero mwihua ekyaa ru taiqa kyorave. ");
INSERT INTO omw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nte tumuani entava Rotiva qati varu entara votima kyero vahiananrove. Rotiva qati varu entara nraakye qoravanto kyarave nramanrive nramwaqi vita, nkyiari kyoqaa kyaiqa varaqi vita, nraata vaati varaqita vita, kyara vara tuqi vita, nraamwu hoqaqi vita mwitaa mwitaamaqita vuvaro ");
INSERT INTO omw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Rotiva Sotomi mwatukyaqitairo vuvaro nyaamwusairo qiavanto vati votima kyero ntiqaro mwi mwatanaahua ekyaa itamwa taiqa kyorave. ");
INSERT INTO omw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nte qovarama quani entara nraakye qoravanto mwitaamaqi viqata nkyiari kyaiqa nraahu varaqi vivarave. ");
INSERT INTO omw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mwi entara vaisivanto nraamwu aatareqani variariva nai vataani inraikyara vararero nraamwuqi hiama vera ntaarive. Vaisi mpovanto kyaiqa varaariva nrumu ntantero nraamwuqi hiama quarive. ");
INSERT INTO omw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rotira nraatavanto apiqama viro taiqa vurara nkye riaate. ");
INSERT INTO omw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nte qutu quankyo tiro qati varianinranra nronraqama kye riaariva qutu quananrove. Hia nai qutuaninranra nronraqama kye riemwaqiro quariva, (mwiva qutu viro mwiaqaatairo) ekyaa enta qati variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mwi entara entaqi vaisi taaratanavanto taariqaa vaite varivaro kuaiku nraahu nyaamwuni vita varero viro mpo mwia mwinima kyairaro variananrove. ");
INSERT INTO omw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mwi entara nraakye taaratanavanto kyara taiti ti varivaro kuaiqia nraahu nyaamwuni vita varero viro mpo mwia mwinima kyairaro variananrove. ");
INSERT INTO omw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Vaisi taaratanavanto utaqi kyaiqa vare varivaro kuaiqia nraahu nyaamwuni vita varero viro mpo mwia mwini kyairaro variananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iesusiva mwitaa tuvata mwia nraaqiaranramwuvanto mwia kyapara hita tiqata, Tainive mwi inraikyava mwi inraikyava qovara hiananrove? tuvaro Iesusiva mpo quaqaa ntumwa kyero mwihua timwa nyinro tiqaro, Qutu quani inraikyava vahianinra mwiaqaama memonravanto ntuvaantua hivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iesusiva nai nraaqiaranramwuanra mwihua Kotirara aakyara ntamwaqi vivaro hia pupohairata qaqira kyaate tiro, mwaa quaraqaa ntumwa kyero timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Haaru qua avuqavu hi varu vaisiva iaasiva mpo mwatukyaqaa variqaro mwiva hia Kotira nraatu aatu hu vaisiva hia nai hena vaisiaravata nronraqama kyero rie varu vaisiva varurave. ");
INSERT INTO omw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mwiva varuvaro tetoqa nraakyevantovata mwi mwatukyaraqaa varurave. Mwi nraakyeva ekyaa enta ko rio vaisiva varunani nri ntero tiqaro, Vaisi mpovanto ni qoraqama matairara rieqara e ni qua avuqavuma mataante, turave. ");
INSERT INTO omw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mwitaa timwaqiro vuvaro airi enta ko rio vaisiva hia mwia kyaahaqa hiataa huvaro hia mwia kyaahaqa hurave. Mwitaamaqiro viro ekyaara mwianra tiqaro, Nte Kotiraravata vaisiaravata hia nronraqama kyena riauva ");
INSERT INTO omw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tetoqa nraakye mwaavata hia kyaahaqa hiataa ihana varuqaro mwiva airi nani nte hunani nri variqaro ni antue variho. Kyai nte mwia qua riena avuqavuma mwataariro mwiva hia mpo enta mpo enta qaiqaavata nte hunani nriqanro ni pupohama mataarive, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mwitaa timwa kyero Iesusiva nronravanto tiqaro, Riaante. Hia kyuqe iaasiva hia mwi nraakyera kyaahaqa hiataa huvarovata mwia kyaahaqa hurave. ");
INSERT INTO omw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kotira nraakye qoravanto entaqivata, iheravata, mwianra aakyara ntamwaqi vivaro Kotiva hiave mwihua qua riero kyaahaqama nyataananrove? Kotiva qakyoma kyerove mwihua kyaahaqa hiananrove? ");
INSERT INTO omw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Qaqao, nte qianinra riaate. Kotiva mwihua qua riero qamwanrama kyero mwihua kyaahaqama nyataananrove. Nte mwatani mwatatai nraaqiarava qaiqaa tumuani entaraqaa Kotira qua rieqata mwianra aakyara ntamwaqi vihua mpoqiani varivarave iho, hiave varivarave? tura. ");
INSERT INTO omw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iesusiva mwitaa timwa kyero tiqaro, Vaisi mponramwuvanto tiqata, Tire nraahuma kyuqe hurahua variqata avuqavumakye nrohi varurata mpohua hia kyuqe hia huama variavo qiarave. Kyai nte mwitaa qia vaisihuara mwaa quaraqaa ntumwa kyena qiankye, timwa kyero tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Vaisi taaratanavanto Kotira nraamwuqi Kotirara aakyara ntarerata vurave. Mpo Parisi vaisivanto vuvaro mpo taakisi vare varu vaisiva vurave. ");
INSERT INTO omw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mwitanahua Kotira nraamwuqi vera ntovaro Parisi vaisi mwiva uro nanrianra mposata variqaro Kotirara aakyara nteqaro mwitaama tiro: Kotio, Hia nte mpohua votima kyena varuvara tina, nte iara kyuqema tuqo. Hia nte mpohua nraantantena munima mpuara vare varuvave. Hia nte api qora kyaiqa utuqina nrohi varuvave, Hia nte mpora nraatavata mpuaraqama kyena nrohuvave. Hia nte viti vaisiva taakisi vare vari vaisira votima kyena varuvave. ");
INSERT INTO omw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nte kuaa uiki mwiqi variqana i kyaiqara rieqana taara enta kyara aurama teqana varuvave. Nte ntena hu inraikyaraqaatai munima vara kyena kyauqurutanaqitaina avuqavuma tukyama kyena kuaiqia ina mwi varurave, turave. ");
INSERT INTO omw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Parisi vaisivanto mwitaa ti varuvaro taakisi vare varu vaisiva vutura nyianra sata siviro variro kyauriqaro hia tuaahera kyero nyaamwunivata taqaraitiro, nai mwetokya ntuqutiro tiqaro, Kotio, po nte hia kyuqe huvama varuqo. E nianra po kye timwa mataante, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mwitaa timwa kyero Iesusiva timwa nyinro tiqaro, Nte qianinra riaate. Kotiva Parisi vaisivanto tu quara hia riaraitiro, taakisi vare varu vaisira qua nraahu riero mwiva uaqia hi kyaiqara utura nruka mwatovaro mwi vaisiva nrumu ntantero nai nraamwuni vurave. Nai nrutu nraahu tuaaheraaninra Kotiva mwia nrutu vara mwataniqama kyaananrove. Nai nrutu vara mwataniqa hianinra Kotiva mwia nrutu tuaaherama mwataananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nraakye qoravanto nkyiari nraaqiara sitaqita Iesusiva mwihuaqaa kyauqu vatero kyuqema nyataarive tita nri ntovata Iesusira nraaqiaranramwuvanto tiqata, Siteta mwihuavata quate, tura. ");
INSERT INTO omw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mwitaa tuvaro Iesusiva nraaqiara mwihua nyaanrama kyero tiqaro, Nraaqiara mwihua qati kyaivata nte hunani nriate. Hia mwihua aanra antuaate. Kotiva ntaqikyiari mwatukyava mwi nraaqiarahua voti hiahua mwihua mwatukyama vahiananrove. ");
INSERT INTO omw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nkye mwaa quara riaate. Vaisivanto hia nraaqiara nraantantamwa kyero variqaro Kotira qua riaariva hiama qio Kotiva ntaqikyi mwatukyaraqi quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iesusiva varuvaro Iutaa vaisi nronravanto mwia ntumwahiamwa hiro tiqaro, E mwaanra ti variara vaisiva kyuqevave. Nte nataa hiani kyaiqara Kotira vara mwataaninraqaatainave nte nraakiara ekyaa enta qati variqina quaninrave? tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mwitaa tuvaro Iesusiva tiqaro, E nanraqamave nianra vaisi kyuqevave qiaro? Kotiva nraahuma kyuqeva variho. ");
INSERT INTO omw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","E Kotiva timwa to quara riaananrave. Mwia quavanto mwataa tirave: E hia mpora nraatantiri api nrohiante. E hia mpora ru kyaante. E hia mpuara varaante. E hia unra qua mporaqaa vataante. E ena nrohua qohua nyutu tuaahera nyataante, turave. E mwi quara timwa tova vahira riemwaqira quante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Iesusiva mwitaa tuvaro mwi vaisiva tiqaro, Nte nraaqiara patakyaa mwi quara riemwaqina nruvama mate mwaa varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mwitaa tuvaro Iesusiva mwia qua riero mwia timwa mwinro tiqaro, Mwitaa hirera, e kuaa inraikya nraahu hia utuaro. E ekyaa ena vataana inraikyara mpohua nyinra munima vara kyera ntainra kyera vehi nraakye qora nyinranro nyaamwuni ini mpo inraikya vahiarive. Mwitaama kyera mwiaqaataira ni pataqira nriante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mwitaa tuvaro mwi vaisiva airi inraikya vatovara tiro, mwia mwutukyavanto uaqia huvaro varura. ");
INSERT INTO omw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mwia mwutukyavanto uaqia huvaro varuvaro Iesusiva mwia taqero tiqaro, Airi inraikya vate vari vaisihua mwukyaari tu kyeta Kotira mwatukyaqi vivarave. ");
INSERT INTO omw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","(Kameri quara nronravanto nataama kyerove vuqa uvintaqi/iriraqi ntuqiaraananrove? Hia qiove.) Qio nte qianinra riaate. Kamerivanto vuqa uvintaqi/iriraqi qio ntuqiarairarove, airi inraikya vataarivavata Kotira mwatukyaqi qio quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mwitaa tuvata nraakye qoravanto mwi quara rietama Iesusira kyapara hita tiqata, Airi inraikya vataariva Kotiva ntaqikyianinraqi hia qio virera, nai ta vaisivave qio variraro Kotiva mwia vitaananrove? tita. ");
INSERT INTO omw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Mwatani varihua mwihua nkyiari nraahu variqata hiama qio vivarave. Kotiva mwihua kyaahaqa hiratama mwihua qio vivarave. Kotiva ekyaa kyaiqa vare varivave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mwitaa tuvaro Pitaava tiqaro, Taqaante. Tirenramwu i vataqi virera hiqata, teta hunanra ekyaa inraikya mwini kyeta qatima nrunro, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Mwitaa tuvaro Iesusiva tiqaro, Eo, qutaama tira hiaro. Nte qianinra riaate. Vaisivanto Kotiva ntaqikyiani kyaiqarara rieqaro nai mwaatave, nai nraatave, nai qata vakyaahuave, nai nrohua qohuave, nai nraaqiarave, mwiva mwihua mwihua mwini kyero Kotira kyaiqa vararero viraro ");
INSERT INTO omw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Kotiva hiama eqaananrove. Kotiva mwi vaisira mate mwaa entaravata mwia qiata airiqama kyero mpo inraikya mwiananrove. Mwinro nraakiaravata mwinranro mwi vaisiva ekyaa enta qati variqiro quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesusiva nai nraaqiara 12 nramwu nraahu sita mpo sata kyero timwa nyinro tiqaro, Riaate. Nte mwatani mwatatai nraaqiaravama varuqo. Tirenramwu Ierusaremini quararo haaru poropeti vaisinramwuvanto nianra ekyaa qua qara ntumwa to quava qutaa mwivauma vahiananrove. ");
INSERT INTO omw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ni ntavaaqavuqita uro mpo mwatanaahua kyauquqi kyaivata mwi mwatanaahua nianra raima mateta, nianra uaqia hi quara timwa mateta, niqaa taara vihivarave. ");
INSERT INTO omw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mwitaamaqi viqata mwihua ni kyaamwuqo ntuqutu mateta, ni pitaqita ru kyaivaqe nte taarampo enta variariro (Kotiva ni vara qati sivuma kyairaqe) nte qati variqi quaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iesusiva mwitaa tuvata mwia nraaqiaranramwuvanto hia mwia qua ntapihi kye riora. Mwi quara okyaravanto uqeta viro vahuvata mwihua tiqata, Iesusiva nanra quave tiho? Hia tirenramwu mwia qua ntapihuro, tita. Turama. ");
INSERT INTO omw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesusiva Ieriko qaumato vuvaro vaisi mpovanto vu qipa vuva aanra tokyani variqaro mpo inrakya mpo inraikyara nyaanru tiqaro mpiate ti varu vaisiva variqaro riovata ");
INSERT INTO omw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","nraakye qora airivanto mwisaita nritareqata vi varuvaro mwiva mwihua kyapara hiro tiqaro, Taqaate. Nanra inraikyave uti variavo? tuvata ");
INSERT INTO omw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","mwihua mwia timwa mwita tiqata, Iesusiva Nasaretinyaava nritare vi variho, tura. ");
INSERT INTO omw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tuvaro mwiva aakyara ntamwa kyero tiqaro, Iesusio, Ntevitira mwaaquo, qati nianra po kye timwa mataante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mwitaa tuvata nraakye qoravanto mwia vuni varuhua mwia inronra hita tiqata, Eqera tirema variante, tuvaro mwiva hia mwihua qua riaraitiro, qaiqaa nraahu aakyara ntero tiqaro, Ntevitira mwaaquo, qati e nianra po kye timwa mataante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mwitaa tuvaro Iesusiva uro mwiaqaa siviro variqaro vu qipa vu vaisira mwia viteta nte hunani nriate tuvata mwia vitaqita nrumu mwiva hunani kyovaro Iesusiva mwia kyapara hiro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Nivanto i nataa hiarive tirave e nianra aakyara nte variaro? tiro. Tuvaro mwiva tiqaro, Nronrao, e ni pu ntapairi kyaanterama nte iara aakyara tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mwitaa tuvaro Iesusiva mwia timwa mwinro tiqaro, Vu ntapairi kyera taqaante. E nianra mwiva ni kyaahaqa hianinrave qiararoma i vu ntapairi viho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mwitaa tuvaro qamwanrama kyero mwia vuvanto ntapairi vuvaro qio taqeqaro mwiaqaatairo mwiva Kotira nrutu tuaahereqaro Iesusira vataqiro vuvata nraakye qora ntuvaantuama vita varuhua mwihuavata mwia taqeta Kotira nrutu tuaahere varura. ");
INSERT INTO omw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesusiva Ierikoqi urontero mwatukya mwiqi vi varuvaro ");
INSERT INTO omw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","taakisi vare varuva nronra vaisi Sakiaasiva airi inraikya vatova mwini varura. ");
INSERT INTO omw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mwi vaisiva tiqaro, Iesusiva nai nataa hi vaisivave iho? timwa kyero mwia taqaankye tuvata airi nraakye qora ututuma vita varuvaro mwiva qiqu vaisiruvantora tiro, hia qio Iesusira taqaaqara hura. ");
INSERT INTO omw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mwitaa huvaro mwiva hiantero Iesusiva quani aanranraqaa mwiva nraante uro ntero Iesusira taqarero kyatariqi nriviro varura. ");
INSERT INTO omw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mwiqi varuvaro Iesusiva nri ntero tuaahera kyero viri mwia taqero Sakiaasirara tiqaro, Sakiaasio, qamwanrama mpiami ntaante. Mate nte i nraamwuqi uro varianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mwitaa tuvaro Sakiaasiva qamwanrama mpiami ntero mpoqama kyero qamwata kyero Iesusira vitero uro nai nraamwuqi kyovata ");
INSERT INTO omw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","nraakye qoravanto taqetama nrutu nraunru tita tiqatama, Mwi vaisiva qora vaisi mpuara vaisi nraamwuqima viho, tura. ");
INSERT INTO omw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mwitaa tuvaro Sakiaasiva siviro nronra vaisi Iesusira timwa mwinro tiqaro, Nronrao, riaante. Nte iara rieqanama ntena hu inraikyara utaqaa ntainra kyena hini vehi nraakye qora nyinrenrave. Nte taakisi vareqana mpora munima unra timwa kyena mpoqiavata varaankyera, hia nai kuaa nani mwinrenrave. Nte erahiamuaantema nani mwinrenrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Nte mate mwaa nraamwunraqi vera ntena taqauqata nkye uaqia hi aanranra qaqira kyeta Kotira aanraqaa virerata uti variavo. Mwaa vaisiva Evarahaamunra kuaa okyaravantoma variho. ");
INSERT INTO omw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nte mwatani mwatatai nraaqiarava variqana nte raupirima vi vaisihua puaama kyaariro Kotiva sitaarive tina nruvave, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iesusiva qua timwa nyuvata nraakye qoravanto mwi quara rieta nkyiari rieta tiqata, Iesusiva Ierusaremi qaumatoma nrumu variho. Kotiva mwia kepukya mwinranro mwiva nronraqama viro tiriqaa ntaqikyiari entava qaumato vaiho, tita. Mwihua nkyiari riemwa kyeta mwitaa ti varuvaro ");
INSERT INTO omw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iesusiva mwaa quaraqaa ntumwa kyero timwa nyinro, Nronra vaisi mpovanto tiqaro, Nte nyianra mpo mwatani uro variarita ni nronraqama kyaivaqena nte vunyaa vaisiqama vina uro ntantena nrinrenrave, turave. ");
INSERT INTO omw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Timwa kyero mwiva virera hiro nai kyaiqa vaisi kyauqurutana nyaanrama kyero mwihua munima 20 kinaa 20 kinaa nyinro tiqaro, Mwaa munimanraqotaita uro kyoqaa kyaiqa vare varivaqenama nte uro ntantena nriankye, turave. ");
INSERT INTO omw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mwitaa timwa kyero vuvata mwi mwataraqi varuhua hia mwi vaisirara kyakya huvata mwihua vaisi mponramwu siteta tiqatama, Nkye mwia nraakiara viqatama mwitaama qiate. Mwi vaisiva uro nronraqama viro vunyaa vaisi vari viro uro ntantero hiama nrumu tiriqaa ntaqikyiananrove qiate, turave. ");
INSERT INTO omw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mwi mwatanaahua mwitaa timwa kyeta varuvaro nronra vaisi mwiva mpo mwatani uro varuvata mwia nronraqama kyovaro mwiva mwini variro uro ntantero nrumu nai kyaiqa vaisi haaru munima nyuhua nyaanrama kyero tiqaro, Nte munima nyunraqo kyaiqa utu kyeta nataamave varaavo? tiro. ");
INSERT INTO omw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tuvaro mwia kyaiqa vaisi mpovanto nri ntero tiqaro, Nronrao, Munima 20 kinaa mpiarana nte mwiaqo kyaiqa utu kyena 200 kinaa varauqo, turave. ");
INSERT INTO omw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mwitaa tuvaro nronra vaisi mwiva tiqaro, E kyuqema kyerama kyaiqa varaaro. E pata kyaiqa kyuqema kyera varaananra nte mwianra rieqana nronra kyaiqa i mwinrenrave. Nte i nronraqama kyaarira e mwatukya kyauqurutanaqaama ntaqikyinanrave, turave. ");
INSERT INTO omw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mwitaa tuvaro mwia kyaiqa vaisi mpovanto nri ntero tiqaro, Nronrao, munima 20 kinaa mpiananraqo nte kyaiqa utu kyena 100 kinaa varauqo tuvaro ");
INSERT INTO omw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","mwi vaisirara tiqaro, Nte i nronraqama kyaarira e mwatukya hini kyauquruqaa ntaqikyinanrave, turave. ");
INSERT INTO omw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mwitaa tuvaro mwia kyaiqa vaisi mpovanto nri ntero tiqaro, Nronrao, munima 20 kinaa mpiananra mwaa ena qati varaante. Nte mwi munimanra tavunaqo qapuqama kyena uqeta taurave. ");
INSERT INTO omw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","E kyaiqara vuaviraavira ti variarava variarana nte i nraatu aatu hiqana varuqo. E mpohua hia inraikyara api varaaravave. E mpohua vara tutaara uro api vanti variaravave, turave. ");
INSERT INTO omw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mwitaa tuvaro nronravanto tiqaro, E kyaiqa vaisi uaqia hiaravama variaro. Nte ina qua mwianra rieqana nte iqaa qua vatarerave. E nianra tiqara, E kyaiqara vuaviraavira ti variaravave. E mpohua hia inraikyara api varaaravave. E mpohua vara tutaara api vanti variaravave, qiananrave. ");
INSERT INTO omw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","E mpo, mwitaa timwa kyera nanraqamave hia mwi munimanra mpenki nraamwuqi uro vatera hiaro? Mwitaa hiaratiri, nte vuva uro ntantena nrumu variqana mwi munimanravata, mwiqi vataananranra rieqana munima pata mpoqiatanavatama varautirio, turave. ");
INSERT INTO omw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mwitaa timwa kyero mwiva mwini sivi varuhuara tiqaro, Mwi vaisira munima mwia ntavihi kyeta munima 200 kinaa vatai vaisira mwiate, tuvata ");
INSERT INTO omw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","mwihua qaqao tita, Mwi vaisiva munima 200 kinaa vaakya vataivave, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","mwiva tiqaro, Nte qianinra riaate. Mpo inraikya vaakya vataari vaisiva mpoqiavata varaananrove. Hia mpo inraikya vataari vaisiva variraro mwiva hiani inraikyara pata mwiqiara vara kyaananrove, turave. ");
INSERT INTO omw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mwitaa timwa kyero mwiva tiqaro, Vaisi mponramwuvanto nianra hia mwutukya ntihata hia tiriqaa ntaqikyiananrove qia vaisihua, mwihua sitaqita nrumu ni puqaa kyeta ru taiqa kyaate, turave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesusiva mwitaa timwa kyero Ierusareminianra mwiva nraante viro. ");
INSERT INTO omw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mwiva vuva Mpetapaasivata, Mpetaanivata, Oripi taaqi nrunroqi vahu mwatukyatana qaumato nrintero Iesusiva nai nraaqiara taaratana sitero tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nkyetana vutu mwatukyaraqi quate. Nkyetana vihua uro taqaivaro mwi mwatukyaraqi ntonki qaraakya kyaantaru taariva variananrove. Mwi ntonkira hia vaisivanto mwia mwoqaqa mwatakyaa viro nrohi ntonkirave. Nkyetana uro mwia puaama kyetama ntatu kyeta mwaini vitaqita nrumu mpiate. ");
INSERT INTO omw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mpovanto nkyitananra nanraqamave nkyetana mwia ntati variavo tirera, nkyetana mwitaamama timwa mwiate, Tiritana nronravanto mwianra tihata nrunro qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Iesusiva mwitaa timwa kyero mwitanahua sitovata vuhua uro taqovaro Iesusiva tuntema kyero vahura. ");
INSERT INTO omw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mwitanahua ntonki ntati varuvata ntonki mwia qohua mwitanahuara tiqatama, Nkyetana nanraqamave mwia ntati variavo? tuvata ");
INSERT INTO omw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","mwitanahua tiqata, Tiritana nronravanto mwianra tihatama nrunro, tita. ");
INSERT INTO omw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mwitanahua mwitaa timwa kyeta ntonki mwia vitaqita Iesusira uro mwita. Uro mwita mwihua nkyiari vaaqa ntonki mwia mwoqaqa vuti mwateta Iesusira kyaahaqa huvaro Iesusiva mwiaqaa mwaanri ntero mwatakyaa viro varura. ");
INSERT INTO omw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iesusiva mwatakyaa viro aanraqaa vi varuvata nraakye qoravanto Iesusira qamwata mwatarerata nkyiari vaaqa aanravau vuti tovaro ");
INSERT INTO omw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Iesusiva Ierusaremi qaumato Oripi taaqiqaatairo vu aanranraqaa uro ntovata mwia vataqi nruhua airivanto ntuvaantuama vita aakyara ntamwaqi viqata Iesusirara kyuqeve tiqata mwia kyaiqa taqorara rieqata Kotira nrutu tuaaheraqita vurama. ");
INSERT INTO omw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mwihua tiqata, Nronravanto nai nrutuqa nri vari vaisira kyuqema mwataiho. Kotiva nyaamwusairo tiri mwaateraqama timwa taananrove. Kotiva nyaamwu virini varihata tire mwia nrutu nronraqama kyauro, tita. ");
INSERT INTO omw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nraakye qoravanto mwitaa timwaqita vi varuvata Parisi vaisinramwuvanto mwini varuhua Iesusirara qaqao tita, Mwaanra ti variara vaisivao, ena nraaqiaranramwuanra tirema variate qiante, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iesusiva mwihua nkyiari timwa nyinro tiqaro, Mwihua tirema varivera, aanraqaa vahi oriva, mwivama aakyara nteqaro ni nutu tuaaheraananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesusiva mwitaa timwa kyero Ierusaremini qaumato nri ntero mwatukya nronra mwia taqero mwianra ntatero tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Po, e mwaateraqama vi vari aanranra taqaataara vaihara hia taqaananrave. Mwi aanrava tuqeta vaiharara tira, hia taqaaro. ");
INSERT INTO omw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mpo enta nri ntairata i nramwutaahua i rirerata i vara ututuma teta vasaamwunra tokyasataa mwata quvukye ntamwa teta mwiaqaatai ivata ntaqivarave. Mwitaa hiqata ena kyaahaqa hina aanranravata titaa titama kyeta i antua tevarave. ");
INSERT INTO omw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mwihua i nraatara kyeta ivata, i utaqi vari nraakye qorahuavata, ru taiqa kyevarave. Kotiva i kyaahaqa hiari entava vaihara e hia mwianra riaaro. Mwia kyaara i taiqa kyeta ekyaa ori nraamwu taaqau vahianinra ekyaa ntuvuraavurama kyaivaro hiama kuaiqiavantovata qati vahiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iesusiva mwitaa timwa kyero uro Kotira nraamwuqi vera ntero taqovata kyoqaa uti varu vaisihua mwiqi variqata kyoqaa kyaiqa vare varuvaro Iesusiva mwihua sata veva mwaatani kyero tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kotira mpukuqi Kotiva mwitaama turave: Nraakye qoravanto ni nraamwuanra Kotirara aakyara nte nraamwunrave tivarave, turave. Nkye variavaro mwaa nraamwuva mpuara vaisivanto uqeta vita variqata mpuara vare varia nraamwunra votima kyero vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mwitaa timwa kyero Iesusiva mwiaqaatairo mpo enta mpo enta uro Kotira nraamwuqi variqaro nraakye qora qua mwakyaakya timwa nyiqiro viro. Mwitaamaqiro vuvata Kotira nraamwuqi Kotira kyaiqa vare varu vaisihua mwihua nronra vaisinramwuvata, mwaanra okyara ti varu vaisihuavata, nronra vaisi mponramwuvantovata, mwihua Iesusira rukyaare tita taqovata ");
INSERT INTO omw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nraakye qora airivanto Iesusira qua nraahu riaataa huvata rie varuvata nronra vaisinramwuvanto mwia rukye aanranra puaa huvaro hia vahura. ");
INSERT INTO omw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mpo enta Iesusiva Kotira nraamwuqi mwakyaakya kyuqe mwakyaakya nraakye qora timwa nyiqiro vuvata Kotira nraamwuqi Kotira kyaiqa vare varuhua mwihua nronra vaisinramwuvata, mwaanra okyara ti varuhuavata, nronra vaisi mponramwuvantovata, mwihua nri nteta ");
INSERT INTO omw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Iesusira inronra hita tiqata, E ta vaisiva variqarave e mwaa kyaiqara vare variaro? Tava i nronraqama kyaiharave e mwaa kyaiqara vare variaro? Tiraqe riaare, tita. ");
INSERT INTO omw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mwihua mwitaa tuvaro Iesusiva tiqaro, Kyai nte nkyi nraante kyapara hiankye. ");
INSERT INTO omw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Tava Ioninra nronraqama kyovaro Ioniva nraakye qora nramanri nyunrave? Kotivave iho? Qumina nraakye qoravantove iho? Nkye timwa mpivaqe riaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Iesusiva mwitaa tuvata mwihua nkyiari kyapara hita tiqata, Tire nataave qiananrave? Tire tiqata, Kotiva mwia nronraqama kyorave, qiararo mwiva tiriara nkye nanraqamave Ioninra quara hia qutaave qiavo qiankyorave. ");
INSERT INTO omw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tire tiqata, Qumina vaisivanto mwia nronraqama kyorave, qiarata nraakye qora mwaaqi ntuvaantuama vita variahua oriqo tiri aavata ntuqutu kyevorave. Qumina nraakye qora mwaahua Ioninranra mwiva poropeti vaisivanto Kotira qua ti varuvave ti variarave, tita. ");
INSERT INTO omw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mwihua mwitaa timwa kyeta Iesusira timwa mwita tiqata, Nai tava Ioninra nronraqama kyorave? Hia tire ntapihuro, tita. ");
INSERT INTO omw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Nkye hia ni timwa mpiavana ntevata ni nronraqama kyaihana mwaa kyaiqara varaura okyara hia nkyitavata timwa nyianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mwitaa timwa kyero Iesusiva mwaa quaraqaa ntumwa kyero timwa nyinro tiqaro, Vaisi mpovanto uaini aakyoqi vara tutero mwiaqaatairo nyianrani virera hiro vaisi mpo uhuara tiqaro, Nkye ni aakyoqaa ntaqikyi mate varivaqe nte nyianrani quankye, timwa kyero nai mwaata mwini kyero mpo mwatani mpuahaama varirero vurave. ");
INSERT INTO omw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mwini uro varuvaro uaini hiqu entava nri ntovaro mwiva nai kyaiqa vaisi mpo titero tiqaro, Uro ni aakyoqaa ntaqikyiahua tirata ninanivata uaini hiqukye mataate, tuvaro mwini vuvata mwia kyaiqa vaisi mwia ntuqutu kyeta vatovaro mwiva hia uainivata vararaitiro, qati uro ntantero nrunrave. ");
INSERT INTO omw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nruvaro mwiva nai kyaiqa vaisi mpo titovaro vuvata mwiavata ntuqutu kye vateta kyaurira inraikya mwuvaro mwivavata qati uro ntantero nrunrave. ");
INSERT INTO omw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mwitaa huvaro aakyo qova nai kyaiqa vaisi mpo titovaro vuvata aakyoqaa ntaqikyi varuhua mwiavata ntuqutu kye teqaaqama kye vateta vitaqita mwaaqani mwaati tuto kyorave. ");
INSERT INTO omw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mwitaa huvaro aakyo qova tiqaro, Nte nataave hianinrave? Kyai nte ntena maaqu mwianra mpoqiavata ni mutukya vahira titaarita mwianra mwia mwaaquvantove timwa kyetama mwia kyuqema mwatevarave, turave. ");
INSERT INTO omw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mwitaa tuvaro mwia mwaaquvanto vuvata mwia aakyoqaa ntaqikyuhua mwia taqeta tiqata, Mwaa mwia mwaaquvanto nriho. Nrivaqe mwia ru kyaararo mwia aakyovanto tirini vahiarive, turave. ");
INSERT INTO omw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mwitaa timwa kyeta mwihua aakyoqitaita mwia vara mwaati mwaaqani kyeta ru kyorave, tiro. Iesusiva mwitaa timwa kyero mwihua kyapara hiro tiqaro, Mwihua mwitaa hurara tiro, aakyo qova nai mwaaqu rukyera kyaara nataave hiananrove? ");
INSERT INTO omw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aakyo qova nri ntero aakyoqaa ntaqikyi vaisihua ru taiqa kyero mpohuarama ni utaqaa ntaqikyi mataate qiananrove, tiro. Iesusiva mwitaa tuvata nraakye qora mwiqi ntuvaantuama vita varuhua qaqao tita, Hiama mwiva mwitaa hiananrove, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesusiva mwihua taqero mwihua kyapara hiro tiqaro, Mwaa quava Kotira mpukuqi qara ntumwa tova nanreve tiho? Mwi quara okyara ni timwa mpivaqe riaankye. Mwitaama tiho: Ori nraamwu hoqeqaro ori mpo, hia kyuqe hirave timwa kyero qaqira kyaiva, mwi oriva puhaqama viho, turave. ");
INSERT INTO omw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ori mwiaqaa tuto ntuaninra toqa ntupepaama pataqia pataqiama kyaananrove. Mwi oriva vaisi mpoqaa tumu ntirera, vaisi mwia rukyero mumuni utu kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mwitaa tuvata mwaanra okyara ti varu vaisihuavata, Kotira kyaiqa vara mwate varuhua mwihua nronranramwuvantovata, mwihua tiqata, Mwiva mwi quara tiriqaa ntumwa kyero tiho, timwa kyeta Iesusira mwiqi tu varaare tuvata nraakye qora airivanto varuvata mwihuara aatu hita hia mwia tu varora. ");
INSERT INTO omw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mwihua nraakye qora nraatu aatu hiqata hia Iesusira tuvararaitita, qatinasaita mwia aitutuhi variqata vaisi mponramwu siteta tiqata, Nkye qumina vaisi nraantantamwa kyeta uro variqata mwia qua riemwaqita vivaro mwiva api qua tirata nrumu tirivata hunta kyaivaqe uro kamanira nronra vaisi timwa mwianranro mwiva nrumu Iesusira tu varaarive, tita. ");
INSERT INTO omw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mwitaa tuvata vaisi mwinramwuhua uro Iesusirara mwitaama tita, Mwaanra ti variarao, tire taqaurara e nraakye qora ntapihi kyeqara qua mwakyaakya timwa nyi variaravave. E nronra vaisiaravata, pata vaisiaravata, kuaa qarama kyera nraahu qua qiaravave. E vaisivanto Kotira aanraqaa virara ntapihi kyera timwa nyi variaro. ");
INSERT INTO omw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","E mwaa quara tiri timwa timwinraqe riaare. Tire Kotira qua rieqata qiove tire Romeni mwihua nronra vunyaa vaisi Sisaara taakisi mwiananrave? tita. ");
INSERT INTO omw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mwitaa tuvaro mwiva api qua qiarive tita tu quara Iesusiva ntapihi kyero, mwiva mwihuara tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Munima mpoqia vara kyaivaqe taqaankye, tiro. Tuvata mwihua munima mporu vara kyovaro taqero tiqaro, Munima mwiaqaa tara virivata tara nrutuvatave vaiho? tiro. Tuvata mwihua tiqata, Sisaarave, tura. ");
INSERT INTO omw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tuvaro Iesusiva mwihua timwa nyinro tiqaro, Mwianra rieqatama nkye Sisaava hianinra nai mwiate. Nkye Kotiva hianinra nai mwiate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iesusiva mwitaa tuvata mwihua Iesusiva nraakye qora suqaa api qua tiraqe mwia tuvaraare tita taqovarovata mwiva hia api qua tuvata mwihua Iesusiva qua tura rieta qikye tita, Mwiva tiri quavata nraatara kyero kyuqe quama tiho, timwa kyeta mwihua kyauqu ntukikinraaqata kyeta tirema varura. ");
INSERT INTO omw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Vaisi mponramwu Saitiusi vaisinramwuvanto tiqata, Vaisivanto qutu viro ekyaarama taiqa viro hiama qaiqaa siquananrove, ti varuhua uro Iesusira kyapara hita tiqata, ");
INSERT INTO omw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mwaanra ti variara vaisio, tiri haivaqava Mosesiva mwaanra qua tiri timwa timwiqanro mwitaama qua vatorave. Vaisi mpovanto hia nraaqiara mwataraitiro, qutu viraro mwia qatavantove mwia vakyaavave mwia nraata varatero nraaqiara mwata kyero nai qora mwaatana vataarive, turave. ");
INSERT INTO omw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tire qiananra riaante. Haaru qate vakye 7 nramwu varurave. Mwinramwuhua sakyaava nraakye varatero hia nraaqiara mwataraitiro, qutu vuvaro ");
INSERT INTO omw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","mwia nanaava mwia nraata varatero mwivavata hia nraaqiara mwataraitiro, qati qutu vurave. ");
INSERT INTO omw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mwiva qutu vuvaro mwia nanaava nraakye mwia varatero mwivavata hia nraaqiara mwataraitiro, qutu vuvaro mwiaqaataita hini mwihuavata mwitaamaqi vita uro ekyaa qutu vurave. ");
INSERT INTO omw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mwihua ekyaa qutu vuvaro nraakye mwivavata nraakiara variqi viro qutu vurave. ");
INSERT INTO omw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nraakiara nraakye qoravanto qaiqaa qati sivita vari entaraqaa mwi nraakyeva tara nraatave variananrove? Mwiva qati varu entara qoraisi 7 nramwu varatorave, tita. ");
INSERT INTO omw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Saitiusi vaisinramwuvanto mwitaa tuvaro Iesusiva mwihua nkyiari timwa nyinro tiqaro, Mate mwaama mwatani varia nraakye qorahua nai vare nai vare hiavo. ");
INSERT INTO omw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nraakiara Kotiva taqairata nyaamwuni virara qioqa ihua mwihua qati vara sivuma kyairata mwihua mwini uro qati variqi viqata hiama nraata vaati varevarave. ");
INSERT INTO omw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mwihua nyaamwunyaahua votima kyeta variqata hia qaiqaa qutu vivarave. Kotiva mwihua nkyiari quntamwa teraqitairo qati vara qaiqaa sivuma kyaaninranra tita, mwihua Kotira nraaqiarama varivarave. ");
INSERT INTO omw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Vaisivanto qutu viro qaiqaa qati siquaninranra nkyi haivaqava Mosesiva mwi quara qara ntumwa torave. Kotiva qia ite varu kyatariraqitairo Mosesirara qua tu entara Mosesiva Kotirara mwitaama kyero qara ntumwa tero tiqaro, Kotiva Evarahaamunraqaavata, Aisaakiraqaavata, Iaikopuraqaavata, ntaqikyi varivave, turave. ");
INSERT INTO omw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Qio riaate, ekyaa enta variva, Kotiva hia qutu viro taiqavi inraikyaraqaa ntaqikyi varivama varirave. Mwiva qati variqi vi inraikyaraqaa ntaqikyi varivama varirave. Vaisivanto qutu viharo Kotiva qati variahuaqaa ntaqikyintema kyero mwiva mwanraquraqaa ntaqikyi varirave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iesusiva mwitaa tuvata mwaanra okyara tuhua hinivanto tiqata, Mwaanra ti variara vaisio, e kyuqe quama nkyiari hiniqama kyera timwa nyianro, tita. ");
INSERT INTO omw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mwihua aatu hiqata hia qaiqaavata Iesusira kyapara hiare timwa kye mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesusiva mwihua kyaparama nyateqaro mwitaama tiro: Mpo hia vaisihua tiqata, Kotiva titaariva Mesaiaavanto Ntevitiva mwatataaninra mwi naaquntaraqaanaavama variananrove, ti variarave. Nanraqamave mwihua mwitaa ti variavo? ");
INSERT INTO omw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ntevitiva nai qara ntumwa to mpukuraqi nai tiqaro, Kotiva ni nronra vaisiara tiqaro, E nritarera ni kyauqu kyaatutani mwatakyaa vira variraqe ");
INSERT INTO omw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nte i nramwutaahua nraatara kye ru taiqa kyaarira e mwihuaqaa kyuqu ntamwa taante, turave. ");
INSERT INTO omw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ntevitiva haaru mwitaama kyero qara ntumwa torave. Ntevitiva Mesaiaavanto qovara hianianranra tiqaro, Ni nronra vaisive, turave. Ntevitiva mwitaa turara tiro, nataama kyerove Mesaiaavanto Ntevitira nraisi variananrove? tiro. ");
INSERT INTO omw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Iesusiva mwihua kyaparama nyatovata nraakye qora mwiqi varuhua mwia qua rie varuvaro Iesusiva nai nraaqiaranramwuanra tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Mwaanra okyara ti varia vaisihuara rauriqata variate. Nraakye qoravanto mwihua taqeta qua mwanteqata qamwataate tita, mwihua tavuna mpuahaa kyuqera rupa vareta maaketiqi nraakye qora suqaa nraahu nrohi variarave. Mwihua mwaanra nraamwuqi vera nteta tainta uaqia hiraqa eqeta kyuqeraqaa nraahu mwatakyaa vita variarave. Mwihua omwata nraanraqaa variqata mwihuara nronra vaisive qiate tita, vaisi nrutu vaihua variaraqaa mwihuavata mwatakyaa vita variarave. ");
INSERT INTO omw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mwihua tetoqa nraakye nraamwuvata, mpo inraikya mpo inraikyavata, mpuara vareta tiqata, Mpohua tiri uaqia hi kyaiqara taqeta tiriara uaqia hia vaisihuave tivo, tita, mwihua nraakye qora suqaa Kotirara mpuahaama kyeta aakyara nte variarave. Qikye, mwia kyaara mwihuaqaa nronraqama kyero qua vahiananrove, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesusiva Kotira nraamwuqi variqaro taqovata airi inraikya vato vaisihua nri nteta Kotira kyaiqara rieqatama munima nronraqama kye taquqi mwaati kye varura. ");
INSERT INTO omw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Iesusiva taqe varuvaro tetoqa nraakye hia mpo inraikyavata vatova vehi nraakyevanto nri ntero mwivavata taquqi munima uapaara taararu mwaati kyora. ");
INSERT INTO omw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mwiqi mwaati kyovaro Iesusiva tiqaro, Taqaate. Vehi tetoqa nraakyevanto kyai munimava ekyaa inraikya vataahua kyaa munimanravata nraatara kyaiho. ");
INSERT INTO omw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Airi inraikya vate variahua mwihua nkyiari munima hini nraahu taquqi mwaati kyaavo. Mwi nraakyeva vehi variqaro nai vatai munimanra ekyaa kyaiharo hia kyaravata vara nraanriva vaiho, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Vaisi mponramwuvanto Kotira nraamwuanra tiqata, Nraamwu kyuqera mwia taqaate. Nraakye qoravanto Kotirara rieqata munima kyaavata ori kyuqera vara kyeta nraamwu kyuqera hoqa taarave, tita. ");
INSERT INTO omw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Mwitaa tuvaro Iesusiva tiqaro, Nkye mate nraamwu mwaa taqe variarave. Nraakiara ori nai mwoqaqa nai mwoqaqaa taaqau kye vataava hia mwitaama vahiananrove. Nraamwu mwaa ntuarakuraakurama kyeta kyaivaro hia ori mpoqiavantovata nai mwoqaqa nai mwoqaqaa vahiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iesusiva mwitaa tuvata mwihua tiqata, Mwaanra ti variarao, taireve mwitaa hiananrove? Nanra inraikyavanto qovara hiraqe tire mwiaqaa vitama kye taqetave mwi entava nrianriva qaumato vaiho qiananrave? Tiri timwa timwinraqe riaare, tita. ");
INSERT INTO omw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mwitaa tuvaro Iesusiva tiqaro, Mpovanto mwi quara nkyi api timwa nyiankyo tita rauriqata variate. Nraakiara vaisi airivanto nrinte ni nutu nteta tiqata, Kotiva ni titaihana nruva, nte mwaa mwivama varuqo. Qio mwi entava nri ntaiho, tivarave. Mwihua mwitaa tivata hia mwihua sataqita quate. ");
INSERT INTO omw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nkye variqata riaivaro mpo mwatanaava mpo mwatanaanravata ntaqirata nkye hia aatu hiate. Kamaniva nai henanra mpovatama kyero ntaquqiro virata nkye hia aatu hiate. Mwi inraikyava nraante qovara hiananrove. Mwitaa mwitaa hirata hia ekyaara enta nri ntaiho qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iesusiva mwitaa timwa kyero mwiva qaiqaavata timwa nyinro tiqaro, Mpo mwatanaava mpo mwatanaanravatama kyero ntaquananrove. Vunyaa vaisi mpovanto vunyaa vaisi mpovatama kyero ntaquananrove. ");
INSERT INTO omw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nraakiara ekyaa mwata vahiarintema nronraqama kyero mwatura tuananrove. Kyaravanto hia vahirata aara nte entava mpoqi mpoqi vahiananrove. Nyiqa quari entava vahiananrove. Nyaamwuqi nraatuqa taani inraikyara mpo inraikya mpo inraikya taqeta tiqata, Qikye, mwaa nanra inraikyave taqauro, tivarave. ");
INSERT INTO omw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Qakyo mwi inraikyava mwi inraikyava qovara hirata nkyi nraante ntavaaqavu kyeta uaqiama nyatevarave. Mwihua nkyi sitaqita uro mwaanra nraamwuqi nkyi ko timwa kyeta nkyi karavuqi sitaqita uro kyevarave. Nkye ni kyaiqa vare varivatara tita, nkyi ntavaaqavuqita uro nronra vaisi vunyaahua suqaa kyevarave. ");
INSERT INTO omw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nkyi sitaqita uro kyera mwi entara nkye ni qua mwihua timwa nyiva nkyiara kyuqe entama vahiananrove. ");
INSERT INTO omw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mwihua nkyi ko tirera hivata hia nkye nkyeta nraato tu kyeta mwi quara mwi quara tirerave qiate. ");
INSERT INTO omw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nte mwi entara nkyi kyaahaqa hiarita nkye kyuqe qua kepukya qua tivarave. Nkye mwitaa tivata nkyi uaqiama nyatehua hia nkyi qua qio nraatara kyevarave. ");
INSERT INTO omw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nraakiara nkyiqa qua vataate tita, nkyi nyohua sohuave, nkyi sata sakyaahuave, nkyi kuaa nraanrevantove, nkyi totivantove, mwihuama nkyi qovarama kyaivata nkyi ntavaaqavu kye sitevarave. Nkyi ntavaaqavu kyeta nkyi mponramwu ru kyevarave. ");
INSERT INTO omw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ekyaahua nkyiara Iesusira nraaqiarave tiqatama mwia kyaara mwihua hia nkyiara mwutukya vahirata varivarave. ");
INSERT INTO omw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mwihua mwitaa hivata nkye hia aatu hiate. Nkye qioma varivarave. Hia nkyi qiata kyaahi kuaiqiavantovata raupiri hiananrove. ");
INSERT INTO omw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nkye kepukyaqama kyeta varivera, nkye ekyaa enta qioma qati variqi vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mwitaa timwa kyero Iesusiva tiqaro, Nkye mpo enta taqaivata ntaqi vaisihua Ierusaremi mwatukya vara ututuma taivatama nkye mwitaama qiate, Ierusaremi ntamwa kyaivaro taiqaari entava nrintaiho, qiate. ");
INSERT INTO omw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mwi entara Iutiaani varihua aatu ntuqema kye hiantamwa teta verara ora tatari taaqini quate. Mwi entara Ierusaremiqi varihua mwiqitai sivita hiante aatu ntuqema kyeta verara taaqiqaara quate. Mwi entara Ierusaremi mwia tokya vaikya varihua mwatukya mwiqi hia quate. ");
INSERT INTO omw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mwi entara Ierusaremini varihua nkyiari uaqia hi kyaiqara utira kyaara Kotiva mwihua ruananrove. Haaru Kotira mpukuqi qara ntumwa to quava qutaa mwivau vahiarive tiro, mwi entara mwi inraikyava qovara hiananrove. ");
INSERT INTO omw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mwi entara nraaqiara tuaqa hitave, nraamwa nyi vari nraakyehuara po tuqo. Mwi entara mwihuara hia kyuqe enta vahiananrove. Mwi entara mwaa mwataraqaa varihua tiqata, Qio matema raupirima quananrave, tivarave. Mwi entara Kotira raraqa tairaro mwaa mwatanaahua ntuqutuananrove. ");
INSERT INTO omw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mwi entara mpo mwatanaahua nri nteta paipa mpuahaaqotaita mwaa mwatanaahua mponramwu rukyeta hini mwihua ntavaaqavu vareta mpo mwata mpo mwatani uro kyevarave. Mwi mwatanaahua hia Kotira qua riehua Ierusaremiqi nrohiqata mwi mwatukyara ntamwa ntautiqaatiqama kyevarave. Mwihua Ierusaremini variqi vivaro Kotiva qiove timwa taari entava taiqa virata vivarave. ");
INSERT INTO omw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nraakiara nyaamwuqi huariqaave, toraqaave, qovoraqaave, vitama kye taqetama nraakye qoravanto tiqata, Qikye, po, nanra inraikyavanto qovarama virera uti variharove mwitaa iho? tivarave. Nraakiara vevara kyaarera nramanri nronravanto nronraqama kyero nteqaro taku takaa hi varirata mpo mwatanaa mpo mwatanaahua kyuqu kyauqu ntirata aatu hiqata varivarave. ");
INSERT INTO omw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nraakiara nyaamwuqi vahiari inraikyava apiqama kyero vahiqaro qakyaa qakyaa hi varirata nraakye qoravanto mwia taqeta mpo inraikyavanto qovara hianinra vekya variqata nataave hiananrove timwa kyeta nraatuqa tero vuqitairo nrivu nrivu hirata tumu ntivarave. ");
INSERT INTO omw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mwitaa hi varirata mwihua taqe varivaqena nte mwatani mwatatai nraaqiarava nyaamwusaina tonamwuqi tumi variarita ni taqevarave. Nte mwunruqama taari inraikyava mpoqama kyero itero takyuqi variraqe nte kepukyavanto tumuaninrave. ");
INSERT INTO omw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nraakiara mwi inraikyava mwi inraikyava mwitaama kye tohara tairata nkye mwaamwianrama vita qiata tuaahera kyeta vateqata tiri kyaahaqa hiariva qio vainima vaiho qiate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iesusiva mwitaa timwa kyero mwiva mpo quaqaa ntumwa kyero timwa nyinro tiqaro, Kyatari qaampuakya tamwa voti hiraravata mpo kyatariaravata riaate. ");
INSERT INTO omw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nkye taqaivaro mwiva mwunri ntairata nkye mwiaqaa vitama kye taqeta tiqata, Huari nronraqama kyero itaari entava qaumaqa iho, tivarave. ");
INSERT INTO omw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mwia votima kyeta nkye taqaivaro mpo inraikya mpo inraikyavanto qovara hirata nkye mwiaqaa vitama kye taqeta tiqata, Kotiva tiriqaa ntaqikyiari entava qaumatoma vaiho, qiate. ");
INSERT INTO omw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nte qutaama tuqo, Mwaa mwataraqaa varihua hia taiqa vivaro mwi inraikyara mwi inraikyarara tuva qovara hiananrove. ");
INSERT INTO omw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nyaamwuvantovata mwatavantovata taiqa viraro ni quavanto qati nraahu vahiqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nkye rauriqata variate. Nkye kyara airi nreta uera nramanri nreqata mwata mwaaqaanaa inraikyara nronraqama kyeta riemwaqita vivorave. Nkye mwitaamaqita vivaro mwi entava nrihanrama nyatero nri ntairata nkye hia terama teta varivorave. ");
INSERT INTO omw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mwi entava mwaanra tita taintema kyero ekyaa mwata mwaaqa varihuaqa qovara hiananrove. ");
INSERT INTO omw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nkye rauru kyeqa variqi viqatama Kotirara aakyara ntaivaro mwiva nkyi kepukyaqama nyatairata nkye nraakiara nriani inraikyara nraatara kyetama ni mwatani mwatatai nraaqiarara vuqaa qio sivita varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iesusiva mwitaa timwa kyero mwiva mpo entanramwu variqaro Kotira nraamwuqi ihera nraakye qora mwakyaakya timwa nyiqanro entaqi uro Oripi taaqiqaa vaitata hura. ");
INSERT INTO omw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mwiva mwitaamaqiro vuvata nraakye qoravanto nai vaaota toqaqi nrumu Kotira nraamwuqi variqata Iesusira qua riora. ");
INSERT INTO omw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hia kyoto mperetirara nro entara mwia nrutu vekyahu nyato entarave tuva nri ntovata ");
INSERT INTO omw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kotira kyaiqa vare varuhua nronranramwuvata, mwaanra okyara ti varuhuavata, tiqata, Tire qumina Iesusira ru kyaarata nraakye qoravanto tiriara tivorave. Nataama kyetave tire mwia ru kyaananrave? tita. ");
INSERT INTO omw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mwitaa ti varuvaro Iutaasi Isikeriotiva, mwiva Iesusira nraaqiara 12 nramwuqitairo varuvaro Saataaniva mwia mwutukyaqi viqetero kyaahaqa huvaro ");
INSERT INTO omw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Iutaasiva siviro Iesusira qovarama kyarero uti variqaro Kotira kyaiqa vare varuhua mwihua nronra vaisivata, Kotira nraamwuqaa ntaqikyi varu pipohuavata, mwiva mwihua timwa nyinro tiqaro, Nte mwitaa mwitaa hiaritama nkye Iesusira ntavaaqavu kyaate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mwitaa tuvata mwihua qamwata kyeta tiqata, Tire i munimave mwiananrave? tuvaro Iutaasiva eo timwa kyero ");
INSERT INTO omw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","mwiaqaatairo variro tiqaro, Kyai nte taqaarita hia airi nraakye qoravanto mwiavata varivaqena mwi entara nte mwia uqeta kyena qovarama kyaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Iutaasiva mwitaa timwa kyero varuvaro hia kyoto mperetira nro entava nri ntovaro (mwi entaraqaa haaru nyaamwunyaava hia mwihua haivaqahua ru kyaraitiro,) mwihua vekyahu nyatero (nritarero uro Isipi nraaqiara ru kyo) entarara rieqatama mwi mwatanaahua sipisipi nraati rukye entava nri ntora. ");
INSERT INTO omw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nri ntovaro Iesusiva Pitaakya Ionikya sitero tiqaro, Nkyetana uro vekyahu nyato kyarara terama taivaqe tire nraanre, tuvata ");
INSERT INTO omw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","mwitanahua mwia kyapara hita tiqata, Taraqive mwi kyarara terama taananrave? tuvaro ");
INSERT INTO omw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Iesusiva tiqaro, Qio mwaini riaate. Nkyetana mwatukyaqi uro nteta vivaro vaisi mpovanto nramanri taqu kyaqa kyero varero aanraqaa nrianriva nrumu nkyitana qintorama kyairata nkyetana mwia vataqita vivaro mwiva nai nraamwuqi viqetairata nkyetanavata mwiqi vera nteta ");
INSERT INTO omw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","nraamwu qorara mwitaama qiate, Mwaanra ti vari vaisiva iara tiqaro, Taraqive nte ntena nraaqiara kyapata vekyahu nyato kyarara nraaninrave? tiho, qiate. ");
INSERT INTO omw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nkyetana mwitaa tivaro mwiva nraamwu nronra mpo mwaanrini mwoqaqa vahira nkyitana nyaamwu tairata nkye mwiqima kyara terama taate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iesusiva mwitaa tuvata mwitanahua vuhua uro taqovaro ekyaa inraikyavanto Iesusiva tunte tuntema kyero vahuvata mwitanahua vekyahu nyato kyarara terama tora. ");
INSERT INTO omw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mwitanahua kyara terama tovaro kyara nrenraqaa vahuvaro Iesusiva nai nronraqama kyo vaisinramwuhuavata taintaqaa mwatakyaa viro varura. ");
INSERT INTO omw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mwiva mwihua timwa nyinro tiqaro, Qakyo nte nriqavi inraikyara vararera hiqanama nte mwaa vekyahu nyato kyarara nkyivata variqana nraaninranra vuni nronraqama kye rieqana varura mwia mate nkyivata nranrenrave. ");
INSERT INTO omw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mwaa entaraqaataina hia qaiqaa vekyahu nyato kyarara nraaninrave. Nraakiara ekyaa Kotiva ntaqikyiari inraikyava qovarama virata nkye ntapihivaqe nte mwi entaraqaa qaiqaa nraaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iesusiva mwitaa timwa kyero mwiva uaini kaapu vara kyero Kotirara kyuqeve timwa kyero tiqaro, Mwaa kaapura vara kyeta nkye ekyaahua mwiqitai nraate. ");
INSERT INTO omw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mate mwaa entaraqaataina nte hia uaini nraanriva qati variqina quariro nraakiara Kotiva ntaqikyiari entava nri ntairaqena nranrenrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mwitaa timwa kyero mwiva mpereti vara kyero Kotirara kyuqeve timwa kyero nteqa kyero nai nraaqiaranramwu nyinro tiqaro, Mwaa ni mamantama iho. Nte nkyiara rieqanama mwia nkyi nyuqo. Nte mate mwaa utuntema kyeta nkyevata mwitaamaqi viqatama nianra rieqata variate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mwihua kyara nramwa kyovaro Iesusiva nramanri kaapuvata vara kyero kuaa qarama kyero nyinro tiqaro, Nkyiara rieqanama nte mwaa nramanrinra rauru nyatauqo. Kotiva nkyivata kuaaqi taaqau vi varirero qaraakya qua vataira mwi quava kepukyaqama quarive tiro, ni nraanrevanto mwi quara kepukyaqama kyaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mwitaa timwa kyero Iesusiva tiqaro, Qio taqaate, ni qovarama kyaari vaisiva mwaini variqaro ni vatama kyero kyara nre variho. ");
INSERT INTO omw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ni mwatani mwatatai nraaqiarara ni ru kyerara qio Kotiva nianra mwi aanranraqaa quante tirave. Kotiva qiove tirata ni rukyaate tiro, ni qovarama kyaani vaisirara nte po kye tuqo. Mwiva viro raupirima quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iesusiva mwitaa tuvata mwia nraaqiaranramwuvanto nai kyapara hi nai kyapara hita tiqata, Qaqao, nai tavave tiriqitairo mwi kyaiqara mwitaama kyero varaananrove? tura. ");
INSERT INTO omw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Iesusira nraaqiaranramwuvanto varita tiqata, Tavave tirinramwuqitairo nronraqama viro nronra vaisivanto variananrove? timwa kyeqata inronra hi varuvaro ");
INSERT INTO omw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesusiva tiqaro, Mwaa mwataraqaa variahua vunyaahua nkyiari nraakye qoraqaa ntaqikyiqatama tiqata, Nte nronravanto varurara tita, nkye ni qua rieta nkye nianra vaisi kyuqerave qiate, qiarave. ");
INSERT INTO omw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nkye hia mwihua nraantantaate. Nkyiqitairo mpovanto vaisi nronra varirero hiariva, mwiva uapaa vaisi nraantantamwa kyero variananrove. Nkyiqitairo mpovanto henahuaqa ntaqikyirero hiariva, mwiva nai hena vaisinramwuni kyaiqa vara nyataarive. ");
INSERT INTO omw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tava nronra vaisi varirave? Vaisivanto mwatakyaa viro variqaro kyara nre variva, mwivave nronra vaisi variho? Mwia kyaiqa vaisivanto kyara varaqiro nrumu mwi variva, mwivave nronra vaisi variho? Qio, vaisivanto mwatakyaa viro variqaro kyara nre variva, mwivama nronra vaisi variho. Qio nte nkyi kyapata variqana hia nte nkyiara kyaiqa vara mataate tiraitina, nte nkyi kyaiqa vara nyatauvave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Vaisi mpo hiahuave mpo inraikyavantove ni uaqiama matarera utuavata nkye ni vatama kyeta variqi vi variarave. ");
INSERT INTO omw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ni kova ni nronraqama kyaihana nte nraakye qoraqaa ntaqikyiqina virerave. Nte ntena kora nraantantamwa kyena nkyivata nronraqama kyaarita ");
INSERT INTO omw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","nkye nraakiara ni mwatukyaqi variqata nivatama kye kyaravata nramanrivata nramwaqi viqatama taintaqaa mwatakyaa vi variqata nkye Isareri nraakye qora 12 okyara mwihuaqaa ntaqikyivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Iesusiva mwitaa timwa kyero Pitaarara tiqaro, Saimonio, Saimonio, riaante. Saataaniva nkyi mwataarama kye nkyi ntainra kyaankye tiharo Kotiva qio mwitaa hiante tirave. ");
INSERT INTO omw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nte Kotirara aakyara nteqanama iara mwia kyaahaqa hiraro mwiva iara kepukyaqama kyero riemwaqiro quarive turave. Nraakiara qaiqaa nianra riemwaqira viqarama ena qata vakyaa kepukyaqama nyataante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Iesusiva mwitaa tuvaro Pitaava tiqaro, Qaqao, nronrao, nte ivatama kyena karavuqi vina ivatama kyena qutu quaninranra terama varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mwitaa tuvaro Iesusiva timwa mwinro tiqaro, Pitaao, nte i timwa mwianinra riaante. E taarampo nani nianra hia mwia taqaurave tiraro kokoraaravanto nruqua qiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mwitaa timwa kyero Iesusiva nai nraaqiaranramwu timwa nyinro tiqaro, Tauraaqama kyena nte nkyi sitauqata nkye munimavata, tuavata, kyuqu nraamwu hiravata, hia vararaitita, qati vurave. Nkye mwi entara mpo inraikyara aara ntorave iho? tuvata mwihua, Hiave, tita. ");
INSERT INTO omw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hiave tuvaro Iesusiva tiqaro, Mate mwaa tavave tua vataariva qioma tuavata varero quananrove. Hia paipa mpuahaa vataariva nai tuavaaqaqo paipa kyoqaama kyero varaarive. ");
INSERT INTO omw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nte timwa nyianinra riaate. Haaru nianra qara ntumwa to quava mwivauma vahiananrove. Nianra mwitaama tiro: Nraakye qoravanto mwianra uaqia hi kyaiqara uti varivave turave. Mwi quara haaru qara ntumwa tova mwivauma vahiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iesusiva mwitaa tuvata mwia nraaqiaranramwuvanto tiqata, Nronrao, mwaini taqaante. Paipa mpuahaa taaratanama vatauro, tuvaro Iesusiva qiove tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesusiva mwitaa timwa kyero mwiva nraamwuqitairo veva ntero nai nraaqiaranramwu kyapata Oripi taaqiqaa nai vi varuraqaa qaiqaa viro. ");
INSERT INTO omw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mwini uro ntero nai nraaqiaranramwu timwa nyinro tiqaro, Nkye Saataaninra qua rieqata uaqia hi kyaiqara utuarorave tita, Kotirara aakyara nteqata variate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mwitaa timwa kyero Iesusiva mwihua mwini kyero pataqia vututo viro uro tori kyauru raviro Kotirara aakyara ntero tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ko, nte nriqa quani nramanrinra nraaninra voti hira e qatinani vara kyaante. Qio hia ni kyakya hira vataqira quante. Ena kyakya hira vataqira quante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mwitaa tuvaro nyaamwunyaava tumu ntero Iesusira kepukyaqama mwatovaro ");
INSERT INTO omw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iesusiva varuvaro mwia mwutukyavanto anoma kyero uaqia huvaro Iesusiva kepukyaqama kyero aakyara ntamwaqiro vuvaro Iesusiraqaatairo toqaamwuvanto nraanre votima kyero mwataqi tumu ntura. ");
INSERT INTO omw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Qio Iesusiva Kotirara aakyara ntamwa taiqa kyero siviro nrumu ntantero uro nai nraaqiaranramwu taqovata mwihua mwutukyavanto uaqia huvata vaite varura. ");
INSERT INTO omw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Iesusiva mwihuara tiqaro, Nkye nanraqamave vaite variavo? Sivita Kotirara aakyara tivaro mwiva nkyi kyaahaqa hirata hia uaqia hi kyaiqara utuate, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesusiva mwini variqaro qati nraahu qua ti varuvata airi vaisivanto nri ntora. Iesusira nraaqiara 12 nramwuqitairo Iutaasiva airi vaisi sita varero mwiva nraante mwihua suni nruva Iesusiva varunani nri ntero Iesusira mota kyarero uti varuvaro ");
INSERT INTO omw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Iesusiva tiqaro, Iutaasio, qio e mwitaama kyera ni motenanra mwiaqove ni mwatani mwatatai nraaqiarara nramwutaahua suqaa qovarama kyenanrave? tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Iesusiva mwitaa tuvata mwia nraaqiaranramwu mwiavata varuhua taqovata mwihua Iesusira ntavaaqavu kyarerata uti varuvata mwinramwuhua Iesusirara tiqata, Nronrao, tire qiove paipaqo mwihua teqa kyaananrave? tita. ");
INSERT INTO omw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mwitaa timwa kyeta varuvaro mwinramwuhuaqitairo mpovanto Kotira kyaiqa vara mwate varu vaisihua mwihua vunyaa vaisi kyaiqa vaisi mpo kyaatutanyaa nraato teqa kyovaro tumu ntura. ");
INSERT INTO omw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tumu ntuvaro Iesusiva qaqao hia qaiqaavata mwitaa hiate tiro. Mwitaa timwa kyero mwi vaisira nraatoqa nai kyauquqo vatovaro qaiqaa naitarama vahura. ");
INSERT INTO omw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kotira kyaiqa vara mwate varu vaisihua mwihua nronranramwuvata, Kotira nraamwuqaa ntaqikyi varu pipohuavata, nronra vaisi mponramwuvata, mwihua Iesusira ntavaaqavu kyarera nruhuara Iesusiva tiqaro, Nkye kamaninravata ntaqi vaisira ntavaaqavu kyareratave paipavata kyaamwuvata vareta nriavo? ");
INSERT INTO omw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nte nkyivata mpo enta mpo enta Kotira nraamwuqi variqi vi varuqata nkye hia ni ntavaaqavu kyaarave. Qio mate mwaa entava nkyinima vaiho. Mate enta hi inraikyava kepukyaqama kyero ntaqikyi variho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Iesusiva mwitaa tuvata mwihua mwia ntavaaqavu kyeta vitaqita uro Kotira kyaiqa vare varuhua mwihua vunyaa vaisi nraamwuqi kyovaro Pitaava nyianrasata viqaro mwihua sataqiro vuva uro taqovata ");
INSERT INTO omw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","mwatukya utasata qia quara teta varuvaro Pitaavavata mwihua kyapata qia taare varura. ");
INSERT INTO omw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mwiaqaa varuvaro kyaiqa nraakye mpovanto taqovaro Pitaava qia taare varuvaro mwiva mwia aitutuma kyero taqero tiqaro, Mwaavavata Iesusikyantiri varivave, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pitaava qaqao tiro, Mwaa nraakyevao, nte hia mwia taqaurave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mwitaa timwa kyero mwini variqiro vuvaro qaiqaa vaisi mpovanto Pitaara taqero tiqaro, Evata mwia nraaqiaravanto variaro, tiro. Tuvaro Pitaava tiqaro, Mwaa vaisivao, hia nte mwivave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Timwa kyero hia mpuahaama varuvaro vaisi mpovanto qaiqaa kepukyaqama kyero tiqaro, Mwi vaisiva Karirinyaa vaisivantora tiro, mwikyantiri varivave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tuvaro Pitaava qaqao tiro, Mwaa vaisivao, e qiana quara nte hia ntapihi kyauqo, tiro. Mwitaa ti varuvaro qamwanrama kyero kokoraaravanto nruqua tura. ");
INSERT INTO omw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nruqua tuvaro nronravanto tuqasaa viro Pitaara vuqi taqovaro vaakya nronravanto Pitaarara tu quava mwia vu nraatoqi ntura. Vuni nronravanto tiqaro, E taarampo nani nianra mwia hia taqaurave tiraroma kokoraaravanto nruqua qiananrove, tura. ");
INSERT INTO omw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mwi quava Pitaara nraatoqi ntumwa vuvaro mwiva ntapihi kyero riero mwiaqaatairo mwaaqani mwaati ntovaro mwia mwutukyavanto uaqia huvaro nronraqama kyero ntatero. ");
INSERT INTO omw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mwitaa huvata Iesusira ntavaaqavu vaisihua Iesusirara raima mwateta Iesusira ntuqutiqata ");
INSERT INTO omw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Iesusiva hia taqaarive tita, mwihua tavuna vara kyeta vuvata qiatavata rupateta Iesusira ntuqutiqata mwia kyapara hita tiqata, Poropeti vaisi maavao, tavave i riho? Hia taqaraitira, tiraqeta riaare, timwa kyeta ");
INSERT INTO omw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","mwihua uaqia hu quara mpo qua mpo qua timwa mwate varura. ");
INSERT INTO omw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mwitaamaqita vuvaro qaatata vuvata Kotira kyaiqa vare varuhua mwihua nronranramwuvata, mwaanra okyara ti varuhuavata, mwihua ntuvaantuama vita Iesusira vita vareta nkyiari kaanasori varunani uro kyovata ");
INSERT INTO omw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","mwihua tiqata, Qutaaqama kyerave e Mesaiaavanto Kotiva titai vaisiva variaro? Tiri timwa timwinraqe riaare, tita. Mwihua mwitaa tuvaro Iesusiva tiqaro, Nte nkyi timwa nyianrita nkye hia ni quara qutaave tivarave. ");
INSERT INTO omw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nte nkyi kyapara hiarita nkye hia mpo qua ni timwa mpivarave. ");
INSERT INTO omw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Qio mwaa entaraqaataina nte mwatani mwatatai nraaqiarava variqana Kotiva kepukyavanto varinani uro mwia kyauqu kyaatutani mwatakyaa vina varirerave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Iesusiva mwitaa tuvata mwihua tiqata, Qio mwitaa hirera e Kotira mwaaquvantove variaro? tuvaro Iesusiva nkyiari timwa nyinro tiqaro, Nkye qiara nte mwaa mwivave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Iesusiva mwitaa tuvata mwihua tiqata, Qumina mwiaqaa qua vatehua nyaanraanronrave. Qaqira kyaare. Mwiama nai nroqitairo uaqia hi quara tihata riauro, tita. Tura. ");
INSERT INTO omw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mwitaa timwa kyeta ekyaa mwihua sivita Iesusira vita vareta Pairaativa varunani uro kyeta ");
INSERT INTO omw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Iesusiraqaa qua vateqata mwitaama tita, Tire taqauraro mwaa vaisiva nraakye qora uaqia hi aanranra nyaamwuteqaro mwihuara hia nronra vaisi vunyaanra Sisaara taakisi mwiate ti varirave. Mwiva nanrianra nte nronravanto nte nraakye qoraqaa ntaqikyiariva Mesaiaavanto varuqo ti variho, tita. ");
INSERT INTO omw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mwihua mwitaa tuvaro Pairaativa Iesusira kyapara hiro, Qutaave e Iutaa vunyaa vaisivanto variaro? tuvaro Iesusiva tiqaro, E qiananra nte mwaa mwivama iho, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pairaativa Kotira kyaiqa varohua mwihua nronranramwuanravata, nraakye qora ntuvaantuama vuhuaravata, tiqaro, Nte taqauqaro mwaa vaisiva hia kamaninra qua nteqa kyaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mwitaa tuvata mwihua nronraqama kyeta kepukya qua Iesusiraqa vateta tiqata, Nraakye qoravanto kamaninravata ntaquate tiro, mwiva antua qua timwa nyi varivave. Mwiva tohara kyero vevara Karirisairo mwi quara timwa nyiqiro nrinro mwaini nri ntaiho, tita. ");
INSERT INTO omw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mwihua mwitaa tuvaro Pairaativa mwi quara riero mwiva tiqaro, Qutaa mwaa vaisiva Karirinyaavave? tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Mwitaa timwa kyero mwiva ntapihi kyovaro Iesusiva Karirinyaava Herotiva mwi mwatanaahuaqaa ntaqikyunanyaava varuvaro mwiaqaatairo Pairaativa Iesusira titovata Herotiva varunani Iesusira vitaqita uro kyora. Mwi entara Herotiva Ierusaremini uro varura. ");
INSERT INTO omw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Iesusira Herotiva varunani uro kyovaro Herotiva qamwatero. Herotiva Iesusira kyaiqara rieqaro airi enta mwia taqarero variqaro Iesusiva ni puqaa variqaro nronra kyaiqa varairaqe taqarerave timwa kyero qamwata kyero ");
INSERT INTO omw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","uro Iesusira airi qua kyapara huvaro Iesusiva hia qua mpoqiavata nai timwa mwinraitiro varura. ");
INSERT INTO omw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kotira kyaiqa vare varuhua nronranramwuvata, mwaanra okyara ti varuhuavata, mwihua sivita uro kepukyaqama kyeta Iesusiraqaa qua vatovata ");
INSERT INTO omw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","mwiaqaatai Herotivavata, mwia ntaqu vaisihuavata, Iesusirara raima mwateta tiqata, E nronra vaisi variarava nronra vaisi tavuna utu taante, timwa kyeta tuavaaqa kyuqera utumwate ua qua timwa mwateta titovaro Pairaativa varunani nrumu ntantero vura. ");
INSERT INTO omw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Haaru Herotivavata Pairaativavata nramwutaatanavanto varurama. Mwi entaraqaataita mwitanahua totiqama vita kyuqema vi nanrianra nanrianra qamwateqatatana varura. ");
INSERT INTO omw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pairaativa Kotira kyaiqa vare varuhua mwihua nronranramwuvata, nronra vaisi mponramwuvata, qumina nraakye qoravata, nyaanrama ntuvaantuama kyero ");
INSERT INTO omw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","mwihua timwa nyinro tiqaro, Nkye mwaa vaisira vitaqita nte hunani nrumu kyeta tiqata, Mwaava nraakye qora uaqia hi aanranra nyaamwute variho, qiarave. Nkye mwitaa qiavana nte nkyi suqa variqana mwi quara avuqavu hiqana taqauqaro mwaa vaisiva hiama nkye uaqia hi kyaiqarara qiara utiho. ");
INSERT INTO omw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herotivavata mwitaa hiqaro taqero qati titaiharo nte hunani qaiqaa nriho. Riaate. Mwi vaisiva uaqia hi kyaiqara utuaninravauma tire mwia ru kyaararo qutu quananrove. ");
INSERT INTO omw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kyaiqe nte qiarita mwia kyaamwuqo ntuqutu kyeta vataivaro qati quarive, tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mpo ihi mpo ihi vekyahu nyato entaraqaa Pairaativa nraakye qorara rieqaro karavu vaisi kuaiqia qati huvantu kyovaro mwaatani vura. Pairaativa Iesusirara kyaamwuqo ntuqutu kye vateta titaivaro qati quarive tuvata ");
INSERT INTO omw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ekyaa ntuvaantuama vuhua qaqao tita, Mwia ru kyaante. Tiriara rieqarama Varavaasira huvantu kyairaro mwaatani quarive, tura. ");
INSERT INTO omw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Varavaasiva kamaninra vatama kyero mwi mwatukyaraqi ntaqura kyaaravata, vaisi ru kyora kyaaravata, karavu rupa kyovaro varuvaro ");
INSERT INTO omw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pairaativa Iesusira huvantu kyarero uti variqaro qaiqaa nraakye qora kyapara hiro. ");
INSERT INTO omw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kyapara huvata mwihua hia mwia qua riaraitita, nronraqama kye aakyara nteta tiqata, Mwia kyatariqaa rutaante. Mwia kyatariqaa rutaante, tita. ");
INSERT INTO omw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mwihua mwitaa tuvaro Pairaativa taarampo nani kyapara hiro tiqaro, Mwaa vaisiva nanra quave nteqa kyaiho? Nanra uaqia hi kyaiqarave utiho? Nte mwia qua avuqavu hiqana taqauqaro hia mwiaqa qua vaiho. Hia tire qumina quaqaara vaisi mpo ru kyaananrave. Kyai nte qiarita mwia kyaamwuqo ntuqutu kye vataivaro qati quarive, tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mwitaa tuvata mwihua kepukyaqama kyeta aakyara ntamwaqi viqata kyatariqaa rutaante nraahu tita. Mwitaa tiqatama Pairaatira quavata rukyeta mwihua quavanto nraahu kepukyaqa huvaro ");
INSERT INTO omw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pairaativa mwihua qua nraahu riero qiove tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mwitaa timwa kyero mwihuara rieqaro mwiva kamaninravata ntaqura kyaaravata, vaisi ru kyora kyaaravata, karavuqi kyo vaisira huvantu kyero, mwiaqaatairo nraakye qora kyakya hurara rieqaro naivanto Iesusira ntaqu vaisihua sita kyero nyinro. ");
INSERT INTO omw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Iesusira nyuvata mwihua Iesusira vite viqatama aanraqaa vaisi mpo mwia nrutu Saimoniva mwiva Sairininyaava mwiva tokyasairo mwatukya nronra mwiqiara vuvata mwia qintorama kye vuaviraavira tita mwianra tiqata, Iesusiva qu tai kyatarira vara quqira mwia nraakiara virava uro mwataante, tita. ");
INSERT INTO omw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mwitaa huvata nraakye qora airivanto mwia vataqita vurama. Mwihua utaqitaita nraakye mponramwuvanto Iesusirara ti atura ntiqata ntataqita vuvaro ");
INSERT INTO omw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iesusiva mwihua hunani tuqasaa viro timwa nyinro tiqaro, Ierusaremiqinaa nraakye tuaavo, Hia nianra ntataate. Nkyetaravata nkyeta nraaqiararavata ntataate. ");
INSERT INTO omw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","30","Mpo entanramwu nri ntairata mwi entaraqaa nraakye qoravanto tiqata, Ehaara nraakye hia nraaqiara mwatehuave hia nraaqiara nraamwa nyihuave, qora tatari taaqiara tiqata, Tiriqaa nteqeta tumu ntumwaqu kyaate, tivarave. Mwihua pata taaqiara tiqata, Tiriqaa tumu ntita ntumwaqu kyaate, tivarave. ");
INSERT INTO omw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nte kyatari karaaha votima kyena varuqata mwihua mwitaama kyeqata ni uaqiama mate variavo. Nkye kyatari aahara votima kyeta variavata po, nraakiara mwihua nkyi nataa nataama kyetave nkyi uaqiama nyatevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mwitaa tuvata mwihua karavu vaisi taaratanavata Iesusiravata rirerata siteta vurama. ");
INSERT INTO omw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mwihua vuhua qumina mwatukya mwi mwatukyara nrutu Qiata Mwukyaarive tu mwatukyaraqaa uro nteta Iesusira kyatariqaa ninriqotai ruteta mwata quvu kyeta mwiqi mwaamwi utaqaa rateta hini hini uaqia hu vaisihua mwitana rutora. ");
INSERT INTO omw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Rutovaro Iesusiva Kotirara aakyara ntero tiqaro, Ko, hia mwihua uaqia hi kyaiqara utuarara riaante. Mwihua mwitaa hiqata hia mwia utuara mwia okyara ntapihiavo, tiro. Mwitaa tuvata mwihua kaati ruantema kye ori tuto kyeqata Iesusira tuavaaqa ntainra kyeta varora. ");
INSERT INTO omw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mwia tuavaaqa ntainra kyeta varovata qumina nraakye qora mwini sivita variqa taqe varuvata Iutaa vaisi nronranramwuvanto Iesusirara raima mwateta tiqata, Mwiva airi vaisi kyaahaqa hi varivave. Kotiva mwia titaiharo mwiva Mesaiaavanto varirera, mwiva qioma nai kyaahaqa hiananrove, tita. ");
INSERT INTO omw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mwihua mwitaa tuvata ntaqu vaisihuavata Iesusirara raima mwateta uro uaini uka vura mwita nraante timwa kyeta mwianra tiqata, ");
INSERT INTO omw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","E qutaa Iutaaqa ntaqikyirava hirera, e ena kyaahaqa hiante, tura. ");
INSERT INTO omw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mwihua qua mpo Iesusira qiatani kyatariqaa qara ntumwa kyeta vatova mwitaama tiro: MWAA VAISIVA IUTAA VUNYAA VAISIVE, tura. ");
INSERT INTO omw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Uaqia hu vaisiva mpovanto hini rutova mwivavata Iesusirara qora qua tiro tiqaro, Qutaave e Mesaiaavanto variaro? Qio mwitaa hirera, enavata tiritanavata kyaahaqa hiante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mwitaa tuvaro uaqia hu vaisiva mpovanto hiniqaa rutova eqaante tiro, Hiave e Kotirara aatu hiaro? Mwihua tiritana votima kyeta mwiavata rutaavo. ");
INSERT INTO omw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mwihua tiritana qio rutaavo. Titatana uaqia hi kyaiqara kyaara tiritana rutaavo. Mwi vaisiva hia uaqia hi kyaiqara utivave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mwitaa timwa kyero mwiva Iesusirara tiqaro, Iesusio, i nronraqama kyaani entara nianravata riaante, tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mwitaa tuvaro Iesusiva tiqaro, Nte i timwa mwianinra riaante. Mate e mwatukya kyuqeraqi ni vatama kyera varinanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mwitaa tuvaro huari nrinro qiataqa vahuvaro mwiaqaatairo upima vuvaro hia huari itovaro kyokira nraahu rutovaro huari tumiviro 3 kirokiqa huvaro qaiqaa ntuvaahama vura. ");
INSERT INTO omw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ierusaremini Kotira nraamwuqi tavuna tauha votima kye hiritova utaqaa nai nrahitu vuvaro ");
INSERT INTO omw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iesusiva kyatariqaa variqaro paatiro aakyara ntero tiqaro, Ko, ni manraqura tu varaante, tiro. Mwitaa timwa kyero mwiva qutu vura. ");
INSERT INTO omw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Iesusiva qutu vuvaro ntaqu vaisihua qiata vaisivanto Iesusiva mwitaa hura taqero Kotira nrutu tuaaherero tiqaro, Qutaama mwaa vaisiva avuqavu nrohi vari vaisivave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mwitaa tuvata mpo uhua mwi inraikyava qovara hura taqarerata ntuvaantuama vuhua, mwihua variqata mwi inraikyara taqeta, mwiaqaataita mwihua nkyiari mwaatani nrumu ntanteta viqata mwutukya uaqia huvata nkyiari mwekuraata/mwetokya ntuqutu kyeqata vurama. ");
INSERT INTO omw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mwihua vuvata Iesusira vataqi nrohu nraakye qorahuavata, nraakye mponramwu Karirisaita mwia vataqita nruhuavata, mwihua nyianra sata variqata mwi inraikyava qovara hura taqe varura. ");
INSERT INTO omw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Vaisi mpovanto mwia nrutu Iosepiva Arimatia mwatukya Iutianyaava, mwiva vaisi kyuqeva avuqavuma kyero nrohi varu vaisiva, mwiva Kotiva ntaqikyiani entarara taqeqaro mwia vekya varura. Mwiva kaanasorivanto variqaro mwiva hia mpo kaanasorivanto tu quarara eo tiraitiro, mwihua kyaiqaravata hia qamwateqaro varura. ");
INSERT INTO omw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mwi vaisiva Pairaativa varunani uro ntero tiqaro, Iesusira mwamwanta mpiraqe varaqina quntaankye, tiro. ");
INSERT INTO omw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mwitaa timwa kyero mwiva uro Iesusira mwamwanta itu kyero vara mwatumwi vatero eqarori tavuna vara kyero mwia qapuqama kyero uto ori qaraakya vauru kye hia vaisi mpo quntoraqi uro quntamwa tora. ");
INSERT INTO omw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mwi entara nraakye qoravanto hura Saarareqa tiri mwaanra enta mwi entara kyaiqa varaarorave timwa kyeqata mwi entarara rieqata mpo inraikya mpo inraikya tera taarama kye vate varu entava vahura. ");
INSERT INTO omw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mwitaa huvata nraakye mponramwuvanto tauraa Karirisaita Iesusira vataqita nrohi varu nraakyehua Iosepiravata uro Iesusira quntarera huraqi vuhua uro taqovaro Iosepiva Iesusira mwamwanta vatovata mwihua taqeta ");
INSERT INTO omw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","mwiaqaatai nrumu ntante nkyiari nraamwuqi uro variqata vahamwenra kyuqema kyero mwunta vuravata, mpo inraikya mwia mwamwantaqaa qumwa teravata, tera hura. Mwihua nkyiari mwaanra qua rieqata Saarareqaa qati varura. ");
INSERT INTO omw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nraakye mwihua kyuqema kyero mwuntavi varu inraikyara terama kye vateta mwihua Saarareqa vari kyeta Saanteqa vaakya toqa entaqi sivita mwi inraikyara vareta Iesusira quntamwa toraqi vuhua uro taqovaro ");
INSERT INTO omw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","qesaqaa ori nronra tita tora ventaqita uro tokyani vatova vahura. ");
INSERT INTO omw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Vahuvata mwihua oriqi vera nte taqovaro nronra vaisi Iesusira mwamwanta hia vahura. ");
INSERT INTO omw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hia mwiqi vahuvata mwihua mwiqi qati apiqama vita airi nraato ti varuvata qamwanrama vaisi taaratana qovarama vita takyuqu tuavaaqara ututeta mwihua nraaqani sivita varura. ");
INSERT INTO omw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Varuvata nraakye mwinramwuhua nronraqama kye aatu hita nkyiari siri mwataqi vateta varuvata vaisi mwitanahua tiqata, Nanraqamave nkye qati vari vaisirara qutu quahua mwaataqi puaa hi variavo? ");
INSERT INTO omw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mwiva hia mwaini variho. Mwiva qati siviho. Tauraa mwiva Karirini variqaro nkyi timwa nyu quara nkye qative riemwa taavo? ");
INSERT INTO omw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mwiva mwi entara tiqaro, Nte mwatani mwatatai nraaqiarava variarita uaqia hi vaisihua ni ntavaaqavu kyaate tiro, ni qovarama kyairata mwihua ni pitaqita kyatariqaa ru taivaqena nte taarampo enta varina qaiqaa qati siquaninrave tirave, tita. ");
INSERT INTO omw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mwitanahua mwitaa tuvata nraakye mwinramwuhua nyaatoqi Iesusiva tu quava ntuvata ");
INSERT INTO omw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","mwia quntamwato mwatara mwini kyeta nrumu ntante uro Iesusira nraaqiara 11 nramwuvata mpo huhuavata timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nraakye mwinramwuhua nyutu vahirero Mariaava Makataranyaava, Iohaanaava, Iemisira nrova Mariaava, mwinramwuhua mwi inraikyara taqeta uro Iesusira nraaqiaranramwu timwa nyuvata ");
INSERT INTO omw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","mwihua tiqata, Qaqao, nkye unrama qiavo. Hia mwianra qutaave qiananrave, tita. ");
INSERT INTO omw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mwitaa tuvaro Pitaava siviro hiantero mwia quntamwa toraqi vuva uro kakataama viro vera taqovaro tavuna nraahu vahuvaro Iesusira mwamwanta hia vahura. Hia vahuvaro mwiva nrumu ntantero uro mwaatani variqaro nai uro taqo inraikyarara airi nraato tiqaro varura. ");
INSERT INTO omw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kuaa mwi entaraqaa Iesusira nraaqiara taaratanavanto mwatukya mpo Emeasinianra vura. (Kyuvaira vaiharo Omwunra vahira mwia votima Ierusaremi vahuvaro Emeasi mwatukya vahura.) ");
INSERT INTO omw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mwitanahua aanraqaa mwinianra viqata Iesusira ru kyo quara timwaqita vita. ");
INSERT INTO omw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mwitanahua timwaqi vuvaro Iesusiva nai nri ntero mwitanahua vatama kyero vuvata ");
INSERT INTO omw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","mwitanahua mwia taqeta hia mwia ntapihi taqaraitita, mpo vaisivantove tuvaro ");
INSERT INTO omw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesusiva mwitanahuara tiqaro, Nkyetana aanrani nriqatama nanra quave timwaqita nriavo? tiro. Mwitaa tuvata mwitana uro mwiaqa ra kyeta mwitana mwutukyavanto uaqia huvatatana ");
INSERT INTO omw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","mpovanto Kiropaasirave tuva Iesusira kyapara hiro tiqaro, Mate airivanto Ierusaremiqi variaraqitaira e kuaikuvantove enta nanau qovara hi quara hia riaaro? tiro. ");
INSERT INTO omw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mwitaa tuvaro Iesusiva tiqaro, Nanra quave? tuvata mwitanahua tiqata, Iesusira Nasaretinyaanra quave. Mwi vaisiva poropeti vaisivanto variqaro Kotira vuqaavata, nraakye qora suqaavata, nronra kyaiqa vareqaro kyuqe qua nraahu tirave. ");
INSERT INTO omw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mwiva mwitaa hi varihata Kotira kyaiqa vara mwate varia vaisihua mwihua nronra vaisinramwuvata, tiriqaa ntaqikyi variahuavata, mwihua kamaninra mwiavaro mwiva mwia rukyaate tihata mwia ninriqotaita kyatariqa rutaavo. ");
INSERT INTO omw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tire tauraa mwi vaisirara Kotiva mwia titaiharo mwiva mpo mwatanaahua nraatara kyero tiri Isareriqaa ntaqikyiarivave tunanrave. Qua mpovatama vaiho. Mwia rukyaavaro mate taarampo enta nritaraiho. ");
INSERT INTO omw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mate tiretana nraakyenramwuvanto qia quara rieta nrihanramama vuro. Mwinramwuhua vaakya toqaqi mwia quntamwa taaraqi uro nteta hia mwia mwamwanta taqaavo. ");
INSERT INTO omw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mwinramwuhua uro ntanteta nrumu tiri timwa timwita tiqata, Nyaamwunyaahua tirinramwuanra mwiva qatima variho qiavo, qiarave. ");
INSERT INTO omw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nraakyenramwuvanto mwitaa qiavata tirinramwuqitaita mpo hiahua mwia quntamwa taaraqi quahua uro taqaavaro nraakyenramwuvanto qia quava qutaa vaihata mwinramwuhuavata mwia mwamwanta hia taqaarave, tita. ");
INSERT INTO omw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mwitana mwitaa tuvaro Iesusiva mwitanahua timwa nyinro tiqaro, Hiave nkyitana su nyaato vaiho? Haaru poropeti vaisinramwuvanto timwa to quara, mwianra nkyetana qamwanrama kye qutaave qiataara vaihata nkyetana qakyoma kyaavo. ");
INSERT INTO omw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nkyetana hia ntapihiarave iho? Kotiva titaari vaisiva Mesaiaavanto nriqa vi inraikyara varaqiro viro mwiaqaatairo nronraqama viro kepukya vaisivanto variananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mwitaa timwa kyero Iesusiva Mesaiaara Kotira mpukuqi qara ntumwa to quara mwitana timwa nyinrenro tohareqaro Mosesira mpukuqitairo timwa nyiqiro viro, poropetinramwu mpukuqitairovata timwa nyiqiro vura. ");
INSERT INTO omw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mwitaa timwaqi vi varuvaro mwitanahua virera tu mwatukyava qaumato vahuvaro Iesusiva rieqarovata aanra mwiaqaa qati nraahu vi varuvata ");
INSERT INTO omw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","mwitanahua hiave tita, Mateqama enta hiananrove. Qaqira kyera tiritanavata vaitaante, tuvaro mwihuavata varirero nraamwuqi vura. ");
INSERT INTO omw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iesusiva nraamwu mwiqi variqaro kyara taintaqaa mwitana vatama kyero mwatakyaa viro Kotirara kyuqeve timwa kyero mpereti nteqa kyero tukyama kyero nyuvata ");
INSERT INTO omw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","mwitana su ntapairi vuvata ntapihi rieta mwitana mwia ntapihi taqeta. Mwitana mwia ntapihi kyeta taqovaro Iesusiva mwitana suqaatairo uvaarama vura. ");
INSERT INTO omw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iesusiva uvaarama vuvata mwitana nai timwa mwi nai timwa mwi hita tiqata, Qikye, mwiva aanraqaa nriqanro Kotira mpukuqinaara qua okyara ntapihi kyero tiritana timwa timwiharo qutaa tiritana mwutukyaqitairo kyuqe hirave, tita. ");
INSERT INTO omw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mwitaa timwa kyeta mwitanahua qamwanrama sivitatana nrumu ntanteta Ierusaremini uro Iesusira nraaqiara 11 nramwu puaama kyeta taqovata mwinramwuhua mpo vaisinramwu kyapata ntuvaantuama vita varita tiqata, ");
INSERT INTO omw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nronravanto qutaama qaiqaa qati siviho. Saimoniva mwivama mwia taqaiho, tuvata ");
INSERT INTO omw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","mwitanavata aanrani vita taqorara mwihua timwa nyita. Mwitanahua tiqata, Mwiva mpereti nteqa kyaihata mwiaqaataita tiretana nronra vaisi ntapihi taqauro, tita. ");
INSERT INTO omw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mwitana qua mwihua timwa nyi varuvaro mate mwiqiara nronravanto nai qovarama viro mwihua nraaqani siviro variro tiqaro, Nkyi mwutukyavanto qihaakyama vahiarive, tiro. ");
INSERT INTO omw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mwitaa tuvata mwihua nronraqama kyeta aatu hita tiqata, Vaanavanto qovarama viho, tuvaro ");
INSERT INTO omw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Iesusiva mwihuara tiqaro, Nkye nanraqamave aatu hiavaro taara vu nraato tuava nkyi su nyaatoqi vaiho? ");
INSERT INTO omw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ni kyuqu kyauqu taqaate. Nte mwivama huqo. Ni mamantaqa tiqata taqaate. Nte vaisima varuqo. Vaana mwia hia ni votima kyero mwativata mwukyaarivata vahirave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mwitaa timwa kyero mwiva nai kyuquvata kyauquvata nyaamwutovata ");
INSERT INTO omw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","mwihua mpoqama kyeta qamwateta kyauqu ntukikinraaqateta hia qamwanrama qutaave tuvaro Iesusiva mwihua kyapara hiro tiqaro, Kyara nraanriva vahirove? tuvata ");
INSERT INTO omw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","mwihua tavukya uta tora pataqia mwuvaro ");
INSERT INTO omw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","mwiva mwihua suqaa variqaro vara kyero nronra. ");
INSERT INTO omw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iesusiva tavukya nramwa kyero mwihua timwa nyinro tiqaro, Tauraa nte nkyivata variqana nte mwaa quara nkyi timwa nyiavarave. Nianra haaru Mosesiva mpukuqi qara ntumwa to quarave, poropeti vaisinramwuvanto qara ntumwa to quarave, Saami mpukuqi qara ntumwa to quarave, nte nkyi timwa nyiqana mwi quara mwivauma vahiananrove qiavarave, tiro. ");
INSERT INTO omw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mwitaa timwa kyero mwihua Kotira mpukuqi qara ntumwa to quara ntapihi kyeta riaate tiro, Iesusiva mwi quara mwi quara mwihua timwa nyinro tiqaro, ");
INSERT INTO omw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mwaa quara qara ntumwa torave. Mesaiaarara mwiva nriqa quani inraikyara varero uro qutu viro taarampo enta variro qaiqaa qati siquananrove. ");
INSERT INTO omw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mwiaqaataita nkye ni kyaiqara ni nutuara rieqatama nraakye qora timwa nyiqi viqata uaqia hi aanranra qaqira kyaivaro Kotiva nkye uaqia hi kyaiqara uti quara nruka nyataarive qiate. Mwi quara timwa nyiqi viqata Ierusaremini nraante mwi quara timwa nyiqi vita mwiaqaataita mpo mwatanaa mpo mwatanaa timwa nyiqi quate. ");
INSERT INTO omw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nkyenramwu nkyeta suqotaita mwi kyaiqaravata mwi inraikyaravata taqaarave. ");
INSERT INTO omw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ni kova nai kyauqu nriqiqaa vatero ntena nkyi nyinrenrave qianinra ntema mwia titaariro tumuananrove. Nkye mwaa mwatukyaraqi variqi vivaro nyaamwusairo mwiva tuminro nkyiqi variqaroma nkyi kepukyaqama nyataananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iesusiva mwitaa timwa kyero mwiva mwihua sita varero Ierusaremi kyero Mpetaanini uro ntero nai kyauqutana tuaahera kyero mwihua kyuqema nyatero. ");
INSERT INTO omw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mwiva mwihua kyuqema nyate varuvaro Kotiva mwia nyaamwuni vitero vuvaro mwiva nai nraaqiara mwihua kyero vura. ");
INSERT INTO omw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Iesusiva nyaamwuni vuvata mwia nraaqiaranramwuvanto mwia nrutu tuaahera kyeta nrumu ntanteta Ierusaremini vura. ");
INSERT INTO omw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mwini uro variqata Kotira nraamwuqi mpo enta mpo enta Kotira nrutu tuaaheraqita vi varura. ");
INSERT INTO omw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Haaru toharero quavanto varura. Mwi quava Kotikyantiri varura. Mwi quava nai Kotiva varura. ");
INSERT INTO omw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tauraa toharero mwi quava Kotikyantiri variqiro vura. ");
INSERT INTO omw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mwiva Kotikyantiri variqi viqaro mpo inraikya mpo inraikya ekyaa inraikya utu kyero vatora. Mpovantovata mpo inraikya utuariva hia varuvaro qua mwiva nraahu ekyaa inraikya utu kyero vatora. ");
INSERT INTO omw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mwi quava qati variqi vi variara tuqavantoma variro. Mwi quava omwa votima kyero itamwaqiro viqaroma nraakye qora kyuqema kyero ntuvaahama nyatero. ");
INSERT INTO omw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Omwavanto upi hiraqi itamwaqiro viharo hiama enta hi inraikyava mwia qipa kyaariva vahiro. ");
INSERT INTO omw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kotiva vaisi mpo titora mwia nrutu Ioniva. ");
INSERT INTO omw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nraakye qoravanto Iesusirara mwiva qutaa omwavantove qiate tiro, Ioniva mwianra timwa nyinrenro nri ntora. ");
INSERT INTO omw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ioniva nai hia mwi omwava variraitiro, mwiva omwa mwianra timwa nyinrenro nrunra. ");
INSERT INTO omw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mwiva nri ntovaro mwia nraakiara quavanto nri ntero omwa votima kyero itamwaqiro viqaroma ekyaa mwaa mwataraqaa nraakye qora ntuvaahama nyatero. ");
INSERT INTO omw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iesusiva nai mwaa mwatara utu kyero vatova mwatani tumuvata mwaa mwatanaahua hia mwia ntapihi kye taqaraitita, mwianra hia mwivave tita. ");
INSERT INTO omw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mwiva nai nramwunaahua hunani nri ntovata mwia nramwunaahua hia mwia kyakyama mwataraitita, mwia qoririma mwatora. ");
INSERT INTO omw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mwitaahuvatavata mpo uhua mwia kyakyama mwateta mwianra qutaa mwivave tura. Mwitaa tuhua mwihua mwiva nronraqama kyovata mwihua Kotira nraaqiaraqama vita varura. ");
INSERT INTO omw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Hia nraakyevanto nraaqiara mwataintema kyero mwihua mwata taihata Kotira nraaqiaraqama vita variara. Hia qumina vaisi kyakya hiraqa Kotira nraaqiaraqama vita variara. Nai Kotira kyakya hiraqa mwihua Kotira nraaqiaraqama vita variara. ");
INSERT INTO omw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kotira quavanto vaisi tuero tirivata varirero tuminro. Mwiva tuminro mwaa mwataraqaa varuvata tire mwia peqa okyara taqaavananra. Tire taqaavararo mwi vaisiva kyuqe hiro vaisiara mpoqama kyero po kye timwa nyateqaro qutaa qua nraahu ti varuva varura. ");
INSERT INTO omw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioniva nraakye qora timwa nyinro tiqaro, Nte haaru nkyi timwa nyina tiqana, Vaisi mpovanto ni naakiara nrianriva ni naataraananrove, tuva qio mwaa mwi vaisivave. Nte hia qovara hiava entara mwiva haaru qati variqiro vurave. Mwitaama variqarora tiro, mwi vaisiva ni naatara kyero mwiva nronravanto variho, tiro. Ioniva mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iesusiva mpoqama kyero tiriara nraamwunruqa taiharo mwiva tiriara po kye timwa timwatero airi nani tiri kyuqema timwate varira. ");
INSERT INTO omw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Haaru Kotiva nai qua mwaanra nraakye qoravanto hia nteqa kyaraitita, qati nraahu riemwaqita quate tiro, Mosesira mwunra. Mate mwaa entara Iesusi Karaisiva Kotiva hinasairo tumu Kotiva po kye timwa timwatai okyarara, qutaa okyara tiri timwinra. ");
INSERT INTO omw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hia qumina vaisi mpovanto Kotira taqairave. Mwia mwaaquvanto nai qora nraaqani variva, mwiva nraahu nai qora okyara qovarama kyaihata tire taqeta ntapihunanra. ");
INSERT INTO omw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ioniva Iesusirara timwa nyu quava mwataamama vahiro. Ioniva nri ntovata Iutaa vaisi nronranramwuvanto Ierusaremini varuhua vaisi mponramwu sitovata Kotira nraamwuqi Kotira kyaiqa vara mwate varuhuavata, Rivaira kuaa okyara mponramwuvantovata, mwihua uro nteta Ioninra kyapara hita tiqata, E ta vaisivave? (E qutaa tiri mesaiaavantove variaro?) tita. ");
INSERT INTO omw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mwihua mwitaa tuvaro Ioniva hia qua tuqetaraitiro, vutu kyero timwa nyinro tiqaro, Qaqao, hia nte Kotiva titai vaisiva mesaiaavanto varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tuvata mwihua mwia qaiqaa kyapara hita tiqata, E hia mwivave tiqara, e mpo tavave hiaro? E tiri haivaqava, Iraisaavave variaro? tita. Tuvaro Ioniva qaqao, Nte hia mwivave, tiro. Tuvata mwihua qaiqaa mwia kyapara hita tiqata, E ta vaisivave? Tire poropeti vaisi mpo mwia vekyama varuro. E mwivave hiaro? tuvaro Ioniva qaqao nraahu tiro. ");
INSERT INTO omw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mwitaa tuvata mwihua tiqata, E tavave hiaro? Timwa timwinraqe tire nrumu ntanteta tiri titaa vaisihua iara uro timwa nyianre. E enanra tavaveve tira hiaro? tita. ");
INSERT INTO omw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mwihua mwitaa tuvaro Ioniva timwa nyinro tiqaro, Nte qumina sata variqana aakyara ntena tiqana, Aanra ntapihi taivaro nronravanto nrianrive, ti varuvama varuqo, tiro. Haaru poropeti vaisi Aisaiaava tu quara Ionivavata tura. ");
INSERT INTO omw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ioniva mwitaa tuvata Parisi vaisinramwuvanto sitohua tiqata, ");
INSERT INTO omw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","E tiriara nte hia mesaiaavanto varuqo qiaro. Hia nte Iraisaavave qiaro. Hia nte poropeti mwivave qiaro. Qio nanraqamave qumina vaisi varuqo qiarava nramanri nyi variaro? tita. ");
INSERT INTO omw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tuvaro Ioniva mwinramwuhua timwa nyinro tiqaro, Nte qumina nramanri nraahuma nraakye qora nyi varuqo. Mpovanto nkyi utaqaa varira nkye hia mwia taqaarave. ");
INSERT INTO omw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mwiva ni naakiara nrivave. Nte pata vaisi varuqaro mwiva nronra vaisi varihananra tina, nte hiama qio mwiva kyuqu nraamwu rupa tai kyaantara huvantu mwataaninrave, tura. ");
INSERT INTO omw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ioniva Mpetaani mwaata Iotaani nramanri qarahi hini variqaro nramanri nyi varu entara mwi quara tura. ");
INSERT INTO omw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mwia qanranraa Ioniva variqaro taqovaro Iesusiva mwisairo nri varuvaro mwiva tiqaro, Qio taqaate. Mwiva Kotira sipisipi nraative. Mwiaqaama Kotiva mwatani varihua uaqia hi kyaiqara utira taiqa nyataananrove. ");
INSERT INTO omw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nte haaru tiqana, Vaisi mpovanto ni naakiara nrianriva ni naataraananrove. Nte hia qovara hiava entara mwiva haaru qati variqiro vuvave. Mwitaama variqarora tiro, mwiva ni naatara kyero nronravanto variananrove, tu vaisiva, mwaa mwivave. ");
INSERT INTO omw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tauraa hia nte mwia ntapihi taqaurave. Nkye Isareri nraakye qoravanto mwia ntapihi kye taqaate tina, nte mwaini nrumu variqana nramanri nkyi nyi varurave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mwitaa timwa kyero Ioniva Iesusirara mwihua vutukye timwa nyinro tiqaro, Nte taqauqaro Kotira mwanraquravanto minrunra voti hiva hitamwaqiro tuminro tumu mwiaqaa varirave. ");
INSERT INTO omw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tauraa nte hia Iesusira ntapihi taqe varuqaro Kotiva ni titaihana nte nramanri nkyi nyi varuqaro Kotiva ni timwa mpiro tiqaro, E taqairaro ni mwanraquravanto quariva uto mwiaqaa variani vaisira qio mwianra mwivave qiante. Mwiva hia qati nramanri nyiananrove. Mwiva nraakye qora ni mwanraqura nyianrivave, tirave. ");
INSERT INTO omw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kotiva ni mwi quara timwa mpihana nte mwi inraikyara kyuqema kyena taqena nte mwianra mwaavama Kotira mwaaquve tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mwia qanranraa Ioniva nai nraaqiara taaratana mwia vataqita nrohutanavata siviro varuvaro ");
INSERT INTO omw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iesusiva nritarero vuvaro Ioniva mwia vutu taqero, mwitana timwa nyinro tiqaro, Taqaate. Mwiva Kotira sipisipi nraative, tiro. ");
INSERT INTO omw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mwitaa tuvata Ioninra vataqita nrohutana Ioniva tu quara rieta, mwiaqaatai tuqasaa vita Ioninra mwini kyeta Iesusira vataqita vura. ");
INSERT INTO omw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Vuvaro Iesusiva tuqasaa viro taqovata mwitana mwia vataqita nruvaro mwiva tiqaro, Nkyetana naanrave nriavo? tuvata mwitanahua tiqata, Rapai. mwaanra ti variara vaisio, e taraqi variaravave? tuvaro ");
INSERT INTO omw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iesusiva tiqaro, Qio nrita taqaate, tiro. Mwitaa tuvata mwitanahua mwia vatama kyeta uro mwiva varuraqi varita. Mwitanahua Iesusira vatama kyeta variqi vita enrovata nrumu ntanteta vura. ");
INSERT INTO omw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mwitanahua Ioniva Iesusirara tu quara rieta Iesusira vataqi vuraqitairo mpo Enturuva, Saimoni Pitaara qatavanto varura. ");
INSERT INTO omw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mwitana Iesusira mwini kyetatana Enturuva nai vakyaara puaama kyero mwia timwa mwinro tiqaro, Tiretana, Kotiva titai vaisira, mesaiaa mwia puaama kyauro, tiro. (Mesaiaave, Karaisivave, kuaa nrutuma vahiro.) ");
INSERT INTO omw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Mwi vaisira puaama kyeta taqauro, timwa kyero Enturuva nai vakyaara vita varero Iesusiva hunani uro kyovaro Iesusiva mwia taqero tiqaro, E Ioninra mwaaqu Saimonivave. Nte qaraakya nrutu nteqana iara Sipaasirave tirerave, tiro. Sipaasirave, Pitaarave, kuaa nrutuma vahiro. (Mwaa quaraqitai mwi nrutura tirerata Orivave tita.) ");
INSERT INTO omw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mwia qanranraa Iesusiva Karirini virerave timwa kyero, uro Piripira puaama kyero mwianra tiqaro, Ni naakiara nriante, tiro. ");
INSERT INTO omw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Piripiva Vetasaitanyaavama variro. Enturukya Pitaakyavata kuaa mwatukya mwiqinaahua varura. ");
INSERT INTO omw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Iesusiva Piripirara ni pataqira nriante tuvaro Piripiva Nataanierira puaama kyero mwia timwa mwinro tiqaro, Haaru tiri haivaqava Mosesiva mwaanra qua qara ntiqaro mwi vaisirara timwatovata, poropeti vaisinramwuvata, mwi vaisiva nraakiara qovara hiananrove timwa kyeta qara ntumwato vaisira, qio mate mwi vaisirama taqauqo. Mwiva Iesusiva Iosepira mwaaquvanto Nasaretiqinaavave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tuvaro Nataanieriva tiqaro, Qaqao, qiove kyuqe vaisivanto mwi mwatukyaraqitairo qovara hiananrove? tiro. Tuvaro Piripiva tiqaro, Enavanto nrumu taqaante, tiro. ");
INSERT INTO omw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mwitaa timwa kyero vuvaro Iesusiva taqovata mwitanahua nri varuvaro tiqaro, Taqaante. Qutaama mwi vaisiva Isareri vaisivanto variho. Hia mwi vaisiraqi unra qua vahivave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mwitaa tuvaro Nataanieriva Iesusira kyapara hiro tiqaro, Nataama kyerave e ni okyara ntapihira hiaro? tuvaro Iesusiva tiqaro, Piripiva hia i uro nraanrai vakya e fiki okyarani variarana nte i taqaurave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mwitaa tuvaro Nataanieriva tiqaro, Mwaanra ti variara vaisio, e Kotira mwaaquve. E Isareriqaa ntaqikyiravave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mwitaa tuvaro Iesusiva tiqaro, E fiki okyarani variarana nte i taqaurave, turaqaatairave nianra qutaa mwivave qiaro? Nraakiara nronra inraikya, mpo inraikya mpo inraikya mwia nraataraaninrama taqenanrave. ");
INSERT INTO omw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","E qutaama taqairaro nyaamwuvanto qatua viraqe nte mwatani mwatatai nraaqiarava variarita niqaanra nyaamwunyaahua vita tumita hi varivaqe varianinrave, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Taara enta nritarovata mwatukya mpo Kenaa, Karirini mwi mwatanaahua nraakye ntumwinrenra hura. ");
INSERT INTO omw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mwitaa huvaro Iesusira nrovavata mwini varuvata mwi mwatanaahua Iesusiravata, mwia nraaqiaranramwuvata, nyaanrovata mwinramwuhuavata mwini vita. ");
INSERT INTO omw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mwinramwuhua uro variqata kyara nre varuvaro uainivanto taiqa vuvaro Iesusira nrova Iesusira timwa mwinro tiqaro, Uaini taiqama viho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tuvaro Iesusiva qaqao tiro, Mwaa nraakyevao, i kyaiqa mpo kyaiqa vaiharo ni kyaiqa mpo kyaiqama vaiho. Nte kyaiqa varaani entava hiama nri ntaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mwitaa tuvaro Iesusira nrova mwi mwatanaahua kyaiqa vaisinramwu timwa nyinro tiqaro, Mwiva nanra quave nkyiara tirata mwiva qiarinte qiarinte hiate, tiro. ");
INSERT INTO omw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Iutaavanto nkyiari mwaanra qua rieqata mwitaa mwitaama kyeqata nkyiari mwamwanta hiqama kyora. Qio mwianra rieqaro nramanri taqu 6 nramwu nronra tave voti huva mwi nraamwunraqi vatovaro vahura. (Tave nronra kuaa mwiqi qioma nramanri taqu qataara 10 vanto quananro.) ");
INSERT INTO omw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Vahuvaro Iesusiva kyaiqa vaisinramwu timwa nyinro tiqaro, Ekyaa mwi taqura qati nramanriqotaita piqa kyaate, tuvata qati nramanri kyaqaqita uro tave nronra mwinramwunra piqa kyovaro vaiqaara hura. ");
INSERT INTO omw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Piqa kyovaro Iesusiva qaiqaa tiqaro, Qio mwiqitai kyaqaqita uro kyaraqaa ntaqikyira mwivaro nreqanro taqaarive, tiro. ");
INSERT INTO omw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mwitaa tuvata mwiqitai mwi nramanrinra kyaqaqita uro mwuvaro mwi vaisiva qati nramanrivanto uaini utu vura nreqanro taqovaro kyuqe huvaro mwiva hia qati nramanri kyaqora mwianra ntapihuvata kyaiqa vaisi mwinramwuhua nraahu mwianra ntapihura. Mwitaa huvaro kyaraqaa ntaqikyuva nreqanro taqovaro kyuqe uaini vahuvaro qamwata kyero nraakye varo vaisira nraanrama kyero ");
INSERT INTO omw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","mwia timwa mwinro tiqaro, Qikye, mpo hiahua kyuqe uaini nraante nraakye qora nyiavata nramwa taiqa kyaavata nraakiara uaqia hi uaininra nyi variarave. E hia mwitaa hiaro. Nte taqauqara e mpo uaini vuni nyinra kyuqe uaini mwia nraakiarama nyinra hiaro, tiro. Mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iesusiva Kenaa mwatukya Karirini variqaro qati nramanri vara kyero uaini utu kyero nyunra. Mwiva mwi kyaiqara nraante toharama tero mwiaqaatairo mpo kyaiqa mpo kyaiqa nronra kyaiqa varaqiro vura. Iesusiva mwi kyaiqara varovata mwia nraaqiaranramwuvanto mwia kyaiqa taqetama Iesusira kepukya okyarara ntapihita mwianra qio qutaa mwivave tura. ");
INSERT INTO omw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mwiaqaatai mwivavata, mwia nrovavata, mwia qatanramwuvata, mwia qua riohuavata, mwini kyeta vuhua Kapenaamini uro mpo entanramwu varura. ");
INSERT INTO omw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Vekyahu nyato kyarara nro entava qaumatoqa huvaro Iesusiva Ierusaremini vuva ");
INSERT INTO omw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","uro Kotira nraamwu nronraqi vera ntero taqovata mpo uhua kyoqaa kyaiqa vare variqata munima vareqata purimakauve sipisipive nyaamwave nyi varuvata mpo vaisinramwu tainta nraaqani variqata kamaninra munima vareqata Kotira nraamwuqinaa munima nyi varura. ");
INSERT INTO omw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mwitaamaqita viqata kyoqaa kyaiqa vare varuvaro Iesusiva mwihua taqero kyapipi vara kyero mwiaqotairo purimakauvata, sipisipivata, sataqiro veva Kotira nraamwuqitairo mwaatani kyero munima tuqasaaqi varu vaisihua tainta tu varero vara rauru kyero mwi munimanravata rauru kyero, ");
INSERT INTO omw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","nyaamwa nyiqata munima vare varu vaisihuara tiqaro, Nkye mwi inraikyara mwi inraikyara mwaaqitai vare quate. Nkye hia ni kora nraamwu maaketi nraamwuqama taate. ");
INSERT INTO omw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iesusiva mwitaa tuvaro mpo qua Kotira mpukuqi qara ntumwato quava mwia nraaqiaranramwu nyaatoqi ntumwa vuvata riora. Mwi quava mwitaama tiro: Nte i nraamwuanra nronraqama kyena riemwaqi quariva qia itaintema kyero niqi ite vaiho, tura. Mwi quara mwitaama kyero qara ntumwa tora. ");
INSERT INTO omw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iesusiva mwitaa huvata Iutaa vaisi nronranramwuvanto tiqata, Qaqao, tava iara tiharave e mwitaa hiaro? E nanra nronra kyaiqa mpo tiri tivuqaa utiraqe tire mwia taqetave iara mwiva qio mwitaa hiananrove qiananrave? tita. ");
INSERT INTO omw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mwihua mwitaa tuvaro Iesusiva tiqaro, Nkye mwaa nraamwunra ntapairi kyaivaqe nte taarampo entara qaiqaa hoqa kyaaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mwitaa tuvata Iutaa vaisi nronranramwuvanto tiqata, Qaqao, mwaa nraamwunra hoqeqata 46 ihi airi ihi hoqaqi vita uro hoqa taiqa kyaarave. Qiove e taarampo entara nraahu mwi nraamwunra hoqa taiqa kyenanrave? tita. ");
INSERT INTO omw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mwitaa tuvaro Iesusiva hia vutu kyero qati nraamwuanra tiraitiro, mwiva nai mwamwantaqaa ntumwa kyero tiro. (Nkye ni rukyaivaqe nte taarampo enta vari kyena qati siquaninrave, tiro.) ");
INSERT INTO omw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iesusiva mwi quaraqaa ntumwa kyero tuvata nraakiara Iesusiva qati sivi varu entaraqaa mwia nraaqiaranramwuvanto variqata Iesusiva nraamwuanra tu quava mwihua nyaatoqi ntumwa vura. Kotira mpukuqi qara ntumwato quaravata rieqata, Iesusiva mwi entara tu quaravata rieqata mwihua Iesusirara qutaave tura. ");
INSERT INTO omw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Vekyahu nyato kyarara nro entaraqaa Iesusiva Ierusaremini varuvata nraakye qora airivanto mwia kyaiqa nronra kyaiqa taqeqata Iesusirara qio qutaa mwivave tita. ");
INSERT INTO omw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nraakye qoravanto mwianra qamwateqata mwitaa ti varuvaro Iesusiva nraakye qora okyarara ntapihi kyero rieqarora tiro, mwiva hia mwihua turara qutaave tura. ");
INSERT INTO omw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Iesusiva nai vaakya nraakye qora su nyaatoqi vahu inraikyara ntapihi kyorara tiro, hia qumina mpovanto mwihua okyarara mwia timwa mwianriva varura. ");
INSERT INTO omw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisi vaisi mpovanto mwia nrutu Nikotimaasiva varura. Mwiva Iutaa vunyaa vaisi mpovanto varura. ");
INSERT INTO omw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mpo enta mwiva entaqi uro Iesusira taqero tiqaro, Mwaanra ti variarao, tire taqauraro Kotiva i titaiharara tira, e mwaanra qua ti variaravama nrinra hiaro. Hia Kotiva i kyaahaqa hiankye titiri, e hiama qio nronra kyaiqa varaaratirio, tiro. ");
INSERT INTO omw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mwiva mwitaa tuvaro Iesusiva mwia timwa mwinro tiqaro, Nte qutaa qua qianinra riaante. Vaisi nronra tuemwa quaninra hia qaiqaa mwata tairaro mwiva hiama qio Kotiva ntaqikyi mwatukyara taqaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tuvaro Nikotimaasiva kyapara hiro tiqaro, Nataama kyerove nronra tuemwa quani vaisira qaiqaa mwata kyaananrove? Qiove mwiva nai nronra vikyokyaqi qaiqaa viqe tairaro mwia nrova qaiqaa mwata kyaananrove? tiro. ");
INSERT INTO omw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mwitaa tuvaro Iesusiva nai timwa mwinro tiqaro, Nte qutaama tuqo. Nramanrivata mwata taariva variraro hia Kotira mwanraquravanto mwia qaiqaa mwata kyairaro mwiva hiama qio Kotiva ntaqikyi mwatukyaraqi quananrove. ");
INSERT INTO omw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mwamwanta vataava nai mwamwanta vahira nraahu mwatairave. Mwanraquravanto nai mwanraqura nraahu mwatairave. ");
INSERT INTO omw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nte nkyi qaiqaa qaraakyaqama kyero mwata kyaarive tu quarara hia e mwi quarara nrihanrama quante. ");
INSERT INTO omw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nte mpo quaqaa ntumwa kyena i timwa mwinrenrave. Toqavanto tiqaro nai quataa hiraqa virave. Toqavanto nrihanra e hia mwia taqaraitira, e mwia nruqua nraahu riaananrave. E mwiva viro nrinro hi okyarara hia ntapihiananrave. Qio Kotira mwanraquravanto mwatai okyarava kuaa qarama kyeroma vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Iesusiva mwitaa tuvaro Nikotimaasiva mwia kyapara hiro tiqaro, Nataama kyerove mwitaa hiananrove? tuvaro ");
INSERT INTO omw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesusiva tiqaro, E Isareri nraakye qora mwaanra timwa nyi variarava e hiave ntapihiaro? ");
INSERT INTO omw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nte qutaama tuqo. Tire ntapihi kyeta rie taqe hunanra nkyi timwa nyi varurata nkye hia tiri qua riaarave. ");
INSERT INTO omw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nte mwatanyaa inraikyara nkyi timwa nyuqata nkye mwianra hia ntapihita qutaave qiarave. Nkye mwitaa hiavana nte nyaamwunyaa inraikyara qiarita nataama kyetave nkye mwi quara qio ntapihi rievarave? ");
INSERT INTO omw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Hia vaisi mpovanto Kotiva varira nyaamwuni virave. Nte mwatani mwatatai nraaqiarava nte nraahu nyaamwuni variavava mwisaina tumunrave. ");
INSERT INTO omw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Haaru nkyi haivaqava Mosesiva qumina mwataqaa variqaro ori vara kyero qarura utu kyero mwia kyatariqaa rupa kyero tuaahera kyorave. (Nraakye qoravanto mwia taqeta hia qutu quate tiro, Mosesiva mwitaa hurave. ) Qio nte mwatani mwatatai nraaqiarava variarita haaru Mosesiva qarura utu kyero tuaahera kyontema kyeta nivata kyatariqaa vateta tuaahera kyevarave. ");
INSERT INTO omw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mwitaa hirata nraakye qora nianra qutaa mwivave tihua hia qutu viraitita, ekyaa enta ekyaa enta qati variqi vivarave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kotiva mwatani variahuara mpoqama kyero mwutukya ntiharora tiro, mwiva nai mwaaqu kuaiqia vataira tiri timwinra. Mwitaa hirara tita, nraakye qoravanto mwia mwaaquara qutaa mwivave tihua hia qutu viraitita, mwihua ekyaa enta ekyaa enta qati variqi vivara. ");
INSERT INTO omw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kotiva hia nai mwaaqu ko riaa vaisihua votima kyero variqaro nraakye qora tukya hiarive tiro mwatani titaiharo tuminrave. Mwiva nraakye qora sitaarive tiro, Kotiva mwia titaiharo tuminrave. ");
INSERT INTO omw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mpovanto mwia mwaaquara qutaa mwivave qiariva, mwiva hiama qua varaananro. Mpovanto hia mwia mwaaquara qutaa mwivave qiariva, mwiva vaakyama qua varero. Mwiva Kotira mwaaqu kuaiqiara hia qutaa mwivave tira kyaarama, Kotiva mwianra qutaa iqaa qua vaiho timwa kyero, mwiaqaa qua vatero. ");
INSERT INTO omw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mwaa inraikyara kyaara qua vahiananro. Omwavanto mwatani tumihata nraakye qoravanto hia mwia qamwata mwataraitita, mwihua kyokira rirara nraahu qamwateqata variara. Mwihua kyaiqavanto qora kyaiqa vaihatara tita, mwihua hia mwi omwanra qamwata mwateta. ");
INSERT INTO omw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Qora kyaiqa uti variva nramwutaaqa hiqaroma hia omwavanto varinani viro. Omwavanto iteqaro ni uaqia hi kyaiqara qovarama kyaankyo tiro, hia omwavanto varinani viro. ");
INSERT INTO omw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mwiva mwitaama variharo qutaa kyaiqa vare vari vaisiva hia aatu hiraitiro, omwavanto varinani viro. Mwiva viharo omwavanto itero mwia kyaiqa qovarama kyaihata nraakye qora taqaavaro mwi vaisiva Kotira qua rieqaro Kotira kyaiqa vare varira. ");
INSERT INTO omw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mwiaqaataita Iesusivavata mwia nraaqiaranramwuvata (Ierusaremi kyeta) Iutaa mwata mpo qumina mwatani vura. Iesusiva nai nraaqiaranramwu kyapata variqaro nraakye qora nramanri nyunra. ");
INSERT INTO omw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nyuvaro Ionivavata mwatukya mpo Serimi tataaqa Ainonini variqaro nramanri nyi varura. Ioniva nramanri nronra vahunani variqaro nraakye qora mwini ntuvaantuama vuhua nramanri nyunra. ");
INSERT INTO omw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mwi entara hia Ioninra karavuqi vitaqita uro kyo entara varura. ");
INSERT INTO omw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mwi entara Iutaa vaisi mpovanto Ioninra qua riohua kyapata nramanri vare okyarara inronra huvata mwihua Ioniva hunani uro nteta tiqata, ");
INSERT INTO omw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mwaanra ti variarao, tauraa e Iotaani qarahi vutura hini vaisi mpovata variqarama e mwianra mwivave tunanrave. Qio taqaante. Mwi vaisiva mwivavata nramanri nyi varihata airivanto mwiva hinani vi variavo, tita. ");
INSERT INTO omw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mwitaa tuvaro Ioniva tiqaro, Qio Kotiva nyaamwuni variva vaisi mpo hia mpo inraikya mwinrenra, mwi vaisiva hiama mwi inraikyara varaananrove. ");
INSERT INTO omw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nkyevata vuni nte tura riaarave. Nte tiqana, Hiama nte nkyi kyaahaqa hiariva varuqo. Ni titaihana nte nraante mwia vuni nruvave, turave. ");
INSERT INTO omw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nraakye vararera hi vaisiva nraakye varairave. Mwi vaisira totivanto qati sivi variqaro mwia qua rieqaro qamwata kyero varirave. Qio mwia totivanto qamwataintema kyena nte Iesusirara qamwatauqo. ");
INSERT INTO omw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iesusira nrutu virini nriviraro ni nutu mwatani tumi quarive. (Airivanto mwia vataqita vivarave. Hiama ni pataqita vivarave. Mwihua Iesusira vataqita virara hiama nte Iesusira kyaru ntumwa mwataaninrave. Nte mwia qamwata mwataaninrave), tiro. Ioniva turama. ");
INSERT INTO omw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Iesusiva virisairo tumivara tiro, ekyaahua nraatara kyaivama variro. Mwatanyaava mwatasairo nrivara tiro, mwiva mwatanyaa inraikyara nraahu ti varira. Iesusiva nyaamwusairo tumivara tiro, ekyaahua nraatara kyaivama variro. ");
INSERT INTO omw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mwiva nai taqero riero hi inraikyara qoqaa timwa nyi varihata nraakye qoravanto mwia quara hia qutaave tiraitita, mwia qua qoririma mwate variara. ");
INSERT INTO omw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Qio vaisi mpovanto hia Iesusira qua qoririma mwataraitiro, mwia quara qutaave ti vari vaisiva, mwiva mwitaa tiqaroma Kotira quaravata qutaa qua vaiho tiro. ");
INSERT INTO omw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kotiva Iesusira titaiharo mwiva Kotira qua nraahu ti varira. Kotiva mwia titarera hiro hia nai mwanraqura pataqia pataqia mwinraitiro, mwia nronraqama kyero mwihanronra tiro, qio Kotira qua nraahu ti varira. ");
INSERT INTO omw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mwia qova nai mwaaquara mpoqama kyero mwutukya ntiharo ekyaa inraikya nai mwaaqu mwihanro mwiva mwi inraikyaraqaa ntaqikyiqiro vi variro. ");
INSERT INTO omw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mpovanto mwia mwaaquara qutaave qiariva hia ekyaara qutu viraitiro, mwiva qati variqiro quananro. Mpovanto hia mwia quara qutaave qiariva variraro Kotira raraqa tairaro mwia inronra hiraro quavanto mwiaqaa vahiananro. ");
INSERT INTO omw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mwi entara Parisi vaisinramwuvanto riovaro Iesusiva airi nraakye qora nai hunani sita kyero vateqaro mwihua nramanri nyiqanroma Ioninra nraatara kyora. ");
INSERT INTO omw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Iesusiva hia naivanto mwihua nramanri nyunra. Mwia nraaqiaranramwuvanto nraakye qora nramanri nyunra. ");
INSERT INTO omw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Parisi vaisinramwuvanto mwi quara riovarora tiro, Iesusiva mwiaqaatairo Iutia mwini kyero Karirini viro. ");
INSERT INTO omw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Karirini virero mwiva Sameriaa mwata utaqaama tero quariva vahura. ");
INSERT INTO omw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mwiva viqaroma mwatukya pata mpo mwia nrutu Saikaa mwini uro ntora. Mwata mpo haaru Iaikopuva nai mwaaqu Iosepira mwu mwatara mwia tataaqa vahura. ");
INSERT INTO omw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iaikopuva haaru nramanrianra quvutova mwini vahuvaro Iesusiva nyianra aanra nri kyovaro pupohovaro mwiva nramanrianra quvutora tataaqa mwatakyaa viro varura. Varuvaro huarivanto nrinro virira qiataqaa vahuvaro ");
INSERT INTO omw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sameriaa nraakye mpovanto nramanri kyaqarero nruvaro Iesusira nramanri nraataa huvaro mwi nraakyerara tiqaro, Nramanri kyaqa kyera ni mpiraqe nraankye, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Iesusira nraaqiaranramwu vaakya kyara vararerata mwatukyani vuvaro ");
INSERT INTO omw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Iesusiva mwiaqaa variqaro mwitaa tuvaro Sameriaa nraakye mwiva qaqao tiro, E Iutaavanto variarana nte Sameriaavanto varuqo. Nataamaqirave nianra nramanri kyaqa mpiraqe nraankye tira hiaro? tiro. Iutaavantovata Sameriaavantovata nai nununrama mwate nai nununrama mwate hi varuhuara tiro, mwi nraakyeva mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mwitaa tuvaro Iesusiva nai timwa mwinro tiqaro, E Kotiva qati nyiani inraikyarara e riera ni okyararavata ntapihiaratirio, e ni kyapara hiarana nte qati variqi vi nramanrinra i mwutirio, tiro. (Mwi mwatanaahua nrumwuqinaa nramanrianra tiqata, Qati variqi vi nramanrinrave), tura. ");
INSERT INTO omw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Iesusiva nte qati variqi vi nramanrinra i mwinrenrave tuvaro mwi nraakyeva hia ntapihi kyero riaraitiro, mwiva rumwu nramanrianra tiho tiro. Mwiva tiqaro, Nronrao, nramanrivanto vevato vaihara e hiama nramanri taqu vatera hiaro. Taraqitairave qati variqi vi nramanrinra kyaqenanrave? ");
INSERT INTO omw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tiri haivaqava Iaikopuva nronra vaisivanto varurave. E mpo? E mwia nraatara kyaaravave iho? Mwiva nramanri varaaninra mwata quvu kyero naivata nai nraaqiaravata nai quaravatama kyero mwaa nramanrinra kyaqa kyero nronrave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mwitaa tuvaro Iesusiva tiqaro, Mpovanto mwaa nramanrinra nrainranro qaiqaa nraahu nraataa hiraro nrumu nreqanro variananrove. ");
INSERT INTO omw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nte mwiani nramanrinra mpovanto nrainranro mwia hiama qaiqaavata nraataa hiananrove. Nte nramanri mwianrinro mwi nramanriva vaisi utaqitairo rumwuqitairo tumi nramanrinra votima kyero vi variraro mwi vaisiva hia qutu viraitiro, qati nraahu variqiro quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mwitaa tuvaro mwi nraakyeva tiqaro, Nronrao, qio mwi nramanrinra ni mpiraqe nte nraanrinro hia qaiqaa ni nraataa hiraqe qaiqaavata nrumu mwaaqitaina kyaqa kyeqana nraankye, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Mwitaa tuvaro Iesusiva tiqaro, Qio, uro ena vaativata nraanrama kye vita varera uro ntantera mwaini nriante, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tuvaro mwi nraakyeva tiqaro, Qaqao, hia ni paati varivave, tiro. Tuvaro Iesusiva tiqaro, E qutaama tiqara hia ni paati variho qiaro. ");
INSERT INTO omw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","E kyauquru nani vaati varaaravave. Mate e vaisi mpovata variarava, mwiva hia qutaa i vaativanto variho. E qutaama tira hiaro, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mwitaa tuvaro nraakye mwiva tiqaro, Nronrao, nte taqauqara e poropeti vaisima varira hiaro. Kotiva i kyaahaqa iharama e mwitaa tira hiaro. ");
INSERT INTO omw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Qio Sameriaa tiri haivaqahua Kotira nrutu tuaaherarerata mwaa taaqiraqaa variqata Kotirara aakyara nte varurave. Mwitaa turata nkye Iutaavanto tiriara tiqata, Qaqao nkye Ierusaremini nraahu variqata Kotira nrutu tuaaheraataarave, qiarave. Nkye tiriara mwitaa ti variarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mwitaa tuvaro Iesusiva tiqaro, Ni quara e qutaave qiante. Mpo enta nri ntairata nkye mwi entaraqaa ni kora nrutu tuaaherarera hiqata, hiama mwaa taaqiraqaa variqata aakyara ntevarave. Hiama Ierusaremini variqata Kotirara aakyara ntevarave. ");
INSERT INTO omw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nkye Sameriaavanto hia Kotira okyarara ntapihiraitita, apiqama kyeqata aakyara nte variarave. Tiri Iutaaqitairo nraakye qora huvantu nyataariva qovara hianinranra tita, tire ntapihi kye Kotira okyarara rieqata mwia nrutu tuaahereqata mwianra aakyara nte varunanrave. ");
INSERT INTO omw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mpo enta nrianriva qaumaqa iho. Mwi entava mate qovarama viho. Mwi entaraqaa Kotira mwanraquravanto nraakye qora kyaahaqa hirata mwihua ntapihi kye Kotira okyarara rieqatama mwihua qutaaqama kyeta Kotira nrutu tuaaherevarave. Mwitaama kye Kotira nrutu tuaaherehuara Kotiva puaa hi variho. ");
INSERT INTO omw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kotiva mwanraquravanto varirave. Mwitaama varirara tita, mwia mwanraquravanto kyaahaqa hi nraakye qorahua mwihua nraahuma Kotira okyara ntapihita qutaaqama kyeta Kotira nrutu tuaaherevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mwitaa tuvaro nraakye mwiva tiqaro, Kotiva titaaninra, mesaiaa mwianra nte ntapihi kyauqo. Nraakiara mpo enta mwi vaisiva nri ntero ekyaa inraikyara tiri timwa timwiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mwitaa tuvaro Iesusiva mwianra tiqaro, Qio ivata qua ti varuva nte mwaa mwivave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iesusiva mwitaa ti varuqiaraqi Iesusira nraaqiaranramwuvanto uro ntanteta nrumu taqovaro Iesusiva Sameriaa nraakyevata qua ti varuvata mwihua nrihanrama vita. Mwihua nrihanrama vitavata hia mwi nraakyerara tiqata, Nanra inraikyarave mwiavata qua ti variaro? tiraitita, hia Iesusiraravata tiqata, Nanra inraikyarave nraakye mwiavata qua ti variaro? tura. ");
INSERT INTO omw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tirema varuvaro nraakye mwiva nai nramanri taqu mwini kyero siviro nrumu ntantero mwatukyaqi nraakye qora uro timwa nyinrenro vuva uro ntero tiqaro, ");
INSERT INTO omw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Nkye vaisi mpo nrita taqaate. Mwiva nte utu inraikyara ekyaa ni timwa mpiho. Qutaa mwiva Kotiva titarera hiva, mwivave iho? tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mwitaa tuvata mwihua mwatukya mwia kyeta Iesusiva varunanianra vura. ");
INSERT INTO omw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mwi nraakyeva vuvata Iesusira nraaqiaranramwuvanto Iesusirara tiqata, Mwaanra ti variarao, qati kyara mwaa vara kyera nraante, tuvaro ");
INSERT INTO omw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","mwiva mwihuara tiqaro, Nte kyara nraaninra vatauqo. Nkye mwi kyarara hiama ntapihi kyaavo, tuvata ");
INSERT INTO omw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","mwia nraaqiaranramwu nai timwa mwi nai timwa mwi hita tiqata, Vaakya mpovanto kyara mwihanro nrenrove mwitaa tiho? tuvaro ");
INSERT INTO omw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iesusiva mwinramwuhua timwa nyinro tiqaro, Ni titaira mwutukya vahi kyaiqara vareqana mwiva kyaiqa mpitairavata varaqina uro taiqa kyaariva qio mwi kyaiqava ni kyarama iho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Iesusiva mwitaa timwa kyero tiqaro, Nkye mpo quaqaa ntumwa kye tiqata qiarave. Tora taaratana taaratana vara kyaariro kyara peqaqama viraqe vantuaninrave, qiarave. Qio kyara vara tutaaraqi aitutu hiqata taqaate. Mate kyaravanto naitarama viho. Nkye qioma vantivarave. ");
INSERT INTO omw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kyara vantiva nai kyaiqa varairara kyoqaa varairave. Mwiva kyara vantu tairaro mwi kyarava ekyaa enta ekyaa enta qati vahiqiro quananrove. Mwitaa hirata kyara vara tuarivavata, kyara vantuarivavata, mwitanahuaqama qamwateqata varivarave. ");
INSERT INTO omw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mpo quavata qiava qutaa quama vaiho. Vaisi mpovanto kyara vara tutaira mpovanto mwi kyarara vantirave. ");
INSERT INTO omw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nte nkyi sitena tiqana, Mpovanto kyaiqa vareqaro vara tutai kyarara uro vantuate, tuqo. Mpo hiahua toqaamwu tukyeta kyaiqa vara kyeta kyara vara tutaara, nkye mwihua kyara vantivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Iesusiva mwitaa ti varuvaro mwi nraakyeva uro nai nramwunaahuara tiqaro, Mwiva nte utu inraikyara ekyaa timwa mpiho, tuvata Sameriaa nraakye qora mwi mwatukyaraqinaahua airivanto Iesusirara qio qutaa mwivave, tita. ");
INSERT INTO omw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mwitaa timwa kyeta Sameriaa qinaahua Iesusiva varunani nri nteta Iesusirara po tita tiqata, Qio hia qamwanrama quante. E tirivata vari kyera quante, tuvaro Iesusiva mwihuavata taara enta vaitero vurama. ");
INSERT INTO omw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kyaatavanto nraahu Iesusira qua rieqata qio qutaa mwivave tita. ");
INSERT INTO omw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mwihua mwi nraakyerara tiqata, Hia vaakya e qiananraqaataitavauma tire mwianra qutaa mwivave, turo. Mate tetavanto nai nroqitaita rietama mwianra qutaa mwivave turo. Tire taqauraro Kotiva mwia titaiharo mwiva tiri mwaa mwataraqaa varurahua kyaahaqama timwa tero huvantu timwa taarivama variho, tita. Mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iesusiva mwini taara enta vaitero mwiaqaatairo nai mwaata Karirini viro. ");
INSERT INTO omw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iesusiva nai tiqaro, Poropeti vaisivanto nai mwaatani variharo mwia nrutuvanto hia virito vahirave, tura. ");
INSERT INTO omw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Iesusiva Karirini vuvata mwi mwatanaahua mwianra qamwateqata varura. Mwi mwatanaahuavata vekyahu nyato kyarara nro entara Ierusaremini uro variqata Iesusiva nronra kyaiqa varovata taqorara tita, mwihua mwianra qamwatora. ");
INSERT INTO omw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mwia qamwata mwatovaro Iesusiva qaiqaa Kenaani tauraa mwini variqaro qati nramanri vara kyero uaini nramanriqama kyonani nrunra. Nruvaro kamaninra kyaiqa vaisi mpovanto varuvaro mwia mwaaquvanto nronraqama kyero nriqa vuvaro Kapenaamini varura. ");
INSERT INTO omw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Iesusiva Iutiasairo Karirini nriho tuvaro riero, mwi vaisiva Iesusiva varunani uro ntero tiqaro, Qiove e nrinra ni maaqu nriqa vira kyaahaqama kyairaro qati variananrove, tiro. Mwi vaisira nraaqiaravanto qutu quariva qaumaqa huvaro mwiva mwitaa tuvaro ");
INSERT INTO omw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesusiva mwianra tiqaro, Nkye hia nronra kyaiqa kyuqe hira taqaraitita, hiama nkye qutaave tivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tuvaro nronra vaisi mwiva tiqaro, Nronrao, ni maaquvanto qutu quankyorave. Qamwanrama nriante, tuvaro ");
INSERT INTO omw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesusiva tiqaro, Qio ena mwaatani quante. I mwaaquvanto qati variananrove, tiro. Mwitaa tuvaro mwi vaisiva Iesusiva qua timwa mwunranra qutaa quave timwa kyero, nai mwaatani viro. ");
INSERT INTO omw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mwi vaisiva aanrani vi varuvata mwia kyaiqa vaisinramwuvanto uro hunta kyeta mwia timwa mwita tiqata, I nraaqiaravanto kyuqema viho, tita. ");
INSERT INTO omw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tuvaro mwiva mwinramwuhua kyapara hiro tiqaro, Nanra huari vuqaave mwia nriqa viva taiqa viharo mwiva kyuqema viho? tuvata mwihua tiqata, Enta huari vu vitini tumi viro 1 kirokiqa iharo mwia nriqa viva taiqa virave, tura. ");
INSERT INTO omw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mwitaa tuvaro mwia qova ntapihi kyovaro huari vu mwiqiaraqaa Iesusiva mwia timwa mwinro tiqaro, I mwaaquvanto qioma variananrove, tura. Mwitaa turara tiro, mwi vaisivavata mwia nramwunaahuavata Iesusirara qutaa mwivave turama. ");
INSERT INTO omw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iesusiva Iutiasairo nrumu Karirini variqaro mwi kyaiqara varova tauraa varova kuaiqia vahuraqa mwiva viro taaraqiaqa hura. ");
INSERT INTO omw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mwiaqaatairo Iutaavanto omwata nro entava mpo nri ntovaro Iesusiva Ierusaremini viro. ");
INSERT INTO omw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ierusaremini vasaamwunra qesa mpo sipisipi qesa vahura. Mwia tataaqa nramanri rumpua mwia nrutu Vetasaitaave tuva vahura. Nramanri tokyasataa haraara nraamwu kyauquru vahuvata ");
INSERT INTO omw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","haraara mwiqi nriqa vuhua airinti varura. Vu qipa vuhuave, kyuqu uaqiama vuhuave, kyuqu kyauqu tapanra vuhuave, mwihua variqata nramanrivanto qakyaa hianinra mwia vekya varura. ");
INSERT INTO omw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kuaa enta kuaa enta nyaamwunyaava mpovanto tumu nramanri qakyaa huvaro mwihuaqitairo mpovanto nraante nramanriqi vuvaro mwia nanra mwamwantave nriqa vuva kyuqema vura. ");
INSERT INTO omw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Qio mwihua nramanri qakyaa hianinra vekya varuvaro vaisi mpovanto airi ihi 38 ihiara nriqa vuvaro varuvavata mwiqi variro. ");
INSERT INTO omw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Varuvaro Iesusiva mwia taqero ntapihi kyovaro mwi vaisiva airi ihi nriqa vuvaro varura mwia kyapara hiro tiqaro, I nriqa quariva taiqa quarive tira, e mwianra qamwaterave hiaro? tiro. ");
INSERT INTO omw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mwitaa tuvaro nriqa vu vaisiva tiqaro, Nronrao, nramanrivanto qakyaa iharo mpovanto ni kyaahaqamaqiro uto nramanriqi kyaariva hia varihana nte nraante virera huqata mpohua nraante quavo. Mwitaamaqi vi variqana varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nriqa vu vaisiva mwitaa tuvaro Iesusiva mwia timwa mwinro tiqaro, Sivira ena taarivata tu varera nrohiante, tuvaro qamwanrama mwia mwamwantavanto kyuqema vuvaro ");
INSERT INTO omw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","mwi vaisiva siviro nai taarivata tu varero qio nrohura. Mwi entara mwaanraqaa mwitaama kyora. ");
INSERT INTO omw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mwaanraqaa mwitaama kyorara tita, mwia kyaara Iutaa vaisi nronranramwuvanto vaisi kyuqema vura mwia inronra hita tiqata, Mate mwaanraqaave. Ena taari tu vare vinanranra tiri mwaanra quavanto qao tirave, tita. ");
INSERT INTO omw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tuvaro mwi vaisiva tiqaro, Qaqao, vaisi mpovanto ni kyuqema kyaiva nianra ena taari tu varera nrohiante tihanama nte mwitaa huqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tuvata Iutaa vaisi nronranramwuvanto tiqata, Ta vaisivave iara sivira ena taari tu varera nrohiante tiho? ");
INSERT INTO omw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","tuvaro mwia mwamwantavanto kyuqema vu vaisiva hia mwia nrutu ntapihura. Mwini nraakye qora airivanto varuvaro Iesusiva qamwanrama vi vuvaro mwi vaisiva hia Iesusira nrutu ntapihura. ");
INSERT INTO omw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mwia nrutu hia ntapihiraitiro varuvaro Iesusiva nraakiara variqaro taqovaro mwi vaisiva nraamwu nronra Kotira nraamwuqi varuvaro Iesusiva mwia timwa mwinro tiqaro, Qio taqaante, i mwamwantavanto kyuqema viho. Mpo inraikyavanto mwia nraataraariva i ru kyaankyo tira, hiama qaiqaa uaqia hi kyaiqara utuqira quante, tiro. ");
INSERT INTO omw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mwitaa tuvaro mwi vaisiva mwiqitairo veva ntero uro Iutaa vaisi nronranramwu timwa nyinro tiqaro, Mwia nrutu Iesusiva mwivama ni mamanta kyuqema kyaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tuvata mwihua riovaro Iesusiva mwaanraqaa mwia kyuqema kyorara tita, mwihua mwia kyaara mwi entaraqaataita Iesusira qoraqama mwate varura. ");
INSERT INTO omw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mwitaa huvaro Iesusiva mwihua timwa nyinro tiqaro, Ni kova ekyaa enta kyaiqa vare varihanama ntevata kyaiqa vare varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tuvata mwi quara kyaara Iutaa vaisi nronranramwuvanto mpoqama kyeta Iesusira ru kyarerata uti varita tiqata, Tauraa Iesusiva tire mwaanra entara tuna quara nteqa kyaiho. Mwia nraakiara mwiva Kotirara ni korave tiho. Mwiva qumina vaisivanto variqaro mwiva Kotira votima kyero Kotikyantiri kuaaqaa varirero uti variho, tita. ");
INSERT INTO omw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iutaa vaisinramwuvanto mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Nte qutaa qua qianinra riaate. Nte mwia mwaaquvanto variqana hiama ntena nraato tukyena mwi inraikyara varaaninrave. Ni kova kyaiqa varaihana nte taqaura mwi kyaiqara nraahuma vare varuqo. Ni kova mwitaa mwitaa ihana nte mwia mwaaquvantovata mwitaa mwitaa hi varuqo. ");
INSERT INTO omw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ni kora mwutukyavanto ni nai mwaaquara vaiharora tiro, mwiva nai vare vari kyaiqara ekyaa kyaiqa ni naamutaiho. Nraakiara ni kova naamutairaqe nte mwaa kyaiqara nraatara kyaani kyaiqarama varaaninrave. Nte mwi kyaiqara mwi kyaiqara varaarita nkye mwia taqetama mpoqama kyeta nrihanrama vivarave. ");
INSERT INTO omw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ni kova qutu quahua qaiqaa vara sivuma kye varivave. Ni kova mwitaa hintema kyena nte mwia mwaaquvantovata variqana ni mutukya vahiani nraakye qorahua qati vara sivuma kyaarita mwihua qati variqita vivarave. ");
INSERT INTO omw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ni kova nai hiama nraakye qora ko qiananrove. Mwiva mwi kyaiqara ni mpitaihana nte mwia mwaaquvanto variqana qio ko qianinrave. ");
INSERT INTO omw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mwiaqaataita nraakye qoravanto ni kora nrutu tuaaheraantema kyeta mwihua ni mwia mwaaqu nrutuvata tuaaherevarave. Mpovanto hia ni mwia mwaaqu nrutu tuaaheraariva hiama ni kova ni titaira nrutuvata tuaaheraananrove. ");
INSERT INTO omw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nte qutaa qua qianinra riaate. Mpovanto ni qua riero qutaama Kotiva mwia titaivave qiariva, mwivama ekyaa enta ekyaa enta qati variqiro quananrove. Mwi vaisiva hiama qua varaananrove. Mwiva mwaa entara hia ekyaara qutu viraitiro, mwiva ekyaa enta qati variqiro quarivama variho. ");
INSERT INTO omw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nte qutaa qua qianinra riaate. Mpo enta nrianriva qaumaqa iho. Mwi entaraqaa qutu virera utihua, mwihua Kotira mwaaqu ni qua rievarave. Ni qua riehua qioma qati variqita vivarave. ");
INSERT INTO omw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Qati variqita qua okyarava ni koraqi vaiharo ni kova nai mwaaqu ni nronraqama kyaiharo mwiaqi vahintema kyero qati variqita qua okyarava niqivata vaiho. ");
INSERT INTO omw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ni mwatani mwatatai nraaqiarara tiro, ni kova ni nronraqama kyaihana nte mwatani vari nraakye qorahua qio ko qianinrave. ");
INSERT INTO omw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nkye hia nte qua qianinranra nrihanrama quate. Mpo enta nri ntairaqe nte mwihua nyaanraanrita mwataqi quntamwa te nraakye qorahua ni qua rieta, ");
INSERT INTO omw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mwihua quntamwa teraqitaita sivivarave. Hini hihua kyuqe kyaiqa varehua sivita qati variqita vivarave. Hini hihua uaqia hi kyaiqara utihua sivita nronra quama varevarave. ");
INSERT INTO omw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nte variqana hiama ntena nraato tukyena mpo inraikya varaaninrave. Kotiva timwa mpi varihana mwia qua rieqanama nte nraakye qora qio ko qianinrave. Hiama nte ntena mwutukya nti kyaiqara vare varuqo. Nte ni kora mwutukya nti kyaiqarama vare varuqo. Mwitaamaqi vi varuvara tina, nte nraakye qora qua ntapihi kyena ko qianinrave. ");
INSERT INTO omw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nte ntenavanto ntena okyarara qiariro mpovanto ni quara hia qutaa quave qiankyorave. ");
INSERT INTO omw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Qio mpovanto variqaro ni okyarara timwa nyi variho. Nte ntapihi kyauqaro mwiva nianra timwa nyi quava qutaa quama vaiho. ");
INSERT INTO omw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nkye tauraa vaisi mponramwu sitovata mwihua uto Ioninra kyapara huvaro Ioniva ni okyarara ntapihi mwihua timwa nyunrave. ");
INSERT INTO omw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Vaisivanto ni okyarara qianinra hia nte mwianra nronraqama kyena riauqo. Kotiva nkyi sitaarive tina, nte mwi quara timwa nyuqo. ");
INSERT INTO omw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ioniva variqaro omwa votima kyero ite varuvata nkye variqata mwiva itorara hia mpuahaama kyeta qamwata mwatorave. ");
INSERT INTO omw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Qio ni okyarara qiariva Ioninra nraataraarivama variho. Ni kyaiqavanto nianra timwa nyi variho. Ni kova kyaiqa ni mpitaira nte mwi kyaiqara vare varuva, qio mwi kyaiqava ni okyarara timwa nyi variho. Nraakye qoravanto ni kyaiqa taqeqatama qioma ni kova ni titairave tivarave. ");
INSERT INTO omw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ni kova ni titaiva, mwivama ni okyarara timwa nyi variho. Nkye hia mwia qua rieta, hia mwia viri taqaarave. ");
INSERT INTO omw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mwiva ni titaihana tumuqata nkye hia nianra qutaa mwivave qiavo. Nkye hia mwitaa qiavarora tiro, Kotira quavanto hia nkyi su nyaatoqi vaihata variavo. ");
INSERT INTO omw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nkye tiqata, Kyaiqe Kotira mpukuqi aitutuma kyeta taqeta ekyaa enta ekyaa enta qati variqita quare, ti variarave. Qio mwi mpukuraqi vahi quava ni okyarara ti varihata ");
INSERT INTO omw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nkye hia nte varunani nriavana nte qati variqi vi inraikyara nkyi nyunrave. Nte hunani nriataara vaihata nkye hia nrianrave. ");
INSERT INTO omw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Hiama nte vaisiqaataina nronra nrutu varaaninrave. ");
INSERT INTO omw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nte nkyi ntapihi kyauqo. Nkyi mwutukyavanto hia Kotirara vaihata variavo. ");
INSERT INTO omw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kotiva ni kova ni titaihana nte ntena kora nrutu varena nruqatavata nkye hia ni qamwata kyeta pitaarave. Mpovanto nai riemwa kyero nai nrutu tuaaherarero hirata nkye qamwanrama kyeta mwia qamwata mwatevarave. ");
INSERT INTO omw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nkye nai nrutu nai nrutu tuaahererara nronraqama kyeta rieqata hia Kotiva nkyi nyutu tuaaheraaninranra nronraqama kyeta riaavo. Mwitaa hi variqata nkye nataama kyetave nianra qutaa mwivave tivarave? ");
INSERT INTO omw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nraakiara ntena kora vuqaa variqana hia ntevanto nkyiqa qua vataaninrave. Mosesiva nkyita haivaqava, mwivama nkyiqa qua vataananrove. Nkye Mosesirara mwiva tiri kyaahaqa hiananrove qiarave. Qio nraakiara mwivama nkyiqa qua vataananrove. Mosesiva qara ntumwa to quava nianra tihata nkye mwia quara hia qutaa quave qiarave. ");
INSERT INTO omw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nkye Mosesiva tu quarara qutaa quave qiatirio, nkye ni quaravata qutaa quavema qiatiri. ");
INSERT INTO omw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nkye mwia quara hia qutaa quave tiqata nataama kyetave nkye ni quaravata qutaa quave tivarave? Nkye hia qio mwitaa hivarave, tiro. (Iesusiva mwi quara Iutaa nronra vaisinramwu timwa nyunra.) ");
INSERT INTO omw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mwiaqaatairo Iesusiva uro Kariri kyaarera, mwia nrutu mpo Taipiriaasi kyaarera vara mwaini kyero mpotuqi kyaarera mwiaqaa qarero hini tokyani uro variro. ");
INSERT INTO omw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Uro varuvata nraakye qora airivanto taqovaro Iesusiva nriqa vuhua kyuqema kyovatara tita, mwihua Iesusira vataqita vita. ");
INSERT INTO omw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mwia vataqita vuvaro Iesusiva nai nraaqiaranramwu kyapata uro taaqisataa mwatakyaa viro varura. ");
INSERT INTO omw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mwi entara Iutaavanto vekyahu nyato kyarara omwata nro entava qaumaqa hura. ");
INSERT INTO omw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesusiva nai nraaqiaranramwu kyapata mwatakyaa viro variqaro taqovata nraakye qora airivanto mwia vataqita nruhua nrumu ntuvaantuama vita varuvaro Iesusiva Piripira kyapara hiro tiqaro, Tire taisaitave kyara kyoqaama kyeta mwi nraakye qorahua nyianrata nrevarave? tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iesusiva nai mwihua kyara nyiani okyarara vaakya ntapihiro mwiva Piripira qati mwataara hiqaro mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tuvaro Piripiva tiqaro, Qaqao, kyarara 200 kinaa nronra munima kyeta vara ntainra nyianrata mwihua pataqia pataqia nraahu varevarave. Airi nraakye qoravanto variavo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tuvaro Iesusira nraaqiara mpovanto Enturuva Saimoni Pitaara qatavanto tiqaro, ");
INSERT INTO omw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Nyaako mpovanto mwaini variho. Mwiva mpereti hini kyauquruvata tavukya taaratanavata nraahu vataiva variho. Nataama kyerove mwiqiatanava airi nraakye qoraqi qio vahiananrove? tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mwitaa tuvaro Iesusiva nai nraaqiaranramwu timwa nyinro tiqaro, Nraakye qorara tivata mwatakyaa vita variate, tiro. Iesusiva mwitaa tuvaro mwini mwukyauvanto vahuvata vaisi 5,000 nramwu airivanto mwatakyaa vita varuvata (nraakyevata airivanto mwatakyaa vita varura). ");
INSERT INTO omw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mwihua mwatakyaa vita varuvaro Iesusiva mpereti mwia vara kyero Kotirara kyuqeve timwa kyero, nraakye qora mwatakyaa vita varuhua tukyama kyero nyinro. Tukyama nyinro tavukyavata vara kyero kuaa qarama kyero mwatakyaa vita varuhua tukyama kyero nyuvata mwihua vara kyeta qio nronra. Mwihua nkyiari nraataa huntema mwi kyarara qio nronra. ");
INSERT INTO omw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mwihua qio nrovaro Iesusiva nai nraaqiaranramwuanra tiqaro, Mwihua nreqata viti vaati kye kyarara utu ntuvaantua hiate. Kyaravanto qumina viro raupiri hiankyorave, tuvata ");
INSERT INTO omw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","mwia nraaqiaranramwuvanto nraakye qoravanto kyauquru mpereti nreta viti vaati kyora utu kyeta ntutantuto tuara 12 nramwu piqa kyora. ");
INSERT INTO omw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Piqa kyovata qio nraakye qora mwini varuhua taqovaro Iesusiva nronra kyaiqa vara kyovata mwihua tiqata, Poropeti vaisivanto mwatani tumuanriva qio qutaa mwaa mwi vaisivave, tita. ");
INSERT INTO omw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mwitaa ti varuvaro Iesusiva ntapihi kyovata nraakye qoravanto kyai mwia nronraqama kyaararo tiri vunyaa vaisi nronravanto variarive tiqata Iesusira tu vararera uti varuvaro Iesusiva mwia ntapihi kyero mwihua mwitaa hivorave timwa kyero, qaqira kyero tumu ntantero taaqiqaa nanrianraa uro varirero vura. ");
INSERT INTO omw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Iesusiva taaqiqaa uro varuvaro enta hirero huvata mwia nraaqiaranramwuvanto kyaarera tokyasata tumu nteta ");
INSERT INTO omw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","mpotuqi mwaanri nteta nrumu ntanteta Kapenaaminianra vita. Mwihua mwinianra vuvaro anoma entama vuvaro ");
INSERT INTO omw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Iesusiva hia tumuvata mwihua kyaareraqaa vi varuvaro toqa vaururuvanto nronraqama kyero tiqaroma kyaarera nramanri ventaqiro nri varura. ");
INSERT INTO omw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mwitaa huvata mwia nraaqiaranramwuvanto kyaareraqaa kyatariqo mpotu ventaqita viqata 5 kiromitave iho 6 kiromitave mwihua vara kyeta kyaarera utaqaa nrita taqovaro Iesusiva nramanri mwutuqaa kyuqu ntamwaqiro viqaroma mpotu qaumato nruvata mwihua mwia nraatu mpoqama kyeta aatu hi varura. ");
INSERT INTO omw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Aatu hi varuvaro Iesusiva mwihua timwa nyinro tiqaro, Hia aatu hiate. Ntema nruqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tuvata mwihua qio mpotuqi mwaanri ntaante tuvaro mwaanri ntovaro mpotuvanto qamwanrama mwihua virera hunani uro ntora. ");
INSERT INTO omw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mwia qanranraa nraakye qora kyaarera tokya hini varuhua taqovaro mpotu kuaiqiavanto vahuvata mwihua ntapihi kyovaro Iesusiva hia mwisairo nai nraaqiaranramwu kyapata mwaanri ntero vuvata mwihua nkyiariaraa mpotuqi mwaari nteta vura. ");
INSERT INTO omw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mwihua mwitaama rieta varuvata Taipiriaasisaita mpotu mponramwuvanto nrumu tauraa Iesusiva kyarara kyuqeve timwa kyero, tukyama nyuvata nraakye qoravanto nro mwatara qaumato nruvata ");
INSERT INTO omw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","mpo nraakye qora mwini varuhua taqovaro Iesusiva hia mwini varuvata mwia nraaqiaranramwuvata hia varuvata mwihua mpotuqi mwaanri nteta Kapenaamini Iesusirara puaa hirerata vura. ");
INSERT INTO omw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mwihua Iesusira puaa hirerata vuhua uro kyaarera tokya hini Iesusira puaama kyeta mwianra tiqata, Mwaanra ti variara vaisio, taireve e mwaini nrinra hiaro? tuvaro ");
INSERT INTO omw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesusiva tiqaro, Nte qutaa qua qianinra riaate. Nkye mpereti airiqama nraanranra rieqatama nianra puaa hi variavo. Nkye hia ni kyaiqa okyara ntapihi paahima kye rieqatavauma nianra puaa hi variavo. ");
INSERT INTO omw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Qio hiama qati kyara tapitaani kyarara vararerata kyaiqa varaate. Nkye mwitaa hira qaqira kyeta ekyaa enta qati variqi quani kyarara vararerata kyaiqa varaate. Mwi kyarara nte mwatani mwatatai nraaqiarava variqana qioma nte nkyi nyianinrave. Kotiva ni kova mwivama ni nronraqama kyaihana nte qio mwitaa hianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iesusiva mwitaa tuvata mwihua mwia kyapara hita tiqata, Tire Kotira kyaiqa vararera hiqata, nataa nataave hiananrave? tita. ");
INSERT INTO omw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tuvaro Iesusiva timwa nyinro tiqaro, Kotiva nkyiara mwaa kyaiqara varaate ti variho. Mwiva titai vaisirara nkye qutaa mwivave qiate tiho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mwitaa tuvata mwihua tiqata, Qio nanra kyaiqave tiri tinraamwutairaqe tire mwia taqeta i okyarara qutaave qiananrave? ");
INSERT INTO omw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","E nanra kyaiqa nronra kyaiqave varenanrave? Tiri haivaqahua haaru qumina mwatani variqata nyaamwunyaa kyara nronrave. Mwihua manaa nronrave. Mwianra Kotira mpukuqi qara ntumwa tova mwitaama tiro: Mwiva nyaamwunyaa kyara nyunrave, turave, tita. ");
INSERT INTO omw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mwihua mwitaa tuvaro Iesusiva tiqaro, Nte qutaa qua qianinra riaate. Haaru mwi entara Mosesiva nkyi haivaqahua kyara nyiqanro hia qutaa nyaamwunyaa kyara mwihua nyunrave. Ni kova, mwivama nyaamwunyaa kyara qutaa kyara nyianrivama variho. ");
INSERT INTO omw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mwatani variahua mwihua qati variqi quate tiro, nyaamwusairo tumu vari vaisiva, mwi vaisivama Kotira kyaravanto variho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mwitaa tuvata mwihua tiqata, Nronrao, qio e mwi kyarara tiri timwiqira quante, tita. ");
INSERT INTO omw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tuvaro Iesusiva timwa nyinro tiqaro, Qio nte qati variqi vi kyarava mwaa mwivama varuqo. Nte hunani nrianriva hiama kyara nraataa hiananrove. Nianra qutaa mwivave qiariva hiama mwia nramanri nraata hiananrove. ");
INSERT INTO omw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nte vaakya nkyiara tiqana, Nkye ni taqetavata hia nianra qutaa mwivave qiavo, turave. ");
INSERT INTO omw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ni kova ni mpiari nraakye qorahua, mwihua nte hiarinani nrivarave. Mwihua nte hiarinani nrivaqena nte hiama mwihua qoririma nyataaninrave. ");
INSERT INTO omw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nte nyaamwusaina hia ntena vu nraato tukyena kyaiqa vararera tumuvave. Nte ni titaira mwutukya vahi kyaiqara vararera tumuvave. Ni titaira Kotira mwutukya vahiva mwitaamama vahirove. ");
INSERT INTO omw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mwiva nraakye qora ni mpihua nte mpoku raupirima kyaankyorave. Nte mwihuaqaa ntaqikyiqi vina ekyaara entaqaa vara sivuma kyaarita qati variqita vivarave. ");
INSERT INTO omw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Qaiqaa ni titaira mwia mwutukya vahiva mwitaamama vahirove. Ekyaa nraakye qora ni mwia mwaaqu taqeta qutaa mwivave tihua, mwihuama qati variqita vivarave. Nte ekyaara entaqaa variqana mwihua sivuma kyaarita qati variqi vivarave. Qio ni kora mwutukya vahiva mwitaamama vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Iesusiva tiqaro, Nte nyaamwusaina tumu mperetivave, turara tita, Iutaa nronranramwuvanto nrutu nraunru/nrunru nraanru tita tiqata, ");
INSERT INTO omw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Qaqao, mwi vaisiva Iesusiva Iosepira mwaaquvantove. Mwia nrohua qohua tire taqaunanrave. Qio nanraqamave mwiva nte nyaamwusaina tumuvave tiho? tita. ");
INSERT INTO omw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mwihua mwitaa ti varuvaro Iesusiva tiqaro, Eqaate. Nkye hia nrutu nraunru qiate. ");
INSERT INTO omw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni kova ni titaiva hia vaisi mpo vitairera, mwi vaisiva hiama nte hunani qio nriananrove. Ni kova vitaarihua mwihua nraahuma nte hunani nrivarave. Qio mwihua nrivaqe nte ekyaara entaqaa mwihua vara sivuma kyaarita mwihua qati variqi vivarave. ");
INSERT INTO omw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Haaru poropeti vaisi mpovanto mwitaama qara ntumwa tero tiqaro, Nraakiara Kotiva ekyaa nraakye qora nyaamwute varirata mwia kyaiqa ntapihivarave, turave. Ni kova kyaiqa nyaamwutairata mwihua ni kora qua riehua mwihua nraahuma nte hunani nrivarave. ");
INSERT INTO omw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Qio hia vaisi mpovanto ni kora taqaiva varirave. Nte Kotiva hinasaina tumuva, nte nraahu mwia taqaurave. ");
INSERT INTO omw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nte qutaama tuqo. Nianra qutaa mwivave qiariva qati variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nraakye qoravanto kyara nreta qati variqi viva nte mwaa mwi kyaravama varuqo. ");
INSERT INTO omw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nkyi haivaqahua qumina mwatani variqata nyaamwunyaa kyara, mwia nrutu manaa mwi kyarara nramwaqi viqatavata uro qutu vurave. ");
INSERT INTO omw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Qio mpo kyaravanto nyaamwusairo tuminrave. Mwi kyarara nraanriva hiama ekyaara qutu quananrove. ");
INSERT INTO omw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Qio nte qati variqi vi kyarava mwiva nyaamwusaina tumuvave. Mpovanto mwi kyarara nraanriva, mwiva qati variqiro quananrove. Nte kyara mwinrenra ntena mwativata ntena mwamwantavata mwianinrave. Mwatani varihua qati variqita quate tina, nte mwia nyianinrave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tuvaro Iesusiva mwitaa tuvata Iutaa vaisi nronranramwuvanto nkyiari nraahu inronra hita tiqata, Mwiva nataama kyerove nai mwamwanta tiri timwinraqe nraananrave? tita. ");
INSERT INTO omw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesusiva mwihua timwa nyinro tiqaro, Qutaama nte tuqo. Nte mwatani mwatatai nraaqiarava nte variarita nkye hia ni mwativata nraanrevata nraivera, nkye hiama qati variqita vivarave. ");
INSERT INTO omw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ni mwativata ni nraanrevata nraanriva qati variqiro viraqe nte ekyaara entaqaa mwia qati vara sivuma kyaaninrave. ");
INSERT INTO omw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ni mwativanto kyara tuananra vaiharo ni nraanrevantovata nramanri tuananra vaiho. ");
INSERT INTO omw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ni mwativata ni nraanrevata nraanriva niqi variraqena nte mwiaqima varianinrave. ");
INSERT INTO omw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ni kova mwiva qati variqiro viva variqaro mwiva ni titaihanama nte mwiva qati variqiro viraqaataina ntevata mwaini tumu qati variqina vuqo. Qio mwia votima kyero vaisi mpovanto ni nramwaqiro quariva niqaatairo qati variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Qio nte mwi kyarava nyaamwusaina tumuvave. Nkyi haivaqahua haaru mpo kyara manaa nramwaqita vita uro qutu vurave. Qio hia nte mwi kyarara voti huvama varuqo. Ni kyara mwaa nraanriva ekyaa enta qati variqiro quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesusiva Kapenaamini mwaanra nraamwuqi variqaro mwi quara tura. ");
INSERT INTO omw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iesusiva mwi quara tuvata mwia vataqita nrohuhua mponramwu variqata mwi quara rieta qaqao tita, Mwi quava muaanra ntai quarama tiho, Tavave mwi quara qio ntapihiananrove? Hia tire qio ntapihiananrave, tita. ");
INSERT INTO omw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mwihua tirema kyeta mwitaa ti varuvaro Iesusiva ntapihuvata mwia vataqita nrohu vaisihua mwianra nrutu nraunru tiqata mwia inronra hi varuvaro Iesusiva tiqaro, Mwi quara kyaarave nianra nrutu nraunru ti variavo? ");
INSERT INTO omw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Qio nte mwatani mwatatai nraaqiarava varuqo. Nte nraakiara tumu ntantena ntena variavara qoqaraanani uro variarita nkye mwia taqeta nataave hivarave? ");
INSERT INTO omw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Vaisivanto mwanraqura vataava variharo mwia mwanraquravanto mwiaqi variharora tiro, mwi vaisiva qati varirave. Mwia mwanraquravanto mwi vaisiraqi hia varirera, hia mwia mwamwantavanto mwia qio kyaahaqa hiraro mwiva qati variqiro quananrove. Qio nte vaakya turara hia nte qumina mwamwantara turave. Nte qati variqi vi mwanraqura okyarara nkyi timwa nyunrave. ");
INSERT INTO omw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nte qati variqi vi okyarara nkyi timwa nyunrave. Nte mwitaa tuqata nkye hininramwuvanto hia ni quara qutaa quave qiavo, tiro. Iesusiva haaru toharo entaraqaatairo vaisi mponramwuvanto nraakiara mwianra hia qutaa mwivave tihua ntapihi kyora. Vaisi mpovanto mwia nramwutaahua uro timwa nyinro mwia qovarama kyaaninravata ntapihi kyora. ");
INSERT INTO omw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mwihua mwitaa mwitaa hirara ntapihi kyero Iesusiva mwihua timwa nyinro tiqaro, Mwianra rieqanama nte vuni tiqana, Hia ni kova qiove tirera, hia mpovanto nte hianinrani qio nriananrove, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mwitaa tuvata mwia kyaara Iesusira vataqita vuhua airivanto mwia ekyaara qaqira kyeta nrumu ntanteta vura. ");
INSERT INTO omw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mwitaa huvaro Iesusiva nai nraaqiara 12 nramwu kyapara hiro tiqaro, Nkyevata mpo? Nkye ni qaqira kyeta vireratave hiavo? tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tuvaro Saimoni Pitaava mwia timwa mwinro tiqaro, Nronrao, tirenramwu ta vaisiva hinanive quananrave? Ema qati variqi qua okyarara qiaravama variaro. ");
INSERT INTO omw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tirenramwu iara qutaama mwivave tiqatama ntapihi kye taqaurara e nraahuma Kotira kyotata vaisivanto Kotiva hinasaira tumuanravave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mwitaa tuvaro Iesusiva mwihua timwa nyinro tiqaro, Qio nte nkyi 12 nramwu nyaanrama kyena sitaurave. Nte 12 nramwu nkyi nyaanrama tauraqitairovata mpokuvanto uaqia hi vaanavama variho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesusira nraaqiara 12 nramwuqitairo Iutaasiva Saimoni Isikeriotira mwaaquvanto nraakiara Iesusira qovarama kyaaninranra rieqaro Iesusiva mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mwiaqaataita Iutaa vaisi nronranramwuvanto mwia ru kyarerata uti varuvarora tiro, Iesusiva hia Iutiaani nrohiraitiro, qaqira kyero Kariri mwatani variqaro mwini nraahu nrohi varura. ");
INSERT INTO omw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mwi entara omwata nro entava mpo qaumatoqa hura. Mwia nrutu Haraara Nraamwu omwata. (Haaru mwihua haivaqahua qumina mwatani variqata haraara nraamwuqi varu entarara rieqatama omwata nronra.) Omwata nro entava qaumato vahuvata ");
INSERT INTO omw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iesusira qatanramwuvanto tiqata, Qio mwaini kyera vetara Iutiaani virata i vataqita vihua i kyaiqa taqaate. ");
INSERT INTO omw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nai nrutu viriniqa hiarive tiro, mpovanto hia nai kyaiqa uqeta kyakya hirave. E qutaa mwi kyaiqara mwi kyaiqara vare varirera, qio uro ntera qoqaa variqara mwi kyaiqara mwi kyaiqara varairata ekyaa mwihua i taqaate, tita. ");
INSERT INTO omw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mwia qatanramwuvanto Iesusirara hia qutaa mwivave tiqatara tita, mwihua mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mwitaa tuvaro Iesusiva timwa nyinro tiqaro, Nte mwini quari entava hiama nri ntaiho. Nkye qioma api enta vivarave. ");
INSERT INTO omw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mwatani variahua hia nkyi nramwutaaqa hivarave. Nte mwihua kyaiqara uaqia hi kyaiqarave timwa kyeqana ntapihi timwa nyunrave. Mwitaama vutu kyeqana timwa nyuqata mwihua ni nramwutaaqa hi variavo. ");
INSERT INTO omw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nkyenramwu omwata nranrenra hianani quate. Nte mwini quari entava hia nri ntaihana nte mate hia quaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","10","Iesusiva mwitaa timwa kyero Karirini varuvata mwia qatanramwuvanto omwata nranrenra hunani vuvaro Iesusiva vari kyero nraakiara mwivavata mwini viro. Mwiva hia qoqaa viraitiro, uqeta kyero mwini vura. ");
INSERT INTO omw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Vuvata Ierusaremini omwata nronraqi Iutaa vaisi nronranramwuvanto mwianra aitutu hi varita tiqata, Mwiva tanave variho? ti varura. ");
INSERT INTO omw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mwitaa ti varuvata qati nraakye qoravanto Iesusirara tirema kyeta mpo qua mpo qua tura. Hini uhua mwianra tiqata, Mwiva kyuqe vaisivantove, tuvata hini uhua mwianra tiqata, Qaqao, mwiva nraakye qora api aanra nraahu nyaamwute vari vaisivave, tita. ");
INSERT INTO omw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Iutaa nronra vaisinramwu nyaatu aatu hiqata mwihua hia Iesusirara vutu kyeta mwitaa tura. Mwihuaqitairo hia mpovanto vutu kyerovata tura. ");
INSERT INTO omw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mwitaamaqita vuvaro omwata nro entava hininramwu taiqa vuvaro Iesusiva uro ntero Kotira nraamwu nronraqi variqaro Kotira qua nraakye qora timwa nyi varura. ");
INSERT INTO omw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mwiva timwa nyi varuvata Iutaa vaisi nronranramwuvanto mwia qua rieta nrihanrama vita tiqata, Qikye, mwiva hia tirivata sikuru tivave. Nataama kyerove mwiva mpo qua mpo qua okyara qio ti variho? tita. ");
INSERT INTO omw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mwitaa tuvaro Iesusiva tiqaro, Hiama nte ntena qua mwakyaakya nkyi timwa nyi varuqo. Kotiva ni titaihana nte mwia qua mwakyaakyama nkyi timwa nyi varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Iesusiva mwitaa timwa kyero mwiva tiqaro, Kotira mwutukya vahirara rieqaro mwia kyaiqa varaataa hiariva, mwivama ni qua tukyama kyero tiqaro, Mwiva Kotira quama ti variho, mwiva nai quama ti variho, qiananrove. ");
INSERT INTO omw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mpovanto nai vu nraato tukyero qua ti vari vaisiva, mwi vaisiva nai nrutuara nraahu rieqaro varirave. Mpovanto nai titaira nrutuara nraahu riemwaqiro vi vari vaisiva, mwi vaisiva qutaa qua nraahuma tiharo hiama unra qua mwiaqi vahirove. ");
INSERT INTO omw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Qio qutaa nkyi haivaqava Mosesiva qua mwaanra Kotiva mwitaa mwitaa hiate tu quara nkyi timwa nyunrave? Qio hia nkyiqitairo mpovanto mwi quara vataqiro vi varirave. Mwitaa hiqata nkye nanraqamave ni ru kyarerata uti variavo? tiro. ");
INSERT INTO omw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Iesusiva mwitaa tuvata mwini ntuvaantuama vita varuhua tiqata, E ueraqama quaro. Tavave i ru kyarera uti variho? tita. ");
INSERT INTO omw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tuvaro Iesusiva tiqaro, Nte (mwaanra entaqaa) nronra kyaiqa kuaiqia varauqata nkye mwianra nrihanrama quavaroma hia nkyi kyakya iho. ");
INSERT INTO omw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nkyi haivaqava Mosesiva mwaanra qua tiqaroma qoraisi nraaqiarara mwia mwamwanta toqa kyaate. (Qoraisi nraaqiara mwatataivata 8 enta nritarairata mwia mwamwanta toqa kyaate,) turave. Qio hia Mosesiva tauraaqama mwi quara turave. Mosesira haivaqahuamwanra mwi quara vuniqama kye turave. Qio nkye mwi quara rieqatama 8 enta nritarairata qati entaqaave, mwaanra entaqaave, nkye qoraisi nraaqiara mwamwanta toqa nyate variarave. ");
INSERT INTO omw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mosesira qua nteqa kyaarorave tiqatama nkye mwaanra entaqaa qoraisi nraaqiara mwamwanta toqa nyate variarave. Mwitaa hi variavana nte mwaanra entaqaa nriqa vi vaisira kyuqema kyauqata nkye nanraqamave mwia kyaara ni inronra hi variavo? ");
INSERT INTO omw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nkye niqaa qua vatarera hiqatama, haunri qumina nkyeta su nyaato tiraqa niqaa qua vatevorave. Nkye qutaa vahiani inraikyaraqaara niqaa qua vataate, tiro. ");
INSERT INTO omw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Iesusiva mwitaa ti varuvata Ierusaremiqinaahua mponramwuvanto Iesusirara mpo vaisinramwu kyapara hita tiqata, Mwi vaisirave mwihua ru kyarerata uti variavo? ");
INSERT INTO omw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Qio taqaate. Mwiva qoqaa variqaro qua ti varihata mwihua hia nrumu mwiaqaa mwianra mpo qua qiavo. Qutaave mwihua Iesusirara mwiva mesaiaavantove qiavo? ");
INSERT INTO omw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Qio tire Iesusiva mwisairo nri okyarara ntapihuro. Mwiva mwi mwatukyaraqitairo nrivave. Mesaiaavanto qovarama viraro hiama tiriqitairo mpokuvanto mwiva mwisairo nriani okyarara qio ntapihiananrove, tita. ");
INSERT INTO omw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mwitaa ti varuvaro Iesusiva Kotira nraamwu nronraqi mwakyaakya timwa nyi variqaro aakyara ntamwa kyero mwihua kyaparama nyatero tiqaro, Qutaa nkye ni ntapihi kyaarave? Qutaa nkye nte mwisaina nru okyarara ntapihi kyaarave? Qio hia nte ntena vu nraato tukyena nruvave. Ni titaiva mwiva qutaa kyaiqa vare varivave. Nkye hia mwia ntapihiarave. ");
INSERT INTO omw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nte mwia ntapihurave. Mwivama ni titaihana nte mwiva hinasaina tumuvave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iesusiva mwitaa tuvata mwi quara kyaara mwia ntavaaqavu kyaare tiqatavata hia qio mwia tu varora. Iesusira rukye entava hia nri ntovatara tita, mwihua hia qio mwia tu varora. ");
INSERT INTO omw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mwitaa huvata nraakye qora mwihuaqitaita airivanto Iesusirara qutaa mwivave tita. Mwihua mwataama tita, Iesusiva nronra kyaiqa vare variho. Mesaiaavanto nrianriva mwiva Iesusira kyaiqa qiove nraatara kyaananrove? Hia qio mwia nraatara kyaananrove. Iesusiva mwivama mesaiaavanto variho, tita. ");
INSERT INTO omw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisi vaisinramwuvanto variqata riovata nraakye qoravanto ntuvaantuama vita Iesusirara tirema kyeta mwitaa ti varuvata Parisi vaisinramwuvata, Kotira kyaiqa vara mwate varu vaisihua mwihua nronranramwuvata, mwihua nkyiari porisi sitovata mwihua Iesusira ntavaaqavu kyeta karavuqi kyarerata vita. ");
INSERT INTO omw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mwihua vuvaro Iesusiva tiqaro, Nte nkyi kyapata pataqia vari kyenama mwata mwaaqaataina ni titaiva hinani virerave. ");
INSERT INTO omw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mwi entara nkye ni puaama kyaare tira, hiama qio ni puaama kyevarave. Nkye hia qioqamakye virera hinani nte virerave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mwitaa tuvata Iutaa vaisi nronranramwuvanto nai kyapara hi nai kyapara hita tiqata, Mwiva taini viraqeve tire hia qio mwia puaama kyaananrave? Mwiva Kiriki mwatukya mponramwuqi Iutaa mponramwuvanto variananive uro qua timwa nyinrenro virerove? ");
INSERT INTO omw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mwiva nanrianra tiqaro, Nkye ni puaama kyaare tira hiama qio ni puaama kyevarave, tiho. Nkye hia qioqamakye virera hinani nte virerave, tiho. Mwiva mwitaa tiqaro nanra quave tiho? Hiama tire mwia qua ntapihita huro, tita. ");
INSERT INTO omw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mwitaa tuvaro omwata nro entava ekyaara enta nri ntora. Mwi entarara nronra entave tura. Ekyaara enta nri ntovaro Iesusiva mwi entaraqaa siviro paatiro tiqaro, Nramanri nraataa hiariva nte hunasairo qioma nrumu nraananrove. ");
INSERT INTO omw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kotira mpukuqi qara ntumwa to quava nianra mwitaama tiro: Nianra qutaa mwivave qiariva variraro mwia mwutukyaqitairo rumwu votima kyero qati variqi quani nramanriva ntamwaqiro quananrove, turave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesusiva siviro variqaro mwi quaraqaa ntumwa kyero Kotira mwanraqura nyianinranra tiro. Nraakye qoravanto Iesusirara qutaa mwivave tihua Kotira mwanraqura varerara tura. Mwi entara Iesusiva hia qutu viro qaiqaa qati siviro nyaamwuni vurara tiro, hia Kotira mwanraqura nyu entava vahura. ");
INSERT INTO omw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Iesusiva mwitaa tuvata nraakye qora ntuvaantuama vuhua airivanto tiqata, Qio qutaama Iesusiva poropetivanto variho. Kotiva mwia kyaahaqa hi variharo mwiva mwia qua ti variho, tita. ");
INSERT INTO omw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tuvata mponramwuvanto tiqata, Mwiva mesaiaavantove. Mwiva Kotiva titai vaisiva tiri kyaahaqa hiarivave, tita. Tuvata mponramwuvanto qaqao tita, Mesaiaavanto hiama Kaririqitairo nriananrove. ");
INSERT INTO omw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kotira mpukuqi mesaiaara qara ntumwa tova mwitaama tiro: Mesaiaavanto Ntevitira kuaa okyarama variraro Vetarahemi Ntevitiva varu mwatukyaraqi mwia mwata taananrove, turave, tita. ");
INSERT INTO omw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mwitaa tiqata nraakye qora ntuvaaquama vita varuhua hininramwuvanto Iesusirara qamwateqata varuvata hininramwuvanto hia mwianra qamwateqata varura. ");
INSERT INTO omw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hininramwuvanto Iesusira karavuqi kyarerata uti varura. Qio mwi entara hia mwihuaqitairo mpokuvanto Iesusira tu varora. ");
INSERT INTO omw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Porisi vaisinramwu vaakya sitohua nrumu ntanteta Kotira kyaiqa vara mwate varuhua mwihua nronranramwuvata, Parisi vaisinramwuvata, mwihua hunani uro ntovata mwihua tiqata, Qaqao, nkye mwia vita vareta nriataara vaihata nanraqamave qati nriavo? tuvata ");
INSERT INTO omw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","porisinramwuvanto tiqata, Tire riauraro mwiva hia qumina vaisivanto qua tintema kyero qua ti variho, tita. ");
INSERT INTO omw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tuvata Parisi vaisinramwuvanto tiqata, Qio nkyevata mwia unra quara qutaa quaveve tita hiavo? ");
INSERT INTO omw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nkye ntapihitave hiavo? Tavave tiri nronra vaisinramwuqitairove, Parisi vaisinramwuqitairove, Iesusirara qutaa mwiva mesaiaavanto variho tiho? Hiama tirinramwuqitairo mpovantovata mwitaa tiho. ");
INSERT INTO omw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Qati qumina nraakye qora ntuvaantuama vita variahua hia Mosesira qua mwaanra qio ntapihi riaarara tiro, mwia kyaara Kotiva mwihua qoraqama nyataananrove, tita. ");
INSERT INTO omw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Parisi vaisinramwuvanto mwitaa tuvaro Parisi vaisi mpokuvanto Nikotimaasiva mwiva entaqi Iesusira uro taqova, mwiva qaqao tiro, ");
INSERT INTO omw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Tire teta qua mwaanra rieqatama hia ko tiraitita, vaisiqaa qumina qua vataarorave. Tire ko nraanteta qiataarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mwitaa tuvata mwihua tiqata, E mpo? E Karirisaira nrianravave? E Kotira mpukuqi taqaante. E mwiqi taqairaro hiama Karirisairo poropeti vaisivanto qovara hiananrove, tita. ");
INSERT INTO omw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mwitaa timwa kyeta nkyiari nraamwuni nkyiari nraamwuni vuvaro Iesusiva Oripi taaqiqaa uro varura. ");
INSERT INTO omw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","2","Mwia qanranraa toqa entaqi Iesusiva uro ntantero Kotira nraamwu nronraqi vuvata nraakye qora airivanto ntuvaantuama vita varuvaro Iesusiva mwatakyaa viro variqaro qua timwa nyi varura. ");
INSERT INTO omw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Timwa nyi varuvata mwaanra okyara ti varu vaisihuavata, Parisi vaisinramwuvata, mwihua nraakye mpo vita vareta nrunra. Mwi nraakyeva vaati vataava mpo qoraisivata nrohi varuvata mwihua taqamwa kyeta mwia viteta Iesusiva hunani uro nraakye qora suqaa mwia kyovaro siviro varuvata mwihua Iesusirara tiqata, ");
INSERT INTO omw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mwaanra ti variarao, mwaa nraakyeva vaati vataava mpo qoraisi vatama kyero nrohi varihata tire mwia taqeta tu vareta nrunro. ");
INSERT INTO omw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesira mwaanra quavanto mwitaama tiro: Nrahesivanto mwitaa hirera, oriqotaita ntuqutu kyaivaro qutu quarive, turave. Qio e mpo? Nanra quave mwianra tinanrave? tita. ");
INSERT INTO omw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iesusirara api qua tiraqe tire mwiaqaa qua vataare tiqata mwihua mwitaa tuvaro Iesusiva hia qua tiraitiro, kakataama viro nai vukahiqo mwataqaa qara nti varura. ");
INSERT INTO omw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Qara nti varuvata mwihua sivita variqata mpo qua mpo qua Iesusira kyapara hi varuvaro Iesusiva mwaamwianra viro mwihuara tiqaro, Nkyiqitairo mpovanto hia uaqia hi kyaiqara utuariva, mwiva nraante ori vara kyero mwia ntuqutuarive, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iesusiva mwitaa timwa kyero mwiva qaiqaa kakataama viro mwataqaa qara nti varuvata ");
INSERT INTO omw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","mwihua mwi quara rieta kuaiqia kuaiqiavanto mwiqitaita qaqira kyeta veva nteqata vura. Nyaapainramwu nraante veva nteta vuni vuvata qaraakya vaisinramwu mwihua nraakiara veva nteta vita mwihua Iesusira mwini kyeta vuvaro Iesusiva nanrianraa variro. ");
INSERT INTO omw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesusiva mwaamwianra viro taqovaro mwi nraakyeva vaakya siviro varunani nanrianraa varuvaro Iesusiva tiqaro, Mwihua tainive variavo? Hiave mpovanto iqaa qua vataariva variho? tuvaro nraakye mwiva tiqaro, ");
INSERT INTO omw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nronrao, hia mpovanto mwitaa iho, tuvaro Iesusiva mwia timwa mwinro tiqaro, Qio ntevata hia iqaa qua vatarerave. Qio ena quante. Virava hiama nraakiara qaiqaavata uaqia hi kyaiqara utuante, tiro. Turama. ");
INSERT INTO omw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesusiva qaiqaa nraakye qora timwa nyinro tiqaro, Nte mwatanyaa omwavanto varuqo. Ni pataqiro nrianriva hiama kyokiraqi nrohiananrove. Mwiva ntuvaahaaninraqa nrohiqaro qati variqiro quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Iesusiva mwita tuvata Parisi vaisinramwuvanto tiqata, Qio e enanra variqara ena nrutu tuaahere variananranra tiro, i quavanto qumina quama vaiho, tita. ");
INSERT INTO omw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mwitaa tuvaro Iesusiva qaqao tiro, Nte variqana ntena kyaiqara tiqana hiama qumina qua tuqo. Nte ntena mwisaina nru okyarara ntapihi kyaurave. Nte ntena quani okyarara ntapihi kyaurave. Mwitaa hurara tiro, ni qua qutaa quama vaiho. Nte mwisaina nru okyararave, nte quani okyararave, nkye hia ntapihivarave. ");
INSERT INTO omw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nkye ko tiqatama nkye vaisi su nyaato vahiraqa ko ti variarave. Mate nte hia vaisi mpo ko timwa kyena mwiaqaa qua vatauqo. ");
INSERT INTO omw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nte ko qiataa hiraqena qioma nte ko avuqavuma kyena qianinrave. Nte ko tiqana hiama ntenanraa ko qianinrave. Nte ko qiariro ni kova ni titaiva variqaro ni kyaahaqa hiraqe nte avuqavuma kyena ko qianinrave. ");
INSERT INTO omw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nkyi mwaanra qua qara ntumwa tova mwitaama tiro: Vaisi taaratanavanto qua tiqatama kuaa qua nraahu tivera, qio mwitana quavanto qutaa quama vahiananrove, turave. ");
INSERT INTO omw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Qio nte ntena quara qutaa quave qiariro ni titaiva ni kova, mwivavata ni quara qutaa quave nraahuma qiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Iesusiva mwitaa tuvata mwihua tiqata, I qova tana variharave ti variaro? tuvaro Iesusiva tiqaro, Nkye hia ni ntapihi kyaahuara tita, nkye ni koravata hiama ntapihiavo. Nkye ni ntapihi kyaatirio, nkye qioma ni koravata ntapihiatirio, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesusiva Kotira nraamwuqi munima kye varuraqi variqaro mwi quara tiro. Tuvaro mwia rukye entava hia nri ntovarora tiro, hia mpovanto mwia ntavaaqavuqiro karavuqi kyora. ");
INSERT INTO omw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesusiva qaiqaa timwa nyinro tiqaro, Qio nte quarita nkye qumina nianra puaamaqi vita uro nkyeta qora kyaiqa rirante qati qutu vivarave. Mwitaa hiqata nte quaninrani nkye hiama qio vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mwitaa tuvata Iutaa vaisi nronra nramwuvanto tiqata, Mwiva nanra quave tiho? Mwiva nai tiqaro, Nte quaninrani nkye hia qio vivarave, tiho. Mwiva naivanto nai ru kyarero uti variqarove mwitaa ti variho? tita. ");
INSERT INTO omw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mwitaa tuvaro Iesusiva tiqaro, Nte virisaina tumuqata nkye mpiasaita nriahuave. Nkye mwaa mwataraqaataita nriahuave. Nte hia mwaa mwataraqaataina nruvave. ");
INSERT INTO omw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nte vaakya nkyiara tiqana, Nkye nkyeta qora kyaiqa rirante variqi vita qutu vivarave, turave. Nte qati nraahu variqi vuvave tuqo. Nkye hia mwi quarara qutaa quave tivera, qutaa nkye nkyeta qora kyaiqa mwia rirante qutu vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mwitaa tuvata mwihua mwia kyapara hita tiqata, Qio e ta vaisivave hiaro? Tuvaro Iesusiva mwihua timwa nyinro tiqaro, Nte vuni nkyi timwa nyuva nte mwivama huqo. ");
INSERT INTO omw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nte nkyiqa qua vataari quava, mpo qua mpo qua vaihana mate hia nte mwi quara tirerave. Ni titaiva ni timwa mpi quara, nte mwi quara nraahu mwatani varihuavata timwa nyinrenrave. Ni titaiva qutaa qua nraahu ti varivave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iesusiva mwitaa tuvata mwihua hia ntapihi kyeta Iesusiva nai qorara tu quara riora. ");
INSERT INTO omw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mwihua hia ntapihuvaro Iesusiva qaiqaa tiqaro, Nte mwatani mwatatai nraaqiaravama varuqo. Nte variarita nkye ni tuaahera kyaivaro mwiaqaatairo nkyi su nyaato ntapihirata nkye ni okyarara ntapihi rietama nianra qio mwiva qati nraahu variqiro vivave tivarave. Nkye mwi entarama nte hia ntenaqama kye mpo kyaiqa varaura ntapihita ni kova timwa mpi quara mwi quara nraahu timwa nyunravata ntapihivarave. ");
INSERT INTO omw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ni titaiva ni vatama kyero variqaro mwiva hia ni qaqira kyaananrove. Ni titaiva ni vatama kyero varihana nte mwia mwutukya vahi kyaiqara vare varuqaro mwiva nianra qamwateqaroma hia ni qaqira kyaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iesusiva mwi quara ti varuvata airivanto mwi quara riohua mwianra qutaave tita. ");
INSERT INTO omw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iutaa mponramwuvanto mwianra qutaa mwivave tuvaro Iesusiva mwihuara tiqaro, Qio nkye ni qua riemwaqita vivera, nkye qutaama ni pataqita nrihua varivarave. ");
INSERT INTO omw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nkye qutaa qua ntapihi kye riaivaro qutaa quavanto nkyi huvantu kyairata nkye qati varivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mwitaa tuvata mwihua qaqao tita, Tire teta haivaqara Evarahaamunra nraaqiarama varuro. Hia mpovanto tiri rupa taihata tire mwia kyaiqa vare varuro. Qio nanraqamave e tiriara nkyi huvantu kyairata nkye qati varivarave qiaro? tita. ");
INSERT INTO omw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Mwihua mwitaa tuvaro Iesusiva tiqaro, Nte qutaa quama tuqo, Nkye uaqia hi kyaiqara uti variavaro nkyi uaqia hi kyaiqava rupa taihatara tita, nkye mwia kyaiqa nraahu vare variavo. ");
INSERT INTO omw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nraamwu qova variraro rupataari vaisiva hiama ekyaa enta mwiavata variqiro quananrove. Nai mwia mwaaquvantoma mwiavata mwaakyota variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nte mwia mwaaquvanto nkyi huvantu kyaarita nkye qutaaqama kyeta qati varivarave. ");
INSERT INTO omw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nkye Evarahaamunra nraaqiara variara mwia nte ntapihi kyaurave. Mwitaama variqatavata nkye ni quara qumina quave timwa kyeta, ni ru kyarerata uti variavo. ");
INSERT INTO omw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nte ntena kokyantiri variqana mwi inraikyara taqaurara nkyi timwa nyi varuqo. Nkye nkyeta sora vatama kyeta variqata taqaa kyaiqara nkye mwi kyaiqarama vare variavo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Iesusiva mwitaa tuvata mwihua tiqata, Tiri tiqova Evarahaamuvave, tita. Tuvaro Iesusiva tiqaro, Nkye qutaa Evarahaamunra nraaqiara variatirio, nkye mwiva varo kyaiqarama nkyevata varaatirio. ");
INSERT INTO omw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kotiva qutaa qua tihana nte mwi quara riaura nkyi timwa nyuqata nkye ni ru kyarerata uti variavo. Evarahaamuva hia nkye hiante hurave. ");
INSERT INTO omw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nkye nkyeta sova varai kyaiqara nraahuma vare variavo, tiro. Mwitaa tuvata mwihua tiqata, Hia tire kyapa nraative. Tiri tiqova mwiva Kotivave, tita. ");
INSERT INTO omw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tuvaro Iesusiva tiqaro, Kotiva nkyi sova varitirio, nte mwiva hinasaina tumu nkyivata mate mwaa varura nianra nkyi mwutukya ntihata variatirio. Hia nte ntena vu nraato tukyena ntena kyaiqa vararerana tumuvave. Kotiva ni titaihana tumuvave. ");
INSERT INTO omw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nte mwitaa tuqata nkye nanraqamave ni qua hia ntapihiavo? Kyaivaqe nte nkyi timwa nyiankye. Nkye nte tu quara hia riaahuama variavo. ");
INSERT INTO omw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Saataaniva nkyi sova varihata nkye mwia mwutukya vahira nraahu utuqita vi variarave. Haaru vuniqama kyero Saataaniva variqaro vaisi rukye varuva nraahu varurave. Qutaaqama vahi inraikyavave, qutaa kyaiqavantove, hia mwiaqi vaiharora tiro, mwiva hia qutaa qua ti varirave. Mwiva unra tiqaro unra qiara mwia qova variqarora tiro, unra qua mwia nai qua tuananra tirave. ");
INSERT INTO omw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mwia kyaiqa mwitaama vaihana nte qutaa qua tuqata nkye ni quara hia qutaa quave ti variavo. ");
INSERT INTO omw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nkyiqitairo tavave nianra uaqiahi kyaiqara varaiho qiananro? Nkye hiama qio niqaa qua vatevarave. Nte qutaa qua ti varuqata nanraqamave nkye ni quara hia qutaa quvave ti variavo? Kyai nte nkyi timwa nyiankye. ");
INSERT INTO omw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kotira nraaqiaravanto Kotira qua rie varirave. Nkye hia mwia qua riaahuara tita, nkye hia mwia nraaqiarama variavo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Iesusiva mwitaa tuvata Iutaa nronranramwuvanto tiqata, Tire iara Sameriaanyaava ueraqama viho turava, mwi quava qutaa quama vaiho, tita. ");
INSERT INTO omw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tuvaro Iesusiva qaqao tiro, Hiama nte ueraqama vuqo. Nte ntena kora nrutu tuaahere varuqatama nkye ni nutu qoraqama mateta hiavo. ");
INSERT INTO omw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Qio hia nte ntena nrutuara nronraqama kyena riauqo. Ni nutu tuaaheraiva variho. Mwiva ntapihi kyero ko ti varivave. ");
INSERT INTO omw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nte qutaa qua qianinra riaate. Ni qua riemwaqiro quariva hiama qutu quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iesusiva mwitaa tuvata Iutaa nronranramwuvanto tiqata, Mwitaa qiarata tire i taqaurara e ueraqama quaro. Tiri haivaqava Evarahaamuva variqiro viro uro qutu vurave. Poropeti vaisi mpohua mpohua variqita vita ekyaa qutu vurave. Mwihua ekyaa qutu quavara e tiqara, Ni qua riemwaqiro nrohiariva hiama qutu quananrove, qiaro. ");
INSERT INTO omw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tiri tiqova Evarahaamuva nronra vaisivanto variqiro viro uro qutu vurave. E hia qio Evarahaamunranra tiqara, Nte mwia nraatara kyaarivave, tinanrave. Poropeti vaisinramwuvata nronra vaisi variqita vita uro qutu vurave. E nataa hira vaisiva varirera hiqarave mwitaa ti variaro? tita. ");
INSERT INTO omw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mwitaa tuvaro Iesusiva tiqaro, Nte ntena nrutu tuaahere variarirovauma ni nutuvanto qumina vahiananrove. Ni nutu tuaahera kye variva, mwiva ni kovave. Nkye mwianrama Kotiva tiri mwanriqavanto variho qiarave. ");
INSERT INTO omw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nkye hia mwia ntapihiarave. Nte mwia ntapihurave. Nte tiqana, Nte hia mwia ntapihi kyaurave, qiarirovauma ni quavanto nkyi qua votima kyero unra qua vahiananrove. Qio nte Kotira ntapihina mwia qua riemwaqina vuvave. ");
INSERT INTO omw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nte mwatani tuminrenra hiava entara nkyi haivaqava Evarahaamuva ni qamwata matorave. Nte mwatani tumuavaro mwiva ni taqovaro mwia mwutukyavanto kyuqe huvaro varurave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iesusiva mwitaa tuvata Iutaa nronranramwuvanto tiqata, Qaqao, e hia 50 ihi vara kyaraitira, qaraakya vaisivanto variqarama nte nkyi haivaqara Evarahaamunra taqaurave tira hiaro, tita. ");
INSERT INTO omw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tuvaro Iesusiva tiqaro, Haaru nkyi haivaqava Evarahaamuva hia varu entara nte qati variqina quavavave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iesusiva mwitaa tuvata mwihua ori vara kyeta mwia ntuqutirerata huvaro Iesusiva tuqeta kyero Kotira nraamwuqitairo veva ntero vurama. ");
INSERT INTO omw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesusiva viqaro taqovaro vaisi mpovanto nai nronra vikyokyaqitairo vu qipa vuva varura. ");
INSERT INTO omw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mwia taqeta Iesusira nraaqiaranramwuvanto Iesusira kyapara hita tiqata, Mwaanra ti variarao, tava Kotira qua nteqa kyairaqaarave mwi vaisira vu nai nronra vikyokyaqitairo qipa viho? Naive iho, mwia nrohua qohuave iho? tita. ");
INSERT INTO omw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mwitaa tuvaro Iesusiva qaqao tiro, Hiama nai Kotira qua nteqa kyairaqaarave, mwia nrohua qohua Kotira qua nteqa kyaaraqaarave, mwia vu qipa viho. Nkye mwi vaisiraqaataita Kotira kepukyavanto kyaiqa varaaninra taqaate tiro, mwia vu qipa virave. ");
INSERT INTO omw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kotiva ni titaira kyaiqa tire qaatataaninraqa varaqita virerave. Entama viraro hia mpovanto qio kyaiqa varaananrove. ");
INSERT INTO omw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nte mwatani variqana nte omwavanto itaintema kyena itamwaqina quarita mwatani varihua qio taqevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mwitaa timwa kyero Iesusiva mwataqaa taara vihi kyero horaqama kyero viti vu qipa vu vaisira vuqaa taaqau mwatero tiqaro, ");
INSERT INTO omw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Uto Siromi Rumpuaqi. Titai Nramanrinraqi ena viri hiqaante, tiro. Mwitaa tuvaro mwi vaisiva Iesusiva tuntema kyero uro nai viri hiqama kyovaro mwia vu ntapairi vuvaro mwiva mwisairo uro ntantero qio taqamwaqiro nrinro. ");
INSERT INTO omw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mwiva qio taqamwaqiro nri varuvata mwia nraaqani varuhua taqovaro aanra tokyani variqaro mwitaa inraikya mpiate ti varu vaisiva qati nruvata mwihua mwia taqeta tiqata, Mwaa ta vaisivave iho? Mwiva aanra tokyani mwatakyaa viro variqaro mwitaa inraikya mpiate ti vari vaisiva, mwaa mwivave iho? tita. ");
INSERT INTO omw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tuvata mpo uhua tiqata, Qio mwia mwivave, tita. Tuvata mpo uhua qaqao nai mpo vaisi mwia viri voti hivama nriho tita. Tuvaro mwi vaisiva nri ntero nai tiqaro, Nte mwaa mwivama iho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mwitaa tuvata mwihua mwia kyapara hita tiqata, Nataama kyaararo i vu ntapairi viharave e taqaaro? tita. ");
INSERT INTO omw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tuvaro mwiva mwihua timwa nyinro tiqaro, Vaisi mpo mwia nrutu Iesusiva taara vihi kyero horaqama kyero ni puqaa taaqau matero nianra tiqaro, Siromi rumpuaqi uto ena viri hiqaante, tihana nte uto hiqama kyauqaro ni pu ntapairi vihanama nte qio taqamwaqina nruqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mwitaa tuvata mwihua mwia kyapara hita tiqata, Mwiva taini viharave nrianro? tita. Tuvaro mwiva tiqaro, Nai tainive viho? Hia nte mwia taqauqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tuvata mwihua haaru vu qipa vu vaisira mwia vitaqita uro Parisi vaisinramwuvanto varunani kyora. ");
INSERT INTO omw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Iesusiva mwaanra entaqaa hora taaqau kyero mwi vaisira vu ntapairi kyora. ");
INSERT INTO omw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mwihua Parisi vaisinramwu varunani mwia uro kyovata Parisi vaisinramwuvanto mwi vaisira kyapara hita tiqata, Nataama kyaiharove i vuvanto ntapairi viho? tuvaro mwiva tiqaro, Mwiva hora vara kyero ni puqaa taaqau taihana nte uto ntena piri hiqama kyauqaro ni pu ntapairi vihana nte qio taqauqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mwiva mwitaa tuvata Parisi vaisi hini uhua tiqatama, Mwi kyaiqara varaiva mwaanraqa qua nteqeqaro varaivara tiro, mwiva hia Kotiva hinasairo tumivave, tita. Tuvata hini uhua tiqata, Qaqao, nataama kyerove uaqia hi vaisiva nronra kyaiqa mwia qio varaananrove? tita. Mwitaa timwa kyeta mwihua nkyiari utaqaa ntainra vita taara qua ti varura. ");
INSERT INTO omw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Qaiqaa Parisi vaisinramwuvanto mwia kyapara hita tiqata, E tiqara mwiva ni pu ntapairi kyaiho qiananrave. Mwi vaisirara e nanreve tinanrave? tuvaro mwi vaisiva tiqaro, Kotiva mwia kyaahaqa hi variharo mwiva mwi kyaiqara vare variho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mwitaa tuvata Iutaa vaisinramwuvanto hia mwia quara qutaave tiraitita, mwi vaisirara tiqata, E unra tiqarama ni pu ntapairi viho tira hiaro. Haaru hia i vuvanto qipa vurave, tita. Mwitaa timwa kyeta mwi vaisira nrohua qohua nyaanronra. ");
INSERT INTO omw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nyaanrovata nruvata mwitanahua kyapara hita tiqata, Mwaa vaisiva nkyitana nyaaquve iho? Qutaa mwia nai nronra vikyokyaqitairo vu qipa vurave? Nataama kyaiharove mwia vuvanto ntapairi viharo qio taqaiho? tita. ");
INSERT INTO omw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tuvata mwia nrohua qohua tiqatama, Mwaa vaisiva tiritana timwaaquve. Mwia vuvanto haaru vikyokyaqitairo qipa vurave. ");
INSERT INTO omw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nai nataama kyaiharove mwia vu ntapairi viho? Nai tavave mwia vu ntapairi kyaiho? Mwiva nronra tuaivama iho. Nkye nkyeta mwia kyapara hiqata taqaivaro mwiva qioma nkyita timwa nyiananrove, tita. ");
INSERT INTO omw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mwitanahua Iutaa vaisi nronranramwu nyaatu aatu hiqata mwitaa tura. Iutaa vaisi nronranramwuvanto vaakya qua timwa teta tiqatama, Vaisi mpovanto Iesusirara mesaiaavanto tiri kyaahaqa hiariva nrivave tirera, mwia kyaara tire mwia inronra hiqatama mwaanra nraamwuqitaita titamwa kyaararo veva ntero ekyaara quarive, tita. ");
INSERT INTO omw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mwitaa timwa kyeta qua timwa torara tita, mwia nrohua qohua Iutaa vaisi nronranramwu nyaatu aatu hita tiqata, Mwiva nronra tuairave. Nkyeta mwia kyapara hiqata taqaate, tura. ");
INSERT INTO omw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tuvata mwihua qaiqaa haaru vu qipa vu vaisira nraanrama kyeta tiqata, E Kotira vuqaa variqara qutaa qua nraahu qiante. Tire taqauraro Iesusiva Kotira qua nteqa kyai vaisivave, tita. ");
INSERT INTO omw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tuvaro mwi vaisiva tiqaro, Iesusiva Kotira qua nteqa kyai vaisivave iho kyuqe vaisive iho nte hia mwia okyara ntapihi kyauqo. Ni pu qipa vura ntapairi kyaira mwia nraahuma ntapihuqo, tiro. Tuvata mwihua mwia kyapara hita tiqata, ");
INSERT INTO omw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mwiva i nataave iho? Mwiva nataama kyerove i vu ntapairi kyaiho? tita. Tuvaro mwiva tiqaro, ");
INSERT INTO omw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nte mwi quara vaakya nkyi timwa nyuqata nkye hiave ntapihiavo? Nanraqamave nkye mwi quara qaiqaa kyapara hiavo? Nkyevata mpo? Nkyevata mwia nraaqiara varireratave qaiqaa mwi quara ni kyapara hiavo? tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tuvata mwihua mwia nronraqama kyeta inronra hita tiqata, Enama mwia nraaqiara variqara mwia qua riaaravave. Tire teta haivaqara Mosesira qua riemwaqita vurahuave. ");
INSERT INTO omw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kotiva Mosesirara qua timwa tora tire riemwaqita vunanrave. Iesusiva mwi vaisiva qumina vaisivantove. Tire hiama mwiva mwisairo nri okyarara ntapihuro, tita. ");
INSERT INTO omw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mwihua mwitaa tuvaro mwiva kyauqu ntukikinraaqata kyero tiqaro, Qikye, ni pu ntapairi matai vaisiva, mwiva mwisairo nri okyarara nkye hiave ntapihiavo? ");
INSERT INTO omw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tire ntapihi kyauraro Kotiva hia uaqia hi vaisira qua rie varirave. Kotiva nai qua rieqata nrohi varia vaisihua mwihua qua nraahu rie varirave. Mwia nrutu tuaahere variahua mwihua qua nraahu Kotiva rie varirave. ");
INSERT INTO omw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Haaru mwaa mwatara toharato entaraqaatairo hia vaisi mpovanto nai nronra vikyokyaqitairo vu qipa vura ntapairi kyorave. ");
INSERT INTO omw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Iesusiva hia Kotiva hinasairo tumiva hitirio, mwiva hiama qio ni pu ntapairi mataitirio, tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mwi vaisiva mwitaa tuvata mwihua tiqatama, I mwatatoraqaataira e uaqia hiara vaisivama variqira nrianro. E mpo? E tirivata mwaanra qua timwa timwinrenrave hiaro? tita. Mwitaa timwa kyeta mwihua vaisi mwia ntanrauqita mwaanra nraamwuqitaita veva mwaatani tuto kyora. ");
INSERT INTO omw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mwia tuto kyo quara riero Iesusiva mwi vaisira puaama kyero mwianra tiqaro, Mwatani mwatatai nraaqiarara e qutaa mwivaveve tira hiaro? tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tuvaro mwi vaisiva kyapara hiro tiqaro, Nronrao, mwiva ta vaisivave iho? E ni timwa mpiraqena nte mwianra qutaave qiankye, tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tuvaro Iesusiva mwia timwa mwinro tiqaro, E taqe variara vaisiva, nte mwaa mwivama iara ti varuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mwitaa tuvaro mwiva tiqaro, Nronrao, qutaama e mwivave, tiro. Timwa kyero mwiva Iesusira vuqaa tori kyauru raviro mwia qamwata mwatero varura. ");
INSERT INTO omw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mwitaa huvaro Iesusiva tiqaro, Nte nraakye qora tukya hirera mwatani tumuvave. Vu qipa vihua qaiqaa taqaate tina, tumuvave. Qati taqe varihua su qipa quarive tina, tumuvave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mwitaa tuvata Parisi vaisinramwuvanto mwi quara rieta Iesusira kyapara hita tiqata, Tiri tivuvatave qipa viho? tita. ");
INSERT INTO omw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tuvaro Iesusiva mwihua timwa nyinro tiqaro, Nkyi su qipa vihata variahua varivarovauma hia nkyiqa quavanto vahiananrove. Nkye ni okyara hia ntapihi kye taqaraitita, nkye tiqata, Tire Kotira okyara taqaunanrave, ti variarave. Mwitaa ti variarara tiro, mwia kyaara nkyiqa qua vahirove, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesusiva mpo quaqaa ntumwa kyero timwa nyinro tiqaro, Nte qutaa qua qianinra riaate. Vaisi mpovanto sipisipi vataa tutukyaraqi virero hia qesana vera ntaraitiro, tutukya mpona mwaati ntero vi vari vaisiva mwi vaisiva mpuara uti vaisivave, mpohua riqaro mwihuani mpuara vare vari vaisivama variho. ");
INSERT INTO omw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Vaisi mpovanto sipisipi qesana vera nteqaro vi variva, mwi vaisiva qutaa sipisipi qovama variho. ");
INSERT INTO omw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Qesaqaa vaimwanraanra ntaqikyi vari vaisiva mwia taqero qio qesa qatua mwataiharo mwiva nai sipisipiara aakyara nteqaro nai sipisipi nrutu ntamwaqiro vihata mwia sipisipinramwuvanto mwia qua ntapihi riaavaro mwihua sitero mwaaqani virave. ");
INSERT INTO omw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mwiva mwaaqani nai sipisipi uro kyero mwiva nraante vuni vi varihata mwia sipisipinramwuvanto nkyiari sora qua ntapihi kyeta rieqatara tita, mwia vataqita vi variarave. ");
INSERT INTO omw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mwia sipisipinramwuvanto hia mpo vaisi vataqita vivarave. Mwihua mpo vaisi qua hia ntapihi kyeta rieqatara tita, mwihua mwia nraatu aatu hiqata aatu vivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesusiva mwitaa timwa kyero sipisipiqaa ntumwa kyero timwa nyuvata mwihua mwi quara okyara hia ntapihiraitita varura. ");
INSERT INTO omw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hia ntapihuvaro Iesusiva qaiqaa timwa nyinro tiqaro, Nte qutaama tuqo. Nte sipisipi mwihua qesavantoma varuqo. ");
INSERT INTO omw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ni puni nria vaisihua mwihua mpuara utuahuave, mpohua riqata mwihuani mpuara vare variahua variavata sipisipivanto hia mwihua qua riaarave. ");
INSERT INTO omw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Utaqi qua qesava ntema mwi qesava varuqo. Niqaamatero nritaraani vaisira ni kova mwia vitaananrove. Niqaamatero tumitare nritare hiariva qioma kyara puaama kyero nraananrove. ");
INSERT INTO omw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mpuara varai vaisiva mpuara vareqaro sipisipi ru taiqa kyarero nrinrave. Nte sipisipiara rieqanama sipisipi mwihua qati variqita viqatama kyuqema kyeta variate tina, nte nruvave. ");
INSERT INTO omw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nte sipisipi qova kyuqevave. Sipisipi qova kyuqeva variqaro nai sipisipi rukyevorave tiqaro antuaqiro viro kyai nte mwihuara rieqana qutu quankye timwa kyero qutirave. ");
INSERT INTO omw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mpovanto hia sipisipi qova, mwiva qati kyaiqa vaisivanto variqaro taqaiharo qaakyau vairivanto nrihanro mwiva aatu hiqaro qaqira kyero hiantero viharo qaakyau vairivanto sipisipi rukyero hini ru sata kyaihata mwihua nkyiariara nkyariara mpona mpona quarave. ");
INSERT INTO omw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mwia kyaiqa vaisivanto qati kyaiqa vaisivanto variqarora tiro, mwiva hia sipisipiara nronraqama kyero riaraitiro, aatu virave. ");
INSERT INTO omw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nte sipisipi qova kyuqeva variqana nte ntena sipisipi ntapihi kyauqata ni sipisipinramwuvanto nivata ntapihi kyeta taqaarave. ");
INSERT INTO omw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Mwia votima kyero ni kova ni ntapihi kyaihana ntevata mwia ntapihi kyaurave. Qio ni sipisipi rukyevorave tina, nte mwihuara rieqana qutu virerave. ");
INSERT INTO omw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sipisipi mponramwu mwihua hia mwaa utaraqi varihua mwihuavata ni sipisipive. Mwihua ni qua riaivaqe nte mwihua sitaqina uro kyaarita ni sipisipi hini mwihuavata kuaaqi varivarave. Mwihua kuaaqi varivaqe nte mwihua sova kuaiqiavanto nraahu varianinrave. ");
INSERT INTO omw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nte mwihuara rieqana qutu vina qaiqaa qati siquaninrave. Nte mwitaa hianinranra tiro, ni kora mwutukyavanto nianra vaiho. ");
INSERT INTO omw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nte hia qiove qiariro mpovanto hiama qio ni rukyaananrove. Nte ntena qutu quataa hiraqena qutu quaninrave. Nte qutu quani okyararave, nte qaiqaa qati siquani okyararave, nina kyaiqa nraahuma vaiho. Ni kova nianra mwitaa mwitaa hiante ti quara, nte mwi quara vararerave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mwitaa tuvata Iutaa vaisi nronranramwuvanto mwi quara rieta utaqaa ntainra vita hininramwu mpo qua tuvata hininramwuvanto mpo qua tura. ");
INSERT INTO omw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Airivanto tiqata, Ueravanto mwiaqi variharo mwitaa tiho, Mwiva ueraqama viho. Nanraqamave nkye mwia qua riaavo? Hia mwia qua riaate, tuvata ");
INSERT INTO omw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","mponramwuvanto tiqata, Qaqao, ueraqa hiari vaisiva hiama qio mwi quara qiananrove. Ueravanto hiama qio vu qipa quani vaisira ntapaira kyaananrove, tita. Mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ierusaremini omwata mpo nro entava nri ntora. Kotira nraamwu qamwata mwato omwatava vahuvaro huarivanto hia nronraqama kyero ite varu entaraqaa mwi omwatara nronra. ");
INSERT INTO omw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mwi entaraqaa Iesusiva Kotira nraamwu nronraqi variqaro mpo rumuqi mwia nrutu Soromoninra rumuqi nrohi varuvata ");
INSERT INTO omw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iutaa vaisi nronranramwuvanto mwiqi ntuvaantuama vita Iesusirara tiqatama, E mpo qua vaakya tiri timwa timwiataarave. Taireve tiri timwa timwinanrave? E mesaiaavanto varirera, vutu kyera timwa timwinraqe tire riaare, tita. ");
INSERT INTO omw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tuvaro Iesusiva tiqaro, Nte vaakya nkyi timwa nyuqata nkye hia ni quara qutaa quave qiavo. Ni kova ni nronraqama kyaihana nte mwia kyaiqa vare varurave. Qio nte varau kyaiqava ni okyarara ntapihima ti variho. Nkye ni kyaiqa taqaarara rieqata ni okyarara ntapihiataarave. ");
INSERT INTO omw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nkye hia ni sipisipi variqatara tita, nkye hia ni quara qutaave tivarave. ");
INSERT INTO omw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nte ntena sipisipi ntapihi kyaurave. Mwihua ni qua rieqatama ni pataqita nrohi varivarave. ");
INSERT INTO omw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nte ekyaa enta qati variqi vira nyianrita mwihua hia qutu vivarave. Hiama mpovanto ni kyauquqitairo ni sipisipi ntavihi kyero varaananrove. ");
INSERT INTO omw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ni kova ni sipisipi mpitaiva, mwiva peqavanto ekyaa inraikya nraataraiva variqaro ni sipisipiqaa ntaqikyi variharora tiro, hia mpovanto mwia kyauquqitairo qio ntavihi kye varaananrove. ");
INSERT INTO omw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ntevata ni kovavata kuaikuvantoma varuro, tiro. ");
INSERT INTO omw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iesusiva mwitaa tuvata Iutaa vaisi nronranramwuvanto mwia ru kyaare tita, ori tu varovaro ");
INSERT INTO omw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iesusiva tiqaro, Nte ni kora kyuqe kyaiqa, mpo kyaiqa mpo kyaiqa nkyi nyaamwutauqata nanra kyaiqa varaura kyaarave nkye niqaa ori tuto kyarerata uti variavo? tiro. ");
INSERT INTO omw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tuvata Iutaa vaisi nronranramwuvanto tiqata, Tire hia i kyaiqa kyuqera kyaara i ru kyarerave. E Kotirara qora qua qiaro. E qati vaisivanto variqarama Kotikyantiri kuaaqaa varirera uti variaro. Mwia kyaarama tire ori vara kyeta i ru kyarerave, tita. ");
INSERT INTO omw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mwihua mwitaa tuvaro Iesusiva tiqaro, Nkye Kotira mpuku vataaraqi qua mpo qara ntumwa tova vaiho. Nkye hiave mwi quara taqaavo? Kotiva vaisi mpo uhuara mwitaama tiro: Nkye mwanriqavantove, turave. ");
INSERT INTO omw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tire ntapihi kyauraro Kotira qua hia unra qua vahirave. Kotiva nai qua tu vaisihua qati qumina vaisiara mwanriqavantove turave. ");
INSERT INTO omw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Qio Kotiva ni mwatama kyero ni titaihana nte mwatani tumu variqanama nkyiara nte mwanriqa Kotira mwaaquve tuqata nkye tiqata, Kotirara qora qua qiaro, qiavo. ");
INSERT INTO omw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nte hia ntena kora kyaiqa varaaritavauma nkye hia nianra qutaa mwivave tivarave. Nte ntena kora kyaiqama vare varuqo. ");
INSERT INTO omw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nkye hia nianra nronraqama kyeta riaivera, nkye nte kyaiqa vare varianinranra nronraqama kyeta rieqatama nianra qutaa mwivave qiate. Nkye mwitaa tivaro nkyi su nyaato ntapihirata nkye ni kova niqi varirara ntapihivarave. Nte mwiaqi varianinranra nkye ntapihivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mwitaa tuvata mwihua qaiqaa mwia karavu hirera uti varuvaro Iesusiva veva ntero viro. ");
INSERT INTO omw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Veva ntero vuva uro Iotaani nramanri hini tokyani Ioniva tauraa variqaro nramanri nyunani uro varura. ");
INSERT INTO omw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Varuvata airi nraakye qoravanto mwiva varunani nri nteta tiqata, Ioniva hia nronra kyaiqa varova variqaro Iesusirara tiri timwa timwunrave. Qio tire taqauraro Ioniva qutaa qua mwaa vaisirara timwa timwunrave, tita. ");
INSERT INTO omw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mwitaa timwa kyeta mwini varuhua airivanto Iesusirara qutaa mwivave tura. ");
INSERT INTO omw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Vaisi mpovanto mwia nrutu Rasarusiva Vetaaninyaava nronraqama kyero nriqa vuvaro varuvata mwia nrunratana Mariaavavata Mataavavata mwini varura. ");
INSERT INTO omw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariaava vahamwenra kyuqera Iesusiraqaa qu mwatero nai qiata kyaahiqotairo mwia kyuqu nruka mwataariva varura. Mwi nrunre nrakyetana variqata taqovaro mwihua sakyaava nriqa vuvaro varuvata ");
INSERT INTO omw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","mwitanahua vaisi mpo titeta Iesusirara uro mwitaama qiante tita, Nronrao, i mwutukya nti vaisiva nronraqama kyero nriqa viharo variho qiante, tita. ");
INSERT INTO omw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mwitanahua mwitaa timwa kyeta titovaro vevani uto timwa mwuvaro Iesusiva mwi quara riero tiqaro, Rasarusiva nronraqama kyero nriqa viharo variho. Qio mwiva hiama qutu quananrove. Nkye Kotira kepukya taqaate tiro, mwia nriqa viharo variho. Ni Kotira mwaaqu ni peqa okyara taqaate tiro, mwia nriqa viho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesusiva Mataararavata mwia nrunranravata Rasarusiraravata mpoqama kyero mwutukya ntuva variqaro ");
INSERT INTO omw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","mwi quara rierovata hia qamwanrama viraitiro, qaqira kyero taara entavata mwini varura. ");
INSERT INTO omw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Vari kyero mwiaqaatairo nai nraaqiaranramwuanra tiqaro, Qio varaivaqenramwu tumu ntante Iutiaani quare, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tuvata mwia nraaqiaranramwuvanto qaqao tita, Mwaanra ti variarao, nanauma Iutaa vaisi nronranramwuvanto ori vara kyeta i ru kyarerata uturave. E qaiqaa mwini tumu ntantera virerarave hiaro? tita. ");
INSERT INTO omw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tuvaro Iesusiva tiqaro, Mpo enta mpo enta huarivanto ihera qio itairave. Vaisivanto qaatatairaqaa nrohi variva huarivanto itairaqaa nrohiqaro aanra qio taqeqaro hia huntavaivaimaqiro kyaamwu ntirave. ");
INSERT INTO omw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Huarivanto hia itaiharo entaqi nrohi variva huntavaivaimaqiro kyaamwu nti varirave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mwitaa timwa kyero Iesusiva qaiqaa tiqaro, Tiri toti Rasarusiva vaitama viho. Nte uro mwia vaurama kyarerave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mwitaa tuvata mwia nraaqiaranramwu tiqata, Nronrao, mwiva qati vaite varirera, mwiva qioqa hiananrove, tita. ");
INSERT INTO omw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Mwitaa timwa kyeta mwihua hia ntapihuvaro Iesusiva mwi quaraqa ntumwa kyero Rasarusiva qutu vurara tura. Mwihua tiqata, Iesusiva Rasarusirara qati vaitairarama tiho, tita. ");
INSERT INTO omw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mwitaama rieqata varuvaro Iesusiva vutu kyero timwa nyinro tiqaro, Rasarusiva qutuma viho. ");
INSERT INTO omw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Qio nte nkyiara rieqanama nkye nianra qutaa mwivave qiate tina, nte Rasarusira hia qamwanrama uro taqaurara qamwateqama varuqo. Qio varaivaqenramwu mwiva qutu vinani quare, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tuvaro mwia nraaqiara mpovanto Tomaasiva, mwia mpo nrutu Kaapiva, mwiva nai hena vaisinramwuanra tiqaro, Qio varaivaqenramwu mwaanra ti vari vaisiravata quare. Iutaa nronranramwuvanto mwia ru kyaivaqe tirenramwuvata mwia vatama kyeta qutu quare, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tuvaro Iesusiva vuva uro ntero riovata Rasarusira quntamwa tovaro erahiamuaantema enta nritarora. ");
INSERT INTO omw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Vetaani Ierusaremi qaumato 3 kiromitaa votima mwiaqaatairo vahuvaro ");
INSERT INTO omw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ierusaremisaita mwi mwatanaahua airivanto Mariaaravata Mataaravata mwutukya qihaakyama nyateqata Rasarusirara ntatarerata nrunra. ");
INSERT INTO omw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nri varuvaro Mataava riovaro Iesusivavata mwisairo aanrani nri varuvaro mwiva Iesusira hunta kyarero viqaro Mariaara nraamwuqi kyero vuva uro ntero ");
INSERT INTO omw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Iesusirara tiqaro, Nronrao, e mwaini variaratiri, ni pakyaava hiama qutu vitirio. ");
INSERT INTO omw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Qio mate e Kotirara mpo inraikya mpo inraikyara nyaanru tiraro Kotiva mwi inraikyara qioma i mwiananrove. Nte mwia ntapihi kyauqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tuvaro Iesusiva mwia timwa mwinro tiqaro, I vakyaava qatima siquananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tuvaro Mataava tiqaro, Qio ekyaara entaqaa mwiva ekyaa nraakye qora kyapata siquananrove. Nte mwia ntapihi kyauqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tuvaro Iesusiva tiqaro, Nraakye qora qutu quahua qati vara sivuma kye varuva, nte mwaa mwivave. Nraakye qora qati variqi vi varia inraikyara nyi varuva nte mwaa mwivave. Nianra qutaa mwivave qiariva qutu viro mwiqitairo qati variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Qati variqiro viqaro nianra qutaa mwivave qiariva hiama qutu quananrove. E mwianra qutaaveve tira hiaro? tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tuvaro Mataava tiqaro, Qutaama tira hiaro. Mesaiaa Kotira maaquvanto mwatani tuminrenra hiarava, e qutaa mwivama hiaro, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mwitaa timwa kyero Mataava nrumu ntantero uro nai nrunra tirema kyero timwa mwinro tiqaro, Mwaanra ti vari vaisiva nri ntaiho. Mwiva iara kyapara iho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tuvaro Mariaava mwi quara riero siviro hiantero uro Iesusira hunta kyarero viro. ");
INSERT INTO omw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesusiva vaakya Mataava uro qua mwantonani variqaro hia mwatukyani nri ntovaro ");
INSERT INTO omw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mariaava mwia huntarero vuvata Iutaa nraakye qora mwia mwutukya qihaakyama mwatarerata nruhua taqovaro Mariaava nraamwuqitairo hiantero vuvata mwihua tiqata, Qio mwia quntamwa taanani ntatareraro virerove, timwa kyeta mwihuavata sivita Mariaara vata vareta vura. ");
INSERT INTO omw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mwihua Mariaara vata vareta vuvaro Mariaava vuva Iesusiva hunani uro ntero Iesusira taqero uro mwia vuqaa tumu ntiro variro tiqaro, Nronrao, e variaratiri, hiama ni pakyaava qutu vitirio, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tuvaro Iesusiva taqovaro mwiva ntate varuvata Iutaa nraakye qora Mariaaravata nruhua mwihuavata ntate varuvaro Iesusira mwutukyavanto qoraqama kyero nraamwunruqa tovaro mwiva po kye tiro tiqaro, ");
INSERT INTO omw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mwia taraqive quntamwa teta hiavo? tuvata mwihua tiqata, E nrinra uro taqaante, tuvaro ");
INSERT INTO omw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesusiva ntate varura. ");
INSERT INTO omw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ntate varuvata Iutaa nraakye qoravanto tiqata, Qio taqaate. Mwiva mpoqama kyero Rasarusirara mwutukya ntiharo variho, tita. ");
INSERT INTO omw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tuvata mponramwuvanto tiqata, Mwiva vu qipa vi vaisiravata qio ntapairi kye varivave. Iesusiva mwaini varitirio, Rasarusiva qutuve vitirio, hiave qutu vitirio? tita. ");
INSERT INTO omw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tuvaro Iesusira qaiqaa ua huvaro mwiva mwia quntamwa tonani vura. Mwihua ori vaurutoraqi Rasarusira veta vateta ori mpo vara kyeta qesana tita torara tiro, Iesusiva tiqaro, ");
INSERT INTO omw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ori mwia qatinani vara kyaate, tuvaro Mataava qutu vu vaisira nrunravanto qaqao tiro, Mwia quntamwa taavaro erahiamuaantema enta nritaraiharo ntera viva mwuntama quananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Tuvaro Iesusiva Mataarara tiqaro, Nte vaakya i timwa mwu quarara riaante. E nianra qutaa mwivave tirera, e Kotira peqa taqenanrave turave. Hiave nte vaakya iara mwitaa tina huqo? tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tuvata mwihua ori qatinani venta kyovaro Iesusiva virini taqero tiqaro, Ko, e nte tu quara rie variananra nte mwianra kyuqeve tuqo. ");
INSERT INTO omw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","E ekyaa enta ni qua rie variananra nte ntapihi kyaurave. E ni titaananranra nraakye qoravanto ntapihiate tina, nte mwihuara rieqanama iara aakyara tuqo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesusiva mwitaa timwa kyero mwiva aakyara ntero tiqaro, Rasarusio, sivira veva ntaante, tuvaro ");
INSERT INTO omw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Rasarusiva qutu vuva qati siviro mwia kyuqu kyauqu ququtama teta mwia qiatavata tavunaqo qapuqamatova mwiqitairo veva ntero. Veva ntovaro Iesusiva mwihua timwa nyinro tiqaro, Mwia huvantu kyaivaro qati quarive, tura. ");
INSERT INTO omw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tuvata Iutaa nraakye qora airivanto Mariaara taqarerata nruhua mwi kyaiqara taqeta Iesusiva qio qutaa mwivave, tita. ");
INSERT INTO omw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tuvata mponramwuvanto qaqira kyeta Iesusiva mwi kyaiqara varorara uro Parisi vaisinramwu timwa nyuvata ");
INSERT INTO omw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Parisi vaisinramwuvata, Kotira kyaiqa vara mwate varu vaisihua mwihua nronra vaisinramwuvata, mwihua nkyiari kaanasori vaisi kyapata ntuvaantuama vita tiqata, Mwi vaisiva mpo kyaiqa mpo kyaiqa nronra kyaiqa vare variho. Qikye, tire mwia nataamave kyaananrave? ");
INSERT INTO omw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tire mwia qati kyaarera, mwiva mwitaamaqiro virata ekyaa nraakye qora mwianra qutaa mwivave tivarave. Mwihua mwitaa tivata tiriqaa ntaqikyi variahua Romenivanto tiri ntaqiqata Kotira nraamwu ntapairi kyeta tiri nraakye qora ekyaa ru taiqa kyevarave, tita. ");
INSERT INTO omw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tuvaro mwi vaisinramwuhuaqitairo mpovanto mwia nrutu Kaiapaasiva siviro. Kaiapaasira mwia nronraqama kyovaro mwi ihiraqi Kotira kyaiqa vara mwate varu vaisihuaqaa ntaqikyiqaro vunyaa vaisivanto varuva, mwiva siviro tiqaro, Hia nkye vu nraatovata vahihuave. ");
INSERT INTO omw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Romeni mwatanaahua tiri ekyaa ru taiqa kyevorave. Tiri kyaahaqa hirero vaisi kuaiqiavanto nraahu qutu viraro kyuqe hiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapaasiva mwi quara tiqaro nte ntena nraato tukyena tuqo, tiro. Mwiva hia ntapihi kyovaro Kotiva mwia kyaahaqa huvaro mwiva Iesusiva Iutaa nraakye qorara rieqaro qutu quaninranra tura. ");
INSERT INTO omw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Iesusiva hia Iutaa mwatanaahuara nraahu rieqaro qutu quariva varura. Kotira nraaqiara ekyaa mpoqi mpoqi apiqama varihua mwihuavata sita kyero uro kuaaqi ntuvaantuama tarero Iesusiva qutu quariva varura. ");
INSERT INTO omw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","(Kaiapaasiva tiqaro, Vaisi kuaiqiavanto tiri Iutaa kyaahaqa hirero qutu viraro kyuqe hiarive, tuvata) mwi entaraqaataita Iutaa nronra vaisinramwuvanto Iesusira rukyerara timwaqita vura. ");
INSERT INTO omw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mwitaa ti varuvarora tiro, Iesusiva Iutaa mwatani hia qoqaa nrohiraitiro, qaqira kyero uro Eparaimi mwatukya qumina mwata tokyani uro nai nraaqiaranramwu kyapata varura. ");
INSERT INTO omw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mwini varuvaro Iutaavanto vekyahu nyato kyarara omwata nro entava qaumaqa huvata hisai hisaita nraakye qora verara nronra mwatukya Ierusaremini nraahu vura. Mwini uro variqata nronra enta mwia vekya variqata mwihua nkyiari mwaanra qua rieqata nramanri ntumwa kyeta tuapakyaara hiqama kyeta varura. ");
INSERT INTO omw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mwihua mwini variqata Iesusirara aitutumaqita nrohiqata uro Kotira nraamwu nronra nraamwuqi ntuvaantuama vita nai kyapara hi nai kyapara hita tiqata, Iesusiva qiove nrumu omwata nraananrove? Mwiva aatu hiqaro hiave nriananrove? tita. ");
INSERT INTO omw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mwitaa ti varuvata Parisi vaisinramwuvantovata, Kotira kyaiqa vara mwate varu vaisihua mwihua nronranramwuvantovata, mwihua nraakye qora timwa nyita tiqata, Nkye taqaivaro Iesusiva nrinrenra nkye nrumu tiri timwa timwivaqe tire mwia rupaqi karavuqi kyaare, tura. ");
INSERT INTO omw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Vekyahu nyato kyarara omwata nro entava qaumaqa huvaro 6 entanramwu qati vahuvaro Iesusiva qaiqaa Vetaani mwini Rasarusiva varunani vura. Rasarusira mwia haaru qutu vura Iesusiva qaiqaa qati sivuma kyo vaisiva varura. ");
INSERT INTO omw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mwini vuvata mwi mwatanaahua Iesusirani kyara uta mwatovaro Mataava mwi kyarara varaqiqaro uro nyuvaro Rasarusiva Iesusikyantiri kyara tainta mwia tataaqa mwatakyaa viro varura. ");
INSERT INTO omw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Varuvaro Mariaava taqu mpo varero nrunra. Mwi taquraqi nronra munima kyo vahamwenranra mwia nrutu naanti vahuvaro Mariaava mwi taqura varero mwi vahamwenranra Iesusira kyuquqaa qu mwatero mwiaqaatairo nai qiata kyaahiqotairo Iesusira kyuqu nruka mwatovaro vahamwenra kyuqe hu mwuntava nraamwu mwia piqa kyora. ");
INSERT INTO omw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Piqa kyovaro Iesusira nraaqiaranramwuqitairo mpovanto Iutaasi Isikeriotiva Iesusira qovarama kyaariva, mwiva qaqao tiro, ");
INSERT INTO omw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Mwi vahamwenranra mpohua nyinro munima 300 kinaa vara kyero mwi munimanra vehi nraakye qora nyiataara vaiharoma, qumina i kyuquqaa qu mwatero iho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Iutaasiva hia vehi nraakye qorara riaraitiro, mwiva mpuara vaisivanto variqarora tiro, mwitaa tura. Mwiva Iesusira nraaqiaranramwu munima tuaqa ntaqikyiqaro mwi tuaraqitairo tuqeta kyeqaro mwinramwuhua munima mpuara vare varura. ");
INSERT INTO omw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iutaasiva tiqaro, Munima mwia vehi nraakye qora nyiataara vaiharoma qumina i kyuquqaa qu mwataiho, tuvaro Iesusiva tiqaro, Hia mwi nraakyera antuaante. Mwiva vahamwenra niqaa qu mateqaro ni quntamwa te entarara ni mamanta terama mate variho. ");
INSERT INTO omw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Vehi nraakye qora mwihua ekyaa entama nkyivata variqita vivarave. Nkye qati entaqaa mwihua qio kyaahaqa hivarave. Nte hiama nkyivata ekyaa enta variqina quaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Iesusiva mwitaa timwa kyero varuvata Iutaa airivanto riovaro Iesusiva Vetaani mwini varuvata mwihua Iesusiravata Iesusiva qati sivuma kyo vaisira Rasarusiravata taqarerata uto Vetaanini kuaira hita varura. ");
INSERT INTO omw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Iutaa airivanto Rasarusira qati sivuma kyorara rieqatama nkyiari nronra vaisinramwu qaqira kyeta uto Iesusirara qutaa mwivave ti varuvata mwia kyaara Kotira kyaiqa vara mwate varu vaisihua mwihua nronranramwuvanto Rasarusiravata rukye quara ti varura. ");
INSERT INTO omw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mwia qanranraa nraakye qora airivanto vekyahu nyato kyarara nranrenrata nruhua riovaro Iesusiva Ierusareminianra aanrani nri varura. ");
INSERT INTO omw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nri varuvata mwihua mwia qamwata mwatarerata qatokya mwanre voti hura teqa vareta Iesusira hunta kyarerata viqatama mwihua aakyara nteta tiqata, Kyai mwia nrutu tuaaheraare. Nronravanto nai nrutuqa nri vari vaisira kyuqema mwataiho. Tiri Isareriqaa ntaqikyi vaisira Kotiva kyuqema mwataiho, tita. ");
INSERT INTO omw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mwihua mwitaa timwaqita vuvaro Iesusiva qaraakya ntonki puaama kyero Kotira mpukuqi tuntema kyero mwia mwoqaqa mwatakyaa viro variro Ierusaremiqiara viro. Haaru Kotira mpukuqi mwianra mwitaama tiro: ");
INSERT INTO omw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Saioniqinaahua (Ierusaremiqinaahua), nkye hia aatu hiate. Taqaate, nkyiqa ntaqikyiariva nriqanroma mwiva qaraakya ntonki mwoqaqa nri variho, tura. ");
INSERT INTO omw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mwi quava mpukuqi vahuvata mwi entara Iesusira nraaqiaranramwuvanto hia mwi quara okyara ntapihura. Nraakiara Iesusiva qutu viro qaiqaa sivu entaraqaa mwi quava mwihua nyaatoqi ntumwa vuvata mwihua tiqata, Mwi quava Iesusiva ntonki mwoqaqa Ierusaremini vurara turave, tura. ");
INSERT INTO omw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iesusiva Rasarusira oriqi quntamwa toraqitairo nraanrama kyero mwia qati vara sivuma kyovata nraakye qora mwini Iesusiravata varuhua mwi kyaiqara taqeta mpohua mpohua timwa nyuvata ");
INSERT INTO omw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","mwiaqaataita nraakye qora airivanto Iesusiva nronra kyaiqa mwia varorara rieqata Iesusira uto hunta kyora. ");
INSERT INTO omw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mwihua Iesusira qamwata mwatarerata vuvata Parisi vaisinramwu nai timwa mwi nai timwa mwi hita tiqata, Qio taqaate. Tire hiama qio mpo qara hiara aanrava vaiho. Ekyaahua mwia nraahuma vataqita vi variavo, tura. ");
INSERT INTO omw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kiriki mponramwuvanto (mwihua Iutaa mwaanra qua riohua) mwihuavata mwi omwatara nreqatama Kotira nrutu tuaaherarerata Ierusaremini uro varura. ");
INSERT INTO omw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Uro variqata mwihua Iesusira nraaqiara mpo Piripira Vetasaitaa mwatukya Karirinyaanranra tiqata, Tiri vaisio, tire Iesusira taqarerave, tuvaro ");
INSERT INTO omw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Piripiva uro Entururavata timwa mwinro mwiva vatama kyero uro Iesusira timwa mwunra. ");
INSERT INTO omw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Timwa mwuvaro Iesusiva tiqaro, Nte mwatani mwatatai nraaqiaravave. Ni nutu nronraqama quari entava nri ntaiho. ");
INSERT INTO omw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nte qua qianinra riaate. Uiti uru hia mwataqi vara tutairaro uiti uru mwiqiava nanrianraa vahiananrove. Uiti uru mwataqi vara tutairaro ntuko hiro turu vera kyairaro mwiaqaatairo uru mwiva taiqa quananrove. Uru mwiva taiqa viraro uiti mwiva qupiqeqaro airi tamwa riaananrove. ");
INSERT INTO omw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Qio vaisi mpovanto mwaa mwataraqaa nai qati variqiro quaninranra nraahu nronraqama kyero riemwaqiro quariva, mwiva ekyaarama qutu quananrove. Vaisi mpovanto hia nai mwaa mwataraqaa qati variqiro quaninranra nronraqama kyero riemwaqiro quariva, mwi vaisiva ekyaa enta qatima variqiro quananrove. ");
INSERT INTO omw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tahuave ni kyaiqa varaataa hiarihua, mwihua qati varivorave. Mwi vaisihua ni pataqita nriate. Mwihua mwitaa hiqata nte varianinrani mwihuavata varivarave. Mwihua mwitaama kyeta ni kyaiqa vara mate varivaro ni kova mwihua nyutu nronraqama kyaananrove. ");
INSERT INTO omw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Qio mwaa entara ni mutukya uaqia ihana varuqo. Ntena korara nanra quave qianinrave? Ko, mwi entava nri ntaankyora mwi entara qaqira kyaante. Mwitaave Kotirara qianinrave? Qaqao, nte hia mwitaa tirerave. Nte mwi entarara rieqana tumuvave. Mwi entaraqaa nte atura ntumwaqina quankye timwa kyena tumuvave. ");
INSERT INTO omw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ko, e ena nrutu nronraqama kyaante, tiro. Iesusiva mwitaa tuvaro nyaamwusairo quavanto tiqaro, Nte ntena nutu nronraqama kyauqo. Qaiqaavata nronraqama kyarerave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tuvata nraakye qora ntuvaantuama vita mwini sivita varuhua mwi quara rieta tiqata, Nyaanruva nruqua tiho, tuvata hini uhua tiqata, Qaqao, nyaamwunyaa vaisivanto mwiavata qua tiho, tita. ");
INSERT INTO omw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tuvaro Iesusiva tiqaro, Hia mwiva nianra rieqarovauma qua tiho. Mwiva nkyiara rieqaroma qua tiho. ");
INSERT INTO omw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Qio mwaa entara mwatani varihua ko qiani entarave. Mwaa entara mwatani variahuaqaa ntaqikyi varira Saataaninra peqa ntuvuraa kyaani entarave. ");
INSERT INTO omw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mwatasaita ni tuaahera kyaivaqe nte variqana ekyaa nraakye qora ntanrau kyaarita mwihua nte hianinrani nraahu nrivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesusiva mwi quara tiqaro nai qutu quaninranra timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mwitaa tuvata mwini ntuvaantuama vuhua qaqao tita, Kotira mpukuqi qara ntumwa tova tiqaro, Kotira kepukya vaisi mesaiaavanto ekyaa enta qati variqiro quananrove, turave. Nanraqamave e tiqara, Ni mwatani mwatatai nraaqiarara tuaahera kyevarave, qiaro? (E ena qutu vinanranra qiana quara hia ntapihuro.) E tiqara, Ni mwatani mwatatai nraaqiaravave, qiananrave. E ta vaisivave hiaro? tita. ");
INSERT INTO omw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tuvaro Iesusiva tiqaro, Pataqia omwavanto nkyi kyapata variqaro itamwaqiro quananrove. Kyokiraqi nrohiva hia nai vi aanranra ntapihirara tita, nkye kyokira ruquankyo tita omwavanto qati ite variani entaraqaa nrohiqata variate. ");
INSERT INTO omw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Omwavanto qati vahiani entaraqaa nkye mwi omwanranra qutaa mwivave timwa kyeta, mwianra riemwaqi viqatama nrohiate. Mwitaa tiqatama nkye omwa nraaqiara variqatama nkyevata omwavanto itaintema kyeta itamwaqita vivarave, tiro. Iesusiva mwi quara timwa kyero mwiaqaatairo uro hia mwihua suqaa variraitiro, uqeta varura. ");
INSERT INTO omw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesusiva mwihua suqaa variqaro nronra kyaiqa varovata mwihua taqetavata mwihua qaqira kyeta hia mwianra qutaa mwivave tuvarora tiro, ");
INSERT INTO omw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","mwi entara Aisaiaava haaru tu quava qutaa vahura. Haaru Kotiva vaisi mpo Aisaiaara kyaahaqa huvaro Aisaiaava poropeti vaisivanto variqaro qumina vakya mwaa quara vutu kyero tiqaro, Nronrao, tavave tiri quara qutaave tiho? Hia mpovantovata qutaave tirave. Nronravanto nronra kyaiqa vara kyaiharo tavave mwia kyaiqa ntapihi taqaiho? Hia mpovantovata ntapihi kyero taqaiho, tura. ");
INSERT INTO omw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Aisaiaava mwitaa turara tita, mwihua hia Iesusirara qutaa mwivave tura. Aisaiaava qaiqaa mesaia mwianiara tiqaro, ");
INSERT INTO omw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Mwi vaisihua uaqia hi aanranra qaqira kyeta nianra tiri kyaahaqa hiante tivorave timwa kyero, Kotiva mwihua su nyaato tita kyaihata mwihua hia vuqotaita qio taqeta, mwihua hia nraatoqotaita qio riaavo, tura. ");
INSERT INTO omw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiaava haaru variqaro Iesusira peqa okyara taqeqarora tiro, mwiva mwianra qua timwa nyunra. ");
INSERT INTO omw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mwi entara Iutaa nronra vaisinramwuqitaita mponramwuvanto tiqata, Qutaama Iesusiva mwivave, tita. Mwihua mwitaa tiqata mwihua Parisi vaisi nyaatu aatu hita qaqira kyeta hia qoqaa variqata mwi quara tita. Mwaanra nraamwuqitaita veva nteta quate tivorave tita, hia mwihua qoqaa variqata mwi quara tura. ");
INSERT INTO omw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Qati vaisivanto qamwata nyaterara nraahu mwihua nronraqama kyeta rieqatama hia Kotiva qamwata nyataaninranra nronraqama kyeta riora. Mwihua mwianra nraahu riohuara tita, mwihua hia qoqaa Iesusirara qutaa mwivave tura. ");
INSERT INTO omw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iesusiva paatiro timwa nyinro tiqaro, Nianra qutaa mwivave qiariva hiama nianra nraahu qutaave qiananrove. Mwiva ni titairaravatama qutaave qiananrove. ");
INSERT INTO omw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Vaisivanto ni taqeqaro ni titairavatama taqaananrove. ");
INSERT INTO omw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nianra qutaa mwivave qiariva kyokiraqi nrohiankyo tina, nte omwa votima kyena itamwaqina virera mwatani tumuvave. ");
INSERT INTO omw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nte hia mwatani varihuaqa qua vatarerana tumuvave. Mwatani varihua kyuqema variate tina, nte tumuvave. Ni qua riero nteqa kyaariva variraqe hia ntevauma mwiaqaa qua vataaninrave. ");
INSERT INTO omw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ni qoririma mataani vaisiraqaave, ni qua nteqa kyaani vaisiraqaave, hiama nte qua vataaninrave. Nte timwa taani quava, mwivama ekyaara entaqaa variqaro mwiaqaa qua vataananrove. ");
INSERT INTO omw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nte hia ntena nraato tukyenavauma qua nkyi timwa nyuqo. Ni kova mwitaa mwitaa qiante timwa kyero ni titaihana nte mwia qua nkyi timwa nyuqo. ");
INSERT INTO omw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nte ntapihi kyauqaro ni kora qua riaariva ekyaa enta qati variqiro quananrove. Qio ni kova mwitaa mwitaa qiante ti quara, nte mwi quara nkyi timwa nyuqo, tiro. Iesusiva mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Vekyahu nyato kyarara omwata nro entava kuaa enta nraahu qati vahuvaro Iesusiva variqaro ntapihi kyovaro nai mwata mwaini kyero tumu ntantero nai qova varinani quari entava qaumato vahura. Mwitaa huvaro Iesusiva variqaro nai huhua mwatani varuhuara mpoqama kyero mwutukya vahuvaro mwihuara rieqaro varura. Mwiva mwihuara mwutukya vahuva qati nraahu vahiqiro vuvaro uro qutu vura. ");
INSERT INTO omw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Entama vuvaro Iesusiva nai nraaqiaranramwu kyapata kyara nre varuvaro mwia nraaqiara mpovanto Iutaasi Isikeriotiva Saimoninra mwaaquvanto varuvaro Saataaniva Iesusira qovarama kyaante tiro, Iutaasira mwia nraatoqi qora qua vatovaro Iutaasiva Saataaninra qua riora. ");
INSERT INTO omw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Riero varuvaro Kotiva ekyaa inraikya Iesusira kyauquqi vatora Iesusira vu nraatoqi vahuvaro mwianra ntapihi kyero. Iesusiva Kotiva hunasairo tumuva qaiqaa Kotiva hunani quaninra mwianravata mwiva ntapihi kyora. ");
INSERT INTO omw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mwiaqaatairo mwiva kyara nro taintaraqaatairo siviro verato ututo tuavaaqara ntahuku kyero vatero tauri tavaarana rupatero uro ");
INSERT INTO omw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","tanuqi nramanri rauru kyero varero uro nai nraaqiaranramwu kyuqu hiqama nyatero tauri tavaarana rupatoraqotairo aahara tu nyatero. ");
INSERT INTO omw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mwitaamaqiro viro Saimoni Pitaava hunani nri ntovaro Pitaava qaqao tiro, Nronrao, e ni kyuquvatave hiqama matarera uti variaro? tuvaro ");
INSERT INTO omw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesusiva tiqaro, Mate nte mwaa kyaiqara varaura e hia ntapihiaro. Nraakiara mwianra qio ntapihinanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tuvaro Pitaava tiqaro, Qaqao, e nronra vaisivanto variqara haunri mwitaa hi kyaiqara ni vara materavaare. E hiama ni kyuqu qio hiqenanrave, tiro. Tuvaro Iesusiva tiqaro, Hia nte i kyuqu hiqama mwataankyera, e hiama ni nraaqiara varinanrave, tiro ");
INSERT INTO omw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mwitaa tuvaro Saimoni Pitaava tiqaro, Nronrao, mwitaa hirara e hia ni kyuqu nraahu hiqama mataante. Ni kyauquvata ni qiatavata hiqama mataante, tiro. ");
INSERT INTO omw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tuvaro Iesusiva tiqaro, Nramanri ntumwa taariva hiama qumina qaiqaa ntuananrove. Mwiva nai kyuqu nraahuma hiqaananrove, tiro. Nkye ekyaa nramanri ntumwa kye kyuqema variavaro kuaikuvanto nraahu hia kyuqema variho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesusiva nai nraaqiara mpovanto mwia qovarama kyaaninra ntapihi kyerora tiro, mwiva tiqaro, Nkye ekyaa kyuqema variavaro kuaikuvanto nraahu hia kyuqema variho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Mwitaa timwa kyero mwihua kyuqu hiqama nyatero Iesusiva qaiqaa uro nai tuavaaqa ntahuku kye vatora vara utu varero uro nai varura qoqaraaraqaa mwatakyaa viro variro timwa nyinro tiqaro, Nte mwataa hi kyaiqara nkyi vara nyataura nkye qio mwianra ntapihitave hiavo? ");
INSERT INTO omw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nkye nianra nronra vaisi mwaanra ti variaravave qiarave. Nte mwitaama varurara tita, nkye qioma nianra mwitaa tivarave. ");
INSERT INTO omw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Qio nte nkyi nronra vaisi mwaanra ti varuva variqanama nte nkyi mwataa kyaiqa vara nyateqanama nkyi kyuqu hiqama nyatauqo. Nkyevata variqata nte huntema kyeta nai kyuqu nai kyuqu hiqama nyateqata variate. ");
INSERT INTO omw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nkye nte hunte hiate tina, nte nkyi mwi kyaiqara nyaamwu tauqo. ");
INSERT INTO omw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nte qutaa qianinra nkye riaate. Kyaiqa vaisivanto hia nai nronra vaisi nraatara kyairave. Mpo inrakyara titaiharo vi vaisiva hia nai titaira mwia nraatara kyairave. ");
INSERT INTO omw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nkye mwi quara okyara ntapihi kyeta rieta mwi kyaiqara mwitaama kye varaqi vivera, nkye qamwateqatama variqi vivarave. ");
INSERT INTO omw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Qio hia nte nkyi ekyaahuara tuqo. Nte ntena mwatama tau nraaqiarahua qio ntapihi taqaurave. Nte mwihua okyara ntapihi kyaurave. Haaru Kotira mpukuqi qua mpo qara ntumwa tova mate qutaa mwivauma vahiananrove. Mwi quava mwitaama tiro: Vaisi mpovanto nivatama kyero variqaro ni kyara nrenro mwiaqaatairo tuqasaa viro ni qoraqama mataananrove, turave. ");
INSERT INTO omw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nkyiqitairo vaisi mpovanto ni qoraqama mataaninranra nte mate nkyi timwa nyi varuqo. Mwiva nraakiara ni qoraqama matairata nkye variqata mate nte timwa nyunranra rieqatama qio nianra mwiva qutaama qati nraahu variqi vivave tivarave. ");
INSERT INTO omw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nte qutaa qianinra nkye riaate. Vaisi mpovanto nte titaani vaisira qamwata mwateqaro mwiva nivata qamwata mataananrove. Mwiva ni qamwata mateqaro Kotiva ni titairavata qamwata mwataananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesusiva mwitaa timwa kyero varuvaro mwia mwutukyavanto uaqia huvaro mwiva vutu kyero mwihua timwa nyinro tiqaro, Nte qutaa qianinra riaate. Nkyiqitairo mpovanto ni rukyaate tiro, uro timwa nyiananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mwitaa tuvata mwia nraaqiaranramwuvanto nai taqe nai taqe hita airi nraato tita tiqata, Iesusiva ta vaisirarave tiho? tita. ");
INSERT INTO omw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mwitaa ti varuvaro mpovanto Iesusira mwutukyavanto mwianra mpoqiavata vahu vaisiva Iesusira nraaqani varuvaro ");
INSERT INTO omw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimoni Pitaava mwianra nru nraata kyero tiqaro, E Iesusira ta vaisiva mwitaa hianinra kyapara hiqara taqaante, tuvaro ");
INSERT INTO omw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","mwi vaisiva Iesusiraqaa uromwi vuntuvi variro Iesusira kyapara hiro tiqaro, Nronrao, mwiva ta vaisivave iho? tiro. ");
INSERT INTO omw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tuvaro Iesusiva mwia timwa mwinro tiqaro, Nte mpereti viti nramanri tanuqi vahiraqi mwaati ntamwa kyena vaisi mpo mwianriva qio mwia mwi vaisivave, tiro. Timwa kyero mpereti viti vara kyero nramanriqi ntamwa kyero Iutaasira viti mwunra. ");
INSERT INTO omw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mpereti viti mwia mwuvaro Iutaasiva mwia varovaro Saataaniva Iutaasira utaqi viqetero varuvaro Iesusiva Iutaasirara tiqaro, Qio hiantera ena vararera tina kyaiqara varaante, tiro. ");
INSERT INTO omw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mwitaa tuvata mwia nraaqiara kyara taintaqaa varuhuaqitairo hia mpovanto mwi quara okyara ntapihura. ");
INSERT INTO omw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mwihua tiqata, Iutaasiva munimaqaa ntaqikyi vari vaisiva variharo Iesusiva hura omwata nraana kyarara varaanteve tiho, mwiva vehi vaisi munima uro nyianteve tiho? tita. ");
INSERT INTO omw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mwihua mwitaa ti varuvaro Iutaasiva Iesusiva mpereti viti mwunra varero mwiaqaatairo veva ntero viro. Entaqi mwiva vurama. ");
INSERT INTO omw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iutaasiva veva ntero vuvaro Iesusiva tiqaro, Nte mwatani mwatatai nraaqiaravave. Mate ni peqa okyaravanto qovarama viho. Nte Kotira peqa okyara mate qovarama kyauqo. ");
INSERT INTO omw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nte Kotira peqa okyara qovarama kyaankyera, Kotiva mwiva ni peqa okyaravata qovarama kyaananrove. Mwiva qamwanrama mwitaa hiananrove. ");
INSERT INTO omw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Qikye, ni nraaqiaranramwu tuaavo, nte nkyivata pataqia varikyena quarita nkye nraakiara qumina nianra puaa hivarave. Nte Iutaa vaisi nronranramwu timwa nyuntema kyena nkyivata timwa nyuqo. Nte virera hianinrani nkye hia qio vivarave, tuqo. ");
INSERT INTO omw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nte mate qaraakya qua mwaanra nkyi timwa nyianrita nkye riaate. Nkye mpoqama kyeta nanrianra nanrianra mwutukya vahirata variate. Ni mutukyavanto nkyiara vahintema kyeta nkyevata nanrianra nanrianra mwutukya vahirata variate. ");
INSERT INTO omw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nkye nanrianra nanrianra mwutukya vahirata varivata nraakye qora nkyi taqeta mwihua nkye Iesusira nraaqiarama variavo tivarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Iesusiva mwitaa tuvaro Saimoni Pitaava mwia kyapara hiro tiqaro, Nronrao, e taini virerarave qiaro? tiro. Tuvaro Iesusiva tiqaro, Nte virera hianinrani e hiama qio ni pataqira vinanrave. E nraakiarama ni pataqira vinanrave, tuvaro Pitaava tiqaro, ");
INSERT INTO omw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nronrao, nanraqamave nte hia qio mate i vataqina quaninrave? Nte iara rieqana qioma qutu quaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tuvaro Iesusiva tiqaro, Qutaave e nianra rieqara qutu vinanrave? Nte qutaa qianinra riaante. Kokoraaravanto hia nruqua tirara e taarampo nani nianra nte hia mwia taqaurave tinanrave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesusiva nai nraaqiaranramwu timwa nyinro tiqaro, Hia nianra riaivaro nkyi mwutukyavanto uaqia hiarive. Nkye Kotirara kepukyaqama kye riemwaqita quantema kyeta nianravata kepukyaqama kye riemwaqita quate. ");
INSERT INTO omw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ni kora mwaatani airi mpo nraamwu mpo nraamwu vaihana nte nkyiara rieqana uro terama nyatarerana vuqo. Hia mwitaama vahitiri, nte hiama nkyi timwa nyutiri. ");
INSERT INTO omw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nte uro nkyini teramatena uro ntantena tumu nkyi sitaqina uro ntena varianinrani kyaarita, nkye nivata varivarave. ");
INSERT INTO omw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nte virera hu aanranra nkye ntapihi kyaarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tuvaro Tomaasiva qaqao tiro, Nronrao, tire e virera hiananra hia ntapihi kyauro. Nataama kyetave tire mwi aanranra ntapihi kyaananrave? tiro. ");
INSERT INTO omw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tomaasiva mwitaa tuvaro Iesusiva mwia timwa mwinro tiqaro, Nte Kotiva hinani qua aanrava mwaa mwivama varuqo. Nte qutaa okyara mwaa mwivama varuqo. Nte qati variqi qua okyarava mwaa mwivama varuqo. Hia mpo aanranraqaama tero ni kova hinani quariva vaiho. Qio nte mwaa aanra mwivama varuqo. ");
INSERT INTO omw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nkye ni ntapihi kyeta taqaahuara tita, nkye ni koravata ntapihi kyeta taqevarave. Mate mwaa entaraqaataita nkye ni kora ntapihi kyetama nkye mwiavata taqaahuama variavo, tiro. ");
INSERT INTO omw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Mwitaa tuvaro Piripiva tiqaro, Nronrao, qio ena qora tiri tinraamwu tairaqe tire mwia taqeta qiove qiare, tuvaro ");
INSERT INTO omw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesusiva mwia timwa mwinro tiqaro, Piripio, nte nkyi kyapata mpuahaama varuqara e hiave ni ntapihi kyera taqaaro? Ni taqaiva ni koravatama taqaiho. E nanraqamave nianra tiqara ena qora tiri tinraamwu taante qiaro? ");
INSERT INTO omw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Piripio, nte ntena koraqi varuqaro ni kova niqima variho. E hiave mwi quarara qutaave qiaro? Nte nkyi timwa nyu quara hia nte ntena riemwa kyeqanavauma nkyi timwa nyuqo. Ni kova niqi variva, mwiva variqaro nai kyaiqa vare variho. ");
INSERT INTO omw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nte ntena koraqi varuqaro ni kova niqima variho. Mwi quarara qutaave qiate. Nkye hia nianra riaivera, nkye nte kyaiqa varaurara rieqata nianra qutaa mwivave qiate. ");
INSERT INTO omw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nte qutaa qianinra riaate. Nianra qutaa mwivave timwa kyero riemwaqiro quariva, mwiva variqaro nte kyaiqa varauntema kyero kyaiqa varaananrove. Nte ntena kova hinani quaninranra tiro, mwia kyaiqavanto ni kyaiqa nraatara kyaananrove. ");
INSERT INTO omw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nkye ni kyaiqara rieqata qioma nkye mpo inraikyararave, mpo kyaiqarave, ni kyapara hivaqe nte nkyi nyianinrave. Nkye ni kora peqa okyara taqaate tina, nte mwia mwaaquvanto mwitaa hirerave. ");
INSERT INTO omw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nkye ni kyaiqara rieqata qio nkye mpo inraikya mpo inraikyara ni kyapara hivera, nte nkyi nyianinrave. ");
INSERT INTO omw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nkyi mwutukyavanto nianra vahirera, nkye ni qua nraahu riemwaqita vivarave. ");
INSERT INTO omw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nte ntena kora kyapara hiariro mwiva nkyi kyaahaqa hianinra Kotira mwanraqura qutaa qua nraahu ti varianinra titairaro nkyi airiqa hirero tumu ekyaa enta nkyivata variananrove. ");
INSERT INTO omw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Qati nraakye qora mwatani variahua hia Kotira mwanraqura taqeta mwihua hia mwia ntapihi kyaarara tita, mwihua hia mwia qio varevarave. Nkye mwia taqaavaro mwaa entara mwiva nkyivatama variho. Nraakiara mwiva nkyiqima variananrove. ");
INSERT INTO omw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Hia nte nkyi mwaini kyena quarita nkye nrainranra nraaqiara votima kyeta varivarave. Nte nkyi kyaarinani uro ntantena tumuaninrave. ");
INSERT INTO omw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pata iheraqia mwatani varihua hia ni taqaivata nkye nraahu ni taqevarave. Nte qati variqina quariva varurara tita, nkyevata qati variqita vivarave. ");
INSERT INTO omw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mwi entara nte ntena koraqi varurave, nkye niqi variarave, nte nkyiqi varurave, nkye ntapihi kyevarave. ");
INSERT INTO omw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ni qua varakye tutero mwi quara vataqiro quaninra mwia mwutukyavanto nianra vahiananrove. Nianra mwutukya vahiariva variraro ni kora mwutukyavanto mwianra vahiananrove. Ni mutukyavantovata mwi vaisirara vahiananrove. Nte variqana mwi vaisira ntena okyara qoqaa nraamwu taaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tuvaro Iutaasiva hia Iutaasi Isikeriotiva mpo Iutaasiva tiqaro, Nanraqamave e ena okyara tiri nraahu tinraamwu teqara hia mwatani variahua nyaamwu tenanrave? tiro. ");
INSERT INTO omw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iutaasiva mwitaa tuvaro Iesusiva tiqaro, (Mwatani variahua hiama nianra mwutukya ntihata variavo). Vaisivanto nianra mwutukya vahiariva, mwiva ni qua riemwaqiro viraro ni kora mwutukyavanto mwianra vahiananrove. Ntevata ni kovavata mwi vaisiraqi uro variananrave. ");
INSERT INTO omw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Vaisi mpovanto hia nianra mwutukya vahiariva, mwi vaisiva ni quavata hia vataqiro quananrove. Nte nkyi timwa nyu quara hia ntena nraato tukyena nkyi timwa nyunrave. Nte ni koraqaataina mwi quara varena tumu nkyi timwa nyunrave. ");
INSERT INTO omw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nte mate nkyivata varu entara mwaa quara nkyi timwa nyuqo. ");
INSERT INTO omw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nte quariro ni kova nkyi kyaahaqa hianinra nai mwanraqura titairaro mwiva ni kyaiqara rieqaro tumu variqaro ekyaa inraikya nkyi nyaamwu teqaro nkyi su nyaatovata kyaahaqa hirata nkye nte tu quara ntapihi riemwa tevarave. ");
INSERT INTO omw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nte virera hiqanama nkyiara mwaateraqama varivaro nkyi mwutukyavanto qihaakya hirata variate, tuqo. Mwaa mwatanaahua nkyiari nanrianra nanrianra qua mwanteta tiqata, Mwaateraqama kyera variante, ti variarave. Nkyiari mwitaa tiqata qumina qua nraahu ti variarave. Nte nkyiara mwaateraqama kyeta variate tu quava hiama qumina quave. Nkye ni qua riemwaqita vivaro nkyi mwutukyaqitairo qihaakyama vahirata hia aatu hivaro nkyi mwutukyavanto hiama uaqia hiananrove. ");
INSERT INTO omw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nkyi kyena quariva uro ntantena tumuaninrave tu quara nkye vaakya riaarave. Ni kova ni naatara kyero nronravanto varirara tita, nkyi mwutukyavanto nianra qutaaqama vahirera, nte ntena kova hinani quaninranra nkye qamwateqata varivarave. ");
INSERT INTO omw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mwi inraikyava mwi inraikyava nraakiara mwitaa mwitaa hianinranra nte mate nkyi timwa nyuqo. Qio nraakiara nkye taqaivaro mwi inraikyava qovaramaqiro virata nkye nianra tiqata mwiva tu quava mate qutaa mwivauma vaiho tivarave. ");
INSERT INTO omw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Qio mwaa entara mwatani variahuaqaa ntaqikyi variva, Saataaniva, nrumu varihananra tina, mwia kyaara nte hia nkyi kyapata mpuahaa qua qianinrave. Mwia kepukyavanto hia ni qio naatara kyaananrove. ");
INSERT INTO omw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ni mutukyavanto ni korara vahira mwatani varihua taqaate tina, nte ni kora qua vataqina virerave. Qio varaivaqenramwu mwaaqitaita vevante quare, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesusiva mpo quaqaa ntumwa kyero nai nraaqiaranramwu timwa nyinro tiqaro, Nte uaini apa kyuqeva varuqaro ni kova uainiqaa ntaqikyi varivama varihata nkye uaini mwanre kyaarama variavo. ");
INSERT INTO omw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ni kova taqaiharo kyaara mpovanto hia tamwa riaiharo mwiva mwia teqa qaqira kyero uro taqaiharo mpo kyaaravanto kyuqema kyero tamwa riemwa taiharo mwiva kyuqema vahiqaro mpoqiavata riaarive tiro, mwia rapatu kyero vatairave. ");
INSERT INTO omw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nte tu quava nkyi vaakya rapatu kyero vataihatara tita, nkye qioma variavo. ");
INSERT INTO omw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nkye niqi varivaqe nte nkyiqi variankye. Kyaara mpovanto nanrianraqama vahiariva hiama qio tamwa riaananrove. Kyaara mwiva apaqaa taaqau vahiariva qio tamwa riaananrove. Mwia votima kyeta nkye hia nivatama kyeta taaqauvi varivera, nkye hiama qio tamwa rievarave. ");
INSERT INTO omw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nte uaini apa varuqata nkye kyauqu kyaarama variavo. Ni vatama kyero variraqe nte mwia vatama kyena variariva, mwivama tamwa airi riaananrove. Nkye hia nivata taaqauvi variraitita nkye nkyetaraa varivera, nkye hiama qio mpo kyaiqavata varevarave. ");
INSERT INTO omw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kyauqu kyaara qaqira kyairaro aaharama quarintema kyero hia nivata taaqauvi variani vaisira ni kova qaqira kyaananrove. Qaqira kyaani kyaarara mwia nraakiara ntupi kyero varaqiro qiaqi tuto kyairaro itamwa taiqa kyaananrove. ");
INSERT INTO omw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nkye ni vatama kyeta taaqau vita varivaro ni quavanto nkyiqi vahirera, nkye Kotirara nkyeta mwutukya vahiani inraikyarara kyapara hivaro nkyi nyiananrove. ");
INSERT INTO omw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nkye ni qua riemwaqi viqata uaini kyaanta votima kyeta airi tamwa riaivaro ni kora nrutuvanto nronraqa hiarive. Nkye mwitaamaqi viqata nkye qutaaqama kyeta ni nraaqiara varivarave. ");
INSERT INTO omw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ni kora mwutukyavanto nianra vahintema kyero ni mutukyavantovata nkyiara vaiho. Ni mutukyavanto nkyiara vahira mwiqi variate. ");
INSERT INTO omw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nte ni kora qua riemwaqina vi varuqaro mwia mwutukyavanto nianra vahirave. Mwitaa huntema kyeta nkyevata ni qua riemwaqita vivera, nkye ni mutukyavanto nkyiara vahiraqi varivarave. ");
INSERT INTO omw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ni mutukyaqi kyuqe hintema kyero nkyi mwutukyaqivata kyuqe hirata nronraqama kye qamwateqata variate tina, nte mwaa quara nkyi timwa nyuqo. ");
INSERT INTO omw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nte mpo qua qianinra nkye mwi quara riemwaqita quate. Ni mutukyavanto nkyiara vahintema kyeta nkyevata nanrianra nanrianra mwutukya vahirata variate. ");
INSERT INTO omw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Vaisivanto nai nramwunaahuara mwutukya vaiharo mwihuara rieqaro qutu virave. Mwitaama kyero nai hena huara mwutukya vahiariva mpohuara mwutukya vahi okyarara ekyaa nraatara kyero nritarero vahiananrove. ");
INSERT INTO omw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nkye ni qua riemwaqita vivera, nkye ni nramwunaahuama varivarave. ");
INSERT INTO omw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kyaiqa vaisivanto hia nai nronra vaisivanto mwitaa mwitaa hiani okyarara ntapihirara tina, nte hiama nkyiara ni kyaiqa vaisive timwaqina quaninrave. Nte nkyiara ni nramwunaahuave timwaqina virerave. Nte ni kora qua riaura ekyaa nkyi timwa nyunranra tina, nte mwitaa tirerave. ");
INSERT INTO omw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Hia nkye ni naanraanrave. Nte nkyi nyaanraunrave. Nte nkyi nyaanrama kye sita kyena nkyiara uro kyatarivanto tamwa riaintema kyeta kyuqe tamwa mpuahaama vahiani tamwanra riemwataate turave. Nkye mwitaa hivera, nkye ni nutuarave, ni kyaiqarave rieqata nanra inraikyarave ni kora kyapara hivaro mwiva nkyi nyiananrove. ");
INSERT INTO omw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nte mwaa quara nkyiara mwitaa hiatema tuqo. Nkye nanrianra nanrianra mwutukya vahirata variqita quate. ");
INSERT INTO omw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mwatani varihua nkyi nramwutaaqa hivera, nkye ntapihiate, mwihua ni nraante nramwutaaqama taahuara titama, nkyivata nramwutaaqa hivarave. ");
INSERT INTO omw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nkye mwata mwainyaahua varivatavauma mwihua nkyiara tiri nramwunaahuave tiqata nkyiara mwutukya vahirata varivarave. Nte mwatani variahuaqitaina nkyi nyaanrama kyauqata nkye hia mwihuaniqama variavo. Nkye hia mihuaniqama variarara titama, mwihua nkyi nramwutaaqa hi variavo. ");
INSERT INTO omw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nte vaakya timwa nyunranra riaate. Hia kyaiqa vaisivanto nai nronra vaisi nraatara kyairave. Mwatani variahua ni uaqiama matehuara tita, mwihua nkyivata uaqiama nyatevarave. Mwihua ni qua riehuavauma nkyi quavata rievarave. ");
INSERT INTO omw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nkye ni nraaqiara variavatara tita, mwihua mwia kyaara nkyivata qoraqama nyatevarave. Ni titaira hia ntapihiahuara tita, mwihua mwitaa hivarave. ");
INSERT INTO omw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nte hia tumu mwihua timwa nyutirio, mwihua qora kyaiqa utuarara hiama qua vahitirio. Nte tumu mwihua timwa nyunranra tiro, mwiaqaatairo mwihua qaqao hia mwia riaunanrave ti quava hiama vahiananrove. ");
INSERT INTO omw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Vaisivanto ni nramwutaaqa hiqaro ni koravata nramwutaaqa hiananrove. ");
INSERT INTO omw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mpo kyaiqa mpo kyaiqa hia mwihua qio varaa kyaiqara nte mwi kyaiqara mwihua suqaa variqana vare varuvave. Hia nte mwitaa hutirio, hiama mwihuaqaa qua vahitirio. Mwihua ni kyaiqa taqeta ni qaqira kyeta nivata ni koravata nramwutaaqa hiavo. ");
INSERT INTO omw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mwihua mwitaama variavaro qua mpo haaru qumina vakya qara ntumwa tova mate ntapihi kyero mwivauma viho. Mwi quava mwitaama tiro: Hia mpo quavata vahirata quminaqama kyeta mwihua ni nramwutaaqa hivarave, turave. ");
INSERT INTO omw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Qio nkyi kyaahaqa hiariva mpovanto tumuananrove. Mwiva Kotira mwanraquravanto qutaa qua nraahu ti variva, mwiva Kotiva hinasairo tumuananrove. Nte mwia ntena koraqaataina titaariro mwiva tumu variqaro nianra ntapihi kyero nkyi timwa nyiananrove. ");
INSERT INTO omw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nkyevata vuni nivatama kyeta variqi quahuara tita, nkye qioma ni kyaiqa okyarara mpo mwatanaa mpo mwatanaahua timwa nyivarave. ");
INSERT INTO omw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nkye nraakiara pupohairata ni qua qaqira kyevo tina, nte mwi quara mwi quara nkyi timwa nyuqo. ");
INSERT INTO omw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nraakiara mwihua nkyi inronra hiqata mwaanra nraamwuqitaita nkyi raaqu kyevarave. Mpo enta nrintairata mwihua nkyi ru kyeta tiqata, Tire Kotira kyaiqama vare varuro, tivarave. ");
INSERT INTO omw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mwihua nianravata ni koraravata hia ntapihi kyeta riaahuara tita, mwihua mwitaa hivarave. ");
INSERT INTO omw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nte mwaa entara nraakiara nkyi uaqiama nyaterara timwa nyuqo. Nraakiara mwihua mwitaa mwitaa hivata nkye mwi entara nte mate mwaa quara turara nraato tuate. Tauraa nte nkyivata variqananra tina, hia nte mwi quara mwi quara nkyi timwa nyunrave. ");
INSERT INTO omw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Qio nte pataqia vari kyena ni titaiva hinani virerave. Qio nte mwini virerana uti varuqaro hiama nkyiqitairo mpovanto tiqaro, E taini virerarave hiaro? tiho. ");
INSERT INTO omw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nte vaakya turara nkye rie variavaro nkyi mwutukyavanto uaqia ihata variavo. ");
INSERT INTO omw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Qio nte qutaama tuqo. Nte hia quariro nkyi kyaahaqa hiariva hia qio tumuananrove. Nte quariva qioma uro mwia titaariro nkye hinani tumuananrove. ");
INSERT INTO omw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kotira mwanraquravanto tumu variqaro mwiva mwatani varihua taarampo inraikyara nyaamwutaananrove: (1) mwihua uaqia hi kyaiqarave (2) kyuqe kyaiqa okyararave (3) Kotiva ko qiani okyararave ");
INSERT INTO omw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","(1) Mwihua uaqia hi kyaiqara: Mwatani varihua hia nianra qutaa mwivave tihuara tita, mwihua uaqia hi kyaiqara utira mwiva nyaamwu taananrove. ");
INSERT INTO omw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","(2) Kyuqe kyaiqa okyara: Nte ntena kova hinani quarita nkye hia qaiqaa ni taqerara tiro, mwiva variqaro kyuqe kyaiqa okyara nkyi nyaamwu taananrove. ");
INSERT INTO omw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","(3) Kotiva ko qiani okyarara: Mwaa mwataraqaa ntaqikyi variva Saataaniva ko hia nraatara kyairara tiro, mwiva Kotiva ko qiani okyarara mwatani varihua nyaamwu taananrove. (Kotira mwanraquravanto mwitaama timwa nyiananrove.) ");
INSERT INTO omw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nte mpo qua mpo qua nkyi timwa nyianriva vaihata nkye hia ekyaa mwi quarara qioqa hiavananra tina, mate nte hia mwi quara nkyi timwa nyinrenrave. ");
INSERT INTO omw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Qutaa qua nraahu ti variari mwanraqurava tumu ntero, mwiva variqaro nkyi sita varero nkyi kyuqe aanra nyaamwu teqaro qutaa qua okyara ekyaa mwi okyarara nkyi timwa nyiananrove. Mwiva hia nai vu nraato tuani quarara tiraitiro, mwiva riaani quara nraahuma timwa nyiananrove. Nraakiara mwi inraikyava mwitaa mwitaama qovara hiani inraikyarara mwiva nkyi timwa nyiananrove. ");
INSERT INTO omw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mwiva nte qua qianinra mwi quara nkyi timwa nyianinranra tiro, ni nutuvanto nronraqa hiananrove. ");
INSERT INTO omw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ekyaa ni kova hi inraikyava nini vahirara tina, nte vaakya tiqana, Kotira mwanraqura mwiva nte hu inraikyarara riero vara kyero nkyi timwa nyiananrove, turave. ");
INSERT INTO omw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Qio pataqia nkye varita hia ni taqevarave. Mwiaqaataita pataqia nkye varita qaiqaa ni taqevarave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iesusiva mwitaa tuvata mwia nraaqiara mponramwuvanto nai timwa mwi nai timwa mwi hita tiqata, Mwiva nanra quave tiho? Mwiva tiqaro, Pataqia nkye varita hia ni taqevarave, timwa kyero qaiqaa tiqaro, Nkye vari kyeta ni qaiqaa taqevarave, tiho. Mwiva mwitaa timwa kyero nai qova hinani quaninranravata tiho. ");
INSERT INTO omw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mwiva nkye pataqia vari kyetave ti quara, hia tire mwi quara ntapihi riauro, tita. ");
INSERT INTO omw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Mwitaa ti varuvaro Iesusiva ntapihi kyovata mwihua mwi quarara mwia kyapara hirerata uti varuvaro Iesusiva tiqaro, Nte vaakya turara nkye pataqia varita hia ni taqevarave mwiaqaataita pataqia varita qaiqaa ni taqevarave turave. Nkye mwi quararave nai kyapara hi nai kyapara hi variavo? ");
INSERT INTO omw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Qio nte qutaa qianinra riaate. Nkye ntateqata atura ntiqa variqi vivata mwatani varihua qamwateqata varivarave. Nkyi mwutukyavanto uaqia hirata variqita vivaro mwiaqaatairo nkyi mwutukyavanto kyuqema vahirata varivarave. ");
INSERT INTO omw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nraakyevanto nraaqiara mwataariva qaumato vaiharora tiro, mwiva atura ntirave. Qio mwi nraakyeva nraaqiara mwata kyero mwiaqaatairo tiqaro, Nte nraaqiara mwata kyauqo, timwa kyero qamwateqaro nai atura ntirara taunru kyairave. ");
INSERT INTO omw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nkyevata mwitaa hivarave. Mwaa entara nkyi mwutukyavanto uaqia hirata varivarave. Qio nraakiara nte nkyi uro taqaariro nkyi mwutukyavanto kyuqe hirata qio varivarave. Varivaro mpovanto hia qio nkyi qoraqama nyatairaro nkyi mwutukyavanto uaqia hiananrove. ");
INSERT INTO omw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mwitaa hirata mwi entara nkye mpo inraikyara ni kyapara hiva hiama vahiananrove. Nte qutaa tuqo. Mwi entara nkye ni korara mpo inraikya mpo inraikyara mwia kyapara hivaro mwiva ni kyaiqarave, ni nutuarave, rieqaroma nkyi nyiananrove. ");
INSERT INTO omw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tauraa nkye variqata hia ni kyaiqarave ni nutuarave rieqata ni kora kyapara hiarave. Mwaa entaraqaataita nkye ni kora kyapara hivaro nkyi mwutukya kyuqe hiarive tiro, nkyi nyiananrove. ");
INSERT INTO omw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nte mpo quaqaa ntumwa kyeqana mpo qua mpo qua nkyi timwa nyunrave. Qio mpo enta nri ntairaqe nte hia mpo quaqaa ntumwa kyena nkyi timwa nyinraitina, mwi entara nte ntena korara nkyi timwa nyinrenra nte vutu kyenama nkyi timwa nyianinrave. ");
INSERT INTO omw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mwi entava nri ntairata qioma nkye ni nutu nteqata ni korara kyapara hivaro nkyi nyiananrove. Hia nte nkyiara rieqana ntena kora kyapara hianinrave. (Nkyetavanto qio mwia kyapara hivarave.) ");
INSERT INTO omw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ni kova nkyiara mwutukya ntiharo varirara tita, nkyetavanto qioma mwia kyapara hivaro nkyi nyiananrove. Nkye nianra tiqata, E Kotiva hinasaira tumuanravave, qiavaro nkyi mwutukyavanto nianra vaihata variarara tiro, ni kora mwutukyavantovata nkyiara vaiharo variho. ");
INSERT INTO omw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nte ntena kova hinasaina mwatani tumuvave. Nte qaumama mwaa mwatara mwaini kyena ntena kova hira qoqaraanani quaninrave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mwitaa tuvata mwia nraaqiaranramwuvanto qiove tita, Mate e hia mpo quaqaa ntumwa kyera tiraitira, e vutu kyerama tiri timwa timwi variaro. ");
INSERT INTO omw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mate tire ntapihi kyaurara e ekyaa inraikya ntapihi kyaarava variarata tire hiama i qaiqaa kyapara hiananrave. Mate tire tiqata, Qutaama e Kotiva hinasaira tumuanravave turo, tita. ");
INSERT INTO omw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Mwitaa tuvaro Iesusiva tiqaro, Qio mateve nkye ni okyarara ntapihiavo? ");
INSERT INTO omw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mpo enta nrianriva qaumatoma vaiho. Mwi entaraqaa nkyi vara aanraupima kyaivata nkye mpona mponamate nkyeta mwaatani vivu kyaavuma vivarave. Ni kova nivatama kyero varirara tina, nte mwi entaraqaa hiama ntenanraa varianinrave. ");
INSERT INTO omw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nkye nivata varivaro nkyi mwutukya qihaakyama vahiarive tina, nte mwaa quara nkyi timwa nyuqo. Nkye mwatani varivata mwihua nkyi uaqiama nyatevarave. Qio kepukyaqama kyeta variate. Nte mwatanyaa okyara nraatara kyaurave, tiro. Iesusiva turama. ");
INSERT INTO omw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesusiva mwi quara timwa kyero mwiva nyaamwuni taqeqaro Kotirara aakyara ntero tiqaro, Ko, mate mwaa ni iherama nri ntaiho. Qio e ni peqa okyara qovarama matairaqe nte i mwaaquvanto variqana nte ina peqa okyara nyaamwutaankye. ");
INSERT INTO omw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","E nraakye qora ni mpiarahua nte mwihua kyaahaqamaqina quarita mwihua ekyaa enta qati variqita quate tira, e ni nronraqama kyaarana nte ekyaa nraakye qoraqaa ntaqikyi variqana nte mwihua nronravanto varuqo. ");
INSERT INTO omw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nraakye qora ekyaa enta qati variqi vi okyarava mwataamama vahiro: Nraakye qora iara ntapihi kye rieta tiqata, Kotiva nraahuma qutaa mwanriqa kuaiqiavanto variqaro Iesusi Karaisira titairave, tihua, mwihua mwi okyarara varevara. ");
INSERT INTO omw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nte mwatani variqi vina i peqa okyara nraakye qora nyaamwuteqana e kyaiqa mpiananra vara taiqa kyauqo. ");
INSERT INTO omw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Qio ko, haaru hia mwaa mwatavavata vahu entara nte ivata variqi quavaro ni peqa okyaravanto vahurave. Qio mate e ni peqa okyara mwia nyaamwutairata mwihua taqaate. ");
INSERT INTO omw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mwatanyaa vaisinramwu ni mpiarahua nte mwihua i okyara nyaamwutaurave. Mwi vaisihua ena hiarahua ena mwihua ni mpiarata mwihua variqata i qua riemwaqita quavo. ");
INSERT INTO omw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","E qua ni timwa mpiananra nte mwihua timwa nyuqata mwihua mwi quara varaarave. Mwihua ntapihi kyaavana nte qutaa e hiananrasaina tumuqata mwihua nianra qutaa Kotiva mwia titairave qiarave. Mwitaa tiqatara tita, mwihua ntapihi kyeta riaavaro e ekyaa inraikya ni mpiarava mwi inraikyava e hiananrasairo tuminrave. ");
INSERT INTO omw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Qio nte mwihuara rieqanama iara aakyara nte varuqo. Hiama nte ekyaa nraakye qora mwatani variahuara aakyara nte varuqo. E nraakye qora ni mpiarata mwihua ini variarara tinama, nte mwihuara rieqanama iara aakyara nte varuqo. ");
INSERT INTO omw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nte uhua e hiarahuama variavo. E hiarahua nte uhuama variavo. Mwihua variqata ni peqa okyara mpo hiahua nyaamwute variavo. ");
INSERT INTO omw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nte hia mwaa mwataraqaa variarita mwihuama mwaa mwataraqaa varivarave. Nte e hiananrani virerave. Qio ko, e kyotataqama kyera variaravave. E ena kepukya nrutu ni mpiananra mwi kepukyaraqotaira mwihua antuaraqira virata mwihua tiretana kuaaqi varurantema kyeta mwihuavata variate. ");
INSERT INTO omw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nte mwihua kyapata variqana e ena kepukya nrutu ni mpiananra mwi kepukyaraqotaina mwihua antuaraqina vuqata hia mwihuaqitairo mpoqiavantovata raupirima viho. Vaisi kuaiqiavanto nraahu raupirima viho. Mwiva raupirima quaninranra haaru qati vakya mpovanto mwianra qara ntumwa tero mwitaa hiananrove turaqaara tiro, mwate mwitaama viho. ");
INSERT INTO omw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Qio nte ivata varirerana virera uti varuqo. Ni mutukyavanto qamwatero kyuqe hintema kyero mwihua mwutukyavantovata qamwatero kyuqe hiarive tina, nte mwata mwaini variqana mwaa quara mwitaa tuqo. ");
INSERT INTO omw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nte i qua mwihua timwa nyuqata mwihua mwatani variahua nrohia aanranra qaqira kyeta mwihua nte hia mwata mwaaqaanaava varuntema kyeta mwihuavata hiama mwata mwaaqaanaahua variavo. Mwitaama variavatara tita, mwatani variahua mwihua nramwutaaqa hi variavo. ");
INSERT INTO omw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Qio nte hia mwata mwaaqaataira mwihua sitaantera i kyapara huqo. Qaqao, nte iara tiqana, E mwihuaqaa ntaqikyiqira viraro uaqia hi vaisiva hia mwihua uaqiama nyataarive, tuqo. ");
INSERT INTO omw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nte hia mwata mwaaqaanaava varuntema kyeta mwihuavata hiama mwata mwaaqaanaahua variavo. ");
INSERT INTO omw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","E qutaa quaqotaira mwihua kyaahaqa hirata mwihua i aanraqaa nraahu nrohiate. I qua qutaa quama vaiho. ");
INSERT INTO omw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","E ni mwata mwaini titaarana tumuntema kyena, ntevata mwihua mpo mwata mpo mwatani sitarerave. ");
INSERT INTO omw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Qio nte mwihuara rieqana kuaa kyaiqa nraahu vararerana varuvave. (Nte mwihuara rieqana qutu quataa hiraqe qutu virerana varuqo.) Nte mwitaa hiarita mwihua qutaaqama i nraaqiara variqata i aanraqaa nraahu vivarave. ");
INSERT INTO omw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Hia nte mwihuara nraahu rieqana iara aakyara ntauqo. Nraakiara mpo ihua mwihua qua rieqatama nianra qutaa mwivave tihua, nte mwihuaravata rieqanama iara aakyara ntauqo. ");
INSERT INTO omw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mwihua kuaaqi variate tina, nte iara aakyara ntauqo. E niqi variarana nte iqi varuqo. Ko, mwihua tiritana votima kyeta variate tira, e mwihua kyaahaqa hirata mwihuavata tiritanaqi variate. Mwatani varihua nianra qutaa Kotiva mwia titaivave qiate tira, e ni nraaqiaranramwu kyaahaqa hirata mwihua kuaaqi variate. ");
INSERT INTO omw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","E ni nutu nronraqama kyaarana nte kuaaqarama kyena mwihua nyutu nronraqama kyauqo. Mwihua tiretana kuaaqi varurantema kye mwihuavata kuaaqi variate tina, nte mwihua nyutu nronraqama kyauqo. ");
INSERT INTO omw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","E niqi variraqe nte mwihuaqi variarita mwihua kuaaqi variqatama mpoqiavata kyaakueqa hivarave. Mwihua mwitaama varivata qati nraakye qora mwatani varihua e ni titaananranra ntapihita i mwutukyavanto nianra vahintema kyero i mwutukyavanto ni nraaqiaranramwuanravata vahianinravata taqevarave. ");
INSERT INTO omw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ko, haaru hia mwaa mwatava vahu entara e nianra mwutukya vahuvarara tira, e ni nronraqama kyoraro e ni nronraqama kyoraro ni okyara kepukya okyaravanto vahuvana variavarave. E nraakye qora ni mpiarahua mwihuavata ni peqa okyara taqaate tina, nte tiqana, Nte varianinrani mwihuavata varivarave, tuqo. ");
INSERT INTO omw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ko, e avuqavuma kyera variaravave. Qati nraakye qora mwatani variahua hia i ntapihi kyaavana nte nraahu i ntapihi kyaurave. E ni titaananra mwaa nraaqiaranramwuhua nraahu mwia ntapihi kyaarave. ");
INSERT INTO omw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nte iara mwihua timwa nyuqata mwihua i ntapihi kyaarave. I mwutukyavanto nianra vahintema kyeta mwihuavata mpohuara mwutukya vahirata varivaqe nte mwihuavata kuaaqi variqina quankye tina, nte mwihua iara mpoqiavata timwa nyiqi quarita mwihua ntapihi rievarave, tiro. Iesusiva nai qorara aakyara nteqaro mwitaa tura. ");
INSERT INTO omw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesusiva mwitaama kyero Kotirara aakyara timwa taiqa kyero mwiva nai nraaqiaranramwu vatama kyero vuva uro Kitaroni pata nramanriqiaru qarero oripi kyatari kyaqamwa tutoraqi vura. ");
INSERT INTO omw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iesusiva airi enta nai nraaqiaranramwu kyapata mwiqi uro varurara tiro, Iutaasiva Iesusira nramwutaahua kyauquqi kyaariva mwia ntapihi kyora. ");
INSERT INTO omw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Iutaasiva ntapihi kyero uro Kotira kyaiqa vara mwate varu vaisihua mwihua nronra vaisinramwuvata, Parisi vaisinramwuvata, timwa nyuvata mwihua kamaninra porisinramwu Iutaasira mwita kyaiqa vaisinramwuvata mwia mwuvaro Iutaasiva mwihua sita varero vura. Mwihua omwavata ramuvata qupi kye vareta ntaqi inraikyaravata vareta vuhua uro Iesusiva hunani uro ntora. ");
INSERT INTO omw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Mwini uro ntovaro Iesusiva vaakya mwihua uti inraikyara ntapihi kyero mwiva vutu ntero mwihua kyapara hiro tiqaro, Nkye tararave puaa hi variavo? tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mwitaa tuvata mwihua tiqata, Tire Iesusira Nasaretinyaanranra puaa hi varuro, tuvaro Iesusiva mwihua timwa nyinro tiqaro, Nte mwaa mwivama varuqo, tiro. Mwitaa tuvaro Iutaasiva Iesusira nramwutaa kyauquqi kyaari vaisiva, mwiva Iesusira rukyehua kyapata siviro varura. ");
INSERT INTO omw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iesusiva nte mwaa mwivave tuvata mwihua nrihanrama vita uro ntanteta aatuma kyeta mwatasata tuto ntita varura. ");
INSERT INTO omw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mwitaa huvaro Iesusiva qaiqaa mwihua kyapara hiro tiqaro, Nkye tararave puaa hi variavo? tuvata mwihua qaiqaa tiqata, Iesusira Nasaretinyaanranrave, tuvaro ");
INSERT INTO omw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesusiva tiqaro, Nte vaakya nkyi timwa nyunrave. Nte mwaa mwivama varuqo. Nkye nianra puaa hirerata nrivera, mwaa vaisinramwuhua qati kyaivata quate, tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Vuni Iesusiva nai qorara mwitaama tiro: Vaisi mponramwu ni mpiarahua hia nte mpoku raupirima kyauqo, tura. Mwi quava qutaa mwivau vahiarive tiro, Iesusiva tiqaro, Mwi vaisinramwuhua qati kyaivata quate, tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mwitaa tuvaro Pitaava nai paipanta varero nrunra veva ntanrau kyero mwiaqotairo Kotira kyaiqa vara mwate varu vaisihua mwihua vunyaa vaisi, mwia kyaiqa vaisi nraato kyaatutani vahura teqa kyora. Kyaiqa vaisi mwia nrutu Marakusira. ");
INSERT INTO omw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pitaava mwia nraato teqa kyovaro Iesusiva Pitaarara tiqaro, Ena paipa vara veva nai tuaqi hu taante. Ni kova nramanri ni mpianinra hia nivanto nraanrive tirave mwitaa hiaro? tiro. (Iesusiva nramanriqaa ntumwa kyero nai ntuqutivaro nriqa quani inraikyara varero uro qutu quaninranra tura.) ");
INSERT INTO omw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Iesusiva mwitaa tuvata Romeninyaahua ntaqu vaisihua nkyiari qiata vaisi vatama kyeta nruvata Iutaa porisinramwuvantovata nri nteta Iesusira ntavaaqavu kyeta mwia rupa kyeta ");
INSERT INTO omw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","mwia vitaqita Anaasiva hunani nraante kyora. Anaasiva mwiva Kaiapaasira nrinraamwiva varuvaro Kaiapaasiva nronraqama vuva mwi ihiraqi Kotira nraamwuqi Kotira kyaiqa vara mwate varu vaisihuaqaa ntaqikyiqaro qiata vaisivanto varura. ");
INSERT INTO omw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tauraa Kaiapaasiva nai Iutaa kaanasori vaisi timwa nyinro tiqaro, Tiri kyaahaqa hirero vaisi kuaikuvanto qutu viraro kyuqe hiananrove, tu vaisiva varurama. ");
INSERT INTO omw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Iesusira Anaasiva hunani vitaqita uro kyovata Saimoni Pitaavavata Iesusira nraaqiara mpovantovata Iesusira vataqita vura. Anaasiva Pitaara vatama kyero nru vaisira ntapihi kyovara tiro, mwiva Iesusira vataqiro viqaro Anaasira mwaata mwatukya utaqi viqetora. ");
INSERT INTO omw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pitaava mwaaqani varuvaro Iesusira nraaqiara Anaasiva ntapihi kyo vaisiva mwatukya utaqi vuva uro ntantero nrumu qesana ntaqikyi varu nraakyera timwa mwitero uro Pitaara vitaqiro nrumu utaqi vera kyora. ");
INSERT INTO omw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Utaqi kyovaro Pitaava varuvaro nraakye qesaqaa ntaqikyi varuva mwiva tiqaro, Evata mwi vaisira nraaqiarave variaro? tuvaro Pitaava qaqao, Nte hiave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Timwa kyero varuvata porisinramwuvantovata Anaasira kyaiqa vaisinramwuvantovata varuvaro antovata mwihua qia quarateta qia taare varuvaro Pitaavavata mwini uro variqaro qia taare varura. ");
INSERT INTO omw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mwiaqaatai Iesusira vitaqita mpoqi uro kyovaro Kotira kyaiqa vara mwate varu vaisihua mwihua vunyaa vaisivanto Iesusira nai nraaqiarara kyapara hiro Iesusiva nraakye qora timwa nyu quararavata kyapara huvaro ");
INSERT INTO omw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesusiva nai timwa mwinro tiqaro, Nte qoqaa variqana nraakye qora qua timwa nyunrave. Nte ekyaa enta nraakye qora timwa nyinrenrana Iutaavanto ntuvaantuama vita variaraqive, mwaanra nraamwuqive, Kotira nraamwu nronraqive, variqana nte mwihua qua timwa nyunrave. Hia nte uqeta kyena variqana mwihua qua timwa nyunrave. ");
INSERT INTO omw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Qio nanraqamave e ni kyapara hi variaro? E ni qua riaahua kyapara hiataarave. Nte qua timwa nyuhua kyapara hiante. Mwihua nte tu quara riaahuave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesusiva mwitaa tuvaro porisi vaisi mpovanto mwiqi varuva Iesusira nraatokyai ntuteqa kyero tiqaro, E hia mwitaama kyera tiri nronra vaisiara qua qiante, tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Mwitaa tuvaro Iesusiva mwia timwa mwinro tiqaro, Ni quavanto api qua vahiraravauma e ekyaa nraakye qora mwianra timwa nyinrata rievarave. Ni quavanto qio vaihara e nanraqamave ni qumina ntuqutira hiaro? tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Iesusiva mwitaa timwa kyero mwia kyaantaqotaita rupatova varuvaro Anaasiva mwia titovaro Kotira nraamwuqaa ntaqikyi varu vaisira Kaiapaasiva hunani viro. ");
INSERT INTO omw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Iesusiva mwini vuvaro Pitaava mpoqi variqaro qia taare varuvata mwini varuhua mwia kyapara hita tiqata, Evata mwia nraaqiarave variaro? tuvaro Pitaava qaqao, Nte hiave, tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mwitaa tuvaro vaisi mpo qiata vaisi kyaiqa vaisivanto Pitaava mwia nraato teqa kyora mwia hena vaisivanto Pitaarara tiqaro, Qutaa eve nte taqauqara mwikyantiri kyatari kyaqamwaqi variaro? tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tuvaro Pitaava qaiqaa qaqao nraahu tiro. Mwitaa timwa kyero riovaro qamwanrama kyero kokoraaravanto nruqua tura. ");
INSERT INTO omw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mwihua Kaiapaasira mwini kyeta Iesusira vita vare uro nronra vaisi kamaninra nraamwuqi kyora. Mwihua vaakya toqaqi mwini uro nteta mwihua Iutaavantora tita, hia mwia nraamwuqi vera ntaraitita, mwaatani varura. Mwihua nkyiari tiqata, Tire mwia mpo mwatanaanra nraamwu hia kyotataqi vera nteta uaqiama vita mwia kyaara tire hiama vekyahu nyato entaraqaa omwata qio nraananrave, tita. ");
INSERT INTO omw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mwitaa timwa kyeta mwihua mwaatani varuvaro Pairaativa kamaninra qiata vaisivanto mwihua taqarero veva ntero mwihuara tiqaro, Nanra qua mwaa vaisiraqaa vaihatave qiavo? tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pairaativa mwitaa tuvata mwihua tiqata, Mwi vaisiva hia uaqia hi kyaiqara utitirio, tire hiama qio e hiananrani mwia vite nrunratirio, tita. ");
INSERT INTO omw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mwihua mwitaa tuvaro Pairaativa qaqao tiro, Nkyeta mwaa mwi vaisira viteta nkyeta Iutaa ko quaqaa rieqatama mwia ko qiate, tiro. Pairaativa mwitaa tuvata Iutaa mwihua tiqata, Qaqao, tire qumina vaisi variqata vaisi ru kyaananranra qua varaarorave. (Ena kamaniva variqara qioma tirata mwia ru kyevarave), tita. ");
INSERT INTO omw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mwihua mwitaa tuvaro Iesusiva mwihua mwitaama kyeta ni ru kyevarave tu quava qutaa mwivau vahura. ");
INSERT INTO omw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Iutaa vaisi nronranramwuvanto mwitaa tuvaro Pairaativa nai nraamwu kamaninra nraamwuqi vera ntero Iesusira nraanrama kyovaro mwiqi vuvaro mwia kyapara hiro tiqaro, Qutaa e Iutaaqaa ntaqikyi variaravave? tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tuvaro Iesusiva tiqaro, Ena nraato tukyerave mwi quara qiaro? Vaisi mpovanto nianra i timwa mwihanrave e mwitaa qiaro? tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Iesusiva mwitaa tuvaro Pairaativa tiqaro, Nte Iutaa vaisive huqo? Nte hia Iutaa vaisive. Ina nramwunaa Iutaavantovata, Kotira kyaiqa vara mwate varia vaisihua mwihua nronra vaisinramwuvata, mwihuama i viteta mwaini nriavo. E nataama kyaaratave i viteta nriavo? tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mwitaa tuvaro Iesusiva tiqaro, Nte ntaqikyiariva hiama mwaa mwataraqaa vaiho. Mwiva mwaa mwataraqaa vahitirio, Iutaavanto ni rupevo tita ni kyaara ni pataqi nrihua mwihuavata ntaquatirio. Qio nte ntaqikyiariva hiama mwatani vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Iesusiva mwitaa tuvaro Pairaativa tiqaro, Qio qutaa e nraakye qoraqaa ntaqikyi variaravave? tiro. Tuvaro Iesusiva tiqaro, Qutaa nte nraakye qoraqaa ntaqikyi varuvave. Mwianra rieqaro ni mwatani mwatataihana nruvave. Qutaa qua okyara nraakye qora timwa nyinrenrana nte mwatani tumuvave. Qutaa quara riaariva ni quama riaananrove, tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Iesusiva mwitaa tuvaro Pairaativa tiqaro, Qutaa qua vahirero mwia nanra quave iho? tiro. Pairaativa mwitaa timwa kyero veva ntero Iutaa ntuvaantuama vita varuhua timwa nyinro tiqaro, Nte taqauqaro hia mwia rukyaarava mpo okyara mwiaqi vaiho, tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mwitaa timwa kyero mwiva tiqaro, Qio nkye mpo inraikya utuava mwitaamama vaiho. Nkye vekyahu nyato kyarara omwata nraa entaraqaa nte karavu vaisi kuaiku nkyiara rieqanama mwia huvantu nyataurave. Qiove nte mwianra rieqana nkyi Iutaaqaa ntaqikyi vari vaisira huvantu nyataaninrave? tiro. ");
INSERT INTO omw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mwita