﻿USE sofia;
DROP TABLE IF EXISTS sofia.omw_v_vpl;
CREATE TABLE omw_v_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES omw_v_vpl WRITE;
INSERT INTO omw_v_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sisasiva mwariro mwo kuaqaa nuase nraase qora timwa nyiro tiro, Kotiva nraase qoraqaa naqisiariva vasirero mwaa kuara votaama vaiso. Vainti mwovano suqe si sukura uiti suku nrai vutaqi mwara tuse ");
INSERT INTO omw_v_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","uro enaqi nrai nramwunaavaqa vaite mwauvaro mwira nramwutaa mwovano nrinero uiti tutoraqi kuankusa suku sia suqe si sukura pisorave. (Mwi kuankusava vasirero mwira ituvaqa mwira aqavaqa uiti ituvaqa aqavaqa nkuaa qarama vaisaro mwi kuankusara tavavano aasu sia mwitaama uiti tava votaama vairave.) ");
INSERT INTO omw_v_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mwira nramwutaavano sia suqe si sukura mwira vutaqi pise vuvaro uitivano kuankusa vaqamase nkuaaqi kutero mwataqa tava riare suvanta mwira aira vaintivaravano takuovaro mwi kuankusava uiti vaqamase kute vauvanta ");
INSERT INTO omw_v_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","mwira aira vaintivaravano uro nraaso qora mwata rienta tinta, Nrora vaintio, re suqesi sukurave mwara tutaaro? Ntaintairove mwi kuankusava qovarama viso? tinta. ");
INSERT INTO omw_v_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mwitaa tuvaro nraase qova tiro, Qike, ni nramwutaa mwovano kuankusa mwaqiro uro ni vutaqi mwara tutaiso, tuvanta mwira aira vaintivaravano mwira mwata rienta tinta, Sove te uro mwi kuankusara nuqi saanarave? ");
INSERT INTO omw_v_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","tuvaro mwiva qao tiro, Sia kuankusa mwira nuqi saate. Né kuankusa nuqitanta uiti vaqamasenta nauku sevorave. ");
INSERT INTO omw_v_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Qaqi saivaro uitivanovaqa kuankusavanovaqa nkuaaqi nivuate. Uitivano nroravaqe ne ni sara irara mware nri mwai vaintisuara mwitaama tirenave. Né mwi kuankusara nane tuquse rumpase mwaqinta uro tia quara tenta mwiraqaantai uiti tuquse mwaqi ni sarasaapa nraavuqi uro nini mataate tiasarave, turave. Sisasiva mwi kuaraqaa nuase timwa nyurama... ");
INSERT INTO omw_v_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sisasiva mwo kua mwo kuaqaa nuase timwa nyiqiro viro mwiraqaantai mwiva nraase qora mwini se nraavuqi vuvanta mwira nraaqiaravaravano mwiva mwauraqi uro nenta Sisasirara tinta, Re ota tiana kuara mwira nramwutaavano kuankusa mwira vutaqi piso kuara mwi kuara osarara tiri timwa tiviqe te riaare, tinta. ");
INSERT INTO omw_v_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mwira nraaqiaravaravano mwitaa tuvaro Sisasiva mwinravusua timwa nyiro tiro, Vainti mwovano suqe si sukura mwara tuto vaintira osaravano vairero ne mwiva mwauko. Ne mwataqi mwatatai nraaqiarava ne mwi vaintivave. ");
INSERT INTO omw_v_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mwi vaintira vuta osaravano vairero esaa mwatamaata vaiso. Suqe si sukura osaravano vairero Kotira kua riaa nraase qorasuama mwariarave. Kuankusa osaravano vairero sia Kotira kua riaa nraase qorasuama Saataanira nraaqiarama mwariarave. ");
INSERT INTO omw_v_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mwira nramwutaavano kuankusa suku piso vaintira osaravano vairero mwiva Saataanivave. Sara irara mware nri enara osaravano vairero naantiara mwaa mwatava taiqaari enava vaiso. Sara irara mwarenta nri vaintisua osaravano vairero mwisua naavunyaa vaintinravuve. ");
INSERT INTO omw_v_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mwira aira vaintivaravano kuankusa toqase rumpase mwaqinta uro tiaqi quara tonemase naantiara mwaa mwatava taiqaari enaraqaa mwitaama qovara sianarove. ");
INSERT INTO omw_v_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ne mwataqi mwatatai nraaqiaravama mwaiqi vina mwaa mwatava taiqaari enaraqaa ne naavunyaasua titaarinta mwisua untu ne naqisu mwataraqaantai sia suqe si nraase qorasua ni nraaqiaranravu sia suqema nyate mwari nraase qorasua rumpa mwarenta sia suqe si airara mware mwaisua rumpa mwarenta ntitaqinta ");
INSERT INTO omw_v_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","uro tia nrora itaariraqi pisaivanta mwisua tiaqi mwaitanta qara ninta nataqi vinta nyari vai nkutitanta mwaivarave. ");
INSERT INTO omw_v_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mwisua mwini uro pisaivanta suqema nrue mwai nraase qorasua suarivano itainemase itamaqi vivaro Kotiva mwisua qova mwisuaqaa naqisiqi viranta mwiariqi vivarave. Ini aato vairere mwi kuara osara qintutama riaate, tiro. Sisasiva mwi kuara turama. ");
INSERT INTO omw_v_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sisasiva mwisua sara nyitero mwiraqaantairo nrai vaintivara ntusi tiro, Né mpotuqi mwaari nenta né naane nramai nrukaqi tarenta tarasini uro né vi mwaivaqe ne vainti nraase qora ntusi tiarinta mwini nyari mwaaqani nyari mwaaqani vuate, tiro tuvo. ");
INSERT INTO omw_v_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sisasiva mwitaa timwase mwiva vainti nraase qora nyari mwaaqani nyari mwaaqani ntusi tiro mwiraqaantai Kotirara sapara siase tiro mwera aataqaa vuvaro ena suvaro Sisasiva aataqaa mwinto nrariaraa mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","mpotuvano nramai vutaqaa vuvaro saaravano tuqi viro Sisasira vaintivaravano mpotuqi mwausua mwini vuarenta tinta sunantai saaravano tuqi vuvarora tiro, nramaivano mpotu sampi raaquqi raaquqi vurama. ");
INSERT INTO omw_v_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Saaravano tuqi vuvaro nramaivano mpotu raaquqi raaquqi vi mwauvaro va ataa suvaro Sisasiva nramaiqaa iquqaantai naaqi viro mwira vaintivaravano mpotuqi mwausua vunani vuvanta ");
INSERT INTO omw_v_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","mwira vaintivaravano takuovaro Sisasiva nramaiqaa iquqaantai naaqi nruvanta mwisua mwira takuenta nroraqamase aatu sinta mpo se tinta, Tovevaanavanove, ti mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sisasiva mwisuara va tiro, Né qaqi mwariate. Ne mwivave. Sia aatu siate, tiro tuvo. ");
INSERT INTO omw_v_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sisasiva mwitaa tuvaro Pitaava tiro, Nrora vaintio, re qutaa mwairarere re ni timwa miqe nevaqa nramaiqaa niquqaantai re mwariaranani vuase, tiro. Pitaava mwitaa tuvaro Sisasiva tiro, So tukuane, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Mwitaa tuvaro Pitaava mpotuqintai mwaavi nero mpotu mwini pisero nramaiqaa iquqaantai naaqi viro Sisasiva sunani vurama. ");
INSERT INTO omw_v_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pitaava mwini vitaro tiro, Ne so nramaiqaa vuasarave, timwa tero takuovaro saaravano nroraqamase tuvaro Pitaava mwirara nau riovaro aatu itovaro mwiraqaantai mwiva nramaiqi mweva nare utura Sisasirara sapara siro tiro, ");
INSERT INTO omw_v_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mpo, nrora vaintio, ni tumwaraane, tuvaro Sisasiva va nrai saquqaantai mwiti Pitaara vite tiro, Re saaravano tuarinarara sia nau riaataarave. Re niara aasu nau riaataarave. Re sia niara taara aato tuataarave, tiro turama. ");
INSERT INTO omw_v_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sisasiva mwitaa timwa sero Pitaara vita mware mpotuqi mwaari novaro saaravano va taiqa vuvanta mwira vaintivaravano mpotuqi mwausua Sisasirara riariamase tinta, Re qutaa Kotira mwaaquvano mwariaro, tinta turama. ");
INSERT INTO omw_v_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","...Sisasira 12 nraaqiaravaraqintai mwo vaintivano mwira utu Sutaasi Ikeriotiva mweva nero Kotira aira mwara mwate mwau vaintisua mwisua nrora vaintivaravano mwaunani viro uro mwisua mwata rie tiro, ");
INSERT INTO omw_v_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ne Sisasira ini ntaquqi uro saarinta né nara soqaave ni mivarave siavo? tuvanta mwisua ori mono 30 nravu saara nuase mwira mwuvaro ");
INSERT INTO omw_v_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sutaasiva mwi monora mware mwi enaraqaantai mwisua ntaquqi uro Sisasira saari aarara mpuaamaqi vura. ");
INSERT INTO omw_v_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sia ntoto mpereti sarara omwata nre enanravuva nrinovanta ntaaru enaqaa mwira nraaqiaravaravano Sisasiva sunani nrinenta tinta, Ntaraqive tenravu uro terama mwataarara re vesasuto enarara rietarama mwi sarara nrenarave? tinta. ");
INSERT INTO omw_v_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mwinravusua mwitaa tuvaro Sisasiva tiro, Nenravu Ierusaremi mwatusani uro mwi vaintirara mwitaa tiate, Tirinravu mwaara ti mwai vaintiva mwitaa tiro, Ni enama nrinaiso. Ne nena nraaqiara vaqamasena ri nraavuqi vesasuto sarara nrarenave tiso, tiate, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sisasiva mwitaa tuvanta mwira nraaqiaravaravano mwi sarara Sisasiva tunema senta temwanaama tora. ");
INSERT INTO omw_v_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sara temwanaama tovaro ena suvaro Sisasiva nrai nraaqiaravaravaqa uro sara taintaqaa mwataqaa mwairo ");
INSERT INTO omw_v_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","sara nre mwariro tiro, Ne tiarinta riaate. Iniqintai mwovano nramwutaa vuqaa ni qovarama saanarove, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mwitaa tuvanta mwira nraaqiaravara mwuntusa sia suqe suvanta mwinravusua nkuaiqa nkuaiqa Sisasira mwata rie tinta, Nrora vaintio, re niarave tiaro? Sia ne mwivave, sia ne mwivave, timwaqinta vinta. ");
INSERT INTO omw_v_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mwitaa timwaqi vuvaro Sisasiva tiro, Nrai mpereti mwarase nivaqamase tanaaqi mwaati tumwaraariva mwi vaintiva ni qovarama saanarove. ");
INSERT INTO omw_v_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ni mwataqi mwatatai nraaqiarara niara ntaaru enaqaa mwitaa ni ruse kuara qumwaara ratorave. Mwi kuava mwivau vasianarove. Ni mwatani mwatatai nraaqiarara qovarama saari vaintirara ne mpo se timwa mwatauko. Mwira nrova sia mwira mwatataqe sove tiataarave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sisasiva mwitaa tuvaro Sutaasiva mwira qovarama saariva Sisasira mwata riero tiro, Mwaara ti mwariara vaintio, re niarave tiaro? tuvaro Sisasiva tiro, Eo, re tianarave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sisasira nraaqiaravaravano sara nre mwauvaro Sisasiva mpereti sara mwarase Kotirara suqemave timwase uveqase nrai nraaqiaravara nyiro tiro, Mwaa sarara mwara nraate. Mwaa mperetiva ni mwavanama siso, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mwitaa timwase Sisasiva uaini nramai mwiraqi vasu kaapura mwarase Kotirara suqemave timwase mwinravusua viti nyiro tiro, Né esaa mwaa nramaira nraate. ");
INSERT INTO omw_v_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mwaa nramaiva ni nraarema siso. Kotiva nraase qora vaqamase nkuaaqa naataruse mwairero qaraasa kua mwatarerove. Mwi kuava kempusaqama vasiarive tiro ni nraarevano mwi kuara kempusaqama saanarove. Ni rusaivaro ni nraarevano naariva vaaqara nraase qora saisaqa sitaro mwisua sia suqe kua nrunka nyataanarove. ");
INSERT INTO omw_v_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ne tiarinta riaate. Mwaa enaraqaantai ne sia uaini nramai qava nrarenave. Ne sia nraraitina mwitaamaqi vuarinta né ni nkova naqisiariraqi nivaqa uro mwaivaqe ne mwi enaraqaa inivaqa mwaitana qaraasa uaini nramai nraasarave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sisasiva mwitaa timwase nrai nraaqiaravaravaqa Kotirara isi timwase mwevane Orivi taaqiqaa vurama. ");
INSERT INTO omw_v_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mwinravusua mwini vuvaro Sisasiva mwinravusua timwa nyiro tiro, Nenravu mwate enaqi ni mwaini sentama aatumaqi sanenta vivarave. Kotira vukuqi qumwaara rato kuava mate mwivau vasianarove. Mwitaa tiro: Sipisipiqaa naqisiari vaintira Kotiva mwira nuqutu sairanta sipisipi mwisua aatumase nyiariara nyiariara sampi mwona mwona vivarave, turave. ");
INSERT INTO omw_v_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","So naantiara ni mwara qaqi ntivima saqe ne mwarina ini vuni ne naane Kariri mwatani virenave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Sisasiva mwitaa tuvaro Pitaava qao tiro. Esaa mwinravusua ri mwaini senta aatumase sanama tenta vivaqe ne aasu rivaqa mwariasarave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pitaava mwitaa tuvaro Sisasiva tiro, Ne tiarira re riaane. Mate enaqi kukoraaravano sia qukarairara re taaramo nrau niara tira sia mwi vaintira takuaukavave tinarave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Sisasiva mwitaa tuvaro Pitaava qao tiro, Ne sia riara sia mwira takuaukavave tiasarave, tiro. Pitaava mwitaa tuvanta Sisasira nraaqiara mwonravuvanovaqa mwi kuara aasu tura. ");
INSERT INTO omw_v_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mwiraqaantai Sisasiva nrai nraaqiaravaravaqa mase uro viro saqava tutoraqi mwira utu Kesemani mwiraqi urone nrai nraaqiaravarara tiro, Nenravu mwaini mwataqaa mwaivaqe ne mwuruni uro Kotirara sapara siase, timwase ");
INSERT INTO omw_v_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pitaaravaqa, Sepetira mwaaqutanavaqa, mwinravusua aasu ntita mware mwini vitaro sia suqe aato riovaro mwira mwuntusavano sia suqe suvaro ");
INSERT INTO omw_v_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","mwiva taaramonravuara tiro, Ni mwuntusavano nroraqamase nitampiso ni rusarero votaama vasisana mwauko. Nenravu mwaaqaa mwaitanta ni vaqamase mwaitanta vu mpairase takuetanta mwariate, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mwitaa timwase Sisasiva sia muasaaqama vire uro vurianantai mwataqaa untu niro Kotirara saparamase tiro, Mpo ni nko, re sove tirere ne nitampi nramaira nraarira votaa re mwi nramaira qaqini mwara saane. So sia ne nena mwaraataaraqaa mwararenave. Ne re mwaraase tinaraqaa mwararenave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sisasiva mwitaa timwase uro nane nrai nraaqiara taaramonravu sonani untu takuovanta mwinravusua vu ruara suvanta vaite mwauvaro Sisasiva Pitaarara tiro, Naraqamave né taaramonravu ni vaqamase pataqa mwaritanta sia vu mpaira senta takuetanta mwariavo? ");
INSERT INTO omw_v_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ininravuara mwinravusua sia suqe aira mwaraate tiro, Saataaniva ininravu amaqe siasorave mwirara rietanta né vu mpairase takuetanta Kotirara sapara si mwariate. Ininravu mwaranavano mwitaa siataa sisaro ini mwavanavano aasu sia so kempusaqa sisanta mwariavo, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sisasiva mwitaa timwase qava taaramonravu mwini se uro qava Kotirara saparamase tiro, Mpo ni nko, mwaa kaapuraqi vasi nramaira sia re qaqini mwara saraitira niara mwira qaqi nraane tirere, ne re mwaraataaraqaa mwaraasarave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sisasiva mwitaa timwase qava uro nane untu takuovanta mwira nraaqiara taaramonravu vu ruara suvanta vaite mwaura. ");
INSERT INTO omw_v_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mwinravusua vaite mwauvaro Sisasiva qava mwinravusua mwini se uro vi Kotirara taaramo nrau sapara siro ota tunemase nkuaa qaramase Kotirara saparama sora. ");
INSERT INTO omw_v_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kotirara saparama taiqase Sisasiva uro nanero untu taaramonravuara tiro, Mpo, nenravu qaqi sositantave vaitaavo? Ni mwataqi mwatatai nraaqiarara ni navaatavu mwarenta uro sia suqe si airara mware mwaisua mwisua ntaquqi ni sevarave. ");
INSERT INTO omw_v_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ntivivaqenravu vuare. Ni qovarama saari vaintiva nri mwaiso, tiro... ");
INSERT INTO omw_v_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","...Sisasiva mwitaa tuvanta mwisua mwira navaatavu sovanta mwira nraaqiaravaravano mwira mwini senta nyiari aatu vurama. ");
INSERT INTO omw_v_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mwira nraaqiaravaravano sane vuvanta Sisasira navaatavu sosua mwira vita mware Kotira nraavuqi aira mware mwausua mwisua vunyaa vaintivano mwauraqi Kaiapaasira nraavuqi uro sovanta mwi nraavuraqi mwaara osara ti mwau vaintivarsuavaqa, Iutaa vainti nroranravuvanovaqa, suntu nukaama mwaura. ");
INSERT INTO omw_v_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Sisasira vita mware uro se mwauvaro Pitaava niarantai mwisua ntataqi viro Kaiapaasira nraavu mwatusani urone tosani mwaantine vutaqi viro mwi irainarava qovara siarira takuarero uro mwi nraavuraqaa vaivaraara naqisi mwau vaintisua vaqamase mwataqaa mwairo mwaura. ");
INSERT INTO omw_v_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pitaava mwini mwataqaa mwauvanta nraavuqi Kotira nraavuqaa naqisi mwau vaintisuavaqa, esaa mwiraqi suntu nukaama mwau vaintisuavaqa, mwisua Sisasira rusareranta Sisasiraqaa muna kua mwataare tuvaro ");
INSERT INTO omw_v_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","sia mwi kuava vauvanta qumina mwi kuara mpuaasitanta mwo vainti mwo vaintivano ntivinta Sisasirara muna kua tura. Mwitaamaqi aasu vuvanta mwiraqaantai vainti taaratanavano ntivinta ");
INSERT INTO omw_v_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Sisasirara tinta, Mwaa vaintiva mwitaa tisanta tetana riaunarave. Mwiva tiro, Ne soma Kotira nraavu mpaira sena mwiraqaantai taaramo ena aasu mwarina mwi nraavura qava soqa taiqa saasarave, tisanta riaunarave, tinta. ");
INSERT INTO omw_v_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mwitana mwitaa tuvaro Kotira aira mwara mwate mwau vaintisua mwisua vunyaa vaintivano ntiviro Sisasirara tiro, Mwitaa mwitaama riqaa kua mwate mwariavo? Re mwo? Re nyaritanara narave tinarave? tuvaro ");
INSERT INTO omw_v_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sisasiva sia kua tiraitiro, tire mwauvaro qava vunyaa vaintivano Sisasirara tiro, Ne Kotira vuqaa mwaina mwira utu netana riarama qutaa kua tiane tuko. Qutaave Kotiva ri vusitisarave re tiri saisaqa sirera Mesaia vaintivano mwariaro? Qutaave re Kotira mwaaquvano mwariaro? Re tiri timwa timwiqe riaare, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mwiva mwitaa tuvaro Sisasiva tiro, Re tianara ne mwaa mwivave. Ne tiarinta né riaate. Né naantiara takuaivaqe ne mwataqi mwatatai nraaqiarava nroraqama vina Kotiva kempusavano mwariarinani mwira saqu tanaranani mwataqaa mwaitana iravuqi tukuasarave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sisasiva mwitaa tuvaro Kotira aira mwara mwate mwausua mwisua vunyaa vaintivano nrai tuavaaqa nuqeqaamase tiro, Mpo mwiva Kotira vuqaa mwaitaro sia suqe si kuara aasu tiso. Mwo vaintivano mwiraqaa kua mwatataarira qumina aasara nevorave. Takuaate, né vaa riaavaro mwiva Kotira vuqaa mwaitaro sia suqe si kuara tiso. ");
INSERT INTO omw_v_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwira saara né Sisasirara nara kuave tivarave? Né tivaqe riaase, tiro. Mwitaa tuvanta mwisua tinta, Mwira sia suqe airavano virintoma vaiso. Mwira saara mwira ruseva aasu vaiso, tinta. ");
INSERT INTO omw_v_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mwisua mwitaa timwase uro Sisasira vuriqi taara visise mwisua nyai saquqaantai mwira nuqutuse mwira vu aato nuqutuse mwisua mwira mwoqanya kua tinta, Mesaia vaintio, qutaa re kua qovarama sera vaintiva mwairere sia takuaraitira ri nuqutuari vaintira utu tiqe te riaare, tinta tura. ");
INSERT INTO omw_v_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nraavuqi ko timwaqinta vi mwauvaro Pitaava mwaatani mwatusaqaa mwataqaa mwauvaro aira nraase mwovano Pitaara aaqani viro mwirara tiro, Revaqa Sisasira mwaata Karirinyaavama mwariaro, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mwiva mwitaa tuvaro Pitaava mwisua ntuqaa mwaitaro qao tiro, Re tiana kuara sia ne mwira qintuta surave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mwiva mwitaa timwase uro tosa qentana mwauvaro aira nraase mwovano Pitaara takuero mwiraqi ntivi mwausua timwa nyiro tiro, Mwaa vaintiva Sisasira Naasaretinyaara vaqamase mwaivave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mwitaa tuvaro Pitaava saqu iqiqaa se tiro, Sia ne mwi vaintira takuaurave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mwitaa timwase sia muasaaqama mwauvanta mwiraqi ntivi mwausua Pitaava mwaunani uro nenta mwirara tinta, Sisasira nraaqiaravaravano mwi mwatanaasua mwariavara qutaama revaqa nkuaa mwi mwatanaava aasuma mwariaro. Mwisua tiri kua kuantase tianemase revaqa kuantase ti mwariaro, tinta. ");
INSERT INTO omw_v_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mwisua mwitaa tuvaro Pitaava qava saqu iqiqaa se tiro, Ne sia qutaa kua tiariro Kotiva soma ni nuqutu saanarove. Ne qutaa tuko. Né ti mwaria vaintira sia ne mwira takuaurara né tiavo, tiro. Pitaava mwitaa tuvaro vaa kukoraaravano qukarora. ");
INSERT INTO omw_v_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kukoraaravano qukarero suvaro Pitaava mwiraqaantai Sisasiva timwa mwu kuara riero. Sisasiva mwitaa turave. Kukoraaravano sia qukarairara re taaramo nrau niara tira sia ne mwira takuaurave tinarave tu kuara Pitaava riatero mwiva mwaaqani vuvaro mwira mwuntusavano sia suqe suvaro mwiva nroraqamase natora. ");
INSERT INTO omw_v_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ena suvaro Arimatianyaava vaaqara irainara mwato vaintiva uro ne. Mwira utu Sosepiva mwiva Sisasira nraaqiaravano mwaura. ");
INSERT INTO omw_v_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mwi vaintiva uro ne Pairaativa mwauraqi uro Sisasira mwavana miqe mwaqina qunama taase tuvaro Pairaativa nrai naqu vaintisua titero Sisasira mwavana mwira mwiate tuvaro ");
INSERT INTO omw_v_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sosepiva uro Sisasira mwavana satariqaantai itu mwataqaa se qaraasa vaaqa tasuqu vaaqara mwarase mwira nraavumase ");
INSERT INTO omw_v_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","mwaqi untu nrai naantiara qutu vuarinarara rietaro ori ukutoraqi mwira mwate nrora ori mwo mwira raapuqi vi ori ukutora mwira oqaa suvaite mwini se vuvanta ");
INSERT INTO omw_v_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariaava Makataaranyaavavaqa, mwira kokova mwo Mariaavavaqa, mwitana mwataqaa mwauvaro mwutu mwatani Sisasira mwiraqi qunamato oriva vaura. ");
INSERT INTO omw_v_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sisasiva nruka tosani uro mwariro nraase qora mwasaasa timwa nyiase tuvanta nraase qora vaaqaravano ntunu nukaama mwainta mwira ututuma sovarora tiro, Sisasiva pisero mpotuqi uro mwaari nero mwiraqi mwataqaa mwairo nramaiqaa mwauvanta nraase qoravano mwutuni nramai tosana mwaura. ");
INSERT INTO omw_v_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mwisua nramai tosana mwataqaa mwauvaro Sisasiva mwo kua mwo kuaqaa nuase tiro timwa nyura. ");
INSERT INTO omw_v_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Sisasiva tiro, Ne tiarinta riaate. Vainti mwovano sara suku pisarero vurave. ");
INSERT INTO omw_v_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mwiva sara suku pisaqiro vuvaro sini sukuvano aara tosani untu nuvaro kurivano mwiri mwira nramwa sorave. ");
INSERT INTO omw_v_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mwitaa suvaro sara suku mwonravuvano ori mwataqaa untu nuvaro mwatavano sia mwevaniqama vau mwatava vasuvarora tiro sukuvano untu niro vaavaama kutovaro ");
INSERT INTO omw_v_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","suarivano nrinero itamaqi viro aasaraqama sovaro mwira tuqavano sia mwataqi mwevani vurara tiro, aasarama urave. ");
INSERT INTO omw_v_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mwitaa suvaro sara suku mwonravuvano kuankusa kutoraqi untu niro kuankusa vaqamase nivuvaro kuankusavano suku mwira numwaqu sovaro sukuvano sia tava riorave. ");
INSERT INTO omw_v_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mwitaa suvaro sara suku mwonravuvano suqe su mwataraqaa untu niro suqemaseniviro uro suqema tava riatovaro sini suva mwira aatarase niviro uro suqe tava vaaqara tava riatovaro sini suva mwira aatarase niviro uro suqe tava vaaqara tava riatorave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sisasiva mwi kuaraqaa nuase timwa taiqase tiro, Ini aato vasirente mwi kuara qintutamase riaate, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sisasiva kua timwa nyi taiqa sovanta nraase qoravano nyiari mwaaqa nyiari mwaaqa vuvaro Sisasiva nraria mwauvanta mwira nraaqiara 12 nravuvanovaqa mwo susuavaqa Sisasiva mwaunani nrinenta Sisasiva mwi kuaraqaa nuase tu osarara sia qintutama siraitinta, mwisua Sisasira mwata riovaro ");
INSERT INTO omw_v_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sisasiva mwisua timwa nyiro tiro, Kotiva nraase qoraqaa naqisiari kuara qumpau tai kuara mwi kuara Kotiva iniara qaqi sairanta mwi kuara osara riaate timwase mwiva qaqi nraase qora qaqini mwaisua mwi kuara osara sia qintutama sera timwa nyiane tisana ne mwi kuaraqaa nuase mwisua timwa nyitana sia mwi kuara osara mwisua timwa nyuko. ");
INSERT INTO omw_v_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ne mwo kuaqaa nuase tiarinta nraase qoravano rientama sia qintutamase rievarave. Mwisua ni kuara aato tarase sia qintutamase rievarave. Mwisua nyiari sia suqe si airara qaqira pisaisarove Kotiva mwisua nyiari sia suqe si airara mware kuara nukaama nataanarove, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sisasiva mwitaa timwase mwinravusuara tiro, Né mwo? Ne mwi kuaraqaa nuase tu osarara né siave qintutama riaavo? Né sia mwi kuara osara qintutama riaraitinta naantiara ne mwo kuaqaavaqa nuasena tiari kuara né ntataama senta so qintutamase rievarave? ");
INSERT INTO omw_v_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ne ota mwi kuaraqaa nuase tu osarara ini timwa nyirenave. Vaintivano sara suku mwataqi pisora mwi kuara osara vairero Kotira kuama vaiso. ");
INSERT INTO omw_v_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sara sukuvano aaraqaa untu nora mwira osara vairero vainti nraase qora mwonravuvano mwi sukura votaama mwariasuave. Mwi vainti nraase qorasua Kotira kua riaavaro Saataaniva nrinero mwisua vu aato mwuntusaqintai mwi kuara navisi mwarairave. ");
INSERT INTO omw_v_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ori mwataqaa untu ni sukura osara vairero nraase qora mwonravuvano mwariasuave. Mwinravusua Kotira mwasaasa rienta mwi kuarara riariamasemwariavaro ");
INSERT INTO omw_v_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kuavano sia mwisua mwuntusaqi visanta mwi nraase qorasua sia mwi kuara mwo nrau mwo nrau riaraitinta mwariavanta, mwi kuara saara mwo siasua mwisua sia suqema utu nyatare siavanta mwisua tiri rivorave tinta Kotira kua vaa qaqira pise mwaria vainti nraase qorasua mwariarave. ");
INSERT INTO omw_v_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nraase qora mwonravuvano kuankusa kutoraqi piso sukura votaamase mwariasuave. ");
INSERT INTO omw_v_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mwi nraase qorasua Kotira kua rienta mwiraqaantai mwisua mwataqiaa irainarara nroraqamase riaqinta vitanta monorave mwo irainararave riariamaqi vitanta mwo irainara mwo irainara mwararenta riaqinta vinta Kotira kua qaqira pisaavaro Kotira kuavano sia mwi nraase qorasuaqi vaisanta mwariarave. ");
INSERT INTO omw_v_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mwisua mwitaa siavanta mwo vainti nraase qoravano suqe mwataqaa untu ni sukura votaama mwariasuave. Mwi nraase qorasua Kotira kua rienta mwi kuarara qutaave tinta mwi kuara riaqinta vinta suqe aira Kotirani mwaqi vuarave. Mwisua sininravuvano Kotira kua rietanta aatarase suqe aira Kotirani mwaqi vinta mwariavanta sini nravuvano mwisua aatarase suqe aira Kotirani mwaqi vinta mwariavanta sini nravuvano mwisua aira aatarase suqe aira Kotirani mwaqinta vuarave, tiro. Sisasiva mwi kuara turama. ");
INSERT INTO omw_v_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","...Sisasiva mpotuqi viri nane nrukaqi tare sinyaa tarasini vuvanta mwini nraase qora vaaqaravano suntu nukaa nukamase Sisasiva mwaunani ututuma mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","vainti mwovano mwi mwatusaraqi mwaara nraavuqaa naqisi mwauva Sairaasiva mwiri nriro Sisasira takue uro mwira iqutarani untu niro ");
INSERT INTO omw_v_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mpo se tiro Sisasirara tiro, Ni naavuravano qutuariva mwataqa vaiso. Revaqa vaa nritara rena saqu mwiraqaa mwatairaro mwira qaravano taiqairaro so qaqi mwariarive, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mwi vaintiva mwitaa tuvaro Sisasiva mwiravaqa vura. ");
INSERT INTO omw_v_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","...Sisasiva mwiravaqa aarana vi mwauvanta vainti mwonravuvano Sairaasira nraavuqintai nritanta Sairaasira vitenta mwirara tinta, Mpo, ri raavuravano qutu viso. Mwaara ti mwai vaintira re sia navaata vuane, tuvaro ");
INSERT INTO omw_v_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sisasivavaqa mwinravusua kua riero mwaara nraavuqaa naqisu vaintirara tiro, Sia aatu siane. Re niara nroraqamase riaane, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sisasiva mwitaa timwase mwiva Pitaaravaqa, Semisiravaqa, Semisira qata Soniravaqa, mwinravusua aasu ntita mware ");
INSERT INTO omw_v_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","uro Sairaasira nraavuqi uro takuovanta vainti nraase qoravano nroraqama senta mpo tinta nate mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sisasiva nraavuqi mwaari nero tiro, Narare né nate mwariavo? Mwi kuaasiva sia qutu viso. Mwiva qaqi vaite mwaiso, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sisasiva mwitaa tuvanta mwisua Sisasiva tu kuarara qaqi aaritara suvaro Sisasiva esaa nraase qora raaqu mwaaqani se kuaasi mwira nrosua qosuavaqa, taaramonravu nraivaqa nrusuavaqa, Sisasiva mwinravusua aasu ntita mware kuaasivano qutu vunani uro ");
INSERT INTO omw_v_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","mwira saqu tuaarere nrai kuanantai tiro, Tarita kumi - mwaa kuaasio, ne riara nti vuane tuko, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sisasiva mwitaa tuvaro mwi kuaasiva vaa ntiviro nrue mwauvo. Mwi kuaasiva 12 isi mwarasova ntiviro viro nriro mwauvanta mwinravusua mwira takuenta mpo mpo tinta saqu nunkinkiraara tenta sinta mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sisasiva mwinravusuara irora siro tiro, Né mate takuaa airara sia mwo vaintivaqa timwa nyiate. So mwaa kuaasirara sara aasu mwiate, tuvo. Sisasiva mwi kuara turama. ");
INSERT INTO omw_v_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mwo ena vaaqara nraase qoravano Sisasira takuarenta vitare nritare si mwauvanta Sisasivavaqa nrai vaintivaravaqa sia so sara nrarenta qaqi mwauvaro Sisasiva mwitaa tiro, Vivaqenravu sia vaintivaqa sisanta uro mwariare, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mwitaa timwase nrai vaintivaravaqa ntitero mpotuqi mwaari nero nramai nrukaqi tarero qumina santa virero vura. ");
INSERT INTO omw_v_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mwinravusua mwini senta vuvanta vaaqara nraase qoravano mwinravusua takuenta mwinravusua mwini virenta sunaniara rienta mwo mwatusaqi mwo mwatusaqintai mwisua sanenta nramai nruka tosantata mwata nuna sanenta uro Sisasiva vuase tunaniara mwisua nanenta uro nenta. ");
INSERT INTO omw_v_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mwisua nanenta uro novaro Sisasiva uro ne mpotuqintai mwataqi mwaavi ne takuovanta nraase qora vaaqaravano nukaa sinta mwauvaro Sisasiva mwisuara mpo tiro mwitaa tiro, Vaintivano sia sipisipiqaa naqisi mwarisanta sipisipivano nyariara sampi nrue mwaria sipisipisua mwisua votaasua mwaa nraase qorasuavaqa sampi nrue mwariavo, tiro. Mwitaa timwase Sisasiva mwinto mwaitaro mwisua mwo kua mwo kua timwa nuvo. ");
INSERT INTO omw_v_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sisasiva kua tiaqi vuvaro suarivano tukiro vuvanta Sisasira vaintinravuvano mwirara tinta, Mwaini qumina mwatasantave. Ena siaso. ");
INSERT INTO omw_v_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Re nraase qora ntusi tiranta mwisua mwo mwatusa mwo mwatusa nruenta ori ninta sara mwaraate. Mwisua sia saravaqa mware nriasuave, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sisasira vaintinravuvano mwitaa tuvaro Sisasiva qao tiro, Néntavano sara mwisua niate, tiro. Mwitaa tuvanta mwinravusua qao tinta, Te nrora orive 200 kinaave sove ninta sara mwasenta mwisua niaraarave? tuvo. ");
INSERT INTO omw_v_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mwisua mwitaa tuvaro Sisasiva nrai vaintinravu mwata riero tiro, Nara nara mpereti sarave vaiso. Né uro takuaate, tiro. Mwitaa tuvanta mwinravusua uro takuenta Sisasira timwa mwinta tinta, Mpereti sara nkuaa saquru aasu vaiso. Tavusa taarama aasu vaiso, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mwinravusua mwitaa tuvaro Sisasiva nraase qorara tiro, Né esaa musau santa mwataqaa mwariate, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mwitaa tuvanta mwisua mwo santa 50 nravuvano mwataqaa mwauvanta mwo santa 100 nravuvano mwataqaa mwauvanta mwitaamaqi vinta vinta esaa nraase qoravano mwataqaa mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sisasiva mpereti nkuaa saquru mwase tavusa taarama mwase naavuni takuetaro Kotirara saparamase sarara suqemave, tiro. Sisasiva mwitaa timwase mpereti sara uveqase mwiva nrai vaintinravu niro tiro, So né sara mwarenta uro mwisua nivanta mwisua esaa nraate, tiro. Sisasiva mwitaa timwase mwiva tavusa taaramavaqa mwase airase nyuvo. ");
INSERT INTO omw_v_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sisasiva mwi sarara nrai vaintivaranravu nyuvanta mwinravusua uro nraase qora nyuvanta mwisua esaa so nrorama. ");
INSERT INTO omw_v_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","So nrovanta Sisasira vaintinravuvano mwiraqaantai vunato tuara nrora tua mwarenta uro nraase qoravano mperetivaqa tavusavaqa nretanta viti piso sarara suntu senta nrora tua 12 nravu ntunu senta kuraama sorama. ");
INSERT INTO omw_v_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mwi enara 5000 qoravano mwi sarara nrovanta nraase vaaqaravanovaqa mwi sarara nrorama... ");
INSERT INTO omw_v_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sisasiva nrai vaintivaravaqa viro Seriko mwatusani uro viro mwi mwatusara aatarero vire suvanta nraase qora vaaqaravano mwira vataqinta vi mwauvaro vu qimpa vu vaintiva Vatimiasiva Timiasira mwaaquvano mwariro mwitaa su irainarara naaru tiro miate ti mwau vaintiva aara tosani mwataqaa mwairo. ");
INSERT INTO omw_v_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mwiva mwini mwaitaro Sisasiva Nasaretinyaava nritaraarirara riero mwiraqaantai mwiva nroraqamase Sisasirara saparamase tiro, Sisasio, Ntevitira mwaaquo, re niara mpo tiane, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vu qimpa vu vaintiva mwitaa tuvanta nraase qora vaaqaravano mwirara irora sinta tinta, Re o suvaitaane, tuvaro mwi vaintiva sia mwisua kua riarero qava nroraqamase saparamase tiro, Ntevitira mwaaquo, niara mpo tiane, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Vatimiasiva mwitaa tiaqi vuvaro Sisasiva mwiraqaa ntiviro mwairo tiro, Sapara sivaro nriarive, tuvanta mwisua vu qimpora saparamase tinta, Re riariamase mwariane. Nti vuane. Mwiva ri sapara siso, tinta. ");
INSERT INTO omw_v_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mwisua mwitaa tuvaro vainti mwiva nrai vaaqa utora raaqu qaqini se ntiviro Sisasiva ntivi mwaunani vuvaro ");
INSERT INTO omw_v_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sisasiva mwira mwata riero tiro, Ne ri ntataa siase tukare re nriaro? tuvaro vu qimpa vuva tiro, Mwaara tiara vaintio, re ni mpu mpaira saane tina nrukavave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mwitaa tuvaro Sisasiva tiro, Re so vinarave. Re niara mwiva so ni saisaqa sianarove tiararoma ri vuvano suqema viso, tiro. Sisasiva mwitaa tuvaro mwira vuvano mpaira vuvaro mwi vaintiva so takuora. Mwiva so takuova Sisasivavaqa mase aarana vura. ");
INSERT INTO omw_v_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sisasiva mwitaa timwase mwo kuaqaa nuase mwisua timwa nyiro tiro, Vainti mwovano uaini sana mwara tute tosani urisa rate mwata qukuse uaini tava tatiarira ututuse vaivaraara tainta utute mwate niarani mwo mwatani virero siro mwo susua timwa nyiro tiro, Né ni uaini vutaqaa ninani naqisi matenta né sini uaini tava siqisenta nénta mwaretanta sini uaini tava mwara ninani mataate, tiro. Mwitaa timwase mwiva niarani mwo mwatani vurama. ");
INSERT INTO omw_v_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mwini uro mwauvaro uaini tava siqu enava nrinovaro mwiva nrai aira vainti mwo titero tiro, Re uro ni nraasoqaa naqisi mate mwaisuara tiranta uaini tava ninanivaqa siqi mataate, tuvaro ");
INSERT INTO omw_v_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","mwira aira vaintivano mwini vuvanta mwira nraasoqaa naqisi mwate mwau vaintisua mwira aira vainti navaatavu senta saavuqaantai mwira nuqutuse mwatenta sia uaini tava siqi mwiraitinta, qaqi mwira titovaro uro nane vura. ");
INSERT INTO omw_v_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Qaqi uro nane vuvaro nraaso qova nrai aira vainti mwo titovaro vuvanta mwira nraasoqaa naqisi mwate mwausua mwira aira vainti qiata rasenta sauri irainara mwurama. ");
INSERT INTO omw_v_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mwitaa suvaro nraaso qova nrai aira vainti mwo titovaro vuvanta mwisua mwira rusenta. So mwitaamaqi vinta sini mwira aira vainti titosua saavuqaantai nuqutusenta sini rusorarama tina. ");
INSERT INTO omw_v_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mwira aira vaintinravu taiqa sovaro vainti nkuaiqa aasu mwaura. Mwi vaintiva nraaso qora mwaaquvano mwauvaro mwira qova nrai mwaaquara mwuntusa nuvaro mwau vaintiva mwauvaro mwira qova mwiravaqa naantiara esaara titero tiro, Mwisua ni maaqu takuenta niara mwira mwaaquve titanta mwira suqema mwatevarave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mwitaa timwase nrai mwaaqu titovaro mwini vuvanta mwira nraasoqaa naqisi mwate mwau vaintisua mwira mwaaqu takuenta nrai timwa mwi nrai timwa mwinta tinta, Mwira qova qutu viraro mwaa vaintiva nrai qora mwatavaqa mwitaa irainaravaqa mwaraarivama mwaiso. Mwaraivaqe te mwira rusaararo mwiva mwarare siari irainarava tirini aasu vasiarive, tinta. ");
INSERT INTO omw_v_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mwisua mwitaa timwase mwira mwaaqu navaatavuse ruse mwaatani mwaati mwira pisorave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sisasiva mwitaa timwase mwiva nraase qora mwata rie tiro, Mwisua mwitaa surara tiro, nraaso qova nrai mwaaqu rusorara ntataave sianarove? Nraaso qova nrine nrai nraasoqaa naqisi vaintisua ru taiqase mwonravuara tiro, Né ni nraasoqaa ninani naqisi mataate, tianarove. ");
INSERT INTO omw_v_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Né siave Kotira vukuqi mwaa kuara saara nitanta riaavo? Mwi kuava mwitaama tiso: Ori nraavu utitanta mwo oriara sia suqe orive timwase qaqira pisaa oriva mwi oriva pusa oriqama viso. ");
INSERT INTO omw_v_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kotiva mwi orira mwarase nroraqama sairara tinta, te Kotira aira takuetanta suqe airave turo, turave. Kotira vukuqi mwitaama qumwaara torave. Né siave mwi kuara qumwaara tetantave qintutama riaavo? tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sisasiva mwitaa tuvanta Iutaa nrora vaintivaravano qintutama riovaro Sisasiva uaini vutaqaa nraqisi mwato vaintisuara titaroma mwiva mwisuaqaa nuase tuvanta mwisua Sisasira navaatavuse ko mwiare timwatenta nraase qoravano mwiraqi suntu nukaa nukasusua tiri irora sivo tinta mwisua aatu sinta sia Sisasira navaatavu saraitinta, qaqira pisenta vurama... ");
INSERT INTO omw_v_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mwi qararaara toqaqi Kotira aira mwara mwatate mwau vaintisua mwisua nrora vaintivaravaqa, Iutaa nrora vaintivaravaqa, mwaara osara ti mwau vaintisuavaqa, esaa kaanasori vaintivaravaqa, mwisua suntu nukaama vinta mwaitanta mwisua tiare tu kuara suntu nukaama mware Sisasira seni sanaqaantai mwira rumpa mware Pairaativa kamaanira nrora vaintivano mwauraqi uro sora. ");
INSERT INTO omw_v_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Uro sovaro Pairaativa Sisasira mwata riero tiro, Qutaave re Iutaa mwatanyaasua ntaarunya vaintivano mwariaro? tuvaro Sisasiva tiro, Re tiarava ne mwaa mwivama siso, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mwitaa tuvanta Kotira aira mwara mwate mwau vaintisua mwisua nrora vaintinravu mwo kua mwo kua saara Sisasira irora si mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pairaativa mwisua kua rietaro qava Sisasira mwata riero tiro, Re siave nyarivaqa tinarave? Mwisua vaaqara kua saara ri irora si mwariavo, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mwitaa tuvaro Sisasiva qava kempusaqamase sia kua tiraitiro mwauvaro, Pairaativa vaaqara aato ti mwaura. ");
INSERT INTO omw_v_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pairaativa nrai naqu vaintisua ntaquqi Sisasira pisovanta mwisua mwira vitaqi uro kamaanira nraavuqi se mwisua nyiari sena naqu vaintisua esaa sapara sinta suntu nukaama mwainta ");
INSERT INTO omw_v_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sisasirara mwoqanyaa kua tinta ntaarunyaa vainti vaaqa votaa sura rumpa mwataare tinta nraare vaaqa rumpa mwatenta mwiraqaantai quki sana mwarase qututumase ovaqa votaamase Sisasira qiataqaa qumwa tenta ");
INSERT INTO omw_v_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","munaqamase mwisua nyiari ntaqu vuriqaa mwatetanta muna kua timwa mwinta tinta, Iutaa mwatanyaa ntaarunyaa vaintio, re mwarirave? tinta. ");
INSERT INTO omw_v_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mwitaa timwase mwisua saavuqaantai Sisasira qiata nukavusenta mwiraqaa taara visise mwira vuqaa tori naquntanenta muna riariasitanta mwaura. ");
INSERT INTO omw_v_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mwitaamaqinta vitanta mwira nuqutu senta aaritara sinta taiqase mwiraqaantai mwisua nraare vaaqa rumpa mwatora avanuse Sisasira nrai tuavaaqa utu mwatenta mwira satariqaa niri rutenta siritarenta Sisasira vita mwarenta vurama. ");
INSERT INTO omw_v_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Naqu vaintinravusua Sisasira satariqaa niri rutenta siritarenta sitanta mwira vitaqi mwatusa mwaaqani aarana vi mwauvaro vainti mwovano mwira utu Saimoniva mwintairo nrora mwatusani virero suvanta mwisua mwirara kempusaqamase tinta, Sisasira satari re mwara qu mwarera uro mwataane, tuvaro Saimoniva mwira satari mwara qu mwarero uro mwatora. Saimoniva Sairini mwatanyaava mwiva Arekisantasua Rupusua mwitana qovama mwaura. ");
INSERT INTO omw_v_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mwisua Sisasira vitaqi uro qumina santa Korokotave tunani sora. Korokota mwaa kuaraqintai tirenta, Qiata Mwusaari santave, tunani Sisasira uro se ");
INSERT INTO omw_v_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","uaini nramai mwiraqi sunkavu irainara kuantase mwato nramaira mwira mwirenta suvaro Sisasiva sia nrora. ");
INSERT INTO omw_v_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sia nrovanta mwisua mwira satariqaa niriqaantai rutenta mwira tuavaaqa mwarase ntasua ntasua so mwarevarave timwase mwisua kaati ruanema setanta ori pisetanta Sisasira tuavaaqa ntusamase mwarora. ");
INSERT INTO omw_v_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Toqaqi suarivano mamatama vauvanta Sisasira satariqaa rutora. ");
INSERT INTO omw_v_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mwira satariqaa rutenta Sisasira qiatani kua mwo mwira ko timwa mwato kuara qumwaara ratenta satariqaa rutovaro mwi kuava mwitaama tiro, MWAA VAINTIVA IUTAA MWATANYAASUA NTAARUNYAA VAINTIVE, tiro. Mwi qumwaarava mwitaama vaura. ");
INSERT INTO omw_v_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mwisua Sisasira satariqaa rutetanta Sisasiravaqa vainti taaramavaqa rutovanta mwitana muara mware mwausua mwauvanta mwisua vainti mwo Sisasira saqu tanaranani niri rutenta vainti mwo Sisasira saqu saantotanani niri rutora. ");
INSERT INTO omw_v_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Sisasiravaqa mwitanavaqa rutorara tiro, Kotira vukuqi kua mwo qumwaara tova mwiva qovara sura. Mwitaama tiro: Mwiva sia suqe si vaintisua vaqamase mwarianarove, tura.) ");
INSERT INTO omw_v_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mwitaama rutovanta nraase qoravano vitare nritare sinta mwiri takuenta nyari vauru iqisenta Sisasira sia suqe kua timwa mwatenta tinta, Qike, re tira, Kotira nraavu mpaira senama taaramo enaqaa aira mwaretanama qava soqa taiqa saasarave, tianara mwo? ");
INSERT INTO omw_v_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","So rena saisaqa siane. Rena satariqaantai miavi naane, tinta. ");
INSERT INTO omw_v_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mwisua mwitaa ti mwauvanta mwisua tunemasenta Kotira aira mwara mwate mwausua mwisua nrora vaintivaravanovaqa, mwaara osara ti mwau vaintisuavaqa, mwisua Sisasirara aaritarama mwate tinta, Mwiva mwo siasua nraasu saisaqa si mwaiva siama nrai so saisaqa sianarave. ");
INSERT INTO omw_v_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mwiva Kotiva titai vaintiva Mesaia vaintivanove mwaiso? Mwi vaintiva Isaraari mwatanaa ntaarunya vaintivanove mwaiso? Saqe te mwaitanta takuaararo mwiva nrai satariqaantai miavi nero mwatani tukirere te mwirara qutaa tiare, tinta... ");
INSERT INTO omw_v_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sarareqaa Iutaa mwatanaasua mwaara ena taiqovanta Mariaava Makataaranyaa nraasevanovaqa, mwira kokova Iemisira nrovavaqa, Saromevavaqa, mwi nraasesua ori aquse suqemase mwunta vu irainarara mwaqinta Sisasira mwavanaqaa qumwatarenta vura. ");
INSERT INTO omw_v_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Saante toqaqi suariano mwirini nruvanta mwinravusua Sisasira qunama toraqi virenta vura. ");
INSERT INTO omw_v_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aarani vitanta mwinravusua nrai mwata rie nrai mwata rie sinta tinta, Tenravu mwini uro naararo ntavave ori nrora qentana suvaito orira raaqu timwataanarove? Mwi oriva nrora orima vaiso, tinta. ");
INSERT INTO omw_v_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mwitaa timwase mwinravusua nrinenta takuovaro ori qaqinani raaqu qaqini sova vaura. ");
INSERT INTO omw_v_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Orivano mwitaama vauvanta takuenta mwinravusua oriqi mwerane takuovaro vainti mwo qaraasa vaintivano tasuqu tuavaaqara ututo vaintiva mwiraqi sini saantaaqi mwataqaa mwaura. Mwiva mwiraqi mwauvanta mwira takuenta mwinravusua aato suvaro ");
INSERT INTO omw_v_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","mwiva tiro, Sia aatu siate. Sisasira Nasaretinyaara satariqaa rutaa vaintira nénravu mwira mpuaasi mwariavo? Mwiva sia mwaaqi mwaiso. Mwiva qaqima ntiviso. Nénravu takuaate. Mwaini mwira mwataanani siama mwaiso. ");
INSERT INTO omw_v_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","So mwaa kuara mwaqinta uro mwira nraaqiaravaravaqa, Pitaaravaqa, timwa nyiate. Mwitaama timwa nyiate. Mwiva naane ini ntuni Kariri mwatanima viso. Nénravuvaqa mwini uro vinta mwira takuevarave. Ntaaru mwiva mwaitaro mwirara ininravu timwa nyura mate mwivama qovarama viso. Mwi kuara timwa nyiate, tiro. ");
INSERT INTO omw_v_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mwiva mwitaa tuvanta aatu sitantara tinta mwinravusua Sisasira qunama toraqintai mwevane sanenta aarani vitanta sia mwosuavaqa timwa nyiraitinta vura. ");
INSERT INTO omw_v_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","...Sisasiva mwo mwatusa mwira utu Neni mwatusani vuvanta mwira vaintivaravanovaqa vaaqara nraase qoravanovaqa Sisasira vataqinta vuvaro ");
INSERT INTO omw_v_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sisasiva mwi mwatusara qentaqaa uro takuovanta mwi mwatusaraqintai nraase qoravano qutu vu vaintira mwarenta mwira qunarenta timwa tenta nrurama. Qutu vu vaintiva taqe nraase mwira mwaaquvano mwauvanta vaaqara nraase qoravano mwi nraaseravaqa mwasenta nruvaro ");
INSERT INTO omw_v_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sisasiva mwi nraasera takuovaro mwira mwuntusa nruvaro Sisasiva mwi nraaserara mpo se tiro mwirara tiro, Sia nataane, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sisasiva mwitaa tiate uro qinkera tumwarovanta vaintinravuvano qinkera mwira mwarosua mwiraqaa mwataate mwauvaro Sisasiva tiro, araasa vaintio, ne riara qaqi nti vuane tuko, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tuvaro qutu vu vaintiva ntiviro quturaqintai ntiviro kuavaqa tuvaro Sisasiva mwi vaintira nrai nrora mwurama. ");
INSERT INTO omw_v_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sisasiva mwitaa suvanta vainti nraase qora esaa nroraqamase aatu itovanta Kotira utu tuaare renta tinta, Mpo paropeti vainti nroravano tiri vutaqaa qovarama viso. Te Kotira nraaqiara suraro mwiva sia tiri pisaivave, tinta. Mwisua mwitaa tuvaro Sisasiva aira mwaro mwasaasava esaa Iutaa mwaatanivaqa Iutaa mwata mwataqa vau mwatusaniaravaqa viro mwi kuava vitaro nritaro suvanta esaa mwi kuara riorama. ");
INSERT INTO omw_v_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ni namwunaao, ini mwavana aasu rusesua sia mwisua aatu aatu siate. Mwisua ini rusenta ini mwaranavaqa sia so rusevarave. ");
INSERT INTO omw_v_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Né ntara aatuve sivara siavo? Saqe ne ini timwa nyiase. Né Kotira aatu aatu siate. Mwiva kempusaqa siva mwaitaro mwiva vainti mwo ruse mwiraqaantai so mwi vaintira qutu visua vuanani untu pisaisaro mwaiso. Eo, ne iniara tina, Né Kotira aatu aatu sinta mwariate tuko, tiro. Sisasiva mwi kuara turama. ");
INSERT INTO omw_v_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","...Sisasiva esaa vainti nraase qora timwa nyiro tiro, Né surauri mwariate. Né vaaqara irainarave vaaqara monove mwarenta mwirara nroraqamase nau riaqi vivo. Né vaaqara irainara mwatate so mwaiqi vuaraarave tivo. Vaaqara irainaravano sia ini saisaqa siranta né suqemase mwaiqi vivarave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sisasiva mwitaa timwate mwiva mwo kuaqaa nuase timwa nyiro tiro, Vainti mwovano vaaqara irainara mwatova sarasaapa mwo utuse mwiraqaantai vaaqara sarasaapa mwase ");
INSERT INTO omw_v_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","nrai timwase rie tiro, Ne ntaa nraavuraqive mwaa sarasaapara mwataasarave? Esaa ni nraavuqi sarasaapavano suaiqa siso, tiro tuvo. ");
INSERT INTO omw_v_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mwitaa timwate mwiva qava tiro, Saqe ne esaa nraavu nuquraasena qava nrora nraavu vaaqara nraavu soqasena mwiraqi sarasaapavaqa mwitaa si irainararavaqa mwataase. ");
INSERT INTO omw_v_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ne mwi airara taiqa sena mwitaa tiase, Ne suqema mwauko. Vaaqara sarasaapavaqa vaaqara irainaravaqa vaisana ne vaaqara isi qaqi mwaiqi vina mwaa sarasaaparavaqa nramaivaqa nramwaqi vina suqemase mwariasarave tiase, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mwi vaintiva mwitaa tuvaro Kotiva mwira timwa mwiro tiro, Sia ri vu aato vaisarave. Mate enaqi re qutu vinarave. Re qutu viraro rena tutaase tiana irainarara mwovano mwi irainarara mwaraanarove turave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sisasiva nraase qora mwitaa timwa nyiro mwi kuara taiqase mwiva mwisuara tiro, Vaintivano soqaara aasu nau riaqi viro esaa soqaa vaaqara mwatataiva mwairaro Kotiva mwi vaintirara tiro, Ri soqaa qumina irainarave. Ne takuaukara re mwaaqu vainti mwariaro. Re qaqi qutu vinarave tianarove, tiro. Sisasiva mwi kuara mwitaa turama. ");
INSERT INTO omw_v_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nraaru vainti mwovano qora nraaqiara taarama mwatatova mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","naantiaraava mwaitaro nrai qorara tiro, Naantiara re ni miase tina irainarara mate vaa miane, tiro. Mwitaa tuvaro mwira qova nrai mwato irainarara nuqaaqamase nrai nraaqiaratana mwora mwiro mwora mwiro suvaro ");
INSERT INTO omw_v_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","mwira mwaaqu naantiaraava pataqaa mwaitaro mwira qova nrai mwu irainarara mwosua nyiro ori mwarero untu niarani mwo mwatani mwariase tiro vura. Mwiva niarani mwo mwatani viro mwini mwaitaro mwiva sia suqe vaintinravuvaqa mwariqiro viro ");
INSERT INTO omw_v_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","nrai ori uro taiqa sero. Mwira orivano taiqa vuvaro mwauvaro mwi mwatarani sia saravaqa vaunani nrora qaaranovaro ");
INSERT INTO omw_v_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","mwiva mwaaqu vainti mwaitaro mwi mwatanaasua mwo vaintiqaa aira mwarorama. Mwiva mwo vaintiqaa aira mware mwauvaro mwirara uro quara sara nyiane tuvaro ");
INSERT INTO omw_v_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","mwiva quara sara nyiro tiro, Mpo, nevaqa quara sara viti nyura nraataarave tuvaro mwira sara mwiari vaintiva sia mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","nraataa suvaro mwi vaintiva mwariro aato tusero nau riase tiro, Ni nkora saiqa vaintivaravano vaaqara sarasaapa nre mwariavana ne mwaanto mwaitana sara nraataa sisana mwauko. ");
INSERT INTO omw_v_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Saqe ne nena nkova sinani nanena vuase. Ne uro nanena mwirara mwitaa tiase. Ni nko, ne Kotira vuqaavaqa ri vuqaavaqa qaqiraqa si airara mwarauko. ");
INSERT INTO omw_v_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ne mwitaa sinarara tina, ne sia so ri nraaqiara suqeva mwariasarave, Ne ri saiqa vainti aasu mwariasarave. Ne uro nanena ni nkora mwitaa tia mwiase, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mwi vaintiva mwitaa tiasero mwiva ntiviro nrai qova sunani nrurama. Mwiva mwini aarani viro mwira qora nraavu mwataqa nruvaro mwira qova mwira mwutu takue mwiva mwirara riariamase sanero uro mwira mwaaqu navaatavuse mwira suvuqamase mwauvaro mwira mwaaquvano tiro, ");
INSERT INTO omw_v_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ni nko, ne Kotira vuqaavaqa ri vuqaavaqa qaqiraqa si airara mwarauko. Ne mwitaa sukavara tina, ne sia so ri nraaqiara suqeva mwariasarave, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mwitaa tuvaro mwira qova nrai aira mwaro vaitirara timwa nyiro tiro, Né uro tuavaaqa suqera aasu mwaqinta mwiri mwira mwiate. Saantavavaqa iraravaqa mwasenta sumwataate. ");
INSERT INTO omw_v_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Purumakau nraativaqa rusenta suntaate. Mate mwaasua mwirara riariama saare. ");
INSERT INTO omw_v_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ni maaquvano qutu viso tukaro qaqi nrinaiso. Ni nraaqiaravano raumpirima viso tukaro qaqi qovarama viso, tuvo. Mwira qova mwitaama timwase riariamase sarasaapa mwase mwisua mwira vaasua utunurama. ");
INSERT INTO omw_v_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mwisua mwira vaasua uti mwauvaro mwira vasaava saiqaqintai nrinero riovanta ");
INSERT INTO omw_v_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","isi ti mwauvaro riero mwiva nrai qora aira vainti mwo mwira riovaro mwiva mwitaa tiro, ");
INSERT INTO omw_v_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ri qatavano mwevantai nrinaisaro ri qova mwirara riariamase purumakau nraati rusero sunta mwataiso. Mwiva ri qata suqemase vitase mwitaa riariamase mwaiso, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mwitaa tuvaro mwira vasaava mwauvaro rara itovaro iqiru tusero sia nraavuqi virero mwaatani mwauvaro mwira qova mweva nero mwira sapara suvaro mwira mwaaquvano mwitaa tiro, ");
INSERT INTO omw_v_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ne vaaqara isi ri aira mwarenta mwaitana sia ne mwo enavaqa ri kua anuauko. Ne nena tontivaravaqa riariama saare tukara re sia memeraa nraati mwonku nuqutu sera ni miaro. ");
INSERT INTO omw_v_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mwaava ri mwaaquvano nraaserara nuaararo mwaitaro mwiva re mwiana irainarara mwarero untu taiqase untu nane nrisarama re mwirara purumakau nraati suqera qumina mwirara nuqutu sera mwiaro, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mwitaa tuvaro mwira qova qao tiro, Ni maaquo, re nivaqa mwariaravave. Ne mwu irainarara tentatana mwataunarave. ");
INSERT INTO omw_v_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ri qatavano qutu viso tukaroma qaqi nrinaiso. Mwiva raumpirima viso tukaroma qaqi qovarama viso. Mate te mwirara riariamase mwariare, turama. Sisasiva mwi kuara turama. ");
INSERT INTO omw_v_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sisasiva mwitaa timwa sero mwiva mwo kua nraase qora ntu nusua timwa nyiro tiro, Vainti mwovano vaaqara irainara mwatatova suqe tuavaaqa nukutova mwo nrau mwo nrau suqe su sarara aasu nretaro mwauvo. ");
INSERT INTO omw_v_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mwi vaintiva mwi sarara aasu nretaro mwauvaro vainti mwovano mwira utu Rasarusiva mwauvanta mwosua mwi vaintira vitenta uro vaaqara irainara mwato vaintira qentaqaa i sovaro mwiva mwinto mwauvo. Mwi vaintiva sia irainaravaqa mwato vaintiva mwaaqu vaintivano mwauvaro nrumwaaravano esaa mwira mwavanamaata vauvaro ");
INSERT INTO omw_v_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","mwi vaintiva mwaitaro vaaqara irainara mwato vaintiva sara nretaro viti piso sarara mwi sarara aasu nrarero mwauvo. Sia irainara mwato vaintiva mwinto mwitaa mwauvanta vairi mwonravuvano vitare nritare sitanta mwira nrumwaara mposu nrorama. ");
INSERT INTO omw_v_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sia vaaqara irainara mwato vaintiva qutu vuvanta naavunyaasua mwira vita mwarenta uro Avarahaamuva nrai saivaqava mwaunani i senta. Mwira uro i sovaro mwinto mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","vaaqara irainara mwato vaintiva mwivavaqa qutu vuvanta mwira mwataqi qunama tovaro mwiva qutu vusua mwaaqani mwaitaro qara nuase mwauvo. Mwitaa mwaitaro mwutuni takuovaro Rasarusiva mwinto Avarahaamuravaqa mwaitaro suqema mwauvo. ");
INSERT INTO omw_v_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mwinto mwitaa mwauvaro mwiva Avarahaamurara saparamase tiro, Avarahaamuo, tiri qo, niara mpo timwa mataane. Re Rasarusira vusi tiraro mwiva uro nrai saqu nramaiqi naasero untu ni maaqiriqaa mwatairaro ni maaqirivano sumpama vuarive. Ne nrora tia itairaqi mwarinama qara nina mwauko, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mwitaa tuvaro Avarahaamuva qao tiro, Ni mpaio, re riaane. Re nraaru qaqi mwau enara suqe irainara mwate mwauraro Rasarusiva sia suqe irainara aasu mwatovave. Mate mwiva mwaanto mwaitaro suqema mwaisara re mwinto mwaitara qara nira mwariaro. ");
INSERT INTO omw_v_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Re qava rie mwaiqe mwo kua ri timwa mwiase. Re mwariaranta te mwauraro qina nroravano vutana vaiso. Mwaintai vuaso mwintai nriaso tiro Kotiva qina nrora mwataiso, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Avarahaamuva mwitaa tuvaro mwi vaintiva tiro, Mpo tiri qo, re Rasarusira vusi tiraro mwiva ni nkora nraavuqi uro mwaitaro ");
INSERT INTO omw_v_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ni nkata mpasaa nkuaanania saquru timwa nyiarive. Mwisuavaqa mwaini ita virani nrivo, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mwitaa tuvaro Avarahaamuva qao tiro, Mosesivavaqa paropeti vaintivaravaqa qumwaarara to kuava vaiso. Mwisua mwi kuara so rievarave siavo, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mwitaa tuvaro qaqi mwau enara vaaqara irainara mwato vaintiva tiro, Siave, tiri qo, Avarahaamuo, qutu vuari vaintiva uro nane timwa nyisanta mwisua mwira kua rietanta qaqiraqa si airara pisevarave siavo, tuvo. ");
INSERT INTO omw_v_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mwitaa tuvaro Avarahaamuva qao tiro, Mwisua Mosesira kuavaqa paropeti vaintivara kuavaqa sia rientente, qutu vuari vaintiva uro nane tiari kuaravaqa mwisua sia so rievarave siavo turave turama. Sisasiva mwi kuara turama. ");
INSERT INTO omw_v_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sisasiva mwini mwaitaro kua qaqi ti mwauvanta vaaqara vaintivano nrinora. Sisasira nraaqiara 12 nravuqintai Sutaasiva vaaqara vainti ntita mware mwiva naane mwisua ntuni nriro Sisasiva mwaunani nrinero uro Sisasira mota nare uti mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sisasiva tiro, Sutaasio, re ni mota sera ni mwataqi mwatatai nraaqiarara nramwutaa ntuqaave ni qovarama senarave? tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sisasiva mwitaa tuvanta mwira nraaqiaravara mwira vaqamase mwausua takuovanta mwisua Sisasira navaatavu sarenta uti mwauvanta mwinravusua Sisasirara tinta, Nrora vaintio, tenravu paipaqontai mwisua tuqu saanarave? tinta. ");
INSERT INTO omw_v_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sisasira nraaqiaravaravano mwitaa tuvaro mwinravusuaqintai mwovano Kotira aira mwara mwate mwau vaintisua mwisua vunyaa vainti aira vainti mwo tuquse mwira aato tuqu sovaro untu nuvaro Sisasiva sove tiro ");
INSERT INTO omw_v_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","timwase mwi vaintira aatoqaa nrai saqu mwatatovaro mwira aatovano tavana vura. ");
INSERT INTO omw_v_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kotira aira mwara mwate mwau vaintisua mwisua nroranravuvanovaqa, Kotira nraavuqaa naqisi mwau kiripuvanovaqa, nrora vainti mwonravuvanovaqa, mwisua Sisasira navaatavu sare nrusuara Sisasiva tiro, Né kamaanira vaqamase naquari vaintira votaamase navaatavu sarentave né paipavaqa saavuvaqa mware nriavo? ");
INSERT INTO omw_v_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ne ini vaqamasena mwo nrau mwo nrau Kotira nraavuqi mwaiqina vi mwaukanta né sia ni navaatavu saarave. So mate mwaa enava ini enama vaiso. Mate rupisiqi mwariari irainava kempusaqama sianarove, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kamaanira kua anuo vaintiva mwovano sini tosani rutova mwivavaqa Sisasira sia suqe kua timwa mwi tiro, Qutaave re Mesaia vaintivano mwariaro? Re renavaqa tiritanavaqa saisaqa siane, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mwitaa tuvaro kamaanira kua anuo vaintiva mwovano qao tiro, Re siave Kotira aatu siaro? Mwisua tiritana votaamase mwiravaqa rutaavo. ");
INSERT INTO omw_v_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mwisua tiritana so rutaavo. Mwisua tiritana sia suqe aira saara tiritana rutaavo. Mwi vaintiva sia qaqiraqa si airara mwaraivave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mwitaa tiase mwiva Sisasirara tiro, Sisasio, ri nroraqama saari enaraqaa re niaravaqa riaane, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mwitaa tuvaro Sisasiva tiro, Ne ri timwa mwiarira riaane. Mate re nivaqamase suqe mwatusani mwarinarave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mwitaa tuvaro suarivano mamatama nruvaro mwiraqaantai rupisima vuvaro sia suarivano itovaro rupisi aasu rutovaro suari tukiviro 3 kirokuqaa suvaro qava ataama vura. ");
INSERT INTO omw_v_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ierusaremi mwatusani Kotira nraavuqi tausa votaama vauraqi nrora vaaqa siritova vutaqaa nrai nuqe vuvaro ");
INSERT INTO omw_v_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sisasiva satariqaa mwaitaro nroraqamase oi aai tiase, tiro, Ni nko, ni mwarana mwaraane, tiro. Mwitaa tiase Sisasiva qutu viro. ");
INSERT INTO omw_v_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sisasiva qutu vuvaro naqu vaintisua qiata vaintivano Sisasiva mwitaa sura takuero Kotira utu tuaarere tiro, Qutaama mwaa vaintiva suqema nrue mwai vaintivave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mwitaa tuvanta mwo susua mwi irainarava qovara sura takuarenta suntu nukaama vusua mwisua mwaitanta takuama senta mwiraqaantai mwisua nyari mwaaqani nyari mwaaqani nanenta vitanta mwuntusa sia suqe suvanta nyari mwuntusa nuqutuse vura. ");
INSERT INTO omw_v_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mwisua vuvanta Sisasira vataqi nrue mwau nraase qorasuavaqa, nraase mwonravu Kariri mwatantai Sisasira vataqi nrue mwausuavaqa, mwisua niarani mwaitanta mwi irainarava qovara sura takuora. ");
INSERT INTO omw_v_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mwi enaraqaa Sisasira nraaqiara taaratanavano mwo mwatusa Emeasi mwatusani virenta vura. (Taputantai voqaama Veqaurani voqaama mwira votaama Ierusaremi vauvaro Emeasi mwatusa vaura.) ");
INSERT INTO omw_v_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mwitana aarani vitanta Sisasira ruso kuara timwaqi vinta. ");
INSERT INTO omw_v_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mwitana timwaqi vuvaro Sisasiva nrai nrinero mwitana vaqamase uro vuvanta ");
INSERT INTO omw_v_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","mwitana Sisasira takuenta sia mwira qintutama takuaraitinta, mwo vaintivanove tuvaro ");
INSERT INTO omw_v_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sisasiva mwitanara tiro, Netana aarani nritantama nara kuave nrai timwa mwi nrai timwa mwi vi mwariavo? tiro. Mwitaa tuvanta mwitana uro mwiraqaa ntivinta mwitana mwuntusavano sia suqe suvanta mwaura. ");
INSERT INTO omw_v_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mwovano Kiropaasiva Sisasira mwata rie tiro, Mwaa enara vaaqara vaintinravuvano mwiri Ierusaremini mwariavara re nkuainkuvanove nanau qovarama vi kuara siave riaaro? tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mwitaa tuvaro Sisasiva, Nara kuave? tuvanta mwitana tinta, Sisasira Nasaretinyaara kuave. Mwi vaintiva paropeti vaintivano mwaitaro Kotira vuqaavaqa nraase qora ntuqaavaqa nrora aira mwaretanta suqe kua aasu tirave. ");
INSERT INTO omw_v_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mwiva mwitaa si mwarisanta Kotira aira mwara mwate mwaria vaintisua mwisua nrora vaintivaravanovaqa, tiriqaa naqisi mwariasuavaqa, mwisua kamaanira mwira mwiavaro mwiva mwira rusaate tisanta mwira niriqontai satariqaa rutaarave. ");
INSERT INTO omw_v_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Te ntaaru mwi vaintirara Kotira mwira titaisaro mwiva mwo mwatanaasua aatarase tiri Isaraari mwatanaasuaqaa naqisiarivave tunarave. Kua mwovaqama vaiso. Mwira rusaavaro mate taaramo ena nritaraiso. ");
INSERT INTO omw_v_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mate tetana nraasenravuvano tia kuara rienta isarama vuro. Mwinravusua ota toqaqi mwira qunama taaraqi uro nenta sia mwira mwavana takuaavo. ");
INSERT INTO omw_v_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mwi nravusua uro nanenta mwiri tiri timwa timwi mwitaa tinta, Naavunyaasua tirinravuara mwiva qaqima mwaiso, tiavo, tiarave. ");
INSERT INTO omw_v_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nraasenravuvano mwitaa tiavanta tirinravuqintai mwo vaintinravuvano mwira qunama taaraqi uro vi uro takuaavaro nraasenravuvano tia kuava mwivauma vaisanta mwinravusuavaqa mwira mwavana sia takuaarave, tinta. ");
INSERT INTO omw_v_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mwitana mwitaa tuvaro Sisasiva mwitana timwa nyi tiro, Siave initana vu aato vaiso? Ntaaru paropeti vaintivaravano timwato kuara nétana mwi kuara qutaave tiataara vaisanta nétana qasomase mwi kuara rie mwariavo. ");
INSERT INTO omw_v_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nétana siave riaavaro Kotiva titaari vaintiva mesaia vaintivano itavi irainarara mwaraqi viro mwiraqaantai nroraqamavi kempusa vaintivano mwarianarove, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mwitaa timwase Sisasiva Mesaia vaintiara Kotira vukuqi qara qumwaara rato kuara mwitana timwa nyirero tosarero Mosesira vukuqintai timwa nyiqiro viro paropetivara vukuqintai timwa nyiqiro vura. ");
INSERT INTO omw_v_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mwitaa ti mwauvaro mwitana virenta su mwatusava mwataqaa vauvaro Sisasiva aarana qaqi virero votaama uti mwauvanta mwitana qao tinta, ");
INSERT INTO omw_v_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mate ena sianarove. Pisera tiritanavaqa vaitaane, tuvaro Sisasiva mwitanavaqa mwairero nraavuqi vura. ");
INSERT INTO omw_v_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sisasiva nraavu mwiraqi mwaitaro sara taintaqaa mwitana vaqamase mwataqaa mwai Kotirara suqeve timwase mpereti sara uveqase ntusamase nyuvanta mwitana vu aato qintutama vuvanta qintutama rienta ");
INSERT INTO omw_v_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","mwitana mwira qintutamase takuovaro Sisasiva mwitana ntuqaantai qumpau vura. ");
INSERT INTO omw_v_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sisasiva qumpau vuvanta mwitana nrai timwa mwi nrai timwa mwi tinta, Mpo, mwiva aarana nritaro Kotira vukuqintai kua tiritana timwa timwi mwaisaro qutaama tiritana mwuntusaqintai suqe siso, tinta. ");
INSERT INTO omw_v_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mwitaa timwase mwitana vaavaama ntivinta mwiri nane Ierusaremi uro Sisasira nraaqiara 11 nravu mpuaamase takuovanta mwinravusua mwo vaintinravuvaqa suntu nukaama mwainta tinta, ");
INSERT INTO omw_v_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nroravano qutaama qava qaqi ntiviso. Saimoniva mwivama mwira takuaivo tuvanta ");
INSERT INTO omw_v_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","mwitanavaqa aarani nruenta takuorara mwisua timwa nyi tinta, Mwiva mpereti sara uveqa saisanta mwiraqaantai tetana nrora vainti qintutama takuaunarave, tinta. ");
INSERT INTO omw_v_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mwitana kua mwisua timwa nyi mwauvaro vaavaama nroravano mwivama qovarama viro mwisua aaqani ntivi tiro, Ini mwuntusavano qisaaqama vasiarive, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mwitaa tuvanta mwisua nroraqamase aatu si tinta, Vaanavano qovarama viso, tuvaro Sisasiva mwisuara tiro, ");
INSERT INTO omw_v_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Né narare aatu si mwariavo? Né nararave niara taara aato nauri rie mwariavo? ");
INSERT INTO omw_v_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Né ni iqu saqu takuaate. Ne mwivama suko. Sia vaanavano ni votaamase mwativaqa mwusaarivaqa vaiso, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mwitaa timwase mwiva nrai iquvaqa saquvaqa tia nyuvanta ");
INSERT INTO omw_v_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","mwisua mwoqamase riaria sinta saqu nunkinkiraarate tinta, Sia mwirara qutaave tiare, tuvaro Sisasiva mwisua mwata rie tiro, Sara nraariva vairove? tuvanta ");
INSERT INTO omw_v_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","tavusa suntatora pataqa mwira mwuvaro ");
INSERT INTO omw_v_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Sisasiva mwisua ntuqaa mwaitaro mwarase nrora. ");
INSERT INTO omw_v_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sisasiva tavusa nramwase mwisua timwa nyi tiro, Ntaaru ne inivaqa mwaitana ne mwaa kuara ini timwa nyurave. Niara ntaaru Mosesiva vukuqi qumwaara rato kuarave, paropeti vaintivaravano qumwaara rato kuarave, Saami vukuqi qumwaara rato kuarave, ne ini timwa nyitana mwi kuava mwivauma vasianarove, turave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mwitaa timwase mwisua Kotira vukuqi qumwaara rato kuara qintutamase riaate tiro Sisasiva mwi kuara mwi kuara mwisua timwa nyi tiro, ");
INSERT INTO omw_v_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mwaa kuara qumwaara ratorave, Mesaia vaintiara mwiva ita vuari irainara mwaqi uro qutu viro taaramo ena mwari qava qaqi ntivuanarove. ");
INSERT INTO omw_v_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mwiraqaantai né ni airara ni utuara rietantama nraase qora timwa nyiqi vitanta sia suqe si aarara pisaivaro Kotiva né sia suqe airara mware kuara nrunka nyataanarove, tiate. Mwi kuara timwa nyiqi vitanta Ierusaremini naane mwi kuara timwa nyiqi vinta mwiraqaantai mwo mwatanaasua mwo mwatanaasua timwa nyiqi vuate. ");
INSERT INTO omw_v_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nénravu nénta ntuqaantai mwi airara mwi irainarara takuaarave. ");
INSERT INTO omw_v_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ni nkova nrai saqu iqiqaa mwatero nena ini nyirerave tiarinara nevano mwira titaariro tukuarive, Né mwaa mwatusaraqi mwaiqi vivaro naavuntai mwiva tukiro iniqaa mwaitaroma ini kempusa nyianarove, tiro. ");
INSERT INTO omw_v_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sisasiva mwitaa timwase mwiva mwisua ntita mware Ierusaremi mwatusa mwini se Vetaani mwatusani uro ne nrai saqutana tuaarerase mwisua suqema nyate. ");
INSERT INTO omw_v_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sisasiva mwisua suqema nyate mwaitaro mwiva mwisua mwini sovaro mwira naavuni vita mwarora. ");
INSERT INTO omw_v_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sisasiva naavuni vuvanta mwira nraaqiaravara mwini so vaintivarasua suqe suvanta mwiri nane Ierusaremini vinta uro mwini mwaitanta Kotira nraavuqi uro Kotira utu tuaareraqinta vi mwaura. ");
INSERT INTO omw_v_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parasi vainti mwovano mwauvaro mwira utu Nikotimasira. Nikotimasiva Iutaa mwatanaasua ntarunyaa vainti mwaura. ");
INSERT INTO omw_v_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mwiva mwariro enaqi uro Sisasira takuero tiro, Mwaara ti mwariara vaintio, te takuauraro Kotiva ri titaisarara tira, re mwaara kua ti mwariarava nrira siaro. Sia Kotiva ri saisaqa sitirina, re siama nrora aira mwaraaratirinao, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mwiva mwitaa tuvaro Sisasiva mwira timwa mwiro tiro, Ne qutaa kua tiarira riaane. Vainti nrora tuaiva mwairaro mwira sia qavavaqa mwatatairere, mwi vaintiva siama Kotiva naqisiari mwatusara so takuaanarove, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tuvaro Nikotimasiva qao tiro, Ntataa sirarove nrora tuai vaintira qava mwatataanarove? Mwiva qava nrai nrora visosaqi viqetairarove mwira nrova mwira qava mwatataanarove? tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tuvaro Sisasiva tiro, Ne qutaa tuko. Nramaiqi mwatataariva mwairaro sia Kotira Mwaranavano mwira qava mwatatairaro mwiva sia Kotiva naqisi mwatusarani vuanarove. ");
INSERT INTO omw_v_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mwavana mwataava nrai mwavana mwataara aasu mwatatairave. Mwaranavano mwarana aasu mwatatairave, tiro. Ini qava mwatataari kuarara ne ri timwa mwukara re mwi kuarara isaramave vuaro? Sia mwitaa siane. Ne mwo kuaqaa nuase ri timwa mwirenave. Saaravano titaro mwini mwini vuataa sisaro viso. ");
INSERT INTO omw_v_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Saaravano tuqi visara re sia mwira takuaraitira, re mwira quka aasu rianarave. Re saaravano nriari osararave mwiva vuari osararave sia qintutama riaaro. So Kotira Mwaranavano mwatatai osarava mwira votaama vaiso, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Sisasiva mwitaa tuvaro Nikotimasiva tiro, Ntataama serove mwitaa sianarove? tuvaro ");
INSERT INTO omw_v_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sisasiva tiro, Re Isaraari mwatanaasua mwaara kua timwa nyi mwariarave mwaitarove mwi kuara sia qintutama riaaro? ");
INSERT INTO omw_v_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ne qutaa tuko. Te qintutama riauna kuara ini timwa nyi mwauko. Mwitaa suravanta né sia tiri kua qintutama riaavo. ");
INSERT INTO omw_v_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ne mwatanyaa irainara ini timwa nyukanta né mwirara sia qutaa kuave tiavo. Né mwitaa tiavana ne naavunyaa irainara ini timwa nyiarinta, né ntataamase mwi kuara so qintutama rievarave? ");
INSERT INTO omw_v_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Sia vainti mwovano naavuni Kotiva mwainani virave. Ne aasuma mwintai tukuko. Ni mwataqaa mwatataiva ne nraaru naavuni mwarivarave. ");
INSERT INTO omw_v_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nraaru ini saivaqava Mosesiva qumina mwatani mwaitaro kuanira mwarana oriqaantai utuse mwira satari ratoraqaa tuaare rasorave. (Nraase qoravano mwira takue sia qutu vuate tiro, Mosesiva mwitaa surave.) So ne mwataqaa mwatatai nraaqiarava ne mwariarinta nraaru Mosesiva kuanira mwarana utuse mwatonemase nivaqa satariqaa tuaare rasaivanta ");
INSERT INTO omw_v_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nraase qoravano niara qutaa mwivave tisua sia qutu vinta taiqa viraitinta, mwisua esaa ena esaa ena qaqi mwariqi vivarave, tiro. Sisasiva mwitaa turama. ");
INSERT INTO omw_v_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kotiva mwataqi mwariasuara mwoqamase mwuntusa nisarora tiro, mwiva nrai mwaaqu nkuaiqa mwatataira tiri tivira. Mwitaa sirara tinta, nraase qoravano mwira mwaaquara qutaave tisua sia qutu vinta taiqa viraitinta, mwisua esaa ena esaa ena qaqi mwariqi vivara. ");
INSERT INTO omw_v_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kotiva nrai mwaaqu titovaro mwiva sia nraase qoraqaa kua mwatarero tukiso. Nraase qoravano suqema mwariate tiro, mwiva tukura. ");
INSERT INTO omw_v_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mwovano mwira mwaaquara qutaa mwivave ti mwarirava mwivama sia kua mwaraanaro. Mwovano mwirara sia mwivave ti mwarirava mwivama nrora kua mwaraanaro. Mate mwaa enara Kotiva ko timwase mwi vaintira qoririma saira. Mwi vaintiva Kotira mwaaqu nkuaiqa mwatatairara sia qutaa mwivave tira saara Kotiva mwira qoririma saira. ");
INSERT INTO omw_v_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mwaa irainarara saara kua vasianaro. Tomwavano mwataqi tukuvanta nraase qoravano sia mwira riaria siraitinta, mwisua rupisi sirara riaria sinta mwariara. ");
INSERT INTO omw_v_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sia suqe sia vaintisua mwovano mwovano nramwutaaqa sitanta sia mwi tomwara riaria siraitinta, mwisua sia tomwavano mwainani vuara. Tomwavano tiri sia suqe aira ataa timwataaso tinta sia tomwavano mwainani vuara. ");
INSERT INTO omw_v_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mwisua mwitaa siavaro qutaa aira mware vari vaintiva sia aatu siraitiro, tomwavano mwainani vira. Mwiva visaro tomwavano mwira aira ataama mwataisanta nraase qoravano takuaavaro mwi vaintiva Kotira kua rietaro Kotira aira mware mwaira. ");
INSERT INTO omw_v_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sisasiva vitaro takuovaro vainti mwovano nrai nrora visosaqintai vu qimpa vuva mwauvanta ");
INSERT INTO omw_v_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Sisasira vaintivaravano Sisasira mwata rienta tinta, Mwaara kua tiara vaintio, ntavave qaqiraqa si irainarara mwasaisarove mwaa vaintira vu nrai nrora visosaqintai vu qimpa viva mwaiso? Nraive siso mwira nrosua qosuave qaqiraqa si irainarara utu saavarove mwira vuvano qimpa viso, tinta tuvo. ");
INSERT INTO omw_v_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Sisasira vaintivaravano mwitaa tuvaro Sisasiva qao tiro, Sia nrai qaqiraqa si irainarara mwaraira saara mwira vu qimpa viso. Siama mwira nrosua qosua qaqiraqa si irainarara utu saavaro mwira vu qimpa viso. Né mwi vaintiraqi Kotira kempusaqama aira takuaate tiro, mwira vuvano qimpa viso. Kotiva ni nti mataisana ne tukukavave. ");
INSERT INTO omw_v_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Te Kotira aira ataa siarinto mwaraare. Ena siraro sia mwo vaintivano aira so mwaraanarove. ");
INSERT INTO omw_v_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ne mwataqe mwaitana tomwavano itainema sena ne itamaqina vuariro mwataqi mwaisua so takuevarave, tiro tuvo. ");
INSERT INTO omw_v_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sisasiva mwitaa timwa sero mwataqaa taara visise taaraqontai soraqamase mwiti vainti vuqaa naatauruse mwirara tiro, ");
INSERT INTO omw_v_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Re Siromi nramaiqi untu rena vuri siqama saane, tiro. Sisasiva mwitaa tuvaro mwi vaintiva Sisasiva tunema untu nrai vuri siqama sovaro mwira vuvano mpaira vuvaro mwi vaintiva mwintai untu nane so takuamaqi nrurama. ");
INSERT INTO omw_v_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mwiva so takuamaqi nri mwauvanta mwira nraavu mwataqa mwausua takuovaro aara tosani mwaitaro pata irainara nivaqa miate ti mwau vaintiva qaqi nruvanta mwisua mwira takuenta tinta, Nta vaintivave nriso? Aara tosani mwaitaro pata irainara nivaqa miate ti mwau vaintivave nriso? tinta. ");
INSERT INTO omw_v_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mwisua mwitaa tuvanta mwonravuvano tinta, So mwi vaintiva mwivave, tuvanta mwonravuvano qao tinta, Mwovanove. Mwira vuri votaa siva nriso, tuvaro mwi vaintiva nrine tiro, Ne mwaa mwivama suko, tiro tuvo. ");
INSERT INTO omw_v_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mwi vaintiva mwitaa tuvanta mwisua mwira mwata rienta tinta, Ntataama saisarove ri vuvano mpaira viso? tinta. ");
INSERT INTO omw_v_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mwisua mwitaa tuvaro mwiva timwa nyiro tiro, Vainti mwovano mwira mwutu Sisasiva mwiva taara visise soraqamase ni mpuqaa naatauruse niara tiro, Siromi nramaiqi untu rena vuri siqama saane, tisana ne untu siqama saukaro ni mpuvano mpaira visana ne so takuamaqina nruko, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mwiva mwitaa tuvanta mwisua mwira qava rienta tinta, Mwi vaintiva ntaini visare nriaro? tinta. Mwisua mwitaa tuvaro mwiva tiro, Nrai ntainive vivaaso? Ne siavaqa takuauko, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mwiva mwitaa tuvanta mwisua nraaru vu qimpo vaintira vita mwarenta uro Parasi vaintivaravano mwaunani vurama. ");
INSERT INTO omw_v_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sisasiva mwaara kua tu enaraqaa soraqamase mwi vaintira vu mpaira sorama. ");
INSERT INTO omw_v_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mwisua Parasi vaintivaravano sunani vitaqi uro sovanta Parasi vaintivaravano mwi vaintira mwata rienta tinta, Ntataama saisarove ri vuvano mpaira viso? tuvaro mwi vaintiva tiro, Mwiva soraqamase ni mpuqaa naatauru mataisana ne untu nena mpuri siqama saukaro ni mpuvano mpaira visana ne so takuauko, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mwiva mwitaa tuvanta Parasi vainti mwonravuvano tinta, Mwi airara mwaraiva mwaara enaqaa mwitaa siso. Mwiva mwaara enaqaa sia mwitaa siataara vasisaro mwiva kua qaanuase mwitaa siso. Mwitaa sisorara tiro, mwi vaintiva sia Kotiva sinani tukivave, tinta. Tuvanta Parasi vainti mwonravuvano qao tinta, Ntataama serove qaqira vaintivano mwi airara nrora mwarai airara so mwaraanarove siso? tinta. Mwitaa timwa senta mwonravuvano mwo kua tuvanta mwonravuvano mwo kua tinta. ");
INSERT INTO omw_v_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Parasi vaintivaravano qava mwira mwata rienta tinta, Mwiva ni mpu mpaira sairave tianarave. Mwi vaintirara re nara kuave tiaro? Mwiva ntataama mwai vaintivave ri vu mpaira saiso? Re tiri timwa tivivaqe riaare, tuvaroma vainti mwiva tiro, Mwiva paropeti vaintivano mwaiso. Kotiva mwira saisaqa sisaro mwiva aira mware mwaiso, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mwitaa tuvanta Iutaa vaintivaravano sia mwira kuara qutaa kuave tiarera mwi vaintirara tinta, Re muna titara ni mpu mpaira viso tiaro. Nraaru sia ri vuvano mpaira vurave, tinta. Mwitaa timwa senta mwisua mwira nrosua qosua sapara suvanta ");
INSERT INTO omw_v_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","mwitanavano nruvanta mwisua mwitana mwata rienta tinta, Mwaa vaintiva initana nyaaquve siso? Qutaave mwira nrora visosaqintai vu qimporave? Ntataama saisarove mwira vuvano mpaira visarove takuaiso? tinta. ");
INSERT INTO omw_v_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mwisua mwitaa tuvanta mwira nrosua qosua tinta, Mwaa vaintiva tiritana mwaaquve. Mwira vuvano nraaru visosaqintai qimporave. ");
INSERT INTO omw_v_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nrai ntataa sisarove mwira vuvano mpaira viso? Nrai ntavave mwira vu mpaira saiso? Mwiva nrora tuaivave. Né nénta mwira mwata riaate. Mwiva so ini timwa nyianarove, tinta. ");
INSERT INTO omw_v_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mwira nrosua qosua Iutaa vainti nrora vaintivara aatu sitanta mwitaa turama. Nraaru Iutaa vaintivaravano mwitaa kua mwatate tinta, Vainti mwovano Sisasirara mwiva Mesaia vaintivano tiri saisaqama sirero tukivave tiaso. Mwovano mwitaa tirarore, te mwira irora sinta mwaara nravuqintai mwira raaqu saararo mwiva mweva ne esaara vuarive, turama. ");
INSERT INTO omw_v_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iutaa vainti nrora vaintivaravano mwitaa turara tinta, mwira nrosua qosua Iutaa vainti aatu sitanta tinta, Mwiva nrora tuaivave. Né nénta mwira mwata riaate, turama. ");
INSERT INTO omw_v_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mwitanavano mwitaa tuvanta mwisua qavavaqa nraaru vu qimpo vaintirara sapara sinta mwirara tinta, Re Kotira riaria siataarave. Sisasiva sia suqe vaintive, tinta. Mwisua mwitaa tuvaro mwi vaintiva tiro, ");
INSERT INTO omw_v_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sisasiva sia suqe vaintive siso suqe vaintive siso sia ne qintuta suko. Ni mpu qimpora mwiva mpaira sorara ne mwirara aasu qintuta suko, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mwiva mwitaa tuvanta mwisua mwira qava mwata rienta tinta, Mwiva ri narave utiso? Mwiva rinta ntataama setarove ri vu mpaira saiso? tuvaro vainti mwiva tiro, ");
INSERT INTO omw_v_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ne vaa mwirara ini timwa nyukanta né siave riaavo? Né ntataa si santave qava mwi kuara riarentave tiavo? Névaqa mwo? Névaqa mwira vaintivaravaqa mwariarentave qava mwi kuara ni mata riaavo? tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mwiva mwitaa tuvanta mwisua mwira nroraqamase irora sinta timwa mwinta tinta, Qao, revano mwira vaintivano mwaitara mwira kua riaaravave. Te tenta saivaqara Mosesira kua riaqi vuasuave. ");
INSERT INTO omw_v_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nraaru Kotiva Mosesira timwa to kuara te mwi kuara riaqi vuasuave. Te Sisasirara qumina vaintive turo. Te mwiva mwintai nri osarara sia qintuta suro, tinta. ");
INSERT INTO omw_v_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mwisua mwitaa tuvaro mwiva nrai saqu nunkinkiraara tero mpo se tiro, Ni mpu mpaira sai vaintiva mwiva mwintai nri osarara né siavaqa qintuta siavo? ");
INSERT INTO omw_v_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Te riauraro Kotiva qaqira vainti kua sia riaivave. Kotira kua riaasua Kotiva mwisua kua riaivave. Kotira utu tuaareraa vaintisua kua Kotiva riaivave. ");
INSERT INTO omw_v_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nraaru mwaa mwatara hoqarato enaraqaatairo sia vainti mwovano nrai nrora visosaqintai vu qipa vura mpaira sorave. ");
INSERT INTO omw_v_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sisasiva sia Kotiva sinani tukuase titirina, mwiva sia so ni mpu mpairaitirinao, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mwi vaintiva mwitaa tuvanta mwisua mwira irora sinta tinta, Ri nrova qaqiraqa si airara mware ri mwatataivave. Re mwo? Re tirivaqave i mwaara kua timwa tivinarave siaro? tinta. Mwitaa timwa senta mwisua vainti mwira raaqu senta mwaatani pisorama. ");
INSERT INTO omw_v_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mwisua mwira raaqu senta mwaatani pisovaro Sisasiva mwisua mwira raaqu senta pisorara riero mwi vaintirara mpuaama takuero mwirara tiro, Mwataqi mwatatai nraaqiarara re qutaa mwivave tinarave siaro? tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Sisasiva mwitaa tuvaro mwi vaintiva mwira mwata riero tiro, Nrora vaintio, mwiva ntavave? Re ni timwa miqena ne mwirara qutaa mwivave tiase, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mwitaa tuvaro Sisasiva mwira timwa mwiro tiro, Re takue mwariara vaintiva ne mwivama riara ti mwauko, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sisasiva mwitaa tuvaro mwiva tiro, Nrora vaintio, qutaa re mwivave, tiro. Mwitaa timwa sero mwiva Sisasira vuqaa tori naquntaase mwira riariamase mwinto mwauvaro ");
INSERT INTO omw_v_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sisasiva tiro, Ne nraase qora ntusama sirena mwataqi tukukavave. Vu qimpaisua takuaate tina, ne mwataqi tukukavave. Qaqi takuesua vu qimpa vuate tina, ne mwataqi tukukavave, tiro. ");
INSERT INTO omw_v_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Sisasiva mwitaa tuvanta Parasi vaintivaravano mwi kuara rienta Sisasira mwata rienta tinta, Tiri tivuve qimpa viso? tinta. ");
INSERT INTO omw_v_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Mwitaa tuvaro Sisasiva mwisua timwa nyiro tiro, Ini vu qimpa visantavauma kuavano sia iniqaa vasianarove. Né tinta, Te so takuauro, tiarara tiro, kuavano iniqaa vasianarove, tiro. Sisasiva mwitaa turama. ");
ALTER TABLE omw_v_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
