﻿USE sofia;
DROP TABLE IF EXISTS sofia.omw_a_vpl;
CREATE TABLE omw_a_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES omw_a_vpl WRITE;
INSERT INTO omw_a_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iesusiva Kotira mwaaquvano varura. Mwira qua suqe qua mwira osara vahireraro mwataamama vahiro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Haaru mwo enta Asaiaava Kotira qua qovarama sero qara ntuva tero tiqaro, Taqaane, ni qua nraase qora tiva niani vaitira ne titaariro mwiva i vuni viqaro i aara tequama mwataanarove. (Mal 3:1) ");
INSERT INTO omw_a_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mwi vaitiva qumina mwataqaa variqaro aasara ntero tiqaro, Nroravano vuani aarara tequama mwateta mwira aara avuqavuma mwataivaro mwiva mwi aararaqaama so vuarive tianarove, tura. (Ais 40:3) ");
INSERT INTO omw_a_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kotiva mwira saahaqa huvaro Asaiaava hoqare varu entara mwi quara qara ntuva tovaro airi ihi vi vuvaro mwo enta Ioniva qumina mwataqaa qovarama vura. Qumina mwataqaa qovarama viro Ioniva nraase qora nramari niqaro mwisa tiva niro tiqaro, Néta qora saiqa vare varira qaqira seta nramari varaivaro Kotiva né qora saiqa vare vari quara nruka nataarive, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ioniva mwitaa ti varuvata Iutiataitave, Ierusaremitaitave, esaa mwi mwatanaasa itai itai mwiva qua tunani vita uto variqata mwisa niari qora saiqa vare varura tiva qovarama sovaro Ioniva nramari mwisa nura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ionira tuavaaqa vahireraro mwo quara kameri saahi vara sero ututo tuavaaqava vahuvaro mwiva mwiraqai ututero reti tavaarana rupatero varura. Ioniva sia sara vara tu sero nraraitiro, mwiva kaikori nrero voravano kuruto nramarira nreqaro mwi sararaqai nre varura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ioniva nraase qora tiva niro tiqaro, Ni naatiara nriari vaitiva kepusavano ni naatara sero nrora vaitivanoma varianarove. Mwiva nrora vaitivano varisana ne qumina vaiti variqanara tina, sia né so kakataama vina nai suqu nraamwuma tai saantara avantu mwataanirave. ");
INSERT INTO omw_a_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne qaqi nramari ini ni varuqo. Mwiva Kotira mwaraqura ini nianarove, tiro. Ioniva mwitaa turama. ");
INSERT INTO omw_a_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mwi entara Iesusiva Nasareti mwatusa Kariritairo nri ntero Ioniva varunani utontero vuvaro Ioniva Sotaani nramariqi variqaro Iesusira nramari mwura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nramari mwira mwuvaro Iesusiva nramariqitairo qaqinani mwaari ntero taqovaro naavuvano qatua vuvaro mwiqitairo Kotira mwaraquravano kuri mwuku voti huva uto ntero Iesusiraqaa varura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Uto ntero Iesusiraqaa varuvaro quavano naavutairo mwitaama tiro: E ni maaquvano variararo ni mwutusavano iara mwoqavata vahiso. Ne iara qamwateqanama varuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Quavano naavutairo mwitaa tuvaro qamwanrama sero Kotira mwaraquravano Iesusira vita varero qumina mwataqaa sia vaitivata varu mwataraqaa uro sovaro varura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mwini uro sovaro Iesusiva 40 entara variqiro vuvaro Saataaniva Iesusirara qora saiqa varaarive tiro, mwira mwataara hiqaro taqovaro Iesusiva sia mwira qua riaraitiro, sia qora saiqa utura. Iesusiva mwitaamaqiro viqaro qaasau vahikurivano nrue varunani varuvata naavuniaa vaitinravu uto mwiraqaa suqema seta ntaqaihi varura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mwi entara mwo husa Ionira ntavaaqavu seta viteta karavuqi uro sovaro Iesusiva Karirini uro variqaro Kotira mwasaasa suqe mwasaasa nraase qora tiva niro tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mwi entava nri ntaiso. Kotiva iniqaa ntaqaihiari entava qaumaqa iso. Né qora saiqa uti varira qaqira seta ne suqe mwasaasa tiva nianira né mwi quarara quqaave tiva seta riemwaqi vuate, tura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesusiva mwitaa tiva sero vuva Kariri nruka tosa sataa viqaro taqovaro Saimoniva nai qata Enturusantiri variqaro vahe ne varura. Mwitanasa tavusa saiqa vare varutanasa vahe nte varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesusiva mwitanasara tiqaro, Nétana ni naatiara nriate. Nétana vahe ntava seqata tavusa varaantema seta ni naatiara nriqata nraase qora vitevarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Iesusiva mwitaa tuvata mwitanasa mate mwiqiara niari vahe mwini seta Iesusira vatavare vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mwitanasa mwira vatama seta vuvaro Iesusiva pataqa viqaro taqovata Sepetira mwaaqutana Semisivavata, mwira qata Ionivavata, votuqi variqata vahe ntuke hi vura haqire varura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mwitanasa vahe haqire varuvaro qamwanrama sero Iesusiva mwitanasa nraarovata mwitanasa rieta niari qora Sepetiravata, mwira saiqa varo vaitisavata, votuqi seta Iesusira vatama seta vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mwitanasa Iesusira vatama seta vuvaro Iesusiva vuva Kapeniaani uro variqaro mwaara tu entaraqaa mwaara nraavuqi vera ntero variqaro mwiqi varusa mwasaasa tiva niro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iesusiva nraase qora tiva ni varuvata mwisa mwira qua rieta tiqata, Qike, mwiva nara quave tiri tiva timwiso? Mwiva sia mwaara osara ti varia vaitinravusa tiantema sero ti variso. Mwiva nrora vaitivano tiantema sero ti variso, tura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mwitaa tuvaro Iesusiva mwaara nraavu mwiqi varuvaro vaanavano mwira vutaqi varu vaitiva nraavuqi vera ntero qua aasara ntero tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Iesusio, e Nasaretiniaavave. E tiri nataa hirerarave nriaro? E tiri ntuqutu taiqa sarerarave nriaro? Ne i osara ntapihi sauva e nriaro. Kotiva i titaisara e Kotira saiqaqai vare variarava variaro, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mwitaa tuvaro Iesusiva vaana mwira irora hiro tiqaro, Tirema variane. Mwi vaitiraqitaira nritarera vuane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Iesusiva mwitaa tuvaro vaana mwiva mwoqama sero mwi vaitira tu varero qasaa qasaama sero qua aasara ntava mwatero qaqinani nritarero viro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Vaanavano nritarero vuvata mwiqi uairama vita varusa sauqu ntukikiraaqata seqata nai tiva mwi nai tiva mwi hita tiqata, Nara inraisavanove qovarama viso? Mwaa quara qaraaha quave. Mwi vaitiva kepusa qua tisatama vaanavanovata mwira qua riaavo, tura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mwisa mwitaa tivaqi vita nrita huvata esaa Karirini varusavata mwi quara riora. ");
INSERT INTO omw_a_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iesusiva mwaara nraavuqitairo veva ntero Semisisa Ionisa vita varero vuva uro Saimonisa Enturusa nraavuqi vera ntero varura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimonira nriraatarara mwavanta tutoqa huvaro taintaqaa vaite varuvata mwisa mwirara Iesusira tiva mwita. ");
INSERT INTO omw_a_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tiva mwuvaro Iesusiva mwira uro taqero mwira sauquqa tu varero mwira mwaaviarama sero. Mwitaama sovaro mwira mwavantavano suqema viro naitarama vahuvaro mwi nraaseva tiviro sara uta nireraro tequa hura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Iesusiva mwi mwatusaraqi varuvaro huarivano visovaro entama vuvata nraase qora nriqa vusavata, vaanavano vutaqi varusavata, vita vareta Iesusiva varunani uro sora. ");
INSERT INTO omw_a_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mwitaa huvata esaa mwi mwatusaraqinaasavata Iesusiva varu nraavura qeti mwira nrima varita huvai sora. ");
INSERT INTO omw_a_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Huvai seta varuvaro Iesusiva nraase qora airinti mwo qara mwo qarama sero nriqa vusa suqema natovaro mwisa nriqa vuva taiqa vuvata so varura. So varuvaro vaanavanovata airi vaitiqi varusa titamwa sovata nritareta vura. Nritareqata vi varuvaro Iesusiva vaana mwisara qao tiro tiqaro, Siavata qua tiate, tiro. Vaanavano Iesusira ntapihi sovarora tiro, Iesusiva mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mwira qararaara sia qaata huvaro Iesusiva tiviro veva ntero uro sia vaitivanovata varunani Kotiravata qua tireraro vura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mwini vuvaro Saimoniva nai henasavatama sero mwira huaa hirero viro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Vusa uro Iesusira huaama seta mwiravusa mwirara tiqata, Quqaara e mwaini variarata esaa mwaa mwatusaraqinaasa iara huaa hi variavo, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mwiravusa mwitaa tuvaro Iesusiva qaqao tiro, Varaivaqenravu mwo mwatusa mwo mwatusavata nrueqata qua mwasaasa nraase qora tiva niare. Ne mwasaasa mwisa tiva nirera nruvave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mwitaa tiva sero mwiravusavata vita varero Karirini nrue variqaro mwaara nraavu mwoqi mwoqi vera ntero variqaro mwasaasa nraase qora tiva niqiro viqaro vaiti vutaqitairo vaanavata titamwa sovata nritare vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Iesusiva mwasaasa tiva niqiro vi varuvaro vaiti mwovano uhumakara utu vaitiva Iesusiva varunani nrintero tori sauru raviro Iesusirara po se tiqaro, E ni saahaqa hiataa hirera, e soma ni uhumakara nruka matenarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mwitaa tuvaro Iesusiva mwi vaitirara po se tiva mwatero, nai sauqu miavi mwira mwavantaqaa vatero tiqaro, Ne mwitaa hiataa isana i mwitaama mwatarerave. I mwavantara suqema vuarive tuqo, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","mwira uhumakara qamwanrama tavanta vuvaro mwiva so varura. ");
INSERT INTO omw_a_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mwiva so varuvaro Iesusiva mwi vaitirara kepusaqama sero tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Sia mwosavata tiva niraitira, viraro Kotira saiqa vara mwate vari vaitiva i mwavanta taqaarive. Mwiraqaataira e Mosesiva mwaara qua tiva tora rieqarama Kotira mwo inraisa mwirata nraase qoravano iara tiqata, Quqaama mwira mwavanta suqema viso tiate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Iesusiva mwitaa tuvaro mwi vaitiva sia Iesusiva tunte hiraitiro, mwi quara viti tiva ni viri tiva ni huvata esaa vaiti riovaro mwira saara Iesusiva mwo mwatusa mwo mwatusa qoqaa vuariva sia vahuvaro mwiva qaqira sero sia mwatusani viraitiro, qumina sata variqiro vuvata nraase qora itai itaita mwira taqarerata nrurama. ");
INSERT INTO omw_a_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Iesusiva Karirini nruantero nrima ntantero Kapeniaani uro varuvata mwi mwatanaasa Iesusiva nrima variso tu quara rieta ");
INSERT INTO omw_a_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","mwisa airivano uro Iesusiva varu nraavuraqi uairama vita nraavu mwiavata kuraama seta qetianavata huvaiqu sovaro mwovano mwiqi vera ntaariva sia soqa hura. Mwitaa huvaro Iesusiva nraavu mwiqi variqaro mwasaasa tiva ni varura. ");
INSERT INTO omw_a_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Iesusiva tiva ni varuvata vaiti mwonravuvano niari hena vaiti mwo mwira mwavanta hini qutu vura taintama vare nrura. Erahiamuaantema vaitinravu mwira taintama vareta nrura. ");
INSERT INTO omw_a_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mwiravusa nri nteta Iesusira nraaqani vuanarave tita, taqovata nraase qora airivano varuvata mwiravusa nraavu vutaqi vera nteva sia soqa hura. Sia soqa huvata mwiravusa qaqira seta nraavu qiata tahiporaqaa mwaari nteta mwi vaitira vara mwaari vateta, Iesusiva nraavu vutaqi varuvata mwiravusa Iesusiva varura mwira miavi ntukuraa seta. So ntukuraa seta nriqa vu vaitira taintaqaa vatora qasomase saqi vuvaro mwi taintava nraase qora vutaqaa uto vahura. ");
INSERT INTO omw_a_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Vahuvaro Iesusiva riovata mwi vaitinravusa niariaqai tiqata, Quqaama mwaa vaitira Iesusiva so suqema saanarove, tu vaitinravusa varuvaro Iesusiva hini mwavanta qutu vu vaitirara tiqaro, Ni maaquo, e Kotira qua raaquta saanara ne mwi quara nrukama mwatauqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Iesusiva mwitaa tuvata mwaara osara ti varu vaitinravusa mwiqi varusa riemwaqi vita tiqata, ");
INSERT INTO omw_a_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Qaqao, mwi vaitiva naraqamave mwitaa tiso? Mwiva mwitaa tiqaroma Kotira uaqama mwate variso. Siama qumina vaitivano variqaro nai hena vaitiara, E Kotira qua raaquta saanara nruka mwatauqo, tianarove. Kotiva mwivaqai so mwitaa tianarove, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mwisa mwitaama nraato riovaro Iesusivavata mwisa vu nraato tura ntapihi sero tiqaro, Né nataamaqive mwitaama riaavo? ");
INSERT INTO omw_a_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ne mwaa vaitira hini mwavanta qutu virara tiqanama, E Kotira qua nteqa saanara ne nrukama mwatauqo, tuqatama né niara tiqata, Qaqao, i quavano unra quave. Sia quqaa qovara hianarove, tiarave. So mwaini riaate. Ne mwi vaitirara tiqana, Tivira ena tainta tu varera vuane, tiariro sove ni quara mwiva mwitaa hianarove? Né tiva mivaqena riaase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Iesusiva mwitaama sero mwisa saparama natero mwiva mwisara qaiqaa tiqaro, Ne mwatani mwatatai nraaqiarava varuqaro ni nroraqama saisanara tina, ne soma mwatani variqana vaitivano Kotira qua nteqa saani quara nruka saanirave. Né ni quara quqaa quave tiate tina, ne mwate mwaa vaitirara mwitaa tirerave, tiro. Mwitaa tiva sero Iesusiva hini mwavanta qutu vu vaitirara tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Tivira ena tainta tu varera ena mwaatani vuanema tuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mwitaa tuvata esaa nraase qora mwira taqe varuvaro mwi vaitiva tiviro miavi nai tainta tu varero vuvata mwisa nriharama vita sauqu ntukikiraaqate varita Kotira nrutu tuaahereta tiqata, Mwaa saiqara mwo qara hi saiqara sia taqauna saiqarave, tura. (Mwi entara taakisi vare varu vaitisa mwonravuvano taakisi vareqata hini munima niari tuteta hini munimaqai niari nrora vaiti nura. Mwitaa huvata qumina nraase qoravano taakisi varo vaitisa esaa mwisara muara vaitiqaima variavo tura.) ");
INSERT INTO omw_a_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesusiva Kapeniaani vari sero mwiraqaatairo nrima ntantero Kariri nramari tosasataa vuvata nraase qora airivano mwiva varunani uairama vita varuvaro Iesusiva qua mwasaasa mwisa tiva niro. ");
INSERT INTO omw_a_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mwiraqaatairo mwiva vuva uro variqaro taqovaro Rivaiva, Arapiaasira mwaaquvano, opisi nraavuqi taakisi vare varuvaro Iesusiva mwirara tiqaro, Ni naatiara nriane, tiro. Mwitaa tuvaro Rivaiva tiviro Iesusira vataqiro vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Iesusiva Rivaira nraavuqi uro variqaro nai nraaqiaranravuvata sara nre varuvata airi vaiti taakisi vare varusavata, vaiti mwonravu mwisara uaqaahi saiqara uti variasave tusa mwisavata, nraavu mwiqi variqata sara nre varura. ");
INSERT INTO omw_a_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Iesusiva vaiti mwiravusa sapata sara nre varuvata Parisi vaiti mwaara osara ti varusa taqovaro Iesusiva taakisi vare varusavata, uaqaahi saiqara uti variasave tusa mwisavata, sara nre varuvata mwisa Iesusira nraaqiaranravu sapara hita tiqata, Naraqamave Iesusiva uaqaa hia vaitisa sapata sara nre variso? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Parisi vaitinravuvano mwitaa tuvaro Iesusiva mwisa qua riero tiqaro, Qaqi vari vaitiva sia totaava hinani vi varirave. Nriqa vi vaitivaqai totaava hinani vi varirave. Ta vaitisave tiqata, Te avuqavuma seta nrue varurasave tiasa, ne sia mwisa nraararerana tuvuvave. Ne uaqaa hia nraase qorasa nraararerana tuvuvave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mwi entara Ionira nraaqiaranravuvanovata, Parisi vaitinravuvanovata, sara auramate varuvata vaiti mwonravuvano Iesusira sapara hita tiqata, Ionira nraaqiaranravuvanovata, Parisi vaitinravuvanovata, sara auramate variavo. So naraqamave i nraaqiaranravuvano sia sara aurama taraitita, qaqi sara nre variavo? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mwisa mwitaa tuvaro Iesusiva tiqaro, Nraase vararera tiari vaitiva nai vataasavata qaqi varirera, sove mwovano mwira vataasara sara aurama taate tianaro? Qaqao, siama so mwovano mwitaa tianarove. Nraase vararera tiari vaitiva qaqi varirata mwira vataasa sia sara aurama taraitita, qaqima sara nrevarave. ");
INSERT INTO omw_a_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mwo enta nri ntairata mwisaqitai nraase vararera tiani vaitira tu vareta qaqinani vara saivata mwi entaraqaataita mwira vataasa ti atura ntiqata sara aurama tevarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mwitaa tiva sero Iesusiva mwo quaqaa ntuva sero tiva niro tiqaro, Mwovano tuavaaqa nrihi nrahitu vuanira haqirareraro siama mpuruqa qaraaha toqa sero mwiraqaa ntaaqautero haqiraanarove. Mpuruqa qaraaha mwira toqa saariro qaara vahiraro tuavaaqa nrihi mwivavata nroraqama sero nrahituanso tiro, sia mwitaa hirave. ");
INSERT INTO omw_a_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Qaiqaa tirerave. Uaini qaraaha tati sero sia mwovano memeraa pahiqo ututaira haaruaa taqu vara sero qaraaha uaini mwira mwiqi raurirave. Memeraa pahi mwiva nraahaqama viraqa mwiva mwitaa hiraro uainivano kepusa uaini utu viqaro memeraa pahi nrahitu saanarove. Mwitaa hiraro uainivanovata memeraa pahivanovata uaqama vuanarove. Memeraa pahiqotai ututaa taqura qaraaha taqu vara seta mwiqiqai qaraaha uaini rauruarave, tiro. (Iesusiva mwi quaraqaa ntuva sero tu quara osaravano mwataamama vahiro. Mwira votima seta siama nraarunia osaravata qaraaha osaravata kuaaqi uairama seta tutaate, tura). ");
INSERT INTO omw_a_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mwo enta mwaara tu entaraqaa Iesusiva nai nraaqiaranravu sapata nraaso vutaqi qakuma votihura uiti vara tutoraqi vi varuvata mwira nraaqiaranravuvano viqatama uiti tava nteqa seqa nravaqita vi varuvata ");
INSERT INTO omw_a_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisi vaitivano mwisa taqeta Iesusirara tiqatama, Mwataqi mwisa taqaane. Mwaaraqaa qao tiva tai inraisarama mwisa vareta hiavo, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Parisi vaitinravuvano mwitaa tuvaro Iesusiva niari tiva niro tiqaro, Haaru ini haivaqava Devitivavata, mwiavata nrusa mwisavata, sara nraataa huvata varuvaro Devitiva kuaa qara hura mwira né sia vukuqi saara ntuva seta riaarave? ");
INSERT INTO omw_a_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Apaiataava Kotira saiqa vara mwate varuva vuniaa vaitivano varu entaraqaa Devitiva Kotira nraavuqi vera ntero mpereti Kotirani vatora vara sero nrero nteqa sero nai mwira vatama seta nrusavata hini nuvata nrorave. Kotira saiqa vara mwate varu vaitisaqai mwi sarara nraataara vahuvaro qumina vaitivano mwi sarara nrero mwi quara nteqa sorave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iesusiva mwitaa tiva sero tiqaro, Kotiva vaitiara rieqaro mwaara enta vahianarove turave. Kotiva sia mwaara entara rieqaro vaiti utu tairave. ");
INSERT INTO omw_a_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ni mwatani mwatatai nraaqiarara nroraqama saisana variqana ne mwaara entaqaa ntaqaihiqanama nena sasa hiani saiqara soma varaanirave, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mwo enta Iesusiva mwaara nraamwuqi vera ntero taqovaro vaiti mwovano sauqu hini kukokaqama vuva varuvata ");
INSERT INTO omw_a_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","mwiqi varusa mwonravuvano tiqata, Sai variqata taqaararo Iesusiva vaiti sauqu kukoka mwira mate mwaara tuna entaraqaa suqema sairera, mwira saara mwiraqaa qua vataare, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mwisa mwitaa tiva seta Iesusira taqe varuvaro Iesusiva sauqu hini kukokaqama vu vaitirara tiqaro, E nrira vaiti variara vutaqaa tivira variane, tuvaro mwiva tiviro varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Iesusiva mwisa sapara hiro tiqaro, Tirenravu teta mwaara qua rieqatama mwaara tiana entaraqaa nataa hiani saiqarave so varaanarave? Te mwi entaraqaa vaiti mwo saahaqamave mwataanarave? Mwira uaqamave mwataanarave? Mwaara tiana entaraqaa te vaiti mwo saahaqa hiararo mwiva qative varianarove? Te qaqira seta mwi vaitira ruve saanarave? tiro. Iesusiva mwitaa tuvata mwisa sia quavata tisa tirema varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesusiva taqovata mwisa sia mwi vaitirara po se tiraitita, kepusa viri rate varuvaro mwira saara Iesusira mwutusavano uaqa huvaro mwira raraqa tovaro mwi vaitirara tiqaro, Ena sauqu ntatutaane, tuvaro mwiva nai sauqu ntatuta sovaro suqema vura. ");
INSERT INTO omw_a_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mwira sauquvano suqema vuvata Parisi vaiti mwiravusa mwaara nraavuqitai veva nteta uro Herotira vataqita nruosa sapata uairama vita variqata Iesusira nataama setave ru saanarave tiva seta nai tiva mwi nai tiva mwi hi varura. ");
INSERT INTO omw_a_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesusiva nai nraaqiaranravu vita varero nruka tosasata uro varuvata nraase qora airivano Kaririniaasave, Iutianiaasave, ");
INSERT INTO omw_a_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ierusaremiqinaasave, Itumianiaasave, Taiaaqinaasave, Saitoniqinaasave, Sotaani nramari vutura qarahi hini varusave, mwisa Iesusiva mwo saiqa mwo saiqa vare varurara rieta, mwisa Iesusiva varura nramari tosani uairama vita varura. ");
INSERT INTO omw_a_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nraase qora airivano uairama vita varuvarora tiro, Iesusiva nai nraaqiaranravuara tiqaro, Nraase qoravano ni ntaqutivorave. Votu terama seta vataivaqena mwiqi mwaarintena variase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iesusiva nraase qora airi suqema sovatara tita, nriqa vusa mwira tu vararerata uti variqata nai ntaquti nai ntaquti hi varura. ");
INSERT INTO omw_a_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mwisa mwitaa hi varuvata nraase qora mwonravu vaanavano mwisa vutaqi varusa, mwisa Iesusira taqeta mwira vuni uto ntita variqata aasara nteta tiqata, E Kotira mwaaquvanove, tita. Vaanavano mwisa vutaqi varu vaitisa mwitaa tuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Iesusiva mwisara kepusaqama sero tiqaro, Sia ni osarara tiate. Tirema variate, turama. ");
INSERT INTO omw_a_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesusiva mwini vari sero uro taaqi mworuqaa variqaro nai mwutusa vahu vaitisaqai nraanrovata mwisa uro varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Iesusiva vaiti 12 nravu saara ntuva sero mwisara ne mwisa vitaarita ni qua vareta tiva niqi vuate tiva sero, mwisa nroraqama sero mwisara tiqaro, Nénravu ni airiqama mateta ni qua tiva niate tinama, ne ini vita vatauqo. ");
INSERT INTO omw_a_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nénravu vaana titaivaro nritarero vuarive tina, ne ini kepusa nirerave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iesusiva mwaa vaitinravusa vitora: Saimonira — Iesusiva mwira mwo nrutu ntavatero Pitaavave tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Semisisa Ionisa — Mwitanasa Sepetira mwaaqutana varura. Iesusiva mwitanasa mwo nrutu Poanesisi-satanave tura. (Poanesisi mwaa quaraqitai tirerata, Naaruva Nruqua Ti Varirave, tita.) ");
INSERT INTO omw_a_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Enturura Piripira Pataromiura Matiura Tomaasira Semisira — mwiva Arapiaasira mwaaqu Tatiaasira Saimonira — -mwira nrutu mwo Serotira ");
INSERT INTO omw_a_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Iutaasira — mwi vaitiva Iesusira ntavaaqavu saate tiro, mwira qovarama so vaitiva. Iesusiva 12 vaiti mwi vaitinravusa vitora. ");
INSERT INTO omw_a_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesusiva nai nraaqiaranravu vita varero nraavuniara niari mwaatani vuvata qaiqaa nraase qora airivano mwira taqarerata uairama vita varuvaro Iesusiva nai nraaqiaranravu sapata sara nraariva sia soqa huvaro varuvata ");
INSERT INTO omw_a_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iesusira vataasa mwi quara rieta Iesusirara tiqata, Qike, mwiva ueraqamama viso. Sai uro mwira vitaare, tiva seta vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mwaara osara ti varu vaitisa mwonravuvano Ierusaremitaita utonte mwitaama tita, Vaana vuniaava Belsepurivama Iesusira vutaqi variso. Belsepuriva mwira vutaqi variqaro mwira saahaqa hi varisaroma Iesusiva vaitiqitairo vaana tite variso, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mwisa mwitaa tuvaro Iesusiva mwisa nraanrovata vaini nruvaro mwo quaqaa ntuva sero mwisara tiqaro, Saataaniva nataama serove nai henara titairaro nritaraanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kuaa mwatanaavano ntuaqamavi variqata niaritana nai ntaqi nai ntaqi hisa sia so varivarave. ");
INSERT INTO omw_a_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kuaa nraavunaavano ntuaqamavi variqata niaritana nai ntaqi nai ntaqi hisa, mwisavata sia so varivarave. ");
INSERT INTO omw_a_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Saataaniva ntaqaihi vari vaanasa ntuaqama vita nai ntaqi nai ntaqihi varivaro Saataaniva sia mwisaqaa ntaqaihiqiro viraro mwisa kepusavano taiqaanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Muara varaiva sia kepusa vaiti mwo nraavuqi qumina vera ntero mwo inraisa varairave. Muara varaiva vuni kepusa vaiti mwira nraante rupa sero vatero mwiraqaatairo vera ntero mwo inraisa mwiani muara varairave. ");
INSERT INTO omw_a_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ne quqaa qua tianira riaate. Nraase qoravano uaqa hiani saiqara mwo qara mwo qara hiani saiqara uti vari quarave, uaqa hi quara mwosara ti vari quarave, Kotiva soma esaa mwi quara mwi quara nraase qora qaqi nruka sero tauru nataanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Vaitivano Kotira mwaraqurara uaqa hi quara ti vari quara Kotiva mwaa entaravata nraatiaravata mwi quara sia nruka sero tauru nataanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesusirara vaanavano mwira vutaqi variso tuvarora tiro, mwiva mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iesusiva mwitaa tuvata mwira nrovavata, mwira qatanravuvata, nri nteta mwaata qetiqaa tivi varita tiqata, Iesusira tivaro tuvuarive, tuvata ");
INSERT INTO omw_a_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","nraase qora airivano Iesusira tataaqa mwatasaa vita varusa Iesusira tiva mwita tiqata, I nrovavata, i qatanravuvata, mwaataqa variqata iara tuvuane tiavo, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mwisa mwitaa tuvaro Iesusiva mwisa sapara hiro, Tavave ni ntova variso? Tasave ni qata vasaa variavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mwitaa tiva sero mwira tataaqa vara ututu mwatasaa vita varusa taqero tiqaro, Mwaasama ni ntosa ni qata vasaa variavo. ");
INSERT INTO omw_a_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ni qova naavuni varira mwira qua rieqata nrue variasa, mwisama ni qata vasaa variavata, ni nura nasaa variavata, ni ntosavara varita hiavo, tura. ");
INSERT INTO omw_a_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesusiva nruka tosani uro variqaro nraase qora qua mwasaasa tiva niase tuvata nraase qora airivano uairama vita mwira ututuma sovarora tiro, Iesusiva qaqira sero votu mwoqi mwaari ntero mwiqi mwatasaa viro nramariqaa varuvata nraase qoravano nramari tosa sata varura. ");
INSERT INTO omw_a_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mwisa mwataqaa nramari tosa sata varuvaro Iesusiva mwo qua mwo quaqaa ntuva seqaro tiva nura. ");
INSERT INTO omw_a_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Iesusiva tiqaro, Ne tianira riaate. Vaiti mwovano sara vara tireraro humwu itatamaqiro vurave. ");
INSERT INTO omw_a_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mwiva sara humwu itatamaqiro vuvaro mwohuva aara tosani uto ntuvaro kurivano nrima nrava sorave. ");
INSERT INTO omw_a_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mwitaa huvaro humwu mwonravuvano ori mwataqaa uto ntuvaro mwatavano sia vevatoqama vahuraqaara tiro, qamwanrama qupiqa vuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","mwira tuqavano sia mwataqi vevato vuraqaara tiro, huarivano nri ntero itovaro aaharama vurave. ");
INSERT INTO omw_a_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mwitaa huvaro humwu mwonravuvano uakusa qupiqoraqi uto ntiro uakusa vatama sero qupiqa vuvaro uakusavano ntuvaqu sovaro sia tava riorave. ");
INSERT INTO omw_a_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mwitaa huvaro humwu mwonravuvano suqe hu mwataraqaa uto ntiro suqema sero qupiqeqaro suqe tava riorave. Mwo huva airi tava riemwa tovaro mwo huva uro mwoqavata riemwa tovaro mwo huva uro mwiravata nraatarero mwoqavata riemwa torave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iesusiva mwi quaraqaa ntuva sero tiva ni taiqa sero tiqaro, Ini nraato vahirera, mwi quara osara ntapihi seta riaate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iesusiva qua tiva ni taiqa sovata nraase qoravano niari mwaatani vita nrita huvaro Iesusiva nariaraa varuvata mwira nraaqiara 12 nravuvanovata, mwo husavata, mwiva varunani nri nteta Iesusiva mwi quaraqaa ntuva sero tu osarara sia ntapihiraitita, Iesusira sapara huvaro ");
INSERT INTO omw_a_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iesusiva mwisa tiva niro tiqaro, Kotiva nraase qoraqaa ntaqaihiani quara uqetatai quara, mwi quara Kotiva iniara qaqi sairata mwi quara osara riaate tirave. Mwitaa tiva sero mwo nraase qora qaqinani variasa mwi quara osara sia ntapihi sera tiva niane tisanara tina, ne mwi quaraqaa ntuva seqana mwisa tiva nirerave. ");
INSERT INTO omw_a_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ne mwo quaqaa ntuva sena tiarita nraase qoravano taqeqatavata siama ntapihi seta taqevarave. Mwisa ni qua rietavata siama ntapihi seta rievarave. Mwisa ni qua rieqata niari uaqaahi saiqara qaqira saivarovauma Kotiva mwisa uaqaahi saiqara vare quara nruka nataanarove, tiro. (Ais 6:9-10) ");
INSERT INTO omw_a_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iesusiva mwitaa tiva sero mwinravusara tiqaro, Né mwo? Ne mwi quaraqaa ntuva sena tu osarara hiave né ntapihi riaavo? Né sia mwi quara osara ntapihise riaivera, ne nraakiara mwo quaqaavata ntuva sena tiani quara, né nataama setave so mwiavata ntapihi seta rievarave? ");
INSERT INTO omw_a_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ne vaasa mwi quaraqaa ntuva sena tu osarara tirerave. Vaitivano humwu itatama tora mwi quara osara vahireraro Kotira quama vaiso. ");
INSERT INTO omw_a_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Humwu aaraqaa utontu quara mwira osara vahireraro nraase qora mwonravuvano mwi humwura votima seta variarave. Mwi nraase qorasa Kotira qua riaavaro Saataaniva nri ntero mwisa vu nraato mwutusaqitairo mwi quara ntavihi sero varairave. ");
INSERT INTO omw_a_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mwohia nraase qorasa ori mwataqaa uto nti humwura votima seta variarave. Mwiravusa Kotira mwasaasa rieta mwi quarara qamwata seta variavaro ");
INSERT INTO omw_a_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","quavano sia mwisa mwutusaqi visata mwi nraase qorasa sia mwi quara mwo enta mwo enta riaraitita variavata mwi quara saara mwo hiasa mwisa uaqama natarerata uti variavata mwisa tiri rivorave tiqata Kotira qua qamwanrama qaqira seta varia nraase qorasa variarave. ");
INSERT INTO omw_a_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mwohia nraase qorasa uakusa qupiqairaqi itatamato humwura votima seta variarave. Mwi nraase qorasa Kotira qua rieta ");
INSERT INTO omw_a_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mwiraqaataita mwisa mwataniaa inraisara nroraqama seta riemwaqi viqata munimarave, mwo inraisarave, qamwata seqata mwo inraisa mwo inraisa vararerata riemwaqi vita Kotira qua qaqira saavaro Kotira quavano sia mwi nraase qorasaqi vaisata variarave. ");
INSERT INTO omw_a_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mwisa mwitaa hiavata mwohia nraase qorasa suqe mwataqaa itatamato humwura votimase variarave. Mwi nraase qorasa Kotira qua rieta mwi quarara quqaave tiva seta, mwi quara riemwaqi vita suqe saiqa Kotirani varaqita vuarave. Mwohia nraase qorasa mwi quara rieqata suqe saiqa Kotirani varaqi vi variavata, qaiqaa mwohia nraase qorasa mwisa nraatara seta uro mwoqavata suqe saiqa Kotirani varaqi vi variavata, qaiqaa mwohia nraase qorasa mwisa saiqavata nraatara seta uro nai mwoqavata suqe saiqa Kotirani varaqita vi variarave, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesusiva mwitaa tiva sero mwo quaqaa ntuva sero tiqaro, Ova qupi sero taini uro vatairave? Kina vara sero ntuvaqu tairave iso? Tainta mwevaqi veta vatairave iso? Qaqao, sia mwitaa hiraitiro, ova qupi sero tuaahera sero qoqaa mwaari vatairave. ");
INSERT INTO omw_a_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Naatiara esaa uqeta taani inraisara qoqaama qovarama saanarove. Ntuvaqutaani inraisara esaa qoqaama qovarama saanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ini nraato vahirera, mwi quara osara ntapihi seta riaate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesusiva mwitaa tiva sero mwiva tiqaro, Né qua riaara mwira ntapihi seqata riaate. Né nara tusaqaave mwosa nítave mwosa vara natera mwi tusaraqaama Kotiva nítavata niqaro mwiraqaa mwoqavatama nianarove. ");
INSERT INTO omw_a_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kotira qua riaariva variqiro viraro Kotiva mwira saahaqa hiraro mwiva mwira qua mwoqavatama riaanarove. Kotira qua sia riaariva variqiro viraro mwiva nara inraisave tutaanira mwira vara sairaro mwiva qaqima varianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mwitaa tiva sero Iesusiva mwo quaqaa ntuva sero tiva niro tiqaro, Kotiva ntaqaihiariva mwaa quara votima seroma vaiso. Vaitivano sara humwu isatama tero ");
INSERT INTO omw_a_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","mwiraqaatairo mwiva uro vaitero tiviro qaiqaa vaitero tiviro mwitaamaqiro vi varisaro sara humwuvano nai ntukohiro qupiqe varirave. Vaitivano sara humwu mwiva qupiqaani osarara sia ntapihisaro ");
INSERT INTO omw_a_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","nai mwataqi vahiro naiqama sero qupiqairave. Tauraaqama sero uru mwiva ntukohiro turu vera sero uro tava riemwa taisaro tava mwiva kepusaqa hirave. ");
INSERT INTO omw_a_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kepusaqa visaro vaitivano paipa varero uro tava mwira teqa seqaro varairave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesusiva mwitaa tiva sero qua tiva niqiro viro mwitaama tiro: Kotiva ntaqaihiva nara inraisa votima serove vaiso? Mwirara rieqana nara quaqaave ntuva sena tianirave? ");
INSERT INTO omw_a_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","So mwi maasiteti satari mwira tava votima seroma vaiso. Uru mwiva nai pataqani vahirarama tuqo. Vaitivano uru mwira vara sero mwataqi tutaisaro ");
INSERT INTO omw_a_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","qupiqero satari nroraqama viro hini sara tutaaravata nraatara sero nritarero satari nrora vaisaro mwira sauquvanovata nrora vaisaro kurivanovata mwira sauquqaa nraavu hoqatero mwira aamanaqi varirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mwitaa tiva sero Iesusiva mwi quara voti hira mwo qua mwo quaqaavata ntuva seqaro tiva niqiro viro nraase qoravano ntapihi seta rie quaraqai mwisa tiva nura. ");
INSERT INTO omw_a_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mwiva nraase qora qua tiva nireraro sia vutu sero tiraitiro, mwo quaqaa ntuva seqaro tiva niqiro vuvata nraase qoravano niari mwaatani vita nrita huvaro Iesusiva nariaraa nai nraaqiaranravu sapata variqaro mwi quara osara ntapihi sero mwiravusa tiva nura. ");
INSERT INTO omw_a_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mwi entara entama vuvaro Iesusiva nai nraaqiaranravuara tiqaro, Nrivaqenravu nramari nrora mwaa qara vare vutura hini tosani vuare, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mwitaa tuvata mwira nraaqiaranravuvano nraase qora uairama vusa mwini seta Iesusiva varu voturaqi mwaarinteta mwira vita vareta vuvata votu mwonravuvano mwisa vatama seta vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mwisa nramari mwiraqaa vi varuvaro qamwanrama sero toqa vaururuvano nroraqama sero tiqaro nramari raaqutaqiro nrivi varuvaro nramarivano votuqi mwaarintero kuraama sareraro uti varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesusiva votu vitiqi quruma ntuva sero vaite varuvata mwira nraaqiaranravuvano mwira uro huruma seta tiqata, Mwaara ti variara vaitio, tirinravu nramarivano ntaqutu saanirara e siave nroraqama sera riaaro? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mwisa mwitaa tuvaro Iesusiva vaitoraqitairo tiviro toqa vaururu mwira irora hiro nruka mwirara tiqaro, Qaqi tirema vahiane, tuvaro toqavano taiqa vuvaro nramarivano utovi tirema vahura. ");
INSERT INTO omw_a_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tirema vahuvaro Iesusiva nai nraaqiara mwisara tiqaro, Nara inraisa nraatuve aatu hi variavo? Né siave niara kepusaqama seta rieta hiavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iesusiva mwitaa tuvata mwira nraaqiaranravuvano aatu hita sauqu ntukikiraaqateta tiqata, Qike, mwaa nai nataahi vaitivave? Toqa vaururuvanovata, nramarivanovata, mwira qua riaiso, tita tura. ");
INSERT INTO omw_a_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mwira nraaqiaranravu mwitaa tiva seta votuqi vusa nrukaqa qara vareta hini tosa Kekesaani uro ntovaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iesusiva votuqitairo mwaavi ntovaro vaiti mwovano ori ontavuqitairo veva ntero uto Iesusira hunta sora. ");
INSERT INTO omw_a_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Mwi vaitiva vaiti qunte varura ori ontavuqi variqiro vi varuvaro vaanavano mwira vutaqi varuvaro varuvata mwo husa seni vara seta mwira rupa taare tita, rupa tovaro mwi vaitiva airi saanta suqu sauqu rupa tora ntapihiqaro ntukekaama sora. Qaiqaavata mwitaama seqata mwira rupa taare tuvaro mwiva seni ntukekaamaqai sorara tiro, mwovano mwira rupaariva sia varura. Mwira nraataraariva sia varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","mwi vaitiva entaqivata, ataahiraqaavata, vaiti qunte varura ori ontavuqi viro nriro hiqaro qua aasara tivaqiro viro taaqiqaavata nrueqaro qua aasara tiqaro oriqotairo nai mwavanta toqaaqamaqiro vi varura. ");
INSERT INTO omw_a_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mwi vaitiva variqaro niaratairo Iesusira taqero santero uro mwira suqutarani uto ntiro variqaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","mwoqama sero aasara ntero tiqaro, Iesusio, Kotiva nai virini variva varisara e mwira mwaaquvano variaro. Ni nataa hirere nriaro? Kotirara rieqara sia ni ruanema tuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Iesusiva vuni mwi vaitirara tiqaro, Uaqa hiara vaanavao, mwi vaitiraqitaira nritarera vuane, tuvarora tiro, mwi vaanava mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mwitaa tuvaro Iesusiva mwi vaanarara ena nrutu tiane tuvaro vaana mwiva nai nrutu ntero tiqaro, Ni nrutu Airivave. Te airivanoma mwaa vaitiraqi varuro, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mwitaa tiva sero mwi vaanava qaiqaavata airi nani Iesusirara po se tiro tiqaro, Sia mwaa mwataraqaataira tiri titaane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mwitaa tiva seta vuru taqovaro mwi entara quara airintivano uhiqa nre varuvata ");
INSERT INTO omw_a_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","vaananravuvano Iesusirara po se tita tiqata, Qaqi tiri titairaqe quara mwisaqi viqetaare, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesusiva mwisa qaqi sovata vaana airivano mwi vaitiraqitai nritareta uro quara mwisaqi viqeteta varuvata mwiraqaataita quara 2000 nravuvano santeta okai veva vahuraqi uto nteta nramariqi avuhu vuvaro nramarivano esaa mwisa ntaquti sora. ");
INSERT INTO omw_a_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Quaravano nramariqi ntuva vita qutu vuvata quaraqaa ntaqaihu vaitinravusa taqeta mwiraqaatai santama teta mwatusa nroraqi uro mwi quara tiva nita aaranivata viqata viti viri tiva niqi vuvata mwi mwatanaasa mwi inraisara taqarerata nrima ");
INSERT INTO omw_a_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iesusiva varunani taqovaro vaasa vaana airivano mwira vutaqi varu vaitiva qaqi mwatasaa viro tuavaaqa utu tero mwira vu nraato ntapihi vuvaro varuvata mwisa mwira taqeta aatuma seta varura. ");
INSERT INTO omw_a_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mwisa mwi vaitira taqeta aatu hiqata varuvata vaiti mwonravu vaasa mwi inraisara taqosa tiva nita tiqata, Iesusiva mwitaama saisaroma mwi vaitiva suqema viso, tiva seta quararavata tiva nuvata ");
INSERT INTO omw_a_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","mwi mwatanaasa mwoqama seta aatu hita Iesusirara tiqata, E tiri mwataqaataira vuane, ti varura. ");
INSERT INTO omw_a_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mwi mwatanaasa mwitaa tuvaro Iesusiva votuqi qaiqaa mwaari nte varuvaro vaasa vaanavano vutaqi varu vaitiva Iesusirara po se tiro tiqaro, Sai nevata ivata vuase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mwitaa tuvaro Iesusiva qaqao tiro, Sia mate nivatama sera vinarave. E ena mwaatani uro variqarama Kotiva i suqema sero saahaqama mwatairara ena nravunaasavata tiva niane. Kotiva iara po se tiva mwatai quara uro ena nravunaasavata tiva niane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iesusiva mwitaa tuvaro mwi vaitiva Iesusiva tunte hiro mwi mwatara sero uro sauqurutana mwatusa vahunani nrueqaro Iesusiva nai suqema mwatorara nraase qora tiva niqiro vuvata esaa mwira qua riosa mwi quara rieqata mwisa niari sauqu ntukikiraaqa teqata varura. ");
INSERT INTO omw_a_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mwi mwatanaasa Iesusirara sia tiri mwaatani variane tuvaro Iesusiva votuqi qaiqaa mwaari ntero nrima ntantero nrukaqa qara varero hini tosani vuvata mwini nraase qora airivano uairama vita mwiva varunani ututuma vita varura. ");
INSERT INTO omw_a_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Varuvaro vaiti mwovano mwi mwatusaraqi mwaara nraavuqaa ntaqaihi varuva, Sairaasiva nri ntero Iesusira taqero mwira suqutarani uto ntiro Iesusirara ");
INSERT INTO omw_a_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","po se tiro tiqaro, Ni naavuravano qaumama qutu vuanarove. E nrira ena sauqu mwiraqaa vatairaro mwira nriqa vuariva taiqa viraro qaqi variarive, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mwi vaitiva mwitaa tuvaro Iesusiva mwisantiri vurama. Iesusiva Sairaasisantiri vi varuvata nraase qora airivano mwira vataqita viqata itai itaita mwira raaqutaqi vi varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","nraase mwovano esaa enta tora taqamwaqiro vuvavata mwisaqi varura. Mwi nraaseva 12 ihiara tora taqamwaqiro viqaro nroraqama sero nriqa vuvaro variqaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","mwo totaa mwo totaasara ni saahaqa hiate tiva sero, munima nuvata mwisa sia mwira saahaqa hiraitita, mwira munimaqai nravase varuvaro mwira mwavanta mwoqavata uaqama vuvaro varura. ");
INSERT INTO omw_a_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Mwi nraaseva nraase qora vutaqi variqaro Iesusiva saiqa varorara rieqaro Iesusira naatiara nriqaro nai riero tiqaro, Ne mwira tuavaaqaqa tu varaariro ni nriqa viva qamwanrama taiqa vuarive, tiro. Nraase mwiva mwitaa tiva sero Iesusira vaaqaqaa tu varovaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","qamwanrama sero mwira nraare ntova aaharama vuvaro mwiva taqovaro mwira mwavantavano so vahura. ");
INSERT INTO omw_a_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mwira mwavantavano suqema vuvaro varuvaro Iesusiva qamwanrama sero taqovaro mwira kepusa hinivano vivuvaro mwiva tuqataa viro nraase qora mwira vataqita nrusa sapara hiro, Tavave niqaa tu varaiso? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Iesusiva mwitaa tuvata mwira nraaqiaranravu tiqatama, Nai tavave iqaa tu varaiso? Ena taqaane, nraase qora airivano i tataaqani viqata i raaqutaqi vi variavo, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mwitaa tuvaro Iesusiva qaqiqai vaiti viri mwira huaama sareraro aitutu hi varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","nraase mwiva nai mwavanta suqema vurara riero mwira nraatu hiqaro suqu sauqu nti varuvaro uro Iesusira suqutarani uto ntiro mwi quara esaa qoqaa tiva mwuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesusiva nraase mwirara tiqaro, Ni naavurao, e niara mwiva ni saahaqa hianarove tiararoma i mwavantavano suqema viso. Soma i mwutusavano qihaasa hirara vuane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesusiva mwi quara qaqi ti varuvata Sairaasira nraavuqitaita vaiti mwonravu nri nteta Sairaasira hunta seta mwirara tiqata, I nraavuravano qutuma viso. Hauri mwaara ti vari vaitira ntavaaqavu tero, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesusivavata mwiravusa qua riero mwaara nraavuqaa ntaqaihi varu vaitirara tiqaro, Sia aatu hiane. Niara kepusaqama sera rieqara variane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iesusiva mwitaa tiva sero mwiva Pitaaravata, Semisiravata, Semisira qata Ioniravata, mwiravusaqai vita varero ");
INSERT INTO omw_a_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sairaasira nraavuqi nrintero taqovata nraase qora nroraqama seta ti atura ntiqata ntate varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iesusiva nraavuqi vera ntero tiqaro, Narare né ntate variavo? Mwi qiaatarava sia qutu viso. Mwiva qaqi vaitema variso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Iesusiva mwitaa tuvata mwisa Iesusira quara raima mwateta varuvaro Iesusiva esaa nraase qora vara veva mwaatani sero qiaatara mwira nrosa qosavata, taaramwonravu nai vita tosavata, mwiravusaqai vita varero qiaatara mwiva qutuvata vatoraqi uro ");
INSERT INTO omw_a_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","mwira sauquqaa tu varero nai quaqitairo tiqaro, Tarita kumi — mwaa qiaataravao, ne iara tivuanema tuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Iesusiva mwitaa tuvaro mwi qiaatarava qamwanrama tiviro nrue varura. Mwiva 12 ihi vara so qiaatarava tiviro nrue varuvata mwinravusa mwira taqeta nriharama vita mwoqama seta sauqu ntukikiraaqate varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iesusiva mwinravusara kepusaqama sero tiqaro, So mwaa taqaarara sia mwosa tiva niate. Mwaa qiaatarara saraqai mwiate, turama. ");
INSERT INTO omw_a_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesusiva mwi mwatara sero nai mwaatani vuvata mwira nraaqiaranravuvano mwira vatama seta vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Iesusiva nai mwaatani uro variqaro mwaara entaqaa uro mwaara nraavuqi qua mwasaasa tiva ni varuvata nraavu mwiqi nraase qora airivano varusa mwira qua rieta sauqu ntukikiraaqateta tiqata, Qike, mwi vaitiva taitairove mwi quara mwi quara riaiso? Mwiva suqe osara mwo vu nraato mwo vu nraato taitairo vara qirove tiso? Tava mwi saiqara osara mwira tiva mwisarove mwiva nrora saiqa vare variso. ");
INSERT INTO omw_a_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mwiva taintave mwitaa inraisa uti varivama variso. Mwiva Mariaara mwaaquve. Semisivave Iosisivave Iutaavave Saimonivave mwisama mwira qatanravu variarave. Mwira nruranravuvata mwaini variarave, tita. Mwitaa tivaqi viqata Iesusira nravunaasa mwirara qumina vaitive tiva seta, mwira qoririma mwatora. ");
INSERT INTO omw_a_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mwisa mwitaa huvaro Iesusiva mwisara tiqaro, Poropeti vaiti Kotira qua tiva ni variariva mwo mwatani uro variraro mwi mwatanaavama mwirara qamwateqaroma mwira nrutu tuaaheraanarove. Mwi vaitiva nai mwaatani variqaro nai nrura qata sapata variraro mwira nravunaava mwirara qumina mwaa mwatanaavaqaima variso tiva sero siama mwira nrutu tuaaheraanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mwitaa tiva sero nraase qoravano Iesusirara qumina vaitive tura saara Iesusiva sia so nai mwatusaqi nrora saiqa varaariva vahuvaro mwiva nriqa vusa pataqaatanaqaaqai nai sauqu vatovata suqema vura. ");
INSERT INTO omw_a_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mwira nravunaasa mwirara sia so tiri saahaqa hiarivave turara Iesusiva airi nraato tiqaro varura. Mwi mwatusaraqitairo Iesusiva tiviro vintante nrintante mwo mwatusa mwo mwatusa variqi viqaro nraase qora mwasaasa tiva niqiro vura. ");
INSERT INTO omw_a_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iesusiva nai nraaqiara nraarama sero taaratana taaratana titovata 12 mwinravusa mwona mwona vura. Mwiva mwisa titeqaro vaitiqitaita vaana titaivata qaqinani nritareta vuate tiro, mwiva mwisa kepusa niqaro qua mwitaama tiro: ");
INSERT INTO omw_a_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nénravu virera hiqatama siama mwo inraisa mwo inraisa vareta viraitita, aaraqaa sauru quru vare viraqaima vareta vuate. ");
INSERT INTO omw_a_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Siama sarave tuave munimave vareta vuate. Suqu nraavu mwiraqaima vara ututaate. Sia sioti taaratana ututaate. Kuaiqaqai utu vareta vuate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iesusiva mwi quara tiva sero mwaa quaravata tiqaro, Nénravu vivaro ta mwatanaavave iniara qamwateqaro ini vitairera, né nraavu kuaikuqiqai variqita vitama mwi mwatusara seta vuate. ");
INSERT INTO omw_a_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Né vivaro ta mwatanaasave sia ini qamwata nateta ini qua sia riarera utivera, nétaqaatai ntuverauma seta qaqira setama mwisa tiva nita tiqata, Naatiara nétama taqevarave, tiate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iesusiva mwitaa tiva sero titovata mwira nraaqiaranravuvano uro viti viri tiva nita tiqata, Uaqa hi aarara qaqira seta suqe hi aararaqaa vuate, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mwitaa tivaqi viqata vaiti vutaqi vaana varusa titovata qaqinani nritare vuvata airi vaiti nriqa vusa, mwisa qiataqaa vahavera qu nateqata suqema natovata so varura. ");
INSERT INTO omw_a_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mwitaa huvaro esaa mwi mwatanaava Iesusirara nai tiva mwi nai tiva mwi hi varuvarora tiro, Herotiva vuniaa vaitivano mwi mwatara Kariri mwataqaa ntaqaihi varuva, mwivavata Iesusira nrutu riora. Nraase qora hini husa Iesusirara mwitaama tita, Mwi vaitiva Ionivave. Ioniva nramari ni varu vaitiva qutu vuva qaiqaa tiviro nrue variso. Mwiva qaqi tiviro nrue variqarora tiroma nrora saiqa so vare variso, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hini husa mwitaa tuvata hini husa qaqao tita, Mwi vaitiva tiri haivaqava Iraisaava qovarama viso, tita. Mwitaa tuvata mwo husa Iesusirara tiqata, Haaru poropeti vaiti Kotira qua qovaramase varusa, Iesusiva mwisa votima seroma variso, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nraase qora Iesusirara mwitaa ti varuvaro Herotiva mwi quara riero tiqaro, Qike, mwi vaitiva nramari ni varu vaitivama variso. Né tiavaro mwira nrunta teqa sova Ioniva, mwivama qutu viraqitairo qaqi tiviro nrue variso. Mwiva qutu viraqitairo qaqi tiviro nrue variqarora tiroma, mwiva nrora saiqa so vare variso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Tauraa Herotiva nai qata Piripira nraata Herotinramarira varatero varuvaro Ioniva nri ntero airi nani Herotirara tiqaro, E ena qata nraata sia varaataarama varera hiaro, tuvaro mwira saara Herotiva nai nraata Herotinramarirara tu quara rieqaro mwiva naivano vaiti mwo titovaro Ionira ntavaaqavu sero rupaqiro uro karavuqi sora. ");
INSERT INTO omw_a_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sovaro Ioniva karavuqi varuvaro Herotira nraatavano Herotinramariva varuvaro Ioniva mwirara tu quava mwira raraqa tovaro Ionira rusarera utuvaro sia mwira rusaari aarava vahura. ");
INSERT INTO omw_a_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ioniva vaiti suqeva avuqavuma sero nrue varurara tiro, Herotiva mwirara rieqaro mwira nraatu aatu hiqaro sia mwira rusaate tiro. Mwitaa tiva sero Herotiva Ioniva ti varu quarara qamwateqarovata mwiva mwira quara taara nraato tura. ");
INSERT INTO omw_a_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mwitaamaqi vuvaro mwo enta Herotinramariva Ionira rusaari aarava so vahura. Mwi quara osaravano mwataamama vahiro. Herotiva nai mwato entava qovara huvaro mwi entaraqaa nrora vaiti sara nireraro mwisa nraarora. Mwiva ntaqu vaitisaqaa ntaqaihi varu vaitisave, airi inraisa vato vaitisave, mwiva mwisa nraarama sero sara niro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sara nuvata mwisa nre varuvaro Herotinramarira nraavuravano nrima mwisa ihi ntava natero. Mwiva ihi nte varuvata Herotivavata mwiva sara nrusavata mwi mwaraatara qamwata mwateta. Herotiva nai nraata nraavurara qamwatero mwirara tiqaro, Nara inraisarave i mwutusa vaiso? Ni tiva miraqe i mwiase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mwitaa tiva sero mwiva sauqu nriqiqaa vatero tiqaro, Ne quqaama tuqo. E nara inraisarave tiraqena ne i mwianirave. Mwata hini ne ntaqaihianirara tiraqena ne tusama sena i mwianirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Herotiva mwitaa tuvaro mwaraata mwiva veva ntero uro nai nrora sapara hiro tiqaro Nto, ne nara inraisarave tiariro ni mianarove? tiro. Mwitaa tuvaro mwira nrova tiqaro, Ioniva nramari ni vari vaitira mwira qiata miane tiane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mwira nrova mwitaa tuvaro mwira nraavuravano santero uro vuniaa vaiti Herotirara tiqaro, Qamwanrama sera Ioniva nramari ni vari vaitira nrunta teqa sera tanaaqaa varaqira nrima miane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mwaraata mwiva mwitaa tuvaro Herotira mwutusavano uaqa huvarovata mwiva vaasa sauqu nriqiqaa vatorara rieqaro, sara nrarerata nru vaitisaravata rieqaro tiqaro, Ne mwaraata mwirara tu quara nteqa saasorave, tiva sero ");
INSERT INTO omw_a_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","mwiva karavu vaitiqaa ntaqaihi varu vaitira mwo titero tiqaro, Ionira qiata qamwanrama sera varaqira nrima miane, tuvaro mwiva uro karavuqitairo mwira nrunta teqa sero ");
INSERT INTO omw_a_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mwiraqaatairo mwira qiata tanaaqaa vatero varaqiro nrima mwaraata mwira mwuvaro mwiva varero uro nai nrora mwura. ");
INSERT INTO omw_a_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mwitaama sovata Ionira nraaqiaranravuvano mwi quara rieta mwisa nrima Ionira mwavanta varaqita uro quntama sora. ");
INSERT INTO omw_a_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iesusiva nroraqama sero titovata vu vaitisa nrueta uro ntante nrima uairama vita Iesusira nraaqani variqata mwisa niari saiqa varoravata, niari nraase qora tiva nu quaravata, Iesusira tiva mwura. ");
INSERT INTO omw_a_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mwi entara nraase qora airivano Iesusira taqarerata vita nrita hi varuvarora tiro, Iesusivavata mwira nraaqiaranravuvata sia suqemase sara nreva vahuvata varura. Mwitaa huvaro Iesusiva tiqaro, Vivaqenravu uro qumina sata tetaraa variarata nénravu tesa hiate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Iesusiva mwitaa tiva sero mwinravusa vita varero votuqi mwaari ntero saareraqaama tero qumina sata varirerata vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mwiravusa vuvata airi nraase qoravano mwisa taqeta tiqata, Mwisa mate mwinima vivarave, tiva seta mwo mwatusa mwo mwatusaqitaita mwisa santeta nruka tosasataa mwataqaa vusa uro Iesusiva votuqima tero virera hunani mwisa nraante uro ntora. ");
INSERT INTO omw_a_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mwisa nraante uro ntovaro Iesusiva naatiara nrintero votuqitairo mwatani mwaavi ntero nraase qora airivano uairama vusa taqero mwisara po se tiva sero tiqaro, Qike, vaitivano sia mwisaqaa ntaqaihi varisata sipisipivano niariaraa nrue varia sipisipisa votima seta mwaa nraase qorasa api nrue variavo, tiro. Mwitaa tiva sero mwini variqaro Iesusiva qua mwasaasa mwisa tiva ni varura. ");
INSERT INTO omw_a_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Iesusiva tivaqiro vuvaro huari muani otuntuvata Iesusira nraaqiaranravuvano mwiva varunani uro nteta tiqata, Huarivano muani tuvi visaro mwaini qumina satave. ");
INSERT INTO omw_a_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","E nraase qora mwaasa titairata mwisa uro sara vahiani mwatusaraqi nrueqata sara soqaamase nraate. Mwisa sia sara ntuva vareta nriasave, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mwira nraaqiaranravu mwitaa tuvaro Iesusiva qaqao tiro, nétama mwisa sara niate, tiro. Tuvata mwisa Iesusira sapara hita tiqata, Te nrora munima 200 kinaa mwira setave sara vara seta mwisa nianarave? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mwitaa tuvaro Iesusiva mwinravusa sapara hiro tiqaro, Mpereti nataamave ntuva taavo? Né uro taqaate, tuvata mwisa uro taqeta nrima tiva mwita tiqata, Mpereti kyauquruvata tavusa taaratanavataqai ntuva taavo, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mwira nraaqiaranravu mwitaa tuvaro Iesusiva nraase qora tiva niro tiqaro, Né mwusau mwaa mwo sata mwo sata esaama mwatasaa vita variate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mwitaa tuvata mwisa mwo sata 100 nravu mwatasaa vita varuvata mwo sata 50 nravu mwatasaa vita varuvata mwitaamaqi vita esaa nraase qoravano mwatasaa vita varura. ");
INSERT INTO omw_a_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mwatasaa vita varuvaro Iesusiva mpereti hini sauqu mwiravuravata, tavusa taara mwitanavata, vara sero naavuni taqeqaro Kotirara suqemave tiva sero, mpereti nteqa sero nai nraaqiaranravu niro tiqaro, So né varaqita uro nivata mwisa nraate, tiva sero tavusa taara mwitanavata tusama sero nraase qora mwisa esaa nuvata ");
INSERT INTO omw_a_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","esaa mwisa visosama nrora. ");
INSERT INTO omw_a_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Visosama nrovata Iesusira nraaqiaranravu mwiraqaataita nraase qoravano mperetivata tavusavata nreqata viti vaati sora utu tuntu seta tua nrora ntutantutoraqi 12 nravu kuraama sora. ");
INSERT INTO omw_a_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mwi entara 5,000 vaiti airivano mwi sarara nrora. ");
INSERT INTO omw_a_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iesusiva mwisa sara niro mwiraqaatairo qamwanrama sero nai nraaqiaranravu titero tiqaro, Né nraante votuqi mwaarinte nrukaqaamate vutura qarahi hini Vetasaitaani vi varivaqenama ne nraase qora titaarita niari mwaatani vuate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mwitaa tuvata mwisa vuvaro Iesusiva verara taaqiqaa Kotirara aasara ntareraro viro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Iesusiva Kotirara aasara ntareraro vuvaro entama vuvata votuqi vusa nruka tavaara sata vi varuvaro Iesusiva nariaraa qaqinani variro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iesusiva mwini variqaro taqovaro toqavano mwisa virera tunatairo nriqaro votu raaqutaqiro vuvata votuqi varusa mwusaari tiqata nramari huvaqitaqi vura. Mwitaamaqita vuvaro qauma qataa hirera huvaro Iesusiva mwisa hunta sareraro nruka turuqaa nriro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Mwiva nriqaro mwisa nraatarase vuase tiro, utuvata mwisa taqovaro Iesusiva nruka turuqaa nri varuvata mwisa mwoqama sero nraatuqa tovata vaanave tiva seta, aatu hiqata oi aai ti varura. Mwisa oi aai ti varuvaro Iesusiva qamwanrama sero mwisara tiqaro, Kepusaqama seta variate. Nema nruqo. Sia aatu hiate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mwitaa tiva sero Iesusiva votuqi mwaari ntero mwisa sapata varuvaro toqavano taiqa viro tirema vahuvata mwisa qike tita, sauqu ntukikiraaqate variqata ");
INSERT INTO omw_a_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Iesusiva mpereti taaraqa airiqama sero nraase qora nunrara sia mwisa vu nraato ntapihuvata sia Iesusira osarara ntapihi seta riora. ");
INSERT INTO omw_a_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mwisa vutura hini vantara Kenesaretini uro nte mwaavi nteta votu rupate ");
INSERT INTO omw_a_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","mwataqaa virera huvata mwi mwatanaasa Iesusira ntapihi seta taqeta, So mwaa mwivave, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mwitaa tiva seta mwisa santeta uro vututai vurutaita nriqa vu nraase qorasa vitaqita uto Iesusiva variso tunani sora. ");
INSERT INTO omw_a_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iesusiva mwi mwataraqaa variqaro mwo mwatusa mwo mwatusa pata mwatusave, nrora mwatusave, vuta nraasoqi vahu mwatusarave, Iesusiva mwini nrue varuvata mwi mwatanaasa nriqa vusa vitaqita mwatusaqaa seta Iesusirara po se tita tiqata, Sove nriqa vi nraase qorasa i tuavaaqa vitiqaa sauqu tivarave? tuvaro Iesusiva sove tuvata esaa mwiraqaa sauqu tu so nraase qorasa suqemaqai vura. ");
INSERT INTO omw_a_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisi vaitinravuvata mwaara osara ti varu vaitisavata Iesusira taqarerata Ierusaremitaita nrima Iesusiva varunani uairama vita variqata ");
INSERT INTO omw_a_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","taqovata Iesusira nraaqiara mwonravuvano variqata Parisi vaiti mwisa qua mwaara osara qaqira seta sia sauqu hiqaraitita, sara nre varura. ");
INSERT INTO omw_a_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mwi entara Parisi vaitinravuvata esaa Iutia mwatanaasavata niari haivaqasa tiva to quara rieqata mwitaa mwitaama seqata mwisa niari sauqu hiqe varura. Mwisa sia sauqu hiqosa sia sara nrora. ");
INSERT INTO omw_a_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mwisa uro maaketiqi nrueta uro ntanteta nrima varita sia niari sauqu hiqama saraitita, sia sara nrora. Mwisa haivaqasa kaapu hiqe osararave, tanaa hiqe osararave, mwo osara mwo osara tiva nuvata mwisa riemwaqi viqata nrue varura. ");
INSERT INTO omw_a_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mwisa mwi quara riemwaqita nrue varusara tita, Parisi vaitinravuvata, mwaara osara ti varu vaitisavata, Iesusira sapara hita tiqata, Tiri haivaqasa qua tiva tora i nraaqiaranravuvano nteqa seta sia sauqu hiqaraitita, sara nre variavo. Naraqamave mwisa mwitaa hi variavo? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mwitaa tuvaro Iesusiva mwisa niari tiva niro tiqaro, Né unraqama seqata suqe saiqa vare variasave. Asaiaava haaru variqaro iniara avuqavuma sero qara ntuva torave. Kotiva mwira saahaqa huvaro Asaiaava Kotiva mwitaama tiso tiro: Mwaa mwatanaasa nroqitaiqai ni nrutu tuaahere variavaro mwisa mwutusavano sia niara vaiso. ");
INSERT INTO omw_a_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mwisa mwaara tiqatama mwisa niari haivaqasa quaqai tiva niqata mwisa quminama ni nrutu tuaahere variavo, tura. (Ais 29:13) Asaiaava mwitaama sero qara ntuva torave. ");
INSERT INTO omw_a_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kotiva iniara mwitaa mwitaa hiate tu quara né mwi quara qaqira setama vaitivano tiva taa quaraqaima riemwaqita nrue variarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mwitaa tiva sero Iesusiva mwisara qaiqaa tiqaro, So suqema hiavo. Kotiva mwitaa mwitaa hiate tu quara né mwi quara qoririma seta ini haivaqasa tiva to quaraqai riemwaqita vi variasave. ");
INSERT INTO omw_a_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesiva Kotiva tiva to quara riero iniara tiqaro, Ena nrosa qosa nrutu tuaahera nataane. Nai nrosa qosara uaqa hiani quara ti variani vaitira rusaate, turave. ");
INSERT INTO omw_a_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kotiva mwitaa tiva to quava vaisata né mwi quara sia riaraitita, néta riemwase né tiqata, vaitivano nai nrosa qosara tiqaro, Ne nítana saahaqa hirera tu munimara sia nítana niraitina, Kotirani vatarerave, tirera, ");
INSERT INTO omw_a_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","mwi vaitiva soma nai nrosa qosa qaqira sero sia mwitanasaqaa ntaqaihiqiro vuanarove, tiarave. ");
INSERT INTO omw_a_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Né unra qua mwitaa tiqatama Kotira qua nteqa setama níta haivaqasa tiva nu quara mwiraqaima nraase qora tiva ni variavo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesusiva nraase qora uairama vusa nraarama sero mwisa tiva niro tiqaro, Né esaa ne tirera hiani quara suqema seta rieqatama variate. ");
INSERT INTO omw_a_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Saravano qaqitairo vaiti vutaqi vi inraisava sia vaiti uaqama mwataisaro Kotiva mwirara mwiva uaqa hi vaitirave tianarove. Vaiti vutaqitairo qovara hi inraisava vaiti vara sero uaqama sairave. ");
INSERT INTO omw_a_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ini vu nraato suqe vu nraato vahirera, mwi quara osara ntapihi seta riaate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesusiva mwitaa tiva sero nraase qora uairama vusa mwini sero nraavuqi uro varuvata mwira nraaqiaranravuvano Iesusiva vaasa tu quara osarara mwira sapara huvaro ");
INSERT INTO omw_a_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iesusiva tiqaro, Qike, ini vu nraatovata mwo? Ini vu nraatovano siave ntapihi riaiso? Saravano qaqitairo vaiti vutaqi vi inraisava sia so vaiti uaqama mwataisaro Kotiva mwirara mwiva uaqa hi vaitivave, tianaro. ");
INSERT INTO omw_a_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Vaitivano sara nraisaro sia mwi sarava mwira vu nraatoqive mwutusaqive viraitiro, qaqi vaiti raraqi uto vahiro so mwiqitairo qaqinani tuvitarairave, tiro. Iesusiva mwi quara tiva niqaro mwi quaraqotairo nraase qoravano esaa sara so nraivaro Kotiva siama iniara uaqaa hia vaitisave tianarove, tura. ");
INSERT INTO omw_a_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iesusiva mwitaa tiva sero qua mwo tiqaro, Vu nraatoqinaa inraisavano, mwutusaqinaa inraisavano, mwi inraisava mwi inraisava vaiti uaqama saisaro Kotiva mwi vaitirara uaqa hi vaitirave tirave. ");
INSERT INTO omw_a_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Vaiti vu nraato mwutusaqitairo uaqa hi saiqara utuariva nriso. Vaitivano nraasevata api nruaariva vu nraatoqitairo nriso. Muara varaarivavata mwiqitairo nriso. Vaiti ru saarivavata mwiqitairo nriso. Mwora nraata vaatiara nruaarivavata mwiqitairo nriso. ");
INSERT INTO omw_a_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Mwova hi inraisarara mwutusa ntiraro varaariva vu nraatoqitairo nriso. Airi munimave mwo inraisave vaterovata qaiqaa saatavataqai vararerave ti variariva vu nraato tuaraqitairo nriso. Unra qua tiarivave, sia nai mwavantaqaa suqema ntuva quarivave, mwova hi inraisarara vairiqa hiarivave, mwora nrutu vara mwataniqa hiqaro tiarivave, né nrora vaitive tiarivave, api nruaaniraraqai riemwaqi quarivave, ");
INSERT INTO omw_a_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","esaa mwi inraisava vaiti vu nraato mwutusaqitairo nri ntero vaiti uaqama saisaro Kotiva mwira saara mwirara uaqa hi vaitirave tianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesusiva mwitaa tiva sero mwi mwatara sero uro mwo mwatani Taiaavata Saitonivata vahu mwataraqaa varurama. Mwiva uro variro sia mwovano ni taqaarive tiva sero, nraavu mwoqi varuvaro nraase mwovano mwiva varura vaasa ntapihi sora. ");
INSERT INTO omw_a_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ntapihi sero nraase mwira nraavuraqi vaanavano varu nraaseva Iesusiva varuraqi nrintero Iesusira nraaqani mwira suqusata uto ntiro varura. ");
INSERT INTO omw_a_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mwi nraaseva nai mwo mwatanaava sia Iutaa mwatanaava, mwiva Siria mwata Ponisiaqi mwatatova varura. Mwi nraaseva Iesusirara po se tiro tiqaro, Ni naavuraqitaira vaana titairaro qaqinani nritaraarive, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nraase mwiva mwitaa tuvaro Iesusiva nai tiva mwiro mwo quaqaa ntuva sero tiqaro, Qaqao, ne nraaqiara nraante sara mwirerave. Ne nraaqiara sara vara sena vairi niasorave, tiro. (Mwi quara osara mwataamama vahiro: Iesusiva tiqaro, Sai ne Iutaa mwatanaasa nraante saahaqa hiase. Ne mwo mwatanaasa nraante saahaqa hiasorave, tiro.) ");
INSERT INTO omw_a_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tuvaro nraase mwiva tiqaro, Nrorao, e quqaa tiararovata, vairivano tainta mwevaqi variqaro nraaqiaravano sara viti vaati nreqata saara nrairave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nraase mwiva mwitaa tuvaro Iesusiva tiqaro, Suqema tira hiaro. E mwitaa tiaranara tina, ne vaana mwira titauqaro qaqinani nritaraiso. I nraavuravano so variso. So ena mwaatani vuane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iesusiva mwitaa tuvaro nraase mwiva nai mwaatani vuva nrintero taqovaro vaanavano mwira nraavuraqitairo nritarero vuvaro mwi qiaatarava taintaqaa suqema vaite varurama. ");
INSERT INTO omw_a_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesusiva Taiaani variro mwiraqaatairo Saitoninivata uro variro mwitairo vintantero sauqurutana mwatusa vahunanivata vintantero mwitairo nruka nramari Karirini uto ntora. ");
INSERT INTO omw_a_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mwini uto varuvata mwo husa vaiti mwo vitaqita uro Iesusiva varunani sora. Mwira nraato tita vuvaro quavata sia ntapihi sero tu vaitira vitaqita uro Iesusiva varunani seta Iesusirara po se tita tiqata, Ena sauqu mwiraqaa vatairaro suqema vuarive, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mwisa mwitaa tuvaro Iesusiva nraase qoraqitairo vaiti mwira vitero uro niariaraatana variqata Iesusiva nai sauqu vukahiqo vaiti mwira nraatoqi veta vatero quaantu vihi sero mwira mwaaqiriqaa vatero ");
INSERT INTO omw_a_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","naavuni taqeqaro mwira ua huvaro po tiva sero nai quaqitairo tiqaro, Epatave—Qatua vuane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mwitaa tuvaro mwira nraato tita vuva qamwanrama qatua vuvaro so riero varuvaro mwira mwaaqirivanovata so vahuvaro qua ntapihi sero ti varura. ");
INSERT INTO omw_a_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mwitaa huvaro Iesusiva mwira nravunaasara kepusaqama sero tiqaro, Mwaa inraisara taqaara sia mwosa tiva niate, tiro. Iesusiva mwitaa tuvata mwisa Iesusira qua sia riaraitita, mwi quara viti viri tiva niqita vura. ");
INSERT INTO omw_a_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mwisa viti viri mwi quara tiva niqi vuvata mwi quara riosa qike tita, sauqu ntukikiraaqateta tiqata, Mwiva esaa saiqa suqema sero vare varivave. Mwiva nraato tita vuasa suqema saisata so riaarave. Mwiva sia qua tiasa suqema saisata so qua ti variarave, tura. ");
INSERT INTO omw_a_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mwi entara nraase qora airi saatavano Iesusira taqarerata nrima uairama vita varura. Mwisa sia sara mwoqanivata ntuva taraitita, qaqi varuvaro Iesusiva nai nraaqiaranravu nraarama sero tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ne nraase qora mwaa variasara po tuqo. Mwisa taaramwo enta ni vatama seta variqi viqata niari sara nrava taiqa saavo. ");
INSERT INTO omw_a_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ne mwisa niari mwaatani titaarita mwisa nraataa hiro vuqitairo nrivu nrivuhirata aaraqaa uto ntivorave. Mwo hiasa niarataitavata nriasave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Iesusiva mwitaa tuvata mwira nraaqiara mwisa qaqao tita, Mwaa qumina mwusauqaave. Taitaitave sara varaanarave, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tuvaro Iesusiva mwisa sapara hiro, Nénravu nataama mperetive ntuva taavo? tuvata mwisa tiqata, Mpereti 7 nravu ntuva tauro, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mwisa mwitaa tuvaro Iesusiva nraase qora uairama usara tiqaro, Mwatasata mwatasaa vuate, tiva sero mpereti 7 nravu vara sero Kotirara suqeve tiva sero, mwi sarara nteqa sero nai nraaqiaranravu niro nraase qora niate, tiro. Tuvata mwisa nraase qora uairama vusa nura. ");
INSERT INTO omw_a_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nuvaro Iesusiva tavusavata vatora vara sero Kotirara suqeve tiva sero tiqaro, Tavusavata tusama seta niate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mwitaa tuvata mwisa nuvata nraase qoravano soqama seta nrora. So nreta viti vaati sora mwira nraaqiaranravuvano tuntu seta ntutantutoraqi 7 nravu kuraama sora. ");
INSERT INTO omw_a_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mwi entara 4,000 nraase qora airivano mwi sarara so nrora. ");
INSERT INTO omw_a_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","So mwiraqaatairo Iesusiva nraase qora titero mwiva nai nraaqiaranravu sapata votuqi mwaari ntero nruka nramari qara varero Damanutaa mwatani viro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Iesusiva Damanutaa mwatani vuva uro ntovata Parisi vaitinravu Iesusiva hunani nri nteta Iesusira irorama mwatarerata mwira mwataara hiqata taqaare tiva seta tiqata, E nrora saiqa tiri vuqaa varairaqeta te taqe iara quqaama Kotiva i titaiso tiare, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mwisa mwitaa tuvaro Iesusira ua huvaro po tiro tiqaro, Mate mwaa varia nraase qorasa naraqamave tiqata nrora saiqa tiri tiva timwiraqe te i osarara quqaave tiare ti variavo? Ne quqaa tianira riaate. Mate mwaa entara variasa varivaqena ne sia nena osara mwisa tiva niqana nrora saiqa vararerave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Iesusiva mwitaa tiva sero qaqira mwisa mwini sero votuqi mwaarintero nrukaqaama tero vutura hini tosaniara viro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nrukaqaa vi varuvata Iesusira nraaqiaranravuvano mpereti tauru seta sia vararaitita, kuaiqaqai votuqi vatovaro ");
INSERT INTO omw_a_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesusiva mwo quaqaa ntuva sero tiqaro, (Taupatai inraisava mperetiqi visaro mperetivano sotairave.) Parisivanovata Herotivavata taupataira votima seta variavo. Né mwisa nraatu aatu hiqata variate. ");
INSERT INTO omw_a_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mwitaa huvata mwira nraaqiaranravuvano Iesusiva mwo quaqaa ntuva sero tu quara sia ntapihiraitita, nai tiva mwi nai tiva mwi hita tiqata, Nara quave tiso? Mpereti sia varaunara mwirara rieqarove mwitaa tiso? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mwitaa ti varuvaro Iesusiva mwisa ti varu quara riero tiqaro, Né naraqamave mpereti sia varaara saara airi qua ti variavo? Siave ini vu nraatovano ntapihi visata ntapihi seta riaavo? Ini nraato tita visatave né sia ntapihi seta riaavo? ");
INSERT INTO omw_a_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Né vu nraato vataasa né siave ntapihi seta rieta taqaavo? Né ne saiqa varaurara tauruve saavo? ");
INSERT INTO omw_a_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ne 5,000 nraase qora mpereti sauquru nteqa sena niavata nreta viti vaati sora nataama tua né mwi entara kuraama sorave? tiro. Iesusiva mwitaa tuvata mwisa tiqata, So te mwi entara tua 12 nravu kuraama saavanarave, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mwisa mwitaa tuvaro Iesusiva qaiqaa tiqaro, So ne 4,000 nraase qora mpereti 7 nravu niavata nreta viti vaati sora nataama tua né mwi entara kuraama sorave? tiro. Tuvata mwisa tiqata, So te tua 7 nravu mwi entara kuraama saavanarave, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mwisa mwitaa tuvaro Iesusiva tiqaro, (Né ne mwi saiqara varaurara ntapihi seta riaataara vaisata né tauru seta mpereti kuaiqa vare nriarara airi qua ti variavo.) Ini vu nraato ntapihi virata ni osarara riaataara vaisata né nataamaqitave ni osarara sia ntapihi riaavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesusiva nai nraaqiaranravu sapata vusa Vetasaitaani uro nteta mwini varuvata mwo husa vu qipavu vaitira vita vareta Iesusiva varunani uro seta Iesusirara po tita tiqata, vaiti mwaaqaa ena sauqu vatairaro so taqaarive, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mwitaa tuvaro Iesusiva vu qipavu vaitira sauqu tu varero vitaqiro uro mwatusa mwaaqani sero mwini variqaro mwira vuqaa taara vihi sero nai sauqu mwiraqaa vatero mwira sapara hiro tiqaro, Mwo inraisa sove taqera hiaro? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Iesusiva mwitaa tuvaro vaiti mwira vu qauma ntapairi virera huvaro mwiva vutu taqero tiqaro, Ne vaiti taqe varuqata mwisa satari nraantantama setama nrue variavo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mwitaa tuvaro Iesusiva qaiqaa nai sauqu mwira vuqaa vatovaro mwira vuvano ntapairi vuvaro mwiva suqema sero esaa inraisa taqero. ");
INSERT INTO omw_a_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","vaiti mwiva ntapihi sero taqovaro Iesusiva mwira titero tiqaro, Sia mwi mwatusaraqi nrima ntantera viraitira, ena mwaatani vuane, tiro. Turama. ");
INSERT INTO omw_a_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mwiraqaatairo Iesusiva nai nraaqiaranravuvata uro Sisariaa Piripai qaumato vahu mwatusaraqiara viro. Aaraqaa viqaro nai nraaqiaranravu sapara hiro tiqaro, Nraase qoravano niara tavave tiva seqatave ti variavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mwitaa tuvata mwisa tiqata, Mwo hiasa iara Ioniva nramari ni varivave tiavata, mwo hiasa iara mwiva tiri haivaqava Iraisaavave ti variavata, mwo hiasa iara mwiva tiri haivaqava poropeti vaiti mwovano qaiqaa qovarama viro nrue variso ti variavo, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mwisa mwitaa tuvaro Iesusiva mwisa sapara hiro tiqaro, So nénravu mwo? Né niara ta vaitiva varisove tiavo? tiro. Mwitaa tuvaro Pitaava tiqaro, E Karaisiva, mesaiaa vaitivanove. E Kotiva titai vaitiva variaro, tiva seqatama te varuro, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mwitaa tuvaro Iesusiva mwinravusara kepusaqama sero tiqaro, Siavatama mwi quara mwosa tiva niate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mwitaa tiva sero Iesusiva qua hoqarama tero vutu sero nai nraaqiaranravu mwiva naatiara nai qutuanirara tiva niro tiqaro, Ne mwatani mwatatai nraaqiarava variqana nriqa vuani inraisara airi vararerave. Nrora vaitivanovata, Kotira saiqa vara mwate varia vaitisa vuniaa vaitivanovata, niara qumina vaitive tiva seta, ni qoririma matevarave. Mwisa mwitaa hiqatama ni ru saivaqena ne qutu vina taaramwo enta varina qaiqaa qaqi tivuanirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesusiva mwi quara vutu sero qoqaa tiva nuvaro Pitaava Iesusira vita uhini sero qaqao tiro, Qora quama tira hiaro, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Iesusiva tuqataa viro nai nraaqiaranravu taqero Pitaara irora hiro tiqaro, Saataanio, niarasata vuane. Sia ni vuqaa variane. E sia Kotiva riaintema sera riaaro. E qumina vaitivano riaintema sera rie variaro, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iesusiva mwitaa tiva sero nraase qora uairama vusavata nai nraaqiaranravuvata nraarama sero tiva niro tiqaro, Ni vataqiro nriari vaitiva mwiva nai mwutusa vahianira qaqira sero vaiti ruseta hirite satarira vara qu varero ni naatiara nrianarove. ");
INSERT INTO omw_a_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nai mwatani qaqi varianiraraqai nroraqama sero riaariva, mwi vaitiva esaarama qutu vuanarove. Vaitivano niara riemwaqiro viqaro ni saiqa varareraro ni qua riemwaqiro viqaro uro qutu vuariva, mwi vaitiva esaa enta qaqi variqiro vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Vaitivano mwatani variqiro viqaro esaa inraisa uairama sero mwiraqaatairo qutu viraro mwiva uairama taani inraisava nataama serove mwira saahaqa hianarove? Sia mwi inraisava mwira so saahaqa hianarove. ");
INSERT INTO omw_a_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Vaitivano qutu viro nara soqaave mwinro qaiqaa qaqi variqiro vuanarove? Sia mwiva mwi entara so soqaa utu sero qaiqaa qaqi variqiro vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mwaa entara mwatani varia nraase qorasa uaqa hi saiqara utiqatama Kotira qaqira saavo. Vaiti mwovano niaravata ni quaravata mwoqama sero sauruariva, mwi vaitiva variraqe ne mwatani mwatatai nraaqiarava variqana naatiara ne tuvuani entaraqaa naivata saurira inraisa vara mwianirave. Mwi entara ni qora kepusa osaravano niqaatairo itero ntuvaahe variraqena naavuniaasa vatama sena tuvuanirave. Mwi entara ne mwi vaitira naivata saurira inraisa vara mwianirave, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iesusiva mwitaa tiva sero tiqaro, Ne quqaa tianira riaate. Vaiti mwonravu mwaini mate mwaa tivita variasa sia qumina qutu vivarave. Kotiva nraase qoraqaa kepusaqama sero ntaqaihiari entava nrianira mwisa taqeta qutu vivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iesusiva mwitaa tuvaro 6 enta nritarovaro mwiva Pitaaravata, Semisiravata, Ioniravata, mwiravusaqai vita varero taaqi nroraqaa niariaraa varirerata vita. Mwini uro varuvaro mwisa vuqaa Iesusira mwavantavano suqu viro vahuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","mwira tuavaaqavanovata mwoqama sero itero tahuqi varura. Siama so vaiti mwovano hiqama tairaro mwitaama sero tahuqu vuanaro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mwitaama sero mwira mwavantavano suqu viro vahuvata mwira nraaqiara taaramwonravuvano variqata taqovata Iraisaasa Mosesisa mwisa haivaqasatana qovarama vita variqata Iesusira vatama seta qua ti varura. ");
INSERT INTO omw_a_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mwitanasa Iesusira vatama seta qua ti varuvaro Pitaava Iesusirara tiqaro, Mwaara ti variara vaitio, suqemama tirenravu i vatama seta mwaini nrurasa varuro. E sove tirera, te haraara nraavu taaramwonravu iara mwo, Mosesirara mwo, Iraisaarara mwoma seta hoqa nataare, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mwisa mwoqama sero nraatuqa tovata varuvarora tiro, Pitaava nara quave tianirave tiro, mwi quara turama. ");
INSERT INTO omw_a_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mwitaa tuvaro tonavuvano qovara hiro mwisaqaa ntuvaqu sovaro quavano tonamwuqitairo tiqaro, Mwaa ni maaqu mwirara ni mwutusa nti variva variso. Nénravu mwira qua riaate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mwitaa tuvata mwira nraaqiaranravuvano qamwanramase tuqataaqata hiqata taqovaro sia mwovanovata Iesusira nraaqani varuvaro Iesusivaqai nariaraa varura. ");
INSERT INTO omw_a_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mwitaa huvata mwisa taaqi mwiraqaataita tuvi varuvaro Iesusiva mwinravusara kepusaqama sero tiqaro, Mateqaa taqaa inraisarara sia mwosa qamwanrama seta tiva niate. Ne mwatani mwatatai nraaqiarava ne naatiara qutu vina qaiqaa qaqi tivina varianiraqaataita né soma tiva niqita vivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mwitaa tuvata Iesusiva tuntema seta sia mwosavata tiva ninraitita, niariaqai nai tiva mwi nai tiva mwi hita tiqata, Iesusiva nai qaiqaa tivuanirara tira nataa hi quarave tiso? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mwitaa tiva seta mwisa Iesusira sapara hita tiqata, Mwaara osara tiva ni varia vaitisa tiri tiva timwita tiarave. Iraisaava tiri haivaqava mwiva nraante qovarama viro nri ntaanarove, ti variarave. Naraqamave mwisa mwitaa ti variavo? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mwisa mwitaa tuvaro Iesusiva tiva niro tiqaro, So mwisa quqaa ti variarave. Iraisaava nraante esaa inraisa ntapihi sero tequama tareraro nriarivama variso. Ni mwatani mwatatai nraaqiarara mwo? Nara qua niara qara ntuva tova vahirave? Niara mwiva airi nriqa vuani inraisara varaqiro virata mwiraqaataita mwisa mwira qoririma mwatetama mwirara qumina vaitive tivarave tiro, qara ntuva torave. ");
INSERT INTO omw_a_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","So ne iniara tiqana Iraisaava vaasa nrima varurarama tuqo. Mwiva nrima varuvata vaiti mwonravuvano mwira niari sasa huntema seta mwira uaqama mwatorave. Kotira vukuqi qara ntuva tova tiqaro, Naatiara mwira mwitaa hirave tura mwivau mwira mwitaa hurave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mwitaa tiva sero Iesusiva nai nraaqiara hininravu sonani uto taqovata nraase qora airivano uairama vita varuvata mwaara osara ti varu vaitisa mwini variqata Iesusira nraaqiaranravu sapata irora hi varura. ");
INSERT INTO omw_a_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mwisa uto ntovata mwini uairama vita varusa qamwanrama seta Iesusira taqeta nriharama vita santeta uro mwira qua mwantovaro ");
INSERT INTO omw_a_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesusiva nai nraaqiara hini mwinravusa sapara hiro tiqaro, Nara inraisa saarave né mwisa sapata irora hi variavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mwitaa tuvaro nraase qora vutaqitairo vaiti mwovano mwira tiva mwiro tiqaro, Mwaara ti variara vaitio, vaanavano ni maaqu vutaqi varisaro mwiva sia so qua tisanara tina, ne e hianarani vitena nruqo. ");
INSERT INTO omw_a_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Vaanavano ni maaqu ntavaaqavu sero mwira mwataqaa tuta saisaro mwira nroqitairo taaraparavano nrisaro nai vai kutisaro esaa mwira mwavantavano ntapihi viro kepusaqama vivihirave. Ne i nraaqiarara vaana titaivaro nritarero vuarive tuqata mwisa mwitaa hiare tiavaro vaanavano sia nritare virave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Vaiti mwiva mwitaa tuvaro Iesusiva mwi quara riero tiqaro, Né mwaa entara varia nraase qorasa Kotirara qumimaqama seta sia mwirara riaavo. Qike, né ni pupohaira uti variavana ne nataama nanive nkyi sapata varianirave? Ne nataama entave variqana ini saahaqa hianirave? So nraaqiara mwira vita vareta mwaini nriate, ");
INSERT INTO omw_a_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","tuvata vite nruvaro vaanavano Iesusira taqero nraaqiara mwira vara mwataqaa tuta sovaro tuqataaqata hi varuvaro mwira mwavanta ntirintiri hi varuvaro taaraparavano mwira nroqitairo mwo uti varura. ");
INSERT INTO omw_a_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mwitaa hi varuvaro Iesusiva mwira qora sapara hiro tiqaro, Taire hoqarama serove mwitaa iso? tiro. Mwitaa tuvaro mwiva tiqaro, Nraaqiara pataru varisaro mwitaamaqiro virave. ");
INSERT INTO omw_a_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vaanavano mwira rusaase tiro, mwira vara tiaqive nramariqive tuta sairave. E tiri so saahaqa hirava varirera, tiriara po tiqara tiri saahaqa hiane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Mwitaa tuvaro Iesusiva qaqao tiro, E tiqara, E so tiri saahaqa hiravave variaro tianarave. E siave ntapihira hiaro? Kotirara kepusaqama sero riaariva esaa saiqa so varaanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tuvaro nraaqiara mwira qova qamwanrama sero tiqaro, So ne Kotirara riemwaqina vuva siama soqa iso. Evata ni saahaqa hiraqena ne Kotirara kepusaqamase riemwaqina vuase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mwitaa tuvaro Iesusiva taqovata nraase qora uairama vusa itai itai vaini nruvaro Iesusiva vaana irora hiro tiqaro, E sia qua tiara vaanavave. E nraatora hiara vaanavave. E nraaqiara mwiqitaira nritarera vuane. Sia qaiqaavata nraaqiara mwiraqi viqetera variane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mwitaa tuvaro vaana mwiva nroraqama sero aasara ntero nraaqiara mwira vara ntuqutuvaro ntirintirima sero mwiva qutu vusa nraantantamwa sero ntuva viro vahuvata nraase qoravano tiqatama, Mwiva qutuma viso, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tuvaro Iesusiva mwira sauquqaa tu varero mwira vara mwaaviarama sovaro so qaqi tiviro varura. ");
INSERT INTO omw_a_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nraaqiara mwiva so qaqi tiviro varuvaro Iesusiva mwiraqaatairo uro nraavuqi varuvata mwira nraaqiaranravuvano uro mwira tiremase nariaraa sapara hita tiqata, Te vaana mwira titauraro sia nritarero virave. Naraqamave te sia so mwitaa huro? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mwisa mwitaa tuvaro Iesusiva tiqaro, Mwitaa hiani vaanara sia so qaqi titaivaro nritarero vuanarove. Kotirara aasara nteqatama titaivaro so nritarero vuanarove, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Mwiraqaatairo Iesusiva nai nraaqiaranravu sapata mwi mwatara seta Karirini vura. Mwini viqaro qua ntapihi sero nai nraaqiaranravu tiva niariva vahuvarora tiro, mwovano te vuanara huaama sero taqaaso tiro uqetase titero vura. Iesusiva nai nraaqiaranravu tiva niro tiqaro, Mwovano ni mwatani mwatatai nraaqiarara qovarama sairata ni ntavaaqavuqita uro vaiti sauquqi saivata ni ru saivaqena qutu vina taaramwo enta vari senama qaiqaa qaqi tivuanirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iesusiva mwitaa tuvata mwira nraaqiaranravuvano mwi quara osara sia ntapihi riaraitita, mwiva qua tura nraatu aatu hiqata sia mwi quara osarara sapara hura. ");
INSERT INTO omw_a_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mwiravusa vusa Kapeniaani uro ntovaro Iesusiva nraavuqi uro variqaro nai nraaqiara mwisa sapara hiro tiqaro, Nénravu aarana nriqata nara qua tiva setave irora hiavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mwitaa tuvata mwisa sia qua tiraitita, tirema varura. Mwiravusa aarana nriqata mwitaama tita, Tavave tirinravuqitairo nroraqama viro vuniaa vaitivano varianarove? tura. Mwitaa turara tita, mwisa sauriqata sia Iesusira tiva mwita. ");
INSERT INTO omw_a_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mwiravusa sia qua tuvaro Iesusiva mwatasaa viro mwisa nraarama sero tiva niro tiqaro, Sai ne nroraqama vuani vaitira osara ini tiva niase. Vaiti mwovano nroraqama vuataa hiariva siama vuni uro variqaro nroraqama vuanarove. Mwiva nroraqama vuataa hiraro naatiarani variqaro esaa nraase qora saiqa vaiti variarivama nroraqama vuanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iesusiva mwitaa tiva sero nraaqiara pataru vita sero mwisa vuqaa vatero mwira avuhu sero tutero tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","vaiti mwovano niara rieqaro nraaqiara mwataa hianirara qamwateqaro suqema mwataariva mwiva nivatama mwitaama mataanarove. Mwiva mwitaa hiqaroma Kotiva ni titairavatama qamwata mwataanarove, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Iesusiva mwi quara tuvaro Ioniva tiqaro, Mwaara ti variara vaitio, te taqauraro vaiti mwovano i nrutu nteqaro vaana tite varirave. Mwi vaitiva sia tirivata i vataqiro nrue variva mwitaa ihatara tita, te mwirara eqaane tiva seta, mwira antua tauro, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mwitaa tuvaro Iesusiva qaqao tiro, Sia mwi vaitira antuaate. Mwovano ni nrutu nteqaro nrora saiqa varero mwiraqaatairo mwiva sia qamwanrama sero niara uaqa hi quara tianarove. ");
INSERT INTO omw_a_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mwovano sia tiri nravutaaqa hiariva varirera, mwi vaitiva tiri nravunaavama varianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ne tianira riaate. Ini nramari nraataa hirata varivaro mwovano iniara Iesusira nraaqiarave tiva sero, nramari ini niani vaitiva variraro Kotiva sia mwira tauru saraitiro, mwira soqaa suqema sero mwianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Iesusiva mwitaa tiva sero nraaqiara pataru vaasa avuhu sero tutorara tiqaro, Nraaqiara mwaa voti hiariva ni qua riaariva variraro vaiti mwovano nri ntero uaqa hi aarara mwira nraamwutairera, mwira saara mwi vaitiraqaa qua nroraqama sero vahianarove. Vaiti mwira nruntaqi ori nrora saantaru sero nrukaqi tuto saivaro mwi vaitiva sia nraaqiara pata mwira uaqa hi aarara nraamwutaataarave. ");
INSERT INTO omw_a_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mwi quara rieqarama i sauqu hinivano uaqa hi saiqara uti varirera, mwira teqa sera saane. Mwiraqaataira sauqu kuaiqaqai vahiariva soma naavuni vira qaqi varinarave. E sauqu taaratana vahiariva uaqa hi saiqara uti variraro i tia iteqaro sia qipaaniraqi tuta saasorave. ");
INSERT INTO omw_a_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mwi mwataraqi imwivano qutu vuani mwavantara qaqiqai nravaqiro vi varianarove. Tiavano iteqaro siama qipa vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","I suqu hinivano uaqa hi saiqara uti varirera, mwira teqa sera saane. Mwiraqaataira suqu kuaiqaqai vahiariva soma naavuni vira qaqi varinarave. E suqu taaratana vahiariva variraro i tia nroraqama sero itaaniraqi tuta saasorave. ");
INSERT INTO omw_a_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mwi mwataraqi imwivano qutu vuani mwavantara qaqiqai nravaqiro vi varianarove. Tiavano iteqaro siama qipa vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","I vu hinivano uaqa hi saiqara utirera, vauru saane. E vu kuaiqaqai vahiariva soma Kotiva ntaqaihi mwatusaraqi vira qaqi variqira vinarave. I vu taaratana vahiariva uaqa hi saiqara utuqira viraro i tia nroraqi tuto saasorave. ");
INSERT INTO omw_a_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mwi mwataraqi imwivano qutu vuani mwavantara qaqiqai nravaqiro vi varianarove. Tiavano iteqaro siama qipa vuanarove. (Ais 66:24) ");
INSERT INTO omw_a_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Hore aatai ntema sero tiaqotairo esaa nraase qora aataanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Hore suqe inraisave. Horevano uaqama viro sia qiasaa hirera, siama so qaiqaa utu sairaro qiasaa hianarove. So né hore suqera votima seta varivaro ini mwutusa qihaasa hirata nariara nariara suqe hiqata variate, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","So Iesusiva mwi mwatara sero Iutiaani vuva uro Sotaani nramari qarero vutura hini tosani vura. Iesusiva uro varuvata qaiqaa nraase qora airivano mwiva varunani uairama vita varuvaro Iesusiva nauqaa hunte qaiqaa mwasaasa mwisa tiva ni varura. ");
INSERT INTO omw_a_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Iesusiva mwini varuvata Parisi vaitinravu mwiva varunani uro nteta Iesusiva api qua tiarive tita, mwisa mwo qua Iesusira sapara hita tiqata, Sove vaitivano nai nraata qaqira saanarove? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tuvaro Iesusiva niari sapara hiro tiqaro, Haaru ini haivaqava Mosesiva nara quave iniara mwitaa mwitaa hiate tiqaro tiva torave? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iesusiva mwitaa tuvata mwinravusa tiqata, Mosesiva mwataa tiva torave: vaiti mwovano nai nraata qaqira sareraro hiqaro qara mwo ntuva sero nai nraata mwinro tiqaro, So i qaqira sauqo, tiva seroma titaananrove, turave. Mosesiva qua mwitaama sero tiva torave, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mwitaa tuvaro Iesusiva tiqaro, Mosesiva variqaro taqovaro ini haivaqasavara mwutusavano kepusaqa huvata sia mwisa Kotirara riorave. Mwitaa hi varuvarora tiro, Mosesiva mwi quara tiva torave. ");
INSERT INTO omw_a_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","7","Tauraaqama sero sia mwitaama vahurave. Tauraa Kotiva naavuvata mwatavata utu sero vatero tiqaro, Ne vaitivata nraasevata utu sena vataurara tiro, vaitivano nai nrosa qosa sero nai nraatantiri ntaaqau vita mwitana kuaa mwavanta votima seta varivarave. ");
INSERT INTO omw_a_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Mwitana sia mwo mwavanta mwo mwavanta variraitita, mwitana kuaa mwavantaqaima varivarave, turave. ");
INSERT INTO omw_a_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kotiva naivano vaativata nraatavata vara kuaaqaa ntaaqau tairara tiro, sia mwovano mwitanasa tusama saarive, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Iesusiva mwitaa tiva sero nraavuqi uro varuvata mwira nraaqiaranravu Iesusira mwi quara osarara sapara huvaro ");
INSERT INTO omw_a_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iesusiva mwinravusa tiva niro tiqaro, vaiti mwovano nai nraata qaqira sero mwo nraase varaariva, mwi vaitiva qaraaha nraasentiri nrueqaroma muaraqama seroma mwisantiri nruaananrove. ");
INSERT INTO omw_a_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mwira votima sero nraasevano nai vaati qaqira sero qaraaha vaiti varaariva, mwi nraasevavata qaraaha qoraisi mwisantiri nrueqaroma muaraqama sero nruaananrove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iesusiva varuvata nraase qora mwisa niari nraaqiara vita vareta Iesusiva nai sauqu mwisaqaa vataarive tita, Iesusiva varunani uro saare tuvata Iesusira nraaqiaranravuvano mwisa irora hi varura. ");
INSERT INTO omw_a_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mwitaa huvaro Iesusiva taqero nai nraaqiaranravu niari irora hiro tiqaro, Qaqao, né nraaqiara mwisa qaqi saivata ne hunani nriate. Sia mwisa aara antuaate. Kotiva ntaqaihiari mwatusava mwi nraaqiarasa voti hiasa mwisa mwatusama vahianarove. ");
INSERT INTO omw_a_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mwaa quara riaate. Vaitivano sia nraaqiara votima sero Kotira qua riaariva, mwi vaitiva siama Kotiva ntaqaihiani mwatusaraqi vuanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iesusiva mwitaa tiva sero nraaqiara mwisa avuhu sero tutero nai sauqu mwisaqaa vateqaro mwisa suqema mwatora. ");
INSERT INTO omw_a_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesusiva aarana virera huvaro vaiti mwovano santero nrima Iesusira sapara hiro tiqaro, E mwaara ti variara vaitiva suqevave. Ne nataa hi saiqara mwo saiqa mwo saiqa suqe saiqa Kotirani vara mwataaniraqaatainave naatiara ne esaa enta qaqi variqina vuanirave? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Mwitaa tuvaro Iesusiva tiqaro, E naraqamave niara vaiti suqevave tiaro? Kotivaqaima suqeva variso. ");
INSERT INTO omw_a_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","E Kotiva tiva to quarara riaane. Mwira quavano mwataama sero vahirave: Sia mwora rusaane. Sia mwora nraasera nruaane. Sia muara varaane. Sia unra qua tiane. Sia unra utu seqara mwova hiani inraisara varaane. Ena nrosa qosa nrutu tuaahera nataane, turave. (Kis 20:12-16) Kotira quavano mwitaama sero vahirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iesusiva mwitaa tuvaro mwi vaitiva tiqaro, Mwaara ti variara vaitio, ne nraaqiarasaa variqana ne mwi quara rieqana mwitaa mwitaamaqina nrurave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mwitaa tuvaro Iesusira mwutusavano mwi vaitirara vahuvaro mwira taqeqaro mwira tiva mwiro tiqaro, E kuaa inraisaraqai aara ntaaro. Uro ena vatena inraisara mwosa nira munima vara sera vehi nraase qora tusama sera niraro naavuni i soqaa vahiarive. Mwitaama sera mwiraqaataira ni vataqira nriane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Iesusiva mwitaa tuvaro mwi vaitiva mwi quara riero inraara viri ratero varura. Mwiva airi inraisa vatovara tiro, sia Iesusira qua riaraitiro, qaqira sero mwira mwutusavano uaqa huvaro vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Vuvaro Iesusiva nai nraaqiaranravu vara ututuma sero taqero tiqaro, Airi inraisa vatesa Kotiva ntaqaihi mwatusaraqi mwusaari tu seta vivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mwitaa tuvata mwira nraaqiaranravuvano mwi quara rieta, Qike tita, Iesusiva nataihi quarave tiso, tuvaro Iesusiva qaiqaavataqai mwi quara tiqaro, Ni nraaqiaranravu tuaavo, nraase qoravano Kotiva ntaqaihi mwatusaraqi virerata mwusaari tuseqatama vivarave. ");
INSERT INTO omw_a_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","(Kameri quara nroravano nataama serove vuqa uvintaqi ntuqiaraanarove? Sia so mwitaa hianarove.) So kamerivano vuqa uvintaqi ntuqiaraariva so vahirarove, airi inraisa vataarivavata Kotiva ntaqaihi mwatusaraqi so vuanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iesusiva mwitaa tuvata mwira nraaqiaranravuvano mwira quara airi nraato tiqata qike tita, Airi inraisa vataariva Kotiva ntaqaihinani sia so virera, nai tarave Kotiva vitaanarove? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mwitaa tuvaro Iesusiva mwisa itutuma sero taqero tiqaro, Mwatani variasa niari kepusara siama so vivarave. Kotiva saahaqa hirata so vivarave. Kotiva esaa saiqa vare varivave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mwitaa tuvaro Pitaava tiqaro, Taqaane. Tirenravu i vataqita virera hiqata esaa inraisa mwini seta qaqima nruro, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pitaava mwitaa tuvaro Iesusiva mwisara tiqaro, Ne quqaa qua tianira riaate. Sia ne né saiqa varerara tauru saanirave. Vaiti mwovano nai nraavu maatave, nai qata vasaave, nai nrura nrasaave, nrora qorave, nai nraaqiarave, nai mwatave, mwini sero niara riero ni saiqara riero vuariva, ");
INSERT INTO omw_a_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mwi vaitiva mwira qiata soqaa vareqaro sia kuaa nani varaanarove. Mwiva mate mwaa mwataraqaa soqaa vareqaro airi nani varaanarove. Mwiva nraavuve, qata vasaave, nrura nrasaave, nrosave, nraaqiarave, mwatave, mwi inraisara mwi inraisara airi inraisa varaanarove. Ni qua varaari vaitiva varirata mwira saara mwira uaqama mwataivaro varianarove. So ni qua varaariva qutu viraro Kotiva mwirara esaa enta qaqi variqira vuane tianarove. ");
INSERT INTO omw_a_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mate nraase qora airivano vuni variasa qaso tuvitareta naatiaranima varivarave. Mate naatiarani variasa qaso nritareta vunima varivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mwisa Ierusareminiara aaraqaa vi varuvaro Iesusiva nraante nariaraa vuni vi varura. Mwiva vuni vi varuvata mwira nraaqiaranravuvano naatiara nriqata airi vu nraato tuqita vi varuvata nraase qora mwonravuvano Iesusira vataqita nrusavata aatu hiqata nri varura. Mwitaamaqi vi varuvaro mwiraqaatairo Iesusiva nai nraaqiara 12 nravu nraarama sero niariaraa vita varero viqaro naatiara naiqaa qovara hiani inraisara qaiqaa tiva niro tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Riaate. Te Ierusaremini uro variarata vaiti mwonravuvano ni mwatani mwatatai nraaqiarara ntavaaqavuqita uro saivata Kotira saiqa vara mwate vari vaitisa mwisa vuniaa vaitinravuvanovata, mwaara osara ti varia vaitisavata, mwisa niara mwira ru saate tiva seta, ni vitaqita uro Romeni mwatanaasa sauquqi tuta saivata ni ru sevarave. ");
INSERT INTO omw_a_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mwi mwatanaasa niara raima mateta, niqaa quaantu vihiteta, saantaqo ni ntuqutuse vateta, ni rusaivaqena qutu vuanirave. Ne qutu vina taaramwo enta varina qaiqaa qaqi tivuanirave, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepetira mwaaqutana Semisisa Ionisa Iesusiva varunani uro nteta Iesusira sapara hita tiqata, Mwaara ti variara vaitio, e mwo inraisa tiritana quara eo tiva sera mwitaama tiva taanterama nruro, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tuvaro Iesusiva tiqaro, Ne nítana nataave hianirave? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tuvata mwitanasa tiqata, Naatiara e kepusavano nraase qoraqaa ntaqaihiqara nrora vaiti taintaqa mwatasaa vira variqara e tiraro tiritanaqitairo mwovano nroraqama viro i sauqu tanarani mwatasaa viro variraro mwovano nroraqama viro i sauqu saanaaqani mwatasaa viro variarive. Tiretana mwirara rieqatama i sapara huro, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mwitaa tuvaro Iesusiva qaqao tiro, Nétana sia ntapihi seta vu nraato tiraitita, apiqama seta ni sapara hiavo. Kaapuqitai nramari nraantema sena ne nriqa vuani nramarira nraanira, sove nétanavata nrevarave? Ne nriqa vuani inraisara nramari varaantemase varaanira, sove nétanavata varevarave? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tuvata mwitanasa tiqata, Tiretana soma mwitaa hianarave, tuvaro Iesusiva mwitanasa tiva niro tiqaro, Quqaama ne nramari nraanira nétanavata nrevarave. Quqaama ne nramari varaanira nétanavata varevarave. ");
INSERT INTO omw_a_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ni sauqu tanaranivata saanaaqanivata mwatasaa vita vari vaititanasara siama ni saiqa vaiso. Ni qova vaiti taaratana tequamataisa, mwitanasama mwiraqaa mwatasaa vita varivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mwitaa tuvata Iesusira nraaqiara hini 10 nravuvano mwi quara rieta mwira saara Semisisa Ionisa irora hura. ");
INSERT INTO omw_a_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mwiravusa mwitanasa irora hi varuvaro Iesusiva mwiravusavata mwitanasavata nraarama sero eqaate tiro, Mwo mwatanaasa ntaqaihiqi vi varia osarara né ntapihiarave. Mwisa qiata vaitivano nritareta virito variqata mwi saiqara mwaa saiqara vara timwataate ti variarave. Mwisa nrora vaitivano tiqata, Te nroravano varuro. Tiri quaqai riemwaqita vuate, ti variarave. ");
INSERT INTO omw_a_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nénravu sia mwisa nraantantaate. Iniqitairo mwovano nrora varireraro mwiva ini saiqa vaiti nraante variro naatiara nroraqama vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Iniqitairo mwovano nritarero vuni varireraro tiariva, mwiva rupa tai vaitira votima sero ini saiqa vara nataanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ne mwatani mwatatai nraaqiaravama varuqo. Nevata sia nraase qoravano nini saiqa vara mataatera tuvuvave. Ne nraase qorani saiqa varaqina viqana airi nraase qora saahaqama natena mwisara qutu virerave tiva sena tuvuvave, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iesusiva nai nraaqiaranravuvata vuva Ierikoni nrintero mwi mwatusara nraatarero virera huvata nraase qora airivano mwira vataqita vi varuvaro vu qipa vu vaitiva Vatamiaasiva, Timiaasira mwaaquvano variqaro mwo inraisa miate tiva seqaro naaru ti varu vaitiva aara tosani mwatasaa viro varura. ");
INSERT INTO omw_a_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mwiva mwini variqaro riovata mwo husa tiqata, Iesusiva Nasaretinaava nritare vi variso, tuvaro riero mwiraqaatairo mwiva paatiro Iesusirara aasara ntero tiqaro, Iesusio, Devitira mwaaquo, qaqi niara po se tiva mataane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vu qipa vu vaitiva mwitaa tuvata airi nraase qoravano mwira irora hita tiqata, Tirema variane, tuvaro mwiva sia mwisa qua riaraitiro, qaiqaa paatiro aasara ntero tiqaro, Devitira mwaaquo, qaqi niara po se tiva mataane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mwitaa tivaqi vuvaro Iesusiva nrima mwiraqaa tiviro variro tiqaro, Nraaraivaro nriarive, tuvata mwisa vu qipa vura nraarama seta tiqata, So qamwa teqara variane. Tivuane. Mwiva ima nraaraiho, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mwisa mwitaa tuvaro vaiti mwiva nai vaaqa qutora vara qaqinani sero tiviro Iesusiva tivi varunani vuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesusiva mwira sapara hiro tiqaro, Nivano i nataa hiarive tirave nriaro? tiro. Mwitaa tuvaro vu qipa vu vaitiva tiqaro, Mwaara ti variara vaitio, e ni vu ntapairi saanterama nruqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mwitaa tuvaro Iesusiva mwira tiva mwiro tiqaro, So vuane. E niara mwiva so ni saahaqa hianarove tiararoma i vu ntapairi viso, tiro. Mwitaa tuvaro mwira vuvano qamwanrama sero ntapairi vuvaro mwiva so taqero. Mwiva so taqeqaro Iesusira vataqiro aaraqaa vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iesusiva nai nraaqiaranravu sapata vuvaro Ierusaremi qaumato vahuvata mwisa Betapaasivata Betaani mwatusanivata uro ntora. Mwatusa mwitanava Oripi taaqi mwevaqi vahura. ");
INSERT INTO omw_a_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Uro ntero Iesusiva nai nraaqiara taaratana titero tiqaro, Nétana viti mwatusaraqi vivaro ini vuvano vaasama ntonki mwo saantaru tera taqaanarove. Mwira qaraaha ntonki sia vaiti mwovano mwira mwoqaqaa mwatasaa viro varirave. Nétana uro mwira huaama seta mwira ntatu seta vitaqita nrima ni miate. ");
INSERT INTO omw_a_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mwovano initanara narave uti variavo tirera, nétana mwitaama mwira tiva mwiate. Tiri nroravano ntonki mwirara tisatama nruro. Pataqa vari sero qaiqaa vara sairaro nrianarove, tiate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iesusiva mwitaa tuvata mwitanasa mwatusa mwiqi uro ne taqovaro ntonkivano aaraqaa qetiana saantarutova varuvata mwitana mwira avanti varuvata ");
INSERT INTO omw_a_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","vaiti mwonravu mwini tivita varusa tiqata, Nétana naraqamave mwira avanti variavo? ");
INSERT INTO omw_a_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","tuvata mwitanasa vaasa Iesusiva tu quara tiva nuvata so vitaate tita. ");
INSERT INTO omw_a_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tuvata mwitanasa qaraaha ntonki mwira vitaqita uro Iesusira mwura. Uro mwita mwira nraaqiaranravuvano niari vaaqa ntonki mwoqaqaa vuti mwatovaro Iesusiva mwiraqaa mwaarintero mwatasaa viro variro aaraqaa vura. ");
INSERT INTO omw_a_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aaraqaa vi varuvata nraase qoravano Iesusirara qamwateqata niari tuavaaqa aaravau vuti mwatovata hini husa vutaqitaita satari mware teqaqita uro aaravau vuti mwatora. ");
INSERT INTO omw_a_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mwitaamaqi viqata Iesusira vuni vi varu nraase qorasavata, mwira mwoqani nri varu nraase qorasavata, aasara nteta tiqata, Sai mwira nrutu tuaaheraare. Nroravano nai nrutuqa nri vari vaitira suqema mwataiso. (Sng 118:26) ");
INSERT INTO omw_a_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tiri haivaqava Devitiva kepusaqama sero ntaqaihintema sero mwivavata ntaqaihiqiro vuanirara tiro, Kotiva mwira suqema mwataiso. Esaa naavuniaasa mwira nrutu tuaaheraate, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mwitaa tivaqita vuvaro Iesusiva Ierusaremini uro ntora. Uro ntero Kotira nraavu nroraqi verantero esaa inraisa mwiqi vahura taqamwa sero, veva ntero entama virera huvaro nai nraaqiara 12 nravu sapata nrima ntantero Betaanini vura. ");
INSERT INTO omw_a_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mwira qararaara mwinravusa Betaanitaita uto ntanteta nri varuvaro Iesusira nraataa huvaro ");
INSERT INTO omw_a_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","mwiva taqovaro vutura mwosata fiki, mwira tava nre varu satariva vahuvaro mwira mware airi vahura. Mwira tava vahirera, hiqi sena nraase tiva sero, Iesusiva taqovaro sia mwira tava rio entava vahuvarora tiro, mwareqai ntora. ");
INSERT INTO omw_a_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mwareqai ntovaro Iesusiva fiki mwira irora hiro tiqaro, So, naatiara sia mwovanovata iqaatairo hiqi sero nraarive, tiro. Mwitaa tuvata mwira nraaqiaranravuvata mwi quara riora. ");
INSERT INTO omw_a_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Iesusiva nai nraaqiaranravuvata vuva Ierusaremini nrintero Iesusiva qaiqaa Kotira nraavuqi vera ntero taqovata soqaa saiqa varo vaitisa mwiqi variqata soqaa saiqa vare varura. Mwitaa hi varuvaro Iesusiva mwisa vara veva mwaatani sero, munima mwusaari tuqataaqi varu vaitisa taintavata vara rauru sero, kuri niqata munima vare varu vaitisa taintavata vara rauru sero. ");
INSERT INTO omw_a_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mwitaama sero mwiva mwi nraavura aatareqaniara tiqaro, Mwaini sia aaravano vaiso. Né soqaa mwitaa inraisa vareqata sia mwaini vitare nritare hiate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iesusiva mwitaa tiva sero mwiva qua tiva niro tiqaro, Kotira vukuqi mwitaama qua qara ntuva tova vahirave. Nraase qora mwo mwatanaa mwo mwatanaasa ni nraavuara Kotirara aasara nte varia nraavurave tivarave, turave. (Ais 56:7) Né variavaro mwaa nraavuva muara vaitivano quqetase uairama hia nraavura votima seroma vaiso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Iesusiva mwitaa tuvata Kotira nraavuqi variqata Kotira saiqa varo vaitisavata, mwisa Iesusira qua rieta mwira saara Iesusira ruse aarara huaa hi varura. Mwisa taqovata qaqi nraase qoravano Iesusiva tu quarara qamwateqata sauqu ntukikiraaqate varuvata mwinravusa mwirara rieqata Iesusirara aatu hiqata varura. ");
INSERT INTO omw_a_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Iesusiva Ierusaremini varuvaro enta hirera huvaro mwiva nai nraaqiaranravuvata Ierusaremi sero vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mwira qararaara toqaqi mwinravusa uto ntanteta nriqatama mwira nraaqiaranravuvano taqovaro fiki mwira sauqu sauquvanovata tuqavanovata aaharama viro vahuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pitaava Iesusiva mwi satarirara tu quara riemwa tero Iesusirara tiqaro, Qike, mwaara ti variara vaitio, taqaane. Fiki e irorama taarava tamusama viso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mwitaa tuvaro Iesusiva mwinravusa tiva niro tiqaro, Ne tianira riaate. Nénravu Kotirara kepusaqama seta riemwaqita nruaate. ");
INSERT INTO omw_a_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nénravu mwitaamaqi viqata mwaa taaqirara tiqata, Tuvitarera nrukaqi ntuva vuane, tivarave. Mwitaa tiqata sia taara nraato tiraitita, quqaaqama mwitaa hianarove tivera, Kotiva ininravu saahaqa hiraro taaqivano tuvitarero nrukaqi ntuva vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ne mwirara rieqanama iniara mwitaa tirerave. Né mwo inraisa vararerata Kotirara aasara nteqata quqaama mwi inraisara ni mianarove tiqatama né mwi inraisara mwo inraisa mwo inraisa so varevarave. ");
INSERT INTO omw_a_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Né tivi variqata Kotirara aasara nteqatama mwovano ini uaqama nataani quava vahirera, né mwi quara sia riemwaqi viraitita, mwi vaitira qua tauruse qaqira seta Kotirara aasara tiate. Né mwitaa hivaro ini qova naavuni variva né uaqa hi saiqara uti quaravata qaqira sero tauru nataanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Né sia mwosaqaa qua vahira qaqirase tauru saivera, ini qova naavuni variva siama nítaqaavata qua vahianira qaqira sero tauru saanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iesusiva mwitaa tiva sero nai nraaqiaranravuvata uto ntero Ierusaremini uro varura. Iesusiva qaiqaa Kotira nraavu nroraqi vera ntero nrue varuvata Kotira nraavuqi variqata Kotira saiqa vara mwate varu vaitisa mwisa nrora vaitinravuvata, mwaara osara ti varu vaitisavata, Iutaa nrora vaitivata, mwisa Iesusiva hunani uro nteta ");
INSERT INTO omw_a_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Iesusira mwira irora hita tiqata, E ta vaitiva variqarave mwaa saiqara vare variaro? Tava i nroraqama saisarave e mwaa saiqara vare variaro? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mwisa mwitaa tuvaro Iesusiva niari tiva niro tiqaro, Sai ne nraante ini saparama nataarita né ne tiani quara so tiva mivera ne nena nroraqama vina variqana mwaa saiqara varaanirara ini tiva niase. ");
INSERT INTO omw_a_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tava Ionira nroraqama sovarove mwiva nraase qora nramari nurave? Kotivave iso, qaqi vaitivanove iso? Né ni tiva mivaqena riaase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iesusiva mwitaa tuvata mwisa niari sapara hita tiqata, Te nara quave tianarave? Mate te tiqata, Kotiva Ionira nroraqama sorave, tiarera, Iesusiva tiriara, Né naraqamave Ionira quara sia quqaave tiavo? tianarove. ");
INSERT INTO omw_a_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Qaiqaa mate te tiqata, vaitivanoqai Ionira nroraqama sorave, tiarera, mwi quavavata sia soqa hianarove, tura. Qaqi nraase qoravano Ionirara Kotira qua qovarama so vaitivave turara tita, mwisa qaqi nraase qora nraatu aatu hiqata sia mwitaa tita. ");
INSERT INTO omw_a_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mwisa mwitaa tiva seta mwiraqaatai Iesusirara tiqata, Nai tava Ionira nroraqama sorave? Sia te ntapihunarave, tita. Mwisa mwitaa tuvaro Iesusiva mwisara tiqaro, Né mwitaa tiavana ne nina nroraqama saisana mwaa saiqara vare varurara sia nítavata tiva nianirave, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesusiva mwitaa tiva sero mwo quaqaa ntuva sero mwisa tiva niro tiqaro, vaiti mwovano uaini vara tutero mwira vara ututu qurisa ratero mwata quvu sero uaini tatianira ututero haraara nraavu mwonta vaivaraara nraavu hoqa sero vatorave. Mwiraqaatairo niara mwo mwatani virera hiqaro mwo husa tiva niro tiqaro, Né ni uaini vutaqi ntaqaihiqata varivaqe ne vuase, tiva sero mwiva niara mwo mwatani vurave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mwini uro varuvaro uaini hiqi entava nri ntovaro mwiva nai saiqa vaiti mwo titero tiqaro, E uro ni vutaqaa ntaqaihi mate variasa tiratama uaini ninanivata hiqise mataate, turave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mwitaa tuvaro mwini vuvata mwira vutaqaa ntaqaihi mwate varu vaitisa mwira saiqa vaiti mwira ntavaaqavu seta saavuqotaita ntuqutu seta vateta, sia uaini hiqise mwira mwiraitita, qaqi titovaro nrima ntantero vurave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Qaqi nrima ntantero vuvaro nraaso qova nai saiqa vaiti mwo titovaro vuvata mwira vutaqaa ntaqaihi mwate varusa mwira qiata ntukavu seta saurira inraisa mwurave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mwitaa huvaro nraaso qova nai saiqa vaiti mwo qaiqaa titovaro vuvata mwira rusorave. So mwitaamaqi vita, hini nai saiqa vaiti titosa saavuqotaita ntuqutu seta, hini rusorara tuqo. ");
INSERT INTO omw_a_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mwira saiqa vaiti taiqa sovaro vaiti kuaiqaqai varura. Mwi vaitiva nraaso qora mwaaquvano varuvaro mwira qora mwutusavano mwirara mwoqavata vahu vaitiva varuvaro mwira qova mwiravata naatiara esaara titero tiqaro, Mwisa ni maaqu taqeta niara mwira mwaaquve tiqatama mwira suqema mwatevarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mwitaa tiva sero mwira titovaro mwini vuvata mwira vutaqaa ntaqaihi varu vaitisa mwira mwaaqu taqeta, nai tiva mwi nai tiva mwi hita tiqata, Mwira qova qutu viraro mwaa vaitiva nai qora mwatavata, mwitaa inraisavata, varaarivama variso. Nrivaqe te mwira rusaararo mwiva varareraro hiani inraisava tiriniqai vahiarive, turave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mwisa mwitaa tiva seta mwira mwaaqu ntavaaqavuse ruseta mwaaqani mwaati qaqira sorave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iesusiva mwitaa tiva sero mwisa saparama natero tiqaro, Mwisa mwitaa hurara tiro, nraaso qova nai mwaaqu rusera saara nataave hianarove? Aaso qova nri ntero nai vutaqaa ntaqaihi vaitisa ru taiqa sero saata vaiti mwonravuara tiqaro, Néma ni vutaqaa ntaqaihi mataate, tianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Iesusiva mwitaa tiva sero mwiva mwisara tiqaro, Né siave Kotira vukuqi mwaa quara saara ntuva seta riaavo? Mwi quava mwataama tiro: Ori nraavu hoqeqata ori mwo sia suqerave tivase qaqira saava, mwi oriva puhaqama viso. ");
INSERT INTO omw_a_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kotiva mwi orira vara sero nroraqama saisata te mwira saiqa taqeta suqerave tunarave, turave. (Sng 118:22-23) Kotira vukuqi mwitaamase qara ntuva torave. Né siave mwi quara saara ntuva seta riaavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iesusiva mwitaa tuvata Iutaa nrora vaitinravuvano ntapihi riovaro Iesusiva uaini vutaqaa ntaqaihi mwato vaitisara tiqaroma mwisaqaa ntuva sero tuvata mwisa Iesusira ntavaaqavu seta ko tiare tura. Mwitaa tiva seta nraase qoravano mwiqi uairama vusa tiri irora hivorave tita, mwisa nraatu hiqata Iesusira seta vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Iutaa vaiti nroranravuvanto vari seta mwiraqaatai mwisa Parisi vaiti mwonravuvata, Herotira nravunaasa mwonravuvata, viteta tiqata, Né Iesusira sapara hivaro mwiva api qua tiraqe mwiraqaa qua vataare, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tuvata mwisa Iesusiva hunani uro nteta mwira sapara hita tiqata, Mwaara ti variara vaitio, te taqaurara e suqe quaqai ti variaravave. E sia vaiti nraatu aatu hiraitira, nrora vaitiaravata, qumina vaitiaravata, kuaa quaqai ti variaravave. E vaitivano Kotira vataqita vi aarara ntapihi sera tiva ni variaro. So mwaa quara tiva timwiraqe riaare. Te Kotira qua rieqata sove te Romeni mwatanaasa vuniaa vaiti Sisaara taakisi mwianarave? (Mwi mwatanaasa sia Kotira qua riaasave.) Mwira taakisi mwianarave siave mwianarave? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mwisa mwitaa tuvaro Iesusiva taqovata mwisa nroqaataita suqe suqe ti variqata mwisa vu nraatoqitaita Iesusira uaqama mwatarerata uti varuvaro Iesusiva tiqaro, Naraqamave nénravu nivanto api qua tiarive tita mwitaa tiavo? So munima mwoku vara saivaqe ne taqaase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mwitaa tuvata munima mwira kuauru mwuvaro mwiva mwisa sapara hiro tiqaro, Munima mwiraqaa tara virivata tara nrutuvatave vahiso? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mwitaa tuvata mwisa Sisaarave tuvaro Iesusiva mwisara tiqaro, Mwirara rieqatama né Sisaava hianira nai mwita, Kotiva hianira nai mwiate, tiro. Iesusiva mwitaa tuvata mwisa mwi quara rieta tiqata, Qike, mwiva tiri qua nraatara sero suqe qua tiso, tiva seta sauqu ntukikiraaqate varura. ");
INSERT INTO omw_a_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saitiusi vaitivano Iesusiva varunani uro ntora. Saitiusi mwisa niari mwaara qua rieqatama mwisa tiqata, vaitivano qutu viro so mwiva esaarama qutu viro siama qaiqaavata tivuanarove, ti varu vaitisa uro nteta ");
INSERT INTO omw_a_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Iesusira sapara hita tiqata, Mwaara ti variara vaitio, tiri haivaqava Mosesiva mwaara qua tiva timwiqaro mwitaa turave. Vaitivano sia nraaqiara mwataraitiro, qutu viraro mwira qatavanove vasaavave mwira nraata varatero nraaqiara mwata humwuarama mwataanarove, turave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Te tiarara e riaane. Haaru qate vase 7 nravu varurave. Mwisa vasaava tauraanaava nraase varatero sia nraaqiara mwataraitiro, qutu vuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","mwira qata mwira naatiaraava mwira nraata varatero mwivavata sia nraaqiara mwataraitiro, qaqi variqiro viro qutu vurave. Mwiva qutu vuvaro mwira qata mwira naatiaraava nraase mwira varatero sia nraaqiaravata mwataraitiro, qutu vuvarave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","So mwitaamaqi vita esaa mwinravusa nraase mwira varateta sia nraaqiaravata mwataraitita, esaa qaqiqai qutu vurave. Qutu vuvaro naatiara nraase mwivavata variro qutu vurave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naatiara nraase qora qaiqaa qaqi tivita vari entaraqaa mwi nraaseva tara nraatave varianarove? Mwiva qaqi varu entara qoraisi 7 nravu vara torave, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Saitiusi vaitinravuvano mwitaa tuvaro Iesusiva niari tiva niro tiqaro, Né Kotira qua qara ntuva tora sia ntapihi saasave. Né Kotira kepusavata sia ntapihi saasave. Quqaara sia ntapihi saasara tita, né api qua ti variavo. ");
INSERT INTO omw_a_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Naatiara nraase qora qutu visa qutu viraqitaita qaiqaa tivita qaqi variqita vi entara siama nraata vaati vare osarava vahianarove. Mwisa naavuniaasa nraantantama setama varivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iesusiva mwitaa tiva sero mwiva tiqaro, Nraase qora qutu visa qaqi tivirara ne ini sapara hirerave. Né siave Kotira vukuqi Mosesiva mwaa quara qara ntuva tora saara ntuva seta ntapihi riaavo? Kotiva mwitaa turave. Ne mwariqa Kotivave. Ne i haivaqara Evarahaamuraqaa ntaqaihina, Aisaakiraqaa ntaqaihina, Sekopuraqaa ntaqihuvave, turave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","So riaate, Kotiva mwariqavano sia qutu viro taiqavi inraisaraqaa ntaqaihi varivama variso. Nraase qoravano qaiqaa qaqi tivi osarara ini vu nraatovano sia ntapihi visata api rieqata ti variarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iesusiva Saitiusi vaiti sapata qua ti varuvaro mwaara osara ti varu vaitiva uro variqaro riovaro Iesusiva Saitiusi vaiti qua nraatara seqaro suqe quaqai ti varuvaro mwi vaitiva Iesusira sapara hiro tiqaro, Kotiva qua tiva taiva nara quavanove vuni vahi quava vahiso? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tuvaro Iesusiva mwira tiva mwiro tiqaro, Mwaa quava vuni vahi quavama vahiso. Mwataama qara ntuva torave: Né Isareri mwatanaasa riaate. Tiriqaa ntaqaihi variva Kotiva mwariqa kuaiqavano variso. ");
INSERT INTO omw_a_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Esaa ena mwutusaqitairave, esaa ena mwanraquraqitairave, esaa ena vu nraatoqitairave, esaa ena kepusaqotairave, Kotiraraqai mwutusa vahirara variane, turave. (Lo 6:5) ");
INSERT INTO omw_a_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mwi quava vaisaro mwira naatiara osara qua mwo vahiso. Mwitaama tiro: Enara mwutusa vataarantema sera ena henararavata mwutusa vahirara variane. (Wkp 191-12:18) So mwi quatanava vuni vahi quatanavama vahiso. Sia mwo quavano mwi quatana nraatara sairave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iesusiva mwitaa tuvaro mwaara osara ti varu vaitiva tiqaro, Mwaara ti variara vaitio, e suqema sera ntapihima tiaro. E quqaama tiqara, mwariqa Kotiva kuaiqavanoqaima variso tiaro. Sia mwariqa mwovanovata variso, tiaro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","E quqaama tiqara, Vaitivano mwutusaqitairove, kepusaqotairove, Kotirara mwoqama sero mwutusa ntiraro varianarove. Vaitivano nai henarara nariara mwutusa vahintema sero mwiaravata mwutusa vahiarive, tianarave. Mwi quatanava vuni vahiqaro hini qua nraatara sairave. Mwo qua Kotira saiqa vara mwateqata quara ruseta tia quara mwate varia quaravata, mwi quatanava nraatara sairave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mwitaa tuvaro Iesusiva taqovaro vaiti mwiva suqema sero tuvaro Iesusiva mwira tiva mwiro tiqaro, Kotiva iqaa ntaqaihiariva i qaumatoma variso, tiro. Iesusiva mwitaa tuvata vaiti saatavanovata Iesusiva tiri qua nraatara saaso tita, sia Iesusira qaiqaavata nrima mwo qua mwo qua sapara hura. ");
INSERT INTO omw_a_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesusiva Kotira nraavuqi variqaro qua tiva niqiro viro tiqaro, Mwaara osara ti varia vaitisa tiqatama, Mesaiaa vaiti Kotiva titaariva Devitira osara kuaa osara mwiqinaa vaitivanoma varianarove, tiarave. Mwisa nataama seta mwi quara ntapihi setave mwitaa tivarave? ");
INSERT INTO omw_a_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Haaru Kotira mwaraquravano saahaqa huvaro Devitiva nai mwitaa turave: Kotiva ni nrora vaitiara tiqaro, E nritarera ni sauqu tanarani mwatasaa vira variraqena ne i nravutaasa ru taiqa mwataarira mwisaqaa suqu ntava tera variane, turave. (Sng 110:1) Devitiva mwitaa turave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devitiva mesaiaa vaitivano qovara hianirara tiqaro, Mwiva ni nrora vaitive, turave. Devitiva mwitaa turara tiro, nataama serove mesaiaa vaitivano Devitira nraisi so varianarove? tiro. Iesusiva mwitaa tuvata qumina nraase qora airivano uairama vita varusa mwira qua rieqatama qamwateqata varura. ");
INSERT INTO omw_a_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesusiva qua tiva niqiro viro tiqaro, vaiti mwonravu mwaara osara ti variasa, né mwisara rauriqata variate. Nraase qoravano mwisa tiri taqeta qua mwanteqata qamwata timwataate tita, mwisa muahaa tuavaaqa suqera utu vareta nraase qora vuqaa maaketiqi nrue variarave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mwisa mwaara nraavuqi vera nteta uaqa hi taintara qaqira seta, suqe taintaqaaqai mwatasaa vita variarave. Mwisa omwata nraaraqaa variqata mwisara nrora vaitive tiate tita, uro vaiti nroravano mwatasaa vita variaraqaa mwisavata mwatasaa vita variarave. ");
INSERT INTO omw_a_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mwisa tetoqa varia nraasesa nraavuve mwo inraisave vataara muara vareta tiqata, Mwosa te qora inraisa utunara taqeta tiriara uaqaa hia vaitisave tivorave, tita mwisa nraase qora vuqaa variqata Kotirara muahaama seta aasara ti variarave. Qike, mwira saara mwisaqaa qua nroraqama sero vahianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kotira nraavuqi taqu mwo vahuvata mwiqi nraase qoravano Kotira saiqara rieqata munima se varura. So Iesusiva qua taiqa sero uro taqu mwira tataaqa mwatasaa viro variqaro nraase qoravano munima taqu mwiqi seqata vi varuvaro Iesusiva taqe varura. Mwiva taqovata airi inraisa vatosa munima airi mwiqi sora. ");
INSERT INTO omw_a_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Se varuvaro vehi tetoqa nraasevanovata nri ntero munima patarutanaqai taquqi sora. ");
INSERT INTO omw_a_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Munima pataqarutana mwiqi sovaro Iesusiva nai nraaqiaranravu nraarama sero tiva niro tiqaro, Taqaate, vehi nraase tetoqavano sai munimava airi inraisa vataasa airi munima saaravata nraatara saiso. ");
INSERT INTO omw_a_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Airi inraisa vataasa niari munima hiniqaima taquqi saavo. Nraase mwiva vehi variqaro nai vatai munimara esaama saiso, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesusiva Kotira nraavuqitairo veva ntovaro mwira nraaqiara mwovano tiqaro, Qike, mwaara ti variara vaitio, taqaane. Mwaa nraavuva suqe hi nraavurave. Mwo ori mwo ori nroraqotaita vara seta hoqataa nraavuva suqe nraavuma vaiso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mwitaa tuvaro Iesusiva mwira tiva mwiro tiqaro, Mate e nrora nraavu taqe variaro. Naatiara ori naiqaa naiqaa ntaaqautaava sia mwitaama sero vahianarove. Mwaa nraavura ntapairiqata mwira raaqu saivaro uto ntiraro orivano ntuvuraa vura hiro api mwona mwona vahianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mwitaa tiva sero Iesusiva uro Oripi taaqiqaa mwatasaa viro varura. Oripi taaqivano mwaa hini vahuvaro Kotira nraavuvano vutura qarahi hini vahura. Mwitaama vahuvata Pitaavavata, Semisivavata, Ionivavata, Enturuvavatama seta mwiravusaqai vusa Iesusiva varunani uro nteta mwira sapara hita tiqata, ");
INSERT INTO omw_a_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","E vaasa Kotira nraavuara tianara taireve qovara hianarove? Nara nara inraisa qovara hiraqeve tirenravu mwi inraisaraqaa apeqama seta taqeqata mwi entava nriariva qaumatoqa iso tianarave? E tiri tiva timwiraqe riaare, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mwisa mwitaa tuvaro Iesusiva tiqaro, Mwovano mwi quara ini api tiva niaso tita, rauriqatama variate. ");
INSERT INTO omw_a_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Naatiara airi vaitivano nri nteta ni nrutu nteta tiqata, Kotiva ni titaisana nruvave. Ne mwaa mwivave, tivata airi nraase qoravano mwisa unra quara quqaa quave tivarave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Né varivaro nroraqamase ntaqi quava vainiqaatairove niaratairove nrirata sia aatu hiate. Ntaqi inraisava qovara hianarove. Mwitaa hirata né mwirara rieqata mwi entava esaara enta nri ntaiso tivorave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mwo mwatanaavano mwo mwatanaaravata ntaquanarove. Qiata vaiti mwovano nai hena qiata vaiti mwovata ntaquanarove. Mwo mwata mwo mwata mwaturavano tuanarove. Mwo mwata mwo mwata sarara aarantevarave. Mwi inraisava mwi inraisava qovarama virata sia esaara enta nri ntaiso tiate. Nraasevano nraaqiara mwatareraro hoqarero nriqa vintema sero, muaara ntaani entava qaqi hoqarama taiso, tiate. ");
INSERT INTO omw_a_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mwi entara aitutumaqi vita rauriqata variate. Mwo hi vaitisa ini ntavaaqavuqita uro niari kaanasoriqaa seta, iniqaa qua vatevarave. Né mwaara nraavuqi varivata ini saavuqo ntuqutu seta vatevarave. Né ni saiqa vare varivata mwira saara ini ntavaaqavuqita uro kamanira nrora vaiti vuqaave, vuniaa vaitinravu vuqaave, saivata mwi entara né ni qua ntapihise tiva qovarama sevarave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ni qua suqe qua esaa mwo mwatanaa mwo mwatanaasa tiva niqi vivata esaama riemwa ntevarave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Naatiara mwisa ini ntavaaqavuqita uro ko tirera hivaro, sia ini suqu sauqu ntirata nara quave tianarave tiate. Mwi entara sia néta vu nraatoqitaita riemwa seta tiraitita varivaro Kotira mwaraquravano ini saahaqa hiqaro mwi quara tiate tirata mwi quaraqai tiate. ");
INSERT INTO omw_a_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Naatiara vaitivano nai qatave nai vasaarave qovarama sairata ru sevarave. Mwira qova nai nraaqiara qovarama sairata ru sevarave. Nraaqiaravano niari nrosa qosa nravutaaqa hiqata ru saate tivata mwisa ru sevarave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mwi entara né ni nraase qoravano varivatara tita, mwira saara esaa qaqi nraase qoravano sia iniara mwutusa vahirata varivarave. Mwitaama mwataivarovata sia qoriri hiraitiro, kepusaqama sero variqi viro uro taiqa saani vaitira, mwirama Kotiva vitaanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Naatiara né taqaivaro anoma sero qora inraisavano qovarama viro sia mwirara variane tianira mwinima mwiva tiviro varianarove.—Mwaa quara saara ntirava ntapihi sera nraato tuane. Naatiara mwi entara mwi inraisava qovarama virata nraase qora Iutiaani variasa tivita santeta verara taaqiqaa vuate. ");
INSERT INTO omw_a_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mwi entara nraavu qetiana variariva siama nraavuqi vera ntero mwo inraisavata vararaitiro, mwiva mwo inraisa mwo inraisa qaqira sero qaqima santero vuarive. ");
INSERT INTO omw_a_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mwovano vutaqi saiqa vare variariva sia nai vaaqa varareraro nrima ntantero viraitiro, mwiva mwira qaqira sero qaqima sante vuarive. ");
INSERT INTO omw_a_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mwi entara nraaqiara tuaqahi nraasesavata, nraava ni vari nraasesavata, sia suqema varivarave. Ne mwi nraasesara po tuqo. ");
INSERT INTO omw_a_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sia huari itaani entaraqaa aatu vuaro tita né Kotirara aasara tivaro huari itaani entara niarive. ");
INSERT INTO omw_a_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Po, naatiara mwi entara muaara vahiariva nroraqama sero vitarero vahirata nraase qora sia suqema seta varivarave. Haaru Kotiva mwaa mwatara utu toraqaatairo mwitaa hi muaarava sia qovara hurave. Naatiaravata sia mwitaa hiani muaarava qaiqaavata qovara hianarove. ");
INSERT INTO omw_a_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mwi entara muahaa enta vahiratavauma esaa nraase qoravano taiqa vivaro sia kuaiqavantovata qaqi varianarove. So Kotiva nai saama tai nraase qorasara rieqaroma mwi entara vara qiquqama saanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mwi entaraqaa iniara mesaiaa vaiti Kotiva titai vaitiva mwainima variso, mwinima variso, tivera, sia mwisa quara quqaave tiate. Mwi entaraqaa vaiti mwovano qovarama viro unra tiqaro, Ne mesaiaa vaitivanove, tiraro mwo vaitivano tiqaro, Ne Kotira qua qoqamase varu vaitivave, tianarove. Mwisa mwitaa tivaqi viqata airi unra vaitivano qovarama vivarave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mwisa qovarama vita unra saiqa varaqi viqata Kotiva nai saama tai nraase qorasa mwisa tirinravu quara quqaave tiqata api aara vuate tita, nrora saiqa varaqi vivarave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mwi quara rieqatama mwi entaraqaa né rauriqata variate. Né sia mwi vaitisa quara quqaave tiate tina, ne mwaa entaraqaa variqana naatiara qovarama vuani inraisarara ini tiva ni varuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Iesusiva mwitaa tiva sero tiqaro, Naatiara muaara vahiani entava taiqa viraro mwi entaraqaatairo huarivano qipa viraro toravanovata sia itairaro ");
INSERT INTO omw_a_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","aahoquravanove, qovoravanove, uto nti uto nti hiraro naavuni kepusa inraisa vahiariva esaa qasaa qasaa hianarove. (Ais 13:10; 34:4) ");
INSERT INTO omw_a_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mwi inraisava mwitaa hirata esaa mwata maata variasa taqe varivaqe ne mwatani mwatatai nraaqiarava naavusaina tonavuqi tuvuarita ni taqevarave. Ne vuruqama taari inraisava mwoqama sero itero tahuqiro ante anta hi variraqe ne kepusavano tuvuanirave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ne tuviqana naavuniaasa vitaarita mwisa mwatani uto itai itaita Kotiva nai saama tai nraase qorasa esaa uairama seta vitevarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iesusiva mwitaa tiva sero tiqaro, Né qaamuarara rieqatama mwaa quara osara ntapihi seta riaate. Mwi satariva tava riemwa taiqa sero vahiro mwiraqaatairo qaraaha turu ntareraro utisata né mwiraqaa apeqamase taqeta tiqata, Huari nrora itaani entava qaumaqa iso, tiarave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mwira votima seta, naatiara qovara hiani inraisarara tura, né mwiraqaa apeqamase taqeta niara tiqata, Mwiva tuvuani entava qaumatoqa iso, tivarave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ne quqaama tuqo. Mwaa mwataraqaa vari nraase qorasa sia taiqa vivaro mwi inraisara mwi inraisarara tuva qovara hianarove. ");
INSERT INTO omw_a_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Naavuvanovata mwatavanovata taiqa viraro ni quavano qaqiqai vahiqiro vuanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Iesusiva mwitaa tiva sero tiqaro, Ne taireve, nara huari vuqaave, tuvuanira? Sia vaiti mwovano mwi entara ntapihirave. Sia naavuniaasavata mwirara ntapihiarave. Nenavata mwatani mwatatai nraaqiarava variqana mwi entarara sia ntapihi saurave. Kotiva ni qova mwivaqai mwi entara ntapihirave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mwi entava nrianira né sia ntapihiasara tita, né taqe varita rauru seqa tequama variate. ");
INSERT INTO omw_a_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mwi entava nrianirara tirera nara quaqaa ntuva senave tianirave? Mwaa quaraqaa ntuva sena tirerave. Vaiti nroravano niarani virera hiro nai saiqa vaitinravuara tiqaro, Ne vuarita né mwi saiqara mwi saiqara vare varivaqe ne uro ntantena nriase, tiva sero mwo saiqa mwo saiqa mwisa niro vaiti mwora tiqaro, E qetiana variqara vaivaraara ntaqaihi variane, tiva sero so vurave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","(Iesusiva mwitaa tiva sero nai nraaqiaranravu tiva niro tiqaro), Mwi quara rieqatama nevata taqeqata variate. Taireve mwisa nrora vaitivano niaratairo uro ntantero nrianarove? Enta hirera hianiranive? Enta mwutusaqive? Kokoraaravano nruqua tianiranive? Qataa hireraro toqaqive nrianarove? ");
INSERT INTO omw_a_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mwiva qamwanrama nri ntero taqairata né vaite varivorave. ");
INSERT INTO omw_a_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Né mwirara rieqatama ne ininravuaravata esaasaravata mwitaama tina, Né taqe variqata variate tuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mwo ihi mwo ihi mwi mwatanaasa naavuniaava vesahu natoraravata, sia soto mperetiraravata, rieqata mwi entaraqaa mwi sarara nrora. Mwi entara mwi sarara nreva taara enta qaqi vahuvata Kotira nraavuqi Kotira saiqa vara mwate varu vaitisa mwisa vuniaasavata, mwaara osara ti varu vaitisavata, mwisa uairama vita Iesusira ntavaaqavuqita uro ruserara uqetase qua tiqata ");
INSERT INTO omw_a_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","mwitaama tita, Tirenravu vesahu nato sarara nraana entaraqaa Iesusira ntavaaqavu saararo nraase qoraqitairo ntaqi inraisava qovara hiasorave, tura. ");
INSERT INTO omw_a_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mwi entara Iesusiva Betaanini Saimonira nraavuqi uro varura. Tauraa mwi vaitira uhumakara utuvaro varu vaitira. Iesusiva mwi vaitira nraavuqi uro sara nre varuvaro nraase mwovano vera ntero Iesusira suqema mwatareraro vahavera suqe mwunta vura, nrora munima sora, ori taquqi varero uro taqu hiara kinta sero Iesusira qiataqaa rauru sero qumwatora. ");
INSERT INTO omw_a_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mwira qiataqaa rauru sero qumwatovata hini husa nraavu mwiqi varusa mwi nraasera nunurama mwateta nai tiva mwi nai tiva mwi hita tiqata, Qaqao, naraqamave mwitaama sero vahavera mwira qumina taiqa saiso? ");
INSERT INTO omw_a_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mwiva vahavera mwira niro nrora munima 300 kinaa vara sero vehi nraase qora niataarave, tita. Mwitaa tiva seta mwira saara mwi nraasera irora hi varura. ");
INSERT INTO omw_a_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mwisa mwira irora hi varuvaro Iesusiva tiqaro, Qaqi saivaro mwi nraaseva variarive. Naraqamave né mwira irora hiavo? Mwiva mwitaa hiqaro ni suqema mataiso. ");
INSERT INTO omw_a_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vehi nraase qora mwisa mwo enta mwo enta ini sapata variqi vivarave. Né mwo enta mwisa saahaqa hiataa hirata soma saahaqa hivarave. Neqaima sia ini sapata airi enta varianirave. ");
INSERT INTO omw_a_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mwi nraaseva taqaisaro mwi saiqava mwirara soqa hirama varaiso. Ne qaqi variani entaraqaa mwiva nraante vahavera qumateqaroma ni quntama terara tequama hi variso. ");
INSERT INTO omw_a_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ne quqaa qua tianira riaate. Naatiara ni qua mwasaasa esaa mwo mwatanaa mwo mwatanaasa tiva niqi viqata mwaa nraaseva mate vahavera mwaa ni qu matai quaravatama tiva nivata rievarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iesusiva mwitaa tuvaro mwira nraaqiara 12 nravuqitairo mwovano Iutaasi Isikeriotiva mwiqitairo veva ntero Iesusira qovarama saani quara tiva nireraro vuva Kotira nraavuqi Kotira saiqa vara mwate varusa mwisa nrora vaitinravu tiva nuvata ");
INSERT INTO omw_a_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","mwisa mwira quara qamwata seta tiqata, E mwitaa tiarata te quqaaqama seta munima i mwirerave, tuvaro mwiraqaatairo Iutaasiva Iesusira mwisa sauquqi saani aarara huaa hi varura. ");
INSERT INTO omw_a_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mpereti sia sotorara nro entanravuva nruvata toharo entaraqaa sipisipi nraati ruso entaraqaa mwira nraaqiaranravuvano Iesusira sapara hita tiqata, Taraqive te uro tequama mwataarara e vesahu nato entarara rieqarama mwi sarara nrenarave? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tuvaro Iesusiva nai nraaqiara taaratana titero tiqaro, Nétana Ierusaremi mwatusa nroraqi vivaro vaiti mwovano nramari taqu saqa varero nriariva nítana qintorama sairata mwira vataqita vivaro ");
INSERT INTO omw_a_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mwiva nraavuqi vera ntairata nétanavata mwiqi vera nteta nraavu qorara mwitaama tiate, Mwaara ti vari vaitiva iara tiqaro, Ta rumuraqive ne nena nraaqiaranravu sapata vesahu nato sarara nraanirave tiso, tiate. ");
INSERT INTO omw_a_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nétana mwitaa tivaro mwiva nítana rumu nrora verato vahi rumura taintavata mwiqi tequama taisaro vahiraqi tiva nirata so rumu mwiqi sara tequama taate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iesusiva mwitaa tuvata mwitanasa uro mwatusa nroraqi taqovaro esaa inraisara tu quava avuqavuma sero mwivau vahuvata mwitanasa vesahu nato sarara tequama seta mwatora. ");
INSERT INTO omw_a_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tequama seta mwatovaro entama vuvaro Iesusiva nai nraaqiara sapata nruva nraavu ");
INSERT INTO omw_a_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","mwiqi sara nre variro tiqaro, Ne tianira riaate. Iniqitairo mwovano nravutaasa vuqaa ni qovarama saanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mwitaa tuvaro mwira nraaqiaranravu mwutusavano uaqa huvata mwisa kuaiqa kuaiqavano Iesusira sapara hita tiqata, Niarave tira hiaro? Ne sia mwivave. Ne sia mwivave, tivaqita vita. ");
INSERT INTO omw_a_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mwitaa tuvaro Iesusiva tiva niro tiqaro, Ini 12 nravuqitairo mwovano nai mpereti vara sero ni vatama sero tanaaqi mwaati ntava sero nre variariva mwi vaitivama ni qovarama saanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ni mwatani mwatatai nraaqiarara mwitaama seta ruserara haaru qara ntuva torave. Mwi quava quqaa mwivauma vahianarove. Ni mwatani mwatatai nraaqiarara qovarama saani vaitirara ne po tuqo. Mwira nrova sia mwira mwata saataara mwira mwata sairave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mwitaa tuvata sara nre varuvaro Iesusiva mpereti vara sero Kotirara suqeve tiva sero, nteqa sero nai nraaqiaranravu niro tiqaro, Mwaa sarara varaate. Mpereti mwaa ni mwavantama iso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mwitaa tiva sero mwiva uaini kaapu vara sero Kotirara suqeve tiva sero, viti nuvata esaasa kaapu mwiqitaita nrora. ");
INSERT INTO omw_a_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nreta varuvaro Iesusiva tiqaro, Nramari mwaa ni nraarema iso. Kotiva nraase qora sapata kuaaqi uairama viro varireraro qaraaha qua vatarerarove. Mwi quava kepusaqama vuarive tiro, ni nraarevano mwi quara kepusaqama saanarove. Ni ru saivaro ni nraarevano tuviro airi nraase qora saahaqa hianarove. ");
INSERT INTO omw_a_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ne tianira riaate. Ne mate mwaa entaraqaataina hoqarama sena sia uaini nraraitina, qaqi variqi vina naatiara Kotiva ntaqaihianiraqi variqana mwi entaraqaa qaraaha uaini nraanirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iesusiva mwitaa tiva sero nai nraaqiaranravu sapata Kotirara ihi tiva seta veva nteta Oripi taaqiqaa vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mwiravusa mwini varuvaro Iesusiva tiva niro tiqaro, Nénravu ni seta ntuqeqaa hita vivarave. Kotira vukuqi qara ntuva to quava quqaa mwivauma vahianarove. Mwitaama tiro: Sipisipiqaa ntaqaihi vaitira Kotiva rusairata sipisipi mwisa niariara niariara mwona mwona vivarave, turave. (Sek 13:7) ");
INSERT INTO omw_a_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","So naatiara ni qaqi vara tivuma sairaqe variqana ini vuni ne nraante Karirini virerave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mwitaa tuvaro Pitaava qaqao tiro, Esaa mwinravusa i seta aatu ntuqema seta vivaqevata neqai ivatama sena mwaini varianirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pitaava mwitaa tuvaro Iesusiva tiqaro, Ne tianira riaane. Mate entaqi kokoraavano sia taara nani nruqua tirara e taaramwo nani niara tiqara, Sia mwira ntapihurave, tinarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Iesusiva mwitaa tuvaro Pitaava kepusaqama sero qaqao tiro, Sia iara tiqana, Ne sia ntapihurave, tianirave. Ivatamase ni rusaivaqenavata ne sia mwitaa tianirave, tiro. Pitaava mwitaa tuvata Iesusira nraaqiara hini mwisavata kuaa qua mwiraqai tura. ");
INSERT INTO omw_a_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mwiraqaatairo Iesusiva nai nraaqiaranravuvata vuva uro saqava ututora mwira nrutu Kesemaniqi nrintero nai nraaqiaranravuara tiqaro, Nénravu mwaana mwatasaa vita varivaqe ne vuturaqi uro Kotiravata qua tiase, tiva sero ");
INSERT INTO omw_a_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pitaaravata, Ioniravata, Semisiravata, mwiravusaqai vita varero viro. Mwiravusaqai vita varero vuvaro mwira sia suqe huvaro ");
INSERT INTO omw_a_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","taaramwo mwinravusara tiqaro, Ni mwutusavano nroraqama sero muaara ntero nriqa viqaro ni rusaa qara hisanama varuqo. Nénravu nivatama seta mwaaqaa variqatama vu ntapairi seta viti viri taqe variqata variate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mwitaa tiva sero mwiva pataqa vututo viro uro mwataqaa uto ntiro Kotira sapara hiro tiqaro, Mwo aara vahirera, ne sia muaara vahi aararaqaa vuase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mwitaa tiva sero mwiva tiqaro, Po siave, kaao, e esaa saiqa so vare variaravave. Ne nriqa vuani nramarira nraani kaapura e mwi kaapura vara qaqinani saane. Ne mwitaa tiariravata sia ni mwutusa vahira vataqira vuane. Ena mwutusa vahira vataqira vuane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iesusiva mwitaa tiva sero uro ntantero nai nraaqiara taaramwonravu sonani nrima taqovata mwinravusa vuvano tautovata vaite varuvaro mwiva Pitaarara tiqaro, Saimonio, e vaiteve variaro? Naraqamave nénravu nivata pataqa variqata sia vu ntapairi seta viti viri taqe variqata variavo? ");
INSERT INTO omw_a_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Iniara mwisa uaqa hi saiqara utuate tiro, Saataaniva ini mwataara hiasora mwirara rieqata taqe varita Kotirara aasara nteqata variate. Ini mwaraquravano mwitaa hiataa hisaro ini mwavantavanoqai sia kepusaqa isata variavo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mwitaa tiva sero Iesusiva qaiqaa mwisa mwini sero uro Kotiravata qua tireraro mwiva vaasa tu quara mwi quaraqai qaiqaa tiro tiva taiqa sero ");
INSERT INTO omw_a_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","uro ntantero nrima taqovata mwira nraaqiaranravu vu tautovata qaiqaa vaite varura. Iesusiva nri ntovata mwisa tivita sauriqata Iesusira tiva mwi quava sia vahuvata varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iesusiva qaiqaavata uro Kotiravata qua tiva taiqa sero uro ntantero nrima taqovata mwisa qaiqaa vaite varuvaro Iesusiva tiqaro, Qike, nénravu tesa hiqatave vaite variavo? So taqaate. Ni tu vare entava nrima ntaiso. Ni mwatani mwatatai nraaqiarara ni ntavaaqavuqita uro uaqa hi saiqara uti variasa sauquqi tuta sevarave. ");
INSERT INTO omw_a_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tivivaqenravu vuare. Ni qovarama saari vaitiva nrima variso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesusiva mwi quara ti varuvaro mwira nraaqiara 12 nravuqitairo Iutaasiva nrintero. Iutaasiva uro ntovata mwiravata vaiti airivano paipavata, saavuvata, tu vareta vura. Kotira nraavuqi Kotira saiqa vara mwate varu vaitisa mwisa nrora vaitinravuvata, mwaara osara ti varusavata, Iutaa nrora vaitinravuvanovata, mwisa mwi vaitisa titovata mwisa Iutaasira vatama seta nrura. ");
INSERT INTO omw_a_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nruvaro Iutaasiva Iesusira qovarama saanirara mwisa tiva niro mwitaama tiro: Ne mwira qua mwanteqana mota saani vaitira mwira mwivave. Né mwira ntavaaqavu seta mwiraqaa suqemase ntaqaihiqi vita uro saate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iutaasiva mwitaa tiva sero mwisa sapata nrintero mwiva qamwanrama sero Iesusiva varunani nrintero tiqaro, Mwaara ti variara vaitio, tiva sero mwira mota sero. ");
INSERT INTO omw_a_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Iutaasiva Iesusira uro mota sovata Iutaasiravata nrusa uro Iesusira ntavaaqavu sovaro ");
INSERT INTO omw_a_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iesusira nraaqatairo mwira nraaqiara mwovano paipa nai tuaqitairo veva ntarau sero mwiraqotairo vaiti mwo nraato teqa sovaro uto ntura. Kotira nraavuqi saiqa vare varusa mwisa vuniaa vaiti mwira saiqa vaiti nraato teqa sora. ");
INSERT INTO omw_a_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mwitaama sovaro Iesusiva Iutaasiravata nru vaitisara tiqaro, Qike, né kamaniravatama seta ntaqua vaitisa vitarerata nriantema seta ni vitarerata paipavata saavuvata varetave nriavo? ");
INSERT INTO omw_a_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ne mwo enta mwo enta Kotira nraavuqi variqana nraase qora qua mwasaasa tiva ni varuqata né mwi entara sia ni ntavaaqavuarave. Kotira vukuqi mwitaa hirara qara ntuva tova vaiso. Mate mwi quava mwivauma vahianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iesusiva mwitaa tuvata mwisa mwira ntavaaqavu sovata esaa mwira nraaqiaranravuvano mwira seta aatu ntuqeqaa hita vivura. ");
INSERT INTO omw_a_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Qaraasa vaiti kuaikuvanoqai mpuruqa koritua rupatova Iesusira vataqiro virera utuvata mwisa mwira taqeta uro mwiravata ntavaaqavu saare tita, ");
INSERT INTO omw_a_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mpuruqa mwi tuaraqai tu varovaro mwi vaitiva tosavano santero vura. ");
INSERT INTO omw_a_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mwira nraaqiaranravuvano aatu vuvata mwisa Iesusira vita vareta Kotira nraavuqi saiqa vare varusa mwisa vuniaa vaitivano varuraqi uro sovata Kotira nraavuqaa ntaqaihi varusa esaa hininravu nroraqama vusavata, Iutaa nrora vaitinravuvata, mwaara osara ti varu vaitisavata, mwisa esaa nraavu mwiqi uairama vita varura. ");
INSERT INTO omw_a_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Iesusira vitaqita uro seta varuvaro Pitaava vutura niarasata viqaro mwisa vataqiro vuva vuniaa vaiti nraavu maata vahunani nrintero vutaqi mwaati ntero mwatusa mwiraqaa ntaqaihi varusa sapata mwatasaa viro variqaro tia taare varura. ");
INSERT INTO omw_a_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pitaava mwaata mwini varuvata Kotira nraavuqi saiqa varosa nronranravuvata, esaa nrora vaiti mwiqi uairama vita varusavata, Iesusiraqaa qua vateta mwira rusaare tita, mwo quara huaa huvaro sia vahuvata qumina mwira ruse quarara huaa hi varura. ");
INSERT INTO omw_a_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sia qua vahuvata vaiti airivano apiqama seta Iesusiraqaa unra quaqai vateta ti varuvaro mwisa quavano mwo qua mwo qua vahiro, sia kuaa qua vahura. ");
INSERT INTO omw_a_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mwitaa tivaqita vuvata mwo husa Iesusiraqaa unra qua vateta tiqata, ");
INSERT INTO omw_a_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Iesusiva mwitaa tisata te riaunarave. Mwiva tiqaro, Ne Kotira nraavu vaitivano niari sauquqo hoqataara ntapairi sena ne taaramwo enta variqana sia sauquqo vareqana qaiqaa nraavu mwira hoqa saanirave, tirave, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mwi vaitisa mwi quaravata tiqata sia ntapihi seta kuaa qua turama. ");
INSERT INTO omw_a_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mwitaa tuvaro Kotira saiqa vara mwate varusa mwisa vuniaa vaitivano mwisa vuqaa tiviro Iesusira sapara hiro tiqaro, Mwisa mwitaama seta iqaa qua vateta ti variavo. E mwo? Mwisa mwi quara iara tiara e nara quave niari tiva ninarave? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tuvaro Iesusiva sia qua tiraitiro, tirema varuvaro qaiqaa mwiva mwira sapara hiro tiqaro, Quqaave Kotiva i titaisara e tiri saahaqa hirava mesaiaa vaitivano variaro? Quqaave e Kotira mwaaquvano variaro? Tiri tiva timwiraqe riaare, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mwiva mwitaa tuvaro Iesusiva tiqaro, Ne mwaa mwivave. Né naatiara taqaivaqe ne mwatani mwatatai nraaqiarava nroraqama vina Kotiva kepusavano varianira mwira sauqu tanarani varina tonavuqi tuvuanirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iesusiva mwitaa tuvaro Kotira saiqa vara mwate varusa vuniaa vaitivano nai tuavaaqa nrahitu sero tiqaro, Qike, qumina vaiti saatavano mwiraqaa qua vatesa nraarevorave. ");
INSERT INTO omw_a_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Riaate. Né airivano variavaro mwiva Kotira vuqaa variqaro uaqa hi quara tiso. Mwira saara né nareve Iesusirara tivarave? Tivaqe riaase, tiro. Mwitaa tuvata mwisa tiqata, Mwira qora saiqavano nritaraiso. Mwira saara mwira rusaaravaqaima vaiso, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mwitaa tiva seta hini husa uro Iesusiraqaa taara vihise mwiraqaataita Iesusiva sia so taqaarive tita, mwira vuqaa mpuruqaqo rupateta vireraqama seta mwira ntuqutu seta tiqata, Tavave i ntuqutiso? Sia taqaraitira, i ruani vaitira nrutu tiraqe riaare, tita. Mwitaamaqi vita Iesusira uaqama mwatovata piriponravuvanovata mwira vita seta sauquqo ntuqutuqita vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nraavuqi Iesusira uaqamaqita vi varuvaro Pitaava mwaatani mwatusaqaa mwatasaa viro varuvaro vuniaa vaiti mwira saiqa nraase mwovano nritareqaro taqovaro ");
INSERT INTO omw_a_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pitaava tia taare varuvaro mwira ntapihi sero taqero tiqaro, E Iesusira Nasaretiniaa vaitintiri variaravave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tuvaro Pitaava qaqao tiro, E nara quave tiaro? E tiana quara ne siama ntapihuqo, tiro. Pitaava mwitaa tiva sero uro qetiana varuvaro kokoraavano nruqua tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pitaava mwini varuvaro saiqa nraase mwiva qaiqaa mwira taqero mwini tivita varusara tiqaro, vaiti mwiva mwira nravunaave, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pitaava qaqao siaveqai, tiro. Mwitaa tiva sero pataqa varuvata qaiqaa mwini tivita varusa Pitaarara tiqata, Iesusira nraaqiaranravu Kaririniaasa variavara quqaama evata mwiniaavama variaro, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mwisa mwitaa tuvaro Pitaava sauqu nriqiqaa vatero tiqaro, Ne unra tiasera Kotiva soma ni ruanarove. Ne quqaama tuqo. Né ti varia vaitira ne sia mwira taqaurave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mwitaa tuvaro qamwanrama sero kokoraavano qaiqaa nruqua tuvaro Pitaava mwiraqaatairo Iesusiva tiva mwu quara mwirara riero. Iesusiva Pitaara tiva mwiqaro mwitaama tiro: Mate entaqi kokoraavano sia taara nani nruqua tirara e taaramwo nanima niara tiqara, Ne sia mwira taqaurave tinarave, tu quara mwirara riovaro mwira mwutusavano uaqa huvaro Pitaava ntatora. ");
INSERT INTO omw_a_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mwira qararaara toqaqi Kotira saiqa vara mwate varu vaitisa mwisa nrora vaitinravuvata, Iutaa nrora vaitinravuvata, mwaara osara ti varu vaitisavata, esaa kaanasorinravuvata, mwisa uairama vita variqata mwisa qua ti osarara tiva avuqavuma seta Iesusira seniqotaita mwira rupa vareta Pairaativa kamanira nrora vaitivano varuraqi uro sora. ");
INSERT INTO omw_a_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Uro sovaro Pairaativa Iesusira sapara hiro tiqaro, Quqaave e Iutaa vuniaa vaitivano variaro? tuvaro Iesusiva tiqaro, E tianara ne mwaa mwivama iso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mwitaa tuvata Kotira saiqa vara mwate varu vaitisa mwisa nrora vaitinravuvano mwo qua mwo qua saara Iesusira irora hi varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pairaativa mwisa qua rieqaro qaiqaa Iesusira sapara hiro tiqaro, E siave mwira hiniqama niariara tinarave? Mwisa airi qua saara i irora hi variavo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mwitaa tuvaro Iesusiva qaiqaa sia qua tiraitiro, kepusaqama sero varuvaro Pairaativa airi nraato ti varura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mwo ihi mwo ihi vesahu nato sarara nro entaraqaa kamanira vuniaa vaitivano nraase qora qamwata natareraro karavu vaiti mwo avantu sero titovaro mwaatani vura. Nraase qoravano mwi vaitira avantu tiva taane tuvaro mwi vaitira avantu nate varura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mwi entara vaiti mwonravuvano kamaniravata ntaqura saara karavuqi varuvaro mwi vaitinravusaqitairo mwovano mwira nrutu Varavaasiva mwiva vaiti rusora saara karavuqi varura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","So mwi entaraqaa nraase qoravano uairama vita variqata karavu vaiti avantu saanira mwirara rieqata uairama vita varuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pairaativa mwisa sapara hiro tiqaro, Ne karavuqitaina ta vaitirave avantu nataanirave? Iutaa mwatanaa vuniaa vaiti mwirave ne avantu nataanirave? Né tiva mivaqe riaase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pairaativa ntapihi sovata nrora vaitinravuvano Iesusiva nroraqama vuasorave tita, Iesusira irorama mwateta mwisa mwira vitaqita uro Pairaatira sauquqi tuta sora. ");
INSERT INTO omw_a_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pairaativa karavu vaiti tarave avantu nataanirave tiva sero, nraase qora sapara huvata Kotira saiqa vara mwate varu vaitisa mwisa nrora vaitinravuvano uro nraase qora vutaqaa variqata kepusa qua mwisa tiva nita tiqata, Sia Iesusira avantu tiva taane. Varavaasira avantu tiva taane tiate, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mwi nraase qorasa vusu tuvata mwisa Varavaasira avantu tiva taane tuvaro Pairaativa qaiqaa nraase qora sapara hiro tiqaro, Né Iesusirara tiqatama, Iutaa vuniaa vaitivanove, tiarave. Ne mwi vaitira nataave hianirave? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mwitaa tuvata mwisa aasara nteta tiqata, Mwira satariqaa rutaate, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mwitaa tuvaro Pairaativa qaiqaa mwisa sapara hiro tiqaro, Mwiva nara uaqa hi saiqara utu saisatave mwitaa tiavo? tuvata mwisa qaqiqai paatita aasara nteta tiqata, Mwira satariqaa rutaate, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mwisa mwitaa tuvaro Pairaativa nraase qora qamwata natareraro Varavaasira avantu natero mwiraqaatairo nai ntaqu vaitisara Iesusira saavuqo ntuqutuate tuvata mwisa mwira saavuqo ntuqutu sovaro mwiraqaatairo mwira satariqaa rutaate tiro, Pairaativa Iesusira nai ntaqu vaitisa sauquqi tuta sora. ");
INSERT INTO omw_a_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pairaativa nai ntaqu vaitisa sauquqi Iesusira tuta sovata mwisa mwira vitaqita uro kamanira nraavuqi seta mwisa niari hena ntaqu vaitisa esaa nraarama uairama seta ");
INSERT INTO omw_a_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","mwira vireraqa hiqata vuniaa vaiti mpuruqa nraare mpuruqa rupa mwateta mwiraqaataita kauvera vara seta qiata vaiti tave voti hura ququrama seta Iesusira qiataqaa qumwa tora. ");
INSERT INTO omw_a_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mwitaama seta niari sauqu vuasaaraqaa vateqata kumwaari mwitaa tita tiqata, Iutaa vuniaa vaitio, variqarave? tita. ");
INSERT INTO omw_a_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mwitaa tiva seta mwisa saavuqotaita mwira qiata ntukavu seta, mwiraqaa taara vihi seta, mwira vuqaa tori sauru ravi variqata qaqi vireraqama seta mwira qamwata mwateqata varura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mwitaamaqi viqata vireraqamase raima mwateta mwiraqaataita mwisa nraare mpuruqa rupa mwatora avantu seta nai tuavaaqa utu mwateta mwira satariqaa niri ruseta hiritarerata Iesusira vita vareta vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ntaqu vaitinravusa Iesusira satariqaa niri ru seta hiritaare tita, mwira vita vareta mwatusa mwaaqani aaraqaa vi varuvaro vaiti mwovano mwira nrutu Saimoniva mwatusa nroraqi virera huvata mwisa mwira antuase kepusaqama seta tiqata, Iesusira ru seta hirite satarira vara quqira uro vataane, tuvaro Saimoniva vara quqiro uro mwatora. Saimoniva mwata Sairininiaava mwiva Arekisantaasa Rupusa qova varura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mwisa Iesusira vitaqita uro qumina mwata Korokotaave tunani sora. Korokotaa mwaa quaraqitai tirera, Qiata Mwusaariqaave, tunani Iesusira uro sora. ");
INSERT INTO omw_a_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Uro seta uaini mwiqi ukavu inraisara tuqataase vato nramarira mwira mwirera huvaro Iesusiva sia nrero. ");
INSERT INTO omw_a_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sia nrovata mwisa mwira satariqaa niriqotai ruseta mwira tuavaaqa vara seta tasa tasave so varevarave tiva seta, kaati ruantema seta ori tuto seqata mwira tuavaaqa tusama seta varora. ");
INSERT INTO omw_a_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Toqaqi huarivano nriro virisataqaa huvata Iesusira satariqaa rutora. ");
INSERT INTO omw_a_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mwira satariqaa ruteta Iesusira qiatani qua mwo, mwira ko tiva mwato quara qara ntuva teta satariqaa rutora. Mwi quava mwitaama tiro: IUTAA VUNIAA VAITIVE, tiro. Mwi qarava mwitaama sero vahura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mwisa Iesusira satariqaa ruteta Iesusira vatama seta vaiti taaratana rutora. Mwitanasa muara vare varutanasa varuvata mwo Iesusira sauqu tanarani niri ruteta mwo Iesusira sauqu saanaaqani niri rutora. ");
INSERT INTO omw_a_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Iesusira vatama seta mwitaama rutorara tiro, Kotira vukuqi qua mwo qara ntuva tova mwivau vahura. Mwitaama tiro: Mwiva uaqa hi vaitisa vatama sero varianarove, tura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mwitaamase rutovata nraase qoravano vitare nritare hiqata viri taqeta niari mwauru miqi seqata Iesusirara uaqa hu quara tiva mwateta tiqata, Qike, e tiqarama, Kotira nraavu ntapairi senama taaramwo entaqaa saiqa vareqanama qaiqaa hoqa taiqa saanirave, tiaravave? ");
INSERT INTO omw_a_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","So ena saahaqa hiane. E satariqaataira miavi ntaane, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mwisa mwitaa ti varuvata mwisa tuntema seta Kotira saiqa vara mwate varusa mwisa nrora vaitinravuvata, mwaara osara ti varu vaitisavata, mwisa Iesusirara raima mwateta tiqata, Mwiva mwosaqai saahaqa hi variva siama so nai saahaqa hirove. ");
INSERT INTO omw_a_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mwiva Kotiva titai vaitiva mesaiaa vaitivanove, Isareri vuniaa vaitivanove, tiavata riaunarave. Sai te variqata taqaararo mwiva satariqaatairo miavi ntero tuvirera, te mwirara quqaave tiare, tita. Mwisa mwitaa tuvata mwisa nraantanteta muara vaititana Iesusira vatama seta rutotanasa, mwitanasavata mwira uaqa hu quara tiva mwate varura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mwitaa huvaro ihara mwutusa tavaara esaa mwi mwataraqaa entama tero vahiqi vuvaro huarivano vitira tavaarana tuvi vuvaro qaiqaa ntuvaahama vura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Qaiqaa ntuvaahama vuvaro Iesusiva nai quaqitairo aasara ntero tiqaro, Eroi, Eroi, rama sapakitani—Kotio, Kotio, naraqamave ni qaqira sera hiarao? tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iesusiva mwitaa tuvata mwo husa mwini tivita varusa mwira qua rieta tiqata, Mwiva Iraisaara tiri haivaqara nraaraiso, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","mwovano santero ukavu uainira saqa sero saavu kati sero mwiraqaa huairi sero viri Iesusira nrona vatero tiqaro, Sai variqata taqaararo Iraisaava mwira saahaqa hireraro tuvuanira taqaare, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mwitaa tuvaro Iesusiva nroraqama sero aasara ntava sero qutu vura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iesusiva qutu vuvaro Ierusaremini Kotira nraavuqi taakusa voti hura mpuruqa nrora hiritova viritairo vutaqaa nrahituqiro tuviro miani uto sora. ");
INSERT INTO omw_a_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ntaqu vaitisa vuniaava Iesusira ruto satarira nraaqani varuva taqovaro Iesusiva nroraqama sero aasara ntava sero qutu vuvaro mwiva tiqaro, Qike, quqaama vaiti mwaava Kotira mwaaqu variva qutu viso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Iesusiva qutu vuvata nraase mwonravuvano niarasata variqata taqe varura. Mwinravusaqitairo hininravu nrutu vahireraro. Mariaava Makataraniaava mwo, Mariaava Semisiva naatiaraa vaiti mwiravata Iosisiravata nrova mwo, Saromeva mwo, mwisa mwini varura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nraase mwinravusa Iesusiva Karirini nruo entara mwira vataqita nrueqata mwira saiqa saahaqama mwato nraasenravusa varuvata nraase mwonravuvata mwini varura. Mwisa Iesusiravatama seta nrusa Ierusaremini varura. ");
INSERT INTO omw_a_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Entama virera huvaro Sosepiva Arimatianiaava nri ntora. Mwi vaitiva vaiti suqeva kaanasorivano variqaro Kotiva ntaqaihiani entava nrianirara taqeqaro mwira vesa varuva nri ntero, hura Iutaa mwaara enta vahianirara riero sia aatu hiraitiro, uro Pairaatirara Iesusira mwavantara sapara hiro tiqaro, Mwira miraqe varaqina uro quntaase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mwitaa tuvaro Pairaativa Iesusiva qamwanrama qutu vurara airi nraato tiro ntaqu vaitira mwo nraarama sero sapara huvaro mwi vaitiva tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","So quqaama qutu viso, tuvaro Pairaativa Sosepirara tiqaro, Soma mwira mwavanta varaqira uro quntama tenarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mwitaa tuvaro Sosepiva eqarori mpuruqa soqaama sero Iesusira mwavanta satariqaatairo itu sero eqarori mpuruqa mwiraqotairo qapuqama sero uro vaiti quntarera ori vaurutoraqi vera vatero ori nrora mwo raaqutaqiro uro mwira nrona tita tora. ");
INSERT INTO omw_a_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariaava Makataraniaavavata, Mariaava Iosisira nrovavata, taqe varuvata Iesusira oriqi vera vatora. ");
INSERT INTO omw_a_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Saarareqa Iutaavano mwaara tu entava taiqovata Mariaava Makataraniaa nraasevanovata, mwira qamwava Semisira nrovavata, Saromevavata, mwi nraasenravusa munima seta suqema sero mwunta vu inraisara vareta Iesusira mwavantaqaa qumwatarerata vura. ");
INSERT INTO omw_a_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Saante toqaqi huarivano mate nrintoraqi mwinravusa Iesusira quntama toraqiara vura. ");
INSERT INTO omw_a_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aarani viqata mwinravusa nai sapara hi nai sapara hi tiqata, Te mwini uro ntaararo tavave ori nrora qetiana titataara vara saanarove. Ori mwira nrora nrusi ntava taarave, tita. ");
INSERT INTO omw_a_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mwitaa tiva seta mwinravusa nri nteta taqovaro ori nrora mwira nrusi raaqu sovaro qaqinani vahura. ");
INSERT INTO omw_a_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Orivano mwitaama vahuvata taqeta mwinravusa oriqi vera nteta taqovaro vaiti mwo qaraaha vaitivano eqarori tuavaaqa ututo vaitiva mwiqi hini saataaqi mwatasaa viro varura. Mwiva mwiqi varuvata mwira taqeta aatu huvaro ");
INSERT INTO omw_a_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","mwiva mwisara tiqaro, Sia aatu hiate. Iesusira Nasaretiniaara satariqaa rutaa vaitira, nénravu mwirarave huaa hi variavo? Mwiva sia mwaaqi variso. Mwiva qaqima tiviso. Nénravu mwaini taqaate. Mwaaqi mwira vataaraqi siama variso. ");
INSERT INTO omw_a_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","So mwaa quara vareta uro mwira nraaqiaranravuvata, Pitaaravata, tiva niate. Mwitaama tiva niate: Mwiva nraante ini vuni Karirinima viso. Nénravuvata mwini vita uro mwira taqevarave. Tauraa qaqi variqaro mwirara ini tiva nura mate mwivauma vaiso. Mwi quara tiva niate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mwiva mwitaa tuvata aatu hiqatara tita, mwinravusa Iesusira quntama toraqitaita veva nteta santama teta aarana viqata sia mwosavata tiva ninraitita, vura. ");
INSERT INTO omw_a_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesusiva Saante toqaqi qutu vuraqitairo tiviro vuni mwiva Mariaara Makataraniaara vuqaa nraante qovarama vura. Haaru Iesusiva nraase mwira vutaqitairo vaana 7 nravu titovata nritare vu nraasera vuqaa qovarama vuvaro ");
INSERT INTO omw_a_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariaava uro Iesusira nraaqiaranravu tiva nireraro vuva uro taqovata mwisa Iesusirara ntate varura. ");
INSERT INTO omw_a_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ntate varuvaro mwiva mwisa tiva niro tiqaro, Iesusiva qaqima tiviro variso. Ne nena vuqotaina mwira taqauqo, tuvata mwisa sia mwira quara quqaave tura. ");
INSERT INTO omw_a_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mwi entara Iesusiva mwo qarama mwo qarama sero nai nraaqiara taaratana vuqaa qovarama vura. ");
INSERT INTO omw_a_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mwitanasa aaraqaa vi varuvaro Iesusiva qovarama vuvata mwisa mwira taqeta uro ntanteta nrima hini mwisa tiva nuvata mwisa sia mwitanasa quara quqaave tura. ");
INSERT INTO omw_a_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","So naatiara esaara Iesusira nraaqiara 11 nravuvano sara nre varuvaro Iesusiva mwisa vuqaa qovarama vura. Iesusiva qaqi tiviro varuvata mwo husa mwira taqeta uro Iesusira nraaqiaranravu tiva nuvata mwisa mwi quarara unra quave tiva seta varuvarora tiro, Iesusiva niari vuqaa qovarama viro mwira saara mwisa irora hiro tiqaro, Né mwi quarara quqaave tiataara vaisatama né kepusaqama seta variqata sia quqaave tiavo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mwitaa tiva sero mwisa tiva niro tiqaro, Né esaa mwata maata nrueqata esaa nraase qora suqe qua mwaa tiva niate. ");
INSERT INTO omw_a_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tiva nivaro ni quara quqaave tiva sero, nramari varaani vaitira, mwirama Kotiva so vitaanarove. Ni quara sia quqaave tiani vaitira Kotiva sia mwira vitaraitiro, mwiraqaa qua vataanarove. ");
INSERT INTO omw_a_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ni quara quqaave tisa, mwisama nrora saiqa mwataa hianira so varevarave. Mwisa ni nrutu nteqatama vaana titaivata vivarave. Mwisa mwo mwatanaa mwo mwatanaa quavata so tivarave. ");
INSERT INTO omw_a_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mwisa quaiha tu varaivaro mwi inraisava sia mwisa ruanarove. Mwisa tuhi nramari nraivaro tuhi nramarivano sia mwisa ruanarove. Mwisa nriqa visaqaa sauqu vataivata mwisa suqema vivarave, tiro. Turama. ");
INSERT INTO omw_a_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nroravano Iesusiva nai nraaqiaranravu sapata qua tiva ni taiqa sovaro Kotiva mwira naavuni vitero vuvaro mwiva mwini nroraqama viro Kotira sauqu tanarani mwatasaa virera vurama. ");
INSERT INTO omw_a_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iesusiva naavuni vuvata mwira nraaqiaranravuvano mwata maata vahuntema nrueqata Iesusirara tiva ni varuvaro nroravano Iesusiva mwisa saahaqa hi varuvaro mwisa saiqavano kepusaqama viro nritarero vahuvatara tita, nraase qoravano taqovaro mwisa quavano quqaa quaqai vahura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Haaru toharero quavano varura. Mwi quava Kotisantiriro varura. Mwi quava nai Kotiva varura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tauraa toharero mwi quava Kotisantiriro variqiro vura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mwiva Kotisantiriro variqi viqaro mwo inraisa mwo inraisa esaa inraisa utu sero vatora. Mwovanovata mwo inraisa utuariva sia varuvaro qua mwivaqai esaa inraisa utu sero vatora. ");
INSERT INTO omw_a_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mwi quava qaqi variqi vi variara tuqavanoma variro. Mwi quava ova votima sero itamaqiro viqaroma nraase qora suqema sero ntuvaahama natero. ");
INSERT INTO omw_a_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ovavano rupi hiraqi itamaqiro visaro siama enta hi inraisava mwira qipa saariva vahiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kotiva vaiti mwo titora mwira nrutu Ioniva. ");
INSERT INTO omw_a_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nraase qoravano Iesusirara mwiva quqaa ovavanove tiate tiro, Ioniva mwirara tiva nireraro nri ntora. ");
INSERT INTO omw_a_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ioniva nai sia mwi ovava variraitiro, mwiva ova mwirara tiva nireraro nrura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mwiva nri ntovaro mwira naatiara quavano nri ntero ova votima sero itamaqiro viqaroma esaa mwaa mwataraqaa nraase qora ntuvaahama natero. ");
INSERT INTO omw_a_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iesusiva nai mwaa mwatara utu sero vatova mwatani tuvuvata mwaa mwatanaasa sia mwira ntapihise taqaraitita, mwirara sia mwivave tita. ");
INSERT INTO omw_a_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mwiva nai nravunaasa hunani nri ntovata mwira nravunaasa sia mwira sasama mwataraitita, mwira qoririma mwatora. ");
INSERT INTO omw_a_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mwitaahuvatavata mwo husa mwira sasama mwateta mwirara quqaa mwivave tura. Mwitaa tusa mwisa mwiva nroraqama sovata mwisa Kotira nraaqiaraqama vita varura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sia nraasevano nraaqiara mwataintema sero mwisa mwata taisata Kotira nraaqiaraqama vita variara. Sia qumina vaiti sasa hiraqaa Kotira nraaqiaraqama vita variara. Nai Kotira sasa hiraqaa mwisa Kotira nraaqiaraqama vita variara. ");
INSERT INTO omw_a_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kotira quavano vaiti tuero tirivata varireraro tuviro. Mwiva tuviro mwaa mwataraqaa varuvata te mwira kepusa osara taqaavanara. Te taqaavararo mwi vaitiva suqe hiro vaitiara mwoqama sero po se tiva nateqaro quqaa quaqai ti varuva varura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioniva nraase qora tiva niro tiqaro, Ne haaru ini tiva nina tiqana, vaiti mwovano ni naatiara nriariva ni naataraanarove, tuva so mwaa mwi vaitivave. Ne sia qovara hiava entara mwiva haaru qaqi variqiro vurave. Mwitaama variqarora tiro, mwi vaitiva ni naatara sero mwiva nroravano variso, tiro. Ioniva mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iesusiva mwoqama sero tiriara nraamwunriqa taisaro mwiva tiriara po se tiva timwatero airi nani tiri suqema timwate varira. ");
INSERT INTO omw_a_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Haaru Kotiva nai qua mwaara nraase qoravano sia nteqa saraitita, qaqiqai riemwaqita vuate tiro, Mosesira mwura. Mate mwaa entara Iesusi Karaisiva Kotiva hinatairo uto Kotiva po se tiva timwatai osarara, quqaa osara tiri timwira. ");
INSERT INTO omw_a_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Sia qumina vaiti mwovano Kotira taqairave. Mwira mwaaquvano nai qora tataaqani variva, mwivaqai nai qora osara qovarama saisata te taqeta ntapihunara. ");
INSERT INTO omw_a_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ioniva Iesusirara tiva nu quava mwataamama vahiro. Ioniva nri ntovata Iutaa vaiti nroranravuvano Ierusaremini varusa vaiti mwonravu titovata Kotira nraavuqi Kotira saiqa vara mwate varusavata, Rivaira kuaa osara mwonravuvanovata, mwisa uro nteta Ionira sapara hita tiqata, E ta vaitivave? (E quqaa tiri mesaiaa vaitivanove variaro?) tita. ");
INSERT INTO omw_a_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mwisa mwitaa tuvaro Ioniva sia qua quqetaraitiro, vutu sero tiva niro tiqaro, Qaqao, sia ne Kotiva titai vaitiva mesaiaavano varuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tuvata mwisa mwira qaiqaa sapara hita tiqata, E sia mwivave tiqara, e mwo tavave hiaro? E tiri haivaqava, Iraisaavave variaro? tita. Tuvaro Ioniva qaqao, Ne sia mwivave, tiro. Tuvata mwisa qaiqaa mwira sapara hita tiqata, E ta vaitivave? Te poropeti vaiti mwo mwira vesama varuro. E mwivave hiaro? tuvaro Ioniva qaqaoqai tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mwitaa tuvata mwisa tiqata, E tavave hiaro? Tiva timwiraqe te nrima ntanteta tiri titaa vaitisa iara uro tiva niare. E enara tavaveve tira hiaro? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mwisa mwitaa tuvaro Ioniva tiva niro tiqaro, Ne qumina sata variqana aasara nteqana tiqana, Aara avuqavuqama taivaro nroravano nriarive, ti varuvama varuqo, tiro. (Ais 40:3) Haaru poropeti vaiti Asaiaava tu quara Ionivavata tura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ioniva mwitaa tuvata Parisi vaitinravuvano titosa tiqata, ");
INSERT INTO omw_a_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","E tiriara ne sia mesaiaa vaitivano varuqo tiaro. Sia ne Iraisaavave tiaro. Sia ne poropeti mwivave tiaro. So naraqamave qumina vaiti varuqo tiarava nramari ni variaro? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tuvaro Ioniva mwinravusa tiva niro tiqaro, Ne qumina nramariqaima nraase qora ni varuqo. Mwovano ini vutaqaa varira né sia mwira taqaarave. ");
INSERT INTO omw_a_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mwiva ni naatiara nrivave. Ne pata vaiti varuqaro mwiva nrora vaiti varisanara tina, ne siama so mwiva suqu nraavu rupa tai saantara avantu mwataanirave, tura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ioniva Betaani mwaata Sotaani nramari qarahi hini variqaro nramari ni varu entara mwi quara tura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mwira qararaara Ioniva variqaro taqovaro Iesusiva mwitairo nri varuvaro mwiva tiqaro, So taqaate. Mwiva Kotira sipisipi nraative. Mwiraqaama Kotiva mwatani variasa uaqa hi saiqara utira taiqa nataanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ne haaru tiqana, vaiti mwovano ni naatiara nriariva ni naataraanarove. Ne sia qovara hiava entara mwiva haaru qaqi variqiro vurave. Mwitaama variqarora tiro, mwiva ni naatara sero nroravano varianarove, tu vaitiva, mwaa mwivave. ");
INSERT INTO omw_a_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tauraa sia ne mwira ntapihi taqaurave. Né Isareri nraase qoravano mwira ntapihise taqaate tina, ne mwaini nrima variqana nramari ini ni varurave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mwitaa tiva sero Ioniva Iesusirara mwisa vutusero tiva niro tiqaro, Ne taqauqaro Kotira Mwaraquravano mwuku voti hiva atantiro tuviro uto mwiraqaa varirave. ");
INSERT INTO omw_a_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tauraa ne sia Iesusira ntapihi taqe varuqaro Kotiva ni titaisana ne nramari ini ni varuqaro Kotiva ni tiva miro tiqaro, E taqairaro ni mwaraquravano vuariva uto mwiraqaa variani vaitira so mwirara mwivave tiane. Mwiva sia qaqi nramari nianarove. Mwiva nraase qora ni mwaraqura niarivave, tirave. ");
INSERT INTO omw_a_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kotiva ni mwi quara tiva misana ne mwi inraisara suqema sena taqena ne mwirara mwaavama Kotira mwaaquve tuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mwira qararaara Ioniva nai nraaqiara taaratana mwira vataqita nruotanavata tiviro varuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iesusiva nritarero vuvaro Ioniva mwira vutu taqero, mwitana tiva niro tiqaro, Taqaate. Mwiva Kotira sipisipi nraative, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mwitaa tuvata Ionira vataqita nruotana Ioniva tu quara rieta, mwiraqaatai tuqataa vita Ionira mwini seta Iesusira vataqita vura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Vuvaro Iesusiva tuqataa viro taqovata mwitana mwira vataqita nruvaro mwiva tiqaro, Nétana nararave nriavo? tuvata mwitanasa tiqata, Rapai — Mwaanra ti variara vaitio, e taraqi variaravave? tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iesusiva tiqaro, So nrita taqaate, tiro. Mwitaa tuvata mwitanasa mwira vatama seta uro mwiva varuraqi varita. Mwitanasa Iesusira vatama seta variqi vita erovata nrima ntanteta vura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mwitanasa Ioniva Iesusirara tu quara rieta Iesusira vataqi vuraqitairo mwo Enturuva, Saimoni Pitaara qatavano varura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mwitana Iesusira mwini setatana Enturuva nai vasaara huaama sero mwira tiva mwiro tiqaro, Tetana mesaiaa, Kotiva titai vaitira huaama sauro, tiro. (Mesaiaave, Karaisivave, kuaa nrutuma vaiso.) ");
INSERT INTO omw_a_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Mwi vaitira huaama seta taqauro, tiva sero Enturuva nai vasaara vita varero Iesusiva hunani uro sovaro Iesusiva mwira taqero tiqaro, E Ionira mwaaqu Saimonivave. Ne qaraaha nrutu nteqana iara Sipaasirave tirerave, tiro. Sipaasirave, Pitaarave, kuaa nrutuma vahiro. (Mwaa quaraqitai mwi nrutura tirerata Orivave tita.) ");
INSERT INTO omw_a_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mwira qararaara Iesusiva Karirini virerave tiva sero, uro Piripira huaama sero mwirara tiqaro, Ni naatiara nriane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Piripiva Vetasaitaniaavama variro. Enturusa Pitaasavata kuaa mwatusa mwiqinaasa varura. ");
INSERT INTO omw_a_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Iesusiva Piripirara ni vataqira nriane tuvaro Piripiva Nataanierira huaama sero mwira tiva mwiro tiqaro, Haaru tiri haivaqava Mosesiva mwaara qua qara ntiqaro mwi vaitirara tivatovata, poropeti vaitinravuvata, mwi vaitiva naatiara qovara hianarove tiva seta qara ntumwato vaitira, so mate mwi vaitirama taqauqo. Mwiva Iesusiva Iosepira mwaaquvano Nasaretiniaavave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tuvaro Nataanieriva tiqaro, Qaqao, sove suqe vaitivano mwi mwatusaraqitairo qovara hianarove? tiro. Tuvaro Piripiva tiqaro, Enavano nrima taqaane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mwitaa tiva sero vuvaro Iesusiva taqovata mwitanasa nri varuvaro tiqaro, Taqaane. Quqaama mwi vaitiva Isareri vaitivano variso. Sia mwi vaitiraqi unra qua vahivave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mwitaa tuvaro Nataanieriva Iesusira sapara hiro tiqaro, Nataama serave e ni osara ntapihira hiaro? tuvaro Iesusiva tiqaro, Piripiva sia i uro nraarai vasa e fiki osarani variarana ne i taqaurave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mwitaa tuvaro Nataanieriva tiqaro, Mwaara ti variara vaitio, e Kotira mwaaquve. E Isareriqaa ntaqaihiaravave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mwitaa tuvaro Iesusiva tiqaro, E fiki osarani variarana ne i taqaurave, turaqaatairave niara quqaa mwivave tiaro? Naatiara nrora inraisa, mwo inraisa mwo inraisa mwira nraataraanirama taqenarave. ");
INSERT INTO omw_a_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","E quqaama taqairaro naavuvano qatua viraqe ne mwatani mwatatai nraaqiarava variarita niqaara naavuniaasa vita tuvita hi varivaqe varianirave, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_a_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Taara enta nritarovata mwatusa mwo Kenaa, Karirini mwi mwatanaasa nraase ntuvirera hura. ");
INSERT INTO omw_a_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mwitaa huvaro Iesusira nrovavata mwini varuvata mwi mwatanaasa Iesusiravata, mwira nraaqiaranravuvata, nraanrovata mwiravusavata mwini vita. ");
INSERT INTO omw_a_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mwiravusa uro variqata sara nre varuvaro uainivano taiqa vuvaro Iesusira nrova Iesusira tiva mwiro tiqaro, Uaini taiqama viso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tuvaro Iesusiva qaqao tiro, Mwaa nraasevao, i saiqa mwo saiqa vaisaro ni saiqa mwo saiqama vahiso. Ne saiqa varaani entava siama nri ntaiso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mwitaa tuvaro Iesusira nrova mwi mwatanaasa saiqa vaitinravu tiva niro tiqaro, Mwiva nara quave iniara tirata mwiva tiarinte tiarinte hiate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Iutaavano niari mwaara qua rieqata mwitaa mwitaama seqata niari mwavanta hiqama sora. So mwirara rieqaro nramari taqu 6 nravu nrora tave voti hura mwi nraavuraqi vatovaro vahura. (Tave nrora kuaa mwiqi soma nramari taqu qataara 10 vano vuanaro.) ");
INSERT INTO omw_a_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Vahuvaro Iesusiva saiqa vaitinravu tiva niro tiqaro, Esaa mwi taqura qaqi nramariqotaita kuraama saate, tuvata qaqi nramari saqaqita uro tave nrora mwinravura kuraama sovaro vaiqaara hura. ");
INSERT INTO omw_a_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kuraama sovaro Iesusiva qaiqaa tiqaro, So mwiqitai saqaqita uro saraqaa ntaqaihira mwivaro nreqaro taqaarive, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mwitaa tuvata mwiqitai mwi nramarira saqaqita uro mwuvaro mwi vaitiva qaqi nramarivano uaini utu vura nreqaro taqovaro suqe huvaro mwiva sia qaqi nramari saqora mwirara ntapihuvata saiqa vaiti mwiravusaqai mwirara ntapihura. Mwitaa huvaro saraqaa ntaqaihuva nreqaro taqovaro suqe uaini vahuvaro qamwata sero nraase varo vaitira nraarama sero ");
INSERT INTO omw_a_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","mwira tiva mwiro tiqaro, Qike, mwo hiasa suqe uaini nraante nraase qora niavata nrava taiqa saavata naatiara uaqa hi uainira ni variarave. E sia mwitaa hiaro. Ne taqauqara e mwo uaini vuni nira suqe uaini mwira naatiarama nira hiaro, tiro. Mwitaa turama. ");
INSERT INTO omw_a_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iesusiva Kenaa mwatusa Karirini variqaro qaqi nramari vara sero uaini utu sero nura. Mwiva mwi saiqara nraante hoqarama tero mwiraqaatairo mwo saiqa mwo saiqa nrora saiqa varaqiro vura. Iesusiva mwi saiqara varovata mwira nraaqiaranravuvano mwira saiqa taqetama Iesusira kepusa osarara ntapihita mwirara so quqaa mwivave tura. ");
INSERT INTO omw_a_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mwiraqaatai mwivavata, mwira nrovavata, mwira qatanravuvata, mwira qua riosavata, mwini seta vusa Kapeniaani uro mwo entanravu varura. ");
INSERT INTO omw_a_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Vesahu nato sarara nro entava qaumatoqa huvaro Iesusiva Ierusaremini vuva ");
INSERT INTO omw_a_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","uro Kotira nraavu nroraqi vera ntero taqovata mwo husa soqaa saiqa vare variqata munima vareqata purimakauve sipisipive kurive ni varuvata mwo vaitinravu tainta tataaqani variqata kamanira munima vareqata Kotira nraavuqinaa munima ni varura. ");
INSERT INTO omw_a_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mwitaamaqita viqata soqaa saiqa vare varuvaro Iesusiva mwisa taqero sapipi vara sero mwiraqotairo purimakauvata, sipisipivata, vataqiro veva Kotira nraavuqitairo mwaatani sero munima tuqataaqi varu vaitisa tainta tu varero vara rauru sero mwi munimaravata rauru sero, ");
INSERT INTO omw_a_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","kuri niqata munima vare varu vaitisara tiqaro, Né mwi inraisara mwi inraisara mwaaqitaita vare vuate. Né sia ni qora nraavu maaketi nraavuqama taate. ");
INSERT INTO omw_a_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iesusiva mwitaa tuvaro mwo qua Kotira vukuqi qara ntuvato quava mwira nraaqiaranravu nraatoqi ntuva vuvata riora. Mwi quava mwitaama tiro: Ne i nraavuara nroraqama sena riemwaqi vuariva tia itaintema sero niqi ite variso, tura. (Sng 69:9) Mwi quara mwitaama sero qara ntuva tora. ");
INSERT INTO omw_a_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iesusiva mwitaa huvata Iutaa vaiti nroranravuvano tiqata, Qaqao, tava iara tisarave e mwitaa hiaro? E nara nrora saiqa mwo tiri vuqaa utiraqe te mwira taqetave iara mwiva so mwitaa hianarove tianarave? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mwisa mwitaa tuvaro Iesusiva tiqaro, Né mwaa nraavura ntapaira saivaqe ne taaramwo entara qaiqaa hoqa saanirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mwitaa tuvata Iutaa vaiti nroranravuvano tiqata, Qaqao, mwaa nraavura hoqeqata 46 ihi airi ihi hoqaqi vita uro hoqa taiqa saarave. Sove e taaramwo entaraqai mwi nraavura hoqa taiqa senarave? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mwitaa tuvaro Iesusiva sia vutu sero qaqi nraavuara tiraitiro, mwiva nai mwavantaqaa ntuva sero tiro. (Né ni rusaivaqe ne taaramwo enta vari sena qaqi tivuanirave, tiro.) ");
INSERT INTO omw_a_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iesusiva mwi quaraqaa ntuva sero tuvata naatiara Iesusiva qaqi tivi varu entaraqaa mwira nraaqiaranravuvano variqata Iesusiva nraavuara tu quava mwisa nraatoqi ntuva vura. Kotira vukuqi qara ntuvato quaravata rieqata, Iesusiva mwi entara tu quaravata rieqata mwisa Iesusirara quqaave tura. ");
INSERT INTO omw_a_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Vesahu nato sarara nro entaraqaa Iesusiva Ierusaremini varuvata nraase qora airivano mwira saiqa nrora saiqa taqeqata Iesusirara so quqaa mwivave tita. ");
INSERT INTO omw_a_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nraase qoravano mwirara qamwateqata mwitaa ti varuvaro Iesusiva nraase qora osarara ntapihi sero rieqarora tiro, mwiva sia mwisa turara quqaave tura. ");
INSERT INTO omw_a_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Iesusiva nai vaasa nraase qora vu nraatoqi vahu inraisara ntapihi sorara tiro, sia qumina mwovano mwisa osarara mwira tiva mwiariva varura. ");
INSERT INTO omw_a_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisi vaiti mwovano mwira nrutu Nikotimaasiva varura. Mwiva Iutaa vuniaa vaiti mwovano varura. ");
INSERT INTO omw_a_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mwo enta mwiva entaqi uro Iesusira taqero tiqaro, Mwaara ti variarao, te taqauraro Kotiva i titaisarara tira, e mwaara qua ti variaravama nrira hiaro. Sia Kotiva i saahaqa hiase titiri, e siama so nrora saiqa varaaratirio, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mwiva mwitaa tuvaro Iesusiva mwira tiva mwiro tiqaro, Ne quqaa qua tianira riaane. Vaiti nrora tuemwa vuanira sia qaiqaa mwata tairaro mwiva siama so Kotiva ntaqaihi mwatusara taqaanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tuvaro Nikotimaasiva sapara hiro tiqaro, Nataama serove nrora tuemwa vuani vaitira qaiqaa mwata saanarove? Sove mwiva nai nrora visosaqi qaiqaa viqe tairaro mwira nrova qaiqaa mwata saanarove? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mwitaa tuvaro Iesusiva nai tiva mwiro tiqaro, Ne quqaama tuqo. Nramarivata mwata taariva variraro sia Kotira Mwaraquravano mwira qaiqaa mwata sairaro mwiva siama so Kotiva ntaqaihi mwatusaraqi vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mwavanta vataava nai mwavanta vahiraqai mwatairave. Mwaraquravano nai mwaraquraqai mwatairave. ");
INSERT INTO omw_a_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ne ini qaiqaa qaraahaqama sero mwata saarive tu quarara sia e mwi quarara nriharama vuane. ");
INSERT INTO omw_a_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ne mwo quaqaa ntuva sena i tiva mwirerave. Toqavano tiqaro nai vuataa hiraqaa virave. Toqavano nrisara e sia mwira taqaraitira, e mwira nruquaqai riaanarave. E mwiva viro nriro hi osarara sia ntapihianarave. So Kotira Mwaraquravano mwatatai osarava kuaa qarama seroma vahiso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Iesusiva mwitaa tuvaro Nikotimaasiva mwira sapara hiro tiqaro, Nataama serove mwitaa hianarove? tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesusiva tiqaro, E Isareri nraase qora mwaara tiva ni variarava e siave ntapihiaro? ");
INSERT INTO omw_a_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ne quqaama tuqo. Te ntapihi seta rie taqe hunara ini tiva ni varurata né sia tiri qua riaarave. ");
INSERT INTO omw_a_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ne mwataniaa inraisara ini tiva nuqata né mwirara sia ntapihita quqaave tiarave. Né mwitaa hiavana ne naavuniaa inraisara tiarita nataama setave né mwi quara so ntapihi rievarave? ");
INSERT INTO omw_a_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Sia vaiti mwovano Kotiva varira naavuni virave. Ne mwatani mwatatai nraaqiarava neqai naavuni variavava mwitaina tuvurave. ");
INSERT INTO omw_a_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Haaru ini haivaqava Mosesiva qumina mwataqaa variqaro ori vara sero memaru utu sero mwira satariqaa rupa sero tuaahera sorave. (Nraase qoravano mwira taqeta sia qutu vuate tiro, Mosesiva mwitaa hurave. (Nam 21:6-9)) Qio ne mwatani mwatatai nraaqiarava variarita haaru Mosesiva memaru utu sero tuaahera sontema seta nivata satariqaa vateta tuaahera sevarave. ");
INSERT INTO omw_a_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mwitaa hirata nraase qora niara quqaa mwivave tisa sia qutu viraitita, esaa enta esaa enta qaqi variqi vivarave, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kotiva mwatani variasara mwoqama sero mwutusa ntisarora tiro, mwiva nai mwaaqu kuaiqa vataira tiri timwira. Mwitaa hirara tita, nraase qoravano mwira mwaaquara quqaa mwivave tisa sia qutu viraitita, mwisa esaa enta esaa enta qaqi variqi vivara. ");
INSERT INTO omw_a_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kotiva sia nai mwaaqu ko riaa vaitisa votima sero variqaro nraase qora tusa hiarive tiro mwatani titaisaro tuvirave. Mwiva nraase qora sitaarive tiro, Kotiva mwira titaisaro tuvirave. ");
INSERT INTO omw_a_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mwovano mwira mwaaquara quqaa mwivave tiariva, mwiva siama qua varaanaro. Mwovano sia mwira mwaaquara quqaa mwivave tiariva, mwiva vaasama qua varero. Mwiva Kotira mwaaqu kuaiqara sia quqaa mwivave tira saarama, Kotiva mwirara quqaa iqaa qua vaiso tiva sero, mwiraqaa qua vatero. ");
INSERT INTO omw_a_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mwaa inraisara saara qua vahianaro. Ovavano mwatani tuvisata nraase qoravano sia mwira qamwata mwataraitita, mwisa enta hiraraqai qamwateqata variara. Mwisa saiqavano qora saiqa vaisatara tita, mwisa sia mwi ovara qamwata mwateta. ");
INSERT INTO omw_a_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Qora saiqa uti variva nravutaaqa hiqaroma sia omwavano varinani viro. Ovavano iteqaro ni uaqa hi saiqara qovarama saaso tiro, sia ovavano varinani viro. ");
INSERT INTO omw_a_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mwiva mwitaama varisaro quqaa saiqa vare vari vaitiva sia aatu hiraitiro, ovavano varinani viro. Mwiva visaro ovavano itero mwira saiqa qovarama saisata nraase qora taqaavaro mwi vaitiva Kotira qua rieqaro Kotira saiqa vare varira. ");
INSERT INTO omw_a_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mwiraqaataita Iesusivavata mwira nraaqiaranravuvata (Ierusaremi seta) Iutaa mwata mwo qumina mwatani vura. Iesusiva nai nraaqiaranravu sapata variqaro nraase qora nramari nura. ");
INSERT INTO omw_a_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nuvaro Ionivavata mwatusa mwo Serimi tataaqa Ainonini variqaro nramari ni varura. Ioniva nramari nrora vahunani variqaro nraase qora mwini uairama vusa nramari nura. ");
INSERT INTO omw_a_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mwi entara sia Ionira karavuqi vitaqita uro so entara varura. ");
INSERT INTO omw_a_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mwi entara Iutaa vaiti mwovano Ionira qua riosa sapata nramari vare osarara irora huvata mwisa Ioniva hunani uro nteta tiqata, ");
INSERT INTO omw_a_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mwaara ti variarao, tauraa e Sotaani qarahi vutura hini vaiti mwovata variqarama e mwirara mwivave tunarave. So taqaane. Mwi vaitiva mwivavata nramari ni varisata airivano mwiva hinani vi variavo, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mwitaa tuvaro Ioniva tiqaro, So Kotiva naavuni variva vaiti mwo sia mwo inraisa mwirera, mwi vaitiva siama mwi inraisara varaanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Névata vuni ne tura riaarave. Ne tiqana, Siama ne ini saahaqa hiariva varuqo. Ni titaisana ne nraante mwira vuni nruvave, turave. ");
INSERT INTO omw_a_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nraase vararera hi vaitiva nraase varairave. Mwi vaitira totivano qaqi tivi variqaro mwira qua rieqaro qamwata sero varirave. So mwira totivano qamwataintema sena ne Iesusirara qamwatauqo. ");
INSERT INTO omw_a_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iesusira nrutu virini nriviraro ni nrutu mwatani tuvi vuarive. (Airivano mwira vataqita vivarave. Siama ni vataqita vivarave. Mwisa Iesusira vataqita virara siama ne Iesusira saru ntuva mwataanirave. Ne mwira qamwata mwataanirave,) tiro. Ioniva turama. ");
INSERT INTO omw_a_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Iesusiva viritairo tuvivara tiro, esaasa nraatara saivama variro. Mwataniaava mwatatairo nrivara tiro, mwiva mwataniaa inraisaraqai ti varira. Iesusiva naavutairo tuvivara tiro, esaasa nraatara saivama variro. ");
INSERT INTO omw_a_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mwiva nai taqero riero hi inraisara qoqaa tiva ni varisata nraase qoravano mwira quara sia quqaave tiraitita, mwira qua qoririma mwate variara. ");
INSERT INTO omw_a_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","So vaiti mwovano sia Iesusira qua qoririma mwataraitiro, mwira quara quqaave ti vari vaitiva, mwiva mwitaa tiqaroma Kotira quaravata quqaa qua vaiso tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kotiva Iesusira titaisaro mwiva Kotira quaqai ti varira. Kotiva mwira titarera hiro sia nai mwaraqura pataqa pataqa mwiraitiro, mwira nroraqama sero mwisarora tiro, so Kotira quaqai ti varira. ");
INSERT INTO omw_a_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mwira qova nai mwaaquara mwoqama sero mwutusa ntisaro esaa inraisa nai mwaaqu mwisaro mwiva mwi inraisaraqaa ntaqai hiqiro vi variro. ");
INSERT INTO omw_a_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mwovano mwira mwaaquara quqaave tiariva sia esaara qutu viraitiro, mwiva qaqi variqiro vuanaro. Mwovano sia mwira quara quqaave tiariva variraro Kotira raraqa tairaro mwira irora hiraro quavano mwiraqaa vahianaro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mwi entara Parisi vaitinravuvano riovaro Iesusiva airi nraase qora nai hunani vita sero vateqaro mwisa nramari niqaroma Ionira nraatara sora. ");
INSERT INTO omw_a_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Iesusiva sia naivano mwisa nramari nura. Mwira nraaqiaranravuvano nraase qora nramari nura. ");
INSERT INTO omw_a_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Parisi vaitinravuvano mwi quara riovarora tiro, Iesusiva mwiraqaatairo Iutia mwini sero Karirini viro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Karirini virera mwiva Sameriaa mwata vutaqaama tero vuariva vahura. ");
INSERT INTO omw_a_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mwiva viqaroma mwatusa pata mwo mwira nrutu Saikaa mwini uro ntora. Mwata mwo haaru Sekopuva nai mwaaqu Sosepira mwu mwatara mwira tataaqa vahura. ");
INSERT INTO omw_a_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Sekopuva haaru nramariara quvutova mwini vahuvaro Iesusiva niara aara nri sovaro pupohovaro mwiva nramariara quvutora tataaqa mwatasaa viro varura. Varuvaro huarivano nriro virira qiataqaa vahuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sameriaa nraase mwovano nramari saqareraro nruvaro Iesusira nramari nraataa huvaro mwi nraaserara tiqaro, Nramari saqa sera ni miraqe nraase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Iesusira nraaqiaranravu vaasa sara vararerata mwatusani vuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Iesusiva mwiraqaa variqaro mwitaa tuvaro Sameriaa nraase mwiva qaqao tiro, E Iutaavano variarana ne Sameriaavano varuqo. Nataamaqirave niara nramari saqa miraqe nraase tira hiaro? tiro. Iutaavanovata Sameriaavanovata nai nunurama mwate nai nunurama mwate hi varusara tiro, mwi nraaseva mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mwitaa tuvaro Iesusiva nai tiva mwiro tiqaro, E Kotiva qaqi niani inraisarara e riera ni osararavata ntapihiaratirio, e ni sapara hiarana ne qaqi variqi vi nramarira i mwutirio, tiro. (Mwi mwatanaasa nrumwuqinaa nramariara tiqata, Qaqi variqi vi nramarirave,) tura. ");
INSERT INTO omw_a_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Iesusiva ne qaqi variqi vi nramarira i mwirerave tuvaro mwi nraaseva sia ntapihi sero riaraitiro, mwiva rumwu nramariara tiso tiro. Mwiva tiqaro, Nrorao, nramarivano vevato vaisara e siama nramari taqu vatera hiaro. Taraqitairave qaqi variqi vi nramarira saqenarave? ");
INSERT INTO omw_a_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tiri haivaqava Sekopuva nrora vaitivano varurave. E mo? E mwira nraatara saaravave iso? Mwiva nramari varaanira mwata quvu sero naivata nai nraaqiaravata nai quaravatama sero mwaa nramarira saqa sero nrorave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mwitaa tuvaro Iesusiva tiqaro, Mwovano mwaa nramarira nrairaro qaiqaaqai nraataa hiraro nrima nreqaro varianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ne mwiani nramarira mwovano nrairaro mwira siama qaiqaavata nraataa hianarove. Ne nramari mwiariro mwi nramariva vaiti vutaqitairo rumwuqitairo tuvi nramarira votima sero vi variraro mwi vaitiva sia qutu viraitiro, qaqiqai variqiro vuanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mwitaa tuvaro mwi nraaseva tiqaro, Nrorao, so mwi nramarira ni miraqe ne nraariro sia qaiqaa ni nraataa hiraqe qaiqaavata nrima mwaaqitaina saqa seqana nraase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Mwitaa tuvaro Iesusiva tiqaro, So, uro ena vaativata nraaramase vita varera uro ntantera mwaini nriane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tuvaro mwi nraaseva tiqaro, Qaqao, sia ni vaati varivave, tiro. Tuvaro Iesusiva tiqaro, E quqaama tiqara sia ni vaati variso tiaro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","E sauquru nani vaati varaaravave. Mate e vaiti mwovata variarava, mwiva sia quqaa i vaativano variso. E quqaama tira hiaro, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mwitaa tuvaro nraase mwiva tiqaro, Nrorao, ne taqauqara e poropeti vaitima varira hiaro. Kotiva i saahaqa isarama e mwitaa tira hiaro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","So Sameriaa tiri haivaqasa Kotira nrutu tuaaherarerata mwaa taaqiraqaa variqata Kotirara aasara nte varurave. Mwitaa turata né Iutaavano tiriara tiqata, Qaqao né Ierusareminiqai variqata Kotira nrutu tuaaheraataarave, tiarave. Né tiriara mwitaa ti variarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mwitaa tuvaro Iesusiva tiqaro, Ni quara e quqaave tiane. Mwo enta nri ntairata né mwi entaraqaa ni qora nrutu tuaaherarera hiqata, siama mwaa taaqiraqaa variqata aasara ntevarave. Siama Ierusaremini variqata Kotirara aasara ntevarave. ");
INSERT INTO omw_a_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Né Sameriaavano sia Kotira osarara ntapihiraitita, apiqama seqata aasara nte variarave. Tiri Iutaaqitairo nraase qora avantu nitaariva qovara hianirara tita, te ntapihise Kotira osarara rieqata mwira nrutu tuaahereqata mwirara aasara nte varunarave. ");
INSERT INTO omw_a_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mwo enta nriariva qaumaqa iso. Mwi entava mate qovarama viso. Mwi entaraqaa Kotira Mwaraquravano nraase qora saahaqa hirata mwisa ntapihise Kotira osarara rieqatama mwisa quqaaqama seta Kotira nrutu tuaaherevarave. Mwitaamase Kotira nrutu tuaaheresara Kotiva huaa hi variso. ");
INSERT INTO omw_a_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kotiva mwaraquravano varirave. Mwitaama varirara tita, mwira mwaraquravano saahaqa hi nraase qorasa mwisaqaima Kotira osara ntapihita quqaaqama seta Kotira nrutu tuaaherevarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mwitaa tuvaro nraase mwiva tiqaro, Mesaiaa vaiti Kotiva titaanira, ne mwirara ntapihi sauqo. Naatiara mwo enta mwi vaitiva nri ntero esaa inraisara tiri tiva timwianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mwitaa tuvaro Iesusiva mwirara tiqaro, So ivata qua ti varuva ne mwaa mwivave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iesusiva mwitaa ti varuqaraqi Iesusira nraaqiaranravuvano uro ntanteta nrima taqovaro Iesusiva Sameriaa nraasevata qua ti varuvata mwisa nriharama vita. Mwisa nriharama vitavata sia mwi nraaserara tiqata, Nara inraisarave mwiravata qua ti variaro? tiraitita, sia Iesusiraravata tiqata, Nara inraisarave nraase mwiravata qua ti variaro? tura. ");
INSERT INTO omw_a_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tirema varuvaro nraase mwiva nai nramari taqu mwini sero tiviro nrima ntantero mwatusaqi nraase qora uro tiva nireraro vuva nrintero tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Né vaiti mwo nrita taqaate. Mwiva ne utu inraisara esaa ni tiva miso. Quqaa mwiva Kotiva titarera hiva, mwivave iso? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mwitaa tuvata mwisa mwatusa mwira seta Iesusiva varunaniara vura. ");
INSERT INTO omw_a_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mwi nraaseva vuvata Iesusira nraaqiaranravuvano Iesusirara tiqata, Mwaara ti variarao, qaqi sara mwaa vara sera nraane, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","mwiva mwisara tiqaro, Ne sara nraanira vatauqo. Né mwi sarara siama ntapihi saavo, tuvata ");
INSERT INTO omw_a_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","mwira nraaqiaranravu nai tiva mwi nai tiva mwi hita tiqata, Vaasa mwovano sara mwisaro nrerove mwitaa tiso? tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iesusiva mwinravusa tiva niro tiqaro, Ni titaira mwutusa vahi saiqara vareqana mwiva saiqa mitairavata varaqina uro taiqa saariva so mwi saiqava ni sarama iso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Iesusiva mwitaa tiva sero tiqaro, Né mwo quaqaa ntuvase tiqata tiarave. Tora taaratana taaratana vara saariro sara keko tiqe antuanirave, tiarave. So sara vara tutaaraqi aitutu hiqata taqaate. Mate saravano naitarama viso. Né soma antivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sara antiva nai saiqa varairara soqaa varairave. Mwiva sara antu tairaro mwi sarava esaa enta esaa enta qaqiqai vahiqiro vuanarove. Mwitaa hirata sara vara tuarivavata, sara antuarivavata, mwitanasaqama qamwateqata varivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mwo quavata tiava quqaa quama vaiso. Vaiti mwovano sara vara tutaira mwovano mwi sarara antirave. ");
INSERT INTO omw_a_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ne ini titena tiqana, Mwovano saiqa vareqaro vara tutai sarara uro antuate, tuqo. Mwo hiasa tutoqauha tuseta saiqa vara seta sara vara tutaara, né mwisa sara antivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Iesusiva mwitaa ti varuvaro mwi nraaseva uro nai nravunaasara tiqaro, Mwiva ne utu inraisara esaa tiva miso, tuvata Sameriaa nraase qora mwi mwatusaraqinaasa airivano Iesusirara so quqaa mwivave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mwitaa tiva seta Sameriaa qinaasa Iesusiva varunani nri nteta Iesusirara po tita tiqata, So sia qamwanrama vuane. E tirivata vari sera vuane, tuvaro Iesusiva mwisavata taara enta vaitero vurama. ");
INSERT INTO omw_a_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Saatavanoqai Iesusira qua rieqata so quqaa mwivave tita. ");
INSERT INTO omw_a_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mwisa mwi nraaserara tiqata, Sia vaasa e tianaraqaataitavauma te mwirara quqaa mwivave, turo. Mate tetavano nai nroqitaita rietama mwirara quqaa mwivave turo. Te taqauraro Kotiva mwira titaisaro mwiva tiri mwaa mwataraqaa varurasa saahaqama tiva tero avantu tiva taarivama variso, tita. Mwitaa turama. ");
INSERT INTO omw_a_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iesusiva mwini taara enta vaitero mwiraqaatairo nai mwaata Karirini viro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iesusiva nai tiqaro, Poropeti vaitivano nai mwaatani varisaro mwira nrutuvano sia virito vahirave, tura. ");
INSERT INTO omw_a_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Iesusiva Karirini vuvata mwi mwatanaasa mwirara qamwateqata varura. Mwi mwatanaasavata vesahu nato sarara nro entara Ierusaremini uro variqata Iesusiva nrora saiqa varovata taqorara tita, mwisa mwirara qamwatora. ");
INSERT INTO omw_a_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mwira qamwata mwatovaro Iesusiva qaiqaa Kenaani tauraa mwini variqaro qaqi nramari vara sero uaini nramariqama sonani nrura. Nruvaro kamanira saiqa vaiti mwovano varuvaro mwira mwaaquvano nroraqama sero nriqa vuvaro Kapeniaani varura. ");
INSERT INTO omw_a_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Iesusiva Iutiatairo Karirini nriso tuvaro riero, mwi vaitiva Iesusiva varunani nrintero tiqaro, Sove e nrira ni maaqu nriqa vira saahaqama sairaro qaqi varianarove, tiro. Mwi vaitira nraaqiaravano qutu vuariva qaumaqa huvaro mwiva mwitaa tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesusiva mwirara tiqaro, Né sia nrora saiqa suqe hira taqaraitita, siama né quqaave tivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tuvaro nrora vaiti mwiva tiqaro, Nrorao, ni maaquvano qutu vuasorave. Qamwanrama nriane, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesusiva tiqaro, So ena mwaatani vuane. I mwaaquvano qaqi varianarove, tiro. Mwitaa tuvaro mwi vaitiva Iesusiva qua tiva mwurara quqaa quave tiva sero, nai mwaatani viro. ");
INSERT INTO omw_a_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mwi vaitiva aarana vi varuvata mwira saiqa vaitinravuvano uro hunta seta mwira tiva mwita tiqata, I nraaqiaravano suqema viso, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tuvaro mwiva mwinravusa sapara hiro tiqaro, Nara huari vuqaave mwira nriqa viva taiqa visaro mwiva suqema viso? tuvata mwisa tiqata, Enta huari vu vitini tuvi viro 1 kirokuqa hisaro mwira nriqa viva taiqa virave, tura. ");
INSERT INTO omw_a_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mwitaa tuvaro mwira qova ntapihi sovaro huari vu mwiqaraqaa Iesusiva mwira tiva mwiro tiqaro, I mwaaquvano soma varianarove, tura. Mwitaa turara tiro, mwi vaitivavata mwira nravunaasavata Iesusirara quqaa mwivave turama. ");
INSERT INTO omw_a_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iesusiva Iutiatairo nrima Karirini variqaro mwi saiqara varova tauraa varova kuaiqa vahuraqa mwiva viro taaraqaqa hura. ");
INSERT INTO omw_a_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mwiraqaatairo Iutaavano omwata nro entava mwo nri ntovaro Iesusiva Ierusaremini viro. ");
INSERT INTO omw_a_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ierusaremini vasaavura qeti mwo sipisipi qeti vahura. Mwira tataaqa nramari nruka mwira nrutu Vetasaitaave tuva vahura. Nramari tosasataa haraara nraavu sauquru vahuvata ");
INSERT INTO omw_a_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","haraara mwiqi nriqa vusa airinti varura. Vu qipa vusave, suqu uaqama vusave, suqu sauqu tapara vusave, mwisa variqata nramarivano qasaa hianira mwira vesa varura. ");
INSERT INTO omw_a_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kuaa enta kuaa enta naavuniaava mwovano uto nramari qasaa huvaro mwisaqitairo mwovano nraane nramariqi vuvaro mwira nara mwavantave nriqa vuva suqema vura. ");
INSERT INTO omw_a_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","So mwisa nramari qasaa hianira vesa varuvaro vaiti mwovano airi ihi 38 ihiara nriqa vuvaro varuvavata mwiqi variro. ");
INSERT INTO omw_a_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Varuvaro Iesusiva mwira taqero ntapihi sovaro mwi vaitiva airi ihi nriqa vuvaro varura mwira sapara hiro tiqaro, I nriqa vuariva taiqa vuarive tira, e mwirara qamwaterave hiaro? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mwitaa tuvaro nriqa vu vaitiva tiqaro, Nrorao, nramarivano qasaa hisaro mwovano ni saahaqamaqiro uto nramariqi saariva sia varisana ne nraante virera huqata mwosa nraante vuavo. Mwitaamaqi vi variqana varuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nriqa vu vaitiva mwitaa tuvaro Iesusiva mwira tiva mwiro tiqaro, Tivira ena taarivata tu varera nruaane, tuvaro qamwanrama mwira mwavantavano suqema vuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","mwi vaitiva tiviro nai taarivata tu varero so nruora. Mwi entara mwaaraqaa mwitaama sora. ");
INSERT INTO omw_a_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mwaaraqaa mwitaama sorara tita, mwira saara Iutaa vaiti nroranravuvano vaiti suqema vura mwira irora hita tiqata, Mate mwaaraqaave. Ena taari tu vare vinarara tiri mwaara quavano qao tirave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tuvaro mwi vaitiva tiqaro, Qaqao, vaiti mwovano ni suqema saiva niara ena taari tu varera nruaane tisanama ne mwitaa huqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tuvata Iutaa vaiti nroranravuvano tiqata, Ta vaitivave iara tivira ena taari tu varera nruaane tiso? ");
INSERT INTO omw_a_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","tuvaro mwira mwavantavano suqema vu vaitiva sia mwira nrutu ntapihura. Mwini nraase qora airivano varuvaro Iesusiva qamwanrama vi vuvaro mwi vaitiva sia Iesusira nrutu ntapihura. ");
INSERT INTO omw_a_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mwira nrutu sia ntapihiraitiro varuvaro Iesusiva naatiara variqaro taqovaro mwi vaitiva nraavu nrora Kotira nraavuqi varuvaro Iesusiva mwira tiva mwiro tiqaro, So taqaane, i mwavantavano suqema viso. Mwo inraisavano mwira nraataraariva i ru saaso tira, siama qaiqaa uaqa hi saiqara utuqira vuane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mwitaa tuvaro mwi vaitiva mwiqitairo veva ntero uro Iutaa vaiti nroranravu tiva niro tiqaro, Mwira nrutu Iesusiva mwivama ni mwavanta suqema saiso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tuvata mwisa riovaro Iesusiva mwaaraqaa mwira suqema sorara tita, mwisa mwira saara mwi entaraqaataita Iesusira qoraqama mwate varura. ");
INSERT INTO omw_a_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mwitaa huvaro Iesusiva mwisa tiva niro tiqaro, Ni qova esaa enta saiqa vare varisanama nevata saiqa vare varuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tuvata mwi quara saara Iutaa vaiti nroranravuvano mwoqama seta Iesusira ru sarerata uti varita tiqata, Tauraa Iesusiva te mwaara entara tuna quara nteqa saiso. Mwira naatiara mwiva Kotirara ni qorave tiso. Mwiva qumina vaitivano variqaro mwiva Kotira votima sero Kotisantiriro kuaaqaa varireraro uti variso, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iutaa vaitinravuvano mwitaa tuvaro Iesusiva mwisa tiva niro tiqaro, Ne quqaa qua tianira riaate. Ne mwira mwaaquvano variqana siama nena nraato tusena mwi inraisara varaanirave. Ni qova saiqa varaisana ne taqaura mwi saiqaraqaima vare varuqo. Ni qova mwitaa mwitaa isana ne mwira mwaaquvanovata mwitaa mwitaa hi varuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ni qora mwutusavano ni nai mwaaquara vaisarora tiro, mwiva nai vare vari saiqara esaa saiqa ni tiva miso. Naatiara ni qova ni tiva miraqe ne mwaa saiqara nraatara saani saiqarama varaanirave. Ne mwi saiqara mwi saiqara varaarita né mwira taqetama mwoqama seta nriharama vivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ni qova qutu vuasa qaiqaa vara tivumase varivave. Ni qova mwitaa hintema sena ne mwira mwaaquvanovata variqana ni mwutusa vahiani nraase qorasa qaqi vara tivuma saarita mwisa qaqi variqita vivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ni qova nai siama nraase qora ko tianarove. Mwiva mwi saiqara ni mitaisana ne mwira mwaaquvano variqana so ko tianirave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mwiraqaataita nraase qoravano ni qora nrutu tuaaheraantema seta mwisa ni mwira mwaaqu nrutuvata tuaaherevarave. Mwovano sia ni mwira mwaaqu nrutu tuaaheraariva siama ni qova ni titaira nrutuvata tuaaheraanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ne quqaa qua tianira riaate. Mwovano ni qua riero quqaama Kotiva mwira titaivave tiariva, mwivama esaa enta esaa enta qaqi variqiro vuanarove. Mwi vaitiva siama qua varaanarove. Mwiva mwaa entara sia esaara qutu viraitiro, mwiva esaa enta qaqi variqiro vuarivama variso. ");
INSERT INTO omw_a_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ne quqaa qua tianira riaate. Mwo enta nriariva qaumaqa iso. Mwi entaraqaa qutu virera utisa, mwisa Kotira mwaaqu ni qua rievarave. Ni qua riesa soma qaqi variqita vivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Qaqi variqita qua osarava ni qoraqi vaisaro ni qova nai mwaaqu ni nroraqama saisaro mwiraqi vahintema sero qaqi variqita qua osarava niqivata vahiso. ");
INSERT INTO omw_a_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ni mwatani mwatatai nraaqiarara tiro, ni qova ni nroraqama saisana ne mwatani vari nraase qorasa so ko tianirave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Né sia ne qua tianirara nriharama vuate. Mwo enta nri ntairaqe ne mwisa nraaraarita mwataqi quntama te nraase qorasa ni qua rieta, ");
INSERT INTO omw_a_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mwisa quntama teraqitaita tivivarave. Hini hisa suqe saiqa varesa tivita qaqi variqita vivarave. Hini hisa uaqa hi saiqara utisa tivita nrora quama varevarave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ne variqana siama nena nraato tusena mwo inraisa varaanirave. Kotiva tiva mi varisana mwira qua rieqanama ne nraase qora so ko tianirave. Siama ne nena mwutusa nti saiqara vare varuqo. Ne ni qora mwutusa nti saiqarama vare varuqo. Mwitaamaqi vi varuvara tina, ne nraase qora qua ntapihi sena ko tianirave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ne nenavano nena osarara tiariro mwovano ni quara sia quqaa quave tiasorave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","So mwovano variqaro ni osarara tiva ni variso. Ne ntapihi sauqaro mwiva niara tiva ni quava quqaa quama vaiso. ");
INSERT INTO omw_a_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Né tauraa vaiti mwonravu titovata mwisa uto Ionira sapara huvaro Ioniva ni osarara ntapihi mwisa tiva nurave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Vaitivano ni osarara tianira sia ne mwirara nroraqama sena riauqo. Kotiva ini vitaarive tina, ne mwi quara tiva nuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ioniva variqaro ova votima sero ite varuvata né variqata mwiva itorara sia muahaama seta qamwata mwatorave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","So ni osarara tiariva Ionira nraataraarivama variso. Ni saiqavano niara tiva ni variso. Ni qova saiqa ni mitaira ne mwi saiqara vare varuva, so mwi saiqava ni osarara tiva ni variso. Nraase qoravano ni saiqa taqeqatama soma ni qova ni titairave tivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ni qova ni titaiva, mwivama ni osarara tiva ni variso. Né sia mwira qua rieta, sia mwira viri taqaarave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mwiva ni titaisana tuvuqata né sia niara quqaa mwivave tiavo. Né sia mwitaa tiavarora tiro, Kotira quavano sia ini vu nraatoqi vaisata variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Né tiqata, Saiqe Kotira vukuqi aitutuma seta taqeta esaa enta esaa enta qaqi variqita vuare, ti variarave. So mwi vukuraqi vahi quava ni osarara ti varisata ");
INSERT INTO omw_a_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","né sia ne varunani nriavana ne qaqi variqi vi inraisara ini nurave. Ne hunani nriataara vaisata né sia nriarave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Siama ne vaitiqaataina nrora nrutu varaanirave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ne ini ntapihi sauqo. Ini mwutusavano sia Kotirara vaisata variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kotiva ni qova ni titaisana ne nena qora nrutu varena nruqatavata né sia ni qamwata seta vitaarave. Mwovano nai riemwa sero nai nrutu tuaaherareraro hirata né qamwanrama seta mwira qamwata mwatevarave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Né nai nrutu nai nrutu tuaahererara nroraqama seta rieqata sia Kotiva ini nrutu tuaaheraanirara nroraqama seta riaavo. Mwitaa hi variqata né nataama setave niara quqaa mwivave tivarave? ");
INSERT INTO omw_a_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Naatiara nena qora vuqaa variqana sia nevano iniqaa qua vataanirave. Mosesiva níta haivaqava, mwivama iniqaa qua vataanarove. Né Mosesirara mwiva tiri saahaqa hianarove tiarave. So naatiara mwivama iniqaa qua vataanarove. Mosesiva qara ntuva to quava niara tisata né mwira quara sia quqaa quave tiarave. ");
INSERT INTO omw_a_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Né Mosesiva tu quarara quqaa quave tiatirio, né ni quaravata quqaa quavema tiatiri. ");
INSERT INTO omw_a_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Né mwira quara sia quqaa quave tiqata nataama setave né ni quaravata quqaa quave tivarave? Né sia so mwitaa hivarave, tiro. (Iesusiva mwi quara Iutaa nrora vaitinravu tiva nura.) ");
INSERT INTO omw_a_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mwiraqaatairo Iesusiva uro Kariri nruka, mwira nrutu mwo Taipiriaasi nruka vara mwaini sero votuqi nruka mwiraqaa qarero hini tosani uro variro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Uro varuvata nraase qora airivano taqovaro Iesusiva nriqa vusa suqema sovatara tita, mwisa Iesusira vataqita vita. ");
INSERT INTO omw_a_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mwira vataqita vuvaro Iesusiva nai nraaqiaranravu sapata uro taaqisataa mwatasaa viro varura. ");
INSERT INTO omw_a_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mwi entara Iutaavano vesahu nato sarara omwata nro entava qaumaqa hura. ");
INSERT INTO omw_a_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesusiva nai nraaqiaranravu sapata mwatasaa viro variqaro taqovata nraase qora airivano mwira vataqita nrusa nrima uairama vita varuvaro Iesusiva Piripira sapara hiro tiqaro, Te taitaitave sara soqaama seta mwi nraase qorasa niarata nrevarave? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iesusiva nai mwisa sara niani osarara vaasa ntapihiro mwiva Piripira qaqi mwataara hiqaro mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tuvaro Piripiva tiqaro, Qaqao, sarara 200 kinaa nrora munima seta vara ntuaqama niarata mwisa pataqa pataqaqai varevarave. Airi nraase qoravano variavo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tuvaro Iesusira nraaqiara mwovano Enturuva Saimoni Pitaara qatavano tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Naako mwovano mwaini variso. Mwiva mpereti hini sauquruvata tavusa taaratanavataqai vataiva vaiso. Nataama serove mwiqatanava airi nraase qoraqi so vahianarove? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mwitaa tuvaro Iesusiva nai nraaqiaranravu tiva niro tiqaro, Nraase qorara tivata mwatasaa vita variate, tiro. Iesusiva mwitaa tuvaro mwini mwusauvano vahuvata vaiti 5,000 nravu airivano mwatasaa vita varuvata (nraasevata airivano mwatasaa vita varura.) ");
INSERT INTO omw_a_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mwisa mwatasaa vita varuvaro Iesusiva mpereti mwira vara sero Kotirara suqeve tiva sero, nraase qora mwatasaa vita varusa tusama sero niro. Tusama niro tavusavata vara sero kuaa qarama sero mwatasaa vita varusa tusama sero nuvata mwisa vara seta so nrora. Mwisa niari nraataa huntema mwi sarara so nrora. ");
INSERT INTO omw_a_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mwisa so nrovaro Iesusiva nai nraaqiaranravuara tiqaro, Mwisa nreqata viti vaatise sarara tuntu ntuvaantua hiate. Saravano qumina viro raupiri hiasorave, tuvata ");
INSERT INTO omw_a_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","mwira nraaqiaranravuvano nraase qoravano sauquru mpereti nreta viti vaati sora tuntu seta ntutantutoraqi 12 nravu kuraama sora. ");
INSERT INTO omw_a_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kuraama sovata so nraase qora mwini varusa taqovaro Iesusiva nrora saiqa vara sovata mwisa tiqata, Poropeti vaitivano mwatani tuvuariva so quqaa mwaa mwi vaitivave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mwitaa ti varuvaro Iesusiva ntapihi sovata nraase qoravano sai mwira nroraqama saararo tiri vuniaa vaiti nroravano variarive tiqata Iesusira tu vararera uti varuvaro Iesusiva mwira ntapihi sero mwisa mwitaa hivorave tiva sero, qaqira sero uto ntantero taaqiqaa nariaraa uro varireraro vura. ");
INSERT INTO omw_a_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Iesusiva taaqiqaa uro varuvaro enta hireraro huvata mwira nraaqiaranravuvano nruka tosasata uto nteta ");
INSERT INTO omw_a_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","votuqi mwaari nteta nrima ntanteta Kapeniaaminiara vita. Mwisa mwiniara vuvaro anoma entama vuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Iesusiva sia tuvuvata mwisa nrukaqaa vi varuvaro toqa vaururuvano nroraqama sero tiqaroma nruka nramari raaqutaqiro nri varura. ");
INSERT INTO omw_a_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mwitaa huvata mwira nraaqiaranravuvano nrukaqaa satariqo votu raaqutaqita viqata 5 kiromitave iso 6 kiromitave mwisa vara seta nruka vutaqaa nrita taqovaro Iesusiva nramari turuqaa suqu ntavaqiro viqaroma votu qaumato nruvata mwisa mwira nraatu mwoqama seta aatu hi varura. ");
INSERT INTO omw_a_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Aatu hi varuvaro Iesusiva mwisa tiva niro tiqaro, Sia aatu hiate. Nema nruqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tuvata mwisa so votuqi mwaari ntaane tuvaro mwaari ntovaro votuvano qamwanrama mwisa virera hunani uro ntora. ");
INSERT INTO omw_a_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mwira qararaara nraase qora nruka tosa hini varusa taqovaro votu kuaiqavano vahuvata mwisa ntapihi sovaro Iesusiva sia mwitairo nai nraaqiaranravu sapata mwaari ntero vuvata mwisa niariaraa votuqi mwaari nteta vura. ");
INSERT INTO omw_a_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mwisa mwitaama rieta varuvata Taipiriaasitaita votu mwonravuvano nrima tauraa Iesusiva sarara suqeve tiva sero, tusama nuvata nraase qoravano nro mwatara qaumato nruvata ");
INSERT INTO omw_a_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","mwo nraase qora mwini varusa taqovaro Iesusiva sia mwini varuvata mwira nraaqiaranravuvata sia varuvata mwisa votuqi mwaari nteta Kapeniaani Iesusirara huaa hirerata vura. ");
INSERT INTO omw_a_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mwisa Iesusira huaa hirerata vusa uro nruka tosa hini Iesusira huaama seta mwirara tiqata, Mwaara ti variara vaitio, taireve e mwaini nrira hiaro? tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesusiva tiqaro, Ne quqaa qua tianira riaate. Né mpereti airiqama nraarara rieqatama niara huaa hi variavo. Né sia ni saiqa osara ntapihi paahimase rieqatavauma niara huaa hi variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","So siama qaqi sara tapitaani sarara vararerata saiqa varaate. Né mwitaa hira qaqira seta esaa enta qaqi variqi vuani sarara vararerata saiqa varaate. Mwi sarara ne mwatani mwatatai nraaqiarava variqana soma ne ini nianirave. Kotiva ni qova mwivama ni nroraqama saisana ne so mwitaa hianirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iesusiva mwitaa tuvata mwisa mwira sapara hita tiqata, Te Kotira saiqa vararera hiqata, nataa nataave hianarave? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tuvaro Iesusiva tiva niro tiqaro, Kotiva iniara mwaa saiqara varaate ti variso. Mwiva titai vaitirara né quqaa mwivave tiate tiso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mwitaa tuvata mwisa tiqata, So nara saiqave tiri tiva timwiraqe te mwira taqeta i osarara quqaave tianarave? ");
INSERT INTO omw_a_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","E nara saiqa nrora saiqave varenarave? Tiri haivaqasa haaru qumina mwatani variqata naavuniaa sara nrorave. Mwisa manaa nrorave. Mwirara Kotira vukuqi qara ntuva tova mwitaama tiro: Mwiva naavuniaa sara nurave, turave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mwisa mwitaa tuvaro Iesusiva tiqaro, Ne quqaa qua tianira riaate. Haaru mwi entara Mosesiva ini haivaqasa sara niqaro sia quqaa naavuniaa sara mwisa nurave. Ni qova, mwivama naavuniaa sara quqaa sara niarivama variso. ");
INSERT INTO omw_a_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mwatani variasa mwisa qaqi variqi vuate tiro, naavutairo uto vari vaitiva, mwi vaitivama Kotira saravano variso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mwitaa tuvata mwisa tiqata, Nrorao, so e mwi sarara tiri timwiqira vuane, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tuvaro Iesusiva tiva niro tiqaro, So ne qaqi variqi vi sarava mwaa mwivama varuqo. Ne hunani nriariva siama sara nraataa hianarove. Niara quqaa mwivave tiariva siama mwira nramari nraata hianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ne vaasa iniara tiqana, Né ni taqetavata sia niara quqaa mwivave tiavo, turave. ");
INSERT INTO omw_a_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ni qova ni miari nraase qorasa, mwisa ne hiarinani nrivarave. Mwisa ne hiarinani nrivaqena ne siama mwisa qoririma nataanirave. ");
INSERT INTO omw_a_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ne naavusaina sia nena vu nraato tusena saiqa vararera tuvuvave. Ne ni titaira mwutusa vahi saiqara vararera tuvuvave. Ni titaira Kotira mwutusa vahiva mwitaamama vahirove. ");
INSERT INTO omw_a_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mwiva nraase qora ni misa ne mwoku raupirima saasorave. Ne mwisaqaa ntaqaihiqi vina esaara entaqaa vara tivuma saarita qaqi variqita vivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Qaiqaa ni titaira mwira mwutusa vahiva mwitaamama vahirove. Esaa nraase qora ni mwira mwaaqu taqeta quqaa mwivave tisa, mwisama qaqi variqita vivarave. Ne esaara entaqaa variqana mwisa tivuma saarita qaqi variqi vivarave. So ni qora mwutusa vahiva mwitaamama vahiso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Iesusiva tiqaro, Ne naavutaina tuvu mperetivave, turara tita, Iutaa nroranravuvano nrutu nrauru tita tiqata, ");
INSERT INTO omw_a_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Qaqao, mwi vaitiva Iesusiva Sosepira mwaaquvanove. Mwira nrosa qosa te taqaunarave. So naraqamave mwiva ne naavutaina tuvuvave tiso? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mwisa mwitaa ti varuvaro Iesusiva tiqaro, Eqaate. Né sia nrutu nrauru tiate. ");
INSERT INTO omw_a_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni qova ni titaiva sia vaiti mwo vitairera, mwi vaitiva siama ne hunani so nrianarove. Ni qova vitaarisa mwisaqaima ne hunani nrivarave. So mwisa nrivaqe ne esaara entaqaa mwisa vara tivuma saarita mwisa qaqi variqi vivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Haaru poropeti vaiti mwovano mwitaama qara ntuva tero tiqaro, Naatiara Kotiva esaa nraase qora tiva ni varirata mwira saiqa ntapihivarave, turave. (Ais 54:13) Ni qova saiqa tiva nirata mwisa ni qora qua riesa mwisaqaima ne hunani nrivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","So sia vaiti mwovano ni qora taqaiva varirave. Ne Kotiva hinataina tuvuva, neqai mwira taqaurave. ");
INSERT INTO omw_a_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ne quqaama tuqo. Niara quqaa mwivave tiariva qaqi variqiro vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nraase qoravano sara nreta qaqi variqi viva ne mwaa mwi saravama varuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ini haivaqasa qumina mwatani variqata naavuniaa sara, mwira nrutu manaa mwi sarara nravaqi viqatavata uro qutu vurave. ");
INSERT INTO omw_a_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","So mwo saravano naavutairo tuvirave. Mwi sarara nraariva siama esaara qutu vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","So ne qaqi variqi vi sarava mwiva naavutaina tuvuvave. Mwovano mwi sarara nraariva, mwiva qaqi variqiro vuanarove. Ne sara mwirera nena mativata nena mwavantavata mwianirave. Mwatani variasa qaqi variqita vuate tina, ne mwira nianirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tuvaro Iesusiva mwitaa tuvata Iutaa vaiti nroranravuvano niariqai irora hita tiqata, Mwiva nataama serove nai mwavanta tiri timwiraqe nraanarave? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesusiva mwisa tiva niro tiqaro, Quqaama ne tuqo. Ne mwatani mwatatai nraaqiarava ne variarita né sia ni mativata nraarevata nraivera, né siama qaqi variqita vivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ni mativata ni nraarevata nraariva qaqi variqiro viraqe ne esaara entaqaa mwira qaqi vara tivuma saanirave. ");
INSERT INTO omw_a_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ni mativano sara tanarama vaisaro ni nraarevanovata nramari tanarama vaiso. ");
INSERT INTO omw_a_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ni mativata ni nraarevata nraariva niqi variraqena ne mwiraqima varianirave. ");
INSERT INTO omw_a_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ni qova mwiva qaqi variqiro viva variqaro mwiva ni titaisanama ne mwiva qaqi variqiro viraqaataina nevata mwaini uto qaqi variqina vuqo. So mwira votima sero vaiti mwovano ni nravaqiro vuariva niqaatairo qaqi variqiro vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","So ne mwi sarava naavutaina tuvuvave. Ini haivaqasa haaru mwo sara manaa nravaqita vita uro qutu vurave. So sia ne mwi sarara voti huvama varuqo. Ni sara mwaa nraariva esaa enta qaqi variqiro vuanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesusiva Kapeniaani mwaara nraavuqi variqaro mwi quara tura. ");
INSERT INTO omw_a_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iesusiva mwi quara tuvata mwira vataqita nruosa mwonravu variqata mwi quara rieta qaqao tita, Mwi quava muaara ntai quarama tiso, Tavave mwi quara so ntapihianarove? Sia te so ntapihianarave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mwisa tirema seta mwitaa ti varuvaro Iesusiva ntapihuvata mwira vataqita nruo vaitisa mwirara nrutu nrauru tiqata mwira irora hi varuvaro Iesusiva tiqaro, Mwi quara saarave niara nrutu nrauru ti variavo? ");
INSERT INTO omw_a_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","So ne mwatani mwatatai nraaqiarava varuqo. Ne naatiara uto ntantena nena variavara qoqaraanani uro variarita né mwira taqeta nataave hivarave? ");
INSERT INTO omw_a_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Vaitivano mwaraqura vataava varisaro mwira mwaraquravano mwiraqi varisarora tiro, mwi vaitiva qaqi varirave. Mwira mwaraquravano mwi vaitiraqi sia varirera, sia mwira mwavantavano mwira so saahaqa hiraro mwiva qaqi variqiro vuanarove. So ne vaasa turara sia ne qumina mwavantara turave. Ne qaqi variqi vi mwaraqura osarara ini tiva nurave. ");
INSERT INTO omw_a_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ne qaqi variqi vi osarara ini tiva nurave. Ne mwitaa tuqata né hininravuvano sia ni quara quqaa quave tiavo, tiro. Iesusiva haaru hoqaro entaraqaatairo vaiti mwonravuvano naatiara mwirara sia quqaa mwivave tisa ntapihi sora. Vaiti mwovano mwira nravutaasa uro tiva niro mwira qovarama saaniravata ntapihi sora. ");
INSERT INTO omw_a_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mwisa mwitaa mwitaa hirara ntapihi sero Iesusiva mwisa tiva niro tiqaro, Mwirara rieqanama ne vuni tiqana, Sia ni qova sove tirera, sia mwovano ne hianirani so nrianarove, turave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mwitaa tuvata mwira saara Iesusira vataqita vusa airivano mwira esaara qaqira seta nrima ntanteta vura. ");
INSERT INTO omw_a_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mwitaa huvaro Iesusiva nai nraaqiara 12 nravu sapara hiro tiqaro, Névata mo? Né ni qaqira seta vireratave hiavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tuvaro Saimoni Pitaava mwira tiva mwiro tiqaro, Nrorao, tirenravu ta vaitiva hinanive vuanarave? Ema qaqi variqi qua osarara tiaravama variaro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tirenravu iara quqaama mwivave tiqatama ntapihise taqaurara eqaima Kotira sotata vaitivano Kotiva hinataira tuvuaravave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mwitaa tuvaro Iesusiva mwisa tiva niro tiqaro, So ne ini 12 nravu nraarama sena vitaurave. Ne 12 nravu ini nraarama tauraqitairovata mwokuvano uaqa hi vaanavama variso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesusira nraaqiara 12 nravuqitairo Iutaasiva Saimoni Isikeriotira mwaaquvano naatiara Iesusira qovarama saanirara rieqaro Iesusiva mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mwiraqaataita Iutaa vaiti nroranravuvano mwira ru sarerata uti varuvarora tiro, Iesusiva sia Iutiaani nruaraitiro, qaqira sero Kariri mwatani variqaro mwiniqai nrue varura. ");
INSERT INTO omw_a_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mwi entara omwata nro entava mwo qaumatoqa hura. Mwira nrutu Haraara Nraavu omwata. (Haaru mwisa haivaqasa qumina mwatani variqata haraara nraavuqi varu entarara rieqatama omwata nrora.) Omwata nro entava qaumato vahuvata ");
INSERT INTO omw_a_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iesusira qatanravuvano tiqata, So mwaini sera vetara Iutiaani virata i vataqita visa i saiqa taqaate. ");
INSERT INTO omw_a_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nai nrutu viriniqa hiarive tiro, mwovano sia nai saiqa uqeta sasa hirave. E quqaa mwi saiqara mwi saiqara vare varirera, so uro ntera qoqaa variqara mwi saiqara mwi saiqara varairata esaa mwisa i taqaate, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mwira qatanravuvano Iesusirara sia quqaa mwivave tiqatara tita, mwisa mwitaa turama. ");
INSERT INTO omw_a_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mwitaa tuvaro Iesusiva tiva niro tiqaro, Ne mwini vuari entava siama nri ntaiso. Né soma api enta vivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mwatani variasa sia ini nravutaaqa hivarave. Ne mwisa saiqara uaqa hi saiqarave tiva seqana ntapihi tiva nurave. Mwitaama vutu seqana tiva nuqata mwisa ni nravutaaqa hi variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nénravu omwata nrarera hianani vuate. Ne mwini vuari entava sia nri ntaisana ne mate sia vuanirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","10","Iesusiva mwitaa tiva sero Karirini varuvata mwira qatanravuvano omwata nrarera hunani vuvaro Iesusiva vari sero naatiara mwivavata mwini viro. Mwiva sia qoqaa viraitiro, uqeta sero mwini vura. ");
INSERT INTO omw_a_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Vuvata Ierusaremini omwata nroraqi Iutaa vaiti nroranravuvano mwirara aitutu hi varita tiqata, Mwiva tanave variso? ti varura. ");
INSERT INTO omw_a_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mwitaa ti varuvata qaqi nraase qoravano Iesusirara tirema seta mwo qua mwo qua tura. Hini husa mwirara tiqata, Mwiva suqe vaitivanove, tuvata hini husa mwirara tiqata, Qaqao, mwiva nraase qora api aaraqai tiva ni vari vaitivave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Iutaa nrora vaitinravu nraatu aatu hiqata mwisa sia Iesusirara vutu seta mwitaa tura. Mwisaqitairo sia mwovano vutu serovata tura. ");
INSERT INTO omw_a_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mwitaamaqita vuvaro omwata nro entava hininravu taiqa vuvaro Iesusiva nrintero Kotira nraavu nroraqi variqaro Kotira qua nraase qora tiva ni varura. ");
INSERT INTO omw_a_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mwiva tiva ni varuvata Iutaa vaiti nroranravuvano mwira qua rieta nriharama vita tiqata, Qike, mwiva sia tirivata sikuru tivave. Nataama serove mwiva mwo qua mwo qua osara so ti variso? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mwitaa tuvaro Iesusiva tiqaro, Siama ne nena qua mwasaasa ini tiva ni varuqo. Kotiva ni titaisana ne mwira qua mwasaasama ini tiva ni varuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Iesusiva mwitaa tiva sero mwiva tiqaro, Kotira mwutusa vahirara rieqaro mwira saiqa varaataa hiariva, mwivama ni qua tusama sero tiqaro, Mwiva Kotira quama ti variso, mwiva nai quama ti variso, tianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mwovano nai vu nraato tusero qua ti vari vaitiva, mwi vaitiva nai nrutuaraqai rieqaro varirave. Mwovano nai titaira nrutuaraqai riemwaqiro vi vari vaitiva, mwi vaitiva quqaa quaqaima tisaro siama unra qua mwiraqi vahirove. ");
INSERT INTO omw_a_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","So quqaa ini haivaqava Mosesiva qua mwaara Kotiva mwitaa mwitaa hiate tu quara ini tiva nurave? So sia iniqitairo mwovano mwi quara vataqiro vi varirave. Mwitaa hiqata né naraqamave ni ru sarerata uti variavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Iesusiva mwitaa tuvata mwini uairama vita varusa tiqata, E ueraqama vuaro. Tavave i ru sarera uti variso? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tuvaro Iesusiva tiqaro, Ne (mwaara entaqaa) nrora saiqa kuaiqa varauqata né mwirara nriharama vuavaroma sia ini sasa iso. ");
INSERT INTO omw_a_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ini haivaqava Mosesiva mwaara qua tiqaroma qoraisi nraaqiarara mwira mwavanta toqa saate. (Qoraisi nraaqiara mwatataivata 8 enta nritarairata mwira mwavanta toqa saate,) turave. So sia Mosesiva tauraaqama mwi quara turave. Mosesira haivaqasavara mwi quara vuniqamase turave. So né mwi quara rieqatama 8 enta nritarairata qaqi entaqaave, mwaara entaqaave, né qoraisi nraaqiara mwavanta toqa nate variarave. ");
INSERT INTO omw_a_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mosesira qua nteqa saarorave tiqatama né mwaara entaqaa qoraisi nraaqiara mwavanta toqa nate variarave. Mwitaa hi variavana ne mwaara entaqaa nriqa vi vaitira suqema sauqata né naraqamave mwira saara ni irora hi variavo? ");
INSERT INTO omw_a_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Né niqaa qua vatarera hiqatama, hauri qumina néta vu nraato tiraqa niqaa qua vatevorave. Né quqaa vahiani inraisaraqaara niqaa qua vataate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Iesusiva mwitaa ti varuvata Ierusaremiqinaasa mwonravuvano Iesusirara mwo vaitinravu sapara hita tiqata, Mwi vaitirave mwisa ru sarerata uti variavo? ");
INSERT INTO omw_a_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","So taqaate. Mwiva qoqaa variqaro qua ti varisata mwisa sia nrima mwiraqaa mwirara mwo qua tiavo. Quqaave mwisa Iesusirara mwiva mesaiaa vaitive tiavo? ");
INSERT INTO omw_a_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","So te Iesusiva mwitairo nri osarara ntapihuro. Mwiva mwi mwatusaraqitairo nrivave. Mesaiaa vaitivano qovarama viraro siama tiriqitairo mwokuvano mwiva mwitairo nriani osarara so ntapihianarove, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mwitaa ti varuvaro Iesusiva Kotira nraavu nroraqi mwasaasa tiva ni variqaro aasara ntava sero mwisa saparama natero tiqaro, Quqaa né ni ntapihi saarave? Quqaa né ne mwitaina nru osarara ntapihi saarave? So sia ne nena vu nraato tusena nruvave. Ni titaiva mwiva quqaa saiqa vare varivave. Né sia mwira ntapihiarave. ");
INSERT INTO omw_a_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ne mwira ntapihurave. Mwivama ni titaisana ne mwiva hinataina tuvuvave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iesusiva mwitaa tuvata mwi quara saara mwira ntavaaqavu saare tiqatavata sia so mwira tu varora. Iesusira ruse entava sia nri ntovatara tita, mwisa sia so mwira tu varora. ");
INSERT INTO omw_a_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mwitaa huvata nraase qora mwisaqitaita airivano Iesusirara quqaa mwivave tita. Mwisa mwataama tita, Iesusiva nrora saiqa vare variso. Mesaiaa vaitivano nriariva mwiva Iesusira saiqa sove nraatara saanarove? Sia so mwira nraatara saanarove. Iesusiva mwivama mesaiaa vaitivano variso, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisi vaitinravuvano variqata riovata nraase qoravano uairama vita Iesusirara tirema seta mwitaa ti varuvata Parisi vaitinravuvata, Kotira saiqa vara mwate varu vaitisa mwisa nronranravuvata, mwisa niari porisi titovata mwisa Iesusira ntavaaqavu seta karavuqi sarerata vita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mwisa vuvaro Iesusiva tiqaro, Ne ini sapata pataqa vari senama mwata mwaaqaataina ni titaiva hinani virerave. ");
INSERT INTO omw_a_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mwi entara né ni huaama saare tira, siama so ni huaama sevarave. Né sia soqamase virera hinani ne virerave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mwitaa tuvata Iutaa vaiti nroranravuvano nai sapara hi nai sapara hita tiqata, Mwiva taini viraqeve te sia so mwira huaama saanarave? Mwiva Kiriki mwatusa mwonravuqi Iutaa mwonravuvano variananive uro qua tiva nireraro virerarove? ");
INSERT INTO omw_a_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mwiva nariara tiqaro, Né ni huaama saare tira siama so ni huaama sevarave, tiso. Né sia soqamase virera hinani ne virerave, tiso. Mwiva mwitaa tiqaro nara quave tiso? Siama te mwira qua ntapihita huro, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mwitaa tuvaro omwata nro entava esaara enta nri ntora. Mwi entarara nrora entave tura. Esaara enta nri ntovaro Iesusiva mwi entaraqaa tiviro paatiro tiqaro, Nramari nraataa hiariva ne hunatairo soma nrima nraanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kotira vukuqi qara ntuva to quava niara mwitaama tiro: Niara quqaa mwivave tiariva variraro mwira mwutusaqitairo rumwu votima sero qaqi variqi vuani nramariva ntavaqiro vuanarove, turave, tiro. (Ais 44:3) ");
INSERT INTO omw_a_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesusiva tiviro variqaro mwi quaraqaa ntuva sero Kotira Mwaraqura nianirara tiro. Nraase qoravano Iesusirara quqaa mwivave tisa Kotira Mwaraqura varerara tura. Mwi entara Iesusiva sia qutu viro qaiqaa qaqi tiviro naavuni vurara tiro, sia Kotira Mwaraqura nu entava vahura. ");
INSERT INTO omw_a_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Iesusiva mwitaa tuvata nraase qora uairama vusa airivano tiqata, So quqaama Iesusiva poropetivano variso. Kotiva mwira saahaqa hi varisaro mwiva mwira qua ti variso, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tuvata mwonravuvano tiqata, Mwiva mesaiaavanove. Mwiva Kotiva titai vaitiva tiri saahaqa hiarivave, tita. Tuvata mwonravuvano qaqao tita, Mesaiaavano siama Kaririqitairo nrianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kotira vukuqi mesaiaa vaitiara qara ntuva tova mwitaama tiro: Mesaiaavano Devitira kuaa osarama variraro Vetarahemi Devitiva varu mwatusaraqi mwira mwata taanarove, turave, tita. (Maika 5:2) ");
INSERT INTO omw_a_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mwitaa tiqata nraase qora ntuvaaquama vita varusa hininravuvano Iesusirara qamwateqata varuvata hininravuvano sia mwirara qamwateqata varura. ");
INSERT INTO omw_a_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hininravuvano Iesusira karavuqi sarerata uti varura. So mwi entara sia mwisaqitairo mwokuvano Iesusira tu varora. ");
INSERT INTO omw_a_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Porisi vaitinravu vaasa titosa nrima ntanteta Kotira saiqa vara mwate varusa mwisa nronranravuvata, Parisi vaitinravuvata, mwisa hunani uro ntovata mwisa tiqata, Qaqao, né mwira vita vareta nriataara vaisata naraqamave qaqi nriavo? tuvata ");
INSERT INTO omw_a_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","porisinravuvano tiqata, Te riauraro mwiva sia qumina vaitivano qua tintema sero qua ti variso, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tuvata Parisi vaitinravuvano tiqata, So nevata mwira unra quara quqaa quave tita hiavo? ");
INSERT INTO omw_a_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Né ntapihitave hiavo? Tavave tiri nrora vaitinravuqitairove, Parisi vaitinravuqitairove, Iesusirara quqaa mwiva mesaiaa vaitivano variso tiso? Siama tirinravuqitairo mwovanovata mwitaa tiso. ");
INSERT INTO omw_a_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Qaqi qumina nraase qora uairama vita variasa sia Mosesira qua mwaara so ntapihi riaarara tiro, mwira saara Kotiva mwisa qoraqama nataanarove, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Parisi vaitinravuvano mwitaa tuvaro Parisi vaiti mwokuvano Nikotimaasiva mwiva entaqi Iesusira uro taqova, mwiva qaqao tiro, ");
INSERT INTO omw_a_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Te teta qua mwaara rieqatama sia ko tiraitita, vaitiqaa qumina qua vataarorave. Te ko nraanteta tiataarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mwitaa tuvata mwisa tiqata, E mo? E Kariritaira nriaravave? E Kotira vukuqi taqaane. E mwiqi taqairaro siama Kariritairo poropeti vaitivano qovara hianarove, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mwitaa tiva seta niari nraavuni niari nraavuni vuvaro Iesusiva Oripi taaqiqaa uro varura. ");
INSERT INTO omw_a_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","2","Mwira qararaara toqa entaqi Iesusiva uro ntantero Kotira nraavu nroraqi vuvata nraase qora airivano uairama vita varuvaro Iesusiva mwatasaa viro variqaro qua tiva ni varura. ");
INSERT INTO omw_a_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tiva ni varuvata mwaara osara ti varu vaitisavata, Parisi vaitinravuvata, mwisa nraase mwo vita vareta nrura. Mwi nraaseva vaati vataava mwo qoraisivata nrue varuvata mwisa taqama seta mwira viteta Iesusiva hunani uro nraase qora vuqaa mwira sovaro tiviro varuvata mwisa Iesusirara tiqata, ");
INSERT INTO omw_a_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mwaara ti variarao, mwaa nraaseva vaati vataava mwo qoraisi vatama sero nrue varisata te mwira taqeta tu vareta nruro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesira mwaara quavano mwitaama tiro: Nraasevano mwitaa hirera, oriqotaita ntuqutu saivaro qutu vuarive, turave. So e mo? Nara quave mwirara tinarave? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iesusirara api qua tiraqe te mwiraqaa qua vataare tiqata mwisa mwitaa tuvaro Iesusiva sia qua tiraitiro, kakataama viro nai vukahiqo mwataqaa qara nti varura. ");
INSERT INTO omw_a_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Qara nti varuvata mwisa tivita variqata mwo qua mwo qua Iesusira sapara hi varuvaro Iesusiva mwaaviara viro mwisara tiqaro, Iniqitairo mwovano sia uaqa hi saiqara utuariva, mwiva nraante ori vara sero mwira ntuqutu saarive, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iesusiva mwitaa tiva sero mwiva qaiqaa kakataama viro mwataqaa qara nti varuvata ");
INSERT INTO omw_a_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","mwisa mwi quara rieta kuaiqa kuaiqavano mwiqitaita qaqira seta veva nteqata vura. Naapainravu nraante veva nteta vuni vuvata qaraaha vaitinravu mwisa naatiara veva nteta vita mwisa Iesusira mwini seta vuvaro Iesusiva nariaraa variro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesusiva mwaaviara viro taqovaro mwi nraaseva vaasa tiviro varunani nariaraa varuvaro Iesusiva tiqaro, Mwisa tainive variavo? Siave mwovano iqaa qua vataariva variso? tuvaro nraase mwiva tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nrorao, sia mwovano mwitaa iso, tuvaro Iesusiva mwira tiva mwiro tiqaro, So nevata sia iqaa qua vatarerave. So ena vuane. Virava siama naatiara qaiqaavata uaqa hi saiqara utuante, tiro. Turama. ");
INSERT INTO omw_a_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesusiva qaiqaa nraase qora tiva niro tiqaro, Ne mwataniaa ovavano varuqo. Ni vataqiro nriariva siama rupi hiraqi nruaanarove. Mwiva ntuvaahaaniraqa nrueqaro qaqi variqiro vuanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Iesusiva mwita tuvata Parisi vaitinravuvano tiqata, So e enara variqara ena nrutu tuaahere varianarara tiro, i quavano qumina quama vaiso, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mwitaa tuvaro Iesusiva qaqao tiro, Ne variqana nena saiqara tiqana siama qumina qua tuqo. Ne nena mwitaina nru osarara ntapihi saurave. Ne nena vuani osarara ntapihi saurave. Mwitaa hurara tiro, ni qua quqaa quama vaiso. Ne mwitaina nru osararave, ne vuani osararave, né sia ntapihivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Né ko tiqatama né vaiti vu nraato vahiraqa ko ti variarave. Mate ne sia vaiti mwo ko tiva sena mwiraqaa qua vatauqo. ");
INSERT INTO omw_a_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ne ko tiataa hiraqena soma ne ko avuqavuma sena tianirave. Ne ko tiqana siama nenaraa ko tianirave. Ne ko tiariro ni qova ni titaiva variqaro ni saahaqa hiraqe ne avuqavuma sena ko tianirave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ini mwaara qua qara ntuva tova mwitaama tiro: Vaiti taaratanavano qua tiqatama kuaa quaqai tivera, so mwitana quavano quqaa quama vahianarove, turave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","So ne nena quara quqaa quave tiariro ni titaiva ni qova, mwivavata ni quara quqaa quaqaima tianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Iesusiva mwitaa tuvata mwisa tiqata, I qova tana varisarave ti variaro? tuvaro Iesusiva tiqaro, Né sia ni ntapihi saasara tita, né ni qoravata siama ntapihiavo. Né ni ntapihi saatirio, né soma ni qoravata ntapihiatirio, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesusiva Kotira nraavuqi munima se varuraqi variqaro mwi quara tiro. Tuvaro mwira ruse entava sia nri ntovarora tiro, sia mwovano mwira ntavaaqavuqiro karavuqi sora. ");
INSERT INTO omw_a_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesusiva qaiqaa tiva niro tiqaro, So ne vuarita né qumina niara huaamaqi vita uro néta qora saiqa rirante qaqi qutu vivarave. Mwitaa hiqata ne vuanirani né siama so vivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mwitaa tuvata Iutaa vaiti nrora nravuvano tiqata, Mwiva nara quave tiso? Mwiva nai tiqaro, Ne vuanirani né sia so vivarave, tiso. Mwiva naivano nai ru sareraro uti variqarove mwitaa ti variso? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mwitaa tuvaro Iesusiva tiqaro, Ne viritaina tuvuqata né miataita nriasave. Né mwaa mwataraqaataita nriasave. Ne sia mwaa mwataraqaataina nruvave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ne vaasa iniara tiqana, Né néta qora saiqa rirante variqi vita qutu vivarave, turave. Ne qaqiqai variqi vurave tuqo. Né sia mwi quarara quqaa quave tivera, quqaa né néta qora saiqa mwira rirante qutu vivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mwitaa tuvata mwisa mwira sapara hita tiqata, So e ta vaitivave hiaro? Tuvaro Iesusiva mwisa tiva niro tiqaro, Ne vuni ini tiva nuva ne mwivama huqo. ");
INSERT INTO omw_a_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ne iniqaa qua vataari quava, mwo qua mwo qua vaisana mate sia ne mwi quara tirerave. Ni titaiva ni tiva mi quara, ne mwi quaraqai mwatani varisavata tiva nirerave. Ni titaiva quqaa quaqai ti varivave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iesusiva mwitaa tuvata mwisa sia ntapihi seta Iesusiva nai qorara tu quara riora. ");
INSERT INTO omw_a_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mwisa sia ntapihuvaro Iesusiva qaiqaa tiqaro, Ne mwatani mwatatai nraaqiaravama varuqo. Ne variarita né ni tuaahera saivaro mwiraqaatairo ini vu nraato ntapihirata né ni osarara ntapihi rietama niara so mwiva qaqiqai variqiro vivave tivarave. Né mwi entarama ne sia nenaqamase mwo saiqa varaura ntapihita ni qova tiva mi quara mwi quaraqai tiva nuravata ntapihivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ni titaiva ni vatama sero variqaro mwiva sia ni qaqira saanarove. Ni titaiva ni vatama sero varisana ne mwira mwutusa vahi saiqara vare varuqaro mwiva niara qamwateqaroma sia ni qaqira saiso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iesusiva mwi quara ti varuvata airivano mwi quara riosa mwirara quqaave tita. ");
INSERT INTO omw_a_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iutaa mwonravuvano mwirara quqaa mwivave tuvaro Iesusiva mwisara tiqaro, So né ni qua riemwaqita vivera, né quqaama ni vataqita nrisa varivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Né quqaa qua ntapihise riaivaro quqaa quavano ini avantu sairata né qaqi varivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mwitaa tuvata mwisa qaqao tita, Te teta haivaqara Evarahaamura nraaqiarama varuro. Sia mwovano tiri rupa taisata te mwira saiqa vare varuro. So naraqamave e tiriara ini avantu sairata né qaqi varivarave tiaro? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Mwisa mwitaa tuvaro Iesusiva tiqaro, Ne quqaa quama tuqo, Né uaqa hi saiqara uti variavaro ini uaqa hi saiqava rupa taisatara tita, né mwira saiqaqai vare variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nraavu qova variraro rupataari vaitiva siama esaa enta mwiravata variqiro vuanarove. Nai mwira mwaaquvanoma mwiravata mwaasota variqiro vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ne mwira mwaaquvano ini avantu saarita né quqaaqama seta qaqi varivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Né Evarahaamura nraaqiara variara mwira ne ntapihi saurave. Mwitaama variqatavata né ni quara qumina quave tiva seta, ni ru sarerata uti variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ne nena qosantiri variqana mwi inraisara taqaurara ini tiva ni varuqo. Né néta qora vatama seta variqata taqaa saiqara né mwi saiqarama vare variavo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Iesusiva mwitaa tuvata mwisa tiqata, Tiri qova Evarahaamuvave, tita. Tuvaro Iesusiva tiqaro, Né quqaa Evarahaamura nraaqiara variatirio, né mwiva varo saiqarama névata varaatirio. ");
INSERT INTO omw_a_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kotiva quqaa qua tisana ne mwi quara riaura ini tiva nuqata né ni ru sarerata uti variavo. Evarahaamuva sia né hiante hurave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Né néta qova varai saiqaraqaima vare variavo, tiro. Mwitaa tuvata mwisa tiqata, Sia te sapa nraative. Tiri qova mwiva Kotivave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tuvaro Iesusiva tiqaro, Kotiva ini qova varitirio, ne mwiva hinataina uto inivata mate mwaa varura niara ini mwutusa ntisata variatirio. Sia ne nena vu nraato tusena nena saiqa vararerana tuvuvave. Kotiva ni titaisana tuvuvave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ne mwitaa tuqata né naraqamave ni qua sia ntapihiavo? Saivaqe ne ini tiva niase. Né ne tu quara sia riaasama variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Saataaniva ini qova varisata né mwira mwutusa vahiraqai utuqita vi variarave. Haaru vuniqama sero Saataaniva variqaro vaiti ruse varuvaqai varurave. Qutaaqama vahi inraisavave, quqaa saiqavanove, sia mwiraqi vaisarora tiro, mwiva sia quqaa qua ti varirave. Mwiva unra tiqaro unra tiara mwira qova variqarora tiro, unra qua mwira nai qua tanarama tirave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mwira saiqa mwitaama vaisana ne quqaa qua tuqata né ni quara sia quqaa quave ti variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Iniqitairo tavave niara uaqaahi saiqara varaiso tianaro? Né siama so niqaa qua vatevarave. Ne quqaa qua ti varuqata naraqamave né ni quara sia quqaa quavave ti variavo? Sai ne ini tiva niase. ");
INSERT INTO omw_a_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kotira nraaqiaravano Kotira qua rie varirave. Né sia mwira qua riaasara tita, né sia mwira nraaqiarama variavo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Iesusiva mwitaa tuvata Iutaa nroranravuvano tiqata, Te iara Sameriaaniaava ueraqama viso turava, mwi quava quqaa quama vaiso, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tuvaro Iesusiva qaqao tiro, Siama ne ueraqama vuqo. Ne nena qora nrutu tuaahere varuqatama né ni nrutu qoraqama mateta hiavo. ");
INSERT INTO omw_a_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","So sia ne nena nrutuara nroraqama sena riauqo. Ni nrutu tuaaheraiva variso. Mwiva ntapihi sero ko ti varivave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ne quqaa qua tianira riaate. Ni qua riemwaqiro vuariva siama qutu vuanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iesusiva mwitaa tuvata Iutaa nroranravuvano tiqata, Mwitaa tiarata te i taqaurara e ueraqama vuaro. Tiri haivaqava Evarahaamuva variqiro viro uro qutu vurave. Poropeti vaiti mwosa mwosa variqita vita esaa qutu vurave. Mwisa esaa qutu vuavara e tiqara, Ni qua riemwaqiro nruaariva siama qutu vuanarove, tiaro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tiri qova Evarahaamuva nrora vaitivano variqiro viro uro qutu vurave. E sia so Evarahaamurara tiqara, Ne mwira nraatara saarivave, tinarave. Poropeti vaitinravuvata nrora vaiti variqita vita uro qutu vurave. E nataa hira vaitiva varirera hiqarave mwitaa ti variaro? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mwitaa tuvaro Iesusiva tiqaro, Ne nena nrutu tuaahere variarirovauma ni nrutuvano qumina vahianarove. Ni nrutu tuaaherase variva, mwiva ni qovave. Né mwiarama Kotiva tiri mwariqavano variso tiarave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Né sia mwira ntapihiarave. Ne mwira ntapihurave. Ne tiqana, Ne sia mwira ntapihi saurave, tiarirovauma ni quavano ini qua votima sero unra qua vahianarove. So ne Kotira ntapihina mwira qua riemwaqina vurave. ");
INSERT INTO omw_a_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ne mwatani tuvirera hiava entara ini haivaqava Evarahaamuva ni qamwata matorave. Ne mwatani tuvuavaro mwiva ni taqovaro mwira mwutusavano suqe huvaro varurave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iesusiva mwitaa tuvata Iutaa nroranravuvano tiqata, Qaqao, e sia 50 ihi vara saraitira, qaraaha vaitivano variqarama ne ini haivaqara Evarahaamura taqaurave tira hiaro, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tuvaro Iesusiva tiqaro, Haaru ini haivaqava Evarahaamuva sia varu entara ne qaqi variqina vuavavave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iesusiva mwitaa tuvata mwisa ori vara seta mwira ntuqutirerata huvaro Iesusiva quqeta sero Kotira nraavuqitairo veva ntero vurama. ");
INSERT INTO omw_a_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesusiva viqaro taqovaro vaiti mwovano nai nrora visosaqitairo vu qipa vuva varura. ");
INSERT INTO omw_a_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mwira taqeta Iesusira nraaqiaranravuvano Iesusira sapara hita tiqata, Mwaara ti variarao, tava Kotira qua nteqa sairaqaarave mwi vaitira vu nai nrora visosaqitairo qipa viso? Naive iso, mwira nrosa qosave iso? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mwitaa tuvaro Iesusiva qaqao tiro, Siama nai Kotira qua nteqa sairaqaarave, mwira nrosa qosa Kotira qua nteqa saaraqaarave, mwira vu qipa viso. Né mwi vaitiraqaataita Kotira kepusavano saiqa varaanira taqaate tiro, mwira vu qipa virave. ");
INSERT INTO omw_a_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kotiva ni titaira saiqa te qataa hianiraqaa varaqita virerave. Entama viraro sia mwovano so saiqa varaanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ne mwatani variqana ne ovavano itaintema sena itamwaqina vuarita mwatani variasa so taqevarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mwitaa tiva sero Iesusiva mwataqaa taara vihi sero horaqama sero viti vu qipa vu vaitira vuqaa ntaaqau mwatero tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Uto Siromi nrukaqi — Titai nramariraqi — ena viri hiqaane, tiro. Mwitaa tuvaro mwi vaitiva Iesusiva tuntema sero uro nai viri hiqama sovaro mwira vu ntapairi vuvaro mwiva mwitairo uro ntantero so taqamwaqiro nriro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mwiva so taqamwaqiro nri varuvata mwira nraaqani varusa taqovaro aara tosani variqaro mwitaa inraisa miate ti varu vaitiva qaqi nruvata mwisa mwira taqeta tiqata, Mwaa ta vaitivave iso? Mwiva aara tosani mwatasaa viro variqaro mwitaa inraisa miate ti vari vaitiva, mwaa mwivave iso? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tuvata mwo husa tiqata, So mwira mwivave, tita. Tuvata mwo husa qaqao nai mwo vaiti mwira viri voti hivama nriso tita. Tuvaro mwi vaitiva nri ntero nai tiqaro, Ne mwaa mwivama iso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mwitaa tuvata mwisa mwira sapara hita tiqata, Nataama saararo i vu ntapairi visarave e taqaaro? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tuvaro mwiva mwisa tiva niro tiqaro, Vaiti mwo mwira nrutu Iesusiva taara vihi sero horaqama sero ni vuqaa ntaaqau matero niara tiqaro, Siromi nrukaqi uto ena viri hiqaane, tisana ne uto hiqama sauqaro ni vu ntapairi visanama ne so taqamaqina nruqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mwitaa tuvata mwisa mwira sapara hita tiqata, Mwiva taini visarave nriaro? tita. Tuvaro mwiva tiqaro, Nai tainive viso? Sia ne mwira taqauqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tuvata mwisa haaru vu qipa vu vaitira mwira vitaqita uro Parisi vaitinravuvano varunani sora. ");
INSERT INTO omw_a_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Iesusiva mwaara entaqaa hora ntaaqau sero mwi vaitira vu ntapairi sora. ");
INSERT INTO omw_a_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mwisa Parisi vaitinravu varunani mwira uro sovata Parisi vaitinravuvano mwi vaitira sapara hita tiqata, Nataama saisarove i vuvano ntapairi viso? tuvaro mwiva tiqaro, Mwiva hora vara sero ni vuqaa ntaaqau taisana ne uto nena viri hiqama sauqaro ni vu ntapairi visana ne so taqauqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mwiva mwitaa tuvata Parisi vaiti hini husa tiqatama, Mwi saiqara varaiva mwaaraqaa qua nteqeqaro varaivara tiro, mwiva sia Kotiva hinatairo tuvivave, tita. Tuvata hini husa tiqata, Qaqao, nataama serove uaqa hi vaitiva nrora saiqa mwira so varaanarove? tita. Mwitaa tiva seta mwisa niari vutaqaa tusama vita taara qua ti varura. ");
INSERT INTO omw_a_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Qaiqaa Parisi vaitinravuvano mwira sapara hita tiqata, E tiqara mwiva ni vu ntapairi saiso tianarave. Mwi vaitirara e nareve tinarave? tuvaro mwi vaitiva tiqaro, Kotiva mwira saahaqa hi varisaro mwiva mwi saiqara vare variso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mwitaa tuvata Iutaa vaitinravuvano sia mwira quara quqaave tiraitita, mwi vaitirara tiqata, E unra tiqarama ni vu ntapairi viso tira hiaro. Haaru sia i vuvano qipa vurave, tita. Mwitaa tiva seta mwi vaitira nrosa qosa nraarora. ");
INSERT INTO omw_a_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nraarovata nruvata mwitanasa sapara hita tiqata, Mwaa vaitiva initana mwaaquve iso? Quqaa mwira nai nrora visosaqitairo vu qipa vurave? Nataama saisarove mwira vuvano ntapairi visaro so taqaiso? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tuvata mwira nrosa qosa tiqatama, Mwaa vaitiva tiritana mwaaquve. Mwira vuvano haaru visosaqitairo qipa vurave. ");
INSERT INTO omw_a_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nai nataama saisarove mwira vu ntapairi viso? Nai tavave mwira vu ntapairi saiso? Mwiva nrora tuaivama iso. Né néta mwira sapara hiqata taqaivaro mwiva soma nita tiva nianarove, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mwitanasa Iutaa vaiti nroranravu nraatu aatu hiqata mwitaa tura. Iutaa vaiti nroranravuvano vaasa qua tiva teta tiqatama, Vaiti mwovano Iesusirara mesaiaa vaitivano tiri saahaqa hiariva nrivave tirera, mwira saara te mwira irora hiqatama mwaara nraavuqitaita titama saararo veva ntero esaara vuarive, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mwitaa tiva seta qua tiva torara tita, mwira nrosa qosa Iutaa vaiti nroranravu nraatu aatu hita tiqata, Mwiva nrora tuairave. Néta mwira sapara hiqata taqaate, tura. ");
INSERT INTO omw_a_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tuvata mwisa qaiqaa haaru vu qipa vu vaitira nraarama seta tiqata, E Kotira vuqaa variqara quqaa quaqai tiane. Te taqauraro Iesusiva Kotira qua nteqa sai vaitivave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tuvaro mwi vaitiva tiqaro, Iesusiva Kotira qua nteqa sai vaitivave iso suqe vaitive iso ne sia mwira osara ntapihi sauqo. Ni vu qipa vura ntapairi saira mwiraqaima ntapihuqo, tiro. Tuvata mwisa mwira sapara hita tiqata, ");
INSERT INTO omw_a_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mwiva i nataave iso? Mwiva nataama serove i vu ntapairi saiso? tita. Tuvaro mwiva tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ne mwi quara vaasa ini tiva nuqata né siave ntapihiavo? Naraqamave né mwi quara qaiqaa sapara hiavo? Névata mo? Névata mwira nraaqiara varireratave qaiqaa mwi quara ni sapara hiavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tuvata mwisa mwira nroraqama seta irora hita tiqata, Enama mwira nraaqiara variqara mwira qua riaaravave. Te teta haivaqara Mosesira qua riemwaqita vurasave. ");
INSERT INTO omw_a_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kotiva Mosesirara qua tiva tora te riemwaqita vunarave. Iesusiva mwi vaitiva qumina vaitivanove. Te siama mwiva mwitairo nri osarara ntapihuro, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mwisa mwitaa tuvaro mwiva sauqu ntukikiraaqata sero tiqaro, Qike, ni vu ntapairi matai vaitiva, mwiva mwitairo nri osarara né siave ntapihiavo? ");
INSERT INTO omw_a_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Te ntapihi sauraro Kotiva sia uaqa hi vaitira qua rie varirave. Kotiva nai qua rieqata nrue varia vaitisa mwisa quaqai rie varirave. Mwira nrutu tuaahere variasa mwisa quaqai Kotiva rie varirave. ");
INSERT INTO omw_a_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Haaru mwaa mwatara hoqarato entaraqaatairo sia vaiti mwovano nai nrora visosaqitairo vu qipa vura ntapairi sorave. ");
INSERT INTO omw_a_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Iesusiva sia Kotiva hinatairo tuviva hitirio, mwiva siama so ni vu ntapairi mataitirio, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mwi vaitiva mwitaa tuvata mwisa tiqatama, I mwatatoraqaataira e uaqa hiara vaitivama variqira nriaro. E mo? E tirivata mwaara qua tiva timwirerave hiaro? tita. Mwitaa tiva seta mwisa vaiti mwira ntarauqita mwaara nraavuqitaita veva mwaatani sora. ");
INSERT INTO omw_a_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mwira so quara riero Iesusiva mwi vaitira huaama sero mwirara tiqaro, Mwatani mwatatai nraaqiarara e quqaa mwivave tira hiaro? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tuvaro mwi vaitiva sapara hiro tiqaro, Nrorao, mwiva ta vaitivave iso? E ni tiva miraqena ne mwirara quqaave tiase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tuvaro Iesusiva mwira tiva mwiro tiqaro, E taqe variara vaitiva, ne mwaa mwivama iara ti varuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mwitaa tuvaro mwiva tiqaro, Nrorao, quqaama e mwivave, tiro. Tiva sero mwiva Iesusira vuqaa tori sauru raviro mwira qamwata mwatero varura. ");
INSERT INTO omw_a_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mwitaa huvaro Iesusiva tiqaro, Ne nraase qora tusa hirera mwatani tuvuvave. Vu qipa visa qaiqaa taqaate tina, tuvuvave. Qaqi taqe variasa vu qipa vuarive tina, tuvuvave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mwitaa tuvata Parisi vaitinravuvano mwi quara rieta Iesusira sapara hita tiqata, Tiri vuvatave qipa viso? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tuvaro Iesusiva mwisa tiva niro tiqaro, Ini vu qipa visata variasa varivarovauma sia iniqaa quavano vahianarove. Né ni osara sia ntapihise taqaraitita, né tiqata, Te Kotira osara taqaunarave, ti variarave. Mwitaa ti variarara tiro, mwira saara iniqaa qua vahirove, tiro. Iesusiva mwitaa turama. ");
INSERT INTO omw_a_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesusiva mwo quaqaa ntuva sero tiva niro tiqaro, Ne quqaa qua tianira riaate. Vaiti mwovano sipisipi vataa urisaraqi virera sia qetiana vera ntaraitiro, qurisa mwona mwaati ntero vi vari vaitiva mwi vaitiva muara uti vaitivave, mwosa riqaro mwisani muara vare vari vaitivama variso. ");
INSERT INTO omw_a_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Vaiti mwovano sipisipi qetiana vera nteqaro vi variva, mwi vaitiva quqaa sipisipi qovama variso. ");
INSERT INTO omw_a_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Qetiqaa vaivaraara ntaqaihi vari vaitiva mwira taqero so qeti qatua mwataisaro mwiva nai sipisipiara aasara nteqaro nai sipisipi nrutu ntavaqiro visata mwira sipisipinravuvano mwira nrunta ntapihi riaavaro mwisa vitero mwaaqani virave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mwiva mwaaqani nai sipisipi uro sero mwiva nraante vuni vi varisata mwira sipisipinravuvano niari qora nrunta ntapihi seta rieqatara tita, mwira vataqita vi variarave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mwira sipisipinravuvano sia mwo vaiti vataqita vivarave. Mwisa mwo vaiti nrunta sia ntapihi seta rieqatara tita, mwisa mwira nraatu aatu hiqata aatu vivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesusiva mwitaa tiva sero sipisipiqaa ntuva sero tiva nuvata mwisa mwi quara osara sia ntapihiraitita varura. ");
INSERT INTO omw_a_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sia ntapiraitita varuvaro Iesusiva qaiqaa tiva niro tiqaro, Ne quqaama tuqo. Ne sipisipi mwisa qetivanoma varuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ni vuni nria vaitisa mwisa muara utuasave, mwosa riqata mwisani muara vare variasa variavata sipisipivano sia mwisa nrunta riaarave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Vutaqi vua qetiva nema mwi qetiva varuqo. Niqaamatero nritaraani vaitira ni qova mwira vitaanarove. Niqaamatero tuvitare nritare hiariva soma sara huaama sero nraanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Muara varai vaitiva muara vareqaro sipisipi ru taiqa sareraro nrirave. Ne sipisipiara rieqanama sipisipi mwisa qaqi variqita viqatama suqema seta variate tina, ne nruvave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ne sipisipi qova suqevave. Sipisipi qova suqeva variqaro nai sipisipi rusevorave tiqaro antuaqiro viro sai ne mwisara rieqana qutu vuase tiva sero qutirave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mwovano sia sipisipi qova, mwiva qaqi saiqa vaitivano variqaro taqaisaro qaasau vairivano nrisaro mwiva aatu hiqaro qaqira sero santero visaro qaasau vairivano sipisipi rusero hini ru vata saisata mwisa niariara nariara mwona mwona vuarave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mwira saiqa vaitivano qaqi saiqa vaitivano variqarora tiro, mwiva sia sipisipiara nroraqama sero riaraitiro, aatu virave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ne sipisipi qova suqeva variqana ne nena sipisipi ntapihi sauqata ni sipisipinravuvano nivata ntapihi seta taqaarave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Mwira votima sero ni qova ni ntapihi saisana nevata mwira ntapihi saurave. So ni sipisipi rusevorave tina, ne mwisara rieqana qutu virerave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sipisipi mwonravu mwisa sia mwaa vutaraqi variasa mwisavata ni sipisipive. Mwisa ni nrunta riaivaqe ne mwisa vitaqina uro saarita ni sipisipi hini mwisavata kuaaqi varivarave. Mwisa kuaaqi varivaqe ne mwisa qova kuaiqavanoqaima varianirave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ne mwisara rieqana qutu vina qaiqaa qaqi tivuanirave. Ne mwitaa hianirara tiro, ni qora mwutusavano niara vaiso. ");
INSERT INTO omw_a_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ne sia sove tiariro mwovano siama so ni rusaanarove. Ne nena qutu vuataa hiraqena qutu vuanirave. Ne qutu vuani osararave, ne qaiqaa qaqi tivuani osararave, nina saiqaqaima vaiso. Ni qova niara mwitaa mwitaa hiane ti quara, ne mwi quara vararerave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mwitaa tuvata Iutaa vaiti nroranravuvano mwi quara rieta vutaqaa ntaira vita hininravu mwo qua tuvata hininravuvano mwo qua tura. ");
INSERT INTO omw_a_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Airivano tiqata, Ueravano mwiraqi varisaro mwitaa tiso, Mwiva ueraqama viso. Naraqamave né mwira qua riaavo? Sia mwira qua riaate, tuvata ");
INSERT INTO omw_a_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","mwonravuvano tiqata, Qaqao, ueraqa hiari vaitiva siama so mwi quara tianarove. Ueravano siama so vu qipa vuani vaitira ntapairi saanarove, tita. Mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ierusaremini omwata mwo nro entava nri ntora. Kotira nraavu qamwata mwato omwatava vahuvaro huarivano sia nroraqama sero ite varu entaraqaa mwi omwatara nrora. ");
INSERT INTO omw_a_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mwi entaraqaa Iesusiva Kotira nraavu nroraqi variqaro mwo rumuqi mwira nrutu Soromonira rumuqi nrue varuvata ");
INSERT INTO omw_a_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iutaa vaiti nroranravuvano mwiqi uairama vita Iesusirara tiqatama, E mwo qua vaasa tiri tiva timwiataarave. Taireve tiri tiva timwinarave? E mesaiaa vaitivano varirera, vutu sera tiva timwiraqe te riaare, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tuvaro Iesusiva tiqaro, Ne vaasa ini tiva nuqata né sia ni quara quqaa quave tiavo. Ni qova ni nroraqama saisana ne mwira saiqa vare varurave. So ne varau saiqava ni osarara ntapihima ti variso. Né ni saiqa taqaarara rieqata ni osarara ntapihiataarave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Né sia ni sipisipi variqatara tita, né sia ni quara quqaave tivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ne nena sipisipi ntapihi saurave. Mwisa ni nrunta rieqatama ni vataqita nrue varivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ne esaa enta qaqi variqi vira niarita mwisa sia qutu vivarave. Siama mwovano ni sauquqitairo ni sipisipi ntavihi sero varaanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ni qova ni sipisipi mitaiva, mwiva kepusavano esaa inraisa nraataraiva variqaro ni sipisipiqaa ntaqaihi varisarora tiro, sia mwovano mwira sauquqitairo so ntavihise varaanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nevata ni qovavata kuaikuvanoma varuro, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iesusiva mwitaa tuvata Iutaa vaiti nroranravuvano mwira ru saare tita, ori tu varovaro ");
INSERT INTO omw_a_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iesusiva tiqaro, Ne ni qora suqe saiqa, mwo saiqa mwo saiqa ini tiva nuqata nara saiqa varaura saarave né niqaa ori tuto sarerata uti variavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tuvata Iutaa vaiti nroranravuvano tiqata, Te sia i saiqa suqera saara i ru sarerave. E Kotirara qora qua tiaro. E qaqi vaitivano variqarama Kotisantiriro kuaaqaa varirera uti variaro. Mwira saarama te ori vara seta i ru sarerave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mwisa mwitaa tuvaro Iesusiva tiqaro, Né Kotira vuku vataaraqi qua mwo qara ntuva tova vaiso. Né siave mwi quara taqaavo? Kotiva vaiti mwo usara mwitaama tiro: Né mwariqavanove, turave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Te ntapihi sauraro Kotira qua sia unra qua vahirave. Kotiva nai qua tu vaitisa qaqi qumina vaitiara mwariqavanove turave. ");
INSERT INTO omw_a_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","So Kotiva ni mwatama sero ni titaisana ne mwatani uto variqanama iniara ne mwariqa Kotira mwaaquve tuqata né tiqata, Kotirara qora qua tiaro, tiavo. ");
INSERT INTO omw_a_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ne sia nena qora saiqa varaaritavauma né sia niara quqaa mwivave tivarave. Ne nena qora saiqama vare varuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Né sia niara nroraqama seta riaivera, né ne saiqa vare varianirara nroraqama seta rieqatama niara quqaa mwivave tiate. Né mwitaa tivaro ini vu nraato ntapihirata né ni qova niqi varirara ntapihivarave. Ne mwiraqi varianirara né ntapihivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mwitaa tuvata mwisa qaiqaa mwira karavu hirera uti varuvaro Iesusiva veva ntero viro. ");
INSERT INTO omw_a_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Veva ntero vuva uro Sotaani nramari hini tosani Ioniva tauraa variqaro nramari nunani uro varura. ");
INSERT INTO omw_a_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Varuvata airi nraase qoravano mwiva varunani nri nteta tiqata, Ioniva sia nrora saiqa varova variqaro Iesusirara tiri tiva timwurave. So te taqauraro Ioniva quqaa qua mwaa vaitirara tiva timwurave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mwitaa tiva seta mwini varusa airivano Iesusirara quqaa mwivave tura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Vaiti mwovano mwira nrutu Rasarusiva Vetaaniniaava nroraqama sero nriqa vuvaro varuvata mwira nruratana Mariaavavata Mataavavata mwini varura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariaava vahavera suqera Iesusiraqaa qu mwatero nai qiata saahiqotairo mwira suqu nruka mwataariva varura. Mwi nrure nrasetana variqata taqovaro mwisa vasaava nriqa vuvaro varuvata ");
INSERT INTO omw_a_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","mwitanasa vaiti mwo titeta Iesusirara uro mwitaama tiane tita, Nrorao, i mwutusa nti vaitiva nroraqama sero nriqa visaro variso tiane, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mwitanasa mwitaa tiva seta titovaro vevani uto tiva mwuvaro Iesusiva mwi quara riero tiqaro, Rasarusiva nroraqama sero nriqa visaro variso. So mwiva siama qutu vuanarove. Né Kotira kepusa taqaate tiro, mwira nriqa visaro variso. Ni Kotira mwaaqu ni kepusa osara taqaate tiro, mwira nriqa viso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesusiva Mataararavata mwira nruraravata Rasarusiraravata mwoqama sero mwutusa ntuva variqaro ");
INSERT INTO omw_a_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","mwi quara rierovata sia qamwanrama viraitiro, qaqira sero taara entavata mwini varura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Vari sero mwiraqaatairo nai nraaqiaranravuara tiqaro, So varaivaqenravu uto ntante Iutiaani vuare, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tuvata mwira nraaqiaranravuvano qaqao tita, Mwaara ti variarao, nanauma Iutaa vaiti nroranravuvano ori vara seta i ru sarerata uturave. E qaiqaa mwini uto ntantera virerarave hiaro? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tuvaro Iesusiva tiqaro, Mwo enta mwo enta huarivano ihara so itairave. Vaitivano qataahiraqaa nrue variva huarivano itairaqaa nrueqaro aara so taqeqaro sia huntavaivaimaqiro saavu ntirave. ");
INSERT INTO omw_a_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Huarivano sia itaisaro entaqi nrue variva huntavaivaimaqiro saavu nti varirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mwitaa tiva sero Iesusiva qaiqaa tiqaro, Tiri toti Rasarusiva vaitama viso. Ne uro mwira huruma sarerave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mwitaa tuvata mwira nraaqiaranravu tiqata, Nrorao, mwiva qaqi vaite varirera, mwiva soqa hianarove, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Mwitaa tiva seta mwisa sia ntapihuvaro Iesusiva mwi quaraqaa ntuva sero Rasarusiva qutu vurara tura. Mwisa tiqata, Iesusiva Rasarusirara qaqi vaitairarama tiso, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mwitaama rieqata varuvaro Iesusiva vutu sero tiva niro tiqaro, Rasarusiva qutuma viso. ");
INSERT INTO omw_a_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","So ne iniara rieqanama né niara quqaa mwivave tiate tina, ne Rasarusira sia qamwanrama uro taqaurara qamwateqama varuqo. So varaivaqenravu mwiva qutu vinani vuare, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tuvaro mwira nraaqiara mwovano Tomaasiva, mwira mwo nrutu Kaapiva, mwiva nai hena vaitinravuara tiqaro, So varaivaqenravu mwaara ti vari vaitiravata vuare. Iutaa nroranravuvano mwira ru saivaqe tirenravuvata mwira vatama seta qutu vuare, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tuvaro Iesusiva vuva nrintero riovata Rasarusira quntama tovaro erahiamuaantema enta nritarora. ");
INSERT INTO omw_a_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Vetaani Ierusaremi qaumato 3 kiromitaa votima mwiraqaatairo vahuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ierusaremitaita mwi mwatanaasa airivano Mariaaravata Mataaravata mwutusa qihaasama nateqata Rasarusirara ntatarerata nrura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nri varuvaro Mataava riovaro Iesusivavata mwitairo aarana nri varuvaro mwiva Iesusira hunta sareraro viqaro Mariaara nraavuqi sero vuva nrintero ");
INSERT INTO omw_a_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Iesusirara tiqaro, Nrorao, e mwaini variaratiri, ni vasaava siama qutu vitirio. ");
INSERT INTO omw_a_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","So mate e Kotirara mwo inraisa mwo inraisara naaru tiraro Kotiva mwi inraisara soma i mwianarove. Ne mwira ntapihi sauqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tuvaro Iesusiva mwira tiva mwiro tiqaro, I vasaava qaqima tivuanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tuvaro Mataava tiqaro, So esaara entaqaa mwiva esaa nraase qora sapata tivuanarove. Ne mwira ntapihi sauqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tuvaro Iesusiva tiqaro, Nraase qora qutu vuasa qaqi vara tivumase varuva, ne mwaa mwivave. Nraase qora qaqi variqi vi varia inraisara ni varuva ne mwaa mwivave. Niara quqaa mwivave tiariva qutu viro mwiqitairo qaqi variqiro vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Qaqi variqiro viqaro niara quqaa mwivave tiariva siama qutu vuanarove. E mwirara quqaaveve tira hiaro? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tuvaro Mataava tiqaro, Quqaama tira hiaro. Mesaiaa Kotira maaquvano mwatani tuvirera hiarava, e quqaa mwivama hiaro, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mwitaa tiva sero Mataava nrima ntantero uro nai nrura tirema sero tiva mwiro tiqaro, Mwaara ti vari vaitiva nri ntaiso. Mwiva iara sapara iso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tuvaro Mariaava mwi quara riero tiviro santero uro Iesusira hunta sareraro viro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesusiva vaasa Mataava uro qua mwantonani variqaro sia mwatusani nri ntovaro ");
INSERT INTO omw_a_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mariaava mwira huntareraro vuvata Iutaa nraase qora mwira mwutusa qihaasama mwatarerata nrusa taqovaro Mariaava nraavuqitairo santero vuvata mwisa tiqata, So mwira quntama taanani ntatareraro virerarove, tiva seta mwisavata tivita Mariaara vata vareta vura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mwisa Mariaara vata vareta vuvaro Mariaava vuva Iesusiva hunani nrintero Iesusira taqero uro mwira vuqaa uto ntiro variro tiqaro, Nrorao, e variaratiri, siama ni vasaava qutu vitirio, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tuvaro Iesusiva taqovaro mwiva ntate varuvata Iutaa nraase qora Mariaaravata nrusa mwisavata ntate varuvaro Iesusira mwutusavano qoraqama sero nraamwunriqa tovaro mwiva po se tiro tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mwira taraqive quntama teta hiavo? tuvata mwisa tiqata, E nrira uro taqaane, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesusiva ntate varura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ntate varuvata Iutaa nraase qoravano tiqata, So taqaate. Mwiva mwoqama sero Rasarusirara mwutusa ntisaro variso, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tuvata mwonravuvano tiqata, Mwiva vu qipa vi vaitiravata so ntapairise varivave. Iesusiva mwaini varitirio, Rasarusiva qutuve vitirio, siave qutu vitirio? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tuvaro Iesusira qaiqaa ua huvaro mwiva mwira quntama tonani vura. Mwisa ori vaurutoraqi Rasarusira veta vateta ori mwo vara seta qetiana tita torara tiro, Iesusiva tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ori mwira qaqinani vara saate, tuvaro Mataava qutu vu vaitira nruravano qaqao tiro, Mwira quntama taavaro erahiamuaantema enta nritaraisaro ntera viva mwutama vuanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Tuvaro Iesusiva Mataarara tiqaro, Ne vaasa i tiva mwu quarara riaane. E niara quqaa mwivave tirera, e Kotira kepusa taqenarave turave. Siave ne vaasa iara mwitaa tina huqo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tuvata mwisa ori qaqinani raaqu sovaro Iesusiva virini taqero tiqaro, Kaao, e ne tu quara rie varianara ne mwirara suqeve tuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","E esaa enta ni qua rie varianara ne ntapihi saurave. E ni titaanarara nraase qoravano ntapihiate tina, ne mwisara rieqanama iara aasara ntauqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesusiva mwitaa tiva sero mwiva aasara ntero tiqaro, Rasarusio, tivira veva ntaane, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Rasarusiva qutu vuva qaqi tiviro mwira suqu sauqu ququtama teta mwira qiatavata mpuruqaqo qapuqamatova mwiqitairo veva ntero. Veva ntovaro Iesusiva mwisa tiva niro tiqaro, Mwira avantu saivaro qaqi vuarive, tura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tuvata Iutaa nraase qora airivano Mariaara taqarerata nrusa mwi saiqara taqeta Iesusiva so quqaa mwivave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tuvata mwonravuvano qaqira seta Iesusiva mwi saiqara varorara uro Parisi vaitinravu tiva nuvata ");
INSERT INTO omw_a_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Parisi vaitinravuvata, Kotira saiqa vara mwate varu vaitisa mwisa nrora vaitinravuvata, mwisa niari kaanasori vaiti sapata uairama vita tiqata, Mwi vaitiva mwo saiqa mwo saiqa nrora saiqa vare variso. Qike, te mwira nataamave saanarave? ");
INSERT INTO omw_a_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Te mwira qaqi saarera, mwiva mwitaamaqiro virata esaa nraase qora mwirara quqaa mwivave tivarave. Mwisa mwitaa tivata tiriqaa ntaqaihi variasa Romenivano tiri ntaqiqata Kotira nraavu ntapairi seta tiri nraase qora esaa ru taiqa sevarave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tuvaro mwi vaitinravusaqitairo mwovano mwira nrutu Kaiapaasiva tiviro. Kaiapaasira mwira nroraqama sovaro mwi ihiraqi Kotira saiqa vara mwate varu vaitisaqaa ntaqaihiqaro vuniaa vaitivano varuva, mwiva tiviro tiqaro, Sia né vu nraatovata vahisave. ");
INSERT INTO omw_a_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Romeni mwatanaasa tiri esaa ru taiqa sevorave. Tiri saahaqa hireraro vaiti kuaiqavanoqaima qutu viraro suqe hianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapaasiva mwi quara tiqaro ne nena nraato tusena tuqo, tiro. Mwiva sia ntapihi sovaro Kotiva mwira saahaqa huvaro mwiva Iesusiva Iutaa nraase qorara rieqaro qutu vuanirara tura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Iesusiva sia Iutaa mwatanaasaraqai rieqaro qutu vuariva varura. Kotira nraaqiara esaa mwoqi mwoqi apiqama variasa mwisavata vita sero uro kuaaqi uairama tareraro Iesusiva qutu vuariva varura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","(Kaiapaasiva tiqaro, Vaiti kuaiqavano tiri Iutaa saahaqa hireraro qutu viraro suqe hiarive, tuvata) mwi entaraqaataita Iutaa nrora vaitinravuvano Iesusira ruserara tivaqita vura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mwitaa ti varuvarora tiro, Iesusiva Iutaa mwatani sia qoqaa nruaraitiro, qaqira sero uro Eparaimi mwatusa qumina mwata tosani uro nai nraaqiaranravu sapata varura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mwini varuvaro Iutaavano vesahu nato sarara omwata nro entava qaumaqa huvata itai itaita nraase qora verara nrora mwatusa Ierusareminiqai vura. Mwini uro variqata nrora enta mwira vesa variqata mwisa niari mwaara qua rieqata nramari ntuva seta tuavaaqa hiqama seta varura. ");
INSERT INTO omw_a_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mwisa mwini variqata Iesusirara aitutumaqita nrueqata uro Kotira nraavu nrora nraavuqi uairama vita nai sapara hi nai sapara hita tiqata, Iesusiva sove nrima omwata nraanarove? Mwiva aatu hiqaro siave nrianarove? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mwitaa ti varuvata Parisi vaitinravuvanovata, Kotira saiqa vara mwate varu vaitisa mwisa nroranravuvanovata, mwisa nraase qora tiva nita tiqata, Né taqaivaro Iesusiva nrirera né nrima tiri tiva timwivaqe te mwira rupaqi karavuqi saare, tura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Vesahu nato sarara omwata nro entava qaumaqa huvaro 6 entanravu qaqi vahuvaro Iesusiva qaiqaa Vetaani mwini Rasarusiva varunani vura. Rasarusira mwira haaru qutu vura Iesusiva qaiqaa qaqi tivuma so vaitiva varura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mwini vuvata mwi mwatanaasa Iesusirani sara uta mwatovaro Mataava mwi sarara varaqiqaro uro nuvaro Rasarusiva Iesusisantiriro sara tainta mwira tataaqa mwatasaa viro varura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Varuvaro Mariaava taqu mwo varero nrura. Mwi taquraqi nrora munima so vahaverara mwira nrutu naanti vahuvaro Mariaava mwi taqura varero mwi vahaverara Iesusira suquqaa qu mwatero mwiraqaatairo nai qiata saahiqotairo Iesusira suqu nruka mwatovaro vahavera suqe hu mwuntava nraavu mwira kuraama sora. ");
INSERT INTO omw_a_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kuraama sovaro Iesusira nraaqiaranravuqitairo mwovano Iutaasi Isikeriotiva Iesusira qovarama saariva, mwiva qaqao tiro, ");
INSERT INTO omw_a_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Mwi vahaverara mwosa niro munima 300 kinaa vara sero mwi munimara vehi nraase qora niataara vaisaroma, qumina i suquqaa qu mwatero iso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Iutaasiva sia vehi nraase qorara riaraitiro, mwiva muara vaitivano variqarora tiro, mwitaa tura. Mwiva Iesusira nraaqiaranravu munima tuaqaa ntaqaihiqaro mwi tuaraqitairo quqeta seqaro mwinravusa munima muara vare varura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iutaasiva tiqaro, Munima mwira vehi nraase qora niataara vaisaroma qumina i suquqaa qu mwataiso, tuvaro Iesusiva tiqaro, Sia mwi nraasera antua taane. Mwiva vahavera niqaa qu mateqaro ni quntama te entarara ni mwavanta tequama mate variso. ");
INSERT INTO omw_a_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Vehi nraase qora mwisa esaa entama inivata variqita vivarave. Né qaqi entaqaa mwisa so saahaqa hivarave. Ne siama inivata esaa enta variqina vuanirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Iesusiva mwitaa tiva sero varuvata Iutaa airivano riovaro Iesusiva Vetaani mwini varuvata mwisa Iesusiravata Iesusiva qaqi tivuma so vaitira Rasarusiravata taqarerata uto Vetaanini uaira hita varura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Iutaa airivano Rasarusira qaqi tivuma sorara rieqatama niari nrora vaitinravu qaqira seta uto Iesusirara quqaa mwivave ti varuvata mwira saara Kotira saiqa vara mwate varu vaitisa mwisa nroranravuvano Rasarusiravata ruse quara ti varura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mwira qararaara nraase qora airivano vesahu nato sarara nrarerata nrusa riovaro Iesusiva Ierusareminiara aarana nri varura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nri varuvata mwisa mwira qamwata mwatarerata qantosa mware voti hura teqa vareta Iesusira hunta sarerata viqatama mwisa aasara nteta tiqata, Sai mwira nrutu tuaaheraare. Nroravano nai nrutuqa nri vari vaitira suqema mwataiso. (Sng 118:26) Tiri Isareriqaa ntaqaihi vaitira Kotiva suqema mwataiso, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mwisa mwitaa tivaqita vuvaro Iesusiva qaraaha ntonki huaama sero Kotira vukuqi tuntema sero mwira mwoqaqaa mwatasaa viro variro Ierusaremiqiara viro. Haaru Kotira vukuqi mwirara mwitaama tiro: ");
INSERT INTO omw_a_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Saioniqinaasa (Ierusaremiqinaasa) né sia aatu hiate. Taqaate, iniqaa ntaqaihiariva nriqaroma mwiva qaraaha ntonki mwoqaqaa nri variso, tura. (Sek 9:9) ");
INSERT INTO omw_a_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mwi quava vukuqi vahuvata mwi entara Iesusira nraaqiaranravuvano sia mwi quara osara ntapihura. Naatiara Iesusiva qutu viro qaiqaa tivu entaraqaa mwi quava mwisa nraatoqi ntuva vuvata mwisa tiqata, Mwi quava Iesusiva ntonki mwoqaqaa Ierusaremini vurara turave, tura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iesusiva Rasarusira oriqi quntama toraqitairo nraarama sero mwira qaqi vara tivuma sovata nraase qora mwini Iesusiravata varusa mwi saiqara taqeta mwosa mwosa tiva nuvata ");
INSERT INTO omw_a_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","mwiraqaataita nraase qora airivano Iesusiva nrora saiqa mwira varorara rieqata Iesusira uto hunta sora. ");
INSERT INTO omw_a_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mwisa Iesusira qamwata mwatarerata vuvata Parisi vaitinravu nai tiva mwi nai tiva mwi hita tiqata, So taqaate. Te siama so mwo qara hiara aarava vaiso. Esaasa mwiraqaima vataqita vi variavo, tura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kiriki mwonravuvano (Mwisa Iutaa mwaara qua riosa) mwisavata mwi omwatara nreqatama Kotira nrutu tuaaherarerata Ierusaremini uro varura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Uro variqata mwisa Iesusira nraaqiara mwo Piripira Vetasaitaa mwatusa Kaririniaarara tiqata, Tiri vaitio, te Iesusira taqarerave, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Piripiva uro Entururavata tiva mwiro mwiva vatama sero uro Iesusira tiva mwura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tiva mwuvaro Iesusiva tiqaro, Ne mwatani mwatatai nraaqiaravave. Ni nrutu nroraqama vuari entava nri ntaiso. ");
INSERT INTO omw_a_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ne qua tianira riaate. Uiti uru sia mwataqi vara tutairaro uiti uru mwiqava nariaraa vahianarove. Uiti uru mwataqi vara tutairaro ntuko hiro turu vera sairaro mwiraqaatairo uru mwiva taiqa vuanarove. Uru mwiva taiqa viraro uiti mwiva qupiqeqaro airi tava riaanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","So vaiti mwovano mwaa mwataraqaa nai qaqi variqiro vuaniraraqai nroraqama sero riemwaqiro vuariva, mwiva esaarama qutu vuanarove. Vaiti mwovano sia nai mwaa mwataraqaa qaqi variqiro vuanirara nroraqama sero riemwaqiro vuariva, mwi vaitiva esaa enta qaqima variqiro vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tasave ni saiqa varaataa hiarisa, mwisa qaqi varivorave. Mwi vaitisa ni vataqita nriate. Mwisa mwitaa hiqata ne varianirani mwisavata varivarave. Mwisa mwitaama seta ni saiqa vara mate varivaro ni qova mwisa nrutu nroraqama saanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","So mwaa entara ni mutusa uaqa isana varuqo. Nena qorara nara quave tianirave? Kaao, mwi entava nri ntaasora mwi entara qaqira saane. Mwitaave Kotirara tianirave? Qaqao, ne sia mwitaa tirerave. Ne mwi entarara rieqana tuvuvave. Mwi entaraqaa ne atura ntuvaqina vuase tiva sena tuvuvave. ");
INSERT INTO omw_a_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kaao, e ena nrutu nroraqama saane, tiro. Iesusiva mwitaa tuvaro naavutairo quavano tiqaro, Ne nena nrutu nroraqama sauqo. Qaiqaavata nroraqama sarerave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tuvata nraase qora uairama vita mwini tivita varusa mwi quara rieta tiqata, Naaruva nruqua tiso, tuvata hini husa tiqata, Qaqao, naavuniaa vaitivano mwiravata qua tiso, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tuvaro Iesusiva tiqaro, Sia mwiva niara rieqarovauma qua tiso. Mwiva iniara rieqaroma qua tiso. ");
INSERT INTO omw_a_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","So mwaa entara mwatani variasa ko tiani entarave. Mwaa entara mwatani variasaqaa ntaqaihi varira Saataanira kepusa ntuvuraa saani entarave. ");
INSERT INTO omw_a_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mwatataita ni tuaahera saivaqe ne variqana esaa nraase qora ntarau saarita mwisa ne hianiraniqai nrivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesusiva mwi quara tiqaro nai qutu vuanirara tiva nura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mwitaa tuvata mwini uairama vusa qaqao tita, Kotira vukuqi qara ntuva tova tiqaro, Mesaiaa vaiti Kotira kepusavano esaa enta qaqi variqiro vuanarove, turave. Naraqamave e tiqara, Ni mwatani mwatatai nraaqiarara tuaahera sevarave, tiaro? (E ena qutu vinarara tiana quara sia ntapihuro.) E tiqara, Ni mwatani mwatatai nraaqiaravave, tianarave. E ta vaitivave hiaro? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tuvaro Iesusiva tiqaro, Pataqa ovavano ini sapata variqaro itamaqiro vuanarove. Enta hiraqi nruesa sia nai vi aarara ntapihirara tita, né enta hiaso tita ovavano qaqi ite variani entaraqaa nrueqata variate. ");
INSERT INTO omw_a_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ovavano qaqi vahiani entaraqaa né mwi ovarara quqaa mwivave tiva seta, mwirara riemwaqi viqatama nruaate. Mwitaa tiqatama né ova nraaqiara variqatama névata ovavano itaintema seta itamwaqita vivarave, tiro. Iesusiva mwi quara tiva sero mwiraqaatairo uro sia mwisa vuqaa variraitiro, uqeta varura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesusiva mwisa vuqaa variqaro nrora saiqa varovata mwisa taqetavata mwisa qaqira seta sia mwirara quqaa mwivave tuvarora tiro, ");
INSERT INTO omw_a_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","mwi entara Asaiaava haaru tu quava quqaa vahura. Haaru Kotiva vaiti mwo Asaiaara saahaqa huvaro Asaiaava poropeti vaitivano variqaro qumina vasa mwaa quara vutu sero tiqaro, Nrorao, tavave tiri quara quqaave tiso? Sia mwovanovata quqaave tirave. Nroravano nrora saiqa vara saisaro tavave mwira saiqa ntapihi taqaiso? Sia mwovanovata ntapihi sero taqaiso, tura. (Ais 53:1) ");
INSERT INTO omw_a_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Asaiaava mwitaa turara tita, mwisa sia Iesusirara quqaa mwivave tura. Asaiaava qaiqaa mesaiaa vaitiara tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Mwi vaitisa uaqa hi aarara qaqira seta niara tiri saahaqa hiane tivorave tiva sero, Kotiva mwisa vu nraato tita saisata mwisa sia vuqotaita so taqeta, mwisa sia nraatoqotaita so riaavo, tura. (Ais 6:10) ");
INSERT INTO omw_a_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Asaiaava haaru variqaro Iesusira kepusa osara taqeqarora tiro, mwiva mwirara qua tiva nura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mwi entara Iutaa nrora vaitinramwuqitaita mwonravuvano tiqata, Quqaama Iesusiva mwivave, tita. Mwisa mwitaa tiqata mwisa Parisi vaiti nraatu aatu hita qaqira seta sia qoqaa variqata mwi quara tita. Mwaara nraavuqitaita veva nteta vuate tivorave tita, sia mwisa qoqaa variqata mwi quara tura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Qaqi vaitivano qamwata nateraraqai mwisa nroraqama seta rieqatama sia Kotiva qamwata nataanirara nroraqama seta riora. Mwisa mwiraraqai riosara tita, mwisa sia qoqaa Iesusirara quqaa mwivave tura. ");
INSERT INTO omw_a_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iesusiva paatiro tiva niro tiqaro, Niara quqaa mwivave tiariva siama niaraqai quqaave tianarove. Mwiva ni titairaravatama quqaave tianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Vaitivano ni taqeqaro ni titairavatama taqaanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Niara quqaa mwivave tiariva rupi hiraqi nruaaso tina, ne ova votima sena itamwaqina virera mwatani tuvuvave. ");
INSERT INTO omw_a_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ne sia mwatani varisaqaa qua vatarerana tuvuvave. Mwatani variasa suqema variate tina, ne tuvuvave. Ni qua riero nteqa saariva variraqe sia nevauma mwiraqaa qua vataanirave. ");
INSERT INTO omw_a_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ni qoririma mataani vaitiraqaave, ni qua nteqa saani vaitiraqaave, siama ne qua vataanirave. Ne tiva taani quava, mwivama esaara entaqaa variqaro mwiraqaa qua vataanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ne sia nena nraato tusenavauma qua ini tiva nuqo. Ni qova mwitaa mwitaa tiane tiva sero ni titaisana ne mwira qua ini tiva nuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ne ntapihi sauqaro ni qora qua riaariva esaa enta qaqi variqiro vuanarove. So ni qova mwitaa mwitaa tiane ti quara, ne mwi quara ini tiva nuqo, tiro. Iesusiva mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Vesahu nato sarara omwata nro entava kuaa entaqai qaqi vahuvaro Iesusiva variqaro ntapihi sovaro nai mwata mwaini sero uto ntantero nai qova varinani vuari entava qaumato vahura. Mwitaa huvaro Iesusiva variqaro nai husa mwatani varusara mwoqama sero mwutusa vahuvaro mwisara rieqaro varura. Mwiva mwisara mwutusa vahuva qaqiqai vahiqiro vuvaro uro qutu vura. ");
INSERT INTO omw_a_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Entama vuvaro Iesusiva nai nraaqiaranravu sapata sara nre varuvaro mwira nraaqiara mwovano Iutaasi Isikeriotiva Saimonira mwaaquvano varuvaro Saataaniva Iesusira qovarama saane tiro, Iutaasira mwira nraatoqi qora qua vatovaro Iutaasiva Saataanira qua riora. ");
INSERT INTO omw_a_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Riero varuvaro Kotiva esaa inraisa Iesusira sauquqi vatora Iesusira vu nraatoqi vahuvaro mwirara ntapihi sero. Iesusiva Kotiva hunatairo tuvuva qaiqaa Kotiva hunani vuanira mwiaravata mwiva ntapihi sora. ");
INSERT INTO omw_a_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mwiraqaatairo mwiva sara nro taintaraqaatairo tiviro verato ututo tuavaaqara ntatu sero vatero tauri tavaarana rupatero uro ");
INSERT INTO omw_a_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","tanaaqi nramari rauru sero varero uro nai nraaqiaranravu suqu hiqama natero tauri tavaarana rupatoraqotairo aahara tu natero. ");
INSERT INTO omw_a_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mwitaamaqiro viro Saimoni Pitaava hunani nri ntovaro Pitaava qaqao tiro, Nrorao, e ni suquvatave hiqama matarera uti variaro? tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesusiva tiqaro, Mate ne mwaa saiqara varaura e sia ntapihiaro. Naatiara mwirara so ntapihinarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tuvaro Pitaava tiqaro, Qaqao, e nrora vaitivano variqara hauri mwitaa hi saiqara ni vara materorave. E siama ni suqu so hiqenarave, tiro. Tuvaro Iesusiva tiqaro, Sia ne i suqu hiqama mwataasera, e siama ni nraaqiara varinarave, tiro ");
INSERT INTO omw_a_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mwitaa tuvaro Saimoni Pitaava tiqaro, Nrorao, mwitaa hirara e sia ni suquqai hiqama mataane. Ni sauquvata ni qiatavata hiqama mataane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tuvaro Iesusiva tiqaro, Nramari ntuva taariva siama qumina qaiqaa ntuanarove. Mwiva nai suquqaima hiqaanarove, tiro. Né esaa nramari ntuvase suqema variavaro kuaikuvanoqai sia suqema variso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesusiva nai nraaqiara mwovano mwira qovarama saanira ntapihi serora tiro, mwiva tiqaro, Né esaa suqema variavaro kuaikuvanoqai sia suqema variso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Mwitaa tiva sero mwisa suqu hiqama natero Iesusiva qaiqaa uro nai tuavaaqa ntatuse vatora vara utu varero uro nai varura qoqaraaraqaa mwatasaa viro variro tiva niro tiqaro, Ne mwataa hi saiqara ini vara nataura né so mwirara ntapihitave hiavo? ");
INSERT INTO omw_a_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Né niara nrora vaiti mwaara ti variaravave tiarave. Ne mwitaama varurara tita, né soma niara mwitaa tivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","So ne ini nrora vaiti mwaara ti varuva variqanama ne ini mwataa saiqa vara nateqanama ini suqu hiqama natauqo. Névata variqata ne huntema seta nai suqu nai suqu hiqama nateqata variate. ");
INSERT INTO omw_a_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Né ne hunte hiate tina, ne ini mwi saiqara tiva nuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ne quqaa tianira né riaate. Saiqa vaitivano sia nai nrora vaiti nraatara sairave. Mwo inraisara titaisaro vi vaitiva sia nai titaira mwira nraatara sairave. ");
INSERT INTO omw_a_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Né mwi quara osara ntapihi seta rieta mwi saiqara mwitaamase varaqi vivera, né qamwateqatama variqi vivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","So sia ne ini esaasara tuqo. Ne nena mwatama tau nraaqiarasa so ntapihi taqaurave. Ne mwisa osara ntapihi saurave. Haaru Kotira vukuqi qua mwo qara ntuva tova mate quqaa mwivauma vahianarove. Mwi quava mwitaama tiro: Vaiti mwovano nivatama sero variqaro ni sara nrero mwiraqaatairo tuqataa viro ni qoraqama mataanarove, turave. (Sng 41:9) ");
INSERT INTO omw_a_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Iniqitairo vaiti mwovano ni qoraqama mataanirara ne mate ini tiva ni varuqo. Mwiva naatiara ni qoraqama matairata né variqata mate ne tiva nunrara rieqatama so niara mwiva quqaama qaqiqai variqi vivave tivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ne quqaa tianira né riaate. Vaiti mwovano ne titaani vaitira qamwata mwateqaro mwiva nivata qamwata mataanarove. Mwiva ni qamwata mateqaro Kotiva ni titairavata qamwata mwataanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesusiva mwitaa tiva sero varuvaro mwira mwutusavano uaqa huvaro mwiva vutu sero mwisa tiva niro tiqaro, Ne quqaa tianira riaate. Iniqitairo mwovano ni rusaate tiro, uro tiva nianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mwitaa tuvata mwira nraaqiaranravuvano nai taqe nai taqe hita airi nraato tita tiqata, Iesusiva ta vaitirarave tiso? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mwitaa ti varuvaro mwovano Iesusira mwutusavano mwirara mwoqavata vahu vaitiva Iesusira tataaqani varuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimoni Pitaava mwirara nru nraata sero tiqaro, E Iesusira ta vaitiva mwitaa hianira sapara hiqara taqaane, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","mwi vaitiva Iesusiraqaa urovi vuntuvi variro Iesusira sapara hiro tiqaro, Nrorao, mwiva ta vaitivave iso? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tuvaro Iesusiva mwira tiva mwiro tiqaro, Ne mpereti viti nramari tanaaqi vahiraqi mwaati ntava sena vaiti mwo mwiariva so mwira mwi vaitivave, tiro. Tiva sero mpereti viti vara sero nramariqi ntava sero Iutaasira viti mwura. ");
INSERT INTO omw_a_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mpereti viti mwira mwuvaro Iutaasiva mwira varovaro Saataaniva Iutaasira vutaqi viqetero varuvaro Iesusiva Iutaasirara tiqaro, So santera ena vararera tina saiqara varaane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mwitaa tuvata mwira nraaqiara sara taintaqaa varusaqitairo sia mwovano mwi quara osara ntapihura. ");
INSERT INTO omw_a_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mwisa tiqata, Iutaasiva munimaqaa ntaqaihi vari vaitiva varisaro Iesusiva hura omwata nraana sarara varaaneve tiso, mwiva vehi vaiti munima uro nianeve tiso? tita. ");
INSERT INTO omw_a_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mwisa mwitaa ti varuvaro Iutaasiva Iesusiva mpereti viti mwura varero mwiraqaatairo veva ntero viro. Entaqi mwiva vurama. ");
INSERT INTO omw_a_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iutaasiva veva ntero vuvaro Iesusiva tiqaro, Ne mwatani mwatatai nraaqiaravave. Mate ni kepusa osaravano qovarama viso. Ne Kotira kepusa osara mate qovarama sauqo. ");
INSERT INTO omw_a_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ne Kotira kepusa osara qovarama saasera, Kotiva mwiva ni kepusa osaravata qovarama saanarove. Mwiva qamwanrama mwitaa hianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Qike, ni nraaqiaranravu tuaavo, ne inivata pataqa varisena vuarita né naatiara qumina niara huaa hivarave. Ne Iutaa vaiti nroranravu tiva nuntema sena inivata tiva nuqo. Ne virera hianirani né sia so vivarave, tuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ne mate qaraaha qua mwaara ini tiva niarita né riaate. Né mwoqama seta nariara nariara mwutusa vahirata variate. Ni mwutusavano iniara vahintema seta névata nariara nariara mwutusa vahirata variate. ");
INSERT INTO omw_a_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Né nariara nariara mwutusa vahirata varivata nraase qora ini taqeta mwisa né Iesusira nraaqiarama variavo tivarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Iesusiva mwitaa tuvaro Saimoni Pitaava mwira sapara hiro tiqaro, Nrorao, e taini virerarave tiaro? tuvaro Iesusiva tiqaro, Ne virera hianirani e siama so ni vataqira vinarave. E naatiarama ni vataqira vinarave, tuvaro Pitaava tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nrorao, naraqamave ne sia so mate i vataqina vuanirave? Ne iara rieqana soma qutu vuanirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tuvaro Iesusiva tiqaro, Quqaave e niara rieqara qutu vinarave? Ne quqaa tianira riaane. Kokoraaravano sia nruqua tirara e taaramwo nani niara ne sia mwira taqaurave tinarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesusiva nai nraaqiaranravu tiva niro tiqaro, Sia niara riaivaro ini mwutusavano uaqa hiarive. Né Kotirara kepusaqamase riemwaqita vuanema seta niaravata kepusaqamase riemwaqita vuate. ");
INSERT INTO omw_a_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ni qora mwaatani airi mwo nraavu mwo nraavu vaisana ne iniara rieqana uro tequama natarerana vuqo. Sia mwitaama vahitiri, ne siama ini tiva nutiri. ");
INSERT INTO omw_a_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ne uro ini tequamatena uro ntantena uto ini vitaqina uro nena varianirani saarita, né nivata varivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ne virera hu aarara né ntapihi saarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tuvaro Tomaasiva qaqao tiro, Nrorao, te e virera hianara sia ntapihi sauro. Nataama setave te mwi aarara ntapihi saanarave? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tomaasiva mwitaa tuvaro Iesusiva mwira tiva mwiro tiqaro, Ne Kotiva hinani vua aarava mwaa mwivama varuqo. Ne quqaa osara mwaa mwivama varuqo. Ne qaqi variqi vua osarava mwaa mwivama varuqo. Sia mwo aararaqaama tero ni qova hinani vuariva vaiso. So ne mwaa aara mwivama varuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Né ni ntapihi seta taqaasara tita, né ni qoravata ntapihi seta taqevarave. Mate mwaa entaraqaataita né ni qora ntapihi setama né mwiravata taqaasama variavo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Mwitaa tuvaro Piripiva tiqaro, Nrorao, so ena qora tiri tiri tiva timwiraqe te mwira taqeta sove tiare, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesusiva mwira tiva mwiro tiqaro, Piripio, ne ini sapata muahaama varuqara e siave ni ntapihi sera taqaaro? Ni taqaiva ni qoravatama taqaiso. E naraqamave niara tiqara ena qora tiri tiva timwiane tiaro? ");
INSERT INTO omw_a_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Piripio, ne nena qoraqi varuqaro ni qova niqima variso. E siave mwi quarara quqaave tiaro? Ne ini tiva nu quara sia ne nena riemwa seqanavauma ini tiva nuqo. Ni qova niqi variva, mwiva variqaro nai saiqa vare variso. ");
INSERT INTO omw_a_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ne nena qoraqi varuqaro ni qova niqima variso. Mwi quarara quqaave tiate. Né sia niara riaivera, né ne saiqa varaurara rieqata niara quqaa mwivave tiate. ");
INSERT INTO omw_a_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ne quqaa tianira riaate. Niara quqaa mwivave tiva sero riemwaqiro vuariva, mwiva variqaro ne saiqa varauntema sero saiqa varaanarove. Ne nena qova hinani vuanirara tiro, mwira saiqavano ni saiqa nraatara saanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Né ni saiqara rieqata soma né mwo inraisararave, mwo saiqarave, ni sapara hivaqe ne ini nianirave. Né ni qora kepusa osara taqaate tina, ne mwira mwaaquvano mwitaa hirerave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Né ni saiqara rieqata so né mwo inraisa mwo inraisara ni sapara hivera, ne ini nianirave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ini mwutusavano niara vahirera, né ni quaqai riemwaqita vivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ne nena qora sapara hiariro mwiva ini saahaqa hianira Kotira Mwaraqura quqaa quaqai ti varianira titairaro ini airiqa hireraro uto esaa enta inivata varianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Qaqi nraase qora mwatani variasa sia Kotira Mwaraqura taqeta mwisa sia mwira ntapihi saarara tita, mwisa sia mwira so varevarave. Né mwira taqaavaro mwaa entara mwiva inivatama variso. Naatiara mwiva iniqima varianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Sia ne ini mwaini sena vuarita né nrairara nraaqiara votima seta varivarave. Ne ini saarinani uro ntantena tuvuanirave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pata iharaqa mwatani variasa sia ni taqaivata néqai ni taqevarave. Ne qaqi variqina vuariva varurara tita, névata qaqi variqita vivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mwi entara ne nena qoraqi varurave, né niqi variarave, ne iniqi varurave, né ntapihi sevarave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ni qua varase tutero mwi quara vataqiro vuanira mwira mwutusavano niara vahianarove. Niara mwutusa vahiariva variraro ni qora mwutusavano mwirara vahianarove. Ni mwutusavanovata mwi vaitirara vahianarove. Ne variqana mwi vaitira nena osara qoqaa tiva mwianirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tuvaro Iutaasiva sia Iutaasi Isikeriotiva mwo Iutaasiva tiqaro, Naraqamave e ena osara tiriqai tiva timwiqara sia mwatani variasa tiva ninarave? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iutaasiva mwitaa tuvaro Iesusiva tiqaro, (Mwatani variasa siama niara mwutusa ntisata variavo.) Vaitivano niara mwutusa vahiariva, mwiva ni qua riemwaqiro viraro ni qora mwutusavano mwirara vahianarove. Nevata ni qovavata mwi vaitiraqi uro varianarave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Vaiti mwovano sia niara mwutusa vahiariva, mwi vaitiva ni quavata sia vataqiro vuanarove. Ne ini tiva nu quara sia nena nraato tusena ini tiva nurave. Ne ni qoraqaataina mwi quara varena uto ini tiva nurave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ne mate inivata varu entara mwaa quara ini tiva nuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ne vuariro ni qova ini saahaqa hianira nai mwaraqura titairaro mwiva ni saiqara rieqaro uto variqaro esaa inraisa ini tiva niqaro ini vu nraatovata saahaqa hirata né ne tu quara ntapihi riemwa tevarave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ne virera hiqanama iniara mwaateraqama varivaro ini mwutusavano qihaasa hirata variate, tuqo. Mwaa mwatanaasa niari nariara nariara qua mwanteta tiqata, Mwaateraqama sera variane, ti variarave. Niari mwitaa tiqata qumina quaqai ti variarave. Ne iniara mwaateraqama seta variate tu quava siama qumina quave. Né ni qua riemwaqita vivaro ini mwutusaqitairo qihaasama vahirata sia aatu hivaro ini mwutusavano siama uaqa hianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ini sena vuariva uro ntantena tuvuanirave tu quara né vaasa riaarave. Ni qova ni naatara sero nroravano varirara tita, ini mwutusavano niara quqaaqama vahirera, ne nena qova hinani vuanirara né qamwateqata varivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mwi inraisava mwi inraisava naatiara mwitaa mwitaa hianirara ne mate ini tiva nuqo. So naatiara né taqaivaro mwi inraisava qovaramaqiro virata né niara tiqata mwiva tu quava mate quqaa mwivauma vaiso tivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","So mwaa entara mwatani variasaqaa ntaqaihi variva, Saataaniva, nrima varisanara tina, mwira saara ne sia ini sapata muahaa qua tianirave. Mwira kepusavano sia ni so nraatara saanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ni mwutusavano ni qorara vahira mwatani variasa taqaate tina, ne ni qora qua vataqina virerave. So varaivaqenravu mwaaqitaita vevante vuare, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesusiva mwo quaqaa ntuva sero nai nraaqiaranravu tiva niro tiqaro, Ne uaini apa suqeva varuqaro ni qova uainiqaa ntaqaihi varivama varisata né uaini mware saarama variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ni qova taqaisaro saara mwovano sia tava riaisaro mwiva mwira teqa qaqira sero uro taqaisaro mwo saaravano suqema sero tava riemwa taisaro mwiva suqema vahiqaro mwoqavata riaarive tiro, mwira rapatu sero vatairave. ");
INSERT INTO omw_a_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ne tu quava ini vaasa rapatu sero vataisatara tita, né soma variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Né niqi varivaqe ne iniqi variase. Saara mwovano nariaraqama vahiariva siama so tava riaanarove. Saara mwiva apaqaa ntaaqau vahiariva so tava riaanarove. Mwira votima seta né sia nivatama seta ntaaqauvi varivera, né siama so tava rievarave. ");
INSERT INTO omw_a_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ne uaini apa varuqata né sauqu saarama variavo. Ni vatama sero variraqe ne mwira vatama sena variariva, mwivama tava airi riaanarove. Né sia nivata ntaaqauvi variraitita né nétaraa varivera, né siama so mwo saiqavata varevarave. ");
INSERT INTO omw_a_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sauqu saara qaqira sairaro aaharama vuarintema sero sia nivata ntaaqauvi variani vaitira ni qova qaqira saanarove. Qaqira saani saarara mwira naatiara ntupi sero varaqiro tiaqi tuto sairaro itamwa taiqa saanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Né ni vatama seta ntaaqau vita varivaro ni quavano iniqi vahirera, né Kotirara néta mwutusa vahiani inraisarara sapara hivaro ini nianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Né ni qua riemwaqi viqata uaini saanta votima seta airi tava riaivaro ni qora nrutuvano nroraqaa hiarive. Né mwitaamaqi viqata né quqaaqama seta ni nraaqiara varivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ni qora mwutusavano niara vahintema sero ni mwutusavanovata iniara vaiso. Ni mwutusavano iniara vahira mwiqi variate. ");
INSERT INTO omw_a_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ne ni qora qua riemwaqina vi varuqaro mwira mwutusavano niara vahirave. Mwitaa huntema seta névata ni qua riemwaqita vivera, né ni mwutusavano iniara vahiraqi varivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ni mwutusaqi suqe hintema sero ini mwutusaqivata suqe hirata nroraqamase qamwateqata variate tina, ne mwaa quara ini tiva nuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ne mwo qua tianira né mwi quara riemwaqita vuate. Ni mwutusavano iniara vahintema seta névata nariara nariara mwutusa vahirata variate. ");
INSERT INTO omw_a_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Vaitivano nai nravunaasara mwutusa vaisaro mwisara rieqaro qutu virave. Mwitaama sero nai hena sara mwutusa vahiariva mwosara mwutusa vahi osarara esaa nraatara sero nritarero vahianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Né ni qua riemwaqita vivera, né ni nramwunaasama varivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Saiqa vaitivano sia nai nrora vaitivano mwitaa mwitaa hiani osarara ntapihirara tina, ne siama iniara ni saiqa vaitive tivaqina vuanirave. Ne iniara ni nramwunaasave tivaqina virerave. Ne ni qora qua riaura esaa ini tiva nunrara tina, ne mwitaa tirerave. ");
INSERT INTO omw_a_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Sia né ni nraaraarave. Ne ini nraaraurave. Ne ini nraaramase vita sena iniara uro satarivano tava riaintema seta suqe tava muahaama vahiani tavara riemwataate turave. Né mwitaa hivera, né ni nrutuarave, ni saiqarave rieqata nara inraisarave ni qora sapara hivaro mwiva ini nianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ne mwaa quara iniara mwitaa hiatema tuqo. Né nariara nariara mwutusa vahirata variqita vuate. ");
INSERT INTO omw_a_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mwatani variasa ini nravutaaqa hivera, né ntapihiate, mwisa ni nraante nravutaaqama taasara titama, inivata nravutaaqa hivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Né mwata mwainiaasa varivatavauma mwisa iniara tiri nravunaasave tiqata iniara mwutusa vahirata varivarave. Ne mwatani variasaqitaina ini nraarama sauqata né sia mwisaniqama variavo. Né sia misaniqama variarara titama, mwisa ini nravutaaqa hi variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ne vaasa tiva nunrara riaate. Sia saiqa vaitivano nai nrora vaiti nraatara sairave. Mwatani variasa ni uaqama matesara tita, mwisa inivata uaqama natevarave. Mwisa ni qua riesavauma ini quavata rievarave. ");
INSERT INTO omw_a_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Né ni nraaqiara variavatara tita, mwisa mwira saara inivata qoraqama natevarave. Ni titaira sia ntapihiasara tita, mwisa mwitaa hivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ne sia uto mwisa tiva nutirio, mwisa qora saiqa utuarara siama qua vahitirio. Ne uto mwisa tiva nunrara tiro, mwiraqaatairo mwisa qaqao sia mwira riaunarave ti quava siama vahianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Vaitivano ni nravutaaqa hiqaro ni qoravata nravutaaqa hianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mwo saiqa mwo saiqa sia mwisa so varaa saiqara ne mwi saiqara mwisa vuqaa variqana vare varuvave. Sia ne mwitaa hutirio, siama mwisaqaa qua vahitirio. Mwisa ni saiqa taqeta ni qaqira seta nivata ni qoravata nravutaaqa hiavo. ");
INSERT INTO omw_a_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mwisa mwitaama variavaro qua mwo haaru qumina vasa qara ntuva tova mate ntapihi sero mwivauma viso. Mwi quava mwitaama tiro: Sia mwo quavata vahirata quminaqama seta mwisa ni nravutaaqa hivarave, turave. (Sng 35:19) ");
INSERT INTO omw_a_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","So ini saahaqa hiariva mwovano tuvuanarove. Mwiva Kotira Mwaraquravano quqaa quaqai ti variva, mwiva Kotiva hinatairo tuvuanarove. Ne mwira nena qoraqaataina titaariro mwiva uto variqaro niara ntapihi sero ini tiva nianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Névata vuni nivatama seta variqi vuasara tita, né soma ni saiqa osarara mwo mwatanaa mwo mwatanaasa tiva niivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Né naatiara pupohairata ni qua qaqira sevo tina, ne mwi quara mwi quara ini tiva nuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Naatiara mwisa ini irora hiqata mwaara nraavuqitaita ini raaqu sevarave. Mwo enta nrintairata mwisa ini ru seta tiqata, Te Kotira saiqama vare varuro, tivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mwisa niaravata ni qoraravata sia ntapihi seta riaasara tita, mwisa mwitaa hivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ne mwaa entara naatiara ini uaqama naterara tiva nuqo. Naatiara mwisa mwitaa mwitaa hivata né mwi entara ne mate mwaa quara turara nraato tuate. Tauraa ne inivata variqanara tina, sia ne mwi quara mwi quara ini tiva nurave. ");
INSERT INTO omw_a_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","So ne pataqa vari sena ni titaiva hinani virerave. So ne mwini virerana uti varuqaro siama iniqitairo mwovano tiqaro, E taini virerarave hiaro? tiso. ");
INSERT INTO omw_a_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ne vaasa turara né rie variavaro ini mwutusavano uaqa isata variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","So ne quqaama tuqo. Ne sia vuariro ini saahaqa hiariva sia so tuvuanarove. Ne vuariva soma uro mwira titaariro né hinani tuvuanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kotira Mwaraquravano uto variqaro mwiva mwatani variasa taaramwo inraisara tiva nianarove: (1) mwisa uaqa hi saiqarave (2) suqe saiqa osararave (3) Kotiva ko tiani osararave ");
INSERT INTO omw_a_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","(1) Mwisa uaqa hi saiqara: Mwatani variasa sia niara quqaa mwivave tisara tita, mwisa uaqa hi saiqara utira mwiva tiva nianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","(2) Suqe saiqa osara: Ne nena qova hinani vuarita né sia qaiqaa ni taqerara tiro, mwiva variqaro suqe saiqa osara ini tiva nianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","(3) Kotiva ko tiani osarara: Mwaa mwataraqaa ntaqaihi variva Saataaniva ko sia nraatara sairara tiro, mwiva Kotiva ko tiani osarara mwatani variasa tiva nianarove. (Kotira Mwaraquravano mwitaama tiva nianarove.) ");
INSERT INTO omw_a_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ne mwo qua mwo qua ini tiva niariva vaisatavata, né sia mwi quara so rierara tina, mate ne sia mwi quara ini tiva nirerave. ");
INSERT INTO omw_a_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Quqaa quaqai ti variari mwaraqurava uto ntero, mwiva variqaro ini vita varero ini suqe aara tiva niqaro quqaa qua osara esaa mwi osarara ini tiva nianarove. Mwiva sia nai vu nraato tuani quarara tiraitiro, mwiva riaani quaraqaima tiva nianarove. Naatiara mwi inraisava mwitaa mwitaama qovara hiani inraisarara mwiva ini tiva nianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mwiva ne qua tianira mwi quara ini tiva nianirara tiro, ni nrutuvano nroraqaa hianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Esaa ni qova hi inraisava nini vahirara tina, ne vaasa tiqana, Kotira Mwaraqura mwiva ne hu inraisarara riero vara sero ini tiva nianarove, turave. ");
INSERT INTO omw_a_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","So pataqa né varita sia ni taqevarave. Mwiraqaataita pataqa né varita qaiqaa ni taqevarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iesusiva mwitaa tuvata mwira nraaqiara mwonravuvano nai tiva mwi nai tiva mwi hita tiqata, Mwiva nara quave tiso? Mwiva tiqaro, Pataqa né varita sia ni taqevarave, tiva sero qaiqaa tiqaro, Né vari seta ni qaiqaa taqevarave, tiso. Mwiva mwitaa tiva sero nai qova hinani vuaniraravata tiso. ");
INSERT INTO omw_a_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mwiva né pataqa vari setave ti quara, sia te mwi quara ntapihi riauro, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Mwitaa ti varuvaro Iesusiva ntapihi sovata mwisa mwi quarara mwira sapara hirerata uti varuvaro Iesusiva tiqaro, Ne vaasa turara né pataqa varita sia ni taqevarave mwiraqaataita pataqa varita qaiqaa ni taqevarave turave. Né mwi quararave nai sapara hi nai sapara hi variavo? ");
INSERT INTO omw_a_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","So ne quqaa tianira riaate. Né ntateqata atura ntiqa variqi vivata mwatani varisa qamwateqata varivarave. Ini mwutusavano uaqa hirata variqita vivaro mwiraqaatairo ini mwutusavano suqema vahirata varivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nraasevano nraaqiara mwataariva qaumato vaisarora tiro, mwiva atura ntirave. So mwi nraaseva nraaqiara mwata sero mwiraqaatairo tiqaro, Ne nraaqiara mwata sauqo, tiva sero qamwateqaro nai atura ntirara tauru sairave. ");
INSERT INTO omw_a_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Névata mwitaa hivarave. Mwaa entara ini mwutusavano uaqa hirata varivarave. So naatiara ne ini uro taqaariro ini mwutusavano suqe hirata so varivarave. Varivaro mwovano sia so ini qoraqama natairaro ini mwutusavano uaqa hianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mwitaa hirata mwi entara né mwo inraisara ni sapara hiva siama vahianarove. Ne quqaa tuqo. Mwi entara né ni qorara mwo inraisa mwo inraisara mwira sapara hivaro mwiva ni saiqarave, ni nrutuarave, rieqaroma ini nianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tauraa né variqata sia ni saiqarave ni nrutuarave rieqata ni qora sapara hiarave. Mwaa entaraqaataita né ni qora sapara hivaro ini mwutusa suqe hiarive tiro, ini nianarove. ");
INSERT INTO omw_a_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ne mwo quaqaa ntuva seqana mwo qua mwo qua ini tiva nurave. So mwo enta nri ntairaqe ne sia mwo quaqaa ntuva sena ini tiva niraitina, mwi entara ne nena qorara ini tiva nirera ne vutu senama ini tiva nianirave. ");
INSERT INTO omw_a_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mwi entava nri ntairata soma né ni nrutu nteqata ni qorara sapara hivaro ini nianarove. Sia ne iniara rieqana nena qora sapara hianirave. (Nétavano so mwira sapara hivarave.) ");
INSERT INTO omw_a_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ni qova iniara mwutusa ntisaro varirara tita, nétavano soma mwira sapara hivaro ini nianarove. Né niara tiqata, E Kotiva hinataira tuvuaravave, tiavaro ini mwutusavano niara vaisata variarara tiro, ni qora mwutusavanovata iniara vaisaro variso. ");
INSERT INTO omw_a_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ne nena qova hinataina mwatani tuvuvave. Ne qaumama mwaa mwatara mwaini sena nena qova hira qoqaraanani vuanirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mwitaa tuvata mwira nraaqiaranravuvano sove tita, Mate e sia mwo quaqaa ntuva sera tiraitira, e vutu serama tiri tiva timwi variaro. ");
INSERT INTO omw_a_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mate te ntapihi saurara e esaa inraisa ntapihi saarava variarata te siama i qaiqaa sapara hianarave. Mate te tiqata, Quqaama e Kotiva hinataira tuvuaravave turo, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Mwitaa tuvaro Iesusiva tiqaro, So mateve né ni osarara ntapihiavo? ");
INSERT INTO omw_a_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mwo enta nriariva qaumatoma vaiso. Mwi entaraqaa ini vara aaraupima saivata né mwona mwonamate néta mwaatani vivu saavuma vivarave. Ni qova nivatama sero varirara tina, ne mwi entaraqaa siama nenaraa varianirave. ");
INSERT INTO omw_a_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Né nivata varivaro ini mwutusa qihaasama vahiarive tina, ne mwaa quara ini tiva nuqo. Né mwatani varivata mwisa ini uaqama natevarave. So kepusaqama seta variate. Ne mwataniaa osara nraatara saurave, tiro. Iesusiva turama. ");
INSERT INTO omw_a_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesusiva mwi quara tiva sero mwiva naavuni taqeqaro Kotirara aasara ntero tiqaro, Kaao, mate mwaa ni entama nri ntaiso. So e ni kepusa osara qovarama matairaqe ne i mwaaquvano variqana ne ina kepusa osara tiva niase. ");
INSERT INTO omw_a_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","E nraase qora ni miarasa ne mwisa saahaqamaqina vuarita mwisa esaa enta qaqi variqita vuate tira, e ni nroraqama saarana ne esaa nraase qoraqaa ntaqaihi variqana ne mwisa nroravano varuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nraase qora esaa enta qaqi variqi vi osarava mwataamama vahiro: Nraase qora iara ntapihise rieta tiqata, Kotivaqaima quqaa mwariqa kuaiqavano variqaro Iesusi Karaisira titairave, tisa, mwisa mwi osarara varevara. ");
INSERT INTO omw_a_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ne mwatani variqi vina i kepusa osara nraase qora tiva niqana e saiqa mianara vara taiqa sauqo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","So kaao, haaru sia mwaa mwatavavata vahu entara ne ivata variqi vuavaro ni kepusa osaravano vahurave. So mate e ni kepusa osara mwira tiva nirata mwisa taqaate. ");
INSERT INTO omw_a_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mwataniaa vaitinravu ni miarasa ne mwisa i osara tiva nurave. Mwi vaitisa ena hiarasa ena mwisa ni miarata mwisa variqata i qua riemwaqita vuavo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","E qua ni tiva mianara ne mwisa tiva nuqata mwisa mwi quara varaarave. Mwisa ntapihi saavana ne quqaa e hianarataina tuvuqata mwisa niara quqaa Kotiva mwira titairave tiarave. Mwitaa tiqatara tita, mwisa ntapihi seta riaavaro e esaa inraisa ni miarava mwi inraisava e hianaratairo tuvirave. ");
INSERT INTO omw_a_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","So ne mwisara rieqanama iara aasara nte varuqo. Siama ne esaa nraase qora mwatani variasara aasara nte varuqo. E nraase qora ni miarata mwisa ini variarara tinama, ne mwisara rieqanama iara aasara nte varuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ne husa e hiarasama variavo. E hiarasa ne husama variavo. Mwisa variqata ni kepusa osara mwo hiasa tiva ni variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ne sia mwaa mwataraqaa variarita mwisama mwaa mwataraqaa varivarave. Ne e hianarani virerave. So kaao, e sotataqama sera variaravave. E ena kepusa nrutu ni mianara mwi kepusaraqotaira mwisa antuaraqira virata mwisa tetana kuaaqi varurantema seta mwisavata variate. ");
INSERT INTO omw_a_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ne mwisa sapata variqana e ena kepusa nrutu ni mianara mwi kepusaraqotaina mwisa antuaraqina vuqata sia mwisaqitairo mwoqavanovata raupirima viso. Vaiti kuaiqavanoqaima raupirima viso. Mwiva raupirima vuanirara haaru qaqi vasa mwovano mwirara qara ntuva tero mwitaa hianarove turaqaara tiro, mate mwitaama viso. ");
INSERT INTO omw_a_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","So ne ivata varirerana virera uti varuqo. Ni mwutusavano qamwatero suqe hintema sero mwisa mwutusavanovata qamwatero suqe hiarive tina, ne mwata mwaini variqana mwaa quara mwitaa tuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ne i qua mwisa tiva nuqata mwisa mwatani variasa nruaa aarara qaqira seta mwisa ne sia mwata mwaaqaanaava varuntema seta mwisavata siama mwata mwaaqaanaasa variavo. Mwitaama variavatara tita, mwatani variasa mwisa nravutaaqa hi variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","So ne sia mwata mwaaqaataira mwisa vitaanera i sapara huqo. Qaqao, ne iara tiqana, E mwisaqaa ntaqaihiqira viraro uaqa hi vaitiva sia mwisa uaqama nataarive, tuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ne sia mwata mwaaqaanaava varuntema seta mwisavata siama mwata mwaaqaanaasa variavo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","E quqaa quaqotaira mwisa saahaqa hirata mwisa i aaraqaaqai nruaate. I qua quqaa quama vaiso. ");
INSERT INTO omw_a_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","E ni mwata mwaini titaarana tuvuntema sena, nevata mwisa mwo mwata mwo mwatani titarerave. ");
INSERT INTO omw_a_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","So ne mwisara rieqana kuaa saiqaqai vararerana varuvave. (Ne mwisara rieqana qutu vuataa hiraqe qutu virerana varuqo.) Ne mwitaa hiarita mwisa quqaaqama i nraaqiara variqata i aaraqaaqai vivarave. ");
INSERT INTO omw_a_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Sia ne mwisaraqai rieqana iara aasara ntauqo. Naatiara mwo hisa mwisa qua rieqatama niara quqaa mwivave tisa, ne mwisaravata rieqanama iara aasara ntauqo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mwisa kuaaqi variate tina, ne iara aasara ntauqo. E niqi variarana ne iqi varuqo. Kaao, mwisa tiritana votima seta variate tira, e mwisa saahaqa hirata mwisavata tiritanaqi variate. Mwatani varisa niara quqaa Kotiva mwira titaivave tiate tira, e ni nraaqiaranravu saahaqa hirata mwisa kuaaqi variate. ");
INSERT INTO omw_a_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","E ni nrutu nroraqama saarana ne kuaaqarama sena mwisa nrutu nroraqama sauqo. Mwisa tetana kuaaqi varurantemase mwisavata kuaaqi variate tina, ne mwisa nrutu nroraqama sauqo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","E niqi variraqe ne mwisaqi variarita mwisa kuaaqi variqatama mwoqavata kepusaqama hivarave. Mwisa mwitaama varivata qaqi nraase qora mwatani varisa e ni titaanarara ntapihita i mwutusavano niara vahintema sero i mwutusavano ni nraaqiaranravuaravata vahianiravata taqevarave. ");
INSERT INTO omw_a_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Kaao, haaru sia mwaa mwatava vahu entara e niara mwutusa vahuvarara tira, e ni nroraqama soraro ni osara kepusa osaravano vahuvana variavarave. E nraase qora ni miarasa mwisavata ni kepusa osara taqaate tina, ne tiqana, Ne varianirani mwisavata varivarave, tuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kaao, e avuqavuma sera variaravave. Qaqi nraase qora mwatani variasa sia i ntapihi saavana neqai i ntapihi saurave. E ni titaanara mwaa nraaqiaranravusaqai mwira ntapihi saarave. ");
INSERT INTO omw_a_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne iara mwisa tiva nuqata mwisa i ntapihi saarave. I mwutusavano niara vahintema seta mwisavata mwosara mwutusa vahirata varivaqe ne mwisavata kuaaqi variqina vuase tina, ne mwisa iara mwoqavata tiva niqi vuarita mwisa ntapihi rievarave, tiro. Iesusiva nai qorara aasara nteqaro mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesusiva mwitaama sero Kotirara aasara tiva taiqa sero mwiva nai nraaqiaranravu vatama sero vuva uro Kitaroni pata nramariqaru qarero oripi satari saqava tutoraqi vura. ");
INSERT INTO omw_a_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iesusiva airi enta nai nraaqiaranravu sapata mwiqi uro varurara tiro, Iutaasiva Iesusira nravutaasa sauquqi saariva mwira ntapihi sora. ");
INSERT INTO omw_a_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Iutaasiva ntapihi sero uro Kotira saiqa vara mwate varu vaitisa mwisa nrora vaitinravuvata, Parisi vaitinravuvata, tiva nuvata mwisa kamanira porisinravu Iutaasira mwita saiqa vaitinravuvata mwira mwuvaro Iutaasiva mwisa vita varero vura. Mwisa ovavata ramuvata qupise vareta ntaqi inraisaravata vareta vusa uro Iesusiva hunani uro ntora. ");
INSERT INTO omw_a_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Mwini uro ntovaro Iesusiva vaasa mwisa uti inraisara ntapihi sero mwiva vutu ntero mwisa sapara hiro tiqaro, Né tararave huaa hi variavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mwitaa tuvata mwisa tiqata, Te Iesusira Nasaretiniaarara huaa hi varuro, tuvaro Iesusiva mwisa tiva niro tiqaro, Ne mwaa mwivama varuqo, tiro. Mwitaa tuvaro Iutaasiva Iesusira nravutaara sauquqi saari vaitiva, mwiva Iesusira rusesa sapata tiviro varura. ");
INSERT INTO omw_a_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iesusiva ne mwaa mwivave tuvata mwisa nriharama vita uro ntanteta aatuma seta mwatasata uto ntita varura. ");
INSERT INTO omw_a_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mwitaa huvaro Iesusiva qaiqaa mwisa sapara hiro tiqaro, Né tararave huaa hi variavo? tuvata mwisa qaiqaa tiqata, Iesusira Nasaretiniaararave, tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesusiva tiqaro, Ne vaasa ini tiva nurave. Ne mwaa mwivama varuqo. Né niara huaa hirerata nrivera, mwaa vaitinravusa qaqi saivata vuate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Vuni Iesusiva nai qorara mwitaama tiro: Vaiti mwonravu ni miarasa sia ne mwoku raupirima sauqo, tura. Mwi quava quqaa mwivau vahiarive tiro, Iesusiva tiqaro, Mwi vaitinravusa qaqi saivata vuate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mwitaa tuvaro Pitaava nai paipanta varero nrura veva ntarau sero mwiraqotairo Kotira saiqa vara mwate varu vaitisa mwisa vuniaa vaiti, mwira saiqa vaiti nraato tanarani vahura teqa sora. Saiqa vaiti mwira nrutu Marakusira. ");
INSERT INTO omw_a_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pitaava mwira nraato teqa sovaro Iesusiva Pitaarara tiqaro, Ena paipa vara veva nai tuaqi ntuva taane. Ni qova nramari ni mianira sia nivano nraarive tirave mwitaa hiaro? tiro. (Iesusiva nramariqaa ntuva sero nai ntuqutivaro nriqa vuani inraisara varero uro qutu vuanirara tura.) ");
INSERT INTO omw_a_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Iesusiva mwitaa tuvata Romeniniaasa ntaqu vaitisa niari qiata vaiti vatama seta nruvata Iutaa porisinravuvanovata nri nteta Iesusira ntavaaqavu seta mwira rupa seta ");
INSERT INTO omw_a_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","mwira vitaqita Anaasiva hunani nraante sora. Anaasiva mwiva Kaiapaasira nriraaviva varuvaro Kaiapaasiva nroraqama vuva mwi ihiraqi Kotira nraavuqi Kotira saiqa vara mwate varu vaitisaqaa ntaqaihiqaro qiata vaitivano varura. ");
INSERT INTO omw_a_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tauraa Kaiapaasiva nai Iutaa kaanasori vaiti tiva niro tiqaro, Tiri saahaqa hireraro vaiti kuaikuvano qutu viraro suqe hianarove, tu vaitiva varurama. ");
INSERT INTO omw_a_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Iesusira Anaasiva hunani vitaqita uro sovata Saimoni Pitaavavata Iesusira nraaqiara mwovanovata Iesusira vataqita vura. Anaasiva Pitaara vatama sero nru vaitira ntapihi sovara tiro, mwiva Iesusira vataqiro viqaro Anaasira mwaata mwatusa vutaqi viqetora. ");
INSERT INTO omw_a_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pitaava mwaaqani varuvaro Iesusira nraaqiara Anaasiva ntapihi so vaitiva mwatusa vutaqi vuva uro ntantero nrima qetiana ntaqaihi varu nraasera tiva mwitero uro Pitaara vitaqiro nrima vutaqi vera sora. ");
INSERT INTO omw_a_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Vutaqi sovaro Pitaava varuvaro nraase qetiqaa ntaqaihi varuva mwiva tiqaro, Evata mwi vaitira nraaqiarave variaro? tuvaro Pitaava qaqao, Ne siave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tiva sero varuvata porisinravuvanovata Anaasira saiqa vaitinravuvanovata varuvaro antovata mwisa tia quarateta tia taara hi varuvaro Pitaavavata mwini uro variqaro tia taara hi varura. ");
INSERT INTO omw_a_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mwiraqaatai Iesusira vitaqita mwoqi uro sovaro Kotira saiqa vara mwate varu vaitisa mwisa vuniaa vaitivano Iesusira nai nraaqiarara sapara hiro Iesusiva nraase qora tiva nu quararavata sapara huvaro ");
INSERT INTO omw_a_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesusiva nai tiva mwiro tiqaro, Ne qoqaa variqana nraase qora qua tiva nurave. Ne esaa enta nraase qora tiva nirerana Iutaavano uairama vita variaraqive, mwaara nraavuqive, Kotira nraavu nronraqive, variqana ne mwisa qua tiva nurave. Sia ne uqeta sena variqana mwisa qua tiva nurave. ");
INSERT INTO omw_a_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","So naraqamave e ni sapara hi variaro? E ni qua riaasa sapara hiataarave. Ne qua tiva nusa sapara hiane. Mwisa ne tu quara riaasave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesusiva mwitaa tuvaro porisi vaiti mwovano mwiqi varuva Iesusira nraatosai ntuteqa sero tiqaro, E sia mwitaama sera tiri nrora vaitiara qua tiane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Mwitaa tuvaro Iesusiva mwira tiva mwiro tiqaro, Ni quavano api qua vahiraravauma e esaa nraase qora mwirara tiva nirata rievarave. Ni quavano so vaisara e naraqamave ni qumina ntuqutira hiaro? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Iesusiva mwitaa tiva sero mwira saantaqotaita rupatova varuvaro Anaasiva mwira titovaro Kotira nraavuqaa ntaqaihi varu vaitira Kaiapaasiva hunani viro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Iesusiva mwini vuvaro Pitaava mwoqi variqaro tia taara hi varuvata mwini varusa mwira sapara hita tiqata, Evata mwira nraaqiarave variaro? tuvaro Pitaava qaqao, Ne siave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mwitaa tuvaro vaiti mwo qiata vaiti saiqa vaitivano Pitaava mwira nraato teqa sora mwira hena vaitivano Pitaarara tiqaro, Quqaa eve ne taqauqara mwisantiri satari saqavaqi variaro? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tuvaro Pitaava qaiqaa qaqaoqai tiro. Mwitaa tiva sero riovaro qamwanrama sero kokoraavano nruqua tura. ");
INSERT INTO omw_a_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mwisa Kaiapaasira mwini seta Iesusira vita vare uro nrora vaiti kamanira nraavuqi sora. Mwisa vaasa toqaqi mwini uro nteta mwisa Iutaavanora tita, sia mwira nraavuqi vera ntaraitita, mwaatani varura. Mwisa niari tiqata, Te mwira mwo mwatanaara nraavu sia sotataqi vera nteta uaqama vita mwira saara te siama vesahu nato entaraqaa omwata so nraanarave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mwitaa tiva seta mwisa mwaatani varuvaro Pairaativa kamanira qiata vaitivano mwisa taqareraro veva ntero mwisara tiqaro, Nara qua mwaa vaitiraqaa vaisatave tiavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pairaativa mwitaa tuvata mwisa tiqata, Mwi vaitiva sia uaqa hi saiqara utitirio, te siama so e hianarani mwira vite nruratirio, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mwisa mwitaa tuvaro Pairaativa qaqao tiro, Néta mwaa mwi vaitira viteta néta Iutaa ko quaqaa rieqatama mwira ko tiate, tiro. Pairaativa mwitaa tuvata Iutaa mwisa tiqata, Qaqao, te qumina vaiti variqata vaiti ru saanarara qua varaarorave. (Ena kamaniva variqara soma tirata mwira ru sevarave,) tita. ");
INSERT INTO omw_a_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mwisa mwitaa tuvaro Iesusiva mwisa mwitaama seta ni ru sevarave tu quava quqaa mwivau vahura. ");
INSERT INTO omw_a_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Iutaa vaiti nroranravuvano mwitaa tuvaro Pairaativa nai nraavu kamanira nraavuqi vera ntero Iesusira nraarama sovaro mwiqi vuvaro mwira sapara hiro tiqaro, Quqaa e Iutaaqaa ntaqaihi variaravave? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tuvaro Iesusiva tiqaro, Ena nraato tuserave mwi quara tiaro? Vaiti mwovano niara i tiva mwisarave e mwitaa tiaro? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Iesusiva mwitaa tuvaro Pairaativa tiqaro, Ne Iutaa vaitive huqo? Ne sia Iutaa vaitive. Ina nravunaa Iutaavanovata, Kotira saiqa vara mwate varia vaitisa mwisa nrora vaitinravuvata, mwisama i viteta mwaini nriavo. E nataama saaratave i viteta nriavo? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mwitaa tuvaro Iesusiva tiqaro, Ne ntaqaihiariva siama mwaa mwataraqaa vaiso. Mwiva mwaa mwataraqaa vahitirio, Iutaavano ni rupevo tita ni saara ni vataqi nrisa mwisavata ntaquatirio. So ne ntaqaihiariva siama mwatani vaiso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Iesusiva mwitaa tuvaro Pairaativa tiqaro, So quqaa e nraase qoraqaa ntaqaihi variaravave? tiro. Tuvaro Iesusiva tiqaro, Quqaa ne nraase qoraqaa ntaqaihi varuvave. Mwirara rieqaro ni mwatani mwatataisana nruvave. Quqaa qua osara nraase qora tiva nirerana ne mwatani tuvuvave. Quqaa quara riaariva ni quama riaanarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Iesusiva mwitaa tuvaro Pairaativa tiqaro, Quqaa qua vahireraro mwira nara quave iso? tiro. Pairaativa mwitaa tiva sero veva ntero Iutaa uairama vita varusa tiva niro tiqaro, Ne taqauqaro sia mwira rusaarava mwo osara mwiraqi vaiso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mwitaa tiva sero mwiva tiqaro, So né mwo inraisa utuava mwitaamama vahiso. Né vesahu nato sarara omwata nraa entaraqaa ne karavu vaiti kuaiku iniara rieqanama mwira avantu nataurave. Sove ne mwirara rieqana ini Iutaaqaa ntaqaihi vari vaitira avantu nataanirave? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mwitaa tuvata mwisa aasara ntavase nai tiva mwita tiqata, Qaqao, sia mwi vaitira avantu saane. Vaiti mwo mwira nrutu Varavaasira mwira avantu timwataane, tura. So Varavaasiva vaiti ru seqaro mwisa munima vare varu vaitiva varura. ");
INSERT INTO omw_a_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mwisa mwitaa tuvaro qaiqaa Pairaativa tiqaro, Iesusira viteta uro saantaqo mwira ntuteqaate, tuvata mwira saantaqo ntuteqaateqamase vatora. ");
INSERT INTO omw_a_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mwitaamase vateta Pairaatira ntaqu vaitisa uro kauvera vara seta qiata vaiti tave voti hura ququrama seta mwira qiataqaa qu mwateta nraare mpuruqa vara utu mwateta, ");
INSERT INTO omw_a_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","mwisa mwiva varunani uro nteta mwisa vireraqamase Iesusirara tiqata, Iutaa vuniaa vaiti mwaavao, variqarave? tiva seta sauquqo mwira viri ntuteqa sora. ");
INSERT INTO omw_a_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mwisa mwira mwitaama sovaro Pairaativa qaiqaa veva ntero Iutaa uairama vita varusara tiqaro, So taqaate. Ne taqauqaro sia mwiva uaqa hi saiqara utisana ne mwiraqaa qua vataariva siama vahirove. Névata mwira taqe ntapihi saate tina, ne mwira vara veva sarerave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mwitaa tuvaro Iesusiva qiataqaa kauvera qu mwateta nraare mpuruqa utu mwatora rirante veva ntovaro Pairaativa tiqaro, So taqaate, mwaa mwi vaitivave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mwitaa tuvata Kotira nraavuqi Kotira saiqa vara mwate varu vaitisa mwisa nrora vaitinravuvata, porisinravuvata, Iesusira taqeta mwisa aasara nteta tiqata, Satariqaa mwira hiritaate. Satariqaa mwira hiritaate, tita. Mwitaa tuvaro Pairaativa tiqaro, Néta mwira vitaqita uro satariqaa hiritaate. Ne taqauqaro sia mwiva uaqa hi saiqara utisana ne mwiraqaa qua vataariva siama vahirove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tuvata mwisa tiqata, Qaqao, mwiva te qao tiva tauna quara mwo nteqa sairave. Mwira saara mwiva qutu vuarivama variso. Mwiva tiqaro, Ne Kotira mwaaquvanove tirave, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Mwitaa tuvaro Pairaativa mwi quara riero mwoqavata aatu hiro ");
INSERT INTO omw_a_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","mwiva uto ntantero nai nraavuqi vera ntero Iesusira sapara hiro tiqaro, E tainiaavave? tiro. Tuvaro Iesusiva sia qua tiraitiro, tirema varura. ");
INSERT INTO omw_a_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tirema varuvaro Pairaativa tiqaro, E nive sia qua tiva mirera utuaro? E riaane. Ne nroravano ne soma i avantu sena, ne soma tiarita i satariqaa hiritevarave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mwitaa tuvaro Iesusiva Pairaatira tiva mwiro tiqaro, Kotiva naavuni variva sia i kepusa mwitirio, siama so e ni nraatara saaratirio. Vaiti mwovano ni vitaqiro nrima i mwi vaitira saiqavano i uaqa hi saiqaravata nraatara saiso. Mwira saara mwi vaitiraqaa nrora quama vahianarove, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Iesusiva mwitaa tuvaro Pairaativa mwiraqaatairo Iesusira avantu sarera uti varuvata Iutaa vaitinravu uairama vita varusa aasara nteta tiqata, E mwira avantu sairaro qaqi virera, e siama qiata vaiti Sisaara toti varinarave. Mwovano nariara tiqaro ne qiata vaitima varuqo tiariva, mwiva Sisaara nravutaama varianarove, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tuvaro Pairaativa mwi quara riero uro Iesusira vitaqiro veva ntero ko riaa vaitisa taintaqaa uro mwatasaa viro. Mwi taintava vahu mwatara nrutu nteqata, Ori Ntavatairave, tura. Iutaa mwatanaasa quaqitai mwirara Kapatave, tura. ");
INSERT INTO omw_a_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Vesahu nato sarara nro entava mwira qararaara vahuvaro huari vu nriro virini qiataqaa vahuvaro Pairaativa uro mwi taintaraqaa mwatasaa viro Iutaa uairama vita varusa tiva niro tiqaro, So né néta qiata vaiti mwaa taqaate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tuvata mwisa aasara nteta tiqata, Mwira ru saane. Mwira ru saane. Mwira satariqaa hiritaivaro qutu vuarive, tita. Mwitaa tuvaro Pairaativa mwisa sapara hiro tiqaro, Ne tiarita ini qiata vaiti satariqaa niriqo ru terara ini mwutusa vahirove iso? Mwitaa tuvata Kotira saiqa vara mwate varu vaitisa mwisa nrora vaitinravu tiqata, (Mwiva sia tiri qiata vaitive.) I nroravano Sisaava mwivaqai tiri qiata vaitive, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mwitaa tuvaro Pairaativa Iesusira satariqaa hiritaate tiro, mwisa sauquqi sora. Pairaativa Iesusira mwisa nuvata mwisa mwira viteta vuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iesusiva nai hirite satarira vara qu varero vuvata mwisa Iesusira vita vareta mwaa quaraqitai Qiata Mwusaari satave tunani vita. Iutaa mwatanaasa quaqitai Korokotaave tunani uro ntora. ");
INSERT INTO omw_a_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Uro nteta Iesusira suqu sauqu satariqaa niriqotaita ruseta vara mwaavi mwataqi ratora. Mwira rateta vaiti mwotanavata satariqaa ru seta hini hini ratovaro Iesusiva mwitanasa vutaqaa varura. ");
INSERT INTO omw_a_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Iesusira satariqaa hiritovaro Pairaativa qua qara ntuva tora uro Iesusira qiatani satariqaa rutora. Mwataama sero qara ntuva tero: IESUSIVA NASARETINIAAVA IUTAA VUNYAA VAITIVE, tura. ");
INSERT INTO omw_a_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Iesusira satariqaa hiritova Ierusaremi tataaqani vahuvatara tita, mwi mwatanaasa airivano nrima Iesusira taqeta mwi quara saara ntuva seta taqora. Mwi quara taara mwo quaqitairo qara ntuva tora. Iutaa quaqitaivata, Romeni quaqitaivata, Kiriki quaqitaivata, qara ntuva tora. ");
INSERT INTO omw_a_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kotira nraavuqaa ntaqaihu vaitisa mwi quara taqeta Pairaatirara qaqao tita, E sia mwirara Iutaa qiata vaitive tiva sera qara ntuataarave. E mwataama sera qara ntuataarave. Mwi vaitiva nai tiqaro ne Iutaa qiata vaitive tirave. Mwitaa tiva sera qara ntuane, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tuvaro Pairaativa qaqao tiro, Ne qara ntuva tauva so mwitaama vahiarive, tura. ");
INSERT INTO omw_a_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ntaqu vaitinravusa Iesusira satariqaa hiriteta mwiraqaataita mwira tuavaaqa vara seta erahiamuaantema ntuaqama seta ntaqu vaitisa niari erahiamuaantema variqara tita, mwovano mwoqaatairo varovaro mwovano mwoqaatairo varero mwitama seta vareta mwira siotivata vara seta taqovaro mwuahaanta virisairo miani tuvitarova vahuvata ntaqu vaitinravusa tiqata, Sia mwaa nrahituare. ");
INSERT INTO omw_a_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nrivaqe mwirara kaati voti hira santu ruararo tiriqitairo mwovano mwira varaarive, tita. Mwitaa turara tiro, mwo quavano haaru qumina vasa qara ntuva tova quqaa mwivau vahura. Mwataama tiro: Ni tuavaaqa ntuaqama seta varevarave. Ni sioti mwuahaanta vararerata kaati ruantema setama varevarave, tiro. Mwitaa tura. (Sng 22:18) Ntaqu vaitinravusa mwitaama seta Iesusira tuavaaqa ntuaqama seta varora. ");
INSERT INTO omw_a_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iesusira satariqaa hiritovata nraasenravuvano nrima mwi satarira tataaqa tivita varura. Iesusira nrovavata, mwira nrora nruravanovata, Kiropaasira nraata Mariaavavata, Mariaava Makataraniaavavata, mwinravusa Iesusira hirito satarira tataaqa tivita varuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iesusiva taqovata mwira nrovavata mwira vataqiro nruo vaitiva mwo Iesusiva mwirara mwutusa ntu vaitivavata varura. Mwitanasa varuvaro Iesusiva nai nrorara tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mwaa nraasevao, e mwi vaitirara ni maaquve tiane, tiro. Tiva sero nai vataqiro nruo vaitira Iesusiva mwirara mwoqama sero mwutusa ntu vaitirara tiqaro, Mwaa nraaserara ni ntorave tiane, tiro. Mwitaa tuvaro mwi entaraqaatairo mwira vataqiro nruo vaitiva Iesusira nrora vitaqiro nai nraavuqi sero suqema sero mwiraqaa ntaqaihiqiro vura. ");
INSERT INTO omw_a_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iesusiva mwi quara tiva sero mwiva ntapihi sovaro so mwira saiqavano taiqa vura. Mwiraqaatairo mwo qua haaru qumina vasa vukuqi qara ntuva tova quqaa mwivau vahiarive tiro, mwiva tiqaro, Ni nramari nraataa iso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mwitaa tuvaro uaini ukavura tanaaqi vahuvaro mpuruqa viti vara sero nramariqi ntava sero saavu vitiqaa rupa sero viri Iesusira nroqi ntava tovaro ");
INSERT INTO omw_a_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iesusiva ukavu nramarira mwira nrero mwiraqaatairo mwiva tiqaro, So taiqama viso, tiva sero nru kinta sero nai mwaraqura titovaro vuvaro mwiva qutu viro. ");
INSERT INTO omw_a_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mwiva qutu vuvaro mwira qararaara mwaara enta vesahu nato sarara nro entava nrora enta vahianirara tita, Iutaavano tiqata, Hura vaitinravu qutu vuasa mwisa mwavanta satariqaa vahiasorave tiva seta, uro Pairaatirara tiqata, E tirata mwinravusa suqu ntuvuraa saivata mwinravusa qamwanrama qutu vivata varaqita uro quntaate, tita. ");
INSERT INTO omw_a_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tuvaro Pairaativa eo tuvata mwira ntaqu vaitinravusa nrima Iesusira tataaqa hirito vaitira suqu ntuvuraa seta uro vaiti mwo hini hiritora suqu ntuvuraa seta ");
INSERT INTO omw_a_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","uro Iesusira suquvata ntuvuraa saare tita, taqovaro mwiva vaasa qutu vuvata mwisa qaqira seta sia mwira suqu ntuvuraaqura. ");
INSERT INTO omw_a_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ntaqu vaitiva mwovano uro vaataaraqotairo Iesusira nraantera sata ra varero. Ra sovaro qamwanrama sero nraarevata qaqi nramarivata tuvura. ");
INSERT INTO omw_a_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","So ne mwaa quara qara ntuva tauva mwi entara variqana ne mwi inraisara mwi inraisara taqaavarave. Quqaaqama sena ne mwi inraisara mwi inraisara taqaavarave. Né mwi quarara quqaave tiate tina, ne mwi inraisara quqaaqama sena taqaurara inivata tiva nuqo. ");
INSERT INTO omw_a_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ntaqu vaitiva mwitaa hurara tiro, haaru qaqi vasa qara ntuva to quava quqaa mwivau vahura. Qara ntuva tova mwataama tiro: Mwisa sia mwira mwusaari mwo ntuvuraa sevarave, tura. (Sng 34:20) ");
INSERT INTO omw_a_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Qaiqaa mwo quavata haaru qara ntuva tova tiqaro: Mwisa niari vaataaraqotaita rute vaitira taqevarave, tura. (Sek 12:10) ");
INSERT INTO omw_a_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mwitaa huvaro vaiti mwovano mwira nrutu Sosepiva mwiva Arimatianiaava mwiva tauraaqama Iutaa vaitinravu nraatu aatu hiqaro quqeta seqaro Iesusira vataqiro nruo vaitiva, mwiva nrintero Pairaatirara tiqaro, Iesusira mwavanta miraqena varaqina quntaase, tiro. Tuvaro Pairaativa tiqaro, So uro vara sera quntaane, tuvaro Sosepiva uro Iesusira mwavanta itu sero varora. ");
INSERT INTO omw_a_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Varovaro Nikotimaasiva, mwiva haaru entaqi Iesusira uro taqova, mwivavata suqe ueri suqe hu satariva mwunta vura kuaaqi tuqataase vatoravata varero. Mwira muaaravano vahireraro 30 kiro vahura varero Sosepisantiriro viro. ");
INSERT INTO omw_a_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mwitanasa Iesusira mwavanta vareta eqarori mpuruqa vara seta suqe mwunta vura vatama seta mwira mwavanta qapuqama sora. Iutaa mwatanaasa vaiti qunto osarava mwitaama vahurara tita, mwitanasa mwitaa hura. ");
INSERT INTO omw_a_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Iesusira hiritonani saqava tutova vahuvaro mwiqi qaraaha ori vauru tora vaiti qunte varuva mwo vahura. Mwira qaraaha vahuvaro tauraa sia vaiti mwo mwiqi quntora. ");
INSERT INTO omw_a_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","So mwira qararaara Iutaa mwatanaasa mwaara enta vahianarove tiva seta, mwi oriva qaumato vahuvata mwiqi mwitanasa Iesusira uro quntama tora. ");
INSERT INTO omw_a_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","So Saanteqa toqa entaqi qaso qataa hirera huvaro Mariaava Makataraniaava Iesusira oriqi quntama toraqi nrintero taqovaro orivano qeti titatova qaqinani vara sovaro vahiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ori qaqinani vara sova vahuvaro mwi nraaseva uro ntante santero Iesusira nraaqiaratana Saimoni Pitaavavata, mwo vaiti Iesusiva mwirara mwoqama sero mwutusa ntu vaitivavata, varunani nri ntero mwitanasa tiva niro tiqaro, Mwisa oriqitaita Iesusira vara saavata tirenravu sia mwira varaqita vataara taqauro, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mwitaa tuvata Pitaavavata, vaiti mwo mwivavata, Iesusira oriqi vatora mwiniara vita. ");
INSERT INTO omw_a_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mwitanasa santeta vuvaro mwovano Pitaara nraatara sero mwiva nraante oriqi Iesusira quntama tonani nrintero. ");
INSERT INTO omw_a_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mwiva nraane nrintero siama mwiqi viqetaraitiro, qaqinani variqaro kakataama viro vera taqovaro oriqi mpuruqaqai vahura. ");
INSERT INTO omw_a_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mpuruqaqai mwiqi vahuvaro taqero varuvaro naatiara Saimoni Pitaava nri ntero mwiva sia qaqinani variraitiro, mwiva qamwanrama oriqi vera ntero taqovaro mpuruqaqai vahuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","mwo mpuruqavata, Iesusira qiata nraavuma tova mwivavata, qumina vahiro. Iesusira ququtama to mpuruqava, mwi mpuruqava sia mwo mpuruqavata kuaaqaa vahiraitiro, nariara mwosata vahura. ");
INSERT INTO omw_a_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mwitaama vahuvaro vaiti mwo vaasa nruva, mwivavata mwiqi verantero mwi inraisara taqama sero mwiraqaatairo mwira vu nraato ntapihi vuvaro Iesusira osarara ntapihi sero so quqaa mwivave tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tauraa mwitanasa variqata vukuqi Iesusiva qutu viro qaiqaa qaqi tivuanirara qara ntuvato quara sia ntapihi riora. Sia ntapihiraitita, variqi vita so mwi entara mwitanasa mwi quara ntapihi sora. ");
INSERT INTO omw_a_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mwi inraisara taqeta mwitanasa nrima ntanteta mwaatani vura. ");
INSERT INTO omw_a_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mwitanasa mwaatani vuvaro Mariaava Iesusira quntama tonani nri ntero qaqinani variqaro ntate variro. Mwiva ntate variqaro kakataama sero oriqi vera taqovata ");
INSERT INTO omw_a_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","naavuniaasa taaratana mwiqi varura. Mwitanasa eqarori tuavaaqa ututotana mwovano tauraa Iesusira mwavantavano vahura qiatani mwatasaa viro varuvaro mwovano mwira suqutarani mwatasaa viro varura. ");
INSERT INTO omw_a_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mwitanasa Mariaara sapara hita tiqata, Mwaa nraasevao, nara inraisarave e ntate variaro? tuvaro mwiva tiqaro, Mwosa ni nrora vaiti mwaaqitaita vara saavana ne mwisa uro mwira saanani sia taqaraitinama, mwirara ntate varuqo, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mariaava mwitaa tiva sero mwiva tuqataa viro taqovaro Iesusiva mwira mwoqani tiviro varuvaro mwiva sia mwira viri ntapihi taqaraitiro, mwo vaitivanove tiqaro varuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesusiva mwira sapara hiro tiqaro, Mwaa nraasevao, naraqamave e ntate variaro? E tararave huaa hi variaro? tiro. Iesusiva mwitaa tuvaro Mariaava nai riero tiqaro, Mwi vaitiva saqava mwaaqi ntaqaihi vari vaitivave, tiro. Tiva sero mwirara tiqaro, E mwira vitaqira uro serava varirera, mwiqi vatauqo tiraqe ne uro varaase, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mwitaa tuvaro Iesusiva mwirara tiqaro, Mariaao, tiro. Tuvaro Mariaava tuqataa viro Iesusira ntapihi taqero Iesusirara nai Iutaa quaqitairo tiqaro, Raponaio, tiro. Mwaa quaraqitai tirera, Mwaara ti variara vaitio, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Mariaava mwitaa tuvaro Iesusiva tiqaro, So sia niqaa tu varaane. Ne sia nena qova hinani uto ntantena vuqo, tiro. Mwitaa tiva sero mwiva mwira tiva mwiro tiqaro, E ni qatavara uro tiva niane. Niara mwitaa mwitaama sera tiva niane. Ne virini ni qovavata ini qovavata hinanive, ni mwariqavanovata ini mwariqavanovata hinani uto ntantena virerave, tiso tiane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mwitaa tuvaro Mariaava Makataraniaava nrima ntantero uro Iesusira nraaqiaranravu tiva niro tiqaro, Ne tiri nrora vaiti mwira taqauqo. Mwiva niara mwitaa mwitaama sera ini tiva niane tiso, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mwi Saanteraqaa enta huvata Iesusira nraaqiaranravuvano Iutaa nrora vaitinravu nraatu aatu hiqata nraavu mwoqi qetinravu vahura ruteta varura. Mwisa mwiqi varuvaro mate mwiqara Iesusiva mwisa vutaqaa qovarama viro tivi variro mwisa qua mwantero tiqaro, Ini mwutusa qihaasa hirata variate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mwitaa tiva sero mwiva nai sauqu niriqotaita rutora mwisa tiva niro nai nraanterasataa rutoravata tiva nura. Tiva nuvata mwira nraaqiaranravu mwira taqovaro mwisa suqe huvata mwisa mwirara qamwateqata varura. ");
INSERT INTO omw_a_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Varuvaro Iesusiva qaiqaa mwisa qua mwantero tiqaro, Ini mwutusa qihaasa hirata variate. Ni qova ni titaintema sena ne inivata titarerave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mwitaa tiva sero mwiva mwisaqaa nai nraaiho vuata sero tiqaro, So Kotira Mwaraqura varaate. ");
INSERT INTO omw_a_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Né vaiti mwovano Kotira qua nteqa saani quara qaqira saivera, mwi quava taiqama vuanarove. Né mwi quava qaqi vahiarive tivera, mwi quava qaqima vahianarove, tiro. Mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Iesusiva nai nraaqiaranravu hunani nri ntero mwiqi varuvaro mwi entara mwira nraaqiara mwovano 12 nravuqitairo sia mwisavata varura. Mwira nrutu Tomaasira mwira mwo nrutu Kaapirave tura. ");
INSERT INTO omw_a_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Iesusiva vuvaro Tomaasiva mwitairo nri ntovata Iesusira nraaqiara mwo husa Tomaasira tiva mwita tiqata, Te nrora vaiti Iesusira taqauro, tita. Tuvaro Tomaasiva tiqaro, Qaqao, ne sia mwira sauquqi niri rutaara nrumwaara taqena, ne sia nena sauqu mwiqi veta sena, mwira nraanterani rutaaraqivata sia nena sauqu veta saraitina, sia ini quara quqaave tianirave, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tomaasiva mwitaa tiva sero varuvaro kuaa uiki nritarovata Iesusira nraaqiaranravuvano varuvaro Tomaasivavata mwisa sapata variqata esaa qeti ruteta mwiqi varuvaro Iesusiva qaiqaa qovarama viro mwisa vutaqaa tiviro variro mwisa qua mwantero tiqaro, Ini mwutusa qihaasa hirata variate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tiva sero mwiva Tomaasirara tiqaro, So ena sauqu tutu sera ni sauquqi veta seqara taqaane. Ena sauqu tutu sera ni nraanterani rutaaraqi vera seqara taqaane. E niara taara nraato tinara qaqira saane. E niara kepusaqama sera riemwaqira vuane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mwitaa tuvaro Tomaasiva mwira tiva mwiro tiqaro, E ni nroravanove. E Kotiva ni mwariqavano variaro, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mwitaa tuvaro Iesusiva mwira tiva mwiro tiqaro, Tomaasio, e ni taqera mwiraqaatairama e niara quqaave tiaro. So tasave sia ni taqaraitita, niara quqaa mwivave tisa, mwisa qamwateqata variate, tiro. Iesusiva mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesusiva nai nraaqiaranravu vuqaa variqaro nai osara tiva nireraro nrora saiqa, mwo saiqa mwo saiqa vare varura. So ne Ioniva mwi saiqara hiniqai mwaa vukuraqi qara ntuva tena. ");
INSERT INTO omw_a_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Né Iesusirara quqaa mwiva tiri saahaqa hiariva variqaro quqaama mwiva mwariqa Kotira mwaaquvano variso tiva seta mwirara kepusaqama seta riemwaqita vita esaa enta esaa enta qaqi variqi vuate tina, ne Ioniva mwaa quara qara ntuva taura. ");
INSERT INTO omw_a_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mwo enta Iesusira nraaqiaranravuvano Taipiriaasi nrukaqa Kariri mwatani varuvaro Iesusiva qaiqaa mwisa vuqaa qovarama vuvata mwira nraaqiaranravuvano mwira taqora. Mwataamama mwi quava vahiro. ");
INSERT INTO omw_a_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Mwira nraaqiaranravu Saimoni Pitaavave, Tomaasiva mwira mwo nrutu Kaapivave, Kenaa mwatusa Kaririniaa vaiti Nataanierivave, Sepetira mwaaqutanave, Iesusira nraaqiara mwo taaratanave, mwinravusa mwini kuaaqi varura. ");
INSERT INTO omw_a_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimoni Pitaava hini mwisara tiqaro, So ne tavusara vahe ntarera virerave, tuvata mwinravusa tiqata, Tirevata virerave, tita. Mwitaa tiva seta uto votuqi mwaari nteta mwiqi variqata entaqi tavusara vahe ntavaqi vita sia tavusa mwokuvata varora. ");
INSERT INTO omw_a_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mwitaamaqita vuvaro qataa hirera huvata mwisa taqovaro Iesusiva nruka tosaqaa tiviro varuvata mwisa sia mwira ntapihi taqaraitita, mwo vaitive tuvaro ");
INSERT INTO omw_a_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","mwiva mwisara tiqaro, Ni vaitituaavo, siave né tavusa vareta hiavo? tiro. Mwitaa tuvata mwisa tiqata, Sia varauro, tuvaro mwiva tiqaro, ");
INSERT INTO omw_a_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","So né vahe sauqu tanarani seta tavusa varaate, tiro. Mwitaa tuvata mwisa vahe sauqu tanarani seqata taqovaro vahevano kuraama vuvaro tavusa airinti mwiqi vahuvaro anoma sero muaara ntovata mwisa sia so vahe pati mwaari votuqi vataaqara hura. ");
INSERT INTO omw_a_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mwisa sia vahe pati mwaari votuqi vataaqara huvaro Iesusiva mwoqama sero mwutusa ntu vaitiva Pitaara tiva mwiro tiqaro, Mwi vaitiva tiri nroravanove, tiro. Mwitaa tuvaro Saimoni Pitaava mwi quara riero nai sioti qaqini vatora vara utu varero votuqitairo mwaavi ntero nramariqi avuhu viro nako ru varero Iesusiva hunaniara vuvata hini mwisa votu mwiqi varura. ");
INSERT INTO omw_a_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nruka tosa mwiva sia niarani vahuvatara tita mwisa votuqi variqata tavusavano vahe kuraama sora ntarauqi vita tosani uro ntora. ");
INSERT INTO omw_a_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tosani votu uro vateta mwisa mwaavi nteta taqovaro tia quaratero mwiraqaa tavusa utatova vahuvaro mperetivata vahura. ");
INSERT INTO omw_a_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Vahuvaro Iesusiva mwisara tiqaro, Tavusa mateqa varataara saatavata vareta nriate, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mwitaa tuvaro Saimoni Pitaava votuqi mwaari ntero vahe mwira ntarauqiro tosani uro sora. Tavusa airi 153 nravu vaheqi vahuvaro vahevano ntupema vuataara sia ntupema vura. ");
INSERT INTO omw_a_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Mwitaa huvaro Iesusiva tiqaro, So nrita sara nraate, tuvata mwisa Iesusira vaasa ntapihi seta te sauruaro tita mwisaqitairo sia mwovano Iesusirara e tavave tura. ");
INSERT INTO omw_a_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Qaqi varuvaro Iesusiva mperetivata tavusavata mwisa nuvata nrora. ");
INSERT INTO omw_a_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iesusiva nai qutu vuraqitairo tiviro nai nraaqiaranravu vuqaa qovarama vuvata mwisa mwira taqora. Mwi entara taaramwo nani mwisa vuqaa qovara hura. ");
INSERT INTO omw_a_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mwisa sara nrava sovaro Iesusiva Saimoni Pitaara sapara hiro tiqaro, Saimonio, Ionira mwaaquo, quqaave mwaa vaitisa mwutusavano niara vahiravata nraatara sero i mwutusavano niara mwoqavata vaiso? tiro. Mwitaa tuvaro Pitaava tiqaro, Nrorao, quqaave. Ni mwutusavano iara vahira mwira e ntapihi saanarave, tiro. Tuvaro Iesusiva tiqaro, So ni sipisipi nraati sara niane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mwitaa tiva sero Iesusiva qaiqaa mwira sapara hiro tiqaro, Saimonio, Ionira mwaaquo, quqaave i mwutusavano mwoqavata niara vaiso? tiro. Tuvaro Pitaava tiqaro, Nrorao, quqaave. Ni mwutusavano iara vahira mwira e ntapihi saanarave, tiro. Mwitaa tuvaro Iesusiva tiqaro, So ni sipisipiqaa ntaqaihiane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mwitaa tiva sero Iesusiva qaiqaavata tiqaro, Saimonio, Ionira mwaaquo, quqaave i mwutusavano mwoqavata niara vaiso? tiro. Iesusiva taaramwo nani tiqaro, Quqaave i mwutusavano mwoqavata niara vaiso, tuvarora tiro, Pitaara mwutusavano uaqa huvaro mwiva tiqaro, Nrorao, e esaa inraisa ntapihi saaravave, Ni mwutusavano iara vahira mwira e ntapihi saanarave, tiro. Mwitaa tuvaro Iesusiva Pitaarara tiqaro, So ni sipisipi sara niane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iesusiva mwitaa tiva sero Pitaara tiva mwiro tiqaro, Ne quqaa qua tianira riaane. Tauraa e qaraaha vaiti variqara e tuavaaqa utu varera ena virera hianaraqaa vuanarave. Naatiara e naapaiqama vira ena sauqu tututairaro mwovano i tuavaaqa utu mwatero i vita varero sia e virera tinaraqaa vuanarove. ");
INSERT INTO omw_a_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesusiva mwi quaraqaa ntuva sero Pitaava mwitaama sero Kotira nrutu tuaahereqaro uro qutu vuanarove, tura. Iesusiva mwi quara tiva sero mwiva Pitaara qaiqaa tiva mwiro tiqaro, E ni vataqira nriane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Mwitaa tuvaro Pitaava tuqataa viro taqovaro Iesusiva mwoqama sero mwutusa ntu vaitiva mwitanasa naatiara nriro. Haaru mwisa entaqi sara nre varuvaro mwi vaitiva Iesusiraqaa urovi vuntuvi variqaro Iesusira sapara hiro tiqaro, Ta vaitivave i nravutaasa iara tiva nianarove, tu vaitiva nri ntovaro ");
INSERT INTO omw_a_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pitaava mwira taqero mwirara Iesusira sapara hiro tiqaro, Nrorao, so mwaa vaitiva mo? Mwaa vaitiva nataave hianarove? tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Pitaava mwitaa tuvaro Iesusiva mwira tiva mwiro tiqaro, Ne mwirara tiqana, E qaqi variqira viraqena ne qaiqaa mwatani tuvuase, tiasera, mwira sia i saiqama vahianarove. E ni vataqira nriane, tiro. ");
INSERT INTO omw_a_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Iesusiva mwitaa tuvata mwira nraaqiaranravuvano mwi quara apiqama seta rieta mwisa mwitaama tita, Iesusiva tiqaro mwi vaitiva siama qutu vuanarove tiso, tura. Iesusiva sia mwitaa tiraitiro, mwiva tiqaro, Ne mwaa vaitirara tiqana e variqira viraqena ne mwatani tuvuase tiasera, ne mwirara mwitaa tiariva siama i saiqa vahianarove, tiro. Iesusiva mwitaa tura. ");
INSERT INTO omw_a_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","So mwi entara Iesusiva qua tiva mu vaitiva ne mwaa mwivave. Ne variqanama mwi inraisara mwi inraisara taqama sena mwiraqaataina mwaa quara qara ntuva taurave. Ne tu quava esaa mwi quava quqaa quama iso. ");
INSERT INTO omw_a_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesusiva varo saiqara ne hini vitiqaqai qara ntuva taurave. Esaa mwira saiqa kuaiqa kuaiqa qara ntuva taivera, airi vuku vahiro mwaa mwatara kuraama saanarove. So ne mwiqiarama tuqo. ");
ALTER TABLE omw_a_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
