﻿USE sofia;
DROP TABLE IF EXISTS sofia.omb_vpl;
CREATE TABLE omb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES omb_vpl WRITE;
INSERT INTO omb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Lo tavtevuigi redu Huqe Mauri u teu na taetae mena ureure. ");
INSERT INTO omb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Lolo taro ngehi a ureure u wegineu u eno vurogi ko a dodo u gagavugi nie siu a Vui noi Huqe Mauri mo hahale goro na nagoi wai hi. ");
INSERT INTO omb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Huqe Mauri mo veve vena, “Na leleo,” ko mo leleo. ");
INSERT INTO omb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Huqe Mauri mo lehe huri ve u garea siu mo wahe na leleo dena dodogi. ");
INSERT INTO omb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","I Huqe Mauri mo waregi na leleo a rani siu a dodo a bongi ko a revirevi mena robongi ngaha u teure lo muei reni. ");
INSERT INTO omb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","I Huqe Mauri mo veve vena, “Mwaile, siregi na wai tuegi na eno lo tano tuegi na eno aulu.” ");
INSERT INTO omb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Me i Huqe Mauri mo tau na mwaile mo vilewahe na waigai rue siu wai tuegi mo eno aulu dena wai mo eno lo vavagi. Siu mo eno mwere hi lo nona leo. ");
INSERT INTO omb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","I Huqe Mauri mo suri na henai mwaile a mahava mo revirevi mo bongi mo rani a rani tuegi. ");
INSERT INTO omb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","I Huqe Mauri mo veve vena, “Wai na vomai bubugi lo ute gategale siu tano mamaha ko maraga.” Siu mo eno ngere hi lo nona leo. ");
INSERT INTO omb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","I Huqe Mauri mo suri na henai tano mamaha a ureure siu a wai lawua a tahi, i Huqe Mauri mo lehe huri ve u garea. ");
INSERT INTO omb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","I Huqe Mauri mo veve vena, “Ureure, siregi na lalangai rivurivu doluegi ra mauri siu ngere rain mwasigi na huri na nora lalangai rivurivu doluegi mo mwasigi lolo tano lalangai rivurivu mo mwasigi aulu lo rangagi toligi lure.” Siu mo eno mwere hi lo nona leo. ");
INSERT INTO omb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","A tano mo lobu a gineu doluegi ram Huqe Mauri rivurivu ngere lolo tano, gai ram mwasigi doluegi mo huri na lalangagi mena nora mauriana. Siu Huqe Mauri mo lehe huri ve u garea. ");
INSERT INTO omb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Mo bongi mo rani a rani gaitoligi. ");
INSERT INTO omb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Siu i Huqe Mauri mo veve vena, “A leleo ko eno lolo mwaile mena ure ngaha. Mahava siu vin vilewahe na rani dena bongi, siu ngere rain voragi na gigilegi taro, a rani mena higao. ");
INSERT INTO omb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Siu ngere rain vuragi na leleo lawe na mwaile mena mahava ko vage lawe na ureure.” Siu mo eno mwerehi lo nona leo. ");
INSERT INTO omb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Huqe Mauri mo vai na leleo gairue tuegi lawuagi a matainaho mo leleo goro na rani, tuegi bitigi a vule mo leleo goro na bongi siu vage i Huqe Mauri mo tau na visiu. ");
INSERT INTO omb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Siu i Huqe Mauri mo taure lolo mahava rom bete na leleo lawe na ureure, ");
INSERT INTO omb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","siu a aho vin leogoro ra lalavasigi rain leleo lolo rani a vule vi leleo lolo bongi mo leogoro ra lavasigi, me mo wahegi na leleo dena dodogi, ko Huqe Mauri mo lehe huri ve u garea. ");
INSERT INTO omb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Mo bongi mo rani a rani gaivesigi. ");
INSERT INTO omb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Siu i Huqe Mauri mo veve vena, “Wai ko horo gena lalangai gineu doluegi ram mwaso lolo wai ko siu ngere ram olo lolo mahava lo ului ureure.” ");
INSERT INTO omb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","I Huqe Mauri mo tau na ige lalawua mena ige lalavasigi vage, gineu doluegi ram toga lolo tahi mena wai siu vage mo tau na lalangai manu ngere hi doluegi hi ram olo. Huqe Mauri mo lehe huri ve u garea. ");
INSERT INTO omb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Huqe Mauri mo vaigareagi nire mo veve vena, “Ige netum na sao siu nalulu lolo tahi siu gon horongi na tahi doluegi. Me ko siregi na gineu ram olo rain lulu lolo ureure.” ");
INSERT INTO omb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Mo bongi ko mo rani. Rani gailimegi. ");
INSERT INTO omb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Siu i Huqe Mauri mo veve vena, “Lo ureure ngaha a lalangai gineu mwaso doluegi mwere na gangarue mwaomwao ngere hi doluegi ram tanga, mena turugi.” Siu mo eno mwerehi lo nona leo. ");
INSERT INTO omb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Huqe Mauri mo tau na lalangai gangarue mwaomwao, turugi mena gangarue ram tanga lolo tano. Siu Huqe Mauri mo lehe huri ve u garea. ");
INSERT INTO omb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","I Huqe Mauri mo veve vena, “Ginde da vai na tangaloi dena nunude siboda, ngere rain mwerei ginde, rain leogoro na ige, gineu ram olo lolo mahava, gangarue rau mwaomwao, lolo ureure siu a gineu doluegi ram tanga lo nagoi ure, mena ure ngaha.” ");
INSERT INTO omb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","I Huqe Mauri teu na tangaloi dena nunune me mo tau na mwera mena vavine. Mo tau na mwera mena vavine. ");
INSERT INTO omb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Siu i Huqe Mauri mo vaigareagi nire mo veve lawera vena, “Renetumiru na sao lolo ureure neri leohuri na ureure, ige lolo tahi, goro na gineu ram olo lolo mahava mena gineu mwaso doluegi ram toga lo tano.” ");
INSERT INTO omb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Siu i Huqe Mauri mo veve vena, “Ko leo nam bete na toli rivurivu doluegi lo nagoi ure mena gai ngere hi a toligi lure. Ngere rain vuragi na gamiru hinaga. ");
INSERT INTO omb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Siu Nam bete na songo doluegi vi vuragi hinaga lawera hi, dena tangaloi a gineu mwaso doluegi ngere hi ram dige lo tano.” Siu mo eno mwere hi lo nona leo. ");
INSERT INTO omb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Siu i Huqe Mauri mo lehi na gineu doluegi u veire move “Wo! U garea hogo.” Siu mo revirevi mo bongi mo rani a rani gaionogi. ");
INSERT INTO omb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Siu taetae mena ureure ru dolue mena gineu doluegi ram eno lo tanogi. ");
INSERT INTO omb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Huri Huqe Mauri mo lehi na nona tabanagi doluegi rau dolue, siu nge mo manga dena nona tabanagi doluegi u veire lo rani gaibitu. ");
INSERT INTO omb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Huqe Mauri mo vaigareagi na rani gaibitugi me mo tauwahea mo vuragi na rani gogona huri lo rani hi nge u manga dein na nona tabanai tauteu lolo ureure. ");
INSERT INTO omb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ngere ngaha a valuhuri na taro tavohe taetae mena ureure rom vaiana. Huqe Gogona lo taro hi mo vaire mo vai na ureure mena taetae. ");
INSERT INTO omb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Lo taro hi labute hate mosigei lolo ureure me a songo qaroqaro rain tubu te mosigei huri Huqe Gogona vi qui na uhe te mosigei lolo ureure, me a tangaloi hatie vena rivurivu lolo tano. ");
INSERT INTO omb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","A matamata mo mwalue dena tano mo horongi na tano mo vui na ului tano doluegi. ");
INSERT INTO omb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","I Huqe Gogona mo bolo Tevue dena qiei tano. Siu mo mabugi na mabuhine ta lolo qanona nge mo vuragi na tangaloi. ");
INSERT INTO omb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Huqe Gogona mo rivu na talu lolo vanue Iden, lo matainaho mo kalo mo tau Tevue lolo talu. ");
INSERT INTO omb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","I Huqe Gogona, mo vai na gai ram mauri dena tano, a gai doluegi dam lehire rau garea siu rau garea mena hinaga. A gai mwasoana radu, siu a gai lolo rani garea mena asigi rom labe lo livugei talu. ");
INSERT INTO omb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A wai meuri mo mwalue dena Iden mo vagalobugi na talu mo maraga taie mo mahanga gaivesi. ");
INSERT INTO omb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mahangagi gategale i Bison, mo hale lolo vanue Havila taie hi vatu homu mo eno. ");
INSERT INTO omb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","A vatu homu lolo tano hi u garea lawuagi, mena bedola a bonagi vavangahi, mena vatu maeto. ");
INSERT INTO omb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Mahangagi wai meuri tuegi i Gihon. Mo hale lolo vanue Kus. ");
INSERT INTO omb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Henai wai meuri gaitoligi Taegris. Mo hale suvohi Asaria mo hivo lo matai naho mo kalo. A gaivesigi a henana i Iveretis. ");
INSERT INTO omb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","I Huqe Gogona mo lai Tevue mo taue lolo talu Iden hurivena Tevue na tabana taie siu mo leogoro na talu. ");
INSERT INTO omb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","I Huqe Gogona mo veve lawe Tevue, “Dena gai doluegi goin geni lei. ");
INSERT INTO omb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Nge, a gai lolo rani garea mena asigi goin mese ganie huri lo rani gom ganie niko goin mate.” ");
INSERT INTO omb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Vunu i Huqe Gogona mo veve vena, “Hi garea teve i Tevue vin toga gahea neu nain teu na buluine garea hurie.” ");
INSERT INTO omb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Siu i Huqe Gogona mo vai na gangarue doluegi dena tano, gineu ram olo lolo mahava, siu mo laire lawe Tevue huri ve nge na suri na henara. Me a hava hea mo suri talure mo vuragi henara. ");
INSERT INTO omb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","I Tevue mo bete na henai gangarue mwaomwao siu a gineu ram olo lolo mahava, a gineu mwaso doluegi lolo talu, nge lawe na tangaloi a henana i Tevue a Huqe Gogona vi haqe na tavalune tea. ");
INSERT INTO omb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Siu i Huqe Gogona mo vai Tevue mo maturu mate, me tavohe mo maturu, i Huqe Gogona mo lai na gagaune siu mo bulutegi na tarabehine taligu. ");
INSERT INTO omb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","I Huqe Gogona mo lai na gagaui Tevue mo boloe mo vuragi na vavine, me mo laie mo betea lawe Tevue. ");
INSERT INTO omb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","I Tevue mo veve vena, “Mobei, ngehi! Nge ngaha a hui dena hui gu vihigo dena vihigogu henana vin vuragi vavine huri ba u vomai dena mwera.” ");
INSERT INTO omb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Siu mo vai a mwera vin siregi tamana tona retahine mo bulu mei gahorana rom voragi tarabesi gategale. ");
INSERT INTO omb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ngere vunu rom tuvurogi Tevue mei tubui lo valena, siu rohi maemae tea. ");
INSERT INTO omb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nge i mwata u geligeli garagara dena gangarue doluegi hi Huqe Gogona u teure, mwata mo veve lawe na vavine, “?A hogo huri ve i Huqe Mauri u suri goro gani mwasi gai ram labe lolo talu?” ");
INSERT INTO omb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","I vavine mo duvie move, “Gamaru gori geni lei na mwasi gei lolo talu, ");
INSERT INTO omb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Nge Huqe Mauri u veve huri ve, ‘Neri mese gani na mwasi gei mo labe lolo livugei talu siu goin mese sikelie mwere goin mate.’” ");
INSERT INTO omb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nge i mwata mo veve lawe Vavine move “Hateve goin mate, goin mate telai. ");
INSERT INTO omb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ba i Huqe Mauri u ilo huri ve lo taro gom ganie a matamu vin leleo siu goin mwerei Huqe Mauri, siu niko goin ilo na gareagi dena asigi.” ");
INSERT INTO omb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","I vavine mo lehe huri ve u tatarise mena hinaga siu vavine mo lehe garea lo matana, mo lehe garea, huri ve vi bete na lolo rani lawea mo maraga mo lai na mwasi gei hi mo ganie. Siu tavohe rom tibubugi tona tamai netune mo bete lawea vage mo ganie. ");
INSERT INTO omb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Romo ganie na mwasi gei hi mo rovo matara mo leleo rom leo haqea huri ve rom ti vurogi, rom vatu na tutu gatogato rom barigi nire ginie. ");
INSERT INTO omb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Lo tagugi rom rongo na Huqe Gogona mo dige domidomi mo vano vomai lolo talu tavohe a aho mo madamada. Tevue ton tubui lo valena rom maraga rom hili lolo gai lolo talu dena nagoi Huqe Gogona. ");
INSERT INTO omb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","I Huqe Gogona mo ware Tevue move, “?Niko logo?” ");
INSERT INTO omb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","I Tevue mo duvie move, “Nau rongogo lolo talu nge nam matagu ba nam ti vurogi siu nam hili.” ");
INSERT INTO omb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","I Huqe Gogona mo gato lawea mo veve vena, “?I hine mo veve lawego huri ve nere mo ti vurogi? ?I niko gu geni na mwasi gei nau surigo huri ve goin mese ganie?” ");
INSERT INTO omb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","I Tevue mo veve vena, “Vavine gu betea laweau, nge u bete na mwasigi lavasigi laweau nam ganie.” ");
INSERT INTO omb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","I Huqe Gogona move, “?Vavine, gu vei na havagi?” I vavine mo veve vena, “A mwata u gelieu tau nam ganie.” ");
INSERT INTO omb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","A Huqe Gogona mo veve lawe na mwata, “Ba huri gu vei na gineu hi niko goin toga lo vavai arahiana vin liu dena gangarue mena gineu mwaso doluegi, ko siu i niko goin sure lategi gena taqangimu lolo tano siu goin geni na qie vi hate na duvigi. ");
INSERT INTO omb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nain vei gimiru neri bulubulu esi mei gimiru siu i renetumiru rain bulubulu esi meire vage, netui Vavine vin darawaga na qatumu siu niko goin gesi na qalagena.” ");
INSERT INTO omb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Siu mo veve lawe vavine, “Neu nain vagalawuagi na gagaras lawego lo taro goin hankovi netum siu lo gagarasi hi niko gobei hankovi netumu. Lo nom gagarasi hi niko goin geluvegi tamainetumu tea siu nge vi leogorogo.” ");
INSERT INTO omb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","I Huqe Gogona mo gato lawe Tevue move, “Ba huri gu rorongtagi gahoramu gom gani na mwasi gei hi nau veve huri ve goi mese ganilune, a tano mo eno lo arahiana huri na nomu vagasile, lo gagarasi niko goin gagani vin dadari lune gom mate. ");
INSERT INTO omb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Lolo tano vin tubu garo ginegine, siu rau ginegine lawego, goin geni na rivurivu esi lolo numwe. ");
INSERT INTO omb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Siu goin raratongi gom gagani, vi dadari lune gom hivo lolo tano dein na havai gu vomai denie. Huri niko a tano siu gom mule taligu hivo lolo tano.” ");
INSERT INTO omb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","I Tevue mo suri na henai gahorana Wesue huri ngeie a retahi tangaloi mwaso doluegi. ");
INSERT INTO omb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","I Huqe Gogona mo vai na luqe dena vinui gangarue mo vuragi luqei Tevue tona Wesue ko mo luqegi nire. ");
INSERT INTO omb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","I Huqe Gogona mo veve vena, “Gom lehe huri ve a Tangaloi mo mwerei ginde mo ilo na gareagi dena asigi siu nge vin mese hahaga huri ve na lai na mwasi gai mwasoana radu ve na ganie nge na mwaso radu.” ");
INSERT INTO omb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","I Huqe Gogona mo hora Tevue dena talu lolo Iden siu huri ve nge na tabana lolo tano ngehi u vomai denie. ");
INSERT INTO omb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mo godo vohogi Tevue siu mo tau na Lenao sao lo duvine talu lolo Iden lune matenaho mo galo mena buei vuro avi mo gao lune siu a bue hi mo iriiri goro na turegi mo vano lo gai mwasoana radu. ");
INSERT INTO omb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","I Tevue mo maturugi gahorana Wesue mo tinogi na maresu mo bamba Ken, Wesue mo veve vena, “I Huqe u bului eu, neu nau bulusi na tangaloi a mwera.” ");
INSERT INTO omb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Taligu mo bamba netune tuegi a henana i Ebol, Ebol a tangaloi leogoro sibsib i Ken nge a tangaloi ririvue. ");
INSERT INTO omb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Lolo taro matue i Ken mo wali na bulana mwasi rivurivu mo voragi na nona hogogo lawe na Huqe. ");
INSERT INTO omb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","I Ebol vage mo wali na totogai bulana sibsib rau damoe. Siu Huqe mo havuhevugi Ebol mena nona hure bonboni. ");
INSERT INTO omb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Nge i Huqe Mauri vi hevuhevu te mei Ken mena nona hure bonboni. Mo vai i Ken mero mo romasi. ");
INSERT INTO omb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","I Huqe mo veve lawe Ken, “?Huri havagi gom mero siu gom romasi huri na havagi? ");
INSERT INTO omb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tareve a doridori mu garea nain rongarea i niko nge tareve doridori mu hi garea tea, me a landomu mo eno lo gineu esi, a asiana mo raraigo lo turegimu, mo rarai ve na laigo nge niko hogosie goin qaragi nie.” ");
INSERT INTO omb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","I Ken mo veve lawe tuana Ebol, “Doro vano lolo talu.” Lo taro ngere lolo talu i Ken mo maraga mo ue vagamate Ebol. ");
INSERT INTO omb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","I Huqe mo veve lawe Ken, “?Tuem Ebol nge logo?” Ken mo duvie move, “?Nahi iloe tea? ?Huri ve neu nam leogoro tuegu?” ");
INSERT INTO omb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Huqe mo veve move, “?Gu vei na havagi? A diloi dai tuemu mo ngara lolo tano. ");
INSERT INTO omb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Siserigi ngaha gom toga lo vavai arahiana dena tano hilogo nge mo wawanga huri ve na lai na dai tuemu dena limemu. ");
INSERT INTO omb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tavohe goin tabana lo tano vin he bete na mwasi ririvue garea tea lawego niko, goin toga te surigi siu goin vuragi na tangaloi dige radu lo ure.” ");
INSERT INTO omb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ken mo veve lawe na Huqe, “Noku vevegiana u lawualawuagi huri ve nain weli leie. ");
INSERT INTO omb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Bagataha gom lai vohogi eu dena vanue siu goin lehi eu tea siu neu nain tuduviduvi lo ure siu a hava tangaloi vin haqe au vin ue vagamateau.” ");
INSERT INTO omb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","A Huqe mo veve lawe Ken move, “Tareve mwere hi hine vin wehi Ken, vin toga lo vevegiana vin liue vagabitu.” I Huqe mo tau na gigilegi lui Ken, mo veve sere huri ve hava tangaloi vin haqea vin wehe tea. ");
INSERT INTO omb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Siu i Ken mo beragi dena nagoi Huqe mo toga lolo vanue Nod lo matai naho mo kalo Iden. ");
INSERT INTO omb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","I Ken mo maturu mei gaihorana mo tinogi na maresu mo bamba Enok, Ken mo tavuigi na vanue rege mo suri na henai netune Enok ta lune. ");
INSERT INTO omb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok mo bamba Irad. Irad mo bamba Mehusael. Mehusael mo bamba Metusael ko i Metusael mo bamba Lamek. ");
INSERT INTO omb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek mo lai gaihorana gairue. Tuegi henana Eda tuegi Sila. ");
INSERT INTO omb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","I Eda mo bamba Jabal nge meire rau toga lolo siusiu tomuegi redu huri ram leohuri na gangarue mwaomwao. ");
INSERT INTO omb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabal tuana i Jubal. Ngeie meire a tangaloi tomuegi redu rau uvi na bue warue me ram geri buegerigeri. ");
INSERT INTO omb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila vage mo bamba netune Tubal Ken mo vai me mo vanga na aean mena a brons. Haqei Tubal Ken Nama. ");
INSERT INTO omb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek mo veve lawe tubui lo valena gairue, “Eda tona Sila, nero rorongtagi nero ronghuri na noku leo; nau wehi na tangaloi huri u vagasaburugi eu me nau wehi na mwalakelo huri u vei eu nau gagarugi na daigu. ");
INSERT INTO omb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Tareve tangaloi vi wehi Ken tangaloi gaibitu rain mate, nge Lamek tareve tangaloi vi wehe a tangaloi ngavulu geibitu domwagi gaibitu rain mate hurie.” ");
INSERT INTO omb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Tevue mo maturu mei gahorana Wesue mo bamba na me maresu mo suri na henana Set siu mo veve, “I Huqe Mauri u hogogi na maresu taligu gaisesei Ebol, lo tagugi i Ken uwehi vagamatea.” ");
INSERT INTO omb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","A maresu mwera vage mo vora lawe Set me mo suri na henana i Enos. Lo taro hi tangaloi ram tavuigi ram ware gareagi na henai Huqe. ");
INSERT INTO omb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Nge ngaha a valuhuri na tangaloi lo havahava lui Tevue. Tavohe i Huqe Mauri u bolo na tangaloi u veie gena nunune sibona. ");
INSERT INTO omb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Huqe Mauri u teu na mwera mena vavine ko mo vai tabetabegi nire me siu mo wareginire, a tangaloi. ");
INSERT INTO omb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Lo tarogi i Tevue higaona vudolue avigi ngavulu geitolu mo bamba na maresu mwera hi a nunune sibona, nge mwera hi tamana henana i Set. ");
INSERT INTO omb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set u vora siu Tevue u toga higao vudolue vagawelu. Lolo taro hi mo bamba na maresu mwera me vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Doluegi Tevue u toga higao vudolue vagasiwo avigi ngavulu gaitolu siu mo mate. ");
INSERT INTO omb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","I Set mo toga higao vudolue avigi gailime mo bamba Enos. ");
INSERT INTO omb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Lo tagugi i Set mo bamba Enos, i Set u toga higao vudolue vagawelu avigi gaibitu. Lolo taro hi mo bamba netune ira mwera ko a vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Doluegi Set higaona vudolue vagasiwo avigi hangavulu domwagi gairue siu mo mate. ");
INSERT INTO omb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","I Enos u toga higao ngavulu geisiwo mo bamba Kenan. ");
INSERT INTO omb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","I Enos lo tagugi u bamba Kenan u toga taligu higao vudolue vagawelu avigi hangavulu domwagi gailime. Lolo taro hi siu mo bambara taligu maresu mwera mena vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Doluegi Enos mo toga higao vudolue vagasiwo avigi gailime siu mo mate. ");
INSERT INTO omb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan mo toga higao ngavulugeibitu mo bamba Mahalalel. ");
INSERT INTO omb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Lo tagugi i Kenan u bamba Mahalalel toga taligu higao vudolue vagawelu avigi ngavulu geivesi. Lolo taro hi mo bamba na maresu mwera mena maresu vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Doluegi Kenan u toga higao vudolue vaga siwo avigi hangavulu siu mo mate. ");
INSERT INTO omb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel higaona mo ngavulu geiono domwagi gailime mo bamba Jared. ");
INSERT INTO omb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel mo bamba Jared siu u toga higao vudolue vagawelu avigi ngavulu geitolu. Lolo taro hi siu mo bamba na maresu mwera me maresu vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Doluegi Mahalalel u toga higaogi vudolue vagawelu avigi ngavulu geisiwo domwagi gailime siu mo mate. ");
INSERT INTO omb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","I Jared u toga higao vudolue avigi ngavulugeiono domwagi gairue mo bamba Enok. ");
INSERT INTO omb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","I Jared u bamba Enok siu u toga higao vudolue vagawelu. Lolo taro hi siu mo bamba na maresu mwera me vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Doluegi Jared u toga higao vudolue vaga siwo avigi ngavulu geiono domwagi gairue siu mo mate. ");
INSERT INTO omb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok u toga higao ngavulugeiono domwagi gailime mo bamba Metusela. ");
INSERT INTO omb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Huqe Mauri nge u dige lategi mei Enok higao vudolue vagatolu siu lo tagugi mo bamba Metusela. Lolo taro hi u bamba na maresu mwera me maresu vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Doluegi Enok toga higao vudolue vagatolu avigi ngavulu geiono domwagi gailime. ");
INSERT INTO omb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok u dige mei Huqe Mauri siu he toga teve na qaravu nge mo hatie huri. Huqe Mauri u lei vohoginie. ");
INSERT INTO omb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","I Metusela u toga higao vudolue avigi ngavulugei welu domwagi gaibitu mo bamba Lamek. ");
INSERT INTO omb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lo tagugi Metusela mo bamba Lamek. Lolo taro hi u toga higao vudolue vagabitu avigi ngavulu gaiwelu domwagi gairue. Mo bamba na maresu mwera mena maresu vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Doluegi Metusela u toga higao vudolue vagasiwo avigi ngavulu geiono domwagi gaisiwo siu mo mate. ");
INSERT INTO omb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek u toga higao vudolue vagategale avigi ngavulugei welu domwagi gairue, mo bamba netune mwera gategale. ");
INSERT INTO omb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Mo suri na henana i Noa mo veve vena, “Nge ngaha vin vei masurigi ginde dena tabana gagarasi, dena limada, dena tano hilogo a arahiana a Huqe uteu.” ");
INSERT INTO omb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lo tagugi Lamek mo bamba Noa, nge u toga taligu higao vudolue vagalime avigi ngavulu geisiwo domwagi gailime. Lolo taro hi mo bamba na maresu mwera me vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Doluegi Lamek u toga higao vudolue vaga bitu avigi ngavulu geibitu domwagi gaibitu siu mo mate. ");
INSERT INTO omb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa higaona vudolue vagalime siu mo bamba Sem, Ham me i Savet. ");
INSERT INTO omb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Tavohe a tangaloi mo sao lo ure lehe, a maresu vavine ram vora lawera, ");
INSERT INTO omb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","renetui Huqe Mauri ram leo huri ve a vavine netui tangaloi ngere hi rau garea liu, me ngere ram lagi meire, ngere ram vilegi denire haro. ");
INSERT INTO omb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Siu a Huqe mo veve vena, “Nongu tanumwe vinhe toga tea me tangaloi vin mwaso radu nge vin mate nona rani vin toga higao vudolue avigi ngavulu geirue.” ");
INSERT INTO omb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tavohe renetui Huqe Mauri ram vano lobe na maresu vavine neture tangaloi me ram hango maresu lawera, me ngere tangaloi rau huire garagara. Ngere a Tangaloi roroa ira Nevilim. Lolo ureure lo taro hi, siu lo tagugi vage. ");
INSERT INTO omb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Huqe mo lehi na asiana lalawua nora tangaloi lolo ureure lehe mo vaiana, siu a tangaloi nora ladolado asi hogosie lo taro hi. ");
INSERT INTO omb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Huqe mo hahagavi huri ngeie u vei na tangaloi lo ureure lehe me a lolona u horo gena romasi. ");
INSERT INTO omb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","A Huqe mo veve vena, “Neu nain hora vohogi na tangaloi hi nau vei lo nagoi ure tangaloi me gangarue, mena gineu hi ram tanga lo ului tano, me gineu doluegi ram olo lo mahava ba huri nam hahagavi huri ba i neu nanau veire.” ");
INSERT INTO omb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nge maraga i Huqe leogareagi Noa. ");
INSERT INTO omb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Lune hi a valuhuri Noa nge a tangaloi vovohoi tangaloi hateve ram veveginie lo taro hi, me nge mo dige mei Huqe Mauri. ");
INSERT INTO omb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa bamba na maresu mwera gaitolu, Sem, Ham mei Savet. ");
INSERT INTO omb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Lolo taro nge ngaha ure he vovohoi tea lo nagoi Huqe Mauri me u horo kena vuro. ");
INSERT INTO omb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Huqe Mauri mo lehi na ure he vovohoi tea huri a tangaloi lo ure doridori ne rau hesi garagara. ");
INSERT INTO omb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Siu Huqe Mauri mo veve lawe Noa, “Neu nain vei vohogi na gineu mwaso doluegi huri a ureure u horo gena vuro huri hi neu nain vai vohogi nire mena ureure. ");
INSERT INTO omb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Siu gon vai na nom akai toavaravara gena gai nanara, goin wahe na lologi goin bulu goro na lologi me tavala varea gena gineu bubulugi. ");
INSERT INTO omb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Goin bulu na akai toavaravara mwere a gwaravugi sugu vudolue vagatolu, lawuagi sugu ngavulu gailime, ulugi sugu ngavulu gaitolu. ");
INSERT INTO omb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Goin veie vin rovo goin vei na vulugi sugu gategale. Siu vin wawanga goin vei na matai turegigi lo mwararai akai toavaravara lo gai bibile lo lalangagi vuine, lo livugegi me gaitoligi lo ulugi. ");
INSERT INTO omb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Neu nain vei na waga vin wehi na gineu mwaso doluegi lo vavai taetae. Vataha na gineu mwaso ngere mabuhire lure lolo ureure rain mate. ");
INSERT INTO omb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Neu nain teu na noku waratau siaga me niko goin vano sulolo akai toavaravara, mei tubui lo valemu, renetumu mwera mei tubui lo valera. ");
INSERT INTO omb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Goin teu ta lolo akai toavaravara gineu mwaso doluegi mweragi mena vavinegi huri rain mwaso mei go: ");
INSERT INTO omb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","gineu doluegi ram olo gairue mo huri na lalangagi, lalangai gangarue doluegi ngere hi ram gilu lategi lo tano rain vomai lobemu huri goin teure rain mwaso. ");
INSERT INTO omb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Niko goin lei na lalangai hinaga ngere hi rain geni, me ngere hi rain teu vurugegi Huri go me huri re.” ");
INSERT INTO omb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa u vei na gineu doluegi mwere hi a Huqe Mauri u vevea lawea. ");
INSERT INTO omb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Siu i Huqe mo veve lawe Noa vena, “Siserigi ngaha niko mei renetumu, tubui lo valemu mei tubui lo valei renetumu nein ehu lolo akai toavaravara huri niko hogosie tangaloi vovohoi lo nagogu dena karumu. ");
INSERT INTO omb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Goin lei mei go vataha gangarue rau mwasara hogo gaibitu mweragi vavinegi. Me dena gangarue rain mwasara tea mweragi gategale me vavinegi gategale. ");
INSERT INTO omb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Vage hogo gaibitu dena gineu doluegi ram olo tau lo mahava mweragi vavinegi huri vin lulu taligu lolo ureure. ");
INSERT INTO omb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Lo tagui rani gaibitu vage nain bete na uhe lo ure huri na rani ngavulu geivesi bongi ngavulu geivesi, me nain uevuhogi na gineu mwaso lo ului tano doluegi ngere hi nau teu.” ");
INSERT INTO omb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noa uvei na gineu doluegi mwerehi i Huqe u veve lawea. ");
INSERT INTO omb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa higaona vudolue vaga ono lo taroi waga. ");
INSERT INTO omb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Siu i Noa mei renetune, tubui lo valena mei tubui lo valei renetune rau ehu lolo akai toavaravara huri na waga vin lawua. ");
INSERT INTO omb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","A gangarue rau mwasara mei ngere rain mwasara tea lo nagona, gineu doluegi ram olo, mena gangarue ram toga lo tano, ");
INSERT INTO omb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","gairue gairue rau ehu mei Noa lolo akai toavaravara, mwera mena vavine mwere hi Huqe Mauri u veve lawe Noa. ");
INSERT INTO omb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Lo tagui rani gaibitu wai waga mo tavuigi mo luluvi na ureure. ");
INSERT INTO omb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa higaona vudolue vaga ono lo vule tuegi lo rani hangavulu domwagi gaibitugi walui wai meuri lolo buloi tano ram wawanga doluegi me matai wai lo mahava ram wawanga. ");
INSERT INTO omb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Uhe u eno lolo ureure rani ngavulu gaivesi bongi ngavulu gaivesi. ");
INSERT INTO omb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tavohe lo ranigi hi mosigei Noa mei horana mei netune Sem, Ham, Savet mei horara rau ehu lolo akai toavaravara. ");
INSERT INTO omb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Me lalangai gangarue ta lolo ureure rau ehu lolo aka lalangai gangarue mwaomwaogi, lalangai gangarue turugi, lalawuagi mena wuwerigi vohogi, mena lalangai gineu doluegi ram olo rau ehu lolo akai toavaravara. ");
INSERT INTO omb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Gineu mwaso doluegi lolo ureure gairue gairue mweragi vavinegi rau ehu mei Noa lolo akai toavaravara. ");
INSERT INTO omb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Me lo taro ngere mweragi mena vavinegi doluegi rau ehu lolo akai toavaravara u rovo, mwere hi Huqe Mauri u veve. I Huqe Gogona mo gorogoro na matai turegi. ");
INSERT INTO omb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Siu a waga u eno lo ureure rani ngavulu geivesi, wai u horo mo lawua mo raka na akai toavaravara taulu mo tabe na akai toavaravara mo maraga dena ului tano. ");
INSERT INTO omb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Wai mo horo mo lawua mo lawua vohogi lo ului tano nge aka mo halehale lo ului wai. ");
INSERT INTO omb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Me ram maraga mo lawua lo ureure ram lawua vohogi lo ure mo luluvi na vusi doluegi aulu lo vavai mahava. ");
INSERT INTO omb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Wai mo maraga mo selega vohogi mo gagavugi na vusi buegi aulu mo dadari vine sugu hangavulu domwagi gailime. ");
INSERT INTO omb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Gineu mwaso doluegi lo tano, gineu doluegi ram olo, gangarue turugi mena gutui tano, ngere ram toga mena tangaloi doluegi rau mate. ");
INSERT INTO omb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ngere doluegi mabuhire ram mabu lolo qangora me ngere lo tano mamaha rau mate. ");
INSERT INTO omb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Siu i Huqe Mauri u vei vohogi na gineu doluegi rau toga lo ului tano bubugi tangaloi mena gangarue ngere ram toga mena gineu doluegi ram olo lo mawe rau mate den ureure. Noa mei renetune, me gangarue lolo akai toavaravara hogosie rau mwaso. ");
INSERT INTO omb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","A waga u horo rorongo goro na ureure a rani vudolue avigi ngavulu gailime. ");
INSERT INTO omb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Huqe Mauri u lado Noa mosigei mena gangarue mwaomwao ko a gineu dolue meie lolo akai toavaravara me i Huqe Mauri mo hora na langi mo here lo ului ureure me mo vi na wai ram qega. ");
INSERT INTO omb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Me tomuegi mo soso goro, na matai wai lolo tano huri na wai vin mese mwalue, me mo soso goro na uhe lolo mahava. ");
INSERT INTO omb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Me a wai mo qega mo hivo rorongo taligu. Lo taro hi rani vudolue avigi ngavulu gailime wai mo qega rorongo. ");
INSERT INTO omb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Me lo vule gaibitugi, lo rani hangavulu domwagi gaibitu, a akai toavaravara lawua mo saga lo ului vusi Ararat. ");
INSERT INTO omb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Me a wai u qega rorongo u dadari lo vule hangavulugi lo muei rani lo vule ngehi vusi ram maraga taligu. ");
INSERT INTO omb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Lo tagui rani ngavulu gaivesi, i Noa u langa na matai lengi lo akai toavaravara hi nge u bulue. ");
INSERT INTO omb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Me mo hora tavarea a manu lawua a weu me mo vano mo hi tudori tea, dadari wai mo mamaha lo ureure. ");
INSERT INTO omb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","9","Siu mo hora na mwaragi den akai toavaravara ve na leo huri ve a wai u rovo dena ului tano nge a mwaragi he hue na gineu tea ve na toga lune huri a wai mo horo radu me mo tudori lo akai toavaravara. Noa mo batoragi na limana lo matai lengi me manu mo toga lune mo laie sulolo aka ");
INSERT INTO omb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Me mo rarai rani gaibitu me mo hora nam wara tavarea taligu dena aka toavaravara. ");
INSERT INTO omb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Me lolo revirevi a mwara hi mo vomai taligu lobena. Wou! Mo wali na raui gai qaro oliv lolo wawana, me i Noa mo ilo huri ve a wai mo kakarani mo qega dena ureure. ");
INSERT INTO omb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","I nge urarai rani gaibitu taligu, me mo siregi na mwaragi tavarea taligu nge mwaragi hi mule tea lobena taligu. ");
INSERT INTO omb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Siu lo higao ngehi i Noa higaona vudolue vaga ono domwagi gategale lo muei vule lo muei rani lo vule hi wai u mamaha vurugegi. Noa mo roa na langa ului akai toavaravara me mo leo a tano u mamaha beno. ");
INSERT INTO omb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Me lo vule tuegi lo higao ngehi, lo rani ngavulugeirue domwai gaibitugi, tano u mamaha vurugegi. ");
INSERT INTO omb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Huqe Mauri mo gato lawe Noa vena, ");
INSERT INTO omb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Noa ko mwalue den aka, niko mei horamu mei renetumu mei horara. ");
INSERT INTO omb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Goin lei vohogi na gangarue mwaso mei go gineu doluegi ram olo, gangarue me ngere ram taga lo tano huri rain sao rain vehuhu rain sao vin lulu lo tano.” ");
INSERT INTO omb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noa mo mwalue mei horana, renetune me mei horai renetune. ");
INSERT INTO omb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Me vataha na gineu rau toga mei Noa lolo akai toavaravara rau mwelue, vataha gangarue lalangai gineu doluegi ram olo, mena lalangai gineu ram tanga, ram mwalue den akai toavaravara mo huri na lalangai nora burigi. ");
INSERT INTO omb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noa mo vonda na vatu vuragi na vonda gogona lawe Huqe huri na nona hure bonboni me mo lai na gangarue mena manu rau mwasara mo hure bonboni ginire. U lei gategale den vataha gangarue mo wehire mo hurara ram gao doluegi lo vonda gogona mo vuragi na nona vevegarea lawe na Huqe. ");
INSERT INTO omb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Me lo tagugi Huqe mo rongo na bonagi mo rongarea ginie lawuagi, siu mo domigi nie, “Nain mese arahi na ureure taligu hate huri a tangaloi a domire u esi tavohe rau maresuge me tavohe rau tamaragai beno. Huri na tangaloi, neu nain mese wehi na gineu mwaso mwere hi taligu. ");
INSERT INTO omb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Siserigi ngaha lo ureure ngaha taroi rivu talu, me taroi lai hinaga matue dena vuigi. Taroi gamwadidi, me taroi mwamwavi, taroi rara, me taroi udu, taroi rani, me taroi bongi me gineu doluegi ngere ngaha rain mese sala vin dadari a ureure vin rovo.” ");
INSERT INTO omb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Huqe Mauri mo vai tabetabegi Noa mei renetune, me nge mo veve lawera move, “Nein bamba na maresu vin sao huri nein horo lolo ureure. ");
INSERT INTO omb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","A gangarue doluegi ram dige garu gaivesi mena lalangai manu ram olo, ngere ram taga lo tano me ige rain matagugi gimiu. Gineu ngere ngaha doluegi ram toga lo qaqai lime miu. ");
INSERT INTO omb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Neu nam bete na gangarue lawe gimiu, gineu mwasogi vin voragi hinaga lawe gimiu mwere na gogotoa mena ririvue ngere nau betera lawe gimiu tomue. ");
INSERT INTO omb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Hate huri nge tareve tarabehi mena nona mwasoana mena daine mo eno tau nein mese gani na gangarue hi. ");
INSERT INTO omb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Hate huri nge tareve a gangarue vin wehi na tangaloi, vin mate neu nain wehe vin mate. Siu tareve a tangaloi mo wehi tuana neu nain wehe vin mate vage. ");
INSERT INTO omb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tareve hine mo vai na dain tangaloi mo hale mo mate, a tangaloi dolue vin ve na daine vin hale mo mate; huri lo nunui Huqe Mauri nge u vei na Tangaloi. ");
INSERT INTO omb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Me niko, ko mwasigi na sao huri goin lumuhi na ureure me goin lulu lune.” ");
INSERT INTO omb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Siu Huqe Mauri mo veve lawe Noa mei renetune ram ti meie. ");
INSERT INTO omb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Neu hingaha nam rarai ven nain teu na noku waratau siaga mei ko me mei renetumu lo tagumu vage. ");
INSERT INTO omb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Me vatavataha na gineu mwaso ngere hilogo ram ti mei go, a gineu doluegi ram olo, a gangarue mwaomwao me lalangai gangarue turu, ngere rau mwelue dena akai toavaravara mei go, me vage a lalangai gangarue lolo ure. ");
INSERT INTO omb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Me neu nain membu na noku waratau gogona siaga mei gimiu. Me mwasoana doluegi nain hi wehire tea gen wai taligu. Me a waga vin he ngahigi na ureure te taligu.” ");
INSERT INTO omb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Me i Huqe Mauri mo veve, “A gigilegi hingaha mena waratau siaga nain teue lo livugegu mei gimiu me mena vatavataha na gineu mwaso ngere ram ti mei gimiu me, lawe ra duvi miu ram vomai teu mosigei lolo taro mo vomai teu. ");
INSERT INTO omb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nau teu na noku hinmwehinmwe nain vei raraie lolo tainlengi ven na vuragi na gigilegi waratau siaga mena ureure. ");
INSERT INTO omb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tavohe nam lai na tainlengi sulo ului ureure me a hinmwehinmwe mo kalo lolo tainlengi, ");
INSERT INTO omb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","neu nain landobimbi na noku waratau siaga mo eno lo livugegu mei gimiu mena gineu mwaso doluegi huri ve vin hatie taligu a wai vin vuragi waga mo hale huri ve vin vei hasisigi na mwasoana doluegi. ");
INSERT INTO omb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Vataha tarogi a hinmwehinmwe mo mwalue lolo tainlengi neu nain lehe me nain landobimbi na waratau siaga ngehi vin tuei hate duvigi mei eu siu mena gineu mwaso doluegi.” ");
INSERT INTO omb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Siu I Huqe Mauri mo veve lawe Noa, move “Nge ngaha a gigilegi waratau siaga nau teue lo livuge miu me vatavataha na gineu mwaso lolo ureure.” ");
INSERT INTO omb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Renetui Noa ngere rau mwelue dena aka, i Sem, i Ham me i Savet. Siu i Ham nge i tamai Kenan. ");
INSERT INTO omb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","I Noa renetune ngere gaitolu doluegi me mo mawahewahe lolo ureure. ");
INSERT INTO omb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Siu Noa nge a tangaloi ririvue lolo tano mo maraga mo rivu na talui garoi inuinu. ");
INSERT INTO omb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Me nge mo maraga mo inu na wai garohi me inuinu hi mo vaie qatune mo dadaligi me nge mo lai vohogi na luqana lo livugei nona siusiu. ");
INSERT INTO omb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Siu Ham nge tamai Kenan mo leo hue na tarabehi tamana mo eno vurogi me nge mo vano mo vevea lawe retuana gairue rom ti varea. ");
INSERT INTO omb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Siu Sem tona Savet rom lai na luqe me rom taue lo siqara ngere vunu me rom dige gena tagure rom gagavugi na tarabehi tamara nge mo eno vurogi. Me ngere nagora mo leo sivarea den tamara siu ngere rohe lehi na tarabehi tamara tea mo eno vurogi. ");
INSERT INTO omb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noa mo maraga dena mena inuinu me nge mo ilo tabetabegi na havagi netune tahigi u veie lawea. ");
INSERT INTO omb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Me Noa move, “Arahiana vin huri Kenan me nge vin voragi na gaihora noi retuana.” ");
INSERT INTO omb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Me ngeie mo veve, “Tabeana lawe na Huqe Gogona noi Sem. Siu Kenan vin vuragi na nona gaihora. ");
INSERT INTO omb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Siu i Huqe Mauri vin tagaragi na tanoi Savet vin lawua me vin siregi nie vin toga lolo siusiu noi Sem. Siu vin toga lolo siusiu noi Sem me Kenan vin voragi nona gaihora.” ");
INSERT INTO omb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noa toga lo tagui waga higao vudolue vaga tolu avigi ngavulu gailime. ");
INSERT INTO omb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa u toga higao vudolue vagasiwo avigi ngavulu gailime vunu mobei mate. ");
INSERT INTO omb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nge ngaha a valuhuri renetui Noa i Sem, Ham siu Savet i ngere lo tagui waga rau bamba na maresu mwera vage. ");
INSERT INTO omb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","I renetui Savet a mwera i Gomer, Magog, Madai, Javen, Tubal Misek mei Tiras. ");
INSERT INTO omb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Renetui Gomer mwera i Askenas, Rivat, me i Togarma. ");
INSERT INTO omb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Renetui Javen mwera i Elisa, Tarsis, rehavai Kit mei rehavai Dodan. ");
INSERT INTO omb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Dena garogi hi a tangaloi lo bambai tahi rau magahegahe ram toga lolo tanora sibora vanue mo huri na bambagi mena leora me rau voragi taureure. ");
INSERT INTO omb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Renetui Ham mwera i Kus, rehavai Misra, But, mei Kenan. ");
INSERT INTO omb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Renetui Kus mwera i Seba, Havila, Sabta, Rama mei Sabteka siu i Rama i netune i Seba tona Didan. ");
INSERT INTO omb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","I Kus mo vuragi tamai Nimrod mo tavuigi mo vuragi tangaloi huire u toga lo ureure lehe. ");
INSERT INTO omb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ngeie a tangaloi huire mo muremure lo gotegote bigi lo vavai Huqe me a tangaloi ram mo veve huri ve, “Mwerei Nimrod a tangaloi huire u gilu garea siu u muremure lo gotegote bigi lo vavai Huqe.” ");
INSERT INTO omb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Lo tavtevuigi ngeie mo ratahigi goro lolo Babilon, Erek, Akad, mei Kalne, ram eno lolo vanue lawua waregi Sina. ");
INSERT INTO omb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Dena ute hi nge mo vano Asaria ko mo tavuigi mo ragasi na Niniva, Rehobot-Ir, Kalab ");
INSERT INTO omb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","mei Resen nge mo eno lo livugei Niniva tona Kalab a vanue rege, ");
INSERT INTO omb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","rehavai Misra nge i tamai rehavai Lud, rehavai Anam, rehavai Lehab, rehavai Nabutu, ");
INSERT INTO omb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","rehavai Batru, rehavai Kavto, rehavai Kaslu denirehi a rehavai Balistaen rau vomai. ");
INSERT INTO omb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenan i tamai Sidon netune togagi siu vage netune Het. ");
INSERT INTO omb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Siu i Kenan mo varagi tamai ngaraha ngere rehavai Jebus, rehavai Amor, rehavai Girgas, ");
INSERT INTO omb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ngere rehavai Hivi, rehavai Aki, siu ngere rehavai Sini, ");
INSERT INTO omb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ngere rehavai Arvad, rehavai Semari, rehavai Ham, lo tavugi a havahava lui Kenan rau magahegahe ram varagi vanue lalawua. ");
INSERT INTO omb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Dumui vanue Kenan mo maraga Sidon vano huri na vanue Gerar ko mo dadari Gasa siu mo vano mo dadari Sodom, Gomora, Adma me Seboim siu mo dadari Lasa. ");
INSERT INTO omb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ngere ngaha i renetui Ham mo huri na bambagi, a nora leora, tanora me ram vuragi na taureure. ");
INSERT INTO omb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","I Sem nge i togai Savet siu u bamba na maresu mwera rau sao me nge mo vuragi na qarerei rehavai Eba. ");
INSERT INTO omb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Renetui Sem i Elam, Asur, Avaksad, Lud mei Aram. ");
INSERT INTO omb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","I renetui Aram i Us, Hul, Geta, me i Mas. ");
INSERT INTO omb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Avaksad i tamai Sela me i Sela mo vuragi tamai Eba. ");
INSERT INTO omb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Maresu mwera gairue ru vora lawe Eba: gategale u suriana Belek huri lolo nona taro a ureure mawahewahe; tuana a henana i Joktan. ");
INSERT INTO omb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","I Joktan i tamai Almodad, Selev, Hasamavet, Sera. ");
INSERT INTO omb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO omb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba ");
INSERT INTO omb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Obir, Havila, mei Jobab. Ngere hi doluegi renetui Joktan. ");
INSERT INTO omb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","A mahugi rau toga lolona mo tavuigi lolo vusi Mese mo eno taie mo vano dadari Seva lo ute matai naho mo galo. ");
INSERT INTO omb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ngere ngaha i renetui Sem mo huri na bambagi, a nora leo, tanora me ram vuragi na taureure. ");
INSERT INTO omb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ngere ngaha a havahava lui renetui Noa mwera mo huri na garogi siu a lulugi lolo vanuara. Lo tagui waga mo luluvi na ureure tangaloi ram toga ram mawahewahe lolo ureure. ");
INSERT INTO omb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tomuegi ureure doluegi nora leo gategale me ram laqa gategale. ");
INSERT INTO omb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ngere ram mwalue dena tanora tautomue ram hivo vagi matenaho kalo ram haqe na ute tavola lolo vanue Babelonia me ram toga lune. ");
INSERT INTO omb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Siu ngere ram veve vena, “Ngaraha. Ne vomai, u garea ve da lai na tano damo dorie, dam hurae huri vin siaga mo vuragi vatu.” Ram vai na vatu mo sao me ram lai na wai kolta mo voragi na bulu. ");
INSERT INTO omb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Siu ngere ram veve vena, “Mai ginde dan bulu na vanue rege mena vale ulugi vi dadari lolo mahava, huri dain vei na henada vin lawua, siu vi vei ginde dain mese mawahewahe lolo ure.” ");
INSERT INTO omb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Nge i Huqe mo hivo mo lehi na vanuara mena vale tueulu lolo mahava ngere sinobu rau bulue. ");
INSERT INTO omb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Me Huqe mo veve vena, “Wo! Tangaloi gategale me leora gategale doluegi me ngaha nora tavuigi ve rain vei, siu havagineu ram lado huri ve rain vei vin veiana mwere hi ram lado. ");
INSERT INTO omb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mai, ginde da hivo vuine me da roigi na nora leo huri rain mese ronghuri na leo noi rehavara.” ");
INSERT INTO omb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Me i Huqe mo vile wahera tavuigi Aie me ngere doluegi lo ului tano lolo ureure me ram siregi rain bulu na vanue rege tea. ");
INSERT INTO omb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Siu tangaloi gategale mo maraga mo waregi na henai ute hi Babel, huri taie hi Huqe u roigi na leo doluegi na ureure, me tahi Huqe mo maraga mo wahera lo ului tano doluegi lolo ureure. ");
INSERT INTO omb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Nge ngaha a valuhuri Sem. Tavohe a higaona mo dadari vudolue vagategale, me nge mo bamba Avaksad. Ngelehe u veiana higao gairue lo tagui waga. ");
INSERT INTO omb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Me lo tagugi u bamba Avaksad Sem u toga higao vudolue vagalime me lolo taro hi mo bamba na maresu mwera mena vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Me i Avaksad toga higao ngavulu geitolu domwagi gailime me nge mo bamba Sela. ");
INSERT INTO omb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Vunu lo tagugi i Avaksad u bamba Sela, u toga higao vudolue vaga vesi avigi gaitolu me lolo taro hi mo bamba netune mwera mena vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","I Sela utoga higao ngavulu geitolu siu nge mo bamba Eba. ");
INSERT INTO omb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Lo tagugi nge u bamba Eba, Sela u toga higao vudolue vaga vesi avigi gaitolu me lolo taro hi mo bamba renetune mwera me vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eba u toga higao ngavulu geitolu domwagi gaivesi mo bamba Belek. ");
INSERT INTO omb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Me lo tagugi nge u bamba Belek, Eba toga higao vudolue vaga vesi avigi ngavulu geitolu me lolo taro hi mo bamba netune maresu mwera mena vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Me Belek u toga higao ngavulu geitolu, nge mo bamba Reu. ");
INSERT INTO omb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Lo tagugi nge u bamba Reu, Belek u toga higao vudolue vaga rue avigi gaisiwo me lolo taro hi mo bamba na maresu mwera mena vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu toga higao ngavulu geitolu domwagi gairue me mo bamba Seruk. ");
INSERT INTO omb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Me lo tagugi nge mo bamba Seruk, Reu u toga higao vudolue vaga rue avigi gaibitu me lolo taro hi mo bamba na maresu vage mwera mena vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Tavohe Seruk u toga higao ngavulu geitolu mo bamba Naho. ");
INSERT INTO omb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Lo tagugi Seruk u bamba Naho, nge u toga higao vudolue vaga rue me nge, lolo taro hi mo bamba netune vage mwera mena vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Tavohe Naho u toga higao ngavulu geirue domwagi gaisiwo nge mo bamba Tera. ");
INSERT INTO omb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Me lo tagui nge u bamba Tera, Naho u toga higao vudolue vaga tegale avigi hangavulu domwagi gaisiwo me lolo taro hi mo bamba na mwera vage mwera mena vavine rau sao. ");
INSERT INTO omb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Lo tagugi Tera u toga higao ngavulu gaibitu. Nge mo bamba Ebram, Naho mei Haran. ");
INSERT INTO omb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Nge ngaha a valuhuri Tera. Mo bamba Ebram, Naho mei Haran me i Haran mo bamba Lot. ");
INSERT INTO omb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tavohe Tera mo mwaso tau, i Haran mo mate lolo vanue rege Ur lolo tano tanora Kaldea nge u vora taie. ");
INSERT INTO omb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ebram tona Naho ngere vunu ru legi, A henai tubui lo valei Ebram i Serai, me a henai tubui lo valei Naho i Milka netui Haran; Milka mei Iska tamara i Haran. ");
INSERT INTO omb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ko siu Serai u bamba samwegi maresu teu; siu nge netune hatie. ");
INSERT INTO omb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera mo lai netune Ebram, vagabuine Lot netui Haran, vagabui qelige, Serai, me ram bubugi ram mwalue dena vanue rege Ur tanora Kaldea huri ve rain vano Kenan. Nge tavohe ram vomai Haran, ram toga taie. ");
INSERT INTO omb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Doluegi Tera u toga higao vudolue vagarue avigi gailime, me mo mate lolo vanue rege Haran. ");
INSERT INTO omb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Siu Huqe mo veve lawe Ebram, “Ko vano ko siregi na tanomu mei rehavamu me valei tamamu huri na vanue ngehi nain haharagi nie lawego. ");
INSERT INTO omb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nain vei rehavamu vin lawua me vin sao garagara, nain vei tabetabegi niko. Nain vei na henamu vin lawua, me niko goin voragi na gareana. ");
INSERT INTO omb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nain vei gareagi nire hi ram vaigareagi niko, ngehi mo tangaroagi asisigi niko, nain arahie, me a sinobu doluegi lo ure lehe gareana vin huri re duruhigo.” ");
INSERT INTO omb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Siu i Ebram mo vano mwere hi a Huqe mo horae. Lot mo hurie ram vano bulu. I Ebram a higaona ngavulu geibitu domwagi gailime tavohe nge mo mwalue dena vanue Haran. ");
INSERT INTO omb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Siu aie Ebram mo lai gaihorana Serai mei Lot netui tuana nora vivilangogi doluegi ngere hi rau teu bubugi nire mena tangaloi ngere rau leire lolo Haran, me ram vano sulolo vanue Kenan, siu ngere ram dadari aie. ");
INSERT INTO omb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Me Ebram mo vano turu lo vanue hi a vuigei lawua hi Moreh tahi Sekem. Ngere tau Kenan ram toga lolo vanue hi lo taro hi. ");
INSERT INTO omb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Siu a Huqe mo haharagi nie lawe Ebram siu mo veve vena, “Nain bete na vanue lehe lawe renetumu.” Lune hi mo hau na vonda gogona lawe na Huqe nge mo haharagi nie lawea taie. ");
INSERT INTO omb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Siu mo maraga mo siregi taie hi mo vano lo vusi kakarani Betel me mo vutu na nona siusiu lo livugei Betel mena ute Ai lo matenaho kalo. Nge mo tau na vonda gogona lawe na Huqe taie hi, me mo ware gareagi na henai Huqe. ");
INSERT INTO omb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","I Ebram mo maraga mo vano rorongo matai dueliu. ");
INSERT INTO omb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Lo tagui gineu ngere ngaha, a leo noi Huqe u vomai lawe Ebram lolo bombore mo veve vena, “Goin mese matagu Ebram. Neu nain vuragi na nom tutugoro me nom gai malai u lawua.” ");
INSERT INTO omb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Siu Ebram mo duvie, “?Huqe Lawoa, havai hi goin bete laweau huri netuku hatie? Noku gaihora, Eliese tau Domaskas, vin lei na noku tataue siu nge vin lei na noku hango gineu doluegi.” ");
INSERT INTO omb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Me mo veve taligu, “Ko leo gohi bete na maresu te lawe au a noku gaihora vin lei na noku tataue siu nge vin lei na noku hango gineu doluegi.” ");
INSERT INTO omb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Me a leo noi Huqe mo vomai lobena mo veve vena, “Hatie! Nge ngaha vin mese sesei na tanomu, huri gategale vin mwelue den valemu sibomu, ngeie vin lei na nomu hango gineu.” ");
INSERT INTO omb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Me mo laie tavano varea me mo veve vena, “Ko leo siseri tahage aulu lolo mahava me gom valu na visiu tare gu vei lei ve goin velure. Renetumu rain sao mwere hi.” ");
INSERT INTO omb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ebram mo ladohogo lui Huqe, me siu i Huqe mo wareginie ve nge a tangaloi vovohoi. ");
INSERT INTO omb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Nge mo veve vage lawea vena, “Neu i Huqe. Nau lei vohogi niko den Ur ta Kaldea ve nain bete na tano ngaha lawego goin leie vin voragi nomu.” ");
INSERT INTO omb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ebram mo veve vena, “?Huqe Lawoa, nain ilo mwere hilogo ve rain voragi noku?” ");
INSERT INTO omb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Me nge mo maraga move, “Goin lei laweau a bulugi duregi, me nani duregi, me a sibsib boegi higaora hogo gaitolu, me a mwara, mena rangamea mwalakelogi.” ");
INSERT INTO omb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Me Ebram mo lai na gangarue doluegi lawea, mo tai wakawakara mo taure ravui leoleo nago. Manu ngehi tei wakawakara tea. ");
INSERT INTO omb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Siu a mala ram hivo huri na bigi ngere hi Ebram mo livu vohoginire. ");
INSERT INTO omb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mo kakarani aho mo sasaroro mata huegi mo wehi Ebram mo maturu mate me a dodo na matagute lawua mo gagavugi nie. ");
INSERT INTO omb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Me a Huqe Mauri mo veve lawe Ebram, “Goin ilo vurugegi huri renetumu rain toga lolo tano hate nora, me rain tabana lawe na tangaloi lo vanue hi, rain vei asisigi nire vi dadari a higao vudolue vaga vesi. ");
INSERT INTO omb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nge nain arahi na taureure ngere rain tabana meire lo tagugi ngere rain mwelue mena hagogineu sao. ");
INSERT INTO omb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Nge niko goin mule gitano lo tamwata me rain teviginigo lo taro tavohe gu tamaragai vurugegi. ");
INSERT INTO omb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Lo tagui higao vudolue vaga vesi renetui renetumu rain mule hano huri a doridori esi nora ta Amoro he dadari te lo tovotovogi mosigei.” ");
INSERT INTO omb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Lo taro matenaho mo sasaroro me mo dodo, siserigi hi a sosovene mo ququ mena leleoi here mo vomai lo livugei tavisevisei bigi. ");
INSERT INTO omb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Lo rani ngehi i Huqe mo vai na waratau siaga mei Ebram mo veve vena, “Nain bete na vanue ngaha lawe renetumu mo tavuigi lo arai vanue Ijib mo dadari lo wai meuri lawua Iveretis: ");
INSERT INTO omb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","A tano tau Keni, tano tau Kenisi, tano tau Kadamon, ");
INSERT INTO omb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","tano tau Hiti, tano tau Beris, tano tau Revei, ");
INSERT INTO omb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","tano tau Amoro, tano tau Kenan, tano tau Gigas me tano tau Jebus.” ");
INSERT INTO omb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Serai, i gahorai Ebram, he bamba telai maresu nge a nona vavine tabanagi tau Ijib henana i Hega. ");
INSERT INTO omb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Me i Serai mo veve lawe Ebram, “Huqe u tugoro au dena maresu. Ko vano ko maturu mei noku vavine tabanagi mo tabana noku, bataha renetugu rain vomai denie.” Ebram mo masinge lo leoi Serai. ");
INSERT INTO omb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Lo tarogi hi, Ebram toga Kenan higao hangavulu. Me Serai gaihorai Ebram mo lai na vavine tabanagi tau Ijib hi henana Hega, mo betea lawe tamai netune mo vuragi gaihorana. ");
INSERT INTO omb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Me mo maturu mei Hega, mo tinogi na maresu. Lo taro hi mo tinogi na maresu mo tavuigi mo leo masi na nona ratahigi Serai. ");
INSERT INTO omb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Siu Serai mo veve lawe Ebram, mo veve vena, “Niko gu veieu tau nam romasi lune. Nam tau na noku tangaloi tabanagi lo limemu, siserigi ngaha u ilo ve mo tinogi na maresu mo leo masi eu, u garea a Huqe vin tovotovo lo livuge daru.” ");
INSERT INTO omb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ebram move, “Nom vavine tabanagi nge lo limemu. Ko vai na havagi lawea gom lado huri ve vovohoi.” Siu Serai mo vai asisigi Hega mo maraga mo toa denie. ");
INSERT INTO omb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","A Gaihora noi Huqe mo haqe Hega lobe na matamata lolo vanue vurogi, a matamata lo bomboi turegi mo vano lo vanue vurogi Sur. ");
INSERT INTO omb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Me mo veve vena “?Hega tangaloi tabanagi noi Serai, gom vomai logo, me goin valogo?” Hega move, “Nam toa dena noku ratahigi Serai.” ");
INSERT INTO omb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Siu a Gaihora noi Huqe mo veve lawea move, “Ko mule taligu lobe na nom ratahigi gom rongo hurie.” ");
INSERT INTO omb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","A Gaihora noi Huqe mo veve taligu, “Nain vei na duvi mu vin sao liu a tangaloi vin velu telai.” ");
INSERT INTO omb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","A Gaihora noi Huqe mo veve vage lawea, “Siseri hi niko mena maresu me goin haqe na maresu mwera. Goin suri na henana i Ismael, huri a Huqe u rongo na nom romasi. ");
INSERT INTO omb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Vin vuragi na donki turugi dena tangaloi, limana vin esi vovohoi na tangaloi doluegi me a limei tangaloi doluegi rain esi vovohoie, me nge vin toga gina romasi vohivohi retuana doluegi.” ");
INSERT INTO omb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hega mo bete na hena hingaha lawe na Huqe Mauri nge u gato meie: “Niko a Huqe nge gu lehi eu.” Huri mo veve, “Nam lehie nge u lehi eu.” ");
INSERT INTO omb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Huri hi a tungui wai waregi Bere Lahai Roi, mo eno taie mosigei, lo livugei Kades mena Bered. ");
INSERT INTO omb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Siu Hega mo bamba netui Ebram maresu mwera, me Ebram mo suri na henana Ismael. ");
INSERT INTO omb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ebram higaona ngavulugei welu domwagi gaiono tavohe i Hega mo bamba Ismael lawea. ");
INSERT INTO omb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tavohe i Ebram higaona ngavulu geisiwo siwo domwagi gaisiwo, Huqe mo vosangie lawea, move “Neu a Huqe Huireana, ko dige na vovohoi mei eu me a tangaloi na mese sawirigo. ");
INSERT INTO omb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Siu nain vei na noku waratau siaga mei go me nain vei na tovomiu vin sao.” ");
INSERT INTO omb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ebram mo soi hivo gena nagona me Huqe Mauri mo veve lawea, ");
INSERT INTO omb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Huri eu, nge ngaha a noku waratau siaga mei go: Niko goin voragi na tamai vanue sao. ");
INSERT INTO omb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Siu a henamu taligu hate i Ebram, nge a henamu vin voragi Ebraham, huri nain veigo goin vuragi na tamai vanue sao. ");
INSERT INTO omb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nain vei renetumu vin sao garagara, nain veigo goin vuragi vanue sao me a ratahigi sao rain vomai denigo. ");
INSERT INTO omb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nain vei na noku waratau siaga vagituei lo livuge daru mei renetumu siu lo tagumu mo huri na bambagi mo vomai teu mosigei, nain vuragi nomu Huqe Mauri me ngere hi lo tagumu. ");
INSERT INTO omb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nain bete lawego mei renetumu lo tagumu, vanue Kenan gom vuragi na hala lolona, nain bete na gineu doluegi vin voragi nomu vagituei me nain voragi na nomiu Huqe Mauri.” ");
INSERT INTO omb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Siu Huqe Mauri mo veve lawe Ebraham, “Nge niko, goin hako bimbi na noku waratau siaga, niko mei renetumu lo tagumu siu lo bambagi ram vomai mosigei. ");
INSERT INTO omb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nge ngaha a noku waratau siaga mei go me a bambagi lo tagumu, a waratau siaga niko goin wiribibi: Mwera doluegi lobemu rain teve gigilegi nire. ");
INSERT INTO omb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","I niko goin lehe hurivena a teve gigilegi mo vaiana me vin vuragi na gai gigilegi waratau siaga lo livuge daru. ");
INSERT INTO omb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Lo bambagi vin vomai, vataha na mwera doluegi mei gimiu bongire gaiwelu rain teve gigilegi nire meire hi rau vora lolo valemu mena maresu halo me ngere hatie renetumu. ");
INSERT INTO omb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Vovohoi garagara tareve rau vora lolo valemu sige neu volire gena vatu, ngere rain teve gigilegi nire. Noku waratau siaga lo tarabesimiu vin voragi na waratau siaga vagituei. ");
INSERT INTO omb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","A mwera rahi teve gigilegi tea mosigei, nge rahi teve gigilegi nire te lo tarabesi, dai velu vohoginire dena nona tangaloi, huri nge u vei utu hi na noku waratau siaga.” ");
INSERT INTO omb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Huqe Mauri mo veve lawe Ebraham, “Nge huri Serai tubui lo valemu, gon he warea te taligu huri ve i Serai nge a henana vin vuragi Sera. ");
INSERT INTO omb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Neu nain vei gareagi nie me nain bete lawego a maresu mwera nge vin bamba. Nain veie vin vuragi na retahi vanue sao, me a ratahigi sao rain vomai denie.” ");
INSERT INTO omb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ebraham mo soi hivo gena nagona, mo mana me mo gatogato gahea move, “Ve u garea huri vena tangaloi vin hankovi na maresu lolo higao vudolue? Huri vena i Sera vin hakovi na maresu lo higaona ngavulu geisiwo siwo?” ");
INSERT INTO omb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Me i Ebraham mo veve lawe Huqe Mauri, “Ve huri ve i Ismael na toga lo vavai nomu gareana.” ");
INSERT INTO omb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Siu Huqe Mauri move, “Io i tubui lo valemu Sera vin bamba netumu mwera, me niko goin suri na henana a Aesak. Nain teu na noku waratau siaga meie vin vuragi na waratau siaga vagituei lawe reduvine lo tagune. ");
INSERT INTO omb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Nge huri Ismael, nau rongogo: nain vei gareagi nie, nain veie vin lulu me a tovogi vin lawua. Nge vin vuragi na tamai ratahigi hangavulu domwagi gairue, me nain veie vin voragi na vanue lawua. ");
INSERT INTO omb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Nge a noku waratau siaga nain veie mei Aesak, huri Sera vin bamba lolo taro mwere ngaha lo higao taligu.” ");
INSERT INTO omb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Tavohe u laqa u rovo mei Ebraham, Huqe Mauri mo mule kalo denie. ");
INSERT INTO omb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Lo ranigi hi teu Ebraham mo lai netune Ismael mei ngere doluegi rau vora lolo valena sige u voli gena vatu, mwera doluegi lolo valena, me mo teve gigilegi nire mwerei Huqe Mauri u veve lawea. ");
INSERT INTO omb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ebraham higaona ngavulu geisiwo siwo domwagi gaisiwo ram teve gigilegi nie. ");
INSERT INTO omb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Me i netune Ismael higaona hangavulu domwagi gaitolu. ");
INSERT INTO omb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ebraham mei netune Ismael ngere vunu ru teve gigilegi lo rani gategale. ");
INSERT INTO omb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Me a mwera doluegi lolo valei Ebraham meire rau vora lolo valena, sige ngere rau voliana dena taureure, rau teve gigilegiana meie. ");
INSERT INTO omb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Huqe mo vosangie lawe Ebraham kakarani lobei gai lalawua bulei Mamre, tavohe nge mo toga lo matai turegi nona siusiu lolo livugei reni. ");
INSERT INTO omb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Me i Ebraham mo lalangau mo lehi na tangaloi gaitolu ram labe kakarani lobena. Tavohe mo lehire, mo maraga dena nona siusiu mo toa siseri vena laire me mo huduhudu hivo lo tano lawera. ");
INSERT INTO omb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Siu i Ebraham mo veve vena, “Tareve nau haqe vena gu leo gareagi eu, nongu ratahigi, ko mese dige liu na nom tangaloi tabanagi. ");
INSERT INTO omb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Nan lai na wai biti, me nein solo na garu miu me nein manga lo vavai gei hi. ");
INSERT INTO omb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nan lai na hinaga nen gani, huri vin ture bimbi gimiu lo turegi miu huri nei dadari lobei nom tangaloi tabanagi.” Ngere ram duvi, “Garea liu, go vai mwere hi gom veve.” ");
INSERT INTO omb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Me i Ebraham mo vano siseri lobei Sera lolo nona siusiu. Mo veve vena, “Siseri, lai na vulaoa gete gaitolu gom qihie gom qui na bereti.” ");
INSERT INTO omb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Siu mo toa vano lo arai bulana kankarue, mo vilegi nire me mo lai na natui bulugi damoe mo bete lawe na nona tangaloi tabanagi, nge mo vai siseri mo vai raraie. ");
INSERT INTO omb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Siu a hinaga mo manoga, nge mo lai na woro mena rui mena bigigi, nge mo walie lawe ngaraha gaitolu, mo tau na hinaga hi vuine lawera. Siu ngere ram gani, nge mo labe lobe ra lo vavai gai. ");
INSERT INTO omb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ram huie, “?Gaihoramu Sera nge logo?” Nge mo duvi, “Nge vano, lolo siusiu.” ");
INSERT INTO omb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Siu HUQE Mauri mo veve, “Nain tudori lobe mu mwere hingaha lo higao taligu, me Sera tubui lo valemu vin bamba na mwera.” Siserigi hi i Sera mo rorongtagi lo matai turegi siusiu lo tagure. ");
INSERT INTO omb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ebraham tona Sera ru sesea lawuagi me i Sera uliu na higaoi bamba maresu. ");
INSERT INTO omb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","I Sera mo manamana gahea me mo ladoladogi, “?Neu nau tubui lawuagi me i tamai netuku u sesea lawuagi, siu neu nain rongarea huri ve nain vuragi na tanqalugu taligu?” ");
INSERT INTO omb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Siu Huqe mo veve lawe Ebraham, “Huri havagi i Sera mo mana me move, ‘?Neu hurive nain bamba na maresu, siserigi ngaha nau sesea?’ ");
INSERT INTO omb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Neu i Huqe. ?Havagi hi u siaga lawuagi me eu? Nain tudori lobe mu lo taro mwere hingaha lo higao taligu me i Sera vin bamba na maresu mwera.” ");
INSERT INTO omb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sera mo matagu, me mo kali mo veve vena, “Nai mana tea,” nge i Huqe mo veve vena, “Io gu keli, nigo gu mana.” ");
INSERT INTO omb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Huqe u vei gareagi Sera mwere nge u warataugi lawea. ");
INSERT INTO omb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","I Sera mo tinogi na maresu me mo bamba na maresu hi mwera lawe Ebraham lo taro hi nge u tamaragai beno vovohoi mwere u waratau beno lawea. ");
INSERT INTO omb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ebraham mo suri na henai maresu hi, i Aesak. Sera u bamba lawea. ");
INSERT INTO omb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Tavohe netune Aesak bongine mo gaiwelu Ebraham mo teve gigilegi nie mwerei Huqe Mauri u vevea lawea. ");
INSERT INTO omb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ebraham higaona vudolue tavohe netune Aesak mo vora. ");
INSERT INTO omb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sera mo veve vena, “Huqe Mauri u vei gareagi eu, u vei eu nam mana tare hine vi rongo na rorogu, rain rongarea mei eu me rain mana.” ");
INSERT INTO omb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Me nge mo veve vena, “Hine vi veve lawe Ebraham huri ve i ?Sera vin vagatiti na maresu? Nge ko leo, neu tongu Ebraham guru sesea lawuagi me neu nau bamba na maresu lawea.” ");
INSERT INTO omb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ngaha a maresu u lawua mo siregi titi, Ebraham mo lagogi na hinaga lawua vuragi na gai tovoi rani ngehi. ");
INSERT INTO omb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Nge i Sera nge mo leo huri ve netui Hega vavine tau Ijib nge u bambae lawe Ebraham mo bilibili esi mei Aesak. ");
INSERT INTO omb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Siu mo veve lawe Ebraham, “Ko hora vohogi na vavine hora mei netune, huri a vavine hora netune vin mese lai na duvi hango gineu noi netuku Aesak.” ");
INSERT INTO omb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","A gineu ngaha mo vai Ebraham mo rongesi lawuagi huri netune. ");
INSERT INTO omb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Nge i Huqe Mauri mo veve lawe Ebraham “Mese romasi huri na maresu mena vavine hora; goin ronghuri na hava leo i Sera mo veve lawego, huri vevenagi duruhi Aesak a maresu ngere hi rain waregi renetumu vovohoi. ");
INSERT INTO omb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Nain vei netui vavine hora vage vin voragi na vanue lawua, huri na maresu ngehi i netumu.” ");
INSERT INTO omb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Robongi siaga lo rain tuegi, Ebraham mo lai na hinaga, vurugi wai, me mo bete lawe Hega. Mo taure lo siqei Hega, siu mo hora vohoginire tona netune Ismael. Mo dige lategi lolo vanue vurogi waregi Bereseba. ");
INSERT INTO omb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tavohe a wai u rovo lolo vurugi, nge mo tau na maresu lo vavai gei gategale. ");
INSERT INTO omb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Siu nge mo vano mo toga vidiregi dena maresu mwere na liue mo olo, huri mo lado, “Neu nain mese lehi netuku ve vin mate lo nagogu,” me nge mo toga taie mo ngara gena dilo siaga. ");
INSERT INTO omb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Huqe Mauri u rongo na diloi Ismael me a Gaihora noi Huqe Mauri mo ware na henai Hega dena taetae mo veve lawea move “?Mwere hilogo Hega? Mese matagu Huqe Mauri u rongo na diloi maresu lo tanona nge mo eno. ");
INSERT INTO omb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Raka na maresu ta aulu me gom dulae, huri nain veie vin vuragi na vanue lawua.” ");
INSERT INTO omb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Siu i Huqe Mauri mo waga na matai Hega me mo lehi na walui tungu. Me mo vano mo utu na wai lolo vurugi, me mo bete lawe na maresu mo inue. ");
INSERT INTO omb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Huqe Mauri nge mo bului na maresu hi mo dadari lune nge mo lawua. U toga lolo vanue vurogi me nge mo vuragi na tangaloi venvene masogo lo vuhu. ");
INSERT INTO omb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Lo tarogi nge mo toga lolo vanue vurogi tau Baran, i retahine mo lai gaihorana tau Ijib lawea. ");
INSERT INTO omb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Lo tagugi, he ribi tea, Huqe mo vai lehi na ladohogo noi Ebraham. Mo ware himei lawea move, “Ebraham.” Me i Ebraham mo duvi lawea move, “Neu nge.” ");
INSERT INTO omb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Siu i Huqe Mauri mo veve vena “Ko lai netumu, netumu gategale vohogi Aesak, nge gu lehe garea me goin vano lo vanue Morea. Nain haharagi na vusi lawego. Lo vusi hi goin hure netumu vin vuragi na nom hure bonboni lawe au.” ");
INSERT INTO omb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Lolo robongi siaga lo rani tuegi, i Ebraham mo maraga mo vagararai na bulana donki. Me mo lai na nona hora gairue, mei netune Aesak. Lo tarogi hi nge u tei na avi u tatarise huri na hure bonboni, me nge mo vano huri na ute hi Huqe u horae hurie. ");
INSERT INTO omb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Lo rani gaitoligi Ebraham mo leo ta eulu mo lehi na ute hi mala vindiregi. ");
INSERT INTO omb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Mo veve lawe na nona tangaloi tabanagi, “Nero tino tau mena donki, nge gamaru mena maresu goro vano tavano, goro galohagi na Huqe Mauri siu gorom tudori lobe miru.” ");
INSERT INTO omb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ebraham mo wali na gai huri hure bonboni mo taure lui netune Aesak, me i Ebraham mo wali na avi geni mena bue. Tavohe ngere rom vano bubugi, ");
INSERT INTO omb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aesak mo veve lawe Ebraham, move, “Ei tata.” Ebraham move, “Io netuku.” Mo hui, “?Avi mena gai ngere, nge a sibsib huri na hure bonboni nge logo?” ");
INSERT INTO omb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ebraham mo duvi move, “Netuku, a Huqe sibona vin bete na sibsib huri na hure bonboni.” Me ngere rom vano bubugi. ");
INSERT INTO omb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Lune ngere romo vano dadari lo ute Huqe u vevea lawea, Ebraham mo bulu na vonda gogona taie, me mo tau vurugegi na gai hure bonboni lo ulugi. Me mo vau hi bibi Aesak mo taue lo vonda gogona lo ului gai hure bonboni. ");
INSERT INTO omb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Siu mo hahaga vano mo lai na bue huri ve na wehi netune. ");
INSERT INTO omb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Nge a Gaihora noi Huqe mo ware dena taetae mo veve vena, “Hei Ebraham! Ebraham!” Me I Ebraham mo duvie move, “Neu nge.” ");
INSERT INTO omb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Mese singeli na maresu, Mese vai na hava gineu te lawea. Siserigi ngaha, nau ilo huri ve a domi mu u mwamwavi lui Huqe me goin sigigi netumu te dein eu huri netumu gategale hogosie.” ");
INSERT INTO omb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Siu Ebraham mo leo lategi mo lehi na sibsib boegi a hibine u ganga lo rangai gei biti. Me mo vano mo lai vohogi nie me mo wehe mo mate, me mo hurae mo vuragi na nona hure bonboni lo tanoi netune. ");
INSERT INTO omb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Me mo tau na henai ute ngehi, “Huqe vin bete.” Hurihi u vomai mo dadari bagataha ram veve, “Na ute aulu lo ului vusi noi Huqe nge vin bete.” ");
INSERT INTO omb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","A Gaihora noi Huqe mo ware lawe Ebraham lolo taetae vaga tuegi. ");
INSERT INTO omb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Me mo veve lawe Ebraham move, “I Huqe mo veve vena nam hariherigi lo henagu mo huri na noku waratau siaga huri ve nain vei gareagi niko u lawua liu. Netumu gategale vohogi gu bambae, nge goin sigiginie tea, gu rarai ve goin siregi nie vin mate. Huri niko gu vei mwere ngaha, ");
INSERT INTO omb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","neu nam waratau siaga lawego, huri ve ngere rain vomai lo tagumu rain sao vin mwere na visiu lolo mahava mena one lo bambai tahi. Ngere rain qaragi na nora tavalui vuro. ");
INSERT INTO omb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Me duruhi renetumu, neu nain vei gareagi na sinobu doluegi lo ure lehe, me nain vei gareagi nire ngere rain vomai lo tagumu, huri na doridori gu vei mei eu, mwere hi gu ronghuri na noku leo.” ");
INSERT INTO omb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Siu Ebraham tona Aesak rom vomai lobei na tangaloi hora gairue ngere doluegi ram vano bubugi lolo vanue Bereseba. Siu i Ebraham mo togagi vanue taie hi.");
INSERT INTO omb_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Mosis mo warera Israel doluegi me mo veve vena, “Ei Israel, ne rongo na leoi tamwata mena leo vevegi nam veve sere lawe gimiu bagataha. Nein huhuire me siu nein huri vurugegi nire. ");
INSERT INTO omb_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Noda Huqe Mauri u teu na waratau siaga mei ginde lo vusi Saenai. ");
INSERT INTO omb_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","I Huqe hi teu na waratau siaga ngaha tea lawe retamada, nge lawe ginde, ginde doluegi hano dam mwaso bagataha. ");
INSERT INTO omb_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Huqe u gato mei go lo nagomu lo vusi dena livugei avi. ");
INSERT INTO omb_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Lo taro ngehi neu nau labe lo livugei Huqe me lo livuge miu ve nain matamwasaragi na leo noi Huqe lawe gimiu, ba huri gimiu neu matagu gena avi me nein hage tea lo vusi. Me mo veve vena: ");
INSERT INTO omb_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‘Neu nom nomu Huqe Mauri, nau lei vohogi niko dena vanue Ijib, a vanuei tangaloi gimiu neu tabana gagarasi lune. ");
INSERT INTO omb_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Goin mese huduhudu goro na huqe wagineu. Neu Huqe gategale. ");
INSERT INTO omb_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Goin mese vai na nunui huqe tau eulu lolo taetae, sige nunui gineu mwaso talo tano me lo vavai tano, me lo buloi tahi vuine. ");
INSERT INTO omb_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Goin mese huduhudu goro na huqe vurogi huri neu nomu Huqe Mauri, neu a domi gagarasi. Nain vevegi na maresu huri na bugui tamara vin dadari lo bambai maresu gaitolu, gaivesigi ngere hi rau leo masi eu. ");
INSERT INTO omb_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Nge a noku vaigarea lawe na sinobu teriteri ngere hi rau leogareagi eu me ram wiribibi na noku leohora. ");
INSERT INTO omb_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Goin mese ware vurogi na henai nomu Huqe Mauri, huri Huqe vin vevegi nire ram ware vurogi na henana. ");
INSERT INTO omb_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Goin wiribibi na rani gaibitugi vin gogona, a rani mangana mwere hi nomu Huqe Mauri u veve lawego. ");
INSERT INTO omb_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Lolo rani gaiono goin tabana me goin vei na tabanagi doluegi lolona. ");
INSERT INTO omb_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Nge a rani gaibitugi a rani mangana noi nomu Huqe Mauri. Goin mese vai na tabana lune, niko mei renetumu, sige a nomu tangaloi tabanagi doluegi sige a bulugi sige a donki, sige hala. Sige hine bulemu gangarue, me hala lolo nomu ara, huri a nomu tangaloi tabanagi rain manga mwereigo. ");
INSERT INTO omb_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Huri goin lado bibi ve niko a tangaloi tabana vurogi, lolo Ijib, nge a nomu Huqe Mauri u lei vohogi niko dena Ijib gena nona huireana. Siu nomu Huqe Mauri mo veve lawego huri ve goin wiribibi na rani gaibitugi. ");
INSERT INTO omb_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Goin lado mavagi tamamu mei retahimu mwerei nomu Huqe Mauri u veve lawego, huri nein mwaso vin tuei, me nein toga vurugegi vin qaravu lolo vanue nomu Huqe Mauri vin betea lawego. ");
INSERT INTO omb_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Goin mese ue vagamate na tangaloi. ");
INSERT INTO omb_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Goin mese maturu mena vavine dolue nge hate i horamu sige a mwera hate tamainetumu. ");
INSERT INTO omb_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Goin mese balubelu. ");
INSERT INTO omb_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Goin mese gaivutugi retuemu gena leo kalikeli. ");
INSERT INTO omb_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Goin mese vai huri gaihorai tuemu, a valena, a nona tano, a nona tangaloi tabanagi, a bulana gangarue, sige a nona gineu doluegi.’” ");
INSERT INTO omb_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Me taligu, Mosis mo veve vena, “Ngere ngaha a leohora i Huqe u veve lawe gimiu, tavohe neu kalo bubugi lo vusi Saenai. Me mo gato gena dilo lawua dena tailengi mena dodo gena avi. Siu hate gineu vage. Mo reve na leo lo tavisei vatu tatavola gairue, me mo betera lawe au. ");
INSERT INTO omb_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Me tavohe a avi mo gao na vusi gam rongo na leo mo vomai dena dodo lawua, me ira sesea meire ira tomtomuegi doluegi ramo vomai ram lehi eu. ");
INSERT INTO omb_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Me go ve, ‘Wo! Noda Huqe Mauri, u haharagi na varavarai nona muremure mena lawuana lawe ginde lo dilo lawua gau rongoe lo livugei avi. Bagataha dambei ilo huri ve Huqe Mauri u gato me tangaloi he mate tea. ");
INSERT INTO omb_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Siserigi ngaha gamai gam rao huri ve gain kakarani lobei mateana taligu. A avi lawua vin gao gamai me vin ngehigi gamai. Tareve gamai gain rongo na diloi noda Huqe Mauri taligu gamai gain mate. ");
INSERT INTO omb_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Gu ilo beno! Hate tangaloi tangaha huri ve Huqe vomai lobena lolo avi vena gato mwere u gato mei ginde siu lo tagugi dahe mate tea. ");
INSERT INTO omb_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Ko vano kakarani ko rorongtagi na leo doluegi noda Huqe Mauri vin veve lawego me lo tagugi goin vomai gom vevesere lawe gamai. Gamai gai rongora me gain tabera.’ ");
INSERT INTO omb_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Me i Huqe u rongo na diloi nomu leo tavohe gu gato mei eu me i Huqe mo veve vena, ‘Nau rongo na diloi leo noi sinobu me havai ngere rau veve doluegi rau hogo. ");
INSERT INTO omb_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Neu nam tarani ve rain lado mavagieu, me rain tabe na noku lehora tamwere, me lo nora mwasoana, noi reneture me i reneture rain vomai lo tagure vin garea vin tuei, ");
INSERT INTO omb_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","siserigi ngaha goin veve lawera, rain mule taligu lo nora vale siusiu. ");
INSERT INTO omb_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Niko hogosie goin toga mei eu hano. Neu nain bete na noku leohora mena noku leo tamwata, me leo vevegi, lo tagugi goin vano goin huhui na tangaloi ngere hi ginie, me lo tagugi rain toga lolo vanue nain bete lawera, rain tabe na noku tamwata.’” ");
INSERT INTO omb_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Me taligu, Mosis mo veve vena, “Nein dige lo turegi hi a nomiu Huqe Mauri u veve lawe gimiu. Nein lehuri ve nein vei na havagi a Huqe Mauri u veve lawe gimiu. Mese begi sulo matue sige sulo mawiri. ");
INSERT INTO omb_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Nein dige lo turegi hi a nomiu Huqe Mauri u veve lawe gimiu. Tareve nein vei mwere hi, nomiu mwasoana vin garea me nein mwaso vurugegi siu nein toga vin qaravu lolo vanue ngere hi nein leie vin vuragi nomiu.” ");
INSERT INTO omb_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“Ngere ngaha a leohora, leo tamwata mena leo vevegi ngere hi a nomiu Huqe Mauri u betea laweau huri ve nein huhui gimiu nein vei lune lolo vanue nge hilogo nein dige utu liu vano lolo vanue nein leie vin vuragi nomiu. ");
INSERT INTO omb_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Me gimiu mei renetumiu mei reneture lo tagure rain lado mavagi gina nomiu Huqe Mauri, huri lune nein mwaso vin qaravu me nein hako bibi na nona leo tamwata mena nona leohora neu nau bete lawego. ");
INSERT INTO omb_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Ei Israel! Goin ronghuri me goin tabetabe, huri vin garea mei go siu huri nein sao lawuagi; ko lolo tano mo hale wai lulumu, mena hinaga lulumu, mwere hi Huqe Mauri noi tamamiu Huqe u warataugi lawe gimiu. ");
INSERT INTO omb_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Ei Israel! Nein rongo! Huqe i nge noda Huqe Mauri, Huqe ngeie gategale hogosie. ");
INSERT INTO omb_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Goin leogareagi na nomu Huqe Mauri mena dingmwangomu doluegi, mena nomu mwasoana doluegi me gena huimu doluegi. ");
INSERT INTO omb_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Leohora ngere ngaha nam bete lawego bagataha goin lado bibi lolo dingmwangomu. ");
INSERT INTO omb_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Goin uluire lawe renetumu me goin laqagi lawera tavohe gom toga lolo valemu, me tavohe gom dige lo turegi, tavohe gom eno, tavohe gom maraga. ");
INSERT INTO omb_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Me nein veu gigilegi nie lo lime mu gagategalegi, mena rae mu gagategalegi. ");
INSERT INTO omb_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Me goin ulire lo matai vale mu me lo matai nomu ara. ");
INSERT INTO omb_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Tavohe nomu Huqe Mauri vin lei go vano lolo vanue ngere hi nge u warataugi lawe retubumiu, i Ebraham, i Aesak, me lawe Jekob ve vin bete lawego, a tano mena vanue rege lalawua ngere hi nehi bulure tea. ");
INSERT INTO omb_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","Me vale sao rau medi doluegi gena gineu gagarea ngehi hogoni tea, walui wai gohi keli tea, talui waen mena talui oliv nehi rivu tea. Siu tavohe gom gani goin guqe, ");
INSERT INTO omb_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","goin leohuri huri ve goin mese galuvegi na Huqe. Ngeie u lei go dena vanue Ijib, dena vanuei tangaloi gimiu neu tabana gagarasi lune. ");
INSERT INTO omb_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Goin lado mavagi gena nomu Huqe Mauri goin tabana lawea hogosie me go goin waratau lohenana. ");
INSERT INTO omb_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Nein mese huri na huqe vurogi doluegi, me dena huqe vurogi nora tangaloi dolue mo dali gimiu. ");
INSERT INTO omb_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Huri nomu Huqe Mauri nge lo livuge miu nge a nomu Huqe Mauri domi gagarasi mo mata bibi gimiu me a merona vin gao huri gimiu me vin lei vohogi gimiu dena nagoi tano. ");
INSERT INTO omb_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Nein mese vai lehi na nomu Huqe Mauri mwere neu vei lehie lo vanue Masa. ");
INSERT INTO omb_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Nein lado bibi ve nein hako bibi na leohora noi nomu Huqe Mauri mena nona na leo raga hui me leo tamwata goro nge u teu lawe gimiu. ");
INSERT INTO omb_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Goin vei havai u vovohoi me u garea lo nagoi Huqe, huri vi garea mei go me goin vano goin lei na tano garea i Huqe u waratau lawe retubumiu. ");
INSERT INTO omb_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Me goin godo vohogi na tavalui vuro dena vanue hi, mwerei Huqe u veve. ");
INSERT INTO omb_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Lo taro vin vomai renetumiu rain hui go ve, ‘?Noda Huqe Mauri, nge huri havagi mo veve siaga lawe ginde huri ve dan tabe siagagi na leo raga hui me leo tamwata, me leo vevegi ngaha?’ ");
INSERT INTO omb_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Nein veve lawera huri vena, ‘Tuei noda tamaragai rau tabana gagarasi noi ratahigi tau Ijib, nge Huqe u vomai mo lai vohogi ginde gena nona huireana. ");
INSERT INTO omb_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Lo tarogi hi i Huqe u vei na gineu lalawua vaigivui me gineu vai vutugegi lawua, rau huire vovohi na vanue Ijib, vovohi na ratahigi tau Ijib, me vovohi na valera doluegi. Dau lehire lolo matada. ");
INSERT INTO omb_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Nge u lei vohogi ginde dena vanue Ijib, mo vai ginde dam toga masuri me mo lai ginde talo vanue hano mwere nge u warataugi lawe retubumiu. ");
INSERT INTO omb_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","I Huqe mo veve lawe ginde ve dain tabe na nona tamwata me dain lado mavagi na noda Huqe Mauri, huri a gineu vin garea me dain mwaso mwere bagataha. ");
INSERT INTO omb_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Me ve dain tabe vurugegi na nona leohora doluegi ngere ngaha lo nagoi noda Huqe Mauri mwere nge u veve lawe ginde dain toga vovohoi lo nagona.’” ");
INSERT INTO omb_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“Tavohe nomu Huqe Mauri vin lei nigo tau lolo tano goi ehu lolona vin vuragi nomu me vin livusi vohogi na buri sinobu sao denigo, vanuara tau Hiti, me ngere tau Gikas, me ngere tau Amoro, me ngere tau Kenan, me ngere tau Beris, me ngere tau Hivi, me ngere tau Jebus. Vanuara buri sinobu gaibitu rau lawua me rau huire denigo. ");
INSERT INTO omb_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Me tavohe nomu Huqe Mauri mo betera lawego, me gom qaragi nire me gom wehi vagamatera doluegi vi rovo. Mese waratau siaga lawera. Mese hagavire. ");
INSERT INTO omb_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Mese lagi meire. Mese bete netumiu vavine lawe neture mwera, sige lai neture vavine lawe netumiu mwera, ");
INSERT INTO omb_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","huri rain dori netumiu den eu rain huri na nora huqe dolue me a meroi Huqe vin gao huri gimiu me vin wehi gimiu siseri. ");
INSERT INTO omb_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Nein vei vahavagi lawera: Vai vurivuri na nora vonda gogona mena vatu gogona, nein tei suri na berui gogona, me nein bule na nora nunui huqe vurogi lolo avi. ");
INSERT INTO omb_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Huri gimiu a tangaloi gogona lo nagoi nomu Huqe Mauri. U leo wahe gimiu den tangaloi doluegi lo nagoi ure siu gimiu hogosie Nie leogareagi gimiu lawuagi dena sinobu doluegi. ");
INSERT INTO omb_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Lo tarogi i Huqe u leo wahe ginde, dai sao tea. Vena liure dena garo lalavasigi lo ure ngaha, garoda u biti lawuagi liu den garora lolo ureure. ");
INSERT INTO omb_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Nge ba Huqe u leogareagi ginde me u hako bibi na nona waratau lawe retubumiu. Nge i Huqe u lei vohogi gimiu gena nona huireana me u vagamwasoi gimiu dena vanuei tangaloi gimiu neu tabana gagarasi lune, ko den muremure noi Vero nora ratahigi tau Ijib. ");
INSERT INTO omb_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Me goin ilo huri ve nomu Huqe Mauri nge i Huqe u garohuri siu nge u hango bibi na nona waratau siaga mena vaigareagi lawera, rau leogareagi me lawe na sinobu teriteri ngere ram tabea ko ram wiribibi na nona leohora. ");
INSERT INTO omb_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Me lawe hine ram leomasie lo nagona nge vin duvire gena vevegiana mena mateana. Nge vin sagaribi tea ve vin duvire gena vevegiana mena mateana. ");
INSERT INTO omb_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Siu, goin leohuri ve goin huri na leohora mena tamwata mena leo vevegi nau bete lawe gimiu bagataha. ");
INSERT INTO omb_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Me tareve nein ronghuri na nona leo vevegi nge mo betea, me nein tabea tamwere, nge vin hango bibi na nona waratau siaga, mena nona vaigarea mwere hinge u waratau lawe retubumiu. ");
INSERT INTO omb_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Nge vin leogareagi gimiu, me vin vei gareagi gimiu, me vin ragasi na tovomiu. Nge vin vei gareagi renetumiu, mena bulemiu rivurivu, mena hinaga, mena waen, mena oele, bulemiu bomboroa, mwere hi u warataugi lawe retubumiu huri ve vin bete lawe gimiu. ");
INSERT INTO omb_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Vin vei gareagi gimiu liu na sinobu doluegi; mwera mena vavine doluegi rain hango maresu. Siu bulemiu bomboroa rain vehuhu. ");
INSERT INTO omb_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Me i Huqe vin leogoro gimiu den segeana doluegi. Nge vin lei vohogi na segeana asi tau Ijib dein gimiu, nge vin betera lawera hine ram leo masi gimiu. ");
INSERT INTO omb_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Nein ue vagamate na tangaloi doluegi nomu Huqe Mauri u betera lawe gimiu. Nein mese hagavire, nein mese tabana nora huqe vurogi, huri ngere rain vuragi vune miu. ");
INSERT INTO omb_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Bataha nein lado lolo domi miu huri ve, ‘Buri sinobu ngere ngaha rau huire dein gimiu. ?Nge ginde da gondora vahavagi?’ ");
INSERT INTO omb_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Goin mese matagu ginire, nein lado na havagi i nomu Huqe Mauri u vei lawe Vero mena tangaloi doluegi tau Ijib. ");
INSERT INTO omb_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Neu leo gen matamiu gineu lalawua me gigilegi, me vaigivui, me lo nona huireana nge mo lai gimiu dena Ijib. A nomu Huqe Mauri vin vei mwere hi lawe na tangaloi gimiu nem matagu ginire siserigi ngaha. ");
INSERT INTO omb_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Me vage nomu Huqe Mauri vin hora na onet lawera vin dadari ngere hi rau mwaso rau hili dei gimiu rain mate doluegi. ");
INSERT INTO omb_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Mese matagu ginire. Nomu Huqe Mauri nge lo livuge miu, me u muremure, u garea ve a tangaloi doluegi rain matagu ginie. ");
INSERT INTO omb_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Nomu Huqe Mauri vin veire rain toa denire rorongogi vin dadari doluegi vi rovo, nein mese livu vohoginire vagategale. Huri tareve nein vei mwere hi, a gangarue turu rain sao rain wehi gimiu. ");
INSERT INTO omb_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Me i nomu Huqe Mauri vin betera lawe gimiu. Vin tulire rain dalodaloga vin dadari vin wehire rain mate doluegi. ");
INSERT INTO omb_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Me nge vin teu na nora ratahigi lo lime miu, me gimiu nein hara vohogi na henara lo ure. A tangaloi vin mese labe lo nago miu nein ue vagamatera vin rovo. ");
INSERT INTO omb_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Nunui nora huqe vurogi nein bule lolo avi, mese vai huri vatu renige mena vatu homu ngere hi ram eno lo nunu me mese lai ginomu nein bulara. Nein leohuri ve vin mese vuragi vune miu. Lo nagoi nomu Huqe Mauri rau esi garagara. ");
INSERT INTO omb_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Me goin mese lai na nunui huqe vurogi ta lolo valemu. Tareve goin vei mwere hi Huqe Mauri vin hara vohogi gimiu vage, ba huri ngehi mo tino huri vai vohogi hogosie. Goin lemasie garagara, ba huri ngere rau esi garagara.” ");
INSERT INTO omb_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","“Tavohe goin ehu lolo vanue ngehi i nomu Huqe Mauri vin bete lawego goin mese vai na gineu esi garagara ram eno lolo tanora buri sinobu ngere hi. ");
INSERT INTO omb_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Lo livuge miu tangaloi vin mese hure netune vena vuragi nona hure bonboni sige rain vei gineu mwere na duruduru, bombore, gaqaleva, ");
INSERT INTO omb_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","vangavanga, mateana, me ngere hi ram wade na tamatei tangaloi vena buluire. ");
INSERT INTO omb_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","I hine vin vei na gineu esi garagara ngere ngaha vin vuragi na tangaloi esi garagara lo nagoi Huqe, huri a gineu esi garagara ngere ngaha a nomu Huqe Mauri vin godo vohogi na taureure ngere hi denigo. ");
INSERT INTO omb_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","A tangaloi rain vevegi niko tea lo nagoi nomu Huqe Mauri.” ");
INSERT INTO omb_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","“A buri sinobu ngere hi i niko goin godo vohoginire rau mwere, ram huri na leora mataduru me ngere ram vai gigilegi gineu. Nge i nomu Huqe Mauri vi siregi ginde tea vena goin vei na doridori mwere hi. ");
INSERT INTO omb_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Nge nomu Huqe Mauri vin teu dein gimiu na tangaloi leo ligoligogi mwerei eu, siu gimiu nein rongo hurie. ");
INSERT INTO omb_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Nge ngaha vevenagi huri hava gineu gu nevu dena nomu Huqe Mauri tavohe neu kalo bubugi lo vusi Saenai. A gimiu neu veve lawe na nomiu Huqe Mauri vena gimiu nem matagu, nem rao huri ve vin gato mei gimiu taligu, siu gimiu nem ram rao nem veve vena, ‘Gamai gam rao rongoe ve vin gato mei gamai taligu, me gam rao vena, gain lehi na avi lawua taligu, mwere hi gain mate.’ ");
INSERT INTO omb_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Me i Huqe mo veve lawe au ve huri hi, mo veve lawe au vena, ‘Havagi ram veve, a leo hi rau vevea rau garea. ");
INSERT INTO omb_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Neu nain labetagi na nora tangaloi leo ligoligogi mwerei ko, nge vin vomai denire. Neu nain veve na noku leo me i nge vin vano vin veve sere na leo hi lawera mwere hi neu nau veve lawea. ");
INSERT INTO omb_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Nge vin gato lo henagu me tareve a tangaloi vin tarani tea vena rongoe, neu nain veveginie. ");
INSERT INTO omb_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Nge tareve a tangaloi leo ligoligogi gategale vin waregi sere na leo lo henagu tavohe neu nain horae tea, huri vena na vai mwere hi, gimiu nein ue vagamatea. Me, a tangaloi leo ligoligogi ngere hi ram gato lo henara huqe wagineu gimiu nein ue vagamatera vage.’ ");
INSERT INTO omb_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Nge bataha gimiu nein lado vena, ‘?Nge i ginde dain ilo vahavagi ve a leo hi u vomai dena Huqe sige hatie?’ ");
INSERT INTO omb_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","A turegine lune, tareve a tangaloi leo ligoligogi gategale mo tino mo gato lo henai Huqe, nge a gineu mo vevera rain vomai tea, ngehi mo haharagi nie huri ve a leo hi hate noi Huqe. A tangaloi leo ligoligogi hi mo gato lo nona huireana gahea. Siu huri hi, gimiu nein mese ladomava ginie.”");
INSERT INTO omb_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Lo tagui mateana noi Mosis tangaloi tabana noi Huqe, siu Huqe mo veve lawe Jesua netui Nun gaihango noi Mosis vena: ");
INSERT INTO omb_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Mosis nogu tangaloi tabana u mate. Siserigi lehe i nigo me tangaloi doluegi hi, ne maraga nem vano liu na wai meuri Jodan, sulo vanue ngehi nam bete lawera tau Israel. ");
INSERT INTO omb_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Tano doluegi ngehi goin dige lune nau bete beno lawe gimiu, mwere hi nau waratau lawe Mosis. ");
INSERT INTO omb_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","A tanomiu mo tavuigi lo vanue vurogi mo vano dadari lolo vusi lalawua Lebenon, siu dena wai meuri lawua Iveretis: vanue tau Hiti doluegi, me mo dadari Tahi Medeterenian lo matainaho sasaroro. ");
INSERT INTO omb_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Hate gategale ve vin labe lai vovohoigo lolo rani doluegi na nom mwasoana. Siu neu meigo mwerehi neu mei Mosis. Neu nain siregi nigo tea me nain teu vohogi nigo tea. ");
INSERT INTO omb_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Labe siaga me mese matagu, huri nigo goin tomuegi na tangaloi rain lei na vanue vin vuragi na hango gineu ngehi, nau haharigi lawe retubure hurive nai bete lawera. ");
INSERT INTO omb_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Labe siaga hogosie siu mese matagu. Goin leohuri ve goin tabe na huhuiana doluegi ngehi nogu tangaloi tabana Mosis u veve lawego; mese begi denie sulo matue sige sulo mawiri, huri nigo goin roroa logo hi nigo goin vano. ");
INSERT INTO omb_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Wiribibi na Bugui Huhuiana lo singomu me goi ladolado lune lolo rani, lolo bongi huri siu goi leohuri ve goi tabe na gineu doluegi u uliana lolona. Siu goin maraga lo gineu doluegi me goin roroa. ");
INSERT INTO omb_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Neu nau veve be lawego huri ve goi labe siaga me mese matagu. Mese rurururu, me mese wiriwiri huri nomu Huqe Mauri lo gineu doluegi ngeie meigo logo nigo gom vano.” ");
INSERT INTO omb_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","Me lo tagui rani sao, i Huqe mo bete na mangana lawera Israel dena nora tavalui vuro dalire. Siu tavohe hi Jesua u tamaragai lawuagi. ");
INSERT INTO omb_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","Siu Jesua mo warera Israel doluegi, nora sesea me mo ware na nora tomtomuegi, nora tangaloi vevegi, me mo ware na nora tangaloi gaihango siu mo veve lawera: “Neu nau sesea a nogu rani u rovo hi. ");
INSERT INTO omb_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Gimiu neu leo sibomu gineu doluegi hi i nomiu Huqe Mauri u vei lawe na buri sinobu huri gimiu, huri nge nomiu Huqe Mauri u qalo huri gimiu. ");
INSERT INTO omb_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Nein leo! Nau betegi na vanue lawe reduvimiu a vanue nora buri sinobu ngerehi ram toga tau meire hi nau qaragi nire. Vanue hi mo tavuigi Jodan mo vano mo dadari lo Tahi Medeterenian lo matainaho sasaroro. ");
INSERT INTO omb_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Siu a nomiu Huqe Mauri, nge vin livusire den gimiu. Nge vin lei vohogi nire dena vanue ba siu huri nein lei na vanue vin vuragi nomiu, mwere hi nomiu Huqe Mauri u waratau lawe gimiu. ");
INSERT INTO omb_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","Me gimiu nein labe vin siaga, nein leohuri ve nein tabe doluegi na leo lolo Bugui Huhuiana noi Mosis. Siu mese begi denie sulo matue sige sulo mawiri. ");
INSERT INTO omb_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Siu nein mese bulu meire buri sinobu ngerehi ram toga tau mei gimiu. Mese wareware lo henai nora huqe sao. Me mese haharigi lure, mese tabana nora, sige huduhudu lawera. ");
INSERT INTO omb_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Nge gimiu nei bulu siaga lo nomiu Huqe Mauri mwere hi gu vei beno mo dadari bagataha. ");
INSERT INTO omb_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","Huqe u livu vohogi nire buri sinobu ngerehi den gimiu rau lawua me rau huire. Lo taro hi, a tangaloi he labe lai tea suvohi gimiu. ");
INSERT INTO omb_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","A tangaloi gategale den gimiu vin livusire tangaloi teri, huri nomiu Huqe Mauri mo qalo huri gimiu mwerehi nge u waratau lawe gimiu. ");
INSERT INTO omb_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Siu gimiu nei leohuri vurugegi hurive, nei leogareagi na nomiu Huqe Mauri. ");
INSERT INTO omb_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","Tarevena nein tudori me nei bulu meire buri sinobu ngerehi ram toga tau mei gimiu, me nein lagi meire, me nein toga meire, ");
INSERT INTO omb_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","siu gimiu nein ilo hurive a nomiu Huqe Mauri hateve vin livusi na buri sinobu ngerehi taligu den gimiu. Nein ilo vurugegi hurive rain vuragi nomiu vune mena mata, rain mwere gai gagavo lo gangaumiu me rain mwere ginei volae lolo matamiu. Nge vin mwerehi vin dadari nein sala dena tano garea ngehi nomiu Huqe Mauri u bete lawe gimiu. ");
INSERT INTO omb_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","Me bagataha neu nogu taro u rovo. Me, gimiu nein landobimbi me nein ilo vurugegi vena a leo garea ngehi nomiu Huqe Mauri u warataugi lawe gimiu, doluegi rau veiana. Hateve leo gategale ngeie u soi lune. Doluegi rau veiana. ");
INSERT INTO omb_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Mwere hi leo garea doluegi noi nomiu Huqe Mauri rau veiana lawe gimiu. Siu nge vin vei na leo huire doluegi vin dadari lune vin vei vohogi gimiu dena tano garea ngehi, nge u bete lawe gimiu. ");
INSERT INTO omb_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Tavohe gimiu nei dige vagasile lo waratau siaga noi nomiu Huqe Mauri ngehi u veve lawe gimiu, huri gimiu nein tabana noi huqe wagineu me nein huduhudu lawera. Siu a nona meroana vin gao lumiu me gimiu nein sala siserigi dena vanue garea ngehi u bete lawe gimiu.”");
INSERT INTO omb_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Jesua mo hora vohogi na tangaloi tau Israel. Gagategalegi vin vano vin lei na vanue ngehi vin vuragi na nona hagogineu. ");
INSERT INTO omb_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Me a tangaloi ram galohagi na Huqe lolo taro tavohe i Jesua u mwaso. Lo tagui taro noi Jesua, ram galohagi Huqe tau duruhi na taro nora sesea ngerehi rau lehi na tabana lawua doluegi ngehi Huqe uvei beno lawera Israel. ");
INSERT INTO omb_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Jesua netui Nun, tangaloi tabana noi Huqe, u mate lo higaona vudolue avigi hangavulu. ");
INSERT INTO omb_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Siu ram tulegi nie lolo vanue hi a nona lo Timnat Heres, lolo vusi tanoi Evrem, gangarani lo Vusi Gaas. ");
INSERT INTO omb_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Siu lo babagi leheno mei Jesua rau mate beno, me ngerehi rau vora lo tagugi hateve rau ilo Huqe mena tabana lawua ngehi u veiana beno lawera Israel. ");
INSERT INTO omb_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Siu tangaloi tau Israel ram vai na gineu esi lolo matai nora Huqe me ram tabana noi tagaro vurogi saosao. ");
INSERT INTO omb_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Ram siregi na Huqe a Huqe noi retubure, ngehi u lei vohogi nire dena vanue Ijib. Ngerehi ru vora atagu ram huri na huqe wagineu nora tangaloi doluegi ngehi dalire, me ram huduhudu lawera. Ram vai na Huqe mo mero‪‬, ");
INSERT INTO omb_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","huri ram siregi Huqe me ram tabana noi Tagaro me ngere huqe vavinegi. ");
INSERT INTO omb_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Tavohe Huqe mo merogi nire Israel mo betera sulo limara tangaloi vuro sao ramo wehire me ramo balu na nora vai gineu. Huqe mo siregi nire sulo limara nora tavalui vuro ngerehi ram toga dalire. Lo taro hi ngere Israel rahe vai lai tea vena rain labe lo nagoi nora tavalui vuro. ");
INSERT INTO omb_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Lo taro hi ram vano lolo vuro, limei Huqe mo eno vovohire mo vai asisigi nire mwere hi nge u veve me u haharigi. U gagarasi lawuagi lawera tau Israel. ");
INSERT INTO omb_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Siu me Huqe mo ragasire na tangaloi vagamwasoi me ramo vagamwasoire Israel dena limara tangaloi vuro. ");
INSERT INTO omb_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Me tangaloi tau Israel hateve rau rongo na leo nora tangaloi vagamwasoi, me ram dori mwere na vavine huri turegi lo tagure huqe wagineu me ram huduhudu lawera. Ram begi siseri dena turegi ngehi retubure rau dige lune me rai ronghuri leo hora noi Huqe tea. ");
INSERT INTO omb_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Lo taro hi Huqe mo ragasi na nora tangaloi vagamwasoi, Huqe mo toga meire tangaloi vagamwasoi. Ngeie mo vagamwasoire dena limei nora tavalui vuro lolo taro nora tangaloi vagamwasoi, huri Huqe mo hagavire lo taroi nora raveana huri ngerehi ram vai asisigi nire me ram vai gagarasigi nire. ");
INSERT INTO omb_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Me lo taro hi tangaloi vagamwasoi u mate, me ram tudori ramo vai gineu rau esi liu retubure. Ram dige mo hurire huqe wagineu vena rain tabana nora, me vena rain huduhudu lawera. Ram rao siregi na nora doridori esi mena turegi na qatusiaga. ");
INSERT INTO omb_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Mo vai i Huqe mo mero lawuagi meire Israel me mo veve vena, “Huri a sinobu lehe he huri na nogu waratau siaga tea hi nau veve lawe tubure me hateve rau ronghuri na dilogu, ");
INSERT INTO omb_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","siu neu nain he livusi na buri sinobu lehe tea ngerehi ram toga mwaso mosigei tavohe Jesua u mate beno. ");
INSERT INTO omb_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Neu nain veire huri siu rain vailehire Israel vena ngere Israel rain huri na nogu turegi me rain dige lune mwerei retubure sige hatie.” ");
INSERT INTO omb_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Me Huqe mo siregi na buri sinobu hi ram toga. Nge he livusire tea vena siseri, me hateve u betera sulo limei Jesua. ");
INSERT INTO omb_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","Ngelehe buri sinobu ngehi Huqe u siregi nire rau tirendu, nge mo vailehire doluegi tau Israel lure. Ngerehi Israel rau mwaso lo taro hi rai ilo na vuro tea lolo vanue Kenan ");
INSERT INTO omb_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","(nge hogosie mo huhui reneture Israel ve rain vei vuro mwere hi rai ilo na vai vuro tea lo taro vano beno): ");
INSERT INTO omb_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","Ngere ratahigi gailime nora tau Balistaen, meire ngere tau Kenan, meire tau Sidon, meire tau Hivi ngehi rau toga lo vusi sao Lebenon tavuigi lo Vusi Bal Heremon mo dadari Lebo Hamat. ");
INSERT INTO omb_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","Sinobu ngerehi ram toga vena ngeie vin vailehire tau Israel vena ngere rain tabe na leohora noi Huqe ngehi ngeie u bete lawe retubure duruhi Mosis sige hatie. ");
INSERT INTO omb_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","Tangaloi tau Israel ram toga lo livugara tau Kenan, meire tau Hiti, meire tau Amoro, meire tau Beris, meire tau Hivi, meire tau Jebus. ");
INSERT INTO omb_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","Ngere Israel ram lai reneture vavine vuragi gaihorara, me ngere Israel ram bete reneture vavine lawe reneture mwera ngere talo tavalugi ram vuragi gaihorara. Me ngere Israel ram maraga ram tabana noi nora huqe sao.");
INSERT INTO omb_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Me siu Samuel mo lawua, me Huqe mo tino meie. Huqe he siregi na leo noi Samuel tea vena soi talo tano. ");
INSERT INTO omb_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Me doluegi Israel tavuigi Dan mo dadari Bereseba ngere rau ilo ve Huqe mo rivu Samuel mwere na nona tangaloi ligoligogi. ");
INSERT INTO omb_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Me Huqe mo vomai tuqaravu lo Saelo, huri mo vosangie lawe Samuel lo Saelo duruhi na nona leo. ");
INSERT INTO omb_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Samuel u voragi na tangaloi vevegi lolo Israel lolo rani doluegi hinge u mwaso lolona. ");
INSERT INTO omb_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Vataha na higao mo dige lategi mo dali mo vano Betel mo vano Kilkal me Misba, mo vevegi nire tau Israel lolo ute ngere hi doluegi. ");
INSERT INTO omb_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Maraga mo tudori taligu mo vano Rama lo valena, me taie hi mo vevegi nire tau Israel. Me u vonda na vonda gogona noi Huqe. ");
INSERT INTO omb_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Lo taro tavohe i Samuel u sesea, mo tau netune mwera gairue rom vuragi nora tangaloi vevegi tau Israel. ");
INSERT INTO omb_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","I netune mwera togagi i Joel me henai netune tuegi su hurie i Abisa. Ngere rom voragi tangaloi vevegi lolo Bereseba. ");
INSERT INTO omb_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Siu renetune mwera rai dige tea lo nona turegi. Rau begi denie ram lai gineu lo turegi he vovohoi tea, me ram vevegi na tangaloi lo turegi he vovohoi tea. ");
INSERT INTO omb_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Siu sesea doluegi tau Israel ram galo bubugi, me ram vomai lobei Samuel lo Rama, ");
INSERT INTO omb_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","me ram veve lawea vena, “Nigo gu sesea, me netumu mwera rohe dige tea lo nom turegi. Go rivu na nomai ratahigi nge vin vevegi gamai mwereire sinobu doluegi lolo vanue dolue.” ");
INSERT INTO omb_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Lo taro hi ram veve vena, “Go rivu na nomai ratahigi vin vevegi gamai,” Samuel he havuhevu tea. Siu mo tataro lawe Huqe. ");
INSERT INTO omb_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Me Huqe mo veve lawe Samuel vena, “Rorontagi na leora tangaloi doluegi ngerehi rain veve lawego. Hateve rau rahagi nigo, nge i neu hi ram rahagi eu hurive neu a nora ratahigi gorora. ");
INSERT INTO omb_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Mwere doluegi na doridori ngehi rau vei mo tavuigi lo rani hi nau lei vohogi nire dena Ijib me mo dadari bagataha. Ram siregi eu me ram tabana lawe huqe saosao wagineu, siu ngere ram vai mwerehi vage lawego. ");
INSERT INTO omb_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Me siserigi lehe go rorontagi na leora nge i nigo goin veve siagagi lawera. Me goin matamwasaragi lawera vena, havagineu hi nora ratahigi vin vei, tavohe vin leogorora, siu vin vei mwerehi mo lado hurive u vovohoi.” ");
INSERT INTO omb_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Me Samuel mo veve na leo noi Huqe doluegi lawe na tangaloi ngerehi ram hui na ratahigi denie. ");
INSERT INTO omb_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Me mo veve vena, “Nge ngaha nge vin vuragi nomiu ratahigi, nge vin leogoro gimiu, vin vei mwerehi mo lado vena u vovohoi: renetumu mwera vin teure rain vuragi nona tangaloi jariot me tangaloi hosi. Me rain toa lo nagoi nona jariot doluegi. ");
INSERT INTO omb_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Nge vin rivure lalavasigi rain vuragi nona tomtomuegi nora teri vatusao, me tomtomuegi nora buri ngavulu gailime. Me vin taure lalavasigi rain geli momogagi nona tano, lalavasigi rain vile na gana hinaga matue. Taligu, lalavasigi rain vei na langoi vuro me lalangoi nona jariot. ");
INSERT INTO omb_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Me nge vin lei vohogi renetumiu vavine rain vuragi tangaloi vurei bonagi mwere digugu me rain vuragi tangaloi sasalawai me tangaloi quiqui. ");
INSERT INTO omb_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Ngeie vin lei vohogi na talumiu hi a gineu gagarea lolona, me dena talui bulemiu garo inuinu, siu dena talui oliv, go mo betera lawe na nona tangaloi tabana. ");
INSERT INTO omb_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Ngeie vin lei gategale den hangavulu lo bulemiu toli, me mwasi garo inuinu, go betera lawe na nona tangaloi gaihango me lawe na nona tangaloi tabana. ");
INSERT INTO omb_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Ngeie vin lei na nomiu tangaloi tabana mwera me a nomiu tangaloi tabana vavine, me a bulemiu bulugi gagarea mena bulemiu donki saosao, me ngeie vin tambara lo nona tabana. ");
INSERT INTO omb_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Ngeie vin lei gategale den hangavulu lo bulemiu nani, mena sibsib me gimiu nein vuragi nona tangaloi tabana. ");
INSERT INTO omb_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Lo rani hi gimiu nein ngara huri buluiana dein ratahigi ngehi neu teue, nge i Huqe vin he duvi gimiu tea lo rani hi.” ");
INSERT INTO omb_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Ngere sinobu ram rao ve rain rorongtagi na leoi Samuel, me ram veve vena, “Hatie! Nge gamai gam tarani na ratahigi goro gamai. ");
INSERT INTO omb_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Siu gamai gain mwere na buri sinobu wagineu ve nomai ratahigi ngeie vin vevegi gamai me vin tomuegi gamai, me vin qalo nomai vuro.” ");
INSERT INTO omb_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Me Samuel mo rorongtagi na leo doluegi nora tangaloi, me mo valuhuri na leora lawe Huqe. ");
INSERT INTO omb_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Siu Huqe mo veve lawe Samuel vena, “Rorontagi nire me goin teu na nora ratahigi.” Me Samuel mo veve lawera tau Israel vena, “Gimiu gagategalegi nein mule lo vanue miu.” ");
INSERT INTO omb_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Huqe mo veve lawe Samuel vena, “?Vi dadari tagaha nigo goin hahagavi huri Sol? Nge neu nau rahagi nie ve vin ratahigi goro Israel. Horongi na nom laha gena vurei me gom vano, nain hora go lawe Jesi, tangaloi tau Betlehem. Nau vilewahe netune gategale lawe au ve vin vuragi ratahigi.” ");
INSERT INTO omb_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Siu Samuel mo veve vena, “?Nain vano mwere hilogo? Tareve i Sol vin rongo au, vin ue vaga mate au.” Me Huqe mo veve vena, “Goin lei na bulugi mwane meigo me goin veve vena, ‘Neu nam vomai huri na hure bonboni laweHuqe.’ ");
INSERT INTO omb_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Me goin veve, i Jesi vin vomai lo hure bonboni me nai haharagi lawego havagi goin vei. Me goin sasavi na vurei gogona ngehinge lo tangaloi ngehi nain vevea lawego.” ");
INSERT INTO omb_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Siu Samuel mo vai mwere hi Huqe u veve lawea. Mo vomai Betlehem, me ngere sesea tau lolo vanue renge ram matagu tavohe ram vano lobena. Me ram veve vena, “?Gom vomai mena tamwata?” ");
INSERT INTO omb_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Me Samuel duvi vena, “Neu nam vomai mena tamwata; huri na hure bonboni lawe Huqe. Gimiu nein toga gogona, me nein vomai mei eu lo hure bonboni.” Siu ngeie mo vai gogonagi Jesi mei renetune mwera me nge mo veve lawera vena rain vomai lobena lo hure bonboni. ");
INSERT INTO omb_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Siu lo taro tavohe ram vomai me nge mo lehi Eliab me nge mo lado vena, “Io hogo, tangaloi ngehi Huqe u vile wahea vena nai vureie nge lehe mo labe.” ");
INSERT INTO omb_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Nge Huqe mo veve lawe Samuel vena, “Mese leo lo nagona me qaravune huri nau rahagi nie beno. Ba huri neu nam leo hateve mwere hi tangaloi mo leo. Tangaloi nge mo lehe lo tarabehine, nge neu nam leo lolo dinmwango na.” ");
INSERT INTO omb_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Siu Jesi mo ware Abinadab me mo vaie mo dige utu lo nagoi Samuel. Nge Samuel mo veve vena, “Taligu Huqe nge he vile wahea tea.” ");
INSERT INTO omb_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Siu Jesi mo vai Sama mo dige utu lo nagoi Samuel, nge Samuel mo veve vena, “Taligu, Huqe nge he vile wahea tea.” ");
INSERT INTO omb_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Me Jesi u vei netune mwera gaibitu ram dige utu lo nagoi Samuel, nge Samuel mo veve lawe Jesi vena, “Huqe nge he vile wahera tea.” ");
INSERT INTO omb_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Me Samuel mo hui Jesi vena, “?Netumu ngere belehe?” Me Jesi mo veve vena, “Tahigi redu mo tino mosigei. Mo leogoro na sibsib.” Me Samuel mo veve lawea vena, “Go hora na tangaloi na vano hurie me na laie, huri nain toga tea vuine vin hurive da gagani vin dadari mo vomai talehe.” ");
INSERT INTO omb_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Siu Jesi mo hora na tangaloi mo vano hurie, me mo laie. Ngeie a vulune u memea, u garea tatarise, me mo gabisie. Me Huqemo veve vena, “Ngeie hi, maraga gom sasavi na vurei gogona lune.” ");
INSERT INTO omb_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Me i Samuel mo lai na laha hi a vurei lolona mo vureie Devet lo livugei retuana. Siu siserigi hi a Vui noi Huqe mo vomai lui Devet lo ranigi hi mo vano. Siu Samuel mo maraga mo vano Rama. ");
INSERT INTO omb_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Siserigi hi ngere Balistaen mena nora tangaloi vuro vena rain qalo, me rau galo bubugi Soko lolo vanue Juda. Ram toga bubugi tahinge Damim lolo Ebes lo livugei Soko me na Aseka. ");
INSERT INTO omb_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Sol me i ngere Israel ram vumai bubugi lolo waluwelu tahinge Ela, me ramo tau vurugegi nire vena ran qalo meire tau Balistaen. ");
INSERT INTO omb_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Ngere Balistaen ramo labe lo vusi gategale lo tavului welu me ngere tau Israel ramo labe tavului vusi, me waluwelu lo mahogi lo livugara. ");
INSERT INTO omb_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Me a tangaloi huire gategale ngeie tau Kat, mo mwalue dena siusiu nora Balistaen, a henana i Kalaiot. Qaravune sugu gaiono dumu gategale. ");
INSERT INTO omb_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Me a gairoqoi qatune rau veie lo vatu meraga me gaitugoroi luqe mo luqegi nie lo betune a vatu meraga, a mavagi mwere na vatu wuwerigi teri vagalime. ");
INSERT INTO omb_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Gairoqoi garune rau veire lo vatu meraga, me a nona gaimenu rau veie lo vatu meraga mo sanga lo livugei siqana. ");
INSERT INTO omb_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Nona gaituru mwere na sili gamali, a qatugi aean a mavagi mo mwere na vatui woro ngavulu gairue domwa gailime. Tangaloi mo wali na nona gaisingi mo vano tomuegi nie. ");
INSERT INTO omb_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Kalaiot mo labe me mo waregi lawera ngere tau Israel. “Huri havai nem mai nem labegi vurugegi hurive da qalo? Hateve i neu tau Balistaen me gimiu tangaloi noi Sol? Nen vile wahe na tangaloi gategale na himei lobengu. ");
INSERT INTO omb_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Tarevena ngeie vin vei lei vena vin wehi eu nain mate, gamai gain voragi nomiu tangaloi tabanagi. Tarevena neu nain vei lei ve nain wehie vin mate, gimiu nein voragi nomai tangaloi tabanagi. Siu nein tabana nomai.” ");
INSERT INTO omb_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Me Kalaiot mo veve vena, “Lo rani lehe nam leo savi gimiu tangaloi vuro tau Israel! Ne bete lawe au a tangaloi goron vui ue.” ");
INSERT INTO omb_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Tavohe Sol ram rongo na leo noi tangaloi tau Balistaen hi, me ngere doluegi tau Israel ram matagu liu garagara me ram rongoe u esi garagara. ");
INSERT INTO omb_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Devet netui tangaloi gategale tau Evrat a henagi tuegi Betlehem lolo vanue Juda. Henai tamana i Jesi. Netune mwera ngere gaiwelu, me lolo taro noi Sol, i Jesi u sesea vohogi. ");
INSERT INTO omb_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Me netui Jesi gaitolu togagi rau vano ram huri Sol lolo vuro: Togagi henana i Eliab; su hurie i Abinadab; me gaitoligi i Sama. ");
INSERT INTO omb_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Devet ngeie a tahigi redu. Me retogana gaitolu rau huri Sol. ");
INSERT INTO omb_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Tuqaravu i Devet u tudori taligu dein Sol vena leogoro na sibsib bulei tamana Betlehem. ");
INSERT INTO omb_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Lolo rani ngavulugaivesi tangaloi tau Balistaen hinge mo vumai kakarani mo labe vataha robongi me revirevi. ");
INSERT INTO omb_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Me i Jesi mo veve lawe netune mweragi Devet vena, “Go lai na sasalawai ngere lehe me na bereti hangavulu ngere lehe siseri lawe retuemu ram toga bubugi lo tanoi vuro. ");
INSERT INTO omb_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Me siu go lai na utei hinaga ngere lehe hangavulu lawe na tomtomuegi nora u teri. Me goin lehi retuemu siu goin vumai taligu gom veve hurive wuraha meire.” ");
INSERT INTO omb_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Ngere tora Sol me na tangaloi ngere doluegi tau Israel lolo waluwelu hinge Ela, ram qalo meire tau Balistaen. ");
INSERT INTO omb_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Lolo robongi siaga Devet mo siregi na sibsib ta lo tanoi leohuri nora tangaloi leogoro sibsib, mo lai na hinaga me mo vano, mwere hi Jesi u dedegi. Ngeie u dadari lo tanogi hinge ram toga bubugi taie tavohe a tangaloi vuro ram ngarangaragi me ram vano ram lai tanora vena rain qalo. ");
INSERT INTO omb_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Me ngere tau Israel me ngere tau Balistaen ram labegi na vuro ram vui leoleo. ");
INSERT INTO omb_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","I Devet u membu siregi na nona gineu ngere hi lobena tangaloi mo leogoro getei hinaga, mo toa mo vano lobera ram labegi vuro me mo hui retuana vena rau mwere hilogo. ");
INSERT INTO omb_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Me tavohe mo gato meire, Kalaiot, ngeie tau Balistaen a tangaloi gilu garea tau Kat, mo mwalue dena burigi me mo ngarangaragi siaga mwere hi tamwere me mo vaivei lolohaga, me i Devet mo rongoe. ");
INSERT INTO omb_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Tavohe tangaloi doluegi tau Israel ram lehi na tangaloi hinge, ngere ram toa denie me ngere ram matagu lawagi. ");
INSERT INTO omb_vpl VALUES ("S117_25","010_17_25","1SA","17","25","26","Me ngerehi tau Israel ram veve vena, “Nem lehi na tangaloi mo tuhuri mo vumai. Ngeie mo vumai vena saogi nire tau Israel.” Me Devet mo hui dena tangaloi ram labe lobena vena, “?Havagineu i ratahigi vin vei lawe na tangaloi ngehi vin ue vagamate na tangaloi tau Balistaen hinge me vin lei vohogi na maleana lehe dena Israel? Tangaloi tau Balistaen lehe hateve rau tevegigilegi nie tea me ngeie a tangaloi vurogi. Ngeie u vei asisigi na henai tangaloi vuro noi Huqe Mauri Vagituei.” Me ngere ram veve vena, “I ratahigi vin bete na gineu gagarea lawe na tangaloi ngehi vin wehi na tangaloi lehe vin mate. Ngeie vin bete netune vavine vena vin legi meie me vin lei vohogi denie mei rehavana rain mese tuli homu lawe na ratahigi tau Israel.” ");
INSERT INTO omb_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Me ngere ram veve lawea vena, “Ngaha havagineu i ratahigi vin vei lawe na tangaloi hine hi vin wehie vin mate.” ");
INSERT INTO omb_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Me tavohe Eliab, i tuei Devet togagi, mo rongoe mo gato lawe na tangaloi, mo vaie Eliab a merona mo mwere na avi mo mui su lawe Devet. Me mo hui vena, “Huri na havagi gom himei talehe? Me gu teu na sibsib wewerigi ngerehi lawe hine lolo vanue vurogi? Nau iloe mwere hilogo a nomu sagesage mena domimu hinge asigi; gom vumai hogosie hurive gon leo vuro.” ");
INSERT INTO omb_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Devet mo veve vena, “Nau vei na havagi? Hurive neu nai mese gato?” ");
INSERT INTO omb_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Siu mo talele dori lawe na tangaloi dolue me mo veve na leo mwerehi teu, me tangaloi ngere ram duvi lawea mwere hi tomue. ");
INSERT INTO omb_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Me ngere ram rongo‪‬ na leoi Devet. Me ram veve serea lawe Sol, me i Sol mo hora hurie. ");
INSERT INTO omb_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Devet mo veve lawe Sol vena, “Dominde na mese soi lo valuhuri tangaloi lehe tau Balistaen; Nomu tangaloi tabanagi vin vano mo gilu meie.” ");
INSERT INTO omb_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Sol mo duvi, “Nigo goi vei telai vena goin vano goin gilu me na tangaloi lehe tau Balistaen; nigo a mwalagelo vohogi, me ngeie a tangaloi vuro tavohe mo mwalagelo tau mo dadari bagataha.” ");
INSERT INTO omb_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Nge i Devet mo veve lawe Sol vena, “Nomu tangaloi tabanagi mo leogoro sibsib bulei tamana. Tavohe a laion sige a bea mo mai vena wali vohogi na sibsib dena burigi, ");
INSERT INTO omb_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","Nam hurie mo vano nam wehie me nam wali vohogi na sibsib dena singona. Me tavohe mo tudori huri eu, Nam wiri lo vulune me nam wehie mo mate. ");
INSERT INTO omb_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Ngere vunu a laion mena bea; Nom tangaloi tabanagi u ue vaga matera; Tangaloi lehe tau Balistaen hateve rau tevegigilegi nie siu vin mwere laion mena bea, ba huri mo vaivei lolohaga mena tangaloi vuro noi Huqe Mauri Vagituei.” ");
INSERT INTO omb_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Devet mo veve vena, “Huqe ngehi u lei vohogi eu dena limei laion me dena limei bea ngeie vin lei vohogi eu dena limei tangaloi tau Balistaen.” Sol mo veve lawe Devet vena, “Go vano, me i Huqe ngeie meigo.” ");
INSERT INTO omb_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Sol mo luqegi Devet gena luqana. Me mo tau na luqe gaitugoroi vuro lune me a gairoqoi qetu rau veie lo vatu meraga lo qatune. ");
INSERT INTO omb_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Me Devet mo vai raraie, buei vuro mo taue lolo luqana me mo dige samwegi, ba huri hateve u luqegi nire tau, ngeie mo veve lawe Sol vena, “Nain vano tea lai me na gineu ngere, ba huri neu hateve nau hangovire mosigei.” Siu ngeie mo lai vohogi nire. ");
INSERT INTO omb_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Me mo lai na nona gaitigo lo limana me mo vile na vatu gailime rau minu dena matewelu, mo taure lolo gete, mena nona talivava lo limana, me mo vano kakarani lobei Kalaiot. ");
INSERT INTO omb_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Siserigi lehe Kalaiot mo vumai huri Devet, me na tangaloi mo wali na gaisingi betune mo tomue. ");
INSERT INTO omb_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Tavohe i Kalaiot mo lehi Devet, me mo leosavie, mo lehie hurivena ngeie u biti dena maresu mwera, a vulune u memea mo gabisie. ");
INSERT INTO omb_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Kalaiot mo veve lawe Devet huri vena, “?Neu a wiriu huri gom vomai huri eu mena gai?” Me Kalaiot mo tagaroagi asisigi Devet lo henai nona huqe saosao. ");
INSERT INTO omb_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Me mo veve lawea vena, “Go vumai lobengu nain bete na tarabesi mu lawe na manu lolo mahava me lawe na kankarue tau lolo songo!” ");
INSERT INTO omb_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Me i Devet mo veve lawe Kalaiot vena, “Go vumai vovohi eu gena buei vuro me na gaituru mena gaimenu, nge i neu nain vomai vovohoi go lo henai Huqe Managi, Huqe nora tangaloi vuro tau Israel ngeie hi gom vaivei lolohaga meie. ");
INSERT INTO omb_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Lo rani ngelehe i Huqe vin bete go tau lolo limegu, me nain wehi go, goin taqao vuine me nain tei utu na qatumu. Lo rani ngelehe nain bete na betui tangaloi vuro tau Balistaen lawe na manu lolo mahava me lawe na kankarue tau lolo songo! Me lolo ureure doluegi rain iloe huri vena lolo Israel a nora Huqe Mauri lure. ");
INSERT INTO omb_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Tangaloi doluegi ram tino talehe. Siu rain iloe vena hateve gena buei vuro, sige a gaimenu, huri Huqe ngeie a huireana vin qaragi na vuro lehe siu ngeie vin bete gimiu doluegi talolo lime mai.” ");
INSERT INTO omb_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Tavohe Kalaiot mo vano mo kakarani lobena vena wehie, Devet mo toa siseri suvovohoie vena ron gilu. ");
INSERT INTO omb_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Siu mo haga ta lolo nona gete mo roa na vatu, mo siugi nie mo hogo lo raei Kalaiot. A vatu hinge u soro ta lolo qatune, mo soi lo nagona sulo tano. ");
INSERT INTO omb_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Devet qaragi Kalaiot gena talivava me na vatu: Mo totogie mo soi ta vuine mo mate, hateve gina buei vuro lolo limei Devet. ");
INSERT INTO omb_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Devet mo toa mo labe gagaliue. Mo lai na nona buei vuro dena tanogi. Siu mo ue vagamatea, mo tai vohogi na qatune gena buei vuro noi Kalaiot sibona. Tavohe ngere tau Balistaen ram leo nora tangaloi huire u mate, ngere ramo tudori me ram toa. ");
INSERT INTO omb_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Siu ngere sinobu tau Israel me Juda ramo ngarangaragi vuro me ramo hurire ngere tau Balistaen mo dadari Kat me lo matai ara Ekron. Ram wehire ram vui mategi lo turegi mo vano Ekron mo dadari lo matai ara Ekron me Kat. ");
INSERT INTO omb_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Tavohe sinobu ngere tau Israel rau livusire tau Balistaen mo rovo, ram tudori vano ram wali vohogi na nora gineu doluegi. ");
INSERT INTO omb_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Devet mo lai na qatui tangaloi tau Balistaen me mo vano meie Jerusalem; mo tau na nona langoi vuro lolo nona vale siusiu. ");
INSERT INTO omb_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Tavohe i Sol mo lehi Devet mo vano lobei Kalaiot, ngeie mo veve lawe Abna tomtomuegi nora tangaloi tau lolo vuro vena, “?Netui hine mwalagelo mwera lehe?” Abna mo duvi lawea vena, “Mwere hi gom toga Ratahigi, neu nau haroe.” ");
INSERT INTO omb_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","I Ratahigi mo veve vena, “Gon haqea huri vena, ‘?Netui hine mwalagelo mwera hinge?’” ");
INSERT INTO omb_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Tavohe Devet mo tudori u wehi Kalaiot, Abna mo laie mo vano meie lawe Sol, me a qatui Kalaiot hinge mo wiribibie tau lolo limana. ");
INSERT INTO omb_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Sol mo huie, “?Nigo netui hine mwalagelo mwera?” Devet mo veve vena, “Neu i netui ‬nom tangaloi tabanagi Jesi tau Betlehem.” ");
INSERT INTO omb_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Devet mo siregi Kat mo salavohogi mo vano lolo malanga Adulam. Tavohe i retuana me i rehavai tamana lo vale ram rongo hurie, ngere ram hivo tahinge lombena. ");
INSERT INTO omb_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Ngere doluegi ram toga lo romasi me lavasigi a bugure lategi sige ram tarani na gineu hateve ram laie ram ara dalie, siu me mo voragi nora tomtomuegi. Lategi tangaloi vudolue vaga vesi ngere bulu. ");
INSERT INTO omb_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Tahinge Devet mo vano lo vanue renge hi Misba lolo Moab me mo veve lawe na ratahigi tau Moab vena, “Goin siregi lei vena i tamangu me i retahingu roin vumai roin tino lombemu vin dandari lune neu nain iloe vena havai hi Huqe vin vei laweau?” ");
INSERT INTO omb_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Siu ngeie mo siregi nire lombei ratahigi tau Moab, me ram tino ngere bulu tavohe Devet ngeie lolo ara tugoro. ");
INSERT INTO omb_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Maraga a tangaloi ligoligogi Kat mo veve lawe Devet vena, “Mese tino lolo ara tugoro. Go vano lolo vanue Juda.” Me i Devet mo siregi mo vano lolo tamatue i ute Heret. / Sol mo wehi na tangaloi toretore tau Nod ");
INSERT INTO omb_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Siseri lehe i Sol mo rongo hurive i Devet mena nona tangaloi rau haqera. Siu i Sol, a gaimenu lolo limana, u toga lolo vavai gai a Tamaris lo vusi Kibea, mena nona tangaloi tambanagi doluegi ram lambe dalie. ");
INSERT INTO omb_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","Sol mo veve lawera vena, “Nen rongo, gimiu ta Benseman! Netui Jesi vin bete talu ngere hi mena viniat lolona lawe gimiu? Ngeie vin vei gimiu doluegi nein voragi tomtomuegi nora teri mena tomtomuegi nora ngere vudolue? ");
INSERT INTO omb_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","Ngehi havagi mo vaie gimiu doluegi nem qalo meieu? Hateve tangaloi gategale vena u veve laweau tavohe i netungu u vei na waratau siaga mei netui Jesi. Gimiu gategale hateve u romasi huri eu sige veve lawe au huri vena i netungu u veie a nongu tangaloi tambana mo taqao rarai eu, mwere hi mo vai bagataha.” ");
INSERT INTO omb_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Maraga i Doek tau Edom, ngeie mo lambe mena tangaloi tambana noi Sol, mo veve vena, “Neu nau lehi na maresu mwera netui Jesi u vumai lombei Ahimelek maresu mwera netui Ahitub Nob. ");
INSERT INTO omb_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","Ahimelek mo hui dein MAURI hava gineu vin vei meie; me mo bete leo gaiture mena buei vuro noi Kalaiot tau Balistaen.” ");
INSERT INTO omb_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Me i ratahigi (Sol) mo hora huri na tangaloi toretore hi i Ahimelek netui Ahitub mei rehavai tamana doluegi, ngere a tangaloi toretore tau Nob, me ngere doluegi rau vumai lombei ratahigi. ");
INSERT INTO omb_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Sol mo veve vena, “Siseri hi go rorontagi, a maresu mwera netui Ahitub.” / ngeie mo duvi vena, “Io nongu mauri,” ");
INSERT INTO omb_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Sol mo veve lawea vena, “Huri na havai gom qalo meieu, ningo tomu netui Jesi, gom bete na bereti mena buei vuro me gom hui huri dein Huqe huri eu, siu huri vin qalo meieu me mo tagaragi eu me mo tino ragi eu, mwere hi mo vai bataha?” ");
INSERT INTO omb_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Ahimelek mo duvi lawe Sol vena, “Dena tangaloi nom tambanagi doluegi, hine hi u veve hogo mwerei Devet, ngehi i qeligei ratahigi, a tomtomuegi nomu matagoro rau lando mavagi nie lolo valemu? ");
INSERT INTO omb_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","A rani lehe nam bei hui turegi lehe dein Huqe hurie? ngehi hatie! Mese siregi ratahigi mo qalo mei nom tangaloi tambana sige rehavai retamana, huri neu tangaloi nom tambanagi nahe ilo na havagi tea lolo gineu doluegi lehe.” ");
INSERT INTO omb_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Maraga i ratahigi mo veve vena, “Ningo goin mate hogo, Ahimelek, ningo mei rehavai tamamu doluegi.” ");
INSERT INTO omb_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","Me i ratahigi mo veve lawe na nona tangaloi mo lambe lo mwararana: “Nen tudori me nem wehi na tangaloi toretore noi MAURI, ba ngere vage ram bulu lo tavalugi mei Devet. Ngere rau iloe vena mo salavohogi, siu me rahe veve serea tea laweau.” / Maraga tangaloi tambanagi noi ratahigi ram rongoe hateve u garea vena rain heu limara vena rain wehi na tangaloi toretore noi MAURI ");
INSERT INTO omb_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Ratahigi mo hora Doek, “Ningo go tudori vano me gom wehi na tangaloi toretore ngerehi.” Me Doek ngeie tau Edom mo tudori mo vili tulire. Lo ranigi hi ngeie u wehi na tangaloi ngavulu gaiwelu domwagi gailime ngere hi ram wali na ebhot. ");
INSERT INTO omb_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Me ngeie u teu na buei vuro vage Nod, a togagi venue nora tangaloi toretore ngere hi, meire mweragi mena vavinegi, a maresu mena maresu ngere hi ram titi teu, me bulugi, donki mena sibsib. ");
INSERT INTO omb_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Maraga i Abiata, a mwera netui Ahimelek a mwera netui Ahitub, u toa sasavohogi mo bulu mei Devet. ");
INSERT INTO omb_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","Mo veve lawe Devet vena i Sol u wehi na tangaloi toretore noi MAURI. ");
INSERT INTO omb_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","Siu i Devet mo veve lawe Abiata vena: “A rani hi, tavohe i Doek tau Edom ngeie tahinge, nau ilo vurugegi vena ngeie vin veve lawe Sol. Mateana noi rehavai tamamu doluegi mo eno laweau. ");
INSERT INTO omb_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Go tino lombengu; mese matagu; a tangaloi hi mo hingesi go ngeie mo hingesi eu vage. Ningo goin mwaso lo tanoi nongu leogoro.”");
INSERT INTO omb_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Lo tagugi a ratahigi mo toga surigi lolo valena me a Huqe mo bete lawea mangana dena nona tavalui vuro sao doluegi dalie, ");
INSERT INTO omb_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","ratahigi mo veve lawe Natan tangaloi ligoligogi, “Neu nge, nam toga lolo vale rau veie lo gai siaga a tora, nge a Angai Waratau noi Huqe Mauri mo eno mo sigei lolo vale siusiu.” ");
INSERT INTO omb_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Natan mo duvi lawe ratahigi vena, “Havagi mo eno lolo domimu, vano gom vaie, ba huri i Huqe ngeie meigo.” ");
INSERT INTO omb_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Nge lolo bongi hinge a leo noi Huqe mo vumai lawe Natan, mo veve vena: ");
INSERT INTO omb_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“Go vano go veve lawe nongu tangaloi tabanagi Devet, ‘Nge lehe a havai i Huqe u veve: Hatie, nigo goin mese bulu na valengu vena nain toga lolona. ");
INSERT INTO omb_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Neu hateve nau toga lolo vale lo tarogi hi neu nau laire ngere Israel dena Ijib mo dadari bagataha. Neu nau gilu lategi lolo vale siusiu mo voragi valengu. ");
INSERT INTO omb_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Lolo ute ngere hi nam gilu lategi meire Israel doluegi, neu nau veve lawe na nora tomtomuegi vena rain tomuegi na nongu sinobu tau Israel, nge i neu hateve nau veve lawera vena. “Huri na havai gohe vutu na valengu tea lo gai siaga hi a tora?”’ ");
INSERT INTO omb_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Siu siserigi lehe, goin veve lawe na nongu tangaloi tabanagi Devet vena, ‘Nge lehe a havai i Huqe Managi u veve: Nau leigo dena duvu garea, me dena nomu tabana hi gom tomuegi sibsib, vena goin voragi leogoroi nongu sinobu tau Israel. ");
INSERT INTO omb_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Nau dige meigo tavohe gom vano logo logo, me nau vei vohogi doluegi na nomu tavului vuro denigo. Siserigi lehe neu nain vei na henamu vin lawoa, mwere na henara tangaloi lalawoa tau lolo ure. ");
INSERT INTO omb_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","Me neu nain vei rarai na tantano huri na nongu sinobu tau Israel siu nain vei rarai hurire huri vena ngere rai togagi venue sibora me rain mese tatu taligu. A tangaloi esi rain mese saugi nire taligu, mwere hi rau vei lo tavuigi, ");
INSERT INTO omb_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","siu nau vei lo tavuigi nau vile wahe na tangaloi vagamwasoi sao goro na nongu sinobu tau Israel. Mwerehi, neu nain bete lawego vage mangana dena nomu tavului vuro. A Huqe mo veve matamwasaragi lawego huri vena i Huqe sibona vin vei ragasi na babagi lo ratahigi lumu: ");
INSERT INTO omb_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Tavohe goi mate goin manga mei retubumu, neu nain ragasi na babagi lui netumu, ngeie hi netumu sibomu, me neu nain teu na nona ratahigi goro. ");
INSERT INTO omb_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Ngeie hi vin vutu na vale huri na henagu, siu nain teu na herei nona ratahigi goro vagituei. ");
INSERT INTO omb_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Neu nain voragi tamana, me ngeie vin voragi netungu. Tavohe mo vai gineu esi neu nain gagavoe gena gaitatali, mwerehi tangaloi ram tatali reneture. ");
INSERT INTO omb_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Nge a nongu vaigarea vin he vano te vohogi denie, mwere hi nau lei vohogi den Sol, ngehi nau lei vohogi siu nigo goin voragi ratahigi. ");
INSERT INTO omb_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Me dena babagi hi lumu mena nomu ratahigi goro vin eno vagituei lo nagongu, heremu vin teuana vagituei.’” ");
INSERT INTO omb_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Natan mo veve na leo ngere hi doluegi lawe Devet mwerehi i Huqe u vosangie lawea. ");
INSERT INTO omb_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","Me i ratahigi Devet mo vano mo toga lo nagoi Huqe, me mo veve vena, “Huqe Lawoa: I neu a tangaloi vurogi, me lo babagi hinge neu lune vage, huri i nigo gu vei eu nam voragi na ratahigi. ");
INSERT INTO omb_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","Nge mwere vena he tatarise tea lo matamu, Huqe Lawoa, nigo gu veve vage huri na taro mo vumai mo sigei huri lo babagi lui nomu tangaloi tabanagi. Huqe Lawoa, neu a tangaloi hogosie! ");
INSERT INTO omb_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","Neu nahe navu na gineu tea vage denigo,Huqe Lawoa ba huri nigo gu ilo na nom tangaloi tabanagi. ");
INSERT INTO omb_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","Mo huri na nomu leo me mo huri na nomu tarani, nigo gu vei na gineu lalawoa me mo vaie mo vosangi ana lawe na nomu tangaloi tabanagi. ");
INSERT INTO omb_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","Huqe Lawoa, nigo gu lawoa garagara hogo. Hate gategale mwereigo, hate Huqe vage nge i nigo hogosie, mwerehi gau rongo gena qero mai sibomai. ");
INSERT INTO omb_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","Me hate tangaloi rau mwereire nomu sinobu tau Israel. A burigi gategale hogosie ngehinge i nigo gu vagamwasoire vena rain voragi nomu sibomu. Me gu vei na henamu sibona. Me gu vei gineu lalawoa gagarea, siu huri gu livusi na taureure sao mena nora huqe sao dena nom sinobu, ngerehi gu vagamwasoire dena Ijib. ");
INSERT INTO omb_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","Nigo gu vei na nom sinobu tau Israel mwere na nomu tavagi tuei. Me nigo, Huqe, gu voragi nora Huqe Mauri. ");
INSERT INTO omb_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","Me siserigi lehe, Huqe Gogona, go wiribibi tavagi tuei a waratau hinge gu vei huri na nomu tangaloi tabanagi mei renetune. Vai mwere hinge gu warataugi, ");
INSERT INTO omb_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","siu huri a henamu vin lawoa tavagi tuei. Siu sinobu rain veve vena, ‘I Huqe Managi huire garagara a Huqe goro na Israel!’ Me a babagi lo nomu tangaloi tabanagi Devet vin veiana lolo matamu mwerehi gom tarani. ");
INSERT INTO omb_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","Huqe Managi, Huqe Mauri tau Israel, nigo gu haharagi lawe na nomu tangaloi tabanagi, vena, ‘Neu nain ragasi na babagi lo ratahigi lumu.’ Huri tangaloi nom tabanagi u hamqe na gaiture lo tataro a tataro hi lawego. ");
INSERT INTO omb_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","Huqe Lawoa, nigo a Huqe Mauri! Nom leo rau hogo, me nigo gu warataugi na gineu gagarea lawe na nom tangaloi tabanagi. ");
INSERT INTO omb_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","Siserigi hi goin rongo garea huri goin vei gareagi na babagi lo nom tangaloi tabanagi, hurive vin vano rorongo tavagi tuei lolo matamu; huri nigo HUQE Lawoa gu veve, siu mena nomu vaigareagi lo babagi hi lo nom tangaloi tabanagi vin garea tavagi tuei.”");
INSERT INTO omb_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","Rehobom u vano Sekem, huri ngere Israel doluegi rau vano taie vena ran taue na vuragi ratahigi. ‬ ");
INSERT INTO omb_vpl VALUES ("K112_2","012_12_2","1KI","12","2","2","Tavohe Jerobom mo rongoe ngeie tau mosigei Ijib huri u toa dei ratahigi Solomon dena vanue Israel. Mo siregi Ijib mo tudori mo vano lo vanue Israel. ");
INSERT INTO omb_vpl VALUES ("K112_3","012_12_3","1KI","12","3","3","Ngere tau Israel ram hora hurie ram vomai doluegi bubugi ram veve lawe Rehobom vena: ");
INSERT INTO omb_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","“I tamamu Solomon u teu na tabana mava lumei, nge siserigi hi nigo go vaie na tabana siaga hi na mamarae. Siu gamai gain tabana nomu.” ");
INSERT INTO omb_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","Rehobom mo duvi, “Nen vano a rani gai gaitolu vin liliu nemo vomai taligu lombegu.” Me a tangaloi ram mule taligu. ");
INSERT INTO omb_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","Siu ratahigi Rehobom meire sesea ngerehi rau tamba mei tamana Solomon tavohe mo toga mwaso. Mo hui vena, “?Gimiu nei veve vena nai duvi na tangaloi ngere ngaha wuraha?” ");
INSERT INTO omb_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","Ramo duvie, “Tareve bagataha goin vuragi nora tangaloi tabanagi me goin gato garea meire, me gom duvi vurugegi nire, rain vuragi nom tangaloi tabanagi tuqaravu.” ");
INSERT INTO omb_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","Nge i Rehobom u rahagi na tovotovo nora sesea me mo hingehinge dena mwalagelo mwera ngere rau sesea bubugi, ram vuragi na nona tangaloi tovotovo. ");
INSERT INTO omb_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","Mo huire vena, “?Nomiu tovotovo a havai? ?Dai duvi na tangaloi ngerelehe wuraha? Huri rau veve laweau vena, ‘Gon vai na tabana mava tamamu u teue lumei na mamarae.’” ");
INSERT INTO omb_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","Ngere mwalagelo mwera hi rau sesea bubugi meie ram duvi, “Goi veve lawe na tangaloi ngerehi rau veve lawego vena, ‘Tamamu teu na tabana mava lumei, nge go vai na nomai tabana na mamarae,’ veve lawera vena, ‘A bisungu bisu biti u matolu dena tanoi wesi tamangu. ");
INSERT INTO omb_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","Tamangu u teu lumiu tabana mava; Neu nain veie vin mava liue. Tamangu u gavogo gena gaiteli tangaloi; Neu, nain gavogo gena ginei garo volae.’” ");
INSERT INTO omb_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","Lo rani gai toligi, Jerobom mena tangaloi doluegi rau tudori lobei Rehobom mwerei ratahigi u veve, “Nein vumai taligu lombegu lo rani gaitoligi.” ");
INSERT INTO omb_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","I ratahigi u duvi gagarasigi na leogi lawera tangaloi. U rahagi na tovotovo mo beteana lawea dena sesea. ");
INSERT INTO omb_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","Me mo huri na tovotovo nora mwalagelo me move, “Tamangu u vei na nomiu tabana u mava; Neu nain veie vin mava liue. Tamangu u gavo gimiu gena gaiteli tangaloi; Neu nain gavo gimiu gena kinei garo volae.” ");
INSERT INTO omb_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","I ratahigi he rorontagi nire tangaloi tea, huri a taroi kineu lehe mo vai u vumai deni Huqe, huri ve a leoi Huqe na woro mwere hi Huqe u veve lawe Ahisa tau Silo me i Ahisa mo veve lawe Jerobom netui Nebat. ");
INSERT INTO omb_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","Tavohe ngere Israel doluegi ram leo ve i ratahigi he rorontagi nire tea, ram duvi na ratahigi, “I Devet gamai gai taranie tea. Netui Jesi gamai gai iloe tea. Vagabui Devet go leohuri na nom babagi lui tubumu! Ginde tau Israel da mule lolo noda siusiu!” Siu ngere tau Israel ram mawahe ram mule vano lo nora siusiu. ");
INSERT INTO omb_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","Nge i ngere tau Israel hi ram toga lolo vanue renge sao noi Juda, lo taro hi ram toga lo tanoi leogoro noi Rehobom mosigei. ");
INSERT INTO omb_vpl VALUES ("K112_18","012_12_18","1KI","12","18","18","Ratahigi Rehobom u hora Adoram, a tangaloi hi mo vai na tangaloi ve ran tabana siaga, nge i ngere Israel doluegi rau buguri vagamatea. Ratahigi Rehobom, mo galo lo bulana sariot mo toa vano mo toga Jerusalem. ");
INSERT INTO omb_vpl VALUES ("K112_19","012_12_19","1KI","12","19","19","Siu ngere tau Israel ramo qalo vohivohi na babagi lui Devet mo vumai mo dadari bagataha. ");
INSERT INTO omb_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Tavohe ngere Israel doluegi ram rongo huri ve i Jerobom u mule, ram hora warea vumai lo nora kalo bubugi, me ram taue mo ratahigi goro na Israel doluegi. A lulugi hogosie lui Juda rau huri rorongogi na babagi lui ratahigi Devet. ");
INSERT INTO omb_vpl VALUES ("K112_21","012_12_21","1KI","12","21","21","Tavohe Rehobom u dadari Jerusalem, mo ware bubugi nire doluegi lo babagi lui Juda me a babagi lui Benseman. Ngere u teri vaga vudolue vagategale avigi ngavulu gaiwelu hogo tangaloi vuro huri ve ngere rain vai na vuro mei retuara tau Israel. Siu ngere rain lai tuguhi na tanoi ratahigi Rehobom i netui Solomon. ");
INSERT INTO omb_vpl VALUES ("K112_22","012_12_22","1KI","12","22","22","Nge a leo lehe noi Huqe Mauri u vumai lawe Semaia a tangaloi ligoligogi noi Huqe Mauri: ");
INSERT INTO omb_vpl VALUES ("K112_23","012_12_23","1KI","12","23","23","“Go veve lawe Rehobom netui Solomon, ratahigi tau Juda, lo babagi lui Juda doluegi, mei Benseman, me lawe na sinobu lavasigi vage, vena, ");
INSERT INTO omb_vpl VALUES ("K112_24","012_12_24","1KI","12","24","24","‘Nge lehe a havai i Huqe u veve: Mese hage ve go vai vuro vohivohi retuemiu, tau Israel. Gimiu doluegi ne mule lo tano miu, huri ngaha a nogu dedegi.’” Siu ram tabe na leo noi Huqe ram mule taligu, mwerehi i Huqe u veve. ");
INSERT INTO omb_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","Siu i Jerobom mo hagovi na ute Sekem lolo vusi vanuei Evrem me mo toga taie. U maraga taie mo vano mo hangovi na ute Benuel vage. ");
INSERT INTO omb_vpl VALUES ("K112_26","012_12_26","1KI","12","26","26","Jerobom mo ladolado gahea move, “Siserigi lehe a tanoi leogoro vi tudori taligu lo bambagi lui ratahigi Devet. ");
INSERT INTO omb_vpl VALUES ("K112_27","012_12_27","1KI","12","27","27","Tareve tangaloi ngerelehe rai hage tamwere ve ran vai na nora hure bonboni lo sara gogona noi Huqe lolo Jerusalem taligu, a domire vin huri na nora huqegi, Rehobom ratahigi tau Juda. Rain ue vagamate au me rain tudori lobei ratahigi Rehobom.” ");
INSERT INTO omb_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Lo tagui nona hingehinge lo leogi, i ratahigi u vei na nunui bulugi mwalagelo gairue gena vatu homu. Mo veve lawera tangaloi, “Gimiu neu hage Jerusalem u tatarise beno, O Israel, a nomiu huqe ngere, ru lei gimiu dena vanue Ijib.” ");
INSERT INTO omb_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","U teue tuegi lo ute hi Betel, me u teue tuegi lo ute hi Dan. ");
INSERT INTO omb_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","Siu a gineu lehe u vuragi na asiana; a tangaloi rau vumai ram galohagi nie hi Betel, me ram vano Dan ram galohagi nie hi tuegi. ");
INSERT INTO omb_vpl VALUES ("K114_1","012_14_1","1KI","14","1","1","Lo taro hi Abisa netui Jerobom mo sege. ");
INSERT INTO omb_vpl VALUES ("K114_2","012_14_2","1KI","14","2","2","Me i Jerobom mo veve lawe tubui lo valena, “Go maraga go tau goro na nagomu huri a tangaloi rain mese ilogo huri ve i nigo i tubui lo valengu. Siu goi vano Saelo, taie hi tangaloi ligoligogi i Ahisa u veve lawea au hurive nain ratahigi goro na tangaloi ngere. ");
INSERT INTO omb_vpl VALUES ("K114_3","012_14_3","1KI","14","3","3","Me lo limemu goin lei na bereti hangavulu mena kek te gaivihe me a lahai hani, me gom vano lobena. Ngeie vin veve na havagi vin vei lawe na maresu mwera lehe.” ");
INSERT INTO omb_vpl VALUES ("K114_4","012_14_4","1KI","14","4","4","Me nge mo vai mwere hi Jerobom u horae, mo maraga me mo vano Saelo mo vano lo valei Ahisa. I Ahisa hi vei lei tea vena lehi na vavine hi ba matana ru dodo huri u sesea. ");
INSERT INTO omb_vpl VALUES ("K114_5","012_14_5","1KI","14","5","5","Me Huqe mo veve lawe Ahisa, “I tubui lo valei Jerobom mo vomai ve na hinke leo denigo huri netune mo sege, me nigo goin duvie mwere. Tavohe mo dadari, vin vei huri ve nge a tangaloi dolue.” ");
INSERT INTO omb_vpl VALUES ("K114_6","012_14_6","1KI","14","6","6","Tavohe i Ahisa mo rongo na dumi garune lo matai turegi, move, “?Tubui lo valei Jerobom go soro. Huri havai gom vaie huri ve nigo a tangaloi dolue? U horau mena roro asi lawego. ");
INSERT INTO omb_vpl VALUES ("K114_7","012_14_7","1KI","14","7","7","Go vano gom veve lawe Jerobom, ‘Nge lehe a havai i Huqe, a Huqe Mauri noi Israel, u veve: “Nau ragasigo dena sinobu me nau rivugo gom tomue goro na nogu tangaloi Israel. ");
INSERT INTO omb_vpl VALUES ("K114_8","012_14_8","1KI","14","8","8","Nau heve vohogi na tanoi ratahigi dena babagi lui ratahigi Devet me nau betea lawego, nge hateve gu mwerei na nogu tangaloi tabanagi i Devet, ngeie u wiribibi na nogu leohora. Me u huri eu gena loloi domine, mo vai na havai u vovohoi hogosie lolo mataku. ");
INSERT INTO omb_vpl VALUES ("K114_9","012_14_9","1KI","14","9","9","Nigo gu vei na gineu esi u liure rau toga tomue. Gu bolo na nom huqe wagineu, a nunui huqe gairue lo vatu homu; gu vutu na merongu me gu labe dorigi eu. ");
INSERT INTO omb_vpl VALUES ("K114_10","012_14_10","1KI","14","10","10","Huri hi, neu nain hora na tatuana vin hivo lure lo babagi lui Jerobom. Nain tei vohogi na mwera doluegi dena babagi lui Jerobom: ngerehi tangaloi lalawua me ngere tangaloi vurogi. Nain hure vohogi na babagi lui Jerobom ngere mwera doluegi vin mwerehi a tangaloi mo hure vohogi na qatuisongo. ");
INSERT INTO omb_vpl VALUES ("K114_11","012_14_11","1KI","14","11","11","Wiriu rain genire hi lui Jerobom ram mate lolo vanue renge, me a manu rai genire hi ram mate lolo vanue.” I Huqe u vevea beno!’ ");
INSERT INTO omb_vpl VALUES ("K114_12","012_14_12","1KI","14","12","12","Nge i nigo go mule taligu. Nge tavohe goi dadari lolo nom vanue renge, a maresu mwera hi vin mate. ");
INSERT INTO omb_vpl VALUES ("K114_13","012_14_13","1KI","14","13","13","Israel doluegi rain ngara hie siu rain tulegi nie. Ngeie gategale hogosie lui Jerobom rain tulegi nie, huri nge hogosie lo babagi lui Jerobom i Huqe i Huqe Mauri noi Israel u haqe na gineu garea lune. ");
INSERT INTO omb_vpl VALUES ("K114_14","012_14_14","1KI","14","14","14","I Huqe vin rivu na nona ratahigi goro na Israel, ngeie vin tei vohogi na babagi lui Jerobom. U tevuigi beno lo rani bagataha. ");
INSERT INTO omb_vpl VALUES ("K114_15","012_14_15","1KI","14","15","15","Me I Huqe vin wehire tau Israel me ngere rain rurururu. Me ngere rain ruru mwere na ere mo ruru lolo wai. Nge vin sara vohogi na tangaloi tau Israel dena tano garea ngehi u betea lawe retamara, siu vin geburegi nire rain gagaliu na wai meuri Evaretes, huri rau vutu na meroana noi Huqe gena nora beru noi huqe vurogi Asera. ");
INSERT INTO omb_vpl VALUES ("K114_16","012_14_16","1KI","14","16","16","Huqe vin siregi nire Israel huri na asiana noi Jerobom. Huri u vagasile tau mo vai na Israel ram vagasile.” ");
INSERT INTO omb_vpl VALUES ("K114_17","012_14_17","1KI","14","17","17","I tubui lo valei Jerobom mo maraga mo mule taligu vano Tisa. Tavohe mo dadari lo mataituregi valena maresu mwera hi mo mate. ");
INSERT INTO omb_vpl VALUES ("K114_18","012_14_18","1KI","14","18","18","Mwerehi i Huqe u veve lawe na nona gaihora tangaloi ligoligogi Ahisa, Israel ram tangihie siu ram tulegi nie. ");
INSERT INTO omb_vpl VALUES ("K116_29","012_16_29","1KI","16","29","29","Lo higaoi Asa ratahigi tau Juda, mo dadari ngavulu gaitolu domwa gaiwelu, Ehab netui Omri, mo vuragi na ratahigi tau Israel, me ngeie u leogoro na Israel higao ngavulu gairue domwa gairue lolo vanue renge Samaria. ");
INSERT INTO omb_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","I Ehab netui Omri u vei na gineu sao rau esi lolo matai Huqe denire ngere rau toga tomue siu mobei ngeie. ");
INSERT INTO omb_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Ngeie u vei na asiana rau sao mwerei Jerobom netui Nebat, nge u veie u liue, mo lagi mei Jesebel netui Etbal ratahigi tau Sidon, me ngeie mo tavuigi mo tabana noi Tagaro vurogi me mo huduhudu lawea. ");
INSERT INTO omb_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","Nge u tabe na vondai hure bonboni lawe Tagaro vurogi lolo valei Tagaro vurogi, ngehi u tabea lolo Samaria. ");
INSERT INTO omb_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","I Ehab u vei na berui huqe vurogi Asera vage me u vei na gineu u sao mo vai ragasi na meroana noi Huqe, i Huqe Mauri nora tau Israel, denire ratahigi rau toga tomuegi nie. ");
INSERT INTO omb_vpl VALUES ("K116_34","012_16_34","1KI","16","34","34","Lolo taro noi Ehab, i Hiel tau Betel mo vei huri na Jerigo taligu. Tavohe mo tavuigi na tabana, i netune mwera togagi i Abiram mo mate. Tavohe nge mo vagasigi na tabana i netune tahigi i Segub mo mate, mo eno lo leo noi Huqe mwerehi Jesua netui Nun u veve. ");
INSERT INTO omb_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Siseri lehe i Elaeja, tau Tisbi lolo vanue Kiliad, mo veve lawe Ehab vena, “Namo haharigi lo henai Huqe, i Huqe Mauri nora tau Israel hi mo mwaso, ngehi neu nam tabana lawea, a endano vin hatie sige a uhe lolo higao ram vumai mosigei teu vin dadari lune i neu nain veve.” ");
INSERT INTO omb_vpl VALUES ("K117_2","012_17_2","1KI","17","2","2","Siu a leo noi Huqe mo vomai lawe Elaeja vena, ");
INSERT INTO omb_vpl VALUES ("K117_3","012_17_3","1KI","17","3","3","“Goin siregi hano, goin liliu sulo matenaho mo galo me goin hili lolo halai wai Kerit, lo tavalui Jodan suvohi na matenaho mo galo. ");
INSERT INTO omb_vpl VALUES ("K117_4","012_17_4","1KI","17","4","4","Goin inuinu dena halai wai matamata, me neu nain hora na manu revin hurive rain bete na hinaga lawe go taie.” ");
INSERT INTO omb_vpl VALUES ("K117_5","012_17_5","1KI","17","5","5","Siu mo vai mwerehi i Huqe u vevea lawea. Ngeie mo vano sulo halai wai Kerit, lobei Jodan lune matenaho mo galo. Me mo toga taie. ");
INSERT INTO omb_vpl VALUES ("K117_6","012_17_6","1KI","17","6","6","A revin ram wali na hinaga mena gabigigi lolo rombongi me hinaga mena gabigigi lolo revirevi lawea, me mo inuinu dena halai wai matamata. ");
INSERT INTO omb_vpl VALUES ("K117_7","012_17_7","1KI","17","7","7","Lo tagugi he rimbi tea a halai matamata hi mo mamaha huri he uhe tea lolo vanue. ");
INSERT INTO omb_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Siu a leo noi Huqe mo vumai lawea vena, ");
INSERT INTO omb_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","“Go vano siseri Sarevat lolo vanue Sidon me gom toga taie. Neu nau hora na vavine mandue tau lo ute hi ve vin bete na hinaga lawego.” ");
INSERT INTO omb_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Siu nge mo vano Sarevat. Tavohe nge mo vomai lo mataituregi vanue renge, a vavine mandue mo vile avi. Nge mo ware su vano lawea me mo hui, “?Huri ve gon lai na wai biti lolo laha i nan inue?” ");
INSERT INTO omb_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Tavohe vavine hi mo vano ve na laie, nge mo ware, “Etue, me goin lei na tavisei bereti te biti lawe au.” ");
INSERT INTO omb_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Ngeie mo duvi vena, “Namo haharigi lo henai nomuHuqe Mauri mo mwaso, gangu hinaga hatie nge a vulaoa biti u tatarise mena qaqai lime lolo laha me a vureigi biti lolo laha. Neu nam vile bubugi na avi hogosire, ve na laire talo valengu me nai vei na hinaga huri eu mei netungu mwera, huri ve gori genie, siu gorom mate.” ");
INSERT INTO omb_vpl VALUES ("K117_13","012_17_13","1KI","17","13","13","Elaeja mo veve lawea move, “Go mese matagu. Go mule me gom vai na havai mwere gu vevea. Nge tomuegi goin vei na hinaga biti huri eu dena gamu hinaga mo eno. Me gom laie su vomai lawe au. Siu gom vai na hinaga huri go mei netumu. ");
INSERT INTO omb_vpl VALUES ("K117_14","012_17_14","1KI","17","14","14","Huri lehe havai i Huqe, i Huqe Mauri nora tau Israel u veve: ‘A lahai vulaoa vin he rovo te lai me a lahai vurei vin he mamaha tea, vin dadari lo rani hi a Huqe vin bete na uhe lolo vanue.’” ");
INSERT INTO omb_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Nge mo vano me mo vai na havagi hi i Elaeja u vevea lawea. Siu a hinaga mo eno vataha rani huri Elaeja me huri na vavine hi mei netune. ");
INSERT INTO omb_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Huri a lahai vulaoa he rovo tea me a lahai vurei he mamaha tea, mo huri na leo noi Huqe i Elaeja u vevea. ");
INSERT INTO omb_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Lo tagugi he rimbi tea a vavine hi mo leogoro na vale, i netune maresu mwera hi mo sege. Nge mo sege mo asi lawagi, me mo asi vohogi, me a mabuhine mo vano. ");
INSERT INTO omb_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Nge mo veve lawe Elaeja, “?Tangaloi noi Huqe Mauri, a nomu havagi vohivohi eu? ?Ve gu vomai huri ve goin veve raga na nongu asiana laweau me gom ue vaga mate netungu?” ");
INSERT INTO omb_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","I Elaeja mo duvi, “Go bete netumu laweau.” Nge mo laie dena limana, me mo walie su hage eulu lolo loloi vale hi lune ngeie mo toga, me mo guroe lo qeana. ");
INSERT INTO omb_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","Siu ngeie mo ngara hage lawe na Huqevena, “?O nongu Huqe Mauri, ve gu lei na romasi lawe na mandue ngaha neu nam toga meie, mo vai netune mo mate?” ");
INSERT INTO omb_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Siu nge mo eno bimbi na maresu mwera hi vaga tolu me mo ngara lawe na Huqe vena, “O nongu Huqe Mauri, go hagavi gamai, go siregi na mwasoana noi maresu mwera ngaha na mule taligu lawea!” ");
INSERT INTO omb_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","A Huqe mo rongo na ngarana noi Elaeja, me a mwasoana noi maresu mwera hi mo mule lawea taligu, me ngeie mo mwaso. ");
INSERT INTO omb_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","Elaeja mo ragasi na maresu hi taulu me mo walie su hivo vuine dena loloi vale hi eulu tau lolo vale vurugegi. Nge mo betea lawe retahine me move, “Gon lehe, i netumu u mwaso!” ");
INSERT INTO omb_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Siu a vavine hi mo veve lawe Elaeja vena, “Siseri lehe i neu nam ilo huri ve i nigo a tangaloi noi Huqe Mauri me a leo noi Huqe dena singomu a hogo.” ");
INSERT INTO omb_vpl VALUES ("K118_1","012_18_1","1KI","18","1","1","Lo tagui taro qaravu, lo higao gai toligi hi a aho huru u eno, a leoi Huqe mo vomai lawe Elaeja vena, “Go vano gon haharagi nigo sibomu lawe Ehab, me nain hora na uhe ta lolo vanue.” ");
INSERT INTO omb_vpl VALUES ("K118_2","012_18_2","1KI","18","2","2","Siu Elaeja mo vano vena haharagi nie sibona lawe Ehab. Siseri ngaha a maro u esi garagara lolo Samaria. ");
INSERT INTO omb_vpl VALUES ("K118_3","012_18_3","1KI","18","3","3","Me i Ehab mo ware Obadia ngeie mo leogoro na valei ratahigi. (Obadia ngeie a tangaloi ladomava siaga lo Huqe. ");
INSERT INTO omb_vpl VALUES ("K118_4","012_18_4","1KI","18","4","4","Tavohe Jesebel mo ue vagamate na tangaloi ligoligogi ngere hi noi Huqe, i Obadia u lei na tangaloi ligoligogi ngere vudolue me mo hiligi nire lolo malanga gairue, a ngavulu geilime lolona tuegi, me a ngavulu geilime lolo na tuegi, me mo bete na hinaga mena wai lawera.) ");
INSERT INTO omb_vpl VALUES ("K118_5","012_18_5","1KI","18","5","5","I Ehab u veve lawe Obadia vena, “Go vano turu na vanue sulo wai meuri mena baha doluegi. Bataha dain haqe na songo huri vin wiribibi na hosi mena miul rain mwaso siu dain mese ue vagamate na bulanda kankarue.” ");
INSERT INTO omb_vpl VALUES ("K118_6","012_18_6","1KI","18","6","6","Siu ngere ram wahegi na vanue ve ngere roin dige doluegi nire, i Ehab mo vano lo turegi dolue me Obadia lune tuegi. ");
INSERT INTO omb_vpl VALUES ("K118_7","012_18_7","1KI","18","7","7","Tavohe i Obadia mo dige mo vano, i Elaeja mo hangwea. Obadia mo leo hogosie, mo siolo suvine lo tano, me mo veve vena, “?Huri ve nigo hogo, nongu huqe Elaeja?” ");
INSERT INTO omb_vpl VALUES ("K118_8","012_18_8","1KI","18","8","8","Ngeie mo duvi vena, “Io. Go vano go veve lawe na nomu ratahigi vena, ‘I Elaeja ngeie talehe.’ ” ");
INSERT INTO omb_vpl VALUES ("K118_9","012_18_9","1KI","18","9","9","I Obadia mo hui vena, “?Nau vei na havagi u esi? Huri nigo gom bete na nomu tangaloi tabanagi vano lawe Ehab vena vin teue lo mateana. ");
INSERT INTO omb_vpl VALUES ("K118_10","012_18_10","1KI","18","10","10","A hogo mwerehi nomu Huqe Mauri mo mwaso, hate togagi venue sige a ara noi ratahigi u eno vurogi hurive a nongu ratahigi na higesi go. Me tareve a togagi venue sige a ara noi ratahigi rain veve hurive nigo hate taie, ngeie u veire ram haharigi siaga vena ngere rahi haqego tea. ");
INSERT INTO omb_vpl VALUES ("K118_11","012_18_11","1KI","18","11","11","Siu siseri ngaha goin veve laweau vena, ‘Nain vano lobei nongu ratahigi me nain veve lawea vena, “I Elaeja ngeie tau.’ ” ");
INSERT INTO omb_vpl VALUES ("K118_12","012_18_12","1KI","18","12","12","I neu nahe iloe tea vena Vui noi Huqe vin weligo su logo tavohe i neu nam siregi nigo. Tare neu nain vano me nain vevea lawe Ehab me i ngeie vin haqego tea, nge vin ue vagamate au. Maraga i neu nomu tangaloi tabanagi nau ladomava lo Huqe u tevuigi lolo nongu mwalagelo. ");
INSERT INTO omb_vpl VALUES ("K118_13","012_18_13","1KI","18","13","13","Ba huri bataha nigo goin rongo tea, havagi nau vei tavohe Jesebel mo ue vagamate na tangaloi ligoligogi noi Huqe. I neu nau hiligi na tangaloi ligoligogi noi Huqe vudolue lolo malanga gairue, ngavulu geilime lolona tuegi siu ngavulu geilime lolona tuegi, me nau bete na hinaga mena wai lawera. ");
INSERT INTO omb_vpl VALUES ("K118_14","012_18_14","1KI","18","14","14","Me siseri ngaha i nigo gom veve lawe au vena vano lobei nongu ratahigi me nain veve lawea vena, ‘I Elaeja nge tau.’ I ngeie vin ue vagamate au!” ");
INSERT INTO omb_vpl VALUES ("K118_15","012_18_15","1KI","18","15","15","I Elaeja mo veve vena, “Namo haharigi lo henai Huqe Managi hi mo mwaso, ngehi i neu nam tabana lawea, neu nain vosangi eu hogo sibongu lawe Ehab bagataha.” ");
INSERT INTO omb_vpl VALUES ("K118_16","012_18_16","1KI","18","16","16","Siu i Obadia mo vano lobei Ehab me mo vevea lawea, me Ehab mo vano lobei Elaeja. ");
INSERT INTO omb_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Tavohe nge mo lehi Elaeja, nge mo veve lawea vena, “?Ve nigo hingaha, gom vuragi na vui rongesi lolo vanue Israel?” ");
INSERT INTO omb_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","Me Elaeja mo duvi vena, “I neu hateve a vui rongesi lolo Israel. Nge nigo me lo babagi lui tamamu i gimiu neu veie. Gimiu neu siregi na leo hora noi Huqe me nigo gom huri na Tagaro vurogi. ");
INSERT INTO omb_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Siu siseri ngaha go ware na sinobu dena Israel doluegi ran bulu mei eu lo Vusi Kamel. Me goin lei na tangaloi ligoligogi ngere vudolue vaga vesi avigi ngavulu geilime noi Tagaro vurogi me ngere tangaloi ligoligogi noi Asera ngere vudolue vaga vesi, ngere hi ram gani lo hinaga gai Jesebel.” ");
INSERT INTO omb_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Siu Ehab mo hora na leo mo vano doluiegi na Israel me ram lai bubugi na tangaloi ligoligogi lo Vusi Kamel. ");
INSERT INTO omb_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","I Elaeja u vano tomuegi na sinobu me mo veve vena, “?Nem labe lo livugei ladolado gairue vin dadari tagaha? Tareve i Huqe ngeie i Huqe Mauri, nen hurie; nge tareve i Tagaro ngeie a huqe mauri hogo, nen hurie.” Nge sinobu rahe gesi dala tea. ");
INSERT INTO omb_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Siu Elaeja mo veve lawera vena, “I neu tangaloi ligoligogi noi Huqe gategale hogosie nam tino, nge i Tagaro vurogi nona tangaloi ligoligogi vudolue vagavesi avigi ngavulu gailime. ");
INSERT INTO omb_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","Gimiu nen lai na bulugi boegi gairue lawe gamai. Nen siregi nire ran vile wahe na nora gategale sibora, me nen siregi nire ran teve vurivurie me ram taue talo gai nge rain mese tau na avi lune. I neu nain vei rarai na bulugi tuegi me nain teue lo gai nge nain mese tau na avi lune vage. ");
INSERT INTO omb_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Siu nein ware lo henai nomiu huqe, me neu nain ware lo henai Huqe noi Ebraham, Aesak me Israel. A huqe nge vin duvi gena avi; ngeie a Huqe Mauri.” Siu a sinobu doluegi ram veve vena, “Gom veve na havagi hi u garea.” ");
INSERT INTO omb_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","I Elaeja mo veve lawe na tangaloi ligoligogi noi Tagaro vurogi vena, “Nen lai na bulugi denie tuegi me nem vagararaie tomue, huri gimiu neu sao. Nein wareware lo henai nomiu huqe, nge nein mese vagao na avi.” ");
INSERT INTO omb_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Siu ngere ram lai na bulugi hi u beteana lawera me ram vagararaie. Siu ngere ram wareware lo henai Tagaro vurogi, u tevuigi lolo robongi mo dadari lo matainaho mo tuvosa qatu. Ngere ram ngaragi, “O Tagaro gon duvi gamai!” Maraga hatie gaiduvigi, a tangaloi he duvi tea. Me ngere ram wetu dali na vonda hi ngere rau veie. ");
INSERT INTO omb_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Lo matainaho mo tu vosa qatu i Elaeja mo tiehire. Ngeie mo veve lawera vena, “Nen ngaragi siaga taligu! Hogo ngeie a huqe. Bataha ngeie mo ladolado lawuagi lolo domine, sige mo dige lategi, sige ngeie mo didige. Bataha ngeie mo maturu me ngeie vin maraga.” ");
INSERT INTO omb_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Siu ngere ram ngarangaragi mo siaga vagevage me ngere ramo gigirire sibora gena buei vuro mena gaimenu, mo huri na nora doridori, mo dadari daire ram hale. ");
INSERT INTO omb_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Lo matainaho mo begi, me ngere ram vai na nora leo waregi sere siaga hi mo dadari lo taroi hure bonboni lolo revirevi. Maraga hate gaiduvigi, a tangaloi he duvi tea, a tangaloi he rongora tea. ");
INSERT INTO omb_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Siu Elaeja mo veve lawe na sinobu doluegi vena, “Nen vomai teu lombegu.” Ngere ram vomai lobena, me ngeie mo vai huri na vondai hure bonboni noi Huqe, ngehi rau vei surisuri. ");
INSERT INTO omb_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","Elaeja mo wali na vatu hangavulu domwa gairue, hogo gategale mo tatarise mena babagi ngerehi rau hivo dein renetui Jekob, lawea hi a leo noi Huqe u vomai, mo veve vena, “A henamu vin vuragi Israel.” ");
INSERT INTO omb_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Ngeie mo bulu na vonda lo henai Huqe gena vatu ngere, me mo geli na walu dalie u lawua tatarise mena laqoloi vurugi wai ngavulu gairue huri ve vin horo lolona. ");
INSERT INTO omb_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","Ngeie mo tau tabe tabegi na gai lo vonda, mo teve vurivuri na bulugi me mo taure lo gai hi. Siu nge mo veve lawera vena, “Nen lingi na wai ta lolo bue vatu lalawoa gairue hogo ngadu hangavulu me nem dandae su lo hure bonboni hi, me ta lo gai.” ");
INSERT INTO omb_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","Ngeie mo veve vena, “Nen vaie taligu,” me ngere ram vaie taligu. Ngeie mo veve vena, “Nen vaie vagatolu,” me ngere ram vaie vagatoligi. ");
INSERT INTO omb_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","A wai hi mo hale mo hivo dali na vonda me vage mo horo lolo walu hi. ");
INSERT INTO omb_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Lo taroi hure bonboni hi, a tangaloi ligoligogi hi Elaeja mo labe me mo tataro vena, “O Huqe Mauri noi Ebraham, Aesek mei Israel, siregi nie na matamwasara lolo rani bagataha hurive i nigo i Huqe Mauri lolo Israel me i neu a nomu tangaloi tabanagi, me nau vei na gineu doluegi lo nomu leohora. ");
INSERT INTO omb_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","Go duvi eu, O Huqe, go duvi eu, huri tangaloi ngere ngaha rain iloe hurive nigo, O Huqe, i Huqe Mauri, me i nigo goin dori na domire vin tudori taligu.” ");
INSERT INTO omb_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Siu avi noi Huqe mo soi me mo gao na hure bonboni, a gai, a vatu mena tano, me mo sungu tantau na wai lolo walu hi. ");
INSERT INTO omb_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Tavohe sinobu doluegi ram lehi na gineu lehe, ramo soi suvine me ramo ngara ngaragi, “A Huqe ngeie i Huqe Mauri! A Huqe ngeie i Huqe Mauri!” ");
INSERT INTO omb_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Siu Elaeja mo veve vena, “Nen wiribibi na tangaloi ligoligogi noi Tagaro vurogi. Nen mese siregi nie gategale mo vano!” Ngere ram wiribibire, me Elaeja mo vaire ram laire mo hivo su lolo halai wai Kison me mo tai vaga matera taie. ");
INSERT INTO omb_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Me Elaeja mo veve lawe Ehab vena, “Go vano go gagani me gom inuinu, huri a roroi uhe lawua mo vomai.” ");
INSERT INTO omb_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Siu Ehab mo vano vena gagani me mo inuinu, nge Elaeja mo galo ta lo ului Vusi Kamel, mo siolo su vine lo tano me mo tau na nagona lo mahoi qaune. ");
INSERT INTO omb_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Ngeie mo veve lawe na nona tangaloi tabanagi vena, “Go vano me gon leo suvohi lo tahi.” Me nge mo hage aulu me mo veve vena, “Hate gineu taie,” I Elaeja u veve vaga bitu move, “Go vano taligu.” ");
INSERT INTO omb_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Vaga bitugi a tangaloi tabanagi mo bete na gaiduvigi vena, “A tailengi u biti mo mwere limei tangaloi mo maraga dena tahi.” Siu Elaeja mo veve vena, “Go vano go veve lawe Ehab vena, ‘Go tagaragi na bulemu jariot me gon hivo vine vaiteu a uhe mo tugoro go.’” ");
INSERT INTO omb_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","He rimbi tea, a mahava mo tavuigi mo maeto gena dondoi uhe, a langi mo maraga, a uhe mava mo vumai me i Ehab mo siregi mo toa su vano Jeserel. ");
INSERT INTO omb_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","A huireana noi Huqe mo hivo lui Elaeja, me mo vintegi na luqana ta lolo wasine, me ngeie mo toa tomuegi Ehab su vano Jeserel. ");
INSERT INTO omb_vpl VALUES ("K119_1","012_19_1","1KI","19","1","1","Siseri hi i Ehab u veve lawe Jesebel a gineu doluegi hi i Elaeja u veire me vage ngeie u ue vagamate na tangaloi ligoligogi doluegi hi noi Tagaro vurogi gena buei vuro. ");
INSERT INTO omb_vpl VALUES ("K119_2","012_19_2","1KI","19","2","2","Siu Jesebel mo hora na nona gaihora lawe Elaeja vena na veve lawea vena, “Lo taro mwere ngaha mavugo, nam veve hogo lawego nain wehigo mwere hi gu wehi na nogu tangaloi ligoligogi, u garea hurive nongu huqe rain ue vagamate au tareve nain veie tae.” ");
INSERT INTO omb_vpl VALUES ("K119_3","012_19_3","1KI","19","3","3","I Elaeja mo matagu me mo toa huri na nona mwasoana. Tavohe ngeie mo vumai Berseba lolo Juda, mo tau na nona tangaloi tabanagi taie. ");
INSERT INTO omb_vpl VALUES ("K119_4","012_19_4","1KI","19","4","4","Siu ngeie gahea mo vano a rani dolue lo hala hi su lolo vanue vurogi. Ngeie mo vomai sulo vui gai biti, mo toga vuine lo vavagi me mo tataro hurive ngeie na mate. Ngeie mo veve vena, “Neu nau weli na gineu ngaha u tatarise, Huqe. Go lai vohogi na nogu mwasoana; I neu hateve nau garea mwerei reduvingu ngerehi rau mate beno.” ");
INSERT INTO omb_vpl VALUES ("K119_5","012_19_5","1KI","19","5","5","Siu mo eno suvine lo vavai gai hi mo maturu. Tasiserigi hi a gaihora noi HUQE mo singelie me mo veve vena, “Go maraga me go gagani.” ");
INSERT INTO omb_vpl VALUES ("K119_6","012_19_6","1KI","19","6","6","Ngeie mo kileu dali bulu, me kakarani lobei qatune a bereti u quiana lo ului dirigni mwamwavi, mena lahai wai. Ngeie mo gani bereti me mo inu wai siu mo eno suvine taligu. ");
INSERT INTO omb_vpl VALUES ("K119_7","012_19_7","1KI","19","7","7","A gaihora noiHuqe mo vumai taligu vagatuegi me mo singelie me mo veve vena, “Go maraga me go gagani, huri a turegi u qaravu liu huri go.” ");
INSERT INTO omb_vpl VALUES ("K119_8","012_19_8","1KI","19","8","8","Siu ngeie mo maraga mo gani na bereti me mo inu na wai. Hinaga hi u veie mo huire, u lei na turegi rani ngavulu geivesi me bongi ngavulu geivesi me mo dadari Horeb, a vusi noi Huqe Mauri. ");
INSERT INTO omb_vpl VALUES ("K119_9","012_19_9","1KI","19","9","9","Taie hi ngeie mo soro ta lolo malanga me mo manga lolo bongi. Me a leo noi Huqe mo vumai lawea vena, “?Gom vai na havai talehe?” ");
INSERT INTO omb_vpl VALUES ("K119_10","012_19_10","1KI","19","10","10","Nge mo duvi mo veve vena, “O Huqe, Huqe Mauri Managi, neu nau romasi huri na Israel. Ngere rau siregi na nomu waratau siaga, rau vei surisuri na nomu vonda, me rau teu na nomu tangaloi ligoligogi sulo mateana gena buei vuro. I neu gategale hogosie nam tino, me siseri ngaha rave rain ue vagamate au vage.” ");
INSERT INTO omb_vpl VALUES ("K119_11","012_19_11","1KI","19","11","11","A Huqe move, “Go vano varea me gom labe lo vusi lolo ute gogona noi Huqe, huri i Huqe mo gangarani mo dige utu.” Siu a langi lawua u huire mo heregi vurivuri na vusi hi lategi me a vatu ram tavisevise lo nagoi Huqe, nge a Huqe hateve nge lolo langi hi. Lo tagui langi hi a ruru, nge a Huqe hateve ngeie lolo ruru hi. ");
INSERT INTO omb_vpl VALUES ("K119_12","012_19_12","1KI","19","12","12","Lo tagui ruru a avi mo vumai, nge a Huqe ngeie hatie lolona. Me lo tagui avi hi a dilo mo vomai rorongo mo ngutu. ");
INSERT INTO omb_vpl VALUES ("K119_13","012_19_13","1KI","19","13","13","Tavohe Elaeja mo rongoe, ngeie mo reve na luqana goro na nagona me mo mwalue su varea me mo labe lo matai malanga. Siu a dilo mo veve lawea vena, “?Gom vai na havai talehe?” ");
INSERT INTO omb_vpl VALUES ("K119_14","012_19_14","1KI","19","14","14","Ngeie mo duvi mo veve vena, “O Huqe, Huqe Mauri Managi, neu nau romasi huri na Israel. Ngere rau siregi na nomu waratau siaga, rau vei surisuri na nomu vonda, me rau teu na nomu tangaloi ligoligogi sulo mateana gena buei vuro. I neu gategale hogosie namo tino, me siseri ngaha ngere rave rain ue vagamate au vage.” ");
INSERT INTO omb_vpl VALUES ("K119_15","012_19_15","1KI","19","15","15","A Huqe mo veve lawea vena, “Go tudori lo hala hi gu vumai lune, me goin vano sulo vanue vurogi Damaskas. Tavohe gom dadari taie, goin vurei Hasael na vuragi ratahigi goro Aram. ");
INSERT INTO omb_vpl VALUES ("K119_16","012_19_16","1KI","19","16","16","Taligu, goin vurei Jehu netui Nimsi na ratahigi goro Israel, me goin vurei Elisa netui Savat dena ute hi Ebol Mehola na vuragi na tangaloi ligoligogi lo tanomu. ");
INSERT INTO omb_vpl VALUES ("K119_17","012_19_17","1KI","19","17","17","Jehu vin teu ra hine hi sulo mateana ngere hi rain toa dena buei vuro noi Hasael, me Elisa vin teu ra hine hi rain toa dena buei vuro noi Jehu. ");
INSERT INTO omb_vpl VALUES ("K119_18","012_19_18","1KI","19","18","18","Nge hatie huri nau wiri bimbire ngere teri vagabitu lolo Israel. Ngere qaure rahe sisiqeu tea lawe Tagaro vurogi me ngere a singora he sungunie tea.”");
INSERT INTO omb_vpl VALUES ("K212_1","013_12_1","2KI","12","1","1","Lolo higao gaibitu hi noi Jehu, Joas mo voragi na ratahigi, siu ngeie u leogoro na Jerusalem higao ngavulu gaivesi. Retahine henana i Sibia; ngeie tau lo vanue renge hi Bereseba. ");
INSERT INTO omb_vpl VALUES ("K212_2","013_12_2","2KI","12","2","2","Joas u vei na gineu rau garea lolo matai HUQE lolo higao ngerehi doluegi Jehoiada u haharae. ");
INSERT INTO omb_vpl VALUES ("K212_3","013_12_3","2KI","12","3","3","A ute gogona ngerehi ramo tataro taie, hateve rau lei vohogi nire; a sinobu ngerehi ramo hure bonboni me ramo bule na gineu buhoru taie mosigei. ");
INSERT INTO omb_vpl VALUES ("K212_4","013_12_4","2KI","12","4","4","Joas mo hora lawera tangaloi toretore noi HUQE vena, “ Nen vile bumbugi na mane rau bete mwereve a bete bete lawe na tantano gogona noi Huqe, a mane rau vile huri valu velui tangaloi, a mane mo vumai dena tangaloi huri nora waratau me a mane mo vumai lo domiana garea su lawe na tantano gogona. ");
INSERT INTO omb_vpl VALUES ("K212_5","013_12_5","2KI","12","5","5","Nen siregi na tangaloi toretore doluegi ran lai mane dena tangaloi ngerehi ramo leogoro mane, me nen siregi nie na vai huri na havagi hi mo hamqea vena u esi lolo tantano gogona.” ");
INSERT INTO omb_vpl VALUES ("K212_6","013_12_6","2KI","12","6","6","Nge lo higao ngavulu gairue domwagi gaitolu noi Joas tavohe mo ratahigi a tangaloi toretore ngerehi hateve rau vei vurugegi na gineu ngerehi rau esi lo tantano gogona. ");
INSERT INTO omb_vpl VALUES ("K212_7","013_12_7","2KI","12","7","7","Maraga ratahigi Joas mo ware na tangaloi toretore hi Jehoiada mena tangaloi toretore ngerehi lalavasigi vage me mo huire vena, “Huri havai gimiu nehe vai huri na gineu ngerehi tea rau esi lolo tantano gogona? Nei mese lai mane taligu dena tangaloi ngerehi ramo leo goro mane.” ");
INSERT INTO omb_vpl VALUES ("K212_8","013_12_8","2KI","12","8","8","Tangaloi toretore ngerehi ramo daragi vena ngere rain he vile te mane dena sinobu me vage ngere rain he vai huri na tantano gogona lai tea gahera. ");
INSERT INTO omb_vpl VALUES ("K212_9","013_12_9","2KI","12","9","9","A tangaloi toretore hi Jehoiada u lei na gesi me mo ahi durue lolona me a roqoigogogi lune. Mo taue lo mwararai vonda gogona, lo matue tavohe gategale mo soro na tantano gogona noi Huqe. ");
INSERT INTO omb_vpl VALUES ("K212_10","013_12_10","2KI","12","10","10","Me tavohe ramo leo hurive a mane u vumai lawoa lolo gesi, a tangaloi revereve lo valei ratahigi me a tangaloi tomtomuegi nora ngere ramo toretore romo vano, romo valu na mane hi rau teu ta lolo tantano gogona noi HUQE me romo taure ta lolo bagi. ");
INSERT INTO omb_vpl VALUES ("K212_11","013_12_11","2KI","12","11","11","Tavohe romo hamqe na tovogi, romo bete na mane hi lawe na tangaloi hi rau teue vena vin leo goro na tambana lo tantano gogona hi. Romo volire ngerehi rau tambana lo tantano gogona noi Huqe tangaloi rau bulubulu vale mena tangaloi rau vutuvutu vale, ");
INSERT INTO omb_vpl VALUES ("K212_12","013_12_12","2KI","12","12","12","A tangaloi tai vatu ngerehi. Ramo lai buli me ramo vagaminugi vatu huri vaihuri na tantano gogona noi HUQE, me ramo vai na bugui gineu lalavasigi vage huri na tantano gogona hi ramo vai hurie. ");
INSERT INTO omb_vpl VALUES ("K212_13","013_12_13","2KI","12","13","13","A mane u vumai lolo tantano gogona hateve rau voli gieu ngerehi rau veire lo vatu renige, a gineu ramo vai na wigi laiti lune, tantanoi wai huri ramo gaburegi, a tavue sige gineu lavasigi lo vatu meraga sige vatu renige huri na tantano gogona noi HUQE; ");
INSERT INTO omb_vpl VALUES ("K212_14","013_12_14","2KI","12","14","14","Ramo lai na mane hi huri ramo volire tangaloi tambana, me huri ramo voli na langoi vale tantano gogona noi HUQE. ");
INSERT INTO omb_vpl VALUES ("K212_15","013_12_15","2KI","12","15","15","Me hateve ramo leoleo lure hi ramo bete na mane vena rain volire tangaloi tabanagi, ba huri ngere ramo dori u garea vurugegi. ");
INSERT INTO omb_vpl VALUES ("K212_16","013_12_16","2KI","12","16","16","A mane betebete huri ramo sine Huqe me betebete huri doridori esi ngerehi hateve ramo soro lolo tantano gogona noi HUQE; ngerehi a nora tangaloi toretore. ");
INSERT INTO omb_vpl VALUES ("K212_17","013_12_17","2KI","12","17","17","Lolo taro hi, Hasael mo ratahigi Aram mo hage aulu me mo qalo meire Kat siu u qaragi nie. Me mo tudori vano mo wehire Jerusalem. ");
INSERT INTO omb_vpl VALUES ("K212_18","013_12_18","2KI","12","18","18","Nge i Joas ratahigi tau Juda u lei doluegi na gineu ngerehi rau tabutebu retamara Jehosabat, Jehoram me i Ahasia, ratahigi tu Juda, me a betebete hi ngeie sibona u betera me a vatu meraga doluegi rau haqera lolo tantanoi mane lo tantano gogona noi HUQE me lolo vale lawoa noi ratahigi, me mo horara lawe Hasael ratahigi tau Aram, siu ngeie mo rovo dena Jerusalem. ");
INSERT INTO omb_vpl VALUES ("K212_19","013_12_19","2KI","12","19","19","Huri na gineu ngere lavasigi rau veiana lolo taro noi Joas, me a gineu doluegi hi u vei, hateve rau uliana lolo bugu huri valu hurire ratahigi tau Juda? ");
INSERT INTO omb_vpl VALUES ("K212_20","013_12_20","2KI","12","20","20","Nona tangaloi ramo qalo me ramo ue vagamatea rorongogi nie tahinge Bet Malo, lo turegi mo hivo lo Sila. ");
INSERT INTO omb_vpl VALUES ("K212_21","013_12_21","2KI","12","21","21","A tangaloi tabanagi ngerehi rau wehie. i Josabat netui Simeat me i Jehosabat netui Soma. Ngeie u mate rau tulegi nie mei retamana lolo vanue renge noi Devet. Me i Amasia netune mo lai na tanona mwere na ratahigi. ");
INSERT INTO omb_vpl VALUES ("K217_1","013_17_1","2KI","17","1","1","Lolo higao hangavulu domwa gairue noi Ehas ratahigi tau Juda, Hosea i netui Ela mo vuragi na ratahigi tau Israel lolo vanue renge Samaria, me u ratahigi gorora higao gaisiwo. ");
INSERT INTO omb_vpl VALUES ("K217_2","013_17_2","2KI","17","2","2","Nge u galegale asi lo nagoi Huqe, ngeie hateve u esi lawuagi mwere na ratahigi ta Israel ngere tomue. ");
INSERT INTO omb_vpl VALUES ("K217_3","013_17_3","2KI","17","3","3","Salmanesa ratahigi tau Asaria u hamai vena qalo mei Hosea, nge i Hosea mo siregi nie sibona mo vano lo limei ratahigi ngehinge, me vataha higao ratahigi tau Israel mo tuli nona vatu homu mo vano lawe ratahigi tau Asaria. ");
INSERT INTO omb_vpl VALUES ("K217_4","013_17_4","2KI","17","4","6","I ratahigi tau Israel mo hora na tangaloi mo vano lobei ratahigi So tau Ijib hurive na buluie, me i ratahigi Hosea na mese tuli nona vatu homu mwerehi u tuli tomue. I ratahigi tau Asaria tavohe mo ilo na gineu ngaha mo hamai mo qaragi na vanue Israel, me ram tehi vohivohi Samaria me ram tugoroe higao gaitolu. Lolo higao gaisiwogi noi Hosea, a ratahigi tau Asaria u qaragi na vanue renge Samaria. Siu ratahigi tau Asaria mo wiribibi ratahigi Hosea me mo taue lo garovauveu. Me i ratahigi tau Asaria mo hora vohogi nire tau Israel vano Asaria. U teure ram toga lolo vanue Hala, me lolo vanue Gosan lobei Wai meuri Habo, me lolo vanue renge ngerehi tau Mede. ");
INSERT INTO omb_vpl VALUES ("K217_7","013_17_7","2KI","17","7","7","Huqe mo vai na gineu doluegi mwere ngaha huri ngere tau Israel rau galegale asi lo nagoi nora Huqe Mauri. U lei vohogi nire den limei ratahigi Vero lo vanue Ijib. Rau ladomavagi nire huqe wagineu, ");
INSERT INTO omb_vpl VALUES ("K217_8","013_17_8","2KI","17","8","8","me ram huri na doridori nora taureure i Huqe u gondo vohogi lo nagora. Ngere tau Israel ram huri na huhuiana hi nora ratahigi rau huhuire ginie. ");
INSERT INTO omb_vpl VALUES ("K217_9","013_17_9","2KI","17","9","9","Ngere tau Israel ram besegoro na bugure deni nora Huqe Mauri, a gineu ngerehi rahi vovohoi tea lo nagona. Mo tavugi lolo togagi venue mo vano mo dadari lolo vanue renge ngere sibora rau tabe na ute gogona lolo nora togagi vanue doluegi. ");
INSERT INTO omb_vpl VALUES ("K217_10","013_17_10","2KI","17","10","10","Ram tabe na vatu sao noi Tagaro vurogi ngerehi me beru sao noi Asera vataha na ului vusi me lo vavai gai lalawua. ");
INSERT INTO omb_vpl VALUES ("K217_11","013_17_11","2KI","17","11","11","Lo ute gogona doluegi ram hure na bulu buhoru, ram huri na huhuiana nora taureure tomue ngehi Huqe u livu vohogi denire beno. Ram vai na gineu esi ngere hi mo vai na Huqe mo lolo gagasi ginire. ");
INSERT INTO omb_vpl VALUES ("K217_12","013_17_12","2KI","17","12","12","Ram huduhudu lawe na huqe vurogi ngerehi, nge i Huqe u veve vena, “Nen mese vai na gineu ngaha.” ");
INSERT INTO omb_vpl VALUES ("K217_13","013_17_13","2KI","17","13","13","I Huqe mo veve siagagi lawera tau Israel me Juda duruhi re nona tangaloi ligoligogi vena, “Nen siregi na nomiu doridori esi. Nen hango bimbi na nongu leohora mena nongu leo tamwata, vin huri na huhuiana nau betea lawe retubumiu ve rain hango bimbire, me nau sere lue lawe gimiu duruhi na nongu tangaloi leo ligoligogi.” ");
INSERT INTO omb_vpl VALUES ("K217_14","013_17_14","2KI","17","14","14","Nge ngere tau Israel me Juda rai rorontagi tea me a qature rau siaga mwerei tamara, ngere rai ladohogo tea lo nora Huqe Mauri. ");
INSERT INTO omb_vpl VALUES ("K217_15","013_17_15","2KI","17","15","15","Ram rahagi na nona leo tamwata mena nona waratau siaga nge u vei mei retamara mena leo raga hui u bete lawera. Ram huri na huqe vurogi me ngere sibora vage ram voragi na gineu vurogi. Ngere ram lai na doridori tangaloi dalire hate huri i Huqe u veve lawera vena, “Nen mese vai mwere ngere ram vai,” nge ngere ram vai na gineu a Huqe u gato gorora ve rain mese vaie. ");
INSERT INTO omb_vpl VALUES ("K217_16","013_17_16","2KI","17","16","16","Ngere ram siregi na leohora noi nora Huqe Mauri me ram vai na nora nunui huqe vurogi gairue mwere na natui bulugi, me berui Asera. Ram huduhudu lawe na visiu me gineu doluegi lolo mahava me ram huduhudu lawei Tagaro vurogi. ");
INSERT INTO omb_vpl VALUES ("K217_17","013_17_17","2KI","17","17","17","Ram hure reneture mwera mena vavine voragi na hure bonboni lolo avi. Ngere ram hango mataduru, uviuvi me ram sogagi nire sibora me ram vai gineu esi lo nagoi Huqe, mo vaie mo mero lawagi. ");
INSERT INTO omb_vpl VALUES ("K217_18","013_17_18","2KI","17","18","18","Siu i Huqe mo merogi nire tau Israel me mo lai vohogi nire doluegi den nagona. Hogosie babagi lui Juda ram toga, ");
INSERT INTO omb_vpl VALUES ("K217_19","013_17_19","2KI","17","19","19","me Juda vage he hango bimbi na leohora tea noi nora Huqe Mauri. Ram huri na doridori wagineu nora tau Israel ram bei huhuire ginie. ");
INSERT INTO omb_vpl VALUES ("K217_20","013_17_20","2KI","17","20","20","Siu i Huqe mo rahagi nire sinobu doluegi tau Israel; nge mo arahire me mo siregi nire ram vano lo limara nora tavalui vuro vava mo gondo vohogi nire den nagona. ");
INSERT INTO omb_vpl VALUES ("K217_21","013_17_21","2KI","17","21","21","Tavohe mo heve vohogi na Israel dena babagi lui ratahigi Devet, ngere ram tau Jerobom i netui Nebat mo ratahigi nora. Me Jerobom mo vaire Israel ram soi rahe huri na Huqe tea nge mo vaire ram galegale asi u liu. ");
INSERT INTO omb_vpl VALUES ("K217_22","013_17_22","2KI","17","22","22","Ngere tau Israel ram dige lo turegi asiana noi Jerobom me rahi tudori tea denire, ");
INSERT INTO omb_vpl VALUES ("K217_23","013_17_23","2KI","17","23","23","mo dadari i Huqe mo livusire dena nagona, mwere u veve tau duruhi na nona tangaloi tabanagi ngere tangaloi ligoligogi. Siu ngere Asaria ram lai na sinobu tau Israel dena tanora sibora. Me ram toga tahi Asaria mo dadari bagataha. ");
INSERT INTO omb_vpl VALUES ("K224_1","013_24_1","2KI","24","1","1","Lo tarogi Jehoiakim mo ratahigi goro na vanue Juda, Nebukadnesa a ratahigi tau Babilon mo vumai Juda me na nona tangaloi vuro, mo tau na ratahigi Jehoiakim mo huri na nona tarani higao gaitolu. Nge lo tagui higao gaitolu Jehoiakim he huri na tarani noi Nebukadnesa tea. ");
INSERT INTO omb_vpl VALUES ("K224_2","013_24_2","2KI","24","2","2","I Huqe mo hora na tangaloi ngere tau Kaldea, ngere tau Aram, ngere tau Moab, me ngere tau Aman ram vumai ram vai na vuro mei Jehoiakim. Mo hora ra vena ran vai vohogi na vanue Juda, mwerehi a leo noi Huqe u toregiana denire nona tangaloi ligoligogi. ");
INSERT INTO omb_vpl VALUES ("K224_3","013_24_3","2KI","24","3","3","Hogo, a gineu ngere ngaha mo vai mo huri na leo noi Huqe, vena lai vohogi nire den nagona huri na galegale asi noi ratahigi Manase mena gineu doluegi u veire, ");
INSERT INTO omb_vpl VALUES ("K224_4","013_24_4","2KI","24","4","4","lo ulugi vage nge u ue vagamatera tangaloi rahe vai na gineu esi tea. Huri nge u vaga horongi na vanue renge Jerusalem gena dai tangaloi vovohoi sao, me i Huqe he tarani tea ve vin ladolado goro na bugune. ");
INSERT INTO omb_vpl VALUES ("K224_5","013_24_5","2KI","24","5","5","Me a gineu lavasigi vage ratahigi Jehoiakim u veire, tangaloi u uli na valuhuri na mwasoana nora ratahigi tau Juda. ");
INSERT INTO omb_vpl VALUES ("K224_6","013_24_6","2KI","24","6","6","Jehoiakim mo mate mo eno mei retubune. Me Jehoiajin netune mo voragi na ratahigi sesei tamana. ");
INSERT INTO omb_vpl VALUES ("K224_7","013_24_7","2KI","24","7","7","A ratahigi tau Ijib mena nona tangaloi vuro rahi mwelue tea taligu den tanora ve ra vai na vuro, ba ratahigi tau Babilon u lei vohogi na vanue hi dena limei ratahigi tau Ijib beno. Mo tavuigi lo halai wai Ijib mo dadari lo Wai Meuri Iveretis. ");
INSERT INTO omb_vpl VALUES ("K224_8","013_24_8","2KI","24","8","8","Tavohe Jehoiajin mo vuragi na ratahigi ta Juda higaona hangavulu domwa gaiwelu. U ratahigi vule gaitolu lolo vanue renge Jerusalem. Henai retahine Nehusta, netune vavine Elnatan; ngeie tau Jerusalem. ");
INSERT INTO omb_vpl VALUES ("K224_9","013_24_9","2KI","24","9","9","Ratahigi hi u galegale asi lo nagoi Huqe, mo huri na doridori esi noi tamana. ");
INSERT INTO omb_vpl VALUES ("K224_10","013_24_10","2KI","24","10","10","Lo taro hi tangaloi vuro noi Nebokadnesa ratahigi tau Babilon, ram tugoro ra dali na arai Jerusalem. Tangaloi ram toga lolona, ");
INSERT INTO omb_vpl VALUES ("K224_11","013_24_11","2KI","24","11","11","me ratahigi Nebukadnesa sibona u hamai lo vanue renge Jerusalem tavohe nona tangaloi vuro ram labe rarai vuro dalie. ");
INSERT INTO omb_vpl VALUES ("K224_12","013_24_12","2KI","24","12","12","Jehoiajin ratahigi ta Juda, i retahine, nona tangaloi tabanagi, nona tomtomuegi, me nona muei tangaloi lo valena, ram siregi nire lawea. Lo higao gaiwelugi lo tanoi leogoro noi ratahigi tau Babilon, mo lai Jehoiajin mo taue lolo garovauveu. ");
INSERT INTO omb_vpl VALUES ("K224_13","013_24_13","2KI","24","13","13","Mwere i Huqe u veve tau, Nebukadnesa mo lai vohogi na gineu gagarea rau eno lolo valei Huqe me dena valei ratahigi, me mo wali vohogi na gineu rau veire lo vatu homu. Ratahigi Solomon tau Israel u veire huri na vale gogona noi Huqe. ");
INSERT INTO omb_vpl VALUES ("K224_14","013_24_14","2KI","24","14","14","Me u weli vohogi na tangaloi doluegi ta Jerusalem: tomtomuegi doluegi me tangaloi huire mena tangaloi hibehibe gineu lo gai mena aean, a tovogi u teri vaga hangavulu. Hogosie mahoi tangaloi ngere saugi vohogi ram toga lolo vanue. ");
INSERT INTO omb_vpl VALUES ("K224_15","013_24_15","2KI","24","15","15","Nebukadnesa u lei Jehoiajin su vano Babilon. U lei ratahigi Jehoiajin mei retahine, me retubui lo valena, me nona muei tangaloi lo valena, me ngere tomtomuei tangaloi lolo vanue Juda. Nebukadnesa mo laire dena vanue renge Jerusalem tavano Babilon. ");
INSERT INTO omb_vpl VALUES ("K224_16","013_24_16","2KI","24","16","16","A ratahigi ta Babilon mo wali vohogi na tangaloi huire teri vaga bitu, me ngere teri vagategale hi ram hibehibe lo gai mena aean, rau huire vena rai qalo. Nebukadnesa mo laire tavano Babilon. ");
INSERT INTO omb_vpl VALUES ("K224_17","013_24_17","2KI","24","17","17","Nebukadnesa mo tau Matania, i tagaruei Jehoiajin, mo vuragi na ratahigi lo tanona me mo sesei na henana Matania mo voragi Sedekia. ");
INSERT INTO omb_vpl VALUES ("K224_18","013_24_18","2KI","24","18","18","Sedekia higaona ngavulu gairue domwa gategale mo vuragi na ratahigi, me u ratahigi lolo vanue renge Jerusalem huri na higao hangavulu domwa gategale. Retahine henana Hamutal netui Jeremae; ngeie tau Libna. ");
INSERT INTO omb_vpl VALUES ("K224_19","013_24_19","2KI","24","19","19","Nge i Sedekia u galegale asi lo nagoi Huqe, mwere i Jehoiakim. ");
INSERT INTO omb_vpl VALUES ("K224_20","013_24_20","2KI","24","20","20","Me huri Huqe mo mero lawagi mo vai na gineu ngere ngaha doluegi lawe na vanue renge Jerusalem mena vanue Juda. Nge i Sedekia he huri na tarani noi ratahigi tau Babilon tea. ");
INSERT INTO omb_vpl VALUES ("K225_1","013_25_1","2KI","25","1","1","Siu lolo higao gaisiwogi tavohe Sedekia mo ratahigi, lo rani hangavulugi lo vule hangavulugi, Nebukadnesa ratahigi tau Babilon mo vano suvohi na Jerusalem mena nona tangaloi vuro doluegi. U toga tavala aravatu varea me ram tabe na ara tuegi vage gena langoi vuro mo dali na aravatu. ");
INSERT INTO omb_vpl VALUES ("K225_2","013_25_2","2KI","25","2","2","Siu rau tugoro na vanue renge u eno mwere ngehi u dadari higao hangavulu domwa gategale noi ratahigi Sedekia. ");
INSERT INTO omb_vpl VALUES ("K225_3","013_25_3","2KI","25","3","3","Lo rani gaisiwogi lo vule gaivesigi, a maro mo wehi na vanue renge lawuagi siu hate hinaga gai tangaloi ve ran gani. ");
INSERT INTO omb_vpl VALUES ("K225_4","013_25_4","2KI","25","4","4","Siu a tangaloi vuro tau Babilon ram geli turu na aravatu, me i ratahigi Sedekia mena buri tangaloi vuro doluegi rau toa vohogi lolo bongi turu na matai aravatu lo livugei qetuqetu gairue kakarani lo talui ratahigi, hate huri ngere ta Babilon ram dali na vanue renge. Ram toa mo hivo huri na ute tavola vuine. ");
INSERT INTO omb_vpl VALUES ("K225_5","013_25_5","2KI","25","5","5","Nge ngere tangaloi vuro tau Babilon ram livusi ratahigi, vanovano ram wiribibie lolo tavola lawua Jerigo. Nona tangaloi vuro ram toa denie ram mawahewahe. ");
INSERT INTO omb_vpl VALUES ("K225_6","013_25_6","2KI","25","6","6","Me ram wiribibie ram taue lawe ratahigi tau Babilon lo vanue renge Ribla, me taie hi ratahigi Nebukadnesa mo vevegi nie. ");
INSERT INTO omb_vpl VALUES ("K225_7","013_25_7","2KI","25","7","7","Ram ue vagamate renetui ratahigi Sedekia lo nagona. Siu lo tagugi ram lai vohogi na matana, me ram vauhi bimbie gena seni meraga ram laie mo vano Babilon. ");
INSERT INTO omb_vpl VALUES ("K225_8","013_25_8","2KI","25","8","8","Lo rani gaibitugi lo vule gailimegi, lolo higao hangavulu domwa gaisiwogi noi Nebukadnesa ratahigi tau Babilon, Nebusaradan a tomtomuei matagoro, ngeie a tangaloi tabanagi noi ratahigi tau Babilon, mo vomai Jerusalem. ");
INSERT INTO omb_vpl VALUES ("K225_9","013_25_9","2KI","25","9","9","Mo bule na valei noi Huqe, valei ratahigi, me valera nona muei tangaloi mena vale doluegi Jerusalem. ");
INSERT INTO omb_vpl VALUES ("K225_10","013_25_10","2KI","25","10","10","A buri tangaloi vuro doluegi tau Babilon lo vavai tomtomuei matagoro, ram dare na aravatu mo dali na vanue renge Jerusalem. ");
INSERT INTO omb_vpl VALUES ("K225_11","013_25_11","2KI","25","11","11","Nebusaradan tomtomuei matagoro mo wiribibi na sinobu doluegi ram toga tau lo vanue renge, meire hi rau vano ram bulu meire hi tau Babilon lo taroi vuro, me a sinobu vage, ngeie u leire doluegi tavano Babilon.");
INSERT INTO omb_vpl VALUES ("ER1_1","016_1_1","EZR","1","1","1","Lo higao tomuegi i Saeras mo ratahigi goro na vanue Besia, me huri ve a gineu na woro mwerehi a leo noi Huqe i Jeremae u toregi nie, i Huqe u gilugi na domi Saeras ratahigi tau Besia mo reve na leo mo horae. Me mo vano vataha na ute ngeie mo leogoro vena, ");
INSERT INTO omb_vpl VALUES ("ER1_2","016_1_2","EZR","1","2","2","“Nge lehe a havai i Saeras ratahigi tau Besia u veve: I Huqe, i Huqe Mauri lolo taetae, u bete na tanoi leogoro doluegi lolo ure laweau, siu mo tau eu huri ve nain vutu na valena lolo Jerusalem lolo Juda. ");
INSERT INTO omb_vpl VALUES ("ER1_3","016_1_3","EZR","1","3","3","Hine mei gimiu dena nona tangaloi (A nona Huqe Mauri nge meie!) me ngeie na hage Jerusalem lolo Juda na tabe na valei Huqe. Ngeie a Huqe Mauri noi Israel mo toga lolo Jerusalem. ");
INSERT INTO omb_vpl VALUES ("ER1_4","016_1_4","EZR","1","4","4","Me lolo hava ute hi a tangaloi ram toga mwaso siserigi lehe, nora tangaloi doluegi hi ram toga gangarani meire rai buluie huri na turegine mo vano Jerusalem gena: vatu renige mena vatu homu, gena vivilangogi doluegi, mena kankarue, me gena hogohogo ngerehi vin veiana gena loloi domire, huri na valei Huqe Mauri lolo Jerusalem.” ");
INSERT INTO omb_vpl VALUES ("ER1_5","016_1_5","EZR","1","5","5","Siu ngere qatui havahava lui Juda, me i Benseman, me ngere mama mena Livaet, doluegi hi i Huqe Mauri u gilu lolo domire, rau rarai hurive rain hage rain vutu huri na valei Huqe lolo Jerusalem. ");
INSERT INTO omb_vpl VALUES ("ER1_6","016_1_6","EZR","1","6","6","Nora tangaloi doluegi hi ram toga gangarani meire rau buluire gena vatu renige mena vatu homu, gena vivilangogi doluegi, mena kankarue, gena nora betebete gagarea, buluigi vage, a nora hogohogo ngerehi vin veiana gena loloi domire. ");
INSERT INTO omb_vpl VALUES ("ER1_7","016_1_7","EZR","1","7","7","Vage, i ratahigi Saeras mo roa na vivilagogi lawera, hi i Nebokadnesa u weli vohoginire dena valei Huqelolo Jerusalem mo taure lolo valei nona huqe vurogi doluegi. ");
INSERT INTO omb_vpl VALUES ("ER1_8","016_1_8","EZR","1","8","8","Saeras ratahigi tau Besia mo betera lawe Mitredat a gaileogoroi vatu homu, mo valure me mo betera lawe Sesbasar a tangaloi lawua tau Juda. ");
INSERT INTO omb_vpl VALUES ("ER1_9","016_1_9","EZR","1","9","9","A tovoi gineu ngerehi ngere: a disi vatu homu ngavulu gaitolu, disi vatu renige teri vagategale, bue biti ngavulu gairue domwa gaisiwo, ");
INSERT INTO omb_vpl VALUES ("ER1_10","016_1_10","EZR","1","10","10","laha vatu homu ngavulu gaitolu, laha vatu renige vudolue vagavesi avigi hangavulu. Vaigineu lalavasigi vage u teri. ");
INSERT INTO omb_vpl VALUES ("ER1_11","016_1_11","EZR","1","11","11","A vai gineu doluegi rau veiana gena vatu homu me vatu renige teri vaga lime, vudolue vagavesi. I Sesbasar u leire mena tangaloi ram vumai dena Babilon ram mule taligu vano Jerusalem.");
INSERT INTO omb_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Gareana lawe na tangaloi nge hilogo hi dige tea lo tovotovo nora tangaloi esi, me he labe tea lo nora turegi rau esi, siu he toga tea lo herera tangaloi vaivei lolohaga Huqe. ");
INSERT INTO omb_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Nge mo havusie gena leo noi Huqe me mo ladolado lolo nona tamwata vataha na rani me lolo bongi. ");
INSERT INTO omb_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Nge mwere na gai ram rivuana lo mwararai matamata nge hilogo lo tarona mo mwasigi a raune rain soi tea, me nge mo maraga lo gineu doluegi nge mo vaire. ");
INSERT INTO omb_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Hate mwere na tangaloi esi mwere na bembei tovu ngere hilogo a langi mo heregi vohoginire. ");
INSERT INTO omb_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Siu i Huqe vin veveginire tangaloi esi rain vurogi me vin vile wahera tangaloi galegale asi dena bubugiana nora tangaloi vovohoi. ");
INSERT INTO omb_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Huri Huqe u ilo na turegire tangaloi vovohoi, nge a tangaloi esi mo huri na turegi mateana. ");
INSERT INTO omb_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","?Huri havagi a vanue dolue ram lalangogi huri vena ra vai gineu esi? ?Huri havagi tangaloi a nora lalangogi mo toa vurogi? ");
INSERT INTO omb_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Ratahigi tau lo ure ram labe ram rarai ve ra qalo mei Huqe. Ngere ram vile bubugi ram tovotovo asi vovoi Huqe mena na nona tangaloi vagatai. ");
INSERT INTO omb_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Ngere ram veve vena, “Ginde da lai vohogi na garovauveu me da tuli vohogi na garo ngere denire.” ");
INSERT INTO omb_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Nge mo toga lolo taetae mo mana, me i Huqe mo vaivei lolohaga meire. ");
INSERT INTO omb_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Siu nge mo veve vohoginire me na nona loloasi, mena nona lolobute mo vaire ram matagu. ");
INSERT INTO omb_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Siu nau teu na Nongu ratahigi me lui Saeon a Nongu vusi gogona. ");
INSERT INTO omb_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Ratahigi move, “Neu nain toregi na leo noi Huqe. Nge mo veve laweau move, ‘Nigo i netungu mwere! Bagataha nam voragi tamamu. ");
INSERT INTO omb_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Tareve goin hui deni eu, me neu nain bete lawego a nomu vanue, mena nom sinobu vin dadari lo duvin ureure. ");
INSERT INTO omb_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Goin vei vurivurire, gena ruqi aean me goin momogagi nire mwere na sosovene tano.’” ");
INSERT INTO omb_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Siu i gimiu ratahigi nein iloe. Nein leohuri, gimiu tangaloi leogoro talo ure. ");
INSERT INTO omb_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Go tabana nona Huqe mena londo mava, rongarea mena matagute. ");
INSERT INTO omb_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Go lai tabe tabegi na maresu mwera vaiteu mo mero mo vai asisigi nigo huri mo mero u siseri. Gareana lawera hi ramo betubetu lune. ");
INSERT INTO omb_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Tomtomuei Ahi. Mena bue gerigeri mena bue gerigeri garo gai welu. Ahi noi Devet. Huqe lolo nomu lolobute go mese veve vohogi eu sige lolo nom meroana go mese haharau. ");
INSERT INTO omb_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Huqe go haharagi na gareana lawe au huri neu nam wiriwiri, Huqe go vaga vagamwasoi eu huri a hui gu ram rurururu. ");
INSERT INTO omb_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Me neu gaheau, nam romasi liu. ?Nge nigo Huqe goin bului eu tagaha? ");
INSERT INTO omb_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Huqe gon tudori gon bului eu. Me lo nom hahagavi vagitue gon vaga vagamwasoi eu. ");
INSERT INTO omb_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Huri lolo mateana a tangaloi vin lado bibigo tea. ?Me hine lolo qaru vin ware hagegi nigo? ");
INSERT INTO omb_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Neu nam wiriwiri gena nongu ngarana; Mena nongu tinengi nam vaga bibilugi na heregu mena qanagu lolo bongi gena nongu tingeni. ");
INSERT INTO omb_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Mataku mo dodo gena romasi, Me a matagu mo asi gena nongu tavului vuro. ");
INSERT INTO omb_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Nen vano den eu gimiu doluegi nem vai gineu rau esi vohogi, huri Huqe mo rongo na nongu ngarana. ");
INSERT INTO omb_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","A Huqe nge u rongo na nongu ngarana huri na hahagavi, siu i Huqe vin duvi na nongu tataro. ");
INSERT INTO omb_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Nongu tavalui vuro doluegi rain matagu lawuagi, me rain maemae rain toa dori siseri deni eu siu rain maemae. ");
INSERT INTO omb_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Ahi noi Devet. A Huqe nge a nongu leo goro garea, neu nain he mahogi tea. ");
INSERT INTO omb_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Mo vai eu nam eno lolo ute lombu, me mo tomuegi eu lo mwararai wai matamata. ");
INSERT INTO omb_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Mo vurugegi na nongu mwasoana, me mo tomuegi eu sulo turegi vovohoiana huri na henana. ");
INSERT INTO omb_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Hate huri nain dige turu na dodo, a waluwelui asiana nain matagu tea gena gineu esi, huri nigo mei eu; a nom ruqi mena gaitigo ngere a gai turegu. ");
INSERT INTO omb_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Gom rarai na hinaga lo nagoi nongu tavului vuro, gom lai gogogi eu me a nongu laha mo horo mwalinglingi. ");
INSERT INTO omb_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","A hogo liu, a nom gareana me nom vaigarea vin huri eu vataha na rani nongu mwasoana me neu nain toga lolo valei Huqe vagituei. ");
INSERT INTO omb_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Ahi noi Devet huri na vai gogonagi na Sara Gogona. Nain tabe hagegi nigo gena roroa, Huqe, huri gu ragasi eu dena walu, me gohi mesingegi tea ve nongu tavalui vuro ve rain rongarea gieu. ");
INSERT INTO omb_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Nongu Huqe Mauri, nam warego huri na buluiana, siu nigo gu vagamwasoi eu. ");
INSERT INTO omb_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Huqe, gu ragasi eu dena qarui mateana. Gu dedegi na nongu mwasoana, hi hivo tea lolo walu. ");
INSERT INTO omb_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Gimiu nona tangaloi gogona nein galohagi na Huqe, me nein bete na harigiana lawe na henana u gogona. ");
INSERT INTO omb_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Huri a nona meroana mo eno mahogi biti, nge a nona leogareagi nigo mo eno tuqaravu, tangiana vin eno lai bongi gategale, nge lolo robongi a rongarea. ");
INSERT INTO omb_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Tavohe nongu tutugoro mo eno, nam veve vena, “Neu nain he gilu tea.” ");
INSERT INTO omb_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","O Huqe, tavohe gom leogareagi eu gom vai na vusigu mo labe siaga; nge tavohe gom hiligi na nagomu nau ruru gena matagute. ");
INSERT INTO omb_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","O Huqe, neu nau warego; Lawego Huqe, neu nau ngara huri na hahagavi. ");
INSERT INTO omb_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","?Hava lalaie nge talehe tare vena neu nau mate? ?Neu nam soi silolo walu siu? ?A qie vin galohagi nigo? ?I nge vin toregi na nom garohuri? ");
INSERT INTO omb_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","O Huqe, go rongo au me go hagavi eu, me O Huqe, go vuragi na buluigu. ");
INSERT INTO omb_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Nigo gu dori na nongu tangiana silo hawana. Nigo gu lei vohogi na luqegu a luqe asi siu gom luqegi eu gena hahavusiana. ");
INSERT INTO omb_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Huri ve a lologu na huri ehi lawego, siu neu na mese toga maunegi. Nongu Huqe Mauri, neu nain ware hagegi nigo tavagi tuei. ");
INSERT INTO omb_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","A ahi noi Devet. A tomtomuei buegerigeri. I tangaloi leo ligoligogi Natan, u vumai lobena, lo tagugi i Devet u vei na doridori esi mei Batsiba. Huqe Mauri go hagavi eu na huri na nomu vaigarea lawua huri na nongu doridori esi. Lo nomu hahagavi gon lai vohogi na nongu asiana. ");
INSERT INTO omb_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Gon solo vohogi na nongu asiana doluegi, me go vagahagi eu dena na bugungu doluegi. ");
INSERT INTO omb_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Ba huri nau ilo na nongu doridori esi mei eu, siu a bugungu mo eno mei eu vataha na tarogi. ");
INSERT INTO omb_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Siu nigo hogosie nau vagasile vovohigo me nau vei na gineu esi lolo matamu. Tavohe gom lanqa, u vovohoi, me tavohe gom vevegi na tangaloi u vovohoi. ");
INSERT INTO omb_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","A hogo nau vora lolo asiana siu neu a nongu galegale asi lungu tavohe i retahigu mo tinogi eu ");
INSERT INTO omb_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Gu tarave na hogo lolo loloi tangaloi, me gu huhui eu gena lolorani lolo buloi dimwangogu. ");
INSERT INTO omb_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Vagahagi eu gena digugu me neu nain mwasara, solo vohogi na nongu asiana me neu nain mevute vin liu na vire hi a wagahiata. ");
INSERT INTO omb_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Vai eu na rongarea me na havuhevu. Siregi na hui gu momogagi nire ra havuhevu. ");
INSERT INTO omb_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Vunigi na nagomu dena nongu asiana me go hara vohogi na nongu doridori esi doluegi. ");
INSERT INTO omb_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","O Huqe Mauri, go vai na lolo lolongu, a dimwango mwasara, me go vai na tanumwe garaqa huire lolo lolongu. ");
INSERT INTO omb_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Mese tuli vohogi eu denigo, me go mese lai vohogi na nom Tanumwe Gogona deni eu. ");
INSERT INTO omb_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Gon bete muleagi lawe au a hahavusi na nom vaga mwasoana, me gon bete na nom tanumwei tabetabe na gaiture au. ");
INSERT INTO omb_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Siu neu nain huhui na tangaloi esi kena nom leo me ngere rain tudori su lobemu. ");
INSERT INTO omb_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","O Huqe Mauri, Huqe Mauri nigo nongu vagamwasoi, go vagamwasoi eu dena dai, siu neu nain huri na ahi hahavusiana huri na nomu vovohoiana. ");
INSERT INTO omb_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Huqe, go tagahi na singogu siu a wawagu vin ware hagegi na henamu. ");
INSERT INTO omb_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Huri nigo gom rahagi na bulengu kankarue nam hogohogo lawego, siu nigo goin hevuhevu tea lo nongu hure bonboni. ");
INSERT INTO omb_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","A hogohogo, O Huqe Mauri, a tanumwegi u mevurivuri me a dimwangona mo hahagavi. O Huqe Mauri, go mese tudori denie. ");
INSERT INTO omb_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Go vai na gineu garea lawe na Saeon; mwerehi gom taranie. Go hagovi na qetuqetu goro na Jerusalem. ");
INSERT INTO omb_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Siu a hogohogo rau vovohoi, a hure bonboni bulugi dodoluegi vin veigo goin hevuhevu, me a bulugi boegi doluegi rain hureana lo nom vonda gogona. ");
INSERT INTO omb_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","A ahi na veve garea. Galohagi na Huqe, mena hahavusiana, dali na ure. ");
INSERT INTO omb_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Galohagi na Huqe, mena hahavusiana; nein vumai lo nagona mena ahi hahavusiana. ");
INSERT INTO omb_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Nei ilo huri ve i Huqe, nge i Huqe Mauri; nge u vei ginde me ginde a nona, ginde nona tangaloi me a nona buri sibsib nge vin leohuri ginde lo tanona. ");
INSERT INTO omb_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Ahu turu na nona matai ara mena veve garea, me nen ware roroagi nie lolo sarana. Nen garea hurie me nen vaga roroagi na henana. ");
INSERT INTO omb_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Huri a Huqe, nge u garea lawuagi me a nona vaigarea vin eno randu, a nona garohuri vin eno duruhi na babagi doluegi vin tuei.");
INSERT INTO omb_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","Netungu mwera go rorontagi na nogu lolorani me gon ronghuri na nogu leoi gaidumu. ");
INSERT INTO omb_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","Huri nigo gon leohuri na dorimu me a singomu vin wiribibi na iloiloi. ");
INSERT INTO omb_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","Huri a singoi vavine, gaihora i tangaloi dolue u lulumu mwere na tovu me a nona leo u minu dena vurei. ");
INSERT INTO omb_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","Nge lo tagugi a vavine u gogona mwere na ngoli sala u magegeni mwere na buei vuro hogogi gairue. ");
INSERT INTO omb_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","Nge vin tomuegi nigo talo ingwei mateana me nge mo dige lo turegi mateana. ");
INSERT INTO omb_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","Nge u geluvegi na turegi mwasoana siu, nge a turegine rau tatagi he iloe tea ve u beragi dena turegi vovohoi. ");
INSERT INTO omb_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Siu renetugu mwera, siserigi ngaha nein rorontagi eu; nein mese beragi nge nen lado bibi na nogu leo. ");
INSERT INTO omb_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Nei huri na turegi vagahao dena vavine ngehi, nei mese vano gangarani lobei matai turegi valena. ");
INSERT INTO omb_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","Tarave goin vei mwere ngaha, vatevai gom bete na nom huireana lawe na tangaloi wagineu me nom mwasoana lawe na tangaloi esi. ");
INSERT INTO omb_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","Vatevai a tangaloi wagineu ram lai vohogi na nom hagogineu me ram ratahigi lo valera lo nom gagarasi. ");
INSERT INTO omb_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","Tavohe gom sesea goi eno lo heremu gom rave, betumu vin soi a huimu vin eno vurogi. ");
INSERT INTO omb_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","?Goi tugutugu, huri havai nau leo masi vena ran tau vovohoigi eu? Siu goi veve, “?Huri havai nam rao ve tangaloi na vovohoigi eu? ");
INSERT INTO omb_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","Tuei nai ronghuri na nogu huhui tea, na he taran tea tamwere vena rongohurire. ");
INSERT INTO omb_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","Me siserigi ngaha, nai hili lai tea huri a sinobu rau iloau beno, siu mo vaieu nam maemae lawuagi lo nagoi sinobu.” ");
INSERT INTO omb_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Go inu na wai dena nom tungu sibomu, a wai meuri mo hale dena loloi nom tungu. ");
INSERT INTO omb_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","Tareve a vavine dolue vin bamba netumu varea, a roromu mena henamu vinhe garea tea. ");
INSERT INTO omb_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","Siu, he garea tea huri ve goi teu na maresu sao lo turegi, nge go tau na maresu na sao lo valemu sibomu, huri rain gogo gorogo me rain bului go. ");
INSERT INTO omb_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Nomu bubugiana mei gaihoramu na roroa, me vataha tarogi goin hevuhevu huri gom bulu meie lolo mwalagelo. ");
INSERT INTO omb_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","Ngeie a memu tovu lulumu mwere na bebe mo vaihuri na waigarea u rerega; nona vaigarea vin vei gareagi nigo vin tuei me a domine vin veuhi bibigo tuqaravu. ");
INSERT INTO omb_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Netungu mwera, go mese lenga hurie dolue, siu go mese lado ve a vavine wagineu u garea liu deni gaihoramu. ");
INSERT INTO omb_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","A Huqe mo leo bibi vataha na gineu gom vaie, me mo mata bibigo lo turegi doluegi gom dige lune. ");
INSERT INTO omb_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Tavohe a tangaloi mo galegaleasi, nge u mwerehi mo siegi na vune mo vidie sibona. ");
INSERT INTO omb_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Nge vin mate huri na nona domi wiriwiri, me a nona lengana me doridori esi doluegi vin leie talolo dalona. ");
INSERT INTO omb_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","Tangaloi mo domigi na havai vin vei laie, nge i Huqe hogosie vin vevea huri ve u garea sige hatie. ");
INSERT INTO omb_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","Bagataha tangaloi mo lado ve mo vai na gineu doluegi rau vovohoi, nge i Huqe vin dumure ve rau vovohoi sige hatie. ");
INSERT INTO omb_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","Go bete lawe na Huqe hava gineu gom vaire, a nom tabana rai maraga vin garea. ");
INSERT INTO omb_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","I Huqe u teu na gineu doluegi mo huri na nona lengagi sibona, siu a tangaloi esi a nona rani vagasigi i Huqe u veie mo vai asisigi nie sibona. ");
INSERT INTO omb_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","I Huqe u leo masi na garigeri. Nge vin siregi nire tea, nge vin arahire. ");
INSERT INTO omb_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Gena vaigarea, a garohuri i Huqe mo lado vohogi na asiana. Gena matagute lui Huqe a tangaloi mo begi dena gineu esi. ");
INSERT INTO omb_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","Tavohe a doridori nona tangaloi mo vai Huqe mo hahavusi, nge mo vai na nona tavalui vuro ram toga meie lo tamwata. ");
INSERT INTO omb_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Biti nge u garea mena vovohoiana, denie hi mo laie u lawua, mena matahala hi he vovohoi tea. ");
INSERT INTO omb_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","A tangaloi mo domigi na turegine, nge i Huqe mo tomuegi na taigerune.");
INSERT INTO omb_vpl VALUES ("IS8_11","024_8_11","ISA","8","11","11","I Huqe nge mo veve laweau, mwere hi a limana huire mo eno lungu, goi mese huri na turegi tangaloi tau Juda. Mo veve vena, ");
INSERT INTO omb_vpl VALUES ("IS8_12","024_8_12","ISA","8","12","12","“Mese bulu mena tangaloi nora lalangogi rau esi mwere hi a tangaloi ram ladolado he huri na tamwata tea, siu mese matagu gina havagi hi a tangaloi ram matagu ginie, me go mese matagu. ");
INSERT INTO omb_vpl VALUES ("IS8_13","024_8_13","ISA","8","13","13","Nge i Huqe Managi nge u vuivuire, me nein ladomava ginie, ngeie gategale hogosie nein tabea, ngeie gategale hogosie nein matagu ginie. ");
INSERT INTO omb_vpl VALUES ("IS8_14","024_8_14","ISA","8","14","14","Ngeie vin vuragi na ute gogona tanoi hilihili; nge Israel mei Juda ngeie vin voragi vatu ngehi vin vei na tangaloi ram taturegi me a vatu ngehi vin veire rain soi. Me lawera tangaloi tau Jerusalem ngeie vin vindire rain dule lo vune. ");
INSERT INTO omb_vpl VALUES ("IS8_15","024_8_15","ISA","8","15","15","Sao denire rain teturegi, ngere rain soi rain mevurivuri, ngere rain dule lo vune me vin wiribibire.” ");
INSERT INTO omb_vpl VALUES ("IS8_16","024_8_16","ISA","8","16","16","Wesi bimbi na leogarea noi Huqe, bulu bimbi na huhuiana noi Huqe Mauri lawe na nongu rorong taigi. ");
INSERT INTO omb_vpl VALUES ("IS8_17","024_8_17","ISA","8","17","17","Nain toga rarai na Huqe, ngehi u hiligi na nagona dena valei Jekob. Me nain toga raraie gena nongu ladohogo. ");
INSERT INTO omb_vpl VALUES ("IS8_18","024_8_18","ISA","8","18","18","Ngelehe neu mena maresu ngehi Huqe u betera laweau. Ginde a gigilegi mena nunui gineu tau lolo Israel, dein Huqe Managi, ngehi mo toga rorongo lo Vusi Saeon. ");
INSERT INTO omb_vpl VALUES ("IS8_19","024_8_19","ISA","8","19","19","Tavohe ngere rain veve lawe gimiu gon hui dena tangaloi uviuvi, me ngere hi ram ngutugi nora huihui. ?Nge huri ve a tangaloi rain hui telai dena nora Huqe Mauri? ?Huri havai ram hui dena tangaloi mate lo taraniana nora ram mwaso? ");
INSERT INTO omb_vpl VALUES ("IS8_20","024_8_20","ISA","8","20","20","Gon hui Huqe huri na huhuiana mena nona leogarea mo waregi sere huri na veveraga. Tareve hine tea vin he toretore tea vena huri na leo ngaha, hate nora leleoi robongi. ");
INSERT INTO omb_vpl VALUES ("IS8_21","024_8_21","ISA","8","21","21","Rongo masi mena mwaruruhie vin vano turu na vanue; ngere rain mweruruhi garagara me ngere rain lolobute, me ram danda su eulu rain arahi na nora ratahigi mena nora huqe. ");
INSERT INTO omb_vpl VALUES ("IS8_22","024_8_22","ISA","8","22","22","Siu ngere rain leo suvohi na ureure, me ngere rain lehi na dodo mena romasi rain matagu lawagi me rain tulire ta lolo dodo maeto. ");
INSERT INTO omb_vpl VALUES ("IS9_1","024_9_1","ISA","9","1","1","Nge vin hate na dodo lawera hi rau romasi. Lo taro tomue Huqe u vei hivogi na vanue Sebulun mena Navtali, nge lo taro mo vumai mo sigei ngeie vin tabera mwere na vanue Kalili ngere hate duvi Israel. Taie hi lo hala mo vano lo tahi lo ute ngehi Jodan. ");
INSERT INTO omb_vpl VALUES ("IS9_2","024_9_2","ISA","9","2","2","Tangaloi ngere hi ramo dige lolo dodogi, ngere rain lehi na leleo lawoa ngehi mo mwaso lo vanue hi u dodoga garagara, a leleo vin varavara su lure. ");
INSERT INTO omb_vpl VALUES ("IS9_3","024_9_3","ISA","9","3","3","Nigo goin vagaqaloi na tangaloi lolo vanuara, lawea goin ragasi na havuhevu ngehinge ve ngere rain hevuhevu lumiu mwere na havuhevui taroi hinaga matue, mwere ve ramo gaganigi me ram wahegi nora gineu rau qaragi nire lolo vuro. ");
INSERT INTO omb_vpl VALUES ("IS9_4","024_9_4","ISA","9","4","4","Ba huri mwere hi tavohe lolo rani ngehi ngere Midian rahe qaragi na gineu tea, nigo gu lei vohogi na nora hagohago, a gai weli mo saro lo siqara, me a ruqi na nora tabana gagarasi vurogi. ");
INSERT INTO omb_vpl VALUES ("IS9_5","024_9_5","ISA","9","5","5","Ba huri, a butu nora tangaloi vuro doluegi mena luqe qaravu rau lulugi lolo dai me u tatarise mena avi me vin voragi gai vagaoi avi. ");
INSERT INTO omb_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","Ba huri a maresu mwera vin vora lawe ginde, vin beteana lawe ginde me a lawoagoro vin eno lo siqana, me a henana vin waregiana: Gaiture garea liu, Huqe managi, me a Tama vagituei, Netui tawmata. ");
INSERT INTO omb_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","Me a nona lawoagoro vin lawoa mena nona tamwata vin eno hate duvigi. Lo herei ratahigi Devet me lo tanona mo mamalu goro mena vovohoiana tasiserigi hi mo vano vin dadari hate duvigi. A garohuri nona Huqe Managi vin veiana mwere hi. ");
INSERT INTO omb_vpl VALUES ("IS52_13","024_52_13","ISA","52","13","13","Go leo, nogu tangaloi tabana vin tabana vin garea liu, siu ngeie vin ragasie me vin tabe hagegi nie siu vin lado mavagi nie siu a henana vin roroa hage liu. ");
INSERT INTO omb_vpl VALUES ("IS52_14","024_52_14","ISA","52","14","14","Mwere hi ngere rau vei asisigi nie a tangaloi ram vutugegi ginie, me tarabehine dau leo samwegi nie u esi garagara liu na tangaloi, me a nagona he mwere na tangaloi tea. ");
INSERT INTO omb_vpl VALUES ("IS52_15","024_52_15","ISA","52","15","15","Siu ngeie vin vagavutugegi na vanue saosao, ba hurie tau ratahigi sao rai gato tea. Havai rai veve tea lawera ngere rain lehe, havagi rahi rongo tea ngere rain rongo hogo. ");
INSERT INTO omb_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","?Hine u ladohogo lo nomai leo me lawe hine hi Huqe u haharagi na nona huireana? ");
INSERT INTO omb_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","Ngeie u meuri lo nagona mwere na qaloi gei, me mwere na goari dena tano mamaha. Tarabesine he garea tea siu nona varavara vin he revei ginde tea lawea. Hate gineu lune vena dain taranie. ");
INSERT INTO omb_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","Ngeie rau leo vurogi ginie, me rau rahagi nie, ngeie a tangaloi rongesi me u ilo na gagarasi. Nge mwere na tangaloi sao ram hiligi na nagora denie nge rau leomasie, me ginde dahe lado tabea tea. ");
INSERT INTO omb_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","Nge u lei vohogi na noda gagarasi, me mo wali vohogi na noda rongesi, maraga i ginde dam lado vena i Huqe Mauri mo arahie, me mo vaie mo gagarasi. ");
INSERT INTO omb_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","Nge rau qangea huri noda asiana, mo gagarasi huri na bugude. A arahiana hi u eno lune u lei ginde mo tau ginde lo tamwata. Me huri na mataigana ginde dam mwaso. ");
INSERT INTO omb_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","Ginde doluegi dau mwere na sibsib rau sala, ginde gagategalegi dau dori lo noda turegi gahe ginde, nge i Huqe u sangatagi na noda galegaleasi doluegi lune. ");
INSERT INTO omb_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","Rau veie u garasie me u gagarasi, maraga ngeie hateve u gato mwere na sibsib ram laie vena rain teveroto mwagorona. Me mwere na sibsib hi ramo laie mo vano vena rain bala na vulune ngehi ngara tea. Siu he wowongagi na singona tea. ");
INSERT INTO omb_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","Siu dena gagarasi, dena vevegiana rau lei vohogi nie. ?Me i hine vin velu huri na garogi hinge lui renetune? Ngeie rau tei vohogi nie dena vanuei mwasoana; huri na doridori esi noi nongu tangaloi ngeie mo vano lo arahiana. ");
INSERT INTO omb_vpl VALUES ("IS53_9","024_53_9","ISA","53","9","9","Me ngeie rau domiginie vena vin eno mena tangaloi doridori esi, maraga lolo nona mateana ngeie u eno mena ratahigi, ngeie hi vei na galegaleasi tea, me he galigeli tea. ");
INSERT INTO omb_vpl VALUES ("IS53_10","024_53_10","ISA","53","10","10","Maraga a ladolado noi Huqe ve vi momogagi nie me vi veie vi gagarasi, me Huqe mo bete na nona mwasoana mo voragina gaivoli bugu, nge vin lehi netune me vin vei na nona rani vin qaravu, me ladolado noi Huqe vin woro lo limana. ");
INSERT INTO omb_vpl VALUES ("IS53_11","024_53_11","ISA","53","11","11","Lo tagui nona gagarasi nge vin lehi na leleoi mwasoana me mo rongo garea; gena iloilo na nongu tangaloi tabana vovohoi vin veire sao rain vovohoi me vin weli goro na bugure. ");
INSERT INTO omb_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","Huri hi neu nain bete lawea mahoi ute meire tangaloi lalawoa me ngeie vin wahegi na vai gineu meire tangaloi huire, bahuri ngeie u siregi na nona mwasoana su lo mateana, me rau velue mena tangaloi doridori esi, huri nge u weli na asiana noi tangaloi sao, me mo vai na tataro huri na tangaloi doridori esi.");
INSERT INTO omb_vpl VALUES ("JR25_1","025_25_1","JER","25","1","1","A leo mo vumai lawe Jeremae huri na sinobu tau Juda lo higao gaivesigi tavohe Jehoiakim netui Josaea Ratahigi tau Juda, lo muei higao noi Nebukadnesa Ratahigi tau Babilon. ");
INSERT INTO omb_vpl VALUES ("JR25_2","025_25_2","JER","25","2","2","I Jeremae a tangaloi ligoligogi mo veve lawe na sinobu tau Juda me lawera doluegi ram toga Jerusalem: ");
INSERT INTO omb_vpl VALUES ("JR25_3","025_25_3","JER","25","3","3","Lolo higao hangavulu dongwagai gaitolu, tavohe Josaea netui Amon tau Juda mo ratahigi Huqe mo gato mei eu me neu nam gato mei gimiu. Mo dadari bagataha higao ngavulu geirue domwagi tolugi lehe, maraga gimiu hateve nem rorontagi. ");
INSERT INTO omb_vpl VALUES ("JR25_4","025_25_4","JER","25","4","4","Me hate huri i Huqe u hora na nona tangaloi ligoligogi lawe gimiu taligu siu taligu nge nehi rorongtagi tevohogi. ");
INSERT INTO omb_vpl VALUES ("JR25_5","025_25_5","JER","25","5","5","Ram veve vena, “Tudor, vataha gimiu dena nomiu galegaleasi mena doridori esi, siu nei toga lai lolo vanue i Huqe u bete lawe gimiu, meire tubumiu vagituei. ");
INSERT INTO omb_vpl VALUES ("JR25_6","025_25_6","JER","25","6","6","Mese huri re huqe dolue ve nen tamba nora me sige nen huduhudu lawera; mese vutu na nongu meroana gena nunui huqe lime miu u veie. Siu nain mese arahi gimiu.” ");
INSERT INTO omb_vpl VALUES ("JR25_7","025_25_7","JER","25","7","7","I Huqe mo veve, “Nge nei rorontagi eu tea, me gimiu neu vutu na nogu meroana gena havagi a lime miu u veie, me neu lei na tatuana lawe gimiu sibomiu.” ");
INSERT INTO omb_vpl VALUES ("JR25_8","025_25_8","JER","25","8","8","Hurihi lehe a havai i Huqe Managi u veve: “Huri nei rorontagi na nogu leo tea, ");
INSERT INTO omb_vpl VALUES ("JR25_9","025_25_9","JER","25","9","9","Nain hora na leo lawe na sinobu lo matai wai bilage me nongu tangaloi tabana Nebukadnesa Ratahigi tau Babilon,” Huqe mo veve, “Siu nain leire vohivohi na vanue ngaha mena nona tangaloi me vohivohi na taureure dalire doluegi. Nain vei vohogi nire me nain veire rai vuragi na gineu vurogi, me a tangaloi rai lehire rai matagu siu, rain esi tavagi tuei. ");
INSERT INTO omb_vpl VALUES ("JR25_10","025_25_10","JER","25","10","10","Nain vei goro na nora diloi havuhevu mena rongarea, me a diloi havuhevui hinagai laginana. Vin hate na nora leleoi bulu, me vin hate na gara hinaga. ");
INSERT INTO omb_vpl VALUES ("JR25_11","025_25_11","JER","25","11","11","Vanue doluegi vin vuragi na gineu vurogi, me a taureure ngerehi rain tabana noi ratahigi tau Babilon higao ngavulu geibitu. ");
INSERT INTO omb_vpl VALUES ("JR25_12","025_25_12","JER","25","12","12","Nge tavohe a higao ngavulu geisiwo bitu u rovo, neu nain arahi na ratahigi tau Babilon mena nona sinobu, a tano tau Babilon huri na bugure,” Huqe mo veve, “Me vin veie vin esi vagituei. ");
INSERT INTO omb_vpl VALUES ("JR25_13","025_25_13","JER","25","13","13","Nain teu lo tano hi gineu doluegi hi nau veve vovohoie, gineu doluegi hi u uliana lolo nogu bugu a tangaloi ligoligogi Jeremae waratau vohivohi na taureure doluegi. ");
INSERT INTO omb_vpl VALUES ("JR25_14","025_25_14","JER","25","14","14","Ngere sibora rain vuragi na gaihora nora taureure sao mena ratahigi lalawua: Nain malaire vin huri na nora doridori mena tabana mo vaiana gena limara.”");
INSERT INTO omb_vpl VALUES ("DN2_1","028_2_1","DAN","2","1","1","Lolo higao tuegi hi Nebokadnesa a ratahigi u bombore. A boborea hi u veie mo ladolado lawuagi lune siu mo maturu samwegi. ");
INSERT INTO omb_vpl VALUES ("DN2_2","028_2_2","DAN","2","2","2","Ratahigi hi mo ware na: tangaloi ram mataduru; a tangaloi ram voki, tangaloi ram lalagohi gena huireana nona tamate, me a tangaloi ram tovotovo mo huri na visiu. Mo warera huri ve ran matamwasaragi na nona boborea. Siu rau vomai ram labe lo nagoi ratahigi, ");
INSERT INTO omb_vpl VALUES ("DN2_3","028_2_3","DAN","2","3","3","mo veve lawera, “?Nau bombore mo vai eu nam romasi me nam tarani ve na ilo huri ve mo vosangi na havai?” ");
INSERT INTO omb_vpl VALUES ("DN2_4","028_2_4","DAN","2","4","4","Ngere ram huduhudu lawea me ram gato lo leo Aramig rave, “O ratahigi mwaso vagituei! Go valu na nom bombore lawe gamai, siu gam veve na havagi hi mo vosangie lawego.” ");
INSERT INTO omb_vpl VALUES ("DN2_5","028_2_5","DAN","2","5","5","A ratahigi mo duvi lawera tangaloi ngerehi, “Nau domigi nie beno huri ve gimiu nei veve na nogu boborea me nein matamwasaragi nie. Tareve nein vevea tea, neu nain tei vurivuri gimiu me a valemiu rain taqao vusi dolue. ");
INSERT INTO omb_vpl VALUES ("DN2_6","028_2_6","DAN","2","6","6","Nge tareve nein velu na nogu boborea me nein matamwasaragi nie, nogu betebete, gaitawe, me a domi mava, rai vunatu lawe gimiu. Siu nein veve na boborea me nein matamwasaragi nie laweau! ");
INSERT INTO omb_vpl VALUES ("DN2_7","028_2_7","DAN","2","7","7","Taligu ram veve, ratahigi go valu na boborea hi lawera nom gaihora, siu gamai gam matamwasaragi nie.” ");
INSERT INTO omb_vpl VALUES ("DN2_8","028_2_8","DAN","2","8","8","Nge i ratahigi move, “Nau ilo huri ve nem vai vena nen revereve taro huri, neu ilo na nogu ladolado beno.” ");
INSERT INTO omb_vpl VALUES ("DN2_9","028_2_9","DAN","2","9","9","Tareve goi velu na boborea hi tea laweau, a vevegiana lawe gimiu gategale hogosie. Neu bata na leo huri ve nei sine au me nem lado huri ve nomiu leo galigeli hi vin veieu nain tugu na nogu leo taligu. Nge, go valu na nogu boborea siu, nain ilo huri ve goin matamwasaragi nie lai laweau. ");
INSERT INTO omb_vpl VALUES ("DN2_10","028_2_10","DAN","2","10","10","Nona tangaloi ram veve lawea, “Hate tangaloi gategale lo ure vena vai na havai gom huie. U siaga lawuagi. Hate ratahigi lawua sige huire ve na hui na gineu mwerehi dena tangaloi mataduru, sige a tangaloi ram lalagohi gena huireana nona tamate, me tangaloi visiu. ");
INSERT INTO omb_vpl VALUES ("DN2_11","028_2_11","DAN","2","11","11","Havai ratahigi mo hui u siaga lawuagi. Tangaloi vin vosangi laie tea lawe na ratahigi. Ngere huqe hogosie, maraga rai toga te lo ure meire tangaloi.” ");
INSERT INTO omb_vpl VALUES ("DN2_12","028_2_12","DAN","2","12","12","Gineu hi u vei na ratahigi mo sambu lawuagi, mo hora leo huri ve a tangaloi mataisao doluegi tau Babilon rai mate. ");
INSERT INTO omb_vpl VALUES ("DN2_13","028_2_13","DAN","2","13","13","A leo hi mo mwalue huri ve rain ue vagamate na tangaloi mataisao, tora Daniel mena buluine. ");
INSERT INTO omb_vpl VALUES ("DN2_14","028_2_14","DAN","2","14","14","Daniel mo lehi Ariok a muei leogoro noi ratahigi. Huri ngeie hi vin ue vagamate na tangaloi mataisao ngerehi. Daniel lo mataisao mena lolorani mo gato meie. ");
INSERT INTO omb_vpl VALUES ("DN2_15","028_2_15","DAN","2","15","15","Daniel mo huie vena, “?Huri havai i ratahigi mo hora na leo huri ve gamai gan mate?” I Ariok mo veve sere na havagi hi mo vai lawe Daniel. ");
INSERT INTO omb_vpl VALUES ("DN2_16","028_2_16","DAN","2","16","16","Siu, Daniel mo vano mo hui na ratahigi huri ve na tau na taro, huri ngeie vin matamwasaragi na nona boborea. ");
INSERT INTO omb_vpl VALUES ("DN2_17","028_2_17","DAN","2","17","17","Siu Daniel u mule lo valena mo valuhuri na leo noi ratahigi lawe rebuluine: Hanania, Misael, me i Asaria. ");
INSERT INTO omb_vpl VALUES ("DN2_18","028_2_18","DAN","2","18","18","Daniel mo laqa ragasi rebuluine huri ve ra tataro huri na hahagavi noi Huqe lolo taetae, vena gineu hi mo eno vunigi na matamwasara lawera siu, ngere ran mese mate meire tangaloi mataisao noi Babilon. ");
INSERT INTO omb_vpl VALUES ("DN2_19","028_2_19","DAN","2","19","19","Lolo bongi hi mo vosangi na leovunigi hi huri na nunui boborea hi lawe Daniel. Siu i Daniel mo galohagegi na Huqe lolo taetae. ");
INSERT INTO omb_vpl VALUES ("DN2_20","028_2_20","DAN","2","20","20","Move, “Huqe Mauri, mataisao a lolorani mena huireana a nomu. Neu nain galohagegi nigo vataha tarogi vin he rovo lai tea! ");
INSERT INTO omb_vpl VALUES ("DN2_21","028_2_21","DAN","2","21","21","Ngeie mo wiribibi na taro doluegi, mo tau vohogi nire ratahigi siu mo taure wagineu. Mo bete na lolorani lawe na mataisao mena iloilo lawera hi rau ronhogo. ");
INSERT INTO omb_vpl VALUES ("DN2_22","028_2_22","DAN","2","22","22","Ngeie u vosangi na gineu u eno vunigi, u ilo na havai mo eno lolo dodo maeto, me a leleo mo eno meie. ");
INSERT INTO omb_vpl VALUES ("DN2_23","028_2_23","DAN","2","23","23","Nam harigi nigo me nam galohagegi nigo, Huqe Mauri noi retubungu; gu bete na lolorani mena huireana lawe au, havagi gau hui go gu vosangie lawe gamai, gu veie gamai gam ilo na boborea noi ratahigi.” ");
INSERT INTO omb_vpl VALUES ("DN2_24","028_2_24","DAN","2","24","24","Siu Daniel mo vano lobei Ariok hi, i ratahigi u horae vena wehi vagamate na tangaloi mataisao tau Babilon, mo veve lawea vena, “Mese ue vagamate na tangaloi mataisao tau Babilon. Go lai eu lawe ratahigi neu nain matamwasaragi na nona boborea.” ");
INSERT INTO omb_vpl VALUES ("DN2_25","028_2_25","DAN","2","25","25","Ariok mo lai Daniel siseri lawe ratahigi move, “Nau hagwe na tangaloi gategale deni re rau reveire dena Juda, ngeie vin matamwasaragi lei na boborea lawe na ratahigi.” ");
INSERT INTO omb_vpl VALUES ("DN2_26","028_2_26","DAN","2","26","26","I ratahigi mo hui Daniel hi a henana tuegi i Beltesasa, “?I nigo goi vei lei ve goi veve na nogu boborea, siu mo vosangi na havai?” ");
INSERT INTO omb_vpl VALUES ("DN2_27","028_2_27","DAN","2","27","27","Daniel mo duvi lawe ratahigi Nebokadnesa vena, “Hate tangaloi Mataisao, sige tangaloi ramo voki, tangaloi mataduru, ngere tangaloi visiu, tangaloi mo veve na gineu lo taro mo vumai teu, vena vi matamwasaragi na gineu vunigi hi ratahigi mo huie huri, ");
INSERT INTO omb_vpl VALUES ("DN2_28","028_2_28","DAN","2","28","28","nge i Huqe lolo taetae mo vosangi na gineu vunigi. Ngeie u haharagi lawe ratahigi, a nom boborea me havai gu lehe mo eno lolo domimu tavohe gom eno lo niemu ngere. Mo haharagi nigo a hava gineu vin vei lolo rani mo vomai mosigei. ");
INSERT INTO omb_vpl VALUES ("DN2_29","028_2_29","DAN","2","29","29","Ratahigi, tavohe gu meturu gu bomboregi na gineu vin vomai mosigei. Lo nom boborea, i Huqe Mauri hi mo haharagi na gineu lawego mo eno vunigi vin vomai mosigei. ");
INSERT INTO omb_vpl VALUES ("DN2_30","028_2_30","DAN","2","30","30","Nge i neu a gineu vunigi ngaha u vosagiana laweau hate huri ve ba a nogu lolorani u lawua deni re lavasigi, nge huri ve i Huqe lolo taetae na matamwasaragi na nom boborea siu nigo ratahigi goin ilo na havagi hi mo eno lolo domimu. ");
INSERT INTO omb_vpl VALUES ("DN2_31","028_2_31","DAN","2","31","31","Ratahigi, lolo nomu boborea gu lehi na nunui tangaloi lawua me u qaravu liu u labe lo nagomu, me u varavara dena varavara. Nunu hi u veigo gom matagu ve go lehie. ");
INSERT INTO omb_vpl VALUES ("DN2_32","028_2_32","DAN","2","32","32","A qatune rau veie gena vatu homu mwasara, a mabune mena limana gena vatu renige, a taqangine mena baloana gena vatu meraga, ");
INSERT INTO omb_vpl VALUES ("DN2_33","028_2_33","DAN","2","33","33","garune gairue rau veire lo aean, qaqai qalagena gena aean mena tano qeaqea. ");
INSERT INTO omb_vpl VALUES ("DN2_34","028_2_34","DAN","2","34","34","Siu tavohe gom lelehurie, a vatu u teiana hate gena limei tangaloi mo totogi na nunui tangaloi hi lo ului gave rau veire, lo aean mena tano qeaqea rom mavurivuri. ");
INSERT INTO omb_vpl VALUES ("DN2_35","028_2_35","DAN","2","35","35","Siu aean, vatu qeaqea, vatu meraga. Vatu renige me a vatu homu rau mevurivuri mwere na bebei tovu. A Langi mo heregi vohogi nire gategale he eno tea. Nge a vatu hi mo mauri sueulu mo vuragi vusi lawua, mo horongi na ureure doluegi. ");
INSERT INTO omb_vpl VALUES ("DN2_36","028_2_36","DAN","2","36","36","Ngehi a nom boborea, siu siserigi hi gai matamwasaragi nie lawe na ratahigi. ");
INSERT INTO omb_vpl VALUES ("DN2_37","028_2_37","DAN","2","37","37","O ratahigi, nigo a ratahigi nora ratahigi; huri i Huqe lolo taetae u ragasigo mo bete na huireana, me mo vaigo gom lawua liu na ratahigi doluegi. ");
INSERT INTO omb_vpl VALUES ("DN2_38","028_2_38","DAN","2","38","38","U veigo gom vuragi ratahigi goro na tangaloi doluegi vataha na ute ram toga lune lolo ureure; me goro na gangarue turu talolo songo, manu lolo mahava, mena ige lolo tahi me i nigo hi a vatu homu. ");
INSERT INTO omb_vpl VALUES ("DN2_39","028_2_39","DAN","2","39","39","Lo tagumu: ngere lo bambai ratahigi tuegi gategale vage rain maraga mwere na vatu renige, ngere rai lado mavagi nie tea mwereigo. Me a bambai ratahigi gai toligi nge a vatu meraga, vin ratahigi goro na ureure doluegi. ");
INSERT INTO omb_vpl VALUES ("DN2_40","028_2_40","DAN","2","40","40","Me vagasigi, a bambai ratahigi gaivesigi u siaga mwere na aean; huri a aean mo volo, me mo momogagi na gineu doluegi. Me mwerehi a aean mo volo vurivuri na gineu, siu ngeie vin momogagi nire me vin volora lalavasigi doluegi. ");
INSERT INTO omb_vpl VALUES ("DN2_41","028_2_41","DAN","2","41","41","Mwerehi gu lehi na qaqai geru mena bisu, ru veiana duvigi a aean duvigi a tano qeaqea, siu a sinobu noi ratahigi rain mawahewahe; huri a huine u mwere na aean maraga i nge mo roigi mena tano qeaqea. ");
INSERT INTO omb_vpl VALUES ("DN2_42","028_2_42","DAN","2","42","42","Mwerehi a bisu lo garune duvigi a aean duvigi a tano qeaqea, siu, sinobu noi ratahigi hi lavasigi rau huire lavasigi hatie. ");
INSERT INTO omb_vpl VALUES ("DN2_43","028_2_43","DAN","2","43","43","Vage, gu lehi na tano qeaqea mo bulu mena aean, ngehi mo haharagi nie vena ngere a duvi aean me ngere duvi tano qeaqea,tangaloi ram lado huri ve rain bubugi vin garea maraga, a tano qeaqea roin roigi tea lai mena aean. Siu, a tangaloi rain bulu tea mwere na tano qeaqea mena aean. ");
INSERT INTO omb_vpl VALUES ("DN2_44","028_2_44","DAN","2","44","44","Lo taro nora ratahigi ngerehi, Huqe lolo taetae vin rivu na ratahigi vin toga vagitue. Siu vin siregi na tanoi nona ratahigi tea lawe na tangaloi dolue. Ngeie vin momogagi na tanoi ratahigi ngerehi doluegi, me i ngeie sibona vin labe vagituei. ");
INSERT INTO omb_vpl VALUES ("DN2_45","028_2_45","DAN","2","45","45","Nge ngaha a havagi gu bomboregi nie huri a vatu u teiana dena vusi lawua hate gena limei tangaloi, me mo toto vurivuri na aean, a vatu meraga, a tano qeaqea, a vatu renige, mena vatu homu; a Huqe lawua u haharagi na ratahigi mo ilo na havagi mo vomai mosigei. A boborea hi a hogo me havagi nam matamwasaragi nie a hogo!” ");
INSERT INTO omb_vpl VALUES ("DN2_46","028_2_46","DAN","2","46","46","Siu, i ratahigi Nebokadnesa mo taigi na nagona vuine mo galohagi Daniel, me mo veve lawe na nona tangaloi huri ve ran hogohogo lawea ran bete na gineu bonana u buhoru. ");
INSERT INTO omb_vpl VALUES ("DN2_47","028_2_47","DAN","2","47","47","I ratahigi mo veve lawe Daniel, “A hogo a nom Huqe Mauri nge a Huqe Mauri nora huqe me a Huqe nora ratahigi. Me mo vosangi na gineu vunigi, huri nigo gu vei lei gom matamwasaragi na gineu vunigi.” ");
INSERT INTO omb_vpl VALUES ("DN2_48","028_2_48","DAN","2","48","48","Siu i ratahigi mo tau Daniel mo vuragi tangaloi lawua me mo bete na hogohogo sao lalawua lawea. Siu mo taue mo vuragi qatui leogoro na togagi venue varea dena Babilon. Me nge mo vuragi na qatui leogoro na tangaloi mataisao doluegi noi Babilon. ");
INSERT INTO omb_vpl VALUES ("DN2_49","028_2_49","DAN","2","49","49","Siu, Daniel mo hui na ratahigi, me mo tau Sedrak, Misak me i Abednigo ram leogoro na togagi venue lolo Babilon, nge i Daniel mo tabana lolo gamali ratahigi. ");
INSERT INTO omb_vpl VALUES ("DN3_1","028_3_1","DAN","3","1","1","Ratahigi Nebokadnesa mo bolo na gailandolando gena vatu homu. Qaravugi sugu ngavulu geiono me a lawuana sugu gaiono. U labetagi nie lolo tavola hi Dura, lo togagi venue hi tau Babilon. ");
INSERT INTO omb_vpl VALUES ("DN3_2","028_3_2","DAN","3","2","2","Siu, i ratahigi Nebokadnesa mo ware na nona lalangai tangaloi lalawua lolo vanue doluegi nge mo ratahigi goro vena ran vumai bubugi ra vaigareagi na gailandolando hi nge u boloe. ");
INSERT INTO omb_vpl VALUES ("DN3_3","028_3_3","DAN","3","3","3","Tavohe ngerehi rau vomai, rau labe lo nagoi gailandolando i Nebokadnesa u veie. ");
INSERT INTO omb_vpl VALUES ("DN3_4","028_3_4","DAN","3","4","4","A tangaloi waregi leo noi ratahigi mo waregi siaga move, “Tangaloi doluegi vataha na vanue mena lalangai leo. Nge ngaha a havagi huri ve i nigo goin vei: ");
INSERT INTO omb_vpl VALUES ("DN3_5","028_3_5","DAN","3","5","5","Tavohe nem rongo na diloi tavue, bue balabala, bue warue, bue kore, mwasi mwele, sisingi mena lalangai bue doluegi, i nigo goin soi suvine gom galohagi na gailandolando vatu homu i ratahigi Nebokadnesa u labetagi nie. ");
INSERT INTO omb_vpl VALUES ("DN3_6","028_3_6","DAN","3","6","6","Tangaloi vin he soi suvine tea ve na galohagi, gamai gain tulie ta lolo avi u mwamwavi de mwamwavi.” ");
INSERT INTO omb_vpl VALUES ("DN3_7","028_3_7","DAN","3","7","7","Tavohe a lalangai bue me tavue dilogi mo mwagologolo, a lalangai tangaloi doluegi mena lalangai leo ram huduhudu ram galohagi na gailandolando i ratahigi Nebokadnesa u labetagi nie. ");
INSERT INTO omb_vpl VALUES ("DN3_8","028_3_8","DAN","3","8","8","Lo taro hi i ngere tangaloi tau Babilon, rau vumai ve rain vevegi vogohi na tangaloi tau Juda. ");
INSERT INTO omb_vpl VALUES ("DN3_9","028_3_9","DAN","3","9","9","Ram veve lawe ratahigi Nebokadnesa, “O ratahigi, goin toga vagituei! ");
INSERT INTO omb_vpl VALUES ("DN3_10","028_3_10","DAN","3","10","10","O ratahigi, nigo gu teu na leo siaga huri ve tavohe a diloi tavue mena lalangai bue mo mwagologolo gamai gain huduhudu gam galohagi na gailandolando gu boloe lo vatu homu. ");
INSERT INTO omb_vpl VALUES ("DN3_11","028_3_11","DAN","3","11","11","Me i hine vin he soi suvine tea ve na galohagi, nge vin tuliana ta lolo avi u mwamwavi de mwamwavi. ");
INSERT INTO omb_vpl VALUES ("DN3_12","028_3_12","DAN","3","12","12","Ngere tau Juda gaitolu gu teure ram leogoro na togagi venue tau Babilon, i Sedrak, i Misak, me i Abednigo rai tabe na nom leo tea. Rai galohaginire nom huqe tea, me hateve rau galohagegi na gailandolando vatu homu gu labetagi nie.” ");
INSERT INTO omb_vpl VALUES ("DN3_13","028_3_13","DAN","3","13","13","I ratahigi Nebokadnesa u mero garasie, move, “Ne vano ne lai na tangaloi gai toluhi vumai lombegu.” Siu ram laire vumai lawe na ratahigi. ");
INSERT INTO omb_vpl VALUES ("DN3_14","028_3_14","DAN","3","14","14","Nebokadnesa move, “?A hogo, huri ve gimiu nei tabana tea lawera nogu huqe siu nei galohagi na gailandolando vatu homu tea? ");
INSERT INTO omb_vpl VALUES ("DN3_15","028_3_15","DAN","3","15","15","Siserigi ngaha, tavohe gom rongo na diloi tavue mena lalangai bue mo mwagologolo, goi huduhudu gom galohagi na gailandolando vatu homu nau labetagi nie. Nge tareve hatie, nein tuliana ta lolo avi mui tasiserigi hi. Huri hate huqe vage ve vin lei gimiu dena nogu huireana.” ");
INSERT INTO omb_vpl VALUES ("DN3_16","028_3_16","DAN","3","16","16","Nge i ngaraha gaitolu hi ram duvi lawe ratahigi Nebokadnesa, ram veve “Gamai hate nomai leo huri ve gain tugoro gamai dena gineu ngaha. ");
INSERT INTO omb_vpl VALUES ("DN3_17","028_3_17","DAN","3","17","17","Tareve goi tuli gamai talolo avi huire hi, i Huqe Mauri gamai gam tabana lawe au vei lei ve vin lei gamai dena avi hi. Siu ngeie vin vagamwasoi gamai dena nom hureana, O ratahigi. ");
INSERT INTO omb_vpl VALUES ("DN3_18","028_3_18","DAN","3","18","18","Nge tareve vin vagamwasoi gamai tea, u garea. Nge i ratahigi na ilo huri ve gamai gain he tabana tea lawera nom huqe me gain he galohagi na gailandolando vatu homu gu labetagi nie.” ");
INSERT INTO omb_vpl VALUES ("DN3_19","028_3_19","DAN","3","19","19","Siu Nebokadnesa mo merogi Setrak, Misak mei Abednigo, a nagona mo asi ginire. Mo hora huri ve ne huru na avi hi na mwamwavi vaga bitu denie mwerehi tamwere. ");
INSERT INTO omb_vpl VALUES ("DN3_20","028_3_20","DAN","3","20","20","Me mo hora na nona tangaloi vuro rau huire garagara huri ve ran wesibibi Sedrak, Misak me i Abednigo siu ra tulire talolo avi hi mo mui. ");
INSERT INTO omb_vpl VALUES ("DN3_21","028_3_21","DAN","3","21","21","Siu tangaloi ram wesibimbire mena luqara, nora roqoroqo mena luqe lavasigi vage, siu ram tulire ta lolo livugei mui evi hi. ");
INSERT INTO omb_vpl VALUES ("DN3_22","028_3_22","DAN","3","22","22","Huri i ratahigi u veve vena rain vei na avi vin mwamwavi liue tamwere, ngere tangaloi vuro rau welire hage ve ran tulire talolo avi rau mate gena mwamwavi avi hi. ");
INSERT INTO omb_vpl VALUES ("DN3_23","028_3_23","DAN","3","23","23","Siu i Sedrak, Misak me i Abednigo ngere lo garovauveu teu tavohe ram soi ta lolo mui avi hi. ");
INSERT INTO omb_vpl VALUES ("DN3_24","028_3_24","DAN","3","24","24","Ratahigi Nebokadnesa mo lehire, mo vutugegi, mo maraga siseri hage mo labe moveve, lawe na nona tangaloi lalawua “Ei ngaraha! ?Nem lado ve dau wesibimbire gaitolu hogosie dam tulire talolo avi?” Ram duvi vena, “Io ratahigi.” ");
INSERT INTO omb_vpl VALUES ("DN3_25","028_3_25","DAN","3","25","25","Mo veve vena, “Neleo! Nam lehi na tangaloi gaivesi ram dige lategi lolo avi, hateve a garo lure me rai gao tea; Gaivesigi u mwerei neture huqe.” ");
INSERT INTO omb_vpl VALUES ("DN3_26","028_3_26","DAN","3","26","26","I Nebokadnesa mo vano lo matai evi mo ware, “Sedrak, Misak Abednigo tangaloi tabana noi Huqe Eulu, mwalue!” Siu i Sedrak, Misak, me i Abednigo ram mwalue dena avi. ");
INSERT INTO omb_vpl VALUES ("DN3_27","028_3_27","DAN","3","27","27","Me a tangaloi lalawua noi ratahigi ram sone dalire. Ram leo a avi he gao na tarabesire tea, a vulure rai gao tea, luqara rai gao tea, siu hate bui evi lure. ");
INSERT INTO omb_vpl VALUES ("DN3_28","028_3_28","DAN","3","28","28","I ratahigi move, “Galohagi na Huqe Mauri noi Sedrak, noi Misak, me noi Abednigo! U hora na nona lenao mo vagamwasoi na tangaloi ngerelehe rau ladohogo lune. Rai tabe na nogu leo tea me rai lado na nora mwasoana tea. Ram tabana me ram galohagi na nora Huqe Mauri hogosie! ");
INSERT INTO omb_vpl VALUES ("DN3_29","028_3_29","DAN","3","29","29","Huri hi, a nogu leo mwere: a tangaloi dena hava vanue sige hava leo, mo veve asisigi na leo suvohi na Huqe Mauri noi Sedrak, Misak, me i Abednigo, nain tei vurivurire me a valera rain rurungudo ram vusi vuine. Hate huqe wagineu vage huri ve vin vagamwasoi mwerehi.” ");
INSERT INTO omb_vpl VALUES ("DN3_30","028_3_30","DAN","3","30","30","Lo tagugi, i ratahigi mo ragasi Sedrak, Misak me i Abednigo sulo here lalawua lolo togagi venue tau Babilon.");
INSERT INTO omb_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","A leo noi Huqe mo veve lawe Jona netui Amitai mweragi. ");
INSERT INTO omb_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Go vano siseri lo vanue renge lawua Niniva, go toretore lawera huri a nora doridori esi mo hamai lolo nagogu.” ");
INSERT INTO omb_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Maraga i Jona mo toa deni Huqe huri vena vano lo vanue Tasis. Mo hivo vine Soba mo haqe na anga mo vano huri na wawahao hi vage. Mo voli na turegine vunu mo kalo lo anga mo toa mo vano Tasis vagahao deni Huqe. ");
INSERT INTO omb_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Nge i Huqe mo hora na langi huire talolo tahi mo vai na tahi mo maragaraga mo asi lawuagi, ngere lo anga ram lado vena a anga vin mweduru. ");
INSERT INTO omb_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","A bosiguru lo anga ram matagu lawuagi ngere gagategalegi ram tataro lawe na nora huqe ve na buluire, me ngere ram tuli na lakolako dena anga talolo tahi huri ve a anga na mamarae. I Jona lo taro hi u mesuri hivo lo buloi anga u meturu geluve. ");
INSERT INTO omb_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","I toga lo vohe mo haqea move, “?Ei huri havai gom maturu mwere ngaha? Maraga, go tataro lawe na nom huqe bataha vin bului ginde dain mese dono.” ");
INSERT INTO omb_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Siu a bosiguru lo anga ram veve lawera gagategalegi vena, “Nen vumai, da tuli na taisi da higesie huri ve hine mo vuragi na vui tatuana leheno.” Ram tuli na taisi mo soi lui Jona. ");
INSERT INTO omb_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Siu ram huie, “?Go veve lawe gamai huri ve a gineu lehe mo vai dam romasi a bugui hine? ?Gu vei na havagi? ?Gom vomai logo me a tanomu logo? ?Gom vomai dena duvi hava tangaloi?” ");
INSERT INTO omb_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Jona mo duvi move, “Neu a Hibru me neu nam tataro lawe Huqe i Huqe lolo taetae, nge u vei na tahi mena tano mamaha.” ");
INSERT INTO omb_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Mo vaire ram matagu liu me i ngere ram huie, “?Gu vei na havagi?” Siu ram ilo huri ve nge mo toa dena Huqe, huri nge u veve sere lawera tomue beno. ");
INSERT INTO omb_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Navo ram lalawua vohogi me ngere ram huie, “?Gamai gai vei wuraha lawego hurivena a langi na hivo me a tahi na tamwata?” ");
INSERT INTO omb_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Me nge mo veve lawera vena, “Nen wali eu me nem tuli eu hivo lolo tahi. Mwerehi vin veie na tahi vin mesuri ba neu nau iloe huri vena neu nau veie tau navo ramo lawoa ram saugi gimiu.” ");
INSERT INTO omb_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Me ngere ram hue mo hage varea lo vanue, nge maraga hatie rai vei telai ba a tahi mo asi mo vagevage. ");
INSERT INTO omb_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Me ngere ram ware lawe Huqe ram veve vena, “Huqe go mese siregi gamai gam mate lo tanoi tangaloi lehe, nigo goin mese vai na daine mo vuragi na bugumei. Nge Huqe go vei hava gineu hi gu tarani.” ");
INSERT INTO omb_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Me ngere ram wali Jona sueulu ram tulie tahivo ta lolo tahi me a tahi mo taqao. ");
INSERT INTO omb_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Ngere ram matagu, ramo matagu liu garagara siu ngere ram lai bulara kankarue, ram hogohogo lawe na Huqe me ram vai na nora waratau sao huri ve rai tabana nona. ");
INSERT INTO omb_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Siserigi hi i Huqe mo vai na ige lawua mo dono Jona, siu i Jona u toga lolo taqangi ige a bongi gaitolu. ");
INSERT INTO omb_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Lolo ige i Jona mo tataro lawe na Huqe nona Huqe Mauri. ");
INSERT INTO omb_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Me mo veve vena, “Neu nau ware mena nongu romasi lawua lawe na Huqe, me nge mo duvi na dilogu laweau tavohe nam toga lolo tanoi mateana. Neu nau ware huri na buluiana, me nge mo duvi na nongu ngarana. ");
INSERT INTO omb_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Me i nigo gu tuli eu ta lolo tahi bue, talolo buloi tehi, me a wai halehale mo dalieu doluegi siu a nomu navo ram tawogawoga ram gagaliu eu. ");
INSERT INTO omb_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Siu nam veve vena, ‘Neu rau tuli eu nau vano dena nagomu mena matamu, nge nain leo taligu ta lolo Sara Gogona.’ ");
INSERT INTO omb_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Tahi buegi mo dali eu mo dadari lo mwagoro gu a tahi mo dali eu mena lumusi mo vauhi deli na qatungu. ");
INSERT INTO omb_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Lolo vui vusi neu nau hivo vuine, a ureure u wiribibi eu vagituei, nge nigo nogu Huqe Mauri gu ragasi eu nam hage aulu dena walu. ");
INSERT INTO omb_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Nogu mwasoana mo wiriwiri namo lado haqego Huqe, me a nongu tataro mo avu lawego lolo nomu Sara Gogona. ");
INSERT INTO omb_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ngere hi ramo ladohogo lure tagaro vurogi rau tudori dena vaigarea noi Huqe. ");
INSERT INTO omb_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Nge i neu nain bugogogi na ahi vevegarea lawego, neu nain hure boniboni lawego. Mwere nau waratau, ve nain veie vin garea. Huqe, nge u vagamwasoi eu.” ");
INSERT INTO omb_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Me i Huqe mo hora na ige, mo luegi Jona talo ute mamaha. ");
INSERT INTO omb_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Siu a leo noi Huqe mo vumai lawe Jona vaga tuegi, mo veve vena, ");
INSERT INTO omb_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Go maraga go vano lo vanue renge lawoa Niniva. Siu goin toregi na nongu leo ngehinge neu nain vevea lawego.” ");
INSERT INTO omb_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Me i Jona mo maraga mo vano Niniva mwerehi i Huqe u horae. Niniva a vanue renge lawoa nge mo lai na rani gaitolu dam dige ginie. ");
INSERT INTO omb_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Me i Jona mo tavuigi mo dige mo vano lo togagi venue hinge mo lai na rani gategale. Ngeie mo toretore mo veve vena, “Niniva vin veiana vohogi lolo rani ngavulugaivesi.” ");
INSERT INTO omb_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Siu tangaloi ngere tau Niniva ramo ladohogo lui Huqe Mauri. Ngere ram toregi na valiveli. Me ram luqegi na luqe bagi, mo tavuigi lo tangaloi lalawoa mo dadari meire hinge rau biti. ");
INSERT INTO omb_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Me tavohe a leo mo bulusi na ratahigi lawoa tau Niniva, me ngeie mo labe aulu dena herena. Mo lai vohogi na luqana denie, me ngeie mo luqegi na luqe masuesue, me mo toga lolo qie. ");
INSERT INTO omb_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Me ngeie mo tau na nona leo mo vano turuturu na Niniva vena, “A leo lehe mo vumai dena ratahigi me a nona tangaloi lalawoa, Vena a tangaloi mena kankarue a bulugi mena sibsib ngere rain mese gagani. Ngere rain mese gagani, ngere rain mese gani duvu me ngere rain mese inu wai. ");
INSERT INTO omb_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Siu ngeie mena kankarue ramo luqegi na lumqe masuesue. Rain ware hage lawe Huqe Mauri mena huire, ngere tangaloi gagategalegi rain tudori dena turegire ngere hinge rau esi, mwere na gilugilu, me a vai gagarasigi tangaloi gena dorire rau siaga. ");
INSERT INTO omb_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","?Hine mo ilo? Vena vin tudori vin hahagavi me vin lado dori dena nona lologagasi, siu huri ginde dain mese mate.” ");
INSERT INTO omb_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Huqe Mauri mo lehire vena rau lado mavagi nie me a doridorire u veie ramo tudori dena nora turegi rau esi me mo hagavire ngeie mo hahagavi huri na leo hinge u vevea lawera, siu ngeie he vaie tea. ");
INSERT INTO omb_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Nge i Jona hateve u havuhevu me nge mo mero. ");
INSERT INTO omb_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Nge mo tataro lawe Huqe, “?O Huqe nge ngaha hi nau vevea tavohe namo tino tau lo tanongu? Giniehi neu nau veie tomue vena nain toa nain vano Tasis. Huri nau ilo huri vena nigo a Huqe Mauri gu vaigarea lawe na nomu tavului vuro, me gu hahagavi, gom mero rorongo, nge a nom vaigarea u lawua liu, siu nigo goi vei lei vena goi dori na domimu vena goi mese arahi na tangaloi. ");
INSERT INTO omb_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Siu Huqe, gon lai vohogi na nongu mwasoana deni eu, u garea huri vena nan mate denie hi ve nain toga mwaso.” ");
INSERT INTO omb_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Siu, i Huqe mo veve vena, “?U garea huri vena goin mero?” ");
INSERT INTO omb_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Jona mo mwalua me mo toga lo ute suvohi na matenaho mo kalo dena vanue renge. Ngeie mo vai na nona siusiu, me mo toga lolo vavagi me mo leo huri vena havagi vin veiana lawe na vanue renge. ");
INSERT INTO omb_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Me i Huqe Gogona mo veve vena, nain rivu na kasrael siu vin meuri vin hage lo ului Jona vin mamalu goro na qwatune, ngeie na mese romasi, nge na rongareagi na kasrael hi mena havusie. ");
INSERT INTO omb_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Nge i Huqe Mauri u hora na nuve lolo robongi a nuve hinge u geni na kasrael hi mo goru. ");
INSERT INTO omb_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Siu tavohe a matenaho mo kalo, i Huqe Mauri mo hora na langi mwamwavi mo vumai lo matenaho kalo, mo aho talo qatui Jona vava a nago dodo mo vaie. Me ngeie mo hui Huqe Mauri, huri na nona mwasoana vena ngeie na mate, “U garea denie hinge ve nan toga mwaso.” ");
INSERT INTO omb_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Siu i Huqe Mauri mo veve lawe Jona vena, “?U garea huri vena nigo goin mero huri na kasrael hi?” Me ngeie mo veve vena, “Io, u garea ve neu nan mate.” ");
INSERT INTO omb_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","I Huqe mo veve, “Nigo gom romasi huri na kasrael hinge nigo hateve gu veie vena mauri na lawoa. Nge u meuri lolo bongi siu mo mate lolo bongi. ");
INSERT INTO omb_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","?Siu neu nain mese romasi huri na vanue lawoa Niniva ngehi? A tangaloigi rau sao liue na teri vatugi vudolue avigi ngavulu geirue. I ngere rau haroe huri ve a limara matue ngehi logo, a mawiri ngehi logo. Siu a kankarue u sao vage.”");
ALTER TABLE omb_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
