﻿USE sofia;
DROP TABLE IF EXISTS sofia.oboNT_vpl;
CREATE TABLE oboNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES oboNT_vpl WRITE;
INSERT INTO oboNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Na, ini en kos mgo ngaran to kovuyyahan ni Disas Krays no lubbad ni David woy Abraham. ");
INSERT INTO oboNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham kos amoy ni Isaac woy si Isaac kos amoy ni Jacob, woy si Jacob kos amoy ni Juda woy to mgo suwod din. ");
INSERT INTO oboNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda kos amoy ni Fares woy Zara, (si Tamar kos inoy ran). Na si Fares kos amoy ni Esrom, woy si Esrom kos amoy ni Aram. ");
INSERT INTO oboNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram kos amoy ni Aminadab, woy si Aminadab kos amoy ni Naason, woy si Naason kos amoy ni Salmon. ");
INSERT INTO oboNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Na si Salmon, noko-osawa ki Rahab woy dos anak dan, si Boas. Ini mandad si Boas, noko-osawa ki Ruth woy dos anak dan, si Obed. Si Obed, amoy ni Isai, ");
INSERT INTO oboNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","woy si Isai kos amoy ni Harin David. Ini si David, amoy ni Solomon woy dos inoy rin, sawa ni Urias dangan. ");
INSERT INTO oboNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Na si Solomon kos amoy ni Roboam, woy si Roboam kos amoy ni Abias, woy si Abias mandad kos amoy ni Asa. ");
INSERT INTO oboNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa kos amoy ni Josafat, woy si Josafat kos amoy ni Joram, woy si Joram mandad kos amoy ni Uzias. ");
INSERT INTO oboNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Uzias kos amoy ni Jotam, woy si Jotam kos amoy ni Acaz, woy si Acaz kos amoy ni Esequias. ");
INSERT INTO oboNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Esequias kos amoy ni Manases, woy si Manases kos amoy ni Amos, woy si Amos kos amoy ni Josias. ");
INSERT INTO oboNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Na si Josias kos amoy ni Jeconias woy to mgo suwod din. Idda en no timpu, id dakop kos mgo toho Israel woy id piyod diyon to Babilonia. ");
INSERT INTO oboNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nopongnga idda, id tobbow si Salatiel no iddos amoy rin, si Jeconias. Na ini mandad si Salatiel, amoy ni Sorobabel. ");
INSERT INTO oboNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Sorobabel kos amoy ni Abiud, woy si Abiud kos amoy ni Eliaquim, woy si Eliaquim kos amoy ni Azor. ");
INSERT INTO oboNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Na si Azor kos amoy ni Sadoc, woy si Sadoc kos amoy ni Aquim, woy si Aquim kos amoy ni Eliud. ");
INSERT INTO oboNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud kos amoy ni Eleazar, woy si Eleazar kos amoy ni Matan, woy si Matan kos amoy ni Jacob. ");
INSERT INTO oboNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jacob kos amoy ni Jose no sawa ni Maria. Na, si Maria kos inoy ni Disas no id ngoranan to Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","De-en duwon sopuu-oppat no linubbaran pomon ki Abraham taman ki David, woy sopuu-oppat mandad no linubbaran pomon ki David taman to koddakop to mgo toho Israel nid piyod diyot Babilonia. Duwon mandad sopuu-oppat no linubbaran pomon to koddakop taman to kodtobbow taddot Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na, iling ka-ay kos kodtobbow ni Disas Krays. Iddos inoy rin no si Maria, od osowan ni Jose. To waa pa sikandan id po-ogkottoy, movoddos don sikandin ukit to kotuusan to Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Si Jose nod osawa kandin, morumoruma to mgo suhu to Monama, piru dii sikandin od kopiyan nod ko-ilawan si Maria. De-en nokopuhawang sikandin nod suwayan din si Maria no waa duma nod pokosaddoo. ");
INSERT INTO oboNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Na, to id puhawang din pa idda, id pokita kandin kos ponolihan to Monama ukit to tohenoppon. Mid ikahi iddos ponolihan to, “Jose no koubbaran ni David, yo kod aang-aang nod osawa ki Maria, su iyon unayan no movoddos sikandin, ukit to kotuusan to Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Od anak sikandin to mama, woy ngoraniyu sikandin ki Disas, oyya su sikandin kos od tobbus to mgo minuvu rin pomon diyot saa ran.” ");
INSERT INTO oboNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na notomanan inis langun, su amoy od kotuman iddos id po-ikahi dangan to Monama ukit to propeta no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Dos sokkad no mongovay, od movoddos woy od anak sikandin to mama. Iddon anak, od ngoranan to Emmanuel,” no iddos kohulugan, dos Monama duma keta. ");
INSERT INTO oboNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","De-en to nokohimata si Jose, id puungan din iddos id suhu to ponolihan, woy id osawa rin si Maria. ");
INSERT INTO oboNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Piru waa rin loyuki si Maria to waa pa tobbawi. Na, to id tobbawan don sikandin, id ngoranan ni Jose iddos anak ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na, to id tobbow si Disas diyot bonuwa to Betlehem no sakup to Judea iddot timpu no si Herodes kos hari, duwon mgo minuvu no id pomon tid tollak nid inguma riyot Jerusalem. Sikandan, od kotuig nod ontong to kohulugan to mgo bitu-on. ");
INSERT INTO oboNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Na mid intud sikandan, kahi ran to, “Ingkon man iddos id tobbow no hari to mgo Judio? Su nokita roy iddos bitu-on nid loppow riyon lomig tid tollak no patow to kodtobbow rin, de-en mid undini koy amoy'd simba kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","To norinog idda ni Harin Herodes, dii ron sikandin od pokodto-ii, woy ungketen dad en mandad iddos langun nid oubpa riyot Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","De-en id po-umow rin iddos mgo ponguu to tohodbuwis woy dos mgo tohodnonaw to Suhu ni Moises. Na id inturan din sikandan, kahi rin to, “Ingkon man od tobbow iddos Mesiyas?” ");
INSERT INTO oboNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mid tavak sikandan to, “Diyot Betlehem no sakup to Judea, su ini en kos id sulat to propeta no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sikkow, Betlehem no riyot prubinsya to Judea, ahad disok ka no bonuwa, od kovantug ka taddot dumon mgo bonuwa no sakup to Judea. Oyyos od pomon duwot kikow iddos sokkad no ponguu nod hari to koddin mgo minuvu no idda en so koubbaran ni Israel.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","To norinog idda ni Herodes, id po-umow rin iddon mgo minuvu no siksikandan da. Woy id inturan din ko kannu id loppow dos bitu-on. ");
INSERT INTO oboNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Na id po-undiyon din sikandan to Betlehem, kahi rin to, “Undiyon kow woy ooyyari row tod nangkap iddos anak. Woy otid kokita rowd, livod kow vo ka-ay woy ponudtuli a, su od undiyon a mandad amoy'd simba kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nopongnga idda, id logkiyat don iddon mgo minuvu. To kod-ipanow ran, nokita ran mandon iddos bitu-on no nokita ran to riyon pa sikandan to lomig tid tollak, woy dakkoo en kos kahaan dan. Id ikuu ran idda taman to id soro riyot pantok to baoy no rutun en iddos anak. ");
INSERT INTO oboNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Na id usok dan taddon baoy, woy nokita ran don iddos anak woy dos inoy rin no si Maria. Mid lingko-od sikandan amoy'd simba taddot anak. Id ukaa ran iddos mahaa no mgo piniyoddan dan, woy id boggoy ran taddot anak iddos buawan, mammut no insenso woy dos pomammut no mira. ");
INSERT INTO oboNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","To kod-uli ran, id baya sikandan to osson daan, su id pomonduwan sikandan to Monama ukit to tohenoppon no dii ran don od livod diyot ki Herodes. ");
INSERT INTO oboNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na, to noko-ipanow ron iddos mgo minuvu no id pomon tid tollak, id pokita ki Jose iddos ponolihan to Monama ukit to tohenoppon, woy kahi rin to, “Onnow ka. Piyoddow kos anak woy inoy, woy paahuy kow po-undiyon to Ehipto. Oubpa kow pa tahad dutun taman tod oseng a koniyu no od pokolivod kowd, oyyos konnod kouhoy, id po-inangkap ni Herodes kos anak amoy'd imotayan.” ");
INSERT INTO oboNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","De-en id onnow si Jose woy id piyod din iddos anak duma taddot inoy, woy id ipanow ran to idda ra en no bulli po-undiyon to Ehipto. ");
INSERT INTO oboNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Na riyon en sikandan id oubpa taman tid patoy si Herodes. Notomanan ini amoy'd kotuman iddos id ikahi to Monama nod Longaggon ukit to propeta no mid ungketen to, “Id umow ku kos koddin anak nod leggua pomon diyot Ehipto.” ");
INSERT INTO oboNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","To nosorollan ni Herodes no iddos mgo minuvu nid pomon lomig tid tollak, waa id tuman taddot tandu ran nod livod diyot kandin, nolinglingasa sikandin. De-en id suhu rin kos mgo sundau rin nod imotayan kos langun no anak no mama pomon diyot lammid tobbow taman to oruwon lahun kos idad no id oubpa riyot Betlehem woy riyot mgo bonuwa no morani rutun. Iyon din id ikuu, iddos timpu no id ponudtuu taddot mgo minuvu no id pomon tid tollak iddot id inturan din sikandan ko kannu id loppow iddos bitu-on. ");
INSERT INTO oboNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","De-en notuman iddos id ikahi to propeta no si Jeremias no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Od korinog kos kodpondaawit diyon to Rama. Id sinoggow si Raquel atag to mgo anak din, woy dii ron od ko-uus kos ginawa rin, oyyos id patoy ron man dos mgo anak din.” ");
INSERT INTO oboNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na, to id patoy ron si Herodes, duwon ponolihan to Monama nod Longaggon no id pokita ki Jose riyot Ehipto ukit to tohenoppon. Kahi taddot ponolihan to, ");
INSERT INTO oboNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Onnow ka. Piyoddow kos anak woy inoy, woy livod kow riyot ingod to Israel, oyya su id patoy ron iddos od kopiyan nod imatoy ruwot anak.” ");
INSERT INTO oboNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","De-en id onnow si Jose woy id piyod din iddos anak woy dos inoy, woy id uli sikandan diyot ingod to Israel. ");
INSERT INTO oboNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Piru to norinog ni Jose no si Arquelao no anak ni Herodes kos id suvaa nid hari riyot Judea, novaakkan sikandin nod undiyon. Na, id pomonduwan don mandon sikandin to Monama ukit to tohenoppon, de-en id undiyon sikandan to prubinsya to Galilea. ");
INSERT INTO oboNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na, diyon don en sikandan mid oubpa to bonuwa to Nazaret. De-en notuman don iddos id ikahi to mgo propeta no mid ungketen to, “Od ngoranan sikandin no toho Nazaret.” ");
INSERT INTO oboNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na, to id lihad kos pilon mgo lahun, mid undiyon si Juan no Tohodboutismu to noka-awoy-awoy'n lugaa to Judea. Id ponudtuu rin kos kahit Monama riyot mgo minuvu no mid undiyon to kandin. Kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Sondit kow woy tanan kowd to mgo saa row, su asow ron kos kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan en iddos od tommanon ni propeta Isaias no, “Duwon monokkaan bawos diyot noka-awoy-awoy'n lugaa no mid ungketen to, ‘Ponaya row kos pusung dow atag tod Longaggon, woy tulidda row kos od ukitan din.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na iddos umpak ni Juan, binovallan pomot bowvuu to kamelyo woy dos ollon din, binovallan pomot kindaa to oyama. Iyon ko-uyahan din, mgo apang woy tonnob. ");
INSERT INTO oboNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mid undiyon to kandin iddos mgo minuvu no id pomon diyot Jerusalem, pomon diyon to intirut prubinsya to Judea woy pomon diyot mgo lugaa no moranit Oweg to Jordan. ");
INSERT INTO oboNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Id ponudtuu ran no id sondit woy id tanan don sikandan to mgo saa ran, woy id poboutismu sikandan ki Juan diyot Oweg to Jordan. ");
INSERT INTO oboNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Na, duwon mandad mgo ponguu to pomokayon to Judio nod ngoranan no Pariseo woy Saduseo no id undiyon amoy'd poboutismu. Piru to nokita rin sikandan, id ikohiyan din to, “Sikiyu, iling kow to mgo uwod nod laas! Kunan dow ayu kod pokolegguang kowd taddot od ingumon kodsilut to Monama otid koboutismuwan kowd. ");
INSERT INTO oboNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Otik bonnaa en no id sondit woy id tanan kowd to mgo saa row, posivonnali row ini ukit to koniyun pinuungan. ");
INSERT INTO oboNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yo kowd pososalig no dii kow od silutan pomon to koubbaran kow ni Abraham. Od ikohiyan ku sikiyu, no ahad inis mgo batu, od kovovallan to Monama no koubbaran ni Abraham. ");
INSERT INTO oboNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pomotawi row! Dos kodsilut to Monama koniyu, noko-iling to porokuu no nopanoy ron nid tampod to kayu. Na, iddos ipat kayu no diid bovunga to moppiya, od tompoddon woy id lumbag diyot apuy. ");
INSERT INTO oboNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Od boutismuwan ku sikiyu to oweg, patow no id sondit woy id tanan kowd to mgo saa row. Piru konnod kouhoy, duwon od tundug koddi no lampas pa no motuus, su konna a ollog ahad kodbitbit da to sandalyas din. Uhis no Ispiritu woy apuy kos id boutismu rin koniyu. ");
INSERT INTO oboNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Od pod-ossan din iddos mgo minuvu no moppiya woy morat iling to minuvu nod oottap to trigu. Dos moppiyon trigu, id ta-aw rin diyot budiga, piru iddos mgo ottap, od tirukkan din diyot apuy no konnod ko-ovukkan.” ");
INSERT INTO oboNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na riyot timpu to kodboutismu ni Juan, mid undiyon si Disas to Oweg to Jordan pomon diyot prubinsya to Galilea amoy'd poboutismu kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Piru dii nanoy od boutismu si Juan kandin. Kahi rin to, “Siyak kos ollog nod boutismuwan du, konna siyak kos od boutismu kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Piru mid tavak si Disas to, “Boutismu-i a en, su ollog en nod kotuman ta iddos langun no id kopi-it Monama.” De-en id boutismuwan ni Juan si Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","To noboutismuwan don si Disas, id go-un sikandin diyot oweg. Woy idda ron en, nopokes kos langit, woy nokita rin no id lonna iddos Uhis no Ispiritu riyot kandin iling to soopati. ");
INSERT INTO oboNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na, duwon bawos pomon diyot datas to langit no mid ungketen to, “Ini en kos Anak ku no id dokollan ku to ginawa woy oraroy ku nid kahaa-i.” ");
INSERT INTO oboNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na, id piyod si Disas to Uhis no Ispiritu riyot noka-awoy-awoy'n lugaa amoy od geddaman ni Moivuyan kod kopiyod sikandin nod puung to saa. ");
INSERT INTO oboNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Id puasa si Disas daom to oppat-no-puun allow woy bulli, woy nopongnga, oraroy sikandin id gutasan. ");
INSERT INTO oboNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na id porani si Moivuyan kandin woy mid kahi to, “Otik mooggot ka en no Anak to Monama, suhuwow inis batu nod kovovallan no paan.” ");
INSERT INTO oboNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Piru mid tavak si Disas to, “No-ikahi riyot Nosulat no Kahit Monama no, ‘Konna ra koka-an kos od poko-uyag to minuvu, ko konna, iddos ipat kahi to Monama.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nopongnga idda, id piyod sikandin ni Moivuyan diyot Jerusalem woy id poohinat din diyot oray'n motikang no sakup to templo. ");
INSERT INTO oboNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Na id ikohiyan din si Disas to, “Otik sikkow en kos Anak to Monama, timballu ka riyot dosiyung, su no-ikahi riyot Nosulat no Kahit Monama no, ‘Od suhuwon to Monama iddos mgo ponolihan din to kodtavang kikow amoy dii ka od komonnu. Od saakon ka nikandan amoy ahad ikos pa-a ru, diid kohisgisan.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Piru mid tavak si Disas to, “No-ikahi mandad diyot Nosulat no Kahit Monama no, ‘Yo ru geddami kos Monama nod Longaggon du.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nopongnga idda, id piyod sikandin ni Moivuyan diyot oray'n mowwet no buvungan. Woy id pokita rin iddos langun no kohoriyan ka-ay to ampow't ingod woy dos mgo korotuwan dutun. ");
INSERT INTO oboNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kahin Moivuyan to, “Id boggoy ku kikow inis langun otid lingko-od ka woy od simba koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mid tavak si Disas to, “Awa ka, Moivuyan! No-ikahi riyot Nosulat no Kahit Monama no, ‘Iyon du ra simba-ana iddos Monama nod Longaggon du woy sikandin da kos duurumanniyu.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na mid awa ron si Moivuyan, woy id inguma iddos mgo ponolihan amoy'd tuhanuu ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na, to norinog ni Disas no noprisu si Juan, id livod sikandin diyot Galilea. ");
INSERT INTO oboNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mid tanan sikandin diyot Nazaret, woy id undiyon to Capernaum amoy'd oubpa rutun. Inin bonuwa, diyon lomig to ibpit to Lanow't Galilea no sakup to livuta to koubbaran ni Zabulon woy Neptali. ");
INSERT INTO oboNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Notomanan ini, su amoy od kotuman iddos id po-ikahi to Monama ki propeta Isaias no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“dos mgo ingod to Zabulon woy Neftali, noko-ibpit to lanow woy nokoripaa to Oweg to Jordan. Inin mgo lugaa, sakup to prubinsya to Galilea nid oubpan to konna mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Iddos mgo minuvu rutun, noko-iling tid oubpa riyot mosukirom. Iling to id patoy ron sikandan, oyyos waa ran id kilaa to Monama. Piru init od ingumon allow, od kokita ran don kos ma-awang no se-aa nod taddow kandan.” ");
INSERT INTO oboNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na pomon taddon timpu, mid tigkanoy si Disas to kodponudtuu to kahit Monama. Kahi rin to, “Sondit kow woy tanan kowd to mgo saa row, su asow ron kos kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sokkad no allow, laggun tid ipanow si Disas diyot ibpit to Lanow't Galilea, nokita rin iddos oruwon toosuwod no si Simon no id ngoranan mandad ki Pedro woy dos ari rin no si Andres. Id ooppan dan to pukut su mgo tohodngongaap me-en sikandan. ");
INSERT INTO oboNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kahin Disas kandan to, “Duma kow koddi. Konnad ngaap kos od ingutollon dow, ko konna, od nonawwan ku sikiyu nod ingutoo to mgo minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Idda ron en, id tonanan dan iddos mgo pukut dan woy mid duma ran kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Na ponayun mid ipanow si Disas diyot ibpit to lanow, woy nokita rin iddos oruwa mandad no toosuwod no si Santiago woy si Juan no mgo anak ni Sebedeo. Id ounsad sikandan diyot bollangay duma to amoy ran no id oupiya to mgo pukut. Na, id umow sikandan ni Disas amoy'd duma kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Idda ron en, id tonanan dan iddos amoy ran woy dos bollangay woy mid duma ran ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na, id lingkus ni Disas iddos intirut prubinsya to Galilea. Id nonaw sikandin diyot mgo simba-an to Judio woy id ponudtuu to Moppiyon Dinoggan moka-atag to kodharit Monama, woy id bowiyan din kos nokod-osso-osson bohok. ");
INSERT INTO oboNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","De-en novantug sikandin diyon to intirut lugaa to Siria. Pomon tadda, id piyod to mgo minuvu iddos langun nod kovohokan diyot kandin, dos id geddam to oray'n mosakit, dos id ponlosuran to busow, dos od pombovuyon woy dos mgo minuvu nid patoy kos lawa. Na langun dan, no-uliyan. ");
INSERT INTO oboNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Purisu ahad ingkon sikandin od isau, oray'n mo-uraa kos mgo minuvu nod dumoruma kandin pomon diyot Galilea, diyot Decapolis, diyot Jerusalem woy riyon to dipaat Oweg to Jordan. ");
INSERT INTO oboNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","To nokita ni Disas iddos mo-uraan minuvu, id tikoddog sikandin diyot lovuntud woy mid ounsad dutun. Woy id lolivuung diyot kandin iddos mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Na mid tigkanoy sikandin id nonaw, kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Moppiya kod kotomanan taddot minuvu no nokosaddoo no waa en kogahan dan otik waa tavang to Monama, oyyos sikandan kos od pokolonug to kodhari rin. ");
INSERT INTO oboNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Moppiya kod kotomanan taddot minuvu nid lanu pomon to saa, oyyos od uuson to Monama kos ginawa ran. ");
INSERT INTO oboNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Moppiya kod kotomanan taddot minuvu nod poobbava, oyyos sikandan en kos od pokokomunoy to lammin ingod init morin allow. ");
INSERT INTO oboNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Moppiya kod kotomanan taddot minuvun dakkoo kos ingowollon nod puung to id kopi-it Monama, oyyos od tovangan din en sikandan nod puung tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Moppiya kod kotomanan taddot minuvun eeruwon, oyya su iddos Monama od pokita to eru kandan. ");
INSERT INTO oboNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Moppiya kod kotomanan taddot minuvun molinis kos pusung, oyyos od kokita ran kos Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Moppiya kod kotomanan taddot minuvu nod pod-uli to koroniyan, oyyos sikandan en kos od ngoranan no mgo anak to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Moppiya kod kotomanan taddot minuvu nid posupittan pomon to kodtuman to id kopi-it Monama, oyyos sikandan en kos no-iraom to kodhari rin. ");
INSERT INTO oboNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Moppiya kod kotomanan dow otik duwon od sumpalit, od posuppit woy'd doddora-at koniyu pomon to koddumoruma row koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ungketen dad en mandad kos id puungan dan taddot mgo propeta dangan. De-en kahaa kow, oyya su dakkoo kos ganti no id panoy koniyu riyot datas to langit.” ");
INSERT INTO oboNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Na ponayun mid nonaw si Disas, kahi rin to, “Sikiyu no mgo tinodduwan ku, noko-iling kow to assin ka-ay to ampow't ingod. Piru otid motabbang don ini, dii ron en id pokopolivod kos nanam. Worad mandad koru-anon ka-ay, de-en id sowela ron woy'd geeheddan to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Noko-iling kow mandad to suu nod pokoma-awang to poomdom to mgo minuvu ka-ay to ampow't ingod. Iddos bonuwa no riyot buvungan, oraroy en idda nod kokita. ");
INSERT INTO oboNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Waa minuvu nod loottom to suu woy kopongnga, od poongkobban din to lobban, ko konna, id ta-aw rin idda riyot od sopatan amoy'd kotorawwan kos langun diyot baoy. ");
INSERT INTO oboNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","De-en iling dad mandad tadda, pooglogga row kos koniyun suu riyot isowwan to mgo minuvu amoy'd kokita ran kos moppiyon pinuungan dow, woy od doongon dan kos Amoy row riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Yo row poomdomma no mid undini a to ampow't ingod amoy od worannon kos mgo Suhu ni Moises woy dos id sulat to mgo propeta. Mid undini a amoy'd tumanon ku idda. ");
INSERT INTO oboNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Bonnaavonnaa nod ikohiyon ku koniyu, no laggun to duwon pa kos langit woy livuta, waa en ahad songo-litra o songo-tulduk nod kowora riyot mgo Suhu to Monama, oyyos ponayun en idda taman tod kotuman don kos langun. ");
INSERT INTO oboNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","De-en iddos ahad ondoy nod lempang to ahad sokkad no Suhu to Monama, woy id nonaw rin mandad diyot duma nod puung to ungketen, sikandin kos moobbava to langun diyon to kodharit Monama. Piru iddos od tuman woy'd nonaw mandad to duma nod tuman tadda, sikandin kos mowwet diyon to kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Purisu od ikohiyan ku sikiyu, no ko-ilangan no iddos kodtuman dow to id kopi-it Monama, od lampas taddot kodtuman dow to mgo tohodnonaw to Suhu ni Moises woy taddot mgo Pariseo, su otik konna, dii kow en od kolonug to kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Na ponayun mid nonaw si Disas, kahi rin to, “Norinog dowd iddos suhu to keton kovuyyahan no mid ungketen to, ‘Yo kow'd imatoy. Su iddos ahad ondoy nod imatoy, ko-ilangan nod piyoddon sikandin diyot tohodhukum amoy'd silutan.’ ");
INSERT INTO oboNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Piru siyak, ini kos od ikohiyon ku koniyu, no iddos ahad ondoy no duwon langot diyot duma, od silutan en. Woy dos od po-ilow to duma nod ikahi no, ‘Waa utok du,’ od piyoddon diyot mowwet no tohodhukum. Woy idda mandad so od ikahi no, ‘Bangog ka en,’ iyon din od ingumannon, iddos linow't apuy. ");
INSERT INTO oboNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“De-en ahad diyon kad to daom to templo amoy od boggoy't buwis, piru nosompottan du no duwon minuvun nomorat kikow su nokopuung ka to konna ollog diyot kandin, ");
INSERT INTO oboNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na tuwos du pa riyot isowwan to buwisanan kos buwis du. Unna-aw pa upiyanni kos koroniyan du taddon minuvu, idda pa livod ka amoy od boggoy to kikow'n buwis diyot Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Otik duwon minuvu nod uug kikow no nokopuung ka to saa, noonokkaliyu nod pokod-usoy kow go-os, to dii pa od inguma riyot hukumanan. Su otid poko-uma kow'd dutun, saddook id boggoy ka to tohodhukum diyon to pulis woy id poprisu ka. ");
INSERT INTO oboNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Bonnaavonnaa nod ikohiyon ku kikow, no dii ka en od pokolegguang otik dii ru od kovorayan kos langun no multa ru. ");
INSERT INTO oboNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Norinog dowd mandad iddos suhu no mid ungketen to, ‘Yo kow'd loivug.’ ");
INSERT INTO oboNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Piru siyak, ini kos od ikohiyon ku koniyu, no iddos ahad ondoy nod tongtong to ba-ay no molibmit kos kandin no poomdom, nokoloivug don sikandin diyot ginawa rin. ");
INSERT INTO oboNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","De-en otik mata ru kos unayan nod pokosaa ka, kootowd baling ika woy lumbag du. Su moppiya pa nod koworan ka to sokkad no sakup to lawa, kuntra to intirut lawa ru kos id lumbag diyon to linow't apuy. ");
INSERT INTO oboNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Woy otik kowanan no bollad du kos unayan nod pokosaa ka, tompoddowd baling ika woy id lumbag du. Oyya su moppiya pa nod koworan ka to sokkad no sakup to lawa, kuntra to intirut lawa ru kos id lumbag diyon to linow't apuy.” ");
INSERT INTO oboNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Na duwon mandad suhu no mid ungketen to, ‘Iddos ahad ondoy no mama nod suwoy to sawa rin, ko-ilangan nod boggoy to kosulatan diyot sawa rin no od posivonnaa to kodposuwayoy ran.’ ");
INSERT INTO oboNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Piru siyak, ini kos od ikohiyon ku koniyu, no iddos ahad ondoy'n mama nod suwoy to sawa rin no waa nopuungan no morat, iling to id usung din kos sawa rin diyot kodloivug otid osawa mandon. Woy idda mandad so mama nod osawa kandin, nokoloivug mandad.” ");
INSERT INTO oboNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Na ponayun mid ikahi si Disas to, “Norinog dow mandad iddos suhu riyot keton kovuyyahan no mid ungketen to, ‘Otid pongulivot kow, ko-ilangan en nod tumanon dow kos tandu row riyot isowwan tod Longaggon.’ ");
INSERT INTO oboNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Piru siyak, ini kos od ikohiyon ku koniyu, no otik od totandu kow, yo kow'd pongulivot diyon to langit, su idda en kos trunu to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yo kow mandad od pongulivot ka-ay to livuta, oyyos ka-ay en kos sikuwayan to pa-a rin. Woy yo kow'd pongulivot to Jerusalem su idda en kos bonuwa to novantug no Hari. ");
INSERT INTO oboNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yo kow od pongulivot nod ikahi to, ‘Od bottu pok uu ku ko id ouhus a,’ oyyos konna man sikiyu kos id bovaa to koniyun lawa. Ahad songo-silag to bowvuu row, dii kow man od pokopomoputi o od pokopometom. ");
INSERT INTO oboNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Iyon dow ra osenga no, ‘Oyya’ o ‘Konna’, su otid pongulivot kow pa, id pomon don idda ki Moivuyan.” ");
INSERT INTO oboNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Norinog dow mandad iddos suhu no mid ungketen to, ‘Dos minuvu nod pokovutud to mata to duma, od ungketennon en mandad kos mata rin, woy dos od pokopengow to ngipon to duma, od pengawan mandad.’ ");
INSERT INTO oboNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Piru siyak, ini kos od ikohiyon ku koniyu, no yo kow'd puung to morat diyot minuvu no id puung to morat koniyu. Iyon dow puungi, otid tobpiyon kos kowanan no bonnong dow, potabpi row mandad kos divauy. ");
INSERT INTO oboNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na otik duwon od kasu koniyu woy od ahaw to umpak dow, boggoy row mandad ahad iddos lapid no umpak dow. ");
INSERT INTO oboNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Otik duwon od pohos koniyu nod povava to piniyoddan din taman to sokkad no kilometro, bova-aw idda ahad taman to oruwon kilometro. ");
INSERT INTO oboNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Otik duwon od bovuyu koniyu, boggayi row sikandin, woy otik duwon od samboy, posombaya row.” ");
INSERT INTO oboNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Norinog dow iddos suhu dangan no mid ungketen to, ‘Ginowanni row kos mgo oukuy row, woy kolingasa-i row iddos od pongkuntra koniyu.’ ");
INSERT INTO oboNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Piru od ikohiyan ku sikiyu, no ginowanni row iddos od pongkuntra koniyu, woy dasaa kow atag taddot mgo minuvu nod posuppit koniyu. ");
INSERT INTO oboNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Su otid puungan dow ini, iddos botasanon dow, od poko-iling to botasanon to Amoy row riyot datas to langit. Oyyos waa od podmusingon din, su id pose-alan din to allow iddos moppiyon mgo minuvu woy idda mandad so morat. Id popiyoddan din to uran iddos mgo motallong woy idda mandad so konna motallong. ");
INSERT INTO oboNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Su otik iyon dow ra od ginowannon iddos id ginawa koniyu, duwon bo ganti nod kotanggap dow riyot Monama? Waa en! Oyya su ahad iddos mgo tohodsukut to buhis nod loimbung, od ginawa man mandad taddot id ginawa kandan. ");
INSERT INTO oboNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Woy otik iyon dow ra od olit-oliton iddos mgo oukuy row, duwon bo nopuungan dow no moppiya pa taddot duma? Waa en! Su ahad iddos mgo minuvu no waa id kilaa to Monama, od puung man to ungketen. ");
INSERT INTO oboNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","De-en pokita row kos waa kulang no kopiyannoy riyot duma, iling taddot Amoy row riyot datas to langit no waa en kulang to kopiyannoy rin.” ");
INSERT INTO oboNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Na ponayun mid nonaw si Disas, kahi rin to, “Ayyad-ayyad kow no konna kow od puung to moppiya amoy'd pokitakita to mgo minuvu. Su otik ungketen, waa od kotanggap dow no ganti pomon diyot Amoy row no riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“De-en otid boggoy kow riyot mgo worowora, yo row idda id pokitakita iling to id puungan taddot duma riyot daom to simba-an to mgo Judio woy riyon to doraanon. Id puungan dan idda, su amoy od doongon sikandan to mgo minuvu. Piru bonnaavonnaa nod ikohiyon ku koniyu, no worad od kotanggap dan no ganti pomon diyot Monama, oyyos nokotanggap don man sikandan to koddoong to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Piru sikiyu, otid boggoy kow riyot worowora, yo yo row idda ponudtuu ahad diyot oraroy row no oukuy, ");
INSERT INTO oboNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","su amoy waa en od pokosaddoo. Na, iddos Amoy row riyot datas to langit no iyon nokokita taddot ollos nid puungan dow, sikandin kos od kotuig koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Na otid dasaa kow, yo kow od iling to mgo minuvu nod po-uvag-uvag no mopompomakoy. Oyya su id kotoosi ran nod dasaa riyot simba-an to mgo Judio woy riyot doraanon amoy'd kokita to mgo minuvu. Bonnaavonnaa nod ikohiyon ku koniyu, no pomon to notanggap dan don iddos koddoong to minuvu, worad od kotanggap dan no ganti pomon diyot Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Piru sikiyu, otid dasaa kow, usok kow riyot kwartu row woy lookkob kow. Na rutun, dasaa kow riyot Monamon Amoy row no konnod kokita. Woy dos Amoy row no nokokita to langun no pinuungan dow, sikandin don kos od kotuig koniyu. ");
INSERT INTO oboNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Na riyot koddasaa row, yo row mo-uralla kos osengan dow no waa mgo koru-anon iling taddot id puungan to mgo minuvu no waa Monama. Su kunan dan kod pominoggon to Monama kos dosalon dan otik mowwet. ");
INSERT INTO oboNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yo kow od iling kandan, oyya su iddos Monamon Amoy row, nokosaddoo ron tapoy taddot ko-ilonganon dow, ahad waa kow pa id buyu kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Diyot koniyun koddasaa, ungketenna row to, ‘Amoy roy riyot datas to langit, muopa nod posivontuhon kos ngaran du. ");
INSERT INTO oboNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Muopa no iddos kikow'n kodhari, od inguma rinit ampow't ingod amoy iddos kikow'n id kopi-i, od kotuman dinit ingod iling taddot diyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Boggayi koy to koka-an nod ko-ilonganon doy inin allow. ");
INSERT INTO oboNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Posinsiya-i koy to mgo saa roy, iling to kodposinsya roy taddot nokosaa konami. ");
INSERT INTO oboNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tovangi koy no dii koy'd kopiyod to kodpuung to saa, woy id polegguanga koy riyot kororattan.’ ");
INSERT INTO oboNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Na otid posinsyan dow iddos nokosaa koniyu, od posinsyan kow mandad to Amoy row riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Piru otik dii row sikandan od posinsyan, na dii kow mandad od posinsyan to Amoy row riyot datas to langit.” ");
INSERT INTO oboNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Na ponayun mid nonaw si Disas, kahi rin to, “Otid puasa kow, yo row idda pokita riyot bonnong dow iling tod puungan to mgo minuvu no od po-uvag-uvag no mopompomakoy. Oyyos od livonglivong dan no diid pondappug woy diid ponuwat amoy od kokita to duma no id puasa sikandan. Bonnaavonnaa nod ikohiyon ku koniyu, no pomon to nokotanggap don man sikandan to koddoong to mgo minuvu, worad od kotanggap dan no ganti pomon diyot Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Piru sikiyu, otid puasa kow, iyon moppiya, pondappug woy ponuwat kow, ");
INSERT INTO oboNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","su amoy waa od pokosaddoo no id puasa kow. Iyon da nokosaddoo tadda, idda ra en so Amoy row no konnod kokita woy nokokita to langun no pinuungan dow, woy sikandin don kos od kotuig koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Yo kow od loimud to mgo korotuwan ka-ay to ampow't ingod, oyyos od kotkotton da en ini to anoy woy tangis, woy od usokkon ini to mgo tokawon diyot baoy row. ");
INSERT INTO oboNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Iyon moppiya, no loimud kow to mgo korotuwan diyot datas to langit, oyya su rutun, waa en anoy woy tangis nod kotkot woy waa mandad od poko-usok nod takow tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Su otik ingkon nokota-aw kos koniyun korotuwan, diyon en mandad kos koniyun ginawa.” ");
INSERT INTO oboNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Na inis mata, noko-iling to suu to lawa. De-en otik ma-awang kos kod-ontong du, ma-awang mandad kos tivuk no lawa ru. ");
INSERT INTO oboNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Piru otik mosukirom kos kod-ontong du, mosukirom mandad kos tivuk no lawa ru. De-en otid ikahi ka no ma-awang kos lawa ru, piru iyon bonnaa, mosukirom bos, na oray'n mosukirom kos tivuk no lawa ru!” ");
INSERT INTO oboNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Waa minuvu nod po-uripon to oruwon amu, oyyos od dokollan din to ginawa kos sokkad woy dos sokkad, id kolingasa-i rin. Od dumoruma sikandin taddot sokkad woy dos sokkad, id podtohon din. Na iling mandad tadda, otid po-uripon kow to soopi, dii kow en od pokopo-uripon to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“De-en od ikohiyan ku sikiyu, no yo kow od kaaggow to mgo ko-ilonganon dow to kod-oubpa, iling to koka-an, inommon woy'd umpakon dow. Su iddos koniyun umuu, lampas pa kos koru-anon taddot koka-an, woy dos lawa row, lampas pa kos koru-anon taddot umpak. ");
INSERT INTO oboNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ontongngi row man kos mgo manuk nod layanglayang. Waa ran id pomuwa, waa id kottu woy waa mandad budiga ran, piru id boggayan man sikandan to koka-an to Amoy ta no riyot datas to langit. Na, iyon kow pobbo no lampas pa kos koru-anon taddot mgo manuk. ");
INSERT INTO oboNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Woy sokkad pa, ondoy man koniyu kos od pokopoowwet to umuu row ahad sokkad da no uras ukit to laggow? Waa en! ");
INSERT INTO oboNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Woy mambot od kaaggow kow tod umpakon dow? Poomdomma row man iddos mgo bulak no id pontuvu. Waa ran id puung woy waa id ponobbii tod umpakon dan. ");
INSERT INTO oboNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Piru od ikohiyan ku sikiyu, no ahad si Harin Solomon no novantug to korotuwan din dangan, waa noko-umpak iling to kogolingoy to ahad sokkad ka-ay'n mgo bulak. ");
INSERT INTO oboNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Na, otik id pomogoling man to Monama kos mgo sabbot nod ko-uyag da ko-ungkay, piru simag od tirukkan don, konna vo lampas kow pa nod umpakan din? Ooy koniyu! Oray'n disok kos kopomakoy row! ");
INSERT INTO oboNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“De-en yo kow od kaaggow woy'd ikahi to, ‘Momonnu kid man moho ini! Ondan don kos od kannon woy'd inommon ta? Ondan don kos od umpakon ta?’ ");
INSERT INTO oboNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Oyya su iddos inaayun od kaaggow tadda, idda en so mgo minuvu no waa id kilaa to Monama. Piru sikiyu, yo kow'd kaaggow, su iddos Amoy row no riyot datas to langit, nokosaddoo no od ko-ilonganon dow en idda. ");
INSERT INTO oboNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Piru iyon dow unna-a tod nangkap iddos kodharit Monama woy dos kod-ikuu to kandin nid kopi-i, woy id potommu rin kos langun no ko-ilonganon dow. ");
INSERT INTO oboNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","De-en yo kowd od kaaggow taddot simag. Su ollog don iddos kosupittan no id inguma inin allow. Konna tad od timulan kos kosupittan ukit to laggow ta taddot simag.” ");
INSERT INTO oboNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Na ponayun mid nonaw si Disas, kahi rin to, “Yo kow'd hukum to duma amoy dii kow mandad od hukuman to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Su iddos kodhukum dow to duma, ungketen dad en mandad kos kodhukum koniyu to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Mambot oraroy kow od kita to disok no possok diyot mata to duma, piru id podtohon dow kos batang duwot mata row? ");
INSERT INTO oboNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Momonnu kow man od poko-oseng diyot duma no, ‘Od ongayon ku kos possok to mata ru,’ no duwon man batang duwot mata row? ");
INSERT INTO oboNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Od po-uvag-uvag kow no motallong. Unna-a row pa ongaya kos batang duwot mata row amoy oraroy row od kokita tod angoy kos possok to duma. ");
INSERT INTO oboNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Yo kow'd avoy od nonaw to kahit Monama riyot mgo minuvu no konnod kopiyan nod pominog, su noko-iling sikandan to mgo tuyyang woy bavuy. Oyya su ahad od boggayan dow pe-en to mahaa kos tuyyang, od kahaton kow rad en. Woy ahad od lumbahan dow to perlas kos mgo bavuy, od geeheddan dan da en idda.” ");
INSERT INTO oboNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Bovuyu kow riyot Monama woy od kovoggayan kow, nangkap kow woy'd pokokita kow, ponoktok kow woy od kolukatan kow. ");
INSERT INTO oboNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Su iddos ahad ondoy nod bovuyu, od pokotanggap en, woy dos od nangkap, od pokokita en, woy idda mandad so od ponoktok, od lukatan en. ");
INSERT INTO oboNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sikiyu no mgo amoy, otid bovuyu kos anak dow to paan, od boggayan dow vo sikandin to batu? ");
INSERT INTO oboNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Woy otid bovuyu sikandin to ngaap, od boggayan dow vo sikandin to uwod? Dii en! ");
INSERT INTO oboNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na otik sikiyu no mgo mosaasaa, od kotuig nod boggoy to moppiya riyot mgo anak dow, iyon pobbo iddos Amoy row no riyot datas to langit, od boggoy en to mgo moppiya riyot od bovuyu kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","De-en puungi row riyot duma iddos id kopi-i row nod puungan dan koniyu. Oyya su ini en kos kohulugan taddot mgo Suhu ni Moises woy taddot id sulat to mgo propeta.” ");
INSERT INTO oboNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Usok kow riyot moliggot no sobbangan. Su mowwag kos sobbangan nod undiyon to linow't apuy, woy dos daan tadda, moomok nod ikulon, de-en mo-uraa kos od usok dutun. ");
INSERT INTO oboNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Piru iddos sobbangan no iyon od ingumannon iddos umuun waad tomanon, moliggot woy mosuppit, woy simbokkad da kos od pokotuntuu tadda.” ");
INSERT INTO oboNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Bantoy kow, su saddook od kopiyod kow to konna bonnaan mgo propeta nod unduwon to koniyu. Otid ontongngan sikandan, moppiya kos botasan dan. ");
INSERT INTO oboNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Od kokilaa row sikandan ukit to pinuungan dan, iling to kayu nod kokilaa ukit to kandin no bunga. Ponunggeleng, iddos kayun duhiyon, diid bovunga to ubas, woy dos baahon, dii en od bovunga to igera. ");
INSERT INTO oboNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Dos moppiyon kayu, od bovunga to moppiya, piru iddos morat no kayu, od bovunga en mandad to morat. ");
INSERT INTO oboNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Su iddos moppiyon kayu, konna en od bovunga to morat, woy dos morat no kayu, konnod bovunga to moppiya. ");
INSERT INTO oboNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Dos ipat kayu no konnod bovunga to moppiya, od tompoddon woy id lumbag diyot apuy. ");
INSERT INTO oboNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","De-en iling mandad tadda, od kokilaa row iddos konna bonnaan mgo propeta ukit to pinuungan dan.” ");
INSERT INTO oboNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Konna langun taddot od ikahi koddi no, ‘Longaggon, Longaggon,’ od pokolonug diyon to kodharit Monama, ko konna, idda ra en so od puung to id kopi-it Amoy ku no riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na otid inguma ron kos allow to kodhukum, mo-uraa kos od ikahi koddi to, ‘Longaggon, po-usokka koy su ukit to ngaran du, id ponudtuu roy iddos id poposaddoo to Monama konami, woy id poleggua roy dos mgo busow woy id puung koy to mo-uraan mokososoobbu.’ ");
INSERT INTO oboNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Piru od tovakon ku en sikandan to, ‘Waa a mid kilaa koniyu. Poriyu kow koddi, sikiyu langun nod puung to morat!’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Na, iddos ahad ondoy nod pominog to koddin mgo osengan woy'd puung tadda, noko-iling sikandin to minuvu no moraom kos koovottan no id poohinat to baoy riyot batu. ");
INSERT INTO oboNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ahad id dunnas kos monokkaan uran woy id lanog, woy nosuhat to monokkaan kaamag iddon baoy, waa en nopiloy, oyya su iddos po-unsaran tadda, idda en so batu. ");
INSERT INTO oboNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Na, idda mandad so minuvu no id pominog to koddin osengan, piru waa rin puungi, noko-iling sikandin to minuvu no id poohinat to baoy riyot paok. ");
INSERT INTO oboNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","To id dunnas kos monokkaan uran woy id lanog, nosuhat to monokkaan kaamag iddos baoy, nopiloy idda woy nohobbahobba en.” ");
INSERT INTO oboNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Na, to nopongnga osenga ni Disas idda, nosoobbuwan iddos mgo minuvu, ");
INSERT INTO oboNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","su iddos nonaw rin, duwon en kotuusan, konna iling taddot mgo tohodnonaw to Suhu ni Moises. ");
INSERT INTO oboNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Na, to id potupang si Disas pomon diyot lovuntud, mo-uraan minuvu kos id tintinundug kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Duwon sokkad no minuvu no duwon bohok no et-et no id porani ki Disas, woy mid lingko-od diyot isowwan din woy mid ikahi to, “Longaggon, nokosaddoo a nod poko-uli ka ka-ay't molibmit no bohok ku otik id kopi-i ru.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Na, id somaddan ni Disas iddos minuvu woy id ikohiyan din to, “Oyya, id kopi-i ku en. Na od ko-uliyan kad.” Idda ron en, worad iddos et-et din. ");
INSERT INTO oboNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kahin Disas kandin to, “Yo ru vo id ponudtuu ini riyot ahad ondoy, ko konna, undiyon ka to tohodbuwis amoy'd po-ontong to lawa ru. Woy boggoy ka to buwis no id suhu ni Moises amoy'd posivonnaa riyot mgo minuvu no no-uliyan kad.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Na, to id inguma si Disas diyot Capernaum, duwon sokkad no kopitan to mgo sundau to Roma no mid porani amoy'd nganoy kandin. Kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Longaggon, duwon sudsuhuwon ku no diid pokowaong woy lampas no mosakit kos od geddamon din.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kahin Disas kandin to, “Oyya, kuo kid me-en sud bowiyan ku sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Piru mid tavak iddos kopitan to, “Longaggon, motuus ka koddi, de-en konna a ollog nod po-usok kikow riyot baoy ku. Osengow robbo woy od ko-uliyan en iddos sudsuhuwon ku. ");
INSERT INTO oboNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nokosaddoo a ka-ay, oyyos ahad siyak, no-iraom a to kotungud taddot mowwet pa koddi, woy duwon mandad mgo sundau no no-iraom to koddin kotungud. Otid ikahi a riyot sokkad no, ‘Ipanow kad,’ na od ipanow en sikandin. Woy otid ikahi a riyot sokkad no, ‘Undini ka,’ na od undini en sikandin. Woy otid ikohiyan ku iddos koddin uripon no, ‘Puungiyu ini,’ na od puungan din en.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","To norinog idda ni Disas, nosoobbuwan sikandin woy id osengan din iddos mgo minuvu nid tintinundug kandin, kahi rin to, “Bonnaavonnaa nod ikohiyon ku koniyu, no waa poron nokita ku no minuvu no duwon dakkoon kodsalig no iling ka-ay, ahad dini to Israel. ");
INSERT INTO oboNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pomotawi row! Init morin allow, mo-uraa kos od kolonug diyon to kodharit Monama no id pomon diyon tid tollak woy pomon diyon tid saop, woy od unsad sikandan amoy'd ka-an duma ongki Abraham, ki Isaac woy ki Jacob. ");
INSERT INTO oboNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Piru iddos koubbaran ni Israel no sikandan en nanoy kos od kolonug diyon to kodharit Monama, id lumbag diyot mosuksukirom. Na rutun, mopet dobbo kos sinoggawon dan woy'd pogkihot sikandan to ngipon pomon to mosakit nod geddamon dan.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Na mid ikahi si Disas diyot kopitan to, “Uli kad bo, su notuman don iddos id pomokayan du.” Idda ron en, no-uliyan don iddos sudsuhuwon to kopitan. ");
INSERT INTO oboNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na, mid undiyon si Disas to baoy ni Pedro. To kod-inguma rin dutun, nokita rin iddos ba-ay no onuhang ni Pedro no id oilogga su id momonit. ");
INSERT INTO oboNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Id somaddan ni Disas kos bollad din woy idda ron en, no-uliyan sikandin. Na, mid onnow sikandin woy id sondad to koka-an atag ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","To od kosagkup don, id piyod to mgo minuvu riyot ki Disas iddos mo-uraan id losuran to busow woy dos nongovohokan. To kodsuhu rin da en, mid leggua iddos mgo busow woy no-uliyan dos langun no novohokan. ");
INSERT INTO oboNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Notomanan ini, su amoy od kotuman iddos id po-ikahi to Monama ki propeta Isaias no mid ungketen to, “Sikandin en kos id awa to od ponggeddamon to lawa ta, woy sikandin kos id awa to mgo bohok ta.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na, to nokita ni Disas iddos mo-uraan minuvu no id lolivuung diyot kandin, mid ikahi sikandin diyot mgo tinodduwan din to, “Od undiyon ki to dipaat lanow.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Piru to waa pa sikandan noko-ipanow, duwon sokkad no tohodnonaw to mgo Suhu ni Moises no id porani ki Disas woy mid ikahi to, “Tohodnonaw, od duma a kikow ahad ingkon ka od undiyon.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mid tavak si Disas to, “Moppiya pa kos mgo lokivot su duwon od ko-ubpan, woy dos mgo manuk su duwon saag. Piru siyak no Anak to Minuvu, waa en noto-oo nod ko-imooyyan ku.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na, duwon mandad sokkad taddot od pondumoruma kandin no mid ikahi to, “Longaggon, od uli a pa, woy otik nolobbong don iddos amoy ku, od duma a kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Piru kahin Disas kandin to, “Podtohonowd iddos minatoy no od lobbong taddot mgo minuvu no waa umuun waad tomanon. Piru sikkow, duma ka koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Na, id sakoy si Disas to bollangay woy mid duma kandin iddos mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tigkow id doppot kos monokkaan kaamag, woy id lapow ron kos mgo baud diyot bollangay, de-en asow ran don od koonnod. Piru si Disas, nokotintinuhon. ");
INSERT INTO oboNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na, id porani iddos mgo tinodduwan din woy id sukaa ran sikandin, kahi ran to, “Longaggon, tovangi koy! Od koonnod kid man moho ini!” ");
INSERT INTO oboNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mid tavak si Disas to, “Mambot od kovaakkan kow? Oray'n disok kos kopomakoy row!” Na, id lohinat sikandin woy id sugga rin iddos kaamag woy mgo baud amoy'd soro, woy idda ron en, id tivonok kos langun. ");
INSERT INTO oboNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Oray'n nosoobbuwan iddos mgo tinodduwan din woy id po-ikohiyoy ran to, “Ondoy moho inin minuvu no ahad iddos kaamag woy mgo baud, id dumoruma kandin?” ");
INSERT INTO oboNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Na, id ponayun onsi Disas taman to id inguma ran diyot dipaa to lanow no riyot lugaa to mgo toho Gadara. To kodponog din, mid sinuggung kandin iddos oruwon minuvu no id losuran to mgo busow. Id pomon sikandan diyot langub nod lovongngan woy oraroy ran no movuut, de-en waa od poko-ukit taddon lugaa. ");
INSERT INTO oboNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tigkow sikandan id pomehes, kahi ran to, “Sikkow no Anak to Monama, ondan man kos lavut du konami? Od silutan koy vo nikkow ahad konna pa ini kos ollog no timpu?” ");
INSERT INTO oboNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na konna oray'n moriyu rutun, duwon mo-uraan bavuy nid ponuwaa. ");
INSERT INTO oboNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","De-en id po-eru-eru ki Disas iddos mgo busow, kahi ran to, “Otid po-owan koy nikkow, po-olina koy nod lasud duwot mgo bavuy.” ");
INSERT INTO oboNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Na kahin Disas to, “Diyon kowd!” De-en id ponleggua iddos mgo busow woy id losuran dan iddos mgo bavuy. Idda ron en, id pouharus diyot daama iddos mgo bavuy woy nongo-uug diyot lanow woy nongoonnod. ");
INSERT INTO oboNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","To nokita idda taddot mgo tohodtamong to mgo bavuy, id lungkossu ran po-undiyot bonuwa, woy id ponudtuu ran iddos langun no notomanan taddot oruwon minuvu nid losuran to mgo busow. ");
INSERT INTO oboNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Purisu iddos langun no minuvu nid oubpa taddon bonuwa, id undiyot ki Disas, woy id po-eru-eru ran nod awa sikandin diyot lugaa ran. ");
INSERT INTO oboNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Na, id sakoy onsi Disas to bollangay woy id livod diyot dipaa to lanow amoy od uli riyot kandin no bonuwa. ");
INSERT INTO oboNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","To riyon don sikandin, duwon mgo minuvu nid undiyon to kandin no id sayung to minuvu nid patoy kos lawa no id oilogga riyot ikam. To nokita ni Disas no dakkoo kos kodsalig dan, id ikohiyan din iddos novohokan to, “Suwod, yo kod kaanu, su id posinsyan don kos mgo saa ru.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na rutun, duwon mgo tohodnonaw to Suhu ni Moises, kohingginawa ran to, “Te, id sosumpalit ikon minuvu, su imman moho to sikandin kos Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Piru nosorollan ni Disas kos diyot poomdom dan, woy id ikohiyan din sikandan to, “Mambot ungketen kos poomdom dow? ");
INSERT INTO oboNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ingkon man musing kos moomok nod osengon? Idda vo so od ikahi no, ‘Id posinsyan don kos mgo saa ru,’ o iddos od ikahi no, ‘Lohinat woy ipanow ka’? ");
INSERT INTO oboNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Piru id pokita ku koniyu no siyak no Anak to Minuvu, duwon kotungud ku ka-ay to ampow't ingod nod posinsya to mgo saa.” Na, id osengan din iddos minuvu no id patoy kos lawa, kahi rin to, “Lohinat ka, piyoddow kos ikam du woy uli kad bo.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Idda ron en, id lohinat sikandin woy id uli. ");
INSERT INTO oboNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","To nokita idda to mgo minuvu, nosoobbuwan sikandan woy novaakkan, woy id doong dan kos Monama no id boggoy to kotungud no iling tadda riyon to minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na ponayun mid ipanow si Disas pomon dutun, woy nokita rin iddos tohodsukut to buhis no id ngoranan ki Mateo nid ounsad diyot od boovoyaran to buhis. Kahin Disas to, “Duma ka koddi.” De-en id lohinat si Mateo woy id duma kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nopongnga idda, id ka-an onsi Disas diyot baoy ni Mateo, woy duwon id inguma no mo-uraan tohodsukut to buhis woy duma pon mosaasaa no id lommung nid ka-an duma ki Disas woy taddot mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","To nokita idda to mgo Pariseo, id ikohiyan dan iddos mgo tinodduwan ni Disas to, “Mambo moho to ikos tohodnonaw row, id lommung nid ka-an duwot mgo tohodsukut to buhis woy dumon mosaasaa?” ");
INSERT INTO oboNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","To norinog idda ni Disas, id tavak din sikandan ukit to ponunggelengan, kahi rin to, “Iddos mgo minuvu no waa bohok, konnod ko-ilangan to doktor, ko konna, idda ra en so duwon bohok. ");
INSERT INTO oboNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ooyyari row tod labbot iddos kohulugan taddot Nosulat no Kahit Monama no mid ungketen to, ‘Waa en koru-anon diyot koddi iddos mgo buwis dow. Iyon ku id kopi-i no od ko-eruwan kow to duma.’ ” Na ponayun mid ikahi si Disas to, “Waa a mid undini amoy'd nangkap taddot mgo motallong, ko konna, idda en so mgo mosaasaa.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na, duwon mgo tinodduwan ni Juan no Tohodboutismu no id porani ki Disas woy mid intud, kahi ran to, “Sikami woy dos mgo Pariseo, od puasa koy. Piru mambot ikos mgo tinodduwan du, dii man od puasa?” ");
INSERT INTO oboNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mid tavak si Disas to, “Otik duwon kosaa, od kaanu vo iddos mgo oukuy no moranit ginawa taddot lammid osawa laggun to duma ran pa sikandin? Dii en! Piru od inguma kos timpu nod puasa ran otid ongayon don pomon diyot kandan iddos id osawa.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Na duwon mandon ponunggelengan ni Disas, kahi rin to, “Waa minuvu nod tapong to lammin ogget diyot tapoy'n umpak. Oyya su otid pippiyan don idda, od kipos dos ogget nid tapong, woy od lowwag pe-en kos bendas. ");
INSERT INTO oboNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Iling mandad tadda, waa minuvu nod ta-aw to lammin binu nod bovuwak poron diyot tapoy'n tootawwan no binovallan pomot kindaa to oyama, oyyos od bottu en moho idda. Na, od korattan da en iddos tootawwan woy od ko-uwakkan dos binu. Purisu ko-ilangan no iddos lammin binu, diyon en mandad id ta-aw to lammin tootawwan amoy waa od ko-uwakkan.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Laggun tid ooseng pa si Disas, duwon id inguma no sokkad no ponguu to simba-an to mgo Judio. Id lingko-od sikandin diyot isowwan ni Disas woy mid ikahi to, “Iddos ba-ay'n anak ku, id patoy gena, piru ahad ungketen, undiyon ka pa woy somaddiyu sikandin amoy'd ko-uyag.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","De-en id lohinat si Disas woy mid duma kandin. Id duma mandad iddos mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na laggun tid ipanow ran, duwon sokkad no ba-ay no noosayan to bohok din, su id longossan sikandin no diid soro daom don to sopuu-oruwon lahun. Id porani sikandin diyot inoyyuhan ni Disas amoy'd somaddan din kos ubpu to umpak ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Su kohingginawa rin no, “Ahad od pokosomad a ra to umpak din, od ko-uliyan ad en.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","To id loingoy si Disas, nokita rin iddos ba-ay woy kahi rin to, “Uri, yo kod kaanu. No-uliyan kad pomon to kopomakoy ru.” Idda ron en, no-uliyan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","To id inguma ron si Disas diyot baoy taddot ponguu, nokita rin iddos id lolaantuy atag to kodlobbong woy dos mo-uraan minuvu no id pondaawit. ");
INSERT INTO oboNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Id ikohiyan din sikandan to, “Leggua kow pa. Waa id patoy inis anak, ko konna, id tinuhon da.” Piru id kosu-atan dan da en sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","To id ponleggua ron iddos mgo minuvu, mid usok si Disas woy id somaddan din iddos bollad taddot anak, woy id onnow sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na, iddos dinoggan moka-atag ka-ay'n notomanan, nokoso-ob diyot intiru taddon ingod. ");
INSERT INTO oboNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na, to id ipanow si Disas pomon dutun, duwon oruwon mama no butud nid tinundug kandin woy id pomehes sikandan no mid ungketen to, “Lubbad ni David, ko-eruwan ka konami.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","To kod-inguma ni Disas diyot baoy nod undiyonnan din, id porani kandin iddos oruwon butud. Na mid intud si Disas kandan, kahi rin to, “Od pomakoy kow vo nod poko-uli a koniyu?” Mid tavak sikandan to, “Oyya, od Longaggon.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Na, id somaddan ni Disas kos mata ran woy kahi rin to, “Od kopuungan en ini rinit koniyu pomon to kopomakoy row.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Idda ron en, nokokita ron sikandan. Kahin Disas kandan to, “Od loglohottan ku sikiyu, no yo row ponudtuu riyot ahad ondoy inis id puungan ku koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Piru id ipanow sikandan, woy id so-ob dan da en tid ponudtuu riyot langun dutun no lugaa iddos moka-atag ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","To mid awa ron iddos oruwa, duwon mandon id inguma riyot ki Disas woy id piyod dan kos minuvun no-ommow su id losuran to busow. ");
INSERT INTO oboNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Na nopongnga id poleggua ni Disas dos busow, od poko-ooseng don iddos minuvu. Oray'n nosoobbuwan kos mgo minuvu, kahi ran to, “Kuu! Waa poron kotomanan no iling ka-ay rini to intirut ingod to Israel!” ");
INSERT INTO oboNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Piru duwon mgo Pariseo no mid ikahi to, “Od pokopoleggua sikandin to mgo busow, oyyos id boggayan man sikandin to kotuusan ni Moivuyan no ponguu ran.” ");
INSERT INTO oboNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na, id lingkus ni Disas iddos langun no bonuwa woy bariyu taddon lugaa. Id nonaw sikandin diyot mgo simba-an to Judio, woy id ponudtuu rin iddos Moppiyon Dinoggan moka-atag to kodharit Monama, woy id bowiyan din kos nokod-osso-osson bohok. ");
INSERT INTO oboNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","To nokita rin iddos mo-uraan minuvu, no-eruwan sikandin su id posupittan sikandan woy notompoddan to puhawang iling to mgo karnero no waa tohodtamong. ");
INSERT INTO oboNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","De-en kahi rin diyot mgo tinodduwan din to, “Iddos mgo minuvu, od poko-iling to ommoy no ollog don nod kottuwon. Oray'n dakkoo kos od kottuwon, piru disok da kos mgo tohodkottu. ");
INSERT INTO oboNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Purisu buyuwa row riyot Monama no komunoy taddot ommayon amoy'd popiyod sikandin to mgo tohodkottu.” ");
INSERT INTO oboNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na id umow ni Disas iddos sopuu-oruwon tinodduwan din, woy id boggayan din sikandan to kotungud to kodpoleggua to mgo busow woy kotungud nod poko-uli to nokod-osso-osson bohok. ");
INSERT INTO oboNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na, ini en kos mgo ngaran taddot sopuu-oruwon apostoles. Si Simon no id ngoranan mandad ki Pedro woy dos suwod din no si Andres, dos toosuwod no si Santiago woy si Juan no mgo anak ni Sebedeo, ");
INSERT INTO oboNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","si Felipe, si Bartolome, si Tomas, si Mateo no tohodsukut to buhis, si Santiago no anak ni Alfeo, si Tadeo, ");
INSERT INTO oboNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon no mohingginawa to ingod din, woy si Judas Iscariote nod boligya ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Id suhu ni Disas iddos sopuu-oruwon apostoles din, woy id pomonduwan din sikandan, kahi rin to, “Yo kow'd undiyon to mgo lugaa to konna mgo Judio woy riyot mgo bonuwa to toho Samaria. ");
INSERT INTO oboNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Iyon dow undiyonni, iddos mgo duma ta no koubbaran ni Israel, su noko-iling sikandan to notarin no mgo karnero. ");
INSERT INTO oboNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Diyot iponawon dow, ponudtuu row no asow ron iddos kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bowi-i row iddos od pongkovohokan, bodnawa row iddos id poomatoy, bowi-i row kos duwon bohok no et-et woy poleggua-a row kos mgo busow. Waa bayad dow ka-ay't kotungud no id boggoy ku koniyu, de-en yo kow mandad od povayad diyon to kodtavang dow. ");
INSERT INTO oboNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yo kow'd piyod to soopi, ahad sinsilyu ra. ");
INSERT INTO oboNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yo kow mandad od piyod to kavii, ilisan no umpak, sandalyas woy tukod. Oyya su iddos minuvu nod puung, ollog nod boggayan to langun no ko-ilonganon din. ");
INSERT INTO oboNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Na otid inguma kow riyot sokkad no bonuwa o bariyu, nangkap kow to moppiyon minuvu nod tanggap koniyu. Diyon kow vo tahad oubpa to baoy rin taman tod awa kowd taddon bonuwa. ");
INSERT INTO oboNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Diyot kod-usok dow to sokkad no baoy, oseng kow to, ‘Muopa nod pokotanggap kow to kopiyannoy to Monama.’ ");
INSERT INTO oboNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Otik moppiya kos kodtanggap koniyu taddot id ubpa tadda, na id pokita en to Monama kos kopiyannoy rin kandan. Piru otik dii ran od tanggap koniyu, konna en mandad idda od puungan to Monama riyot kandan. ");
INSERT INTO oboNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Otik duwon ubpan o bonuwa no diid tanggap o diid pominog koniyu, na tanan kow rutun. Diyot kod-awa row, podpara row kos boubbuk to livuta riyot pa-a row, patow no waa id pokosondit dan koniyu. ");
INSERT INTO oboNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Bonnaavonnaa nod ikohiyon ku koniyu, no riyot allow to kodhukum, movoggat pa kos silut taddot id oubpa taddon bonuwa kuntra taddot mgo toho Sodoma woy mgo toho Gomora.” ");
INSERT INTO oboNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Na ponayun mid ikahi si Disas to, “Pomotawi row! Id popiyod ku sikiyu riyot morat no mgo minuvu. Od poko-iling kow to mgo karnero nod isau riyot movuut no mgo tuyyang. De-en ko-ilangan no mopandoy kow, piru ko-ilangan mandad no waa id pokosawoy koniyu. ");
INSERT INTO oboNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bantoy kow, oyyos duwon mgo minuvu nod ammot koniyu. Id boggoy kow nikandan diyot bollad to mgo tohodhukum, woy od ponlompossan kow riyot mgo simba-an to Judio. ");
INSERT INTO oboNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pomon to kopomakoy row koddi, id po-isau kow riyot mgo gubernador woy mgo hari. Na rutun, id pokoponudtuu row kos Moppiyon Dinoggan diyot kandan woy riyon to konna mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Otid intud-inturan kow nikandan, yo kow'd kaaggow ko ondan kos id tavak dow, su idda ra en no uras, od tuntulan kow to ollog nod osengon dow. ");
INSERT INTO oboNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Oyya su iddos osengan dow, konnad koniyu, ko konna, pomon en to Ispiritu to Monamon Amoy ta. ");
INSERT INTO oboNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Na iddon timpu, duwon mgo toosuwod nod unoy od boggoy to suwod dan diyot bollad to dumon minuvu amoy'd imotayan. Ungketen dad en mandad iddos mgo amoy, id boggoy ran kos mgo anak dan amoy'd po-imotayan. Idda mandad so mgo anak, od atu to amoy woy inoy ran woy'd po-imotayan dan. ");
INSERT INTO oboNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Id kolingasa-i kow to langun no minuvu pomon to kopomakoy row koddi. Piru iddos ahad ondoy nod ti-is to kosupittan taman to kotompusan, od kotobbus en. ");
INSERT INTO oboNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Otid posupittan kow riyot sokkad no bonuwa, lukut kow poriyu riyon to osson bonuwa. Bonnaavonnaa nod ikohiyon ku koniyu, no to dii row pa od kopongnga kos id popuungan ku koniyu riyot langun no bonuwa to Israel, siyak no Anak to Minuvu, od livod don. ");
INSERT INTO oboNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Waa tinodduwan no lampas pa taddot kandin no tohodnonaw, woy waa uripon no lampas pa taddot kandin no amu. ");
INSERT INTO oboNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","De-en iddos tinodduwan, od posolamat sikandin ko nokoloppa sikandin taddot tohodnonaw rin. Woy dos uripon, od posolamat sikandin ko nokoloppa sikandin taddot amu rin. Otik siyak no ponguu row, od ngoranan a nikandan no ponguu to mgo busow, iyon kow pobbo no mgo sakup ku, lampas pe-en no morat kos id ngaran dan koniyu. ");
INSERT INTO oboNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“De-en yo kow'd kovaakki kandan, oyyos waa id tombunan no konnod kokita woy waa id ollos no konnod kosorollan. ");
INSERT INTO oboNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Iddos id ponudtuu ku koniyu riyot mosukirom, ko-ilangan no id ponudtuu row riyot ko-owangan. Woy dos id nona-as ku koniyu, ko-ilangan no id pomehes dow amoy'd korinog to mo-uraan minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yo row id kovaakki kos mgo minuvu nod pokopatoy ra to lawa, piru diid pokopatoy to gimukud. Iyon ollog no id kovaakki row, iddos Monama, oyyos sikandin kos duwon kotuusan nod lumbag diyon to linow't apuy, konna ra iddos lawa, ko konna, idda mandad so gimukud. ");
INSERT INTO oboNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Poomdomma row iddos kodtuhanuu to Monama koniyu. Su ahad iddos oruwon maya no od kovolli ra to oray'n disok no kontidad, waa en sokkad kandan nod patoy otik dii id kopi-it Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na iyon kow pobbo, su ahad iddos bowvuut uu row, nosorollan din kos ko-uralloy. ");
INSERT INTO oboNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","De-en yo kow'd kovaakki, oyyos lampas pe-en kos koru-anon dow taddot mo-uraan maya. ");
INSERT INTO oboNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Iddos ahad ondoy nod tanggap koddi riyot isowwan to mgo minuvu, od tonggapon ku mandad sikandin diyot isowwan to Amoy ku riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Piru iddos ahad ondoy nod elle koddi riyot isowwan to mgo minuvu, od elleyan ku mandad sikandin diyot isowwan to Amoy ku riyot datas langit.” ");
INSERT INTO oboNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yo row poomdomma no mid undini a amoy duwon kosunayan ka-ay to ampow't ingod! Su iyon bonnaa, od kova-ad iddos mgo minuvu pomon koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ponunggeleng, iddos mgo anak no mama, od pokodsupak taddot amoy ran. Idda mandad so mgo anak no ba-ay, od pokodsupak taddot inoy ran, woy dos mgo moka-amung no ba-ay, od pokodsupak taddot onuhang dan no ba-ay. ");
INSERT INTO oboNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Iddos od pongkuntra to minuvu, od pomon da en diyot sakup to kandin no pomilya. ");
INSERT INTO oboNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Dos ahad ondoy nod ginawa to amoy woy inoy rin no lampas pa taddot kodginawa rin koddi, konna ollog no tinodduwan ku. Woy dos id ginawa to mgo anak din no lampas pa taddot kodginawa rin koddi, konna mandad ollog no tinodduwan ku. ");
INSERT INTO oboNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iddos ahad ondoy no diid tiyang to kandin no krus, konna ollog no tinodduwan ku. ");
INSERT INTO oboNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Oyya su iddos minuvu nod konuhunan to umuu rin, od koworan da en baling tadda. Piru iddos od dumoruma koddi ahad od undag idda to kopotayan din, duwon umuun waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Na iddos ahad ondoy nod tanggap koniyu, id tanggap a mandad nikandin, woy dos od tanggap koddi, od tanggap mandad taddot id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dos ahad ondoy nod tanggap to propeta pomon to timbang bivig sikandin to Monama, duwon en ganti nod kotanggap din iling taddot od kotanggap to propeta. Woy iddos ahad ondoy nod tanggap to motallong no minuvu pomon to motallong sikandin, duwon en ganti nod kotanggap din iling taddot od kotanggap to motallong no minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Bonnaavonnaa nod ikohiyon ku koniyu, no iddos ahad ondoy nod boggoy to ahad songo-pokawan no mohonnow'n oweg diyot minuvu nid poobbava pomon to kopomakoy rin koddi, duwon en ganti nod kotanggap din pomon diyon to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nopongnga id nonaw ni Disas iddos langun tadda riyot sopuu-oruwon tinodduwan din, id ipanow sikandin woy id undiyon to mgo bonuwa no morani rutun amoy'd nonaw woy od ponudtuu to kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na si Juan no Tohodboutismu, diyon poron sikandin to prisuwan. To norinog din iddos id puungan ni Disas Krays, id po-undiyon din kos mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","To kod-inguma ran dutun, id inturan dan si Disas, kahi ran to, “Sikkow ron be-en iddos id oongatan doy o od angat koy pa to ossa?” ");
INSERT INTO oboNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mid tavak si Disas to, “Livod kow riyot ki Juan woy ponudtuli row sikandin to langun no nokita woy norinog dow. ");
INSERT INTO oboNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Oyya su iddos mgo butud nokokita ron, dos mgo pungku od poko-ipanow ron, dos duwon bohok no et-et no-uliyan don, dos diid dinog od pokorinog don, dos id poomatoy nongovadnow, woy noponudtulan don mandad to Moppiyon Dinoggan iddos mgo worowora. ");
INSERT INTO oboNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ponudtuu row mandad kandin no moppiya kod kotomanan taddot minuvu no waa kodduworuwa koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na, to id ipanow ron iddos mgo minuvu nid suhu ni Juan, mid ikahi si Disas moka-atag ki Juan diyot mo-uraan minuvu, kahi rin to, “To kod-undiyon dow to ki Juan to riyon pa sikandin to noka-awoy-awoy'n lugaa, ondan man kos id imman dow nod kokita? Idda vo so minuvu no od kopalinpalin kos poomdom iling to aggi nod kopiyodpiyod to kaamag? ");
INSERT INTO oboNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ondan man kos id kopi-i row nod kokita rutun? Idda vo so minuvu no id oumpak to mahaa? Konna en, su iddos od oumpak to ungketen, diyon da id oubpa to polasyu. ");
INSERT INTO oboNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ondan kos id kopi-i row nod kokita rutun? Idda vo so propeta? Oyya en, woy od ikohiyan ku sikiyu, no iddos nokita row, lampas pa sikandin to dumon mgo propeta. ");
INSERT INTO oboNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Oyyos sikandin en iddos no-ikahi riyot Nosulat no Kahit Monama no mid ungketen to, ‘Id popiyod ku iddos koddin tohodponudtuu no od unna kikow amoy'd panoy to kod-inguma ru.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na ponayun mid ikahi si Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no waa poron minuvu nid tobbow ka-ay to ampow't ingod no lampas pa ki Juan no Tohodboutismu. Piru iddos minuvu no moobbava to langun no no-iraom to kodharit Monama, lampas pa sikandin ki Juan. ");
INSERT INTO oboNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Pomon poron to timpu to kodtigkanoy ni Juan no Tohodboutismu taman ko-ungkay, id udsuu pe-en iddos kodso-ob to kodharit Monama, woy duwon mandad od pomohos nod kolonug sikandan diyon to kodhari rin. ");
INSERT INTO oboNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Iddos langun no propeta woy dos diyot mgo Suhu ni Moises, id posaddoo en taddot id poponudtuu to Monama kandan moka-atag to kodhari rin, taman to mid inguma si Juan amoy'd tuman taddon ponudtulon. ");
INSERT INTO oboNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Woy otid tonggapon dow iddos id ponudtuu ran, od koovottan dow no ini si Juan, sikandin en si Elias no od livod. ");
INSERT INTO oboNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na sikiyu, su duwon man tolinga row, pa-ayyad kow pominog.” ");
INSERT INTO oboNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Na ponayun mid ikahi si Disas to, “Ondan man kos od koponunggelengan ku to mgo minuvu to inin timpu? Noko-iling sikandan to mgo anak nod ponggaaw riyot plasa. Od po-ikohiyoy ran diyot mgo duma ran to, ");
INSERT INTO oboNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Id totogunggu koy atag koniyu, piru waa kow man id sayow. Id pondaawit koy, piru waa kow man id sinoggow.’ ");
INSERT INTO oboNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Dos mgo minuvu to inin timpu, od poko-iling en mandad taddon mgo anak, oyyos iddot kod-undini ni Juan no Tohodboutismu, no inaayun id puasa woy waa id inom tod pokohubug, od ikohiyon dan moho no id losuran sikandin to busow. ");
INSERT INTO oboNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Woy siyak no Anak to Minuvu, diyot kod-undini ku, nokita ran no mid ka-an woy id inom a. De-en od ikohiyon dan moho no sopeton a woy polohubug, woy oukuy a kun to mgo tohodsukut to buhis woy dumon mosaasaa. Piru ahad ungketen kos id ikahi ran, ukit taddot pinuungan to Monama, od koposivonnalan no moraom kos koovottan din.” ");
INSERT INTO oboNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nopongnga tadda, id sawoy ni Disas iddos id pon-oubpa riyot mgo bonuwa nid puungan din to mo-uraan mokososoobbu, oyyos waa ran id sondit woy'd tanan to mgo saa ran. ");
INSERT INTO oboNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kahi rin to, “Moka-arat-arat kod kotomanan dow no mgo toho Corazin woy sikiyu mandad no toho Betsaida! Su mo-uraa kos id puungan ku no mokososoobbu ruwot koniyu, piru waa kow en id sondit woy'd tanan to mgo saa row. Otik diyon ku pa idda puungi to Tiro woy Sidon, nouhoy ran don nanoy id oumpak to saku woy mid ounsad diyot ibmukon, patow to kodsondit to mgo saa ran. ");
INSERT INTO oboNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","De-en od ikohiyan ku sikiyu, no riyot allow to kodhukum, otik movoggat man kos silut taddot mgo toho Tiro woy Sidon, iyon kow pobbo no toho Corazin woy toho Betsaida. ");
INSERT INTO oboNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Woy sikiyu mandad no toho Capernaum, kunan dow ayu kod inguma kow taman to langit. Piru id subbuk kow ra vos en baling diyon to linow't apuy. Otik diyon ku pa puungi to Sodoma iddos mgo mokososoobbu nid puungan ku riyot koniyu, tadda poron nanoy kos Sodoma taman ko-ungkay. ");
INSERT INTO oboNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","De-en od ikohiyan ku sikiyu, no riyot allow to kodhukum, otik movoggat man kos silut atag taddot mgo toho Sodoma, iyon kow pobbo no toho Capernaum.” ");
INSERT INTO oboNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na iddon timpu, id dasaa si Disas, kahi rin to, “Amoy ku, sikkow en kos Monama no komunoy to langit woy livuta. Od doongon ku sikkow, su iddos kovonnaan no waa ru id posaddoo riyot mgo minuvu nod ikahi no mopandoy woy moraom kos koovottan, diyon du id posaddoo to mgo minuvu no movavow kos koovottan iling to mgo anak. ");
INSERT INTO oboNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oyya en, Amoy ku, od doongon ku sikkow su ini me-en kos kikow'n id kopi-i.” ");
INSERT INTO oboNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nopongnga idda, mid ikahi si Disas diyot mgo minuvu to, “Id sanna koddi to Amoy ku iddos langun. Oyyos waa osson nokokilaa koddi, idda ra en so Amoy ku, su anak a man nikandin. Woy waa mandad osson nokokilaa to Amoy ku, siyak da en woy dos mgo minuvu no id kopi-i ku nod pokokilaa kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Porani kow koddi, sikiyu langun no novoggatan woy novolloy su od po-imaayyon ku sikiyu. ");
INSERT INTO oboNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Dumoruma kow to koddin mgo suhu woy pohinonaw kow koddi amoy duwon ko-imooyyan dow, su mosunay a woy mopoobbava. ");
INSERT INTO oboNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Oyya su iddos koddin mgo suhu, moomok da nod tumanon woy mahan nod puungan.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sokkad no timpu to Allow't Kod-imolloy, nokovaya onsi Disas diyot kamot no duwon pinomuwon trigu. Pomon to id gutasan iddos mgo tinodduwan din, id pomadti ran iddos mgo trigu, woy id kusukusu ran idda woy id sungit. ");
INSERT INTO oboNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","To nokita idda to mgo Pariseo, id ikohiyan dan si Disas to, “Mambot id puungan to mgo tinodduwan du iddos id diiyan diyon to Allow't Kod-imolloy?” ");
INSERT INTO oboNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mid tavak si Disas to, “Waa kow vo nokovasa taddot id puungan ni Harin David woy taddot mgo duma rin iddot id gutasan sikandan? ");
INSERT INTO oboNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Id usok sikandin diyon to baoy't Monama, woy id ka-an din iddos paan no id buwis diyot Monama. Iddon paan, id diiyan nod kannon to ahad ondoy, woy idda ra en so mgo tohodbuwis kos od pokoka-an tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yo row mandad osenga no waa kow nokovasa taddot nosulat diyon to mgo Suhu ni Moises, no iddos mgo tohodbuwis, od puung diyot undae to ipat Allow't Kod-imolloy, ahad id diiyan kos kodpuung taddon allow. Piru waa ran man nokosaa. ");
INSERT INTO oboNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Od ikohiyan ku sikiyu, no duwon dini ko-ungkay no iddos kotungud din, lampas pa taddot templo. ");
INSERT INTO oboNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Duwon id posulat to Monama no mid ungketen to, ‘Waa en koru-anon diyot koddi iddos mgo buwis dow. Iyon ku id kopi-i no eeruwon kow riyot duma.’ Otik noovottan dow nanoy kos kohulugan ka-ay, dii row od hukuman iddos minuvu no waa saa. ");
INSERT INTO oboNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Oyyos siyak no Anak to Minuvu, duwon kotungud ku ko ondan kos od puungan ahad diyon to Allow't Kod-imolloy.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na mid tanan si Disas dutun, woy id undiyon sikandin to simba-an to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Dutun, duwon minuvu no id patoy kos divauy'n bollad. Duwon mandad mgo Pariseo rutun no od nangkap to po-unayan nod ko-uug dan si Disas no nokopuung to saa. De-en id inturan dan sikandin, kahi ran to, “Ondan, noko-ikuu vo riyot mgo Suhu ni Moises iddos kodbawi riyon to Allow't Kod-imolloy?” ");
INSERT INTO oboNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mid tavak si Disas to, “Ponunggeleng, duwon sokkad no karnero row woy no-uug idda riyot moraom no bobbo sasang to Allow't Kod-imolloy. Ondan, dii row vo idda od botunon? ");
INSERT INTO oboNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Otik dakkoo man kos koru-anon taddot karnero, iyon pobbo iddos minuvu. De-en id ikuu en diyot mgo Suhu ni Moises iddos keton kodtavang to duma ahad diyon to Allow't Kod-imolloy.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Na id ikohiyan ni Disas iddos minuvu to, “Kotongngow kos bollad du.” Na id kottong din kos bollad din, woy idda ron en, no-uliyan idda no noko-iling don taddot divauy'n bollad din. ");
INSERT INTO oboNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Idda mandad so mgo Pariseo, id leggua woy id pomuhawang ko momonnu ran od ko-imotayan si Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nosorollan ni Disas iddos puhawang dan, de-en id awa sikandin dutun. Mo-uraa kos minuvu nid tinundug kandin, woy id bowiyan din iddos langun nod kovohokan. ");
INSERT INTO oboNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Piru id ikohiyan din sikandan no konna ran id ponudtuu riyot duma iddos moka-atag kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Pomon ka-ay, notuman iddos id poposaddoo to Monama ukit ki propeta Isaias no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ini en kos sinuhuwan no id aam ku. Id dokollan ku sikandin to ginawa woy oraroy ku nid kahaa-i. Id po-iroomman ku sikandin to koddin Ispiritu, woy id posaddoo rin diyot konna mgo Judio ko momonnu ran od komotallong diyot kod-ontong to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dii sikandin od pokid-apuu o od pomehes, woy dii mandad sikandin od ooseng to monokkaa riyot doraanon. ");
INSERT INTO oboNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Od tovangan din nod mosalig iddos moomet diyot kopomakoy woy dos notompoddan to puhawang. Konna sikandin od soro taman tod kotuman iddos motallong no dontulon to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Woy sikandin kos od immanon to langun no minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Na, duwon minuvun novutud woy no-ommow, su id losuran sikandin to busow, woy id piyod sikandin diyot ki Disas. Id poleggua rin iddos busow, woy noko-ooseng don iddos minuvu woy nokokita ron. ");
INSERT INTO oboNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","De-en nosoobbuwan iddos nongolivuung dutun, kahi ran to, “Sikandin ayu iddos lubbad ni David no id oongatan ta nod hari keta.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Piru to norinog idda to mgo Pariseo, mid ikahi sikandan to, “Te! Od pokopoleggua sikandin to mgo busow su iyon id boggoy kandin to kotuusan, si Belsebul no ponguu to mgo busow.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Na nosorollan ni Disas kos diyot poomdom dan, de-en mid ikahi sikandin to, “Iddos ahad ondoy no hari to sokkad no kohoriyan nod po-unayoy od povunuwoy taddot mgo sakup din, konnod kouhoy, od kohobba en kos kohoriyan din. Woy dos mgo sakup to sokkad no bonuwa o pomilya, otid po-unayoy nod po-imotayoy, od pokodsuwoysuwoy en sikandan. ");
INSERT INTO oboNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","De-en otid unayon ni Moivuyan to kodpa-awa iddos mgo sakup din, iyon kohulugan tadda no id unoy rin kos ko-ugolingun din, woy od kohobba iddos kandin da en no kohoriyan. ");
INSERT INTO oboNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na, od tommanon dow no nokopoleggua a to busow pomon to kotuusan ni Belsebul. Otik bonnaa idda, dos mgo tinodduwan dow, ukit bo mandad to kotuusan ni Belsebul iddos kodpoleggua ran to mgo busow? Ahad sikandan, od pokoposivonnaa en no soyup kos id oseng dow. ");
INSERT INTO oboNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Piru pomon to id poleggua ku man kos mgo busow ukit to kotuusan to Ispiritu to Monama, posivonnaa ini no iddos kodharit Monama, ka-ay ron to koniyu. ");
INSERT INTO oboNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Notalu kud si Moivuyan, oyya su id poleggua kud iddos mgo busow no mgo sakup din. Oyyos waa minuvu nod poko-usok diyot baoy to monokkaan minuvu amoy'd ahaw to korotuwan din, otik konna pa unna od bokuwon iddos monokkaan minuvu, idda pa od ka-ahaw rin idda.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Na mid ikahi mandon si Disas to, “Iddos ahad ondoy no diid poomig koddi, id supak en koddi. Woy dos diid tavang koddi nod limud to mgo minuvu to Monama, od podsuwoy kandan. ");
INSERT INTO oboNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","De-en od ikohiyan ku sikiyu, no od koposinsyan to Monama dos ahad ondan no saa to minuvu, ahad pa iddos kodsumpalit kandin. Piru iddos kodsumpalit to Uhis no Ispiritu, konnad en od koposinsyan. ");
INSERT INTO oboNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dos ahad ondoy nod ooseng to morat moka-atag koddi no Anak to Minuvu, od koposinsyan pa. Piru iddos od sumpalit to Uhis no Ispiritu, konna en od koposinsyan to inin timpu ahad init od inguma pa.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Na ponayun mid nonaw si Disas ukit to ponunggelengan, kahi rin to, “Iddos moppiyon kayu, moppiya mandad kos bunga. Iling mandad tadda, dos morat no kayu, morat mandad kos bunga. Oyyos od kokilaa iddos kayu ukit to bunga tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sikiyu, iling kow to mgo uwod nod laas! Waa moppiya nod ko-oseng dow su morat kos diyot ginawa row. Ko ondan kos diyot ginawa to minuvu, idda en mandad kos od leggua to bivig din. ");
INSERT INTO oboNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dos moppiyon minuvu, od ooseng to moppiya, oyya su moppiya kos diyot ginawa rin. Piru iddos morat no minuvu, od ooseng to morat, oyyos morat me-en kos diyot ginawa rin. ");
INSERT INTO oboNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Od ikohiyan ku sikiyu, no riyot allow to kodhukum, dos ipat sokkad, ko-ilangan nod tavak to langun no waa koru-an no no-oseng dan. ");
INSERT INTO oboNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Su ukit taddot mgo no-oseng dow, idda en kos od gomiton to Monama to kodhukum koniyu kod silutan kow o dii.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Na, duwon mgo Pariseo woy mgo tohodnonaw to Suhu ni Moises no mid ikahi to, “Tohodnonaw, pokitanna koy to mokososoobbu nod posivonnaa no id popiyod ka en to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Piru mid tavak sikandin to, “Sikiyu no mgo minuvu to inin timpu, oraroy kow no morat, woy id inoyyuhan dow kos Monama. Id kopi-i row nod pokokita to mokososoobbu, piru waa id pokita ku koniyu, ko konna, idda ra en so notomanan ni Jonas no propeta. ");
INSERT INTO oboNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Oyyos si Jonas, diyon sikandin to gottok to dakkoon ngaap daom to otollun allow woy bulli. Iling mandad tadda, siyak no Anak to Minuvu, diyon a to lovongngan ku daom to otollun allow woy bulli. ");
INSERT INTO oboNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Diyot allow to kodhukum, od lohinat iddos mgo toho Ninive woy od oseng no iddos mgo minuvu to inin timpu, ollog en nod silutan. Oyya su dangan to norinog dan iddos kodponudtuu ni Jonas, id sondit sikandan woy id tanan to mgo saa ran. Piru ko-ungkay, dini ron kos lampas pa ki Jonas, piru waa kow man id sondit woy id tanan to mgo saa row. ");
INSERT INTO oboNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na, ungketen dad en mandad iddos Rayna to Siba. Diyot allow to kodhukum, od lohinat sikandin woy od ooseng no iddos mgo minuvu to inin timpu, ollog en nod silutan. Su ahad oray'n moriyu iddos id ubpan din, piru mid undiyon sikandin to ki Harin Solomon amoy'd pominog da en taddot osengan to hari no moraom kos koovottan. Piru ko-ungkay, dini ron kos lampas pa ki Solomon no moraom kos koovottan, piru waa kow man id pominog to nonaw rin.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Na ponayun mid nonaw si Disas ukit to ponunggelengan, kahi rin to, “Otid leggua kos busow riyot minuvu, od lo-uklo-uk idda riyot noka-awoy-awoy'n lugaa lugaa su od nonangkap tod ko-imooyyan din, piru waad kokita rin. ");
INSERT INTO oboNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","De-en od ikahi sikandin to, ‘Od livod a ron baling diyot id ubpan ku.’ Na riyot kod-inguma rin, nokita rin no waa id ubpa rutun, id lemasan idda woy noto-oo ron. ");
INSERT INTO oboNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Od ipanow sikandin woy'd pongakat to pittun mgo busow no lampas pa kos komorattoy. Od losuran dan iddos minuvu woy od ubpan dan don. Na iddos od kotomanan taddon minuvu, od lampas pe-en no morat taddot unna. Ungketen en mandad kos od kotomanan to morat no mgo minuvu to inin timpu.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Laggun to id ooseng pa si Disas diyot mgo minuvu, mid inguma iddos inoy woy mgo suwod din. Id aangat sikandan diyot lama woy id po-umow ran sikandin, su duwon od osengon dan. ");
INSERT INTO oboNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","De-en duwon mid ikahi kandin to, “Sir, iddos inoy ru woy mgo suwod du, id aangat diyot leggua su duwon kun od osengon dan kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mid tavak si Disas to, “Oyya, piru id pokita ku koniyu ko ondoy kos inoy ku woy mgo suwod ku.” ");
INSERT INTO oboNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na, id toddu rin iddos mgo tinodduwan din woy kahi rin to, “Sikandan en kos inoy ku woy mgo suwod ku. ");
INSERT INTO oboNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Su iddos ahad ondoy nod tuman to id kopi-it Amoy ku no riyot datas to langit, sikandan en kos inoy ku, mgo tobboy woy mgo suwod ku.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na iddon allow, id leggua si Disas to baoy woy id undiyon to ibpit to lanow, woy mid unsad sikandin dutun. ");
INSERT INTO oboNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pomon to oray'n mo-uraa kos minuvu no id lolivuung diyot kandin, id penek sikandin diyot bollangay woy mid unsad amoy'd nonaw. Dos mgo minuvu nid loohinat diyot ibpit to lanow, id pominog kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na, mo-uraa kos id nonaw rin kandan ukit to ponunggelengan, kahi rin to, “Duwon sokkad no minuvu no id undiyon to kamot amoy'd savud to bonni. ");
INSERT INTO oboNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Na riyot kodsavud din, duwon mgo bonni no nongo-uug diyot daan, woy id ponuktuk idda to mgo manuk nod layanglayang. ");
INSERT INTO oboNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dos duma, nongo-uug diyot botuwon. Na pomon to movavow ra kos livuta, go-os da idda id lottob. ");
INSERT INTO oboNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Piru to moko-untud don kos allow, naanos idda, woy pomon to waa goli nokodoralig, nahangu ron. ");
INSERT INTO oboNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dos duma, nongo-uug diyot mgo sopiniton. To id tuvu iddos sopinit, id poomatoy dos lammid tuvu su nokubmutan to mgo sopinit. ");
INSERT INTO oboNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Piru iddos duma, nongo-uug diyot moppiyon livuta. Na, moppiya kos tuvu tadda woy id bovunga. Dos duma, ollog-ollog da kos bunga, dos duma mandad, dakkoo woy dos duma pa, oray'n dakkoo.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na kahin Disas to, “Sikiyu, su duwon man tolinga row, pa-ayyad kow pominog.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na, id porani ki Disas iddos mgo tinodduwan woy mid intud, kahi ran to, “Mambot id po-ukit du to ponunggelengan otid nonaw ka to mgo minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mid tavak sikandin to, “Sikiyu, id boggayan kowd to Monama to koovottan taddot waa rin id posaddoo dangan moka-atag to kodhari rin. Piru riyot dumon minuvu, waa rin ini id posaddoo. ");
INSERT INTO oboNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Su iddos minuvu nod pomakoy taddot norinog din koddi, od duhangan pe-en kos koovottan din. Piru iddos minuvu no diid pomakoy, od ongayon pe-en diyot kandin, ahad iddos disok no koovottan din. ");
INSERT INTO oboNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ini en kos unayan no id nonaw a kandan ukit to mgo ponunggelengan, su amoy ahad od totongtong dan, dii ran od pokokita woy ahad od pominog dan, dii ran od pokaabbot. ");
INSERT INTO oboNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na, notuman don diyot kandan iddos id poposaddoo to Monama ukit ki Isaias no mid ungketen to, ‘Ahad pe-en id saud dan kos tolinga ran, dii en sikandan od pokaabbot. Ahad ayas dan pe-en od totongtong, dii en sikandan en od pokokita. ");
INSERT INTO oboNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Su inin mgo minuvu, motoggas kos uu. Id povovongoo ran woy id povovutud. Su otik dii ran idda od puungan, saddook od pokokita ran woy'd pokorinog woy od pokaabbot sikandan. Od livod sikandan diyot koddi, woy od posinsyan ku kos mgo saa ran.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Na ponayun mid ikahi si Disas to, “Piru sikiyu, moppiya kod kotomanan dow, su od pokokita woy'd pokorinog kow. ");
INSERT INTO oboNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Bonnaavonnaa nod ikohiyon ku koniyu, no mo-uraa iddos mgo propeta woy motallong no mgo minuvu no od kopiyan nod pokokita taddot nokita row, piru waa ran en idda nokita. Id kopi-i ran nod pokorinog taddot norinog dow, piru waa ran en idda norinog.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Na, pa-ayyad kow pominog amoy'd pokaabbot kow to kohulugan taddot ponunggelengan moka-atag to minuvu no id savud to bonni. ");
INSERT INTO oboNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Dos daan no no-uuhan to bonni, idda en so mgo minuvu no nokorinog moka-atag to kodharit Monama, piru waa ran nokaabbot. De-en id undiyon si Moivuyan woy id sukabmit din iddos kahit Monama no nokopomuwa riyot pusung dan. ");
INSERT INTO oboNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na iddos botuwon no no-uuhan to bonni, idda en so nokorinog to kahit Monama woy idda ron en, nahaa ran to kodtanggap tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Piru waa goli idda nokodoralig diyot pusung dan, woy sinsinahaw ra kos kopomakoy ran. Oyya su otid inguma kos kosupittan pomon to kodtanggap dan to kahit Monama, konnad sikandan od ponayun. ");
INSERT INTO oboNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Dos sopiniton no no-uuhan to bonni, idda en so nokorinog to kahit Monama, piru inaayun dan od popoomdom to mgo sowkuu to ko-ubpa ran woy dos kodginawa ran to soopi. De-en iling to id kubmutan iddos kahi no norinog dan woy waa nokovunga. ");
INSERT INTO oboNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na, iddos moppiyon livuta no no-uuhan to bonni, idda en so mgo minuvu no nokorinog to kahit Monama woy noovottan dan idda, woy moppiya kos bunga tadda riyot ko-ubpa ran. Dos duma, ollog-ollog da kos bunga to kopomakoy ran, dos duma mandad, dakkoo woy dos duma pa, oray'n dakkoo.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Na ponayun mid nonaw si Disas ukit to ponunggelengan, kahi rin to, “Dos kodharit Monama, iling ka-ay. Duwon minuvu no id savud to moppiyon bonni riyot kamot din. ");
INSERT INTO oboNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sokkad no bulli to nokotinuhon don sikandin woy dos mgo tohodpuung din, id undiyon iddos kuntra rin woy id sovuran din idda to bonnit sabbot woy id ipanow sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","To id tuvu ron iddos mgo moppiyon bonni woy id bovunga ron, idda rin pa nokilaa no duwon bos mgo sabbot no nokosambut tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na, mid undiyon to komunoy taddot kamot iddos mgo tohodpuung woy kahi ran to, ‘Sir, moppiyon bonni iddos id savud du riyot kamot du. Ingkon man pomon dos mgo sabbot?’ ");
INSERT INTO oboNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Mid tavak iddos komunoy to, ‘Iddos id puung ka-ay, dos kuntra ku.’ “Kahi taddot mgo tohodpuung to, ‘Od kopiyan ka vo nod pomoruton doy iddos mgo sabbot?’ ");
INSERT INTO oboNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Mid tavak iddos komunoy to, ‘Yo row pa, su otid pomoruton dow iddos mgo sabbot, saddook od ka-apii iddos pinomuwa. ");
INSERT INTO oboNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Podtohona row ron nod tuvu iddos sabbot duma taddot pinomuwa taman to tingkottu. Oyyos diyon kangkan to tingkottu, od suhuwon ku iddos mgo tohodkottu nod unnan dan tod pomarut iddos mgo sabbot, woy od bogkosson idda amoy'd loowon. Kopongnga, id polimud ku kandan iddos nokottu ran diyon to budiga.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na, id itulan dan ni Disas to sokkad mandon no ponunggelengan, kahi rin to, “Iddos kodharit Monama, noko-iling to oray'n disok no bonni no id pomuwa riyot kamot. ");
INSERT INTO oboNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Oray'n disok ini to langun no bonni, piru otid tuvu ron, mowwet pa ini to dumon pinomuwa taman tod kovovallan no kayu. Woy od ponsosaag diyot mgo panga ka-ay iddos mgo manuk nod layanglayang.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Na, duwon mandon ponunggelengan ni Disas. Kahi rin to, “Iddos kodharit Monama, noko-iling to potuvu to paan no id angoy to ba-ay, woy id podsambut din idda to oruwompuu-limmon kilu no horina taman to id tuvu iddos tivuk no horina.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Na, diyot langun no kodnonaw ni Disas to mgo minuvu moka-atag to kodharit Monama, id po-ukit din to mgo ponunggelengan. Waa sikandin id nonaw kandan no konna ukit to mgo ponunggelengan. ");
INSERT INTO oboNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Id puungan din ini, su amoy od kotuman iddos osengan to sokkad no propeta no mid ungketen to, “Id po-ukit ku to mgo ponunggelengan kos kodnonaw ku kandan. Id ponudtuu ku iddos waa pa id posaddoo pomon poron to kodbovaa to ingod.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Na nopongnga idda, id tanan si Disas diyot mgo minuvu woy mid usok sikandin diyot baoy. Id porani kandin iddos mgo tinodduwan din woy mid intud, kahi ran to, “Paabbotlabbot du konami kos kohulugan taddot ponunggelengan moka-atag to mgo sabbot diyot kamot.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mid tavak si Disas to, “Iddos minuvu no mid savud taddot moppiyon bonni, siyak en idda no Anak to Minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na iddos kamot, ini en so ingod. Dos moppiyon bonni, idda en so mgo minuvu no sakup to kodharit Monama. Woy dos mgo sabbot, idda en so mgo minuvu no sakup ni Moivuyan. ");
INSERT INTO oboNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iddos kuntra no id savud taddot mgo unda, idda en si Moivuyan. Dos tingkottu, idda en so kotompusan to ingod, woy dos mgo tohodkottu, idda en so mgo ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Na iling taddot mgo sabbot nod limuron amoy'd loowon, ungketen dad en mandad kos od kotomanan diyot kotompusan to ingod. ");
INSERT INTO oboNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Siyak no Anak to Minuvu, od suhu to mgo ponolihan ku no od limuron pomon diyot koddin kodhari iddos langun nod ookoy to duma nod puung to saa, woy dos langun no id puung to kororattan. ");
INSERT INTO oboNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Woy id lumbag sikandan diyon to linow't apuy. Na rutun, mopet dobbo kos sinoggawon dan woy'd pogkihot sikandan to ngipon pomon to mosakit nod geddamon dan. ");
INSERT INTO oboNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Piru iddos motallong no mgo minuvu to Monama, od se-aa iling to allow riyon to kodharit Monamon Amoy ran. De-en su duwon man tolinga row, pa-ayyad kow pominog.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Na ponayun mid ituu si Disas ukit to ponunggelengan, kahi rin to, “Iddos kodharit Monama, noko-iling to buawan no id lobbong diyot livuta. To nokita idda to sokkad no minuvu, oray sikandin no nahaa. Na id tombunan din mandon idda, woy id boligya rin iddos langun no koruwonnan din amoy'd kovolli rin iddon livuta. ");
INSERT INTO oboNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Na, iling mandad ka-ay kos kodharit Monama. Duwon sokkad no nigusyanti no od nangkap to motoos no mgo perlas. ");
INSERT INTO oboNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","To nokita rin kos sokkad no perlas no dakkoo kos koru-anon, id boligya rin kos langun no koruwonnan din amoy id bolli tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Na, iling mandad ka-ay kos kodharit Monama riyon to mgo minuvu rin. Duwon pukut no id tuntun diyot dahat woy nokod-osso-osson Nokod-osso-osson ngaap kos no-utoo. ");
INSERT INTO oboNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Otid koponnu ron iddos pukut, od goyoron idda to mgo tohodngongaap po-undiyon to ibpit. Na od ounsad sikandan dutun, woy od pod-ossan dan iddos ngaap. Dos moppiyon ngaap, id lasud dan diyot bukag woy dos morat, id lumbag dan. ");
INSERT INTO oboNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ungketen dad en mandad kos od kotomanan diyot kotompusan to ingod. Od undini kos mgo ponolihan woy od ossan dan kos morat no mgo minuvu pomon diyot mgo motallong. ");
INSERT INTO oboNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Woy id lumbag sikandan diyon to linow't apuy. Na rutun, mopet dobbo kos sinoggawon dan woy'd pogkihot sikandan to ngipon pomon to mosakit nod geddamon dan.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Na mid intud si Disas taddot mgo tinodduwan din, kahi rin to, “Nokaabbot kow vo ka-ay't langun no id oseng ku koniyu?” Mid tavak sikandan to, “Oyya, nokaabbot koy.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kahin Disas to, “Purisu iddos ipat tohodnonaw to mgo Suhu ni Moises no dakkoo kos sinorollan moka-atag to kodharit Monama, od poko-iling sikandin to minuvu no dakkoo kos korotuwan no id pokopoleggua rin pomon diyot kandin no budiga. Oyyos konna ra iddos tapoy'n nonaw kos id pokononaw rin, ko konna, idda mandad so lammi.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nopongnga id nonaw ni Disas iddon mgo ponunggelengan, id tanan sikandin dutun, ");
INSERT INTO oboNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","woy id livod diyot bonuwa no id dokollan din. Na, id nonaw sikandin diyot amba-an to mgo Judio, woy nosoobbuwan iddos mgo minuvu nid pominog kandin, kahi ran to, “Eh, ingkon ayu pomon kos moraom no koovottan ka-ay'n minuvu woy kotuusan to kodpuung to mokososoobbu? ");
INSERT INTO oboNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Konna vo anak da man sikandin to panday woy dos inoy rin, si Maria? Konna vo iddos mgo suwod din, onsi Santiago, si Jose, si Simon woy si Judas? ");
INSERT INTO oboNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Woy konna vo iddos mgo tobboy rin, dini mandad id oubpa? Ingkon man pomon kos moraom no koovottan woy kotuusan din?” ");
INSERT INTO oboNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na, nomorat sikandan ki Disas woy waa ran id pomakoy kandin. Kahin Disas kandan to, “Iddos propeta, mowwet kos kod-ontong kandin to langun, piru riyot kandin no ingod woy riyot mgo sakup to pomilya rin, od poddisokkan sikandin to kod-ontong.” ");
INSERT INTO oboNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na pomon to waa ran id pomakoy kandin, waa goli sikandin id puung to mokososoobbu rutun. ");
INSERT INTO oboNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na iddon timpu, si Herodes no gubernador to Galilea, norinog din iddos moka-atag taddot pinuungan ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Woy id ikohiyan din kos mgo sudsuhuwon din to, “Ini si Disas, sikandin en si Juan no Tohodboutismu no novadnow pomon diyot kopotayan. Ini en kos unayan nod pokopuung sikandin to mgo mokososoobbu.” ");
INSERT INTO oboNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Id ikahi idda ni Herodes, su iddot id lihad, id pa-ammot din si Juan, id povaku woy id poprisu. Id puungan din idda pomon to kodsugga ni Juan kandin, su id ahaw rin si Herodias no sawa taddot ari rin no si Felipe. ");
INSERT INTO oboNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Oyya su inaayun od ikohiyan ni Juan si Herodes to, “Supak diyot mgo Suhu ni Moises no od ahawon du kos sawa to suwod du.” ");
INSERT INTO oboNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Pomon tadda, id kopi-i ni Herodes nod po-imotayan din si Juan, piru novaakkan sikandin to mo-uraan minuvu, oyyos id pomakoy ran no propeta en si Juan. ");
INSERT INTO oboNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na riyot kodsampot ni Herodes to allow't kodtobbow rin, id pista sikandin, woy id sayow iddos mongovay no anak ni Herodias ki Felipe riyot isowwan to langun nid inggat din. Oray'n notoosan si Herodes taddot kodsayow to mongovay. ");
INSERT INTO oboNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","De-en id totandu sikandin, kahi rin to, “Od pongulivot a no id boggoy ku en kikow kos ahad ondan nod buyuwon du.” ");
INSERT INTO oboNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na pomon to id sutsutan to inoy rin iddos mongovay, mid ikahi sikandin to, “Boggoy ru koddi no nokota-aw riyot bondihadu iddos uu ni Juan no Tohodboutismu!” ");
INSERT INTO oboNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","To norinog idda ni Herodes, nokodsondit sikandin. Piru pomon to id pongulivot don sikandin woy'd ko-ilow taddot id pon-inggat din, mid suhu sikandin no id boggoy iddos id buyu taddot mongovay. ");
INSERT INTO oboNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","De-en id po-undiyon din to prisuwan iddos sokkad taddot mgo sundau rin amoy'd tompoddan to liyog si Juan. ");
INSERT INTO oboNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na, id piyod din iddos uu ni Juan no nokota-aw ron diyot bondihadu, woy id boggoy rin idda riyot mongovay. Id piyod mandad idda taddot mongovay riyon to inoy rin. ");
INSERT INTO oboNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","To norinog taddot mgo tinodduwan ni Juan iddon notomanan, id undiyon dan to prisuwan, woy id angoy ran iddos lawa ni Juan amoy id lobbong. Nopongnga idda, id undiyon dan to ki Disas amoy id ponudtuu ran kandin iddos moka-atag tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na, to norinog onni Disas iddon notomanan, id tanan dan dutun woy mid sakoy to bollangay po-undiyot noka-awoy-awoy'n lugaa no siksikandan da. Piru to nokosaddoo iddos mo-uraan minuvu no id pomon diyot nokod-osso-osson bonuwa, mid lupug dan kandin nid pongulibpit diyot lanow. ");
INSERT INTO oboNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","To koddunggu onni Disas woy to kodponog din, nokita rin iddos mo-uraan minuvu no nolivuung. No-eruwan sikandin woy id bowiyan din iddos od pongkovohokan. ");
INSERT INTO oboNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","To od komapun don, id porani ki Disas iddos mgo tinodduwan woy mid ikahi to, “Noka-awoy-awoy inin lugaa, woy asow ron od saop kos allow. Iyon ayu moppiya no od po-undiyonnon du to mgo bariyu inis mo-uraan minuvu amoy'd pokovolli ran to koka-an.” ");
INSERT INTO oboNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mid tavak si Disas to, “Konnad ko-ilangan nod undiyon sikandan. Sikiyu kos od poka-an kandan.” ");
INSERT INTO oboNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kahi ran to, “Eh, toonaw ra man limmon molison no paan woy oruwon ngaap inis ka-ay't keta.” ");
INSERT INTO oboNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kahin Disas to, “Piyodda row idda rinit koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na, id osengan din iddos mgo minuvu no od unsad diyot sobbotton. Nopongnga idda, id angoy rin iddos limmon molison no paan woy oruwon ngaap. Mid langngag sikandin diyot datas to langit woy id posolamat diyon to Monama. Nopongnga, id pontoppiktoppik din idda woy id boggoy rin diyot mgo tinodduwan din amoy id sondad diyot mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na, nokoka-an dan langun woy nongovuung. Nopongnga, id temmos dan iddos nongosama woy nokoponnu pa en idda to sopuu-oruwon bukag. ");
INSERT INTO oboNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dos mgo minuvu nid ka-an, mgo limmon maan (5,000) no mama, waa pa apii to kod-iyap iddos mgo ba-ay woy mgo anak. ");
INSERT INTO oboNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nopongnga idda, id posakoy ni Disas iddos mgo tinodduwan din diyot bollangay, woy id po-unna rin sikandan diyot dipaa to lanow laggun tid popo-uli rin pa iddos mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","To id ipanow ron iddos mgo minuvu, mid tikoddog sikandin po-undiyot buvungan amoy'd dasaa. To od kosagkup don, diyon poron si Disas no siksikandin da. ");
INSERT INTO oboNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na idda mandad so mgo tinodduwan din no id pomollangay, diyon don sikandan to moriyu pomon diyot ibpit to lanow. Nosinuggung dan kos kaamag, de-en nosuhat to doorakkoon mgo baud iddos bollangay. ");
INSERT INTO oboNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","To od ka-allow-allow ron, id undiyonnan sikandan ni Disas no id ipanow riyon to ampow't oweg. ");
INSERT INTO oboNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","To nokita sikandin taddot mgo tinodduwan, oraroy ran no novaakkan woy id pomehes dan to mattag allak, kahi ran to, “Eh, busow!” ");
INSERT INTO oboNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Piru idda ron en, mid ikahi si Disas kandan to, “Yo kow'd kovaakki, su siyak ini!” ");
INSERT INTO oboNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Na kahin Pedro kandin to, “Longaggon, otik mooggot en no sikkow ika, po-unduwonna a to kikow nod ipanow ka-ay to ampow't oweg.” ");
INSERT INTO oboNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Mid ikahi si Disas to, “Na undini ka.” De-en id ponog si Pedro taddot bollangay, woy id ipanow sikandin diyon to ampow't oweg po-undiyot ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Piru to noheddam din iddos monokkaan kaamag woy to nokita rin iddos doorakkoon baud, novaakkan sikandin woy enot-enot don od koonnod. Na, id pomehes sikandin no mid ungketen to, “Longaggon, tovangi a!” ");
INSERT INTO oboNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Idda ron en, id so-ut sikandin tid apput ni Disas woy id somaddan. Kahi rin to, “Oray mohon disok kos kopomakoy ru! Mambot id duworuwa ka?” ");
INSERT INTO oboNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na mid sakoy sikandan diyot bollangay, woy idda ron en, id soro iddos kaamag. ");
INSERT INTO oboNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dos id sakoy taddot bollangay, mid simba kandin woy kahi ran to, “Mooggot ka en no Anak to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na, to nokorunggu ran diyot dipaa to lanow, noko-inguma ran diyot lugaa to Genesaret. ");
INSERT INTO oboNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","To nokilaa si Disas to mgo minuvu taddon lugaa, id posaddoo ran diyot langun no lugaa no nokolingkus dutun no riyon sikandin. De-en id piyod to mgo minuvu riyot kandin iddos langun nod kovohokan. ");
INSERT INTO oboNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Id po-eru-eru ran ki Disas no od posomaddon iddos od pongkovohokan, ahad ubpu robbo taddot umpak din. Na iddos langun no nokosomad kandin, no-uliyan en. ");
INSERT INTO oboNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na, duwon mgo Pariseo woy mgo tohodnonaw to Suhu ni Moises no id pomon diyot Jerusalem. Id porani ran ki Disas woy mid intud, kahi ran to, ");
INSERT INTO oboNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mambot id supak moho to mgo tinodduwan du iddos botasanon to kovuyyahan ta amoy'd molinis diyot kod-ontong to Monama? Oyyos id ka-an dan no waa id ounab to bollad amoy'd ikuu to botasanon atag to kodlinis.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mid tavak si Disas to, “Na sikiyu, mambot id supak dow kos mgo suhu to Monama ukit to kod-ikuu row to koniyun botasanon? ");
INSERT INTO oboNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Su id suhu to Monama no, ‘Rispitu kow to amoy woy inoy row,’ woy ‘Iddos ahad ondoy nod oseng to morat diyot amoy o inoy rin, ko-ilangan en nod imotayan.’ ");
INSERT INTO oboNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Piru sikiyu, ossa moho kos nonaw row. Su iddos minuvu no duwon nanoy id pokotavang diyot amoy woy inoy rin, od bolivad baling sikandin woy'd oseng to, ‘Duwon nanoy tavang ku koniyu, piru id ossa kud ini atag to Monama.’ ");
INSERT INTO oboNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","De-en id podwora row iddos suhu to Monama ukit to kod-ikuu row taddot koniyun botasanon. ");
INSERT INTO oboNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sikiyu nod po-uvag-uvag no motallong! Bonnaa en iddos id poposaddoo to Monama ukit ki Isaias moka-atag koniyu no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Inin mgo minuvu, taman da to dila kos kodposivantug dan koddi, piru moriyu kos pusung dan koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Waa koru-anon to kodsimba ran koddi, su iddos id nonaw ran, id bobbovallan da to mgo minuvu.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Na, id poporani ni Disas iddos mo-uraan minuvu woy id ikohiyan din to, “Pominog kow woy ooyyari row ini tod labbotlabbot. ");
INSERT INTO oboNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Konnod pokolibmit iddos koka-an no id sungit to minuvu riyot bivig din. Iyon od pokolibmit kandin, idda en so morat no osengan nod leggua to bivig din.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na, id porani ki Disas iddos mgo tinodduwan din woy mid ikahi to, “Nokosaddoo ka vo no nomorat kos mgo Pariseo taddot id oseng du?” ");
INSERT INTO oboNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mid tavak si Disas to, “Iddos ipat pinomuwa no waa id pomuwa taddot Amoy ku no riyot datas to langit, od boruton. ");
INSERT INTO oboNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Podtohona row sikandan, su noko-iling dan to mgo butud nod inahak to iling dan no butud. Otik butud kos od inahak to iling din no butud, od pokodtapik en sikandan nod ko-uug diyot moraom no bobbo.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Na mid ikahi si Pedro to, “Paabbotlabbot du konami iddos kohulugan taddot ponunggelengan.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kahin Disas to, “Nosoobbuwan a koniyu, su iling kow vos mandad to dumon minuvu no waa poron nokaabbot. ");
INSERT INTO oboNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Waa kow vos nokosaddoo no iddos ahad ondan no koka-an nod usok diyot bivig to minuvu, od undiyon to gottok woy od leggua? ");
INSERT INTO oboNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Piru iddos od leggua to bivig, id pomon idda riyot ginawa, woy idda en kos od pokolibmit to minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Oyyos id pomon diyot ginawa iddos morat no poomdom, no idda en kos od piyod kandin nod puung to kod-imatoy, kodloivug woy dumon molibmit no pinuungan, kodponakow, kodposivonnaa to uhus woy koddoddora-at to duma. ");
INSERT INTO oboNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Na ini en langun kos od pokolibmit to minuvu. Piru iddos kodka-an no waa mid ikuu to botasanon moka-atag to kod-ounab to bollad, konna idda kos od pokolibmit to minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Na, id tanan si Disas dutun woy mid undiyon to lugaa no sakup to mgo bonuwa to Tiro woy Sidon. ");
INSERT INTO oboNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na, duwon sokkad no ba-ay no id oubpa rutun. Iddon ba-ay, konna Judio, su toho Canaan sikandin. Id porani sikandin ki Disas woy id po-eru-eru, kahi rin to, “Longaggon, lubbad ni David, ko-eruwan ka koddi! Su iddos anak ku no ba-ay, oray'n noosayan pomon to busow no id lasud kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Piru waa mid tavak si Disas, ahad songo-kahi. De-en id porani kandin iddos mgo tinodduwan din woy mid ikahi to, “Po-owa-aw kos ba-ay, su id tinundug sikandin keta no oray'd poko-ulingoo.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kahin Disas taddot ba-ay to, “Id popiyod a to Monama atag da to koubbaran ni Israel no noko-iling to nongotarin no karnero.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Piru id porani ra en sikandin ki Disas woy mid lingko-od diyot isowwan din. Kahi rin to, “Longaggon, tovangi a!” ");
INSERT INTO oboNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Id tavak si Disas kandin ukit to ponunggelengan, kahi rin to, “Konna en ollog nod ongayon iddos koka-an to mgo anak woy id sunggud diyot mgo tuyyang.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kahi taddot ba-ay to, “Oyya, Longaggon, piru ahad pa iddos mgo tuyyang, od pokoka-an man to mgo mumu nod pongo-uug diyot silob to lomisa taddot amu ran.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mid tavak si Disas to, “Tiya, dakkoo kos kopomakoy ru! Od kotuman en kos od buyuwon du.” Na idda ron en, no-uliyan iddos anak din. ");
INSERT INTO oboNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Na, id awa si Disas dutun woy id pongulibpit diyon to Lanow't Galilea. Id tikoddog sikandin diyot lovuntud woy mid unsad dutun. ");
INSERT INTO oboNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mo-uraa kos minuvu nid undiyon to kandin. Id duma ran iddos mgo pungku, mgo butud, mgo minuvu no id patoy kos pa-a, mgo ommow woy duma pa. Id piyod dan idda riyot isowwan ni Disas woy langun dan, no-uliyan ukit to kotuusan din. ");
INSERT INTO oboNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na, nosoobbuwan iddos mgo minuvu no nokokita tadda, oyyos od poko-ooseng don iddos mgo ommow, no-uliyan iddos mgo pungku, noko-ipanow ron iddos mgo minuvu nid patoy kos pa-a woy nokokita ron iddos mgo butud. De-en id doong dan kos Monama nod simba-anon to mgo toho Israel. ");
INSERT INTO oboNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na, id poporani ni Disas iddos mgo tinodduwan din woy id ikohiyan din to, “No-eruwan a ka-ay't mo-uraan minuvu, oyyos notolluwan don nid duma ran koddi no worad tasak dan. Dii a od kopiyan nod po-uliyon ku sikandan no diid pokoka-an, su saddook od moomet dan to gutas diyot daan.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kahi taddot mgo tinodduwan din to, “Oyya en, piru ingkon ki man od poko-angoy to koka-an no ollog ka-ay't oray'n mo-uraan minuvu no ini ki man to noka-awoy-awoy'n lugaa?” ");
INSERT INTO oboNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mid intud si Disas kandan, kahi rin to, “Pilon molison kos paan duwot koniyu?” Mid tavak sikandan to, “Pittu woy pilopilon moollimot no ngaap.” ");
INSERT INTO oboNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Na, id po-unsad ni Disas iddos mo-uraan minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Woy id angoy rin iddos pittun paan woy dos mgo ngaap woy id posolamat sikandin diyot Monama. Nopongnga, id pontoppiktoppik din idda woy id boggoy riyot mgo tinodduwan din amoy id sondad diyot mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na, nokoka-an dan langun woy nongovuung. Woy nokolimud pe-en iddos mgo tinodduwan din to nongosama no nokoponnu to pittun doorakkoon bukag. ");
INSERT INTO oboNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iddos ko-uralloy to minuvu nid ka-an, mgo oppat no maan (4,000) no mama, waa pa apii to kod-iyap iddos mgo ba-ay woy mgo anak. ");
INSERT INTO oboNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nopongnga idda, id popo-uli ni Disas iddos mgo minuvu, woy mid sakoy sikandin to bollangay po-undiyot Magadan. ");
INSERT INTO oboNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na, duwon mgo Pariseo woy mgo Saduseo no id porani ki Disas. Id kopi-i ran nod posaharon sikandin, de-en id buyu ran kandin no od pokitannon sikandan to mokososoobbu nod posivonnaa no id popiyod en sikandin to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Piru mid tavak si Disas to, “Otid saop don kos allow, od ikahi kow to, ‘Od tollak be-en moho simag, su moollutu kos langit.’ ");
INSERT INTO oboNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Woy otid ka-allow ron, od ikahi kow to, ‘Od uran be-en moho ko-ungkay, su moollutu kos langit woy od mosukirom.’ Od kotuig kow nod otuk to timpu ukit to kod-ontong dow to ko-oowayan, piru dii kow man od kotuig nod otuk to kohulugan to mgo kotomanan to inin timpu. ");
INSERT INTO oboNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sikiyu no mgo minuvu to inin timpu, oraroy kow no morat, oyya su id inoyyuhan dow kos Monama. Id buyu kow to mokososoobbu, piru waa id pokita ku koniyu, idda ra en so mokososoobbun notomanan ni Jonas.” Nopongnga idda, id tanan si Disas kandan woy mid ipanow. ");
INSERT INTO oboNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na, to id dunggu onsi Disas diyot dipaa to lanow, nolingow iddos mgo tinodduwan din nid piyod to tasak dan no paan. ");
INSERT INTO oboNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kahin Disas kandan to, “Bantoy kow taddot potuvu to paan to mgo Pariseo woy mgo Saduseo.” ");
INSERT INTO oboNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Id po-ikohiyoy iddos mgo tinodduwan din to, “Saddook id oseng din idda, su wora ki man.” ");
INSERT INTO oboNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Na nokosaddoo si Disas taddot mgo osengan dan, de-en mid ikahi sikandin to, “Ooy koniyu, oray'n disok kos kopomakoy row! Mambot nosasow kow no waa kow nokopiyod to paan? ");
INSERT INTO oboNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Waa kow pobbos nokaabbot? Nolingow kowd bo taddot limmon molison no paan no id poka-an ku taddot limmon maan (5,000) no minuvu? Woy pilon bukag iddos noponnu row taddot nongosama? ");
INSERT INTO oboNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Woy nolingow kowd bo taddot pittun molison no paan no id poka-an ku taddot oppat no maan (4,000) no minuvu? Woy pilon doorakkoon bukag kos noponnu row taddot nongosama? ");
INSERT INTO oboNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","De-en nosoobbuwan a no waa kow poron nokaabbot no konna moka-atag to paan iddos id ikahi ku. Od uliton ku tod oseng, ‘Bantoy kow taddot potuvu to paan to mgo Pariseo woy mgo Saduseo!’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na, idda pa sikandan nokaabbot no iddos id ponudtuu ni Disas kandan, konna moka-atag to potuvu to paan, ko konna, ko-ilangan nod bantoy ran taddot nonaw to mgo Pariseo woy mgo Saduseo. ");
INSERT INTO oboNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na, to id inguma onsi Disas diyot bonuwa to Cesarea Filipos, id inturan din iddos mgo tinodduwan din, kahi rin to, “Ondak poomdom to mgo minuvu moka-atag koddi? Diyot poomdom dan, siyak no Anak to Minuvu, ondoy a man?” ");
INSERT INTO oboNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mid tavak sikandan to, “Duwon id ikahi no sikkow kun si Juan no Tohodboutismu. Dos duma mid ikahi no sikkow si Elias, woy duwon duma nid ikahi no sikkow si Jeremias o sokkad ka taddot dumon mgo propeta.” ");
INSERT INTO oboNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Na kahin Disas to, “Piru atag koniyu, ondoy a man?” ");
INSERT INTO oboNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Mid tavak si Simon Pedro to, “Sikkow kos Mesiyas no Anak to ma-antoy'n Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kahin Disas kandin to, “Simon no anak ni Jonas, moppiya kod kotomanan du, oyyos konna minuvu kos id posaddoo ka-ay riyot kikow, ko konna, iddos Amoy ku riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na od ikahi a kikow, no sikkow si Pedro, no iddos kohulugan, batu. Woy ka-ay'n batu, od poohinaton ku kos koddin simba-an no idda en so langun nod pompomakoy. Woy konna en od pokotalu kandan iddos kotuusan to kopotayan. ");
INSERT INTO oboNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Id boggoy ku kikow kos kotungud no iling to tusi nod pokes to kodharit Monama. Dos ahad ondan nod diiyan du ka-ay to ampow't ingod, od diiyan mandad diyot datas to langit. Woy dos ahad ondan nod omanan du ka-ay to ampow't ingod, od omanan mandad diyot datas to langit.” ");
INSERT INTO oboNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Na, id loglohottan ni Disas iddos mgo tinodduwan din no dii ran id ponudtuu riyot ahad ondoy no sikandin kos Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Na pomon tadda, id tigkanoy ron si Disas to kodpaabbotlabbot diyot mgo tinodduwan din moka-atag tod kotomanan din. Kahi rin to, “Ko-ilangan nod undiyon a to Jerusalem. Woy rutun, od ukit a to mo-uraan kodposuppit tod pombuyyahon ta, mgo ponguu to tohodbuwis woy mgo tohodnonaw to Suhu ni Moises. Od po-imotayan a nikandan, piru riyot iko-otollun allow, od kovadnow a.” ");
INSERT INTO oboNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Na, id piyod ni Pedro si Disas diyot ibpit woy id sugga rin, kahi rin to, “Longaggon, muopa no diid aman kos Monama ruwot id oseng du! Konna en idda od kotuman duwot kikow!” ");
INSERT INTO oboNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Piru id isau si Disas ki Pedro woy mid ikahi to, “Awa ka, Moivuyan! Od boovahan a nikkow, su iddos poomdom du, konna pomon to Monama, ko konna, pomon to minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Na mid ikahi si Disas diyot mgo tinodduwan din to, “Iddos ahad ondoy no od kopiyan nod kovovallan no tinodduwan ku, ko-ilangan nod inoyyuhan din kos kandin nid kopi-i woy od tiyangon din iddos kandin no krus amoy'd dumoruma koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Su iddos minuvu nod konuhunan to umuu rin, od koworan da en baling tadda. Piru iddos ahad ondoy nod patoy pomon to koddumoruma rin koddi, duwon umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Oyyos ahad od kokomunoy to minuvu kos langun no korotuwan ka-ay to ampow't ingod, waa en koru-anon otid koworan sikandin to umuun waad tomanon, su iddos od ingumannon din, idda en so linow't apuy. Oyyos waa korotuwan no id pokovullas to minuvu amoy'd ka-awi rin iddos umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Su siyak no Anak to Minuvu, od livod duma to mgo ponolihan ku nod dumannan to se-aa to kotuusan to Amoy ku. Na od boggayan ku to ganti iddos ipat sokkad ukit taddot nopuungan din. ");
INSERT INTO oboNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Bonnaavonnaa nod ikohiyon ku koniyu, no duwon duma ka-ay no dii pa od patoy taman to dii ran pa od kokita iddos kod-undini woy kodhari ku no Anak to Minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na, to id lihad don kos annom no allow, id poruma ni Disas si Pedro, woy dos toosuwod no si Santiago woy si Juan po-undiyon to mowwet no buvungan no siksikandan da. ");
INSERT INTO oboNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Laggun tid totongtong dan ki Disas, tigkow nopalin kos boyo rin. Iddos bonnong din, id se-aa iling to allow woy dos umpak din, id sella-sella pomon to koputiyoy. ");
INSERT INTO oboNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na idda ron en, nokita ran si Moises woy si Elias no id tongko ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kahin Pedro ki Disas to, “Longaggon, moppiya en no ka-ay ki. Otid kopiyan ka, od sosabbung a to otollu, sokkad atag kikow, sokkad atag ki Moises woy sokkad atag ki Elias.” ");
INSERT INTO oboNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Laggun tod ooseng poron sikandin, duwon mose-aa no souhapun no id tambun kandan, woy duwon bawos nid pomon diyot souhapun no mid ungketen to, “Ini en kos Anak ku no id dokollan ku to ginawa, woy oraroy ku sikandin id kahaa-i. Pominogga row sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","To norinog idda taddot mgo tinodduwan din, mid lingko-od sikandan no iddos bonnong dan noko-uma riyot livuta pomon to dakkoon allak dan. ");
INSERT INTO oboNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Na mid porani si Disas woy id somad kandan, kahi rin to, “Lohinat kow. Yo kow'd kovaakki.” ");
INSERT INTO oboNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","To id laangngag sikandan, worad dumon nokita ran, si Disas dobbo. ");
INSERT INTO oboNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Laggun tod potupang sikandan, id loglohottan dan ni Disas, kahi rin to, “Yo row en id ponudtuu riyot ahad ondoy iddos nokita row taman to siyak no Anak to Minuvu, od kovadnow ron.” ");
INSERT INTO oboNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na id inturan dan si Disas, kahi ran to, “Mambot od ikohiyon to mgo tohodnonaw to Suhu ni Moises no ko-ilangan no unna pa od undini si Elias, idda pa iddos Mesiyas?” ");
INSERT INTO oboNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mid tavak si Disas to, “Bonnaa en no unna pa od undini si Elias amoy'd panoy to langun. ");
INSERT INTO oboNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Piru od ikohiyan ku sikiyu, no id inguma ron si Elias, piru waa sikandin kilaanna to mgo minuvu. Woy id puungan dan pe-en diyot kandin iddos ahad ondan no morat nid kopi-i ran. Ungketen dad en mandad koddi no Anak to Minuvu, od posupittan a nikandan.” ");
INSERT INTO oboNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na, idda pa nokaabbot iddos mgo tinodduwan no iddos od tommanon din, si Juan no Tohodboutismu. ");
INSERT INTO oboNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na, to id inguma ron onsi Disas diyot mo-uraan minuvu nid porani kandin woy mid lingko-od diyot isowwan din. ");
INSERT INTO oboNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Kahi rin to, “Longaggon, ko-eruwan ka ka-ay't anak ku. Duwon bohok din nod bovuyun woy noompasan oraroy kos kod-oilasoy rin, su inaayun sikandin od kopiloy riyot apuy woy oweg. ");
INSERT INTO oboNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Id piyod kud sikandin diyot mgo tinodduwan du, piru waa ran man noko-uli kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kahin Disas to, “Sikiyu no mgo minuvu to inin timpu, waa kopomakoy row woy mgo ebbaw kow! Momonnu kouhayyoy kos koddumoruma ku koniyu, woy kannu pa ayu od kotaman inis kodti-is ku koniyu? Piyoddow kos anak du ka-ay't koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","To riyon don to morani ni Disas iddos anak, id suhu rin nod leggua kos busow woy idda ron en, no-uliyan iddos anak. ");
INSERT INTO oboNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na, id porani ki Disas iddos mgo tinodduwan din no siksikandan da woy mid intud, kahi ran to, “Mambot waa koy nokopoleggua taddot busow?” ");
INSERT INTO oboNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mid tavak si Disas to, “Oyyos kulang kos kopomakoy row. Bonnaavonnaa nod ikohiyon ku koniyu, no ahad iling da korisokkoy to bonnit mustasa kos kopomakoy row, od kopuungan dow en kos langun. Od pokosuhu kow ruwot buvungan nod alin, woy od alin en idda. ");
INSERT INTO oboNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Piru iddos iling taddon busow, dii kow en od pokopoleggua otik dii kow od ponayun nod dasaa woy'd puasa.” ");
INSERT INTO oboNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sokkad no allow, si Disas duma to mgo tinodduwan din, id lolivuung diyot Galilea, woy id ikohiyan din sikandan to, “Siyak no Anak to Minuvu, id boggoy a riyot bollad taddot od pongkuntra koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Od imotayan a nikandan, piru od kovadnow a riyot iko-otollun allow.” To norinog idda to mgo tinodduwan din, oraroy ran no naaggow. ");
INSERT INTO oboNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","To id inguma ran diyot Capernaum, id poroniyan si Pedro to mgo tohodsukut to buhis woy mid intud kandin, kahi ran to, “Iddos tohodnonaw row, id bayad bo sikandin to buhis atag to templo?” ");
INSERT INTO oboNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Mid tavak si Pedro to, “Oyya.” Na, to id usok si Pedro riyot baoy, id unna mid ooseng si Disas, kahi rin to, “Diyot kikow, Simon, ondoy ayu kos od sukutan to buhis to mgo hari ka-ay to ampow't ingod? Idda vo so mgo anak dan o iddos dumon minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kahin Pedro to, “Idda en so dumon minuvu.” Mid ikahi si Disas to, “Na, ko ungketen, iling mandad to mgo anak to Monama, konna ko-ilangan nod bayad atag to baoy rin. ");
INSERT INTO oboNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Piru amoy konna ran od komorat keta, undiyon ka to lanow woy pomunuwit ka. Woy riyot bivig to unnon ngaap nod ko-utoo ru, od kokita ru kos soopi. Na, piyoddow vo idda woy bayad du to buhis atag keta oruwa.” ");
INSERT INTO oboNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na iddon timpu, id porani ki Disas iddos mgo tinodduwan din woy mid intud, kahi ran to, “Ondoy man kos mowwet to langun diyon to kodharit Monama?” ");
INSERT INTO oboNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","De-en id poporani ni Disas iddos sokkad no anak woy id poohinat din diyot tongannan dan. ");
INSERT INTO oboNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kahin rin to, “Bonnaavonnaa nod ikohiyon ku koniyu, no konna kow od kolonug diyon to kodharit Monama otik dii row od lommiyon kos poomdom dow woy otik dii kow od poobbava iling to anak. ");
INSERT INTO oboNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Su iddos ahad ondoy nod poobbava to ko-ugolingun din iling ka-ay't anak, sikandin kos mowwet to langun diyon to kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Woy dos ahad ondoy nod tanggap to mopoobbavon minuvu iling ka-ay't anak pomon to kopomakoy rin koddi, siyak kos id tanggap din.” ");
INSERT INTO oboNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Na, iddos ahad ondoy nod poko-okoy nod puung to saa kos mopoobbavon minuvu iling ka-ay't disok no anak no od pomakoy koddi, moppiya pa nod ikottan kos liyog din to oray'n dakkoon gilingan no batu woy id lumbag diyot kinoroomman to dahat. ");
INSERT INTO oboNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Moka-arat-arat kod kotomanan taddot mgo minuvu no unayan nod ko-okoy kos duma riyot kodpuung to saa. Od inguma en kos mgo kodgeddam, piru moka-arat-arat iddos silut taddot minuvu no noko-iling to daan tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“De-en otik ikos bollad o pa-a ru kos unayan nod pokopuung ka to saa, tompoddowd baling ika woy lumbag du. Su moppiya pa nod pokotanggap ka to umuun waad tomanon no sokkad da kos bollad o pa-a, kuntra to duwon oruwon bollad o pa-a ru no id lumbag ka riyon to linow't apuy no konna od ko-ovukkan. ");
INSERT INTO oboNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Woy otik ikos mata ru kos unayan nod pokosaa ka, kootowd baling ika woy lumbag du. Oyyos moppiya pa nod pokotanggap ka to umuun waad tomanon no sokkad da kos mata, kuntra to duwon oruwon mata ru no id lumbag ka riyon to linow't apuy.” ");
INSERT INTO oboNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ayyad-ayyad kow no konna kow od lommot to ahad sokkad nod poobbava iling ka-ay't moollimot poron no mgo anak. Oyyos od ikohiyan ku sikiyu, no iddos mgo ponolihan no id tavang kandan, inaayun duma to Amoy ku no riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Su siyak no Anak to Minuvu, mid undini to ingod amoy'd nangkap to mgo minuvu no moriyu to Monama woy od tobbus kandan. ");
INSERT INTO oboNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Diyot koniyu, ondan ayu kos od puungan to minuvu otik duwon mahatus no karnero, woy od kotorinan idda to sokkad? Id tuwos din en iddos siyowmpuu-siyow riyot posobsavan amoy od nongkapon din iddos sokkad no notarin. ");
INSERT INTO oboNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","To nokita rin don idda, bonnaavonnaa nod ikohiyon ku koniyu, no lampas pa kos kahaan din taddot sokkad no karnero kuntra taddot siyowmpuu-siyow no waa notarin. ");
INSERT INTO oboNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na, ungketen dad en mandad kos Amoy row no riyot datas to langit. Konna sikandin od kopiyan nod kotarin kos ahad sokkad da to mgo sakup din iling ka-ay't moollimot poron no mgo anak.” ");
INSERT INTO oboNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Otik duwon suwod du riyot kopomakoy no nokosaa kikow, undiyonniyu sikandin woy ponudtuu ru iddos saa rin kikow no siksikoniyu ra. Otid pominog sikandin woy od tonggapon din kos osengan du, na nokod-uli ron kos songnga rin kikow. ");
INSERT INTO oboNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piru otik dii en sikandin od pominog, piyod ka to sokkad o oruwon minuvu amoy duwon od posivonnaa koniyu. ");
INSERT INTO oboNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na, otik dii pe-en sikandin od pominog kandan, posaddoo ru idda riyon tod lolivuung nod pompomakoy. Woy otik dii en sikandin od pominog taddot id pomandu tod pompomakoy, po-iling dud sikandin to sokkad no minuvu no waa Monama o oray'd loimbung no tohodsukut to buhis.” ");
INSERT INTO oboNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Od ikohiyan ku sikiyu, no iddos ahad ondan nod diiyan dow ka-ay to ampow't ingod, od diiyan mandad idda riyot datas to langit. Woy dos ahad ondan nod omanan dow ka-ay to ampow't ingod, od omanan mandad idda riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Od ikohiyan ku mandad sikiyu, no otik duwon oruwa no nokodsokkad to ahad ondan nod buyuwon dan diyot Monama, id boggoy en idda to Amoy ku no riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Su ahad oruwa o otollu kos od lolivuung pomon to kopomakoy ran koddi, diyon a mandad duma kandan.” ");
INSERT INTO oboNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Na, id undiyon si Pedro to ki Disas woy mid intud, kahi rin to, “Longaggon, kopila ku od posinsyan kos suwod ku no nokopuung to saa koddi? Ko-pittu vo?” ");
INSERT INTO oboNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mid tavak si Disas to, “Konna ra kopittu, ko konna, kopittumpuu pittu. ");
INSERT INTO oboNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Su iddos kodharit Monama, od poko-iling ka-ay'n ponunggelengan. Duwon hari nod sosukut to utang diyot mgo sudsuhuwon din. ");
INSERT INTO oboNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","To id tigkanoy pa sikandin id sosukut, duwon sokkad no sudsuhuwon no id piyod diyot kandin no noko-utang to maanmaan no soopi. ");
INSERT INTO oboNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na pomon to waa id pokovayad din, id suhu taddot hari no id boligya iddon sudsuhuwon amoy'd uriponnon, apii iddos sawa woy mgo anak din. Woy id suhu mandad taddot hari no id povoligya kos langun no koruwonnan din amoy id bayad to utang. ");
INSERT INTO oboNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pomon tadda, mid lingko-od iddos sudsuhuwon woy id po-eru-eru riyot hari, kahi rin to, ‘Sir, boggayi a pa to timpu, su od boyaran ku en sikkow taddot langun no utang ku.’ ");
INSERT INTO oboNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na no-eruwan iddos hari, de-en id posinsyan din sikandin woy id podwora rin don iddos utang din woy id po-uli. ");
INSERT INTO oboNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“To mid leggua ron iddon sudsuhuwon, nosinuggung din iddos duma rin no sudsuhuwon no duwon mandad utang kandin, piru disok da. Idda ron en, id pokkoo rin iddos noko-utang kandin woy kahi rin to, ‘Boyariyud en iddos utang du koddi!’ ");
INSERT INTO oboNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Na iddos duma rin no sudsuhuwon, mid lingko-od woy id po-eru-eru kandin, kahi rin to, ‘Boggayi a pa to timpu, su od boyaran ku en sikkow.’ ");
INSERT INTO oboNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Piru waa en sikandin id aman woy id poprisu rin da en baling taman tod kovoyaran din iddos utang. ");
INSERT INTO oboNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","To nokita to dumon mgo sudsuhuwon iddon notomanan, oraroy ran no nosokitan. Woy mid undiyon sikandan to hari woy id ponudtuu ran iddos langun no notomanan. ");
INSERT INTO oboNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“De-en id po-umow taddot hari iddon sudsuhuwon, kahi rin to, ‘Oray'n morat kos botasan du! Id posinsyan ku sikkow taddot langun no utang du, su id po-eru-eru ka koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mambo moho to waa eru ru riyot duma ru no sudsuhuwon iling taddot id pokita ku kikow?’ ");
INSERT INTO oboNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pomon to lingasa taddot hari, id suhu rin nod prisuwon woy'd posokitan iddon sudsuhuwon taman tod pokovayad taddot langun no utang din.” ");
INSERT INTO oboNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na mid ikahi si Disas to, “Ungketen dad en mandad kos od puungan koniyu to Amoy ku no riyot datas to langit, otik dii row od posinsyan to bonnaavonnaa iddos nokopuung to saa koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nopongnga mid nonaw si Disas taddon ponunggelengan, id tanan sikandin diyot prubinsya to Galilea, woy id undiyon sikandin to Judea no riyot dipaa to Oweg to Jordan. ");
INSERT INTO oboNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mo-uraa oraroy kos minuvu nid tinundug kandin, woy id bowiyan din iddos od pongkovohokan. ");
INSERT INTO oboNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na, duwon mgo Pariseo nid porani ki Disas amoy'd posahad kandin ukit to kod-intud, kahi ran to, “Ondan, noko-ikuu vo riyot mgo Suhu ni Moises iddos kodsuwoy to mama to sawa rin to ahad ondan no unayan?” ");
INSERT INTO oboNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mid tavak si Disas to, “Yo row osenga no waa kow nokovasa taddot Nosulat no Kahit Monama, no riyot tigkonayan to id bovallan to Monama kos minuvu, id bovallan din kos mama woy ba-ay. ");
INSERT INTO oboNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Woy mid ikahi iddos Monama to, ‘Ini en kos unayan no od tanan kos mama to amoy woy inoy rin amoy'd pokodsokkad don sikandan to sawa rin, woy dos oruwa, od kosokkad don.’ ");
INSERT INTO oboNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Na konnad sikandan oruwa, ko konna, sokkad don. De-en iddos id podsokkad don to Monama, konnod podsuwayon to minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mid ikahi iddos mgo Pariseo kandin to, “Ko ungketen, mambot id aman si Moises no od boggoy kos mama riyot sawa rin to kosulatan to kodposuwayoy, woy kopongnga, od pokodsuwoy ran don to sawa rin?” ");
INSERT INTO oboNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mid tavak si Disas to, “Id aman si Moises nod suwayan dow kos sawa row, su motoggas man kos uu row. Piru riyot tigkonayan, konna ungketen kos dontulon to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Od ikohiyan ku sikiyu, no iddos ahad ondoy no mama nod suwoy to sawa rin no waa id loivug woy iddon mama, od osawa to duma, nokoloivug en sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Na mid ikahi iddos mgo tinodduwan diyot ki Disas to, “Ko ungketen kos toosawa, moppiya pa no konnod osawa.” ");
INSERT INTO oboNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mid tavak si Disas to, “Konna langun no minuvu od pokotanggap duwot osengan dow, ko konna, idda ra en so id boggayan to Monama to kogahan nod pokoti-is no konnod osawa. ");
INSERT INTO oboNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nokod-osso-ossa kos mgo unayan no konna od osawa kos minuvu. Dos duma, konna od osawa pomon to duwon kulang diyot lawa ran pomon poron to kodtobbow ran. Iddos duma, konna od osawa pomon to id kopun sikandan. Idda mandad so duma, konna od osawa su iyon dan id popoomdom, dos kodpuung atag to kodharit Monama. Na iddos ahad ondoy nod pokogaha nod tanggap ka-ay'n nonaw, ko-ilangan en nod tonggapon din ini. ");
INSERT INTO oboNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sokkad no allow, duwon mgo minuvu nid piyod to mgo anak dan diyot ki Disas. Id kopi-i ran no id pokita ni Disas kos kopiyannoy rin diyot mgo anak ukit to kodtoddung din to bollad din taddot uu ran diyon to koddasaa. Piru id sugga to mgo tinodduwan din iddos mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kahin Disas to, “Podtohona row ron kos mgo anak nod porani koddi woy yo row sikandan sugga-a. Su iddos mgo minuvu nod salig to Monama iling to kodsalig to mgo anak, sikandan en kos no-iraom diyon to kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Na, id torungngan ni Disas to bollad din kos uu taddot mgo anak diyon to koddasaa rin atag kandan, woy nopongnga, id ipanow sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na, duwon sokkad no minuvu no id undiyot ki Disas woy mid intud kandin, kahi rin to, “Tohodnonaw, ondan kos moppiya nod puungan ku amoy'd kotanggap ku kos umuun waad tomanon?” ");
INSERT INTO oboNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mid tavak si Disas to, “Mambot id inturan a nikkow ko ondan kos moppiya? Sokkad da kos moppiya, idda ra en so Monama. Na moka-atag taddot intud du, otid kopiyan ka nod pokotanggap to umuun waad tomanon, tumanow kos mgo suhu to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mid intud mandon iddos minuvu, kahi rin to, “Ondan bo iddon mgo suhu?” Id tavak si Disas to, “ ‘Yo kod imatoy, yo kod loivug, yo kod ponakow woy yo kod posivonnaa to uhus. ");
INSERT INTO oboNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Rispitu ka to amoy woy inoy ru, woy ginowanniyu kos dumon minuvu iling to kodginawa ru to kikow'n ko-ugolingun.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kahi taddot minuvu to, “Langun duwon no suhu, id puungan kud. Ondan pa kos ko-ilangan nod puungan ku?” ");
INSERT INTO oboNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kahin Disas kandin to, “Otid kopiyan ka no waa en kulang diyot kikow, boligya ru kos korotuwan du woy pomboggoy ru kos bayad riyot worowora. Na otid puungan du ini, duwon en korotuwan du riyot datas to langit. Kopongnga, livod ka woy duma ka koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","To norinog idda taddot minuvu, id ipanow sikandin no naanu, oyyos dakkoo man kos kandin no korotuwan. ");
INSERT INTO oboNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Na kahin Disas diyot mgo tinodduwan din to, “Bonnaavonnaa nod ikohiyon ku koniyu, no mosuppit en taddot minuvu no dakkoo kos korotuwan nod kolonug diyon to kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Od uliton ku tod oseng, moomok pa iddos kod-usok to kamelyo riyon to bobbot simat kuntra to minuvu no dakkoo kos korotuwan nod lonug diyon to kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","To norinog idda taddot mgo tinodduwan din, oraroy ran no nosoobbuwan, woy mid intud sikandan to, “Ko ungketen, ondoy pobbo kos od kotobbus?” ");
INSERT INTO oboNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Id tongtong si Disas kandan woy mid ikahi to, “Konna ini od kopuungan to minuvu, piru iddos Monama, od kopuungan din en kos langun.” ");
INSERT INTO oboNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kahin Pedro to, “Na sikami, id tonanan doyd kos langun pomon to koddumoruma kikow. Ondan man kos od kotanggap doy?” ");
INSERT INTO oboNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mid tavak si Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no riyot timpu nod kolammi ron inis ingod, siyak no Anak to Minuvu, od unsad diyot koddin trunu amoy'd hari woy od kokita iddos se-aa to kotuusan ku. Na sikiyu no mgo tinodduwan ku, od unsad mandad diyot sopuu-oruwon trunu woy od hukuman dow iddos sopuu-oruwon tribu to Israel. ");
INSERT INTO oboNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Dos ahad ondoy nod tanan to ubpan din, mgo suwod o tobboy, amoy o inoy rin, mgo anak din woy mgo kamot pomon to koddumoruma koddi, od pokotanggap sikandin to lampas pa taddot id tonanan din, woy od pokotanggap sikandin to umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Piru iddos mowwet ko-ungkay riyot kod-ontong to minuvu, od poobbovan, woy dos moobbava ko-ungkay riyot kod-ontong to minuvu, od porotason.” ");
INSERT INTO oboNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Na mid ikahi si Disas to, “Iddos kodharit Monama, od poko-iling ka-ay'n ponunggelengan. Duwon sokkad no minuvu no duwon pinomuwon ubas. Sokkad no allow to sollom poron, id ipanow sikandin amoy'd nangkap to mgo minuvu nod popuungon taddot kamot din. ");
INSERT INTO oboNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Duwon nokita rin woy id potonduwoy ran no od boyaran din sikandan to ollog no bayad to sokkad no allow no kodpuung. Na, id po-undiyon din sikandan to ubasan amoy'd puung. ");
INSERT INTO oboNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","To mgo alas nuwebe ron to sollom, id ipanow ron mandon dos komunoy to kamot woy nokita rin iddos waa od pongkopuungan diyot plasa. ");
INSERT INTO oboNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kahi rin kandan to, ‘Undiyon kow mandad to ubasan ku woy puung kow rutun, woy od boyaran ku sikiyu to ollog no bayad.” ");
INSERT INTO oboNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","De-en mid undiyon sikandan to ubasan amoy'd puung. To mgo alas dose ron, id ipanow mandon iddos komunoy amoy'd nangkap tod popuungon din, woy ungketen dad en mandad kos id puungan din to alas tres to mapun. ");
INSERT INTO oboNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na, to mgo alas singko ron to mapun, id undiyon mandon sikandin to polingki woy nokita rin iddos waad pongkopuungan dutun. Kahi rin kandan to, ‘Mambo moho to id uuwakkan dow kos timpu no waa od pongkopuungan laroy't allow?’ ");
INSERT INTO oboNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mid tavak sikandan to, ‘Waa man od popuung konami.’ Kahi taddot komunoy to, ‘Undiyon kow to ubasan ku woy puung kow rutun.’ ");
INSERT INTO oboNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“To od kosagkup don, id osengan taddot komunoy to ubasan iddos ponguu tat id popuung din. Kahi rin to, ‘Umawow iddos mgo tohodpuung woy boyariyu sikandan. Unna-aw tod bayad dos mori nid puung taman taddot unna nid puung.’ ");
INSERT INTO oboNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Na iddos id puung to mgo alas singko ron, id undiyon woy ipat sokkad kandan, id boyaran to ollog no bayad to kodpuung to sokkad no allow. ");
INSERT INTO oboNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","De-en to id inguma iddos unna nid puung, kunan dan ko lampas pa kos bayad nod kotanggap dan, piru ipat sokkad kandan, nokod-iling da vos en kos bayad to kodpuung to sokkad no allow. ");
INSERT INTO oboNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","To id tanggap dan iddos bayad kandan, id pommivig dan taddot komunoy to ubasan. ");
INSERT INTO oboNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kahi ran to, ‘Ikos mori no id popuung du, sokkad dobbon uras kos kodpuung dan, piru sikami moho, no-ilad-ilad koy to monit laroy't allow.’ ");
INSERT INTO oboNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Piru mid ikahi iddos komunoy diyot sokkad kandan to, ‘Suwod, waa a mid loimbung koniyu. Konna vo id potonduwoy kid man no iddos id bayad ku koniyu, idda en so ollog no bayad to kodpuung to sokkad no allow? ");
INSERT INTO oboNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ongayow inis bayad du woy uli kad. Koddin id kopi-i nod bayad diyot mori nid puung iling taddot id bayad ku koniyu. ");
INSERT INTO oboNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Waa vo kotungud ku nod puung to ahad ondan nid kopi-i ku, su koddi man no soopi idda? Saddook nosina ka ayu, su moppiya kos id puungan ku kandan.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Na mid ikahi si Disas to, “Ungketen dad en mandad kos od kotomanan diyon to kodharit Monama. Iddos moobbava ko-ungkay riyot kod-ontong to minuvu, od poratason, woy dos mowwet ko-ungkay riyot kod-ontong to minuvu, od poobbovan.” ");
INSERT INTO oboNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na, to id ipanow onsi Disas po-undiyot Jerusalem, id livuung din iddos sopuu-oruwon tinodduwan din diyot ibpit to daan woy id ikohiyan din to, ");
INSERT INTO oboNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pominog kow, od undiyon kid to Jerusalem. Na rutun, siyak no Anak to Minuvu, id boggoy a riyot bollad to mgo ponguu to tohodbuwis woy riyot mgo tohodnonaw to Suhu ni Moises. Od silutan a nikandan to kopotayan. ");
INSERT INTO oboNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Id boggoy a nikandan diyot bollad to konna mgo Judio amoy'd sumpoliton woy od pomodasan. Kopongnga, id pakpak a nikandan diyon to krus, piru riyot iko-otollun allow, od kovadnow a.” ");
INSERT INTO oboNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na, id undiyot ki Disas iddos sawa ni Sebedeo duma taddot oruwon anak din no mama no si Santiago woy si Juan. Id lingko-od sikandin diyot isowwan din woy mid ikahi to, “Longaggon, duwon od buyuwon ku kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mid intud si Disas kandin, kahi rin to, “Ondan man kos id kopi-i ru?” Id tavak iddos ba-ay to, “Id kopi-i ku no otid inguma ron kos timpu to kodhari ru, od po-unsaron du inis oruwon anak ku riyot duug du, sokkad diyot kowanan woy dos sokkad diyot ivang du.” ");
INSERT INTO oboNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mid ikahi si Disas to, “Waa row nosorolli ko ondan kos od buyuwon dow. Od pokogaha kow vo nod ukit to kosupittan iling tod ko-ukitan ku?” Id tavak iddos oruwon toosuwod to, “Oyya, od pokogaha koy.” ");
INSERT INTO oboNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kahin Disas to, “Bonnaa rad en no iddos kosupittan nod ko-ukitan ku, od ko-ukitan dow mandad. Piru moka-atag to kodpo-unsad diyot kowanan woy ivang ku, konna siyak kos od aam tadda. Oyya su id panoy ron tapoy to Amoy ku ko ondoy kos od po-unsaron din tadda.” ");
INSERT INTO oboNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","To norinog idda taddot sopuun tinodduwan no duma ran, nolingasa sikandan taddot oruwon toosuwod. ");
INSERT INTO oboNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","De-en id umow ni Disas iddos langun no tinodduwan din woy id ikohiyan din to, “Nosorollan dow no iddos od ponguu to konna mgo Judio, id pomohos dan iddos id kopi-i ran, woy dos mgo minuvu no mowwet kos kotundanan, id pokita ran en kos kandan no kotungud. ");
INSERT INTO oboNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Piru sikiyu, konna kow iling kandan, su iddos ahad ondoy koniyu nod kopiyan nod kovovallan no mowwet, ko-ilangan no od poobbava woy'd po-uripon. ");
INSERT INTO oboNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Woy dos ahad ondoy nod kopiyan no mowwet to langun koniyu, ko-ilangan no od po-uripon sikandin to duma. ");
INSERT INTO oboNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Su ahad siyak no Anak to Minuvu, waa a mid undini to ingod amoy'd uripon to mgo minuvu, ko konna, amoy od po-uripon a woy id boggoy ku kos umuu ku atag to kodtobbus to mo-uraan minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","To id leggua ran don pomon diyot Jerico, mo-uraan minuvu kos mid tinundug ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Duwon oruwon butud no mid ounsad diyot ibpit to daan, woy norinog dan nid lihad si Disas. De-en id pomehes sikandan no mid ungketen to, “Longaggon, lubbad ni David, ko-eruwan ka konami!” ");
INSERT INTO oboNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Id sugga sikandan taddot mo-uraan minuvu amoy'd po-onong-onong. Piru ayas da en sikandan id pomehes nid ungketen to, “Longaggon, lubbad ni David, ko-eruwan ka konami!” ");
INSERT INTO oboNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Na id soro si Disas, woy id umow rin iddos mgo butud woy id inturan, kahi rin to, “Ondan man kos id kopi-i row nod puungan ku koniyu?” ");
INSERT INTO oboNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mid tavak sikandan to, “Longaggon, id kopi-i roy nod pokokita.” ");
INSERT INTO oboNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Na, no-eruwan si Disas kandan woy id somaddan din kos mata ran. Idda ron en, nokokita ron sikandan woy id duma ran ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na, to morani ron sikandan diyot Jerusalem, od kopantow ran don iddos bariyu to Betpahe no riyot banod to Buvungan to mgo Olibo. Id po-unna ni Disas dutun iddos oruwa taddot mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kahi rin kandan to, “Undiyon kow to bariyu no riyot ko-unnan, woy to kod-inguma row rutun, idda ron en, od kokita row iddos asnu nid ikot duma to nati rin. Okasa row vo idda woy tuyuka row rinit koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Otik duwon od intud koniyu, tovaka row no, ‘Od ko-ilonganon ini tod Longaggon woy go-os din da ini id po-uli.” ");
INSERT INTO oboNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nopuungan ini, su amoy od kotuman iddos id poponudtuu to Monama ukit to propeta no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ponudtuli row iddos mgo toho Sion no, ‘Od inguma ron kos koniyun hari no mopoobbava woy id sakoy sikandin to natit asnu.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na mid ipanow iddos oruwon tinodduwan, woy id puungan dan kos id suhu ni Disas kandan. ");
INSERT INTO oboNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Id tuyuk dan iddos asnu woy dos nati po-undiyon to ki Disas. Id ompasan dan idda to umpak, woy mid sakoy sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mo-uraa kos minuvu rutun no id ampas to mgo umpak dan diyot daan nod ukitan din to kodposivantug kandin. Woy dos duma, id tampod to moollimot no mgo panga to kayu woy id ampas dan idda riyot daan. ");
INSERT INTO oboNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na, iddos mgo minuvu no riyot ko-unnan din woy dos id tinundug, id pehes dan no mid ungketen to, “Od doongon kos lubbad ni David. Od posivontuhan ta kos id popiyod to Monama nod Longaggon. Od doongon kos Monama riyot datas to langit!” ");
INSERT INTO oboNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","To kod-inguma ni Disas diyot Jerusalem, nohuyakot kos langun nid oubpa rutun woy kahi ran to, “Ondoy man inin minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mid tavak iddos mo-uraan minuvu nid tinundug kandin, kahi ran to, “Sikandin en si Disas, dos propeta no id pomon diyot Nazaret no sakup to Galilea.” ");
INSERT INTO oboNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na mid usok si Disas diyot templo, woy id pa-awa rin iddos langun nod pombovoligya riyot lama woy dos id pombovolli rutun. Id ponlingkuwab din iddos mgo lomisa taddot tohodbovullas to soopi, woy id pompiloy rin iddos mgo unsaran taddot od pombovoligya to mgo soopati. ");
INSERT INTO oboNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mid ikahi sikandin to, “No-ikahi riyot Nosulat no Kahit Monama no, ‘Iddos Baoy't Monama, od ngoranan no baoy atag to koddasaa.’ Piru sikiyu, id bovallan dow moho ini nod oubpan to mgo tokawon!” ");
INSERT INTO oboNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na, duwon mgo butud woy mgo pungku no mid porani kandin diyot templo, woy id bowiyan din sikandan. ");
INSERT INTO oboNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Piru iddos mgo ponguu to tohodbuwis woy dos mgo tohodnonaw to Suhu ni Moises, oraroy ran no nolingasa to nokita ran iddos mokososoobbun pinuungan ni Disas woy to norinog dan no ahad iddos mgo anak, id pehes to kahaan no mid ungketen to, “Od doongon ta inis lubbad ni David!” ");
INSERT INTO oboNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","De-en id intud sikandan ki Disas, kahi ran to, “Norinog du vo iddos osengan dan?” Mid tavak si Disas to, “Oyya. Waa kow vo nokovasa taddot Nosulat no Kahit Monama no, ‘Ahad iddos moollimot poron no mgo anak, id nonawwan to Monama nod doong kandin?’ ");
INSERT INTO oboNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Na, mid tanan si Disas kandan woy id undiyon to Betania woy riyon sikandin id owwot. ");
INSERT INTO oboNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na, to nosollom don to id livod onsi Disas diyot Jerusalem, id gutasan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nokita rin iddos kayu nod ngoranan to igera diyot ibpit to daan. Id porani sikandin tadda amoy'd ontongngan ko duwon bunga, piru paanan da en mgo do-un kos nokita rin. De-en id ikohiyan din iddos kayu to, “Pomon ko-ungkay, konna kad od bovunga.” Na idda ron en, nahangu iddos kayu. ");
INSERT INTO oboNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","To nokita idda taddot mgo tinodduwan din, oraroy ran no nosoobbuwan, kahi ran to, “Eh! Mambot tigkow moho nahangu ikon kayu?” ");
INSERT INTO oboNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kahin Disas kandan to, “Bonnaavonnaa nod ikohiyon ku koniyu, no otik duwon kopomakoy row woy waa kodduworuwa row, od kopuungan dow kos iling taddot id puungan ku ka-ay'n kayu. Woy konna ra idda, ahad od ikahi kow ra ka-ay't buvungan to, ‘Od ko-onnat ka woy'd poko-antug diyot dahat,’ od kopuungan en idda. ");
INSERT INTO oboNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ahad ondan kos od buyuwon dow riyon to Monama, id boggoy rin en idda koniyu otid pomakoy kow.” ");
INSERT INTO oboNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na, id livod si Disas diyot templo woy laggun tid nonaw sikandin, id porani kandin iddos mgo ponguu to tohodbuwis woy dos od pombuyyahon to mgo Judio. Kahi ran to, “Ondak kotungud du ka-ay't langun nid puungan du? Woy ondoy kos id boggoy kikow ka-ay'n kotungud?” ");
INSERT INTO oboNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mid tavak si Disas kandan to, “To dii ku pa od tovakon kos intud dow, duwon intud ku koniyu. Tovaka row ini, woy id ponudtuu ku koniyu ko ondoy kos id boggoy koddi to kotungud to kodpuung ka-ay. ");
INSERT INTO oboNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Dos kotungud ni Juan to kodboutismu, id pomon bo riyot Monama o riyot minuvu?” Na id posisipoy ran kod monnuwon dan idda tod tavak, kahi ran to, “Otid ikahi ki no, ‘Iddos Monama kos id boggoy kandin to kotungud,’ na od ikahi sikandin to, ‘Mambot waa kow id pomakoy ki Juan?’ ");
INSERT INTO oboNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Piru otid ikahi ki no, ‘Minuvu kos id boggoy kandin to kotungud,’ na od kovaakkan ki to mgo minuvu, su id pomakoy ran no propeta en si Juan.” ");
INSERT INTO oboNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","De-en mid tavak sikandan to, “Waa koy nokosaddoo ko ingkon idda id pomon.” Na kahin Disas kandan to, “Ko ungketen, dii ku mandad sikiyu od ponudtulan ko ingkon id pomon kos kotungud ku to kodpuung ka-ay.” ");
INSERT INTO oboNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na id itulan dan ni Disas to sokkad no ponunggelengan, kahi rin to, “Ondan kos poomdom dow moka-atag ka-ay? Duwon sokkad no amoy no oruwa kos anak din no mama. Id ikahi sikandin diyot kakoy to, ‘Anak, undiyon ka to ubasan ko-ungkay'n allow woy puung ka rutun.’ ");
INSERT INTO oboNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mid tavak iddos kakoy to, ‘Dii a.’ Piru riyot mori, nopalin kos poomdom din woy id undiyon sikandin to ubasan. ");
INSERT INTO oboNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Na iddos amoy, id undiyon mandad to ari, woy ungketen dad en kos id suhu rin. Mid tavak iddos ari to, ‘Oyya, od undiyon a en.’ Piru waa man sikandin id undiyon.” ");
INSERT INTO oboNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kahin Disas to, “Na atag koniyu, ingkon musing taddot oruwon anak kos id tuman taddot id kopi-i to amoy ran?” Id tavak sikandan to, “Idda en so kakoy.” De-en mid ikahi si Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no iddos mgo mosaasaan minuvu iling to oray'd loimbung no mgo tohodsukut to buhis woy dos mgo ba-ay nod bovoligya to lawa ran, od unna sikandan koniyu nod lonug to kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Su iddot mid undini si Juan no Tohodboutismu woy id nonaw koniyu to motallong no ko-ubpa, waa kow moho id pomakoy kandin. Piru iddos oray'd loimbung no mgo tohodsukut to buhis woy dos morat no mgo ba-ay, id pomakoy ran kandin. Ahad pe-en nokita row nid pomakoy ran, waa kow mid sondit woy'd tanan to koniyun mgo saa woy waa kow id pomakoy kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Na kahin Disas kandan to, “Pominogga row inis ossa pa no ponunggelengan. Duwon sokkad no minuvu no id pomuwa to ubas diyot kamot din. Na id kuralan din idda, woy id bovaa sikandin tod toviran to ubas, woy id poohinat sikandin to motikang no sabbung nod ubpan tod tamong tadda. Nopongnga, id popursintuwan din iddos kamot woy id undiyon sikandin to osson ingod. ");
INSERT INTO oboNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","To timpu ron to kodpomupu to ubas, id suhu rin kos mgo sudsuhuwon din diyot id pomursintu amoy'd angoy to kandin no taad. ");
INSERT INTO oboNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Piru to kod-inguma taddot mgo sudsuhuwon din, id ammot dan taddot id pomursintu. Dos sokkad, id pomodasan dan, dos sokkad, id imotayan woy dos sokkad, id ponlumbahan dan to batu taman tid patoy. ");
INSERT INTO oboNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Na, id suhu mandon taddot komunoy iddos duma pon mgo sudsuhuwon no mo-uraa pa taddot unna, piru ungketen dad en kos id puungan taddot id pomursintu. ");
INSERT INTO oboNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Diyot mori, id suhu taddot komunoy iddos anak din, su kohingginawa rin to, ‘Od rispituwon dan en kos anak ku.’ ");
INSERT INTO oboNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Piru to nokita taddot id pomursintu no idda ron so anak to komunoy kos od inguma, id po-ikohiyoy ran to, ‘Ika ron kos anak to komunoy. Kuo kid, od imotayan ta sikandin amoy siketa ron kos od pokokomunoy ka-ay't ubasan!’ ");
INSERT INTO oboNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","De-en id goyod dan sikandin po-undiyot leggua to ubasan woy id imotayan.” ");
INSERT INTO oboNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Na kahin Disas to, “Ondan ayu kos od puungan taddot komunoy to ubasan diyot id pomursintu?” ");
INSERT INTO oboNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mid tavak sikandan to, “Od imotayan din en iddon morat no mgo minuvu, woy od popursintuwan din iddos ubasan to ossa nod boggoy kandin to taad diyot timpu to kodpomupu to ubas.” ");
INSERT INTO oboNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kahin Disas kandan to, “Waa kow vo nokovasa taddot Nosulat no Kahit Monama no, ‘Iddos batu no id oovoddan to tohodbovaoy su kunan dan ko waa koru-anon, idda vos en kos batu no mosalig no po-unsaran. Dos od Longaggon kos id puung tadda, woy motoos idda nod tongtongngan.’ ");
INSERT INTO oboNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Na ponayun mid ikahi si Disas to, “De-en od ikohiyan ku sikiyu, no konnad sikiyu no mgo Judio kos od kolonug diyon to kodharit Monama, ko konna, idda ron so mgo minuvu nod tuman to kandin nid kopi-i. ");
INSERT INTO oboNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Iddos ahad ondoy nod pokovuntug taddon batu, od kotoppuwan en, woy dos od ko-uuhan tadda, od koubpot en.” ");
INSERT INTO oboNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","To norinog taddot mgo ponguu to tohodbuwis woy taddot mgo Pariseo iddos mgo ponunggelengan ni Disas, noovottan dan no sikandan kos id suhat din. ");
INSERT INTO oboNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Purisu od omotton dan nanoy sikandin, piru novaakkan dan taddot mo-uraan minuvu, su id pomakoy ran no propeta en si Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na id itulan dan mandon si Disas to ponunggelengan. ");
INSERT INTO oboNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Kahi rin to, “Iddos kodharit Monama, iling ka-ay. Duwon sokkad no hari no id panoy to dakkoon kodpoka-an atag to anak din nod osawa. ");
INSERT INTO oboNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","To id inguma ron kos allow't kosaa, id po-undiyonnan din to mgo sinuhuwan din iddos mgo minuvun no-inggat amoy od posampot kandan nod undiyon to kosaa. Piru langun dan, id bolivad. ");
INSERT INTO oboNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","De-en id popiyod din mandon iddos duma pon uripon din amoy od ikahi taddot nongo-inggat no, ‘Nosumbali ron kos mgo baka woy dos id paambog no mgo natin baka, woy nopanoy ron kos langun. De-en undini kowd to kosaa to anak ku.’ ");
INSERT INTO oboNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Piru iddos nongo-inggat, id podtohon dan da en idda woy id ponayun dan iddos pinuungan dan. Dos sokkad, id undiyon to kamot din woy idda mandad so sokkad, diyot nigusyu rin. ");
INSERT INTO oboNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Woy dos duma, id ammot dan moho iddos mgo sinuhuwan taddot hari, id pomodasan dan idda woy id imotayan. ");
INSERT INTO oboNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Oray'n nolingasa iddos hari, de-en id polusuran din iddon mgo minuvu to mgo sundau rin amoy'd imotayan dan iddos id imatoy taddot mgo sinuhuwan din woy od tirukkan dos bonuwa ran. ");
INSERT INTO oboNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Na id po-umow taddot hari iddos dumon mgo uripon din, kahi rin to, ‘Nopanoy ron kos langun atag to kosaa, piru iddos nongo-inggat ku, konna ollog nod sakup tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Undiyonni row dos mgo minuvu riyot mgo doraanon woy inggata row nod undini to kosaa iddos ahad ondoy nod kokita row.’ ");
INSERT INTO oboNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","De-en id undiyon to doraanon iddos mgo sinuhuwan woy id livuung dan iddos langun no nosuggung dan, dos moppiya woy dos morat no mgo minuvu, woy noponnu iddos baoy nod kosalan. ");
INSERT INTO oboNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Todtahad id usok iddos hari amoy'd olit-olit taddot mgo minuvu no nolivuung dutun. Na, nokita rin no duwon sokkad no minuvu no waa id sukub to umpak atag to kosaa. ");
INSERT INTO oboNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Id inturan sikandin taddot hari, kahi rin to, ‘Suwod, mambot ka-ay ka no waa ka man id sukub to umpak atag to kosaa?’ Piru waa en sikandin nokotavak. ");
INSERT INTO oboNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","De-en mid ikahi iddos hari riyot mgo sinuhuwan din to, ‘Bokuwa row kos bollad woy pa-a rin woy lumbag dow sikandin diyot mosuksukirom. Na rutun, mopet dobbo kos sinoggawon din woy'd pogkihot sikandin to ngipon pomon to mosakit nod geddamon din.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Na mid ikahi si Disas to, “Mo-uraa kos id pon-inggat, piru disok da kos id aam to Monama nod kolonug diyot kodhari rin.” ");
INSERT INTO oboNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na, mid awa iddos mgo Pariseo woy id pomuhawang dan nod posaharon si Disas ukit to osengan din. ");
INSERT INTO oboNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Woy id po-undiyon dan to ki Disas iddos kandan no mgo tinodduwan woy dos mgo minuvu ni Herodes. To kod-inguma ran, id ikohiyan dan si Disas to, “Tohodnonaw, nokosaddoo koy no bonnaa en kos langun nid nonaw ru woy iyon du id nonaw, iddos kovonnaan moka-atag to id kopi-it Monama. Iddos ahad ondoy nod isowwon du, id pod-iling du kos kodnonaw ru kandan, oyyos waa od podmusingon du. ");
INSERT INTO oboNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Purisu ponudtuli koy ko ondak poomdom du moka-atag ka-ay. Diyot mgo Suhu ni Moises, ollog bo iddos kodbayad to buhis diyot hari to Roma o dii?” ");
INSERT INTO oboNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Piru nosorollan ni Disas no morat kos dontulon dan, de-en kahi rin to, “Sikiyu no oray'd po-uvag-uvag no mopompomakoy, mambot od geddaman a nikiyu? ");
INSERT INTO oboNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pokitanna a ve-en to soopi nid bayad dow to buhis.” Na, id toyawwan dan sikandin to soopi. ");
INSERT INTO oboNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kahin Disas kandan to, “Ondoy man bonnong woy ngaran kos od kokita ka-ay?” ");
INSERT INTO oboNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mid tavak sikandan to, “Iddos hari to Roma.” Na kahin Disas to, “Ko ungketen, boggoy row riyot hari to Roma iddos kandin, woy boggoy row riyot Monama iddos kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","To norinog dan idda, oraroy ran no nosoobbuwan woy mid awa ran dutun woy'd ipanow. ");
INSERT INTO oboNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na iddon allow, duwon mgo Saduseo no id porani ki Disas. Inin mgo minuvu, konnod pomakoy nod bodnawon to Monama iddos id poomatoy ron. ");
INSERT INTO oboNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kahi ran to, “Tohodnonaw, nosulat diyot mgo Suhu ni Moises no otik duwon mama nod patoy no waa anak dan taddot sawa rin, ko-ilangan no od pomoowwon tat suwod din amoy'd poko-anak dan atag taddot id patoy. ");
INSERT INTO oboNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ponunggeleng, duwon pittun toosuwod no mama no id oubpa ka-ay. Dos kinokokayan, id osawa, piru id patoy no waa anak dan. Na, id pomau taddot iko-oruwon suwod din iddon ba-ay. ");
INSERT INTO oboNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ungketen dad en mandad kos notomanan taddot iko-oruwon suwod, woy taddot iko-otollu taman to iko-pittu. Id poomatoy ran langun no waa anak. ");
INSERT INTO oboNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Diyot mori, id patoy mandad iddos ba-ay. ");
INSERT INTO oboNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na, init allow to kodbadnow taddot id poomatoy ron, ondoy musing kandan kos tullid no sawa taddot ba-ay? Su iddos langun taddot pittun toosuwod, noko-osawa man kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mid tavak si Disas to, “Soyup kow, oyyos waa kow nokaabbot taddot Nosulat no Kahit Monama woy taddot kotuusan to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Su init allow to kodbadnow taddot id poomatoy ron, od poko-iling don sikandan to mgo ponolihan diyot datas to langit no konnod po-osoway. ");
INSERT INTO oboNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na moka-atag to kodbadnow taddot id poomatoy ron, yo row osenga no waa kow nokovasa taddot id ikahi to Monama koniyu no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Siyak kos Monama ni Abraham, ni Isaac woy ni Jacob.’ Na, ungketen kos no-ikahi ahad nouhoy ron id poomatoy onsi Abraham. Dos kohulugan tadda, no od kovadnow en iddos poomatoy ron, oyya su iddos Monama, konna sikandin Monama taddot id poomatoy ron, ko konna, Monama taddot nongo-uyag.” ");
INSERT INTO oboNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","To norinog idda taddot mgo minuvu, oraroy ran no nosoobbuwan taddot nonaw rin. ");
INSERT INTO oboNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Na, to norinog taddot mgo Pariseo no waa nokotavak iddos mgo Saduseo ki Disas, id porumannoy ran nid undiyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sokkad kandan no oray'd kotuig no tohodnonaw to mgo Suhu ni Moises, id geddam ki Disas ukit to kod-intud. ");
INSERT INTO oboNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Kahi rin to, “Tohodnonaw, diyot langun no Suhu ni Moises, ingkon musing tadda kos lampas to langun kos koru-anon?” ");
INSERT INTO oboNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Mid tavak si Disas to, “ ‘Ginowanniyu kos Monama nod Longaggon du riyot tivuk no pusung du, diyot tivuk no umuu ru woy riyot tivuk no poomdom du.’ ");
INSERT INTO oboNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ini en kos suhu no lampas to langun kos koru-anon. ");
INSERT INTO oboNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Woy iddos iko-oruwon suhu no lampas to langun kos koru-anon, idda en so, ‘Ginowanniyu kos duma iling to kodginawa ru to ko-ugolingun du.’ ");
INSERT INTO oboNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ka-ay en pantok to oruwon suhu, id pomon iddos langun no suhu no id boggoy to Monama ki Moises woy dos langun no id sulat to mgo propeta.” ");
INSERT INTO oboNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","To nolivuung pa iddos mgo Pariseo, mid intud si Disas kandan, kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ondan kos poomdom dow moka-atag to Mesiyas? Ondoy man kos kovuyyahan din?” Mid tavak sikandan to, “Lubbad sikandin ni David.” ");
INSERT INTO oboNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kahin Disas to, “Ko ungketen, mambo man to id ngoranan sikandin ni David no ‘Longaggon’? Oyya su iddot no-iroomman si David to Uhis no Ispiritu, id ooseng sikandin to, ");
INSERT INTO oboNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Mid ikahi iddos Monama riyon tod Longaggon ku no, Unsad ka lomig to kowanan ku taman tod kotalu kud iddos od pongkuntra kikow.’ ");
INSERT INTO oboNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na, su id ngoranan man sikandin ni David no ‘Longaggon,’ momonnu vo no lubbad ni David iddos Mesiyas?” ");
INSERT INTO oboNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Waa en nokotavak taddot intud ni Disas, ahad songo-kahi. Nopongnga idda, worad sikandan noko-aku nid intud kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Na mid ooseng si Disas diyot mo-uraan minuvu woy riyot mgo tinodduwan din. Kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Iddos mgo tohodnonaw to Suhu ni Moises woy dos mgo Pariseo, duwon kotungud dan nod paabbotlabbot to mgo Suhu ni Moises. ");
INSERT INTO oboNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","De-en ko-ilangan en nod tumanon dow woy od puungan dow iddos langun no id ponudtuu ran koniyu. Piru yo kowd iling kandan, su konna ran od puungan iddos id nonaw ran. ");
INSERT INTO oboNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Id povoggatan dan kos mgo minuvu nod tuman taddot id podluntudluntud dan no mgo suhu no id pohos dan nod ikulon. Piru waa ran man id tavang kandan nod tuman tadda, ahad disok da. ");
INSERT INTO oboNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Diyot langun nod puungan dan, id pokitakita ran to mgo minuvu amoy'd doongon. De-en id poowaggan dan iddos tawwan to mgo bersikulu no id pomon to Nosulat no Kahit Monama nid ikot diyot uu woy bollad dan. Woy id supayyan dan iddos ubpu to umpak dan no mowwet amoy'd pokitakita to duma no oraroy ran no mopompomakoy. ");
INSERT INTO oboNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iyon dan id dokollan to ginawa, iddos kod-unsad diyot isowwan to mgo minuvu riyot mgo pista woy ahad diyot mgo simba-an to Judio no id panoy atag taddot od rispituwon no mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Oraroy ran mandad od kotoosan nod kumustan woy'd rispituwon diyot od kolivuungan to mgo minuvu, woy od kotoosan dan nod ngoranan no ‘Tohodnonaw.’ ");
INSERT INTO oboNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Piru sikiyu, yo kow od aman nod ngoranan no ‘Tohodnonaw,’ su sokkad da en kos koniyun Tohodnonaw woy langun dow, iling to mgo toosuwod. ");
INSERT INTO oboNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Woy yo kow od ngaran to ‘Amoy’ to ahad ondoy ka-ay to ampow't ingod, oyyos sokkad da kos Amoy row no riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Woy yo kow'd aman nod ngoranan kow no ‘Ponguu,’ oyyos sokkad da en kos Ponguu row no idda en so Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dos ahad ondoy koniyu no od kopiyan no lampas kos koru-anon to langun, ko-ilangan nod kovovallan sikandin no sudsuhuwon dow. ");
INSERT INTO oboNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Oyya su iddos ahad ondoy nod poratasdatas to kandin no ko-ugolingun, od poobbovan woy dos od poobbava, od porotason.” ");
INSERT INTO oboNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Moka-arat-arat en kod kotomanan dow, sikiyu no mgo tohodnonaw to Suhu ni Moises woy mgo Pariseo! Oraroy kow nod po-uvag-uvag no mopompomakoy! Su iling tid lokobban dow kos sobbangan amoy diid poko-usok kos mgo minuvu riyon to kodharit Monama. Id elle kow nod lonug taddot kodhari rin woy id boovahan dow iddos od kopiyan nod lonug. ");
INSERT INTO oboNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Moka-arat-arat en kod kotomanan dow, sikiyu no mgo tohodnonaw to Suhu ni Moises woy mgo Pariseo! Oraroy kow nod po-uvag-uvag no mopompomakoy to Monama! Su id ahaw row iddos mgo koruwonnan taddot mgo ba-ay'n bau. Woy od tombunan dow iddos morat no pinuungan ukit to mowwet no dosalon no uvag kun to moppiya kow no mgo minuvu. Purisu lampas en no moka-arat-arat kos kodsilut to Monama koniyu! ");
INSERT INTO oboNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Moka-arat-arat en kod kotomanan dow, sikiyu no mgo tohodnonaw to Suhu ni Moises woy mgo Pariseo! Oraroy kow nod po-uvag-uvag no mopompomakoy! Oyyos od undiyon kow to dipaat dahat woy riyot moriyun mgo ingod amoy duwon ahad sokkad dobbon minuvu nod kopiyod dow nod ikuu taddot nonaw row. Woy to nopiyod dowd sikandin, od kovovallan dow sikandin no lampas pe-en koniyu nod silutan diyon to linow't apuy. ");
INSERT INTO oboNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Iling kow moho to butud no od inahak to duma rin no butud. Moka-arat-arat en kod kotomanan dow! Su id nonaw row, no otik duwon id pongulivot dow riyot templo, konna kun saa otik dii rin idda od tumanon. Piru id ikahi kow no iddos ahad ondoy nod pongulivot ukit to buawan diyot templo, ko-ilangan en nod tumanon din idda. ");
INSERT INTO oboNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mgo bangog kow woy mgo butud! Ingkon musing ka-ay iddos lampas kos koru-anon? Idda vo so buawan o iddos templo no nokopo-uhis taddot buawan? ");
INSERT INTO oboNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Id nonaw row mandad no ‘otik duwon od pongulivot ukit to buwisanan, konna kun saa otik dii rin idda od tumanon. Piru otid pongulivot sikandin ukit taddot id buwis diyot buwisanan, ko-ilangan en kun nod tumanon din idda.’ ");
INSERT INTO oboNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Noompasan kow no butud! Ingkon musing iddos lampas kos koru-anon? Idda vo so buwis o iddos buwisanan no nokopo-uhis taddon buwis? ");
INSERT INTO oboNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Idda en so buwisanan! Purisu iddos minuvu no id pongulivot ukit taddot buwisanan, konna ra iddos buwisanan kos id pongulivottan din, ko konna, ahad iddos id buwis dutun. ");
INSERT INTO oboNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Woy dos minuvu no id pongulivot ukit to templo, konna ra iddos templo kos id pongulivottan din, ko konna, ahad iddos Monama no id oubpa rutun. ");
INSERT INTO oboNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Woy dos ahad ondoy no id pongulivot ukit to langit, konna ra langit kos id pongulivottan din, ko konna, ahad iddos trunu to Monama woy dos mid unsad dutun. ");
INSERT INTO oboNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Moka-arat-arat en kod kotomanan dow, sikiyu no mgo tohodnonaw to Suhu ni Moises woy mgo Pariseo! Oraroy kow nod po-uvag-uvag no mopompomakoy! Su od boggoy kow to koniyun iko-sopuu, ahad pa iddos id pomon to pinomuwa row no mgo loggu. Piru id podtohon dow man iddos mgo Suhu ni Moises no ko-ilangan nod puung kow to motallong, eeruwon kow woy'd kosolihan. Ollog en no id boggoy row kos iko-sopuu, piru yo row podtohona iddos kodpuung taddot dumon suhu no lampas pa kos koru-anon. ");
INSERT INTO oboNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Iling kow moho to butud no od inahak to duma rin no butud. Od noonokkalan dow tod ikuu iddos disok no mgo suhu, piru id podtohon dow iddos mgo suhu no lampas kos koru-anon. Iling kow to minuvu no od solan din kos tovisok diyot oweg amoy dii rin idda od ko-inom, piru iyon din baling noommod, iddos kamelyo. ");
INSERT INTO oboNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Moka-arat-arat en kod kotomanan dow, sikiyu no mgo tohodnonaw to Suhu ni Moises woy mgo Pariseo! Oraroy kow nod po-uvag-uvag no mopompomakoy! Noko-iling kow to minuvu no idda ra en so leggua to pokawan woy oyyug to pinggan kos id linisan din, piru riyot daom, molibmit poron. Oyya su id pokitakita kow ra to moppiyon botasan, piru iddos pusung dow, noponnut kodloupig woy oray'd akon-akon. ");
INSERT INTO oboNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sikiyu no mgo Pariseo, mgo butud kow! Unna-a row pa linisi kos daom to pokawan woy pinggan dow amoy'd molinis mandad kos diyot leggua. ");
INSERT INTO oboNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Moka-arat-arat en kod kotomanan dow, sikiyu no mgo tohodnonaw to Suhu ni Moises woy mgo Pariseo! Oraroy kow nod po-uvag-uvag no mopompomakoy! Iling kow to lobbong no id pinturan to moputi. Moppiya nod ontongngan kos diyot leggua, piru riyot daom, noponnut mgo tullan woy duma pon molibmit. ");
INSERT INTO oboNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ungketen kow rad en mandad, oyyos od pokitakita kow no motallong kos mgo botasan dow, piru iddos kovonnaan, od po-uvag-uvag kow woy noponnu kos ginawa row to langun no kororattan. ");
INSERT INTO oboNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Moka-arat-arat en kod kotomanan dow, sikiyu no mgo tohodnonaw to Suhu ni Moises woy mgo Pariseo! Oraroy kow nod po-uvag-uvag no mopompomakoy! Id povovallan dow to lovongngan iddos mgo propeta, woy id pomotoos dow iddos lovongngan to motallong no mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Woy mid ikahi kow no, ‘Otik duwon koyd nanoy iddot timpu to kovuyyahan doy, dii koy en od lonug to kod-imatoy to mgo propeta.’ ");
INSERT INTO oboNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Piru ukit taddot id ikahi row, id posivonnaa no koubbaran kow taddot id imatoy to mgo propeta. ");
INSERT INTO oboNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ovaya row, ipongnga-a row iddos id tigkonayan taddot koniyun kovuyyahan! ");
INSERT INTO oboNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Iling kow to mgo uwod nod laas! Dii kow en od pokoleggua taddot silut to Monama koniyu riyon to linow't apuy. ");
INSERT INTO oboNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","De-en id popiyod ku ruwot koniyu iddos mgo propeta, dos mgo minuvu no moraom kos koovottan woy dos mgo tohodnonaw to kahit Monama. Piru iddos duma, od imotayan dow woy dos duma, id pakpak dow riyon to krus. Idda mandad so duma, od bodasan dow riyot mgo simba-an dow. Ahad ingkon sikandan od paahuy, od loupuhon dow amoy'd posupittan. ");
INSERT INTO oboNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pomon ka-ay, od sukutan kow to Monama taddot kod-imatoy to kovuyyahan dow to mgo motallong pomon poron ki Abel taman ki Zacarias no anak ni Baraquias, no id imotayan dow riyot ollot to templo woy buwisanan. ");
INSERT INTO oboNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Bonnaavonnaa nod ikohiyon ku koniyu, no sikiyu no mgo minuvu to inin timpu kos od silutan to kod-imatoy kandan langun.” ");
INSERT INTO oboNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Koyoy koniyu no toho Jerusalem, oraroy a nod kosowkuu koniyu. Su id ponlumbahan dow to batu iddos mgo propeta, woy id pon-imotayan dow sikandan woy dos duma no id po-unduwon to Monama to koniyu. Kopila kud nanoy tod kupkup koniyu iling to mommiyak, piru dii row ini id kopi-i. ");
INSERT INTO oboNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sikiyu nod pon-oubpa ka-ay'n bonuwa, pomotawi row! Od inguma kos timpu no od inoyyuhan kowd to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Od ikohiyan ku sikiyu, no dii ad en nikiyu od kokita taman tod poko-ikahi kowd to, ‘Od posivontuhon ta iddos id popiyod to Monama nod Longaggon.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na, to id tanan si Disas diyot templo woy mid ipanow, id porani kandin iddos mgo tinodduwan din woy id toddu ran kandin iddos motoos no kodbovaa taddot langun diyot templo. ");
INSERT INTO oboNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kahin Disas kandan to, “Oyya, motoos en. Piru bonnaavonnaa nod ikohiyon ku koniyu, no od inguma kos timpu no wora ahad sokkad duwot mgo batu no id podluntudluntud nod kosama, oyyos od gobban en.” ");
INSERT INTO oboNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na, to id unsad si Disas diyot Buvungan to mgo Olibo, id undiyot kandin iddos mgo tinodduwan din no siksikandan da woy mid intud kandin. Kahi ran to, “Ponudtuli koy, kannu man od kotuman inis id ikahi ru, woy ondan kos kilaannan to kodlivod du woy dos kotompusan to ingod?” ");
INSERT INTO oboNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mid tavak si Disas to, “Bantoy kow no konna kow od ko-okalan. ");
INSERT INTO oboNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Su mo-uraa kos od loppow no od po-uvag-uvag nod piyod to koddin ngaran nod ikahi no, ‘Siyak en kos Mesiyas,’ woy mo-uraa kos od ko-okalan dan. ");
INSERT INTO oboNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Od pokorinog kow no duwon gira ka-ay't morani row woy riyot moriyu, piru yo kow'd kovaakki. Oyyos ko-ilangan en nod kotuman ini langun, piru konna pa ini kos kotompusan to ingod. ");
INSERT INTO oboNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Oyya su iddos sokkad no ingod, od pokidgira taddot osson ingod, woy dos sokkad no kohoriyan, od pokidgira to osson kohoriyan. Duwon mandad od inguma no dakkoon gutas woy mgo linug diyot nokod-osso-osson lugaa. ");
INSERT INTO oboNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Na ini langun, iling to tigkonayan da to mosakit nod geddamon to ba-ay nod sokalan. ");
INSERT INTO oboNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Od omotton kow, od posupittan woy'd imotayan. Id kolingasa-i kow to langun no minuvu pomon to kopomakoy row koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Iddon timpu, mo-uraa kos od tanan to kopomakoy woy'd po-okaloy woy id kolingasa-i ran kos duma nod pompomakoy. ");
INSERT INTO oboNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na, od loppow iddos mo-uraa no konna bonnaan mgo propeta woy mo-uraa kos od ko-okalan dan. ");
INSERT INTO oboNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pomon to lampas don kos kororattan ka-ay to ampow't ingod, od mohonnow ron kos ginawa to ko-urallan to minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Piru iddos ahad ondoy nod ti-is to kosupittan taman to kotompusan, od kotobbus en. ");
INSERT INTO oboNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Woy to dii pa od inguma kos kotompusan, id ponudtuu riyon to intirut ingod iddos Moppiyon Dinoggan moka-atag to kodharit Monama amoy'd pokosaddoo kos langun no minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Na ponayun mid ikahi si Disas to, “Od inguma kos timpu no od kokita row riyot daom to templo iddos od piyod to kororattan amoy'd supak to Monama. Woy ini en kos id posaddoo dangan ni propeta Daniel. (Atag taddot od basa ka-ay, ko-ilangan nod loblovotton dow ini!) ");
INSERT INTO oboNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Na otid inguma ron inin kotomanan, iddos id pon-oubpa riyot Judea, ko-ilangan nod paahuy riyot buvunganon. ");
INSERT INTO oboNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iddos minuvu no riyot atop to baoy rin, ko-ilangan no dii ron sikandin od usok diyot baoy amoy'd ponemmos pa. ");
INSERT INTO oboNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Idda mandad so minuvu riyot kamot din, ko-ilangan no dii ron od uli amoy'd angoy to umpak din. ");
INSERT INTO oboNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Woy iddon timpu, moko-eru-eru iddos mgo movoddos woy dos duwon anak nod susu poron! ");
INSERT INTO oboNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dasaa kow no iddos kodpaahuy row, konnod pokosasang to timmohonnow woy Allow't Kod-imolloy. ");
INSERT INTO oboNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Su iddos kosupittoy to iddon timpu, od lampas pa taddot kosupittoy pomon poron to tigkonayan to ingod taman ko-ungkay. Woy worad en od inguma pa no kosupittoy no iling tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Piru ko waa poobbava-a to Monama iddon timpu, waa en ahad sokkad no minuvu nod ko-uyag. Piru atag da en taddot id pon-aam din, id poobbovan din iddon timpu. ");
INSERT INTO oboNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Na otik duwon mgo minuvu nod ikahi koniyu to, ‘Ontongngi row, ini ron kos Mesiyas,’ o ‘Idda ron sikandin,’ yo kow'd pomakoy kandan. ");
INSERT INTO oboNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Oyyos od loppow en iddos od ikahi no sikandan kun kos Mesiyas woy dos duma, od ikahi no sikandan kun kos mgo propeta. Od puung dan to mgo mokososoobbu amoy'd aakaa nanoy taddot mgo minuvu nid aam to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pomotawi row! Su id ponudtuu kud tapoy ini koniyu to dii pa od inguma iddon kotomanan. ");
INSERT INTO oboNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“De-en otik duwon mgo minuvu nod ikahi to, ‘Ontongngi row, diyon sikandin to noka-awoy-awoy'n lugaa,’ na yo kow'd undiyon. Otid ikahi ran to, ‘Ontongngi row, id oollos sikandin dutun,’ yo kow ron en od pomakoy kandan. ");
INSERT INTO oboNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Oyya su iddos kodlivod ku no Anak to Minuvu, od poko-iling to kilat no tigkow od se-aa riyot koowaggan to langit woy od kokita to langun ka-ay to ampow't ingod.” ");
INSERT INTO oboNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Na ponayun mid nonaw si Disas ukit to ponunggelengan, kahi rin to, “Otid kokita nod lolivuung iddos mgo uwak, od kosorollan no morani kos bangkoy. Iling mandad tadda, otid kokita iddos mgo kilaannan, od kosorollan no morani ron kos kotompusan to ingod.” ");
INSERT INTO oboNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Na kopongnga iddos timpu to kosupittan, ‘od mosukirom kos allow woy konnad od se-aa kos buwan. Od pongo-umpad kos bitu-on, woy od pongo-antog iddos duma pa no riyot datas to langit.’ ");
INSERT INTO oboNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kopongnga tadda, od loppow riyot datas to langit iddos kilaannan no asow ron kos kodlivod ku no Anak to Minuvu. Na, od pondaawit kos langun no minuvu riyot nokod-osso-osson ingod, otid kokita ran iddos lampas no se-aa to kotuusan ku riyot kod-inguma ku nod dumannan to souhapun. ");
INSERT INTO oboNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na duwon monokkaan dahing to trumpeta, woy id popiyod ku kos mgo ponolihan ku amoy od limud taddot mgo minuvu nid aam ku pomon diyot ahad ingkon ka-ay to ampow't ingod.” ");
INSERT INTO oboNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Na mid ikahi si Disas to, “Poomdomma row iddos kayu no igera amoy'd pokopohinonaw kow. Otid kokita row nod sosuving don idda, od kosorollan dow no asow ron kos tintollak. ");
INSERT INTO oboNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iling mandad tadda, otid kokita rowd inin mgo kotomanan, od kosorollan dow no asow ron kos kodlivod ku. ");
INSERT INTO oboNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Bonnaavonnaa nod ikohiyon ku koniyu, no od kotuman en inis langun to dii pa od poomatoy kos mgo minuvu no no-uyag to inin timpu. ");
INSERT INTO oboNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Od kowora kos langit woy livuta, piru inis mgo kahi ku, dii en od kowora taman to waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Piru moka-atag taddot timpu to kodlivod ku, waa ahad sokkad no minuvu no nokosaddoo, ahad iddos mgo ponolihan diyot datas to langit, ahad siyak no Anak to Monama, ko konna, idda ra en so Monamon Amoy. ");
INSERT INTO oboNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Iddos pinuungan to mgo minuvu riyot timpu to kodlivod ku no Anak to Minuvu, od poko-iling taddot pinuungan to mgo minuvu iddot timpu ni Noe. ");
INSERT INTO oboNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Su iddon timpu to waa pa iddos dakkoon lanog, iyon id pompuungan to mgo minuvu, iddos kodka-an, kod-oinom woy kodpo-osoway taman to allow nid usok si Noe riyot arka. ");
INSERT INTO oboNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Waa ran nosorolli ko ondan kos od kotomanan dan taman tid inguma iddos dakkoon lanog woy langun dan, nongoonnod. Na, iling dad en mandad tadda kos od kotomanan init timpu no siyak no Anak to Minuvu, od livod. ");
INSERT INTO oboNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","To iddon timpu, otik duwon oruwon mama nod puung diyot kamot, dos sokkad, od ongayon woy dos sokkad, od kotuwos. ");
INSERT INTO oboNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Otik duwon oruwon ba-ay nod gohiling, dos sokkad, od ongayon woy dos sokkad, od kotuwos. ");
INSERT INTO oboNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","De-en panoypanoy kow, oyyos waa row nosorolli iddos allow to kodlivod tod Longaggon dow. ");
INSERT INTO oboNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tota-aw row ini riyot koniyun poomdom, no otik od kosorollan pa nanoy to komunoy to baoy ko kannu od inguma kos tokawon, od bantoy en sikandin amoy dii od poko-usok kos tokawon. ");
INSERT INTO oboNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Purisu sikiyu mandad, ko-ilangan no nopanoy kow, su siyak no Anak to Minuvu, od inguma en diyot uras no waa row poomdomma.” ");
INSERT INTO oboNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Na mid nonaw mandon si Disas ukit to ponunggelengan, kahi rin to, “Iddos sudsuhuwon nod kosolihan woy duwon moraom no koovottan, sikandin kos od solihan to amu to kodtamong to duma rin no mgo sudsuhuwon, woy to kodtaadtaad to koka-an dan diyot ollog no timpu. ");
INSERT INTO oboNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Moppiya kod kotomanan taddot sudsuhuwon, no riyot kodlivod to amu rin, od kokita nid puungan din kos langun no id popuungan kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Bonnaavonnaa nod ikohiyon ku koniyu, no id salig en taddot amu iddos langun no koruwonnan din diyot od kosolihan no sudsuhuwon. ");
INSERT INTO oboNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Piru ko morat iddon sudsuhuwon, od oungketen kos ginawa rin to, ‘Kouhoy pa od uli kos amu ku.’ ");
INSERT INTO oboNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Od pomodasan din iddos duma rin no mgo sudsuhuwon, woy iyon din da en od puungan, dos kodka-an woy kod-oinom duma to mgo polohubug. ");
INSERT INTO oboNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na, od inguma iddos amu rin diyot allow woy uras no waa rin immana. ");
INSERT INTO oboNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Od silutan sikandin woy id poommung diyot mgo minuvu nod po-uvag-uvag no mopompomakoy. Na rutun, mopet dobbo kos sinoggawon dan woy'd pogkihot sikandan to ngipon pomon to mosakit nod geddamon dan.” ");
INSERT INTO oboNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Na ponayun mid ikahi si Disas to, “Iddos kodharit Monama, iling ka-ay. Duwon sopuun mongovay no id piyod to ilowan dan, su od tommu taddot od osawa amoy'd sakup to kosaa. ");
INSERT INTO oboNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Dos limma kandan, mgo le-aw woy idda mandad so limma, moraom kos koovottan. ");
INSERT INTO oboNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Iddos le-aw, waa ran id piyod to gaas no id sullug dan otid ko-ominan dos ilowan. ");
INSERT INTO oboNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Piru iddos moraom kos koovottan, id piyod pe-en to gaas no id sullug dan otid ko-ominan dos ilowan. ");
INSERT INTO oboNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na pomon to nouhoy id inguma iddos od osawa, id tintinuhon dan taman to no-urom-urom sikandan. ");
INSERT INTO oboNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Na riyot tongngovulli ron, duwon id umow no mid ungketen to, ‘Ka-ay ron iddos od osawa. Undini kow woy tommu kow kandin!’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Idda ron en, id onnow dos mgo mongovay woy id panoy ran iddos mgo ilowan dan. ");
INSERT INTO oboNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dos mgo le-aw, mid ooseng diyot limma no moraom kos koovottan, kahi ran to, ‘Boggayi koy pa uvag to disok no gaas, su asow ron od ko-ovukkan inis mgo ilowan doy.’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Piru mid tavak iddos moraom kos koovottan, kahi ran to, ‘Eh konna, su saddook kulang don ini atag keta langun. Moppiya pa, undiyon kow baling to tindahan woy bolli kow.’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Na laggun tid ipanow ran, id inguma ron iddos od osawa. Woy dos limmon mongovay no nopanoy ron, mid usok duma kandin diyot kosalan woy id lokobban don iddos sobbangan. ");
INSERT INTO oboNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Todtahad, id inguma riyot leggua to sobbangan iddos le-aw no mgo mongovay woy mid umow ran nid ungketen to, ‘Sir, Sir! Po-usokka koy!’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Piru mid tavak iddos od osawa to, ‘Waa a nokokilaa koniyu.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Na kahin Disas to, “De-en panoypanoy kow, oyyos waa row nosorolli ko ondan ollawa o urasa iddos kodlivod ku.” ");
INSERT INTO oboNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Na id itulan dan ni Disas to ossa pa no ponunggelengan. Kahi rin to, “Iddos kodharit Monama, iling ka-ay. Duwon minuvu no to waa pa sikandin id ipanow po-undiyot moriyun ingod, id po-umow rin kos mgo sudsuhuwon din amoy id salig din kandan iddos soopi rin. ");
INSERT INTO oboNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Dos ipat sokkad taddot sudsuhuwon din, id solihan din to loppa tod kogaha ran. Iddos sokkad, id solihan to limmon maan (5,000) no buawan no soopi woy dos sokkad, id solihan din to oruwa maan (2,000), woy idda mandad so sokkad, id solihan din to sokkad no maan (1,000). Na idda pa, id ipanow sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dos sudsuhuwon no nokotanggap to limmon maan (5,000) no buawan no soopi, idda ron en, id nigusyu rin idda, woy limmon maan (5,000) mandad kos gononsya rin. ");
INSERT INTO oboNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ungketen dad en mandad kos id puungan taddot nokotanggap to oruwon maan (2,000) no buawan no soopi, nokogononsya sikandin to oruwon maan (2,000). ");
INSERT INTO oboNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Piru idda moho so nokotanggap to sokkad no maan (1,000) no buawan no soopi, id kokali riyot livuta woy id lobbong din iddos soopi to amu rin amoy id tota-aw. ");
INSERT INTO oboNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","To nouhoy'n timpu, id uli ron iddos amu taddon mgo sudsuhuwon, woy id po-umow rin sikandan amoy'd kosorollan ko momonnu ron kos soopi rin. ");
INSERT INTO oboNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na, id porani iddos nokotanggap to limmon maan (5,000) no buawan no soopi, woy id boggoy rin idda riyot amu rin duma to gononsya rin. Kahi rin to, ‘Sir, id solihan a nikkow to limmon maan (5,000) no buawan no soopi. Na, ini ron kos soopi ru duma to limma maan (5,000) no gononsya.’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kahi taddot amu rin to, ‘Moppiya kos id puungan du. Moppiya ka woy kosolihan no sudsuhuwon. Pomon tod kosolihan ka man to disok, od solihan ku sikkow to dakkoo. Na usok ka rini, woy lonug ka to kahaan ku.’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Na, id porani mandad iddos nokotanggap to oruwon maan (2,000) no buawan no soopi. Kahi rin to, ‘Sir, id solihan a nikkow to oruwon maan (2,000) no buawan no soopi. Na, ini ron kos soopi ru duma to oruwon maan (2,000) no gononsya.’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kahi taddot amu rin to, ‘Moppiya kos id puungan du. Moppiya ka woy kosolihan no sudsuhuwon. Pomon tod kosolihan ka man to disok, od solihan ku sikkow to dakkoo. Na usok ka rini, woy lonug ka to kahaan ku.’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Na, id porani iddos nokotanggap to sokkad no maan (1,000) no buawan no soopi woy mid ikahi to, ‘Sir, nokosaddoo a no oraroy ka no istriktu. Od ongayon du pe-en iddos konna kikow, woy od kottuwon du ahad iddos waa ru oiluggati tid pomuwa. ");
INSERT INTO oboNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Novaakkan a, de-en id ipanow a woy id lobbong ku inis soopi ru. Na ini rad kos soopi.’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kahi taddot amu rin to, ‘Morat ka woy poggulon no sudsuhuwon! Nokosaddoo ka rad bos en no od ongayon ku iddos konna koddi, woy od kottuwon ku ahad iddos waa ku oiluggati tid pomuwa. ");
INSERT INTO oboNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na, ko ungketen kos poomdom du, mambot waa ru moho id ta-aw kos soopi ku riyot bangku amoy od kotanggap ku nanoy no duwon don tuvu.’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Na, mid ikahi iddos amu riyot dumon sudsuhuwon din to, ‘Ongaya row kos soopi ruwot kandin woy boggoy row riyot duwon sopuun maan (10,000) no buawan no soopi. ");
INSERT INTO oboNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Su iddos od kosolihan, od duhangan pe-en iddos diyot kandin. Piru iddos diid kosolihan, od ongayon pe-en ahad iddos disok dobbo no riyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na ikos waa koru-an no sudsuhuwon, lumbag dow riyot mosuksukirom. Na rutun, mopet dobbo kos sinoggawon to mgo minuvu woy'd pogkihot sikandan to ngipon pomon to mosakit nod geddamon dan.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Na ponayun mid ikahi si Disas to, “Diyot timpu to kodlivod ku duma to langun no ponolihan, siyak no Anak to Minuvu, od unsad a riyot koddin trunu amoy'd hari woy od kokita iddos se-aa to kotuusan ku. ");
INSERT INTO oboNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Od livuungon kos langun no minuvu ka-ay to ampow't ingod diyot isowwan ku, woy od pod-ossan ku sikandan iling to tohodtamong to oyama nod pod-ossan kos mgo karnero woy mgo kambing. ");
INSERT INTO oboNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Iddos mgo minuvu no id po-iling ku to karnero, id ta-aw ku riyon lomig to kowanan ku, woy dos id po-iling ku to mgo kambing, diyon lomig to ivang. ");
INSERT INTO oboNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na siyak no Hari, od osengan ku iddos mgo minuvu no riyon lomig to kowanan ku, kahi ku to, ‘Sikiyu no nokotanggap to kopiyannoy to Amoy ku, undini kow woy lonug kow to kohoriyan ku no id panoy atag koniyu pomon poron to tigkonayan to ingod. ");
INSERT INTO oboNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Oyya su id gutasan a, id poka-an a nikiyu, woy notokkangan a, id po-inom a nikiyu. Id undiyon a to koniyu no waa od kopenekkan ku, id olit-olit a nikiyu. ");
INSERT INTO oboNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Waa umpak ku, id umpakan a nikiyu. Novohokan a, id tuhanuu a nikiyu woy to id prisu a, id lowwi a nikiyu.’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Na, iddos motallong no mgo minuvu no riyon lomig to kowanan ku, od ikahi to, ‘Longaggon, kannu roy man sikkow nokita nid gutasan no id poka-an doy, woy notokkangan no id po-inom doy? ");
INSERT INTO oboNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kannu ka man id undiyot konami no waa od kopenekkan du woy id olit-olit doy, woy waa umpak du no id umpakan doy? ");
INSERT INTO oboNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kannu ka man novohoki no id tuhanuu roy, woy kannu ka id prisu no id lowwi roy?’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na siyak no Hari, od tavak a kandan nod ungketen to, ‘Bonnaavonnaa nod ikohiyon ku koniyu, no ahad ondan kos id puungan dow amoy'd tavang ka-ay't mopoobbava to langun no suwod ku, id puungan dow ini atag koddi.’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Od osengan ku iddos mgo minuvu no riyon lomig to ivang ku, kahi ku to, ‘Sikiyu no id silutan to Monama, awa kow ka-ay! Diyon kow to linow't apuy no konna od ko-ovukkan no id panoy ron tapoy atag ki Moivuyan woy taddot mgo sakup din. ");
INSERT INTO oboNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Oyya su id gutasan a piru waa a nikiyu pokanna, woy notokkangan a piru waa a nikiyu po-inomma. ");
INSERT INTO oboNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Id undiyon a to koniyu no waa od kopenekkan ku, piru waa a nikiyu olit-olita. Waa umpak ku, piru waa a nikiyu umpaki. Novohokan a woy id prisu, piru waa a nikiyu lowwiya.’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Na od intud dan mandad koddi nod ungketen to, ‘Longaggon, kannu roy man sikkow nokita nid gutasan, notokkangan, id undiyot konami no waad kopenekkan, waa umpak, novohokan woy id prisu no waa roy tovangi?’ ");
INSERT INTO oboNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Od tavak a kandan to, ‘Bonnaavonnaa nod ikohiyon ku koniyu, no ahad ondan no waa row puungi amoy'd tavang ka-ay't mopoobbava to langun no suwod ku, iling mandad to waa kow id tavang koddi.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Purisu od po-owan sikandan amoy'd silutan to waad tomanon, piru iddos motallong no mgo minuvu, od pokotanggap to umuun waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Na, to nopongnga id nonaw ni Disas idda langun, id ikohiyan din iddos mgo tinodduwan din to, ");
INSERT INTO oboNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nosorollan dow no oruwa robbon allow pomon ko-ungkay, od inguma ron kos pista to Kodlihad to Ponolihan. Woy siyak no Anak to Minuvu, id boggoy riyot bollad to mgo minuvu amoy id pakpak diyon to krus.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na, id lolivuung iddos mgo ponguu to tohodbuwis woy dos od pombuyyahon to mgo Judio riyot baoy ni Caifas no mowwet no ponguu to mgo tohodbuwis. ");
INSERT INTO oboNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Id pomuhawang sikandan to kod-ammot ki Disas no waa od pokosaddoo, oyyos od po-imotayan dan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kahi ran to, “Konna ta id posasang to pista kos kod-ammot kandin, su saddook od ko-ukag kos mgo minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","To riyon don onsi Disas to Betania, mid undiyon sikandan to baoy ni Simon no duwon bohok no et-et no no-uliyan don. ");
INSERT INTO oboNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na, duwon sokkad no ba-ay nid inguma no id piyod to oray'n mahaa no pomammut no nokota-aw riyot tootawwan no binovallan pomot batu nod ngoranan to alabastro. Laggun tid ka-an onsi Disas, id porani kandin iddon ba-ay woy id daddas din iddos pomammut diyot uu ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","To nokita idda to mgo tinodduwan din, id langot sikandan woy kahi ran to, “Kuu! Mambo moho tid uuwakkan din ika? ");
INSERT INTO oboNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Su otik id boligya pa nanoy ikon pomammut, maanmaan kos kontidad woy dos bayad, id boggoy riyot mgo worowora.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Piru nokosaddoo si Disas taddot osengan dan woy mid ikahi sikandin to, “Mambot od sowayon dow sikandin? Su moppiya man kos id puungan din koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Oyya su iddos mgo worowora, inaayun dow od koruma. Piru siyak, konna a nikiyu inaayun od koruma. ");
INSERT INTO oboNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Inis koddaddas din to pomammut ka-ay't lawa ku, id panoy rin atag to kodlobbong koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Bonnaavonnaa nod ikohiyon ku koniyu, no ahad ingkon ka-ay to ampow't ingod id ponudtuu iddos Moppiyon Dinoggan, id ponudtuu en mandad inis id puungan din koddi amoy'd kosompottan sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sokkad taddot sopuu-oruwon apostoles no id ngoranan ki Judas Iscariote, id undiyon to mgo ponguu to tohodbuwis. ");
INSERT INTO oboNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Woy mid ikahi sikandin to, “Pila kos id boggoy row koddi otik id boggoy ku riyot koniyun bollad si Disas?” Na, id iyap dan to otollumpuun plata no soopi woy id boggoy ran idda riyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pomon taddon timpu, id nangkap si Judas to po-ukit to kodboligya ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na riyot unnon allow to pista to Paan no Waa Potuvu, id porani ki Disas iddos mgo tinudduwan din woy mid intud kandin. Kahi ran to, “Longaggon, ingkon koy od panoy to lavung ta atag to pista to Kodlihad to Ponolihan?” ");
INSERT INTO oboNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kahin Disas to, “Undiyonni row iddos sokkad no minuvu no riyot bonuwa to Jerusalem, woy osengi row sikandin no, ‘Mid ikahi iddos Tohodnonaw no id inguma ron kos timpu nid panoy to Monama atag kandin. Sikami no mgo tinodduwan din, id po-undini rin to baoy ru amoy ka-ay koy od lavung atag to pista to Kodlihad to Ponolihan.’ ");
INSERT INTO oboNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na, id puungan taddot mgo tinodduwan iddos id pomandu ni Disas woy id panoy ran to lavung atag to pista to Kodlihad to Ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","To od kosagkup don, mid ka-an si Disas duma taddot sopuu-oruwon apostoles. ");
INSERT INTO oboNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Laggun tid ka-an sikandan, mid ikahi si Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no sokkad koniyu, od boligya koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na oray'n naanu iddos mgo tinodduwan, woy ipat sokkad kandan, mid intud kandin, kahi ran to, “Longaggon, siyak bo kos od tommanon du?” ");
INSERT INTO oboNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mid tavak si Disas to, “Iddos id aggom to paan ka-ay't yohung duma koddi, sikandin en kos od boligya koddi. ");
INSERT INTO oboNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Siyak no Anak to Minuvu, od patoy a en iling taddot no-ikahi riyot Nosulat no Kahit Monama. Piru moka-arat-arat kod kotomanan taddot minuvu nod boligya koddi. Moppiya pa nanoy ko waa sikandin nominuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Na si Judas nod boligya ki Disas, mid ikahi to, “Tohodnonaw, siyak bo kos od tommanon du?” Id tavak si Disas to, “No-oseng dud en.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Laggun tid ka-an sikandan, mid angoy si Disas to paan woy id posolamat sikandin diyot Monama. Nopongnga, id toppiktoppik din idda woy id toyyow riyot mgo tinodduwan din, woy kahi rin to, “Owata row ini woy kanna row. Ini en kos lawa ku no id buwis atag koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na, mid angoy sikandin to kupa woy id posolamat diyot Monama. Nopongnga, id toyyow rin idda riyot kandan, woy kahi rin to, “Owata row ini woy inom kow langun. ");
INSERT INTO oboNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ini en kos longossa ku no id posivonnaa to kodpotonduwoy to Monama. Id tihis kos longossa ku atag to mo-uraan minuvu amoy'd koposinsyan kos mgo saa ran. ");
INSERT INTO oboNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Od ikohiyan ku sikiyu, no dii ad od uman nod inom to ammis to ubas taman tod inguma ron iddos timpu no od inom a to lammin ammis duma koniyu init timpu nod hari ron kos Monamon Amoy ku.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Na id kanta ran atag to koddoong to Monama, woy nopongnga, mid undiyon dan to Buvungan to mgo Olibo. ");
INSERT INTO oboNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Na kahin Disas kandan to, “Ini en no bulli, langun dow od paahuy woy'd tanan koddi, oyya su no-ikahi riyot Nosulat no Kahit Monama no, ‘Od imotayan ku iddos tohodtamong to karnero woy od pokodsuwoysuwoy kos mgo karnero.’ ");
INSERT INTO oboNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Piru riyot timpu nod kovadnow ad, od unna a koniyu riyon to Galilea.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Na kahin Pedro ki Disas to, “Ahad od tanan dan langun kikow, konna a en od tanan kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kahin Disas to, “Bonnaavonnaa nod ikohiyon ku kikow, Pedro, no to dii pa od ukkaa kos manuk to ini en no bulli, ko-otollu rud kangkan tod elle no waa ka id kilaa koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piru mid tavak si Pedro to, “Ahad od patoy a duma kikow, konna ku en id elle no waa ku sikkow nokilaa.” Na, ungketen dad en mandad kos id ikahi taddot dumon mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na, id undiyon si Disas to lugaa nod ngoranan to Getsemane duma taddot mgo tinodduwan din, woy id ikohiyan din sikandin to, “Unsad kow pa ka-ay, laggun tod dasaa a riyot ko-unnan.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Id poruma rin si Pedro woy dos oruwon anak ni Sebedeo. Id tigkanoy kos id geddam din no lampas no lanu, woy oray'n movoggat kos ginawa rin. ");
INSERT INTO oboNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kahi rin to, “Lampas kos lanu ku no imman tod patoy ad. Polintotuwos kow pa ka-ay woy yo kow'd tinuhon.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na id poriyu boyow sikandin diyot ko-unnan, woy rutun, id laangkob sikandin diyot livuta woy mid dasaa, kahi rin to, “Amoy ku, otid kopakoy, yo ad po-ukita tod ingumon koosayan. Piru konna inis id kopi-i ku kos od kotuman, ko konna, idda rad en so kikow'n id kopi-i.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","To id livod sikandin diyot otollun tinodduwan din, nokita rin sikandan no nokotinuhon. Kahi rin ki Pedro to, “Mambot id tinuhon kow moho? Konna kow vo od pokogaha no diid tinuhon ahad sokkad da no uras? ");
INSERT INTO oboNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yo kow'd tinuhon, woy dasaa kow amoy dii kow'd kopiyod diyot kodpuung to saa. Dos ginawa row, od kopiyan nanoy nod puung to motallong, piru iddos lawa row, moomet.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Na iko-oruwon timpu, id undiyon mandon si Disas to ko-unnan amoy'd dasaa. Kahi rin to, “Amoy ku, otik ko-ilangan en nod poko-ukit a to od ingumon koosayan, muopa no iddos kikow'n id kopi-i kos od kotuman.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nopongnga, id livod mandon sikandin diyot mgo tinodduwan din woy nokita rin sikandan no nokotinuhon, su oraroy ron no movoggat kos mata ran. ");
INSERT INTO oboNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Na, id tanan mandon si Disas kandan woy mid undiyon to ko-unnan amoy'd dasaa to iko-otollun timpu iling taddot unnon dosalon din. ");
INSERT INTO oboNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nopongnga idda, id livod mandon sikandin diyot mgo tinodduwan woy mid ikahi to, “Mambot id tinuhon kow poron woy'd oimolloy? Ontongngi row, id inguma ron kos uras no siyak no Anak to Minuvu, id boggoy riyot bollad to mgo mosaasaa. ");
INSERT INTO oboNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Onnow kowd, su ini ron kos minuvu nod boligya koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Laggun tod ooseng pa si Disas, id inguma si Judas no sokkad taddot sopuu-oruwon tinodduwan din. Id duma kandin iddos oray'n mo-uraan minuvu no posidpiyod to mgo polihuma woy mgo badas. Iyon id suhu kandan, iddos mgo ponguu to tohodbuwis woy dos od pombuyyahon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tapoy id posaddoo ni Judas kandan iddos kilaannan, kahi rin to, ‘Iddos minuvu no od pongumustan ku ukit to kod-arok, sikandin en iddos od nongkapon dow. Na omotta row sikandin!” ");
INSERT INTO oboNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","De-en to kod-inguma ni Judas, idda ron en, id porani sikandin ki Disas woy mid ikahi to, “Tohodnonaw, moppiyon bulli!” Woy id pongumusta sikandin ki Disas ukit to kod-arok. ");
INSERT INTO oboNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mid tavak si Disas to, “Suwod, lukutowd woy puungiyud iddos dontulon to kod-undini row.” Na, id ammot dan si Disas woy id ponoggasan dan tid somad. ");
INSERT INTO oboNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Idda ron en, sokkad taddot id duma ki Disas, id tadnus to polihuma rin, woy id tibbas din iddos uripon taddot mowwet no ponguu to mgo tohodbuwis, de-en no-utas kos divauy'n tolinga. ");
INSERT INTO oboNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Piru mid ikahi si Disas kandin to, “Polivod du kos polihuma ru ruwot lipi, su iddos langun nod tadnus to polihuma, od patoy en ukit to polihuma. ");
INSERT INTO oboNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Waa ka vo nokosaddoo, no otik id kopi-i ku, od poko-umow a riyot Amoy ku nod tavang koddi woy idda ron en, od popiyod sikandin to maanmaan no ponolihan? ");
INSERT INTO oboNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Piru otid buyu a to tavang, konna od kotuman iddos Nosulat no Kahit Monama no ini en kos ko-ilangan nod kotomanan.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na mid ikahi si Disas diyot mgo minuvu to, “Kriminal a vo su goli kow od piyod to mgo polihuma woy mgo badas to kod-ammot koddi? Allow-allow a man id unsad woy id nonaw riyot templo, piru waa a man nikiyu omotta. ");
INSERT INTO oboNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Piru od kotomanan ini langun, su amoy od kotuman iddos no-ikahi to mgo propeta riyot Nosulat no Kahit Monama.” Na, id tanan kandin iddos langun no tinodduwan woy id paahuy. ");
INSERT INTO oboNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na iddos id pon-ammot ki Disas, id piyod kandin diyot baoy to mowwet no ponguu to mgo tohodbuwis no si Caifas. Diyon mandad id lolivuung iddos mgo tohodnonaw to Suhu ni Moises woy dos od pombuyyahon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Si Pedro, id tintinundug no moriyu boyow taman diyot lama to baoy taddot mowwet no ponguu to mgo tohodbuwis. Id usok sikandin dutun woy mid ounsad duma to mgo tohodtamong taddon baoy amoy'd kokita ko ondan kos od kotomanan ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na, iddos mgo ponguu to tohodbuwis woy dos langun no sakup to hukumanan to mgo Judio, id nangkap sikandan to unayan, ahad konna bonnaa amoy'd uuhon dan to saa si Disas woy'd po-imotayan. ");
INSERT INTO oboNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Piru waa nokita ran, ahad mo-uraa kos id posivonnaa to uhus moka-atag kandin. Na riyot mori, duwon oruwon minuvu no id undiyon to isowwan taddot mgo ponguu. ");
INSERT INTO oboNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Woy kahi ran to, “Id oseng inin minuvu to, ‘Od gobban ku kos templo woy od poohinaton ku mandon daom to otollun allow.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Na, id lohinat iddos mowwet no ponguu to mgo tohodbuwis woy id inturan din si Disas, kahi rin to, “Waa vo id pokotavak du taddot id oseng dan moka-atag kikow?” ");
INSERT INTO oboNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Piru id po-onong-onong da en si Disas. Na, id ooseng mandon iddos mowwet no ponguu to mgo tohodbuwis, kahi rin to, “Pongulivot ka ukit to ngaran to ma-antoy'n Monama no od ponudtulan koy nikkow ko sikkow ve-en kos Mesiyas, dos Anak to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mid tavak si Disas to, “No-oseng dud en. Piru od ikohiyan ku sikiyu no init morin allow, od kokita row no siyak no Anak to Minuvu, od unsad diyon lomig to kowanan to Monamon Motuus, woy od undini a pomon diyot datas to langit nod dumannan to souhapun.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Na, id bendas taddot mowwet no ponguu to mgo tohodbuwis iddos umpak din pomon to lingasa rin, woy mid kahi sikandin to, “Id sosumpalit sikandin to Monama! Konnad ko-ilangan nod angoy ki pa to duma nod posivonnaa taddot saa rin? Sikiyu ron en kos nokorinog taddot kodsosumpalit din. ");
INSERT INTO oboNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na ondan kos od ko-oseng dow ka-ay?” Mid tavak sikandan to, “Ollog en sikandin nod imotayan.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Na, id ilobban dan sikandin diyot bonnong woy id ponsuntuk woy dos duma, id pontabpi kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kahi ran to, “Na sikkow no Mesiyas kun uvag, otukow ve-en ko ondoy kos id tabpi kikow?” ");
INSERT INTO oboNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Laggun tid ounsad si Pedro riyot lama, duwon sokkad no ba-ay no sudsuhuwon to mowwet no ponguu to mgo tohodbuwis no id porani kandin woy mid ikahi to, “Sikkow mandad, sokkad ka en no duma ni Disas no toho Galilea.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piru mid elle si Pedro riyot isowwan to langun, kahi rin to, “Te, waa moho saddoo ku ruwot id oseng du!” ");
INSERT INTO oboNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Waa nouhoy pomon tadda, mid undiyon sikandin to sobbangan to lama. Na rutun, duwon mandon sokkad no ba-ay'n sudsuhuwon no nokokita kandin, woy id osengan din iddos mgo minuvu rutun. Kahi rin to, “Ikon minuvu, sokkad en sikandin nid duma ki Disas no toho Nazaret.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piru mid elle rad mandon si Pedro no golid pongulivot, kahi rin to, “Waa a moho nokokilaa ruwon no minuvu!” ");
INSERT INTO oboNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Todtahad, id porani ki Pedro iddos mgo minuvu nid loohinat dutun woy kahi ran to, “Bonnaa en no sokkad ka en kandan, su riyot kodlituk du, iling mandad taddot kodlituk to mgo toho Galilea.” ");
INSERT INTO oboNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piru id pongulivot pe-en sikandin, kahi rin to, “Ahad od patoy a pa ko-ungkay ko id ouhus a, su nosorollan to Monama no waa ku en moho nokilaa ikon minuvu.” Na idda ron en, id ukkaa iddos manuk. ");
INSERT INTO oboNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Woy nosompottan ni Pedro iddos id ikahi ni Disas kandin no, “To dii pa od ukkaa kos manuk to ini en no bulli, ko-otollu rud kangkan tod elle no waa ka id kilaa koddi.” Na, mid awa sikandin woy oray'n mopet kos sinoggawon din. ");
INSERT INTO oboNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","To od ka-allow ron, id pomuhawang iddos langun no ponguu to tohodbuwis woy dos od pombuyyahon to mgo Judio ko momonnu ran od ko-imotayan si Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Id baku ran iddos bollad din woy id piyod dan sikandin diyot ki Pilato no gubernador to Roma. ");
INSERT INTO oboNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na si Judas no id boligya ki Disas, to nokita rin no id silutan si Disas to kopotayan, nokodsondit sikandin taddot id puungan din, woy id po-uli rin iddos otollumpuun plata no soopi riyot mgo ponguu to tohodbuwis woy'd pombuyyahon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kahi rin kandan to, “Nokosaa a, su id boligya ku iddos minuvu no waa saa.” Mid tavak sikandan to, “Te! Ondan mak lavut doy? Sikkow ron man kos bahala tadda!” ");
INSERT INTO oboNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Na, id sovuwak ni Judas iddos soopi riyot osag to templo. Mid awa sikandin woy id pongoggot ukit to kodbovitin. ");
INSERT INTO oboNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na, id pomurut taddot mgo ponguu to tohodbuwis iddos soopi woy kahi ran to, “Id diiyan diyot keton mgo Suhu no id timuu ini riyot tootawwan to soopi to templo, oyya su nahamit man ini atag to kodbayad to kod-imatoy to minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","De-en id pomuhawang dan nod gomiton iddon soopi to kodbolli to livuta riyot minuvu no tohodbovaa to kuron amoy od lovongngan atag to mgo moholiyug nod patoy. ");
INSERT INTO oboNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Purisu taman ko-ungkay, id ngoranan don iddon livuta to ‘Livuta nid Boyaran to Longossa.’ ");
INSERT INTO oboNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ukit tadda, notuman iddos id ikahi dangan ni propeta Jeremias no mid ungketen to, “Id angoy ran iddos otollumpuun plata no soopi, no idda en no kontidad kos no-unduhan to dumon koubbaran ni Israel no id bolli kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Woy id gamit idda amoy id bolli to livuta riyot minuvu no tohodbovaa to kuron iling taddot id suhu koddi to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na si Disas, mid lohinat diyot isowwan to gubernador woy id intud kandin iddos gubernador, kahi rin to, “Sikkow vo kos hari to mgo Judio?” Mid tavak si Disas to, “No-oseng dud en.” ");
INSERT INTO oboNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Piru waa tovaka ni Disas iddos mgo ponguu to tohodbuwis woy dos od pombuyyahon to mgo Judio no id uug kandin no nokopuung sikandin to saa. ");
INSERT INTO oboNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Na mid ikahi si Pilato to, “Waa ru vo norinog iddos mo-uraan saa no id uug dan kikow?” ");
INSERT INTO oboNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Piru waa en id tavak si Disas ahad sokkad taddot saa nid uug dan kandin, de-en oray'n nosoobbuwan dos gubernador. ");
INSERT INTO oboNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na ipat pista to Kodlihad to Ponolihan, nooyami ron to gubernador nod poleggua to sokkad no pinirisu no od buyuwon to mo-uraan minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Iddon timpu, duwon pinirisu no novantug nod puung to morat no id ngoranan ki Barabas. ");
INSERT INTO oboNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","De-en to nolivuung don iddos mo-uraan minuvu, id intud si Pilato kandan, kahi rin to, “Ondoy man kos id kopi-i row nod polegguangon ku, si Barabas bo o si Disas no id ngoranan no Mesiyas?” ");
INSERT INTO oboNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Id oseng ni Pilato idda, su nosorollan din no kosina kos unayan no id boggoy ran si Disas diyot bollad din. ");
INSERT INTO oboNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Laggun to id unsad pa si Pilato diyot unsaran to kodhukum, duwon id inguma no id piyod to sulat pomon diyot sawa ni Pilato. Woy nokosulat dutun no, “Yo ru monnuwa kos minuvu no waa saa, su genot bulli duwon morat no tohenoppon ku moka-atag kandin woy noosayan a oraroy taddon tohenoppon.” ");
INSERT INTO oboNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Piru id sutsutan taddot mgo tohodbuwis woy'd pombuyyahon to mgo Judio iddos mgo minuvu, no iyon dan od buyuwon nod polegguangon, si Barabas woy od po-imotayan si Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Na mid intud mandon si Pilato, kahi rin to, “Ondoy musing ka-ay't oruwa kos id kopi-i row nod polegguangon ku?” Mid tavak sikandan to, “Si Barabas!” ");
INSERT INTO oboNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kahi rin mandon to, “Ondan kos od puungan ku ki Disas no id ngoranan no Mesiyas?” Na langun dan mid tavak to, “Id pakpak sikandin diyon to krus!” ");
INSERT INTO oboNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Piru mid ikahi si Pilato kandan to, “Mambo? Ondan man kos saa no nopuungan din?” Na, id ayas pe-en id pehes iddos mgo minuvu no mid ungketen to, “Id pakpak en sikandin diyon to krus!” ");
INSERT INTO oboNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","To nokita ni Pilato no worad en koru-anon taddot osengan din diyot mgo minuvu woy od ko-ukag don nanoy sikandan, id angoy sikandin to oweg woy id ounab to bollad din diyot isowwan to mo-uraan minuvu. Kahi rin to, “Waa en lavut ku to kopotayan ka-ay'n minuvu! Koniyu ron no saa!” ");
INSERT INTO oboNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mid tavak iddos langun no minuvu to, “Oyya! Sikami woy dos mgo anak doy kos od sukutan taddot kandin no kopotayan!” ");
INSERT INTO oboNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Na id poleggua ni Pilato si Barabas, piru si Disas, id polompossan din, woy id boggoy rin diyot bollad to mgo sundau amoy id pakpak diyon to krus. ");
INSERT INTO oboNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na, id piyod to mgo sundau si Disas diyot baoy to gubernador woy nokolingkus kandin iddos langun no duma ran no mgo sundau. ");
INSERT INTO oboNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Id lusutan dan si Disas, woy id umpakan dan tod momoollutun umpak iling to umpak to hari. ");
INSERT INTO oboNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Id podlambed dan kos duhiyon no baahon, woy id bovallan dan idda no kuruna no id takos diyot uu ni Disas. Nopongnga, id posomad sikandin to bookayu riyot kowanan no bollad din no uvag kun to bastun to hari. Na mid lingko-od dan diyot isowwan din woy id sumpalit dan sikandin, kahi ran to, “Muopa no mowwet kos umuu ru, sikkow no Hari to mgo Judio!” ");
INSERT INTO oboNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na, id pon-ilobban dan sikandin woy id angoy ran iddos id somaddan din no bookayu, woy id pipit dan idda riyot uu rin. ");
INSERT INTO oboNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","To nopongnga ran mid sumpalit kandin, id lusut dan iddos od momoollutun umpak woy id posukub dan mandon iddos umpak din. Nopongnga, id piyod dan sikandin diyot leggua amoy id pakpak diyon to krus. ");
INSERT INTO oboNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","To id leggua ran don pomon diyot bonuwa, nosinuggung dan iddos minuvu no id ngoranan ki Simon no toho Cirene, woy id pohos dan sikandin nod tiyang taddot krus ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na, id inguma ran don diyot lugaa nod ngoranan to Golgota, (no iddos kohulugan, lugaa to Bongovongo). ");
INSERT INTO oboNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Id boggayan dan si Disas to binu no id sombutan to mopet no bawi nod pokotogka to mosakit. Piru to id geddaman din idda, mid elle sikandin nod inom tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Na id pakpak dan si Disas diyon to krus, woy id bunutbunut dan atag taddot ogget ni Disas ko ondan kos od kokomunoy to ipat sokkad kandan. ");
INSERT INTO oboNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nopongnga idda, mid unsad sikandan amoy'd tamong kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na riyot lomig datas to uu ni Disas, id tawwan dan to korotula, woy nokosulat dutun iddos saa nid uug dan kandin no mid ungketen to, “Ini en si Disas no Hari to mgo Judio.” ");
INSERT INTO oboNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na, duwon oruwon kriminal no id pakpak dan mandad diyon to krus no riyot tapad ibpit ni Disas. Iddos sokkad, diyon lomig to kowanan din woy dos sokkad, diyon lomig to ivang. ");
INSERT INTO oboNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na iddos mgo minuvu nid lihad dutun, id ponlingi-lingi ran woy id sumpalit dan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kahi ran to, “Tomman du, od gobban du iddos templo woy'd poohinaton du mandon daom da to otollun allow. Otik mooggot en iddos id oseng du, tovangiyu kos ko-ugolingun du! Woy otik mooggot ka en no Anak to Monama, ponog ka ruwot krus!” ");
INSERT INTO oboNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mid sumpalit mandad kandin iddos mgo ponguu to tohodbuwis, dos mgo tohodnonaw to Suhu ni Moises woy dos od pombuyyahon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kahi ran to, “Te, id tovangan din kos duma, piru dii man sikandin od pokotavang to ko-ugolingun din! Tomman din no Hari sikandin to Israel. Otid pokoponog sikandin duwot krus, od pomakoy ki kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Id salig man sikandin to Monama woy id ikahi rin pe-en no Anak sikandin to Monama. Na, od ontongngan ta ve-en kod tovangan sikandin to Monama!” ");
INSERT INTO oboNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ahad pe-en iddos mgo kriminal nid pakpak diyon to krus no duug din, iling dad en mandad tadda kos kodsumpalit dan kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na, to moko-untud don kos allow, tigkow id mosukirom kos intirut ingod daom to otollun uras. ");
INSERT INTO oboNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","To mgo alas tres don to mapun, id pehes si Disas to monokkaa no mid ungketen to, “Eli, Eli, lema sabactani?” no iddos kohulugan, “Monama ku, Monama ku, mambot id tonanan a nikkow?” ");
INSERT INTO oboNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","To norinog idda taddot dumon minuvu nod loohinat dutun, mid ikahi sikandan to, “Id umow rin si Elias!” ");
INSERT INTO oboNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sokkad kandan, id lungkossu woy mid angoy to immat bukoo nid aggom diyot suka, woy id takos din idda riyot ubpu to panga to kayu. Nopongnga, id bullow rin idda amoy id po-inom kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Piru mid ikahi iddos duma to, “Podtohona row sikandin. Od ongatan ta woy'd ontongngan ta kod loppow vo si Elias amoy'd tavang kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Na id pehes mandon si Disas to monokkaa, woy id salig din kos ispiritu rin diyot Monama. ");
INSERT INTO oboNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Idda ron en, iddos oray'n mokoppaan kurtina riyon to templo, novendas pomon diyot datas po-undiyot dosiyung. Na, id linug woy nongotobbag dos doorakkoon mgo batu. ");
INSERT INTO oboNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nopokes kos mgo lovongngan woy mo-uraan minuvu to Monama nid poomatoy no nongovadnow. ");
INSERT INTO oboNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Id leggua sikandan pomon diyot lovongngan. Woy to novadnow ron si Disas, iddos id poomatoy no nongovadnow, mid undiyot Jerusalem woy mo-uraan minuvu no nokokita kandan. ");
INSERT INTO oboNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na, iddos kopitan to mgo sundau woy dos mgo sakup din no id tamong ki Disas, nokorinog taddon linug woy nokita ran iddos mgo notomanan, woy oraroy ran no novaakkan. Kahi ran to, “Bonnaa vos en no Anak sikandin to Monama!” ");
INSERT INTO oboNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na, duwon mo-uraan ba-ay rutun no id pomantow riyot moriyu boyow. Sikandan iddos id dumoruma ki Disas pomon poron diyot Galilea, woy id tovangan dan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dos duma kandan, si Maria no toho Magdala, si Maria no inoy ni Santiago woy Jose woy dos sawa ni Sebedeo. ");
INSERT INTO oboNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","To od kosagkup don, id inguma iddos od koruwonnan no minuvu no id ngoranan ki Jose no toho Arimatea. Sokkad sikandin taddot od pondumoruma ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mid undiyon sikandin to ki Pilato amoy od buyuwon din nod ongayon iddos bangkoy ni Disas. Na, id aman si Pilato tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","De-en id angoy ni Jose iddon bangkoy, woy id bukusan din to lammi woy mahaa no ogget. ");
INSERT INTO oboNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Woy id ta-aw rin idda riyot langub no lovongngan no lammi rin id bongbangan atag to ko-ugolingun din. Na, id lokobban din idda to dakkoon batu woy mid ipanow sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Iddos mgo ba-ay no si Maria no toho Magdala woy dos sokkad pa no Maria, id unsad dutun nid isau riyot lovongngan. ");
INSERT INTO oboNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","To so-op no allow no idda en kos Allow't Kod-imolloy, mid undiyot ki Pilato iddos mgo ponguu to tohodbuwis woy dos mgo Pariseo. ");
INSERT INTO oboNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kahi ran to, “Sir, nosompottan doy no iddot no-uyag pa iddos bouhuson no minuvu, mid ikahi sikandin no od kovadnow kun sikandin otid lihad kos iko-otollun allow. ");
INSERT INTO oboNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","De-en iyon ayu moppiya no od suhu ka to minuvu nod potomongngon tat lovongngan din taman to otollun allow, su saddook od undiyon iddos mgo tinodduwan din amoy'd takow taddot bangkoy rin woy'd osengon dan no novadnow ron sikandin. Ko ungketen kos od puungan dan, iddos kod-ouhus dan, od lampas pe-en taddot unna.” ");
INSERT INTO oboNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kahin Pilato kandan to, “Oyya, piyoddow kos mgo sundau woy ooyyari row tod tamong dos lovongngan.” ");
INSERT INTO oboNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","De-en id ipanow ran, woy id tawwan dan to patow dos batu riyot sobbangan to lovongngan amoy'd kosorollan ko duwon od lukat tadda. Nopongnga, id tuwos dan iddos mgo sundau amoy'd tamong tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na, to sollom poron oraroy to allow't Linggu nopongnga iddos Allow't Kod-imolloy, mid undiyon si Maria no toho Magdala woy dos sokkad pa no Maria amoy'd ontong taddot lovongngan. ");
INSERT INTO oboNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na tigkow duwon monokkaan linug, su id ponog iddos sokkad no ponolihan pomon diyot datas to langit. Id po-ibpit din iddos dakkoon batu woy mid unsad sikandin diyot ampow tadda. ");
INSERT INTO oboNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Iddos bonnong din, id sella iling to kilat woy dos umpak din, golid se-aa to koputiyoy. ");
INSERT INTO oboNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dos mgo tohodtamong dutun, id pongookoo to mattag allak dan woy novantang sikandan iling to minuvu nid patoy ron. ");
INSERT INTO oboNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na id osengan taddot ponolihan iddos oruwon ba-ay, kahi rin to, “Yo kow'd kovaakki! Nokosaddoo a nod nangkap kow ki Disas nid pakpak diyon to krus. ");
INSERT INTO oboNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Worad sikandin ka-ay, su id badnow ron iling taddot id ikahi rin dangan. Undini kow woy ontongngi row iddos id tawwan kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na, lukut kow woy ponudtuu row riyot mgo tinodduwan din no novadnow ron sikandin, woy id unna sikandin diyot Galilea woy rutun, od kokita ran sikandin. Yo kow'd kolingow taddot id ponudtuu ku koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","De-en id lukut dan id awa riyot lovongngan no nokodsambut kos id geddam dan, su novaakkan woy noponnu ran mandad to kahaan. Id lungkossu ran amoy'd ponudtuu taddot langun diyot mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Laggun tid lungkossu ran, tigkow ran notommu si Disas diyot daan woy mid ikahi sikandin to, “Od po-ingkon kow?” Na id porani ran ki Disas, mid lingko-od, id somad sikandan to pa-a rin woy id simba kandin. ");
INSERT INTO oboNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kahin Disas kandan to, “Yo kow'd kovaakki. Undiyon kow to mgo suwod ku woy ponudtuli row sikandan nod undiyon dan to Galilea, woy riyon koyd od pokitannoy.” ");
INSERT INTO oboNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Laggun to riyon pa to daan iddos mgo ba-ay, mid undiyon to bonuwa iddos dumon tohodtamong woy id ponudtuu ran diyot mgo ponguu to tohodbuwis iddos langun no notomanan. ");
INSERT INTO oboNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na iddon mgo ponguu, id lolivuung duma taddot od pombuyyahon to mgo Judio, woy nopuhawang dan nod boggayan to paandog iddos mgo sundau woy id puungan dan en idda. ");
INSERT INTO oboNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kahi ran to, “Ko-ilangan nod osengon dow riyot mgo minuvu no laggun to id tinuhon kow, id undiyon dos mgo tinodduwan ni Disas to tongngovulli woy id takow ran iddos bangkoy rin. ");
INSERT INTO oboNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na otid korinog to gubernador no nokotinuhon kow, yo kow'd kaaggow, su sikami ron kos od kotuig nod oseng kandin amoy konna kow'd komonnu.” ");
INSERT INTO oboNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","De-en id tanggap taddot mgo sundau iddos soopi woy id puungan dan iddos id suhu kandan. Taman ko-ungkay, ini en kos itulan no id poso-ob to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na iddos sopuu-sokkad no tinodduwan, mid undiyon to Galilea no riyot sokkad no buvungan, no idda en kos id oseng ni Disas nod tommuwan dan. ");
INSERT INTO oboNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","To nokita ran sikandin dutun, mid lingko-od dan amoy'd simba kandin, piru iddos duma kandan, duwon poron kodduworuwa. ");
INSERT INTO oboNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Na, id porani si Disas kandan woy mid ikahi to, “Id boggoy koddi kos langun no kotungud diyot datas to langit woy ka-ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","De-en undiyon kow to langun no minuvu riyot nokod-osso-osson ingod amoy'd kovovallan sikandan no mgo tinodduwan ku. Boutismu-i row sikandan diyot ngaran to Amoy, Anak woy Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Woy nonawwi row sikandan nod tuman to langun no id suhu ku koniyu. Pomuwa row riyot poomdom dow, no inaayun a od duma koniyu taman to kotompusan to ingod.”");
INSERT INTO oboNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Na, ini en kos tigkonayan to Moppiyon Dinoggan moka-atag ki Disas Krays no Anak to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","No-ikahi riyot id posulat to Monama ki propeta Isaias no, “Id popiyod ku kos koddin tohodponudtuu nod unna kikow amoy od panoy to kod-inguma ru.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Oyyos duwon monokkaan bawos diyot noka-awoy-awoy'n lugaa no mid ungketen to, “ ‘Ponaya row kos pusung dow atag tod Longaggon, woy tulidda row kos od ukitan din!’ ” ");
INSERT INTO oboNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Notuman en idda, su id inguma si Juan no Tohodboutismu no riyon id oubpa to noka-awoy-awoy'n lugaa. Id nonaw sikandin to mgo minuvu, kahi rin to, “Sondit kow woy tanan kowd to mgo saa row woy poboutismu kow amoy'd posinsyan kow to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na, mid undiyot kandin iddos mgo minuvu no id pomon diyon to intirut prubinsya to Judea woy pomon diyot bonuwa to Jerusalem. Id ponudtuu ran iddos mgo saa ran, woy id poboutismu ran ki Juan diyot Oweg to Jordan. ");
INSERT INTO oboNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Iddos umpak ni Juan, binovallan pomot bowvuu to kamelyo woy dos ollon din, binovallan pomot kindaa to oyama. Iyon koka-an din, mgo apang woy tonnob. ");
INSERT INTO oboNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na id posaddoo si Juan diyot mgo minuvu, kahi rin to, “Duwon od tundug koddi no lampas pa koddi, su konna a ollog ahad kod-akas da en to sandalyas din. ");
INSERT INTO oboNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Od boutismuwan ku sikiyu to oweg, piru sikandin, Uhis no Ispiritu kos id boutismu rin koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na riyot timpu to kodboutismu ni Juan, mid inguma si Disas pomon diyot bonuwa to Nazaret no sakup to prubinsya to Galilea, woy id boutismuwan sikandin ni Juan diyot Oweg to Jordan. ");
INSERT INTO oboNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","To id go-un don si Disas diyot oweg, idda ron en, nokita rin no nopokes kos langit woy id lonna iddos Uhis no Ispiritu riyot kandin iling to soopati. ");
INSERT INTO oboNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na, duwon bawos pomon diyot datas to langit no mid ungketen to, “Sikkow en kos Anak ku no id dokollan ku to ginawa woy oraroy a no nahaa kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","To nopongnga boutismu-i si Disas, idda ron en, id po-undiyon sikandin to Uhis no Ispiritu to noka-awoy-awoy'n lugaa. ");
INSERT INTO oboNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Na, daom to oppat-no-puun allow, id ubpa sikandin diyot noka-awoy-awoy'n lugaa no riyon en iddos mgo monnanap to puwaason, woy id geddaman sikandin ni Moivuyan. Piru mid undiyot ki Disas iddos mgo ponolihan amoy'd tuhanuu kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na, to noprisu si Juan, id livod si Disas diyot Galilea amoy'd ponudtuu to Moppiyon Dinoggan to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kahi rin to, “Ini ron en kos timpu no id ponudtuu to mgo propeta dangan, oyyos asow ron kos kodharit Monama. Sondit kow woy tanan kowd to mgo saa row, woy pomokaya row kos Moppiyon Dinoggan.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sokkad no allow, laggun tid ipanow si Disas diyot ibpit to Lanow't Galilea, nokita rin iddos oruwon toosuwod no si Simon woy si Andres. Id ooppan dan to pukut, su mgo tohodngongaap me-en sikandan. ");
INSERT INTO oboNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kahin Disas kandan to, “Duma kow koddi. Konnad ngaap kos od ingutollon dow, ko konna, od nonawwan ku sikiyu nod ingutoo to mgo minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Idda ron en, id tonanan dan iddos mgo pukut woy id duma ran kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Na, ponayun mid ipanow si Disas diyot ko-unnan boyow, woy nokita rin iddos oruwa mandad no toosuwod no si Santiago woy si Juan no mgo anak ni Sebedeo. Id ounsad sikandan diyot bollangay no id oupiya to mgo pukut. ");
INSERT INTO oboNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Idda ron en, id umow sikandan ni Disas no od duma kandin. Na, id tonanan dan iddos amoy ran no si Sebedeo riyon to bollangay duma taddot mgo minuvu no id popuung dan, woy mid duma ran mandad ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Na, id undiyon onsi Disas to bonuwa to Capernaum. Woy riyon to Allow't Kod-imolloy, id usok si Disas diyot simba-an to mgo Judio woy mid nonaw to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nosoobbuwan dan taddot kodnonaw rin su duwon en kotungud, konna iling taddot mgo tohodnonaw to Suhu ni Moises. ");
INSERT INTO oboNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na riyot simba-an to mgo Judio, duwon sokkad no minuvu no id losuran to busow woy id pomehes, kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Disas no toho Nazaret, ondak lavut du konami? Id undini ka vo amoy'd silutan koy nikkow? Id kilaa a kikow, su sikkow en kos Uhis no Anak to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Na id sugga ni Disas iddos busow, kahi rin to, “Po-onong-onong ka! Leggua kad kandin!” ");
INSERT INTO oboNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Idda ron en, id pokookoo to busow iddon minuvu, woy ayas mid pomehes to waa pa sikandin id leggua riyot minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nosoobbuwan iddos langun no minuvu woy id po-ikohiyoy ran to, “Eh, ondan man ini? Lammi inin nonaw, su duwon kotungud din nod sugga to mgo busow woy id leggua en!” ");
INSERT INTO oboNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pomon tadda, go-os nokoso-ob iddos moka-atag ki Disas diyot mgo lugaa no nokolingkus to intirut prubinsya to Galilea. ");
INSERT INTO oboNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Na, to id leggua onsi Disas diyot simba-an to mgo Judio, mid undiyon sikandin to baoy onni Simon woy Andres, duma ongki Santiago woy Juan. ");
INSERT INTO oboNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Dutun, iddos ba-ay no onuhang ni Simon, id oilogga su id momonit. To mid inguma ron si Disas, id ponudtulan sikandin to mgo minuvu atag taddot novohokan. ");
INSERT INTO oboNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","De-en id poroniyan ni Disas iddos novohokan, woy id somaddan din kos bollad woy id po-onnow rin. Na idda ron en, no-uliyan sikandin woy id sondad kandan to koka-an. ");
INSERT INTO oboNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","To od kosagkup don, id piyod to mgo minuvu riyot ki Disas iddos langun nod kovohokan woy dos id ponlosuran to busow. ");
INSERT INTO oboNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Langun to mgo minuvu riyot bonuwa, nolivuung diyot lama to baoy. ");
INSERT INTO oboNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na, no-uliyan ni Disas iddos mo-uraan minuvu no duwon nokod-osso-osson bohok, woy id poleggua rin iddos mo-uraan busow, woy waa po-osenga ni Disas iddos mgo busow, su nokokilaa ran man ko ondoy sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mosukirom poron, mid onnow si Disas woy id undiyon to noka-awoy-awoy'n lugaa amoy od dasaa rutun. ");
INSERT INTO oboNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na, id nonangkap kandin onsi Simon. ");
INSERT INTO oboNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","To nokita ran don sikandin, mid ikahi ran to, “Od nongkapon ka to langun no minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Piru kahin Disas kandan to, “Od undiyon ki pa to dumon bonuwa no morani ka-ay, su amoy id pokoponudtuu ku mandad kandan iddos Moppiyon Dinoggan oyyos ini en kos dontulon to kod-undini ku.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","De-en id lingkus ni Disas iddos langun no bonuwa riyon to Galilea. Id ponudtuu rin kos kahit Monama riyot mgo simba-an to Judio, woy id poleggua rin iddos mgo busow no id lasud diyot mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na, duwon sokkad no minuvu no duwon bohok no et-et no id porani ki Disas. Mid lingko-od sikandin diyot isowwan din woy id po-eru-eru, kahi rin to, “Nokosaddoo a nod poko-uli ka ka-ay't molibmit no bohok ku otik id kopi-i ru.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Pomon to oray'n no-eruwan si Disas kandin, id somaddan din iddos minuvu woy id ikohiyan din to, “Oyya, id kopi-i ku en. Na od ko-uliyan kad.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Idda ron en, worad iddos et-et din woy no-uliyan don sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","To waa pa po-iponawa ni Disas iddos minuvu, id loglohottan din sikandin, kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Yo ru vo ponudtuu ini riyot ahad ondoy, ko konna, undiyon ka to tohodbuwis amoy'd ontongngan din kos lawa ru. Woy boggoy ka to buwis no id suhu ni Moises amoy'd posivonnaa riyot mgo minuvu no no-uliyan kad.” ");
INSERT INTO oboNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Piru mid ipanow iddos minuvu woy id posaddoo rin iddos langun no pinuungan ni Disas, de-en nokoso-ob iddos dinoggan. Na pomon tadda, dii ron od poko-undiyon si Disas to dumon bonuwa, su otid kokita sikandin to mgo minuvu, od livuungan en sikandin. Purisu diyon da sikandin id oubpa to noka-awoy-awoy'n lugaa, piru id pon-undiyon dad en to kandin iddos mgo minuvu no pomon diyot nokod-osso-osson lugaa. ");
INSERT INTO oboNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Na, to id lihad kos pilon allow, id livod mandon si Disas diyot bonuwa to Capernaum, woy nokoso-ob kos dinoggan no id uli ron sikandin diyot baoy. ");
INSERT INTO oboNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","De-en mo-uraan minuvu no id lolivuung dutun woy pomon tadda, worad lugaa nod ko-usokkan, ahad pa riyot sobbangan. Woy id ponudtuu ni Disas kandan iddos kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Na, duwon oppat no minuvu nid inguma no id sayung to minuvu nid patoy kos lawa. ");
INSERT INTO oboNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Piru pomon to mo-uraan minuvu riyot daom, waa ran nokoporani ki Disas. De-en id akas dan iddos atop no riyot pantok ni Disas. Nopongnga idda, id tuntun dan don iddos minuvu nid patoy kos lawa no id ilogga riyot ikam. ");
INSERT INTO oboNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","To nokita ni Disas no dakkoo kos kodsalig dan, id ikohiyan din iddos minuvu to, “Suwod, id posinsyan don kos mgo saa ru.” ");
INSERT INTO oboNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na, duwon mgo tohodnonaw to Suhu ni Moises no id ounsad dutun. To norinog dan iddos id ikahi ni Disas, kohingginawa ran to, ");
INSERT INTO oboNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Te, mambo moho tod ikahi ikon minuvu to iling duwon? Id sumpalit din kos Monama, oyyos waa en minuvu nod pokoposinsya to saa, ko konna, idda ra en so Monama!” ");
INSERT INTO oboNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Piru nosorollan ni Disas kos diyot poomdom dan, de-en id ikohiyan din sikandan to, “Mambot ungketen kos poomdom dow? ");
INSERT INTO oboNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ingkon man musing kos moomok nod osengon atag ka-ay't minuvu no id patoy kos lawa? Idda vo so od ikahi no, ‘Id posinsyan don kos mgo saa ru,’ o iddos od ikahi no, ‘Lohinat ka, piyoddow kos ikam du woy ipanow ka’? ");
INSERT INTO oboNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Piru id pokita ku koniyu no siyak no Anak to Minuvu, duwon kotungud ka-ay to ampow't ingod no od posinsya to mgo saa.” Na id isau si Disas diyot mama no id patoy kos lawa, woy mid ikahi sikandin to, ");
INSERT INTO oboNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Lohinat ka woy piyoddow kos ikam du, woy uli kad bo.” ");
INSERT INTO oboNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Idda ron en, id lohinat sikandin nid piyod to ikam din woy id baya riyot isowwan to mgo minuvu. Na, nosoobbuwan dan woy id doong dan kos Monama, kahi ran to, “Pomon poron, ini ki pe-en nokokita to iling ka-ay'n notomanan!” ");
INSERT INTO oboNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nopongnga idda, mid livod mandon si Disas diyot ibpit to Lanow't Galilea, woy id nonaw sikandin taddot mo-uraan minuvu nid lolivuung no id undiyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Todtahad, id ipanow ron mandon sikandin, woy nokita rin si Levi no anak ni Alfeo no mid unsad diyot od boovoyaran to buhis. Kahin Disas kandin to, “Duma ka koddi.” De-en mid lohinat si Levi woy id duma kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sokkad no allow, id ka-an si Disas woy dos mgo tinodduwan din diyot baoy ni Levi. Duwon mandad mo-uraan tohodsukut to buhis woy duma pon mosaasaa no id ka-an duma ongki Disas, su mo-uraa kos id dumoruma kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na rutun, duwon mgo tohodnonaw to Suhu ni Moises no sakup to mgo Pariseo. To nokita ran no id ka-an si Disas duma to mgo mosaasaa woy taddot mgo tohodsukut to buhis, id ikahi ran diyot mgo tinodduwan din to, “Mambo moho tid lommung sikandin nid ka-an duwot mgo tohodsukut to buhis woy dumon mosaasaa?” ");
INSERT INTO oboNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","To norinog ni Disas idda, id tavak din sikandan ukit to ponunggelengan, kahi rin to, “Iddos mgo minuvu no waa bohok, konna od ko-ilangan to doktor, ko konna, idda ra en so duwon bohok. Na iling mandad tadda, waa a mid undini amoy'd nangkap to mgo motallong, ko konna, idda en so mgo mosaasaa.” ");
INSERT INTO oboNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Sokkad no timpu, id puasa iddos mgo tinodduwan ni Juan no Tohodboutismu woy dos mgo Pariseo. Na, duwon mgo minuvu no id porani ki Disas woy mid intud, kahi ran to, “Iddos mgo tinodduwan ni Juan no Tohodboutismu woy dos mgo Pariseo, duwon timpu nod puasa ran. Piru mambot ikos mgo tinodduwan du, dii man od puasa?” ");
INSERT INTO oboNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mid tavak si Disas to, “Otik duwon kosaa, od puasa vo iddos korumannan taddot lammid osawa laggun to duma ran pa sikandin? Dii en! Na ungketen dad en mandad kos mgo tinodduwan ku, konna pa sikandan od puasa laggun to duma a pa nikandan. ");
INSERT INTO oboNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Piru od inguma en kos timpu nod puasa ran otid ongayon don pomon diyot kandan iddos id osawa.” ");
INSERT INTO oboNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Na, duwon mandon ponunggelengan ni Disas, kahi rin to, “Waa minuvu nod tapong to lammin ogget diyot tapoy'n umpak. Oyya su otid pippiyan don idda, od kipos dos ogget nid tapong woy od lowwag pe-en kos bendas. ");
INSERT INTO oboNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Iling mandad tadda, waa minuvu no od ta-aw to lammin binu nod bovuwak poron diyot tapoy'n tootawwan no binovallan pomot kindaa to oyama, su otid puungan din idda, od kovendas iddon tawwan. Na od korattan da en iddos od tootawwan, woy od ko-uwakkan dos binu. Purisu ko-ilangan no iddos lammin binu, diyon en mandad id ta-aw to lammin tootawwan.” ");
INSERT INTO oboNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sokkad no timpu to Allow't Kod-imolloy, nokovaya si Disas woy dos mgo tinodduwan din diyot kamot no duwon pinomuwon trigu. Laggun tid ipanow ran, id pomadti iddos mgo tinodduwan din to mgo trigu, id kusukusu ran idda woy id sungit. ");
INSERT INTO oboNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","To nokita idda to mgo Pariseo, id ikahi ran ki Disas to, “Mambot id puungan to mgo tinodduwan du iddos id diiyan diyon to Allow't Kod-imolloy?” ");
INSERT INTO oboNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Mid tavak si Disas to, “Waa kow vo nokovasa taddot id puungan ni Harin David woy taddot mgo duma rin iddot timpu no id gutasan sikandan? ");
INSERT INTO oboNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Id usok sikandin diyon to baoy't Monama, woy id ka-an din iddos paan no id buwis diyot Monama woy id boggayan din mandad iddos mgo duma rin. Iddon paan, id diiyan nod kannon to ahad ondoy, su iyon da od pokoka-an tadda, iddos mgo tohodbuwis. Notomanan idda timpu no si Abiator kos mowwet no ponguu to mgo tohodbuwis.” ");
INSERT INTO oboNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Na kahin Disas diyot mgo Pariseo to, “Id bovallan to Monama kos Allow't Kod-imolloy atag to kopiyannan to mgo minuvu. Waa rin bovalli kos mgo minuvu atag to Allow't Kod-imolloy. ");
INSERT INTO oboNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","De-en siyak no Anak to Minuvu kos duwon kotungud ko ondan kos od puungan ahad diyon to Allow't Kod-imolloy.” ");
INSERT INTO oboNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na, mid livod mandon si Disas diyot simba-an to mgo Judio. Diyot daom, duwon sokkad no minuvu no id patoy kos divauy'n bollad. ");
INSERT INTO oboNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Woy duwon mandad mgo minuvu no od nangkap to po-unayan amoy'd ko-uug dan si Disas no nokopuung to saa. De-en id ponulan dan sikandin kod bowiyan din iddos minuvu riyon to Allow't Kod-imolloy. ");
INSERT INTO oboNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Na, id osengan ni Disas iddos minuvu no id patoy kos bollad, kahi rin to, “Lohinat ka rinit isowwan to langun.” ");
INSERT INTO oboNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Id inturan ni Disas iddos mgo minuvu rutun, kahi rin to, “Ingkon musing ka-ay kos noko-ikuu to mgo Suhu ni Moises diyon to Allow't Kod-imolloy? Idda vo so kodpuung to moppiya o iddos kodpuung to morat? Idda vo so kodtavang to minuvu o iddos kod-imatoy?” Piru id po-onong-onong da en sikandan. ");
INSERT INTO oboNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nolingasa si Disas nid tongtong taddot mgo minuvu no nokolingkus kandin, woy naanu sikandin pomon to motoggas kos pusung dan. Na id osengan din iddos minuvu no id patoy kos bollad, kahi rin to, “Kotongngow kos bollad du.” Na id kottong din idda, woy idda ron en, no-uliyan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nopongnga idda, id leggua iddos mgo Pariseo woy id polivuungoy ran duma to mgo sakup ni Herodes amoy'd nangkap to po-ukit to kod-imatoy ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Na, mid undiyon si Disas to ibpit to Lanow't Galilea duma iddos mgo tinodduwan din. Id tinundug kandin iddos mo-uraan minuvu no id pomon diyot Galilea, woy duwon mandad duma no id pomon diyot Judea. ");
INSERT INTO oboNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Duwon mandad id pomon diyot Jerusalem, diyot Edumea, diyot dipaa to Oweg to Jordan woy id pomon diyot mgo lugaa no sumbaoy to bonuwa to Tiro woy Sidon. Mid undiyon dan to ki Disas, su nokorinog dan to langun no mokososoobbun pinuungan din. ");
INSERT INTO oboNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na pomon to mo-uraa kos minuvu, id suhu ni Disas iddos mgo tinodduwan din no od panoy to bollangay nod sokayan din amoy dii sikandin od kolipit to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pomon to mo-uraan novohokan kos no-uliyan din, de-en od po-ohawoy iddos dumon od pongkovohokan amoy'd porani ki Disas, su amoy od pokosomad dan kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na iddos id ponlosuran to busow, otid pokokita sikandan ki Disas, od ponlaangkob dan diyot isowwan din, woy od popeheson sikandan taddot mgo busow nod ungketen to, “Sikkow en kos Anak to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Piru id loglohottan ni Disas tid sugga iddos mgo busow, no konna ran id ponudtuu to mgo minuvu ko ondoy sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nopongnga idda, mid tikoddog si Disas diyot buvungan, woy id umow rin iddos id kopi-i rin nod dumannon, de-en id porani sikandan. ");
INSERT INTO oboNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na, mid aam sikandin to sopuu-oruwon tinodduwan no id ngoranan din no mgo apostoles. Kahi rin kandan to, “Id aam ku sikiyu nod dumoruma koddi, woy id popiyod ku sikiyu amoy'd ponudtuu to kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Woy od boggayan ku sikiyu to kotungud to kodpoleggua to mgo busow.” ");
INSERT INTO oboNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na, ini en kos mgo ngaran to sopuu-oruwa no id aam ni Disas. Si Simon no id ngoranan din ki Pedro, ");
INSERT INTO oboNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Santiago woy dos ari rin no si Juan no id ngoranan sikandan ni Disas to Boanerges, no iddos kohulugan, baansi. Sikandan, mgo anak ni Sebedeo. ");
INSERT INTO oboNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Dos duma si Andres, si Felipe, si Bartolome, si Mateo, si Tomas, si Santiago no anak ni Alfeo, si Tadeo, si Simon no mohingginawa to ingod din ");
INSERT INTO oboNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","woy si Judas Iscariote nod boligya ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na, to id uli ron si Disas woy dos mgo tinodduwan din, nolivuung mandon iddos mo-uraan minuvu riyot kandin. De-en waa ran nokosakat nid ka-an. ");
INSERT INTO oboNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","To norinog idda to mgo korumannan din, id undiyonnan dan sikandin amoy'd ongayon dan nanoy, oyyos duwon id ikahi no od busawon don kun sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na, duwon mgo tohodnonaw to Suhu ni Moises no id pomon diyot Jerusalem no mid ikahi to, “Si Disas, id losuran ni Moivuyan no ponguu to mgo busow. De-en od pokopoleggua sikandin to mgo busow.” ");
INSERT INTO oboNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","To norinog idda ni Disas, id poporani rin iddos mgo minuvu woy id osengan din sikandan ukit to mgo ponunggelengan, kahi rin to, “Mambot od po-owan ni Moivuyan iddos kandin da en no mgo sakup? ");
INSERT INTO oboNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Otik duwon mgo sakup to sokkad no kohoriyan nod po-unayoy od povunuwoy, konnod kouhoy, od kohobba en iddon kohoriyan. ");
INSERT INTO oboNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ungketen dad en mandad kos od kotomanan taddot mgo sakup to sokkad no pomilya. Otid po-unayoy sikandan od po-imotayoy, od pokodsuwoysuwoy en sikandan. ");
INSERT INTO oboNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ungketen dad en mandad kos kohoriyan ni Moivuyan. Otid po-unayoy od po-imotayoy iddos kandin da en no sakup, konnod kouhoy, od kohobba en iddos kohoriyan din woy'd kotaman. ");
INSERT INTO oboNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Piru notalu kud si Moivuyan, oyya su id poleggua kud iddos mgo busow no mgo sakup din. Waa minuvu nod poko-usok diyot baoy to monokkaan minuvu amoy'd ahaw to mgo korotuwan din, otik konna pa unna od bokuwon iddos monokkaan minuvu, idda pa od ka-ahaw rin idda. ");
INSERT INTO oboNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Bonnaavonnaa nod ikohiyon ku koniyu, no ahad ondan no saa nod kopuungan to mgo minuvu, od koposinsyan pa to Monama, ahad iddos kodsumpalit dan kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Piru iddos ahad ondoy nod sumpalit to Uhis no Ispiritu, konna en od koposinsyan. Oyya su iddos saa rin, konnad en od ka-awa riyot kandin taman to waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Na id oseng ni Disas ini, su duwon id ikahi no iddos kotuusan din, id pomon to busow nid lasud kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na, mid inguma iddos inoy woy mgo suwod ni Disas. Id aangat sikandan diyot lama, woy id po-umow ran sikandin su duwon od osengon dan. ");
INSERT INTO oboNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Diyot daom, duwon mo-uraan minuvu nid ounsad no nokolingkus kandin. Na, duwon mid ikahi kandin to, “Sir, iddos inoy ru woy mgo suwod du, id aangat diyot leggua su duwon kun od osengon dan kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mid ikahi sikandin to, “Oyya, piru id pokita ku koniyu ko ondoy kos inoy woy mgo suwod ku.” ");
INSERT INTO oboNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Na, id tongtong sikandin diyot mgo minuvu no nokolingkus kandin, woy kahi rin to, “Ini en no mgo minuvu kos inoy ku woy mgo suwod ku. ");
INSERT INTO oboNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Su iddos ahad ondoy nod tuman to id kopi-it Monama, sikandan en kos inoy ku, mgo tobboy woy mgo suwod ku.” ");
INSERT INTO oboNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sokkad no allow, id nonaw mandon si Disas to mgo minuvu riyot ibpit to Lanow't Galilea. Pomon to oray'n mo-uraan minuvu no id lolivuung diyot kandin, mid unsad sikandin diyot bollangay amoy'd nonaw. Iddos mgo minuvu no riyot ibpit to lanow, id pominog kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na, mo-uraa kos id nonaw rin kandan ukit to ponunggelengan. Kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ooyyari row tod pominog ini. Duwon sokkad no minuvu nid undiyon to kamot amoy'd savud to bonni. ");
INSERT INTO oboNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na riyot kodsavud din, duwon mgo bonni no nongo-uug diyot daan woy id ponuktuk idda to mgo manuk nod layanglayang. ");
INSERT INTO oboNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Dos duma, nongo-uug diyot botuwon. Pomon to movavow ra man kos livuta, go-os da idda id tuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Piru to moko-untud don kos allow, naanos idda, woy pomon to waa goli nokodoralig, nahangu ron. ");
INSERT INTO oboNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dos duma, nongo-uug diyot sopiniton. To id tuvu dos mgo sopinit, nokubmutan don iddos lammid tuvu, de-en worad idda nokobovunga. ");
INSERT INTO oboNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Piru iddos dumon bonni, nongo-uug diyot moppiyon livuta. Na, moppiya kos tuvu tadda woy id bovunga. Dos duma, ollog-ollog da kos bunga, dos duma mandad, dakkoo woy dos duma, oray'n dakkoo.” ");
INSERT INTO oboNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na kahin Disas to, “Sikiyu, su duwon man tolinga row, pa-ayyad kow pominog.” ");
INSERT INTO oboNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","To id awa ron iddos mgo minuvu, id porani kandin iddos sopuu-oruwon tinodduwan din woy dos dumon minuvu, woy mid intud dan kandin moka-atag to mgo ponunggelengan. ");
INSERT INTO oboNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kahin Disas to, “Sikiyu, id boggayan kowd to Monama to koovottan taddot waa rin pa id posaddoo dangan moka-atag to kodhari rin. Piru riyot dumon minuvu, id nonaw ku kandan iddos langun no kovonnaan ukit to ponunggelengan, ");
INSERT INTO oboNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","su amoy ahad od totongtong dan, dii ran od pokokita woy ahad od pominog dan, dii ran od pokaabbot. Su otid pokaabbot dan, od sondit woy'd tanan sikandan to mgo saa ran, woy od posinsyan sikandan to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na mid ikahi mandon si Disas to, “Waa kow pobbos nokaabbot taddot ponunggelengan? Otik dii kow od pokaabbot ka-ay, momonnu kow vo od pokaabbot to duma pon ponunggelengan ku? ");
INSERT INTO oboNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ini kos kohulugan taddot ponunggelengan. Dos bonni no id savud, idda en so kahit Monama no id nonaw riyot mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Na iddos daan no no-uuhan to bonni, idda en so mgo minuvu no nokorinog to kahit Monama, piru idda ron en, id ahaw ni Moivuyan iddos kahi no nokopomuwa riyot pusung dan. ");
INSERT INTO oboNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na iddos botuwon no no-uuhan to bonni, idda en so nokorinog to kahit Monama woy idda ron en, nahaa ran to kodtanggap tadda. ");
INSERT INTO oboNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Piru waa goli idda nokodoralig diyot pusung dan, woy sinsinahaw ra kos kopomakoy ran. Oyya su otid inguma kos kosupittan pomon to kodtanggap dan to kahit Monama, konnad sikandan od ponayun. ");
INSERT INTO oboNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Dos sopiniton no no-uuhan to bonni, idda en so nokorinog to kahit Monama, ");
INSERT INTO oboNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","piru inaayun dan od popoomdom to mgo sowkuu to ko-ubpa ran, dos kodginawa to soopi woy od kolewang dan to mgo ingowollon to ko-ubpa ran. De-en iling to id kubmutan iddos kahi no norinog dan woy waa nokovunga. ");
INSERT INTO oboNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na iddos moppiyon livuta no no-uuhan to bonni, idda en so mgo minuvu no nokorinog to kahit Monama woy id tanggap dan idda, woy moppiya kos bunga tadda riyot ko-ubpa ran. Dos duma, ollog-ollog da kos bunga to kopomakoy ran, dos duma mandad, dakkoo woy dos duma pa, oray'n dakkoo.” ");
INSERT INTO oboNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na, duwon mandon ponunggelengan ni Disas. Kahi rin to, “Waa minuvu nod loottom to suu no od poongkobban to lobban o id ta-aw rin diyot silob to katri, ko konna, id ta-aw rin idda riyot od sopatan. ");
INSERT INTO oboNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iling mandad tadda, iddos, iddos ahad ondan no noko-ollos woy diid koovottan ko-ungkay, od kosorollan woy'd koovottan en diyot mori. ");
INSERT INTO oboNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","De-en su duwon man mgo tolinga row, pa-ayyad kow pominog.” ");
INSERT INTO oboNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na mid ikahi mandon si Disas to, “Pa-ayyad kow pominog, su otik ungketen, oraroy kow od pokaabbot, woy od duhangan pe-en to Monama kos koovottan dow. ");
INSERT INTO oboNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Su iddos minuvu no nokaabbot to norinog din, od duhangan pe-en kos koovottan din. Piru iddos waa id pa-ayyad id pominog, od ongayon pe-en ahad iddos disok no koovottan din.” ");
INSERT INTO oboNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na ponayun mid ikahi si Disas to, “Iddos kodharit Monama, iling ka-ay. Duwon sokkad no minuvu no id savud to bonni riyot kamot din. ");
INSERT INTO oboNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Laggun tid ponayun sikandin to ipat allow no pinuungan din, woy riyot od tinuhon don sikandin to bulli, id tuvu iddos bonni no waa rin nosorolli kos po-ukit to kodtuvu tadda. ");
INSERT INTO oboNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Dos livuta kos od potuvu woy od povunga to pinomuwa. Diyot unna, od tuvu iddos lawa, so-op tadda, od movoddos woy kopongnga, od bovunga ron. ");
INSERT INTO oboNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Otid koutuwan don idda, od gaavon don su tingkottu ron man.” ");
INSERT INTO oboNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Na ponayun mid ikahi si Disas to, “Ondan man kos od ko-ilingan to kodharit Monama? Ondan man kos od koponunggelengan ka-ay? ");
INSERT INTO oboNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Noko-iling idda to sokkad no bonni to mustasa no id pomuwa ron diyot kamot. Oray'n disok ini to langun no bonni ka-ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Piru otik id pomuwa ron ini woy od tuvu, mowwet pa ini to dumon mgo pinomuwa. Od lapung kos panga ka-ay woy riyot mallung, od sosaag kos mgo manuk nod layanglayang.” ");
INSERT INTO oboNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na, iddos kodnonaw ni Disas to kahit Monama riyot mgo minuvu, id po-ukit din to mgo ponunggelengan, woy idda ra en so od koovottan dan kos id nonaw rin. ");
INSERT INTO oboNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Waa sikandin id nonaw kandan no konna po-ukit to mgo ponunggelengan. Piru ko idda ra en so mgo tinodduwan din kos duma rin, id paabbotlabbot din kandan iddos langun no kohulugan tadda. ");
INSERT INTO oboNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na, to od kosagkup don to idda ra en no allow, mid ikahi si Disas diyot mgo tinodduwan din to, “Od undiyon ki to dipaat lanow.” ");
INSERT INTO oboNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","De-en id tanan onsi Disas pomon diyot mo-uraan minuvu, woy id sakoy iddos mgo tinodduwan din taddot bollangay no riyon en mid unsad si Disas. Id undiyon dan to dipaa duma iddos dumon id pomollangay. ");
INSERT INTO oboNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na, tigkow mid doppot kos monokkaan kaamag woy nosuhat to doorakkoon mgo baud iddos bollangay. De-en od koponnu ron asow to oweg. ");
INSERT INTO oboNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Piru si Disas no riyon lomig to ubpu to bollangay, nokotintinuhon diyot uunan. Id sukaa ran sikandin, kahi ran to, “Tohodnonaw, tovangi koy! Od koonnod kid man moho ini!” ");
INSERT INTO oboNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na, id onnow si Disas woy id sugga rin iddos kaamag woy id ikohiyan din iddos mgo baud to, “Soro kad! Tivonok kowd!” Idda ron en, id soro iddos kaamag woy id tivonok kos langun. ");
INSERT INTO oboNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kahin Disas kandan to, “Mambot novaakkan kow? Waa pobbos kodsalig dow koddi?” ");
INSERT INTO oboNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na, oraroy ran no nosoobbuwan woy id po-inturoy ran to, “Ondoy moho inin minuvu no ahad iddos kaamag woy mgo baud, id dumoruma kandin?” ");
INSERT INTO oboNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na, id dunggu onsi Disas diyot dipaa to Lanow't Galilea, riyot lugaa to mgo toho Gerasa. ");
INSERT INTO oboNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","To id ponog si Disas taddon bollangay, duwon minuvu no id sinuggung kandin pomon diyot lovongngan. ");
INSERT INTO oboNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Inin minuvu, id losuran to mgo busow, woy riyon sikandin id oubpa to mgo lovongngan. Ahad pa od bokuwon sikandin to kodina, konna en od kotoholan. ");
INSERT INTO oboNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Na, komo-uraa ron sikandin bokuwa to mgo kodina woy id pasung kos pa-a rin woy bollad din, piru id ponbudtus din iddos mgo kodina woy id pondorattan din iddos pasung. Waa en minuvu nod pokotohoo kandin su oray'n monokkaa. ");
INSERT INTO oboNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allow bulli, od livonglivong sikandin diyot lovongngan woy riyot buvunganon no laayun od pomehes, woy id ponpoliyan din kos lawa rin to mgo batu. ");
INSERT INTO oboNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","To nopantow rin si Disas, mid sinuggung sikandin nid lungkossu. Woy riyot kod-inguma rin, id lingko-od sikandin diyot isowwan ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Na id pehes sikandin no mid ungketen to, “Disas, Anak to Monama no Lampas to Langun, ondak lavut du koddi? Kolimulimu, pongulivot ka riyot ngaran to Monama no konna a nikkow od silutan!” ");
INSERT INTO oboNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Id oseng din idda, su id ikohiyan don man ni Disas iddos busow to, “Sikkow no busow, leggua ka ka-ay'n minuvu!”) ");
INSERT INTO oboNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Na id inturan sikandin ni Disas, kahi rin to, “Ondoy kos ngaran du?” Mid tavak iddos busow to, “Maanmaan kos ngaran ku, su mo-uraa koy.” ");
INSERT INTO oboNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ayas id po-eru-eru ki Disas iddos mgo busow no konna rin sikandan od po-owan taddon ingod. ");
INSERT INTO oboNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na riyot londig no morani rutun, duwon mo-uraan bavuy nid ponuwaa. ");
INSERT INTO oboNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Id po-eru-eru ki Disas iddos mgo busow, kahi ran to, “Po-olina koy nod lasud duwot mgo bavuy.” ");
INSERT INTO oboNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","De-en id aman si Disas. Na id ponleggua iddos mgo busow, woy id losuran dan dos mgo bavuy no iddos ko-uralloy tadda, mgo oruwon maan (2,000). Idda ron en, id pouharus diyot daama iddos mgo bavuy woy nongo-uug diyot lanow woy nongoonnod. ");
INSERT INTO oboNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","To nokita idda taddot mgo tohodtamong to mgo bavuy, id lungkossu ran woy id ponudtuu ran iddos notomanan diyot langun no id ubpa riyot bonuwa, woy riyot mgo lugaa no nokolingkus dutun. To norinog idda to mgo minuvu, mid undiyon dan amoy'd kokita ko ondan kos notomanan. ");
INSERT INTO oboNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Na riyot kod-inguma ran, id porani sikandan ki Disas woy nokita ran iddos minuvu no id losuran to maanmaan no mgo busow. Id ounsad sikandin, noko-oumpak don woy motallong don kos poomdom din. De-en oraroy ran no novaakkan. ");
INSERT INTO oboNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dos mgo minuvu no nokokita taddon notomanan, id ponudtuu ran diyot langun iddos moka-atag taddon minuvu woy dos notomanan taddot mgo bavuy. ");
INSERT INTO oboNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","To norinog idda to mgo minuvu, id po-eru-eru ran nod awa si Disas diyot lugaa ran. ");
INSERT INTO oboNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na, to id penek don sikandin diyot bollangay, id po-eru-eru kandin iddos minuvu no no-uliyan don no od porumannon sikandin ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Piru id ikohiyan din iddos minuvu to, “Iyon moppiya, uli kad diyot koniyu, woy ponudtuu ru riyot korumannan du iddos id puungan tod Longaggon atag kikow woy dos eru rin kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","De-en id uli ron iddos minuvu, woy id ponudtuu rin diyot sopuun bonuwa no sakup to Decapolis iddos langun nid puungan ni Disas atag kandin. Na iddos langun no nokorinog kandin, oraroy ran no nosoobbuwan. ");
INSERT INTO oboNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na id sakoy mandon onsi Disas diyot bollangay, woy id livod sikandan diyot dipaa to lanow. To kodponog din, id livuungan sikandin to mo-uraan minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Duwon mandad id inguma no sokkad no ponguu to simba-an to mgo Judio no id ngoranan ki Jairo. To nokita rin si Disas, id porani sikandin woy mid lingko-od diyot isowwan din. ");
INSERT INTO oboNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Id po-eru-eru sikandin no mid ikahi to, “Tohodnonaw, iddos ba-ay'n anak ku, od oumasoy ron. Kolimulimu, duma ka koddi woy somaddiyu sikandin amoy od ko-uliyan woy'd ko-uyag.” ");
INSERT INTO oboNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","De-en id duma si Disas kandin. Na, mid tinundug mandad iddos oray'n mo-uraan minuvu no id pososokoy riyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dutun, duwon mandad sokkad no ba-ay no novohokan su sopuu-oruwa ron no lahun, diid soro nod longossan. ");
INSERT INTO oboNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Na, noosayan oraroy sikandin taddot kodbawi to mo-uraan doktor. Na-amin din don kos langun no koruwonnan din amoy id bayad kandan, piru waa sikandin no-uliyan, ko konna, id ayas baling dos bohok din. ");
INSERT INTO oboNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","To nokorinog sikandin moka-atag ki Disas, id lotlot sikandin diyot mo-uraan minuvu woy id porani riyot inoyyuhan ni Disas amoy'd somaddan din kos umpak ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Su kohingginawa rin no, “Ahad od pokosomad a ra to umpak din, od ko-uliyan ad en.” ");
INSERT INTO oboNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","To nokosomad don sikandin, idda ron en, id soro iddos bohok din nod longossan. Na, noheddam din no no-uliyan don sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Idda ron en, noheddam ni Disas no duwon kotuusan no id leggua pomon kandin. Na, id loingoy sikandin woy mid intud diyot mgo minuvu, kahi rin to, “Ondoy kos id somad to umpak ku?” ");
INSERT INTO oboNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mid tavak dos mgo tinodduwan din to, “Ontongngiyu man, mo-uraa kos od sosok kikow. Mambo man tod intud ka ko ondoy kos id somad kikow?” ");
INSERT INTO oboNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Piru id loloingoy pe-en sikandin amoy'd kokita ko ondoy kos mid somad to umpak din. ");
INSERT INTO oboNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pomon to nosorollan en taddot ba-ay iddos notomanan din, id kookoo sikandin to mattag allak woy id porani ki Disas. Mid lingko-od sikandin diyot isowwan din, woy id ponudtuu rin kos langun. ");
INSERT INTO oboNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Na kahin Disas kandin to, “Uri, no-uliyan kad pomon to kopomakoy ru. Uli kad bo duma to kosunayan, su konnad od livod dos bohok du.” ");
INSERT INTO oboNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Laggun tid oseng din idda, duwon mgo minuvu nid inguma pomon diyot baoy ni Jairo. Kahi ran to, “Poonna ruk ginawa ru, worad iddos anak du. Yo rud lewanga kos Tohodnonaw.” ");
INSERT INTO oboNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Piru id podtohon ni Disas iddos osengan dan. Kahi rin ki Jairo to, “Yo kod kaanu. Salig ka ra.” ");
INSERT INTO oboNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na waa rin porumanna iddos dumon minuvu, si Pedro ra woy dos toosuwod no si Santiago woy si Juan kos id poruma rin. ");
INSERT INTO oboNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","To id inguma ron sikandan diyot baoy ni Jairo, nokita ni Disas no od kohuyakot kos mgo minuvu, woy norinog din iddos od pondaawit. ");
INSERT INTO oboNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na, to noko-usok don sikandin, mid ikahi sikandin to, “Mambot od kohuyakot woy'd pondaawit kow? Waa id patoy inis anak, ko konna, id tinuhon da.” ");
INSERT INTO oboNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Piru id kosu-atan dan da en sikandin. Id poleggua rin iddos mgo minuvu, woy id poruma rin iddos amoy woy inoy tat anak woy dos otollu taddot mgo tinodduwan din. Id usok dan diyot kwartu no id pooyyasan tat anak. ");
INSERT INTO oboNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Na id somaddan ni Disas iddos bollad taddot anak, woy kahi rin to, “Talita kumi,” no iddos kohulugan, “Idi, onnow kad!” ");
INSERT INTO oboNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Idda ron en, id onnow dos anak woy id oipanow. (Iddon anak, sopuu-oruwa ron kos idad din.) To nokita ran idda, oraroy ran no nosoobbuwan. ");
INSERT INTO oboNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Na, id loglohottan dan ni Disas no konna ran id ponudtuu riyot ahad ondoy iddon notomanan, woy id ikohiyan din sikandan no od pokannon dos anak. ");
INSERT INTO oboNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na mid tanan si Disas taddon bonuwa duma taddot mgo tinodduwan din, woy id undiyon sikandan to bonuwa to Nazaret no id dokollan din. ");
INSERT INTO oboNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","To id inguma ron kos Allow't Kod-imolloy, id undiyon si Disas to simba-an to mgo Judio woy mid nonaw. Na rutun, mo-uraan minuvu no id lolivuung. To norinog dan iddos nonaw ni Disas, oraroy ran no nosoobbuwan. Kahi ran to, “Te, ingkon ayu id pomon kos langun no sinorollan ka-ay'n minuvu? Ondoy ayu kos id boggoy kandin to moraom no koovottan? Mambot od pokopuung sikandin to mokososoobbu? ");
INSERT INTO oboNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Konna vo sikandin man iddos panday no anak ni Maria woy suwod onni Santiago, Jose, Judas woy Simon? Konna vo iddos mgo tobboy rin, dini man id oubpa?” Na, nomorat sikandan ki Disas woy waa ran id pomakoy kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","De-en mid ikahi si Disas kandan to, “Iddos propeta, mowwet kos kod-ontong kandin to langun, piru riyot kandin no ingod, diyot mgo korumannan din woy riyot mgo sakup to pomilya rin, od poddisokkan sikandin to kod-ontong.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na pomon to dii sikandan od pomakoy, waa sikandin id puung to mokososoobbu riyot ingod din, idda ra en so pilopilon novohokan nid somaddan din kos no-uliyan. ");
INSERT INTO oboNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Oray'n nosoobbuwan si Disas taddot mgo minuvu pomon to waa ran id pomakoy kandin. Na, id undiyon si Disas to langun no bariyu amoy'd ponudtuu to kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na, id umow ni Disas iddos sopuu-oruwon tinodduwan din, woy id suhu rin sikandan no tinduwa. Id boggayan din sikandan to kotungud to kodpoleggua to mgo busow. ");
INSERT INTO oboNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","To waa pa sikandan id ipanow, id pomonduwan din sikandan, kahi rin to, “Yo kow'd piyod to koka-an, kavii woy soopi. Iyon dow ra piyodda, iddos tukod dow. ");
INSERT INTO oboNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sukub kow to sandalyas, piru yo kow'd piyod to ilisan. ");
INSERT INTO oboNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ahad ingkon kow od undiyon, woy otik duwon od inggat koniyu nod oubpa riyot baoy rin, yo kow'd alin diyot osson baoy taman tod awa kow taddon bonuwa. ");
INSERT INTO oboNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Piru otid poko-inguma kow riyot lugaa no waad tanggap koniyu o konnod pominog to nonaw row, na tonani row idda woy podpara row kos boubbuk to livuta riyot pa-a row to kod-awa row, patow no waa id pokosondit dan koniyu riyot timpu nod silutan sikandan to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","De-en id ipanow ran, woy id ponudtuu ran diyot mgo minuvu no ko-ilangan od sondit woy'd tanan sikandan to mgo saa ran. ");
INSERT INTO oboNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na id poleggua ran iddos mgo busow, woy id doddasan dan to lana iddos od pongkovohokan woy no-uliyan sikandan. ");
INSERT INTO oboNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na, norinog ni Harin Herodes iddos moka-atag taddot pinuungan ni Disas pomon to oray'n novantug kos ngaran din. Oyyos duwon mgo minuvu nid ikahi to, “Ini en si Juan no Tohodboutismu no novadnow pomon diyot kopotayan. Ini en kos unayan nod pokopuung sikandin to mgo mokososoobbu.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Duwon duma nid ikahi to, “Sikandin si Elias.” Duwon mandad duma no mid ikahi to, “Sokkad sikandin taddot mgo propeta dangan.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Na, to norinog ni Herodes iddos moka-atag ki Disas, mid ikahi sikandin to, “Sikandin en si Juan no Tohodboutismu no id potompoddan kud to liyog, piru no-uyag mandon!” ");
INSERT INTO oboNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Id ikahi ni Herodes idda, oyyos sikandin man kos id pa-ammot, id povaku woy id poprisu dangan ki Juan. Id puungan din idda pomon to kodsugga ni Juan kandin, su id ahaw rin si Herodias no sawa taddot ari rin no si Felipe. ");
INSERT INTO oboNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Oyya su inaayun od ikohiyan ni Juan si Herodes no, “Supak diyot mgo Suhu ni Moises no od ahawon du kos sawa to suwod du.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pomon tadda, nolingasa si Herodias ki Juan woy'd po-imotayan din nanoy sikandin, piru waa rin nopuungi idda su konnod aman si Herodes. ");
INSERT INTO oboNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Su novaakkan si Herodes ki Juan, oyyos nosorollan din no motallong sikandin no minuvu woy molinis kos pusung. De-en waa rin po-imotayi si Juan. Id kopi-i rin nod pominog to nonaw ni Juan, ahad od pokovoggoy idda to taong diyot poomdom din. ");
INSERT INTO oboNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Na riyot kodsampot ni Herodes to allow't kodtobbow rin, nokokita si Herodias to po-ukit to kod-imatoy ki Juan. Id pon-inggat ni Herodes iddos langun no ponguu no no-iraom kandin, dos mgo kopitan to sundau, woy dos od kilaannon no mgo minuvu riyot Galilea amoy od sakup to pista to allow't kodtobbow rin. ");
INSERT INTO oboNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","To nolivuung don sikandan, iddos mongovay no anak ni Herodias ki Felipe, mid usok woy id sayow. Na, oray'n notoosan si Herodes woy dos langun nid pon-inggat din. De-en id ikohiyan ni Herodes iddos mongovay to, “Buyu ka koddi to ahad ondan nid kopi-i ru, su id boggoy ku en kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Id pongulivot pe-en sikandin, kahi rin to, “Ahad ondan kos od buyuwon du, id boggoy ku en kikow, ahad pa inis kotongnga ka-ay't kohoriyan ku.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na, id leggua iddos mongovay su od undiyot inoy rin woy mid intud kandin, kahi rin to, “Ondan man kos od buyuwon ku?” Id tavak dos inoy to, “Iyon du buyuwa, iddos uu ni Juan no Tohodboutismu.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Idda ron en, id livod iddos mongovay riyot hari, woy mid ikahi sikandin to, “Id kopi-i ku nid boggoy ru koddi ini ron en, iddos uu ni Juan no Tohodboutismu no nokota-aw riyot bondihadu.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na, to norinog idda to hari, oray sikandin no naanu. Piru pomon to id pongulivot don me-en sikandin diyot isowwan taddot id pon-inggat din, waa sikandin nokobolivad. ");
INSERT INTO oboNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Purisu idda ron en, id suhu rin iddos sokkad taddot mgo sundau rin no od tompoddan to liyog si Juan. De-en id ipanow dos sundau po-undiyot prisuwan, woy id tampod din iddos liyog ni Juan. ");
INSERT INTO oboNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Na, id piyod din iddos uu ni Juan no nokota-aw riyot bondihadu, woy id boggoy rin idda riyot mongovay. Id boggoy mandad idda taddot mongovay riyon to inoy rin. ");
INSERT INTO oboNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","To norinog taddot mgo tinodduwan ni Juan iddon notomanan, id undiyon dan to prisuwan woy id angoy ran iddos lawa ni Juan amoy id lobbong. ");
INSERT INTO oboNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","To id livod don diyot ki Disas iddos mgo tinodduwan no id suhu rin, id ponudtuu ran kandin iddos langun no id puungan woy id nonaw ran. ");
INSERT INTO oboNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pomon to oray'n mo-uraan minuvu no od pokodsuvaa-suvaa nod inguma, konna ran od pokosakat ahad diyot kodka-an dan. De-en id osengan ni Disas iddos mgo tinodduwan din, kahi rin to, “Od undiyon ki to noka-awoy-awoy'n lugaa amoy'd poko-imolloy ki pa.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Purisu id sakoy ran to bollangay amoy od undiyon dan to noka-awoy-awoy'n lugaa. ");
INSERT INTO oboNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Piru to kodlogkiyat dan, nokita sikandan to mo-uraan minuvu no nokokilaa kandan. Id ponlungkossu ran no id pongulibpit diyot lanow pomon diyot nokod-osso-osson bonuwa, woy noko-unna ran pe-en id inguma riyot lugaa nod undiyonnan onni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","To koddunggu onni Disas woy to kodponog din to bollangay, nokita rin iddos mo-uraan minuvu no nolivuung. No-eruwan sikandin, su noko-iling dan to mgo karnero no waa tohodtamong. Na, mo-uraa kos id nonaw rin kandan. ");
INSERT INTO oboNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","To od komapun don, id porani ki Disas iddos mgo tinodduwan din woy mid ikahi to, “Noka-awoy-awoy inin lugaa woy asow ron od saop kos allow. ");
INSERT INTO oboNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Iyon ayu moppiya no od po-undiyonnon du to mgo bariyu inis mgo minuvu amoy'd pokovolli ran to koka-an.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Piru kahin Disas kandan to, “Sikiyu kos od poka-an kandan.” Kahi ran to, “Sikami vo kos od bolli to koka-an dan? Ko-ilangan ayu nod puung koy daom to waun buwan amoy'd pokovolli koy to paan no id poka-an kandan!” ");
INSERT INTO oboNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mid intud si Disas to, “Pilon molison no paan kos id piyod dow? Ontongngi row ve-en.” To no-ontongngan dan don idda, id ikahi ran to, “Eh, toonaw ra man limmon molison no paan woy oruwon ngaap inis ka-ay't keta.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na, id suhu ni Disas iddos mgo tinodduwan din no od livuungon kos langun no minuvu riyot mgo grupu, woy od po-unsaron sikandan diyot sobbotton. ");
INSERT INTO oboNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","De-en id pon-unsad iddos mgo minuvu to tinlimmompuu woy idda mandad so duma, simbokkad no gatus. ");
INSERT INTO oboNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na, id angoy ni Disas iddos limmon molison no paan woy oruwon ngaap, woy id langngag sikandin diyot datas to langit woy id posolamat diyot Monama. Nopongnga, id pontoppiktoppik din iddos mgo paan, woy id boggoy riyot mgo tinodduwan din amoy id sondad diyot mgo minuvu. Ungketen dad en mandad taddot mgo ngaap, id pontoppiktoppik din idda woy id pomboggoy riyot langun no minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na, nokoka-an dan langun woy nongovuung. ");
INSERT INTO oboNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nopongnga, id temmos taddot mgo tinodduwan din iddos nongosama no nokoponnu pe-en to sopuu-oruwon bukag. ");
INSERT INTO oboNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na iddos ko-uralloy to mgo minuvu nid ka-an, mgo limmon maan (5,000) no mama. ");
INSERT INTO oboNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Na idda ron en, id posakoy ni Disas dos mgo tinodduwan din diyot bollangay, woy id po-unna rin sikandan diyot Betsaida no riyon to dipaa taddot lanow, laggun tid popo-uli rin pa iddos mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","To id ipanow ron iddos mgo minuvu, mid tikoddog sikandin po-undiyot buvungan amoy'd dasaa. ");
INSERT INTO oboNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","To od kosagkup don, diyon poron si Disas to buvungan no siksikandin da, piru iddos mgo tinodduwan din, id pomollangay riyot tongannan to dakkoon lanow. ");
INSERT INTO oboNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na, nopantow ni Disas no noosayan iddos mgo tinodduwan nod bovadsoy, su nosinuggung dan kos kaamag. To od ka-allow-allow ron, id undiyonnan dan ni Disas no mid ipanow riyon to ampow't oweg no uvag kun tod lihad kandan. ");
INSERT INTO oboNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","To nokita ran sikandin nid ipanow riyon to ampow't oweg, id pomehes sikandan to mattag allak, oyyos kunan dan ko busow sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Su iddos langun, nokokita kandin woy no-od-oratan. Piru idda ron en, mid ikahi si Disas to, “Yo kow'd kovaakki. Kahaa kow, su siyak ini.” ");
INSERT INTO oboNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","To id sakoy si Disas diyot bollangay, idda ron en, id soro dos kaamag. Na, oraroy ran no nosoobbuwan. ");
INSERT INTO oboNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Oyyos ahad pa nokokita ran taddot mokososoobbun id puungan din taddot paan, waa ran nokaabbot taddot kohulugan tadda, su motoggas man kos uu ran. ");
INSERT INTO oboNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na, to nokorunggu ran don diyot dipaa to lanow, noko-inguma ran diyot lugaa to Genesaret, woy id ikot dan iddos bollangay ran. ");
INSERT INTO oboNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","To kodponog dan to bollangay, idda ron en, nokilaa ron to mgo minuvu si Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Na, id ponlungkossu ran diyot langun no lugaa no nokolingut, woy id sayung dan diyot ki Disas iddos od pongkovohokan amoy'd povowiyan dan kandin, ahad ingkon dan od korinog no riyon sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ahad ingkon od undiyon si Disas, diyon to mgo bariyu, diyot mgo bonuwa o riyot mgo lugaa no nokolingkus dutun, od soyungon dan iddos od pongkovohokan diyot od kolivuungan to mgo minuvu. Id po-eru-eru ran ki Disas no od posomaddon dan ahad ubpu robbo taddot umpak din. Na iddos langun no nokosomad, no-uliyan en. ");
INSERT INTO oboNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sokkad no timpu, duwon mgo Pariseo woy mgo tohodnonaw to Suhu ni Moises nid pomon diyon to Jerusalem no id undiyot ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nokita ran no duwon mgo tinodduwan din no mid ka-an no waa id ounab to bollad dan. Dos id puungan dan, supak diyot botasanon no ko-ilangan molinis dan diyot kod-ontong to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Su iddos mgo Judio, labbi ron iddos mgo Pariseo, konna ran od ka-an otik dii ran pa unna od ikulon dos botasanon to kovuyyahan dan moka-atag to kod-ounab to bollad. ");
INSERT INTO oboNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ahad od uli ran pomon diyot polingki, konna ran od ka-an otik dii ran od unnan tod ikuu iddos botasanon to kod-ounab to bollad, su saddook nokosomad dan to molibmit diyot kod-ontong to Monama. Na, duwon pa dumon botasanon nod ikulon dan, iling to kod-ounab to mgo pokawan, mgo kondiru woy brunsi no mgo kopitira. ");
INSERT INTO oboNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","De-en mid intud iddos mgo Pariseo woy dos mgo tohodnonaw to Suhu ni Moises. Kahi ran to, “Mambot id supak moho to mgo tinodduwan du iddos botasanon to kovuyyahan ta? Oyyos mid ka-an sikandan no waa id ounab to bollad.” ");
INSERT INTO oboNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mid tavak si Disas to, “Bonnaa en iddos id poposaddoo to Monama ukit ki Isaias. Oyya su oraroy kow od po-uvag-uvag no mopompomakoy iling taddot no-ikahi riyot Nosulat no Kahit Monama no mid ungketen to, ‘Inin mgo minuvu, taman da to dila kos kodposivantug dan koddi, piru moriyu kos pusung dan koddi. ");
INSERT INTO oboNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Waa koru-anon to kodsimba ran koddi, su iddos id nonaw ran, id bobbovallan da to mgo minuvu!’ ");
INSERT INTO oboNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Na, bonnaa en no id puungan dow iddos id sulat ni Isaias, oyyos id tonanan dow iddos suhu to Monama woy iyon dow baling id ikuu, iddos mgo botasanon nid bobbovallan da to mgo minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mid ikahi pe-en si Disas to, “Oraroy kow od kotuigtuig nod inoyyug to suhu to Monama amoy'd ko-ikuu row ra en iddos botasanon dow! ");
INSERT INTO oboNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Oyyos duwon id ikahi ni Moises no mid ungketen to, ‘Rispitu ka to amoy woy inoy ru,’ woy ‘Iddos ahad ondoy nod oseng to morat diyot amoy o inoy rin, ko-ilangan en nod imotayan.’ ");
INSERT INTO oboNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Piru sikiyu, ossa moho kos nonaw row. Su iddos minuvu no duwon nanoy id pokotavang diyot amoy woy inoy rin, od bolivad baling sikandin nod ikahi to, ‘Korban,’ no iddos kohulugan, id ossa kud ini atag to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Na otid ikulon din iddos kodnonaw row, konnad sikandin od pokotavang to amoy woy inoy rin. ");
INSERT INTO oboNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","De-en id podwora row kos suhu to Monama ukit to kod-ikuu row to botasanon no id pomon diyot kovuyyahan dow. Woy duwon pe-en mo-uraan id puungan dow no iling ka-ay.” ");
INSERT INTO oboNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na, id poporani ni Disas iddos mo-uraan minuvu woy id ikohiyan din to, “Pominog kow woy ooyyari row ini tod labbotlabbot. ");
INSERT INTO oboNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Konnod pokolibmit diyot kod-ontong to Monama iddos ahad ondan no koka-an nod usok diyot bivig to minuvu. Iyon od pokolibmit, idda en so morat no osengan nod leggua to bivig din. ");
INSERT INTO oboNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Na sikiyu, su duwon man tolinga row, pa-ayyad kow pominog.” ");
INSERT INTO oboNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nopongnga idda, id tanan sikandin taddot mo-uraan minuvu woy mid usok diyot baoy. Id intud ki Disas iddos mgo tinodduwan din ko ondan kos kohulugan taddot ponunggelengan din. ");
INSERT INTO oboNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kahin Disas to, “Waa kow vos mandad nokaabbot? Konna iddos ahad ondan no koka-an nod usok diyot bivig to minuvu kos od pokolibmit kandin diyot kod-ontong to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Oyyos dii man idda od poko-usok diyot ginawa rin, ko konna, diyon da to gottok woy od leggua.” (Ukit ka-ay'n osengan, id paabbotlabbot ni Disas no od pokoka-an ki to ahad ondan no koka-an.) ");
INSERT INTO oboNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na ponayun mid ikahi si Disas to, “Iyon od pokolibmit to minuvu riyot kod-ontong to Monama, idda en so nokota-aw riyot ginawa rin no od leggua riyot bivig din. ");
INSERT INTO oboNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Oyyos pomon diyot daom to minuvu, nokota-aw riyot ginawa rin iddos morat no poomdom. Woy pomon tadda, od puung don sikandin to morat, iling to kodlaayuk to konna rin sawa, kodponakow, kod-imatoy, ");
INSERT INTO oboNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kodloivug, kod-akon-akon, morat no ingowollon to lawa, kod-aakaa, kodpuung to kororattan, od kosina, koddoddora-at to duma, kodporatasdatas woy ko-ongollan. ");
INSERT INTO oboNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Na langun ka-ay, id pomon diyot daom to ginawa to minuvu woy ini en kos od pokolibmit kandin diyot kod-ontong to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Na, id tanan si Disas diyot Galilea woy id undiyon sikandin to mgo lugaa no moranit bonuwa to Tiro. To kod-inguma rin dutun, id owwot sikandin diyot sokkad no baoy, su id kopi-i rin nanoy no waa od pokosaddoo to kod-inguma rin. Piru ahad ungketen, nosorollan en ko ingkon sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Dutun, duwon sokkad no inoy no iddos ba-ay'n anak din, id losuran to busow. To norinog din nid inguma si Disas, idda ron en, id undiyon sikandin woy mid lingko-od nid ounduk diyot isowwan ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Id po-eru-eru sikandin no od polegguangon ni Disas iddos busow nid lasud diyot anak din. Na iddon ba-ay, konna Judio, su nominuvu sikandin diyot prubinsya to Fenicia woy dos kinohiyan din, Griego. ");
INSERT INTO oboNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Piru mid ooseng si Disas kandin ukit to ponunggelengan, kahi rin to, “Ko-ilangan no unna pa od kovuung kos mgo anak. Su konna en ollog nod ongayon iddos koka-an to mgo anak woy id sunggud diyot mgo tuyyang.” ");
INSERT INTO oboNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Piru kahi taddot ba-ay to, “Oyya, Longaggon, piru ahad pa iddos mgo tuyyang no riyot silob to lomisa, od pokoka-an man to mgo mumu nod pongo-uug to mgo anak.” ");
INSERT INTO oboNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kahin Disas to, “Pomon to iling duwon kos id oseng ru, od poko-uli kad su id leggua ron iddos busow nid lasud diyot anak du.” ");
INSERT INTO oboNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na id uli ron dos ba-ay, woy nokita rin iddos anak din no id oilogga no no-uliyan don. ");
INSERT INTO oboNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","To id tanan si Disas diyot bonuwa to Tiro, id baya sikandin diyot bonuwa to Sidon, woy riyot mgo lugaa no moranit bonuwa to Decapolis, idda pa sikandin id livod diyon to Lanow't Galilea. ");
INSERT INTO oboNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na rutun, duwon mgo minuvu no id piyod diyot ki Disas to sokkad no minuvu no diid pokorinog woy ommow. Id po-eru-eru ran kandin no od somaddan din iddon minuvu amoy'd ko-uliyan. ");
INSERT INTO oboNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","De-en id piyod ni Disas iddos minuvu riyot moriyu boyow pomon diyot ko-urallan. Na, id tiyuk din to tintoddu rin woy id somaddan din iddos dila taddot minuvu. Nopongnga, id ilobban din iddos tintoddu rin woy id somoddan din iddos dila taddot minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na id langngag si Disas diyot datas to langit, woy id songnga sikandin to moraom pomon to eru rin woy kahi rin to, “Efata,” no iddos kohulugan, “Od kopokesan ka!” ");
INSERT INTO oboNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Idda ron en, nokorinog don dos minuvu woy na-awa iddos unayan no no-ommow sikandin, woy motallong don kos kod-ooseng din. ");
INSERT INTO oboNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Id ikohiyan ni Disas dos mgo minuvu, no konna ran id ponudtuu riyot ahad ondoy iddos nokita ran. Piru ahad kopila rin sikandan id osengan, id ayas dan da en baling id poso-ob tid ponudtuu iddos nokita ran. ");
INSERT INTO oboNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na langun taddot nokorinog, oray'n nosoobbuwan. Kahi ran to, “Moppiya kos langun nid puungan din, oyya su ahad iddos diid pokorinog, woy dos mgo ommow, od poko-ooseng don!” ");
INSERT INTO oboNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sokkad no timpu, nolivuung mandon iddos mo-uraan minuvu. Na-amin don kos tasak dan, de-en id poporani ni Disas iddos mgo tinodduwan din woy id ikohiyan din to, ");
INSERT INTO oboNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“No-eruwan a ka-ay't mo-uraan minuvu, oyyos notolluwan don nid duma ran koddi no worad tasak dan. ");
INSERT INTO oboNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na, otid po-uliyon ku sikandan no diid pokoka-an, od moomet dan to gutas diyot daan, su duwon duma no moriyu pa kos od uliyan.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kahi taddot mgo tinodduwan din to, “Oyya en, piru ingkon ki man od poko-angoy to id poka-an ta ka-ay't mo-uraan minuvu, su ini ki man to noka-awoy-awoy'n lugaa?” ");
INSERT INTO oboNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mid intud si Disas kandan, kahi rin to, “Pilon molison kos paan duwot koniyu?” Id tavak sikandan to, “Pittu.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na, id po-unsad ni Disas iddos mo-uraan minuvu, woy id angoy rin iddos pittun paan woy id posolamat sikandin diyot Monama. Nopongnga, id pontoppiktoppik din idda woy id boggoy riyot mgo tinodduwan din amoy id sondad diyot mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Duwon mandad pilopilon ngaap. Id posolamat mandon si Disas tadda riyon to Monama, woy id posondad din mandad idda taddot mgo tinodduwan din diyot mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na, nokoka-an dan langun woy nongovuung. To nopongnga ran mid ka-an, nokolimud iddos mgo tinodduwan to nongosama no nokoponnu to pittun doorakkoon bukag. ");
INSERT INTO oboNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Dos ko-uralloy to minuvu nid ka-an, mgo oppat no maan (4,000). Nopongnga idda, id popo-uli ni Disas iddos mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Woy id sakoy sikandin to bollangay duma to mgo tinodduwan din po-undiyot lugaa to Dalmanuta. ");
INSERT INTO oboNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na, to kod-inguma ran diyot Dalmanuta, duwon mgo Pariseo no id porani ki Disas amoy'd opilon sikandin diyot opulanan, su id kopi-i ran nod posaharon sikandin. De-en id buyu ran kandin no od pokitannon sikandan to mokososoobbu nod posivonnaa no id popiyod en sikandin to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Id songnga si Disas to moraom, su id mosakit kos ginawa rin woy mid ikahi sikandin to, “Ooy koniyu no mgo minuvu to inin timpu! Mambot od buyu kow pa nod pokitannon to mokososoobbu? Bonnaavonnaa nod ikohiyon ku koniyu, no waa en mokososoobbu no id pokita ku koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na, id tanan onsi Disas kandan woy mid sakoy mandon to bollangay woy id tollus dan diyot dipaa to lanow. ");
INSERT INTO oboNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na, nolingow iddos mgo tinodduwan ni Disas no id piyod to tasak dan no paan, woy sokkad dobbon molison no paan kos diyot bollangay ran. ");
INSERT INTO oboNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Id osengan sikandan ni Disas ukit to ponunggelengan, kahi rin to, “Bantoy kow taddot potuvu to paan to mgo Pariseo woy ki Harin Herodes.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","To id oseng ni Disas idda, id po-ikohiyoy ran to, “Saddook id oseng din idda su wora ki man nokopiyod to paan.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Na nokosaddoo si Disas taddot mgo osengan dan, de-en mid ikahi sikandin to, “Mambot nosasow kow no waa kow nokopiyod to paan? Waa kow pobbos nokaabbot? Mambot motoggas kow nod pokaabbot? ");
INSERT INTO oboNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Duwon mata row, piru konna kow od pokokita, woy duwon tolinga row, piru konna kow od pokorinog. Nolingow kowd bo taddot id puungan ku? ");
INSERT INTO oboNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Iddot id pontoppiktoppik ku iddos limmon molison no paan nid poka-an ku taddot limmon maan (5,000) no minuvu, pilon bukag kos noponnu row tat nongosama?” Mid tavak sikandan to, “Sopuu-oruwa.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Na mid ikahi mandon si Disas to, “Iddot id pontoppiktoppik ku iddos pittun molison no paan nid poka-an ku taddot oppat no maan (4,000) no minuvu, pilon doorakkoon bukag kos noponnu row tat nongosama?” Mid tavak sikandan to, “Pittu.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kahi rin kandan to, “Waa kow pobbos nokaabbot no inis id nonaw ku, konna moka-atag to paan?” ");
INSERT INTO oboNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","To id inguma onsi Disas diyot bonuwa to Betsaida, duwon mgo minuvu no id undiyot ki Disas woy id piyod sikandan to butud no mama. Id po-eru-eru ran nod somaddan din iddos butud amoy'd ko-uliyan. ");
INSERT INTO oboNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na id pikit ni Disas iddos butud, woy id leggua ran taddon bariyu. To nokoleggua ron sikandan, id ilobban din iddos mata taddot butud, id somaddan din sikandin woy id inturan, kahi rin to, “Ondan, duwon don od kokita ru?” ");
INSERT INTO oboNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na id langngag boyow iddos butud woy mid tavak to, “Oyya, od pokokita a to mgo minuvu, piru iling da to mgo kayu nod ipopanow.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Id somaddan mandon ni Disas iddos mata taddot butud. Na, id totongtong iddos minuvu woy moppiya ron kos kod-ontong din. ");
INSERT INTO oboNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nopongnga idda, id po-uli sikandin ni Disas woy id ikohiyan din to, “Yo ka vo od baya riyot bonuwa nid pomonnan ta.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na, mid undiyon si Disas woy dos mgo tinodduwan din to mgo bariyu no sakup to bonuwa to Cesarea Filipos, woy laggun tid ipanow ran, id intud si Disas kandan, kahi rin to, “Ondoy a man diyot poomdom to mgo minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mid tavak sikandan to, “Duwon id ikahi no sikkow kun si Juan no Tohodboutismu. Dos duma mid ikahi no sikkow si Elias, woy duwon duma nid ikahi no sokkad ka taddot mgo propeta dangan.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kahin Disas to, “Piru atag koniyu, ondoy a man?” Mid tavak si Pedro to, “Sikkow en kos Mesiyas.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Na, id loglohottan din iddos mgo tinodduwan no dii ran id ponudtuu riyot ahad ondoy iddos moka-atag kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na, mid tigkanoy ron si Disas to kodpaabbotlabbot diyot mgo tinodduwan din moka-atag tod kotomanan din. Kahi rin to, “Siyak no Anak to Minuvu, ko-ilangan nod ukit to mo-uraan kodposuppit, woy od elleyan a tod pombuyyahon to mgo Judio, taddot mgo ponguu to tohodbuwis woy taddot mgo tohodnonaw to Suhu ni Moises. Od imotayan a, piru riyot iko-otollun allow, od kovadnow a.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iddos langun no id ponudtuu ni Disas diyot mgo tinodduwan din moka-atag to kopotayan din, moomok da nod koovottan. To norinog idda ni Pedro, id piyod din si Disas diyot ibpit woy id sugga rin, kahi rin to, “Yo kod oseng to ungketen.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Piru mid isau si Disas diyot mgo tinodduwan din woy id sugga rin si Pedro, kahi rin to, “Awa ka, Moivuyan! Su iddos poomdom du, konna pomon to Monama, ko konna, pomon to minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na, id poporani ni Disas iddos mgo minuvu woy dos mgo tinodduwan din woy id ikohiyan din to, “Iddos ahad ondoy no od kopiyan nod kovovallan no tinodduwan ku, ko-ilangan nod inoyyuhan din kos kandin nid kopi-i, woy od tiyangon din iddos kandin no krus amoy'd dumoruma koddi. ");
INSERT INTO oboNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Oyya su iddos minuvu nod konuhunan to umuu rin, od koworan da en baling tadda. Piru iddos ahad ondoy nod patoy pomon to koddumoruma rin koddi woy pomon to kodponudtuu rin to Moppiyon Dinoggan, duwon umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Su ahad od kokomunoy to minuvu kos langun no korotuwan ka-ay to ampow't ingod, waa en koru-anon otid koworan sikandin to umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Oyyos waa korotuwan no id pokovullas to minuvu amoy'd ka-awi rin iddos umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Dos mgo minuvu to inin timpu, oray'n mosaasaa su id inoyyuhan dan kos Monama. Na otik id ko-ilow a nikandan woy dos mgo nonaw ku, siyak no Anak to Minuvu, id ko-ilow ku mandad sikandan init kodlivod ku nod dumannan to se-aa to kotuusan to Amoy ku woy taddot uhis no mgo ponolihan.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na ponayun mid ikahi si Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no duwon duma ka-ay no dii pa od patoy taman to dii ran pa od kokita iddos kotuusan to kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","To id lihad don kos annom no allow, id poruma ni Disas si Pedro, si Santiago woy si Juan po-undiyon to mowwet no buvungan no siksikandan da. Laggun tid totongtong dan ki Disas, idda ron en, nopalin kos boyo rin. ");
INSERT INTO oboNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Iddos umpak din, id sella-sella pomot koputiyoy no waa en iling tadda ka-ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na, nokita ran si Elias woy si Moises no id tongko ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kahin Pedro ki Disas to, “Tohodnonaw, moppiya en no ka-ay ki. Od sosabbung koy to otollu, sokkad atag kikow, sokkad atag ki Moises woy sokkad atag ki Elias.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Id oseng ni Pedro idda pomon to waa rin nonongnongngi ko ondan kod osengon din, su oraroy sikandan no novaakkan. ");
INSERT INTO oboNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na duwon souhapun no id tambun kandan, woy duwon bawos nid pomon diyot souhapun no mid ungketen to, “Ini en kos Anak ku no id dokollan ku to ginawa. Pominogga row sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Idda ron en, id langulangu ran woy waa osson nokita ran, si Disas dobbo. ");
INSERT INTO oboNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na laggun tod potupang dan, id loglohottan dan ni Disas. Kahi rin to, “Yo row en id ponudtuu riyot ahad ondoy iddos nokita row taman to siyak no Anak to Minuvu, od kovadnow ron.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","De-en id tota-aw ran diyot poomdom dan iddos id ikahi ni Disas, woy waa ran en id ponudtuu iddos nokita ran. Piru id po-inturoy sikandan, kahi ran to, “Ondan ayu kos kohulugan taddot id oseng din nod kovadnow sikandin?” ");
INSERT INTO oboNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na mid intud sikandan ki Disas, kahi ran to, “Mambot od ikohiyon to mgo tohodnonaw to Suhu ni Moises no ko-ilangan no unna od undini si Elias, idda pa iddos Mesiyas?” ");
INSERT INTO oboNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mid tavak si Disas to, “Bonnaa en no unna pa od undini si Elias amoy'd panoy to langun. No-ikahi mandad diyot Nosulat no Kahit Monama no dakkoo kos koosayan ku no Anak to Minuvu, woy od elleyan a nikandan pomon to lingasa ran koddi. ");
INSERT INTO oboNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Piru od ikohiyan ku sikiyu, no id inguma ron si Elias, woy id puungan to mgo minuvu iddos langun no morat no id kopi-i ran nod puungan diyot kandin. Woy ini en kos no-ikahi moka-atag kandin diyot Nosulat no Kahit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na, to id inguma onsi Disas diyot dumon mgo tinodduwan din no id polintotuwos, nokita ran no id lingut kandan iddos mo-uraan minuvu. Woy duwon mgo tohodnonaw to Suhu ni Moises no mid apuu taddon mgo tinodduwan. ");
INSERT INTO oboNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","To nokita si Disas taddot mgo minuvu, oraroy ran no nosoobbuwan, woy id ponlungkossu ran amoy od tommu kandin woy'd olit-olit. ");
INSERT INTO oboNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mid intud si Disas kandan, kahi rin to, “Ondan kos opulanan dow?” ");
INSERT INTO oboNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na duwon sokkad nid tavak, kahi rin to, “Tohodnonaw, duwon anak ku no id piyod ku ka-ay't kikow, su id losuran to busow unayan no konnad sikandin od poko-ooseng. ");
INSERT INTO oboNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Otid ingumannan sikandin, od kopiloy nod pokovuntug diyot livuta, od bovuwak kos bivig din, od kihot kos ngipon woy'd koggaa sikandin. Id nganoy ad diyot mgo tinodduwan du nod polegguangon dan iddos busow, piru waa ran man noko-uli kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kahin Disas to, “Sikiyu no mgo minuvu no waa kopomakoy woy ebbaw! Momonnu kouhayyoy kos kodumoruma ku koniyu? Kannu pa ayu od kotaman inis kodti-is ku koniyu? Piyodda row kos anak ka-ay't koddi!” ");
INSERT INTO oboNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na, id piyod dan iddos anak diyot ki Disas. To nokokita ki Disas dos busow, idda ron en, id pokookoo to busow iddos anak. Id gohulivid mandon iddos anak woy nopiloy no nokovuntug mandon diyot livuta, woy id likidlikid sikandin nid bovuwak kos bivig. ");
INSERT INTO oboNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mid intud si Disas taddot amoy, kahi rin to, “Kannu man sikandin no-iling ka-ay?” Id tavak dos amoy to, “Pomon poron to ko-onakoy rin. ");
INSERT INTO oboNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kopila ron nanoy sikandin od imotayan to busow nid lasud kandin, woy od pokoumbag sikandin diyot apuy woy oweg. Piru otid pokogaha ka, ko-eru-i koy woy tovangi koy.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kahin Disas to, “Mambot od ikahi ka no otid pokogaha a? Oyyos od kopuungan en kos langun otid pomakoy kos minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na, id nganoy kandin iddos amoy taddot anak, kahi rin to, “Duwon kopomakoy ku piru moomet en. Tovangi a nod mosalig kos kopomakoy ku!” ");
INSERT INTO oboNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","To nokita ni Disas no id lukutlukut id porani iddos mo-uraan minuvu, id suhu rin iddos busow nid lasud diyot anak. Kahi rin to, “Sikkow no busow no id po-ommow woy'd povongoo ka-ay't anak, leggua ka woy yo kad od livod nod lasud kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na, id pomehes dos busow woy ayas din pe-en id pokookoo iddos anak, idda pa mid leggua sikandin. Iddos anak, imman tid patoy ron su worad man nokowaong. De-en mid ikahi iddos mgo minuvu to, “Eh, id patoy ron bos moho ika!” ");
INSERT INTO oboNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Piru id somaddan ni Disas iddos bollad taddot anak woy id po-onnow rin, woy id lohinat dos anak no no-uliyan don. ");
INSERT INTO oboNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","To id usok onsi Disas diyot baoy nid oubpan dan, id inturan sikandin to mgo tinodduwan din no siksikandan da, kahi ran to, “Mambot waa koy nokopoleggua taddot busow?” ");
INSERT INTO oboNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mid tavak si Disas to, “Waa ossa nod pokopoleggua to iling taddon busow, idda ra en so koddasaa.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Na, id tanan onsi Disas taddon lugaa woy id baya sikandan diyot Galilea. Id kopi-i ni Disas no konnod kosorollan to mgo minuvu ko ingkon sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Id puungan din idda, su amoy waad pokolewang to kodnonaw rin to mgo tinodduwan din. Na kahin Disas kandan to, “Siyak no Anak to Minuvu, id boggoy a riyot bollad taddot od pongkuntra koddi. Id po-imotayan a nikandan, piru od kovadnow a riyot iko-otollun allow.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Waa ran nokaabbot to kohulugan taddot id ikahi ni Disas kandan, piru od kovaakkan dan nod intud kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na, id inguma ron onsi Disas diyot bonuwa to Capernaum. To riyon don sikandan to daom to baoy, id inturan ni Disas iddos mgo tinodduwan din, kahi rin to, “Ondan kos opulanan dow riyot daan?” ");
INSERT INTO oboNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Piru id po-onong-onong da en sikandan, su id po-opuloy ran man ko ondoy kandan kos mowwet to langun. ");
INSERT INTO oboNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Na, id ounsad si Disas woy id poporani rin iddos sopuu-oruwon tinodduwan din. Kahi rin kandan to, “Iddos ahad ondoy nod kopiyan nod kovovallan no mowwet to langun, ko-ilangan no od poobbava sikandin woy'd po-uripon to langun.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Id angoy ni Disas iddos disok no anak woy id poohinat din diyot tongannan dan. Id sopipi rin iddon anak woy mid kahi sikandin to, ");
INSERT INTO oboNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Iddos ahad ondoy nod tanggap to mopoobbavon minuvu iling ka-ay't anak pomon to kopomakoy rin koddi, siyak kos id tanggap din. Woy konna ra siyak kos id tanggap din, ko konna, idda mandad so Monamon Amoy ku no id popiyod koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na mid ikahi si Juan ki Disas to, “Tohodnonaw, nokokita koy to sokkad no minuvu no nokopoleggua to mgo busow ukit to ngaran du. Id sugga roy sikandin, oyyos konna ta man duma.” ");
INSERT INTO oboNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Piru kahin Disas to, “Yo row sikandin sugga-a, oyyos waa minuvu no kopongnga od puung to mokososoobbu ukit to ngaran ku, od ooseng don to morat moka-atag koddi. ");
INSERT INTO oboNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Su iddos minuvu no konnod supak keta, od poomig keta. ");
INSERT INTO oboNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Bonnaavonnaa nod ikohiyon ku koniyu, no iddos ahad ondoy nod po-inom koniyu to sokkad no pokawan no oweg pomon to mgo tinodduwan kow to Mesiyas, od pokotanggap sikandin to ganti. ");
INSERT INTO oboNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Na, iddos ahad ondoy nod poko-okoy nod puung to saa kos mopoobbavon minuvu iling ka-ay't disok no anak no od pomakoy koddi, moppiya pa nod ikottan kos liyog din to oray'n dakkoon gilingan no batu woy id lumbag sikandin diyot dahat. ");
INSERT INTO oboNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","De-en otik ikos bollad du kos unayan nod pokosaa ka, tompoddowd baling ika. Su moppiya pa nod pokotanggap ka to umuun waad tomanon no sokkad da kos bollad, kuntra to duwon oruwon bollad du no id lumbag ka riyon to linow't apuy. ");
INSERT INTO oboNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Oyyos dutun, duwon mgo tagkoy no diid patoy nod ka-an taddot mgo lawa ran woy dos apuy no konnod ko-ovukkan. ");
INSERT INTO oboNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na otik ikos pa-a ru kos unayan nod pokosaa ka, tompoddowd baling ika. Su moppiya pa nod pokotanggap ka to umuun waad tomanon no sokkad da kos pa-a, kuntra to duwon oruwon pa-a ru no id lumbag ka riyon to linow't apuy. ");
INSERT INTO oboNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Oyyos dutun, duwon mgo tagkoy no diid patoy nod ka-an taddot mgo lawa ran woy dos apuy no konnod ko-ovukkan. ");
INSERT INTO oboNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Otik ikos mata ru kos unayan nod pokosaa ka, kootowd baling ika! Su moppiya pa nod lonug ka riyon to kodharit Monama no sokkad da kos mata, kuntra to duwon oruwon mata ru no id lumbag ka riyon to linow't apuy. ");
INSERT INTO oboNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Oyyos dutun, duwon mgo tagkoy no diid patoy nod ka-an taddot mgo lawa ran woy dos apuy no konnod ko-ovukkan. ");
INSERT INTO oboNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Bonnaa en no duwon mgo kosupittan nod ko-ukitan to langun nod pompomakoy amoy'd mosalig kos kopomakoy ran. Su iddos mgo kosupittan, noko-iling taddot assin woy apuy nod poka-awa to ahad ondan no konna moppiya. ");
INSERT INTO oboNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Moppiya kos assin su od pokovoggoy't nanam to koka-an ta, piru kod motabbang don ini, dii ron en id pokopolivod kos nanam. Purisu sikiyu nod pomakoy koddi, ko-ilangan nod poko-iling kow to assin ukit to kodpotovangoy no od moppiya kos koroniyan dow.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Na id tanan onsi Disas diyot prubinsya to Galilea, woy id undiyon sikandan to Judea woy riyot dipaa to Oweg to Jordan. Dutun, id livuungan mandon sikandin to mo-uraan minuvu, woy mid nonaw sikandin su idda en kos nooyami rin nod puungan. ");
INSERT INTO oboNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Duwon mgo Pariseo no id porani ki Disas amoy'd posahad kandin ukit to kod-intud. Kahi ran to, “Ondan, noko-ikuu vo riyot mgo Suhu ni Moises iddos kodsuwoy to mama taddot sawa rin?” ");
INSERT INTO oboNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Piru mid tavak si Disas kandan ukit to intud, kahi rin to, “Ondan man kos id suhu ni Moises koniyu moka-atag ka-ay?” ");
INSERT INTO oboNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Id tavak sikandan to, “Id aman si Moises no od bovaa kos mama to kosulatan to kodposuwayoy, idda pa od suwayan din kos sawa rin.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kahin Disas to, “Id aman si Moises no od suwayan dow kos sawa row, su motoggas man kos uu row. ");
INSERT INTO oboNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Piru riyot tigkonayan to kodbovaa to ingod, id bovallan to Monama kos mama woy ba-ay. ");
INSERT INTO oboNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ini en kos unayan no od tanan kos mama to amoy woy inoy rin amoy'd pokodsokkad don sikandan to sawa rin woy dos oruwa, od kosokkad don. ");
INSERT INTO oboNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Na konnad sikandan oruwa, ko konna, sokkad don. ");
INSERT INTO oboNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","De-en iddos id podsokkad don to Monama, konnod podsuwayon to minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","To id inguma onsi Disas diyot baoy, id intud don mandon kandin iddos mgo tinodduwan din moka-atag to kodposuwayoy. ");
INSERT INTO oboNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mid ikahi si Disas to, “Iddos ahad ondoy no mama nod suwoy to sawa rin woy od osawa to duma, nokoloivug sikandin taddot unnon sawa rin. ");
INSERT INTO oboNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Woy ungketen dad en mandad diyot ba-ay. Otid suwoy sikandin to sawa rin woy'd osawa to duma, nokoloivug sikandin taddot unnon sawa rin.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sokkad no allow, duwon mgo minuvu no id piyod to mgo anak dan diyot ki Disas, amoy ukit to kodtoddung din to bollad din taddot uu ran diyon to koddasaa, id pokita to Monama iddos kopiyannoy rin diyot mgo anak. Piru id sugga to mgo tinodduwan din iddos mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","To nokita idda ni Disas, nolingasa sikandin woy mid ikahi to, “Podtohona row ron kos mgo anak nod porani koddi, woy yo row sikandan sugga-a. Su iddos mgo minuvu no od salig to Monama iling to kodsalig to mgo anak, sikandan en kos od kolonug to kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bonnaavonnaa nod ikohiyon ku koniyu, no iddos ahad ondoy no diid salig to Monama iling to kodsalig to anak, dii en od kolonug diyon to kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na, id ponsopipi rin iddos mgo anak woy ukit to kodtoddung din to bollad din taddot uu ran diyon to koddasaa, id buyu rin no iddos Monama, od pokita to kopiyannoy rin diyot kandan. ");
INSERT INTO oboNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","To kodlogkiyat onni Disas to iponawon dan, duwon sokkad no minuvu no id lungkossu po-undiyot kandin. Id lingko-od sikandin diyot isowwan din woy mid intud, kahi rin to, “Moppiyon Tohodnonaw, ondan kos od puungan ku amoy'd pokotanggap a to umuun waad tomanon?” ");
INSERT INTO oboNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Mid tavak si Disas to, “Mambot od ngoranan a nikkow no moppiya? Oyyos sokkad da kos moppiya, idda ra en so Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nokosaddoo kad taddot mgo suhu to Monama no mid ungketen to, ‘Yo kod imatoy, yo kod loivug, yo kod ponakow, yo kod posivonnaa to uhus, yo kod loimbung, woy rispitu ka to amoy woy inoy ru.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kahi taddot minuvu to, “Tohodnonaw, langun duwon no suhu, id puungan kud pomon poron to ko-onakoy ku.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Na, id tongtongngan ni Disas iddos minuvu duma to kodginawa, woy id ikohiyan din to, “Duwon pa sokkad no kulang diyot kikow. Uli ka, woy boligya ru kos korotuwan du woy pomboggoy ru kos bayad diyot worowora. Otid puungan du ini, duwon en korotuwan du riyot datas to langit. Kopongnga, livod ka woy duma ka koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","To norinog idda taddot minuvu, od kokita riyot bonnong din no naanu sikandin woy id ipanow no noponnut lanu, oyyos dakkoo man kos korotuwan din. ");
INSERT INTO oboNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na id tongtong si Disas diyot mgo tinodduwan din, woy kahi rin kandan to, “Mosuppit en taddot minuvu no dakkoo kos korotuwan nod kolonug diyon to kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nosoobbuwan iddos mgo tinodduwan din taddot id oseng din. Piru id ikahi mandon si Disas to, “Mgo anak, mosuppit en oraroy iddos kodlonug diyon to kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Moomok pa iddos kod-usok to kamelyo riyon to bobbot simat kuntra to minuvu no dakkoo kos korotuwan nod lonug diyon to kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na oray'n nosoobbuwan iddos mgo tinodduwan din, woy id po-inturoy ran to, “Ko ungketen, ondoy pobbo kos od kotobbus?” ");
INSERT INTO oboNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Id tongtong si Disas kandan woy mid ikahi to, “Konna ini od kopuungan to minuvu, piru iddos Monama, od kopuungan din en kos langun.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kahin Pedro to, “Na sikami, id tonanan doyd kos langun pomon to koddumoruma kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kahin Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no iddos ahad ondoy nod tanan to ubpan din, mgo suwod o tobboy rin, amoy o inoy rin, mgo anak din, woy mgo kamot din pomon to koddumoruma rin koddi woy pomon to kodponudtuu rin to Moppiyon Dinoggan, ");
INSERT INTO oboNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","duwon ganti no id boggoy to Monama kandin to inin timpu. Oyyos od pokotanggap sikandin to lampas pa taddot id tonanan din no mgo ubpan, mgo suwod, mgo tobboy, mgo inoy, mgo anak woy mgo kamot. Od ukit mandad sikandin to kodposuppit pomon to kopomakoy rin, piru riyot mori, od pokotanggap sikandin to umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Piru mo-uraan mowwet ko-ungkay riyot kod-ontong to minuvu no od poobbovan, woy mo-uraa mandad no moobbava ko-ungkay riyot kod-ontong to minuvu no od porotason.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Laggun to riyon pa onsi Disas to daan po-undiyot Jerusalem, id unna sikandin. Nosoobbuwan iddos mgo tinodduwan din, woy dos mgo minuvu nid tinundug kandan, novaakkan. De-en id livuung ni Disas iddos mgo tinodduwan din, woy id ponudtuu rin mandon kandan iddos moka-atag tod kotomanan din. ");
INSERT INTO oboNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kahi rin to, “Pominog kow, od undiyon kid to Jerusalem. Na rutun, siyak no Anak to Minuvu, id boggoy riyot bollad to mgo ponguu to tohodbuwis woy riyot mgo tohodnonaw to Suhu ni Moises. Od silutan a nikandan to kopotayan woy kopongnga, id boggoy a riyot bollad to konna mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Od sumpoliton a nikandan, od ilobban woy'd pomodasan. Kopongnga, od imotayan a, piru riyot iko-otollun allow, od kovadnow a.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na, mid porani ki Disas si Santiago woy si Juan no mgo anak ni Sebedeo woy kahi ran to, “Tohodnonaw, duwon od buyuwon doy kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mid intud si Disas kandan, kahi rin to, “Ondan man kos od buyuwon dow koddi?” ");
INSERT INTO oboNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Id tavak sikandan to, “Otid inguma ron iddos timpu to kodhari ru nod dumannan to se-aa to kotuusan du, muopa nod po-unsaron koy nikkow riyot duug du, sokkad diyot kowanan du woy sokkad diyot ivang.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kahin Disas to, “Waa row nosorolli ko ondan kos od buyuwon dow. Od pokogaha kow vo nod ukit to koosayan iling tod ko-ukitan ku? Woy od pokogaha kow vo nod ti-is to kopotayan iling to kopotayan ku?” ");
INSERT INTO oboNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mid tavak sikandan to, “Oyya, od pokogaha koy.” Kahin Disas to, “Bonnaa rad en no iddos kosupittan nod ko-ukitan ku, od ko-ukitan dow mandad. Woy dos kopotayan nod ko-ukitan ku, od ko-ukitan dow en mandad. ");
INSERT INTO oboNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Piru moka-atag to kodpo-unsad diyot kowanan woy ivang ku, konna siyak kos od aam tadda. Oyya su id panoy ron tapoy to Monama ko ondoy kos od po-unsaron din tadda.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","To norinog idda taddot sopuun tinodduwan no duma ran, nolingasa ran ki Santiago woy ki Juan. ");
INSERT INTO oboNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Na id poporani ran langun ni Disas, woy id ikohiyan din sikandan to, “Nosorollan dow no iddos od ponguu to konna mgo Judio, id pomohos dan iddos kopi-i ran, woy dos mgo minuvu no mowwet kos kotundanan, id pokita ran en kos kandan no kotungud. ");
INSERT INTO oboNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Piru sikiyu, konna kow iling kandan, su iddos ahad ondoy koniyu no od kopiyan nod kovovallan no mowwet, ko-ilangan nod po-uripon sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Woy dos ahad ondoy nod kopiyan no mowwet to langun koniyu, ko-ilangan nod po-uripon sikandin to duma. ");
INSERT INTO oboNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Su ahad siyak no Anak to Minuvu, waa a mid undini to ingod amoy'd uripon to mgo minuvu, ko konna, amoy od po-uripon a woy'd boggoy to umuu ku atag to kodtobbus to mo-uraan minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na, id inguma si Disas woy dos mgo tinodduwan din diyot bonuwa to Jerico. To id tanan don sikandan dutun, oray'n mo-uraa kos minuvu nid duma kandan. Duwon sokkad no butud no mid ounsad diyot ibpit to daan amoy'd pokilimus. Sikandin, si Bartimeo no anak ni Timeo. ");
INSERT INTO oboNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","To norinog din nod lihad si Disas no toho Nazaret, id pehes sikandin no mid ungketen to, “Disas, lubbad ni David, ko-eruwan ka koddi!” ");
INSERT INTO oboNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Id sugga sikandin taddot mo-uraan minuvu no od po-onong-onong da, piru ayas da en baling sikandin id pehes nid ungketen to, “Lubbad ni David, ko-eruwan ka koddi!” ");
INSERT INTO oboNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","De-en id soro si Disas woy mid ikahi to, “Po-undiniya row sikandin.” Na, id umow ran iddos butud woy kahi ran to, “Kahaa ka woy lohinat ka, su id umow ka nikandin.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Idda ron en, id lusut din kos mowwet no umpak din woy id lohinat sikandin nid ipanow po-undiyot ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Na id inturan sikandin ni Disas, kahi rin to, “Ondan man kos id kopi-i ru nod puungan ku kikow?” Mid tavak iddos butud to, “Tohodnonaw, id kopi-i ku nod pokokita.” ");
INSERT INTO oboNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kahin Disas to, “Na uli kad bo. No-uliyan ka pomon to kopomakoy ru.” Idda ron en, nokokita ron iddos butud woy id duma sikandin ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na, to morani ron onsi Disas diyot Jerusalem, od kopantow ran don iddos bariyu to Betpahe woy Betania no riyot banod to Buvungan to mgo Olibo. Id po-unna ni Disas dutun iddos oruwa taddot mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kahi rin kandan to, “Undiyon kow to bariyu no riyot ko-unnan woy to kod-inguma row rutun, idda ron en, od kokita row kos natit asnu no waa pa nosokayi no id ikot. Okasa row vo idda woy tuyuka row rinit koddi. ");
INSERT INTO oboNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Otik duwon od intud koniyu no, ‘Mambot od okasan dow kos natit asnu?’ tovaka row sikandin to, ‘Od ko-ilonganon ini tod Longaggon, woy go-os din da ini id po-uli.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na id ipanow sikandan woy to kod-inguma ran, nokita ran iddos natit asnu nid ikot diyot sobbangan to ubpan no riyot ibpit to daan, woy id akas dan idda. ");
INSERT INTO oboNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Duwon mgo minuvu rutun no mid ikahi kandan to, “Mambot od okasan dow kos natit asnu?” ");
INSERT INTO oboNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Id tavak sikandan iling taddot id pomandu ni Disas kandan, de-en id aman iddos mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na, id tuyuk dan iddos natit asnu po-undiyon to ki Disas. Id ompasan dan idda to mgo umpak dan, woy id sakoy ron si Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mo-uraa kos minuvu rutun no id ampas to mgo umpak dan diyot od ukitan ni Disas to kodposivantug kandin. Idda mandad so duma, id tampod to mgo panga to kayu no doro-unon woy id ampas dan idda riyot daan. ");
INSERT INTO oboNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na, iddos mgo minuvu no riyot ko-unnan woy dos id tinundug ki Disas, id pehes dan no mid ungketen to, “Od doongon kos Monama. Od posivontuhan ta kos id popiyod to Monama nod Longaggon!” ");
INSERT INTO oboNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Id pokita to Monama iddos kopiyannoy rin taddot od ingumon hari nod suvaa to kovuyyahan doy no si David! Od doongon kos Monama riyot datas to langit!” ");
INSERT INTO oboNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","To kod-inguma ni Disas diyot Jerusalem, mid undiyon sikandin to lama to templo, woy id tongtongngan din iddos langun dutun. Nopongnga, id undiyon sikandin to Betania duma taddot sopuu-oruwon tinodduwan din, oyyos od kosagkup don. ");
INSERT INTO oboNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","So-op no allow, id tanan sikandan diyot Betania amoy'd livod diyot Jerusalem. To riyon pa sikandan to daan, id gutasan si Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na, nopantow rin iddos kayu nod ngoranan to igera no maapung kos do-un. To kodporani rin taddot kayu amoy'd ontongngan din ko duwon bunga, paanan da en mgo do-un kos nokita rin, oyyos konna pa timpu nod bovunga iddon kayu. ");
INSERT INTO oboNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","De-en kahi rin diyot kayu to, “Pomon ko-ungkay, konna kad od bovunga.” Na, norinog idda taddot mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","To kod-inguma onni Disas diyot Jerusalem, mid undiyon sikandin to templo, woy id pa-awa rin iddos od pombovoligya riyot lama woy dos od pombovolli rutun. Id ponlingkuwab din iddos mgo lomisa taddot mgo tohodbullas to soopi, woy id pompiloy rin iddos mgo unsaran taddot od pombovoligya to mgo soopati. ");
INSERT INTO oboNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Waa rin po-ukita iddos mgo minuvu nod piyod to ahad ondan no od baya riyot lama to templo. ");
INSERT INTO oboNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na id nonaw sikandin diyot mgo minuvu. Kahi rin to, “No-ikahi riyot Nosulat no Kahit Monama no, ‘Iddos Baoy't Monama, od ngoranan no baoy atag to koddasaa to langun no minuvu ka-ay to ampow't ingod.’ Piru sikiyu, id bovallan dow moho ini nod oubpan to mgo tokawon.” ");
INSERT INTO oboNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","To norinog taddot mgo ponguu to tohodbuwis woy taddot mgo tohodnonaw to Suhu ni Moises iddos id puungan ni Disas, id nangkap dan to po-ukit to kod-imatoy kandin. Oyyos novaakkan dan kandin, su iddos mo-uraan minuvu, oray'n notoosan woy nosoobbuwan taddot nonaw rin. ");
INSERT INTO oboNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","To id saop don kos allow, id tanan onsi Disas diyot Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","To nosollom don to id livod sikandan diyot Jerusalem, noliharan dan iddos kayu no igera woy nokita ran no nahangu ron idda pomon to ubbus taman to dalig. ");
INSERT INTO oboNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na, nosompottan ni Pedro iddos id oseng ni Disas diyot kayu no igera woy mid ikahi sikandin to, “Tohodnonaw, ontongngiyu! Ikos kayu nid osengan du govoni no konnad od bovunga, nahangu ron!” ");
INSERT INTO oboNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kahin Disas kandan to, “Pomakoy kow to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Bonnaavonnaa nod ikohiyon ku koniyu, no iddos ahad ondoy nod pomakoy to Monama woy waa kodduworuwa, od kogaha rin tod ikahi kos buvungan to, ‘Ko-onnat ka woy'd poko-antug diyot dahat,’ na od puungan en idda to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","De-en od ikohiyan ku sikiyu, no ahad ondan kos od buyuwon dow riyon to Monama, pomokaya row no notanggap dowd idda woy od kotanggap dow en idda. ");
INSERT INTO oboNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na, otid dasaa kow woy duwon poron id tota-aw row no morat no ginawa riyot duma, posinsya-i row sikandin amoy'd posinsyan kow mandad to Amoy row riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Su otik dii row od posinsyan iddos duma, dii kow mandad od posinsyan to Amoy row riyot datas to langit.” ");
INSERT INTO oboNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na, id inguma mandon onsi Disas diyot Jerusalem. Laggun tid ipanow sikandin diyot lama to templo, id porani kandin iddos mgo ponguu to tohodbuwis, dos mgo tohodnonaw to Suhu ni Moises woy dos od pombuyyahon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mid intud sikandan ki Disas, kahi ran to, “Ondak kotungud du ka-ay't langun nid puungan du? Woy ondoy kos id boggoy kikow ka-ay'n kotungud?” ");
INSERT INTO oboNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kahin Disas kandan to, “To dii ku pa od tovakon kos intud dow, duwon intud ku koniyu. Tovaka row ini, woy id ponudtuu ku koniyu ko ondoy kos id boggoy koddi to kotungud to kodpuung ka-ay. ");
INSERT INTO oboNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Iddos kotungud ni Juan to kodboutismu, id pomon bo riyot Monama o riyot minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na, id posisipoy ran kod monnuwon dan idda tod tavak. Kahi ran to, “Otid ikahi ki no, ‘Iddos Monama kos id boggoy kandin to kotungud,’ na od ikahi sikandin to, ‘Mambot waa kow id pomakoy ki Juan?’ ");
INSERT INTO oboNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Piru otid ikahi ki no, ‘Minuvu kos id boggoy kandin to kotungud,’ na od kolingasa kos mgo minuvu keta.” (Od kovaakkan dan to mgo minuvu, su nosorollan to langun no propeta en si Juan.) ");
INSERT INTO oboNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","De-en id tavak dan si Disas to, “Waa koy nokosaddoo ko ingkon idda id pomon.” Na kahin Disas kandan to, “Ko ungketen, dii ku mandad sikiyu od ponudtulan ko ingkon id pomon kos kotungud ku to kodpuung ka-ay.” ");
INSERT INTO oboNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na ponayun mid nonaw si Disas ukit to ponunggelengan, kahi rin to, “Duwon sokkad no minuvu no id pomuwa to ubas diyot kamot din. Id kuralan din idda woy mid bovaa sikandin to toviran to ubas, woy id poohinat sikandin to motikang no sabbung no od ubpan tod tamong tadda. Nopongnga, id popursintuwan din iddos kamot woy mid undiyon sikandin to osson ingod. ");
INSERT INTO oboNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","To timpu ron to kodpomupu to ubas, id suhu rin kos sudsuhuwon din diyot id pomursintu amoy'd angoy to kandin no taad. ");
INSERT INTO oboNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Piru to kod-inguma taddot sudsuhuwon din, id ammot dan sikandin, id pomodasan woy id po-uli no waa nopiyod. ");
INSERT INTO oboNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pomon tadda, id suhu mandon taddot komunoy iddos ossa pa no sudsuhuwon. To id inguma sikandin dutun, id pomipitan dan kos uu rin woy ayas dan id po-ilawan. ");
INSERT INTO oboNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na, id suhu mandon taddot komunoy iddos sokkad pa no sudsuhuwon, piru id imotayan dan sikandin. Woy duwon pa mo-uraa nid suhu rin, piru iddos duma, id pomodasan dan woy dos duma, id pon-imotayan dan. ");
INSERT INTO oboNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Iyon dobbo nosama nod kosuhu rin, iddos soosokkad no anak din no id dokollan din to ginawa. Purisu idda en kos id suhu rin, su kohingginawa rin no, ‘Od rispituwon dan en inis anak ku.’ ");
INSERT INTO oboNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Piru to noko-inguma ron iddos anak din, id po-ikohiyoy iddos id pomursintu to, ‘Ika ron kos anak to komunoy. Kuo kid, od imotayan ta sikandin amoy siketa ron kos od pokokomunoy ka-ay't ubasan!’ ");
INSERT INTO oboNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","De-en id goyod dan sikandin, id imotayan woy id lumbag dan iddos lawa rin diyot leggua to ubasan.” ");
INSERT INTO oboNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Na kahin Disas to, “Ondan ayu kos od puungan taddot komunoy to ubasan? Od undiyonnan din iddos id pomursintu woy'd imotayan, woy od popursintuwan din to ossa iddos ubasan. ");
INSERT INTO oboNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Waa kow vo nokovasa taddot Nosulat no Kahit Monama no mid ungketen to, ‘Iddos batu no id oovoddan to mgo tohodbovaoy su kunan dan ko waa koru-anon, idda vos en kos batu no mosalig no po-unsaran. ");
INSERT INTO oboNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dos od Longaggon kos id puung tadda, woy motoos idda nod tongtongngan.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","To norinog idda taddot mgo ponguu to Judio, noovottan dan no sikandan kos id suhat din. De-en od omotton dan nanoy sikandin, piru novaakkan dan taddot mo-uraan minuvu nid pominog kandin. Purisu mid awa iddos mgo ponguu woy id ipanow. ");
INSERT INTO oboNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na, to id awa ron iddos mgo ponguu to Judio, duwon mandad duma pon mgo Pariseo woy mgo minuvu ni Herodes no id suhu ran nod intud ki Disas amoy od posaharon dan sikandin ukit to osengan din. ");
INSERT INTO oboNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","To kod-inguma ran, mid ikahi sikandan to, “Tohodnonaw, nokosaddoo koy no bonnaa en kos nonaw ru. Nosorollan doy no iddos ahad ondoy nod isowwon du, id pod-iling du kos kodnonaw kandan, oyyos waa od podmusingon du woy iyon du id nonaw, iddos kovonnaan moka-atag to id kopi-it Monama. De-en duwon intud doy kikow. Diyot mgo Suhu ni Moises, ollog bo iddos kodbayad to buhis diyot hari to Roma o dii?” ");
INSERT INTO oboNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Piru nosorollan ni Disas iddos kodpo-uvag-uvag dan. De-en kahi rin to, “Mambo man tod geddaman a nikiyu? Pokitanna a to soopi to Roma.” ");
INSERT INTO oboNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","De-en id toyawwan dan si Disas to soopi. Na mid ikahi sikandin to, “Ondoy man bonnong woy ngaran kos od kokita ka-ay?” Mid tavak sikandan to, “Iddos hari to Roma.” ");
INSERT INTO oboNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kahin Disas to, “Ko ungketen, boggoy row riyot hari to Roma iddos kandin, woy boggoy row riyot Monama iddos kandin.” Na, nosoobbuwan dan oraroy taddot tavak ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na, duwon mgo Saduseo no id porani ki Disas. Inin mgo minuvu, konnod pomakoy nod bodnawon to Monama iddos id poomatoy ron. ");
INSERT INTO oboNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Kahi ran to, “Tohodnonaw, nosulat diyot mgo Suhu ni Moises, no otik duwon mama nod patoy no waa anak dan taddot sawa rin, ko-ilangan no od pomoowwon idda to suwod din amoy'd poko-anak dan atag taddot id patoy. ");
INSERT INTO oboNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ponunggeleng, duwon pittun toosuwod no mama. Iddos kinokokayan, id osawa, piru id patoy no waa anak. ");
INSERT INTO oboNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na, id pomau taddot ari iddon ba-ay. Id patoy mandad sikandin no waa anak. Ungketen dad en mandad kos notomanan taddot iko-otollun suwod din. ");
INSERT INTO oboNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Langun taddot pittun toosuwod, noko-osawa taddot ba-ay, piru waa ran man noko-anak. Diyot mori, id patoy mandad iddos ba-ay. ");
INSERT INTO oboNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na, init allow to kodbadnow taddot id poomatoy ron, ondoy musing kandan kos tullid no sawa taddot ba-ay? Su iddos langun tat pittun toosuwod, noko-osawa man kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mid tavak si Disas to, “Soyup kow, oyyos waa kow nokaabbot taddot Nosulat no Kahit Monama woy taddot kotuusan to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Su otid bodnawon don iddos id poomatoy ron, konnad en sikandan od po-osoway, oyyos od poko-iling don sikandan to mgo ponolihan diyot datas to langit no konnod po-osoway. ");
INSERT INTO oboNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na moka-atag to kodbadnow taddot id poomatoy ron, waa kow vo nokovasa taddot id sulat ni Moises moka-atag taddot id oseng to Monama kandin diyot mid loglog no sopinit? Kahi rin to, ‘Siyak kos Monama ni Abraham, ni Isaac woy ni Jacob.’ Na, ungketen kos no-ikahi ahad nouhoy ron id poomatoy onsi Abraham. ");
INSERT INTO oboNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dos kohulugan tadda, no od kovadnow en iddos poomatoy ron, oyya su iddos Monama, konna sikandin Monama taddot id poomatoy ron, ko konna, Monama taddot nongo-uyag. De-en soyup kow!” ");
INSERT INTO oboNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na, duwon tohodnonaw to mgo Suhu ni Moises no id pominog taddot id ikahi ni Disas diyot mgo Saduseo. Nosorollan din no ollog en iddos mgo tavak ni Disas taddot mgo Saduseo. Na id porani sikandin woy mid intud, kahi rin to, “Ondan man kos suhu no lampas to langun kos koru-anon?” ");
INSERT INTO oboNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mid tavak si Disas to, “Ini en kos suhu no lampas to langun kos koru-anon. Sikiyu no koubbaran ni Israel, pominogga row ini! Sokkad da kos Longaggon ta no idda en so Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ginowanniyu kos Monama nod Longaggon du riyot tivuk no pusung du, diyot tivuk no umuu ru, diyot tivuk no poomdom du woy riyot tivuk no konokkaan du. ");
INSERT INTO oboNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na, ini en kos iko-oruwon suhu no lampas to langun kos koru-anon. Ginowanniyu kos duma iling to kodginawa ru to ko-ugolingun du. Worad en osson suhu no lampas pa ka-ay't oruwa.” ");
INSERT INTO oboNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iddos tohodnonaw to mgo Suhu ni Moises, mid ikahi to, “Tohodnonaw, ollog kos tavak du, oyyos sokkad da kos Monama woy worad en ossa. ");
INSERT INTO oboNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Woy bonnaa en iddos id oseng du no od ginowannan ta kos Monama riyot tivuk no pusung ta, diyot tivuk no poomdom woy riyot tivuk no konokkaan ta. Bonnaa en mandad nod ginowannan ta iddos duma iling to kodginawa ta to keton ko-ugolingun. Dakkoo kos koru-anon taddot id loow no oyama no id buwis diyot Monama, piru lampas pa no dakkoo kos koru-anon otid tumanon ta inis oruwon suhu.” ");
INSERT INTO oboNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","To norinog ni Disas no ollog iddos tavak din, mid ikahi sikandin to, “Asow kad od kolonug to kodharit Monama.” Nopongnga idda, worad od poko-aku nod intud ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Laggun tid nonaw si Disas to mgo minuvu riyot templo, mid intud sikandin, kahi rin to, “Mambo man tid ikahi iddos mgo tohodnonaw to Suhu ni Moises no lubbad ni David iddos Mesiyas? ");
INSERT INTO oboNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Oyya su iddot no-iroomman si David to Uhis no Ispiritu, id oseng sikandin to, ‘Mid ikahi iddos Monama riyon tod Longaggon ku no, Unsad ka lomig to kowanan ku taman tod kotalu kud iddos od pongkuntra kikow.’ ” ");
INSERT INTO oboNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na ponayun mid ikahi si Disas to, “Si David en kos id oseng no iddos Mesiyas, Longaggon din. Ko ungketen, iddos Mesiyas, konna ra lubbad ni David, ko konna, Longaggon din mandad.” Na, notoosan nid pominog iddos mo-uraan minuvu taddot nonaw ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na ponayun mid nonaw si Disas, kahi rin to, “Bantoy kow taddot mgo tohodnonaw to Suhu ni Moises no od kotoosan nod oumpak to mowwet woy'd pokitakita to mgo minuvu. Id kopi-i ran nod kumustan woy'd rispituwon diyot od kolivuungan to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Otik diyon sikandan to simba-an to mgo Judio o riyot pista, id kopi-i ran nod unsad diyot mgo unsaran no id panoy atag taddot od rispituwon no mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Id okalan dan iddos mgo ba-ay'n bau amoy od ka-ahaw ran iddos koruwonnan dan. Woy amoy od kotombunan iddos morat no pinuungan dan, od poowetton dan kos dosalon dan no uvag kun no moppiya sikandan no mgo minuvu. Purisu lampas en no moka-arat-arat iddos silut to Monama kandan.” ");
INSERT INTO oboNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Na, id ounsad si Disas diyot isowwan to tootawwan to soopi riyot templo, woy id tongtongngan din iddos mo-uraan minuvu no id ta-aw to soopi rutun. Woy mo-uraa kos od koruwonnan nid ta-aw to dakkoon soopi. ");
INSERT INTO oboNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Duwon mandad sokkad no worowora no ba-ay'n bau nid inguma, woy id ta-aw sikandin to oruwon pisus. ");
INSERT INTO oboNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Na, id poporani ni Disas iddos mgo tinodduwan din woy kahi rin to, “Bonnaavonnaa nod ikohiyon ku koniyu, no dakkoo pa kos id boggoy ka-ay't worowora no bau kuntra taddot langun no nokovoggoy. ");
INSERT INTO oboNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Su iddos id boggoy to dakkoon soopi, sama robbo idda taddot langun no koruwonnan dan. Piru inin bau, ahad worowora sikandin, id boggoy rin iddos sapuu uvag no soopi rin.” ");
INSERT INTO oboNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na, to id leggua si Disas diyot templo, sokkad taddot mgo tinodduwan din, mid ikahi to, “Tohodnonaw, ontongngiyu man kos motoos no templo no id bovallan pomot doorakkoon batu.” ");
INSERT INTO oboNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kahin Disas to, “Oyya, motoos en woy dakkoo, piru od inguma kos timpu no wora ahad sokkad duwot mgo batu no id podluntudluntud nod kosama, oyyos od gobban en.” ");
INSERT INTO oboNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","To riyon don sikandan to Buvungan to mgo Olibo, id unsad si Disas nid isau riyot templo. Na mid intud kandin onsi Pedro, si Santiago, si Juan woy si Andres no siksikandan da. ");
INSERT INTO oboNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Kahi ran to, “Ponudtuli koy, kannu man od kotuman inis id oseng du, woy ondan kos kilaannan no asow ron od kotuman inis langun?” ");
INSERT INTO oboNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mid tavak si Disas to, “Bantoy kow no konna kow od ko-okalan. ");
INSERT INTO oboNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Su mo-uraa kos od loppow no od po-uvag-uvag nod piyod to koddin ngaran nod ikahi no, ‘Siyak en kos Mesiyas,’ woy mo-uraa kos od ko-okalan dan. ");
INSERT INTO oboNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Otid pokorinog kow no duwon gira ka-ay't morani woy riyot moriyu, yo kow'd kovaakki. Oyyos ko-ilangan en nod kotuman ini langun, piru konna pa ini kos kotompusan to ingod. ");
INSERT INTO oboNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Su iddos sokkad no ingod, od pokidgira to osson ingod, woy dos sokkad no kohoriyan, od pokidgira to osson kohoriyan. Duwon mandad mgo linug diyot nokod-osso-osson lugaa woy duwon dakkoon gutas. Na ini langun, tigkonayan da to kosupittan, iling taddot mosakit nod geddamon to ba-ay nod sokalan. ");
INSERT INTO oboNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Piru sikiyu, bantoy kow su id boggoy kow riyot bollad to mgo tohodhukum, woy od ponlompossan kow nikandan diyot mgo simba-an to Judio. Od piyoddon kow nikandan diyot isowwan to mgo gubernador woy mgo hari pomon to kopomakoy row koddi. Na, idda ron en kos timpu no od pokoposivonnaa kow kandan moka-atag koddi. ");
INSERT INTO oboNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Oyyos to dii pa od inguma iddos kotompusan to ingod, ko-ilangan no unna pa id ponudtuu kos Moppiyon Dinoggan diyot langun no minuvu ka-ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Otid piyoddon kow nikandan diyot tohodhukum, yo kow'd kaanu ko ondak od osengon dow. Iddon timpu, iddos Monama kos od boggoy koniyu to kotuihan, su iddos osengan dow, konna pomon koniyu, ko konna, pomon to Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Na iddon timpu, duwon mgo toosuwod nod unoy od boggoy to suwod dan diyot bollad to dumon minuvu amoy'd po-imotayan. Ungketen dad en mandad iddos mgo amoy, id boggoy ran kos mgo anak dan amoy'd po-imotayan. Idda mandad so mgo anak, od atu to amoy woy inoy ran woy'd po-imotayan dan. ");
INSERT INTO oboNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na, id kolingasa-i kow to langun no minuvu pomon to kopomakoy row koddi. Piru iddos ahad ondoy nod ti-is to kosupittan taman to kotompusan, od kotobbus en.” ");
INSERT INTO oboNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Na ponayun mid ikahi si Disas to, “Od inguma kos timpu no od kokita row riyot lugaa no konna en ollog nod tawwan, iddos od piyod to kororattan amoy'd supak to Monama. (Atag taddot od basa ka-ay, ko-ilangan nod loblovotton dow ini). Otid inguma ron inin kotomanan, iddos id pon-oubpa riyot Judea, ko-ilangan nod paahuy riyot buvunganon. ");
INSERT INTO oboNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iddos minuvu no riyot atop to baoy rin, ko-ilangan no konnad sikandin od usok diyot baoy amoy'd ponemmos pa. ");
INSERT INTO oboNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Idda mandad so minuvu riyot kamot din, ko-ilangan no dii ron od uli amoy'd angoy to umpak din. ");
INSERT INTO oboNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Woy iddon timpu, moko-eru-eru iddos mgo movoddos woy dos duwon anak nod susu poron! ");
INSERT INTO oboNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Na, dasaa kow riyon to Monama no iddos kodpaahuy row, konnod pokosasang to timmohonnow. ");
INSERT INTO oboNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Su iddos kosupittoy to iddon timpu, lampas pa taddot kosupittoy pomon poron to tigkonayan to kodbovaa to ingod taman ko-ungkay. Woy worad en od inguma pa no kosupittoy no iling tadda. ");
INSERT INTO oboNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Piru ko waa poobbava-a to Monama iddon timpu, waa en ahad sokkad no minuvu nod ko-uyag. Piru atag da en taddot id pon-aam din, id poobbovan din iddon timpu. ");
INSERT INTO oboNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Na otik duwon mgo minuvu nod ikahi koniyu to, ‘Ontongngi row, ini ron kos Mesiyas,’ o ‘Idda ron sikandin,’ yo kow'd pomakoy kandan. ");
INSERT INTO oboNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Oyyos od loppow en iddos od ikahi no sikandan kun kos Mesiyas, woy dos duma, od ikahi no sikandan kun kos mgo propeta. Od puung dan to mokososoobbu amoy'd aakaa nanoy taddot mgo minuvu nid aam to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pomotawi row! Su id ponudtuu kud tapoy ini koniyu to dii pa od inguma iddon kotomanan.” ");
INSERT INTO oboNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Na, kopongnga iddos timpu to kosupittan, ‘od mosukirom kos allow woy konnad od se-aa kos buwan. ");
INSERT INTO oboNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Od pongko-uug kos mgo bitu-on, woy od pongo-antog iddos duma pa no riyot datas to langit.’ ");
INSERT INTO oboNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na, od kokita to langun iddos lampas no se-aa to kotuusan ku no Anak to Minuvu riyot kod-inguma ku nod dumannan to souhapun. ");
INSERT INTO oboNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Woy id popiyod ku iddos mgo ponolihan ku amoy od limud taddot mgo minuvu nid aam ku pomon diyot ahad ingkon ka-ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Na mid ikahi si Disas to, “Poomdomma row iddos kayu no igera amoy'd pokopohinonaw kow. Otid kokita row nod sosuving don idda, od kosorollan dow no asow ron kos tintollak. ");
INSERT INTO oboNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Iling mandad tadda, otid kokita rowd inin mgo kotomanan, od kosorollan dow no asow ron kos kodlivod ku. ");
INSERT INTO oboNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Bonnaavonnaa nod ikohiyon ku koniyu, no od kotuman en inis langun, to dii pa od poomatoy kos mgo minuvu no no-uyag to inin timpu. ");
INSERT INTO oboNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Od kowora kos langit woy livuta, piru inis mgo kahi ku, dii en od kowora.” ");
INSERT INTO oboNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Piru moka-atag taddot timpu to kodlivod ku, waa ahad sokkad no minuvu no nokosaddoo, ahad iddos mgo ponolihan diyot datas to langit, ahad siyak no Anak to Monama, ko konna, idda ra en so Monamon Amoy. ");
INSERT INTO oboNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","De-en bantoy kow woy panoypanoy kow, oyyos waa row nosorolli ko kannu ini od kotuman. ");
INSERT INTO oboNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Oyya su iddos kodlivod ku, noko-iling to sokkad no minuvu nid ipanow riyot moriyun ingod no waa rin id ponudtuu ko kannu sikandin od livod. Id sanna rin diyot mgo sudsuhuwon din iddos langun no riyot baoy rin, woy dos ipat sokkad kandan, duwon od puungan. Id suhu rin mandad iddos tohodtamong to sobbangan amoy inaayun od panoypanoy to kodlivod din. ");
INSERT INTO oboNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","De-en panoypanoy kow, oyyos waa row nosorolli iddos kodlivod ku iling taddot kodlivod to komunoy to baoy. Waa row nosorolli ko riyot timpu vo nod saop kos allow, riyot tongngovulli vo, to dii pobbo od ka-allow, o riyot timpu vo nod kosollom don. ");
INSERT INTO oboNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Su otik tigkow a od inguma, saddook od ingumannan ku sikiyu no nokotinuhon. ");
INSERT INTO oboNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Inis id ikahi ku koniyu, od ikohiyon ku mandad diyon to langun. Panoypanoy kow!” ");
INSERT INTO oboNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na oruwa robbon allow, idda pa od inguma iddos pista to Kodlihad to Ponolihan woy dos pista to Paan no Waa Potuvu. Dos mgo ponguu to tohodbuwis woy dos mgo tohodnonaw to Suhu ni Moises, id nangkap dan to po-ukit to kod-ammot ki Disas no waa od pokosaddoo woy od po-imotayan dan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kahi ran to, “Konna ta id posasang to pista kos kod-ammot kandin, su saddook od ko-ukag kos mgo minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na, to riyon don onsi Disas to Betania, mid undiyon sikandan to baoy ni Simon no duwon bohok no et-et no no-uliyan don. To mid ka-an sikandan, duwon sokkad no ba-ay nid inguma no id piyod to oray'n mahaa no pomammut. Iddon pomammut, lumbus no nardo no nokota-aw riyot tootawwan no binovallan pomot batu nod ngoranan to alabastro. Id toppu rin iddos liyog taddot tootawwan, woy id daddas din iddos pomammut diyot uu ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Piru duwon mgo minuvu rutun no nolingasa, woy id po-ikohiyoy ran to, “Kuu! Mambo moho tid uuwakkan din ikon pomammut? ");
INSERT INTO oboNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Su otik id boligya pa nanoy ikon pomammut, maanmaan kos kontidad duwon, woy dos bayad, id boggoy riyot mgo worowora.” Ayas dan id sawoy iddos ba-ay. ");
INSERT INTO oboNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Piru kahin Disas kandan to, “Podtohona row ron sikandin. Mambot od sowayon dow sikandin? Su moppiya man iddos id puungan din koddi. ");
INSERT INTO oboNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Su iddos mgo worowora, inaayun dow od koruma, woy ahad ondan no timpu, od kotovangan dow sikandan. Piru siyak, konna a nikiyu inaayun od koruma. ");
INSERT INTO oboNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Inis ba-ay, id puungan din ko ondan kos od kogaha rin, su inis koddaddas din to pomammut ka-ay't lawa ku, id panoy rin atag to kodlobbong koddi. ");
INSERT INTO oboNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Bonnaavonnaa nod ikohiyon ku koniyu, no ahad ingkon ka-ay to ampow't ingod id ponudtuu iddos Moppiyon Dinoggan, id ponudtuu en mandad inis id puungan din koddi amoy'd kosompottan sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na, si Judas Iscariote no sokkad taddot sopuu-oruwon apostoles, mid undiyon to mgo ponguu to tohodbuwis amoy od pomuhawang to kodboligya ki Disas diyot kandan. ");
INSERT INTO oboNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","To norinog dan iddon puhawang, oraroy ran no nahaa woy id totandu ran nod boggoy't soopi ki Judas. De-en id nangkap sikandin to ollog no timpu to kodboligya ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na riyot unnon allow to pista to Paan no Waa Potuvu, id buwis to mgo Judio iddos natit karnero atag to pista to Kodlihad to Ponolihan. Id porani ki Disas iddos mgo tinodduwan din woy mid intud, kahi ran to, “Longaggon, ingkon koy od panoy to keton lavung atag to pista to Kodlihad to Ponolihan?” ");
INSERT INTO oboNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Na, id suhu rin iddos oruwa taddot mgo tinodduwan din woy id ikohiyan din to, “Undiyon kow to bonuwa to Jerusalem, woy rutun, duwon sokkad no mama nod kosinuggung dow no id tiyang to gunsu no duwon oweg. Tundug kow vo kandin diyot baoy nod undiyonnan din. ");
INSERT INTO oboNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Otid inguma kow rutun, osengi row iddos komunoy taddot baoy no, ‘Mid intud iddos Tohodnonaw ko ingkon lomig kos kwartu no od kannan din to kodlavung atag to pista to Kodlihad to Ponolihan duma to mgo tinodduwan din?’ ");
INSERT INTO oboNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na, id pokita rin koniyu iddos mowwag no kwartu riyot iko-oruwon ondana no nopanoy ron tapoy iddos langun nod ko-ilonganon ta. Ponaya row rutun iddos lavung ta.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na, id ipanow iddos oruwon tinodduwan din po-undiyot Jerusalem, woy nokita ran iddos langun nid ikahi ni Disas kandan, woy id panoy ran iddos lavung atag to pista to Kodlihad to Ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","To od kosagkup don, id inguma si Disas diyot baoy duma taddot sopuu-oruwon apostoles. ");
INSERT INTO oboNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Laggun tid ka-an dan, mid ikahi si Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no sokkad koniyu nod tuhon koddi, od boligya koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na oraroy ran no naanu, woy ipat sokkad kandan, mid intud kandin, kahi ran to, “Siyak bo kos od tommanon du?” ");
INSERT INTO oboNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mid tavak si Disas to, “Iddos sokkad koniyu nid aggom to paan ka-ay't yohung duma koddi, sikandin en kos od boligya koddi. ");
INSERT INTO oboNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Oyyos siyak no Anak to Minuvu, od patoy en iling taddot no-ikahi riyot Nosulat no Kahit Monama. Piru moka-arat-arat en kod kotomanan taddot minuvu nod boligya koddi. Moppiya pa nanoy ko waa sikandin nominuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Laggun tid ka-an sikandan, mid angoy si Disas to paan woy id posolamat sikandin diyot Monama. Nopongnga, id toppiktoppik din idda woy id toyyow riyot mgo tinodduwan din, woy kahi rin to, “Owata row ini woy kanna row. Ini en kos lawa ku no id buwis atag koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na, mid angoy sikandin to kupa woy id posolamat sikandin diyot Monama. Nopongnga, id toyyow rin idda riyot kandan woy langun dan id inom tadda. ");
INSERT INTO oboNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kahin Disas kandan to, “Ini en kos longossa ku no id posivonnaa to kodpotonduwoy to Monama. Id tihis kos longossa ku atag to mo-uraan minuvu. ");
INSERT INTO oboNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Bonnaavonnaa nod ikohiyon ku koniyu, no dii ad od uman nod inom to ammis to ubas taman tod inguma ron iddos timpu no od inom a to lammin ammis duma koniyu init timpu nod hari ron kos Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na id kanta ran atag to koddoong to Monama, woy nopongnga, id undiyon dan to Buvungan to mgo Olibo. ");
INSERT INTO oboNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Na, to riyon don sikandan to daan, mid ikahi si Disas to, “Langun dow od paahuy woy'd tanan koddi, oyya su no-ikahi riyot Nosulat no Kahit Monama no, ‘Od imotayan ku iddos tohodtamong to karnero woy od pokodsuwoysuwoy kos mgo karnero.’ ");
INSERT INTO oboNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Piru riyot timpu nod kovadnow ad, od unna a koniyu riyon to Galilea.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Na kahin Pedro ki Disas to, “Ahad od tanan dan langun kikow, konna a en od tanan kikow.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kahin Disas to, “Bonnaavonnaa nod ikohiyon ku kikow, Pedro, no to dii pa od ukkaa kos manuk to ko-oruwa to ini en no bulli, ko-otollu rud tod elle no waa ka id kilaa koddi.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piru ayas pe-en id totandu si Pedro, kahi rin to, “Ahad od patoy a duma kikow, konna ku en id elle no waa ku sikkow nokilaa.” Na, iling dad en mandad tadda kos id ikahi taddot langun no duma rin no tinodduwan. ");
INSERT INTO oboNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","To mid inguma si Disas woy dos mgo tinodduwan din diyot lugaa nod ngoranan to Getsemane, id ikohiyan din sikandan to, “Unsad kow pa ka-ay laggun tod dasaa a.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na id poruma rin onsi Pedro, si Santiago woy si Juan. Id geddam din kos lampas no lanu, woy oray'n movoggat kos ginawa rin. ");
INSERT INTO oboNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kahi rin to, “Lampas kos lanu ku no imman tod patoy ad. Polintotuwos kow pa ka-ay woy yo kow'd tinuhon.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Na id poriyu boyow sikandin diyot ko-unnan, woy rutun, id laangkob sikandin diyot livuta woy id dasaa no otid kopakoy, konna rin od ko-ukitan iddos koosayan nod inguma kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kahi rin to, “Amoy ku, od kopuungan du kos langun. Yo ad po-ukita tod ingumon koosayan. Piru konna inis id kopi-i ku kos od kotuman, ko konna, idda rad en so kikow'n id kopi-i.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","To id livod sikandin diyot otollun tinodduwan din, nokita rin sikandan no nokotinuhon. Kahi rin ki Pedro to, “Simon, nokotinuhon ka vos! Konna ka vo od pokogaha no diid tinuhon ahad sokkad da no uras? ");
INSERT INTO oboNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yo kow'd tinuhon, ko konna, dasaa kow amoy dii kow'd kopiyod diyot kodpuung to saa. Dos ginawa row, od kopiyan nanoy nod puung to motallong, piru iddos lawa row, moomet.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Na, id poriyu mandon boyow si Disas kandan woy mid dasaa sikandin iling taddot unnon dosalon din. ");
INSERT INTO oboNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nopongnga, id livod mandon sikandin diyot mgo tinodduwan din woy nokita rin sikandan no nokotinuhon, su oraroy ron no movoggat kos mata ran. Waa ran nosorolli ko ondan kos id tavak dan kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","To id livod mandon si Disas diyot kandan to iko-otollun timpu, mid ikahi sikandin to, “Mambot id tinuhon kow poron woy'd oimolloy? Ollog don. Id inguma ron kos timpu no siyak no Anak to Minuvu, id boggoy riyot bollad to mgo mosaasaa. ");
INSERT INTO oboNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Onnow kowd, su ini ron kos minuvu nod boligya koddi. Kuo kid, oyyos od tommu kid kandin.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Laggun tod ooseng pa si Disas, idda ron en, id inguma ron si Judas no sokkad taddot mgo tinodduwan din. Id duma kandin iddos mo-uraan minuvu no posidpiyod to mgo polihuma woy mgo badas. Iyon id suhu kandan, iddos mgo ponguu to tohodbuwis, dos mgo tohodnonaw to Suhu ni Moises woy dos od pombuyyahon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tapoy id posaddoo ni Judas kandan iddos kilaannan. Kahi rin to, “Iddos minuvu nod pongumustan ku ukit to kod-arok, sikandin en iddos od nongkapon dow. Na, omotta row sikandin woy piyodda row. Po-ooyyari row sikandin tod tamong.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","De-en to kod-inguma ni Judas, idda ron en, id porani sikandin ki Disas woy mid ikahi to, “Tohodnonaw!” Woy id pongumusta sikandin ki Disas ukit to kod-arok. ");
INSERT INTO oboNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na, id ammot dan si Disas woy id ponoggasan dan tid somad. ");
INSERT INTO oboNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Piru duwon sokkad no minuvu riyot morani no mid tadnus to polihuma rin, woy id tibbas din iddos uripon taddot mowwet no ponguu to mgo tohodbuwis, de-en no-utas kos divauy'n tolinga rin. ");
INSERT INTO oboNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na mid ikahi si Disas diyot mgo minuvu to, “Kriminal a vo su goli kow od piyod to mgo polihuma woy mgo badas to kod-ammot koddi? ");
INSERT INTO oboNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Allow-allow a man duma koniyu nid nonaw riyot templo, piru waa a man nikiyu omotta. Piru od kotomanan ini langun amoy od kotuman iddos no-ikahi riyot Nosulat no Kahit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","To id oseng ni Disas idda, mid tanan kandin iddos langun no tinodduwan din woy id paahuy. ");
INSERT INTO oboNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na, duwon sokkad no konakan no id kokoumbung to monipis no ogget. Id tundug sikandin ki Disas. To od omotton dan mandad nanoy sikandin, ");
INSERT INTO oboNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","iyon dan nosomaddan iddos ogget din, woy nokopaahuy sikandin no nousutan don. ");
INSERT INTO oboNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na, id piyod dan si Disas diyot baoy to mowwet no ponguu to mgo tohodbuwis, woy rutun, id lolivuung iddos langun no ponguu to tohodbuwis, dos od pombuyyahon to mgo Judio woy dos mgo tohodnonaw to Suhu ni Moises. ");
INSERT INTO oboNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Si Pedro, id tintinundug no moriyu boyow taman to noko-inguma sikandin diyot lama to baoy taddot mowwet no ponguu to mgo tohodbuwis. Id ounsad sikandin diyot morani to apuy duma to mgo tohodtamong to baoy, woy id oinarang sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na, iddos mgo ponguu to tohodbuwis woy dos langun no sakup to hukumanan to mgo Judio, id nangkap sikandan to unayan ahad konna bonnaa amoy od uuhon dan to saa si Disas woy'd po-imotayan. Piru waa nokita ran no id uug dan kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mo-uraa kos id posivonnaa to uhus amoy'd uuhon dan to saa si Disas, piru waa nokod-iling iddos kodponudtuu ran. ");
INSERT INTO oboNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na, duwon mgo minuvu no id lohinat amoy'd posivonnaa to uhus moka-atag kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Kahi ran to, “Norinog doy nid oseng si Disas no od gobban din inis templo no binovallan to minuvu, woy daom to otollun allow, od poohinaton din mandon iddos osson baoy no konna binovallan to minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Piru ahad iling tadda kos id oseng dan, waa rad en nokod-iling iddos kodponudtuu ran. ");
INSERT INTO oboNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Na, id lohinat iddos mowwet no ponguu to mgo tohodbuwis diyot isowwan to langun, woy id inturan din si Disas, kahi rin to, “Waa vo id pokotavak du taddot id oseng dan moka-atag kikow?” ");
INSERT INTO oboNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Piru id po-onong-onong da en si Disas. Na, id intud mandon iddos mowwet no ponguu to mgo tohodbuwis, kahi rin to, “Sikkow ve-en kos Mesiyas, dos Anak to od posivontuhon no Monama?” ");
INSERT INTO oboNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mid tavak si Disas to, “Siyak en idda. Od kokita row no siyak no Anak to Minuvu, od unsad lomig to kowanan to Monamon Motuus, woy od kokita row mandad iddos kodlivod ku pomon diyot datas to langit no od dumannan to souhapun.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Na, id bendas taddot mowwet no ponguu to mgo tohodbuwis iddos umpak din pomon to lingasa rin, woy mid ikahi sikandin to, “Konnad ko-ilangan nod angoy ki pa to duma nod posivonnaa taddot saa rin. ");
INSERT INTO oboNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sikiyu ron en kos nokorinog taddot kodsosumpalit din. Ondak od ko-oseng dow ka-ay?” Na langun dan, id ikahi no ollog en sikandin nod silutan to kopotayan. ");
INSERT INTO oboNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Na duwon id pon-ilob ki Disas, woy id tombunan dan kos mata rin woy id ponsuntuk dan sikandin. Kahi ran to, “Otukow ve-en ko ondoy kos mid suntuk kikow!” Idda mandad so mgo tohodtamong to baoy, id pontabpi ran sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Laggun to riyon si Pedro to lama, duwon sokkad no ba-ay nid lihad kandin. Iddon ba-ay, sokkad taddot sudsuhuwon to mowwet no ponguu to mgo tohodbuwis. ");
INSERT INTO oboNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","To nokita rin si Pedro no id oinarang, id porani sikandin nid totongtong ki Pedro, woy kahi rin to, “Sikkow mandad, sokkad ka en no duma ni Disas no toho Nazaret.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piru mid elle si Pedro, kahi rin to, “Waa a nokosaddoo woy waa a moho nokaabbot duwot id oseng du.” Na id leggua sikandin diyot sobbangan to lama, woy idda ron en, duwon manuk nid ukkaa. ");
INSERT INTO oboNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nokita mandon si Pedro taddot ba-ay, woy id osengan din iddos mgo minuvu no id loohinat dutun, kahi rin to, “Ikon minuvu, sokkad en sikandin taddot mgo duma ni Disas.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piru mid elle rad mandon si Pedro. Todtahad, id oseng mandad ki Pedro iddos id pon-loohinat dutun, kahi ran to, “Sokkad ka en no duma ni Disas, su toho Galilea ka man mandad.” ");
INSERT INTO oboNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piru id pongulivot si Pedro nid ungketen to, “Ahad od patoy a pa ko-ungkay ko id ouhus a, su nosorollan to Monama no waa ku en moho nokilaa ikos minuvu nod tommanon dow!” ");
INSERT INTO oboNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Idda ron en, id ukkaa iddos manuk to ko-oruwon timpu. Na, nosompottan ni Pedro iddos id ikahi ni Disas kandin no, “To dii pa od ukkaa kos manuk to ko-oruwon timpu to ini en no bulli, ko-otollu rud tod elle no waa ka id kilaa koddi.” Na, id sinoggow si Pedro woy mopet oraroy kos sinoggawon din. ");
INSERT INTO oboNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","To od ka-allow ron, id pomuhawang iddos mgo ponguu to tohodbuwis, dos od pombuyyahon to mgo Judio, dos mgo tohodnonaw to Suhu ni Moises woy dos langun no tohodhukum ko ondan kos od puungan dan ki Disas. Na, id baku ran kos bollad din woy id piyod dan sikandin diyot ki Pilato no gubernador to Roma. ");
INSERT INTO oboNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Id inturan ni Pilato si Disas, kahi rin to, “Sikkow vo kos hari to mgo Judio?” Mid tavak si Disas to, “No-oseng dud en.” ");
INSERT INTO oboNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na iddos mgo ponguu to tohodbuwis, mo-uraa kos saa no id uug dan ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","De-en id intud mandon si Pilato, kahi rin to, “Norinog du iddos mo-uraan saa no id uug dan kikow. Ondan, waa vo id pokotavak du?” ");
INSERT INTO oboNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Piru waa en id tavak si Disas, de-en oray'n nosoobbuwan si Pilato. ");
INSERT INTO oboNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na ipat pista to Kodlihad to Ponolihan, nooyami ron ni Pilato no od poleggua to sokkad no pinirisu nod buyuwon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iddon timpu, duwon mgo minuvu no noprisu pomon to kodsupak dan to guberno. Sokkad kandan, id ngoranan ki Barabas no noko-imatoy to minuvu riyot nosamuk don. ");
INSERT INTO oboNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","To id undiyot ki Pilato iddos mo-uraan minuvu, id buyu ran nod polegguangon din iddos sokkad no pinirisu, su idda me-en kos od puungan din ipat lahun. ");
INSERT INTO oboNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na mid intud si Pilato kandan, kahi rin to, “Od kopiyan kow vo nod polegguangon ku inis Hari to mgo Judio?” ");
INSERT INTO oboNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Id oseng ni Pilato idda, su nosorollan din no iddos mgo ponguu to tohodbuwis, kosina kos unayan no id boggoy ran si Disas diyot bollad din. ");
INSERT INTO oboNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Piru id sutsutan taddot mgo ponguu to tohodbuwis iddos mgo minuvu, no iyon dan od buyuwon nod polegguangon, si Barabas, konna si Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Id intud mandon si Pilato, kahi rin to, “Ondak id kopi-i row nod puungan ku ka-ay't minuvu no id ngoranan dow no Hari to mgo Judio?” ");
INSERT INTO oboNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na id pehes dan no mid ungketen to, “Id pakpak sikandin diyon to krus!” ");
INSERT INTO oboNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kahin Pilato kandan to, “Mambo? Ondan man kos saa no nopuungan din?” Piru ayas pe-en id pehes iddos mgo minuvu nid ungketen to, “Id pakpak sikandin diyon to krus!” ");
INSERT INTO oboNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","De-en id poleggua ni Pilato si Barabas su id kopi-i rin nod kahaa kos mgo minuvu, woy id polompossan din si Disas. Nopongnga, id boggoy rin sikandin diyot bollad to mgo sundau amoy id pakpak diyon to krus. ");
INSERT INTO oboNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na, id piyod to mgo sundau si Disas diyot lama to baoy't gubernador, woy id livuung dan iddos langun no duma ran no mgo sundau. ");
INSERT INTO oboNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Id umpakan dan si Disas tod momoollutun umpak iling to umpak to hari. Id podlambed dan iddos duhiyon no baahon, woy id bovallan dan idda no kuruna no id takos diyot uu ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na, id po-uvag-uvag dan nod posivantug kandin woy kahi ran to, “Muopa nod mowwet kos umuu ru, sikkow no hari to mgo Judio!” ");
INSERT INTO oboNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na id pomipitan dan kos uu rin to bookayu, woy id pon-ilobban dan sikandin, woy id ponlingko-od dan diyot isowwan din no uvag kun tod simba ran kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nopongnga ran sikandin tid sumpalit, id lusut dan iddos od momoollutun umpak woy id posukub dan mandon iddos kandin no umpak. Nopongnga, id piyod dan sikandin diyot leggua amoy id pakpak diyon to krus. ");
INSERT INTO oboNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Laggun to riyon sikandan to daan, nokosuggung dan to sokkad no minuvu no toho Cirene no id pomon diyot bariyu. Id pohos dan sikandin nod tiyang taddot krus ni Disas. (Dos ngaran din, si Simon no amoy onni Alejandro woy Rufo). ");
INSERT INTO oboNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Id piyod dan si Disas diyot lugaa nod ngoranan to Golgota, no iddos kohulugan, lugaa to Bongovongo. ");
INSERT INTO oboNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Od boggayan dan si Disas to binu no id sombutan to bawi nod ngoranan no mira, piru waa sikandin id inom tadda. ");
INSERT INTO oboNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Na, id pakpak dan sikandin diyon to krus. Id bunutbunut dan atag taddot ogget ni Disas ko ondan kos od kokomunoy to ipat sokkad kandan. ");
INSERT INTO oboNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mgo alas nuwebe to sollom kos uras to kodpakpak dan ki Disas diyon to krus. ");
INSERT INTO oboNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na riyot korotula, nokosulat iddos saa no id uug dan kandin no mid ungketen to, “Ini en si Disas no Hari to mgo Judio.” ");
INSERT INTO oboNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na, duwon oruwon kriminal no id pakpak dan mandad diyon to krus no riyot tapad ibpit ni Disas. Iddos sokkad, diyon lomig to kowanan din woy dos sokkad, diyon lomig to ivang. ");
INSERT INTO oboNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ukit ka-ay, notuman iddos no-ikahi riyot Nosulat no Kahit Monama no mid ungketen to, “Diyot kod-ontong to mgo minuvu, id po-iling sikandin to sokkad no kriminal.” ");
INSERT INTO oboNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na iddos mgo minuvu nid lihad dutun, id ponlingi-lingi ran woy id sumpalit dan sikandin. Kahi ran to, “Tomman du, od gobban du iddos templo woy'd poohinaton du mandon daom da to otollun allow! ");
INSERT INTO oboNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Otik mooggot en iddos id oseng du, tovangiyu kos ko-ugolingun du woy ponog ka ruwot krus!” ");
INSERT INTO oboNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ungketen dad en mandad kos id puungan taddot mgo ponguu to tohodbuwis woy dos mgo tohodnonaw to Suhu ni Moises. Id sumpalit dan sikandin, kahi ran to, “Te, id tovangan din kos duma, piru dii man sikandin od pokotavang to ko-ugolingun din! ");
INSERT INTO oboNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Otik bonnaa en no sikandin kos Mesiyas no Hari to Israel, od pokoponog nanoy sikandin duwot krus amoy od kokita ta woy'd pomakoy ki kandin.” Na, ahad iddos oruwon minuvu no id pakpak diyon to krus no riyot tapid ibpit din, id sumpalit mandad kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na, to moko-untud don kos allow, tigkow id mosukirom kos intirut ingod daom to otollun uras. ");
INSERT INTO oboNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","To alas tres don to mapun, id pehes si Disas to monokkaa no mid ungketen to, “Eloi, Eloi, lema sabactani,” no iddos kohulugan, “Monama ku, Monama ku, mambot id tonanan a nikkow?” ");
INSERT INTO oboNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","To norinog idda taddot dumon minuvu no id loohinat dutun, mid ikahi sikandan to, “Id umow rin si Elias!” ");
INSERT INTO oboNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Na, duwon sokkad no minuvu nid lungkossu woy id angoy sikandin to immat bukoo nid aggom diyot suka, woy id takos din idda riyot ubpu to panga to kayu. Nopongnga, id bullow rin idda amoy id po-inom kandin. Mid ikahi iddos minuvu riyot mgo duma rin to, “Od ongatan ta kod loppow vo si Elias amoy od angoy kandin duwot krus.” ");
INSERT INTO oboNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Na, id pehes si Disas to monokkaa woy novudtus don kos songnga rin. ");
INSERT INTO oboNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iddos oray'n mokoppaan kurtina riyon to templo, novendas pomon diyot datas po-undiyot dosiyung. ");
INSERT INTO oboNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","To norinog taddot kopitan to mgo sundau no id lohinat diyot isowwan to krus iddos kodpehes ni Disas, woy to nokita rin iddos notomanan, mid ikahi sikandin to, “Mooggot bos en no Anak sikandin to Monama!” ");
INSERT INTO oboNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na, duwon mandad mgo ba-ay nid pomantow. Sikandan onsi Maria no toho Magdala, si Salome, woy si Maria no inoy ni Jose woy dos ari rin no si Santiago. ");
INSERT INTO oboNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sikandan iddos mgo ba-ay no id dumoruma ki Disas, woy id tavang kandin to riyon pa sikandin to Galilea. Duwon mandad mo-uraa pon mgo ba-ay no id duma kandin to kod-undiyon din to Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na iddot kodpatoy ni Disas, nokosasang idda to allow to kodpanoy atag to Allow't Kod-imolloy. De-en to id saop don kos allow, duwon minuvu nid inguma no id ngoranan ki Jose no toho Arimatea. ");
INSERT INTO oboNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Sokkad sikandin nod rispituwon no sakup to Mowwet no Hukumanan to mgo Judio, woy id aangat sikandin to timpu to kodharit Monama. To iddon mapun, waa sikandin id aang-aang nid undiyot ki Pilato, woy id buyu rin nod ongayon iddos bangkoy ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","To kodbuyu ni Jose tadda, nosoobbuwan si Pilato, su kunan din ko waa pa id patoy si Disas. Na id po-umow rin iddos kopitan to mgo sundau, woy id inturan din ko mooggot be-en no id patoy ron si Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Id ikahi iddos kopitan to mgo sundau no id patoy ron en si Disas, de-en id aman si Pilato no od ongayon ni Jose iddos bangkoy ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pomon tadda, id ipanow si Jose. Id bolli sikandin to mahaa no ogget, woy id angoy rin iddos bangkoy ni Disas diyon to krus woy id bukusan din idda taddot ogget. Nopongnga, id ta-aw rin idda riyot lovongngan no id bongbangan no pahang iling to langub. Duwon dakkoon batu rutun no id lokkob din taddot lobbong. ");
INSERT INTO oboNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na, nokita ni Maria no toho Magdala woy ni Maria no inoy ni Jose ko ingkon din lomig id lobbong iddos bangkoy ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","To id lihad don iddos Allow't Kod-imolloy, id bovolli to pomammut onsi Maria no toho Magdala, si Salome woy si Maria no inoy ni Santiago, su od undiyon dan to lobbong amoy'd busbusan dan to pomammut iddos bangkoy ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na, sollom poron to allow't Linggu to lammi pa id bottuk allow, mid undiyon sikandan to lobbong ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","To waa pa sikandan id inguma rutun, id po-inturoy ran nid ungketen to, “Ondoy kos od po-ibpit taddot batu no riyot sobbangan to lovongngan din?” ");
INSERT INTO oboNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Piru to kod-inguma ran dutun, nokita ran no noko-ibpit don iddos batu. ");
INSERT INTO oboNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","To id usok don sikandan, nokita ran no duwon sudduwan no mama no moputi kos umpak, woy mid unsad sikandin diyon lomig to kowanan dan, woy novaakkan sikandan. ");
INSERT INTO oboNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kahi rin kandan to, “Yo kow'd kovaakki. Nokosaddoo a nod nangkap kow ki Disas no toho Nazaret no id pakpak diyon to krus. Piru worad sikandin ka-ay, su id badnow ron! Ontongngi row man ikos lugaa nid tawwan kandin. ");
INSERT INTO oboNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na ipanow kow, woy ponudtuu row ini riyot mgo tinodduwan din, labbi ron en ki Pedro. Osengi row no id unna ron si Disas diyot Galilea, woy rutun, od kokita ran sikandin iling taddot id ponudtuu rin kandan.” ");
INSERT INTO oboNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na, id ponleggua ran diyot lovongngan woy id pompaahuy sikandan, su id kookoo ran to mattag allak. Waa ahad sokkad no id ponudtulan dan oyyos novaakkan dan. ");
INSERT INTO oboNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na, to novadnow ron si Disas to sollom poron to allow't Linggu, unna sikandin id pokita ki Maria no toho Magdala no id losuran dangan to pittun busow nid poleggua rin. ");
INSERT INTO oboNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nopongnga idda, id undiyonnan ni Maria iddos mgo tinodduwan ni Disas. No-ingumannan din sikandan no id ponlanu woy id ponsinoggow. ");
INSERT INTO oboNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","To norinog dan iddos ponudtulon ni Maria no nokita rin si Disas no novadnow ron, waa ran id pongimbonnaa. ");
INSERT INTO oboNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nopongnga id pokita si Disas ki Maria no toho Magdala, id pokita mandad sikandin diyot oruwa taddot mgo tinodduwan din laggun tod ipanow ran pomon diyot bonuwa. Piru waa ran go-os nokokilaa kandin su nopalin kos boyo rin. ");
INSERT INTO oboNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na, id livod sikandan diyot Jerusalem amoy id ponudtuu ran diyot mgo duma ran no nokita ran si Disas, piru waa mandad sikandan id pongimbonnaa. ");
INSERT INTO oboNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Diyot mori, id pokita si Disas diyot sopuu-sokkad no tinodduwan din laggun tid ka-an dan. Id sawoy rin sikandan, su kulang kos kopomakoy ran woy motoggas kos uu. Oyyos waa ran man id pongimbonnaa taddot osengan to mgo minuvu no nokokita no novadnow ron sikandin. ");
INSERT INTO oboNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na kahin Disas kandan to, “Undiyon kow to langun no tribu ka-ay to ampow't ingod, woy id ponudtuu row kos Moppiyon Dinoggan diyon to langun. ");
INSERT INTO oboNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dos ahad ondoy nod pomakoy woy'd poboutismu, od kotobbus en. Piru iddos konnod pomakoy, od silutan to kopotayan. ");
INSERT INTO oboNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Woy dos od pomakoy koddi, od boggayan to kotuusan to kodpuung to mokososoobbu. Oyyos od pokopoleggua sikandan to mgo busow woy od poko-oseng dan to mgo kinohiyan no waa ran nopohinonawwi. ");
INSERT INTO oboNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Otid pokosomad sikandan to mgo uwod woy'd poko-inom dan to ahad ondan nod poko-ilu, konna ran od komonnu. Na, od somaddan dan iddos uu tod pongkovohokan woy od ko-uliyan en.” ");
INSERT INTO oboNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nopongnga mid ikahi si Disas nod Longaggon diyon to mgo tinodduwan din, novatun don sikandin diyot datas to langit, woy mid unsad sikandin lomig to kowanan to Monama. ");
INSERT INTO oboNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na, id ipanow iddos mgo tinodduwan din amoy'd ponudtuu to Moppiyon Dinoggan diyot ahad ingkon no ingod. Id boggayan sikandan tod Longaggon to kotuusan to kodpuung to mokososoobbu amoy od posivonnalan din iddos id ponudtuu ran.");
INSERT INTO oboNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Diyon to kikow, Teofilo no oraroy nod rispituwon. Mo‑uraan minuvu kos id boggoy to dakkoon timpu to kodsulat taddot mgo notomanan dinit keta. ");
INSERT INTO oboNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Id sulat dan iddos id ponudtuu keta taddot mgo minuvu no nokokita ron en to pinuungan ni Disas Krays pomon to tigkonayan, woy sikandan don en kos id ponudtuu to kahi tod Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na Teofilo, id ooyyaran ku ini tid pohinonaw pomon to tigkonayan, su nopuhawang ku mandad nod sulaton iddos moka‑atag ka‑ay'n mgo notomanan, woy id ooyyaran ku ini tid tapid atag kikow. ");
INSERT INTO oboNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Id puungan ku ini amoy'd kosorollan du no mooggot en iddos mgo notomanan no id nonaw kikow. ");
INSERT INTO oboNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na iddot timpu no si Herodes kos hari to Judea, duwon minuvu no id ngoranan ki Zacarias no sokkad no tohodbuwis no id pomon to koubbaran ni Abias. Dos sawa rin no si Elisabet, lubbad mandad to mgo tohodbuwis no koubbaran dad en ni Aaron. ");
INSERT INTO oboNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sikandan no toosawa, paanan motallong diyot kod‑ontong to Monama. Woy riyot kodtuman dan to langun no suhu woy bola‑ud to Monama, waa en id pokosawoy kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Piru waa anak dan, su dii en od poko‑anak si Elisabet woy buyyag don mandad sikandan. ");
INSERT INTO oboNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sokkad no timpu, si Zacarias woy dos mgo duma rin no koubbaran ni Abias, id suvaa ran nod bovuwis diyon to templo. ");
INSERT INTO oboNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na, duwon botasanon to mgo tohodbuwis no od bunutbunut amoy'd kosorollan ko ondan kos pinuungan to ipat sokkad kandan. De‑en si Zacarias kos na‑aam nod poko‑usok diyot templo amoy od loow to insenso. ");
INSERT INTO oboNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Laggun tid loow sikandin to insenso riyot daom, duwon mo‑uraan minuvu no nolivuung diyot leggua no mid dasaa. ");
INSERT INTO oboNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na idda ron en, duwon id pokita kandin no ponolihan to Monama no id lohinat lomig diyot kowanan taddot buwisanan to insenso. ");
INSERT INTO oboNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","To nokita ni Zacarias iddos ponolihan, notigkawan sikandin woy no‑oratan. ");
INSERT INTO oboNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Piru mid ikahi iddos ponolihan to, “Yo kod kovaakki, Zacarias! Id tavak to Monama iddos dosalon du, oyyos si Elisabet no sawa ru, od anak to mama woy ngoraniyu sikandin ki Juan. ");
INSERT INTO oboNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Oraroy ka en nod kahaa pomon kandin, woy mo‑uraa mandad kos od kahaa to kodtobbow rin. ");
INSERT INTO oboNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Su dakkoo kos koru‑anon din diyot kod‑ontong to Monama. Konna sikandin od inom to binu o ahad ondan nod pokohubug no inommon. Od ko‑iroomman sikandin to Uhis no Ispiritu ahad diyon pa sikandin to gottok to inoy rin. ");
INSERT INTO oboNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Od polivoddon din iddos mo‑uraan koubbaran ni Israel nod pomakoy riyot Monama no od simba‑anon to kovuyyahan dan. ");
INSERT INTO oboNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Od unna sikandin tod Longaggon woy duwon kotuusan din nod ponudtuu to kahit Monama iling ki Elias no propeta. Od pod‑uliyon din kos koroniyan taddot mgo amoy woy mgo anak. Woy dos mgo minuvu no diid dumoruma to id kopi‑it Monama, od tanan sikandan to mgo saa ran woy od moraom kos koovottan dan iling to motallong no minuvu ukit to nonaw rin. Na ukit mandad kandin, mo‑uraan minuvu nod kopanoy atag to kod‑inguma tod Longaggon.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Piru mid ikahi si Zacarias diyot ponolihan to, “Momonnu ku od kosorollan nod kotuman kos id oseng du? Oyyos sikami no toosawa, buyyag koyd man.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mid tavak iddos ponolihan to, “Siyak si Gabriel no sinuhuwan to Monama, woy id suhu a nikandin amoy od posaddoo kikow ka‑ay't moppiyon dinoggan. ");
INSERT INTO oboNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Piru pomon to waa ru man pomokaya inis id ponudtuu ku kikow, ini ron en, od ko‑ommow ka taman tod inguma iddos allow no od kotuman don kos langun nid ponudtuu ku.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na iddos mgo minuvu nid aangat ki Zacarias diyot leggua, oray'n nosoobbuwan su nouhoy sikandin diyot daom to templo. ");
INSERT INTO oboNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","To kodleggua rin, konnad sikandin od poko‑ooseng diyot mgo minuvu, de‑en id sinyas dobbo sikandin. Pomon ka‑ay, noovottan dan no duwon id pokita kandin to Monama riyot daom. ");
INSERT INTO oboNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","To nopongnga ron iddos mgo allow to pinuungan ni Zacarias diyot templo, id uli ron sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Waa nouhoy pomon tadda, movoddos don iddos sawa rin no si Elisabet. Woy daom to limmon buwan, waa sikandin id leggua riyot baoy ran. ");
INSERT INTO oboNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Mid ikahi si Elisabet to, “No‑eruwan en koddi iddos Monama, su id awa rin don kos id ko‑ilawi ku riyot mgo minuvu no dii a od poko‑anak.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Na, to annom don no buwan dos kodmovoddos ni Elisabet, id suhu mandon to Monama iddos ponolihan no si Gabriel nod undiyon to Nazaret no sokkad taddot mgo bonuwa no sakup to Galilea. ");
INSERT INTO oboNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Id undiyonnan din iddos mongovay no id ngoranan ki Maria. Na ini si Maria, id posoyuran don ni Jose no sokkad taddot koubbaran ni Harin David. ");
INSERT INTO oboNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","To kod‑inguma taddot ponolihan, mid ikahi sikandin to, “Maria, kahaa ka oraroy, su id pokita tod Longaggon iddos kopiyannoy rin kikow woy od dumannan ka nikandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","To norinog idda ni Maria, oray sikandin no notaong woy waa nokaabbot ko ondan kos kohulugan tadda. ");
INSERT INTO oboNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Piru mid ikahi iddos ponolihan to, “Yo kod kovaakki, Maria! Id aam ka to Monama su nahaa sikandin kikow. ");
INSERT INTO oboNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Od movoddos ka woy'd anak to mama woy ngoraniyu sikandin ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Oraroy sikandin od kovantug woy od kilaannon sikandin no Anak to Monama no Lampas to Langun. Id boggoy kandin to Monama nod Longaggon iddos kohoriyan taddot kovuyyahan din no si David. ");
INSERT INTO oboNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Od hari sikandin to koubbaran ni Jacob taman to waad tomanon, oyya su iddos kodhari rin, dii en od kotaman.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Na mid ikahi si Maria to, “Od monnuwon man, su mongovay a pa?” ");
INSERT INTO oboNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mid tavak iddos ponolihan to, “Od ko‑iroomman ka to Uhis no Ispiritu, woy od koheddam du iddos kotuusan to Monama no Lampas to Langun. De‑en iddos anak nid pototobbow ru, uhis woy'd kilaannon sikandin no Anak to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Poomdommow man iddos ig‑agaw ru no si Elisabet. Ahad id popoomdom kos duma no konnad sikandin od poko‑anak pomon to buyyag don, piru ko‑ungkay, annom don no buwan iddos kodmovoddos din. ");
INSERT INTO oboNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Oyya su atag to Monama, waa en ahad ondan no dii rin od kopuungan.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kahin Maria to, “Sudsuhuwon a to Monama. Muopa nod kotuman ka‑ay't koddi iddos langun no id oseng du.” Na id tanan don kandin iddos ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Waa nouhoy pomon tadda, id logkiyat si Maria nid lukut po‑undiyon to bonuwa no id ubpan onni Zacarias, no riyon lomig to buvunganon no sakup to Judea. ");
INSERT INTO oboNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","To kod‑inguma rin diyot baoy ran, id ponguras sikandin ki Elisabet. ");
INSERT INTO oboNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","To norinog ni Elisabet iddos kodponguras ni Maria, noheddam din no ayas id waong dos anak diyot gottok din. Idda ron en, no‑iroomman sikandin to Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Na, id ooseng sikandin to monokkaa pomon to kahaan, kahi rin to, “Moppiya ka to langun no ba‑ay woy moppiya mandad kos anak duwot gottok du! ");
INSERT INTO oboNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Oraroy a no nahaa, su ondoy a man nod lowwiyon du no inoy tod Longaggon ku. ");
INSERT INTO oboNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Oyyos to norinog ku kos kodponguras du, ayas id waong inis anak ka‑ay't gottok ku pomon to kahaan. ");
INSERT INTO oboNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Moppiya kod kotomanan du, su id pomakoy ka man no od kotuman en iddos id ikahi tod Longaggon.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kahin Maria to, “Od doongon ku en kos Monama nod Longaggon diyot tivuk no pusung ku! ");
INSERT INTO oboNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Woy oray'd kahaa kos ginawa ku taddot Monama no Tohodtobbus ku. ");
INSERT INTO oboNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Oyyos waa a en nikandin lingawi, ahad moobbava a ra no sudsuhuwon din. Pomon ko‑ungkay, od osengon to langun no minuvu no moppiya kod kotomanan ku. ");
INSERT INTO oboNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Oyya su Motuus kos Monama woy mokososoobbu kos id puungan din koddi. Motallong sikandin woy uhis kos ngaran din. ");
INSERT INTO oboNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pomon poron to unnon linubbaran taman ko‑ungkay woy taman to waad tomanon, eeruwon sikandin to langun no minuvu no duwon allak kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Id pokita rin kos kandin no kotuusan ukit to pinuungan din. Id podsuwoysuwoy rin iddos mgo minuvu nod poratasdatas woy'd pobporoong. ");
INSERT INTO oboNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Id pa‑awa rin iddos mgo hari riyot kodponguu ran, woy od porotason din iddos od poobbava. ");
INSERT INTO oboNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Id ivuung din iddos id ponggutasan to kopiyannan, piru id pa‑awa rin iddos pongkoruwonnan no waa en nopiyod. ");
INSERT INTO oboNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Id tovangan ki nikandin no koubbaran ni Israel no uripon din, woy dii en sikandin od kolingow taddot tandu rin nod ko‑eruwan keta. ");
INSERT INTO oboNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Oyya su id tandu rin no id ko‑eru‑i rin si Abraham woy dos koubbaran din taman to waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na, id oubpa pa si Maria riyot ongki Elisabet daom to mgo otollun buwan woy nopongnga, id uli ron sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","To id inguma ron kos timpu nod pototobbow ron si Elisabet, id aanak sikandin to mama. ");
INSERT INTO oboNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na, norinog taddot mgo sumbaoy woy korumannan onni Elisabet no dakkoo kos eru to Monama kandin, woy nahaa sikandan duma kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","To wau ron no allow iddos anak pomon to kodtobbow, id lolivuung sikandan amoy'd tupuwan dos anak. Na, id posangoy ran nanoy iddos anak ki Zacarias no amoy rin. ");
INSERT INTO oboNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Piru mid ikahi si Elisabet to, “Konnod kopakoy! Juan kos id ngaran kandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kahi ran ki Elisabet to, “Mambo man? Waa man moho ahad sokkad no korumannan dow no id ngoranan to Juan.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na, id sinyasan dan iddos amoy ko ondan kos id kopi‑i rin no id ngaran taddot anak. ");
INSERT INTO oboNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Id sinyas sikandin no od boggayan to popii amoy'd sulatan, woy id sulat sikandin no mid ungketen to, “Juan kos ngaran din.” De‑en nosoobbuwan sikandan langun. ");
INSERT INTO oboNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na idda ron en, noko‑ooseng don sikandin woy id doong din kos Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nosoobbuwan iddos langun no sumbaoy ran pomon to ponudtulon moka‑atag taddon notomanan, woy nokoso‑ob idda riyot mgo minuvu no id pon‑ubpa riyot buvunganon no sakup to Judea. ");
INSERT INTO oboNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na iddos langun no minuvu no nokorinog tadda, id popoomdom woy id po‑inturoy. Kahi ran to, “Ondan ayu kod ingumannon ka‑ay'n anak otid dakkoo ron sikandin? Oyyos od kokita man, no riyon en to kandin iddos kotuusan to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na si Zacarias no amoy taddot anak, no‑iroomman to Uhis no Ispiritu, woy id oseng din iddos id poposaddoo kandin to Monama. Kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Od doongon ta iddos od Longaggon no Monama to koubbaran ni Israel, su id undini sikandin amoy'd tobbus to mgo minuvu rin. ");
INSERT INTO oboNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Id po‑undini rin iddos Tohodtobbus no motuus no id pomon to koubbaran ni Harin David no sudsuhuwon din. ");
INSERT INTO oboNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ini en mandad kos id ikahi rin dangan ukit taddot mgo propeta no id aam din. ");
INSERT INTO oboNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Id tandu sikandin no od polegguangon ki nikandin pomon diyot bollad tod pongkuntra keta woy pomon diyot langun nod kolingasa keta. ");
INSERT INTO oboNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Id ikahi mandad sikandin no id ko‑eru‑i rin iddos kovuyyahan ta, woy dii rin od lingawan iddos uhis no kodpotonduwoy rin kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Su ini en kos kodpotonduwoy no id pongulivottan din diyot ko‑opuwan ta no si Abraham, ");
INSERT INTO oboNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","no od polegguangon ki nikandin pomon diyot bollad taddot od pongkuntra keta, su amoy od pokopuung ki atag to Monama no waa id kovaakki ta. ");
INSERT INTO oboNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Woy amoy od molinis woy'd komotallong ki riyot kod‑ontong din taman tod kovudtus kos songnga ta. ");
INSERT INTO oboNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na sikkow mandad no anak ku, od ngoranan ka no propeta to Monama no Lampas to Langun. Od unna ka tod Longaggon, su amoy od panoy to mgo minuvu taddot kod‑inguma rin. ");
INSERT INTO oboNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Od nonaw ka to mgo minuvu rin no od kotobbus sikandan ukit to kodposinsya to Monama taddot mgo saa ran. ");
INSERT INTO oboNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Oyya su iddos Monama ta, eeruwon woy mohingginawa. De‑en id popiyod din iddos Tohodtobbus pomon diyot datas to langit iling to se‑aa to lammid bottun allow. ");
INSERT INTO oboNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Inin se‑aa, od boggoy to ko‑owangan to mgo minuvu no riyot mosukirom woy dos novaakkan to kopotayan. Id potuntuu ki nikandin no od pokod‑uli kos koroniyan ta riyot Monama woy riyon to duma.” ");
INSERT INTO oboNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na, id dakkoo si Juan woy id mosalig kos kopomakoy rin diyon to Monama. Id oubpa sikandin diyot noka‑awoy‑awoy'n lugaa taman tid tigkanoy ron sikandin to kodnonaw to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na iddon timpu, si Augusto no hari to Roma, id poponog to suhu no iddos langun no minuvu riyon to intirut kohoriyan din, ko‑ilangan nod polista. ");
INSERT INTO oboNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Idda en kos unnon kodlista iddot timpu no si Cirenio pa kos gubernador riyot prubinsya to Siria. ");
INSERT INTO oboNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","De‑en posid‑uli iddos langun no minuvu riyot bonuwa to kovuyyahan dan amoy'd polista. ");
INSERT INTO oboNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Si Jose mandad, id ipanow pomon diyot bonuwa to Nazaret no sakup to Galilea po‑undiyon to Betlehem no sokkad no bonuwa to Judea, su idda en kos bonuwa ni Harin David no kovuyyahan din. ");
INSERT INTO oboNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Id poruma rin si Maria nod osowan din no movoddos don iddon timpu. ");
INSERT INTO oboNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","To riyon don sikandan to Betlehem, nokosasang no id pototobbow si Maria. ");
INSERT INTO oboNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Id aanak sikandin to mama no ponganoy rin. Id bukusan din to lamping iddos anak woy id po‑ilogga rin diyot pokannan to oyama, su worad man lugaa riyot baoy nod oowottan to mgo moholiyug. ");
INSERT INTO oboNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Iddon bulli, duwon mgo tohodtamong to karnero riyot posobsavan no morani rutun no id tamong to mgo karnero ran. ");
INSERT INTO oboNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Na, tigkow duwon ponolihan tod Longaggon no id pokita kandan, woy nolingkus dan to se‑aa to kotuusan tod Longaggon woy oraroy ran no novaakkan. ");
INSERT INTO oboNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Piru mid ikahi iddos ponolihan to, “Yo kow'd kovaakki, su id undini a amoy'd posaddoo koniyu to moppiyon dinoggan no od pokovoggoy to dakkoon kahaan to langun no minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Oyya su inin bulli, id tobbow ron diyot bonuwa ni Harin David iddos Tohodtobbus no idda en so Mesiyas nod Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dos patow no mooggot en inis ikahi ku, oyyos od kokita row iddos anak no id bukusan to lamping woy id po‑ilogga riyot pokannan to oyama.” ");
INSERT INTO oboNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nopongnga idda osenga to ponolihan, tigkow id loppow iddos duma rin no maanmaan no ponolihan pomon diyot datas to langit. Id doong dan kos Monama, kahi ran to, ");
INSERT INTO oboNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Od posivontuhan ta iddos Monama riyot datas to langit, woy ka‑ay to ampow't ingod, duwon kosunayan to mgo minuvu no id kahaa‑i rin.” ");
INSERT INTO oboNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","To id livod don iddos mgo ponolihan diyot datas to langit, id po‑ikohiyoy iddos mgo tohodtamong to karnero to, “Kuo kid, od undiyon kid to Betlehem amoy'd kokita ta iddos notomanan no id posaddoo keta to Monama nod Longaggon.” ");
INSERT INTO oboNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","De‑en id lukutlukut dan nid undiyon, woy rutun, nokita ran si Maria woy si Jose woy dos anak no riyot pokannan to oyama. ");
INSERT INTO oboNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","To nokita ran don iddos anak, id ponudtuu ran diyot langun iddos id ikahi kandan tat ponolihan moka‑atag taddot anak. ");
INSERT INTO oboNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na, iddos langun no nokorinog taddot id ikahi to mgo tohodtamong to karnero, nosoobbuwan. ");
INSERT INTO oboNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Piru si Maria, id tota‑aw rin diyot poomdom din iddos langun no notomanan woy inaayun din idda od oonongngon. ");
INSERT INTO oboNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na, id uli iddos mgo tohodtamong to karnero no mid doong woy id posivantug to Monama pomon taddot langun no norinog woy nokita ran. Oyyos bonnaa en iddos id ponudtuu to ponolihan kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na, to wau ron no allow iddos anak, id potupuwan sikandin woy id ngoranan ki Disas. Ini en kos ngaran no id ponudtuu taddot ponolihan to waa pa sikandin diyot gottok to inoy rin. ");
INSERT INTO oboNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","To id inguma ron iddos allow to kodtuman onni Jose woy Maria taddot suhu ni Moises moka‑atag to botasanon to kodlinis to ba‑ay no lammi tobbawi, mid undiyon sikandan to Jerusalem amoy'd bovuwis. Id piyod dan si Disas amoy id po‑ossa atag to Monama nod Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Oyya su ini en kos nosulat diyot Suhu tod Longaggon no mid ungketen to, “Ko‑ilangan no iddos ponganoy no anak no mama, id po‑ossa atag tod Longaggon.” ");
INSERT INTO oboNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na moka‑atag taddot botasanon to kodlinis, id bovuwis sikandan iling taddot no‑ikahi riyot Suhu tod Longaggon no, “Ko‑ilangan no id buwis iddos oruwon limukon o oruwon pispis to soopati.” ");
INSERT INTO oboNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Iddon timpu, duwon sokkad no buyyag diyot Jerusalem no id ngoranan ki Simeon no id aangat to kod‑inguma taddot Tohodtobbus amoy'd tovangan iddos koubbaran ni Israel. Motallong sikandin no minuvu woy mopompomakoy woy no‑iroomman to Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tapoy id posaddoo kandin to Uhis no Ispiritu, no konna pa sikandin od patoy taman tod kokita rin iddos Mesiyas no id tandu to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ukit to kodpomandu kandin to Uhis no Ispiritu, id usok sikandin diyot templo. Nokosasang en mandad no id piyod onni Jose si Disas amoy'd puungan dan iddos no‑ikahi riyot Suhu moka‑atag kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","To nokita ni Simeon iddos anak, id sopipi rin woy id doong din kos Monama. Kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Longaggon, notuman don iddos tandu ru koddi no uripon du. Nopanoy ad ahad kannu ru od ongayon kos umuu ku, oyyos id lonna ron kos ginawa ku. ");
INSERT INTO oboNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Su matamata kud en tid kita ka‑ay't id popiyod du no Tohodtobbus ");
INSERT INTO oboNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","no id panoy ru atag to langun no minuvu to intirut ingod. ");
INSERT INTO oboNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Sikandin en iddos od poma‑awang to poomdom to konna mgo Judio no waa poron id kilaa kikow. Woy ukit kandin, od posivontuhon iddos minuvu ru no koubbaran ni Israel.” ");
INSERT INTO oboNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","De‑en nosoobbuwan iddos amoy woy inoy ni Disas taddot id ikahi ni Simeon moka‑atag kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Na id dasaa si Simeon, no iddos Monama od pokita to kopiyannoy rin diyot kandan. Nopongnga, id osengan din iddos inoy no si Maria, kahi rin to, “Inin anak, id aam to Monama su amoy ukit kandin, mo‑uraa kos minuvu to Israel nod kotobbus, piru mo‑uraa mandad kos od silutan. Od kilaannon sikandin no patow pomon diyot Monama, piru mo‑uraa mandad kos od kolingasa kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ukit kandin, od kosorollan iddos poomdom to mo‑uraan minuvu. Woy sikkow Maria, pomon to lampas no kodlanu ru, od geddamon du no iling tid pillak kos pusung du.” ");
INSERT INTO oboNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na riyot templo, duwon mandad ba‑ay'n propeta no id ngoranan ki Ana no anak ni Fanuel no lubbad ni Aser. Buyyag don sikandin, woy noko‑osawa sikandin daom da to pittun lahun. ");
INSERT INTO oboNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nopongnga, novau ron sikandin taman ko‑ungkay no waumpuu‑oppat kos idad din. Inaayun sikandin diyot templo su allow bulli, od simba sikandin, od dasaa woy'd puasa. ");
INSERT INTO oboNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","To idda ra en no timpu, id porani si Ana ki Jose woy ki Maria woy id posolamat sikandin diyot Monama. Id ponudtuu rin iddos moka‑atag taddot anak diyot langun no id aangat to allow to kodtobbus to Monama to mgo minuvu riyot Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","To notuman don onni Jose woy Maria iddos langun no no‑ikahi riyot Suhu tod Longaggon, id uli ron sikandan diyot kandan no bonuwa to Nazaret no sakup to Galilea. ");
INSERT INTO oboNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na, id tuvu iddos anak woy id monokkaa sikandin, id moraom pe‑en kos koovottan din woy id kahaa‑i sikandin to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na ipat lahun, od undiyon to Jerusalem iddos amoy woy inoy ni Disas amoy'd sakup to pista to Kodlihad to Ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","To sopuu‑oruwa ron kos idad ni Disas, id sakup sikandan taddon pista, su idda me‑en kos noyaami ran nod puungan. ");
INSERT INTO oboNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nopongnga iddos pista, id logkiyat don si Jose woy si Maria amoy'd uli, piru waa saddoo ran no id polintotuwos bos si Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kunan dan ko nokoruma rad si Disas taddot ko‑urallan to duma ran nid ipanow. To sokkad don no allow to kod‑ipanow ran, idda pa sikandan nokosaddoo no waa vos dutun si Disas. De‑en id ponaap dan sikandin diyot mgo korumannan dan woy riyot mgo oukuy ran. ");
INSERT INTO oboNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pomon to waa ran sikandin nokita, id poolivod sikandan diyot Jerusalem amoy'd ponaap kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","To otollu ron no allow kos mid lihad, idda pa nokita ran sikandin no id ounsad diyot templo duma to mgo tohodnonaw to Suhu ni Moises. Id pominog sikandin woy mid ointud kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na iddos langun no nokorinog kandin, nosoobbuwan taddot sinorollan woy mgo tavak din. ");
INSERT INTO oboNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","To nokokita ki Disas iddos amoy woy inoy rin, oraroy ran no nosoobbuwan. Kahi taddot inoy rin to, “Anak ku, mambot id puungan du ini konami? Siyak woy inis amoy ru, oraroy koyd no no‑ipong to kodponaap kikow.” ");
INSERT INTO oboNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mid tavak si Disas to, “Mambot id ponaap kow pa koddi? Waa row vo nosorolli no ko‑ilangan en no ka‑ay a to baoy't Amoy ku?” ");
INSERT INTO oboNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Piru waa ran nokaabbot taddot kohulugan to id ikahi rin. ");
INSERT INTO oboNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nopongnga idda, id duma si Disas kandan nid uli riyot Nazaret, woy id dumoruma sikandin to langun no suhu ran kandin. Na iddos langun no notomanan, id tota‑aw ni Maria riyot poomdom din. ");
INSERT INTO oboNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na id tuvu si Disas, woy id moraom pe‑en kos koovottan din, woy id kahaa‑i sikandin to Monama woy to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Na riyot iko‑sopuu‑limmon lahun don to kodponguu ni Tiberio no hari to Roma, duwon ponudtulon to Monama ki Juan no anak ni Zacarias. Id oubpa si Juan diyot noka‑awoy‑awoy'n lugaa. To idda ra en no timpu, si Poncio Pilato kos gubernador diyot prubinsya to Judea, si Harin Herodes kos ponguu riyot prubinsya to Galilea woy dos ari rin no si Felipe kos ponguu riyot prubinsya to Iturea woy Trakonite. Na si Harin Lisanias mandad, sikandin kos ponguu riyot prubinsya to Abilene. Si Anas woy si Caifas mandad kos mowwet no mgo ponguu to tohodbuwis. ");
INSERT INTO oboNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pomon to ponudtulon to Monama ki Juan, mid undiyon sikandin to langun no lugaa no moranit Oweg to Jordan amoy od ponudtuu to kahit Monama. Kahi rin diyot mgo minuvu to, “Sondit kow woy tanan kowd to mgo saa row, woy poboutismu kow amoy'd posinsyan kow to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ukit ka‑ay't id puungan ni Juan, notuman iddos id sulat ni propeta Isaias no, “Duwon monokkaan bawos diyot noka‑awoy‑awoy'n lugaa no mid ungketen to, ‘Ponaya row kos pusung dow atag tod Longaggon, woy tulidda row kos od ukitan din. ");
INSERT INTO oboNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Iddos ipat sobbong no lugaa, od bunbunan, woy dos ipat lovuntud woy buvungan, od potaddon. Dos bengkog no daan, od tuliddon woy dos botuwon, od upiyannan. ");
INSERT INTO oboNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na, od kokita to langun no minuvu iddos po‑ukit to Monama to kodtobbus kandan.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mo‑uraan minuvu kos mid undiyon to ki Juan amoy'd poboutismu. Kahi rin kandan to, “Sikiyu, iling kow to mgo uwod nod laas! Kunan dow ayu kod pokolegguang kowd taddot od ingumon kodsilut to Monama otid koboutismuwan kowd! ");
INSERT INTO oboNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Otik bonnaa en no id sondit woy id tanan kowd to mgo saa row, posivonnali row ini ukit to koniyun pinuungan. Yo kow'd pososalig no dii kow od silutan to Monama pomon to koubbaran kow ni Abraham. Od ikohiyan ku sikiyu, no ahad inis mgo batu, od kovovallan to Monama no koubbaran ni Abraham. ");
INSERT INTO oboNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pomotawi row! Dos kodsilut to Monama koniyu, noko‑iling to porokuu no nopanoy ron nid tampod to kayu. Woy dos ipat kayu no diid bovunga to moppiya, od tompoddon woy'd lumbag diyot apuy.” ");
INSERT INTO oboNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Na mid intud ki Juan iddos mo‑uraan minuvu, kahi ran to, “Ko ungketen, ondan man kos od puungan doy?” ");
INSERT INTO oboNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mid tavak si Juan to, “Iddos duwon oruwon umpak, ko‑ilangan no id boggoy rin kos sokkad diyot waa umpak. Idda mandad so duwon koka‑an, ko‑ilangan nod boggoy riyot waa koka‑an.” ");
INSERT INTO oboNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Duwon mandad mgo tohodsukut to buhis no id porani ki Juan amoy'd poboutismu. Kahi ran to, “Tohodnonaw, ondan kos od puungan doy?” ");
INSERT INTO oboNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mid tavak si Juan to, “Yo kow'd ponukut to buhis no lampas taddot id posukut koniyu to guberno.” ");
INSERT INTO oboNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Duwon mandad mgo sundau nid intud kandin, kahi ran to, “Na sikami, ondan mandad kos od puungan doy?” Mid tavak si Juan to, “Yo kow'd pongimallak woy yo kow'd ampoo to mgo minuvu amoy'd ponoopi. Kahaa kowd taddot bayad koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na pomon taddot id pon‑ikahi ni Juan, notimulan pe‑en iddos kod‑imman to mgo minuvu no sikandin don en kos Mesiyas no nouhoy ran don od oongatan. Woy kohingginawa ran no sikandin don en ayu kos Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Piru kahin Juan kandan to, “Od boutismuwan ku sikiyu to oweg, patow no id sondit woy id tanan kowd to mgo saa row. Piru konnod kouhoy, duwon od tundug koddi no lampas pa koddi, su konna a ollog ahad kod‑akas da to sandalyas din. Uhis no Ispiritu woy apuy kos id boutismu rin koniyu. ");
INSERT INTO oboNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Od pod‑ossan din iddos mgo minuvu no moppiya woy morat iling to minuvu nod oottap to trigu. Dos moppiyon trigu, id ta‑aw rin diyon to budiga, piru iddos mgo ottap, od tirukkan din diyot apuy no konnod ko‑ovukkan.” ");
INSERT INTO oboNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na, mo‑uraa pe‑en kos nonaw ni Juan moka‑atag to Moppiyon Dinoggan, woy id ikohiyan din iddos mgo minuvu no ko‑ilangan nod sondit woy od tanan sikandan to mgo saa ran. ");
INSERT INTO oboNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ahad si Herodes no gubernador, id sugga rin su id ahaw rin si Herodias no sawa taddot ari rin, woy id sugga rin mandad sikandin taddot duma pon morat no pinuungan din. ");
INSERT INTO oboNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Piru si Herodes, ayas da en baling id puung to morat, oyyos id poprisu rin si Juan. ");
INSERT INTO oboNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","To waa pa noprisu si Juan, mo‑uraa kos id poboutismu kandin, woy id poboutismu mandad kandin si Disas. Laggun tid dasaa pa si Disas, nopokes kos langit. ");
INSERT INTO oboNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Woy id lonna riyot kandin iddos Uhis no Ispiritu no iling to soopati. Na duwon bawos pomon diyot datas to langit no mid ungketen to, “Sikkow en kos Anak ku no id dokollan ku to ginawa woy oraroy ku nid kahaa‑i.” ");
INSERT INTO oboNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","To mgo otollumpuu ron kos lahun ni Disas, id tigkanoy sikandin to pinuungan din. Diyot poomdom to mgo minuvu, anak sikandin ni Jose. Si Jose, anak ni Eli. ");
INSERT INTO oboNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Eli, anak ni Matat. Si Matat, anak ni Levi. Si Levi, anak ni Melqui. Si Melqui, anak ni Janai. Si Janai, anak ni Jose. ");
INSERT INTO oboNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Jose, anak ni Matatias. Si Matatias, anak ni Amos. Si Amos, anak ni Nahum. Si Nahum, anak ni Esli. Si Esli, anak ni Nagai. ");
INSERT INTO oboNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagai, anak ni Maat. Si Maat, anak ni Matatias. Si Matatias, anak ni Semei. Si Semei, anak ni Josec. Si Josec, anak ni Juda. ");
INSERT INTO oboNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Juda, anak ni Joana. Si Joana, anak ni Resa. Si Resa, anak ni Sorobabel. Si Sorobabel, anak ni Salatiel. Si Salatiel, anak ni Neri. ");
INSERT INTO oboNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri, anak ni Melqui. Si Melqui, anak ni Adi. Si Adi, anak ni Cosam. Si Cosam, anak ni Elmadam. Si Elmadam, anak ni Er. ");
INSERT INTO oboNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er, anak ni Josue. Si Josue, anak ni Eliezer. Si Eliezer, anak ni Jorim. Si Jorim, anak ni Matat. Si Matat, anak ni Levi. ");
INSERT INTO oboNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Levi, anak ni Simeon. Si Simeon, anak ni Juda. Si Juda, anak ni Jose. Si Jose, anak ni Jonan. Si Jonan, anak ni Eliakim. ");
INSERT INTO oboNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliakim, anak ni Melea. Si Melea, anak ni Mena. Si Mena, anak ni Matata. Si Matata, anak ni Natan. Si Natan, anak ni David. ");
INSERT INTO oboNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David, anak ni Isai. Si Isai, anak ni Obed. Si Obed, anak ni Boas. Si Boas, anak ni Salmon. Si Salmon, anak ni Naason. ");
INSERT INTO oboNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Naason, anak ni Aminadab. Si Aminadab, anak ni Admin. Si Admin, anak ni Arni. Si Arni, anak ni Esrom. Si Esrom si Fares. Si Fares, anak ni Juda. ");
INSERT INTO oboNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Juda, anak ni Jacob. Si Jacob, anak ni Isaac. Si Isaac, anak ni Abraham. Si Abraham, anak ni Tera. Si Tera, anak ni Nahor. ");
INSERT INTO oboNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor, anak ni Serug. Si Serug, anak ni Ragau. Si Ragau, anak ni Peleg. Si Peleg, anak ni Eber. Si Eber, anak ni Sala. ");
INSERT INTO oboNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sala, anak ni Cainan. Si Cainan, anak ni Arfaxad. Si Arfaxad, anak ni Sem. Si Sem, anak ni Noe. Si Noe, anak ni Lamec. ");
INSERT INTO oboNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamec, anak ni Metusela. Si Metusela, anak ni Enoc. Si Enoc, anak ni Jared. Si Jared, anak ni Mahalaleel. Si Mahalaleel, anak ni Cainan. ");
INSERT INTO oboNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Cainan, anak ni Enos. Si Enos, anak ni Set. Si Set, anak ni Adan. Si Adan, anak to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na, to noboutismuwan don si Disas, id tanan sikandin diyot Oweg to Jordan. No‑iroomman sikandin to Uhis no Ispiritu woy id piyod sikandin diyot noka‑awoy‑awoy'n lugaa. ");
INSERT INTO oboNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Woy rutun, daom to oppat‑no‑puun allow, id geddaman sikandin ni Moivuyan kod kopiyod sikandin nod puung to saa. Iddon timpu, waa sikandin id ka‑an, de‑en oray sikandin id gutasan diyot kotompusan. ");
INSERT INTO oboNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na kahin Moivuyan kandin to, “Otik mooggot ka en no Anak to Monama, suhuwow inis batu nod kovovallan no paan.” ");
INSERT INTO oboNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Piru mid tavak si Disas to, “No‑ikahi riyot Nosulat no Kahit Monama no, ‘Konna ra koka‑an kos od poko‑uyag to minuvu.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nopongnga idda, id piyod sikandin ni Moivuyan diyot oray'n mowwet no buvungan. Woy id pokita rin iddos langun to kohoriyan ka‑ay to ampow't ingod to songo‑kodpollokpollok da. ");
INSERT INTO oboNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kahin Moivuyan to, “Id boggoy ku kikow kos kotungud to kodponguu ka‑ay't langun no kohoriyan woy dos kodpongomunoy to korotuwan dan. Su inis langun, id boggoy koddi, de‑en id pokovoggoy ku mandad ini riyot ahad ondoy no id kopi‑i ku nod boggayan. ");
INSERT INTO oboNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na otid simba ka koddi, kikow ron ini langun.” ");
INSERT INTO oboNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Piru mid tavak si Disas to, “No‑ikahi riyot Nosulat no Kahit Monama no, ‘Iyon du ra simba‑ana iddos Monama nod Longaggon du woy sikandin da kos duurumanniyu.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nopongnga idda, id piyod sikandin ni Moivuyan diyon to Jerusalem woy id poohinat din sikandin diyot oray'n motikang no sakup to templo. Kahi rin to, “Otik sikkow en kos Anak to Monama, timballu ka riyot dosiyung. ");
INSERT INTO oboNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Su no‑ikahi riyot Nosulat no Kahit Monama no, ‘Od suhuwon to Monama iddos mgo ponolihan din to kodtavang kikow amoy dii ka od komonnu. ");
INSERT INTO oboNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Od saakon ka nikandan amoy ahad ikos pa‑a ru, diid kohisgisan to batu.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Piru mid tavak si Disas to, “No‑ikahi mandad diyot Nosulat no Kahit Monama no, ‘Yo ru geddami kos Monama nod Longaggon du.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","To nopongnga iddos langun no po‑ukit ni Moivuyan to kodgeddam ki Disas, id tonanan din pa sikandin tahad woy id puhawang din no duwon dad allow nod geddaman din si Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na, id livod si Disas diyot Galilea no no‑iroomman to Uhis no Ispiritu, woy nokoso‑ob iddos dinoggan moka‑atag kandin diyon to langun no bonuwa no morani rutun. ");
INSERT INTO oboNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Id nonaw sikandin diyot mgo simba‑an to Judio woy id doong sikandin to langun. ");
INSERT INTO oboNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na, id undiyon si Disas to bonuwa to Nazaret, dos lugaa no id dokollan din. Diyon to Allow't Kod‑imolloy, mid undiyon sikandin to simba‑an to mgo Judio, su idda me‑en kos nooyami rin nod puungan. Id lohinat sikandin diyot isowwan to mgo minuvu amoy od basa to kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Id toyawwan sikandin taddot id luun no popii no id sulat ni propeta Isaias. Na id bollat din idda woy to nokita rin don, id basa rin no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“No‑iroomman a to Ispiritu to Monama nod Longaggon, su id aam a nikandin amoy od ponudtuu to Moppiyon Dinoggan diyot mgo worowora. Id popiyod a nikandin amoy'd posaddoo no duwon don kolegguangan taddot nongo‑uripon, amoy od pokokita ron iddos mgo butud woy amoy od tavang taddot od pon‑ooyuwon. ");
INSERT INTO oboNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Id popiyod a mandad nikandin amoy'd posaddoo to mgo minuvu no id inguma ron kos timpu nid pokita to Monama kos kopiyannoy rin kandan.” ");
INSERT INTO oboNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nopongnga ni Disas tid basa iddos Nosulat no Kahit Monama, id luun din idda woy id po‑uli riyot sinolihan dutun. Mid unsad sikandin amoy'd nonaw woy langun to mgo minuvu rutun, id totongtong nid pominog kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na id tigkanoy sikandin nid nonaw kandan, kahi rin to, “Iddos no‑ikahi riyot Nosulat no Kahit Monama nid basa ku, notuman don ko‑ungkay to norinog dow ini.” ");
INSERT INTO oboNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Id doong kandin iddos langun no minuvu woy nosoobbuwan dan taddot kotuihan din to kod‑ooseng. Kahi ran to, “Konna vo anak da man sikandin ni Jose?” ");
INSERT INTO oboNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kahin Disas kandan to, “Nokosaddoo a nid kopi‑i row nod ikahi koddi ka‑ay't ponunggelengan no mid ungketen to, ‘Sikkow no doktor, unna‑aw pa tod bawi kos ko‑ugolingun du.’ Woy id kopi‑i row nod ikahi koddi to, ‘Iddos norinog doy nid puungan du riyot bonuwa to Capernaum, ko‑ilangan mandad nod puungan du ka‑ay't kikow ron en no bonuwa.’ ");
INSERT INTO oboNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Bonnaavonnaa nod ikohiyon ku koniyu, no waa propeta nod tonggapon diyot kandin da en no ingod. ");
INSERT INTO oboNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Sompotta row iddos notomanan iddot timpu ni propeta Elias. Daom to mgo otollu woy'd tongngot lahun, waa id uran woy duwon dakkoon gutas. Iddon timpu, mo‑uraan bau ka‑ay to Isael no id ponggutasan. ");
INSERT INTO oboNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Piru iddos Monama, waa rin po‑undiyonna si Elias nod tavang to ahad ondoy kandan, ko konna, id po‑undiyon din sikandin to Sarepta no sakup to Sidon amoy od tavang taddot ba‑ay'n bau no konna Judio. ");
INSERT INTO oboNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Woy iddot timpu ni propeta Eliseo, mo‑uraa mandad no minuvu riyot Israel no duwon bohok no et‑et. Piru waa ahad sokkad kandan no no‑uliyan, ko konna, idda ra en so konna Judio no si Naaman no toho Siria.” ");
INSERT INTO oboNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na, to norinog idda to langun no minuvu riyot simba‑an to mgo Judio, oraroy ran no nolingasa. ");
INSERT INTO oboNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Posidlohinat sikandan woy id pohos dan sikandin nid poleggua riyot bonuwa, woy id goyod dan po‑undiyot ibpit to daama to buvungan no id poohinatan taddot bonuwa ran, su amoy od uuhon dan sikandin dutun. ");
INSERT INTO oboNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Piru id baya si Disas diyot tongannan to mo‑uraan minuvu woy ponayun don id ipanow. ");
INSERT INTO oboNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Na, id undiyon si Disas to bonuwa to Capernaum no sakup to Galilea. Woy riyon to Allow't Kod‑imolloy, id nonaw sikandin diyot mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nosoobbuwan dan taddot kodnonaw rin, su duwon en kotuusan to kod‑ooseng din. ");
INSERT INTO oboNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na riyot simba‑an to mgo Judio, duwon sokkad no minuvu no id losuran to busow, woy id pomehes sikandin no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Disas no toho Nazaret, ondak lavut du konami? Id undini ka vo amoy'd silutan koy nikkow? Id kilaa a kikow, su sikkow en kos Uhis no Anak to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Na id sugga ni Disas iddos busow, kahi rin to, “Po‑onong‑onong ka! Leggua kad kandin!” Idda ron en, to kodleggua taddot busow, id buntug din iddos minuvu riyot isowwan to ko‑urallan, piru waa sikandin nomonnu. ");
INSERT INTO oboNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nosoobbuwan iddos langun no mgo minuvu woy id po‑ikohiyoy ran to, “Eh, ondan man inin mgo nonaw? Duwon kotuusan woy kotungud din nod sugga to mgo busow, woy id leggua en.” ");
INSERT INTO oboNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pomon tadda, nokoso‑ob iddos moka‑atag ki Disas diyon to langun no mgo lugaa rutun. ");
INSERT INTO oboNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na, to id leggua si Disas diyot simba‑an to mgo Judio, mid undiyon sikandin to baoy ni Simon. Dutun, iddos ba‑ay'n onuhang ni Simon, oray'n id momonit. De‑en id nganoy ran ki Disas amoy'd ko‑uliyan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Id poroniyan din iddos novohokan woy id sugga rin iddos kodmomonit, woy idda ron en, no‑uliyan sikandin. Na, id onnow sikandin woy id sondad kandan to koka‑an. ");
INSERT INTO oboNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","To od kosagkup don, id piyod to mgo minuvu riyot ki Disas iddos langun nod kovohokan. Id somaddan ni Disas kos uu taddot ipat sokkad woy no‑uliyan sikandan. ");
INSERT INTO oboNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na, id poleggua rin mandad iddos mgo busow no id lasud taddot mo‑uraan minuvu. To id leggua iddos mgo busow, id pomehes sikandan no mid ungketen to, “Sikkow en kos Anak to Monama!” Piru id sugga sikandan ni Disas woy waa rin po‑osenga, su nosorollan dan man no sikandin en kos Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","To na‑allow ron, mid undiyon si Disas to noka‑awoy‑awoy'n lugaa. Id nonangkap kandin iddos mgo minuvu, woy to nokita ran don sikandin, id owiran dan sikandin no diid awa riyot bonuwa ran. ");
INSERT INTO oboNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Piru kahin Disas kandan to, “Ko‑ilangan no id pokoponudtuu ku riyot osson mgo bonuwa iddos Moppiyon Dinoggan moka‑atag to kodharit Monama. Oyya su ini en kos dontulon to kodpopiyod koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na, id ponayun sikandin nid ponudtuu to kahit Monama riyot mgo simba‑an to Judio no riyot mgo bonuwa to sakup to Judea. ");
INSERT INTO oboNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sokkad no allow to riyon si Disas to ibpit to Lanow't Genesaret, id pososokoy iddos mo‑uraan minuvu no id porani kandin amoy'd pominog to kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na rutun, nokita ni Disas iddos oruwon bollangay no id tonanan to mgo tohodngongaap su id loinis to mgo pukut dan. ");
INSERT INTO oboNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Id penek si Disas taddot sokkad no bollangay no si Simon kos komunoy. Woy id ikohiyan din sikandin to, “Usungow ve‑en boyow inis bollangay riyot oweg.” Na, mid unsad si Disas woy id nonaw riyot mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nopongnga id nonaw si Disas, id ikohiyan din si Simon to, “Od ossud ki riyot moraom, woy uuha row kos mgo pukut amoy'd poko‑utoo kow.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kahin Simon to, “Tohodnonaw, nouggat koy laroy't bulli nid ngongaap, piru waad en no‑utoo roy. Onggad su sikkow man kos id suhu konami, od puungan doy kos suhu ru.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na, to id uug dan iddos mgo pukut, doddohusun ngaap kos mid sahad woy disok sama novendas iddos mgo pukut dan. ");
INSERT INTO oboNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","De‑en id kamoy ran iddos mgo duma ran no riyot osson bollangay amoy od dubpu woy'd tavang kandan. Na, id iponnu ran to ngaap iddos tapad bollangay woy asow ran don od koonnod. ");
INSERT INTO oboNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","To nokita idda ni Simon Pedro, id lingko‑od sikandin diyot isowwan ni Disas woy mid ikahi to, “Longaggon, poriyu ka koddi su mosaasaa a no minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Id oseng idda ni Pedro, oyyos sikandin woy dos mgo duma rin, oray'n nosoobbuwan taddot doddohusun ngaap no no‑utoo ran. ");
INSERT INTO oboNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nosoobbuwan mandad iddos mgo duma ni Pedro no si Santiago woy si Juan no mgo anak ni Sebedeo. Na kahin Disas ki Simon to, “Yo kod kovaakki, oyyos pomon ko‑ungkay, konnad ngaap kos od ingutollon du, ko konna, mgo minuvu ron.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","De‑en id po‑ibpit dan iddos mgo bollangay, woy id tonanan dan kos langun woy mid duma ran ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sokkad no allow, to riyon si Disas to sokkad no bonuwa, duwon minuvu nid inguma no noso‑ob to et‑et. To nokita rin si Disas, mid lingko‑od sikandin woy id ounduk diyot isowwan din woy id po‑eru‑eru. Kahi rin to, “Longaggon, nokosaddoo a nod poko‑uli ka ka‑ay't molibmit no bohok ku otik id kopi‑i ru.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na, id somaddan ni Disas iddos minuvu woy id ikohiyan din to, “Oyya, id kopi‑i ku en. Od ko‑uliyan kad.” Idda ron en, worad iddos et‑et din. ");
INSERT INTO oboNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kahin Disas kandin to, “Yo ru vo id ponudtuu ini riyot ahad ondoy, ko konna, undiyon ka to tohodbuwis amoy'd ontongngan din kos lawa ru. Woy boggoy ka to buwis no id suhu ni Moises amoy'd posivonnaa riyot mgo minuvu no no‑uliyan kad.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Piru ahad ungketen kos id ikahi ni Disas, ayas da en baling id so‑ob iddos dinoggan moka‑atag kandin. De‑en oray'n mo‑uraan minuvu kos mid undiyot kandin amoy od pominog woy amoy'd ko‑uliyan iddos mgo bohok dan. ");
INSERT INTO oboNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Piru si Disas, inaayun od undiyon to noka‑awoy‑awoy'n lugaa amoy'd dasaa. ");
INSERT INTO oboNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sokkad no allow to id nonaw si Disas, duwon id ounsad no mgo Pariseo woy mgo tohodnonaw to Suhu ni Moises no id pomon diyot ipat bariyu no sakup to Galilea, Judea woy Jerusalem. Na riyot ki Disas iddos kotuusan to Monama nod Longaggon, oyyos od pokovawi sikandin tod pongkovohokan. ");
INSERT INTO oboNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Iddon timpu, duwon mgo minuvu nid inguma no id sayung to minuvu nid patoy kos lawa no id ilogga riyot ikam. Id po‑usok dan nanoy sikandin diyot baoy amoy id poonna riyot isowwan ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Piru pomon to mo‑uraan minuvu, waad kovoyan dan nod usok. De‑en id pomenek dan diyot atop woy id akas dan kos pilon atop, woy id tuntun dan sikandin diyot tongannan to mgo minuvu riyot isowwan ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","To nokita rin no dakkoo kos kodsalig dan, mid ikahi sikandin to, “Suwod, id posinsyan don kos mgo saa ru.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","To norinog idda taddot mgo tohodnonaw to Suhu ni Moises woy taddot mgo Pariseo, kohingginawa ran to, “Te, ondoy man moho ikon minuvu nod sumpalit to Monama? Oyyos waa minuvu nod pokoposinsya to saa, ko konna, Monama ra en.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Piru nosorollan ni Disas kos diyot poomdom dan, de‑en id ikohiyan din sikandan to, “Mambot ungketen kos poomdom dow? ");
INSERT INTO oboNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ingkon man musing kos moomok nod osengon? Idda vo so od ikahi no, ‘Id posinsyan don kos mgo saa ru,’ o iddos od ikahi no, ‘Lohinat ka woy ipanow ka’? ");
INSERT INTO oboNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Piru id pokita ku koniyu no siyak no Anak to Minuvu, duwon kotungud ka‑ay to ampow't ingod no od posinsya to mgo saa.” Na id osengan din iddos minuvu no id patoy kos lawa, kahi rin to, “Lohinat ka, piyoddow kos ikam du woy uli kad bo.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Idda ron en, mid lohinat sikandin diyot isowwan to langun, id piyod din iddos ikam woy id uli sikandin no id doong din kos Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na, nosoobbuwan iddos langun woy id doong dan kos Monama duma to allak, kahi ran to, “Kuu! Oray'n mokososoobbu kos nokita ta ko‑ungkay!” ");
INSERT INTO oboNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nopongnga idda, id ipanow si Disas woy nokita rin iddos tohodsukut to buhis no id ngoranan ki Levi. Id unsad sikandin diyot od boovoyaran to buhis. Na kahin Disas to, “Duma ka koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","De‑en mid lohinat si Levi, id tonanan din kos langun woy id duma kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na, id pista si Levi riyot baoy rin atag ki Disas. Duwon mandad mo‑uraan tohodsukut to buhis woy duma pon mgo minuvu no mid ka‑an duma kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Duwon mgo Pariseo woy mgo tohodnonaw to Suhu ni Moises dutun. Id sawoy ran iddos mgo tinodduwan ni Disas. Kahi ran to, “Mambo moho to id lommung kow nid ka‑an woy'd inom duma ruwot mgo tohodsukut to buhis woy dumon mosaasaa?” ");
INSERT INTO oboNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Piru mid tavak si Disas kandan ukit to ponunggelengan, kahi rin to, “Iddos mgo minuvu no waa bohok, konna od ko‑ilangan to doktor, ko konna, idda ra en so duwon bohok. ");
INSERT INTO oboNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iling mandad tadda, waa a mid undini amoy'd nangkap to mgo motallong, ko konna, idda en so mgo mosaasaa, su amoy od sondit woy'd tanan sikandan to mgo saa ran.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na, duwon mgo minuvu no mid ikahi ki Disas to, “Iddos mgo tinodduwan ni Juan no Tohodboutismu, inaayun od puasa woy'd dasaa, woy ungketen dad en mandad iddos mgo tinodduwan to mgo Pariseo. Piru ikos mgo tinodduwan du, od ka‑an moho woy'd inom.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mid tavak si Disas to, “Otik duwon kosaa, od puasa vo iddos korumannan taddot lammid osawa laggun to duma ran pa sikandin? Konna en! ");
INSERT INTO oboNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ungketen dad en mandad iddos mgo tinodduwan ku. Piru od inguma en kos timpu no od puasa ran otid ongayon don pomon diyot kandan iddos id osawa.” ");
INSERT INTO oboNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na, duwon mandon ponunggelengan ni Disas, kahi rin to, “Waa minuvu nod bendas diyot lammin umpak amoy id tapong diyot tapoy. Oyya su otid puungan din idda, od kovendas en iddos lammin tapong woy dos lammi, diid dappan taddot tapoy. ");
INSERT INTO oboNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Iling mandad tadda, waa minuvu no od ta‑aw to lammin binu nod bovuwak poron diyot tapoy'n tootawwan no binovallan pomot kindaa to oyama, oyyos od bottu en moho idda. Na od korattan da en iddos tootawwan woy'd ko‑uwakkan dos binu. ");
INSERT INTO oboNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Purisu ko‑ilangan no iddos lammin binu, diyon en mandad id ta‑aw to lammin tootawwan. ");
INSERT INTO oboNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na, waa en minuvu no od kopiyan pa od geddam to lammin binu otik naayam don sikandin taddot tapoy, oyya su atag kandin, idda ra en so tapoy kos monanam.” ");
INSERT INTO oboNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sokkad no timpu to Allow't Kod‑imolloy, nokovaya onsi Disas diyot kamot no duwon pinomuwon trigu. Laggun tid ipanow ran, id pomadti iddos mgo tinodduwan din to mgo trigu, woy id kusukusu ran idda woy id sungit. ");
INSERT INTO oboNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Piru duwon mgo Pariseo no nokokita taddot id puungan dan, woy kahi ran ki Disas to, “Mambot id puungan dow iddos id diiyan diyon to Allow't Kod‑imolloy?” ");
INSERT INTO oboNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mid tavak si Disas to, “Waa kow vo nokovasa taddot id puungan ni Harin David woy taddot mgo duma rin iddot timpu no id gutasan sikandan? ");
INSERT INTO oboNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Id usok sikandin diyon to baoy't Monama woy id ka‑an din iddos paan no id buwis diyot Monama, woy id boggayan din mandad iddos mgo duma rin. Iddon paan, id diiyan nod kannon to ahad ondoy su iyon da od pokoka‑an tadda, iddos mgo tohodbuwis.” ");
INSERT INTO oboNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Woy id ikahi pe‑en si Disas to, “Na, siyak no Anak to Minuvu kos duwon kotungud ko ondak od puungan ahad diyon to Allow't Kod‑imolloy.” ");
INSERT INTO oboNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sokkad mandon no timpu to Allow't Kod‑imolloy, mid usok si Disas diyot simba‑an to mgo Judio woy id nonaw. Na rutun, duwon minuvu no id patoy kos kowanan no bollad. ");
INSERT INTO oboNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Duwon mandad mgo tohodnonaw to Suhu ni Moises woy mgo Pariseo no od nangkap to po‑unayan amoy'd ko‑uug dan si Disas no nokopuung to saa. De‑en id ponulan dan sikandin kod bowiyan din iddos minuvu riyon to Allow't Kod‑imolloy. ");
INSERT INTO oboNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Piru nosorollan ni Disas kos diyot poomdom dan, woy id osengan din iddos minuvu no id patoy kos bollad, kahi rin to, “Lohinat ka rinit isowwan to langun.” De‑en id lohinat sikandin woy id porani. ");
INSERT INTO oboNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na, id inturan ni Disas iddos mgo minuvu rutun. Kahi rin to, “Ingkon musing ka‑ay kos noko‑ikuu to mgo Suhu ni Moises diyon to Allow't Kod‑imolloy? Idda vo so kodpuung to moppiya o iddos kodpuung to morat? Idda vo so kodtavang to minuvu o iddos kod‑imatoy?” ");
INSERT INTO oboNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Id tongtongngan dan langun ni Disas, woy id ikohiyan din iddos minuvu to, “Kotongngow kos bollad du.” Na, id kottong din idda woy idda ron en, no‑uliyan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Piru oray'n nolingasa iddos mgo tohodnonaw to Suhu ni Moises woy dos mgo Pariseo, de‑en id pomuhawang sikandan ko ondan kos od puungan dan ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Waa nouhoy pomon tadda, mid tikoddog si Disas diyot buvungan amoy'd dasaa. Laroy't bulli, id dasaa sikandin diyon to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na, to na‑allow ron, id livuung din iddos langun no tinodduwan din, woy id aam din pomon diyot kandan iddos sopuu‑oruwa no id ngoranan din no mgo apostoles. ");
INSERT INTO oboNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Dos ngaran dan, si Simon no id ngoranan ni Disas ki Pedro woy dos suwod din no si Andres, dos toosuwod no si Santiago woy si Juan. Dos duma, si Felipe, si Bartolome, ");
INSERT INTO oboNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo, si Tomas, si Santiago no anak ni Alfeo woy si Simon no id ngoranan no Patriota su mohingginawa sikandin to ingod din. ");
INSERT INTO oboNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Id aam din mandad si Judas no anak taddot sangoy ni Santiago, woy si Judas Iscariote nod boligya ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na, id potupang si Disas duma to mgo apostoles taman to id inguma ran diyot pattad. Woy rutun, nolivuung iddos mo‑uraan minuvu nod pondumoruma kandin, woy dos oray'n mo‑uraan minuvu no id pomon diyon to intirut Judea woy riyot Jerusalem. Duwon mandad id pomon diyot bonuwa to Tiro woy Sidon no riyot ibpit to dahat. ");
INSERT INTO oboNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mid undiyon iddon mgo minuvu amoy'd pominog to nonaw ni Disas, woy amoy od ko‑uliyan kos bohok dan. Idda mandad so mgo minuvu no id posupittan to mgo busow nid lasud kandan, no‑uliyan oyyos id poleggua ni Disas iddos mgo busow. ");
INSERT INTO oboNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Id nokkaanokkaa iddos langun no minuvu amoy'd pokosomad ki Disas, su duwon kotuusan no id pomon diyot kandin no nokovawi kandan langun. ");
INSERT INTO oboNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nopongnga idda, id tongtongngan ni Disas iddos mgo tinodduwan din, woy kahi rin to, “Moppiya kod kotomanan dow, sikiyu no worowora, oyyos od pokolonug kow to kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Moppiya kod kotomanan dow, sikiyu no id gutasan ko‑ungkay, oyyos od ivuungon kow rad. Moppiya kod kotomanan dow, sikiyu no id sinoggow ko‑ungkay, oyyos od kosu‑at kow rad kangkan pomon to kahaan. ");
INSERT INTO oboNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Moppiya kod kotomanan dow otik id kolingasa‑i kow to mgo minuvu, id pa‑awa kow, id sumpalit woy id doddorattan pomon to koddumoruma row koddi no Anak to Minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“De‑en otik od puungan dan ini koniyu, kahaa kow woy sayow kow to kahaan, oyya su dakkoo kos ganti no id panoy atag koniyu riyot datas to langit. Su iddos id puungan dan koniyu, ungketen dad en mandad kos id puungan to kovuyyahan dan diyot mgo propeta. ");
INSERT INTO oboNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Piru sikiyu no noratu ko‑ungkay, moko‑eru‑eru kow, su notanggap dowd kos kahaan ka‑ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Moka‑arat‑arat kod kotomanan dow, sikiyu no novuung ko‑ungkay, oyyos od inguma en kos timpu nod gutasan kow. Moka‑arat‑arat kod kotomanan dow, sikiyu nod kosu‑at ko‑ungkay, oyyos od inguma kos timpu nod kaanu woy'd pondaawit kow. ");
INSERT INTO oboNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Moka‑arat‑arat kod kotomanan dow, sikiyu no od doongon ko‑ungkay to mgo minuvu, su ungketen dad en mandad kos id puungan to kovuyyahan dan diyot od po‑uvag‑uvag no mgo propeta. ");
INSERT INTO oboNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Piru od ikohiyan ku sikiyu no id pominog koddi, ginowanni row kos od kuntra koniyu woy puungi row to moppiya iddos nolingasa koniyu. ");
INSERT INTO oboNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Buyu kow riyot Monama no od pokita sikandin to kopiyannoy taddot od doddora‑at koniyu, woy dasaa kow atag taddot od ayu‑ayu koniyu. ");
INSERT INTO oboNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Otik duwon od tabpit bonnong dow, potabpi row mandad kos divauy. Otik duwon od ahaw to lapid no umpak dow, boggoy row ahad iddos umpak dow. ");
INSERT INTO oboNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Boggayi row iddos langun nod bovuyu koniyu, woy otik duwon od ahaw to mgo koruwonnan dow, yo rowd idda owiya. ");
INSERT INTO oboNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Puungi row riyot duma iddos id kopi‑i row nod puungan dan koniyu. ");
INSERT INTO oboNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Otik iyon dow ra od ginowannon iddos id ginawa koniyu, ondan man kos nokomoppiya tadda? Su ahad iddos mgo mosaasaa, od ginawa man taddot id ginawa kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Woy otik iyon dow ra od puungan to moppiya iddos od puung to moppiya koniyu, ondan man kos nokomoppiya tadda? Su ahad iddos mgo mosaasaa, od puung man mandad to ungketen. ");
INSERT INTO oboNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Otik iyon dow ra od posombayon iddos duwon id pokovullas, ondan man kos nokomoppiya tadda? Su ahad iddos mgo mosaasaa, od posamboy man mandad diyot od pokovullas kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Piru sikiyu, ginowanni row iddos od kuntra koniyu woy puungi row iddos od pokomoppiya kandan. Posamboy kow woy yo kow'd angat to bullas. Na, ko ungketen kos od puungan dow, dakkoo kos ganti nod kotanggap dow, woy od kokita no mgo anak kow en to Monama no Lampas to Langun. Su moppiya sikandin ahad taddot diid kotuig nod posolamat woy riyot morat no mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","De‑en ko‑ilangan no eeruwon kow iling taddot Monamon Amoy ta no eeruwon. ");
INSERT INTO oboNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Yo kow'd hukum to duma amoy dii kow mandad od hukuman to Monama. Yo kow'd oseng no ko‑ilangan en sikandan od silutan, su amoy konna kow mandad od silutan to Monama. Posinsya‑i row iddos duma amoy'd posinsyan kow mandad to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Boggoy kow woy od boggayan kow mandad to Monama. Oray'n dakkoo kos id boggoy rin koniyu, oyyos iling to boggas no id lasud diyot saku, od dosokkon idda woy kopongnga, od timulan taman tod koponnuponnu. De‑en iddos korokolloy no id boggoy row riyot duma, ungketen dad en mandad kos id boggoy to Monama koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Na, duwon mandon ponunggelengan ni Disas, kahi rin to, “Waa en butud nod poko‑inahak to iling din no butud, su od pokodtapik dan da en nod ko‑uug diyot moraom no bobbo. ");
INSERT INTO oboNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Waa tinodduwan nod pokolampas to tohodnonaw rin. Piru od pokoloppa ra kos tinodduwan taddot kandin no tohodnonaw, otik notuihan din don iddos langun no sinorollan tat tohodnonaw rin. ");
INSERT INTO oboNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Mambot oray kow'd kita to disok no possok diyot mata to duma, piru id podtohon dow kos batang duwot mata row? ");
INSERT INTO oboNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Na momonnu kow man od poko‑oseng diyot duma no, ‘Suwod, od ongayon ku kos possok to mata ru,’ no waa row man nokita kos batang duwot mata row? Od po‑uvag‑uvag kow! Unna‑a row pa man ongaya kos batang duwot mata row amoy oraroy row od kokita tod angoy iddos possok to duma. ");
INSERT INTO oboNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Iddos moppiyon kayu, konna en od bovunga to morat woy iling mandad tadda, dos morat no kayu, konnod bovunga to moppiya. ");
INSERT INTO oboNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Dos ipat kayu, od kokilaa ukit to bunga tadda. Ponunggeleng, iddos kayu no duhiyon, waa od kopupu no igera pomon tadda, woy waa od ka‑angoy no ubas pomon diyot baahon. ");
INSERT INTO oboNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Na iling mandad tadda, od kokilaa ta kos minuvu ukit to osengan din. Dos moppiyon minuvu, moppiya kos pusung din, de‑en moppiya mandad kos osengan din. Piru iddos morat no minuvu, morat kos pusung din, de‑en morat mandad kos osengan din. Oyyos ko ondan kos diyot pusung to minuvu, idda en mandad kos od leggua riyot bivig din.” ");
INSERT INTO oboNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Mambot od ngoranan a nikiyu no, ‘Longaggon,’ no waa kow man id tuman tod osengon ku koniyu? ");
INSERT INTO oboNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Id paabbotlabbot ku koniyu iddos minuvu nod porani koddi, dos id pominog to koddin mgo osengan woy dos od tuman tadda. ");
INSERT INTO oboNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Noko‑iling sikandin to minuvu no id poohinat to baoy. Id po‑unsad din iddos tuddok diyot moraom no duwon mosalig no batu. To id lonoggan iddon baoy, waa en nomonnu su mosalig man kos po‑unsaran. ");
INSERT INTO oboNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Na, idda mandad so minuvu no nokorinog to koddin mgo osengan, piru waa id tuman, noko‑iling sikandin to minuvu no mid poohinat to baoy no waa po‑unsaran. To id lonoggan iddon baoy, idda ron en, nopiloy idda woy nohobbahobba en.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nopongnga ni Disas tid oseng idda langun diyon to mgo minuvu, mid undiyon sikandin to Capernaum. ");
INSERT INTO oboNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na rutun, duwon sokkad no kopitan to mgo sundau to Roma. Duwon sudsuhuwon din no id dokollan din to ginawa no novohokan woy asow ron od patoy. ");
INSERT INTO oboNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","To norinog taddot kopitan iddos moka‑atag ki Disas, id popiyod din iddos od pombuyyahon to mgo Judio amoy'd nganoy ki Disas no od undiyonnan din woy'd bowiyan iddos sudsuhuwon din. ");
INSERT INTO oboNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","To kod‑inguma ran, id po‑eru‑eru sikandan ki Disas. Kahi ran to, “Kolimulimu, tovangiyu iddos kopitan su ollog en sikandin nod tovangan, ");
INSERT INTO oboNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","oyyos dakkoo kos ginawa rin keta no mgo Judio, woy sikandin kos id povovaa to simba‑an doy ka‑ay'n lugaa.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","De‑en id duma si Disas kandan. Piru to morani ron sikandin diyot baoy, id suhu taddot kopitan iddos mgo oukuy rin no od tommuwon dan si Disas woy'd po‑osengan to, “Longaggon, yo kad od luggatluggat nod allus, su konna a ollog nod po‑usok kikow riyot baoy ku. ");
INSERT INTO oboNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Konna a ollog ahad kodtommu ra en kikow. Osengow robbo woy od ko‑uliyan en iddos sudsuhuwon ku. ");
INSERT INTO oboNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nokosaddoo a ka‑ay, oyyos ahad siyak, no‑iraom a to kotungud taddot mowwet pa koddi, woy duwon mandad mgo sundau no no‑iraom to koddin kotungud. Otid ikahi a riyot sokkad no, ‘Ipanow kad,’ na od ipanow en sikandin. Woy otid ikahi a riyot sokkad no, ‘Undini ka,’ na od undini en sikandin. Woy otid ikohiyan ku iddos koddin uripon no, ‘Puungiyu ini,’ na od puungan din en.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","To norinog idda ni Disas, nosoobbuwan sikandin woy id isau riyot mgo minuvu no id tintinundug kandin, kahi rin to, “Od ikohiyan ku sikiyu, no waa poron nokita ku no minuvu no dakkoo kos kodsalig iling ka‑ay, ahad dini to Israel.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na, to id uli ron iddos id popiyod taddot kopitan, nokita ran no no‑uliyan don iddos sudsuhuwon. ");
INSERT INTO oboNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Waa nouhoy pomon tadda, mid undiyon si Disas to bonuwa no id ngoranan to Nain. Id duma mandad kandin iddos mgo tinodduwan din woy dos oray'n mo‑uraan minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","To morani ron sikandan diyot sobbangan to bonuwa, nokosuggung dan to mgo minuvu nid sayung to minatoy amoy id lobbong. Dos id patoy, budtung no anak to ba‑ay'n bau. Mo‑uraa kos mgo minuvu no id duma taddot bau amoy'd loobbong. ");
INSERT INTO oboNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","To nokita ni Disas iddos bau, no‑eruwan sikandin woy id ikohiyan din to, “Yo kad od sinoggow.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na, id porani si Disas woy id somaddan din iddos id soyungan taddot minatoy, de‑en id soro iddos id ponsayung. Kahin Disas to, “Oto, onnow kad.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Idda ron en, id livod kos songnga taddot konakan, woy id onnow sikandin woy noko‑ooseng don. Nopongnga, id ikohiyan ni Disas dos inoy to, “No‑uyag don kos anak du, ini rad sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","To nokita idda taddot mgo minuvu, oraroy ran no nosoobbuwan woy id doong dan kos Monama. Kahi ran to, “Id po‑undini to Monama ka‑ay't keta inis motuus no propeta, su amoy od tavang keta no mgo minuvu rin!” ");
INSERT INTO oboNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na iddos dinoggan moka‑atag taddot id puungan ni Disas, nokoso‑ob diyot langun no lugaa no sakup to Judea woy riyot morani no mgo bonuwa. ");
INSERT INTO oboNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na iddos mgo tinodduwan ni Juan no Tohodboutismu, id undiyon to prisuwan amoy od ponudtuu kandin moka‑atag taddot langun no pinuungan ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","To norinog idda ni Juan, id po‑undiyon din to ki Disas iddos oruwon tinodduwan din amoy od intud ko sikandin don be‑en kos Mesiyas o od angat pa to ossa? ");
INSERT INTO oboNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","To id inguma ron sikandan diyot ki Disas, mid intud dan kandin, kahi ran to, “Id po‑undini koy ni Juan no Tohodboutismu amoy od intud ko sikkow ron be‑en kos Mesiyas o od angat koy pa to ossa?” ");
INSERT INTO oboNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na daom to iddon allow, id bowiyan ni Disas dos mo‑uraan od kovohokan. Id poleggua rin iddos mgo busow no id lasud to mgo minuvu woy id bowiyan din iddos mgo butud. ");
INSERT INTO oboNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Id osengan ni Disas iddos id suhu ni Juan, kahi rin to, “Livod kow riyot ki Juan, woy ponudtuu row kandin iddos langun no nokita woy norinog dow. Oyya su iddos mgo butud nokokita ron, dos mgo pungku od poko‑ipanow ron, iddos duwon bohok no et‑et no‑uliyan don, dos diid dinog nokorinog don woy dos id poomatoy nongovadnow woy noponudtulan don mandad to Moppiyon Dinoggan iddos mgo worowora. ");
INSERT INTO oboNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ponudtuu row mandad kandin no moppiya kod kotomanan taddot minuvu no waa kodduworuwa koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na, to id ipanow ron iddos mgo minuvu no id suhu ni Juan, mid ooseng si Disas moka‑atag ki Juan diyon to mo‑uraan minuvu. Kahi rin to, “To kod‑undiyon dow to ki Juan to riyon pa sikandin to noka‑awoy‑awoy'n lugaa, ondan man kos id imman dow nod kokita? Idda vo so minuvu no od kopalinpalin kos poomdom iling to aggi nod kopiyodpiyod to kaamag? ");
INSERT INTO oboNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na, ondan man kos id kopi‑i row nod kokita rutun? Idda vo so minuvu no id oumpak to mahaa? Konna en! Su iddos od oumpak to ungketen, diyon da id oubpa to polasyu. ");
INSERT INTO oboNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ondan kos id kopi‑i row nod kokita rutun? Idda vo so propeta? Oyya en, woy od ikohiyan ku sikiyu, no lampas pa sikandin to dumon mgo propeta. ");
INSERT INTO oboNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Oyyos sikandin en iddos no‑ikahi riyot Nosulat no Kahit Monama no mid ungketen to, ‘Id popiyod ku iddos koddin tohodponudtuu no od unna kikow amoy'd panoy to kod‑inguma ru.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na ponayun mid ikahi si Disas to, “Od ikohiyan ku sikiyu, no waa poron minuvu no id tobbow ka‑ay to ampow't ingod no lampas pa ki Juan. Piru iddos minuvu no moobbava to langun no no‑iraom to kodharit Monama, lampas pa sikandin ki Juan.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","To norinog idda to langun no minuvu, labbi ron en iddos mgo tohodsukut to buhis, id tanggap dan no ollog en iddos puhawang to Monama, oyyos id poboutismu ron man sikandan ki Juan. ");
INSERT INTO oboNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Piru iddos mgo Pariseo woy mgo tohodnonaw to Suhu ni Moises, waa ran id poboutismu ki Juan, su id elleyan dan man iddos puhawang to Monama atag kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Na mid ikahi mandon si Disas to, “Ondan man kos od koponunggelengan ku to mgo minuvu to inin timpu? ");
INSERT INTO oboNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Noko‑iling sikandan to mgo anak nod ponggaaw riyot plasa, woy id po‑ikohiyoy ran diyot mgo duma ran to, ‘Id totogunggu koy atag koniyu, piru waa kow man sayow. Id pondaawit koy, piru waa kow man id sinoggow.’ ");
INSERT INTO oboNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Dos mgo minuvu to inin timpu, od poko‑iling en mandad taddon mgo anak, oyyos si Juan no Tohodboutismu no inaayun od puasa woy waa id inom tod pokohubug, od ikohiyon dow moho no id losuran sikandin to busow. ");
INSERT INTO oboNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Woy siyak no Anak to Minuvu, diyot kod‑undini ku, nokita row no id ka‑an woy id inom a. De‑en od ikohiyon dow moho no sopeton a woy polohubug, woy oukuy a kun to mgo tohodsukut to buhis woy dumon mosaasaa. ");
INSERT INTO oboNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Piru ahad ungketen, od kosorollan no ollog iddos nonaw ku woy dos nonaw ni Juan, oyyos od koposivonnalan idda riyon to ko‑ontayan taddot mgo minuvu no id pomakoy.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Duwon sokkad no Pariseo no id ngoranan ki Simon no mid inggat ki Disas nod ka‑an diyot baoy rin. De‑en id undiyon sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na rutun no bonuwa, duwon sokkad no ba‑ay'n mosaasaa. To nosorollan din no riyon si Disas to baoy taddot Pariseo, mid undiyon sikandin woy id piyod to pomammut no nokota‑aw riyot tootawwan no id bovallan pomot batu nod ngoranan to alabastro. ");
INSERT INTO oboNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Id porani sikandin diyot inoyyuhan ni Disas woy mid lingko‑od diyon lomig to pa‑a rin. Id sinoggow sikandin no id lommos din to dayas iddos pa‑a ni Disas. Na, id punasan din idda to bowvuut uu rin woy id oorokkan. Nopongnga, id doddasan din idda to pomammut. ");
INSERT INTO oboNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","To nokita taddot Pariseo nid inggat ki Disas iddos id puungan taddot ba‑ay, kohingginawa rin to, “Te, otik mooggot no propeta inin minuvu, od kosorollan din nanoy ko ondan ikon ba‑ay, su oray mohon mosaasaa ika.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Piru nosorollan ni Disas kos diyot poomdom din, de‑en mid ikahi sikandin to, “Simon, duwon od osengon ku kikow.” Mid tavak si Simon to, “Ondan man, Tohodnonaw?” ");
INSERT INTO oboNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kahin Disas to, “Duwon oruwon minuvu no noko‑utang to soopi riyot tohodposamboy. Dos sokkad, id outang to limmon gatus woy dos sokkad, limmompuu. ");
INSERT INTO oboNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","To nosorollan taddot tohodposamboy no waa en id pokovayad dan tadda, id podwora rin don iddos utang dan. Na, ondoy musing kandan kos duwon lampas pa no ginawa taddot tohodposamboy?” ");
INSERT INTO oboNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mid tavak si Simon to, “Idda ayu so dakkoo kos no‑utang.” Kahin Disas to, “Ollog kos tavak du.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na id loingoy si Disas diyot ba‑ay, woy kahi rin ki Simon to, “Ontongngiyu man inis ba‑ay. To kod‑inguma ku ka‑ay't baoy ru, waa a nikkow boggayi to oweg nid unab to pa‑a ku, piru sikandin, id lommos din to dayas kos pa‑a ku woy id punasan din to bowvuut uu rin. ");
INSERT INTO oboNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Waa ka id olit‑olit koddi ukit to kod‑arok, piru inis ba‑ay, pomon to kod‑usok ku, waa soroan din to kod‑arok to pa‑a ku. ");
INSERT INTO oboNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Waa ru doddasi to lana kos uu ku, piru sikandin, id doddasan din to pomammut kos pa‑a ku. ");
INSERT INTO oboNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","De‑en od ikohiyan ku sikkow, no ahad dakkoo kos saa ka‑ay'n ba‑ay, id posinsyan don idda to Monama, de‑en dakkoo kos ginawa rin koddi. Piru iddos minuvu no noposinsyan to disok no saa, disok mandad kos ginawa rin.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Na id ikohiyan ni Disas iddos ba‑ay to, “Id posinsyan don kos mgo saa ru.” ");
INSERT INTO oboNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Iddos mgo minuvu no id ka‑an duma ki Disas, kohingginawa ran to, “Te, inin minuvu, dii od pokoposinsya to mgo saa, oyyos Monama ra en kos od pokopuung tadda!” ");
INSERT INTO oboNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Piru id osengan mandon ni Disas iddos ba‑ay, kahi rin to, “Notobbus kad pomon to kopomakoy ru. Na, uli kad bo duma to kosunayan.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Waa nouhoy pomon tadda, id lingkus ni Disas iddos mgo bonuwa woy mgo bariyu amoy od ponudtuu to Moppiyon Dinoggan moka‑atag to kodharit Monama. Id duma kandin iddos sopuu‑oruwon tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Duwon mandad mgo ba‑ay nid duma kandin no id bowiyan din pomon to mgo bohok dan, woy dos duma, id poleggua rin iddos mgo busow no id lasud kandan. Dos sokkad tadda, si Maria no toho Magdala no duwon pittun busow nid lasud kandin no id poleggua rin. ");
INSERT INTO oboNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Id duma mandad kandan si Juana no sawa ni Cusa no sinolihan diyot polasyu ni Harin Herodes. Iddos duma, si Susana woy mo‑uraa pon mgo ba‑ay no id potommu to mgo ko‑ilonganon onni Disas ukit to kandan no soopi. ");
INSERT INTO oboNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sokkad no allow, mid undiyot ki Disas iddos mo‑uraan minuvu no id pomon diyon to nokod‑osso‑osson mgo bonuwa. To nolivuung don sikandan, id itulan dan ni Disas to ponunggelengan. ");
INSERT INTO oboNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Kahi rin to, “Duwon sokkad no minuvu no id undiyon to kamot amoy'd savud to bonni. Na, duwon mgo bonni no nongo‑uug diyot daan, de‑en noheddan idda to mgo minuvu woy id ponuktuk to mgo manuk nod layanglayang. ");
INSERT INTO oboNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dos duma, nongo‑uug diyot botuwon. Id tuvu rad idda, piru naanos su motokkang kos livuta. ");
INSERT INTO oboNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dos duma, nongo‑uug diyot sopiniton. To id tuvu iddos bonni woy sopinit, nokubmutan iddos lammid lottob no bonni. ");
INSERT INTO oboNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Piru iddos duma, nongo‑uug diyot moppiyon livuta. Na, moppiya kos tuvu tadda woy oray'n dakkoo kos nokottu.” Na kahin Disas to, “Sikiyu, su duwon man tolinga row, pa‑ayyad kow pominog.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na, id intud iddos mgo tinodduwan ni Disas ko ondan kos kohulugan taddot ponunggelengan din. ");
INSERT INTO oboNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mid tavak si Disas to, “Sikiyu, id boggayan kowd to Monama to koovottan taddot waa rin id posaddoo dangan moka‑atag to kodhari rin. Piru riyot duma, id po‑ukit ku to mgo ponunggelengan, su amoy ahad od totongtong dan, dii ran od pokokita woy ahad od pominog dan, dii ran od pokaabbot.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na, id paabbotlabbot ni Disas iddos kohulugan taddon ponunggelengan. Kahi rin to, “Iddos bonni, idda en so kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Dos daan no no‑uuhan to bonni, idda en so mgo minuvu no nokorinog to kahit Monama. Piru id undiyon si Moivuyan woy id ahaw rin iddos kahi no nokopomuwa riyot pusung dan amoy dii ran od pokopomakoy woy diid kotobbus. ");
INSERT INTO oboNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na iddos botuwon no no‑uuhan to bonni, idda en so nokorinog to kahit Monama woy idda ron en, nahaa ran to kodtanggap tadda, piru waa goli nokodoralig diyot pusung dan woy sinsinahaw ra kos kopomakoy ran. Oyya su otid inguma kos kodgeddam pomon to kodtanggap dan to kahit Monama, konnad sikandan od ponayun. ");
INSERT INTO oboNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Dos sopiniton no no‑uuhan to bonni, idda en so mgo minuvu no id pomakoy rad, piru iling tid kubmutan iddos kahit Monama taddot mgo sowkuu moka‑atag to kod‑oubpa ran, kodginawa to soopi woy dos kahaan ka‑ay to ampow't ingod, de‑en waa idda nokobovunga. ");
INSERT INTO oboNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Piru iddos moppiyon livuta no no‑uuhan to bonni, idda en so id pominog to kahit Monama woy id pomuwa ran idda riyot pusung dan. Od kosolihan sikandan woy moppiyon minuvu, woy id ponayun dan nid pomakoy taman tid undag to moppiyon mgo bunga.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Na duwon mandon ponunggelengan ni Disas, kahi rin to, “Waa minuvu nod loottom to suu woy od poongkobban din idda to lobban o id ta‑aw rin diyot silob to katri, ko konna, id ta‑aw rin idda riyot od sopatan amoy'd kotorawwan iddos od usok to baoy. ");
INSERT INTO oboNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Iling mandad tadda, iddos ahad ondan no noko‑ollos woy diid koovottan ko‑ungkay, od kosorollan woy'd koovottan en diyot mori. ");
INSERT INTO oboNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","De‑en pa‑ayyad kow pominog, su iddos minuvu no nokaabbot taddot norinog din, od duhangan pe‑en kos koovottan din. Piru iddos waa id pa‑ayyad id pominog, od ongayon pe‑en ahad iddos disok no kunan din ko noovottan din.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na, id inguma iddos inoy woy mgo suwod ni Disas su duwon od osengon dan, piru waa ran nokoporani kandin pomon to ko‑uralloy to minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","De‑en duwon id ikahi kandin to, “Sir, iddos inoy woy mgo suwod du, id aangat diyot leggua su id kopi‑i ran nod pokidkita kikow.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mid tavak si Disas to, “Oyya, piru iddos inoy ku woy mgo suwod ku, idda en so mid pominog to kahit Monama woy'd tuman tadda.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sokkad no allow, mid ikahi si Disas diyot mgo tinodduwan din to, “Od undiyon ki to dipaa to lanow.” De‑en id sakoy ran to bollangay. ");
INSERT INTO oboNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Laggun tid pomollangay ran, nokotinuhon si Disas. Todtahad, id doppot kos monokkaan kaamag diyon to lanow, de‑en od koponnu ron asow to oweg iddos bollangay woy disok sama od koonnod. ");
INSERT INTO oboNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na id porani ki Disas iddos mgo tinodduwan woy id sukaa ran sikandin, kahi ran to, “Tohodnonaw, tovangi koy! Od koonnod kid man moho ini!” Na, id onnow si Disas woy id sugga rin iddos kaamag woy dos monokkaan mgo baud. Idda ron en, id soro iddos kaamag woy id tivonok kos langun. ");
INSERT INTO oboNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kahin Disas kandan to, “Ingkon don man kos kopomakoy row?” Novaakkan sikandan woy nosoobbuwan, woy id po‑ikohiyoy ran to, “Ondoy moho inin minuvu no ahad iddos kaamag woy mgo baud, id dumoruma kandin!” ");
INSERT INTO oboNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na, ponayun id pomollangay onsi Disas taman to id dunggu ran diyot lugaa to mgo toho Gerasa no riyot dipaa to Lanow't Galilea. ");
INSERT INTO oboNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","To id ponog si Disas pomon diyot bollangay, duwon minuvu nid losuran to mgo busow no id sinuggung kandin. Nouhoy ron no timpu no waa sabpong to lawa rin, woy worad sikandin id oubpa riyot baoy su riyon dobbo en sikandin id oubpa to lovongngan. ");
INSERT INTO oboNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","To nokita si Disas taddot minuvu, id lingko‑od sikandin diyot isowwan din woy id pehes no mid ungketen to, “Disas, Anak to Monama no Lampas to Langun, ondan man kos lavut du koddi? Kolimulimu, yo a siluti!” ");
INSERT INTO oboNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Id oseng din idda, su id suhu man ni Disas iddos busow no od leggua pomon kandin. Iddot id lihad no timpu, id tomongngan sikandin to mgo minuvu woy id baku ran to kodina kos bollad din woy id pasung pe‑en kos pa‑a rin, piru id dorattan din da en idda. Woy id pohos sikandin taddot busow no od oubpa riyot noka‑awoy‑awoy'n lugaa. ");
INSERT INTO oboNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na id inturan sikandin ni Disas, kahi rin to, “Ondoy kos ngaran du?” Mid tavak sikandin to, “Maanmaan kos ngaran ku.” Id oseng din idda, su mo‑uraa man no busow kos id lasud kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Id po‑eru‑eru ki Disas iddos mgo busow no konna rin sikandan od uuhon diyot bobbo no waad tomanan kos koroomman. ");
INSERT INTO oboNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na riyot londig, duwon mo‑uraan bavuy nid ponuwaa. De‑en id po‑eru‑eru ran no od po‑olinon nod lasud diyot mgo bavuy, woy id aman si Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Idda ron en, id ponleggua iddos mgo busow pomon diyot minuvu woy id losuran dan iddos mgo bavuy. Id pouharus idda riyot daama woy nongo‑uug diyot lanow woy nongoonnod. ");
INSERT INTO oboNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na, to nokita idda to mgo tohodtamong to bavuy, id lungkossu ran, woy id ponudtuu ran iddos notomanan diyot mgo minuvu no id ubpa riyot bonuwa woy riyot mgo lugaa no nokolingkus dutun. ");
INSERT INTO oboNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","De‑en id undiyon iddos mgo minuvu amoy'd kokita ran ko ondan kos notomanan. To kod‑inguma ran diyot ki Disas, nokita ran iddos minuvu no id losuran to mgo busow. Id ounsad sikandin diyot isowwan ni Disas, noko‑oumpak don woy motallong don kos poomdom din. De‑en oraroy ran no novaakkan. ");
INSERT INTO oboNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na, iddos mgo minuvu no nokokita taddon notomanan, id ponudtuu ran diyot duma ko momonnu no no‑uliyan iddos minuvu no id losuran to mgo busow. ");
INSERT INTO oboNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Iddos langun no minuvu no id oubpa riyot nokolingkus no lugaa to mgo toho Gerasa, id ikohiyan dan si Disas no od awa riyot lugaa ran pomon to oraroy ran no novaakkan. De‑en id livod si Disas diyot bollangay amoy'd awa. ");
INSERT INTO oboNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","To id penek don sikandin, id po‑eru‑eru kandin iddos minuvu no no‑uliyan don no od porumannon sikandin ni Disas. Piru id ikohiyan din iddos minuvu to, ");
INSERT INTO oboNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Iyon moppiya, uli kad diyot koniyu woy ponudtuu ru kos langun no id puungan to Monama atag kikow.” De‑en id uli sikandin, woy id ponudtuu rin diyon to intirut bonuwa iddos langun nid puungan ni Disas kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","To id inguma onsi Disas diyot dipaa to lanow, nahaa iddos mo‑uraan minuvu su id aangat dan kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na, duwon id inguma no sokkad no ponguu to simba‑an to mgo Judio no id ngoranan ki Jairo. Mid lingko‑od sikandin diyot isowwan ni Disas woy id po‑eru‑eru nod undiyon si Disas to baoy rin, ");
INSERT INTO oboNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","oyyos od oumasoy ron iddos budtung no anak din no ba‑ay no mgo sopuu‑oruwa ron kos idad. To id duma ron si Disas kandin, id tinundug mandad iddos mo‑uraan minuvu no id pososokoy riyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dutun, duwon mandad sokkad no ba‑ay no duwon bohok nod longossan no diid soro daom don to sopuu‑oruwon lahun. Na‑amin don kos langun no koruwonnan din amoy'd ko‑uliyan, piru waa en ahad sokkad no nokovawi kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na, id lotlot sikandin diyot inoyyuhan ni Disas amoy'd somad taddot ubpu to umpak din. Idda ron en, id soro iddos bohok din nod longossan. ");
INSERT INTO oboNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Id inturan sikandan ni Disas, kahi rin to, “Ondoy kos id somad to umpak ku?” Id tavak sikandan to, “Tovo, waa saddoo roy.” Kahin Pedro to, “Tohodnonaw, diid kosorollan ko ondoy su mo‑uraa man kos od sosok kikow.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Piru mid ikahi si Disas to, “Duwon en id somad koddi, su noheddam ku no duwon kotuusan no id leggua pomon koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","To nosorollan taddot ba‑ay no waa noko‑ollos iddos id puungan din, id porani sikandin nid kookoo woy mid lingko‑od diyot isowwan din. Na, id ponudtuu rin ki Disas diyot isowwan to mgo minuvu iddos unayan no id somad sikandin taddot umpak din, woy dos tigkow sikandin no‑uliyan. ");
INSERT INTO oboNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","De‑en mid ikahi si Disas to, “Uri, no‑uliyan kad pomon to kopomakoy ru. Na, uli kad bo duma to kosunayan.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Laggun tid oseng din idda, duwon minuvu no id inguma pomon diyot baoy ni Jairo. Kahi rin to, “Poonna ruk ginawa ru, worad iddos anak du. Yo rud lewanga kos tohodnonaw.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Piru to norinog idda ni Disas, id ikohiyan din si Jairo to, “Yo kod kaanu. Salig ka ra, oyyos od ko‑uliyan dad iddos anak du.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","To id inguma ron si Disas diyot baoy, iyon da id poruma rin nod usok, si Pedro, si Juan, si Santiago woy idda mandad so amoy woy inoy tat anak. ");
INSERT INTO oboNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Langun taddot mgo minuvu no riyot daom, id pondaawit. Kahin Disas to, “Yo kow'd sinoggow, oyyos waa id patoy inis anak, ko konna, id tinuhon da.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Piru id kosu‑atan dan da en sikandin, su nosorollan dan no id patoy ron iddos anak. ");
INSERT INTO oboNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Na, id somaddan ni Disas iddos bollad taddot anak woy mid ikahi sikandin to, “Idi, onnow kad.” ");
INSERT INTO oboNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Idda ron en, id livod kos songnga taddot anak woy id onnow sikandin. Nopongnga, id ikohiyan dan ni Disas no od pokannon iddos anak. ");
INSERT INTO oboNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nosobbuwan iddos inoy woy amoy taddot anak, piru id loglohottan dan ni Disas no konna ran id ponudtuu riyon to ahad ondoy iddon notomanan. ");
INSERT INTO oboNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na id umow ni Disas iddos sopuu‑oruwon tinodduwan din, woy id boggayan din sikandan to kotuusan woy kotungud to kodpoleggua to mgo busow woy to kodbawi tod pongkovohokan. ");
INSERT INTO oboNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Id suhu rin sikandan amoy'd ponudtuu to langun moka‑atag to kodharit Monama woy amoy od bawi tod pongkovohokan. ");
INSERT INTO oboNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na id pomonduwan ni Disas iddos mgo tinodduwan din, kahi rin to, “Yo kow'd piyod to ahad ondan diyot iponawon dow, iling to tukod, kavii, koka‑an, soopi ahad ilisan. ");
INSERT INTO oboNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Otik duwon od inggat koniyu nod oubpa riyot baoy rin, yo kow'd alin diyot osson baoy taman tod awa kow taddon bonuwa. ");
INSERT INTO oboNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Piru otid poko‑inguma kow riyot lugaa no waad tanggap koniyu o konnod pominog to nonaw row, na tonani row idda woy podpara row kos boubbuk to livuta riyot pa‑a row to kod‑awa row, patow no waa id pokosondit dan koniyu riyot timpu nod silutan sikandan to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na, id ipanow ran woy undiyon to mgo bariyu amoy'd ponudtuu to Moppiyon Dinoggan woy id bowiyan dan iddos od pongkovohokan. ");
INSERT INTO oboNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","To norinog ni Herodes no gubernador to Galilea iddos moka‑atag taddot pinuungan ni Disas, oray sikandin no notaong. Oyyos duwon mgo minuvu nid ikahi no sikandin kun si Juan no Tohodboutismu no novadnow pomon diyot kopotayan. ");
INSERT INTO oboNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Woy duwon duma nid ikahi no sikandin si Elias. Duwon mandad duma no id ikahi no sokkad sikandin taddot mgo propeta dangan no novadnow ron. ");
INSERT INTO oboNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Piru mid ikahi si Herodes to, “Id potompoddan kud man to liyog si Juan. Ondoy ayu inis minuvu nod tommanon dan?” Pomon tadda, id nangkap si Herodes to po‑ukit no od kokita rin si Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na, to id livod don diyot ki Disas iddos mgo apostoles, id ponudtuu ran kandin iddos langun no pinuungan dan. Nopongnga, id duma rin sikandan diyot bonuwa to Betsaida no siksikandan da. ");
INSERT INTO oboNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Piru to nosorollan taddot mo‑uraan minuvu no nokologkiyat don onsi Disas, id tundug dan kandin. Na, id olit‑olit dan ni Disas woy id ponudtuu rin kandan iddos moka‑atag to kodharit Monama. Id bowiyan din mandad iddos od pongkovohokan. ");
INSERT INTO oboNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","To od komapun don, id porani ki Disas iddos sopuu‑oruwon tinodduwan din woy mid ikahi to, “Iyon ayu moppiya no od po‑undiyonnon du to mgo bariyu inis mo‑uraan minuvu amoy od pokonangkap to koka‑an woy'd ko‑owottan, su noka‑awoy‑awoy inin lugaa.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Piru kahin Disas kandan to, “Sikiyu kos od poka‑an kandan.” Kahi ran to, “Eh, toonaw ra man limmon paan woy oruwon ngaap inis ka‑ay't keta. Momonnu koy man od pokovolli to koka‑an atag ka‑ay't langun no minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Id oseng dan idda su iddos ko‑uralloy to mgo mama, mgo limmon maan (5,000). Na kahin Disas diyot mgo tinodduwan din to, “Po‑unsara row sikandan woy livuunga row to tinlimmompuu.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","De‑en id pon‑unsad iddos mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Na, id angoy ni Disas iddos limmon molison no paan woy oruwon ngaap, woy id langngag sikandin diyot datas to langit woy id posolamat diyot Monama. Nopongnga, id pontoppiktoppik din idda woy id boggoy rin diyot mgo tinodduwan din amoy id sondad diyot mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na, nokoka‑an dan langun woy nongovuung. Nopongnga idda, id temmos taddot tinodduwan din iddos nongosama no nokoponnu pe‑en to sopuu‑oruwon bukag. ");
INSERT INTO oboNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sokkad no allow, id dasaa si Disas no siksikandin da. Nopongnga, id inturan din iddos mgo tinodduwan din, kahi rin to, “Ondoy a man diyot poomdom to mgo minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mid tavak sikandan to, “Duwon mid ikahi no sikkow kun si Juan no Tohodboutismu. Dos duma mid ikahi no sikkow si Elias, woy duwon duma nid ikahi no sokkad ka taddot mgo propeta dangan no novadnow ron.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kahin Disas to, “Piru atag koniyu, ondoy a man?” Mid tavak si Pedro to, “Sikkow en kos Mesiyas no id popiyod to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na, id loglohottan ni Disas dos mgo tinodduwan din no dii ran id ponudtuu riyot ahad ondoy iddos moka‑atag kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na mid ikahi si Disas to, “Siyak no Anak to Minuvu, ko‑ilangan nod ukit to mo‑uraan kodposuppit woy od elleyan a taddot od pombuyyahon to mgo Judio, dos mgo ponguu to tohodbuwis woy dos mgo tohodnonaw to Suhu ni Moises. Od imotayan a, piru riyot iko‑otollun allow, od kovadnow a.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na id osengan ni Disas iddos mo‑uraan minuvu, kahi rin to, “Iddos ahad ondoy no od kopiyan nod kovovallan no tinodduwan ku, ko‑ilangan nod inoyyuhan din kos kandin nid kopi‑i, woy od tiyangon din iddos kandin no krus amoy'd dumoruma koddi. ");
INSERT INTO oboNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Su iddos minuvu nod konuhunan to umuu rin, od koworan da en baling tadda. Piru iddos ahad ondoy nod patoy pomon to koddumoruma rin koddi, duwon umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Oyyos ahad od kokomunoy to minuvu kos langun no korotuwan ka‑ay to ampow't ingod, waa en koru‑anon otid koworan sikandin to umuun waad tomanon, su iddos od ingumannon din, idda en so linow't apuy. ");
INSERT INTO oboNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Na, iddos ahad ondoy nod ko‑ilow koddi woy taddot mgo nonaw ku, siyak no Anak to Minuvu, id ko‑ilow ku mandad sikandin init kodlivod ku. Od posivontuhan a woy'd kokita to langun iddos se‑aa to kotuusan ku, woy dos se‑aa to kotuusan to Amoy ku woy idda mandad so uhis no mgo ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Bonnaavonnaa nod ikohiyon ku koniyu, no duwon duma ka‑ay no dii pa od patoy taman to dii ran pa od kokita iddos kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na, to id lihad don kos sokkad no simana nopongnga mid oseng si Disas tadda, id poruma rin si Pedro, si Juan woy si Santiago po‑undiyon to buvungan amoy'd dasaa. ");
INSERT INTO oboNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Laggun tid dasaa si Disas, id se‑aa kos bonnong din, tigkow nopalin kos boyo rin woy dos umpak din, id sella‑sella pomon to koputiyoy. ");
INSERT INTO oboNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na idda ron en, nokita ran iddos oruwon minuvu no id tongko ki Disas. Sikandan, si Moises woy si Elias. ");
INSERT INTO oboNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Woy id sella‑sella mandad kos boyo ran. Dos tongkoanan dan, moka‑atag taddot od ingumon kopotayan ni Disas diyot Jerusalem amoy od kotuman iddos puhawang to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na onsi Pedro, nokotintinuhon. To nokohimata ron sikandan, nokita ran si Disas no id se‑aa woy idda mandad so oruwon minuvu nid lohinat duma kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","To od tanan don onsi Moises, kahin Pedro ki Disas to, “Tohodnonaw, moppiya en no ka‑ay ki. Od sosabbong koy to otollu, sokkad atag kikow, sokkad atag ki Moises woy sokkad atag ki Elias.” Id oseng ni Pedro idda pomon to waa rin nonongnongngi ko ondan kos od osengon din. ");
INSERT INTO oboNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Laggun tod ooseng poron sikandin, duwon souhapun no id tambun kandan woy oraroy ran no novaakkan. ");
INSERT INTO oboNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na, duwon bawos no id pomon diyot souhapun no mid ungketen to, “Ini en kos Anak ku no id aam ku. Pominogga row sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","To id soro ron iddos bawos, si Disas dobbo kos nokita ran. To nouhoy'n timpu, waa ran id ponudtuu riyot ahad ondoy iddos nokita ran. ");
INSERT INTO oboNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","So‑op no allow, id potupang don onsi Disas pomon diyot buvungan woy mo‑uraan minuvu nid sinuggung kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Duwon sokkad kandan no id umow ki Disas, kahi rin to, “Tohodnonaw, kolimulimu, ko‑eruwan ka ka‑ay't budtung no anak ku. ");
INSERT INTO oboNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Inaayun sikandin od uriponnon to busow woy tigkow ron od pomehes, od pongookoo woy'd bovuwak kos bivig din. Woy od pomiliton sikandin taddot busow woy dii en od tokasan. ");
INSERT INTO oboNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Id nganoy ad diyot mgo tinodduwan du no od polegguangon dan iddos busow, piru waa ran man noko‑uli kandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kahin Disas to, “Sikiyu no mgo minuvu to inin timpu, waa en kopomakoy row woy ebbaw kow! Momonnu kouhayyoy kos koddumoruma ku koniyu, woy kannu pa ayu od kotaman inis kodti‑is ku koniyu? Piyoddow kos anak du ka‑ay't koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","To id porani ron iddos anak diyot ki Disas, id buntug sikandin taddot busow woy id pokookoo. Piru id poleggua ni Disas iddos busow woy idda ron en, no‑uliyan dos anak. Na, id boggoy ni Disas dos anak diyot amoy rin. ");
INSERT INTO oboNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nosoobbuwan iddos langun no minuvu pomon to kotuusan to Monama. Piru laggun to nosoobbuwan iddos mgo minuvu taddot id puungan ni Disas, mid ikahi sikandin diyot mgo tinodduwan din to, ");
INSERT INTO oboNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Poomdomma row inis od osengon ku koniyu. Siyak no Anak to Minuvu, id boggoy a riyot bollad taddot od pongkuntra koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Piru waa ran nokaabbot to kohulugan taddot id ikahi ni Disas, su iling to notombunan kos poomdom dan woy od kovaakkan dan nod intud kandin moka‑atag tadda. ");
INSERT INTO oboNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sokkad no allow, id po‑opuloy iddos mgo tinodduwan ni Disas ko ondoy kandan kos mowwet to langun. ");
INSERT INTO oboNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Piru nosorollan ni Disas kos diyot poomdom dan, de‑en id poporani rin iddos disok no anak woy id poohinat din diyot duug din. ");
INSERT INTO oboNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kahi rin to, “Iddos ahad ondoy nod tanggap ka‑ay't anak pomon to kopomakoy rin koddi, siyak kos id tanggap din. Woy dos ahad ondoy nod tanggap koddi, id tanggap din mandad iddos id popiyod koddi. Oyya su iddos mopoobbava to langun koniyu, sikandin kos mowwet to langun.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Na mid ikahi si Juan ki Disas to, “Tohodnonaw, nokokita koy to sokkad no minuvu no nokopoleggua to mgo busow ukit to ngaran du. Id sugga roy sikandin, oyyos konna ta man duma.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Piru kahin Disas to, “Yo row sikandin sugga‑a, su iddos konnod supak koniyu, od poomig koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na, to asow ron kos timpu to kodbatun ki Disas diyot datas to langit, id oggot din kos ginawa rin nod undiyon to Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Duwon mgo sinuhuwan nid po‑unna rin diyot sokkad no bariyu no sakup to Samaria, su amoy od pokopanoy ran atag to kod‑inguma rin. ");
INSERT INTO oboNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Piru iddos mgo minuvu rutun, waa id tanggap kandin, oyyos nosorollan dan man no od undiyon sikandin to Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","To norinog idda taddot mgo tinodduwan din no si Santiago woy si Juan, mid ikahi sikandan to, “Longaggon, id kopi‑i ru vo nod buyu koy riyot Monama no od popiyod sikandin to apuy pomon diyot datas to langit amoy'd kotutung sikandan?” ");
INSERT INTO oboNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Piru mid isau si Disas diyot kandan woy id sugga rin. ");
INSERT INTO oboNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nopongnga idda, id ponayun don sikandan nid undiyon to osson bariyu. ");
INSERT INTO oboNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na laggun tod ipanow sikandan, duwon minuvu no id ikahi ki Disas to, “Od duma a kikow ahad ingkon ka od undiyon.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Piru mid tavak si Disas to, “Moppiya pa kos mgo lokivot su duwon luyung to kayu nod ko‑ubpan, woy moppiya pa iddos mgo manuk nod layanglayang su duwon saag. Piru siyak no Anak to Minuvu, waa noto‑oo nod ko‑imooyyan ku.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Na mid oseng mandon si Disas diyot ossa pa no minuvu, kahi rin to, “Duma ka koddi.” Piru mid tavak sikandin to, “Longaggon, od uli a pa woy otik nolobbong don iddos amoy ku, od duma a kikow.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Piru kahin Disas kandin to, “Podtohonowd iddos minatoy no od lobbong taddot mgo minuvu no waa umuun waad tomanon. Piru sikkow, ipanow ka woy ponudtuu ru riyot mgo minuvu iddos moka‑atag to kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Duwon pe‑en ossa no mid ikahi ki Disas to, “Longaggon, od duma a kikow, piru po‑uliya a pa amoy'd poko‑obisu a to mgo korumannan ku.” ");
INSERT INTO oboNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Piru mid tavak si Disas to, “Iddos od tigkanoy ron nod somad to dadu no od loloingoy poron, konna ollog nod lonug to pinuungan to kodponudtuu moka‑atag to kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nopongnga idda, id aam tod Longaggon iddos pittumpuu‑oruwon minuvu no id pondumoruma kandin, woy id suhu rin sikandan nod unna kandin to tinduwa riyon to ipat bonuwa nod undiyonnan din. ");
INSERT INTO oboNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kahin Disas kandan to, “Iddos mgo minuvu, od poko‑iling to ommoy no ollog don nod kottuwon. Oray'n dakkoo kos od kottuwon, piru disok da kos mgo tohodkottu. De‑en buyuwa row riyot Monama no komunoy taddot ommayon amoy'd popiyod sikandin to mgo tohodkottu. ");
INSERT INTO oboNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na ipanow kowd. Piru pa‑ayyad‑ayyad kow, oyyos od poko‑iling kow to mgo karnero nod isau riyot movuut no mgo tuyyang. ");
INSERT INTO oboNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yo kow'd piyod to soopi, kavii, sandalyas woy yo kow mandad od sambang od totongko to ahad ondoy nod kotommu row riyot daan. ");
INSERT INTO oboNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Diyot kod‑usok dow to sokkad no baoy, unna kow vo oseng to, ‘Muopa nod pokotanggap to kosunayan iddos id ubpa ka‑ay'n baoy.’ ");
INSERT INTO oboNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na otik moppiya kos kodtanggap koniyu taddot id ubpa tadda, od pokotanggap en sikandan to kosunayan. Piru ko dii ran od tanggap koniyu, konna en mandad idda od puungan to Monama riyot kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Otik duwon od tanggap koniyu, diyon kow vo tahad oubpa to baoy rin taman tod awa kowd taddon bonuwa. Tonggapa row iddos ahad ondan no koka‑an woy'd inommon no id sondad koniyu, oyya su iddos minuvu nod puung, ollog en nod boggayan to langun no ko‑ilonganon din. ");
INSERT INTO oboNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Iddos ahad ingkon no bonuwa nod undiyonnan dow woy moppiya kos kodtanggap dan koniyu, kanna row iddos ahad ondan no id sondad dan koniyu. ");
INSERT INTO oboNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bowi‑i row iddos od pongkovohokan woy ponudtuli row iddos mgo minuvu no asow ron kos kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Piru ko iddos ahad ingkon no bonuwa nod undiyonnan dow, dii od tanggap koniyu, undiyon kow to doraanon woy osengi row iddos mgo minuvu rutun no, ");
INSERT INTO oboNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ahad iddos boubbuk to bonuwa row no ka‑ay't pa‑a roy, od podparon doy pe‑en, patow no waa id pokosondit dow konami. Piru ko‑ilangan nod kosorollan dow no asow ron kos kodharit Monama.’ ");
INSERT INTO oboNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Od ikohiyan ku sikiyu, no riyot allow to kodhukum, movoggat pa kos silut taddot id oubpa taddon bonuwa kuntra taddot mgo toho Sodoma.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Moka‑arat‑arat kod kotomanan dow no mgo toho Corazin woy sikiyu mandad no mgo toho Betsaida! Su mo‑uraa kos id puungan ku no mokososoobbu ruwot koniyu, piru waa kow en id sondit woy'd tanan to mgo saa row. Otik diyon ku pa idda puungi to Tiro woy Sidon, nouhoy ran don nanoy id oumpak to saku woy id ounsad diyot ibmukon, patow to kodsondit woy kodtanan dan to mgo saa ran. ");
INSERT INTO oboNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Diyot allow to kodhukum, otik movoggat man kos silut taddot mgo toho Tiro woy Sidon, lampas kow pe‑en. ");
INSERT INTO oboNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Woy sikiyu mandad no mgo toho Capernaum, kunan dow ayu kod inguma kow taman to langit. Piru id subbuk kow ra vos en baling diyon to linow't apuy.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Na mid ikahi si Disas diyot mgo tinodduwan din to, “Iddos ahad ondoy nod pominog koniyu, id pominog a mandad nikandan. Woy dos ahad ondoy nod elle koniyu, id elleyan a mandad nikandan. Iddos ahad ondoy nod elle koddi, id elleyan dan mandad kos Monama nid popiyod koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","To id livod don iddos pittumpuu‑oruwa no id suhu ni Disas, oraroy ran no nahaa no mid ponudtuu kandin moka‑atag taddot iponawon dan. Kahi ran to, “Longaggon, ahad iddos mgo busow, id dumoruma konami to id poleggua roy ukit to kikow'n ngaran.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kahin Disas kandan to, “Nokita ku en si Moivuyan no no‑uug iling to kilat pomon diyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yo kow'd kolingow! Id boggayan kud sikiyu to kotungud, amoy ahad od koheddan dow kos mgo uwod woy mgo topilak, dii kow en od komonnu, woy dii kow mandad od kotalu taddot kuntra row no si Moivuyan. ");
INSERT INTO oboNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Piru yo kow'd kahaa no id tuman iddos mgo busow to id poleggua row sikandan, ko konna, kahaa kow su iddos ngaran dow, nokosulat don diyot datas to langit.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","To iddon timpu, nahaa si Disas ukit to Uhis no Ispiritu woy mid ikahi sikandin to, “Amoy ku, sikkow en kos Monama no komunoy to langit woy livuta. Od doongon ku sikkow, su iddos kovonnaan no waa ru id posaddoo riyot mgo minuvu nod ikahi no mopandoy woy moraom kos koovottan, diyon du id posaddoo to mgo minuvu no movavow kos koovottan iling to mgo anak. Oyya en, Amoy ku, od doongon ku sikkow su ini me‑en kos kikow'n id kopi‑i.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Na mid ikahi si Disas diyot mgo minuvu to, “Id sanna koddi to Amoy ku iddos langun. Oyyos waa osson nokokilaa koddi, idda ra en so Amoy ku, su anak a man nikandin. Woy waa mandad osson nokokilaa to Amoy ku, siyak da en woy dos mgo minuvu no id kopi‑i ku nod pokokilaa kandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nopongnga idda, mid isau si Disas diyot mgo tinodduwan din woy id osengan din no siksikandan da, kahi rin to, “Moppiya kod kotomanan to mgo minuvu no nokokita taddot nokita row.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Oyyos od ikohiyan ku sikiyu, no mo‑uraan propeta woy mgo hari no od kopiyan nod pokokita taddot nokita row, piru waa ran en idda nokita. Id kopi‑i ran nod pokorinog taddot norinog dow, piru waa ran en idda norinog.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na, duwon tohodnonaw to mgo Suhu ni Moises no id lohinat su id kopi‑i rin nod posaharon si Disas ukit to intud. Kahi rin to, “Tohodnonaw, ondan kos od puungan ku amoy'd kotanggap ku kos umuun waad tomanon?” ");
INSERT INTO oboNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mid tavak si Disas to, “Ondan man kos no‑ikahi riyot mgo Suhu ni Moises no novasa ru?” ");
INSERT INTO oboNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kahi taddot tohodnonaw to, “ ‘Ginowanniyu kos Monama nod Longaggon du riyot tivuk no pusung du, diyot tivuk no umuu ru, diyot tivuk no konokkaan du woy riyot tivuk no poomdom du. Woy ginowanniyu kos duma iling to kodginawa ru to ko‑ugolingun du.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kahin Disas to, “Ollog kos tavak du. Na, puungiyu ini amoy'd pokotanggap ka to umuun waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Piru iddon tohodnonaw, diid kopiyan nod potalu, de‑en id intud pe‑en sikandin ki Disas, kahi rin to, “Ondoy man bos kos duma no ollog nod ginowannon?” ");
INSERT INTO oboNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mid tavak si Disas kandin ukit to ponunggelengan, kahi rin to, “Duwon sokkad no minuvu no id undiyon to Jerico pomon diyot Jerusalem. Diyon to daan, id oyanan sikandin to mgo tulisan, id pomodasan sikandin woy id angoy pe-en, ahad iddos sabpong to lawa rin. Nopongnga, id tonanan dan sikandin no asow ron od patoy. ");
INSERT INTO oboNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na, duwon tohodbuwis no id baya rutun. To nokita rin iddos minuvu, id olihuwan din da en. ");
INSERT INTO oboNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Iling mandad tadda, id baya rutun iddos sokkad no Levita. To nokita rin iddos minuvu, id olihuwan din mandad. ");
INSERT INTO oboNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Todtahad, duwon minuvu no toho Samaria no id baya, woy to nokita rin iddos minuvun nopaddoo, iling tid kommos kos pusung din pomon to eru. ");
INSERT INTO oboNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Id poroniyan din idda, woy id bowiyan din to lana woy binu iddos mgo paddoo rin woy id bukusan. Nopongnga, id posakoy rin sikandin to asnu amoy od piyoddon diyot baoy nod oowottan. Na rutun, id tuhanuu rin pe‑en sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","So‑op no allow, id boggayan din to soopi iddos komunoy taddot baoy, woy id ikohiyan din to, ‘Tuhonulow vo sikandin woy od boyaran ku sikkow init kodlivod ku otik duwon od kogastu ru kandin.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na mid intud si Disas diyot tohodnonaw to mgo Suhu ni Moises, kahi rin to, “Diyot kikow'n poomdom, ondoy musing ka‑ay't otollu kos id pokita to ginawa riyot duma?” ");
INSERT INTO oboNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mid tavak sikandin to, “Iddos no‑eruwan kandin.” Purisu id ikohiyan sikandin ni Disas to, “Na, ungketen be‑en mandad kos ko‑ilangan nod puungan du.” ");
INSERT INTO oboNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na, to id ponayun onsi Disas to iponawon dan, id inguma ran diyot sokkad no bariyu no id ubpan taddot ba‑ay no id ngoranan ki Marta. Id pa‑allus din onsi Disas diyon to baoy rin. ");
INSERT INTO oboNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Duwon ari ni Marta nid ngoranan ki Maria no id unsad diyot morani to pa‑a ni Disas amoy'd pominog to nonaw rin. ");
INSERT INTO oboNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Piru si Marta, nolewang nod panoy to koka‑an atag ongki Disas. De‑en id porani sikandin ki Disas woy kahi rin to, “Longaggon, imman to waa ron diyot kikow no id podtohon a to ari ku nod puung to langun? Suhuwow sikandin nod tavang koddi!” ");
INSERT INTO oboNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Piru mid tavak iddos Longaggon to, “Ooy kikow, Marta! Oraroy ka nod kaanu woy od kolewang to mo‑uraan pinuungan. ");
INSERT INTO oboNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sokkad da kos duwon dakkoon koru‑anon, woy ini en kos na‑aam ni Maria woy worad en od poko‑angoy tadda pomon diyot kandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sokkad no allow, nopongnga id dasaa si Disas, id porani kandin iddos sokkad taddot mgo tinodduwan din woy mid ikahi sikandin to, “Longaggon, si Juan no Tohodboutismu, id nonaw taddot mgo tinodduwan din moka‑atag to koddasaa, de‑en nonawwi koy mandad.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kahin Disas kandan to, “Otid dasaa kow, ungketenna row to, “ ‘Amoy roy, muopa nod posivontuhon kos ngaran du. Muopa no iddos kodhari ru, od inguma ka‑ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Boggayi koy to koka‑an nod ko‑ilonganon doy inin allow, woy ");
INSERT INTO oboNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","posinsya‑i koy to mgo saa roy iling to kodposinsya roy taddot nokosaa konami. Woy tovangi koy no dii koy'd kopiyod to kodpuung to saa.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mid ikahi pe‑en si Disas to, “Ponunggeleng, sokkad koniyu nod undiyon to baoy't oukuy rin to tongngovulli, woy od ikahi to, ‘Oh suwod, posombaya a pa to otollun molison no paan. ");
INSERT INTO oboNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Su duwon oukuy ku no lammid inguma no waa en id pokoposabpot ku kandin.’ ");
INSERT INTO oboNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na od tavak iddos oukuy rin nod ungketen to, ‘Yo ad somuka, su nookobban don kos sobbangan woy sikami duma to mgo anak doy, id ilogga koyd. De‑en dii ad onnow nod boggoy kikow to ahad ondan.’ ");
INSERT INTO oboNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Od ikohiyan ku sikiyu, no ahad pe‑en oukuy sikandan, dii ron nanoy sikandin od onnow. Piru pomon to waa soroan din nod buyu, id onnow ron sikandin woy od boggoy to ahad ondan nod ko‑ilonganon din. ");
INSERT INTO oboNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","De‑en od ikohiyan ku sikiyu, no bovuyu kow riyot Monama woy od kovoggayan kow, nangkap kow woy'd pokokita kow, ponoktok kow woy od kolukatan kow. ");
INSERT INTO oboNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Su iddos ahad ondoy nod bovuyu, od pokotanggap en woy dos od nangkap, od pokokita en, woy idda mandad so od ponoktok, od lukatan en. ");
INSERT INTO oboNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sikiyu no mgo amoy, otid bovuyu kos anak dow to ngaap, od boggayan dow vo sikandin to uwod? ");
INSERT INTO oboNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Woy otid bovuyu sikandin to soo, od boggayan dow vo sikandin to topilak? Dii en! ");
INSERT INTO oboNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Na otik sikiyu no mgo mosaasaa, od kotuig nod boggoy to moppiya riyot mgo anak dow, iyon pobbo iddos Amoy row no riyot datas to langit, od boggoy en to Uhis no Ispiritu riyot od buyu kandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sokkad no allow, id poleggua ni Disas iddos busow no id lasud taddot sokkad no minuvu unayan no no‑ommow sikandin. To id leggua ron iddos busow, noko‑ooseng don iddon minuvu. De‑en nosoobbuwan iddos nolivuung dutun. ");
INSERT INTO oboNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Piru duwon duma kandan no mid ikahi to, “Te! Od pokopoleggua sikandin to mgo busow su iyon id boggoy kandin to kotuusan, si Moivuyan no ponguu to mgo busow.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Idda mandad so duma, id kopi‑i ran nod posaharon si Disas. De‑en id buyu ran kandin no od puung sikandin to mokososoobbu nod posivonnaa no id popiyod en sikandin to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Piru nosorollan ni Disas kos diyot poomdom dan, de‑en mid ikahi sikandin to, “Iddos ahad ondoy no hari to sokkad no kohoriyan nod po‑unayoy od povunuwoy taddot mgo sakup din, konnod kouhoy, od kohobba en kos kohoriyan din. Woy dos mgo sakup to sokkad no pomilya, otid po‑unayoy nod po‑imotayoy, od pokodsuwoysuwoy en sikandan. ");
INSERT INTO oboNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na ungketen mandad si Moivuyan. Otid po‑unayoy od po‑imotayoy si Moivuyan taddot mgo sakup din, od kohobba en kos kohoriyan din. Od ikahi kow no nokopoleggua a to mgo busow ukit to kotuusan ni Moivuyan. ");
INSERT INTO oboNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Otik bonnaa idda, dos mgo tinodduwan dow, ukit bo mandad to kotuusan ni Moivuyan iddos kodpoleggua ran to mgo busow? Ahad sikandan, od pokoposivonnaa en no soyup kos id oseng dow. ");
INSERT INTO oboNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Piru pomon to id poleggua ku man iddos mgo busow ukit to kotuusan to Monama, posivonnaa ini no iddos kodharit Monama, ka‑ay ron to koniyu. ");
INSERT INTO oboNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Noko‑iling si Moivuyan to monokkaan minuvu no mid panoy to langun no goggot to kodpo‑imotayoy. Otid tomongngan din kos baoy rin, waa en od poko‑ahaw to korotuwan din. ");
INSERT INTO oboNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Piru kod lusuran sikandin taddot lampas pa kandin no monokkaa, od kotalu en sikandin. Na iddos id solihan din no mgo goggot, od ahawon woy dos korotuwan din, od ba‑adba‑addon.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nopongnga idda, mid ikahi si Disas to, “Iddos ahad ondoy no diid poomig koddi, id supak koddi, woy dos diid tavang koddi nod limud to mgo minuvu to Monama, od podsuwoy kandan.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Na ponayun mid nonaw si Disas ukit to ponunggelengan, kahi rin to, “Otid leggua kos busow riyot minuvu, od lo‑uklo‑uk idda riyot noka‑awoy‑awoy'n lugaa amoy od nonangkap tod ko‑imooyyan din, piru waa od kokita rin. De‑en od ikahi sikandin to, ‘Od livod a ron baling diyot id ubpan ku.’ ");
INSERT INTO oboNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na riyot kod‑inguma rin, od kokita rin no waa id ubpa rutun, id lemasan idda woy noto‑oo ron. ");
INSERT INTO oboNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Od ipanow sikandin woy od pongakat to pittun busow no lampas pa kos komorattoy kandin. Od losuran dan iddos minuvu woy'd ubpan dan don. Na iddos od kotomanan taddon minuvu, lampas pe‑en no morat taddot unna.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Laggun tid ooseng poron si Disas tadda, duwon ba‑ay no id ooseng to monokkaa pomon diyot mo‑uraan minuvu no mid ungketen to, “Moppiya kod kotomanan taddot inoy no id anak woy id posusu kikow.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Piru kahin Disas to, “Lampas no moppiya kod kotomanan taddot mgo minuvu nod pominog to kahit Monama woy od tuman tadda.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na, laggun tid mo‑uraa pe-en iddos nolivuung no mgo minuvu riyot ki Disas, mid ikahi sikandin to, “Sikiyu no mgo minuvu to inin timpu, oraroy kowd no morat, oyyos id kopi‑i row nod pokokita to mokososoobbu. Piru waa id pokita ku koniyu, ko konna, idda ra en so mokososoobbun notomanan ni Jonas no propeta. ");
INSERT INTO oboNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Su iddos notomanan din, kilaannan idda no id popiyod en sikandin to Monama atag taddot mgo toho Ninive. Na iling mandad tadda, siyak no Anak to Minuvu, id popiyod to Monama atag to mgo minuvu to inin timpu. ");
INSERT INTO oboNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Diyot allow to kodhukum, od lohinat iddos Rayna to Siba woy'd ooseng no iddos mgo minuvu to inin timpu, ollog en nod silutan. Su ahad oray'n moriyu iddos id ubpan din, piru mid undiyon sikandin to ki Harin Solomon amoy od pominog da en taddot osengan to hari no moraom kos koovottan. Piru ko‑ungkay, dini ron kos lampas pa ki Solomon no moraom kos koovottan, piru waa kow man id pominog to nonaw rin. ");
INSERT INTO oboNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na ungketen dad en mandad iddos mgo toho Ninive, od lohinat sikandan diyot allow to kodhukum woy'd ooseng no iddos mgo minuvu to inin timpu, ollog en nod silutan. Oyyos dangan to norinog dan iddos kodponudtuu ni Jonas, id sondit sikandan woy id tanan to mgo saa ran. Piru ko‑ungkay, dini ron kos lampas pa ki Jonas, piru waa kow man id sondit woy id tanan to mgo saa row.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kahi mandon ni Disas to, “Waa minuvu nod loottom to suu woy kopongnga, id ollos din o od poongkobban din to lobban, ko konna, id ta‑aw rin idda riyot od sopatan amoy'd kotorawwan kos langun diyon to baoy. ");
INSERT INTO oboNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Na inis mata, noko‑iling to suu to lawa. Otik ma‑awang kos kod‑ontong du, ma‑awang mandad kos tivuk no lawa ru. Piru otik mosukirom kos kod‑ontong du, mosukirom mandad kos tivuk no lawa ru. ");
INSERT INTO oboNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","De‑en od ooyyaran du no ma‑awang kos poomdom du, su saddook iddos id oseng du no ma‑awang, iyon bonnaa, mosukirom bos. ");
INSERT INTO oboNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","De‑en otik id poma‑awang tod Longaggon kos poomdom ta taman to waa en ahad disok no mosukirom diyot keta, dos umuu ta, iling to baoy nod kotorawwan kos langun diyot daom.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nopongnga osenga ni Disas idda, duwon sokkad no Pariseo no id inggat kandin nod ka‑an. De‑en id undiyon sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nosoobbuwan iddos Pariseo, su nokita rin nid ka‑an si Disas no waa id ounab to bollad amoy od ikuu to botasanon atag to kodlinis. ");
INSERT INTO oboNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Na kahin Disas kandin to, “Sikiyu no mgo Pariseo, noko‑iling kow to minuvu no idda ra en so leggua to pokawan woy oyyug to pinggan kos id linisan din, piru iddos diyot daom, molibmit poron. Oyya su id pokitakita kow ra to moppiyon botasan, piru iddos pusung dow, noponnut kodloupig woy kororattan. ");
INSERT INTO oboNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Waa en mgo utok dow! Waa kow vo nokosaddoo no iddos Monama no id bovaa to lawa ta, sikandin en mandad kos mid bovaa to poomdom ta? ");
INSERT INTO oboNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","De‑en boggoy kow riyot worowora no mahan kos ginawa row. Su otid puungan dow idda, molinis kow riyot kod‑ontong to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Moka‑arat‑arat kod kotomanan dow no mgo Pariseo! Su od boggoy kow to koniyun iko‑sopuu, ahad pa iddos id pomon to pinomuwa row no mgo loggu. Piru id podtohon dow man iddos mgo Suhu ni Moises no ko‑ilangan nod puung kow to motallong woy od ginawa kow to Monama. Ollog en no id boggoy row kos iko‑sopuu, piru yo row podtohona iddos kodpuung taddot dumon suhu no lampas pa kos koru‑anon. ");
INSERT INTO oboNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Moka‑arat‑arat kod kotomanan dow, sikiyu no mgo Pariseo! Su iyon dow id dokollan to ginawa, iddos kod‑unsad diyot isowwan to mgo minuvu riyot simba‑an to mgo Judio, woy od kotoosan kow nod kumustan woy'd rispituwon diyon to kolivuungan. ");
INSERT INTO oboNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Moka‑arat‑arat kod kotomanan dow, sikiyu no mgo Pariseo! Su noko‑iling kow to mgo lobbong no waa kilaannan, de‑en od koheddan to mgo minuvu no waa saddoo no lobbong bos idda. Oyya su molinis kow riyot leggua, piru diid kokita no no‑obbuu kos diyot daom.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na, duwon sokkad no tohodnonaw to mgo Suhu ni Moises no mid ikahi ki Disas to, “Tohodnonaw, to kod‑oseng du ka‑ay, id po‑ilawan koy mandad nikkow.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kahin Disas to, “Moka‑arat‑arat en mandad kod kotomanan dow, sikiyu no mgo tohodnonaw to Suhu ni Moises! Su id povoggatan dow kos mgo minuvu nod tuman taddot id podluntudluntud no mgo suhu no id pohos dow nod ikulon. Piru sikiyu, waa kow man id tavang kandan nod tuman tadda, ahad disok da. ");
INSERT INTO oboNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Moka‑arat‑arat kod kotomanan dow! Su id povovallan dow to lovongngan iddos mgo propeta no id imotayan to kovuyyahan dow. ");
INSERT INTO oboNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Piru ukit taddot id puungan dow, id posivonnaa no nahaa kow taddot id puungan to kovuyyahan dow. Oyyos sikandan kos id imatoy to mgo propeta, woy sikiyu kos id bovaa to lovongngan dan. ");
INSERT INTO oboNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Na pomon ka‑ay, iddos Monama no duwon moraom no koovottan, id ikahi moka‑atag koniyu no mid ungketen to, ‘Od popiyoddan ku sikandan to mgo propeta woy mgo apostoles. Piru iddos duma, od imotayan dan woy dos duma, od posupittan.’ ");
INSERT INTO oboNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","De‑en sikiyu no mgo minuvu to inin timpu kos od sukutan to Monama taddot kod‑imatoy to mgo propeta pomon poron to kodbovaa to ingod. ");
INSERT INTO oboNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Id tigkanoy idda taddot kod‑imatoy ki Abel taman to kod‑imatoy ki Zacarias no id imotayan diyot ollot to buwisanan woy riyot templo. Oyya, od ikohiyan ku sikiyu, no od sukutan en to Monama iddos mgo minuvu to inin timpu. ");
INSERT INTO oboNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Moka‑arat‑arat kod kotomanan dow, sikiyu no mgo tohodnonaw to Suhu ni Moises! Su iling tid lokobban dow kos sobbangan amoy diid poko‑usok kos mgo minuvu riyon to kodharit Monama. Id elle kow nod lonug taddot kodhari rin woy id boovahan dow iddos od kopiyan nod lonug.” ");
INSERT INTO oboNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na, to id tanan don si Disas taddon baoy, id morat don kos songnga taddot mgo tohodnonaw to Suhu ni Moises woy mgo Pariseo. De‑en id tigkanoy ran don to kodsupak woy kod‑intud kandin to ahad ondan. ");
INSERT INTO oboNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Oyyos id kopi‑i ran nod posaharon si Disas ukit to tavak din, su id imman dan nod kosoyup sikandin woy duwon saa no id poko‑uug dan kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na iddon timpu, id porani ki Disas iddos maanmaan no minuvu nid pososokoy. Id unnan din tid oseng iddos mgo tinodduwan din to, “Bantoy kow no konna kow od kopiyod taddot pinuungan to mgo Pariseo no noko‑iling to potuvu to paan nod so‑ob, su id po‑uvag‑uvag dan no motallong kos pinuungan dan. ");
INSERT INTO oboNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Oyyos waa id tombunan no konnod kokita woy waa id ollos no konnod kosorollan. ");
INSERT INTO oboNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","De‑en ahad ondan nod osengon dow no waa osson nokorinog, od korinog en diyot ko‑owangan, woy dos ahad ondan no id nona‑as dow riyot kwartu, od peheson en idda riyot atop no iddos kohulugan, id posaddoo riyot langun.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Od ikohiyan ku sikiyu no mgo oukuy ku, yo row id kovaakki kos mgo minuvu no od imatoy ra to lawa, su taman da en tadda kos od kopuungan dan. ");
INSERT INTO oboNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Piru od ponudtulan ku sikiyu, no idda ra en so Monama kos ollog nid kovaakki row. Su kopongnga rin od ongayon kos songnga row, duwon en kotuusan din to kodlumbag koniyu riyon to linow't apuy.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mid ikahi pe‑en si Disas to, “Iddos limmon maya, od kovolli ra to oray'n disok no kontidad. Piru waa ahad sokkad kandan no id lingawan to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","De‑en yo kow'd kovaakki, oyyos lampas pe‑en kos koru‑anon dow taddot mo‑uraan maya, su ahad iddos bowvuut uu row, nosorollan din kos ko‑uralloy.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Na od ikohiyan ku sikiyu, no iddos ahad ondoy nod ponudtuu riyot isowwan to mgo minuvu no siyak kos od Longaggon din, siyak no Anak to Minuvu, id ponudtuu ku mandad diyot isowwan to mgo ponolihan to Monama no sikandin, id dumoruma koddi. ");
INSERT INTO oboNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Piru iddos ahad ondoy nod elle koddi riyot isowwan to mgo minuvu, od elleyan ku mandad sikandin diyot isowwan to mgo ponolihan to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Woy dos ahad ondoy nod oseng to morat moka‑atag koddi no Anak to Minuvu, od koposinsyan pa, piru iddos od sumpalit to Uhis no Ispiritu, konna en od koposinsyan. ");
INSERT INTO oboNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Na otid omotton woy'd piyoddon kow riyot isowwan to mgo ponguu to simba‑an to Judio, riyot mgo gubernador woy riyot dumon mgo ponguu, yo kow'd kaaggow ko ondan kos id tavak dow, ");
INSERT INTO oboNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","oyyos to idda ra en no uras, od tuntulan kow to Uhis no Ispiritu ko ondan kos ollog nod osengon dow.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na, duwon sokkad no minuvu no mid oseng ki Disas pomon diyot mo‑uraan minuvun nolivuung. Kahi rin to, “Tohodnonaw, osengiyu pa iddos kakoy ku no mama amoy'd ba‑addan a taddot korotuwan to amoy roy no id patoy ron.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Piru kahin Disas kandin to, “Te, kotungud ku vo nod usoy amoy ollog iddos kodba‑ad taddot korotuwan no id tuwos koniyu? Konna en!” ");
INSERT INTO oboNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na kahin Disas diyot mo‑uraan minuvu to, “Bantoy kow taddot ahad ondan no id ko‑ima‑i row, oyyos konna iddos dakkoon korotuwan kos od pokomoppiya to umuu to minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nopongnga idda, id itulan dan ni Disas to ponunggelengan, kahi rin to, “Duwon sokkad no minuvun noruwonnan no iddos langun to pinomuwa rin, id bovunga to moppiya. ");
INSERT INTO oboNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kohingginawa rin to, ‘Ondan kos od puungan ku, su worad man od kotawwan to langun no bunga to pinomuwa ku?’ ");
INSERT INTO oboNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na mid ikahi sikandin to, ‘Oyya vos en, iling ka‑ay kos od puungan ku. Od gobban ku iddos koddin mgo budiga amoy'd poohinat a to dakkoo pa atag to langun no bunga to koddin pinomuwa woy taddot duma pon mgo koruwonnan ku. ");
INSERT INTO oboNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ini pobbo moho, su od ikohiyan ku kos ko‑ugolingun ku to, ‘Moppiya inis kotomanan ku, oyyos dakkoo ron kos nolimud ku nod poko‑uyag koddi daom to mo‑uraan lahun. De‑en od pongiikii a robbo, od ka‑an, od oinom woy'd kahaa.’ ");
INSERT INTO oboNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Piru mid ikahi iddos Monama kandin to, ‘Bangog ka! Su ini ra en no bulli, od kovudtus kos songnga ru. Na, ondoy pa man kos od pokokomunoy to langun nid limud du no korotuwan no id panoy ru atag da en to ko‑ugolingun du?’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nopongnga idda, mid ikahi si Disas to, “Na, iling en mandad ka‑ay kos od kosahapan to minuvu nod loimud to mgo korotuwan atag to ko‑ugolingun din, piru worowora riyot kod‑ontong to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na kahin si Disas diyot mgo tinodduwan din to, “De‑en od ikohiyan ku sikiyu, no yo kow'd kaaggow to mgo ko‑ilonganon dow ko ondan kos od kannon woy'd umpakon dow. ");
INSERT INTO oboNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Su iddos koniyun umuu, lampas pa kos koru‑anon taddot koka‑an woy dos lawa row, lampas pa kos koru‑anon taddot umpak. ");
INSERT INTO oboNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Poomdomma row man iddos mgo uwak. Waa ran mid pomuwa, waa id kottu woy waa mandad budiga ran, piru id boggayan sikandan to Monama to koka‑an. Na, iyon kow pobbo no lampas pa kos koru‑anon taddot mgo manuk nod layanglayang. ");
INSERT INTO oboNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Woy sokkad pa, ondoy man koniyu kos od pokopoowwet to umuu row ahad sokkad da no uras ukit to laggow? Waa en! ");
INSERT INTO oboNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","De‑en, su konna kow man od pokopoowwet to ahad sokkad dobbon uras to umuu row, mambot od kaaggow kow to ahad ondan no ko‑ilonganon dow? ");
INSERT INTO oboNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Poomdomma row man iddos mgo bulak no id pontuvu. Waa ran id puung woy waa id ponobbii tod umpakon dan. Piru od ikohiyan ku sikiyu, no ahad si Harin Solomon no novantug to korotuwan din, waa en noko‑umpak iling to kogolingoy to ahad sokkad ka‑ay'n mgo bulak. ");
INSERT INTO oboNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Na, otik id pomogoling man to Monama kos mgo sabbot nod ko‑uyag da ko‑ungkay, piru simag od tirukkan don, konna vo lampas kow pa nod umpakan din? Ooy koniyu! Oray'n disok kos kopomakoy row! ");
INSERT INTO oboNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yo kow'd kaaggow no iyon dobbo en od poomdommon ko ondan kos od kannon woy'd inommon dow. ");
INSERT INTO oboNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Oyya su iddos inaayun od kaaggow tadda, idda en so mgo minuvu no waa id kilaa to Monama. Piru sikiyu, yo kow'd kaaggow, su iddos Amoy row no riyot datas to langit, nokosaddoo no od ko‑ilonganon dow en idda. ");
INSERT INTO oboNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","De‑en iyon dow unna‑a tod nangkap, iddos kodharit Monama woy dos kod‑ikuu to kandin nid kopi‑i, woy id potommu rin kos langun no ko‑ilonganon dow.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Na sikiyu no mgo tinodduwan ku, yo kow'd kovaakki ahad pilopila kow ra, su id kahaa‑i to Monama no od lonug kow riyon to kodhari rin. ");
INSERT INTO oboNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Boligya row kos koniyun korotuwan woy boggoy row riyot worowora iddos bayad tadda. Na ukit ka‑ay, od pokolimud kow riyot datas to langit to korotuwan no diid korattan woy diid kowora, oyyos dutun, waa en minuvu nod ponakow woy waa od kotkot. ");
INSERT INTO oboNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Su otik ingkon nokota‑aw kos koniyun korotuwan, diyon en mandad kos ginawa row.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Na mid ungketen pe‑en si Disas to, “Ko‑ilangan no nopanoy kow inaayun iling to mgo sudsuhuwon no waa ran ovukki kos mgo suu ran. ");
INSERT INTO oboNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ilingi row iddos mgo sudsuhuwon no nopanoy to kod‑inguma to amu ran no pomon diyot kosalan, amoy ahad kannu sikandin od inguma woy'd ponoktok, go‑os dan sikandin od kolukatan. ");
INSERT INTO oboNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Moppiya kod kotomanan taddot mgo sudsuhuwon no diid tintinuhon nod aangat to kod‑inguma to amu ran. Bonnaavonnaa nod ikohiyon ku koniyu, no od po‑unsaron taddot amu iddos mgo sudsuhuwon woy sikandin kos od sondad kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ahad tongngovulli o asow ron od ka‑allow nod ko‑umannan din iddos mgo sudsuhuwon no waa id tintinuhon, moppiya kod kotomanan dan. ");
INSERT INTO oboNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Poomdomma row ini. Otid kosorollan to komunoy to baoy ko kannu od inguma kos tokawon, od bantoy en sikandin amoy dii od poko‑usok iddon tokawon. ");
INSERT INTO oboNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","De‑en sikiyu mandad, ko‑ilangan no nopanoy kow, su siyak no Anak to Minuvu, od inguma en diyot timpu no waa kow id imman nod inguma a.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Na kahin Pedro to, “Longaggon, moka‑atag taddot ponunggelengan no id nonaw ru, atag da vo idda konami o atag to langun?” ");
INSERT INTO oboNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mid tavak si Disas ukit to ponunggelengan, kahi rin to, “Iddos sudsuhuwon nod kosolihan woy moraom kos koovottan, sikandin kos od solihan to amu to kodtamong to duma rin no mgo sudsuhuwon woy to kodtaadtaad to koka‑an dan diyot ollog no timpu. ");
INSERT INTO oboNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Moppiya kod kotomanan taddot sudsuhuwon, no riyot kodlivod to amu rin, od kokita no id puung sikandin taddot langun nid popuungan kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Bonnaavonnaa nod ikohiyon ku koniyu, no id salig en taddot amu iddos langun no koruwonnan din diyot od kosolihan no sudsuhuwon. ");
INSERT INTO oboNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Piru ko morat iddon sudsuhuwon, od popoomdom sikandin to, ‘Kouhoy pa od uli kos amu ku.’ Na, od pomodasan din iddos duma rin no mgo sudsuhuwon ahad iddos mgo ba‑ay woy iyon din da en od puungan, iddos kodka‑an woy kod‑oinom duma to mgo polohubug. ");
INSERT INTO oboNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na, od inguma iddos amu rin diyot allow woy uras no waa rin immana. Iyon din od ingumannon, iddos moka‑arat‑arat no kodsilut woy id poommung sikandin taddot mgo minuvu no diid pomakoy no riyot lugaa no waad tomanon kos koosayan. ");
INSERT INTO oboNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Dos sudsuhuwon no nokosaddoo taddot id suhu to amu rin, piru waa rin puungi, od ingumannon din iddos movoggat no silut. ");
INSERT INTO oboNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Piru iddos sudsuhuwon no waa nokosaddoo taddot id kopi‑i to amu rin woy nokopuung sikandin to saa, mahan da kos silut kandin. Dos ahad ondoy no id solihan to dakkoo, od sukutan mandad to dakkoo. Woy iddos id solihan to lampas pe‑en no dakkoo, lampas pe‑en mandad kos od sukuton kandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Na mid ikahi mandon si Disas to, “Id undini a to ampow't ingod nid piyod to apuy woy id kopi‑i ku nod lotomman don en ini. ");
INSERT INTO oboNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Piru od ukit a to mo‑uraan kodposuppit woy diid lonna kos ginawa ku taman tod kopongnga idda. ");
INSERT INTO oboNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yo row poomdomma no mid undini a amoy duwon kosunayan ka‑ay to ampow't ingod! Su iyon bonnaa, od kova‑ad iddos mgo minuvu pomon koddi. ");
INSERT INTO oboNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pomon ko‑ungkay, od kova‑ad kos pomilya. Ponunggeleng, iddos pomilya no duwon limmon sakup, dos otollu, od supak taddot oruwa woy dos oruwa, od supak tat otollu. ");
INSERT INTO oboNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dos amoy, od pokodsupak taddot anak din no mama, ungketen dad en mandad iddos inoy woy dos anak din no ba‑ay. Idda mandad so onuhang no ba‑ay woy dos moka‑amung din no ba‑ay, od pokodsupak.” ");
INSERT INTO oboNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Na mid ikahi mandon si Disas diyot mgo minuvu to, “Otid kokita row nod mosukirom kos souhapun lomig tid saop, od ikahi kow no, ‘Asow ron od uran.’ Na diid kouhoy, od uran en. ");
INSERT INTO oboNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Otid kokaamag pomon diyot boovahan, od oungketen kow to, ‘Od tollak be‑en moho ko‑ungkay,’ woy od kovonnaa en idda. ");
INSERT INTO oboNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sikiyu no oray'd po‑uvag‑uvag! Od kotuig kow nod otuk to timpu ukit to kod‑ontong dow to livuta woy ko‑oowayan, piru mambot dii kow moho od kotuig nod otuk to kohulugan to mgo kotomanan to inin timpu?” ");
INSERT INTO oboNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mambot dii kow moho od poko‑anong‑anong ko ondan kos ollog nod puungan dow? ");
INSERT INTO oboNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ponunggeleng, otik duwon minuvu nod popenek to kasu kuntra kikow, noonokkaliyu nod pokod‑uli kow to dii kow pa od inguma riyot tohodhukum. Su otid poko‑uma kowd dutun, saddook od goyoron ka nikandin po‑undiyot hukumanan, woy id boggoy ka to tohodhukum diyot pulis woy id poprisu ka. ");
INSERT INTO oboNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Od ikohiyan ku sikkow, no dii ka en od pokolegguang otik dii ru od kovoyaran kos langun no multa ru. ");
INSERT INTO oboNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na, to id nonaw ni Disas idda, duwon mgo minuvu nid inguma woy id posaddoo kandin no duwon id po‑imotayan ni Pilato no mgo toho Galilea laggun tid sosumbali ran to mgo oyama riyot templo amoy id buwis. ");
INSERT INTO oboNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kahin Disas kandan to, “Pomon to ungketen kos kopotayan dan, id popoomdom kow ayu no movoggat pa kos mgo saa ran taddot dumon toho Galilea. ");
INSERT INTO oboNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Konna en! Su od ikohiyan ku sikiyu, no otik dii kow od sondit woy'd tanan to mgo saa row, od silutan kow mandad langun to kopotayan. ");
INSERT INTO oboNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na, moka‑atag mandad taddot sopuu‑wau nid poomatoy no nopilayan to motikang no baoy riyot Siloe, id popoomdom kow ayu no movoggat pa kos mgo saa ran kuntra taddot dumon toho Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Konna en! Su od ikohiyan ku sikiyu, no otik dii kow od sondit woy'd tanan to mgo saa row, od silutan kow mandad langun to kopotayan.” ");
INSERT INTO oboNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na id itulan dan ni Disas to sokkad ponunggelengan, kahi rin to, “Duwon sokkad no minuvu no id pomuwa to kayu no igera riyot kamot din. Id lowwi rin idda su kunan din ko id bovunga ron, piru waa vos. ");
INSERT INTO oboNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","De‑en id osengan din iddos tohod‑okudi taddot kamot din, kahi rin to, ‘Iko‑otollu ron no lahun nid livodlivod a ka‑ay amoy'd ontong ko id bovunga ron inin igera, piru waa en. Na pilayow ika, su od konuhunan da en kos koomboggan to livuta.’ ");
INSERT INTO oboNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Piru mid tavak iddos tohod‑okudi to, ‘Sir, od podtohonon ta poron inin kayu ahad ini robbo no lahun. Od koliyan ku pa kos polingut ka‑ay woy'd obunuwan. ");
INSERT INTO oboNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na onggad od bovunga ini riyot so‑op no lahun, moppiya. Piru otik konna, popiloy rud.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na riyon to Allow't Kod‑imolloy, id nonaw si Disas diyot simba‑an to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Dutun, duwon ba‑ay'n novokkut pomon to id losuran sikandin to busow daom don to sopuu‑waun lahun. Dii ron en sikandin od pokotullid nod lohinat ahad boyow ra. ");
INSERT INTO oboNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","To nokita sikandin ni Disas, id poporani rin sikandin, kahi rin to, “Tiya, no‑uliyan kad to bohok du.” ");
INSERT INTO oboNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na, id somaddan ni Disas dos ba‑ay woy idda ron en, tullid don kos kodlohinat din woy id doong din kos Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Piru iddos ponguu to simba‑an to mgo Judio, nolingasa, su id bovawi si Disas diyon to Allow't Kod‑imolloy. Kahi rin diyot mgo minuvu to, “Duwon annom no allow nod pokopuung ki. De‑en undini kow taddon mgo allow amoy'd povawi, piru konna timpu to Allow't Kod‑imolloy.” ");
INSERT INTO oboNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mid tavak si Disas to, “Sikiyu no oray'd po‑uvag‑uvag! Mambo sikiyu, od alin kow man to mgo oyama row woy'd po‑inommon dow ahad diyon to Allow't Kod‑imolloy. ");
INSERT INTO oboNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iyon pobbo inin ba‑ay, su lubbad mandad sikandin ni Abraham no id baku ni Moivuyan daom don to sopuu‑waun lahun. Mambo, konna vo lampas pe‑en no ko‑ilangan nod okasan sikandin ahad diyon to Allow't Kod‑imolloy?” ");
INSERT INTO oboNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","To kod‑ikahi ni Disas tadda, no‑ilawan iddos id pongkuntra kandin. Piru iddos duma, nahaa pomon taddot mokososoobbun pinuungan din. ");
INSERT INTO oboNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Na ponayun mid ikahi si Disas to, “Ondan man kos od ko‑ilingan to kodharit Monama? Ondan man kos od koponunggelengan ka‑ay? ");
INSERT INTO oboNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Iddos kodharit Monama, noko‑iling to oray'n disok no bonni no id pomuwa riyot kamot. Id tuvu idda woy novovallan no kayu, woy od ponsosaag diyot mgo panga tadda iddos mgo manuk nod layanglayang.” ");
INSERT INTO oboNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Na mid ikahi mandon si Disas to, “Ondan man kos od ko‑ilingan to kodharit Monama? ");
INSERT INTO oboNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Noko‑iling idda to potuvu to paan no id angoy to ba‑ay woy id podsambut din to sokkad no poonggana no horina taman tid tuvu iddos tivuk no horina.” ");
INSERT INTO oboNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","To id ponayun si Disas nid undiyon to Jerusalem, id tuuy sikandin diyot mgo bonuwa woy mgo bariyu no od ukitan din amoy'd nonaw. ");
INSERT INTO oboNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na duwon mid intud ki Disas, kahi rin to, “Longaggon, pilopila ra vo kos od kotobbus?” Mid tavak si Disas ukit to ponunggelengan, kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nokkaanokkaa kow nod poko‑usok diyot moliggot no sobbangan. Od ikohiyan ku sikiyu, no mo‑uraa kos od kopiyan nod poko‑usok dutun, piru dii en od poko‑usok. ");
INSERT INTO oboNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Oyya su iddos komunoy to baoy, od lookkob don to sobbangan. Ahad pe‑en od umow kow riyot leggua woy'd nganoy nod ungketen to, ‘Longaggon, kolimulimu, lukati koy,’ piru od tavak sikandin to, ‘Waa a mid kilaa koniyu woy waa saddoo ku ko ingkon kow pomon!’ ");
INSERT INTO oboNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na od ikahi kow to, ‘Nolingow kad ayu no nokodduma ki pa man nid ka‑an, woy sikkow en kos id nonaw riyot bonuwa roy.’ ");
INSERT INTO oboNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Piru od tavak sikandin to, ‘Id osengan kud sikiyu, no waa a nokokilaa koniyu! Poriyu kow koddi, sikiyu langun nid puung to morat!’ ");
INSERT INTO oboNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na otid kokita rowd onsi Abraham, si Isaac, si Jacob woy dos langun no propeta riyon to kodharit Monama, mopet dobbo kos sinoggawon dow woy'd pogkihot kow to ngipon, oyyos dii kow od po‑usokkon. ");
INSERT INTO oboNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Duwon od inguma rutun no mgo minuvu no id pomon diyon tid tollak woy pomon diyon tid saop, woy pomon diyon tid boovahan lomig to ivang woy kowanan no od unsad to kodlonug to pista riyon to kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na, iddos moobbava ko‑ungkay riyot kod‑ontong to minuvu, od porotason, woy dos mowwet ko‑ungkay riyot kod‑ontong to minuvu, od poobbovan.” ");
INSERT INTO oboNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","To idda ra en no timpu, duwon mgo Pariseo nid inguma woy id ikohiyan dan si Disas to, “Ko‑ilangan nod awa kad ka‑ay, su id kopi‑i ni Harin Herodes nod imatoy kikow.” ");
INSERT INTO oboNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Piru mid tavak si Disas to, “Ipanow kow woy ponudtuu row ki Herodes no od kotuigtuig nod aakaa, no ko‑ungkay woy simag, od ponayun kos pinuungan ku to kodpoleggua to mgo busow no id lasud to mgo minuvu woy ponayun a nod bawi tod pongkovohokan. Woy riyot iko‑otollun allow, od ipongngan kud kos pinuungan ku. ");
INSERT INTO oboNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ko‑ilangan en nod ponayun a to pinuungan ku ko‑ungkay, simag woy riyot iko‑otollun allow. Waa en od pokomonnu koddi ka‑ay, su riyon da en to Jerusalem od imotayan kos propeta.” ");
INSERT INTO oboNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Koyoy koniyu no toho Jerusalem, oraroy a nod kosowkuu koniyu! Su id ponlumbag dow to batu iddos mgo propeta, woy id pon‑imotayan dow sikandan woy dos duma nid po‑unduwon to Monama to koniyu. Kopila kud nanoy tod kupkup koniyu iling to mommiyak, piru dii row ini id kopi‑i. ");
INSERT INTO oboNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sikiyu nod pon‑oubpa ka‑ay'n bonuwa, pomotawi row! Od inguma en kos timpu nod inoyyuhan kowd to Monama. Od ikohiyan ku sikiyu, no dii ad en nikiyu od kokita taman tod poko‑ikahi kow to, ‘Od posivontuhon ta iddos id popiyod to Monama nod Longaggon.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sokkad no timpu to Allow't Kod‑imolloy, id inggat si Disas to sokkad no ponguu to Pariseo amoy od ka‑an diyot baoy rin. Dutun, duwon id panuu kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Diyot isowwan din, duwon minuvu no id ponlobbag kos bollad woy pa‑a rin. ");
INSERT INTO oboNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na, id inturan ni Disas iddos mgo Pariseo woy dos mgo tohodnonaw to Suhu ni Moises, kahi rin to, “Noko‑ikuu vo riyot mgo Suhu ni Moises iddos kodbawi riyon to Allow't Kod‑imolloy?” ");
INSERT INTO oboNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Piru id po‑onong‑onong da en sikandan. Na id somaddan ni Disas iddos minuvu woy no‑uliyan don sikandin, nopongnga, id po‑ipanow rin don. ");
INSERT INTO oboNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na kahin Disas kandan to, “Ponunggeleng, otid ko‑uug kos anak dow o ahad baka riyot moraom no bolun, od podtohonon dow ra vo su Allow't Kod‑imolloy?” ");
INSERT INTO oboNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Piru waa en sikandan nokotavak. ");
INSERT INTO oboNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na, nokita ni Disas iddos mgo minuvu no id unna‑unna nid unsad diyot id panoy no unsaran atag to mgo minuvu nod rispituwon. De‑en id itulan din sikandan to sokkad no ponunggelengan. ");
INSERT INTO oboNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Kahi rin to, “Otid inggaton ka nod sakup to kosaa, yo kod unna‑unna nod unsad diyot id panoy atag to mgo minuvu nod rispituwon, su saddook duwon pa od posokupon no lampas pa kikow nod rispituwon. ");
INSERT INTO oboNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na, od poroniyan ka taddot id inggat kikow woy'd ikohiyan ka to, ‘Awa ka pobbo ruwon su ikon unsaran, id panoy atag ka‑ay'n minuvu.’ De‑en od ko‑ilawan ka, oyyos od popo‑ibpiton ka robbo. ");
INSERT INTO oboNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Otid inggaton ka, moppiya pa kod pobpo‑ibpit ka ra. De‑en otid kokita ka taddot id inggat kikow, od ikohiyan ka nikandin to, ‘Suwod, alin ka unsad ka‑ay't id panoy atag to mgo minuvu nod rispituwon.’ Na, od koposivontuhan ka riyot isowwan to langun nid pon‑inggat. ");
INSERT INTO oboNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Su iddos ahad ondoy nod poratasdatas to ko‑ugolingun din, od poobbovan, piru iddos od poobbava, od porotason.” ");
INSERT INTO oboNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Na id osengan mandad ni Disas iddos id inggat kandin, kahi rin to, “Otid poka‑an ka to poni‑udtu o lavung diyot baoy ru, yo ru inggata iddos mgo oukuy ru, mgo korumannan o mgo sumbaoy ru nod pongkoruwonnan, su od pokobalus dan kikow. ");
INSERT INTO oboNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Piru kod panoy ka to pista, iyon du inggata, iddos mgo worowora, dos mgo pungku, dos mgo pe‑oo woy dos mgo butud. ");
INSERT INTO oboNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Na, ko ungketen kos od puungan du, moppiya kod kotomanan du, su iddos Monama kos od balus kikow riyot timpu nod bodnawon don kos mgo motallong.” ");
INSERT INTO oboNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na laggun tod ka‑an dan, sokkad taddot id pon‑inggat no nokorinog tat id oseng ni Disas, mid ikahi to, “Moppiya kod kotomanan taddot minuvu nod sakup to pista riyon to kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mid tavak si Disas ukit to ponunggelengan, kahi rin to, “Duwon minuvu nid panoy to dakkoon kodpoka‑an, woy mo‑uraa kos id inggat din nod sakup tadda. ");
INSERT INTO oboNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na, to id inguma ron iddos allow to dakkoon kodpoka‑an, id po‑undiyonnan din to sudsuhuwon din iddos mgo minuvu no no‑inggat amoy'd ikohiyan to, ‘Na undiyon kowd, su nopanoy ron kos langun.’ ");
INSERT INTO oboNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Piru id bolivad dan da en langun. Kahi taddot sokkad to, ‘Posinsya‑i a no dii a od pokosakup, su lammi a nokovolli to livuta woy ko‑ilangan en nod lowwiyon ku idda.’ ");
INSERT INTO oboNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Duwon mandad sokkad nid ikahi to, ‘Posinsya‑i a no dii a od pokosakup, su lammi a nokovolli to limmon porisan no baka, de‑en od geddaman ku pa ko moppiya rad bo idda nid dadu.’ ");
INSERT INTO oboNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Duwon pe‑en mid ikahi to, ‘Lammi a pa no noko‑osawa, de‑en dii a od pokosakup.’ ");
INSERT INTO oboNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Na, id uli iddos sudsuhuwon woy id ponudtuu rin diyot amu rin iddos mgo bolivad dan. Oray'n nolingasa iddos amu, woy kahi rin diyot sudsuhuwon din to, ‘Na lukut ka, undiyon ka to mgo doraanon woy riyot suksuk no mgo lugaa to bonuwa, woy po‑undiniyow iddos mgo worowora, dos mgo pungku, dos mgo butud woy dos mgo pe‑oo.’ ");
INSERT INTO oboNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Waa nouhoy, id livod iddos sudsuhuwon diyot amu rin woy mid ikahi to, ‘Sir, nopuungan kud kos suhu ru, piru waa pa noponnu kos baoy ru.’ ");
INSERT INTO oboNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","De‑en id suhu mandon taddot amu iddos sudsuhuwon din, kahi rin to, ‘Undiyonniyu iddos mgo minuvu no riyot mgo doraanon woy riyot suksuk no mgo lugaa, woy loglohottiyu sikandan nod undini amoy od koponnu inis baoy ku. ");
INSERT INTO oboNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Od ikohiyan ku sikiyu, no iddos id pombolivad to kod‑inggat ku, dii kud en od pokannon, ahad songo‑sungit dobbo ka‑ay't id panoy ku.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na, ponayun mid ipanow si Disas woy oray'n mo‑uraan minuvu kos id duma kandin. Id isau sikandin diyot kandan woy mid ikahi to, ");
INSERT INTO oboNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Iddos ahad ondoy nod kopiyan nod dumoruma koddi, ko‑ilangan no iddos kodginawa rin koddi, lampas pa taddot kodginawa rin to amoy woy inoy rin, sawa woy mgo anak din, mgo suwod woy tobboy rin. Ahad iddos kodginawa rin to ko‑ugolingun din, konna od lampas taddot kodginawa rin koddi. Su otik konna, dii ku en sikandin tinodduwan. ");
INSERT INTO oboNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Dos ahad ondoy no diid tiyang to kandin no krus amoy'd dumoruma koddi, dii ku en sikandin tinodduwan. ");
INSERT INTO oboNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ko‑ilangan no od poomdommon dow pa iddos kosupittan nod ko‑ukitan to mgo tinodduwan ku. Ponunggeleng, otik duwon sokkad koniyu nod pomuhawang od poohinat to dakkoon baoy, ko‑ilangan nod bolonsiyon din pa ko pila kos od kahastu amoy'd kosorollan ko ollog bo kos soopi rin nod poko‑ipongnga tadda. ");
INSERT INTO oboNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Su otik nokopoohinat dow ra en iddos mgo tuddok, piru dii vos od kopongnga, od kosu‑atan kow to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Od oungketen sikandan to, ‘Ette, od tigkanoy ra en moho od poohinat inin minuvu, piru waa vos id poko‑ipongnga rin.’ ");
INSERT INTO oboNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Na iling mandad tadda, otik duwon sokkad no hari no od pokidgira to osson hari, od puhawangon din pa kod pokoponalu vo sikandin no duwon da man sopuun maan (10,000) no sundau rin nod atu taddot hari no duwon oruwompuun maan (20,000) no sundau. ");
INSERT INTO oboNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Otik dii sikandin od pokogaha, od popiyod sikandin to mgo minuvu rin diyot kuntra rin to moriyu pa iddos mgo sundau taddon hari amoy'd pokod‑usoy. ");
INSERT INTO oboNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iling mandad tadda, iddos waa nopanoy nod tanan to langun no id dokollan din to ginawa, konna ku en tinodduwan.” ");
INSERT INTO oboNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Na ponayun mid ikahi si Disas to, “Moppiya kos assin su od pokovoggoy to nanam to koka‑an ta, piru kod motabbang don ini, dii ron en id pokopolivod kos nanam. ");
INSERT INTO oboNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Konnad mandad ini od kahamit, ahad pa id paambog diyot kamot woy id sowela robbo. Na sikiyu, su duwon man tolinga row, pa‑ayyad kow pominog.” ");
INSERT INTO oboNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na, mo‑uraan tohodsukut to buhis woy duma pa nod ngoranan to mgo Judio no mosaasaa no id porani ki Disas amoy'd pominog kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Piru iddos mgo Pariseo woy mgo tohodnonaw to Suhu ni Moises, id pommivig no mid ungketen to, “Te! Inin minuvu, od oukuy to mgo mosaasaa woy id lommung pe‑en kandan nid ka‑an.” ");
INSERT INTO oboNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","De‑en id itulan dan ni Disas to ponunggelengan. ");
INSERT INTO oboNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Kahi rin to, “Otik duwon sokkad koniyu no duwon mahatus no karnero nod kotorinan to sokkad, ondan ayu kos od puungan din? Id tuwos din en iddos siyowmpuu‑siyow riyot od posobsavan amoy'd nongkapon din iddos sokkad no notarin taman tod kokita rin. ");
INSERT INTO oboNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na, to nokita rin don idda, od tiyangon din duma to dakkoon kahaan. ");
INSERT INTO oboNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","To kod‑inguma rin diyot baoy, od umawon din kos mgo oukuy woy mgo sumbaoy rin nod ungketen to, ‘Na od kahaa kid, su nokita kud iddos karnero ku no notarin.’ ");
INSERT INTO oboNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ungketen dad en mandad kos diyot datas to langit. Lampas pa kos kahaan dutun otik iddos sokkad no mosaasaa, od sondit woy'd tanan to mgo saa rin, kuntra taddot siyowmpuu‑siyow no motallong no konnad ko‑ilangan nod sondit woy'd tanan to mgo saa ran.” ");
INSERT INTO oboNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ponunggeleng, duwon sokkad no ba‑ay no duwon sopuun molison no soopi no plata woy notarin kos sokkad. Ondan bo kos od puungan din? Od loottom sikandin to suu woy od ooyyaran tod lemas kos baoy amoy od nongkapon idda taman tod kokita rin. ");
INSERT INTO oboNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","To nokita rin don idda, od umawon din kos mgo oukuy woy mgo sumbaoy rin nod ungketen to, ‘Na od kahaa kid, su nokita kud iddos soopi ku no plata no notarin.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ungketen dad en mandad kos diyot datas to langit. Lampas pa kos kahaan taddot mgo ponolihan to Monama otik iddos sokkad no mosaasaa, od sondit woy'd tanan to mgo saa rin.” ");
INSERT INTO oboNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na duwon mandon ponunggelengan ni Disas, kahi rin to, “Duwon minuvu no oruwa kos anak din no paanan mama. ");
INSERT INTO oboNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kahi taddot ari riyot amoy rin to, ‘Ama, boggayi ad to koddin taad to korotuwan no id tuwos du konami.’ “De‑en id ba‑ad taddot amoy iddos langun no korotuwan din diyot oruwon anak din. ");
INSERT INTO oboNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Waa nouhoy pomon tadda, id boligya moho tat ari iddos taad din woy id undiyon sikandin to moriyun ingod. Dutun, id uuwakkan din kos soopi rin. ");
INSERT INTO oboNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","To no‑ominan don sikandin to soopi, timpu en mandad idda to dakkoon gutas taddon ingod, woy ka‑ay en pantok, oray'n mosuppit kos kotomanan din su worad po‑ukit nod kotommu iddos langun no ko‑ilonganon din. ");
INSERT INTO oboNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","De‑en mid undiyon sikandin to sokkad no mohingod dutun, woy id popuung dobbo sikandin nod poka‑an to mgo bavuy riyot kamot. ");
INSERT INTO oboNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na pomon to lampas no gutas, od ka‑an don nanoy sikandin taddot laug to mgo bavuy, piru waa minuvu nid boggoy kandin to ahad ondan. ");
INSERT INTO oboNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Diyot mori, noko‑anong‑anong sikandin, kahi rin to, ‘Moppiya pa iddos mgo sudsuhuwon to amoy ku, su dii ran od ko‑ominan to koka‑an, piru siyak, od patoy ad moho to gutas. ");
INSERT INTO oboNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Moppiya pa od uli ad baling diyot amoy ku, woy od ikohiyan ku sikandin to, ‘Ama, nokosaa a en diyot isowwan to Monama woy riyot kikow. ");
INSERT INTO oboNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Konnad ollog nod ngoranan a pa nikkow no anak du, de‑en tonggapa a robbo no sokkad taddot mgo sudsuhuwon du.’ ");
INSERT INTO oboNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","De‑en id logkiyat sikandin woy id uli ron diyot amoy rin. “Piru ahad moriyu poron sikandin pomon diyot baoy ran, nokita ron sikandin taddot amoy rin woy oray sikandin no no‑eruwan kandin. Na, id lungkossu iddos amoy to kodsinuggung kandin woy id kopkoppan sikandin tat amoy rin duma to kod‑arok. ");
INSERT INTO oboNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Kahi taddot anak diyot amoy rin to, ‘Ama, nokosaa a riyot isowwan to Monama woy riyot kikow. Konnad ollog nod ngoranan a pa nikkow no anak du.’ ");
INSERT INTO oboNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Piru id umow ra en baling taddot amoy iddos mgo sudsuhuwon din, kahi rin to, ‘Lukut kow! Piyodda row ka‑ay kos oray'n motoos no umpak woy id po‑umpak dow kandin. Sukuvi row mandad sikandin to sising woy sopotusi row. ");
INSERT INTO oboNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ongaya row mandad iddos oray'n maambog no natin baka woy sumboliya row, su od pista woy'd kahaa ki. ");
INSERT INTO oboNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Oyya su inis anak ku, timbang id patoy ron, piru ko‑ungkay, no‑uyag mandon. Timbang notarin sikandin, piru ko‑ungkay, nokita ron.’ De‑en id tigkonayan dan don iddos kahaan. ");
INSERT INTO oboNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Na iddon timpu, idda mandad so anak din no kakoy, diyon poron to kamot. Piru to morani ron sikandin diyot baoy, norinog din iddos mgo porohingon woy mgo kodsayow. ");
INSERT INTO oboNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","De‑en id umow rin iddos sokkad taddot mgo sudsuhuwon amoy'd inturan ko ondan kos notomanan diyot baoy. ");
INSERT INTO oboNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Mid ikahi iddos sudsuhuwon to, ‘Id uli ron iddos ari ru no moppiya kos kodlolaawa woy waa morat no notomanan. De‑en id posumbali konami taddot amoy ru iddos id paambog no natin baka.’ ");
INSERT INTO oboNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","To idda ra en kos norinog taddot kakoy, id langot sikandin woy dii ron od kopiyan nod usok. Na, id leggua iddos amoy su od imumu kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Piru id ikohiyan din iddos amoy rin to, ‘Ama, yo kod kolingow no pila ron no lahun no id puung a robbo en iling to uripon du, woy waa ahad sokkad no suhu ru no waa ku puungi. Piru ahad natit kambing dobbo, waa ad en nikkow boggayi amoy'd kahaa a duma to mgo oukuy ku. ");
INSERT INTO oboNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Piru to kod‑inguma ruwot anak du nid uwak‑uwak to korotuwan du pomon to ivog din to mgo ba‑ay nod bovoligya to lawa, id posumboliyan du moho to id paambog no natin baka.’ ");
INSERT INTO oboNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Na kahi taddot amoy to, ‘Oto, inaayun ka man duma koddi, woy kikow en kos langun no korotuwan ku. ");
INSERT INTO oboNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Piru ollog en nod kahaa ki, su iddos ari ru, timbang id patoy ron, piru ko‑ungkay, no‑uyag mandon. Timbang notarin sikandin, piru ko‑ungkay, nokita ron.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na, id itulan mandon ni Disas to ponunggelengan iddos mgo tinodduwan din. Kahi rin to, “Duwon sokkad no minuvu nod koruwonnan no id salig din kos langun no korotuwan din diyot sinolihan din. Na, duwon id uug kandin to saa no id uuwakkan din kun iddos mgo korotuwan taddot amu rin. ");
INSERT INTO oboNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","De‑en id po‑umow sikandin taddot amu rin woy id ikohiyan to, ‘Ondan man inis norinog ku moka‑atag kikow? Piyoddow rini kos listahan to soopi no id salig ku kikow, oyyos pomon ko‑ungkay, dii kud sikkow sinolihan.’ ");
INSERT INTO oboNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kohingginawa taddot sinolihan to, ‘Pomon to dii ad sinolihan to amu ku, ondan ayu kos od puungan ku? Konna a man moho od pokogaha nod puung to movoggat iling tod kokali to livuta, woy od ko‑ilow a mandad nod pokilimus. ");
INSERT INTO oboNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Oyya vos en! Iling ka‑ay kos od puungan ku, su amoy kod po‑owan ad to amu ku, duwon pa mgo minuvu nod tanggap koddi riyot ubpan dan.’ ");
INSERT INTO oboNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","De‑en id po‑umow rin iddos ipat minuvu no noko‑utang diyot amu rin. Kahi rin diyot unna to, ‘Pila man kos no‑utang du to amu ku?’ ");
INSERT INTO oboNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Mid tavak sikandin to, ‘Songo‑hatus no lata to lana to olibo.’ Kahi taddot sinolihan to, ‘Ini rad kos risibu. Na, unsad ka woy sulat du no limmompuu ra no lata.’ ");
INSERT INTO oboNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kopongnga tadda, id ikohiyan din iddos iko‑oruwa woy id inturan to, ‘Sikkow, pila man kos no‑utang du to amu ku?’ Mid tavak sikandin to, ‘Sokkad no gatus no saku no trigu.’ Kahi taddot sinolihan to, ‘Ini rad kos risibu. Na, sulat du no waumpuu ra no saku.’ ");
INSERT INTO oboNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“To nosorollan tat amu iddos id puungan taddot id loimbung no sinolihan, id doong din sikandin, kahi rin to, ‘Od kotuig en moho iddon sinolihan nod panoy atag to kod‑oubpa rin.’ ” Na ponayun mid ikahi si Disas to, “Iddos waa id pomakoy, lampas pa nod kotuig od po‑umid‑umid diyot iling dan, kuntra taddot id pomakoy no riyon don to ko‑owangan. ");
INSERT INTO oboNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","De‑en od ikohiyan ku sikiyu, no gomita row kos korotuwan dow ka‑ay to ampow't ingod atag to kodtavang to duma, su otid inguma ron kos allow nod tanan kowd to mgo korotuwan dow, duwon od tanggap koniyu riyot ubpan no waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Dos od kosolihan to disok, od kosolihan mandad to dakkoo. Iling mandad tadda, iddos diid kosolihan to disok, dii mandad od kosolihan to dakkoo. ");
INSERT INTO oboNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na, otik dii kow od kosolihan to mgo korotuwan ka‑ay to ampow't ingod, dii kow mandad od kosolihan to bonnaan korotuwan no riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Woy otik dii kow od kosolihan to korotuwan to duma, dii kow mandad od kovoggayan to korotuwan no atag nanoy koniyu. ");
INSERT INTO oboNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Waa minuvu nod po‑uripon to oruwon amu, oyyos od dokollan din to ginawa kos sokkad woy dos sokkad, id kolingasa‑i rin. Od dumoruma sikandin taddot sokkad woy dos sokkad, id podtohon din. Na iling mandad tadda, otik od po‑uripon kow to soopi, dii kow en od pokopo‑uripon to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na, to norinog taddot mgo Pariseo iddon nonaw ni Disas, id yangyang dan da en sikandin su bonnong man sikandan to soopi. ");
INSERT INTO oboNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Piru kahin Disas kandan to, “Id pokitakita kow riyot mgo minuvu no motallong kow, piru nosorollan to Monama kos diyot ginawa row. Su iddos duwon dakkoon koru‑anon diyot kod‑ontong to minuvu, id kolingasa‑i riyot kod‑ontong to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“To waa pa si Juan no Tohodboutismu, id ikuu to mgo minuvu iddos mgo Suhu ni Moises woy dos id sulat to mgo propeta. Piru to ka‑ay ron si Juan, id tigkanoy ron iddos kodponudtuu to Moppiyon Dinoggan moka‑atag to kodharit Monama, woy dos ipat sokkad, od nokkaanokkaa nod pokolonug ka‑ay. ");
INSERT INTO oboNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Piru konna kohulugan no worad koru‑anon taddot mgo Suhu ni Moises. Moomok pa nod kowora kos langit woy livuta, kuntra tod kowora iddos ahad songo‑kolet diyot mgo Suhu.” ");
INSERT INTO oboNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Na ponayun mid ikahi si Disas to, “Iddos ahad ondoy'n mama nod suwoy to sawa rin woy'd osawa to duma, nokoloivug sikandin taddot unnon sawa rin. Woy idda mandad so mama nod osawa to ba‑ay no id suwayan to sawa rin, nokoloivug mandad.” ");
INSERT INTO oboNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Na mid ikahi mandon si Disas to, “Duwon sokkad no minuvu nod koruwonnan no allow‑allow od oumpak to oray'n mahaa, moppiya kos koka‑an woy worad od nongkapon din. ");
INSERT INTO oboNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Duwon mandad sokkad no minuvu no worowora no id ngoranan ki Lazaro. Noso‑ob to koggang kos lawa rin, woy id po‑ilogga sikandin diyot sobbangan to baoy taddot minuvu nod koruwonnan. ");
INSERT INTO oboNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pomon to lampas no gutas, id kopi‑i rin nanoy nod ka‑an ahad mumu robbo nod pongko‑uug pomon diyot lomisa taddot minuvu nod koruwonnan. Piru waa en, ko konna, noruhangan da en baling, su iyon moho id porani kandin iddos mgo tuyyang nid delot to koggang din. ");
INSERT INTO oboNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Na riyot mori, id patoy si Lazaro woy id piyod sikandin to mgo ponolihan diyot ki Abraham no riyot datas to langit. Id patoy mandad iddos minuvu nod koruwonnan woy id lobbong. ");
INSERT INTO oboNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","To riyon don sikandin to Hades no ingod tid poomatoy, id po‑ilosayan sikandin. Na, to kodlangngag din, nokita rin si Abraham diyon to moriyu woy si Lazaro no riyot duug din. ");
INSERT INTO oboNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","De‑en id nganoy ki Abraham iddos minuvu nod koruwonnan. Kahi rin to, ‘Apu Abraham, ko‑eru‑i a! Kolimulimu, pa‑aggom du pa ki Lazaro kos tintoddu rin diyot oweg amoy id potaddu rin ka‑ay't dila ku, su lampas kos koosayan ku ka‑ay't apuy.’ ");
INSERT INTO oboNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Piru mid tavak si Abraham to, ‘Sompottow man iddos timpu no riyon ka pa to ampow't ingod. Oray'n moppiya kos kod‑oubpa ru woy si Lazaro, oray'n maasoy kos notomanan din. Piru ko‑ungkay, od kahaa ron sikandin ka‑ay, woy sikkow ron mandon kos od koosayan. ");
INSERT INTO oboNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ossa pa tadda, duwon oray'n mowwag no daama no noko‑ollot keta no diid ko‑ukitan to ahad ondoy ka‑ay't konami nod unduwon, woy waa mandad od ko‑ukitan dow nod undini.’ ");
INSERT INTO oboNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Kahi taddot koruwonnan to, ‘Apu, ko ungketen, od nganoy a kikow no od po‑undiyonnon du baling si Lazaro to baoy't amoy ku. ");
INSERT INTO oboNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Oyyos duwon pa limmon suwod ku rutun woy id kopi‑i ku nod koponudtulan sikandan, amoy dii ran mandad od poko‑undini to lugaa to lampas no koosayan.’ ");
INSERT INTO oboNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Piru mid tavak si Abraham to, ‘Diyon don man to kandan iddos id ponsulat ni Moises woy taddot mgo propeta. Idda en kos ko‑ilangan nod pomokayon dan.’ ");
INSERT INTO oboNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Kahi rin to, ‘Oyya en, Apu, piru dii sikandan od pomakoy tadda! Piru ko duwon od kovadnow nod undiyon to kandan, od sondit woy'd tanan en sikandan to mgo saa ran.’ ");
INSERT INTO oboNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Piru kahin Abraham kandin to, ‘Otik dii sikandan od pomakoy taddot id ponsulat ni Moises woy taddot mgo propeta, na dii en mandad sikandan od pomakoy ahad duwon pe‑en od kovadnow woy'd ponudtuu kandan.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na mid ikahi si Disas diyot mgo tinodduwan din to, “Duwon en unayan nod pokopuung to saa kos minuvu. Piru moka‑arat‑arat kod kotomanan taddot ahad ondoy nod poko‑okoy to duma riyot kodpuung to saa. ");
INSERT INTO oboNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Moppiya pa nod ikottan kos liyog din to oray'n dakkoon gilingan no batu woy id lumbag diyon to dahat, su amoy dii sikandin od poko‑okoy to duma riyot kodpuung to saa, ahad pe‑en ka‑ay't disok no mgo anak. ");
INSERT INTO oboNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","De‑en pa‑ayyad‑ayyad kow. “Otik iddos suwod du riyot kopomakoy, nokosaa kikow, sugga‑aw sikandin. Otid sondit woy'd tanan sikandin to saa rin, posinsya‑iyu. ");
INSERT INTO oboNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Otik nokosaa sikandin kikow to kopittu daom to sokkad no allow, woy kopittu mandad sikandin od buyu kikow to posinsya, posinsya‑iyu sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na id osengan si Disas taddot mgo apostoles, kahi ran to, “Longaggon, pomosolihow pe‑en kos kopomakoy roy.” ");
INSERT INTO oboNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kahin Disas kandan to, “Otik duwon kopomakoy row ahad iling da to korisokkoy to bonnit mustasa, od pokosuhu kow ruwot dakkoon kayu nod ungketen to, ‘Od kookkat ka woy alin ka riyot dahat.’ Na, od tuman en ini koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Na mid ikahi mandon si Disas to, “Ponunggeleng, duwon sudsuhuwon dow no id dadu riyot kamot o id tamong to mgo oyama. Otik lammi pa sikandin id inguma pomon to kodpuung, dii row en sikandin od osengan to, ‘Na undini ka, woy ka‑an kad.’ ");
INSERT INTO oboNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Konna en! Od ikohiyan dow baling sikandin to, ‘Na ilis kad, woy oilutu kad atag koddi woy kopongnga, sondari a. Otid pokopongnga ad, suvaa kad bo ka‑an.’ ");
INSERT INTO oboNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Konnad ko‑ilangan nod posolomatan dow iddon sudsuhuwon, oyyos id puungan din da me‑en kos kotundanan din. ");
INSERT INTO oboNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na ungketen dad en mandad koniyu. Otik nopuungan dowd iddos id popuungan to Monama koniyu, osenga row ra no, ‘Mgo sudsuhuwon koy ra no konna ollog nod doongon, oyyos id puungan doy ra kos kotundanan doy.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na, to id ponayun si Disas nid undiyon to Jerusalem, id ukit sikandin diyot ollot to Samaria woy Galilea. ");
INSERT INTO oboNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","To kod‑inguma rin diyot sokkad no bariyu, mid sinuggung kandin iddos sopuun minuvu no duwon bohok no et‑et woy id soro sikandan diyot moriyu boyow. ");
INSERT INTO oboNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Id nganoy sikandan ki Disas, kahi ran to, “Disas nod Longaggon, ko‑eruwan ka konami!” ");
INSERT INTO oboNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","To nokita sikandan ni Disas, mid ikahi sikandin to, “Undiyon kow to mgo tohodbuwis amoy'd ontongngan dan ko no‑uliyan kowd.” Woy to riyon pa sikandan to daan, no‑uliyan dan don. ");
INSERT INTO oboNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Na iddos sokkad kandan, to nokita rin no no‑uliyan don sikandin, id poolivod sikandin diyot ki Disas woy id pehes to koddoong to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mid lingko‑od sikandin diyot isowwan ni Disas woy id posolamat kandin. Iddon minuvu, toho Samaria. ");
INSERT INTO oboNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Na mid intud si Disas kandin, kahi rin to, “Konna vo sopuu man kos no‑uliyan? Ingkon don man kos siyow? ");
INSERT INTO oboNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mambo man to ini ra so konna Judio kos id livod amoy'd posolamat to Monama?” ");
INSERT INTO oboNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na kahin Disas kandin to, “Lohinat ka woy uli kad bo. No‑uliyan ka pomon to kopomakoy ru.” ");
INSERT INTO oboNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sokkad no timpu, duwon mgo Pariseo nid intud ki Disas ko kannu od tigkanoy iddos kodharit Monama. Mid tavak si Disas to, “Waa mgo kilaannan nod kokita row otid tigkanoy ron kos kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Waa mandad od poko‑ikahi to, ‘Ontongngi row, ini rad’ o ‘Idda rad‑i,’ oyya su iddos kodharit Monama, ka‑ay en to koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Na kahin Disas diyot mgo tinodduwan din to, “Od inguma en kos timpu no od ingowollon dow nod pokokita to ahad sokkad da taddot mgo allow to kodhari ku no Anak to Minuvu, piru dii row pa idda od kokita. ");
INSERT INTO oboNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Duwon mgo minuvu nod ikahi koniyu to, ‘Diyon dad sikandin lomig’ o ‘Ini rad sikandin.’ Na, yo kow ron en od pomakoy kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Oyya su iddos kodlivod ku no Anak to Minuvu, od kokita to langun ka‑ay to ampow't ingod iling to tigkow no kodse‑aa to kilat. ");
INSERT INTO oboNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Piru to dii pa ini od kotomanan, ko‑ilangan nod ukit a pa to mgo kodposuppit woy'd elleyan a to mgo minuvu to inin timpu. ");
INSERT INTO oboNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Iddos pinuungan to mgo minuvu riyot kodlivod ku no Anak to Minuvu, od poko‑iling taddot pinuungan to mgo minuvu iddot timpu ni Noe. ");
INSERT INTO oboNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Su iddon timpu, iyon id pompuungan to mgo minuvu, iddos kodka‑an, kod‑oinom woy kodpo‑osoway taman to allow nid usok si Noe riyot arka. Na, id inguma iddos dakkoon lanog woy langun dan, nongoonnod. ");
INSERT INTO oboNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ungketen dad en mandad kos pinuungan to mgo minuvu iddot timpu ni Lot. Su mid ka‑an sikandan, id oinom, id bovolli, id bovoligya, id pomuwa woy id bovaoy. ");
INSERT INTO oboNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Piru to id awa onsi Lot pomon diyot Sodoma, tigkow idda id po‑uranan to apuy woy asupre no id pomon diyot datas to langit, woy id poomatoy kos langun. ");
INSERT INTO oboNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na, ungketen dad en mandad kos od kotomanan to mgo minuvu riyot allow nod pokita ad no Anak to Minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Otid inguma ron iddon allow, iddos minuvu no riyot atop to baoy rin, ko‑ilangan no dii ron od usok diyot baoy amoy'd ponemmos pa. Idda mandad so minuvu no riyot kamot din, ko‑ilangan no dii ron od uli. ");
INSERT INTO oboNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sompotta row iddos notomanan to sawa ni Lot. ");
INSERT INTO oboNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dos ahad ondoy nod konuhunan to umuu rin, od koworan da en baling tadda. Piru iddos od dumoruma koddi ahad od undag idda to kopotayan din, duwon umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Od ikohiyan ku sikiyu, no iddon bulli, otik duwon oruwon minuvu nid poruuhoy to kodtinuhon, dos sokkad od ongayon woy dos sokkad, od kotuwos. ");
INSERT INTO oboNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Otik duwon oruwon ba‑ay nod gohiling, dos sokkad, od ongayon woy dos sokkad, od kotuwos. ");
INSERT INTO oboNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Otik duwon oruwon mama nod puung diyot kamot, dos sokkad od ongayon woy dos sokkad, od kotuwos.” ");
INSERT INTO oboNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Na mid intud kandin iddos mgo tinodduwan din, kahi ran to, “Longaggon, ingkon man ini od kotomanan?” Mid tavak si Disas ukit to ponunggelengan no mid ungketen to, “Otid kokita nod lolivuung iddos mgo uwak, od kosorollan no morani kos bangkoy. Iling mandad tadda, otid kokita iddos mgo kilaannan, od kosorollan no morani ron kos kotompusan to ingod.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na, id itulan ni Disas iddos mgo tinodduwan din to ossa pa no ponunggelengan amoy'd nonaw kandan no ko‑ilangan no inaayun sikandan od dasaa woy dii ran od ko‑obbod. ");
INSERT INTO oboNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kahi rin to, “Diyot sokkad no lugaa, duwon tohodhukum no waa allak to Monama woy id podtohon din da en kos mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Duwon mandad sokkad no ba‑ay'n bau no id livodlivod taddon tohodhukum amoy od buyu to tavang nod poponoluwon sikandin to kasu, su duwon minuvu nid ayu‑ayu kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Daom to mowwet no timpu, id bolivad iddos tohodhukum. Piru riyot mori, kohingginawa rin to, ‘Ahad waa allak ku to Monama woy id podtohon ku ra en kos mgo minuvu, ");
INSERT INTO oboNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","od tovangan ku iddon bau su id sumpuu ad moho taddot kodlivodlivod din.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kahin Disas to, “Poomdomma row iddos id puungan taddot dii motallong no tohodhukum. Id tovangan din iddos bau. ");
INSERT INTO oboNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Na lampas pe‑en nod tavang kos Monama, oyyos dii rin en od podtohonon iddos mgo minuvu no id aam din nod nganoy kandin allow bulli. ");
INSERT INTO oboNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Od ikohiyan ku sikiyu, no go‑os en od tavang iddos Monama kandan. Piru otik siyak no Anak to Minuvu, od livod don, duwon pobbo ayu od pomakoy?” ");
INSERT INTO oboNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na, duwon mgo minuvu rutun nid pososalig no motallong sikandan woy id poddisokkan dan to kod‑ontong kos duma. De‑en id itulan dan ni Disas to ponunggelengan. ");
INSERT INTO oboNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kahi rin to, “Duwon oruwon minuvu no id undiyon to templo amoy'd dasaa. Dos sokkad, Pariseo woy dos sokkad, tohodsukut to buhis. ");
INSERT INTO oboNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Id lohinat iddos Pariseo woy mid dasaa moka‑atag da en to ko‑ugolingun din. Kahi rin to, ‘Monama, od posolamat a kikow to koddin botasan, su konna a iling to dumon mgo minuvu. Konna a bonnong to soopi, konna a od loimbung woy konna a od loivug. Od posolamat a mandad no konna a iling duwot tohodsukut to buhis. ");
INSERT INTO oboNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ko‑oruwa a od puasa to ipat simana, woy id boggoy a mandad to iko‑sopuu no id pomon to langun no notanggap ku.’ ");
INSERT INTO oboNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Piru iddos tohodsukut to buhis, id po‑ibpit sikandin woy ahad kodlangngag dobbo riyot datas to langit, waad en. Iyon din da id puungan, id ounduk sikandin woy id pukpuk din kos kabpa rin pomon to kodsondit din to mgo saa rin. Kahi rin to, ‘Monama, ko‑eruwan ka koddi no mosaasaa.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na kahin Disas to, “Od ikohiyan ku sikiyu, no to id uli ron iddos tohodsukut to buhis, sikandin kos id podmotallong to Monama, konna iddos Pariseo. Su iddos ahad ondoy nod poratasdatas, od poobbovan. Piru iddos od poobbava, od porotason.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sokkad no allow, id piyod to mgo minuvu iddos disok no mgo anak dan diyon to ki Disas. Id kopi‑i ran no id pokita ni Disas kos kopiyannoy rin diyot mgo anak ukit to kodtoddung din to bollad din taddot uu ran diyon to koddasaa. To nokita idda taddot mgo tinodduwan din, id sugga ran sikandan. ");
INSERT INTO oboNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Piru id poporani ni Disas iddos mgo anak diyot kandin, woy id ikohiyan din iddos mgo tinodduwan din to, “Podtohona row ron ikos mgo anak nod porani koddi woy yo row sikandan sugga‑a. Su iddos mgo minuvu nod salig to Monama iling to kodsalig to mgo anak, sikandan en kos no‑iraom diyon to kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bonnaavonnaa nod ikohiyon ku koniyu, no iddos ahad ondoy no diid salig to Monama iling to kodsalig to anak, dii en od kolonug diyon to kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na, duwon sokkad no ponguu to mgo Judio no mid intud ki Disas, kahi rin to, “Moppiyon Tohodnonaw, ondan kos ko‑ilangan nod puungan ku amoy'd pokotanggap a to umuun waad tomanon?” ");
INSERT INTO oboNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mid tavak si Disas to, “Mambot od ngoranan a nikkow to moppiya? Oyyos sokkad da kos moppiya, idda ra en so Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na moka‑atag taddot intud du, nokosaddoo kad man taddot mgo suhu no mid ungketen to, ‘Yo kod loivug, yo kod imatoy, yo kod ponakow, yo kod posivonnaa to uhus woy rispitu ka to amoy woy inoy ru.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kahi taddot minuvu to, “Langun duwon no suhu, id puungan kud pomon poron to ko‑onakoy ku.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","To norinog idda ni Disas, id ikohiyan din iddos minuvu to, “Duwon pa sokkad no kulang diyot kikow. Boligya ru kos langun no korotuwan du woy pomboggoy ru kos bayad diyot worowora. Na otid puungan du ini, duwon en korotuwan du riyot datas to langit. Kopongnga, livod ka woy duma ka koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Piru to norinog idda taddot ponguu, naanu sikandin, oyyos dakkoo man kos korotuwan din. ");
INSERT INTO oboNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","To nokita ni Disas no naanu iddos ponguu, mid ikahi sikandin to, “Mosuppit en taddot minuvu no dakkoo kos korotuwan nod kolonug diyon to kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Moomok pa iddos kod‑usok to kamelyo riyon to bobbot simat kuntra to minuvu no dakkoo kos korotuwan nod lonug diyon to kodharit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Na iddos nokorinog tadda, mid ikahi to, “Ko ungketen, ondoy pobbo kos od kotobbus?” ");
INSERT INTO oboNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mid tavak si Disas to, “Iddos diid kopuungan to minuvu, od kopuungan en to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kahin Pedro to, “Na sikami, id tonanan doyd kos langun pomon to koddumoruma kikow.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kahin Disas kandan to, “Bonnaavonnaa nod ikohiyon ku koniyu, no iddos ahad ondoy nod tanan to mgo korotuwan din, sawa rin, mgo suwod din, amoy rin, inoy rin woy mgo anak din atag da en to kodlonug to kodharit Monama, ");
INSERT INTO oboNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","od pokotanggap sikandin to lampas pa taddot id tonanan din. Woy init morin allow, od pokotanggap sikandin to umuun waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Na, id livuung ni Disas iddos sopuu‑oruwon tinodduwan din, woy id ikohiyan din to, “Pominog kow, od undiyon kid to Jerusalem. Dutun, od kotuman don iddos langun nid sulat to mgo propeta moka‑atag koddi no Anak to Minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Su id boggoy a nikandan diyot bollad to konna mgo Judio, od sumpoliton a, od po‑ilawan woy'd ilobban. ");
INSERT INTO oboNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Od ponlompossan a nikandan woy kopongnga, od imotayan, piru riyot iko‑otollun allow, od kovadnow a.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Piru waa en nokaabbot iddos mgo tinodduwan ni Disas taddot id ikahi rin, su noko‑ollos man kos kohulugan tadda. ");
INSERT INTO oboNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Na, to morani ron onsi Disas diyot bonuwa to Jerico, duwon butud no mid ounsad diyot ibpit to daan amoy'd pokilimus. ");
INSERT INTO oboNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","To nokorinog iddon butud no id lihad iddos mo‑uraan minuvu rutun, id intud sikandin ko ondan idda. ");
INSERT INTO oboNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kahi taddot mgo minuvu to, “Id lihad si Disas no toho Nazaret.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","To norinog din idda, id pehes sikandin no mid ungketen to, “Disas, lubbad ni David, ko‑eruwan ka koddi!” ");
INSERT INTO oboNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Na iddos mgo minuvu nid unna ki Disas, id sugga kandin amoy'd po‑onong‑onong. Piru ayas da en baling sikandin id pehes nid ungketen to, “Lubbad ni David, ko‑eruwan ka koddi!” ");
INSERT INTO oboNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Na id soro si Disas, woy id pa‑angoy rin iddos butud. To nokoporani ron idda kandin, mid intud sikandin to, ");
INSERT INTO oboNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ondan man kos id kopi‑i ru nod puungan ku kikow?” Id tavak sikandin to, “Longaggon, id kopi‑i ku nod pokokita.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kahin Disas kandin to, “Od pokokita kad. No‑uliyan ka pomon to kopomakoy ru.” ");
INSERT INTO oboNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Idda ron en, nokokita ron iddos butud woy id duma sikandin ki Disas. Na id doong din kos Monama, woy dos langun no minuvu no nokokita tadda, id doong dan mandad kos Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na id inguma onsi Disas diyot Jerico, su riyon man kos od ukitan po‑undiyon to Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Dutun, duwon sokkad no minuvu no id ngoranan ki Saqueo. Sokkad sikandin no ponguu to mgo tohodsukut to buhis woy dakkoo kos korotuwan din. ");
INSERT INTO oboNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Id kopi‑i rin nod pokokita ki Disas, piru dii rin od kokita pomon to mo‑uraan minuvu woy molivutut sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","De‑en id lungkossu sikandin diyot ko‑unnan, woy id pomenek diyot kayu no sikomoro amoy'd kokita rin si Disas, su riyon me‑en sikandin od ukit. ");
INSERT INTO oboNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","To nokopantok don si Disas taddon kayu, mid langngag sikandin woy id ikohiyan din sikandin to, “Saqueo, lukut ka ponog su ko‑ilangan en nod allus a riyot baoy ru ko‑ungkay'n allow.” ");
INSERT INTO oboNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","De‑en mid lukutlukut si Saqueo id ponog, woy nahaahaa sikandin nid piyod ki Disas diyot baoy rin. ");
INSERT INTO oboNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","To nokita taddot mgo minuvu no id porumannoy si Disas woy si Saqueo, id pommivig dan no mid ungketen to, “Mambot duwon moho sikandin od allus to baoy't mosaasaa?” ");
INSERT INTO oboNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na, to riyon don si Disas to baoy, id lohinat si Saqueo woy mid ikahi ki Disas to, “Longaggon, id boggoy ku kos kotongnga to korotuwan ku riyot mgo worowora. Woy otik nokoloimbung a to ahad ondoy, od ko‑oppaton ku pe‑en kos id po‑uli ku kandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kahin Disas to, “Ko‑ungkay'n allow, sikkow duma to pomilya ru, id tobbus don, su id pomakoy ka man iling taddot kopomakoy to kovuyyahan du no si Abraham. ");
INSERT INTO oboNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Su siyak no Anak to Minuvu, mid undini to ampow't ingod amoy od nangkap taddot nongotarin woy'd tobbus kandan.” ");
INSERT INTO oboNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na laggun to id pominog iddos mgo minuvu, id itulan dan ni Disas to ponunggelengan su morani ron man sikandan diyot Jerusalem, woy kunan dan ko otid inguma ran dutun, od tigkanoy ron kos kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kahin Disas kandan to, “Duwon sokkad no minuvu no oray nod rispituwon no mid undiyon to moriyun ingod amoy od boggayan to kotungud nod kovovallan no hari. Kopongnga, od livod don sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Piru to waa pa sikandin nokologkiyat, id po‑umow rin iddos sopuun sudsuhuwon din. Dos ipat sokkad, id tuwossan din to sokkad no soopin buawan. Kahi rin kandan to, ‘Nigusyu row ikon soopi taman to kodlivod ku.’ ");
INSERT INTO oboNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Na, duwon mgo mohingod no od kolingasa kandin. To noko‑ipanow ra en sikandin, id popiyod sikandan to mgo minuvu nod tundug amoy'd po‑osengon no dii ran od kopiyan no od ponguu kandan iddon minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Piru ahad ungketen, sikandin en kos id boggayan to kotungud nod kovovallan no hari. To kod‑uli rin diyot ingod din, id po‑umow rin iddos mgo sudsuhuwon no id tuwossan din to soopi amoy'd kosorollan ko pila kos gononsya tadda. ");
INSERT INTO oboNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Na, id inguma iddos unnon sudsuhuwon woy mid ikahi to, ‘Sir, iddos sokkad no soopi ru no buawan, kosopuu pe‑en kos gononsya.’ ");
INSERT INTO oboNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kahi taddot hari to, ‘Moppiya kos id puungan du. Moppiya ka woy kosolihan no sudsuhuwon. Pomon tod kosolihan ka man to disok, od boggayan ku sikkow to kotungud nod ponguu to sopuun bonuwa.’ ");
INSERT INTO oboNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","To kod‑inguma mandad taddot iko‑oruwon sudsuhuwon, mid ikahi sikandin to, ‘Sir, dos sokkad no soopi ru no buawan, kolimma pe‑en kos gononsya.’ ");
INSERT INTO oboNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kahi taddot hari to, ‘Moppiya, od boggayan ku mandad sikkow to kotungud nod ponguu to limmon bonuwa.’ ");
INSERT INTO oboNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Piru to kod‑inguma taddot iko‑otollun sudsuhuwon, mid ikahi sikandin to, ‘Sir, ini rad kos soopi ru. Id temmos ku ini woy id ooyyaran ku tid bukus. ");
INSERT INTO oboNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Su novaakkan a kikow, oyyos nokosaddoo a no oraroy ka no istriktu. Od ongayon du pe‑en ahad iddos konna kikow woy od kottuwon du ahad iddos waa ru oiluggati tid pomuwa.’ ");
INSERT INTO oboNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Na kahi taddot hari to, ‘Morat ka no sudsuhuwon. Od silutan ku sikkow ukit da en taddot id oseng du. Su nokosaddoo ka rad bos en no istriktu a, woy od ongayon ku pe‑en ahad iddos konna koddi woy od kottuwon ku ahad iddos waa ku oiluggati tid pomuwa. ");
INSERT INTO oboNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Piru mambot waa ru moho id ta‑aw kos soopi ku riyot bangku amoy od kotanggap ku nanoy idda no duwon don tuvu?’ ");
INSERT INTO oboNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Na id osengan taddot hari iddos mgo minuvu nid lohinat dutun, kahi rin to, ‘Ongaya row kos soopi ruwot kandin woy boggoy row riyot sudsuhuwon no nokogononsya to sopuu.’ ");
INSERT INTO oboNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kahi ran to, ‘Oyya, Sir, piru duwon don man sopuun soopi rin no buawan.’ ");
INSERT INTO oboNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mid tavak dos hari to, ‘Od ikohiyan ku sikiyu, no iddos od kosolihan, od duhangan pa en kos diyot kandin. Piru iddos diid kosolihan, od ongayon pe‑en ahad iddos disok dobbo no riyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na, moka‑atag taddot mgo minuvu nod kuntra koddi no diid kopiyan nod hari a kandan, piyodda row sikandan dini woy imotayi row ka‑ay't isowwan ku.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nopongnga osenga ni Disas idda, id unna boyow sikandin nid ipanow taddot mgo tinodduwan din po‑undiyon to Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","To morani ran don diyot bariyu to Betpahe woy Betania no riyot banod to Buvungan to mgo Olibo, id po‑unna rin dutun iddos oruwa taddot mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Kahi rin kandan to, “Unna kowd diyot bariyu no riyot ko‑unnan woy to kod‑inguma kow rutun, od kokita row kos natit asnu no waa pa nosokayi no id ikot. Okasa row vo idda woy tuyuka row rinit koddi. ");
INSERT INTO oboNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Otik duwon od intud koniyu no, ‘Mambot od okason dow kos natit asnu?’ tovaka row sikandin to, ‘Od ko‑ilonganon ini tod Longaggon.’ ” ");
INSERT INTO oboNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na, id ipanow iddos id suhu ni Disas woy nokita ran en dutun iddos id oseng din kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","To id akas dan don iddos natit asnu, id inturan dan taddot mgo komunoy, kahi ran to, “Mambot id akas dow ika?” ");
INSERT INTO oboNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mid tavak sikandan to, “Od ko‑ilonganon ini tod Longaggon.” ");
INSERT INTO oboNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na, id tuyuk dan iddos natit asnu po‑undiyon to ki Disas. Id ompasan dan idda to mgo umpak dan, woy id sakoy ron si Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","To od po‑isau ron sikandin to Jerusalem, id ampas to mgo minuvu iddos mgo umpak dan diyot daan nod ukitan din to kodposivantug kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na, to morani ron si Disas diyot Jerusalem, no riyon don pantok tod tupang pomon to Buvungan to mgo Olibo, nahaahaa iddos mo‑uraan tinodduwan din woy id pehes dan to koddoong to Monama pomon taddot mgo mokososoobbun nokita ran. ");
INSERT INTO oboNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kahi ran to, “Od doongon ta kos Hari no id popiyod to Monama nod Longaggon. Od posivontuhan ta sikandin, su nokod‑uli ron kos koroniyan ta riyon to Monama no riyot datas to langit. Od posivontuhan ta sikandin!” ");
INSERT INTO oboNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na riyot mo‑uraan minuvu, diyon en mandad iddos dumon mgo Pariseo no mid ikahi ki Disas to, “Tohodnonaw, posoro‑ow kos mgo tinodduwan du nod doong kikow.” ");
INSERT INTO oboNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Piru mid tavak si Disas to, “Otid po‑onong‑onong sikandan, iddos mgo batu ron kos od pehes to koddoong koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","To morani ron si Disas diyot Jerusalem woy to kodpomantow rin taddon bonuwa, nokosinoggow sikandin to mattag eru rin to mgo minuvu rutun. ");
INSERT INTO oboNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kahi rin to, “Jerusalem, otik nosorollan dow nanoy ahad ko‑ungkay'n allow, ko ondan kos od puungan dow amoy'd kotanggap dow iddos kosunayan, piru dii row pa ini od kosorollan. ");
INSERT INTO oboNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Od inguma en kos allow no od lingkusan ikos bonuwa row taddot od pongkuntra koniyu, woy od boovahan dan kos langun nod ukitan amoy dii kow od pokoleggua. ");
INSERT INTO oboNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Od iponnason kow nikandan woy'd gobban dan kos bonuwa woy mgo baoy row, no waa ahad sokkad duwot mgo batu no id podluntudluntud nod kosama. Ini en kangkan kos od inguma no koosayan dow, oyyos waa row kilaanna no ko‑ungkay kos timpu nod undini kos Monama amoy'd tobbus koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na, to kod‑inguma ran diyot Jerusalem, mid undiyon si Disas to templo woy id pa‑awa rin iddos id pombovoligya riyot lama. ");
INSERT INTO oboNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kahi rin kandan to, “No‑ikahi riyot Nosulat no Kahit Monama no, ‘Iddos koddin baoy, od ngoranan no baoy atag to koddasaa.’ Piru sikiyu, id bovallan dow moho ini nod oubpan to mgo tokawon.” ");
INSERT INTO oboNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na ipat allow, mid nonaw si Disas diyon to templo. Piru iddos mgo ponguu to tohodbuwis dutun, dos mgo tohodnonaw to Suhu ni Moises woy dos od pombuyyahon to mgo Judio, id pomuhawang dan nod imatoy kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Piru waa nokita ran to po‑ukit, su oray'n notoosan iddos langun no minuvu to kodpominog taddot nonaw ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sokkad no allow, to id nonaw si Disas woy id ponudtuu moka‑atag to Moppiyon Dinoggan diyot mgo minuvu no riyot templo, id porani kandin iddos mgo ponguu to tohodbuwis, dos mgo tohodnonaw to Suhu ni Moises woy dos od pombuyyahon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kahi ran ki Disas to, “Ondak kotungud du ka‑ay't langun nid puungan du? Woy ondoy kos id boggoy kikow ka‑ay'n kotungud?” ");
INSERT INTO oboNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mid tavak si Disas to, “To dii ku pa od tovakon kos intud dow, duwon intud ku koniyu. ");
INSERT INTO oboNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Iddos kotungud ni Juan to kodboutismu, id pomon bo riyot Monama o riyot minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Na, id posisipoy ran kod monnuwon dan idda tod tavak, kahi ran to, “Otid ikahi ki no, ‘Iddos Monama kos id boggoy kandin to kotungud,’ od ikahi sikandin to, ‘Mambot waa kow id pomakoy ki Juan?’ ");
INSERT INTO oboNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Piru otid ikahi ki no, ‘Minuvu kos id boggoy kandin to kotungud,’ na od lumbahon ki to mgo minuvu to batu taman tod patoy, su id pomakoy ran no propeta en si Juan.” ");
INSERT INTO oboNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","De‑en mid tavak dan ki Disas to, “Waa koy nokosaddoo ko ingkon idda id pomon.” ");
INSERT INTO oboNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kahin Disas kandan to, “Ko ungketen, dii ku mandad sikiyu od ponudtulan ko ingkon id pomon kos kotungud ku to kodpuung ka‑ay.” ");
INSERT INTO oboNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na id itulan ni Disas to ponunggelengan iddos mgo minuvu, kahi rin to, “Duwon sokkad no minuvu no id pomuwa to ubas diyot kamot din. Nopongnga, id popursintuwan din idda woy mid undiyon sikandin to osson ingod to mouhoy'n timpu. ");
INSERT INTO oboNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","To timpu ron to kodpomupu to ubas, id suhu rin kos sokkad taddot mgo sudsuhuwon din diyot id pomursintu amoy od angoy to kandin no taad. Piru to kod‑inguma taddot sudsuhuwon din, id pomodasan dan sikandin woy id po‑uli no waa nopiyod. ");
INSERT INTO oboNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Na, id suhu mandon taddot komunoy iddos ossa pa no sudsuhuwon din. Piru to id inguma iddos sudsuhuwon dutun, id pomodasan dad en sikandin, id po‑ilawan woy id po‑uli no waa nopiyod. ");
INSERT INTO oboNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Id suhu mandon taddot komunoy iddos iko‑otollun sudsuhuwon din, piru to kod‑inguma rin dutun, id poliyan dan sikandin woy id goyod nid poleggua pomon diyot ubasan. ");
INSERT INTO oboNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","De‑en kohingginawa taddot komunoy to, ‘Ondan pobbo kos od puungan ku? Moppiya pa, ini ron so budtung no anak ku no id dokollan ku to ginawa kos od suhuwon ku, su saddook od rispituwon dan don.’ ");
INSERT INTO oboNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Piru to nokita taddot id pomursintu no idda ron so anak tat komunoy kos od inguma, id po‑ikohiyoy ran to, ‘Ika ron kos anak to komunoy. Na, od imotayan ta sikandin amoy siketa ron kos od pokokomunoy ka‑ay't ubasan!’ ");
INSERT INTO oboNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","De‑en id goyod dan sikandin nid poleggua pomon diyot ubasan woy id imotayan.” “Na, ondan ayu kos od puungan taddot komunoy to ubasan diyot id pomursintu? ");
INSERT INTO oboNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Od undiyonnan din sikandan woy'd imotayan, woy od popursintuwan din to ossa iddos ubasan.” To norinog idda taddot mgo minuvu, mid ikahi sikandan to, “Muopa nanoy no id poporiyu idda to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Piru id tongtongngan sikandan ni Disas woy id ikohiyan to, “Na ondan man kos koovottan dow taddot Nosulat no Kahit Monama no mid ungketen to, ‘Iddos batu no id oovoddan to tohodbovaoy su kunan dan ko waa koru‑anon, idda vos en kos batu no mosalig no po‑unsaran.’ ");
INSERT INTO oboNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Dos ahad ondoy nod pokovuntug taddon batu, od kotoppuwan woy dos od ko‑uuhan tadda, od koubpot en.” ");
INSERT INTO oboNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na, to norinog taddot mgo tohodnonaw to Suhu ni Moises woy taddot mgo ponguu to tohodbuwis iddos ponunggelengan ni Disas, noovottan dan no sikandan kos id suhat din. De‑en od omotton dan nanoy sikandin to idda ra en no timpu, piru novaakkan dan taddot mo‑uraan minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pomon taddon timpu, id nangkap dan to po‑ukit to kod‑ammot ki Disas. Duwon mgo minuvu no id poponi‑id dan kandin nod po‑uvag‑uvag no moppiya kos dontulon. Piru iyon id kopi‑i ran no od sahad si Disas ukit to osengan din, su amoy duwon unayan dan nod uug kandin to saa riyot gubernador no duwon kotungud nod hukum. ");
INSERT INTO oboNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na iddon mgo tohodponi‑id, mid intud ki Disas, kahi ran to, “Tohodnonaw, nokosaddoo koy no bonnaa en kos id oseng woy id nonaw ru. Woy nosorollan doy no ahad ondoy nod isowwon du, id pod‑iling du kos kodnonaw ru, oyyos waa od podmusingon du woy iyon du id nonaw, iddos kovonnaan moka‑atag to id kopi‑it Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","De‑en diyot mgo Suhu ni Moises, ollog bo iddos kodbayad to buhis diyot hari to Roma o dii?” ");
INSERT INTO oboNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Piru nosorollan ni Disas iddos morat no dontulon dan, de‑en kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pokitanna a to soopi to Roma.” To id toyawwan dan si Disas to soopi, id ikahi sikandin to, “Ondoy man bonnong woy ngaran kos od kokita ka‑ay?” Mid tavak sikandan to, “Iddos hari to Roma.” ");
INSERT INTO oboNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kahin Disas to, “Ko ungketen, boggoy row riyot hari to Roma iddos kandin, woy boggoy row riyot Monama iddos kandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na, waa sikandin nokosahad ahad id kopi‑i ran nanoy nod sahad sikandin ukit to mgo osengan din diyot isowwan to mgo minuvu. Nosoobbuwan dan oraroy taddot tavak din, de‑en nokopo‑onong‑onong dan dobbo. ");
INSERT INTO oboNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na, duwon mgo Saduseo no id porani ki Disas. Inin mgo minuvu, konnod pomakoy nod bodnawon to Monama iddos id poomatoy ron. ");
INSERT INTO oboNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Kahi ran to, “Tohodnonaw, nosulat diyot mgo Suhu ni Moises no otik duwon mama nod patoy no waa anak dan taddot sawa rin, ko‑ilangan no od pomoowwon idda to suwod din amoy'd poko‑anak dan atag taddot id patoy. ");
INSERT INTO oboNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ponunggeleng, duwon pittun toosuwod. Dos kinokokayan, id osawa piru id patoy no waa anak. ");
INSERT INTO oboNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na, id pomau taddot iko‑oruwon suwod din iddos ba‑ay. Id patoy mandad sikandin no waa anak. ");
INSERT INTO oboNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ungketen dad en mandad kos notomanan taddot iko‑otollun suwod taman to iko‑pittu, id poomatoy ran langun no waa anak. ");
INSERT INTO oboNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Diyot mori, id patoy mandad iddos ba‑ay. ");
INSERT INTO oboNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na, init allow to kodbadnow taddot id poomatoy ron, ondoy musing kandan kos tullid no sawa taddot ba‑ay? Su iddos langun tat pittun toosuwod, noko‑osawa man kandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mid tavak si Disas to, “Ka‑ay to ampow't ingod, od po‑osoway kos mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Piru iddos ahad ondoy no ollog nod bodnawon to Monama woy'd lonug kandin diyot datas to langit, dii ron od po‑osoway. ");
INSERT INTO oboNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Dii ron mandad sikandan od poomatoy, oyyos od poko‑iling don sikandan to mgo ponolihan. Mgo anak don sikandan to Monama su id badnow rin man. ");
INSERT INTO oboNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na moka‑atag taddot mgo minuvu no id poomatoy ron, ahad si Moises, id posivonnaa nod bodnawon en sikandan to Monama. Su iddot mid pokita kandin iddos Monama riyot id loglog no sopinit, id ngoranan din iddos od Longaggon no, ‘Monama ni Abraham, ni Isaac woy ni Jacob.’ Na, ungketen kos no‑ikahi ahad nouhoy ron id poomatoy onsi Abraham. ");
INSERT INTO oboNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","De‑en pomon ka‑ay, od kosorollan ta, no od kovadnow en iddos poomatoy ron, oyya su iddos Monama, konna sikandin Monama taddot id poomatoy ron, ko konna, Monama taddot nongo‑uyag. Su riyot kod‑ontong din, nongo‑uyag kos langun.” ");
INSERT INTO oboNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na kahi taddot dumon tohodnonaw to mgo Suhu ni Moises to, “Tohodnonaw, ollog en kos tavak du.” ");
INSERT INTO oboNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pomon tadda, worad od poko‑aku nod intud ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Na mid intud si Disas kandan, kahi rin to, “Mambo man tid ikahi to mgo minuvu no lubbad ni Harin David iddos Mesiyas? ");
INSERT INTO oboNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Oyyos si David don en kos id oseng diyot libru to mgo Salmo no mid ungketen to, ‘Mid ikahi iddos Monama riyon tod Longaggon ku no, Unsad ka lomig to kowanan ku, ");
INSERT INTO oboNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","taman tod kotalu kud iddos od pongkuntra kikow.’ ");
INSERT INTO oboNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na, su id oseng man ni David no Longaggon din iddos Mesiyas, de‑en konna ra sikandin lubbad ni David, ko konna, Longaggon din mandad.” ");
INSERT INTO oboNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Laggun tid pominog iddos mo‑uraan minuvu, id ikohiyan ni Disas iddos mgo tinodduwan din to, ");
INSERT INTO oboNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Bantoy kow taddot mgo tohodnonaw to Suhu ni Moises no od kotoosan nod oumpak to mowwet woy'd pokitakita. Id kopi‑i ran nod kumustan woy od rispituwon diyot od kolivuungan to mgo minuvu. Otik diyon sikandan to simba‑an to mgo Judio o riyot pista, id kopi‑i ran nod unsad diyot mgo unsaran no id panoy atag taddot od rispituwon no mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Id okalan dan iddos mgo ba‑ay'n bau amoy'd ka‑ahaw ran iddos koruwonnan dan. Woy amoy od kotombunan kos morat no pinuungan dan, od poowetton dan kos dosalon dan no uvag kun to moppiya sikandan no mgo minuvu. Purisu lampas en no moka‑arat‑arat iddos silut to Monama kandan.” ");
INSERT INTO oboNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sokkad no allow to riyon si Disas to templo, nokita rin iddos od pongkoruwonnan no mid ta‑aw to soopi ran diyot tootawwan to soopi. ");
INSERT INTO oboNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Woy nokita rin mandad iddos worowora no ba‑ay'n bau no id ta‑aw to oruwon pisus. ");
INSERT INTO oboNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kahin Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no dakkoo pa kos id boggoy ka‑ay't worowora no bau kuntra taddot langun no nokovoggoy. ");
INSERT INTO oboNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Su iddos id boggoy to dakkoon soopi, sama robbo idda taddot langun no koruwonnan dan. Piru inin bau, ahad worowora sikandin, id boggoy rin iddos sapuu uvag no soopi rin.” ");
INSERT INTO oboNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na, duwon mgo tinodduwan din no id po‑ikohiyoy moka‑atag taddot oray'n motoos no templo, su iddot kodbovaa tadda, id gamit iddos mahaa no mgo batu woy duma pon mahaa no id pomboggoy rutun atag to Monama. Piru kahin Disas to, ");
INSERT INTO oboNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Od inguma en kos timpu nod gobban kos langun no nokita row. Oyya su wora ahad sokkad duwot mgo batu no id podluntudluntud nod kosama.” ");
INSERT INTO oboNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na mid intud ki Disas iddos mgo tinodduwan din, kahi ran to, “Tohodnonaw, kannu man od kotuman kos id oseng du, woy ondan kos kilaannan no asow ron ini od kotuman?” ");
INSERT INTO oboNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mid tavak si Disas to, “Bantoy kow no konna kow od ko‑okalan. Su mo‑uraa kos od loppow no od po‑uvag‑uvag nod piyod to koddin ngaran nod ikahi no, ‘Siyak en kos Mesiyas,’ woy od ikahi no asow ron kos kotompusan to ingod. Piru yo kow ron en od dumoruma kandan, su uhus kos osengan dan. ");
INSERT INTO oboNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Otid pokorinog kow no duwon gira ka‑ay't morani woy riyot moriyu, yo kow'd kovaakki. Oyyos ko‑ilangan en nod kotuman ini langun, piru konna pa ini kos kotompusan to ingod.” ");
INSERT INTO oboNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na ponayun mid ikahi si Disas to, “Iddos sokkad no ingod, od pokidgira to osson ingod woy dos sokkad no kohoriyan, od pokidgira to osson kohoriyan. ");
INSERT INTO oboNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Duwon monokkaan mgo linug woy duwon dakkoon gutas diyot nokod‑osso‑osson lugaa, woy mo‑uraa kos od poomatoy to bohok. Od kokita kow mandad iddos moka‑arat‑arat woy dos mgo mokososoobbu no id pomon diyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Piru to dii pa ini od kotomanan, od omotton kow nikandan woy'd posupittan. Id boggoy kow riyot bollad to mgo ponguu to simba‑an to Judio woy'd prisuwon. Od piyoddon kow nikandan diyot isowwan to mgo hari woy riyot mgo gubernador pomon to kopomakoy row koddi. ");
INSERT INTO oboNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na, idda ron en kos timpu row no od pokoposivonnaa kow kandan moka‑atag koddi. ");
INSERT INTO oboNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","De‑en tota‑aw row riyot poomdom dow, no otid inguma ron iddon timpu, yo kow'd kaanu ko ondan kos od osengon dow. ");
INSERT INTO oboNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Oyyos od boggayan ku sikiyu to kotuihan to kodtavak woy'd boggayan ku sikiyu to moraom no koovottan, su amoy iddos od pongkuntra koniyu, waa id poko‑apuu ran woy id pokosupak koniyu. ");
INSERT INTO oboNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ahad iddos amoy woy inoy row, mgo suwod, mgo korumannan woy mgo oukuy row, od boggoy koniyu riyot bollad to od pongkuntra koniyu woy dos duma koniyu, od imotayan. ");
INSERT INTO oboNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Id kolingasa‑i kow to langun no minuvu pomon to kopomakoy row koddi. ");
INSERT INTO oboNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Piru ahad ungketen kos kodposuppit koniyu, waa en od poko‑ahaw koniyu pomon diyot bollad to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","De‑en ponayun kow lohinat no mosalig diyot kopomakoy, su ukit tadda, od kotanggap dow kos umuun waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Na ponayun mid ikahi si Disas to, “Otid kokita row nod lingkusan don to mgo sundau iddos Jerusalem, od kosorollan dow no asow ron kos kororattan. ");
INSERT INTO oboNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Otid inguma ron inin kotomanan, iddos id pon‑oubpa riyot Judea, ko‑ilangan nod paahuy riyot buvunganon. Idda mandad so riyot Jerusalem, ko‑ilangan od paahuy ron woy dos diyot kamot, ko‑ilangan dii ron od livod diyot Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Su ini en kos timpu nod silutan to Monama kos Jerusalem, woy od kotuman iddos langun no no‑ikahi riyot Nosulat no Kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Iddon timpu, moko‑eru‑eru iddos mgo movoddos woy dos duwon anak nod susu poron! Oyyos lampas en kos koosayan nod inguma taddon bonuwa, su lampas don kos langot to Monama kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dos duma kandan, od poomatoy to polihuma, dos duma, od omotton woy'd uriponnon diyot osson ingod. Na iddos bonuwa to Jerusalem, od dorattan en, woy idda ron so konna mgo Judio kos od ponguu taman tod kopongnga ron kos timpu to kodponguu ran.” ");
INSERT INTO oboNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Na, duwon mandad mokososoobbun mgo kilaannan nod kokita riyot allow, buwan woy riyot mgo bitu‑on. Od ko‑oratan woy'd kotaong kos mgo minuvu ka‑ay to ampow't ingod pomon to dohonoggon to dahat woy doorakkoon baud. ");
INSERT INTO oboNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Od kovantang kos mgo minuvu pomon to allak dan tod kotomanan ka‑ay to ampow't ingod. Od pongo‑antog iddos duma pa no riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na, od kokita to langun iddos lampas no se‑aa to kotuusan ku no Anak to Minuvu riyot kod‑inguma ku nod dumannan to souhapun. ");
INSERT INTO oboNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","De‑en otid tigkanoy ron inin kotomanan, ponokkala row kos ginawa row woy langngag kow riyot datas to langit, su konnod kouhoy, od inguma kos kodtobbus koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Na id itulan dan ni Disas to ponunggelengan, kahi rin to, “Poomdomma row iddos kayun igera woy dos duma pon mgo kayu. ");
INSERT INTO oboNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Otid bullas don idda to mgo do‑un, od kokita woy'd kosorollan ta no asow ron kos tintollak. ");
INSERT INTO oboNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iling mandad tadda, otid kokita rowd inin mgo kotomanan, od kosorollan dow no asow ron kos kodharit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Bonnaavonnaa nod ikohiyon ku koniyu, no od kotuman inis langun nod kotomanan, to dii pa od poomatoy kos mgo minuvu no no‑uyag to inin timpu. ");
INSERT INTO oboNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Od kowora kos langit woy livuta, piru inis mgo kahi ku, dii en od kowora.” ");
INSERT INTO oboNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Na ponayun mid ikahi si Disas to, “De‑en bantoy kow no dii kow od ko‑uripon to mgo ingowollon ka‑ay to ampow't ingod, iling to lampas no kodka‑an, kodhubughubug woy mgo sowkuu moka‑atag to kod‑oubpa. Su tigkow od inguma iddon allow woy'd kotingkommod kow iling to id sahad diyot lettag. ");
INSERT INTO oboNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Oyyos iling taddot kosiyopatoy tod kopaus no lettag, ungketen dad en mandad iddos kod‑inguma taddon allow riyot langun no minuvu ka‑ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Purisu panoypanoy kow inaayun, woy dasaa kow nod pokoti‑is kow taddot mgo kosupittan nod inguma koniyu woy dasaa kow no waa allak dow to kod‑isau koddi no Anak to Minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na ipat allow, id nonaw si Disas diyot templo woy ipat bulli, id undiyon sikandin to Buvungan to mgo Olibo su riyon sikandin od tinuhon. ");
INSERT INTO oboNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","De‑en sollom poron, mid undiyon to templo iddos mgo minuvu amoy'd pominog kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na, asow ron od inguma iddos pista to Paan no Waa Potuvu no id ngoranan mandad no pista to Kodlihad to Ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Dos mgo ponguu to tohodbuwis woy dos mgo tohodnonaw to Suhu ni Moises, id nangkap dan to po‑ukit to kod‑imatoy ki Disas no waa od pokosaddoo, oyyos od kovaakkan dan to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na, id losuran ni Moivuyan si Judas no id ngoranan ki Iscariote no sokkad taddot sopuu‑oruwon apostoles. ");
INSERT INTO oboNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mid undiyon sikandin to mgo ponguu to tohodbuwis woy riyot mgo ponguu to tohodtamong to templo amoy od pomuhawang to kodboligya ki Disas diyot kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Oraroy ran no nahaa taddon puhawang woy id totandu ran nod boggoy to soopi riyot ki Judas. ");
INSERT INTO oboNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","De‑en id aman si Judas, woy id nangkap sikandin to ollog no timpu to kodboligya ki Disas no dii od pokosaddoo iddos mo‑uraan minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na, id inguma ron iddos unnon allow to pista to Paan no Waa Potuvu. Idda en no allow, ko‑ilangan nod buwis to natin karnero iddos mgo Judio atag to pista to Kodlihad to Ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","De‑en id pomonduwan ni Disas si Pedro woy si Juan. Kahi rin to, “Unna kowd bo woy panoy kow to lavung ta atag to pista to Kodlihad to Ponolihan.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mid intud sikandan to, “Longaggon, ingkon man kos id kopi‑i ru no id panoy roy idda?” ");
INSERT INTO oboNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kahin Disas to, “Otid inguma kow riyot bonuwa to Jerusalem, duwon mama nod kosinuggung dow no id tiyang to gunsu no duwon oweg. Tundug kow vo kandin diyot baoy nod undiyonnan din. ");
INSERT INTO oboNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Osengi row iddos komunoy taddot baoy no, ‘Id intud iddos Tohodnonaw ko ingkon kos kwartu no od kannan din to kodlavung atag to pista to Kodlihad to Ponolihan duma to mgo tinodduwan din.’ ");
INSERT INTO oboNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Na, id pokita rin koniyu iddos mowwag no kwartu riyot iko‑oruwon ondana no nopanoy ron tapoy iddos langun nod ko‑ilonganon ta. Ponaya row rutun iddos lavung ta.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Purisu id ipanow onsi Pedro, woy nokita ran iddos langun nid ikahi ni Disas kandan woy id panoy ran iddos lavung atag to pista to Kodlihad to Ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","To id inguma ron iddos uras to kodlavung, mid unsad si Disas duma taddot mgo apostoles amoy'd ka‑an. ");
INSERT INTO oboNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kahin Disas kandan to, “Id kopi‑i ku nod pokodduma ki nod lavung atag to pista to Kodlihad to Ponolihan to dii a pa od ukit to kodposuppit. ");
INSERT INTO oboNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Su od ikohiyan ku sikiyu, no dii ad od ka‑an ka‑ay'n koka‑an taman to od kotuman don iddos bonnaan kohulugan ka‑ay riyot timpu nod hari ron kos Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Na mid angoy sikandin to kupa woy id posolamat sikandin diyot Monama. Nopongnga, id ikohiyan din sikandan to, “Owata row ini woy inom kow langun ka‑ay. ");
INSERT INTO oboNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Oyyos od ikohiyan ku sikiyu, no dii ad od inom to ammis to ubas taman tod inguma ron iddos timpu no od hari ron kos Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Na, mid angoy sikandin to paan woy id posolamat sikandin diyot Monama. Nopongnga, id toppiktoppik din idda woy id toyyow riyot kandan, kahi rin to, “Ini en kos lawa ku no id buwis atag koniyu. Puungi row ini to kodsampot koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","To nokoka‑an don sikandan, mid angoy mandad sikandin to kupa woy kahi rin to, “Ini en kos patow to lammin kodpotonduwoy to Monama koniyu no od posivonnalan ukit to longossa ku nod tihis atag koniyu. ");
INSERT INTO oboNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Piru od ikohiyan ku sikiyu, no duma ta rad en ka‑ay no mid ka‑an iddos minuvu nod boligya koddi. ");
INSERT INTO oboNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Oyyos siyak no Anak to Minuvu, od patoy en iling taddot tapoy'n puhawang to Monama. Piru moka‑arat‑arat kod kotomanan taddot minuvu nod boligya koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","To norinog dan idda, id po‑inturoy ran ko ondoy kandan kos od puung to ungketen. ");
INSERT INTO oboNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na, id po‑opuloy iddos mgo tinodduwan ni Disas ko ondoy kandan kos od kilaannon no mowwet. ");
INSERT INTO oboNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","De‑en kahin Disas kandan to, “Ka‑ay to ampow't ingod, id pomohos taddot mgo hari iddos id kopi‑i ran nod puungan to mgo sakup dan, woy id kopi‑i ran mandad nod kilaannon no motavangtavang. ");
INSERT INTO oboNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Piru sikiyu, konna kow iling kandan. Su iddos od kilaannon no mowwet koniyu, ko‑ilangan nod poobbava woy dos ponguu, ko‑ilangan no iling to sudsuhuwon kos botasan din. ");
INSERT INTO oboNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Na, ondoy man kos od kilaannon no mowwet? Idda vo so id sondaran to koka‑an o iddos id sondad? Idda en so id sondaran. Piru siyak nod Longaggon dow, noko‑iling a to sudsuhuwon dow. ");
INSERT INTO oboNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Sikiyu en kos id duma koddi ahad diyot langun no kosupittan no no‑ukitan ku. ");
INSERT INTO oboNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na, su id boggayan a man to Amoy ku to kotungud nod hari, ungketen dad en mandad kos od puungan ku koniyu. ");
INSERT INTO oboNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Od pokoruma kow koddi nod ka‑an init kodhari ku, woy od po‑unsaron ku sikiyu riyot trunu amoy od hukum to sopuu‑oruwon tribu to koubbaran ni Israel.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Na kahin Disas ki Simon Pedro to, “Simon, bantoy ka. Id aman kos Monama ki Moivuyan no od geddaman kow. Dos kodgeddam din koniyu, noko‑iling to kodloyyak to ommoy amoy'd pod‑ossan iddos oppes woy tiparay, su saddook iling to oppes kos kopomakoy row. ");
INSERT INTO oboNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Piru id dasaa ad atag kikow amoy diid kotalu kos kopomakoy ru. Od inoyyug ka en koddi, piru kod livod ka, inniyatow kos mgo suwod du riyot kopomakoy.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mid tavak si Pedro to, “Longaggon, nopanoy a en nod duma kikow ahad pa riyot prisuwan woy riyot kopotayan.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Piru kahin Disas to, “Od ikohiyan ku sikkow, Pedro, no to dii pa od ukkaa kos manuk ko‑ungkay'n bulli, ko‑otollu rud tod elle no waa ka id kilaa koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na kahin Disas diyot mgo tinodduwan din to, “Iddot id suhu ku sikiyu amoy'd ponudtuu to kahit Monama no waa ku sikiyu popiyodda to soopi, kavii o sandalyas, ondan, nokulangan kow vo?” Mid tavak sikandan to, “Wora en.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kahin Disas to, “Piru ko‑ungkay, ko‑ilangan no od piyod kowd to kavii woy soopi. Iddos ahad ondoy no waa polihuma, ko‑ilangan no id boligya rin kos umpak din amoy'd pokovolli sikandin tadda. ");
INSERT INTO oboNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Oyyos ko‑ilangan en nod kotuman iddos no‑ikahi riyot Nosulat no Kahit Monama moka‑atag koddi no mid ungketen to, ‘Id polommung sikandin diyot mgo kriminal.’ Na, asow ron ini od kotuman.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kahi ran to, “Longaggon, ontongngiyu, duwon oruwon polihuma ka‑ay.” Kahin Disas to, “Ollog don.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na mid tanan si Disas pomon dutun, woy id undiyon sikandin to Buvungan to mgo Olibo, su idda me‑en kos nooyami rin nod puungan. Id duma kandin iddos mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","To id inguma ron sikandan dutun, mid ikahi sikandin to, “Dasaa kow amoy dii kow od kopiyod diyot kodpuung to saa.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na, id poriyu boyow sikandin woy rutun, mid lingko‑od sikandin amoy'd dasaa. ");
INSERT INTO oboNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kahi rin to, “Amoy ku, otid aman ka, yo ad po‑ukita tod ingumon koosayan. Piru konna inis id kopi‑i ku kos od kotuman, ko konna, idda rad en so kikow'n id kopi‑i.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na, duwon ponolihan pomon diyot datas to langit no mid porani amoy'd ponokkaa kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pomon to oraroy sikandin id lanu, id monit pe‑en kos koddasaa rin no golid taddu kos ating din diyot livuta iling to longossa. ");
INSERT INTO oboNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","To nopongnga sikandin mid dasaa, id livod sikandin diyot mgo tinodduwan din, woy nokita rin sikandan no nokotinuhon pomon tid moomet dan to mattag lanu. ");
INSERT INTO oboNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kahin Disas kandan to, “Mambot id tinuhon kow moho? Onnow kowd woy dasaa kow amoy dii kow od kopiyod diyot kodpuung to saa.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Laggun tod ooseng pa si Disas, id inguma iddos mo‑uraan minuvu. Iyon id ponguu kandan, si Judas no sokkad taddot sopuu‑oruwon tinodduwan din. Id porani sikandin ki Disas amoy'd pongumusta ukit to kod‑arok. ");
INSERT INTO oboNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Piru mid ikahi si Disas to, “Judas, ukit bos to kod‑arok kos kodboligya koddi no Anak to Minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","To nokita taddot mgo tinodduwan ni Disas no od omotton sikandin, mid ikahi sikandan to, “Longaggon, od ponibbason doyd bo sikandan?” ");
INSERT INTO oboNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na, id tibbas to sokkad taddot mgo tinodduwan din iddos uripon to mowwet no ponguu to mgo tohodbuwis, de-en no-utas kos kowanan no tolinga rin. ");
INSERT INTO oboNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Piru mid ikahi si Disas to, “Ollog don duwon!” Na, id somaddan ni Disas iddos tolinga taddon uripon woy idda ra en, no‑uliyan don sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iddos mid undiyon amoy'd ammot ki Disas, idda en so mgo ponguu to tohodbuwis, dos mgo ponguu to tohodtamong to templo woy dos duma pon od pombuyyahon to mgo Judio. Kahin Disas kandan to, “Kriminal a vo su goli kow'd piyod to mgo polihuma woy mgo badas to kod‑ammot koddi? ");
INSERT INTO oboNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Allow‑allow a man id nonaw riyot templo, piru waa a man nikiyu omotta. Piru ini ron en kos koniyun timpu woy timpu ni Moivuyan nod hari riyot mosukirom.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na, id ammot dan si Disas woy id piyod diyot baoy to mowwet no ponguu to mgo tohodbuwis. Si Pedro, id tintinundug no moriyu boyow. ");
INSERT INTO oboNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Diyot tongannan to lama, id totavun iddos mgo minuvu woy id ounsad amoy'd oinarang. Id porani mandad si Pedro amoy'd oinarang duma kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na rutun, duwon sokkad no ba‑ay no sudsuhuwon no nokokita ki Pedro no notorawwan to apuy. De‑en id totongtong sikandin woy mid ikahi to, “Inin minuvu, duma en sikandin duwot id ammot.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Piru mid elle si Pedro, kahi rin to, “Te, Idi, waa a moho nokokilaa kandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Waa nouhoy pomon tadda, duwon mandad sokkad no mama no nokokita ki Pedro woy mid ikahi to, “Ee, sikkow me‑en moho iddos sokkad taddot mgo duma rin.” Piru mid tavak si Pedro to, “Te, aawang ka ron od ooseng! Konna ku moho sikandin duma.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","To mgo sokkad don no uras kos id lihad, duwon don mandon mid ikahi to, “Bonnaa en no inin minuvu, duma en sikandin duwot na‑ammot, su toho Galilea man mandad sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piru mid tavak si Pedro to, “Te, waa ron en moho sinorollan ku ruwot id oseng du.” Laggun tod ooseng pa si Pedro, idda ron en, id ukkaa kos manuk. ");
INSERT INTO oboNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na, id loingoy dos od Longaggon woy id totongtong ki Pedro. Idda ron en, nosompottan din iddos id ikahi ni Disas no, “To dii pa od ukkaa kos manuk ko‑ungkay'n bulli, ko‑otollu rud tod elle no waa ka id kilaa koddi.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Id leggua si Pedro woy oray'n mopet kos sinoggawon din. ");
INSERT INTO oboNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na, id sumpalit si Disas woy id ponlompossan sikandin taddot mgo minuvu nid tamong kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Id sobpongngan dan kos mata rin, woy id ikohiyan to, “Otik mooggot ka no propeta, otukow ve‑en ko ondoy kos id tabpi kikow!” ");
INSERT INTO oboNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na, mo‑uraa pa kos id sumpalit dan kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","To od ka‑allow ron, id lolivuung iddos od pombuyyahon to mgo Judio. Dos duma kandan, mgo ponguu to tohodbuwis woy mgo tohodnonaw to Suhu ni Moises. Id angoy ran si Disas amoy id po‑isau kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kahi ran ki Disas to, “Ponudtuli koy, sikkow ve‑en kos Mesiyas?” Mid tavak si Disas to, “Ahad od ponudtulan ku sikiyu, dii kow man od pongimbonnaa. ");
INSERT INTO oboNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Woy otid boliyungan ku sikiyu tod intud, dii kow man od tavak. ");
INSERT INTO oboNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Piru pomon ko‑ungkay, siyak no Anak to Minuvu, od unsad diyon lomig to kowanan to Monamon Motuus.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Na langun dan, mid intud kandin, kahi rin to, “Ko ungketen, sikkow vo kos Anak to Monama?” Kahin Disas to, “No‑oseng dowd en.” ");
INSERT INTO oboNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","De‑en mid ikahi sikandan to, “Konnad ko‑ilangan nod angoy ki pa to duma amoy'd posivonnaa taddot saa rin, oyyos siketa ron en kos nokorinog taddot id oseng din.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nopongnga idda, mid lohinat iddos langun no minuvu no nolivuung dutun woy id piyod dan si Disas diyot ki Pilato no gubernador. ");
INSERT INTO oboNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Woy id uug dan kandin no nokopuung sikandin to saa, kahi ran to, “Inin minuvu, nokita roy no id sutsutan din iddos duma roy no mgo Judio nod supak to guberno. Su id diiyan din sikandan nod bayad to buhis diyot hari to Roma. Id ikahi rin pe‑en no sikandin kun iddos Mesiyas no hari.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","De‑en id inturan sikandin ni Pilato, kahi rin to, “Sikkow vo kos hari to mgo Judio?” Mid tavak si Disas to, “No‑oseng dud en.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na, id osengan ni Pilato iddos mgo ponguu to tohodbuwis woy dos mo‑uraan minuvu, kahi rin to, “Waa nokita ku no unayan nod silutan inin minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Piru ayas pe‑en sikandan id pehes no mid ungketen to, “Sikandin en kos unayan no no‑ukag kos mgo minuvu ka‑ay to intirut Judea pomon to mgo nonaw rin. Id tigkanoy sikandin nid nonaw riyot prubinsya to Galilea woy id so‑ob ka‑ay't Jerusalem.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Na, to norinog idda ni Pilato, mid intud sikandin ko toho Galilea vo si Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","To nosorollan ni Pilato no id pomon bos si Disas diyot Galilea, id popiyod din sikandin diyot ki Herodes su no‑iraom man idda to kodponguu rin, woy nokosasang mandad no riyon si Herodes to Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nahaahaa si Herodes to nokita rin si Disas, su nouhoy ron no id kopi‑i rin nod kokita sikandin. Mo‑uraa kos norinog din moka‑atag ki Disas woy id kopi‑i rin nod pokitannon sikandin to mokososoobbu. ");
INSERT INTO oboNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Na, id intud‑inturan ni Herodes si Disas, piru waa en sikandin mid tavak. ");
INSERT INTO oboNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Iddos mgo ponguu to tohodbuwis woy dos mgo tohodnonaw to Suhu ni Moises no id ponloohinat dutun, id oyassan dan pe‑en tid uug si Disas to mgo saa. ");
INSERT INTO oboNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Na, id sumpalit si Disas woy id po‑ilawan ni Herodes duma taddot mgo sundau rin. Id umpakan dan pe‑en sikandin to motoos no uvag kun to umpak to hari, woy id polivod din si Disas diyot ki Pilato. ");
INSERT INTO oboNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","To iddon allow, nokod‑oukuy ron si Herodes woy si Pilato, su nokodkuntra ran man iddot id lihad. ");
INSERT INTO oboNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na, id po‑umow ni Pilato iddos ponguu to mgo tohodbuwis, dos dumon mgo ponguu to Judio woy dos mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kahin Pilato kandan to, “Id piyod dow rinit koddi inin minuvu no id uug dow no sikandin kos unayan nod ko‑ukag iddos mgo minuvu to kodsupak to guberno. Piru to id intud‑intud a kandin diyot isowwan dow, waa en nokita ku no unayan nod silutan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ungketen dad en mandad ki Herodes, su id polivod din man inin minuvu rinit keta. Na, waa en nopuungan din no saa no ollog sikandin nod silutan to kopotayan. ");
INSERT INTO oboNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","De‑en od polompossan ku ra sikandin woy kopongnga, od polegguangon.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Id oseng din idda, su ipat pista to Kodlihad to Ponolihan, nooyami rin don nod poleggua to sokkad no pinirisu. ");
INSERT INTO oboNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Piru to norinog taddot mgo minuvu iddos id oseng ni Pilato, id pehes dan no mid ungketen to, “Imotayiu ikon minuvu! Si Barabas kos polegguangow!” ");
INSERT INTO oboNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ini si Barabas, id prisu, oyyos sokkad sikandin taddot id ponsupak to guberno riyot Jerusalem woy noko‑imatoy sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Id kopi‑i nanoy ni Pilato no si Disas kos od polegguangon din. De‑en id ovayan din poron tid oseng iddos mgo minuvu no waa saa ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Piru ayas pe‑en sikandan id pehes no mid ungketen to, “Id pakpak sikandin! Id pakpak sikandin diyon to krus!” ");
INSERT INTO oboNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Na riyot iko‑otollun timpu, mid ikahi si Pilato kandan to, “Mambo, ondan man kos saa no nopuungan din? Waa nokita ku no unayan nod silutan sikandin to kopotayan. De‑en od polompossan ku ra sikandin woy kopongnga, od polegguangon.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Piru ayas pe‑en id pehes iddos mgo minuvu no id pakpak sikandin diyon to krus. Na riyot mori, notalu si Pilato. ");
INSERT INTO oboNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","De‑en id aman dobbo sikandin taddot id kopi‑i ran. ");
INSERT INTO oboNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Iyon din id poleggua, iddos minuvu no id prisu pomon to kodsupak din to guberno woy kod‑imatoy. Piru si Disas, id boggoy ni Pilato riyot bollad to mgo sundau amoy'd kopuungan dan iddos id kopi‑i to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Laggun tod piyoddon dan si Disas diyot lugaa nod pokpakan kandin, nokosuggung dan to sokkad no minuvu nod ngoranan ki Simon no toho Cirene no id pomon diyot bariyu. Id pohos dan sikandin nod tiyang taddot krus, woy id potinundug dan sikandin ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Duwon mandad mo‑uraan minuvu no id tinundug ki Disas. Dos duma, mgo ba‑ay no ayas id sinoggow woy id pondaawit atag kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Piru id loingoy si Disas kandan no mid ungketen to, “Sikiyu no mgo ba‑ay to Jerusalem, yo kow'd sinoggow atag koddi. Iyon dow sinoggawi kos ko‑ugolingun dow woy mgo anak dow. ");
INSERT INTO oboNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Oyyos od inguma en kos timpu no od ikahi kos mgo minuvu to, ‘Moppiya kod kotomanan taddot mgo ba‑ay no diid poko‑anak woy waad posusuwon.’ ");
INSERT INTO oboNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Woy to iddon timpu, od ikahi sikandan diyot mgo buvungan to, ‘Kounow kowd ka‑ay't konami,’ woy od ikahi ran pe‑en diyot mgo buvungan to, ‘Tombuni koyd!’ ");
INSERT INTO oboNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Su otik nopuungan dan man ini rinit koddi no waa saa, iyon pobbo riyot mgo minuvu no mosaasaa.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na, duwon oruwon kriminal no id piyod dan amoy'd silutan to kopotayan duma ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","To id inguma ron sikandan diyot lugaa nod ngoranan no Bongovongo, id pakpak taddot mgo sundau si Disas diyon to krus, woy idda mandad so oruwon kriminal. Dos sokkad, diyon lomig to kowanan ni Disas woy dos sokkad, diyon lomig to ivang. ");
INSERT INTO oboNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na id dasaa si Disas, kahi rin to, “Amoy ku, posinsya‑iyu sikandan, oyyos waa saddoo ran ko ondan kos id puungan dan.” Na iddos mgo sundau, id bunutbunut dan atag taddot ogget ni Disas ko ondan kos od kokomunoy to ipat sokkad kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Laggun tod loohinat dutun iddos mgo minuvu nod totongtong, id sumpalit kandin iddos mgo ponguu to Judio. Kahi ran to, “Id tovangan din kos duma, na od ontongngan ta ve‑en kod pokotavang sikandin to ko‑ugolingun din. Woy od kosorollan ta ko mooggot en no sikandin kos Mesiyas.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Id sumpalit mandad sikandin taddot mgo sundau. Id porani ran kandin woy id bullow ran iddos suka amoy id po‑inom kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kahi ran to, “Otik sikkow en kos hari to mgo Judio, tovangiyu kos ko‑ugolingun du.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Id oseng dan idda, su duwon man korotula no riyon lomig to datas to uu ni Disas no mid ungketen to, “Ini en kos Hari to mgo Judio.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ahad pe‑en iddos sokkad no id pakpak don diyot duug ni Disas, id sumpalit mandad kandin. Kahi rin to, “Otik mooggot en no sikkow kos Mesiyas, tovangiyu kos ko‑ugolingun du woy sikami mandad.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Piru id sugga sikandin taddot duma rin no kriminal, kahi rin to, “Waa ka vo novaakki to Monama? Id silutan ki to nokod‑iling no silut. ");
INSERT INTO oboNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Piru siketa no oruwa, ollog en nod silutan to iling ka‑ay, su nokopuung ki man to morat. Piru sikandin, id silutan no waa saa.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na kahi rin to, “Disas, yo a vo nikkow lingawi otid hari kad.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mid tavak si Disas to, “Bonnaavonnaa nod ikohiyon ku kikow, no inin allow, od koruma kud sikkow riyot langit.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Na, to moko‑untud don kos allow, tigkow id mosukirom kos intirut ingod daom to otollun uras. ");
INSERT INTO oboNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Idda ron en, novendas iddos oray'n mokoppaan kurtina riyot templo. ");
INSERT INTO oboNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Na id pehes si Disas to monokkaa no mid ungketen to, “Amoy ku, id salig kud diyot bollad du inis koddin ispiritu.” Nopongnga rin osenga idda, novudtus don kos songnga rin. ");
INSERT INTO oboNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","To nokita taddot kopitan to mgo sundau iddon notomanan, id doong din kos Monama, kahi rin to, “Mooggot bos en no waa saa ka‑ay'n minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Iddos langun nid totongtong taddon notomanan, id pon‑uli sikandan no immat id kommos kos pusung dan pomon to lampas no lanu. ");
INSERT INTO oboNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Piru iddos langun no oukuy ni Disas, ahad iddos mgo ba‑ay nid duma kandin pomon poron diyot Galilea, id ponloohinat dan diyot moriyu boyow woy nokita ran en mandad iddos langun no notomanan. ");
INSERT INTO oboNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Na, duwon minuvu no id ngoranan ki Jose no toho Arimatea no sakup to Judea. Moppiya sikandin woy motallong no minuvu. Id aangat sikandin to timpu to kodharit Monama. Ahad sakup sikandin to mowwet no hukumanan to mgo Judio, waa sikandin mid aman taddot puhawang to kod‑imatoy ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Id undiyon sikandin to ki Pilato woy id buyu rin nod ongayon dos bangkoy ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","De‑en id angoy onni Jose iddos bangkoy ni Disas pomon diyon to krus. Id bukusan din idda to mahaa no ogget, woy id ta‑aw rin idda riyot lovongngan no waa poron ta‑aw. Iddon lovongngan, id bongbangan no pahang iling to langub. ");
INSERT INTO oboNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","To kodpuung dan tadda, od kosagkup don to Bernis no idda en kos kodpanoy to mgo Judio atag to Allow't Kod‑imolloy. ");
INSERT INTO oboNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Iddos mgo ba‑ay no id duma ki Disas pomon diyot Galilea, id tinundug ki Jose woy nokita ran ko ingkon iddos id lovongngan ki Disas woy ko momonnu id ta‑aw iddos bangkoy rin. ");
INSERT INTO oboNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Na, id uli ron sikandan woy id panoy to mgo pomammut no id bukbuk woy id daddas dan taddot bangkoy ni Disas. Nopongnga idda, id tigkanoy ron iddos Allow't Kod‑imolloy woy id oimolloy pa sikandan, su idda me‑en kos suhu atag to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na sollom poron oraroy to allow't Linggu, mid undiyon to lovongngan iddos mgo ba‑ay no id pompiyod tid panoy ran no mgo pomammut. ");
INSERT INTO oboNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","To kod‑inguma ran dutun, nokita ran no noko‑ibpit don iddos batu no id lokkob taddot lovongngan. ");
INSERT INTO oboNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Na id usok dan diyot daom, piru waa ran nokita rutun iddos bangkoy ni Disas nod Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Laggun to notaong dan poron taddot notomanan, tigkow duwon oruwon mama no mid lohinat diyot morani ran. Dos umpak dan, golid se‑aa to koputiyoy. ");
INSERT INTO oboNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pomon to lampas no allak dan, id ounduk sikandan no noko‑uma kos bonnong dan diyot livuta. Piru id ikohiyan sikandan taddot oruwon mama to, “Mambot od nangkap kow to ma‑antoy ka‑ay't lugaa tid poomatoy? ");
INSERT INTO oboNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Worad ka‑ay si Disas, su id badnow ron. Nolingow kowd bo taddot id oseng din koniyu to riyon pa sikandin to Galilea no, ");
INSERT INTO oboNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","sikandin no Anak to Minuvu, ko‑ilangan no id boggoy pa riyot bollad to mgo mosaasaa woy od imotayan sikandin ukit to kodpakpak diyon to krus. Piru od kovadnow en sikandin diyot iko‑otollun allow.” ");
INSERT INTO oboNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na, to norinog dan idda, nosompottan taddot mgo ba‑ay iddos id oseng ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Id uli sikandan woy id ponudtuu ran idda riyot sopuu‑sokkad no tinodduwan din woy riyot mgo duma ran. ");
INSERT INTO oboNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Iddos ngaran taddon mgo ba‑ay, si Maria no toho Magdala, si Juana woy si Maria no inoy ni Santiago. Sikandan woy dos duma pon mgo ba‑ay kos id ponudtuu riyot mgo apostoles moka‑atag taddon notomanan. ");
INSERT INTO oboNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Piru kunan taddot mgo apostoles ko waa koru‑anon tat ponudtulon dan, de‑en waa ran id pongimbonnaa. ");
INSERT INTO oboNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piru si Pedro, id lungkossu po‑undiyon to lovongngan. To kod‑inguma rin dutun, id lungaung sikandin woy iyon dobbo nokita rin, iddos ogget nid bodbod taddot bangkoy ni Disas. Na, id uli sikandin no nosoobbuwan taddon notomanan. ");
INSERT INTO oboNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","To idda ra en no allow, mid undiyot bariyu to Emaus iddos oruwon tinodduwan ni Disas. Dos koriyuwoy to Emaus pomon diyot Jerusalem, mgo sopuu‑sokkad no kilometro. ");
INSERT INTO oboNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","To riyon pa sikandan to daan, iyon dan tongkoanan, iddos moka‑atag taddot langun no notomanan. ");
INSERT INTO oboNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Laggun tid potongkooy ran, id porani si Disas woy id duma kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Na nokita ran sikandin, piru iling to id soungan kos mata ran amoy dii ran od pokokilaa kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kahin Disas kandan to, “Ondan man kos tongkoanan dow?” Id soro ran sinahaw woy'd kokita riyot bonnong dan no id lanu ran. ");
INSERT INTO oboNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na iddos sokkad kandan no id ngoranan ki Cleopas, id tavak kandin no mid ungketen to, “Sikkow ra vos en ayu kos minuvu ka‑ay't Jerusalem no waa saddoo taddot nopilan pa no notomanan.” ");
INSERT INTO oboNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mid intud si Disas kandan, kahi rin to, “Mambo, ondan man bos kos notomanan?” Kahi ran to, “Iddos notomanan ki Disas no toho Nazaret. Motuus sikandin no propeta riyot kod‑ontong to Monama woy riyot kod‑ontong to mgo minuvu ukit to nonaw rin woy ukit to kodpuung din to mokososoobbu. ");
INSERT INTO oboNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Dos mgo ponguu to tohodbuwis woy dos duma pon mgo ponguu, id boggoy kandin diyot bollad to gubernador woy id silut kandin to kopotayan ukit to kodpakpak diyon to krus. ");
INSERT INTO oboNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sikandin en nanoy kos ko‑immanan doy nod tobbus to koubbaran ni Israel. Piru ko‑ungkay, iko‑otollu ron no allow pomon taddot kod‑imatoy kandin. ");
INSERT INTO oboNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Iyon doy pe‑en nosoobbu‑i, iddos duma roy no mgo ba‑ay no id undiyon gena to lovongngan to sollom poron. ");
INSERT INTO oboNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Id poolivod dan nid ponudtuu konami no worad kun dutun iddos bangkoy ni Disas. Id ikahi pe‑en sikandan no duwon kun oruwon ponolihan nid pokita kandan no id ponudtuu no no‑uyag don kun si Disas. ");
INSERT INTO oboNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","To norinog doy idda, duwon mandad duma roy nid undiyon, woy nokita ran no mooggot en iddos ponudtulon taddot mgo ba‑ay.” ");
INSERT INTO oboNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na kahin Disas kandan to, “Ooy koniyu! Mambot motoggas kow moho nod pomakoy taddot id ponudtuu to mgo propeta? ");
INSERT INTO oboNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Id sulat dan no iddos Mesiyas, ko‑ilangan nod ukit pa to mgo kodposuppit, idda pa od posivontuhan sikandin to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na, id paabbotlabbot ni Disas diyot kandan iddos langun moka‑atag kandin diyot Nosulat no Kahit Monama. Id tigkanoy sikandin diyot id ponsulat ni Moises woy riyot langun no nosulat to mgo propeta. ");
INSERT INTO oboNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","To id inguma ron sikandan diyot bariyu nod undiyonnan dan, id ponayun si Disas no uvag kun tod ipanow ron sikandin. ");
INSERT INTO oboNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Piru id owiran dan en sikandin, kahi ran to, “Owwot kad ka‑ay duma konami, su od kosagkup don man ini.” De‑en id usok don si Disas diyon to baoy duma kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","To id unsad don sikandan nod ka‑an, id purut sikandin to paan woy id posolomatan din idda riyot Monama. Nopongnga, id toppiktoppik din idda woy id toyyow riyot kandan. ");
INSERT INTO oboNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Idda ron en, nopokes kos poomdom dan woy nokilaa ran don no si Disas bos idda. Piru tigkow ron sikandin no nowora. ");
INSERT INTO oboNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Na id po‑ikohiyoy ran to, “Kuu! Udtovos monit kos ginawa ta no iling to duwon apuy laggun to id paabbotlabbot din gena iddos Nosulat no Kahit Monama to riyon ki pa to daan.” ");
INSERT INTO oboNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","To idda ra en no timpu, id ipanow sikandan su od poolivod diyot Jerusalem. Dutun, no‑ingumannan dan iddos sopuu‑sokkad no tinodduwan woy dos duma pa nid lolivuung. ");
INSERT INTO oboNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na, sikandan don en kos unna nid ponudtuu riyot oruwa no lammid inguma, kahi ran to, “Mooggot en no novadnow ron iddos od Longaggon, su id pokita man sikandin ki Pedro!” ");
INSERT INTO oboNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Id ponudtuu mandad taddot oruwa iddos notomanan to riyon pa sikandan to daan po‑undiyot Emaus, woy ko momonnu ran nokilaa si Disas iddot kodtoppiktoppik din to paan. ");
INSERT INTO oboNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Laggun tod oituu pa sikandan moka‑atag taddon notomanan, tigkow id pokita si Disas kandan no mid lohinat diyot tongannan dan woy kahi rin to, “Iddos kosunayan, inaayun duwon to koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Notigkawan sikandan woy novaakkan, su kunan dan ko gimukud iddos nokita ran. ");
INSERT INTO oboNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Piru mid ikahi si Disas to, “Mambot novaakkan kow woy mambot id duworuwa no siyak ini? ");
INSERT INTO oboNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ontongngi row man inis bollad woy pa‑a ku. Somaddi a nikiyu amoy'd pongimbonnaa kow no konna a gimukud. Su iddos gimukud, waa lawa, piru siyak, nokita row no duwon lawa ku.” ");
INSERT INTO oboNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nopongnga rin osenga idda, id pokita rin kandan iddos bollad woy pa‑a rin. ");
INSERT INTO oboNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Oray sikandan no nahaa woy nosoobbuwan taddot nokita ran. Piru dii ran pe‑en od pokopongimbonnaa ko si Disas en idda. Na id inturan din sikandan to, “Duwon koka‑an dow ruwon?” ");
INSERT INTO oboNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Na, id boggayan dan sikandin to songo‑molison no tinuwog no ngaap. ");
INSERT INTO oboNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Id tanggap din idda woy id ka‑an din diyot isowwan dan. ");
INSERT INTO oboNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kahi rin kandan to, “Ini en kos id oseng ku koniyu iddot nokodduma ki pa, no ko‑ilangan en nod kotuman iddos langun no nosulat moka‑atag koddi riyon to mgo Suhu ni Moises, riyot id sulat to mgo propeta woy riyot mgo Salmo.” ");
INSERT INTO oboNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Na, id poma‑awang ni Disas kos mgo poomdom dan amoy od koovottan dan iddos Nosulat no Kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kahin rin to, “No‑ikahi riyot Nosulat no Kahit Monama, no iddos Mesiyas, ko‑ilangan nod ti‑is to kodposuppit taman to kopotayan, piru od kovadnow sikandin diyot iko‑otollun allow. ");
INSERT INTO oboNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nosulat mandad dutun no, ko‑ilangan no id ponudtuu no ukit da en kandin, od posinsyan to Monama iddos langun no minuvu nod sondit woy'd tanan to mgo saa ran. Ko‑ilangan no unna idda id ponudtuu ka‑ay't Jerusalem woy id poso‑ob diyot langun no mgo tribu ka‑ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pomon to sikiyu me‑en kos nokokita taddot langun no notomanan ku, sikiyu en kos od posivonnaa moka‑atag ka‑ay. ");
INSERT INTO oboNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Id popiyod ku ka‑ay't koniyu iddos Uhis no Ispiritu no id tandu to Amoy ku, piru ko‑ilangan nod aangat kow ka‑ay't Jerusalem taman tod ko‑iroomman kow to kotuusan din no id pomon diyot datas to langit.” ");
INSERT INTO oboNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nopongnga idda, id poruma ran ni Disas diyot bariyu to Betania. To id inguma ron sikandan dutun, id poratas din kos bollad din woy id dasaa sikandin amoy'd kotanggap dan kos kopiyannoy to Monama. ");
INSERT INTO oboNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Laggun tid puungan din idda, enot‑enot don sikandin od kovatun sikandin diyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na, id simba ran kandin woy id livod sikandan diyot Jerusalem duma to dakkoon kahaan. ");
INSERT INTO oboNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ipat allow, od undiyon sikandan to templo woy id posivontuhan dan kos Monama.");
INSERT INTO oboNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Diyot tigkonayan to waa pa novovalli kos langun, duwon don tapoy iddos od ngoranan no Kahi. Na inin Kahi, duma to Monama woy inin Kahi, Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pomon poron to tigkonayan, iddos Kahi, duma ron to Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ukit kandin, novovallan iddos langun woy waa en ahad ondan no binovallan no konna ukit kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na inin Kahi, sikandin kos id pomonnan to umuu woy inin umuu, od pokoma‑awang to poomdom to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Sikandin mandad kos od pokoma‑awang to mosukirom woy dos mosukirom, dii en od pokotalu tadda. ");
INSERT INTO oboNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na, duwon minuvu nid popiyod to Monama no id ngoranan ki Juan. ");
INSERT INTO oboNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Id popiyod sikandin to Monama nod posivonnaa moka‑atag taddot ko‑owangan amoy od pomakoy kos langun no minuvu ukit kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Konna si Juan iddos ko‑owangan, ko konna, mid undini sikandin amoy'd posivonnaa moka‑atag taddot ko‑owangan. ");
INSERT INTO oboNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iddos bonnaan ko‑owangan, mid undini to ampow't ingod amoy od poma‑awang to poomdom to langun no minuvu. ");
INSERT INTO oboNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Na ahad ka‑ay ron sikandin to ingod woy novovallan kos langun ukit kandin, waa sikandin kilaanna to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Woy mid undiyon sikandin to kandin don en no ingod, piru waa sikandin tonggapa taddot iling din no mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Piru iddos ahad ondoy nid tanggap woy id pomakoy kandin, id boggayan din to kotungud nod kovovallan no mgo anak to Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Novovallan sikandan no mgo anak to Monama, konna ukit to kodlubbad to minuvu woy konna pomon to puhawang woy id kopi‑it minuvu, ko konna, pomon da en to kopi‑it Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na iddon Kahi, nominuvu woy mid ubpa duma keta. Noponnu sikandin to eru woy kovonnaan. Nokita roy dos kopiyannoy woy kotuusan taddot soosokkad no Anak no id pomon to Monamon Amoy. ");
INSERT INTO oboNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Sikandin kos id posivonnaa ni Juan nid pehes no mid ungketen to, “Sikandin en iddos id ikahi ku no duwon od tundug koddi no lampas pa koddi, oyya su iddot waa a pa nominuvu, duwon don tapoy sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pomon to lampas no eru ni Disas Krays, notanggap ta iddos diid kotampod no kopiyannan. ");
INSERT INTO oboNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dangan ukit ki Moises, id boggoy to Monama iddos mgo Suhu riyot mgo minuvu. Piru ko‑ungkay, ukit ki Disas Krays, notanggap ta iddos eru to Monama woy od koovottan ta iddos kovonnaan moka‑atag kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Waa poron ahad sokkad no minuvu no nokokita to Monama. Piru id pokilaa sikandin ka‑ay't keta taddot soosokkad no Monamon Anak no id dokollan to ginawa taddot Monamon Amoy. ");
INSERT INTO oboNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na, ini en kos kodposivonnaa ni Juan no Tohodboutismu. Duwon mgo tohodbuwis woy duma ran no mgo Levita no id undiyon to ki Juan. Id suhu sikandan taddot mgo ponguu to Judio riyot Jerusalem amoy od intud ko sikandin en kos Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","To norinog idda ni Juan, waa rin id ollos kos kovonnaan, ko konna, id ponudtuu rin en no konna sikandin kos Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Na mid intud sikandan, kahi ran to, “Otik konna sikkow kos Mesiyas, ondoy ka man bos? Sikkow vo si Elias no propeta?” Mid tavak si Juan to, “Konna a mandad si Elias.” Id intud mandon sikandan to, “Sikkow vo iddos Propeta no id oongatan doy?” Mid tavak si Juan to, “Konna.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kahi ran to, “Ko ungketen, ponudtuli koy ko ondoy ka, su amoy duwon mandad id pokoponudtuu roy taddot id ponsuhu konami. Ondan kos od ko‑oseng du moka‑atag to ko‑ugolingun du?” ");
INSERT INTO oboNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Id tavak si Juan to, “Diyot koddi, notuman iddos id ikahi dangan ni propeta Isaias no, ‘Duwon monokkaan bawos diyot noka‑awoy‑awoy'n lugaa no mid ungketen to, Ponaya row kos pusung dow atag tod Longaggon woy tulidda row kos od ukitan din!’ ” ");
INSERT INTO oboNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na, duwon mandad dumon mgo Pariseo no id ponsuhu riyot ki Juan. ");
INSERT INTO oboNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Woy id inturan dan si Juan, kahi ran to, “Otik konna sikkow kos Mesiyas woy konna ka mandad si Elias woy konna sikkow iddos Propeta no id oongatan doy, na ondak kotungud du nod boutismu?” ");
INSERT INTO oboNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mid tavak si Juan to, “Id boutismu a to mgo minuvu ukit to oweg, piru duwon sokkad no pomon diyot koniyu no waa row pa nokilaa. ");
INSERT INTO oboNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Sikandin kos od tundug koddi woy pomon to lampas pa sikandin no motuus, konna a ollog ahad kod‑akas da to sandalyas din.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na ini langun, nopuungan diyot bonuwa to Betania no riyot dipaa to Oweg to Jordan no riyon en id bovoutismu si Juan. ");
INSERT INTO oboNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","So‑op no allow, nokita ni Juan si Disas no od po‑isau riyot kandin. Kahin Juan diyot mgo minuvu to, “Ini ron kos natin Karnero no id popiyod to Monama amoy id buwis atag to kod‑awa to saa to langun no minuvu. ");
INSERT INTO oboNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sikandin en iddos id ikahi ku koniyu nod pokotundug koddi no lampas pa koddi, su iddot waa a pa nominuvu, duwon don tapoy sikandin. ");
INSERT INTO oboNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Diyot unna, ahad siyak, waa a nokosaddoo ko ondoy sikandin. Piru mid undini a nid boutismu ukit to oweg, su amoy id pokilaa sikandin diyon to langun no koubbaran ni Israel. ");
INSERT INTO oboNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","“Waa a nokosaddoo ko ondoy sikandin, piru iddos Monama nid suhu koddi to kodboutismu to oweg, mid ikahi to, ‘Iddos od kokita ru nod lonnan to Uhis no Ispiritu woy od ubpa idda riyot kandin, sikandin en kos od boutismu to Uhis no Ispiritu.’ Na, nokita ku en iddon Ispiritu to Monama no iling to soopati nid pomon diyot datas to langit no mid lonna woy id ubpa riyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","De‑en od pokoposivonnaa a koniyu no sikandin kos Anak to Monama, su nokita ku en ini riyot kandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","So‑op no allow, diyon dad mandon onsi Juan duma to oruwa taddot mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","To nokita rin si Disas nid lihad, mid ikahi sikandin to, “Ini ron kos natin Karnero no id popiyod to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","To norinog idda taddot oruwon tinodduwan ni Juan, idda ron en, mid tinundug don sikandan ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Na, to kodloingoy ni Disas, nokita rin no id tinundug sikandan. De‑en id inturan din sikandan to, “Ondan kos dontulon dow?” Kahi ran to, “Rabbi” (dos kohulugan ka‑ay, Tohodnonaw), “ingkon ka man id oubpa?” ");
INSERT INTO oboNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Mid tavak si Disas to, “Duma kow koddi amoy'd kokita row.” Idda ron en, id duma sikandan woy nokita ran iddos id oubpan din. (Iddon timpu, alas kwatro ron to mapun.) Na, id ubpa pa sikandan duma ki Disas to iddon allow taman to sollom. ");
INSERT INTO oboNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na si Andres no ari ni Simon Pedro, sokkad sikandin taddot oruwa no nokorinog to id ikahi ni Juan woy taddot id duma ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Iyon id puungan ni Andres, id unna rin tid nangkap iddos kakoy rin no si Simon woy id ponudtulan din, kahi rin to, “Nokita royd iddos Mesiyas” (no idda en kos id aam to Monama amoy'd harit langun). ");
INSERT INTO oboNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Na, id dumannan ni Andres si Simon nod undiyon to ki Disas. To kod‑inguma ran dutun, id tongtongngan ni Disas si Simon woy id ikohiyan to, “Sikkow si Simon no anak ni Juan, piru pomon ko‑ungkay, Cefas don kos id ngaran kikow.” (Diyot Hebreo no kinohiyan, inis ngaran no Cefas, nokod‑iling da en to ngaran no Pedro riyot Griego.) ");
INSERT INTO oboNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","So‑op no allow, nopuhawang ni Disas nod undiyon to prubinsya to Galilea. To kod‑inguma rin dutun, id nangkap din si Felipe woy to nokita rin don, id ikohiyan din sikandin to, “Duma ka koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ini si Felipe, toho Betsaida no idda en mandad kos bonuwa no id pomonnan onni Andres woy Pedro. ");
INSERT INTO oboNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na, id nangkap ni Felipe si Natanael woy to nokita rin don, id ikohiyan din sikandin to, “Nokita royd iddos minuvu no nosulat diyot mgo Suhu ni Moises woy riyot id ponsulat taddot mgo propeta. Sikandin bos en si Disas no toho Nazaret woy dos amoy rin, si Jose.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Kahin Natanael to, “Te, duwon bo moppiya pomon diyon to Nazaret?” Piru mid tavak si Felipe kandin to, “Duma ka me‑en koddi amoy'd kokita ru.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","To id inguma ron onsi Felipe, id ikohiyan ni Disas si Natanael to, “Ini en kos mooggot no lubbad ni Israel woy dii sikandin od ouhus.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Na mid intud si Natanael kandin, kahi rin to, “Id monnu ru man no nokilaa a moho nikkow?” Mid tavak si Disas to, “To waa ka pa nongkapa ni Felipe, nokita kud tapoy sikkow riyot lobbut to kayu no igera.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kahin Natanael to, “Tohodnonaw, sikkow en kos Anak to Monama! Sikkow en kos hari roy no koubbaran ni Israel.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kahin Disas kandin to, “Mambo, id pomakoy ka ra vo koddi pomon to id oseng a no nokita ku sikkow riyot lobbut to kayu no igera? Duwon lampas pa no mokososoobbu nod kokita ru.” ");
INSERT INTO oboNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na ponayun mid ikahi si Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no od inguma en kos timpu nod kokita row kos langit nod kopokesan, woy od kokita row mandad iddos mgo ponolihan to Monama no od poundatas woy'd porosiyung ka‑ay't koddi no Anak to Minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Na oruwon allow pomon tadda, duwon kosaa riyot bonuwa to Cana no sakup to Galilea. Diyon en iddos inoy ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Diyon en mandad si Disas woy dos mgo tinodduwan din, su id inggat man sikandan taddot od kosalon. ");
INSERT INTO oboNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","To no‑ominan don sikandan to binu, id osengan si Disas taddot inoy rin, kahi rin to, “Worad man moho binu ran.” ");
INSERT INTO oboNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kahin Disas to, “Ina, yo kad od kosasow su siyak kos nokosaddoo tadda. Oyyos konna pa ollog timpu no id pokita ku kos koddin kotuusan.” ");
INSERT INTO oboNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Na id osengan to inoy rin iddos mgo tohodsondad to binu, kahi rin to, “Puungi row kos ahad ondan no id suhu rin koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Dutun, duwon annom no doorakkoon banga no id panoy atag to botasanon to mgo Judio moka‑atag to kod‑ounab, su idda me‑en kos pomokayon dan. Dos ipat sokkad taddon banga, od kotawwan to mgo sokkad no gatus no litrun oweg. ");
INSERT INTO oboNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Na id osengan ni Disas iddos mgo tohodsondad to binu, kahi rin to, “Iponnuwa row to oweg ikos mgo banga.” De‑en id puungan dan idda. ");
INSERT INTO oboNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nopongnga, mid ikahi si Disas to, “Sahuk kow woy piyodda row riyot ponguu to kodpoka‑an to kosalan.” De‑en id puungan dan idda woy id piyod dan diyot ponguu. ");
INSERT INTO oboNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Na, id geddaman din iddos oweg no novauy ron no binu. (Piru nokosaddoo rad iddos mgo tohodsondad to binu.) Na, id umow taddot ponguu to kodpoka‑an to kosalan iddos od osawa. ");
INSERT INTO oboNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Woy id ikohiyan din to, “Nooyami to ko‑urallan no minuvu no unna id sondad iddos monanam no binu. Woy otik dakkoo ron kos no‑inom to mgo minuvu, idda pa id poleggua iddos konna oraroy monanam no binu. Piru ossa kos po‑ukit du, su mori ru moho id poleggua inis binu no oray'n monanam.” ");
INSERT INTO oboNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Na, ini en kos unna taddot mgo mokososoobbun pinuungan ni Disas. Id puungan din ini riyot Cana no sakup to Galilea. Ukit ka‑ay, id pokita rin iddos lampas no kotuusan din. De‑en iddos mgo tinodduwan din, id mosalig pe‑en kos kopomakoy ran kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","To nopongnga ron iddos kosaa, mid undiyon si Disas to bonuwa to Capernaum duma to inoy rin, mgo suwod din woy dos mgo tinodduwan din. Dutun, id tahad pa sikandan id oubpa daom to pilon mgo allow. ");
INSERT INTO oboNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na, asow ron od inguma iddos pista to mgo Judio nod ngoranan no pista to Kodlihad to Ponolihan, de‑en mid undiyon si Disas to Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Diyot lama to templo, nokita rin no duwon od pombovoligya to mgo baka, mgo karnero woy mgo soopati. Woy duwon mandad mgo minuvu rutun nid ounsad amoy od bovullas to soopi. ");
INSERT INTO oboNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","De‑en id bovaa si Disas to latigu woy id pombuggow rin iddos langun, ahad iddos mgo karnero woy dos mgo baka pomon diyon to templo. Id ponsovuwak din mandad dos mgo soopi taddot od pombovullas woy id ponlingkuwab din kos mgo lomisa ran. ");
INSERT INTO oboNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Id osengan din iddos id pombovoligya to mgo soopati, kahi rin to, “Ongaya row ruwon ika! Yo row bovalli no polingki inis baoy't Amoy ku!” ");
INSERT INTO oboNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na pomon taddot id puungan din, nosompottan taddot mgo tinodduwan din iddos nosulat diyot Kahit Monama no mid ungketen to, “Iddos komonitoy to kodginawa ku to kikow'n baoy, idda en kos od pokopatoy koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iddon timpu, mid intud kandin iddos mgo ponguu to Judio, kahi ran to, “Ondan kos mokososoobbu no id pokopokita ru amoy'd posivonnaa no duwon en kotungud du nod puung to iling ka‑ay?” ");
INSERT INTO oboNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mid tavak si Disas to, “Gobba‑a row inis templo woy daom to otollun allow, od poohinaton ku mandon.” ");
INSERT INTO oboNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kahi ran to, “Te! Oppat‑no‑puu annom no lahun kos kodbovaa ka‑ay'n templo, woy od poohinaton du ra moho daom to otollun allow?” ");
INSERT INTO oboNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Piru waa ran nokaabbot no iddos od tommanon din no templo, idda en so kandin no lawa. ");
INSERT INTO oboNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ahad iddos mgo tinodduwan din, waa sikandan nokaabbot. Gali ran nokaabbot, iddot timpu no novadnow ron si Disas, su nosompottan dan no id oseng din en ini. Woy id pomakoy ron sikandan taddot Nosulat no Kahit Monama woy taddot id oseng ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Laggun to riyon pa si Disas to Jerusalem iddot timpu to pista to Kodlihad to Ponolihan, mo‑uraa kos mid pomakoy kandin pomon taddot nokita ran no mokososoobbun pinuungan din. ");
INSERT INTO oboNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Piru waa novonnali si Disas taddot kopomakoy ran, su nosorollan din kos kodbovotasan to minuvu ka‑ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Konnad ko‑ilangan nod ponudtulan pa sikandin, oyyos nosorollan din ko ondan kos diyot ginawa ran. ");
INSERT INTO oboNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na, duwon sokkad no minuvu no id ngoranan ki Nicodemo. Sokkad sikandin taddot od pombuyyahon to mgo Judio woy sakup mandad sikandin to mgo Pariseo. ");
INSERT INTO oboNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sokkad no bulli, id undiyon sikandin to ki Disas woy mid ikahi sikandin to, “Tohodnonaw, nosorollan doy no sikkow en kos id popiyod to Monama amoy'd nonaw konami. Oyyos waa en minuvu nod pokopuung to mgo mokososoobbu iling to od puungan du, otik waa id duma kandin iddos Monama.” ");
INSERT INTO oboNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kahin Disas kandin to, “Bonnaavonnaa nod ikohiyon ku kikow, no waa ahad sokkad nod kolonug diyon to kodharit Monama otik konna sikandin od kominuvu mandon.” ");
INSERT INTO oboNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Na mid intud si Nicodemo, kahi rin to, “Momonnu nod tobbow pa mandon kos minuvu, otik buyyag don sikandin? Konna ron en sikandin od pokolivod diyot gottok to inoy rin amoy'd kominuvu mandon.” ");
INSERT INTO oboNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mid tavak si Disas to, “Bonnaavonnaa nod ikohiyon ku kikow, no waa en minuvu nod kolonug diyon to kodharit Monama, otik konna sikandin od kominuvu mandon ukit to oweg woy Ispiritu to Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Dos na‑anak ukit to minuvu, minuvu rad sikandin, piru iddos na‑anak ukit to Ispiritu to Monama, duwon don lammin umuu rin pomon to Ispiritu no riyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","De‑en yo kod kosoobbu‑i taddot id ikahi ku, no ko‑ilangan od kominuvu kow mandon. ");
INSERT INTO oboNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Od poko‑iling ini to kaamag nod irup diyot ahad ingkon no id kopi‑i rin. Od korinog dow kos dohingon din, piru dii row od kosorollan ko ingkon ini id pomon woy ingkon od po‑isau. Na, iling en mandad ka‑ay kos nominuvu mandon ukit to Ispiritu to Monama, oyyos konna ta od kokita iddos Ispiritu, piru iyon ta ra od kokita, iddos lammin kodbovotasan din.” ");
INSERT INTO oboNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kahin Nicodemo to, “Yo ka pa man. Momonnu nod kopuungan ini?” ");
INSERT INTO oboNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Mid tavak si Disas to, “Te! Novantug ka man no tohodnonaw ka‑ay't Israel, piru waa ka poron bos nokaabbot ka‑ay? ");
INSERT INTO oboNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Bonnaavonnaa nod ikohiyon ku kikow, no iddos nosorollan woy nokita roy, idda en kos id ponudtuu roy koniyu. Piru dii kow pe‑en moho od pomakoy taddot konamin kodposivonnaa. ");
INSERT INTO oboNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na, otik dii kow en od pomakoy to id ponudtuu ku koniyu moka‑atag to kotomanan ka‑ay to ampow't ingod, iyon pobbo ayu kod ponudtulan ku sikiyu moka‑atag to kotomanan diyot datas to langit? ");
INSERT INTO oboNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Oyyos waa en ahad ondoy no noko‑undiyon to datas to langit, ko konna, siyak da en no Anak to Minuvu, su riyon a man id pomon. ");
INSERT INTO oboNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Iddos od kotomanan ku, noko‑iling taddot kodporatas dangan ni Moises to brunsi no uwod no id takos din diyot kayu nid bunsud to riyon pa sikandan to noka‑awoy‑awoy'n lugaa. De‑en iling mandad tadda, siyak no Anak to Minuvu, ko‑ilangan no id poratas diyot kayu nid bunsud, ");
INSERT INTO oboNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","su amoy iddos ahad ondoy nod pomakoy koddi, od pokotanggap to umuun waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pomon to dakkoon ginawa to Monama to langun no minuvu ka‑ay to ampow't ingod, id boggoy rin kos soosokkad no Anak din, amoy iddos ahad ondoy nod pomakoy kandin, konnod silutan to kopotayan, ko konna, od pokotanggap to umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Oyyos waa id popiyod to Monama iddos Anak din ka‑ay to ampow't ingod amoy od silut to mgo minuvu, ko konna, amoy'd kotobbus dan ukit kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Dos ahad ondoy nod pomakoy kandin, konnod silutan, piru iddos waa id pomakoy, nohukuman don en nod silutan. Oyyos waa man sikandan id pomakoy taddot soosokkad no Anak to Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iddos unayan nod silutan sikandan, oyyos waa ran tonggapa iddos ko‑owangan no mid undini to ingod. Iyon dan moho id dokollan to ginawa, iddos mosukirom kuntra taddot ko‑owangan, su morat man kos pinuungan dan. ");
INSERT INTO oboNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Dos mgo minuvu nod puung to morat, id kolingasa‑i ran iddos ko‑owangan woy od poriyu ran tadda, su amoy diid kosorollan iddos morat no pinuungan dan. ");
INSERT INTO oboNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Piru iddos mgo minuvu nod ikuu to kovonnaan, od porani en to ko‑owangan amoy od kokita no iddos Monama kos id pomonnan taddot langun no moppiyon pinuungan dan. ");
INSERT INTO oboNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nopongnga idda, si Disas woy dos mgo tinodduwan din, mid undiyon to prubinsya to Judea. Id oubpa sikandin dutun to pilon allow woy id bovoutismu. ");
INSERT INTO oboNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Na si Juan no Tohodboutismu, id ponayun mandad sikandin nid bovoutismu riyon to Enon no moranit bonuwa to Salem, su dakkoo man kos oweg dutun. Id pon‑undiyon iddos mgo minuvu to ki Juan amoy'd poboutismu. ");
INSERT INTO oboNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Iddon timpu, waa pa noprisu si Juan. ");
INSERT INTO oboNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sokkad no allow, iddos mgo tinodduwan ni Juan, nokod‑apuu taddot sokkad no Judio moka‑atag to kod‑ikuu to botasanon dan to kodlinis. ");
INSERT INTO oboNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","De‑en id undiyon sikandan to ki Juan woy mid ikahi to, “Tohodnonaw, iddos minuvu nid duma kikow no id pokilaa ru no Mesiyas to riyon ka pa to dipaat Oweg to Jordan, id bovoutismu ron, woy oray'n mo‑uraa kos mid undiyot kandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mid tavak si Juan to, “Waa en kogahan to minuvu otik konna idda id boggoy to Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Sikiyu en kos od pokoposivonnaa no id ikahi a, no konna siyak kos Mesiyas, ko konna, id popiyod a ra nod unna kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Noko‑iling a to oukuy taddot od osawa nod sakup to kosaa rin. Ahad konna siyak kos od osawa, piru od kahaa a otik od korinog ku no iddos od osawa, nahaa taddot od osowan din. De‑en noponnu a to kahaan. ");
INSERT INTO oboNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Oyya su ollog en nod kovantug si Disas woy siyak mandad, ollog en nod lingawan.” ");
INSERT INTO oboNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Na sikandin no id pomon diyot datas to langit, lampas to langun, piru iddos minuvu nid pomon ka‑ay to ampow't ingod, sakup en sikandin to ingod woy'd ikahi sikandin moka‑atag da en ka‑ay to ampow't ingod, su idda ra me‑en kos sinorollan din. Piru sikandin no id pomon diyot langit, lampas en to langun. ");
INSERT INTO oboNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ahad id ponudtuu rin iddos moka‑atag to nokita woy norinog din diyot datas to langit, waa moho goli od pomakoy taddot id posivonnaa rin. ");
INSERT INTO oboNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Piru iddos minuvu no id pomakoy taddot id nonaw rin, id posivonnaa no iddos langun no kahit Monama, mooggot en. ");
INSERT INTO oboNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Oyyos si Disas no id popiyod to Monama, waa osson id ponudtuu rin, idda ra en so id po‑ikahi to Monama kandin. Su id boggayan man sikandin to waa toppong no kotuusan to Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dakkoo kos ginawa to Monamon Amoy taddot Anak din, woy id sanna rin kandin iddos kotungud nod ponguu to langun. ");
INSERT INTO oboNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na, iddos ahad ondoy nod pomakoy to Anak to Monama, duwon umuun waad tomanon, piru iddos ahad ondoy no diid dumoruma to Anak to Monama, konnod pokotanggap to umuun waad tomanon, ko konna, od kosahapan din kos silut to Monama taman to waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na iddon timpu, norinog taddot mgo Pariseo no ahad mo‑uraa kos id dumoruma ki Juan, lampas pe‑en no mo‑uraa kos id dumoruma ki Disas woy id poboutismu kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Piru iyon bonnaa, konna si Disas kos id bovoutismu, ko konna, iddos mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","To nosorollan ni Disas no idda en kos norinog to mgo Pariseo, id tanan sikandin diyot prubinsya to Judea duma to mgo tinodduwan din woy id livod mandon sikandan diyot prubinsya to Galilea. ");
INSERT INTO oboNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Diyot kodlivod dan, ko‑ilangan en nod baya sikandan diyot prubinsya to Samaria. ");
INSERT INTO oboNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Na, noko‑inguma sikandan diyot morani to bonuwa to Sicar no sakup to Samaria. Diyon sikandan to livuta no id boggoy dangan ni Jacob to anak din no si Jose. ");
INSERT INTO oboNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Woy rutun, duwon moraom no bolun no id bovallan ni Jacob. Pomon to novolloy si Disas to kod‑ipanow rin, id ounsad sikandin diyot ibpit taddon bolun woy iddon timpu, moko‑untud don kos allow. ");
INSERT INTO oboNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Na iddos mgo tinodduwan din, id pontollus diyot bonuwa amoy od bovolli to koka‑an. Laggun to id ounsad pa si Disas, duwon sokkad no molitan no toho Samaria nid inguma su od ponikoddu. Kahin Disas kandin to, “Uri, po‑inomma a pobbe‑en to oweg.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mid ikahi iddos molitan diyot ki Disas to, “Mambo man tod buyu ka koddi to oweg, su Judio ka man woy siyak, molitan no toho Samaria?” Id oseng din idda su iddos mgo Judio, waa me‑en moppiyon koroniyan taddot mgo toho Samaria. ");
INSERT INTO oboNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Id tavak si Disas to, “Otik nosorollan du ra nanoy ko ondan kos id boggoy to Monama woy ko ondoy a no id buyu kikow to oweg, sikkow pe‑en ayu kos od buyu koddi, woy od boggayan ku en sikkow to oweg nod pokovoggoy to umuu.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kahi taddot molitan to, “Sir, moraom kos bolun woy waa sahuk du. Ingkon du man od ongayon kos oweg nod pokovoggoy to umuu? ");
INSERT INTO oboNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Id boggoy dangan konami inin bolun taddot kovuyyahan ta no si Jacob. Sikandin woy dos mgo anak din, ahad iddos mgo oyama rin, ka‑ay en pomon kos id inom dan. Na, ko ungketen, lampas ka pobbos taddot kovuyyahan ta no si Jacob?” ");
INSERT INTO oboNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mid tavak si Disas to, “Iddos ahad ondoy nod inom ka‑ay'n oweg, od kotokkangan pa mandon. ");
INSERT INTO oboNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Piru iddos ahad ondoy nod inom to oweg no id boggoy ku, dii ron en sikandin od kotokkangan. Oyya su iddos oweg no id boggoy ku, od pokovoggoy to umuun waad tomanon. Od poko‑iling idda to sobsob diyot ginawa rin no od aus woy diid ko‑ottiyan.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kahi taddot molitan to, “Sir, boggayi a ruwon no oweg amoy dii ad od kotokkangan woy dii ad od livodlivod ka‑ay nod ponikoddu.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kahin Disas to, “Uli ka pobbo woy dumannow rini kos sawa ru.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mid tavak iddos molitan to, “Waa man sawa ku.” Kahin Disas to, “Ollog en kos id oseng du no waa sawa ru, ");
INSERT INTO oboNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","su iyon bonnaa, kolimma kad noko‑osawa woy dos mama no duma ru ko‑ungkay, konna ru tullid no sawa. De‑en bonnaa rad kos id oseng du.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kahi taddot molitan to, “Sir, nosorollan ku ko‑ungkay no propeta ka vos. ");
INSERT INTO oboNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","De‑en ponudtuli a ko mambot sikiyu no mgo Judio, od ikahi no diyon da to Jerusalem kos ollog no lugaa to kodsimba to Monama. Piru ontongngiyu ikon buvungan. Sikami moho no mgo toho Samaria, id pomakoy no ika en no buvungan kos mooggot no simba‑an, oyyos duwon me‑en id ponsimba iddos kovuyyahan ta dangan.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mid tavak si Disas to, “Uri, pominog ka tod osengon ku kikow. Od inguma en kos timpu no od simba kow to Monamon Amoy, konna ka‑ay no buvungan woy konna mandad diyon to Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Oyyos sikiyu no mgo toho Samaria, od simba kow, piru waa kow nokokilaa ko ondoy kos id simba row. Piru sikami no mgo Judio, nokilaa roy kos id simba roy, su iddos tohodtobbus, id pomon en dinit konami no mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Od inguma kos timpu woy ko‑ungkay ron en, no iddos mooggot nod ponsimba to Monama, od ponsimba ran to Monamon Amoy ukit to tivuk no ginawa ran woy bonnaavonnaan kodsimba. Oyya su ungketen en kos kodsimba no id kopi‑it Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dos Monama, ispiritu, de‑en iddos langun nod ponsimba kandin, ko‑ilangan nod simba kandin diyot tivuk no ginawa ran woy bonnaavonnaan kodsimba.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mid ikahi iddos molitan to, “Nosorollan ku nod undini iddos Mesiyas no id aam to Monama amoy'd harit langun. Na otid inguma ron sikandin, id paabbotlabbot din kos langun dinit keta.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kahin Disas to, “Iddos od tommanon du, siyak en idda.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","To id oseng din idda, id inguma ron iddos mgo tinodduwan din. Nosoobbuwan sikandan to nokita ran no id potongkooy si Disas taddon molitan. Piru waa en ahad sokkad kandan no noko‑intud taddot molitan ko ondan kos dontulon din. Woy waa ran mandad noko‑intud ki Disas ko mambot id tongko rin iddos molitan. ");
INSERT INTO oboNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Na, id tuwos taddot molitan iddos gunsu rin woy id livod sikandin diyon to bonuwa, woy id osengan din iddos mgo minuvu to, ");
INSERT INTO oboNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Duma kow koddi amoy'd kokita row iddos minuvu no nokosaddoo moho to langun nid puungan ku. Kuo kid, su saddook sikandin don en kos Mesiyas.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","De‑en id pon‑undiyon to ki Disas iddos mgo minuvu no id pomon diyon to bonuwa. ");
INSERT INTO oboNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","To waa pa id inguma iddos mgo minuvu riyot ki Disas, id inggat sikandin taddot mgo tinodduwan din amoy'd ka‑an. ");
INSERT INTO oboNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Piru mid ikahi si Disas to, “Duwon dad koka‑an ku no waa row nosorolli.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","De‑en id po‑inturoy iddos mgo tinodduwan, kahi ran to, “Duwon ayu id atod kandin to koka‑an?” ");
INSERT INTO oboNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kahin Disas kandan to, “Iddos timbang koka‑an ku, idda en so kodtuman to id kopi‑i taddot id popiyod koddi woy dos kod‑ipongnga taddot id popuungan din koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Duwon osengan dow no, ‘Oppat no buwan pomon to kod‑oddok, idda pa kos kodkottu.’ Piru od ikohiyan ku sikiyu, ini ron en kos timpu to kodkottu. Ontongngi row man kos mo‑uraan minuvu nod inguma, su iling en sikandan to pinomuwa no ollog don nod kottuwon, oyyos ini ron en kos timpu nod pomakoy sikandan. ");
INSERT INTO oboNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Iddos mgo tohodkottu, id boyaran woy dos mgo minuvu no timbang od kottuwon dan, od pokotanggap to umuun waad tomanon. De‑en iddos tohod‑oddok to kahit Monama woy dos tohodkottu, od pokodduma nod kahaa. ");
INSERT INTO oboNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mooggot en iddos osengan no, ‘Duwon od oddok, duwon mandad od kottu.’ ");
INSERT INTO oboNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Su id popiyod ku sikiyu nod kottu to waa row oiluggati. Duwon don tapoy id oddok to kahit Monama, woy sikiyu en kos od pokokottu taddot mgo bunga to kod‑oiluggat dan.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na, mo‑uraan toho Samaria taddon bonuwa no id pomakoy ki Disas pomon taddot id ponudtuu to molitan, no nosodsorollan ni Disas iddos langun no id puungan din. ");
INSERT INTO oboNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","De‑en to kod‑inguma taddot mgo toho Samaria riyot ki Disas, ayas dan id aawid kandin. Purisu mid oubpa pa sikandin dutun daom to oruwon allow. ");
INSERT INTO oboNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","To norinog dan iddos nonaw rin, mo‑uraa pe‑en kos id pomakoy kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mid ikahi sikandan diyot molitan to, “Id pomakoy koyd konna ra pomon taddot id ponudtuu ru, ko konna, pomon to norinog doyd iddos nonaw rin. Nosorollan doyd no mooggot en no sikandin kos Tohodtobbus to langun no minuvu ka‑ay to ampow't ingod.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na, to id lihad kos oruwon allow, id logkiyat onsi Disas po‑undiyot prubinsya to Galilea. ");
INSERT INTO oboNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Id undiyon si Disas ahad sikandin don en kos mid ikahi, no iddos propeta, id poddisokkan to kod‑ontong diyot kandin don en no ingod. ");
INSERT INTO oboNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","To kod‑inguma ran diyot Galilea, moppiya kos kod‑olit‑olit kandan taddot mgo mohingod dutun. Oyya su nokita ran man iddos langun no mokososoobbun pinuungan ni Disas to riyon pa sikandan to Jerusalem iddot timpu to pista to Kodlihad to Ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Na, mid undiyon mandon si Disas to Cana no sakup to Galilea no riyon en no lugaa, id bauy rin no binu iddos oweg. Diyot osson bonuwa nod ngoranan to Capernaum, duwon sokkad no ponguu no sinolihan to hari, no iddos anak din no mama, novohokan. ");
INSERT INTO oboNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","To norinog din no mid inguma si Disas diyon to Galilea pomon diyot Judea, idda ron en, id undiyon sikandin woy id po‑eru‑eru nod duma si Disas diyot Capernaum amoy od bowiyan iddos anak din no asow ron od patoy. ");
INSERT INTO oboNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kahin Disas kandin to, “Gali kow ra moho od pomakoy kod pokokita kow to mokososoobbun pinuungan.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Piru mid ikahi iddos ponguu to, “Sir, kolimulimu, duma ka pa koddi laggun to waa pa nohottasi iddos anak ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kahin Disas to, “Uli kad bo, su od ko‑uliyan don iddos anak du.” Na, id pomakoy iddos ponguu taddot id oseng ni Disas woy id ipanow ron sikandin. ");
INSERT INTO oboNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na, to riyon pa sikandin to daan, notommu rin iddos mgo sinuhuwan din woy mid ikahi ran no no‑uyag iddos anak din woy no‑uliyan don. ");
INSERT INTO oboNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Id inturan din sikandan ko kannu no‑uliyan iddos anak. Mid tavak sikandan to, “Na‑awa kos kodmomonit din govoni to ala una to mapun.” ");
INSERT INTO oboNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Idda ron en, nosompottan taddot ponguu no idda en mandad no uras mid ikahi si Disas kandin no od ko‑uliyan don iddos anak din. De‑en id pomakoy ron sikandin woy dos langun no sakup din diyot kandin no baoy. ");
INSERT INTO oboNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na, idda en kos iko‑oruwon mokososoobbun pinuungan ni Disas diyon to Galilea to kodlivod din pomon diyot Judea. ");
INSERT INTO oboNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Waa nouhoy pomon tadda, mid undiyon mandon si Disas to Jerusalem amoy od lonug to pista to mgo Judio atag to pomokayon dan. ");
INSERT INTO oboNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na riyot Jerusalem, duwon linow nod polihusan diyot morani to sokkad no sobbangan to bonuwa nod ngoranan no Sobbangan to Karnero. Diyot Hebreo no kinohiyan, od ngoranan ini no Betsata. Nokolingut taddon polihusan iddos limmon od oollungan. ");
INSERT INTO oboNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Diyon en id pon‑oilogga iddos mo‑uraan od kovohokan no idda en so mgo butud, mgo pungku woy mgo minuvu no id patoy kos lawa. ");
INSERT INTO oboNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Iyon dan od oongatan iddos kodwaong taddot oweg, oyyos duwon timpu no od inguma kos ponolihan to Monama amoy'd kolebboo tadda. Iddos od poko‑unna nod tinsubbuk dutun, od ko‑uliyan ahad ondan kos bohok din. ");
INSERT INTO oboNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na, duwon sokkad no mama rutun no novohokan daom don to otollumpuu‑waun lahun. ");
INSERT INTO oboNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nokita sikandin ni Disas woy nosorollan din no nouhoy ron oraroy iddos bohok taddon mama. De‑en mid intud si Disas kandin, kahi rin to, “Od kopiyan ka vo nod ko‑uliyan?” ");
INSERT INTO oboNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Id tavak iddos novohokan to, “Oyya en nanoy, Sir, piru waa me‑en od pokotavang koddi amoy od poko‑unna a nod tinsubbuk duwot oweg otid kolevollon don ika. Su laggun to od nokkaanokkaa a poron nod unduwon to linow, duwon don man od poko‑unna koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kahin Disas to, “Lohinat ka, piyoddow kos ikam du woy ipanow kad bo.” ");
INSERT INTO oboNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Idda ron en, no‑uliyan iddos novohokan. Id luun din iddos ikam din woy mid ipanow. Na, id puungan ni Disas idda timpu to Allow't Kod‑imolloy. ");
INSERT INTO oboNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","De‑en to nokita taddot mgo ponguu to Judio iddon minuvu, mid ikahi sikandan to, “Allow't Kod‑imolloy ko‑ungkay, woy id diiyan diyot keton pomokayon ahad iddos kodpiyod to ikam. De‑en mambot id puungan du moho ini?” ");
INSERT INTO oboNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mid tavak sikandin to, “Iddos minuvu no noko‑uli koddi kos id ikahi, no od piyoddon ku inis koddin ikam woy id po‑ipanow a nikandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","De‑en id inturan dan sikandin, kahi ran to, “Ondoy man kos minuvu no id oseng tadda riyot kikow?” ");
INSERT INTO oboNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Piru waa rin nokilaa ko ondoy iddos noko‑uli kandin, su id awa ron man si Disas woy nosoungan don taddot mo‑uraan minuvu no nolivuung dutun. ");
INSERT INTO oboNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Waa nouhoy pomon tadda, nokita mandon sikandin ni Disas diyon to templo. Kahin Disas kandin to, “Na no‑uliyan kad. Pomon ko‑ungkay, tonaniyud kos saa ru, su otid ponoyunon du pa idda, lampas pe‑en no mosuppit kos od kotomanan du.” ");
INSERT INTO oboNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Na, mid ipanow iddos mama woy id ponudtuu rin diyot mgo ponguu to Judio no si Disas en kos noko‑uli kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","De‑en pomon taddot id puungan ni Disas diyon to Allow't Kod‑imolloy, mid tigkanoy iddos mgo ponguu to Judio to kodposuppit kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Piru id ikohiyan dan ni Disas to, “Waa en soroan to Amoy ku nod puung to kandin no pinuungan woy siyak mandad, od ponayun a nod puung.” ");
INSERT INTO oboNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pomon taddot id oseng ni Disas, ayas pe‑en id nangkap to po‑ukit to kod‑imatoy kandin iddos mgo ponguu to Judio. Oyyos konna ra no id supak din iddos pomokayon moka‑atag to Allow't Kod‑imolloy, ko konna, id ikahi rin pe‑en no toppong din kos Monama ukit to kod‑oseng no Amoy rin kos Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Na kahin Disas kandan to, “Bonnaavonnaa nod ikohiyon ku koniyu, no siyak no Anak to Monama, waa a mid unoy‑unoy nid puung to ahad ondan, ko konna, iyon id puungan ku, iddos nokita ku no id puungan to Amoy ku. Oyya su ahad ondan kos od puungan din, idda ra en mandad kos od puungan ku. ");
INSERT INTO oboNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Su iddos Amoy ku, dakkoo kos ginawa rin koddi no Anak din, de‑en id pokita rin koddi iddos langun nod puungan din. Woy duwon lampas pe‑en ka‑ay no id pokita rin koddi nod puungan ku woy'd kosoobbuwan kow en. ");
INSERT INTO oboNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Oyyos od bodnawon to Amoy ku iddos id poomatoy woy'd boggayan din sikandan to umuu. Iling mandad tadda, siyak no Anak din, od boggoy mandad to umuu riyot ahad ondoy no id kopi‑i ku nod boggayan. ");
INSERT INTO oboNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Konna iddos Amoy ku kos od hukum to mgo minuvu, ko konna, siyak no Anak din kos id boggayan din taddot langun no kotungud to kodhukum, ");
INSERT INTO oboNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","su id kopi‑i to Amoy ku no od posivontuhan a to langun no minuvu iling to kodposivantug dan to Amoy ku. De‑en iddos ahad ondoy no waa id posivantug koddi no Anak din, waa mandad id posivantug taddot Amoy ku no id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Bonnaavonnaa nod ikohiyon ku koniyu, no iddos id dumoruma to koddin kahi woy id pomakoy to Monama no id popiyod koddi, sikandin en kos od pokotanggap to umuun waad tomanon. Konna sikandin od silutan to kopotayan, oyyos nokotanggap don man sikandin to umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Bonnaavonnaa nod ikohiyon ku koniyu, no od inguma kos timpu woy ini ron en, no iddos timbang id poomatoy ron pomon to mgo saa ran, od pokorinog to bawos ku no Anak to Monama. Na, iddos od pokorinog to bawos ku woy id pomakoy, od pokotanggap to umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Su iddos Amoy ku kos id pomonnan to umuu woy siyak mandad no Anak din, od pokovoggoy taddon umuu, oyya su id boggayan a nikandin to kotungud to kodboggoy tadda. ");
INSERT INTO oboNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Id boggayan a pe‑en nikandin to kotungud to kodhukum to langun no minuvu, oyyos siyak en kos Anak to Minuvu. ");
INSERT INTO oboNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yo kow'd kosoobbu‑i ka‑ay't id oseng ku koniyu, su od inguma en kos timpu no iddos langun no id poomatoy ron, od pokorinog to bawos ku ");
INSERT INTO oboNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","woy od kovadnow sikandan pomon diyot lovongngan. Dos id puung to moppiya, od bodnawon amoy'd pokotanggap to umuun waad tomanon, piru iddos id puung to kororattan, od bodnawon amoy'd silutan to kopotayan no waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Na ponayun mid ikahi si Disas to, “Waa a mid unoy‑unoy nid puung to ahad ondan. Su od hukum a ukit da to id oseng to Monama koddi. De‑en motallong kos koddin kodhukum, oyyos waa ku ikula iddos koddin id kopi‑i, ko konna, idda ra en so id kopi‑i taddot id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Otik siyak da kos od posivonnaa moka‑atag koddi, dii a en od pokoposivonnaa no mooggot kos id ikahi ku. ");
INSERT INTO oboNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Piru duwon pa ossa nod posivonnaa moka‑atag koddi no idda en so Amoy ku, woy nosorollan ku no mooggot en iddos kodposivonnaa rin. ");
INSERT INTO oboNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Na, duwon id po‑undiyon dow ki Juan no Tohodboutismu woy mooggot en iddos id ikahi rin moka‑atag koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Konna ad od ko‑ilangan to minuvu nod posivonnaa moka‑atag koddi. Piru id ngoranan ku ra sikandin amoy'd kotobbus kow. ");
INSERT INTO oboNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Oyyos si Juan, noko‑iling to suu no id loglog woy id se‑aa. Na, notoosan kow taddot kandin no taddow riyot koniyun poomdom to moobbava ra no timpu. ");
INSERT INTO oboNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Piru duwon pe‑en lampas ki Juan no id posivonnaa moka‑atag koddi, no idda en so mgo pinuungan no id po‑ipongnga koddi to Amoy ku. Woy od posivonnaa idda no Amoy ku kos id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Idda mandad so Amoy ku no id popiyod koddi, sikandin kos id posivonnaa moka‑atag koddi. Piru waa kow poron en nokokita to boyo rin woy waa kow nokorinog to bawos din. ");
INSERT INTO oboNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Waa row mandad id pomuwa riyot pusung dow iddos kandin no kahi, oyyos waa kow man id pomakoy koddi no id popiyod din. ");
INSERT INTO oboNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Inaayun kow od basa taddot Nosulat no Kahit Monama, su kunan dow ko ukit tadda, od kotanggap dow iddos umuun waad tomanon. Woy ahad idda ron en so Nosulat no Kahit Monama kos mid posivonnaa moka‑atag koddi, ");
INSERT INTO oboNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","piru dii kow rad en od kopiyan nod dumoruma koddi amoy od pokotanggap kow nanoy to umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Waa ku ingowolla nod doongon a to mgo minuvu, ");
INSERT INTO oboNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","piru nosorollan ku no riyot pusung dow, waa en ginawa row to Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mid undini a woy id boggayan to kotungud no id pomon en diyot Amoy ku, piru waa a nikiyu tonggapa. Piru ko duwon ossa nod undini ukit to ko‑ugolingun din no kotungud, od tonggapon dow moho sikandin. ");
INSERT INTO oboNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Momonnu kow man od pomakoy, otik iyon dow ra od ingowollon iddos koddoong no id pomon da en diyot mgo duma row, piru waa row ingowolla iddos koddoong no id pomon en diyot Monama? ");
INSERT INTO oboNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yo row poomdomma no siyak kos od popenek to koniyun saa riyot isowwan to Amoy ku, ko konna, si Moises no id solihan dow kos od popenek tadda. ");
INSERT INTO oboNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Su otik mooggot en kos kodpomakoy row ki Moises, od pomokayon a mandad nanoy nikiyu, oyyos moka‑atag man koddi iddos id sulat din dangan. ");
INSERT INTO oboNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Piru pomon to waa kow en id pomakoy taddot id sulat din, momonnu kow man od pomakoy taddot id ikahi ku?” ");
INSERT INTO oboNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Waa nouhoy pomon tadda, mid livod si Disas diyot dipaa to Lanow't Galilea no id ngoranan mandad no Lanow't Tiberias. ");
INSERT INTO oboNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Id lupug kandin iddos mo‑uraan minuvu, su nokita ran man iddos mokososoobbun pinuungan din to kodbawi taddot od pongkovohokan. ");
INSERT INTO oboNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Id tikoddog si Disas diyot buvungan duma iddos mgo tinodduwan din woy riyon sikandan id pon‑ounsad. ");
INSERT INTO oboNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Iddon timpu, asow ron iddos pista to mgo Judio nod ngoranan no pista to Kodlihad to Ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","To kodpomantow ni Disas, nokita rin iddos mo‑uraan minuvu nod inguma no od undiyot kandin. De‑en id ikohiyan din si Felipe to, “Ingkon ki man od pokovolli to koka‑an atag ka‑ay't mo‑uraan minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Idda en kos intud din, su id kopi‑i rin nod geddaman si Felipe. Piru si Disas, nokosaddoo ron tapoy ko ondan kos od puungan din. ");
INSERT INTO oboNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Mid tavak si Felipe to, “Ahad od puung koy pa daom to waun buwan amoy'd pokovolli to paan no id poka‑an kandan, dii en idda od pokotoked ahad songo‑sungit.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na, iddos sokkad taddot mgo tinodduwan din no si Andres no ari ni Pedro, mid ikahi to, ");
INSERT INTO oboNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Duwon od kongkonakan ka‑ay no id totannow to limmon molison no paan woy oruwon ngaap. Piru momonnu man ini od pokotoked ka‑ay't mo‑uraan minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kahin Disas diyot mgo tinodduwan din to, “Po‑unsara row kos mgo minuvu.” Na iddon lugaa, mowwag no sobbotton, de‑en id pon‑ounsad iddos langun no minuvu. Dos ko‑uralloy to mgo mama, mgo limmon maan (5,000). ");
INSERT INTO oboNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Na, id angoy ni Disas iddos paan woy id posolamat sikandin diyon to Monama. Nopongnga, id pontaadtaad din idda riyot mgo minuvu. Ungketen dad en mandad kos id puungan din taddot ngaap, woy id pomboggayan din iddos langun woy id pongka‑an dan taman tid kopi‑i ran. ");
INSERT INTO oboNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","To nongovuung don sikandan langun, mid ikahi si Disas diyot mgo tinodduwan din to, “Limura row iddos nongosama amoy waa od ko‑uwakkan.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","De‑en id ponlimud dan iddos langun no nosama pomon taddot limmon molison no paan, woy noponnu pe‑en iddos sopuu‑oruwon bukag. ");
INSERT INTO oboNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","To nokita taddot mgo minuvu iddos mokososoobbun pinuungan ni Disas, mid ikahi sikandan to, “Ini ron bos en kos Propeta no id oongatan ta nod undini to ampow't ingod!” ");
INSERT INTO oboNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Na, nosorollan ni Disas no duwon puhawang to mgo minuvu no od pohoson sikandin nod bovallan no hari. De‑en id tanan sikandin woy mid tikoddog mandon diyot buvungan no siksikandin da. ");
INSERT INTO oboNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","To od kosagkup don, id pon‑undiyon to ibpit to lanow iddos mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mattag don od kovulli, waa poron id livod si Disas diyot kandan. De‑en id logkiyat don sikandan nod pomollangay po‑undiyot bonuwa to Capernaum. ");
INSERT INTO oboNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Laggun tid pomollangay ran, tigkow id doppot kos monokkaan kaamag woy id doorakkoo kos mgo baud. ");
INSERT INTO oboNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","To mgo limma o annom don no kilometro kos id baya ran to kodbovadsoy pomon diyot ibpit, nokita ran si Disas nid ipanow riyon to ampow't oweg po‑undiyot bollangay woy no‑od‑oratan sikandan. ");
INSERT INTO oboNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Piru mid ikahi si Disas to, “Yo kow'd kovaakki, siyak ini!” ");
INSERT INTO oboNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","De‑en nongahaa sikandan woy id posakoy ran si Disas diyot bollangay. To nokosakoy ron sikandin, idda ron en, id dunggu ron iddos bollangay riyot od undiyonnan dan. ");
INSERT INTO oboNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","So‑op no allow, id aangat pa ki Disas iddos mgo minuvu no riyon poron to dipaat lanow, su nokosaddoo ran no waa sikandin id duma nid sakoy taddot bollangay to kodtanan dan, woy waa en dumon bollangay to iddon bulli. ");
INSERT INTO oboNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Todtahad, duwon mgo bollangay pomon diyot bonuwa to Tiberias no id pondunggu riyot morani taddot lugaa nid kannan to mgo minuvu taddot paan no id posolomatan tod Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","To nosorollan taddot mgo minuvu no worad dutun si Disas woy dos mgo tinodduwan din, id ponsakoy ran to bollangay woy mid undiyon sikandan to Capernaum amoy od nangkap ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","To kod‑inguma ran diyot Capernaum, nokita ran si Disas, woy kahi ran to, “Tohodnonaw, kannu ka id inguma rini?” ");
INSERT INTO oboNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kahin Disas kandan to, “Bonnaavonnaa nod ikohiyon ku koniyu, no iyon unayan no id nangkap kow koddi, konna pomon to mgo mokososoobbun nokita row, ko konna, pomon to nongovuung kow taddot paan. ");
INSERT INTO oboNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yo row oiluggati iddos kodnangkap to koka‑an nod ko‑obbuu ra, ko konna, iyon dow oiluggati iddos koka‑an nod pokovoggoy to umuun waad tomanon. Siyak no Anak to Minuvu kos od pokovoggoy koniyu ka‑ay'n koka‑an, oyya su id boggayan a to kotungud taddot Monamon Amoy ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","De‑en mid intud sikandan to, “Ondan man kos ollog nod puungan doy amoy od tuman taddot id kopi‑it Monama?” ");
INSERT INTO oboNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Mid tavak si Disas to, “Iyon id kopi‑it Monama nod puungan dow, idda en so od pomakoy kow koddi no id popiyod din.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kahi ran to, “Ondan no mokososoobbu kos id pokita ru amoy od pomakoy koy? Ondan kos od puungan du amoy'd pokita no id pomon ka en to Monama? ");
INSERT INTO oboNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Su iddos kovuyyahan ta, id poka‑an sikandan ni Moises taddot id ngoranan no mana laggun to riyon pa sikandan to noka‑awoy‑awoy'n lugaa. Diyot Nosulat no Kahit Monama, no‑ikahi no, ‘Id boggoy rin kandan iddos koka‑an no id pomon diyot datas to langit.’ ” ");
INSERT INTO oboNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kahin Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no konna si Moises kos id boggoy to koka‑an no id pomon diyot datas to langit, ko konna, idda en so Amoy ku. Woy ko‑ungkay, sikandin mandad kos od boggoy koniyu to bonnaan koka‑an no id pomon diyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Su iddos bonnaan koka‑an no id boggoy to Monama, idda en so id pomon diyot datas to langit woy od boggoy idda to umuu riyot langun no minuvu ka‑ay to ampow't ingod.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","To norinog taddot mgo minuvu iddos id oseng ni Disas, mid ikahi sikandan to, “Tohodnonaw, boggayi koy inaayun duwon no koka‑an.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kahin Disas kandan to, “Siyak kos koka‑an no id pomonnan to umuu. Iddos minuvu nod porani woy'd pomakoy koddi, dii ron en sikandin od gutasan woy dii ron en od kotokkangan. ");
INSERT INTO oboNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Piru iling taddot id ikahi kud, no ahad nokita rowd iddos mokososoobbun pinuungan ku, waa kow rad en id pomakoy. ");
INSERT INTO oboNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Iddos langun no minuvu no id boggoy koddi to Amoy ku, od undinit koddi woy dos ahad ondoy nod dumoruma koddi, dii ku en sikandin od osikayon. ");
INSERT INTO oboNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Su mid undini a pomon diyot datas to langit, konna amoy od puung to id kopi‑i ku, ko konna, amoy'd puung taddot id kopi‑i to Monamon Amoy no id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iyon din id kopi‑i, no waa en ahad sokkad taddot mgo minuvu no id boggoy rin koddi nod kowora, ko konna, od bodnawon ku sikandan init morin allow. ");
INSERT INTO oboNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Oyyos ini en kos id kopi‑i to Amoy ku no iddos langun nod kilaa woy'd pomakoy koddi no Anak din, od pokotanggap to umuun waad tomanon woy od bodnawon ku sikandan init morin allow.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na, id pommivig iddos mgo Judio pomon taddot id oseng ni Disas no sikandin kos koka‑an no id pomon diyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kahi ran to, “Konna vo si Disas man ika no anak ni Jose? Nokilaa ta man kos amoy woy inoy ruwon. De‑en mambot od osengon din moho no id pomon sikandin diyot datas to langit?” ");
INSERT INTO oboNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kahin Disas to, “Soro kowd to kodpommivig dow. ");
INSERT INTO oboNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Waa ahad ondoy nod dumoruma koddi, otik dii iddos Amoy ku no id popiyod koddi kos od kobbit to pusung dan amoy'd pomakoy. Na iddos od dumoruma koddi, od bodnawon ku sikandin init morin allow. ");
INSERT INTO oboNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Duwon id sulat to sokkad taddot mgo propeta dangan no mid ungketen to, ‘Iddos langun no minuvu, od nonawwan to Monama.’ De‑en iddos ahad ondoy nod pominog taddot nonaw to Amoy ku, sikandan kos od porani koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Konna kohulugan tadda no duwon don minuvu no nokokita to Amoy ku, oyyos waa ron en nokokita kandin, ko konna, siyak da en no id pomon diyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Bonnaavonnaa nod ikohiyon ku koniyu, no iddos od pomakoy koddi, duwon umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Oyyos siyak kos koka‑an no id pomonnan to umuu. ");
INSERT INTO oboNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Iddos kovuyyahan dow, nokoka‑an to mana to riyon pa sikandan to noka‑awoy‑awoy'n lugaa, piru id poomatoy rad man sikandan. ");
INSERT INTO oboNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Piru iddos koka‑an no ka‑ay ko‑ungkay pomon diyot datas to langit, iddos ahad ondoy nod ka‑an ka‑ay, konna en od patoy. ");
INSERT INTO oboNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Siyak kos ma‑antoy'n koka‑an no id pomon diyot datas to langit. Dos ahad ondoy nod ka‑an ka‑ay, duwon umuun waad tomanon. Inis koka‑an no id boggoy ku, ini en so lawa ku, su amoy iddos mgo minuvu ka‑ay to ampow't ingod, od pokotanggap to umuun waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Na, nokod‑apuu iddos mgo Judio pomon taddot osengan ni Disas. Kahi ran to, “Te, od monnuwon man ka‑ay'n minuvu tod boggoy kos lawa rin amoy od kannon ta?” ");
INSERT INTO oboNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kahin Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no otik konna kow od ka‑an to lawa taddot Anak to Minuvu woy'd inom to longossa rin, dii kow en od pokotanggap to umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Piru iddos ahad ondoy nod ka‑an to lawa ku woy'd inom to longossa ku, duwon umuun waad tomanon woy od bodnawon ku sikandin init morin allow. ");
INSERT INTO oboNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Su iddos lawa ku, idda en kos bonnaan koka‑an woy dos longossa ku, idda en kos bonnaan inommon. ");
INSERT INTO oboNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Dos ahad ondoy nod ka‑an to lawa ku woy'd inom to longossa ku, od ubpa sikandin dinit koddi woy siyak mandad, diyon to kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Iddos Amoy ku no id pomonnan to umuu, sikandin kos id popiyod koddi woy duwon umuu ku pomon kandin. Na iling mandad tadda, iddos minuvu nod pokoka‑an koddi, duwon umuun waad tomanon no id pomon koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Siyak en kos koka‑an no id pomon diyot datas to langit. Konna ini iling taddot mana, su ahad id pongka‑an tadda iddos kovuyyahan dow, id poomatoy rad man sikandan. Piru iddos od ka‑an taddot od ikohiyon ku no koka‑an, duwon umuun waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Id oseng idda ni Disas laggun to id nonaw sikandin diyot simba‑an to mgo Judio no riyot Capernaum. ");
INSERT INTO oboNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na, to norinog taddot mgo minuvu nod dumoruma ki Disas iddos nonaw rin, mo‑uraa kandan kos mid ikahi to, “Diid kogaha inin nonaw! Worad od pokopongimbonnaa ka‑ay.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Piru nosorollan ni Disas no id pommivig iddos od pondumoruma kandin pomon taddot nonaw rin. De‑en mid ikahi si Disas to, “Monnu, nomorat bo kos songnga row taddot id oseng ku? ");
INSERT INTO oboNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Momonnu ayu otik od kokita row no siyak no Anak to Minuvu, od kovatun diyot datas to langit no id pomonnan ku? ");
INSERT INTO oboNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Iddos Ispiritu to Monama kos id boggoy to umuun waad tomanon, woy konna ini od kopuungan to minuvu. Dos id ikahi ku koniyu, id pomon idda riyot Ispiritu to Monama woy od pokovoggoy idda to umuu. ");
INSERT INTO oboNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Piru duwon duma koniyu no waa id pomakoy koddi.” Id oseng din ini, su nosorollan din don tapoy ko ondoy kos diid pomakoy woy dos od boligya kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Na ponayun mid ikahi si Disas to, “Ini en kos unayan no id osengan ku sikiyu no, waa od dumoruma koddi otik waa id kobbit to Amoy ku iddos pusung din.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Pomon tadda, mo‑uraa iddos od dumoruma ki Disas no mid tanan don woy worad id duma kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","De‑en id inturan ni Disas iddos sopuu‑oruwon tinodduwan din, kahi rin to, “Na sikiyu, od tanan kow vo mandad koddi?” ");
INSERT INTO oboNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mid tavak si Simon Pedro to, “Longaggon, ondoy pa man kos od ko‑undiyonnan doy? Su riyon da en to kikow iddos mgo kahi nod pokovoggoy to umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Id pomakoy koy kikow, su nokosaddoo koy no sikkow en kos waa saa no id popiyod to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kahin Disas to, “Id aam ku sikiyu no sopuu‑oruwa, piru sokkad koniyu, no‑iraom ki Moivuyan!” ");
INSERT INTO oboNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iyon kohulugan ni Disas tadda, idda en si Judas no anak ni Simon Iscariote, su ahad sokkad sikandin taddot sopuu‑oruwon tinodduwan din, piru riyot mori, sikandin kos od boligya ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nopongnga id nonaw si Disas, mid undiyon sikandin to nokod‑osso‑osson bonuwa no sakup to prubinsya to Galilea. Waa sikandin id livod diyot prubinsya to Judea, su iddos mgo ponguu to Judio, id nangkap to po‑ukit to kod‑imatoy kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na, asow ron iddos pista to mgo Judio nod ngoranan no pista to Kodsosabbung. ");
INSERT INTO oboNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","De‑en mid ikahi iddos mgo suwod ni Disas to, “Iyon moppiya, ipanow ka woy undiyon ka to Judea, amoy iddos od pondumoruma kikow, od pokokita to mgo mokososoobbun pinuungan du. ");
INSERT INTO oboNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Su otik id kopi‑i to sokkad no minuvu nod kovantug, dii rin id ollos kos pinuungan din. De‑en otid puung ka to mgo mokososoobbu, iyon moppiya, pokita ru idda riyot isowwan to langun.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Id oseng idda to mgo suwod ni Disas, su ahad sikandan, waa en mandad id pomakoy kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Na kahin Disas to, “Atag koddi, konna pa ini kos ollog no timpu, piru atag koniyu, od poko‑undiyon kow ahad kannu. ");
INSERT INTO oboNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Iddos mgo minuvu ka‑ay to ampow't ingod, waa en unayan nod kolingasa ran koniyu, piru siyak, od kolingasa ran koddi, oyya su id posivonnalan ku no morat kos pinuungan dan. ");
INSERT INTO oboNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Unna kowd undiyon to pista. Piru siyak, dii a pa od undiyon, oyyos waa pa id inguma kos ollog no timpu atag koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","To no‑oseng din idda riyot kandan, id polintotuwos pa sikandin diyon to Galilea. ");
INSERT INTO oboNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","To nokologkiyat don iddos mgo suwod ni Disas amoy'd sakup taddot pista, mid undiyon dad mandad sikandin. Piru waa sikandin id posaddoo, su dii sikandin od kopiyan nod kosorollan to mo‑uraan minuvu. ");
INSERT INTO oboNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na riyot pista, id nangkap ki Disas iddos mgo ponguu to Judio, kahi ran to, “Ingkon don ayu iddon minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Duwon mgo minuvu nod ponona‑asoy moka‑atag kandin. Dos duma kandan, mid ikahi to, “Moppiya sikandin no minuvu.” Piru iddos duma, mid ikahi to, “Konna. Id pon‑okalan din da kos mgo minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Piru dii sikandan od porinog diyot ko‑urallan, oyyos od kovaakkan sikandan taddot mgo ponguu to Judio. ");
INSERT INTO oboNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na, to od tongngotongnga ron iddos timpu to pista, idda pa mid undiyon si Disas to templo woy id nonaw. ");
INSERT INTO oboNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nosoobbuwan iddos mgo ponguu to Judio, woy mid ikahi sikandan to, “Ingkon moho id angoy inin minuvu to kotuihan no waa man sikandin nonawwi to mgo tohodnonaw to Judio?” ");
INSERT INTO oboNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","To norinog idda ni Disas, mid tavak sikandin to, “Inin nonaw, konna pomon koddi, ko konna, id pomon diyot Monama no id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Iddos ahad ondoy nod kopiyan nod puung taddot id kopi‑it Monama, od pokosaddoo sikandin ko inin nonaw, id pomon en diyot Monama o koddi ra no poomdom. ");
INSERT INTO oboNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Su iddos minuvu nod nonaw pomon diyot poomdom din, iyon din od ingowollon no od kovantug sikandin. Piru iddos duwon ingowollon nod povantug taddot id popiyod kandin, dos osengan din, mooggot woy waa en uhus diyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Konna vo si Moises man kos id boggoy koniyu taddon mgo Suhu? Piru waa en ahad sokkad koniyu no id tuman tadda. Su otik id tuman kow pa, dii kow nanoy od pomuhawang nod imatoy koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Na iddos mo‑uraan minuvu, id pon‑ikahi to, “Id losuran ka vos ayu! Ondoy man bos kos od pomuhawang nod imatoy kikow?” ");
INSERT INTO oboNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kahi ni Disas to, “Sokkad da kos mokososoobbun id puungan ku riyon to Allow't Kod‑imolloy, piru dii row idda od kotanggap woy nosoobbuwan kow. ");
INSERT INTO oboNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Piru ahad sikiyu, id puung kow man diyon to Allow't Kod‑imolloy. Oyya su id suhu kow ni Moises, no ko‑ilangan nod tupuwan iddos mgo anak dow riyot iko‑waun allow pomon to kodtobbow. (Inin botasanon, waa id tigkanoy ki Moises, ko konna, pomon poron diyon to kovuyyahan dow.) De‑en ahad od pokosasang idda to Allow't Kod‑imolloy, id pontotupu kow. ");
INSERT INTO oboNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Otik idda en kos id puungan dow riyon to Allow't Kod‑imolloy amoy'd kotuman dow iddos Suhu ni Moises moka‑atag to sokkad no sakup to lawa, mambot od langot kow koddi, su no‑uliyan man iddos tivuk no lawa taddot minuvu riyon to Allow't Kod‑imolloy? ");
INSERT INTO oboNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yo kowd hukum to minuvu ukit taddot od kokita row, ko konna, hukumi row sikandin ukit to motallong woy ollog no kodhukum.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na, duwon mgo minuvu no toho Jerusalem no mid ikahi to, “Konna vo ika me‑en no minuvu kos od puhawangon tod imatoy to mgo ponguu ta? ");
INSERT INTO oboNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ka‑ay ron me‑en sikandin ko‑ungkay no id nonaw to mo‑uraan minuvu. Mambot waa man sikandin sugga‑a taddot mgo ponguu? Nokosaddoo ran don ayu no sikandin en kos Mesiyas? ");
INSERT INTO oboNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Piru otid inguma ron iddos Mesiyas, waa en od pokosaddoo ko toho ingkon sikandin. Piru ini mohon minuvu, nosorollan ta rad man ko ingkon sikandin id pomon.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Na laggun tid nonaw sikandin diyot templo, id ooseng sikandin to monokkaa, kahi rin to, “Kunan dow ko nokilaa a nikiyu woy nosorollan dow ko ingkon a id pomon. Piru iyon mooggot, waa a mid undini pomon to koddin id kopi‑i, su iddos id popiyod koddi, sikandin en kos bonnaan Monama no waa row nokilaa. ");
INSERT INTO oboNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Piru siyak, nokokilaa a kandin, oyya su riyon a man id pomon woy sikandin en kos id popiyod koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pomon taddot id oseng ni Disas, od omotton dan nanoy sikandin, piru waa ran noko‑aku, oyyos waa pa man id inguma kos ollog no timpu. ");
INSERT INTO oboNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Piru ahad iling tadda, mo‑uraa rad no mgo minuvu kos id pomakoy kandin. Kahi ran to, “Sikandin don en ayu kos Mesiyas, oyyos waa ahad ondoy nod pokolampas taddot mgo mokososoobbun pinuungan din.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na, norinog to mgo Pariseo iddos kodposisipoy taddot mgo minuvu moka‑atag ki Disas, de‑en sikandan woy dos mgo ponguu to tohodbuwis, id ponsuhu ran iddos mgo tohodtamong to templo no od omotton sikandin. ");
INSERT INTO oboNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kahin Disas to, “Moobbava robbo kos timpu no od pokodduma ki, oyyos od livod ad man diyot id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Od nangkap kow koddi, piru dii ad nikiyu od kokita, su dii kow man od poko‑undiyon tod undiyonnan ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Na id po‑inturoy iddos mgo ponguu to mgo Judio, kahi ran to, “Ingkon ayu od undiyon inin minuvu no dii tad sikandin od kokita? Saddoo ayu kod undiyon sikandin to mgo duma ta no Judio no id pon‑ubpa riyot mgo ingod to Griego woy od nonaw sikandin dutun. ");
INSERT INTO oboNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ondan kos kohulugan taddot id oseng din no, ‘Od nangkap kow koddi, piru dii ad nikiyu od kokita,’ woy ‘Dii kow od poko‑undiyon tod undiyonnan ku’?” ");
INSERT INTO oboNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na riyot kotompusan no allow taddon pista, no idda en kos allow no duwon dakkoon koru‑anon atag to mgo Judio, id lohinat si Disas woy mid ooseng sikandin to monokkaa. Kahi rin to, “Iddos ahad ondoy koniyu nod kotokkangan, undini kow to koddi su od po‑inommon ku sikiyu. ");
INSERT INTO oboNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Oyya su no‑ikahi riyot Nosulat no Kahit Monama no, ‘Iddos minuvu nod pomakoy koddi, duwon ma‑antoy'n oweg no od aus pomon diyot ginawa rin.’ ” ");
INSERT INTO oboNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Dos kohulugan taddot id oseng ni Disas no “ma‑antoy'n oweg,” idda en so Ispiritu to Monama no id boggoy riyot od pomakoy kandin. Su iddon timpu, waa pa id boggoy kandan iddos Ispiritu to Monama, oyyos waa pa man novatun si Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na, to norinog taddot mgo minuvu iddos id oseng ni Disas, mid ikahi iddos duma to, “Ini ron en kos Propeta no id oongatan ta.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Duwon mandad mid ikahi to, “Sikandin en kos Mesiyas.” Piru mid ikahi mandad iddos duma to, “Konna, su iddos Mesiyas, konna od pomon diyot prubinsya to Galilea. ");
INSERT INTO oboNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Oyyos no‑ikahi riyot Nosulat no Kahit Monama no iddos Mesiyas, od pomon en diyot koubbaran ni Harin David woy od tobbow sikandin diyot Betlehem no id ubpan ni Harin David.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","De‑en nokod‑osso‑ossa kos poomdom taddot mgo minuvu moka‑atag ki Disas woy nokodba‑ad sikandan. ");
INSERT INTO oboNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Iddos duma, od kopiyan nod ammot kandin, piru waa en ahad sokkad kandan no noko‑aku nod puung tadda. ");
INSERT INTO oboNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","To id ponlivod don iddos mgo tohodtamong to templo, id inturan sikandan taddot mgo Pariseo woy taddot mgo ponguu to tohodbuwis, kahi ran to, “Mambot waa row sikandin piyodda rini?” ");
INSERT INTO oboNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kahi taddot mgo tohodtamong to, “Waa poron minuvu no nokononaw iling kandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mid ikahi iddos mgo Pariseo to, “Mambo, ahad bos sikiyu no‑okalan din mandad? ");
INSERT INTO oboNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Sikami no mgo Pariseo woy dos mgo ponguu to Judio, duwon bo ahad sokkad konami no id pomakoy kandin? ");
INSERT INTO oboNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wora! Idda ra en so mgo minuvu no waa koovottan to mgo Suhu ni Moises kos id pomakoy kandin. Od kosahapan dan en kos silut to Monama!” ");
INSERT INTO oboNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na, si Nicodemo no noko‑undiyon dangan to ki Disas woy sokkad mandad taddot mgo Pariseo, mid ikahi sikandin diyot mgo duma rin to, ");
INSERT INTO oboNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Konna vo supak diyot keton botasanon no od hukuman no nokosaa iddos minuvu, ahad waa pa no‑intud‑inturi amoy'd kosorollan kos nopuungan din?” ");
INSERT INTO oboNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mid tavak sikandan to, “Te, toho Galilea ka mandad? Ooyyariyu man tod basa iddos nosulat no Kahit Monama woy od kosorollan du no waa en propeta no id pomon diyot Galilea!” ");
INSERT INTO oboNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nopongnga idda, id pon‑uli ran don langun. ");
INSERT INTO oboNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Na si Disas, mid undiyon to Buvungan to mgo Olibo. ");
INSERT INTO oboNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","So‑op no allow to sollom poron, id livod mandon sikandin diyot templo. Dutun, id livuungan sikandin to mo‑uraan minuvu. De‑en mid unsad sikandin woy id nonaw kandan. ");
INSERT INTO oboNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na, duwon id inguma no mgo tohodnonaw to Suhu ni Moises woy mgo Pariseo. Id piyod dan iddos sokkad no molitan no nosullan no id laayuk to konna rin sawa, woy id po‑isau ran sikandin diyot mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kahi ran ki Disas to, “Tohodnonaw, inin molitan, nosullan no id laayuk to konna rin sawa. ");
INSERT INTO oboNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Otik diyot mgo Suhu ni Moises, ollog en nod lumbahon to batu inin molitan taman tod patoy. Na, ondan man kos od ko‑oseng du moka‑atag ka‑ay?” ");
INSERT INTO oboNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Id ungketen dan idda tid intud, su id kopi‑i ran nod pokosahad si Disas amoy duwon saa no id poko‑uug dan kandin. Piru iyon id puungan ni Disas, id sosulat sikandin diyot livuta ukit to tintoddu rin. ");
INSERT INTO oboNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Laggun to ponayun dan od ointud, id lohinat si Disas woy mid ikahi to, “Ko ondoy koniyu kos waa saa, sikandin kos unna nod lumbag to batu ka‑ay'n molitan.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","To nopongnga rin osenga idda, id sosulat mandon sikandin diyot livuta. ");
INSERT INTO oboNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","To norinog dan idda, posid‑awa ran no id tigkanoy to mgo buyyag taman to iyon dobbo nosama, si Disas woy dos molitan nid loohinat dutun. ");
INSERT INTO oboNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Na, id lohinat mandon si Disas woy mid ikahi kandin to, “Uri, ingkon don sikandan? Waa vo ahad sokkad kandan no id silut kikow?” ");
INSERT INTO oboNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mid tavak iddos molitan to, “Wora, Sir.” Kahin Disas to, “Dii a mandad od silut kikow. Na, uli kad bo woy yo kad od avoy nod puung to saa.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Na mid ikahi mandon si Disas diyot mgo minuvu to, “Siyak kos ko‑owangan nod taddow to mgo minuvu ka‑ay to ampow't ingod. Dos od dumoruma koddi, dii ron sikandin od oubpa riyot mosukirom, su riyon don man to kandin iddos ko‑owangan nod pokovoggoy to umuun waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Piru to norinog idda to mgo Pariseo, id apuu ran sikandin no mid ungketen to, “Konna ollog nod pongimbonnalon kos id oseng du, su sikkow ra en kos id posivonnaa atag to ko‑ugolingun du.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mid tavak si Disas to, “Ahad pe‑en siyak da kos id posivonnaa moka‑atag to ko‑ugolingun ku, bonnaa en kos id oseng ku, oyyos nosorollan ku ko ingkon a mid pomon woy ko ingkon a od undiyon. Piru sikiyu, waa kow nokosaddoo tadda. ");
INSERT INTO oboNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Dos koniyun kodhukum, po‑ukit idda to minuvu ka‑ay to ampow't ingod. Piru siyak, waa a mid hukum to ahad ondoy. ");
INSERT INTO oboNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Piru otid poponog a man to kodhukum, ollog en idda, su konna ra siyak kos od hukum, ko konna, oruwa koy taddot Amoy ku no id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nosulat diyot koniyun mgo Suhu no id sulat ni Moises, no otik nokod‑iling kos kodposivonnaa taddot oruwon minuvu, ollog en idda nod pongimbonnalon. ");
INSERT INTO oboNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","De‑en mooggot kos koddin kodposivonnaa moka‑atag to ko‑ugolingun ku, oyyos duwon oruwon id posivonnaa, siyak woy dos Amoy ku no id popiyod koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Na mid ikahi iddos mgo Pariseo to, “Ingkon man kos amoy ru?” Mid tavak si Disas to, “Waa kow nokokilaa ko ondoy kos Amoy ku woy ko ondoy a. Otik nokokilaa kow pa nanoy koddi, od kokilaa row mandad iddos Amoy ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ini langun, id nonaw ni Disas diyot templo no riyon lomig to morani tod tootawwan to soopi. Piru waa en ahad sokkad no noko‑aku nid ammot kandin, oyyos waa pa man id inguma kos timpu rin. ");
INSERT INTO oboNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Na id osengan mandon ni Disas iddos mgo ponguu to Judio, kahi rin to, “Siyak, asow ad od tanan koniyu. Ahad od nangkap kow koddi, dii ad nikiyu od kokita, oyyos konna kow en od poko‑undiyon tod undiyonnan ku. Mattag kow ron od poomatoy no waa noposinsyan kos mgo saa row.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","De‑en id po‑inturoy ran to, “Ondan man kos kohulugan taddot id oseng din no konna ki kun od poko‑undiyon tid undiyonnan din? Od pongoggot ayu sikandin?” ");
INSERT INTO oboNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kahin Disas to “Sikiyu, toho ka‑ay kow to ampow't ingod, piru siyak, toho riyon a to datas to langit. Waa ki nokod‑iling, su sakup kow man ka‑ay't ingod, piru siyak, konna. ");
INSERT INTO oboNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Id ikahi ku koniyu no mattag kow ron od poomatoy no waa noposinsyan kos mgo saa row, su idda en kos od kotomanan otik konna kow od pomakoy no siyak en iddos noponudtuu kud koniyu ko ondoy a.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kahi ran to, “Mambo, ondoy ka man bos?” Mid tavak si Disas to, “Konna vo noponudtuu kud man idda koniyu pomon poron to tigkonayan to kodnonaw ku? ");
INSERT INTO oboNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mo‑uraa pa nanoy kos od ko‑oseng ku moka‑atag to kodhukum ku koniyu. Piru iddos od osengon ku riyot langun no minuvu, idda en so norinog ku pomon diyot kandin no id popiyod koddi, su mooggot en iddos kahi rin.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Waa sikandan nokaabbot no iddos id oseng din, moka‑atag idda to Monamon Amoy rin. ");
INSERT INTO oboNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","De‑en mid ikahi si Disas to, “Otik siyak no Anak to Minuvu, id pakpak a nikiyu poratas diyon to krus, od kokilaa row no siyak en iddos id oseng ku koniyu ko ondoy a. Od kosorollan dow mandad no waa a mid ikahi woy id puung to ahad ondan no id pomon to koddi ra no poomdom, ko konna, idda en so id popuungan woy id poponudtuu koddi to Amoy ku. ");
INSERT INTO oboNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iddos id popiyod koddi, inaayun a nikandin dumanni woy waa a en nikandin tonani. Oyya su iyon ku inaayun od puungan, idda en so id kahaa‑i rin.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na, to norinog to mgo minuvu iddos id oseng ni Disas, mo‑uraa kos id pomakoy kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Na kahin Disas diyot mgo Judio to, “Otik ponayun kow nod ikuu taddot nonaw ku, mooggot en no sikiyu kos mgo tinodduwan ku. ");
INSERT INTO oboNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Od kosorollan dow iddos kovonnaan moka‑atag to Monama woy iddon kovonnaan, od boggoy koniyu to kolegguangan.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mid tavak iddos mgo minuvu to, “Te! Mgo koubbaran koy man ni Abraham, woy waa koy poron no‑uripon to ahad ondoy. De‑en mambot id ikahi ka no od boggayan koy nikkow to kolegguangan?” ");
INSERT INTO oboNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kahin Disas to, “Bonnaavonnaa nod ikohiyon ku, no iddos ahad ondoy nod puung to saa, no‑uripon sikandin to saa. ");
INSERT INTO oboNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ponunggeleng, iddos uripon, konna sikandin inaayun no sakup diyot sokkad no pomilya, piru iddos anak, sakup en sikandin taddot pomilya taman to waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","De‑en otik iddos Anak to Monama kos od boggoy koniyu to kolegguangan, duwon en kolegguangan dow. ");
INSERT INTO oboNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nokosaddoo a no koubbaran kow ni Abraham, piru id pomuhawang kow nod imatoy koddi, oyyos waa row man id pomuwa riyot pusung dow iddos nonaw ku. ");
INSERT INTO oboNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Dos id ponudtuu ku koniyu, idda en so id pokita koddi to Amoy ku, piru sikiyu, iyon dow moho od puungan, iddos norinog dow pomon diyot amoy row.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mid tavak sikandan to, “Iddos amoy roy, si Abraham!” Kahin Disas to, “Otik mooggot en no koubbaran kow ni Abraham, od puungan dow nanoy kos moppiya iling kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Piru iyon dow moho od ingowollon, iddos kod‑imatoy koddi, su id ponudtuu ku koniyu iddos kovonnaan no norinog ku pomon diyon to Monama. Waa en nokopuung si Abraham iling taddot id puungan dow. ");
INSERT INTO oboNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Oyya su iyon dow id puungan, iddos id puungan to amoy row.” Kahi ran to, “Te! Konna koy mgo anak to daan, su sokkad da kos Amoy roy no idda en so Monama.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kahin Disas to, “Otik bonnaa en no iddos Monama kos Amoy row, od ginowannan a nanoy nikiyu, su id pomon a man diyot Monama. Waa a mid undinit ingod pomon to koddin id kopi‑i, ko konna, sikandin kos id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mambot dii kow moho od pokaabbot taddot osengan ku? Od ko‑ungketen kow ve‑en su dii kow man od kopiyan nod tanggap taddot id oseng ku. ");
INSERT INTO oboNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Si Moivuyan kos amoy row. Ko ondan kos morat no id kopi‑i rin, idda en mandad kos od puungan dow. Oyyos pomon poron to tigkonayan, mongimatoy sikandin woy'd supak to kovonnaan, oyyos waa en kovonnaan diyot kandin. Bouhuson sikandin, su idda me‑en kos botasan din woy id pomonnan mandad sikandin to langun no uhus. ");
INSERT INTO oboNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Piru siyak, kovonnaan kos id ponudtuu ku koniyu woy idda en kos unayan no dii kow od pomakoy koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ondoy man koniyu kos od pokoposivonnaa no nokopuung a to saa? Waa en! Na, mambot dii kow od pomakoy koddi otid ponudtuu a to kovonnaan? ");
INSERT INTO oboNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iddos mgo minuvu no sakup to Monama, od pomakoy en to kahi rin. Piru pomon to konna kow man mgo sakup to Monama, idda en kos unayan no dii kow od pomakoy.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Na id ikohiyan sikandin taddot mgo Judio to, “Ollog bos en iddos id oseng doy no iling ka to toho Samaria woy id losuran ka to busow!” ");
INSERT INTO oboNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mid tavak si Disas to, “Waa a losuri to busow. Iyon id puungan ku, id posivontuhan ku iddos Amoy ku, piru sikiyu, id poddisokkan a moho nikiyu to kod‑ontong. ");
INSERT INTO oboNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Waa ingowollon ku nod posivantug to koddin ko‑ugolingun. Piru duwon od posivantug koddi woy sikandin en kos od hukum koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Bonnaavonnaa nod ikohiyon ku koniyu, no iddos ahad ondoy nod ikuu taddot nonaw ku, dii en od patoy.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kahi taddot mgo Judio to, “Ko‑ungkay, waa kodduworuwa roy no id losuran ka en to busow! Su ahad si Abraham woy dos mgo propeta, id poomatoy ron man. Piru id oseng ka moho, no iddos ahad ondoy nod tuman taddot nonaw ru, dii en od patoy. ");
INSERT INTO oboNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ondan, lampas ka pa ki Abraham no kovuyyahan doy woy taddot langun no propeta no id poomatoy ron? Ondan man bos kos kod‑ontong du to ko‑ugolingun du?” ");
INSERT INTO oboNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mid tavak si Disas to, “Otik siyak kos od posivantug to ko‑ugolingun ku, waa koru‑anon tadda. Piru iyon id posivantug koddi, idda en so Amoy ku no od tommanon dow no Monama row. ");
INSERT INTO oboNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Waa kow nokokilaa kandin, piru siyak, nokokilaa a. De‑en otid oseng a no waa ku sikandin nokilaa, od poko‑iling a mandad koniyu no bouhuson. Piru iddos kovonnaan, nokilaa ku en sikandin woy id tuman ku iddos suhu rin. ");
INSERT INTO oboNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nahaa iddos kovuyyahan dow no si Abraham, su id imman sikandin nod pokokita koddi to kod‑undini ku to ingod. De‑en to nokita rin ini, oray sikandin no nahaa.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kahi taddot mgo Judio to, “Te! Momonnu ru man nokita si Abraham no waa pa man id inguma to limmompuu kos idad du.” ");
INSERT INTO oboNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mid tavak si Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no to waa pa id tobbow si Abraham, duwon ad!” ");
INSERT INTO oboNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pomon tadda, id pomurut sikandan to batu amoy'd lumbahon si Disas. Piru id oollos sikandin diyot mo‑uraan minuvu taman to noko‑awa riyot templo. ");
INSERT INTO oboNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Laggun tid ipanow onsi Disas, nokita rin iddos minuvun butud pomon poron to kodtobbow rin. ");
INSERT INTO oboNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Na mid intud ki Disas iddos mgo tinodduwan din, kahi ran to, “Tohodnonaw, ondoy man kos nokosaa no id tobbow sikandin no butud? Sikandin bo o iddos amoy woy inoy rin?” ");
INSERT INTO oboNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mid tavak si Disas to, “Id tobbow sikandin no butud, konna pomon to kandin no saa o pomon to saa to amoy woy inoy rin, ko konna, amoy od kokita iddos kotuusan to Monama riyot kandin no umuu. ");
INSERT INTO oboNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Laggun to allow pa, ko‑ilangan nod puungan ta iddos id sanna taddot id popiyod koddi, su otid kovulli ron, worad od pokopuung. ");
INSERT INTO oboNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Oyyos laggun to ka‑ay a pa, siyak kos ko‑owangan nod taddow to mgo minuvu ka‑ay to ampow't ingod.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nopongnga rin osenga idda, id ilob sikandin diyot livuta woy id bovallan din idda no basak woy id daddas din diyot mata taddot butud. ");
INSERT INTO oboNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kahi rin to, “Undiyon ka to Linow't Siloe woy pondappug ka rutun.” (Dos kohulugan to Siloe, id popiyod.) De‑en mid undiyon iddos butud woy id pondappug, woy id uli sikandin nod pokokita ron. ");
INSERT INTO oboNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na, iddos mgo sumbaoy rin woy dos dumon nokokita kandin no id pokilimus dangan, id po‑inturoy ran no mid ungketen to, “Konna vo ini me‑en no minuvu iddos od ounsad nod pokilimus?” ");
INSERT INTO oboNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kahi taddot duma to, “Oyya, sikandin en!” Piru duwon duma nid ikahi to, “Eh konna, nokod‑iling da ayu kos boyo ran.” Na sikandin don en kos mid ikahi to, “Siyak en idda.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Purisu id inturan dan sikandin, kahi ran to, “Id monnu man nod pokokita kad?” ");
INSERT INTO oboNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mid tavak sikandin to, “Iddos minuvu no id ngoranan ki Disas, id bovaa sikandin to basak woy nopongnga, id daddas din idda ka‑ay't mata ku woy id po‑undiyon a nikandin to Linow't Siloe amoy od pondappug. De‑en id undiyon a woy id pondappug woy nokokita ad.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Id inturan dan mandon sikandin, kahi ran to, “Na, ingkon don bo iddon minuvu?” Mid tavak sikandin to, “Tove‑en.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Na, id piyod dan diyot mgo Pariseo iddos minuvun butud dangan. ");
INSERT INTO oboNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Oyya su Allow't Kod‑imolloy iddos kodbovaa ni Disas tat basak no id bawi rin taddot butud. ");
INSERT INTO oboNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","De‑en id inturan mandad sikandin to mgo Pariseo ko momonnu nod pokokita ron sikandin. Mid tavak sikandin to, “Id doddasan din to basak kos mata ku woy nopongnga, id pondappug a woy nokokita ad.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Na, duwon dumon mgo Pariseo no mid ikahi to, “Iddos minuvu nid puung ka‑ay, konna pomon diyot Monama, oyya su id supak man sikandin to mgo suhu moka‑atag to Allow't Kod‑imolloy.” Piru iddos duma, mid ikahi to, “Otik mosaasaa iddon minuvu, dii nanoy sikandin od pokopuung to mokososoobbu no iling ka‑ay.” De‑en nokodba‑ad don sikandan. ");
INSERT INTO oboNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Id intud mandon iddos mgo Pariseo taddot butud dangan, kahi ran to, “Su id bowiyan din man kos mata ru, ondan bo kos od ko‑oseng du moka‑atag kandin?” Kahi taddot minuvu to, “Atag koddi, sokkad sikandin no propeta.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Piru iddos mgo ponguu to Judio, dii en od pomakoy no butud sikandin dangan woy ko-ungkay, od pokokita ron. De‑en id po‑umow ran iddos amoy woy inoy rin. ");
INSERT INTO oboNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Na, id inturan sikandan taddot mgo ponguu, kahi ran to, “Anak dow ve‑en inin minuvu? Bonnaa vo no butud sikandin pomon poron to kodtobbow rin? Id monnu man nod pokokita ron sikandin?” ");
INSERT INTO oboNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mid tavak iddos amoy woy inoy rin to, “Oyya, anak doy en, woy bonnaa en no butud sikandin pomon poron to kodtobbow rin. ");
INSERT INTO oboNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Piru ko id monnu nod pokokita ron sikandin woy ko ondoy kos id bawi to mata rin, ika en kos waa roy nosorolli. Intura row sikandin su duwon don man poddu rin.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Idda en kos tavak taddot amoy woy inoy rin, oyyos novaakkan sikandan taddot mgo ponguu to Judio. Su iddos mgo ponguu, nokodsokkad no iddos ahad ondoy nod ikahi no si Disas en kos Mesiyas, dii ron od kilaannon no sakup diyot simba‑an to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Na, idda en kos unayan no mid ikahi iddos amoy woy inoy rin to, “Intura row sikandin su duwon don man poddu rin.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","De‑en id po‑umow mandon taddot mgo ponguu to Judio iddos butud dangan woy id ikohiyan dan to, “Ponudtuu ru kos bonnaa, oyyos ka‑ay ki to isowwan to Monama. Su otik sikami, nosorollan doyd no iddos minuvu nid bawi kikow, mosaasaa.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kahi taddot minuvu to, “Waa a nokosaddoo ko mosaasaa vo sikandin o konna. Iyon ku ra nosorollan no siyak, butud dangan, piru ko‑ungkay, od pokokita ad!” ");
INSERT INTO oboNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Na mid intud mandon sikandan to, “Ondan man kos id puungan din kikow? Id monnu rin man tid bawi kos mata ru?” ");
INSERT INTO oboNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Id tavak sikandin to, “Id ponudtulan kud en sikiyu, piru diid kow mohod pominog. Mambot od ointud kow pa mandon? Ondan, id kopi‑i row mandad nod kovovallan no mgo tinodduwan din?” ");
INSERT INTO oboNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Na, nolingasa ran woy id boliyungan dan sikandin tid ikahi to, “Te, sikkow en kos tinodduwan din, piru sikami, mgo tinodduwan koy ni Moises! ");
INSERT INTO oboNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nosorollan doy no mid ikahi dangan iddos Monama ki Moises, piru iddon minuvu, waa en moho saddoo roy ko ingkon sikandin id pomon.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kahi taddot minuvu to, “Od kosoobbuwan a moho koniyu! Sikandin kos nokovawi to mata ku, piru waa kow nokosaddoo ko ingkon sikandin id pomon. ");
INSERT INTO oboNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nosorollan ta no diid tavak kos Monama taddot dosalon to minuvun mosaasaa. Piru od tovakon din en iddos mopompomakoy woy'd puungan din iddos id kopi‑i rin. ");
INSERT INTO oboNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pomon poron to tigkonayan to ingod, waa ki pa nokorinog no duwon od pokovawi to minuvun butud pomon poron to kodtobbow rin. ");
INSERT INTO oboNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","De‑en otik waa pa sikandin id pomon diyot Monama, konna en nanoy sikandin od pokopuung to iling ka‑ay.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kahi taddot mgo ponguu to Judio to, “Pomon poron to kodtobbow ru, id dakkoo ka riyot saa woy ko‑ungkay, od pa‑awoy‑awoy ka mohod nonaw konami!” Idda ron en, id dorok dan sikandin pomon diyot simba‑an to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na, norinog ni Disas iddos notomanan taddot butud dangan no id dorok pomon diyot simba‑an to mgo Judio. De‑en id nangkap sikandin ni Disas woy to nokita rin don, id inturan din, kahi rin to, “Id pomakoy ka vo taddot Anak to Minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mid tavak iddos minuvu to, “Sir, ponudtuli a ko ondoy sikandin amoy'd pomakoy a kandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kahin Disas to, “Nokita rud sikandin, oyyos sikandin don en inis id tongko kikow ko‑ungkay.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Na idda ron en, mid lingko‑od iddos minuvu riyot isowwan ni Disas woy kahi rin to, “Longaggon, id pomakoy ad kikow.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kahin Disas to, “Iyon unayan no mid undini a to ampow't ingod amoy od hukum ko ondoy kos nokokilaa to Monama woy dos wora. Su iddos waa nokokilaa kandin, noko‑iling sikandan to mgo butud to kovonnaan woy od bowiyan ku sikandan amoy'd pokokita. Piru iddos od po‑uvag‑uvag no nokokilaa to Monama, id pokita ku no sikandan, mgo butud poron.” ");
INSERT INTO oboNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Na, duwon mgo Pariseo riyot morani rin no nokorinog taddot id oseng din woy id inturan dan sikandin, kahi ran to, “Ondan? Iyon du vod osengon no ahad sikami, mgo butud mandad?” ");
INSERT INTO oboNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kahin Disas kandan to, “Otik id tanggap dow no noko‑iling kow to mgo butud to kovonnaan, worad nanoy saa row. Piru pomon tod osengon dow man no od pokokita kow su id po‑uvag‑uvag kow no duwon koovottan dow to kovonnaan, de‑en ponayun pe‑en iddos saa row.” ");
INSERT INTO oboNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Na, duwon ponunggelengan ni Disas, kahi rin to, “Bonnaavonnaa nod ikohiyon ku koniyu, no iddos minuvu nod usok no dii od ukit diyot sobbangan taddot toril to mgo karnero woy iyon din od puungan, od saampow tadda, iddon minuvu, tokawon woy tulisan. ");
INSERT INTO oboNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Piru iddos tohodtamong to karnero, od ukit en to sobbangan. ");
INSERT INTO oboNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Od lukatan sikandin to tohodbantoy to sobbangan woy dos mgo karnero, od pominog to bawos taddot id tamong kandan. Od umawon din iddos ngaran taddot mgo karnero rin woy od tinundug dan kandin nod poleggua. ");
INSERT INTO oboNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Otid pokoleggua ran don langun, sikandin kos od unna kandan woy dos mgo karnero, od ikuu kandin, oyyos nokilaa ran man iddos bawos din. ");
INSERT INTO oboNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Iddon mgo karnero, diid ikuu to osson minuvu no waa ran nokilaa, ko konna, od pomaahuy ra en baling sikandan, oyyos waa ran man nokilaa iddos bawos din.” ");
INSERT INTO oboNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Id ituu ni Disas kandan inin ponunggelengan, piru waa sikandan nokaabbot to kohulugan ka‑ay. ");
INSERT INTO oboNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","De‑en mid ikahi mandon si Disas to, “Bonnaavonnaa nod ikohiyon ku koniyu, no siyak kos sobbangan nod ukitan to mgo karnero. ");
INSERT INTO oboNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Dos id undini no noko‑unna koddi no mid nonaw to uhus, sikandan iddos mgo tokawon woy tulisan, piru waa en id pominog kandan iddos mgo karnero. ");
INSERT INTO oboNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Siyak kos sobbangan. Dos ahad ondoy nod usok ukit koddi, od kotobbus en. Od poko‑iling sikandin to karnero nod poko‑usok woy'd pokoleggua amoy od nangkap to moppiyon sobsavan. ");
INSERT INTO oboNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Iddos tokawon, iyon dontulon din, idda ra en so kodponakow, kod‑imatoy woy koddora‑at. Piru siyak, mid undini a to ingod amoy od boggoy to umuu no lampas kos kopiyannoy. ");
INSERT INTO oboNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Siyak kos moppiyon tohodtamong to karnero. Dos moppiyon tohodtamong, nopanoy nod patoy atag da en to mgo karnero rin. ");
INSERT INTO oboNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Iddos minuvu nod boyaran da amoy'd tamong to mgo karnero, konna sikandin moppiyon tohodtamong woy konna mandad sikandin kos komunoy taddot mgo karnero. Purisu otid pokokita sikandin to movuut no tuyyang to movonnos nod inguma, od tonanan din da en baling iddos mgo karnero, su od paahuy sikandin. De‑en od pomuwoddon iddos mgo karnero woy'd pokodsuwoysuwoy ron. ");
INSERT INTO oboNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Od paahuy iddon minuvu, oyyos id boyaran da me‑en sikandin woy dii sikandin od kosowkuu taddot mgo karnero. ");
INSERT INTO oboNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Siyak kos moppiyon tohodtamong. Su iling taddot Amoy ku woy siyak no nokodsorolloy ron oraroy, nosorollan ku iddos koddin mgo karnero woy nosorollan a mandad nikandan, woy nopanoy a nod patoy atag da en kandan. ");
INSERT INTO oboNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na, duwon dumon mgo karnero ku no waa pa nosakup ka‑ay'n toril. Ko‑ilangan nod po‑usokkon ku mandad sikandan woy od pominoggon dan kos koddin bawos. De‑en od kosokkad don sikandan woy sokkad da kos tohodtamong dan. ");
INSERT INTO oboNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ini en kos unayan no id ginowannan a to Amoy ku, su nopanoy a nod boggoy to umuu ku woy kopongnga, od kovadnow a. ");
INSERT INTO oboNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Waa minuvu nod poko‑imatoy koddi otik dii ku id boggoy kos umuu ku. Su duwon kotungud ku no id boggoy ini woy duwon mandad kotungud ku to kodbadnow ka‑ay, oyyos ini en kos id suhu koddi to Amoy ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na pomon taddot id oseng ni Disas, nokodba‑ad mandon iddos mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mo‑uraa kandan kos mid ikahi to, “Eh, inin minuvu, od busawon don su id losuran to busow! De‑en mambo man tod pominoggon dow pa sikandin?” ");
INSERT INTO oboNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Piru iddos duma, mid ikahi to, “Konna ini osengan to minuvu no id losuran to busow. Duwon bo busow nod pokovawi to minuvun butud amoy'd pokokita?” ");
INSERT INTO oboNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na, duwon pista riyot Jerusalem nod ngoranan no pista to Kod‑upiya to templo, woy iddon timpu, timmohonnow. ");
INSERT INTO oboNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Diyon mandad si Disas to templo woy id oipanow sikandin diyot Balkon ni Solomon. ");
INSERT INTO oboNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Id livuungan sikandin to mgo ponguu to Judio, woy kahi ran to, “Kannu ru taman id ollos konami ko ondoy ka? Ponudtuli koy to mooggot, sikkow ve‑en kos Mesiyas?” ");
INSERT INTO oboNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mid tavak si Disas to, “Id ponudtulan kud sikiyu, piru dii kow me‑en od pomakoy. Iddos mgo mokososoobbu nid puungan ku ukit to kotungud to Amoy ku, idda en kos od posivonnaa ko ondoy a. ");
INSERT INTO oboNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Piru dii kow en od pomakoy, oyyos konna ku sikiyu mgo karnero. ");
INSERT INTO oboNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Dos mgo karnero ku, od pominog en to koddin bawos. Nokilaa ku sikandan woy od ikuu ran koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Id boggayan ku sikandan to umuun waad tomanon woy dii en sikandan od silutan to kopotayan. Waa ahad ondoy nod poko‑ahaw kandan pomon dinit bollad ku. ");
INSERT INTO oboNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Iddos Amoy ku no id boggoy kandan dinit koddi, motuus sikandin to langun, woy waa ahad ondoy nod poko‑ahaw kandan pomon diyot bollad to Amoy ku. ");
INSERT INTO oboNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Oyya su iddos Amoy ku woy siyak, sokkad da.” ");
INSERT INTO oboNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","To norinog idda taddot mgo Judio, id pomurut mandon sikandan to mgo batu amoy'd lumbahon sikandin. ");
INSERT INTO oboNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Piru mid ikahi si Disas to, “Mo‑uraa kos id pokita ku koniyu no moppiya no id popuungan koddi to Amoy ku. Na, ingkon musing taddon mgo pinuungan kos unayan nod lumbahon a nikiyu to batu?” ");
INSERT INTO oboNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kahi ran to, “Dii roy sikkow od lumbahon to batu pomon to moppiyon pinuungan du, ko konna, pomon to kodsumpalit du to Monama! Su od ikohiyon du moho no Monama ka, no minuvu ka ra man nanoy!” ");
INSERT INTO oboNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kahin Disas to, “Duwon nosulat diyot koniyun mgo Suhu no id ikahi to Monama riyot mgo tohodhukum dangan no mid ungketen to, ‘Mgo monama kow.’ ");
INSERT INTO oboNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nosorollan ta no iddos Nosulat no Kahit Monama, dii en od kovovaawan. De‑en otik iddos mgo minuvu no id ikohiyan to Monama, id ngoranan din sikandan no ‘mgo monama,’ ");
INSERT INTO oboNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","na mambot id oseng kow no kodsumpalit iddos id ikahi ku no, ‘Anak a to Monama?’ Oyyos siyak kos id aam din woy id popiyod ka‑ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Otik waa ku puungi iddos id popuungan taddot Amoy ku, yo kow'd pomakoy koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Piru ko id puungan ku iddos id popuungan to Amoy ku, na pomokaya row iddos mokososoobbun pinuungan ku, ahad dii kow od pomakoy taddot id ikahi ku, su amoy od kosorollan dow no iddos Amoy ku, ka‑ay en to koddi woy siyak mandad, diyon to kandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Id kopi‑i ran nanoy nod omotton mandon si Disas, piru noka‑awa ron sikandin. ");
INSERT INTO oboNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Na, id ipanow si Disas nid livod diyot dipaa to Oweg to Jordan no riyon en id bovoutismu dangan si Juan. Woy id oubpa pa sikandin dutun. ");
INSERT INTO oboNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mo‑uraan minuvu kos mid undiyon to kandin woy id po‑ikohiyoy ran to, “Waa nokopuung si Juan to mgo mokososoobbu, piru iddos langun no id oseng din moka‑atag ka‑ay'n minuvu, bonnaa en.” ");
INSERT INTO oboNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na rutun, mo‑uraa kos mid pomakoy ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Na, duwon sokkad no minuvu nod kovohokan no id ngoranan ki Lazaro. Sikandin woy dos oruwon tobboy rin no si Maria woy si Marta, id oubpa riyot Betania. ");
INSERT INTO oboNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ini en no Maria iddos id daddas to pomammut diyot pa‑a tod Longaggon woy dos id punas tadda ukit to bowvuut uu rin. Na, novohokan iddos tobboy ran no si Lazaro. ");
INSERT INTO oboNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","De‑en id posugkawan dan si Disas, no iddos id ginowannan din no oukuy, novohokan. ");
INSERT INTO oboNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","To norinog idda ni Disas, mid ikahi sikandin to, “Iddos dontulon to bohok din, konna amoy'd patoy sikandin, ko konna, amoy id pokopokita iddos kotuusan to Monama woy'd koposivontuhan a no Anak din.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na, id ginowannan ni Disas iddos otollun toosuwod no onsi Marta, si Maria woy si Lazaro. ");
INSERT INTO oboNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Piru to norinog din no novohokan si Lazaro, waa sikandin go‑os id undiyon, ko konna, id oubpa poron sikandin daom to oruwon allow riyot lugaa nid ubpan din. ");
INSERT INTO oboNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nopongnga idda, mid ikahi sikandin diyot mgo tinodduwan din to, “Kuo kid, od undiyon ki mandon to prubinsya to Judea.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kahi taddot mgo tinodduwan din to, “Adi, Tohodnonaw! Konna vo nopilan pa man nod lumbahon ka nanoy to batu taddot mgo Judio rutun? Mambot od livod kid mandon dutun?” ");
INSERT INTO oboNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Mid tavak si Disas ukit to ponunggelengan, kahi rin to, “Yo kow'd kosowkuu, su dii ki en od komonnu. Konna vo duwon man sopuu‑oruwon uras no ma‑awang daom to sokkad no allow? De‑en otid ipanow kos minuvu no allow pa, dii en sikandin od pokorudsu, su ma‑awang pa man. ");
INSERT INTO oboNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Piru otid tivulli kos minuvu, od pokorudsu en sikandin, oyyos mosukirom woy waa me‑en suu rin.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Na ponayun mid ikahi si Disas to, “Nokotinuhon iddos oukuy ta no si Lazaro, piru od undiyon a amoy'd onnawon ku sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kahi taddot mgo tinodduwan din to, “Longaggon, otik nokotinuhon da sikandin, moppiya su od ko‑uliyan dad.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Id oseng dan idda, su kunan dan ko nokotinuhon da en si Lazaro, piru iyon bos kohulugan taddot id oseng din, no id patoy ron si Lazaro. ");
INSERT INTO oboNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","De‑en waa id tekko‑tekko si Disas to kodpaabbotlabbot kandan, kahi rin to, “Si Lazaro, id patoy ron. ");
INSERT INTO oboNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Woy moppiya no waa a riyot kodpatoy rin, su atag ini to koniyun kopiyannan amoy od mosalig pe‑en kos kopomakoy row koddi. Kuo kid, od undiyonnan ta sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Na si Tomas no iddos angga rin, Sopping, id osengan din iddos duma rin no mgo tinodduwan, kahi rin to, “Kuo kid en, od duma ki kandin, su otid imotayan man sikandin, od patoy ki mandad duma kandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","To kod‑inguma onni Disas diyot bonuwa to Betania, duwon id ponudtuu kandin no oppat don no allow ni Lazaro riyot lovongngan. ");
INSERT INTO oboNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Iddos Betania, mgo otollun kilometro ra pomon diyon to Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","De‑en mo‑uraa kos mgo Judio no toho Jerusalem no mid undiyon amoy od uus to ginawa onni Marta woy Maria pomon to kopotayan taddot tobboy ran. ");
INSERT INTO oboNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","To norinog ni Marta no od inguma ron si Disas, id leggua sikandin amoy'd tommu. Piru si Maria, id oubpa ra riyot baoy. ");
INSERT INTO oboNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","To nokita ron ni Marta si Disas, mid ikahi sikandin to, “Longaggon, otik ka‑ay ka ra nanoy, waa en id patoy iddos tobboy ku. ");
INSERT INTO oboNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Piru nokosaddoo a no ahad ko‑ungkay, od boggoy iddos Monama kikow to ahad ondan nod buyuwon du.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mid ikahi si Disas to, “Od kovadnow en iddos tobboy ru.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Kahin Marta kandin to, “Oyya en, nokosaddoo a nod kovadnow sikandin init morin allow.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Na kahin Disas to, “Siyak kos tohodbadnow woy id pomonnan to umuu. Iddos od pomakoy koddi, ahad pe‑en od patoy sikandin, duwon umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Dos ahad ondoy nod pomakoy koddi, duwon umuu woy dii ron en sikandin od patoy. Na Marta, od pomakoy ka vo ka‑ay?” ");
INSERT INTO oboNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mid tavak si Marta kandin to, “Oyya, Longaggon! Id pomakoy a en no sikkow kos Mesiyas woy Anak to Monama no id oongatan doy nod undinit ingod.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nopongnga osenga ni Marta idda, id livod sikandin diyot baoy ran woy id nona‑asan din iddos suwod din no si Maria. Kahi rin to, “Ka‑ay ron iddos Tohodnonaw, od po‑undiyonnon ka kun.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","To norinog idda ni Maria, mid lohinat sikandin woy id lukutlukut nid leggua amoy'd undiyon to ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iddon timpu, waa pa noko‑inguma si Disas diyot bonuwa, su riyon poron sikandin to id tommuwan ni Marta kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na, iddos mgo Judio no riyon to baoy amoy'd uus to ginawa onni Maria, nokita ran sikandin no id lukutlukut nid leggua. De‑en mid tinundug sikandan, su kunan dan kod undiyon sikandin to lobbong amoy'd pondaawit dutun. ");
INSERT INTO oboNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","To kod‑inguma ni Maria riyot ki Disas, id lingko‑od sikandin woy mid ikahi to, “Longaggon, otik ka‑ay ka ra nanoy, waa en id patoy iddos tobboy ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","To nokita ni Disas no id sinoggow si Maria ahad iddos mgo Judio nid duma kandin, immat id kommos kos pusung din woy no‑eruwan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Na mid intud si Disas, kahi rin to, “Ingkon man kos id lovongngan dow kandin?” Kahi ran to, “Kuo kid, Longaggon, amoy'd kokita ru.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Na, id sinoggow si Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","De‑en noko‑ikahi iddos mgo Judio to, “Ontongngi row, id dokollan ni Disas to ginawa si Lazaro.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Piru kahi taddot duma kandan to, “Otik novowiyan din iddos mata taddot butud, mambo man to waa sikandin nokotohoo to kopotayan ni Lazaro?” ");
INSERT INTO oboNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na, noheddam mandon ni Disas no immat id kommos kos pusung din to morani ron sikandin diyot lovongngan. Iddon lovongngan, sokkad no langub nid sobpongngan to dakkoon batu. ");
INSERT INTO oboNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kahin Disas to, “Po‑ibpit dow kos batu.” Piru si Marta no tobboy taddot id patoy, mid ikahi to, “Eh, Longaggon, od ngarog don ika, su oppat don man no allow rin duwot lobbong!” ");
INSERT INTO oboNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kahin Disas to, “Id ikohiyan kud sikkow no otid pomakoy ka, od kokita ru kos kotuusan to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Na, id po‑ibpit dan iddos dakkoon batu. Nopongnga, id langngag si Disas diyot datas to langit woy mid dasaa, kahi rin to, “Amoy ku, id posolamat a, su id dinog du kos koddin dosalon. ");
INSERT INTO oboNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nokosaddoo a no inaayun ka od pominog koddi. Piru id oseng ku ini atag ka‑ay't mgo minuvu no nolivuung, su amoy od pomakoy sikandan no sikkow en kos id popiyod koddi ka‑ay to ampow't ingod.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","To no‑oseng din idda, id pehes sikandin no mid ungketen to, “Lazaro, leggua ka!” ");
INSERT INTO oboNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na, id leggua si Lazaro no duwon poron bodbod no ogget diyot bollad woy pa‑a rin woy duwon poron tambun to bonnong din. Kahin Disas kandan to, “Okasa row kos ogget amoy'd poko‑ipanow sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Na, mo‑uraan Judio no id duma ongki Maria no nokokita taddot id puungan ni Disas, de‑en id pomakoy ron sikandan. ");
INSERT INTO oboNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Piru iddos duma, mid undiyon to mgo Pariseo woy id ponudtuu ran iddos id puungan ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","De‑en iddos mgo Pariseo woy dos mgo ponguu to tohodbuwis, id ponlivuung dan iddos langun no sakup to Mowwet no Hukumanan. To nolivuung don sikandan, id po‑ikohiyoy ran to, “Ondan man kos od puungan ta? Mo‑uraa ron kos mokososoobbun pinuungan ka‑ay'n minuvu. ");
INSERT INTO oboNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Otid podtohonon ta sikandin, od pomakoy iddos langun no minuvu no sikandin en kos hari to Israel. Na, ko ungketen, od lusud kos mgo toho Roma woy'd gobban dan kos templo, ahad inis tivuk no ingod ta!” ");
INSERT INTO oboNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Piru si Caifas no mowwet no ponguu to mgo tohodbuwis to iddon lahun, mid ikahi sikandin to, “Waa ron en moho mgo utok dow! ");
INSERT INTO oboNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Waa kow vo nokaabbot no moppiya pa no sokkad da no minuvu kos od patoy atag to langun amoy diid kohobba inis intirut ingod ta?” ");
INSERT INTO oboNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Waa rin idda osenga pomon to kandin da no poomdom, ko konna, pomon to sikandin kos mowwet no ponguu to mgo tohodbuwis to iddon lahun. Id po‑ikahi sikandin to Monama, no ko‑ilangan od patoy si Disas atag to langun no Judio. ");
INSERT INTO oboNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Woy konna ra atag to mgo Judio, ko konna, atag to langun no minuvu to Monama no nokodsuwoysuwoy ron amoy od kolimud woy'd kosokkad sikandan. ");
INSERT INTO oboNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pomon taddon allow, id pomuhawang iddos mgo ponguu to Judio no od imotayan si Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","De‑en dii ron inaayun od pokita si Disas diyot mgo Judio. Mid undiyon baling sikandin to ingod no morani to noka‑awoy‑awoy'n lugaa no riyot sokkad no bonuwa no id ngoranan to Efraim. Na, diyon sikandin id oubpa duma to mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","To asow ron iddos pista to Kodlihad to Ponolihan, mo‑uraan minuvu no id pomon diyot dumon bonuwa nod undiyon to Jerusalem amoy od puungan dan iddos botasanon to kodlinis to lawa ran to dii pa od inguma iddon pista. ");
INSERT INTO oboNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Id nangkap dan si Disas, piru waa ran nokita. De‑en id po‑inturoy ran nid ungketen to, “Diyot poomdom dow, od sakup ayu sikandin to pista?” ");
INSERT INTO oboNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Piru idda vos no timpu, tapoy ron duwon suhu pomon diyot mgo Pariseo woy riyot mgo ponguu to tohodbuwis, no iddos ahad ondoy no nokosaddoo ko ingkon si Disas, ko‑ilangan nod ponudtuu kandan amoy od ka‑ammot dan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na, annom no allow to waa pa id inguma iddos pista to Kodlihad to Ponolihan, mid undiyon si Disas to Betania no riyon en id ubpa si Lazaro no id badnow rin. ");
INSERT INTO oboNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Duwon id panoy ran no lavung atag ki Disas. Na, si Marta kos id sondad kandan woy sokkad taddot mid ka‑an duma ki Disas, si Lazaro. ");
INSERT INTO oboNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Si Maria mandad, id angoy to tongngot litru no pomammut no oray'n mahaa. Iddon pomammut, binovallan pomot pinomuwa nod ngoranan to nardo. Id daddas din idda riyot pa‑a ni Disas woy id punasan din to bowvuut uu rin. Na, no‑ompon to mammut iddos intirut baoy. ");
INSERT INTO oboNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Piru sokkad taddot mgo tinodduwan ni Disas no si Judas Iscariote no od boligya kandin diyot mori, id sawoy rin si Maria. ");
INSERT INTO oboNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Kahi rin to, “Kuu, konuhun! Maanmaan kos kontidad duwon! Mambo moho to waa id boligya ikon pomammut woy dos bayad, id boggoy riyot mgo worowora?” ");
INSERT INTO oboNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Waa rin osenga idda pomon to duwon ginawa rin nod tavang to mgo worowora, ko konna, pomon to tokawon sikandin. Oyyos sikandin man kos tohodsomad to soopi ran woy nooyami rin en nod loliyam tadda. ");
INSERT INTO oboNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Piru kahin Disas to, “Podtohona row ron sikandin, su id panoy rin inin pomammut atag to allow't kodlobbong koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Iddos mgo worowora, inaayun dow od koruma. Piru siyak, konna a nikiyu inaayun od koruma.” ");
INSERT INTO oboNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","To norinog to mo‑uraan Judio no riyon don si Disas to Betania, mid undiyon sikandan amoy od kokita ran si Disas woy si Lazaro nid badnow rin. ");
INSERT INTO oboNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","De‑en iddos mgo ponguu to tohodbuwis, id pomuhawang no od imotayan dan mandad si Lazaro. ");
INSERT INTO oboNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Oyyos pomon to kodbadnow kandin, mo‑uraa ron kos mgo duma ran no Judio no worad id posakup kandan, su id pomakoy ron ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na so‑op no allow, iddos mo‑uraan minuvu nid sakup taddon pista, nokorinog no od inguma ron si Disas diyot Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","De‑en mid angoy ran to mgo lokkoy to palmera woy id leggua ran diyot bonuwa amoy'd tommu kandin. Pomon to dakkoon kahaan dan, id pehes dan no mid ungketen to, “Od doongon kos Monama! Od posivontuhan ta kos id popiyod to Monama nod Longaggon! Od doongon ta iddos Hari to Israel!” ");
INSERT INTO oboNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na, nokita ni Disas no duwon natit asnu woy idda en kos id sokayan din. Ukit taddot id puungan din, notuman iddos no‑ikahi riyot Nosulat no Kahit Monama no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sikiyu no mgo toho Sion, yo kow'd kovaakki. Ontongngi row man, od inguma ron kos hari row no id sakoy to natit asnu.” ");
INSERT INTO oboNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","To iddon timpu, waa pa nokaabbot iddos mgo tinodduwan din to kohulugan tadda. To novadnow woy novatun don si Disas, idda pa sikandan nokosampot no iddos id puungan dan kandin, idda vos en kos no‑ikahi riyot Nosulat no Kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na, iddos mo‑uraan minuvu nid duma ki Disas no nokokita taddot kod‑umow woy kodbadnow rin ki Lazaro riyot lovongngan, id poso‑ob dan pe‑en tid ponudtuu iddon notomanan. ");
INSERT INTO oboNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Idda en kos unayan no mo‑uraan minuvu kos mid tommu ki Disas, oyyos nokorinog dan man taddot mokososoobbun id puungan din. ");
INSERT INTO oboNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","De‑en id po‑ikohiyoy iddos mgo Pariseo to, “Ontongngi row man, worad id pokogaha ta, su iddos langun no minuvu, id dumoruma ron kandin!” ");
INSERT INTO oboNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na, duwon mandad mgo Griego no id pon‑undiyot Jerusalem amoy od simba to Monama timpu to pista. ");
INSERT INTO oboNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Id porani sikandan ki Felipe no toho Betsaida no sakup to Galilea. Kahi ran to, “Sir, id kopi‑i roy nanoy nod pokidkita ki Disas.” ");
INSERT INTO oboNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","De‑en mid undiyon si Felipe woy id ponudtulan din si Andres taddot id kopi‑i to mgo Griego, woy id porumannoy ran amoy od ponudtulan si Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Na mid ikahi si Disas kandan to, “Id inguma ron kos timpu no siyak no Anak to Minuvu, od posivontuhon ukit to kopotayan ku. ");
INSERT INTO oboNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Bonnaavonnaa nod ikohiyon ku koniyu, no otik dii id pomuwa iddos songo‑ngipon no bonni, dii en idda od tuvu woy diid mo‑uraa. Piru otik id pomuwa idda, iling tid patoy woy id lobbong, od tuvu en idda woy'd mo‑uraa. Na iling mandad tadda, otid patoy ad, od kovadnow a woy'd pokovoggoy to lammin umuu riyot mo‑uraan minuvu. ");
INSERT INTO oboNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Dos minuvu no iyon din da en id konuhuni iddos umuu rin, od koworan da en baling tadda. Piru iddos minuvu no diid konuhunan to umuu rin ka‑ay to ampow't ingod atag koddi, od pokotanggap to umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Iddos ahad ondoy nod kopiyan nod puung atag koddi, ko‑ilangan nod dumoruma koddi. Na ahad ingkon a, diyon en mandad sikandin, woy dos ahad ondoy nod puung atag koddi, od posivontuhan taddot Amoy ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Na ponayun mid ikahi si Disas to, “Ko‑ungkay, oray'n naaggow kos ginawa ku. Ondan ayu kos od dosalon ku? Od buyuwon ku vo riyot Amoy ku no id poleggua a nikandin pomon ka‑ay'n koosayan? Konna, su ini en kos unayan nid undini a to ingod amoy od ko‑ukitan ku idda.” ");
INSERT INTO oboNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Na mid dasaa si Disas diyot Amoy rin, kahi rin to, “Amoy ku, povontuhow kos ngaran du.” Idda ron en, duwon norinog dan no bawos pomon diyot datas to langit no mid ungketen to, “Id povantug kud en woy'd povontuhon ku en mandon ini.” ");
INSERT INTO oboNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","To norinog idda taddot mo‑uraan minuvu rutun, mid ikahi sikandan to, “Eh, id louhung.” Dos duma, mid ungketen to, “Duwon ponolihan no id oseng kandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Piru mid ikahi si Disas to, “Iddon bawos, konna atag koddi, ko konna, atag en koniyu amoy'd pomakoy kow. ");
INSERT INTO oboNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ini ron en kos timpu to kodhukum to Monama taddot mgo minuvu ka‑ay to ampow't ingod. Woy ini ron en kos timpu nod kotalu ron si Moivuyan no ponguu to mgo minuvu no diid pomakoy. ");
INSERT INTO oboNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Piru siyak, otik id pakpak ad woy id poratas diyon to krus, od poporoniyon ku ka‑ay't koddi iddos langun no minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Id oseng din idda, su amoy id posaddoo rin ko momonnu sikandin od patoy. ");
INSERT INTO oboNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Na mid ikahi kandin iddos mo‑uraan minuvu to, “Diyot mgo Suhu ni Moises, novasa roy no diid patoy iddos Mesiyas. De‑en mambot od oseng ka no ko‑ilangan id pakpak woy id poratas diyon to krus iddos Anak to Minuvu? Ondoy man bos kos Anak to Minuvu?” ");
INSERT INTO oboNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kahin Disas to, “Diid kouhoy, od kowora ron iddos ko‑owangan ka‑ay't koniyu. De‑en ipanow kow riyot ko‑owangan laggun to duma pa ini koniyu amoy dii kow od koso‑utan to mosukirom. Su iddos od ipanow riyot mosukirom, waa saddoo rin ko ingkon sikandin od undiyon. ");
INSERT INTO oboNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Purisu laggun to ka‑ay pa kos ko‑owangan, ko‑ilangan nod pomakoy kow amoy'd kosakup kow tadda.” Nopongnga rin osenga idda, id tanan don sikandin woy worad id pokita kandan. ");
INSERT INTO oboNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Na, ahad nokita ron en taddot mgo ponguu to Judio iddos mo‑uraan mokososoobbun pinuungan ni Disas, waa sikandan id pomakoy kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","De‑en notuman iddos id ikahi ni propeta Isaias no mid ungketen to, “Longaggon, waa od pomakoy to ponudtulon doy. Waa minuvun nokaabbot taddot kotuusan no id pokita ru kandan.” ");
INSERT INTO oboNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Duwon mandad id oseng ni Isaias moka‑atag to unayan no dii ran od pokopomakoy. Kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Id sobpongngan to Monama kos mata ran amoy dii ran od pokokita, woy id potoggas din kos pusung dan amoy dii ran od pokaabbot. Id puungan to Monama idda amoy dii sikandan od pokoporani kandin woy amoy diid koposinsyan kos mgo saa ran.” ");
INSERT INTO oboNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Na, si Disas iddos od tommanon ni Isaias to id oseng din ini, su nokita rin don tapoy no od posivontuhan en sikandin. ");
INSERT INTO oboNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ahad iling tadda, mo‑uraa rad no mgo ponguu to Judio kos mid pomakoy ki Disas. Piru pomon to allak dan to mgo Pariseo, waa ran ini id ponudtuu, su saddook od po‑owan sikandan woy dii ron od poko‑usok diyot simba‑an to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Oyyos iyon dan id dokollan to ginawa, iddos koddoong to mgo minuvu kandan lampas pa taddot koddoong to Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na id pehes si Disas no mid ungketen to, “Iddos ahad ondoy nod pomakoy koddi, konna ra siyak kos id pomokayan din, ko konna, idda en mandad so id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Su iddos nokokita koddi, nokokita mandad taddot id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mid undini a amoy'd boggoy to ko‑owangan to mgo minuvu ka‑ay to ampow't ingod, su amoy iddos ahad ondoy nod pomakoy koddi, dii ron od ubpa riyot mosukirom. ");
INSERT INTO oboNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Dos ahad ondoy no nokorinog to nonaw ku, piru waa rin puungi, konna siyak kos od hukum kandin. Oyyos waa a mid undini amoy'd hukum to mgo minuvu, ko konna, amoy od tobbus kandan. ");
INSERT INTO oboNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Duwon en od hukum taddot minuvu no id elle koddi woy diid tanggap to nonaw ku. Su iddos nonaw ku, idda en kos od hukum kandin init morin allow. ");
INSERT INTO oboNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Oyyos waa a mid nonaw pomon to koddin id kopi‑i, ko konna, iddos Amoy ku no id popiyod koddi kos id nonaw ko ondan kos od osengon ku. ");
INSERT INTO oboNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Purisu iddos id ponudtuu ku koniyu, idda ra en so id po‑ikahi koddi to Amoy ku. Oyya su nosorollan ku no iddos nonaw rin, od undag en to umuun waad tomanon.” ");
INSERT INTO oboNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Na, to sokkad dobbon allow idda pa od inguma iddos pista to Kodlihad to Ponolihan, nosorollan ni Disas no od inguma ron en kos timpu to kodtanan din ka‑ay to ampow't ingod woy dos kodlivod din diyot Amoy rin. Pomon poron dangan, id dokollan din to ginawa kos mgo tinodduwan din woy ko‑ungkay, id pokita rin en iddos waad tomanon no ginawa rin kandan. ");
INSERT INTO oboNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Laggun tid lavung dan, id ta‑aw ron tapoy ni Moivuyan diyot poomdom ni Judas no anak ni Simon Iscariote no id boligya rin si Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nosorollan ni Disas no id boggoy ron taddot Amoy rin iddos langun no kotungud diyot kandin. Nosorollan din mandad no id pomon sikandin diyot Monama woy od livod en sikandin diyon to Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","De‑en laggun tid ka‑an pa iddos mgo tinodduwan, mid lohinat si Disas woy id lusut din kos lapid no umpak din. Na, id angoy sikandin to tuwalya woy id bagkos din idda riyot awak din. ");
INSERT INTO oboNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nopongnga idda, id busbus sikandin to oweg diyot poonggana woy id tigkonayan din tid unab iddos pa‑a taddot mgo tinodduwan woy id punasan din idda taddot tuwalya no id bagkos diyot awak din. ");
INSERT INTO oboNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na, to si Simon Pedro ron kos od unavan din, mid ikahi si Pedro to, “Eh, Longaggon, konna ollog nod unavan du kos pa‑a ku!” ");
INSERT INTO oboNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mid tavak si Disas to, “Ko‑ungkay, dii ru pa od koovottan inis id puungan ku, piru od koovottan du rad ini riyot mori.” ");
INSERT INTO oboNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kahin Pedro to, “Dii ku en od po‑unavan kikow inis pa‑a ku, su konna en ollog nod puungan du ini!” Piru kahin Disas kandin to, “Otik dii ka od po‑unab koddi, konna kud sikkow tinodduwan.” ");
INSERT INTO oboNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Na mid ikahi si Pedro to, “Longaggon, ko ungketen, konna ra inis pa‑a ku kos unaviyu, ko konna, ahad mandad inis uu woy bollad ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Piru kahin Disas to, “Iddos nokopolihus don, molinis don kos tivuk no lawa rin, de‑en idda robbo so pa‑a rin kos ko‑ilangan nod unavan. Sikiyu, nolinisan kowd, piru konna langun dow.” ");
INSERT INTO oboNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Id oseng ni Disas idda, su nosorollan din don tapoy ko ondoy kos od boligya kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","To no‑unavan don ni Disas iddos pa‑a ran, id sukub din mandon iddos lapid no umpak din woy id livod sikandin diyot id unsaran din. Na id inturan dan ni Disas, kahi rin to, “Nokaabbot kow vo taddot id puungan ku koniyu? ");
INSERT INTO oboNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Id umow kow koddi no Tohodnonaw woy'd Longaggon woy ollog dad idda, oyyos siyak me‑en kos tohodnonaw woy'd Longaggon dow. ");
INSERT INTO oboNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na otik siyak nod Longaggon woy Tohodnonaw row, id pokita to kodpoobbava ukit to kod‑unab to pa‑a row, ollog en mandad no sikiyu, od po‑unavoy to pa‑a row. ");
INSERT INTO oboNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Id pokita ku idda koniyu amoy od ilingan woy'd puungan dow mandad. ");
INSERT INTO oboNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Bonnaavonnaa nod ikohiyon ku koniyu, no waa uripon no lampas taddot kandin no amu woy waa sudsuhuwon no lampas taddot od suhu kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Na, ko‑ungkay su noovottan dowd iddos nonaw ku koniyu, moppiya kod kotomanan dow otid puungan dow ini. ");
INSERT INTO oboNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Waa a mid ikahi ka‑ay atag koniyu langun, su nokilaa ku kos ipat sokkad koniyu no id aam ku. Piru ko‑ilangan nod kotuman iddos no‑ikahi riyot Nosulat no Kahit Monama no, ‘Iddos minuvu no od tuhon koddi tod ka‑an, sikandin en kos od unoy nod puung to morat koddi.’ ");
INSERT INTO oboNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“De‑en to waa pa inin kotomanan, id ponudtulan kud tapoy sikiyu moka‑atag ka‑ay, su amoy riyot allow nod kotuman don ini, od pomakoy kowd no siyak en iddos Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Bonnaavonnaa nod ikohiyon ku koniyu, no iddos ahad ondoy nod tanggap taddot id popiyod ku, iling dad to id tanggap a nikandin woy dos od tanggap koddi, iling dad mandad to id tanggap din iddos Amoy ku no id popiyod koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nopongnga idda osenga ni Disas, oray sikandin no naanu woy kahi rin diyot mgo tinodduwan din to, “Bonnaavonnaa nod ikohiyon ku, no sokkad koniyu, od boligya koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Notigkawan iddos mgo tinodduwan woy id po‑ontongngoy ran, oyyos waa ran nosorolli ko ondoy kandan kos od tommanon din. ");
INSERT INTO oboNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na, duwon sokkad taddot mgo tinodduwan ni Disas no id dokollan din to ginawa no mid unsad duug kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Id sinyasan sikandin ni Pedro amoy'd inturon si Disas ko ondoy kandan kos od tommanon din. ");
INSERT INTO oboNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","De‑en id nona‑as iddos tinodduwan ki Disas woy mid intud kandin, kahi rin to “Longaggon, ondoy sikandin?” ");
INSERT INTO oboNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Id tavak si Disas to, “Iddos od toyawwan ku ka‑ay't id toppik no paan no id aggom ku, sikandin en kos od boligya koddi.” Na, id aggom din idda riyot sowsawan woy id toyyow rin ki Judas no anak ni Simon Iscariote. ");
INSERT INTO oboNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","To notanggap ni Judas iddos paan, idda ron en, id losuran sikandin ni Moivuyan. Na kahin Disas kandin to, “Puungiyud go‑os iddos od puungan du.” ");
INSERT INTO oboNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Piru iddos dumon mgo tinodduwan din, waa en nokaabbot taddot id oseng ni Disas ki Judas. ");
INSERT INTO oboNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Dos duma kandan, id popoomdom no saddook id suhu ra sikandin ni Disas no od bovolli to mgo ko‑ilonganon dan atag to pista o od boggoy ra to soopi riyot mgo worowora, oyyos si Judas me‑en kos tohodsomad to soopi. ");
INSERT INTO oboNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","To noka‑an don ni Judas iddos paan nid toyyow ni Disas, idda ron en, id leggua sikandin. Na iddon timpu, bulli ron. ");
INSERT INTO oboNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na, to noko‑ipanow ron si Judas, mid ikahi si Disas to, “Ini ron en kos timpu no siyak no Anak to Minuvu, od kovantug woy ukit koddi, od koposivontuhan iddos Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Otid posivontuhon iddos Monama ukit koddi, od posivontuhon a mandad nikandin woy go‑os din en ini od puungan. ");
INSERT INTO oboNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Na, sikiyu no timbang mgo anak ku no id dokollan ku to ginawa, konnad od kouhoy kos kodduma ku koniyu. Od nangkap kow koddi, piru iling taddot no‑ikahi kud diyot mgo Judio, od osengon ku mandad diyot koniyu no dii kow od poko‑undiyon tod undiyonnan ku. ");
INSERT INTO oboNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Id boggoy ku koniyu kos lammin suhu, ko‑ilangan nod pohinowannoy kow. Dos kodginawa ku koniyu, iling en mandad tadda kos kodpohinowannoy row. ");
INSERT INTO oboNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Su otid pohinowannoy kow, od kosorollan to langun no minuvu no mgo tinodduwan ku en sikiyu.” ");
INSERT INTO oboNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Na mid intud si Pedro ki Disas, kahi rin to, “Longaggon, od po‑ingkon ka man bos?” Mid tavak si Disas to “Dii ka od pokoruma koddi ko‑ungkay riyot od undiyonnan ku, piru od pokotundug ka rad init morin allow.” ");
INSERT INTO oboNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piru kahin Pedro to, “Longaggon, mambot dii a od pokoruma kikow ko‑ungkay? Nopanoy ad nod patoy atag da en kikow.” ");
INSERT INTO oboNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Kahin Disas to, “Mooggot bo no nopanoy kad en nod patoy atag koddi? Bonnaavonnaa nod ikohiyon ku kikow, no to dii pa od ukkaa kos manuk, ko‑otollu rud tod elle no waa ka id kilaa koddi!” ");
INSERT INTO oboNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Na kahin Disas kandan to, “Yo kow'd kaaggow. Salig kow riyot Monama woy salig kow mandad koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Duwon mo‑uraan od ko‑ubpan diyot baoy to Amoy ku. Dii ku nanoy ini id ponudtuu koniyu otik dii pa ini bonnaa. Od unna a riyon amoy'd panoy tod po‑ubpan koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Otik nopanoy kud kos langun, od livod a ka‑ay woy'd ongayon ku sikiyu, su amoy ko ingkon a, diyon kow en mandad. ");
INSERT INTO oboNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Woy nosorollan dowd iddos daan ko ingkon a od undiyon.” ");
INSERT INTO oboNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Na kahin Tomas kandin to, “Longaggon, waa koy nokosaddoo ko ingkon ka od undiyon. De‑en monnuwon doy man tod tuntuu iddon daan?” ");
INSERT INTO oboNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Kahin Disas to, “Siyak kos daan, dos kovonnaan, woy dos id pomonnan to umuu. Waa od poko‑undiyon to Amoy ku otik dii od baya koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Otik nokokilaa kowd koddi, nokokilaa kow mandad to Amoy ku. Pomon ko‑ungkay, nokokilaa woy nokokita kowd en kandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kahin Felipe kandin to, “Longaggon, pokita ru konami kos Amoy ru woy ollog don idda konami.” ");
INSERT INTO oboNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Mid ikahi si Disas to, “Ooy kikow, Felipe! Nouhoy kid id porumannoy, piru waa ka pobbos nokokilaa koddi? Iddos nokokita koddi, nokokita mandad to Amoy ku. Na mambot id oseng ka no, ‘Pokita ru konami kos Amoy ru?’ ");
INSERT INTO oboNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Waa ka vos id pomakoy no siyak, nosokkad diyot Amoy ku woy dos Amoy ku, ka‑ay en to koddi? Dos id ikahi ku koniyu, konna pomon koddi, ko konna, iddos Amoy ku no id ubpa ka‑ay't koddi kos id puung to kandin nid kopi‑i. ");
INSERT INTO oboNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pomokaya row iddos id ikahi ku no siyak, nosokkad diyot Amoy ku woy dos Amoy ku, nosokkad dinit koddi. Otik dii kow'd pomakoy taddot id ikahi ku, pomokaya a baling nikiyu pomon taddot mokososoobbun pinuungan ku. ");
INSERT INTO oboNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Bonnaavonnaa nod ikohiyon ku koniyu, no iddos od pomakoy koddi, od puung mandad sikandin iling taddot nopuungan ku woy lampas pe‑en tadda kos od kopuungan din, oyyos od livod ad man diyot Amoy ku. ");
INSERT INTO oboNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na, ahad ondan kos od buyuwon dow riyot Amoy ku ukit to koddin ngaran, od puungan ku en amoy'd kovantug kos Amoy ku. ");
INSERT INTO oboNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","De‑en ahad ondan kos od buyuwon dow pomon to kodsalig dow koddi, od puungan ku en ini.” ");
INSERT INTO oboNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Na ponayun mid ikahi si Disas to, “Otik id ginowannan a nikiyu, tumana row kos koddin mgo suhu. ");
INSERT INTO oboNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Od buyuwon ku riyot Amoy ku no id popiyod din iddos ossa pa no Tohodponavang woy dii sikandin od tanan koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Sikandin iddos Uhis no Ispiritu nod nonaw to kovonnaan. Dii sikandin od tonggapon to mgo minuvu no konnod pomakoy koddi, oyyos dii man sikandin od kokita woy dii ran mandad od kilaannon. Piru sikiyu, nokokilaa kow kandin, su id duma man sikandin koniyu woy id ubpa riyot pusung dow. ");
INSERT INTO oboNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Na konna ku sikiyu od tonanan iling to mgo ilu, oyyos od livod a ka‑ay't koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","To diid kouhoy, iddos mgo minuvu no konnod pomakoy koddi, dii ron od kita koddi, piru od kokita a en nikiyu. Woy pomon to no‑uyag a mandon, od ko‑uyag kow mandad. ");
INSERT INTO oboNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Iddon timpu, od kosorollan dow no siyak, nosokkad diyot Amoy ku woy sikiyu, nosokkad dinit koddi woy siyak mandad, nosokkad diyot koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Dos minuvu nod tanggap woy od tuman to koddin mgo suhu, sikandin en kos id ginawa koddi. Na, od ginowannan to Amoy ku iddos minuvu nod ginawa koddi, woy od ginowannan ku mandad sikandin woy id posaddoo ku kandin iddos moka‑atag koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Na si Judas (konna iddos Judas no Iscariote), mid intud ki Disas, kahi rin to, “Longaggon, ondak unayan no ka‑ay ka ra id pokita to konami woy konna riyot langun no minuvu ka‑ay to ampow't ingod?” ");
INSERT INTO oboNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mid tavak si Disas to, “Iddos id ginawa koddi, od ikuu to koddin nonaw. Od ginowannan sikandin to Amoy ku woy od ubpa koy riyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Piru iddos waa id ginawa koddi, dii en od ikuu to koddin nonaw. Inis nonaw no norinog dow, waa id pomon dinit koddi, ko konna, id pomon diyot Amoy ku no id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ini langun, id oseng ku laggun to ka‑ay a pa duma koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Piru od popiyod iddos Amoy ku to Tohodponavang nod suvaa koddi. Sikandin iddos Uhis no Ispiritu. Id nonaw rin kos langun woy id posampot din iddos langun no id ikahi ku koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Yo kow'd kaaggow woy yo kow'd kovaakki, su id tuwos ku kos kosunayan diyot ginawa row. Inin kosunayan, id pomon koddi woy konna ini iddos kosunayan ka‑ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Norinog dow iddos id ikahi ku no od tanan a koniyu, piru od livod a rad ka‑ay't koniyu. Otik id ginowannan a nikiyu, od kahaa kow nod undiyon a to Amoy ku, su lampas pa man sikandin koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Id oseng kud tapoy ini koniyu to dii pa ini od kotomanan, su otid inguma ron idda, od mosalig pe‑en kos kopomakoy row koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Konna kud od kouhayyon inis osengan ku koniyu, oyyos asow ron od inguma si Moivuyan no ponguu ka‑ay to ampow't ingod. Waa kotuusan din nod hari koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Piru id tuman ku iddos id suhu to Amoy ku, su amoy od kosorollan to langun no minuvu ka‑ay to ampow't ingod no id ginowannan ku sikandin. Na kuo kid.” ");
INSERT INTO oboNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Na ponayun mid ikahi si Disas ukit to ponunggelengan, kahi rin to, “Siyak kos mooggot no lawa to pinomuwon ubas woy dos Amoy ku kos tohod‑okudi. ");
INSERT INTO oboNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Iddos ipat panga no diid bovunga, od ponompoddon din woy dos ipat panga nod bovunga, od ongayan din to solingsing woy'd gowanan amoy od bovunga pe‑en to mo‑uraa. ");
INSERT INTO oboNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na, noko‑iling kow mandad taddot kamot nid gowanan don, su nolinisan kowd ukit taddot id nonaw ku koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ponayun kow no nosokkad dinit koddi woy siyak mandad, nosokkad diyot koniyu. Su iling to panga to ubas, dii ini od bovunga otik waa nosuppay riyot lawa to pinomuwa. De‑en dii kow mandad od bovunga otik konna kow od ponayun no nosokkad dinit koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Siyak kos lawa to pinomuwon ubas woy sikiyu kos mgo panga. Iddos od ponayun no nosokkad dinit koddi woy siyak mandad diyot kandin, od bovunga to mo‑uraa. Oyyos waa en od kopuungan dow otik od pitas kow koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Su iddos diid ponayun no nosokkad dinit koddi, iling sikandin tid tampod no panga no id lumbag. Na otid kahangu ron idda, od limuron woy id lumbag diyot apuy. ");
INSERT INTO oboNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Otik ponayun kow no nosokkad dinit koddi woy id pomuwa row kos koddin mgo kahi riyot pusung dow, id boggoy to Monama iddos ahad ondan nod buyuwon dow. ");
INSERT INTO oboNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Otid bovunga kow to mo‑uraa, od koposivontuhan iddos Amoy ku, su ukit ka‑ay, od koposivonnalan no mgo tinodduwan ku en sikiyu. ");
INSERT INTO oboNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Id ginowannan ku sikiyu iling to kodginawa koddi taddot Amoy ku. De‑en yo kow'd pitas to ginawa ku atag koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Otid tumanon dow kos koddin mgo suhu, konnod pitas iddos ginawa ku riyot koniyu. Na iling mandad koddi no id tuman taddot mgo suhu to Amoy ku, waa id pitas iddos ginawa rin dinit koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Id ponudtuu ku ini koniyu amoy od geddamon dow iddos kahaan no id geddam ku woy'd koponnu kow to kahaan. ");
INSERT INTO oboNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ini en kos suhu ku, pohinowannoy kow iling to kodginawa ku koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Worad od pokolampas taddot kodginawa to sokkad no minuvu no od boggoy to kandin no umuu atag da en to mgo oukuy rin. ");
INSERT INTO oboNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Otid tuman kow to koddin mgo suhu, mgo oukuy ku en sikiyu. ");
INSERT INTO oboNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Konna kud sikiyu od ngoranan no mgo sudsuhuwon, su iddos sudsuhuwon, waa nokosaddoo to mgo puhawang to amu rin. Piru sikiyu, od ngoranan kud no mgo oukuy ku, oyya su id ponudtuu kud man koniyu iddos langun nid ponudtuu koddi to Amoy ku. ");
INSERT INTO oboNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Konna sikiyu kos id aam koddi, ko konna, siyak kos id aam koniyu. Id sanna ku koniyu iddos nonaw ku amoy'd bovunga kow to mo‑uraa no od taman to waad tomanon. Su otid puungan dow idda, iddos ahad ondan nod buyuwon dow riyot Amoy ku ukit to koddin ngaran, id boggoy rin en idda koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na ini kos suhu ku koniyu, pohinowannoy kow.” ");
INSERT INTO oboNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Na ponayun mid ikahi si Disas to, “Otik id kolingasa‑i kow to mgo minuvu ka‑ay to ampow't ingod, yo kow'd kosoobbu‑i, su siyak kos unna nid kolingasa‑i ran. ");
INSERT INTO oboNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Otik sakup kow pa to mgo minuvu ka‑ay to ampow't ingod, od ginowannan kow nanoy nikandan. Piru id aam ku sikiyu nid po‑ossa kandan, de‑en id kolingasa‑i kow nikandan. ");
INSERT INTO oboNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sompotta row iddos id oseng ku koniyu no, ‘Waa sudsuhuwon no lampas to kandin no amu.’ De‑en pomon to id posupittan a man nikandan, ungketen dad en mandad kos od puungan dan diyot koniyu. Su otik id ikuu ran pa nanoy taddot nonaw ku, od ikuu ran mandad to nonaw row. ");
INSERT INTO oboNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Od puungan dan ini langun diyot koniyu pomon to kopomakoy row koddi, oyyos waa ran man nokokilaa taddot id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Otik waa a mid undini to ingod amoy'd nonaw kandan, waa ran nanoy nokaabbot no duwon saa ran, piru ko‑ungkay, dii ran don od poko‑oseng no waa saa ran. ");
INSERT INTO oboNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Dos minuvu nod kolingasa koddi, id kolingasa‑i rin mandad iddos Amoy ku. ");
INSERT INTO oboNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Dos mokososoobbun pinuungan ku no matamata ran en tid kita, waa en nokopuung to iling tadda. Na otik waa pa sikandan nokokita tadda, dii nanoy sikandan od kosukutan to saa ran. Piru ahad nokita ran don iddos mokososoobbun pinuungan ku, od kolingasa ran poron koddi woy taddot Amoy ku. ");
INSERT INTO oboNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Na ukit taddot id puungan dan, notuman iddos id posulat to Monama ki Moises no mid ungketen to, ‘Id kolingasa‑i a nikandan ahad waa unayan.’ ” ");
INSERT INTO oboNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kahin Disas to, “Id popiyod ku rinit koniyu iddos Tohodponavang no idda en so Uhis no Ispiritu no id pomon diyot Amoy ku. Sikandin kos od nonaw to kovonnaan moka‑atag to Monama woy'd posivonnaa moka‑atag koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Woy sikiyu mandad, od posivonnaa moka‑atag koddi, oyyos pomon to tigkonayan to kodnonaw ku, duma kowd man koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Na ponayun mid ikahi si Disas to, “Id ponudtuu kud tapoy ini langun diyot koniyu, amoy diid kowora kos kopomakoy row koddi ahad ondan pa kos od kotomanan. ");
INSERT INTO oboNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Od po‑owan kow nikandan diyot simba‑an to iling dow no mgo Judio, woy od inguma kos timpu no iddos od imatoy koniyu, od popoomdom no id puungan dan idda atag to Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Od puungan dan idda koniyu, oyyos waa ran man nokokilaa to Amoy ku woy waa ran mandad nokokilaa koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","“Id ponudtuu ku ini koniyu amoy otid inguma ron kos timpu nod puungan dan ini koniyu, od kosompottan dow no id oseng kud ini tapoy koniyu. “Diyot unna, waa ku ini id ponudtuu, su duma ku pa man sikiyu. ");
INSERT INTO oboNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Na ko‑ungkay, asow ad od livod diyot kandin no id popiyod koddi, piru od kosoobbuwan a, oyyos waa man ahad sokkad koniyu nod intud ko ingkon a od undiyon. ");
INSERT INTO oboNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Noponnu kow to lanu pomon taddot id ponudtuu ku koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Piru od ikohiyan ku sikiyu to mooggot, no iddos kodtanan ku, atag da en to kopiyannan dow. Su otik dii a od tanan, dii od undini iddos Tohodponavang. Piru otid pokotanan ad, id popiyod kud sikandin ka‑ay't koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na otik dini ron sikandin, id paabbotlabbot din to mgo minuvu ka‑ay to ampow't ingod iddos saa ran woy ko ondan kos motallong woy dos kodsilut to Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Od poovotton din iddos mgo minuvu taddot saa ran, oyyos waa ran id pomakoy koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Woy od poovotton din sikandan no motallong a, su od undiyon a to Amoy ku woy dii kowd en od pokokita koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Od poovotton din mandad sikandan no iddos Monama, od silut kandan, su id silutan don si Moivuyan no ponguu to mgo minuvu ka‑ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mo‑uraa pa nanoy kos od osengon ku koniyu, piru ko‑ungkay, dii row pa ini od kogaha tod labbot. ");
INSERT INTO oboNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Piru otid inguma ron iddos Uhis no Ispiritu nod nonaw to kovonnaan, sikandin kos od potuntuu koniyu to langun no kovonnaan moka‑atag koddi. Oyya su iddos id nonaw rin koniyu, konna pomon diyot kandin, ko konna, id nonaw rin iddos norinog din pomon diyon to Monama. Id paabbotlabbot din mandad koniyu iddos od inguma pon kotomanan. ");
INSERT INTO oboNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Od posivontuhan a nikandin su iddos langun nid paabbotlabbot din koniyu, id pomon koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Oyya su iddos langun no riyot Amoy ku, ka‑ay en mandad to koddi. Idda en kos unayan no mid ikahi a no iddos langun nid paabbotlabbot koniyu to Uhis no Ispiritu, id pomon dinit koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Na ponayun mid ikahi si Disas to, “Konnod kouhoy, dii ad nikiyu od kokita. Piru dii mandad od kouhoy, od kokita a rad mandon nikiyu.” ");
INSERT INTO oboNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Id po‑inturoy iddos dumon tinodduwan din, kahi ran to, “Ondan man kos kohulugan taddot id oseng din no, ‘Konnod kouhoy, dii ad nikiyu od kokita. Piru dii mandad od kouhoy, od kokita a rad mandon nikiyu?’ Woy mambot id oseng sikandin no, ‘Od livod ad diyot Amoy ku’? ");
INSERT INTO oboNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Woy ondan man kos kohulugan taddot id oseng din no, ‘konnod kouhoy’? Waa ki nokaabbot ko ondak kohulugan tadda.” ");
INSERT INTO oboNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na, nosorollan ni Disas no od kopiyan dan nanoy nod intud kandin, de‑en kahi rin to, “Id oseng a no, ‘Konnod kouhoy, dii ad nikiyu od kokita. Piru dii mandad od kouhoy, od kokita a rad mandon nikiyu.’ Konna vo ini me‑en nanoy kos id kopi‑i row nod inturon koddi? ");
INSERT INTO oboNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Bonnaavonnaa nod ikohiyon ku koniyu, no pomon to lanu row, od ponsinoggow woy'd pondaawit kow, piru iddos mgo minuvu ka‑ay to ampow't ingod, od pongkahaa taddot od kotomanan ku. Na ahad od lanu kow, od kovuwassan idda to kahaan. ");
INSERT INTO oboNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Id ponunggelengan ku ini to od pototobbow no ba‑ay. Od geddamon din kos mosakit laggun tod sokalan sikandin. Piru otid tobbow ron iddos anak, od kolingawan din don kos mosakit pomon to kahaan su duwon don man anak din. ");
INSERT INTO oboNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ungketen dad en mandad kos od kotomanan dow. Ko‑ungkay od lanu kow pa, piru od pokita a rad mandon koniyu woy iddon timpu, oraroy kow nod kahaa, woy waa en ahad ondoy nod poko‑ahaw taddon kahaan pomon diyot koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na otid inguma ron iddon timpu, konnad ko‑ilangan nod intud kow pa to ahad ondan koddi. Bonnaavonnaa nod ikohiyon ku koniyu, no iddos ahad ondan nod buyuwon dow riyot Amoy ku ukit to koddin ngaran, id boggoy rin en koniyu. ");
INSERT INTO oboNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Taman ko‑ungkay, waa kow poron id buyu to ahad ondan diyot kandin ukit to koddin ngaran. Na, buyu kow amoy'd boggayan kow woy od koponnu kow to kahaan. ");
INSERT INTO oboNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ini langun, id oseng ku koniyu ukit to mgo ponunggelengan, piru od inguma kos timpu no dii kud ini id po‑ukit to ponunggelengan, ko konna, od paabbotlabbot a koniyu no moomok dow od koovottan iddos moka‑atag to Amoy ku. ");
INSERT INTO oboNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na iddon timpu, konnad siyak kos od buyu riyot Amoy ku atag koniyu, ko konna, sikiyu ron en kos od buyu kandin ukit to koddin ngaran. ");
INSERT INTO oboNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Su id ginowannan kow to Amoy ku, oyyos id ginowannan a man nikiyu woy id pomakoy kow no id pomon a riyot kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Id pomon a riyot Amoy ku woy mid undini a to ampow't ingod. Piru ko‑ungkay, od tanan a ka‑ay woy'd livod a riyot kandin.” ");
INSERT INTO oboNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kahi taddot mgo tinodduwan din to, “Ko‑ungkay koy pe‑en oray'n nokaabbot taddot id nonaw ru, oyyos waa kad man id nonaw konami ukit to ponunggelengan. ");
INSERT INTO oboNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ko‑ungkay, noovottan doyd no nokosaddoo ka to langun woy konnad ko‑ilangan no duwon od intud kikow, su nosorollan dud ko ondan kos diyot poomdom doy. Purisu id pomakoy koy no id pomon ka en diyot Monama.” ");
INSERT INTO oboNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Na kahin Disas to, “Monnu, id pomakoy kowd koddi? ");
INSERT INTO oboNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Piru konnod kouhoy woy id inguma ron en kos timpu no od pokodsuwoysuwoy kow. Dos ipat sokkad koniyu, od tanan don koddi su od uli kowd diyon to ubpan dow. Piru ahad ungketen, waa a noka‑awoy‑awoy oyyos duma ku man kos Amoy ku. ");
INSERT INTO oboNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Id ponudtuu ku ini langun koniyu amoy duwon kosunayan dow pomon to kopomakoy row koddi. Ka‑ay to ampow't ingod, od posupittan kow, piru yo kow'd kovaakki, su id talu kud iddos ponguu no id hari ka‑ay to ampow't ingod.” ");
INSERT INTO oboNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Na nopongnga osenga ni Disas idda, id langngag sikandin diyot datas to langit woy mid dasaa, kahi rin to, “Amoy ku, id inguma ron kos timpu no id aam du. Posivontuhi a no Anak du, su amoy ukit tod puungan ku no Anak du, od koposivontuhan ku mandad sikkow. ");
INSERT INTO oboNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Oyya su id boggayan a nikkow to kotungud nod ponguu to langun no minuvu amoy od kovoggayan ku to umuun waad tomanon iddos langun nid sanna ru koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na ini en kos umuun waad tomanon, no od kosorollan dan no sikkow ra en kos mooggot no Monama woy od kosorollan dan no siyak si Disas Krays no id popiyod du. ");
INSERT INTO oboNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Id posivontuhan ku sikkow ka‑ay to ampow't ingod, su nopongnga kud iddos id popuungan du koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Na ko‑ungkay, Amoy ku, posivontuhi a riyot isowwan du iling taddot bantug ku dangan laggun to duma a kikow to waa pa novovalli kos ingod. ");
INSERT INTO oboNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Amoy ku, moka‑atag ka‑ay't mgo minuvu nid sanna ru koddi no id pon‑aam du ka‑ay to ampow't ingod, id pokita kud kandan ko ondoy ka. Kikow en sikandan woy id sanna ru sikandan dinit koddi. Id ikuu ran taddot nonaw ru. ");
INSERT INTO oboNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Woy ko‑ungkay, nosorollan dan don no iddos langun nid puungan woy id ikahi ku, id pomon en diyot kikow. ");
INSERT INTO oboNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Oyya su id tanggap dan iddos id po‑ikahi ru koddi woy nosodsorollan dan no id pomon a en diyot kikow. Id pomakoy mandad sikandan no sikkow kos id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Inis dosalon ku, konna atag to langun no minuvu ka‑ay to ampow't ingod, ko konna, atag ka‑ay't mgo tinodduwan no id sanna ru koddi, oyyos kikow man sikandan. ");
INSERT INTO oboNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Iddos langun no koddi, kikow mandad woy dos langun no kikow, koddi mandad. Na, od koposivontuhan a ukit kandan. ");
INSERT INTO oboNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Dii ad od kouhoy ka‑ay to ampow't ingod, su od livod ad duwot kikow. Piru inis mgo tinodduwan ku, od pokotuwos pa ka‑ay't ingod. Uhis no Amoy ku, tomongngiyu sikandan ukit to kotuusan no id boggoy ru koddi, su amoy langun dan, od kosokkad iling to sikkow woy siyak, sokkad da. ");
INSERT INTO oboNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Laggun to duma ku pa sikandan, siyak kos id inahak kandan ukit to kotuusan no id boggoy ru koddi. Id tomongngan ku sikandan woy waa en ahad sokkad kandan nod kowora, ko konna, idda ra en so minuvu no iyon od ingumannon, iddos kororattan amoy od kotuman iddos nosulat no Kahi ru. ");
INSERT INTO oboNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Na diid kouhoy, od livod ad duwot kikow. De‑en id oseng ku ini riyot kandan laggun to ka‑ay a pa to ingod amoy od koponnu ran to kahaan iling to kahaan ku. ");
INSERT INTO oboNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Id nonaw ku kandan iddos ikahi ru. De‑en id kolingasa‑i ran to mgo minuvu ka‑ay to ampow't ingod, oyyos konna ran man sakup ka‑ay't ingod iling koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Waa a mid dasaa no id poriyu ru sikandan pomon ka‑ay to ampow't ingod, ko konna, tomongngiyu sikandan amoy diid kotalu ni Moivuyan. ");
INSERT INTO oboNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Su iling dan koddi no konna sakup ka‑ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Po‑uhisow sikandan woy ossa‑aw ukit to kovonnaan no idda en so kikow'n kahi. ");
INSERT INTO oboNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Oyyos iling taddot kodpopiyod du koddi ka‑ay to ampow't ingod, id popiyod ku mandad sikandan amoy od nonaw to mgo minuvu ka‑ay to ampow't ingod. ");
INSERT INTO oboNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Atag to kopiyannan dan, id boggoy ku kos koddin umuu riyot kikow, su amoy bonnaavonnaa ran mandad no id boggoy kos ginawa ran to kodpuung tid kopi‑i ru. ");
INSERT INTO oboNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Amoy ku, inis koddin dosalon, konna ra atag to mgo tinodduwan ku, ko konna, atag mandad to langun nod pomakoy pa koddi init mori ukit to kodnonaw ran. ");
INSERT INTO oboNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Muopa no od kosokkad sikandan iling to sikkow dinit koddi, woy siyak diyot kikow. Muopa nod kosokkad mandad sikandan dinit keta, su amoy iddos mgo minuvu ka‑ay to ampow't ingod, od pomakoy no id popiyod a en nikkow. ");
INSERT INTO oboNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Id posivontuhan ku sikandan iling to kodposivantug du koddi, su amoy od kosokkad mandad sikandan iling keta. ");
INSERT INTO oboNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Oyyos siyak diyon to kandan woy sikkow mandad, dinit koddi amoy bonnaavonnaa kos kodposokaddoy ran. Ukit ka‑ay, od kosorollan to mgo minuvu ka‑ay to ampow't ingod, no sikkow kos id popiyod koddi, woy od kosorollan dan mandad no id ginowannan du kos od pompomakoy iling to kodginawa ru koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Amoy ku, id kopi‑i ku no inis mgo minuvu no id sanna ru koddi, od pokoruma koddi ko ingkon a amoy od kokita ran kos kodposivantug du koddi, su id ginowannan a nikkow to waa pa novovalli kos ingod. ");
INSERT INTO oboNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Amoy ku, motallong ka en. Ahad waa id kilaa kikow kos mgo minuvu ka‑ay to ampow't ingod, piru siyak, id kilaa a kikow. Woy inis mgo tinodduwan ku, nokosaddoo no sikkow kos id popiyod koddi. ");
INSERT INTO oboNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Id pokilaa ku sikkow riyot kandan, woy od ponoyunon ku pe‑en sikkow tid pokilaa amoy od pohinowannoy sikandan iling to kodginawa ru koddi woy'd oubpa a riyot kandan.” ");
INSERT INTO oboNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nopongnga mid dasaa si Disas, id ipanow sikandin duma to mgo tinodduwan din woy id batas dan diyot Bo‑og to Kedron. Diyot dipaa, duwon mgo pinomuwon kayu no olibo woy rutun dan en mid undiyon. ");
INSERT INTO oboNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na si Judas no id boligya kandin, nokotuntuu taddon lugaa, su inaayun man od undiyon si Disas woy dos mgo tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","De‑en id piyod ni Judas dutun iddos mgo sundau to Roma duma taddot mgo tohodtamong to templo no id popiyod to mgo ponguu to tohodbuwis woy mgo Pariseo. Id piyod sikandan to mgo suu woy mgo goggot to kodpo‑imotayoy. ");
INSERT INTO oboNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Na, pomon to nosorollan don tapoy ni Disas iddos langun nod kotomanan din, id tommu rin sikandan woy id inturan, kahi rin to, “Ondoy kos od nongkapon dow?” ");
INSERT INTO oboNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mid tavak sikandan to, “Si Disas no toho Nazaret.” Kahin Disas to, “Siyak me‑en idda.” Na ini si Judas nod boligya kandin, diyon en mid loohinat duma taddot mgo sundau. ");
INSERT INTO oboNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","To kod‑oseng ni Disas no, “Siyak me‑en idda,” nokooyyang sikandan diyot livuta. ");
INSERT INTO oboNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Na, id inturan dan mandon ni Disas ko ondoy kos od nongkapon dan. Mid tavak sikandan to, “Si Disas no toho Nazaret.” ");
INSERT INTO oboNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kahin Disas to, “Id osengan kud man sikiyu no siyak en idda. Na otik siyak kos od nongkapon dow, yo row ununga inis mgo duma ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nopuungan ini, su amoy od kotuman iddos diyot dosalon din no mid ungketen to, “Waa en ahad sokkad kandan no id sanna ru koddi nod kowora.” ");
INSERT INTO oboNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Na si Pedro no nokoponlipi to polihuma, id tadnus din idda woy id tibbas din iddos uripon taddot mowwet no ponguu to mgo tohodbuwis, de‑en no‑utas kos kowanan no tolinga rin. (Si Malco kos ngaran taddon uripon.) ");
INSERT INTO oboNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Na id ikohiyan ni Disas si Pedro to, “Polivod du kos polihuma ru ruwot lipi! Ko‑ilangan nod kovoyan ku kos kosupittan no id panoy to Amoy ku atag koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Na, iddos mgo sundau to Roma duma to kopitan dan woy dos mgo tohodtamong to templo, id ammot dan si Disas woy id baku ran kos bollad din. ");
INSERT INTO oboNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Unna ran sikandin piyodda riyot ki Anas no onuhang ni Caifas. Ini si Caifas, sikandin kos mowwet no ponguu to mgo tohodbuwis to iddon lahun. ");
INSERT INTO oboNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Sikandin en mandad kos id pomandu taddot duma rin no mgo ponguu to Judio, no iyon moppiya no sokkad da no minuvu kos od patoy atag to langun no iling din no mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na si Pedro, id tintinundug ki Disas duma taddot sokkad pa no tinodduwan. To kod‑inguma ran diyot leggua to baoy taddot mowwet no ponguu to mgo tohodbuwis, iyon da noko‑usok diyot lama iddos duma ni Pedro, su nokokilaa man kandin iddos komunoy tat baoy. ");
INSERT INTO oboNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piru si Pedro, id polintotuwos diyot leggua. Todtahad, id livod iddos tinodduwan no nokilaa taddot komunoy to baoy woy id obisu sikandin diyot ba‑ay no id tamong to sobbangan, idda pa id po‑usok din si Pedro. ");
INSERT INTO oboNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Na mid intud ki Pedro iddos ba‑ay, kahi rin to, “Konna vo sokkad ka en mandad taddot mgo tinodduwan duwon no minuvu?” Mid tavak si Pedro to, “Te! Konna adi!” ");
INSERT INTO oboNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Iddon bulli, oray'n mohonnow, de‑en id totavun diyot lama iddos mgo sudsuhuwon woy dos mgo tohodtamong to templo woy id ponloohinat dan nid oinarang. Na, diyon en mandad si Pedro duma kandan. ");
INSERT INTO oboNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na, id intud‑inturan si Disas taddot mowwet no ponguu to mgo tohodbuwis moka‑atag to mgo tinodduwan din woy dos nonaw rin. ");
INSERT INTO oboNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kahin Disas to, “Inaayun a mid nonaw riyot isowwan to mo‑uraan minuvu iling taddot diyot mgo simba‑an to Judio woy riyot templo no od lolivuungan to langun no Judio. De‑en waa nonaw ku no id ikahi ku riyon to ollos. ");
INSERT INTO oboNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mambot siyak kos od inturan du? Iyon ollog nod inturan du, iddos mgo minuvun nokorinog koddi, su nokosaddoo sikandan taddot id nonaw ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","To kod‑oseng ni Disas tadda, id tabpi sikandin taddot tohodtamong to templo no id lohinat diyot morani rin, woy mid ikahi sikandin to, “Waa botasan du! Mambot iling duwon kos tavak du ruwot mowwet no ponguu to mgo tohodbuwis?” ");
INSERT INTO oboNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Piru kahin Disas to, “Otik morat iddos kodtavak ku, osengow ve‑en ko ondak morat tadda. Piru otik wora, mambot id tabpi a nikkow?” ");
INSERT INTO oboNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Na, id popiyod ni Anas si Disas no id baku poron diyon to ki Caifas no mowwet no ponguu to mgo tohodbuwis. ");
INSERT INTO oboNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Laggun tid loohinat si Pedro no id oinarang, id inturan mandon sikandin taddot dumon id loohinat dutun, kahi ran to, “Konna vo sokkad ka me‑en mandad taddot mgo tinodduwan duwon no minuvu?” Id elle mandon si Pedro woy mid ikahi to, “Te! Konna en!” ");
INSERT INTO oboNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Na rutun, duwon sokkad no sudsuhuwon taddot mowwet no ponguu to mgo tohodbuwis no korumannan taddot mama no id tibbas ni Pedro kos tolinga. Mid intud sikandin to, “Konna vo sikkow me‑en iddos nokita ku gena no duma rin diyot duwon mgo pinomuwa no olibo?” ");
INSERT INTO oboNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piru mid elle mandon si Pedro woy idda ron en, id ukkaa kos manuk. ");
INSERT INTO oboNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na, to sollom poron, id piyod dan si Disas pomon diyot ki Caifas po‑undiyon to polasyu to gubernador to Roma. Iddos mgo Judio, waa id usok diyot polasyu pomon to botasanon dan to kodlinis. Su otid poko‑usok dan to baoy to konna Judio, molibmit don sikandan woy od diiyan dan nod lommung od ka‑an diyot pista to Kodlihad to Ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","De‑en si Pilato kos id leggua woy mid intud kandan, kahi rin to, “Ondan man kos saa ka‑ay'n minuvu no id popenek dow rinit koddi?” ");
INSERT INTO oboNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kahi ran to, “Otik waa morat no nopuungan ka‑ay'n minuvu, waa roy nanoy piyodda rinit kikow.” ");
INSERT INTO oboNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kahin Pilato kandan to, “Piyodda row sikandin woy sikiyu ron kos od hukum kandin ukit to pomokayon dow.” Mid tavak sikandan to, “Waa kotungud doy nod silut to kopotayan diyot ahad ondoy.” ");
INSERT INTO oboNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Notomanan ini, su amoy od kotuman iddos id oseng ni Disas moka‑atag to po‑ukit to kopotayan din. ");
INSERT INTO oboNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Na, id livod si Pilato riyot daom to polasyu woy id po‑umow rin si Disas, woy id inturan din to, “Sikkow vo kos hari to mgo Judio?” ");
INSERT INTO oboNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Kahin Disas to, “Id ointud ka vo no pomon diyot kikow'n poomdom o duwon id ponudtuu kikow moka‑atag koddi?” ");
INSERT INTO oboNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kahin Pilato kandin to, “Ondan man kos kod‑ontong du koddi, Judio a? Iddos mgo duma ru woy dos mgo ponguu row no tohodbuwis kos id piyod kikow ka‑ay't koddi. Ondan man bos en kos nopuungan du?” ");
INSERT INTO oboNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mid tavak si Disas to, “Iddos kodhari ku, konna ka‑ay to ampow't ingod. Su otik ka‑ay pa idda to ingod, id pon‑atu ron nanoy kos mgo tinodduwan ku amoy dii a od ka‑ammot to mgo Judio. Piru iddos kovonnaan, konna en ka‑ay to ampow't ingod kos kodhari ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","De‑en kahin Pilato kandin to, “Ko ungketen, hari ka vos en!” Kahin Disas to, “Ollog en kos id oseng du no hari a. Iyon unayan no mid undini a to ingod woy nominuvu, su amoy od nonaw a to kovonnaan. De‑en iddos langun nid ginawa to kovonnaan, od pominog koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Kahin Pilato kandin to, “Te! Ondan man kos kovonnaan?” To nopongnga osenga ni Pilato idda, id leggua mandon sikandin diyot mgo Judio woy id ikohiyan din sikandan to, “Waa nokita ku no saa ka‑ay'n minuvu. ");
INSERT INTO oboNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nooyami row man no ipat pista to Kodlihad to Ponolihan, od buyu kow nod poleggua a to sokkad no pinirisu. Na, od kopiyan kow vo nod polegguangon ku inis Hari to mgo Judio?” ");
INSERT INTO oboNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Piru id pehes iddos mgo minuvu no mid ungketen to, “Konna sikandin! Si Barabas kos polegguangow!” Na ini si Barabas, id supak to guberno to Roma. ");
INSERT INTO oboNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","De‑en id pa‑angoy ni Pilato si Disas woy id polompossan din. ");
INSERT INTO oboNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nopongnga, id podlambed to mgo sundau iddos duhiyon no baahon woy id bovallan dan idda no kuruna no id takos diyot uu ni Disas. Id umpakan dan sikandin tod momoollutun umpak iling to umpak to hari. ");
INSERT INTO oboNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Na id porani ran kandin, kahi ran to, “Muopa nod mowwet kos umuu ru, sikkow no hari to mgo Judio!” Nopongnga idda, id tabpi ran sikandin. ");
INSERT INTO oboNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Na, id leggua mandon si Pilato woy id ikohiyan din iddos mgo minuvu to, “Od polegguangon ku sikandin dinit koniyu amoy od kosorollan dow no waa nokita ku no unayan nod silutan to kopotayan inin minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","De‑en id poleggua ran si Disas no id kurunan to duhiyon no baahon woy id umpakan dan sikandin tod momoollutun umpak. Kahin Pilato kandan to, “Na, ontongngi row inin minuvu!” ");
INSERT INTO oboNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","To nokita si Disas taddot mgo ponguu to tohodbuwis woy taddot mgo tohodtamong to templo, id pehes dan no mid ungketen to, “Id pakpak sikandin! Id pakpak sikandin diyon to krus!” Na kahin Pilato kandan to, “Ko ungketen, piyodda row sikandin woy sikiyu ron kos od pakpak kandin diyon to krus, su atag koddi, waa nokita ku no unayan nod silutan to kopotayan inin minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mid tavak iddos mgo Judio to, “Duwon suhu ni Moises konami no iddos iling ka‑ay'n minuvu, ko‑ilangan nod imotayan, su id oseng din no Anak kun sikandin to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","To norinog idda ni Pilato, oraroy pe‑en sikandin no novaakkan. ");
INSERT INTO oboNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Purisu id po‑usok din mandon si Disas diyot daom to polasyu woy id inturan din pe‑en sikandin. Piru waa en id tavak si Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","De‑en kahin Pilato kandin to, “Mambot dii ka od tavak? Waa ka vo nokosaddoo no duwon kotungud ku nod savuk o pakpak kikow riyon to krus?” ");
INSERT INTO oboNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kahin Disas to, “Waa nanoy kotungud du koddi, otik waa idda id boggoy to Monama kikow. De‑en lampas pa kos saa taddot minuvu no id boggoy koddi ka‑ay't kikow.” ");
INSERT INTO oboNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Na pomon tadda, id nangkap sikandin to po‑ukit amoy'd pokoleggua si Disas. Piru ponayun id pehes iddos mgo Judio no mid ungketen to, “Otid sovukan du ikon minuvu, od korattan kos ngaran du riyot hari to Roma. Oyya su iddos ahad ondoy nod ikahi no hari sikandin, id supak en to harit Roma.” ");
INSERT INTO oboNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","To norinog idda ni Pilato, id poleggua rin mandon si Disas woy mid unsad sikandin diyot unsaran to kodhukum no riyot lugaa nod ngoranan to, Osag no Batu. (Otik diyot Hebreo no kinohiyan, Gabata.) ");
INSERT INTO oboNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Iddon timpu, moko‑untud don kos allow woy idda en kos kodpanoy atag to pista to Kodlihad to Ponolihan. Na id ikohiyan din iddos mgo Judio to, “Ontongngi row, ini ron kos hari row!” ");
INSERT INTO oboNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Piru ponayun id pehes iddos mgo minuvu no mid ungketen to, “Od imotayan ikon minuvu! Od imotayan sikandin! Id pakpak sikandin diyon to krus!” De‑en id intud si Pilato kandan, kahi rin to, “Ondan, id popakpak dow kos hari row?” Mid tavak iddos mgo ponguu to tohodbuwis, kahi ran to, “Idda ra en so hari to Roma kos hari roy, worad ossa!” ");
INSERT INTO oboNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Purisu id boggoy ni Pilato si Disas diyot bollad dan amoy id pakpak diyon to krus. ");
INSERT INTO oboNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Na, id potiyang dan si Disas to krus po‑undiyon to lugaa nod ngoranan no Bongovongo. Otik diyot Hebreo no kinohiyan, Golgota. ");
INSERT INTO oboNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Dutun, id pakpak dan sikandin diyon to krus. Diyot tapad ibpit ni Disas, duwon mandad oruwon minuvu no id pakpak diyot mgo krus. ");
INSERT INTO oboNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na, duwon id posulat ni Pilato riyot korotula woy id potakos din idda riyot krus ni Disas. Ini en kos nokosulat tadda, “Si Disas no toho Nazaret, iddos Hari to mgo Judio.” ");
INSERT INTO oboNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mo‑uraa kos Judio no nokovasa tadda, su morani ra man diyot Jerusalem iddos lugaa no id pokpakan dan ki Disas, woy nosulat idda riyot kinohiyan no Hebreo, Latin woy Griego. ");
INSERT INTO oboNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Na iddos mgo ponguu to tohodbuwis, id osengan dan si Pilato, kahi ran to, “Konna ollog iddos id sulat du no, ‘Hari to mgo Judio.’ Moppiya pa nod buwassan du idda to, ‘Id oseng inin minuvu no Hari sikandin to mgo Judio.’ ” ");
INSERT INTO oboNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Piru kahin Pilato kandan to, “Ko ondan kos nosulat kud, idda ron en.” ");
INSERT INTO oboNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na, to nopakpak don to mgo sundau si Disas diyon to krus, id angoy ran iddos mgo umpak din woy id ba‑ad idda taddot oppat no sundau. Id angoy ran mandad iddos mowwet no umpak din no waa tinobbilan. ");
INSERT INTO oboNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Id po‑ikohiyoy iddos mgo sundau to, “Dii ta ra ini od bendason, ko konna, od bunutbunut ki ra ko ondoy kos od pokokomunoy ka‑ay.” Ini en kos notomanan, su amoy od kotuman iddos no‑ikahi riyot Nosulat no Kahit Monama no mid ungketen to, “Id ba‑adba‑ad dan iddos mgo umpak ku woy id bunutbunut dan atag taddot mowwet no umpak ku.” Iling en tadda kos id puungan to mgo sundau. ");
INSERT INTO oboNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na riyot morani to krus ni Disas, id loohinat iddos inoy rin, dos suwod to inoy rin, si Maria no sawa ni Cleopas woy si Maria no toho Magdala. ");
INSERT INTO oboNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","To nokita ni Disas iddos inoy rin woy dos id ginowannan din no tinodduwan no id loohinat dutun, mid ikahi sikandin diyot inoy rin to, “Ina, po‑iling dud sikandin to anak du.” ");
INSERT INTO oboNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Id ikahi mandad si Disas diyot tinodduwan din to, “Po‑iling dud sikandin to inoy ru.” Pomon tadda, id po‑ubpa ron taddon tinodduwan iddos inoy ni Disas diyon to baoy rin. ");
INSERT INTO oboNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Na nosorollan ni Disas no nopongnga ron kos langun, de‑en mid ikahi sikandin to, “Notokkangan a.” Id oseng din idda, su amoy od kotuman iddos no‑ikahi riyot Nosulat no Kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Dutun, duwon sokkad no tootawwan no noponnut suka. De‑en mid angoy sikandan to immat bukoo woy id aggom dan idda taddot suka. Nopongnga, id takos dan idda riyot ubpu to panga to kayu nod ngoranan no isopo woy id bullow ran diyot bivig ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","To noheddaman din idda, mid ikahi sikandin to, “Nopongnga ron kos langun.” Na idda ron en, mid unduk sikandin woy id polivod din diyon to Monama iddos ispiritu rin. ");
INSERT INTO oboNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na iddon timpu, idda en kos kodpanoy atag to Allow't Kod‑imolloy to so‑op no sollom tadda, woy dakkoo kos koru‑anon taddon allow, su nokosasang mandad idda to pista. De‑en id buyu ran ki Pilato no od ponoppuwan to pa‑a iddos id ponpakpak diyon to krus amoy go‑os od poomatoy, woy od ka‑angoy ron iddos mgo bangkoy. Oyyos id diiyan to mgo Judio nod koomaggan iddos mgo bangkoy riyon to krus, su od inguma ron kos Allow't Kod‑imolloy. ");
INSERT INTO oboNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Purisu id undiyon iddos mgo sundau woy id ponoppuwan dan to pa‑a iddos oruwon minuvu nid pakpak diyon to krus no riyot tapad ibpit ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Piru to id porani ran ki Disas, nokita ran no id patoy ron sikandin, de‑en waa ran ponoppuwa iddos pa‑a rin. ");
INSERT INTO oboNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Iyon id puungan taddot sokkad no sundau, id pillak din kos tokeleran ni Disas woy idda ron en, duwon id aus no oweg woy longossa. ");
INSERT INTO oboNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na siyak nid sulat ka‑ay, nosorollan ku no bonnaa en idda, su matamata ku ron en moho tid kita taddon notomanan. Woy id posivonnalan ku idda, su amoy od pomakoy kow mandad. ");
INSERT INTO oboNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Notomanan idda amoy od kotuman iddos no‑ikahi riyot Nosulat no Kahi't Monama no mid ungketen to, “Waa en ahad sokkad no tullan din nod toppuwon.” ");
INSERT INTO oboNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Duwon mandad nosulat dutun no mid ungketen to, “Od tongtongngan dan en iddos minuvu no id pillak dan.” ");
INSERT INTO oboNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nopongnga idda, duwon minuvu no id ngoranan ki Jose no toho Arimatea. Sokkad sikandin taddot od pondumoruma ki Disas, piru waa rin id posaddoo su od kovaakkan sikandin to mgo ponguu to Judio. Na, id buyu rin ki Pilato no od ongayon iddos bangkoy ni Disas, woy id aman si Pilato, de‑en id angoy rin iddos bangkoy ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Id duma kandin si Nicodemo, dos id undiyon dangan to ki Disas to tongngovulli. Id piyod sikandin to lampas to otollumpuun kilu no pomammut no id podsambut to mira woy aloe. ");
INSERT INTO oboNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Na, id angoy ran iddos bangkoy ni Disas woy id bodboddan dan idda to moputin ogget no id tawwan taddot pomammut. Su idda en kos botasanon to mgo Judio otid loobbong to minatoy. ");
INSERT INTO oboNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Diyot morani to id pokpakan ki Disas diyon to krus, duwon mgo pinomuwon kayu. Woy iddon lugaa, duwon langub no lovongngan no lammi pa id bongbangan no waa poron ta‑aw. ");
INSERT INTO oboNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na, pomon to morani ra man idda woy timpu ron to kodpanoy to mgo Judio atag to Allow't Kod‑imolloy, de‑en diyon dan id lobbong si Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na mosukirom poron to allow't Linggu, mid undiyon to lovongngan si Maria no toho Magdala. To kod‑inguma rin dutun, nokita rin no noko‑ibpit don iddos batu no id lokkob tadda. ");
INSERT INTO oboNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","De‑en id lungkossu sikandin po‑undiyot ki Simon Pedro woy riyot tinodduwan no id ginowannan ni Disas. To kod‑inguma rin, mid ikahi sikandin to, “Id angoy iddos od Longaggon pomon diyot lovongngan! Waa koy nokosaddoo ko ingkon sikandin piyodda.” ");
INSERT INTO oboNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Na idda ron en, mid undiyon to lovongngan si Pedro woy iddon tinodduwan. ");
INSERT INTO oboNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tapad dan id ponlungkossu, piru mosiyapat pe‑en iddos duma ni Pedro, de‑en unna sikandin noko‑inguma riyot lovongngan. ");
INSERT INTO oboNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","To kod‑inguma rin dutun, id lungaung sikandin woy nokita rin iddos ogget nid bodbod no nokotuwos, piru waa sikandin id usok. ");
INSERT INTO oboNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Todtahad, id inguma si Pedro no nokotinundug kandin woy id tollus sikandin diyot daom to lovongngan. Na, nokita rin iddos ogget no nokotuwos, ");
INSERT INTO oboNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","woy dos ogget no id bodbod to uu ni Disas. Worad idda nokoddani taddot ogget nid bodbod to lawa rin, ko konna, nouppi ron woy noko‑ossa. ");
INSERT INTO oboNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Na, id usok mandad iddos tinodduwan no noko‑unna riyot lovongngan. To nokita rin no ogget dobbo kos nokotuwos, mid pomakoy sikandin no novadnow ron si Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Id pomakoy sikandin ahad so iddon timpu, waa ran poron nokaabbot taddot no‑ikahi riyot Nosulat no Kahit Monama, no ko‑ilangan od kovadnow si Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nopongnga, id uli ron iddos oruwon tinodduwan. ");
INSERT INTO oboNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Na si Maria, id loohinat pa no id sinoggow riyot leggua to lovongngan. Laggun tid sinoggow poron sikandin, id lungaung sikandin diyot daom. ");
INSERT INTO oboNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nokita rin iddos oruwon ponolihan no moputi kos umpak no id ounsad diyot id tawwan taddot bangkoy ni Disas. Dos sokkad, diyon lomig to uuwan woy dos sokkad, diyon lomig to sikuwayan. ");
INSERT INTO oboNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Na mid intud ki Maria iddos mgo ponolihan, kahi ran to, “Uri, mambot id sinoggow ka?” Id tavak sikandin to, “Id angoy dos od Longaggon ku, woy waa a nokosaddoo ko ingkon sikandin piyodda!” ");
INSERT INTO oboNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nopongnga rin osenga idda, id loingoy sikandin woy nokita rin no duwon minuvu nid lohinat dutun, piru waa saddoo rin no si Disas bos idda. ");
INSERT INTO oboNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Na mid intud si Disas kandin, kahi rin to, “Uri, mambot id sinoggow ka? Ondoy kos od nongkapon du?” Kunan ni Maria ko sikandin kos tohod‑okudi to mgo pinomuwa rutun. De‑en mid ikahi sikandin to, “Sir, otik sikkow kos id angoy kandin, ponudtuli a ko ingkon du sikandin piyodda su od ongayon ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kahin Disas to, “Maria!” Na idda ron en, id isau si Maria ki Disas woy riyot Hebreo no kinohiyan, mid ikahi sikandin to, “Rabboni!” (Dos kohulugan tadda, tohodnonaw.) ");
INSERT INTO oboNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kahin Disas kandin to, “Yo kod somad koddi, oyyos waa a pa id livod diyon to Amoy ku. Undiyonniyu iddos mgo tinodduwan ku woy ponudtuu ru kandan no od livod ad diyot Amoy ku no Amoy row mandad, woy Monama ku no Monama row mandad.” ");
INSERT INTO oboNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","De‑en id undiyonnan ni Maria no toho Magdala iddos mgo tinodduwan, woy id ikohiyan din to, “Nokita ku iddos od Longaggon!” Na, id ponudtuu rin kandan iddos langun nid oseng ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na riyot bulli ron to iddon allow't Linggu, id lolivuung iddos mgo tinodduwan din diyot sokkad no baoy. Pomon to allak dan to mgo ponguu to Judio, id ponoggasan dan iddos mgo lokkob. Na, tigkow id lohinat si Disas diyot isowwan dan woy mid ikahi sikandin to, “Iddos kosunayan, inaayun duwon to koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nopongnga rin osenga idda, id pokita rin iddos bollad woy tokeleran din. Na, oray'n nahaa iddos mgo tinodduwan to nokita ran iddos od Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Na mid ikahi mandon si Disas to, “Iddos kosunayan, inaayun duwon to koniyu. Iling taddot kodpopiyod koddi to Amoy ku, id popiyod ku mandad sikiyu.” ");
INSERT INTO oboNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nopongnga rin osenga idda, id irupan din sikandan woy id ikohiyan to, “Tonggapa row kos Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Otid posinsyan dow iddos ahad ondoy no nokosaa, od posinsyan mandad sikandan to Monama. Piru ko dii row sikandan od posinsyan, dii ran mandad od posinsyan to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na, iddot timpu no id pokita si Disas diyot mgo tinodduwan din, waa rutun si Tomas no iddos angga rin, Sopping. Sokkad sikandin taddot sopuu‑oruwon tinodduwan din. ");
INSERT INTO oboNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","De‑en id ponudtulan sikandin taddot duma rin no mgo tinodduwan no nokita ran iddos od Longaggon. Piru kahin Tomas to, “Dii a od pomakoy no novadnow sikandin, oyya kod kokita ku woy'd kosamsam to tintoddu ku iddos ukit to pansaa riyot bollad din woy dos pali riyot tokeleran din.” ");
INSERT INTO oboNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","To id lihad don kos sokkad no simana, id lolivuung mandon dutun no baoy iddos mgo tinodduwan woy duma ran don si Tomas. Ahad id ponoggasan dan iddos mgo lokkob, tigkow mandon id lohinat si Disas diyot tongannan dan woy mid ikahi sikandin to, “Iddos kosunayan, inaayun duwon to koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Na id osengan din si Tomas to, “Undini ka, ontongngiyu inis bollad ku. Somsamow to tintoddu ru inis bollad ku woy ini mandad so tokeleran ku. Yo kad od duworuwa. Pomakoy kad.” ");
INSERT INTO oboNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kahin Tomas kandin to, “Sikkow en kos od Longaggon woy Monama ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kahin Disas to, “Id pomakoy kad su nokita ad man nikkow. Moppiya kod kotomanan taddot id pomakoy koddi ahad waa a nikandan nokita.” ");
INSERT INTO oboNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Duwon pa mo‑uraan mokososoobbu no id pokita ni Disas diyot mgo tinodduwan din no waa nosulat ka‑ay'n libru. ");
INSERT INTO oboNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Piru inis nosulat ka‑ay, id sulat amoy od pomakoy kow no si Disas en kos Mesiyas woy Anak to Monama. Woy ukit to kopomakoy row kandin, od pokotanggap kow to umuun waad tomanon. ");
INSERT INTO oboNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Na, to id lihad kos pilon allow, id pokita mandon si Disas to mgo tinodduwan din diyot ibpit to Lanow't Tiberias. Iling ka‑ay dos notomanan. ");
INSERT INTO oboNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Id lolivuung onsi Simon Pedro, si Tomas no iddos angga rin, Sopping, si Natanael no toho Cana no sakup to Galilea, dos mgo anak ni Sebedeo woy idda mandad so oruwa taddot duma pon mgo tinodduwan ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Na kahin Pedro kandan to, “Od ngongaap a pa.” Kahi ran to, “Od duma koy kikow.” De‑en id sakoy sikandan to bollangay amoy'd ngongaap, piru laroy't bulli, waad en no‑utoo ran. ");
INSERT INTO oboNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Gulari tod ka‑allow ron, duwon nokita ran no id lohinat diyot ibpit to lanow. Piru waa saddoo ran no si Disas bos idda. ");
INSERT INTO oboNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Na mid umow si Disas kandan, kahi rin to, “Mgo suwod, duwon dad no‑utoo row?” Id tavak sikandan to, “Waad en moho.” ");
INSERT INTO oboNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kahin Disas to, “Uuha row kos pukut duwon lomig to kowanan to bollangay amoy od poko‑utoo kow.” De‑en to id puungan dan idda, dii ran don od kogaha tod go‑un iddos pukut pomon to ko‑uralloy to ngaap no no‑utoo ran. ");
INSERT INTO oboNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na iddos tinodduwan no id ginowannan ni Disas, mid ikahi ki Pedro to, “Iddos od Longaggon man bos idda!” To norinog idda ni Pedro, id sukub din iddos umpak nid lusut din, id ballu sikandin diyot oweg woy id languy po‑undiyon to ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Dos dumon tinodduwan, id tinundug nid sakoy taddot bollangay. Id goyod dan dobbo iddos pukut no noponnut ngaap, su morani ron man sikandan diyot ibpit to lanow no mgo limmompuun leppa robbo kos koriyuwoy. ");
INSERT INTO oboNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","To nokogo‑un don sikandan, nokita ran iddos apuy no duwon mgo ngaap no id tuwog woy duwon mandad mgo paan. ");
INSERT INTO oboNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Na kahin Disas to, “Piyod kow rini to mgo ngaap no no‑utoo row.” ");
INSERT INTO oboNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","De‑en mid undiyon si Pedro to bollangay woy id goyod din nid po‑ibpit iddos pukut. Noponnu idda to doorakkoon ngaap no id inguma to sokkad no gatus woy limmompuu otollun (153) molison kos ko‑uralloy. Na ahad iling tadda kos ko‑uralloy, waad en novendas iddos pukut. ");
INSERT INTO oboNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kahin Disas to, “Undini kowd su od lammag kid.” Na, iddos langun taddot mgo tinodduwan, od ka‑aang‑aang nod intud ko ondoy sikandin, su nokosaddoo ran no sikandin kos od Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Na mid angoy si Disas to paan woy id toyyow rin idda riyot kandan, woy ungketen dad en mandad taddot tinuwog no mgo ngaap. ");
INSERT INTO oboNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na, ini en kos iko‑otollun kodpokita ni Disas diyot mgo tinodduwan din, nopongnga sikandin novadnow. ");
INSERT INTO oboNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","To nopongnga ran id lammag, id inturan ni Disas si Simon Pedro. Kahi rin to, “Simon no anak ni Juan, id dokollan a vo nikkow to ginawa lampas pa taddot kodginawa koddi to mgo duma ru?” Mid tavak si Pedro to, “Oyya, od Longaggon, nokosaddoo ka no id ginowannan ku sikkow.” Kahin Disas kandin to, “Tuhonulow kos mgo natin karnero ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Na mid intud mandon si Disas kandin, kahi rin to, “Simon no anak ni Juan, id dokollan a ve‑en nikkow to ginawa?” Id tavak si Pedro to, “Oyya, od Longaggon, nokosaddoo ka no id ginowannan ku sikkow.” Kahin Disas to, “Tomongngiyu kos mgo karnero ku.” ");
INSERT INTO oboNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mid intud mandon si Disas to iko‑otollun timpu, kahi rin to, “Simon no anak ni Juan, id ginowannan a vo nikkow?” Na, immat id kommos kos pusung ni Pedro oyyos ko‑otollu ron sikandin inturi ni Disas. De‑en mid ikahi sikandin to, “Longaggon, nosorollan du kos langun woy nokosaddoo ka no id ginowannan ku en sikkow.” Kahin Disas kandin to, “Na, tuhonulow kos mgo karnero ku. ");
INSERT INTO oboNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Bonnaavonnaa nod ikohiyon ku kikow, no dangan to sudduwan ka pa, od poko‑oumpak ka woy'd poko‑undiyon to ahad ingkon nid kopi‑i ru. Piru otid kovuyyag kad, od poleppan kos bollad du woy osson minuvu kos od baku kikow woy od tuyukon ka po‑undiyon to lugaa no dii ru id kopi‑i.” ");
INSERT INTO oboNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Id oseng ni Disas idda, su amoy id paabbotlabbot din kos po‑ukit to kopotayan ni Pedro woy ukit tadda, od koposivontuhan din kos Monama. Na mid ikahi si Disas ki Pedro to, “Duma ka koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nopongnga osenga ni Disas idda, id loingoy si Pedro woy nokita rin iddos tinodduwan no id ginowannan ni Disas. Sikandin en kos id duug ki Disas iddot kodlavung dan woy dos mid intud ko ondoy kos od boligya kandin. ");
INSERT INTO oboNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","To nokita ni Pedro iddon tinodduwan, mid intud sikandin ki Disas, kahi rin to, “Longaggon, ondan bo mandad kos od kotomanan din?” ");
INSERT INTO oboNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Mid tavak si Disas to, “Otik id kopi‑i ku nod ko‑uyag sikandin taman to kodlivod ku ka‑ay to ampow't ingod, konnad ko‑ilangan nod kosorollan du idda. Iyon du puungi, duma ka koddi.” ");
INSERT INTO oboNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Na pomon taddot id oseng ni Disas, nokoso‑ob kos dinoggan diyon tod pompomakoy, no iddon tinodduwan, dii kun od patoy. Piru iyon bonnaa, waa mid ikahi si Disas no diid patoy iddon tinodduwan, ko konna, iddos id ikahi rin, “Otik id kopi‑i ku nod ko‑uyag sikandin taman to kodlivod ku ka‑ay to ampow't ingod, konnad ko‑ilangan nod kosorollan du idda.” ");
INSERT INTO oboNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iddos tinodduwan nod tommanon ni Disas, sikandin en kos id posivonnaa woy mid sulat langun ka‑ay, woy nosorollan doy no mooggot en kos kodposivonnaa rin. ");
INSERT INTO oboNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na, mo‑uraa pa kos id puungan ni Disas. Otid ipanon idda tod sulat, saddook kulang pa inis intirut ingod no od tawwan taddot langun no libru nod sulatan tadda.");
INSERT INTO oboNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Diyon to kikow, Teofilo. Iddot unnon sulat ku kikow, id ponudtuu ku iddos langun no pinuungan ni Disas woy dos kodnonaw rin pomon taddot kodtigkanoy to kandin no pinuungan, ");
INSERT INTO oboNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","taman taddot allow no novatun sikandin diyot datas to langit. Iling ka-ay kos notomanan. Nopongnga iddos kopotayan ni Disas diyon to krus woy dos kodbadnow kandin, komo-uraa sikandin id pokita riyot mgo apostoles daom to oppat-no-puun allow amoy id posivonnaa rin no no-uyag en sikandin. Woy id nonaw mandad sikandin diyot mgo apostoles moka-atag to kodharit Monama. To waa pa sikandin id batun, duwon mgo ponaannon din diyot id pon-aam din no mgo apostoles ukit to kotuusan to Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Sokkad no ponaannon din kandan laggun tid porumannoy ran nid ka-an, mid ikahi sikandin to, “Yo kow'd awa riyot bonuwa to Jerusalem. Ongati row iddos kod-inguma to Uhis no Ispiritu no id tandu to Amoy ku, no idda en so id ikahi kud dangan koniyu. ");
INSERT INTO oboNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Oyyos si Juan, oweg kos id boutismu rin to mgo minuvu, piru pilon allow pomon ko-ungkay, Uhis no Ispiritu kos id boutismu koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na sokkad no timpu, id lolivuung kos mgo apostoles duma ki Disas woy mid intud sikandan, kahi ran to, “Longaggon, od po-owan du vo ko-ungkay no timpu iddos mgo minuvu no id hari keta amoy'd poohinaton mandon iddos kohoriyan to Israel?” ");
INSERT INTO oboNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mid tavak si Disas to, “Idda ra en so Amoy ku kos nokosaddoo to timpu nod puungan din iddos id kopi-i rin ka-ay to ampow't ingod. Piru sikiyu, konna atag koniyu inin sinorollan ko kannu ini od kopuungan. ");
INSERT INTO oboNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Piru otik od ko-iroomman kowd to Uhis no Ispiritu, od pokotanggap kowd to kotuusan. Woy od pokoposivonnaa kowd moka-atag koddi riyon to Jerusalem woy riyot langun no lugaa no sakup to Judea, ahad diyot bonuwa to Samaria woy ahad ingkon ka-ay to intirut ingod.” ");
INSERT INTO oboNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nopongnga mid ooseng si Disas tadda, id batun don sikandin diyot datas to langit laggun tid pon-ontong kandin iddos mgo apostoles taman to worad od kokita ran su nosoungan don man sikandin to souhapun. ");
INSERT INTO oboNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Laggun tod totongtong dan diyot datas to langit, tigkow ron duwon oruwon mama no moputi kos umpak no id lohinat diyot morani ran. ");
INSERT INTO oboNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na mid ikahi iddos oruwon mama to, “Sikiyu no mgo toho Galilea, mambot od loohinat kow nod langngag diyot datas to langit? Si Disas no id batun don, od livod dad sikandin ka-ay to ampow't ingod iling taddot kodbatun kandin.” ");
INSERT INTO oboNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na, id tanan don iddos mgo apostoles diyot Buvungan to mgo Olibo woy mid livod sikandan diyot Jerusalem. Iddon buvungan, mgo sokkad no kilometro kos koriyuwoy pomon diyot Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","To noko-inguma ran don dutun, id penek dan diyot kwartu nid oubpan dan. Sikandan onsi Pedro, si Juan, si Santiago, si Andres, si Felipe, si Tomas, si Bartolome, si Mateo, si Santiago no anak ni Alfeo, si Simon no mohingginawa to ingod din woy si Judas no anak ni Santiago. ");
INSERT INTO oboNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Langun dan, inaayun od posokaddoy to koddasaa riyot Monama, woy mid lonug kandan si Maria no inoy ni Disas woy dos duma pon mgo molitan woy mgo suwod ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sokkad no allow, id lolivuung dan. (Iddos ko-uralloy tod pompomakoy rutun, mgo sokkad no gatus woy oruwompuu.) Na id lohinat si Pedro woy id osengan din sikandan, kahi rin to, ");
INSERT INTO oboNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mgo suwod, ko-ilangan nod kotuman iddos id posulat dangan to Monama ki David ukit to Uhis no Ispiritu moka-atag ki Judas no id piyod taddot mgo minuvu nid ammot ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si Judas, sokkad sikandin dangan no duma ta no apostoles woy id aam tod Longaggon amoy'd lonug to pinuungan din.” ");
INSERT INTO oboNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Na, iddos soopi no id bayad ki Judas taddot morat nid puungan din ki Disas, id bolli idda to livuta. Diyon en mandad no livuta, no-uug sikandin no noko-unna kos uu woy id bossot kos gottok din woy novukayat pe-en kos bituka rin. ");
INSERT INTO oboNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","De-en to norinog inin notomanan taddot langun no toho Jerusalem, id ngoranan dan iddon livuta no, ‘Akeldama’ riyot kinohiyan dan no Aramaic, no iddos kohulugan, Livuta no id Boyaran to Longossa.) ");
INSERT INTO oboNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Na ponayun mid ikahi si Pedro to, “Oyya su no-ikahi riyot libru to Salmo no, “ ‘Ko-ilangan en nod tonanan dos ubpan din woy worad od poko-oubpa tadda.’ Woy duwon mandad nosulat dutun no mid ungketen to, ‘Ko-ilangan no duwon sokkad nod suvaa to kotundanan din.’ ");
INSERT INTO oboNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Purisu ko-ilangan nod aam ki to sokkad no minuvu nod suvaa ki Judas amoy od lonug keta to kodposivonnaa taddot kodbadnow ki Disas. Iddos minuvu nod aamon ta, ko-ilangan no id dumoruma keta daom to timpu no ka-ay pa si Disas nod Longaggon, pomon taddot timpu nid boutismu si Juan taman tid batun don sikandin diyot datas to langit.” ");
INSERT INTO oboNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","De-en duwon oruwon ngaran no id boggoy ran amoy'd aaman taddot od pokosuvaa ki Judas. Iddos sokkad, si Jose no id ngoranan ki Barsabas (no id ngoranan mandad ki Justo) woy dos sokkad, si Matias. ");
INSERT INTO oboNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nopongnga idda, id dasaa sikandan no mid ungketen to, “Longaggon, nosorollan du iddos diyot pusung to langun no minuvu. Pokita ru konami ko ondoy musing ka-ay to oruwa kos id aam du ");
INSERT INTO oboNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","no id suvaa ki Judas taddot id tonanan din no kotundanan no apostoles, su id undiyon sikandin to lugaa no ollog kandin.” ");
INSERT INTO oboNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","To nopongnga ran id dasaa, id bunutbunut sikandan woy dos na-aam, si Matias. Na pomon tadda, sokkad don sikandin taddot sopuu-oruwon apostoles. ");
INSERT INTO oboNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na, to id inguma ron iddos allow to Pentecostes, id lolivuung diyot sokkad no baoy iddos langun tod pompomakoy. ");
INSERT INTO oboNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Woy tigkow ron duwon dahing pomon diyot datas to langit no iling to monokkaan kaamag nod gohonugguu, woy dos dohingon tadda, nokoso-ob diyot daom to baoy nid lolivuungan dan. ");
INSERT INTO oboNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nokokita ran to immat dila no mgo loglog to apuy no id mo-uraa woy id latun idda riyot uu to ipat sokkad kandan. ");
INSERT INTO oboNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Langun dan, no-iroomman to Uhis no Ispiritu woy id tigkanoy no posid-ooseng to nokod-osso-osson kinohiyan no waa ran nopohinonawwi, su idda man so Uhis no Ispiritu kos id boggoy kandan to kogahan. ");
INSERT INTO oboNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na iddon timpu, duwon mgo Judio no mid oubpa riyot Jerusalem no duwon allak to Monama. Id pomon sikandan diyot nokod-osso-osson ingod. ");
INSERT INTO oboNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","To norinog dan iddos dohingon, id pondupak dan diyon tod pompomakoy. Woy oraroy ran no nongotaong su iddos ipat sokkad kandan, nokorinog no iddos od pompomakoy, noko-ooseng moho taddot ipat sokkad no kinohiyan dan. ");
INSERT INTO oboNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Purisu oraroy ran no nosoobbuwan woy id pon-ikahi ran to, “Mambo moho tod poko-ooseng don to nokod-osso-osson kinohiyan inin mgo minuvu no toho Galilea man nanoy sikandan? ");
INSERT INTO oboNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mambo ayu tod poko-ooseng don sikandan taddot ipat sokkad no kinohiyan to lugaa nid pomonnan ta? ");
INSERT INTO oboNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Oyya su duwon duma ta ka-ay no toho Partia, toho Media, toho Elam, toho Mesopotamia, toho Judea, toho Capadocia, toho Ponto woy pomon diyot Asia. ");
INSERT INTO oboNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Woy duwon mandad toho Frigia, toho Pamfilia, toho Ehipto woy duwon id pomon diyot mgo lugaa no sakup to Libya no moranit bonuwa to Cirene woy duwon pe-en id pomon diyot Roma no mgo Judio woy konna mgo Judio no nongopiyod tod pomokayon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Woy duwon pe-en mandad id pomon diyot Creta woy riyot Arabia. Ahad waa nokod-iling kos keton mgo kinohiyan, piru noovottan ta rad man iddos langun no id ikahi ran moka-atag to mgo mokososoobbun pinuungan to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na pomon to nosoobbuwan woy notaong dan, id po-inturoy ran no mid ungketen to, “Ondan ayu kos kohulugan ka-ay?” ");
INSERT INTO oboNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Piru duwon duma no id yangyang dan iddos od pompomakoy, kahi ran to, “Nongohubug da ikon mgo minuvu!” ");
INSERT INTO oboNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piru si Pedro, mid lohinat duma taddot dumon sopuu-sokkad no apostoles diyot isowwan to mo-uraan minuvu woy id ooseng sikandin to monokkaa no mid ungketen to, “Sikiyu no duma roy no mgo Judio woy langun no mid oubpa ka-ay't Jerusalem, ooyyari row tod pominog inis od ikohiyon ku koniyu. ");
INSERT INTO oboNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Id popoomdom kow no od pongkohubug inis mgo duma ku, piru waa moho minuvu nod kohubug to alas nuwebe poron to sollom! ");
INSERT INTO oboNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Inin notomanan, ini en iddos id poposaddoo dangan to Monama ki propeta Joel no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Init morin allow, id busbus ku riyot langun no minuvu iddos koddin Ispiritu. Na ukit tadda, id poposaddoo ku iddos koddin kahi taddot mgo anak dow no mama woy ba-ay. Duwon id pokita ku riyot mgo konakan dow. Woy dos mgo buyyag dow no mama, duwon mandad id potohenop ku kandan. ");
INSERT INTO oboNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Iddon mgo allow, ahad pa iddos mgo uripon ku no mama woy ba-ay, id boggoy ku kandan iddos koddin Ispiritu amoy'd pokoponudtuu ran to koddin kahi. ");
INSERT INTO oboNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Woy duwon id pokita ku no mgo mokososoobbu riyot datas to langit woy ka-ay to ampow't ingod, oyya su duwon od kokita no longossa woy apuy woy mokoppaan obboo. ");
INSERT INTO oboNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Od mosukirom kos allow woy dos buwan, od moollutu iling to longossa. Na idda pa, od inguma iddos moka-arat-arat no allow to kodhukum tod Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Iddos ahad ondoy nod nganoy tod Longaggon, od kotobbus.’ ” ");
INSERT INTO oboNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Na mid ikahi pe-en si Pedro to, “Sikiyu no mgo duma ku no toho Israel, pominogga row inis od osengon ku koniyu. Si Disas no toho Nazaret, id popiyod to Monama rinit keta, woy id posivonnalan din ini to mgo mokososoobbun pinuungan ni Disas. Nokosaddoo kowd ka-ay su id puungan me-en ini ka-ay't koniyu. ");
INSERT INTO oboNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ini si Disas, id boggoy row riyot bollad to mgo mosaasaan minuvu amoy'd po-imotayan ukit to kodpakpak diyon to krus. Na langun ka-ay, nopuungan don, su id ikuu ini to puhawang to Monama woy tapoy rin don nosorolli. ");
INSERT INTO oboNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Piru id badnow si Disas to Monama woy id polegguang sikandin pomon diyot kotuusan to kopotayan, oyyos konnod kopakoy nod kotalu sikandin to kopotayan. ");
INSERT INTO oboNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Poomdomma row iddos id ikahi dangan ni Harin David moka-atag kandin no mid ungketen to, ‘Inaayun id duma koddi iddos Monama nod Longaggon, de-en konna a od kovaakkan, su rini man sikandin to tokeleran ku amoy'd tavang koddi. ");
INSERT INTO oboNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ini en kos unayan no dakkoo kos kahaan ku, woy od kanta kos pusung ku to koddoong diyot Monama. Ahad pa od patoy a, duwon en ko-immanan ku. ");
INSERT INTO oboNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Oyyos nosorollan ku en no konna a nikkow od podtohonon diyot lovongngan. Dii ka od aman nod ko-obbuu kos lawa to uhis no uripon du. ");
INSERT INTO oboNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Id pokita ru koddi iddos daan nod po-undiyon to umuun waad tomanon. De-en oraroy a nod kahaa su inaayun ka man duma koddi.’ ” ");
INSERT INTO oboNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Na ponayun mid ikahi si Pedro to, “Mgo suwod, id paabbotlabbot ku koniyu no si Harin David no keton kovuyyahan, waa sikandin id ooseng ka-ay moka-atag to ko-ugolingun din, su nosorollan ta no id patoy woy id lobbong sikandin. Woy dos lobbong din, duwon poron taman ko-ungkay. ");
INSERT INTO oboNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pomon to si David sokkad man no propeta, tapoy rin don nosorolli iddos tandu to Monama no od pohoriyon iddos sokkad taddot koubbaran din. ");
INSERT INTO oboNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nosorollan din don tapoy iddos kodbadnow taddot Mesiyas, de-en mid ikahi si David to, ‘Waa sikandin podtohona to Monama riyot lovongngan woy waa en mandad no-obbuu kos lawa rin.’ ");
INSERT INTO oboNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Id badnow to Monama si Disas woy sikami langun, od pokoposivonnaa, oyya su nokita roy ron en moho no no-uyag sikandin. ");
INSERT INTO oboNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Na id batun si Disas to Monama, woy id posivontuhan ukit to kodpo-unsad diyon lomig to kowanan din. Woy notanggap din iddos Uhis no Ispiritu nid tandu to Amoy rin. Iddos mokososoobbun nokita woy norinog dow ko-ungkay, ini en kos pinuungan to Uhis no Ispiritu no id boggoy ni Disas woy id popiyod din ka-ay't konami. ");
INSERT INTO oboNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nosorollan ta no iddos id oseng ni David, konna en moka-atag kandin, su konna man si David kos novatun diyot datas to langit, ko konna, si Disas en. Oyyos duwon id sulat ni David no mid ungketen to, ‘Dos Monama, mid ikahi riyon tod Longaggon ku, Unsad ka lomig to kowanan ku, ");
INSERT INTO oboNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","taman tid po-iraom kud to kikow'n kodponguu iddos od pongkuntra kikow.’ ");
INSERT INTO oboNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","De-en sikiyu langun no koubbaran ni Israel, ko-ilangan nod pokosaddoo kow no si Disas no id pakpak dow riyon to krus, id aam sikandin to Monama amoy od kovovallan no Mesiyas woy'd Longaggon!” ");
INSERT INTO oboNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na, to norinog to mgo minuvu iddos osengan ni Pedro, nokobbit kos pusung dan. De-en id inturan dan si Pedro woy dos duma rin no mgo apostoles, kahi ran to, “Mgo suwod, ondan man kos ollog nod puungan doy?” ");
INSERT INTO oboNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mid tavak si Pedro to, “Sondit kow woy tanan kowd to mgo saa row, woy ko-ilangan no ipat sokkad koniyu, od poboutismu, su ini en kos kodposivonnaa no nosokkad kowd diyot ki Disas Krays. Puungi row ini amoy'd koposinsyan kow woy od kotanggap dow iddos Uhis no Ispiritu no id boggoy to Monama koniyu. ");
INSERT INTO oboNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Su ini en kos id tandu to Monama koniyu woy riyot koubbaran dow, ahad pa iddos id pon-oubpa riyot moriyu woy dos ahad ondoy nod umawon to Monama nod Longaggon ta.” ");
INSERT INTO oboNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na, mo-uraa pa iddos mgo osengan ni Pedro kandan woy id loglohottan din sikandan no mid ungketen to, “Poriyu kow to mgo minuvu to inin timpu nod puung to morat su mooggot en nod silutan sikandan to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Iddon allow, mo-uraa kos mid pomakoy taddot ponudtulon ni Pedro woy id poboutismu sikandan. Duwon otollun maan (3,000) no minuvu no nokotimuu riyon tod pompomakoy. ");
INSERT INTO oboNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Na, id boggoy ran langun kos kandan no timpu to kodpominog taddot nonaw to mgo apostoles, ponayun dan nid porumannoy woy id ka-an taddot id toppiktoppik no paan atag to kodsampot to kopotayan ni Disas woy ponayun dan mid dasaa. ");
INSERT INTO oboNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na, mo-uraa kos mgo mokososoobbun pinuungan to Monama ukit to mgo apostoles. De-en iddos langun no minuvu, duwon don allak dan to Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ponayun nid lolivuung iddos langun nod pompomakoy woy id povoggayoy ran diyot ahad ondoy no duwon ko-ilonganon. ");
INSERT INTO oboNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Id boligya ran iddos mgo koruwonnan dan woy dos bayad tadda, id ba-adba-ad dan diyot mgo suwod dan to kopomakoy no duwon ko-ilonganon. ");
INSERT INTO oboNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ipat allow, ponayun dan id lolivuung diyot templo. Na riyon mandad to baoy ran, id pontoppiktoppik dan to paan woy mid ka-an sikandan nid dumannan to bonnaavonnaan kahaan. ");
INSERT INTO oboNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ponayun dan to koddoong to Monama woy mowwet kos kod-ontong kandan to langun no minuvu. Ipat allow, id timuu pe-en tod Longaggon iddos ko-uralloy to minuvu no notobbus. ");
INSERT INTO oboNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sokkad no allow, to mgo alas tres to mapun, mid undiyon to templo si Pedro woy si Juan, su idda en kos timpu to koddasaa to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Diyot sobbangan to templo nod ngoranan no Motoos no Sobbangan, duwon sokkad no minuvun pungku pomon poron to kodtobbow rin. Na ipat allow, duwon od sayung kandin woy od ta-aw kandin taddon sobbangan amoy'd pokilimus taddot od pon-usok diyon to templo. ");
INSERT INTO oboNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","To nokokita sikandin ki Pedro woy ki Juan no od usok don diyot templo, id bovuyu sikandin to soopi. ");
INSERT INTO oboNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Na, id tongtongngan ni Pedro woy Juan iddos pungku, woy id ikohiyan ni Pedro to, “Ontong ka konami.” ");
INSERT INTO oboNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","De-en mid ontong kandan iddos pungku su id aangat sikandin no duwon od kotanggap din. ");
INSERT INTO oboNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piru mid ikahi si Pedro to, “Waa soopi ku, piru duwon ka-ay't koddi no id pokovoggoy ku kikow. Ukit to kotuusan to ngaran ni Disas Krays no toho Nazaret, ipanow ka.” ");
INSERT INTO oboNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Na, id somaddan ni Pedro iddos kowanan no bollad taddot pungku woy id poohinat din. Woy idda ron en, id monokkaa kos pa-a rin. ");
INSERT INTO oboNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","De-en id lohinat sikandin woy id oipanow, woy id duma ron kandan nid usok diyot templo. Laggun tid ipanow ran, id oumbottut sikandin pomon to kahaan woy id doong din kos Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na langun to mgo minuvu rutun, nokita ran iddos pungku no noko-ipanow ron woy id doong diyon to Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","De-en oraroy ran no nosoobbuwan taddot notomanan din, oyyos nokilaa ran man no sikandin en iddos laayun od ounsad nod pokilimus diyot Motoos no Sobbangan. ");
INSERT INTO oboNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na, diyot lugaa nod ngoranan no Balkon ni Solomon, waa id pitas nid somad ongki Pedro iddos pungku pomon to kahaan no no-uliyan don sikandin. Dos mo-uraan minuvu, posidlungkossu no id porani kandan su oraroy ran no nosoobbuwan. ");
INSERT INTO oboNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","To nokita ni Pedro iddos mgo minuvu, id ikohiyan din sikandan to, “Mgo duma ku no koubbaran ni Israel, mambot od kosoobbuwan kow tadda woy mambot od totongtong kow konami? Id popoomdom kow vo no sikami kos nokopo-ipanow kandin pomon to konamin kotuusan woy pomon to morumoruma koy to Monama? ");
INSERT INTO oboNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Konna! Su iddos Monama to keton kovuyyahan no si Abraham, si Isaac woy si Jacob, sikandin en kos id puung ka-ay amoy'd koposivontuhan iddos uripon din no si Disas. Piru sikiyu, id boggoy row moho sikandin diyot bollad to mgo ponguu woy id inoyyuhan dow pe-en sikandin diyot isowwan ni Pilato no gubernador ahad nopuhawang din don nanoy nod sovukan sikandin. ");
INSERT INTO oboNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Uhis sikandin woy Motallong, piru id inoyyuhan dow. Woy iyon dow baling id buyu riyot ki Pilato nod sovukan iddos minuvun mongimatoy. ");
INSERT INTO oboNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Id imotayan dow iddos id pomonnan to umuun waad tomanon, piru id badnow sikandin to Monama, woy sikami, od pokoposivonnaa en ka-ay. ");
INSERT INTO oboNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na, idda en no kotuusan ni Disas kos id ponokkaa ka-ay'n minuvu no nokita woy nokilaa row. Ukit to kopomakoy rin ki Disas, no-uliyan sikandin no matamata row ron en tid kita. ");
INSERT INTO oboNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mgo suwod, nokosaddoo a no sikiyu woy iddos mgo ponguu row, to id po-imotayan dow si Disas, waa row nosorolli ko ondoy sikandin. ");
INSERT INTO oboNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Piru id posaddoo ron tapoy to Monama ukit to langun no propeta, no ko-ilangan nod ti-is to mgo kodposuppit iddos Mesiyas. Na pomon taddot id puungan dow kandin, notuman en iddos id ikahi to Monama ukit kandan. ");
INSERT INTO oboNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","De-en sondit kow woy tanan kowd to mgo saa row, woy livod kowd diyot Monama amoy'd ka-awa ron kos koniyun mgo saa, na od ma-awang kos ginawa row. ");
INSERT INTO oboNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Woy od popiyod din mandon si Disas Krays no Mesiyas no id aam din nod hari keta. ");
INSERT INTO oboNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Piru ko-ilangan nod oubpa pa sikandin diyot datas to langit taman tod lommiyon don to Monama iddos langun iling taddot id posaddoo rin ukit to mgo propeta rin dangan. ");
INSERT INTO oboNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Oyyos duwon id ikahi ni Moises no mid ungketen to, ‘Od popiyod kos Monama to propeta nod pomon da en dinit keta, iling taddot kodpopiyod din koddi ka-ay't koniyu. Ko-ilangan nod dumoruma kow to langun nod osengon din koniyu. ");
INSERT INTO oboNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Dos ahad ondoy no konnod dumoruma taddot osengan din, od po-owan pomon diyot mgo minuvu to Monama amoy'd silutan to kopotayan no waad tomanon.’ ” ");
INSERT INTO oboNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Na kahin Pedro to, “Ungketen dad en mandad iddos mgo propeta no pomon poron to timpu ni Samuel woy dos langun no nokotundug kandin, id ponudtuu mandad moka-atag to kotomanan inin mgo allow. ");
INSERT INTO oboNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Oyyos duwon id tandu dangan to Monama riyot keton kovuyyahan ukit to mgo propeta, woy siketa no mgo Judio, apii taddon tandu. Oyya su mid ikahi sikandin ki Abraham to, ‘Ukit to kikow'n lubbad, od boggayan ku to kopiyannan iddos langun no minuvu ka-ay to ampow't ingod.’ ");
INSERT INTO oboNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","De-en id aam to Monama iddos uripon din no si Disas Krays, woy id popiyod din unna rinit keta no mgo Judio, su amoy od kotovangan ki nod sondit woy'd tanan to morat no pinuungan ta.” ");
INSERT INTO oboNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na, laggun tod ooseng pa si Pedro woy si Juan diyot mgo minuvu, id poroniyan sikandan to mgo tohodbuwis duma to kopitan to mgo tohodtamong to templo woy ahad iddos mgo Saduseo. ");
INSERT INTO oboNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nolingasa ran, su id nonaw iddos oruwon apostoles diyon to mgo minuvu no novadnow en si Disas, woy id ponudtuu ran no idda en kos id posivonnaa no od kovadnow mandad iddos langun nid poomatoy. ");
INSERT INTO oboNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","De-en id ammot dan si Pedro woy si Juan woy id prisu pa tahad sikandan taman to sollom su od kovulli ron man iddot kod-ammot kandan. ");
INSERT INTO oboNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Piru ahad iling tadda, dos mo-uraan nokorinog taddot nonaw ni Pedro, mid pomakoy ran. Woy iddos ko-uralloy taddot mgo mama ra no id pomakoy, id inguma to mgo limmon maan (5,000). ");
INSERT INTO oboNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","So-op no allow, id lolivuung diyot Jerusalem iddos mgo ponguu to Judio duma tod pombuyyahon dan woy dos mgo tohodnonaw to Suhu ni Moises. ");
INSERT INTO oboNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Id lonug kandan si Anas no mowwet no ponguu to mgo tohodbuwis, si Caifas, si Juan, si Alejandro woy dos duma pon korumannan ni Anas. ");
INSERT INTO oboNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Na, id pa-angoy ran si Pedro woy si Juan woy id piyod diyot isowwan dan amoy'd inturan, kahi ran to, “Ingkon pomon kos kotuusan dow no noko-uli ka-ay't pungku? Ondoy man kos id boggoy koniyu ka-ay'n kotungud?” ");
INSERT INTO oboNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na si Pedro no no-iroomman to Uhis no Ispiritu, mid ikahi to, “Mgo ponguu woy od pombuyyahon, ");
INSERT INTO oboNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","otik iyon dow od inturon konami iddos moppiya nid puungan doy ka-ay't pungku woy ko momonnu sikandin no-uliyan, ");
INSERT INTO oboNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ini kos od ko-oseng doy koniyu. Sikiyu woy dos langun no koubbaran ni Israel, ko-ilangan nod koovottan dow no inis minuvu nid lohinat ka-ay't isowwan dow ko-ungkay, no-uliyan pomon to kotuusan ni Disas Krays no toho Nazaret. Sikandin kos id pakpak dow riyon to krus, piru id badnow sikandin to Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Disas iddos batu nod ikohiyon diyot Nosulat no Kahit Monama no mid ungketen to, ‘Iddos batu nid oovoddan to mgo tohodbovaoy, idda vos en kos batu no mosalig no po-unsaran.’ ");
INSERT INTO oboNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Waa ossa nod pokotobbus keta, oyyos ka-ay to intirut ingod, waa ossa no id popiyod to Monama nod tobbus keta, ko konna, si Disas da en.” ");
INSERT INTO oboNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na, pomon to waa kod-aang-aang no kod-ooseng ni Pedro woy Juan, nosoobbuwan iddos mgo ponguu to Judio, su nosorollan dan man no moobbava ra kos no-iskwilan dan woy waa goli nokilaa kos ngaran dan. Woy noponulan dan no inis oruwa, id dumoruma ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pomon to nokita ran no no-uliyan don iddos minuvun pungku nid lohinat diyot duug ni Pedro woy Juan, worad id poko-oseng taddot mgo ponguu. ");
INSERT INTO oboNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","De-en id poleggua ran pa tahad si Pedro woy si Juan pomon diyot Mowwet no Hukumanan, amoy od potongkooy pa sikandan. ");
INSERT INTO oboNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kahi ran to, “Ondan man kos od puungan ta ka-ay'n mgo minuvu? Su nosorollan to langun ka-ay't Jerusalem no nokopuung dan to mokososoobbu. De-en dii ki od poko-oseng no konna mooggot iddon notomanan. ");
INSERT INTO oboNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Piru amoy konnod pokoso-ob inis notomanan, od diiyan tad sikandan nod nonaw moka-atag ki Disas.” ");
INSERT INTO oboNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","De-en id po-umow ran si Pedro woy si Juan woy id loglohottan no dii ron en od ikahi woy od nonaw moka-atag ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piru mid tavak si Pedro woy si Juan, kahi ran to, “Podtiitimbanga row ve-en ko ingkon musing kos ollog diyot kod-ontong to Monama. Idda vo sod dumoruma koy taddot koniyun id kopi-i o iddos id kopi-it Monama? ");
INSERT INTO oboNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Su atag konami, konna koy en od pokosoro nod ponudtuu taddot langun no nokita woy norinog doy pomon ki Disas.” ");
INSERT INTO oboNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","To norinog idda taddot mgo ponguu, id kotasan dan pe-en si Pedro woy si Juan. Piru id sovukan dan dad, oyyos waa man ollog no unayan to kodsilut kandan, woy novaakkan dos mgo ponguu to mo-uraan minuvu no mid doong to Monama pomon taddot mokososoobbun notomanan. ");
INSERT INTO oboNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Oyya su inis minuvu no no-uliyan don ukit to mokososoobbun pinuungan, lampas don to oppat-no-puu kos idad din. ");
INSERT INTO oboNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na, to id sovukan don si Pedro woy si Juan, id tollus dan diyot duma ran nod pompomakoy. Woy id ponudtuu ran iddos langun nid ikahi taddot mgo ponguu to tohodbuwis woy'd pombuyyahon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","To norinog idda to mgo duma ran, id posokaddoy sikandan nid dasaa riyot Monama, kahi ran to, “Longaggon no Motuus, sikkow kos mid bovaa to langit, livuta, dahat woy ahad iddos langun no nokota-aw ka-ay. ");
INSERT INTO oboNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ukit to Uhis no Ispiritu, id po-oseng du iddos kovuyyahan doy no si David no uripon du no mid ungketen to, ‘Mambot oraroy nod kolingasa kos konna mgo Judio? Mambot od popoomdom dan taddot waa koru-anon no mgo puhawang? ");
INSERT INTO oboNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Su iddos mgo hari ka-ay to ampow't ingod woy dos mgo ponguu, nolivuung don amoy'd supak to Monama nod Longaggon woy taddot id aam din no Mesiyas.’ ” ");
INSERT INTO oboNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Monama, notuman don iddos id posulat du ki David, oyyos ka-ay to Jerusalem, nolivuung don onsi Harin Herodes woy dos gubernador no si Poncio Pilato. Nokodsokkad don sikandan duma to langun no Judio woy taddot konna mgo Judio amoy'd supak ki Disas no uhis no uripon nid aam du no Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Iddos langun no id puungan dan, id ikuu taddot tapoy'n puhawang du ukit to kikow'n kotuusan woy id kopi-i. ");
INSERT INTO oboNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na ko-ungkay, od Longaggon, nosorollan du iddos kodkatas dan konami. Tovangi koy no mgo uripon du amoy dii koy od aang-aang nod nonaw to kikow'n kahi. ");
INSERT INTO oboNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pokita ru kos kikow'n kotuusan amoy'd ko-uliyan iddos od pongkovohokan, woy puungiyu iddos mgo mokososoobbu ukit to kotuusan to ngaran ni Disas no uhis no uripon du.” ");
INSERT INTO oboNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","To nopongnga ran don id dasaa, nouva iddos baoy nid lolivuungan dan. Langun dan, id po-iroomman to Uhis no Ispiritu, woy to waa kod-aang-aang, id nonaw ran kos kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na langun tod pompomakoy, nosokkad dos poomdom woy ginawa ran. Woy waa ahad sokkad kandan no noohoddan taddot koruwonnan dan, ko konna, inaayun dan od potovangoy. ");
INSERT INTO oboNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Iddos mgo apostoles, ponayun dan id posivonnaa moka-atag taddot kodbadnow ki Disas nod Longaggon ukit to dakkoon kotuusan no id boggoy kandan. Woy id busbus to Monama dos kopiyannoy rin diyot langun nod pompomakoy. ");
INSERT INTO oboNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Waa sokkad kandan no nokulangan to ko-ilonganon dan, oyyos duwon man duma nod pompomakoy no id boligya to mgo livuta woy baoy ran, ");
INSERT INTO oboNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","woy dos bayad tadda, id piyod dan diyot mgo apostoles amoy id pomboggoy riyot duwon mgo ko-ilonganon. ");
INSERT INTO oboNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na, iling dad en mandad tadda kos id puungan ni Jose no toho Cipre no sokkad taddot koubbaran ni Levi. Id ngoranan sikandin to mgo apostoles ki Bernabe no iddos kohulugan, tohod-inniyat to ginawa. ");
INSERT INTO oboNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mid bovoligya sikandin to livuta woy id piyod din iddos bayad tadda riyot mgo apostoles. ");
INSERT INTO oboNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na, duwon toosawa no id boligya mandad to livuta ran. Iddos mama, id ngoranan ki Ananias woy dos sawa rin, si Safira. ");
INSERT INTO oboNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","To novoligya ran don idda, id piyod ni Ananias iddos bayad diyot mgo apostoles, piru waa rin id amin id boggoy. Woy dos sawa rin, nokosaddoo rad tadda. ");
INSERT INTO oboNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Na kahin Pedro to, “Ananias, mambot id aman ka nod po-iraom to kotuusan ni Moivuyan woy id uhusan du kos Uhis no Ispiritu? Su iddos dumon soopi no id bayad taddot koniyun livuta, id ollos dow moho. ");
INSERT INTO oboNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","To waa row pa novoligya iddon livuta, koniyu me-en idda. Woy to novoligya rowd, koniyu rad en mandon kos bayad tadda. Na, mambo moho tid pomuhawang kow nod puung to morat no iling ka-ay? Konna ra sikami kos id uhusan dow, ko konna, ahad iddos Monama.” ");
INSERT INTO oboNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","To norinog idda ni Ananias, idda ron en nopiloy sikandin woy id patoy. Na, id porani iddos sudduwan no mgo mama woy id bukusan dan iddos minatoy woy id sayung dan po-undiyot leggua amoy id lobbong. Pomon tadda, oray'n novaakkan iddos langun no nokorinog moka-atag taddon notomanan. ");
INSERT INTO oboNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na mgo otollun uras pomon tadda id inguma iddos sawa ni Ananias, piru waa saddoo rin taddon notomanan. ");
INSERT INTO oboNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Mid intud si Pedro kandin, kahi rin to, “Ponudtuu ka koddi to bonnaa. Ini ra ve-en langun kos bayad taddot livuta row?” Mid tavak si Safira to, “Oyya, ika ra en langun.” ");
INSERT INTO oboNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kahin Pedro kandin to, “Mambot nokod-iling kow no toosawa nod geddam to Uhis no Ispiritu? Ontongngiyu! Ika ron to sobbangan kos mid loobbong to sawa ru, su id lobbong ka rad en mandad nikandan!” ");
INSERT INTO oboNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na idda ron en, nopiloy sikandin diyot isowwan ni Pedro woy id patoy. To kod-usok taddot sudduwan no mgo mama, nokita ran no id patoy ron mandad sikandin, de-en id sayung dan idda po-undiyot leggua amoy id lobbong duug taddot sawa rin. ");
INSERT INTO oboNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na, no-od-oratan iddos langun no id lolivuung nod pompomakoy woy dos langun no nokorinog taddon notomanan. ");
INSERT INTO oboNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na, mo-uraa kos mokososoobbun pinuungan to mgo apostoles diyot mgo minuvu. Iddos langun nod pompomakoy, inaayun od lolivuung diyot Balkon ni Solomon. ");
INSERT INTO oboNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ahad mowwet kos kod-ontong to mgo minuvu kandan, duwon en duma no waa id pongaku nod lonug kandan pomon to allak dan. ");
INSERT INTO oboNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Piru ahad iling tadda, ayas pe-en id mo-uraa kos id pomakoy diyon tod Longaggon, mgo mama woy mgo ba-ay. ");
INSERT INTO oboNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na, pomon to mokososoobbun pinuungan to mgo apostoles, id piyod to mgo minuvu iddos od pongkovohokan po-undiyot ibpit to doraanon woy id po-ilogga ran diyot katri woy ikam amoy otid ukit si Pedro, od kovoyan sikandan ahad od kopontokkan dobbot aung din iddos duma. ");
INSERT INTO oboNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Woy id pon-inguma iddos mo-uraan minuvu nid pomon diyot mgo bonuwa no nokolingkus to Jerusalem no id pompiyod mandad tod pongkovohokan woy ahad iddos id ponlosuran to busow, nongo-uliyan dan langun. ");
INSERT INTO oboNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Piru iddos mowwet no ponguu to mgo tohodbuwis woy dos langun no duma rin no Saduseo, oray'n nosina taddot mgo apostoles. ");
INSERT INTO oboNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","De-en id pa-ammot dan iddos mgo apostoles woy id prisu. ");
INSERT INTO oboNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Piru iddon bulli, id lukatan to ponolihan tod Longaggon iddos lokkob taddot prisuwan woy id poleggua rin iddos mgo apostoles. ");
INSERT INTO oboNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Woy id ikohiyan din sikandan to, “Undiyon kow to templo woy ponudtuu row riyot mgo minuvu rutun iddos moka-atag taddot lammin umuu no id pomon diyot ki Disas.” ");
INSERT INTO oboNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","De-en id dumoruma iddos mgo apostoles taddot id ikahi to ponolihan. To sollom poron tadda, mid undiyon dan to templo woy id nonaw. Na, idda mandad so mowwet no ponguu to mgo tohodbuwis woy dos mgo duma rin, id po-umow ran iddos langun no ponguu to mgo Judio duma taddot od pombuyyahon dan amoy'd kolivuung diyot Mowwet no Hukumanan. Na, id pa-angoy ran iddos mgo apostoles diyot prisuwan. ");
INSERT INTO oboNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Piru to kod-inguma taddot id ponsuhu riyot prisuwan, worad dutun iddos mgo apostoles. Purisu id poolivod dan diyon to mgo ponguu woy mid ikahi sikandan to, ");
INSERT INTO oboNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“To kod-inguma roy rutun, nokita roy no id ponoggasan tid lokkob iddos prisuwan, woy dos langun no tohodtamong, dutun dad man id ponloohinat to sobbangan, piru to id lukatan doy iddos lokkob, worad dutun iddos mgo pinirisu nid pa-angoy row nanoy konami!” ");
INSERT INTO oboNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","To norinog idda to kopitan to mgo tohodtamong to templo woy taddot mgo ponguu to tohodbuwis, nongotaong sikandan taddon notomanan to mgo apostoles. ");
INSERT INTO oboNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na, duwon id inguma riyot kandan no mid ikahi to, “Dos mgo minuvu no id prisu row, diyon don to templo woy mid nonaw to mgo minuvu.” ");
INSERT INTO oboNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Idda ron en, iddos kopitan to mgo tohodtamong to templo duma taddot mgo minuvu rin, id undiyon woy id ammot dan mandon iddos mgo apostoles. Piru waa ran posokiti, su od kovaakkan dan to mgo minuvu kod ponlumbahon dan to batu. ");
INSERT INTO oboNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Na, id piyod dan iddos mgo apostoles diyot isowwan to mgo ponguu to Judio, woy id sugga sikandan taddot mowwet no ponguu to mgo tohodbuwis. ");
INSERT INTO oboNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Kahi rin to, “Id loglohottan doyd man nanoy sikiyu no diid nonaw moka-atag taddon minuvu! Piru ayas dow ra en moho id so-ob kos nonaw row ka-ay to intirut Jerusalem, woy iyon dow id kopi-i no sikami kos od sonditan dow taddot kandin no kopotayan!” ");
INSERT INTO oboNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piru mid tavak si Pedro woy dos dumon mgo apostoles, kahi ran to, “Ko-ilangan no iyon doy'd dumannan iddos id kopi-it Monama, konna id kopi-it mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dos Monama to keton kovuyyahan, sikandin kos id badnow ki Disas nid imotayan dow ukit to kodpakpak diyon to krus. ");
INSERT INTO oboNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nopongnga sikandin novadnow, id batun don to Monama woy id posivontuhan ukit to kodpo-unsad diyon lomig to kowanan din, su amoy sikandin kos od hari woy od tobbus keta. Id puungan din idda amoy siketa no koubbaran ni Israel, od sondit woy od tanan to mgo saa amoy'd koposinsyan. ");
INSERT INTO oboNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Na, od posivonnalan doy no inis langun ka-ay, bonnaa en woy id posivonnalan mandad ini to Uhis no Ispiritu no id boggoy to Monama riyot mgo minuvu nid dumoruma kandin.” ");
INSERT INTO oboNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","To norinog idda taddot mgo ponguu to Judio, ayas pe-en sikandan id langot woy kopi-i ran nod imotayan iddos mgo apostoles. ");
INSERT INTO oboNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Piru duwon sokkad no Pariseo no tohodnonaw to mgo Suhu ni Moises woy mowwet kos kod-ontong kandin to langun no minuvu. Iddos ngaran din, si Gamaliel. Mid lohinat sikandin woy id suhu to mgo minuvu nod polegguangon pa tahad iddos mgo apostoles. ");
INSERT INTO oboNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","To nokoleggua ron sikandan, mid ikahi si Gamaliel to, “Mgo duma ku no koubbaran ni Israel, ayyad-ayyad kow tod puungan dow taddon mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Su dangan, duwon sokkad no minuvu nid ngoranan ki Teudas no mid pokita woy id pokilaa nod bontuhon kun sikandin no minuvu, woy duwon mgo oppat no gatus no minuvu no sakup din. Piru to id imotayan don sikandin, iddos langun taddot mgo minuvu rin, nokodsuwoysuwoy woy dos pinuungan din, nowora. ");
INSERT INTO oboNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Woy riyot timpu no id suhu to gubernador no id polista kos mgo minuvu, id loppow si Judas no toho Galilea. Duwon mo-uraan minuvu no nopiyod din, piru id imotayan dad sikandin, woy nokodsuwoysuwoy rad en mandad iddos mgo minuvu rin. ");
INSERT INTO oboNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","De-en ko-ungkay, ini kos od osengon ku koniyu. Yo row monnuwa iddon mgo minuvu woy podtohona row ron sikandan, oyya su otik iddos pinuungan dan, puhawang da to minuvu, konna en idda od pokoponayun. ");
INSERT INTO oboNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Piru ko iddos pinuungan dan, puhawang to Monama, dii kow en od pokoposoro kandan. Konna ra idda, od pokosupak kow pe-en to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","De-en to norinog taddot mgo ponguu to Judio iddos id ikahi ni Gamaliel, id dumoruma sikandan. Na, id po-umow ran iddos mgo apostoles woy id polompossan. Nopongnga, id diiyan dan don sikandan nod nonaw moka-atag ki Disas, idda pa id sovukan. ");
INSERT INTO oboNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na, id leggua iddos mgo apostoles no duwon dakkoon kahaan, su riyot kod-ontong to Monama, od pokogaha ran nod ti-is to kodpo-ilow pomon to ngaran ni Disas. ");
INSERT INTO oboNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na, ipat allow riyot templo woy riyon mandad to mgo baoy ran, id ponayun sikandan nid nonaw woy id ponudtuu to Moppiyon Dinoggan moka-atag ki Disas no sikandin en iddos Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na iddon timpu, to mid enot-enot don id mo-uraa kos od pompomakoy, id langot iddos mgo Judio no Griego kos kinohiyan diyon to mgo Judio no Hebreo kos kinohiyan. Oyya su iddos mgo bau no molitan to Judio no Griego, waa novoggayi to allow-allow no koka-an dan. ");
INSERT INTO oboNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","De-en id po-umow taddot sopuu-oruwon apostoles iddos langun nod pompomakoy. Kahi ran to, “Konna moppiya nod tonanan doy iddos kodponudtuu to kahit Monama amoy'd possi to mgo bau no molitan. ");
INSERT INTO oboNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","De-en mgo suwod, aam kow pomon ka-ay't koniyu to pittun mama no waa id pokosawoy woy no-iroomman to Uhis no Ispiritu woy moraom kos koovottan, oyyos sikandan don kos od tuwossan doy to kotungud taddon pinuungan. ");
INSERT INTO oboNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Woy sikami no mgo apostoles, od kahamit doy kos langun no timpu riyot koddasaa woy kodponudtuu to kahit Monama.” ");
INSERT INTO oboNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Na iddos langun nod pompomakoy, nahaa taddon puhawang, de-en id aam dan si Esteban no mopompomakoy woy no-iroomman to Uhis no Ispiritu. Woy dos duma no id aam dan, onsi Felipe, si Procoro, si Nicanor, si Timon, si Parmenas woy si Nicolas no toho Antioquia no konna Judio, piru nopiyod sikandin to pomokayon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nopongnga, id poohinat sikandan diyot isowwan to mgo apostoles. Na, id dasaa iddos mgo apostoles laggun tid torungngan dan to bollad dan iddos uu taddot pittun mama, patow no sikandan en kos id tuwossan to kotungud. ");
INSERT INTO oboNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","De-en ponayun no nokoso-ob kos kahit Monama. Id mo-uraa pe-en iddos mgo tinodduwan diyot Jerusalem woy mo-uraa mandad kos mgo tohodbuwis no id pomakoy ron to Moppiyon Dinoggan. ");
INSERT INTO oboNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na ini si Esteban, noponnu to eru to Monama woy id boggayan din to kotuusan. De-en mo-uraa kos mokososoobbu no id puungan din diyot isowwan to mgo minuvu. ");
INSERT INTO oboNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Piru duwon dumon mgo minuvu nod pon-apuu to nonaw ni Esteban. Mgo sakup sikandan to simba-an to mgo Judio nod ngoranan no Nokolegguang Pomon diyot Kod-uripon. Inin mgo Judio, toho Cirene, toho Alejandria woy duwon mandad toho Cilicia woy toho Asia. ");
INSERT INTO oboNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Piru waa ran en nokogaha to kod-apuu ki Esteban, oyya su id boggayan man sikandin to moraom no koovottan pomon to Uhis no Ispiritu ukit to kod-ooseng din. ");
INSERT INTO oboNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","De-en duwon id boyaran dan no mgo minuvu amoy'd ooseng to uhus no uvag kun to norinog dan no si Esteban, id sosumpalit ki Moises woy riyot Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pomon tadda, no-ukag iddos mgo minuvu, dos od pombuyyahon to mgo Judio woy dos mgo tohodnonaw to Suhu ni Moises. Id ammot dan si Esteban woy id piyod diyot isowwan tod pombuyyahon to mgo Judio. ");
INSERT INTO oboNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Na, id umow ran kos dumon mgo minuvu amoy od posivonnaa to uhus moka-atag ki Esteban. Kahi ran to, “Ikon minuvu, inaayun od ooseng to morat no od pokosumpalit ka-ay't uhis no templo woy ahad taddot mgo Suhu ni Moises. ");
INSERT INTO oboNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Norinog doy no mid ikahi sikandin, no od gobban ni Disas no toho Nazaret inis templo woy od buwassan iddos mgo botasanon no id po-ikuu ni Moises keta.” ");
INSERT INTO oboNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na, ayas tongtongngi si Esteban taddot langun no sakup to mgo tohodhukum no id pon-unsad dutun, woy nokita ran no iddos bonnong din, id se-aa iling to bonnong to ponolihan. ");
INSERT INTO oboNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na iddos mowwet no ponguu to mgo tohodbuwis, mid intud ki Esteban, kahi rin to, “Mooggot bo inis langun no id ponudtuu ka-ay'n mgo minuvu moka-atag kikow?” ");
INSERT INTO oboNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Mid tavak si Esteban to, “Mgo suwod woy od pombuyyahon to mgo Judio, pominogga row pa inis od osengon ku koniyu. Dangan, to riyon pa to prubinsya to Mesopotamia iddos keton kovuyyahan no si Abraham, id pokita kandin iddos Monama no Motuus to Langun to waa pa sikandin id alin diyot bonuwa to Haran. ");
INSERT INTO oboNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mid ikahi iddos Monama ki Abraham to, ‘Tonaniyu inis ingod du woy dos mgo korumannan du, woy undiyon ka to ingod no id pokita ku kikow.’ ");
INSERT INTO oboNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","De-en id tanan sikandin diyot ingod to Caldea, woy id alin nid oubpa riyot Haran. To id patoy ron kos amoy rin, id pa-alin mandon sikandin to Monama ka-ay't ingod no id ubpan ta ko-ungkay. ");
INSERT INTO oboNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Iddon timpu, waa pa boggayi to Monama si Abraham to livuta, ahad songo-paad dobbo. Piru id tandu to Monama no inin livuta, id boggoy rin en amoy sikandin kos od pongomunoy woy dos koubbaran din. Piru iddon timpu to kodtandu to Monama ki Abraham ka-ay, waa pa anak din. ");
INSERT INTO oboNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mid ikahi iddos Monama kandin to, ‘Dos koubbaran du, od ubpa riyot konna kandan no ingod woy rutun, od uriponnon sikandan woy'd pon-ooyuwon daom to oppat no gatus no lahun. ");
INSERT INTO oboNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Piru od silutan ku en iddos ingod nod uripon kandan. Woy kopongnga, od polegguangon ku sikandan taddon ingod woy od livod mandon ka-ay'n lugaa amoy dini ran od simba koddi.’ ");
INSERT INTO oboNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Na, id suhu to Monama si Abraham no od tupuwan iddos langun no mama su idda en kos patow taddot tandu rin. De-en id tupuwan ni Abraham si Isaac to iko-waun allow pomon to kodtobbow rin. Id tupuwan mandad ni Isaac si Jacob woy ungketen dad en mandad kos id puungan ni Jacob taddot sopuu-oruwon anak din no keton kovuyyahan. ");
INSERT INTO oboNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Na, si Jose no sokkad taddot mgo anak ni Jacob, nosina moho kandin iddos mgo suwod din, de-en id boligya ran sikandin diyot mgo minuvu nod undiyot ingod to Ehipto amoy'd uriponnon. Piru id dumannan dad sikandin to Monama, ");
INSERT INTO oboNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","su id polegguang sikandin pomon taddot langun no kosupittan woy id boggayan mandad sikandin to Monama to moraom no koovottan, de-en oray'n nahaa iddos harit Ehipto kandin. Id aam din si Jose nod ponguu riyon to intirut Ehipto, woy ahad pa iddos langun no korotuwan to hari, no-iraom to kandin no kodponguu. ");
INSERT INTO oboNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Na, id inguma iddos dakkoon gutas diyon to Ehipto woy ahad diyot Canaan, de-en oray'n nosupittan iddos keton kovuyyahan, oyya su worad od ko-ongayan dan to koka-an. ");
INSERT INTO oboNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Piru to norinoggan ni Jacob no duwon koka-an diyot Ehipto, id po-undiyon din iddos mgo anak din no keton kovuyyahan amoy'd bovolli to koka-an. Idda en kos unnon kod-undiyon dan to Ehipto. ");
INSERT INTO oboNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na riyot iko-oruwon kod-undiyon dan, id pokilaa ron si Jose riyot mgo suwod din, woy id posaddoo rin mandad diyot hari iddos moka-atag to mgo korumannan din. ");
INSERT INTO oboNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Na, id pa-angoy ni Jose iddos amoy rin no si Jacob duma taddot langun no korumannan din, woy dos ko-uralloy ran, pittumpuu limma langun. ");
INSERT INTO oboNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","De-en id undiyon si Jacob to Ehipto duma iddos keton kovuyyahan, woy riyon dan id pon-ubpa woy rutun dan en mandad id poomatoy. ");
INSERT INTO oboNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Piru iddos mgo bangkoy ran, id piyod dad diyot bonuwa to Siquem no sakup to ingod to Canaan su riyon id lobbong to lovongngan no id bolli dangan ni Abraham pomon diyot mgo anak ni Hamor. ");
INSERT INTO oboNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“To asow ron iddos timpu nod puungan to Monama iddos tandu rin ki Abraham, ayas pe-en id mo-uraa kos koubbaran taddot keton kovuyyahan diyot Ehipto. ");
INSERT INTO oboNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na, id inguma kos allow no duwon id suvaa no hari riyot Ehipto no waa sinorollan moka-atag ki Jose. ");
INSERT INTO oboNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Id okalan taddon hari iddos keton kovuyyahan woy ayas din sikandan id posupittan, woy id pohos din sikandan nod tanan taddot mgo anak dan no lammi pa id tobbow amoy'd poomatoy. ");
INSERT INTO oboNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“To idda en mandad no timpu, id tobbow si Moises no anak no oray'n motoos diyot kod-ontong to Monama. Na, id tuhanuu sikandin to inoy woy amoy rin diyot baoy ran daom to otollun buwan. ");
INSERT INTO oboNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","To nopohos don sikandan nod tanan ki Moises diyot leggua, nokita sikandin to ba-ay no anak to hari. Id onnat din idda woy id uyag din iling to kandin don en no anak. ");
INSERT INTO oboNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Na, id nonawwan sikandin to langun no sinorollan to mgo toho Ehipto. Woy novantug sikandin pomon to kotuihan to kod-ooseng woy pinuungan din. ");
INSERT INTO oboNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“To oppat-no-puun lahun don si Moises, nokopuhawang sikandin nod lowwi to iling din no koubbaran ni Israel. ");
INSERT INTO oboNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","To kod-inguma rin dutun, nokita rin iddos iling din no lubbad ni Israel no id ayu-ayu taddot sokkad no toho Ehipto. De-en id ponovangan din idda, woy id imotayan din iddos toho Ehipto. ");
INSERT INTO oboNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kunan ni Moises kod koovottan to iling din no tribu no ukit kandin, od polegguangon sikandan to Monama pomon diyot kod-uripon, piru waa ran bos nokaabbot. ");
INSERT INTO oboNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","So-op no allow, nokita ni Moises iddos oruwon koubbaran ni Israel no id po-imotayoy. Id porani sikandin amoy'd gollangon woy'd pod-uliyon din nanoy. Kahi rin to, ‘Mgo suwod, mambot od po-imotayoy kow moho no tooruma kow man!’ ");
INSERT INTO oboNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Piru iddos minuvun id ayu-ayu tat duma rin, id osikoy rin da en baling si Moises woy id ikohiyan din to, ‘Eh, ondoy ka man nod ponguu woy od hukum konami? ");
INSERT INTO oboNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ondan, id kopi-i ru ayu nod imatoy koddi iling taddot id puungan du taddot toho Ehipto govoni?’ ");
INSERT INTO oboNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","To norinog idda ni Moises, id paahuy sikandin woy id oubpa ron diyot ingod to Midian no konna kandin no ingod. Na, dutun don sikandin noko-osawa, woy riyon en mandad id tobbow iddos oruwon anak din no mama. ");
INSERT INTO oboNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“To id lihad kos oppat-no-puun lahun, duwon ponolihan to Monama no mid pokita ki Moises diyot id loglog no sopinit laggun to riyon pa sikandin to noka-awoy-awoy'n lugaa no moranit Buvungan to Sinai. ");
INSERT INTO oboNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Oray'n nosoobbuwan si Moises taddot nokita rin, de-en id poroniyan din iddos sopinit amoy'd ontongngan din. Piru to riyon don sikandin to morani, norinog din kos bawos tod Longaggon no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Siyak kos Monama to kovuyyahan du no onsi Abraham, si Isaac woy si Jacob.’ To norinog idda ni Moises, id pongookoo sikandin to mattag allak din woy dii sikandin od pokogaha nod tongtong tadda. ");
INSERT INTO oboNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Na mid ikahi iddos Monama kandin to, ‘Lusutow kos sandalyas du, su uhis no lugaa inis id lohinatan du. ");
INSERT INTO oboNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nokita ku iddos mopet no notomanan to koddin mgo minuvu no id uripon diyot Ehipto. Woy norinog ku iddos kodnganoy ran, de-en id undini a su od polegguangon ku sikandan pomon diyot kod-uripon. Na, undini kad su sikkow kos id popiyod ku riyot Ehipto.’ ");
INSERT INTO oboNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Na, si Moises en kos id elleyan taddot iling din no koubbaran ni Israel no id pon-ooseng to, ‘Eh, ondoy ka man nod ponguu woy od hukum konami?’ Piru sikandin en kos id aam to Monama nod ponguu woy od polegguang kandan pomon diyot kod-uripon ukit to kodtavang taddot ponolihan no id pokita kandin diyot id loglog no sopinit. ");
INSERT INTO oboNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Si Moises en kos id ponguu taddot keton kovuyyahan to kodleggua pomon diyot Ehipto. Mo-uraa kos mokososoobbun pinuungan din dutun, ahad diyot kod-ukit dan to Moollutun Dahat woy riyon mandad to noka-awoy-awoy'n lugaa daom to oppat-no-puun lahun. ");
INSERT INTO oboNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Woy sikandin en kos id oseng diyot keton kovuyyahan no mid ungketen to, ‘Od popiyod kos Monama to propeta nod pomon da en dinit keta, iling dad en to kodpopiyod din koddi ka-ay't koniyu.” ");
INSERT INTO oboNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Si Moises en kos duma to keton kovuyyahan iddot nolivuung pa sikandan diyot noka-awoy-awoy'n lugaa. Woy sikandin en kos id tongko taddot ponolihan diyot Buvungan to Sinai, woy sikandin kos id tanggap taddot kahit Monama no od pokovoggoy to umuu amoy id boggoy mandad keta. ");
INSERT INTO oboNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Piru waa id dumoruma ki Moises iddos keton kovuyyahan, ko konna, id elleyan dan da en baling sikandin, su iyon od nongkapon to ginawa ran, iddos kodlivod diyot Ehipto. ");
INSERT INTO oboNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Na, laggun to riyon pa si Moises to Buvungan to Sinai, id oseng iddos mgo minuvu ki Aaron no kakoy ni Moises, kahi ran to, ‘Bovaa kad moho to mgo monama nod ponguu keta. Su ini si Moises nid piyod keta pomon diyot Ehipto, waa tad nosorolli ko ondan don kos notomanan din.’ ");
INSERT INTO oboNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","De-en id bovaa ran don to konna bonnaan monama no iddos boyo, iling to natit baka. Nopongnga, id buwisan dan idda woy id pista ran, oyya su nahaa ran taddot id bovallan dan. ");
INSERT INTO oboNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Piru pomon taddot id puungan dan, id inoyyuhan sikandan to Monama. Id podtohon din sikandan nod simba to mgo bitu-on diyot datas to langit, su ini en kos id sulat taddot mgo propeta no mid ungketen to, ‘Sikiyu no koubbaran ni Israel, to riyon kow pa to noka-awoy-awoy'n lugaa daom to oppat-no-puun lahun, id bovuwis kow to mgo oyama row, piru konna atag koddi. ");
INSERT INTO oboNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Iyon dow od piipiyoddon, iddos tolda nod simba-anan dow to konna bonnaan monama row no si Moloc, woy iddos konna bonnaan monama row no si Repan no binovallan pomot boyo to bitu-on. Ini en kos unayan no id pa-ammot woy id popiyod ku sikiyu riyot lugaa no lomig pa riyot ingod to Babilonia.’ ");
INSERT INTO oboNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Dangan, to riyon pa to noka-awoy-awoy no lugaa iddos keton kovuyyahan, id piyod sikandan to tolda no simba-anan. Idda en kos patow taddot tandu to Monama no inaayun en sikandin od duma kandan. Id bovallan dan iddon tolda ukit to ikulan no id pokita to Monama riyot ki Moises. ");
INSERT INTO oboNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","To notanggap taddot koubbaran dan iddos tolda, id piyod dan idda to kod-undini ran timpu to kodponguu ni Josue no nokosuvaa ki Moises. Su id popa-awa to Monama iddos mgo minuvu no id pon-oubpa ka-ay'n livuta, su amoy idda en so keton kovuyyahan kos od pokokomunoy tadda. Iddon tolda, dutun poron to iddon lugaa taman to timpu no id hari si David. ");
INSERT INTO oboNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na, id buyu ni David diyot Monama no od poohinat sikandin to noto-oo no baoy atag to Monama amoy diyon od simba iddos koubbaran ni Jacob. Piru ahad id kahaa-i si David to Monama, waa en sikandin omani, ");
INSERT INTO oboNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ko konna, si Solomon no anak din kos id poohinat tadda. ");
INSERT INTO oboNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Piru iddos Monama no Lampas to Langun, dii en sikandin od oubpa riyot mgo baoy no binovallan da to mgo minuvu. Oyyos duwon id sulat taddot sokkad no propeta no mid ungketen to, ");
INSERT INTO oboNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Iddos langit kos unsaran ku to kodhari woy dos livuta kos od unturan to pa-a ku. De-en konnod kopakoy nod poohinat kow to baoy nod oubpan ku woy konna en mandad od kopakoy nod poohinat kow tod imooyyan ku. ");
INSERT INTO oboNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Oyyos siyak en kos id bovaa to langit woy livuta, ahad iddos langun no nokota-aw ka-ay.’ ” ");
INSERT INTO oboNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Na ponayun mid ikahi si Esteban to, “Sikiyu, mgo motoggas kos uu row woy noko-iling kow to mgo minuvu no waa sinorollan to kahit Monama su od povovongoo kow to kahi rin. Waa en moho od suwayan dow to koniyun kovuyyahan no inaayun od supak to Uhis no Ispiritu! ");
INSERT INTO oboNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Waa en ahad sokkad taddot mgo propeta no waa posuppiti taddot kovuyyahan dow. Oyya su id pon-imotayan dan iddos langun no propeta nid nonaw moka-atag to kod-undini taddot Motallong no uripon din no si Disas. Woy sikiyu en kos id boligya kandin diyot od pongkuntra kandin woy id imotayan dow pe-en sikandin. ");
INSERT INTO oboNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Woy sikiyu iddos nokotanggap taddot mgo Suhu to Monama ukit to mgo ponolihan, piru waa kow id tuman tadda.” ");
INSERT INTO oboNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na, to norinog taddot sakup to mgo tohodhukum iddon mgo osengan ni Esteban, id pongongitoo sikandan to mattag langot dan. ");
INSERT INTO oboNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Piru si Esteban no no-iroomman to Uhis no Ispiritu, id langngag diyot datas to langit. Nokita rin iddos se-aa to kotuusan to Monama no oray'n mosella woy nokita rin mandad si Disas no id lohinat diyon lomig to kowanan to Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kahin Esteban to, “Ontongngi row! Nokita ku iddos langit no nopokesan woy dos Anak to Minuvu no id lohinat lomig to kowanan to Monama!” ");
INSERT INTO oboNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","To norinog dan idda, id pomehes sikandan woy id sosabpong to tolinga ran amoy diid pokorinog taddot osengan ni Esteban. Woy idda ron en, id porongnganoy ran nid dubpu kandin. ");
INSERT INTO oboNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Na, id goyod dan sikandin po-undiyot leggua to bonuwa woy rutun, id ponlumbahan dan sikandin to batu. Woy idda mandad so mgo minuvu no id posivonnaa to uhus moka-atag ki Esteban, id ponlousut to umpak dan no mowwet so bollad amoy moomok kandan nod lumbag to batu. Woy id potomongngan dan iddon umpak to sokkad no sudduwan nod ngoranan ki Saulo. ");
INSERT INTO oboNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Laggun tid ponlumbahan dan si Esteban to batu, id dasaa sikandin no mid ungketen to, “Disas nod Longaggon, tonggapow inis gimukud ku.” ");
INSERT INTO oboNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Na, id lingko-od sikandin woy id oseng to monokkaa no mid ungketen to, “Longaggon, yo ru sikandan sukuti ka-ay't saa ran.” To noko-oseng da en si Esteban tadda, novudtus kos songnga rin. ");
INSERT INTO oboNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Na, id lobbong si Esteban to mgo minuvu no mopompomakoy to Monama woy oraroy ran id pondaawit taddot kopotayan din. Piru si Saulo, nahaa taddot kod-imatoy ki Esteban. Pomon taddot allow to kodpatoy rin, id tigkanoy kos dakkoon kodposuppit tod pompomakoy riyot Jerusalem. Idda en kos unayan no iddos langun nod pompomakoy, nokodsuwoysuwoy riyot mgo prubinsya to Judea woy riyot Samaria. Piru iddos mgo apostoles, waa id tanan dutun. ");
INSERT INTO oboNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Na, ayas id posupittan ni Saulo iddos od ponlolivuung nod pompomakoy. Id ipan din pon-usokki iddos mgo baoy woy id ammot din iddos mgo mama, ahad iddos mgo ba-ay woy id poprisu. ");
INSERT INTO oboNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na, iddos od pompomakoy no nokodsuwoysuwoy, id ponudtuu ran iddos kahit Monama riyot ahad ingkon no lugaa nod ko-ingumannan dan. ");
INSERT INTO oboNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Sokkad kandan, si Felipe. Mid undiyon sikandin to bonuwa to Samaria woy id ponudtuu rin iddos moka-atag to Mesiyas. ");
INSERT INTO oboNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","To norinog taddot mo-uraan minuvu iddos ponudtulon din woy to nokita ran iddos mgo mokososoobbu nid puungan din, id ooyyaran dan sikandin tid pominog. ");
INSERT INTO oboNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Oyyos duwon mgo minuvu no id losuran to mgo busow no no-uliyan. Id pomomehes to monokkaa iddos mgo busow laggun to id ponleggua riyot id ponlosuran dan. Mo-uraa mandad kos mgo minuvu no id patoy kos lawa woy ahad iddos mgo pungku no no-uliyan don. ");
INSERT INTO oboNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","De-en oray'n nahaa iddos mgo minuvu riyot Samaria. ");
INSERT INTO oboNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","To idda ra en no bonuwa, duwon sokkad no minuvu no od kotuig nod madyik no id ngoranan ki Simon. Woy nouhoy ron, oray'd kosoobbuwan iddos langun no toho Samaria pomon to kandin no kotuihan. Id pobporoong sikandin no duwon kotuusan din. ");
INSERT INTO oboNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Langun to worowora woy'd koruwonnan to iddon bonuwa, od pominoggon dan sikandin. Kahi ran to, “Saddook sikandin en iddos duwon kotuusan to Monama no id ngoranan to Dakkoon Kotuusan.” ");
INSERT INTO oboNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Idda en kos unayan no oraroy sikandin od pominoggon taddot mgo toho Samaria, su nouhoy ron no timpu no id kosoobbu-i ran sikandin taddot kodmadyik din. ");
INSERT INTO oboNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Piru to id inguma si Felipe no mid ponudtuu to Moppiyon Dinoggan moka-atag to kodharit Monama woy moka-atag ki Disas Krays, id pomakoy sikandan woy id poboutismu ron iddos mgo mama woy mgo ba-ay. ");
INSERT INTO oboNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na ahad si Simon, id pomakoy woy id poboutismu ron mandad, de-en inaayun don sikandin id dumoruma ki Felipe ahad ingkon. Woy nosoobbuwan sikandin taddot nokita rin no mokososoobbun pinuungan ni Felipe. ");
INSERT INTO oboNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","To norinog to mgo apostoles diyot Jerusalem no id pomakoy ron to kahit Monama iddos mgo toho Samaria, id po-undiyon dan si Pedro woy si Juan. ");
INSERT INTO oboNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","To kod-inguma ran dutun, id dasaa ran atag tod pompomakoy amoy'd kotanggap dan iddos Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Oyyos waa ran poron notanggap iddos Uhis no Ispiritu to noboutismuwan sikandan ukit da to ngaran ni Disas Krays nod Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Na, id torungngan onni Pedro woy Juan to bollad dan iddos uu taddot od pompomakoy, woy idda ron en, notanggap dan iddos Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","To nokita ni Simon no nokotanggap don to Uhis no Ispiritu iddos od pompomakoy ukit to kodtoddung to mgo apostoles to bollad dan diyot uu ran, od boggayan din nanoy to soopi si Pedro woy si Juan. ");
INSERT INTO oboNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Kahi rin to, “Boggayi a ruwon no kotuusan, su amoy iddos ahad ondoy nod kotorungngan to koddin bollad diyot ampow to uu ran, od pokotanggap mandad to Uhis no Ispiritu.” ");
INSERT INTO oboNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Piru mid tavak si Pedro to, “Od pokosahap ka nanoy duma ikos kikow'n soopi riyon to linow't apuy, su kunan du kod kovolli ru kos kotuusan no id boggoy to Monama! ");
INSERT INTO oboNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Waa lavut du ka-ay't id popuungan to Monama konami, oyya su ikos poomdom du, konna motallong diyot kod-ontong to Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","De-en sondit ka woy tanan kad to morat no puhawang du woy dasaa ka riyon tod Longaggon, su saddook od posinsyan din pa kos morat no ingowollon du. ");
INSERT INTO oboNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Su nosorollan ku no oraroy ka en no nosina woy no-uripon ka to saa.” ");
INSERT INTO oboNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Na kahin Simon kandan to, “Dasaa kow riyon tod Longaggon atag koddi amoy konna ku od kosahapan iddos id ikahi row.” ");
INSERT INTO oboNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","To nopongnga id posivonnaa woy id ponudtuu to kahi tod Longaggon si Pedro woy si Juan diyot bonuwa to Samaria, id livod sikandan diyot Jerusalem. Na, id ponudtuu ran iddos Moppiyon Dinoggan diyot mo-uraan bariyu no nongovoyan dan no sakup to Samaria. ");
INSERT INTO oboNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Na, duwon ponolihan tod Longaggon no id pokita ki Felipe woy id ikohiyan sikandin to, “Porava ka ko-ungkay woy ikuu ka to daan no pomon diyot Jerusalem po-undiyon to Gaza.” (Iddon daan, konna oraroy od kovoyan.) ");
INSERT INTO oboNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Purisu mid ipanow si Felipe. To riyon pa sikandin to daan, nokita rin iddos sokkad no minuvu no toho Etiopia nod uli ron pomon to kodsimba riyot Jerusalem. Iddon minuvu, sinolihan sikandin to Rayna to Etiopia nod ngoranan no Candace, woy mowwet kos kotundanan din su tohodtamong man sikandin to langun no korotuwan taddot Rayna. ");
INSERT INTO oboNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Laggun tid sakoy sikandin to kolisa rin, id basa rin iddos libru ni propeta Isaias. ");
INSERT INTO oboNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Na iddos Uhis no Ispiritu, mid ikahi ki Felipe to, “So-utow iddos kolisa woy daag ka tadda.” ");
INSERT INTO oboNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","De-en id lupug ni Felipe iddos kolisa, woy to noso-utan din don idda, norinog din no id basa taddot sinolihan iddos libru ni propeta Isaias. Na mid intud si Felipe kandin, kahi rin to, “Noovottan du vo kos id basa ru?” ");
INSERT INTO oboNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mid tavak iddos sinolihan to, “Waa en, oyyos waa man od paabbotlabbot koddi.” Na, id posakoy rin si Felipe riyot kolisa woy id po-unsad diyot duug din. ");
INSERT INTO oboNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Iddos nokota-aw taddot id basa rin diyot Nosulat no Kahit Monama, mid ungketen to, “Noko-iling sikandin to karnero no od tuyukon amoy'd sumboliyon, woy noko-iling mandad sikandin to natit karnero no diid pomehes laggun tod bongulan, su od tivunok sikandin. ");
INSERT INTO oboNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Id po-ilawan sikandin woy konna ollog kos kodhukum kandin. Wora od poko-oituu moka-atag to koubbaran din, oyya su id poobbavan da man iddos umuu rin ka-ay to ampow't ingod.” ");
INSERT INTO oboNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Na mid ikahi iddos sinolihan diyot ki Felipe to, “Ponudtuu ru koddi ko ondoy inis minuvu nod tommanon ni Isaias ka-ay't id sulat din. Moka-atag bo ini to ko-ugolingun din o riyot ossa?” ");
INSERT INTO oboNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pomon dad en diyon tid basa rin, id paabbotlabbot ni Felipe kandin iddos Moppiyon Dinoggan moka-atag ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Todtahad, id inguma ran diyot lugaa no duwon oweg. Kahi taddot sinolihan diyot ki Felipe to, “Na, duwon man oweg iko-i. Kopakoy vo nod boutismuwan a nikkow?” ");
INSERT INTO oboNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Mid tavak si Felipe to, “Otik mooggot kos kopomakoy ru ki Disas Krays no waa kodduworuwa, kopakoy nod boutismuwan ka.” Kahi taddot sinolihan to, “Id pomakoy a en no si Disas Krays kos Anak to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Na, id posoro taddot sinolihan kos kolisa, woy id ponog dan nid undiyot oweg, woy id boutismuwan sikandin ni Felipe. ");
INSERT INTO oboNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","To id go-un dan don pomon diyot oweg, tigkow ron no nowora si Felipe su id piyod don to Uhis no Ispiritu. Worad sikandin nokita taddot sinolihan, piru id ponayun don sikandin nid uli duma to dakkoon kahaan. ");
INSERT INTO oboNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na si Felipe, nokotaud to riyon don sikandin to bonuwa to Asoto. Woy id ponudtuu rin iddos Moppiyon Dinoggan diyot langun no bonuwa no id boyan din taman tid inguma sikandin diyot Cesarea. ");
INSERT INTO oboNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na iddon timpu, id ayas pe-en iddos lingasa ni Saulo taddot od pompomakoy tod Longaggon, woy id kotasan din sikandan nod imotayan. Id undiyon sikandin to mowwet no ponguu to mgo tohodbuwis, ");
INSERT INTO oboNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","amoy od buyu to mgo sulat diyot mgo ponguu to simba-an to Judio no riyot Damasco. Iddon mgo sulat, id boggoy kandin to kotungud nod ammot to ahad ondoy nod kokita rin nod ikuu taddot nonaw moka-atag ki Disas, mama man o ba-ay, woy od piyoddon din diyot Jerusalem amoy'd prisuwon. ");
INSERT INTO oboNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Na, to od po-undiyon don si Saulo to Damasco woy asow ron sikandin od inguma, tigkow duwon se-aa pomon diyot datas to langit no nokotaddow kandin. ");
INSERT INTO oboNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nopiloy sikandin woy duwon bawos no norinog din no mid ungketen to, “Saulo, Saulo, mambot id posupittan a nikkow?” ");
INSERT INTO oboNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mid ikahi si Saulo to, “Sir, ondoy ka man?” Id tavak iddos bawos no mid ungketen to, “Siyak si Disas no id posupittan du. ");
INSERT INTO oboNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Na, lohinat ka woy ponayun ka undiyon taddon bonuwa su rutun, duwon od ponudtuu kikow ko ondak od puungan du.” ");
INSERT INTO oboNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Iddos mgo duma ni Saulo, nokoloohinat da en to mattag allak dan, su nokorinog sikandan piru waa ran man nokita ko ondoy iddos id ooseng. ");
INSERT INTO oboNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Na, mid lohinat si Saulo piru to kodgimollat din, dii ron sikandin od pokokita. De-en id pikit dobbo sikandin taddot mgo duma rin taman diyot Damasco. ");
INSERT INTO oboNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Daom to otollun allow, dii sikandin od pokokita woy waa sikandin id ka-an ahad id inom. ");
INSERT INTO oboNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na riyot Damasco, duwon sokkad no tinodduwan ni Disas nod ngoranan ki Ananias. Id pokita iddos od Longaggon kandin woy mid ikahi to, “Ananias!” Id tavak si Ananias to, “Longaggon, ini a rad.” ");
INSERT INTO oboNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kahi tod Longaggon to, “Undiyon ka to daan nod ngoranan no Motullid, woy ointud ka riyot baoy ni Judas moka-atag taddot minuvu no toho Tarso no id ngoranan ki Saulo. Ini en no timpu, id dasaa sikandin dutun, ");
INSERT INTO oboNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","woy id pokita ku kandin iddos iling to tohenoppon no od usok ka riyot id ubpan din, woy id ta-aw ru kos bollad du riyot mata rin amoy'd pokokita mandon sikandin.” ");
INSERT INTO oboNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Piru kahin Ananias to, “Longaggon, duwon mo-uraan nokoponudtuu koddi moka-atag taddon minuvu woy dos langun no morat no pinuungan din diyot mgo minuvu ru nid oubpa riyot Jerusalem. ");
INSERT INTO oboNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Woy ko-ungkay, dini ron kun sikandin to Damasco no id boggayan to kotungud to mgo ponguu to tohodbuwis amoy'd omotton koy langun no id simba kikow.” ");
INSERT INTO oboNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Piru kahi tod Longaggon ki Ananias to, “Undiyon kad, su sikandin en kos id aam ku amoy'd nonaw moka-atag koddi riyot konna mgo Judio, diyot mgo hari ran woy riyot koubbaran ni Israel. ");
INSERT INTO oboNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Woy id pokita ku kandin no ko-ilangan nod poko-ukit sikandin to mo-uraan koosayan atag da en koddi.” ");
INSERT INTO oboNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","De-en id undiyonnan ni Ananias iddos baoy no riyon en si Saulo. Woy to kod-usok din dutun, id ta-aw rin kos bollad din diyot mata ni Saulo woy kahi rin to, “Suwod ku no Saulo, iddos od Longaggon no si Disas no id pokita kikow riyot daan to kod-undini ru, sikandin en kos id popiyod koddi ka-ay't kikow amoy'd pokokita ka mandon woy od ko-iroomman ka to Uhis no Ispiritu.” ");
INSERT INTO oboNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Idda ron en, duwon no-uug no immat mgo onnii pomon diyot mata ni Saulo, woy nokokita ron mandon sikandin. Na, id lohinat sikandin woy id poboutismu. ");
INSERT INTO oboNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nopongnga idda, id ka-an sikandin woy id livod don iddos konokkaa rin. Na daom to pilon allow, id oubpa pa si Saulo riyot Damasco duma tod pompomakoy. ");
INSERT INTO oboNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mid undiyon sikandin to mgo simba-an to Judio woy id ponudtuu rin iddos moka-atag ki Disas no sikandin en kos Anak to Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na, iddos langun no nokorinog kandin, nosoobbuwan woy id po-inturoy, kahi ran to, “Konna vo ika me-en no minuvu kos id posuppit taddot id pomakoy ki Disas diyot Jerusalem? Saddook idda en kos dontulon din to kod-undini amoy'd omotton kos od pompomakoy woy'd piyoddon din diyot mgo ponguu to tohodbuwis.” ");
INSERT INTO oboNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Piru iddos komonitoy to kodponudtuu ni Saulo to kahit Monama, id ayas pe-en woy oray'n oggot kos kodposivonnaa rin no si Disas en kos Mesiyas. Purisu iddos mgo Judio no id pon-oubpa riyot Damasco, waa nokotavak kandin. ");
INSERT INTO oboNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","To nouhoy'n timpu no id oubpa sikandin dutun, nosokkad kos puhawang to mgo Judio nod imotayan si Saulo. ");
INSERT INTO oboNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Allow bulli, id oyanan dan si Saulo riyot mgo sobbangan taddon bonuwa amoy'd imotayan otid kokita ran sikandin. Piru duwon nokoponudtuu ki Saulo moka-atag taddon puhawang. ");
INSERT INTO oboNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","De-en sokkad no bulli, id lasud dan si Saulo riyot dakkoon bukag woy id tuntun taddot mgo tinodduwan din diyot divauy to motikang no aavat no nokolingkus tat bonuwa. ");
INSERT INTO oboNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Na, mid undiyon si Saulo to Jerusalem woy to kod-inguma rin dutun, id kopi-i rin nanoy nod lonug tod pompomakoy. Piru waa ran id pongimbonnaa no id pomakoy ron sikandin, de-en langun dan, novaakkan kandin. ");
INSERT INTO oboNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Piru id tovangan sikandin ni Bernabe ukit to kodpiyod kandin diyot mgo apostoles, woy id paabbotlabbot din kandan iddos kodpokita tod Longaggon ki Saulo woy dos kod-oseng kandin to riyon pa sikandin to daan. Id ituu mandad ni Bernabe kandan no riyot Damasco, waa kod-aang-aang ni Saulo to kodponudtuu moka-atag ki Disas. ");
INSERT INTO oboNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","De-en pomon tadda, duma ron si Saulo taddot od pompomakoy ahad ingkon no lugaa riyot Jerusalem, woy waa kod-aang-aang din nod ponudtuu moka-atag ki Disas nod Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Na, id pabbotlabbot ni Saulo taddot mgo Judio no Griego kos kinohiyan iddos moka-atag ki Disas, woy id tavak din iddos kod-apuu ran. Piru id ponlangot da en sikandan woy id pomuhawang nod imatoy kandin. ");
INSERT INTO oboNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","To nosorollan taddot mgo suwod to kopomakoy iddon puhawang, id piyod dan sikandin diyot bonuwa to Cesarea, woy id popo-uli ran diyot Tarso. ");
INSERT INTO oboNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na iddon timpu, id soro ron iddos kodposuppit tod pompomakoy riyot langun no lugaa no sakup to Judea, Galilea woy riyot Samaria. Inaayun sikandan id tovangan to Uhis no Ispiritu, woy idda en kos unayan no mosalig kos kopomakoy ran. Diyot kandan no ko-ubpa, id posivontuhan dan kos od Longaggon duma to allak. Woy ukit mandad to tavang to Uhis no Ispiritu, id timuu pe-en iddos ko-uralloy ran. ");
INSERT INTO oboNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na si Pedro, id undiyonnan din iddos nokod-osso-osson lugaa amoy'd lowwi to mgo minuvu to Monama. Sokkad nid undiyonnan din, iddos bonuwa to Lida. ");
INSERT INTO oboNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Dutun, nokita rin iddos minuvu nod ngoranan ki Eneas. Daom don to waun lahun, id patoy kos lawa rin woy diid poko-onnow pomon taddot bohok din. ");
INSERT INTO oboNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Na kahin Pedro kandin to, “Eneas, id bowiyan kad ni Disas Krays. Lohinat kad woy luunow kos ikam du.” Idda ron en, mid lohinat si Eneas. ");
INSERT INTO oboNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nokita taddot langun no id ubpa riyot Lida woy Saron no no-uliyan don sikandin, de-en id pomakoy sikandan tod Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na riyot bonuwa to Jope, duwon sokkad nod pompomakoy nod ngoranan ki Tabita. (Diyot Griego no kinohiyan, Dorcas kos ngaran din, no iddos kohulugan, saarong.) Mo-uraa kos moppiyon nopuungan din woy kodtavang to mgo worowora. ");
INSERT INTO oboNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Iddon timpu, novohokan sikandin woy idda en kos unayan to kopotayan din. Na, ukit to kod-ikuu to botasanon to mgo Judio, id dihus dan iddos minatoy woy id popooyyas dan diyot datas no kwartu. ");
INSERT INTO oboNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Inis bonuwa to Jope, morani ra pomon diyot Lida. De-en to norinog taddot od pompomakoy no toho Jope no riyon si Pedro to Lida, id posugkawan dan sikandin to oruwon minuvu amoy go-os od undiyon to Jope. ");
INSERT INTO oboNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Purisu id duma si Pedro taddot oruwon minuvu. To kod-inguma ran dutun, id piyod dan si Pedro riyot datas no kwartu no id pooyyasan taddot minatoy. Na iddos langun no ba-ay'n bau, id porani kandin no posidsinoggow, woy id pokita ran ki Pedro iddos mgo tinobbilan ni Dorcas no mgo umpak to no-uyag pa sikandin. ");
INSERT INTO oboNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Kahin Pedro kandan to, “Leggua kow pobbo sinahaw.” To sokkad din dobbo riyot daom, mid lingko-od sikandin woy id dasaa. Nopongnga, id isau sikandin diyot minatoy, kahi rin to, “Tabita, onnow kad!” Idda ron en, id gimollat iddos molitan, woy id unsad to nokita rin si Pedro. ");
INSERT INTO oboNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Id somaddan ni Pedro dos bollad din woy id tovangan din nod lohinat. Na, id umow rin iddos mgo ba-ay'n bau woy dos dumon od pompomakoy, woy id pokita rin kandan si Dorcas no no-uyag don. ");
INSERT INTO oboNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nokoso-ob diyon to intirut bonuwa to Jope iddos dinoggan moka-atag taddon notomanan. Pomon tadda, mo-uraa kos id pomakoy tod Longaggon. ");
INSERT INTO oboNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na si Pedro, nouhoy id oubpa riyot bonuwa to Jope riyot baoy ni Simon no tohodtina to kindaat oyama. ");
INSERT INTO oboNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na riyot bonuwa to Cesarea, duwon sokkad no minuvu nod ngoranan ki Cornelio. Kopitan sikandin to mgo sundau nod ngoranan to Batalyon to Italia. ");
INSERT INTO oboNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Inin minuvu, morumoruma woy duwon allak to Monama, woy ungketen dad en iddos langun no sakup din diyot kandin no baoy. Movoggoyvoggoy sikandin to mgo Judio no worowora woy morasaarasaa. ");
INSERT INTO oboNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sokkad no allow to mgo alas tres to mapun, duwon ponolihan to Monama no id pokita kandin woy mid ikahi to, “Cornelio!” ");
INSERT INTO oboNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Na, id totongtong sikandin taddot ponolihan duma to dakkoon allak woy kahi rin to, “Sir, ondan man?” Mid tavak dos ponolihan to, “Norinog to Monama iddos mgo dosalon du woy nahaa sikandin taddot kodtavang du to mgo worowora, de-en dii ka nikandin od kolingawan. ");
INSERT INTO oboNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ko-ungkay, po-undiyonnow kos mgo minuvu ru to Jope amoy'd angoy ki Simon no id ngoranan mandad ki Pedro. ");
INSERT INTO oboNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Diyon sikandin tahad id oubpa to baoy ni Simon no tohodtina to kindaat oyama. Iddos ubpan din, diyon lomig to ibpit to dahat.” ");
INSERT INTO oboNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","To id tanan don iddos ponolihan, id umow ni Cornelio dos oruwa taddot sudsuhuwon din woy dos sokkad nod kosolihan no sundau no duwon mandad allak to Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Id ponudtuu rin kandan iddos langun no notomanan woy nopongnga, id po-undiyon din sikandan to bonuwa to Jope. ");
INSERT INTO oboNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","So-op no allow, to asow ron od inguma iddos id po-undiyon ni Cornelio to Jope, si Pedro mandad, id penek diyot pattad no atop to baoy amoy'd dasaa. Iddon timpu, moko-untud don kos allow. ");
INSERT INTO oboNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Todtahad, id gutasan don sikandin woy od kopiyan don nanoy nod ka-an, piru laggun tod oilutu pa iddos mgo duma rin, duwon id pokita to Monama kandin. ");
INSERT INTO oboNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Na nokita rin no nopokesan kos langit, woy duwon id tuntun diyot morani rin no immat kesay no mowwag no id pinidbagkos dos tapad ibpit. ");
INSERT INTO oboNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Diyot daom tadda, nokota-aw dos langun no nokod-osso-osson monnanap, dos od pomonanap woy duwon mandad mgo manuk nod layanglayang. ");
INSERT INTO oboNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Na, duwon bawos no norinog din no mid ungketen to, “Pedro, lohinat ka woy sosumbali ka amoy'd pokoka-an ka.” ");
INSERT INTO oboNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piru kahin Pedro to, “Eh, Longaggon, konna a! Su pomon poron to ko-onakoy ku, waa a en nokoka-an to ahad ondan no molibmit no id diiyan diyot pomokayon doy no mgo Judio.” ");
INSERT INTO oboNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mid ungketen mandon iddos bawos to, “Yo ru osenga no molibmit iddos id podlinis don to Monama.” ");
INSERT INTO oboNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ko-otollu ulita iddos nokita woy norinog ni Pedro woy nopongnga, id polivod idda riyot datas to langit. ");
INSERT INTO oboNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Laggun tod popoomdom si Pedro to kohulugan taddot id pokita kandin to Monama, to idda ra en mandad no timpu, notuntulan don iddos baoy ni Simon taddot mgo minuvu no id suhu ni Cornelio, woy riyon dan don to sobbangan. ");
INSERT INTO oboNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Na, id ponguras dan woy id ointud, kahi ran to, “Ka-ay vo id oubpa si Simon no id ngoranan mandad ki Pedro?” ");
INSERT INTO oboNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Laggun tid popoomdom pa si Pedro to kohulugan taddot id pokita kandin to Monama, mid ikahi iddos Uhis no Ispiritu kandin to, “Duwon otollun minuvu nid nonangkap kikow. ");
INSERT INTO oboNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ponog ka woy yo kod ka-aang-aang nod duma kandan, oyyos siyak kos id po-undini kandan.” ");
INSERT INTO oboNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Purisu id ponog si Pedro woy mid ikahi riyot mgo minuvu to, “Siyak kos od nongkapon dow. Na, ondan man kos dontulon dow koddi?” ");
INSERT INTO oboNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mid tavak sikandan to, “Id po-undini koy ni Cornelio no kopitan to mgo sundau. Motallong sikandin, woy duwon allak to Monama woy mowwet kos kod-ontong to langun no Judio kandin. Na, duwon ponolihan to Monama nid ponudtuu kandin no od po-undiyonnon ka to baoy rin su od pominog sikandin tod osengon du.” ");
INSERT INTO oboNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Na, id pa-allus ni Pedro iddos mgo minuvu woy riyon dan don en noomaggi. To so-op no allow, id duma ron si Pedro kandan woy id dumannan mandad sikandin to dumon suwod diyon to kopomakoy no toho Jope. ");
INSERT INTO oboNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Na, id inguma sikandan diyot Cesarea nopongnga iddos sokkad no allow no kod-ipanow. Si Cornelio mandad, id aangat kandan duma taddot mgo korumannan woy mgo oukuy rin no id lolivuung diyot baoy rin. ");
INSERT INTO oboNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","To riyon don si Pedro to sobbangan, id tommu kandin si Cornelio woy mid lingko-od no id ounduk diyot isowwan din. ");
INSERT INTO oboNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Piru id poohinat sikandin ni Pedro woy id ikohiyan din to, “Eh konna! Yo kod lingko-od ka-ay't isowwan ku, su minuvu a ra mandad.” ");
INSERT INTO oboNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Na, id potongkooy ran nid usok diyot daom woy rutun, nokita ni Pedro iddos mo-uraan minuvu nid lolivuung. ");
INSERT INTO oboNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kahi rin kandan to, “Nokosaddoo kowd man no riyot konamin pomokayon no mgo Judio, id diiyan koy nod lommung ahad od lowwi ra to konna mgo Judio. Piru id pokita to Monama koddi no konna ollog nod podlibmiton iddos ahad ondoy no minuvu. ");
INSERT INTO oboNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","De-en to id pa-angoy a nikiyu, waa ad en mid aang-aang nid undini. Na ko-ungkay, ponudtuu row koddi iddos unayan to kodpo-umow row koddi.” ");
INSERT INTO oboNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Mid tavak si Cornelio to, “Iddot otollun allow ron nid lihad, id dasaa a rinit baoy ku to iling dad en ka-ay'n uras to alas tres to mapun. Na, tigkow ron duwon minuvu nid lohinat diyot isowwan ku no oray'n mosella kos umpak. ");
INSERT INTO oboNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Woy kahi rin to, ‘Cornelio, norinog to Monama iddos mgo dosalon du, woy dii rin od kolingawan dos pinuungan du nod tavang to mgo worowora. ");
INSERT INTO oboNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pa-angoy ru riyot Jope iddos sokkad no minuvu nod ngoranan ki Simon no id ngoranan mandad ki Pedro. Id oubpa sikandin diyot ubpan ni Simon no tohodtina to kindaat oyama, woy dos ubpan din, diyon lomig to ibpit to dahat.’ ");
INSERT INTO oboNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","De-en id pa-angoy ku sikkow go-os woy solamat su mid undini ka en. Id lolivuung koy langun ka-ay't isowwan to Monama amoy'd pominog to langun nid po-ikahi tod Longaggon kikow.” ");
INSERT INTO oboNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Na kahin Pedro kandan to, “Ko-ungkay, nosorollan kud no waa en minuvu nod podmusingon to Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Oyya su iddos ahad ondoy no minuvu nid pomon to ahad ingkon no ingod no duwon allak kandin woy'd puung to motallong, od tonggapon din en. ");
INSERT INTO oboNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nosorollan dowd iddos Moppiyon Dinoggan no id popiyod to Monama riyot koubbaran ni Israel no duwon moppiyon koroniyan to mgo minuvu riyot kandin ukit ki Disas Krays nod Longaggon to langun. ");
INSERT INTO oboNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nosorollan dowd mandad iddos notomanan no id tigkanoy riyot Galilea woy riyot langun no ingod to koubbaran ni Israel, nopongnga iddos kodnonaw ni Juan moka-atag to boutismu. ");
INSERT INTO oboNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nosorollan dowd mandad no id aam to Monama si Disas no toho Nazaret woy id boggayan to Uhis no Ispiritu woy kotuusan. Id so-ob sikandin nid puung to moppiya woy id tovangan din iddos langun nid posupittan ni Moivuyan, oyyos id dumannan man sikandin to Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Od pokoposivonnaa koy taddot langun no pinuungan ni Disas diyot Jerusalem woy riyot dumon ingod to mgo Judio. Id imotayan dan sikandin ukit to kodpakpak diyon to krus. ");
INSERT INTO oboNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Piru id badnow sikandin to Monama riyot iko-otollun allow woy id pokita rin konami no no-uyag sikandin. ");
INSERT INTO oboNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Waa sikandin id pokita riyot langun no minuvu, ko konna, diyon da en to konami, su id aam koy man to Monama nod posivonnaa atag kandin. Oyya su laggun to ka-ay pa si Disas, noruma roy pa sikandin nid ka-an nopongnga iddos kodbadnow. ");
INSERT INTO oboNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Id suhu koy nikandin nod ponudtuu to Moppiyon Dinoggan, woy od posivonnalan doy no sikandin en iddos id aam to Monama nod hukum to langun no minuvu no no-uyag woy dos id poomatoy ron. ");
INSERT INTO oboNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Iddos langun no propeta, id posivonnaa moka-atag ki Disas. Id ikahi ran no iddos ahad ondoy nod pomakoy kandin, od posinsyan kos mgo saa ran.” ");
INSERT INTO oboNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Na laggun tid oseng pa si Pedro, no-iroomman to Uhis no Ispiritu iddos langun nid pominog kandin. ");
INSERT INTO oboNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iddos od pompomakoy no mgo Judio no toho Jope nid duma ki Pedro, nosoobbuwan, oyya su ahad iddos konna mgo Judio, no-iroomman don mandad to Uhis no Ispiritu. ");
INSERT INTO oboNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Su iddos kovonnaan tadda, norinog dan no noko-ooseng onsi Cornelio to mgo kinohiyan no waa ran nopohinonawwi, woy id doong dan kos Monama. Na kahin Pedro riyot mgo duma rin to, ");
INSERT INTO oboNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Inis mgo minuvu no konna mgo Judio, nokotanggap to Uhis no Ispiritu iling mandad keta no mgo Judio. Waa minuvu nod pokobaavag nod boutismuwan sikandan ukit to oweg.” ");
INSERT INTO oboNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Purisu id poboutismuwan ni Pedro onsi Cornelio ukit to ngaran ni Disas Krays. Nopongnga sikandan boutismu-i, id owiran dan si Pedro nod oubpa pa to pilon allow riyot kandan. ");
INSERT INTO oboNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na, iddos mgo apostoles woy dos mgo duma ran nod pompomakoy riyot prubinsya to Judea, norinoggan dan no iddos konna mgo Judio, id pomakoy ron mandad to kahit Monama. ");
INSERT INTO oboNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","To id livod si Pedro riyot Jerusalem, iddos od pompomakoy no mgo Judio no oray'd ikuu to mgo botasanon dan, id sawoy kandin. ");
INSERT INTO oboNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Kahi ran to, “Mambo moho tid undiyon ka to konna mgo Judio no waa pontupu-i woy mid ka-an ka duma kandan?” ");
INSERT INTO oboNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","De-en id amin ni Pedro tid ituu kandan iddos langun no notomanan pomon to tigkonayan. ");
INSERT INTO oboNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Kahi rin to, “Laggun tid dasaa a to riyon a pa to bonuwa to Jope, duwon id pokita to Monama koddi. Nokita ku iddos immat kesay no mowwag no id pinidbagkos dos tapad ibpit, woy id tuntun idda pomon diyot datas to langit taman diyot morani ku. ");
INSERT INTO oboNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","To id ontongngan ku idda, nokita ku no duwon nokota-aw no mgo oyama, mgo monnanap to puwaason, dos od pomonanap woy duwon mandad mgo manuk nod layanglayang. ");
INSERT INTO oboNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Woy duwon bawos no norinog ku no mid ungketen to, ‘Pedro, lohinat ka woy sosumbali ka amoy'd pokoka-an ka!’ ");
INSERT INTO oboNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Piru kahi ku to, ‘Eh, Longaggon, konna a! Su 