﻿USE sofia;
DROP TABLE IF EXISTS sofia.nyy_vpl;
CREATE TABLE nyy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nyy_vpl WRITE;
INSERT INTO nyy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ɨsi syo ngamu sya bandʉ abaa nkɨkolo kya Jesu ʉjʉ jo Meesija, ʉgwa nkɨkolo kya malafyale Ndaabɨti na Abulahamu. ");
INSERT INTO nyy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abulahamu aalɨmpaapile Isaka, Isaka aalɨmpaapile Jaakobo, Jaakobo aalɨmpaapile Juuta na baamyabo. ");
INSERT INTO nyy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juuta aalɨmpaapile Pelesi na Sela kwa Tamali. Pelesi aalɨmpaapile Esoloni, Esoloni aalɨmpaapile Alamu, ");
INSERT INTO nyy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamu aalɨmpaapile Aminatabu, Aminatabu aalɨmpaapile Nasoni, Nasoni aalɨmpaapile Salimoni, ");
INSERT INTO nyy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni aalɨmpaapile Boasi kʉ nkasi Lahabu, Boasi aalɨmpaapile Obeti kʉ nkasi Lʉtɨ, Obeti aalɨmpaapile Jese, ");
INSERT INTO nyy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na Jese aalɨmpaapile ʉmalafyale Ndaabɨti. Ndaabɨti aalɨmpaapile Solomoni kʉ nkiikʉlʉ ʉjʉ aalɨ nkasi gwa Ulija, ");
INSERT INTO nyy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni aalɨmpaapile Lehobwamu, Lehobwamu aalɨmpaapile Abija, Abija aalɨmpaapile Asa, ");
INSERT INTO nyy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa aalɨmpaapile Jehosafati, Jehosafati aalɨmpaapile Jolamu, Jolamu aalɨmpaapile Usija, ");
INSERT INTO nyy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usija aalɨmpaapile Jotamu, Jotamu aalɨmpaapile Ahasi, Ahasi aalɨmpaapile Esekija, ");
INSERT INTO nyy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekija aalɨmpaapile Manasi, Manasi aalɨmpaapile Amoni, na Amoni aalɨmpaapile Josija, ");
INSERT INTO nyy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josija aalɨmpaapile Jekonija na baamyabo. Akabalɨlo ako aBanyaisilaɨli baasaamikɨsiigwe mbʉtʉmwa kʉ Babeli. ");
INSERT INTO nyy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bo basaamikɨsiigwe kʉ Babeli, Jekonija aalɨmpaapile Salatyeli, Salatyeli aalɨmpaapile Selubabeli, ");
INSERT INTO nyy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabeli aalɨmpaapile Abihuti, Abihuti aalɨmpaapile Elyakimu, Elyakimu aalɨmpaapile Asoli, ");
INSERT INTO nyy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoli aalɨmpaapile Satoki, Satoki aalɨmpaapile Akimu, Akimu aalɨmpaapile Elihuti, ");
INSERT INTO nyy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihuti aalɨmpaapile Elyasali, Elyasali aalɨmpaapile Matani, na Matani aalɨmpaapile Jaakobo. ");
INSERT INTO nyy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jaakobo aalɨmpaapile Joosefu ʉndʉme gwa Malija. Malija aalɨmpaapile Jesu ʉjʉ jo Meesija. ");
INSERT INTO nyy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Po leelo, ɨsopelo ʉkʉfuma kwa Abulahamu mpaka kwa Ndaabɨti syalɨ kalongo na ina. Ʉkʉfuma kwa Ndaabɨti mpaka ʉkʉfika akabalɨlo aka abandʉ baasaamikɨsiigwe mbʉtʉmwa kʉ Babeli, ɨsopelo syalɨ kalongo na ina. Ʉkʉfuma bo basaamikɨsiigwe kʉ Babeli mpaka ʉkʉpaapigwa kwa Kɨlɨsiti, ɨsopelo syalɨ kalongo na ina. ");
INSERT INTO nyy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ʉkʉpaapigwa kwa Jesu Kɨlɨsiti kwalɨ bo ʉlʉ, Malija ʉnna gwa Jesu aasingɨliigwe na Joosefu. Leelo bo bakaalɨ ʉkwegana, Malija alɨnkʉboneka alɨ nɨ kɨfuba. Ɨkɨfuba ɨkɨ aakabile kʉ maka agaa Mbepo Mwikemo. ");
INSERT INTO nyy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joosefu ʉjʉ aalɨnsingiile Malija aalɨ mundʉ ngolofu, looli akaalondaga ʉkʉnnjwelʉla Malija. Po alɨnkʉtumula ʉkʉnndeka kɨsita kʉnsitaaka pabwelu. ");
INSERT INTO nyy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bo atumwile ɨsyo, ʉgwandʉmi gwa Ntwa alɨnkʉmmwisɨla mu njosi. Ʉgwandʉmi jʉla aalɨmmbʉʉlile aatile, “Joosefu, gwe gwa nkɨkolo kya malafyale Ndaabɨti, ʉlɨngatiilaga ʉkʉmmwega Malija ʉkʉja nkasigo, paapo ɨkɨfuba ɨkɨ alɨ nakyo akabile kʉ maka agaa Mbepo Mwikemo. ");
INSERT INTO nyy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aikʉpaapa ʉmwana ʉndʉmyana. Gwise gʉmpe ɨngamu ɨjaa Jesu, paapo ikwisa kʉbapoka abandʉ baake ʉkʉfuma mbʉtʉlanongwa bwabo.” ");
INSERT INTO nyy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Syosa ɨsi syabombiigwe bo ʉlo ʉkʉtɨ, iisyʉ lɨla lɨboneke ɨlɨ ʉNtwa Kyala aalɨjobile kʉ njɨla jaa nkunguluka ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Keeta! Ʉndɨndwana ʉjʉ akammanyamo sikʉ ʉnnyambala, ikʉja nɨ kɨfuba. Kangɨ aikʉpaapa ʉmwana ʉnnyambala! Po aabikʉmpapo ʉmwana ʉjo ɨngamu ɨjaa Imanweli.” Ɨngamu ɨjo kokʉtɨ, “Kyala alɨ na nuuswe.” ");
INSERT INTO nyy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joosefu bo alembwike, alɨnkʉbomba bo muno ʉgwandʉmi gwa Ntwa aalɨnndagiile, alɨnkʉmmwega Malija ʉkʉja nkasi. ");
INSERT INTO nyy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Looli akaalɨmmeenyemo sikʉ mpaka bo Malija apaapile ʉmwana ʉnnyambala. Po Joosefu alɨnkʉmpa ʉmwana ʉjo ɨngamu ɨjaa Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesu aapaapiigwe nkaaja akaa mu Betelehemu, nkiisʉ ɨkya Jutai, akabalɨlo aka ʉmalafyale Heloti aalongosyaga. Po akabalɨlo ako, nkaaja akaa mu Jelusalemu, balɨnkʉboneka abamanya ndondwa aba baafumile kʉbʉsookelo. ");
INSERT INTO nyy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Abamanya ndondwa bala baalaalʉʉsyaga baatɨgɨ, “Alɨ kʉʉgʉ ʉmwana ʉjʉ apaapiigwe ʉkʉja Malafyale gwa Bajuuta? Tʉmeenye ʉkʉtɨ apaapiigwe paapo tʉlʉbwene ʉlʉtondwa ʉlʉ lʉnangiisye. Jo nongwa ɨjɨ ʉswe twisile kʉkʉmmwipuuta.” ");
INSERT INTO nyy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ʉmalafyale Heloti bo apɨliike ɨsyo, syalɨntaamiisye fiijo pamopeene na bandʉ boosa abaa mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Po alɨnkʉbabʉngaania abapuuti abalongosi boosa na bamanyisi baa ndagɨlo sya Moose, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Meesija ikʉpaapigwa kʉʉgʉ?” ");
INSERT INTO nyy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Abeene balɨnkʉmmwamula balɨnkʉtɨ, “Ikʉpaapigwa mu Betelehemu, nkiisʉ ɨkya Jutai. Ɨsyo syo ɨsi syasimbiigwe nʉ nkunguluka ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Na nungwe gwe kaaja Betelehemu, gwe ʉlɨ nkiisʉ ɨkya kɨkolo kya Juuta, ʉkaja nnandɨ na panandɨ mbʉlongosi ʉbwa kɨkolo kya Juuta! Paapo mmyako mo ikʉfuma ʉndongosi, ʉjʉ ikʉjaga ntiimi gwa bandʉ bangʉ aBanyaisilaɨli.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Po Heloti alɨnkʉbakoolela abamanya ndondwa bala kʉbʉtiitʉ, ʉkʉtɨ biise banndɨngaanie ʉbwanalooli akabalɨlo aka lwababonekiile ʉlʉtondwa lʉla. ");
INSERT INTO nyy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Po alɨnkʉbatʉma kʉ Betelehemu, alɨnkʉbabʉʉla alɨnkʉtɨ, “Namubʉʉke mukapelelesye kanunu mpaka mumanye kʉno aliko ʉmwana ʉjo. Lɨnga mummwagile, mwise muumbʉʉle mbɨmbɨbɨ, ʉkʉtɨ na niine mbʉʉke kʉkʉmmwipuuta.” ");
INSERT INTO nyy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Abamanya ndondwa bala bo bampɨlɨkiisye ʉmalafyale, balɨnkʉsookapo. Ʉlʉtondwa ʉlʉ baalʉbwene kʉbwandɨlo, lwabalongolelaga nkyeni mmyabo, lʉlɨnkwakwɨma pamwanya pabʉjo ʉbʉ aalipo ʉmwana. ");
INSERT INTO nyy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bo balʉbwene ʉlʉtondwa lʉla lwɨmile apo, baahobwike fiijo. ");
INSERT INTO nyy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Po balɨnkwingɨla nnyumba, balɨnkʉmmbona ʉmwana alɨ pamopeene nʉ nna Malija, balɨnkʉfugama, balɨnkʉmmwipuuta. Balɨnkʉsokola ɨfyʉma fyabo, balɨnkʉmmbonola ɨsahabʉ, ʉnkota ʉgwa kʉfuusya na mafuta agaa lʉʉma ʉlʉnunu. ");
INSERT INTO nyy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Piitaasi, Kyala alɨnkʉbasoka mu njosi ʉkʉtɨ balɨngagomokelako kangɨ kwa Heloti. Po balɨnkwenda ɨnjɨla ɨjɨngɨ ʉkʉbʉʉka kʉmyabo. ");
INSERT INTO nyy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Abamanya ndondwa bala bo babʉʉkile, ʉgwandʉmi gwa Ntwa alɨnkʉnsetʉkɨla Joosefu mu njosi, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Sumuka, ʉmmwege ʉmwana nʉ nna, mubopele kʉ Misili. Heloti ikwisa kʉkʉnndonda ʉmwana ʉjo ʉkʉtɨ anngoge. Po mukasyalege kʉlakʉla mpaka pakabalɨlo aka ngwisa kʉbabʉʉla ʉkʉtɨ mugomoke.” ");
INSERT INTO nyy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Po Joosefu aalembwike pakɨlo, aalɨmmwegile ʉmwana nʉ nna, alɨnkʉbopela mbɨbɨmbɨbɨ nabo kʉla kʉ Misili. ");
INSERT INTO nyy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aasyele kʉlakʉla mpaka bo afwile Heloti. Ʉlo mo muno ɨliisyʉ lyaboniike ɨlɨ ʉNtwa Kyala aalɨjobile kʉ njɨla jaa nkunguluka ʉkʉtɨ, “Naalɨnkooliile ʉmwanangʉ ʉkʉfuma kʉ Misili.” ");
INSERT INTO nyy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heloti bo asyageenie ʉkʉtɨ abamanya ndondwa bala bansyobile, aakaleele fiijo. Po alɨnkʉlagɨla ʉkʉtɨ abaana abanyambala boosa abaa mu Betelehemu pamopeene na baa ntwaja ʉtʉpalamani, bagogigwe, ʉkwandɨla abafyele mpaka abaa fyɨnja fibɨlɨ. Aabombile bo ʉlo ʉkʉkongana na kabalɨlo aka aabʉʉliigwe na bamanya ndondwa. ");
INSERT INTO nyy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ʉlo mo muno ɨliisyʉ lyaboniike ɨlɨ ʉnkunguluka Jelemija aajobile ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ɨnguuto ɨngʉlʉmba jaapɨlɨkiigwe mu Lama, jo Laheli ikʉbalɨlɨla abaanaake, kangɨ ikʉkaana ʉkʉmmbatamisya, paapo abaanaake bakajako kʉ bʉʉmi.” ");
INSERT INTO nyy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heloti bo afwile, ʉgwandʉmi gwa Ntwa alɨnkʉnsetʉkɨla kangɨ Joosefu mu njosi kʉla kʉ Misili. ");
INSERT INTO nyy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Alɨnkʉmmbʉʉla alɨnkʉtɨ, “Sumuka, ʉmmwege ʉmwana nʉ nna, ʉgomokeleko kangɨ nkiisʉ kya Isilaɨli, paapo aba baalondaga ʉkʉnngoga ʉmwana ʉjo bafwile.” ");
INSERT INTO nyy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Po Joosefu alɨnkʉmmwega ʉmwana nʉ nna, balɨnkʉsookako, balɨnkʉbʉʉka nkiisʉ kya Isilaɨli. ");
INSERT INTO nyy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Looli bo apɨliike ʉkʉtɨ Alekelajo ikʉlongosya mu Jutai pabʉjo ʉbwa gwise Heloti, alɨnkʉtiila ʉkʉbʉʉka kʉla. Leelo bo asokiigwe mu njosi, alɨnkʉbʉʉka nkiisʉ ɨkya Galilai. ");
INSERT INTO nyy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Alɨnkwakʉtʉʉgala nkaaja akaa mu Nasaleti. Ʉlo mo muno ɨliisyʉ lyaboniike ɨlɨ lyajobiigwe kʉ njɨla jaa bakunguluka ʉkʉtɨ, “Ikwisa kʉjobigwaga ʉkʉja Nnasaleti.” ");
INSERT INTO nyy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ɨfyɨnja fingi bo fikɨndile, aaliko ʉmundʉ jʉmo ɨngamu jaake Johani ʉMoosi, alɨnkʉboneka ndʉngalangala ʉlwa mu Jutai. Aalʉmbɨlɨlaga aatɨgɨ, ");
INSERT INTO nyy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mupɨndʉke, paapo ʉBʉnyafyale bwa kʉmwanya bʉsegeliile nkiisʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Johani jo ʉjʉ aajobiigwe nʉ nkunguluka Jeesaja ʉkʉtɨ, “Ɨliisyʉ lya mundʉ likʉkoolela ndʉngalangala likʉtɨ, ‘Mutendekesye ʉnsebo ʉgwa kwendamo ʉNtwa! Mugolosye ɨnjɨla syake!’ ” ");
INSERT INTO nyy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johani aafwalaga ʉnselekesye gwa lʉsyoja lwa ngamila nʉ kwipinya ʉmpango ʉgwa lʉkoba mu nsana, aalyaga amapalaalɨla nʉ lʉʉki. ");
INSERT INTO nyy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Po abandʉ bammwisɨlaga ʉkʉfuma mu Jelusalemu, nkiisʉ kyosa ɨkya Jutai na baa ntwaja toosa ʉtwa mumbalɨ ʉtwa ndwɨsi Jolitani. ");
INSERT INTO nyy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Biilaataga ɨmbiibi syabo, ʉmwene aaboosyaga ndwɨsi Jolitani. ");
INSERT INTO nyy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Looli baaliko abandʉ bamo aba baabatɨgɨ aBafalisai na Basatukai. Bingi balɨnkwisa ʉkʉtɨ bammbone Johani bo ikʉboosya abandʉ. Johani bo ababwene alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉmwe mwe baa ndʉjungu lwa njoka! Bʉle, mukʉtɨ mubagiile ʉkʉpona ʉlʉfundo lwa Kyala lɨnga mukʉpɨndʉka kʉ bʉsyobi? ");
INSERT INTO nyy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Po munangɨsye ɨseke ɨsi sikʉnangɨsya ʉkʉtɨ mupɨndwike. ");
INSERT INTO nyy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Muleke ʉkwinogona ʉkʉtɨ, ‘Ʉswe taata jo Abulahamu.’ Nikʉbabʉʉla, Kyala abagiile ʉkʉgapela amabwe aga ʉkʉja baana baa Abulahamu! ");
INSERT INTO nyy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ʉlʉ ʉbʉlongi bwa Kyala bʉfikile, bo ʉlwa mundʉ ʉjʉ akolile ɨndwanga, iitendekiisye ʉkʉtumula ɨmipiki. Po ʉmpiki ʉgʉ gʉtikʉpa ɨseke ɨnunu, gukʉtumuligwaga nʉ kʉsopigwa mmooto. ");
INSERT INTO nyy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ʉne ngʉboosya na mɨɨsi ʉkʉnangɨsya ʉkʉtɨ mupɨndwike. Looli kʉnyuma kʉmyangʉ ikwisa ʉjʉ alɨ na maka ʉkʉngɨnda ʉne, ngabagɨsya nʉ kwabʉla ɨfilato fyake. Ʉmwene jo ʉjʉ ikʉboosyaga na Mbepo Mwikemo nʉ mooto. ");
INSERT INTO nyy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Afwene nʉ mundʉ ʉjʉ akolile mmaboko ɨkya kʉlʉlʉʉkɨsya, iitendekiisye ʉkʉlʉlʉʉsya. Bo alʉlʉʉsiisye, ikʉbʉngaania mu ndamba, looli ɨmikʉkʉʉjɨlo ikʉgɨkosya nʉ mooto ʉgʉ gʉtikʉsima sikʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Po nkabalɨlo kala, Jesu aafumile nkiisʉ ɨkya Galilai, alɨnkwisa kwa Johani kʉ lwɨsi Jolitani, ʉkʉtɨ Johani ammoosye. ");
INSERT INTO nyy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Looli Johani aagelile ʉkʉkaana, alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Po silɨ bʉleebʉle ʉkʉtɨ ʉgwe gwise kʉmyangʉ? Ʉne ne ngʉlondigwa ʉkoosigwa na nungwe.” ");
INSERT INTO nyy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Looli Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Bomba ɨsi ʉlʉ, paapo tukʉlondigwa ʉkʉbanangɨsya abandʉ ʉbʉpoki bwa Kyala.” Po Johani aaliitiike, alɨnkʉmmoosya. ");
INSERT INTO nyy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesu bo oosiigwe, alɨnkʉfyʉka pi isɨɨlya. Nakalɨnga kʉmwanya kʉlɨnkwigʉka, alɨnkʉmmbona Mbepo gwa Kyala ikʉsuluka pamwanya pamyake, nʉ mbɨlɨ bo ʉgwa ngʉnde. ");
INSERT INTO nyy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ɨliisyʉ lya Kyala ʉkʉfuma kʉmwanya, lɨlɨnkʉtɨ, “Ʉjʉ jo Mwanangʉ ʉNkʉndwe, ʉjʉ niikyeliile nagwe.” ");
INSERT INTO nyy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Po Jesu alɨnkʉlongosigwa na Mbepo Mwikemo ʉkʉbʉʉka ndʉngalangala ʉkʉtɨ akageligwe na Seetano. ");
INSERT INTO nyy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Alɨnkʉfipɨɨka ɨfindʉ amasikʉ amalongo mana pakɨlo na pamuusi. Po kʉmmalɨɨkɨsyo, ɨnjala jɨlɨnkʉnndʉma. ");
INSERT INTO nyy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Po Seetano alɨnkwisa kʉkʉnngela alɨnkʉtɨ, “Lɨnga ʉgwe ʉlɨ Mwana gwa Kyala, gabʉʉle amabwe aga gasanuke ʉkʉja fisyesye.” ");
INSERT INTO nyy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ʉkʉlya fyene ɨfindʉ ʉmundʉ akabagɨla ʉkʉja mʉʉmi, looli ikʉja mʉʉmi lɨnga ikʉgakonga amasyʉ goosa agaa Kyala.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Po Seetano alɨnkʉntwala Jesu mpaka nkaaja akiikemo akaa mu Jelusalemu, alɨnkʉmmbɨɨka ndʉpaso lwa tempeli apa palɨ pamwanya fiijo, ");
INSERT INTO nyy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","alɨnkʉmmbʉʉla alɨnkʉtɨ, “Lɨnga ʉgwe ʉlɨ Mwana gwa Kyala, isope paasi. Ʉtikʉfulala, paapo sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Kyala ikʉbatʉma abandʉmi baake kʉnongwa jaako, kangɨ bikʉkʉpɨmba mmaboko gaabo, ʉkʉtɨ ʉngafulala ɨkɨlʉndɨ kyako pi ibwe.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Keeta, sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ʉlɨnganngelaga ʉNtwa Kyala gwako.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Po Seetano alɨnkʉntwala mpaka pamwanya pa kyamba ɨkɨtali fiijo, alɨnkʉnnangɨsya ɨfiisʉ fyosa ɨfya pakiisʉ nʉ bʉsisya bwake, ");
INSERT INTO nyy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","alɨnkʉmmbʉʉla alɨnkʉtɨ, “Lɨnga kʉfugama nʉ kʉʉnyiipuuta, angʉkʉpa fyosa ɨfi.” ");
INSERT INTO nyy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Sookapo apa Seetano! Keeta, sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ʉmmwipuutege ʉNtwa Kyala gwako. Kangɨ ʉmmbombelege mwene itolo.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Po Seetano alɨnkʉnndeka Jesu, balɨnkwisa abandʉmi baa Kyala, balɨnkʉmmbombela. ");
INSERT INTO nyy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Akabalɨlo kala Johani aapinyiigwe mu nnyololo. Jesu bo apɨliike ɨnongwa ɨsi, alɨnkʉsookapo pala, alɨnkʉbʉʉka nkiisʉ ɨkya Galilai, alɨnkʉfika nkaaja akaa mu Nasaleti. ");
INSERT INTO nyy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Po alɨnkʉsookamo mu Nasaleti, alɨnkwakʉtʉʉgala mu Kapelinaʉmu, akaaja aka kalɨ mumbalɨ mwa sʉmbɨ Galilai, mu mpaka gwa kiisʉ ɨkya mu Sabuloni nɨ kya mu Nafutali. ");
INSERT INTO nyy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Syabombiigwe bo ʉlo ʉkʉtɨ iisyʉ lɨla lɨboneke ɨlɨ Kyala aajobile kʉ njɨla jaa nkunguluka Jeesaja ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ɨkiisʉ ɨkya mu Sabuloni nɨ kya mu Nafutali, filɨ mu njɨla ɨjaa kʉbʉʉka kwa sʉmbɨ, kwi isɨɨlya ɨlya lwɨsi Jolitani. Ʉko kʉ Galilai ko kʉno bikʉtʉʉgala abandʉ aba bakaja Banyaisilaɨli. ");
INSERT INTO nyy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Abandʉ aba bikʉtʉʉgala mu ngiisi, balʉbwene ʉlʉmuli ʉlʉnywamu. Aba bikʉtʉʉgala mu nsyʉngʉʉlʉ ʉgwa bʉfwe, ʉlʉmuli ʉlwa nʉlʉbʉnjʉ lʉbamulɨkiile.” ");
INSERT INTO nyy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ʉkʉfuma akabalɨlo kala, Jesu alɨnkwanda ʉkʉlʉmbɨlɨla alɨnkʉtɨ, “Amupɨndʉkege, paapo ʉBʉnyafyale bwa kʉmwanya bʉsegeliile.” ");
INSERT INTO nyy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesu endaga mumbalɨ mwa sʉmbɨ Galilai, alɨnkʉbabona abalobi babɨlɨ, Simoni ʉjʉ bantɨgɨ Peeteli, nʉ gwamyabo Andeleja. Babɨlɨ abo baataagɨlaga ʉlwelo mwa sʉmbɨ. ");
INSERT INTO nyy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mungongege! Nikʉbapela ʉkʉja balobi baa bandʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nakalɨnga balɨnkʉsileka ɨnyeelo syabo, balɨnkʉnkonga. ");
INSERT INTO nyy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bo endilepo nkyenipo panandɨ, alɨnkʉbabona abanyamundʉ abangɨ babɨlɨ, Jaakobo nʉ gwamyabo Johani, abanya Sebetai. Abandʉ babɨlɨ abo baalɨ mwi ibooti pamopeene nʉ gwisabo, baatendekesyaga ɨnyeelo syabo. Jesu alɨnkʉbakoolela boope. ");
INSERT INTO nyy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nakalɨnga, balɨnkʉlɨleka iibooti pala nʉ gwisabo, balɨnkʉnkonga Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesu aasyʉngʉʉtɨlaga moosa mu Galilai, ingɨlaga mu sinagogi, aabamanyisyaga abandʉ, aalʉmbɨlɨlaga ɨNdʉmi ɨNunu ʉkʉtɨ ʉBʉnyafyale bwa kʉmwanya bʉsegeliile nkiisʉ, nʉ kʉbabʉmbʉlʉsya ʉbʉbine bwabo boosa. ");
INSERT INTO nyy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Po ɨnongwa syake silɨnkʉbalanila mpaka nkiisʉ kyosa ɨkya Silija. Abandʉ balɨnkʉntwalɨla ababine boosa abaa lʉko nʉ lʉko. Ndɨ abo baalimo aba baalɨ babine fiijo, aba bakoliigwe nɨ mbepo ɨnyali, abaa inyiki na aba balalile. Jesu aababʉmbʉlwisye boosa. ");
INSERT INTO nyy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Po abandʉ bingi fiijo bankongaga ʉkʉfuma mu Galilai, mu Ndekapoli, mu Jelusalemu, mu Jutai na kwi isɨɨlya ɨlya lwɨsi Jolitani. ");
INSERT INTO nyy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesu bo akɨbwene ɨkɨlʉndɨlo ɨkya bandʉ, alɨnkʉfyʉka pa kyamba. Po bo atʉʉgeele, abafundigwa baake balɨnkʉnkonga, ");
INSERT INTO nyy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","alɨnkwanda ʉkʉbamanyisya, alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Basajiigwe aba bikʉnndonda fiijo Kyala mu ndumbula syabo, paapo ʉBʉnyafyale bwa kʉmwanya bwabo. ");
INSERT INTO nyy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Basajiigwe aba basulumeenie, paapo Kyala ikwisa kʉbasʉʉbɨsya. ");
INSERT INTO nyy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Basajiigwe abooloolo, paapo Kyala ikwisa kʉbapa ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Basajiigwe aba balɨ nɨ njala nɨ kyʉmɨlwa ɨkya bʉgolofu, paapo Kyala ikwisa kʉbapela ʉkwikʉta. ");
INSERT INTO nyy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Basajiigwe aba bikʉbapaakɨsya abangɨ, paapo Kyala ikwisa kʉbapaakɨsya boope. ");
INSERT INTO nyy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Basajiigwe aba balɨ nɨ ndumbula ɨnyeelu, paapo bikwisa kʉmmbona Kyala. ");
INSERT INTO nyy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Basajiigwe aba bikʉbafwania abandʉ, paapo Kyala ikʉbakoolelaga ʉkʉtɨ baanaake. ");
INSERT INTO nyy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Basajiigwe aba bikʉtaamigwa kʉnongwa jaa kʉbomba ɨsya bwigane bwa Kyala, paapo ʉBʉnyafyale bwa kʉmwanya bwabo. ");
INSERT INTO nyy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Musajiigwe ʉmwe mwe abandʉ bikʉbatʉka, bikʉbataamya nʉ kʉbajobela ɨmbiibi nyingi ɨsya bʉtʉngʉlʉ, kʉnongwa jangʉ. ");
INSERT INTO nyy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Boope abiisʉkʉlʉ baabo, baababombelaga abakunguluka aba baaliko ijolo bo lʉlʉʉlo. Po musekelege fiijo, paapo Kyala ababɨɨkiile ɨfihombigwa ɨfinywamu kʉmwanya.” ");
INSERT INTO nyy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ʉmwe mulɨ bo ʉmuunyu kʉ bandʉ boosa. Looli ʉmuunyu lɨnga gʉsʉʉkile, ʉbagiile bʉleebʉle ʉkʉgomokesyamo ʉbʉnunu? Gʉkaja na mbombo najɨmo, looli ʉkʉtaagigwa panja nʉ kʉkanyigwa na bandʉ. ");
INSERT INTO nyy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ʉmwe mulɨ bo ʉlʉmuli kʉ bandʉ boosa. Akaaja aka kajengiigwe pa kyamba, kakabagɨla ʉkwifisa. ");
INSERT INTO nyy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kangɨ abandʉ batikwasya ɨnyaale nʉ kʉjɨkupɨkɨla nɨ kiibo, looli bikʉjɨbɨɨka pa kɨkolela nyaale, ʉkʉtɨ jɨbamulɨkɨlege boosa aba balimo nnyumba. ");
INSERT INTO nyy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bʉbʉʉbo ʉlʉmuli lwɨnu lʉmulɨkege nkyeni mmbandʉ ʉkʉtɨ basibonege ɨmbombo syɨnu ɨnunu, bantuufyege ʉGwiseemwe ʉgwa kʉmwanya.” ");
INSERT INTO nyy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mulɨngiinogonaga ʉkʉtɨ naaliisile kʉkʉsyomola ɨndagɨlo sya Moose, pamo ɨsi baajobile abakunguluka. Mma, ngaaliisile kʉkʉsyomola, looli naaliisile ʉkʉtɨ syosa ɨsi aajobile Kyala siboneke. ");
INSERT INTO nyy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nalooli nikʉbabʉʉla, kʉpepe ʉkoomoka ʉmpaalanga nɨ kiisʉ, ʉkʉkɨnda ʉkoomoka akasyʉ kamo akanandɨ akaa mu ndagɨlo sya Moose, mpaka syosa ɨsi silimo siboneke. ");
INSERT INTO nyy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mu ndagɨlo ɨsyo, gwesa ʉjʉ ikʉkilania ʉlʉlagɨlo lʉmo ʉlʉnandɨ, nʉ kʉbamanyisya abangɨ ʉkʉtɨ boope bakilanie, ʉjo jo ikwisa kʉjobigwaga ʉkʉja nnandɨ mBʉnyafyale bwa kʉmwanya. Looli gwesa ʉjʉ ikʉsikonga nʉ kʉbamanyisya abangɨ, ʉkʉtɨ boope basikonge, ʉjo jo ikwisa kʉjobigwaga ʉkʉja nkʉlʉmba mBʉnyafyale bwa kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nikʉbabʉʉla nikʉtɨ, Kyala atikwisa kʉbambɨlɨla ʉmwe mBʉnyafyale bwake, lɨnga ʉbʉgolofu bwɨnu bʉkabʉkɨnda ʉbʉgolofu bwa Bafalisai, nʉ bwa bamanyisi baa ndagɨlo sya Moose.” ");
INSERT INTO nyy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mupɨliike ʉkʉtɨ abandʉ abaa ijolo baabʉʉliigwe ʉkʉtɨ, ‘Ʉlɨngagogaga, nʉ kʉtɨ ʉmundʉ gwesa ʉjʉ ikʉnngoga ʉnnine, gwa kʉlongigwa.’ ");
INSERT INTO nyy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Looli ʉne nikʉbabʉʉla nikʉtɨ, ʉmundʉ gwesa ʉjʉ ikʉnkalalɨla ʉnnine, gwa kʉlongigwa. Kangɨ ʉmundʉ gwesa ʉjʉ ikʉntʉka ʉmwitɨki ʉnnine amaheelu, gwa kʉlongigwa pa lʉkomaano. Kangɨ ʉjʉ ikʉntʉka ʉmwitɨki ʉnnine ikʉtɨ, ‘Ʉgwe ʉlɨ nkonyofu,’ ʉjo gwa kʉtaagigwa ndʉpanga lwa mooto! ");
INSERT INTO nyy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Po lɨnga kʉsoosya iikemo lyako pa kɨgemo, leelo ʉkʉmbwike ʉkʉtɨ ʉntʉlile ɨnongwa ʉnnino, ");
INSERT INTO nyy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ʉlɨleke iikemo lyako pa kɨgemo, bʉʉka taasi ʉkamanyane nʉ nnino jʉla. Po gwisege kʉkʉsoosya iikemo lyako ɨlyo. ");
INSERT INTO nyy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kangɨ lɨnga ʉmundʉ jʉmo ikʉkʉtwala kʉ ndongi, nakalɨnga ʉnsʉʉme ʉkʉtɨ mupɨlɨkɨsanie. Kɨsita kʉbomba bo ʉlo, ikʉkʉfikɨsya kʉ ndongi, joope ʉndongi ikʉkʉtwala kʉ nsikali, ʉnsikali ikʉkʉsopa mu nnyololo. ");
INSERT INTO nyy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nalooli nikʉkʉbʉʉla, ʉtikwisa kʉsooka nkatɨ mula mpaka ʉhombe fyosa, ɨfi kʉmeleligwa!” ");
INSERT INTO nyy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mupɨliike ʉlʉlagɨlo ʉlʉ lukʉtɨ, ‘Ʉlɨngalogwaga.’ ");
INSERT INTO nyy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Looli ʉne nikʉbabʉʉla nikʉtɨ, ʉmundʉ gwesa ʉjʉ ikʉnkeeta ʉnkiikʉlʉ nʉ kʉnnyonywa, bo alogilwe nagwe mu ndumbula jaake. ");
INSERT INTO nyy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Lɨnga ɨkɨsige kyako kikʉkʉsofya, kɨfyʉle nʉ kʉkɨtaaga pabʉtali na nungwe! Kʉnunu ʉkʉsobesya akambakaasya kamo akaa mbɨlɨ gwako, ʉkʉkɨnda ʉmbɨlɨ gwako goosa ʉkʉtaagigwa ndʉpanga lwa mooto. ");
INSERT INTO nyy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kangɨ lɨnga ɨkɨboko kyako kikʉkʉsofya, ʉkɨbuute nʉ kʉkɨtaaga pabʉtali na nungwe! Kʉnunu ʉkʉsobesya akambakaasya kamo akaa mbɨlɨ gwako, ʉkʉkɨnda ʉmbɨlɨ gwako goosa ʉkwingɨla ndʉpanga lwa mooto.” ");
INSERT INTO nyy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kangɨ mupɨliike ʉlʉlagɨlo ʉlʉ lukʉtɨ, ‘Ʉmundʉ gwesa ʉjʉ ikʉnndeka ʉnkasi, ampege kalata ʉgwa kʉnsoosya.’ ");
INSERT INTO nyy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Looli ʉne nikʉbabʉʉla nikʉtɨ, gwesa ʉjʉ anndekile ʉnkasi, bo akankola mbʉlogwe, ʉnkiikʉlʉ jʉla lɨnga ikʉbʉʉka kʉkwegigwa kangɨ, ʉjo abapelile abandʉ abo babɨlɨ ʉkʉja balogwe, ʉnkiikʉlʉ jʉla nʉ ndʉme.” ");
INSERT INTO nyy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mupɨliike ʉkʉtɨ abandʉ abaa ijolo baabʉʉliigwe ʉkʉtɨ, ‘Lɨnga mukʉlapa kʉ Ntwa, mulɨngoonangaga. Looli mubombege syosa ɨsi mulapile kʉ Ntwa Kyala.’ ");
INSERT INTO nyy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Looli ʉne nikʉbabʉʉla nikʉtɨ, mulɨngalapaga sikʉ, nalɨnga ko kʉlapɨla kʉmwanya, paapo kyo kɨkota kya Kyala, ");
INSERT INTO nyy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","pamo kʉkiisʉ, paapo kyo kɨkota kya Kyala ɨkya kʉbɨɨkapo amalʉndɨ gaake, pamo kʉ Jelusalemu, paapo ko kaaja kaa Malafyale ʉNkʉlʉmba. ");
INSERT INTO nyy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kangɨ mulɨngalapaga kʉ mitʉ gyɨnu, paapo mukabagɨla ʉkwandʉla nʉ lʉnywili lʉmo ʉlwa nywili syɨnu ʉkʉja lwelu pamo lʉtiitʉ. ");
INSERT INTO nyy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Looli mujobege lyene ɨlya kʉtɨ, ‘Eena,’ lɨnga mukwitɨka, nɨ lyakʉtɨ, ‘Mma,’ lɨnga mukʉkaana, paapo ɨsya kongelapo palɨ ɨsyo, sikʉfuma kʉ mbiibi jʉla Seetano.” ");
INSERT INTO nyy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mupɨliike ʉlʉlagɨlo ʉlʉ lukʉtɨ, ‘Ɨkɨsige kʉ kɨsige nɨ liino kʉ liino.’ ");
INSERT INTO nyy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Looli ʉne nikʉbabʉʉla nikʉtɨ, mulɨngagomokesyaga ʉbʉbiibi kʉ mundʉ ʉjʉ ababombiile ʉbʉbiibi. Lɨnga ʉmundʉ akʉkomile ʉlʉsaja ʉlwa kʉ kiilɨɨlo, ʉnsanukɨsye nʉ lwa kʉ kiimama. ");
INSERT INTO nyy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kangɨ lɨnga ʉmundʉ akʉsitaakile ʉkʉtɨ eege ɨsyatɨ jaako, nndekele ni ikoti. ");
INSERT INTO nyy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kangɨ lɨnga ʉmundʉ ikʉkʉfimbɨlɨsya ʉkwitwɨka ɨkɨtwalo kyake ʉkwenda ɨkilomita jɨmo, bʉʉkaga nagwe ɨkilomita ibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kangɨ lɨnga jʉmo ikʉkʉsʉʉma fimo, ʉmpege. Kangɨ lɨnga ʉmundʉ ikʉlonda ʉkʉkopa fimo, ʉlɨngammwimaga.” ");
INSERT INTO nyy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mupɨliike Kyala ikʉtɨ, ‘Ʉbaganege abanino,’ abandʉ bikʉtɨ, ‘Ʉbabengege abalʉgʉ baako.’ ");
INSERT INTO nyy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Looli ʉne nikʉbabʉʉla nikʉtɨ, mubaganege abalʉgʉ bɨɨnu. Kangɨ mubasʉʉmɨlege kwa Kyala boosa aba bikʉbataamya. ");
INSERT INTO nyy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Po mukʉjaga baana baa Gwiseemwe ʉgwa kʉmwanya, paapo ʉmwene iisʉba lyake likʉbamulɨkɨla abandʉ abanunu na babiibi, nɨ fula jaake jikʉbatimɨla abandʉ abagolofu pamopeene na aba bakaja bagolofu. ");
INSERT INTO nyy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lɨnga mukʉbagana beene aba babaganile ʉmwe, mukʉsʉʉbɨla ʉkʉkaba ɨfihombigwa filɨkʉ? Bʉle, abasongesya songo boope batikʉbagana beene aba babaganile? ");
INSERT INTO nyy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kangɨ lɨnga mukʉbaponia beene abiinɨɨnu, bo mubombile ɨsya fiki ʉkʉbakɨndapo abangɨ? Keeta boope aba batikʉmmwitɨka Kyala boope bikʉbaponia abiinaabo. ");
INSERT INTO nyy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Po mujege bagolofu bo ʉlwa Gwiseemwe ʉgwa kʉmwanya ʉngolofu.” ");
INSERT INTO nyy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mwikeetege mulɨngabombaga ɨmbombo ɨsi sibagiisye nkyeni mmbandʉ ʉkʉtɨ bababone, paapo lɨnga mukʉbomba bo ʉlo, mutikwisa kwambɨlɨla ɨfihombigwa ʉkʉfuma kʉ Gwiseemwe ʉgwa kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Po leelo bo kʉbatʉʉla abalondo, ulɨngiifumusyaga, bo muno bikʉbombela abasyobi mu sinagogi na mu njɨla, ʉkʉtɨ abandʉ babatuufye. Nalooli nikʉbabʉʉla, bambɨliile kɨlɨngaani ɨfihombigwa fyabo. ");
INSERT INTO nyy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Looli ʉgwe bo kʉbatʉʉla abalondo, ɨkɨboko kyako ɨkiimama kɨlɨngamanyaga ɨsi ɨkɨboko kyako ɨkiilɨɨlo kikʉbomba, ");
INSERT INTO nyy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ʉkʉtɨ ʉbʉtʉʉli bwako bʉjege bwa mbʉtiitʉ, paapo ʉGwiseemwe ʉjʉ ikʉsibona ɨsi sikʉbombigwa mbʉtiitʉ, ikwisa kʉkʉhomba. ");
INSERT INTO nyy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Lɨnga mukwipuuta kwa Kyala, mulɨngajaga bo abasyobi, paapo abeene biiganile ʉkwinangɨsya kʉ bandʉ bo balɨ pakwipuuta kwa Kyala mu sinagogi, na mu nyaagano ɨsya njɨla, ʉkʉtɨ abandʉ babatuufye. Nalooli nikʉbabʉʉla, bambɨliile kɨlɨngaani ɨfihombigwa fyabo. ");
INSERT INTO nyy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Looli ʉgwe bo kwipuuta kwa Kyala, gwingɨlege kʉ sofu nʉ kwigala ʉlwigi, po gwipuutege kwa Taata Kyala ʉjʉ atikʉboneka. Jo ʉjʉ ikʉsibona ɨsi sikʉbombigwa mbʉtiitʉ, ikwisa kʉkʉhomba. ");
INSERT INTO nyy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kangɨ bo mukwipuuta kwa Kyala, mulɨngajobaga amasyʉ mwalomwalo, bo muno bikʉbombela abandʉ aba bikwipuuta kʉ tʉndʉ ʉtʉ akaja jo Kyala, paapo abeene bikwinogona ʉkʉtɨ bikʉkaba ɨfi bikʉsʉʉma kʉnongwa jaa masyʉ gaabo amingi. ");
INSERT INTO nyy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mulɨngiipuutaga bo muno bikʉbombela abeene, paapo Taata Kyala asimeenye ɨsi mukʉlonda na bo mukaalɨ ʉkʉnsʉʉma. ");
INSERT INTO nyy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Po ʉmwe mwipuutege kwa Kyala bo ʉlʉ, ‘Taata gwɨtʉ ʉgwa kʉmwanya, ɨngamu jaako jɨɨmɨkigwege. ");
INSERT INTO nyy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ɄBʉnyafyale bwako bwisege. Ɨsi kʉlonda sibombigwege pakiisʉ apa, bo ʉlwa kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ʉtʉpege kʉkʉtɨ isikʉ ɨfindʉ fyɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ʉtʉswege ʉbʉtʉlanongwa bwɨtʉ, bo ʉlʉ nuuswe tukʉbaswa boosa aba bikʉtʉla ɨnongwa kʉmyɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ʉtwepʉsye mu ngelo, ʉtʉpoke kʉ mbiibi jʉla. ɄBʉnyafyale, amaka nʉ bʉsisya, fyako bwila na bwila! Ameni.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jesu alɨnkʉjoba kangɨ, alɨnkʉtɨ, “Lɨnga mukʉbaswa abiinɨɨnu ʉbʉtʉlanongwa bwabo, ʉGwiseemwe ʉgwa kʉmwanya ikʉbaswaga na nuumwe ʉbʉtʉlanongwa bwɨnu. ");
INSERT INTO nyy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Looli lɨnga mutikʉbaswa abiinɨɨnu ʉbʉtʉlanongwa bwabo, ʉGwiseemwe ʉgwa kʉmwanya atikʉbaswaga na nuumwe ʉbʉtʉlanongwa bwɨnu.” ");
INSERT INTO nyy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kangɨ lɨnga mukʉfipɨɨka ɨfindʉ, kʉlɨngiilʉkaga kʉmaaso kʉmyɨnu bo muno bikʉbombela abasyobi, paapo abeene bikʉkiinyeela kʉmaaso, ʉkʉtɨ abandʉ bamanye ʉkʉtɨ bafipɨɨkile ɨfindʉ. Nalooli nikʉbabʉʉla, bambɨliile kɨlɨngaani ɨfihombigwa fyabo. ");
INSERT INTO nyy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Looli ʉgwe bo ʉlɨ pakʉfipɨɨka ɨfindʉ, ʉpakalege amafuta kʉntʉ nʉ kʉsugusula kʉmaaso, ");
INSERT INTO nyy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ʉkʉtɨ abandʉ balɨngamanya ʉkʉtɨ ʉfipɨɨkile ɨfindʉ. Po Taata Kyala ʉjʉ atikʉboneka, jo gwa kʉmanya mwene. Jo ʉjʉ ikʉsibona ɨsi sikʉbombigwa mbʉtiitʉ, ikwisa kʉkʉhomba.” ");
INSERT INTO nyy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mulɨngiibɨɨkɨlaga ɨkyʉma pakiisʉ, apa amajenje nɨ ngami fikoonanga na bahɨɨji bikʉpangʉla nʉ kwiba. ");
INSERT INTO nyy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Looli mwibɨɨkɨlege ɨkyʉma kʉmwanya, kʉno amajenje nɨ ngami fitikoonanga na kʉno abahɨɨji batikʉpangʉla nʉ kwiba. ");
INSERT INTO nyy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kʉno kʉbɨɨka ɨkyʉma kyako, ko kʉno nɨ ndumbula jaako jikʉjaga. ");
INSERT INTO nyy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Amaaso gaako gafwene bo ʉlwa nyaale ɨjɨ jikʉgʉmulɨkɨla ʉmbɨlɨ gwako. Amaaso gaako lɨnga galɨ kanunu, po ʉmbɨlɨ gwako goosa gukʉja nʉ ndangalɨla. ");
INSERT INTO nyy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Looli lɨnga amaaso gaako gafwile, po ʉmbɨlɨ gwako goosa gukʉja mu ngiisi. Kʉnongwa ɨjo lɨnga ʉndangalɨla ʉgʉ gwalɨ nkatɨ mmyako gwipelile ngiisi, po ngiisi fiijo! ");
INSERT INTO nyy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Akajako ʉmundʉ ʉjʉ abagiile ʉkʉbabombela abatwa babɨlɨ. Bʉno ikʉmmbenga jʉmo nʉ kʉnngana ʉjʉngɨ, pamo ikʉmmwɨmɨkaga jʉmo nʉ kʉmmwila ʉjʉngɨ. Mukabagɨla ʉkʉmmbombela Kyala, kʉno mukʉkɨbombela ɨkyʉma!” ");
INSERT INTO nyy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Po nikʉbabʉʉla nikʉtɨ, mulɨngapaasyaga ɨsya bʉʉmi bwɨnu, ʉkʉtɨ mukʉlyaga ɨfiki, pamo mukʉnwaga ɨfiki, pamo mukʉfwalaga ɨfiki. Bʉle, ʉbʉʉmi bʉkaja bʉkʉlʉmba ʉkʉkɨnda ɨfindʉ, nʉ mbɨlɨ gʉkaja nkʉlʉmba ʉkʉkɨnda ɨmyenda? ");
INSERT INTO nyy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Amusikeete ɨnjʉni. Sitikʉbyala, sitikʉtondola nʉ kʉbɨɨka ɨfindʉ mu ndamba, leelo ʉGwiseemwe ʉgwa kʉmwanya, ikʉsiswɨla. Bʉle, ʉmwe mukaja bapala ʉkʉsikɨnda ɨnjʉni ɨsyo? ");
INSERT INTO nyy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Akajako najʉmo pakatɨ pamyɨnu ʉjʉ abagiile ʉkongelapo ʉbʉʉmi bwake nalɨnga isikʉ lɨmo, kʉ njɨla jaa kʉpaasya ɨsya bʉʉmi bwake. ");
INSERT INTO nyy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kʉnongwa jaa fiki mukʉpaasya ɨsya myenda ɨgya kʉfwala? Namukeete ʉbʉlenge ʉbwa ndiisʉ muno bukʉkʉlɨla. Bʉtikʉbomba ɨmbombo pamo ʉkwisonela ɨmyenda. ");
INSERT INTO nyy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Looli nikʉbabʉʉla nikʉtɨ, joope ʉmalafyale Solomoni mbʉsisya bwake boosa, akaafwelemo kanunu bo ʉbʉlenge ʉbo! ");
INSERT INTO nyy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Po lɨnga Kyala ikʉbʉfwɨka kanunu bo ʉlʉ ʉbʉlenge bwa ndiisʉ, ʉbʉ bʉlipo ʉmwisyʉgʉ, looli kɨlaabo bukʉsopigwa mmooto, bʉle atikʉkɨndapo ʉkʉbafwɨka, mwe baa lwitɨko ʉlʉnandɨ ʉmwe? ");
INSERT INTO nyy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Po mulɨngapaasyaga ʉkʉtɨ, ‘Ʉswe tukʉlyaga ɨfiki? Pamo tukʉnwaga ɨfiki? Pamo tukʉfwalaga ɨfiki?’ ");
INSERT INTO nyy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Paapo abandʉ aba bakammanya Kyala, bikwijʉʉla ʉkʉtʉlonda ʉtʉndʉ ʉto toosa, looli ʉGwiseemwe ʉgwa kʉmwanya ameenye ʉkʉtɨ ʉmwe mukʉlonda ʉto! ");
INSERT INTO nyy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ʉmwe mubʉlondege taasi ʉBʉnyafyale bwa Kyala nʉ kʉbomba ɨsi sikʉlondigwa nkyeni mmyake, po nɨ singi syosa ikʉbongelapo. ");
INSERT INTO nyy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Po mulɨngapaasyaga ɨsya kɨlaabo, paapo ɨsya kɨlaabo sikwibombela syene. Kʉkʉtɨ isikʉ lɨlɨ nʉ bʉtolwe bwake.” ");
INSERT INTO nyy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mulɨngalongaga, nuumwe mutikʉlongigwaga na Kyala, ");
INSERT INTO nyy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","paapo muno mukʉbalongela abangɨ, mo muno Kyala ikwisa kʉbalongelaga nuumwe. Ɨkɨpɨmo ɨkɨ mukʉbapɨmɨla abangɨ, kyo ɨkɨ Kyala ikwisa kʉbapɨmɨlaga nuumwe. ");
INSERT INTO nyy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Fiki kʉkeeta akapaatʉ aka kalɨ nkɨsige ɨkya nnino, looli ʉtikʉlɨbona iitapwa ɨlɨ lɨlɨ nkɨsige kyako? ");
INSERT INTO nyy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kangɨ ʉbagiile bʉleebʉle ʉkʉmmbʉʉla ʉnnino ʉkʉtɨ, ‘Isaga ngʉsoosyemo akapaatʉ aka kalɨ nkɨsige kyako,’ bo nkɨsige kyako lɨlimo itapwa? ");
INSERT INTO nyy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gwe nsyobi ʉgwe! Soosyamo taasi iitapwa ɨlɨ lɨlɨ nkɨsige kyako, po kʉkeetaga kanunu nʉ kʉsoosyamo akapaatʉ nkɨsige ɨkya nnino! ");
INSERT INTO nyy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mulɨngasipaga ɨmbwa ʉtʉndʉ ʉtwikemo ʉkʉtɨ silɨngabasanukɨla nʉ kʉbanyaafulania. Mulɨngasisopelaga ɨngʉlʉbe ʉtʉndʉ ʉtwa ntengo ʉkʉtɨ silɨngakanyanga.” ");
INSERT INTO nyy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Musʉʉmege, mukʉpeeligwaga; mulondege, mukʉfyagaga; mukungʼundege kʉ lwigi, mukwigʉlɨligwaga. ");
INSERT INTO nyy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Paapo kʉkʉtɨ mundʉ ʉjʉ ikʉsʉʉma, ikʉpeeligwa, ʉjʉ ikʉlonda, ikʉfyaga, joope ʉjʉ ikʉkungʼunda, ikwigʉlɨligwa. ");
INSERT INTO nyy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Kalɨ, jo jwani pakatɨ pamyɨnu, ʉjʉ ʉmwanaake ikʉsʉʉma ɨkɨsyesye ikʉmpapo ɨliibwe? ");
INSERT INTO nyy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pamo ikʉsʉʉma ɨɨswɨ, ikʉmpapo ɨnjoka? ");
INSERT INTO nyy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Po lɨnga ʉmwe, mwe babiibi mumeenye ʉkʉbapapo abaanɨɨnu ʉtʉndʉ ʉtʉnunu, bʉle, Taata ʉgwa kʉmwanya atikʉkɨndɨlɨla ʉkʉbapapo ɨfinunu aba bikʉnsʉʉma? ");
INSERT INTO nyy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Po syosa ɨsi mukʉlonda ʉkʉbombeligwa na bandʉ, nuumwe mubabombelege abangɨ. Paapo ɨndagɨlo sya Moose nɨ manyisyo sya bakunguluka, sikʉlɨngaania bo ʉlo.” ");
INSERT INTO nyy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mwingɨlege ʉkwendela pa kɨfigo ɨkɨfinye, paapo ɨkɨfigo kyeleefu ɨkya kwingɨlɨla ʉkʉbʉʉka mbʉpyutigwa, nɨ njɨla ɨjaa kʉbʉʉka ʉko nyeeleefu fiijo. Kangɨ abandʉ aba bikwenda mu njɨla ɨjo bingi. ");
INSERT INTO nyy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Looli ɨkɨfigo ɨkya kwingɨlɨla ʉkʉbʉʉka kʉ bʉʉmi kɨfinye, nɨ njɨla ɨjaa kʉbʉʉka ʉko finye, kangɨ abandʉ aba bikʉjaaga ɨnjɨla ɨjo banandɨ.” ");
INSERT INTO nyy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mujege maaso na bakunguluka abaa bʉtʉngʉlʉ, paapo bo bikwisa kʉmyɨnu, bikʉfwana ʉlwa ngʼoosi, looli mu ndumbula syabo mbwa sya ndiisʉ ɨngalɨ. ");
INSERT INTO nyy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mukʉbamanyaga abo mu seke syabo. Bʉle, abandʉ bikʉpaata ɨseke sya maafiilʉ pamo ɨsya nkʉjʉ mmipiki ɨgya miifwa? ");
INSERT INTO nyy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bʉbʉʉbo ʉmpiki ʉnnunu gukʉpa ɨseke ɨnunu, looli ʉmpiki ʉmbiibi gukʉpa ɨseke ɨmbiibi. ");
INSERT INTO nyy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ʉmpiki ʉnnunu gʉkabagɨla ʉkʉpa ɨseke ɨmbiibi, kangɨ ʉmpiki ʉmbiibi gʉkabagɨla ʉkʉpa ɨseke ɨnunu. ");
INSERT INTO nyy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kʉkʉtɨ mpiki ʉgʉ gʉtikʉpa ɨseke ɨnunu, gukʉtumuligwaga nʉ kʉsopigwa mmooto. ");
INSERT INTO nyy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Po leelo abakunguluka abaa bʉtʉngʉlʉ aamukʉbamanyaga mu seke syabo.” ");
INSERT INTO nyy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Mungatɨgɨ boosa aba bikʉtɨ, ‘Gwe Ntwa, gwe Ntwa,’ Kyala ikwisa kʉbambɨlɨla mBʉnyafyale bwake. Looli ʉmundʉ ʉjʉ ikʉbomba ɨsi ikʉlonda Taata ʉgwa kʉmwanya, ʉjo jo ʉjʉ ikwisa kʉmmwambɨlɨla. ");
INSERT INTO nyy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pi isikʉ lya bʉlongi bo lɨfikile, abandʉ bingi bikwisa kʉʉndaalʉʉsyaga ʉkʉtɨ, ‘Gwe Ntwa, gwe Ntwa! Bʉle, mu ngamu jaako tʉkaakungulukaga, tʉkaasikagaga ɨmbepo ɨnyali nʉ kʉbomba ɨfiika fingi?’ ");
INSERT INTO nyy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Po ngwisa kʉbabʉʉlaga pabwelu ʉkʉtɨ, ‘Ngabamanya ʉmwe! Sookapo apa, mwe babomba mbiibi ʉmwe!’” ");
INSERT INTO nyy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Po kʉkʉtɨ mundʉ ʉjʉ asipɨliike ɨmanyisyo syangʉ ɨsi nʉ kʉsikonga, afwene bo ʉlwa mundʉ ʉgwa mahala ʉjʉ aajengile ɨnyumba jaake pa lwalabwe. ");
INSERT INTO nyy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ɨfula bo jɨtimile, ʉmweleesyo gʉlɨnkwisa, ʉmbelo ʉnkalɨ gʉlɨnkʉkula nʉ kʉjɨguta ɨnyumba jɨla, looli poope ɨnyumba jɨla jɨkaagwile paasi, paapo ʉlwalo lwake lwajengiigwe pa lwalabwe. ");
INSERT INTO nyy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Looli kʉkʉtɨ mundʉ ʉjʉ asipɨliike ɨmanyisyo syangʉ kɨsita kʉsibombela, ʉjo afwene bo ʉlwa mundʉ ʉnkonyofu, ʉjʉ aajengile ɨnyumba jaake pa nsanga. ");
INSERT INTO nyy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ɨfula bo jɨtimile, ʉmweleesyo gʉlɨnkwisa, ʉmbelo ʉnkalɨ gʉlɨnkʉkula nʉ kʉjɨguta ɨnyumba jɨla, nakalɨnga jɨlɨnkʉgwa nʉ kʉpangʉka joosa.” ");
INSERT INTO nyy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesu bo amalile ʉkʉjoba amasyʉ ago, ɨfilʉndɨlo ɨfya bandʉ bala baaswigile fiijo ɨmanyisyo syake. ");
INSERT INTO nyy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Paapo akaamanyiisye bo muno baamanyikɨsyaga abamanyisi baa ndagɨlo sya Moose, looli bo ʉmundʉ ʉndagɨli. ");
INSERT INTO nyy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesu bo asulwike ʉkʉfuma pa kyamba kɨla, ɨfilʉndɨlo ɨfinywamu ɨfya bandʉ filɨnkʉnkonga. ");
INSERT INTO nyy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Po alɨnkwisa ʉmundʉ jʉmo ʉnkoma, alɨnkʉfugama nkyeni mwa Jesu, alɨnkʉtɨ, “Gwe Ntwa, lɨnga gwiganile ʉkʉmbalamaasya, ʉbagiile ʉkʉʉnyeelʉsya.” ");
INSERT INTO nyy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesu alɨnkʉgolosya ɨkɨboko kyake, alɨnkʉmpalamaasya, alɨnkʉtɨ, “Niiganile, elʉkaga!” Nakalɨnga ʉmundʉ jʉla alɨnkʉbʉmbʉlʉka. ");
INSERT INTO nyy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesu alɨnkʉmmbʉʉla ʉmundʉ jʉla alɨnkʉtɨ, “Ʉlɨngammbʉʉlaga ʉmundʉ najʉmo ɨnongwa ɨsi! Looli ʉbʉʉke ʉkiinangɨsye kʉ mpuuti. Kangɨ ʉtwale iikemo kʉ tempeli, ʉkʉnangɨsya ʉkʉtɨ ʉbʉmbʉlwike, bo muno sikʉlagɨla ɨndagɨlo sya Moose.” ");
INSERT INTO nyy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesu bo ingiile nkaaja akaa mu Kapelinaʉmu, ʉndongosi jʉmo ʉgwa basikali baa Balooma alɨnkwisa kʉkʉsʉʉma ʉbʉtʉʉli kwa Jesu, ");
INSERT INTO nyy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","alɨnkʉtɨ, “Gwe Ntwa, ʉmbombi gwangʉ alalile, ikʉtaamigwa fiijo.” ");
INSERT INTO nyy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Nikwisa kʉkʉmmbʉmbʉlʉsya.” ");
INSERT INTO nyy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Looli ʉndongosi jʉla alɨnkʉmmbʉʉla alɨnkʉtɨ, “Hɨmma, gwe Ntwa! Ʉne ngabagɨsya ʉkʉtɨ ʉgwe gwingɨle nnyumba jangʉ. Looli ʉjobe lyene iisyʉ, ʉmbombi gwangʉ ikʉbʉmbʉlʉka. ");
INSERT INTO nyy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Paapo na niine ndɨ gwa paasi, ngʉlagɨligwa, kangɨ ndɨ nabo abasikali aba balɨ paasi pamyangʉ. Lɨnga nʉmmbʉʉlile jʉmo ndile, ‘Bʉʉka!’ ikʉbʉʉka. Kʉ jʉngɨ lɨnga ndile, ‘Isaga!’ ikwisa. Na kʉ ntʉmwa gwangʉ lɨnga ndile, ‘Bomba ɨsi!’ ikʉbomba.” ");
INSERT INTO nyy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesu bo apɨliike amasyʉ ago, aaswigile fiijo, alɨnkʉbabʉʉla abandʉ aba bankongaga, alɨnkʉtɨ, “Nalooli nikʉbabʉʉla nikʉtɨ, mBanyaisilaɨli boosa, ngammbonamo sikʉ ʉmundʉ ʉjʉ alɨ nʉ lwitɨko ʉlʉnywamu bo ʉlʉ! ");
INSERT INTO nyy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nikʉbabʉʉla nikʉtɨ, abandʉ bingi aabikwisa ʉkʉfuma kʉfibafu fyosa ɨfya kiisʉ. Bikwisa kʉlya pamopeene na biisʉkʉlʉ bɨɨtʉ baa Abulahamu, Isaka na Jaakobo mBʉnyafyale bwa kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Looli aBanyaisilaɨli bingi aba bapaapiigwe ʉkʉja baa Bʉnyafyale ʉbo, abo bikwisa kʉtaagigwa panja mu ngiisi, ʉko bikwisa kʉlɨlaga nʉ kʉsyegetula amiino kʉnongwa jaa ndaamyo.” ");
INSERT INTO nyy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Po Jesu alɨnkʉmmbʉʉla ʉndongosi jʉla alɨnkʉtɨ, “Bʉʉkaga! Sikʉjaga bo muno lʉjɨɨliile ʉlwitɨko lwako.” Nakalɨnga, ʉmbombi gwake jʉla alɨnkʉbʉmbʉlʉka kʉkabalɨlo kalakala. ");
INSERT INTO nyy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Po Jesu alɨnkwingɨla nnyumba jaa Peeteli, alɨnkʉmmwaga ʉnna gwa nkasi gwa Peeteli, aalambaleele pa kɨtala, aalɨ nɨ sekema. ");
INSERT INTO nyy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Po Jesu alɨnkʉmpalamaasya ɨkɨboko, nakalɨnga ɨsekema jɨla jɨlɨnkʉsookamo. Ʉnkiikʉlʉ jʉla alɨnkwɨma, alɨnkwanda ʉkʉmmbombela Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Namajolo, balɨnkʉntwalɨla Jesu abandʉ bingi aba baakoliigwe nɨ mbepo ɨnyali, Jesu alɨnkʉsikaga kwi isyʉ lyake. Kangɨ alɨnkʉbabʉmbʉlʉsya boosa aba baalɨ babine. ");
INSERT INTO nyy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Syabombiigwe ɨsi ʉkʉtɨ iisyʉ lɨla lɨboneke, ɨlɨ lyajobiigwe nʉ nkunguluka Jeesaja ʉkʉtɨ, “Ʉmwene eegile ʉboonywa bwɨtʉ, abʉpɨmbile ʉbʉbine bwɨtʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesu bo aagile ɨkɨlʉndɨlo ɨkya bandʉ abingi bansyʉngʉʉtiile, alɨnkʉbalagɨla abafundigwa baake ʉkʉtɨ, baloboke sʉmbɨ, babʉʉke kwi isɨɨlya. ");
INSERT INTO nyy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ʉmmanyisi jʉmo ʉgwa ndagɨlo sya Moose alɨnkʉsegelela kwa Jesu, alɨnkʉtɨ, “Gwe Mmanyisi, ʉne nikʉkʉkongaga koosa kʉno kʉbʉʉka ʉkʉtɨ nje mfundigwa gwako!” ");
INSERT INTO nyy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉtʉmbwe tʉlɨ nɨ mbako nɨ njʉni silɨ nɨ fifufumbwa, looli ʉne Nnyamundʉ ngaja nʉ bʉjo ʉbwa kʉlambalala!” ");
INSERT INTO nyy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Po ʉmfundigwa ʉjʉngɨ alɨnkʉmmbʉʉla Jesu, alɨnkʉtɨ, “Gwe Ntwa, leka taasi mbʉʉke ngansyɨle taata.” ");
INSERT INTO nyy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉgwe ʉngongege! Baleke abafwe babasyɨlege abafwe baabo.” ");
INSERT INTO nyy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Po Jesu alɨnkwipakɨla mwi ibooti, abafundigwa baake balɨnkʉnkonga. ");
INSERT INTO nyy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Po bo balɨ mwa sʉmbɨ, nakalɨnga gʉlɨnkwisa ʉmbelo ʉgwa mpetapeta, amajɨga galɨnkwanda ʉkʉliibɨsya iibooti. Looli Jesu aagonile ʉtʉlo. ");
INSERT INTO nyy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Po abafundigwa baake balɨnkʉbʉʉka kwa Jesu, balɨnkʉnndembʉsya, balɨnkʉjwega balɨnkʉtɨ, “Gwe Ntwa! Tʉpoke, tukʉfwa!” ");
INSERT INTO nyy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Fiki mukʉtiila ʉmwe mwe baa lwitɨko ʉlʉnandɨ?” Po alɨnkwɨma, alɨnkʉgʉkemela ʉmbelo na sʉmbɨ jʉla, kʉlɨnkʉja mye jonjolo. ");
INSERT INTO nyy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Abafundigwa baake balɨnkʉnyomoka fiijo, balɨnkʉtɨ, “Mundʉ nki ʉjʉ, ʉmbelo na sʉmbɨ fyope fikʉntiila?” ");
INSERT INTO nyy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesu bo alobwike sʉmbɨ, aafikile nkiisʉ kya Bagatala. Po balɨnkwaganila nagwe abandʉ babɨlɨ aba baalɨ nɨ mbepo ɨnyali, aba baafumile kʉ mapʉmba. Abandʉ bala baalɨ bakalɨ fiijo, akaaliko ʉmundʉ ʉjʉ aagelaga ʉkwenda kʉno baliko. ");
INSERT INTO nyy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Po ɨmbepo ɨnyali silɨnkʉjwega fiijo silɨnkʉtɨ, “Gwe Mwana gwa Kyala, tʉlɨ bʉki ʉgwe na nuuswe? Bʉle, gwisile kʉkʉtʉfunda bo akabalɨlo akaa kʉpyutigwa kakaalɨ ʉkʉfika?” ");
INSERT INTO nyy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pabʉtalipo, gwatiimigwaga ʉntiimo ʉnnywamu ʉgwa ngʉlʉbe. ");
INSERT INTO nyy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Po ɨmbepo ɨnyali sila silɨnkʉmpyelesya Jesu silɨnkʉtɨ, “Lɨnga kʉtʉkaga, ʉtʉtʉme mu ntiimo gʉla ʉgwa ngʉlʉbe.” ");
INSERT INTO nyy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesu alɨnkʉsikemela alɨnkʉtɨ, “Namubʉʉkege!” Po ɨmbepo ɨnyali silɨnkʉsookamo mmbandʉ bala, silɨnkwakwingɨla mu ngʉlʉbe. Silɨnkʉsibopesya ɨngʉlʉbe syosa ʉkʉsuluka ndʉpanga, mpaka mwa sʉmbɨ, silɨnkʉmilwa. ");
INSERT INTO nyy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Abatiimi baa ngʉlʉbe balɨnkʉbopa ʉlʉbɨlo, balɨnkʉbʉʉka nkaaja. Balɨnkwakʉbalɨngaania abandʉ syosa ɨsi sibombiigwe kʉ bandʉ bala aba baalɨ nɨ mbepo ɨnyali. ");
INSERT INTO nyy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Abandʉ boosa abaa nkaaja, balɨnkʉbʉʉka kʉkwaganila na Jesu. Po bo bammbwene, balɨnkʉmpyelesya ʉkʉtɨ asookemo nkiisʉ kyabo. ");
INSERT INTO nyy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesu alɨnkwipakɨla mwi ibooti, alɨnkʉloboka mwa sʉmbɨ Galilai, alɨnkʉfika nkaaja kaake akaa mu Kapelinaʉmu. ");
INSERT INTO nyy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Po abandʉ bamo balɨnkʉntwala kwa Jesu ʉmundʉ ʉjʉ aalalile, aalambaleele pa bʉlɨlɨ. Jesu bo alʉbwene ʉlwitɨko lwabo, alɨnkʉmmbʉʉla ʉmundʉ jʉla alɨnkʉtɨ, “Mwanangʉ gwikasye! Ʉhobokeliigwe ʉbʉtʉlanongwa bwako.” ");
INSERT INTO nyy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Po abamanyisi bamo abaa ndagɨlo sya Moose, aba baalipo pala, balɨnkwinogona mu ndumbula syabo, balɨnkʉtɨ, “Ʉmundʉ ʉjʉ ikʉntʉka Kyala!” ");
INSERT INTO nyy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Looli Jesu alɨnkʉsimanya syosa ɨsi biinogonaga, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Fiki mukwinogona ɨmbiibi mu ndumbula syɨnu? ");
INSERT INTO nyy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Lɨlɨkʉ ipepe, ʉkʉmmbʉʉla ʉkʉtɨ, ‘Ʉhobokeliigwe ʉbʉtʉlanongwa bwako,’ pamo ʉkʉtɨ, ‘Sumuka, gwendege’? ");
INSERT INTO nyy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Po musyaganiege ʉkʉtɨ ʉne ne Nnyamundʉ ndɨ na maka agaa kʉhobokela ʉbʉtʉlanongwa nkiisʉ muno...” Alɨnkʉmmbʉʉla ʉjʉ aalalile alɨnkʉtɨ, “Sumuka, pɨmba ʉbʉlɨlɨ bwako, bʉʉkaga kʉkaaja kaako.” ");
INSERT INTO nyy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Po ʉmundʉ jʉla alɨnkʉsumuka, alɨnkʉbʉʉka kʉkaaja. ");
INSERT INTO nyy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Abandʉ abaa nkɨlʉndɨlo kɨla bo basibwene ɨsyo, balɨnkʉja nʉ lʉtende. Balɨnkʉntuufya Kyala ʉjʉ abapeele abandʉ amaka bo ago. ");
INSERT INTO nyy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesu bo asookilepo pala, alɨnkwaganila nʉ nsongesya songo jʉmo, ɨngamu jaake Matai, aatʉʉgeesye apa bikʉsongesya ɨsongo. Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉngongege.” Nakalɨnga Matai alɨnkʉsumuka, alɨnkʉnkonga Jesu ʉkʉfuma akabalɨlo kala. ");
INSERT INTO nyy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesu na bafundigwa baake baabʉʉkile kʉkʉlya ɨfindʉ kwa Matai. Abasongesya songo bingi na batʉlanongwa balɨnkwisa, balɨnkʉtʉʉgala pakʉlya ɨfindʉ pamopeene nabo. ");
INSERT INTO nyy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ABafalisai bo basibwene ɨsyo, balɨnkʉbalaalʉʉsya abafundigwa baake, balɨnkʉtɨ, “Fiki ʉmmanyisi gwɨnu ikʉlya pamopeene na basongesya songo na batʉlanongwa?” ");
INSERT INTO nyy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Looli Jesu bo apɨliike ɨsyo, alɨnkʉbabʉʉla alɨnkʉtɨ, “Abakafu batikʉnndonda ʉnganga, looli beene ababine! ");
INSERT INTO nyy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mubʉʉke mukamanyile amasyʉ aga, ‘Ngʉlonda ɨkɨbabɨɨlɨsi, lyomma iikemo.’ Ngiisa kʉkʉbakoolela abagolofu, looli abatʉlanongwa.” ");
INSERT INTO nyy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Po abafundigwa baa Johani ʉMoosi balɨnkʉbʉʉka kwa Jesu, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Ʉswe na Bafalisai tukʉfipɨɨka ɨfindʉ, looli abafundigwa baako batikʉfipɨɨka, fiki?” ");
INSERT INTO nyy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Aba ʉmwega nkiikʉlʉ abapaalile kʉ bwegi, babagiile bʉleebʉle ʉkʉsulumania bo balɨ pamopeene nagwe? Looli amasikʉ aga gikwisa, abandʉ bikwisa kʉnsoosyapo ʉmwega nkiikʉlʉ pakatɨ pa baheesya baake. Po bikwisa kʉfipɨɨkaga ɨfindʉ. ");
INSERT INTO nyy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Akajako ʉmundʉ ʉjʉ ikʉsonelapo ɨkɨgamba ɨkya mwenda ʉgʉ gukʉkwinya, pa mwenda ʉnkʉʉlʉ. Lɨnga abombile bo ʉlo ɨkɨgamba ɨkyo kɨtikwikolela, paapo kɨsoniigwe pa mwenda ʉnkʉʉlʉ, na apa panyaafwike pikongelela. ");
INSERT INTO nyy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kangɨ akajapo ʉmundʉ ʉjʉ ikʉkʉʉsya ɨfinga ɨmbya mfinyambɨ ɨfikʉʉlʉ. Paapo lɨnga abombile bo ʉlo, ɨfinyambɨ fikʉnyaafuka, ɨfinga jikooneka, nɨ finyambɨ fikoonangɨka. Looli abandʉ bikʉbɨɨka ɨfinga ɨmbya mfinyambɨ ɨfipya. Po fyofibɨɨlɨ ɨkɨnyambɨ ɨkɨpya nɨ finga ɨmbya fikʉja kanunu!” ");
INSERT INTO nyy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesu bo alɨ pakʉbabʉʉla ɨsyo, nakalɨnga alɨnkwisa kʉmyake ʉndongosi jʉmo, alɨnkʉfugama nkyeni mmyake, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉmwanangʉ ʉndɨndwana afwile lʉlʉʉlʉ, leelo gwise, ʉkammbɨɨkepo ɨkɨboko kyako pamwanya pamyake, ʉkʉtɨ asyʉke.” ");
INSERT INTO nyy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Po Jesu alɨnkʉsookapo pamopeene na bafundigwa baake, alɨnkʉnkonga ʉndongosi jʉla. ");
INSERT INTO nyy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kangɨ aalipo ʉnkiikʉlʉ jʉmo ʉjʉ aataamigwaga nʉ bʉbine bwa kooneka iilopa ɨfyɨnja kalongo na fibɨlɨ. Alɨnkʉbʉʉka kʉnyuma kwa Jesu, alɨnkʉpalamaasya ɨkɨpeto kya mwenda gwa Jesu, ");
INSERT INTO nyy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","aaliinogwine mu ndumbula jaake, aatile, “Lɨnga mbalamaasiisye gwene ʉmwenda gwake, ngʉpona.” ");
INSERT INTO nyy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ʉnkiikʉlʉ jʉla bo apalamaasiisye, nakalɨnga Jesu alɨnkʉsanuka, alɨnkʉmmbona, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Mwanangʉ, gwikasye! Ʉbʉmbʉlwike ʉbʉbine kʉnongwa jaa lwitɨko lwako.” Nakalɨnga ʉnkiikʉlʉ jʉla alɨnkʉbʉmbʉlʉka. ");
INSERT INTO nyy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesu bo afikile nnyumba jaa ndongosi jʉla, alɨnkʉbaaga abandʉ bingi babʉngeene, balɨ pakʉlɨla ɨɨfwa, bamo baakʉbaga amalonge. ");
INSERT INTO nyy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Musookepo apa! Ʉndɨndwana ʉjʉ akafwa, looli agonile twene ʉtʉlo!” Abandʉ bala balɨnkʉnseka Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Po alɨnkʉbasoosya panja, alɨnkwingɨla kʉ kyumba, alɨnkʉnkola ɨkɨboko, ʉndɨndwana jʉla alɨnkwɨma. ");
INSERT INTO nyy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ɨnongwa ɨsi silɨnkʉfumuka nkiisʉ kɨla kyosa. ");
INSERT INTO nyy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesu bo asookilepo pala, abafwa maaso babɨlɨ balɨnkʉnkonga, balɨnkʉlaata ʉkʉkoolela balɨnkʉtɨ, “Gwe Mwana gwa malafyale Ndaabɨti, ʉlɨɨtʉpaakɨsya!” ");
INSERT INTO nyy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Po Jesu bo ingiile nnyumba, abafwa maaso bala balɨnkʉnkonga, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Bʉle, mukwitɨka ʉkʉtɨ mbagiile ʉkʉbabʉmbʉlʉsya?” Balɨnkʉmmwamula balɨnkʉtɨ, “Nalooli, Ntwa! Tukwitɨka.” ");
INSERT INTO nyy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Po Jesu alɨnkʉbapalamaasya amaaso gaabo, alɨnkʉbabʉʉla alɨnkʉtɨ, “Sijege bo muno lʉjɨɨliile ʉlwitɨko lwɨnu.” ");
INSERT INTO nyy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nakalɨnga amaaso gaabo galɨnkwigʉka. Jesu alɨnkʉbasoka alɨnkʉtɨ, “Mulɨngammbʉʉlaga ʉmundʉ ɨnongwa ɨsi!” ");
INSERT INTO nyy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Looli abeene bo basookilepo pala, balɨnkʉsifumusya ɨnongwa sya Jesu nkiisʉ kɨla kyosa. ");
INSERT INTO nyy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Abandʉ bala bo basookilepo pala, bamo balɨnkʉntwala kwa Jesu ʉmundʉ ʉjʉ atikʉjoba, paapo aalɨ nɨ mbepo ɨnyali. ");
INSERT INTO nyy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesu alɨnkʉjɨkaga ɨmbepo ɨnyali jɨla, nakalɨnga ʉmundʉ jʉla alɨnkwanda ʉkʉjoba kangɨ. Ɨkɨlʉndɨlo ɨkya bandʉ balɨnkʉswiga, balɨnkʉtɨ, “Tʉkasibonamo sikʉ bo ɨsi mu Isilaɨli!” ");
INSERT INTO nyy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Looli aBafalisai balɨnkʉtɨ, “Ikʉsikaga ɨmbepo ɨnyali kʉ maka agaa nkʉlʉmba gwa mbepo ɨnyali!” ");
INSERT INTO nyy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesu aasyʉngʉʉtɨlaga ntwaja toosa ʉtʉnywamu nʉ tʉnandɨ. Poosa apa endaga, ingɨlaga mu sinagogi, aabamanyisyaga abandʉ, aalʉmbɨlɨlaga ɨNdʉmi ɨNunu ʉkʉtɨ ʉBʉnyafyale bwa kʉmwanya bʉsegeliile nkiisʉ, nʉ kʉbabʉmbʉlʉsya ʉbʉbine boosa nʉ boonywa ʉbwa lʉko nʉ lʉko. ");
INSERT INTO nyy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Po bo akɨbwene ɨkɨlʉndɨlo ɨkya bandʉ, ɨkɨsa kɨlɨnkʉmmwaga, paapo baataamigwaga bakaalɨ nʉ gwa kʉbatʉʉla, baalɨ bo ʉlwa ngʼoosi ɨsi sikaja nʉ ntiimi. ");
INSERT INTO nyy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Po alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Ʉntondolo mwingi, looli abatondoli banandɨ. ");
INSERT INTO nyy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Po munsʉʉmege ʉNtwa ʉgwa ngʉnda, abatʉme abatondoli mu ngʉnda gwake.” ");
INSERT INTO nyy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesu aababɨlɨkiile abafundigwa baake kalongo na babɨlɨ, alɨnkʉbapapo amaka agaa kʉsikaga ɨmbepo ɨnyali, ʉkʉbʉmbʉlʉsya ʉbʉbine ʉbwa lʉko loosa nʉ boonywa ʉbwa lʉko loosa. ");
INSERT INTO nyy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Po ɨngamu sya batʉmigwa abo kalongo na babɨlɨ syo ɨsi: Ʉgwa kwanda jo Simoni (ʉjʉ ɨngamu ɨjɨngɨ bantɨgɨ Peeteli) nʉ gwamyabo Andeleja, Jaakobo ʉmwana gwa Sebetai nʉ nnuguna Johani, ");
INSERT INTO nyy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo, Balitolomai, Tomasi, Matai ʉnsongesya songo, Jaakobo ʉmwana gwa Alifai, Tatai, ");
INSERT INTO nyy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni ʉndwɨla kiisʉ kyake, na Juuta Isikalyoti, ʉjʉ kʉmmalɨɨkɨsyo aalɨnndɨɨliile Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesu alɨnkʉbatʉma kalongo na babɨlɨ abo, alɨnkʉbalagɨla alɨnkʉtɨ, “Mulɨngabʉʉkaga kʉ bandʉ aba bakaja Bajuuta, pamo ʉkwingɨla nkaaja kokoosa akaa Basamalija. ");
INSERT INTO nyy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Looli mubʉʉkege kʉ Bajuuta aba basobile bo ʉlwa ngʼoosi. ");
INSERT INTO nyy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kangɨ bo mukwenda mula mukabalʉmbɨlɨlege abandʉ mukatɨgɨ, ‘ɄBʉnyafyale bwa kʉmwanya bʉsegeliile nkiisʉ.’ ");
INSERT INTO nyy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mubʉmbʉlʉsyege ababine, musyʉsyege abafwe, mubeelʉsyege abakoma, nʉ kʉsikaga ɨmbepo ɨnyali. Kyala abapeele itolo, na nuumwe mupege kɨsita kʉhombigwa. ");
INSERT INTO nyy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mu njɨla jɨɨnu mulɨngendaga nɨ ndalama mu nyambɨ syɨnu. ");
INSERT INTO nyy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mulɨngajaga nɨ kɨnyambɨ, pamo ʉmwenda gwa kwandʉla, pamo ɨfilato, pamo ɨngili jaa kwendela. Namanga ʉmbombeli ikʉlondigwa ʉkʉpeeligwa ɨfi afumbilwe na bandʉ aba ikʉbabombela. ");
INSERT INTO nyy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Akaaja koosa aka mukwakwingɨlaga kaje kakʉlʉmba pamo akanandɨ, mukanndondege ʉmundʉ ʉjʉ abagiisye ʉkʉbambɨlɨla ʉmwe. Po mukatʉʉgalege mulamula kɨsita kʉsaama, mpaka bo mukʉsookamo nkaaja ako. ");
INSERT INTO nyy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bo mukwingɨla nnyumba, mubaponiege abenekaaja. ");
INSERT INTO nyy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Po lɨnga balimo abandʉ aba babagiisye, ʉkʉponia kwɨnu aakukʉbapa ʉlʉtengaano. Looli lɨnga bakajamo aba babagiisye, ʉkʉponia kwɨnu aakʉtikʉbapa ʉlʉtengaano. ");
INSERT INTO nyy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Lɨnga poosa apa batikʉbambɨlɨla ʉmwe nʉ kʉsita kʉbapɨlɨkɨsya, mukasookengepo nʉ kʉkungʼunda ɨfumbɨ ɨjɨ jɨlɨ mmalʉndɨ gɨɨnu. ");
INSERT INTO nyy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nalooli nikʉbabʉʉla nikʉtɨ, pi isikʉ lya bʉlongi abandʉ abaa nkaaja ako, bikwisa kʉkaba ʉlʉfundo ʉlʉnywamu, ʉkʉkɨnda ʉlwa bandʉ baa mu Sotoma na mu Gomola! ");
INSERT INTO nyy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mwikeetege, ngʉbatʉma ngatɨ ngʼoosi pakatɨ pa mbwa ɨsya ndiisʉ. Po mujege na mahala ngatɨ njoka, kangɨ mujege booloolo ngatɨ ngʉnde. ");
INSERT INTO nyy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mujege maaso, paapo abandʉ bikwisa kʉbatwalaga pabʉlongi, nʉ kʉbakoma nɨ fingoti mu sinagogi syabo. ");
INSERT INTO nyy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bikwisa kʉbatwalaga ʉmwe nkyeni mbalongosi baa kiisʉ na mbanyafyale, paapo mulɨ bafundigwa bangʉ. Kʉ njɨla ɨjo mukwisa kʉʉfumusyaga kʉ bandʉ aba bakaja Bajuuta na banyafyale baabo. ");
INSERT INTO nyy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Looli bo bikʉbatwala pabʉlongi, mulɨngiipaakɨsyaga ɨsya kʉjoba, paapo Kyala ikʉbapaga ɨsya kʉjoba akabalɨlo kalakala. ");
INSERT INTO nyy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Paapo ɨsi mukʉjobaga sikaja syɨnu, looli sikʉfuma kwa Mbepo Mwikemo ʉgwa Gwiseemwe. ");
INSERT INTO nyy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Po leelo kangɨ ʉmundʉ ikwisa kʉmmoohelaga ʉgwamyabo ʉkʉtɨ agogigwe, joope ʉgwise ikwisa kʉmmoohelaga ʉmwanaake ʉkʉtɨ agogigwe. Boope na baana bikwisa kʉbasambʉkɨlaga abapaapi baabo nʉ kʉbagoga. ");
INSERT INTO nyy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Abandʉ boosa bikwisa kʉbabengaga ʉmwe, paapo mulɨ bafundigwa bangʉ. Looli ʉjʉ ikʉʉmɨɨlɨla mpaka kʉmmalɨɨkɨsyo, jo ikwisa kʉpokigwa. ");
INSERT INTO nyy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bo bikʉbakaga nkaaja kamo, po mukabopelege nkaaja akangɨ. Nalooli nikʉbabʉʉla nikʉtɨ, mutikwisa kʉmala ʉkwenda ntwaja toosa ʉtwa Isilaɨli bo ʉne Nnyamundʉ ngaalɨ ʉkwisa. ");
INSERT INTO nyy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ʉmfundigwa atikʉnkɨnda ʉmmanyisi gwake, pamo ʉntʉmwa atikʉnkɨnda ʉntwa gwake. ");
INSERT INTO nyy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ʉmfundigwa ikʉja bo ʉmmanyisi gwake, nʉ ntʉmwa ikʉja bo ʉntwa gwake. Lɨnga bikʉtɨ ʉmwene nyumba jo Belisebuli, bʉle, batikʉkɨndɨlɨla ʉkʉbajoba ɨngamu ɨmbiibi abaa nnyumba mmyake?” ");
INSERT INTO nyy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Po mulɨngabatiilaga abandʉ abo. Syosa ɨsi sifisiigwe sikwisa kʉbɨɨkigwa pabwelu, na ɨsi silɨ mbʉtiitʉ sikwisa kʉmanyigwa. ");
INSERT INTO nyy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Syosa ɨsi nikʉbabʉʉla ʉmwe mu ngiisi, musijobege pabwelu. Ɨsi mukʉsipɨlɨka mbʉtiitʉ, musifumusyege nkyeni mmbandʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mulɨngatiilaga abandʉ aba bikʉgʉgoga ʉmbɨlɨ, looli bakabagɨla ʉkʉjɨgoga ɨmbepo. Looli muntiilege Kyala mwene ʉjʉ abagiile ʉkʉgʉpyuta ʉmbɨlɨ nɨ mbepo ndʉpanga lwa mooto. ");
INSERT INTO nyy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bʉle, baatʉndʉlʉ babɨlɨ batikʉʉlɨsigwa kʉ senti jɨmo? Poope tʉndʉlʉ najʉmo atikʉfwa kɨsita bwigane bwa Gwiseemwe. ");
INSERT INTO nyy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Syope nɨ nywili syosa ɨsya mmitʉ gyɨnu asibalile. ");
INSERT INTO nyy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Bʉle, ʉmwe kwa Kyala, mukaja bapala ʉkʉbakɨnda baatʉndʉlʉ? Po mulɨngatiilaga! ");
INSERT INTO nyy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Po ʉmundʉ gwesa ʉjʉ ikʉjoba nkyeni mmbandʉ ʉkʉtɨ aanyiitiike ʉne, na niine ngwisa kʉmmwitɨkɨla nkyeni mwa Taata ʉgwa kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Looli ʉmundʉ gwesa ʉjʉ ikʉngaana nkyeni mmbandʉ, na niine nikwisa kʉnkaana nkyeni mwa Taata gwangʉ ʉgwa kʉmwanya.” ");
INSERT INTO nyy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mulɨngiinogonaga ʉkʉtɨ ndwele ʉlʉtengaano pakiisʉ. Mma! Ngatwala ʉlʉtengaano, looli ndwele ʉlʉʉbo! ");
INSERT INTO nyy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Niisile kʉkʉbasofania ʉmwana ʉndʉmyana nʉ gwise, ʉmwana ʉndɨndwana nʉ nna, ʉmundʉ nʉ nko. ");
INSERT INTO nyy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kangɨ abalʉgʉ baa mundʉ bikʉjaga baa nnyumba jaake. ");
INSERT INTO nyy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Gwesa ʉjʉ annganile ʉgwise pamo ʉnna ʉkʉkɨnda ʉkʉʉngana ʉne, akabagɨsya ʉkʉja mfundigwa gwangʉ. Kangɨ ʉjʉ annganile ʉmwanaake ʉndʉmyana pamo ʉndɨndwana ʉkʉkɨnda ʉne, ʉjo joope akabagɨsya ʉkʉja mfundigwa gwangʉ. ");
INSERT INTO nyy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Gwesa ʉjʉ atikʉngonga nʉ kʉtaamigwa, nalɨnga ko kʉfwa pa kɨkohekano, akabagɨsya ʉkʉja mfundigwa gwangʉ. ");
INSERT INTO nyy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Gwesa ʉjʉ ikʉlonda ʉkʉbʉponesya ʉbʉʉmi bwake, ikʉbʉpeesyaga ʉbʉʉmi bwa bwila na bwila. Looli ʉmundʉ ʉjʉ atikʉpaasya ʉkʉfwa kʉnongwa jangʉ, jo ikʉbʉkabaga ʉbʉʉmi bwa bwila na bwila.” ");
INSERT INTO nyy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ʉmundʉ ʉjʉ ikʉbambɨlɨla ʉmwe, ikʉʉnyambɨlɨla ʉne. Na ʉjʉ ikʉʉnyambɨlɨla ʉne, ikʉmmwambɨlɨla ʉjʉ andʉmile. ");
INSERT INTO nyy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ʉjʉ ikʉmmwambɨlɨla ʉnkunguluka paapo nkunguluka, Kyala ikwisa kʉnhomba ɨfihombigwa bo ɨfya nkunguluka. Kangɨ gwesa ʉjʉ ikʉmmwambɨlɨla ʉmundʉ ʉngolofu paapo mundʉ ngolofu, Kyala ikwisa kʉnhomba ɨfihombigwa bo ɨfya mundʉ ʉngolofu. ");
INSERT INTO nyy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nalooli nikʉbabʉʉla, ʉmundʉ gwesa ʉjʉ ikʉnnwesya nalɨnga kɨkombe kya mɨɨsi amatalalɨfu jʉmo mmbandʉ abafujufu aba, paapo bafundigwa bangʉ, atikwisa kʉpondwa ɨfihombigwa kwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesu bo amalile ʉkʉbalagɨla ɨsya kʉbomba abafundigwa baake kalongo na babɨlɨ, alɨnkʉsookako kʉla. Alɨnkʉbʉʉka kʉkʉmanyisya nʉ kʉlʉmbɨlɨla ntwaja ʉtwa mu Galilai. ");
INSERT INTO nyy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Akabalɨlo ako, Johani ʉMoosi aalɨ mu nnyololo. Bo apɨliike ɨmbombo sya Kɨlɨsiti ɨsi aabombaga, po alɨnkʉbatʉma abafundigwa baake, ");
INSERT INTO nyy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kʉkʉnndaalʉʉsya ʉkʉtɨ, “Bʉle, ʉgwe jo ʉjʉ abakunguluka baatɨgɨ ikwisa? Pamo tʉnnguulɨlege ʉjʉngɨ?” ");
INSERT INTO nyy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Po alɨnkʉbaamula aba baatʉmiigwe alɨnkʉtɨ, “Mubʉʉkege mukammbʉʉle Johani ɨsi musibwene nʉ kʉsipɨlɨka. ");
INSERT INTO nyy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Abafwa maaso bikʉkeeta, aba bikʉkwema bikwenda, abakoma bikwelʉsigwa, abaa mapʉlɨ bikʉpɨlɨka, abafwe bikʉsyʉsigwa, kangɨ abalondo bikʉlʉmbɨlɨligwa ɨNdʉmi ɨNunu. ");
INSERT INTO nyy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Asajiigwe ʉmundʉ gwesa ʉjʉ atikʉleka ʉkʉʉsʉʉbɨla.” ");
INSERT INTO nyy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Abafundigwa baa Johani bo basookilepo, Jesu alɨnkwanda ʉkʉfibʉʉla ɨfilʉndɨlo ɨfya bandʉ ɨsya Johani ʉMoosi, alɨnkʉtɨ, “Mwabʉʉkaga ndʉngalangala kʉkʉkeeta ɨfiki? Kalɨ, mwabʉʉkile kʉkʉnkeeta ʉmundʉ ʉjʉ akaja na maka, afwene nʉ lʉtete ʉlʉ lukʉjʉgɨɨsigwa nʉ mbelo? Mma! ");
INSERT INTO nyy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Po mwabʉʉkile kʉkʉkeeta ɨfiki? Kalɨ, ʉmundʉ ʉjʉ afwele ɨmyenda ɨgya ntengo? Mma! Pɨlɨkɨsya! Abandʉ aba bikʉfwala ɨmyenda ɨgya ntengo, bikʉtʉʉgala mfitangaalala. ");
INSERT INTO nyy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Po leelo mwabʉʉkile kʉkʉkeeta ɨfiki? Ʉnkunguluka? Moomuumo! Nikʉbabʉʉla nikʉtɨ, ʉjo akaja nkunguluka itolo, looli nkʉlʉmba ʉkʉkɨnda ʉnkunguluka. ");
INSERT INTO nyy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ʉjo jo ʉjʉ ɨnongwa syake sisimbiigwe mwa Kalata ʉMwikemo, ʉkʉtɨ, ‘Keeta, ʉne nikʉntʉma ʉgwandʉmi gwangʉ, akʉtalɨlepo nkyeni mmyako, jo ikʉjɨtendekesya ɨnjɨla jaako.’ ");
INSERT INTO nyy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nalooli nikʉbabʉʉla nikʉtɨ, mmbandʉ boosa, akajapo ʉjʉ jo nkʉlʉmba ʉkʉnkɨnda Johani ʉMoosi. Looli ʉnnandɨ mBʉnyafyale bwa kʉmwanya, jo nkʉlʉmba ʉkʉnkɨnda ʉmwene. ");
INSERT INTO nyy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ʉkʉfuma amasikʉ gaa Johani ʉMoosi mpaka lɨɨlɨno, ʉBʉnyafyale bwa kʉmwanya bʉlɨ mbwite. Abandʉ abagaasi bo aba bikʉgela ʉkʉbʉkaba kʉ maka. ");
INSERT INTO nyy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Amasimbo gaa bakunguluka boosa, na gaa Moose, gaakungulwike ɨnongwa ɨsyo mpaka pakabalɨlo kaa Johani. ");
INSERT INTO nyy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Po lɨnga mukʉbwitɨka ʉbʉkunguluka bwabo, Johani jo Elija ʉnkunguluka, ʉjʉ aajobiigwe ʉkʉtɨ ikwisa kʉkʉntendekekesya Meesija. ");
INSERT INTO nyy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ʉjʉ alɨ nɨ mbʉlʉkʉtʉ, jo apɨlɨkege. ");
INSERT INTO nyy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Bʉle, mbafwanikɨsye nɨ fiki abandʉ abaa nkabalɨlo aka? Bafwene na baanike aba batʉʉgeele mu sokoni, aba bikʉbakoolela abiinaabo bikʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Twabakʉbiile amalonge gaa lʉsekelo, leelo mukaakinile! Twapaalile ɨɨfwa, leelo mukaalɨlile!’ ");
INSERT INTO nyy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Po Johani bo iisile, akaalyaga pamo ʉkʉnwa, abandʉ baatɨgɨ, ‘Alɨ nɨ mbepo ɨnyali.’ ");
INSERT INTO nyy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Leelo ne Nnyamundʉ niisile, ngʉlya nʉ kʉnwa, bikʉtɨ, ‘Keeta! Ʉmpafu ʉjʉ, kangɨ ngaala bwalwa! Mmanyaani gwa basongesya songo na bafujufu!’ Looli amahala gaa Kyala gikʉboneka ʉkʉja magolofu mu mbombo sya bandʉ baake.” ");
INSERT INTO nyy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Po Jesu alɨnkwanda ʉkʉtʉkemela ʉtwaja ʉtʉ aabombilemo ɨfiika fingi, paapo abandʉ abaa ntwaja ʉto bakaapɨndwike, alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ahɨɨli mwe bandʉ baa nkaaja akaa mu Kolasini, na nuumwe mwe baa nkaaja akaa mu Betisaita! Paapo ɨfiika ɨfi mbombile kʉmyɨnu, lɨnga fyabombiigwe ntwaja ʉtwa bandʉ ababiibi ʉtwa mu Tili na mu Sitoni, ngalɨ basʉʉmile ʉlʉhobokelo, kʉno bafwele amalogota nʉ kʉpakala ʉmfwandɨlo. ");
INSERT INTO nyy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Looli nikʉbabʉʉla nikʉtɨ, pi isikʉ lya bʉlongi ʉmwe mukwisa kʉkaba ʉlʉfundo ʉlʉnywamu, ʉkʉkɨnda ʉlwa bandʉ baa mu Tili na mu Sitoni. ");
INSERT INTO nyy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na nuumwe mwe bandʉ baa nkaaja akaa mu Kapelinaʉmu, bʉle, mukwinogona ʉkʉtɨ Kyala ikʉbakwesya mpaka kʉmwanya? Mma! Kyala ikʉbasulusya mpaka kʉ ngolongo. Ɨfiika ɨfi fyabombiigwe kʉmyɨnu, lɨnga fyabombiigwe nkaaja akaa mu Sotoma, akaaja ako ngalɨ kaliko mpaka lɨɨlɨno. ");
INSERT INTO nyy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Looli nikʉbabʉʉla nikʉtɨ, pi isikʉ lya bʉlongi, ʉmwe mukwisa kʉkaba ʉlʉfundo ʉlʉnywamu, ʉkʉkɨnda ʉlwa bandʉ baa mu Sotoma.” ");
INSERT INTO nyy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Akabalɨlo kalakala Jesu alɨnkʉjoba alɨnkʉtɨ, “Gwe Taata, gwe Ntwa ʉgwa kʉmwanya na pakiisʉ, ngʉgwa ʉlʉpi paapo ɨmbombo ɨsyo ʉbafisile abaa mahala na bamangʼanyi, ʉbanangiisye aba bikwijiisya bo ʉlwa baana. ");
INSERT INTO nyy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Moomuumo Taata, ɨsyo gwaliikyeliile.” ");
INSERT INTO nyy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kangɨ alɨnkʉtɨ, “Taata ambeele ʉtʉndʉ toosa. Akajako ʉjʉ ammeenye ʉMwana, looli Taata, pamo ʉjʉ ammeenye Taata looli ʉMwana, na gwesa ʉjʉ ʉMwana iiganile ʉkʉnnangɨsya. ");
INSERT INTO nyy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Isaga kʉmyangʉ ʉmwe mwesa mwe mukateele kangɨ mupɨmbile ɨfitwalo ɨfisito, ʉne ngʉbapapo ʉkʉtʉʉsya. ");
INSERT INTO nyy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mwitɨkege ʉkʉtɨ ʉne mbalongosyege bo ʉlwa ngambakʉ ɨsi sipinyiigwe ɨkɨpiki mmakosi. Mumanyilege kʉmyangʉ, paapo ʉne ndɨ mooloolo, kangɨ ndɨ nɨ ndumbula ɨjaa lwijiisyo. Po ʉmwe mukwisa kʉkabaga ʉlʉtengaano mu ndumbula syɨnu. ");
INSERT INTO nyy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Namanga ɨkɨpiki kyangʉ kɨpepe, nɨ kɨtwalo kyangʉ kɨpepe.” ");
INSERT INTO nyy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Akabalɨlo kamo, Jesu na bafundigwa baake bendaga mmigʉnda pi isikʉ ɨlya pa Sabati. Abafundigwa baake baalɨ nɨ njala, balɨnkwanda ʉkʉpʉlʉla ɨfisaasali, balɨnkʉlya. ");
INSERT INTO nyy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Looli aBafalisai bo basibwene ɨsyo, balɨnkʉmmbʉʉla Jesu balɨnkʉtɨ, “Fiki, abafundigwa baako bikʉpʉlʉla? Silɨ mwiko pi isikʉ ɨlya pa Sabati!” ");
INSERT INTO nyy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Bʉle, mukabalamo Kalata ʉMwikemo ɨsi aabombile ʉmalafyale Ndaabɨti na banine bo balɨ nɨ njala? ");
INSERT INTO nyy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aalingiile mu nyumba jaa Kyala, aaliile ɨfisyesye ɨfiikemo ʉmwene na banine, ɨfi bakaaliitɨkɨsiigwe ʉkʉlya nɨ ndagɨlo sya Moose. Baaliitɨkɨsiigwe beene abapuuti. ");
INSERT INTO nyy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kalɨ, mukabalamo ɨndagɨlo sya Moose ʉkʉtɨ abapuuti bikʉbomba ɨmbombo mu tempeli pi isikʉ ɨlya pa Sabati? Leelo batikʉbaligwa ʉkʉja batʉlanongwa. ");
INSERT INTO nyy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Looli nikʉbabʉʉla nikʉtɨ, apa alipo ʉnkʉlʉmba ʉkʉkɨnda ɨtempeli. ");
INSERT INTO nyy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Lɨnga mwagaageenie amasyʉ gaa Kalata ʉMwikemo, aga gikʉtɨ, ‘Ngʉlonda ɨkɨbabɨɨlɨsi, lyomma iikemo,’ ngalɨ mukabalonga abandʉ aba bakaja nɨ nongwa najɨmo. ");
INSERT INTO nyy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Paapo Nnyamundʉ jo Ntwa gwa Sabati.” ");
INSERT INTO nyy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesu alɨnkʉsookako ʉko, alɨnkwingɨla mu sinagogi jaabo. ");
INSERT INTO nyy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mu sinagogi mula, aalimo ʉmundʉ jʉmo ʉjʉ ɨkɨboko kyake kyalalile. Baalimo kangɨ aBafalisai aba baalondaga ʉkʉnngela Jesu ʉkʉtɨ bansitaake, po balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, ɨndagɨlo sya Moose sikwitɨkɨsya ʉkʉmmbʉmbʉlʉsya ʉmundʉ pi isikʉ ɨlya pa Sabati?” ");
INSERT INTO nyy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Lɨnga ɨngʼoosi jaako jɨmo jɨsolokiile nkiina pi isikʉ ɨlya pa Sabati, kʉbomba bʉleebʉle? Bʉle, ʉtikʉjɨfyʉla? ");
INSERT INTO nyy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Bʉle, ʉmundʉ akaja mpala ʉkʉkɨnda ɨngʼoosi? Kʉnongwa ɨjo sikʉtwitɨkɨsya ʉkʉbomba ɨnunu pi isikʉ ɨlya pa Sabati.” ");
INSERT INTO nyy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Po Jesu alɨnkʉmmbʉʉla ʉmundʉ ʉjʉ aalalile ɨkɨboko alɨnkʉtɨ, “Golosya ɨkɨboko kyako.” Alɨnkʉkɨgolosya, nakalɨnga kɨlɨnkʉbʉmbʉlʉka, kɨlɨnkʉja kɨkafu bo ɨkɨboko kyake ɨkɨngɨ. ");
INSERT INTO nyy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Looli aBafalisai balɨnkʉsooka panja, balɨnkʉjobesania ɨsya kʉnngoga Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesu bo asyageenie ɨnyiinogono syabo, alɨnkʉsookapo pala. Abandʉ bingi bankongaga, aababʉmbʉlʉsyaga ababine boosa. ");
INSERT INTO nyy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Looli aabakaanisyaga ʉkʉtɨ balɨngajobaga ʉkʉtɨ jo jwani. ");
INSERT INTO nyy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesu aajobaga bo ʉlo, ʉkʉtɨ siboneke ɨsi aajobile ʉnkunguluka Jeesaja mwa Kalata ʉMwikemo ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Namunkeete ʉmbombeli gwangʉ ʉjʉ nʉnsʉngwile, ʉNkʉndwe gwangʉ, ʉjʉ ɨndumbula jangʉ jiikyeliile nagwe. Ngʉmmbɨɨkapo Mbepo gwangʉ pamwanya pamyake, ʉkʉtɨ afumusye ʉbʉpoki bwangʉ kʉ bandʉ abaa mfiisʉ ɨfingi. ");
INSERT INTO nyy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pabʉlongi aikʉja kɨnuunu, Najʉmo ikwisa kʉlɨpɨlɨka ɨliisyʉ lyake pala. ");
INSERT INTO nyy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Atikwisa kʉmfulasya najʉmo ʉjʉ moonywa, bo ʉlwa lʉtete ʉlʉ lʉfyonywike. Atikwisa kʉmfulasya najʉmo ʉjʉ alɨ kɨfuki ʉkʉfwa, bo ʉlwa mooto ʉgʉ gʉlɨ kɨfuki ʉkʉsima. Kʉmmalɨɨkɨsyo ikwisa kʉbʉbɨɨka ʉbʉpoki ʉkʉbʉtola ʉbʉtʉlanongwa. ");
INSERT INTO nyy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kangɨ abandʉ abaa mfiisʉ ɨfingi bikwisa kʉnsʉʉbɨlaga.” ");
INSERT INTO nyy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Po abandʉ bamo balɨnkʉntwala kwa Jesu ʉmundʉ jʉmo ʉjʉ aalɨ nɨ mbepo ɨnyali. Ɨmbepo ɨnyali jɨla jaalɨmpelile ʉkʉja mfwa maaso nʉ kʉsita kʉjoba. Jesu alɨnkʉmmbʉmbʉlʉsya, ʉmundʉ jʉla alɨnkʉjoba nʉ kʉkeeta. ");
INSERT INTO nyy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɨkɨlʉndɨlo kyosa ɨkya bandʉ balɨnkʉswiga, balɨnkʉtɨ, “Bʉle, ʉjʉ akaja Mwana gwa malafyale Ndaabɨti?” ");
INSERT INTO nyy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Looli aBafalisai bo bapɨliike ɨsi abombile Jesu, balɨnkʉtɨ, “Ʉmundʉ ʉjʉ ikʉsikaga ɨmbepo ɨnyali kwene kʉ maka agaa Belisebuli, ʉnkʉlʉmba gwa mbepo ɨnyali.” ");
INSERT INTO nyy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesu alɨnkʉsyagania ɨnyiinogono syabo, po alɨnkʉbabʉʉla alɨnkʉtɨ, “Abandʉ abaa mbʉnyafyale bʉmo, lɨnga bikʉsambʉkana, ʉbʉnyafyale ʉbo bukʉfwa. Boope abaa nkɨkolo kɨmo, lɨnga basambʉkeene, ɨkɨkolo ɨkyo kikʉfwa. ");
INSERT INTO nyy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Lɨnga Seetano ikʉnkaga Seetano, po ʉbʉlongosi bwake bʉsambʉkeene. Bukwɨmaga bʉleebʉle? ");
INSERT INTO nyy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Lɨnga mukʉtɨ ʉne ngʉsikaga ɨmbepo ɨnyali kʉ maka agaa Belisebuli, abafundigwa bɨɨnu bikʉsikaga kʉ maka gaani? Abafundigwa bɨɨnu bikʉjaga balamuli bɨɨnu. ");
INSERT INTO nyy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Looli lɨnga ʉne ngʉsikaga ɨmbepo ɨnyali kʉ maka agaa Mbepo gwa Kyala, po ʉBʉnyafyale bwa Kyala bʉfikile kʉmyɨnu! ");
INSERT INTO nyy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Akajako ʉmundʉ najʉmo ʉjʉ abagiile ʉkwingɨla nnyumba jaa ʉjʉ alɨ na maka nkʉpʉpa ɨfyʉma fyake, bo akampinya taasi jʉla ʉgwa maka. Looli lɨnga ampinyile, po abagiile ʉkʉmpʉpa ɨfyʉma fyake. ");
INSERT INTO nyy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ʉmundʉ gwesa ʉjʉ akaja na niine, ikʉpɨngana na niine, na ʉjʉ atikʉbʉngaania pamopeene na niine, ikʉbalania. ");
INSERT INTO nyy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kʉnongwa ɨjo nikʉbabʉʉla nikʉtɨ, abandʉ babagiile ʉkʉhobokeligwa kʉkʉtɨ bʉtʉlanongwa na maheelu. Looli ʉjʉ ikʉntʉka Mbepo Mwikemo, atikwisa kʉhobokeligwa. ");
INSERT INTO nyy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kangɨ ʉmundʉ gwesa ʉjʉ ikʉntʉka Nnyamundʉ abagiile ʉkʉhobokeligwa. Looli ʉjʉ ikʉntʉka Mbepo Mwikemo, atikwisa kʉhobokeligwa, akabalɨlo aka pamo aka kikwisa.” ");
INSERT INTO nyy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ʉtendekesye ʉmpiki kanunu, ɨseke syake sikʉjaga nunu. Ʉtendekesye ʉmpiki kabiibi, ɨseke syake sikʉjaga mbiibi. Ʉbagiile ʉkʉgʉmanya ʉmpiki muno gʉjɨɨliile kʉ seke syake. ");
INSERT INTO nyy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwe njoka ʉmwe! Mubagiile bʉleebʉle ʉkʉjoba ɨnunu bo ʉmwe mulɨ babiibi? Ʉmundʉ ikʉjoba ɨsi siiswile nʉ kooneka ʉkʉfuma mu ndumbula jaake. ");
INSERT INTO nyy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ʉmundʉ ʉnnunu ikʉsoosya ɨnunu ʉkʉfuma mu nunu ɨsi siiswile mu ndumbula jaake. Looli ʉmundʉ ʉmbiibi, ikʉsoosya ɨmbiibi ʉkʉfuma mu mbiibi ɨsi siiswile mu ndumbula jaake. ");
INSERT INTO nyy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nikʉbabʉʉla nikʉtɨ, pi isikʉ lya bʉlongi, abandʉ bikwisa kʉlaalʉʉsigwa ʉkʉlɨngaania kʉkʉtɨ isyʉ ɨlya mwalo ɨlɨ baalɨjobile. ");
INSERT INTO nyy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Po kʉ masyʉ gaako amanunu kwisa kwabʉligwa pabʉlongi, na kʉ masyʉ gaako amabiibi kwisa kʉlongigwa.” ");
INSERT INTO nyy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Po aBafalisai bamo na bamanyisi baa ndagɨlo sya Moose, balɨnkʉmmbʉʉla Jesu balɨnkʉtɨ, “Gwe Mmanyisi, tukʉlonda ʉbombe ɨkiika, ʉkʉnangɨsya ʉkʉtɨ ʉtʉmiigwe na Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ʉmwe mulɨ batʉlanongwa mukiigana ʉkʉmmanya Kyala, ʉkeetege mukʉsʉʉma ɨkɨmanyilo! Mutikʉpeeligwa ɨkɨmanyilo nakɨmo, looli kyene ɨkɨmanyilo ɨkya nkunguluka Joona. ");
INSERT INTO nyy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bo ʉlwa Joona aalɨ munda muuswɨ ɨnywamu amasikʉ matatʉ, pakɨlo na pamuusi, bʉbʉʉbo Nnyamundʉ aikʉtʉʉgala mwi ipʉmba amasikʉ matatʉ, pakɨlo na pamuusi. ");
INSERT INTO nyy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pi isikʉ lya bʉlongi, boope abandʉ abaa mu Ninibe bikwisa kwɨma ʉkʉbabʉʉla mwe bandʉ baa nkabalɨlo aka, ʉkʉtɨ mulɨ babiibi, paapo Joona bo alʉmbɨliile ɨliisyʉ lya Kyala kʉmyabo, baapɨndwike. Apa lɨɨlɨno alipo ʉnkʉlʉmba ʉkʉnkɨnda Joona! ");
INSERT INTO nyy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pi isikʉ lya bʉlongi, ʉmalafyale ʉnkiikʉlʉ ʉgwa kwitongo ikwisa kwɨma ʉkʉbabʉʉla mwe bandʉ baa nkabalɨlo aka, ʉkʉtɨ mulɨ babiibi. Ʉmwene aafumile nkiisʉ kya kʉbʉtali, aaliisile kʉkʉpɨlɨkɨsya amasyʉ gaa mahala agaa Solomoni. Apa lɨɨlɨno alipo ʉnkʉlʉmba ʉkʉnkɨnda Solomoni!” ");
INSERT INTO nyy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ɨmbepo ɨnyali bo jikʉsooka mmundʉ, jikʉbʉʉka ndʉngalangala kʉkʉlonda ʉbʉjo bwa kʉtʉʉsya, jɨtikʉbwaga. ");
INSERT INTO nyy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Po jikʉjoba jikʉtɨ, ‘Ngʉgomokelako kʉla kʉ nyumba jangʉ, kʉno naaliko.’ Lɨnga jɨgomwike, jikwaga ɨnyumba jɨlɨ jeene, jɨpyagɨliigwe nʉ kʉtendekesigwa kanunu. ");
INSERT INTO nyy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Po jikʉbʉʉka kʉkʉsyega ɨmbepo ɨnyali ɨsingi ihaano na ibɨlɨ, ɨmbiibi ʉkʉjɨkɨndapo ɨjeene. Ɨmbepo ɨsyo syosa sikwingɨla nʉ kʉtʉʉgala mmundʉ ʉjo. Po akajɨɨlo kaa mundʉ ʉjo kikʉja kabiibi ʉkʉkɨnda ʉlʉtasi. Mo muno sikwisa kʉjɨɨlaga kʉ bandʉ ababiibi abaa nkabalɨlo aka.” ");
INSERT INTO nyy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesu bo alɨ pakʉjoba nɨ kɨlʉndɨlo ɨkya bandʉ, keeta, ʉnna na baamyabo baa Jesu baalyɨmile panja pa nyumba ɨjɨ aalimo, baalondaga ʉkʉjoba nagwe. ");
INSERT INTO nyy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Po ʉmundʉ jʉmo alɨnkʉmmbʉʉla alɨnkʉtɨ, “Keeta! Ʉnyoko na bakamu baako bɨɨmile panja, bikʉlonda ʉkʉjoba na nungwe.” ");
INSERT INTO nyy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Looli Jesu alɨnkʉmmbʉʉla ʉmundʉ jʉla alɨnkʉtɨ, “Jʉʉba jo jwani? Na bakamu bangʉ bo baani?” ");
INSERT INTO nyy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Po alɨnkʉgolosya ɨkɨboko kʉ bafundigwa baake alɨnkʉtɨ, “Keeta, aba bo baa jʉʉba na bakamu bangʉ! ");
INSERT INTO nyy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gwesa ʉjʉ ikʉbomba ʉbwigane bwa Taata gwangʉ ʉgwa kʉmwanya, ʉjo jo nkamu gwangʉ, jo ilʉmbʉ gwangʉ, jo jʉʉba.” ");
INSERT INTO nyy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Iisikʉ lɨlalɨla, Jesu alɨnkʉsookamo mu nyumba jɨla, alɨnkʉbʉʉka kʉkʉtʉʉgala kʉmbalɨ kwa sʉmbɨ Galilai. ");
INSERT INTO nyy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ɨkɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ kɨlɨnkʉbʉngaana kɨfuki nagwe. Kʉnongwa jaa bwingi bwa bandʉ, alɨnkwipakɨla mwi ibooti, alɨnkʉbamanyisya bo alɨ mula. Ɨkɨlʉndɨlo ɨkya bandʉ boosa baalɨ pi isɨɨlya. ");
INSERT INTO nyy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Po Jesu alɨnkʉbabʉʉla ɨnongwa ɨnyingi mfifwanikɨsyo, alɨnkʉtɨ, “Ʉmbyali jʉmo aabʉʉkile kʉkʉsopa ɨmbeju. ");
INSERT INTO nyy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bo ikʉsopa, ɨmbeju simo syagwɨliile mumbalɨ mu njɨla, silɨnkwisa ɨnjʉni silɨnkʉlya. ");
INSERT INTO nyy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ɨsingi syagwɨliile pa lwalabwe, apa ʉmfu gʉkaalipo mwingi. Syo nakalɨnga silɨnkʉmela. ");
INSERT INTO nyy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Iisʉba bo lɨbalile ʉlʉmu bo lʉkalɨ, silɨnkʉkofuka nʉ kʉʉma, paapo ɨmisi gɨkaabʉʉkile paasi. ");
INSERT INTO nyy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ɨmbeju ɨsingi syagwɨliile pakatɨ pa miifwa. Ɨmiifwa gɨla gɨlɨnkʉmela nʉ kʉsifinyatɨla. ");
INSERT INTO nyy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ɨmbeju ɨsingi syagwɨliile pa mfu ʉnnunu. Simo silɨnkʉpa ɨseke ɨmia jɨmo, ɨsingi silɨnkʉpa amalongo ntandatʉ, nɨ singi silɨnkʉpa amalongo matatʉ. ");
INSERT INTO nyy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ʉjʉ alɨ nɨ mbʉlʉkʉtʉ, jo apɨlɨkege!” ");
INSERT INTO nyy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Balɨnkwisa abafundigwa baa Jesu balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Fiki kʉjoba na bandʉ mfifwanikɨsyo?” ");
INSERT INTO nyy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Alɨnkʉbaamula alɨnkʉtɨ, “Ʉmwe Kyala abapeele ʉkʉsyagania ɨsya mbʉtiitʉ ɨsya Bʉnyafyale bwa kʉmwanya, looli abeene bakapeeligwa na Kyala ʉkʉsimanya. ");
INSERT INTO nyy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ʉjʉ apeeliigwe ʉkʉsyagania ɨsyo, ikongeleligwa ʉkʉsyagania. Ʉjʉ akapeeligwa ʉkʉsyagania, syope ɨnandɨ ɨsi asyageenie sitikʉntʉʉla. ");
INSERT INTO nyy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Fyobeene abangɨ nikʉbabʉʉla mfifwanikɨsyo, paapo, nalɨnga bikʉkeeta, batikʉfibona, nalɨnga bikʉpɨlɨka, batikʉsyagania. ");
INSERT INTO nyy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ɨsi sikʉbombigwa kʉmyabo ʉkʉtɨ sibonekege ɨsi ʉnkunguluka Jeesaja aajobile ʉkʉtɨ, ‘Ʉkʉpɨlɨka mukʉpɨlɨkaga, looli mutikʉsyaganiaga. Nʉ kʉkeeta mukʉkeetaga, looli mutikʉsibonaga. ");
INSERT INTO nyy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Paapo ɨndumbula sya bandʉ aba ngafu, ɨmbʉlʉkʉtʉ syabo silɨ na mapʉlɨ, kangɨ basiisiilile. Lɨnga baakeetaga na maaso gaabo, nʉ kʉpɨlɨka nɨ mbʉlʉkʉtʉ syabo, ngalɨ basyageenie mu ndumbula syabo nʉ kʉpɨndʉka, po naababʉmbʉlʉsyaga.’ ");
INSERT INTO nyy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Looli Kyala abasajile ʉmwe, paapo amaaso gɨɨnu gikʉkeeta, nɨ mbʉlʉkʉtʉ syɨnu sikʉpɨlɨka. ");
INSERT INTO nyy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nalooli nikʉbabʉʉla nikʉtɨ, abakunguluka bingi na bagolofu baanyonywaga ʉkʉsibona ɨsi mukʉsibona ʉmwe, looli bakaasibwene. Kangɨ baanyonywaga ʉkʉpɨlɨka ɨsi mukʉsipɨlɨka ʉmwe, looli bakaasipɨliike.” ");
INSERT INTO nyy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Po ʉmwe namupɨlɨkɨsye ɨkɨfwanikɨsyo ɨkya mbyali kikʉtɨ fiki. ");
INSERT INTO nyy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ʉmundʉ gwesa ʉjʉ ikʉpɨlɨka iisyʉ lya Bʉnyafyale bwa kʉmwanya kɨsita kʉsyagania, Seetano ikwisa nʉ kʉlɨsoosyamo ɨlɨ Kyala alɨbyele mu ndumbula jaake. Ʉmundʉ ʉjo afwene bo ʉlwa mbeju ɨsi syagwɨliile mu njɨla. ");
INSERT INTO nyy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ɨmbeju ɨsi syagwɨliile pamwanya pa lwalabwe, ʉlʉ lʉkaja nʉ mfu mwingi, sifwene bo ʉlwa mundʉ ʉjʉ ikʉpɨlɨka iisyʉ lya Bʉnyafyale bwa kʉmwanya, nakalɨnga ikʉlyambɨlɨla nʉ lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Leelo iisyʉ lɨtikwitoteka mu ndumbula jaake, paapo lɨkaja nɨ misi, likʉjamo akabalɨlo akapimba itolo. Lɨnga ɨngʉbɨlo sikʉmmwisɨla pamo ikʉgeligwa kʉnongwa jaa isyʉ ɨlyo, nakalɨnga ikʉlʉleka ʉlwitɨko. ");
INSERT INTO nyy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ɨmbeju ɨsi syagwɨliile pa miifwa, sifwene bo ʉlwa mundʉ ʉjʉ ikʉpɨlɨka iisyʉ lya Kyala, looli kʉnongwa jaa kwikolaania, nɨ mbombo ɨsya pakiisʉ, nʉ kʉsyobigwa, nɨ finyonyo ɨfya bʉkabi, fyosa ɨfyo fikʉlɨfinyatɨla iisyʉ, lɨtikʉpa ɨseke. ");
INSERT INTO nyy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Looli ɨmbeju ɨsi syagwɨliile pa mfu ʉnnunu, sifwene nʉ mundʉ ʉjʉ ikʉpɨlɨka iisyʉ ɨlyo nʉ kʉlyagania. Ʉmundʉ ʉjo jo ʉjʉ ikʉpa ɨseke. Jʉmo ikʉpa ɨseke ɨmia jɨmo, jʉmo amalongo ntandatʉ, nʉ jʉngɨ amalongo matatʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu alɨnkʉkɨbʉʉla ɨkɨlʉndɨlo kya bandʉ ɨkɨfwanikɨsyo ɨkɨngɨ alɨnkʉtɨ, “ɄBʉnyafyale bwa kʉmwanya aabukwisa bo ʉlwa mundʉ jʉmo, ʉjʉ aabyele ɨmbeju ɨnunu mu ngʉnda gwake ʉgwa nganu. ");
INSERT INTO nyy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Looli abandʉ bo balambaleele, ʉndʉgʉ alɨnkwisa alɨnkʉsopa mu ngʉnda ɨmbeju ɨmbiibi ɨsi sifwene nɨ nganu, alɨnkʉsookamo. ");
INSERT INTO nyy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ɨnganu bo jɨmelile nʉ kwanda ʉkʉpa ɨseke, ɨseke ɨmbiibi ɨsi sifwene nɨ nganu syope silɨnkʉboneka. ");
INSERT INTO nyy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ababombi abaa mwene ngʉnda jʉla, balɨnkwisa kʉkʉnndaalʉʉsya balɨnkʉtɨ, ‘Gwe ntwa, tʉmeenye ʉkʉtɨ gwabyele ɨmbeju ɨnunu mu ngʉnda gwako, ɨmbeju ɨmbiibi sifumile kʉʉgʉ?’ ");
INSERT INTO nyy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Alɨnkʉbaamula alɨnkʉtɨ, ‘Ʉndʉgʉ jo ʉjʉ asibombile ɨsi.’ Ababombi balɨnkʉnndaalʉʉsya balɨnkʉtɨ, ‘Bʉle, kʉlonda tʉbʉʉke tʉkanyukule?’ ");
INSERT INTO nyy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ʉmwene alɨnkʉtɨ, ‘Somma ʉkʉnyukula, paapo lɨnga mukʉnyukula ɨmbeju ɨmbiibi, mubagiile ʉkʉnyukula pamopeene nɨ nganu. ");
INSERT INTO nyy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Namufileke fyosa fikʉlege pamopeene mpaka ʉkʉfika akabalɨlo akaa kʉtondola. Akabalɨlo ako, ngwisa kʉbabʉʉla abatondoli ʉkʉtɨ babʉngaanie taasi ɨmbeju ɨmbiibi nʉ kʉpinya mfikose nʉ kʉkosya mmooto. Looli ɨnganu bajɨbʉngaanie nʉ kʉjɨbɨɨka mu ndamba jangʉ.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesu alɨnkʉbabʉʉla ɨkɨfwanikɨsyo ɨkɨngɨ alɨnkʉtɨ, “ɄBʉnyafyale bwa kʉmwanya bʉfwene na kaseke akaa iseeke ɨlya mutaka, aka ʉmundʉ aalyegile, aabyele mu ngʉnda gwake. ");
INSERT INTO nyy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Akaseke aka kaniini ʉkʉkɨnda ɨseke syosa. Looli kikʉmela, kikʉkʉla ʉkʉkɨnda amaseeke goosa, kikʉja mpiki nnywamu ʉgʉ ɨnjʉni sikwisa nʉ kʉtenga ɨfifufumbwa mu samba syake.” ");
INSERT INTO nyy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesu alɨnkʉjoba ɨkɨfwanikɨsyo ɨkɨngɨ alɨnkʉtɨ, “ɄBʉnyafyale bwa kʉmwanya bʉfwene nʉ nkese ʉgʉ ʉnkiikʉlʉ jʉmo aalyongeenie nʉ bʉfu ɨfipɨmo fitatʉ, ʉbʉfu boosa bʉlɨnkʉtupa.” ");
INSERT INTO nyy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesu aababʉʉlaga ɨfilʉndɨlo ɨfya bandʉ syosa ɨsyo mfifwanikɨsyo. Akaajobaga nasimo kʉmyabo kɨsita kʉbombela ɨkɨfwanikɨsyo. ");
INSERT INTO nyy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ɨsyo syabombiigwe ʉkʉtɨ siboneke ɨsi ʉnkunguluka aajobile aatile, “Ngwisa kʉjobaga nabo mfifwanikɨsyo. Ngwisa kʉbabʉʉlaga ɨsi sifisiigwe ʉkʉfuma lʉʉlo kyapeligwaga ɨkiisʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Po Jesu alɨnkʉkɨlaga ɨkɨlʉndɨlo kya bandʉ, alɨnkwingɨla nnyumba. Abafundigwa baake balɨnkwisa, balɨnkʉmmbʉʉla balɨnkʉtɨ, “Tʉlɨngaanie ɨkɨfwanikɨsyo ɨkya mbeju mu ngʉnda, kokʉtɨ fiki?” ");
INSERT INTO nyy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ʉmundʉ ʉjʉ aabyele ɨmbeju ɨnunu, jo ʉne Nnyamundʉ. ");
INSERT INTO nyy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ʉngʉnda gʉla kyo kiisʉ, ɨmbeju ɨnunu sila, bo bandʉ baa mBʉnyafyale bwa Kyala, nɨ mbeju ɨmbiibi sila, ɨsi ʉmwene ngʉnda akaabyele, bo bandʉ baa mbʉnyafyale bwa Seetano. ");
INSERT INTO nyy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ʉndʉgʉ ʉjʉ aaliisile kʉkʉbyala ɨmbeju ɨmbiibi jo Seetano. Ʉkʉtondola lyo isikʉ ɨlya kʉmmalɨɨkɨsyo ɨlya kʉlonga ɨkiisʉ. Abatondoli bo bandʉmi baa Kyala. ");
INSERT INTO nyy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Po bo ʉlʉ abatondoli bikʉbʉngaania ɨmbeju ɨmbiibi nʉ kʉkosya mmooto, sikwisa kʉjaga bo ʉlo amasikʉ gaa kʉmmalɨɨkɨsyo. ");
INSERT INTO nyy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ne Nnyamundʉ ngwisa kʉbatʉma abandʉmi bangʉ, ʉkʉbabʉngaania abandʉ ʉkʉfuma mBʉnyafyale bwangʉ aba bikʉbasofya abiinaabo, na batʉlanongwa boosa. ");
INSERT INTO nyy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Abandʉmi bikwisa kʉbataaga abandʉ abo ndʉpanga lwa mooto, mula bikwisa kʉlɨlaga nʉ kʉsyegetula amiino kʉnongwa jaa ndaamyo. ");
INSERT INTO nyy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Po abiikemo bikwisa kʉlangala bo isʉba mBʉnyafyale bwa Taata. Ʉjʉ alɨ nɨ mbʉlʉkʉtʉ, jo apɨlɨkege!” ");
INSERT INTO nyy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ɄBʉnyafyale bwa kʉmwanya bʉfwene bo ʉlwa kyʉma ɨkɨ kɨfisiigwe mu ngʉnda. Ʉmundʉ jʉmo alɨnkwisa, alɨnkʉkyaga mula, alɨnkʉkɨfisa kangɨ. Aasekiile fiijo, alɨnkwakʉʉlɨsya fyosa ɨfi aalɨ nafyo, alɨnkʉʉla ʉngʉnda gʉla. ");
INSERT INTO nyy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kangɨ ʉBʉnyafyale bwa kʉmwanya bʉfwene bo ʉlwa mabwe agaa ntengo aga gaalondigwaga nʉ mʉʉlɨsi jʉmo. ");
INSERT INTO nyy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bo alyagile iibwe lɨmo ɨlya ntengo ʉnnywamu fiijo, alɨnkʉbʉʉka, alɨnkwakʉʉlɨsya fyosa ɨfi aalɨ nafyo, alɨnkwisa kʉlyʉla.” ");
INSERT INTO nyy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kangɨ ʉBʉnyafyale bwa kʉmwanya bʉfwene nʉ lwelo ʉlʉ abalobi baasopile mwa sʉmbɨ, lwakolile ɨɨswɨ ɨsya lʉko nʉ lʉko. ");
INSERT INTO nyy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ʉlwelo lʉla bo lwiswile ɨɨswɨ, balɨnkʉlʉkwabɨla pi isɨɨlya, balɨnkʉtʉʉgala balɨnkʉsala ɨɨswɨ ɨnunu nʉ kʉsibɨɨka mfiibo fyabo, looli ɨɨswɨ ɨmbiibi balɨnkʉsitaaga. ");
INSERT INTO nyy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sikwisa kʉjaga bo ʉlo pi isikʉ ɨlya kʉmmalɨɨkɨsyo ɨlya kʉlonga ɨkiisʉ. Abandʉmi bikwisa kʉpaagʉlania abatʉlanongwa na biikemo. ");
INSERT INTO nyy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Po bikwisa kʉbataaga abatʉlanongwa ndʉpanga lwa mooto, mula bikwisa kʉlɨlaga nʉ kʉsyegetula amiino kʉnongwa jaa ndaamyo.” ");
INSERT INTO nyy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesu alɨnkʉbalaalʉʉsya abafundigwa baake alɨnkʉtɨ, “Bʉle, musyageenie ɨsi syosa?” Balɨnkʉmmwamula balɨnkʉtɨ, “Tʉsyageenie.” ");
INSERT INTO nyy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Kʉkʉtɨ mmanyisi gwa ndagɨlo ʉjʉ amanyisiigwe ɨsya Bʉnyafyale bwa kʉmwanya, afwene bo ʉmwene nyumba ʉjʉ ikʉsokola mu ndamba jaake ɨkyʉma ɨkɨpya nɨ kɨkʉʉlʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesu bo amalile ʉkʉjoba ɨfifwanikɨsyo ɨfyo, alɨnkʉsookako kʉla. ");
INSERT INTO nyy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bo afikile nkaaja aka aakʉliile, alɨnkʉbamanyisya abandʉ mu sinagogi jaabo. Abandʉ bala balɨnkʉswiga, balɨnkʉlaalʉʉsania balɨnkʉtɨ, “Mwe! Ʉjʉ agaagile kʉʉgʉ amahala aga, na maka agaa kʉbomba ɨfiika ɨfi? ");
INSERT INTO nyy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bʉle, ʉjʉ akaja jo mwana gwa nsongola matapwa? Ʉnna akaja jo ʉjʉ bikʉntɨ Malija? Bʉle, abaamyabo bakaja bo baa Jaakobo, Joosefu, Simoni na Juuta? ");
INSERT INTO nyy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Abalʉmbʉ baake boosa tʉkaja nabo papaapa? Po ʉjʉ asyagile kʉʉgʉ syosa ɨsi?” ");
INSERT INTO nyy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Po abeene balɨnkwikinyamo, balɨnkʉsita kʉmmwitɨka. Looli Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉnkunguluka atikʉpondwa ʉlwɨmɨko looli mwene nkaaja kaake, nkɨkolo kyake na baa mu nyumba jaake.” ");
INSERT INTO nyy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jesu akaabombile ɨfiika fingi kʉla, paapo abandʉ abo bakaalɨmmwitiike. ");
INSERT INTO nyy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Akabalɨlo ako Heloti, ʉmalafyale ʉgwa mu Galilai, aapɨliike ɨnongwa sya Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Po alɨnkʉbabʉʉla ababombeli baake alɨnkʉtɨ, “Ʉjo jo Johani ʉMoosi asyʉkile ʉkʉfuma mbafwe. Ʉkeetege alɨ na maka agaa kʉbomba ɨfiika.” ");
INSERT INTO nyy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kʉbwandɨlo ʉnkiikʉlʉ jʉmo ɨngamu jaake Helotija, aalɨ nkasi gwa Filipo ʉgwamyabo gwa malafyale Heloti. Po Heloti alɨnkʉmmwega Helotija. Johani ammbʉʉlaga Heloti alɨnkʉtɨ, “Silɨ mwiko ʉgwe ʉkʉmmwega Helotija ʉnkasi gwa gwamyɨnu.” Heloti alɨnkʉbatʉma abasikali abaa kʉnkola Johani, alɨnkʉmpinya mu nnyololo, ʉkʉtɨ anhobosye Helotija. ");
INSERT INTO nyy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heloti aalondaga ʉkʉnngoga Johani, looli aabatiilaga abandʉ, bammwɨmɨkaga Johani, paapo aalɨ nkunguluka. ");
INSERT INTO nyy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pi isikʉ ɨlya kʉkʉmbʉka ʉkʉpaapigwa ʉmalafyale Heloti, ʉmwana ʉndɨndwana ʉgwa Helotija aamogile nkyeni mbaheesya. Alɨnkʉnhobosya fiijo Heloti. ");
INSERT INTO nyy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Po Heloti alɨnkʉlapa ʉkʉtɨ, ikʉmpapo ʉndɨndwana jʉla akandʉ kokoosa aka ikʉsʉʉma. ");
INSERT INTO nyy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kʉnongwa jaa kʉsongigwa nʉ nna, ʉndɨndwana jʉla alɨnkʉmmbʉʉla Heloti alɨnkʉtɨ, “Ʉmbepo apa ʉntʉ ʉgwa Johani ʉMoosi mwi ibeeseni.” ");
INSERT INTO nyy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ʉmalafyale alɨnkʉsulumania fiijo, looli kʉnongwa jaa kʉlapa kwake, na kʉnongwa jaa bandʉ aba baalɨ pa lʉsekelo, alɨnkʉlagɨla ʉkʉtɨ bampepo. ");
INSERT INTO nyy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Po Heloti alɨnkʉntʉma ʉmundʉ kʉkʉmmbuuta ʉntʉ Johani, mula mu nnyololo. ");
INSERT INTO nyy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Alɨnkʉgʉtwala ʉntʉ gwake mwi ibeeseni, nʉ kʉmpapo ʉndɨndwana jʉla, joope ʉndɨndwana alɨnkwakʉmpapo ʉnna. ");
INSERT INTO nyy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Po paapo abafundigwa baa Johani balɨnkʉbʉʉka, balɨnkwega ʉmfimba, balɨnkʉgʉsyɨla. Po balɨnkʉbʉʉka kʉkʉmmbʉʉla Jesu ɨnongwa ɨsi. ");
INSERT INTO nyy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesu bo apɨliike ɨsi, alɨnkwipakɨla mwi ibooti, alɨnkʉbʉʉka pabʉjo ʉbʉsita bandʉ. Looli abandʉ bo bapɨliike, balɨnkʉnkonga, balɨnkwenda ɨnjɨla ɨjaa pi isɨɨlya na malʉndɨ ʉkʉfuma ntwaja. ");
INSERT INTO nyy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesu bo asulwike mwi ibooti, alɨnkʉkɨbona ɨkɨlʉndɨlo ɨkɨnywamu, kɨlɨnkʉmmwaga ɨkɨsa, alɨnkʉbabʉmbʉlʉsya ababine baabo. ");
INSERT INTO nyy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Namajolo abafundigwa baake balɨnkʉbʉʉka kwa Jesu, balɨnkʉmmbʉʉla balɨnkʉtɨ, “Ʉbʉjo ʉbʉ tʉlipo lʉkʉbo, kangɨ ʉlʉ majolo. Balage abandʉ basookepo, ʉkʉtɨ bakiijʉʉlɨle ɨfindʉ ntwaja.” ");
INSERT INTO nyy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Balɨngabʉʉkaga, amubapepo ʉmwe ɨfindʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Balɨnkʉmmwamula balɨnkʉtɨ, “Tʉlɨ nafyo ɨfisyesye fihaano itolo nɨ ɨswɨ ibɨlɨ.” ");
INSERT INTO nyy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Namundwalɨle ʉne apa.” ");
INSERT INTO nyy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Po alɨnkʉbalagɨla abandʉ ʉkʉtɨ batʉʉgale paasi pa liisʉ. Alɨnkwega ɨfisyesye fila fihaano, nɨ ɨswɨ sila ibɨlɨ, alɨnkʉkeeta kʉmwanya, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉfimenya ɨfisyesye, alɨnkʉbapapo abafundigwa baake. Po abafundigwa baake balɨnkʉbajabɨla abandʉ. ");
INSERT INTO nyy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Abandʉ boosa balɨnkʉlya, balɨnkwikʉta. Po abafundigwa baake balɨnkʉbʉngaania ɨfimeenya ɨfi fyasyeleko, balɨnkwisʉsya ɨfiibo kalongo na fibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Abandʉ aba baaliile ɨfindʉ fila baalɨ banyambala 5,000 bʉno, kɨsita kʉbalɨlako abakiikʉlʉ na baana. ");
INSERT INTO nyy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nakalɨnga Jesu alɨnkʉbalagɨla abafundigwa baake ʉkʉtɨ biipakɨle mwi ibooti, batalepo ʉkʉbʉʉka kwi isɨɨlya ɨlya sʉmbɨ Galilai, bo ʉmwene alɨ pakʉkɨlaga ɨkɨlʉndɨlo kya bandʉ. ");
INSERT INTO nyy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jesu bo akɨlagile ɨkɨlʉndɨlo kɨla ɨkya bandʉ, alɨnkʉfyʉka mwene pa kyamba, pabʉjo ʉbwa kwijeekela, ʉkʉtɨ iipuute. Namajolo aaliko ʉko mwene. ");
INSERT INTO nyy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Akabalɨlo ako ɨliibooti lyafikile pakatɨ paa sʉmbɨ, looli amajɨga gaalɨpɨngaga paapo ʉmbelo gwakulaga. ");
INSERT INTO nyy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Po kʉbʉkye Jesu alɨnkʉbʉʉka kʉno baaliko, bo ikwenda pamwanya pa mɨɨsi. ");
INSERT INTO nyy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Looli abafundigwa baake bo bammbwene Jesu ikwenda pamwanya pa mɨɨsi, balɨnkʉtetema, balɨnkʉtɨ, “Nsyʉka!” Balɨnkʉkuuta fiijo kʉ lʉtende. ");
INSERT INTO nyy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nakalɨnga Jesu alɨnkʉjoba nabo, alɨnkʉtɨ, “Mwikasye, jo ʉne! Mungatiilaga!” ");
INSERT INTO nyy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peeteli alɨnkʉmmwamula alɨnkʉtɨ, “Gwe Ntwa, lɨnga jo ʉgwe nalooli, ndagɨla ʉkʉtɨ niise kʉmyako bo ngwenda pamwanya pa mɨɨsi.” ");
INSERT INTO nyy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Isaga.” Po Peeteli alɨnkwika ʉkʉfuma mwi ibooti lɨla, alɨnkwenda pamwanya pa mɨɨsi, alɨnkʉkonga Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Looli bo agʉbwene ʉmbelo alɨnkʉtiila fiijo, alɨnkwanda ʉkwibɨla. Po alɨnkʉkuuta fiijo alɨnkʉtɨ, “Gwe Ntwa, ʉlɨɨmboka!” ");
INSERT INTO nyy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nakalɨnga, Jesu alɨnkʉgolosya ɨkɨboko kyake, alɨnkʉnkola, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwe gwa lwitɨko ʉlʉnandɨ, fiki gwilaamwaga?” ");
INSERT INTO nyy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jesu na Peeteli balɨnkwipaka mwi ibooti, po ʉmbelo gʉlɨnkʉbota. ");
INSERT INTO nyy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Po abafundigwa aba baalimo mwi ibooti, balɨnkʉbunguluka kwa Jesu, balɨnkʉtɨ, “Nalooli ʉgwe ʉlɨ Mwana gwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jesu na bafundigwa baake bo balobwike sʉmbɨ Galilai, balɨnkʉfika nkiisʉ ɨkya mu Genesaleti. ");
INSERT INTO nyy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Abandʉ baa nkiisʉ kɨla bo bammwageenie ʉkʉtɨ jo Jesu, balɨnkʉtwala ɨndʉmi ntwaja toosa ʉtwa kɨfuki. Abandʉ balɨnkʉbatwala kwa Jesu boosa aba baalɨ babine. ");
INSERT INTO nyy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Balɨnkʉmpyelesya Jesu ʉkʉtɨ abiitɨkɨsye ababine bapalamaasye, nalɨnga kɨpeto kya mwenda gwake. Po ababine boosa aba baalɨmpalamaasiisye, baabʉmbʉlwike. ");
INSERT INTO nyy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Po aBafalisai bamo na bamanyisi baa ndagɨlo sya Moose balɨnkwisa ʉkʉfuma mu Jelusalemu. Balɨnkʉbʉʉka kwa Jesu, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Fiki abafundigwa baako bikʉkilania ɨnyiiho sya biisʉkʉlʉ bɨɨtʉ? Bikʉlya kɨsita kʉkonga ʉlwiho ʉlwa kʉsugusula amaboko!” ");
INSERT INTO nyy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Fiki na nuumwe mukʉkilania ɨndagɨlo sya Kyala, kʉ njɨla jaa kʉsikonga ɨnyiiho syɨnu? ");
INSERT INTO nyy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Namanga Kyala aabalagiile ʉkʉtɨ, ‘Ʉmmwɨmɨkege ʉgʉʉso nʉ nyoko,’ kangɨ ʉkʉtɨ, ‘Ʉjʉ ikʉntʉka ʉgwise pamo ʉnna, jo agogigwege.’ ");
INSERT INTO nyy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Looli ʉmwe mukʉmanyisya mukʉtɨ, ‘Kanunu ʉmundʉ lɨnga ikʉmmbʉʉla ʉgwise pamo ʉnna, ikʉtɨ, “Ɨfi naalondaga ʉkʉkʉpapo ʉgwe, ndikʉkʉpapo, mfibɨɨkile ʉkʉja ikemo kwa Kyala.” ’ ");
INSERT INTO nyy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Po alɨngantʉʉlaga ʉgwise nʉ nna. Ʉko ko kʉlɨfujula iisyʉ lya Kyala kʉ njɨla jaa kʉsikonga ɨnyiiho syɨnu. ");
INSERT INTO nyy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwe basyobi ʉmwe! Jeesaja aatalwisye ʉkʉkunguluka kʉmyɨnu, bo ikʉjoba ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Abandʉ aba, bikʉʉnyɨɨmɨka nɨ milomo itolo, looli ɨndumbula syabo silɨ kʉbʉtali na niine. ");
INSERT INTO nyy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bikʉʉnyiipuuta ʉne ɨsya itolo, paapo bikʉmanyisya ɨnyiiho ɨsya bandʉ ngatɨ sya Kyala.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Po Jesu alɨnkʉkɨkoolela ɨkɨlʉndɨlo kya bandʉ, alɨnkʉbabʉʉla alɨnkʉtɨ, “Amumbɨlɨkɨsye kanunu nʉ kʉsyagania! ");
INSERT INTO nyy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ɨfi fikwingɨla nkanwa, fikaja fyo ɨfi fikʉnnyasya ʉmundʉ. Looli fila fikʉsooka ʉkʉfuma nkanwa mmyake, fyo fikʉnnyasya.” ");
INSERT INTO nyy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Po abafundigwa baake balɨnkʉbʉʉka kwa Jesu, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, ʉmeenye ʉkʉtɨ aBafalisai bakaleele bo bapɨliike amasyʉ aga ʉbabʉʉlile?” ");
INSERT INTO nyy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesu alɨnkwamula alɨnkʉtɨ, “Kʉkʉtɨ mpiki ʉgʉ gʉkabyaligwa na Taata gwangʉ ʉgwa kʉmwanya gukʉnyukuligwa. ");
INSERT INTO nyy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Namubaleke, paapo abo balongosi bafwa maaso aba bikʉbalongosya abafwa maaso! Lɨnga ʉmfwa maaso ikʉnndongosya ʉmfwa maaso nnine, bobabɨɨlɨ bikʉgwɨla mbwina!” ");
INSERT INTO nyy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Looli Peeteli alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉtʉlɨngaanie ɨsi ʉjobile.” ");
INSERT INTO nyy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu alɨnkwamula alɨnkʉtɨ, “Bʉle, na nuumwe mukaja na mahala? ");
INSERT INTO nyy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bʉle, mukasyagania ʉkʉtɨ kʉkʉtɨ kandʉ aka kikwingɨla nkanwa, kikʉbʉʉka mbʉla, po piitaasi kikʉsooka kʉ liisʉ? ");
INSERT INTO nyy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Looli ɨsi sikʉsooka nkanwa, sikʉfuma mu ndumbula, syo ɨsi sikʉnnyasya ʉmundʉ. ");
INSERT INTO nyy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Paapo mu ndumbula jaa mundʉ, mo muno sikʉfuma ɨnyiinogono ɨmbiibi, ʉbʉgogi, ʉbʉlogwe, ʉbʉhɨɨji, ʉbʉkeeti bwa bʉtʉngʉlʉ na maheelu. ");
INSERT INTO nyy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ɨsyo syo ɨsi sikʉnnyasya ʉmundʉ. Looli ʉkʉlya kɨsita kʉsugusula kʉtikʉnnyasya ʉmundʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesu alɨnkʉsookapo pala, alɨnkʉbʉʉka nkiisʉ ɨkya mu Tili nɨ kya mu Sitoni. ");
INSERT INTO nyy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Po ʉnkiikʉlʉ jʉmo ʉNkaanaani ʉjʉ aatʉʉgalaga ʉko, alɨnkwisa kwa Jesu, aalaataga aatɨgɨ, “Gwe Ntwa, Mwana gwa malafyale Ndaabɨti, ʉlɨɨmbaakɨsya! Ʉmwanangʉ ʉndɨndwana akoliigwe nɨ mbepo ɨnyali.” ");
INSERT INTO nyy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Looli Jesu akaalyamwile iisyʉ nalɨmo. Po abafundigwa baake balɨnkwisa nʉ kʉnsʉʉma, balɨnkʉtɨ, “Ʉmmbʉʉle ʉnkiikʉlʉ ʉjʉ abʉʉkege, paapo ikʉjwega kʉnyuma kʉmyɨtʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Alɨnkʉbaamula alɨnkʉtɨ, “Kyala andʉmile kʉkʉbapoka aBanyaisilaɨli beene, aba balɨ bo ʉlwa ngʼoosi ɨsi sisobile.” ");
INSERT INTO nyy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ʉnkiikʉlʉ jʉla alɨnkwisa, alɨnkʉfugama nkyeni mwa Jesu, alɨnkʉnsʉʉma alɨnkʉtɨ, “Gwe Ntwa, ngʉkʉsʉʉma ʉndʉʉle!” ");
INSERT INTO nyy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Alɨnkʉmmwamula alɨnkʉtɨ, “Sikaja kanunu ʉkwega ɨfindʉ ɨfya baana nʉ kʉsisopela ɨmbwa.” ");
INSERT INTO nyy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ʉnkiikʉlʉ jʉla alɨnkʉtɨ, “Moomuumo, gwe Ntwa, leelo nɨ mbwa syope sikʉlya ʉtʉbululukɨsya ʉtʉ tukʉsatʉka paasi ʉkʉfuma pa meesa sya batwa baabo.” ");
INSERT INTO nyy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Po Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Gwe nkiikʉlʉ ʉgwe, ʉlwitɨko lwako lʉnywamu fiijo! Sikʉbombigwa ɨsi kʉlonda.” Nakalɨnga, ʉndɨndwana jʉla alɨnkʉbʉmbʉlʉka. ");
INSERT INTO nyy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesu alɨnkʉsookako ʉko, alɨnkwenda kʉmbalɨ kwa sʉmbɨ Galilai. Po alɨnkʉfyʉka nkyamba, alɨnkʉtʉʉgala ʉko. ");
INSERT INTO nyy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Abandʉ bingi fiijo balɨnkwisa kwa Jesu, balɨnkʉbatwala aba bikʉkwema, abafwa maaso, abalemale, aba batikʉjoba, na babine abangɨ bingi. Balɨnkʉbabɨɨka nkyeni mwa Jesu, alɨnkʉbabʉmbʉlʉsya. ");
INSERT INTO nyy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Abandʉ bala baaswigile fiijo bo bikʉbabona aba batikʉjoba bikʉjoba, abalemale na aba bikʉkwema bikwenda bo bagolwike, na bafwa maaso bikʉkeeta. Balɨnkʉntuufya Kyala gwa Banyaisilaɨli. ");
INSERT INTO nyy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Po Jesu alɨnkʉbabɨlɨkɨla abafundigwa baake, alɨnkʉbabʉʉla alɨnkʉtɨ, “Ngʉbapaakɨsya abandʉ aba, paapo amasikʉ matatʉ balɨndile na niine, lɨɨlɨno bakaja nɨ findʉ. Ngiigana ʉkʉbalaga, bo balɨ nɨ njala aabikʉfwa ʉlʉsɨ mu njɨla.” ");
INSERT INTO nyy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Abafundigwa baake balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Tʉfyage kʉʉgʉ ɨfindʉ pa lʉkʉbo apa ɨfya kwikʉta boosa?” ");
INSERT INTO nyy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Po Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mulɨ nafyo ɨfisyesye filɨnga?” Balɨnkʉmmwamula balɨnkʉtɨ, “Tʉlɨ nafyo fihaano na fibɨlɨ, nʉ tʉswɨ tʉnandɨ.” ");
INSERT INTO nyy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Po Jesu alɨnkʉbalagɨla abandʉ ʉkʉtɨ batʉʉgale paasi. ");
INSERT INTO nyy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Alɨnkwega ɨfisyesye ɨfyo fihaano na fibɨlɨ nʉ tʉswɨ tʉla, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉfimenyania, alɨnkʉbapapo abafundigwa baake, po abafundigwa balɨnkʉbajabɨla abandʉ bala. ");
INSERT INTO nyy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Abandʉ boosa balɨnkʉlya, balɨnkwikʉta. Po abafundigwa balɨnkʉbʉngaania ɨfi fyasyele, balɨnkwisʉsya ɨfiibo fihaano na fibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Abandʉ aba baaliile baalɨ banyambala 4,000 bʉno, kɨsita kʉbala abakiikʉlʉ na baana. ");
INSERT INTO nyy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesu bo abalagile abandʉ bala, alɨnkwingɨla mwi ibooti, alɨnkʉbʉʉka mu Magatani. ");
INSERT INTO nyy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Po aBafalisai na Basatukai bamo balɨnkwisa kwa Jesu, nʉ kʉnngela ʉkʉtɨ abombe ɨkiika ʉkʉja kɨmanyilo ʉkʉbanangɨsya ʉkʉtɨ atʉmiigwe na Kyala. ");
INSERT INTO nyy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Lɨnga amajolo gafikile, mukʉjoba mukʉtɨ, ‘Kɨlaabo bukʉkya kanunu paapo kʉ mpaalanga kwelu.’ ");
INSERT INTO nyy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Looli akabalɨlo akaa nʉlʉbʉnjʉ, mukʉjoba mukʉtɨ, ‘Lɨɨlɨno ɨfula jikʉtima paapo kʉ mpaalanga kʉtiitʉ, kangɨ kʉlɨ na mabɨngo.’ Po ʉmwe mumeenye ʉkʉfyagania ɨfimanyilo ɨfya mu mpaalanga, looli mukabagɨla ʉkʉfyagania ɨfimanyilo ɨfya kabalɨlo aka. ");
INSERT INTO nyy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ʉmwe mulɨ batʉlanongwa mukiigana ʉkʉmmanya Kyala, ʉkeetege mukʉsʉʉma ɨkɨmanyilo! Mutikʉpeeligwa ɨkɨmanyilo nakɨmo, looli kyene ɨkɨmanyilo ɨkya nkunguluka Joona.” Po Jesu alɨnkʉbaleka, alɨnkʉsookapo na bafundigwa baake. ");
INSERT INTO nyy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Abafundigwa baa Jesu bo balobwike ɨnyanja, balɨnkʉsyagania ʉkʉtɨ biibiibwe ʉkwega ɨfisyesye. ");
INSERT INTO nyy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mujege maaso nʉ nkese ʉgwa Bafalisai na Basatukai.” ");
INSERT INTO nyy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Abafundigwa bala balɨnkwanda ʉkʉjobesania balɨnkʉtɨ, “Ikʉjoba bo ʉlo paapo tʉkatwala ɨfisyesye.” ");
INSERT INTO nyy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesu alɨnkʉmanya ɨsi baajobaga, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mwe bandʉ baa lwitɨko ʉlʉnandɨ ʉmwe! Fiki mukʉkaanikana ʉkʉtɨ mukaja nɨ fisyesye? ");
INSERT INTO nyy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bʉle, mukaalɨ mutikʉsyagania? Bʉle, mukaalɨ mutikʉkʉmbʉka muno abandʉ bala 5,000, baaliikwite kʉ fisyesye fila fihaano? Bʉle, mwabʉngeenie ɨfiibo filɨnga ɨfya fimeenya? ");
INSERT INTO nyy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pamo ɨfisyesye fila fihaano na fibɨlɨ kʉ bandʉ bala 4,000, bʉle, mwabʉngeenie ɨfiibo filɨnga? ");
INSERT INTO nyy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Silɨ bʉleebʉle, mutikʉsyagania ʉkʉtɨ ngaajobaga ɨsya fisyesye? Po mujege maaso nʉ nkese ʉgwa Bafalisai na Basatukai.” ");
INSERT INTO nyy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Po abafundigwa baake balɨnkʉsyagania ʉkʉtɨ akaajobaga ɨsya nkese ʉgwa kʉtendekekesya ɨfisyesye, looli aabalaga ɨmanyisyo ɨsya Bafalisai na Basatukai. ");
INSERT INTO nyy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesu na bafundigwa baake, bo bafikile kʉ Kesalija Filipi, Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Abandʉ bikʉʉnjoba ʉne Nnyamundʉ ʉkʉtɨ ne ani?” ");
INSERT INTO nyy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Balɨnkʉmmwamula balɨnkʉtɨ, “Bamo bikʉtɨ gwe Johani ʉMoosi, abangɨ bikʉtɨ gwe nkunguluka Elija, na bangɨ bikʉtɨ ʉgwe gwe Jelemija, pamo jʉmo mbakunguluka abangɨ.” ");
INSERT INTO nyy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Po Jesu alɨnkʉbalaalʉʉsya abeene, alɨnkʉtɨ, “Na nuumwe mukʉtɨ, ʉne ne ani?” ");
INSERT INTO nyy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Po Simoni Peeteli alɨnkʉmmwamula alɨnkʉtɨ, “Ʉgwe gwe Meesija, ʉMpoki ʉjʉ Kyala aatile ikʉntʉma. Ʉgwe ʉlɨ Mwana gwa Kyala ʉMʉʉmi bwila na bwila.” ");
INSERT INTO nyy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Simoni mwana gwa Joona, gwe ʉsajiigwe, paapo akajako ʉmundʉ ʉjʉ akʉsetʉliile ɨsyo, looli jo Taata gwangʉ ʉgwa kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ʉne nikʉkʉbʉʉla, ʉgwe gwe Peeteli, ʉlwalabwe. Pamwanya pa lwalabwe ʉlʉ, ngʉjenga ɨkɨpanga kyangʉ ɨkya Kyala. Amaka agaa kʉ ngolongo gatiisakʉkɨtola sikʉ. ");
INSERT INTO nyy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ʉne ngʉkʉpapo ɨfungulo ɨsya Bʉnyafyale bwa kʉmwanya, ʉkʉtɨ lyolyosa ɨlɨ kʉlɨpinya pakiisʉ, Kyala joope bo alɨpinyile kʉmwanya. Kangɨ lyolyosa ɨlɨ kʉlyabʉla pakiisʉ, Kyala joope bo alyabwile kʉmwanya.” ");
INSERT INTO nyy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Po Jesu alɨnkʉbasoka abafundigwa baake ʉkʉtɨ balɨngammbʉʉlaga ʉmundʉ najʉmo, ʉkʉtɨ ʉmwene jo Meesija. ");
INSERT INTO nyy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ʉkwandɨla akabalɨlo ako, Jesu alɨnkwanda ʉkʉbabʉʉla abafundigwa baake pabwelu, alɨnkʉtɨ, “Mpaka mbʉʉke mu Jelusalemu nʉ kʉkaba ɨngʉbɨlo nyingi kʉ balongosi baa Bajuuta, abapuuti abalongosi, na bamanyisi baa ndagɨlo sya Moose, mpaka ʉkʉgogigwa. Po pi isikʉ lya bʉtatʉ, ngwisa kʉsyʉka.” ");
INSERT INTO nyy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Po Peeteli alɨnkʉmmwega kʉmbalɨ, alɨnkwanda ʉkʉnkemela, alɨnkʉtɨ, “Gwe Ntwa, silɨngaja bo ʉlo! Ɨsyo sitikʉkwaga ʉgwe!” ");
INSERT INTO nyy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Looli Jesu alɨnkʉnsanuka, alɨnkʉmmbʉʉla Peeteli alɨnkʉtɨ, “Kɨnda kʉnyuma kʉmyangʉ, ʉgwe Seetano! Kʉgela ʉkʉʉsigɨla ʉkʉbomba ʉbwigane bwa Kyala! Ʉtikʉsiinogona ɨsya Kyala, looli ɨsya bandʉ!” ");
INSERT INTO nyy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Po Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Ʉmundʉ gwesa ʉjʉ ikʉlonda ʉkʉngonga, jo fikʉtɨ alɨngiipaakɨsyaga na panandɨ, nalɨnga aikʉgogigwa pa kɨkohekano kʉnongwa jangʉ, angongege. ");
INSERT INTO nyy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ʉjʉ lɨnga ikʉlonda ʉkʉbʉponesya ʉbʉʉmi bwake, ikʉbʉpeesyaga ʉbʉʉmi bwa bwila na bwila. Looli ʉmundʉ ʉjʉ atikʉpaasya ʉkʉfwa kʉnongwa jangʉ, jo ikʉbʉkabaga ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Eemwa, kalɨ ʉmundʉ fikʉmmbʉmbʉlɨla ɨfiki ʉkʉkɨkaba ɨkyʉma kyosa ɨkya nkiisʉ, looli ikʉbʉpeesya ʉbʉʉmi bwa bwila na bwila? Pamo ʉmundʉ abagiile ʉkʉsoosya ɨfiki pabʉjo bwa bʉʉmi bwa bwila na bwila? ");
INSERT INTO nyy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ʉne Nnyamundʉ ngwisa kwisa pamopeene na bandʉmi bangʉ, mbʉsisya bwa Taata. Po ngwisa kʉnhomba kʉkʉtɨ mundʉ ʉkʉkongana nɨ mbombo syake. ");
INSERT INTO nyy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nalooli nikʉbabʉʉla, balipo bamo papaapa aba batikʉfwa mpaka taasi baambone ne Nnyamundʉ, bo ngwisa mBʉnyafyale bwangʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Amasikʉ ntandatʉ bo gakɨndile, Jesu alɨnkʉbeega baa Peeteli, Jaakobo na Johani ʉnnuguna gwa Jaakobo. Alɨnkʉfyʉka nabo pamwanya pa kyamba ɨkɨtali fiijo, po alɨnkwijeekela nabo kʉla. ");
INSERT INTO nyy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bo balɨ kʉla, Jesu alɨnkwandʉka ʉmbɨlɨ nkyeni mmyabo. Kʉmaaso kʉlɨnkʉlangala ʉlwa isʉba, nɨ myenda gyake gyalɨ myelu fiijo bo ʉndangalɨla gwa isʉba. ");
INSERT INTO nyy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nakalɨnga, balɨnkʉsetʉka abakunguluka Moose na Elija, baajobaga nagwe. ");
INSERT INTO nyy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Po Peeteli alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Gwe Ntwa, kanunu ʉswe ʉkʉjapo apa. Lɨnga kʉlonda, ngʉjenga ɨfitembe fitatʉ. Kɨmo kɨje kyako, ɨkɨngɨ kya Moose, nɨ kɨngɨ kɨje kya Elija.” ");
INSERT INTO nyy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peeteli bo akaalɨ ikʉjoba, keeta, iibɨngo ɨlɨ likʉlangala lɨlɨnkʉbakupɨkɨla. Po balɨnkʉpɨlɨka iisyʉ ʉkʉfuma mwi ibɨngo likʉtɨ, “Ʉjʉ jo Mwanangʉ ʉNkʉndwe ʉjʉ niikyeliile nagwe, mumpɨlɨkɨsyege!” ");
INSERT INTO nyy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Abafundigwa baake bo bapɨliike ɨsyo, balɨnkʉtiila fiijo, balɨnkʉgwa bʉkupama paasi nʉ lʉtende. ");
INSERT INTO nyy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesu alɨnkʉsegelela kɨfuki, alɨnkʉbapalamaasya, alɨnkʉbabʉʉla alɨnkʉtɨ, “Namusumuke, mulɨngatiilaga!” ");
INSERT INTO nyy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bo biinwile amaaso gaabo, balɨnkʉmmbona Jesu asyele mwene. ");
INSERT INTO nyy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Po bo bikʉsuluka ʉkʉfuma nkyamba, Jesu alɨnkʉbalagɨla alɨnkʉtɨ, “Mulɨngammbʉʉlaga ʉmundʉ najʉmo ɨsi musibwene mpaka akabalɨlo aka Nnyamundʉ ikwisa kʉsyʉka ʉkʉfuma mbafwe.” ");
INSERT INTO nyy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abafundigwa balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Keeta, abamanyisi baa ndagɨlo sya Moose bikʉtɨ Elija jo ikʉtalapo taasi ʉkwisa, bo Meesija akaalɨ?” ");
INSERT INTO nyy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Nalooli Elija jo ikʉtala ʉkwisa, ʉkʉtɨ atendekesye syosa. ");
INSERT INTO nyy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Looli nikʉbabʉʉla nikʉtɨ, Elija iisile, abandʉ bakaalɨmmeenye, baalɨmmbombiile ɨmbiibi syosa ɨsi baalondaga. Bʉbʉʉbo Nnyamundʉ bikwakʉmmbombela kabiibi.” ");
INSERT INTO nyy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Po abafundigwa bala balɨnkʉsyagania ʉkʉtɨ Jesu aajobaga ɨsya Johani ʉMoosi. ");
INSERT INTO nyy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Po paapo Jesu na bafundigwa bala batatʉ bo bafikile pa kɨlʉndɨlo kɨla kya bandʉ, ʉmundʉ jʉmo alɨnkwisa kwa Jesu, alɨnkʉfugama nkyeni mmyake, ");
INSERT INTO nyy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwe Ntwa, ngʉsʉʉma ʉmpaakɨsye ʉmwanangʉ paapo alɨ ni inyiki, ʉbʉbine ʉbo bukʉntaamya fiijo. Kaa kingi ikʉgwa mmooto na mmɨɨsi. ");
INSERT INTO nyy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Naalɨntwele kʉ bafundigwa baako ʉkʉtɨ bammbʉmbʉlʉsye, leelo batoliigwe.” ");
INSERT INTO nyy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mwe bandʉ baa nkabalɨlo aka, mwe mukaja nʉ lwitɨko ʉmwe! Moonangiike! Bʉle, ngʉtʉʉgala pamopeene na nuumwe nʉ kʉbakeetelela mpaka ndɨli? Namuntwale kʉno kʉmyangʉ!” ");
INSERT INTO nyy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Po Jesu alɨnkʉjɨkemela ɨmbepo ɨnyali ɨjɨ jaalɨ nkatɨ mmyake, jɨlɨnkʉsookamo. Nakalɨnga, ʉmwana jʉla alɨnkʉbʉmbʉlʉka. ");
INSERT INTO nyy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Po abafundigwa balɨnkʉmmwisɨla Jesu pabʉjo ʉbwa kwijeekela, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Fiki ʉswe tʉtoliigwe ʉkʉjɨkaga ɨmbepo ɨnyali jɨla?” ");
INSERT INTO nyy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Alɨnkʉbaamula alɨnkʉtɨ, “Kʉnongwa jaa lwitɨko lwɨnu lʉnandɨ. Nalooli nikʉbabʉʉla, lɨnga mulɨ nʉ lwitɨko ʉlʉniini bo ʉlwa kaseke akaa mutaka, mwabagiile ʉkʉkɨbʉʉla ɨkyamba ɨkɨ ʉkʉtɨ, ‘Sookapo apa, ʉbʉʉke pala,’ kyope kikʉsookapo. Aakatikʉjako akandʉ akaa kʉbatola.  ");
INSERT INTO nyy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pamopeene na ɨsyo, ɨmbepo ɨnyali ɨjaa lʉko ʉlo jɨtikʉsooka, looli kʉ njɨla jaa kʉnsʉʉma Kyala nʉ kʉfipɨɨka ɨfindʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesu bo alɨ pamopeene na bafundigwa baake mu Galilai, alɨnkʉbabʉʉla alɨnkʉtɨ, “Ne Nnyamundʉ ngwisa kʉbɨɨkigwa mmaboko agaa balʉgʉ. Bikwisa kʉʉngoga, looli pi isikʉ lya bʉtatʉ, ngwisa kʉsyʉka.” ");
INSERT INTO nyy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Abafundigwa baake balɨnkʉsulumania fiijo. ");
INSERT INTO nyy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesu na bafundigwa baake bo bafikile mu Kapelinaʉmu, abasongesya songo jaa tempeli balɨnkwisa kwa Peeteli. Balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, ʉmmanyisi gwɨnu joope ikʉsonga ɨsongo jaa tempeli?” ");
INSERT INTO nyy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peeteli alɨnkʉbaamula alɨnkʉtɨ, “Moomuumo, ikʉsonga.” Peeteli bo ingiile nnyumba, Jesu alɨnkwanda ʉkʉnndaalʉʉsya alɨnkʉtɨ, “Gwe Peeteli, ʉgwe kʉsyagania bʉleebʉle? Abanyafyale nkiisʉ ɨkɨ bikʉsongesya ɨsongo kʉ bandʉ nki? Kʉ bandʉ baa mfiisʉ fyabo, pamo kwene kʉ baheesya?” ");
INSERT INTO nyy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peeteli alɨnkwamula alɨnkʉtɨ, “Bikʉsongesya kwene kʉ baheesya.” Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Lɨnga silɨ bo ʉlo, po abenekaaja batikʉhomba ɨsongo. ");
INSERT INTO nyy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Looli ʉkʉtɨ tʉlɨngabakalasya, bʉʉka ʉkasope ʉlʉsambo mu nyanja. Ʉkeege ɨɨswɨ ɨjaa kwanda ɨjɨ kwakʉsipʉla, ʉkajɨkahʉle nkanwa, kwakʉlwaga ʉlʉtalama nkatɨ. Ʉkeege ʉlʉtalama ʉlo ʉkasonge ɨsongo jangʉ nɨ jaako.” ");
INSERT INTO nyy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Akabalɨlo kamo abafundigwa baa Jesu balɨnkwisa kwa Jesu, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Jo jwani nkʉlʉmba ʉkʉkɨnda abangɨ boosa mBʉnyafyale bwa kʉmwanya?” ");
INSERT INTO nyy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesu alɨnkʉnkoolela ʉmwanike, alɨnkʉmmbɨɨka pakatɨ pamyabo, ");
INSERT INTO nyy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, lɨnga mutikʉpɨndʉka nʉ kʉja bo abaanike, mutikwisa kwingɨla sikʉ mBʉnyafyale bwa kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Po ʉmundʉ gwesa ʉjʉ ikwijiisya bo ʉmwanike ʉjʉ, ʉjo jo nkʉlʉmba mBʉnyafyale bwa kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kangɨ ʉmundʉ gwesa ʉjʉ mu ngamu jangʉ ikʉmmwambɨlɨla ʉmwanike bo ʉjʉ, ikʉʉnyambɨlɨla ʉne.” ");
INSERT INTO nyy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Looli lɨnga kʉnsobesya jʉmo mbaanike abo aba bikʉʉnyiitɨka ʉne, ngalɨ kʉnunu ʉkʉkʉpinya ʉgwe ʉlwala mmakosi nʉ kʉsopigwa mu nyanja. ");
INSERT INTO nyy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ahɨɨli mwe bandʉ baa nkiisʉ muno, kʉnongwa jaa kʉbomba ɨsi sikʉbasobesya abandʉ! Ɨngelo syo fikʉtɨ sijengepo, looli ahɨɨli ʉmundʉ ʉjʉ ikʉsitwala ɨngelo ɨsyo! ");
INSERT INTO nyy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Lɨnga ɨkɨboko kyako pamo ɨkɨlʉndɨ kyako kikʉkʉsofya ʉkʉtʉla ɨnongwa, kɨtumule nʉ kʉkɨsopa pabʉtali na nungwe! Kʉnunu ʉkwingɨla mbʉʉmi bwa bwila na bwila, bo ʉlɨ nɨ kɨlema, ʉkʉkɨnda ʉkʉja na maboko mabɨlɨ pamo amalʉndɨ mabɨlɨ, leelo ʉsopigwe mmooto ʉgwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nɨ kɨsige kyako lɨnga kikʉkʉsofya, kɨfyʉle nʉ kʉkɨtaaga pabʉtali na nungwe! Kʉnunu ʉkwingɨla mbʉʉmi bwa bwila na bwila, bo ʉlɨ nɨ kɨsige kɨmo, ʉkʉkɨnda ʉkʉja nɨ fisige fyofibɨɨlɨ, leelo ʉsopigwe ndʉpanga lwa mooto.” ");
INSERT INTO nyy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mujege maaso, mulɨngammwilaamwaga jʉmo mbaanike abo! Nikʉbabʉʉla nikʉtɨ, boope balɨ na bandʉmi baabo abaa kʉmwanya, akabalɨlo koosa balɨ nkyeni mwa Taata gwangʉ ʉgwa kʉmwanya.  ");
INSERT INTO nyy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Paapo Nnyamundʉ aaliisile nkiisʉ ʉkʉtɨ abapoke aba basobile. ");
INSERT INTO nyy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Bʉle, ʉmwe mukʉtɨ fiki? Ʉmundʉ ʉjʉ alɨ nɨ ngʼoosi ɨmia jɨmo, lɨnga jɨmo jɨsobile, ikʉbomba bʉleebʉle? Bʉle, atikʉsileka ɨngʼoosi 99 ndiisʉ, ʉkʉtɨ akajɨlonde ɨjɨ jɨsobile? ");
INSERT INTO nyy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nalooli nikʉbabʉʉla, lɨnga ajaagile, ikʉhoboka fiijo kʉnongwa jaa ngʼoosi jɨla jɨmo ʉkʉkɨnda ɨngʼoosi sila 99 ɨsi sikasoba. ");
INSERT INTO nyy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bʉbʉʉbo ʉGwiseemwe ʉgwa kʉmwanya akiigana ʉkʉtɨ jʉmo mmbandʉ baa paasi aba asobe.” ");
INSERT INTO nyy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Lɨnga ʉmwitɨki ʉnnino akʉtʉliile ɨnongwa, bʉʉka ʉnsoke bo mulɨ babɨlɨ itolo. Lɨnga akʉpɨliike, bo ʉmmwagile kangɨ ʉmwitɨki nnino. ");
INSERT INTO nyy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Looli lɨnga akakʉpɨlɨka, bʉʉka ʉmmwege ʉmundʉ ʉjʉngɨ jʉmo pamo babɨlɨ, ʉkʉtɨ mukonge ɨsya mwa Kalata ʉMwikemo ɨsi sikʉtɨ, ‘Bajepo abakeeti babɨlɨ pamo batatʉ abaa kʉsisimɨkɨsya kʉkʉtɨ kandʉ.’ ");
INSERT INTO nyy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Lɨnga akabapɨlɨka abo boope, bʉʉka kʉkʉkɨbʉʉla ɨkɨpanga kya Kyala. Lɨnga akakɨpɨlɨka nɨ kɨpanga, po munkeetege bo ʉmundʉ ʉmpanja, pamo bo ʉnsongesya songo.” ");
INSERT INTO nyy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nalooli nikʉbabʉʉla, syosa ɨsi mukʉsipinya pakiisʉ, Kyala joope bo asipinyile kʉmwanya. Kangɨ syosa ɨsi mukʉsyabʉla pakiisʉ, Kyala joope bo asyabwile kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nikʉbabʉʉla kangɨ ʉkʉtɨ, lɨnga babɨlɨ pakatɨ pamyɨnu biitɨkeene pakiisʉ ndɨ syosa ɨsi bikʉsʉʉma, Taata gwangʉ ʉgwa kʉmwanya ikʉbabombela. ");
INSERT INTO nyy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Paapo apa babʉngeene abandʉ babɨlɨ pamo batatʉ mu ngamu jangʉ, niine ngʉjapo pamopeene nabo.” ");
INSERT INTO nyy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Po Peeteli alɨnkʉbʉʉka kwa Jesu, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Gwe Ntwa, lɨnga ʉmwitɨki mwinangʉ aandɨgile, ngʉlondigwa nʉnhobokele kalɨnga? Bʉle, nalɨnga kahaano na kabɨlɨ?” ");
INSERT INTO nyy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ndikʉkʉbʉʉla ʉkʉtɨ kahaano na kabɨlɨ itolo, looli ʉnhobokelege ʉnnino akabalɨlo koosa mbʉʉmi bwako kɨsita kʉbala. ");
INSERT INTO nyy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kʉnongwa ɨjo, ʉkwisa kwa Bʉnyafyale bwa kʉmwanya kʉfwene bo ɨkɨfwanikɨsyo ɨkɨ. Aaliko ʉmalafyale jʉmo, ʉjʉ aalondaga ʉkwega ɨndalama syake ɨsi aamelaga mbabombeli baake. ");
INSERT INTO nyy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ʉmalafyale bo andile ʉkʉbala, aatwaliigwe ʉmundʉ jʉmo nkyeni mmyake, ʉjʉ aameleligwaga ɨtalanta 10,000. ");
INSERT INTO nyy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ʉmbombeli ʉjo aatoliigwe ʉkʉhomba ɨndalama ɨsi aameleligwaga. Po ʉmalafyale alɨnkʉbalagɨla ʉkʉtɨ ʉʉlɨsigwe pamopeene nʉ nkasi, abaanaake, nʉ tʉndʉ toosa ʉtʉ alɨ nato, ʉkʉtɨ ahombe. ");
INSERT INTO nyy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Po ʉmbombeli jʉla alɨnkʉfugama nkyeni mmalafyale, alɨnkʉnsʉʉma alɨnkʉtɨ, ‘Ngʉsʉʉma ʉʉnguulɨlepo panandɨ, ngʉkʉhomba ʉtʉndʉ twako toosa.’ ");
INSERT INTO nyy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ʉmalafyale jʉla alɨnkʉmpelela ɨkɨsa, alɨnkʉnhobokela, alɨnkʉmmwitɨkɨsya ʉkʉtɨ abʉʉkege. ");
INSERT INTO nyy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Bo asookile panja, alɨnkwaganila nʉ mbombeli ʉnnine ʉjʉ aalɨnkopiisye ɨndenali ɨmia jɨmo itolo. Nakalɨnga alɨnkʉmpiita mmakosi, alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Homba ɨfi naakʉkopiisye.’ ");
INSERT INTO nyy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ʉnnine jʉla alɨnkʉfugama nkyeni mmyake, alɨnkʉnsʉʉma alɨnkʉtɨ, ‘Ngʉsʉʉma ʉʉnguulɨlepo panandɨ, ngʉkʉhomba ʉtʉndʉ twako toosa.’ ");
INSERT INTO nyy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Looli ʉmwene alɨnkʉkaana, alɨnkʉbʉʉka kʉkʉmpinya ʉmwinaake jʉla mu nnyololo, mpaka akabalɨlo aka ikwisa kʉhomba ʉtʉndʉ toosa. ");
INSERT INTO nyy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ababombeli banine bo basibwene ɨsi sibombiigwe, baasulumeenie fiijo mu ndumbula syabo. Po balɨnkʉbʉʉka kʉ malafyale gwabo nʉ kʉnndɨngaania syosa ɨsi sibombiigwe. ");
INSERT INTO nyy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Po ʉmalafyale alɨnkʉnkoolela ʉmbombeli gwake jʉla, alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Gwe mbombeli mbiibi ʉgwe! Keeta! Bo gʉʉsʉʉmile ʉkʉtɨ ngʉhobokele ɨfi naakʉmelelaga, ngʉhobokiile fyosa! ");
INSERT INTO nyy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bʉle, nungwe ʉtikʉlondigwa ʉkʉja nɨ kɨbabɨɨlɨsi kʉ nnino jʉla, bo muno ʉne ngʉbombiile ʉgwe?’ ");
INSERT INTO nyy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Po ʉmalafyale jʉla alɨnkʉkalala fiijo, alɨnkʉbalagɨla abasikali baake ʉkʉtɨ bankole nʉ kʉntaaga mu nnyololo mpaka akabalɨlo aka ikwisa kʉhomba ʉtʉndʉ toosa.” ");
INSERT INTO nyy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Po Jesu alɨnkʉtɨ, “Taata gwangʉ ʉgwa kʉmwanya ikwisa kʉbabombela ʉmwe bo lʉlʉʉlo, lɨnga mutikʉbahobokela abiitɨki biinɨɨnu nɨ ndumbula jɨɨnu joosa.” ");
INSERT INTO nyy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesu bo amalile ʉkʉjoba amasyʉ ago, alɨnkʉsookamo mu Galilai, alɨnkʉbʉʉka nkiisʉ kya Jutai, kwi isɨɨlya ɨlya lwɨsi Jolitani. ");
INSERT INTO nyy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Po abandʉ bingi balɨnkʉnkonga ʉko, alɨnkʉbabʉmbʉlʉsya ababine boosa. ");
INSERT INTO nyy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Po aBafalisai bamo balɨnkʉmmbʉʉkɨla Jesu ʉkʉtɨ bantege, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, ʉlʉlagɨlo lwɨtʉ lukwitɨkɨsya ʉkʉtɨ ʉnnyambala ansoosyege ʉnkasi kʉnongwa jojoosa jɨla?” ");
INSERT INTO nyy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu alɨnkwamula alɨnkʉtɨ, “Bʉle, mukabalamo mwa Kalata ʉMwikemo ʉkʉtɨ kʉbwandɨlo, ‘Kyala aabapelile ʉnnyambala nʉ nkiikʉlʉ?’ ");
INSERT INTO nyy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kangɨ Kyala aatile, ‘Kʉnongwa ɨjo ʉnnyambala ikʉnndeka ʉgwise nʉ nna, ikʉmmʉʉmɨɨlɨlaga ʉnkasi, bobabɨɨlɨ bikʉjaga mbɨlɨ gʉmogwene.’ ");
INSERT INTO nyy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Po nikʉbabʉʉla nikʉtɨ, batikʉja babɨlɨ kangɨ, looli mbɨlɨ gʉmogwene. Po leelo aka akakʉngɨseenie Kyala, ʉmundʉ alɨngakapaagʉlaniaga.” ");
INSERT INTO nyy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ABafalisai bala balɨnkʉnndaalʉʉsya kangɨ balɨnkʉtɨ, “Moose aalagiile ʉkʉtɨ ʉnnyambala abagiile ʉkʉnndeka ʉnkasi lɨnga asimbile kalata ʉgwa kʉnsoosya. Fiki aabombile bo ʉlo?” ");
INSERT INTO nyy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Moose aabiitɨkiisye ʉkʉtɨ mubalekege abakasi bɨɨnu kʉnongwa jaa bʉkafu bwa ndumbula syɨnu, looli ʉkʉfuma kʉbwandɨlo sikaalɨ bo ʉlo. ");
INSERT INTO nyy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Looli ʉne nikʉbabʉʉla nikʉtɨ, ʉmundʉ gwesa ʉjʉ anndekile ʉnkasi, bo akankola mbʉlogwe, nʉ kwega ʉnkiikʉlʉ ʉjʉngɨ, ikʉlogwa.” ");
INSERT INTO nyy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Po abafundigwa baake balɨnkʉmmbʉʉla balɨnkʉtɨ, “Lɨnga silɨ bo ʉlo kʉ mundʉ nʉ nkasi, po kanunu ʉkʉsita kwega!” ");
INSERT INTO nyy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Abandʉ boosa bakabagɨla ʉkʉlyambɨlɨla iisyʉ ɨlɨ, looli beene aba Kyala ikʉbatʉʉla ʉkʉlyambɨlɨla. ");
INSERT INTO nyy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Silipo nyingi ɨsi sikʉpela abandʉ ʉkʉsita kwega. Bamo bakabagɨla ʉkwega kʉnongwa jaa kʉtɨ baapaapiigwe bafule. Bamo batikwega paapo abandʉ babafulile. Balipo abangɨ aba batikwega ʉkʉtɨ babwijʉʉlɨlege ʉBʉnyafyale bwa kʉmwanya. Ʉjʉ abagiile ʉkʉlyambɨlɨla iisyʉ ɨlɨ, alyambɨlɨle.” ");
INSERT INTO nyy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Abandʉ bamo balɨnkʉbatwala abaana abaniini kwa Jesu ʉkʉtɨ ababɨɨkepo amaboko pamwanya pamyabo, nʉ kʉbasaja. Leelo abafundigwa baake balɨnkʉbakemela abandʉ bala. ");
INSERT INTO nyy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Looli Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Namubaleke abaana abaniini biisege kʉmyangʉ, mulɨngabasigɨlaga, paapo ʉBʉnyafyale bwa kʉmwanya bwa bandʉ aba balɨ bo abaana aba.” ");
INSERT INTO nyy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Po Jesu alɨnkʉbɨɨkapo amaboko gaake pamwanya pamyabo, alɨnkʉbasaja, alɨnkʉsookapo pala. ");
INSERT INTO nyy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Po ʉndʉmyana jʉmo alɨnkwisa kwa Jesu, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Gwe Mmanyisi, mbombe ɨnunu silɨkʉ ʉkʉtɨ ngabe ʉbʉʉmi bwa bwila na bwila?” ");
INSERT INTO nyy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Fiki kʉʉndaalʉʉsya ʉne ɨsya bʉnunu? Keeta, Kyala mwene jo nnunu! Looli lɨnga kʉlonda ʉkʉkaba ʉbʉʉmi bwa bwila na bwila, ʉsikongege ɨndagɨlo sya Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ʉndʉmyana jʉla alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Ɨndagɨlo silɨkʉ?” Po Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉlɨngagogaga, ʉlɨngalogwaga, ʉlɨngahɨɨjaga, ʉlɨngajaga nkeeti gwa bʉtʉngʉlʉ, ");
INSERT INTO nyy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ʉmmwɨmɨkege ʉgʉʉso nʉ nyoko,” kangɨ, “Ʉbaganege abanino bo ʉlʉ gwijiiganile ʉgwe.” ");
INSERT INTO nyy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ʉndʉmyana jʉla alɨnkʉtɨ, “Ɨndagɨlo syosa ɨsyo nsikolile. Mbombe ɨfiki kangɨ ɨfi naagiilwe?” ");
INSERT INTO nyy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Lɨnga kʉlonda ʉkʉja mundʉ ʉnsita kwagɨlwa, bʉʉka ʉkʉʉlɨsye ʉtʉndʉ toosa ʉtʉ ʉlɨ nato, ɨndalama ɨsyo ʉbajabɨle abalondo. Lɨnga ʉbombile bo ʉlo, bo gwibɨɨkiile ɨkyʉma kʉmwanya. Po gwise gʉngongege.” ");
INSERT INTO nyy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Po ʉndʉmyana jʉla bo apɨliike ɨsyo, alɨnkʉsookapo kʉ bʉsulumanie paapo aalɨ nɨ kyʉma ɨkingi fiijo. ");
INSERT INTO nyy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Po Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, kʉpala fiijo ʉnkabi ʉkwingɨla mBʉnyafyale bwa kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nikʉbabʉʉla kangɨ ʉkʉtɨ, ɨngamila ʉkwingɨla mbwasi bwa sindaano kʉpepe, ʉkʉkɨnda ʉnkabi ʉkwingɨla mBʉnyafyale bwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Abafundigwa bala bo bapɨliike ɨsyo, balɨnkʉswiga fiijo, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Po jo jwani ʉjʉ abagiile ʉkʉpokigwa?” ");
INSERT INTO nyy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesu alɨnkʉbakeeta fiijo, alɨnkʉtɨ, “Kʉ bandʉ sikabagɨla, looli kwa Kyala syosa sibagiile.” ");
INSERT INTO nyy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peeteli alɨnkʉmmbʉʉla alɨnkʉtɨ, “Keeta, ʉswe tʉfilekile fyosa, tʉkʉkongile ʉgwe! Aatukʉkabamo ɨfiki?” ");
INSERT INTO nyy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, bo ʉne Nnyamundʉ ndɨ Malafyale gwa kiisʉ ɨkɨpya ɨkya Kyala, angʉtʉʉgalaga pa kɨkota kyangʉ ɨkya bʉtwa. Kangɨ ʉmwe nuumwe mwe mungongile ʉne, aamukʉtʉʉgalaga pa fikota fya bʉtwa kalongo na fibɨlɨ, ʉkʉtɨ mufilonge ɨfikolo kalongo na fibɨlɨ ɨfya Isilaɨli. ");
INSERT INTO nyy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Po ʉmundʉ gwesa ʉjʉ ajɨlekile ɨnyumba, pamo abakamu, pamo ʉgwise, pamo ʉnna, pamo abaanaake, pamo ɨmigʉnda, kʉnongwa jangʉ, ikwisa kwambɨlɨla kʉ bwingi ʉkʉkɨndapo. Po ikwisa kʉkaba ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Looli bingi aba bikwibona ʉkʉtɨ aabikʉjaga baa kwanda akabalɨlo ako, bikʉjaga baa kʉmmalɨɨkɨsyo. Looli aba bikwibona ʉkʉtɨ aabikʉjaga baa kʉmmalɨɨkɨsyo, bikʉjaga baa kwanda.” ");
INSERT INTO nyy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Po ʉBʉnyafyale bwa kʉmwanya, aabukwisa bo ʉlwa kɨfwanikɨsyo ɨkɨ. Aaliko ʉmwene ngʉnda jʉmo, ʉjʉ aalaabiile nʉlʉbʉnjʉ fiijo kʉkʉbalonda abaa kʉbomba ɨmbombo mu ngʉnda gwake. ");
INSERT INTO nyy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ʉmwene ngʉnda bo abaagile, alɨnkwitɨkana nabo ʉkʉnhomba kʉkʉtɨ mundʉ ʉmfwalo gwa isikʉ lɨmo, po alɨnkʉbatʉma mu ngʉnda gwake. ");
INSERT INTO nyy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Alɨnkʉsookapo pa ngʉnda bo jɨfikile ɨsala jaa 3:00 nʉlʉbʉnjʉ, alɨnkʉbʉʉka kʉ sokoni, alɨnkʉbaaga abandʉ abangɨ bɨɨmile kɨsita mbombo. ");
INSERT INTO nyy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Alɨnkʉbabʉʉla alɨnkʉtɨ, ‘Na nuumwe mubʉʉke kʉkʉbomba ɨmbombo mu ngʉnda gwangʉ. Ʉne ngwisa kʉkʉbahomba mwesa bo muno sikʉlondeligwa.’ ");
INSERT INTO nyy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Abandʉ bala balɨnkʉbʉʉka. Po bo iisʉba lɨlɨ pantʉ alɨnkʉbatʉma abandʉ abangɨ mu ngʉnda gwake, kangɨ abangɨ mwi ilʉndʉko. ");
INSERT INTO nyy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Namajolo, alɨnkʉsookapo pa ngʉnda kangɨ, alɨnkʉbabona abandʉ abangɨ aba bɨɨmile paa sokoni. Alɨnkʉbalaalʉʉsya alɨnkʉtɨ, ‘Fiki mwɨmile apa iisikʉ lyosa kɨsita mbombo?’ ");
INSERT INTO nyy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Boope balɨnkʉmmwamula balɨnkʉtɨ, ‘Akajapo ʉmundʉ ʉjʉ atʉpeelepo ɨmbombo.’ Alɨnkʉbabʉʉla alɨnkʉtɨ, ‘Na nuumwe namubʉʉke kʉkʉbomba ɨmbombo mu ngʉnda gwangʉ.’ ");
INSERT INTO nyy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Bo bwilile, ʉmwene ngʉnda alɨnkʉmmbʉʉla ʉjʉ ikwɨmɨlɨla ɨmbombo jaake alɨnkʉtɨ, ‘Bakoolele ababombi boosa ʉkʉtɨ ʉbahombe ʉmfwalo gwabo, gwandege ʉkʉbahomba ababombi aba biisile kʉmmalɨɨkɨsyo, ʉmalɨɨkɨsye abaa kʉbwandɨlo.’ ");
INSERT INTO nyy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Po ababombi bala aba baaliisile namajolo, balɨnkwambɨlɨla ɨndalama ɨsya kʉfwana ʉmfwalo gwa isikʉ lɨmo. ");
INSERT INTO nyy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ababombi bala aba baalyandeene ʉkʉfika mu ngʉnda, baasʉʉbɨlaga ʉkʉhombigwa ʉkʉbakɨndapo abiinaabo aba baaliisile namajolo. Leelo kʉkʉtɨ mundʉ aahombiigwe ʉmfwalo gʉlagʉla ʉgwa isikʉ lɨmo. ");
INSERT INTO nyy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Po bo bambɨliile, balɨnkwanda ʉkʉʉmana nʉ mwene ngʉnda balɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Abandʉ bala babombile ɨmbombo kʉ sala jɨmojeene itolo, silɨ bʉleebʉle ʉtʉpeele ʉmfwalo bo ʉgʉ ʉbapeele? Ʉswe tʉjɨbombile ɨmbombo ɨngafu fiijo nʉ lʉmu loosa.’ ");
INSERT INTO nyy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ʉmwene ngʉnda jʉla alɨnkʉmmwamula jʉmo mmbandʉ bala alɨnkʉtɨ, ‘Mmanyaani, ngakʉsyoba nafimo. Bʉle, tʉkiitɨkana ʉkʉtɨ kʉbomba ɨmbombo ɨjaa mfwalo gwa isikʉ lɨmo? ");
INSERT INTO nyy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ega ɨndalama jaako ɨjɨ, sookapo apa! Ʉne niiganile ʉkʉmpapo ʉmundʉ ʉjʉ ʉgwa kʉmmalɨɨkɨsyo, ʉmfwalo ʉgʉ gʉfwene nʉ gwako. ");
INSERT INTO nyy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bʉle, ndikwitɨkɨsigwa nɨ ndagɨlo ʉkʉbombela ʉtʉndʉ twangʉ bo muno niiganiile? Pamo ʉlɨ nʉ bʉʉfi, paapo ndɨ mooloolo fiijo kʉ bangɨ?’ ” ");
INSERT INTO nyy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesu alɨnkʉjoba kangɨ alɨnkʉtɨ, “Po bo bʉbʉʉbo, abandʉ abaa kʉmmalɨɨkɨsyo bikʉjaga baa kwanda, na baa kwanda bikʉjaga baa kʉmmalɨɨkɨsyo.” ");
INSERT INTO nyy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesu bo alɨ mu njɨla ikʉfyʉka ʉkʉbʉʉka mu Jelusalemu, alɨnkʉbeega pambalɨ abafundigwa baake kalongo na babɨlɨ, alɨnkʉbabʉʉla alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Keeta, tukʉfyʉka ʉkʉbʉʉka mu Jelusalemu. Ʉne Nnyamundʉ ngwakʉbɨɨkigwa mmaboko agaa bapuuti abalongosi na bamanyisi baa ndagɨlo. Abeene bikwakʉʉndonga ʉkʉtɨ ngogigwe. ");
INSERT INTO nyy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Po bikwakʉʉmbɨɨka mmaboko agaa Balooma ʉkʉtɨ baanyangalɨle, bangome nɨ fingoti nʉ kʉngomelela pa kɨkohekano. Looli pi isikʉ lya bʉtatʉ, angʉsyʉka.” ");
INSERT INTO nyy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Po ʉnkasi gwa Sebetai alɨnkʉbʉʉka na baanaake, alɨnkʉfugama nkyeni mwa Jesu nʉ kʉsʉʉma ʉbʉtʉʉli. ");
INSERT INTO nyy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesu alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Kʉlonda ngʉbombele ɨfiki?” Alɨnkʉmmwamula alɨnkʉtɨ, “Ngʉsʉʉma ʉbiitɨkɨsye abaanangʉ aba babɨlɨ ʉkʉja pabʉjo ʉbwɨmɨkigwa, balongosyege pamopeene na nungwe mBʉnyafyale bwako.” ");
INSERT INTO nyy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesu alɨnkʉbabʉʉla abaana baa nkiikʉlʉ jʉla alɨnkʉtɨ, “Mukasimanya ɨsi mukʉsʉʉma. Bʉle, mubagiile ʉkʉkʉbɨlwa bo ʉlʉ ʉne ngwakʉkʉbɨlwa?” Balɨnkʉmmwamula balɨnkʉtɨ, “Tʉbagiile.” ");
INSERT INTO nyy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Nalooli aabikʉbapapo ɨngʉbɨlo bo ʉlʉ ʉne aabikʉmbapo ɨngʉbɨlo. Looli ɨsya kʉtʉʉgala pabʉjo ʉbwɨmɨkigwa nʉ kʉlongosya pamopeene na niine jɨkaja mbombo jangʉ ʉkʉbiitɨkɨsya, looli ʉbʉjo ʉbo bikʉpeeligwaga aba batendekekesiigwe na Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Abafundigwa abangɨ bala kalongo, bo bapɨliike ɨsyo, balɨnkʉbakalalɨla abanyamundʉ babɨlɨ bala. ");
INSERT INTO nyy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Po Jesu alɨnkʉbakoolela boosa pamopeene, alɨnkʉbabʉʉla alɨnkʉtɨ, “Mumeenye ʉkʉtɨ pakiisʉ apa, abalongosi biiganile ʉkʉbalagɨla abandʉ kʉ bʉkalɨ, bikʉbabombesya kʉ maka. ");
INSERT INTO nyy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Looli silɨngajaga bo ʉlo kʉmyɨnu. Ʉmundʉ gwesa ʉjʉ ikʉlonda ʉkʉja nkʉlʉmba gwɨnu, ikʉlondigwa ababombelege abangɨ. ");
INSERT INTO nyy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kangɨ ʉmundʉ gwesa ʉjʉ ikʉlonda ʉkʉja gwa pamwanya pamyɨnu, ajege mbombeli gwɨnu. ");
INSERT INTO nyy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bʉbʉʉbo ʉne Nnyamundʉ ngaaliisile ʉkʉtɨ baambombelege, looli naaliisile ʉkʉtɨ mbabombelege abandʉ, nʉ kʉbʉninga ʉbʉʉmi bwangʉ ʉkʉtɨ mbapoke abandʉ bingi.” ");
INSERT INTO nyy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesu na bafundigwa baake bo bikʉsookamo nkaaja akaa mu Jeeliko, ɨkɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ kyankongaga. ");
INSERT INTO nyy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Po abafwa maaso bamo babɨlɨ baatʉʉgeele kʉmbalɨ kʉ njɨla ɨjɨ Jesu endaga. Bo bapɨliike ʉkʉtɨ Jesu ikʉkɨnda, balɨnkʉlaata ʉkʉkoolela balɨnkʉtɨ, “Gwe Ntwa, gwe Mwana gwa malafyale Ndaabɨti, ʉlɨɨtʉpaakɨsya!” ");
INSERT INTO nyy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɨkɨlʉndɨlo ɨkya bandʉ bala kɨlɨnkʉbakemela ʉkʉtɨ bamyeke. Looli abeene balɨnkwendelela ʉkʉkoolela balɨnkʉtɨ, “Gwe Ntwa, gwe Mwana gwa malafyale Ndaabɨti, ʉlɨɨtʉpaakɨsya!” ");
INSERT INTO nyy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesu alɨnkwɨma, alɨnkʉbakoolela, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mukʉlonda mbabombele ɨfiki?” ");
INSERT INTO nyy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Po abafwa maaso bala balɨnkʉmmwamula balɨnkʉtɨ, “Gwe Ntwa, tukʉlonda ʉkʉtɨ amaaso gɨɨtʉ gakeetege.” ");
INSERT INTO nyy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Po Jesu alɨnkʉbapaakɨsya, alɨnkʉbapalamaasya amaaso gaabo. Nakalɨnga, amaaso gaabo galɨnkwanda ʉkʉkeeta, balɨnkʉnkonga Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bo basegeliile mu Jelusalemu, balɨnkʉfika mu Betifage akaaja aka kalɨ kɨfuki nʉ bʉjo ʉbʉ bikʉtɨ Kyamba kya Misyʉngʉtɨ. Po Jesu alɨnkʉbatʉma abafundigwa baake babɨlɨ, ");
INSERT INTO nyy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","alɨnkʉbabʉʉla alɨnkʉtɨ, “Namubʉʉkege nkaaja kala aka kalɨ nkyeni mmyɨnu. Bo mwingiile mula, nakalɨnga mukwakʉjaaga ɨmbunda jɨkʉngiigwe pamopeene nɨ mwana. Po mukasyabʉle, mundwalɨle. ");
INSERT INTO nyy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Lɨnga ʉmundʉ ikʉbalaalʉʉsya, mukatɨgɨ, ‘ɄNtwa afumbilwe nasyo,’ nakalɨnga ikwakʉsitʉma.” ");
INSERT INTO nyy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Syosa ɨsi syabombiigwe bo ʉlo ʉkʉtɨ iisyʉ lɨla lɨboneke ɨlɨ Kyala aalɨjobile, kʉ njɨla jaa nkunguluka ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mubabʉʉle abandʉ abaa mu Syoni ʉkʉtɨ, ‘Namukeete, ʉMalafyale gwɨnu ikwisa kʉmyɨnu, mooloolo, ikwisa bo iitogile ɨmbunda, ɨmwana jaa mbunda.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Po abafundigwa bala balɨnkʉbʉʉka, balɨnkʉbomba bo muno Jesu abalagɨliile. ");
INSERT INTO nyy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Balɨnkʉjɨtwala ɨmbunda jɨla pamopeene nɨ mwana jaake, balɨnkwalɨsya ɨmyenda gyabo pamwanya pa mbunda ɨsyo, Jesu alɨnkwitoga. ");
INSERT INTO nyy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ɨkɨlʉndɨlo kɨla ɨkɨnywamu ɨkya bandʉ balɨnkwalɨsya ɨmyenda gyabo mu nsebo, ʉkʉnangɨsya ʉlwɨmɨko kʉmyake, kangɨ abangɨ balɨnkʉkonyola ɨsamba sya mipiki, balɨnkwalɨsya mu njɨla. ");
INSERT INTO nyy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Abandʉ bala baalongoliile nkyeni mwa Jesu na bala baakongaga balɨnkʉkoolela balɨnkʉtɨ, “Hosyana! Mwana gwa malafyale Ndaabɨti! Asajigwege ʉjʉ ikwisɨla mu ngamu jaa Ntwa Kyala! Hosyana! Ɨɨmɨkigwege ʉNtwa ʉgwa kʉmwanya!” ");
INSERT INTO nyy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesu bo ingiile mu Jelusalemu, akaaja koosa kaanyomwike. Abandʉ balɨnkʉlaalʉʉsania balɨnkʉtɨ, “Ʉjʉ jo jwani?” ");
INSERT INTO nyy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ɨkɨlʉndɨlo kɨla ɨkya bandʉ balɨnkʉbaamula balɨnkʉtɨ, “Ʉjʉ jo Jesu, ʉjʉ afumile mu Nasaleti, nkiisʉ kya Galilai, ʉjʉ jo nkunguluka gwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Po Jesu alɨnkwingɨla ndʉpaso lwa tempeli, alɨnkʉbakagɨla panja aba bʉʉlɨsyaga na aba bʉʉlaga. Alɨnkʉsigwɨsya ɨmeesa sya bʉʉsania ndalama, nɨ fikota fya bʉʉlɨsi baa ngʉnde. ");
INSERT INTO nyy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ɨnyumba jangʉ jikʉjobigwaga ʉkʉja nyumba jaa kwipuutɨlamo.’ Looli ʉmwe mujɨbɨɨkile ʉkʉja, ‘Mbako jaa minyambuta.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesu bo alɨ ndʉpaso lwa tempeli, abafwa maaso na aba bikʉkwema balɨnkʉmmwisɨla, alɨnkʉbabʉmbʉlʉsya. ");
INSERT INTO nyy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Looli abapuuti abalongosi na bamanyisi baa ndagɨlo sya Moose, baafibwene ɨfiswigo ɨfyo, nʉ kʉbapɨlɨka abaanike aba baakoolelaga ndʉpaso lwa tempeli ʉkʉtɨ, “Hosyana, Mwana gwa malafyale Ndaabɨti,” balɨnkʉkalala. ");
INSERT INTO nyy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Balɨnkʉnndaalʉʉsya Jesu balɨnkʉtɨ, “Bʉle, kʉpɨlɨka muno bikʉjobela abaanike aba?” Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ngʉpɨlɨka. Mukabalamo amasyʉ aga gasimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Nkanwa kaa baanike na baana abafyele, mo kʉkaba ɨnduufyo syosa?’ ” ");
INSERT INTO nyy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesu alɨnkʉbaleka, alɨnkʉsookamo mu Jelusalemu, alɨnkʉbʉʉka kʉ Betanija, alɨnkʉgona ʉko. ");
INSERT INTO nyy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jesu bo ikwisa nʉlʉbʉnjʉ nkaaja akaa mu Jelusalemu, ɨnjala jɨlɨnkʉnndʉma. ");
INSERT INTO nyy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Po alɨnkʉgʉbona ʉnkʉjʉ gʉmo mumbalɨ mu njɨla, alɨnkʉbʉʉka apa gʉlipo, alɨnkwaga gʉkaja nɨ seke nasimo, looli geene amaani. Po alɨnkʉgʉbʉʉla ʉmpiki gʉla alɨnkʉtɨ, “Ʉtiisakʉpamo sikʉ ɨseke!” Nakalɨnga ʉnkʉjʉ gʉla gʉlɨnkʉkofuka. ");
INSERT INTO nyy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Abafundigwa baa Jesu bo basibwene ɨsyo, balɨnkʉswiga, balɨnkʉtɨ, “Silɨ bʉleebʉle, ʉnkʉjʉ ʉgʉ gʉkofwike nakalɨnga?” ");
INSERT INTO nyy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, lɨnga mulɨ nʉ lwitɨko kɨsita kwilaamwa, mubagiile ʉkʉbomba bo ɨsi ngʉbombiile ʉnkʉjʉ ʉgʉ, nʉ kʉkɨndapo ɨsyo. Nalɨnga mukʉkɨbʉʉla ɨkyamba ɨkɨ, ʉkʉtɨ, ‘Kʉʉka ʉkiitaage mu nyanja,’ sikʉbombigwaga. ");
INSERT INTO nyy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lɨnga mulɨ nʉ lwitɨko, syosyosa ɨsi mukʉsʉʉma ndwipuuto, sikʉbombigwaga.” ");
INSERT INTO nyy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesu alɨnkʉfika mu Jelusalemu, alɨnkwingɨla ndʉpaso lwa tempeli, alɨnkwanda ʉkʉmanyisya. Po abapuuti abalongosi na balongosi baa Bajuuta, balɨnkʉbʉʉka kʉmyake kʉkʉnndaalʉʉsya balɨnkʉtɨ, “Ʉkabile kʉʉgʉ amaka agaa kʉbomba ɨsi? Jo jwani ʉjʉ akʉpeele amaka aga?” ");
INSERT INTO nyy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Na niine ngʉbalaalʉʉsya iisyʉ lɨmo. Lɨnga muunyaamwile, niine ngʉbabʉʉla ʉkʉtɨ kʉ maka gaani ngʉbomba ɨsi. ");
INSERT INTO nyy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Bʉle, amaka agaa Johani agaa kʉboosya abandʉ gaafumile kʉʉgʉ? Gaafumile kwa Kyala, pamo kʉ bandʉ?” Po balɨnkʉjobesania balɨnkʉtɨ, “Lɨnga tukʉtɨ amaka gaake gaafumile kwa Kyala, ʉmwene ikʉtɨgɨ, ‘Keeta mukaalɨmmwitiike?’ ");
INSERT INTO nyy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Looli lɨnga tukʉtɨ amaka gaake gaafumile kʉ bandʉ, tukʉtiila ɨkɨlʉndɨlo kya bandʉ aba, paapo abandʉ boosa biitiike ʉkʉtɨ Johani aalɨ nkunguluka.” ");
INSERT INTO nyy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Po balɨnkʉmmwamula Jesu balɨnkʉtɨ, “Tʉkamanya.” Joope Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Po leelo niine, ndikʉbabʉʉla ʉkʉtɨ jwani ambeele amaka agaa kʉbomba ɨsi.” ");
INSERT INTO nyy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesu alɨnkʉjoba nabo kangɨ alɨnkʉtɨ, “Bʉle, ʉmwe mukʉtɨ fiki? Aaliko ʉmundʉ jʉmo ʉjʉ aalɨ na baana abalʉmyana babɨlɨ. Alɨnkʉbʉʉka kʉ mwana gwa kwanda, alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Mwanangʉ, bʉʉka lɨɨlɨno ʉkabombe ɨmbombo mu ngʉnda.’ ");
INSERT INTO nyy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ʉmwana jʉla alɨnkʉkaana alɨnkʉtɨ, ‘Ndikʉbʉʉka.’ Looli piitaasi aaliinogwine, aabʉʉkile kʉkʉbomba. ");
INSERT INTO nyy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Po ʉgwise alɨnkʉbʉʉka kʉ mwanaake ʉgwa bʉbɨlɨ, alɨnkʉmmbʉʉla bo lʉlalʉla. Ʉmwana jʉla alɨnkʉtɨ, ‘Ngʉbʉʉka taata.’ Looli akaabʉʉkile. ");
INSERT INTO nyy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bʉle, ndɨ abo babɨlɨ, jwani aabombile ɨsi ʉgwise aalondaga?” Abapuuti abo na balongosi balɨnkʉmmwamula balɨnkʉtɨ, “Jo jʉla ʉgwa kwanda.” Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, abasongesya songo na baa malaja aabikwingɨla mBʉnyafyale bwa Kyala, looli ʉmwe mutikwingɨla. ");
INSERT INTO nyy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Paapo Johani aaliisile kʉmyɨnu, aabanangiisye ɨnjɨla jaa bʉgolofu, ʉmwe mukaalɨmmwitiike. Looli abasongesya songo na baa malaja baalɨmmwitiike. Ʉmwe poope bo musibwene ɨsyo, mukaaliinogwine piitaasi nʉ kʉmmwitɨka.” ");
INSERT INTO nyy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesu alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Namupɨlɨkɨsye ɨkɨfwanikɨsyo ɨkɨngɨ. Aaliko ʉmundʉ jʉmo ʉjʉ aalɨ nʉ ngʉnda. Aabyele amaafiilʉ, aasyʉngʉʉsiisye ʉlʉpaso, aakʉmbile ʉbwina ʉbwa kʉkamɨlamo ɨseke sya maafiilʉ, kangɨ aajengile ɨkɨsonge ɨkya kwɨmapo abalɨndɨlɨli. Alɨnkʉbabɨɨkamo abalɨmi abaa kʉkeetelela ɨmipiki gya maafiilʉ gɨla, ʉkʉtɨ ɨseke bo sibɨfwifwe, biise bajabane. Po alɨnkwenda ɨnjɨla jaa pabʉtali. ");
INSERT INTO nyy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Akabalɨlo kaa kʉtʉngʉla ɨseke bo kafikile, alɨnkʉbatʉma ababombeli baake kʉ balɨmi bala ʉkʉtɨ bampeko ɨkɨjabo kyake. ");
INSERT INTO nyy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Looli abalɨmi bala balɨnkʉbakola ababombeli bala, jʉmo balɨnkʉnkoma, ʉjʉngɨ balɨnkʉnngoga, nʉ jʉngɨ balɨnkʉntuunya na mabwe. ");
INSERT INTO nyy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Po ʉmwene ngʉnda jʉla alɨnkʉbatʉma kangɨ ababombeli abangɨ, abingi ʉkʉkɨnda aba kwanda, looli abalɨmi bala balɨnkʉbabombela bo ʉlʉ baababombiile abaa kwanda. ");
INSERT INTO nyy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Po kʉmmalɨɨkɨsyo alɨnkʉntʉma ʉmwanaake, alɨnkʉtɨ, ‘Ʉmwanangʉ jo bikwakʉmmwɨmɨkaga.’ ");
INSERT INTO nyy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Looli abalɨmi bala bo bammbwene ʉmwana jʉla, balɨnkʉjobesania balɨnkʉtɨ, ‘Ʉjʉ jo mwene kɨlɨngo. Isaga tʉnngoge, ʉkʉtɨ twege ɨkɨlɨngo kyake.’ ");
INSERT INTO nyy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Po balɨnkʉnkola, balɨnkʉnsoosyamo mu ngʉnda, balɨnkʉnngoga.” ");
INSERT INTO nyy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Po Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Po ʉmwene ngʉnda jʉla bo iisile, ikwisa kʉbabombela sya fiki abalɨmi bala?” ");
INSERT INTO nyy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Abeene balɨnkwamula balɨnkʉtɨ, “Ikwisa kʉbagoga kɨsita kʉbapaakɨsya abalɨmi ababiibi bala, kangɨ mu ngʉnda gʉla ikwisa kʉbabɨɨka abangɨ abaa kʉgʉkeetelela, aba bikwisa kʉntwalɨlaga ɨseke pakabalɨlo aka sibɨfwifwe.” ");
INSERT INTO nyy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Po Jesu alɨnkʉbabʉʉla kangɨ alɨnkʉtɨ, “Bʉle, mukabalamo Kalata ʉMwikemo? Apa sisimbiigwe ʉkʉtɨ, ‘Ɨliibwe ɨlɨ abajenga nyumba baalɨkaanile, lyo lɨjile ibwe ikʉlʉmba pa lwalo, pa nguto. ɄNtwa Kyala jo ʉjʉ asipelile ɨsyo, sya kɨswigo fiijo kʉmyɨtʉ ʉkʉsibona ɨsyo.’ ");
INSERT INTO nyy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kʉnongwa ɨjo, nikʉbabʉʉla nikʉtɨ, mutikʉjaga bandʉ baa Kyala, looli abandʉ abangɨ bikʉjaga bandʉ baa Kyala, aba babagiile ʉkʉbomba kanunu mu ngʉnda gwake, ʉkʉtɨ sikabigwe ɨseke. ");
INSERT INTO nyy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kʉkʉtɨ mundʉ ʉjʉ ikʉgwa pamwanya pi ibwe ɨlyo, ikʉkonyoka konyoka, na gwesa jʉla likʉnngwɨla, likʉntakania.” ");
INSERT INTO nyy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Abapuuti abalongosi na Bafalisai bo bapɨliike ɨfifwanikɨsyo ɨfyo, balɨnkʉsyagania ʉkʉtɨ aabajobaga abeene. ");
INSERT INTO nyy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Po balɨnkʉlonda ɨnjɨla jaa kʉnkola, looli balɨnkʉkɨtiila ɨkɨlʉndɨlo kya bandʉ, aba baalɨmmwitiike Jesu ʉkʉja nkunguluka. ");
INSERT INTO nyy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Po Jesu, alɨnkʉjoba kangɨ na balongosi mfifwanikɨsyo alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ɄBʉnyafyale bwa kʉmwanya aabukwisa bo ʉlwa malafyale jʉmo, ʉjʉ aabɨɨkile ʉlʉsekelo lwa bwegi ʉbwa mwanaake ʉndʉmyana. ");
INSERT INTO nyy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Alɨnkʉbatʉma ababombeli baake, kʉkʉbakoolela aba aabapaalile ʉkʉtɨ biise kʉ bwegi, looli abeene balɨnkʉkaana ʉkwisa. ");
INSERT INTO nyy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Po alɨnkʉbatʉma kangɨ ababombeli abangɨ, alɨnkʉtɨ, ‘Mubabʉʉle aba mbapaalile ʉkʉtɨ, “Ndendekiisye ɨfindʉ fyosa ɨfya bwegi. Mboolile ɨngʼombe syangʉ ɨsi situpile fiijo, namwisege kʉ bwegi!” ’ ");
INSERT INTO nyy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Looli abeene balɨnkʉsita kʉpaasya. Balɨnkʉsookapo, bamo balɨnkʉbʉʉka mmigʉnda gyabo, abangɨ mu mbombo syabo. ");
INSERT INTO nyy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bamo balɨnkʉbakola ababombeli baake bala, balɨnkʉbakoma fiijo nʉ kʉbagoga. ");
INSERT INTO nyy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ʉmalafyale jʉla alɨnkʉkalala fiijo, alɨnkʉbatʉma abasikali baake, balɨnkʉbʉʉka kʉkʉbagoga abagogi bala, nʉ kʉkosya akaaja kaabo. ");
INSERT INTO nyy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Po ʉmalafyale alɨnkʉbabʉʉla ababombeli abangɨ alɨnkʉtɨ, ‘Ɨfindʉ ɨfya lʉsekelo ʉlwa bwegi fitendekesiigwe, looli aba naabapaalile bakaabagiisye. ");
INSERT INTO nyy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Po ʉlʉ namubʉʉke moosa nkaaja, boosa aba mukwakʉbaaga mukabakoolele kʉ bwegi.’ ");
INSERT INTO nyy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ababombeli bala balɨnkʉbʉʉka nkaaja moosa. Balɨnkʉbabʉngaania abandʉ boosa aba babaagile, abanunu na babiibi. Po abaheesya balɨnkwisʉla mu nyumba jaa bwegi. ");
INSERT INTO nyy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Leelo ʉmalafyale bo ingiile nnyumba nkʉbakeeta abaheesya, alɨnkʉmmbona ʉmundʉ jʉmo ʉjʉ akaafwele ʉmwenda ʉgwa bwegi. ");
INSERT INTO nyy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Alɨnkʉnndaalʉʉsya alɨnkʉtɨ, ‘Mmanyaani, gwingiile bʉleebʉle muno, bo ʉkafwala ʉmwenda ʉgʉ gʉbagiisye pa bwegi?’ Leelo ʉmundʉ jʉla alɨnkʉtoligwa ɨsya kʉjoba. ");
INSERT INTO nyy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Po ʉmalafyale alɨnkʉbabʉʉla ababombeli baake alɨnkʉtɨ, ‘Mumpinye amalʉndɨ na maboko, muntaage panja mu ngiisi. Abandʉ aba ʉko bikwakʉlɨlaga nʉ kʉsyegetula amiino kʉnongwa jaa ndaamyo.’ ");
INSERT INTO nyy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ababɨlɨkɨligwa bingi, looli abasʉngʉligwa banandɨ itolo.” ");
INSERT INTO nyy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Po aBafalisai balɨnkʉsookapo pala, balɨnkʉntegelela Jesu ʉkʉtɨ bankole mmasyʉ gaake. ");
INSERT INTO nyy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Po balɨnkʉbatʉma kwa Jesu abafundigwa baabo, pamopeene na babombeli abaa malafyale Heloti, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Gwe Mmanyisi, tʉmeenye ʉkʉtɨ ʉgwe ʉlɨ ngolofu, kʉmanyisya ɨsya Kyala kʉ bwanalooli kɨsita kʉpaasya ʉbʉsisya bwa bandʉ. Kangɨ ʉtikʉpaasya ɨsi bikwinogona abandʉ. ");
INSERT INTO nyy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Po tʉbʉʉle muno kʉkeetela. Bʉle, ɨndagɨlo sya Moose sikʉtwitɨkɨsya ʉkʉsonga ɨsongo kʉ malafyale gwa Balooma pamo mma?” ");
INSERT INTO nyy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Looli Jesu alɨnkʉsyagania ɨnyiinogono syabo ɨmbiibi, alɨnkʉbaamula alɨnkʉtɨ, “Mwe basyobi ʉmwe, fiki mukʉʉngela? ");
INSERT INTO nyy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Namuunangɨsye ɨndalama ɨsi mukʉhombela ɨsongo.” Boope balɨnkʉntwalɨla ʉlʉtalama lʉmo. ");
INSERT INTO nyy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Po Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Ɨkɨfwani ɨkɨ kyani, nɨ ngamu ɨjɨ jaani?” ");
INSERT INTO nyy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Balɨnkʉmmwamula balɨnkʉtɨ, “Fya malafyale gwa Balooma.” Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Po ɨfya malafyale gwa Balooma mumpege ʉmalafyale gwa Balooma, nɨ fya Kyala mumpege Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bo bapɨliike ɨsyo, balɨnkʉswiga, po balɨnkʉnndeka, balɨnkʉsookapo pala. ");
INSERT INTO nyy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Iisikʉ lɨlalɨla, aBasatukai bamo balɨnkʉbʉʉka kwa Jesu. Abeene baamanyisyaga ʉkʉtɨ abandʉ bakabagɨla ʉkʉsyʉka ʉkʉfuma mbafwe. Po balɨnkʉnndaalʉʉsya balɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Gwe Mmanyisi, Moose aatile, ‘Lɨnga ʉmundʉ ikʉfwa kɨsita kʉpaapa ʉmwana najʉmo, ʉgwamyabo ammwingɨlengepo ɨkɨlɨngo ʉnkiikʉlʉ ʉmfwɨle jʉla, ʉkʉtɨ ampaapɨle abaana ʉjʉ afwile.’ ");
INSERT INTO nyy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kʉmyɨtʉ, baaliko abanyamundʉ bahaano na babɨlɨ. Ʉgwa kwanda alɨnkwega ʉnkiikʉlʉ, alɨnkʉfwa kɨsita kʉpaapa ʉmwana najʉmo. Alɨnkʉnndekela ʉgwamyabo ʉnkasi. ");
INSERT INTO nyy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bʉbʉʉbo ʉgwa bʉbɨlɨ, nʉ gwa bʉtatʉ, mpaka boosa bahaano na babɨlɨ balɨnkʉfwa kɨsita kʉpaapa nagwe. ");
INSERT INTO nyy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kʉmmalɨɨkɨsyo ʉnkiikʉlʉ jʉla joope alɨnkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Abandʉ boosa bo basyʉkile, ʉnkiikʉlʉ jʉla ikwisa kʉjaga nkasi gwani mbanyambala abo? Paapo boosa bahaano na babɨlɨ baalɨmmwegilemo!” ");
INSERT INTO nyy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ʉmwe mukʉsoba paapo mukasyagania ɨsi sisimbiigwe mwa Kalata ʉMwikemo, kangɨ mukagamanya amaka gaa Kyala muno gajɨɨliile. ");
INSERT INTO nyy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Paapo abafwe bo basyʉkile, bikʉjaga bo ʉlwa bandʉmi aba balɨ kʉmwanya, aba batikwega nʉ kwegigwa. ");
INSERT INTO nyy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Looli ɨsya kʉsyʉka abafwe, Kyala aababʉʉlile ʉmwe mwa Kalata ʉMwikemo ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ʉne ne Kyala gwa Abulahamu, Kyala gwa Isaka na Kyala gwa Jaakobo.’ Bʉle, mukabalamo ɨsyo? Po Kyala akaja jo Kyala gwa bafwe, looli gwa bʉʉmi!” ");
INSERT INTO nyy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ɨkɨlʉndɨlo ɨkya bandʉ bo bapɨliike ɨsyo, baasiswigile fiijo ɨmanyisyo syake. ");
INSERT INTO nyy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ABafalisai bo bapɨliike ʉkʉtɨ Jesu abatolile aBasatukai mbʉjobi, balɨnkʉbʉngaana pamopeene. ");
INSERT INTO nyy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jʉmo mBafalisai bala, ʉmmanyisi gwa ndagɨlo sya Moose, alɨnkʉgela ʉkʉntega Jesu, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Gwe Mmanyisi, lo lʉlagɨlo lʉlɨkʉ ʉlʉkʉlʉmba kʉlɨ syosa?” ");
INSERT INTO nyy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉnnganege ʉNtwa Kyala gwako nɨ ndumbula jaako joosa, nɨ mbepo jaako joosa, na mahala gaako goosa. ");
INSERT INTO nyy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ʉlʉlagɨlo ʉlo, lo lʉkʉlʉmba ʉkʉkɨnda ɨndagɨlo ɨsingi syosa. ");
INSERT INTO nyy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kangɨ lʉlipo ʉlʉlagɨlo ʉlwa bʉbɨlɨ ʉlʉkʉlʉmba bo ʉlo, lo ʉlʉ lukʉtɨ, ‘Ʉbaganege abanino bo ʉlʉ gwijiiganile ʉgwe.’ ");
INSERT INTO nyy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mu ndagɨlo ɨsyo ibɨlɨ, silimo syosa ɨsya mwa baakalata abaa Moose na baa bakunguluka.” ");
INSERT INTO nyy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ABafalisai bala bo bakaalɨ babʉngeene pamopeene, Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mukwinogona bʉleebʉle ɨsya Meesija? Bʉle, mwana gwani?” Balɨnkʉmmwamula balɨnkʉtɨ, “Mwana gwa malafyale Ndaabɨti.” ");
INSERT INTO nyy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Po silɨ bʉleebʉle apa Ndaabɨti bo ikʉlongosigwa na Mbepo Mwikemo, ikʉnkoolela ʉkʉtɨ Ntwa? Paapo aatile, ");
INSERT INTO nyy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘ɄNtwa Kyala aalɨmmbʉʉlile ʉNtwa gwangʉ, “Itʉʉgasye kʉkɨbafu kyangʉ ɨkiilɨɨlo, ʉbʉjo ʉbwa lwɨmɨko fiijo, ʉkʉfika apa nikʉbabɨɨkaga abalʉgʉ baako paasi pa malʉndɨ gaako.” ’ ");
INSERT INTO nyy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Lɨnga Ndaabɨti ikʉnkoolela Meesija ʉkʉtɨ Ntwa, Meesija ikʉjaga mwanaake bʉleebʉle?” ");
INSERT INTO nyy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Akajako ʉmundʉ ʉjʉ aalɨmmwamwile Jesu. Kangɨ ʉkʉfuma iisikʉ ɨlyo, akaagelilepo ʉmundʉ najʉmo ʉkʉnndaalʉʉsya kangɨ Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Po Jesu alɨnkʉkɨbʉʉla ɨkɨlʉndɨlo kya bandʉ na bafundigwa baake alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Abamanyisi baa ndagɨlo sya Moose na Bafalisai bikʉbamanyisya abandʉ ɨndagɨlo sya Moose. ");
INSERT INTO nyy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Po musikolege nʉ kʉsibombela ɨmbombo syosa ɨsi bikʉbabʉʉla. Looli mulɨngakongaga ɨmbombo syabo, paapo abeene batikʉbomba nʉ kʉsikonga ɨsi bikʉmanyisya. ");
INSERT INTO nyy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Abeene bikʉpinya ɨfitwalo ɨfisito nʉ kʉbalagɨla abandʉ ʉkʉfipɨmba pa fibeja, looli abeene batikʉlonda nʉ kʉfipalamaasyapo nʉ loobe lwabo. ");
INSERT INTO nyy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Abeene ɨmbombo syabo bikʉbomba ʉkʉtɨ biinangɨsye kʉ bandʉ. Bikʉfwala pamaaso na mmaboko ʉtʉnyambɨ ʉtwa fipapa ʉtʉnywamu ʉkʉkɨnda ʉtwa bangɨ, nɨ miselekesye ɨgya mpɨndo ʉgwa sanja ɨndali ʉkʉkɨnda abangɨ. ");
INSERT INTO nyy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Biiganile ʉkʉtʉʉgala pa lʉsekelo mbʉjo ʉbwa lwɨmɨko, na pa fikota ɨfya bɨɨmɨkigwa mu ngomaano. ");
INSERT INTO nyy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kangɨ biiganile ʉkʉtɨ abandʉ babaponiege kʉ lwɨmɨko mu sokoni, nʉ kʉtɨ babatɨgɨ, ‘Mmanyisi.’ ");
INSERT INTO nyy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Looli ʉmwe mulɨngiitɨkaga lɨnga bikʉbakoolela bikʉtɨ, ‘Mmanyisi,’ paapo ʉmmanyisi gwɨnu alɨ jʉmojwene itolo, ʉmwe mwesa mulɨ banyamundʉ. ");
INSERT INTO nyy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kangɨ mulɨngankoolelaga ʉmundʉ gwesa jʉla pakiisʉ ʉkʉtɨ, ‘Taata,’ paapo mulɨ nʉ Gwiseemwe jʉmojwene itolo kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kangɨ mungiitɨkaga lɨnga bikʉbakoolela bikʉtɨ, ‘Balongosi,’ paapo mulɨ nʉ Ndongosi jʉmojwene itolo, jo Meesija. ");
INSERT INTO nyy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ʉmundʉ gwesa ʉjʉ ikʉlonda ʉkʉja nkʉlʉmba gwɨnu, iijiisyege nʉ kʉbabombela ʉmwe. ");
INSERT INTO nyy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Paapo kʉkʉtɨ mundʉ ʉjʉ ikwijiinʉla, ikʉsulusigwaga na Kyala, ʉmundʉ gwesa ʉjʉ ikwisulusya, ikwinʉligwaga na Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ahɨɨli ʉmwe mwe bamanyisi baa ndagɨlo sya Moose na mwe Bafalisai, mwe basyobi ʉmwe! Paapo mukʉbasigɨla abandʉ ʉkwingɨla mBʉnyafyale bwa kʉmwanya. Ʉmwe mutikwingɨla, kangɨ abandʉ aba bikʉlonda ʉkwingɨla mukʉbasigɨla.  ");
INSERT INTO nyy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ahɨɨli ʉmwe mwe bamanyisi baa ndagɨlo sya Moose na mwe Bafalisai, mwe basyobi ʉmwe! Mukʉkabɨla kʉ bʉsyobi ɨfyʉma ɨfya bakiikʉlʉ abafwɨle, nʉ kwipuuta kʉ bʉkomu ɨnyiipuuto ɨndali ɨsya kʉlabaasya. Kʉnongwa ɨjo mukwisa kʉkaba kwa Kyala ʉlʉfundo ʉlʉnywamu ʉkʉkɨndapo. ");
INSERT INTO nyy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ahɨɨli ʉmwe mwe bamanyisi baa ndagɨlo sya Moose na mwe Bafalisai, mwe basyobi ʉmwe! Mukʉsyʉngʉʉtɨla nkiisʉ na mu nyanja ʉkʉmmwaga ʉmundʉ ʉjʉ akaja Njuuta ʉkʉtɨ abakonge ndwitɨko lwɨnu. Looli lɨnga mummwagile, mukʉmmbɨɨka ʉkʉja ntʉlanongwa ʉkʉbakɨnda ʉmwe. ");
INSERT INTO nyy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ahɨɨli ʉmwe mwe balongosi abafwa maaso ʉmwe! Ʉmwe mukʉtɨ, ‘Lɨnga ʉmundʉ ikʉlapa kʉ tempeli, jɨkaja nongwa. Looli lɨnga ikʉlapa kʉ sahabʉ ɨjaa mu tempeli, ʉjo iipinyile kʉlɨ ɨsi alapile.’ ");
INSERT INTO nyy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwe bakonyofu na bafwa maaso ʉmwe! Fyo filɨkʉ ɨfipala, bʉle, jo sahabʉ pamo ɨtempeli ɨjɨ jikʉjeelʉsya ɨsahabʉ ʉkʉja nyiikemo? ");
INSERT INTO nyy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kangɨ mukʉtɨ, ‘Lɨnga ʉmundʉ ikʉlapa kʉ kɨgemo kya tempeli, jɨkaja nongwa. Looli lɨnga ikʉlapa kʉ fya ikemo lya kʉbooligwa, ɨfi filɨ pa kɨgemo, ʉjo iipinyile kʉlɨ ɨsi alapile.’ ");
INSERT INTO nyy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwe bafwa maaso ʉmwe! Kyo kɨlɨkʉ ɨkɨpala, lyo ikemo pamo kɨgemo ɨkɨ kikʉlyelʉsya iikemo? ");
INSERT INTO nyy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Po ʉjʉ ikʉlapa kʉ kɨgemo kya tempeli, ikʉlapa kʉ tʉndʉ toosa ʉtʉ tʉlipo pamwanya. ");
INSERT INTO nyy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ʉjʉ ikʉlapa kʉ tempeli, ikʉlapa kʉ tempeli ɨjo na kwa Kyala ʉjʉ ikʉtʉʉgalamo. ");
INSERT INTO nyy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ʉjʉ ikʉlapa kʉmwanya, ikʉlapa kʉ kɨkota kya Kyala na kwa Kyala ʉjʉ ikʉtʉʉgala pa kɨkota ɨkyo. ");
INSERT INTO nyy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ahɨɨli ʉmwe mwe bamanyisi baa ndagɨlo sya Moose na mwe Bafalisai, mwe basyobi ʉmwe! Mukʉnsookesya Kyala ɨfya pi ilongo ʉkʉfuma ntʉndʉ toosa ʉtʉ mulɨ nato, mpaka fyope ɨfilʉngo fya maseeke, akajɨnja nʉ bʉnunia. Looli mulekile ʉkʉkonga ɨmanyisyo ɨngʉlʉmba ɨsya mu ndagɨlo sya Moose, bo ɨsya bʉgolofu, ʉlʉpaakɨsyo nʉ lwitɨko. Mukʉlondigwa ʉkʉsibomba ɨsya bʉgolofu nʉ lʉgano, kɨsita kʉleka ʉkʉsoosya ɨfya pi ilongo. ");
INSERT INTO nyy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mwe balongosi abafwa maaso! Mwe mukʉsʉʉja ɨmbwele ndɨ ɨfi mukʉnwa, looli mukʉmila ɨngamila! ");
INSERT INTO nyy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ahɨɨli ʉmwe mwe bamanyisi baa ndagɨlo sya Moose na mwe Bafalisai, mwe basyobi ʉmwe! Mumeenye ʉkʉsuka munyuma ɨndeko nɨ mbaale, looli mutikʉpaasya ʉkʉsuka nkatɨ mmyɨnu, muno bʉlimo ʉbʉnyali ʉbwingi, ʉbwa bʉhɨɨji nʉ bʉʉfi. ");
INSERT INTO nyy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mwe Bafalisai ʉmwe, mulɨ bafwa maaso! Musuke taasi nkatɨ mu ndeko ʉkʉtɨ munyuma moope muje mwelu. ");
INSERT INTO nyy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ahɨɨli ʉmwe mwe bamanyisi baa ndagɨlo sya Moose na mwe Bafalisai, mwe basyobi ʉmwe! Mufwene bo ʉlwa mapʉmba aga bikʉpaka ʉmpanya. Munyuma gikʉboneka manunu, looli nkatɨ giiswile ɨfifupa nʉ bʉnyali ʉbwa lʉko nʉ lʉko. ");
INSERT INTO nyy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bʉbʉʉbo na nuumwe munyuma mukʉboneka kʉ bandʉ ʉkʉja bagolofu, looli nkatɨ mwiswile ʉbʉsyobi nʉ bʉbiibi. ");
INSERT INTO nyy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ahɨɨli ʉmwe mwe bamanyisi baa ndagɨlo sya Moose na mwe Bafalisai, mwe basyobi ʉmwe! Mukʉjenga amapʉmba gaa bakunguluka nʉ kʉganosya amapʉmba gaa bagolofu. ");
INSERT INTO nyy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Po mukʉtɨ, ‘Lɨnga ʉswe twalipo mmasikʉ agaa biisʉkʉlʉ bɨɨtʉ, ngalɨ tʉkatʉʉlana nabo ʉkʉbagoga abakunguluka.’ ");
INSERT INTO nyy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ʉkʉjoba bo ʉlo, mukwijoba ʉkʉtɨ ʉmwe mulɨ baana baa aba baabagogile abakunguluka! ");
INSERT INTO nyy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Po namumalɨɨsye ɨsi abiisʉkʉlʉ bɨɨnu baalyandile! ");
INSERT INTO nyy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ʉmwe mwe baa ndʉjungu lwa njoka! Mukʉponaga bʉleebʉle ʉbʉlongi ʉbwa ndʉpanga lwa mooto? ");
INSERT INTO nyy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kʉnongwa ɨjo, ngʉbatʉma kʉmyɨnu abakunguluka, abandʉ abaa mahala, na bamanyisi. Bamo ndɨ abo ʉmwe mukwakʉbagoga nʉ kʉbakomelela pa kɨkohekano, bamo mukwakʉbakomaga mu ngomaano syɨnu, na bangɨ mukwakʉbafwɨmaga ntwaja ʉtʉ balimo. ");
INSERT INTO nyy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jo nongwa ɨjɨ Kyala ikwisa kʉbalonga ʉmwe, kʉnongwa jaa kʉbagoga abandʉ bingi abagolofu, ʉkʉfuma ʉkʉgogigwa Aabeli ʉngolofu, mpaka apa aagogiigwe Sakalija ʉmwana gwa Balakija, ʉjʉ mwalɨnngogile mu tempeli pakatɨ pa Pabwikemo na pa kɨgemo. ");
INSERT INTO nyy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nalooli nikʉbabʉʉla, Kyala ikwisa kʉbalonga abandʉ abaa nkabalɨlo aka kʉ bʉtʉlanongwa ʉbo boosa.” ");
INSERT INTO nyy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Po Jesu alɨnkʉtɨ, “Mwe bandʉ baa mu Jelusalemu, mwe bandʉ baa mu Jelusalemu! Mukʉbagoga abakunguluka nʉ kʉbatuunya na mabwe aba Kyala ikʉbatʉma kʉmyɨnu. Kalɨnga ndondile ʉkʉbabʉngaania pamopeene, bo ɨngʉkʉ ɨfyele ɨjɨ jikʉtʉbʉngaania ʉtwanaake nʉ kʉtʉʉbatɨla mmapɨko gaake? Looli ʉmwe mwakaanile! ");
INSERT INTO nyy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Keeta, Kyala ikwisa kʉbaleka ʉmwe, nɨ tempeli jɨɨnu jikwisa kʉja kɨsaame! ");
INSERT INTO nyy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nikʉbabʉʉla nikʉtɨ, mutikʉʉmbonaga kangɨ mpaka pakabalɨlo aka mukwisa kʉjobaga ʉkʉtɨ, ‘Asajigwege ʉjʉ ikwisɨla mu ngamu jaa Ntwa Kyala!’ ” ");
INSERT INTO nyy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesu alɨnkʉsooka ndʉpaso lwa tempeli, bo ikʉbʉʉka abafundigwa baake balɨnkʉmmwisɨla ʉkʉtɨ bannangɨsye ɨnyumba sya mu tempeli. ");
INSERT INTO nyy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mukʉsibona ɨsi syosa? Nalooli nikʉbabʉʉla, lɨtikwisa kʉjako iibwe ɨlɨ lɨlɨ pamwanya pi ibwe iinine. Goosa gikwisa koomoligwa!” ");
INSERT INTO nyy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesu bo atʉʉgeele pa Kyamba kya Misyʉngʉtɨ, abafundigwa baake balɨnkʉmmwisɨla pabʉjo ʉbʉsita bandʉ, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Tʉbʉʉle, ɨsyo sikwisa ndɨli? Kɨmanyilo nki kikwisa kʉtʉnangɨsya bo kwisa, kangɨ nʉ kʉfika kwa bʉmalɨɨkɨsyo bwa kabalɨlo akabiibi ako?” ");
INSERT INTO nyy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Mujege maaso, ʉmundʉ najʉmo alɨngabasyobaga! ");
INSERT INTO nyy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Abandʉ bingi bikwisa kʉbombelaga ɨngamu jangʉ, bikwisa kʉtɨgɨ, ‘Ʉne ne Meesija!’ Bikwisa kʉbasofya abandʉ abingi. ");
INSERT INTO nyy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mukwisa kʉpɨlɨkaga ɨsya bwite mbʉjo mbʉjo. Mulɨngiisa kʉtiilaga. Ɨsyo mpaka siboneke, looli ʉbʉmalɨɨkɨsyo bo bʉkaalɨ. ");
INSERT INTO nyy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ɨkiisʉ kɨmo kikwisa kʉlwaga nɨ kiisʉ ɨkɨngɨ, nʉ bʉnyafyale bʉmo bukwisa kʉlwaga nʉ bʉnyafyale ʉbʉngɨ. Ɨnjala nʉ tʉsenyenda fikwisa kʉboneka mfiisʉ fingi. ");
INSERT INTO nyy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ɨsyo syosa sikwisa kʉjaga bo ʉlwa bwandɨlo bwa lʉbabo lwa nkiikʉlʉ ʉjʉ alɨ kɨfuki ʉkʉpaapa. ");
INSERT INTO nyy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Akabalɨlo ako, abandʉ abaa mfiisʉ fyosa bikwisa kʉbabengaga ʉmwe, bikwisa kʉbakolaga ʉmwe, paapo mulɨ bafundigwa bangʉ. Bamo pakatɨ pamyɨnu bikwisa kʉbakolaga nʉ kʉbafunda, abangɨ ʉkʉbagoga. ");
INSERT INTO nyy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Po abandʉ bingi bikwisa kʉleka ʉkʉngonga ʉne. Bikwisa koohelanilaga nʉ kʉbengana. ");
INSERT INTO nyy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Akabalɨlo ako, bikwisa kʉbonekaga abakunguluka bingi abaa bʉtʉngʉlʉ nʉ kʉbasyoba abandʉ abingi. ");
INSERT INTO nyy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kangɨ kʉnongwa jaa kongelela ʉbʉtʉlanongwa, ʉlʉgano ʉlwa bandʉ bingi lukwisa kʉlogotela. ");
INSERT INTO nyy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Looli ʉjʉ ikʉʉmɨɨlɨla mpaka kʉmmalɨɨkɨsyo, jo ikwisa kʉpokigwa. ");
INSERT INTO nyy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kangɨ ɨNdʉmi ɨNunu ɨjaa Bʉnyafyale bwa Kyala jikwisa kʉlʉmbɨlɨligwa kʉfiisʉ fyosa, ʉkʉtɨ jɨjege bʉkeeti kʉ bandʉ boosa. Po ʉbʉmalɨɨkɨsyo bukwisa kwisaga.” ");
INSERT INTO nyy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Po apo mukwisa kʉkabona, ‘Akandʉ aka kikʉnyasya nʉ koonanga,’ kɨɨmile Pabʉjo ʉBwikemo. Akandʉ ako kaajobiigwe nʉ nkunguluka Ndaanieli. Ʉjʉ ikʉpɨlɨka amasyʉ aga asyaganiege. ");
INSERT INTO nyy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ɨsyo bo sikʉboneka, po abandʉ aba balɨ mu Jutai, babopelege mfyamba. ");
INSERT INTO nyy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Joope ʉmundʉ ʉjʉ alɨ pamwanya pa nyumba, alɨngasulukaga kʉkwega ʉtʉndʉ twake ʉtʉ tʉlɨ nnyumba jaake, looli abopege. ");
INSERT INTO nyy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kangɨ ʉmundʉ ʉjʉ alɨ mu ngʉnda, alɨngagomokelangako kʉkaaja kʉkwega ʉmwenda gwake. ");
INSERT INTO nyy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ahɨɨli abaa fifuba na aba bikongesya abaana nkabalɨlo ako! ");
INSERT INTO nyy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mwipuutege ʉkʉtɨ ʉkʉbopa kwɨnu kʉngiisa kʉja nkabalɨlo akaa mu fula pamo pi isikʉ ɨlya pa Sabati. ");
INSERT INTO nyy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Namanga nkabalɨlo ako, abandʉ bikwisa kʉkaba ʉbʉtolwe ʉbʉnywamu ʉbʉ bʉkabonekamo sikʉ, ʉkʉfuma kʉbwandɨlo bwa kʉpeligwa ɨkiisʉ mpaka lɨɨlɨno. Kangɨ ʉbʉtolwe ʉbo bʉtikwisa kʉjako sikʉ. ");
INSERT INTO nyy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Lɨnga Kyala akaakapimbwile akabalɨlo ako, akaajangapo najʉmo ʉgwa kwisa kʉpona. Looli kʉnongwa jaa basʉngʉligwa baake, Kyala akapimbwile akabalɨlo ako. ");
INSERT INTO nyy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Po nkabalɨlo ako, lɨnga ʉmundʉ ikʉbabʉʉla ikʉtɨ, ‘Keeta, Meesija alipo apa!’ pamo, ‘Aliko kʉla!’ mulɨngiisa kwitɨka. ");
INSERT INTO nyy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Namanga bikwisa kwisa abandʉ aba bikʉtʉngʉlʉpaga ʉkʉtɨ bo baa Meesija, nʉ kʉtɨ bakunguluka baa Kyala. Bikwisa kʉbomba ɨfimanyilo ɨfinywamu nɨ fiswigo, ʉkʉtɨ babasofye abandʉ, nʉ kʉtɨ lɨnga sibagiile babasofye boope na basʉngʉligwa baa Kyala. ");
INSERT INTO nyy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mujege maaso paapo mbabʉʉlile kɨlɨngaani syosa ɨsyo bo sikaalɨ ʉkʉboneka! ");
INSERT INTO nyy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Po leelo, lɨnga bikʉtɨ, ‘Keeta, Meesija alɨ ndʉngalangala!’ mulɨngiisa kʉbʉʉka ʉko. Pamo lɨnga bikʉtɨ, ‘Keeta, aliko kʉno iifisile nnyumba jɨla!’ mulɨngiisa kwitɨka. ");
INSERT INTO nyy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Paapo ʉkwisa kwa ne Nnyamundʉ kukwisa kʉja bo ʉlwa kɨmweku ɨkya njasi, ɨkɨ kikʉmulɨka mu mpaalanga, ʉkʉfuma ʉlʉbafu lʉmo kikwakʉfika ʉlʉbafu ʉlʉngɨ. ");
INSERT INTO nyy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pabʉjo apa gʉlipo ʉmfimba, po apa ɨminombo gikʉbʉngaana.” ");
INSERT INTO nyy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Leelo nakalɨnga, nkabalɨlo ako, bo ɨngʉbɨlo ɨsyo sikɨndile, ‘Ɨliisʉba likwisa kʉja nɨ ngiisi, nʉ mwesi gʉtikwisa kʉsoosya ʉndangalɨla gwake, nɨ ndondwa sikwisa kʉsatʉkaga paasi ʉkʉfuma kʉmwanya. Nʉ tʉndʉ toosa ʉtʉnywamu ʉtʉ tʉlɨ kʉmwanya, tukwisa kʉjʉngaanika.’ ");
INSERT INTO nyy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Po ɨkɨmanyilo kya Nnyamundʉ kikwisa kʉboneka kʉmwanya, na bandʉ abaa mfiisʉ fyosa bikwisa kʉlɨlaga kʉ lʉtende, bikwisa kʉʉmbona ne Nnyamundʉ bo ngwisa mmabɨngo agaa kʉmwanya, na maka amingi nʉ bʉsisya bwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Po ʉne ngwisa kʉbatʉma abandʉmi bangʉ ʉkʉfuma kʉmwanya, aba bikwisa kʉkʉba ɨngangabwite. Bikwisa kʉbabʉngaania abasʉngʉligwa bangʉ, ʉkʉfuma mfibafu fyosa ɨfya pakiisʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesu alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Mumanyilege ɨnongwa ɨjaa kʉfuma nkɨfwanikɨsyo ɨkya nkʉjʉ. Lɨnga ɨsamba syake ndeta, kangɨ amaani gatʉlwile, mukʉmanya ʉkʉtɨ ʉmpɨngo gʉsegeliile. ");
INSERT INTO nyy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bʉbʉʉbo na nuumwe bo mukʉsibona ɨsyo syosa, aamumanyege ʉkʉtɨ ʉbʉmalɨɨkɨsyo ʉbwa kabalɨlo akabiibi ako bʉsegeliile. ");
INSERT INTO nyy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nalooli nikʉbabʉʉla, abandʉ abaa nkabalɨlo aka, batikwisa kʉmalɨka ʉkʉfwa, bo syosa ɨsyo sikabombigwa. ");
INSERT INTO nyy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ʉmpaalanga nɨ kiisʉ fikwisa koomoka, looli amasyʉ gangʉ gatikoomokamo sikʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Leelo akajako najʉmo ʉjʉ alɨmeenye iisikʉ na kabalɨlo akaa kwisa kwangʉ, boope na bandʉmi abaa kʉmwanya, joope ʉMwana, looli Taata mwene jo ameenye. ");
INSERT INTO nyy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Namanga bo ʉlwa mmasikʉ agaa Nwaka, bo sikwisa kʉjɨɨlaga ʉkwisa kwa Nnyamundʉ. ");
INSERT INTO nyy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Akabalɨlo kala bo ʉmweleesyo gʉkaalɨ ʉkwisa, abandʉ baalyaga nʉ kʉnwa, beegaga nʉ kwegigwa, mpaka iisikʉ ɨlɨ Nwaka aalingiile mu ngalaba. ");
INSERT INTO nyy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Abandʉ bakaasyageenie mpaka bo ʉmweleesyo gwisile, gwabakwangwenie boosa. Bʉbʉʉbo bo sikwisa kʉjɨɨlaga bo ngwisa ne Nnyamundʉ. ");
INSERT INTO nyy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Akabalɨlo ako, lɨnga balipo abandʉ babɨlɨ bikʉbomba ɨmbombo mu ngʉnda, jʉmo ikwisa kwegigwa, ʉjʉngɨ ikwisa kʉlekigwa. ");
INSERT INTO nyy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kangɨ abakiikʉlʉ babɨlɨ bikwisa kʉsyaga pamopeene, jʉmo ikwisa kwegigwa, ʉjʉngɨ ikwisa kʉlekigwa. ");
INSERT INTO nyy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Po mujege maaso paapo mukalɨmanya iisikʉ ɨlyo ɨlɨ ʉNtwa gwɨnu ikwisa. ");
INSERT INTO nyy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Musyaganie ɨsi ʉkʉtɨ, lɨnga ʉmwene nyumba aamanyaga akabalɨlo aka ʉnhɨɨji ikwisa, ngalɨ ikʉja maaso, ʉkʉlɨndɨlɨla ɨnyumba jaake, akaabagiile ʉkʉjɨleka ɨnyumba jaake ʉkʉpangʉligwa. ");
INSERT INTO nyy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kʉnongwa ɨjo, na nuumwe mwitendekesyege, paapo Nnyamundʉ ikwisa pakabalɨlo aka mutikʉsʉʉbɨla.” ");
INSERT INTO nyy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Po jo jwani ʉmbombeli ʉnsʉʉbɨligwa ʉgwa mahala? Jo mbombeli ʉjʉ ʉntwa gwake ammbɨɨkile ʉkwɨmɨlɨla abaa nnyumba mmyake, ʉkʉbapa ɨfindʉ pakabalɨlo kaake. ");
INSERT INTO nyy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aasikʉja kanunu kʉ mbombeli ʉjʉ bo ʉntwa gwake ikwisa, ikʉmmwaga ikʉbomba bo ʉlo. ");
INSERT INTO nyy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nalooli nikʉbabʉʉla, ikʉmmbɨɨka ʉmbombeli ʉjo ʉkʉja mwɨmɨlɨli gwa tʉndʉ twake toosa. ");
INSERT INTO nyy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Looli lɨnga ʉmbombeli ʉjo mbiibi, ikwijobeesya mu ndumbula ikʉtɨ, ‘Ʉntwa gwangʉ akaabiile ʉkwisa,’ ");
INSERT INTO nyy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kangɨ lɨnga ikwanda ʉkʉbakoma ababombeli banine, ikʉlya nʉ kʉnwa pamopeene na bagaala bwalwa, ");
INSERT INTO nyy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ʉntwa gwa mbombeli ʉjo ikwisa pi isikʉ ɨlɨ akaasʉʉbɨlaga na pakabalɨlo aka akakamanya. ");
INSERT INTO nyy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ikwisa kʉmmbuutania nʉ kʉmmbɨɨka pabʉjo bʉmo na basyobi. Ʉko bikwisa kʉlɨlaga nʉ kʉsyegetula amiino kʉnongwa jaa ndaamyo.” ");
INSERT INTO nyy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Po Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Akabalɨlo akaa kʉfika ʉBʉnyafyale bwa kʉmwanya, kikwisa kʉfwana bo ʉlwa lʉsekelo lwa bwegi. Baaliko abalɨndwana kalongo, aba baalyegile ɨnyaale syabo nʉ kʉbʉʉka kʉkʉmmwambɨlɨla ʉmwega nkiikʉlʉ. ");
INSERT INTO nyy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bahaano ndɨ abo, baalɨ bakonyofu, abangɨ bahaano baalɨ baa mahala. ");
INSERT INTO nyy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Abakonyofu bala baalyegile ɨnyaale syabo, kɨsita kwega amafuta agangɨ agaa kongelelamo. ");
INSERT INTO nyy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Looli abaa mahala baalyegile amafuta mu supa syabo pamopeene nɨ nyaale syabo. ");
INSERT INTO nyy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ʉmwega nkiikʉlʉ bo akaabiile ʉkwisa, boosa balɨnkʉsipʉka, balɨnkʉgona ʉtʉlo. ");
INSERT INTO nyy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Looli pakɨlo pakatɨ, abandʉ balɨnkʉjwega balɨnkʉtɨ, ‘Keeta, ʉmwega nkiikʉlʉ ikwisa! Namusooke mubʉʉke kʉkʉmmwambɨlɨla.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nakalɨnga abalɨndwana bala boosa balɨnkʉlembʉka, balɨnkʉsitendekesya ɨnyaale syabo. ");
INSERT INTO nyy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Abakonyofu bala balɨnkʉbabʉʉla abaa mahala balɨnkʉtɨ, ‘Namutʉpepo amafuta manandɨ paapo ɨnyaale syɨtʉ sikʉsima.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Looli abaa mahala bala balɨnkʉbaamula balɨnkʉtɨ, ‘Mma! Gakabagɨla ʉkʉtʉfwana ʉswe na nuumwe. Kwalɨ kʉnunu mubʉʉke kʉno bikʉʉlɨsya ʉkʉtɨ mukiijʉʉlɨle.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Bo bikʉbʉʉka kʉkʉʉla, ʉmwega nkiikʉlʉ alɨnkʉfika, abalɨndwana aba baaliitendekiisye, balɨnkwingɨla pamopeene nagwe nnyumba muno lwalimo ʉlʉsekelo lwa bwegi, ɨkɨfigo kɨlɨnkwigaligwa. ");
INSERT INTO nyy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Piitaasi balɨnkwisa abalɨndwana abakonyofu bala, balɨnkʉtɨ, ‘Gwe ntwa! Gwe ntwa! Twigʉlɨle!’ ");
INSERT INTO nyy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Looli ʉmwega nkiikʉlʉ jʉla alɨnkʉbaamula alɨnkʉtɨ, ‘Nalooli nikʉbabʉʉla, ngabamanya ʉmwe!’ ” ");
INSERT INTO nyy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Po Jesu alɨnkʉtɨ, “Mujege maaso paapo mukalɨmanya iisikʉ, pamo akabalɨlo akaa kwisa Nnyamundʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesu alɨnkʉtɨ, “Kangɨ ʉBʉnyafyale bwa kʉmwanya bukwisa kʉja bo ʉlwa kɨfwanikɨsyo ɨkɨ. Aaliko ʉnkabi ʉjʉ aalondaga ʉkwenda ɨnjɨla, alɨnkʉbakoolela ababombeli baake, alɨnkʉbapapo ɨkyʉma kyake, ʉkʉtɨ bankabɨleko, bɨɨmɨlɨle mpaka bo iisile. ");
INSERT INTO nyy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aalɨmpeele kʉkʉtɨ mundʉ ʉkʉkongana na mahala gaake. Alɨnkʉmpa jʉmo ɨtalanta ihaano, ʉjʉngɨ ibɨlɨ, kangɨ nʉ jʉngɨ ɨtalanta jɨmo, po alɨnkwenda ɨnjɨla. ");
INSERT INTO nyy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Nakalɨnga, ʉjʉ aalyambɨliile ɨtalanta ihaano, alɨnkʉbʉʉka nasyo mbʉkyulusi, alɨnkʉkabɨlako ɨsingi ihaano pamwanya. ");
INSERT INTO nyy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bʉbʉʉbo nʉ mbombeli ʉgwa talanta ibɨlɨ, joope alɨnkʉkabɨlako ɨsingi ibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Looli jʉla ʉjʉ aapeeliigwe ɨtalanta jɨmo, aajile kʉjɨsyɨla mu mfu. ");
INSERT INTO nyy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Amasikʉ mingi bo gakɨndile, alɨnkwisa ʉnkabi ʉgwa babombeli bala, alɨnkʉbakoolela ababombeli bala ʉkʉtɨ bammbʉʉle muno babombiile ɨkyʉma kyake. ");
INSERT INTO nyy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Alɨnkwisa ʉjʉ aapeeliigwe ɨtalanta ihaano, alɨnkʉtɨ, ‘Ntwa, gwabɨɨkile kʉmyangʉ ɨtalanta ihaano. Keeta, ngabiileko ɨsingi ihaano.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ʉntwa jʉla alɨnkʉmmwamula alɨnkʉtɨ, ‘Ʉbombile kanunu, ʉgwe ʉlɨ mbombeli ʉnsʉʉbɨligwa kangɨ ʉlɨ ngolofu. Gwalɨ ngolofu kʉ finandɨ, ngʉkʉbɨɨka ʉkʉja mwɨmɨlɨli gwa kyʉma ɨkingi. Ingɨla ndʉsekelo, ʉsaale pamopeene na ne ntwa gwako.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Alɨnkwisa ʉmbombeli ʉjʉ aapeeliigwe ɨtalanta ibɨlɨ, alɨnkʉjoba alɨnkʉtɨ, ‘Ntwa, gwabɨɨkile kʉmyangʉ ɨtalanta ibɨlɨ. Keeta, ngabiileko ɨsingi ibɨlɨ.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ʉntwa gwake alɨnkʉtɨ, ‘Ʉbombile kanunu, ʉgwe ʉlɨ mbombeli ʉnsʉʉbɨligwa kangɨ ʉlɨ ngolofu. Gwalɨ ngolofu kʉ finandɨ, ngʉkʉbɨɨka ʉkʉja mwɨmɨlɨli gwa kyʉma ɨkingi. Ingɨla ndʉsekelo, ʉsaale pamopeene na ne ntwa gwako.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Alɨnkwisa jʉla ʉjʉ aapeeliigwe ɨtalanta jɨmo, alɨnkʉtɨ, ‘Ntwa, naameenye ʉkʉtɨ ʉgwe ʉlɨ mpalapala, kʉtondola muno ʉkaabyele, kʉbʉngaania mfitʉʉba ɨfi ʉkapʉʉlapo. ");
INSERT INTO nyy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Naatiilaga ʉkʉjɨsobesya ɨtalanta jaako, najile kʉjɨfisa mu mfu. Ʉlʉ gwege ɨtalanta jaako ɨjɨ.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ʉntwa gwake alɨnkwamula alɨnkʉtɨ, ‘Ʉgwe ʉlɨ mbombeli ʉmbiibi, kangɨ ʉlɨ moolo! Lɨnga gwameenye ʉkʉtɨ ʉne ngʉtondola ɨfi ngabyala nʉ kʉbʉngaania mfitʉʉba ɨfi ngapʉʉlapo, ");
INSERT INTO nyy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","po fiki ʉkaabɨɨkile ɨtalanta jangʉ kʉlɨ aba bikʉbombela ʉkʉtɨ ngabɨleko? Ʉne bo niisile, ngalɨ neegile ɨtalanta jangʉ, pamopeene na ɨsi ngabiileko.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Po ʉntwa gwake alɨnkʉbalagɨla abangɨ alɨnkʉtɨ, ‘Namupoke ɨtalanta ɨjo, mukampepo jʉla ʉjʉ alɨ nɨ talanta kalongo.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Paapo ʉjʉ ikʉbombela kanunu aka alɨ nako, ikongeleligwa ikʉja nafyo fingi. Ʉjʉ atikʉbombela kanunu, koope aka alɨ nako ikʉpokigwa. ");
INSERT INTO nyy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ʉmbombeli ʉjʉ akaja ngolofu, namuntaage panja mu ngiisi, kʉno ikwakʉlɨlaga nʉ kʉsyegetula amiino kʉnongwa jaa ndaamyo.” ");
INSERT INTO nyy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesu alɨnkwendelela ʉkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Ne Nnyamundʉ bo ngwisa mbʉsisya bwangʉ, na bandʉmi abiikemo boosa pamopeene na niine, po ngwisa kʉtʉʉgala pa kɨkota ɨkya bʉnyafyale, ɨkya bʉsisya. ");
INSERT INTO nyy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Abandʉ baa mfiisʉ fyosa bikwisa kʉbʉngaana nkyeni mmyangʉ. Ʉne ngwisa kʉbapaagʉlaniaga bo muno ʉntiimi ikʉsipaagʉlania ɨngʼoosi nɨ mbene. ");
INSERT INTO nyy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ngwisa kʉsibɨɨka ɨngʼoosi kʉ lʉbafu lwangʉ ʉlwa kʉ kiilɨɨlo, aba bo bandʉ abagolofu. Kʉ lʉbafu lwangʉ ʉlwa kʉ kiimama ngwisa kʉsibɨɨka ɨmbene, aba bo bandʉ ababiibi. ");
INSERT INTO nyy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Po ne Malafyale ngwisa kʉbabʉʉla abandʉ aba balɨ kʉ lʉbafu lwangʉ ʉlwa kʉ kiilɨɨlo, ʉkʉtɨ, ‘Isaga, mwe musajiigwe na Taata. Namwingɨle mbʉnyafyale ʉbʉ Kyala aabatendekekiisye kɨlɨngaani, ʉkʉfuma bo ikʉpela ɨkiisʉ. ");
INSERT INTO nyy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Paapo naalɨ nɨ njala, mwalɨmbeele ɨfindʉ. Naalɨ nɨ kyʉmɨlwa, mwalɨmbeele amɨɨsi agaa kʉnwa. Naalɨ nheesya, mwalɨɨnyambɨliile. ");
INSERT INTO nyy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Naalɨ kɨtali, mwalɨɨfwɨkile ɨmyenda. Naalɨ mbine, mwaliisile kʉkʉʉndwasya. Naalɨ mu nnyololo, mwaliisile kʉkʉngeeta.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Po abagolofu bikwisa kʉʉnyaamula ʉkʉtɨ, ‘Gwe Ntwa, ndɨli apa twakʉbwene bo ʉlɨ nɨ njala twakʉpeele ɨfindʉ? Pamo bo ʉlɨ nɨ kyʉmɨlwa twakʉpeele amɨɨsi? ");
INSERT INTO nyy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kangɨ ndɨli apa twakʉbwene bo ʉlɨ nheesya twakwambɨliile? Pamo bo ʉlɨ kɨtali twakʉfwɨkile ɨmyenda? ");
INSERT INTO nyy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ndɨli kangɨ apa twakʉbwene bo ʉlɨ mbine twakʉlwesye, pamo bo ʉlɨ mu nnyololo twaliisile nkʉkʉkeeta?’ ");
INSERT INTO nyy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ne Malafyale ngwisa kwamula ʉkʉtɨ, ‘Nalooli nikʉbabʉʉla, ɨsi mwammbombelaga jʉmo ʉnnandɨ mbaamyɨtʉ aba, mwambombelaga ʉne.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Po ngwisa kʉbabʉʉla bala aba balɨ kʉ lʉbafu lwangʉ ʉlwa kʉ kiimama ʉkʉtɨ, ‘Sookapo kʉmyangʉ ʉmwe mwe muguniigwe, namubʉʉke mmooto ʉgwa bwila na bwila ʉgʉ abɨɨkɨliigwe Seetano na bandʉmi baake. ");
INSERT INTO nyy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Paapo naalɨ nɨ njala, mukaalɨmbeele ɨfindʉ. Naalɨ nɨ kyʉmɨlwa, mukaalɨmbeele amɨɨsi. ");
INSERT INTO nyy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Naalɨ nheesya, mukaalɨɨnyambɨliile. Bo ndɨ kɨtali, mukaalɨɨfwɨkile ɨmyenda. Kangɨ bo ndɨ mbine, mukaaliisile kʉkʉʉndwasya. Na bo ndɨ mu nnyololo, mukaaliisile kʉkʉngeeta.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Po aba balɨ kʉ kɨboko kyangʉ ɨkiimama bikwisa kʉʉnyaamulaga, bikwisa kʉtɨgɨ, ‘Gwe Ntwa, ndɨli apa twakʉbwene bo ʉlɨ nɨ njala tʉkaakʉpeele ɨfindʉ? Pamo bo ʉlɨ nɨ kyʉmɨlwa tʉkaakʉpeele amɨɨsi? Bo ʉlɨ nheesya tʉkaakwambɨliile? Pamo bo ʉlɨ kɨtali tʉkaakʉpeele ɨmyenda? Kangɨ bo ʉlɨ mbine tʉkaakʉlwesye? Pamo bo ʉlɨ mu nnyololo tʉkaakʉtʉʉlile?’ ");
INSERT INTO nyy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ʉne ngwisa kʉbaamula ʉkʉtɨ, ‘Nalooli nikʉbabʉʉla, syosa ɨsi mukammbombelaga jʉmo ʉnnandɨ mbiitɨki biinɨɨnu aba, mukaambombelaga ʉne.’ ");
INSERT INTO nyy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Po ababomba mbiibi bala bikwisa kʉsookapo nʉ kʉbʉʉka kʉkʉkaba ɨngʉbɨlo bwila na bwila. Looli abagolofu bala bikwisa kʉbʉʉka kʉ bʉʉmi bwa bwila na bwila.” ");
INSERT INTO nyy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesu bo amalile ʉkʉjoba amasyʉ ago goosa, alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mumeenye ʉkʉtɨ bo gakɨndile amasikʉ mabɨlɨ, aatukʉja nɨ kyaka kya Pasa. Ʉne Nnyamundʉ ngwakʉbɨɨkigwa mmaboko agaa balʉgʉ, ʉkʉtɨ bangomelele pa kɨkohekano.” ");
INSERT INTO nyy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Akabalɨlo ako, abapuuti abalongosi na balongosi baa Bajuuta, balɨnkʉbʉngaana mu nyumba jaa mpuuti ʉnkʉlʉmba, ɨngamu jaake Kajafa. ");
INSERT INTO nyy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Balɨnkʉjobesania ɨsya kʉkʉnkola Jesu kʉ bʉkomu nʉ kʉnngoga. ");
INSERT INTO nyy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Looli balɨnkʉtɨ, “Tʉlɨngankolaga pa kyaka kya Pasa ʉkʉtɨ abandʉ balɨngiisa kʉlʉndʉkana.” ");
INSERT INTO nyy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Po Jesu aabʉʉkile mu Betanija, alɨnkwingɨla nnyumba jaa Simoni, ʉjʉ bantɨgɨ ʉNkoma. ");
INSERT INTO nyy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ʉnkiikʉlʉ jʉmo alɨnkwisa kʉmyake nɨ supa jaa mafuta agaa lʉʉma ʉlʉnunu, agaa ntengo ʉnnywamu fiijo, alɨnkʉmmoonelela pantʉ Jesu, bo alɨ pakʉlya. ");
INSERT INTO nyy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Abafundigwa baake bo basibwene ɨsyo, balɨnkʉkalala, balɨnkʉtɨ, “Mwe! Fiki ikʉbinika amafuta amanunu ago? ");
INSERT INTO nyy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kwalɨ kʉnunu ʉkʉʉlɨsya amafuta aga kʉ ndalama ɨnyingi, ɨndalama ɨsyo ngalɨ bikʉpeeligwa abalondo!” ");
INSERT INTO nyy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesu alɨnkʉsyagania ɨnyiinogono syabo, alɨnkʉbabʉʉla alɨnkʉtɨ, “Fiki mukʉntaamya ʉnkiikʉlʉ ʉjʉ? Aambombiile ɨmbombo ɨnunu ʉne. ");
INSERT INTO nyy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Abalondo mulɨ nabo amasikʉ goosa. Looli ʉne ndikʉja pakʉja pamopeene na nuumwe bwila. ");
INSERT INTO nyy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ʉnkiikʉlʉ ʉjʉ aanyooneliile amafuta aga ʉkʉtɨ agʉtendekesye ʉmbɨlɨ gwangʉ ʉkʉʉsyɨla kɨlɨngaani. ");
INSERT INTO nyy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nalooli nikʉbabʉʉla, poosa apa ɨNdʉmi ɨNunu ɨjaa Kyala jikʉlʉmbɨlɨligwaga pakiisʉ, ɨsi abombile ʉnkiikʉlʉ ʉjʉ, sikʉjobigwaga ʉkʉnkʉmbʉkɨlamo.” ");
INSERT INTO nyy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Po jʉmo mbafundigwa baa Jesu kalongo na babɨlɨ, ɨngamu Juuta Isikalyoti, alɨnkʉbʉʉka kʉ bapuuti abalongosi, ");
INSERT INTO nyy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mukʉmbapo ɨfiki lɨnga nʉntwele kʉmyɨnu?” Po balɨnkʉnhomba ɨndalama amalongo matatʉ. ");
INSERT INTO nyy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ʉkʉfuma akabalɨlo ako, Juuta Isikalyoti alɨnkwanda ʉkʉlonda ɨnjɨla ɨjaa kʉnndɨɨla Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pi isikʉ ɨlya kwanda ɨlya kyaka ɨkya fisyesye ɨfisita nkese, abafundigwa baake balɨnkʉbʉʉka kwa Jesu, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Tʉkakʉtendekekesye kʉʉgʉ ɨfindʉ fya Pasa?” ");
INSERT INTO nyy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Amubʉʉke nkaaja akaa Jelusalemu, kʉ mundʉ jʉla, mukwakʉmmbʉʉla ʉkʉtɨ ʉMmanyisi ikʉtɨ, ‘Akabalɨlo kangʉ kasegeliile. Nnyumba jaako mo muno ngʉlɨɨlamo ɨPasa pamopeene na bafundigwa bangʉ.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Abafundigwa balɨnkʉbomba bo muumo Jesu abalagiile, balɨnkʉtendekesya ɨfindʉ fya Pasa. ");
INSERT INTO nyy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ɨngiisi bo jikwanda, Jesu na bafundigwa baake kalongo na babɨlɨ, balɨnkʉtʉʉgala pakʉlya ɨfindʉ. ");
INSERT INTO nyy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bo balɨ pakʉlya, Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, jʉmo nkɨbugutɨla kyɨnu, ikʉʉndɨɨla.” ");
INSERT INTO nyy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Abafundigwa baake balɨnkʉsulumania fiijo, balɨnkwanda ʉkʉjoba jʉmoojʉmo balɨnkʉtɨ, “Gwe Ntwa, bʉle jo ʉne?” ");
INSERT INTO nyy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesu alɨnkʉtɨ, “Ʉjʉ ikʉtobela ɨkɨsyesye mu mposi pamopeene na niine, jo ʉjʉ ikʉʉndɨɨla. ");
INSERT INTO nyy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ʉne Nnyamundʉ, angʉfwa bo muno sisimbiigwe mwa Kalata ʉMwikemo. Looli ahɨɨli ʉmundʉ ʉjʉ ikʉʉndɨɨla ne Nnyamundʉ. Kwalɨ kʉnunu lɨnga ʉmundʉ ʉjo akaapaapiigwe!” ");
INSERT INTO nyy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Po Juuta ʉgwa kʉnndɨɨla Jesu, alɨnkʉtɨ, “Gwe Mmanyisi, bʉle jo ʉne?” Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Bo lɨlɨɨlyo ʉjobile.” ");
INSERT INTO nyy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bo balɨ pakʉlya, Jesu alɨnkwega ɨkɨsyesye, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉkɨmenya, alɨnkʉbapapo abafundigwa baake, alɨnkʉbabʉʉla alɨnkʉtɨ, “Namwege, mulyege, ʉgʉ go mbɨlɨ gwangʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Alɨnkwega ɨkɨkombe ɨkya finga, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉbapapo, alɨnkʉbabʉʉla alɨnkʉtɨ, “Namunwege ɨfinga ɨjɨ mwesa, ");
INSERT INTO nyy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","namanga ɨlɨ lyo ilopa lyangʉ ɨlya kʉnangɨsya ʉlwitɨkano lwa Kyala. Likooneka kʉnongwa jaa bandʉ bingi ʉkʉtɨ Kyala abahobokele ʉbʉtʉlanongwa bwabo. ");
INSERT INTO nyy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Looli nikʉbabʉʉla nikʉtɨ, ndikwisa kʉnwamo kangɨ ɨfinga ɨjɨ mpaka pi isikʉ lɨla, ɨlɨ angwisa kʉnwa ɨfinga ɨmbya pamopeene na nuumwe, mBʉnyafyale bwa Taata.” ");
INSERT INTO nyy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bo bɨmbile ʉlwɨmbo, balɨnkʉsookapo ʉkʉbʉʉka kʉ Kyamba kya Misyʉngʉtɨ. ");
INSERT INTO nyy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Po Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Pakɨlo kya lɨɨlɨno, ʉmwe mwesa mukʉʉndeka. Paapo sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ngwisa kʉnkoma ʉntiimi, po ɨngʼoosi sikwisa kʉbalanila.’ ");
INSERT INTO nyy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Looli bo nsyʉkile, ngʉbatalɨlapo ʉkʉbʉʉka kʉ Galilai.” ");
INSERT INTO nyy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Po Peeteli alɨnkʉnkaanika Jesu alɨnkʉtɨ, “Nalɨnga boosa bikʉkʉleka, ʉne ndikʉkʉleka sikʉ!” ");
INSERT INTO nyy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Nalooli nikʉkʉbʉʉla ʉgwe, ɨkɨlo ɨkɨ, bo ɨngongobe jɨkaalɨ ʉkʉkoolela, kʉngaana katatʉ.” ");
INSERT INTO nyy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peeteli alɨnkʉmmwamula alɨnkʉtɨ, “Nalɨnga ko kʉfwa pamopeene na nungwe, ndikʉkʉkaana sikʉ!” Abafundigwa baake boosa balɨnkʉjoba bo lɨlɨɨlyo. ");
INSERT INTO nyy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Po Jesu alɨnkʉfika pamopeene na bafundigwa baake, pabʉjo ʉbwa mipiki ɨgya misyʉngʉtɨ, ʉbʉ bikʉtɨ Getisemani, alɨnkʉbabʉʉla alɨnkʉtɨ, “Namutʉʉgale papaapa, ʉne ngʉbʉʉka pala pakwipuuta.” ");
INSERT INTO nyy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Alɨnkʉbeega Peeteli na baana babɨlɨ abaa Sebetai, alɨnkʉsulumania nʉ kʉtaamigwa fiijo mu ndumbula jaake. ");
INSERT INTO nyy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Po alɨnkʉbabʉʉla alɨnkʉtɨ, “Ɨndumbula jangʉ jɨsulumeenie ʉlwa kʉfwa. Namutʉʉgale papaapa, muje maaso pamopeene na niine.” ");
INSERT INTO nyy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Alɨnkʉsemapo nkyeni panandɨ, alɨnkʉgwa ʉlʉpi, alɨnkwipuuta alɨnkʉtɨ, “Gwe Taata! Lɨnga sibagiile, ngʉkʉsʉʉma ʉʉsookesyepo ɨngʉbɨlo ɨsi. Leelo bʉlɨngabombigwa ʉbwigane bwangʉ, looli ʉbwako.” ");
INSERT INTO nyy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Po Jesu alɨnkʉbʉʉka kʉ bafundigwa baake, alɨnkʉbaaga bagonile ʉtʉlo. Alɨnkʉbabʉʉla baa Peeteli alɨnkʉtɨ, “Keeta mutoliigwe ʉkʉja maaso pamopeene na niine kʉkabalɨlo akanandɨ itolo? ");
INSERT INTO nyy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mujege maaso, mwipuutege, ʉkʉtɨ mulɨngiisa kʉtoligwa nɨ ngelo. Mwiganile ʉkʉbomba kanunu, looli mukaja na maka.” ");
INSERT INTO nyy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesu alɨnkʉbʉʉka kangɨ ʉlwa bʉbɨlɨ, alɨnkwipuuta alɨnkʉtɨ, “Gwe Taata, lɨnga ɨngʉbɨlo ɨsi sikabagɨla ʉkʉsookako kʉmyangʉ, po ʉbwigane bwako bʉbombigwe.” ");
INSERT INTO nyy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Po alɨnkwisa, kangɨ alɨnkʉbaaga bagonile ʉtʉlo, paapo amaaso gaabo gaalɨ nʉ tʉlo twingi. ");
INSERT INTO nyy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesu alɨnkʉbaleka kangɨ, alɨnkʉbʉʉka alɨnkwipuuta ʉlwa bʉtatʉ, alɨnkʉjoba amasyʉ galagala. ");
INSERT INTO nyy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Po alɨnkwisa kʉ bafundigwa baake, alɨnkʉbabʉʉla alɨnkʉtɨ, “Mukaalɨ mukʉgona ʉtʉlo nʉ kʉtʉʉsya? Akabalɨlo kafikile! Keeta, ne Nnyamundʉ angʉbɨɨkigwa mmaboko agaa bandʉ ababiibi. ");
INSERT INTO nyy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Amusumuke! Tʉbʉʉke. Keeta, ʉndɨɨli gwangʉ asegeliile.” ");
INSERT INTO nyy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesu bo akaalɨ ikʉjoba, nakalɨnga alɨnkʉfika Juuta Isikalyoti, ʉgwa ndɨ bala kalongo na babɨlɨ, alɨnkwisa pamopeene nɨ kɨlʉndɨlo ɨkɨnywamu kya bandʉ aba baakolile ɨnyʉʉbo nɨ nduuha. Abandʉ abo baafumile kʉ bapuuti abalongosi na balongosi baa Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Juuta bo akaalɨ ʉkʉfika kwa Jesu, aababʉʉlile kɨlɨngaani ɨkɨmanyilo aatile, “Ʉjʉ ngwakʉmfipa, jo jʉʉjo, mukankole.” ");
INSERT INTO nyy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nakalɨnga, Juuta alɨnkʉbʉʉka kwa Jesu, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwe Mmanyisi, ʉgonile!” Po alɨnkʉmfipa. ");
INSERT INTO nyy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Mmanyaani, gwisile kʉkʉbomba syene ɨsi?” Po abandʉ bala balɨnkʉbʉʉka kwa Jesu, balɨnkʉnkola. ");
INSERT INTO nyy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Po jʉmo mbafundigwa baake Jesu, alɨnkʉkwaba ʉlʉʉbo, alɨnkʉnsenga ɨmbʉlʉkʉtʉ ʉntʉmwa gwa mpuuti ʉnkʉlʉmba. ");
INSERT INTO nyy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Po Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gomosya ʉlʉʉbo lwako mu nyambɨ jaake, paapo abandʉ boosa aba bikʉbombela ʉlʉʉbo, aabikʉfwa kʉ lʉʉbo. ");
INSERT INTO nyy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bʉle, mukamanya ʉkʉtɨ mbagiile ʉkʉsʉʉma ʉbʉtʉʉli kwa Taata? Nakalɨnga aabagiile ʉkʉndwalɨla lʉlʉʉlʉ abandʉmi baake, ɨfilʉndɨlo ɨfinywamu kalongo na fibɨlɨ nʉ kʉkɨndapo. ");
INSERT INTO nyy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Leelo lɨnga mbombile bo ʉlo, sikʉbombigwa bʉleebʉle ɨsi sisimbiigwe mwa Kalata ʉMwikemo, ʉkʉtɨ mo muno sikʉlondeligwa ʉkʉja?” ");
INSERT INTO nyy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Po Jesu alɨnkʉbabʉʉla abandʉ bala alɨnkʉtɨ, “Bʉle, mwisile mukolile ɨnyʉʉbo nɨ nduuha ngatɨ mukʉlɨkola inyambuta? Bwila naatʉʉgalaga ndʉpaso lwa tempeli, naamanyisyaga, mukaalɨngolilemo sikʉ! ");
INSERT INTO nyy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Leelo ɨsi silɨ bo ʉlʉ, ʉkʉtɨ siboneke ɨsi abakunguluka baasimbile mwa Kalata ʉMwikemo.” Po abafundigwa baake boosa balɨnkʉnndeka Jesu, balɨnkʉbopa. ");
INSERT INTO nyy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Po abandʉ aba baalɨnkolile Jesu, balɨnkʉntwala kwa Kajafa ʉmpuuti ʉnkʉlʉmba, kʉno baabʉngeene abamanyisi baa ndagɨlo sya Moose na balongosi baa Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peeteli alɨnkʉnkonga Jesu pabʉtalipo, mpaka nkatɨ ndʉpaso lwa nnyumba jaa mpuuti ʉnkʉlʉmba. Po alɨnkʉtʉʉgala pamopeene na balɨndɨlɨli, ʉkʉtɨ akeete muno sikʉmalɨkɨlaga. ");
INSERT INTO nyy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Po paapo abapuuti abalongosi bala na baa lʉkomaano lwa Sanihendilini boosa, baalondaga ʉbʉkeeti ʉbwa bʉtʉngʉlʉ ʉkʉtɨ bajaage ɨnjɨla ɨjaa kʉnngoga Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Looli bakaabwagile ʉbʉkeeti nabʉmo na paalema baaliisile abakeeti bingi abaa bʉtʉngʉlʉ. Po kʉmmalɨɨkɨsyo balɨnkwisa abakeeti babɨlɨ balɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Ʉmundʉ ʉjʉ aajobile ʉkʉtɨ, ‘Mbagiile ʉkoomola ɨtempeli jaa Kyala nʉ kʉjɨjenga kangɨ kʉ masikʉ matatʉ.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Po ʉmpuuti ʉnkʉlʉmba alɨnkwɨma, alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Ʉkʉkongana na ɨsi abandʉ aba bikʉkʉsitaaka ʉgwe, bʉle ʉtikwamula nalɨmo?” ");
INSERT INTO nyy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Looli Jesu akaalɨmmwamwile nalɨmo. Po ʉmpuuti ʉnkʉlʉmba alɨnkʉmmbʉʉla kangɨ alɨnkʉtɨ, “Nikʉkʉbʉʉla ʉlape mu ngamu jaa Kyala ʉMʉʉmi, tʉbʉʉle lɨnga ʉgwe gwe Meesija, ʉMwana gwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Bo lɨlɨɨlyo ʉjobile. Looli nikʉbabʉʉla mwesa, ʉkwandɨla lɨɨlɨno aamukʉʉmbona ne Nnyamundʉ ndʉʉgeele kʉmwanya, pabʉjo ʉbwɨmɨkigwa, kʉkɨbafu ɨkiilɨɨlo ɨkya Kyala ʉMwene maka, bo ngwisa mmabɨngo agaa kʉmwanya.” ");
INSERT INTO nyy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Po ʉmpuuti ʉnkʉlʉmba bo apɨliike amasyʉ ago, alɨnkʉnyaafulania ɨmyenda gyake ʉkʉnangɨsya ʉbʉkalale, alɨnkʉtɨ, “Ikʉntʉka Kyala! Po tukʉbʉlonda ʉbʉkeeti bwa fiki? Mupɨliike muno antʉkiile Kyala! ");
INSERT INTO nyy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mukʉtɨ fiki ʉmwe?” Balɨnkwamula balɨnkʉtɨ, “Ikʉlondigwa agogigwe!” ");
INSERT INTO nyy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Po bamo balɨnkʉnswela amata kʉmaaso, balɨnkʉmmbulɨka nɨ fibuli, bamo balɨnkʉnkoma na mapi, ");
INSERT INTO nyy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","balɨnkʉtɨ, “Gwe Meesija, kunguluka! Jo jwani akʉkomile?” ");
INSERT INTO nyy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Akabalɨlo kalakala Peeteli aatʉʉgeele panja ndʉpaso. Po ʉmbombi jʉmo ʉndɨndwana alɨnkwisa kwa Peeteli, alɨnkʉtɨ, “Na nungwe gwalɨ pamopeene na Jesu ʉgwa mu Galilai.” ");
INSERT INTO nyy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Looli Peeteli alɨnkʉkaana nkyeni ndɨ bala boosa alɨnkʉtɨ, “Ngasimanya ɨsi kʉjoba!” ");
INSERT INTO nyy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Po alɨnkʉsookapo pala, alɨnkʉbʉʉka kʉ kɨfigo. Apo ʉmbombi ʉjʉngɨ ʉndɨndwana alɨnkʉmmbona, alɨnkʉbabʉʉla abandʉ aba baalipo pala alɨnkʉtɨ, “Ʉmundʉ ʉjʉ aalɨ pamopeene na Jesu ʉNnasaleti.” ");
INSERT INTO nyy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peeteli alɨnkʉkaana kangɨ, alɨnkʉlapa alɨnkʉtɨ, “Ngammanya ʉmundʉ ʉjo!” ");
INSERT INTO nyy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Akabalɨlo bo kakɨndilepo panandɨ, abandʉ aba baalipo pala balɨnkwisa kwa Peeteli, balɨnkʉmmbʉʉla balɨnkʉtɨ, “Nalooli ʉgwe ʉlɨ mwinaabo, paapo nʉ bʉjobi bwako bukʉkʉnangɨsya!” ");
INSERT INTO nyy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Peeteli alɨnkwanda ʉkʉguna nʉ kʉlapa, alɨnkʉtɨ, “Ngammanya ʉmundʉ ʉjo!” Nakalɨnga ɨngongobe jɨlɨnkʉkoolela. ");
INSERT INTO nyy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Po Peeteli alɨnkʉlɨkʉmbʉka iisyʉ ɨlɨ aajobile Jesu ʉkʉtɨ, “Ɨngongobe bo jɨkaalɨ ʉkʉkoolela, kʉngaana katatʉ.” Po alɨnkʉsooka panja, alɨnkʉlɨla fiijo. ");
INSERT INTO nyy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nʉlʉbʉnjʉ fiijo, abapuuti abalongosi boosa na balongosi baa Bajuuta, balɨnkʉtumula ɨnongwa jaa Jesu, ʉkʉtɨ banngoge. ");
INSERT INTO nyy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Po balɨnkʉmpinya, balɨnkʉntwala kʉ ndongosi gwa kiisʉ, ɨngamu jaake Pilati. ");
INSERT INTO nyy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Po Juuta ʉndɨɨli, bo aagile ʉkʉtɨ Jesu alongiigwe ʉkʉtɨ agogigwe, alɨnkwibona nsobi. Alɨnkwega ɨndalama sila amalongo matatʉ, alɨnkʉbʉʉka kʉkʉbagomokesya abapuuti abalongosi na balongosi baa Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Ndʉlile ɨnongwa ʉkʉnndɨɨla ʉmundʉ ʉjʉ akaja na nongwa najɨmo.” Looli abeene balɨnkʉtɨ, “Ɨsyo sitikʉtʉtʉʉla ʉswe, silɨ mmaboko gaako jʉjʉʉgwe.” ");
INSERT INTO nyy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Po Juuta alɨnkʉsitaaga ɨndalama sila ndʉpaso lwa tempeli, alɨnkʉsookapo, alɨnkwakwitʉlɨka. ");
INSERT INTO nyy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Abapuuti abalongosi balɨnkwega ɨndalama sila, balɨnkʉtɨ, “Mwiko ʉkʉsibɨɨka ɨndalama ɨsi ʉkʉja ikemo lya tempeli, namanga ɨsi ndalama sya ilopa.” ");
INSERT INTO nyy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Po balɨnkʉjobesania, balɨnkʉʉlɨla ʉngʉnda ʉgwa mbʉmba ndeko, ʉkʉtɨ bʉjege bʉjo bwa kʉbasyɨlamo aba bakaja benekaaja. ");
INSERT INTO nyy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Fyobeene ʉngʉnda ʉgo, ɨngamu jaake bikʉtɨ Ngʉnda gwa Ilopa mpaka lɨɨlɨno. ");
INSERT INTO nyy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Po silɨnkʉbonekelamo ɨsi syajobiigwe nʉ nkunguluka Jelemija ʉkʉtɨ, “Baalyegile ɨndalama amalongo matatʉ, ʉntengo ʉgwa mundʉ ʉgʉ aBanyaisilaɨli baaliitɨkeene. ");
INSERT INTO nyy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Balɨnkʉʉlɨla ʉngʉnda ʉgwa mbʉmba ndeko bo muno ʉNtwa aalɨɨndagiile ʉne.” ");
INSERT INTO nyy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Po Jesu alɨnkwɨma nkyeni mu ndongosi gwa kiisʉ, ʉndongosi ʉjo alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Bʉle, ʉgwe ʉlɨ Malafyale gwa Bajuuta?” Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Bo lɨlɨɨlyo ʉjobile.” ");
INSERT INTO nyy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Looli abapuuti abalongosi na balongosi baa Bajuuta, balɨnkʉnsitaaka kwa Pilati ʉndongosi gwa kiisʉ, looli ʉmwene akaalyamwile iisyʉ nalɨmo. ");
INSERT INTO nyy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Po Pilati alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Bʉle, ʉtikʉsipɨlɨka syosa ɨsi bikʉkʉsitaaka?” ");
INSERT INTO nyy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Looli Jesu akaalyamwilepo ni isyʉ lɨmo. Po Pilati alɨnkʉswiga fiijo. ");
INSERT INTO nyy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Po lwalɨ lwiho lwa ndongosi gwa kiisʉ, pa kyaka kya Pasa, ʉkʉmmwabʉla ʉmpinyigwa jʉmo, ʉjʉ abandʉ baalondaga ʉkʉtɨ aabʉligwe. ");
INSERT INTO nyy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Po akabalɨlo ako, aaliko ʉmpinyigwa jʉmo ʉmfumuke, ɨngamu jaake Balaba. ");
INSERT INTO nyy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Abandʉ bo babʉngeene, Pilati alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Jo jwani ʉjʉ mukʉlonda mbaabʉlɨle? Bʉle, mbaabʉlɨle Balaba, pamo Jesu, ʉjʉ bikʉtɨ Meesija?” ");
INSERT INTO nyy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilati aabalaalʉʉsiisye bo ʉlo paapo aasyageenie ʉkʉtɨ baalɨntwele Jesu kʉmyake kʉ bʉʉfi itolo. ");
INSERT INTO nyy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilati bo atʉʉgeele pa kɨkota kyake ɨkya bʉlongi, ʉnkasi alɨnkʉntʉmɨla ɨndʉmi alɨnkʉtɨ, “Ʉlɨngammbombelaga nasimo ʉmundʉ ʉjo, akatʉla ɨnongwa najɨmo. Ɨkɨlo ɨkɨ ndaamiigwe fiijo mu njosi kʉnongwa jaake.” ");
INSERT INTO nyy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Looli abapuuti abalongosi na balongosi baa Bajuuta, balɨnkʉbasonga abandʉ ʉkʉtɨ bansʉʉme Pilati, abaabʉlɨle Balaba nʉ kʉnndonga Jesu ʉkʉtɨ agogigwe. ");
INSERT INTO nyy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilati alɨnkʉbalaalʉʉsya kangɨ alɨnkʉtɨ, “Jo jwani ʉjʉ mukʉlonda mbaabʉlɨle mbapinyigwa aba babɨlɨ?” Balɨnkʉtɨ, “Balaba.” ");
INSERT INTO nyy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilati alɨnkʉbalaalʉʉsya kangɨ alɨnkʉtɨ, “Po ndʉbʉlege na Jesu ʉjʉ bikʉtɨ jo Meesija?” Abandʉ boosa balɨnkʉlaata balɨnkʉtɨ, “Nkomelele pa kɨkohekano!” ");
INSERT INTO nyy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilati alɨnkʉbalaalʉʉsya kangɨ alɨnkʉtɨ, “Fiki? Abombile mbiibi nki?” Looli abeene balɨnkʉkɨndɨlɨla ʉkʉlaata balɨnkʉtɨ, “Nkomelele pa kɨkohekano!” ");
INSERT INTO nyy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilati bo asyageenie ʉkʉtɨ akabagɨla ʉkwandʉla ɨnyiinogono syabo, looli bandile ʉkʉlʉndʉkana, alɨnkwega amɨɨsi, alɨnkʉsugusula amaboko gaake nkyeni mmyabo, alɨnkʉtɨ, “Ngaja na nongwa najɨmo kwi ilopa lya mundʉ ʉjʉ. Ɨsi syɨnu jʉjʉʉmwe!” ");
INSERT INTO nyy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Abandʉ boosa balɨnkʉmmwamula balɨnkʉtɨ, “Ɨnongwa ɨjaa kʉnngoga Jesu jɨjege jɨɨtʉ ʉswe na baanɨɨtʉ!” ");
INSERT INTO nyy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Po Pilati alɨnkʉbaabʉlɨla Balaba, alɨnkʉlagɨla ʉkʉtɨ Jesu akomigwe nɨ fingoti, po alɨnkʉnsoosya ʉkʉtɨ bankomelele pa kɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Po abasikali abaa ndongosi gwa kiisʉ balɨnkʉmmwega Jesu, balɨnkʉbʉʉka nagwe ndʉpaso lwa nyumba jaa kɨtangaalala kya Pilati. Ɨkɨlʉndɨlo kyosa ɨkya basikali balɨnkʉnsyʉngʉʉtɨla Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Balɨnkʉmfuula ɨmyenda gyake nʉ kʉmfwɨka ʉnselekesye ʉnkeseefu. ");
INSERT INTO nyy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Balɨnkʉtendekesya ɨngɨga ɨjaa miifwa, balɨnkʉmfwɨka muntʉ, ni ilaasi balɨnkʉmmbɨɨkɨla kʉ kɨboko kyake ɨkiilɨɨlo. Balɨnkʉfugama nkyeni mmyake, balɨnkʉmmoobela balɨnkʉtɨ, “Ʉgonile, gwe Malafyale gwa Bajuuta!” ");
INSERT INTO nyy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Po balɨnkʉnswela amata, balɨnkwega iilaasi lɨla, balɨnkʉnkoma koma nalyo muntʉ. ");
INSERT INTO nyy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bo bamalile ʉkʉmmwangalɨla, balɨnkʉmfuula ʉnselekesye gʉla, balɨnkʉmfwɨka kangɨ ɨmyenda gyake. Po balɨnkʉsooka panja nagwe, balɨnkʉntwala kʉkʉnkomelela pa kɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jesu na basikali bo bikʉsooka, balɨnkʉmmwaga mu njɨla ʉmundʉ jʉmo, ɨngamu jaake Simoni, ʉgwa nkaaja akaa mu Kilene. Abasikali bala balɨnkʉnkola, balɨnkʉmfimbɨlɨsya ʉkʉmpɨmbɨla Jesu ɨkɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Po balɨnkʉfika pabʉjo ʉbʉ bikʉtɨ Goligota, kokʉtɨ ʉLʉpaja lwa Ntʉ. ");
INSERT INTO nyy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Balɨnkʉmpapo ɨfinga ɨjɨ baalyongeenie nʉ nkota mila, ʉgwa kʉpungusya ʉkʉbaba, looli bo onjile, aakaanile ʉkʉnwa. ");
INSERT INTO nyy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Balɨnkʉnkomelela pa kɨkohekano, balɨnkʉjabana ɨmyenda gyake kʉ njɨla jaa bʉlagʉsi. ");
INSERT INTO nyy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Po balɨnkʉtʉʉgala, balɨnkʉnndɨndɨlɨla. ");
INSERT INTO nyy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pamwanya pantʉ gwake, baasimbile ɨnongwa ɨjɨ baalɨnngogiile ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Po abanyambuta babɨlɨ boope baabakomeliile pa fikohekano, pamopeene nagwe, jʉmo kʉkɨbafu ɨkiilɨɨlo nʉ jʉngɨ kʉkɨbafu ɨkiimama. ");
INSERT INTO nyy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Abandʉ aba bendaga pala, baasukaaniaga ɨmitʉ ʉkʉmmwilaamwa. ");
INSERT INTO nyy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Baatɨgɨ, “Oho! Gwe mpangʉla tempeli nʉ kʉjɨjenga kangɨ kʉ masikʉ matatʉ, gwipoke gwimwene! Lɨnga ʉgwe ʉlɨ Mwana gwa Kyala, gwipoke gwimwene! Ika pa kɨkohekano!” ");
INSERT INTO nyy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bo lʉlʉʉlo na bapuuti abalongosi, na bamanyisi baa ndagɨlo sya Moose, pamopeene na balongosi baa Bajuuta bammoobelaga, ");
INSERT INTO nyy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","baatɨgɨ, “Aabapokaga abangɨ, looli ʉmwene akabagɨla ʉkwipoka! Lɨnga jo Malafyale gwa Banyaisilaɨli, oko asuluke ʉlʉ pa kɨkohekano, po aatukʉmmwitɨka. ");
INSERT INTO nyy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ikʉnsʉʉbɨla Kyala, po ampoke ʉlʉ, lɨnga ikʉnndonda, paapo aajobaga ʉkʉtɨ, ‘Ʉne ndɨ Mwana gwa Kyala.’ ” ");
INSERT INTO nyy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Boope abanyambuta aba baakomeleliigwe pamopeene na Jesu, balɨnkʉntʉka. ");
INSERT INTO nyy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ʉkwandɨla ɨsala jaa 6:00 pamuusi, ɨngiisi jɨlɨnkʉgwa nkiisʉ kɨla kyosa, mpaka ɨsala jaa 9:00. ");
INSERT INTO nyy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Po ɨsala jaa 9:00 bʉno, Jesu alɨnkʉlaata ʉkʉkoolela alɨnkʉtɨ, “Eloi! Eloi! Lama sabakitani?” Kokʉtɨ, “Kyala gwangʉ! Kyala gwangʉ! Fiki ʉʉndekile?” ");
INSERT INTO nyy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Abandʉ bamo aba baalyɨmile pala, bo bapɨliike ɨsi balɨnkʉtɨ, “Ʉjʉ ikʉmmbɨlɨkɨla Elija.” ");
INSERT INTO nyy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nakalɨnga jʉmo mbasikali bala, alɨnkʉbopa, alɨnkʉjubɨka ɨsipanji mu finga ɨngalɨ, ɨjɨ jɨlʉlile, alɨnkʉfyɨka kʉ lʉtete, alɨnkʉmpapo ʉkʉtɨ anwe. ");
INSERT INTO nyy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Abangɨ bala balɨnkʉtɨ, “Nndeke! Tʉkeete lɨnga Elija ikwisa kʉkʉmpoka.” ");
INSERT INTO nyy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Po paapo Jesu alɨnkʉlaata ʉkʉkuuta kangɨ kʉ maka, alɨnkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nakalɨnga, ɨliibaalɨka lya tempeli lɨlɨnkʉnyaafuka pakatɨ na pakatɨ, ʉkʉfuma kʉmwanya mpaka paasi. Ɨkiisʉ kɨlɨnkʉsenyendeka, ɨnyaalabwe silɨnkʉpasʉkana. ");
INSERT INTO nyy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Amapʉmba galɨnkwigʉka, ɨmibɨlɨ mingi ɨgya biikemo aba baafwile, balɨnkʉsyʉka, ");
INSERT INTO nyy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","balɨnkʉsooka mmapʉmba gaabo. Jesu bo asyʉkile, balɨnkwingɨla nkaaja akaa mu Jelusalemu, balɨnkʉboneka kʉ bandʉ bingi. ");
INSERT INTO nyy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Po ʉndongosi gwa basikali, pamopeene na aba banndɨndɨlɨlaga Jesu, bo bakabwene akasenyenda na ɨsi siboniike, balɨnkʉtiila fiijo, balɨnkʉjoba balɨnkʉtɨ, “Nalooli ʉmundʉ ʉjʉ aalɨ Mwana gwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Baalipo abakiikʉlʉ bingi pala, aba baalongoseenie na Jesu ʉkʉfuma mu Galilai, bo aba bammbombelaga. Abo baakeetaga syosa ɨsyo ʉkʉfuma pabʉtali. ");
INSERT INTO nyy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mbakiikʉlʉ abo, aalimo Malija ʉgwa kʉ Magatala, Malija ʉnna gwa Jaakobo na Joosefu, nʉ nna gwa baana baa Sebetai. ");
INSERT INTO nyy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Amajolo bo gafikile, alɨnkwisa ʉmundʉ jʉmo ʉnkabi ʉkʉfuma mu Alimatai, ɨngamu jaake Joosefu. Ʉjo joope aalɨ mfundigwa gwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Joosefu alɨnkʉbʉʉka kwa Pilati, alɨnkʉsʉʉma ʉmfimba gwa Jesu, akasyɨle. Po Pilati alɨnkʉlagɨla ʉkʉtɨ bampepo. ");
INSERT INTO nyy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joosefu alɨnkʉbʉʉka, alɨnkwega ʉmfimba gwa Jesu, alɨnkʉgʉniembeteelela mmwenda ʉmwelu. ");
INSERT INTO nyy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Alɨnkʉgʉbɨɨka mwi ipʉmba lyake ɨlɨ bakaalɨnsyɨlilemo ʉmundʉ najʉmo, lyasongoleliigwe kɨlɨngaani ndwalabwe. Po alɨnkʉbungulukɨsyapo iibwe iinywamu pa kɨfigo ɨkya ipʉmba, alɨnkʉsookapo. ");
INSERT INTO nyy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Panja baatʉʉgeele Malija ʉgwa kʉ Magatala na Malija ʉnna gwa Jaakobo na Joosefu, baakeetile kwi ipʉmba. ");
INSERT INTO nyy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kɨlaabo kyake lyalɨ isikʉ ɨlya pa Sabati. Po abapuuti abalongosi na Bafalisai balɨnkʉbʉngaana kwa Pilati. ");
INSERT INTO nyy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Balɨnkʉtɨ, “Gwe ntwa, tukʉkʉmbʉka ʉkʉtɨ ʉnsyobi jʉla, aajobile bo mʉʉmi ʉkʉtɨ, ‘Amasikʉ matatʉ bo gakɨndile angʉsyʉka.’ ");
INSERT INTO nyy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Po ʉlagɨle ʉkʉtɨ iipʉmba lɨlɨndɨlɨliigwe kanunu, mpaka pi isikʉ lya bʉtatʉ, abafundigwa baake bangiisa kwiba ʉmfimba gwake nʉ kʉbabʉʉla abandʉ ʉkʉtɨ asyʉkile mbʉfwe. Ʉbʉsyobi ʉbʉ ʉbwa kʉmmalɨɨkɨsyo aabukʉja bʉbiibi ʉkʉbʉkɨnda ʉbwa kwanda.” ");
INSERT INTO nyy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilati alɨnkʉbabʉʉla alɨnkʉtɨ, “Mulɨ nabo abasikali, namubeege mukalɨndɨlɨle iipʉmba kanunu bo muno mwiganiile ʉmwe.” ");
INSERT INTO nyy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Po balɨnkʉbʉʉka kwi ipʉmba, balɨnkʉbɨɨka ɨkɨkolekelo pi ibwe, nʉ kʉbabɨɨka abasikali abaa kʉlɨndɨlɨla. ");
INSERT INTO nyy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Po iisikʉ ɨlya pa Sabati bo lɨkɨndile, nʉlʉbʉnjʉ fiijo pi isikʉ ɨlya pa ndʉngʉ, Malija ʉgwa kʉ Magatala na Malija ʉjʉngɨ balɨnkʉbʉʉka kʉkʉlɨkeeta iipʉmba. ");
INSERT INTO nyy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Keeta, akasenyenda akanywamu kalɨnkʉkɨnda, paapo ʉgwandʉmi gwa Ntwa aasulwike ʉkʉfuma kʉmwanya, aalɨbungulwisye iibwe lɨla nʉ kʉlɨtʉʉgalɨla. ");
INSERT INTO nyy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kʉmaaso aalangalaga bo ɨkɨmweku ɨkya njasi, nɨ myenda gyake gyalɨ myelu fiijo. ");
INSERT INTO nyy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Abalɨndɨlɨli balɨnkʉntiila fiijo, balɨnkʉtetema, balɨnkʉja bo ʉlwa bafwe. ");
INSERT INTO nyy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Looli ʉgwandʉmi jʉla alɨnkʉbabʉʉla abakiikʉlʉ bala alɨnkʉtɨ, “Ʉmwe mulɨngatiilaga! Mmeenye ʉkʉtɨ mukʉnndonda Jesu ʉjʉ aakomeleliigwe pa kɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Akajapo apa! Asyʉkile, bo muno aababʉʉlile. Isaga mukeete apa baalɨnndambaliike. ");
INSERT INTO nyy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Po namubʉʉke mbɨmbɨbɨ mukababʉʉle abafundigwa baake ʉkʉtɨ, ‘Asyʉkile mbʉfwe, ikʉbatalɨla ʉkʉbʉʉka kʉ Galilai. Ʉko ko mukwakʉmmbonaga.’ Ʉne mbabʉʉlile!” ");
INSERT INTO nyy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Po abakiikʉlʉ bala balɨnkʉsookapo mbɨmbɨbɨ pi ipʉmba, kʉ lʉtende nʉ lʉsekelo ʉlʉnywamu. Balɨnkʉbopa ʉkʉbʉʉka kʉkʉbabʉʉla abafundigwa baa Jesu ɨnongwa ɨsyo. ");
INSERT INTO nyy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nakalɨnga, Jesu alɨnkwaganila nabo, alɨnkʉtɨ, “Mugonile!” Po balɨnkʉsegelela, balɨnkʉfugama, balɨnkʉnkola amalʉndɨ, balɨnkʉmmwipuuta. ");
INSERT INTO nyy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mulɨngatiilaga. Namubʉʉke mukababʉʉle abakamu bangʉ, babʉʉke mu Galilai, ʉko bikwakʉʉmbona.” ");
INSERT INTO nyy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Abakiikʉlʉ bala bo balɨ mu njɨla bikʉbʉʉka, abasikali bamo aba baalɨndɨlɨlaga iipʉmba lya Jesu balɨnkʉbʉʉka nkaaja, balɨnkʉbabʉʉla abapuuti abalongosi syosa ɨsi siboniike. ");
INSERT INTO nyy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Po abapuuti abalongosi bala balɨnkʉbʉngaana na balongosi baa Bajuuta, balɨnkʉjobesania, balɨnkʉbapa ɨndalama ɨnyingi abasikali bala. ");
INSERT INTO nyy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Balɨnkʉbabʉʉla balɨnkʉtɨ, “Mujobege mutɨgɨ, ‘Abafundigwa baake biisile kʉkwiba ʉmbɨlɨ gwake pakɨlo, ʉswe bo tʉgonile ʉtʉlo.’ ");
INSERT INTO nyy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Lɨnga Pilati ikʉpɨlɨka ɨsyo, ʉswe aatukʉjoba nagwe ʉkʉtɨ ʉmwe mulɨngiisa kʉkaba ʉbʉtolwe.” ");
INSERT INTO nyy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Po abasikali balɨnkwambɨlɨla ɨndalama sila, balɨnkʉbabʉʉla abandʉ bo muno baamanyisiigwe na balongosi baa Bajuuta. Ɨnongwa ɨsyo silɨnkʉbalanila fiijo pakatɨ pa Bajuuta mpaka lɨɨlɨno. ");
INSERT INTO nyy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Po abafundigwa baa Jesu bala kalongo na jʉmo, balɨnkʉbʉʉka mu Galilai kʉ kyamba kʉno Jesu aabalagiile. ");
INSERT INTO nyy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ʉko baalɨmmbwene, balɨnkʉmmwipuuta, leelo bamo balɨnkwilaamwa. ");
INSERT INTO nyy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Po Jesu alɨnkʉsegelela kʉmyabo alɨnkʉbabʉʉla alɨnkʉtɨ, “Mbeeliigwe na Kyala amaka goosa, agaa kʉmwanya na gaa pakiisʉ. ");
INSERT INTO nyy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Po namubʉʉkege mukabapelege abandʉ baa mfikolo fyosa, ʉkʉja bafundigwa bangʉ. Mukaboosyege mu ngamu jaa Taata Kyala, ɨjaa Mwana nɨ jaa Mbepo Mwikemo. ");
INSERT INTO nyy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mukabamanyisyege ʉkʉsikonga syosa ɨsi naabalagiile ʉmwe. Keeta, ʉne ngʉjaga pamopeene na nuumwe amasikʉ goosa, mpaka pi isikʉ ɨlya kʉmmalɨɨkɨsyo.”");
INSERT INTO nyy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ʉbʉ bo bwandɨlo bwa Ndʉmi ɨNunu ɨjaa Jesu Kɨlɨsiti, ʉMwana gwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bo muno sisimbiigwe mwa kalata gwa nkunguluka Jeesaja ʉkʉtɨ, “Keeta, ʉne nikʉntʉma ʉgwandʉmi gwangʉ, akʉtalɨlepo nkyeni mmyako, jo ikʉjɨtendekesya ɨnjɨla jaako.” ");
INSERT INTO nyy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Ɨliisyʉ lya mundʉ likʉkoolela ndʉngalangala likʉtɨ, ‘Mutendekesye ʉnsebo ʉgwa kwendamo ʉNtwa! Mugolosye ɨnjɨla syake!’ ” ");
INSERT INTO nyy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ʉmundʉ ʉjo jo Johani ʉMoosi. Alɨnkʉboneka ndʉngalangala, aabalʉmbɨlɨlaga abandʉ ʉkʉtɨ bapɨndʉke, boosigwe, po Kyala ikʉbahobokela ʉbʉtʉlanongwa bwabo. ");
INSERT INTO nyy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Abandʉ ʉkʉfuma mu Jelusalemu na baa nkiisʉ kyosa ɨkya Jutai baabʉʉkaga kwa Johani. Biilaataga ɨmbiibi syabo, ʉmwene aaboosyaga ndwɨsi Jolitani. ");
INSERT INTO nyy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johani aafwalaga ʉnselekesye gwa lʉsyoja lwa ngamila nʉ kwipinya ʉmpango ʉgwa lʉkoba mu nsana, aalyaga amapalaalɨla nʉ lʉʉki. ");
INSERT INTO nyy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aalʉmbɨlɨlaga, aatɨgɨ, “Kʉnyuma kʉmyangʉ ikwisa ʉjʉ alɨ na maka ʉkʉngɨnda ʉne, ngabagɨsya nʉ kwinama paasi ʉkwabʉla ʉtʉkoba ʉtwa filato fyake. ");
INSERT INTO nyy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ʉne ngʉboosya ʉmwe na mɨɨsi, looli ʉmwene ikʉboosyaga na Mbepo Mwikemo.” ");
INSERT INTO nyy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Akabalɨlo kala Jesu alɨnkwisa ʉkʉfuma kʉ Nasaleti, akaaja akaa nkiisʉ ɨkya Galilai, alɨnkoosigwa na Johani ndwɨsi Jolitani. ");
INSERT INTO nyy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nakalɨnga bo oosiigwe, bo ikʉfyʉka pi isɨɨlya alɨnkwaga kʉmwanya kwigwike, Mbepo Mwikemo ikʉsuluka pamwanya pamyake, nʉ mbɨlɨ bo ʉgwa ngʉnde. ");
INSERT INTO nyy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ɨliisyʉ lya Kyala ʉkʉfuma kʉmwanya, lɨlɨnkʉtɨ, “Ʉgwe gwe Mwanangʉ ʉNkʉndwe, gwe niikyeliile na nungwe.” ");
INSERT INTO nyy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Po Mbepo Mwikemo nakalɨnga alɨnkʉntwala Jesu ndʉngalangala. ");
INSERT INTO nyy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Alɨnkʉjamo ndʉngalangala amasikʉ amalongo mana, po Seetano alɨnkʉgela ʉkʉnsofya. Alɨnkʉja pamopeene nɨ finyamaana fya ndiisʉ amasikʉ goosa ago, looli abandʉmi baa Kyala balɨnkʉmmbombela. ");
INSERT INTO nyy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Johani bo apinyiigwe mu nnyololo, po Jesu alɨnkʉbʉʉka nkiisʉ ɨkya Galilai, alɨnkwanda ʉkʉlʉmbɨlɨla ɨNdʉmi ɨNunu ɨjaa Kyala, ");
INSERT INTO nyy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","aatɨgɨ, “Akabalɨlo kafikile, ʉBʉnyafyale bwa Kyala bʉsegeliile. Amupɨndʉkege, mujiitɨke ɨNdʉmi ɨNunu!” ");
INSERT INTO nyy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesu endaga mumbalɨ mwa sʉmbɨ Galilai, alɨnkʉbabona abalobi babɨlɨ, Simoni nʉ gwamyabo Andeleja. Babɨlɨ abo baataagɨlaga ɨnyeelo syabo mwa sʉmbɨ. ");
INSERT INTO nyy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mungongege! Nikʉbapela ʉkʉja balobi baa bandʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nakalɨnga balɨnkʉsileka ɨnyeelo syabo, balɨnkʉnkonga. ");
INSERT INTO nyy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bo endilepo nkyenipo panandɨ, alɨnkʉbabona abanyamundʉ abangɨ babɨlɨ, Jaakobo nʉ gwamyabo Johani, abanya Sebetai. Boope baalɨ mwi ibooti baatendekesyaga ɨnyeelo syabo. ");
INSERT INTO nyy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nakalɨnga Jesu alɨnkʉbakoolela, po paapo balɨnkʉnndeka mwi ibooti ʉgwisabo Sebetai pamopeene na babombi, balɨnkʉnkonga. ");
INSERT INTO nyy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Balɨnkʉbʉʉka mu Kapelinaʉmu. Iisikʉ ɨlya pa Sabati bo lɨfikile, Jesu alɨnkwingɨla mu sinagogi na bafundigwa baake, alɨnkwanda ʉkʉmanyisya. ");
INSERT INTO nyy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Abandʉ aba baalimo mula baaswigile fiijo ɨmanyisyo syake. Paapo akaamanyiisye bo muno baamanyikɨsyaga abamanyisi baa ndagɨlo sya Moose, looli bo ʉmundʉ ʉndagɨli. ");
INSERT INTO nyy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Akabalɨlo kala mu sinagogi mula aalimo ʉmundʉ ʉjʉ aalɨ nɨ mbepo ɨnyali, ");
INSERT INTO nyy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","jɨlɨnkʉlaata jɨlɨnkʉtɨ, “Gwe Jesu, gwe gwa mu Nasaleti, kʉlonda ɨfiki kʉmyɨtʉ? Bʉle, gwisile kʉkʉtʉpyuta? Ngʉmeenye ʉkʉtɨ ʉgwe gwe gwani. Ʉlɨ Mwikemo gwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesu alɨnkʉjɨkemela ɨmbepo ɨnyali jɨla, alɨnkʉtɨ, “Myeka! Sookamo mmundʉ ʉjʉ!” ");
INSERT INTO nyy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Po ɨmbepo ɨnyali jɨla jɨlɨnkʉnnjʉgaania ʉmundʉ jʉla, jɨlɨnkʉkuuta fiijo, jɨlɨnkʉsookamo. ");
INSERT INTO nyy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Abandʉ boosa baaswigile, balɨnkʉlaalʉʉsania balɨnkʉtɨ, “Fyo fiki ɨfi? Kʉ maka gaake ikʉmanyisya ɨmbya. Kangɨ ikʉsilagɨla ɨmbepo ɨnyali, po syope sikʉntiila!” ");
INSERT INTO nyy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ɨnongwa sya Jesu silɨnkʉbalanila mbɨbɨmbɨbɨ ntwaja toosa ʉtwa mu Galilai. ");
INSERT INTO nyy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesu na bafundigwa baake Simoni, Andeleja, Jaakobo na Johani balɨnkʉsookamo mu sinagogi, balɨnkwingɨla mu nyumba jaa Simoni na Andeleja. ");
INSERT INTO nyy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ʉnna gwa nkasi gwa Simoni aalambaleele, aalɨ nɨ sekema. Jesu bo afikile balɨnkʉmpangɨla ɨsya bʉbine bwake. ");
INSERT INTO nyy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Alɨnkʉsegelela kʉ mbine, alɨnkʉnkola ɨkɨboko, alɨnkʉnsumusya, ɨsekema jɨla jɨlɨnkʉsookamo. Ʉnkiikʉlʉ jʉla alɨnkwanda ʉkʉmmbombela Jesu na bafundigwa baake. ");
INSERT INTO nyy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Namajolo, bo iisʉba lɨjongile, abandʉ balɨnkʉntwalɨla Jesu ababine abingi na aba baalɨ nɨ mbepo ɨnyali. ");
INSERT INTO nyy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Abandʉ ʉkʉfuma mu mbeto syosa ɨsya kaaja kala, baabʉngeene pa kɨfigo ɨkya nyumba jaa Simoni. ");
INSERT INTO nyy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesu alɨnkʉbabʉmbʉlʉsya bingi aba baalɨ nʉ bʉbine ʉbwa lʉko nʉ lʉko. Alɨnkʉsikaga ɨmbepo ɨnyali nyingi, looli akaasilekile ʉkʉtɨ sijobege, paapo syalɨmmeenye ʉkʉtɨ jo jwani. ");
INSERT INTO nyy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kɨlaabo kyake nʉlʉbʉnjʉ bo kakaalɨ kaliko akakiisi, Jesu alɨnkʉsumuka, alɨnkʉbʉʉka pabʉjo bʉmo ʉbʉ bakajapo abandʉ, po alɨnkwipuuta. ");
INSERT INTO nyy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Akabalɨlo bo kakɨndilepo, Simoni na banine balɨnkʉbʉʉka kʉkʉnndonda. ");
INSERT INTO nyy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bo bammwagile balɨnkʉmmbʉʉla balɨnkʉtɨ, “Abandʉ boosa bakʉfumbilwe.” ");
INSERT INTO nyy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Looli Jesu alɨnkʉbaamula alɨnkʉtɨ, “Tʉbʉʉke kʉbʉngɨ kʉtwaja ʉtʉpalamani. Kʉla koope ngalʉmbɨlɨleko, paapo syo ɨsi niisiile, ʉkʉbalʉmbɨlɨla abandʉ boosa.” ");
INSERT INTO nyy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Endaga ntwaja toosa ʉtwa mu Galilai, aalʉmbɨlɨlaga mu sinagogi nʉ kʉsikaga ɨmbepo ɨnyali. ");
INSERT INTO nyy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Po ʉmundʉ jʉmo ʉnkoma alɨnkʉbʉʉka kwa Jesu, alɨnkʉfugama nʉ kʉlamba, alɨnkʉtɨ, “Gwe Ntwa, lɨnga gwiganile ʉkʉmbalamaasya, ʉbagiile ʉkʉʉnyeelʉsya.” ");
INSERT INTO nyy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesu alɨnkʉmpaakɨsya, alɨnkʉgolosya ɨkɨboko kyake, alɨnkʉmpalamaasya, alɨnkʉtɨ, “Niiganile, elʉkaga.” ");
INSERT INTO nyy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nakalɨnga ʉbʉkoma bwake bʉlɨnkʉsookamo, alɨnkʉbʉmbʉlʉka. ");
INSERT INTO nyy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Alɨnkʉnsoosyapo nʉ kʉnkaanisya kʉ maka, alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ʉlɨngammbʉʉlaga ʉmundʉ najʉmo ɨnongwa ɨsi! Looli ʉbʉʉke ʉkiinangɨsye kʉ mpuuti. Kangɨ ʉtwale iikemo lya kwelʉsigwa kʉ tempeli, ʉkʉnangɨsya ʉkʉtɨ ʉbʉmbʉlwike, bo muno sikʉlagɨla ɨndagɨlo sya Moose.” ");
INSERT INTO nyy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ʉmundʉ jʉla alɨnkʉsookapo, looli alɨnkwanda ʉkʉpanga ɨnongwa sya kʉbʉmbʉlʉka kwake. Kʉnongwa jaa kʉfumuka ɨsyo abandʉ bingi balɨnkʉnkonga Jesu. Po Jesu alɨnkʉtoligwa ʉkʉja pabwelu ʉkwingɨla ntwaja, paapo abandʉ bingi banndondaga, alɨnkʉja pabʉtiitʉ apa bakajapo abandʉ. Poope abandʉ bankongaga ʉkʉfuma ntwaja toosa. ");
INSERT INTO nyy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Amasikʉ manandɨ bo gakɨndile, Jesu alɨnkʉbʉʉka kangɨ kʉ Kapelinaʉmu, po abandʉ balɨnkʉpɨlɨka ʉkʉtɨ iisile kangɨ kʉkaaja. ");
INSERT INTO nyy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Balɨnkʉbʉngaana abandʉ bingi panja na nnyumba ɨjɨ aatʉʉgalaga, bʉkaalipo nʉ bʉjo nabʉmo pa kɨfigo. Jesu alɨnkʉbalʉmbɨlɨla iisyʉ lya Kyala. ");
INSERT INTO nyy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Po balɨnkwisa abandʉ bana aba baalɨmpɨmbile ʉmundʉ ʉjʉ aalalile ʉmbɨlɨ gwake, ʉkʉtɨ bantwale kwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Baatoliigwe ʉkʉmfikɨla Jesu kʉnongwa jaa kɨlʉndɨlo kya bandʉ. Po balɨnkʉpangʉla pamwanya pa nyumba ʉkʉbɨɨka ʉbwasi. Balɨnkʉnsulusya mpaka apa Jesu aalipo. ");
INSERT INTO nyy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Po paapo Jesu bo alʉbwene ʉlwitɨko lwabo, alɨnkʉmmbʉʉla ʉmundʉ jʉla aalalile, alɨnkʉtɨ, “Mwanangʉ, ʉhobokeliigwe ʉbʉtʉlanongwa bwako.” ");
INSERT INTO nyy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Abamanyisi baa ndagɨlo sya Moose bamo baatʉʉgeesye mula, balɨnkwinogona mu ndumbula syabo, balɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Fiki ʉjʉ ikʉjoba bo ʉlʉ? Ikʉntʉka Kyala! Akajako ʉmundʉ ʉjʉ abagiile ʉkʉhobokela ʉbʉtʉlanongwa, looli jo Kyala mwene!” ");
INSERT INTO nyy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesu nakalɨnga alɨnkʉmanya mu ndumbula jaake ɨsi biinogonaga mu ndumbula syabo, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Fiki mukwinogona bo ʉlo mu ndumbula syɨnu? ");
INSERT INTO nyy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lɨlɨkʉ ipepe, ʉkʉmmbʉʉla ʉjʉ alalile ʉkʉtɨ, ‘Ʉhobokeliigwe ʉbʉtʉlanongwa bwako,’ pamo ʉkʉtɨ, ‘Sumuka gwitwɨke ʉbʉlɨlɨ bwako, gwendege?’ ");
INSERT INTO nyy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Po musyaganiege ʉkʉtɨ ʉne ne Nnyamundʉ ndɨ na maka agaa kʉhobokela ʉbʉtʉlanongwa nkiisʉ muno...” Po alɨnkʉmmbʉʉla ʉjʉ aalalile, alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nikʉkʉbʉʉla, sumuka, pɨmba ʉbʉlɨlɨ bwako, bʉʉkaga kʉkaaja kaako.” ");
INSERT INTO nyy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nakalɨnga alɨnkʉsumuka nʉ kwitwɨka ʉbʉlɨlɨ bwake, alɨnkʉsookapo bo bikʉnkeeta abandʉ boosa. Balɨnkʉswiga, balɨnkʉntuufya Kyala, balɨnkʉtɨ, “Bo ɨsi tʉkakeetamo sikʉ!” ");
INSERT INTO nyy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesu alɨnkʉbʉʉka kangɨ kʉmbalɨ kwa sʉmbɨ Galilai. Ɨkɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ kɨlɨnkʉmmbʉngaanila, alɨnkʉbamanyisya. ");
INSERT INTO nyy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Piitaasi bo ikwenda, alɨnkʉmmbona Leebi, ʉmwana gwa Alifai, atʉʉgeesye apa bikʉsongesya ɨsongo. Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉngongege!” Alɨnkʉsumuka, alɨnkʉnkonga Jesu ʉkʉfuma akabalɨlo kala. ");
INSERT INTO nyy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesu na bafundigwa baake baabʉʉkile kʉkʉlya ɨfindʉ kwa Leebi. Abasongesya songo bingi na batʉlanongwa aba bankongaga Jesu, baatʉʉgaseenie nabo. ");
INSERT INTO nyy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Abamanyisi baa ndagɨlo sya Moose, aba baalɨ Bafalisai, balɨnkʉmmbona Jesu ikʉlya pamopeene na basongesya songo na batʉlanongwa, balɨnkʉbalaalʉʉsya abafundigwa baake, balɨnkʉtɨ, “Fiki ikʉlya pamopeene na basongesya songo na batʉlanongwa?” ");
INSERT INTO nyy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Looli Jesu bo apɨliike ɨsyo, alɨnkʉbabʉʉla alɨnkʉtɨ, “Abakafu batikʉnndonda ʉnganga, looli beene ababine! Ngiisa kʉkʉbakoolela abagolofu, looli abatʉlanongwa.” ");
INSERT INTO nyy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Akabalɨlo kamo abafundigwa baake Johani ʉMoosi na Bafalisai baafipɨɨkaga ɨfindʉ. Po abandʉ bamo balɨnkʉbʉʉka kwa Jesu, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Abafundigwa baa Johani na Bafalisai bikʉfipɨɨka ɨfindʉ, looli abafundigwa baako batikʉfipɨɨka, fiki?” ");
INSERT INTO nyy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Aba ʉmwega nkiikʉlʉ abapaalile kʉ bwegi, babagiile bʉleebʉle ʉkʉfipɨɨka ɨfindʉ bo balɨ nagwe? Akabalɨlo koosa aka balɨ nagwe ʉmwega nkiikʉlʉ, bakabagɨla ʉkʉfipɨɨka. ");
INSERT INTO nyy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Looli amasikʉ aga gikwisa, abandʉ bikwisa kʉnsoosyapo ʉmwega nkiikʉlʉ pakatɨ pa baheesya baake. Po bikwisa kʉfipɨɨkaga ɨfindʉ. ");
INSERT INTO nyy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Akajako ʉmundʉ ʉjʉ ikʉsonelapo ɨkɨgamba ɨkya mwenda ʉgʉ gukʉkwinya pa mwenda ʉnkʉʉlʉ. Lɨnga asoniilepo, ɨkɨgamba ɨkyo kɨtikwikolela, paapo kɨsoniigwe pa mwenda ʉnkʉʉlʉ, na apa panyaafwike pikongelela. ");
INSERT INTO nyy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kangɨ najʉmo atikʉkʉʉsyamo ɨfinga ɨmbya mfinyambɨ ɨfikʉʉlʉ. Lɨnga abombile bo ʉlo, ɨfinyambɨ fikʉnyaafuka nʉ koonangɨka. Looli abandʉ bikʉbɨɨka ɨfinga ɨmbya mfinyambɨ ɨfipya.” ");
INSERT INTO nyy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pi isikʉ lɨmo ɨlya pa Sabati, Jesu na bafundigwa baake bendaga mmigʉnda. Abafundigwa baake balɨnkwanda ʉkʉpʉlʉla ɨfisaasali. ");
INSERT INTO nyy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Po aBafalisai bamo balɨnkʉnndaalʉʉsya Jesu, balɨnkʉtɨ, “Fiki abafundigwa baako bikʉpʉlʉla? Silɨ mwiko pi isikʉ ɨlya pa Sabati!” ");
INSERT INTO nyy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Bʉle, mukabalamo Kalata ʉMwikemo ɨsi aabombile ʉmalafyale Ndaabɨti na banine bo balɨ nɨ njala? ");
INSERT INTO nyy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aalingiile mu nyumba jaa Kyala mmasikʉ gaa mpuuti ʉnkʉlʉmba Abyatali. Aaliile ɨfisyesye ɨfiikemo ɨfi baaliitɨkɨsiigwe ʉkʉlya beene abapuuti, aabapeele na banine aba aalɨ nabo.” ");
INSERT INTO nyy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “ƗSabati jaabɨɨkiigwe kʉnongwa jaa bandʉ, abandʉ bakaabɨɨkiigwe kʉnongwa jaa Sabati. ");
INSERT INTO nyy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nnyamundʉ jo Ntwa gwa Sabati joope.” ");
INSERT INTO nyy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Po Jesu alɨnkwingɨla kangɨ mu sinagogi jɨmo, muno aalimo ʉmundʉ ʉjʉ ɨkɨboko kyake kyalalile. ");
INSERT INTO nyy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ABafalisai bamo baalimo, baalondaga ɨnjɨla ɨjaa kʉnsitaaka Jesu, po balɨnkʉntegelela lɨnga ikʉmmbʉmbʉlʉsya ʉmundʉ pi isikʉ ɨlya pa Sabati. ");
INSERT INTO nyy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu alɨnkʉmmbʉʉla ʉmundʉ ʉjʉ ɨkɨboko kyake kɨlalile, alɨnkʉtɨ, “Isaga, gwɨme pakatɨ.” ");
INSERT INTO nyy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Po alɨnkʉbalaalʉʉsya aBafalisai, alɨnkʉtɨ, “Bʉle, siitɨkɨsiigwe ʉkʉbomba ɨnunu pamo ɨmbiibi pi isikʉ ɨlya pa Sabati? Ʉkʉpoka ʉbʉʉmi pamo ʉkʉboonanga?” Leelo balɨnkʉja kɨmyemye. ");
INSERT INTO nyy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesu alɨnkʉbakeeta kʉ bʉkalale, alɨnkʉsulumania kʉnongwa jaa bʉkafu bwa ndumbula syabo. Alɨnkʉmmbʉʉla ʉmundʉ jʉla, alɨnkʉtɨ, “Golosya ɨkɨboko kyako.” Alɨnkʉkɨgolosya ɨkɨboko kyake, kɨlɨnkʉbʉmbʉlʉka, kɨlɨnkʉja kɨkafu. ");
INSERT INTO nyy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nakalɨnga itolo aBafalisai balɨnkʉsooka panja, balɨnkʉjobesania pamopeene na babombeli abaa Heloti ɨsya kʉnngogelamo. ");
INSERT INTO nyy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ʉmwene Jesu alɨnkʉsookapo pamopeene na bafundigwa baake, balɨnkʉbʉʉka kʉmbalɨ kwa sʉmbɨ Galilai. Abandʉ bingi aba baafumile kʉ Galilai balɨnkʉnkonga. Kangɨ abandʉ bingi ʉkʉfuma mbʉjo nʉ bʉjo balɨnkʉnkonga bo bapɨliike syosa ɨsi aabombaga. Baafumile mu Jelusalemu na ntwaja ʉtwa nkiisʉ ɨkya mu Jutai, nkiisʉ ɨkya mu Itumija, kwi isɨɨlya ɨlya lwɨsi Jolitani na ntwaja ʉtwa kʉ Tili na kʉ Sitoni. ");
INSERT INTO nyy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesu alɨnkʉbatʉma abafundigwa baake ʉkʉnsegelekesya ibooti mo atʉʉgale, ɨkɨlʉndɨlo kya bandʉ kɨlɨngamfinyatɨla bo ikʉmanyisya. ");
INSERT INTO nyy_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Namanga aababʉmbʉlwisye baa bingi, na boosa aba baalɨ nɨ mbʉngo balɨnkʉlwɨlanila ʉkʉmpalamaasya. ");
INSERT INTO nyy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na sii mbepo ɨnyali ɨsi syajaga mmbandʉ, lɨnga simmbwene Jesu syapelaga abandʉ ʉkʉgwa nkyeni mmyake. Syalataga syatɨgɨ, “Ʉgwe ʉlɨ Mwana gwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesu alɨnkʉsikemela fiijo ɨmbepo ɨnyali ʉkʉtɨ silɨngannjobaga ʉkʉtɨ jo jwani. ");
INSERT INTO nyy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Po paapo Jesu alɨnkʉfyʉka kʉ kyamba, alɨnkʉbakoolela bala aabalondaga, po balɨnkwisa. ");
INSERT INTO nyy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aabasʉngwile abandʉ kalongo na babɨlɨ abaa kʉja nagwe, ʉkʉtɨ abatʉmege kʉkʉlʉmbɨlɨla, ");
INSERT INTO nyy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kangɨ bajege na maka agaa kʉsikaga ɨmbepo ɨnyali. ");
INSERT INTO nyy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aba baasʉngʉliigwe baalɨ bo baa Simoni (ʉjʉ Jesu aalɨmpeele ɨngamu ɨjaa Peeteli), ");
INSERT INTO nyy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jaakobo ʉmwana gwa Sebetai nʉ nnuguna Johani (alɨnkʉbapapo ɨngamu ɨjaa Boneligesi, kokʉtɨ abaana baa njasi), ");
INSERT INTO nyy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andeleja, Filipo, Balitolomai, Matai, Tomasi, Jaakobo ʉmwana gwa Alifai, Tatai, Simoni ʉndwɨla kiisʉ kyake, ");
INSERT INTO nyy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Juuta Isikalyoti ʉjʉ kʉmmalɨɨkɨsyo aalɨnndɨɨliile Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Po paapo Jesu na bafundigwa baake balɨnkʉbʉʉka kʉmyabo. Po ɨkɨlʉndɨlo kya bandʉ kɨlɨnkʉbʉngaana kangɨ pala, ʉmwene na bafundigwa baake balɨnkʉtoligwa ʉkʉkaaga akabalɨlo akaa kʉlya ɨfindʉ. ");
INSERT INTO nyy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Abakamu baa Jesu balɨnkʉpɨlɨka ɨnongwa ɨsyo, balɨnkwinogona ʉkʉtɨ abopile ɨmbepo, balɨnkʉbʉʉka kʉkʉmmwega. ");
INSERT INTO nyy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Boope abamanyisi baa ndagɨlo sya Moose aba baasulwike ʉkʉfuma kʉ Jelusalemu, baalimo mu nyumba jɨla, balɨnkʉtɨ, “Alɨ na Belisebuli, ʉnkʉlʉmba gwa mbepo ɨnyali! Ikʉsikaga ɨmbepo ɨnyali kʉ maka agaa Belisebuli.” ");
INSERT INTO nyy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesu alɨnkʉbakoolela, alɨnkʉbabʉʉla kʉ fifwanikɨsyo, alɨnkʉtɨ, “Abagiile bʉleebʉle Seetano ʉkwikaga? ");
INSERT INTO nyy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Abandʉ abaa mbʉnyafyale bʉmo, lɨnga bikʉsambʉkana, ʉbʉnyafyale ʉbo bukʉfwa. ");
INSERT INTO nyy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Boope abaa nkɨkolo kɨmo, lɨnga basambʉkeene, ɨkɨkolo ɨkyo kikʉfwa. ");
INSERT INTO nyy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Lɨnga ʉbʉlongosi bwa Seetano bʉsambʉkeene, po bʉkabagɨla ʉkwɨma, looli bukʉmalɨkaga loosa. ");
INSERT INTO nyy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Akajako ʉmundʉ najʉmo ʉjʉ abagiile ʉkwingɨla nnyumba jaa ʉjʉ alɨ na maka nkʉpʉpa ɨfyʉma fyake, bo akampinya taasi jʉla ʉgwa maka. Looli lɨnga ampinyile, po abagiile ʉkʉmpʉpa ɨfyʉma fyake. ");
INSERT INTO nyy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nalooli nikʉbabʉʉla nikʉtɨ, ʉbʉtʉlanongwa boosa ʉbwa bandʉ, na maheelu goosa aga bikʉtʉka fikʉhobokeligwa, ");
INSERT INTO nyy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","looli ʉjʉ ikʉntʉka Mbepo Mwikemo, ʉjo atikwisa kʉhobokeligwa sikʉ, aguniigwe bwila na bwila.” ");
INSERT INTO nyy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Alɨnkʉbabʉʉla ɨsyo paapo baatɨgɨ alɨ nɨ mbepo ɨnyali. ");
INSERT INTO nyy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Po paapo ʉnna na baamyabo balɨnkʉfika, balɨnkwɨma panja pa nyumba ɨjɨ aalimo, balɨnkʉntʉma ʉmundʉ jʉmo ʉkʉnkoolela Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Abandʉ aba baalimo nnyumba baatʉʉgeesye nʉ kʉmmbʉngaanila, balɨnkʉmmbʉʉla balɨnkʉtɨ, “Keeta! Ʉnyoko na bakamu baako balɨ panja, bikʉkʉlonda ʉgwe.” ");
INSERT INTO nyy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Jʉʉba na bakamu bangʉ bo baani?” ");
INSERT INTO nyy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Po alɨnkʉbakeeta abandʉ aba baalɨmmbʉngaaniile, alɨnkʉtɨ, “Keeta, aba bo baa jʉʉba na bakamu bangʉ! ");
INSERT INTO nyy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gwesa ʉjʉ ikʉbomba ʉbwigane bwa Kyala, ʉjo jo nkamu gwangʉ, jo ilʉmbʉ gwangʉ, jo jʉʉba.” ");
INSERT INTO nyy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Po Jesu alɨnkwanda ʉkʉbamanyisya abandʉ kʉmbalɨ kwa sʉmbɨ Galilai. Kʉnongwa jaa bwingi bwa bandʉ, alɨnkwipakɨla mwi ibooti ɨlɨ lyalɨ mwa sʉmbɨ, alɨnkʉbamanyisya bo alɨ mula. Ɨkɨlʉndɨlo ɨkya bandʉ boosa baalɨ pi isɨɨlya. ");
INSERT INTO nyy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Po alɨnkʉbamanyisya ɨnongwa ɨnyingi mfifwanikɨsyo, alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Amupɨlɨkɨsye! Ʉmbyali jʉmo aabʉʉkile kʉkʉsopa ɨmbeju. ");
INSERT INTO nyy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bo ikʉsopa, ɨmbeju simo syagwɨliile mumbalɨ mu njɨla, silɨnkwisa ɨnjʉni silɨnkʉlya. ");
INSERT INTO nyy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ɨsingi syagwɨliile pa lwalabwe, apa ʉmfu gʉkaalipo mwingi. Syo nakalɨnga silɨnkʉmela. ");
INSERT INTO nyy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Iisʉba bo lɨbalile ʉlʉmu bo lʉkalɨ, silɨnkʉkofuka nʉ kʉʉma, paapo ɨmisi gɨkaabʉʉkile paasi. ");
INSERT INTO nyy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ɨmbeju ɨsingi syagwɨliile pakatɨ pa miifwa. Ɨmiifwa gɨla gɨlɨnkʉmela nʉ kʉsifinyatɨla. Kʉnongwa ɨjo silɨnkʉsita kʉpa ɨseke. ");
INSERT INTO nyy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ɨmbeju ɨsingi syagwɨliile pa mfu ʉnnunu, silɨnkʉmela nʉ kʉkʉla, nʉ kʉpa ɨseke ɨnyingi. Simo silɨnkʉpa ɨseke amalongo matatʉ, ɨsingi silɨnkʉpa amalongo ntandatʉ, nɨ singi silɨnkʉpa ɨmia jɨmo.” ");
INSERT INTO nyy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Po paapo Jesu alɨnkʉtɨ, “Ʉjʉ alɨ nɨ mbʉlʉkʉtʉ ɨsya kʉpɨlɨkɨla, jo apɨlɨkege!” ");
INSERT INTO nyy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesu bo iijeekiile, abafundigwa baake kalongo na babɨlɨ, na bandʉ aba baalɨmmbʉngaaniile, balɨnkʉnndaalʉʉsya ɨsya fifwanikɨsyo fila. ");
INSERT INTO nyy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉmwe Kyala abapeele ʉkʉsyagania ɨsya mbʉtiitʉ ɨsya Bʉnyafyale bwake. Looli aba bakajapo pa kɨbugutɨla ɨkɨ, bo syosa ngʉbamanyikɨsya mfifwanikɨsyo. ");
INSERT INTO nyy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Nalɨnga bikʉkeeta fiijo, batikʉfibona, nalɨnga bikʉpɨlɨka fiijo, batikʉsyagania. Lɨnga baapɨliike nʉ kʉsyagania, ngalɨ bapɨndwike nʉ kʉhobokeligwa.’ ” ");
INSERT INTO nyy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesu alɨnkʉtɨ, “Mukakɨmanya ɨkɨfwanikɨsyo ɨkɨ? Po mukʉfyaganiaga bʉleebʉle ɨfifwanikɨsyo fyosa ɨfingi? ");
INSERT INTO nyy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ʉmbyali ikʉsopa iisyʉ lya Kyala. ");
INSERT INTO nyy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Abandʉ bamo bafwene bo ɨmbeju ɨsi sigwɨliile mumbalɨ mu njɨla. Bikʉpɨlɨka iisyʉ ɨlyo, leelo nakalɨnga Seetano ikwisa nʉ kʉlɨsoosyamo ɨlɨ Kyala alɨbyele mu ndumbula syabo. ");
INSERT INTO nyy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Abandʉ abangɨ bafwene bo ɨmbeju ɨsi syagwɨliile pa lwalabwe, ʉlʉ lʉkaja nʉ mfu mwingi. Nakalɨnga bo balɨpɨliike iisyʉ lya Bʉnyafyale bwa Kyala, bikʉlyambɨlɨla nʉ lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Looli iisyʉ lɨtikwitoteka mu ndumbula syabo, paapo lɨkaja nɨ misi, likʉjamo akabalɨlo akapimba itolo. Lɨnga ɨngʉbɨlo sikʉbiisɨla pamo bikʉgeligwa kʉnongwa jaa isyʉ ɨlyo, nakalɨnga bikʉlʉleka ʉlwitɨko. ");
INSERT INTO nyy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Abandʉ abangɨ bafwene bo ɨmbeju ɨsi syagwɨliile pa miifwa. Bikʉpɨlɨka iisyʉ lya Kyala, ");
INSERT INTO nyy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","looli kʉnongwa jaa kwikolaania, nɨ mbombo ɨsya pakiisʉ, nʉ kʉsyobigwa, nɨ fyʉma, nɨ kɨnyonyo ɨkya tʉndʉ twingi, fyosa ɨfyo fikʉlɨfinyatɨla iisyʉ, po lɨtikʉpa ɨseke. ");
INSERT INTO nyy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Abangɨ bafwene bo ɨmbeju ɨsi syagwɨliile pa mfu ʉnnunu. Aba bo bandʉ aba bikʉlɨpɨlɨka iisyʉ ɨlyo, nʉ kʉlyambɨlɨla. Bikʉpa ɨseke, bamo amalongo matatʉ, bamo amalongo ntandatʉ, na bangɨ ɨmia jɨmo.” ");
INSERT INTO nyy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu alɨnkʉbamanyisya abandʉ, alɨnkʉtɨ, “Bʉle, abandʉ bikwasya ɨnyaale nʉ kʉjɨkupɨkɨla nɨ kiibo, pamo bikʉjɨbɨɨka kwi ifungu? Batikʉjɨbɨɨka pa kɨkolela nyaale? ");
INSERT INTO nyy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Syosa ɨsi sifisiigwe sikwisa kʉbɨɨkigwa pabwelu. Syosa ɨsi silɨ mbʉtiitʉ sikwisa kʉkuputuligwaga. ");
INSERT INTO nyy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ʉjʉ alɨ nɨ mbʉlʉkʉtʉ ɨsya kʉpɨlɨkɨla, jo apɨlɨkege!” ");
INSERT INTO nyy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesu alɨnkwendelela ʉkʉbamanyisya alɨnkʉtɨ, “Musyaganiege ɨsi mukʉpɨlɨkɨsya! Ɨkɨpɨmo ɨkɨ mukʉbapɨmɨla abangɨ, kyo ɨkɨ Kyala ikwisa kʉbapɨmɨlaga nuumwe, kangɨ mukwisa kongeleligwangapo. ");
INSERT INTO nyy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ʉjʉ apeeliigwe ʉkʉsyagania ɨsyo, ikongeleligwa ʉkʉsyagania. Ʉjʉ akapeeligwa ʉkʉsyagania, syope ɨnandɨ ɨsi asyageenie sitikʉntʉʉla.” ");
INSERT INTO nyy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesu alɨnkʉjoba alɨnkʉtɨ, “ɄBʉnyafyale bwa Kyala bʉlɨ bo ʉlwa kɨfwanikɨsyo ɨkɨ. Aaliko mundʉ ʉjʉ aabyalaga ɨmbeju mu mfu. ");
INSERT INTO nyy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Po pakɨlo aagonile ʉtʉlo, nʉlʉbʉnjʉ bo alembwike alɨnkwaga ɨmbeju jɨmelile, kɨsita kʉmanya muno jɨmeliile. ");
INSERT INTO nyy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ʉmfu gwene gukʉmesya, likʉtala ɨlyani, kikʉkonga ɨkɨsaasa, po ɨseke nkɨsaasa. ");
INSERT INTO nyy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ɨseke bo sibɨfwifwe, ʉmundʉ ikwega ɨkɨtondolelo, paapo ʉntondolo gʉfikile.” ");
INSERT INTO nyy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kangɨ Jesu alɨnkʉtɨ, “Tʉbʉfwanikɨsye nɨ fiki ʉBʉnyafyale bwa Kyala? Tʉbamanyisye nkɨfwanikɨsyo kɨlɨkʉ? ");
INSERT INTO nyy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bʉfwene na kaseke akaa iseeke ɨlya mutaka, akaseke akaniini ʉkʉkɨnda ɨseke syosa ɨsya iseeke ɨsi sikʉbyaligwa. ");
INSERT INTO nyy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bo kabyaliigwe kikʉkʉla ʉkʉkɨnda amaseeke goosa, kikʉja mpiki ʉgwa samba ɨnywamu, nɨ njʉni sibagiile ʉkʉtengamo ɨfifufumbwa.” ");
INSERT INTO nyy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mfifwanikɨsyo fii fingi bo ɨfi alɨnkʉbamanyisya ɨliisyʉ lya Kyala, bo muno babagiile ʉkʉsyagania. ");
INSERT INTO nyy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pa bandʉ abingi akaabamanyisyaga kɨsita kɨfwanikɨsyo, looli lɨnga iijeekiile na bafundigwa baake, aabalɨngɨsaniaga syosa mbwelu. ");
INSERT INTO nyy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ɨliisikʉ lɨlalɨla namajolo, Jesu alɨnkʉbabʉʉla abafundigwa baake, alɨnkʉtɨ, “Isaga, tʉloboke sʉmbɨ, tʉbʉʉke kwi isɨɨlya.” ");
INSERT INTO nyy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Balɨnkʉkɨleka ɨkɨlʉndɨlo kya bandʉ, balɨnkwipakɨla mwi ibooti muno aalimo. Po amabooti agangɨ galɨnkʉlongosania nagwe. ");
INSERT INTO nyy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bo balɨ pakatɨ paa sʉmbɨ ʉmbelo ʉgwa mpetapeta gʉlɨnkwisa, amajɨga galɨnkʉkoma mwi ibooti, lɨlɨnkwanda ʉkwisʉla amɨɨsi. ");
INSERT INTO nyy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesu jo aalɨ kʉbʉjo ʉbwa kʉnyuma, aagonile ʉtʉlo, aalyegamiile ɨkiinʉlɨlo ɨkya ntʉ. Po abafundigwa baake balɨnkʉnndembʉsya, balɨnkʉjwega balɨnkʉtɨ, “Gwe Mmanyisi, ʉtikʉpaasya ʉkʉtɨ tukʉfwa!” ");
INSERT INTO nyy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Alɨnkʉlembʉka, alɨnkʉgʉkemela ʉmbelo, alɨnkʉgabʉʉla amajɨga, alɨnkʉtɨ, “Kiba, boteela!” Ʉmbelo gʉlɨnkʉleka ʉkʉkula, kʉlɨnkʉja mye jonjolo. ");
INSERT INTO nyy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Fiki mukʉtiila? Mukaalɨ mukaja nʉ lwitɨko?” ");
INSERT INTO nyy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Balɨnkʉja nʉ lʉtende ʉlʉnywamu fiijo, balɨnkʉjobesania balɨnkʉtɨ, “Ʉjʉ jo jwani? Ʉmbelo na sʉmbɨ fyope fikʉntiila!” ");
INSERT INTO nyy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Po paapo balɨnkʉfika nkiisʉ kya Bagelasi, kwi isɨɨlya ɨlya sʉmbɨ Galilai. ");
INSERT INTO nyy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesu bo asulwike mwi ibooti, nakalɨnga alɨnkwaganila nagwe ʉmundʉ jʉmo ʉgwa nkiisʉ kɨla, ʉjʉ aalɨ nɨ mbepo ɨnyali, aafumile kʉ mapʉmba. ");
INSERT INTO nyy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ʉmundʉ ʉjʉ ʉbʉjo bwake bwalɨ bwa kʉ mapʉmba. Akaaliko ʉmundʉ najʉmo ʉjʉ aabagiile ʉkʉmpinya, poope nɨ minyololo. ");
INSERT INTO nyy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kaa kingi ʉmundʉ ʉjʉ abandʉ bampinyaga nɨ mbɨngo nɨ minyololo, looli aagɨlatʉlaniaga ɨminyololo nʉ kʉsipomola ɨmbɨngo. Akaaliko ʉmundʉ najʉmo ʉjʉ aabagiile ʉkʉntola amaka. ");
INSERT INTO nyy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Amasikʉ goosa, pakɨlo na pamuusi, aasyʉngʉʉtɨlaga kʉ mapʉmba na mfyamba, aajwegaga ʉnjwego nʉ kwibuuta buuta mu mbɨlɨ na mabwe. ");
INSERT INTO nyy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ʉmundʉ ʉjʉ, bo ammbwene Jesu kʉbʉtali alɨnkʉmmbopela, alɨnkʉfugama nkyeni mmyake. ");
INSERT INTO nyy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ɨmbepo ɨnyali jɨlɨnkʉlaata fiijo, jɨlɨnkʉtɨ, “Gwe Jesu, gwe Mwana gwa Kyala ʉNkʉlʉmba, tʉlɨ bʉki ʉgwe na niine? Kʉ ngamu jaa Kyala ngʉkʉsʉʉma ʉlɨngaafundaga!” ");
INSERT INTO nyy_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ɨmbepo ɨnyali jɨla jaajobile bo ʉlo paapo Jesu aajɨkemiile kʉbwandɨlo aatile, “Gwe mbepo ɨnyali, sookamo mmundʉ ʉjʉ!” ");
INSERT INTO nyy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Po alɨnkʉjɨlaalʉʉsya alɨnkʉtɨ, “Ɨngamu jaako gwe gwani?” Ɨmbepo ɨnyali jɨlɨnkʉmmwamula jɨlɨnkʉtɨ, “Ɨngamu jangʉ ne Kɨlʉndɨlo, paapo tʉlɨ bingi.” ");
INSERT INTO nyy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Silɨnkʉpyelesya fiijo kwa Jesu ʉkʉtɨ alɨngasikaga nkiisʉ kɨla. ");
INSERT INTO nyy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Gwalipo ʉntiimo ʉnnywamu ʉgwa ngʉlʉbe ʉgʉ gwatiimigwaga nkyamba. ");
INSERT INTO nyy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ɨmbepo ɨnyali sila silɨnkʉmpyelesya Jesu silɨnkʉtɨ, “Ʉtʉtʉme mu ngʉlʉbe sila, mo twingɨlege.” ");
INSERT INTO nyy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Po alɨnkʉsiitɨkɨsya. Silɨnkʉsookamo, silɨnkwakwingɨla mu ngʉlʉbe. Ʉntiimo goosa ʉgwa ngʉlʉbe, syalɨ mwa 2,000. Silɨnkʉsibopesya ɨngʉlʉbe syosa ʉkʉsuluka ndʉpanga, mpaka mwa sʉmbɨ, silɨnkʉmilwa. ");
INSERT INTO nyy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Abatiimi baa ngʉlʉbe balɨnkʉbopa ʉlʉbɨlo, balɨnkwakʉfumusya syosa nkaaja na mmigʉnda. Abandʉ balɨnkwisa kʉkʉkeeta ɨsi siboniike. ");
INSERT INTO nyy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Balɨnkʉbʉʉka kwa Jesu, balɨnkʉmmwaga ʉmundʉ jʉla aalɨ nɨ kɨlʉndɨlo ɨkya mbepo ɨnyali atʉʉgeele paasi, afwele kanunu, kangɨ alɨ na mahala goosa, balɨnkʉtiila. ");
INSERT INTO nyy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Abandʉ aba baasikeetile ɨsi syaboniike, balɨnkʉbapangɨla abangɨ ɨsya mundʉ jʉla aalɨ nɨ mbepo ɨnyali, nɨ sya ngʉlʉbe. ");
INSERT INTO nyy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Po abenekaaja bala balɨnkʉmpyelesya Jesu, ʉkʉtɨ asookemo nkiisʉ kyabo. ");
INSERT INTO nyy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesu bo ikwipaka mwi ibooti, ʉmundʉ ʉjʉ aponile ɨmbepo ɨnyali, alɨnkʉlamba kwa Jesu ʉkʉtɨ abʉʉkege pamopeene nagwe. ");
INSERT INTO nyy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesu akaalɨmmwitɨkiile, looli alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉbʉʉkege kʉmyɨnu kʉ bakamugo, ʉkababʉʉlege syosa ɨsi ʉNtwa Kyala akʉbombiile na muno akʉpaakiisye.” ");
INSERT INTO nyy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Po ʉmundʉ jʉla alɨnkʉsookapo pala, alɨnkʉfumusya ntwaja ʉtwa kʉ Ndekapoli syosa ɨsi Jesu ammbombiile. Po paapo abandʉ boosa balɨnkʉswiga. ");
INSERT INTO nyy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu na bafundigwa baake, baalobwike sʉmbɨ ni ibooti ʉkʉgomokelako kwi isɨɨlya. Bo alɨ kʉmbalɨ kwa sʉmbɨ ɨkɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ kɨlɨnkʉbʉngaana nkyeni mmyake. ");
INSERT INTO nyy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Alɨnkwisa kʉmyake ʉndongosi jʉmo ʉgwa mu sinagogi, ɨngamu jaake Jailo. Bo ammbwene Jesu, alɨnkʉfugama nkyeni mmyake. ");
INSERT INTO nyy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Alɨnkʉpyelesya fiijo, alɨnkʉtɨ, “Ʉmwanangʉ ʉndɨndwana ʉnkeke mbine, alɨ kɨfuki ʉkʉfwa. Ngʉkʉsʉʉma gwise, ʉkammbɨɨkepo ɨkɨboko kyako pamwanya pamyake, ʉkʉtɨ abʉmbʉlʉke ajege mʉʉmi.” ");
INSERT INTO nyy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesu alɨnkʉbʉʉka nagwe. Ɨkɨlʉndɨlo ɨkya bandʉ ɨkɨnywamu kɨlɨnkʉnkonga nʉ kʉmfinyɨla. ");
INSERT INTO nyy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nkɨlʉndɨlo kɨla, aalimo ʉnkiikʉlʉ jʉmo, ʉjʉ aalɨ nʉ bʉbine bwa kooneka iilopa. Ʉbʉbine ʉbo bwalɨntaamiisye kʉ fyɨnja kalongo na fibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Aataamigwaga nʉ bʉlwasi bwa baganga bingi, ɨkyʉma kyake kyosa aataagile nkʉbahomba, looli kɨsita kʉpona. Ʉbʉbine bwake bwalyongeliile fiijo. ");
INSERT INTO nyy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Bo apɨliike ɨnongwa sya Jesu, alɨnkwifinyatɨla nkɨlʉndɨlo kya bandʉ, alɨnkʉbʉʉka kʉnyuma kwa Jesu, alɨnkʉpalamaasya ʉmwenda gwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Namanga aaliinogwine mu ndumbula jaake, aatile, “Lɨnga mbalamaasiisye gwene ʉmwenda gwake, ngʉpona.” ");
INSERT INTO nyy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bo apalamaasiisye ʉmwenda, nakalɨnga iilopa lɨlɨnkʉleka ʉkooneka, alɨnkwipɨlɨka ʉmbɨlɨ ʉkʉtɨ aponile ʉbʉbine bwake. ");
INSERT INTO nyy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nakalɨnga Jesu alɨnkwijaagania mu ndumbula ʉkʉtɨ amaka gamo agaa kʉbʉmbʉlʉkɨsya gasookile. Alɨnkʉkɨsanukɨla kʉno na kʉno ɨkɨlʉndɨlo kya bandʉ, alɨnkʉlaalʉʉsya alɨnkʉtɨ, “Jo jwani ambalamaasiisye ɨmyenda gyangʉ?” ");
INSERT INTO nyy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abafundigwa baake balɨnkʉmmwamula balɨnkʉtɨ, “Kʉkɨbona ɨkɨlʉndɨlo kya bandʉ kikʉkʉfinyatɨla finyatɨla. Fiki kʉlaalʉʉsya ʉkʉtɨ jwani akʉpalamaasiisye?” ");
INSERT INTO nyy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Looli Jesu alɨnkʉkelengania ɨfibafu fyosa, ʉkʉtɨ ammbone ʉjʉ ampalamaasiisye. ");
INSERT INTO nyy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ʉnkiikʉlʉ jʉla bo ameenye ɨsi simmwagile, alɨnkʉja nʉ lʉtende, alɨnkʉtetema, alɨnkwinangɨsya, alɨnkʉfugama nkyeni mwa Jesu, alɨnkʉmmbʉʉla syosa mbwanalooli. ");
INSERT INTO nyy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Mwanangʉ, ʉbʉmbʉlwike ʉbʉbine kʉnongwa jaa lwitɨko lwako. Kangɨ ʉjege nkafu itolo kɨsita bʉtolwe bwako nabʉmo. Bʉʉkaga nʉ lʉtengaano.” ");
INSERT INTO nyy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesu bo alɨ pakʉjoba, balɨnkwisa abandʉ bamo ʉkʉfuma kʉkaaja kaa Jailo, ʉndongosi jʉla ʉgwa mu sinagogi, balɨnkʉmmbʉʉla balɨnkʉtɨ, “Ʉlɨngantaamyaga ʉMmanyisi, ʉmwanaako ʉndɨndwana afwile.” ");
INSERT INTO nyy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Looli Jesu bo apɨliike ɨsi baajobaga, alɨnkʉmmbʉʉla ʉndongosi jʉla, alɨnkʉtɨ, “Ʉlɨngatiilaga, ʉjege nʉ lwitɨko itolo.” ");
INSERT INTO nyy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Akaalɨmmwitɨkiisye ʉmundʉ najʉmo ʉkʉnkonga, looli beene baa Peeteli, Johani na Jaakobo ʉgwamyabo. ");
INSERT INTO nyy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Balɨnkʉfika pakaaja kaa ndongosi jʉla ʉgwa mu sinagogi, Jesu alɨnkʉgwaga ʉnjwego na bandʉ aba baalɨlaga ɨɨfwa, baakuutaga fiijo. ");
INSERT INTO nyy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Po alɨnkwingɨla nnyumba, alɨnkʉbabʉʉla abafwɨle, alɨnkʉtɨ, “Keeta mukʉjwega nʉ kʉlɨla? Ʉndɨndwana ʉjʉ akafwa, looli agonile twene ʉtʉlo.” ");
INSERT INTO nyy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Abandʉ bala balɨnkʉnseka, looli Jesu alɨnkʉbasoosya boosa panja. Alɨnkʉmmwega ʉgwise gwa ndɨndwana nʉ nna palɨkɨmo na bafundigwa baake, alɨnkwingɨla kʉ kyumba kʉno gwaliko ʉmfimba gwa ndɨndwana. ");
INSERT INTO nyy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Alɨnkʉnkola ɨkɨboko, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Talita, kʉmi!” Kokʉtɨ, “Ndɨndwana, lembʉka!” ");
INSERT INTO nyy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nakalɨnga ʉndɨndwana alɨnkʉsumuka nʉ kwenda. Aalɨ nkʉsi gwa fyɨnja kalongo na fibɨlɨ. Bo bikʉsikeeta ɨsi balɨnkʉswiga fiijo. ");
INSERT INTO nyy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Looli Jesu alɨnkʉbakaanisya fiijo ʉkʉtɨ balɨngampangɨlaga najʉmo ɨsi siboniike. Alɨnkʉbalagɨla ʉkʉtɨ bampepo ɨfindʉ ʉndɨndwana jʉla. ");
INSERT INTO nyy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Po Jesu alɨnkʉsookako kʉla na bafundigwa baake, balɨnkʉnkonga ʉkʉbʉʉka nkaaja aka aakʉliile. ");
INSERT INTO nyy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Iisikʉ ɨlya pa Sabati bo lɨfikile, Jesu alɨnkwanda ʉkʉmanyisya mu sinagogi. Abandʉ bingi aba baalimo balɨnkʉswiga fiijo nʉ kʉlaalʉʉsania, balɨnkʉtɨ, “Mwe! Ʉjʉ asyagile kʉʉgʉ ɨsi ikʉmanyisya? Mahala maki aga apeeliigwe ʉjʉ? Agaagile kʉʉgʉ amaka agaa kʉbomba ɨfiika bo ɨfi? ");
INSERT INTO nyy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bʉle, ʉjʉ akaja jo nsongola matapwa, ʉmwana gwa Malija, na baamyabo bo baa Jaakobo, Joose, Juuta na Simoni? Abalʉmbʉ baake bakaja bo aba tʉlɨ nabo pamyɨtʉ apa?” Po abeene balɨnkwikinyamo, balɨnkʉsita kʉmmwitɨka. ");
INSERT INTO nyy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Looli Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉnkunguluka atikʉpondwa ʉlwɨmɨko, looli mwene nkaaja kaake, nkɨkolo kyake na baa mu nyumba jaake.” ");
INSERT INTO nyy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Alɨnkʉsita kʉbomba ɨfiika fingi kʉla, looli kwene ʉkʉbabɨɨkɨla amaboko gaake ababine banandɨ nʉ kʉbabʉmbʉlʉsya. ");
INSERT INTO nyy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ʉmwene Jesu alɨnkʉbaswiga fiijo abandʉ baa kʉla, paapo bakammwitɨkaga. Po alɨnkwanda ʉkʉsyʉngʉʉtɨla kʉno na kʉno ntwaja, ʉkʉmanyisya abandʉ. ");
INSERT INTO nyy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Alɨnkʉbabɨlɨkɨla abafundigwa baake kalongo na babɨlɨ, alɨnkʉbatʉma babɨlɨ babɨlɨ, alɨnkʉbapapo amaka agaa kʉsikaga ɨmbepo ɨnyali. ");
INSERT INTO nyy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Alɨnkʉbalagɨla alɨnkʉtɨ, “Mulɨngendaga nafyo nafimo ɨfya kʉbatʉʉla mu njɨla, nalɨnga findʉ, nalɨnga kɨnyambɨ, syope nɨ ndalama, looli jeene ɨngili ɨjaa kwendela. ");
INSERT INTO nyy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mufwalege ɨfilato, looli mungajaga nʉ mwenda gwa kwandʉla. ");
INSERT INTO nyy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Poosa pala bikʉbambɨlɨla nnyumba, mukatʉʉgalege mulamula kɨsita kʉsaama, mpaka bo mukʉsookamo nkaaja ako. ");
INSERT INTO nyy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Lɨnga poosa apa batikʉbambɨlɨla ʉmwe nʉ kʉsita kʉbapɨlɨkɨsya, mukasookengepo nʉ kʉkungʼunda ɨfumbɨ ɨjɨ jɨlɨ mmalʉndɨ gɨɨnu, ʉkʉja kyo kɨmanyilo kya kʉbasoka.” ");
INSERT INTO nyy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Balɨnkʉbʉʉka, balɨnkwakʉlʉmbɨlɨla ʉkʉtɨ abandʉ bapɨndʉke, basileke ɨmbiibi syabo. ");
INSERT INTO nyy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Balɨnkʉsikaga ɨmbepo ɨnyali ɨnyingi, balɨnkʉbapaka amafuta ababine, bingi balɨnkʉbʉmbʉlʉka. ");
INSERT INTO nyy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Akabalɨlo ako, Heloti ʉjʉ aalɨ malafyale ʉgwa mu Galilai, aapɨliike ɨnongwa sya Jesu, paapo ɨngamu jaake jaafumwike. Abandʉ bamo baatɨgɨ, “Ʉjo jo Johani ʉMoosi asyʉkile ʉkʉfuma mbafwe. Ʉkeetege alɨ na maka agaa kʉbomba ɨfiika.” ");
INSERT INTO nyy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Abangɨ baatɨgɨ, “Jo Elija.” Abangɨ baatɨgɨ, “Jo nkunguluka jʉmo mbakunguluka abaa ijolo.” ");
INSERT INTO nyy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Looli ʉmwene Heloti bo apɨliike, alɨnkʉtɨ, “Johani ʉMoosi, ʉjʉ naalɨmmbuutile ʉntʉ, asyʉkile.” ");
INSERT INTO nyy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kʉbwandɨlo ʉnkiikʉlʉ jʉmo ɨngamu jaake Helotija, aalɨ nkasi gwa Filipo ʉgwamyabo gwa malafyale Heloti. Po Heloti alɨnkʉmmwega Helotija. Johani ammbʉʉlaga Heloti alɨnkʉtɨ, “Silɨ mwiko ʉgwe ʉkʉmmwega Helotija ʉnkasi gwa gwamyɨnu.” Heloti alɨnkʉbatʉma abasikali abaa kʉnkola Johani, alɨnkʉmpinya mu nnyololo, ʉkʉtɨ anhobosye Helotija. ");
INSERT INTO nyy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Helotija alɨnkʉmfiifya Johani ʉlwa kɨlʉgʉ, aalondaga ʉkʉtɨ agogigwe, leelo aatoligwaga, ");
INSERT INTO nyy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","paapo Heloti anndɨndɨlɨlaga Johani. Anndɨndɨlɨlaga paapo antiilaga, aalɨmmeenye ʉkʉja mundʉ ngolofu kangɨ mwikemo. Heloti aaliiganile ʉkʉmpɨlɨkɨsya Johani na paapo amasyʉ gaake gantaamyaga fiijo mu ndumbula. ");
INSERT INTO nyy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Helotija alɨnkʉkaaga akabalɨlo aka aakalondaga akaa kʉnngoga Johani. Pi isikʉ ɨlya kʉkʉmbʉka ʉkʉpaapigwa ʉmalafyale Heloti, alɨnkʉbabɨɨkɨla ɨkyaka abakʉʉlʉ, abalongosi baa basikali na bakʉlʉmba abaa mu Galilai. ");
INSERT INTO nyy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Po ʉmwana ʉndɨndwana ʉgwa Helotija alɨnkwingɨla nʉ kʉmoga, alɨnkʉbahobosya fiijo Heloti palɨkɨmo na baheesya boosa aba baalimo pakʉlya ɨfindʉ. Ʉmalafyale alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gʉʉsʉʉme fyosa ɨfi kʉlonda, ngʉkʉpa.” ");
INSERT INTO nyy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Alɨnkʉlapa alɨnkʉtɨ, “Akandʉ koosa aka kʉʉsʉʉmaga nikʉkʉpa, nalɨnga tukʉjabana pakatɨ na pakatɨ ɨkyʉma ɨkɨ kɨlɨ mbʉnyafyale bwangʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ʉndɨndwana alɨnkʉsooka panja, alɨnkwakʉnndaalʉʉsya ʉnna, alɨnkʉtɨ, “Nsʉʉme ɨfiki?” Ʉnna alɨnkwamula alɨnkʉtɨ, “Ʉntʉ ʉgwa Johani ʉMoosi.” ");
INSERT INTO nyy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nakalɨnga alɨnkʉbopa alɨnkʉgomoka kʉ malafyale, alɨnkʉsʉʉma alɨnkʉtɨ, “Ʉmbepo lʉlʉʉlʉ ʉntʉ ʉgwa Johani ʉMoosi mwi ibeeseni.” ");
INSERT INTO nyy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ʉmalafyale alɨnkʉsulumania fiijo, looli kʉnongwa jaa kʉlapa kwake, na kʉnongwa jaa bandʉ aba baalɨ pa lʉsekelo, akaalondaga ʉkʉnkaanila. ");
INSERT INTO nyy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Alɨnkʉntʉma ʉnsikali, alɨnkʉnndagɨla ʉkʉtɨ akatwale ʉntʉ ʉgwa Johani. Ʉnsikali alɨnkʉbʉʉka, alɨnkʉmmbuuta Johani ʉntʉ gwake mula mu nnyololo. ");
INSERT INTO nyy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Alɨnkʉgʉtwala ʉntʉ gwake mwi ibeeseni, nʉ kʉmpapo ʉndɨndwana jʉla, joope ʉndɨndwana alɨnkwakʉmpapo ʉnna. ");
INSERT INTO nyy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Po paapo abafundigwa baake Johani ʉMoosi, bo bapɨliike ɨnongwa ɨsyo, balɨnkʉbʉʉka, balɨnkwega ʉmfimba, balɨnkʉgʉsyɨla mwi ipʉmba. ");
INSERT INTO nyy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Abatʉmigwa balɨnkʉgomoka ʉkʉfuma kʉno aabatʉmile Jesu, balɨnkʉbʉngaana nkyeni mmyake, balɨnkʉmpangɨla ɨmbombo syosa ɨsi baabombile na ɨsi baamanyiisye. ");
INSERT INTO nyy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Baalipo abandʉ bingi kʉla, aba biisaga kwa Jesu nʉ kʉgomoka, Jesu na bafundigwa baake bakaalɨ na kabalɨlo nakamo akaa kʉlyamo ɨfindʉ. Po alɨnkʉbabʉʉla alɨnkʉtɨ, “Tʉbʉʉke kʉno twibeene tʉkiijeekele, mutʉʉsyepo panandɨ.” ");
INSERT INTO nyy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Balɨnkʉbʉʉka beene mwi ibooti pabʉjo ʉbʉ bʉkaja na bandʉ. ");
INSERT INTO nyy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Looli abandʉ bingi balɨnkʉbabona bo bikʉsookapo. Po abandʉ balɨnkʉbopa na malʉndɨ ʉkʉfuma ntwaja toosa, balɨnkwenda ɨnjɨla ɨjaa pi isɨɨlya, balɨnkʉtalapo ʉkʉfika. ");
INSERT INTO nyy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesu bo asulwike mwi ibooti, alɨnkʉkɨbona ɨkɨlʉndɨlo ɨkɨnywamu, kɨlɨnkʉmmwaga ɨkɨsa, baalɨ bo ʉlwa ngʼoosi ɨsi sikaja nʉ ntiimi. Po alɨnkwanda ʉkʉbamanyisya ɨnongwa ɨnyingi. ");
INSERT INTO nyy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Namajolo, abafundigwa baake balɨnkʉbʉʉka kwa Jesu, balɨnkʉtɨ, “Ʉbʉjo ʉbʉ tʉlipo lʉkʉbo, kangɨ ʉlʉ majolo. ");
INSERT INTO nyy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Balage abandʉ basookepo, ʉkʉtɨ babʉʉke ntwaja na mmigʉnda ɨgya kɨfuki, bakiijʉʉlɨle ɨfindʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Alɨnkʉbaamula alɨnkʉtɨ, “Amubapepo ʉmwe ɨfindʉ.” Balɨnkʉmmwamula balɨnkʉtɨ, “Poope lɨnga twajaga nasyo ɨndenali ɨmia ibɨlɨ, ʉkʉʉla ɨfisyesye fya kʉbapapo ʉkʉtɨ balyemo, fitikʉbafwana.” ");
INSERT INTO nyy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mulɨ nafyo ɨfisyesye filɨnga? Amubʉʉke mukakeete.” Bo bakeetile, balɨnkʉtɨ, “Tʉlɨ nafyo ɨfisyesye fihaano nɨ ɨswɨ ibɨlɨ.” ");
INSERT INTO nyy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesu alɨnkʉbalagɨla ʉkʉtɨ abandʉ boosa babatʉʉgasye mfibugutɨla pa liisʉ ɨliibɨsɨ. ");
INSERT INTO nyy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Balɨnkʉtʉʉgala mfibugutɨla ɨfya bandʉ ɨmia jɨmo nɨ fya bandʉ amalongo mahaano. ");
INSERT INTO nyy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Alɨnkwega ɨfisyesye fila fihaano, nɨ ɨswɨ sila ibɨlɨ, alɨnkʉkeeta kʉmwanya, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉfimenya ɨfisyesye, alɨnkʉbapapo abafundigwa baake ʉkʉtɨ babajabɨle abandʉ. Ɨɨswɨ ibɨlɨ sila, syope alɨnkʉbajabɨla boosa. ");
INSERT INTO nyy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Abandʉ boosa balɨnkʉlya, balɨnkwikʉta. ");
INSERT INTO nyy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Po abafundigwa baake balɨnkʉbʉngaania ɨfimeenya fya fisyesye nɨ ɨswɨ, balɨnkwisʉsya ɨfiibo kalongo na fibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Abanyambala aba baaliile baalɨ 5,000. ");
INSERT INTO nyy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nakalɨnga Jesu alɨnkʉbalagɨla abafundigwa baake ʉkʉtɨ biipakɨle mwi ibooti, batalepo ʉkʉbʉʉka kwi isɨɨlya kʉ Betisaita, bo ʉmwene alɨ pakʉkɨlaga ɨkɨlʉndɨlo kya bandʉ. ");
INSERT INTO nyy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bo amalile ʉkʉlagana nabo, alɨnkʉfyʉka mwene pa kyamba kʉkwipuuta. ");
INSERT INTO nyy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Namajolo, ɨliibooti lyalɨ pakatɨ paa sʉmbɨ, Jesu aakaalɨ kʉ kwi isɨɨlya mwene. ");
INSERT INTO nyy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Alɨnkʉbabona abafundigwa baake bikʉtaamigwa ʉkʉfiga, paapo ʉmbelo gwalɨ gwa maka, gwabapɨngaga. Po kʉbʉkye alɨnkʉbʉʉka kʉno baaliko, bo ikwenda pamwanya pa mɨɨsi. Aalondaga ʉkʉbakɨɨsania, ");
INSERT INTO nyy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","looli abeene bo bammbwene ikwenda pamwanya pa mɨɨsi, balɨnkwinogona ʉkʉtɨ nsyʉka, balɨnkʉkuuta fiijo. ");
INSERT INTO nyy_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Boosa bo bammbwene balɨnkʉtetema fiijo. Nakalɨnga Jesu alɨnkʉjoba nabo, alɨnkʉtɨ, “Mwikasye, jo ʉne! Mungatiilaga!” ");
INSERT INTO nyy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Alɨnkwipaka mwi ibooti muno baalimo, po ʉmbelo gʉlɨnkʉbota. Balɨnkʉnyomoka fiijo mu ndumbula syabo. ");
INSERT INTO nyy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bakaakyageenie ɨkiika ɨkya fisyesye, paapo ɨndumbula syabo syalɨ sito. ");
INSERT INTO nyy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesu na bafundigwa baake bo balobwike sʉmbɨ Galilai, balɨnkʉfika nkiisʉ ɨkya mu Genesaleti, balɨnkʉlyɨmɨka ɨliibooti nʉ kʉsuluka. ");
INSERT INTO nyy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nakalɨnga abandʉ aba baalipo pi isɨɨlya balɨnkwaga ʉkʉtɨ jo Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Balɨnkʉbopa nʉ kʉsyʉngʉʉtɨla nkiisʉ kɨla kyosa, balɨnkʉbapɨmba pa bʉlɨlɨ abandʉ aba baalɨ babine, balɨnkʉbatwala kwa Jesu, koosa kʉno baapɨlɨkaga ʉkʉtɨ aliko. ");
INSERT INTO nyy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Koosa kʉno aabʉʉkaga Jesu, pamo ntwaja, pamo mmigʉnda, abandʉ baabatwalaga ababine nʉ kʉbasulusya paa sokoni. Balɨnkʉmpyelesya Jesu ʉkʉtɨ abiitɨkɨsye ababine ʉkʉmpalamaasya, nalɨnga kɨje kɨpeto kya mwenda gwake. Po ababine boosa aba baalɨmpalamaasiisye, baabʉmbʉlwike. ");
INSERT INTO nyy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Po aBafalisai bamo na bamanyisi baa ndagɨlo sya Moose balɨnkwisa ʉkʉfuma mu Jelusalemu, balɨnkʉbʉngaana nkyeni mwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Balɨnkʉbabona abafundigwa baake bamo bikʉlya ɨfindʉ na maboko aga bakasugusula. ");
INSERT INTO nyy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ABajuuta boosa nnoono aBafalisai, batikʉlya kɨsita kʉsugusula amaboko, ʉkʉkongana nɨ nyiiho sya biisʉkʉlʉ baabo. ");
INSERT INTO nyy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kangɨ batikʉlya fyosa fila ɨfi fifumile kʉ sokoni mpaka bafisuke nʉ kʉsugusula. Siliko ɨnyiiho ɨsingi ɨsi bikʉsikonga, bo ɨsya kʉsuka ɨfikombe, ɨndeko nɨ fyombo. ");
INSERT INTO nyy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ABafalisai na bamanyisi baa ndagɨlo sya Moose balɨnkʉnndaalʉʉsya Jesu, balɨnkʉtɨ, “Fiki abafundigwa baako batikʉkonga ɨnyiiho ɨsi tʉsyambɨliile kʉ biisʉkʉlʉ bɨɨtʉ? Bikʉlya kɨsita kʉkonga ʉlwiho ʉlwa kʉsugusula amaboko.” ");
INSERT INTO nyy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Alɨnkʉbaamula alɨnkʉtɨ, “Mwe basyobi ʉmwe! Jeesaja aatalwisye ʉkʉkunguluka kʉmyɨnu, bo ikʉjoba ʉkʉtɨ, ‘Abandʉ aba, bikʉʉnyɨɨmɨka nɨ milomo itolo, looli ɨndumbula syabo silɨ kʉbʉtali na niine. ");
INSERT INTO nyy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bikʉʉnyiipuuta ʉne ɨsya itolo, paapo bikʉmanyisya ɨnyiiho ɨsya bandʉ, ngatɨ sya Kyala.’ ");
INSERT INTO nyy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Ʉmwe mukʉsileka ɨndagɨlo sya Kyala, mukʉsyʉmɨɨlɨla ɨnyiiho sya bandʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Mukʉsitaaga ɨndagɨlo sya Kyala kʉ bʉkomu, ʉkʉtɨ musikongege ɨnyiiho syɨnu. ");
INSERT INTO nyy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Namanga Moose aabalagiile ʉkʉtɨ, ‘Ʉmmwɨmɨkege ʉgʉʉso nʉ nyoko,’ kangɨ ʉkʉtɨ, ‘Ʉjʉ ikʉntʉka ʉgwise pamo ʉnna, jo agogigwege.’ ");
INSERT INTO nyy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Looli ʉmwe mukʉmanyisya mukʉtɨ, ‘Kanunu ʉmundʉ lɨnga ikʉmmbʉʉla ʉgwise pamo ʉnna, ikʉtɨ, “Ɨfi naalondaga ʉkʉkʉpapo ʉgwe ndikʉkʉpapo, mfibɨɨkile ʉkʉja Kolibani, kokʉtɨ ikemo kwa Kyala.” ’ ");
INSERT INTO nyy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kʉ njɨla ɨjo mukʉnsigɨla ʉmundʉ ʉjo ʉkʉntʉʉla ʉgwise pamo ʉnna. ");
INSERT INTO nyy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ʉko ko kʉlɨfujula iisyʉ lya Kyala, ʉkʉtɨ mukongege ɨnyiiho syɨnu ɨsi mukʉpokesania. Kangɨ mukʉbomba nyingi ɨsi sifwene bo ɨsyo.” ");
INSERT INTO nyy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesu alɨnkʉkɨkoolela kangɨ ɨkɨlʉndɨlo kya bandʉ, alɨnkʉbabʉʉla alɨnkʉtɨ, “Amumbɨlɨkɨsye mwesa, nʉ kʉsyagania! ");
INSERT INTO nyy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Akandʉ aka kalɨ panja pa mundʉ lɨnga kammwingiile kakabagɨla ʉkʉnnyasya. Looli fila fikʉsooka ʉkʉfuma mmyake, fyo fikʉnnyasya.  ");
INSERT INTO nyy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ʉjʉ alɨ nɨ mbʉlʉkʉtʉ ɨsya kʉpɨlɨkɨla, jo apɨlɨkɨsyege!” ");
INSERT INTO nyy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesu alɨnkʉkɨleka ɨkɨlʉndɨlo kya bandʉ, alɨnkwingɨla mu nyumba jɨmo pamopeene na bafundigwa baake. Balɨnkʉnndaalʉʉsya ɨsya kɨfwanikɨsyo kɨla. ");
INSERT INTO nyy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Bʉle, na nuumwe mukaja na mahala? Bʉle, mukasyagania ʉkʉtɨ akandʉ aka kikʉmmwingɨla ʉmundʉ ʉkʉfuma panja, kakabagɨla ʉkʉnnyasya? ");
INSERT INTO nyy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ɨfindʉ fitikʉmmwingɨla mu ndumbula, looli mwene mbʉla, po piitaasi fyende nʉ kʉsooka kʉ liisʉ.” (Nkʉjoba bo ʉlo, Jesu aafyelwisye ɨfindʉ fyosa.) ");
INSERT INTO nyy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kangɨ alɨnkʉjoba alɨnkʉtɨ, “Ɨsi sikʉsooka nkatɨ mmundʉ syo ɨsi sikʉnnyasya. ");
INSERT INTO nyy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kaabʉno nkatɨ mu ndumbula sya bandʉ mo sikʉfuma ɨnyiinogono ɨmbiibi, ʉbʉlogwe, ʉbʉhɨɨji, ʉbʉgogi, ");
INSERT INTO nyy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ɨfinyonyo, ʉbʉbiibi, ʉbʉsyobi, ʉbʉʉfi, akabini, amaheelu, amatingo nʉ bʉkonyofu. ");
INSERT INTO nyy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ɨmbiibi syosa ɨsi sikʉfuma nkatɨ mu ndumbula jaa mundʉ, syo sikʉnnyasya ʉmundʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu alɨnkʉsookapo apa aalipo, alɨnkʉbʉʉka nkiisʉ ɨkya mu Tili. Alɨnkwingɨla mu nyumba jɨmo, akaalondaga abandʉ ʉkʉmanya apa aalipo, looli poope aatoliigwe ʉkwifisa. ");
INSERT INTO nyy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Po aaliko ʉnkiikʉlʉ jʉmo, ʉjʉ ʉmwanaake ʉndɨndwana aalɨ nɨ mbepo ɨnyali. Alɨnkʉpɨlɨka ɨnongwa sya Jesu, alɨnkwisa, alɨnkʉgwa mmalʉndɨ gaake. ");
INSERT INTO nyy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ʉnkiikʉlʉ ʉjʉ akaalɨ Njuuta, aalɨ Nsilofoinike. Alɨnkʉnsʉʉma Jesu ʉkʉtɨ asikage ɨmbepo ɨnyali mmwanaake ʉndɨndwana. ");
INSERT INTO nyy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Leka taasi abaana biikʉte. Sikaja kanunu ʉkwega ɨfindʉ ɨfya baana nʉ kʉsisopela ɨmbwa.” ");
INSERT INTO nyy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Leelo ʉnkiikʉlʉ jʉla alɨnkʉmmwamula alɨnkʉtɨ, “Moomuumo, gwe Ntwa, leelo nɨ mbwa syope ɨsi silɨ kʉʉsi kʉ meesa, sikʉlya ʉtʉbululukɨsya ʉtʉ tukʉsatʉka paasi.” ");
INSERT INTO nyy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesu alɨnkʉmmbʉʉla ʉnkiikʉlʉ jʉla, alɨnkʉtɨ, “Kʉnongwa jaa ɨsyo ʉjobile, bʉʉkaga, ɨmbepo ɨnyali jɨsookilemo mmwanaako.” ");
INSERT INTO nyy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Po paapo ʉnkiikʉlʉ jʉla alɨnkʉbʉʉka kʉkaaja kaake, alɨnkʉmmwaga ʉmwanaake alambaleele pa kɨtala nɨ mbepo ɨnyali jɨsookilemo. ");
INSERT INTO nyy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesu alɨnkʉsookako kʉ Tili, alɨnkwendela ɨnjɨla ɨjaa mu Sitoni, alɨnkʉbʉʉka mpaka kwa sʉmbɨ Galilai ʉkʉtumusania nkiisʉ ɨkya mu Ndekapoli. ");
INSERT INTO nyy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Abandʉ bamo balɨnkʉntwalɨla ʉmundʉ ʉgwa mapʉlɨ ʉjʉ kangɨ atikʉjoba kanunu, balɨnkʉnsʉʉma ʉkʉtɨ ammbɨɨkepo amaboko, ʉkʉtɨ ammbʉmbʉlʉsye. ");
INSERT INTO nyy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Alɨnkʉmmwega ʉmundʉ jʉla pa kɨlʉndɨlo kya bandʉ, alɨnkʉnsookapo nagwe, alɨnkwijeekela nagwe. Alɨnkʉbɨɨka ɨnyoobe mu mbʉlʉkʉtʉ, po alɨnkʉswa amata, alɨnkʉmpalamaasya ʉlʉlɨmi. ");
INSERT INTO nyy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Po alɨnkʉkeeta kʉmwanya, alɨnkʉtʉʉkɨsya, alɨnkʉmmbʉʉla ʉgwa mapʉlɨ, alɨnkʉtɨ, “Efata!” Kokʉtɨ, “Igʉka!” ");
INSERT INTO nyy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nakalɨnga ɨmbʉlʉkʉtʉ syake silɨnkwigʉka, ɨkɨfundo kya lʉlɨmi lwake kɨlɨnkʉlegela, alɨnkwanda ʉkʉjoba kanunu. ");
INSERT INTO nyy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesu alɨnkʉbalagɨla ʉkʉtɨ balɨngammbʉʉlaga ʉmundʉ najʉmo. Looli bo ikʉbakaanisya fiijo, po abeene balɨnkʉkɨndɨlɨla fiijo ʉkʉfumusya ɨnongwa ɨsyo. ");
INSERT INTO nyy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Balɨnkʉswiga fiijo, balɨnkʉtɨ, “Abombile syosa kanunu! Boope abaa mapʉlɨ ikʉbapela ʉkʉtɨ bapɨlɨkege, aba batikʉjoba ʉkʉtɨ bajobege.” ");
INSERT INTO nyy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mmasikʉ gala kangɨ, ɨkɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ baabʉngeene nkyeni mwa Jesu. Kʉ mmalɨɨkɨsyo ɨfindʉ fyabo filɨnkʉmalɨka. Jesu alɨnkʉbabɨlɨkɨla abafundigwa baake, alɨnkʉbabʉʉla alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ngʉbapaakɨsya abandʉ aba, paapo amasikʉ matatʉ balɨndile na niine, lɨɨlɨno bakaja nɨ findʉ. ");
INSERT INTO nyy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Lɨnga ʉne ngʉbalaga ʉkʉtɨ babʉʉkege kʉkaaja, bo balɨ nɨ njala aabikʉfwa ʉlʉsɨ, paapo bamo bafumile kʉbʉtali.” ");
INSERT INTO nyy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Abafundigwa baake balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Pa lʉkʉbo apa tʉfyage kʉʉgʉ ɨfindʉ ɨfya kwikʉta boosa?” ");
INSERT INTO nyy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Po Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mulɨ nafyo ɨfisyesye filɨnga?” Balɨnkʉmmwamula balɨnkʉtɨ, “Tʉlɨ nafyo fihaano na fibɨlɨ!” ");
INSERT INTO nyy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Po Jesu alɨnkʉbalagɨla abandʉ ʉkʉtɨ batʉʉgale paasi. Alɨnkwega ɨfisyesye ɨfyo fihaano na fibɨlɨ, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉfimenyania, alɨnkʉbapapo abafundigwa baake ʉkʉtɨ babajabɨle abandʉ, po balɨnkʉbajabɨla. ");
INSERT INTO nyy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Baalɨ nato toope ʉtʉswɨ tʉnandɨ. Alɨnkʉgwa ʉlʉpi kwa Kyala kʉ tʉswɨ ʉto, alɨnkʉbalagɨla ʉkʉtɨ babajabɨle abandʉ. ");
INSERT INTO nyy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Abandʉ boosa balɨnkʉlya, balɨnkwikʉta. Po abafundigwa balɨnkʉbʉngaania ɨfi fyasyele, balɨnkwisʉsya ɨfiibo fihaano na fibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Aba baaliile baalɨ bandʉ 4,000 bʉno. Po Jesu alɨnkʉbalaga. ");
INSERT INTO nyy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Alɨnkʉsumuka nʉ kwingɨla mwi ibooti pamopeene na bafundigwa baake, balɨnkʉbʉʉka, balɨnkwakʉfika mu Ndalimanuta. ");
INSERT INTO nyy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Po bo bafikile kʉla, aBafalisai bamo balɨnkʉnkonga. Balɨnkwanda ʉkʉkaanikana nagwe nʉ kʉnngela ʉkʉtɨ abombe ɨkiika ʉkʉja kɨmanyilo ʉkʉnangɨsya ʉkʉtɨ atʉmiigwe na Kyala. ");
INSERT INTO nyy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Alɨnkʉtʉʉkɨsya alɨnkʉtɨ, “Keeta abandʉ abaa nkabalɨlo aka bikʉlonda ɨkɨmanyilo? Nalooli nikʉbabʉʉla nikʉtɨ, batikʉpeeligwa ɨkɨmanyilo nakɨmo.” ");
INSERT INTO nyy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Po Jesu alɨnkʉbaleka, alɨnkwipaka kangɨ mwi ibooti pamopeene na bafundigwa baake, balɨnkʉloboka ʉkʉbʉʉka kwi isɨɨlya ɨlya sʉmbɨ Galilai. ");
INSERT INTO nyy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Abafundigwa baaliibiibwe ʉkwega ɨfisyesye, looli baalɨ nakyo ɨkɨsyesye kɨmokyene itolo mwi ibooti. ");
INSERT INTO nyy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Po Jesu alɨnkʉbasoka, alɨnkʉtɨ, “Mujege maaso nʉ nkese ʉgwa Bafalisai nʉ gwa Heloti.” ");
INSERT INTO nyy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Abafundigwa bala balɨnkwanda ʉkʉjobesania, balɨnkʉtɨ, “Ikʉjoba bo ʉlo paapo tʉkaja nɨ fisyesye.” ");
INSERT INTO nyy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu alɨnkʉmanya ɨsi baajobaga, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Fiki mukʉkaanikana ʉkʉtɨ mukaja nɨ fisyesye? Bʉle, mukaalɨ mutikʉsyagania? Bo bʉsito bʉki ɨndumbula syɨnu? ");
INSERT INTO nyy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Amaaso mulɨ nago, fiki mutikʉkeeta? Ɨmbʉlʉkʉtʉ mulɨ nasyo, fiki mutikʉpɨlɨka? Bʉle, poope mutikʉkʉmbʉka ");
INSERT INTO nyy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","lʉla naamenyaniaga ɨfisyesye fihaano nʉ kʉbaswɨla abandʉ 5,000? Bʉle, mwabʉngeenie ɨfiibo filɨnga ɨfya fimeenya ɨfi fyasyele?” Balɨnkʉmmwamula balɨnkʉtɨ, “Kalongo na fibɨlɨ.” ");
INSERT INTO nyy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesu aabalaalʉʉsiisye kangɨ aatile, “Nɨ fisyesye fila fihaano na fibɨlɨ kʉ bandʉ bala 4,000, bʉle, mwabʉngeenie ɨfiibo filɨnga ɨfiisʉle?” Balɨnkʉmmwamula balɨnkʉtɨ, “Fihaano na fibɨlɨ.” ");
INSERT INTO nyy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Po mukaalɨ mukasyagania?” ");
INSERT INTO nyy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Po Jesu na bafundigwa baake balɨnkʉsookapo pala balɨnkʉfika mu Betisaita. Kʉla balɨnkʉntwalɨla ʉmfwa maaso, balɨnkʉnsʉʉma ʉkʉtɨ ampalamaasye nʉ kʉmmbʉmbʉlʉsya. ");
INSERT INTO nyy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Alɨnkʉnkola ɨkɨboko ʉmfwa maaso jʉla, alɨnkʉsookapo nagwe ʉkʉfuma nkɨpanga ɨkɨ baalipo. Alɨnkʉnswela amata mmaaso, alɨnkʉmmbɨɨkapo amaboko gaake. Po Jesu alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Bʉle, kʉfibona fimo?” ");
INSERT INTO nyy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ʉmfwa maaso jʉla alɨnkʉkeeta mmwanya, alɨnkʉtɨ, “Ngʉbabona abandʉ ngatɨ mipiki, bikʉsyʉngʉʉtɨla.” ");
INSERT INTO nyy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Po kangɨ alɨnkʉbɨɨka amaboko pamaaso gaake, ʉmfwa maaso alɨnkʉgalʉʉlɨka amaaso, alɨnkʉpona, alɨnkʉkeeta kanunu kʉkʉtɨ kandʉ. ");
INSERT INTO nyy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesu alɨnkʉntʉma kʉmyabo, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉlɨngenda nkaaja bo kʉbʉʉka kʉmyɨnu.” ");
INSERT INTO nyy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Po paapo Jesu na bafundigwa baake balɨnkʉbʉʉka mfipanga fya kaaja kaa mu Kesalija Filipi. Bo balɨ mu njɨla, alɨnkʉbalaalʉʉsya abafundigwa baake alɨnkʉtɨ, “Abandʉ bikʉtɨ, ʉne ne ani?” ");
INSERT INTO nyy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Balɨnkʉmmwamula balɨnkʉtɨ, “Bamo bikʉtɨ gwe Johani ʉMoosi, abangɨ bikʉtɨ ʉgwe jo nkunguluka Elija, na bangɨ bikʉtɨ ʉgwe jo jʉmo mbakunguluka abangɨ.” ");
INSERT INTO nyy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Po Jesu alɨnkʉbalaalʉʉsya abeene, alɨnkʉtɨ, “Na nuumwe mukʉtɨ, ʉne ne ani?” Po Peeteli alɨnkʉmmwamula alɨnkʉtɨ, “Ʉgwe gwe Meesija, ʉMpoki ʉjʉ Kyala aatile ikʉntʉma.” ");
INSERT INTO nyy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Po Jesu alɨnkʉbasoka ʉkʉtɨ balɨngammbʉʉlaga ʉmundʉ najʉmo, ʉkʉtɨ ʉmwene jo Meesija. ");
INSERT INTO nyy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Po paapo alɨnkwanda ʉkʉbamanyisya abafundigwa baake alɨnkʉtɨ, “Ʉne Nnyamundʉ mpaka ngabe ɨngʉbɨlo nyingi nʉ kʉkaanigwa na balongosi baa Bajuuta, abapuuti abalongosi na bamanyisi baa ndagɨlo sya Moose, mpaka ʉkʉgogigwa. Po pi isikʉ lya bʉtatʉ, ngwisa kʉsyʉka.” ");
INSERT INTO nyy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ʉmwene aajobaga ɨliisyʉ ɨlɨ pabwelu itolo. Po Peeteli alɨnkʉmmwega kʉmbalɨ, alɨnkwanda ʉkʉnkemela. ");
INSERT INTO nyy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesu alɨnkʉsanuka, alɨnkʉbakeeta abafundigwa baake, alɨnkʉnkemela Peeteli, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Kɨnda kʉnyuma kʉmyangʉ, ʉgwe Seetano! Ʉtikʉsiinogona ɨsya Kyala, looli ɨsya bandʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Po alɨnkʉkɨbɨlɨkɨla ɨkɨlʉndɨlo kya bandʉ palɨkɨmo na bafundigwa baake. Alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉmundʉ gwesa ʉjʉ ikʉlonda ʉkʉngonga, jo fikʉtɨ alɨngiipaakɨsyaga na panandɨ, nalɨnga aikʉgogigwa pa kɨkohekano kʉnongwa jangʉ, angongege. ");
INSERT INTO nyy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ʉjʉ lɨnga ikʉlonda ʉkʉbʉponesya ʉbʉʉmi bwake, ikʉbʉpeesyaga ʉbʉʉmi bwa bwila na bwila. Looli ʉmundʉ ʉjʉ atikʉpaasya ʉkʉfwa kʉnongwa jangʉ na kʉnongwa jaa Ndʉmi ɨNunu, jo ikʉbʉkabaga ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Eemwa, kalɨ ʉmundʉ fikʉmmbʉmbʉlɨla ɨfiki ʉkʉkɨkaba ɨkyʉma kyosa ɨkya nkiisʉ, looli ikʉbʉpeesya ʉbʉʉmi bwa bwila na bwila? ");
INSERT INTO nyy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Pamo ʉmundʉ abagiile ʉkʉsoosya ɨfiki pabʉjo bwa bʉʉmi bwa bwila na bwila? ");
INSERT INTO nyy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ʉmundʉ gwesa ʉjʉ ikʉʉfwɨlaga ɨsoni ʉne na masyʉ gangʉ, mmbandʉ baa tʉbalɨlo ʉtʉ, abalogwe na batʉlanongwa boosa, ne Nnyamundʉ ngwisa kʉmfwɨla ɨsoni ʉmundʉ ʉjo, bo ngwisa mbʉsisya bwa Taata pamopeene na bandʉmi abiikemo.” ");
INSERT INTO nyy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, balipo bamo papaapa aba batikʉfwa mpaka taasi babʉbone ʉBʉnyafyale bwa Kyala bo bukwisa na maka.” ");
INSERT INTO nyy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Amasikʉ ntandatʉ bo gakɨndile, Jesu alɨnkʉbeega baa Peeteli, Jaakobo na Johani, balɨnkʉfyʉka pamwanya pa kyamba ɨkɨtali fiijo, po alɨnkwijeekela nabo kʉla. Bo balɨ kʉla, Jesu alɨnkwandʉka ʉmbɨlɨ nkyeni mmyabo, ");
INSERT INTO nyy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ɨmyenda gyake gyalɨ myelu gyanyekukaga fiijo, najʉmo ʉnsuka myenda ʉgwa nkiisʉ abagiile ʉkʉgyelʉsya bo gɨla. ");
INSERT INTO nyy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Po balɨnkʉsetʉka abakunguluka Elija na Moose, baajobaga na Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Po Peeteli alɨnkʉmmbʉʉla Jesu, alɨnkʉtɨ, “Gwe Mmanyisi, kanunu ʉswe ʉkʉjapo apa. Tʉjenge ɨfitembe fitatʉ. Kɨmo kɨje kyako, ɨkɨngɨ kya Moose, nɨ kɨngɨ kɨje kya Elija.” ");
INSERT INTO nyy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Akaameenye ɨsya kʉjoba, paapo baanyomwike fiijo. ");
INSERT INTO nyy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Po lɨlɨnkwisa iibɨngo, lɨlɨnkʉbakupɨkɨla. Po balɨnkʉpɨlɨka iisyʉ ʉkʉfuma mwi ibɨngo lɨlɨnkʉtɨ, “Ʉjʉ jo Mwanangʉ ʉNkʉndwe, mumpɨlɨkɨsyege!” ");
INSERT INTO nyy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nakalɨnga, abafundigwa bo bikʉkelengania kʉno na kʉno, balɨnkʉsita kʉmmbona najʉmo, looli Jesu mwene aalɨ pamopeene nabo. ");
INSERT INTO nyy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Po bo bikʉsuluka ʉkʉfuma nkyamba, Jesu alɨnkʉbalagɨla abafundigwa bala alɨnkʉtɨ, “Mulɨngammbʉʉlaga ʉmundʉ najʉmo ɨsi musibwene mpaka akabalɨlo aka Nnyamundʉ ikwisa kʉsyʉka ʉkʉfuma mbafwe.” ");
INSERT INTO nyy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Baalɨkolile ɨliisyʉ ɨlyo, balɨnkʉlaalʉʉsania ʉkʉtɨ ʉkʉsyʉka ʉkʉfuma mbafwe kokʉtɨ fiki? ");
INSERT INTO nyy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Keeta, abamanyisi baa ndagɨlo sya Moose bikʉtɨ Elija jo ikʉtalapo taasi ʉkwisa, bo Meesija akaalɨ?” ");
INSERT INTO nyy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Alɨnkʉbaamula alɨnkʉtɨ, “Nalooli Elija jo ikʉtala ʉkwisa, ʉkʉtɨ atendekesye syosa. Pamopeene na ɨsi, fiki sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ Nnyamundʉ ikwisa kʉkʉbɨlwa nʉ kʉfujuligwa? ");
INSERT INTO nyy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Looli nikʉbabʉʉla nikʉtɨ, Elija iisile, baalɨmmbombiile ɨmbiibi syosa ɨsi baalondaga, bo muno sisimbiigwe mwa Kalata ʉMwikemo.” ");
INSERT INTO nyy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesu na bafundigwa bala batatʉ balɨnkʉfika apa baalipo abafundigwa aba baasyele. Balɨnkʉbabona basyʉngʉʉtɨliigwe nɨ kɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ, na bamanyisi baa ndagɨlo sya Moose bakaanikanaga nabo. ");
INSERT INTO nyy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nakalɨnga abandʉ abo bo bammbwene Jesu balɨnkʉswiga, balɨnkʉmmbopela, balɨnkʉmponia. ");
INSERT INTO nyy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mukʉkaanikana nabo sya fiki?” ");
INSERT INTO nyy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ʉmundʉ jʉmo nkɨlʉndɨlo alɨnkʉmmwamula alɨnkʉtɨ, “Gwe Mmanyisi, nʉntwele ʉmwanangʉ kʉmyako, alɨ nɨ mbepo ɨjaa kʉsita kʉjoba. ");
INSERT INTO nyy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kʉkʉtɨ jɨnkolile, jikʉmmbiga paasi, ikʉsooka ʉntotoofula nʉ kʉsyegetula amiino, nʉ kʉʉma. Mbasʉʉmile abafundigwa baako ʉkʉtɨ bajɨkage ɨmbepo ɨnyali, looli batoliigwe.” ");
INSERT INTO nyy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mwe, bandʉ baa nkabalɨlo aka, mwe mukaja nʉ lwitɨko ʉmwe! Moonangiike! Bʉle, ngʉtʉʉgala pamopeene na nuumwe nʉ kʉbakeetelela mpaka ndɨli? Namuntwale kʉmyangʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Balɨnkʉntwala kʉmyake, ɨmbepo ɨjo bo jɨmmbwene Jesu, jɨlɨnkʉnnjʉgaania ʉmwanike, po alɨnkʉgwa paasi, alɨnkʉbunguluka, gʉlɨnkʉsooka ʉntotoofula nkanwa. ");
INSERT INTO nyy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu alɨnkʉnndaalʉʉsya ʉgwise alɨnkʉtɨ, “Bʉmmwagile ʉbʉbine ʉbʉ ʉkʉfuma ndɨli?” Alɨnkʉtɨ, “Ʉkʉfuma mbʉkeke. ");
INSERT INTO nyy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kaa kingi ɨmbepo ɨnyali ɨjɨ jikʉntaaga lʉmo mmooto lʉmo mmɨɨsi, ʉkʉtɨ jɨnngoge. Looli lɨnga ʉbagiile ʉkʉbomba simo, ʉtʉpaakɨsye nʉ kʉtʉtʉʉla.” ");
INSERT INTO nyy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Fiki kʉtɨ, ‘Lɨnga ʉbagiile?’ Syosa sibagiile kʉlɨ ʉjʉ alɨ nʉ lwitɨko kwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nakalɨnga ʉgwise gwa mwanike alɨnkʉlaata alɨnkʉtɨ, “Ngwitɨka, looli ʉndʉʉle ndɨngiilaamwaga.” ");
INSERT INTO nyy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu bo ikʉkɨbona ɨkɨlʉndɨlo kya bandʉ kɨkongelela mbɨbɨmbɨbɨ, alɨnkʉjɨkemela ɨmbepo ɨnyali jɨla. Alɨnkʉjɨbʉʉla alɨnkʉtɨ, “Gwe mbepo jaa kʉsita kʉjoba na mapʉlɨ, ʉne nikʉkʉlagɨla, sookamo mmundʉ ʉjʉ ʉngiisa kʉmmwingɨlamo sikʉ!” ");
INSERT INTO nyy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ɨmbepo ɨnyali jɨlɨnkʉkuuta, jɨlɨnkʉnnjʉgaania fiijo ʉmwanike, jɨlɨnkʉsookamo. Ʉmwanike alɨnkʉfwana mfimba, ko kʉno abandʉ bingi balɨnkʉtɨ, “Afwile.” ");
INSERT INTO nyy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Looli Jesu alɨnkʉnkola ɨkɨboko kyake, alɨnkʉmmwinʉla. Po ʉmwanike jʉla alɨnkwɨma. ");
INSERT INTO nyy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesu alɨnkwingɨla mu nyumba jɨmo pamopeene na bafundigwa baake. Bo biijeekiile balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Fiki ʉswe tʉtoliigwe ʉkʉjɨkaga ɨmbepo ɨnyali jɨla?” ");
INSERT INTO nyy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Ɨmbepo jaa lʉko ʉlʉ jɨtikʉsookamo, looli kwene ʉkʉsʉʉma kwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Balɨnkʉsookako ʉko, balɨnkʉtumusania mu Galilai. Jesu akaalondaga ʉkʉtɨ jʉmo amanye ʉkʉtɨ alipo, ");
INSERT INTO nyy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","paapo aabamanyisyaga abafundigwa baake beene, alɨnkʉbabʉʉla alɨnkʉtɨ, “Ne Nnyamundʉ ngwisa kʉbɨɨkigwa mmaboko agaa balʉgʉ. Bikwisa kʉʉngoga, looli pi isikʉ lya bʉtatʉ, ngwisa kʉsyʉka.” ");
INSERT INTO nyy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Looli abafundigwa baake bakaasyageenie ɨsi aajobaga, baatiilaga ʉkʉnndaalʉʉsya. ");
INSERT INTO nyy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Po balɨnkʉfika kʉ Kapelinaʉmu, balɨnkwingɨla mu nyumba jɨmo. Bo balɨ mula, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mwakaanikanaga sya fiki bo tʉlɨ mu njɨla?” ");
INSERT INTO nyy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Looli abeene balɨnkʉja kɨmyemye, paapo mu njɨla baakaanikanaga, ʉkʉtɨ jwani jo nkʉlʉmba nkɨbugutɨla kyabo. ");
INSERT INTO nyy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesu alɨnkʉtʉʉgala paasi, alɨnkʉbakoolela bala kalongo na babɨlɨ, alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉmundʉ ʉjʉ ikʉlonda ʉkʉja gwa kwanda, jo ikʉlondigwa ʉkʉja gwa kʉmmalɨɨkɨsyo, kangɨ ajege mbombeli gwa boosa.” ");
INSERT INTO nyy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Po alɨnkʉmmwega ʉmwanike, alɨnkʉmmbɨɨka pakatɨ pamyabo, alɨnkʉmmʉʉbatɨla alɨnkʉbabʉʉla alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ʉmundʉ ʉjʉ ikʉmmwambɨlɨla ʉmwanike jʉmo bo ʉjʉ, mu ngamu jangʉ, ikʉʉnyambɨlɨla ʉne. Ʉjʉ ikʉʉnyambɨlɨla ʉne, atikʉʉnyambɨlɨla ʉne niimwene, looli ikʉmmwambɨlɨla joope ʉjʉ andʉmile.” ");
INSERT INTO nyy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johani alɨnkʉmmbʉʉla Jesu, alɨnkʉtɨ, “Gwe Mmanyisi, twalɨmmbwene ʉmundʉ jʉmo ikʉkaga ɨmbepo ɨnyali mu ngamu jaako. Twalɨnkaaniisye, paapo akaja pamopeene na nuuswe.” ");
INSERT INTO nyy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Looli Jesu alɨnkʉtɨ, “Mulɨngankaanisyaga, paapo akajako ʉmundʉ ʉjʉ ikʉbomba ɨkiika mu ngamu jangʉ, kangɨ nakalɨnga ende nʉ kʉʉnjoba ʉne ʉbʉbiibi. ");
INSERT INTO nyy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ʉjʉ atikʉkɨndana na nuuswe, jo alɨ kʉkɨbafu kyɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kangɨ lɨnga jʉmo ikʉbanwesya ʉmwe ɨkɨkombe kya mɨɨsi mu ngamu jangʉ, paapo ʉmwe mulɨ bandʉ baa Kɨlɨsiti, nalooli nikʉbabʉʉla, atikwisa kʉpondwa ɨfihombigwa kwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Lɨnga kʉnsobesya jʉmo mmbandʉ abafujufu aba bikʉʉnyiitɨka ʉne, ngalɨ kʉnunu fiijo kʉmyako ʉkʉpinyigwa ʉlwala mmakosi gaako, nʉ kʉsopigwa mu nyanja. ");
INSERT INTO nyy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kangɨ lɨnga ɨkɨboko kyako kikʉkʉsofya, kɨtumule! Kʉnunu ʉkwingɨla mbʉʉmi bwa bwila na bwila, bo ʉlɨ nɨ kɨlema, ʉkʉkɨnda ʉkʉja na maboko mabɨlɨ nʉ kwingɨla ndʉpanga lwa mooto ʉgʉ gʉtikʉsimamo sikʉ.  ");
INSERT INTO nyy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mbʉjo ʉbo ɨfwingili sitikʉfwa nʉ mooto gʉtikʉsima. ");
INSERT INTO nyy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Lɨnga ɨkɨlʉndɨ kyako kikʉkʉsofya, kɨtumule! Kʉnunu ʉkwingɨla mbʉʉmi bwa bwila na bwila, bo ʉlɨ nɨ kɨlema, ʉkʉkɨnda ʉkʉja na malʉndɨ mabɨlɨ nʉ kʉsopigwa ndʉpanga lwa mooto.  ");
INSERT INTO nyy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mbʉjo ʉbo ɨfwingili sitikʉfwa nʉ mooto gʉtikʉsima. ");
INSERT INTO nyy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nɨ kɨsige kyako lɨnga kikʉkʉsofya, kɨfyʉle, ʉkɨtaage. Kʉnunu ʉkwingɨla mBʉnyafyale bwa Kyala, bo ʉlɨ nɨ kɨsige kɨmo, ʉkʉkɨnda ʉkʉja nɨ fisige fyofibɨɨlɨ nʉ kʉsopigwa ndʉpanga lwa mooto, ");
INSERT INTO nyy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","mbʉjo ʉbo ɨfwingili sitikʉfwa nʉ mooto gʉtikʉsima. ");
INSERT INTO nyy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kʉkʉtɨ mundʉ ikwisa kwelʉsigwa nʉ mooto, bo apa ɨliikemo likwelʉsigwa nʉ muunyu. ");
INSERT INTO nyy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ʉmuunyu nnunu, looli ʉmuunyu lɨnga gʉsʉʉkile, ʉbagiile bʉleebʉle ʉkʉgomokesyamo ʉbʉnunu? Mujege nʉ muunyu nkatɨ mmyɨnu, kangɨ mujege nʉ lʉtengaano na biinɨɨnu.” ");
INSERT INTO nyy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Po paapo Jesu alɨnkʉsookapo pala, alɨnkʉbʉʉka nkiisʉ kya Jutai na kwi isɨɨlya ɨlya lwɨsi Jolitani. Ɨkɨlʉndɨlo ɨkɨnywamu kɨlɨnkʉbʉʉka kʉmyake kɨlɨnkʉbʉngaana. Alɨnkʉmanyisya kangɨ bo muno aabombelaga ʉmwene. ");
INSERT INTO nyy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Po aBafalisai bamo balɨnkʉmmbʉʉkɨla ʉkʉtɨ bantege, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, ʉlʉlagɨlo lwɨtʉ lukwitɨkɨsya ʉkʉtɨ ʉnnyambala ansoosyege ʉnkasi?” ");
INSERT INTO nyy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesu alɨnkwamula alɨnkʉtɨ, “Moose aabalagiile aatile fiki?” ");
INSERT INTO nyy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Balɨnkʉtɨ, “Moose aaliitɨkiisye ʉnnyambala ʉkʉsimba kalata ʉgwa kʉnsoosya ʉnkasi, nʉ kʉnndeka.” ");
INSERT INTO nyy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Moose aabasimbiile ʉlʉlagɨlo ʉlʉ kʉnongwa jaa bʉkafu bwa ndumbula syɨnu. ");
INSERT INTO nyy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Looli ʉkʉfuma kʉbwandɨlo, Kyala bo ikʉpela ɨkiisʉ, ‘Aabapelile ʉnnyambala nʉ nkiikʉlʉ.’ ");
INSERT INTO nyy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Kʉnongwa ɨjo ʉnnyambala ikʉnndeka ʉgwise nʉ nna, ikʉmmʉʉmɨɨlɨlaga ʉnkasi, ");
INSERT INTO nyy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","bobabɨɨlɨ bikʉjaga mbɨlɨ gʉmogwene.’ Po nikʉbabʉʉla nikʉtɨ, batikʉja babɨlɨ kangɨ, looli mbɨlɨ gʉmogwene. ");
INSERT INTO nyy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Po leelo aka akakʉngɨseenie Kyala, ʉmundʉ alɨngakapaagʉlaniaga.” ");
INSERT INTO nyy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jesu alɨnkwingɨla mu nyumba jɨmo na bafundigwa baake. Po balɨnkʉnndaalʉʉsya ɨnongwa ɨsya kʉsoosya abakiikʉlʉ. ");
INSERT INTO nyy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Alɨnkʉbaamula alɨnkʉtɨ, “Ʉmundʉ gwesa ʉjʉ anndekile ʉnkasi, nʉ kwega ʉjʉngɨ, ikʉlogwa. ");
INSERT INTO nyy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Joope nʉ nkiikʉlʉ lɨnga asookile kʉ ndʉme nʉ kwegigwa nʉ mundʉ ʉjʉngɨ, ikʉlogwa.” ");
INSERT INTO nyy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Po abandʉ balɨnkʉntwalɨla Jesu abaanaabo abaniini ʉkʉtɨ abapalamaasye, looli abafundigwa baake balɨnkʉbakemela. ");
INSERT INTO nyy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Looli Jesu bo asibwene ɨsi silɨnkʉnkalasya fiijo, alɨnkʉbabʉʉla abafundigwa alɨnkʉtɨ, “Namubaleke abaana abaniini biisege kʉmyangʉ, mulɨngabasigɨlaga, paapo ʉBʉnyafyale bwa Kyala bwa bandʉ aba balɨ bo abaana aba. ");
INSERT INTO nyy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nalooli nikʉbabʉʉla, ʉmundʉ gwesa ʉjʉ atikʉnsʉʉbɨla Kyala, bo ʉmwana ʉnniini muno ikʉbasʉʉbɨla abapaapi, atikwingɨla sikʉ mBʉnyafyale bwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Alɨnkʉbeega abaana bala, alɨnkʉbʉʉbatɨla, alɨnkʉbɨɨkapo amaboko gaake pamwanya pamyabo, alɨnkʉbasaja. ");
INSERT INTO nyy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesu alɨnkʉsookapo pala. Bo ikwenda mu njɨla, ʉmundʉ jʉmo alɨnkʉmmbopela, alɨnkʉfugama nkyeni mmyake. Alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Gwe Mmanyisi Nnunu, mbombe ɨfiki ʉkʉtɨ ngabe ʉbʉʉmi bwa bwila na bwila?” ");
INSERT INTO nyy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Fiki kʉʉnjoba ʉkʉtɨ ndɨ nnunu? Akajako ʉnnunu, looli aliko jʉmojwene, jo Kyala! ");
INSERT INTO nyy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ʉsimeenye ɨndagɨlo, ‘Ʉlɨngagogaga, ʉlɨngalogwaga, ʉlɨngahɨɨjaga, ʉlɨngajaga nkeeti gwa bʉtʉngʉlʉ, ʉlɨngasyobaga, ʉmmwɨmɨkege ʉgʉʉso nʉ nyoko.’ ” ");
INSERT INTO nyy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Joope alɨnkʉtɨ, “Gwe Mmanyisi, ɨndagɨlo syosa ɨsyo nsikolile ʉkʉfuma mbʉkeke bwangʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu alɨnkʉnkeeta alɨnkʉnngana, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwagiilwe kamokeene. Bʉʉka ʉkʉʉlɨsye ʉtʉndʉ toosa ʉtʉ ʉlɨ nato, ɨndalama ɨsyo ʉbajabɨle abalondo. Lɨnga ʉbombile bo ʉlo, bo gwibɨɨkiile ɨkyʉma kʉmwanya. Po gwise gʉngongege.” ");
INSERT INTO nyy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Looli ʉmwene bo apɨliike ɨsyo alɨnkʉsulumania nʉ kwilʉka kʉmaaso. Alɨnkʉsookapo ʉnsulumanie, paapo aalɨ nɨ kyʉma kingi fiijo. ");
INSERT INTO nyy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu alɨnkʉkeeta koosakoosa, alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Bo bʉpala bʉki abakabi ʉkwingɨla mBʉnyafyale bwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Abafundigwa balɨnkʉgaswiga amasyʉ gaake. Po Jesu alɨnkʉbabʉʉla kangɨ alɨnkʉtɨ, “Baanangʉ, kʉpala fiijo ʉkwingɨla mBʉnyafyale bwa Kyala! ");
INSERT INTO nyy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɨngamila ʉkwingɨla mbwasi bwa sindaano kʉpepe, ʉkʉkɨnda ʉnkabi ʉkwingɨla mBʉnyafyale bwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Po balɨnkʉswiga ʉkʉkɨndapo ʉlwa kwanda, balɨnkʉlaalʉʉsania baabo batʉpʉ, balɨnkʉtɨ, “Po jo jwani ʉjʉ abagiile ʉkʉpokigwa?” ");
INSERT INTO nyy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu alɨnkʉbakeeta fiijo, alɨnkʉtɨ, “Kʉ bandʉ sikabagɨla, looli kwa Kyala syosa sibagiile.” ");
INSERT INTO nyy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peeteli alɨnkʉmmbʉʉla alɨnkʉtɨ, “Keeta, ʉswe tʉfilekile fyosa, tʉkʉkongile ʉgwe!” ");
INSERT INTO nyy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, ʉmundʉ gwesa ʉjʉ ajɨlekile ɨnyumba, pamo abakamu, pamo ʉnna, pamo ʉgwise, pamo abaanaake, pamo ɨmigʉnda, kʉnongwa jangʉ na kʉnongwa jaa Ndʉmi ɨNunu, ");
INSERT INTO nyy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ikwisa kwambɨlɨla kʉ bwingi ʉkʉkɨndapo, nkabalɨlo aka. Ikʉkaba amalongo kalongo ʉtʉndʉ ʉto, ɨnyumba, abakamu, kangɨ abanna na baana, nɨ migʉnda. Looli ikwambɨlɨlaga syope nɨ ngʉbɨlo. Po nkabalɨlo aka kikwisa, ikwisa kʉkaba ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Looli bingi aba bikwibona ʉkʉtɨ aabikʉjaga baa kwanda akabalɨlo ako, bikʉjaga baa kʉmmalɨɨkɨsyo. Looli aba bikwibona ʉkʉtɨ aabikʉjaga baa kʉmmalɨɨkɨsyo, bikʉjaga baa kwanda.” ");
INSERT INTO nyy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Po Jesu na bafundigwa baake balɨnkwanda ʉkʉbʉʉka mu Jelusalemu. Ʉmwene Jesu jo aalongwile nkyeni mmyabo. Abafundigwa baake baaswigile, looli abenda njɨla abangɨ baatiilile fiijo. Alɨnkʉbeega kangɨ pambalɨ abafundigwa bala kalongo na babɨlɨ, alɨnkʉbabʉʉla ɨsi sikʉja pakʉmmwaga, ");
INSERT INTO nyy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","alɨnkʉtɨ, “Keeta, tukʉfyʉka ʉkʉbʉʉka mu Jelusalemu. Ʉne Nnyamundʉ ngwakʉbɨɨkigwa mmaboko agaa bapuuti abalongosi na bamanyisi baa ndagɨlo. Abeene bikwakʉʉndonga ʉkʉtɨ ngogigwe. Po bikwakʉʉmbɨɨka mmaboko agaa Balooma. ");
INSERT INTO nyy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Po bikwakʉʉnyangalɨlaga, bikwakʉʉswelaga amata, bikwakʉngomaga nɨ fingoti, nʉ kʉʉngoga. Amasikʉ matatʉ bo gakɨndile, angʉsyʉka.” ");
INSERT INTO nyy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Po Jaakobo na Johani abaana baa Sebetai, balɨnkʉmmbʉʉkɨla Jesu, balɨnkʉmmbʉʉla balɨnkʉtɨ, “Gwe Mmanyisi, tukʉkʉsʉʉma ʉkʉtʉbombela syosa ɨsi tukʉsʉʉma kʉmyako.” ");
INSERT INTO nyy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mukʉlonda mbabombele ɨfiki?” ");
INSERT INTO nyy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Balɨnkʉmmbʉʉla balɨnkʉtɨ, “Bo ʉlɨ mBʉnyafyale bwako ʉbʉsisya, ʉtwitɨkɨsye ʉswe ʉkʉtɨ, tʉtʉʉgalege pabʉjo bwako ʉbwɨmɨkigwa tʉlongosyege pamopeene na nungwe.” ");
INSERT INTO nyy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mukasimanya ɨsi mukʉsʉʉma. Bʉle, mubagiile ʉkʉkʉbɨlwa bo ʉlʉ ʉne ngwakʉkʉbɨlwa?” ");
INSERT INTO nyy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Balɨnkʉmmwamula balɨnkʉtɨ, “Tʉbagiile.” Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Nalooli aabikʉbapapo ɨngʉbɨlo bo ʉlʉ aabikʉmbapo ɨngʉbɨlo. ");
INSERT INTO nyy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Looli ɨsya kʉtʉʉgala pabʉjo ʉbwɨmɨkigwa nʉ kʉlongosya pamopeene na niine jɨkaja mbombo jangʉ ʉkʉbiitɨkɨsya, looli ʉbʉjo ʉbo bikʉpeeligwaga aba batendekekesiigwe na Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Abafundigwa abangɨ bala kalongo, bo bapɨliike amasyʉ gaa Jaakobo na Johani, balɨnkʉbakalalɨla. ");
INSERT INTO nyy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Po Jesu alɨnkʉbakoolela boosa pamopeene alɨnkʉbabʉʉla alɨnkʉtɨ, “Mumeenye ʉkʉtɨ pakiisʉ apa, aba bikʉjobigwa ʉkʉja balongosi biiganile ʉkʉbalagɨla abandʉ kʉ bʉkalɨ, bikʉbabombesya kʉ maka. ");
INSERT INTO nyy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Looli silɨngajaga bo ʉlo kʉmyɨnu. Ʉmundʉ gwesa ʉjʉ ikʉlonda ʉkʉja nkʉlʉmba gwɨnu, ikʉlondigwa ababombelege abangɨ. ");
INSERT INTO nyy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kangɨ ʉmundʉ gwesa ʉjʉ ikʉlonda ʉkʉja gwa pamwanya pamyɨnu, ajege mbombeli gwa bandʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Paapo ʉne Nnyamundʉ ngaaliisile ʉkʉtɨ baambombelege, looli naaliisile ʉkʉtɨ mbabombelege abandʉ, nʉ kʉbʉninga ʉbʉʉmi bwangʉ ʉkʉtɨ mbapoke abandʉ bingi.” ");
INSERT INTO nyy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Po Jesu na bafundigwa baake balɨnkʉbʉʉka nʉ kwakʉfika kʉ Jeeliko. Bo ikʉsookako kʉla, ɨkɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ kyankongaga. Po ʉmfwa maaso jʉmo, ɨngamu jaake Balitimai, kokʉtɨ ʉmwana gwa Timai, aatʉʉgeele kʉmbalɨ kʉ njɨla, aasʉʉmaga ɨfya bʉsʉsɨlwa. ");
INSERT INTO nyy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bo apɨliike ʉkʉtɨ Jesu ʉNnasaleti ikʉkɨnda, alɨnkʉlaata ʉkʉkoolela alɨnkʉtɨ, “Gwe Jesu, gwe Mwana gwa malafyale Ndaabɨti, ʉlɨɨmbaakɨsya!” ");
INSERT INTO nyy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Abandʉ bingi balɨnkʉnkemela ʉkʉtɨ amyeke. Looli ʉmwene alɨnkʉkɨndɨlɨla fiijo, alɨnkʉlaata ʉkʉkoolela alɨnkʉtɨ, “Gwe Mwana gwa malafyale Ndaabɨti, ʉlɨɨmbaakɨsya!” ");
INSERT INTO nyy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu alɨnkwɨma alɨnkʉtɨ, “Amunkoolele.” Balɨnkʉnkoolela ʉmfwa maaso jʉla, balɨnkʉmmbʉʉla balɨnkʉtɨ, “Gwikasyege, sumuka, ikʉkʉkoolela!” ");
INSERT INTO nyy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Alɨnkʉsopa iigolole lyake paasi, alɨnkʉnyeela alɨnkʉbʉʉka kwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Kʉlonda ngʉbombele ɨfiki?” Ʉmfwa maaso jʉla alɨnkʉtɨ, “Gwe Mmanyisi gwangʉ, ngʉlonda ʉkʉtɨ ngeetege.” ");
INSERT INTO nyy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Bʉʉkaga! Ʉbʉmbʉlwike ʉbʉbine kʉnongwa jaa lwitɨko lwako.” Nakalɨnga alɨnkʉkeeta, alɨnkʉnkonga Jesu mu njɨla. ");
INSERT INTO nyy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Po Jesu na bafundigwa baake bo basegeliile mu Jelusalemu, balɨnkʉfika mu Betanija na mu Betifage, ʉtwaja ʉtʉ tʉlɨ kɨfuki nʉ bʉjo ʉbʉ bikʉtɨ Kyamba kya Misyʉngʉtɨ. Jesu alɨnkʉbatʉma abafundigwa baake babɨlɨ, ");
INSERT INTO nyy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","alɨnkʉbabʉʉla alɨnkʉtɨ, “Namubʉʉkege nkaaja kala aka kalɨ nkyeni mmyɨnu. Bo mwingiile mula, mukwakʉjaaga ɨmwana jaa mbunda jɨkʉngiigwe, ɨjɨ ʉmundʉ akiitogamo sikʉ. Mukajaabʉle, mukajɨtwale apa. ");
INSERT INTO nyy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Lɨnga ʉmundʉ ikʉbalaalʉʉsya ikʉtɨ, ‘Fiki mukʉbomba bo ʉlo?’ mukatɨgɨ, ‘ɄNtwa afumbilwe najo, nakalɨnga ikwakʉjɨtʉma papaapa.’ ” ");
INSERT INTO nyy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Po paapo balɨnkʉbʉʉka, balɨnkwakʉjaaga ɨmwana jaa mbunda jɨɨmile pambalɨ pa njɨla, jɨkʉngiigwe pa kɨfigo kya nyumba, balɨnkʉjaabʉla. ");
INSERT INTO nyy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bo balɨ pakʉjaabʉla, abandʉ bamo aba baalyɨmile palapala, balɨnkʉbalaalʉʉsya balɨnkʉtɨ, “Fiki mukʉjaabʉla ɨmwana jaa mbunda jɨla?” ");
INSERT INTO nyy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Balɨnkʉbaamula bo muno Jesu aabalagɨliile, po balɨnkʉbiitɨkɨsya. ");
INSERT INTO nyy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Balɨnkʉntwalɨla Jesu ɨmwana jaa mbunda, balɨnkʉtenga ɨmyenda gyabo pamwanya, Jesu alɨnkwitoga. ");
INSERT INTO nyy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Abandʉ bingi balɨnkwalɨsya ɨmyenda gyabo mu nsebo, ʉkʉnangɨsya ʉlwɨmɨko kʉmyake, bamo ɨsamba ɨsya mipiki ɨsi baakonyolaga mmigʉnda. ");
INSERT INTO nyy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Abandʉ bala baalongoliile nkyeni mwa Jesu na bala baakongaga balɨnkʉkoolela balɨnkʉtɨ, “Hosyana! Asajigwege ʉjʉ ikwisɨla mu ngamu jaa Ntwa Kyala! ");
INSERT INTO nyy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bʉsajigwege ʉbʉnyafyale ʉbwa taata Ndaabɨti ʉbʉ bukwisa. Hosyana! Ɨɨmɨkigwege ʉNtwa ʉgwa kʉmwanya!” ");
INSERT INTO nyy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Po Jesu alɨnkʉfika mu Jelusalemu, alɨnkwingɨla ndʉpaso lwa tempeli, Jesu alɨnkʉkeeta kʉno na kʉno, alɨnkʉfibona fyosa. Paapo gaalɨ majolo alɨnkʉsookapo, alɨnkʉbʉʉka kʉ Betanija pamopeene na bafundigwa baake kalongo na babɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bo bʉkiile, Jesu na bafundigwa baake balɨnkʉsumuka ʉkʉfuma kʉ Betanija ʉkʉbʉʉka kangɨ kʉ Jelusalemu, po jɨlɨnkʉnndʉma ɨnjala. ");
INSERT INTO nyy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Po bo alɨ kʉbʉtali alɨnkʉgʉbona ʉnkʉjʉ ʉgʉ gʉlɨ na maani amateta, alɨnkʉbʉʉka apa gʉlipo, paapo aasʉʉbɨlaga ʉkʉtɨ ikʉsyagamo ɨseke simo. Bo afikile akaasibwenemo nasimo looli geene amaani, paapo kakaalɨ kabalɨlo kaa kʉjamo ɨseke. ");
INSERT INTO nyy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Po alɨnkʉgʉbʉʉla ʉmpiki gʉla alɨnkʉtɨ, “Ʉmundʉ najʉmo ikwisa kʉlyamo ɨseke syako.” Abafundigwa baake balɨnkʉpɨlɨkɨsya amasyʉ gaake. ");
INSERT INTO nyy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Po paapo balɨnkwakʉfika kʉ Jelusalemu, ʉmwene alɨnkwingɨla ndʉpaso lwa tempeli. Alɨnkwanda ʉkʉbakagɨla panja aba bʉʉlɨsyaga na aba bʉʉlaga. Alɨnkʉsigwɨsya ɨmeesa sya bʉʉsania ndalama, nɨ fikota fya bʉʉlɨsi baa ngʉnde. ");
INSERT INTO nyy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kangɨ aakaaniisye ʉmundʉ ʉkʉpɨmba kamo akaa kʉʉlɨsya mbʉjo bʉbʉʉbo. ");
INSERT INTO nyy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Alɨnkʉmanyisya alɨnkʉtɨ, “Bʉle, sikasimbigwa mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ɨnyumba jangʉ jikʉjobigwaga ʉkʉja nyumba jaa kwipuutɨlamo kʉ bandʉ baa mfikolo fyosa’? Looli ʉmwe mujɨbɨɨkile ʉkʉja, ‘Mbako jaa minyambuta.’ ” ");
INSERT INTO nyy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Abapuuti abalongosi na bamanyisi baa ndagɨlo sya Moose bo bapɨliike ɨsyo, balɨnkʉlonda ɨnjɨla ɨjaa kʉnngogela Jesu, bantiilaga paapo abandʉ boosa syabakolile ɨmanyisyo syake. ");
INSERT INTO nyy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Amajolo bo gafikile, Jesu na bafundigwa baake balɨnkʉsookamo nkaaja kala. ");
INSERT INTO nyy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kɨlaabo kyake nʉlʉbʉnjʉ, bo bikʉkɨnda ʉkʉbʉʉka kʉ Jelusalemu, balɨnkʉgʉbona ʉnkʉjʉ gʉla gʉkofwike ʉkwandɨla ɨmisi. ");
INSERT INTO nyy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Po Peeteli alɨnkʉkʉmbʉka amasyʉ gaa Jesu, alɨnkʉtɨ, “Gwe Mmanyisi, keeta! Ʉnkʉjʉ ʉgʉ gwagʉgunile gʉkofwike!” ");
INSERT INTO nyy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Mujege nʉ lwitɨko kwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nalooli nikʉbabʉʉla, gwesa ʉjʉ ikʉkɨbʉʉla ɨkyamba ɨkɨ ʉkʉtɨ, ‘Nyukuka, ʉkiitaage mu nyanja,’ lɨnga atikwilaamwa na panandɨ mu ndumbula jaake, looli alɨ nʉ lwitɨko ʉkʉtɨ ɨsi ikʉsijoba sikʉbombigwa, sikʉbombigwaga. ");
INSERT INTO nyy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kʉnongwa ɨjo nikʉbabʉʉla nikʉtɨ, syosa ɨsi mukʉsʉʉma ndwipuuto, mujege nʉ lwitɨko ʉkʉtɨ mwambɨliile, nuumwe mukʉpeeligwaga. ");
INSERT INTO nyy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ʉmwe, kʉkʉtɨ lɨnga mukwɨma pakwipuuta nʉ kʉmanya ʉkʉtɨ mulɨ nɨ nongwa nʉ mundʉ, munswege ɨmbiibi, ʉkʉtɨ ʉGwiseemwe ʉgwa kʉmwanya abaswege na nuumwe ʉbʉtʉlanongwa bwɨnu.  ");
INSERT INTO nyy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Looli lɨnga ʉmwe mutikʉbaswa abandʉ ʉbʉtʉlanongwa, joope ʉGwiseemwe ʉgwa kʉmwanya atikʉbaswaga na nuumwe ʉbʉtʉlanongwa bwɨnu.” ");
INSERT INTO nyy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Po Jesu na bafundigwa baake balɨnkʉfika kʉ Jelusalemu kangɨ. Bo ikwenda ndʉpaso lwa tempeli, balɨnkʉbʉʉka kʉmyake abapuuti abalongosi, abamanyisi baa ndagɨlo sya Moose na balongosi baa Bajuuta, ");
INSERT INTO nyy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Ʉkabile kʉʉgʉ amaka agaa kʉbomba ɨsi? Jo jwani ʉjʉ akʉpeele amaka agaa kʉtɨ ʉbombege ɨsi?” ");
INSERT INTO nyy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Na niine ngʉbalaalʉʉsya iisyʉ lɨmo. Lɨnga muunyaamwile, niine ngʉbabʉʉla ʉkʉtɨ kʉ maka gaani ngʉbomba ɨsi. ");
INSERT INTO nyy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bʉle, amaka agaa Johani agaa kʉboosya abandʉ gaafumile kwa Kyala, pamo kʉ bandʉ? Namuunyaamule niine.” ");
INSERT INTO nyy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Po balɨnkʉjobesania balɨnkʉtɨ, “Lɨnga tukʉtɨ amaka gaake gaafumile kwa Kyala, ʉmwene ikʉtɨgɨ, ‘Keeta mukaalɨmmwitiike?’ ");
INSERT INTO nyy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Looli lɨnga tukʉtɨ amaka gaake gaafumile kʉ bandʉ...” (Baatiilile ɨkɨlʉndɨlo kya bandʉ, paapo abandʉ boosa baaliitiike ʉkʉtɨ Johani aalɨ nkunguluka gwa nalooli.) ");
INSERT INTO nyy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Po balɨnkʉmmwamula Jesu balɨnkʉtɨ, “Tʉkamanya.” Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Po leelo niine, ndikʉbabʉʉla ʉmwe ʉkʉtɨ jwani ambeele amaka agaa kʉbomba ɨsi.” ");
INSERT INTO nyy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Po paapo Jesu alɨnkwanda ʉkʉjoba na balongosi bala mfifwanikɨsyo alɨnkʉtɨ, “Aaliko ʉmundʉ jʉmo ʉjʉ aalɨ nʉ ngʉnda. Aabyele amaafiilʉ, aasyʉngʉʉsiisye ʉlʉpaso, aakʉmbile ʉbwina ʉbwa kʉkamɨlamo ɨseke sya maafiilʉ, kangɨ aajengile ɨkɨsonge ɨkya kwɨmapo abalɨndɨlɨli. Alɨnkʉbabɨɨkamo abalɨmi abaa kʉkeetelela ɨmipiki gya maafiilʉ gɨla, ʉkʉtɨ ɨseke bo sibɨfwifwe, biise bajabane. Po alɨnkwenda ɨnjɨla jaa pabʉtali. ");
INSERT INTO nyy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Akabalɨlo kaa kʉtʉngʉla ɨseke bo kafikile, alɨnkʉntʉma jʉmo mbabombeli baake kʉ balɨmi bala ʉkʉtɨ bampeko ɨkɨjabo kyake. ");
INSERT INTO nyy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Looli abalɨmi bala balɨnkʉnkola, balɨnkʉnkoma nʉ kʉnkaga kɨsita kʉmpapo nafimo. ");
INSERT INTO nyy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Po ʉmwene ngʉnda jʉla alɨnkʉntʉma kangɨ ʉmbombeli ʉjʉngɨ, joope balɨnkʉmfulasya ʉntʉ nʉ kʉmmbombela ɨngosya soni. ");
INSERT INTO nyy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Po alɨnkʉntʉma kangɨ ʉjʉngɨ, jo balɨnkʉnngoga. Alɨnkʉbatʉma na bangɨ baa bingi, po bamo balɨnkʉbakoma, abangɨ balɨnkʉbagoga. ");
INSERT INTO nyy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Aasyele ʉmundʉ jʉmojwene itolo ʉgwa kʉntʉma, jo mwanaake jʉmojwene ntɨga ʉndʉmyana, kangɨ ʉnkʉndwe. Po kʉmmalɨɨkɨsyo joope alɨnkʉntʉma kʉ ngʉnda, alɨnkʉtɨ, ‘Ʉmwanangʉ jo bikwakʉmmwɨmɨkaga.’ ");
INSERT INTO nyy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Looli abalɨmi balɨnkʉjobesania balɨnkʉtɨ, ‘Ʉjʉ jo mwene kɨlɨngo. Isaga tʉnngoge, ʉkʉtɨ ɨkɨlɨngo kɨjege kyɨtʉ.’ ");
INSERT INTO nyy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Balɨnkʉnkola, balɨnkʉnngoga, balɨnkʉnsoosyamo mu ngʉnda.” ");
INSERT INTO nyy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Po Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Po ʉmwene ngʉnda jʉla ikwakʉbomba ɨfiki? Ikwisa kʉbagoga abalɨmi bala, nʉ ngʉnda gʉla ikʉbapapo abangɨ. ");
INSERT INTO nyy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bʉle, mukabalamo Kalata ʉMwikemo? Apa sisimbiigwe ʉkʉtɨ, ‘Ɨliibwe ɨlɨ abajenga nyumba baalɨkaanile, lyo lɨjile ibwe ikʉlʉmba pa lwalo, pa nguto. ");
INSERT INTO nyy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ɄNtwa Kyala jo ʉjʉ asipelile ɨsyo, sya kɨswigo fiijo kʉmyɨtʉ ʉkʉsibona ɨsyo.’ ” ");
INSERT INTO nyy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Abalongosi baa Bajuuta balɨnkʉlonda ʉkʉnkola, paapo baasyageenie ʉkʉtɨ, ɨkɨfwanikɨsyo ɨkɨ aabajobaga abeene. Looli balɨnkʉkɨtiila ɨkɨlʉndɨlo kya bandʉ, po balɨnkʉnndeka, balɨnkʉsookapo. ");
INSERT INTO nyy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Po paapo abalongosi baa Bajuuta balɨnkʉbatʉma kwa Jesu aBafalisai bamo, na babombeli abaa Heloti, ʉkʉtɨ bankolele mmasyʉ gaake. ");
INSERT INTO nyy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bo bafikile kwa Jesu balɨnkʉtɨ, “Gwe Mmanyisi, tʉmeenye ʉkʉtɨ ʉgwe ʉlɨ ngolofu, kangɨ ʉtikʉpaasya ɨsi bikwinogona abandʉ. Kʉmanyisya ɨsya Kyala kʉ bwanalooli, kɨsita kʉpaasya ʉbʉsisya bwa bandʉ. Bʉle, ɨndagɨlo sya Moose sikʉtwitɨkɨsya ʉkʉsonga ɨsongo kʉ malafyale gwa Balooma, pamo mma? ");
INSERT INTO nyy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tʉsongege pamo tʉlɨngasongaga?” Leelo bo abʉbwene ʉbʉsyobi bwabo alɨnkʉtɨ, “Fiki mukʉʉngela? Namundwalɨle ʉlʉtalama lʉmo ʉlwa ndenali, ngeete.” ");
INSERT INTO nyy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Po paapo balɨnkʉntwalɨla. Ʉmwene Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Ɨkɨfwani ɨkɨ kyani, nɨ ngamu ɨjɨ jaani?” Balɨnkʉmmwamula balɨnkʉtɨ, “Fya malafyale gwa Balooma.” ");
INSERT INTO nyy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Po ɨfya malafyale gwa Balooma mumpege ʉmalafyale gwa Balooma, nɨ fya Kyala mumpege Kyala.” Po abeene balɨnkʉswiga muno aalyamuliile na mahala. ");
INSERT INTO nyy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Po aBasatukai balɨnkʉbʉʉka kwa Jesu. Abeene baamanyisyaga ʉkʉtɨ abandʉ bakabagɨla ʉkʉsyʉka ʉkʉfuma mbafwe. Po balɨnkʉnndaalʉʉsya balɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Gwe Mmanyisi, Moose aatʉsimbiile mu ndagɨlo, ʉkʉtɨ, ‘Lɨnga ʉmundʉ ikʉfwa kɨsita kʉpaapa ʉmwana najʉmo, ʉgwamyabo ammwingɨlengepo ɨkɨlɨngo ʉnkiikʉlʉ ʉmfwɨle jʉla, ʉkʉtɨ ampaapɨle abaana ʉjʉ afwile.’ ");
INSERT INTO nyy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Po baaliko abanyamundʉ bahaano na babɨlɨ. Ʉgwa kwanda alɨnkwega ʉnkiikʉlʉ, alɨnkʉfwa kɨsita kʉpaapa ʉmwana najʉmo. ");
INSERT INTO nyy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ʉgwa bʉbɨlɨ, alɨnkwenda nʉ kʉmmwingɨlapo ʉnkiikʉlʉ jʉla, alɨnkʉfwa kɨsita kʉpaapa nagwe, nʉ gwa bʉtatʉ bʉbʉʉbo, joope alɨnkʉfwa kɨsita kʉpaapa nagwe. ");
INSERT INTO nyy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Boosa bahaano na babɨlɨ balɨnkʉfwa kɨsita kʉkaba ʉmwana najʉmo. Kʉmmalɨɨkɨsyo ʉnkiikʉlʉ jʉla joope alɨnkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Abandʉ boosa bo basyʉkile, ʉnkiikʉlʉ jʉla ikwisa kʉjaga nkasi gwani? Paapo boosa bahaano na babɨlɨ baalɨmmwegilemo.” ");
INSERT INTO nyy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ʉmwe mukʉsoba paapo mukasyagania ɨsi sisimbiigwe mwa Kalata ʉMwikemo, kangɨ mukagamanya amaka gaa Kyala muno gajɨɨliile. ");
INSERT INTO nyy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Paapo abafwe bo basyʉkile, bikʉjaga bo ʉlwa bandʉmi aba balɨ kʉmwanya, aba batikwega nʉ kwegigwa. ");
INSERT INTO nyy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Looli ɨsya kʉsyʉsigwa abafwe, bʉle mukabalamo kalata ʉgwa Moose, pala Kyala aajobaga nkɨsyanjʉ kɨla kyakaga ʉmooto? Kyala aalɨmmbʉʉlile Moose aatile, ‘Ʉne ne Kyala gwa Abulahamu, Kyala gwa Isaka na Kyala gwa Jaakobo.’ ");
INSERT INTO nyy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kyala akaja jo Kyala gwa bafwe, looli gwa bʉʉmi. Ʉmwe mukʉsoba fiijo.” ");
INSERT INTO nyy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Po ʉmmanyisi gwa ndagɨlo sya Moose jʉmo, aabʉʉkile pala baalipo. Aabapɨliike bo bikʉjobesania baabo, aasyageenie ʉkʉtɨ Jesu aabaamwile ɨsya nalooli. Po joope alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Lo lʉlagɨlo lʉlɨkʉ ʉlʉkʉlʉmba kʉlɨ syosa?” ");
INSERT INTO nyy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu alɨnkʉtɨ, “Ʉlʉkʉlʉmba lo ʉlʉ lukʉtɨ, ‘Pɨlɨka mwe Banyaisilaɨli! ɄNtwa Kyala gwɨtʉ jo Ntwa jʉmojwene ntɨga. ");
INSERT INTO nyy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ʉnnganege ʉNtwa Kyala gwako nɨ ndumbula jaako joosa, nɨ mbepo jaako joosa, na mahala gaako goosa, na maka gaako goosa!’ ");
INSERT INTO nyy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ʉlʉlagɨlo ʉlwa bʉbɨlɨ lo ʉlʉ lukʉtɨ, ‘Ʉbaganege abanino bo ʉlʉ gwijiiganile ʉgwe.’ Lʉkajako ʉlʉlagɨlo ʉlʉkʉlʉmba ʉkʉsikɨnda ɨsi.” ");
INSERT INTO nyy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Po paapo ʉmmanyisi jʉla alɨnkʉtɨ, “Moomuumo Mmanyisi! Ʉjobile ɨsya nalooli ʉkʉtɨ Kyala alɨ jʉmojwene ntɨga, kangɨ akajako ʉjʉngɨ, jo jʉʉjo mwene. ");
INSERT INTO nyy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ʉkʉnngana Kyala nɨ ndumbula jaako joosa, na mahala gaako goosa, na maka gaako goosa, nʉ kʉbagana abanino bo ʉlʉ gwijiiganile ʉgwe, kʉkɨndile ʉkʉnsookesya Kyala ɨfyabʉpe na makemo.” ");
INSERT INTO nyy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Joope Jesu bo ammbwene ʉkʉtɨ ajobile ɨsya mahala alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉgwe ʉkaja kʉbʉtali nʉ Bʉnyafyale bwa Kyala.” Akaagelilepo ʉmundʉ najʉmo ʉkʉnndaalʉʉsya kangɨ Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesu bo ikʉmanyisya ndʉpaso lwa tempeli, alɨnkʉbalaalʉʉsya abandʉ aba baalipo alɨnkʉtɨ, “Fiki abamanyisi baa ndagɨlo sya Moose bikʉjoba ʉkʉtɨ Meesija Mwana gwa malafyale Ndaabɨti? ");
INSERT INTO nyy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ndaabɨti bo ikʉlongosigwa na Mbepo Mwikemo aatile, ‘ɄNtwa Kyala aalɨmmbʉʉlile ʉNtwa gwangʉ, “Itʉʉgasye kʉkɨbafu kyangʉ ɨkiilɨɨlo, ʉbʉjo ʉbwa lwɨmɨko fiijo, ʉkʉfika apa nikʉbabɨɨkaga abalʉgʉ baako paasi pa malʉndɨ gaako.” ’ ");
INSERT INTO nyy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Ndaabɨti jʉʉjo ikʉnnjoba Meesija ʉkʉtɨ Ntwa. Po Meesija ikʉjaga mwanaake bʉleebʉle?” Ɨkɨlʉndɨlo ɨkɨnywamu kya bandʉ kɨlɨnkʉpɨlɨkɨsya nʉ lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesu bo ikʉbamanyisya alɨnkʉtɨ, “Mujege maaso na bamanyisi baa ndagɨlo sya Moose! Biiganile ʉkwenda bo bafwele ɨmyenda ɨmitali, ʉkʉtɨ abandʉ babaponiege kʉ lwɨmɨko mu sokoni. ");
INSERT INTO nyy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bikwisalɨla ʉkʉtʉʉgasya pa fikota ɨfya bɨɨmɨkigwa mu ngomaano, pabʉjo ʉbwa bɨɨmɨkigwa pa lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bikʉkabɨla mbʉsyobi ɨfyʉma kʉ bakiikʉlʉ abafwɨle, kangɨ bikwipuuta ɨnyiipuuto ɨndali, ɨsya kʉlabaasya. Pi isikʉ lya bʉlongi, bikwisa kwambɨlɨlaga ʉlʉfundo ʉlʉnywamu kwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesu bo alɨ ndʉpaso lwa tempeli, alɨnkʉtʉʉgala ʉkʉningɨsania nɨ kya kʉsopamo amakemo. Alɨnkʉbakeeta abandʉ bo balɨ pakʉsopa ɨndalama. Abakabi baa bingi baasopangamo ɨndalama nyingi. ");
INSERT INTO nyy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Po alɨnkwisa joope ʉnkiikʉlʉ jʉmo ʉmfwɨle ʉndondo, alɨnkʉsopa ʉtʉsenti tʉbɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Po paapo Jesu alɨnkʉbabɨlɨkɨla abafundigwa baake alɨnkʉtɨ, “Nalooli nikʉbabʉʉla nikʉtɨ, ʉnkiikʉlʉ ʉjʉ ʉmfwɨle ʉndondo, asoosiisye ɨndalama nyingi ʉkʉbakɨnda boosa aba basoosiisye nkya kʉsopamo amakemo. ");
INSERT INTO nyy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Paapo abangɨ boosa basopile ɨfi beegile mfyʉma fyabo ɨfi fijeelile, looli ʉmfwɨle ʉjʉ mbʉlondo bwake asoosiisye fyosa ɨfi aalɨ nafyo, ɨfi aafisʉʉbɨlaga mbʉʉmi bwake.” ");
INSERT INTO nyy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Po Jesu alɨnkʉsooka ndʉpaso lwa tempeli pamopeene na bafundigwa baake. Po ʉmfundigwa gwake jʉmo alɨnkʉtɨ, “Gwe Mmanyisi, keeta amabwe aga nɨ nyumba ɨsi muno fijɨɨliile ʉkʉbagɨla ʉbʉnunu!” ");
INSERT INTO nyy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Bʉle, kʉsikeeta ɨnyumba ɨnywamu ɨnunu ɨsi? Lɨtikwisa kʉjako iibwe ɨlɨ lɨlɨ pamwanya pi ibwe iinine. Goosa gikwisa koomoligwa!” ");
INSERT INTO nyy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Po baafikile pa Kyamba kya Misyʉngʉtɨ, Jesu aatʉʉgeele ʉkʉkeeta kʉ tempeli. Pabʉjo ʉbʉsita bandʉ, baa Peeteli, Jaakobo, Johani na Andeleja balɨnkʉnndaalʉʉsya balɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tʉbʉʉle, ɨnongwa ɨsi kʉsijoba sikʉbonekaga ndɨli? Kɨmanyilo nki kikwisa kʉtʉnangɨsya ʉkʉtɨ ɨsi silɨ kɨfuki ʉkʉboneka?” ");
INSERT INTO nyy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mujege maaso, ʉmundʉ najʉmo alɨngabasyobaga. ");
INSERT INTO nyy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Abandʉ bingi bikwisa kʉbombelaga ɨngamu jangʉ, bikwisa kʉtɨgɨ, ‘Ʉne ne Meesija!’ Bikwisa kʉbasofya abandʉ abingi. ");
INSERT INTO nyy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bo mukʉpɨlɨka ɨsya bwite mbʉjo mbʉjo, mulɨngiisa kʉtiilaga. Ɨsyo mpaka siboneke, looli ʉbʉmalɨɨkɨsyo bo bʉkaalɨ. ");
INSERT INTO nyy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Paapo ɨkiisʉ kɨmo kikwisa kʉlwaga nɨ kiisʉ ɨkɨngɨ, nʉ bʉnyafyale bʉmo bukwisa kʉlwaga nʉ bʉnyafyale ʉbʉngɨ. Tukwisa kʉjangako ʉtʉsenyenda mfiisʉ fingi, nɨ njala jikwisa kʉgwaga. Ɨsyo sikwisa kʉjaga bo ʉlwa bwandɨlo bwa lʉbabo lwa nkiikʉlʉ ʉjʉ alɨ kɨfuki ʉkʉpaapa. ");
INSERT INTO nyy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ʉmwe mujege maaso, paapo abandʉ bikwisa kʉbatwalaga pabʉlongi, nʉ kʉbakoma nɨ fingoti mu sinagogi. Bikwisa kʉbatwalaga ʉmwe nkyeni mbalongosi baa kiisʉ na mbanyafyale, paapo mulɨ bafundigwa bangʉ. Kʉ njɨla ɨjo mukwisa kʉʉfumusyaga ʉne kʉmyabo. ");
INSERT INTO nyy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ƗNdʉmi ɨNunu ɨjaa Kyala jɨlʉmbɨlɨligwe mfikolo fyosa ɨfya bandʉ, bo bʉkaalɨ ʉkʉfika ʉbʉmalɨɨkɨsyo ʉbwa kiisʉ. ");
INSERT INTO nyy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bo bikʉbatwala pabʉlongi, mulɨngiipaakɨsyaga ɨsya kʉjoba. Akabalɨlo ako mujobege syosa ɨsi Kyala ikʉbapa, paapo ɨsi mukʉjobaga sikaja syɨnu, looli sikʉfuma kwa Mbepo Mwikemo. ");
INSERT INTO nyy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kangɨ ʉmundʉ ikwisa kʉmmoohelaga ʉgwamyabo ʉkʉtɨ agogigwe, joope ʉgwise ikwisa kʉmmoohelaga ʉmwanaake ʉkʉtɨ agogigwe. Boope na baana bikwisa kʉbasambʉkɨlaga abapaapi baabo nʉ kʉbagoga. ");
INSERT INTO nyy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Abandʉ boosa bikwisa kʉbabengaga ʉmwe, paapo mulɨ bafundigwa bangʉ. Looli ʉjʉ ikʉʉmɨɨlɨla mpaka kʉmmalɨɨkɨsyo, jo ikwisa kʉpokigwa. ");
INSERT INTO nyy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Po mukwisa kʉkabona, ‘Akandʉ aka kikʉnyasya nʉ koonanga,’ kɨɨmile pabʉjo ʉbʉ katikʉlondigwa ʉkʉjapo. Ʉjʉ ikʉpɨlɨka amasyʉ aga, asyaganiege ɨsi ngʉjoba. Ɨsyo bo sikʉboneka, po abandʉ aba balɨ mu Jutai babopelege mfyamba. ");
INSERT INTO nyy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Joope ʉmundʉ ʉjʉ alɨ pamwanya pa nyumba, alɨngasulukaga kʉkwega ʉtʉndʉ twake ʉtʉ tʉlɨ nnyumba jaake, looli abopege. ");
INSERT INTO nyy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kangɨ ʉmundʉ ʉjʉ alɨ mu ngʉnda alɨngagomokelangako kʉkaaja kʉkwega ʉmwenda gwake. ");
INSERT INTO nyy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ahɨɨli abaa fifuba na aba bikongesya abaana nkabalɨlo ako! ");
INSERT INTO nyy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mwipuutege ʉkʉtɨ ɨsyo silɨngiisa kʉboneka nkabalɨlo akaa mu fula. ");
INSERT INTO nyy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nkabalɨlo ako bukwisa kʉjako ʉbʉtolwe ʉbʉ bʉkabonekamo sikʉ, ʉkʉfuma kʉbwandɨlo bwa kʉpeligwa ɨkiisʉ mpaka lɨɨlɨno. Kangɨ ʉbʉtolwe ʉbo bʉtikwisa kʉjako sikʉ. ");
INSERT INTO nyy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lɨnga ʉNtwa akaakapimbwile akabalɨlo ako, akaajangapo najʉmo ʉgwa kwisa kʉpona. Looli kʉnongwa jaa basʉngʉligwa baake, Kyala akapimbwile akabalɨlo ako. ");
INSERT INTO nyy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Po nkabalɨlo ako, lɨnga ʉmundʉ ikʉbabʉʉla ikʉtɨ, ‘Keeta, Meesija alipo apa!’ pamo, ‘Aliko kʉla!’ mulɨngiisa kwitɨka. ");
INSERT INTO nyy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Namanga bikwisa kwisa abandʉ aba bikʉtʉngʉlʉpaga ʉkʉtɨ bo baa Meesija, nʉ kʉtɨ bakunguluka baa Kyala. Bikwisa kʉbomba ɨfimanyilo ɨfinywamu nɨ fiswigo, ʉkʉtɨ babasofye abandʉ, nʉ kʉtɨ lɨnga sibagiile babasofye boope na basʉngʉligwa baa Kyala. ");
INSERT INTO nyy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mujege maaso paapo mbabʉʉlile kɨlɨngaani syosa ɨsyo bo sikaalɨ ʉkʉboneka!” ");
INSERT INTO nyy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Looli nkabalɨlo ako, bo ɨngʉbɨlo ɨsyo sikɨndile, ‘Ɨliisʉba likwisa kʉja nɨ ngiisi, nʉ mwesi gʉtikwisa kʉsoosya ʉndangalɨla gwake, ");
INSERT INTO nyy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nɨ ndondwa sikwisa kʉsatʉkaga paasi ʉkʉfuma kʉmwanya. Nʉ tʉndʉ toosa ʉtʉnywamu ʉtʉ tʉlɨ kʉmwanya, tukwisa kʉjʉngaanika.’ ");
INSERT INTO nyy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Po abandʉ bikwisa kʉʉmbona ne Nnyamundʉ, bo ngwisa mmabɨngo na maka amingi nʉ bʉsisya bwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ʉne ngwisa kʉbatʉma abandʉmi bangʉ ʉkʉtɨ bababʉngaanie abasʉngʉligwa bangʉ, ʉkʉfuma mfibafu fyosa ɨfya pakiisʉ. ");
INSERT INTO nyy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mumanyilege ɨnongwa ɨjaa kʉfuma nkɨfwanikɨsyo ɨkya nkʉjʉ. Lɨnga ɨsamba syake ndeta, kangɨ amaani gatʉlwile, mukʉmanya ʉkʉtɨ ʉmpɨngo gʉsegeliile. ");
INSERT INTO nyy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bʉbʉʉbo na nuumwe bo mukʉsibona ɨsyo syosa, aamumanyege ʉkʉtɨ ʉbʉmalɨɨkɨsyo ʉbwa kabalɨlo akabiibi ako bʉsegeliile. ");
INSERT INTO nyy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nalooli nikʉbabʉʉla, abandʉ abaa nkabalɨlo aka, batikwisa kʉmalɨka ʉkʉfwa, bo syosa ɨsyo sikabombigwa. ");
INSERT INTO nyy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ʉmpaalanga nɨ kiisʉ fikwisa koomoka, looli amasyʉ gangʉ gatikoomokamo sikʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Akajako najʉmo ʉjʉ alɨmeenye iisikʉ na kabalɨlo akaa kwisa kwangʉ, boope na bandʉmi abaa kʉmwanya, joope ʉMwana, looli Taata mwene jo ameenye. ");
INSERT INTO nyy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mujege maaso, mukeetege, paapo mukakamanya akabalɨlo akaa kwisa Nnyamundʉ kikʉjaga ndɨli. ");
INSERT INTO nyy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ʉkwisɨla kwake kʉlɨɨtɨ bo ʉmundʉ ʉjʉ ikwenda ɨnjɨla, ikʉjɨleka ɨnyumba jaake, ikʉbalagɨla ababombeli baake kʉkʉtɨ mundʉ nɨ mbombo jaake, ikʉnndagɨla ʉndɨndɨlɨli ʉkʉtɨ ajege maaso. ");
INSERT INTO nyy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Po mujege maaso, ʉkʉtɨ ʉmwene nyumba alɨngiisa kʉbaaga bo mwijɨbile pamo bo mugonile ʉtʉlo. Paapo mukakamanya akabalɨlo aka ikwisa ʉkʉtɨ majolo, pamo pakɨlo pakatɨ, pamo bo jikʉkoolela ɨngongobe, pamo nʉlʉbʉnjʉ. ");
INSERT INTO nyy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Amasyʉ aga nikʉbabʉʉla ʉmwe, go nikʉbabʉʉla na bangɨ boosa. Mujege maaso!” ");
INSERT INTO nyy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Po paapo, gaasyele amasikʉ mabɨlɨ ʉkwɨmba ɨkyaka kya Pasa, nɨ kyaka ɨkya fisyesye ɨfisita nkese. Abapuuti abalongosi na bamanyisi baa ndagɨlo sya Moose baajobesaniaga ɨnjɨla jaa kʉnkolelamo Jesu kʉ bʉkomu, ʉkʉtɨ banngoge. ");
INSERT INTO nyy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Looli balɨnkʉtɨ, “Tʉlɨngankolaga pa kyaka kya Pasa ʉkʉtɨ abandʉ balɨngiisa kʉlʉndʉkana.” ");
INSERT INTO nyy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Akabalɨlo kalakala Jesu na bafundigwa baake baalɨ kʉ Betanija, nnyumba jaa Simoni, ʉjʉ bantɨgɨ ʉNkoma. Bo balɨ pakʉlyamo ɨfindʉ, alɨnkwisa ʉnkiikʉlʉ jʉmo nɨ supa jaa mafuta agaa lʉʉma ʉlʉnunu, agaa ntengo ʉnnywamu fiijo. Pakwigʉla, alɨnkʉkonyola amakosi gaa supa, alɨnkʉmmoonelela pantʉ Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Abandʉ bamo aba baalipo pala, baakaleele, balɨnkʉjobesania balɨnkʉtɨ, “Mwe! Fiki ikʉbinika amafuta amanunu ago? ");
INSERT INTO nyy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kwalɨ kʉnunu ʉkʉʉlɨsya amafuta aga kʉ ndenali ɨmia itatʉ, ɨsi ngalɨ bikʉpeeligwa abalondo!” Balɨnkʉnkemela fiijo ʉnkiikʉlʉ jʉla. ");
INSERT INTO nyy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Looli Jesu alɨnkʉtɨ, “Munndeke! Fiki mukʉntaamya ʉnkiikʉlʉ ʉjʉ! Aambombiile ɨmbombo ɨnunu ʉne. ");
INSERT INTO nyy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Abalondo mulɨ nabo amasikʉ goosa, mubagiile ʉkʉbatʉʉla akabalɨlo koosa aka mwiganile. Looli ʉne ndikʉja pakʉja pamopeene na nuumwe bwila. ");
INSERT INTO nyy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ʉmwene abombile ɨsi abagiile, aanyooneliile amafuta aga ʉkʉtɨ agʉtendekesye ʉmbɨlɨ gwangʉ ʉkʉʉsyɨla kɨlɨngaani. ");
INSERT INTO nyy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nalooli nikʉbabʉʉla, poosa apa ɨNdʉmi ɨNunu ɨjaa Kyala jikʉlʉmbɨlɨligwaga pakiisʉ, ɨsi abombile ʉnkiikʉlʉ ʉjʉ sikʉjobigwaga ʉkʉnkʉmbʉkɨlamo.” ");
INSERT INTO nyy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Po Juuta Isikalyoti, jʉmo mbafundigwa baake kalongo na babɨlɨ, alɨnkʉbʉʉka kʉ bapuuti abalongosi kʉkʉnndɨɨla Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Abapuuti abalongosi bo bapɨliike amasyʉ gaa Juuta Isikalyoti, baahobwike fiijo. Balɨnkwitɨkana nagwe ʉkʉnhomba ɨndalama. Po paapo Juuta alɨnkwanda ʉkʉlonda ɨnjɨla ɨjaa kʉnndɨɨla. ");
INSERT INTO nyy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pi isikʉ ɨlya kwanda ɨlya kyaka ɨkya fisyesye ɨfisita nkese, akabalɨlo aka akangʼoosi kaa Pasa kikʉbooligwa, abafundigwa baake balɨnkʉnndaalʉʉsya Jesu balɨnkʉtɨ, “Tʉkakʉtendekekesye kʉʉgʉ ɨfindʉ fya Pasa?” ");
INSERT INTO nyy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesu alɨnkʉbatʉma abafundigwa baake babɨlɨ alɨnkʉbabʉʉla alɨnkʉtɨ, “Namwingɨle nkaaja akaa Jelusalemu, mukwakwaganila nʉ nnyambala jʉmo, apɨmbile ɨndeko jaa mɨɨsi. Mukankongege. ");
INSERT INTO nyy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mukingɨle nnyumba ɨjɨ ikwingɨla. Mukammbʉʉle ʉmwene nyumba ʉkʉtɨ ʉMmanyisi ikʉkʉlaalʉʉsya ikʉtɨ, ‘Ɨkyumba kya baheesya kɨlɨ kʉʉgʉ? Ngʉlonda ʉkʉlɨɨlamo ɨkyaka kya Pasa pamopeene na bafundigwa bangʉ.’ ");
INSERT INTO nyy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ʉmwene nyumba ikwakʉbanangɨsya ɨkyumba ɨkɨnywamu ɨkya kʉ golofwa ɨkɨ kɨtendekesiigwe, mo mukatendekesyege ɨfindʉ fya Pasa kʉnongwa jɨɨtʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Abafundigwa baake balɨnkʉbʉʉka kʉ Jelusalemu, balɨnkwakʉsyaga syosa bo muumo Jesu aajobiile. Po balɨnkʉtendekesya ɨfindʉ fya Pasa. ");
INSERT INTO nyy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jesu na bafundigwa baake kalongo na babɨlɨ balɨnkʉfika pala namajolo. ");
INSERT INTO nyy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bo batʉʉgeele balɨ pakʉlyamo, Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, jʉmo nkɨbugutɨla kyɨnu, ʉjʉ ikʉlya na niine, jo ikʉʉndɨɨla.” ");
INSERT INTO nyy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Balɨnkʉsulumania, po jʉmoojʉmo alɨnkʉnndaalʉʉsya Jesu, alɨnkʉtɨ, “Bʉle, jo ʉne?” ");
INSERT INTO nyy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Jʉmo ndɨ mwe bafundigwa bangʉ kalongo na babɨlɨ, ʉjʉ ikʉtobela ɨkɨsyesye mu mposi pamopeene na niine jo jʉjʉʉjo. ");
INSERT INTO nyy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ʉne Nnyamundʉ angʉfwa bo muno sisimbiigwe mwa Kalata ʉMwikemo. Looli ahɨɨli ʉmundʉ ʉjʉ ikʉʉndɨɨla ne Nnyamundʉ. Kwalɨ kʉnunu lɨnga ʉmundʉ ʉjo akaapaapiigwe.” ");
INSERT INTO nyy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bo balɨ pakʉlya, Jesu alɨnkwega ɨkɨsyesye, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉkɨmenya, alɨnkʉbapapo abafundigwa baake, alɨnkʉbabʉʉla alɨnkʉtɨ, “Namwege, ʉgʉ go mbɨlɨ gwangʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Alɨnkwega ɨkɨkombe ɨkya finga, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉbapapo, balɨnkʉnwa boosa nkɨkombe kɨlakɨla. ");
INSERT INTO nyy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Ɨlɨ lyo ilopa lyangʉ ɨlya kʉnangɨsya ʉlwitɨkano lwa Kyala. Likooneka ʉkʉbapoka bingi. ");
INSERT INTO nyy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nalooli nikʉbabʉʉla nikʉtɨ, ndikwisa kʉnwamo kangɨ ɨfinga mpaka pi isikʉ lɨla, ɨlɨ angwisa kʉnwa ɨfinga ɨmbya mBʉnyafyale bwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bo bɨmbile ʉlwɨmbo, balɨnkʉsookapo ʉkʉbʉʉka kʉ Kyamba kya Misyʉngʉtɨ. ");
INSERT INTO nyy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Po paapo Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Ʉmwe mwesa mukʉʉndeka, paapo sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ngwisa kʉnkoma ʉntiimi, po ɨngʼoosi sikwisa kʉbalanila.’ ");
INSERT INTO nyy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Looli bo nsyʉkile, ngʉbatalɨlapo ʉkʉbʉʉka kʉ Galilai.” ");
INSERT INTO nyy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Po Peeteli alɨnkʉnkaanika Jesu alɨnkʉtɨ, “Nalɨnga boosa bikʉkʉleka, ʉne ndikʉkʉleka sikʉ!” ");
INSERT INTO nyy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Nalooli nikʉkʉbʉʉla ʉgwe, ɨkɨlo ɨkɨ, bo ɨngongobe jɨkaalɨ ʉkʉkoolela ʉlwa kabɨlɨ, kʉngaana katatʉ.” ");
INSERT INTO nyy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ʉmwene alɨnkʉkɨndɨlɨla ʉkʉjoba alɨnkʉtɨ, “Nalɨnga ko kʉfwa pamopeene na nungwe, ndikʉkʉkaana sikʉ!” Abafundigwa baake boosa balɨnkʉjoba bo lɨlɨɨlyo. ");
INSERT INTO nyy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Po Jesu na bafundigwa baake balɨnkʉbʉʉka pabʉjo ʉbwa mipiki ɨgya misyʉngʉtɨ, ʉbʉ bikʉtɨ Getisemani. Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Namutʉʉgale papaapa bo ngwipuuta.” ");
INSERT INTO nyy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Alɨnkʉbeega baa Peeteli, Jaakobo na Johani alɨnkʉja pamopeene nabo, alɨnkʉsulumania nʉ kʉtaamigwa fiijo mu ndumbula jaake. ");
INSERT INTO nyy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Po alɨnkʉbabʉʉla alɨnkʉtɨ, “Ɨndumbula jangʉ jɨsulumeenie ʉlwa kʉfwa. Namutʉʉgale papaapa, muje maaso.” ");
INSERT INTO nyy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Alɨnkʉsemapo nkyeni panandɨ, alɨnkʉgwa ʉlʉpi, alɨnkwipuuta ʉkʉtɨ lɨnga sibagiile akabalɨlo kaake akaa ngʉbɨlo kakɨnde. ");
INSERT INTO nyy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Alɨnkʉjoba alɨnkʉtɨ, “Abba, gwe Taata! Syosa sibagiile kʉmyako. Ngʉkʉsʉʉma ʉʉsookesyepo ɨngʉbɨlo ɨsi. Leelo bʉlɨngabombigwa ʉbwigane bwangʉ, looli ʉbwako.” ");
INSERT INTO nyy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Po Jesu alɨnkʉbʉʉka kʉ bafundigwa baake, alɨnkʉbaaga bagonile ʉtʉlo. Alɨnkʉmmbʉʉla Peeteli alɨnkʉtɨ, “Simoni ʉgonile ʉtʉlo? Bʉle, ʉtoliigwe ʉkʉja maaso na kʉkabalɨlo akanandɨ itolo? ");
INSERT INTO nyy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mujege maaso mwipuutege, ʉkʉtɨ mulɨngiisa kʉtoligwa nɨ ngelo. Mwiganile ʉkʉbomba kanunu, looli mukaja na maka.” ");
INSERT INTO nyy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Alɨnkʉbʉʉka, kangɨ alɨnkwipuuta, alɨnkʉjoba amasyʉ galagala. ");
INSERT INTO nyy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Po alɨnkwisa, kangɨ alɨnkʉbaaga bagonile ʉtʉlo, paapo amaaso gaabo gaalɨ nʉ tʉlo twingi, bakaasimeenye nɨ sya kʉmmwamula. ");
INSERT INTO nyy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Alɨnkwisa ʉlwa katatʉ, alɨnkʉbabʉʉla alɨnkʉtɨ, “Mukaalɨ mukʉgona ʉtʉlo nʉ kʉtʉʉsya? Sifwene! Akabalɨlo kafikile. Keeta, ne Nnyamundʉ angʉbɨɨkigwa mmaboko agaa bandʉ ababiibi. ");
INSERT INTO nyy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Amusumuke! Tʉbʉʉke. Keeta, ʉndɨɨli gwangʉ asegeliile.” ");
INSERT INTO nyy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Po Jesu bo akaalɨ ikʉjoba, nakalɨnga alɨnkʉfika Juuta Isikalyoti, ʉgwa ndɨ bala kalongo na babɨlɨ, alɨnkwisa pamopeene nɨ kɨlʉndɨlo kya bandʉ aba baakolile ɨnyʉʉbo nɨ nduuha. Abandʉ abo baafumile kʉ bapuuti abalongosi, abamanyisi baa ndagɨlo sya Moose na balongosi baa Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Juuta bo akaalɨ ʉkʉfika kwa Jesu, aababʉʉlile kɨlɨngaani ɨkɨmanyilo, aatile, “Ʉjʉ ngwakʉmfipa, jo jʉʉjo, mukankole, mukasookengepo nagwe kanunu itolo.” ");
INSERT INTO nyy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nakalɨnga, Juuta alɨnkʉbʉʉka kwa Jesu, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Mmanyisi!” Po alɨnkʉmfipa. ");
INSERT INTO nyy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Po abandʉ bala balɨnkʉnkola Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jʉmo ndɨ bala baalipo, alɨnkʉkwaba ʉlʉʉbo, alɨnkʉnsenga ɨmbʉlʉkʉtʉ ʉntʉmwa gwa mpuuti ʉnkʉlʉmba. ");
INSERT INTO nyy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Po paapo Jesu alɨnkʉjoba kʉmyabo alɨnkʉtɨ, “Bʉle, mwisile mukolile ɨnyʉʉbo nɨ nduuha ngatɨ mukʉlɨkola inyambuta? ");
INSERT INTO nyy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Bwila naatʉʉgalaga nkyeni mmyɨnu ndʉpaso lwa tempeli naamanyisyaga, mukaalɨngolilemo sikʉ! Leelo ɨsi silɨ bo ʉlʉ, ʉkʉtɨ siboneke ɨsi sisimbiigwe mwa Kalata ʉMwikemo.” ");
INSERT INTO nyy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Po abafundigwa baake boosa balɨnkʉnndeka Jesu, balɨnkʉbopa. ");
INSERT INTO nyy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Looli aalipo ʉndʉmyana jʉmo ʉjʉ ankongaga Jesu, aaliibigile ɨkɨlʉndo ɨkya mwenda. Balɨnkʉgela ʉkʉnkola, ");
INSERT INTO nyy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","leelo aaliipukunywile, aabalekiile ʉmwenda, alɨnkʉbopa kɨtali. ");
INSERT INTO nyy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Abandʉ bala balɨnkʉmmwega Jesu balɨnkʉntwala kʉkaaja kaa mpuuti ʉnkʉlʉmba, kʉno baabʉngeene boosa, abapuuti abalongosi, abalongosi baa Bajuuta na bamanyisi baa ndagɨlo sya Moose. ");
INSERT INTO nyy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peeteli alɨnkʉnkonga Jesu pabʉtalipo, mpaka nkatɨ ndʉpaso lwa nnyumba jaa mpuuti ʉnkʉlʉmba. Po alɨnkʉtʉʉgala pamopeene na balɨndɨlɨli, alɨnkoota ʉmooto. ");
INSERT INTO nyy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Po paapo abapuuti abalongosi bala na baa lʉkomaano lwa Sanihendilini boosa, baalondaga ʉbʉkeeti ʉbwa kʉjaaga ɨnjɨla ɨjaa kʉnngoga Jesu. Leelo balɨnkʉpondwa. ");
INSERT INTO nyy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Abandʉ bingi bannjobelaga ʉbʉkeeti bwa bʉtʉngʉlʉ, leelo ʉbʉkeeti bwabo bwaleganaga. ");
INSERT INTO nyy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na bangɨ balɨnkwɨma, balɨnkʉnnjobela ʉbʉkeeti bwa bʉtʉngʉlʉ, balɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ʉswe twalɨmpɨliike ʉjʉ bo ikʉtɨ, ‘Ʉne nikʉjoomola ɨtempeli ɨjɨ jɨjengiigwe na maboko. Kangɨ kʉ masikʉ matatʉ nikʉjenga ɨjɨngɨ ɨsita kʉjengigwa na maboko.’ ” ");
INSERT INTO nyy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Poope ʉbʉkeeti bwabo bʉlɨnkʉlegana. ");
INSERT INTO nyy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Po ʉmpuuti ʉnkʉlʉmba alɨnkwɨma pakatɨ, alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Ʉkʉkongana na ɨsi abandʉ aba bikʉkʉsitaaka ʉgwe, bʉle ʉtikwamula nalɨmo?” ");
INSERT INTO nyy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Looli Jesu akaalɨmmwamwile nalɨmo. Po ʉmpuuti ʉnkʉlʉmba alɨnkʉnndaalʉʉsya kangɨ, alɨnkʉtɨ, “Bʉle, ʉgwe gwe Meesija, gwe Mwana gwa Kyala ʉNsisya?” ");
INSERT INTO nyy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Eena, jo ʉne. Ʉmwe mukwisa kʉʉmbona ne Nnyamundʉ ndʉʉgeele kʉmwanya, pabʉjo ʉbwɨmɨkigwa, kʉkɨbafu ɨkiilɨɨlo ɨkya Kyala ʉMwene maka, bo ngwisa mmabɨngo agaa kʉmwanya.” ");
INSERT INTO nyy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Po ʉmpuuti ʉnkʉlʉmba alɨnkʉnyaafulania ɨmyenda gyake ʉkʉnangɨsya ʉbʉkalale, alɨnkʉtɨ, “Tukʉbʉlonda ʉbʉkeeti bwa fiki? ");
INSERT INTO nyy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mupɨliike muno antʉkiile Kyala! Mukʉtɨ fiki ʉmwe?” Boosa balɨnkʉnndonga ʉkʉtɨ kanunu agogigwe. ");
INSERT INTO nyy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bamo balɨnkwanda ʉkʉnswela amata, balɨnkʉmpinya nɨ kɨtambala kʉmaaso, balɨnkʉmmbulɨka nɨ fibuli, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Gwe Meesija, kunguluka! Jo jwani akʉkomile?” Boope abalɨndɨlɨli balɨnkʉmmwega, balɨnkʉnkoma na mapi. ");
INSERT INTO nyy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Po Peeteli aalɨ pabʉjo bwa ndʉpaso. Alɨnkwisa ʉndɨndwana jʉmo ʉgwa mbabombi baa mpuuti ʉnkʉlʉmba, ");
INSERT INTO nyy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","alɨnkʉmmbona Peeteli ikoota ʉmooto. Alɨnkʉnndʉʉsamila alɨnkʉtɨ, “Na nungwe gwalɨ pamopeene na Jesu ʉNnasaleti.” ");
INSERT INTO nyy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Looli Peeteli alɨnkʉkaana alɨnkʉtɨ, “Ngasimanya ɨsi kʉjoba ʉgwe, ndikʉsyagania.” Alɨnkʉsookapo apa aalipo, alɨnkʉbʉʉka kʉ kɨfigo ɨkya lʉpaso. Nakalɨnga ɨngongobe jɨlɨnkʉkoolela. ");
INSERT INTO nyy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ʉndɨndwana jʉla alɨnkʉmmbona kangɨ, alɨnkwanda ʉkʉbabʉʉla aba baalyɨmile pala alɨnkʉtɨ, “Ʉjʉ jo mwinaabo.” ");
INSERT INTO nyy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Looli ʉmwene alɨnkʉkaana kangɨ. Akabalɨlo bo kakɨndilepo panandɨ, aba baalyɨmile pala balɨnkʉmmbʉʉla Peeteli balɨnkʉtɨ, “Nalooli ʉgwe ʉlɨ mwinaabo, paapo ʉlɨ Ngalilai bo ʉlwabo.” ");
INSERT INTO nyy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peeteli alɨnkwanda ʉkʉguna nʉ kʉlapa, alɨnkʉtɨ, “Ngammanya ʉmundʉ ʉjʉ mukʉnnjoba.” ");
INSERT INTO nyy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nakalɨnga ɨngongobe jɨlɨnkʉkoolela ʉlwa kabɨlɨ. Po Peeteli alɨnkʉlɨkʉmbʉka iisyʉ ɨlɨ aajobile Jesu ʉkʉtɨ, “Ɨngongobe bo jɨkaalɨ ʉkʉkoolela ʉlwa kabɨlɨ, kʉngaana katatʉ.” Po alɨnkwinogona, alɨnkʉlɨla fiijo. ");
INSERT INTO nyy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Po nʉlʉbʉnjʉ fiijo, abaa lʉkomaano lwa Sanihendilini ʉlʉ bikʉjamo abapuuti abalongosi, abalongosi baa Bajuuta, pamopeene na bamanyisi baa ndagɨlo sya Moose, boosa balɨnkʉtumula ɨnongwa jaa Jesu. Po balɨnkʉmpinya, balɨnkʉntwala kʉ ndongosi gwa kiisʉ, ɨngamu jaake Pilati. ");
INSERT INTO nyy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Po Pilati alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Bʉle, ʉgwe ʉlɨ Malafyale gwa Bajuuta?” Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Bo lɨlɨɨlyo ʉjobile.” ");
INSERT INTO nyy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Po paapo abapuuti abalongosi balɨnkʉnsitaaka ɨnongwa sii nyingi. ");
INSERT INTO nyy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Po paapo Pilati alɨnkʉnndaalʉʉsya kangɨ alɨnkʉtɨ, “Ʉtikwamula nasimo? Kana bikʉkʉsitaaka sii nyingi?” ");
INSERT INTO nyy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Looli Jesu akaalyamwilepo nasimo. Po Pilati alɨnkʉswiga. ");
INSERT INTO nyy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pa kyaka kya Pasa, Pilati aalɨ nʉ lwiho ʉlwa kʉmmwabʉla ʉmpinyigwa jʉmo, ʉjʉ abandʉ baalondaga ʉkʉtɨ aabʉligwe. ");
INSERT INTO nyy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aalipo ʉmpinyigwa jʉmo ɨngamu jaake aalɨ jo Balaba. Ʉmwene na banine baapinyiigwe mu nnyololo paapo baabagogile abandʉ bo basambwike pakʉpɨnga ʉbʉlongosi bwa kiisʉ. ");
INSERT INTO nyy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kɨlɨnkʉbʉʉka ɨkɨlʉndɨlo kya bandʉ kwa Pilati. Balɨnkʉnsʉʉma ʉkʉtɨ ababombele ʉlwiho lwake ʉlwa kʉmmwabʉla ʉmundʉ jʉmo. ");
INSERT INTO nyy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilati alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Bʉle, mukʉʉndonda mbaabʉlɨle ʉMalafyale gwa Bajuuta?” ");
INSERT INTO nyy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilati aasijobile sisiisi paapo aasyageenie ʉkʉtɨ abapuuti abalongosi baalɨntwele Jesu kʉmyake kʉ bʉʉfi itolo. ");
INSERT INTO nyy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Looli abapuuti abalongosi balɨnkʉbasonga abandʉ ʉkʉtɨ bansʉʉme Pilati, abaabʉlɨle Balaba. ");
INSERT INTO nyy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilati alɨnkʉbalaalʉʉsya kangɨ alɨnkʉtɨ, “Po ndʉbʉlege nagwe ʉjʉ ʉmwe mukʉtɨ jo Malafyale gwa Bajuuta?” ");
INSERT INTO nyy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Balɨnkʉlaata kangɨ balɨnkʉtɨ, “Nkomelele pa kɨkohekano!” ");
INSERT INTO nyy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilati alɨnkʉbalaalʉʉsya kangɨ alɨnkʉtɨ, “Fiki? Abombile mbiibi nki?” Looli abeene balɨnkʉkɨndɨlɨla ʉkʉlaata balɨnkʉtɨ, “Nkomelele pa kɨkohekano!” ");
INSERT INTO nyy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paapo Pilati aalondaga ʉkʉkɨhobosya ɨkɨlʉndɨlo kya bandʉ, alɨnkʉbaabʉlɨla Balaba. Alɨnkʉlagɨla ʉkʉtɨ Jesu akomigwe nɨ fingoti, po alɨnkʉnsoosya ʉkʉtɨ bankomelele pa kɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Po paapo ɨkɨlʉndɨlo kya basikali baa Balooma balɨnkʉmmwega Jesu, balɨnkʉbʉʉka nagwe ndʉpaso lwa nyumba jaa kɨtangaalala kya Pilati. Po abasikali boosa balɨnkʉbʉngaana pala. ");
INSERT INTO nyy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Balɨnkʉmfwɨka ʉnselekesye ʉmfubɨɨfu ʉbʉtiitʉ, ʉgwa malafyale, nɨ ngɨga ɨjaa miifwa muntʉ. ");
INSERT INTO nyy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Balɨnkwanda ʉkʉmponia balɨnkʉtɨ, “Ʉgonile, gwe Malafyale gwa Bajuuta.” ");
INSERT INTO nyy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Balɨnkʉnkoma pantʉ ni ilaasi, kangɨ nʉ kʉnswela amata kʉmaaso. Balɨnkʉfugama, balɨnkʉnngwɨla ʉlʉpi ʉkʉmmwangalɨla. ");
INSERT INTO nyy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bo bamalile ʉkʉmmwangalɨla, balɨnkʉmfuula ʉnselekesye ʉmfubɨɨfu ʉbʉtiitʉ, balɨnkʉmfwɨka kangɨ ɨmyenda gyake. Po balɨnkʉsooka panja nagwe, balɨnkʉntwala kʉkʉnkomelela pa kɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mu njɨla balɨnkwaganila nʉ mundʉ jʉmo aafumile mmigʉnda, iisaga nkaaja. Ɨngamu jaake Simoni, ʉgwise gwa Alikisanda na Lʉfu, ʉgwa nkaaja akaa mu Kilene. Jo balɨnkʉnkola balɨnkʉmfimbɨlɨsya ʉkʉmpɨmbɨla Jesu ɨkɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Balɨnkʉntwala Jesu pabʉjo ʉbʉ bikʉtɨ Goligota, kokʉtɨ ʉLʉpaja lwa Ntʉ. ");
INSERT INTO nyy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Balɨnkʉmpapo ɨfinga ɨjɨ baalyongeenie nʉ nkota mila, ʉgwa kʉpungusya ʉkʉbaba, looli ʉmwene alɨnkʉkaana ʉkʉnwa. ");
INSERT INTO nyy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Balɨnkʉnkomelela pa kɨkohekano, balɨnkʉjabana ɨmyenda gyake kʉ njɨla jaa bʉlagʉsi, ʉkʉtɨ jwani ikwegaga gʉlɨkʉ. ");
INSERT INTO nyy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kaalɨ kabalɨlo kaa sala jaa 3:00 nʉlʉbʉnjʉ, akabalɨlo aka baalɨnkomeliile Jesu pa kɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pamwanya pa kɨkohekano, baasimbile ɨnongwa ɨjɨ baalɨnngogiile, baatile, ");
INSERT INTO nyy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Baalɨnkomeliile pa kɨkohekano palɨkɨmo na banyambuta babɨlɨ, jʉmo kʉkɨbafu ɨkiilɨɨlo, nʉ jʉngɨ kʉkɨbafu ɨkiimama.  ");
INSERT INTO nyy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Syabombiigwe bo muno sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, “Aabaliigwe pamopeene na batʉlanongwa.” ");
INSERT INTO nyy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Boope abandʉ aba bendaga pala, baasukaaniaga ɨmitʉ ʉkʉmmwilaamwa, baatɨgɨ, “Oho! Gwe mpangʉla tempeli nʉ kʉjɨjenga kangɨ kʉ masikʉ matatʉ, ");
INSERT INTO nyy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","gwipoke gwimwene! Ika pa kɨkohekano!” ");
INSERT INTO nyy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bo lʉlʉʉlo na bapuuti abalongosi na bamanyisi baa ndagɨlo sya Moose, baamulanilaga, bammwangalɨlaga baatɨgɨ, “Aabapokaga abangɨ, looli ʉmwene akabagɨla ʉkwipoka. ");
INSERT INTO nyy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Meesija ʉjʉ, ʉMalafyale gwa Banyaisilaɨli, oko asuluke ʉlʉ pa kɨkohekano, ʉkʉtɨ tʉkeete twende nʉ kʉmmwitɨka!” Boope na aba baakomeleliigwe pa fikohekano pamopeene nagwe, bantʉkaga. ");
INSERT INTO nyy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ʉkwandɨla ɨsala jaa 6:00 pamuusi, ɨngiisi jɨlɨnkʉgwa nkiisʉ kɨla kyosa, mpaka ɨsala jaa 9:00. ");
INSERT INTO nyy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Po ɨsala jaa 9:00, Jesu alɨnkʉlaata ʉkʉkoolela alɨnkʉtɨ, “Eloi! Eloi! Lama sabakitani?” Kokʉtɨ, “Kyala gwangʉ! Kyala gwangʉ! Fiki ʉʉndekile?” ");
INSERT INTO nyy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Abandʉ bamo aba baalyɨmile pala, bo bapɨliike ɨsi balɨnkʉtɨ, “Pɨlɨka! Ikʉmmbɨlɨkɨla Elija.” ");
INSERT INTO nyy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ʉmundʉ jʉmo alɨnkʉbopa, alɨnkʉjubɨka ɨsipanji mu finga ɨngalɨ, ɨjɨ jɨlʉlile, alɨnkʉfyɨka kʉ lʉtete, alɨnkʉmpapo ʉkʉtɨ anwe, alɨnkʉtɨ, “Nndeke! Tʉkeete lɨnga Elija ikwisa kʉkʉnsulusya.” ");
INSERT INTO nyy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Po paapo Jesu alɨnkʉlaata ʉkʉkuuta, alɨnkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ɨliibaalɨka lya tempeli lɨlɨnkʉnyaafuka pakatɨ na pakatɨ, ʉkʉfuma kʉmwanya mpaka paasi. ");
INSERT INTO nyy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Po ʉndongosi gwa basikali ʉjʉ aalyɨmile nkyeni mwa Jesu, bo akeetile muno aafwɨliile, alɨnkʉtɨ, “Nalooli ʉmundʉ ʉjʉ aalɨ Mwana gwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Baalipo boope abakiikʉlʉ aba baakeetaga ʉkʉfuma pabʉtali. Mbakiikʉlʉ abo aalimo Malija ʉgwa kʉ Magatala, Salome, Malija ʉnna gwa Jaakobo ʉnnandɨ na Joose. ");
INSERT INTO nyy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Abakiikʉlʉ abo baalongoseenie na Jesu nʉ kʉmmbombela mu Galilai. Baalipo na bakiikʉlʉ abangɨ abingi aba baafyʉkile nagwe ʉkʉbʉʉka mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Iisikʉ lɨla lyalɨ lya kwitendekesya, ʉkʉlembʉkɨla iisikʉ ɨlya pa Sabati. Amajolo bo gafikile, ");
INSERT INTO nyy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","alɨnkwisa ʉmundʉ jʉmo ʉmwɨmɨkigwa, ʉgwa ndʉkomaano lwa Sanihendilini, ɨngamu jaake Joosefu ʉgwa mu Alimatai. Joope ʉmundʉ ʉjʉ aabʉguulɨlaga ʉBʉnyafyale bwa Kyala ʉkwisa. Alɨnkʉkiba ʉkʉmmbʉʉkɨla Pilati, alɨnkʉnsʉʉma ʉkʉtɨ ampepo ʉmfimba gwa Jesu, akasyɨle. ");
INSERT INTO nyy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilati bo ikʉpɨlɨka ʉkʉtɨ Jesu afwile litaasi, alɨnkʉswiga, alɨnkʉnkoolela ʉndongosi gwa basikali, alɨnkʉnndaalʉʉsya lɨnga Jesu afwile nalooli litaasi. ");
INSERT INTO nyy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilati bo asyageenie, alɨnkwitɨkɨsya ʉkʉtɨ Joosefu eege ʉmfimba gwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Po Joosefu alɨnkʉʉla ʉmwenda ʉnnunu. Alɨnkʉgʉsulusya paasi ʉmfimba gwa Jesu ʉkʉfuma pa kɨkohekano. Alɨnkʉgʉniembeteelela mmwenda, alɨnkʉgʉbɨɨka mwi ipʉmba ɨlɨ lyasongoleliigwe kɨlɨngaani ndwalabwe. Po alɨnkʉbungulukɨsyapo iibwe pa kɨfigo ɨkya ipʉmba. ");
INSERT INTO nyy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Malija ʉgwa kʉ Magatala na Malija ʉnna gwa Joose, baapabwene apa baagʉlambaliike ʉmfimba gwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Po iisikʉ ɨlya pa Sabati bo lɨkɨndile, Malija ʉgwa kʉ Magatala, Salome na Malija ʉnna gwa Jaakobo, balɨnkʉʉla ɨmikota gya kwa kʉgʉpaka ʉmfimba gwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Po nʉlʉbʉnjʉ fiijo pi isikʉ ɨlya pa ndʉngʉ, balɨnkʉbʉʉka kwi ipʉmba, bo ɨliisʉba likwanda ʉkʉsooka. ");
INSERT INTO nyy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Po balɨnkʉjobesania balɨnkʉtɨ, “Jwani, ikwakʉbungulusya iibwe lɨla pa kɨfigo ɨkya ipʉmba?” ");
INSERT INTO nyy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Leelo balɨnkʉkeeta, balɨnkwaga iibwe lɨbungulusiigwe. Ɨliibwe lyalɨ inywamu fiijo. ");
INSERT INTO nyy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Balɨnkwingɨla nkatɨ mwi ipʉmba, balɨnkʉmmbona ʉndʉmyana jʉmo ʉjʉ aafwele ʉmwenda ʉmwelu. Aatʉʉgeesye kʉkɨbafu ɨkiilɨɨlo. Abakiikʉlʉ abo balɨnkʉnyomoka fiijo. ");
INSERT INTO nyy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Po ʉndʉmyana ʉjo alɨnkʉbabʉʉla alɨnkʉtɨ, “Mulɨnganyomokaga. Mukʉnndonda Jesu ʉgwa mu Nasaleti ʉjʉ aakomeleliigwe pa kɨkohekano. Akajapo apa! Asyʉkile! Isaga mukeete apa baalɨnndambaliike. ");
INSERT INTO nyy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Namubʉʉkege mukababʉʉle abafundigwa baake, nnoono Peeteli, ʉkʉtɨ ikʉbatalɨla ʉkʉbʉʉka kʉ Galilai. Ʉko ko mukwakʉmmbonaga, bo muno aababʉʉlile.” ");
INSERT INTO nyy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Po paapo balɨnkʉsookapo pala pi ipʉmba, balɨnkʉbopa paapo lwabakomile ʉlʉtende, balɨnkʉtetema. Balɨnkʉsita nʉ kʉmmbʉʉla ʉmundʉ najʉmo simo, namanga baatiilaga.  ");
INSERT INTO nyy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesu bo asyʉkile nʉlʉbʉnjʉ fiijo pi isikʉ ɨlya pa ndʉngʉ, alɨnkʉnsetʉkɨla taasi Malija ʉgwa kʉ Magatala, ʉjʉ Jesu aasisoosiisye mmyake ɨmbepo ɨnyali ihaano na ibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Malija ʉjo alɨnkʉbʉʉka alɨnkwakʉbabʉʉla bala baajaga pamopeene na Jesu. Akabalɨlo ako baalɨ nkatɨ nkwilɨlɨɨsya nʉ kʉlɨla. ");
INSERT INTO nyy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Looli abeene bo bapɨliike ʉkʉtɨ Jesu mʉʉmi, kangɨ nʉ kʉtɨ Malija ʉgwa kʉ Magatala ammbwene, bakaaliitiike. ");
INSERT INTO nyy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Po piitaasi palɨ ɨsi, abafundigwa babɨlɨ bendaga mmigʉnda. Po Jesu alɨnkʉbabonekela mu njɨla, aalyandwike alɨnkʉboneka ngatɨ jʉngɨ. ");
INSERT INTO nyy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Balɨnkʉbʉʉka kangɨ kʉ Jelusalemu, balɨnkwakʉbabʉʉla abafundigwa biinaabo, looli boope bakaabiitiike. ");
INSERT INTO nyy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kʉmmalɨɨkɨsyo, Jesu alɨnkʉbabonekela abafundigwa baake kalongo na jʉmo, bo balɨ boosa pakʉlyamo. Alɨnkʉbakemela fiijo kʉnongwa jaa bʉkafu bwa ndumbula syabo, paapo bakaabiitiike bala baalɨmmbwene bo asyʉkile. ");
INSERT INTO nyy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Po paapo alɨnkʉbabʉʉla alɨnkʉtɨ, “Namubʉʉkege nkiisʉ kyosa, mukalʉmbɨlɨlege ɨNdʉmi ɨNunu ɨjaa Kyala kʉ bandʉ boosa! ");
INSERT INTO nyy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ʉjʉ ikwitɨka, kangɨ nʉ koosigwa, jo ikʉpokigwa. Looli ʉjʉ atikwitɨka ikwisa kʉlongigwa. ");
INSERT INTO nyy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kangɨ aba bikwitɨka, bikʉbombaga ɨfiika bo ɨfi. Mu ngamu jangʉ bikʉsikagaga ɨmbepo ɨnyali, bikʉjobaga ɨnjobelo ɨmbya, ");
INSERT INTO nyy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bikʉkolaga ɨnjoka, lɨnga bikʉnwa kamo akagogi, katikʉboonangaga, kangɨ bikʉbɨɨkaga amaboko pa babine, po ababine bikʉbʉmbʉlʉkaga.” ");
INSERT INTO nyy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ɄNtwa Jesu bo amalile ʉkʉjoba na bafundigwa baake, alɨnkwegigwa ʉkʉfyʉka kʉmwanya. Alɨnkʉtʉʉgala kʉmwanya, pabʉjo ʉbwɨmɨkigwa, kʉkɨbafu ɨkiilɨɨlo ɨkya Kyala. ");
INSERT INTO nyy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Abafundigwa balɨnkʉbʉʉka kʉkʉlʉmbɨlɨla moosamoosa. ɄNtwa aabombaga ɨmbombo pamopeene nabo, alɨnkʉlɨsisimɨkɨsya iisyʉ lyake nɨ fiika ɨfi baabombaga.");
INSERT INTO nyy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kʉmyako gwe mwɨmɨkigwa Tyofili: Abandʉ bingi biijʉʉlile ʉkʉsimba ɨnongwa sya Jesu Kɨlɨsiti, ɨsi syaboniike pakatɨ pamyɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Basimbile ɨnongwa ɨsyo, bo ʉlʉ baatʉpangiile aba baasibwene nʉ kʉsifumusya ʉkʉfuma kʉbwandɨlo. ");
INSERT INTO nyy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ndondile kanunu ʉbwanalooli ʉbwa nongwa sya Jesu ʉkʉfuma kʉbwandɨlo, po na niine nsibwene ʉkʉja kanunu ʉkʉkʉsimbɨla ɨsyo syosa kʉ lʉbaatɨko, ");
INSERT INTO nyy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ʉkʉtɨ ʉbwaganie ʉbwanalooli ʉbwa nongwa syosa ɨsi ʉmanyisiigwe. ");
INSERT INTO nyy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Amasikʉ aga Heloti aalɨ malafyale gwa nkiisʉ ɨkya Jutai, aalipo ʉmpuuti jʉmo ɨngamu jaake Sakalija, ʉgwa nkɨbugutɨla kya bʉpuuti ɨkya Abija. Ʉnkasi gwa Sakalija aalɨ jo Elisabeti, ʉgwa nkɨkolo ɨkya Aaloni. ");
INSERT INTO nyy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakalija na Elisabeti baalɨ bagolofu nkyeni mwa Kyala, baasikongile kanunu ɨndagɨlo syosa ɨsya Kyala, kɨsita koonanga. ");
INSERT INTO nyy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Abandʉ aba bakaalɨ nʉ mwana, paapo Elisabeti aalɨ nngʉmba, kangɨ baalɨ bakangale. ");
INSERT INTO nyy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Lwaliko ʉlʉbaatɨko ʉlwa bapuuti ʉlwa kʉbomba ɨmbombo mu tempeli. Akabalɨlo kamo ndʉbaatɨko ʉlo, kaalɨ kabalɨlo akaa kɨbugutɨla ɨkya Abija. Bo ʉlʉ lwajɨɨliile ʉlwiho ʉlwa bapuuti, baabombile ʉbʉlagʉsi. Po Sakalija aasaliigwe ʉkwingɨla mu tempeli ʉkʉtɨ ookye lʉbani nkyeni mwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Bo alɨ mu tempeli ikookya, abandʉ bingi baalɨ ndʉpaso lwa tempeli biipuutaga. ");
INSERT INTO nyy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Po ʉgwandʉmi gwa Ntwa alɨnkʉnsetʉkɨla Sakalija, aalyɨmile ɨkɨbafu ɨkya kʉ kiilɨɨlo ɨkya kɨgemo kya kookela lʉbani. ");
INSERT INTO nyy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakalija bo ikʉmmbona ʉgwandʉmi jʉla, aanyomwike, kangɨ aakoliigwe nʉ lʉtende. ");
INSERT INTO nyy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Looli ʉgwandʉmi jʉla alɨnkʉmmbʉʉla alɨnkʉtɨ, “Sakalija, ʉlɨngatiilaga! Kyala apɨliike ʉkʉsʉʉma kwako, po ʉnkasi gwako Elisabeti ikʉkʉpaapɨla ʉmwana ʉnnyambala, ʉnkoolelege ɨngamu ɨjaa Johani. ");
INSERT INTO nyy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Apo kʉjaga nʉ lʉsekelo ʉlʉnywamu, kangɨ abandʉ bingi aabikʉhoboka kʉnongwa jaa kʉpaapigwa kwake, ");
INSERT INTO nyy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","paapo ikʉjaga nʉ bʉkʉlʉmba ʉbʉfuma kʉ Ntwa. Atikʉnwaga ɨfinga pamo koosa kala aka kikʉgaalɨsya, kangɨ ikwisʉla Mbepo Mwikemo ʉkʉfuma bo alɨ ndwanda lwa nna. ");
INSERT INTO nyy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ikʉbagomokesyaga aBanyaisilaɨli bingi kʉ Ntwa, Kyala gwabo. ");
INSERT INTO nyy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ʉjo ikʉtalapo nkyeni mu Ntwa, bo alɨ na Mbepo Mwikemo na maka bo ʉlwa Elija, ʉkʉbafwania abapaapi na baanaabo, kangɨ ʉkʉbagomokesya abatʉlanongwa amahala agaa bʉgolofu, nʉ kʉbatendekesya abandʉ ʉkʉmmwambɨlɨla ʉNtwa.” ");
INSERT INTO nyy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Po Sakalija alɨnkʉnndaalʉʉsya ʉgwandʉmi alɨnkʉtɨ, “Kandʉ nki aka kikʉmbela ʉne ʉkwitɨka amasyʉ aga ʉkʉja gaa nalooli? Paapo ʉne nʉ nkasi gwangʉ tʉlɨ bakangale, amasikʉ gakɨndile.” ");
INSERT INTO nyy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ʉgwandʉmi alɨnkʉmmwamula alɨnkʉtɨ, “Ʉne ne Gabilieli, ne ngwɨma nkyeni mwa Kyala, andʉmile kʉkʉjoba na nungwe nʉ kʉkʉbʉʉla ɨndʉmi ɨjɨ ɨnunu. ");
INSERT INTO nyy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ʉlʉ, paapo ʉkiitɨka ɨsi ngʉbʉʉlile, ʉtikʉjobaga mpaka ɨliisikʉ ɨlɨ sikwisa kʉboneka. Nalooli ɨsi aasikʉboneka pakabalɨlo kaake.” ");
INSERT INTO nyy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Akabalɨlo ako, abandʉ bala bannguulɨlaga Sakalija balɨnkʉnswiga, paapo aakaabiile ʉkʉsooka mu tempeli. ");
INSERT INTO nyy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bo ikʉsooka aatoliigwe ʉkʉjoba simo kʉmyabo, po abeene balɨnkʉmanya ʉkʉtɨ, finsetʉkiile fimo mu tempeli. Joope alɨnkʉjobela geene amaboko, aasyele nsita kʉjoba. ");
INSERT INTO nyy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Amasikʉ gaake agaa kʉbomba ɨmbombo sya bʉpuuti bo gamaliike, alɨnkʉbʉʉka kʉkaaja. ");
INSERT INTO nyy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Piitaasi ʉnkasi gwake Elisabeti alɨnkʉja nɨ kɨfuba, alɨnkʉja nnyumba ɨmyesi mihaano. ");
INSERT INTO nyy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Alɨnkwinogona ʉkʉtɨ, “Ɨsi syo ɨsi ʉNtwa aambombiile ʉne. Mmasikʉ aga, ambeliile ɨkɨsa nʉ kʉʉsookesyapo ɨsoni nkyeni mmbandʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ɨmyesi mihaano ɨgya kʉja nɨ kɨfuba Elisabeti bo gɨkɨndile, mmwesi gwa ntandatʉ, Kyala alɨnkʉntʉma ʉgwandʉmi Gabilieli nkaaja akaa mu Nasaleti, aka kaalɨ nkiisʉ ɨkya Galilai. ");
INSERT INTO nyy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Apo aalipo ʉndɨndwana jʉmo, ɨngamu jaake aalɨ jo Malija. Akaalɨmmeenyemo sikʉ ʉnnyambala, aasingɨliigwe nʉ mundʉ jʉmo, ɨngamu jaake alɨ jo Joosefu, ʉgwa ndʉjungu lwa malafyale Ndaabɨti. ");
INSERT INTO nyy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ʉgwandʉmi bo afikile kwa Malija alɨnkʉmmbʉʉla alɨnkʉtɨ, “Nikʉkʉponia, ʉgwe gwe ʉkabile ɨliipyana! ɄNtwa alɨ na nungwe!” ");
INSERT INTO nyy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malija alɨnkʉtaamigwa fiijo mu ndumbula, alɨnkwilaalʉʉsya alɨnkʉtɨ, “Ʉlʉponio ʉlʉ, lwa lʉko lʉki?” ");
INSERT INTO nyy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Po ʉgwandʉmi alɨnkʉtɨ, “Malija, ʉlɨngatiilaga, paapo ʉkabile ɨliipyana ʉkʉfuma kwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Keeta, kʉkaba ɨkɨfuba, kʉpaapa ʉmwana ʉnnyambala, ʉnkoolelege ɨngamu ɨjaa Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ʉmwana ʉjo ikʉjaga nkʉlʉmba, ikʉkooleligwaga Mwana gwa Kyala ʉNkʉlʉmba. ɄNtwa Kyala ikʉmpapo ɨkɨkota kya bʉtwa ɨkya mwisʉkʉlʉ Ndaabɨti. ");
INSERT INTO nyy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kangɨ ikʉbalongosyaga aBanyaisilaɨli bwila na bwila, ʉBʉnyafyale bwake bʉtikʉmalɨkaga.” ");
INSERT INTO nyy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Malija alɨnkʉnndaalʉʉsya ʉgwandʉmi alɨnkʉtɨ, “Ʉne ngammanyamo sikʉ ʉnnyambala, po ɨsi sikʉjaga bʉleebʉle?” ");
INSERT INTO nyy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ʉgwandʉmi alɨnkʉmmwamula alɨnkʉtɨ, “Mbepo Mwikemo ikʉkwisɨla, goope na maka agaa Kyala ʉNkʉlʉmba aagikʉkʉkupɨkɨla ngatɨ kɨpepo. Kʉnongwa ɨjo ʉmwana ʉjʉ ikʉpaapigwa ikʉjaga mwikemo, ikʉkooleligwaga Mwana gwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Keeta! Joope ʉnkamu gwako Elisabeti, ʉjʉ bantɨgɨ nngʉmba, mbʉkangale bwake alɨ nɨ kɨfuba ɨkya myesi ntandatʉ, ɨkya mwana ʉnnyambala. ");
INSERT INTO nyy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Paapo kakajako aka abagiile ʉkʉtoligwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Po Malija alɨnkʉtɨ, “Keeta ʉne, ndɨ mbombeli gwa Ntwa! Sijege bo muumo ʉjobiile kʉmyangʉ.” Po ʉgwandʉmi alɨnkʉsookapo. ");
INSERT INTO nyy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bo gakɨndile amasikʉ gamo, Malija alɨnkʉbʉʉka mbɨbɨmbɨbɨ nkaaja akaa mfyamba akaa nkiisʉ ɨkya Jutai. ");
INSERT INTO nyy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Bo afikile kʉla alɨnkwingɨla nnyumba jaa Sakalija, alɨnkʉmponia Elisabeti. ");
INSERT INTO nyy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabeti bo apɨliike ʉlʉponio ʉlwa Malija, ʉmwana ndwanda lwake aakinile. Elisabeti alɨnkwisʉla Mbepo Mwikemo, ");
INSERT INTO nyy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","alɨnkʉlaata ʉkʉjoba alɨnkʉtɨ, “Ʉsajiigwe ʉgwe mbakiikʉlʉ boosa, joope asajiigwe ʉmwana ʉjʉ kʉpaapaga! ");
INSERT INTO nyy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Fiki siinyaagile ʉne ɨsi, ʉnna gwa Ntwa gwangʉ aanyendiile ʉne? ");
INSERT INTO nyy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Paapo bo mbɨliike ɨliisyʉ ɨlɨ gʉmboniisye, ʉmwana ʉjʉ alɨ ndwanda lwangʉ akinile kʉ lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ʉsajiigwe gwe gwitiike ʉkʉtɨ aasikʉbombigwa sila ajobile kʉmyako ʉNtwa.” ");
INSERT INTO nyy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Po Malija alɨnkʉtɨ, “Ngʉntuufya ʉNtwa nɨ ndumbula jangʉ, ");
INSERT INTO nyy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ɨndumbula jangʉ jɨnsaaliile Kyala, ʉMpoki gwangʉ, ");
INSERT INTO nyy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","paapo abʉbwene ʉbʉfujufu bwa mbombeli gwake. Keeta, ʉkʉfuma akabalɨlo aka, ɨngʉlɨlo syosa ɨsya bandʉ bikʉʉnjobaga ʉkʉja nsajigwa, ");
INSERT INTO nyy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","paapo ʉGwa maka aambombiile ɨngʉlʉmba, nɨ ngamu jaake nyiikemo. ");
INSERT INTO nyy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ɨkɨbabɨɨlɨsi kyake kɨlipo kʉlɨ aba bikʉntiila, mu ngʉlɨlo syosa. ");
INSERT INTO nyy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Abombile ɨngʉlʉmba nɨ kɨboko kyake, aba balɨ na matingo mu ndumbula syabo, ababaleenie. ");
INSERT INTO nyy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Abasulwisye abakʉlʉmba mfikota fyabo ɨfya bʉtwa, abaa lwijiisyo abiinwile. ");
INSERT INTO nyy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Abaa njala abiisʉkiisye ʉtʉnunu, abakabi abakagile maboko matʉpʉ. ");
INSERT INTO nyy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Abatʉʉlile ababombeli baake aBanyaisilaɨli, ʉkʉkʉmbʉka ɨkɨbabɨɨlɨsi kyake, ");
INSERT INTO nyy_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ʉlwa bwila na bwila, bo muno aababʉʉlile baataata, Abulahamu nʉ lʉjungu lwake.” ");
INSERT INTO nyy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malija aatʉʉgeele na Elisabeti ɨmyesi mitatʉ bʉno, po alɨnkʉbʉʉka kʉmyake. ");
INSERT INTO nyy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ʉbʉsikʉ bwa kʉpaapa Elisabeti bʉlɨnkʉfika, alɨnkʉpaapa ʉmwana ʉnnyambala. ");
INSERT INTO nyy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Abapalamani na bakamu balɨnkʉpɨlɨka ʉkʉtɨ ʉNtwa ampeliile fiijo ɨkɨsa, balɨnkʉsekela pamopeene nagwe. ");
INSERT INTO nyy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pi isikʉ lya lwele ʉkʉfuma pakʉpaapigwa ʉmwana, balɨnkwisa kʉkʉmmbuuta kʉkyeni ʉmwana. Baalondaga ʉkʉmpa ʉmwana ɨngamu jaa gwise, ɨjaa Sakalija. ");
INSERT INTO nyy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Looli ʉnna alɨnkʉbaamula alɨnkʉtɨ, “Mma, ikʉkooleligwaga ɨjaa Johani.” ");
INSERT INTO nyy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Abeene balɨnkʉmmbʉʉla balɨnkʉtɨ, “Nkɨkolo kyako akajapo najʉmo ʉmundʉ ʉgwa ngamu bo ɨjo.” ");
INSERT INTO nyy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Po balɨnkʉjobela amaboko ʉkʉnndaalʉʉsya ʉgwise ɨngamu ɨjaa kʉmpapo ʉmwana. ");
INSERT INTO nyy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakalija alɨnkʉsʉʉma ɨkɨtapwa ɨkya kʉsimbapo, alɨnkʉsimba alɨnkʉtɨ, “Ɨngamu jaake jo Johani.” Abandʉ boosa balɨnkʉswiga. ");
INSERT INTO nyy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Palapala akanwa kalɨnkwigʉka, ʉlʉlɨmi lʉlɨnkʉgoloka, alɨnkwanda ʉkʉjoba nʉ kʉntuufya Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Abapalamani boosa abaa Sakalija lwabakolile ʉlʉtende. Ɨnongwa ɨsi syabalaniile nkaaja koosa akaa mfyamba fya mu Jutai. ");
INSERT INTO nyy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Abandʉ boosa aba baapɨliike, balɨnkwilaalʉʉsya mu ndumbula syabo balɨnkʉtɨ, “Ʉmwana ʉjʉ ikʉjaga gwa lʉko lʉki?” Baajobaga bo ʉlo paapo amaka gaa Ntwa gaalɨ pamopeene nagwe. ");
INSERT INTO nyy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Po Sakalija ʉgwise gwa mwanike, alɨnkwisʉla Mbepo Mwikemo, alɨnkʉkunguluka alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Atuufigwege ʉNtwa Kyala gwa Isilaɨli, paapo abiisiile nʉ kʉbaabʉla abandʉ baake. ");
INSERT INTO nyy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atʉpeele ʉMpoki ʉgwa maka, ʉkʉfuma nkɨkolo ɨkya mbombeli gwake Ndaabɨti. ");
INSERT INTO nyy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Bo muno Kyala aajobiile ijolo, ʉkwendela mbakunguluka baake abiikemo ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","tʉpokigwe kʉ balʉgʉ bɨɨtʉ, mmaboko gaa bandʉ boosa aba bikʉtʉbenga, ");
INSERT INTO nyy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ʉkʉnangɨsya ɨkɨbabɨɨlɨsi kʉ biisʉkʉlʉ bɨɨtʉ, nʉ kʉkʉmbʉka ʉlwitɨkano lwake ʉlwikemo. ");
INSERT INTO nyy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ʉkʉlapa ʉko aalɨnndapiile ʉmwisʉkʉlʉ gwɨtʉ Abulahamu, ");
INSERT INTO nyy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ʉkʉtʉpoka ʉswe mmaboko gaa balʉgʉ bɨɨtʉ, ʉkʉtɨ tʉmmbombelege ʉmwene kɨsita lʉtende, ");
INSERT INTO nyy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mbwikemo na mbʉgolofu, mmasikʉ goosa agaa bʉʉmi bwɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Po ʉgwe gwe mwanangʉ, kʉkooleligwaga nkunguluka gwa Kyala ʉNkʉlʉmba, paapo kʉntalɨlapo ʉNtwa ʉkʉntendekekesya ʉmwene ɨnjɨla, ");
INSERT INTO nyy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ʉkʉbabʉʉla abandʉ baake ɨsya bʉpoki, ʉkwendela nkʉbahobokela ʉbʉtʉlanongwa bwabo. ");
INSERT INTO nyy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kʉnongwa jaa kɨbabɨɨlɨsi ɨkɨkʉlʉmba ɨkya Kyala gwɨtʉ, ʉndangalɨla ʉkʉfuma kʉmwanya gukʉtwisɨla, ");
INSERT INTO nyy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ʉkʉbamulɨkɨla aba balɨ mu ngiisi na nkɨpepo ɨkya bʉfwe, nʉ kʉtʉlongosya mu njɨla jaa lʉtengaano.” ");
INSERT INTO nyy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ʉmwanike Johani aakʉlile, amaka agaa kʉfuma kwa Mbepo Mwikemo galɨnkongelela. Alɨnkʉtʉʉgala ndʉngalangala, mpaka iisikʉ ɨlɨ aaliinangiisye kʉ Banyaisilaɨli. ");
INSERT INTO nyy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nkabalɨlo kala, ʉmalafyale gwa Balooma ɨngamu jaake Agusiti, aalagiile ʉkʉtɨ abandʉ boosa mfiisʉ fya mbʉlongosi bwake babaligwe. ");
INSERT INTO nyy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lwalɨ lwa kwanda ʉkʉbala abandʉ, akabalɨlo aka Kilenio aalongosyaga ɨkiisʉ kya Silija. ");
INSERT INTO nyy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Po abandʉ boosa baabʉʉkile kʉkʉtɨ mundʉ nkɨpanga kyake kʉkʉbaligwa. ");
INSERT INTO nyy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joope Joosefu alɨnkʉsookamo nkaaja akaa mu Nasaleti akaa nkiisʉ ɨkya Galilai, alɨnkʉbʉʉka nkaaja akaa mu Betelehemu akaa nkiisʉ ɨkya Jutai, kʉno aapaapiigwe ʉmalafyale Ndaabɨti, paapo Joosefu aalɨ gwa ndʉjungu lwa Ndaabɨti. ");
INSERT INTO nyy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aabʉʉkile kʉkʉbaligwa pamopeene na Malija ʉjʉ aalɨnsingiile. Akabalɨlo ako Malija aalɨ nɨ kɨfuba. ");
INSERT INTO nyy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bo balɨ kʉ Betelehemu, Malija kalɨnkʉfika akabalɨlo kaake akaa kʉpaapa. ");
INSERT INTO nyy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Alɨnkʉpaapa ʉmwana gwa kwanda ʉnnyambala, alɨnkʉnniembeteelela ɨmyenda ɨgya baanike. Kangɨ alɨnkʉnndambalɨka nkɨpondo ɨkya kʉlɨɨlamo ɨngʼombe, kʉnongwa jaa kʉtɨ Joosefu na Malija bakaabwagile ʉbʉjo nnyumba jaa baheesya. ");
INSERT INTO nyy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kɨfuki na pala baalipo, baaliko abatiimi aba baatʉʉgalaga kʉ lʉkʉbo, baalɨndɨlɨlaga ɨngʼoosi pakɨlo. ");
INSERT INTO nyy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ʉgwandʉmi gwa Ntwa alɨnkʉbabonekela nakalɨnga, ʉndangalɨla ʉgwa Ntwa gwabamuliike ɨfibafu fyosa, balɨnkʉtiila fiijo. ");
INSERT INTO nyy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ʉgwandʉmi alɨnkʉtɨ, “Pɨlɨkɨsya, mungatiilaga, mbatwaliile ʉmwe ɨndʉmi ɨnunu ɨjaa kʉbahobosya fiijo abandʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ʉmwisyʉgʉ, ʉMpoki apaapiigwe kʉnongwa jɨɨnu nkaaja akaa Ndaabɨti, jo Meesija ʉNtwa. ");
INSERT INTO nyy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ɨkɨmanyilo kʉmyɨnu kyo ɨkɨ. Mukwakʉmmwaga ʉmwana ʉmfyele, banniembeteeliile ɨmyenda ɨgya baanike, alambaleele nkɨpondo ɨkya kʉlɨɨlamo ɨngʼombe.” ");
INSERT INTO nyy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nakalɨnga ʉgwandʉmi jʉla alɨnkʉja nɨ kɨlʉndɨlo ɨkɨnywamu ɨkya bandʉmi abaa kʉmwanya, bantuufyaga Kyala baatɨgɨ, ");
INSERT INTO nyy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Atuufigwege Kyala kʉmwanya, nʉ lʉtengaano lʉjege nkiisʉ, kʉ bandʉ aba abiitiike ʉkʉbapapo ɨliipyana.” ");
INSERT INTO nyy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Abandʉmi balɨnkʉsookapo ʉkʉbʉʉka kʉmwanya, abatiimi bala balɨnkʉjobesania balɨnkʉtɨ, “Ʉlʉ, tʉsookepo tʉbʉʉke kʉ Betelehemu, tʉkakeete ɨsi siboniike, ɨsi ʉNtwa atʉbʉʉlile.” ");
INSERT INTO nyy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Balɨnkʉbʉʉka mbɨbɨmbɨbɨ kʉ Betelehemu. Balɨnkʉmmwaga Malija na Joosefu, nʉ mwana alambaleele nkɨpondo ɨkya kʉlɨɨlamo ɨngʼombe. ");
INSERT INTO nyy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bo bankeetile ʉmwana, balɨnkʉbapangɨla abandʉ ɨnongwa ɨsi ʉgwandʉmi aababʉʉlile ɨsya mwana jʉla. ");
INSERT INTO nyy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Boosa aba baapɨliike ɨnongwa ɨjɨ, baaswigile. ");
INSERT INTO nyy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Looli Malija aagiinogoniile aga goosa nʉ kʉgabɨɨka mu ndumbula jaake. ");
INSERT INTO nyy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Abatiimi bala balɨnkʉgomoka kʉno bikʉnngindɨka nʉ kʉntuufya Kyala, kʉlɨ syosa ɨsi baasipɨliike nʉ kʉsikeeta, bo muno ababʉʉlile ʉgwandʉmi. ");
INSERT INTO nyy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ɨliisikʉ lya lwele ʉkʉfuma ʉmwana pakʉpaapigwa bo lɨfikile, kalɨnkʉja kabalɨlo kaa kʉmmbuuta kʉkyeni, balɨnkʉmpapo ɨngamu ɨjaa Jesu. Ɨngamu ɨjɨ aapeeliigwe nʉ gwandʉmi, bo ʉnna akaalɨ ʉkʉja nɨ kɨfuba. ");
INSERT INTO nyy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Akabalɨlo kaa kwelʉsigwa kwa Joosefu na Malija bo kakɨndile, bo muno sijɨɨliile ɨndagɨlo sya Moose, baabʉʉkile nʉ mwana kʉla kʉ Jelusalemu kʉkʉmmbɨɨka kʉ Ntwa. ");
INSERT INTO nyy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bo muno sisimbiigwe mwa kalata gwa ndagɨlo ɨsya Ntwa Kyala ʉkʉtɨ, “Ʉmwana ʉnnyambala gwesa jʉla ʉgwa kwanda mu nna, abɨɨkigwe ʉkʉja mwikemo kʉ Ntwa.” ");
INSERT INTO nyy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kangɨ baasoosiisye iikemo kʉnongwa jaa kwelʉsigwa, bo muno lwajɨɨliile ʉlʉlagɨlo ʉlwa Ntwa ʉkʉtɨ, basoosye ɨngʉnde ibɨlɨ pamo ɨngʉngʉbɨja ɨmwana ibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Po akabalɨlo kala mu Jelusalemu, aalipo ʉmundʉ jʉmo ɨngamu jaake Simyoni. Ʉmundʉ ʉjo aalɨ ngolofu, antiilaga Kyala, aasʉʉbɨlaga ʉkʉpokigwa aBanyaisilaɨli. Mbepo Mwikemo anndongosyaga, ");
INSERT INTO nyy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","aalɨmmbʉʉlile Simyoni ʉkʉtɨ atikʉfwa mpaka apa ikwisa kʉmmbona Meesija gwa Ntwa. ");
INSERT INTO nyy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Apo, Mbepo Mwikemo aalɨnndongwisye Simyoni ʉkʉbʉʉka ndʉpaso lwa tempeli. Abapaapi baa Jesu bo bantwele Jesu ndʉpaso lwa tempeli, ʉkʉtɨ bammbombele bo muno syalagɨliigwe mu ndagɨlo, ");
INSERT INTO nyy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simyoni alɨnkʉmmwega, alɨnkʉmpagata, alɨnkʉntuufya Kyala alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Gwe Ntwa, ʉʉnyiitɨkɨsye ne mbombeli gwako mfwe nʉ lʉtengaano, bo ʉlʉ gwafingile. ");
INSERT INTO nyy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Amaaso gangʉ gabʉbwene ʉbʉpoki bwako, ");
INSERT INTO nyy_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ʉbʉ ʉbʉsetwile nkyeni mmbandʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Bukʉjaga lʉmuli lwa kʉbamulɨkɨla boosa aba bakaja Banyaisilaɨli, nʉ kʉtwala ʉbʉsisya kʉ bandʉ baako aBanyaisilaɨli.” ");
INSERT INTO nyy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ɨnongwa ɨsya mwana ɨsi Simyoni aajobile, syabaswigiisye ʉgwise nʉ nna gwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Po Simyoni alɨnkʉbasaja, alɨnkʉmmbʉʉla Malija ʉnna alɨnkʉtɨ, “Keeta, ʉmwana ʉjʉ abɨɨkiigwe na Kyala, kʉnongwa jaa kʉbagwɨsya nʉ kʉbiinʉla abandʉ bingi mBanyaisilaɨli. Ikʉjaga kɨmanyilo ɨkɨ kɨfumile kwa Kyala ɨkɨ bamo bikʉkɨpɨngaga. ");
INSERT INTO nyy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Po ɨnyiinogono ɨsya bingi sikʉjaga pabwelu. Na nungwe kwisa kʉbabigwaga mu ndumbula, ngatɨ kʉlasigwa nʉ lʉʉbo.” ");
INSERT INTO nyy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kangɨ aalipo ʉnkunguluka ʉnkiikʉlʉ ʉjʉ aalɨ nkangale fiijo, ɨngamu jaake Ana. Aalɨ mwana gwa Fanweli ʉmfuma nkɨkolo ɨkya Aaseli. Bo atʉʉgeele ɨfyɨnja fihaano na fibɨlɨ ʉkʉfuma pakwegigwa, ʉndʉme alɨnkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Aalɨ mfwɨle ʉjʉ aalɨ nɨ fyɨnja 84. Akabalɨlo koosa ako aajaga ndʉpaso lwa tempeli, iipuutaga nʉ kʉfipɨɨka ɨfindʉ kʉnongwa jaa kʉnsʉʉma Kyala pakɨlo na pamuusi. ");
INSERT INTO nyy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Akabalɨlo kalakala bo Simyoni ikʉjoba na Joosefu pamopeene na Malija, ʉnkunguluka Ana alɨnkwisa apa baalipo. Po alɨnkʉntuufya Kyala nʉ kʉfumusya ɨnongwa ɨsya mwana jʉla kʉ bandʉ boosa aba bankeetelelaga Kyala ʉkʉbaabʉla aBanyaisilaɨli. ");
INSERT INTO nyy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joosefu na Malija bo bamalile ʉkʉbomba ʉlʉbaatɨko loosa ʉlwa ndagɨlo sya Ntwa, balɨnkʉbʉʉka kʉmyabo kʉ Nasaleti nkiisʉ ɨkya Galilai. ");
INSERT INTO nyy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ʉmwana jʉla alɨnkʉkʉla, Kyala alɨnkʉmpa amaka, amahala nʉ bʉndʉ. Ɨliipyana lya Kyala lyalɨ pamopeene nagwe. ");
INSERT INTO nyy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kʉkʉtɨ kyɨnja abapaapi baake Jesu baabʉʉkaga kʉ Jelusalemu kʉkʉsekela ɨkyaka kya Pasa. ");
INSERT INTO nyy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesu bo alɨ nɨ fyɨnja kalongo na fibɨlɨ, aabʉʉkile na bapaapi baake kʉla, bo muno lwajɨɨliile ʉlwiho. ");
INSERT INTO nyy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Amasikʉ gaa kyaka kya Pasa bo gamaliike, abapaapi baake balɨnkʉsookapo ʉkʉgomoka kʉkaaja, kɨsita kʉmanya ʉkʉtɨ ʉmwana Jesu asyele kʉla kʉ Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bo bikʉgomoka kʉkaaja, baatɨgɨ Jesu alɨ nkɨbugutɨla ɨkya bendanjɨla. Bo bendile iisikʉ lɨmo, po balɨnkwanda ʉkʉnndonda mbakamu na mbamanyaani, ");
INSERT INTO nyy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","bakaalɨmmbwene. Po balɨnkʉgomoka kʉla kʉ Jelusalemu kʉno bikʉnndonda. ");
INSERT INTO nyy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Amasikʉ matatʉ bo gakɨndile, balɨnkʉmmbona ndʉpaso lwa tempeli, atʉʉgeele na bamanyisya ndagɨlo sya Moose, ikʉbapɨlɨkɨsya nʉ kʉbalaalʉʉsya. ");
INSERT INTO nyy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Boosa aba bampɨlɨkɨsyaga, balɨnkʉnswiga fiijo amahala gaake nʉ kwamula kwake. ");
INSERT INTO nyy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Boope abapaapi baake bo bammwagile ndʉpaso lwa tempeli, baaswigile fiijo. Po ʉnna alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Mwanangʉ, fiki ʉtʉbombiile bo ʉlʉ? Keeta! Ʉne nʉ gʉʉso tʉkʉlondile nʉ lʉtende!” ");
INSERT INTO nyy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Fiki mwandondaga? Bʉle, mukaameenye ʉkʉtɨ ʉne ngʉlondigwa na Taata ʉkʉja mu nyumba jaake?” ");
INSERT INTO nyy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Looli abapaapi baake bakaasyageenie ɨsi aababʉʉlaga. ");
INSERT INTO nyy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Po Jesu alɨnkʉgomoka na bapaapi baake kʉ Nasaleti, aabapɨlɨkaga. Ʉnna alɨnkʉsibɨɨka syosa ɨsi mu ndumbula jaake. ");
INSERT INTO nyy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesu alɨnkʉkʉla amahala, ʉbʉndʉ nʉ mbɨlɨ, alɨnkʉnhobosya Kyala na bandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ɨkyɨnja kya 15 mbʉlongosi bwa malafyale gwa Balooma Tibelio, Pontio Pilati aalongosyaga nkiisʉ ɨkya mu Jutai. Heloti aalongosyaga ɨkiisʉ ɨkya Galilai, joope Filipo ʉgwamyabo aalongosyaga mu Ituleja na mu Tulakoniti. Lisanija joope aalongosyaga mu Abilene. ");
INSERT INTO nyy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kajafa baalɨ bapuuti abalongosi. Akabalɨlo ako, Kyala alɨnkʉntʉma Johani ʉmwana gwa Sakalija ʉkʉlʉmbɨlɨla ndʉngalangala. ");
INSERT INTO nyy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Po Johani alɨnkwenda ntwaja toosa ʉtʉ twalɨ kɨfuki nʉ lwɨsi Jolitani. Aalʉmbɨlɨlaga ʉkʉtɨ abandʉ bapɨndʉke, boosigwe, po Kyala ikʉbahobokela ʉbʉtʉlanongwa bwabo. ");
INSERT INTO nyy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ɨsyo siboniike syo ɨsi syasimbiigwe liijolo mwa kalata gwa nkunguluka Jeesaja ʉkʉtɨ, “Ɨliisyʉ lya mundʉ likʉkoolela ndʉngalangala likʉtɨ, ‘Mutendekesye ʉnsebo ʉgwa kwendamo ʉNtwa! Mugolosye ɨnjɨla syake! ");
INSERT INTO nyy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kʉkʉtɨ lʉsooko lʉsyɨligwe, kʉkʉtɨ kyamba nʉ twamba fitelamikigwege. Apa paniongeele pagolosigwege, apa pakaja kanunu pagwasigwege. ");
INSERT INTO nyy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Po abandʉ boosa bikʉbʉbona ʉbʉpoki bwa Kyala.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Abandʉ bingi bankongaga Johani kʉkoosigwa. Alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉmwe mwe baa ndʉjungu lwa njoka! Bʉle, mukʉtɨ mubagiile ʉkʉpona ʉlʉfundo lwa Kyala lɨnga mukʉpɨndʉka kʉ bʉsyobi? ");
INSERT INTO nyy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Po munangɨsye ɨseke ɨsi sikʉnangɨsya ʉkʉtɨ mupɨndwike. Muleke ʉkwinogona ʉkʉtɨ, ‘Ʉswe taata jo Abulahamu.’ Nikʉbabʉʉla, Kyala abagiile ʉkʉgapela amabwe aga ʉkʉja baana baa Abulahamu! ");
INSERT INTO nyy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ʉlʉ ʉbʉlongi bwa Kyala bʉfikile, bo ʉlwa mundʉ ʉjʉ akolile ɨndwanga, iitendekiisye ʉkʉtumula ɨmipiki. Po ʉmpiki ʉgʉ gʉtikʉpa ɨseke ɨnunu, gukʉtumuligwaga nʉ kʉsopigwa mmooto.” ");
INSERT INTO nyy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Po ɨkɨlʉndɨlo kya bandʉ balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Ʉlʉ po tʉtɨ fiki?” ");
INSERT INTO nyy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Johani alɨnkʉbaamula alɨnkʉtɨ, “Ʉjʉ alɨ nɨ myenda mibɨlɨ annjabɨle ʉjʉ akaja nɨ myenda, joope ʉjʉ alɨ nɨ findʉ annjabɨle ʉjʉ akaja nɨ findʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Abasongesya songo boope baabʉʉkile ʉkʉtɨ boosigwe, balɨnkʉnndaalʉʉsya Johani balɨnkʉtɨ, “Gwe Mmanyisi, na ʉswe tʉtɨ fiki?” ");
INSERT INTO nyy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Alɨnkʉbaamula alɨnkʉtɨ, “Muleke ʉkʉsongesya ɨsongo ʉkʉkɨnda ɨkɨpɨmo ɨkɨ kɨbɨɨkiigwe.” ");
INSERT INTO nyy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Boope abasikali balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Na ʉswe tʉtɨ fiki?” Alɨnkʉbabʉʉla alɨnkʉtɨ, “Muleke ʉkwega ɨndalama sya bandʉ kʉ maka, mulɨngasitaakaga abandʉ ɨsya bʉtʉngʉlʉ, looli mufwanege nʉ mfwalo gwɨnu.” ");
INSERT INTO nyy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Akabalɨlo ako abandʉ baaguulɨlaga ʉkwisa kwa Meesija, boosa biinogonaga ʉkʉtɨ pamo Johani jo Meesija. ");
INSERT INTO nyy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Looli Johani bo asyageenie ɨsyo, alɨnkʉbaamula boosa alɨnkʉtɨ, “Ʉne ngʉboosya na mɨɨsi, looli ikwisa ʉjʉ alɨ na maka ʉkʉngɨnda ʉne, ngabagɨsya nʉ kwabʉla ʉtʉkoba ʉtwa filato fyake. Ʉmwene jo ʉjʉ ikʉboosyaga na Mbepo Mwikemo nʉ mooto. ");
INSERT INTO nyy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Afwene nʉ mundʉ ʉjʉ akolile mmaboko ɨkya kʉlʉlʉʉkɨsya, iitendekiisye ʉkʉlʉlʉʉsya. Bo alʉlʉʉsiisye, ikʉbʉngaania mu ndamba, looli ɨmikʉkʉʉjɨlo ikʉgɨkosya nʉ mooto ʉgʉ gʉtikʉsima sikʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kʉ masyʉ ago na gangɨ amingi, Johani aabasokaga abandʉ nʉ kʉbalʉmbɨlɨla ɨNdʉmi ɨNunu ɨjaa Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Akabalɨlo akangɨ Johani alɨnkʉnkemela ʉmalafyale Heloti, paapo Heloti aalɨmmwegile Helotija ʉnkasi gwa gwamyabo, na kʉ mbiibi nyingi ɨsi aabombile. ");
INSERT INTO nyy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Po Heloti alɨnkongelapo ʉbʉbiibi, alɨnkʉmpinya Johani mu nnyololo. ");
INSERT INTO nyy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Abandʉ bingi bo bikoosigwa, joope Jesu alɨnkoosigwa. Bo ikwipuuta, kʉmwanya kʉlɨnkwigʉka, ");
INSERT INTO nyy_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Mbepo Mwikemo alɨnkʉsuluka pamwanya pamyake, nʉ mbɨlɨ bo ʉgwa ngʉnde. Ɨliisyʉ lya Kyala ʉkʉfuma kʉmwanya, lɨlɨnkʉtɨ, “Ʉgwe gwe Mwanangʉ ʉNkʉndwe, gwe niikyeliile na nungwe.” ");
INSERT INTO nyy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu bo ikwanda ɨmbombo jaake, aalɨ nɨ fyɨnja amalongo matatʉ bʉno. Abandʉ biinogonaga ʉkʉtɨ Jesu aalɨ mwana gwa Joosefu, Joosefu aalɨ mwana gwa Eli, ");
INSERT INTO nyy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli aalɨ mwana gwa Matati, Matati aalɨ mwana gwa Leebi, Leebi aalɨ mwana gwa Meliki, Meliki aalɨ mwana gwa Jana, Jana aalɨ mwana gwa Joosefu, ");
INSERT INTO nyy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joosefu aalɨ mwana gwa Matatija, Matatija aalɨ mwana gwa Aamosi, Aamosi aalɨ mwana gwa Nahumu, Nahumu aalɨ mwana gwa Esili, Esili aalɨ mwana gwa Nagaji, ");
INSERT INTO nyy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaji aalɨ mwana gwa Maati, Maati aalɨ mwana gwa Matatija, Matatija aalɨ mwana gwa Semeji, Semeji aalɨ mwana gwa Joseki, Joseki aalɨ mwana gwa Jota, ");
INSERT INTO nyy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jota aalɨ mwana gwa Jwanani, Jwanani aalɨ mwana gwa Lesa, Lesa aalɨ mwana gwa Selubabeli, Selubabeli aalɨ mwana gwa Salatyeli, Salatyeli aalɨ mwana gwa Neli, ");
INSERT INTO nyy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli aalɨ mwana gwa Meliki, Meliki aalɨ mwana gwa Andi, Andi aalɨ mwana gwa Kosamu, Kosamu aalɨ mwana gwa Elimatamu, Elimatamu aalɨ mwana gwa Eli, ");
INSERT INTO nyy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eli aalɨ mwana gwa Jooswa, Jooswa aalɨ mwana gwa Elieseli, Elieseli aalɨ mwana gwa Jolimu, Jolimu aalɨ mwana gwa Matati, Matati aalɨ mwana gwa Leebi, ");
INSERT INTO nyy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leebi aalɨ mwana gwa Simyoni, Simyoni aalɨ mwana gwa Juuta, Juuta aalɨ mwana gwa Joosefu, Joosefu aalɨ mwana gwa Jonamu, Jonamu aalɨ mwana gwa Elyakimu, ");
INSERT INTO nyy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakimu aalɨ mwana gwa Meleja, Meleja aalɨ mwana gwa Mena, Mena aalɨ mwana gwa Matata, Matata aalɨ mwana gwa Natani, Natani aalɨ mwana gwa Ndaabɨti, ");
INSERT INTO nyy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ndaabɨti aalɨ mwana gwa Jese, Jese aalɨ mwana gwa Obeti, Obeti aalɨ mwana gwa Boasi, Boasi aalɨ mwana gwa Salimoni, Salimoni aalɨ mwana gwa Nasoni, ");
INSERT INTO nyy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoni aalɨ mwana gwa Aminatabu, Aminatabu aalɨ mwana gwa Andimini, Andimini aalɨ mwana gwa Esoloni, Esoloni aalɨ mwana gwa Pelesi, Pelesi aalɨ mwana gwa Juuta, ");
INSERT INTO nyy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juuta aalɨ mwana gwa Jaakobo, Jaakobo aalɨ mwana gwa Isaka, Isaka aalɨ mwana gwa Abulahamu, Abulahamu aalɨ mwana gwa Tela, Tela aalɨ mwana gwa Naholi, ");
INSERT INTO nyy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naholi aalɨ mwana gwa Selʉgi, Selʉgi aalɨ mwana gwa Lagau, Lagau aalɨ mwana gwa Pelegi, Pelegi aalɨ mwana gwa Ebeli, Ebeli aalɨ mwana gwa Sala, ");
INSERT INTO nyy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala aalɨ mwana gwa Kenani, Kenani aalɨ mwana gwa Alipakisati, Alipakisati aalɨ mwana gwa Semu, Semu aalɨ mwana gwa Nwaka, Nwaka aalɨ mwana gwa Lameki, ");
INSERT INTO nyy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki aalɨ mwana gwa Metusela, Metusela aalɨ mwana gwa Enoki, Enoki aalɨ mwana gwa Jaleti, Jaleti aalɨ mwana gwa Mahalaleli, Mahalaleli aalɨ mwana gwa Kenani, ");
INSERT INTO nyy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenani aalɨ mwana gwa Enosi, Enosi aalɨ mwana gwa Seti, Seti aalɨ mwana gwa Atamu, Atamu aalɨ mwana gwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu bo iiswile Mbepo Mwikemo alɨnkʉsookako kʉ lwɨsi Jolitani, alɨnkʉlongosigwa na Mbepo Mwikemo ʉkʉbʉʉka ndʉngalangala. ");
INSERT INTO nyy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ʉko Jesu aageligwaga na Seetano amasikʉ amalongo mana. Amasikʉ ago aafipɨɨkile ɨfindʉ. Bo gamaliike ɨnjala jɨlɨnkʉnndʉma. ");
INSERT INTO nyy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Po Seetano alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Lɨnga ʉgwe ʉlɨ Mwana gwa Kyala, lɨbʉʉle iibwe ɨlɨ lɨsanuke ʉkʉja kɨsyesye.” ");
INSERT INTO nyy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ʉkʉlya fyene ɨfindʉ ʉmundʉ akabagɨla ʉkʉja mʉʉmi.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Po Seetano alɨnkʉntwala Jesu apa piinwike fiijo, nakalɨnga alɨnkʉnnangɨsya ɨfiisʉ fyosa ɨfya pakiisʉ. ");
INSERT INTO nyy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Seetano alɨnkʉtɨ, “Nikʉkʉpa ʉkʉja malafyale gwa fiisʉ fyosa ɨfyo, pamopeene nʉ bʉsisya bwake, paapo mbeeliigwe ʉbʉnyafyale bwa fiisʉ fyosa ɨfyo, ʉne ngʉmpapo ʉmundʉ gwesa kʉ bwigane bwangʉ. ");
INSERT INTO nyy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Lɨnga kʉfugama nʉ kʉʉnyiipuuta, fyosa fikʉjaga fyako.” ");
INSERT INTO nyy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Mwa Kalata ʉMwikemo sisimbiigwe ʉkʉtɨ, ‘Ʉmmwipuutege ʉNtwa Kyala gwako. Kangɨ ʉmmbombelege mwene itolo.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Po Seetano alɨnkʉnndongosya Jesu mpaka kʉ Jelusalemu, alɨnkʉmmbɨɨka ndʉpaso lwa tempeli apa palɨ pamwanya fiijo, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Lɨnga ʉgwe ʉlɨ Mwana gwa Kyala, isope paasi. ");
INSERT INTO nyy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ʉtikʉfulala, paapo sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Kyala ikʉbatʉma abandʉmi baake kʉnongwa jaako, bakʉlɨndɨlɨle. ");
INSERT INTO nyy_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bikʉkʉpɨmba mmaboko gaabo, ʉkʉtɨ ʉngafulala ɨkɨlʉndɨ kyako pi ibwe.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Kalata ʉMwikemo ikʉtɨ, ‘Ʉlɨnganngelaga ʉNtwa Kyala gwako.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seetano bo amalile ʉkʉnngela Jesu kʉ njɨla syosa, alɨnkʉnndeka kʉkabalɨlo. ");
INSERT INTO nyy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Po Jesu alɨnkʉbʉʉka nkiisʉ ɨkya Galilai, aalongosigwaga na Mbepo Mwikemo. Ɨnongwa syake silɨnkʉbalanila ntwaja toosa. ");
INSERT INTO nyy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ʉmwene aamanyisyaga mu sinagogi syabo, na bandʉ boosa aba baalɨmpɨliike bantuufyaga. ");
INSERT INTO nyy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Po Jesu alɨnkʉfika kʉ Nasaleti, nkaaja aka aakʉliile. Pi isikʉ ɨlya pa Sabati alɨnkwingɨla mu sinagogi bo muno lwajɨɨliile ʉlwiho lwake. Alɨnkwɨma ʉkʉtɨ abale Kalata ʉMwikemo. ");
INSERT INTO nyy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Balɨnkʉmpa kalata ʉgwa nkunguluka Jeesaja, alɨnkʉbaalʉla, alɨnkʉpaaga apa mwa Kalata ʉMwikemo pasimbiigwe ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mbepo gwa Ntwa ikʉʉndongosya, paapo Kyala aasʉngwile ʉkʉbalʉmbɨlɨla abalondo ɨNdʉmi ɨNunu. Andʉmile ʉkʉbafumukɨsya aba balɨ mu nnyololo, ɨndʉmi jaa kwabʉligwa kwabo, na bafwa maaso ʉkʉkeeta kangɨ. Andʉmile ʉkʉbaabʉla aba baboneliigwe, ");
INSERT INTO nyy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kangɨ ʉkʉfumusya akabalɨlo aka ʉNtwa ikwisa kʉkʉbasaja.” ");
INSERT INTO nyy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bo amalile ʉkʉbala, alɨnkʉkupɨkɨla kalata jʉla, alɨnkʉnngomokesya ʉmbombeli ʉgwa mu sinagogi, alɨnkʉtʉʉgala ʉkwanda ʉkʉmanyisya. Abandʉ boosa aba baalimo mula balɨnkʉnndʉʉsamila. ");
INSERT INTO nyy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Po alɨnkʉbabʉʉla alɨnkʉtɨ, “Mupɨliike amasyʉ ago agaa Kalata ʉMwikemo aga mbalile, siboniike ʉmwisyʉgʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Boosa balɨnkʉnnjoba kanunu, balɨnkʉswiga amasyʉ agaa ipyana aga ajobile, balɨnkʉtɨ, “Bʉle, ʉjʉ akaja jo mwana gwa Joosefu?” ");
INSERT INTO nyy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Po joope alɨnkʉbabʉʉla alɨnkʉtɨ, “Mmeenye, mukʉja pakʉjoba ɨsya mbʉpɨngamu ɨsi sikʉtɨ, ‘Gwe nganga, ibʉmbʉlʉsye! Ɨmbombo ɨsi tʉsipɨliike ʉkʉtɨ ʉsibombile mu Kapelinaʉmu, ʉsibombe na papaapa nkɨpanga kyako ɨkɨ.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Alɨnkongelapo ʉkʉjoba alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, akajako ʉnkunguluka ʉjʉ ikwambɨlɨligwa nkaaja kaake. ");
INSERT INTO nyy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mmasikʉ gaa nkunguluka Elija, ɨfula jɨkaatimile ɨfyɨnja fitatʉ nɨ myesi ntandatʉ, ɨnjala ɨnywamu jaaliisile nkiisʉ kyosa ɨkya Isilaɨli. Nalooli nikʉbabʉʉla, akabalɨlo ako baalipo abafwɨle bingi nkiisʉ ɨkɨ, ");
INSERT INTO nyy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","leelo Elija akaatʉmiigwe kʉlɨ jʉmo mbafwɨle bala abaa nkiisʉ kya Isilaɨli, looli aatʉmiigwe kʉ mfwɨle gwa nkɨpanga kya Salepati kɨfuki na mu Sitoni. ");
INSERT INTO nyy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kangɨ mmasikʉ gaa nkunguluka Elisa, baalipo abandʉ bingi aba baalɨ nʉ bʉkoma nkiisʉ kya Isilaɨli. Leelo akaalyelʉsiigwe najʉmo, looli Elisa aalɨmmbʉmbʉlwisye Naamani mwene ʉjʉ aafumile nkiisʉ kya Silija!” ");
INSERT INTO nyy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Po abandʉ boosa aba baalɨ mu sinagogi, bo bapɨliike amasyʉ ago, baakaleele fiijo. ");
INSERT INTO nyy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Balɨnkwɨma, balɨnkʉnsoosyamo kʉ maka nkɨpanga kyabo, ɨkɨ kyalɨ pamwanya pa kyamba. Balɨnkʉntwala kʉ lʉpanga ʉlwa kyamba ʉkʉtɨ banngutɨle paasi. ");
INSERT INTO nyy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Leelo ʉmwene aalyendile pakatɨ pamyabo, alɨnkʉsookapo. ");
INSERT INTO nyy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Po Jesu alɨnkʉbʉʉka kʉ Kapelinaʉmu, akaaja akaa nkiisʉ ɨkya Galilai. Pi isikʉ ɨlya pa Sabati aalingiile mu sinagogi, alɨnkʉbamanyisya abandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Balɨnkʉswiga fiijo ɨmanyisyo syake, paapo syalɨ manyisyo sya maka, aamanyisyaga ngatɨ mundʉ ʉndagɨli. ");
INSERT INTO nyy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mu sinagogi mula aalimo ʉmundʉ ʉjʉ aalɨ nɨ mbepo ɨnyali, jɨlɨnkʉlaata fiijo, ");
INSERT INTO nyy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","jɨlɨnkʉtɨ, “Gwe Jesu, gwe gwa mu Nasaleti, kʉlonda ɨfiki kʉmyɨtʉ? Bʉle, gwisile kʉkʉtʉpyuta? Ngʉmeenye ʉkʉtɨ ʉgwe gwe gwani. Ʉlɨ Mwikemo gwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesu alɨnkʉjɨkemela ɨmbepo ɨnyali jɨla alɨnkʉtɨ, “Myeka! Sookamo mmundʉ ʉjʉ!” Po ɨmbepo ɨnyali jɨla jɨlɨnkʉnngwɨsya pakatɨ pamyabo, jɨlɨnkʉsooka kɨsita kʉmfulasya. ");
INSERT INTO nyy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Abandʉ boosa balɨnkʉswiga fiijo, balɨnkʉjobesania balɨnkʉtɨ, “Tʉkasibonamo bo ɨsi! Ʉmundʉ ʉjʉ ikʉsikaga ɨmbepo ɨnyali kʉ bʉlagɨli na kʉ maka gaake, po syope sikʉsooka!” ");
INSERT INTO nyy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ɨnongwa sya Jesu silɨnkʉbalanila nkiisʉ kɨla kyosa. ");
INSERT INTO nyy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesu alɨnkʉsookamo mu sinagogi, alɨnkwingɨla mu nyumba ɨjaa Simoni. Ʉnna gwa nkasi gwa Simoni aakoliigwe fiijo nɨ sekema, balɨnkʉnsʉʉma Jesu ʉkʉtɨ ammbʉmbʉlʉsye. ");
INSERT INTO nyy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Po alɨnkwɨma kɨfuki nʉ mbine, alɨnkʉjɨkemela ɨsekema jɨla, jɨlɨnkʉsookamo. Nakalɨnga ʉnkiikʉlʉ jʉla alɨnkʉsumuka, alɨnkwɨma nʉ kwanda ʉkʉmmbombela Jesu na bafundigwa baake. ");
INSERT INTO nyy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Iisʉba bo likʉjonga, abandʉ boosa balɨnkʉntwalɨla Jesu abandʉ bingi aba baalɨ nʉ bʉbine ʉbwa lʉko nʉ lʉko. Ʉmwene alɨnkʉbɨɨka amaboko gaake pamwanya pa kʉkʉtɨ mbine, alɨnkʉbabʉmbʉlʉsya. ");
INSERT INTO nyy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kangɨ ɨmbepo ɨnyali syasookaga mmbandʉ bingi, kʉno syajwegaga syatɨgɨ, “Ʉgwe ʉlɨ Mwana gwa Kyala!” Jesu aasikemelaga nʉ kʉsibʉʉla ʉkʉtɨ silɨngajobaga, paapo syalɨmmeenye ʉkʉtɨ jo Meesija. ");
INSERT INTO nyy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bo kʉkiile, Jesu alɨnkʉsookamo nkaaja kala, alɨnkʉbʉʉka pabʉjo bʉmo ʉbʉ bakajapo abandʉ. Ɨkɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ balɨnkʉnndonda, kʉbʉʉbo balɨnkʉfika apa aalipo. Baagelile ʉkʉnsigɨla ʉkʉtɨ alɨngasookapo. ");
INSERT INTO nyy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Looli ʉmwene Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Ngʉlondigwa ʉkʉfumusya ɨNdʉmi ɨNunu ɨjaa Bʉnyafyale bwa Kyala ntwaja ʉtʉngɨ toope. Jo nongwa ɨjɨ naatʉmiigwe.” ");
INSERT INTO nyy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Po Jesu aalʉmbɨlɨlaga mu sinagogi ɨsya nkiisʉ ɨkyo. ");
INSERT INTO nyy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ɨliisikʉ lɨmo Jesu aalyɨmile kʉmbalɨ kwa sʉmbɨ Genesaleti. Abandʉ bingi baapapateene ʉkʉtɨ bapɨlɨkɨsye iisyʉ lya Kyala kʉmyake. ");
INSERT INTO nyy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kʉmbalɨ kwa sʉmbɨ, Jesu alɨnkʉgabona amabooti mabɨlɨ. Abalobi bakaalimo, paapo baasukaga ɨnyeelo syabo. ");
INSERT INTO nyy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesu alɨnkwingɨla mwi ibooti lɨmo, ɨlɨ lyalɨ lya Simoni. Alɨnkʉnsʉʉma Simoni ʉkʉtɨ alɨsemekesye panandɨ nkatɨ mwa sʉmbɨ. Po Jesu alɨnkʉtʉʉgala mwi ibooti alɨnkʉmanyisya ɨkɨlʉndɨlo kɨla ɨkya bandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bo amalile ʉkʉmanyisya, alɨnkʉmmbʉʉla Simoni alɨnkʉtɨ, “Ʉbʉʉke pakatɨ pa nyanja, mukataagɨle ɨnyeelo syɨnu, mulobe ɨɨswɨ.” ");
INSERT INTO nyy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni alɨnkʉmmwamula Jesu alɨnkʉtɨ, “Gwe Ntwa, tʉbombile ɨmbombo ɨngafu ɨkɨlo kyosa, tʉkakabapo nakamo, po tʉkabagɨla ʉkʉkaba simo pamuusi. Looli paapo ʉjobile ʉgwe, tukʉtaagɨla ɨnyeelo.” ");
INSERT INTO nyy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bo bataagiile ɨnyeelo, baalobile ɨɨswɨ ɨnyingi fiijo, ɨnyeelo syabo silɨnkwanda ʉkʉnyaafuka. ");
INSERT INTO nyy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Po balɨnkʉbakoopa abiinaabo aba baalɨ mwi ibooti ɨlɨngɨ, ʉkʉtɨ biise kʉkʉbatʉʉla. Balɨnkwisa, balɨnkwisʉsya ɨɨswɨ amabooti gomabɨɨlɨ, na mabooti galɨnkwanda ʉkwibɨla. ");
INSERT INTO nyy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni ʉjʉ ɨngamu ɨjɨngɨ aalɨ jo Peeteli, bo asibwene ɨsyo, alɨnkʉfugama nkyeni mwa Jesu alɨnkʉtɨ, “Gwe Ntwa, sookapo apa ndipo, paapo ʉne ndɨ ntʉlanongwa!” ");
INSERT INTO nyy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ʉmwene na bangɨ boosa aba baalɨ pamopeene nagwe, baaswigile fiijo kʉnongwa jaa nswɨ ɨnyingi ɨsi baalobile. ");
INSERT INTO nyy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Boope baa Jaakobo na Johani, abanya Sebetai, aba baalɨ balobi banine baa Simoni, baaswigile fiijo. Po Jesu alɨnkʉmmbʉʉla Simoni alɨnkʉtɨ, “Ʉlɨngatiilaga, ʉkwandɨla akabalɨlo aka, kʉlobaga abandʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Po baagabɨɨkile amabooti gaabo pi isɨɨlya, balɨnkʉfileka fyosa, balɨnkʉnkonga Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ɨliisikʉ lɨmo Jesu bo alɨ nkaaja kamo, aalipo ʉmundʉ ʉgwa bʉkoma ʉmbɨlɨ goosa. Bo ammbwene Jesu, alɨnkʉfugama nʉ kwinama mpaka paasi nkyeni mmyake, alɨnkʉlamba alɨnkʉtɨ, “Gwe Ntwa, lɨnga gwiganile ʉkʉmbalamaasya, ʉbagiile ʉkʉʉnyeelʉsya.” ");
INSERT INTO nyy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesu alɨnkʉgolosya ɨkɨboko kyake, alɨnkʉmpalamaasya, alɨnkʉtɨ, “Niiganile, elʉkaga.” Nakalɨnga ʉbʉkoma bʉlɨnkʉsookamo mu mbɨlɨ gwake. ");
INSERT INTO nyy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Alɨnkʉnkaanisya ʉmundʉ jʉla alɨnkʉtɨ, “Ʉlɨngammbʉʉlaga ʉmundʉ najʉmo ɨnongwa ɨsi! Looli ʉbʉʉke ʉkiinangɨsye kʉ mpuuti. Kangɨ ʉtwale iikemo lya kwelʉsigwa kʉ tempeli, ʉkʉnangɨsya ʉkʉtɨ ʉbʉmbʉlwike, bo muno sikʉlagɨla ɨndagɨlo sya Moose.” ");
INSERT INTO nyy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Poope ɨnongwa sya Jesu silɨnkongelapo ʉkʉbalanila. Po abandʉ bingi baabʉngaanaga ʉkʉmpɨlɨkɨsya nʉ kʉbʉmbʉlʉsigwa ʉbʉbine bwabo. ");
INSERT INTO nyy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Po ʉmwene aasookangapo, aabʉʉkaga pabʉjo ʉbʉ bʉkaja na bandʉ, ʉkʉtɨ iipuute. ");
INSERT INTO nyy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ɨliisikʉ lɨmo Jesu aalɨ mu nyumba jɨmo, aamanyisyaga abandʉ. ABafalisai na bamanyisi baa ndagɨlo sya Moose ʉkʉfuma ntwaja toosa ʉtwa Galilai nʉ twa Jutai, na nkaaja akanywamu akaa Jelusalemu, baatʉʉgeele apo. Amaka gaa Ntwa Kyala gaalɨ nagwe ʉkʉbʉmbʉlʉsya ababine. ");
INSERT INTO nyy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Po balɨnkwisa abandʉ bamo, baalɨmpɨmbile pa bʉlɨlɨ ʉmundʉ ʉjʉ aalalile. Balɨnkʉlonda ʉkʉmmwingɨsya nnyumba ʉkʉtɨ bammbɨɨke nkyeni mwa Jesu, ammbʉmbʉlʉsye. ");
INSERT INTO nyy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Leelo baatoliigwe ʉkʉmmwingɨsya ʉmbine jʉla nnyumba kʉnongwa jaa kɨlʉndɨlo kya bandʉ. Po balɨnkʉbʉʉka pamwanya pa nyumba, balɨnkʉpangʉla, balɨnkʉnsulusya mpaka apa Jesu aalipo. ");
INSERT INTO nyy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesu bo alʉbwene ʉlwitɨko lwabo, alɨnkʉmmbʉʉla ʉmbine jʉla, alɨnkʉtɨ, “Mmanyaani, ʉhobokeliigwe ʉbʉtʉlanongwa bwako.” ");
INSERT INTO nyy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Po abamanyisi baa ndagɨlo sya Moose na Bafalisai bala balɨnkwanda ʉkwinogona mu ndumbula syabo, balɨnkʉtɨ, “Jo jwani ʉjʉ? Ikʉntʉka Kyala! Akajako ʉmundʉ ʉjʉ abagiile ʉkʉhobokela ʉbʉtʉlanongwa, looli jo Kyala mwene!” ");
INSERT INTO nyy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Looli Jesu alɨnkʉsimanya syosa ɨsi biinogonaga, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Fiki mukwinogona bo ʉlo mu ndumbula syɨnu? ");
INSERT INTO nyy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Lɨlɨkʉ ipepe, ʉkʉmmbʉʉla ʉkʉtɨ, ‘Ʉhobokeliigwe ʉbʉtʉlanongwa bwako,’ pamo ʉkʉtɨ, ‘Sumuka, gwendege?’ ");
INSERT INTO nyy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Po musyaganiege ʉkʉtɨ ʉne ne Nnyamundʉ, ndɨ na maka agaa kʉhobokela ʉbʉtʉlanongwa nkiisʉ muno...” Po alɨnkʉmmbʉʉla ʉjʉ aalalile alɨnkʉtɨ, “Nikʉkʉbʉʉla, sumuka, pɨmba ʉbʉlɨlɨ bwako, bʉʉkaga kʉkaaja kaako.” ");
INSERT INTO nyy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nakalɨnga ʉmundʉ jʉla alɨnkʉsumuka nkyeni mmyabo, alɨnkʉpɨmba ʉbʉlɨlɨ ʉbʉ aalambaleelepo, alɨnkʉbʉʉka kʉkaaja kaake, kʉno ikʉntuufya Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Boosa balɨnkʉswiga, balɨnkʉntuufya Kyala, balɨnkʉja nʉ lʉtende, balɨnkʉtɨ, “Lɨɨlɨno tʉsibwene ɨsya kʉswigɨsya.” ");
INSERT INTO nyy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Piitaasi Jesu aasookile mu nyumba jɨla, alɨnkʉmmbona ʉnsongesya songo jʉmo, ɨngamu jaake Leebi, aatʉʉgeesye apa bikʉsongesya ɨsongo. Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉngongege.” ");
INSERT INTO nyy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leebi alɨnkʉfileka fyosa, alɨnkʉsookapo, alɨnkʉnkonga Jesu ʉkʉfuma akabalɨlo kala. ");
INSERT INTO nyy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leebi alɨnkʉntendekekesya Jesu ɨfindʉ fya lʉsekelo ʉlʉnywamu nnyumba jaake. Kangɨ kyalipo nɨ kɨlʉndɨlo ɨkɨnywamu ɨkya basongesya songo na bandʉ abangɨ aba baalyaga pamopeene nabo. ");
INSERT INTO nyy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Po aBafalisai na bamanyisi baabo abaa ndagɨlo sya Moose, bʉʉmanaga na bafundigwa baa Jesu, balɨnkʉtɨ, “Fiki mukʉlya nʉ kʉnwa pamopeene na basongesya songo na batʉlanongwa?” ");
INSERT INTO nyy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Abakafu batikʉnndonda ʉnganga, looli beene ababine! ");
INSERT INTO nyy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngiisa kʉkʉbakoolela abagolofu, looli niisile kʉkʉbakoolela abatʉlanongwa, ʉkʉtɨ bapɨndʉke.” ");
INSERT INTO nyy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Po balɨnkʉjoba kwa Jesu balɨnkʉtɨ, “Abafundigwa baa Johani ʉMoosi bikʉfipɨɨka ɨfindʉ kaa kingi nʉ kwipuuta, boope aBafalisai. Keeta abafundigwa baako bikʉlya nʉ kʉnwa amasikʉ goosa?” ");
INSERT INTO nyy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Leelo Jesu alɨnkʉbaamula alɨnkʉtɨ, “Kalɨ mubagiile ʉkʉbapinya ʉkʉtɨ bafipɨɨke ɨfindʉ aba bapaaliigwe pa bwegi, bo ʉmwega nkiikʉlʉ alɨ pamopeene nabo? ");
INSERT INTO nyy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Looli amasikʉ aga gikwisa, abandʉ bikwisa kʉnsoosyapo ʉmwega nkiikʉlʉ pakatɨ pa baheesya baake. Po bikwisa kʉfipɨɨkaga ɨfindʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Alɨnkʉbabʉʉla mfifwanikɨsyo alɨnkʉtɨ, “Akajako ʉmundʉ ʉjʉ ikʉnyaafula ɨkɨgamba ɨkya mmwenda ʉmpya nʉ kʉsonelapo pa mwenda ʉnkʉʉlʉ. Lɨnga abombile bo ʉlo, bo anyaafwile ʉmwenda ʉmpya, nɨ kɨgamba ɨkya mwenda ʉmpya kɨtikʉbagɨsya nʉ mwenda ʉnkʉʉlʉ. ");
INSERT INTO nyy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kangɨ akajapo ʉmundʉ ʉjʉ ikʉkʉʉsya ɨfinga ɨmbya mfinyambɨ ɨfikʉʉlʉ. Paapo lɨnga abombile bo ʉlo, ɨfinyambɨ fikʉnyaafuka, ɨfinga jikooneka, nɨ finyambɨ fikoonangɨka. ");
INSERT INTO nyy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Looli abandʉ bikʉbɨɨka ɨfinga ɨmbya mfinyambɨ ɨfipya. ");
INSERT INTO nyy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kangɨ akajapo ʉmundʉ ʉjʉ anwile ɨfinga ɨngʉʉlʉ, ʉkʉtɨ anyonywe ɨfinga ɨmbya, paapo ikʉtɨ, ‘Ɨngʉʉlʉ jo nunu.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pi isikʉ lɨmo ɨlya pa Sabati, Jesu na bafundigwa baake bendaga mmigʉnda. Abafundigwa baake balɨnkwanda ʉkʉpʉlʉla ɨfisaasali nʉ kʉfigisa mmaboko nʉ kʉlya. ");
INSERT INTO nyy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Po aBafalisai bamo balɨnkʉnndaalʉʉsya Jesu balɨnkʉtɨ, “Fiki mukʉpʉlʉla? Silɨ mwiko pi isikʉ ɨlya pa Sabati!” ");
INSERT INTO nyy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Bʉle, mukabalamo Kalata ʉMwikemo ɨsi aabombile ʉmalafyale Ndaabɨti na banine bo balɨ nɨ njala? ");
INSERT INTO nyy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aalingiile mu nyumba jaa Kyala, aalyegile ɨfisyesye ɨfiikemo ɨfi baaliitɨkɨsiigwe ʉkʉlya beene abapuuti, aaliile, aabapeele na banine aba aalɨ nabo.” ");
INSERT INTO nyy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Nnyamundʉ jo Ntwa gwa Sabati.” ");
INSERT INTO nyy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ɨliisikʉ ɨlɨngɨ ɨlya pa Sabati, Jesu alɨnkwingɨla mu sinagogi, alɨnkʉmanyisya. Nkatɨ mula, aalimo ʉmundʉ jʉmo ʉjʉ ɨkɨboko kyake ɨkya kʉ kiilɨɨlo kyalalile. ");
INSERT INTO nyy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Abamanyisi baa ndagɨlo sya Moose na Bafalisai balɨnkʉntegelela Jesu, ʉkʉtɨ bammbone lɨnga ikʉmmbʉmbʉlʉsya ʉmundʉ pi isikʉ ɨlya pa Sabati, ʉkʉtɨ basyage simo ɨsya kʉnsitaaka. ");
INSERT INTO nyy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Looli Jesu alɨnkʉsimanya ɨnyiinogono syabo, alɨnkʉmmbʉʉla jʉla ʉgwa kɨboko ɨkɨ kɨlalile, alɨnkʉtɨ, “Sumuka, gwɨme pakatɨ!” Alɨnkʉsumuka nʉ kwɨma. ");
INSERT INTO nyy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Po Jesu alɨnkʉbaamula alɨnkʉtɨ, “Nikʉbalaalʉʉsya ʉmwe ʉkʉtɨ, bʉle, siitɨkɨsiigwe ʉkʉbomba ɨnunu pamo ɨmbiibi pi isikʉ ɨlya pa Sabati? Ʉkʉpoka ʉbʉʉmi pamo ʉkʉboonanga?” ");
INSERT INTO nyy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesu alɨnkʉbalʉʉsamila boosa, alɨnkʉmmbʉʉla ʉmundʉ jʉla alɨnkʉtɨ, “Golosya ɨkɨboko kyako.” Alɨnkʉkɨgolosya ɨkɨboko kyake, kɨlɨnkʉbʉmbʉlʉka, kɨlɨnkʉja kɨkafu. ");
INSERT INTO nyy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Baakaleele fiijo, balɨnkʉjobesania ʉkʉtɨ bammbombele bʉleebʉle Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ɨliisikʉ lɨmo, Jesu alɨnkʉbʉʉka kʉ kyamba kʉkwipuuta, ʉko ko alɨnkʉsʉʉma kwa Kyala ɨkɨlo kyosa. ");
INSERT INTO nyy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nʉlʉbʉnjʉ, alɨnkʉbakoolela abafundigwa baake. Ndɨ abo alɨnkʉbasʉngʉla kalongo na babɨlɨ, alɨnkʉbabɨɨka ʉkʉja batʉmigwa. ");
INSERT INTO nyy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ɨngamu syabo baalɨ bo baa Simoni (ʉjʉ Jesu aalɨmpeele ɨngamu ɨjaa Peeteli) nʉ gwamyabo Andeleja, Jaakobo, Johani, Filipo, Balitolomai, ");
INSERT INTO nyy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matai, Tomasi, Jaakobo ʉmwana gwa Alifai, Simoni ʉndwɨla kiisʉ kyake, ");
INSERT INTO nyy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juuta ʉmwana gwa Jaakobo, na Juuta Isikalyoti ʉjʉ aalɨnndɨɨliile Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesu alɨnkʉsuluka ʉkʉfuma kʉ kyamba pamopeene na bafundigwa baake. Alɨnkwɨma pa bʉtelamu pamopeene na bafundigwa abingi nɨ kɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ, aba baafumile mu Jelusalemu na moosa nkiisʉ ɨkya mu Jutai. Bamo baafumile mu Tili na mu Sitoni, ʉtwaja ʉtwa kʉmbalɨ kʉ nyanja. ");
INSERT INTO nyy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Baaliisile kʉkʉmpɨlɨkɨsya Jesu nʉ kʉbʉmbʉlʉsigwa ʉbʉbine bwabo. Boope aba baataamigwaga nɨ mbepo ɨnyali, baabʉmbʉlʉsigwaga. ");
INSERT INTO nyy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ɨkɨlʉndɨlo kyosa ɨkya babine baalondaga ʉkʉmpalamaasya Jesu, paapo amaka gaafumaga mmyake, aababʉmbʉlʉsyaga boosa. ");
INSERT INTO nyy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesu alɨnkʉbakeeta abafundigwa baake, alɨnkʉbabʉʉla alɨnkʉtɨ, “Musajiigwe ʉmwe, mwe mulɨ balondo, paapo ʉBʉnyafyale bwa Kyala bwɨnu. ");
INSERT INTO nyy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Musajiigwe ʉmwe mwe mulɨ nɨ njala akabalɨlo aka, paapo Kyala ikwisa kʉbapela ʉkwikʉta. Musajiigwe ʉmwe mwe mukʉlɨla akabalɨlo aka, paapo mukwisa kʉsekaga. ");
INSERT INTO nyy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Musajiigwe ʉmwe mwe bikʉbabengaga abandʉ nʉ kʉbasambʉkɨla nʉ kʉbatʉka nʉ kʉbajoba ʉkʉtɨ mulɨ batʉlanongwa, kʉnongwa jangʉ ne Nnyamundʉ. ");
INSERT INTO nyy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Boope abiisʉkʉlʉ baabo, baababombelaga abakunguluka bo lʉlʉʉlo. Bo ɨsyo sikʉbombigwa, musekelege nʉ kʉkina akabalɨlo ako, paapo Kyala ababɨɨkiile ɨfihombigwa ɨfinywamu kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Looli ahɨɨli ʉmwe mwe mulɨ bakabi, paapo ʉlʉsekelo lwɨnu, mulɨ pakʉkaba. ");
INSERT INTO nyy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ahɨɨli ʉmwe mwe mwikwite akabalɨlo aka, paapo mukwisa kʉjaga nɨ njala. Ahɨɨli ʉmwe mwe mukʉseka akabalɨlo aka, paapo mukwisa kwilɨlɨɨsyaga nʉ kʉlɨla. ");
INSERT INTO nyy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ahɨɨli ʉmwe mwe abandʉ boosa bikʉbajoba kanunu, paapo abiisʉkʉlʉ baabo baababombelaga abakunguluka abaa bʉtʉngʉlʉ bo lʉlʉʉlo.” ");
INSERT INTO nyy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Looli nikʉbabʉʉla ʉmwe mwe mukʉpɨlɨka, mubaganege abalʉgʉ bɨɨnu. Aba bikʉbakalalɨla ʉmwe mubabombelege ɨnunu. ");
INSERT INTO nyy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aba bikʉbaguna ʉmwe, mubasʉʉmɨlege kwa Kyala ʉkʉtɨ abasaje. Aba bikʉbabonela ʉmwe, mubasʉʉmɨlege. ");
INSERT INTO nyy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Lɨnga ʉmundʉ akʉkomile ʉlʉsaja ʉlwa kʉ kiilɨɨlo, ʉnsanukɨsye nʉ lwa kʉ kiimama. Lɨnga ʉmundʉ ikʉpoka ikoti lyako, ʉlɨngasiitɨlaga ɨsyatɨ. ");
INSERT INTO nyy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Lɨnga jʉmo ikʉkʉsʉʉma fimo, ʉmpege. Ʉjʉ ikʉpoka ʉtʉndʉ twako, ʉlɨngalondaga ʉkʉkʉgomokesya. ");
INSERT INTO nyy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mubabombelege abangɨ bo muno mukʉlondela ʉkʉbombeligwa. ");
INSERT INTO nyy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Lɨnga mukʉbagana beene aba babaganile ʉmwe, mukʉnangɨsya ɨnunu silɨkʉ? Keeta boope abatʉlanongwa, bikʉbagana aba bikʉbagana abeene. ");
INSERT INTO nyy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Lɨnga ʉmwe mukʉbabombela ɨnunu aba bikʉbabombela ɨnunu, mukʉnangɨsya ɨnunu silɨkʉ? Keeta boope ababomba mbiibi bikʉbomba bo ʉlo. ");
INSERT INTO nyy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Lɨnga ʉmwe mukʉbakopesya aba mukʉsʉʉbɨla ʉkʉtɨ bikʉbahomba, mukʉnangɨsya ɨnunu silɨkʉ? Keeta boope ababomba mbiibi, bikʉbakopesya ababomba mbiibi biinaabo ʉkʉtɨ babahombe bo filafila. ");
INSERT INTO nyy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Looli ʉmwe mubaganege abalʉgʉ bɨɨnu, mubabombelege ɨnunu. Mubakopesyege kɨsita kʉsʉʉbɨla ʉkʉbagomokesya. Lɨnga mukʉbomba bo ʉlo, po ɨfihombigwa fyɨnu fikʉjaga finywamu, kangɨ mukʉjaga baana baa Kyala ʉNkʉlʉmba, paapo ʉmwene nnunu na kʉlɨ aba batikʉgwa ʉlʉpi kʉmyake, na kʉ batʉlanongwa. ");
INSERT INTO nyy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Po mujege nɨ kɨbabɨɨlɨsi bo ʉlwa Gwiseemwe ʉjʉ alɨ nɨ kɨbabɨɨlɨsi.” ");
INSERT INTO nyy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mulɨngalongaga, nuumwe mutikʉlongigwaga na Kyala. Mulɨngannjobaga najʉmo kabiibi nuumwe mutikʉjobigwaga. Muhobokelege abangɨ nuumwe mukʉhobokeligwaga. ");
INSERT INTO nyy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mubapege abandʉ nuumwe mukʉpeeligwaga, pa kɨpɨmo ɨkɨ kiiswile, kangɨ kɨkanyisiigwe nʉ kʉjʉgɨɨsigwa nʉ kʉsaata. Paapo ɨkɨpɨmo ɨkɨ mukʉbapɨmɨla abangɨ, kyo ɨkɨ Kyala ikwisa kʉbapɨmɨlaga nuumwe.” ");
INSERT INTO nyy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesu alɨnkʉbabʉʉla mfifwanikɨsyo alɨnkʉtɨ, “Kalɨ, ʉmfwa maaso abagiile ʉkʉnndongosya ʉmfwa maaso nnine? Batikʉgwɨla mbwina bobabɨɨlɨ? ");
INSERT INTO nyy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ʉmfundigwa atikʉnkɨnda ʉmmanyisi gwake, looli ʉjʉ amalile ʉkʉmanyila ikʉfwana bo ʉmmanyisi gwake. ");
INSERT INTO nyy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Fiki kʉkeeta akapaatʉ aka kalɨ nkɨsige ɨkya nnino, looli ʉtikʉlɨbona iitapwa ɨlɨ lɨlɨ nkɨsige kyako? ");
INSERT INTO nyy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kangɨ ʉbagiile bʉleebʉle ʉkʉmmbʉʉla ʉnnino ʉkʉtɨ, ‘Gwe nkamu gwangʉ, isaga ngʉsoosyemo akapaatʉ aka kalɨ nkɨsige kyako,’ looli ʉgwe ʉtikʉlɨbona iitapwa ɨlɨ lɨlɨ nkɨsige kyako? Gwe nsyobi ʉgwe! Soosyamo taasi iitapwa ɨlɨ lɨlɨ nkɨsige kyako, po kʉkeetaga kanunu nʉ kʉsoosyamo akapaatʉ nkɨsige ɨkya nnino!” ");
INSERT INTO nyy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ʉmpiki ʉnnunu gʉkabagɨla ʉkʉpa ɨseke ɨmbiibi, kangɨ ʉmpiki ʉmbiibi gʉkabagɨla ʉkʉpa ɨseke ɨnunu. ");
INSERT INTO nyy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ʉbagiile ʉkʉgʉmanya ʉmpiki muno gʉjɨɨliile kʉ seke syake, paapo abandʉ bakabagɨla ʉkʉpaata ɨseke sya nkʉjʉ pamo ɨsya maafiilʉ mmipiki ɨgya miifwa. ");
INSERT INTO nyy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ʉmundʉ ʉnnunu ikʉsoosya ɨnunu ʉkʉfuma mu nunu ɨsi siiswile mu ndumbula jaake. Looli ʉmundʉ ʉmbiibi, ikʉsoosya ɨmbiibi ʉkʉfuma mu mbiibi ɨsi siiswile mu ndumbula jaake. Paapo ɨsi ʉmundʉ ikʉjoba, syo ɨsi siiswile nʉ kooneka ʉkʉfuma mu ndumbula jaake.” ");
INSERT INTO nyy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Fiki mukʉngoolela, ‘Gwe Ntwa, gwe Ntwa,’ looli mutikʉbomba ɨsi nikʉbabʉʉla? ");
INSERT INTO nyy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ʉmundʉ gwesa ʉjʉ ikwisa kʉmyangʉ, nʉ kʉpɨlɨkɨsya ɨmanyisyo syangʉ nʉ kʉsikonga, ");
INSERT INTO nyy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","afwene bo ʉlwa mundʉ ʉjʉ ajengile ɨnyumba. Bo akaalɨ ʉkʉjenga aakʉmbile paasi fiijo, aafikile pa lwalabwe, po aajengile ʉlwalo lwa nyumba jaake. Bo gʉfikile ʉmweleesyo, ʉlwɨsi lwajɨgutile kʉ maka fiijo, looli lwatoliigwe ʉkʉjɨjʉgɨɨsya, paapo jaajengiigwe kanunu. ");
INSERT INTO nyy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Looli ʉmundʉ gwesa ʉjʉ asipɨliike ɨmanyisyo syangʉ kɨsita kʉsibombela, afwene bo ʉlwa mundʉ ʉjʉ aajengile ɨnyumba jaake pa mfu kɨsita lwalo. Ʉlwɨsi bo lwisile lwajɨgutile kʉ maka fiijo, jɨlɨnkʉgwa nʉ kʉpangʉka joosa.” ");
INSERT INTO nyy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesu bo amalile ʉkʉjoba syosa ɨsi aalondaga ʉkʉtɨ abandʉ bapɨlɨke, alɨnkʉbʉʉka nkaaja akaa mu Kapelinaʉmu. ");
INSERT INTO nyy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ʉko aaliko ʉndongosi jʉmo ʉgwa basikali baa Balooma. Ʉndongosi ʉjo aalɨ nʉ mbombi ʉjʉ aalɨnnganile fiijo. Ʉmbombi ʉjo aalɨ mbine, aalɨ kɨfuki ʉkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ʉndongosi jʉla bo apɨliike ɨnongwa sya Jesu, alɨnkʉbatʉma kwa Jesu abalongosi bamo abaa Bajuuta, ʉkʉtɨ babʉʉke bakansʉʉme iise ammbʉmbʉlʉsye ʉmbombi gwake. ");
INSERT INTO nyy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Abalongosi bala bo bafikile kwa Jesu, balɨnkʉnndamba balɨnkʉtɨ, “Ʉmundʉ ʉjʉ abagiisye ʉkʉbombeligwa ɨsi, ");
INSERT INTO nyy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","paapo akɨganile ɨkiisʉ kyɨtʉ, kangɨ atʉjengiile ɨsinagogi.” ");
INSERT INTO nyy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Po Jesu alɨnkʉsookapo na balongosi bala, ʉkʉbʉʉka kʉ nyumba jaa ndongosi gwa basikali. Bo balɨ kɨfuki nɨ nyumba, ʉndongosi jʉla aabatʉmile abamanyaani baake kwa Jesu, ʉkʉtɨ bantwalɨle ɨndʉmi ɨjaa kʉtɨ, “Gwe Ntwa, ʉlɨngiikatasyaga, ʉne ngabagɨsya ʉkʉtɨ ʉgwe gwingɨle nnyumba jangʉ. ");
INSERT INTO nyy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Fyobeene ʉne naaliibwene ʉkʉtɨ, ngabagɨsya ʉkwisa kʉmyako. Looli ʉjobe iisyʉ lyene, ʉmbombi gwangʉ ikʉbʉmbʉlʉka. ");
INSERT INTO nyy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Paapo na niine ndɨ gwa paasi, ngʉlagɨligwa, kangɨ ndɨ nabo abasikali aba balɨ paasi pamyangʉ. Lɨnga nʉmmbʉʉlile jʉmo ndile, ‘Bʉʉka!’ ikʉbʉʉka. Kʉ jʉngɨ lɨnga ndile, ‘Isaga!’ ikwisa. Na kʉ ntʉmwa gwangʉ lɨnga ndile, ‘Bomba ɨsi!’ ikʉbomba.” ");
INSERT INTO nyy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesu bo apɨliike amasyʉ ago, aaswigile fiijo. Po alɨnkʉkɨsanukɨla ɨkɨlʉndɨlo ɨkya bandʉ ɨkɨ kyankongaga, alɨnkʉtɨ, “Nikʉbabʉʉla nikʉtɨ, mBanyaisilaɨli boosa, ngammbonamo sikʉ ʉmundʉ ʉjʉ alɨ nʉ lwitɨko ʉlʉnywamu bo ʉlʉ!” ");
INSERT INTO nyy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Abandʉ aba baatʉmiigwe kwa Jesu, bo bagomwike kʉ nyumba jaa ndongosi jʉla, balɨnkʉmmwaga ʉmbombi jʉla abʉmbʉlwike. ");
INSERT INTO nyy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Piitaasi, Jesu na bafundigwa baake, pamopeene nɨ kɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ, balɨnkʉbʉʉka nkaaja aka kikʉkooleligwa ɨngamu jaa Naini. ");
INSERT INTO nyy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bo alɨ kɨfuki nɨ kɨpata ɨkya kaaja, aalyaganiile na bandʉ aba baasookangamo nkaaja, baapɨmbile ʉmfimba gwa ndʉmyana. Ʉndʉmyana ʉjʉ aalɨ mwana jʉmojwene ntɨga mu nna, ʉjʉ aasyɨlile ʉndʉme. Abandʉ bingi abaa nkaaja kala baalɨ pamopeene nʉ nkiikʉlʉ ʉmfwɨle jʉla. ");
INSERT INTO nyy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ɄNtwa Jesu bo ammbwene ʉmfwɨle jʉla, alɨnkʉmpelela ɨkɨsa. Alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉlɨngalɨlaga.” ");
INSERT INTO nyy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Po alɨnkʉsegelela, alɨnkʉlɨpalamaasya iibokosi lya mfimba, abandʉ aba baapɨmbile balɨnkwɨma. Jesu alɨnkʉtɨ, “Gwe ndʉmyana ʉgwe, nikʉkʉbʉʉla, sumuka!” ");
INSERT INTO nyy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ʉmfwe jʉla alɨnkʉsumuka, alɨnkwanda ʉkʉjoba. Po Jesu alɨnkʉmpapo ʉnna ʉmwana jʉla. ");
INSERT INTO nyy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Abandʉ boosa balɨnkʉtiila, balɨnkʉntuufya Kyala balɨnkʉtɨ, “Ʉnkunguluka ʉnkʉlʉmba aboniike kʉmyɨtʉ! Kyala iisile kʉkʉbatʉʉla abandʉ baake!” ");
INSERT INTO nyy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ɨnongwa ɨsi aabombile Jesu, syafumwike nkaaja koosa akaa Jutai na ntwaja toosa ʉtwa kɨfuki. ");
INSERT INTO nyy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Abafundigwa baa Johani ʉMoosi baalɨmpangiile syosa ɨsi Jesu aabombaga. Po Johani alɨnkʉbakoolela babɨlɨ mbafundigwa baake, ");
INSERT INTO nyy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","alɨnkʉbatʉma kʉ Ntwa Jesu ʉkʉtɨ bakanndaalʉʉsye bakatɨ, “Bʉle, ʉgwe jo ʉjʉ abakunguluka baatɨgɨ ikwisa? Pamo tʉnnguulɨlege ʉjʉngɨ?” ");
INSERT INTO nyy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Abafundigwa bala bo bafikile kwa Jesu, balɨnkʉtɨ, “Johani ʉMoosi atʉtʉmile tʉkʉlaalʉʉsye ʉkʉtɨ, ‘Bʉle, ʉgwe jo ʉjʉ abakunguluka baatɨgɨ ikwisa? Pamo tʉnnguulɨlege ʉjʉngɨ?’ ” ");
INSERT INTO nyy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Akabalɨlo kalakala, Jesu aababʉmbʉlwisye bingi ʉbʉbine ʉbwa lʉko nʉ lʉko, na aba baalɨ nɨ mbepo ɨnyali, kangɨ abafwa maaso bingi aabapelile ʉkʉkeeta. ");
INSERT INTO nyy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Po alɨnkʉbaamula aba baatʉmiigwe alɨnkʉtɨ, “Mubʉʉkege mukammbʉʉle Johani ɨsi musibwene nʉ kʉsipɨlɨka. Abafwa maaso bikʉkeeta, aba bikʉkwema bikwenda, abakoma bikwelʉsigwa, abaa mapʉlɨ bikʉpɨlɨka, abafwe bikʉsyʉsigwa, kangɨ abalondo bikʉlʉmbɨlɨligwa ɨNdʉmi ɨNunu. ");
INSERT INTO nyy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Asajiigwe ʉmundʉ gwesa ʉjʉ atikʉleka ʉkʉʉsʉʉbɨla.” ");
INSERT INTO nyy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Abafundigwa baa Johani bo basookilepo, Jesu alɨnkwanda ʉkʉfibʉʉla ɨfilʉndɨlo ɨfya bandʉ ɨsya Johani ʉMoosi, alɨnkʉtɨ, “Mwabʉʉkaga ndʉngalangala kʉkʉkeeta ɨfiki? Kalɨ, mwabʉʉkile kʉkʉnkeeta ʉmundʉ ʉjʉ akaja na maka, afwene nʉ lʉtete ʉlʉ lukʉjʉgɨɨsigwa nʉ mbelo? Mma! ");
INSERT INTO nyy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Po mwabʉʉkile kʉkʉkeeta ɨfiki? Kalɨ, ʉmundʉ ʉjʉ afwele ɨmyenda ɨgya ntengo? Mma! Pɨlɨkɨsya! Abandʉ aba bikʉfwala ɨmyenda ɨgya ntengo, nʉ kʉja nafyo ɨfindʉ fyosa ɨfinunu, bikʉtʉʉgala mfitangaalala. ");
INSERT INTO nyy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Po mwabʉʉkile kʉkʉkeeta ɨfiki? Ʉnkunguluka? Moomuumo! Nikʉbabʉʉla nikʉtɨ, ʉjo akaja nkunguluka itolo, looli nkʉlʉmba ʉkʉkɨnda ʉnkunguluka. ");
INSERT INTO nyy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ʉjo jo ʉjʉ ɨnongwa syake sisimbiigwe mwa Kalata ʉMwikemo, ʉkʉtɨ, ‘Keeta, ʉne nikʉntʉma ʉgwandʉmi gwangʉ, akʉtalɨlepo nkyeni mmyako, jo ikʉjɨtendekesya ɨnjɨla jaako.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesu kangɨ alɨnkʉtɨ, “Nikʉbabʉʉla nikʉtɨ, mmbandʉ boosa, akajapo ʉjʉ jo nkʉlʉmba ʉkʉnkɨnda Johani ʉMoosi. Looli ʉnnandɨ mBʉnyafyale bwa Kyala, jo nkʉlʉmba ʉkʉnkɨnda ʉmwene.” ");
INSERT INTO nyy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Po abandʉ boosa, boope na basongesya songo, bo bapɨliike amasyʉ gaa Jesu, balɨnkwitɨka ʉkʉtɨ ɨnjɨla jaa Kyala jo ngolofu, paapo baalyosiigwe nʉ loosyo lwa Johani. ");
INSERT INTO nyy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Looli aBafalisai na bamanyisi baa ndagɨlo sya Moose, baalʉkaanile ʉlʉbaatɨko lwa Kyala, paapo bakaalyosiigwe na Johani. ");
INSERT INTO nyy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesu alɨnkʉtɨ, “Bʉle, mbafwanikɨsye nɨ fiki abandʉ abaa nkabalɨlo aka? Balɨ bʉleebʉle? ");
INSERT INTO nyy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bafwene na baanike aba batʉʉgeele mu sokoni, aba bikʉbakoolela abiinaabo bikʉtɨ, ‘Twabakʉbiile amalonge gaa lʉsekelo, leelo mukaakinile! Twapaalile ɨɨfwa, leelo mukaalɨlile!’ ");
INSERT INTO nyy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Po Johani ʉMoosi bo iisile, aafipɨɨkaga ɨfindʉ nɨ finga, ʉmwe mwatɨgɨ, ‘Alɨ nɨ mbepo ɨnyali.’ ");
INSERT INTO nyy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Leelo ne Nnyamundʉ niisile, ngʉlya nʉ kʉnwa, ʉmwe mukʉtɨ, ‘Keeta! Ʉmpafu ʉjʉ, kangɨ ngaala bwalwa! Mmanyaani gwa basongesya songo na bafujufu!’ ");
INSERT INTO nyy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Looli amahala gaa Kyala gikʉboneka ʉkʉja magolofu mu mbombo sya baanaake boosa.” ");
INSERT INTO nyy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ɨliisikʉ lɨmo ʉMfalisai jʉmo, ɨngamu jaake Simoni, aalɨmpaalile Jesu kʉkʉlya ɨfindʉ kʉmyake. Po Jesu alɨnkʉbʉʉka kʉkaaja kaa Mfalisai jʉla, alɨnkʉtʉʉgala nʉ kʉlya ɨfindʉ. ");
INSERT INTO nyy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nkaaja kala aalipo ʉnkiikʉlʉ jʉmo, ʉjʉ aalɨ nʉ lwendo ʉlʉbiibi. Ʉnkiikʉlʉ ʉjo, bo apɨliike ʉkʉtɨ Jesu alɨ pakʉlya nnyumba jaa Mfalisai jʉla, alɨnkʉbʉʉka nɨ supa jaa mafuta agaa lʉʉma ʉlʉnunu. ");
INSERT INTO nyy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Alɨnkwɨma kʉnyuma kwa Jesu, kɨfuki na malʉndɨ gaake bo ikʉlɨla. Amaasosi gaake galɨnkʉtimɨsya amalʉndɨ gaa Jesu. Po alɨnkʉpyagɨɨsya amalʉndɨ gaa Jesu nɨ nywili syake, kʉno ikʉgafipa nʉ kʉgapaka amafuta. ");
INSERT INTO nyy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ɄMfalisai jʉla, ʉjʉ aalɨmpaalile Jesu, bo asibwene ɨsyo, alɨnkwinogona mu ndumbula jaake alɨnkʉtɨ, “Ʉmundʉ ʉjʉ lɨnga aalɨ nkunguluka, ngalɨ ameenye ʉkʉtɨ ʉnkiikʉlʉ ʉjʉ ikʉmpalamaasya jo jwani, gwa lʉko lʉki, kangɨ ntʉlanongwa.” ");
INSERT INTO nyy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Po Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Simoni, ndɨ nasyo simo ɨsya kʉkʉbʉʉla.” Simoni alɨnkʉtɨ, “Gwe Mmanyisi, mbʉʉla.” ");
INSERT INTO nyy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Po Jesu alɨnkʉtɨ, “Baaliko abandʉ babɨlɨ aba baakopile ɨndalama kʉ mundʉ jʉmo. Jʉmo aakopile ɨndenali ɨmia ihaano, ʉjʉngɨ aakopile ɨndenali amalongo mahaano. ");
INSERT INTO nyy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Abandʉ abo baatoliigwe ʉkʉhomba, po ʉjʉ aabakopiisye alɨnkʉbahobokela bobabɨɨlɨ. Alɨkʉ ndɨ aba baameleligwaga, ikʉnngana ʉkʉkɨndapo ʉjʉ aabakopiisye?” ");
INSERT INTO nyy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni alɨnkʉmmwamula alɨnkʉtɨ, “Ʉne ngʉtɨ, ʉjʉ aahobokeliigwe ɨnyingi.” Jesu alɨnkʉtɨ, “Ʉtalwisye.” ");
INSERT INTO nyy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Po Jesu alɨnkʉnsanukɨla ʉnkiikʉlʉ jʉla, alɨnkʉmmbʉʉla Simoni alɨnkʉtɨ, “Ʉmmbwene ʉnkiikʉlʉ ʉjʉ? Ningiile nnyumba jaako, ʉgwe ʉkambapo amɨɨsi gaa kʉsugusula mmalʉndɨ gangʉ. Looli ʉjʉ, aasuguswisye amalʉndɨ gangʉ na maasosi gaake, nʉ kʉgapyagɨɨsya nɨ nywili syake. ");
INSERT INTO nyy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bo kʉmbonia, ʉkaafipapo. Looli ʉjʉ, ʉkʉfuma lʉʉlo ningɨliile muno, akalekapo ʉkʉgafipa amalʉndɨ gangʉ. ");
INSERT INTO nyy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ʉkambaka amafuta pantʉ, looli ʉjʉ agapakile amalʉndɨ gangʉ amafuta agaa lʉʉma ʉlʉnunu. ");
INSERT INTO nyy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Po kʉnongwa jaa ɨsyo ngʉkʉbʉʉla ʉkʉtɨ, anangiisye ʉlʉgano ʉlʉnywamu, ʉkeetege ahobokeliigwe ʉbʉtʉlanongwa bwake ʉbwingi. Looli ʉmundʉ ʉjʉ ikʉhobokeligwa ʉbʉtʉlanongwa ʉbʉnandɨ, jo ʉjʉ ikʉgana panandɨ.” ");
INSERT INTO nyy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Po Jesu alɨnkʉmmbʉʉla ʉnkiikʉlʉ jʉla alɨnkʉtɨ, “Ʉhobokeliigwe ʉbʉtʉlanongwa bwako.” ");
INSERT INTO nyy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Po aba baalɨ pamopeene na Jesu pakʉlya ɨfindʉ, balɨnkʉjobesania balɨnkʉtɨ, “Ʉjʉ jo jwani, ikʉhobokela ʉbʉtʉlanongwa?” ");
INSERT INTO nyy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesu alɨnkʉmmbʉʉla ʉnkiikʉlʉ jʉla alɨnkʉtɨ, “Ʉlwitɨko lwako lʉkʉpokile. Ʉbʉʉkege nʉ lʉtengaano!” ");
INSERT INTO nyy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Po Jesu alɨnkʉbʉʉka ntwaja ʉtʉnywamu nʉ tʉnandɨ, aalʉmbɨlɨlaga ɨNdʉmi ɨNunu ʉkʉtɨ ʉBʉnyafyale bwa Kyala bʉsegeliile nkiisʉ. Aalɨ pamopeene na bafundigwa baake kalongo na babɨlɨ, ");
INSERT INTO nyy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na bakiikʉlʉ bamo, aba aabasoosiisyemo ɨmbepo ɨnyali nʉ kʉbabʉmbʉlʉsya ʉbʉbine bwabo. Aalimo Malija, ʉjʉ bantɨgɨ ʉgwa kʉ Magatala, ʉjʉ Jesu aalɨnsoosiisyemo ɨmbepo ɨnyali ihaano na ibɨlɨ, ");
INSERT INTO nyy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","kangɨ aalimo Joana ʉnkasi gwa Kusa. Kusa ʉjo ɨɨmɨlɨlaga ɨfyʉma fya malafyale Heloti. Kangɨ aalimo Susaana na bakiikʉlʉ abangɨ abingi. Abakiikʉlʉ aba baasoosyaga ʉtʉndʉ twabo ʉkʉmmbombela Jesu na bafundigwa baake. ");
INSERT INTO nyy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ɨliisikʉ lɨmo ɨkɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ baabʉngeene kwa Jesu, abandʉ biisaga ʉkʉfuma kʉkʉtɨ kaaja. Po Jesu alɨnkʉbabʉʉla nkɨfwanikɨsyo, alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ʉmbyali jʉmo aabʉʉkile kʉkʉsopa ɨmbeju. Bo ikʉsopa, ɨmbeju simo syagwɨliile mumbalɨ mu njɨla, silɨnkʉkanyigwa na bandʉ, ɨnjʉni silɨnkʉlya. ");
INSERT INTO nyy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ɨsingi syagwɨliile pa lwalabwe. Bo simelile, silɨnkʉʉma paapo pakaalɨ pabundafu. ");
INSERT INTO nyy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ɨmbeju ɨsingi syagwɨliile pa miifwa. Ɨmiifwa bo gɨmelile pamopeene nɨ mbeju, gɨlɨnkʉsifinyatɨla. ");
INSERT INTO nyy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Po ɨsingi syagwɨliile pa mfu ʉnnunu, silɨnkʉmela nʉ kʉpa ɨseke, kʉkʉtɨ mbeju jaapeele ɨseke ɨmia jɨmo.” Jesu bo amalile ʉkʉjoba ɨsyo, alɨnkʉlaata alɨnkʉtɨ, “Ʉjʉ alɨ nɨ mbʉlʉkʉtʉ ɨsya kʉpɨlɨkɨla, jo apɨlɨkege!” ");
INSERT INTO nyy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Abafundigwa baake balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Ɨkɨfwanikɨsyo ɨkɨ kokʉtɨ fiki?” ");
INSERT INTO nyy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Alɨnkʉbaamula alɨnkʉtɨ, “Ʉmwe Kyala abapeele ʉkʉsyagania ɨsya mbʉtiitʉ ɨsya Bʉnyafyale bwake. Looli abangɨ nikʉbabʉʉla mfifwanikɨsyo, paapo, ‘Nalɨnga bikʉkeeta, batikʉfibona. Nalɨnga bikʉpɨlɨka, batikʉsyagania.’ ");
INSERT INTO nyy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Po ɨkɨfwanikɨsyo ɨkɨ kokʉtɨ bʉno. Ɨmbeju lyo isyʉ lya Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ɨsi syagwɨliile mumbalɨ mu njɨla, bo bandʉ aba bikʉpɨlɨka ɨliisyʉ lya Kyala, looli Seetano ikwisa nʉ kʉlɨsoosyamo ɨliisyʉ ɨlyo mu ndumbula syabo, ʉkʉtɨ balɨngiisa kwitɨka nʉ kʉpokigwa. ");
INSERT INTO nyy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ɨsi syagwɨliile pamwanya pa lwalabwe, ʉlʉ lʉkaja nʉ mfu mwingi, sifwene bo ʉlwa bandʉ aba bikʉpɨlɨka iisyʉ lya Bʉnyafyale bwa Kyala, bikʉlyambɨlɨla nʉ lʉsekelo, looli iisyʉ lɨkaja nɨ misi. Bikwitɨka kʉkabalɨlo akapimba, pakabalɨlo akaa ngelo bikʉlʉleka ʉlwitɨko. ");
INSERT INTO nyy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ɨsi syagwɨliile pa miifwa, bo aba bikʉpɨlɨka iisyʉ lya Kyala, looli pabʉngɨ mbʉʉmi bwabo bikwikolaania nɨ mbombo, ɨkyʉma nɨ finyonyo ɨfya nkiisʉ. Po batikʉkʉla. ");
INSERT INTO nyy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Looli ɨmbeju ɨsi syagwɨliile pa mfu ʉnnunu, bo bandʉ aba balɨ nɨ ndumbula ɨnyeelu kangɨ nunu, bikʉlɨpɨlɨka iisyʉ ɨlyo, nʉ kʉlɨkola. Po bikʉpa ɨseke nʉ kwikasya mu ngʉbɨlo.” ");
INSERT INTO nyy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Akajako ʉmundʉ ʉjʉ ikwasya ɨnyaale, ikʉjɨkupɨkɨla nɨ kyombo pamo ikʉjɨbɨɨka kwi ifungu. Looli ikʉjɨbɨɨka pa kɨkolela nyaale, ʉkʉtɨ abandʉ bo bikwingɨla, bagʉbonege ʉndangalɨla. ");
INSERT INTO nyy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Namanga syosa ɨsi sifisiigwe sikwisa kʉbɨɨkigwa pabwelu. Kangɨ syosa ɨsi silɨ mbʉtiitʉ sikwisa kʉkuputuligwaga. ");
INSERT INTO nyy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Po mupɨlɨkɨsyege kanunu! Paapo ʉjʉ apeeliigwe ʉkʉsyagania ɨsyo, ikongeleligwa ʉkʉsyagania. Ʉjʉ akapeeligwa ʉkʉsyagania, syope ɨnandɨ ɨsi asyageenie sitikʉntʉʉla.” ");
INSERT INTO nyy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ʉnna na baamyabo baa Jesu baaliisile kʉkʉnkeeta. Looli baatoliigwe ʉkʉsegelela apa aalipo, paapo aalɨ pa kɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Po ʉmundʉ jʉmo alɨnkʉmmbʉʉla alɨnkʉtɨ, “Keeta! Ʉnyoko na bakamu baako bɨɨmile panja, bikʉlonda ʉkwaganila na nungwe.” ");
INSERT INTO nyy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Looli Jesu alɨnkwamula alɨnkʉtɨ, “Jʉʉba na bakamu bangʉ bo bala bikʉlɨpɨlɨka iisyʉ lya Kyala nʉ kʉlɨbombela.” ");
INSERT INTO nyy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ɨliisikʉ lɨmo Jesu alɨnkwipaka na bafundigwa baake mwi ibooti alɨnkʉtɨ, “Isaga, tʉloboke sʉmbɨ, tʉbʉʉke kwi isɨɨlya.” Po balɨnkwanda ʉkʉloboka. ");
INSERT INTO nyy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bo bikʉloboka, Jesu alɨnkʉgona ʉtʉlo. Ʉmbelo ʉgwa mpetapeta gʉlɨnkwisa, amɨɨsi galɨnkwanda ʉkwisʉla mwi ibooti, balɨnkʉja kɨfuki ʉkwibɨla. ");
INSERT INTO nyy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Po abafundigwa baake balɨnkʉbʉʉka kwa Jesu, balɨnkʉnndembʉsya, balɨnkʉjwega balɨnkʉtɨ, “Gwe Ntwa, gwe Ntwa, tukʉfwa!” Jesu alɨnkʉlembʉka, alɨnkʉgʉkemela ʉmbelo na majɨga, filɨnkʉbota, kʉlɨnkʉja mye jonjolo. ");
INSERT INTO nyy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Po Jesu alɨnkʉbalaalʉʉsya abafundigwa baake alɨnkʉtɨ, “Ʉlwitɨko lwɨnu lʉlɨ kokʉʉgʉ?” Abafundigwa baake balɨnkʉnyomoka fiijo, balɨnkʉlaalʉʉsania balɨnkʉtɨ, “Ʉjʉ jo jwani? Ikʉkemela ʉmbelo na majɨga, fyope fikʉntiila!” ");
INSERT INTO nyy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesu na bafundigwa baake balɨnkʉloboka sʉmbɨ Galilai, balɨnkʉfika kwi isɨɨlya, nkiisʉ ɨkya Bagelasi. ");
INSERT INTO nyy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesu bo iikile kwi isɨɨlya, alɨnkwaganila nagwe ʉmundʉ jʉmo ʉgwa nkiisʉ kɨla, ʉjʉ aalɨ nɨ mbepo ɨnyali. Amasikʉ mingi endaga ngelebuno, kangɨ akaatʉʉgalaga pakaaja, looli aatʉʉgalaga kʉ mapʉmba. ");
INSERT INTO nyy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bo ammbwene Jesu, ɨmbepo ɨnyali jɨlɨnkʉjwega, ʉmundʉ jʉla alɨnkʉgwa nkyeni mmyake, ɨmbepo ɨnyali jɨlɨnkʉlaata fiijo, jɨlɨnkʉtɨ, “Gwe Jesu, gwe Mwana gwa Kyala ʉNkʉlʉmba, tʉlɨ bʉki ʉgwe na niine? Ngʉkʉsʉʉma ʉlɨngaafundaga!” ");
INSERT INTO nyy_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ɨmbepo ɨnyali jɨla jaajobile bo ʉlo paapo Jesu aajɨkemiile, ʉkʉtɨ jɨsookemo mmundʉ jʉla. Jankolaga ʉmundʉ jʉla kaa kingi. Abandʉ bampinyaga ɨminyololo nɨ mbɨngo, ʉkʉnndɨndɨlɨla, poope aagɨlatʉlaniaga. Ɨmbepo jɨla jankagɨlaga ndiisʉ. ");
INSERT INTO nyy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesu alɨnkʉjɨlaalʉʉsya alɨnkʉtɨ, “Ɨngamu jaako gwe gwani?” Ɨmbepo ɨnyali jɨlɨnkʉmmwamula jɨlɨnkʉtɨ, “Ɨngamu jangʉ ne Kɨlʉndɨlo.” Jaajobile bo ʉlo paapo ɨmbepo ɨnyali nyingi syalingiile mmundʉ jʉla. ");
INSERT INTO nyy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ɨmbepo ɨnyali sila silɨnkʉnndamba Jesu ʉkʉtɨ, alɨngasilagɨla ʉkʉbʉʉka mbwina ʉbwa kʉ ngolongo. ");
INSERT INTO nyy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akabalɨlo ako nkyamba, gwatiimigwaga ʉntiimo ʉnnywamu ʉgwa ngʉlʉbe. Po ɨmbepo ɨnyali sila silɨnkʉmpyelesya Jesu ʉkʉtɨ, asiitɨkɨsye ʉkwingɨla mu ngʉlʉbe sila. Po alɨnkʉsiitɨkɨsya. ");
INSERT INTO nyy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Po ɨmbepo ɨnyali silɨnkʉsookamo mmundʉ jʉla, silɨnkwakwingɨla mu ngʉlʉbe. Silɨnkʉsibopesya ɨngʉlʉbe syosa ʉkʉsuluka ndʉpanga, mpaka mwa sʉmbɨ, silɨnkʉmilwa. ");
INSERT INTO nyy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Abatiimi baa ngʉlʉbe bo basibwene ɨsyo, balɨnkʉbopa ʉlʉbɨlo, balɨnkʉbʉʉka nkaaja na mmigʉnda, balɨnkʉpanga ɨsi baasibwene. ");
INSERT INTO nyy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Abandʉ balɨnkʉbʉʉka kʉkʉkeeta ɨsi syaboniike. Bo bafikile kwa Jesu, balɨnkʉmmbona ʉmundʉ jʉla, ʉjʉ sisookilemo ɨmbepo ɨnyali, atʉʉgeele paasi, afwele kanunu, kangɨ alɨ na mahala goosa, balɨnkʉtiila. ");
INSERT INTO nyy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Abandʉ aba baasikeetile ɨsi syaboniike, balɨnkʉbapangɨla abangɨ muno abʉmbʉlʉkɨsiigwe ʉjʉ aalɨ nɨ mbepo ɨnyali. ");
INSERT INTO nyy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Po abandʉ boosa abaa nkiisʉ kya Bagelasi, lʉlɨnkʉbakola ʉlʉtende, balɨnkʉnsʉʉma Jesu ʉkʉtɨ asookemo nkiisʉ kyabo. Jesu alɨnkwingɨla mwi ibooti, alɨnkʉsookamo. ");
INSERT INTO nyy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jesu bo ikʉsookamo, ʉmundʉ jʉla ʉjʉ syasookilemo ɨmbepo ɨnyali, alɨnkʉlamba kwa Jesu ʉkʉtɨ abʉʉkege pamopeene nagwe. Looli Jesu akaalɨmmwitɨkiile alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ʉbʉʉke kʉmyɨnu, ʉkababʉʉle abandʉ ɨsi Kyala akʉbombiile.” Po ʉmundʉ jʉla alɨnkʉsookapo pala, alɨnkʉfumusya nkaaja koosa, ɨsi Jesu ammbombiile. ");
INSERT INTO nyy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesu bo agomwike ʉkʉfuma kwi isɨɨlya, aalyambɨlɨliigwe nɨ kɨlʉndɨlo ɨkya bandʉ, paapo boosa bannguulɨlaga. ");
INSERT INTO nyy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Po alɨnkʉbʉʉka ʉmundʉ jʉmo kwa Jesu, ɨngamu jaake Jailo, aalɨ ndongosi gwa sinagogi. Alɨnkʉfugama nkyeni mwa Jesu, alɨnkʉpyelesya fiijo ʉkʉtɨ abʉʉke kʉkaaja kaake, ");
INSERT INTO nyy_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","paapo ʉmwanaake ʉndɨndwana ʉgwa fyɨnja kalongo na fibɨlɨ bʉno, ʉjʉ aalɨ mwanaake jʉmojwene ntɨga, aalɨ mbine ʉlwa kʉfwa. Jesu bo ikʉbʉʉka kʉkaaja kaa Jailo, ɨkɨlʉndɨlo kya bandʉ balɨnkʉmfinyatɨla. ");
INSERT INTO nyy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nkɨlʉndɨlo kɨla, aalimo ʉnkiikʉlʉ jʉmo, ʉjʉ aalɨ nʉ bʉbine bwa kooneka iilopa. Ʉbʉbine ʉbo bwalɨntaamiisye kʉ fyɨnja kalongo na fibɨlɨ. Ɨkyʉma kyake kyosa aataagile nkʉbahomba abaganga, poope akaaliko ʉjʉ aabagiile ʉkʉmmbʉmbʉlʉsya. ");
INSERT INTO nyy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Po ʉnkiikʉlʉ jʉla alɨnkʉbʉʉka kʉnyuma kwa Jesu, alɨnkʉpalamaasya ɨkɨpeto kya mwenda gwa Jesu, palapala iilopa lɨlɨnkʉleka ʉkooneka. ");
INSERT INTO nyy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesu alɨnkʉlaalʉʉsya alɨnkʉtɨ, “Jo jwani ambalamaasiisye?” Abandʉ boosa balɨnkʉkaana. Po Peeteli alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Gwe Ntwa, abandʉ bingi bakʉsyʉngʉʉtiile kangɨ bikʉkʉfinyatɨla.” ");
INSERT INTO nyy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Looli Jesu alɨnkʉtɨ, “Alipo ʉmundʉ ʉjʉ ambalamaasiisye, paapo ngwipɨlɨka ʉkʉtɨ amaka gamo agaa kʉbʉmbʉlʉkɨsya gasookile.” ");
INSERT INTO nyy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ʉnkiikʉlʉ jʉla bo aagile ʉkʉtɨ Jesu asyageenie, alɨnkwisa bo ikʉtetema. Alɨnkʉfugama nkyeni mmyake, alɨnkʉmmbʉʉla Jesu nkyeni mmbandʉ boosa ɨsi syalɨmpelile ʉkʉmpalamaasya, na muno abʉmbʉlʉkiile palapala. ");
INSERT INTO nyy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Mwanangʉ, ʉbʉmbʉlwike ʉbʉbine kʉnongwa jaa lwitɨko lwako. Bʉʉkaga nʉ lʉtengaano!” ");
INSERT INTO nyy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesu bo alɨ pakʉjoba, alɨnkwisa ʉmundʉ ʉkʉfuma kʉkaaja kaa Jailo, ʉndongosi jʉla ʉgwa mu sinagogi, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉlɨngantaamyaga ʉMmanyisi, ʉmwanaako ʉndɨndwana afwile.” ");
INSERT INTO nyy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Looli Jesu bo apɨliike ɨsyo, alɨnkʉmmbʉʉla Jailo alɨnkʉtɨ, “Ʉlɨngatiilaga, ʉjege nʉ lwitɨko itolo, ʉmwanaako ikʉbʉmbʉlʉka.” ");
INSERT INTO nyy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesu bo afikile pa nyumba jaa Jailo, aabakaaniisye abandʉ ʉkwingɨla pamopeene nagwe, looli aabiitɨkiisye ʉgwise nʉ nna gwa ndɨndwana, na baa Peeteli, Johani na Jaakobo. ");
INSERT INTO nyy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Abandʉ boosa balɨnkʉkuuta nʉ kʉnndɨlɨla ɨɨfwa ʉndɨndwana jʉla. Looli Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mulɨngakuutaga! Akafwa, looli agonile twene ʉtʉlo.” ");
INSERT INTO nyy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Abandʉ bala balɨnkʉnseka Jesu, paapo baameenye ʉkʉtɨ ʉndɨndwana jʉla afwile. ");
INSERT INTO nyy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesu alɨnkʉnkola ɨkɨboko ʉndɨndwana jʉla, alɨnkʉlaata alɨnkʉtɨ, “Ndɨndwana, lembʉka!” ");
INSERT INTO nyy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ʉndɨndwana jʉla, ʉbʉʉmi bwake bʉlɨnkʉgomokelamo, alɨnkʉsumuka akabalɨlo kalakala. Jesu alɨnkʉlagɨla ʉkʉtɨ bampepo ɨfindʉ ʉndɨndwana jʉla. ");
INSERT INTO nyy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Abapaapi baa ndɨndwana baaswigile fiijo. Looli Jesu alɨnkʉbalagɨla ʉkʉtɨ balɨngampangɨlaga najʉmo ɨsi siboniike. ");
INSERT INTO nyy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesu aababʉngeenie abafundigwa baake kalongo na babɨlɨ. Alɨnkʉbapapo amaka nʉ bʉlagɨli bwa kʉsikaga ɨmbepo ɨnyali syosa, nʉ kʉbʉmbʉlʉsya ʉbʉbine. ");
INSERT INTO nyy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Po alɨnkʉbatʉma ʉkʉlʉmbɨlɨla ʉBʉnyafyale bwa Kyala nʉ kʉbʉmbʉlʉsya ababine. ");
INSERT INTO nyy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Mulɨngendaga nafyo nafimo ɨfya kʉbatʉʉla mu njɨla, nalɨnga ngili jaa kwendela, nalɨnga kɨnyambɨ, nalɨnga findʉ, nalɨnga ndalama, kangɨ nalɨnga mwenda gwa kwandʉla. ");
INSERT INTO nyy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ɨnyumba joosa jɨla mukwakwingɨlaga, mukatʉʉgalege mulamula kɨsita kʉsaama, mpaka bo mukʉsookamo nkaaja ako. ");
INSERT INTO nyy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Lɨnga abandʉ batikʉbambɨlɨla, mukasookengepo nʉ kʉkungʼunda ɨfumbɨ ɨjɨ jɨlɨ mmalʉndɨ gɨɨnu, ʉkʉja kyo kɨmanyilo kya kʉbasoka.” ");
INSERT INTO nyy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Po balɨnkʉbʉʉka ntwaja, balɨnkʉlʉmbɨlɨla ɨNdʉmi ɨNunu, nʉ kʉbʉmbʉlʉsya ababine koosa kʉno baabʉʉkaga. ");
INSERT INTO nyy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heloti, ʉmalafyale ʉgwa mu Galilai, aapɨliike ɨnongwa syosa ɨsi aabombaga Jesu. Leelo silɨnkʉmmwalangania, paapo abandʉ bamo baatɨgɨ Johani ʉMoosi asyʉkile ʉkʉfuma mbafwe. ");
INSERT INTO nyy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Abangɨ baatɨgɨ, ʉnkunguluka Elija iisile kangɨ. Abangɨ baatɨgɨ, jʉmo mbakunguluka abaa ijolo asyʉkile. ");
INSERT INTO nyy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Looli Heloti alɨnkʉtɨ, “Johani naalɨmmbuutile ʉntʉ! Po jo jwani ʉjʉ ngʉsipɨlɨka ɨnongwa syake?” Po Heloti alɨnkʉlonda fiijo ʉkʉmmbona Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Abatʉmigwa balɨnkʉgomoka kwa Jesu, balɨnkʉmpangɨla ɨmbombo syosa ɨsi baabombile. Po alɨnkʉbeega, alɨnkʉbʉʉka nabo nkaaja aka ɨngamu jaake jo Betisaita, ʉkʉtɨ baje beene pabʉjo ʉbwa kwijeekela. ");
INSERT INTO nyy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Abandʉ bingi bo bakʉmeenye kʉno ikʉbʉʉka, balɨnkʉnkonga. Jesu alɨnkʉbambɨlɨla, alɨnkʉbamanyisya ɨnongwa sya Bʉnyafyale bwa Kyala. Alɨnkʉbabʉmbʉlʉsya ʉbʉbine, aba baafumbilwe ʉkʉbʉmbʉlʉsigwa. ");
INSERT INTO nyy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Akabalɨlo akaa namajolo bo kasegeliile, abafundigwa kalongo na babɨlɨ balɨnkʉbʉʉka kwa Jesu, balɨnkʉtɨ, “Ʉbalage abandʉ ʉkʉtɨ babʉʉke ntwaja na mmigʉnda ɨgya kɨfuki, babagiile ʉkʉfyaga ɨfindʉ na pa bʉgono, paapo apa tʉlipo lʉkʉbo.” ");
INSERT INTO nyy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Amubapepo ʉmwe ɨfindʉ.” Balɨnkʉmmwamula balɨnkʉtɨ, “Ʉswe tʉkaja nafyo nafimo, looli fyene ɨfisyesye fihaano nɨ ɨswɨ ibɨlɨ. Pamo tʉbʉʉke tʉkʉʉle ɨfindʉ ɨfya kʉbafwana abandʉ aba boosa!” ");
INSERT INTO nyy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Baalipo abandʉ abanyambala 5,000 bʉno. Po Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Mubatʉʉgasye abandʉ mfibugutɨla fya bandʉ amalongo mahaano mahaano bʉno.” ");
INSERT INTO nyy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Po balɨnkʉbomba bo muno abalagɨliile, balɨnkʉbatʉʉgasya boosa. ");
INSERT INTO nyy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Po Jesu alɨnkwega ɨfisyesye fila fihaano, nɨ ɨswɨ sila ibɨlɨ, alɨnkʉkeeta kʉmwanya, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉfimenya ɨfisyesye, alɨnkʉbapapo abafundigwa baake ʉkʉtɨ babajabɨle abandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Abandʉ boosa balɨnkʉlya, balɨnkwikʉta. Po abafundigwa baake balɨnkʉbʉngaania ɨfimeenya ɨfi fyasyeleko, balɨnkwisʉsya ɨfiibo kalongo na fibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ɨliisikʉ lɨmo, Jesu na bafundigwa baake baalɨ pamopeene pabʉjo bʉmo ʉbwa kwijeekela, iipuutaga. Alɨnkʉbalaalʉʉsya abafundigwa baake alɨnkʉtɨ, “Abandʉ bikʉtɨ, ʉne ne ani?” ");
INSERT INTO nyy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Balɨnkʉmmwamula balɨnkʉtɨ, “Bamo bikʉtɨ gwe Johani ʉMoosi, abangɨ bikʉtɨ gwe nkunguluka Elija, na bangɨ bikʉtɨ ʉgwe jo jʉmo mbakunguluka abaa ijolo, ʉjʉ asyʉkile.” ");
INSERT INTO nyy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Po Jesu alɨnkʉbalaalʉʉsya abeene, alɨnkʉtɨ, “Na nuumwe mukʉtɨ, ʉne ne ani?” Po Peeteli alɨnkʉmmwamula alɨnkʉtɨ, “Ʉgwe gwe Meesija, ʉMpoki ʉjʉ Kyala aatile ikʉntʉma.” ");
INSERT INTO nyy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesu alɨnkʉbasoka ʉkʉtɨ balɨngammbʉʉlaga ɨnongwa ɨjo najʉmo. ");
INSERT INTO nyy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉne Nnyamundʉ mpaka ngabe ɨngʉbɨlo nyingi nʉ kʉkaanigwa na balongosi baa Bajuuta, abapuuti abalongosi na bamanyisi baa ndagɨlo sya Moose, mpaka ʉkʉgogigwa. Po pi isikʉ lya bʉtatʉ, ngwisa kʉsyʉka.” ");
INSERT INTO nyy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Po Jesu alɨnkʉbabʉʉla boosa alɨnkʉtɨ, “Ʉmundʉ gwesa ʉjʉ ikʉlonda ʉkʉngonga, jo fikʉtɨ alɨngiipaakɨsyaga na panandɨ, nalɨnga aikʉgogigwa pa kɨkohekano kʉnongwa jangʉ, angongege kʉkʉtɨ isikʉ. ");
INSERT INTO nyy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ʉjʉ lɨnga ikʉlonda ʉkʉbʉponesya ʉbʉʉmi bwake, ikʉbʉpeesyaga ʉbʉʉmi bwa bwila na bwila. Looli ʉmundʉ ʉjʉ atikʉpaasya ʉkʉfwa kʉnongwa jangʉ, jo ikʉbʉkabaga ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Eemwa, kalɨ ʉmundʉ fikʉmmbʉmbʉlɨla ɨfiki ʉkʉkɨkaba ɨkyʉma kyosa ɨkya nkiisʉ, looli ikʉbʉpeesya ʉbʉʉmi bwa bwila na bwila? ");
INSERT INTO nyy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ʉmundʉ gwesa ʉjʉ ikʉʉfwɨlaga ɨsoni ʉne na masyʉ gangʉ, ne Nnyamundʉ ngwisa kʉmfwɨla ɨsoni ʉmundʉ ʉjo, bo ngwisa mbʉsisya bwangʉ, ʉbwa Taata nʉ bwa bandʉmi abiikemo. ");
INSERT INTO nyy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nalooli nikʉbabʉʉla, balipo bamo papaapa aba batikʉfwa mpaka taasi babʉbone ʉBʉnyafyale bwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Amasikʉ lwele bʉno bo gakɨndile, ʉkʉfuma pakʉjoba amasyʉ ago, Jesu alɨnkʉbeega baa Peeteli, Johani na Jaakobo, alɨnkʉfyʉka nabo pa kyamba kʉkwipuuta. ");
INSERT INTO nyy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bo ikwipuuta, aalyandwike kʉmaaso, nɨ myenda gyake gɨlɨnkʉja myelu, gɨlɨnkʉlangala fiijo. ");
INSERT INTO nyy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Nakalɨnga abandʉ babɨlɨ baasetwike nʉ bʉsisya, baajobaga na Jesu. Abandʉ abo baalɨ bakunguluka, Moose na Elija. Baajobaga ɨnongwa ɨsya kʉfwa kwake Jesu, ɨsi aalɨ kɨfuki ʉkʉsimalɨɨsya kʉ Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peeteli na banine twabakolile ʉtʉlo. Nakalɨnga balɨnkʉlembʉka balɨnkʉmmbona Jesu mbʉsisya bwake na bandʉ babɨlɨ abo bɨɨmile pamopeene nagwe. ");
INSERT INTO nyy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Abandʉ bala babɨlɨ bo bikʉbalanila na Jesu, Peeteli alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Gwe Ntwa, kanunu ʉswe ʉkʉjapo apa. Tʉjenge ɨfitembe fitatʉ. Kɨmo kɨje kyako, ɨkɨngɨ kya Moose, nɨ kɨngɨ kɨje kya Elija.” Peeteli akaasimeenye na ɨsi aajobaga. ");
INSERT INTO nyy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peeteli bo akaalɨ ikʉjoba, lɨlɨnkwisa iibɨngo lɨlɨnkʉbakupɨkɨla. Po abafundigwa balɨnkʉtiila fiijo. ");
INSERT INTO nyy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Po balɨnkʉpɨlɨka iisyʉ ʉkʉfuma mwi ibɨngo, lɨlɨnkʉtɨ, “Ʉjʉ jo Mwanangʉ ʉNsʉngʉligwa, mumpɨlɨkɨsyege!” ");
INSERT INTO nyy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ɨliisyʉ bo lɨmyekile, Jesu alɨnkʉboneka alɨ mwene. Boope abafundigwa baake balɨnkʉja kɨmyemye, bakaalɨmpangiilemo ʉmundʉ najʉmo ɨsi baasibwene, mmasikʉ ago. ");
INSERT INTO nyy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kɨlaabo kyake, Jesu na bafundigwa bala batatʉ bo basulwike ʉkʉfuma kʉ kyamba, baalyaganiile nɨ kɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ʉmundʉ jʉmo nkɨlʉndɨlo alɨnkʉkoolela alɨnkʉtɨ, “Gwe Mmanyisi, ngʉkʉsʉʉma ʉnkeete ʉmwanangʉ, paapo jo mwanangʉ jʉmojwene ntɨga. ");
INSERT INTO nyy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ɨmbepo ɨnyali jikʉnkola kaa kingi, ikʉjwega, jikʉnnjʉgaania ikʉsoosya ʉntotoofula nkanwa. Ɨmbepo ɨnyali ɨjo jikʉntaamya fiijo, jɨtikʉnndeka, looli lʉmoolʉmo. ");
INSERT INTO nyy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mbasʉʉmile abafundigwa baako ʉkʉtɨ bajɨkage, looli batoliigwe.” ");
INSERT INTO nyy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mwe bandʉ baa nkabalɨlo aka, mwe mukaja nʉ lwitɨko ʉmwe! Moonangiike! Bʉle, ngʉtʉʉgala pamopeene na nuumwe nʉ kʉbakeetelela mpaka ndɨli? Namuntwale apa ʉmwanike.” ");
INSERT INTO nyy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ʉmwana jʉla bo ikʉbʉʉka kwa Jesu, ɨmbepo ɨnyali jɨlɨnkʉnnjʉgaania, jɨlɨnkʉmmbiga paasi. Po Jesu alɨnkʉjɨkemela, alɨnkʉmmbʉmbʉlʉsya ʉmwana jʉla, alɨnkʉnngomokesya ʉgwise. ");
INSERT INTO nyy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Abandʉ boosa baagaswigile amaka amakʉlʉmba agaa Kyala. Abandʉ bala bo bikʉswiga syosa ɨsi abombile Jesu, alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mupɨlɨkɨsye kanunu ɨsi. Ne Nnyamundʉ ngwisa kʉbɨɨkigwa mmaboko agaa balʉgʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Looli abeene bakaasyageenie ɨsi aajobaga Jesu, paapo syafisiigwe kʉmyabo ʉkʉtɨ balɨngasyagania. Kangɨ baatiilaga ʉkʉnndaalʉʉsya. ");
INSERT INTO nyy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Abafundigwa baa Jesu balɨnkwanda ʉkʉkaanikana ʉkʉtɨ, jo jwani nkʉlʉmba nkɨbugutɨla kyabo. ");
INSERT INTO nyy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesu aasyageenie ɨnyiinogono syabo. Po alɨnkʉmmwega ʉmwanike, alɨnkʉmmbɨɨka kɨfuki nagwe. ");
INSERT INTO nyy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉmundʉ gwesa ʉjʉ ikʉmmwambɨlɨla ʉmwanike ʉjʉ mu ngamu jangʉ, ikʉʉnyambɨlɨla ʉne. Kangɨ ʉjʉ ikʉʉnyambɨlɨla ʉne, ikʉmmwambɨlɨla ʉjʉ andʉmile. Paapo ʉnnandɨ ʉkʉkɨnda mwesa pakatɨ pamyɨnu, jo nkʉlʉmba ʉkʉkɨnda boosa.” ");
INSERT INTO nyy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Johani alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Gwe Ntwa, twalɨmmbwene ʉmundʉ jʉmo ikʉkaga ɨmbepo ɨnyali mu ngamu jaako. Twalɨnkaaniisye, paapo akaja pamopeene na nuuswe.” ");
INSERT INTO nyy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Looli Jesu alɨnkʉtɨ, “Mulɨngankaanisyaga, paapo ʉmundʉ ʉjʉ atikʉkɨndana na nuumwe, jo alɨ kʉkɨbafu kyɨnu.” ");
INSERT INTO nyy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Akabalɨlo kaake akaa kʉfyʉka kʉmwanya bo kalɨ kɨfuki, Jesu aatumwile ʉkʉbʉʉka kʉ Jelusalemu, alɨnkʉbʉʉka. ");
INSERT INTO nyy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Po alɨnkʉbatʉma abandʉ abaa kʉtalapo, abo balɨnkʉbʉʉka nkaaja kamo akaa Basamalija, kʉkʉntendekekesya ʉbʉjo. ");
INSERT INTO nyy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Looli abandʉ baa kʉla balɨnkʉkaana ʉkʉmmwambɨlɨla Jesu, paapo aabʉʉkaga kʉ Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Abafundigwa baake, Jaakobo na Johani, bo basibwene ɨsyo balɨnkʉtɨ, “Gwe Ntwa, kʉlonda tʉsʉʉme ʉmooto gʉsuluke ʉkʉfuma kʉmwanya gʉbapyute bo ʉlʉ aabombile Elija?” ");
INSERT INTO nyy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Looli Jesu alɨnkʉbasanukɨla nʉ kʉbakemela. Alɨnkʉtɨ, “Mukasyagania ʉkʉtɨ mukʉlondigwa ʉkʉja nɨ nyiinogono ɨsya lʉko lʉki. ");
INSERT INTO nyy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Namanga Nnyamundʉ akaaliisile kʉkʉbapyuta abandʉ looli kʉkʉbapoka.” Jesu na bafundigwa baake balɨnkʉsookapo, balɨnkʉbʉʉka nkaaja akangɨ. ");
INSERT INTO nyy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jesu na bafundigwa baake bo balɨ mu njɨla, ʉmundʉ jʉmo alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Ʉne nikʉkʉkongaga koosa kʉno kʉbʉʉka ʉkʉtɨ nje mfundigwa gwako!” ");
INSERT INTO nyy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉtʉmbwe tʉlɨ nɨ mbako, nɨ njʉni silɨ nɨ fifufumbwa, looli ʉne Nnyamundʉ ngaja nʉ bʉjo ʉbwa kʉlambalala.” ");
INSERT INTO nyy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesu alɨnkʉmmbʉʉla ʉmundʉ ʉjʉngɨ, alɨnkʉtɨ, “Ʉngongege!” Ʉmundʉ jʉla alɨnkʉtɨ, “Gwe Ntwa, leka taasi mbʉʉke ngansyɨle taata.” ");
INSERT INTO nyy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Baleke abafwe babasyɨlege abafwe baabo. Looli ʉgwe, ʉbʉʉke kʉkʉfumusya ʉBʉnyafyale bwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Joope ʉjʉngɨ alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Gwe Ntwa, ngʉkʉkongaga, looli ʉʉndekesye taasi ngalage kʉkaaja.” ");
INSERT INTO nyy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉmundʉ ʉjʉ alɨ pakʉlɨma, lɨnga ikʉkeetako kʉnyuma, akabagɨsya ʉkʉja mbombeli mBʉnyafyale bwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bo sikɨndile ɨsyo, ʉNtwa Jesu alɨnkʉbasʉngʉla abandʉ abangɨ 72. Po alɨnkʉbatʉma babɨlɨ babɨlɨ, ʉkʉtɨ batalepo kʉkʉtɨ kaaja nʉ bʉjo, kʉno aabɨngɨliile ʉkʉbʉʉka ʉmwene. ");
INSERT INTO nyy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉntondolo mwingi, looli abatondoli banandɨ. Po munsʉʉmege ʉNtwa ʉgwa ngʉnda, abatʉme abatondoli mu ngʉnda gwake. ");
INSERT INTO nyy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Namubʉʉke, ngʉbatʉma ngatɨ ngʼoosi ɨmwana pakatɨ pa mbwa ɨsya ndiisʉ! ");
INSERT INTO nyy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mulɨngendaga nɨ ndalama, pamo ɨkɨnyambɨ, pamo ɨfilato. Kangɨ mulɨngataagaga akabalɨlo ʉkʉponia abandʉ mu njɨla. ");
INSERT INTO nyy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ɨnyumba joosa ɨjɨ mukwakwingɨlaga mukabaponiege abenekaaja, mukatɨgɨ, ‘Kyala abapepo ʉlʉtengaano mu nyumba ɨjɨ.’ ");
INSERT INTO nyy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Lɨnga ʉmwene nyumba gwa lʉtengaano, ʉlʉtengaano lukʉjaga nagwe. Lɨnga akaja gwa lʉtengaano, atikʉjaga nʉ lʉtengaano. ");
INSERT INTO nyy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Musyalege mu nyumba ɨjɨ babambɨliile, mulyege nʉ kʉnwa ɨfi bikʉbapapo. Paapo kʉkʉtɨ mbombeli ikʉlondigwa ʉkʉpeeligwa ɨfi afumbilwe na bandʉ aba ikʉbabombela. Mulɨngasaamaga saamaga ʉkʉbʉʉka mu nyumba ɨsingi. ");
INSERT INTO nyy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Bo mwingiile nkaaja koosa kala, lɨnga abenekaaja babambɨliile, mukalyege ɨfi bikwakʉbapaga. ");
INSERT INTO nyy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ababine aba balimo nkaaja ako, mubabʉmbʉlʉsyege. Mubabʉʉlege ʉkʉtɨ, ‘ɄBʉnyafyale bwa Kyala bʉsegeliile.’ ");
INSERT INTO nyy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Looli lɨnga mukwakwingɨla nkaaja koosa kala, batikʉbambɨlɨla, mukabʉʉkege mmisebo gyabo mukatɨgɨ, ");
INSERT INTO nyy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Joope ɨfumbɨ jaa kaaja kɨɨnu ɨjɨ jɨtʉʉmɨɨliile mmalʉndɨ gɨɨtʉ, tukʉbakungʼundɨla. Looli mumanye ʉkʉtɨ ʉBʉnyafyale bwa Kyala bʉsegeliile.’ ");
INSERT INTO nyy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nikʉbabʉʉla nikʉtɨ, pi isikʉ lya bʉlongi, abandʉ abaa nkaaja ako, bikwisa kʉkaba ʉlʉfundo ʉlʉnywamu, ʉkʉkɨnda ʉlwa bandʉ baa mu Sotoma!” ");
INSERT INTO nyy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ahɨɨli mwe bandʉ baa nkaaja akaa mu Kolasini, na nuumwe mwe baa nkaaja akaa mu Betisaita! Paapo ɨfiika ɨfi mbombile kʉmyɨnu, lɨnga fyabombiigwe ntwaja ʉtwa bandʉ ababiibi ʉtwa mu Tili na mu Sitoni, ngalɨ basʉʉmile ʉlʉhobokelo kʉno bafwele amalogota nʉ kʉpakala ʉmfwandɨlo. ");
INSERT INTO nyy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Looli pi isikʉ lya bʉlongi, mukwisa kʉkaba ʉlʉfundo ʉlʉnywamu, ʉkʉkɨnda ʉlwa bandʉ baa mu Tili na mu Sitoni! ");
INSERT INTO nyy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na nuumwe mwe bandʉ baa nkaaja akaa mu Kapelinaʉmu, bʉle, mukwinogona ʉkʉtɨ Kyala ikʉbakwesya mpaka kʉmwanya? Mma! Kyala ikʉbasulusya mpaka kʉ ngolongo.” ");
INSERT INTO nyy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Po Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Ʉmundʉ ʉjʉ ikʉbapɨlɨka ʉmwe, ikʉmbɨlɨka ʉne. Ʉjʉ ikʉbakaana ʉmwe, ikʉngaana ʉne. Kangɨ ʉjʉ ikʉngaana ʉne, ikʉnkaana ʉjʉ andʉmile.” ");
INSERT INTO nyy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Po abafundigwa baa Jesu 72, balɨnkʉgomoka nʉ lʉsekelo, balɨnkʉmmbʉʉla Jesu balɨnkʉtɨ, “Gwe Ntwa, syope ɨmbepo ɨnyali, mu ngamu jaako, sikʉtʉtiila!” ");
INSERT INTO nyy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Naalɨmmbwene Seetano ikʉsatʉka ngatɨ kɨmweku ɨkya njasi ʉkʉfuma kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Keeta! Mbapeele amaka agaa kʉsikanya ɨnjoka na baa kaliisa, nʉ kʉtola amaka goosa agaa ndʉgʉ. Kakajako akaa kʉbafulasya. ");
INSERT INTO nyy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Leelo mulɨngasekelaga kwene ʉkʉbatiila ɨmbepo ɨnyali, looli musekelege fiijo paapo ɨngamu syɨnu sisimbiigwe kʉmwanya.” ");
INSERT INTO nyy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Akabalɨlo kalakala, kʉ maka agaa Mbepo Mwikemo, Jesu alɨnkʉsekela fiijo alɨnkʉtɨ, “Gwe Taata, gwe Ntwa ʉgwa kʉmwanya na pakiisʉ, ngʉgwa ʉlʉpi paapo ɨmbombo ɨsyo ʉbafisile abaa mahala na bamangʼanyi, ʉbanangiisye aba bikwijiisya bo ʉlwa baana. Moomuumo Taata, ɨsyo gwaliikyeliile.” ");
INSERT INTO nyy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kangɨ alɨnkʉtɨ, “Taata ambeele ʉtʉndʉ toosa. Akajako ʉjʉ ammeenye ʉMwana, looli Taata, pamo ʉjʉ ammeenye Taata looli ʉMwana, na gwesa ʉjʉ ʉMwana iiganile ʉkʉnnangɨsya.” ");
INSERT INTO nyy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Po Jesu alɨnkʉbasanukɨla abafundigwa baake, alɨnkʉbabʉʉla kʉbʉtiitʉ alɨnkʉtɨ, “Basajiigwe aba bikʉsibona ɨsi mukʉsibona! ");
INSERT INTO nyy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nalooli nikʉbabʉʉla nikʉtɨ, abakunguluka bingi na banyafyale baalondaga ʉkʉsibona ɨsi mukʉsibona ʉmwe, looli bakaasibwene. Kangɨ baalondaga ʉkʉpɨlɨka ɨsi mukʉsipɨlɨka ʉmwe, looli bakaasipɨliike.” ");
INSERT INTO nyy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Po ʉmmanyisi gwa ndagɨlo sya Moose jʉmo, alɨnkwɨma ʉkʉnndaalʉʉsya Jesu kʉnongwa jaa kʉnngela, alɨnkʉtɨ, “Gwe Mmanyisi, mbombe ɨfiki, ʉkʉtɨ ngabe ʉbʉʉmi bwa bwila na bwila?” ");
INSERT INTO nyy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Sisimbiigwe silɨkʉ mu ndagɨlo sya Moose? Ʉsyageenie bʉleebʉle?” ");
INSERT INTO nyy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ʉmmanyisi jʉla alɨnkwamula alɨnkʉtɨ, “Ʉnnganege ʉNtwa Kyala gwako nɨ ndumbula jaako joosa, nɨ mbepo jaako joosa, na maka gaako goosa, na mahala gaako goosa, kangɨ ʉbaganege abanino bo ʉlʉ gwijiiganile ʉgwe.” ");
INSERT INTO nyy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesu alɨnkʉtɨ, “Gwamwile kanunu! Ʉbombe bo lʉlʉʉlo, po kʉjaga nʉ bʉʉmi bwa bwila na bwila.” ");
INSERT INTO nyy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Looli ʉmmanyisi jʉla, aalondaga ʉkʉnangɨsya ʉkʉtɨ ngolofu, alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Po ʉmwinangʉ jo jwani?” ");
INSERT INTO nyy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉmundʉ jʉmo aafumile kʉ Jelusalemu, aasulukaga kʉkaaja kaa mu Jeeliko. Mu njɨla aalyaganiile nɨ minyambuta, gyalɨmfuulile ɨmyenda, gyalɨnkomile fiijo, gɨlɨnkʉnndeka bo alɨ kɨfuki ʉkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nakalɨnga ʉmpuuti jʉmo aasulukaga mu njɨla jɨla. Bo ammbwene ʉmundʉ jʉla aalyendile kʉmbalɨ. ");
INSERT INTO nyy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Joope ʉNnyaleebi, bo afikile pala, bo ammbwene ʉmundʉ jʉla, joope aalyendile kʉmbalɨ. ");
INSERT INTO nyy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Looli alɨnkwisa ʉNsamalija jʉmo, ʉjʉ endaga mu njɨla jɨla. Bo ammbwene ʉmundʉ jʉla, alɨnkʉmpelela ɨkɨsa, ");
INSERT INTO nyy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","alɨnkʉsegelela, alɨnkʉmpaka ɨfinga na mafuta mfilonda fyake, alɨnkʉmpinya nʉ mwenda. Alɨnkʉnkwesya pamwanya pa mbunda jaake, alɨnkʉntwala kʉ nyumba jaa baheesya, alɨnkʉnndwasya. ");
INSERT INTO nyy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Kɨlaabo kyake, aasoosiisye ɨndenali ibɨlɨ, alɨnkʉmpapo ʉmwene nyumba jɨla, alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Ʉnndwasye ʉmundʉ ʉjʉ. Lɨnga ɨndalama ɨsi sitikʉfwana, ngwisa kʉsoosya ɨsingi bo ngʉgomoka.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Po Jesu alɨnkʉnndaalʉʉsya ʉmmanyisi gwa ndagɨlo sya Moose jʉla alɨnkʉtɨ, “Bʉle, mmbandʉ batatʉ abo, jo jwani ʉnnine ʉgwa mundʉ ʉjʉ aalyaganiile nɨ minyambuta?” ");
INSERT INTO nyy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Alɨnkʉmmwamula alɨnkʉtɨ, “Ʉjʉ aalɨmpeliile ɨkɨsa.” Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Nungwe bʉʉkaga ʉkabombege bo lʉlʉʉlo!” ");
INSERT INTO nyy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesu na bafundigwa baake, bo balɨ mu njɨla bikʉbʉʉka kʉ Jelusalemu, balɨnkʉfika nkaaja kamo. Ʉnkiikʉlʉ jʉmo, ʉjʉ ɨngamu jaake aalɨ jo Maalita, aalɨmmwambɨliile Jesu pakaaja kaake. ");
INSERT INTO nyy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maalita aalɨ nʉ nnuguna, ɨngamu jaake aalɨ jo Malija. Ʉjo aatʉʉgeele nkyeni mwa Jesu, aapɨlɨkɨsyaga ɨsi aajobaga. ");
INSERT INTO nyy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Looli Maalita aapakanyikaga nɨ mbombo nyingi ɨsya kʉmmwambɨlɨla Jesu. Po alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Gwe Ntwa, ʉtikʉsibona ʉkʉja kabiibi, ʉlʉ ʉnnuguna gwangʉ aandekiile ngʉbomba niimwene? Po ʉmmbʉʉle andʉʉle!” ");
INSERT INTO nyy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ɄNtwa alɨnkʉmmwamula alɨnkʉtɨ, “Maalita, Maalita! Fiki kʉtaamigwa kʉnongwa jaa mbombo nyingi? ");
INSERT INTO nyy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kamokeene itolo kikʉlondigwa. Malija asalile akanunu ako, akanunu ako akajako najʉmo ʉgwa kwega.” ");
INSERT INTO nyy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ɨliisikʉ lɨmo Jesu aalɨ pabʉjo bʉmo iipuutaga. Bo amalile, ʉmfundigwa gwake jʉmo alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwe Ntwa ʉtʉmanyisye ʉkwipuuta, bo ʉlʉ Johani aabamanyiisye abafundigwa baake.” ");
INSERT INTO nyy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Bo mukwipuuta mutɨgɨ, ‘Taata gwɨtʉ ʉgwa kʉmwanya, ɨngamu jaako jɨɨmɨkigwege. ɄBʉnyafyale bwako bwisege. Ɨsi kʉlonda sibombigwege pakiisʉ apa, bo ʉlwa kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ʉtʉpege kʉkʉtɨ isikʉ ɨfindʉ fyɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ʉtʉswege ʉbʉtʉlanongwa bwɨtʉ, bo ʉlʉ nuuswe tukʉbaswa boosa aba bikʉtʉla ɨnongwa kʉmyɨtʉ. Ʉtwepʉsye mu ngelo, ʉtʉpoke kʉ mbiibi jʉla.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Po alɨnkʉbabʉʉla alɨnkʉtɨ, “Mbabʉʉle ɨkɨfwanikɨsyo. Ʉmundʉ jʉmo pakatɨ pamyɨnu, ikʉbʉʉka kʉ mmanyaani pakɨlo pakatɨ, ikʉmmbʉʉla ikʉtɨ, ‘Nkamu gwangʉ, ʉngopesye ɨfisyesye fitatʉ. ");
INSERT INTO nyy_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Paapo ʉmmanyaani gwangʉ alɨ nɨ njɨla, endile pamyangʉ, leelo ʉne ngaja nɨ findʉ ɨfya kʉmpa.’ ");
INSERT INTO nyy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ʉmmanyaani jʉla ikʉmmwamula ikʉtɨ, ‘Ʉngandaamyaga! Niigeeleko kʉ kɨfigo! Ʉne na baanangʉ tʉlambaleele. Ngabagɨla ʉkʉsumuka ʉkʉkʉpapo fimo!’ ");
INSERT INTO nyy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nikʉbabʉʉla, atikʉsumuka ʉkʉmpapo ɨfisyesye kʉnongwa jaa bʉmanyaani bwene, looli ikʉsumuka nʉ kʉmpapo fyosa ɨfi ikʉlonda kʉnongwa jaa mmanyaani ikʉʉmɨɨlɨla ʉkʉsʉʉma. ");
INSERT INTO nyy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Po nikʉbabʉʉla nikʉtɨ, musʉʉmege, mukʉpeeligwaga; mulondege, mukʉfyagaga; mukungʼundege kʉ lwigi, mukwigʉlɨligwaga. ");
INSERT INTO nyy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Paapo kʉkʉtɨ mundʉ ʉjʉ ikʉsʉʉma, ikʉpeeligwa, ʉjʉ ikʉlonda, ikʉfyaga, joope ʉjʉ ikʉkungʼunda, ikwigʉlɨligwa. ");
INSERT INTO nyy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kalɨ, jo jwani pakatɨ pamyɨnu, ʉjʉ ʉmwanaake ikʉsʉʉma ɨkɨsyesye, ikʉmpapo ɨliibwe? Pamo ikʉsʉʉma ɨɨswɨ, ikʉmpapo ɨnjoka? ");
INSERT INTO nyy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pamo lɨnga ikʉsʉʉma iifumbɨ, ikʉmpapo kaliisa? ");
INSERT INTO nyy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Po lɨnga ʉmwe mwe babiibi, mumeenye ʉkʉbapapo abaanɨɨnu ʉtʉndʉ ʉtʉnunu, bʉle, Taata ʉgwa kʉmwanya atikʉkɨndɨlɨla ʉkʉbapapo Mbepo Mwikemo aba bikʉnsʉʉma?” ");
INSERT INTO nyy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ɨliisikʉ lɨmo, Jesu aajɨkagaga mmundʉ ɨmbepo ɨnyali ɨjɨ jaalɨmpelile ʉkʉsita kʉjoba. Ɨmbepo jɨla bo jɨsookilemo, ʉmundʉ jʉla alɨnkwanda ʉkʉjoba. Ɨkɨlʉndɨlo kya bandʉ baaswigile fiijo. ");
INSERT INTO nyy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Looli abandʉ bamo pakatɨ pamyabo balɨnkʉtɨ, “Ikʉsikaga ɨmbepo ɨnyali kʉ maka agaa Belisebuli, ʉnkʉlʉmba gwa mbepo ɨnyali!” ");
INSERT INTO nyy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bamo balɨnkʉnngela Jesu, baalondaga ʉkʉtɨ abombe ɨkiika ʉkʉja kɨmanyilo ʉkʉnangɨsya ʉkʉtɨ atʉmiigwe na Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Looli Jesu alɨnkʉsimanya ɨnyiinogono syabo, po alɨnkʉbabʉʉla alɨnkʉtɨ, “Abandʉ abaa mbʉnyafyale bʉmo, lɨnga bikʉsambʉkana, ʉbʉnyafyale ʉbo bukʉfwa. Boope abaa nkɨkolo kɨmo, lɨnga basambʉkeene, ɨkɨkolo ɨkyo kikʉfwa. ");
INSERT INTO nyy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Lɨnga ʉbʉlongosi bwa Seetano bʉsambʉkeene, po bʉkabagɨla ʉkwɨma. Ngʉlɨjoba ɨlyo paapo mukʉtɨ ngʉsikaga ɨmbepo ɨnyali kʉ maka agaa Belisebuli. ");
INSERT INTO nyy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Lɨnga mukʉtɨ ʉne ngʉsikaga ɨmbepo ɨnyali kʉ maka agaa Belisebuli, abafundigwa bɨɨnu bikʉsikaga kʉ maka gaani? Abafundigwa bɨɨnu bikʉjaga balamuli bɨɨnu. ");
INSERT INTO nyy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Looli lɨnga nalooli ngʉsikaga ɨmbepo ɨnyali kʉ maka agaa Kyala, po ʉBʉnyafyale bwa Kyala bʉfikile kʉmyɨnu! ");
INSERT INTO nyy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ʉmundʉ ʉgwa maka, lɨnga alɨ nɨ filwɨlo kangɨ ikʉlɨndɨlɨla ɨnyumba jaake, ɨfyʉma fyake fikʉja kanunu itolo. ");
INSERT INTO nyy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Looli lɨnga iisile ʉmundʉ ʉgwa maka ʉkʉnkɨnda ʉmwene, ikʉntola, ikʉpoka ɨfilwɨlo fyake fyosa ɨfi aafisʉʉbɨlaga. Kangɨ ikwega ʉtʉndʉ toosa ʉtʉ tʉlimo nnyumba nʉ kʉbajabɨla abangɨ. ");
INSERT INTO nyy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ʉmundʉ gwesa ʉjʉ akaja na niine, ikʉpɨngana na niine, na ʉjʉ atikʉbʉngaania pamopeene na niine, ikʉbalania.” ");
INSERT INTO nyy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ɨmbepo ɨnyali bo jikʉsooka mmundʉ, jikʉbʉʉka ndʉngalangala kʉkʉlonda ʉbʉjo bwa kʉtʉʉsya, jɨtikʉbwaga. Po jikʉjoba jikʉtɨ, ‘Ngʉgomokelako kʉla kʉ nyumba jangʉ, kʉno naaliko.’ ");
INSERT INTO nyy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Lɨnga jɨgomwike, jikwaga ɨnyumba jɨpyagɨliigwe nʉ kʉtendekesigwa kanunu. ");
INSERT INTO nyy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Po jikʉbʉʉka kʉkʉsyega ɨmbepo ɨnyali ɨsingi ihaano na ibɨlɨ, ɨsi mbiibi ʉkʉjɨkɨndapo ɨjeene. Ɨmbepo ɨsyo syosa sikwingɨla nʉ kʉtʉʉgala mmundʉ ʉjo. Po akajɨɨlo kaa mundʉ ʉjo kikʉja kabiibi ʉkʉkɨnda ʉlʉtasi.” ");
INSERT INTO nyy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesu bo ikʉjoba ɨsyo, ʉnkiikʉlʉ jʉmo nkɨlʉndɨlo kɨla, alɨnkʉlaata ʉkʉjoba alɨnkʉtɨ, “Asajiigwe ʉnkiikʉlʉ ʉjʉ aakʉpaapile nʉ kʉkongesya!” ");
INSERT INTO nyy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Looli Jesu alɨnkwamula alɨnkʉtɨ, “Basajiigwe ʉkʉkɨndapo aba bikʉlɨpɨlɨka nʉ kʉlɨbombela iisyʉ lya Kyala!” ");
INSERT INTO nyy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Abandʉ bo bikongelela ʉkʉbʉngaana, Jesu alɨnkʉtɨ, “Ʉmwe mulɨ batʉlanongwa mukiigana ʉkʉmmanya Kyala! Ʉkeetege mukʉsʉʉma ɨkɨmanyilo! Mutikʉpeeligwa ɨkɨmanyilo nakɨmo, looli kyene ɨkɨmanyilo ɨkya nkunguluka Joona.” ");
INSERT INTO nyy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bo ʉlwa Joona aalɨ kɨmanyilo kʉ bandʉ baa nkaaja akaa mu Ninibe, bʉbʉʉbo Nnyamundʉ ikʉjaga kɨmanyilo kʉ bandʉ baa nkabalɨlo aka. ");
INSERT INTO nyy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Pi isikʉ lya bʉlongi, ʉmalafyale ʉnkiikʉlʉ ʉgwa kwitongo ikwisa kwɨma ʉkʉbabʉʉla mwe bandʉ baa nkabalɨlo aka, ʉkʉtɨ mulɨ babiibi. Ʉmwene aafumile nkiisʉ kya kʉbʉtali, aaliisile kʉkʉpɨlɨkɨsya amasyʉ gaa mahala agaa Solomoni. Apa lɨɨlɨno alipo ʉnkʉlʉmba ʉkʉnkɨnda Solomoni! ");
INSERT INTO nyy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pi isikʉ lya bʉlongi, boope abandʉ abaa mu Ninibe bikwisa kwɨma ʉkʉbabʉʉla, mwe bandʉ baa nkabalɨlo aka, ʉkʉtɨ mulɨ babiibi, paapo Joona bo alʉmbɨliile ɨliisyʉ lya Kyala kʉmyabo, baapɨndwike. Apa lɨɨlɨno alipo ʉnkʉlʉmba ʉkʉnkɨnda Joona!” ");
INSERT INTO nyy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Akajako ʉmundʉ ʉjʉ ikwasya ɨnyaale nʉ kʉjɨfisa pamo ʉkʉjɨkupɨkɨla nɨ kiibo. Looli ikʉjɨbɨɨka pa kɨkolela nyaale, ʉkʉtɨ abandʉ bo bikwingɨla, bagʉbonege ʉndangalɨla. ");
INSERT INTO nyy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Amaaso gaako gafwene bo ʉlwa nyaale ɨjɨ jikʉgʉmulɨkɨla ʉmbɨlɨ gwako. Amaaso gaako lɨnga galɨ kanunu, po ʉmbɨlɨ gwako goosa gukʉja nʉ ndangalɨla. Looli lɨnga amaaso gaako mabine, po ʉmbɨlɨ gwako gukʉja nɨ ngiisi. ");
INSERT INTO nyy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Po ʉje maaso, ʉndangalɨla ʉgʉ gʉlimo nkatɨ mmyako, gʉlɨngasanuka ʉkʉja ngiisi! ");
INSERT INTO nyy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Lɨnga ʉmbɨlɨ gwako goosa gwiswile ʉndangalɨla, kɨsita kʉja nɨ ngiisi napamo, apo ʉndangalɨla gukʉjaga poosa, bo ʉlwa nyaale ɨjɨ jikʉkʉmulɨka fiijo.” ");
INSERT INTO nyy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesu bo ajobile amasyʉ ago, ʉMfalisai jʉmo alɨnkʉnsʉʉma ʉkʉtɨ abʉʉke kʉmyake akalyemo. Po Jesu alɨnkʉbʉʉka, alɨnkʉtʉʉgala pakʉlya ɨfindʉ. ");
INSERT INTO nyy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ɄMfalisai jʉla aaswigile bo ammbwene Jesu ikʉlya kɨsita kʉsugusula bo muno bikʉlondeligwa ʉkʉsugusula aBajuuta. ");
INSERT INTO nyy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Po ʉNtwa alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉmwe mwe Bafalisai, mukʉsuka munyuma ɨndeko nɨ mbaale, looli nkatɨ mu ndumbula syɨnu, mwiswile ʉbʉʉfi nʉ bʉbiibi. ");
INSERT INTO nyy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mwe bakonyofu ʉmwe! Ʉjʉ aabʉmbile panja, akaja jo ʉjʉ aabʉmbile na nkatɨ? ");
INSERT INTO nyy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Po mubatʉʉlege abalondo nɨ ndumbula syɨnu syosa, po fyosa fikwelʉsigwa. ");
INSERT INTO nyy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ahɨɨli ʉmwe mwe Bafalisai! Paapo mukʉnsookesya Kyala ɨfya pi ilongo, ʉkʉfuma mfilʉngo ɨfya findʉ na maseeke. Looli mulekile ɨsya bʉgolofu nɨ sya lʉgano lwa Kyala. Mukʉlondigwa ʉkʉsibomba ɨsya bʉgolofu nʉ lʉgano, kɨsita kʉleka ʉkʉsoosya ɨfya pi ilongo. ");
INSERT INTO nyy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ahɨɨli ʉmwe mwe Bafalisai! Paapo mwiganile ʉkʉtʉʉgala pa fikota ɨfya bɨɨmɨkigwa mu ngomaano, nʉ kʉtɨ abandʉ babaponiege kʉ lwɨmɨko mu sokoni. ");
INSERT INTO nyy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ahɨɨli kʉmyɨnu! Paapo mufwene na mapʉmba aga gakaja nɨ kɨmanyilo, abandʉ bikwenda pamwanya pa mapʉmba ago kɨsita kʉmanya.” ");
INSERT INTO nyy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ʉmmanyisi jʉmo ʉgwa ndagɨlo sya Moose alɨnkʉtɨ, “Gwe Mmanyisi, ʉkʉjoba bo ʉlo, kʉtʉjoba kabiibi nuuswe, twe bamanyisi baa ndagɨlo sya Moose.” ");
INSERT INTO nyy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Na nuumwe mwe bamanyisi baa ndagɨlo sya Moose, ahɨɨli! Paapo mukʉbatwɨka abandʉ ɨfitwalo ɨfisito ʉkʉpɨmbigwa. Kangɨ ʉmwe mutikʉbatʉʉlapo ʉkʉpɨmba, koope nʉ kʉpalamaasyapo nɨ nyoobe syɨnu! ");
INSERT INTO nyy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Ahɨɨli kʉmyɨnu! Paapo mukʉjenga amapʉmba gaa bakunguluka, aba baagogiigwe na biisʉkʉlʉ bɨɨnu! ");
INSERT INTO nyy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Apo mukʉnangɨsya ʉkʉtɨ mukwitɨkana na ɨsi abiisʉkʉlʉ bɨɨnu baasibombile. Paapo abeene baabagogile abakunguluka, po ʉmwe mukʉjenga amapʉmba! ");
INSERT INTO nyy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Fyobeene Kyala ʉmwene mahala aatile, ‘Nikʉbatʉma abakunguluka na batʉmigwa kʉmyabo, bamo bikwakʉbagoga, abangɨ bikwakʉbafunda nɨ ngʉbɨlo.’ ");
INSERT INTO nyy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kʉnongwa ɨjo abandʉ baa nkabalɨlo aka bikwisa kʉlongigwa kʉnongwa jaa bakunguluka boosa aba baagogiigwe, ʉkʉfuma kʉbwandɨlo bwa kiisʉ, ");
INSERT INTO nyy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ʉkʉfuma ʉkʉgogigwa Aabeli, mpaka apa aagogiigwe Sakalija, ʉjʉ aagogiigwe mu tempeli pakatɨ pa Pabwikemo na pa kɨgemo. Nalooli nikʉbabʉʉla, abandʉ abaa nkabalɨlo aka bikwisa kʉlongigwa kʉnongwa jaa ɨsyo syosa. ");
INSERT INTO nyy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ahɨɨli mwe bamanyisi baa ndagɨlo sya Moose! Paapo musigiile ɨnjɨla jaa bandʉ ʉkʉmmanya Kyala. Na nuumwe mukammanya, kangɨ mubasigiile aba bikʉlonda ʉkʉmmanya.” ");
INSERT INTO nyy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesu bo asookilemo nnyumba jaa Mfalisai jʉla, aBafalisai na bamanyisi baa ndagɨlo sya Moose balɨnkwanda ʉkʉmpɨnga fiijo nʉ kʉnndaalʉʉsya Jesu sii nyingi itolo, ");
INSERT INTO nyy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kʉnongwa jaa kʉntega, ʉkʉtɨ pamo bankole mbʉjobi bwake. ");
INSERT INTO nyy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Akabalɨlo ako baabʉngeene abandʉ baelʉfu na baelʉfu, baakanyanaga. Jesu alɨnkwanda ʉkʉbabʉʉla taasi abafundigwa baake alɨnkʉtɨ, “Mujege maaso nʉ bʉsyobi ʉbwa Bafalisai, paapo bukʉbomba ɨmbombo ngatɨ nkese. ");
INSERT INTO nyy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Syosa ɨsi sifisiigwe sikwisa kʉbɨɨkigwa pabwelu, na ɨsi silɨ mbʉtiitʉ sikwisa kʉmanyigwa. ");
INSERT INTO nyy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Po ɨsi mujobile mu ngiisi, sikʉpɨlɨkigwaga pabwelu. Kangɨ ɨsi mukʉsipɨlɨka mbʉtiitʉ, sikʉfumusigwaga nkyeni mmbandʉ boosa.” ");
INSERT INTO nyy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mwe bamanyaani bangʉ, nikʉbabʉʉla nikʉtɨ, mungabatiilaga aba bikʉgʉgoga ʉmbɨlɨ, bo bagʉgogile bakabagɨla ʉkʉbomba ɨsingi. ");
INSERT INTO nyy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Looli nikʉbanangɨsya ʉjʉ mukʉlondigwa ʉkʉntiila, muntiilege ʉjʉ bo agogile ʉmundʉ, alɨ na maka agaa kʉntaaga ndʉpanga lwa mooto. Nalooli nikʉbabʉʉla, ʉjo jo muntiilege! ");
INSERT INTO nyy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Bʉle, baatʉndʉlʉ bahaano batikʉʉlɨsigwa kʉ senti ibɨlɨ? Poope Kyala atikʉmmwibwamo najʉmo. ");
INSERT INTO nyy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Syope nɨ nywili syosa ɨsya mmitʉ gyɨnu asibalile. Bʉle, ʉmwe kwa Kyala, mukaja bapala ʉkʉbakɨnda baatʉndʉlʉ? Po mulɨngatiilaga!” ");
INSERT INTO nyy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nikʉbabʉʉla nikʉtɨ, ʉmundʉ gwesa ʉjʉ ikʉjoba nkyeni mmbandʉ ʉkʉtɨ aanyiitiike ʉne, ne Nnyamundʉ ngwisa kʉmmwitɨkɨla nkyeni mbandʉmi baa Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Looli ʉmundʉ gwesa ʉjʉ ikʉngaana nkyeni mmbandʉ, ʉjo ngwisa kʉnkaana nkyeni mbandʉmi baa Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ʉmundʉ gwesa ʉjʉ ikʉntʉka Nnyamundʉ abagiile ʉkʉhobokeligwa. Looli ʉjʉ ikʉntʉka Mbepo Mwikemo, atikwisa kʉhobokeligwa. ");
INSERT INTO nyy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Bo bikʉbatwala mu sinagogi, kʉ bakʉlʉmba na kʉ balagɨli, mulɨngiipaakɨsyaga ɨsya kwamula pamo ɨsya kʉjoba, ");
INSERT INTO nyy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","paapo Mbepo Mwikemo ikʉbamanyisyaga akabalɨlo kalakala ɨsya kʉjoba.” ");
INSERT INTO nyy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ʉmundʉ jʉmo ʉgwa nkɨlʉndɨlo kɨla, alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Gwe Mmanyisi, mmbʉʉle ʉgwamyɨtʉ ʉkʉtɨ aanjabɨle ɨfya pa kɨlɨngo kyɨtʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Jo jwani ʉjʉ aambɨɨkile ʉne ʉkʉja ndamuli pamo ʉkʉja njabi gwɨnu?” ");
INSERT INTO nyy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Po alɨnkʉbabʉʉla alɨnkʉtɨ, “Mujege maaso, mungajaga bapafu, paapo ʉbʉʉmi bwa mundʉ bʉtikʉfuma mbwingi bwa tʉndʉ twake.” ");
INSERT INTO nyy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Po alɨnkʉbabʉʉla ɨkɨfwanikɨsyo ɨkɨ alɨnkʉtɨ, “Aalipo ʉnkabi jʉmo, ʉjʉ ʉngʉnda gwake gwalyelile. ");
INSERT INTO nyy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Alɨnkwinogona mu ndumbula jaake alɨnkʉtɨ, ‘Kalɨ, mbombe ɨfiki? Apa ngaja nʉ bʉjo ʉbwa kʉbɨɨkamo ɨfi ngʉtondolaga.’ ");
INSERT INTO nyy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Po alɨnkʉtɨ, ‘Ngʉbomba bo ʉlʉ, ngʉpangʉla ɨndamba syangʉ nʉ kʉjenga ɨndamba ɨsingi ɨnywamu ʉkʉkɨndapo. Ʉmo mo muno ngʉbɨɨka ʉntondolo gwangʉ goosa nʉ tʉndʉ twangʉ. ");
INSERT INTO nyy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Po ngwibʉʉlaga jʉjʉʉne ngʉtɨgɨ, “Ʉlɨ nʉ tʉndʉ twingi ʉtʉnunu ʉtʉ gwibɨɨkiile, ʉtwa kʉkʉtʉʉla ɨfyɨnja fingi. Tengaanaga, ʉlyege nʉ kʉnwa, ʉsaalege.” ’ ");
INSERT INTO nyy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Looli Kyala alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Gwe nkonyofu ʉgwe! Kʉfwa ɨkɨlo ɨkɨ! Po ʉtʉndʉ ʉtʉ gwibɨɨkiile, tukʉjaga twani?’ ");
INSERT INTO nyy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Bo sikʉjaga bo ʉlo kʉ mundʉ gwesa ʉjʉ ikwilʉndɨkɨla ɨkyʉma, kɨsita kʉbomba ɨsi ikʉlonda Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Po Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Kʉnongwa ɨjo nikʉbabʉʉla nikʉtɨ, mulɨngapaasyaga ɨsya bʉʉmi bwɨnu, ʉkʉtɨ mukʉlyaga ɨfiki, pamo ɨmibɨlɨ gyɨnu, ʉkʉtɨ mukʉfwalaga ɨfiki. ");
INSERT INTO nyy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Paapo ʉbʉʉmi bʉkʉlʉmba ʉkʉkɨnda ɨfindʉ, nʉ mbɨlɨ nkʉlʉmba ʉkʉkɨnda ɨmyenda. ");
INSERT INTO nyy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Amwinogone amakʉngʉʉlʉ. Gatikʉbyala nʉ kʉtondola, gakaja nɨ ndamba pamo ʉbʉjo ʉbwa kʉbɨɨkamo, leelo Kyala ikʉgaswɨla. Bʉle, ʉmwe mukaja bapala ʉkʉsikɨnda ɨnjʉni ɨsyo? ");
INSERT INTO nyy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Akajako najʉmo pakatɨ pamyɨnu ʉjʉ abagiile ʉkongelapo ʉbʉʉmi bwake nalɨnga isikʉ lɨmo, kʉ njɨla jaa kʉpaasya ɨsya bʉʉmi bwake. ");
INSERT INTO nyy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Lɨnga mukabagɨla ʉkʉbomba akandʉ akanandɨ bo ako, fiki mukwipaakɨsya kʉ singi? ");
INSERT INTO nyy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Mukeete ʉbʉlenge muno bukʉkʉlɨla. Bʉtikʉbomba ɨmbombo pamo ʉkwisonela ɨmyenda. Looli nikʉbabʉʉla nikʉtɨ, joope ʉmalafyale Solomoni mbʉsisya bwake boosa, akaafwelemo kanunu bo ʉbʉlenge ʉbo! ");
INSERT INTO nyy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Po lɨnga Kyala ikʉbʉfwɨka kanunu bo ʉlʉ ʉbʉlenge bwa ndiisʉ, ʉbʉ bʉlipo ʉmwisyʉgʉ, looli kɨlaabo bukʉsopigwa mmooto, bʉle atikʉkɨndapo ʉkʉbafwɨka, mwe baa lwitɨko ʉlʉnandɨ ʉmwe? ");
INSERT INTO nyy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Po mulɨngapaasyaga ʉkʉtɨ mukʉlyaga ɨfiki, pamo mukʉnwaga ɨfiki, kangɨ mulɨngajaga nʉ lʉtende kʉnongwa jaa ɨsyo. ");
INSERT INTO nyy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Paapo abandʉ aba bakammanya Kyala, bikwijʉʉla ʉkʉtʉlonda ʉtʉndʉ ʉto toosa, looli ʉGwiseemwe ʉgwa kʉmwanya ameenye ʉkʉtɨ ʉmwe mukʉlonda ʉto! ");
INSERT INTO nyy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Looli ʉmwe mubʉlondege ʉBʉnyafyale bwa Kyala, po nɨ singi syosa ikʉbongelapo.” ");
INSERT INTO nyy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mulɨngatiilaga, mwe baa nkatiimo akanandɨ, paapo ʉGwiseemwe iikyeliile ʉkʉbapa ʉBʉnyafyale bwake. ");
INSERT INTO nyy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mʉʉlɨsye ɨfi mulɨ nafyo, mubapepo abalondo. Ʉko ko kʉbɨɨka ɨndalama mfinyambɨ ɨfi fitikʉkʉʉlʉpa, ko kwibɨɨkɨla ɨkyʉma kʉmwanya ɨkɨ kɨtikʉmalɨka, kʉno ʉnhɨɨji atikʉsegelelako, na majenje gatikoonanga. ");
INSERT INTO nyy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kʉno mukʉbɨɨka ɨkyʉma kyɨnu, ko kʉno nɨ ndumbula syɨnu sikʉjaga.” ");
INSERT INTO nyy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mwitendekesye ngaani akabalɨlo koosa kʉlɨ syosa ɨsi sikʉboneka, nɨ nyaale syɨnu syakege. ");
INSERT INTO nyy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mujege bo ababombeli aba bikʉnnguulɨla ʉntwa gwabo ʉkʉgomoka ʉkʉfuma kʉ lʉsekelo. Bo afikile nʉ kʉkungʼunda kʉ lwigi, biise bammwigʉlɨle nakalɨnga. ");
INSERT INTO nyy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aasikʉja kanunu kʉ babombeli aba ʉntwa gwabo bo iisile, ikʉbaaga balɨ maaso. Nalooli nikʉbabʉʉla nikʉtɨ, ʉmwene ikwitendekesya nʉ kʉbakoolela ʉkʉtɨ batʉʉgale, ikʉbategelekesya ɨfindʉ, nʉ kʉbabombela bo bikʉlya. ");
INSERT INTO nyy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Po aasikʉja kanunu kʉ babombeli abo, ʉntwa gwabo lɨnga ikʉbaaga balɨ maaso, nalɨnga ikwisa pakɨlo pakatɨ, pamo kʉbʉkye. ");
INSERT INTO nyy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Musyaganie ɨsi ʉkʉtɨ, lɨnga ʉmwene nyumba aamanyaga akabalɨlo aka ʉnhɨɨji ikwisa, ngalɨ ikʉja maaso, akaabagiile ʉkʉjɨleka ɨnyumba jaake ʉkʉpangʉligwa. ");
INSERT INTO nyy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na nuumwe mwitendekesyege, paapo Nnyamundʉ ikwisa pakabalɨlo aka mutikʉsʉʉbɨla.” ");
INSERT INTO nyy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Po Peeteli alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Gwe Ntwa, ɨkɨfwanikɨsyo ɨkɨ, kʉtʉbʉʉla twibeene pamo abandʉ boosa?” ");
INSERT INTO nyy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ɄNtwa alɨnkʉtɨ, “Po jo jwani mwɨmɨlɨli ʉnsʉʉbɨligwa, ʉgwa mahala? Jo ʉjʉ ʉntwa gwake ikʉmmbɨɨka ʉkwɨmɨlɨla ababombeli banine, ʉkʉbapa ɨfindʉ pakabalɨlo kaake. ");
INSERT INTO nyy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aasikʉja kanunu kʉ mbombeli ʉjʉ bo ʉntwa gwake ikwisa, ikʉmmwaga ikʉbomba bo ʉlo. ");
INSERT INTO nyy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nalooli nikʉbabʉʉla, ikʉmmbɨɨka ʉmbombeli ʉjo ʉkʉja mwɨmɨlɨli gwa tʉndʉ twake toosa. ");
INSERT INTO nyy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Looli ʉmbombeli jʉla lɨnga ikwijobeesya mu ndumbula ikʉtɨ, ‘Ʉntwa gwangʉ akaabiile ʉkwisa,’ kangɨ lɨnga ikwanda ʉkʉbakoma ababombeli banine, ikʉlya nʉ kʉnwa nʉ kʉgaala, ");
INSERT INTO nyy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ʉntwa gwa mbombeli ʉjo ikwisa pi isikʉ ɨlɨ akaasʉʉbɨlaga na pakabalɨlo aka akakamanya. Ikwisa kʉmmbuutania nʉ kʉmmbɨɨka pabʉjo bʉmo na bandʉ aba bakaja bagolofu. ");
INSERT INTO nyy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ʉmbombeli ʉjʉ abʉmeenye ʉbwigane bwa ntwa gwake, looli akiitendekesya pamo akabomba bo muno ikʉlondela ʉntwa gwake, ʉjo ikwisa kʉkomigwa fiijo. ");
INSERT INTO nyy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Looli ʉmbombeli ʉjʉ akabʉmanya ʉbwigane bwa ntwa gwake, lɨnga abombile kabiibi, ʉjo ikwisa kʉkomigwa panandɨ. Kʉ mundʉ ʉjʉ apeeliigwe twingi, ʉjo ikwisa kʉmeleligwaga twingi. Kʉlɨ ʉjʉ apeeliigwe ʉkʉlɨndɨlɨla fingi, fikwisa kʉlondigwaga ɨfingi ʉkʉkɨndapo.” ");
INSERT INTO nyy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Niisile pakiisʉ apa ʉkwasya ʉmooto, naalondaga fiijo ngalɨ gwakile! ");
INSERT INTO nyy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ndɨ nɨ ngʉbɨlo ɨsya kʉkʉbɨlwa, ngʉtaamigwa mu ndumbula jangʉ mpaka simalɨke! ");
INSERT INTO nyy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Baatɨ, mukʉtɨ niisile nkiisʉ ʉkʉtwala ʉlʉtengaano? Hɨmma! Nikʉbabʉʉla nikʉtɨ, niisile ʉkʉtwala ʉkʉtapʉkana. ");
INSERT INTO nyy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ʉkʉfuma ʉlʉ, nnyumba jɨmo bikʉjangamo abandʉ bahaano aba batapʉkeene. Abandʉ batatʉ bikʉtapʉkanaga na bandʉ babɨlɨ, kangɨ abandʉ babɨlɨ bikʉtapʉkanaga na bandʉ batatʉ. ");
INSERT INTO nyy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ʉgwise ikʉtapʉkanaga nʉ mwanaake, joope ʉmwana nʉ gwise. Ʉnna ikʉtapʉkanaga nʉ mwanaake ʉndɨndwana, joope ʉndɨndwana nʉ nna. Ʉnkamwana ʉnkiikʉlʉ ikʉtapʉkanaga nʉ nkasi gwa mwanaake, joope ʉnkasi gwa mwanaake nʉ nkamwana ʉnkiikʉlʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesu alɨnkʉbabʉʉla kangɨ abandʉ abaa nkɨlʉndɨlo kɨla, alɨnkʉtɨ, “Lɨnga mukʉlɨbona iibɨngo likʉfyʉka ʉkʉfuma kʉbʉjongelo iisʉba, nakalɨnga mukʉtɨ, ‘Ɨfula jikʉja pakʉtima,’ nalooli jikʉtima. ");
INSERT INTO nyy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kangɨ lɨnga mukʉgʉbona ʉmbelo gukʉkula ʉkʉfuma ɨkɨbafu kya kwitongo, mukʉtɨ, ‘Gikʉja pakwanda amafuku,’ nalooli sikʉja bo ʉlo. ");
INSERT INTO nyy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mwe basyobi ʉmwe! Mumeenye ʉkʉfyagania ɨfimanyilo ɨfya pakiisʉ na mu mpaalanga. Po fiki mutoliigwe ʉkʉlɨngaania ɨsya nkabalɨlo aka?” ");
INSERT INTO nyy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Po fiki mukʉtoligwa ʉkʉsyagania ɨsya bʉgolofu? ");
INSERT INTO nyy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Lɨnga kʉbʉʉka nʉ ndʉgʉ gwako kʉ ndongi, bo mulɨ mu njɨla gwijʉʉlege ʉkʉtɨ mupɨlɨkɨsanie, ʉkʉtɨ alɨngakʉtwala kʉ ndongi, paapo ʉndongi ikʉkʉtwala kʉ nsikali, ʉnsikali ikʉkʉsopa mu nnyololo. ");
INSERT INTO nyy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nikʉkʉbʉʉla nikʉtɨ, ʉtikwisa kʉsooka nkatɨ mula mpaka ʉhombe fyosa, ɨfi kʉmeleligwa!” ");
INSERT INTO nyy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Akabalɨlo kalakala, abandʉ bamo aba baalipo pala, balɨnkʉmmbʉʉla Jesu ʉkʉtɨ ʉndongosi gwa Balooma Pilati aabagogile aBagalilai bamo, bo bikʉnsookesya Kyala iikemo, po iilopa lyabo lɨlɨnkooneka nʉ kongaana ni ikemo. ");
INSERT INTO nyy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Paapo baagogiigwe bo ʉlo, bʉle, mukwinogona ʉmwe ʉkʉtɨ baalɨ batʉlanongwa ʉkʉkɨnda aBagalilai boosa? ");
INSERT INTO nyy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mma! Looli nikʉbabʉʉla ʉmwe nikʉtɨ, lɨnga mutikʉpɨndʉka nuumwe mwesa mukwisa kʉpyutigwa! ");
INSERT INTO nyy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pamo abandʉ bala kalongo na lwele aba ɨkɨsonge ɨkya mu Siloamu kyabagwɨliile, baafwile. Bʉle, mukwinogona ʉkʉtɨ abeene baalɨ batʉlanongwa ʉkʉkɨnda abandʉ boosa abaa mu Jelusalemu? ");
INSERT INTO nyy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mma! Looli nikʉbabʉʉla nikʉtɨ, lɨnga mutikʉpɨndʉka, nuumwe mwesa mukwisa kʉpyutigwa.” ");
INSERT INTO nyy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Po Jesu alɨnkʉbabʉʉla ɨkɨfwanikɨsyo ɨkɨ, alɨnkʉtɨ, “Aalipo ʉmundʉ jʉmo ʉjʉ aabyele ʉnkʉjʉ mu ngʉnda gwake, po alɨnkʉbʉʉka nkʉtʉngʉla ɨseke sya nkʉjʉ, akaasyagilemo nasimo. ");
INSERT INTO nyy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Po alɨnkʉmmbʉʉla ʉmbombi gwa ngʉnda alɨnkʉtɨ, ‘Keeta! Ɨfyɨnja fitatʉ ɨfi ngwisa nkʉtʉngʉla ɨseke mu nkʉjʉ ʉgʉ, ndikʉsyaga ɨseke nasimo. Po gʉtumule! Fiki gukoonanga itolo ʉmfu?’ ");
INSERT INTO nyy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ʉmbombi jʉla alɨnkʉmmwamula alɨnkʉtɨ, ‘Gwe ntwa gwangʉ, gʉleke ɨkyɨnja ɨkɨ, ngʉlɨmɨlɨle nʉ kʉgʉtaagɨlɨla ɨndope. ");
INSERT INTO nyy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Lɨnga gukʉpa ɨseke ɨkyɨnja kya kɨlaabo, kanunu! Looli lɨnga gʉtikʉpa ɨseke, po kwisa kʉgʉtumula.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Po leelo Jesu aamanyisyaga mu sinagogi jɨmo pi isikʉ ɨlya pa Sabati. ");
INSERT INTO nyy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ʉmo aalimo ʉnkiikʉlʉ jʉmo, ʉjʉ aalɨ nɨ mbepo ɨnyali, ɨjɨ jaalɨntwaliile ʉboonywa, ɨfyɨnja kalongo na lwele. Ʉnkiikʉlʉ ʉjo aalɨ nɨ kyengeenyuma, aatoligwaga loosa ʉkwigolosya. ");
INSERT INTO nyy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesu bo ammbwene ʉnkiikʉlʉ jʉla, alɨnkʉnkoolela, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwe nkiikʉlʉ ʉgwe, gwabʉliigwe ʉboonywa bwako!” ");
INSERT INTO nyy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Alɨnkʉbɨɨkapo amaboko gaake pa nkiikʉlʉ jʉla, nakalɨnga alɨnkwɨma agolwike ɨnyuma, alɨnkʉntuufya Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Po ʉnkʉlʉmba gwa sinagogi alɨnkʉkalala, kʉnongwa jaa kʉtɨ Jesu ammbʉmbʉlwisye ʉmundʉ pi isikʉ ɨlya pa Sabati. Ʉnkʉlʉmba jʉla alɨnkʉbabʉʉla abandʉ aba baabʉngeene alɨnkʉtɨ, “Kʉlɨ na masikʉ ntandatʉ mu ndʉngʉ, agaa kʉbomba ɨmbombo. Mwisege kʉkʉbʉmbʉlʉsigwa mmasikʉ ago, somma pi isikʉ ɨlya pa Sabati!” ");
INSERT INTO nyy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ɄNtwa alɨnkʉmmwamula alɨnkʉtɨ, “Mwe basyobi ʉmwe! Bʉle, kʉkʉtɨ mundʉ atikʉbomba ɨmbombo ɨjaa kʉjaabʉla ndwama ɨngʼombe pamo ɨmbunda jaake, nʉ kʉjɨtwala kʉkʉnwa amɨɨsi, mmasikʉ gaa Sabati? ");
INSERT INTO nyy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Bʉle, ʉnkiikʉlʉ ʉjʉ ʉgwa ndʉjungu lwa Abulahamu, ʉjʉ aapinyiigwe na Seetano ɨfyɨnja kalongo na lwele, akabagɨsya ʉkwabʉligwa pi isikʉ ɨlya pa Sabati?” ");
INSERT INTO nyy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesu bo ajobile ɨsyo, silɨnkʉbakola ɨsoni boosa aba baapɨnganaga nagwe. Looli abangɨ boosa, balɨnkʉhoboka kʉnongwa jaa mbombo ɨsisya ɨsi aabombaga. ");
INSERT INTO nyy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Po Jesu alɨnkʉlaalʉʉsya alɨnkʉtɨ, “ɄBʉnyafyale bwa Kyala bʉfwene nɨ fiki? Mbʉfwanikɨsye nɨ fiki? ");
INSERT INTO nyy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bʉfwene na kaseke akaa iseeke ɨlya mutaka, aka ʉmundʉ aabyele mu ngʉnda gwake. Kalɨnkʉmela kalɨnkʉja mpiki, nɨ njʉni silɨnkʉtenga ɨfifufumbwa mu samba syake.” ");
INSERT INTO nyy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesu alɨnkʉlaalʉʉsya kangɨ alɨnkʉtɨ, “Mbʉfwanikɨsye nɨ fiki, ʉBʉnyafyale bwa Kyala? ");
INSERT INTO nyy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bʉfwene nʉ nkese ʉgʉ ʉnkiikʉlʉ jʉmo aalyongeenie nʉ bʉfu ɨfipɨmo fitatʉ, ʉbʉfu boosa bʉlɨnkʉtupa.” ");
INSERT INTO nyy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesu aabʉʉkaga kʉ Jelusalemu, alɨnkwenda ntwaja ʉtʉnywamu nʉ tʉnandɨ, aamanyisyaga. ");
INSERT INTO nyy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ʉmundʉ jʉmo alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Gwe ntwa, bʉle bikʉja banandɨ itolo abandʉ aba bikʉpokigwa?” Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ʉkwingɨla mBʉnyafyale bwa Kyala kʉlɨ bo ʉkwingɨla pa kɨfigo ɨkɨfinye. Nikʉbabʉʉla nikʉtɨ, bingi bikʉlondaga ʉkwingɨla, looli bikʉtoligwaga! Ʉmwe mwijʉʉle ʉkwingɨla ʉmo. ");
INSERT INTO nyy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bo ʉmwene nyumba iigeeleko ʉlwigi, po ʉmwe mukwɨmaga panja, mukwandaga ʉkʉkungʼunda kʉ kɨfigo mukʉtɨgɨ, ‘Gwe ntwa, twigʉlɨle!’ Looli ʉmwene ikwisa kwamulaga ʉkʉtɨ, ‘Ngabamanya ʉmwe na kʉno mufumile!’ ");
INSERT INTO nyy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na nuumwe mukwisa kʉmmwamulaga ʉkʉtɨ, ‘Ʉswe jo ʉswe twalyaga nʉ kʉnwa pamopeene na nungwe! Kangɨ ʉgwe gwatʉmanyisyaga ntwaja twɨtʉ!’ ");
INSERT INTO nyy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Looli ʉmwene ikwisa kʉjobaga ʉkʉtɨ, ‘Ngabamanya ʉmwe na kʉno mufumile! Sookapo apa, mwesa mwe babomba mbiibi ʉmwe!’ ");
INSERT INTO nyy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Po jikwisa kʉja nguuto nʉ kʉsyegetula amiino kʉnongwa jaa ndaamyo, bo mukʉmmbona Abulahamu, Isaka, Jaakobo na bakunguluka boosa mBʉnyafyale bwa Kyala, looli ʉmwe bo mutaagiigwe panja! ");
INSERT INTO nyy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kangɨ abandʉ aabikwisa ʉkʉfuma kʉfibafu fyosa ɨfya kiisʉ. Bikwisa kʉlya mBʉnyafyale bwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Keeta! Bamo aba bikwibona ʉkʉtɨ aabikʉjaga baa kʉmmalɨɨkɨsyo, bikʉjaga baa kwanda, na aba bikwibona ʉkʉtɨ aabikʉjaga baa kwanda, bikʉjaga baa kʉmmalɨɨkɨsyo.” ");
INSERT INTO nyy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Akabalɨlo kalakala aBafalisai bamo balɨnkʉbʉʉka kwa Jesu balɨnkʉmmbʉʉla balɨnkʉtɨ, “Sookapo apa, ʉbʉʉkege kʉbʉngɨ, paapo ʉmalafyale Heloti ikʉlonda ʉkʉkʉgoga.” ");
INSERT INTO nyy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Mubʉʉke mukakabʉʉle akambwe kala ʉkʉtɨ, ‘Keeta! Lɨɨlɨno na kɨlaabo, ngʉsikaga ɨmbepo ɨnyali nʉ kʉbʉmbʉlʉsya ababine, ɨliisikʉ lya bʉtatʉ ngʉmalɨɨsya ɨmbombo jangʉ. ");
INSERT INTO nyy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Looli mpaka nendelelege nɨ njɨla jaa kʉbʉʉka kʉ Jelusalemu ʉmwisyʉgʉ, kɨlaabo na palʉbʉnjʉ, mpaka mfike. Paapo sikʉlondigwa kʉkʉtɨ nkunguluka afwɨlege mu Jelusalemu, somma kʉbʉngɨ!’ ");
INSERT INTO nyy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Mwe bandʉ baa mu Jelusalemu, mwe bandʉ baa mu Jelusalemu! Mukʉbagoga abakunguluka nʉ kʉbatuunya na mabwe aba Kyala ikʉbatʉma kʉmyɨnu. Kalɨnga ndondile ʉkʉbabʉngaania pamopeene, bo ɨngʉkʉ ɨfyele ɨjɨ jikʉtʉbʉngaania ʉtwanaake nʉ kʉtʉʉbatɨla mmapɨko gaake? Looli ʉmwe mwakaanile! ");
INSERT INTO nyy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Keeta, Kyala ikwisa kʉbaleka ʉmwe, nɨ tempeli jɨɨnu jikwisa kʉja kɨsaame! Nikʉbabʉʉla nikʉtɨ, mutikʉʉmbonaga kangɨ mpaka pakabalɨlo aka mukwisa kʉjobaga ʉkʉtɨ, ‘Asajigwege ʉjʉ ikwisɨla mu ngamu jaa Ntwa Kyala.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ɨliisikʉ lɨmo ɨlya pa Sabati, Jesu aabʉʉkile kʉkʉlya ɨfindʉ kʉkaaja kaa ndongosi jʉmo ʉgwa Bafalisai. ABafalisai na bandʉ abangɨ, balɨnkʉntegelela ɨsi ikʉbomba. ");
INSERT INTO nyy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nkyeni mwa Jesu, aalipo ʉmundʉ jʉmo, ʉjʉ aalɨ nʉ bʉbine bwa kwisʉla ʉmbɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Po Jesu alɨnkʉbalaalʉʉsya aBafalisai na bamanyisi baa ndagɨlo sya Moose, alɨnkʉtɨ, “Bʉle, ɨndagɨlo sya Moose siitɨkiisye ʉkʉbʉmbʉlʉsya abandʉ pi isikʉ ɨlya pa Sabati, pamo mma?” ");
INSERT INTO nyy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Looli abeene balɨnkʉja kɨmyemye. Jesu alɨnkʉmpalamaasya ʉmbine jʉla, alɨnkʉmmbʉmbʉlʉsya, alɨnkʉmmwitɨkɨsya ʉkʉsookapo pala. ");
INSERT INTO nyy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Po Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Jo jwani pakatɨ pamyɨnu, ʉmwanaake pamo ɨngʼombe jaake lɨnga jɨsolokiile nkiina pi isikʉ ɨlya pa Sabati, atikʉfyʉla nakalɨnga?” ");
INSERT INTO nyy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Abandʉ bala balɨnkʉtoligwa ɨsya kwamula. ");
INSERT INTO nyy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesu bo ababwene abaheesya aba baapaaliigwe, bikwisalɨla ɨfikota ɨfya bɨɨmɨkigwa, alɨnkʉbabʉʉla ɨkɨfwanikɨsyo alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Lɨnga ʉmundʉ akʉpaalile pa lʉsekelo, ʉlɨngatʉʉgalaga pabʉjo ʉbwa bɨɨmɨkigwa, paapo lʉmo apaaliigwe ʉmwɨmɨkigwa ʉkʉkʉkɨnda ʉgwe. ");
INSERT INTO nyy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ʉjʉ abapaalile ikwisa kʉkʉbʉʉla ʉkʉtɨ, ‘Mwepʉkɨle ʉjʉ apa.’ Po kʉsookangapo nɨ soni ʉkʉbʉʉka kʉkʉtʉʉgala pabʉjo ʉbʉfujufu. ");
INSERT INTO nyy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Looli lɨnga ʉpaaliigwe kʉkʉlyamo, ʉtʉʉgalege pabʉjo ʉbʉ bʉkaja bwɨmɨkigwa, ʉkʉtɨ bo iisile ʉjʉ abapaalile, kʉmyako atɨgɨ, ‘Mmanyaani gwangʉ, isaga ʉtʉʉgale kʉbʉjo ʉbwa bɨɨmɨkigwa.’ Po kwɨmɨkigwaga nkyeni mmbandʉ boosa aba batʉʉgeele pamopeene na nungwe. ");
INSERT INTO nyy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Paapo kʉkʉtɨ mundʉ ʉjʉ ikwijiinʉla, ikʉsulusigwaga na Kyala, ʉmundʉ gwesa ʉjʉ ikwisulusya, ikwinʉligwaga na Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesu alɨnkʉmmbʉʉla ʉjʉ aalɨmpaalile kʉkʉlya alɨnkʉtɨ, “Lɨnga kʉtendekesya ɨfindʉ fya pamuusi pamo namajolo, ʉlɨngabakoolelaga abamanyaani baako pamo abaamyɨnu, pamo abakamu baako, pamo abapalamani baako abakabi, ʉkʉtɨ boope bangiisa kʉkʉpaala nungwe ʉkʉkʉhomba ɨsi gwababombiile. ");
INSERT INTO nyy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Looli lɨnga kʉtendekesya ɨfindʉ fya lʉsekelo, ʉbapaalege abalondo, aba bikʉkwema, abalemale na bafwa maaso. ");
INSERT INTO nyy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Po ʉgwe kʉsajigwa, paapo abo bakaja nɨ fya kʉkʉhomba. Kwisa kʉhombigwa na Kyala bo bikʉsyʉka abagolofu.” ");
INSERT INTO nyy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ʉmundʉ jʉmo ndɨ bala baatʉʉgeele pakʉlya ɨfindʉ, bo apɨliike ɨsyo, alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Asajiigwe ʉmundʉ ʉjʉ ikwisa kʉlya mBʉnyafyale bwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesu alɨnkwamula alɨnkʉtɨ, “Aaliko ʉmundʉ jʉmo ʉjʉ aatendekiisye ɨfindʉ fya lʉsekelo ʉlʉnywamu, alɨnkʉbapaala abandʉ abingi. ");
INSERT INTO nyy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Akabalɨlo kaa findʉ bo kafikile, alɨnkʉntʉma ʉmbombeli gwake, kʉkʉbabʉʉla abandʉ aba aabapaalile ʉkʉtɨ, ‘Mwisege, fyosa fitendekesiigwe!’ ");
INSERT INTO nyy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Looli boosa aba aabapaalile, kʉkʉtɨ mundʉ alɨnkwanda ʉkʉjoba ɨsi sikʉnsigɨla ʉkʉbʉʉka. Ʉgwa kwanda alɨnkʉjoba alɨnkʉtɨ, ‘Nʉʉlile ʉngʉnda, ngʉlondigwa ʉkʉtɨ mbʉʉke ngagʉkeete, ngʉsʉʉma ʉhobokele, ndikwisa.’ ");
INSERT INTO nyy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ʉjʉngɨ alɨnkʉjoba alɨnkʉtɨ, ‘Nʉʉlile ɨngʼombe kalongo ɨsya kʉlɨmɨla, nsumwike nkʉsigela, ngʉsʉʉma ʉhobokele, ndikwisa.’ ");
INSERT INTO nyy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ʉjʉngɨ alɨnkʉjoba alɨnkʉtɨ, ‘Naalɨ pakwega ʉnkiikʉlʉ, po ngabagɨla ʉkwisa.’ ");
INSERT INTO nyy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ʉmbombeli jʉla alɨnkʉgomoka, alɨnkʉmpangɨla sisiisi ʉntwa gwake. Po ʉntwa gwa nyumba jɨla alɨnkʉkalala, alɨnkʉmmbʉʉla ʉmbombeli gwake alɨnkʉtɨ, ‘Sooka panja mbɨbɨmbɨbɨ, ʉbʉʉke mmisebo na mu njɨla ɨsya nkaaja, ʉkabatwale abalondo, aba bikʉkwema, abafwa maaso na balemale.’ ");
INSERT INTO nyy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Piitaasi ʉmbombeli jʉla alɨnkʉgomoka, alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Ntwa, mbombile ɨsi gʉʉndagiile, leelo ʉbʉjo bʉkaalɨ bʉlipo.’ ");
INSERT INTO nyy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ʉntwa alɨnkʉmmbʉʉla ʉmbombeli alɨnkʉtɨ, ‘Sooka panja, ʉbʉʉke mmisebo na mu njɨla ɨsya mmigʉnda, ʉkabafimbɨlɨsye abandʉ ʉkwisa, ʉkʉtɨ ɨnyumba jangʉ jiisʉle abandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nikʉbabʉʉla ʉmwe nikʉtɨ, abandʉ bala naabapaalile kʉbwandɨlo, atikonjapo najʉmo ɨfindʉ fyangʉ!’ ” ");
INSERT INTO nyy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesu aalongeseenie nɨ kɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ. Po alɨnkʉsanuka, alɨnkʉbabʉʉla alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Lɨnga ʉmundʉ ikwisa kʉmyangʉ, ikʉlondigwa ʉkʉʉngana ʉne, ʉkʉkɨnda ʉgwise, ʉnna, ʉnkasi, abaanaake, na bakamu abanyambala na bakiikʉlʉ. Kangɨ ikʉlondigwa ʉkʉʉngana ʉne ʉkʉbʉkɨnda ʉbʉʉmi bwake. Lɨnga atoliigwe ʉkʉbomba bo ʉlo, ʉjo akabagɨsya ʉkʉja mfundigwa gwangʉ. ");
INSERT INTO nyy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Gwesa ʉjʉ atikʉngonga nʉ kʉtaamigwa, nalɨnga ko kʉfwa pa kɨkohekano, akabagɨsya ʉkʉja mfundigwa gwangʉ. ");
INSERT INTO nyy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Lɨnga jʉmo pakatɨ pamyɨnu, ikʉlonda ʉkʉjenga ɨkɨsonge, ikʉbomba bʉleebʉle? Bʉle, atikʉtʉʉgala taasi ʉkʉmanya ʉntengo, ʉkʉtɨ amanye ʉkʉtɨ ɨkyʉma kyake kɨbagiile ʉkʉmalɨɨsya ʉkʉjenga? ");
INSERT INTO nyy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Paapo lɨnga ajengile ʉlwalo, leelo atoliigwe ʉkʉmalɨɨsya ʉkʉjenga ɨkɨsonge, abandʉ boosa aba bikʉkɨbonaga ɨkɨsonge bikʉnsekaga. ");
INSERT INTO nyy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Bikʉtɨgɨ, ‘Ʉmundʉ ʉjʉ aalyandile ʉkʉjenga, looli atoliigwe ʉkʉmalɨɨsya!’ ");
INSERT INTO nyy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Pamo lɨnga ʉmalafyale ikʉlonda ʉkʉlwa ʉbwite nʉ malafyale ʉjʉngɨ, ikʉbomba bʉleebʉle? Bʉle, atikʉtʉʉgala taasi nʉ kwinogona, lɨnga abagiile ʉkʉlwa nʉ malafyale ʉjʉ alɨ na basikali 20,000, bo ʉmwene alɨ nabo abasikali 10,000 itolo? ");
INSERT INTO nyy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Lɨnga aagile akabagɨla ʉkʉlwa nagwe, bo abalʉgʉ balɨ kʉbʉtali, ʉmwene ikʉbatʉma abandʉ baa kwakwaganila nʉ malafyale ʉnnine, kʉkʉnsʉʉma ʉkʉtɨ bapɨlɨkɨsanie ɨsya kʉtwala ʉlʉtengaano. ");
INSERT INTO nyy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Ʉkʉfwana bo sisiisyo, ʉmundʉ gwesa pakatɨ pamyɨnu ʉjʉ atikʉfileka fyosa ɨfi alɨ nafyo, akabagɨsya ʉkʉja mfundigwa gwangʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ʉmuunyu nnunu, looli ʉmuunyu lɨnga gʉsʉʉkile, ʉbagiile bʉleebʉle ʉkʉgomokesyamo ʉbʉnunu? ");
INSERT INTO nyy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gʉkaja na mbombo najɨmo ʉkʉtendekesya ʉmfu ʉkʉja nnunu, abandʉ bikʉgʉtaaga itolo. Ʉjʉ alɨ nɨ mbʉlʉkʉtʉ ɨsya kʉpɨlɨkɨla, jo apɨlɨkege!” ");
INSERT INTO nyy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Iisikʉ lɨmo, abasongesya songo na bafujufu bingi, baasegelelaga kwa Jesu ʉkʉtɨ bampɨlɨkɨsye. ");
INSERT INTO nyy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Po aBafalisai na bamanyisi baa ndagɨlo sya Moose, balɨnkwijobeesya balɨnkʉtɨ, “Ʉmundʉ ʉjʉ ikʉbambɨlɨla abatʉlanongwa, kangɨ ikʉlya nabo.” ");
INSERT INTO nyy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Po Jesu alɨnkʉbabʉʉla ɨkɨfwanikɨsyo ɨkɨ, alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Jo jwani pakatɨ pamyɨnu ʉjʉ alɨ nɨ ngʼoosi ɨmia jɨmo, lɨnga jɨmo jɨsobile, atikʉsileka ɨngʼoosi 99 ndiisʉ, ʉkʉtɨ akajɨlonde ɨjɨ jɨsobile mpaka ajaage? ");
INSERT INTO nyy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bo ajaagile, ikʉjɨbagala nʉ lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Bo afikile kʉmyake, ikʉbapaala abamanyaani na bapalamani, ikʉtɨ, ‘Namusekelege pamopeene na niine, paapo ɨngʼoosi jangʉ ɨjɨ jaasobile, njaagile!’ ");
INSERT INTO nyy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Nikʉbabʉʉla nikʉtɨ, bo lʉlʉʉlo lukʉjaga lʉsekelo kʉmwanya, kʉnongwa jaa ntʉlanongwa jʉmo ʉjʉ apɨndwike, ʉkʉkɨnda ʉlʉsekelo kʉnongwa jaa bandʉ bala 99, aba bakaja batʉlanongwa.” ");
INSERT INTO nyy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Pamo ʉnkiikʉlʉ ʉjʉ alɨ nɨ ndalama kalongo, asobiisye ʉlʉtalama lʉmo, ikʉbomba bʉleebʉle? Bʉle, atikwasya ɨnyaale nʉ kʉpyagɨla nnyumba, nʉ kʉjɨlonda fiijo mpaka ajaage? ");
INSERT INTO nyy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bo alwagile, ikʉbapaala abamanyaani na bapalamani, ikʉtɨgɨ, ‘Amusekelege pamopeene na niine, paapo ʉlʉtalama lwangʉ ʉlʉ lwasobile, ndwagile!’ ");
INSERT INTO nyy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Nikʉbabʉʉla nikʉtɨ, bo lʉlʉʉlo abandʉmi baa Kyala balɨ nʉ lʉsekelo ʉlʉkʉlʉmba fiijo, kʉnongwa jaa ntʉlanongwa jʉmo ʉjʉ apɨndwike.” ");
INSERT INTO nyy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesu alɨnkwendelela ʉkʉbabʉʉla alɨnkʉtɨ, “Aaliko ʉmundʉ jʉmo, ʉjʉ aalɨ na baana babɨlɨ abalʉmyana. ");
INSERT INTO nyy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ʉnnandɨ alɨnkʉmmbʉʉla ʉgwise alɨnkʉtɨ, ‘Taata, ʉʉnjabɨle ɨkyʉma kya kɨlɨngo kyangʉ.’ Po ʉgwisabo alɨnkʉbajabania ɨkyʉma abaanaake bobabɨɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Bo gakakɨndapo amasikʉ mingi, ʉnnandɨ jʉla alɨnkʉbʉngaania fyosa ɨfi alɨ nafyo, alɨnkwenda ɨnjɨla jaa kʉbʉʉka nkiisʉ ɨkya kʉbʉtali. Ʉko alɨnkwakʉbululusya ɨkyʉma kyake mu mbombo sya bwalangani. ");
INSERT INTO nyy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bo amalile ʉkʉbombela kyosa, ɨnjala ɨngʉlʉmba jɨlɨnkʉgwa nkiisʉ kɨla, alɨnkʉja ndondo. ");
INSERT INTO nyy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Po alɨnkʉbʉʉka kʉ mwenekaaja jʉmo ʉgwa nkiisʉ kɨla, alɨnkʉnsʉʉma ɨmbombo. Ʉmundʉ jʉla alɨnkʉntʉma mu ngʉnda gwake, ʉkʉtɨ atiimege ɨngʉlʉbe. ");
INSERT INTO nyy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ʉndʉmyana jʉla aalɨ nɨ njala, mpaka alɨnkʉnyonywa ʉkʉlya amakandi aga syalyaga ɨngʉlʉbe, poope najʉmo akaalɨmpeelepo ɨfindʉ ɨfya kʉlya. ");
INSERT INTO nyy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Bo asyageenie alɨnkʉtɨ, ‘Ababomba mbombo baa taata balɨnga, bikʉlya nʉ kʉsyasya, looli ʉne ngʉfwa nɨ njala! ");
INSERT INTO nyy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ʉne ngʉbʉʉka kwa taata, ngwakʉmmbʉʉla ngwakʉtɨ, “Taata, ndʉlile ɨnongwa kwa Kyala na kʉmyako. ");
INSERT INTO nyy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngabagɨsya ʉkʉja mwanaako, ʉʉmbɨɨke ʉkʉja jʉmo mbabomba mbombo baako.” ’ ");
INSERT INTO nyy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Po paapo alɨnkʉsookapo alɨnkʉbʉʉka kʉ gwise. Bo alɨ kɨfuki na pakaaja, ʉgwise alɨnkʉmmbona, alɨnkʉmpelela ɨkɨsa, alɨnkʉbopa, alɨnkʉmmʉʉbatɨla, alɨnkʉmfipa. ");
INSERT INTO nyy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ʉmwanaake jʉla, alɨnkʉmmbʉʉla ʉgwise alɨnkʉtɨ, ‘Taata, ndʉlile ɨnongwa kwa Kyala na kʉmyako. Ngabagɨsya ʉkʉja mwanaako.’ ");
INSERT INTO nyy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Looli ʉgwise alɨnkʉbabʉʉla ababombeli baake alɨnkʉtɨ, ‘Namutwale mbɨbɨmbɨbɨ ʉmwenda ʉnnunu, mumfwɨke. Mumfwɨke na kakʉba ndoobe, nɨ filato mmalʉndɨ. ");
INSERT INTO nyy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Namutwale ɨndama ɨjɨ jɨtupile, muboole, tʉlye nʉ kʉsekela. ");
INSERT INTO nyy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Paapo ʉmwanangʉ ʉjʉ aafwile, lɨɨlɨno asyʉkile; aasobile, lɨɨlɨno aboniike!’ Po balɨnkwanda ʉkʉsekela. ");
INSERT INTO nyy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Akabalɨlo ako ʉmwanaake ʉnkʉlʉmba aalɨ mu ngʉnda. Alɨnkʉbʉʉka kʉkaaja. Bo alɨ kɨfuki nɨ nyumba, alɨnkʉpɨlɨka akoogo kaa nyɨmbo na bandʉ ʉkʉmoga. ");
INSERT INTO nyy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Alɨnkʉnkoolela ʉmbombeli jʉmo, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, ‘Filiko ɨfiki?’ ");
INSERT INTO nyy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Ʉnnugunago iisile, ʉgʉʉso ankomiile ɨndama ɨndupe, paapo ammwambɨliile ʉmwanaake ʉnkafu itolo.’ ");
INSERT INTO nyy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ʉmwanaake ʉnkʉlʉmba jʉla alɨnkʉkalala, alɨnkʉkaana ʉkwingɨla nnyumba. Po ʉgwise alɨnkʉsooka panja alɨnkʉntengʉlɨla. ");
INSERT INTO nyy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Looli ʉmwene alɨnkʉmmwamula ʉgwise alɨnkʉtɨ, ‘Keeta ɨfyɨnja fingi ngʉbombiile, ngakilaniamo sikʉ ɨndagɨlo syako! Ʉkambamo ʉne sikʉ na kapeene, ʉkʉtɨ mbɨɨkepo ʉlʉsekelo na bamanyaani bangʉ. ");
INSERT INTO nyy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Looli bo iisile ʉmwanaako ʉjʉ abululwisye ɨkyʉma kyako na baa malaja, gʉnkomiile ɨndama ɨndupe!’ ");
INSERT INTO nyy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ʉgwise alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Mwanangʉ, ʉgwe bwila ʉlɨ pamopeene na niine, fyosa ɨfi ndɨ nafyo fyako. ");
INSERT INTO nyy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Lɨɨlɨno tʉtile tʉsekele nʉ kʉmoga, paapo ʉnnugunago ʉjʉ aafwile, lɨɨlɨno asyʉkile. Aasobile, lɨɨlɨno aboniike!’ ” ");
INSERT INTO nyy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Aaliko ʉmundʉ jʉmo ʉnkabi, ʉjʉ aalɨ nʉ mwɨmɨlɨli gwa kyʉma kyake. Ʉnkabi jʉla balɨnkʉmmbʉʉla ʉkʉtɨ ʉmwɨmɨlɨli ikʉbululusya ɨkyʉma kyake. ");
INSERT INTO nyy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Po ʉnkabi alɨnkʉnkoolela ʉmwɨmɨlɨli, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, ‘Silɨ bʉleebʉle ɨnongwa ɨsi ngʉpɨlɨka bikʉkʉjoba? Mbalɨla ɨkyʉma kyangʉ ɨkɨ kwɨmɨlɨla! Ʉkabagɨsya ʉkʉja mwɨmɨlɨli kangɨ!’ ");
INSERT INTO nyy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ʉmwɨmɨlɨli jʉla alɨnkwinogona mu ndumbula alɨnkʉtɨ, ‘Mbombe bʉleebʉle? Paapo ʉntwa gwangʉ ikʉlonda ʉkʉʉsoosyapo ʉkʉja mwɨmɨlɨli. Ʉkʉlɨma ngaja na maka, ʉkʉsʉʉma sya soni. ");
INSERT INTO nyy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mmeenye ɨsi ngʉja pakʉbomba, ʉkʉtɨ bo ngagiigwe mbwɨmɨlɨli, abandʉ baanyambɨlɨlege nnyumba syabo.’ ");
INSERT INTO nyy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Po alɨnkʉbakoolela jʉmoojʉmo aba ʉntwa gwake ikʉbamelela. Alɨnkʉnndaalʉʉsya ʉgwa kwanda alɨnkʉtɨ, ‘Kʉmeleligwa filɨnga nʉ ntwa gwangʉ?’ ");
INSERT INTO nyy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Alɨnkwamula alɨnkʉtɨ, ‘Amapiipa agaa mafuta amalongo mabɨlɨ.’ Ʉmwɨmɨlɨli alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Ega kalata gwako, tʉʉgala mbɨbɨmbɨbɨ, ʉsimbe kalongo.’ ");
INSERT INTO nyy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Po alɨnkʉnndaalʉʉsya ʉgwa bʉbɨlɨ alɨnkʉtɨ, ‘Ʉgwe kʉmeleligwa filɨnga?’ Alɨnkwamula alɨnkʉtɨ, ‘Ɨfinyambɨ ɨmia jɨmo ɨfya nganu.’ Ʉmwɨmɨlɨli jʉla alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Ega kalata gwako, ʉsimbe amalongo lwele.’ ");
INSERT INTO nyy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ʉntwa jʉla alɨnkʉsyagania ɨsi aabombile ʉmwɨmɨlɨli ʉnsyobi jʉla, alɨnkʉntuufya paapo aabombile na mahala. Namanga abandʉ abaa nkabalɨlo aka, bikʉbomba ɨmbombo syabo na mahala ʉkʉbakɨnda aba bikʉmmwitɨka Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nikʉbabʉʉla nikʉtɨ, ɨkyʉma kya pakiisʉ apa kikʉmalɨka. Mubombelege ɨkyʉma ɨkyo ʉkʉbatʉʉla abangɨ, po mukʉkabaga abamanyaani. Po Kyala ikwisa kʉbambɨlɨlaga ʉmwe pabʉjo bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ʉmundʉ gwesa ʉnsʉʉbɨligwa ntʉndʉ ʉtʉnandɨ, ikʉja nsʉʉbɨligwa ntʉndʉ ʉtʉnywamu. Ʉmundʉ gwesa ʉjʉ akaja ngolofu ntʉndʉ ʉtʉnandɨ, moope ntʉndʉ ʉtʉnywamu atikʉja ngolofu. ");
INSERT INTO nyy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Po lɨnga mukaja basʉʉbɨligwa ʉkwɨmɨlɨla ɨkyʉma kya pakiisʉ, jo jwani ikʉbasʉʉbɨlaga ʉkwɨmɨlɨla ɨkyʉma kya bwila na bwila? ");
INSERT INTO nyy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kangɨ lɨnga mukaja basʉʉbɨligwa pa kyʉma kya mundʉ ʉjʉngɨ, jo jwani ʉgwa kʉbapa ɨkɨ kyo kyɨnu jʉjʉʉmwe? ");
INSERT INTO nyy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Akajako ʉmbombeli ʉjʉ abagiile ʉkʉbabombela abatwa babɨlɨ. Bʉno ikʉmmbenga jʉmo nʉ kʉnngana ʉjʉngɨ, pamo ikʉmmwɨmɨkaga jʉmo nʉ kʉmmwila ʉjʉngɨ. Mukabagɨla ʉkʉmmbombela Kyala kʉno mukʉkɨbombela ɨkyʉma!” ");
INSERT INTO nyy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Po aBafalisai, aba baalɨ bagana ndalama, bo bapɨliike ɨsyo syosa, balɨnkʉmmyalisya Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉmwe, mukwinangɨsya ʉkʉja bagolofu nkyeni mmbandʉ, looli Kyala asimeenye ɨndumbula syɨnu. Paapo ɨsi abandʉ bikʉsyɨmɨka, sikʉnkalasya Kyala!” ");
INSERT INTO nyy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ɨndagɨlo sya Moose na masimbo gaa bakunguluka, fyabalongwisye abandʉ mpaka pakabalɨlo kaa Johani ʉMoosi. Ʉkʉfuma pakabalɨlo ako, ɨNdʉmi ɨNunu ɨjaa Bʉnyafyale bwa Kyala jikʉlʉmbɨlɨligwa, kʉkʉtɨ mundʉ ikwingɨla mBʉnyafyale kʉ maka. ");
INSERT INTO nyy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Looli kʉpepe ʉkoomoka ʉmpaalanga nɨ kiisʉ, ʉkʉkɨnda ʉkoomoka akasyʉ kamo akaa ndagɨlo. ");
INSERT INTO nyy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ʉmundʉ gwesa ʉjʉ anndekile ʉnkasi nʉ kwega ʉnkiikʉlʉ ʉjʉngɨ, ikʉlogwa. Joope na ʉjʉ ikʉmmwega ʉnkiikʉlʉ ʉjʉ alekiigwe nʉ ndʉme, ikʉlogwa.” ");
INSERT INTO nyy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Akabalɨlo kamo aaliko ʉmundʉ jʉmo ʉnkabi, ʉjʉ aafwalaga ɨmyenda ɨgya ntengo, kangɨ aalyaga ɨfindʉ ɨfinunu amasikʉ goosa. ");
INSERT INTO nyy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pa kɨfigo kya nkabi jʉla, bammbɨɨkaga ʉndondo jʉmo ɨngamu jaake Laasalo, aalɨ nɨ filonda ʉmbɨlɨ goosa. ");
INSERT INTO nyy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Laasalo alɨnkʉnyonywa ʉkʉlya ʉtʉbululukɨsya twa findʉ ʉtʉ twasatʉkaga ʉkʉfuma pa meesa jaa nkabi jʉla, syope ɨmbwa siisaga kʉkʉmyanda ɨfilonda fyake. ");
INSERT INTO nyy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Akabalɨlo kalɨnkʉfika aka ʉndondo jʉla alɨnkʉfwa, abandʉmi balɨnkʉmmwega, balɨnkwakʉntʉʉgasya kʉmwanya kɨfuki na Abulahamu. Joope ʉnkabi jʉla alɨnkʉfwa, balɨnkʉnsyɨla. ");
INSERT INTO nyy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bo ʉnkabi ikʉtaamigwa kʉ ngolongo, alɨnkʉkeeta kʉmwanya, alɨnkʉmmbona Abulahamu kʉbʉtali, na Laasalo alɨ kɨfuki nagwe. ");
INSERT INTO nyy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Alɨnkʉnkoolela alɨnkʉtɨ, ‘Gwe taata Abulahamu, ʉlɨɨmbaakɨsya ʉne, ʉntʉme Laasalo, ajubɨke ʉloobe lwake mmɨɨsi kʉ sulo, ʉkʉtɨ alʉtalalɨsye ʉlʉlɨmi lwangʉ, paapo ngʉtaamigwa fiijo mmooto ʉgʉ.’ ");
INSERT INTO nyy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Looli Abulahamu alɨnkʉmmwamula alɨnkʉtɨ, ‘Mwanangʉ, ʉkʉmbʉkege ʉkʉtɨ bo ʉlɨ kʉ bʉʉmi gwakabile ɨfinunu, joope Laasalo aakabile ɨfibiibi. Looli apa alɨ pakʉsʉʉbɨsigwa, ʉgwe ʉlɨ pakʉkʉbɨlwa fiijo. ");
INSERT INTO nyy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Palɨ syosa ɨsyo, pakatɨ pamyɨtʉ na nuumwe, lʉbɨɨkiigwe ʉlʉpanga ʉlʉnywamu, ʉkʉtɨ aba bikʉlonda ʉkwisa ʉko, ʉkʉfuma kʉno batoligwege, boope aba bikʉfuma ʉko batoligwege ʉkwisa kʉmyɨtʉ.’ ");
INSERT INTO nyy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ʉnkabi jʉla alɨnkʉjoba alɨnkʉtɨ, ‘Po taata Abulahamu, ngʉkʉsʉʉma ʉntʉme Laasalo kʉkaaja kaa taata, ");
INSERT INTO nyy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","paapo ndɨ nabo abaamyɨtʉ bahaano. Akabasoke ʉkʉtɨ boope bangiisa kwisa pabʉjo ʉbʉ ʉbwa ngʉbɨlo.’ ");
INSERT INTO nyy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Looli Abulahamu alɨnkʉmmwamula alɨnkʉtɨ, ‘Balɨ nabo baakalata abaa Moose na baa bakunguluka. Basiitɨkege ɨsi sisimbiigwe nabo.’ ");
INSERT INTO nyy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ʉnkabi jʉla alɨnkʉjoba alɨnkʉtɨ, ‘Mma, taata Abulahamu! Looli lɨnga abʉʉkile kʉmyabo ʉmundʉ ʉkʉfuma mbafwe, bikwakʉpɨndʉka.’ ");
INSERT INTO nyy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abulahamu alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Lɨnga batikʉsipɨlɨka ɨsi sisimbiigwe na Moose na bakunguluka, po sitikʉbakolaga nalɨnga ʉmundʉ asyʉkile ʉkʉfuma mbafwe.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Nalooli sikwisa ɨsi sikʉbasobesya abandʉ! Looli ahɨɨli ʉmundʉ ʉjʉ ikʉsitwala! ");
INSERT INTO nyy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ngalɨ kʉnunu ʉkʉpinyigwa ʉlwala mmakosi gaake nʉ kʉsopigwa mu nyanja, ʉkʉkɨndapo ʉkʉnsobesya jʉmo mmbandʉ abafujufu aba! ");
INSERT INTO nyy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Muje maaso! Lɨnga ʉnnino akʉtʉliile ɨnongwa, ʉnsokege. Kangɨ lɨnga ikʉkʉsʉʉma ʉlʉhobokelo, ʉnhobokelege. ");
INSERT INTO nyy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nalɨnga akʉtʉliile ɨnongwa kahaano na kabɨlɨ kwi isikʉ lɨmo, ikwisa kʉmyako, ikʉtɨ, ‘Nsobile,’ ʉnhobokelege!” ");
INSERT INTO nyy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Abatʉmigwa balɨnkʉmmbʉʉla ʉNtwa balɨnkʉtɨ, “Ʉtongelepo ʉlwitɨko!” ");
INSERT INTO nyy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ɄNtwa alɨnkʉbaamula alɨnkʉtɨ, “Lɨnga mulɨ nʉ lwitɨko ʉlʉniini bo ʉlwa kaseke akaa mutaka, mwabagiile ʉkʉgʉbʉʉla ʉnkʉjʉ ʉgʉ ʉkʉtɨ, ‘Nyukuka, ʉkiibyale mu nyanja,’ gwabagiile ʉkʉbiitɨka.” ");
INSERT INTO nyy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Jo jwani mmyɨnu ʉjʉ alɨ nʉ mbombi gwake, ʉjʉ ikʉlɨma pamo ikʉtiima ɨngʼoosi, ikʉmmbʉʉla bo akotwike mu mbombo ʉkʉtɨ, ‘Isaga mbɨbɨmbɨbɨ, ʉtʉʉgale, ʉlyemo ɨfindʉ’? ");
INSERT INTO nyy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bʉle, atikʉmmbʉʉla ʉkʉtɨ, ‘Ndendekekesya ɨfindʉ, ʉbombege ɨsi ngʉlonda, bo ndɨ pakʉlya nʉ kʉnwa. Bo mmalile, po na nungwe kʉlyamo nʉ kʉnwa’? ");
INSERT INTO nyy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bʉle, ikʉnngwɨla ʉlʉpi ʉmbombi jʉla, paapo abombile ɨsi alagɨliigwe? ");
INSERT INTO nyy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nuumwe bo mumalile ʉkʉbomba syosa ɨsi Kyala abalagiile, mutɨgɨ, ‘Ʉswe tʉlɨ babombeli abasita kʉbagɨsya, tʉbombile itolo ɨsi twalondigwaga ʉkʉsibomba.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesu bo alɨ mu njɨla ʉkʉbʉʉka kʉ Jelusalemu, alɨnkwenda mu mpaka gwa Samalija na Galilai. ");
INSERT INTO nyy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bo ikwingɨla nkaaja kamo, alɨnkwaganila na bandʉ kalongo, aba baalɨ nɨ mbʉngo jaa bʉkoma. Balɨnkwɨma pabʉtali, ");
INSERT INTO nyy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","balɨnkʉkoolela fiijo balɨnkʉtɨ, “Gwe Jesu gwe Malafyale, ʉlɨɨtʉpaakɨsya!” ");
INSERT INTO nyy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bo ababwene alɨnkʉbabʉʉla alɨnkʉtɨ, “Amubʉʉke mukiinangɨsye kʉ bapuuti.” Bo balɨ mu njɨla bikwenda, balɨnkwelʉka. ");
INSERT INTO nyy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jʉmo ndɨ balabala, bo iibwene ʉkʉtɨ abʉmbʉlwike, aagomwike ikʉlaata ʉkʉntuufya Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bo afikile alɨnkʉfugama nʉ kwinama paasi nkyeni mwa Jesu, ʉkʉgwa ʉlʉpi kʉmyake. Ʉmundʉ ʉjo aalɨ Nsamalija. ");
INSERT INTO nyy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesu alɨnkʉlaalʉʉsya alɨnkʉtɨ, “Bʉle, bakeelʉsigwa boosa kalongo? Bala bahaano na bana balɨ kʉʉgʉ? ");
INSERT INTO nyy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bʉle, najʉmo ʉjʉ agomwike kʉkʉntuufya Kyala, looli mwene ʉnjanga ʉjʉ?” ");
INSERT INTO nyy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Po paapo Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Sumuka, bʉʉkaga, ʉbʉmbʉlwike ʉbʉbine kʉnongwa jaa lwitɨko lwako!” ");
INSERT INTO nyy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ɨliisikʉ lɨmo, aBafalisai baalɨnndaalʉʉsiisye Jesu baatile, “ɄBʉnyafyale bwa Kyala bukwisa ndɨli?” Jesu alɨnkʉbaamula alɨnkʉtɨ, “ɄBʉnyafyale bwa Kyala bʉtikwisa nɨ fimanyilo ɨfi fikʉboneka na maaso. ");
INSERT INTO nyy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kangɨ abandʉ batikwisa kʉjobaga ʉkʉtɨ, ‘Keeta! Bʉliko kʉno!’ pamo, ‘Bʉlɨ kʉla!’ Paapo ʉBʉnyafyale bwa Kyala bʉlimo mmyɨnu.” ");
INSERT INTO nyy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Po Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Gikwisa amasikʉ aga mukwisa kʉnyonywaga iisikʉ lya kwisa kwangʉ ʉne ne Nnyamundʉ, leelo mutikwisa kʉlɨbona. ");
INSERT INTO nyy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kangɨ abandʉ bikwisa kʉbabʉʉlaga ʉkʉtɨ, ‘Keeta aliko kʉla!’ pamo, ‘Keeta aliko kʉno!’ Mulɨngiisa kʉsookangapo apa mulipo, pamo ʉkʉbakonga. ");
INSERT INTO nyy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Namanga pi isikʉ ɨlɨ ngwisa kwisa ne Nnyamundʉ, ngwisa bo ʉlwa kɨmweku ɨkya njasi, ɨkɨ kikʉmulɨka mu mpaalanga, ʉkʉfuma ʉlʉbafu lʉmo kikwakʉfika ʉlʉbafu ʉlʉngɨ. ");
INSERT INTO nyy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bo sikaalɨ ʉkʉboneka ɨsyo, Nnyamundʉ sikʉʉnyaaga ɨngʉbɨlo ɨnyingi nʉ kʉkaanigwa na bandʉ baa nkabalɨlo aka. ");
INSERT INTO nyy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Bo ʉlwa mmasikʉ agaa Nwaka, bo sikwisa kʉjɨɨlaga akabalɨlo akaa kʉgomoka Nnyamundʉ. ");
INSERT INTO nyy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Abandʉ baalyaga nʉ kʉnwa, beegaga nʉ kwegigwa, mpaka iisikʉ ɨlɨ Nwaka aalingiile mu ngalaba. Ɨfula jaa mweleesyo jɨlɨnkʉtima, jɨlɨnkʉbapyuta boosa. ");
INSERT INTO nyy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Kangɨ syalɨ bo lʉlʉʉlo mmasikʉ gaa Looti. Abandʉ baalyaga nʉ kʉnwa, bʉʉlaga nʉ kʉʉlɨsya, baabyalaga nʉ kʉjenga. ");
INSERT INTO nyy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Looli ɨliisikʉ ɨlɨ Looti aasookilemo mu Sotoma, ʉmooto na mabwe aga gikwaka, fyalagalaga ʉkʉfuma kʉmwanya, ngatɨ fula, filɨnkʉbapyuta boosa. ");
INSERT INTO nyy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bʉbʉʉbo bo sikwisa kʉjɨɨlaga, bo ngʉsetʉligwa pabwelu ne Nnyamundʉ. ");
INSERT INTO nyy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Iisikʉ ɨlyo, ʉmundʉ ʉjʉ alɨ pamwanya pa nyumba, alɨngasulukaga kʉkwega ʉtʉndʉ twake ʉtʉ tʉlɨ nnyumba, looli abopege. Kangɨ ʉmundʉ ʉjʉ alɨ mu ngʉnda, alɨngagomokelangako kʉkaaja. ");
INSERT INTO nyy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Munkʉmbʉkege ʉnkasi gwa Looti! ");
INSERT INTO nyy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ʉmundʉ gwesa ʉjʉ ikʉlonda ʉkʉbʉponesya ʉbʉʉmi bwake, ikʉbʉpeesyaga ʉbʉʉmi bwa bwila na bwila. Looli ʉmundʉ ʉjʉ atikʉbʉpaasya ʉbʉʉmi bwake pakiisʉ apa, ʉjo jo ikʉbʉkabaga ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Nikʉbabʉʉla nikʉtɨ, pakɨlo ɨkyo abandʉ babɨlɨ lɨnga balambaleele pa kɨtala kɨmo, jʉmo ikwisa kwegigwa, ʉjʉngɨ ikwisa kʉlekigwa. ");
INSERT INTO nyy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Abakiikʉlʉ babɨlɨ bikwisa kʉsyaga pamopeene, jʉmo ikwisa kwegigwa, ʉjʉngɨ ikwisa kʉlekigwa.  ");
INSERT INTO nyy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Abanyambala babɨlɨ bikwisa kʉbombaga ɨmbombo mu ngʉnda, jʉmo ikwisa kwegigwa, ʉjʉngɨ ikwisa kʉlekigwa.” ");
INSERT INTO nyy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Abafundigwa balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Gwe Ntwa, ɨsyo sikwisa kʉbombigwa kʉʉgʉ?” Alɨnkʉbaamula alɨnkʉtɨ, “Apa gʉlipo ʉmfimba, po apa ɨminombo gikʉbʉngaana.” ");
INSERT INTO nyy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Po paapo Jesu alɨnkʉbabʉʉla abafundigwa baake ɨkɨfwanikɨsyo, ʉkʉbamanyisya ʉkʉtɨ, bikʉlondigwa bansʉʉmege Kyala bwila kɨsita kʉleka. ");
INSERT INTO nyy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Alɨnkʉjoba alɨnkʉtɨ, “Aaliko ʉndongi nkaaja kamo akanywamu, ʉjʉ akantiilaga Kyala, kangɨ akampaasyaga ʉmundʉ. ");
INSERT INTO nyy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nkaaja ako aaliko ʉnkiikʉlʉ jʉmo ʉmfwɨle, ʉjʉ aabʉʉkaga kʉ ndongi kaa kingi, alɨnkʉjoba alɨnkʉtɨ, ‘Ngʉkʉsʉʉma ʉʉndongele kanunu ɨnongwa jangʉ nʉ ndʉgʉ gwangʉ.’ ");
INSERT INTO nyy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Akabalɨlo kaa kingi ʉndongi aakaanaga, looli kʉbʉʉbo alɨnkwinogona mu ndumbula jaake alɨnkʉtɨ, ‘Ndikʉntiila Kyala pamo ʉkʉmpaasya ʉmundʉ. ");
INSERT INTO nyy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Looli paapo ʉnkiikʉlʉ ʉmfwɨle ʉjʉ ikʉʉsingʉla fiijo, ngʉnndongela kanunu ɨnongwa jaake, ʉkʉtɨ alɨngangatasyaga ʉkʉʉngilɨla bwila!’ ” ");
INSERT INTO nyy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ɄNtwa alɨnkʉjoba alɨnkʉtɨ, “Musyaganie ɨsi ikʉjoba ʉndongi ʉnniongafu jʉla! ");
INSERT INTO nyy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bʉle, Kyala atikʉbabombela kanunu abasʉngʉligwa baake, aba bikʉnndɨlɨla pamuusi na pakɨlo? Bʉle, ikʉkaabɨla ʉkʉbatʉʉla? ");
INSERT INTO nyy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nikʉbabʉʉla nikʉtɨ, Kyala ikʉbapa mbɨbɨmbɨbɨ ɨfi bikʉnsʉʉma. Looli bo ngwisa ne Nnyamundʉ, bʉle, ngwisa kʉbaaga abandʉ aba bikʉʉnyiitɨka?” ");
INSERT INTO nyy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Po Jesu alɨnkʉbabʉʉla ɨkɨfwanikɨsyo, abandʉ bala bikwibona ʉkʉja bagolofu, bikʉbiila abandʉ abangɨ. ");
INSERT INTO nyy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Alɨnkʉtɨ, “Iisikʉ lɨmo abandʉ babɨlɨ baabʉʉkile kʉkwipuuta ndʉpaso lwa tempeli, jʉmo aalɨ Mfalisai, ʉjʉngɨ aalɨ nsongesya songo. ");
INSERT INTO nyy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ɄMfalisai jʉla alɨnkwɨma, alɨnkwipuuta mu ndumbula jaake alɨnkʉtɨ, ‘Gwe Kyala, ngʉgwa ʉlʉpi, paapo ʉne ngaja bo abandʉ abangɨ, aba bikʉkaba ɨkyʉma kʉ bʉsyobi, abaniongafu, abalogwe, pamo bo ʉlwa nsongesya songo ʉjʉ! ");
INSERT INTO nyy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ʉne ngʉfipɨɨka ɨfindʉ nʉ kwipuuta, kabɨlɨ kʉ ndʉngʉ, kangɨ fyosa ɨfi ngʉkaba ngʉkʉsookesya ɨfya pi ilongo.’ ");
INSERT INTO nyy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Looli ʉnsongesya songo jʉla, alɨnkwɨma pabʉtali, akaagelilepo ʉkwinʉla amaaso gaake kʉmwanya, looli alɨnkwikoma koma kʉ kɨpambaga ʉkʉnangɨsya ʉbʉsulumanie, alɨnkʉjoba alɨnkʉtɨ, ‘Gwe Kyala, ʉlɨɨmbaakɨsya ʉne, ne ntʉlanongwa!’ ” ");
INSERT INTO nyy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Nikʉbabʉʉla, ʉnsongesya songo ʉjʉ aagomwike kʉkaaja, aabaliigwe ʉkʉja ngolofu, somma ʉMfalisai. Namanga kʉkʉtɨ mundʉ ʉjʉ ikwijiinʉla, ikʉsulusigwaga na Kyala, ʉmundʉ gwesa ʉjʉ ikwisulusya ikwinʉligwaga na Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Abandʉ bantwalɨlaga Jesu na baana abaniini, ʉkʉtɨ abapalamaasye. Abafundigwa baake bo basibwene ɨsyo, balɨnkʉbakemela. ");
INSERT INTO nyy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Looli Jesu alɨnkʉbakoolela abaana bala, alɨnkʉtɨ, “Namubaleke abaana abaniini biisege kʉmyangʉ, mulɨngabasigɨlaga, paapo ʉBʉnyafyale bwa Kyala bwa bandʉ aba balɨ bo abaana aba. ");
INSERT INTO nyy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nalooli nikʉbabʉʉla, ʉmundʉ gwesa ʉjʉ atikʉnsʉʉbɨla Kyala bo ʉmwana ʉnniini muno ikʉbasʉʉbɨla abapaapi, atikwingɨla sikʉ mBʉnyafyale bwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ʉndongosi jʉmo alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Gwe Mmanyisi Nnunu, mbombe ɨfiki ʉkʉtɨ ngabe ʉbʉʉmi bwa bwila na bwila?” ");
INSERT INTO nyy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Fiki kʉʉnjoba ʉkʉtɨ ndɨ nnunu? Akajako ʉnnunu, looli aliko jʉmojwene, jo Kyala! ");
INSERT INTO nyy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ʉsimeenye ɨndagɨlo, ‘Ʉlɨngalogwaga, ʉlɨngagogaga, ʉlɨngahɨɨjaga, ʉlɨngajaga nkeeti gwa bʉtʉngʉlʉ, ʉmmwɨmɨkege ʉgʉʉso nʉ nyoko.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ʉmwene alɨnkʉtɨ, “Ɨndagɨlo syosa ɨsyo nsikolile ʉkʉfuma mbʉkeke bwangʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesu bo apɨliike ɨsyo, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwagiilwe kamokeene. Ʉlɨsya ʉtʉndʉ toosa ʉtʉ ʉlɨ nato, ɨndalama ɨsyo ʉbajabɨle abalondo. Lɨnga ʉbombile bo ʉlo, bo gwibɨɨkiile ɨkyʉma kʉmwanya. Po gwise gʉngongege.” ");
INSERT INTO nyy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ʉndongosi jʉla bo apɨliike ɨsyo, alɨnkʉsulumania fiijo, paapo aalɨ nɨ kyʉma kingi fiijo. ");
INSERT INTO nyy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesu bo ammbwene ʉkʉtɨ asulumeenie, alɨnkʉjoba alɨnkʉtɨ, “Bo bʉpala bʉki abakabi ʉkwingɨla mBʉnyafyale bwa Kyala! ");
INSERT INTO nyy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɨngamila ʉkwingɨla mbwasi bwa sindaano kʉpepe, ʉkʉkɨnda ʉnkabi ʉkwingɨla mBʉnyafyale bwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Abandʉ aba baasipɨliike ɨsyo, balɨnkʉjoba balɨnkʉtɨ, “Po jo jwani ʉjʉ abagiile ʉkʉpokigwa?” ");
INSERT INTO nyy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Ɨsi bikʉtoligwa abandʉ, abagiile Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peeteli alɨnkʉjoba alɨnkʉtɨ, “Keeta, ʉswe tʉfilekile fyosa, tʉkʉkongile ʉgwe!” ");
INSERT INTO nyy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, ʉmundʉ gwesa ʉjʉ ajɨlekile ɨnyumba, pamo ʉnkasi, pamo abakamu, pamo abapaapi, pamo abaanaake, kʉnongwa jaa Bʉnyafyale bwa Kyala, ");
INSERT INTO nyy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ikwisa kwambɨlɨla kʉ bwingi ʉkʉkɨndapo, nkabalɨlo aka. Kangɨ nkabalɨlo aka kikwisa, ikwisa kʉkaba ʉbʉʉmi bwa bwila na bwila.” ");
INSERT INTO nyy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesu alɨnkʉbeega abafundigwa bala kalongo na babɨlɨ, alɨnkʉja nabo pambalɨ, alɨnkʉbabʉʉla alɨnkʉtɨ, “Keeta! Tukʉfyʉka ʉkʉbʉʉka mu Jelusalemu, syosa ɨsi baasimbile abakunguluka, ɨsya kʉʉnjoba ne Nnyamundʉ, sikʉbombigwa. ");
INSERT INTO nyy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ngwakʉbɨɨkigwa mmaboko agaa Balooma. Bikwakʉʉnyangalɨlaga, bikwakʉndʉkaga nʉ kʉʉswela amata. ");
INSERT INTO nyy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bikwakʉngoma nɨ fingoti, po bikwakʉʉngoga. Pi isikʉ lya bʉtatʉ, angʉsyʉka.” ");
INSERT INTO nyy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Looli abafundigwa baake bakaasyageenie ɨsi aajobaga. Ɨnongwa ɨsi aajobaga bakaameenye ʉkʉtɨ sikʉtɨ fiki, paapo syafisiigwe kʉmyabo. ");
INSERT INTO nyy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bo Jesu asegeliile nkaaja akaa mu Jeeliko, ʉmundʉ jʉmo ʉmfwa maaso, aatʉʉgeele kʉmbalɨ kʉ njɨla, aasʉʉmaga ɨfya bʉsʉsɨlwa. ");
INSERT INTO nyy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bo apɨliike ɨkɨlʉndɨlo kya bandʉ bikʉkɨnda, alɨnkʉlaalʉʉsya alɨnkʉtɨ, “Filiko ɨfiki?” ");
INSERT INTO nyy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Balɨnkʉmmbʉʉla balɨnkʉtɨ, “Jesu ʉgwa mu Nasaleti ikʉkɨnda.” ");
INSERT INTO nyy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Po alɨnkʉkoolela alɨnkʉtɨ, “Gwe Jesu, gwe Mwana gwa malafyale Ndaabɨti, ʉlɨɨmbaakɨsya!” ");
INSERT INTO nyy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Abandʉ aba baatalilepo nkyeni mwa Jesu, balɨnkʉnkemela ʉkʉtɨ amyeke. Looli ʉmwene alɨnkʉkɨndɨlɨla fiijo, alɨnkʉlaata ʉkʉkoolela alɨnkʉtɨ, “Gwe Mwana gwa malafyale Ndaabɨti, ʉlɨɨmbaakɨsya!” ");
INSERT INTO nyy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesu alɨnkwɨma, alɨnkʉbalagɨla ʉkʉtɨ bantwale kʉmyake. Bo asegeliile alɨnkʉnndaalʉʉsya alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kʉlonda ngʉbombele ɨfiki?” Ʉmfwa maaso jʉla alɨnkʉtɨ, “Gwe Ntwa, ngʉlonda ʉkʉtɨ ngeetege.” ");
INSERT INTO nyy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Keetaga! Ʉbʉmbʉlwike ʉbʉbine kʉnongwa jaa lwitɨko lwako.” ");
INSERT INTO nyy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nakalɨnga alɨnkʉkeeta, alɨnkʉnkonga Jesu kʉno ikʉntuufya Kyala. Abandʉ boosa bo basibwene ɨsyo, boope balɨnkʉntuufya Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu alɨnkwingɨla mu Jeeliko, aakɨɨsaniaga nkaaja kala. ");
INSERT INTO nyy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aalimo ʉmundʉ jʉmo ɨngamu jaake Sakai, ʉjʉ aalɨ nkʉlʉmba gwa basongesya songo, kangɨ aalɨ nkabi. ");
INSERT INTO nyy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ʉmundʉ ʉjʉ aalondaga ʉkʉmmbona Jesu muno ajɨɨliile, looli alɨnkʉtoligwa ʉkʉmmbona, kʉnongwa jaa kɨlʉndɨlo kya bandʉ, paapo ʉmwene aalɨ mpimba. ");
INSERT INTO nyy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Po alɨnkʉbopa ʉkʉtalapo nkyeni, alɨnkʉkwela mu nkʉjʉ ʉkʉtɨ ammbone, paapo Jesu aajaga pakʉkɨnda mu njɨla jɨla. ");
INSERT INTO nyy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesu bo afikile pa nkʉjʉ gʉla, alɨnkʉkeeta kʉmwanya, alɨnkʉmmbʉʉla Sakai alɨnkʉtɨ, “Sakai, suluka nakalɨnga! Paapo lɨɨlɨno ngwakʉlɨnda nnyumba mmyako.” ");
INSERT INTO nyy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakai alɨnkʉsuluka nakalɨnga nʉ kʉmmwambɨlɨla Jesu nʉ lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Abandʉ boosa aba baalɨmmbwene Jesu bo ikwingɨla mu nyumba jaa Sakai, balɨnkwibuneesya, balɨnkʉtɨ, “Abʉʉkile kʉkʉja nheesya gwa ntʉlanongwa!” ");
INSERT INTO nyy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Looli Sakai alɨnkwɨma, alɨnkʉmmbʉʉla ʉNtwa alɨnkʉtɨ, “Keeta Ntwa! Ɨkyʉma kyangʉ ngʉjaba pakatɨ, kɨmo ngʉbapapo abalondo. Kangɨ ʉmundʉ ʉjʉ lɨnga naalɨnsyobile fimo, ngʉnngomokesya ɨfi naalɨnsyobile kana.” ");
INSERT INTO nyy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Po Jesu alɨnkʉmmbʉʉla Sakai alɨnkʉtɨ, “Lɨɨlɨno ʉbʉpoki bwisile nnyumba ɨjɨ, paapo joope ʉjʉ mwana gwa Abulahamu. ");
INSERT INTO nyy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Paapo Nnyamundʉ iisile kʉkʉbalonda nʉ kʉbapoka aba basobile.” ");
INSERT INTO nyy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bo bikʉgapɨlɨkɨsya amasyʉ gaake, Jesu alɨnkwendelela ʉkʉbabʉʉla ɨkɨfwanikɨsyo, paapo aalɨ kɨfuki ʉkʉfika kʉ Jelusalemu, kangɨ abandʉ bala biinogonaga ʉkʉtɨ ʉBʉnyafyale bwa Kyala bukʉja pakʉboneka nakalɨnga. ");
INSERT INTO nyy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Aaliko ʉmundʉ jʉmo ʉgwa nkɨkolo ɨkyɨmɨkigwa, ʉjʉ aalondaga ʉkwenda ɨnjɨla ʉkʉbʉʉka nkiisʉ ɨkya kʉbʉtali nʉ kʉgomoka, ʉkʉtɨ akapeeligwe ʉbʉnyafyale ʉbwa kʉlongosya ɨkiisʉ kyake. ");
INSERT INTO nyy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Bo akaalɨ ʉkʉbʉʉka, aabakooliile ababombeli baake kalongo, alɨnkʉmpapo kʉkʉtɨ mbombeli ɨndalama ɨnyingi, alɨnkʉbabʉʉla alɨnkʉtɨ, ‘Musibombele ɨndalama ɨsi, ʉkʉtɨ syongelengepo, mpaka bo ngʉgomoka.’ ");
INSERT INTO nyy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Looli abandʉ baa nkiisʉ kyake baalɨmmbengile, balɨnkʉtʉma abandʉ abaa kwa kʉjoba ʉkʉtɨ, ‘Tʉtikʉlonda ʉmundʉ ʉjʉ ʉkʉja ndagɨli gwɨtʉ!’ ");
INSERT INTO nyy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Poope ʉmundʉ jʉla aakabile ʉbʉnyafyale, alɨnkʉgomoka kʉkaaja. Bo afikile alɨnkʉbakoolela ababombeli aba aabapeele ɨndalama, aalondaga ʉkʉtɨ amanye ɨfi akabiileko kʉkʉtɨ mbombeli. ");
INSERT INTO nyy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Alɨnkwisa ʉgwa kwanda, alɨnkʉjoba alɨnkʉtɨ, ‘Ntwa, ɨndalama syako, ngabiileko ɨfijabo kalongo.’ ");
INSERT INTO nyy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ʉntwa gwake alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Ʉbombile kanunu, gwe mbombeli nnunu! Paapo ʉlɨ ngolofu mu mbombo ɨnandɨ fiijo, ngʉkʉpapo ʉkʉlongosya ʉtwaja kalongo.’ ");
INSERT INTO nyy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Alɨnkwisa ʉmbombeli ʉgwa bʉbɨlɨ alɨnkʉjoba alɨnkʉtɨ, ‘Ntwa, ɨndalama syako, ngabiileko ɨndalama ɨsingi ɨfijabo fihaano.’ ");
INSERT INTO nyy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ʉntwa gwake alɨnkʉmmbʉʉla joope ʉjʉ, alɨnkʉtɨ, ‘Ʉgwe, ngʉkʉpapo ʉkʉlongosya ʉtwaja tʉhaano.’ ");
INSERT INTO nyy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Alɨnkwisa ʉjʉngɨ alɨnkʉjoba alɨnkʉtɨ, ‘Ntwa, ɨsi syo ndalama syako, naapinyile nkɨtambala, ʉkʉtɨ silɨngasoba. ");
INSERT INTO nyy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Naabombile bo ʉlo paapo nakʉtiilaga, namanga ʉgwe ʉlɨ mundʉ ʉnkalɨ. Kwega ɨfi ʉkaabɨɨkile nʉ kʉtondola ɨfi ʉkaabyele.’ ");
INSERT INTO nyy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ʉntwa jʉla alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Gwe mbombeli ʉmbiibi ʉgwe! Ngʉkʉlongela mu mmasyʉ gaako aga ʉjobile. Gwameenye ʉkʉtɨ ʉne ndɨ nkalɨ. Ngwega ɨfi ngaabɨɨkile nʉ kʉtondola ɨfi ngaabyele. ");
INSERT INTO nyy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Po fiki ʉkaabɨɨkile ɨndalama syangʉ kʉlɨ aba bikʉsibombela ʉkʉtɨ ngabɨleko? Ʉne bo niisile ngalɨ neegile na ɨsi ngabiileko.’ ");
INSERT INTO nyy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Po alɨnkʉbalagɨla aba baalyɨmile kɨfuki, alɨnkʉtɨ, ‘Namupoke ɨndalama, mukampepo jʉla ʉjʉ akabile ndalama ɨfijabo kalongo.’ ");
INSERT INTO nyy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Balɨnkwamula balɨnkʉtɨ, ‘Ntwa, keeta alɨ nasyo ɨndalama ɨfijabo kalongo!’ ");
INSERT INTO nyy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Joope alɨnkʉbaamula alɨnkʉtɨ, ‘Nikʉbabʉʉla nikʉtɨ, ʉjʉ ikʉbombela kanunu aka alɨ nako, ikongeleligwa ʉkʉpeeligwa. Ʉjʉ atikʉbombela kanunu, koope aka alɨ nako ikʉpokigwa. ");
INSERT INTO nyy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Po mubatwale abalʉgʉ bangʉ, aba batikʉlonda ʉkʉtɨ njege malafyale gwabo, mubatwale apa, mubagoge, bo ngʉkeeta!’ ” ");
INSERT INTO nyy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesu bo amalile ʉkʉjoba ɨsyo alɨnkʉtalapo nkyeni, alɨnkwanda ɨnjɨla jaa kʉfyʉka ʉkʉbʉʉka kʉ Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bo asegeliile mu Betifage na mu Betanija, ʉtwaja ʉtʉ tʉlɨ kɨfuki nʉ bʉjo ʉbʉ bikʉtɨ Kyamba kya Misyʉngʉtɨ, alɨnkʉbatʉma abafundigwa baake babɨlɨ, ");
INSERT INTO nyy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","alɨnkʉbabʉʉla alɨnkʉtɨ, “Namubʉʉkege nkaaja aka kalɨ nkyeni mmyɨnu. Bo mwingiile mula, mukwakʉjaaga ɨmwana jaa mbunda jɨkʉngiigwe, ɨjɨ ʉmundʉ akiitogamo sikʉ. Mukajaabʉle, mukajɨtwale apa. ");
INSERT INTO nyy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Lɨnga ʉmundʉ ikʉbalaalʉʉsya ikʉtɨ, ‘Fiki mukʉjaabʉla?’ mukammbʉʉlege mukatɨgɨ, ‘ɄNtwa afumbilwe najo.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Po bala baatʉmiigwe balɨnkʉbʉʉka, balɨnkwaga sijɨɨliile bo muno aababʉʉlile. ");
INSERT INTO nyy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bo balɨ pakʉjaabʉla ɨmwana jaa mbunda, abeene najo balɨnkʉbalaalʉʉsya balɨnkʉtɨ, “Fiki mukʉjaabʉla ɨmwana jaa mbunda?” ");
INSERT INTO nyy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Balɨnkʉbaamula balɨnkʉtɨ, “ɄNtwa afumbilwe najo.” ");
INSERT INTO nyy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Balɨnkʉntwalɨla Jesu, balɨnkʉtenga ɨmyenda gyabo pamwanya paa mwana jaa mbunda, Jesu alɨnkwitoga. ");
INSERT INTO nyy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesu bo ikwenda, abandʉ baalɨsyaga ɨmyenda gyabo mu nsebo, ʉkʉnangɨsya ʉlwɨmɨko kʉmyake. ");
INSERT INTO nyy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bo alɨ kɨfuki nʉ nsebo ʉgʉ gukʉsuluka ʉkʉfuma kʉ Kyamba kya Misyʉngʉtɨ, ɨkɨbugutɨla kyosa ɨkya bafundigwa baake, kɨlɨnkwanda ʉkʉsekela nʉ kʉlaata ʉkʉntuufya Kyala, kʉnongwa jaa mbombo sya fiika fyosa ɨfi baafibwene, ");
INSERT INTO nyy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","balɨnkʉtɨ, “Asajigwege ʉMalafyale ʉjʉ ikwisɨla mu ngamu jaa Ntwa Kyala! Ʉlʉtengaano kʉmwanya nʉ bʉsisya kwa Kyala gwa kʉmwanya fiijo!” ");
INSERT INTO nyy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ABafalisai bamo, aba baalimo nkɨlʉndɨlo, balɨnkʉmmbʉʉla balɨnkʉtɨ, “Mmanyisi, ʉbakemele abafundigwa baako, bamyeke!” ");
INSERT INTO nyy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Alɨnkʉbaamula alɨnkʉtɨ, “Nikʉbabʉʉla nikʉtɨ, lɨnga bamyekile aba, amabwe gikʉlaataga!” ");
INSERT INTO nyy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesu bo alɨ kɨfuki, alɨnkʉkabona akaaja kaa Jelusalemu, alɨnkʉkalɨlɨla, ");
INSERT INTO nyy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","alɨnkʉtɨ, “Ngalɨ silɨ kanunu kʉmyako ʉmwisyʉgʉ, lɨnga gwasimeenye ɨsi sikʉtwala ʉlʉtengaano! Looli akabalɨlo aka ʉtikʉsibona. ");
INSERT INTO nyy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Paapo amasikʉ gikwisa, aga abalʉgʉ baako bikwisa kʉjenga iilinga ɨlya mabwe ʉkʉkʉsyʉngʉʉtɨla, bikwisa kʉkʉfinyatɨla mfibafu fyosa. ");
INSERT INTO nyy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bikwisa kʉkʉpondania paasi ʉgwe na baanaako, mwi ilinga lyako ɨlya mabwe. Batikwisa kʉkʉlekela iibwe ɨlɨ lɨlɨ pamwanya pi ibwe iinine, kʉnongwa jaa kʉtɨ ʉkaakaageenie akabalɨlo aka Kyala aaliisile kʉkʉkʉpoka!” ");
INSERT INTO nyy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesu alɨnkwingɨla ndʉpaso lwa tempeli, alɨnkwanda ʉkʉbakagɨla panja aba bʉʉlɨsyaga ʉtʉndʉ. ");
INSERT INTO nyy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ɨnyumba jangʉ jikʉjaga nyumba jaa kwipuutɨlamo.’ Looli ʉmwe, mujɨbɨɨkile ʉkʉja, ‘Mbako jaa minyambuta.’ ” ");
INSERT INTO nyy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesu aamanyisyaga kʉkʉtɨ isikʉ ndʉpaso lwa tempeli. Abapuuti abalongosi, abamanyisi baa ndagɨlo sya Moose na balongosi baa Bajuuta, balɨnkʉlonda ɨnjɨla ɨjaa kʉnngogela, ");
INSERT INTO nyy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","looli bakaajaagile najɨmo, paapo abandʉ boosa baapɨlɨkɨsyaga kanunu ɨsi aajobaga. ");
INSERT INTO nyy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Iisikʉ lɨmo, Jesu aabamanyisyaga nʉ kʉbalʉmbɨlɨla abandʉ ɨNdʉmi ɨNunu ndʉpaso lwa tempeli. Abapuuti abalongosi, abamanyisi baa ndagɨlo sya Moose na balongosi baa Bajuuta, balɨnkʉbʉʉka kʉmyake, ");
INSERT INTO nyy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Tʉbʉʉle, ʉkabile kʉʉgʉ amaka agaa kʉbomba ɨsi? Jo jwani ʉjʉ akʉpeele amaka aga?” ");
INSERT INTO nyy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Alɨnkʉbaamula alɨnkʉtɨ, “Na niine ngʉbalaalʉʉsya iisyʉ lɨmo. Muumbʉʉle, ");
INSERT INTO nyy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","bʉle, amaka agaa Johani agaa kʉboosya abandʉ gaafumile kwa Kyala, pamo kʉ bandʉ?” ");
INSERT INTO nyy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Po balɨnkʉjobesania balɨnkʉtɨ, “Lɨnga tukʉtɨ amaka gaake gaafumile kwa Kyala, ʉmwene ikʉtɨgɨ, ‘Keeta mukaalɨmmwitiike?’ ");
INSERT INTO nyy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Looli lɨnga tukʉtɨ amaka gaake gaafumile kʉ bandʉ, ɨkɨlʉndɨlo ɨkɨ ɨkya bandʉ bikʉtʉtuunya na mabwe, paapo biitiike ʉkʉtɨ Johani aalɨ nkunguluka.” ");
INSERT INTO nyy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Po balɨnkʉmmwamula Jesu balɨnkʉtɨ, “Tʉkamanya kʉno gaafumile.” ");
INSERT INTO nyy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Po leelo niine, ndikʉbabʉʉla ʉmwe ʉkʉtɨ jwani ambeele amaka agaa kʉbomba ɨsi.” ");
INSERT INTO nyy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Po Jesu alɨnkwanda ʉkʉbabʉʉla abandʉ ɨkɨfwanikɨsyo ɨkɨ, alɨnkʉtɨ, “Aaliko ʉmundʉ jʉmo ʉjʉ aabyele amaafiilʉ mu ngʉnda gwake. Alɨnkʉbabɨɨkamo abalɨmi abaa kʉkeetelela ɨmipiki gya maafiilʉ gɨla, ʉkʉtɨ ɨseke bo sibɨfwifwe, biise bajabane. Po alɨnkwenda ɨnjɨla akabalɨlo akatali. ");
INSERT INTO nyy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Akabalɨlo kaa kʉtʉngʉla ɨseke bo kafikile, alɨnkʉntʉma jʉmo mbabombeli baake kʉ balɨmi bala ʉkʉtɨ bampeko ɨkɨjabo kyake. Looli abalɨmi bala balɨnkʉnkoma, balɨnkʉnkaga kɨsita kʉmpapo nafimo. ");
INSERT INTO nyy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Po ʉmwene ngʉnda jʉla alɨnkʉntʉma kangɨ ʉmbombeli ʉjʉngɨ. Abalɨmi bala joope balɨnkʉnkoma, balɨnkʉmmbombela ɨngosya soni, balɨnkʉnkaga kɨsita kʉmpapo nafimo. ");
INSERT INTO nyy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Alɨnkʉntʉma kangɨ ʉgwa bʉtatʉ, joope balɨnkʉmfulasya, balɨnkʉnkaga. ");
INSERT INTO nyy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Po ʉmwene ngʉnda alɨnkwinogona alɨnkʉtɨ, ‘Mbombe ɨfiki? Ngʉntʉma ʉmwanangʉ ʉnkʉndwe. Pamo ʉjʉ jo bikwakʉmmwɨmɨkaga.’ ");
INSERT INTO nyy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Looli abalɨmi bala bo bammbwene, balɨnkʉjobesania balɨnkʉtɨ, ‘Ʉjʉ jo mwene kɨlɨngo. Isaga tʉnngoge, ʉkʉtɨ ɨkɨlɨngo kɨjege kyɨtʉ.’ ");
INSERT INTO nyy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Balɨnkʉnsoosyamo mu ngʉnda, balɨnkʉnngoga.” Po Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Ʉmwene ngʉnda jʉla ikwisa kʉbabombela sya fiki abalɨmi bala? ");
INSERT INTO nyy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ikwisa kʉbagoga abalɨmi bala, nʉ ngʉnda gʉla ikʉbapapo abangɨ!” Abandʉ bo bapɨliike ɨsyo, balɨnkʉjoba balɨnkʉtɨ, “Bʉno silɨngiisa kʉboneka ɨsyo sikʉ!” ");
INSERT INTO nyy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Looli Jesu alɨnkʉbakeeta, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Fiki sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ɨliibwe ɨlɨ abajenga nyumba baalɨkaanile, lyo lɨjile ibwe ikʉlʉmba pa lwalo, pa nguto’? ");
INSERT INTO nyy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Kʉkʉtɨ mundʉ ʉjʉ ikʉgwa pamwanya pi ibwe ɨlyo, ikʉkonyoka konyoka, na gwesa jʉla likʉnngwɨla, likʉntakania.” ");
INSERT INTO nyy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Abamanyisi baa ndagɨlo sya Moose na bapuuti abalongosi, balɨnkʉlonda ʉkʉnkola akabalɨlo kalakala, paapo baasyageenie ʉkʉtɨ, ɨkɨfwanikɨsyo ɨkɨ aabajobaga abeene. Looli balɨnkʉbatiila abandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Po paapo abalongosi baa Bajuuta balɨnkʉntegelela Jesu. Balɨnkʉbatʉma abandʉ baa kʉntendeela, aba baaliibɨɨkile ngatɨ bagolofu, ʉkʉtɨ bankole mbʉjobi bwake, po bantwale kʉ ndongosi gwa kiisʉ ʉkʉtɨ banndonge. ");
INSERT INTO nyy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Po abandʉ bala baalɨntegeliile, balɨnkʉnndaalʉʉsya Jesu balɨnkʉtɨ, “Gwe Mmanyisi, tʉmeenye ʉkʉtɨ kʉjoba nʉ kʉmanyisya ɨsya nalooli. Tʉmeenye ʉkʉtɨ ʉtikʉpaasya ɨsi bikwinogona abandʉ, ʉgwe kʉmanyisya ɨsya Kyala kʉ bwanalooli. ");
INSERT INTO nyy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bʉle, ɨndagɨlo sya Moose sikʉtwitɨkɨsya ʉkʉsonga ɨsongo kʉ malafyale gwa Balooma, pamo mma?” ");
INSERT INTO nyy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Looli Jesu alɨnkʉbʉmanya ʉbʉkomu bwabo, alɨnkʉbabʉʉla alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Namuunangɨsye ʉlʉtalama lʉmo ʉlwa ndenali. Ɨkɨfwani ɨkɨ kyani, nɨ ngamu ɨjɨ jaani?” Balɨnkʉmmwamula balɨnkʉtɨ, “Fya malafyale gwa Balooma.” ");
INSERT INTO nyy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Po ɨfya malafyale gwa Balooma mumpege ʉmalafyale gwa Balooma, nɨ fya Kyala mumpege Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Abandʉ bala balɨnkʉswiga fiijo ʉkwamula kwa Jesu, balɨnkʉmyeka. Balɨnkʉtoligwa ɨnongwa ɨjaa kʉnkolela, kʉnongwa jaa masyʉ aga ajobile nkyeni mmbandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ABasatukai bamo balɨnkʉbʉʉka kwa Jesu. Abeene baamanyisyaga ʉkʉtɨ abandʉ bakabagɨla ʉkʉsyʉka ʉkʉfuma mbafwe. Po balɨnkʉnndaalʉʉsya balɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Gwe Mmanyisi, Moose aatʉsimbiile mu ndagɨlo ʉkʉtɨ, ‘Lɨnga ʉmundʉ ikʉfwa kɨsita kʉpaapa ʉmwana najʉmo, ʉgwamyabo ammwingɨlengepo ɨkɨlɨngo ʉnkiikʉlʉ ʉmfwɨle jʉla, ʉkʉtɨ ampaapɨle abaana ʉjʉ afwile.’ ");
INSERT INTO nyy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Po baaliko abanyamundʉ bahaano na babɨlɨ. Ʉgwa kwanda alɨnkwega ʉnkiikʉlʉ, alɨnkʉfwa kɨsita kʉpaapa ʉmwana najʉmo. ");
INSERT INTO nyy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ʉgwa bʉbɨlɨ alɨnkʉmmwingɨlapo ɨkɨlɨngo ʉmfwɨle jʉla, joope alɨnkʉfwa kɨsita kʉpaapa nagwe, ");
INSERT INTO nyy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","nʉ gwa bʉtatʉ, joope alɨnkʉmmwingɨlapo. Bo lʉlʉʉlo boosa bahaano na babɨlɨ balɨnkʉmmwingɨlapo, balɨnkʉfwa kɨsita kʉpaapa nagwe. ");
INSERT INTO nyy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kʉmmalɨɨkɨsyo, ʉnkiikʉlʉ jʉla joope alɨnkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Abandʉ boosa bo basyʉkile, ʉnkiikʉlʉ jʉla ikwisa kʉjaga nkasi gwani? Paapo aalyegiigwemo na banyambala boosa bahaano na babɨlɨ.” ");
INSERT INTO nyy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Abandʉ baa nkabalɨlo aka bikwega nʉ kwegigwa. ");
INSERT INTO nyy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Looli aba Kyala ababwene ʉkʉtɨ babagiisye ʉkʉja nkiisʉ ɨkɨpya, nʉ kʉsyʉka ʉkʉfuma mbafwe, batikwisa kwega pamo ʉkwegigwa. ");
INSERT INTO nyy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bakabagɨla ʉkwisa kʉfwa kangɨ, paapo bikwisa kʉjaga bo ʉlwa bandʉmi. Abandʉ abo baana baa Kyala, paapo basyʉsiigwe ʉkʉfuma mbafwe. ");
INSERT INTO nyy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Joope Moose aatile, abafwe bikwisa kʉsyʉka. Aajobile ɨsyo mwa Kalata ʉMwikemo, pala aasimbile ɨsya kɨsyanjʉ ɨkɨ kyakaga ʉmooto. Aalɨnnjobile ʉNtwa Kyala, ʉkʉtɨ jo, ‘Kyala gwa Abulahamu, Kyala gwa Isaka na Kyala gwa Jaakobo.’ ");
INSERT INTO nyy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Po Kyala akaja jo Kyala gwa bafwe, looli gwa bʉʉmi, paapo kʉmyake boosa bʉʉmi.” ");
INSERT INTO nyy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Po abamanyisi baa ndagɨlo sya Moose bamo, balɨnkʉjoba balɨnkʉtɨ, “Gwe Mmanyisi, ʉjobile kanunu!” ");
INSERT INTO nyy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ʉkwandɨla apo, akaagelilepo ʉmundʉ najʉmo ʉkʉnndaalʉʉsya kangɨ Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Po Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Fiki abandʉ bikʉtɨ Meesija Mwana gwa malafyale Ndaabɨti? ");
INSERT INTO nyy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ʉmwene Ndaabɨti ikʉjoba mwa kalata gwa Ɨsabʉli ikʉtɨ, ‘ɄNtwa Kyala aalɨmmbʉʉlile ʉNtwa gwangʉ, “Itʉʉgasye kʉkɨbafu kyangʉ ɨkiilɨɨlo, ʉbʉjo ʉbwa lwɨmɨko fiijo, ");
INSERT INTO nyy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ʉkʉfika apa nikʉbabɨɨkaga abalʉgʉ baako paasi pa malʉndɨ gaako.” ’ ");
INSERT INTO nyy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Ndaabɨti ikʉnkoolela Meesija ʉkʉtɨ Ntwa. Po Meesija ikʉjaga mwanaake bʉleebʉle?” ");
INSERT INTO nyy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Abandʉ boosa bo bikʉmpɨlɨkɨsya, Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mujege maaso na bamanyisi baa ndagɨlo sya Moose. Biiganile ʉkwenda bo bafwele ɨmyenda ɨmitali, ʉkʉtɨ abandʉ babaponiege kʉ lwɨmɨko mu sokoni. Bikwisalɨla ʉkʉtʉʉgasya pa fikota ɨfya bɨɨmɨkigwa mu ngomaano, pabʉjo ʉbwa bɨɨmɨkigwa pa lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bikʉkabɨla mbʉsyobi ɨfyʉma kʉ bakiikʉlʉ abafwɨle, kangɨ bikwipuuta ɨnyiipuuto ɨndali, ɨsya kʉlabaasya. Pi isikʉ lya bʉlongi, bikwisa kwambɨlɨlaga ʉlʉfundo ʉlʉnywamu kwa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesu bo alɨ ndʉpaso lwa tempeli, alɨnkʉbabona abakabi bikʉsopa amakemo gaabo nkya kʉsopamo amakemo. ");
INSERT INTO nyy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Alɨnkʉmmbona joope ʉmfwɨle jʉmo ʉndondo, ikʉsopa mula ʉtʉsenti tʉbɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Po Jesu alɨnkʉjoba alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, ʉnkiikʉlʉ ʉjʉ ʉmfwɨle ʉndondo, asoosiisye fiijo ʉkʉbakɨnda boosa. ");
INSERT INTO nyy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Paapo abo boosa basopile ɨfi beegile mfyʉma fyabo ɨfi fijeelile, looli ʉmfwɨle ʉjʉ mbʉlondo bwake asoosiisye fyosa ɨfi aalɨ nafyo, ɨfi aafisʉʉbɨlaga mbʉʉmi bwake!” ");
INSERT INTO nyy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Abafundigwa bamo abaa Jesu baajobaga ɨsya tempeli, muno jaanokesiigwe na mabwe amanunu, nʉ tʉndʉ ʉtʉnunu ʉtʉ abandʉ baalɨnsookiisye Kyala. Looli Jesu alɨnkʉjoba alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ɨfi mukʉfikeeta, gikwisa amasikʉ aga lɨtikwisa kʉjako iibwe ɨlɨ lɨlɨ pamwanya pi ibwe iinine. Goosa gikwisa koomoligwa!” ");
INSERT INTO nyy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Abandʉ bala balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Gwe Mmanyisi, ɨsyo sikwisa ndɨli? Kangɨ kɨmanyilo nki kikwisa kʉtʉnangɨsya ʉkʉtɨ ɨsi silɨ kɨfuki ʉkʉboneka?” ");
INSERT INTO nyy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Mujege maaso, ʉkʉtɨ mulɨngiisa kʉsyobigwa! Abandʉ bingi bikwisa kʉbombelaga ɨngamu jangʉ, bikwisa kʉtɨgɨ, ‘Ʉne ne Meesija!’ Kangɨ bikʉtɨgɨ, ‘Akabalɨlo kasegeliile!’ Looli ʉmwe mulɨngiisa kʉbakongaga! ");
INSERT INTO nyy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bo mukʉpɨlɨka ɨsya bwite na kabini, mulɨngiisa kʉtiilaga. Paapo ɨsyo mpaka sikwisa kʉtala ʉkʉboneka, looli ʉbʉmalɨɨkɨsyo bo bʉkaalɨ.” ");
INSERT INTO nyy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesu alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Ɨkiisʉ kɨmo kikwisa kʉlwaga nɨ kiisʉ ɨkɨngɨ, nʉ bʉnyafyale bʉmo bukwisa kʉlwaga nʉ bʉnyafyale ʉbʉngɨ. ");
INSERT INTO nyy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kʉkʉtɨ bʉjo tukwisa kʉjako ʉtʉsenyenda ʉtʉnywamu, ɨnjala nɨ mbʉngo ɨjɨ jikwambʉkɨla abandʉ. Fikwisa kʉjako ɨfya kʉtiilɨsya, nɨ fimanyilo ɨfikʉlʉmba ʉkʉfuma kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Looli bo syosa ɨsyo sikaalɨ ʉkʉboneka, bikwisa kʉbakolaga ʉmwe nʉ kʉbafunda nɨ ngʉbɨlo, bikwisa kʉbatwalaga mbalongosi baa mu sinagogi, nʉ kʉbapinya mu nnyololo. Kangɨ bikwisa kʉbatwalaga nkyeni mbanyafyale na mbalongosi baa kiisʉ ʉkʉtɨ mulongigwege, paapo mulɨ bafundigwa bangʉ. ");
INSERT INTO nyy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Looli kʉmyɨnu ako ko kabalɨlo kaa kʉʉfumusya. ");
INSERT INTO nyy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mulɨngapaasyaga, ʉkʉtɨ mukwakwamula bʉleebʉle, bo bikʉbalaalʉʉsya pabʉlongi. ");
INSERT INTO nyy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Paapo ʉne angʉbapapo amasyʉ na mahala, aga akajako najʉmo ʉndʉgʉ gwɨnu, ʉjʉ abagiile ʉkʉgatola pamo ʉkʉgapɨnga. ");
INSERT INTO nyy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Kangɨ bikwisa kʉboohelaga ʉmwe, abapaapi bɨɨnu, abaamyɨnu, abakamu bɨɨnu na bamanyaani bɨɨnu. Bamo pakatɨ pamyɨnu mukwisa kʉgogigwaga. ");
INSERT INTO nyy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Abandʉ boosa bikwisa kʉbabengaga, paapo mulɨ bafundigwa bangʉ. ");
INSERT INTO nyy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Looli lʉtikwisa kʉsobapo nʉ lʉnywili nalʉmo ʉlwa mitʉ gyɨnu! ");
INSERT INTO nyy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kʉnongwa jaa kwikasya kwɨnu, mukwisa kʉkaba ʉbʉʉmi.” ");
INSERT INTO nyy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Bo mwagile akaaja kaa Jelusalemu kasyʉngʉʉtɨliigwe nɨ filʉndɨlo fya basikali, po mwise mumanyege ʉkʉtɨ kikʉja pakʉpyutigwa. ");
INSERT INTO nyy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Po abandʉ aba balɨ mu Jutai babopelege mfyamba, aba balɨ nkatɨ nkaaja basookengemo nʉ kʉbopa, na aba balɨ mmigʉnda balɨngagomokelangamo nkaaja. ");
INSERT INTO nyy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Paapo amasikʉ ago gikwisa kʉja gaa ngʉbɨlo, ʉkʉtɨ syosa ɨsi sisimbiigwe mwa Kalata ʉMwikemo siboneke. ");
INSERT INTO nyy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ahɨɨli abaa fifuba na aba bikongesya abaana nkabalɨlo ako! Paapo bukwisa kʉjako ʉbʉtolwe ʉbwingi nkiisʉ, nɨ ngalalɨsi sya Kyala kʉ bandʉ abaa nkiisʉ ɨkɨ. ");
INSERT INTO nyy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Abandʉ bamo bikwisa kʉgogigwa nɨ nyʉʉbo, abangɨ bikwisa kʉkoligwa, nʉ kwa kʉpinyigwa mfiisʉ fyosa. Abandʉ aba bakaja Bajuuta, bikwisa kʉkakanya akaaja kaa Jelusalemu mpaka akabalɨlo kaabo kamalɨke.” ");
INSERT INTO nyy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kangɨ fikwisa kʉbonekaga ɨfimanyilo mwi isʉba, mmwesi na mu ndondwa. Abandʉ abaa nkiisʉ, bikwisa kʉja nʉ bʉtolwe nʉ booga, kʉnongwa jaa koobela nʉ kʉsambʉka kwa nyanja. ");
INSERT INTO nyy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Abandʉ amaka gikwisa kʉbamalɨkɨla, kʉnongwa jaa lʉtende, bo bikʉguulɨla ɨfi fikwisa pakiisʉ, paapo ʉtʉndʉ toosa ʉtʉnywamu ʉtʉ tʉlɨ kʉmwanya, tukwisa kʉjʉngaanika. ");
INSERT INTO nyy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Po bikwisa kʉʉmbona ne Nnyamundʉ bo ngwisa mmabɨngo na maka amingi nʉ bʉsisya bwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ɨsyo bo syandile ʉkʉboneka, mwise mwikasyege, paapo ʉkʉpokigwa kwɨnu kʉlɨ kɨfuki!” ");
INSERT INTO nyy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesu alɨnkʉbabʉʉla abafundigwa baake ɨkɨfwanikɨsyo, alɨnkʉtɨ, “Namukeete ʉmpiki gwa nkʉjʉ nɨ mipiki ɨgɨngɨ gyosa. ");
INSERT INTO nyy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Amaani bo gikʉtʉlʉla, mukʉmanya ʉkʉtɨ ʉmpɨngo gʉsegeliile. ");
INSERT INTO nyy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bʉbʉʉbo na nuumwe bo mukʉsibona ɨsyo syosa, aamumanyege ʉkʉtɨ ʉBʉnyafyale bwa Kyala bʉsegeliile. ");
INSERT INTO nyy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nalooli nikʉbabʉʉla, abandʉ abaa nkabalɨlo aka, batikwisa kʉmalɨka ʉkʉfwa, bo syosa ɨsyo sikabombigwa. ");
INSERT INTO nyy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ʉmpaalanga nɨ kiisʉ fikwisa koomoka, looli amasyʉ gangʉ gatikoomokamo sikʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mujege maaso, ʉkʉtɨ ɨndumbula syɨnu silɨngakoligwa na kajɨɨlo akabiibi akaa bʉgaala bwalwa, nʉ kʉkoligwa nɨ mbombo ɨsya pakiisʉ. Iisikʉ lɨla lɨlɨngiisa kʉbaaga bo mwijɨbile. ");
INSERT INTO nyy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Paapo iisikʉ ɨlyo nakalɨnga likwisa kʉbaaga abandʉ boosa abaa pakiisʉ. ");
INSERT INTO nyy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Po mujege maaso akabalɨlo koosa, munsʉʉmege Kyala, ʉkʉtɨ muje na maka agaa kwendela kanunu ndɨ syosa ɨsi sikʉbonekaga, nʉ kwɨma nkyeni mu Nnyamundʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kʉkʉtɨ isikʉ Jesu aamanyisyaga ndʉpaso lwa tempeli. Pakɨlo aabʉʉkaga kʉkʉgona kʉ Kyamba kya Misyʉngʉtɨ. ");
INSERT INTO nyy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Abandʉ boosa baalaabɨlaga nʉlʉbʉnjʉ ʉkʉbʉʉka ndʉpaso lwa tempeli, ʉkʉtɨ bampɨlɨkɨsye. ");
INSERT INTO nyy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ɨkyaka ɨkya fisyesye ɨfisita nkese, ɨkɨ bikʉtɨ kyaka kya Pasa, kyasegeliile. ");
INSERT INTO nyy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Abapuuti abalongosi na bamanyisi baa ndagɨlo sya Moose baalondaga ɨnjɨla ɨjaa kʉnngogela Jesu. Baabombaga ɨsyo kʉbʉtiitʉ, paapo baabatiilaga abandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Seetano alɨnkʉmmwingɨla Juuta Isikalyoti, aalɨ jʉmo mbafundigwa baa Jesu kalongo na babɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Po Juuta alɨnkʉbʉʉka kʉ bapuuti abalongosi na bakʉlʉmba baa basikali aba baalɨndɨlɨlaga ɨtempeli, alɨnkwitɨkana nabo muno abagiile ʉkʉnndɨɨla Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Balɨnkʉhoboka, balɨnkwitɨkana nagwe ʉkʉnhomba ɨndalama. ");
INSERT INTO nyy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Po Juuta alɨnkwitɨka, alɨnkʉlonda ɨnjɨla ɨjaa kʉnndɨɨla Jesu, bo ɨkɨlʉndɨlo kya bandʉ kɨkajapo. ");
INSERT INTO nyy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Iisikʉ lya fisyesye ɨfisita nkese lɨlɨnkʉfika. Iisikʉ ɨlyo lyo isikʉ ɨlɨ baaboolaga akangʼoosi kaa kʉlya pa kyaka kya Pasa. ");
INSERT INTO nyy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Po Jesu alɨnkʉbatʉma baa Peeteli na Johani, alɨnkʉbabʉʉla alɨnkʉtɨ, “Mubʉʉke mukatʉtendekekesye ɨfindʉ fya Pasa, ʉkʉtɨ tʉlyemo.” ");
INSERT INTO nyy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Kʉlonda tʉkatendekekesye kʉʉgʉ?” ");
INSERT INTO nyy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Bo mwingiile nkaaja akaa Jelusalemu, mukwakwaganila nʉ nnyambala jʉmo, apɨmbile ɨndeko jaa mɨɨsi. Mukankongege mpaka nnyumba ɨjɨ ikwakwingɨla. ");
INSERT INTO nyy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mukammbʉʉle ʉmwene nyumba ʉkʉtɨ ʉMmanyisi ikʉkʉlaalʉʉsya ikʉtɨ, ‘Ɨkyumba kya baheesya kɨlɨ kʉʉgʉ? Ngʉlonda ʉkʉlɨɨlamo ɨkyaka kya Pasa pamopeene na bafundigwa bangʉ.’ ");
INSERT INTO nyy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ʉmwene nyumba ikwakʉbanangɨsya ɨkyumba ɨkɨnywamu ɨkya kʉ golofwa, kɨtendekesiigwe kanunu pa bʉtʉʉgalo, mukatendekesyege ɨfindʉ fya Pasa ʉmo.” ");
INSERT INTO nyy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Balɨnkʉbʉʉka, balɨnkwakʉsyaga syosa bo muumo Jesu aababʉʉliile. Po balɨnkʉtendekesya ɨfindʉ fya Pasa. ");
INSERT INTO nyy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Namajolo akabalɨlo kaa kʉlya bo kafikile, Jesu alɨnkʉtʉʉgala pakʉlya ɨfindʉ pamopeene na batʉmigwa baake kalongo na babɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Nnyonyilwe fiijo ʉkʉlya ɨPasa ɨjɨ pamopeene na nuumwe, bo taasi ngaalɨ ʉkʉtaamigwa. ");
INSERT INTO nyy_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nikʉbabʉʉla nikʉtɨ, ndikwisa kwandɨsyamo sikʉ ʉkʉlya ɨfindʉ fya Pasa, mpaka apa ngwisa kʉlya ɨPasa ɨjaa nalooli mBʉnyafyale bwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Po alɨnkwega ɨkɨkombe ɨkya finga, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉjoba alɨnkʉtɨ, “Namwege ɨkɨkombe ɨkɨ ɨkya finga, kʉkʉtɨ mundʉ anwe! ");
INSERT INTO nyy_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Paapo nikʉbabʉʉla nikʉtɨ, ndikwisa kʉnwamo kangɨ ɨfinga mpaka bwise ʉBʉnyafyale bwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Alɨnkwega ɨkɨsyesye, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉkɨmenya, alɨnkʉbapapo, alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉgʉ go mbɨlɨ gwangʉ, ʉgʉ gʉningiigwe kʉnongwa jɨɨnu. Mubombege bo ʉlʉ ʉkʉngʉmbʉka ʉne.” ");
INSERT INTO nyy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kangɨ bo baliile ɨfindʉ, Jesu alɨnkwega ɨkɨkombe ɨkya finga, alɨnkʉtɨ, “Ɨkɨkombe ɨkɨ ɨkya finga lo lwitɨkano ʉlʉpya mwi ilopa lyangʉ, ɨlɨ likooneka ʉkʉbapoka ʉmwe. ");
INSERT INTO nyy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Looli ʉjʉ ikʉja pakʉʉndɨɨla, ikʉlya pamopeene na niine apa pa meesa. ");
INSERT INTO nyy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Paapo ʉne Nnyamundʉ angʉfwa bo muno Kyala aasibaatɨkiile, looli ahɨɨli ʉmundʉ ʉjʉ ikʉʉndɨɨla!” ");
INSERT INTO nyy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Balɨnkwanda ʉkʉlaalʉʉsania ʉkʉtɨ jo jwani ikʉja pakʉbomba ɨsyo. ");
INSERT INTO nyy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Po abatʉmigwa balɨnkwanda ʉkʉkaanikana, ʉkʉtɨ jo jwani nkʉlʉmba nkɨbugutɨla kyabo. ");
INSERT INTO nyy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Abanyafyale baa pakiisʉ apa biiganile ʉkʉbalagɨla abandʉ kʉ bʉkalɨ, bikʉjobigwa ʉkʉtɨ batʉʉli baa bandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Looli kʉmyɨnu ʉmwe silɨngajaga bo ʉlo. Ʉjʉ jo nkʉlʉmba nkɨbugutɨla kyɨnu, jo ajege bo ʉnnandɨ. Kangɨ ʉjʉ ikʉlongosya, ikʉlondigwa ababombelege abangɨ. ");
INSERT INTO nyy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Po jwani nkʉlʉmba kʉ nnine? Ʉjʉ atʉʉgeele pakʉlya ɨfindʉ pamo ʉjʉ ikʉntwalɨla ɨfindʉ? Bʉle, akaja jo ʉjʉ atʉʉgeele pakʉlya? Looli ʉne nkɨbugutɨla kyɨnu ndɨ bo ʉmbombeli. ");
INSERT INTO nyy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ʉmwe jo ʉmwe musyele na niine, bo ndɨ mbʉtolwe ʉbwa ngelo. ");
INSERT INTO nyy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ʉne ngʉbapapo ʉmwe ʉBʉnyafyale bo ʉlʉ Taata aalɨmbeele ʉne, ");
INSERT INTO nyy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ʉkʉtɨ mwise mulye nʉ kʉnwa mBʉnyafyale bwangʉ, kangɨ mwise mutʉʉgale pa fikota fya bʉtwa, ʉkʉtɨ mufilonge ɨfikolo kalongo na fibɨlɨ ɨfya Isilaɨli.” ");
INSERT INTO nyy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesu alɨnkʉjoba alɨnkʉtɨ, “Simoni, Simoni! Seetano asʉʉmile kwa Kyala, ʉkʉbagela ʉmwe mwesa, bo ʉlwa ndɨmi ʉjʉ ikʉlʉlʉʉsya. ");
INSERT INTO nyy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Looli ngwipuutiile, ʉkʉtɨ ʉlwitɨko lwako lʉlɨnganaganika. Bo gʉʉngomokiile, gwise ʉbakasyege abafundigwa biinaako.” ");
INSERT INTO nyy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Po Simoni alɨnkʉmmwamula alɨnkʉtɨ, “Gwe Ntwa, ʉne niitendekiisye ʉkʉpinyigwa, poope nʉ kʉfwa pamopeene na nungwe!” ");
INSERT INTO nyy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesu alɨnkʉtɨ, “Nikʉkʉbʉʉla Simoni Peeteli ʉkʉtɨ, bo ɨngongobe jɨkaalɨ ʉkʉkoolela ʉmwisyʉgʉ, ʉgwe kʉngaana katatʉ ʉkʉtɨ ʉkaamanya.” ");
INSERT INTO nyy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Po Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Bo mbatʉmile kɨsita ndalama, pamo ɨkɨnyambɨ, pamo ɨfilato, bʉle, mwalyagiilwe fimo?” Balɨnkʉtɨ, “Mma, tʉkaalyagiilwe nafimo.” ");
INSERT INTO nyy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉlʉ, ʉjʉ alɨ na kanyambɨ akaa ndalama akolelege, na joope ʉjʉ alɨ nɨ kɨnyambɨ akolelege. Ʉjʉ akaja nʉ lʉʉbo, ʉʉlɨsyege ikoti lyake, akʉʉle. ");
INSERT INTO nyy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Paapo nikʉbabʉʉla, sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Aabaliigwe pamopeene na batʉlanongwa.’ Nalooli syosa ɨsi sisimbiigwe kʉnongwa jangʉ, mpaka sibombigwe.” ");
INSERT INTO nyy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Abafundigwa baake balɨnkʉtɨ, “Gwe Ntwa, keeta, apa silipo ɨnyʉʉbo ibɨlɨ.” Alɨnkʉbaamula alɨnkʉtɨ, “Tʉsileke ɨsyo.” ");
INSERT INTO nyy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Po Jesu alɨnkʉsookamo mu Jelusalemu, alɨnkʉbʉʉka kʉ Kyamba kya Misyʉngʉtɨ, bo muno lwajɨɨliile ʉlwiho lwake, abafundigwa baake balɨnkʉnkonga. ");
INSERT INTO nyy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bo afikile pabʉjo bʉla, alɨnkʉbabʉʉla alɨnkʉtɨ, “Mwipuutege, ʉkʉtɨ mulɨngiisa kʉtoligwa nɨ ngelo.” ");
INSERT INTO nyy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Alɨnkʉsookapo apa baalipo, alɨnkʉbʉʉka pabʉtalipo, apa likʉgomokela iibwe lɨnga ʉmundʉ atuunyile. Alɨnkʉfugama, alɨnkwipuuta, ");
INSERT INTO nyy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","alɨnkʉtɨ, “Gwe Taata! Lɨnga bwigane bwako, ʉʉsookesyepo ɨngʉbɨlo ɨsi. Leelo bʉlɨngabombigwa ʉbwigane bwangʉ, looli ʉbwako!”  ");
INSERT INTO nyy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Po ʉgwandʉmi ʉkʉfuma kʉmwanya alɨnkʉmmwisɨla, alɨnkʉmpa amaka. ");
INSERT INTO nyy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aalɨ mu ngʉbɨlo ɨnywamu ɨsya mu ndumbula, po alɨnkʉkɨndɨlɨla fiijo ʉkwipuuta, amafuku gaake galɨnkʉja bo ʉlwa matondobya gaa ilopa, galɨnkʉtoonya paasi. ");
INSERT INTO nyy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bo iipuutile, alɨnkwɨma, alɨnkʉbʉʉka kʉ bafundigwa baake, alɨnkʉbaaga bagonile ʉtʉlo, kʉnongwa jaa bʉsulumanie. ");
INSERT INTO nyy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Fiki mukʉgona ʉtʉlo? Namusumuke! Mwipuutege, ʉkʉtɨ mulɨngiisa kʉtoligwa nɨ ngelo.” ");
INSERT INTO nyy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bo akaalɨ ikʉjoba, nakalɨnga kɨlɨnkwisa ɨkɨlʉndɨlo kya bandʉ, kɨlongosiigwe na Juuta, ʉgwa ndɨ bala kalongo na babɨlɨ. Alɨnkʉsegelela kwa Jesu, alɨnkʉmfipa. ");
INSERT INTO nyy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesu alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Juuta! Kʉʉndɨɨla ne Nnyamundʉ kʉ njɨla jaa kʉʉfipa?” ");
INSERT INTO nyy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Abafundigwa baa Jesu bo basibwene ɨsyo, balɨnkʉjoba balɨnkʉtɨ, “Gwe Ntwa! Bʉle, tʉbasenge nɨ nyʉʉbo?” ");
INSERT INTO nyy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Po ʉmwinaabo jʉmo alɨnkʉnsenga nʉ lʉʉbo ʉntʉmwa gwa mpuuti ʉnkʉlʉmba, ɨmbʉlʉkʉtʉ jaa kʉ kiilɨɨlo. ");
INSERT INTO nyy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesu alɨnkʉjoba alɨnkʉtɨ, “Namuleke ʉkʉbomba ɨsyo!” Alɨnkʉpalamaasya ɨmbʉlʉkʉtʉ jaa ntʉmwa jʉla, alɨnkʉmmbʉmbʉlʉsya. ");
INSERT INTO nyy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesu alɨnkʉbabʉʉla abapuuti abalongosi, abakʉlʉmba baa basikali abaa mu tempeli, pamopeene na balongosi baa Bajuuta, aba baaliisile kʉkʉnkola, alɨnkʉtɨ, “Bʉle, mwisile mukolile ɨnyʉʉbo nɨ nduuha ngatɨ mukʉlɨkola inyambuta? ");
INSERT INTO nyy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bwila naatʉʉgalaga nkyeni mmyɨnu ndʉpaso lwa tempeli, mukaalɨngolilemo sikʉ! Looli aka kabalɨlo kɨɨnu, kabalɨlo kaa bʉlagɨli bwa ngiisi.” ");
INSERT INTO nyy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Po abandʉ bala balɨnkʉnkola Jesu, balɨnkʉntwala kʉkaaja kaa mpuuti ʉnkʉlʉmba. Peeteli alɨnkʉnkonga pabʉtalipo. ");
INSERT INTO nyy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Abandʉ balɨnkʉkosya ʉmooto pakatɨ pa lʉpaso, balɨnkʉtʉʉgala pamopeene, joope Peeteli alɨnkʉtʉʉgala pamopeene nabo. ");
INSERT INTO nyy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ʉmbombi jʉmo ʉndɨndwana, alɨnkʉmmbona Peeteli atʉʉgeele apa ʉmooto gwakaga, aalɨnkeetile kanunu, alɨnkʉjoba alɨnkʉtɨ, “Joope ʉjʉ, aalɨ pamopeene na Jesu.” ");
INSERT INTO nyy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Looli Peeteli alɨnkʉkaana alɨnkʉtɨ, “Gwe nkiikʉlʉ ʉgwe! Ʉne ngammanya!” ");
INSERT INTO nyy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bo bangeelepo panandɨ, ʉmundʉ ʉjʉngɨ alɨnkʉmmbona Peeteli, alɨnkʉjoba alɨnkʉtɨ, “Na nungwe ʉlɨ mwinaabo bala.” Peeteli alɨnkʉmmwamula alɨnkʉtɨ, “Gwe mundʉ ʉgwe, ʉngaasaaka ʉne!” ");
INSERT INTO nyy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bo jɨkɨndile ɨsala jɨmo bʉno, ʉmundʉ ʉjʉngɨ alɨnkʉsisimɨkɨsya, alɨnkʉjoba alɨnkʉtɨ, “Nalooli ʉmundʉ ʉjʉ aalɨ pamopeene na Jesu! Paapo joope ʉjʉ Ngalilai!” ");
INSERT INTO nyy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Looli Peeteli alɨnkwamula alɨnkʉtɨ, “Gwe mundʉ ʉgwe, ɨsi kʉsijoba ngasimanya!” Nakalɨnga bo alɨ pakʉjoba ɨsyo, ɨngongobe jɨlɨnkʉkoolela. ");
INSERT INTO nyy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ɄNtwa Jesu alɨnkʉsanuka, alɨnkʉnkeeta Peeteli. Po Peeteli alɨnkʉgakʉmbʉka amasyʉ aga ʉNtwa aalɨmmbʉʉlile ʉkʉtɨ, “Lɨɨlɨno ɨngongobe bo jɨkaalɨ ʉkʉkoolela, kʉngaana katatʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Po alɨnkʉsooka panja, alɨnkʉlɨla fiijo. ");
INSERT INTO nyy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Abasikali aba banndɨndɨlɨlaga Jesu, balɨnkʉmmʉʉgɨɨlɨla nʉ kʉnkoma. ");
INSERT INTO nyy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Balɨnkʉmpinya nɨ kɨtambala kʉmaaso, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Kunguluka! Jo jwani akʉkomile?” ");
INSERT INTO nyy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Balɨnkʉntʉka amaheelu agangɨ amingi. ");
INSERT INTO nyy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bo bʉkiile, balɨnkʉkomaana abaa lʉkomaano lwa Sanihendilini, ʉlʉ bikʉjamo abalongosi baa Bajuuta, abapuuti abalongosi, na bamanyisi baa ndagɨlo sya Moose. Po abasikali balɨnkʉntwala Jesu nkyeni mmyabo. ");
INSERT INTO nyy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Po balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Tʉbʉʉle, ʉgwe gwe Meesija?” Jesu alɨnkʉbaamula alɨnkʉtɨ, “Nalɨnga mbabʉʉlile, mutikʉʉnyiitɨka. ");
INSERT INTO nyy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kangɨ lɨnga ngʉbalaalʉʉsya, mutikʉʉnyaamula. ");
INSERT INTO nyy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Looli ʉkwandɨla lɨɨlɨno, ʉne ne Nnyamundʉ ngʉtʉʉgalaga kʉmwanya, pabʉjo ʉbwɨmɨkigwa, kʉkɨbafu ɨkiilɨɨlo ɨkya Kyala ʉMwene maka.” ");
INSERT INTO nyy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Balɨnkʉjoba boosa balɨnkʉtɨ, “Kokʉtɨ ʉgwe ʉlɨ Mwana gwa Kyala?” Jesu alɨnkʉbaamula alɨnkʉtɨ, “Mujobile ɨsya nalooli.” ");
INSERT INTO nyy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Po balɨnkʉjoba balɨnkʉtɨ, “Tukʉbʉlonda ʉbʉkeeti bwa fiki? Keeta, tʉpɨliike jʉjʉʉswe amasyʉ ʉkʉfuma nkanwa mmyake!” ");
INSERT INTO nyy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Po abalongosi abakʉlʉmba bala abaa Bajuuta, balɨnkwɨma, balɨnkʉntwala Jesu kwa Pilati, ʉndongosi gwa kiisʉ ɨkya Jutai. ");
INSERT INTO nyy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Balɨnkwanda ʉkʉnsitaaka balɨnkʉtɨ, “Ʉmundʉ ʉjʉ tʉmmbwene ikʉbasofya abandʉ baa nkiisʉ kyɨtʉ. Ikʉkaanisya abandʉ ʉkʉsonga ɨsongo kʉ malafyale gwa Balooma, kangɨ ikwijoba ʉkʉtɨ ʉmwene jo Meesija, ʉMalafyale.” ");
INSERT INTO nyy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Po Pilati alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Bʉle, ʉgwe ʉlɨ Malafyale gwa Bajuuta?” Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Bo lɨlɨɨlyo ʉjobile.” ");
INSERT INTO nyy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilati alɨnkʉbabʉʉla abapuuti abalongosi nɨ kɨlʉndɨlo ɨkya bandʉ, alɨnkʉtɨ, “Ngajaagamo ɨnongwa najɨmo mmundʉ ʉjʉ.” ");
INSERT INTO nyy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Looli abeene balɨnkʉsisimɨkɨsya ʉkʉjoba balɨnkʉtɨ, “Ikʉbasonga abandʉ ʉkʉbʉsambʉkɨla ʉbʉnyafyale nɨ manyisyo syake, moosa mu Jutai. Aalyandiile kʉ Galilai mpaka afikile kʉno.” ");
INSERT INTO nyy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilati bo apɨliike ɨsyo, alɨnkʉlaalʉʉsya alɨnkʉtɨ, “Bʉle, ʉmundʉ ʉjʉ gwa mu Galilai?” ");
INSERT INTO nyy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bo asyageenie ʉkʉtɨ Ngalilai, ikʉfuma mbʉnyafyale bwa Heloti, alɨnkʉntʉma kwa Heloti, ʉjʉ joope akabalɨlo ako aalimo mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heloti bo ammbwene Jesu, aahobwike fiijo, paapo amasikʉ mingi aalondaga ʉkʉmmbona. Aapɨliike ɨnongwa syake, aasʉʉbɨlaga ʉkʉmmbona Jesu ikʉbomba ɨkiika kɨmo. ");
INSERT INTO nyy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Po Heloti alɨnkʉnndaalʉʉsya Jesu amasyʉ mingi, looli ʉmwene akaalɨmmwamwile iisyʉ nalɨmo. ");
INSERT INTO nyy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Abapuuti abalongosi na bamanyisi baa ndagɨlo sya Moose baalipo, balɨnkʉjoba amasyʉ gaa kʉnsitaaka kʉ maka fiijo. ");
INSERT INTO nyy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Po Heloti na basikali baake, balɨnkʉmmwangalɨla nʉ kʉmmoobela. Balɨnkʉmfwɨka ɨmyenda ɨgya bʉnyafyale, balɨnkʉntwala kangɨ kwa Pilati. ");
INSERT INTO nyy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ɨliisikʉ ɨlyo, Heloti na Pilati balɨnkʉja bamanyaani, paapo kʉnyuma baalɨ kɨlʉgʉ. ");
INSERT INTO nyy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Po Pilati alɨnkʉbabʉngaania abapuuti abalongosi, abalongosi baa bandʉ na bandʉ abangɨ. ");
INSERT INTO nyy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉmundʉ ʉjʉ muntwele kʉmyangʉ, mukʉnsitaaka ʉkʉtɨ ikʉbasonga abandʉ ʉkʉbʉsambʉkɨla ʉbʉlongosi bwa kiisʉ. Nʉnndaalʉʉsiisye nkyeni mmyɨnu, looli ngajaaga ɨnongwa najɨmo ɨjɨ atʉlile, ndɨ syosa ɨsi munsitaakile. ");
INSERT INTO nyy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Joope Heloti akajaaga ɨnongwa najɨmo kʉmyake, fyobeene anngomwisye kʉmyɨtʉ. Akabomba nasimo ɨsya kʉmpelela ʉkʉlongigwa ʉkʉgogigwa. ");
INSERT INTO nyy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Po leelo, ikʉkomigwa ɨfingoti, po ngʉmmwabʉlaga.”  ");
INSERT INTO nyy_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Lwalɨ lwiho ʉkʉmmwabʉla ʉmpinyigwa jʉmo pa kyaka kya Pasa. ");
INSERT INTO nyy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Looli abandʉ boosa balɨnkʉjwega palɨkɨmokyene balɨnkʉtɨ, “Nngoge ʉmundʉ ʉjʉ! Ʉtwabʉlɨle Balaba!” ");
INSERT INTO nyy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba aapinyiigwe mu nnyololo, paapo aapelile ʉkʉsambʉka abandʉ nkaaja ʉkʉpɨnga ʉbʉlongosi bwa kiisʉ, na kʉnongwa jaa bʉgogi. ");
INSERT INTO nyy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilati aalondaga ʉkʉmmwabʉla Jesu, alɨnkʉjoba na bandʉ kangɨ. ");
INSERT INTO nyy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Looli abeene balɨnkongelapo ʉkʉjwega balɨnkʉtɨ, “Nkomelele pa kɨkohekano! Nkomelele pa kɨkohekano!” ");
INSERT INTO nyy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilati alɨnkʉjoba nabo kangɨ ʉlwa bʉtatʉ alɨnkʉtɨ, “Fiki? Abombile mbiibi nki? Ʉne ngajaaga ɨnongwa najɨmo kʉmyake, ɨjaa kʉmpelela ʉkʉtɨ alongigwe ʉkʉgogigwa! Kʉnongwa ɨjo ngʉlagɨla akomigwe ɨfingoti, po ngʉmmwabʉlaga.” ");
INSERT INTO nyy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Looli abandʉ balɨnkʉkɨndapo ʉkʉjwega kʉ maka fiijo, balɨnkʉʉmɨɨlɨla ʉkʉsʉʉma ʉkʉtɨ Jesu akomeleligwe pa kɨkohekano. Ʉnjwego gwabo gʉlɨnkʉpela ʉkʉtɨ biitɨkɨsigwe. ");
INSERT INTO nyy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Po Pilati alɨnkʉtumula ʉkʉtɨ sibombigwe ɨsi baasʉʉmaga. ");
INSERT INTO nyy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Alɨnkʉmmwabʉla Balaba ʉjʉ aapinyiigwe kʉnongwa jaa kʉbasonga abandʉ ʉkʉbʉsambʉkɨla ʉbʉlongosi bwa kiisʉ, na kʉnongwa jaa bʉgogi, alɨnkʉbapapo Jesu abasikali, ʉkʉtɨ bammbombele ɨsi baalondaga abandʉ. ");
INSERT INTO nyy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Abasikali bo bikʉntwala Jesu kʉkʉnngoga, balɨnkwaganila nʉ mundʉ jʉmo ɨngamu jaake Simoni ʉgwa mu Kilene, aafumile mmigʉnda, iisaga nkaaja. Balɨnkʉnkola, balɨnkʉntwɨka ɨkɨkohekano ʉkʉtɨ ampɨmbɨle Jesu. Po alɨnkʉpɨmba, alɨnkʉnkonga Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ɨkɨlʉndɨlo ɨkɨnywamu kya bandʉ kɨlɨnkʉnkonga Jesu. Nkɨlʉndɨlo ɨkyo, baalimo abakiikʉlʉ aba banndɨlɨlaga nʉ kʉnkuutɨla. ");
INSERT INTO nyy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesu alɨnkʉbasanukɨla, alɨnkʉbabʉʉla alɨnkʉtɨ, “Mwe bakiikʉlʉ baa mu Jelusalemu! Mulɨngaandɨlɨlaga ʉne, looli mwilɨlɨlege mwibeene na baanɨɨnu! ");
INSERT INTO nyy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Paapo gikwisa amasikʉ aga abandʉ bikʉtɨgɨ, ‘Basajiigwe abakiikʉlʉ abagʉmba, aba bakapaapamo nʉ kongesyamo abaana!’ ");
INSERT INTO nyy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Po, ‘Abandʉ bikwisa kʉfibʉʉlaga ɨfyamba ʉkʉtɨ, “Namutʉgwɨlege!” Kangɨ nʉ twamba ʉkʉtɨ, “Namutʉsyɨlege!” ’ ");
INSERT INTO nyy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Abandʉ bikʉʉmbombela ʉne bo ʉlʉ, ne ngaja ntʉlanongwa. Po sikwisa kʉjaga bʉleebʉle kʉ batʉlanongwa?” ");
INSERT INTO nyy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Balɨnkʉbatwala boope abanyambuta babɨlɨ, ʉkʉtɨ bagogiigwe pamopeene na Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Po balɨnkʉfika pabʉjo ʉbʉ ɨngamu jaake bikʉtɨ Lʉpaja lwa Ntʉ, balɨnkʉbakomelela pa fikohekano, Jesu na banyambuta babɨlɨ bala, jʉmo kʉkɨbafu ɨkiilɨɨlo, nʉ jʉngɨ kʉkɨbafu ɨkiimama. ");
INSERT INTO nyy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Po Jesu alɨnkʉtɨ, “Gwe Taata, ʉbahobokele, paapo bakasimanya ɨsi balɨ pakʉsibomba.” Balɨnkʉjabana ɨmyenda gyake kʉ njɨla jaa bʉlagʉsi. ");
INSERT INTO nyy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Abandʉ baalyɨmile kɨfuki baakeetaga. Abalongosi baa Bajuuta bammwangalɨlaga Jesu, baatɨgɨ, “Aabapokaga abangɨ, oko na iipoke ʉmwene, lɨnga jo Meesija gwa Kyala, ʉnsʉngʉligwa gwake!” ");
INSERT INTO nyy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Abasikali boope balɨnkʉmmwangalɨla, balɨnkʉsegelela kʉmyake, balɨnkʉmpa ɨfinga ɨngalɨ, ");
INSERT INTO nyy_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kangɨ balɨnkʉtɨ, “Lɨnga ʉgwe ʉlɨ Malafyale gwa Bajuuta, na gwipoke gwimwene!” ");
INSERT INTO nyy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pamwanya pa kɨkohekano baasimbile baatile, ");
INSERT INTO nyy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jʉmo mbanyambuta aba baakomeleliigwe pa kɨkohekano kɨfuki na Jesu, alɨnkʉntʉka Jesu alɨnkʉtɨ, “Ʉgwe ʉkaja gwe Meesija? Gwipoke gwimwene kangɨ ʉtʉpoke na nuuswe!” ");
INSERT INTO nyy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Looli ʉnnyambuta ʉjʉngɨ alɨnkʉnkemela ʉnnine alɨnkʉtɨ, “Ʉgwe ʉtikʉntiila Kyala, na apa nungwe ʉlongiigwe ʉkʉfwa bo ʉmwene? ");
INSERT INTO nyy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ʉswe kʉtʉbagiile ʉkʉlongigwa kʉnongwa jaa ɨsi tʉbombile, looli ʉmundʉ ʉjʉ akabomba ɨmbiibi najɨmo.” ");
INSERT INTO nyy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Po alɨnkʉjoba alɨnkʉtɨ, “Gwe Jesu! Bo kwingɨla mBʉnyafyale bwako gʉngʉmbʉkege!” ");
INSERT INTO nyy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Nalooli nikʉkʉbʉʉla nikʉtɨ, lɨɨlɨno kwakʉjaga pamopeene na niine kʉmwanya.” ");
INSERT INTO nyy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jaalɨ sala jaa 6:00 bʉno pamuusi, ɨngiisi jɨlɨnkʉgwa nkiisʉ kɨla kyosa, mpaka ɨsala jaa 9:00, ");
INSERT INTO nyy_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","iisʉba lɨlɨnkʉleka ʉkʉbala. Ɨliibaalɨka lya tempeli lɨlɨnkʉnyaafuka pakatɨ na pakatɨ. ");
INSERT INTO nyy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Po paapo Jesu alɨnkʉlaata ʉkʉkuuta alɨnkʉtɨ, “Gwe Taata! Ʉbʉʉmi bwangʉ ngʉbʉbɨɨka mmaboko gaako.” Bo ajobile ɨsyo, alɨnkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ʉndongosi gwa basikali bo asibwene ɨsi siboniike, alɨnkʉntuufya Kyala, alɨnkʉjoba alɨnkʉtɨ, “Nalooli ʉmundʉ ʉjʉ aalɨ ngolofu!” ");
INSERT INTO nyy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Abandʉ boosa aba baabʉngeene pala, pakʉsikeeta ɨsi siboniike, balɨnkʉgomoka kʉmyabo, kʉno bikwikoma koma mfipambaga fyabo, ʉkʉnangɨsya ʉbʉsulumanie. ");
INSERT INTO nyy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Looli abandʉ boosa aba baalɨmmeenye, pamopeene na bakiikʉlʉ aba baalongoseenie nagwe ʉkʉfuma mu Galilai, baalyɨmile pabʉtali ʉkʉsikeeta ɨsyo. ");
INSERT INTO nyy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Aalipo ʉmundʉ jʉmo ɨngamu jaake Joosefu, ʉgwa mu Alimatai, nkiisʉ ɨkya Jutai. Aalɨ mundʉ nnunu kangɨ ngolofu, aabʉguulɨlaga ʉBʉnyafyale bwa Kyala ʉkwisa. Akaaliitɨkeene na balongosi banine abaa ndʉkomaano lwa Sanihendilini, kʉlɨ ɨsi baalɨmmbombiile Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ʉmundʉ ʉjʉ alɨnkʉbʉʉka kwa Pilati, alɨnkʉnsʉʉma ʉkʉtɨ ampepo ʉmfimba gwa Jesu, akasyɨle. ");
INSERT INTO nyy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilati alɨnkwitɨka, po alɨnkʉgʉsulusya paasi ʉmfimba ʉkʉfuma pa kɨkohekano. Alɨnkʉgʉniembeteelela mmwenda ʉnnunu, alɨnkʉgʉbɨɨka mwi ipʉmba ɨlɨ lyasongoleliigwe kɨlɨngaani ndwalabwe, ɨlɨ bakaalɨnsyɨlilemo ʉmundʉ najʉmo. ");
INSERT INTO nyy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɨliisikʉ ɨlyo, lyalɨ isikʉ ɨlya kwitendekesya, bo ɨSabati jikʉja pakwanda. ");
INSERT INTO nyy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Abakiikʉlʉ bala aba baalongoseenie na Jesu ʉkʉfuma mu Galilai, balɨnkʉnkonga Joosefu, balɨnkʉlɨbona iipʉmba, nʉ mfimba gwa Jesu muno gʉlambalɨkiigwe. ");
INSERT INTO nyy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Po balɨnkʉgomoka kʉkaaja, balɨnkʉtendekesya ɨmikota na mafuta gaa lʉʉma ʉlʉnunu. Looli pi isikʉ ɨlya pa Sabati, balɨnkʉtʉʉsya ʉkʉkongana nɨ ndagɨlo sya Moose. ");
INSERT INTO nyy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nʉlʉbʉnjʉ fiijo pi isikʉ ɨlya pa ndʉngʉ, abakiikʉlʉ bala balɨnkʉbʉʉka kwi ipʉmba, baatwele ɨmikota ɨgɨ baatendekiisye. ");
INSERT INTO nyy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bo bafikile balɨnkwaga iibwe lɨbungulusiigwe ʉkʉfuma pa kɨfigo ɨkya ipʉmba. ");
INSERT INTO nyy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Balɨnkwingɨla nkatɨ, balɨnkwaga ʉmfimba gwa Ntwa Jesu gʉkajamo. ");
INSERT INTO nyy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bo bakaalɨ bikʉswiga ɨsyo, nakalɨnga abandʉmi babɨlɨ, aba baafwele ɨmyenda ɨgɨ gikʉlangala, balɨnkwɨma kɨfuki nabo. ");
INSERT INTO nyy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Abakiikʉlʉ abo balɨnkʉtiila, balɨnkwinama paasi. Looli abandʉmi bala balɨnkʉbabʉʉla balɨnkʉtɨ, “Fiki mukʉnndonda ʉmʉʉmi mbafwe? ");
INSERT INTO nyy_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Akajapo apa! Asyʉkile! Namukʉmbʉkege amasyʉ aga aababʉʉlile, bo alɨ na nuumwe mu Galilai, ");
INSERT INTO nyy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","aatile, ‘Mpaka Nnyamundʉ abɨɨkigwe kʉ batʉlanongwa, akomeleligwe pa kɨkohekano, na pi isikʉ lya bʉtatʉ asyʉke!’ ” ");
INSERT INTO nyy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Po abakiikʉlʉ bala balɨnkʉgakʉmbʉka amasyʉ gaa Jesu. ");
INSERT INTO nyy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Po balɨnkʉsookapo pi ipʉmba, balɨnkʉbʉʉka apa baalipo abafundigwa baa Jesu bala kalongo na jʉmo, na bafundigwa abangɨ boosa, balɨnkʉbabʉʉla syosa ɨsi baasibwene. ");
INSERT INTO nyy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Abakiikʉlʉ aba baababʉʉlile abatʉmigwa baa Jesu ɨnongwa ɨsyo, bo baa Malija ʉgwa kʉ Magatala, Joana, Malija ʉnna gwa Jaakobo, na bakiikʉlʉ abangɨ aba baalɨ pamopeene nabo. ");
INSERT INTO nyy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Looli abatʉmigwa bo bapɨliike ɨnongwa ɨsi baabʉʉliigwe na bakiikʉlʉ bala, bakaasiitiike, balɨnkwaga ngatɨ sya mwalo. ");
INSERT INTO nyy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Looli Peeteli alɨnkwɨma, alɨnkʉbopa ʉkʉbʉʉka kwi ipʉmba. Alɨnkwinama, alɨnkʉlingʉlɨla mwi ipʉmba, alɨnkʉgʉbona gwene ʉmwenda ʉgʉ baalɨnsyɨliile Jesu. Alɨnkʉsookapo pala, kʉno ikʉswiga ɨsi syaboniike. ");
INSERT INTO nyy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ɨliisikʉ lɨlalɨla, abafundigwa babɨlɨ baa Jesu bendaga mu njɨla ʉkʉbʉʉka nkaaja akaa mu Emau, aka kaalɨ pabʉtali bwa kilomita kalongo na jɨmo ʉkʉfuma kʉ Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bo bikwenda mu njɨla, baajobaga ɨnongwa syosa ɨsi syaboniike. ");
INSERT INTO nyy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bo bikʉjoba nʉ kʉlaalʉʉsania, Jesu jʉʉjo alɨnkʉsegelela nʉ kwenda pamopeene nabo. ");
INSERT INTO nyy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Looli amaaso gaabo gaakoliigwe, ʉkʉtɨ balɨngammanya. ");
INSERT INTO nyy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Masyʉ maki aga mukʉjobesania bo mukwenda?” Balɨnkwɨma, kʉno baasulumeenie. ");
INSERT INTO nyy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jʉmo ʉjʉ ɨngamu jaake aalɨ jo Kilyopa, alɨnkwamula alɨnkʉtɨ, “Bʉle, ʉgwe gwimwene ʉlɨ nheesya mu Jelusalemu, gwe ʉkamanya ɨsi siboniike ʉmo amasikʉ aga?” ");
INSERT INTO nyy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Ɨsya fiki?” Balɨnkʉmmbʉʉla balɨnkʉtɨ, “Ɨsya Jesu ʉgwa mu Nasaleti. Ʉmwene aalɨ nkunguluka, ɨsi aajobaga nʉ kʉbomba syalɨ na maka nkyeni mwa Kyala na mmbandʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Abapuuti abalongosi na balongosi bɨɨtʉ baalɨntwele kʉ ndongosi gwa Balooma, ʉkʉtɨ alongigwe ʉkʉgogigwa, balɨnkʉnkomelela pa kɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ʉswe twasʉʉbɨlaga ʉkʉtɨ ʉmwene alɨ jo gwa kʉtwabʉla twe Banyaisilaɨli. Palɨ syosa sisiisi, lɨɨlɨno isikʉ lya bʉtatʉ ʉkʉfuma apa syabonekiile. ");
INSERT INTO nyy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Kangɨ abakiikʉlʉ bamo nkɨbugutɨla kyɨtʉ ɨkya bafundigwa, batʉnyomwisye. Balaabiile nʉlʉbʉnjʉ fiijo ʉkʉbʉʉka kwi ipʉmba, ");
INSERT INTO nyy_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","leelo bakagwaga ʉmfimba gwake. Biisile kʉkʉtʉbʉʉla ʉkʉtɨ babasetʉkiile abandʉmi, bababʉʉlile ʉkʉtɨ Jesu mʉʉmi. ");
INSERT INTO nyy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Po bamo nkɨbugutɨla kyɨtʉ babʉʉkile kwi ipʉmba, baagile silɨ bo muno bajobiile abakiikʉlʉ bala, looli ʉmwene bakammbona.” ");
INSERT INTO nyy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mwe bakonyofu ʉmwe! Mulɨ basito ʉkʉsiitɨka syosa ɨsi baajobile abakunguluka! ");
INSERT INTO nyy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bʉle, akaalondigwaga Meesija mpaka akʉbɨlwe bo ʉlo, po ingɨle mbʉsisya bwake?” ");
INSERT INTO nyy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Po Jesu alɨnkwanda ʉkʉbalɨngaania ɨsi sisimbiigwe mwa Kalata ʉMwikemo, ɨsi sikʉnnjoba ʉmwene, ʉkwandɨla ɨsi aasimbile Moose na bakunguluka boosa. ");
INSERT INTO nyy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bo balɨ kɨfuki ʉkʉfika nkaaja aka baabʉʉkaga, Jesu alɨnkʉfwana ikʉkɨɨsania. ");
INSERT INTO nyy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Looli abeene balɨnkʉpyelesya fiijo balɨnkʉtɨ, “Ʉsyale apa pamopeene na nuuswe. Keeta bwilile, ɨngiisi jɨlɨ kɨfuki.” Po Jesu alɨnkwingɨla nnyumba, alɨnkʉtʉʉgala nabo. ");
INSERT INTO nyy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bo atʉʉgeele pakʉlya ɨfindʉ pamopeene nabo, alɨnkwega ɨkɨsyesye, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉkɨmenyania, alɨnkʉbapa. ");
INSERT INTO nyy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Po Kyala alɨnkʉbiigʉla, balɨnkʉmmwagania ʉkʉtɨ jo Jesu, po ʉmwene alɨnkʉsoba nkyeni mmyabo. ");
INSERT INTO nyy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Balɨnkʉlaalʉʉsania balɨnkʉtɨ, “Bʉle, gʉkaafwanaga mooto gukwaka mu ndumbula syɨtʉ, bo ikʉjoba na nuuswe mu njɨla nʉ kʉtʉlɨngaania amasyʉ agaa Kalata ʉMwikemo?” ");
INSERT INTO nyy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Akabalɨlo kalakala balɨnkʉsookapo, balɨnkʉgomokelako kʉ Jelusalemu. Balɨnkʉbaaga abatʉmigwa bala kalongo na jʉmo, na bafundigwa abangɨ aba baalɨ pamopeene nabo, babʉngeene. ");
INSERT INTO nyy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Boosa baajobaga baatɨgɨ, “Nalooli ʉNtwa asyʉkile! Ammbonekiile Simoni!” ");
INSERT INTO nyy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Po boope abafundigwa babɨlɨ bala, balɨnkʉbapangɨla syosa ɨsi sibabonekiile mu njɨla, na muno bammanyiile Jesu bo ikʉmenyania ɨkɨsyesye. ");
INSERT INTO nyy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bo balɨ pakʉbapangɨla ɨnongwa ɨsyo, ʉmwene Jesu alɨnkwɨma pakatɨ pamyabo, alɨnkʉbaponia alɨnkʉtɨ, “Mugonile, ʉlʉtengaano lʉjege na nuumwe!” ");
INSERT INTO nyy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Balɨnkʉnyomoka nʉ kʉtiila, balɨnkwinogona ʉkʉtɨ bikʉmmbona ʉnsyʉka. ");
INSERT INTO nyy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Looli Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Fiki mukʉtiila? Fiki mukwilaamwa mu ndumbula syɨnu? ");
INSERT INTO nyy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Amukeete amaboko na malʉndɨ gangʉ, jo ʉne. Namumbalamaasye, mukeete, paapo ʉnsyʉka akaja nʉ mbɨlɨ nɨ fifupa, bo ʉlʉ mukʉʉmbona ʉne ndɨ nafyo.” ");
INSERT INTO nyy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jesu bo ajobile ɨsyo, alɨnkʉbanangɨsya amakoko agaa mmaboko na mmalʉndɨ gaake. ");
INSERT INTO nyy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kʉnongwa jaa lʉsekelo nʉ kʉswiga ɨsi siboniike, baatoliigwe ʉkwitɨka ɨsi. Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mulɨ nɨ findʉ fimo apa?” ");
INSERT INTO nyy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Balɨnkʉmpapo ɨkɨbalali ɨkya ɨswɨ ɨnyookye, ");
INSERT INTO nyy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","alɨnkwambɨlɨla nʉ kʉlya nkyeni mmyabo. ");
INSERT INTO nyy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Po alɨnkʉbabʉʉla alɨnkʉtɨ, “Ɨsi syo ɨsi naababʉʉlile, bo ngaalɨ ndɨ na nuumwe, ʉkʉtɨ syosa ɨsi sisimbiigwe ʉkʉʉnjoba ʉne, mu ndagɨlo sya Moose, mwa baakalata baa bakunguluka na mwa kalata gwa Ɨsabʉli, mpaka siboneke.” ");
INSERT INTO nyy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Po alɨnkwigʉla amahala gaabo, ʉkʉtɨ basyaganiege ɨsi sisimbiigwe mwa Kalata ʉMwikemo. ");
INSERT INTO nyy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Ɨsyo syo ɨsi sisimbiigwe, ʉkʉtɨ Meesija ikwisa kʉkʉbɨlwa, pi isikʉ lya bʉtatʉ, ikwisa kʉsyʉka ʉkʉfuma mbafwe. ");
INSERT INTO nyy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kangɨ mu ngamu jaake abandʉ baa mfikolo fyosa, ʉkwandɨla mu Jelusalemu, bikwisa kʉlʉmbɨlɨligwa ʉkʉtɨ basʉʉme ʉlʉhobokelo lwa bʉtʉlanongwa bwabo. ");
INSERT INTO nyy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ʉmwe mulɨ bakeeti baa nongwa ɨsi sibombiigwe. ");
INSERT INTO nyy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Pɨlɨkɨsya! Ngʉntʉma kʉmyɨnu ʉjʉ Taata aafingile ʉkʉtɨ ikʉbatʉmɨla ʉmwe. Looli mutʉʉgale nkaaja aka, mpaka bo mwambɨliile amaka aga gikʉfuma kwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Po Jesu alɨnkʉbalongosya ʉkʉsookamo mu Jelusalemu, alɨnkʉfika nabo kʉ Betanija, alɨnkwinʉla amaboko gaake, alɨnkʉbasaja. ");
INSERT INTO nyy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bo ikʉbasaja, alɨnkʉbaleka, alɨnkwegigwa ʉkʉfyʉka kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Abeene balɨnkʉmmwipuuta, po balɨnkʉsookapo pala, balɨnkʉbʉʉka mu Jelusalemu nʉ lʉsekelo ʉlʉnywamu. ");
INSERT INTO nyy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bwila baajaga ndʉpaso lwa tempeli, nkʉntuufya Kyala.");
INSERT INTO nyy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kʉbwandɨlo bwa syosa aaliko Isyʉ. Isyʉ ʉjo aalɨ pamopeene na Kyala. Kangɨ Isyʉ aalɨ jo Kyala. ");
INSERT INTO nyy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kʉbwandɨlo bwa syosa, Isyʉ ʉjo aaliko kɨlɨngaani pamopeene na Kyala. ");
INSERT INTO nyy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kyala aafipelile fyosa ʉkwendela mmyake. Akaakapelile akandʉ nakamo kɨsita kwendela mmyake. ");
INSERT INTO nyy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ʉmwene jo bwandɨlo bwa bʉʉmi boosa. Po ʉbʉʉmi ʉbo bukʉtwala ʉlʉmuli kʉ bandʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ʉlʉmuli ʉlo lukʉmulɨka mu ngiisi, looli ɨngiisi jɨtoliigwe ʉkʉlʉtola. ");
INSERT INTO nyy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kyala aalɨntʉmile ʉmundʉ jʉmo ʉjʉ ɨngamu jaake aalɨ jo Johani. ");
INSERT INTO nyy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Johani aaliisile ʉkʉja nkeeti gwa kʉfumusya ʉlʉmuli ʉlo, ʉkʉtɨ abandʉ boosa balwitɨke. ");
INSERT INTO nyy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Johani akaalɨ lʉmuli ʉlo, looli aaliisile kʉkʉfumusya ɨsya lʉmuli ʉlo. ");
INSERT INTO nyy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ʉlʉmuli ʉlo lwalɨ lʉmuli lwa nalooli, ʉlʉ lukʉbamulɨkɨla boosa. Kangɨ ʉlʉmuli ʉlo lwaliisile pakiisʉ apa. ");
INSERT INTO nyy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Isyʉ aalipo pakiisʉ apa. Abandʉ boosa abaa pakiisʉ bakaalɨmmeenye, na paapo aalɨ jo ʉjʉ Kyala aapelile ɨkiisʉ kyosa ʉkwendela mmyake. ");
INSERT INTO nyy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aaliisile kʉ bandʉ baake, leelo abandʉ baake bakaalɨmmwambɨliile. ");
INSERT INTO nyy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Looli aba baalɨmmwambɨliile nʉ kʉmmwitɨka, aabapelile ʉkʉja baana baa Kyala. ");
INSERT INTO nyy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Abeene bo baana baa Kyala, looli somma kʉnongwa jaa kɨkolo kyabo, kangɨ somma kʉnongwa jaa kʉpaapigwa nʉ nnyambala nʉ nkiikʉlʉ, looli Kyala jo ʉjʉ ikʉbapela ʉkʉja baanaake jʉʉjo. ");
INSERT INTO nyy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Isyʉ ʉjo aaliisile alɨnkʉja mundʉ, aaliisile kʉtʉʉgala kʉmyɨtʉ. Ʉswe twabʉbwene ʉbʉsisya bwake, ʉbʉsisya ʉbwa ʉjʉ alɨ jʉmojwene ntɨga, ʉkʉfuma kwa Taata Kyala, kangɨ ʉjʉ alɨ ni ipyana nʉ bwanalooli kʉ bwingi. ");
INSERT INTO nyy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johani alɨnkʉbabʉʉla abandʉ ɨnongwa ɨsya mundʉ ʉjo, alɨnkʉjoba pabwelu alɨnkʉtɨ, “Ʉjʉ jo ʉjʉ naababʉʉlaga naatɨgɨ, ‘Ikwisa ʉmundʉ jʉmo kʉnyuma kʉmyangʉ, ʉjʉ jo nkʉlʉmba ʉkʉngɨnda ʉne, paapo aaliko bo ʉne ngaalɨ ʉkʉpaapigwa.’ ” ");
INSERT INTO nyy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ʉkʉkongana nʉ kʉsita kwagɨlwa kwake, Kyala atʉpeele twesa iipyana, ongiilepo pi ipyana ɨlɨ lyatalilepo. ");
INSERT INTO nyy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kokʉtɨ ijolo Kyala aatʉpeele ɨndagɨlo syake kʉ njɨla jaa Moose, looli akabalɨlo aka atʉpeele iipyana lyake nʉ bwanalooli bwake kʉ njɨla jaa Meesija Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Akajako ʉmundʉ ʉjʉ ammbwenemo Kyala. Looli ʉjo, ʉjʉ alɨ jʉmojwene ntɨga, ʉjʉ joope jo Kyala, kangɨ alɨ pamopeene na Taata Kyala, jo ʉjʉ atʉsetʉliile Kyala. ");
INSERT INTO nyy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Iisikʉ lɨmo abalongosi baa Bajuuta baabatʉmile abapuuti na Banyaleebi ʉkʉfuma mu Jelusalemu, kʉkʉnndaalʉʉsya Johani, ʉkʉtɨ jo jwani. Ʉmwene aasisimɨkiisye, ");
INSERT INTO nyy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","aabaamwile kɨsita kʉfinda ʉbwanalooli, aatile, “Ʉne ngaja ne Meesija.” ");
INSERT INTO nyy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Balɨnkʉnndaalʉʉsya kangɨ balɨnkʉtɨ, “Po ʉgwe gwe gwani? Bʉle, ʉgwe gwe nkunguluka Elija?” Johani alɨnkʉbaamula alɨnkʉtɨ, “Mma, ngaja ne Elija.” Abeene balɨnkʉnndaalʉʉsya kangɨ balɨnkʉtɨ, “Bʉle, ʉgwe gwe nkunguluka ʉjʉngɨ, ʉjʉ tukʉnnguulɨla ʉkʉfuma kwa Kyala?” Johani alɨnkʉbaamula alɨnkʉtɨ, “Mma, ngaja jo ʉne.” ");
INSERT INTO nyy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Balɨnkʉnndaalʉʉsya kangɨ balɨnkʉtɨ, “Po ʉgwe gwe gwani? Ʉkʉtɨ tʉkababʉʉle aba batʉtʉmile. Ʉgwe kwijoba ʉkʉtɨ gwe gwani?” ");
INSERT INTO nyy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Johani alɨnkʉbaamula ʉkʉkongana na masyʉ aga aajobile ʉnkunguluka Jeesaja, ʉkʉtɨ, “Ʉne ndɨ isyʉ lya mundʉ, likʉkoolela ndʉngalangala likʉtɨ, ‘Mutendekesye ʉnsebo ʉgwa kwendamo ʉNtwa!’ ” ");
INSERT INTO nyy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Po abandʉ bala, aba aBafalisai baabatʉmile kwa Johani, ");
INSERT INTO nyy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Lɨnga ʉgwe ʉkaja gwe Meesija, pamo ʉkaja gwe nkunguluka Elija, pamo ʉkaja gwe nkunguluka ʉjʉngɨ ʉgwa Kyala, keeta koosya?” ");
INSERT INTO nyy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johani alɨnkʉbaamula alɨnkʉtɨ, “Ʉne ngʉboosya na mɨɨsi, looli pakatɨ pamyɨnu alipo ʉjʉ ʉmwe mukammanya. ");
INSERT INTO nyy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ʉjo jo ʉjʉ ikwisa kʉnyuma kʉmyangʉ, kangɨ jo ʉjʉ ngabagɨsya nʉ kwabʉla ʉtʉkoba ʉtwa filato fyake.” ");
INSERT INTO nyy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Syosa ɨsyo syabombiigwe nkaaja akaa mu Betanija, kʉkɨbafu ɨkya kʉbʉsookelo ɨkya lwɨsi Jolitani, kʉno Johani oosyaga abandʉ. ");
INSERT INTO nyy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kɨlaabo kyake, Johani alɨnkʉmmbona Jesu ikwisa kʉmyake. Alɨnkʉbabʉʉla abandʉ aba baalipo pala alɨnkʉtɨ, “Keeta, ʉjo jo Kangʼoosi kaa Kyala, ʉjʉ ikʉbʉsoosyamo ʉbʉtʉlanongwa bwa bandʉ boosa! ");
INSERT INTO nyy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ʉjʉ jo ʉjʉ naababʉʉlaga ʉkʉtɨ, ‘Ikwisa ʉmundʉ jʉmo kʉnyuma kʉmyangʉ, ʉjʉ nkʉlʉmba ʉkʉngɨnda ʉne, paapo aaliko bo ʉne ngaalɨ ʉkʉpaapigwa.’ ");
INSERT INTO nyy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na niine ngaalɨmmeenye ʉkʉtɨ jo jwani, looli naaliisile kʉkʉboosya abandʉ na mɨɨsi ʉkʉtɨ, nʉnsetʉle kʉ Banyaisilaɨli.” ");
INSERT INTO nyy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Po Johani alɨnkʉbabʉʉla ɨsi asibwene, alɨnkʉtɨ, “Nʉmmbwene Mbepo Mwikemo ʉkʉfuma kʉmwanya, bo ikʉsuluka pamwanya pamyake nʉ mbɨlɨ bo ʉgwa ngʉnde, asyele pamopeene nagwe. ");
INSERT INTO nyy_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Leelo ngaalɨmmeenye ʉkʉtɨ jo jwani, looli Kyala ʉjʉ aalɨndʉmile kʉkoosya aatile, ‘Lɨnga gʉmmbwene ʉmundʉ ʉjʉ Mbepo gwangʉ ikʉsuluka pamwanya pamyake, nʉ kʉsyala nagwe, ʉjo jo ʉjʉ ikʉboosyaga abandʉ na Mbepo Mwikemo.’ ” ");
INSERT INTO nyy_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Po Johani alɨnkʉtɨ, “Na niine nsibwene, kangɨ ngʉsisimɨkɨsya, ʉkʉtɨ ʉjo Mwana gwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kɨlaabo kyake, Johani aalipo pala kangɨ pamopeene na bafundigwa baake babɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Po alɨnkʉmmbona Jesu ikwenda kɨfuki nabo. Alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Keeta, ʉjo jo Kangʼoosi kaa Kyala!” ");
INSERT INTO nyy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Abafundigwa baa Johani bo bapɨliike ɨsyo, balɨnkʉnkonga Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Po Jesu alɨnkʉsanuka, alɨnkʉbabona abafundigwa bala bikʉnkonga. Alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Bʉle, mukʉlonda ɨfiki?” Abeene balɨnkʉmmwamula balɨnkʉtɨ, “Gwe Labi (ɨngamu ɨjɨ kokʉtɨ Mmanyisi), kalɨ, kʉtʉʉgala kʉʉgʉ?” ");
INSERT INTO nyy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesu alɨnkʉtɨ, “Isaga, mukwakʉpabona.” Po balɨnkʉnkonga. Ɨsala jaa 10:00 pamuusi, balɨnkʉfika apa aatʉʉgalaga, balɨnkʉlɨnda nagwe iisikʉ lɨla. ");
INSERT INTO nyy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ʉmfundigwa jʉmo mbafundigwa babɨlɨ aba baapɨliike amasyʉ gaa Johani, na aba baalɨnkongile Jesu, ɨngamu jaake aalɨ jo Andeleja, ʉgwamyabo gwa Simoni Peeteli. ");
INSERT INTO nyy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nakalɨnga ʉjo alɨnkʉbʉʉka kʉkʉnndonda Simoni. Bo ammwagile, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Tʉmmwagile ʉMpoki, ʉjʉ jo Meesija!” (Ɨngamu ɨjɨ kokʉtɨ Kɨlɨsiti.) ");
INSERT INTO nyy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Po Andeleja alɨnkʉntwala Simoni kwa Jesu. Jesu alɨnkʉnkeeta Simoni, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉgwe gwe Simoni ʉmwana gwa Johani. Ʉkwandɨla lɨɨlɨno, ɨngamu jaako kʉjaga gwe Kefa” (pamo Peeteli, kokʉtɨ Lwalabwe). ");
INSERT INTO nyy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kɨlaabo kyake, Jesu alɨnkʉtumula ʉkʉbʉʉka nkiisʉ ɨkya Galilai. Po alɨnkʉmmwaga Filipo, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Filipo, isaga ʉngongege.” ");
INSERT INTO nyy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo aafumile mu Betisaita, muno Andeleja na Peeteli boope baatʉʉgalaga. ");
INSERT INTO nyy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Po Filipo alɨnkʉmmwaga Natanaeli, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Tʉmmbwene ʉmundʉ ʉjʉ Moose aasimbile ɨnongwa syake mwa Kalata gwa Ndagɨlo, kangɨ ʉjʉ boope abakunguluka baasimbile ɨnongwa syake. Ɨngamu jaake jo Jesu ʉgwa mu Nasaleti, mwana gwa Joosefu.” ");
INSERT INTO nyy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Looli Natanaeli alɨnkʉnndaalʉʉsya Filipo alɨnkʉtɨ, “Kandʉ nki akanunu aka kabagiile ʉkʉfuma nkaaja akanandɨ akaa mu Nasaleti?” Filipo alɨnkʉmmwamula alɨnkʉtɨ, “Isaga gwikeetele.” ");
INSERT INTO nyy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesu bo ammbwene Natanaeli ikwisa kʉmyake, alɨnkʉtɨ, “Keeta, ʉmundʉ ʉjo Mwisilaɨli gwa nalooli, ʉjʉ akaja nsyobi.” ");
INSERT INTO nyy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaeli alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Gwe ntwa, gʉʉmeenye bʉleebʉle?” Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Na bo Filipo akaalɨ ʉkwisa kʉkʉkoolela, ʉne bo ngʉbwene ʉtʉʉgeele pa nkʉjʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Po Natanaeli alɨnkwamula alɨnkʉtɨ, “Gwe Mmanyisi, lɨɨlɨno mmeenye ʉkʉtɨ ʉgwe ʉlɨ Mwana gwa Kyala! Ʉgwe ʉlɨ Malafyale gwa kiisʉ kya Isilaɨli!” ");
INSERT INTO nyy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesu alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Bʉle, kwitɨka paapo ngʉbʉʉlile ʉkʉtɨ ngʉbwene bo ʉtʉʉgeele pa nkʉjʉ? Kʉsibona ɨsingi ɨngʉlʉmba ʉkʉsikɨnda ɨsi! ");
INSERT INTO nyy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nalooli nikʉbabʉʉla, mukwisa kʉkʉbona kʉmwanya kʉkwigʉka, nʉ kʉbabona abandʉmi baa Kyala bikʉfyʉka nʉ kʉsuluka pamwanya pamyangʉ ne Nnyamundʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bo ajobile ɨsyo, pi isikʉ lya bʉtatʉ, lwalipo ʉlʉsekelo ʉlwa bwegi mu Kana, nkiisʉ ɨkya Galilai. Pa bwegi ʉbo aalipo joope ʉnna gwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu na bafundigwa baake boope baalipo pa bwegi ʉbo, baapaaliigwe. ");
INSERT INTO nyy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Akabalɨlo bo kakɨndilepo, abaheesya baanwile ɨfinga joosa. Po ʉnna gwa Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwe mwanangʉ, abaheesya bamalile ɨfinga.” ");
INSERT INTO nyy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesu alɨnkʉmmwamula ʉnna alɨnkʉtɨ, “Jʉʉba, fiki kʉjoba bo ʉlo? Akabalɨlo kaa kʉbomba ɨmbombo jangʉ kakaalɨ ʉkʉfika.” ");
INSERT INTO nyy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Po ʉnna alɨnkʉbabʉʉla ababombi alɨnkʉtɨ, “Syosa ɨsi ikʉbabʉʉla ʉmwanangʉ, mubombege.” ");
INSERT INTO nyy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pabʉjo bʉla, syalipo ɨngumbe ntandatʉ ɨsya mabwe. ABajuuta baabɨɨkangamo amɨɨsi agaa kʉbombela ʉlwiho lwabo, ʉlwa kwijeelʉsya. Ɨngumbe jɨmo jiisʉlaga amalebe mahaano pamo ntandatʉ. ");
INSERT INTO nyy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Po Jesu alɨnkʉbabʉʉla ababombi bala alɨnkʉtɨ, “Namwisʉsye amɨɨsi mu ngumbe ɨsyo.” Po balɨnkʉnega amɨɨsi nʉ kwisʉsya mu ngumbe sila. ");
INSERT INTO nyy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Namunege amɨɨsi gamo, mukampepo ʉnkʉlʉmba gwa lʉsekelo.” Po balɨnkʉnega amɨɨsi nʉ kwakʉmpapo ʉnkʉlʉmba jʉla. ");
INSERT INTO nyy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ʉnkʉlʉmba alɨnkʉnwa amɨɨsi gala, aga Jesu aagasanwisye ʉkʉja finga. Ʉmwene akaameenye kʉno jɨfumile, looli ababombi aba baanegile amɨɨsi baameenye kʉno jɨfumile. Po alɨnkʉnkoolela ʉmwega nkiikʉlʉ. ");
INSERT INTO nyy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Bo iisile, ʉnkʉlʉmba jʉla alɨnkʉtɨ, “Ʉmundʉ gwesa kʉbwandɨlo ikʉjaba ɨfinga ɨnunu, looli abandʉ bo banwile nʉ kwikʉta, po ikwisa nɨ finga ɨjɨ jɨkaja nunu. Looli ʉgwe ʉtwele ɨfinga ɨnunu kʉmmalɨɨkɨsyo!” ");
INSERT INTO nyy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesu aabombile ɨkiika ɨkɨ nkaaja akaa mu Kana mu Galilai. Ɨkiika ɨkyo kyalɨ kya kwanda ʉkʉbomba, ʉkʉnangɨsya ʉbʉsisya bwake kʉ bandʉ. Kʉnongwa ɨjo abafundigwa baake balɨnkʉmmwitɨka. ");
INSERT INTO nyy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ʉlʉsekelo lwa bwegi bo lʉmaliike, Jesu alɨnkʉsuluka mu Kapelinaʉmu pamopeene nʉ nna, abanuguna na bafundigwa baake. Balɨnkʉtʉʉgala ʉko amasikʉ manandɨ. ");
INSERT INTO nyy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Akabalɨlo akaa kyaka kya Bajuuta, ɨkɨ bikʉtɨ Pasa, bo kɨlɨ kɨfuki, Jesu alɨnkʉfyʉka ʉkʉbʉʉka mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Po alɨnkwingɨla ndʉpaso lwa tempeli. Ʉmo alɨnkʉbaaga aba bʉʉlɨsyaga ɨngʼombe, ɨngʼoosi nɨ ngʉnde, na aba bʉʉsaniaga ɨndalama. ");
INSERT INTO nyy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesu bo asibwene ɨsyo, alɨnkʉpota ʉtʉgoje ʉkʉja kɨngoti, alɨnkʉbakaga boosa aba bʉʉlɨsyaga ndʉpaso lwa tempeli, pamopeene nɨ ngʼombe nɨ ngʼoosi. Alɨnkʉsipetusya ɨmeesa sya bʉʉsania ndalama nʉ koona ɨndalama syabo. ");
INSERT INTO nyy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Po Jesu alɨnkʉbabʉʉla aba bʉʉlɨsyaga ɨngʉnde alɨnkʉtɨ, “Namusisoosyepo ɨngʉnde apa. Mulɨngajɨbɨɨkaga ɨnyumba jaa Taata ʉkʉja sokoni.” ");
INSERT INTO nyy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Abafundigwa baake bo bapɨliike ɨsyo, balɨnkʉkʉmbʉka amasyʉ aga gasimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, “Ʉlʉgano lwangʉ kʉ nyumba jaako, lukwaka nkatɨ mmyangʉ bo ʉlwa mooto.” ");
INSERT INTO nyy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Po abalongosi baa Bajuuta bo basibwene ɨsi Jesu abombile, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Kʉbomba ɨkɨmanyilo kɨlɨkʉ, ʉkʉnangɨsya ʉkʉtɨ ʉlɨ nʉ bʉlagɨli ʉbwa kʉbomba ɨsi?” ");
INSERT INTO nyy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Namoomole ɨtempeli ɨjɨ, ʉne ngʉjɨjenga kʉ masikʉ matatʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Po abeene balɨnkʉmmwamula balɨnkʉtɨ, “Ɨtempeli ɨjɨ jaajengiigwe kʉ fyɨnja 46. Po ʉgwe ʉbagiile bʉleebʉle ʉkʉjɨjenga kʉ masikʉ matatʉ?” ");
INSERT INTO nyy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Looli Jesu akaajobaga ɨsya tempeli, aajobaga ɨsya mbɨlɨ gwake ʉmwene, ʉgʉ gwajaga pakʉbomoligwa. ");
INSERT INTO nyy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Po Jesu bo asyʉkile ʉkʉfuma mbʉfwe, abafundigwa baake balɨnkʉkʉmbʉka amasyʉ aga aajobile. Kʉ njɨla ɨjo, balɨnkwitɨka amasyʉ aga gasimbiigwe mwa Kalata ʉMwikemo, na masyʉ aga Jesu aajobile. ");
INSERT INTO nyy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesu bo alɨ pa kyaka kya Pasa mu Jelusalemu, abandʉ bingi balɨnkwanda ʉkʉmmwitɨka, paapo baafibwene ɨfiika ɨfi aabombaga. ");
INSERT INTO nyy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Looli Jesu akaabiitiike, paapo aasyageenie ɨsi silimo mu ndumbula syabo. ");
INSERT INTO nyy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kangɨ akaalondaga ʉmundʉ gwesa jʉla, ʉkʉmmbʉʉla ɨsi abandʉ bikwinogona, paapo aasimeenye syosa ɨsi silimo mu ndumbula sya bandʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Aaliko ʉndongosi jʉmo ʉgwa Bajuuta, ʉgwa nkɨbugutɨla kya Bafalisai, ɨngamu jaake aalɨ jo Nikotemu. ");
INSERT INTO nyy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ɨliisikʉ lɨmo pakɨlo, alɨnkʉbʉʉka kwa Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwe Mmanyisi, tʉmeenye ʉkʉtɨ ʉgwe ʉlɨ mmanyisi ʉjʉ atʉmiigwe na Kyala, paapo akajako ʉmundʉ ʉjʉ abagiile ʉkʉbomba ɨfiika ɨfi kʉbomba, lɨnga Kyala akaja pamopeene nagwe.” ");
INSERT INTO nyy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Nalooli nikʉkʉbʉʉla, akajako ʉmundʉ ʉjʉ abagiile ʉkwingɨla mBʉnyafyale bwa Kyala, lɨnga akapaapigwa ʉlwa bʉbɨlɨ.” ");
INSERT INTO nyy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikotemu alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Bʉle, ʉnkangale abagiile bʉleebʉle ʉkʉpaapigwa ʉlwa bʉbɨlɨ? Bʉle, abagiile ʉkwingɨla kangɨ ndwanda lwa nna ʉkʉtɨ apaapigwe?” ");
INSERT INTO nyy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Nalooli nikʉkʉbʉʉla, akajako ʉmundʉ ʉjʉ abagiile ʉkwingɨla mBʉnyafyale bwa Kyala, lɨnga akapaapigwa kʉ mɨɨsi na kwa Mbepo gwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Abapaapi bikʉbapaapa abaanaabo nʉ mbɨlɨ, looli Mbepo gwa Kyala jo ʉjʉ ikʉbapaapa abandʉ ʉkʉtɨ bajege nʉ bʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ʉlɨngaswigaga ɨsi ngʉbʉʉlile ʉkʉtɨ, ‘Fikʉtɨ ʉpaapigwe ʉlwa bʉbɨlɨ.’ ");
INSERT INTO nyy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ʉmbelo gukʉkula ʉkʉlabɨla kʉno gwiganile. Ʉbagiile ʉkʉpɨlɨka ʉkʉkula kwake, looli ʉtikʉmanya kʉno gukʉfuma na kʉno gukʉlabɨla. Ɨsi bo silɨ na kʉ mundʉ gwesa ʉjʉ apaapiigwe na Mbepo gwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikotemu alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Bʉle, ʉmundʉ abagiile bʉleebʉle ʉkʉpaapigwa na Mbepo gwa Kyala?” ");
INSERT INTO nyy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉgwe ʉlɨ mmanyisi ʉmwɨmɨkigwa ʉgwa bandʉ abaa nkiisʉ ɨkya Isilaɨli. Bʉle, ʉkasimanya syosa ɨsi? ");
INSERT INTO nyy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nalooli nikʉkʉbʉʉla, ʉswe tʉsimeenye ɨsi tukʉsijoba, kangɨ tʉsibwene ɨsi tukʉsilɨngaania. Looli ʉmwe mutikwitɨka ɨsyo. ");
INSERT INTO nyy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mbabʉʉlile ɨsi sikʉbombigwa pakiisʉ apa, looli ʉmwe mutikwitɨka. Po mubagiile bʉleebʉle ʉkʉʉnyiitɨka, lɨnga ngʉbabʉʉla ɨsi sikʉbombigwa kʉmwanya? ");
INSERT INTO nyy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Akajako ʉmundʉ najʉmo ʉjʉ abʉʉkileko kʉmwanya. Looli ne Nnyamundʉ jo ʉne naaliisile ʉkʉfuma kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Moose aatendekiisye ɨkɨfwani kya njoka jaa kɨbʉngʉ nʉ kʉkɨfyʉsya pa kɨpiki, ʉkʉtɨ abapoke aBanyaisilaɨli bo balɨ ndʉngalangala. Bʉbʉʉbo ne Nnyamundʉ ngwisa kʉfyʉsigwa, ");
INSERT INTO nyy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ʉkʉtɨ mbape ʉbʉʉmi bwa bwila na bwila abandʉ aba bikʉʉnyiitɨka.” ");
INSERT INTO nyy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kyala abaganile fiijo abandʉ boosa abaa pakiisʉ apa. Jo nongwa ɨjɨ aalɨntʉmile ʉMwanaake jʉmojwene ntɨga, ʉkwisa pakiisʉ apa, ʉkʉtɨ ʉmundʉ gwesa ʉjʉ ikʉmmwitɨka alɨngasobaga, looli akabe ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kyala akaalɨntʉmile ʉMwanaake pakiisʉ kʉkʉbalonga abandʉ, looli kʉkʉbapoka. ");
INSERT INTO nyy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kyala atikʉnndonga ʉmundʉ ʉjʉ ikʉmmwitɨka ʉMwanaake, looli ʉmundʉ ʉjʉ atikʉmmwitɨka alongiigwe, paapo akammwitɨka ʉMwanaake jʉmojwene ntɨga. ");
INSERT INTO nyy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ʉbʉlongi bo ʉbʉ, ʉlʉmuli lwisile pakiisʉ apa, looli abandʉ bingi biiganile ʉkʉja mu ngiisi ʉkʉkɨndapo ʉkʉja ndʉmuli, paapo ɨmbombo syabo mbiibi. ");
INSERT INTO nyy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Abandʉ boosa aba bikʉbomba ɨsi sikaja nunu, balʉbengile ʉlʉmuli ʉlo. Kangɨ bomma ʉkʉbʉʉka ndʉmuli, ʉkʉtɨ ɨmbiibi syabo silɨngiisa kʉboneka pabwelu. ");
INSERT INTO nyy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Looli abandʉ boosa aba bikʉlonda fiijo ɨsya bwanalooli bikʉbʉʉka ndʉmuli ʉlo, ʉkʉtɨ ɨmbombo syabo sije pabwelu, simanyigwege ʉkʉtɨ jo Kyala ʉjʉ ikʉbapa amaka agaa kʉsibomba. ");
INSERT INTO nyy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Akabalɨlo bo kakɨndilepo panandɨ, Jesu na bafundigwa baake balɨnkʉbʉʉka nkiisʉ ɨkya Jutai. Balɨnkʉtʉʉgala mula kʉkabalɨlo kamo, paapo oosyaga abandʉ. ");
INSERT INTO nyy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nkabalɨlo kalakala, joope Johani oosyaga abandʉ mu Ainoni, kɨfuki na nkaaja akaa mu Salimu, paapo gaaliko amɨɨsi mingi. Abandʉ bingi balɨnkʉbʉʉka kʉmyake ʉkʉtɨ aboosye. ");
INSERT INTO nyy_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Johani aabombaga ɨmbombo ɨjo, bo Heloti akaalɨ ʉkʉnkola nʉ kʉmmbɨɨka mu nnyololo. ");
INSERT INTO nyy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ɨliisikʉ lɨmo abafundigwa bamo abaa Johani, balɨnkwanda ʉkʉkaanikana nʉ Njuuta jʉmo, ɨsya lwiho ʉlwa kwijeelʉsya bo kʉja pakwipuuta. ");
INSERT INTO nyy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Po balɨnkʉbʉʉka kwa Johani, balɨnkʉmmbʉʉla balɨnkʉtɨ, “Gwe Mmanyisi, ʉmundʉ ʉjʉ gwalɨ nagwe kwi isɨɨlya ɨlɨngɨ ɨlya lwɨsi Jolitani, ʉjʉ gwatʉbʉʉlile ɨnongwa syake, joope ikoosya abandʉ. Kangɨ bingi bikʉbʉʉka kʉmyake ʉkʉkɨndapo kʉmyako.” ");
INSERT INTO nyy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johani alɨnkʉbaamula alɨnkʉtɨ, “Ʉmundʉ akabagɨla ʉkʉkaaga akandʉ nakamo, lɨnga Kyala akampa. ");
INSERT INTO nyy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ʉmwe mulɨ bakeeti bangʉ, kʉlɨ ɨsi ngʉsijoba ʉkʉtɨ, ‘Ʉne ngaja ne Meesija, looli Kyala aalɨndʉmile ʉne ʉkʉtɨ ndalepo nkyeni mmyake.’ ");
INSERT INTO nyy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ʉndɨndwana ʉjʉ ikwegigwa ikʉlondigwa ʉkʉbʉʉka kʉ nnyambala ʉjʉ ikʉmmwega. Ʉne ndɨ bo ʉlwa mmanyaani ʉgwa mwega nkiikʉlʉ, nɨɨmile kʉmbalɨ kʉmyake ʉjʉ ikwega, ngʉsekela bo ngʉpɨlɨka iisyʉ lyake. Nalooli jo mbombo ɨjɨ jɨɨhobwisye fiijo. ");
INSERT INTO nyy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Fikʉtɨ Jesu ajege nkʉlʉmba ʉkʉkɨndapo, looli ʉne njege nnandɨ ʉkʉkɨndapo.” ");
INSERT INTO nyy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ɄMwana gwa Kyala ʉjʉ afumile kʉmwanya, alɨ nʉ bʉlagɨli ʉkʉbakɨnda abandʉ boosa. Gwesa ʉjʉ atikʉfuma kʉmwanya, ikʉjoba syene ɨnongwa ɨsya pakiisʉ apa. Kokʉtɨ ʉjʉ afumile kʉmwanya, alɨ nʉ bʉlagɨli ʉkʉbakɨnda abandʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jesu ikʉlɨngaania ɨsi asibwene nʉ kʉsipɨlɨka ʉkʉfuma kwa Kyala, looli abandʉ banandɨ itolo aba bikwitɨka ʉkʉtɨ ɨsi ikʉjoba sya nalooli. ");
INSERT INTO nyy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ʉmundʉ gwesa ʉjʉ ikwitɨka amasyʉ gaa Jesu, ikʉnangɨsya ʉkʉtɨ ɨsi Kyala ikʉjoba sya nalooli, ");
INSERT INTO nyy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","namanga Kyala aalɨntʉmile Jesu ʉkʉjoba amasyʉ gaa Kyala. Kyala aalɨmpeele Mbepo Mwikemo kɨsita kɨpɨmo. ");
INSERT INTO nyy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taata Kyala annganile ʉMwanaake, kangɨ ampeele amaka agaa kʉlagɨla ʉtʉndʉ toosa. ");
INSERT INTO nyy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ʉmundʉ gwesa ʉjʉ ikʉmmwitɨka ʉMwanaake Kyala, alɨ nʉ bʉʉmi bwa bwila na bwila. Looli ʉmundʉ gwesa ʉjʉ ikʉnkaana, akaja nʉ bʉʉmi bwa bwila na bwila, paapo ɨngalalɨsi sya Kyala sikwendelelaga ʉkʉja pamyake bwila. ");
INSERT INTO nyy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Po aBafalisai balɨnkʉpɨlɨka ɨnongwa sya Jesu ʉkʉtɨ ikoosya nʉ kʉkaba abafundigwa bingi ʉkʉnkɨnda Johani. ");
INSERT INTO nyy_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ɨsya bwanalooli, Jesu akoosyaga, looli abafundigwa baake bo aba boosyaga. ");
INSERT INTO nyy_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesu bo asyageenie ʉkʉtɨ ɨnongwa ɨsyo sibalaniile, alɨnkʉsookamo nkiisʉ ɨkya Jutai pamopeene na bafundigwa baake, alɨnkʉbʉʉka nkiisʉ ɨkya Galilai. ");
INSERT INTO nyy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Bo bikʉbʉʉka mu Galilai, baalondigwaga ʉkwendela nkiisʉ ɨkya mu Samalija. ");
INSERT INTO nyy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Po balɨnkʉfika mu Samalija, nkaaja kamo aka baatɨgɨ mo mu Sikali. Akaaja ako kaalɨ kɨfuki nʉ ngʉnda ʉgʉ Jaakobo aalɨmpeele ɨkɨlɨngo ʉmwanaake, Joosefu. ");
INSERT INTO nyy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Apo kyalipo ɨkiina kɨmo ɨkya mɨɨsi ɨkɨ baakɨtɨgɨ kiina kya Jaakobo. Iisʉba bo lɨlɨ pantʉ, Jesu alɨnkʉtʉʉgala kʉmbalɨ kʉ kiina ɨkyo ʉkʉtɨ atʉʉsye, kʉnongwa jaa bʉkatale ʉbwa kwenda ɨnjɨla ɨndali. ");
INSERT INTO nyy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Po abafundigwa baake balɨnkʉbʉʉka nkaaja kʉkʉʉla ɨfindʉ, Jesu alɨnkʉsyala mwene pa kiina. Po ʉnkiikʉlʉ jʉmo ʉNsamalija alɨnkwisa kʉkʉnega amɨɨsi nkiina kɨla. Bo Jesu ammbwene, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwe nkiikʉlʉ ʉgwe, ngʉsʉʉma amɨɨsi gamo agaa kʉnwa.” ");
INSERT INTO nyy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Po ʉnkiikʉlʉ jʉla alɨnkʉmmwamula Jesu alɨnkʉtɨ, “Ʉgwe ʉlɨ Njuuta, ʉne ndɨ Nsamalija. Sya kɨswigo ʉkʉsʉʉma amɨɨsi kʉmyangʉ.” Aajobile bo ʉlo paapo aBajuuta baakaanaga ʉkʉlya pamopeene na Basamalija. ");
INSERT INTO nyy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Lɨnga gwameenye ɨfi Kyala ikʉlonda ʉkʉkʉpa nʉ kʉtɨ jo jwani ʉjʉ ikʉkʉsʉʉma amɨɨsi gamo agaa kʉnwa, gwabagiile ʉkʉʉsʉʉma ʉne, niine naabagiile ʉkʉkʉpa amɨɨsi aga gikʉbapa abandʉ ʉbʉʉmi bwa bwila na bwila.” ");
INSERT INTO nyy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ʉnkiikʉlʉ jʉla alɨnkʉmmwamula Jesu alɨnkʉtɨ, “Gwe taata, ʉgwe ʉkaja nʉ lʉgoje pamo ɨkya kʉnegela amɨɨsi, kangɨ ɨkiina ɨkɨ kɨsolofu fiijo, po kʉgaaga kʉʉgʉ amɨɨsi ago, aga gikʉbapa abandʉ ʉbʉʉmi? ");
INSERT INTO nyy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ʉmwisʉkʉlʉ gwɨtʉ Jaakobo jʉʉjo aatʉpeele ɨkiina ɨkɨ ɨkya mɨɨsi, aga aanwaga na baanaake, pamopeene nɨ finyamaana fyake ɨfya kʉtiima. Bʉle, kwibona ʉgwe ʉlɨ nkʉlʉmba fiijo ʉkʉnkɨnda ʉmwene?” ");
INSERT INTO nyy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Po Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉmundʉ gwesa ʉjʉ ikʉnwa amɨɨsi aga gikʉfuma nkiina ɨkɨ, ikʉʉmɨlwa kangɨ. ");
INSERT INTO nyy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Looli ʉmundʉ ʉjʉ ikʉnwa amɨɨsi aga ʉne ngʉmpa, atikʉʉmɨlwaga bwila na bwila. Amɨɨsi aga ngʉmpaga ʉne gikʉjaga bo ʉlwa nyiibʉko jaa mɨɨsi nkatɨ mmyake, ɨjɨ jɨtikʉʉma sikʉ, jikʉmpaga ʉbʉʉmi bwa bwila na bwila.” ");
INSERT INTO nyy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Po ʉnkiikʉlʉ jʉla alɨnkʉnsʉʉma Jesu alɨnkʉtɨ, “Gwe taata, ngʉkʉsʉʉma gʉmbepo amɨɨsi aga ʉgajobile, ʉkʉtɨ ndɨngʉʉmɨlwangamo, kangɨ ndeke ʉkwisa kʉkʉnega amɨɨsi nkiina ɨkɨ!” ");
INSERT INTO nyy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Bʉʉka ʉkankoolele ʉndʉmego, gwise nagwe apa.” ");
INSERT INTO nyy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Alɨnkwamula alɨnkʉtɨ, “Ʉne ngeegigwa.” Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉjobile ɨsya nalooli ʉkʉtɨ ʉkeegigwa! ");
INSERT INTO nyy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Namanga gwegiigwemo na banyambala bahaano mpaka ʉlʉ, joope ʉnnyambala ʉjʉ kʉtʉʉgala nagwe akabalɨlo aka, akaja ndʉmego. Ʉjobile ɨsya nalooli.” ");
INSERT INTO nyy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ʉnkiikʉlʉ jʉla alɨnkwamula alɨnkʉtɨ, “Gwe taata, lɨɨlɨno nsyageenie ʉkʉtɨ ʉgwe ʉlɨ nkunguluka. ");
INSERT INTO nyy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Abiisʉkʉlʉ bɨɨtʉ bammwipuutaga Kyala nkyamba ɨkɨ ɨkya Gelisimu, looli ʉmwe mwe Bajuuta mukʉtɨ tʉbʉʉkege kʉkʉmmwipuuta Kyala mu Jelusalemu. Bʉle, ʉbwanalooli bo bʉlɨkʉ?” ");
INSERT INTO nyy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Gwe nkiikʉlʉ ʉgwe, itɨkaga ɨsi ngʉjoba sya nalooli. Akabalɨlo aakikwisa aka aamutikʉmmwipuutaga Taata Kyala nkyamba ɨkɨ pamo mu tempeli ɨjaa mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ʉmwe mwe Basamalija mukʉmmwipuuta Kyala ʉjʉ mukammanya, looli ʉswe twe Bajuuta tukʉmmwipuuta Kyala ʉjʉ tʉmmeenye. Paapo aikʉbapoka abandʉ ʉkwendela kʉ Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Akabalɨlo kikwisa, kangɨ kafikile, aka abandʉ aba bikʉlonda ʉkʉmmwipuuta Kyala kʉ bwanalooli, aabikʉmmwipuutaga Taata bo muno Mbepo gwake abanangiisye, ʉkʉmmwipuuta ʉmwene muno ajɨɨliile nalooli. Taata Kyala ikʉbalonda abandʉ aba bikʉmmwipuuta kʉ njɨla ɨjo. ");
INSERT INTO nyy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kyala jo Mbepo. Abandʉ aba bikʉmmwipuuta, bikʉlondigwa ʉkʉtɨ bammwipuutege bo muno Mbepo gwake abanangiisye, ʉkʉmmwipuuta ʉmwene muno ajɨɨliile nalooli.” ");
INSERT INTO nyy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ʉnkiikʉlʉ jʉla alɨnkʉmmwamula alɨnkʉtɨ, “Mmeenye ʉkʉtɨ Meesija ikwisa, ʉjʉ bikʉtɨ Kɨlɨsiti. Kangɨ mmeenye ʉkʉtɨ bo iisile ikwisa kʉtʉlɨngaania syosa.” ");
INSERT INTO nyy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Po Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉne, ne ngʉjoba na nungwe, jo ʉjʉ ʉgwe kʉnnjoba.” ");
INSERT INTO nyy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Akabalɨlo ako abafundigwa baake balɨnkwisa, balɨnkʉswiga fiijo bo Jesu ikʉjoba nʉ nkiikʉlʉ. Looli najʉmo ʉmfundigwa ʉjʉ aalɨnndaalʉʉsiisye Jesu ʉkʉtɨ, “Kʉlonda ɨfiki kʉmyake?” pamo ʉkʉtɨ, “Fiki kʉjoba nagwe?” ");
INSERT INTO nyy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ʉnkiikʉlʉ jʉla alɨnkʉjɨleka ɨndeko jaake ɨjaa mɨɨsi palapala, alɨnkʉbʉʉka nkaaja. Bo afikile alɨnkʉbabʉʉla abandʉ alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tʉbʉʉke mukankeete ʉmundʉ ʉjʉ aambʉʉlile syosa ɨsi mbombilemo. Bʉle, ʉmundʉ ʉjo abagiile ʉkʉja jo Meesija ʉjʉ tukʉsʉʉbɨla ʉkʉtɨ ikwisa?” ");
INSERT INTO nyy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Po bo abandʉ bapɨliike ɨsyo, balɨnkʉsookamo nkaaja kala, nʉ kwanda ʉkʉbʉʉka kʉno Jesu aaliko. ");
INSERT INTO nyy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Bo abandʉ bala bakaalɨ ʉkʉfika, abafundigwa baake balɨnkʉnsʉʉma balɨnkʉtɨ, “Gwe Mmanyisi, isaga pakʉlya ɨfindʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Looli ʉmwene alɨnkʉbaamula alɨnkʉtɨ, “Ʉne ndɨ nɨ findʉ ɨfya lʉko ʉlʉngɨ ɨfi ʉmwe mukafimanya.” ");
INSERT INTO nyy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Po abafundigwa baake balɨnkwanda ʉkʉlaalʉʉsania balɨnkʉtɨ, “Bʉle, alipo ʉmundʉ ʉjʉ iisile kʉkʉmpapo ɨfindʉ bo tʉkajapo?” ");
INSERT INTO nyy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ɨfindʉ fyangʉ ʉne ko kʉbomba ɨsya bwigane bwa Taata ʉjʉ aalɨndʉmile, kʉkʉmalɨɨsya ɨmbombo jaake. ");
INSERT INTO nyy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ʉmwe mukʉtɨ, ‘Gɨsyele ɨmyesi mina itolo ʉkʉfika ʉntondolo.’ Looli sikaja bo ʉlo! Namukeete ɨmigʉnda muno gɨjɨɨliile. Ɨfya kʉtondola fikomile ʉkʉtɨ fitondoligwe. ");
INSERT INTO nyy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kangɨ ʉntondoli akabile ʉmfwalo gwake. Alɨ pakʉbʉngaania mu ndamba syake ɨfi atondwile, kokʉtɨ ʉbʉʉmi bwa bwila na bwila. Po ʉmbyali nʉ ntondoli boosa bikʉsekelaga pamopeene. ");
INSERT INTO nyy_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bʉlipo ʉbʉjobi ʉbʉ bukʉtɨ, ‘Ʉmundʉ jʉmo ikʉbyala ɨmbeju, ʉjʉngɨ ikʉtondola.’ Ʉbʉjobi ʉbo bwa nalooli. ");
INSERT INTO nyy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Naabatʉmile ʉmwe kʉkʉtondola ɨfi mukaabyele. Abandʉ abangɨ baabombile ɨmbombo joosa ɨngafu, ʉmwe mukʉkaba kʉnongwa jaa mbombo jaabo.” ");
INSERT INTO nyy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ABasamalija bingi abaa nkaaja kala akaa mu Sikali, balɨnkʉmmwitɨka Jesu, paapo baapɨliike ɨsi ʉnkiikʉlʉ jʉla aajobile ʉkʉtɨ, “Ʉmundʉ ʉjo aambʉʉlile syosa ɨsi mbombilemo.” ");
INSERT INTO nyy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Po aBasamalija bala balɨnkʉfika apa Jesu aalipo, balɨnkʉnsʉʉma fiijo ʉkʉtɨ atʉʉgalepo pamopeene nabo. Po alɨnkʉtʉʉgala nkaaja ako amasikʉ mabɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nkabalɨlo ako, abandʉ bingi fiijo balɨnkʉmmwitɨka Jesu kʉnongwa jaa ɨsi aajobaga. ");
INSERT INTO nyy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Balɨnkʉmmbʉʉla ʉnkiikʉlʉ jʉla balɨnkʉtɨ, “Mpaka ʉlʉ tʉmmwitiike ʉmundʉ ʉjʉ kʉnongwa jaa syene ɨsi ʉtʉbʉʉlile ʉgwe. Looli ʉlʉ tʉbagiile ʉkʉmmwitɨka fiijo, paapo tʉpɨliike jʉjʉʉswe ɨsi ikʉjoba. Kangɨ tʉsyageenie ʉkʉtɨ nalooli ʉmundʉ ʉjʉ jo Mpoki gwa kiisʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Amasikʉ mabɨlɨ bo gakɨndile, Jesu alɨnkʉsookamo nkaaja akaa mu Sikali, alɨnkʉbʉʉka mu Galilai. ");
INSERT INTO nyy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesu aajobile kʉ bafundigwa baake ʉkʉtɨ, ʉnkunguluka atikwɨmɨkigwa na bandʉ abaa kʉmyabo. ");
INSERT INTO nyy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Abandʉ abaa mu Galilai balɨnkʉmmwambɨlɨla kanunu, paapo boope baabʉʉkile kʉ kyaka kya Pasa mu Jelusalemu, koope baasibwene syosa ɨsi Jesu aabombile. ");
INSERT INTO nyy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Po Jesu alɨnkʉbʉʉka kangɨ nkaaja akaa mu Kana aka kalɨ mu Galilai. Nkaaja ako mo muno aasanwisye amɨɨsi ʉkʉja finga. Aalimo ʉndongosi jʉmo ʉgwa silikali mu Kapelinaʉmu ʉjʉ ʉmwanaake ʉndʉmyana aalɨ mbine. ");
INSERT INTO nyy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ʉndongosi ʉjo aapɨliike ʉkʉtɨ Jesu iisile kangɨ mu Galilai, ʉkʉfuma nkiisʉ ɨkya Jutai. Alɨnkʉbʉʉka kwa Jesu nʉ kʉnsʉʉma fiijo ʉkʉtɨ abʉʉke mu Kapelinaʉmu, kʉkʉmmbʉmbʉlʉsya ʉmwanaake, ʉjʉ aalɨ kɨfuki ʉkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesu alɨnkʉmmwamula ʉndongosi jʉla alɨnkʉtɨ, “Mwe bandʉ ʉmwe, bʉle, mukabagɨla ʉkʉʉnyiitɨka kɨsita kʉfibona ɨfiika ɨfikʉlʉmba?” ");
INSERT INTO nyy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ʉndongosi alɨnkʉmmwamula alɨnkʉtɨ, “Gwe Ntwa, ngʉkʉsʉʉma, tʉbʉʉke ʉkammbʉmbʉlʉsye ʉmwanangʉ bo akaalɨ ʉkʉfwa.” ");
INSERT INTO nyy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Looli Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Bʉʉkaga kʉmyɨnu, ʉmwanaako abʉmbʉlwike.” Ʉndongosi jʉla alɨnkwitɨka amasyʉ gaa Jesu, po alɨnkʉbʉʉka kʉmyake. ");
INSERT INTO nyy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ʉndongosi jʉla bo ikwenda mu njɨla, alɨnkwaganila na babombeli baake. Balɨnkʉmmbʉʉla balɨnkʉtɨ, “Ʉmwanaako abʉmbʉlwike, nkafu itolo.” ");
INSERT INTO nyy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Po alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Abʉmbʉlwike ʉkwandɨla ndɨli?” Abeene balɨnkʉmmwamula balɨnkʉtɨ, “Abʉmbʉlwike ʉkwandɨla mmajolo pamuusi, ɨsala jaa 7:00.” ");
INSERT INTO nyy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Po ʉgwise ʉgwa ndʉmyana jʉla alɨnkʉsyagania ʉkʉtɨ abʉmbʉlwike ʉkwandɨla akabalɨlo kalakala aka Jesu aatile, “Ʉmwanaako abʉmbʉlwike.” Po ʉndongosi jʉla pamopeene na baa nnyumba jaake balɨnkʉmmwitɨka Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ʉlʉ lwalɨ lwa bʉbɨlɨ Jesu ʉkʉfuma mu Jutai ʉkʉbomba ɨkiika mu Galilai. ");
INSERT INTO nyy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bo sikɨndile ɨsyo, Jesu alɨnkʉbʉʉka nkaaja akaa mu Jelusalemu, kʉkʉsekela ɨkyaka kɨmo ɨkya Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nkaaja ako, kyalipo ɨkɨpata ɨkɨnywamu ɨkɨ ɨngamu jaake baatɨgɨ, Kɨpata kya Ngʼoosi. Kɨfuki nɨ kɨpata ɨkyo, kyalipo ɨkɨsiba ɨkɨ ɨngamu jaake mu njobelo jaabo baatɨgɨ Betisaita. Gaalipo amabalaasa mahaano aga gaalɨ nɨ mbanda. Amabalaasa ago gaasyʉngʉʉtiile ɨkɨsiba ɨkyo. ");
INSERT INTO nyy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pa kɨpepo ɨkya mabalaasa ago, baalambalalaga ababine bingi, bo abafwa maaso, aba bikʉkwema, na aba balalile. Baaguulɨlaga amɨɨsi ʉkʉsukaanika, ");
INSERT INTO nyy_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","paapo ʉgwandʉmi gwa Kyala iisaga akabalɨlo kamo kʉkʉgasukaania amɨɨsi nkɨsiba kɨla. Ʉmbine ʉgwa kwanda ʉkwingɨla aabʉmbʉlʉkaga ʉbʉbine bwake ʉbʉ aalɨ nabo. ");
INSERT INTO nyy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pa kɨsiba kɨla aalipo ʉnnyambala jʉmo ʉjʉ aalɨ mbine ɨfyɨnja 38. ");
INSERT INTO nyy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Po Jesu alɨnkʉmmbona alambaleele pala. Bo ameenye ʉkʉtɨ abinile akabalɨlo akatali, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Bʉle, ʉgwe kʉlonda ʉkʉbʉmbʉlʉka?” ");
INSERT INTO nyy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Po ʉmbine jʉla alɨnkʉmmwamula Jesu alɨnkʉtɨ, “Gwe taata, akajapo ʉmundʉ ʉgwa kʉʉmbɨɨka nkɨsiba bo amɨɨsi gikʉsukaanika. Paapo bo ngʉlonda ʉkwingɨla nkɨsiba ɨkyo, ʉmundʉ ʉjʉngɨ ikʉtalapo nkyeni mmyangʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Po Jesu alɨnkʉmmbʉʉla ʉmbine jʉla alɨnkʉtɨ, “Sumuka, pɨmba ʉbʉlɨlɨ bwako, bʉʉkaga.” ");
INSERT INTO nyy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nakalɨnga, ʉmundʉ jʉla alɨnkʉbʉmbʉlʉka ʉbʉbine bwake, alɨnkʉpɨmba ʉbʉlɨlɨ bwake alɨnkwanda ʉkʉsyʉngʉʉtɨla syʉngʉʉtɨla palapala. Jesu aalɨmmbʉmbʉlwisye ʉmundʉ ʉjo pi isikʉ ɨlya pa Sabati. ");
INSERT INTO nyy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Po abalongosi baa Bajuuta balɨnkʉmmbʉʉla ʉmundʉ jʉla, ʉjʉ Jesu aalɨmmbʉmbʉlwisye balɨnkʉtɨ, “Ʉmwisyʉgʉ isikʉ lya Sabati, ɨndagɨlo sitikʉkwitɨkɨsya ʉkʉpɨmba ʉbʉlɨlɨ bwako.” ");
INSERT INTO nyy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Looli ʉmundʉ jʉla alɨnkʉbaamula alɨnkʉtɨ, “Ʉmundʉ ʉjʉ aambʉmbʉlwisye jo ʉjʉ aambʉʉlile ʉkʉtɨ mbɨmbe ʉbʉlɨlɨ bwangʉ mbʉʉkege.” ");
INSERT INTO nyy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Po abalongosi bala balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, jo jwani ʉjʉ akʉbʉʉlile ʉkʉbomba bo ʉlʉ?” ");
INSERT INTO nyy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Looli ʉmundʉ jʉla akaalɨmmeenye ʉjʉ aalɨmmbʉmbʉlwisye, paapo Jesu aasookilepo pa kɨlʉndɨlo kya bandʉ, aba baalipo pala. ");
INSERT INTO nyy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɨliisikʉ lɨlalɨla bo kakɨndilepo akabalɨlo kanandɨ, Jesu alɨnkwakʉmmwaga ʉmundʉ jʉla ndʉpaso lwa tempeli, alɨnkʉnsoka alɨnkʉtɨ, “Pɨlɨkɨsya, lɨɨlɨno ʉbʉmbʉlwike. Ʉlɨngatʉlaga kangɨ ɨnongwa, paapo lɨnga kwendelela ʉkʉtʉla ɨnongwa, aakʉtaamigwa fiijo ʉkʉkɨnda akabalɨlo aka gwataamigwaga kʉbwandɨlo.” ");
INSERT INTO nyy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nakalɨnga, ʉmundʉ jʉla alɨnkʉnndeka Jesu, alɨnkʉgomokelako kangɨ kʉkʉbabʉʉla abalongosi baa Bajuuta, ʉkʉtɨ jo Jesu ʉjʉ ammbʉmbʉlwisye. ");
INSERT INTO nyy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Po abalongosi baa Bajuuta balɨnkwanda ʉkʉntaamya Jesu, paapo aababʉmbʉlʉsyaga abandʉ pi isikʉ ɨlya pa Sabati. ");
INSERT INTO nyy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Looli Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Taata ikʉbomba ɨmbombo amasikʉ goosa kɨsita kʉleka. Po na niine ngʉbomba ɨmbombo kɨsita kʉleka.” ");
INSERT INTO nyy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kʉnongwa ɨjo, abalongosi baa Bajuuta balɨnkwanda ʉkʉlonda ɨnjɨla ɨjaa kʉnngoga Jesu. Baabombile bo ʉlo paapo jɨkaalɨ jeene ɨnongwa ɨjaa kʉkilania ɨSabati, looli paapo aajobaga ʉkʉtɨ Kyala jo Gwise. Kʉ njɨla ɨjo iibɨɨkaga ʉkʉtɨ alɨ bo muno ajɨɨliile Kyala. ");
INSERT INTO nyy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesu alɨnkʉbabʉʉla abalongosi bala alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, ʉne ne Mwanaake, ngabagɨla ʉkʉbomba syosyosa kʉ maka gangʉ. Ʉne ngʉsibomba syene ɨsi ngʉmmbona Taata ikʉsibomba, kangɨ syosa ɨsi Taata ikʉsibomba, syo ɨsi na niine ne Mwanaake ngʉsibomba. ");
INSERT INTO nyy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taata aanganile ʉne, jo nongwa ɨjɨ ikʉʉnangɨsya ɨmbombo syosa ɨsi ikʉsibomba, kangɨ aikʉʉnangɨsya muno angʉbombelaga ɨfiika ɨfikʉlʉmba ʉkʉkɨnda ɨfyo, po mukʉswigaga fiijo. ");
INSERT INTO nyy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bo ʉlʉ Taata ikʉbasyʉsya abafwe nʉ kʉbapa ʉbʉʉmi bwa bwila na bwila, bo lʉlʉʉlo na niine mbagiile ʉkʉbapa ʉbʉʉmi abandʉ aba niiganile ʉkʉbapa. ");
INSERT INTO nyy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Taata atikʉnndonga ʉmundʉ gwesa jʉla, looli ambeele ʉne ʉbʉlagɨli ʉbwa kʉbalonga abandʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kʉ njɨla ɨjo, abandʉ boosa aabikʉʉnyɨɨmɨkaga bo ʉlʉ bikʉmmwɨmɨka Taata. Ʉmundʉ gwesa ʉjʉ atikʉʉnyɨɨmɨka ʉne ne Mwanaake, po atikʉmmwɨmɨka Taata ʉjʉ andʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nalooli nikʉbabʉʉla, abandʉ boosa aba bikʉgapɨlɨka amasyʉ gangʉ nʉ kʉmmwitɨka Kyala ʉjʉ andʉmile, balɨ nʉ bʉʉmi bwa bwila na bwila. Aabatikʉlongigwa kʉ bʉtʉlanongwa bwabo, looli balobwike ʉkʉfuma mbʉfwe nʉ kwingɨla mbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nalooli nikʉbabʉʉla, akabalɨlo kikwisa, kangɨ kafikile, aka abafwe aabikʉpɨlɨka ɨsi ne Mwana gwa Kyala ngʉjoba. Po aba bikʉpɨlɨkaga, bikʉjaga nʉ bʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bo ʉlʉ Taata alɨ na maka agaa kʉmpapo ʉmundʉ ʉbʉʉmi bwa bwila na bwila, na niine ne Mwanaake ambeele amaka aga kʉbapapo abandʉ ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kangɨ ambeele amaka agaa kʉbalonga abandʉ, paapo ʉne ne Nnyamundʉ. ");
INSERT INTO nyy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mulɨngaswigaga! Aakikwisa akabalɨlo aka abafwe boosa bikwisa kʉmbɨlɨkaga bo ngʉbakoolela, ");
INSERT INTO nyy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bikwisa kʉsooka mmapʉmba gaabo, bikwisa kʉsyʉsigwa na Kyala. Aba baabombaga ɨnunu, bikwisa kʉpeeligwa ʉbʉʉmi bwa bwila na bwila, looli aba baabombaga ɨmbiibi, bikwisa kʉlongigwa.” ");
INSERT INTO nyy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesu alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Kakajako akandʉ nakamo aka mbagiile ʉkʉkabomba kʉ bʉlagɨli bwangʉ. Ngʉbalonga abandʉ ʉkʉkongana na muno Taata ikʉʉmbʉʉlɨla. Kʉnongwa ɨjo ʉbʉlongi bwangʉ bwa nalooli, paapo ndikʉbomba ɨsi niiganile ʉne, looli ngʉbomba ɨsya bwigane bwa Kyala, ʉjʉ andʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Lɨnga ngʉbabʉʉla ʉmwe ɨnongwa syangʉ jʉjʉʉne, mukabagɨla ʉkwitɨka ɨsi ngʉjoba ʉkʉtɨ sya nalooli. ");
INSERT INTO nyy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Leelo Taata joope ikʉsijoba ɨnongwa syangʉ kʉmyɨnu, na niine mmeenye ʉkʉtɨ syosa ɨsi ikʉʉnjoba sya nalooli. ");
INSERT INTO nyy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ʉmwe mwabatʉmile abandʉmi kwa Johani ʉMoosi, joope aalɨɨnjobile ɨsya nalooli kʉmyɨnu. ");
INSERT INTO nyy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ʉne ndikʉsʉʉbɨla ɨsi abandʉ bikʉʉnjoba, looli ngʉbabʉʉla syosa ɨsyo ʉkʉtɨ mupokigwe. ");
INSERT INTO nyy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","“Johani ʉMoosi abʉnangiisye ʉbwanalooli kʉmyɨnu, bo ʉlwa nyaale muno jikwakɨla nʉ kʉmulɨka mu ngiisi. Ʉmwe mwalʉsaaliile ʉlʉmuli ʉlo kʉkabalɨlo akanandɨ. ");
INSERT INTO nyy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Looli ndɨ nasyo ɨsi sikʉʉsisimɨkɨsya fiijo, sikɨndilepo ɨsi Johani aajobaga. Paapo ɨmbombo ɨsi Taata aalɨmbeele ʉkʉtɨ nsibombege syo ɨsi sikʉnangɨsya ʉkʉtɨ Taata Kyala, jo ʉjʉ andʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Joope Taata ʉjʉ andʉmile ʉne, aasisimɨkiisye ʉne kʉmyɨnu. Ʉmwe mukapɨlɨkamo sikʉ iisyʉ lyake, kangɨ mukammbonamo sikʉ muno ajɨɨliile. ");
INSERT INTO nyy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mukʉkaana ʉkʉgabɨɨka amasyʉ agaa Kyala mu ndumbula syɨnu paapo mutikʉʉnyiitɨka ʉne, ne Kyala andʉmile kʉmyɨnu. ");
INSERT INTO nyy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mukwijʉʉla fiijo ʉkʉbala Kalata ʉMwikemo, paapo mukwinogona ʉkʉtɨ mubagiile ʉkʉkabamo ʉbʉʉmi bwa bwila na bwila. Nalooli ɨsyo sikʉʉsisimɨkɨsya ʉne, ");
INSERT INTO nyy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","leelo mukʉkaana ʉkwisa kʉmyangʉ, ʉkʉtɨ mupeeligwe ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ɨnyango jangʉ kʉkaja ko kʉkaba ʉbʉsisya ʉkʉfuma kʉ bandʉ. ");
INSERT INTO nyy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Looli mbameenye ʉmwe muno mujɨɨliile, ʉkʉtɨ mukanngana Kyala mu ndumbula syɨnu. ");
INSERT INTO nyy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ʉne niisile kʉ bʉlagɨli bwa Taata, looli mukʉkaana ʉkʉʉnyambɨlɨla. Lɨnga ʉmundʉ ʉjʉngɨ ikwisa kʉ bʉlagɨli ʉbwake mwene, aamukʉmmwitɨka nʉ kʉmmwambɨlɨla. ");
INSERT INTO nyy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mwiganile ʉkwɨmɨkigwa na biinɨɨnu, looli mutikwijʉʉla ʉkʉlonda ʉlwɨmɨko ʉlʉ lukʉfuma kwa Kyala jʉʉjo. Po leelo, mubagiile bʉleebʉle ʉkʉʉnyiitɨka ʉne? ");
INSERT INTO nyy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Mulɨngiinogonaga ʉkʉtɨ ʉne angʉbasitaaka kwa Taata. Hɨmma! Moose jo ʉjʉ aikʉbasitaaka, paapo jo ʉjʉ mukʉnsʉʉbɨla. ");
INSERT INTO nyy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Lɨnga nalooli mwaliitiike amasyʉ agaa Moose, po mwabagiile ʉkʉʉnyiitɨka na niine, paapo Moose jo ʉjʉ aasimbile ɨnongwa syangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mutikwitɨka amasyʉ gaa Moose. Po mubagiile bʉleebʉle ʉkwitɨka amasyʉ gangʉ?” ");
INSERT INTO nyy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bo sikɨndile ɨsyo, Jesu alɨnkʉloboka sʉmbɨ Galilai, ʉjʉ ɨngamu ɨjɨngɨ jo sʉmbɨ Tibelija. ");
INSERT INTO nyy_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ɨkɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ bankongaga Jesu, paapo baafibonaga ɨfiika ɨfi aabombaga kʉ babine. ");
INSERT INTO nyy_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Po Jesu na bafundigwa baake balɨnkʉfyʉka pa kyamba kɨmo, balɨnkʉtʉʉgala pamopeene. ");
INSERT INTO nyy_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Akabalɨlo ako, ɨkyaka kya Pasa kyalɨ kɨfuki. ");
INSERT INTO nyy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesu alɨnkʉkeeta, alɨnkʉkɨbona ɨkɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ, ɨkɨ kiisaga kʉmyake. Po alɨnkʉnndaalʉʉsya Filipo alɨnkʉtɨ, “Filipo, bʉle, tʉbagiile ʉkwakʉʉla kʉʉgʉ ɨfindʉ ɨfya kʉbaswɨla abandʉ boosa aba?” ");
INSERT INTO nyy_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesu aalɨnndaalʉʉsiisye Filipo bo ʉlo, ʉkʉnngela, paapo aameenye ɨsya kʉbomba. ");
INSERT INTO nyy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo alɨnkʉmmwamula alɨnkʉtɨ, “Nalɨnga twalondaga ʉkʉfyaga ɨfindʉ ʉkʉtɨ kʉkʉtɨ mundʉ akabepo fimo, leelo ɨndenali ɨmia ibɨlɨ sikabagɨla ʉkʉfwana.” ");
INSERT INTO nyy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Po Andeleja, ʉjʉ aalɨ mfundigwa ʉjʉngɨ, kangɨ gwamyabo gwa Simoni Peeteli, alɨnkʉmmwamula Jesu alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Gwe Ntwa, alipo ʉndʉmyana jʉmo apa, ʉjʉ alɨ nɨ fisyesye fihaano ɨfya syaɨli nʉ tʉswɨ ʉtʉnandɨ tʉbɨlɨ. Leelo ɨfindʉ ɨfi fibagiile bʉleebʉle ʉkʉkɨfwana ɨkɨlʉndɨlo ɨkɨ?” ");
INSERT INTO nyy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Po Jesu alɨnkʉbalagɨla abafundigwa baake alɨnkʉtɨ, “Namubabʉʉle abandʉ batʉʉgale paasi.” Pabʉjo bʉla lyalipo ɨliisʉ lingi, boosa baatʉʉgeele paasi. Nkɨlʉndɨlo kɨla, baalimo abanyambala 5,000 bʉno. ");
INSERT INTO nyy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Po Jesu alɨnkwega ɨfisyesye fila, alɨnkʉgwa ʉlʉpi kwa Kyala, alɨnkʉfimenya, alɨnkʉbajabɨla abandʉ boosa aba baalipo pala. Alɨnkʉbomba bo ʉlo na kʉ tʉswɨ tʉla, bo muno baalondelaga ʉkʉlya. ");
INSERT INTO nyy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Abandʉ boosa bo biikwite, Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Namubʉngaanie ɨfindʉ fyosa ɨfi fisyele, ʉkʉtɨ fingiisa koonangɨka.” ");
INSERT INTO nyy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Po balɨnkʉbʉngaania ɨfindʉ fyosa ɨfi fyasyele nʉ kwisʉsya ɨfiibo kalongo na fibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Abandʉ bala bo bakɨbwene ɨkiika ɨkɨ Jesu aabombile, balɨnkʉjoba balɨnkʉtɨ, “Nalooli ʉmundʉ ʉjʉ nkunguluka gwa Kyala, jo ʉjʉ twasʉʉbɨlaga ʉkʉtɨ ikwisa pakiisʉ apa.” ");
INSERT INTO nyy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesu alɨnkʉmanya ʉkʉtɨ abandʉ bala bikʉlonda ʉkʉnkola, nʉ kʉmmbɨɨka kʉ maka ʉkʉja Malafyale gwabo. Looli ʉmwene alɨnkʉsookapo alɨnkʉbʉʉka kangɨ mwene kʉ kyamba. ");
INSERT INTO nyy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Akabalɨlo akaa namajolo, abafundigwa baa Jesu balɨnkʉsuluka ʉkʉbʉʉka kwa sʉmbɨ Galilai. ");
INSERT INTO nyy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Balɨnkwingɨla mwi ibooti, nʉ kwanda ʉkʉloboka sʉmbɨ ʉkʉbʉʉka mu Kapelinaʉmu. Akabalɨlo ako jaalɨ ngiisi, looli Jesu aakaalɨ ʉkʉfika, ʉkʉja pamopeene nabo. ");
INSERT INTO nyy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Po sʉmbɨ alɨnkʉsambʉka, paapo ʉmbelo ʉnkalɨ fiijo gwakulaga. ");
INSERT INTO nyy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Abafundigwa baa Jesu bo bafigilepo iibooti ɨkilomita ihaano, pamo ntandatʉ bʉno, balɨnkʉmmbona Jesu ikwenda pamwanya pa mɨɨsi, ʉkʉsegelela kwi ibooti, po balɨnkʉtiila fiijo. ");
INSERT INTO nyy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Jo ʉne! Mungatiilaga!” ");
INSERT INTO nyy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Po abeene baalondaga ʉkʉtɨ ingɨle mwi ibooti. Nakalɨnga iibooti lɨlɨnkʉfika kwi isɨɨlya kʉno baabʉʉkaga. ");
INSERT INTO nyy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kɨlaabo kyake, ɨkɨlʉndɨlo ɨkya bandʉ aba baasyele kwi isɨɨlya ɨlɨngɨ ɨlya sʉmbɨ, balɨnkʉsyagania ʉkʉtɨ lɨlipo iibooti lɨmolyene itolo pala. Kangɨ balɨnkʉsyagania ʉkʉtɨ Jesu akaabʉʉkile mwi ibooti lɨla pamopeene na bafundigwa baake, looli abafundigwa baake baabʉʉkile beene. ");
INSERT INTO nyy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Po abandʉ abangɨ balɨnkwisa na mabooti agangɨ ʉkʉfuma mu Tibelija, balɨnkʉfika apa ɨkɨlʉndɨlo kya bandʉ baaliile ɨfisyesye, bo Jesu agwile ʉlʉpi kwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Po ɨkɨlʉndɨlo ɨkya bandʉ bala, bo basyageenie ʉkʉtɨ Jesu akajapo pala, na bafundigwa baake boope bakajapo, balɨnkwingɨla mmabooti gala, balɨnkʉbʉʉka mu Kapelinaʉmu kʉkʉnndonda Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Abandʉ bala bo bafikile kwi isɨɨlya ɨlya sʉmbɨ, balɨnkʉmmwaga, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Gwe Mmanyisi, gwisile ndɨli kʉno?” ");
INSERT INTO nyy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, mmeenye ʉkʉtɨ mukʉʉndonda somma kʉnongwa jaa kʉfyagania ɨfiika ɨfi naabombile, looli paapo naabapeele ɨfisyesye, mwaliile nʉ kwikʉta. ");
INSERT INTO nyy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mulɨngabombaga ɨmbombo kʉnongwa jaa kʉkaba ɨfindʉ ɨfi fikoonangɨka, looli mubombege kʉnongwa jaa findʉ ɨfi fitikoonangɨka, ɨfi fikʉbapa ʉbʉʉmi bwa bwila na bwila. Ʉne ne Nnyamundʉ ngʉbapa abandʉ ɨfindʉ ɨfyo, paapo Taata Kyala aanangiisye pabwelu amaka gangʉ agaa kʉbomba ɨsyo.” ");
INSERT INTO nyy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Po abeene balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, tʉtɨ fiki ʉkʉtɨ tʉsibombege ɨmbombo ɨsi Kyala ikʉsilonda?” ");
INSERT INTO nyy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ɨmbombo ɨjɨ Kyala ikʉlonda mujɨbombege, jo jaa kʉʉnyiitɨka ʉne, ne ndʉmiigwe nagwe.” ");
INSERT INTO nyy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, kʉbomba kiika nki ʉkʉtɨ tʉkɨbone, nʉ kwitɨka? Kʉbomba mbombo jɨlɨkʉ? ");
INSERT INTO nyy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Abiisʉkʉlʉ bɨɨtʉ baaliile ɨmana bo balɨ ndʉngalangala, bo ʉlʉ sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Aabapeele ɨfindʉ ɨfya kʉfuma kʉmwanya.’ ” ");
INSERT INTO nyy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, akaja jo Moose ʉjʉ aabapeele abiisʉkʉlʉ bɨɨnu ɨfindʉ fila, looli jo Taata ʉjʉ lɨɨlɨno ikʉbapa ʉmwe ɨfindʉ ɨfya nalooli ɨfya kʉfuma kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Namanga ɨfindʉ ɨfya Kyala fyo ɨfi ikʉfitʉma ʉkʉfuma kʉmwanya, ʉkʉtɨ fibape ʉbʉʉmi bwa bwila na bwila, abandʉ boosa abaa pakiisʉ apa.” ");
INSERT INTO nyy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Po balɨnkʉmmwamula balɨnkʉtɨ, “Gwe Ntwa, tukʉsʉʉma ʉtʉpege ɨfindʉ ɨfya lʉko ʉlo amasikʉ goosa.” ");
INSERT INTO nyy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ʉne ndɨ findʉ ɨfi fikʉbapa ʉbʉʉmi. Ʉmundʉ gwesa ʉjʉ ikwisa kʉmyangʉ, nʉ kʉʉnyiitɨka, jɨtikwisa kʉnndʉmamo sikʉ ɨnjala, kangɨ atikwisa kʉʉmɨlwamo sikʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Looli ʉne mbabʉʉlile ʉkʉtɨ na paapo muumbwene, mukaalɨ mutikʉʉnyiitɨka. ");
INSERT INTO nyy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Abandʉ boosa aba Taata ikʉmbapo, bikwisa kʉmyangʉ nʉ kʉʉnyiitɨka. Kangɨ ʉne ndikʉnkaana najʉmo ʉjʉ ikwisa kʉmyangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Paapo ʉne niisile ʉkʉfuma kʉmwanya ʉkʉtɨ nsibombege ɨsya bwigane bwa Taata ʉjʉ andʉmile. Ngiisa kʉkʉsibomba ɨsya bwigane bwangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Bwigane bwa Taata ʉjʉ andʉmile, ʉkʉtɨ ndɨngiisa kʉnsobesya najʉmo ndɨ bala ambeele, looli mbasyʉsye boosa, baje bʉʉmi pi isikʉ lya bʉlongi. ");
INSERT INTO nyy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Paapo ʉbwigane bwa Taata bo ʉbʉ, kʉkʉtɨ mundʉ ʉjʉ ikʉsyagania ʉkʉtɨ ʉne ndɨ Mwanaake, nʉ kʉʉnyiitɨka, akabe ʉbʉʉmi bwa bwila na bwila. Ʉne ngwisa kʉnsyʉsya pi isikʉ lya bʉlongi.” ");
INSERT INTO nyy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Po aBajuuta balɨnkwanda ʉkwibuneesya paapo Jesu aaliijobile ʉkʉtɨ, “Ʉne ndɨ findʉ ɨfi Kyala afitʉmile ʉkʉfuma kʉmwanya.” ");
INSERT INTO nyy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Balɨnkʉlaalʉʉsania balɨnkʉtɨ, “Bʉle, ʉmundʉ ʉjʉ akaja jo Jesu, ʉmwana gwa Joosefu, ʉjʉ tʉbameenye abapaapi baake boosa? Po abagiile ʉkʉjoba bʉleebʉle ʉkʉtɨ afumile kʉmwanya?” ");
INSERT INTO nyy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Namuleke ʉkwibuneesya mwibeene. ");
INSERT INTO nyy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Akajako ʉmundʉ ʉjʉ abagiile ʉkwisa kʉmyangʉ, lɨnga Taata ʉjʉ andʉmile akanndongosya. Na niine ngwisa kʉnsyʉsya pi isikʉ lya bʉlongi. ");
INSERT INTO nyy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mwa Kalata ʉMwikemo ʉnkunguluka jʉmo aasimbile ʉkʉtɨ, ‘Kyala aikʉbamanyisya abandʉ boosa.’ Po leelo ʉmundʉ gwesa ʉjʉ ikʉpɨlɨkɨsya nʉ kʉmanyila ʉkʉfuma kwa Taata, jo ikwisa kʉmyangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ndikʉtɨ aliko ʉmundʉ ʉjʉ ammbwenemo Taata Kyala. Looli ʉne niimwene nʉmmbwene, paapo mfumile kʉmyake.” ");
INSERT INTO nyy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Nalooli nikʉbabʉʉla, ʉmundʉ gwesa ʉjʉ ikʉʉnyiitɨka ʉne, alɨ nʉ bʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ʉne ndɨ findʉ ɨfi fikʉbapa abandʉ ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Na paapo abiisʉkʉlʉ bɨɨnu baaliile ɨmana ndʉngalangala, poope baafwile. ");
INSERT INTO nyy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Looli apa filipo ɨfindʉ ɨfi fifumile kwa Kyala. Lɨnga ʉmundʉ aliile ɨfindʉ ɨfyo, atiisakʉfwamo sikʉ. ");
INSERT INTO nyy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ʉne ndɨ findʉ ɨfi fifumile kʉmwanya, ɨfi fikʉbapa abandʉ ʉbʉʉmi. Ʉmundʉ gwesa ʉjʉ ikʉlya ɨfindʉ ɨfi, ikʉja nʉ bʉʉmi bwa bwila na bwila. Ɨfindʉ ɨfi go mbɨlɨ gwangʉ, ʉgʉ angʉgʉsoosya kʉ bandʉ boosa, ʉkʉtɨ bajege nʉ bʉʉmi bwa bwila na bwila.” ");
INSERT INTO nyy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Po aBajuuta balɨnkwanda ʉkʉkaanikana nʉ kʉlaalʉʉsania, balɨnkʉtɨ, “Ʉmundʉ ʉjʉ abagiile bʉleebʉle ʉkʉtʉpapo ʉmbɨlɨ gwake, ʉkʉtɨ tʉgʉlye?” ");
INSERT INTO nyy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Looli Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, lɨnga mutikʉgʉlya ʉmbɨlɨ gwangʉ, nʉ kʉnwa iilopa lyangʉ ʉne ne Nnyamundʉ, mutikʉjaga nʉ bʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ʉmundʉ gwesa ʉjʉ ikʉlya ʉmbɨlɨ gwangʉ nʉ kʉnwa iilopa lyangʉ, alɨ nʉ bʉʉmi bwa bwila na bwila, na niine ngwisa kʉnsyʉsya pi isikʉ lya bʉlongi. ");
INSERT INTO nyy_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Paapo ʉmbɨlɨ gwangʉ fyo findʉ fya nalooli, ni ilopa lyangʉ fyo fya kʉnwa ɨfya nalooli. ");
INSERT INTO nyy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ʉmundʉ gwesa ʉjʉ ikʉlya ʉmbɨlɨ gwangʉ nʉ kʉnwa iilopa lyangʉ, ikwendelelaga ʉkʉja mmyangʉ na niine ngʉjaga mmyake. ");
INSERT INTO nyy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Bo apa Taata ʉjʉ andʉmile mʉʉmi, ʉne ngʉkaba ʉbʉʉmi ʉkʉfuma kʉmyake. Bʉbʉʉbo ʉmundʉ gwesa ʉjʉ ikʉʉndya ʉne, ikʉkaba ʉbʉʉmi ʉkʉfuma kʉmyangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Po ʉne ndɨ findʉ ɨfi fifumile kwa Kyala. Ɨfindʉ ɨfi, fikafwana nɨ findʉ ɨfi abiisʉkʉlʉ bɨɨnu baaliile. Abeene baafwile. Looli ʉmundʉ gwesa ʉjʉ ikʉlya ɨfindʉ ɨfi, ikʉjaga nʉ bʉʉmi bwa bwila na bwila.” ");
INSERT INTO nyy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesu aajobile amasyʉ aga bo alɨ pakʉmanyisya mu sinagogi, kʉla kʉ Kapelinaʉmu. ");
INSERT INTO nyy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bo bapɨliike ɨsyo, bingi ndɨ aba bankongaga balɨnkʉjobesania balɨnkʉtɨ, “Ɨmanyisyo ɨsi ngafu fiijo! Bʉle, jo jwani abagiile ʉkʉsiitɨka?” ");
INSERT INTO nyy_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesu bo asyageenie ʉkʉtɨ bikwibuneesya kʉlɨ ɨsi ajobile, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Bʉle, isyʉ ɨlɨ likʉbapela ʉkwikinyamo? ");
INSERT INTO nyy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Po sikʉjaga bʉleebʉle, lɨnga mukʉʉmbona ne Nnyamundʉ, ngʉfyʉka ʉkʉbʉʉka kʉmwanya kʉno naaliko kʉbwandɨlo? ");
INSERT INTO nyy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mbepo gwa Kyala jo ʉjʉ ikʉbapa abandʉ ʉbʉʉmi. Ʉmundʉ akabagɨla ʉkʉbomba nasimo kʉ maka gaake mwene. Amasyʉ aga mbabʉʉlile gikʉntwala kʉmyɨnu Mbepo gwa Kyala, nʉ bʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Leelo balipo bamo pakatɨ pamyɨnu aba bikʉkaana ʉkʉʉnyiitɨka.” Jesu aajobile bo ʉlo paapo aameenye ʉkʉfuma kʉbwandɨlo ʉkʉtɨ bo baani aba aabikʉnkaana ʉkʉmmwitɨka, nʉ kʉtɨ jo jwani ʉjʉ aikwisa kʉnndɨɨla. ");
INSERT INTO nyy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Po alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Jo nongwa ɨjɨ mbabʉʉlile ʉkʉtɨ, akajapo ʉmundʉ ʉjʉ abagiile ʉkwisa kʉmyangʉ, lɨnga Taata akanndongosya.” ");
INSERT INTO nyy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ʉkʉfuma akabalɨlo kala, bingi ndɨ aba bankongaga balɨnkʉnndeka, baalekile ʉkʉlongosania nagwe kangɨ. ");
INSERT INTO nyy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Po Jesu alɨnkʉbalaalʉʉsya bala kalongo na babɨlɨ alɨnkʉtɨ, “Bʉle, na nuumwe mukʉlonda ʉkʉʉndeka?” ");
INSERT INTO nyy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Peeteli alɨnkwamula alɨnkʉtɨ, “Gwe Ntwa, jo jwani ʉjʉngɨ, ʉjʉ tʉbagiile ʉkʉbʉʉka kʉmyake? Ʉgwe gwimwene ʉlɨ na masyʉ aga gikʉtʉpa ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ʉswe tukwitɨka, kangɨ tʉmeenye ʉkʉtɨ ʉgwe ʉlɨ Mwikemo ʉkʉfuma kwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Naabasalile ʉmwe kalongo na babɨlɨ ʉkʉja bafundigwa bangʉ, looli jʉmo pakatɨ pamyɨnu ikʉlongosigwa na Seetano.” ");
INSERT INTO nyy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Apa Jesu annjobaga Juuta ʉmwana gwa Simoni Isikalyoti. Ʉjo jo ʉjʉ aaliisile kʉnndɨɨla Jesu, na paapo alɨ jʉmo mbafundigwa kalongo na babɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ɨsyo bo sikɨndile, Jesu alɨnkwanda ʉkʉsyʉngʉʉtɨla ntwaja ʉtwa mu Galilai. Akaalondaga ʉkʉsyʉngʉʉtɨla mu Jutai, paapo abalongosi baa Bajuuta baalondaga ʉkʉnngoga. ");
INSERT INTO nyy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Akabalɨlo akaa kyaka kya Bajuuta ɨkya fitembe kaasegeliile. ");
INSERT INTO nyy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Po abanuguna baa Jesu balɨnkʉmmbʉʉla balɨnkʉtɨ, “Sookapo apa, ʉbʉʉke mu Jutai ʉkʉtɨ aba kʉbalongosya bakafibone ɨfiika ɨfi kʉbomba. ");
INSERT INTO nyy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Lɨnga ʉmundʉ ikʉlonda ʉkʉja mfumuke kʉ bandʉ, atikʉbomba ɨmbombo syake kʉbʉtiitʉ. Lɨnga ʉgwe ʉbagiile ʉkʉbomba syosa ɨsi, gwinangɨsye kʉ bandʉ boosa ʉkʉtɨ bakʉmanye.” ");
INSERT INTO nyy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Abanuguna baajobile bo ʉlo paapo boope bakaalɨmmwitiike Jesu ʉkʉja jo Meesija. ");
INSERT INTO nyy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Akabalɨlo kangʉ akaa kʉbʉʉka kakaalɨ ʉkʉfika, looli ʉmwe mubagiile ʉkʉbʉʉka akabalɨlo koosa. ");
INSERT INTO nyy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Abandʉ abaa pakiisʉ apa bakabagɨla ʉkʉbabenga ʉmwe, looli bikʉʉmbenga ʉne paapo nikʉbabʉʉla nikʉtɨ, ɨsi bikʉbomba mbiibi. ");
INSERT INTO nyy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Namufyʉke mwibeene ʉkʉbʉʉka mu Jelusalemu kʉ kyaka. Ʉne ndikʉbʉʉka, paapo akabalɨlo kangʉ kakaalɨ ʉkʉfika.” ");
INSERT INTO nyy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesu bo ajobile ɨsyo, alɨnkʉsyala nkiisʉ ɨkya Galilai. ");
INSERT INTO nyy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Leelo bo abanuguna babʉʉkile mu Jelusalemu kʉ kyaka, Jesu joope alɨnkʉfyʉka, looli kɨsita kwinangɨsya pabwelu. ");
INSERT INTO nyy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Po abalongosi baa Bajuuta, bo balɨ pa kyaka, balɨnkʉnndonda Jesu. Balɨnkʉbalaalʉʉsya abandʉ balɨnkʉtɨ, “Alɨ kʉʉgʉ ʉmundʉ jʉla?” ");
INSERT INTO nyy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Abandʉ bingi ʉkʉfuma nkɨlʉndɨlo kɨla, baakaanikanaga ɨsya Jesu. Bamo baatɨgɨ Jesu mundʉ nnunu, looli bamo baatɨgɨ Jesu mundʉ ʉjʉ ikʉbasyoba abandʉ. ");
INSERT INTO nyy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Po akaalipo ʉmundʉ ʉjʉ annjobaga Jesu pabwelu, kʉnongwa jaa kʉbatiila abalongosi baa Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bo amasikʉ agaa kyaka gafikile pakatɨ, Jesu alɨnkʉbʉʉka, alɨnkwingɨla ndʉpaso ʉlwa tempeli, alɨnkwanda ʉkʉbamanyisya abandʉ. ");
INSERT INTO nyy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Po abalongosi baa Bajuuta balɨnkʉswiga nʉ kwanda ʉkʉjobesania balɨnkʉtɨ, “Bʉle, ʉmundʉ ʉjʉ abagiile ʉkʉsimanya bʉleebʉle syosa ɨsi kɨsita kʉmanyilamo?” ");
INSERT INTO nyy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Po Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Ɨmanyisyo ɨsi ngʉmanyisya sikaja syangʉ, looli sifumile kʉlɨ ʉjʉ andʉmile kʉmyɨnu. ");
INSERT INTO nyy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ʉmundʉ gwesa ʉjʉ ikʉlonda ʉkʉbomba ɨsya bwigane bwa Kyala, ikʉsyagania ʉkʉtɨ ɨmanyisyo ɨsi sifumile kwa Kyala, nʉ kʉtɨ ndikʉjoba kʉ maka gangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ʉmundʉ gwesa ʉjʉ ikʉjoba kʉ maka gaake, ikwilondela ʉbʉsisya bwake mwene. Looli ʉjʉ ikʉlonda ʉbʉsisya ʉbwa jʉla antʉmile, ikʉjoba ɨsya nalooli, sikaja sya bʉtʉngʉlʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Jesu alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Mumeenye ʉkʉtɨ Moose aabapeele abiisʉkʉlʉ bɨɨnu ɨndagɨlo sya Kyala. Looli najʉmo ʉmundʉ pakatɨ pamyɨnu ʉjʉ ikʉsikonga ɨndagɨlo ɨsyo. Po fiki mukʉlonda ʉkʉʉngoga?” ");
INSERT INTO nyy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ɨkɨlʉndɨlo ɨkya bandʉ kɨlɨnkʉmmwamula kɨlɨnkʉtɨ, “Ʉgwe ʉlɨ nɨ mbepo ɨnyali! Bʉle, jo jwani ʉjʉ ikʉlonda ʉkʉkʉgoga?” ");
INSERT INTO nyy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Naabombile ɨkiika kɨmo pi isikʉ ɨlya pa Sabati, ʉmwe mwesa mwanyomwike. ");
INSERT INTO nyy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Keeta, Moose aabalagiile ʉmwe ʉkʉbabuuta kʉkyeni abaanɨɨnu abanyambala, na paapo abiisʉkʉlʉ baake bo aba baalyandiisye ʉlwiho ʉlʉ, bo akaalɨ ʉkwisa Moose. Ʉmwe mulɨ nʉ lwiho ʉlwa kʉbabuuta kʉkyeni abaanɨɨnu na pi isikʉ ɨlya pa Sabati. ");
INSERT INTO nyy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lɨnga mukwijʉʉla ʉkʉkonga ɨndagɨlo sya Moose, ʉkʉbabuuta kʉkyeni abaanɨɨnu abanyambala pi isikʉ ɨlya pa Sabati, po fiki mukʉngalalɨla ʉne, ʉkʉmmbʉmbʉlʉsya ʉmundʉ pi isikʉ ɨlya pa Sabati? ");
INSERT INTO nyy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mulɨnganndongaga ʉmundʉ kʉlɨ ɨsi sikʉboneka panja, looli munndongege ʉmundʉ ʉkʉkongana nɨ sya bwanalooli.” ");
INSERT INTO nyy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Po abandʉ bamo abaa mu Jelusalemu balɨnkwanda ʉkʉlaalʉʉsania balɨnkʉtɨ, “Bʉle, ʉmundʉ ʉjʉ akaja jo ʉjʉ abalongosi bikʉlonda ʉkʉnngoga? ");
INSERT INTO nyy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Keeta lɨɨlɨno ikʉjoba pabwelu, leelo abeene batikʉjoba nasimo! Bʉle, abalongosi babagiile ʉkwinogona ʉkʉtɨ ʉjo jo Meesija? ");
INSERT INTO nyy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Meesija bo ikwisa akajako ʉmundʉ ʉjʉ aikʉmanya kʉno afumile, leelo tʉmeenye kʉno afumile ʉmundʉ ʉjʉ!” ");
INSERT INTO nyy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesu bo ikʉmanyisya ndʉpaso lwa tempeli, alɨnkʉjoba pabwelu alɨnkʉtɨ, “Nalooli muumeenye ʉne, kangɨ mukʉmeenye kʉno mfumile. Ʉne ngiisa kʉ maka gangʉ! Looli Kyala ʉjʉ andʉmile jo gwa bwanalooli. Ʉmwe mukammanya. ");
INSERT INTO nyy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ʉne nʉmmeenye paapo mfumile kʉmyake, kangɨ jo ʉjʉ andʉmile kʉmyɨnu.” ");
INSERT INTO nyy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Po balɨnkʉlonda ʉkʉnkola, looli akaaliko ʉmundʉ ʉjʉ aabagiile ʉkʉnkola, paapo akabalɨlo kaake kakaalɨ ʉkʉfika. ");
INSERT INTO nyy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Leelo abandʉ bingi aba baalipo pala balɨnkʉmmwitɨka Jesu. Baajobaga baatɨgɨ, “Lɨnga Meesija ikwisa, bʉle, aikʉbomba ɨfiika fingi ʉkʉkɨnda ɨfi ʉmundʉ ʉjʉ abombile?” ");
INSERT INTO nyy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Po aBafalisai na bapuuti abalongosi bo bakɨpɨliike ɨkɨlʉndɨlo ɨkya bandʉ bikʉheeha ɨsyo, balɨnkʉbatʉma abasikali ʉkʉtɨ bankole Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Po Jesu alɨnkʉbabʉʉla abandʉ bala alɨnkʉtɨ, “Ngʉjaga na nuumwe kʉkabalɨlo akapimba itolo, bo ngaalɨ ʉkʉgomokelako kʉmyake ʉjʉ andʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mukʉʉndondaga, looli aamutikʉʉnyaaga, kangɨ mukabagɨla ʉkwisa kʉno ngʉjaga.” ");
INSERT INTO nyy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Po abandʉ abaa nkɨlʉndɨlo kɨla balɨnkʉjobesania balɨnkʉtɨ, “Bʉle, ʉmundʉ ʉjʉ ikʉbʉʉka kʉʉgʉ kʉno ʉswe tʉkabagɨla ʉkʉmmwaga? Bʉle, ikʉlonda ʉkʉbʉʉka kʉ Bajuuta aba babalaniile ntwaja ʉtʉheesya? Bʉle, ikwakʉbamanyisyaga abeene? ");
INSERT INTO nyy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Bʉle, ikʉlonda ʉkʉtʉbʉʉla ɨsya fiki kʉ masyʉ gaake aga ikʉtɨ, ‘Mukʉʉndondaga, looli aamutikʉʉnyaaga, kangɨ mukabagɨla ʉkwisa kʉno ngʉjaga’? ” ");
INSERT INTO nyy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Iisikʉ ɨlya kʉmmalɨɨkɨsyo ɨlya kyaka kya fitembe, lyalɨ isikʉ ikʉlʉmba. Po Jesu alɨnkwɨma ndʉpaso ʉlwa tempeli, alɨnkʉjoba pabwelu alɨnkʉtɨ, “Ʉmwe lɨnga mʉʉmiilwe amɨɨsi, mwisege kʉmyangʉ ʉne kʉkʉnwa. ");
INSERT INTO nyy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kalata ʉMwikemo ikʉbabʉʉla abandʉ ʉkʉtɨ ʉmundʉ gwesa ʉjʉ ikʉʉnyiitɨka ʉne, ikʉjaga nɨ nyiibʉko ɨsya mɨɨsi kʉ bwingi fiijo nkatɨ mmyake.” ");
INSERT INTO nyy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesu aajobaga ɨsya Mbepo Mwikemo, ʉjʉ abandʉ boosa aba bikʉmmwitɨka Jesu, bikwisa kʉmmwambɨlɨlaga. Akabalɨlo ako, Kyala aakaalɨ ʉkʉntʉma Mbepo gwake kʉmyabo, paapo Kyala aakaalɨ ʉkʉbʉnangɨsya pabwelu ʉbʉsisya bwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Abandʉ bamo abaa nkɨlʉndɨlo kɨla bo bapɨliike amasyʉ ago, balɨnkwanda ʉkʉjoba balɨnkʉtɨ, “Nalooli ʉmundʉ ʉjʉ, jo nkunguluka ʉjʉ tukʉnnguulɨla ʉkʉfuma kwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Abandʉ abangɨ balɨnkʉtɨ, “Ʉmundʉ ʉjʉ jo Meesija.” Looli bamo balɨnkʉtɨ, “Hɨmma, Meesija akabagɨla ʉkʉfuma nkiisʉ ɨkya Galilai. ");
INSERT INTO nyy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kalɨ, Kalata ʉMwikemo atikʉjoba ʉkʉtɨ Meesija aikʉfuma ndʉjungu ʉlwa malafyale Ndaabɨti? Kangɨ ʉkʉtɨ aikʉpaapigwa mu Betelehemu, nkaaja aka Ndaabɨti aapaapiigwe?” ");
INSERT INTO nyy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Po abandʉ balɨnkʉtapʉkana kʉnongwa jaa Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bamo baalondaga ʉkʉnkola, looli akaaliko ʉmundʉ ʉjʉ aalɨnkolilepo. ");
INSERT INTO nyy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kʉmmalɨɨkɨsyo abasikali balɨnkʉgomokelako kʉ bapuuti abalongosi na Bafalisai, kɨsita kʉnkola Jesu. Po balɨnkʉbalaalʉʉsya balɨnkʉtɨ, “Fiki mukankola Jesu nʉ kʉntwala kʉmyɨtʉ?” ");
INSERT INTO nyy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Abasikali bala balɨnkwamula balɨnkʉtɨ, “Akajako ʉmundʉ ʉjʉngɨ ʉjʉ abagiile ʉkʉjoba bo ɨsi ʉmundʉ jʉla ikʉjoba.” ");
INSERT INTO nyy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Balɨnkʉbalaalʉʉsya balɨnkʉtɨ, “Bʉle, Jesu abasyobile na nuumwe? ");
INSERT INTO nyy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bʉle, alipo ʉndongosi gwesa jʉla pamo ʉMfalisai jʉmo ʉjʉ ammwitiike? ");
INSERT INTO nyy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Looli ɨkɨlʉndɨlo ɨkya bandʉ aba bikʉmmwitɨka bakasimanya ɨndagɨlo sya Moose. Balɨ nɨ kɨgune.” ");
INSERT INTO nyy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Po Nikotemu, jʉmo mbalongosi baa Bafalisai, ʉjʉ aabʉʉkile iisikʉ lɨmo pakɨlo kwa Jesu, akabalɨlo akaa kʉnyuma, alɨnkʉbalaalʉʉsya abanine alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bʉle, ɨndagɨlo syɨtʉ sikʉtwitɨkɨsya ʉkʉnndonga ʉmundʉ bo tʉkampɨlɨkɨsya taasi nʉ kʉsyagania ɨsi ikʉsibomba?” ");
INSERT INTO nyy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Abeene balɨnkʉmmwamula Nikotemu balɨnkʉtɨ, “Bʉle, na nungwe ʉfumile mu Galilai? Bʉʉka ʉkabale kangɨ kanunu Kalata ʉMwikemo, po na nungwe kʉsyagania ʉkʉtɨ akajako ʉnkunguluka ʉjʉ abagiile ʉkʉfuma mu Galilai.”  ");
INSERT INTO nyy_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Po abandʉ boosa balɨnkʉbʉʉka ntwaja twabo. ");
INSERT INTO nyy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Looli Jesu alɨnkʉsookamo ndʉpaso ʉlwa tempeli, alɨnkʉbʉʉka pabʉjo ʉbʉ bikʉtɨ ɨKyamba kya Misyʉngʉtɨ. ");
INSERT INTO nyy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nʉlʉbʉnjʉ bo bʉkiile, alɨnkʉbʉʉka kangɨ alɨnkwingɨla ndʉpaso ʉlwa tempeli. Abandʉ boosa balɨnkʉbʉʉka kʉmyake, po alɨnkʉtʉʉgala nʉ kwanda ʉkʉbamanyisya. ");
INSERT INTO nyy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Abamanyisi baa ndagɨlo sya Moose na Bafalisai, balɨnkʉntwala kʉmyake ʉnkiikʉlʉ jʉmo ʉjʉ aakoliigwe mbʉlogwe, balɨnkʉmmbɨɨka pakatɨ pa kɨlʉndɨlo ɨkya bandʉ. ");
INSERT INTO nyy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Po balɨnkʉmmbʉʉla Jesu balɨnkʉtɨ, “Gwe Mmanyisi, ʉnkiikʉlʉ ʉjʉ akoliigwe bo alɨ pakʉlogwa. ");
INSERT INTO nyy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moose, ʉkʉkongana nɨ ndagɨlo syake, aatʉlagiile ʉkʉnngoga ʉnkiikʉlʉ ʉgwa lʉko ʉlʉ, kʉ njɨla ɨjaa kʉntuunya na mabwe. Po ʉgwe kʉtɨ fiki?” ");
INSERT INTO nyy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Abeene baalɨnndaalʉʉsiisye bo ʉlo ʉkʉnngela, ʉkʉtɨ bajaage ɨnjɨla ɨjaa kʉnsitaaka. Looli Jesu alɨnkwinama alɨnkʉsimba nʉ loobe lwake paasi pa mfu. ");
INSERT INTO nyy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bo bikwendelela ʉkʉnndaalʉʉsya, Jesu alɨnkwɨma alɨnkʉbaamula alɨnkʉtɨ, “Lɨnga alipo jʉmo pakatɨ pamyɨnu, ʉjʉ akabombamo sikʉ ʉbʉtʉlanongwa, jo aje gwa kwanda ʉkʉntuunya ni ibwe ʉnkiikʉlʉ ʉjʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Po Jesu alɨnkwinama kangɨ paasi, alɨnkʉsimba pa mfu. ");
INSERT INTO nyy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bo bapɨliike ɨsyo, balɨnkwanda ʉkʉsookapo jʉmoojʉmo, ʉkwandɨla abakangale mpaka abalʉmyana. Kʉmmalɨɨkɨsyo Jesu alɨnkʉsyala mwene nʉ nkiikʉlʉ jʉla, ʉjʉ aalyɨmile nkyeni mmyake. ");
INSERT INTO nyy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Po Jesu alɨnkwɨma, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Jʉʉba, balɨ kʉʉgʉ aba bikʉkʉsitaaka? Bʉle, akajapo najʉmo ʉjʉ asyele ʉkʉtɨ akʉlonge?” ");
INSERT INTO nyy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Alɨnkwamula alɨnkʉtɨ, “Gwe Ntwa, akajapo najʉmo.” Po Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Na niine ndikʉkʉlonga. Bʉʉkaga, looli ʉkwandɨla ʉmwisyʉgʉ, ʉlɨngatʉlaga kangɨ ɨnongwa.” ");
INSERT INTO nyy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Po Jesu alɨnkwendelela ʉkʉjoba kangɨ nɨ kɨlʉndɨlo kɨla alɨnkʉtɨ, “Ʉne ndɨ lʉmuli kʉ bandʉ abaa pakiisʉ. Ʉmundʉ gwesa ʉjʉ ikʉngonga ʉne, atikwisa kwendamo sikʉ mu ngiisi, looli ikʉjaga nʉ lʉmuli ʉlʉ aalukʉnndongosyaga mbʉʉmi bwa bwila na bwila.” ");
INSERT INTO nyy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ABafalisai balɨnkʉmmbʉʉla Jesu balɨnkʉtɨ, “Ʉgwe kwisisimɨkɨsya gwimwene, ɨsi kʉjoba sikaja sya kʉsʉʉbɨligwa.” ");
INSERT INTO nyy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Nalɨnga ngwisisimɨkɨsya jʉjʉʉne, ɨsi ngʉjoba sya nalooli, paapo mmeenye kʉno mfumile, kangɨ mmeenye kʉno ngʉbʉʉka. Looli ʉmwe mukamanya kʉno mfumile na kʉno ngʉbʉʉka. ");
INSERT INTO nyy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ʉmwe mukʉʉndonga ʉne ʉkʉkongana nʉ tʉndʉ ʉtʉ tukʉboneka, looli ʉne ndikʉnndonga najʉmo. ");
INSERT INTO nyy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Leelo lɨnga ʉne ngʉnndonga ʉmundʉ, ngʉnndonga kʉ bʉgolofu, paapo ndikʉja niimwene, looli ngʉja na Taata ʉjʉ andʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mu ndagɨlo syɨnu sisimbiigwe ʉkʉtɨ, ʉbʉkeeti ʉbwa bandʉ babɨlɨ, bukʉsʉʉbɨligwa ʉkʉja bwa nalooli. ");
INSERT INTO nyy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kʉ njɨla ɨjɨ ʉne ngwisisimɨkɨsya jʉjʉʉne, na Taata ʉjʉ andʉmile jo nkeeti gwangʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Po aBafalisai balɨnkʉnndaalʉʉsya Jesu balɨnkʉtɨ, “Bʉle, ʉGʉʉso alɨ kʉʉgʉ?” Jesu alɨnkʉbaamula alɨnkʉtɨ, “Mukaamanya ʉne, joope Taata mukammanya. Lɨnga mwalɨɨmeenye ʉne, po mwabagiile ʉkʉmmanya Taata.” ");
INSERT INTO nyy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu aajobile ɨsyo syosa bo alɨ pakʉmanyisya ndʉpaso lwa tempeli, pabʉjo ʉbʉ baabɨɨkangapo amabokosi agaa ndalama. Looli akaaliko ʉmundʉ ʉgwa kʉnkola, paapo akabalɨlo kaake kaakaalɨ ʉkʉfika. ");
INSERT INTO nyy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Po Jesu alɨnkʉbabʉʉla kangɨ aBafalisai bala alɨnkʉtɨ, “Ʉne nsumwike, ʉmwe aamukʉʉndondaga, looli aamukʉfwa kʉnongwa jaa bʉtʉlanongwa bwɨnu. Ʉmwe mukabagɨla ʉkwisa kʉno ngʉbʉʉka.” ");
INSERT INTO nyy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Po balɨnkwanda ʉkʉlaalʉʉsania balɨnkʉtɨ, “Fiki ikʉjoba ʉkʉtɨ tʉkabagɨla ʉkʉnkonga kʉno ikʉbʉʉka? Kalɨ, ikʉbʉʉka kʉkwigoga?” ");
INSERT INTO nyy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesu alɨnkwendelela ʉkʉbabʉʉla alɨnkʉtɨ, “Ʉmwe mufumile paasi apa, looli ʉne mfumile kʉmwanya. Ʉmwe mulɨ baa pakiisʉ apa, looli ʉne ngaja gwa pakiisʉ apa. ");
INSERT INTO nyy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jo nongwa ɨjɨ mbabʉʉlile ʉkʉtɨ aamukwisa kʉfwa kʉnongwa jaa bʉtʉlanongwa bwɨnu. Po lɨnga mutikʉʉnyiitɨka ʉne ʉkʉtɨ jo jʉʉjo, aamukwisa kʉfwa kʉnongwa jaa bʉtʉlanongwa bwɨnu.” ");
INSERT INTO nyy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Po balɨnkʉnndaalʉʉsya Jesu balɨnkʉtɨ, “Tʉbʉʉle ʉgwe gwe gwani?” Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ʉkʉfuma kʉbwandɨlo bo ngʉmanyisya, mbabʉʉlile ʉkʉtɨ ʉne ne ani. ");
INSERT INTO nyy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ndɨ nasyo nyingi ɨsi naabagiile ʉkʉbajoba nʉ kʉbalonga ʉmwe, looli ndikʉbomba bo ʉlo. Paapo ʉne ngʉbabʉʉla abandʉ boosa ɨnongwa syene sila, ɨsi nsipɨliike ʉkʉfuma kʉmyake Taata. Jo ʉjʉ aalɨndʉmile kangɨ ikʉjoba ʉbwanalooli.” ");
INSERT INTO nyy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Abeene bakaasyageenie ʉkʉtɨ aajobaga nabo ɨsya Taata ʉgwa kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Po Jesu alɨnkʉsisimɨkɨsya alɨnkʉtɨ, “Bo mumfyʉsiisye Nnyamundʉ ʉkʉtɨ munngoge, po aamukwisa kʉmanya ʉkʉtɨ ʉne jo jʉʉjo. Kangɨ aamukwisa kʉmanyaga ʉkʉtɨ syosa ɨsi ngʉbomba, ndikʉbomba kʉ maka gangʉ, looli ngʉsijoba ɨsi Taata aamanyiisye. ");
INSERT INTO nyy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ʉjʉ andʉmile alɨ pamopeene na niine. Akaandeka niimwene, paapo akabalɨlo koosa ngʉsibomba ɨsi sikʉnkyela.” ");
INSERT INTO nyy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesu bo alɨ pakʉjoba ɨsyo, abandʉ bingi balɨnkʉmmwitɨka. ");
INSERT INTO nyy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Po Jesu alɨnkʉbabʉʉla aBajuuta bala, aba bammwitiike, alɨnkʉtɨ, “Lɨnga mukʉgakonga amasyʉ gangʉ, po nalooli mukʉjaga bafundigwa bangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kangɨ aamukʉbʉmanyaga ʉbwanalooli. Po kʉ njɨla jaa bwanalooli ʉbo, Kyala ikwisa kʉbabɨɨka mbwabʉke.” ");
INSERT INTO nyy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Abeene balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Ʉswe tʉlɨ biisʉkʉlʉ baa Abulahamu. Tʉkabɨɨkigwamo sikʉ nʉ mundʉ ʉkʉja batʉmwa. Fiki kʉjoba ʉkʉtɨ ʉswe aatukʉja baabʉke?” ");
INSERT INTO nyy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, ʉmundʉ gwesa ʉjʉ ikwendelela ʉkʉbomba ʉbʉtʉlanongwa, ikʉbʉbombela ʉbʉtʉlanongwa bo ʉlwa ntʉmwa. ");
INSERT INTO nyy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ʉntʉmwa atikʉtʉʉgala mu nyumba jaa ntwa gwake amasikʉ goosa, looli ʉmwana gwa ntwa, jo ʉjʉ ikʉsyala mu nyumba amasikʉ goosa. ");
INSERT INTO nyy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Po lɨnga ne Mwana gwa Kyala mbaabwile ʉkʉfuma mbʉtʉlanongwa bwɨnu, mutikʉjaga batʉmwa kangɨ, looli mukʉjaga baabʉke nalooli. ");
INSERT INTO nyy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mmeenye ʉkʉtɨ ʉmwe mulɨ biisʉkʉlʉ baa Abulahamu, leelo mukʉlonda ʉkʉʉngoga ʉne, paapo mukʉkaana ʉkwitɨka ɨsi ngʉbamanyisya. ");
INSERT INTO nyy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ʉne ngʉbabʉʉla ɨsi nsibwene kwa Taata, looli ʉmwe mukʉsibomba ɨsi ʉgwiseemwe abamanyiisye.” ");
INSERT INTO nyy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Abeene balɨnkʉmmwamula Jesu balɨnkʉtɨ, “Ʉswe taata jo Abulahamu.” Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Lɨnga nalooli mulɨ baana baa Abulahamu, ngalɨ mukʉsibomba ɨsi Abulahamu aabombaga. ");
INSERT INTO nyy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Looli lɨɨlɨno mukʉlonda ɨnjɨla ɨjaa kʉʉngoga, na paapo mbabʉʉlile ʉbwanalooli ʉbʉ naabʉpɨliike ʉkʉfuma kwa Kyala. Abulahamu akaabombile bo ɨsi mukʉlonda ʉkʉʉmbombela ʉne. ");
INSERT INTO nyy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ɨmbombo ɨsi mukʉsibomba sikʉfuma kʉ gwiseemwe ʉjʉngɨ.” ABajuuta bala balɨnkʉmmwamula Jesu balɨnkʉtɨ, “Ʉswe tʉkaja sigwana, looli Kyala mwene jo Taata.” ");
INSERT INTO nyy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Lɨnga Kyala aalɨ Gwiseemwe, po ngalɨ muunganile. Ʉne ngiisa kʉ maka gangʉ, looli jo Kyala ʉjʉ andʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Fiki mutikʉsyagania ɨsi ngʉjoba? Paapo mukʉsikaana ɨnongwa syangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ʉmwe mulɨ baa Seetano ʉjʉ jo gwiseemwe, nuumwe mukʉlonda ʉkʉbomba ɨsi ʉgwiseemwe ikʉsilonda. Seetano ngogi bwila, kangɨ akiigana ʉkwɨma mbwanalooli, paapo ʉbwanalooli bʉkajamo mu ndumbula jaake. Lɨnga Seetano ikʉjoba ʉbʉtʉngʉlʉ ako ko kajɨɨlo kaake, paapo ʉmwene ntʉngʉlʉ kangɨ jo gwise gwa batʉngʉlʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Looli paapo ʉne ngʉbabʉʉla ɨsya nalooli, jo nongwa ɨjɨ mutikʉʉnyiitɨka. ");
INSERT INTO nyy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Jo jwani pakatɨ pamyɨnu ʉjʉ abagiile ʉkʉsisimɨkɨsya ʉkʉtɨ ʉne ndɨ ntʉlanongwa? Lɨnga ɨsi ngʉbabʉʉla sya bwanalooli, po fiki mutikʉʉnyiitɨka? ");
INSERT INTO nyy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Fyobeene ʉmwe mutikʉsikonga ɨsi Kyala ikʉjoba, paapo ʉmwe mukaja bandʉ baake.” ");
INSERT INTO nyy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ABajuuta balɨnkʉnndaalʉʉsya Jesu balɨnkʉtɨ, “Bʉle, tʉtikʉjoba ɨsya nalooli lɨnga tukʉtɨ ʉgwe ʉlɨ Nsamalija nʉ kʉtɨ ʉlɨ nɨ mbepo ɨnyali?” ");
INSERT INTO nyy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ʉne ngaja nɨ mbepo ɨnyali. Ʉne ngʉmmwɨmɨka Taata, looli ʉmwe mutikʉʉnyɨɨmɨka ʉne. ");
INSERT INTO nyy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ndikʉlonda ʉkʉtɨ ʉmwe mumbege ʉbʉsisya, looli alipo ʉjʉ ikʉlonda ʉkʉmbapo, kangɨ jo aikʉjaga Ndongi gwa nalooli. ");
INSERT INTO nyy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nalooli nikʉbabʉʉla, ʉmundʉ gwesa ʉjʉ ikʉsikonga ɨsi ngʉmanyisya, atiisakʉfwamo sikʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Po aBajuuta balɨnkʉmmbʉʉla Jesu balɨnkʉtɨ, “Akabalɨlo aka tʉsyageenie ʉkʉtɨ ʉgwe ʉlɨ nɨ mbepo ɨnyali! Abulahamu aafwile. Abakunguluka boope baafwile. Looli ʉgwe kʉtɨ, ‘Ʉmundʉ gwesa ʉjʉ ikʉsikonga ɨsi ngʉmanyisya, atiisakʉfwamo sikʉ.’ ");
INSERT INTO nyy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kalɨ ʉgwe, kwipela ʉkʉja nkʉlʉmba ʉkʉnkɨnda ʉmwisʉkʉlʉ gwɨtʉ Abulahamu? Ʉmwene aafwile. Abakunguluka boope baafwile. Kalɨ, ʉgwe kwipela ʉkʉja gwe gwani?” ");
INSERT INTO nyy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Lɨnga ngwipapo ʉbʉsisya, ʉbʉsisya bwangʉ bʉkaja na mbombo najɨmo. Looli Taata, ʉjʉ ʉmwe mukʉtɨ jo Kyala gwɨnu, jo ʉjʉ ikʉmbapo ʉbʉsisya ʉne. ");
INSERT INTO nyy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Na ʉlʉ mukaalɨ mukammanya Kyala, looli ʉne nʉmmeenye. Lɨnga ngʉjoba ʉkʉtɨ ngammanya Kyala, po bo ndɨ ntʉngʉlʉ bo ʉmwe. Looli ʉne nʉmmeenye Kyala, kangɨ ɨsi ikʉjoba ngʉsikonga. ");
INSERT INTO nyy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ʉmwisʉkʉlʉ gwɨnu Abulahamu aahobwike fiijo ʉkʉmanya ʉkʉtɨ ʉne ngwisa. Aafwene aalɨɨmbwene, aahobwike fiijo.” ");
INSERT INTO nyy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Po aBajuuta balɨnkʉkalala, balɨnkʉnndaalʉʉsya Jesu balɨnkʉtɨ, “Ʉgwe ʉkaalɨ ʉkʉfika ɨfyɨnja amalongo mahaano, po gwalɨmmbwene bʉleebʉle Abulahamu?” ");
INSERT INTO nyy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, ʉne ndiko bo Abulahamu akaalɨ ʉkʉpaapigwa.” ");
INSERT INTO nyy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ABajuuta bo basipɨliike ɨsyo, balɨnkʉsala amabwe ʉkʉtɨ bantuunye nago nʉ kʉnngoga, looli Jesu alɨnkwifisa, alɨnkʉsookamo ndʉpaso lwa tempeli. ");
INSERT INTO nyy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Po iisikʉ lɨmo bo Jesu ikwenda, alɨnkʉmmbona ʉmundʉ jʉmo ʉjʉ aapaapiigwe mfwa maaso. ");
INSERT INTO nyy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Abafundigwa baake balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Gwe Mmanyisi, ʉmundʉ ʉjʉ aapaapiigwe mfwa maaso kʉnongwa jaa bʉtʉlanongwa bwani? Bwa mundʉ ʉjʉ pamo bwa bapaapi baake?” ");
INSERT INTO nyy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ʉjʉ akaja mfwa maaso kʉnongwa jaa bʉtʉlanongwa bwake, pamo ʉbʉtʉlanongwa bwa bapaapi baake. Looli aapaapiigwe mfwa maaso, ʉkʉtɨ amaka agaa Kyala gaboneke kʉ bandʉ mbʉʉmi bwake. ");
INSERT INTO nyy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bo pakaalɨ po pamuusi, tukʉlondigwa ʉkʉbomba ɨmbombo ɨjaa Kyala ʉjʉ andʉmile. Ɨkɨlo kikwisa, apa tʉkabagɨla ʉkʉbomba ɨmbombo ɨsi. ");
INSERT INTO nyy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bo ngaalɨ ndipo pakiisʉ apa, ʉne ndɨ lʉmuli kʉ bandʉ boosa.” ");
INSERT INTO nyy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesu bo ajobile ɨsyo, alɨnkʉswa amata pa mfu, alɨnkʉfuga nʉ mfu, alɨnkʉmpaka amatope mmaaso ʉmfwa maaso jʉla. ");
INSERT INTO nyy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Po alɨnkʉmmbʉʉla ʉmfwa maaso jʉla alɨnkʉtɨ, “Bʉʉka ʉkasugusule kʉmaaso pa kɨsiba Siloamu” (Siloamu kokʉtɨ ʉjʉ atʉmiigwe). Po ʉmfwa maaso alɨnkʉbʉʉka, alɨnkwakʉsugusula kʉmaaso, alɨnkʉbʉmbʉlʉka, alɨnkʉgomoka kʉkaaja kaake. ");
INSERT INTO nyy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Po abapalamani baake na bangɨ aba bammbonaga kʉbwandɨlo bo ikʉsʉʉma sʉʉma, balɨnkʉlaalʉʉsania balɨnkʉtɨ, “Bʉle, ʉmundʉ ʉjʉ akaja jo jʉla aatʉʉgalaga nʉ kʉsʉʉma sʉʉma?” ");
INSERT INTO nyy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bamo balɨnkʉtɨ, “Ʉmundʉ ʉjʉ jo jʉʉjo.” Abangɨ balɨnkʉtɨ, “Ʉmundʉ ʉjʉ akaja jo jʉʉjo, looli afwene nagwe fiijo.” Looli ʉmwene alɨnkʉbabʉʉla alɨnkʉtɨ, “Moomuumo, jo ʉne.” ");
INSERT INTO nyy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Po balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Lɨnga nalooli jo ʉgwe, po amaaso gaako gandile ʉkʉkeeta bʉleebʉle?” ");
INSERT INTO nyy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ʉmwene alɨnkʉbaamula alɨnkʉtɨ, “Ʉmundʉ ʉjʉ ɨngamu jaake jo Jesu, aaswile amata pa mfu, aafugile nʉ mfu, aalɨmbakile mmaaso gangʉ, aalɨɨmbʉʉlile aatile, ‘Bʉʉka ʉkasugusule kʉmaaso pa kɨsiba Siloamu.’ Po ndɨnkʉbʉʉka, ndɨnkʉsugusula, ndɨnkwanda ʉkʉkeeta.” ");
INSERT INTO nyy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Po balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, ʉmundʉ ʉjo alɨ kʉʉgʉ?” Ʉmwene alɨnkʉbaamula alɨnkʉtɨ, “Ʉne ngamanya kʉno aliko.” ");
INSERT INTO nyy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Po abandʉ bala balɨnkʉntwala kʉ Bafalisai ʉmundʉ ʉjʉ aalɨ mfwa maaso kʉbwandɨlo. ");
INSERT INTO nyy_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Iisikʉ ɨlɨ Jesu aafugile ʉmfu nʉ kʉmmbʉmbʉlʉsya ʉmfwa maaso jʉla, lyalɨ isikʉ ɨlya pa Sabati. ");
INSERT INTO nyy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Po aBafalisai boope balɨnkʉnndaalʉʉsya ʉmundʉ jʉla balɨnkʉtɨ, “Bʉle, gwandile ʉkʉkeeta bʉleebʉle?” Alɨnkʉbaamula alɨnkʉtɨ, “Ʉmundʉ jʉmo aalɨmbakile amatope mmaaso, naasuguswile, ngʉkeeta.” ");
INSERT INTO nyy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Po aBafalisai bamo balɨnkʉtɨ, “Ʉmundʉ ʉjʉ abombile bo ʉlʉ akabagɨla ʉkʉfuma kwa Kyala, paapo ikʉbomba ɨsi sikaanisiigwe ʉkʉbomba pi isikʉ ɨlya pa Sabati.” Looli bamo balɨnkʉtɨ, “Bʉle, sibagiile bʉleebʉle kʉ mundʉ ʉntʉlanongwa ʉkʉbomba ɨfiika ɨfyo?” Po balɨnkʉtapʉkana baabo kwa baabo. ");
INSERT INTO nyy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Po aBafalisai balɨnkʉnndaalʉʉsya kangɨ balɨnkʉtɨ, “Kʉjoba ɨsya fiki kʉ mundʉ ʉjʉ akʉbʉmbʉlwisye amaaso gaako?” Ʉmwene alɨnkʉbaamula alɨnkʉtɨ, “Ʉne ngwaga ʉmundʉ ʉjo nkunguluka gwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Looli bakaaliitiike ʉkʉtɨ ʉmundʉ ʉjʉ kʉbwandɨlo aapaapiigwe mfwa maaso, ikʉkeeta. Po balɨnkʉbakoolela abapaapi baake. ");
INSERT INTO nyy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Balɨnkʉbalaalʉʉsya balɨnkʉtɨ, “Bʉle, ʉmundʉ ʉjʉ mwanɨɨnu? Lɨnga bo silɨ, bʉle, mukʉsisimɨkɨsya ʉkʉtɨ aapaapiigwe mfwa maaso? Lɨnga bo silɨ, po andile ʉkʉkeeta bʉleebʉle?” ");
INSERT INTO nyy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Po abapaapi baake balɨnkʉbaamula balɨnkʉtɨ, “Ʉswe tʉmeenye ʉkʉtɨ ʉjʉ mwanɨɨtʉ nalooli, kangɨ tukʉsisimɨkɨsya ʉkʉtɨ aapaapiigwe mfwa maaso. ");
INSERT INTO nyy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Looli tʉkamanya muno andiile ʉkʉkeeta, kangɨ tʉkammanya nʉ mundʉ ʉjʉ ammbʉmbʉlwisye amaaso gaake. Namunndaalʉʉsye ʉmwene, paapo mundʉ nkʉsi, abagiile ʉkʉjoba jʉʉjo.” ");
INSERT INTO nyy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Abapaapi baake baajobile bo ʉlo paapo baabatiilaga abalongosi bala, paapo abalongosi baaliitɨkeene ʉkʉtɨ ʉmundʉ gwesa ʉjʉ ikwitɨka ʉkʉtɨ Jesu jo Meesija, bikʉnkaga mu sinagogi syabo. ");
INSERT INTO nyy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jo nongwa ɨjɨ abapaapi baatile, “Namunndaalʉʉsye ʉmwene, paapo mundʉ nkʉsi, abagiile ʉkʉjoba jʉʉjo.” ");
INSERT INTO nyy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Po abalongosi baa Bajuuta balɨnkʉnkoolela kangɨ ʉlwa bʉbɨlɨ, ʉmundʉ ʉjʉ aalɨ mfwa maaso kʉbwandɨlo, balɨnkʉmmbʉʉla balɨnkʉtɨ, “Ʉlape kwa Kyala ʉkʉtɨ kʉjoba sya nalooli! Ʉswe tʉmeenye ʉkʉtɨ ʉmundʉ ʉjo, ʉjʉ akʉbʉmbʉlwisye, ntʉlanongwa.” ");
INSERT INTO nyy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Po alɨnkʉbaamula alɨnkʉtɨ, “Ʉne ngamanya ʉkʉtɨ ʉmundʉ ʉjo ntʉlanongwa, leelo ndɨmeenye lɨmolyene itolo, ʉkʉtɨ naalɨ mfwa maaso, looli akabalɨlo aka ngʉkeeta.” ");
INSERT INTO nyy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Po balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, ʉmundʉ ʉjo aabombile ɨfiki? Akʉbʉmbʉlwisye amaaso gaako bʉleebʉle?” ");
INSERT INTO nyy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ʉmwene alɨnkʉbaamula alɨnkʉtɨ, “Ʉne mbabʉʉlile ɨnongwa ɨsyo, looli mukaapɨlɨkiisye. Po fiki mukʉlonda mbabʉʉle kangɨ? Kalɨ, na nuumwe mukʉlonda ʉkʉja bafundigwa baake?” ");
INSERT INTO nyy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Po abeene balɨnkʉntʉka balɨnkʉtɨ, “Jʉjʉʉgwe ʉlɨ mfundigwa gwake! Looli ʉswe tʉlɨ bafundigwa baa Moose. ");
INSERT INTO nyy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tʉmeenye ʉkʉtɨ Kyala aajobile na Moose, looli ʉmundʉ ʉjo tʉkamanya na kʉno afumile.” ");
INSERT INTO nyy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Alɨnkʉbaamula alɨnkʉtɨ, “Ʉne ngʉswiga fiijo! Ʉmwe mukammanya kʉno afumile, leelo ʉmwene aambʉmbʉlwisye amaaso gangʉ! ");
INSERT INTO nyy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tʉmeenye ʉkʉtɨ Kyala atikʉpɨlɨka ɨnyiipuuto ɨsya batʉlanongwa, looli ikʉmpɨlɨka ʉmundʉ gwesa ʉjʉ ikʉmmwɨmɨka nʉ kʉbomba ɨsya bwigane bwake. ");
INSERT INTO nyy_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ʉkʉfuma lʉʉlo Kyala aakɨpelile ɨkiisʉ, tʉkapɨlɨkamo sikʉ ʉkʉtɨ ʉmundʉ ammbʉmbʉlwisye ʉjʉ aapaapiigwe mfwa maaso. ");
INSERT INTO nyy_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Lɨnga ʉmundʉ ʉjo akaafumile kwa Kyala, po akaabagiile ʉkʉbomba ɨsyo.” ");
INSERT INTO nyy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Abeene balɨnkʉmmwamula balɨnkʉtɨ, “Ʉgwe gwapaapiigwe nʉ kʉswɨligwa bo ʉntʉlanongwa. Bʉle, ʉlɨ nʉ bʉlagɨli bʉki ʉbwa kʉtʉmanyisya ʉswe?” Po balɨnkʉnkaga apa baalipo. ");
INSERT INTO nyy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesu bo apɨliike ʉkʉtɨ bankagile ʉmundʉ ʉjo, alɨnkʉbʉʉka kʉkʉnndonda. Bo ammwagile, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Bʉle, kʉmmwitɨka Nnyamundʉ?” ");
INSERT INTO nyy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ʉmundʉ jʉla alɨnkwamula alɨnkʉtɨ, “Gwe Ntwa, Nnyamundʉ jo jwani ʉkʉtɨ nʉmmwitɨkege?” ");
INSERT INTO nyy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉgwe gʉmmbwene, kangɨ jo ʉjʉ ikʉjoba na nungwe.” ");
INSERT INTO nyy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ʉmundʉ jʉla alɨnkʉtɨ, “Gwe Ntwa, nikʉkwitɨka.” Po alɨnkʉfugama nkyeni mwa Jesu nʉ kʉmmwipuuta. ");
INSERT INTO nyy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Po Jesu alɨnkʉtɨ, “Ʉne naaliisile pakiisʉ apa kʉkʉlonga, ʉkʉtɨ abafwa maaso bakeetege, kangɨ aba bikʉkeeta, baje bafwa maaso.” ");
INSERT INTO nyy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Po aBafalisai bamo aba baalipo pala, bo bapɨliike ɨnongwa ɨsyo, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, kʉtɨ ʉswe tʉlɨ bafwa maaso?” ");
INSERT INTO nyy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Lɨnga mwalɨ bafwa maaso ngalɨ mukaja batʉlanongwa. Looli akabalɨlo aka mukaalɨ mulɨ nʉ bʉtʉlanongwa, paapo mukʉtɨ mukʉkeeta.” ");
INSERT INTO nyy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesu alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, ʉmundʉ gwesa ʉjʉ atikwingɨla pa kɨfigo ɨkya kɨbaga kya ngʼoosi, looli ikwingɨlɨla pabʉngɨ, ʉjo nhɨɨji kangɨ inyambuta. ");
INSERT INTO nyy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Looli ʉjʉ ikwingɨlɨla pa kɨfigo ɨkya kɨbaga, ʉjo jo ntiimi gwa ngʼoosi. ");
INSERT INTO nyy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ʉndɨndɨlɨli ʉgwa kɨbaga ikʉmmwigʉlɨla ʉlwigi ʉntiimi ʉjo ʉgwa ngʼoosi. Syope sibagiile ʉkʉpɨlɨka iisyʉ lyake. Ʉntiimi ikʉjɨkoolela kʉkʉtɨ ngʼoosi ɨngamu jaake nʉ kʉsilongosya ʉkʉsooka panja. ");
INSERT INTO nyy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lɨnga asisoosiisye panja ɨngʼoosi syake syosa, ikʉtalapo nkyeni, syope sikʉnkonga paapo silɨmeenye iisyʉ lyake. ");
INSERT INTO nyy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ɨngʼoosi sikabagɨla ʉkʉnkonga ʉnheesya, looli sikʉmmbopa paapo sikalɨmanya iisyʉ lyake.” ");
INSERT INTO nyy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu aababʉʉlile aBafalisai ɨkɨfwanikɨsyo ɨkɨ, looli abeene bakaasyageenie ɨsi aababʉʉlaga. ");
INSERT INTO nyy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Po Jesu kangɨ alɨnkʉbabʉʉla alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, ʉne ndɨ bo ɨkɨfigo ɨkyo, ɨkɨ ɨngʼoosi sikwingɨlɨla nkɨbaga. ");
INSERT INTO nyy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Boosa aba baalɨndaliilepo ʉkʉja batiimi baa ngʼoosi, baalɨ bahɨɨji kangɨ minyambuta, looli ɨngʼoosi sikaabapɨlɨkɨsyaga. ");
INSERT INTO nyy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ʉne ndɨ bo ɨkɨfigo ɨkyo. Gwesa ʉjʉ ikwingɨlɨla nkɨbaga ʉkwendela kʉmyangʉ aikʉpokigwa, kangɨ ikʉja mwabʉke ʉkwingɨla nʉ kʉsooka, ʉkʉbʉʉka pa liisʉ inunu. ");
INSERT INTO nyy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ʉnhɨɨji ikwisa nkɨbaga kʉ nyango jeene ɨjaa kʉhɨɨja ɨngʼoosi, ʉkʉsigoga nʉ koonanga. Looli ʉne niisile ʉkʉtɨ bajege nʉ bʉʉmi, kangɨ bajege nabo kʉ bwingi. ");
INSERT INTO nyy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ʉne ndɨ Ntiimi ʉNnunu. ɄNtiimi ʉNnunu, ikʉbʉninga ʉbʉʉmi bwake, ʉkʉtɨ ɨngʼoosi syake silɨngasoba. ");
INSERT INTO nyy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ʉmbombi ʉjʉ akaja ntiimi gwa ngʼoosi, kangɨ ɨngʼoosi sikaja syake, lɨnga akɨbwene ɨkɨnyamaana kikwisa, ikʉbopa nʉ kʉsileka ɨngʼoosi syene. Po ɨkɨnyamaana kikʉkola ɨngʼoosi simo, nɨ singi sikʉbalanila. ");
INSERT INTO nyy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ʉmbombi ikʉbopa paapo mundʉ gwa kʉhombigwa, kangɨ atikʉsipaasya ɨngʼoosi. ");
INSERT INTO nyy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ʉne ndɨ Ntiimi ʉNnunu. Nsimeenye kanunu ɨngʼoosi syangʉ, syope siimeenye, ");
INSERT INTO nyy_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","bo ʉlʉ Taata aameenye ʉne, na niine nʉmmeenye. Niine ngʉbʉninga ʉbʉʉmi bwangʉ, ʉkʉtɨ ɨngʼoosi syangʉ silɨngasoba. ");
INSERT INTO nyy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ʉne ndɨ nɨ ngʼoosi ɨsingi ɨsi sikajamo nkɨbaga ɨkɨ, syope ngʉlondigwa ʉkʉsilongosya. Ɨngʼoosi ɨsyo syope aasikʉlɨmanya iisyʉ lyangʉ. Kʉ njɨla ɨjo, aagukʉja ntiimo gʉmogwene, nʉ Ntiimi jʉmojwene. ");
INSERT INTO nyy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Taata aanganile, paapo ngʉbʉninga ʉbʉʉmi bwangʉ, ʉkʉtɨ mbʉkabe kangɨ. ");
INSERT INTO nyy_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Akajako ʉmundʉ ʉjʉ abagiile ʉkʉbʉnyaka ʉbʉʉmi bwangʉ. Ʉne jo ʉne ngʉsala ʉkʉbʉninga ʉbʉʉmi bwangʉ. Ʉne ndɨ na maka agaa kʉbʉninga ʉbʉʉmi bwangʉ, kangɨ ndɨ na maka agaa kʉja mʉʉmi kangɨ. Jo Taata jʉʉjo ʉjʉ aandagiile ʉkʉbomba bo ʉlo.” ");
INSERT INTO nyy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bo bapɨliike ɨnongwa ɨsyo, aBajuuta balɨnkʉlegana mbʉjobi. ");
INSERT INTO nyy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bingi balɨnkʉjoba balɨnkʉtɨ, “Ʉjʉ alɨ nɨ mbepo ɨnyali, ɨjɨ jɨmpelile ʉkʉja gwa kɨgɨlɨ. Mmasyʉ gaake tukʉkabamo ɨfiki?” ");
INSERT INTO nyy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Looli bamo balɨnkʉkaanika balɨnkʉtɨ, “Amasyʉ ago gatikʉfuma mmundʉ ʉjʉ alɨ nɨ mbepo ɨnyali. Bʉle, ɨmbepo ɨnyali jɨbagiile ʉkʉmpela ʉmfwa maaso ʉkʉkeeta?” ");
INSERT INTO nyy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Po akabalɨlo akaa kyaka kya Bajuuta, ɨkya kʉkʉmbʉka ʉkwigʉla ɨtempeli, kalɨnkʉfika kʉla kʉ Jelusalemu. Akabalɨlo ako kaalɨ kaa mmapepo. ");
INSERT INTO nyy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesu aasyʉngʉʉtɨlaga ndʉpaso lwa tempeli, mwi ibalaasa ɨlɨ ɨngamu jaake baatɨgɨ, iBalaasa lya Solomoni. ");
INSERT INTO nyy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ABajuuta bamo balɨnkʉnsyʉngʉʉtɨla balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, kʉtʉtaamyaga mu ndumbula syɨtʉ mpaka ndɨli? Lɨnga ʉgwe gwe Meesija, tʉbʉʉle pabwelu.” ");
INSERT INTO nyy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Looli Jesu alɨnkʉbaamula alɨnkʉtɨ, “Ʉne mbabʉʉlile ʉkʉtɨ ne ani, looli ʉmwe mukʉkaana ʉkʉʉnyiitɨka. Ɨfiika ɨfi ngʉbomba kʉ maka agaa Taata fyo ɨfi fikʉʉsisimɨkɨsya ʉkʉtɨ ʉne ne ani. ");
INSERT INTO nyy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","“Looli mukʉkaana ʉkʉʉnyiitɨka paapo mukaja baa nkɨbugutɨla ɨkya ngʼoosi syangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ɨngʼoosi syangʉ sikʉlɨpɨlɨka iisyʉ lyangʉ. Ʉne nsimeenye kanunu, syope sikʉngonga. ");
INSERT INTO nyy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ʉne ngʉbapa ʉbʉʉmi bwa bwila na bwila, batikwisa kʉsobamo sikʉ. Kangɨ akajako ʉmundʉ ʉgwa kʉbanyaka kʉ maka ʉkʉfuma mmaboko gangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taata ʉjʉ ambeele abo nkʉlʉmba ʉkʉkɨnda boosa. Po akajako ʉmundʉ ʉjʉ abagiile ʉkʉbanyaka mmaboko gaake. ");
INSERT INTO nyy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ʉne na Taata tʉlɨ kandʉ kamokeene.” ");
INSERT INTO nyy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Po aBajuuta bamo bo bapɨliike ɨsyo, balɨnkwanda ʉkʉsala amabwe kangɨ, ʉkʉtɨ bantuunye nʉ kʉnngoga Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Looli Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mbanangiisye ɨmbombo sii nyingi ɨnunu, ɨsi mbombile kʉ maka agaa Taata. Ɨmbombo jɨlɨkʉ ɨjɨ jikʉbapela ʉmwe ʉkʉnduunya na mabwe?” ");
INSERT INTO nyy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ABajuuta balɨnkwamula balɨnkʉtɨ, “Tʉtikʉlonda ʉkʉkʉtuunya na mabwe kʉnongwa jaa kʉbomba ɨnunu, looli paapo kʉntʉka Kyala. Paapo ʉgwe kwijoba ʉkʉtɨ gwe Kyala, bo ʉlɨ mundʉ itolo ʉlwa abandʉ abangɨ!” ");
INSERT INTO nyy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Bʉle, sikasimbigwa mwa baakalata bɨɨnu abaa ndagɨlo ʉkʉtɨ Kyala aatile, ‘Ʉmwe mwe baakyala’? ");
INSERT INTO nyy_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ abandʉ aba baalyambɨliile ɨndʉmi jaa Kyala, Kyala aabajobaga ʉkʉtɨ mwe baakyala. Na nuuswe tʉmeenye ʉkʉtɨ ɨsi sisimbiigwe mwa Kalata ʉMwikemo sya nalooli amasikʉ goosa. ");
INSERT INTO nyy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kalɨ, fiki mukʉtɨ ʉne ngʉntʉka Kyala, apa ngʉtɨ, ‘Ʉne ndɨ Mwana gwa Kyala’? Taata jo ʉjʉ aasʉngwile nʉ kʉndʉma pakiisʉ. ");
INSERT INTO nyy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Lɨnga ndikʉbomba ɨmbombo ɨsya Taata ɨsi ikʉsibomba, po mulɨngaanyiitɨkaga. ");
INSERT INTO nyy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Looli lɨnga ngʉbomba ɨmbombo ɨsi Taata ikʉsibomba, nalɨnga mutikwitɨka ɨsi ngʉjoba, po namusiitɨkege ɨmbombo ɨsyo. Kʉ njɨla ɨjo, po aamukʉmanya ʉkʉtɨ Taata alɨ mmyangʉ, na niine ndɨ mwa Taata.” ");
INSERT INTO nyy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Po aBajuuta bamo bo bapɨliike ɨsyo, balɨnkʉlonda ʉkʉnkola kangɨ, looli Jesu alɨnkʉpulumunyuka mmaboko gaabo. ");
INSERT INTO nyy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Po Jesu alɨnkʉbʉʉka kangɨ kwi isɨɨlya ɨlya lwɨsi Jolitani, alɨnkʉfika apa Johani oosyaga abandʉ kʉbwandɨlo, alɨnkʉtʉʉgala ʉko amasikʉ manandɨ. ");
INSERT INTO nyy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jesu bo alɨ kʉlakʉla, abandʉ bingi balɨnkʉmmwisɨla nʉ kʉjoba nagwe balɨnkʉtɨ, “Johani akaabombile ɨkiika nakɨmo, looli ɨnongwa syosa ɨsya Jesu ɨsi aajobaga syalɨ sya nalooli.” ");
INSERT INTO nyy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Po abandʉ bingi aba baalipo pala balɨnkʉmmwitɨka Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Aaliko ʉmundʉ jʉmo ɨngamu jaake Laasalo. Ʉjo aalɨ mbine. Aatʉʉgalaga nkaaja akaa mu Betanija pamopeene na balʉmbʉ baake, Malija na Maalita. ");
INSERT INTO nyy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Malija ʉjo aalɨ ilʉmbʉ gwa Laasalo, jo ʉjʉ aalɨmpakile ʉNtwa amafuta agaa lʉʉma ʉlʉnunu nʉ kʉmpyasɨɨla mmalʉndɨ nɨ nywili syake. ");
INSERT INTO nyy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Po Malija na Maalita balɨnkʉtʉma ɨndʉmi kwa Jesu balɨnkʉtɨ, “Gwe Ntwa, tukʉkʉbʉʉla ʉkʉtɨ ʉmmanyaani gwako Laasalo mbine.” ");
INSERT INTO nyy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesu bo apɨliike ɨnongwa ɨsyo alɨnkʉtɨ, “Ʉbʉbine ʉbo bʉkaja bwa kʉnngoga, looli bwa kʉnangɨsya ʉbʉsisya bwa Kyala, ʉkʉtɨ abandʉ baanyɨɨmɨkege ne Mwanaake ʉkwendela mbʉbine ʉbo.” ");
INSERT INTO nyy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesu aabaganile fiijo Maalita na baamyabo Malija na Laasalo. ");
INSERT INTO nyy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Looli Jesu bo apɨliike ʉkʉtɨ Laasalo mbine, alɨnkongelapo ʉkʉtʉʉgala pabʉjo ʉbo amasikʉ mabɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Po bo gakɨndile amasikʉ mabɨlɨ, Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Tʉbʉʉke kangɨ mu Jutai.” ");
INSERT INTO nyy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Abafundigwa baake balɨnkʉmmwamula balɨnkʉtɨ, “Gwe Mmanyisi, akabalɨlo kakaaka itolo aBajuuta bamo baalondaga ʉkʉkʉtuunya na mabwe ʉkʉtɨ ʉfwe. Po fiki kʉlonda ʉkʉbʉʉka kangɨ ʉko?” ");
INSERT INTO nyy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesu alɨnkwamula alɨnkʉtɨ, “Bʉle, pamuusi pakaja nɨ sala kalongo na ibɨlɨ? Lɨnga ʉmundʉ ikwenda pamuusi, akabagɨla ʉkwitika ɨkɨlʉndɨ kyake paapo ʉlʉmuli lukʉmmulɨkɨla fyosa. ");
INSERT INTO nyy_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Looli ʉjʉ ikwenda pakɨlo, ikwitika paapo ʉlʉmuli ʉlwa kʉntʉʉla lʉkajapo.” ");
INSERT INTO nyy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesu bo ajobile ɨsyo, alɨnkwendelela ʉkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Ʉmmanyaani gwɨtʉ Laasalo agonile ʉtʉlo, looli ngʉbʉʉka kʉkʉnndembʉsya.” ");
INSERT INTO nyy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Po abafundigwa baake balɨnkʉmmwamula balɨnkʉtɨ, “Gwe Ntwa, lɨnga agonile ʉtʉlo, ikʉpona.” ");
INSERT INTO nyy_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesu apa aajobaga ʉkʉtɨ Laasalo afwile, looli abafundigwa baake biinogonaga ʉkʉtɨ ikʉjoba ʉkʉtɨ agonile ʉtʉlo. ");
INSERT INTO nyy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Po Jesu alɨnkʉbabʉʉla pabwelu alɨnkʉtɨ, “Laasalo afwile. ");
INSERT INTO nyy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Looli ʉne nhobwike ʉkʉtɨ ngaalipo bo Laasalo ikʉfwa, ʉkʉtɨ ʉmwe mukɨndɨlɨlepo ʉkʉʉnyiitɨka. Po mwisege tʉbʉʉke kʉmyake.” ");
INSERT INTO nyy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Po ʉmfundigwa jʉmo ɨngamu jaake Tomasi ʉjʉ bantɨgɨ Mbasa, alɨnkʉbabʉʉla abafundigwa abanine alɨnkʉtɨ, “Na nuuswe tʉbʉʉke, ʉkʉtɨ tʉkafwe pamopeene nagwe.” ");
INSERT INTO nyy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Po Jesu bo afikile nkiisʉ ɨkya mu Jutai nkaaja akaa mu Betanija, alɨnkwaga Laasalo amalile amasikʉ mana mwi ipʉmba. ");
INSERT INTO nyy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Akaaja kaa mu Betanija mpaka mu Jelusalemu kilomita itatʉ bʉno. ");
INSERT INTO nyy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Abandʉ bingi ʉkʉfuma mu Jutai baaliisile mu Betanija kʉkʉbakeeta Maalita na Malija, kʉnongwa jaa bʉfwe ʉbwa ilʉmbʉ gwabo Laasalo. ");
INSERT INTO nyy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Po Maalita alɨnkʉpɨlɨka ʉkʉtɨ Jesu alɨ mu njɨla, alɨnkʉsooka panja nʉ kʉbʉʉka kʉkʉmmwambɨlɨla, looli Malija alɨnkʉsyala nnyumba. ");
INSERT INTO nyy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maalita alɨnkʉmmbʉʉla Jesu alɨnkʉtɨ, “Gwe Ntwa, lɨnga gwalipo apa, iilʉmbʉ gwangʉ ngalɨ akafwa. ");
INSERT INTO nyy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Looli na ʉlʉ mmeenye ʉkʉtɨ kokoosa aka kʉnsʉʉma Kyala ikʉkʉpa.” ");
INSERT INTO nyy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Po Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉliilʉmbʉgo ikʉsyʉka nʉ kʉja mʉʉmi kangɨ.” ");
INSERT INTO nyy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maalita alɨnkʉtɨ, “Gwe Ntwa, mmeenye ʉkʉtɨ Kyala bo ikʉbasyʉsya abandʉ boosa pi isikʉ lya bʉlongi, joope ikwisa kʉsyʉka nʉ kʉja mʉʉmi kangɨ.” ");
INSERT INTO nyy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉne jo ʉne ngʉsyʉsya, kangɨ ne bʉʉmi. Ʉmundʉ gwesa ʉjʉ ikʉʉnyiitɨka ʉne, nalɨnga ikʉfwa aikʉjaga mʉʉmi. ");
INSERT INTO nyy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Joope ʉjʉ mʉʉmi, kangɨ ikʉʉnyiitɨka ʉne atiisakʉfwamo sikʉ. Bʉle, kwitɨka ɨsyo?” ");
INSERT INTO nyy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maalita alɨnkwamula alɨnkʉtɨ, “Nalooli Ntwa, niitiike ʉkʉtɨ ʉgwe gwe Meesija, ʉMwana gwa Kyala, jo ʉgwe Kyala akʉtʉmile pakiisʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maalita bo ajobile ɨsyo, alɨnkʉbʉʉka kʉkʉmmbɨlɨkɨla ʉnnuguna Malija. Po alɨnkʉmmbʉʉla kʉmbalɨ alɨnkʉtɨ, “ɄMmanyisi alipo apa, ikʉkʉbɨlɨkɨla.” ");
INSERT INTO nyy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Malija bo apɨliike ɨsyo, alɨnkʉsumuka mbɨmbɨbɨ alɨnkʉbʉʉka kwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesu aakaalɨ ʉkwingɨla nkaaja ako, looli aalɨ pabʉjo ʉbʉ Maalita aabʉʉkile kʉkʉmmwambɨlɨla. ");
INSERT INTO nyy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Abandʉ bala aba baabʉʉkile kʉkʉnkeeta Malija, baalɨmmbwene ikʉsumuka nʉ kʉsooka panja. Po balɨnkʉnkonga, paapo biinogonaga ʉkʉtɨ Malija ikʉbʉʉka kwi ipʉmba ʉkʉtɨ ko akalɨlɨlege. ");
INSERT INTO nyy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Malija bo afikile apa aalipo Jesu, alɨnkʉmmbona, alɨnkʉfugama nkyeni mwa Jesu, po alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwe Ntwa, lɨnga gwalipo apa, iilʉmbʉ gwangʉ ngalɨ akafwa.” ");
INSERT INTO nyy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesu bo ammbwene Malija ikʉlɨla, na bandʉ aba iisile nabo boope bikʉlɨla, alɨnkʉkalala fiijo nʉ kʉsulumania mu ndumbula jaake. ");
INSERT INTO nyy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Po alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Mummbɨɨkile kʉʉgʉ?” Balɨnkʉmmwamula balɨnkʉtɨ, “Gwe Ntwa, tʉbʉʉke tʉkakʉnangɨsye.” ");
INSERT INTO nyy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesu alɨnkʉlɨla. ");
INSERT INTO nyy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Po abandʉ aba baaliisile kʉʉfwa balɨnkʉtɨ, “Keeta muno aalɨnnganiile Laasalo!” ");
INSERT INTO nyy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Looli bamo balɨnkʉtɨ, “Ʉmundʉ ʉjʉ jo ʉjʉ aalɨmmbʉmbʉlwisye ʉmfwa maaso. Po fiki akabomba nasimo kwa Laasalo, ʉkʉtɨ alɨngafwa?” ");
INSERT INTO nyy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesu bo akaalɨ akaleele mu ndumbula jaake, alɨnkʉfika pi ipʉmba. Iipʉmba ɨlyo jaalɨ mbako ɨjɨ baajɨkupɨkiile ni ibwe iinywamu pa kɨfigo. ");
INSERT INTO nyy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesu alɨnkʉbabʉʉla abandʉ aba baalipo pala alɨnkʉtɨ, “Namulɨsoosyepo iibwe ɨlyo pa kɨfigo.” Po Maalita ʉjʉ aalɨ ilʉmbʉ ʉgwa ʉjʉ afwile alɨnkwamula alɨnkʉtɨ, “Gwe Ntwa, ʉlʉ andile ʉkʉnunga, paapo gakɨndile amasikʉ mana bo alɨ mwi ipʉmba.” ");
INSERT INTO nyy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Po Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Bʉle, ngakʉbʉʉla ʉkʉtɨ lɨnga kwitɨka, kʉbʉbona ʉbʉsisya ʉbwa Kyala muno bʉjɨɨliile?” ");
INSERT INTO nyy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Po balɨnkʉlɨsoosyapo iibwe lɨla. Jesu alɨnkʉkeeta kʉmwanya, alɨnkwipuuta kwa Kyala alɨnkʉtɨ, “Gwe Taata, nikʉgwa ʉlʉpi kʉmyako paapo kʉpɨlɨka ɨnyiipuuto syangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mmeenye ʉkʉtɨ kʉmbɨlɨka akabalɨlo koosa, looli ngʉjoba ɨsi kʉnongwa jaa kɨlʉndɨlo kya bandʉ aba, ʉkʉtɨ biitɨke ʉkʉtɨ jo ʉgwe ʉndʉmile.” ");
INSERT INTO nyy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jesu bo ajobile ɨsyo alɨnkʉlaata ʉkʉkoolela alɨnkʉtɨ, “Laasalo, sooka panja!” ");
INSERT INTO nyy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Po ʉjʉ aafwile alɨnkʉsooka panja. Amalʉndɨ na maboko gaake ganiembeteeleliigwe nʉ mwenda ʉgwa kʉsyɨlɨla. Kangɨ aalɨ nɨ kɨtambala ɨkɨ baalɨmpinyile kʉmaaso. Po Jesu alɨnkʉbabʉʉla abandʉ bala alɨnkʉtɨ, “Namummwabʉle ɨmyenda ɨgyo, munndeke abʉʉkege.” ");
INSERT INTO nyy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Po aBajuuta bingi aba baaliisile kʉkʉnkeeta ɨɨfwa Malija, bo basibwene ɨsi Jesu asibombile, balɨnkʉmmwitɨka. ");
INSERT INTO nyy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Leelo aBajuuta bamo balɨnkʉbʉʉka kʉ Bafalisai nʉ kʉbabʉʉla ɨsi Jesu abombile. ");
INSERT INTO nyy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Po abapuuti abalongosi na Bafalisai balɨnkʉkoolela ʉlʉkomaano lwa Sanihendilini, balɨnkʉlaalʉʉsania balɨnkʉtɨ, “Tʉbombe ɨfiki? Paapo ʉmundʉ ʉjʉ ikʉbomba ɨfiika fingi. ");
INSERT INTO nyy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Lɨnga tukʉnndeka ʉkʉtɨ abombege itolo ɨfiika ɨfyo, abandʉ boosa aabikʉmmwitɨka. ABalooma aabikwisa, bikwisa kʉkyonanga ɨkiisʉ kyɨtʉ nɨ tempeli.” ");
INSERT INTO nyy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Po jʉmo mbakʉlʉmba bala ɨngamu jaake Kajafa, ʉjʉ aalɨ mpuuti ʉnkʉlʉmba nkabalɨlo ako, alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉmwe mukasimanya nasimo!” ");
INSERT INTO nyy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bʉle, mukamanya ʉkʉtɨ kanunu kʉmyɨnu ʉkʉtɨ ʉmundʉ jʉmo abafwɨle abandʉ boosa, ʉkʉkɨnda ɨkiisʉ kyosa ʉkʉpyutigwa? ");
INSERT INTO nyy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kajafa akaajobile ɨsyo kʉ bwigane bwake jʉʉjo. Looli paapo aalɨ mpuuti ʉnkʉlʉmba nkabalɨlo ako, aakungulukaga ʉkʉtɨ Jesu aikʉkɨfwɨla ɨkɨkolo kya Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kangɨ Jesu atikʉkɨfwɨla ɨkɨkolo ɨkyo kyene, looli ʉkʉtɨ ababʉngaanie abaana baa Kyala aba baabalaniile, baje pamopeene. ");
INSERT INTO nyy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ʉkʉfuma iisikʉ ɨlyo, abalongosi baa Bajuuta balɨnkwanda ʉkʉlonda ɨnjɨla ɨjaa kʉnngoga Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kʉnongwa ɨjo, Jesu alɨnkʉleka ʉkwenda pabwelu mu Jutai. Looli alɨnkʉsookamo nʉ kʉbʉʉka kɨfuki na ndʉngalangala, mu Efulaimu, alɨnkʉtʉʉgala kʉlakʉla pamopeene na bafundigwa baake. ");
INSERT INTO nyy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ɨkyaka kya Bajuuta ɨkya Pasa kyalɨ kɨfuki. Po abandʉ bingi balɨnkʉsookamo ʉkʉfuma ntwaja twabo, ʉkʉbʉʉka mu Jelusalemu ʉkʉtɨ bakiijeelʉsye. ");
INSERT INTO nyy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Po balɨnkwendelela ʉkʉnndonda Jesu, balɨnkʉlaalʉʉsania bo babʉngeene pamopeene ndʉpaso lwa tempeli, balɨnkʉtɨ, “Ʉmwe mukwinogona ɨsya fiki? Bʉle, ʉmundʉ ʉjo ikwisa pa kyaka ɨkɨ pamo atikwisa?” ");
INSERT INTO nyy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Abapuuti abalongosi na Bafalisai baalagiile ʉkʉtɨ, ʉmundʉ gwesa ʉjʉ ameenye kʉno aliko Jesu, abʉʉke kʉkʉbabʉʉla ʉkʉtɨ bankole. ");
INSERT INTO nyy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bo gasyele amasikʉ ntandatʉ ʉkʉfika pa kyaka kya Pasa, Jesu alɨnkʉbʉʉka kangɨ kʉ Betanija, nkaaja aka aalɨnsyʉsiisye Laasalo ʉkʉfuma mbafwe. ");
INSERT INTO nyy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Po abandʉ abaa pabʉjo bʉla balɨnkʉmpɨɨjɨla ɨfindʉ ɨfya namajolo. Maalita alɨnkʉmmbombela. Laasalo aalɨ jʉmo mbaheesya aba baatʉʉgeele pa meesa pamopeene na Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Po Malija alɨnkwega ɨsupa jaa mafuta agaa ntengo ʉnnywamu, agaa lʉʉma ʉlʉnunu, alɨnkʉmpaka Jesu mmalʉndɨ, alɨnkʉmpyasɨɨla nɨ nywili syake. Ɨnyumba joosa jɨlɨnkwisʉla ʉlʉʉma ʉlwa mafuta. ");
INSERT INTO nyy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Looli jʉmo mbafundigwa baake ɨngamu jaake Juuta Isikalyoti, ʉjʉ aalondaga ʉkʉnndɨɨla Jesu, alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Fiki amafuta ago gatikʉʉlɨsigwa ɨndenali ɨmia itatʉ nʉ kʉpeeligwa abalondo?” ");
INSERT INTO nyy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Juuta akaajobile bo ʉlo kʉnongwa jaa kʉbapaakɨsya abalondo, looli paapo aalɨ nhɨɨji. Ʉmwene jo ʉjʉ aajaga nɨ kɨnyambɨ ɨkya ndalama. Aahɨɨjaga ɨndalama ɨsi aajaga nasyo nʉ kʉsibombela mwene. ");
INSERT INTO nyy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Po Jesu alɨnkʉmmwamula Juuta alɨnkʉtɨ, “Mulɨngantaamyaga ʉnkiikʉlʉ ʉjʉ, munndeke, abɨɨkile amafuta gaa pi isikʉ ɨlɨ aabikʉʉsyɨla. ");
INSERT INTO nyy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Abalondo mulɨ nabo amasikʉ goosa. Looli ʉne ndikʉja pakʉja pamopeene na nuumwe bwila.” ");
INSERT INTO nyy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Po abandʉ bingi balɨnkʉpɨlɨka ʉkʉtɨ Jesu alipo pabʉjo bʉla, balɨnkʉbʉʉka komma kʉkʉnkeeta ʉmwene itolo, looli koope nʉ kʉnkeeta Laasalo, ʉjʉ Jesu aalɨnsyʉsiisye ʉkʉfuma mbafwe. ");
INSERT INTO nyy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Po abapuuti abalongosi balɨnkʉlonda ɨnjɨla ɨjaa kʉnngoga joope Laasalo, ");
INSERT INTO nyy_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","paapo kʉnongwa jaa kʉsyʉka Laasalo, aBajuuta bingi baabasambʉkiile abalongosi baabo, balɨnkʉmmwitɨka Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kɨlaabo kyake, ɨkɨlʉndɨlo ɨkɨnywamu ɨkya bandʉ aba baaliisile kʉkʉsekela ɨkyaka kya Pasa, baapɨliike ʉkʉtɨ Jesu alɨ mu njɨla ikwisa mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Po balɨnkwega ɨsamba ɨsya tʉgɨndwa, balɨnkʉbʉʉka kʉkʉmmwambɨlɨla Jesu. Balɨnkʉlaata balɨnkʉtɨ, “Hosyana! Asajigwege ʉjʉ ikwisɨla mu ngamu jaa Ntwa Kyala! Asajigwege ʉMalafyale gwa Banyaisilaɨli.” ");
INSERT INTO nyy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Po Jesu alɨnkʉjaaga ɨmwana jaa mbunda, alɨnkwitoga bo muno sisimbiigwe mwa Kalata ʉMwikemo ʉkʉnnjoba ʉmwene ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mwe bandʉ baa mu Syoni, mulɨngatiilaga! Namukeete, ʉMalafyale gwɨnu ikwisa, iitogile ɨmwana jaa mbunda.” ");
INSERT INTO nyy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Akabalɨlo ako, abafundigwa baa Jesu bakaasyageenie ɨsyo. Leelo bo Jesu asyʉkile, po balɨnkʉkʉmbʉka ʉkʉtɨ ɨsyo syasimbiigwe ʉkʉnnjoba ʉmwene, na muno baalɨmmbombiile. ");
INSERT INTO nyy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Abandʉ aba baalɨ na Jesu bo ikʉmmbɨlɨkɨla Laasalo ʉkʉfuma mwi ipʉmba nʉ kʉnsyʉsya ʉkʉfuma mbafwe, baasifumwisye ɨnongwa ɨsyo. ");
INSERT INTO nyy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Po abandʉ bingi baapɨliike ɨnongwa ɨsya kiika ɨkɨ aabombile, jo nongwa ɨjɨ baafumile kʉ Jelusalemu ʉkʉbʉʉka kʉkʉmmwambɨlɨla Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Looli aBafalisai balɨnkʉlaalʉʉsania balɨnkʉtɨ, “Mukʉkeeta? Tʉkabagɨla ʉkʉbomba nakamo! Keeta, abandʉ boosa bikʉnkonga ʉmwene.” ");
INSERT INTO nyy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Abandʉ aba baabʉʉkile kʉ Jelusalemu, kʉkʉmmwipuuta Kyala pa kyaka kya Pasa, bamo bakaalɨ Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Po abandʉ abo balɨnkʉbʉʉka kwa Filipo ʉjʉ aafumile mu Betisaita nkiisʉ ɨkya Galilai, balɨnkʉnsʉʉma balɨnkʉtɨ, “Mwɨmɨkigwa, tukʉsʉʉma tʉjobepo na Jesu.” ");
INSERT INTO nyy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo alɨnkʉbʉʉka kʉkʉmmbʉʉla Andeleja ɨnongwa ɨsyo, po Filipo na Andeleja balɨnkʉbʉʉka kwa Jesu kʉkʉmmbʉʉla. ");
INSERT INTO nyy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesu alɨnkʉbaamula alɨnkʉtɨ, “Akabalɨlo kafikile akaa bʉsisya ʉbwa Nnyamundʉ ʉkʉboneka pabwelu. ");
INSERT INTO nyy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nalooli nikʉbabʉʉla, lɨnga ʉlʉseke lʉkasyɨligwa mu mfu bo ʉlwa mundʉ ʉjʉ afwile, lʉkabagɨla ʉkʉmela, looli lɨnga lʉsyɨliigwe, lukʉmela nʉ kʉpa ɨseke ɨnyingi. ");
INSERT INTO nyy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ʉmundʉ gwesa ʉjʉ ikʉlonda ʉkʉbʉponesya ʉbʉʉmi bwake, ikʉbʉpeesyaga ʉbʉʉmi bwa bwila na bwila, looli ʉmundʉ gwesa ʉjʉ atikʉbʉpaasya ʉbʉʉmi bwake pakiisʉ apa, ʉjo ikʉbʉponesya ʉbʉʉmi bwake, ʉkʉtɨ bʉjege bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ʉmundʉ gwesa ʉjʉ ikʉʉmbombela ʉne, fikʉtɨ angongege. Kangɨ popoosa pala apa ndipo, po apa ʉmbombeli gwangʉ ikʉjapo. Taata ikʉmmwɨmɨkaga ʉmundʉ gwesa ʉjʉ ikʉʉmbombela ʉne. ");
INSERT INTO nyy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Lɨɨlɨno nandile ʉkʉsulumania fiijo mu ndumbula jangʉ. Kalɨ njobe bʉleebʉle? Kalɨ ndɨgɨ, ‘Gwe Taata, ngʉkʉsʉʉma gʉmboke nkabalɨlo akaa ngʉbɨlo aka?’ Hɨmma, ngabagɨla ʉkʉsʉʉma bo ʉlo paapo niisile kʉkʉtaamigwa pakiisʉ apa. ");
INSERT INTO nyy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Gwe Taata Kyala, ʉbʉsetʉle ʉbʉsisya ʉbwa ngamu jaako.” Po Kyala alɨnkʉjoba ʉkʉfuma kʉmwanya alɨnkʉtɨ, “Gwe Mwanangʉ, nsetwile, kangɨ ngwendelelaga ʉkʉbʉsetʉla.” ");
INSERT INTO nyy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Po ɨkɨlʉndɨlo ɨkya bandʉ aba baalipo pala bo bapɨliike iisyʉ ʉkʉfuma kʉmwanya, bamo balɨnkʉtɨ, “Ɨnjasi jikʉtajanika,” abangɨ balɨnkʉtɨ, “Gwandʉmi gwa Kyala aajobaga nagwe.” ");
INSERT INTO nyy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Looli Jesu alɨnkʉbabʉʉla abandʉ bala alɨnkʉtɨ, “Iisyʉ ɨlɨ mwalɨpɨlɨkaga lɨkaalɨ lya kʉndʉʉla ʉne, looli lyalɨ lya kʉbatʉʉla ʉmwe. ");
INSERT INTO nyy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lɨɨlɨno kafikile akabalɨlo akaa Kyala ʉkʉbalonga abandʉ abaa pakiisʉ apa. Lɨɨlɨno kafikile akabalɨlo akaa Kyala akaa kʉnkaga Seetano, ʉjʉ jo ndagɨli gwa pakiisʉ apa. ");
INSERT INTO nyy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ʉne bo mfyʉsiigwe, nikwisa kʉbakwaba boosa ʉkʉtɨ biise kʉmyangʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesu aajobile bo ʉlo, ʉkʉnangɨsya muno aikʉfwɨla. ");
INSERT INTO nyy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Po ɨkɨlʉndɨlo ɨkya bandʉ balɨnkʉmmwamula Jesu balɨnkʉtɨ, “Tʉbalile mwa Kalata ʉMwikemo ʉkʉtɨ, Meesija aikʉjaga mʉʉmi bwila na bwila. Po fiki kʉtɨ abandʉ aabikʉmfyʉsya Nnyamundʉ? Bʉle, Nnyamundʉ jo jwani?” ");
INSERT INTO nyy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉlʉmuli lukʉja pamopeene na nuumwe kʉkabalɨlo akapimba itolo. Mwendelelege ʉkwenda ndʉmuli ʉlʉ bo lʉlipo, ʉkʉtɨ ɨngiisi jɨlɨngiisa kʉbatola, paapo ʉmundʉ ʉjʉ ikwenda mu ngiisi akakʉmanya kʉno ikʉbʉʉka. ");
INSERT INTO nyy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mubɨɨkege ʉlʉsʉʉbɨlo lwɨnu ndʉmuli ʉlo ʉkʉtɨ mujege baana baa lʉmuli.” Jesu bo ajobile ɨsyo, alɨnkʉkɨleka ɨkɨlʉndɨlo kɨla, alɨnkwakwibɨɨlɨla. ");
INSERT INTO nyy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Na paapo Jesu aabombile ɨfiika fingi nkyeni mmyabo, poope abandʉ bingi bakaalɨmmwitiike. ");
INSERT INTO nyy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Syalɨ bo ʉlo ʉkʉtɨ gaboneke amasyʉ aga ʉnkunguluka Jeesaja aajobile ʉkʉtɨ, “Gwe Ntwa, jo jwani iitiike ɨndʉmi jɨɨtʉ? Kangɨ, ʉNtwa ansetʉliile jwani amaka gaake?” ");
INSERT INTO nyy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bakaalɨmmwitiike paapo Kyala aajobile ʉkwendela kwa Jeesaja ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Agogile amaaso gaabo, nʉ kʉsipela ʉbʉkafu ɨndumbula syabo, ʉkʉtɨ balɨngakeetaga, balɨngasyaganiaga mu ndumbula, ʉkʉtɨ balɨngapɨndʉka, po naababʉmbʉlʉsyaga.” ");
INSERT INTO nyy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jeesaja aajobile ɨsyo paapo aabʉbwene ʉbʉsisya bwa Jesu nʉ kʉjoba ɨnongwa syake. ");
INSERT INTO nyy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Poope, abalongosi bingi abaa Bajuuta baalɨmmwitiike Jesu, looli bakaajobaga pabwelu ʉkʉtɨ bammwitiike, kʉnongwa jaa kʉbatiila aBafalisai ʉkʉbakaga mu sinagogi. ");
INSERT INTO nyy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Abalongosi abo baaliiganile fiijo ʉkwɨmɨkigwa na bandʉ, ʉkʉkɨndapo ʉkwɨmɨkigwa na Kyala. ");
INSERT INTO nyy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Po Jesu alɨnkʉjoba pabwelu alɨnkʉtɨ, “Ʉmundʉ ʉjʉ ikʉʉnyiitɨka ʉne, atikʉʉnyiitɨka ʉne niimwene, looli ikʉmmwitɨka na ʉjʉ andʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ʉmundʉ gwesa ʉjʉ aambwene ʉne, ammbwene na ʉjʉ andʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ʉne niisile pakiisʉ apa bo ʉlwa lʉmuli, ʉkʉtɨ kʉkʉtɨ mundʉ ʉjʉ ikʉʉnyiitɨka aleke ʉkʉja mu ngiisi. ");
INSERT INTO nyy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ʉmundʉ gwesa ʉjʉ ikʉpɨlɨkɨsya amasyʉ gangʉ, looli atikʉgakonga, ʉne ndikwisa kʉnndonga, paapo ngaaliisile pakiisʉ apa kʉkʉbalonga abandʉ, looli naaliisile kʉkʉbapoka. ");
INSERT INTO nyy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bʉbʉʉbo ʉmundʉ gwesa ʉjʉ ikʉngaana ʉne pamopeene na masyʉ gangʉ ikwisa kʉlongigwa. Amasyʉ aga njobile go aga gikwisa kʉnndonga pi isikʉ ɨlya kʉmmalɨɨkɨsyo. ");
INSERT INTO nyy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Namanga ngajoba kʉ bʉlagɨli bwangʉ jʉjʉʉne, looli Taata ʉjʉ andʉmile, jo ʉjʉ aandagiile ɨsya kʉjoba, na muno ngʉsijobelaga. ");
INSERT INTO nyy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kangɨ mmeenye ʉkʉtɨ ʉlʉlagɨlo lwake lukʉbapa abandʉ ʉbʉʉmi bwa bwila na bwila. Po ʉne ngʉjoba syene ɨsi Taata aandagiile ʉkʉsijoba.” ");
INSERT INTO nyy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Po ɨkyaka kya Pasa bo kɨkaalɨ ʉkʉfika, Jesu alɨnkʉsyagania ʉkʉtɨ akabalɨlo kaake kafikile, akaa kʉsookapo pakiisʉ apa ʉkʉbʉʉka kʉ Gwise. Akabalɨlo koosa bo alɨ pakiisʉ apa, aabaganile abandʉ baake, kangɨ aabaganile mpaka kʉmmalɨɨkɨsyo. ");
INSERT INTO nyy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesu na bafundigwa baake balɨnkʉtʉʉgala pakʉlya ɨfindʉ ɨfya namajolo. Akabalɨlo ako Seetano aalimo mu ndumbula jaa Juuta ʉmwana gwa Simoni Isikalyoti, ʉkʉtɨ anndɨɨle Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesu aameenye ʉkʉtɨ Taata aalɨmpeele ʉbʉlagɨli ʉbwa kʉtʉlongosya ʉtʉndʉ toosa, kangɨ ʉkʉtɨ aafumile kwa Kyala, nʉ kʉtɨ aikʉbʉʉka kangɨ kwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Po Jesu alɨnkʉleka ʉkʉlya, alɨnkwɨma alɨnkʉbɨɨka iigolole lyake pambalɨ, alɨnkwega iitaabʉlo alɨnkwipinya mu nsana. ");
INSERT INTO nyy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Alɨnkʉkʉʉsya amɨɨsi mwi ibeeseni. Po alɨnkwanda ʉkʉbasugususya amalʉndɨ abafundigwa baake nʉ kʉbapyasɨɨla nɨ taabʉlo ɨlɨ aaliipinyile. ");
INSERT INTO nyy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jesu bo afikile apa aalipo Simoni Peeteli, Peeteli alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Gwe Ntwa bʉle, kʉlonda ʉkʉʉsugususya amalʉndɨ gangʉ?” ");
INSERT INTO nyy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉgwe ʉkasimanya ɨsi ngʉbomba akabalɨlo aka, looli aakʉsimanya piitaasi.” ");
INSERT INTO nyy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peeteli alɨnkʉmmwamula alɨnkʉtɨ, “Ʉkabagɨla sikʉ ʉkʉʉsugususya amalʉndɨ gangʉ!” Po Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Lɨnga ngakʉsugususya ʉgwe, ʉkabagɨla ʉkʉja pamopeene na niine kangɨ.” ");
INSERT INTO nyy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Po Peeteli alɨnkʉmmwamula alɨnkʉtɨ, “Gwe Ntwa, lɨnga silɨ bo ʉlo, ʉlɨngaasugususya geene amalʉndɨ, looli na maboko gangʉ pamopeene nʉ ntʉ gwangʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉmundʉ ʉjʉ oogile, atikʉlondigwa ʉkooga kangɨ, looli ʉkʉsugusula amalʉndɨ geene. Ʉjo mwelu loosa. Ʉmwe mulɨ beelu, looli jʉmo pakatɨ pamyɨnu akaja mwelu.” ");
INSERT INTO nyy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesu aalɨmmeenye ʉjʉ aikʉnndɨɨla, jo nongwa ɨjɨ aajobile ʉkʉtɨ, “Jʉmo pakatɨ pamyɨnu akaja mwelu.” ");
INSERT INTO nyy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesu bo amalile ʉkʉbasugususya amalʉndɨ abafundigwa baake, alɨnkwega iigolole lyake, alɨnkʉtʉʉgala kangɨ apa baalyaga ɨfindʉ, alɨnkʉbabʉʉla alɨnkʉtɨ, “Bʉle, musyageenie ɨsi mbabombiile ʉmwe? ");
INSERT INTO nyy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ʉmwe mukʉʉnjoba ʉne mukʉtɨ, ‘Mmanyisi,’ kangɨ mukʉtɨ, ‘Ntwa.’ Mukʉjoba sya nalooli, paapo ʉne ndɨ Mmanyisi, kangɨ ndɨ Ntwa. ");
INSERT INTO nyy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ʉne ne Mmanyisi, kangɨ ne Ntwa, mbasuguswisye amalʉndɨ. Bʉbʉʉbo na nuumwe musugusaniege amalʉndɨ. ");
INSERT INTO nyy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mbanangiisye ɨkɨfwanikɨsyo ʉkʉtɨ na nuumwe mubombelanilege bo muno ʉne mbabombiile ʉmwe. ");
INSERT INTO nyy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nalooli nikʉbabʉʉla, ʉntʉmwa akaja nkʉlʉmba ʉkʉnkɨnda ʉntwa gwake, kangɨ ʉjʉ ikʉtʉmigwa akaja nkʉlʉmba ʉkʉnkɨnda ʉjʉ ikʉntʉma. ");
INSERT INTO nyy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lɨnga musyaganie ɨsyo, po Kyala ikʉbasajaga lɨnga mukʉkonga ɨkɨfwanikɨsyo ɨkɨ. ");
INSERT INTO nyy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ndikʉjoba ɨsi kʉlɨ ʉmwe mwesa. Mbameenye ʉkʉfuma kʉbwandɨlo abandʉ aba mbasalile ʉkʉja bafundigwa bangʉ. Looli njobile ɨsi ʉkʉtɨ sibonekelemo ɨsi sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ʉmmanyaani gwangʉ ʉjʉ aalyaga ɨfindʉ pamopeene na niine, asanwike ʉkʉja ndʉgʉ gwangʉ.’ ");
INSERT INTO nyy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nikʉbabʉʉla syosa ɨsi akabalɨlo aka, bo ɨnongwa ɨsyo sikaalɨ ʉkʉboneka, ʉkʉtɨ bo siboniike, mukwitɨkaga ʉkʉtɨ ʉne jo jʉla. ");
INSERT INTO nyy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nalooli nikʉbabʉʉla, ʉmundʉ gwesa ʉjʉ ikʉmmwambɨlɨla ʉjʉ nʉntʉmile, ikʉʉnyambɨlɨla jo ʉne. Bʉbʉʉbo ʉjʉ ikʉʉnyambɨlɨla ʉne, ikʉmmwambɨlɨla ʉjʉ andʉmile.” ");
INSERT INTO nyy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesu bo ajobile ɨsyo, aasulumeenie fiijo mu ndumbula jaake, alɨnkʉjoba pabwelu alɨnkʉtɨ, “Nalooli nikʉbabʉʉla, jʉmo nkɨbugutɨla kyɨnu, ikʉʉndɨɨla.” ");
INSERT INTO nyy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Po abafundigwa baake balɨnkwanda ʉkʉkeetana, paapo bakaameenye ʉkʉtɨ ikʉnnjoba jo jwani. ");
INSERT INTO nyy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Aalipo ʉmfundigwa jʉmo ʉjʉ Jesu aalɨnnganile fiijo. Ʉmwene aatʉʉgeele kɨfuki na Jesu bo alɨ pakʉlya. ");
INSERT INTO nyy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Po Simoni Peeteli alɨnkʉnkoopa ʉmfundigwa ʉjo, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gʉnndaalʉʉsye Jesu, ikʉnnjoba jwani?” ");
INSERT INTO nyy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Po ʉmfundigwa jʉla alɨnkʉmmwegamila Jesu, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Gwe Ntwa, jo jwani aikʉkʉlɨɨla?” ");
INSERT INTO nyy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesu alɨnkwamula alɨnkʉtɨ, “Jo ʉjʉ ngʉja pakʉmpa akameenya akaa kɨsyesye bo ndobiile mu mposi.” Po alɨnkwega akameenya akaa kɨsyesye, alɨnkʉtobela mu mposi, alɨnkʉmpa Juuta, ʉmwana gwa Simoni Isikalyoti. ");
INSERT INTO nyy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Juuta bo ambɨliile akameenya kala akaa kɨsyesye, nakalɨnga Seetano alɨnkʉmmwingɨla. Po Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ɨsi kʉlonda ʉkʉbomba, bombaga mbɨbɨmbɨbɨ!” ");
INSERT INTO nyy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Looli abandʉ boosa aba baalyaga, bakaasyageenie ʉkʉtɨ fiki Jesu ajobile bo ʉlo. ");
INSERT INTO nyy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kʉnongwa jaa kʉtɨ Juuta jo ʉjʉ aakolaga ɨkɨnyambɨ ɨkya ndalama, bamo biinogonaga ʉkʉtɨ Jesu ammbʉʉlile ʉkʉtɨ akʉʉle ɨfi fikʉlondigwa pa kyaka, pamo abape abalondo ɨndalama simo. ");
INSERT INTO nyy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Po Juuta bo ambɨliile akameenya kala, nakalɨnga alɨnkʉsooka panja. Kaalɨ kabalɨlo kaa pakɨlo. ");
INSERT INTO nyy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Po Juuta bo asookile panja, Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Lɨɨlɨno ʉbʉsisya bwangʉ ne Nnyamundʉ bukʉja pakʉboneka pabwelu. Kangɨ aabukʉboneka pabwelu ʉbʉsisya bwa Kyala ʉkwendela mu mbombo syangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Lɨnga bukʉboneka ʉbʉsisya bwake ʉkwendela mu mbombo syangʉ, po joope Kyala ikʉbanangɨsya abandʉ ʉbʉsisya bwangʉ ne Nnyamundʉ, kangɨ ikʉbomba bo ʉlo lʉlʉʉlʉ. ");
INSERT INTO nyy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mwe baanangʉ, ngʉjaga na nuumwe kʉkabalɨlo akapimba itolo. Bo ʉlʉ naababʉʉlile abalongosi baa Bajuuta, bʉbʉʉbo nikʉbabʉʉla na nuumwe lɨɨlɨno ʉkʉtɨ, mukʉʉndondaga looli mukabagɨla ʉkwisa kʉno ngʉbʉʉka. ");
INSERT INTO nyy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Looli lɨɨlɨno ngʉbapa ʉlʉlagɨlo ʉlʉpya, ngʉbalagɨla ʉkʉtɨ, ‘Mugananege. Bo ʉlʉ ʉne mbaganile ʉmwe, bʉbʉʉbo nuumwe mugananege.’ ");
INSERT INTO nyy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Lɨnga mukʉganana, po abandʉ boosa aabikʉmanyaga ʉkʉtɨ ʉmwe mulɨ bafundigwa bangʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Po Peeteli alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Gwe Ntwa, kʉbʉʉka kʉʉgʉ?” Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ngʉbʉʉka kʉno ʉgwe ʉkabagɨla ʉkʉngonga akabalɨlo aka, looli aakʉngonga piitaasi.” ");
INSERT INTO nyy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peeteli alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Gwe Ntwa, bʉle, paapo fiki ngabagɨla ʉkʉkʉkonga akabalɨlo aka? Ʉne ngʉfwaga kʉnongwa jaako!” ");
INSERT INTO nyy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Peeteli, bʉle ʉbagiile ʉkʉfwa kʉnongwa jangʉ? Nalooli nikʉkʉbʉʉla, bo ɨngongobe jɨkaalɨ ʉkʉkoolela, kʉngaana katatʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesu alɨnkwendelela ʉkʉbamanyisya alɨnkʉtɨ, “Mulɨngalalamukaga mu ndumbula syɨnu, mummwitɨkege Kyala, kangɨ muunyiitɨkege na niine. ");
INSERT INTO nyy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ʉbʉjo bʉlimo bwingi mu nyumba jaa Taata. Lɨnga sikaalɨ bo ʉlo, ngalɨ mbabʉʉlile. Lɨɨlɨno nsumwike kʉkʉbatendekekesya ʉbʉjo. ");
INSERT INTO nyy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Bo mbʉʉkile nʉ kʉbatendekekesya ʉbʉjo, angwisa kangɨ kʉkʉbeega, ʉkʉtɨ ʉbʉjo ʉbʉ ngʉjangapo, na nuumwe mukʉjaga palapala pamopeene na niine. ");
INSERT INTO nyy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ʉmwe mujɨmeenye ɨnjɨla ɨjɨ jikʉbalongosya kʉbʉjo kʉno ngʉbʉʉka.” ");
INSERT INTO nyy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Po Tomasi alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Gwe Ntwa, ʉswe tʉkakʉmanya kʉno kʉbʉʉka. Bʉle, po tʉbagiile ʉkʉjɨmanya ɨnjɨla bʉleebʉle?” ");
INSERT INTO nyy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesu alɨnkwamula alɨnkʉtɨ, “Ʉne ne njɨla, ne bwanalooli, kangɨ ne bʉʉmi. Akajako ʉmundʉ gwesa ʉjʉ abagiile ʉkwisa kwa Taata lɨnga akendela kʉmyangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Lɨnga mwalɨɨmeenye, po ngalɨ mummeenye joope Taata. Ʉkwandɨla ʉlʉ, mummeenye, kangɨ mummbwene.” ");
INSERT INTO nyy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Po Filipo alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwe Ntwa, tukʉkʉsʉʉma ʉtʉnangɨsye Taata. Lɨnga ʉtʉnangiisye bo sitʉfwene.” ");
INSERT INTO nyy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Filipo, ndɨ na nuumwe akabalɨlo akatali koosa aka, poope ʉkaalɨ ʉkaamanya ʉne? Ʉmundʉ gwesa ʉjʉ aambwene ʉne, ammbwene na Taata. Po fiki kʉʉndaalʉʉsya ʉkʉtɨ, ‘Tʉnangɨsye Taata?’ ");
INSERT INTO nyy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Bʉle, ʉtikwitɨka ʉkʉtɨ ʉne ndɨ mwa Taata, na Taata alɨ mmyangʉ? Amasyʉ aga ngʉbabʉʉla gatikʉfuma mu nyiinogono syangʉ, looli Taata ikʉbomba ɨmbombo jaake bo alɨ nkatɨ mmyangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mwitɨkege ɨsi ngʉjoba ʉkʉtɨ ndɨ nkatɨ mwa Taata, nʉ kʉtɨ alɨ nkatɨ mmyangʉ. Looli lɨnga ʉmwe mutikwitɨka ɨsi ngʉjoba, po namwitɨkege kʉnongwa jaa mbombo ɨsi ngʉbomba. ");
INSERT INTO nyy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nalooli nikʉbabʉʉla, ʉmundʉ gwesa ʉjʉ ikʉʉnyiitɨka, ikʉsibombaga ɨmbombo silasila ɨsi ʉne ngʉsibomba. Kangɨ aikʉbombaga nɨ nywamu ʉkʉkɨnda ɨsi ngʉbomba, paapo ngʉbʉʉka kwa Taata. ");
INSERT INTO nyy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Lɨnga mukʉsʉʉma akandʉ kokoosa mu ngamu jangʉ, ʉne angʉbomba bo muno mukʉsʉʉmɨla. Kʉ njɨla ɨjo, ngʉnangɨsya ʉbʉsisya bwa Taata muno bʉjɨɨliile. ");
INSERT INTO nyy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Lɨnga mukʉʉsʉʉma akandʉ kokoosa mu ngamu jangʉ, angʉbomba bo muno mukʉsʉʉmɨla.” ");
INSERT INTO nyy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Lɨnga muunganile mukʉsibombaga ɨmbombo syosa ɨsi naabalagiile. ");
INSERT INTO nyy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Po na niine angʉnsʉʉma Taata ʉkʉtɨ abape ʉNjɨɨli ʉjʉngɨ, ʉkʉtɨ ajege pamopeene na nuumwe, kangɨ atiisakʉbaleka sikʉ. ");
INSERT INTO nyy_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mbepo ʉjʉ aikʉbasetʉlɨla abandʉ ʉbwanalooli. Abandʉ aba bikʉnkaana Kyala bakabagɨla ʉkʉmmwambɨlɨla Mbepo ʉjo, paapo batikʉmmbona, kangɨ bakammanya. Looli ʉmwe mummeenye Mbepo gwa Kyala paapo ikʉtʉʉgala pamopeene na nuumwe, kangɨ ikʉjaga nkatɨ mmyɨnu. ");
INSERT INTO nyy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ndikʉbaleka mwibeene bo ʉlwa bapɨɨna, looli angwisa kangɨ kʉmyɨnu. ");
INSERT INTO nyy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pasyele panandɨ andikʉbonekaga kangɨ pakiisʉ apa. Looli ʉmwe aamukʉʉmbona. Kʉnongwa jaa kʉtɨ ʉne angʉja mʉʉmi, nuumwe aamukʉja bʉʉmi. ");
INSERT INTO nyy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pi isikʉ lɨla, aamukʉmanya ʉkʉtɨ ʉne ndɨ nkatɨ mwa Taata, na nuumwe mulɨ nkatɨ mmyangʉ, niine ndɨ nkatɨ mmyɨnu. ");
INSERT INTO nyy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ʉmundʉ gwesa ʉjʉ ikʉsimanya nʉ kʉsibomba ɨsi ngʉlagɨla, ʉjo jo ʉjʉ aanganile. Joope ʉmundʉ ʉjʉ aanganile, Taata ikʉnngana. Niine ngʉnngana nʉ kwibonesya kʉmyake.” ");
INSERT INTO nyy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Po ʉmfundigwa jʉmo ɨngamu jaake Juuta, ʉjʉ akaja jo Juuta Isikalyoti, alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Gwe Ntwa, bʉle, sibagiile bʉleebʉle ʉkwibonesya kʉmyɨtʉ, looli ʉtikwibonesya kʉ bandʉ abangɨ boosa?” ");
INSERT INTO nyy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Ʉmundʉ gwesa ʉjʉ aanganile ikʉsibombelaga ɨsi ngʉnndagɨla. Bʉbʉʉbo Taata ikʉnngana, kangɨ ʉne na Taata aatukwisa kʉmyake, nʉ kʉtʉʉgala pamopeene nagwe. ");
INSERT INTO nyy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Looli ʉmundʉ gwesa ʉjʉ akaangana, atikʉsibombela ɨsi ngʉnndagɨla. Kangɨ, ɨsi ngʉbalagɨla sikaja syangʉ, looli sikʉfuma kʉlɨ ʉjʉ andʉmile kʉmyɨnu. ");
INSERT INTO nyy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Mbabʉʉlile syosa ɨsyo bo ngaalɨ ngʉtʉʉgala pamopeene na nuumwe. ");
INSERT INTO nyy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Looli ʉNjɨɨli ʉjo, kokʉtɨ Mbepo Mwikemo, ʉjʉ Taata ikʉntʉma kʉmyɨnu mu ngamu jangʉ, jo ʉjʉ aikʉbamanyisyaga nʉ kʉbakʉmbʉsya syosa ɨsi naababʉʉlile. ");
INSERT INTO nyy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Bo ngʉsookapo, ngʉbapa ʉlʉtengaano lwangʉ. Ngʉbapapo ʉlʉtengaano ʉlʉ lʉkaja bo ʉlʉ lukʉfuma kʉ bandʉ aba bikʉnkaana Kyala. Mulɨngalalamukaga mu ndumbula syɨnu, kangɨ mulɨngatiilaga syosyosa. ");
INSERT INTO nyy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mupɨliike ɨsi mbabʉʉlile ʉkʉtɨ, ‘Ngʉbʉʉka, looli angwisa kangɨ kʉmyɨnu.’ Lɨnga nalooli muunganile, ngalɨ mukʉhoboka ʉkʉpɨlɨka ʉkʉtɨ ngʉbʉʉka kwa Taata, paapo Taata jo nkʉlʉmba ʉkʉngɨnda ʉne. ");
INSERT INTO nyy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Mbabʉʉlile syosa ɨsyo akabalɨlo aka, bo ɨnongwa ɨsyo sikaalɨ ʉkʉboneka, ʉkʉtɨ bo siboniike mukʉʉnyiitɨkaga. ");
INSERT INTO nyy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ngabagɨla ʉkʉjoba na nuumwe akabalɨlo akatali, paapo ʉndagɨli gwa pakiisʉ apa, kokʉtɨ Seetano, ikwisa. Looli akaja na maka kʉmyangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ɨsi ngʉsibomba syo ɨsi Taata aalɨɨndagiile ʉkʉbomba, ʉkʉtɨ abandʉ boosa bamanye ʉkʉtɨ nʉnnganile. Ʉlʉ, namwɨme ʉkʉtɨ tʉsookepo apa.” ");
INSERT INTO nyy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesu alɨnkwendelela ʉkʉbamanyisya alɨnkʉtɨ, “Ʉne ndɨ mpiki ʉgwa maafiilʉ ʉgwa nalooli, Taata jo ndɨmi. ");
INSERT INTO nyy_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kʉkʉtɨ kasamba kangʉ aka katikʉpa ɨseke, Taata ikʉkasoosyamo. Looli kʉkʉtɨ kasamba aka kikʉpa ɨseke, Taata ikʉkapaatɨlɨla ʉkʉtɨ kapege fiijo. ");
INSERT INTO nyy_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ʉmwe mupaatɨlɨliigwe, kokʉtɨ mulɨ beelu, paapo mwitiike ɨmanyisyo syangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mwendelelege ʉkʉja mmyangʉ, na niine ngwendelelaga ʉkʉja mmyɨnu. Bo ʉlʉ akasamba kakabagɨla ʉkʉpa ɨseke keene kɨsita kwitoteka mmaafiilʉ, bʉbʉʉbo mukabagɨla ʉkʉbomba ʉbwigane bwa Kyala kɨsita kʉja mmyangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ʉne ndɨ mpiki ʉgwa maafiilʉ, ʉmwe mulɨ tʉsamba. Ʉmundʉ ʉjʉ ikʉja mmyangʉ, na niine ngʉja mmyake, ʉjo ikʉpaga ɨseke ɨnyingi, paapo kɨsita ʉne mukabagɨla ʉkʉbomba nasimo. ");
INSERT INTO nyy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ʉmundʉ gwesa ʉjʉ atikʉja mmyangʉ afwene na kasamba aka kikʉtaagigwa nʉ kʉʉma. Po abandʉ bikʉkasala nʉ kʉkasopa mmooto, kikʉpya. ");
INSERT INTO nyy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Lɨnga mukʉja mmyangʉ na masyʉ gangʉ gikʉja nkatɨ mmyɨnu, po munsʉʉmege Taata koosa aka mukʉlonda, ikʉbapaga. ");
INSERT INTO nyy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lɨnga mukʉpa ɨseke ɨnyingi, nʉ kʉja bafundigwa bangʉ baa nalooli, mukʉbʉnangɨsyaga pabwelu ʉbʉsisya bwa Taata. ");
INSERT INTO nyy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Bo ʉlwa Taata muno aanganiile ʉne, mo muno niine mbaganile ʉmwe. Po mwendelelege ʉkʉja ndʉgano lwangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Lɨnga mukʉbomba ɨsi ngʉbalagɨla, po mukwendelelaga ʉkʉja ndʉgano lwangʉ, bo muno ʉne nsibombile ɨsi Taata aalɨɨndagiile nʉ kʉja ndʉgano lwake. ");
INSERT INTO nyy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Mbabʉʉlile ɨsi ʉkʉtɨ musekelege bo ʉlwangʉ, kangɨ musekelege fiijo. ");
INSERT INTO nyy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ɨsi ngʉbalagɨla syo ɨsi, mugananege bo ʉlʉ ʉne mbaganile ʉmwe akabalɨlo aka bo ndɨ pamopeene na nuumwe. ");
INSERT INTO nyy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ʉmundʉ ʉjʉ ikʉbafwɨla abamanyaani, alɨ nʉ lʉgano ʉkʉkɨnda ʉlʉgano ʉlwa lʉko loosa. ");
INSERT INTO nyy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lɨnga mukʉbomba ɨsi mbalagiile, ʉmwe mulɨ bamanyaani bangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ʉkwandɨla ʉlʉ, ndikʉbakoolelaga kangɨ ʉkʉja batʉmwa bangʉ, paapo ʉntʉmwa akajɨmanya ɨnyango jaa nkʉlʉmba gwake. Looli ʉmwe mbasetʉliile syosa ɨsi naafumile nasyo ʉkʉfuma kwa Taata, po ʉlo ngʉbakoolelaga bamanyaani bangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mukaja jo ʉmwe mwalɨɨsalile ʉne, looli jo ʉne naabasalile ʉmwe ʉkʉja bafundigwa bangʉ. Naabasʉngwile ʉkʉtɨ mupege ɨseke ɨsi sitikʉmalɨka sikʉ. Po syosa ɨsi mukʉsʉʉma mu ngamu jangʉ, Taata ikʉbapaga. ");
INSERT INTO nyy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Po leelo ngʉbalagɨla ʉmwe ʉkʉtɨ mugananege.” ");
INSERT INTO nyy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Lɨnga abandʉ abaa pakiisʉ apa bikʉbabenga ʉmwe, mukʉmbʉkege ʉkʉtɨ baatalile ʉkʉʉmbenga ʉne. ");
INSERT INTO nyy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lɨnga mwalɨ bandʉ abaa pakiisʉ apa, po abo ngalɨ babaganile bo muno babaganiile abandʉ baake. Looli ʉmwe mukaja baa pakiisʉ apa, paapo mbasalile ʉkʉfuma pakiisʉ apa, jo nongwa ɨjɨ abandʉ abaa pakiisʉ apa bababengile. ");
INSERT INTO nyy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mulɨngiibwaga ɨsi naababʉʉlile ʉkʉtɨ, ‘Ʉntʉmwa akaja nkʉlʉmba ʉkʉnkɨnda ʉntwa gwake.’ Po lɨnga baalɨmbeele ɨngʉbɨlo ʉne, na nuumwe bikʉbapaga ɨngʉbɨlo, looli lɨnga bikwitɨka ɨmanyisyo syangʉ, aabikwitɨkaga nɨ syɨnu. ");
INSERT INTO nyy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Looli bikʉbabombela syosa ɨsyo kʉnongwa jaa kʉjɨkonga ɨngamu jangʉ, kangɨ kʉnongwa jaa kʉtɨ bakammanya ʉjʉ andʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Lɨnga ngaaliisile kʉmyabo nʉ kʉjoba nabo, po ngalɨ bakaja nʉ bʉtʉlanongwa. Looli lɨɨlɨno, bakabagɨla ʉkwinosya ʉkʉtɨ bakaja nʉ bʉtʉlanongwa. ");
INSERT INTO nyy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","“Ʉmundʉ gwesa ʉjʉ ikʉʉmbenga ʉne, ikʉmmbenga na Taata. ");
INSERT INTO nyy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mbombile ɨfiika ɨfinywamu ɨfi akabombamo najʉmo. Lɨnga bakaafibwene, ngalɨ bakaja nʉ bʉtʉlanongwa. Looli lɨɨlɨno basibwene syosa ɨsi naabombile, poope bakaalɨ bikʉʉmbenga, joope Taata bikʉmmbenga. ");
INSERT INTO nyy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ɨsi siboniike ʉkʉtɨ amasyʉ gaboneke aga gasimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Baalɨɨmbengile itolo.’ ");
INSERT INTO nyy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ngʉntʉma kʉmyɨnu ʉNjɨɨli, ʉjʉ jo Mbepo Mwikemo, ʉgwa kʉbasetʉlɨla abandʉ boosa ʉbwanalooli. Ikʉfuma kwa Taata, na bo ikʉfika kʉmyɨnu aikʉbasisimɨkɨsyaga ʉbwanalooli bwangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kangɨ na nuumwe aamukʉsisimɨkɨsyaga ɨnongwa syangʉ, paapo mwalɨ pamopeene na niine ʉkʉfuma kʉbwandɨlo.” ");
INSERT INTO nyy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesu alɨnkwendelela ʉkʉbamanyisya alɨnkʉtɨ, “Mbabʉʉlile syosa ɨsi ʉkʉtɨ mulɨngaleka ʉkʉʉnyiitɨka. ");
INSERT INTO nyy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Looli abandʉ aabikʉbakagaga ʉmwe mu sinagogi syabo. Kikwisa akabalɨlo aka lɨnga ʉmundʉ ikʉnngoga jʉmo pakatɨ pamyɨnu, ikwinogonaga ʉkʉtɨ ikʉbomba ɨmbombo jaa Kyala. ");
INSERT INTO nyy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Aabikʉbabombelaga bo ʉlo paapo bakammanya Taata, kangɨ bakaamanya ʉne. ");
INSERT INTO nyy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Looli mbabʉʉlile ɨsyo ʉkʉtɨ akabalɨlo kaabo akaa kʉbomba ɨsyo bo kafikile, aamusikʉmbʉkege ɨsi naababʉʉlile.” “Ngaababʉʉlile ɨsyo syosa kʉbwandɨlo, paapo naalɨ pamopeene na nuumwe. ");
INSERT INTO nyy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Po ʉlʉ ngʉbʉʉka kwa Taata ʉjʉ andʉmile kʉmyɨnu. Looli akajapo najʉmo pakatɨ pamyɨnu ʉgwa kʉʉndaalʉʉsya ʉkʉtɨ, ‘Bʉle, kʉbʉʉka kʉʉgʉ?’ ");
INSERT INTO nyy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Musulumeenie fiijo mu ndumbula syɨnu paapo mbabʉʉlile ʉkʉtɨ ngʉbʉʉka kwa Taata. ");
INSERT INTO nyy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Ngʉbabʉʉla ɨsya nalooli, kanunu kʉmyɨnu ʉkʉtɨ ngʉbʉʉka kwa Taata. Lɨnga ndikʉbʉʉka, ʉNjɨɨli jʉla akabagɨla ʉkwisa kʉmyɨnu. Looli lɨnga ngʉbʉʉka, angʉntʉma kʉmyɨnu. ");
INSERT INTO nyy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jʉla bo iisile, aikʉbanangɨsyaga abandʉ boosa ʉkʉtɨ abeene batʉlanongwa, nʉ kʉtɨ ʉne ndɨ ngolofu, kangɨ ʉkʉtɨ Kyala ikwisa kʉbalonga. ");
INSERT INTO nyy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Aikʉbanangɨsyaga abeene ʉkʉja batʉlanongwa, paapo batikʉʉnyiitɨka ʉne. ");
INSERT INTO nyy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Aikʉbanangɨsyaga ʉkʉtɨ ndɨ ngolofu paapo ngʉbʉʉka kwa Taata nʉ kʉtɨ aamutikʉʉmbona sikʉ. ");
INSERT INTO nyy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aikʉbanangɨsyaga pabwelu ʉkʉtɨ Kyala aikʉbalonga paapo anndongile Seetano ʉjʉ jo ndagɨli gwa pakiisʉ apa. ");
INSERT INTO nyy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ngaalɨ ndɨ nasyo nyingi ɨsya kʉbabʉʉla, looli akabalɨlo aka mukabagɨla ʉkʉsyagania. ");
INSERT INTO nyy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mbepo jʉla, ʉjʉ aikʉbasetʉlɨla ʉbwanalooli boosa, bo iisile kʉmyɨnu, aikʉbalongosyaga ʉkʉbʉmanya ʉbwanalooli boosa. Atiisakʉjobaga kʉ bʉlagɨli bwake jʉʉjo, looli ikʉjobaga ɨsi asipɨliike nʉ kʉbabʉʉla ɨsi aasikʉboneka. ");
INSERT INTO nyy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mbepo ʉjo aikʉbanangɨsyaga ʉbʉsisya bwangʉ, paapo aikʉbabʉʉlaga syosa ɨsi aikwegaga kʉmyangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ʉtʉndʉ toosa ʉtʉ Taata alɨ nato twangʉ. Jo nongwa ɨjɨ ngʉjoba ʉkʉtɨ Mbepo ʉjo aikʉbabʉʉlaga syosa ɨsi aikwegaga ʉkʉfuma kʉmyangʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kasyele akabalɨlo akapimba aamutikʉʉmbona, kangɨ kasyele akabalɨlo akapimba aamukʉʉmbona.” ");
INSERT INTO nyy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Po abafundigwa baake bamo balɨnkʉlaalʉʉsania balɨnkʉtɨ, “Bʉle, kokʉtɨ fiki ʉlʉ ikʉjoba ʉkʉtɨ, ‘Kasyele akabalɨlo akapimba aamutikʉʉmbona, kangɨ kasyele akabalɨlo akapimba aamukʉʉmbona,’ nʉ kʉtɨ, ‘Ngʉbʉʉka kwa Taata’? ” ");
INSERT INTO nyy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Po balɨnkwendelela ʉkʉlaalʉʉsania balɨnkʉtɨ, “Kokʉtɨ fiki, ‘Akabalɨlo akapimba?’ Ʉswe tʉtikʉsyagania ɨsi ikʉsijoba.” ");
INSERT INTO nyy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesu alɨnkʉsyagania ʉkʉtɨ bikʉlonda ʉkʉnndaalʉʉsya ɨsi ajobile, po alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Bʉle, mukʉlaalʉʉsania ɨsi njobile ʉkʉtɨ, ‘Kasyele akabalɨlo akapimba aamutikʉʉmbona, kangɨ kasyele akabalɨlo akapimba aamukʉʉmbona?’ ");
INSERT INTO nyy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nalooli nikʉbabʉʉla, ʉmwe aamukʉlɨlaga nʉ kʉsulumania, looli abandʉ abaa pakiisʉ apa aabikʉhobokaga. Aamukʉsulumania kʉkabalɨlo akapimba, looli ʉbʉsulumanie bwɨnu aabukʉsanuka ʉkʉja lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Lɨnga ʉnkiikʉlʉ ikʉbʉʉka kʉkʉpaapa ʉmwana, ikʉsulumania paapo akabalɨlo kaa bʉtolwe bwake kafikile. Looli bo apaapile, atikʉkʉmbʉka kangɨ ʉbʉtolwe ʉbo kʉnongwa jaa lʉsekelo lwa kʉpaapigwa ʉmwana pakiisʉ. ");
INSERT INTO nyy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Bʉbʉʉbo na nuumwe mulɨ nʉ bʉsulumanie kʉkabalɨlo. Looli angwisa kangɨ kʉmyɨnu, po aamukʉjaga nʉ lʉsekelo mu ndumbula syɨnu. Akajako ʉjʉ aikʉlʉsoosyamo ʉlʉsekelo ʉlo mu ndumbula syɨnu. ");
INSERT INTO nyy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kangɨ akabalɨlo ako bo kafikile, aamutikʉʉsʉʉmaga kokoosa. Nalooli nikʉbabʉʉla, syosa ɨsi mukʉsʉʉma mu ngamu jangʉ, Taata ikʉbapaga. ");
INSERT INTO nyy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mpaka ʉlʉ, mukasʉʉma nakamo kwa Taata ʉkʉbombela ɨngamu jangʉ. Musʉʉmege kwa Kyala, ʉmwene ikʉbapaga. Kʉ njɨla ɨjo mukwendelelaga ʉkʉja nʉ lʉsekelo fiijo mu ndumbula syɨnu.” ");
INSERT INTO nyy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Mbabʉʉlile syosa ɨsyo kʉ njɨla jaa fifwanikɨsyo. Akabalɨlo kikwisa aka andikʉjobaga na nuumwe kʉ njɨla jaa fifwanikɨsyo, looli angʉbabʉʉlaga pabwelu ɨsya Taata. ");
INSERT INTO nyy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nkabalɨlo ako, aamukʉbombelaga ɨngamu jangʉ ʉkʉnsʉʉma Taata. Ndikʉjoba ʉkʉtɨ ʉne angʉbasʉʉmɨlaga kwa Taata. ");
INSERT INTO nyy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ʉmwene Taata abaganile ʉmwe, paapo nuumwe muunganile ʉne, kangɨ mwitiike ʉkʉtɨ naafumile kwa Taata. ");
INSERT INTO nyy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Naaliisile pakiisʉ apa ʉkʉfuma kwa Taata, looli ʉlʉ ngʉsookapo pakiisʉ apa, ngʉgomokelako kwa Taata.” ");
INSERT INTO nyy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Po abafundigwa baake balɨnkʉmmbʉʉla balɨnkʉtɨ, “Gwe Mmanyisi, ʉlʉ gwandile ʉkʉjoba na nuuswe kɨsita kʉbombela ɨfifwanikɨsyo! ");
INSERT INTO nyy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Po ʉlʉ tʉsyageenie ʉkʉtɨ ʉsimeenye syosa, kangɨ ʉtikʉlonda ʉmundʉ ʉkʉlaalʉʉsya syosyosa. Ɨsyo syo ɨsi sitʉpelile ʉkwitɨka ʉkʉtɨ gwafumile kwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesu alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Bʉle, mwandile ʉkwitɨka ʉlʉ? ");
INSERT INTO nyy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Akabalɨlo kasegeliile, kangɨ kalɨ kɨfuki fiijo, apa mwesa aamukʉbalanila. Mwesa mukʉbʉʉka kʉmyɨnu, nʉ kʉʉndeka niimwene. Looli andikʉja niimwene, paapo Taata alɨ pamopeene na niine. ");
INSERT INTO nyy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mwe bakʉndwe, mbabʉʉlile ɨsyo syosa ʉkʉtɨ mujege nʉ lʉtengaano mu ndumbula syɨnu, kʉnongwa jaa kʉja nkatɨ mmyangʉ. Pakiisʉ apa aamukʉkaba ɨngʉbɨlo ɨnyingi, looli mwikasyege paapo ʉne nkɨtolile ɨkiisʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesu bo amalile ʉkʉjoba syosa ɨsyo, alɨnkʉkeeta kʉmwanya, alɨnkwipuuta alɨnkʉtɨ, “Gwe Taata, akabalɨlo kangʉ kafikile. Ʉbanangɨsye abandʉ ʉbʉsisya bwangʉ ne Mwanaako, ʉkʉtɨ niine mbanangɨsye ʉbʉsisya bwako muno bʉjɨɨliile. ");
INSERT INTO nyy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Namanga ʉmbeele ʉbʉlagɨli ʉbwa kʉbalongosya abandʉ boosa, ʉkʉtɨ mbape abandʉ aba bikʉʉnyiitɨka ʉbʉʉmi bwa bwila na bwila. ");
INSERT INTO nyy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ʉbʉʉmi bwa bwila na bwila bo ʉbʉ, abandʉ bakʉmanye ʉgwe, gwe Kyala gwa nalooli gwimwene, kangɨ baamanye ʉne ne Jesu Kɨlɨsiti, ne gwalɨndʉmile kʉmyabo. ");
INSERT INTO nyy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ʉne nnangiisye ʉbʉsisya bwako kʉ bandʉ boosa, ʉkwendela mu mbombo ɨjɨ gwalɨndʉmile kʉkʉjɨbomba. ");
INSERT INTO nyy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Gwe Taata, ngʉsʉʉma ʉnangɨsye ʉbʉsisya bwangʉ, ʉkʉtɨ abandʉ boosa babʉbone ʉbʉsisya ʉbʉ naalɨ nabo bo tʉlɨ pamopeene, bo ʉkaalɨ ʉkʉkɨpela ɨkiisʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Gwe Taata, ngʉsetwile muno ʉjɨɨliile ʉgwe, kʉ bandʉ aba gwalɨmbeele pakiisʉ apa. Abeene baalɨ baako, ʉgwe gwalɨmbeele. Kangɨ basibombile syosa ɨsi gwabalagiile. ");
INSERT INTO nyy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Po basyageenie ʉkʉtɨ ʉtʉndʉ toosa ʉtʉ gwalɨmbeele, tʉfumile kʉmyako, ");
INSERT INTO nyy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","paapo mbabʉʉlile syosa ɨsi gwalɨɨmbʉʉlile. Boope basyambɨliile, bameenye nalooli ʉkʉtɨ mfumile kʉmyako, kangɨ biitiike ʉkʉtɨ jo ʉgwe gwalɨndʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ngʉbiipuutɨla abo paapo bandʉ baako. Ndikʉbiipuutɨla abandʉ boosa, looli ngʉbiipuutɨla beene abandʉ aba gwalɨmbeele. ");
INSERT INTO nyy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Abandʉ boosa aba bo bangʉ ʉne, na nungwe baako, kangɨ abandʉ boosa aba bo baako, na niine bangʉ. Ʉbʉsisya bwangʉ muno bʉjɨɨliile, bʉsetʉliigwe kʉ bandʉ ʉkwendela mmyabo. ");
INSERT INTO nyy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ʉne ngwisa kʉmyako, po ndikʉjapo kangɨ pakiisʉ apa. Looli abeene bikwendelelaga ʉkʉja pakiisʉ apa. Gwe Taata, gwe Mwikemo, ngʉkʉsʉʉma ʉbalɨndɨlɨle mu ngamu jaako ɨjɨ ʉmbeele, ʉkʉtɨ bajege kandʉ kamokeene bo ʉlʉ ʉne na nungwe tʉlɨ kandʉ kamokeene. ");
INSERT INTO nyy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bo ndɨ pamopeene nabo naabalɨndɨlɨlaga mu ngamu jaako ɨjɨ ʉmbeele. Naabatiimaga kanunu ʉkʉtɨ ndɨngansobesya najʉmo ndɨ bala, looli mwene ʉjʉ sibagiisye ʉkʉtɨ afwe, ʉkʉtɨ siboneke ɨsi sisimbiigwe mwa Kalata ʉMwikemo. ");
INSERT INTO nyy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Gwe Taata, ʉlʉ ndɨ mu njɨla ngwisa kʉmyako. Ʉne ngʉbabʉʉla syosa ɨsyo abafundigwa bangʉ bo ngaalɨ ndipo pakiisʉ apa, ʉkʉtɨ bajege nʉ lʉsekelo fiijo mu ndumbula syabo, bo ʉlʉ ʉne ndɨ nʉ lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mbabʉʉlile abafundigwa bangʉ ɨnongwa ɨsi ʉmbeele. Looli abandʉ abaa pakiisʉ apa bababengile, paapo abeene bakaja baa pakiisʉ apa, bo ʉlʉ na niine ngaja gwa pakiisʉ apa. ");
INSERT INTO nyy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Gwe Taata, ndikʉkʉsʉʉma ʉkʉtɨ ʉbasoosyepo pakiisʉ apa, looli ʉkʉtɨ ʉbapoke kwa Seetano, ʉjʉ jo mbiibi. ");
INSERT INTO nyy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Abeene bakaja baa pakiisʉ apa, bo ʉlʉ ʉne ngaja gwa pakiisʉ apa. ");
INSERT INTO nyy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gwe Taata, ngʉkʉsʉʉma ʉbapele ʉkʉja biikemo, kʉ njɨla jaa bwanalooli bwako. Iisyʉ lyako bo bwanalooli. ");
INSERT INTO nyy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Bo ʉlʉ gwalɨndʉmile ʉne pakiisʉ, bʉbʉʉbo na niine mbatʉmile abeene pakiisʉ. ");
INSERT INTO nyy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ngwibɨɨka ʉkʉkʉbombela ʉgwe kʉnongwa jaabo, ʉkʉtɨ boope biibɨɨke kʉmyako mbwanalooli.” ");
INSERT INTO nyy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ndikʉbiipuutɨla beene itolo, looli ngʉbiipuutɨla boope boosa, aba aabikwisa kʉʉnyiitɨka, kʉnongwa jaa ɨsi abafundigwa bangʉ bikʉmanyisya. ");
INSERT INTO nyy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ngwipuuta ʉkʉtɨ abandʉ boosa bajege kandʉ kamokeene. Taata! Ngwipuuta bajege nkatɨ mmyɨtʉ, bo ʉlʉ ʉgwe ʉlɨ nkatɨ mmyangʉ, niine ndɨ nkatɨ mmyako. Ngwipuuta ʉkʉtɨ bajege kandʉ kamokeene, ʉkʉtɨ biitɨke ʉkʉtɨ jo ʉgwe gwalɨndʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ʉbʉsisya ʉbʉ gwalɨmbeele na niine mbapeele abafundigwa bangʉ, ʉkʉtɨ bajege kandʉ kamokeene, bo ʉlʉ ʉne na nungwe tʉlɨ kandʉ kamokeene. ");
INSERT INTO nyy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ʉne ndɨ nkatɨ mmyabo, nungwe ʉlɨ nkatɨ mmyangʉ. Ngʉsʉʉma ʉkʉtɨ bajege kandʉ kamokeene loosa, ʉkʉtɨ kʉ njɨla ɨjɨ abandʉ boosa abaa pakiisʉ bamanye ʉkʉtɨ jo ʉgwe gwalɨndʉmile, kangɨ bamanye ʉkʉtɨ ʉbaganile bo ʉlʉ gʉʉnganile ʉne. ");
INSERT INTO nyy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Gwe Taata, ngʉnyonywa ʉkʉtɨ aba ʉmbeele bajege pamopeene na niine apa ngʉjaga, ʉkʉtɨ babʉbone ʉbʉsisya bwangʉ ʉbʉ gwalɨmbeele, paapo gwalɨɨnganile na bo ʉkaalɨ ʉkʉkɨpela ɨkiisʉ. ");
INSERT INTO nyy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Gwe Taata, gwe gwa bwanalooli, abandʉ abaa pakiisʉ apa bakakʉmanya. Looli ʉne ngʉmeenye, kangɨ abafundigwa bangʉ bameenye ʉkʉtɨ jo ʉgwe gwalɨndʉmile. ");
INSERT INTO nyy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ʉne mbamanyiisye muno ʉjɨɨliile ʉgwe, kangɨ ngwendelelaga ʉkʉbomba bo ʉlo, ʉkʉtɨ bagananege bo ʉlʉ gʉʉnganile ʉne, kangɨ ʉkʉtɨ njege nkatɨ mmyabo.” ");
INSERT INTO nyy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesu bo amalile ʉkwipuuta, alɨnkʉsookapo na bafundigwa baake, alɨnkʉbʉʉka nkɨsooko Ketiloni, apa gwalipo ʉngʉnda ʉgwa misyʉngʉtɨ. Balɨnkwingɨla ʉmo. ");
INSERT INTO nyy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Po Juuta ʉjʉ aabʉʉkaga kʉkʉnndɨɨla Jesu, aagʉmeenye ʉngʉnda ʉgo, paapo Jesu aaliisibiile ʉkʉbʉʉka mula akabalɨlo kaa kingi pamopeene na bafundigwa baake. ");
INSERT INTO nyy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Po alɨnkʉkɨlongosya ɨkɨbugutɨla kya basikali, pamopeene na babombeli bamo ʉkʉfuma kʉ bapuuti abalongosi na kʉ Bafalisai, balɨnkʉbʉʉka mu ngʉnda gʉla, baakolile ɨnyaale nɨ filwɨlo. ");
INSERT INTO nyy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesu aasimeenye syosa ɨsi syajaga pakʉbombigwa kʉmyake. Po alɨnkʉsookapo pakatɨ pa bafundigwa baake, alɨnkʉbalaalʉʉsya abandʉ aba baaliisile alɨnkʉtɨ, “Bʉle, mukʉnndonda jwani?” ");
INSERT INTO nyy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Abeene balɨnkʉmmwamula balɨnkʉtɨ, “Tukʉnndonda Jesu ʉjʉ afumile mu Nasaleti.” Jesu alɨnkʉbaamula alɨnkʉtɨ, “Jo ʉne ʉjʉ mukʉnndonda.” Juuta ʉjʉ aalɨnndɨɨliile Jesu aalyɨmile pamopeene nabo. ");
INSERT INTO nyy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Po Jesu bo ababʉʉlile ʉkʉtɨ, “Jo ʉne ʉjʉ mukʉnndonda,” abasikali bala balɨnkʉgomoka kʉnyuma nʉ kʉgwa paasi. ");
INSERT INTO nyy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesu alɨnkʉbalaalʉʉsya kangɨ alɨnkʉtɨ, “Bʉle, mukʉnndonda jwani?” Abeene balɨnkʉmmwamula balɨnkʉtɨ, “Tukʉnndonda Jesu ʉjʉ afumile mu Nasaleti.” ");
INSERT INTO nyy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Mbabʉʉlile ʉkʉtɨ jo ʉne ʉjʉ mukʉnndonda. Lɨnga mukʉʉndonda ʉne, po namubaleke abandʉ aba babʉʉkege.” ");
INSERT INTO nyy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesu aajobile bo ʉlo ʉkʉtɨ siboneke ɨsi aajobile kʉbwandɨlo ʉkʉtɨ, “Naabatiimaga kanunu, ʉkʉtɨ ndɨngansobesya najʉmo ndɨ bala aba gwalɨmbeele.” ");
INSERT INTO nyy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Peeteli aalɨ nʉ lʉʉbo, po alɨnkʉkwaba, alɨnkʉnsenga ʉntʉmwa gwa mpuuti ʉnkʉlʉmba, ɨmbʉlʉkʉtʉ jaa kʉ kiilɨɨlo. Ʉntʉmwa ʉjo ɨngamu jaake aalɨ jo Maalɨko. ");
INSERT INTO nyy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Looli Jesu alɨnkʉnndagɨla Peeteli alɨnkʉtɨ, “Peeteli, gomosya ʉlʉʉbo lwako mu nyambɨ jaake. Bʉle, ʉkamanya ʉkʉtɨ ngʉlondigwa ʉkʉkʉbɨlwa bo muno Taata asibaatiike ʉkʉtɨ ngʉbɨlwe?” ");
INSERT INTO nyy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Po ʉnkʉlʉmba gwa basikali, pamopeene nɨ kɨbugutɨla kyake, na babombeli baa balongosi baa Bajuuta, balɨnkʉnkola Jesu, balɨnkʉmpinya. ");
INSERT INTO nyy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Po balɨnkʉntwala taasi kwa Anasi, ʉjʉ aalɨ nko gwa Kajafa, ʉjʉ aalɨ jo mpuuti ʉnkʉlʉmba nkabalɨlo ako. ");
INSERT INTO nyy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mmasikʉ agaa kʉnyuma, Kajafa jo ʉjʉ aababʉʉlile abalongosi baa Bajuuta, ʉkʉtɨ kanunu ʉmundʉ jʉmo abafwɨle abandʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Peeteli nʉ mfundigwa ʉjʉngɨ jʉmo, bankongaga kʉnyuma. Ʉmfundigwa jʉla, ʉmpuuti ʉnkʉlʉmba aalɨmmeenye, jo alɨnkwingɨla na Jesu ndʉpaso lwa nyumba jaa mpuuti ʉnkʉlʉmba. ");
INSERT INTO nyy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Looli Peeteli alɨnkwɨma panja pa kɨpata. Po ʉmfundigwa ʉjʉngɨ jʉla, ʉjʉ ʉmpuuti ʉnkʉlʉmba aalɨmmeenye, alɨnkʉsooka panja. Alɨnkʉjoba nʉ ndɨndwana jʉmo ʉjʉ aalɨ ndɨndɨlɨli pa kɨpata, alɨnkʉmmwitɨkɨsya Peeteli ʉkwingɨla ndʉpaso. ");
INSERT INTO nyy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Po ʉndɨndwana ʉndɨndɨlɨli jʉla, alɨnkʉnndaalʉʉsya Peeteli alɨnkʉtɨ, “Bʉle, na nungwe ʉkaja gwe jʉmo mbafundigwa baa mundʉ ʉjo?” Peeteli alɨnkʉmmwamula alɨnkʉtɨ, “Hɨmma, ngaja jo ʉne.” ");
INSERT INTO nyy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kʉnongwa jaa kʉtɨ kwalɨ nɨ mbepo, abatʉmwa na babombeli bala baalyɨmile apa gwalipo ʉmooto gwa nkala, bootaga ʉmooto. Joope Peeteli aalyɨmile pamopeene nabo, ootaga ʉmooto. ");
INSERT INTO nyy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Po ʉmpuuti ʉnkʉlʉmba jʉla, ɨngamu jaake Anasi, alɨnkʉnndaalʉʉsya Jesu ɨsya bafundigwa baake nɨ manyisyo syake. ");
INSERT INTO nyy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Akabalɨlo koosa naajobaga kʉ bandʉ boosa pabwelu, naamanyisyaga abandʉ mu sinagogi syɨnu na ndʉpaso lwa tempeli, muno aBajuuta bingi bikʉbʉngaana pamopeene. Mmanyiisye ɨmanyisyo syangʉ syosa pabwelu. ");
INSERT INTO nyy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Po fiki kʉʉndaalʉʉsya ʉne? Po fiki ʉtikʉbalaalʉʉsya abandʉ aba bambɨlɨkɨsyaga bo ngʉmanyisya? Abeene basimeenye ɨsi naajobaga nʉ kʉmanyisya.” ");
INSERT INTO nyy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesu bo ajobile ɨsyo, ʉmbombeli jʉmo ʉjʉ aalyɨmile kɨfuki nagwe, alɨnkʉnkoma ni ipi, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Bʉle, kʉmmwamula bo ʉlo ʉmpuuti ʉnkʉlʉmba?” ");
INSERT INTO nyy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Lɨnga njobile kabiibi, joba ʉbʉbiibi bwangʉ. Looli lɨnga njobile ɨsya bwanalooli, po fiki kʉngoma?” ");
INSERT INTO nyy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Po Jesu bo akaalɨ apinyiigwe, Anasi alɨnkʉlagɨla ʉkʉtɨ bammwege nʉ kʉbʉʉka nagwe kʉ mpuuti ʉnkʉlʉmba, Kajafa. ");
INSERT INTO nyy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Po Peeteli bo akaalɨ ikoota ʉmooto, abandʉ bamo balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle, na nungwe ʉkaja gwe jʉmo mbafundigwa baa mundʉ jʉla?” Peeteli alɨnkwamula alɨnkʉtɨ, “Hɨmma, ngaja jo ʉne.” ");
INSERT INTO nyy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Looli jʉmo mbatʉmwa abaa mpuuti ʉnkʉlʉmba, ʉjʉ aalɨ nkamu gwa mundʉ ʉjʉ Peeteli aalɨnsengile ɨmbʉlʉkʉtʉ, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Bʉle, ʉkaja jo ʉgwe naakʉbwene bo ʉlɨ pamopeene na Jesu mu ngʉnda?” ");
INSERT INTO nyy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peeteli alɨnkʉkaana kangɨ alɨnkʉtɨ, “Ngaja jo ʉne.” Nakalɨnga ɨngongobe jɨlɨnkʉkoolela. ");
INSERT INTO nyy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Po nʉlʉbʉnjʉ fiijo, abalongosi baa Bajuuta balɨnkʉmmwega Jesu ʉkʉfuma kwa Kajafa. Balɨnkʉbʉʉka nagwe kʉ kɨtangaalala kya ndongosi gwa Balooma. Looli abeene bakaalingiile nnyumba jaake ʉkʉtɨ balɨngiinyasya, baatiilaga ʉkʉtɨ aabatikʉlya ɨfindʉ fya pa kyaka kya Pasa. ");
INSERT INTO nyy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Po ʉndongosi gwa kiisʉ ɨkya Jutai, ɨngamu jaake Pilati, alɨnkʉsooka panja nʉ kʉbʉʉka apa baalipo, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Bʉle, ʉmundʉ ʉjʉ abombile mbiibi silɨkʉ ɨsi mukʉnsitaaka?” ");
INSERT INTO nyy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Abeene balɨnkʉmmwamula balɨnkʉtɨ, “Lɨnga ʉmundʉ ʉjʉ akaalɨ nɨ mbiibi, tʉkaabagiile ʉkwisa nagwe kʉmyako.” ");
INSERT INTO nyy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilati alɨnkʉbabʉʉla alɨnkʉtɨ, “Po jʉjʉʉmwe namummwege mukanndongege ʉkʉkongana nɨ ndagɨlo syɨnu.” Looli abeene balɨnkʉmmwamula balɨnkʉtɨ, “Tʉkaja nʉ bʉlagɨli ʉbwa kʉnndonga ʉmundʉ gwesa ʉkʉtɨ afwe.” ");
INSERT INTO nyy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ɨsyo syabombiigwe bo ʉlo, ʉkʉtɨ ɨsi Jesu aajobile siboneke, ʉkʉnangɨsya muno aikʉfwɨla. ");
INSERT INTO nyy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Po Pilati alɨnkwingɨla kangɨ nnyumba, alɨnkʉlagɨla ʉkʉtɨ bantwale Jesu kʉmyake, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Bʉle, ʉgwe ʉlɨ Malafyale gwa Bajuuta?” ");
INSERT INTO nyy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Looli Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Bʉle, ɨsi kʉʉndaalʉʉsya, sikʉfuma mu nyiinogono syako pamo abandʉ abangɨ bakʉbʉʉlile ɨnongwa syangʉ?” ");
INSERT INTO nyy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilati alɨnkʉmmwamula alɨnkʉtɨ, “Bʉle, ʉne ndɨ Njuuta? Moomuumo, abandʉ abaa nkɨkolo kyako pamopeene na bapuuti abalongosi bo aba bakʉtwele kʉmyangʉ ʉkʉtɨ ngʉlonge. Bʉle, ʉbombile ɨfiki?” ");
INSERT INTO nyy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesu alɨnkwamula alɨnkʉtɨ, “ɄBʉnyafyale bwangʉ bʉkaja bwa pakiisʉ apa. Lɨnga bwalɨ bwa pakiisʉ apa, po abafundigwa bangʉ baabagiile ʉkʉʉndwɨla ʉkʉtɨ ndɨngakoligwa na Bajuuta. Looli ʉBʉnyafyale bwangʉ bʉkaja bwa pakiisʉ apa.” ");
INSERT INTO nyy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Po Pilati alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Bʉle, po sya nalooli ʉkʉtɨ ʉgwe ʉlɨ malafyale?” Jesu alɨnkwamula alɨnkʉtɨ, “Jo ʉgwe ʉjobile ʉkʉtɨ ʉne ndɨ malafyale. Ʉne naapaapiigwe pakiisʉ apa, kangɨ naaliisile, ʉkʉtɨ mbamanyisye abandʉ ʉbwanalooli. Ʉmundʉ gwesa ʉjʉ ikʉbʉkonga ʉbwanalooli, ikʉgapɨlɨka amasyʉ gangʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilati alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Ʉbwanalooli fyo fiki?” Pilati bo ajobile ɨsyo, alɨnkʉsooka panja, alɨnkʉbabʉʉla abalongosi baa Bajuuta alɨnkʉtɨ, “Ʉne ngajaaga ɨnongwa najɨmo kʉ mundʉ ʉjʉ. ");
INSERT INTO nyy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Looli mulɨ nʉ lwiho ʉlwa kʉʉsʉʉma ʉkʉbaabʉlɨla ʉmpinyigwa jʉmo pakabalɨlo akaa pa kyaka kya Pasa. Bʉle, mukʉʉndonda mbaabʉlɨle ʉMalafyale gwa Bajuuta?” ");
INSERT INTO nyy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Looli abandʉ boosa balɨnkʉjwega balɨnkʉtɨ, “Hɨmma! Ʉlɨngatwabʉlɨla ʉmundʉ ʉjo, looli ʉtwabʉlɨle Balaba!” Balaba aapinyiigwe mu nnyololo kʉnongwa jaa kʉbʉpɨnga ʉbʉlongosi bwa Balooma. ");
INSERT INTO nyy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Po Pilati alɨnkʉmmwega Jesu nnyumba, alɨnkʉbalagɨla abasikali baake ʉkʉtɨ bankome Jesu nɨ fingoti. ");
INSERT INTO nyy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Abasikali balɨnkʉlʉka ɨngɨga ɨjaa miifwa, balɨnkʉmfwɨka muntʉ. Kangɨ balɨnkʉmfwɨka ʉnselekesye ʉmfubɨɨfu ʉbʉtiitʉ, ʉgwa malafyale. ");
INSERT INTO nyy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Balɨnkʉbʉʉka kʉmyake, balɨnkʉmponia balɨnkʉtɨ, “Ʉgonile, gwe Malafyale gwa Bajuuta!” Balɨnkʉnkoma na mapi. ");
INSERT INTO nyy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilati alɨnkʉsooka panja kangɨ, alɨnkʉkɨbʉʉla ɨkɨlʉndɨlo ɨkya bandʉ bala alɨnkʉtɨ, “Namupɨlɨkɨsye, nʉntwele panja kʉmyɨnu ʉmundʉ ʉjʉ, ʉkʉtɨ mumanye ʉkʉtɨ ngajaaga ɨnongwa najɨmo mmyake.” ");
INSERT INTO nyy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Po balɨnkʉnsoosya Jesu panja bo afwele ɨngɨga ɨjaa miifwa nʉ nselekesye ʉmfubɨɨfu ʉbʉtiitʉ. Po Pilati alɨnkʉjoba pabwelu alɨnkʉtɨ, “Keeta, ʉmundʉ ʉmwene jo ʉjo!” ");
INSERT INTO nyy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Abapuuti abalongosi na babombeli baabo bo bammbwene Jesu, balɨnkʉjwega balɨnkʉtɨ, “Nkomelele pa kɨkohekano, nkomelele pa kɨkohekano!” Po Pilati alɨnkʉbabʉʉla alɨnkʉtɨ, “Namummwege jʉjʉʉmwe mukankomelele pa kɨkohekano, namanga ʉne ngajaaga ɨnongwa najɨmo mmyake.” ");
INSERT INTO nyy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ABajuuta balɨnkʉmmwamula balɨnkʉtɨ, “Ʉswe tʉlɨ nʉ lʉlagɨlo. Ʉkʉkongana nʉ lʉlagɨlo ʉlo, ikʉlondigwa ʉkʉgogigwa, paapo ikwijoba ʉkʉtɨ Mwana gwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilati bo apɨliike amasyʉ ago, alɨnkʉkɨndɨlɨla ʉkʉtiila fiijo. ");
INSERT INTO nyy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Po alɨnkwingɨla kangɨ nnyumba jaake, alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Gwe mundʉ ʉgwe, ʉfumile kʉʉgʉ?” Looli Jesu akaalɨmmwamwile nalɨmo. ");
INSERT INTO nyy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Po Pilati alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Fiki ʉtikʉʉnyaamula? Bʉle, ʉkamanya ʉkʉtɨ ndɨ nʉ bʉlagɨli ʉbwa kʉkwabʉla, kangɨ nʉ bwa kʉkʉkomelela pa kɨkohekano?” ");
INSERT INTO nyy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesu alɨnkʉmmwamula Pilati alɨnkʉtɨ, “Ngalɨ ʉkaja nʉ bʉlagɨli nabʉmo lɨnga ʉkaapeeliigwe na Kyala. Looli ʉmundʉ ʉjʉ aambɨɨkile mmaboko gaako, alɨ nʉ bʉtʉlanongwa ʉbʉnywamu fiijo ʉkʉkɨnda ʉbʉtʉlanongwa bwako.” ");
INSERT INTO nyy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Po Pilati bo apɨliike ɨsyo, alɨnkʉgela ʉkʉlonda ɨnjɨla ɨjaa kʉmmwabʉla Jesu, looli aBajuuta balɨnkʉkɨndɨlɨla ʉkʉjwega balɨnkʉtɨ, “Lɨnga gʉmmwabwile ʉmundʉ ʉjo, po ʉkaja mmanyaani gwa malafyale gwa Balooma. Ʉmundʉ gwesa ʉjʉ ikwipela ʉkʉja malafyale, ikʉmpɨnga ʉmalafyale gwa Balooma.” ");
INSERT INTO nyy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilati bo apɨliike amasyʉ ago, alɨnkʉntwala Jesu panja, alɨnkwakʉtʉʉgala pa kɨkota kya bʉlongi, ʉbʉjo ʉbʉ baatɨgɨ, Lwalo lwa Mabwe (ɨngamu ɨjɨ mu njobelo ɨjaa Bajuuta, bikʉtɨ Gabata). ");
INSERT INTO nyy_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kaalɨ kabalɨlo aka iisʉba lyalɨ pantʉ, pi isikʉ lya kwitendekesya kʉnongwa jaa kyaka kya Pasa. Pilati alɨnkʉkɨbʉʉla ɨkɨlʉndɨlo ɨkya bandʉ alɨnkʉtɨ, “Keeta, ʉmalafyale gwɨnu jo ʉjʉ!” ");
INSERT INTO nyy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Abeene balɨnkʉjwega balɨnkʉtɨ, “Nngoge, nngoge! Nkomelele pa kɨkohekano!” Pilati alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Bʉle, mukʉlonda nʉnkomelele pa kɨkohekano ʉmalafyale gwɨnu?” Abapuuti abalongosi balɨnkʉmmwamula balɨnkʉtɨ, “Ʉswe tʉkaja nagwe ʉmalafyale ʉjʉngɨ, looli mwene ʉmalafyale gwa Balooma!” ");
INSERT INTO nyy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Po kʉmmalɨɨkɨsyo Pilati alɨnkʉmmbɨɨka Jesu mmaboko gaabo ʉkʉtɨ bankomelele pa kɨkohekano. Po abasikali balɨnkʉmmwega Jesu nʉ kʉbʉʉka nagwe. ");
INSERT INTO nyy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Alɨnkʉpɨmba ɨkɨkohekano kyake, alɨnkʉsookamo nkaaja, alɨnkʉbʉʉka pabʉjo ʉbʉ mu njobelo jaabo bikʉtɨ Goligota, kokʉtɨ ʉLʉpaja lwa Ntʉ. ");
INSERT INTO nyy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bo bafikile pala, balɨnkʉnkomelela Jesu pa kɨkohekano. Pabʉjo bʉlabʉla baalipo abandʉ bamo babɨlɨ aba baabakomeliile pa fikohekano pamopeene nagwe, jʉmo kʉkɨbafu ɨkiilɨɨlo, nʉ jʉngɨ kʉkɨbafu ɨkiimama. ");
INSERT INTO nyy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilati alɨnkʉlagɨla ʉkʉtɨ gasimbigwe amasyʉ nʉ kʉgabɨɨka pa kɨkohekano kya Jesu, aga gikʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ʉbʉsimbe ʉbo bwasimbiigwe mu njobelo ɨjaa Bajuuta, aBalooma na Bagiliki. ABajuuta bingi baabalaga ʉbʉsimbe ʉbo, paapo pabʉjo ʉbo apa baalɨnkomeliile pa kɨkohekano, paalɨ kɨfuki na mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Po abapuuti abalongosi baalɨmmbʉʉlile Pilati ʉkʉtɨ, “Ʉlɨngasimbaga ʉkʉtɨ, ‘Ʉjʉ jo Malafyale gwa Bajuuta,’ looli ʉsimbe ʉkʉtɨ, ‘Ʉmundʉ ʉjʉ aajobile ʉkʉtɨ ʉmwene jo Malafyale gwa Bajuuta.’ ” ");
INSERT INTO nyy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilati alɨnkʉbaamula alɨnkʉtɨ, “Hɨmma, ʉbʉsimbe bʉsyale bʉbʉʉbo bo muno naalagiile.” ");
INSERT INTO nyy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Abasikali bo bankomeliile Jesu pa kɨkohekano, balɨnkwega ɨmyenda gyake, balɨnkʉjaba ɨfijabo fina. Kʉkʉtɨ nsikali alɨnkwega ɨkɨjabo kyake. Kangɨ balɨnkwega ʉnselekesye gwake. Ʉnselekesye ʉgʉ, gwalʉkiigwe ʉlʉpande lʉmolwene itolo ʉlwa mwenda, gʉkaalɨ nʉ bʉsone nabʉmo. ");
INSERT INTO nyy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Po balɨnkʉjobesania balɨnkʉtɨ, “Tʉlɨnganyaafulania ʉnselekesye ʉgʉ, looli tʉbombe ʉbʉlagʉsi ʉkʉtɨ gʉjege gwani.” Ɨsyo syabombiigwe ʉkʉtɨ siboneke ɨsi sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, “Baajabeene ɨmyenda gyangʉ, nʉ kʉbomba ʉbʉlagʉsi ʉbwa nselekesye gwangʉ.” Syo ɨsi baabombile abasikali. ");
INSERT INTO nyy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Po baalipo abakiikʉlʉ bamo bana aba baalyɨmile kɨfuki nɨ kɨkohekano kya Jesu. Abakiikʉlʉ abo aalipo ʉnna gwa Jesu, ʉnna ʉnnandɨ gwa Jesu, Malija ʉnkasi gwa Kilyopa, na Malija ʉgwa kʉ Magatala. ");
INSERT INTO nyy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesu bo ammbwene ʉnna, kangɨ nʉ mfundigwa ʉjʉ aalɨnnganile fiijo ɨɨmile kɨfuki nʉ nna, alɨnkʉtɨ, “Gwe jʉʉba, nkeete ʉjʉ. Mbɨɨke ʉkʉja mwanaako.” ");
INSERT INTO nyy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kangɨ alɨnkʉmmbʉʉla ʉmfundigwa jʉla alɨnkʉtɨ, “Nkeete ʉjʉ. Mbɨɨke ʉkʉja jo nyoko.” Po ʉkʉfuma akabalɨlo kalakala ʉmfundigwa jʉla alɨnkʉbʉʉka nʉ nna gwa Jesu, alɨnkwakʉtʉʉgala nagwe kʉkaaja kaake. ");
INSERT INTO nyy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Po Jesu alɨnkʉsyagania ʉkʉtɨ amalile ʉkʉjɨbomba ɨmbombo jaake. Po alɨnkʉjoba alɨnkʉtɨ, “Nʉʉmiilwe amɨɨsi.” Ʉlo syaboniike ɨsi sisimbiigwe mwa Kalata ʉMwikemo. ");
INSERT INTO nyy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pabʉjo bʉla kyalipo ɨkyombo ɨkɨ baaliiswisyemo ɨfinga ɨngalɨ ɨjɨ jɨlʉlile. Po balɨnkwega ɨsipanji, balɨnkʉjubɨka mu finga ɨjo, balɨnkʉfyɨka kʉ lʉtete, balɨnkʉntwalɨla Jesu kʉ ndomo. ");
INSERT INTO nyy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesu bo onjile ɨfinga ɨjo, alɨnkʉjoba alɨnkʉtɨ, “Ɨmbombo jangʉ jɨmaliike!” Po ʉntʉ gʉlɨnkʉgoboka, alɨnkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lyalɨ isikʉ ɨlya kwitendekesya, kangɨ ɨSabati jɨla lyalɨ isikʉ inywamu ʉkʉgakɨnda agangɨ. Kʉnongwa jaa kʉtɨ abalongosi baa Bajuuta bakaalondaga ʉmfimba gʉsyale pa kɨkohekano pi isikʉ ɨlya pa Sabati, po balɨnkʉbʉʉka kwa Pilati, balɨnkʉnsʉʉma ʉkʉtɨ abasikali babʉʉke bakabakonyole amalʉndɨ abandʉ aba baabakomeliile, nʉ kʉsoosyapo ɨmifimba gyabo pa fikohekano. ");
INSERT INTO nyy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Po balɨnkʉbʉʉka, balɨnkʉnkonyola amalʉndɨ ʉgwa kwanda nʉ gwa bʉbɨlɨ aba baabakomeliile pamopeene na Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Looli bo bikʉbʉʉka kwa Jesu, balɨnkwaga afwile, po bakaalɨnkonywile amalʉndɨ. ");
INSERT INTO nyy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Leelo ʉnsikali jʉmo alɨnkʉnndasa Jesu nɨ ngwego pa lʉbafu. Po iilopa na mɨɨsi filɨnkʉsooka. ");
INSERT INTO nyy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ɨnongwa ɨsi sisimbiigwe nʉ mundʉ ʉjʉ aasikeetaga ɨsi syabombigwaga. Ɨsi ikʉsijoba sya nalooli, kangɨ joope ameenye ʉkʉtɨ ɨsi ikʉjoba sya nalooli. Po ʉlo na nuumwe mwitɨkege. ");
INSERT INTO nyy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ɨsyo syabombiigwe ʉkʉtɨ siboneke ɨsi sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, “Ɨkɨfupa kyake nakɨmo ɨkɨ aakikʉkonyoka.” ");
INSERT INTO nyy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kangɨ Kalata ʉMwikemo ikʉtɨ, “Bikwisa kʉnkeetaga ʉjʉ baalɨnndasile.” ");
INSERT INTO nyy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ɨsyo bo sikɨndile, alɨnkwisa ʉmundʉ jʉmo ɨngamu jaake Joosefu ʉgwa mu Alimatai. Ʉmundʉ ʉjʉ aalɨ mfundigwa gwa Jesu, looli kʉbʉtiitʉ itolo, paapo aabatiilaga abalongosi baa Bajuuta. Po ʉmundʉ jʉla alɨnkʉbʉʉka kwa Pilati, alɨnkʉnsʉʉma ʉkʉtɨ agwege ʉmfimba gwa Jesu akasyɨle. Pilati alɨnkʉmmwitɨkɨsya. Po Joosefu alɨnkʉbʉʉka, alɨnkʉgʉsoosyapo ʉmfimba. ");
INSERT INTO nyy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Po Nikotemu, ʉjʉ akabalɨlo kamo aabʉʉkile kwa Jesu pakɨlo, alɨnkwisa na mafuta agaa lʉʉma ʉlʉnunu, gaalɨ kilo amalongo matatʉ. ");
INSERT INTO nyy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Po abandʉ babɨlɨ bala balɨnkwega ʉmfimba gwa Jesu, balɨnkʉgʉniembeteelela ʉmwenda ʉmwelu, balɨnkʉgʉpaka amafuta gala agaa lʉʉma ʉlʉnunu ʉkʉkongana nʉ lwiho ʉlwa Bajuuta ʉlwa kʉsyɨla abandʉ. ");
INSERT INTO nyy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pabʉjo apa baalɨnkomeliile Jesu gwalipo ʉngʉnda. Mu ngʉnda mula lyalimo iipʉmba iipya ɨlɨ bakaalɨnsyɨlilemo ʉmundʉ najʉmo. ");
INSERT INTO nyy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Iisikʉ ɨlyo, lyalɨ isikʉ ɨlya Bajuuta ʉkwitendekesya pa Sabati. Kʉnongwa ɨjo balɨnkʉnsyɨla Jesu mwi ipʉmba lɨla, paapo lyalɨ kɨfuki. ");
INSERT INTO nyy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nʉlʉbʉnjʉ fiijo bo bʉkaalɨ ʉkʉkya, pi isikʉ ɨlya pa ndʉngʉ, Malija ʉgwa kʉ Magatala alɨnkʉbʉʉka kwi ipʉmba lya Jesu. Alɨnkwaga ɨliibwe lɨla lɨbungulusiigwe ʉkʉfuma pa kɨfigo ɨkya ipʉmba. ");
INSERT INTO nyy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Po alɨnkʉbopa pala, alɨnkʉbʉʉka kwa Peeteli na kʉ mfundigwa jʉla, ʉjʉ Jesu aalɨnnganile fiijo. Alɨnkʉbabʉʉla alɨnkʉtɨ, “Abandʉ bamo bagʉsoosiisyemo ʉmfimba gwa Ntwa gwɨtʉ mwi ipʉmba, kangɨ tʉkakʉmanya kʉno bagʉbɨɨkile!” ");
INSERT INTO nyy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peeteli nʉ mfundigwa ʉjʉngɨ jʉla, balɨnkʉsookapo, balɨnkʉbʉʉka kwi ipʉmba. ");
INSERT INTO nyy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bobabɨɨlɨ baabopaga bo bikʉbʉʉka, looli ʉmfundigwa jʉla aabopile ʉkʉnkɨnda Peeteli, nʉ kʉntalɨlapo ʉkʉfika pi ipʉmba. ");
INSERT INTO nyy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Alɨnkwinama, alɨnkʉlingʉlɨla mwi ipʉmba, alɨnkʉgʉbona ʉmwenda ʉgʉ baalɨnsyɨliile Jesu, looli akaalingiile nkatɨ. ");
INSERT INTO nyy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Po Simoni Peeteli alɨnkʉnkonga, alɨnkʉfika pala, alɨnkwingɨla mwi ipʉmba nʉ kʉgwaga ʉmwenda ʉgʉ baalɨnsyɨliile Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kangɨ alɨnkʉkyaga nɨ kɨtambala ɨkɨ baalɨmpinyile Jesu kʉntʉ. Kɨkaalɨ pamopeene nɨ myenda ɨgɨngɨ, looli kyapindiigwe pasima, pambalɨ. ");
INSERT INTO nyy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Po ʉmfundigwa ʉjʉngɨ jʉla, ʉjʉ aatalilepo ʉkʉfika pala, joope alɨnkwingɨla mwi ipʉmba. Alɨnkʉkeeta, alɨnkwitɨka, ");
INSERT INTO nyy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","na paapo baakaalɨ ʉkʉsyagania ɨsya mwa Kalata ʉMwikemo ɨsi sikʉtɨ, Jesu mpaka asyʉke ʉkʉfuma mbafwe. ");
INSERT INTO nyy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Po abafundigwa bala balɨnkʉbʉʉka kʉmyabo. ");
INSERT INTO nyy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Looli Malija ʉgwa kʉ Magatala alɨnkʉsyala nʉ kwɨma panja pi ipʉmba, aalɨlaga. Bo alɨ pakʉlɨla, alɨnkwinama nʉ kʉlingʉlɨla mwi ipʉmba, ");
INSERT INTO nyy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","alɨnkʉbabona abandʉmi babɨlɨ aba baafwele ɨmyenda ɨmyelu. Baatʉʉgeele apa kʉbwandɨlo paalɨ nʉ mfimba gwa Jesu. Ʉgwandʉmi jʉmo aatʉʉgeele kʉntʉ, ʉjʉngɨ aatʉʉgeele kʉ malʉndɨ. ");
INSERT INTO nyy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Abandʉmi bala balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Gwe jʉʉba, fiki kʉlɨla?” Joope alɨnkʉbaamula alɨnkʉtɨ, “Abandʉ bamo bagʉsoosiisyepo ʉmfimba gwa Ntwa gwangʉ, kangɨ ngamanya na kʉno bagʉbɨɨkile!” ");
INSERT INTO nyy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Malija bo ajobile amasyʉ ago, alɨnkʉsanuka, alɨnkʉmmbona ʉmundʉ jʉmo ɨɨmile palapala. Ngɨmba ʉmundʉ jʉla aalɨ jo Jesu, looli Malija akaalɨmmeenye. ");
INSERT INTO nyy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesu alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Gwe jʉʉba, fiki kʉlɨla? Bʉle, kʉnndonda jwani?” Malija iinogonaga ʉkʉtɨ ʉmundʉ jʉla aalɨ mbombi ʉgwa mu ngʉnda, po alɨnkʉmmwamula alɨnkʉtɨ, “Gwe taata, lɨnga jo ʉgwe ʉgʉsoosiisyepo ʉmfimba gwake, mbʉʉla kʉno ʉgʉbɨɨkile, niine ngʉbʉʉka kʉkʉgwega.” ");
INSERT INTO nyy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesu alɨnkʉnkoolela ɨngamu jaake alɨnkʉtɨ, “Gwe Malija!” Po Malija alɨnkʉsanuka, alɨnkʉmmbona Jesu, alɨnkʉjoba mu njobelo jaake alɨnkʉtɨ, “Laboni!” Ɨngamu ɨjɨ kokʉtɨ Mmanyisi. ");
INSERT INTO nyy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Leka ʉlɨngangolaga. Ngaalɨ ʉkʉbʉʉka kʉmwanya kwa Taata. Po bʉʉka ʉkababʉʉle abakamu bangʉ, ʉkʉtɨ ngʉbʉʉka kʉmwanya kwa Taata, ʉjʉ jo Gwiseemwe, kwa Kyala gwangʉ ʉjʉ jo Kyala gwɨnu.” ");
INSERT INTO nyy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Po Malija ʉgwa kʉ Magatala alɨnkʉbʉʉka kʉ bafundigwa baa Jesu, alɨnkʉbabʉʉla ɨnongwa ɨsi, alɨnkʉtɨ, “Keeta, ʉne nʉmmbwene ʉNtwa!” Po alɨnkʉbalɨngaania syosa ɨsi Jesu aalɨnndagiile. ");
INSERT INTO nyy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Namajolo ɨliisikʉ lɨlalɨla, abafundigwa baa Jesu baabʉngeene mu nyumba jɨmo, nʉ kwigala ɨnyiigi paapo baabatiilaga abalongosi baa Bajuuta. Na paapo ɨnyiigi syaliigaliigwe, nakalɨnga Jesu alɨnkʉboneka pabwelu, nʉ kwɨma pakatɨ pamyabo, alɨnkʉbaponia alɨnkʉtɨ, “Mugonile, ʉlʉtengaano lʉjege na nuumwe!” ");
INSERT INTO nyy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Po alɨnkʉbanangɨsya amakoko agaa mmaboko na pa lʉbafu lwake. Abafundigwa bo bammbwene ʉNtwa, balɨnkʉhoboka fiijo. ");
INSERT INTO nyy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesu alɨnkʉbaponia kangɨ alɨnkʉtɨ, “Ʉlʉtengaano lʉjege na nuumwe. Bo ʉlʉ Taata aalɨndʉmile ʉne, bo lʉlʉʉlo na niine ngʉbatʉma ʉmwe pakiisʉ apa.” ");
INSERT INTO nyy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Po alɨnkʉbapuutɨla ʉmʉʉji, alɨnkʉbabʉʉla alɨnkʉtɨ, “Namwambɨlɨle Mbepo Mwikemo. ");
INSERT INTO nyy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Lɨnga mukʉbahobokela abandʉ ʉbʉtʉlanongwa bwabo, Kyala joope ikʉbahobokelaga ʉbʉtʉlanongwa bwabo. Lɨnga mutikʉbahobokela, Kyala joope atikʉbahobokelaga.” ");
INSERT INTO nyy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ʉmfundigwa jʉmo mbafundigwa baa Jesu, ɨngamu jaake Tomasi, ʉjʉ bantɨgɨ Mbasa, akaalɨ pamopeene na bafundigwa abangɨ bo Jesu ikʉbasetʉkɨla. ");
INSERT INTO nyy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Po abafundigwa abangɨ bala balɨnkʉmmbʉʉla balɨnkʉtɨ, “Ʉswe tʉmmbwene ʉNtwa.” Looli ʉmwene alɨnkʉbaamula alɨnkʉtɨ, “Ʉne ngabagɨla ʉkwitɨka ɨsyo lɨnga ngagabona taasi amakoko agaa misumali mmaboko gaake na pa lʉbafu lwake, nʉ kʉmpalamaasya nɨ nyoobe syangʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ʉndʉngʉ gʉmo bo gʉkɨndile, abafundigwa baa Jesu balɨnkʉbʉngaana pamopeene kangɨ nnyumba. Ɨliisikʉ ɨlyo joope Tomasi aalipo pamopeene nabo. Ɨnyiigi baaliigeele, nakalɨnga, Jesu alɨnkʉboneka pabwelu, alɨnkwɨma pakatɨ pamyabo, alɨnkʉbaponia alɨnkʉtɨ, “Mugonile. Ʉlʉtengaano lʉjege na nuumwe!” ");
INSERT INTO nyy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Po Jesu alɨnkʉmmbʉʉla Tomasi alɨnkʉtɨ, “Gwe Tomasi, isaga ʉpalamaasye nʉ loobe lwako mmaboko gangʉ. Kangɨ ʉpalamaasye na maboko gaako pa lʉbafu lwangʉ. Ʉlɨngendelelaga ʉkʉsita kwitɨka, looli gwitɨke.” ");
INSERT INTO nyy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi alɨnkʉmmwamula alɨnkʉtɨ, “Ʉgwe ʉlɨ Ntwa gwangʉ! Kangɨ gwe Kyala gwangʉ!” ");
INSERT INTO nyy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Gwitiike paapo ʉʉmbwene. Basajiigwe aba baanyiitiike na paapo bakaambona.” ");
INSERT INTO nyy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesu aabombile ɨfiika fii fingi ɨfingi, ɨfi abafundigwa baake baafibwene. Ɨfiika ɨfyo fikasimbigwa mwa kalata ʉjʉ. ");
INSERT INTO nyy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Looli ɨfiika ɨfi filimo mwa kalata ʉjʉ, fisimbiigwe ʉkʉtɨ mwitɨke ʉkʉtɨ Jesu jo Meesija, Mwana gwa Kyala, nʉ kʉtɨ kʉ njɨla jaa kʉmmwitɨka, mukabe ʉbʉʉmi bwa bwila na bwila mu ngamu jaake. ");
INSERT INTO nyy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Akabalɨlo bo kakɨndilepo panandɨ, Jesu alɨnkʉbasetʉkɨla kangɨ abafundigwa baake kʉmbalɨ kwa sʉmbɨ Galilai. ");
INSERT INTO nyy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Baalipo Simoni Peeteli, Tomasi ʉjʉ ɨngamu ɨjɨngɨ jo Mbasa, Natanaeli ʉjʉ aafumile mu Kana mu Galilai, abaana babɨlɨ abaa Sebetai, na bafundigwa abangɨ babɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Peeteli alɨnkʉbabʉʉla abanine alɨnkʉtɨ, “Ngʉbʉʉka kʉ nyanja kʉkʉloba ɨɨswɨ.” Abeene balɨnkʉmmwamula balɨnkʉtɨ, “Na nuuswe tukʉbʉʉka pamopeene na nungwe.” Po balɨnkʉbʉʉka, balɨnkwipaka mwi ibooti, baalobile ɨkɨlo kyosa, leelo bakaakolilepo ɨɨswɨ najɨmo. ");
INSERT INTO nyy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kʉbʉkye, Jesu alɨnkwɨma kʉmbalɨ kwa sʉmbɨ, leelo abafundigwa baake bakaameenye ʉkʉtɨ jo Jesu. ");
INSERT INTO nyy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Po Jesu alɨnkʉbakoolela alɨnkʉtɨ, “Mwe bamanyaani bangʉ, bʉle, mukolilepo ɨɨswɨ simo?” Abeene balɨnkʉmmwamula balɨnkʉtɨ, “Hɨmma.” ");
INSERT INTO nyy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesu alɨnkʉbabʉʉla alɨnkʉtɨ, “Namusope ʉlwelo kʉkɨbafu kya kʉ kiilɨɨlo ɨkya ibooti, mukʉkola ɨɨswɨ.” Po balɨnkʉsopa ʉlwelo mwa sʉmbɨ, leelo baatoliigwe ʉkʉlʉkwaba paapo baakolile ɨɨswɨ ɨnyingi fiijo. ");
INSERT INTO nyy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Po ʉmfundigwa jʉla ʉjʉ Jesu aalɨnnganile fiijo, alɨnkʉmmbʉʉla Peeteli alɨnkʉtɨ, “Jo Ntwa!” Simoni Peeteli bo apɨliike ʉkʉtɨ jo Ntwa, alɨnkʉfwala ʉmwenda gwake ʉgʉ aafuulile bo andile ʉkʉloba, alɨnkwitaaga mwa sʉmbɨ. ");
INSERT INTO nyy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Abafundigwa abangɨ bala balɨnkʉbʉʉka kʉmbalɨ kwa sʉmbɨ ni ibooti, paapo bakaalɨ patali, looli baalɨ ɨmitambo ɨmia jɨmo bʉno. Balɨnkʉlʉkwaba ʉlwelo ʉlʉ lwaliiswile ɨɨswɨ. ");
INSERT INTO nyy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bo bafikile kʉmbalɨ kwa sʉmbɨ, baagwagile ʉmooto. Pa mooto gʉla syalipo ɨɨswɨ nɨ kɨsyesye. ");
INSERT INTO nyy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Isaga, namutwale apa ɨɨswɨ simo ɨsi mulobile.” ");
INSERT INTO nyy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Po Peeteli alɨnkwingɨla mwi ibooti, alɨnkʉlʉkwabɨla kʉmbalɨ ʉlwelo lʉla ʉlʉ lwaliiswile ɨɨswɨ. Ndwelo lʉla syalimo ɨɨswɨ ɨnywamu 153. Na paapo syalimo ɨɨswɨ ɨnyingi fiijo, poope ʉlwelo lʉkaanyaafwike. ");
INSERT INTO nyy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesu alɨnkʉbabʉʉla abafundigwa baake alɨnkʉtɨ, “Isaga mulyemo ɨfindʉ.” Akaalipo ʉmfundigwa ʉjʉ aagelilepo ʉkʉnndaalʉʉsya ʉkʉtɨ, “Ʉgwe gwe gwani?” Paapo baameenye ʉkʉtɨ jo Ntwa. ");
INSERT INTO nyy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Po Jesu alɨnkwisa, alɨnkwega ɨkɨsyesye, alɨnkʉbapapo abafundigwa baake. Kangɨ alɨnkwega syope ɨɨswɨ, alɨnkʉbomba bo lʉlʉʉlo. ");
INSERT INTO nyy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ʉlo lwalɨ lwa katatʉ Jesu ʉkʉbasetʉkɨla abafundigwa baake, bo asyʉkile ʉkʉfuma mbafwe. ");
INSERT INTO nyy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bo baliile, Jesu alɨnkʉnndaalʉʉsya Peeteli alɨnkʉtɨ, “Simoni gwe mwana gwa Johani, bʉle, ʉʉnganile fiijo ʉkʉbakɨnda muno baanganiile abanino aba?” Peeteli alɨnkʉmmwamula alɨnkʉtɨ, “Moomuumo gwe Ntwa, ʉmeenye ʉkʉtɨ ngʉganile.” Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉtiimege ʉtʉngʼoosi twangʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesu alɨnkʉnndaalʉʉsya Peeteli ʉlwa bʉbɨlɨ alɨnkʉtɨ, “Simoni gwe mwana gwa Johani, bʉle ʉʉnganile?” Peeteli alɨnkʉmmwamula alɨnkʉtɨ, “Moomuumo gwe Ntwa, ʉmeenye ʉkʉtɨ ngʉganile.” Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉtiimege ɨngʼoosi syangʉ.” ");
INSERT INTO nyy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Alɨnkʉnndaalʉʉsya ʉlwa bʉtatʉ alɨnkʉtɨ, “Simoni gwe mwana gwa Johani, bʉle ʉʉnganile?” Po Peeteli alɨnkʉsulumania paapo aalɨnndaalʉʉsiisye ʉlwa bʉtatʉ ʉkʉtɨ, “Bʉle, ʉʉnganile?” Alɨnkʉmmwamula alɨnkʉtɨ, “Gwe Ntwa, ʉsimeenye syosa. Ʉmeenye ʉkʉtɨ ngʉganile.” Jesu alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉtiimege ɨngʼoosi syangʉ. ");
INSERT INTO nyy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nalooli nikʉkʉbʉʉla ʉgwe bo ʉlɨ ndʉmyana, gwaliisibiile ʉkʉfwala ɨmyenda gyako jʉjʉʉgwe, nʉ kʉbʉʉka koosa kʉno gwalondaga. Looli bo ʉkangeele, kʉgolosyaga amaboko gaako, ʉmundʉ ʉjʉngɨ ikʉkʉfwalɨsyaga ɨmyenda gyako, nʉ kʉbʉʉka na nungwe kʉno ʉkiigana ʉkʉbʉʉka.” ");
INSERT INTO nyy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesu aajobile bo ʉlo ʉkʉnangɨsya ɨnjɨla ɨjɨ Peeteli ikwisa kʉfwɨla nʉ kʉntuufya Kyala. Po Jesu alɨnkʉmmbʉʉla Peeteli alɨnkʉtɨ, “Ʉngongege.” ");
INSERT INTO nyy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Po Peeteli alɨnkʉsanuka, alɨnkʉmmbona ʉmfundigwa ʉjʉ Jesu aalɨnnganile fiijo, aabakongaga. Ʉmfundigwa ʉjo jo jʉla aalɨmmwegamiile Jesu bo bikʉlya ɨfindʉ, nʉ kʉnndaalʉʉsya ʉkʉtɨ, “Gwe Ntwa, jo jwani aikʉkʉlɨɨla?” ");
INSERT INTO nyy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Po Peeteli bo ammbwene ʉmfundigwa jʉla, alɨnkʉnndaalʉʉsya Jesu alɨnkʉtɨ, “Gwe Ntwa, bʉle, fiki aafikʉboneka kʉ mfundigwa ʉjo?” ");
INSERT INTO nyy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesu alɨnkʉmmwamula alɨnkʉtɨ, “Lɨnga ngʉlonda ʉkʉtɨ aje mʉʉmi mpaka akabalɨlo aka angʉgomoka, fiki ɨsyo sikʉkʉtaamya? Ʉgwe ʉngongege.” ");
INSERT INTO nyy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kʉnongwa ɨjo, abafundigwa bingi biinogonaga ʉkʉtɨ ʉmfundigwa ʉjo atiisakʉfwamo sikʉ. Looli Jesu akammbʉʉlaga ʉmfundigwa ʉjo ʉkʉtɨ atiisakʉfwamo sikʉ, looli aatile, “Lɨnga ngʉlonda ʉkʉtɨ aje mʉʉmi mpaka akabalɨlo aka angʉgomoka, fiki ɨsyo sikʉkʉtaamya?” ");
INSERT INTO nyy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ʉmfundigwa ʉjo jo ʉjʉ ikʉsisimɨkɨsya ɨsi nʉ kʉsisimba. Nuuswe tʉmeenye ʉkʉtɨ ɨsi ikʉjoba sya nalooli. ");
INSERT INTO nyy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Silipo ɨsingi ɨnyingi ɨsi Jesu aabombaga. Lɨnga syosa ɨsyo syasimbiigwe, ngwaga pakiisʉ poosa pakaafwanaga ʉkʉbɨɨkamo baakalata aba baasimbigwaga.");
INSERT INTO nyy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mwitɨki mwinangʉ Tyofili, mwa kalata gwangʉ jʉla ʉgwa kwanda, naasimbile syosa ɨsi Jesu aabombaga nʉ kʉmanyisya, ʉkʉfuma kʉbwandɨlo bwa mbombo jaake, ");
INSERT INTO nyy_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ʉkʉfika pi isikʉ lɨla aalyegiigwe ʉkʉfyʉka kʉmwanya, bo abalagiile kʉ njɨla jaa Mbepo Mwikemo abatʉmigwa aba aabasʉngwile. ");
INSERT INTO nyy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kʉ masikʉ amalongo mana bo asyʉkile ʉkʉfuma mbʉfwe, aabasetʉkɨlaga abatʉmigwa bala kaa kingi, kʉ njɨla nyingi, ʉkʉbanangɨsya ʉkʉtɨ ʉmwene nalooli mʉʉmi. Aajobaga nabo ɨnongwa ɨsya Bʉnyafyale bwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ɨliisikʉ lɨmo, bo Jesu aaganiile na batʉmigwa baake, alɨnkʉbalagɨla alɨnkʉtɨ, “Mulɨngasookangamo mu Jelusalemu, looli muguulɨle ʉkwambɨlɨla Mbepo Mwikemo ʉjʉ Taata aafingile, ʉjʉ mwapɨliike bo ngʉjoba ɨnongwa syake. ");
INSERT INTO nyy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Namanga Johani ʉMoosi aaboosyaga abandʉ na mɨɨsi, looli amasikʉ manandɨ aga gikwisa, ʉmwe aamukoosigwaga na Mbepo Mwikemo.” ");
INSERT INTO nyy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Akabalɨlo akangɨ bo Jesu aaganiile na batʉmigwa baake, balɨnkʉnndaalʉʉsya balɨnkʉtɨ, “Bʉle Ntwa, akabalɨlo aka ko kaa kʉbagomokesya aBanyaisilaɨli ʉbʉnyafyale bwabo?” ");
INSERT INTO nyy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Alɨnkʉbaamula alɨnkʉtɨ, “Ɨliisikʉ na kabalɨlo kaa kʉbombigwa, afibaatiike Taata, jɨkaja mbombo jɨɨnu ʉkʉmanya. ");
INSERT INTO nyy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Looli mukwisa kwambɨlɨla amaka bo Mbepo Mwikemo abasulukiile, po mukʉʉfumusyaga mu Jelusalemu, moosa nkiisʉ ɨkya Jutai nɨ kya mu Samalija, ʉkwakʉfika kʉno kɨmalɨkiile ɨkiisʉ.” ");
INSERT INTO nyy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jesu bo amalile ʉkʉjoba ɨsyo, boosa bo bikʉnkeeta, alɨnkwegigwa ʉkʉfyʉka kʉmwanya, ibɨngo lɨlɨnkʉmfisa, balɨnkʉtoligwa ʉkʉmmbona kangɨ. ");
INSERT INTO nyy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bo bakaalɨ balʉʉsamiile kʉmwanya, bo ikʉfyʉka, nakalɨnga balɨnkʉboneka abanyambala babɨlɨ aba baafwele ɨmyenda ɨmyelu, bɨɨmile kɨfuki nabo. ");
INSERT INTO nyy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Balɨnkʉtɨ, “Ʉmwe mwe banyambala baa mu Galilai, fiki mwɨmile apa mulʉʉsamiile kʉmwanya? Jesu ʉjʉ anyakiigwe kʉmyɨnu ʉkʉbʉʉka kʉmwanya, muno mummboniile bo ikʉfyʉka kʉmwanya, ikwisa kʉgomoka kangɨ bo lʉlʉʉlo.” ");
INSERT INTO nyy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Po abatʉmigwa baa Jesu balɨnkʉsookapo pa Kyamba kya Misyʉngʉtɨ, balɨnkʉbʉʉka mu Jelusalemu, paalɨ kɨfuki ɨkilomita jɨmo ʉkʉfuma pa kyamba kɨla. ");
INSERT INTO nyy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bo bafikile nkaaja balɨnkwingɨla nnyumba, balɨnkʉfyʉka nkyumba ɨkya kʉ golofwa muno baatʉʉgalaga. Baalimo baa Peeteli, Johani, Jaakobo, Andeleja, Filipo, Tomasi, Balitolomai, Matai, Jaakobo ʉmwana gwa Alifai, Simoni ʉndwɨla kiisʉ kyake, na Juuta ʉmwana gwa Jaakobo. ");
INSERT INTO nyy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Boosa babaaba baaganilaga bwila pakwipuuta, pamopeene na bakiikʉlʉ, na Malija ʉnna gwa Jesu, na baamyabo baa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ɨliisikʉ lɨmo Peeteli aalyɨmile pakatɨ pa biitɨki, bo babʉngeene. Boosa baalɨ bandʉ ɨmia jɨmo na malongo mabɨlɨ bʉno. ");
INSERT INTO nyy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Alɨnkʉbabʉʉla alɨnkʉtɨ, “Mwe baamyɨtʉ, syalondigwaga mpaka sibombiigwe ɨsi sisimbiigwe mwa Kalata ʉMwikemo. Ɨsyo ijolo aasijobile Ndaabɨti kʉ njɨla jaa Mbepo Mwikemo, ɨsya Juuta ʉjʉ aabalongwisye aba baalɨnkolile Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Juuta aalɨ gwa nkɨbugutɨla kyɨtʉ, twabombaga ɨmbombo pamopeene nagwe. ");
INSERT INTO nyy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","20","Sisimbiigwe mwa kalata ʉgwa Ɨsabʉli ʉkʉtɨ, ‘Akaaja kaake na kajege kɨsaame, kangɨ angatʉʉgasyangamo ʉmundʉ najʉmo.’ ” (Juuta aalyʉlile ʉngʉnda nɨ ndalama ɨsi aakabiile mbʉniongafu, alɨnkʉgwɨla ʉlwanda, alɨnkʉpʉfuka nʉ bʉla bwake bʉlɨnkʉsooka panja. Ɨnongwa ɨsyo syafumwike kʉ bandʉ boosa aba baatʉʉgalaga mu Jelusalemu, po ʉngʉnda gʉla balɨnkʉgʉkoolela ɨngamu jaa Akelitama, mu njobelo jaabo kokʉtɨ ʉNgʉnda gwa Ilopa.) Peeteli alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Sisimbiigwe kangɨ mwa kalata gwa Ɨsabʉli ʉkʉtɨ, ‘Ʉmundʉ ʉjʉngɨ apyanilepo pabʉjo bwake ʉbwa bʉlongosi.’ ");
INSERT INTO nyy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Kʉnongwa ɨjo tʉnsale ʉmundʉ jʉmo ndɨ aba baajaga na nuuswe akabalɨlo koosa aka ʉNtwa Jesu asyʉngʉʉtɨlaga na nuuswe. Ʉjo ikʉlondigwa ʉkʉja jo jʉmo ndɨ bala baajaga na nuuswe, ");
INSERT INTO nyy_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ʉkwandɨla akabalɨlo aka Johani ʉMoosi oosyaga, mpaka iisikʉ ɨlɨ Jesu aanyakiigwe kʉmyɨtʉ ʉkʉfyʉka kʉmwanya. Ikʉjaga nkeeti pamopeene na nuuswe ʉkʉfumusya ʉkʉsyʉka kwa Jesu.” ");
INSERT INTO nyy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Po paapo balɨnkʉbajoba abandʉ babɨlɨ. Jʉmo ɨngamu jaake aalɨ jo Joosefu, ɨjɨngɨ bantɨgɨ Balisaba, ʉjʉ kangɨ bankoolelaga ɨngamu ɨjaa Jusiti. Ʉgwa bʉbɨlɨ, ɨngamu jaake aalɨ jo Matija. ");
INSERT INTO nyy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Po balɨnkwipuuta balɨnkʉtɨ, “Gwe Ntwa, ʉsimeenye ɨndumbula sya bandʉ boosa. Ʉtʉnangɨsye abandʉ babɨlɨ aba, jo alɨkʉ ʉjʉ gʉnsalile, ");
INSERT INTO nyy_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ʉkʉtɨ apyanilepo pa mbombo jaa bʉtʉmigwa ɨjɨ Juuta aajɨlekile, po afwile, abʉʉkile pabʉjo bwa bala batikʉmmwitɨka ʉNtwa Jesu.” ");
INSERT INTO nyy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Po balɨnkʉbomba ʉbʉlagʉsi kʉ bandʉ babɨlɨ bala. Ʉbʉlagʉsi bʉlɨnkʉnangɨsya ɨngamu jaa Matija, jo alɨnkʉja pamopeene na batʉmigwa bala kalongo na jʉmo. ");
INSERT INTO nyy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Iisikʉ lya Pentekositi bo lɨfikile, abandʉ boosa aba baalɨmmwitiike Jesu, baabʉngeene pabʉjo bʉmobwene. ");
INSERT INTO nyy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nakalɨnga akoogo kalɨnkʉfuma kʉmwanya, kalɨnkʉfwana koobela kwa mbelo gwa maka, kalɨnkwisʉla nnyumba joosa ɨjɨ baatʉʉgeelemo. ");
INSERT INTO nyy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Po balɨnkʉsibona ɨndɨmi ngatɨ sya mooto, silɨnkʉbalanila nʉ kʉnsulukɨla kʉkʉtɨ mundʉ ʉjʉ aalipo pala. ");
INSERT INTO nyy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Boosa balɨnkwisʉla Mbepo Mwikemo, balɨnkwanda ʉkʉjoba mu njobelo ɨsingi, bo muumo Mbepo Mwikemo aabapaga ʉkʉjoba. ");
INSERT INTO nyy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mu Jelusalemu baalimo aBajuuta aba bantiilaga Kyala, baafumile mfiisʉ fyosa ɨfya panja. ");
INSERT INTO nyy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Abandʉ abo bo bapɨliike ɨliisyʉ ɨlya koogo, balɨnkwisa kʉ bwingi pala. Balɨnkwalangana paapo kʉkʉtɨ mundʉ aajɨpɨlɨkaga ɨnjobelo jaake jikʉjobigwa na biitɨki bala. ");
INSERT INTO nyy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Balɨnkʉswiga, balɨnkʉjoba balɨnkʉtɨ, “Keeta aba boosa bikʉjoba bo ʉlo, bakaja Bagalilai? ");
INSERT INTO nyy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Silɨ bʉleebʉle, ʉswe kʉkʉtɨ mundʉ ikʉbapɨlɨka bikʉjoba mu njobelo jaake, ɨjɨ aapaapiigwe najo? ");
INSERT INTO nyy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Balipo abandʉ baa mu Palitija, Metija, Elamu, abandʉ baa mu Mesopotamija, Jutai, Kapatokija, Ponti, Asija, ");
INSERT INTO nyy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Filigija, Pamfilija, Misili, kʉkɨbafu kya Libija kɨfuki na Kilene, abaheesya ʉkʉfuma kʉ Looma, ");
INSERT INTO nyy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","aBajuuta na bandʉ aba bingiile ndwitɨko lwa Bajuuta, aBakileti na Baalabu. Ʉswe twesa tukʉpɨlɨka bikʉjoba mu njobelo syɨtʉ ɨmbombo ɨngʉlʉmba ɨsi abombile Kyala!” ");
INSERT INTO nyy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Boosa balɨnkʉswiga nʉ kwalangana, balɨnkwanda ʉkʉlaalʉʉsania balɨnkʉtɨ, “Kalɨ, sikʉnangɨsya ɨfiki sisiisi?” ");
INSERT INTO nyy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Looli bamo balɨnkʉʉgɨɨla balɨnkʉtɨ, “Abandʉ aba bagaalile ʉbwalwa.” ");
INSERT INTO nyy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Po Peeteli alɨnkwɨma pamopeene na batʉmigwa bala kalongo na jʉmo, alɨnkʉlaata ʉkʉbalʉmbɨlɨla alɨnkʉtɨ, “Mwe Bajuuta biinangʉ, na mwesa mwe mukʉtʉʉgala mu Jelusalemu, musimanyege ɨnongwa ɨsi siboniike kʉmyɨnu, mupɨlɨkɨsye ɨsi ngʉjoba. ");
INSERT INTO nyy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mungɨ muno mukʉbiinogonela, abandʉ aba bakagaala. Ʉlʉ lʉbʉnjʉ, ɨsala jaa 3:00! ");
INSERT INTO nyy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Looli ɨsi syo ɨsi ʉnkunguluka Joeli aakungulwike aatile, ");
INSERT INTO nyy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Kyala ikʉjoba ikʉtɨ, Mmasikʉ agaa kʉʉsulo, nikwisa kʉboonela Mbepo gwangʉ abandʉ boosa. Abaanɨɨnu abanyambala na balɨndwana bikwisa kʉkungulukaga, abaanɨɨnu abalʉmyana bikwisa kʉfibonaga ɨfya mbʉsetʉka, kangɨ abanyambala abakangale bikwisa kʉgogwaga ɨnjosi. ");
INSERT INTO nyy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Na boope ababombeli bangʉ, abanyambala na bakiikʉlʉ, nikwisa kʉboonela Mbepo gwangʉ, bikwisa kʉkungulukaga. ");
INSERT INTO nyy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ngwisa kʉbomba ɨfiika kʉmwanya mu mpaalanga, nɨ fimanyilo paasi pakiisʉ. Pakiisʉ apa fikwisa kʉboneka ɨfya ilopa, ʉmooto nɨ lyosi ɨlɨ likʉfuuka ngatɨ lʉbeefu. ");
INSERT INTO nyy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kʉmwanya, iisʉba likwisa kwinɨsigwa ʉkʉja ngiisi, ʉmwesi gukwisa kʉja nkeseefu ngatɨ ilopa. Fyosa ɨfyo fikwisa kʉboneka, bo lɨkaalɨ ʉkwisa ɨliisikʉ lya Ntwa ikʉlʉmba iisisya. ");
INSERT INTO nyy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kʉkʉtɨ mundʉ ʉjʉ ikʉsʉʉmɨla mu ngamu jaa Ntwa, ikʉpokigwa.’ ” ");
INSERT INTO nyy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Peeteli alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Mwe Banyaisilaɨli, amupɨlɨkɨsye amasyʉ aga! Jesu ʉgwa mu Nasaleti, aalɨ mundʉ ʉjʉ Kyala aabanangiisye ʉkʉtɨ aalɨntʉmile kʉmyɨnu, nɨ fiika, ɨfiswigo nɨ fimanyilo. Kyala aafibombile pakatɨ pamyɨnu, ʉkwendela mwa Jesu, bo muno musimanyiile ʉmwe. ");
INSERT INTO nyy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kyala ʉkʉkongana nʉ lʉbaatɨko lwake, aatumwile ʉkʉbaninga ʉmwe Jesu. Ʉmwe mwalɨnngogile, kʉ njɨla jaa kʉnninga Jesu kʉ bapanja ʉkʉtɨ bankomelele pa kɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Looli Kyala aalɨnsyʉsiisye Jesu, aalɨmmwabwile ʉkʉfuma mu ngʉbɨlo sya bʉfwe, paapo ʉbʉfwe bʉkaabagiile ʉkʉmpinya Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ʉmalafyale Ndaabɨti aajobile bo ʉlo ɨsya Jesu aatile, ‘Nammbonaga ʉNtwa Kyala nkyeni mmyangʉ bwila, ʉkʉtɨ ndɨngajʉngaanikaga, paapo ntʉʉli gwangʉ bwila. ");
INSERT INTO nyy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Fyobeene ɨndumbula jangʉ jikʉhoboka, ʉlʉlɨmi lwangʉ lukʉluluutɨla nʉ lʉsekelo. Kangɨ ndɨ nʉ lʉsʉʉbɨlo, ʉmbɨlɨ gwangʉ gukʉja mʉʉmi, ");
INSERT INTO nyy_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","paapo ʉgwe ʉtikʉʉndeka ʉne mbʉsyʉka, kangɨ ʉtikwitɨkɨsya ʉkʉtɨ ʉmbɨlɨ gwa Mwikemo gwako gʉbolege. ");
INSERT INTO nyy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gʉʉnangiisye ɨnjɨla ɨsi sikʉtwala kʉ bʉʉmi, kwisa kʉʉhobosya fiijo, ʉkʉjapo apa ndipo.’ ” ");
INSERT INTO nyy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Peeteli alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Mwe baamyɨtʉ, ngʉlonda ʉkʉbabʉʉla pabwelu ɨsya mwisʉkʉlʉ gwɨtʉ Ndaabɨti, ʉkʉtɨ joope aafwile nʉ kʉsyɨligwa. Iipʉmba lyake lɨlipo apa pamyɨtʉ mpaka lɨɨlɨno. ");
INSERT INTO nyy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Paapo Ndaabɨti aalɨ nkunguluka, kangɨ aameenye ʉkʉtɨ Kyala aalapile nʉ lʉfingo, ʉkʉtɨ ʉmundʉ jʉmo ʉgwa ndʉjungu lwake, ikwisa kʉtʉʉgalaga pa kɨkota kyake Ndaabɨti ɨkya bʉtwa. ");
INSERT INTO nyy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ndaabɨti bo asiboniile ngaani ɨsya nkyeni, aasijobile ɨsya kʉsyʉka Meesija, ʉkʉtɨ Kyala akaalɨnndekile mbʉsyʉka, ʉmbɨlɨ gwake gʉkaabolile. ");
INSERT INTO nyy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Po Kyala aalɨnsyʉsiisye Jesu Kɨlɨsiti, ʉswe twesa tʉlɨ bakeeti baake. ");
INSERT INTO nyy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jesu bo afyʉsiigwe na Kyala ʉkʉtʉʉgala pabʉjo ʉbwɨmɨkigwa, kʉkɨbafu ɨkiilɨɨlo ɨkya Kyala, ambɨliile ʉlʉfingo lwa Mbepo Mwikemo kwa Taata, po joope oonile ɨsi na nuumwe mukʉsibona nʉ kʉsipɨlɨka. ");
INSERT INTO nyy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Ndaabɨti akaafyʉkileko kʉmwanya, leelo ʉmwene ikʉjoba ikʉtɨ, ‘ɄNtwa Kyala aalɨmmbʉʉlile ʉNtwa gwangʉ, “Itʉʉgasye kʉkɨbafu kyangʉ ɨkiilɨɨlo, ʉbʉjo ʉbwa lwɨmɨko fiijo, ");
INSERT INTO nyy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ʉkʉfika apa nikʉbabɨɨkaga abalʉgʉ baako paasi pa malʉndɨ gaako.” ’ ” ");
INSERT INTO nyy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Peeteli alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Po aBanyaisilaɨli boosa basyaganie kɨsita kwilaamwa ʉkʉtɨ Kyala ammbɨɨkile Jesu ʉkʉja jo Ntwa, kangɨ jo Meesija, ʉjʉ ʉmwe mwalɨnkomeliile pa kɨkohekano.” ");
INSERT INTO nyy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Po abandʉ bo bapɨliike amasyʉ ago, baalasiigwe mu ndumbula syabo. Balɨnkʉbalaalʉʉsya Peeteli na batʉmigwa banine balɨnkʉtɨ, “Baamyɨtʉ, tʉbombe ɨfiki leelo?” ");
INSERT INTO nyy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peeteli alɨnkʉbaamula alɨnkʉtɨ, “Amupɨndʉke, kʉkʉtɨ mundʉ oosigwe mu ngamu jaa Jesu Kɨlɨsiti, ʉkʉtɨ mulwage ʉlʉhobokelo lwa bʉtʉlanongwa bwɨnu, kangɨ mukwambɨlɨlaga ɨkɨkʉngɨlwa kya Mbepo Mwikemo. ");
INSERT INTO nyy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Namanga ʉlʉfingo ʉlo lwɨnu, lwa baanɨɨnu, kangɨ lwa bandʉ boosa aba balɨ kʉbʉtali, lwa boosa aba ʉNtwa Kyala gwɨtʉ ikʉbakoolelaga.” ");
INSERT INTO nyy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peeteli alɨnkʉbasisimɨkɨsya na masyʉ agangɨ gaa mingi, alɨnkʉbalamba alɨnkʉtɨ, “Amwipoke kʉ bandʉ abaniongafu abaa nkabalɨlo aka.” ");
INSERT INTO nyy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Abandʉ aba baagiitiike amasyʉ gaake balɨnkoosigwa, abandʉ 3,000 bʉno baalingiile nkɨpanga kya Kyala iisikʉ lɨla. ");
INSERT INTO nyy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Abiitɨki abo baasikongaga ɨmanyisyo sya batʉmigwa nɨ ndumbula joosa, nʉ kʉkeetana, ʉkʉmenya ɨkɨsyesye nʉ kwipuuta. ");
INSERT INTO nyy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kʉkʉtɨ mundʉ alɨnkʉswiga fiijo kʉ fiswigo ni fimanyilo fingi ɨfi abatʉmigwa baabombaga. ");
INSERT INTO nyy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Abiitɨki boosa balɨnkʉja kandʉ kamokeene, fyosa balɨnkʉlɨɨlanila. ");
INSERT INTO nyy_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bʉʉlɨsyaga ɨkyʉma kyabo nʉ tʉndʉ twabo, baajabaga ɨndalama ɨsi bakabile, kʉ mundʉ gwesa ʉkʉkongana nʉ bʉtolwe bwake. ");
INSERT INTO nyy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Baakomaanaga bwila nɨ ndumbula jɨmojeene ndʉpaso lwa tempeli, baamenyaniaga ɨkɨsyesye mu nyumba syabo nʉ kʉlya ɨfindʉ fyabo pamopeene, nʉ lʉsekelo nɨ ndumbula ɨsangalʉfu. ");
INSERT INTO nyy_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bantuufyaga Kyala nʉ kʉja bakʉndwe kʉ bandʉ boosa. Kʉkʉtɨ isikʉ ʉNtwa alɨnkongelapo nkɨbugutɨla abandʉ aba baapokigwaga. ");
INSERT INTO nyy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ɨliisikʉ lɨmo Peeteli na Johani baalongoseenie ʉkʉbʉʉka ndʉpaso lwa tempeli, ɨsala jaa 9:00 pamuusi, akabalɨlo kaa kwipuuta. ");
INSERT INTO nyy_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ndʉpaso lwa tempeli aalipo ʉmundʉ jʉmo ʉjʉ aakwemaga, aalemeele ʉkʉfuma munda mu nna. Aapɨmbigwaga na bandʉ kʉkʉtɨ isikʉ, bammbɨɨkaga pa kɨpata kya tempeli, ɨngamu jaake ɨKɨpata ɨKɨnunu, ʉkʉtɨ asʉʉmege ɨndalama kʉ bandʉ aba bikwingɨla ndʉpaso lwa tempeli. ");
INSERT INTO nyy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ʉmundʉ ʉjo bo ikʉbabona Peeteli na Johani balɨ kɨfuki ʉkwingɨla ndʉpaso lwa tempeli, alɨnkʉbasʉʉma ɨndalama. ");
INSERT INTO nyy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Po Peeteli na Johani balɨnkʉnngʼaatulɨla amaaso, Peeteli alɨnkʉmmbʉʉla alɨnkʉtɨ, “Tʉkeete ʉswe!” ");
INSERT INTO nyy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Alɨnkʉbakeeta, alɨnkʉsʉʉbɨla ʉkʉkaba fimo kʉmyabo. ");
INSERT INTO nyy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Looli Peeteli alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉne ngaja nɨ ndalama, looli ɨfi ndɨ nafyo fyo ngʉkʉpapo. Mu ngamu jaa Jesu Kɨlɨsiti ʉgwa mu Nasaleti, sumuka gwendege!” ");
INSERT INTO nyy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Po Peeteli alɨnkʉnkola ɨkɨboko ɨkiilɨɨlo, alɨnkʉmmwinʉla. Nakalɨnga ɨnjajo nɨ fipuuto fya malʉndɨ gaake filɨnkʉkaba amaka. ");
INSERT INTO nyy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Alɨnkwɨma nakalɨnga nʉ kwanda ʉkwenda, alɨnkwingɨla nabo ndʉpaso lwa tempeli kʉno ikʉnyeela nyeela nʉ kʉntuufya Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Abandʉ boosa balɨnkʉmmbona ʉmundʉ jʉla ikwenda nʉ kʉntuufya Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bo basyageenie ʉkʉtɨ jo jʉla aatʉʉgalaga pa Kɨpata ɨKɨnunu ɨkya tempeli, ʉkʉsʉʉma ɨfya bʉsʉsɨlwa, lʉlɨnkʉbakola ʉlʉtende nʉ kʉswiga fiijo kʉlɨ ɨsi simmwagile. ");
INSERT INTO nyy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Po ʉmundʉ jʉla akaalondaga ʉkʉbaleka baa Peeteli na Johani. Abandʉ boosa balɨnkʉswiga fiijo ʉkʉbʉmbʉlʉka kwake, balɨnkʉbabopela mwi ibalaasa ɨlɨ baatɨgɨ Solomoni, ndʉpaso lwa tempeli. ");
INSERT INTO nyy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peeteli bo ababwene abandʉ bala, alɨnkʉbabʉʉla alɨnkʉtɨ, “Mwe Banyaisilaɨli, fiki mukʉswiga ɨsi? Fiki mutʉlʉʉsamiile, ngatɨ kʉ maka gɨɨtʉ pamo kʉ bwikemo bwɨtʉ tʉpelile ʉmundʉ ʉjʉ ʉkwenda? ");
INSERT INTO nyy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kyala gwa biisʉkʉlʉ bɨɨtʉ, Kyala gwa Abulahamu, Isaka na Jaakobo, ammwɨmiike ʉmbombeli gwake Jesu. Ʉmwe mwajile kʉmmbɨɨka kwa Pilati ʉkʉtɨ alongigwe, mulɨnkʉnkaana nkyeni mwa Pilati, bo ʉmwene alongile ʉkʉtɨ Jesu aabʉligwe. ");
INSERT INTO nyy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Looli ʉmwe mulɨnkʉnkaana ʉMwikemo jʉla kangɨ ʉNgolofu, mulɨnkʉsʉʉma ʉkʉtɨ bammwabʉle ʉngogi. ");
INSERT INTO nyy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ʉmwene jo Mpeli gwa bʉʉmi, ʉmwe mwalɨnngogile. Looli Kyala aalɨnsyʉsiisye ʉkʉfuma mbʉfwe, po ʉswe tʉlɨ bakeeti baa kʉsyʉka kwake. ");
INSERT INTO nyy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ʉmundʉ ʉjʉ mukʉmmbona apa, mummeenye fiijo. Akabile amaka kʉ njɨla jaa ngamu jaa Jesu. Kʉ nongwa jaa kwitɨka ɨngamu ɨjo nʉ kʉmmwitɨka Jesu, abʉmbʉlwike loosa, bo ʉlʉ mwesa mukeetile. ");
INSERT INTO nyy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Po lɨɨlɨno baamyɨtʉ, ʉne mmeenye ʉkʉtɨ mwasibombile ɨsi kɨsita kʉsyagania, bo ʉlʉ abalongosi bɨɨnu baabombile. ");
INSERT INTO nyy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Looli ɨsyo Kyala asibombile ʉkʉkongana na masyʉ aga aajobile ijolo ʉkwendela mbakunguluka baake boosa, ʉkʉtɨ Meesija gwake ikwisa kʉkʉbɨlwa. ");
INSERT INTO nyy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Po mupɨndʉke, musanukɨle kwa Kyala, ʉkʉtɨ abaswe loosa ʉbʉtʉlanongwa bwɨnu. ");
INSERT INTO nyy_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mubombe bo ʉlo ʉkʉtɨ ʉNtwa Kyala abapepo ʉtʉbalɨlo ʉtwa kʉsaala mu ndumbula. Kangɨ antʉme Jesu ʉjʉ jo Meesija, ʉjʉ aabɨɨkiigwe kʉnongwa jɨɨnu ʉkʉfuma liijolo. ");
INSERT INTO nyy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesu ikʉlondigwa ʉkʉsyala kʉmwanya mpaka pakabalɨlo akaa kʉtendekesya ʉbʉpya kʉkʉtɨ kandʉ, bo ʉlʉ Kyala aafingile ʉkʉfuma liijolo ʉkwendela mbakunguluka baake abiikemo. ");
INSERT INTO nyy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Bo ʉlʉ Moose aajobile aatile, ‘ɄNtwa Kyala gwɨnu ikwisa kʉbiinʉlɨla ʉnkunguluka bo ʉne ʉkʉfuma mmbandʉ bɨɨnu. Mwise mupɨlɨkɨsyege syosa ɨsi ikwisa kʉbabʉʉlaga. ");
INSERT INTO nyy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ʉmundʉ gwesa ʉjʉ atikwisa kʉmpɨlɨkɨsyaga ʉnkunguluka ʉjo, ikwisa kʉsoosigwangako kʉ bandʉ baa Kyala nʉ kʉpyutigwa.’ ");
INSERT INTO nyy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ʉkwandɨla ʉnkunguluka Samweli na bangɨ boosa aba baakongile, abakunguluka baajobaga ɨnongwa sya masikʉ agaa lɨɨlɨno. ");
INSERT INTO nyy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ʉmwe mulɨ baa kɨlɨngo kya bakunguluka na baa lwitɨkano ʉlʉ Kyala aabalagiile abiisʉkʉlʉ bɨɨnu. Aalɨmmbʉʉlile Abulahamu, ʉkʉtɨ, ‘Ɨfikolo fyosa ɨfya nkiisʉ fikʉsajigwaga ʉkwendela ndʉjungu lwako.’ ");
INSERT INTO nyy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Po Kyala bo abiinʉliile ʉmbombeli gwake Jesu, aalɨntʉmile taasi kʉmyɨnu ʉkʉtɨ abasaje, anngomole kʉkʉtɨ mundʉ ʉkʉtɨ abʉleke ʉbʉtʉlanongwa bwake.” ");
INSERT INTO nyy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peeteli na Johani bo balɨ pakʉjoba na bandʉ bala, nakalɨnga balɨnkwisa abapuuti, ʉnkʉlʉmba gwa basikali baa tempeli, na Basatukai bamo. ");
INSERT INTO nyy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Balɨnkʉkalala fiijo kʉnongwa jaa kʉtɨ Peeteli na Johani babamanyisyaga abandʉ nʉ kʉbalʉmbɨlɨla ʉkʉtɨ, Kyala ikʉbasyʉsya abafwe bo ʉlʉ ansyʉsiisye Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Po balɨnkʉbakola Peeteli na Johani, balɨnkʉbiigalɨla mu nnyololo mpaka nʉlʉbʉnjʉ, paapo gaalɨ majolo. ");
INSERT INTO nyy_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Looli abandʉ bingi ndɨ aba baapɨliike iisyʉ ɨlɨ baalʉmbɨlɨlaga Peeteli na Johani, baalɨmmwitiike Jesu. Abandʉ aba baalɨmmwitiike Jesu baafikile 5,000. ");
INSERT INTO nyy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Po paapo kɨlaabo kyake abapuuti abalongosi, abalongosi baa Bajuuta na bamanyisi baa ndagɨlo sya Moose, balɨnkʉbʉngaana mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Joope Anasi ʉmpuuti ʉnkʉlʉmba aalipo, pamopeene na Kajafa, Johani, Alikisanda na bakamu abangɨ abaa mpuuti ʉnkʉlʉmba. ");
INSERT INTO nyy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bo babɨɨmiike baa Peeteli na Johani nkyeni, balɨnkʉbalaalʉʉsya balɨnkʉtɨ, “Ʉmwe mubombile ɨsyo kʉ maka gaani, pamo kʉ ngamu jaani?” ");
INSERT INTO nyy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Peeteli alɨnkwisʉla Mbepo Mwikemo, alɨnkʉbabʉʉla alɨnkʉtɨ, “Mwe bapuuti abalongosi, na mwe balongosi baa bandʉ! ");
INSERT INTO nyy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ʉmwisyʉgʉ, ʉmundʉ ʉjʉ ikʉkwema abombeliigwe ɨmbombo ɨnunu, mukʉtʉlaalʉʉsya ʉswe ʉkʉtɨ abʉmbʉlwike bʉleebʉle. ");
INSERT INTO nyy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Po mumanyege ʉmwe na bandʉ boosa abaa mu Isilaɨli, ʉkʉtɨ ʉmundʉ ʉjʉ ɨɨmile nkyeni mmyɨnu abʉmbʉlwike mu ngamu jaa Jesu Kɨlɨsiti ʉgwa mu Nasaleti. Ʉjo jo ʉjʉ ʉmwe mwalɨnkomeliile pa kɨkohekano, Kyala aalɨnsyʉsiisye ʉkʉfuma mbʉfwe. ");
INSERT INTO nyy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesu ʉjo jo ʉjʉ Kalata ʉMwikemo ikʉtɨ, ‘Ɨliibwe ɨlɨ mwalɨkaanile mwe bajenga nyumba, lyo lɨjile ibwe ikʉlʉmba pa lwalo, pa nguto.’ ");
INSERT INTO nyy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Kʉnongwa ɨjo, bʉkajamo nabʉmo ʉbʉpoki ʉkʉfuma kʉ mundʉ ʉjʉngɨ, paapo jɨkajako ɨngamu ɨjɨngɨ, ɨjɨ tʉpeeliigwe pakiisʉ, ɨjaa ʉjʉ abagiile ʉkʉtʉpoka.” ");
INSERT INTO nyy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Abalongosi bala bo babʉbwene ʉbʉkifu bwa Peeteli na Johani nʉ kʉbamanya ʉkʉtɨ bakaja bamanya kalata, kangɨ bakaja bamangʼanyi, balɨnkʉswiga, balɨnkʉsyagania ʉkʉtɨ abandʉ aba baalɨ pamopeene na Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Looli bakaalɨ nalyo ɨliisyʉ ɨlya kʉbaamula, paapo baalɨmmbwene ʉmundʉ jʉla abʉmbʉlʉsiigwe, ɨɨmile pamopeene na Peeteli na Johani. ");
INSERT INTO nyy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Po balɨnkʉbalagɨla Peeteli na Johani ʉkʉtɨ basooke panja ʉkʉfuma nkyumba ɨkɨ baabombelaga ʉlʉkomaano lwa Sanihendilini. Abaa lʉkomaano balɨnkʉsyala, balɨnkʉjobesania bo biijeekiile, ");
INSERT INTO nyy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","balɨnkʉtɨ, “Tʉbombe ɨsya fiki na bandʉ aba? Paapo sifumwike kʉ bandʉ boosa aba bikʉtʉʉgala mu Jelusalemu, ʉkʉtɨ ɨkiika ɨkɨnywamu kɨbombiigwe nabo. Tʉkabagɨla nʉ kʉkaana. ");
INSERT INTO nyy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Looli ʉkʉtɨ ɨsi silɨngongelangapo ʉkʉfumuka, tʉbakemele, balɨngajobaga kangɨ nʉ mundʉ gwesa mu ngamu jaa Jesu.” ");
INSERT INTO nyy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Po balɨnkʉbakoolela Peeteli na Johani ʉkʉtɨ bingɨle, balɨnkʉbalagɨla balɨnkʉtɨ, “Mulɨngandɨsya ʉkʉjoba pamo ʉkʉmanyisya mu ngamu jaa Jesu, ɨnongwa syosa!” ");
INSERT INTO nyy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Looli Peeteli na Johani balɨnkʉbaamula balɨnkʉtɨ, “Bʉle, bʉgolofu nkyeni mwa Kyala ʉkʉbapɨlɨka ʉmwe ʉkʉkɨnda ʉkʉmpɨlɨka Kyala? Mulamule jʉjʉʉmwe, ");
INSERT INTO nyy_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","namanga ʉswe tʉkabagɨla ʉkʉleka ʉkʉsijoba ɨsi tʉsibwene nʉ kʉsipɨlɨka.” ");
INSERT INTO nyy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Abalongosi bo bongiilepo ʉkʉbakemela baa Peeteli na Johani, balɨnkʉbaabʉla. Baatoliigwe ɨnjɨla jaa kʉbafundɨlamo, kʉnongwa jaa kʉtɨ abandʉ boosa bantuufyaga Kyala kʉlɨ ɨsi sibombiigwe. ");
INSERT INTO nyy_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Namanga ʉmundʉ ʉjʉ aabombeliigwe ɨkɨmanyilo ɨkɨ ɨkya kʉbʉmbʉlʉsigwa, ɨfyɨnja fyake fyakɨndile amalongo mana. ");
INSERT INTO nyy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bo babalekiisye, Peeteli na Johani balɨnkʉbʉʉka kʉ biinaabo, balɨnkʉbabʉʉla ɨnongwa syosa ɨsi baabʉʉliigwe na bapuuti abalongosi na balongosi baa bandʉ. ");
INSERT INTO nyy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Abiinaabo bo bapɨliike ɨsyo, boosa palɨkɨmokyene balɨnkʉlaata ʉkʉnsʉʉma Kyala, balɨnkʉtɨ, “Gwe Mwene nafyo fyosa, gwe gwapelile ʉmpaalanga, ɨkiisʉ nɨ nyanja, na fyosa ɨfi filimo ʉmo. ");
INSERT INTO nyy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jo taata Ndaabɨti, ʉmbombeli gwako, aajobile amasyʉ kʉ njɨla jaa Mbepo Mwikemo ʉkʉtɨ, ‘Fiki ɨfikolo ɨfingi fikʉjobesania ʉkʉnsambʉkɨla Kyala? Kangɨ ɨfiisʉ fikwinogona ɨsya mwalo? ");
INSERT INTO nyy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Abanyafyale abaa mfiisʉ biitendekiisye, abalongosi bikʉjobesania pamopeene, ʉkʉnsambʉkɨla ʉNtwa, na Meesija gwake.’ ");
INSERT INTO nyy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Po nalooli ʉmalafyale Heloti, Pontio Pilati, pamopeene na Banyaisilaɨli na aba bakaja Banyaisilaɨli, baabʉngeene muno mu Jelusalemu, ʉkʉpanga ʉkʉnngoga Jesu ʉmbombeli gwako ʉmwikemo, ʉjʉ ʉmpakile amafuta ʉkʉja malafyale. ");
INSERT INTO nyy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Baabombile syosa ɨsi gwasibaatiike liijolo kʉ maka gaako nʉ bwigane bwako. ");
INSERT INTO nyy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Po gwe Ntwa Kyala, ʉkeetege ʉkʉtʉkemela kwabo, ʉtʉtʉʉle twe babombeli baako ʉkʉtɨ tʉlʉmbɨlɨlege iisyʉ lyako nʉ bʉkifu boosa. ");
INSERT INTO nyy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Setʉla amaka gaako ʉkʉbʉmbʉlʉsya abandʉ. Bomba ɨfiika ɨfikʉlʉmba mu ngamu jaa mbombeli gwako ʉmwikemo Jesu.” ");
INSERT INTO nyy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bo biipuutile kwa Kyala, palɨnkʉsenyendeka pabʉjo apa baabʉngeene. Boosa balɨnkwisʉla Mbepo Mwikemo, balɨnkwanda ʉkʉlʉmbɨlɨla iisyʉ lya Kyala nʉ bʉkifu boosa. ");
INSERT INTO nyy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Po abiitɨki boosa baalɨ nɨ ndumbula jɨmojeene na mu nyiinogono syabo baalɨ kandʉ kamokeene. Akaaliko najʉmo nkɨlʉndɨlo kyabo ʉjʉ aatɨgɨ ɨkyʉma ɨkɨ alɨ nakyo kyake mwene, looli ɨkyʉma kyabo kyosa baalɨɨlanilaga. ");
INSERT INTO nyy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Abatʉmigwa, kʉ maka amakʉlʉmba, baalʉmbɨlɨlaga ʉkʉtɨ ʉNtwa Jesu asyʉkile mbʉfwe. Kyala aabasajaga fiijo abiitɨki boosa. ");
INSERT INTO nyy_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Po akaalipo ʉmundʉ najʉmo ʉjʉ aafumbilwe nkɨbugutɨla kyabo, paapo aba baalɨ nɨ migʉnda pamo ɨnyumba bʉʉlɨsyaga, baatwalaga ɨndalama ɨsi bakabile. ");
INSERT INTO nyy_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Baabapaga abatʉmigwa ɨndalama ɨsyo ʉkʉtɨ basibɨɨkege, aajabɨligwaga kʉkʉtɨ mundʉ ʉkʉkongana nʉ bʉtolwe bwake. ");
INSERT INTO nyy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Aaliko ʉmundʉ jʉmo ɨngamu jaake Joosefu, ʉNnyaleebi, ʉkʉfuma nkiisʉ kya ndʉsʉngo lwa mu Saipulasi. Abatʉmigwa bankoolelaga ɨngamu ɨjɨngɨ Balinaba, kokʉtɨ ʉjʉ ikʉkasya. ");
INSERT INTO nyy_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aalyʉliisye ʉngʉnda gwake. Ɨndalama ɨsi aakabile, alɨnkʉbapapo abatʉmigwa ʉkʉtɨ basibɨɨkege. ");
INSERT INTO nyy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Looli ʉmundʉ jʉmo ɨngamu jaake Ananija nʉ nkasi gwake Safila balɨnkʉʉlɨsya ʉngʉnda gwabo. ");
INSERT INTO nyy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Leelo alɨnkʉtapʉlapo ɨndalama simo kʉbʉtiitʉ, joope nʉ nkasi aasimeenye ɨsyo, ɨkɨjabo kɨmo alɨnkʉbatwalɨla abatʉmigwa ʉkʉtɨ basibɨɨkege. ");
INSERT INTO nyy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Po Peeteli alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Ananija! Fiki Seetano iswile mu ndumbula jaako ʉkʉtɨ ʉntʉngʉlʉpɨlege Mbepo Mwikemo? Ʉfisileko ɨkɨjabo kɨmo bo gʉʉliisye ʉngʉnda. ");
INSERT INTO nyy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bʉle, bo ʉkaalɨ ʉkʉʉlɨsya, gʉkaalɨ ngʉnda gwako? Bo gʉʉliisye, syalɨ ndalama syako ʉkʉbombela muno gwiganiile. Fiki leelo gwinogwine mu ndumbula jaako ʉkʉbomba bo ɨsyo? Ʉkabatʉngʉlʉpɨla abandʉ, looli gʉntʉngʉlʉpiile Kyala!” ");
INSERT INTO nyy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananija bo apɨliike amasyʉ gaa Peeteli, alɨnkʉgwa paasi, alɨnkʉfwa. Boosa aba baapɨliike ɨsi syaboniike, balɨnkʉja nʉ lʉtende fiijo. ");
INSERT INTO nyy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Po abalʉmyana balɨnkʉgʉniembeteelela ʉmfimba gwake nʉ mwenda, balɨnkʉgʉsoosya panja nʉ kʉgʉsyɨla. ");
INSERT INTO nyy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ɨsala itatʉ bʉno bo sikɨndile, ʉnkasi ʉgwa Ananija alɨnkwingɨla mu nyumba jɨla, kɨsita kʉmanya ɨsi syaboniike. ");
INSERT INTO nyy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peeteli alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Ʉʉmbʉʉle, ɨndalama ɨsi mwakabile bo mʉʉliisye ʉngʉnda gwɨnu, bʉle syo ɨsi itolo?” Ʉnkasi gwa Ananija alɨnkʉmmwamula alɨnkʉtɨ, “Nalooli, syo ɨsyo itolo!” ");
INSERT INTO nyy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Alɨnkʉnndaalʉʉsya kangɨ alɨnkʉtɨ, “Syendile bʉleebʉle, mwitɨkeene nʉ ndʉmego ʉkʉnngela Mbepo gwa Ntwa Kyala? Pɨlɨkɨsya, ʉndindo pa kɨfigo ʉgwa bandʉ aba baalɨ kʉkʉnsyɨla ʉndʉmego, na nungwe bikʉkʉtwala panja nʉ kwa kʉkʉsyɨla.” ");
INSERT INTO nyy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nakalɨnga Safila alɨnkʉgwa nkyeni mwa Peeteli, alɨnkʉfwa. Abalʉmyana balɨnkwingɨla balɨnkwaga Safila afwile, balɨnkʉgʉtwala ʉmfimba gwake panja, balɨnkʉgʉsyɨla kʉmbalɨ kwi ipʉmba lya ndʉme. ");
INSERT INTO nyy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Abandʉ abaa nkɨpanga kya Kyala na bandʉ boosa aba baapɨliike ɨsyo, balɨnkʉja nʉ lʉtende fiijo. ");
INSERT INTO nyy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Abatʉmigwa baabombaga ɨfiika ɨfikʉlʉmba fii fingi kʉ bandʉ, kʉ maka agaa Kyala. Abiitɨki boosa baakomaanaga mwi ibalaasa ɨlɨ baatɨgɨ Solomoni, ndʉpaso lwa tempeli. ");
INSERT INTO nyy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Akaaliko ʉmundʉ najʉmo ʉjʉ akaalɨ mwitɨki, ʉjʉ aagemile ʉkʉja pamopeene nabo, looli abiitɨki bɨɨmɨkigwaga na bandʉ ʉkʉja bandʉ banunu. ");
INSERT INTO nyy_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Boope aba bammwitiike ʉNtwa, abanyambala na bakiikʉlʉ, bongelelaga fiijo ʉbwingi. ");
INSERT INTO nyy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Po abandʉ baabatwalaga ababine mu nsebo nʉ kʉbalambalɨka mfitala na mbʉnyasa, ʉkʉtɨ bo Peeteli ikʉkɨnda ʉnsyʉngʉʉlʉ gwake gʉbakupɨkɨlepo bamo, ʉkʉtɨ babʉmbʉlʉke. ");
INSERT INTO nyy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ɨkɨlʉndɨlo kya bandʉ ʉkʉfuma ntwaja ʉtʉ tʉlɨ kɨfuki, boope biisaga mu Jelusalemu, baabatwalaga ababine na aba baataamigwaga nɨ mbepo ɨnyali, boosa balɨnkʉbʉmbʉlʉsigwa. ");
INSERT INTO nyy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Po ʉmpuuti ʉnkʉlʉmba na banine boosa abaa nkɨbugutɨla kya Basatukai, balɨnkʉja nʉ bʉʉfi kʉ batʉmigwa. ");
INSERT INTO nyy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Balɨnkʉbakola, balɨnkʉbabɨɨka mu nnyololo. ");
INSERT INTO nyy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Looli pakɨlo ʉgwandʉmi gwa Ntwa alɨnkwigʉla ɨnyiigi sya nyumba jaa nnyololo, alɨnkʉbasoosya panja, alɨnkʉbabʉʉla alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Amubʉʉke mukɨɨme ndʉpaso lwa tempeli, mukabalʉmbɨlɨle abandʉ amasyʉ goosa agaa bʉʉmi ʉbʉ ʉbʉpya.” ");
INSERT INTO nyy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bo bapɨliike ɨsi ʉgwandʉmi ababʉʉlile, balɨnkwingɨla ndʉpaso lwa tempeli nʉlʉbʉnjʉ fiijo, balɨnkwanda ʉkʉmanyisya. Ʉmpuuti ʉnkʉlʉmba na banine balɨnkʉfika, balɨnkʉkoolela ʉlʉkomaano lwa Sanihendilini, ʉlʉ lukʉbakomaania abalongosi boosa abaa Banyaisilaɨli. Balɨnkʉbatʉma abasikali mu nnyololo, ʉkʉtɨ bakabatwale abatʉmigwa bala. ");
INSERT INTO nyy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Looli abasikali bo bingiile mula, balɨnkwaga abatʉmigwa bala bakajamo. Balɨnkʉgomoka kʉ balongosi nʉ kʉbabʉʉla ɨsi basibwene, ");
INSERT INTO nyy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","balɨnkʉtɨ, “Twagile ɨnyumba jaa nnyololo nyiigale kanunu, abalɨndɨlɨli bɨɨmile pa fifigo. Looli bo twigwile, tʉkammwagamo ʉmundʉ najʉmo nkatɨ!” ");
INSERT INTO nyy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ʉnkʉlʉmba gwa basikali baa mu tempeli pamopeene na bapuuti abalongosi bo bapɨliike ɨsyo, syabaalangeenie fiijo, balɨnkʉlaalʉʉsania ʉkʉtɨ po sikʉjaga bʉleebʉle. ");
INSERT INTO nyy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Po alɨnkwisa ʉmundʉ jʉmo, alɨnkʉbabʉʉla alɨnkʉtɨ, “Keeta! Abanyambala aba mubapinyile mu nnyololo, bɨɨmile ndʉpaso lwa tempeli, kangɨ bikʉbamanyisya abandʉ.” ");
INSERT INTO nyy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Po ʉnkʉlʉmba gwa basikali na basikali banine, balɨnkʉbʉʉka ndʉpaso lwa tempeli, balɨnkʉbeega abatʉmigwa. Looli bakaabombiile amaka, paapo baatiilaga ʉkʉtɨ abandʉ baabagiile ʉkʉbatuunya na mabwe. ");
INSERT INTO nyy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bo babatwele, balɨnkʉbɨɨmɨka nkyeni mu Sanihendilini. Ʉmpuuti ʉnkʉlʉmba alɨnkʉbalaalʉʉsya, ");
INSERT INTO nyy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","alɨnkʉtɨ, “Ʉmwe tʉbakemiile ʉkʉmanyisya ɨmanyisyo sya mundʉ ʉjʉ. Looli mumanyiisye moosa mu Jelusalemu. Po mukʉtɨ jo ʉswe tʉpelile ʉkʉfwa ʉmundʉ ʉjʉ?” ");
INSERT INTO nyy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peeteli na batʉmigwa banine balɨnkʉmmwamula balɨnkʉtɨ, “Ʉswe tukʉlondigwa ʉkʉntiila Kyala, somma abandʉ! ");
INSERT INTO nyy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kyala gwa biisʉkʉlʉ bɨɨtʉ aalɨnsyʉsiisye Jesu, ʉjʉ ʉmwe mwalɨnngogile pala mwalɨnkomeliile pa kɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kyala amfyʉsiisye, ammbɨɨkile pabʉjo ʉbwɨmɨkigwa, kʉkɨbafu kyake ɨkiilɨɨlo, ajege Ndongosi kangɨ Mpoki, ʉkʉtɨ aBanyaisilaɨli bapɨndʉke nʉ kʉhobokeligwa ʉbʉtʉlanongwa. ");
INSERT INTO nyy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ʉswe tukʉbabʉʉla abandʉ ɨnongwa ɨsi, paapo tʉlɨ bakeeti baa ɨsyo, joope Mbepo Mwikemo, ʉjʉ Kyala abapeele aba bikʉntiila.” ");
INSERT INTO nyy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Abalongosi bala bo bapɨliike ɨsyo, syabakaleesye fiijo, baalondaga ʉkʉlonga ʉkʉtɨ bagogigwe. ");
INSERT INTO nyy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Looli aaliko ʉMfalisai jʉmo, ɨngamu jaake Gamalieli, ʉmmanyisi gwa ndagɨlo sya Moose, ʉjʉ ɨɨmɨkigwaga na bandʉ boosa. Alɨnkwɨma mu Sanihendilini, alɨnkʉlagɨla ʉkʉtɨ abatʉmigwa basoosigwe panja kʉkabalɨlo akapimba. ");
INSERT INTO nyy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Po alɨnkʉbabʉʉla abalongosi abanine alɨnkʉtɨ, “Mwe Banyaisilaɨli, mujege maaso na ɨsi mukʉlonda ʉkʉbabombela abandʉ aba. ");
INSERT INTO nyy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Paapo amasikʉ aga gakɨndile aaliko ʉmundʉ jʉmo ɨngamu jaake Teuta, iituufyaga ʉkʉja mundʉ nkʉlʉmba, abandʉ baamia bana bʉno baalɨnkongile. Bo agogiigwe, boosa aba baalɨnkongile baabalaniile, syosa silɨnkʉmalɨka. ");
INSERT INTO nyy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kangɨ pabʉngɨ, akabalɨlo kala ɨsilikali jaabalaga abandʉ, alɨnkwisa ʉNgalilai jʉmo, ɨngamu jaake Juuta, joope aabasyobile abandʉ, balɨnkʉnkonga. Looli ʉjʉ joope aagogiigwe, po boosa aba baalɨnkongile baabalaniile. ");
INSERT INTO nyy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Po lɨɨlɨno nikʉbabʉʉla nikʉtɨ, muje pabʉtali na bandʉ aba, mubaleke itolo! Lɨnga sisiisi biinogwine baabo pamo lɨnga ɨsi bikʉbomba sifumile mmbandʉ, aasikʉfuba. ");
INSERT INTO nyy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Looli lɨnga sifumile kwa Kyala, mukabagɨla ʉkʉbatola, mukwisa kwijaaga mukʉlwa na Kyala.” ");
INSERT INTO nyy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Po balɨnkwitɨka amasyʉ gaake. Balɨnkʉbakoolela abatʉmigwa bala, balɨnkʉlagɨla ʉkʉtɨ bakomigwe. Balɨnkʉkomigwa ɨfingoti, po balɨnkʉbakaanisya ʉkʉmanyisya mu ngamu jaa Jesu, balɨnkʉbalekesya ʉkʉtɨ babʉʉkege. ");
INSERT INTO nyy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Abatʉmigwa balɨnkʉsookamo mu Sanihendilini nʉ lʉsekelo, paapo Kyala aalyagile ʉkʉtɨ baabagiisye ʉkʉsʉʉka, kʉnongwa jaa ngamu jaa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bakaalekile ʉkʉmanyisya abandʉ nʉ kʉlʉmbɨlɨla bwila ɨNdʉmi ɨNunu, ʉkʉtɨ Jesu jo Meesija, ndʉpaso lwa tempeli na mu nyumba sya bandʉ. ");
INSERT INTO nyy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mmasikʉ gala abiitɨki baa Ntwa Jesu bo bikongelapo ʉkʉbaala, kwalipo ʉkwibuneesya mBajuuta aba baajobaga ɨKɨgiliki kʉ Bajuuta aba baajobaga ɨKɨhibʉli. Aba baajobaga ɨKɨgiliki biibuneesyaga ʉkʉtɨ, abakiikʉlʉ baa nkɨbugutɨla kyabo, aba bafwɨle abalʉme baabo, batikʉkeetigwa ʉkʉjabɨligwa ɨfindʉ ɨfya kʉkʉtɨ isikʉ. ");
INSERT INTO nyy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Po leelo abatʉmigwa bala kalongo na babɨlɨ balɨnkʉbabɨlɨkɨla abiitɨki boosa abaa Ntwa Jesu, balɨnkʉbabʉʉla balɨnkʉtɨ, “Kʉkaja kʉnunu ʉswe ʉkʉtɨ tʉleke ʉkʉmanyisya iisyʉ lya Kyala, kʉnongwa jaa kʉjaba ɨfindʉ. ");
INSERT INTO nyy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Po leelo baamyɨtʉ, amusale abanyambala bahaano na babɨlɨ ʉkʉfuma mmyɨnu, abandʉ aba bikʉjobigwa kanunu, biiswile Mbepo Mwikemo, nʉ kʉja na mahala. Bo tukʉbabɨɨka pa mbombo ɨjɨ. ");
INSERT INTO nyy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Po ʉswe tukʉʉmɨɨlɨlaga ʉkwipuuta, ʉkʉlʉmbɨlɨla nʉ kʉmanyisya iisyʉ lya Kyala.” ");
INSERT INTO nyy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Iisyʉ ɨlyo lɨlɨnkʉbakyela abandʉ boosa nkɨbugutɨla, po paapo balɨnkʉbasala Sitefani, ʉjʉ aaliiswile ʉlwitɨko na Mbepo Mwikemo, pamopeene na Filipo, Pulokoli, Nikanoli, Timoni, Palimena na Nikolai ʉgwa kʉ Antyokija, ʉjʉ aalingiile ndwitɨko lwa Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bo balɨnkʉbabɨɨka nkyeni mbatʉmigwa, po abatʉmigwa balɨnkwipuuta, balɨnkʉbabɨɨkapo amaboko ʉkʉbomba ɨmbombo ɨjo. ");
INSERT INTO nyy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Iisyʉ lya Kyala lɨlɨnkʉkɨndapo ʉkʉfumuka, abiitɨki balɨnkongelela kʉ bwingi fiijo mu Jelusalemu, kangɨ abapuuti bingi balɨnkʉmmwitɨka ʉNtwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitefani aaliiswile ɨliipyana na maka, aabombaga ɨfiswigo nɨ fimanyilo ɨfikʉlʉmba mmbandʉ. ");
INSERT INTO nyy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Looli ɨliisikʉ lɨmo, abandʉ bamo balɨnkwanda ʉkʉkaanikana na Sitefani. Abo baafumile mu sinagogi, ɨjɨ ɨngamu jaake baatɨgɨ, Sinagogi jaa Baabʉke. Baalɨ Bajuuta aba baafumile ntwaja ʉtwa mu Kilene, Alikisandalija, Kilikija na nkiisʉ ɨkya Asija. ");
INSERT INTO nyy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Looli baatoliigwe kʉnongwa jaa mahala gaake, paapo Mbepo Mwikemo anndongosyaga ʉkʉjoba. ");
INSERT INTO nyy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Po balɨnkʉbapapo ɨndalama abandʉ bamo kʉbʉtiitʉ, balɨnkʉbabʉʉla ʉkʉtɨ batɨgɨ, “Tʉmpɨliike ʉmundʉ ʉjʉ ikʉjoba amasyʉ gaa kʉntʉka Moose na Kyala.” ");
INSERT INTO nyy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Po balɨnkʉbasambʉla abandʉ, abalongosi baa bandʉ na bamanyisi baa ndagɨlo sya Moose. Balɨnkʉmmbʉʉkɨla Sitefani, balɨnkʉnkola, balɨnkʉntwala mu Sanihendilini. ");
INSERT INTO nyy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Balɨnkʉbatwala abakeeti baa bʉtʉngʉlʉ aba balɨnkʉjoba balɨnkʉtɨ, “Ʉmundʉ ʉjʉ atikʉleka ʉkʉjoba amasyʉ gaa kʉjɨtʉka ɨtempeli ɨjɨ ɨnyiikemo, nɨ ndagɨlo sya Moose! ");
INSERT INTO nyy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Namanga tʉpɨliike ikʉjoba ʉkʉtɨ Jesu ʉgwa mu Nasaleti ikwisa kʉpoonanga loosa pabʉjo ʉbʉ nʉ kwandʉla ɨnyiiho ɨsi aatʉlekiile Moose.” ");
INSERT INTO nyy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Abandʉ boosa aba baatʉʉgeesye mu Sanihendilini balɨnkʉnngʼaatulɨla amaaso Sitefani, balɨnkwaga kʉmaaso kʉfwene bo ʉgwandʉmi. ");
INSERT INTO nyy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Po ʉmpuuti ʉnkʉlʉmba alɨnkʉnndaalʉʉsya Sitefani alɨnkʉtɨ, “Bʉle, ɨnongwa ɨsi bo silɨ?” ");
INSERT INTO nyy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitefani alɨnkwamula alɨnkʉtɨ, “Mwe baamyɨtʉ na mwe baataata, namumbɨlɨkɨsye! Kyala ʉNsisya aalɨnsetʉkiile taata Abulahamu bo alɨ nkiisʉ kya Mesopotamija, bo akaalɨ ʉkʉtʉʉgala kʉ Halani. ");
INSERT INTO nyy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kyala alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Sookamo nkiisʉ kyako na mbakamu baako, gwise nkiisʉ ɨkɨ nikʉkʉnangɨsya.’ ");
INSERT INTO nyy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Po paapo Abulahamu alɨnkʉsookamo nkiisʉ kya Bakalitai, alɨnkwakʉtʉʉgasya mu Halani. Ʉgwise bo afwile, Kyala alɨnkʉnsaamisya kʉla, alɨnkʉntwala nkiisʉ ɨkɨ mujengile ʉmwe akabalɨlo aka. ");
INSERT INTO nyy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“Kʉbwandɨlo Kyala akaalɨmpeele ɨkɨlɨngo nakɨmo Abulahamu nkiisʉ ɨkɨ, goope nʉ ngʉnda ʉgwa kʉfwana ʉntambo gʉmo. Looli aafingile ʉkʉmpa ɨkiisʉ ɨkɨ ʉkʉja kyake nʉ kʉja kya lʉjungu lwake, na paapo akabalɨlo ako akaalɨ nʉ mwana. ");
INSERT INTO nyy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kyala alɨnkʉmmbʉʉla Abulahamu alɨnkʉtɨ, ‘Ndʉjungu lwako bikwakʉja baheesya nkiisʉ kya bandʉ abangɨ, bikwakʉbɨɨkigwa ʉkʉja batʉmwa baabo nʉ kʉbombeligwa kabiibi ɨfyɨnja 400. ");
INSERT INTO nyy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Looli ʉne ngwisa kʉkɨlonga ɨkiisʉ ɨkɨ kikwisa kʉbabɨɨka ʉkʉja batʉmwa. Po bikwisa kʉsookamo nkiisʉ kɨla, bikwisa kʉʉnyiipuutaga pabʉjo ʉbʉ.’ ");
INSERT INTO nyy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Po Kyala alɨnkʉbɨɨka ʉlwitɨkano ʉlwa bʉbuutigwa kʉkyeni na Abulahamu. Po Abulahamu alɨnkʉmpaapa Isaka, alɨnkʉmmbuuta kʉkyeni bo amalile amasikʉ lwele ʉkʉfuma pakʉpaapigwa. Isaka alɨnkwisa kʉmpaapa Jaakobo, Jaakobo joope alɨnkwisa kʉbapaapa abiisʉkʉlʉ bɨɨtʉ kalongo na babɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Abaana bala abaa Jaakobo, kʉnongwa jaa bʉʉfi balɨnkʉmmʉʉlɨsya Joosefu mbʉtʉmwa nkiisʉ kya Misili. Looli Kyala alɨnkʉja pamopeene nagwe, ");
INSERT INTO nyy_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ampokaga mu ndaamyo syake syosa. Kyala alɨnkʉmpapo Joosefu ɨliipyana na mahala nkyeni mwa Falao ʉmalafyale gwa Misili. Po Falao alɨnkʉmmbɨɨka Joosefu ʉkʉja gwa kɨbɨlɨ kʉmyake, ʉkʉbalongosya abandʉ abaa mu Misili na baa nnyumba jaake. ");
INSERT INTO nyy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Po leelo jɨlɨnkʉgwa ɨnjala moosa nkiisʉ kya Misili nɨ kya Kaanaani, abandʉ balɨnkʉtaamigwa fiijo. Abiisʉkʉlʉ bɨɨtʉ boope ɨfindʉ filɨnkʉbamalɨkɨla. ");
INSERT INTO nyy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jaakobo bo apɨliike ʉkʉtɨ nkiisʉ ɨkya Misili filiko ɨfindʉ, alɨnkʉbatʉma ʉko ʉlwa kwanda abaanaake, aba bo biisʉkʉlʉ bɨɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ʉlwa bʉbɨlɨ Joosefu alɨnkwinangɨsya kʉ baamyabo, po Falao alɨnkʉkɨmanya ɨkɨkolo kya Joosefu. ");
INSERT INTO nyy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Joosefu alɨnkʉtʉma ɨndʉmi kʉ gwise Jaakobo nɨ kɨkolo kyake kyosa, abandʉ 75, ʉkʉtɨ biise kʉ Misili. ");
INSERT INTO nyy_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Po Jaakobo alɨnkʉnsuluka kʉ Misili, alɨnkʉfwɨla kʉlakʉla, ʉmwene na baanaake. ");
INSERT INTO nyy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Looli ɨmibɨlɨ gyabo gyagomosiigwe kʉ Sekemu, baagɨsyɨlile mwi ipʉmba ɨlɨ Abulahamu aalyʉlile nɨ ndalama kʉ baana baa Emoli mu Sekemu. ");
INSERT INTO nyy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Akabalɨlo bo kasegeliile akaa Kyala ʉkʉbomba ɨsi aafingile kwa Abulahamu, abandʉ baabeele kangɨ baalyongilepo ʉkʉja bingi fiijo nkiisʉ kya Misili. ");
INSERT INTO nyy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kʉmmalɨɨkɨsyo, alɨnkʉlongosya ʉmalafyale ʉjʉngɨ mu Misili, ʉjʉ akaalɨmmeenye Joosefu. ");
INSERT INTO nyy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ʉmalafyale ʉjo alɨnkʉbalongosya abaa nkɨkolo kyɨtʉ nɨ kɨpahʉ nʉ kʉbabombela kabiibi. Aabafimbɨlɨsyaga ʉkʉbataaga abaanaabo abafyele, ʉkʉtɨ bafwege. ");
INSERT INTO nyy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Po Moose alɨnkʉpaapigwa akabalɨlo ako, aalɨ mwana nnunu fiijo. Balɨnkʉnswɨla ɨmyesi mitatʉ nnyumba jaa gwise. ");
INSERT INTO nyy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Looli bo bantaagile, ʉmwana ʉndɨndwana ʉgwa Falao alɨnkʉmmwega, alɨnkʉnswɨla ngatɨ mwanaake ʉnnyambala. ");
INSERT INTO nyy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moose aamanyisiigwe amahala goosa agaa Bamisili, alɨnkʉja mundʉ gwa maka mbʉjobi na mu mbombo syake. ");
INSERT INTO nyy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moose bo aalɨ nɨ fyɨnja amalongo mana, alɨnkʉsyʉkwa ʉkʉtɨ abʉʉke kʉkʉbakeeta abaamyabo aBanyaisilaɨli. ");
INSERT INTO nyy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Alɨnkʉmmwaga ʉMmisili jʉmo ikʉmmbonela ʉMwisilaɨli jʉmo, alɨnkʉntʉʉla ʉjʉ aaboneligwaga, alɨnkʉgomola ʉkʉnkoma, alɨnkʉnngoga ʉMmisili jʉla. ");
INSERT INTO nyy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moose iinogonaga ʉkʉtɨ abaamyabo aBanyaisilaɨli bikʉsyagania ʉkʉtɨ Kyala ikʉbapoka ʉkwendela kʉmyake Moose, looli abeene balɨnkʉsita kʉsyagania. ");
INSERT INTO nyy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kɨlaabo kyake, Moose alɨnkʉbabona aBanyaisilaɨli babɨlɨ bikʉlwa. Alɨnkʉgela ʉkʉbafwania, alɨnkʉbabʉʉla alɨnkʉtɨ, ‘Baamyɨtʉ, ʉmwe mulɨ baa nkɨkolo kɨmo! Fiki mukʉfulasania?’ ");
INSERT INTO nyy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Looli ʉmundʉ ʉjʉ ammbonelaga ʉmwinaake alɨnkʉnngutɨla Moose kʉmbalɨ, alɨnkʉlaalʉʉsya alɨnkʉtɨ, ‘Jo jwani ʉjʉ akʉbɨɨkile ʉkʉja ndongosi, kangɨ ʉkʉja ndamuli gwɨtʉ? ");
INSERT INTO nyy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bʉle, ʉgwe kʉlonda ʉkʉʉngoga niine, bo ʉlʉ ʉnngogile ʉMmisili jʉla mmajolo?’ ");
INSERT INTO nyy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moose bo apɨliike amasyʉ ago aabopile, alɨnkwakʉja mbʉheesya nkiisʉ kya Mitiani, mo alɨnkwakʉpaapɨla abaana abanyambala babɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ɨfyɨnja amalongo mana bo fikɨndile, ɨliisikʉ lɨmo Moose aalɨ ndʉngalangala kɨfuki nɨ kyamba Sinai. Po ʉgwandʉmi alɨnkʉnsetʉkɨla nkɨsyanjʉ ɨkɨ kyakaga ʉmooto. ");
INSERT INTO nyy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moose bo asibwene ɨsyo, alɨnkʉswiga, alɨnkʉsegelela ʉkʉtɨ akɨkeete kanunu ɨkɨsyanjʉ. Po alɨnkʉpɨlɨka ɨliisyʉ lya Ntwa Kyala likʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ʉne ne Kyala gwa biisʉkʉlʉ baako, Kyala gwa Abulahamu, Isaka na Jaakobo.’ Moose alɨnkʉtetema, alɨnkʉtiila nʉ kʉkeetako kangɨ. ");
INSERT INTO nyy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Po ʉNtwa Kyala alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Fuula ɨfilato fyako, paapo apa gwɨmile po pabʉjo ʉbwikemo. ");
INSERT INTO nyy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nalooli mbabwene abandʉ bangʉ muno bikʉtaamigwa nkiisʉ kya Misili. Mbɨliike ɨnguuto jaabo, nsulwike kʉkʉbapoka mbʉtʉmwa. Po ʉlʉ isaga, ngʉtʉme kʉ Misili.’ ");
INSERT INTO nyy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moose jo ʉjʉ baalɨnkaanile. Baatile, ‘Jo jwani ʉjʉ akʉbɨɨkile ʉkʉja ndongosi, kangɨ ʉkʉja ndamuli?’ Looli jo ʉjʉ aatʉmiigwe na Kyala ʉkʉja ndongosi nʉ kʉja mpoki gwabo, ʉkwendela ngwandʉmi ʉjʉ aalɨnsetʉkiile nkɨsyanjʉ. ");
INSERT INTO nyy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jo ʉjʉ aabalongwisye ʉkʉsookamo nkiisʉ kya Misili. Aabombile ɨfiswigo nɨ fimanyilo mu Misili, mu Nyanja ɨNgeseefu, kangɨ ndʉngalangala kʉ fyɨnja amalongo mana. ");
INSERT INTO nyy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moose jo ʉjʉ aababʉʉlile aBanyaisilaɨli ʉkʉtɨ, ‘Kyala ikwisa kʉbiinʉlɨla ʉnkunguluka bo ʉne ʉkʉfuma mmbandʉ bɨɨnu.’ ");
INSERT INTO nyy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moose jo ʉjʉ aalipo ndʉngalangala apa baabʉngeene abiisʉkʉlʉ bɨɨtʉ. Pa kyamba Sinai ʉgwandʉmi aajobile nagwe, ʉkʉtɨ abapepo abiisʉkʉlʉ bɨɨtʉ ɨndʉmi. Jo ʉjʉ aalyambɨliile amasyʉ gaa bʉʉmi ʉkʉtɨ atʉpepo ʉswe. ");
INSERT INTO nyy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Looli abiisʉkʉlʉ bɨɨtʉ bakaalondaga ʉkʉmpɨlɨka Moose, balɨnkʉnkaana. Mu ndumbula syabo balɨnkʉgomokelako kʉkiisʉ ɨkya Misili. ");
INSERT INTO nyy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Balɨnkʉmmbʉʉla Aaloni balɨnkʉtɨ, ‘Ʉtʉtendekekesye gyabaakyala ɨgɨ gikʉtʉlongosyaga mu njɨla. Paapo ʉmundʉ ʉjʉ Moose, atʉlongwisye ʉkʉsookamo nkiisʉ kya Misili, tʉkasimanya ɨsi simmwagile!’ ");
INSERT INTO nyy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Po mmasikʉ ago balɨnkʉbʉmba ɨkɨfwani kya ngwata, balɨnkʉkɨsookesya ɨliikemo, balɨnkʉbɨɨka ʉlʉsekelo kʉnongwa jaa kandʉ aka batendekiisye na maboko gaabo. ");
INSERT INTO nyy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kyala alɨnkʉbakaana, po alɨnkʉbaleka ʉkʉtɨ biipuutege kwi isʉba, kʉ mwesi na kʉ ndondwa, bo ʉlʉ sisimbiigwe mwa kalata gwa bakunguluka ʉkʉtɨ, ‘Mwe Banyaisilaɨli, bʉle, mwasookesyaga ʉne ɨfinyamaana fya kʉbooligwa nɨ fya ikemo, ɨfyɨnja amalongo mana ndʉngalangala? ");
INSERT INTO nyy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Looli mwapɨmbile ɨheema jaa kɨfwani kya Moloki, nɨ kɨfwani ɨkya lʉtondwa lwa lyakyala lyɨnu Lefani, ɨfifwani ɨfi mwafibʉmbile ʉkʉtɨ mufiipuutege. Kʉnongwa ɨjo ngʉbatwala kʉbʉtali ʉkʉkɨnda kʉkiisʉ ɨkya mu Babeli.’ ” ");
INSERT INTO nyy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sitefani alɨnkongelapo alɨnkʉtɨ, “Ndʉngalangala mula abiisʉkʉlʉ bɨɨtʉ baalɨ nɨ heema ɨjaa kʉmmwipuutɨlamo Kyala. Ɨheema ɨjo jaatendekesiigwe bo muumo Kyala aalɨnndagiile Moose ʉkʉjɨtendekesya, ʉkʉfwana nɨ kɨfwani ɨkɨ aakɨbwene. ");
INSERT INTO nyy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Po paapo abiisʉkʉlʉ bɨɨtʉ balɨnkʉpokanila ʉkwisa najo, mpaka akabalɨlo aka Jooswa aabalongosyaga ʉkʉkaba ɨkiisʉ ʉkʉfuma mmaboko gaa fikolo, ɨfi Kyala aafikagile nkyeni mmyabo. Ɨheema jɨlɨnkʉjako ʉkwisa kʉfika mmasikʉ agaa malafyale Ndaabɨti. ");
INSERT INTO nyy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Ndaabɨti aakabile ɨliipyana nkyeni mwa Kyala, alɨnkʉnsʉʉma Kyala ʉkʉtɨ ammwitɨkɨsye ʉkʉjenga ʉbʉjo bwa kʉtʉʉgasyamo Kyala gwa Jaakobo. ");
INSERT INTO nyy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Looli ʉjʉ aalɨnnjengiile ɨnyumba, jo Solomoni ʉmwana gwa Ndaabɨti. ");
INSERT INTO nyy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Looli Kyala ʉNkʉlʉmba, atikʉtʉʉgala mu nyumba ɨsi sijengiigwe na maboko gaa bandʉ. Bo muno ikʉjobela ʉnkunguluka ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘ɄNtwa Kyala ikʉtɨ, “Kʉmwanya kyo kɨkota kyangʉ ɨkya bʉtwa, ɨkiisʉ ko kakota kaa kʉbɨɨkapo amalʉndɨ gangʉ. Po mukʉʉnjengela ʉne ɨnyumba jaa lʉko lʉki? Pabʉjo bʉlɨkʉ apa nikʉtʉʉsyaga? ");
INSERT INTO nyy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bʉle, ɨfyo fyosa ngaja jo ʉne naafipelile?” ’ ” ");
INSERT INTO nyy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitefani alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Mwe bandʉ ʉmwe mulɨ nɨ mitʉ ɨmikafu! Ɨndumbula syɨnu nɨ mbʉlʉkʉtʉ syɨnu sikʉtaamya, silɨ bo ɨsya bandʉ aba bakaja Banyaisilaɨli. Amasikʉ goosa ʉmwe mukʉmpɨnga Mbepo Mwikemo, mufwene bo muumo abiisʉkʉlʉ bɨɨnu baabombelaga! ");
INSERT INTO nyy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bʉle, alipo ʉnkunguluka jʉmo ʉjʉ abiisʉkʉlʉ bɨɨnu bakaalɨntaamiisyepo? Baabagogile aba baakungulukaga ʉkwisa kwa Ngolofu, Jesu Kɨlɨsiti! Jo ʉjʉ ʉmwe mwalɨnndɨɨliile nʉ kʉnngoga. ");
INSERT INTO nyy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ʉmwe mwe mwalyambɨliile ɨndagɨlo sya Kyala ɨsi baabatwaliile abandʉmi baake, mutikʉsikonga.” ");
INSERT INTO nyy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Abandʉ baa mu Sanihendilini, bo bapɨliike amasyʉ gaa Sitefani, balɨnkwimemena amiino, paapo baakaleele fiijo. ");
INSERT INTO nyy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Looli Sitefani alɨnkwisʉla Mbepo Mwikemo, alɨnkʉngʼaatulɨla amaaso kʉmwanya, alɨnkʉbʉbona ʉbʉsisya bwa Kyala, na Jesu ɨɨmile pabʉjo ʉbwɨmɨkigwa, kʉkɨbafu ɨkiilɨɨlo ɨkya Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Po alɨnkʉjoba alɨnkʉtɨ, “Keeta! Ngʉkʉbona kʉmwanya kwigwike, Nnyamundʉ ɨɨmile kʉkɨbafu ɨkiilɨɨlo ɨkya Kyala!” ");
INSERT INTO nyy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Po abandʉ boosa balɨnkʉjwega, balɨnkʉsindɨla ɨmbʉlʉkʉtʉ syabo na maboko, balɨnkʉmmotokela palɨkɨmo, ");
INSERT INTO nyy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","balɨnkʉnsoosyamo nkaaja, balɨnkʉntuunya na mabwe. Abakeeti balɨnkʉfuula amakoti gaabo, balɨnkʉgabɨɨka kɨfuki nʉ ndʉmyana jʉmo, ɨngamu jaake Saʉli, ʉkʉtɨ agalɨndɨlɨlege. ");
INSERT INTO nyy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bo bikʉntuunya na mabwe, Sitefani alɨnkʉsʉʉma alɨnkʉtɨ, “Gwe Ntwa Jesu, ambɨlɨla ʉbʉʉmi bwangʉ!” ");
INSERT INTO nyy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Po alɨnkʉfugama paasi, alɨnkʉlaata alɨnkʉtɨ, “Gwe Ntwa, ʉlɨngababalɨlako ʉbʉtʉlanongwa ʉbʉ.” Bo ajobile ɨsyo, alɨnkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Joope Saʉli aalipo, aaliitiike ʉkʉgogigwa Sitefani. Abandʉ abatiila Kyala balɨnkʉnsyɨla Sitefani, balɨnkʉbɨɨka ɨɨfwa ɨnywamu fiijo. Iisikʉ ɨlyo syalyandile ɨngʉbɨlo ɨnywamu nkɨpanga kya Kyala ɨkya mu Jelusalemu. Po abiitɨki boosa balɨnkʉbalanila ʉkʉbʉʉka mu Jutai, na mu Samalija, balɨnkʉsyala beene abatʉmigwa. ");
INSERT INTO nyy_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Akabalɨlo ako akaa ndaamyo joope Saʉli aabapinyaga mu nnyololo abandʉ abaa nkɨpanga kya Kyala, ingɨlaga kʉkʉtɨ nyumba, aabakwabaga abanyambala na bakiikʉlʉ. ");
INSERT INTO nyy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Looli abiitɨki aba baabalaniile balɨnkʉbʉʉka kʉkʉtɨ bʉjo, baalʉmbɨlɨlaga ɨNdʉmi ɨNunu. ");
INSERT INTO nyy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo joope alɨnkʉbʉʉka nkaaja kamo akaa mu Samalija, aalʉmbɨlɨlaga ɨsya Kɨlɨsiti. ");
INSERT INTO nyy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Abandʉ bingi balɨnkʉpɨlɨkɨsya kanunu amasyʉ aga aajobaga Filipo, bo bapɨliike ɨnongwa ɨsya fiika nʉ kʉfibona ɨfi aabombaga. ");
INSERT INTO nyy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Po ɨmbepo ɨnyali aasikagaga mmbandʉ abingi aba baakoliigwe nasyo. Syasookaga nʉ kʉkuuta fiijo. Abandʉ bingi abakokonyale na aba bikʉkwema balɨnkʉbʉmbʉlʉka. ");
INSERT INTO nyy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Po paapo lʉlɨnkʉjamo ʉlʉsekelo ʉlʉnywamu nkaaja kala. ");
INSERT INTO nyy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Po nkaaja kala, aalimo ʉmundʉ jʉmo ɨngamu jaake Simoni, ʉjʉ kʉbwandɨlo aabombaga ɨsya bʉlosi, nʉ kʉbaswigɨsya aBasamalija, iijobaga ʉkʉtɨ nkʉlʉmba. ");
INSERT INTO nyy_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Abandʉ boosa bampɨlɨkaga, ʉkwandɨla abandʉ abaa paasi mpaka abalongosi, baajobaga ʉkʉtɨ, “Ʉmundʉ ʉjʉ go Maka gaa Kyala, aga baatɨgɨ Makʉlʉmba.” ");
INSERT INTO nyy_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bampɨlɨkɨsyaga fiijo kʉnongwa jaa kʉtɨ akabalɨlo kaa kingi aabaswigɨsyaga nɨ mbombo sya bʉlosi bwake. ");
INSERT INTO nyy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Looli abandʉ bo bammwitiike Filipo bo ikʉlʉmbɨlɨla ɨNdʉmi ɨNunu ɨjaa Bʉnyafyale bwa Kyala, nɨ ngamu jaa Jesu Kɨlɨsiti, boosigwaga abanyambala na bakiikʉlʉ. ");
INSERT INTO nyy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Joope Simoni alɨnkwitɨka alɨnkoosigwa. Alɨnkʉnkonga Filipo koosa kʉno aabʉʉkaga, alɨnkʉswiga bo ikʉfibona ɨfimanyilo nɨ fiika ɨfinywamu ɨfi fyabombigwaga. ");
INSERT INTO nyy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mu Jelusalemu abatʉmigwa baapɨliike ʉkʉtɨ abandʉ baa mu Samalija balyambɨliile ɨliisyʉ lya Kyala, balɨnkʉbatʉma Peeteli na Johani kʉ bandʉ bala. ");
INSERT INTO nyy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bo bafikile balɨnkʉbasʉʉmɨla bala, ʉkʉtɨ bammwambɨlɨle Mbepo Mwikemo, ");
INSERT INTO nyy_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","namanga Mbepo Mwikemo aakaalɨ ʉkʉnsololokela najʉmo mmbandʉ abo, looli baalyosiigwe itolo mu ngamu jaa Ntwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Po Peeteli na Johani balɨnkʉbabɨɨkapo amaboko, abandʉ bala balɨnkʉmmwambɨlɨla Mbepo Mwikemo. ");
INSERT INTO nyy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni aababwene abandʉ bikwambɨlɨla Mbepo Mwikemo bo babɨɨkiigwepo amaboko na batʉmigwa. Po alɨnkʉbatwalɨla ɨndalama Peeteli na Johani, ");
INSERT INTO nyy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","alɨnkʉbasʉʉma alɨnkʉtɨ, “Namumbepo niine amaka gagaaga, ʉkʉtɨ kʉkʉtɨ mundʉ ʉjʉ ngʉmmbɨɨkɨlangapo amaboko gangʉ, ambɨlɨlege Mbepo Mwikemo.” ");
INSERT INTO nyy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Looli Peeteli alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉgwe pamopeene nɨ ndalama syako ʉsobege! Kwinogona ʉkʉtɨ ʉbagiile ʉkʉʉla ɨkɨkʉngɨlwa kya Kyala! ");
INSERT INTO nyy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ʉgwe ʉkaja pamopeene na nuuswe, kangɨ ʉkajamo mu mbombo ɨjɨ, paapo ɨndumbula jaako jɨkaja ngolofu nkyeni mwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Po leelo ʉpɨndʉke ʉbʉtʉlanongwa bwako ʉbʉ, kangɨ ʉsʉʉme ʉlʉhobokelo kʉ Ntwa, ʉkʉtɨ pamo ikʉkʉhobokela ɨnyiinogono syako. ");
INSERT INTO nyy_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ngʉkʉbona gwiswile ʉbʉʉfi, kangɨ ʉgwe ʉlɨ mpinyigwa gwa mbiibi.” ");
INSERT INTO nyy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Po Simoni alɨnkʉmmwamula alɨnkʉtɨ, “Muusʉʉmɨle ʉmwe kʉ Ntwa, ʉkʉtɨ silɨngaanyaaga nasimo ɨsi mujobile!” ");
INSERT INTO nyy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Peeteli na Johani bo bapangile ɨnongwa ɨsi Kyala ababombiile abandʉ nʉ kʉlʉmbɨlɨla iisyʉ lya Ntwa Jesu, balɨnkwanda ʉkʉbʉʉka mu Jelusalemu. Mu njɨla baalʉmbɨlɨlaga ɨNdʉmi ɨNunu ntwaja twingi ʉtwa Basamalija. ");
INSERT INTO nyy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Iisikʉ lɨmo, ʉgwandʉmi gwa Ntwa alɨnkʉmmbʉʉla Filipo alɨnkʉtɨ, “Ʉbʉʉke ʉkʉlabɨla kwitongo, mu njɨla ɨjaa ndʉngalangala, ɨjɨ jɨfumile kʉ Jelusalemu, jikʉbʉʉka kʉ Gasa.” ");
INSERT INTO nyy_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Po Filipo alɨnkʉsumuka alɨnkʉbʉʉka. Akabalɨlo kalakala mu njɨla jɨla aaliko ʉmundʉ ʉmfule, ʉgwa nkiisʉ kya Ityopija. Ʉjʉ ɨɨmɨlɨlaga ɨkyʉma kyosa ɨkya malafyale ʉnkiikʉlʉ Kandake. Ʉmfule ʉjo, kʉbwandɨlo aabʉʉkile kʉ Jelusalemu kʉkwipuuta, ");
INSERT INTO nyy_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","akabalɨlo ako aagomokaga kʉkaaja, aatʉʉgeele mwi igeleeti lyake, aabalaga kalata gwa nkunguluka Jeesaja. ");
INSERT INTO nyy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Po Mbepo Mwikemo alɨnkʉmmbʉʉla Filipo, alɨnkʉtɨ, “Bʉʉka kɨfuki ni igeleeti ɨlyo, ʉlongosanie nalyo.” ");
INSERT INTO nyy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Po Filipo alɨnkʉbopela kɨfuki ni igeleeti, alɨnkʉmpɨlɨka ʉmundʉ jʉla ikʉbala kalata gwa nkunguluka Jeesaja, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Bʉle, ɨsi kʉbala kʉsyagania?” ");
INSERT INTO nyy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ʉmfule jʉla alɨnkʉmmwamula alɨnkʉtɨ, “Ngʉsyaganiaga bʉleebʉle, lɨnga ʉmundʉ atikʉʉndɨngaania?” Alɨnkʉnsʉʉma Filipo afyʉke mwi igeleeti, atʉʉgale pamopeene nagwe. ");
INSERT INTO nyy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ɨnongwa ɨjɨ aabalaga mwa Kalata ʉMwikemo jo ɨjɨ, “Aalongosiigwe ngatɨ ngʼoosi ɨjɨ basumwike kʉkʉjɨboola, kangɨ ngatɨ kangʼoosi aka kikʉmyeka bo kalɨ pakʉmweligwa ʉlʉsyoja, bʉnoobʉno joope alɨnkʉsita nʉ kʉjoba ɨliisyʉ nalɨmo. ");
INSERT INTO nyy_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Aafujuliigwe nʉ kʉlongigwa kabiibi. Akajapo ʉjʉ abagiile ʉkʉpanga ɨsya baanaake, paapo ʉbʉʉmi bwake bʉsoosiigwepo pakiisʉ.” ");
INSERT INTO nyy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ʉmfule jʉla alɨnkwendelela ʉkʉnndaalʉʉsya Filipo alɨnkʉtɨ, “Ngʉkʉsʉʉma ʉʉmbʉʉle, ʉnkunguluka ʉjʉ ikʉjoba ɨnongwa ɨjaani? Ikʉjoba ɨnongwa ɨjaake, pamo ɨnongwa jaa mundʉ ʉjʉngɨ?” ");
INSERT INTO nyy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Po Filipo alɨnkwamula alɨnkwandɨla mwa kalata jʉjʉʉjo, alɨnkʉnndʉmbɨlɨla ɨNdʉmi ɨNunu ɨjaa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bo bakaalɨ bikwenda mu njɨla, balɨnkʉfika pabʉjo ʉbʉ amɨɨsi gaalipo. Ʉmfule jʉla alɨnkʉjoba alɨnkʉtɨ, “Keeta! Amɨɨsi galipo apa. Kalɨ ɨfiki fikʉʉsigɨla ʉkoosigwa?”  ");
INSERT INTO nyy_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo alɨnkʉjoba alɨnkʉtɨ, “Lɨnga kʉmmwitɨka Jesu Kɨlɨsiti nɨ ndumbula jaako joosa, ʉbagiile ʉkoosigwa.” Ʉmfule jʉla alɨnkʉmmwamula alɨnkʉtɨ, “Niitiike ʉkʉtɨ Jesu Kɨlɨsiti jo Mwana gwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Po ʉmfule jʉla alɨnkʉlagɨla ʉkʉtɨ ɨliigeleeti lyɨme, balɨnkʉsuluka bobabɨɨlɨ mmɨɨsi. Po Filipo alɨnkʉmmoosya. ");
INSERT INTO nyy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bo bafyʉkile ʉkʉfuma mmɨɨsi, Mbepo gwa Ntwa Kyala alɨnkʉnnyaka Filipo, ʉmfule jʉla akaalɨmmbwene kangɨ, po alɨnkwenda ɨnjɨla jaake nʉ lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo alɨnkwaga alɨ mu Asoto, po alɨnkʉsookamo. Bo ikwenda aalʉmbɨlɨlaga ntwaja toosa ʉtwa mu njɨla ɨNdʉmi ɨNunu, mpaka bo afikile mu Kesalija. ");
INSERT INTO nyy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Akabalɨlo ako, Saʉli endelelaga ʉkʉbatiilɨsya abiitɨki baa Ntwa Jesu, ʉkʉtɨ ikʉbagoga. Po alɨnkʉbʉʉka kʉ mpuuti ʉnkʉlʉmba, ");
INSERT INTO nyy_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","alɨnkʉnsʉʉma ʉkʉtɨ ampepo baakalata abaa kʉbʉʉka nabo kʉ bakʉlʉmba baa sinagogi ɨsya nkaaja akaa mu Ndamasika. Baakalata baalɨmmwitɨkiisye ʉkʉtɨ, lɨnga ammwagile ʉmundʉ gwesa ʉgwa Njɨla jaa Jesu, aje nnyambala pamo nkiikʉlʉ, abapinyege nʉ kʉbatwala kʉ Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Po Saʉli alɨnkwenda ɨnjɨla ɨjaa kʉbʉʉka mu Ndamasika. Bo alɨ kɨfuki, nakalɨnga ʉndangalɨla ʉkʉfuma kʉmwanya gʉlɨnkʉmmulɨka koosakoosa. ");
INSERT INTO nyy_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Aagwile paasi, alɨnkʉpɨlɨka ɨliisyʉ ɨlɨ likʉmmbʉʉla likʉtɨ, “Saʉli! Saʉli! Fiki kʉʉfunda?” ");
INSERT INTO nyy_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saʉli alɨnkʉlaalʉʉsya alɨnkʉtɨ, “Gwe Ntwa, gwe gwani?” Iisyʉ lɨla lɨlɨnkwamula lɨlɨnkʉtɨ, “Ʉne ne Jesu, ʉjʉ ʉgwe kʉmfunda. ");
INSERT INTO nyy_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sumuka! Gwingɨle nkaaja, ʉmo mo kwakʉbʉʉligwa syosa ɨsi kʉlondigwa ʉkʉsibomba.” ");
INSERT INTO nyy_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Abandʉ aba bendaga pamopeene nagwe mu njɨla, baalyɨmile kɨsita kʉja nasyo ɨsya kʉjoba, paapo boope baapɨliike iisyʉ, looli bakaalɨmmbwene ʉmundʉ najʉmo. ");
INSERT INTO nyy_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Po Saʉli alɨnkwinʉka ʉkʉfuma paasi. Bo ikʉgela ʉkʉkeeta, alɨnkwaga atikʉkeeta. Abanine balɨnkʉnkola ɨkɨboko, balɨnkʉnndongosya ʉkʉntwala mu Ndamasika. ");
INSERT INTO nyy_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Gaakɨndile amasikʉ matatʉ kɨsita kʉkeeta. Nkabalɨlo ako akaaliilemo nʉ kʉnwa nafimo. ");
INSERT INTO nyy_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kʉ Ndamasika aaliko ʉmwitɨki jʉmo, ɨngamu jaake Ananija. ɄNtwa Jesu alɨnkʉjoba nagwe mbʉsetʉka, alɨnkʉtɨ, “Ananija!” Ananija alɨnkwamula alɨnkʉtɨ, “Gwe Ntwa, ʉne apa.” ");
INSERT INTO nyy_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Po ʉNtwa alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉbʉʉke kʉ lʉkɨndɨ ʉlʉ ɨngamu jaake bikʉtɨ Lʉgolofu. Ʉkalaalʉʉsye mu nyumba jaa Juuta, lɨnga alimo ʉmundʉ ʉjʉ ɨngamu jaake bikʉtɨ Saʉli, afumile kʉ Taliso. Ʉlʉ alɨ pakwipuuta. ");
INSERT INTO nyy_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mbʉsetʉka ammbwene ʉmundʉ, ɨngamu jaake Ananija, ikwingɨla muno alimo nʉ kʉmmbɨɨkɨlapo amaboko, ʉkʉtɨ akeetege kangɨ.” ");
INSERT INTO nyy_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananija alɨnkʉmmwamula alɨnkʉtɨ, “Gwe Ntwa, mbɨliike kʉ bandʉ baa bingi, ɨnongwa sya mundʉ ʉjʉ, ababombiile ɨmbiibi nyingi abandʉ baako mu Jelusalemu! ");
INSERT INTO nyy_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na ʉlʉ apa, abapuuti abalongosi bammwitɨkiisye ʉkʉtɨ abapinyege boosa aba bikʉkwipuuta.” ");
INSERT INTO nyy_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Looli ʉNtwa alɨnkʉmmbʉʉla Ananija alɨnkʉtɨ, “Bʉʉkaga itolo! Ʉmundʉ ʉjo, kɨbombelo kyangʉ ɨkɨsʉngʉligwa, ɨkya kʉfumusya ɨngamu jangʉ kʉlɨ aba bakaja Banyaisilaɨli na banyafyale baabo, kangɨ kʉ bandʉ bangʉ aBanyaisilaɨli. ");
INSERT INTO nyy_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ʉne nikʉnnangɨsya ɨngʉbɨlo ɨsi mpaka akʉbɨlwe kʉnongwa jangʉ.” ");
INSERT INTO nyy_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Po Ananija alɨnkʉbʉʉka, alɨnkwingɨla nnyumba jɨla, alɨnkʉmmbɨɨkapo amaboko Saʉli, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwamyɨtʉ Saʉli, ʉNtwa Jesu andʉmile kʉmyako, ʉkʉtɨ ʉkeetege kangɨ nʉ kwisʉla Mbepo Mwikemo. Jesu ʉjo jo ʉjʉ aakʉsetʉkiile mu njɨla ɨjɨ gwisɨlaga.” ");
INSERT INTO nyy_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nakalɨnga ʉtʉndʉ ngatɨ makakala, tʉlɨnkʉsatʉka ʉkʉfuma mmaaso gaa Saʉli, alɨnkʉkeeta kangɨ, alɨnkʉsumuka, alɨnkoosigwa. ");
INSERT INTO nyy_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Po alɨnkʉlyamo ɨfindʉ, alɨnkʉkaba amaka. Saʉli aatʉʉgeele amasikʉ gamo pamopeene na biitɨki aba baalimo mu Ndamasika. ");
INSERT INTO nyy_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Aabʉʉkaga mu sinagogi, aalʉmbɨlɨlaga ɨnongwa sya Jesu aatɨgɨ, “Ʉjo jo Mwana gwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Abandʉ boosa aba bampɨlɨkɨsyaga Saʉli baaswigaga, baatɨgɨ, “Bʉle, akaja jo ʉjʉ aabafundaga abandʉ aba bikʉmmwipuuta Jesu, kʉla kʉ Jelusalemu? Na apa iisile ʉkʉtɨ abapinyege abandʉ abo nʉ kʉbatwala kʉ bapuuti abalongosi!” ");
INSERT INTO nyy_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Looli Saʉli alɨnkʉkɨndapo ʉkʉja na maka, aabaswigɨsyaga aBajuuta aba baatʉʉgalaga mu Ndamasika, ʉkʉbanangɨsya ʉkʉtɨ Jesu jo Meesija. ");
INSERT INTO nyy_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Amasikʉ mingi bo gakɨndile, aBajuuta balɨnkwitɨkana ʉkʉtɨ banngoge Saʉli. ");
INSERT INTO nyy_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bansigɨlaga mfipata fya nkaaja, pakɨlo na pamuusi, ʉkʉtɨ banngoge. Looli Saʉli alɨnkʉsimanya ɨsi biitɨkeene. ");
INSERT INTO nyy_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pakɨlo abafundigwa baake baalɨmmwegile, baalɨmmbɨɨkile nkiibo ɨkɨnywamu, baalɨnsulwisye nʉ lʉgoje mwi imato ʉkwendela pabʉjo ʉbʉ bwalɨ bwasi. ");
INSERT INTO nyy_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Po Saʉli aabʉʉkile mu Jelusalemu, alɨnkʉgela ʉkʉja pamopeene na aba bammwitiike Jesu. Looli boosa bantiilaga, paapo bakaaliitiike ʉkʉtɨ joope mwitɨki gwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Looli Balinaba alɨnkwisa kʉkʉmmwega Saʉli, alɨnkʉntwala kʉ batʉmigwa. Alɨnkʉbapangɨla muno Saʉli aalɨmmboniile ʉNtwa mu njɨla ɨjɨ jikʉbʉʉka kʉ Ndamasika, nʉ kʉtɨ ʉNtwa aajobile nagwe. Alɨnkʉbabʉʉla muno Saʉli aalʉmbɨlɨliile ɨnongwa sya Jesu kʉla, kɨsita kʉtiila. ");
INSERT INTO nyy_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Po Saʉli aatʉʉgalaga pamopeene na biitɨki, aasyʉngʉʉtɨlaga mu Jelusalemu kʉno ikʉlʉmbɨlɨla mu ngamu jaa Ntwa Jesu, kɨsita kʉtiila. ");
INSERT INTO nyy_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Aajobaga nʉ kʉkaanikana na Bajuuta aba baajobaga ɨnjobelo ɨjaa Kɨgiliki, looli abeene baalondaga ʉkʉnngoga. ");
INSERT INTO nyy_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Abiitɨki bo basyageenie ɨsyo, balɨnkʉntwala mu Kesalija, po balɨnkʉntʉma kʉ Taliso. ");
INSERT INTO nyy_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Akabalɨlo kala, ɨkɨpanga kyosa ɨkya Kyala kyalɨ nʉ lʉtengaano moosa mu Jutai, mu Galilai na mu Samalija. Abandʉ baa nkɨpanga kya Kyala baapeeligwaga amaka nʉ kwendelela ʉkʉntiila ʉNtwa. Kʉ bʉtʉʉli bwa Mbepo Mwikemo, baalyongeliile ʉkʉja bingi. ");
INSERT INTO nyy_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Akabalɨlo kala Peeteli endaga moosamoosa. Po alɨnkʉbʉʉka kʉkʉbakeeta abiitɨki aba baatʉʉgalaga nkaaja akaa mu Lita. ");
INSERT INTO nyy_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nkaaja kala alɨnkʉmmwaga ʉmundʉ jʉmo ɨngamu jaake Aineja, ʉjʉ aalalile. Aalambaleele pa kɨtala akabalɨlo kaa fyɨnja lwele. ");
INSERT INTO nyy_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peeteli alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉgwe Aineja, Jesu Kɨlɨsiti akʉbʉmbʉlwisye. Sumuka! Ʉbagiile ʉkʉtenga ɨkɨtala kyako.” Nakalɨnga Aineja alɨnkʉsumuka. ");
INSERT INTO nyy_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Abandʉ boosa abaa mu Lita na nkaaja akatelamu akaa mu Saloni, balɨnkʉmmbona Aineja, balɨnkʉpɨndʉka. ");
INSERT INTO nyy_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nkaaja akaa mu Jopa aaliko ʉnkiikʉlʉ jʉmo ʉmwitɨki gwa Jesu, ɨngamu jaake Tabita, kokʉtɨ Ndolikasi, akasya. Aabatʉʉlaga abalondo nʉ kʉbomba ɨmbombo ɨnunu ɨsingi. ");
INSERT INTO nyy_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Akabalɨlo kala, alɨnkʉbina nʉ kʉfwa. Bo bagoosiisye ʉmfimba, balɨnkʉgʉlambalɨka nkyumba ɨkya kʉ golofwa. ");
INSERT INTO nyy_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Akaaja kaa mu Jopa kaalɨ kɨfuki na kʉ Lita. Fyobeene abiitɨki baa Jesu bo bapɨliike ʉkʉtɨ Peeteli aliko kʉ Lita, balɨnkʉbatʉma abandʉ babɨlɨ kʉmyake ʉkʉtɨ bakanndambe. Baatile, “Ʉlɨngakaabɨlaga ʉkwisa kʉmyɨtʉ!” ");
INSERT INTO nyy_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Po Peeteli alɨnkʉsumuka, alɨnkʉlongosania nabo. Bo afikile, balɨnkʉntwala kʉ kyumba kɨla ɨkya kʉ golofwa. Abakiikʉlʉ boosa aba baasyɨlile abalʉme baabo, balɨnkwɨma kɨfuki nagwe. Balɨnkʉlɨla nʉ kʉnnangɨsya ɨmiselekesye nɨ myenda ɨgɨngɨ ɨgɨ Tabita aabasonelaga bo mʉʉmi. ");
INSERT INTO nyy_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peeteli alɨnkʉbasoosya abandʉ boosa panja. Alɨnkʉfugama alɨnkwipuuta, po alɨnkʉgʉkeeta ʉmfimba gʉla, alɨnkʉjoba alɨnkʉtɨ, “Tabita, sumuka!” Po Tabita amaaso gaake galɨnkʉkeeta. Bo ammbwene Peeteli alɨnkʉsumuka. ");
INSERT INTO nyy_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peeteli alɨnkʉnkola ɨkɨboko, alɨnkʉnsumusya, alɨnkʉbakoolela abakiikʉlʉ abafwɨle na biitɨki abangɨ, alɨnkʉbanangɨsya Tabita ʉmʉʉmi. ");
INSERT INTO nyy_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ɨnongwa ɨsyo silɨnkʉfumuka moosa mu Jopa, abandʉ bingi balɨnkʉmmwitɨka ʉNtwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peeteli alɨnkʉtʉʉgala amasikʉ mingi mu Jopa, nnyumba jaa mundʉ jʉmo ɨngamu jaake Simoni, ʉntendekesya ʉtʉndʉ twa fipapa. ");
INSERT INTO nyy_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Aaliko ʉmundʉ jʉmo mu Kesalija, ʉjʉ akaalɨ Njuuta, ɨngamu jaake Kolineli. Aalɨ nkʉlʉmba gwa basikali baa Balooma. Aalongosyaga abasikali ɨmia jɨmo ʉkʉfuma nkɨbugutɨla ɨkɨnywamu ɨkɨ baatɨgɨ, Kɨbugutɨla kya baa Italija. ");
INSERT INTO nyy_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Aalɨ mundʉ ʉjʉ antiilaga Kyala, ʉmwene na bandʉ boosa abaa nnyumba jaake. Aabapaga fiijo abandʉ ɨfya kʉbatʉʉla nʉ kwipuuta kwa Kyala bwila. ");
INSERT INTO nyy_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ɨliisikʉ lɨmo ɨsala jaa 9:00 bʉno pamuusi, alɨnkʉsibona ɨsya mbʉsetʉka. Ʉgwandʉmi gwa Kyala alɨnkʉmmwisɨla, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Kolineli!” ");
INSERT INTO nyy_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kolineli alɨnkʉnngʼaatulɨla amaaso, alɨnkʉtiila, alɨnkʉjoba alɨnkʉtɨ, “Gwe ntwa, filiko ɨfiki?” Ʉgwandʉmi alɨnkʉmmwamula alɨnkʉtɨ, “Kyala apɨliike ɨnyiipuuto syako, na ɨfi kʉsoosya ʉkʉbatʉʉla abandʉ afibwene, syosa ɨsyo atikwibwa. ");
INSERT INTO nyy_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Po ʉlʉ ʉbatʉme abandʉ babʉʉke kʉ Jopa, bakankoolele ʉmundʉ jʉmo, ʉjʉ ɨngamu jaake jo Simoni, ɨjɨngɨ bikʉtɨ Peeteli. ");
INSERT INTO nyy_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ʉmwene nheesya gwa mundʉ jʉmo, ɨngamu jaake Simoni, ʉntendekesya ʉtʉndʉ twa fipapa. Ɨnyumba jaake jɨlɨ kʉmbalɨ kʉ nyanja.” ");
INSERT INTO nyy_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ʉgwandʉmi ʉjʉ aajobaga na Kolineli bo abʉʉkile, po alɨnkʉbakoolela abandʉ babɨlɨ mbabombeli baake, nʉ nsikali gwake jʉmo ʉjʉ antiilaga Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Bo abalɨngeenie syosa ɨsi syaboniike, alɨnkʉbatʉma ʉkʉbʉʉka kʉ Jopa. ");
INSERT INTO nyy_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kɨlaabo kyake bo iisʉba lɨlɨ pantʉ, abandʉ aba aabatʉmile Kolineli baasegeliile ʉkʉfika mu Jopa. Akabalɨlo kala, Peeteli alɨnkʉfyʉka pamwanya pa nyumba, pakwipuuta. ");
INSERT INTO nyy_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ɨnjala jɨlɨnkʉnndʉma, alɨnkʉlonda ʉkʉlya. Bo balɨ pakʉtendekesya ɨfindʉ, alɨnkʉsibona ɨsya mbʉsetʉka. ");
INSERT INTO nyy_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nsya mbʉsetʉka ɨsyo, alɨnkʉkʉbona kʉmwanya kwigwike, na kandʉ kamo ngatɨ mwenda ʉnnywamu, gukʉsololosigwa mu mbeto syake ina. ");
INSERT INTO nyy_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nkatɨ mula fyalimo ɨfinyamaana ɨfya lʉko loosa, ɨfya nkaaja, ʉtʉndʉ nɨ njʉni. ");
INSERT INTO nyy_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Po Peeteli alɨnkʉpɨlɨka ɨliisyʉ, likʉmmbʉʉla likʉtɨ, “Peeteli, sumuka! Boola ʉlye!” ");
INSERT INTO nyy_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peeteli alɨnkwamula alɨnkʉtɨ, “Mma gwe Ntwa! Ngalyamo sikʉ ɨfindʉ ɨfi ɨndagɨlo sya Moose sikʉtɨ filɨ mwiko!” ");
INSERT INTO nyy_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Po ɨliisyʉ lɨlɨnkʉjoba kangɨ lɨlɨnkʉtɨ, “Ɨfindʉ ɨfi fyelʉsiigwe na Kyala, ʉgwe ʉlɨngatɨgɨ mwiko.” ");
INSERT INTO nyy_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ɨliisyʉ ɨlyo lyalyandɨseenie ʉkʉjoba nagwe katatʉ, po nakalɨnga ʉmwenda gʉla gʉlɨnkʉfyʉsigwa kangɨ kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peeteli bo ikwalangana mu ndumbula jaake ʉkʉtɨ ɨsya mbʉsetʉka sikʉnangɨsya sya fiki, abandʉ aba baatʉmiigwe na Kolineli, balɨnkwisa. Baalaalʉʉsiisye ɨnyumba jaa Simoni, po balɨnkʉjɨmanya, balɨnkwɨma pa kɨpata. ");
INSERT INTO nyy_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Balɨnkʉkoolela, balɨnkʉlaalʉʉsya balɨnkʉtɨ, “Bʉle, alimo ʉnheesya ʉjʉ ikʉtʉʉgasya muno, ɨngamu jaake jo Simoni, ɨjɨngɨ jo Peeteli?” ");
INSERT INTO nyy_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peeteli bo akaalɨ ikwinogona ɨsyo, Mbepo Mwikemo alɨnkʉmmbʉʉla alɨnkʉtɨ, “Balipo abandʉ batatʉ aba bikʉkʉlonda. ");
INSERT INTO nyy_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Suluka, ʉlongosanie nabo kɨsita kwilaamwa, paapo jo ʉne mbatʉmile.” ");
INSERT INTO nyy_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peeteli alɨnkʉsuluka paasi, alɨnkʉbabʉʉla abandʉ bala alɨnkʉtɨ, “Jo ʉne mukʉʉndonda. Mubɨngɨliile ɨfiki?” ");
INSERT INTO nyy_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Balɨnkʉmmwamula balɨnkʉtɨ, “Ʉnkʉlʉmba jʉmo ʉgwa basikali atʉtʉmile. Ɨngamu jaake jo Kolineli, mundʉ ngolofu, ntiila Kyala, aBajuuta boosa bikʉmmwɨmɨka kʉnongwa jaa kajɨɨlo kaake akanunu. Alagɨliigwe nʉ gwandʉmi ʉmwikemo, ʉkʉtɨ abatʉme abandʉ kʉmyako, ʉbʉʉke nabo kʉkaaja kaake, akapɨlɨkɨsye amasyʉ aga kwa kʉmmbʉʉlaga.” ");
INSERT INTO nyy_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Po Peeteli alɨnkʉbambɨlɨla ʉkʉja baheesya baake. Kɨlaabo kyake Peeteli alɨnkʉbʉʉka pamopeene nabo, abiitɨki bamo ʉkʉfuma kʉ Jopa balɨnkʉlongosania nagwe. ");
INSERT INTO nyy_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Iisikʉ lya bʉbɨlɨ balɨnkʉfika kʉ Kesalija. Kolineli aabaguulɨlaga, aababʉngeenie abakamu na bamanyaani baake. ");
INSERT INTO nyy_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peeteli bo ikʉfika, Kolineli alɨnkʉsooka kʉkʉmmwambɨlɨla, alɨnkʉbunguluka mmalʉndɨ gaake ʉkʉmmwipuuta. ");
INSERT INTO nyy_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Looli Peeteli alɨnkʉmmwinʉla, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Sumuka! Paapo ʉne ndɨ mundʉ itolo bo ʉlwako!” ");
INSERT INTO nyy_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peeteli bo ikʉjoba na Kolineli, alɨnkwingɨla nnyumba, alɨnkʉbaaga abandʉ bingi babʉngeene. ");
INSERT INTO nyy_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Po alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉmwe mumeenye ʉkʉtɨ, twe Bajuuta ɨndagɨlo syɨtʉ sikʉtʉkaanisya ʉkʉlɨɨlanila nʉ mundʉ ʉgwa nkɨkolo ɨkɨngɨ, pamo ʉkʉnnjaatɨla. Looli Kyala aanangiisye ʉkʉtɨ ndɨngannjobaga ʉmundʉ najʉmo ʉkʉtɨ mwiko. ");
INSERT INTO nyy_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kʉnongwa ɨjo, bo ʉbatʉmile abandʉ kʉkʉngoolela, niisile kɨsita kwilaamwa. Ngʉbalaalʉʉsya mungooleliile silɨkʉ?” ");
INSERT INTO nyy_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kolineli alɨnkwamula alɨnkʉtɨ, “Amasikʉ matatʉ aga gakɨndile, mu sala jɨjɨɨjɨ, ɨjaa 9:00 pamuusi, niipuutaga munomuno nnyumba jangʉ. Nakalɨnga ndɨnkʉmmbona ʉmundʉ ɨɨmile nkyeni mmyangʉ, afwele ɨmyenda ɨgɨ gikʉlangala, ");
INSERT INTO nyy_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","alɨnkʉʉmbʉʉla alɨnkʉtɨ, ‘Kolineli, Kyala apɨliike ɨnyiipuuto syako, na ɨfi kʉsoosya ʉkʉbatʉʉla abandʉ afibwene, syosa ɨsyo atikwibwa. ");
INSERT INTO nyy_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Po leelo, ʉbatʉme abandʉ babʉʉke kʉ Jopa, bakankoolele Simoni, ʉjʉ ɨngamu ɨjɨngɨ bikʉtɨ Peeteli. Ʉmwene nheesya gwa mundʉ jʉmo, ɨngamu jaake Simoni, ʉntendekesya ʉtʉndʉ twa fipapa. Ɨnyumba jaake jɨlɨ kʉmbalɨ kʉ nyanja.’ ");
INSERT INTO nyy_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nakalɨnga ndɨnkʉbatʉma abandʉ kʉmyako, ʉgwe ʉbombile kanunu apa gwisile. Po ʉlʉ twesa ʉswe tʉlɨ nkyeni mwa Kyala, tʉpɨlɨkɨsye amasyʉ goosa aga akʉlagiile ʉkʉtɨ ʉtʉbʉʉle.” ");
INSERT INTO nyy_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Po Peeteli alɨnkʉbabʉʉla alɨnkʉtɨ, “Nalooli nsyageenie ʉkʉtɨ Kyala atikwegamila kʉ bandʉ bamo! ");
INSERT INTO nyy_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Looli kʉkʉtɨ kɨkolo, ikʉbiitɨka abandʉ aba bikʉntiila nʉ kʉbomba ɨsya bʉgolofu. ");
INSERT INTO nyy_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Jo Ndʉmi ɨNunu ɨjaa lʉtengaano, ɨjɨ Kyala aajɨtʉmile kʉ Banyaisilaɨli kʉ njɨla jaa Jesu Kɨlɨsiti, ʉjʉ jo Ntwa gwa bandʉ boosa. ");
INSERT INTO nyy_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ʉmwe musimeenye ɨsi syabombiigwe moosa mu Jutai, syalyandiile mu Galilai, bo Johani ʉMoosi afumile pakʉlʉmbɨlɨla abandʉ ʉkʉtɨ boosigwe. ");
INSERT INTO nyy_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kangɨ musimeenye ɨnongwa ɨsya Jesu ʉgwa mu Nasaleti, muno Kyala aalɨnsʉngwile ʉkʉmpa Mbepo Mwikemo na maka. Jesu aabombaga ɨmbombo ɨnunu nʉ kʉbʉmbʉlʉsya boosa aba baataamigwaga na Seetano kʉkʉtɨ bʉjo. Namanga Kyala aalɨ pamopeene nagwe. ");
INSERT INTO nyy_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ʉswe tʉlɨ bakeeti baa syosa ɨsi Jesu aasibombile nkiisʉ kya Bajuuta na mu Jelusalemu. Piitaasi baalɨnngogile kʉ njɨla jaa kʉnkomelela pa kɨkohekano. ");
INSERT INTO nyy_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Looli iisikʉ lya bʉtatʉ Kyala aalɨnsyʉsiisye Jesu, alɨnkʉnnangɨsya pabwelu kʉ bandʉ. ");
INSERT INTO nyy_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Komma kʉ bandʉ boosa, looli kʉmyɨtʉ twe twasaliigwe kɨlɨngaani na Kyala ʉkʉja bakeeti. Bo afumile pakʉsyʉka kʉ bafwe, ʉswe twaliile nʉ kʉnwa pamopeene nagwe. ");
INSERT INTO nyy_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Aatʉlagiile ʉkʉtɨ tʉbalʉmbɨlɨlege abandʉ boosa, tʉbasokege ʉkʉtɨ ʉmwene jo ʉjʉ Kyala ammbɨɨkile ʉkʉja Ndongi gwa bʉʉmi na bafwe. ");
INSERT INTO nyy_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ʉjo jo ʉjʉ abakunguluka boosa bikʉmfumusya ʉkʉtɨ, kʉkʉtɨ mundʉ ʉjʉ ikʉmmwitɨka, ikʉhobokeligwa ɨmbiibi syake, ʉkwendela mu ngamu jaake.” ");
INSERT INTO nyy_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peeteli bo alɨ pakʉjoba amasyʉ ago, Mbepo Mwikemo alɨnkʉbasulukɨla boosa aba baagapɨliike. ");
INSERT INTO nyy_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ABajuuta abiitɨki aba baaliisile pamopeene na Peeteli, balɨnkʉswiga kʉnongwa jaa kʉtɨ boope aba bakaja Bajuuta, Kyala abapeele Mbepo Mwikemo. ");
INSERT INTO nyy_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Namanga baabapɨliike bikʉjoba mu njobelo ɨsingi, nʉ kʉntuufya Kyala kʉ mbombo syake ɨngʉlʉmba. Po Peeteli alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Abandʉ aba bambɨliile Mbepo Mwikemo bo ʉswe. Jo jwani abagiile ʉkʉbakaanisya ʉkoosigwa?” ");
INSERT INTO nyy_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Alɨnkʉlagɨla ʉkʉtɨ boosigwe mu ngamu jaa Jesu Kɨlɨsiti. Po balɨnkʉnsʉʉma ʉkʉtɨ asyale nabo amasikʉ manandɨ. ");
INSERT INTO nyy_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Po abatʉmigwa na biitɨki abangɨ aba baaliko kʉ Jutai, balɨnkʉpɨlɨka ʉkʉtɨ boope aba bakaja Bajuuta balyambɨliile ɨliisyʉ lya Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Peeteli bo abʉʉkile kʉ Jelusalemu, aBajuuta abiitɨki balɨnkwanda ʉkʉkaanikana nagwe, ");
INSERT INTO nyy_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","balɨnkʉtɨ, “Fiki ʉgwe gwingɨlaga mu nyumba jaa bandʉ aba bakaja Bajuuta, ʉlɨnkʉlya pamopeene nabo?” ");
INSERT INTO nyy_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Po paapo Peeteli alɨnkwanda ʉkʉbalɨngaania kʉkʉtɨ kandʉ kʉ lʉbaatɨko, alɨnkʉbabʉʉla alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ɨliisikʉ lɨmo naalɨ mu Jopa niipuutaga kwa Kyala, ndɨnkʉsibona ɨsya mbʉsetʉka. Nsya mbʉsetʉka ɨsyo, ndɨnkʉkabona akandʉ kamo ngatɨ mwenda ʉnnywamu, gukʉsololosigwa ʉkʉfuma kʉmwanya mu mbeto syake ina, kalɨnkʉʉfikɨla. ");
INSERT INTO nyy_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ndɨnkʉkeeta nkatɨ, ndɨnkʉfibona filimo ɨfinyamaana ɨfya lʉko loosa, fimo fyalɨ fya nkaaja, fimo fyalɨ fya ndiisʉ, ʉtʉndʉ nɨ njʉni. ");
INSERT INTO nyy_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","“Po paapo, ndɨnkʉpɨlɨka iisyʉ likʉtɨ, ‘Peeteli, sumuka! Boola ʉlye!’ ");
INSERT INTO nyy_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ndɨnkwamula ndɨnkʉtɨ, ‘Mma gwe Ntwa! Ngalyamo sikʉ ɨfindʉ ɨfi ɨndagɨlo sya Moose sikʉtɨ filɨ mwiko.’ ");
INSERT INTO nyy_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Looli ɨliisyʉ ʉkʉfuma kʉmwanya lɨlɨnkʉjoba kangɨ lɨlɨnkʉtɨ, ‘Ɨfindʉ ɨfi fyelʉsiigwe na Kyala, ʉgwe ʉlɨngatɨgɨ mwiko.’ ");
INSERT INTO nyy_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ɨliisyʉ ɨlyo lyalyandɨseenie ʉkʉjoba nagwe katatʉ, po paapo ɨfindʉ fyosa filɨnkʉkwabigwa kangɨ ʉkʉgomoka kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Nakalɨnga abandʉ batatʉ, aba baatʉmiigwe kʉmyangʉ ʉkʉfuma mu Kesalija, balɨnkwɨma pa kɨpata kya nyumba ɨjɨ naalimo. ");
INSERT INTO nyy_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Po paapo Mbepo Mwikemo alɨnkʉʉmbʉʉla alɨnkʉtɨ mbʉʉkege nabo kɨsita kwilaamwa. Ndɨnkʉbʉʉka pamopeene na bandʉ aba ntandatʉ. Bo twingiile mu nyumba jaa Kolineli, ");
INSERT INTO nyy_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","alɨnkʉtʉpangɨla muno aalɨmmboniile ʉgwandʉmi ɨɨmile nnyumba mmyake. Ʉgwandʉmi ʉjo alɨnkʉmmbʉʉla alɨnkʉtɨ, ‘Ʉbatʉme abandʉ babʉʉke kʉ Jopa, bakankoolele Simoni, ʉjʉ ɨngamu ɨjɨngɨ bikʉtɨ Peeteli. ");
INSERT INTO nyy_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ʉjo ikwakʉkʉbʉʉla amasyʉ agaa kʉkʉpoka ʉgwe, na bandʉ boosa abaa nnyumba mmyako.’ ");
INSERT INTO nyy_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Bo nandile ʉkʉjoba na bandʉ abo, nakalɨnga Mbepo Mwikemo alɨnkʉbasulukɨla, bo ʉlʉ aatʉsulukiile na nuuswe kʉbwandɨlo. ");
INSERT INTO nyy_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Po leelo ndɨnkʉlɨkʉmbʉka iisyʉ lɨla, ɨlɨ ʉNtwa Jesu aatʉbʉʉlile aatile, ‘Johani ʉMoosi aaboosyaga abandʉ na mɨɨsi, looli ʉmwe aamukoosigwaga na Mbepo Mwikemo.’ ");
INSERT INTO nyy_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Po lɨnga Kyala abapeele abo ɨkɨkʉngɨlwa kɨlakɨla ɨkɨ aatʉpeele na nuuswe, twe tʉmmwitiike ʉNtwa gwɨtʉ Jesu Kɨlɨsiti, ʉne ne ani ʉkʉmpɨnga Kyala?” ");
INSERT INTO nyy_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ABajuuta bo bapɨliike amasyʉ aga, balɨnkʉleka ʉkʉkaanika, balɨnkʉntuufya Kyala, balɨnkʉjoba balɨnkʉtɨ, “Ngɨmba Kyala abapeele boope aba bakaja Bajuuta ʉkʉpɨndʉka, ʉkʉkaba ʉbʉʉmi bwa bwila na bwila!” ");
INSERT INTO nyy_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Po abiitɨki aba baabalaniile kʉnongwa jaa ndaamyo ɨsi syasookiile bo Sitefani agogiigwe, balɨnkʉbʉʉka nkiisʉ ɨkya mu Foinike, mu Saipulasi na mu Antyokija. Koosa ʉko baalʉmbɨlɨlaga iisyʉ lya Ntwa Jesu kʉ Bajuuta beene. ");
INSERT INTO nyy_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Looli baalipo abandʉ bamo abaa mu Saipulasi na mu Kilene, aba bo biisile mu Antyokija, baajobile na bandʉ aba bakaja Bajuuta boope, ʉkʉnndʉmbɨlɨla ʉNtwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ɄNtwa Kyala alɨnkʉbalongosya na maka gaake, abandʉ bingi fiijo balɨnkʉmmwitɨka ʉNtwa Jesu, balɨnkʉpɨndʉka. ");
INSERT INTO nyy_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Abandʉ baa nkɨpanga kya Kyala kya mu Jelusalemu bo basipɨliike ɨsi syabombigwaga mu Antyokija, balɨnkʉntʉma Balinaba ʉkʉtɨ abʉʉke ʉko. ");
INSERT INTO nyy_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Balinaba bo afikile nʉ kʉbabona abandʉ muno Kyala abasajiile, alɨnkʉhoboka. Aabakasyaga boosa ʉkʉtɨ bʉʉmɨɨlɨlege ʉkʉmmwitɨka ʉNtwa nɨ ndumbula joosa. ");
INSERT INTO nyy_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Balinaba aalɨ mundʉ nnunu, aaliiswile Mbepo Mwikemo nʉ lwitɨko. Po abandʉ bingi balɨnkwanda ʉkʉmmwitɨka ʉNtwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Piitaasi Balinaba alɨnkʉsookako kʉla alɨnkʉbʉʉka kʉ Taliso kʉkʉnndonda Saʉli. ");
INSERT INTO nyy_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bo ammwagile, alɨnkʉntwala kʉ Antyokija. Balɨnkʉtʉʉgala ʉko nɨ kɨpanga kya Kyala ɨkyɨnja kyosa, baabamanyisyaga abandʉ abingi fiijo. Kʉ Antyokija ko kʉno abandʉ baalyandile ʉkʉbakoolela abiitɨki baa Jesu, ɨngamu jaa Bakɨlɨsiti. ");
INSERT INTO nyy_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mmasikʉ gagaago, abakunguluka bamo ʉkʉfuma kʉ Jelusalemu balɨnkwisa kʉ Antyokija. ");
INSERT INTO nyy_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jʉmo ndɨ abo ɨngamu jaake Agabo, alɨnkwɨma, alɨnkʉkunguluka kʉ maka agaa Mbepo Mwikemo ʉkʉtɨ, ɨnjala ɨngalɨ jikʉja pakʉgwa mfiisʉ fyosa. Ɨnjala ɨjo jaagwile bo ikʉlongosya ʉmalafyale Kɨlaʉtio. ");
INSERT INTO nyy_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Po abiitɨki baa Jesu balɨnkwitɨkana ʉkʉtʉma ʉbʉtʉʉli, ʉkʉbatʉʉla abiitɨki aba baatʉʉgasyaga mu Jutai. Kʉkʉtɨ mundʉ alɨnkʉsoosya ʉkʉkongana na ɨfi alɨ nafyo mbʉkabi bwake. ");
INSERT INTO nyy_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bo bafibʉngeenie ɨfya bʉtʉʉli, balɨnkʉbapa baa Balinaba na Saʉli, ʉkʉtɨ bafitwale kʉ bakʉʉlʉ baa kɨpanga kya Kyala ɨkya mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nkabalɨlo kalakala, ʉmalafyale Heloti alɨnkwanda ʉkʉbakola abiitɨki abaa mu Jelusalemu bamo, ʉkʉtɨ ababombele kabiibi. ");
INSERT INTO nyy_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Alɨnkʉlagɨla ʉkʉgogigwa nʉ lʉʉbo Jaakobo, ʉnkʉlʉ gwa Johani. ");
INSERT INTO nyy_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bo aagile ɨsyo sibahobwisye aBajuuta, alɨnkongelapo ʉkʉbabombela kabiibi, alɨnkʉnkola joope Peeteli. Ɨsyo syaboniike mmasikʉ agaa kyaka kya Pasa. ");
INSERT INTO nyy_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bo ankolile Peeteli, alɨnkʉmpinya mu nnyololo, alɨnkʉmmbɨɨka mbʉlɨndɨlɨli bwa fibugutɨla fina ɨfya basikali, kʉkʉtɨ kɨbugutɨla kyalɨ na basikali bana. Abasikali abo baapokanilaga ʉkʉnndɨndɨlɨla bana bana. Aalondaga bo ɨfyaka ɨfyo fikɨndile, ansoosye nʉ kʉnndonga nkyeni mmbandʉ. ");
INSERT INTO nyy_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Po Peeteli aalɨndɨlɨligwaga mu nnyololo, looli ɨkɨpanga kya Kyala kiijʉʉlaga fiijo ʉkʉnsʉʉma Kyala, ʉkʉtɨ antʉʉle. ");
INSERT INTO nyy_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ɨkɨlo ɨkɨ kɨlaabo kyake Heloti aajaga pakʉnndonga nkyeni mmbandʉ, Peeteli aalambaleele pakatɨ pa basikali babɨlɨ, aapinyiigwe ɨminyololo mibɨlɨ. Pa kɨfigo baalipo abasikali biinaabo aba baalɨndɨlɨlaga ɨnyumba jaa nnyololo. ");
INSERT INTO nyy_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nakalɨnga ʉgwandʉmi gwa Ntwa alɨnkwɨma kɨfuki nagwe, ʉndangalɨla gʉlɨnkʉmulɨka nkyumba kya nnyololo. Ʉgwandʉmi ʉjo alɨnkʉnnjʉgaania Peeteli pa lʉbafu, alɨnkʉnndembʉsya, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Sumuka mbɨbɨmbɨbɨ!” Ɨminyololo gɨlɨnkʉsatʉka paasi, ʉkʉfuma mmaboko gaa Peeteli! ");
INSERT INTO nyy_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ʉgwandʉmi ʉjo alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ipinye ʉmpango, fwala ɨfilato.” Peeteli alɨnkʉbomba bo ʉlo, po ʉgwandʉmi alɨnkʉmmbʉʉla alɨnkʉtɨ, “Fwala ikoti lyako, ʉngongege!” ");
INSERT INTO nyy_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Po Peeteli alɨnkʉnkonga ʉgwandʉmi, ʉkʉsooka nkyumba. Looli akaasimeenye ɨsi syabombigwaga nʉ gwandʉmi ʉkʉtɨ sya nalooli, iinogonaga ʉkʉtɨ ɨsi ikʉsibona sya mbʉsetʉka. ");
INSERT INTO nyy_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bo bankɨndile ʉndɨndɨlɨli ʉgwa kwanda nʉ gwa bʉbɨlɨ, balɨnkʉfika pa kɨpata kya kyela, ɨkya kʉsooka mu nnyololo, ʉkwingɨla nkaaja. Ɨkɨpata kɨlɨnkwigʉka kyene, balɨnkʉsooka panja. Bo bendile mu njɨla jɨmo, nakalɨnga ʉgwandʉmi alɨnkʉnndeka. ");
INSERT INTO nyy_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Po Peeteli alɨnkʉsyagania ɨsi siboniike, alɨnkʉtɨ, “Lɨɨlɨno mmeenye nalooli ʉkʉtɨ ʉNtwa antʉmile ʉgwandʉmi gwake, ambokile mmaboko gaa Heloti, na ndɨ syosa ɨsi aBajuuta baasʉʉbɨlaga.” ");
INSERT INTO nyy_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Bo asyageenie ɨsi, alɨnkʉbʉʉka mu nyumba jaa Malija, ʉnna gwa Johani, ʉjʉ ɨngamu ɨjɨngɨ aalɨ jo Maalɨka. Nnyumba ɨjo abandʉ bingi baabʉngeene, biipuutaga. ");
INSERT INTO nyy_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peeteli alɨnkʉkoolela pa lwigi lwa pa kɨpata kya lʉpaso. Ʉmbombi ʉndɨndwana, ɨngamu jaake Loota, alɨnkwisa kʉkʉpɨlɨkɨsya. ");
INSERT INTO nyy_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Bo alyageenie iisyʉ lya Peeteli, alɨnkʉsekela fiijo, looli akaalɨmmwigʉliile ʉlwigi. Alɨnkʉbopa ʉkʉgomokela nnyumba, alɨnkʉbabʉʉla aba baalimo alɨnkʉtɨ, “Peeteli ɨɨmile panja pa lwigi!” ");
INSERT INTO nyy_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Balɨnkʉmmbʉʉla balɨnkʉtɨ, “Ʉlɨ nɨ kɨgɨlɨ!” Looli ʉndɨndwana jʉla, aasisimɨkɨsyaga ʉkʉtɨ sya nalooli. Abeene balɨnkʉtɨ, “Ʉjo gwandʉmi gwake.” ");
INSERT INTO nyy_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Peeteli aalyongiilepo ʉkʉkungʼunda ʉlwigi. Bo biigwile ʉlwigi, balɨnkʉmmbona, balɨnkʉswiga. ");
INSERT INTO nyy_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peeteli alɨnkwinʉla ɨkɨboko kyake ʉkʉnangɨsya ʉkʉtɨ bamyeke. Alɨnkʉbabʉʉla muno ʉNtwa ansookiisye mu nnyololo. Kangɨ alɨnkʉtɨ, “Mubabʉʉle Jaakobo, na baamyɨtʉ abangɨ, ɨnongwa ɨsi.” Po Peeteli alɨnkʉsookapo, alɨnkʉbʉʉka pabʉjo ʉbʉngɨ. ");
INSERT INTO nyy_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Bo bʉkiile, abasikali balɨnkʉja nʉ lʉtende fiijo, paapo bakaameenye ɨsi simmwagile Peeteli. ");
INSERT INTO nyy_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heloti alɨnkʉlagɨla abasikali baake ʉkʉtɨ banndonde fiijo, looli balɨnkʉtoligwa ʉkʉmmwaga. Alɨnkʉbalaalʉʉsya abasikali aba banndɨndɨlɨlaga, alɨnkʉlagɨla ʉkʉtɨ bagogigwe abasikali abo. Po Heloti alɨnkʉsookako nkiisʉ ɨkya Jutai, alɨnkʉbʉʉka mu Kesalija, kʉno aatʉʉgalaga. ");
INSERT INTO nyy_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heloti aababengile fiijo abandʉ baa mu Tili na mu Sitoni. Looli abeene balɨnkʉkomaana pamopeene, balɨnkʉsala abandʉ abaa kwa kʉjoba nagwe. Abandʉ abo balɨnkʉmanyana taasi nʉ mundʉ jʉmo ɨngamu jaake Bulasiti, ʉjʉ aalɨ mbombeli mwɨmɨkigwa ʉgwa malafyale Heloti, ɨɨmɨlɨlaga ɨkyʉma kyake. Po balɨnkʉnsʉʉma Heloti ʉkʉtɨ kʉje nʉ lʉtengaano, paapo ɨkiisʉ kyabo kyasʉʉbɨlaga ɨfindʉ, ʉkʉfuma nkiisʉ kyake. ");
INSERT INTO nyy_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ɨliisikʉ lɨmo ɨlɨ aapangile ʉkʉjoba nabo, ʉmalafyale Heloti alɨnkʉfwala ɨmyenda gyake ɨgya bʉnyafyale, alɨnkʉtʉʉgala pa kɨkota kyake ɨkya bʉtwa, alɨnkwanda ʉkʉbalʉmbɨlɨla abandʉ ɨnongwa. ");
INSERT INTO nyy_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ɨkɨlʉndɨlo kya bandʉ balɨnkʉjwega nʉ lʉsekelo balɨnkʉtɨ, “Ɨlyo isyʉ lya lyakyala! Lɨkaja isyʉ lya mundʉ!” ");
INSERT INTO nyy_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nakalɨnga ʉgwandʉmi gwa Ntwa alɨnkʉpela Heloti ʉkʉja mbine fiijo, paapo akaababʉʉlile abandʉ ʉkʉtɨ bantuufyege mwene Kyala. Po alɨnkʉlɨɨligwa munda nɨ fwingili, alɨnkʉfwa. ");
INSERT INTO nyy_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Iisyʉ lya Kyala lɨlɨnkʉkɨndapo ʉkʉfumuka, abiitɨki balɨnkongelelapo kʉ bwingi fiijo. ");
INSERT INTO nyy_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Balinaba na Saʉli bo bamalile ɨmbombo ɨjɨ jaabatwele mu Jelusalemu, balɨnkʉsookamo ʉmo balɨnkʉbʉʉka mu Antyokija, balɨnkʉmmwega Johani ʉjʉ bantɨgɨ Maalɨka, ʉkʉja pamopeene nabo. ");
INSERT INTO nyy_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mmbandʉ baa nkɨpanga kya Kyala ɨkya Antyokija baalimo abakunguluka na bamanyisi aba: Balinaba, Simyoni ʉjʉ ɨngamu ɨjɨngɨ bantɨgɨ Ntiitʉ, Lukio ʉgwa mu Kilene, Manaeni ʉjʉ aakʉlile pamopeene nʉ malafyale Heloti, na Saʉli. ");
INSERT INTO nyy_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ɨliisikʉ lɨmo biipuutaga kʉ Ntwa nʉ kʉfipɨɨka ɨfindʉ. Po Mbepo Mwikemo alɨnkʉbabʉʉla alɨnkʉtɨ, “Muusʉngʉlɨle Balinaba na Saʉli, ʉkʉbomba ɨmbombo ɨjɨ mbakooleliile.” ");
INSERT INTO nyy_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pabʉngɨ bo biipuutile nʉ kʉfipɨɨka ɨfindʉ, balɨnkʉbabɨɨkapo amaboko Balinaba na Saʉli, po balɨnkʉbatʉma kʉ mbombo. ");
INSERT INTO nyy_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mbepo Mwikemo bo abatʉmile baa Balinaba na Saʉli, balɨnkʉbʉʉka mu Seloikija. Ʉkʉfuma nkaaja ako, balɨnkʉloboka mu nyanja ʉkʉbʉʉka ndʉsʉngo lwa mu Saipulasi. ");
INSERT INTO nyy_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bo bafikile mu Salami kʉ Saipulasi, baalʉmbɨlɨlaga iisyʉ lya Kyala mu sinagogi sya Bajuuta. Baalɨ nagwe Johani, ɨngamu ɨjɨngɨ Maalɨka, ʉkʉbatʉʉla ɨmbombo ɨjo. ");
INSERT INTO nyy_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Baatumuseenie mu Saipulasi, balɨnkʉfika mu Pafu. Mula baalɨmmwagile ʉNjuuta jʉmo, ʉndosi, ʉnkunguluka gwa bʉtʉngʉlʉ, ɨngamu jaake aalɨ jo Bali-Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ʉmundʉ ʉjo aalɨ mbombeli gwa Seligio Paʉli, ʉnkʉlʉmba gwa ndʉsʉngo lwa mu Saipulasi, ʉmundʉ gwa mahala. Ʉnkʉlʉmba ʉjo alɨnkʉbakoolela baa Saʉli na Balinaba kʉmyake, alɨnkʉbabʉʉla ʉkʉtɨ ikʉlonda ʉkʉpɨlɨkɨsya ɨliisyʉ lya Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Looli ʉndosi jʉla, ʉjʉ ɨngamu ɨjɨngɨ bantɨgɨ Elima, aabapɨngaga baa Saʉli na Balinaba, nʉ kʉgela ʉkʉnsofya ʉnkʉlʉmba ʉjo, ʉkʉtɨ alɨngammwitɨka Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Looli Saʉli, ʉjʉ ɨngamu jaake ɨjɨngɨ jo Paʉli, alɨnkwisʉla Mbepo Mwikemo, alɨnkʉnngʼaatulɨla amaaso Elima. ");
INSERT INTO nyy_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉgwe ʉlɨ mwana gwa Seetano, kʉpɨnga syosa ɨngolofu! Bwila kʉbasyoba nʉ kʉbabombela ɨnyali abandʉ. Ʉleke ʉkwandʉla ɨnjɨla ɨngolofu ɨsya Ntwa! ");
INSERT INTO nyy_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Keeta! Lʉlʉʉlʉ ʉNtwa ikʉkʉpapo ʉlʉfundo, ʉlʉ kʉjaga mfwa maaso, kʉkabalɨlo.” Nakalɨnga amaaso gaake galɨnkʉtoligwa ʉkʉkeeta, alɨnkwanda ʉkʉpʉʉsanika nʉ kʉlonda ʉmundʉ gwa kʉnkola ɨkɨboko ʉkʉtɨ anndongosye. ");
INSERT INTO nyy_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Po ʉnkʉlʉmba jʉla bo asibwene ɨsi sibombiigwe, alɨnkʉmmwitɨka ʉNtwa Jesu, paapo syalɨnswigiisye ɨnongwa syake ɨsi baamanyisyaga. ");
INSERT INTO nyy_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Po Paʉli na banine balɨnkwipakɨla mu sitima ʉkʉfuma nkaaja akaa mu Pafu, balɨnkʉbʉʉka mu Pelige nkiisʉ ɨkya mu Pamfilija. Apo Johani, ɨngamu ɨjɨngɨ Maalɨka, alɨnkʉbaleka, alɨnkʉgomoka kʉ Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paʉli na Balinaba balɨnkʉfuma kʉ Pelige, balɨnkwenda ʉkʉbʉʉka nkaaja akaa mu Antyokija, aka kalɨ nkiisʉ ɨkya mu Pisitija. Ɨliisikʉ ɨlya pa Sabati balɨnkwingɨla mu sinagogi, balɨnkʉtʉʉgala. ");
INSERT INTO nyy_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bo gabaliigwe amasyʉ ʉkʉfuma mu ndagɨlo sya Moose na baakalata abaa bakunguluka, abalongosi baa sinagogi balɨnkʉntʉma ʉmundʉ ʉgwa kʉbabʉʉla baa Paʉli na Balinaba ʉkʉtɨ, “Mwe baamyɨtʉ, lɨnga mulɨ nasyo ɨnongwa ɨsya kʉbakasya abandʉ aba, isaga mujobe.” ");
INSERT INTO nyy_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paʉli alɨnkwɨma, alɨnkwinʉla ɨkɨboko ʉkʉnangɨsya ʉkʉtɨ bamyeke, po alɨnkʉjoba alɨnkʉtɨ, “Mwe Banyaisilaɨli, na mwe bandʉ mwe mwingiile ndwitɨko lwɨtʉ, mupɨlɨkɨsye! ");
INSERT INTO nyy_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kyala ʉjʉ twe Banyaisilaɨli tukʉmmwipuuta, aabasalile abiisʉkʉlʉ bɨɨtʉ, aapelile ʉkʉja bingi, bo bikʉtʉʉgala mbʉheesya nkiisʉ kya Misili. Alɨnkʉbatʉʉla na maka gaake amakʉlʉmba ʉkʉsookako kʉla. ");
INSERT INTO nyy_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Alɨnkʉtɨ lyambepa ndʉngalangala, kʉkabalɨlo kaa fyɨnja amalongo mana. ");
INSERT INTO nyy_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Alɨnkʉfipyuta ɨfikolo fihaano na fibɨlɨ ɨfya nkiisʉ kya Kaanaani, alɨnkʉbapapo abiisʉkʉlʉ bɨɨtʉ ɨkiisʉ kɨla ʉkʉja kyabo. ");
INSERT INTO nyy_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Fyakɨndile ɨfyɨnja 450 ʉkʉfuma bo bikwingɨla nkiisʉ ɨkya Misili, mpaka bo bikʉkɨtola ɨkiisʉ kya Kaanaani. “Bo kakɨndilepo akabalɨlo, Kyala alɨnkʉbapapo abalamuli ʉkʉbalongosya, mpaka akabalɨlo akaa nkunguluka Samweli. ");
INSERT INTO nyy_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Akabalɨlo kala, aBanyaisilaɨli balɨnkʉnsʉʉma ʉkʉtɨ abasalɨle ʉmalafyale. Po Kyala alɨnkʉbapapo Saʉli ʉmwana gwa Kisi, ʉmundʉ gwa nkɨkolo kya Benjamini, ʉkʉja malafyale gwabo. Alɨnkʉlongosya kʉkabalɨlo kaa fyɨnja amalongo mana. ");
INSERT INTO nyy_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Looli Kyala alɨnkʉnsoosya Saʉli mbʉnyafyale, alɨnkʉnsala Ndaabɨti ʉkʉja malafyale gwabo. Kyala alɨnkʉnsisimɨkɨsya, alɨnkʉtɨ, ‘Nʉmmwagile Ndaabɨti ʉmwana gwa Jese, ʉmundʉ ʉjʉ ɨndumbula jangʉ jiikyeliile, jo ikʉbombaga ʉbwigane bwangʉ boosa.’ ");
INSERT INTO nyy_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Ʉkʉfuma ndʉjungu lwake ʉmundʉ ʉjʉ, Kyala abatwaliile aBanyaisilaɨli ʉMpoki, jo Jesu, bo muumo aafingiile. ");
INSERT INTO nyy_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesu bo akaalɨ ʉkwanda ɨmbombo jaake, Johani aabalʉmbɨliile aBanyaisilaɨli boosa, ʉkʉtɨ bapɨndʉke nʉ koosigwa. ");
INSERT INTO nyy_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Johani bo ikʉjɨmalɨɨsya ɨmbombo jaake, aababʉʉlaga abandʉ aatɨgɨ, ‘Mukwinogona ʉkʉtɨ ʉne ne ani? Ʉne ngaja jo ʉjʉ mukʉtɨ, jo jʉʉjo! Looli ikwisa kʉnyuma kʉmyangʉ, ʉjʉ ʉne ngabagɨsya koope nʉ kwabʉla ʉtʉkoba ʉtwa filato fyake.’ ");
INSERT INTO nyy_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mwe baamyɨtʉ, mwe baa ndʉjungu lwa Abulahamu, na nuumwe mwe mwingiile ndwitɨko lwa Bajuuta, mupɨlɨkɨsye. Ɨndʉmi jaa bʉpoki jɨtʉmiigwe kʉmyɨtʉ twesa. ");
INSERT INTO nyy_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Abenekaaja kaa Jelusalemu, na balongosi baabo, bakaameenye ʉkʉtɨ Jesu aalɨ Mpoki, balɨnkʉnndonga ʉkʉtɨ agogigwe. Ʉkʉbomba bo ʉlo syaboniike ɨsya Jesu ɨsi baajobile abakunguluka, ɨsi sikʉbaligwa kʉkʉtɨ isikʉ ɨlya pa Sabati. ");
INSERT INTO nyy_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Na paapo bakaajaagile ɨnongwa najɨmo ɨjaa kʉnngogela, balɨnkʉnsʉʉma Pilati ʉkʉtɨ Jesu agogigwe. ");
INSERT INTO nyy_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bo bammbombiile Jesu syosa ɨsi sisimbiigwe mwa Kalata ʉMwikemo, balɨnkʉnsulusya pa kɨkohekano, balɨnkwakʉmmbɨɨka mwi ipʉmba. ");
INSERT INTO nyy_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Looli Kyala aalɨnsyʉsiisye ʉkʉfuma mbafwe. ");
INSERT INTO nyy_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kaa kingi Jesu aabasetʉkɨlaga abandʉ aba aalongeseenie nabo, ʉkʉfuma kʉ Galilai ʉkʉbʉʉka kʉ Jelusalemu. Abo bo bakeeti baake, ʉkʉbabʉʉla abandʉ ʉkʉtɨ asyʉkile. ");
INSERT INTO nyy_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ʉswe tʉlipo apa ʉkʉbabʉʉla ɨNdʉmi ɨNunu, ɨjaa ɨsi Kyala aafingile kʉ biisʉkʉlʉ bɨɨtʉ ʉkʉtɨ ikʉbomba. ");
INSERT INTO nyy_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Asibombile ɨsi aafingile kʉlɨ twe baa ndʉjungu lwabo, kʉ njɨla jaa kʉnsyʉsya Jesu ʉkʉfuma mbafwe, bo ʉlʉ sisimbiigwe mu Sabʉli ɨjaa bʉbɨlɨ ʉkʉtɨ, ‘Ʉgwe ʉlɨ Mwanangʉ, ʉmwisyʉgʉ ʉne ngʉpaapile.’ ");
INSERT INTO nyy_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Kangɨ ɨsya kʉnsyʉsya ʉkʉfuma mbafwe, ʉkʉtɨ ʉmbɨlɨ gwake gʉlɨngabola, Kyala aajobile amasyʉ aga, ‘Ngwisa kʉbapapo ɨsajo ɨnyiikemo ɨsya nalooli, bo ʉlʉ naafingile kwa Ndaabɨti.’ ");
INSERT INTO nyy_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Bo ʉlʉ sisimbiigwe pabʉngɨ mwa kalata gwa Ɨsabʉli ʉkʉtɨ, ‘Ʉtikwitɨkɨsya ʉkʉtɨ ʉmbɨlɨ gwa Mwikemo gwako gʉbolege.’ ” ");
INSERT INTO nyy_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Paʉli alɨnkongelapo ʉkʉjoba alɨnkʉtɨ, “Ndaabɨti bo abombile syosa ɨsya bwigane bwa Kyala nkabalɨlo akaa bandʉ baa ngʉlɨlo jaake, alɨnkʉfwa, balɨnkʉnsyɨla kɨfuki na biisʉkʉlʉ baake, ʉmbɨlɨ gwake gʉlɨnkʉbola. ");
INSERT INTO nyy_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Looli ʉjʉ Kyala aalɨnsyʉsiisye ʉkʉfuma mbafwe akaabolile. ");
INSERT INTO nyy_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Po leelo mwe baamyɨtʉ, mumanyege ʉkʉtɨ, ɨndʉmi ɨjaa kʉhobokeligwa ʉbʉtʉlanongwa kʉ njɨla jaa Jesu, jikʉfumusigwa kʉmyɨnu. ");
INSERT INTO nyy_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kʉ njɨla jaake, kʉkʉtɨ mundʉ ʉjʉ ikʉmmwitɨka, ikʉbaligwa na Kyala ʉkʉja ngolofu kʉlɨ syosa ɨsi akaabagiile ʉkʉbaligwa ʉkʉja ngolofu kʉ njɨla jaa ndagɨlo sya Moose. ");
INSERT INTO nyy_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mujege maaso, singiisa kʉbaaga ɨnongwa ɨsi baajobile abakunguluka ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Amupɨlɨkɨsye ʉmwe mwe baa loobelo, muswigege, mufwege. Ʉne ngwisa kʉbomba simo ɨsisya mmasikʉ gɨɨnu, ɨsi mutikwisa kwitɨkamo sikʉ ʉkʉtɨ nsibombile, nalɨnga ʉmundʉ jʉmo ikʉbabʉʉla!’ ” ");
INSERT INTO nyy_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paʉli na Balinaba bo bikʉsooka mu sinagogi jɨla, abandʉ balɨnkʉbasʉʉma ʉkʉtɨ biise pa Sabati ɨjɨ jikwisa, isababamanyisye kangɨ ɨnongwa ɨsyo. ");
INSERT INTO nyy_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bo lʉmaliike ʉlʉkomaano ʉlwa mu sinagogi, aBajuuta abingi na bandʉ aba bingiile ndwitɨko lwa Bajuuta, balɨnkwanda ʉkʉbakonga baa Paʉli na Balinaba. Po Paʉli na Balinaba, baajobaga nabo, balɨnkʉbakasya ʉkʉtɨ, bʉʉmɨɨlɨlege ɨliipyana ɨlya Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Po pa Sabati ɨjɨ jaakongile, abandʉ bingi, ko kʉja akaaja koosa, baaliisile kʉkʉbapɨlɨkɨsya baa Paʉli na Balinaba, bo bikʉlʉmbɨlɨla iisyʉ lya Ntwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Looli aBajuuta bingi bo bakɨbwene ɨkɨlʉndɨlo kya bandʉ, balɨnkʉkoligwa nʉ bʉʉfi, balɨnkwanda ʉkʉsipɨnga ɨsi Paʉli aalʉmbɨlɨlaga, nʉ kʉntʉka. ");
INSERT INTO nyy_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paʉli na Balinaba balɨnkʉjoba kɨsita kʉtiila, balɨnkʉtɨ, “Twalondigwaga ʉkʉlʉmbɨlɨla taasi ɨliisyʉ lya Kyala kʉmyɨnu. Looli paapo mulɨkaanile, nʉ kwibona ʉkʉtɨ mukabagɨsya ʉkʉkaba ʉbʉʉmi bwa bwila na bwila, po tʉbalekile, tukwakʉbalʉmbɨlɨlaga aba bakaja Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tukʉbomba bo ʉlo paapo ʉNtwa atʉlagiile atile, ‘Ngʉbɨɨkile ʉkʉja lʉmuli kʉ bandʉ abaa mfikolo ɨfingi, ʉkʉtɨ ʉbatwalɨle abandʉ ʉbʉpoki, mpaka kʉno kɨmalɨkiile ɨkiisʉ.’ ” ");
INSERT INTO nyy_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Abandʉ aba bakaja Bajuuta bo bapɨliike amasyʉ ago, balɨnkʉlɨtuufya iisyʉ lya Ntwa. Po aba baasʉngʉliigwe ʉkʉkaba ʉbʉʉmi bwa bwila na bwila, balɨnkʉja biitɨki. ");
INSERT INTO nyy_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Iisyʉ lya Ntwa lyabalanilaga nkiisʉ kɨla. ");
INSERT INTO nyy_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Looli aBajuuta balɨnkʉbasonga abakiikʉlʉ abakabi aba baalingiile ndwitɨko lwa Bajuuta, na balongosi baa kaaja kala. Balɨnkwanda ʉkʉbataamya baa Paʉli na Balinaba, balɨnkʉbakaga nkaaja kaabo. ");
INSERT INTO nyy_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Po Paʉli na Balinaba balɨnkʉbakungʼundɨla ɨfumbɨ jaa mmalʉndɨ gaabo ʉkʉbasoka, balɨnkʉbʉʉka nkaaja akaa mu Ikonija. ");
INSERT INTO nyy_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Looli abiitɨki baa Jesu baahobokaga fiijo, baaliiswile ʉlʉsekelo na Mbepo Mwikemo. ");
INSERT INTO nyy_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Bo bafikile kʉ Ikonija, koope Paʉli na Balinaba balɨnkwingɨla mu sinagogi jaa Bajuuta, bo ʉlʉ kaajɨɨliile akajɨɨlo kaabo. Ʉkʉkongana nʉ kʉlʉmbɨlɨla kwabo, ɨkɨlʉndɨlo ɨkɨnywamu ɨkya Bajuuta na aba bakaja Bajuuta balɨnkʉmmwitɨka Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Looli aBajuuta bamo balɨnkʉkaana ʉkʉmmwitɨka Jesu. Abo balɨnkwanda ʉkʉbasonga abandʉ aba bakaja Bajuuta, ʉkʉtɨ babakalalɨle abiitɨki abo. ");
INSERT INTO nyy_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paʉli na Balinaba balɨnkʉtʉʉgala ʉko akabalɨlo akatali, baalʉmbɨlɨlaga kɨsita kʉtiila, bansʉʉbɨlaga ʉNtwa Jesu. ɄNtwa aabapaga amaka agaa kʉbomba ɨfiika ɨfikʉlʉmba. Kʉ njɨla ɨjo aanangɨsyaga ʉkʉtɨ ɨsi baalʉmbɨlɨlaga, ɨsya ipyana lyake, syalɨ sya nalooli. ");
INSERT INTO nyy_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Looli abandʉ baa nkaaja ako baatapʉkeene, bamo balɨnkʉja kʉ lʉbafu lwa Bajuuta aba bakaaliitiike, abangɨ balɨnkʉja kʉ lʉbafu lwa batʉmigwa Paʉli na Balinaba. ");
INSERT INTO nyy_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Po bamo aba bakaja Bajuuta na Bajuuta, pamopeene na balongosi baabo, balɨnkwitɨkana ʉkʉbabombela kabiibi baa Paʉli na Balinaba, nʉ kʉbatuunya na mabwe. ");
INSERT INTO nyy_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bo basipɨliike ɨnongwa ɨsyo, Paʉli na Balinaba balɨnkʉbopela nkiisʉ ɨkya mu Likaonija, ntwaja ʉtwa mu Lisitila na mu Ndelibe. ");
INSERT INTO nyy_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ʉko baalʉmbɨlɨlaga ɨNdʉmi ɨNunu. ");
INSERT INTO nyy_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nkaaja akaa mu Lisitila, aaliko ʉmundʉ jʉmo ʉjʉ aakwemaga, aalemeele amalʉndɨ ʉkʉfuma munda mu nna, akaalyendilemo sikʉ. ");
INSERT INTO nyy_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ʉmundʉ ʉjʉ ampɨlɨkɨsyaga Paʉli bo ikʉlʉmbɨlɨla. Paʉli alɨnkʉnkeeta fiijo ʉmundʉ jʉla, alɨnkʉmmbona ʉkʉtɨ alɨ nʉ lwitɨko, ʉlwa kʉtɨ abagiile ʉkʉbʉmbʉlʉsigwa. ");
INSERT INTO nyy_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Po Paʉli alɨnkʉlaata ʉkʉmmbʉʉla alɨnkʉtɨ, “Ɨma!” Ʉmundʉ jʉla alɨnkwɨma mbɨbɨmbɨbɨ, alɨnkwanda ʉkwenda. ");
INSERT INTO nyy_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Abandʉ bingi baabʉngeene pala. Bo basibwene ɨsi sibombiigwe na Paʉli, balɨnkʉlaata ʉkʉjoba mu njobelo jaabo ɨjaa Kɨlikaonija, balɨnkʉtɨ, “Gyabaakyala giipelile ʉkʉboneka ngatɨ bandʉ, gɨtʉsulukiile!” ");
INSERT INTO nyy_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Balɨnkʉjoba ʉkʉtɨ, Balinaba lyo lyakyala ikʉlʉmba, ɨlɨ ɨngamu jaake jo Selu, na Paʉli balɨnkʉmpapo ɨngamu ɨjaa Elime, paapo Paʉli jo ʉjʉ aajobaga. ");
INSERT INTO nyy_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kɨfuki na nkaaja, jaalipo ɨtempeli ɨjɨ abandʉ biipuutaga kwa Selu. Po ʉmpuuti gwa tempeli jɨla, alɨnkʉtwala ɨngambakʉ ibɨlɨ nɨ ngɨga sya bʉlenge nkaaja. Aalondaga ʉmwene pamopeene nɨ kɨlʉndɨlo kya bandʉ, ʉkʉbasookesya ɨliikemo ɨlya kʉbɨɨmɨka baa Paʉli na Balinaba. ");
INSERT INTO nyy_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Looli abatʉmigwa Balinaba na Paʉli, bo bapɨliike ɨnongwa ɨsyo, balɨnkʉnyaafulania ɨmyenda gyabo ʉkʉnangɨsya ʉbʉkalale, balɨnkʉbopela nkɨlʉndɨlo kya bandʉ, balɨnkʉlaata balɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mwe bandʉ ʉmwe, fiki mukʉbomba ɨsyo? Ʉswe tʉlɨ bandʉ itolo bo jʉjʉʉmwe. Tʉlipo apa tukʉbalʉmbɨlɨla ɨNdʉmi ɨNunu, ʉkʉtɨ mugɨleke gyabaakyala gɨkaja nɨ mbombo najɨmo. Mupɨndʉke, munkonge Kyala ʉMʉʉmi, ʉjʉ apelile ʉmpaalanga, ɨkiisʉ nɨ nyanja, na fyosa ɨfi filimo ʉmo. ");
INSERT INTO nyy_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ijolo Kyala aabalekile abandʉ boosa, ʉkʉbomba ɨsi bikʉsilonda abeene, ");
INSERT INTO nyy_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","na paapo akaalekile ʉkwibonesya mu mbombo ɨnunu ɨsi ikʉbabombela. Aabatwalɨlaga ʉmwe ɨfula, nɨ seke ʉkʉpa pakabalɨlo akabagɨsye. Aabapaga ɨmboto jaa findʉ nʉ kʉbiisʉkɨsya ʉlʉsekelo mu ndumbula syɨnu.” ");
INSERT INTO nyy_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Na paapo baajobile amasyʉ ago, kwalɨ kʉpalapala fiijo Paʉli na Balinaba ʉkʉbasigɨla abandʉ ʉkʉbasookesya ɨliikemo. ");
INSERT INTO nyy_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Po baaliisile aBajuuta bamo ʉkʉfuma kʉ Antyokija na kʉ Ikonija, balɨnkʉbasonga abandʉ bingi ʉkʉtɨ balɨngasiitɨkaga ɨsi aalʉmbɨlɨlaga Paʉli. Abo boosa balɨnkʉntuunya Paʉli na mabwe, balɨnkʉnkwaba ʉkʉnsoosya nkaaja, paapo baatɨgɨ afwile. ");
INSERT INTO nyy_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Looli abiitɨki baa Jesu balɨnkʉnsyʉngʉʉtɨlɨla Paʉli, po alɨnkwɨma, alɨnkʉbʉʉka nkaaja. Kɨlaabo kyake alɨnkʉsookapo apo, alɨnkʉbʉʉka pamopeene na Balinaba nkaaja akaa mu Ndelibe. ");
INSERT INTO nyy_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paʉli na Balinaba bo balʉmbɨliile ɨNdʉmi ɨNunu mu Ndelibe, abandʉ bingi balɨnkʉmmwitɨka Jesu. Paʉli na Balinaba balɨnkʉbʉʉka kangɨ kʉ Lisitila, po balɨnkʉbʉʉka kʉ Ikonija na kʉ Antyokija. ");
INSERT INTO nyy_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Moosa ʉmo, baaganilaga na biitɨki, baabasʉʉbɨsyaga nʉ kʉbakasya ʉkʉʉmɨɨlɨla ʉlwitɨko, baatɨgɨ, “Tukʉkaba ʉbʉtolwe bwingi, mpaka nkabalɨlo akaa kwingɨla mBʉnyafyale bwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kʉkʉtɨ kɨpanga ɨkɨ baabʉʉkaga, baabasaliile abiitɨki ʉkʉja bakʉʉlʉ baa kɨpanga. Kʉ njɨla jaa nyiipuuto nʉ kʉfipɨɨka ɨfindʉ, baababɨɨkaga mu Ntwa Jesu ʉjʉ baalɨmmwitiike, abalɨndɨlɨlege. ");
INSERT INTO nyy_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Po Paʉli na Balinaba balɨnkʉkɨɨsania nkiisʉ kya Pisitija, balɨnkwingɨla nkiisʉ ɨkya mu Pamfilija, ");
INSERT INTO nyy_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","balɨnkʉfika mu Pelige. Ʉmo balɨnkʉmanyisya iisyʉ lya Kyala, po balɨnkʉbʉʉka mu Atalija. ");
INSERT INTO nyy_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ʉkʉfuma kʉla balɨnkwipakɨla mu sitima, ʉkʉbʉʉka kʉ Antyokija, kʉno kʉbwandɨlo abiitɨki baabasʉʉmiile kʉ mbombo ɨjɨ baajɨmalɨɨsiisye ʉkʉjɨbomba. ");
INSERT INTO nyy_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Bo bafikile kʉ Antyokija, Paʉli na Balinaba balɨnkʉkoolela ʉlʉkomaano lwa kɨpanga kya Kyala, balɨnkʉbabʉʉla syosa ɨsi Kyala aabombile ʉkwendela mmyabo, nʉ kʉtɨ abiigʉliile abandʉ aba bakaja Bajuuta ʉkʉmmwitɨka Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Po balɨnkʉtʉʉgala na biitɨki abo amasikʉ mingi. ");
INSERT INTO nyy_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Paʉli na Balinaba bo balɨ mu Antyokija, abiitɨki bamo aBajuuta balɨnkʉfuma mu Jutai, balɨnkwisa, balɨnkwanda ʉkʉbamanyisya abiitɨki aba bakaja Bajuuta ʉkʉtɨ, “Lɨnga mukabuutigwa kʉkyeni ʉkʉkongana nɨ ndagɨlo sya Moose, mukabagɨla ʉkʉpokigwa.” ");
INSERT INTO nyy_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paʉli na Balinaba baakaanikeene fiijo na aba baamanyisyaga ɨsyo. Po ɨkɨpanga kya Kyala ɨkya mu Antyokija, kɨlɨnkʉbasala baa Paʉli na Balinaba na biitɨki bamo, ʉkʉtɨ bakajobe na batʉmigwa pamopeene na bakʉʉlʉ baa kɨpanga kya Kyala ɨkya mu Jelusalemu, ɨnongwa ɨjɨ baakaanikanaga. ");
INSERT INTO nyy_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Po abiitɨki abo abaa mu Antyokija balɨnkʉbatʉma baa Paʉli na banine ʉkʉbʉʉka kʉ Jelusalemu. Balɨnkʉkɨɨsania nkiisʉ ɨkya mu Foinike nɨ kya Samalija, ʉmo baababʉʉlaga abiitɨki ʉkʉtɨ boope aba bakaja Bajuuta bapokiigwe. Ɨnongwa ɨsyo silɨnkʉbahobosya abiitɨki boosa. ");
INSERT INTO nyy_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Paʉli na banine bo bafikile kʉ Jelusalemu, balɨnkwambɨlɨligwa nɨ kɨpanga kya Kyala, abatʉmigwa na bakʉʉlʉ baa kɨpanga. Balɨnkʉbabʉʉla syosa ɨsi Kyala aabombile ʉkwendela mmyabo. ");
INSERT INTO nyy_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Po abiitɨki bamo, abaa nkɨbugutɨla kya Bafalisai, balɨnkwɨma balɨnkʉtɨ, “Abiitɨki aba bakaja Bajuuta mpaka babuutigwe kʉkyeni, kangɨ balagɨligwe ʉkʉsikonga ɨndagɨlo sya Moose.” ");
INSERT INTO nyy_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Po abatʉmigwa na bakʉʉlʉ baa kɨpanga balɨnkʉkomaana, ʉkʉtɨ bajɨkeete ɨnongwa ɨjo. ");
INSERT INTO nyy_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bo bajobeseenie kʉkabalɨlo akatali, Peeteli alɨnkwɨma, alɨnkʉbabʉʉla alɨnkʉtɨ, “Baamyɨtʉ ndwitɨko, mumeenye ʉkʉtɨ kʉbwandɨlo, Kyala aalɨɨsalile ʉne ʉkʉfuma pakatɨ pamyɨnu, ʉkʉbalʉmbɨlɨla abandʉ aba bakaja Bajuuta, ʉkʉtɨ bajɨpɨlɨke ɨNdʉmi ɨNunu nʉ kʉjiitɨka. ");
INSERT INTO nyy_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kyala, ʉjʉ asimeenye ɨndumbula sya bandʉ, aanangiisye ʉkʉtɨ abiitiike aba bakaja Bajuuta, kʉ njɨla jaa kʉbapa Mbepo Mwikemo, bo ʉlʉ aatʉpeele ʉswe. ");
INSERT INTO nyy_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kyala akaabɨɨkilepo ʉkʉkɨndana ʉswe na beene, aabeelwisye ɨndumbula syabo boope, kʉ njɨla jaa kʉmmwitɨka ʉNtwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Fiki mukʉbatwɨka abiitɨki abo ɨkɨtwalo ɨkya kʉsikonga ɨndagɨlo sya Moose, ɨkɨ na biisʉkʉlʉ bɨɨtʉ baatoliigwe ʉkʉpɨmba, kangɨ na nuuswe tʉtoliigwe? Po fiki mukʉnngela Kyala kʉ njɨla ɨjo? ");
INSERT INTO nyy_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Silɨngajaga bo ʉlo, looli tukwitɨka ʉkʉtɨ ʉswe bo abeene, kwi ipyana lya Ntwa Jesu ko kʉno tukʉpokigwa.” ");
INSERT INTO nyy_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ɨkɨlʉndɨlo kyosa kɨlɨnkwendelela ʉkʉmyeka, balɨnkʉbapɨlɨkɨsya baa Paʉli na Balinaba, bo bikʉbapangɨla ɨfiika ɨfikʉlʉmba, ɨfi Kyala aabapelelaga abandʉ aba bakaja Bajuuta, ʉkwendela mu mbombo ɨsi baabombaga Paʉli na Balinaba. ");
INSERT INTO nyy_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bo bamalile ʉkʉjoba, Jaakobo alɨnkʉbaamula alɨnkʉtɨ, “Baamyɨtʉ ndwitɨko, namumbɨlɨkɨsye! ");
INSERT INTO nyy_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni Peeteli atʉlɨngeenie muno Kyala kʉbwandɨlo aabakeetile abandʉ aba bakaja Bajuuta, ʉkʉbasalamo bamo ʉkʉja bandʉ baake. ");
INSERT INTO nyy_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ɨsyo sikwitɨkana nɨ sya mwa baakalata abaa bakunguluka ʉkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘ɄNtwa Kyala aatile, “Ɨsyo bo sikɨndile, ngwisa kʉgomoka, isangwisa kʉbʉbɨɨka kangɨ ʉbʉnyafyale bwa Ndaabɨti. Ngʉjenga kangɨ ɨkɨtangaalala kyake ɨkɨ kyagwile, nʉ kwisa kʉkyɨmɨka. ");
INSERT INTO nyy_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Po abandʉ abangɨ boosa bikʉʉndondaga, abandʉ abaa mfiisʉ ɨfingi, aba mbakooliile ʉkʉtɨ bajege bangʉ.” Ɨsyo ajobile ʉNtwa, ʉjʉ abombile ɨsyo,’ ");
INSERT INTO nyy_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ɨsi syamanyiigwe ʉkʉfuma liijolo.” ");
INSERT INTO nyy_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jaakobo alɨnkwendelela ʉkʉjoba alɨnkʉtɨ, “Ʉne ngeetile ʉkʉtɨ, tʉlɨngabataamyaga abandʉ aba bakaja Bajuuta, aba bapɨndwike, bankongile Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Looli tʉbasimbɨle kalata ʉkʉbabʉʉla ʉkʉtɨ basikongege ɨndagɨlo simo ɨsya Moose. Kokʉtɨ balɨngalyaga ɨfindʉ ɨfi bagɨsookiisye gyabaakyala ʉkʉja ikemo, balɨngalogwaga, balɨngalyaga ɨnyama ɨsya finyamaana ɨfi finiongotoliigwe amakosi, balɨngalyaga iilopa. ");
INSERT INTO nyy_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ngʉlagɨla bo ʉlo paapo ʉkʉfuma liijolo ɨndagɨlo sya Moose sikʉlʉmbɨlɨligwa kʉkʉtɨ kaaja, sikʉbaligwa kʉkʉtɨ Sabati mu sinagogi.” ");
INSERT INTO nyy_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ɨsi aajobile Jaakobo, abatʉmigwa, abakʉʉlʉ nɨ kɨpanga kyosa ɨkya Kyala ɨkya mu Jelusalemu baaliitiike. Baatumwile ʉkʉbasalamo abandʉ nkɨbugutɨla kyabo, nʉ kʉbatʉma kʉ Antyokija pamopeene na Paʉli na Balinaba. Baabasalile Juuta (ʉjʉ bantɨgɨ Balisaba) na Sila, aba baalɨ balongosi baa kɨpanga. ");
INSERT INTO nyy_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Balɨnkʉbapa kalata ʉjʉ asimbiigwe ʉkʉtɨ, Ʉswe twe batʉmigwa na bakʉʉlʉ baa kɨpanga kya Kyala, ʉswe twe biinɨɨnu, tukʉbaponia ʉmwe mwe mukaja Bajuuta, mwe mulɨ kʉ Antyokija, nkiisʉ ɨkya Silija na Kilikija. ");
INSERT INTO nyy_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tʉpɨliike ʉkʉtɨ abandʉ bamo, ʉkʉfuma nkɨbugutɨla kyɨtʉ, bikʉbataamya na masyʉ gaabo, bikʉbabʉʉla ɨsi sikoonanga ɨndumbula syɨnu. Looli ʉswe tʉkabatʉmapo. ");
INSERT INTO nyy_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Po twitɨkeene, ʉkʉbasala abandʉ bamo, nʉ kʉbatʉma kʉmyɨnu, pamopeene na bakʉndwe Balinaba na Paʉli. ");
INSERT INTO nyy_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Abo batikʉpaasya ʉkʉfwa, kʉnongwa jaa kʉmmbombela ʉNtwa gwɨtʉ Jesu Kɨlɨsiti. ");
INSERT INTO nyy_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Po leelo tʉbatʉmile kʉmyɨnu Juuta na Sila, ʉkʉtɨ bababʉʉle ɨsi tʉsimbile, na kanwa kaabo. ");
INSERT INTO nyy_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Mbepo Mwikemo na nuuswe, twagile kanunu ʉkʉtɨ tʉlɨngabatwɨka ɨkɨtwalo ɨkya kʉsikonga ɨndagɨlo ɨsya Bajuuta, ʉkʉkɨndapo pa ndagɨlo ɨsi: ");
INSERT INTO nyy_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mulɨngalyaga ɨfindʉ ɨfi bagɨsookiisye gyabaakyala ʉkʉja ikemo, mulɨngalyaga ɨnyama ɨsya finyamaana ɨfi finiongotoliigwe amakosi, mulɨngalyaga iilopa, kangɨ mulɨngalogwaga. Lɨnga mukʉbomba bo ʉlo po munosiisye. Mugonege! ");
INSERT INTO nyy_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Po Paʉli na banine baatʉmiigwe ʉkʉbʉʉka kʉ Antyokija. Bo bafikile, balɨnkʉbabʉngaania abiitɨki boosa, balɨnkʉbapapo kalata jʉla. ");
INSERT INTO nyy_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Abiitɨki bo babalɨliigwe kalata, baahobwike paapo jaalɨ na masyʉ agaa kʉbakasya. ");
INSERT INTO nyy_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juuta na Sila, boope baalɨ bakunguluka, balɨnkʉjoba na biitɨki biinaabo amasyʉ gaa mingi, agaa kʉbasʉʉbɨsya nʉ kʉbakasya ndwitɨko. ");
INSERT INTO nyy_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bo bagonilepo, abiitɨki abaa nkɨpanga kya Kyala ɨkya mu Antyokija balɨnkʉbalaga nʉ lʉtengaano, ʉkʉgomoka kʉ Jelusalemu kʉlɨ aba baabatʉmile.  ");
INSERT INTO nyy_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Looli Sila alɨnkwaga kanunu ʉmwene ʉkʉsyala kʉlakʉla. ");
INSERT INTO nyy_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paʉli na Balinaba balɨnkʉsyala kʉ Antyokija, baamanyisyaga nʉ kʉlʉmbɨlɨla iisyʉ lya Ntwa Jesu, pamopeene na bandʉ abangɨ abingi. ");
INSERT INTO nyy_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Amasikʉ manandɨ bo gakɨndilepo, Paʉli alɨnkʉmmbʉʉla Balinaba alɨnkʉtɨ, “Tʉgomoke tʉkabakeete abiitɨki ntwaja toosa, ʉtʉ twalʉmbɨlɨlaga iisyʉ lya Ntwa Jesu, tʉkabakeete muno bajɨɨliile ndwitɨko.” ");
INSERT INTO nyy_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Balinaba alɨnkʉlonda ʉkʉtɨ babʉʉke nagwe Johani, ʉjʉ ɨngamu ɨjɨngɨ bantɨgɨ Maalɨka. ");
INSERT INTO nyy_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Looli Paʉli akaalondaga ʉkʉbʉʉka na Maalɨka, paapo ʉlʉtasi Maalɨka aabalekile kʉ Pamfilija, akaalondaga ʉkʉbomba nabo ɨmbombo. ");
INSERT INTO nyy_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Iisyʉ ɨlyo lɨlɨnkʉtwala ʉlʉkaani ʉlʉkʉlʉmba, lʉlɨnkʉbapelela ʉkʉtapʉkana. Balinaba alɨnkʉmmwega Maalɨka, balɨnkwipaka mu sitima, ʉkʉbʉʉka kʉ Saipulasi. ");
INSERT INTO nyy_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Looli Paʉli alɨnkʉnsala Sila. Abiitɨki balɨnkʉbasʉʉmɨla ɨliipyana lya Kyala, po Paʉli na Sila balɨnkʉsookako kʉ Antyokija. ");
INSERT INTO nyy_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Baalyendile nkiisʉ ɨkya mu Silija na mu Kilikija, baafikasyaga ɨfipanga fya Kyala ndwitɨko. ");
INSERT INTO nyy_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paʉli na Sila balɨnkʉfika mu Ndelibe, po balɨnkʉbʉʉka mu Lisitila. Ʉko aaliko ʉmwitɨki gwa Jesu jʉmo, ɨngamu jaake Timoti. Ʉgwise akaalɨ Njuuta, ʉnna aalɨ Njuuta ʉjʉ aalɨmmwitiike Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Abiitɨki abaa mu Lisitila na mu Ikonija, bannjobaga Timoti ʉkʉja mundʉ nnunu. ");
INSERT INTO nyy_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paʉli alɨnkʉnndonda Timoti ʉkʉtɨ alongosaniege nagwe mu mbombo. Po alɨnkʉmmbuuta kʉkyeni. Aabombile bo ʉlo ʉkʉtɨ aBajuuta aba balimo ntwaja tʉla balɨngankaanaga, paapo baameenye ʉkʉtɨ ʉgwise akaalɨ Njuuta. ");
INSERT INTO nyy_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Paʉli na banine bo bikʉkɨnda ntwaja ʉtwa kʉla, balɨnkʉbabʉʉla abiitɨki aba bakaja Bajuuta, ʉkʉtɨ basikongege ɨndagɨlo ɨsi baaliitɨkeene abatʉmigwa na bakʉʉlʉ baa kɨpanga kya Kyala ɨkya mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Po ɨfipanga fya Kyala fyakakaga ndwitɨko, na biitɨki bongelelaga kʉkʉtɨ isikʉ. ");
INSERT INTO nyy_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paʉli na banine, baalondaga ʉkwakʉlʉmbɨlɨla iisyʉ lya Ntwa Jesu nkiisʉ ɨkya mu Asija, looli Mbepo Mwikemo alɨnkʉbakaanisya. Po balɨnkʉkɨnda nkiisʉ ɨkya Filigija nɨ kya Galatija. ");
INSERT INTO nyy_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bo bafikile mu mpaka gwa kiisʉ ɨkya mu Misija, balɨnkʉlonda ʉkwingɨla nkiisʉ ɨkya mu Bitinija, leelo Mbepo Mwikemo ʉkʉfuma kwa Jesu akaabiitɨkiisye. ");
INSERT INTO nyy_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Po balɨnkʉkɨnda mu Misija, balɨnkʉbʉʉka kʉ Tiloja. ");
INSERT INTO nyy_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ɨkɨlo kɨla, Paʉli alɨnkʉsibona ɨsya mbʉsetʉka ɨsya mundʉ ʉgwa mu Maketonija, aalyɨmile nkyeni mmyake, aapyelesyaga, aatɨgɨ, “Loboka, gwise kʉ Maketonija, ʉtʉtʉʉle.” ");
INSERT INTO nyy_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paʉli bo asibwene ɨsyo ɨsya mbʉsetʉka, tʉlɨnkʉmanya ʉkʉtɨ Kyala aatʉkooliile kʉkʉbalʉmbɨlɨla abandʉ abo ɨNdʉmi ɨNunu, po tʉlɨnkwitendekesya ʉkʉbʉʉka mu Maketonija. ");
INSERT INTO nyy_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Po ʉko kʉ Tiloja, tʉlɨnkwipakɨla mu sitima, tʉlɨnkʉsookako, tʉlɨnkʉbʉʉka ndʉsʉngo lwa mu Samatilake, kɨlaabo kyake tʉlɨnkʉfika mu Nijapoli. ");
INSERT INTO nyy_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ʉkʉfuma ʉko tʉlɨnkʉfika mu Filipi, akaaja kamo akakʉlʉmba ʉko kʉ Maketonija, kaalɨ kaaja aka baatʉʉgalaga aBalooma. Twatʉʉgeele nkaaja kala amasikʉ manandɨ. ");
INSERT INTO nyy_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pi isikʉ ɨlya pa Sabati tʉlɨnkʉsookamo nkaaja, tʉlɨnkʉbʉʉka kʉmbalɨ kʉ lwɨsi, twasʉʉbɨlaga ʉkʉtɨ tukwakʉbwaga ʉbʉjo ʉbʉ abandʉ bikwipuutamo. Tʉlɨnkʉtʉʉgala, tʉlɨnkʉjoba na bakiikʉlʉ aba baabʉngeene pala, ʉkwipuuta. ");
INSERT INTO nyy_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ndɨ bala baapɨlɨkɨsyaga aalipo ʉnkiikʉlʉ jʉmo, ɨngamu jaake Litija, ʉmʉʉlɨsya myenda ɨmifubɨɨfu ʉbʉtiitʉ ɨgya ntengo fiijo. Akaapaapiigwe Njuuta, looli aalingiile ndwitɨko lwa Bajuuta, aalɨ gwa nkaaja akaa mu Tyatila. Aatʉpɨlɨkiisye, paapo ʉNtwa aalɨmmwigwile ɨndumbula jaake, alɨnkwitɨka ɨsi aajobaga Paʉli. ");
INSERT INTO nyy_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Alɨnkoosigwa, ʉmwene na bandʉ baa nnyumba jaake, alɨnkʉtʉpyelesya alɨnkʉtɨ, “Lɨnga muumbwene ʉkʉtɨ nalooli nʉmmwitiike ʉNtwa Jesu, tʉbʉʉke mukatʉʉgalege mu nyumba jangʉ.” Alɨnkʉtʉfimbɨlɨsya fiijo mpaka twaliitiike. ");
INSERT INTO nyy_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ɨliisikʉ lɨmo bo tukʉbʉʉka pa bwipuutɨlo, tʉlɨnkwaganila nʉ ndɨndwana jʉmo ʉntʉmwa, ʉjʉ aalɨ nɨ mbepo ɨnyali ɨjaa kʉlagʉla. Ʉndɨndwana ʉjo aabakabɨlaga ɨndalama ɨnyingi abatwa baake kʉ mbombo jaa kʉlagʉla. ");
INSERT INTO nyy_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Po ʉndɨndwana ʉjo alɨnkʉnkongesya Paʉli na nuuswe, aalaataga aatɨgɨ, “Abandʉ aba babombeli baa Kyala ʉNkʉlʉmba, bikʉbalʉmbɨlɨla ʉmwe ɨnjɨla ɨjaa bʉpoki!” ");
INSERT INTO nyy_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Aabombaga bo ʉlo amasikʉ mingi. Looli iisikʉ lɨmo bo ʉndɨndwana ʉjo ikʉjoba ɨsyo, Paʉli aakaleele. Po alɨnkʉnsanukɨla ʉndɨndwana, alɨnkʉjɨbʉʉla ɨmbepo ɨnyali jɨla alɨnkʉtɨ, “Nikʉkʉlagɨla mu ngamu jaa Jesu Kɨlɨsiti, sookamo mu ndɨndwana ʉjʉ!” Nakalɨnga jɨlɨnkʉsookamo. ");
INSERT INTO nyy_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Abatwa abaa ndɨndwana jʉla, bo baagile ʉkʉtɨ ʉlʉsʉʉbɨlo lwabo ʉlwa kʉkabɨlamo ɨndalama lʉmaliike, balɨnkʉbakola baa Paʉli na Sila, balɨnkʉbaluusa mpaka pa kɨbanja ɨkya lʉkomaano, nkyeni mbalongosi. ");
INSERT INTO nyy_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Balɨnkʉbasitaaka balɨnkʉtɨ, “Abandʉ aba Bajuuta, bikʉleefya nkaaja kɨɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bikʉmanyisya ɨnyiiho syabo, ɨsi ɨndagɨlo syɨtʉ twe Balooma sitʉkaaniisye ʉkʉsiitɨka pamo ʉkʉsikonga.” ");
INSERT INTO nyy_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ɨkɨlʉndɨlo ɨkya bandʉ kɨlɨnkongaana na aba baabasitaakaga baa Paʉli na Sila, balɨnkʉbaalʉkɨla. Po abalongosi balɨnkʉbafuula ɨmyenda baa Paʉli na Sila, nʉ kʉlagɨla ʉkʉtɨ bakomigwe nɨ ngili. ");
INSERT INTO nyy_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bo babakomile fiijo, balɨnkʉbapinya mu nnyololo, po abalongi balɨnkʉnndagɨla ʉnkʉlʉmba gwa nnyololo ʉkʉtɨ abalɨndɨlɨlege fiijo. ");
INSERT INTO nyy_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ʉkʉkongana nʉ lʉlagɨlo ʉlʉ, ʉnkʉlʉmba gwa nnyololo alɨnkʉbiigalɨla nkyumba ɨkya kʉ sofu fiijo, nʉ kʉbingɨsya amalʉndɨ mwi ibokosi ɨlya matapwa. ");
INSERT INTO nyy_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pakɨlo pakatɨ, Paʉli na Sila biipuutaga nʉ kwɨmba ɨnyɨmbo ɨsya kʉntuufya Kyala. Abapinyigwa abangɨ babapɨlɨkɨsyaga. ");
INSERT INTO nyy_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nakalɨnga akasenyenda akakʉlʉmba kalɨnkʉboneka, syope nɨ nyaalo sya nnyololo silɨnkʉsukaanika. Nakalɨnga ɨnyiigi syosa silɨnkwigʉka, nɨ minyololo ɨgɨ baapinyiigwe kʉkʉtɨ mundʉ gɨlɨnkwabʉka. ");
INSERT INTO nyy_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ʉnkʉlʉmba gwa nnyololo bo alembwike, alɨnkwaga ɨnyiigi silɨ bwasi. Alɨnkʉfyʉtʉla ʉlʉʉbo lwake ʉkʉtɨ iigoge, paapo iinogonaga ʉkʉtɨ abapinyigwa boosa bajongile. ");
INSERT INTO nyy_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Looli Paʉli alɨnkʉlaata fiijo alɨnkʉtɨ, “Ʉlɨngiigoga, twesa tʉlimo muno.” ");
INSERT INTO nyy_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ʉnkʉlʉmba gwa nnyololo jʉla alɨnkʉlagɨla ababombeli baake ʉkʉtɨ batwale ɨnyaale. Bo bantwaliile, alɨnkwingɨla nkyumba, alɨnkʉgwa ʉlʉpi nkyeni mwa baa Paʉli na Sila bo ikʉtetema. ");
INSERT INTO nyy_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Po alɨnkʉbʉʉka nabo panja, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Batwa bangʉ, mbombe fiki ʉkʉtɨ mbokigwe?” ");
INSERT INTO nyy_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Abeene balɨnkʉmmwamula balɨnkʉtɨ, “Ʉgwe ʉmmwitɨke ʉNtwa Jesu, pamopeene na baa nnyumba jaako, po mukʉpokigwa.” ");
INSERT INTO nyy_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Po Paʉli na Sila balɨnkʉnndʉmbɨlɨla ʉnkʉlʉmba jʉla iisyʉ lya Ntwa, pamopeene na bandʉ boosa aba baalimo nnyumba jaake. ");
INSERT INTO nyy_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Akabalɨlo kalakala akaa pakɨlo, alɨnkʉbasuka ɨfifulalo baa Paʉli na Sila, po alɨnkoosigwa pamopeene na bandʉ boosa aba baalimo nnyumba jaake. ");
INSERT INTO nyy_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Alɨnkʉfyʉka nabo mu nyumba jaake, alɨnkʉbapapo ɨfindʉ. Ʉmwene na bandʉ boosa abaa nnyumba jaake balɨnkʉhoboka fiijo, paapo baalɨmmwitiike Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kɨlaabo kyake abalongosi, balɨnkʉbatʉma ababombeli kʉ nkʉlʉmba gwa nnyololo, balɨnkʉjoba balɨnkʉtɨ, “Namubalekesye abandʉ bala babʉʉkege.” ");
INSERT INTO nyy_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ʉnkʉlʉmba gwa nnyololo alɨnkʉmmbʉʉla Paʉli alɨnkʉtɨ, “Abalongosi batʉmile ɨndʉmi, ʉkʉtɨ mwabʉligwe mu nnyololo. Po ʉlʉ namusooke, mubʉʉkege nʉ lʉtengaano.” ");
INSERT INTO nyy_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Looli Paʉli alɨnkʉbabʉʉla ababombeli bala alɨnkʉtɨ, “Batʉkomile nkyeni mmbandʉ, nʉ kʉtʉpinya mu nnyololo kɨsita kʉtʉlonga, na paapo ʉswe tʉlɨ Balooma kʉ lʉlagɨlo lwa kiisʉ. Lɨɨlɨno fiki bikʉlonda ʉkʉtʉlekesya kʉbʉtiitʉ? Hɨmma! Biise baabo batʉsoosye.” ");
INSERT INTO nyy_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ababombeli bala balɨnkʉbabʉʉla abalongosi ɨnongwa ɨsyo. Abalongosi bo bapɨliike ʉkʉtɨ baa Paʉli na Sila Balooma, balɨnkʉtiila. ");
INSERT INTO nyy_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Po balɨnkwisa kʉkʉbasʉʉma ʉlʉhobokelo. Balɨnkʉbasoosya mu nnyololo, balɨnkʉbasʉʉma ʉkʉtɨ basookemo nkaaja kala. ");
INSERT INTO nyy_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paʉli na Sila bo basookile mu nnyololo, balɨnkʉbʉʉka kwa Litija. Ʉko balɨnkwaganila na baamyabo abiitɨki, balɨnkʉbakasya, po balɨnkʉsookapo. ");
INSERT INTO nyy_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paʉli na Sila bo basookilemo mu Filipi, balɨnkʉkɨɨsania nkaaja akaa mu Amfipoli na mu Apolonija, balɨnkʉfika mu Tesaloniki. Kʉno kwalɨ nɨ sinagogi jaa Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paʉli alɨnkwingɨla mu sinagogi, bo muumo lwajɨɨliile ʉlwiho lwake. Alɨnkʉmanyisya amasyʉ ʉkʉfuma mwa Kalata ʉMwikemo, kʉkabalɨlo akaa Sabati itatʉ. ");
INSERT INTO nyy_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Aabalɨngaaniaga nʉ kʉbanangɨsya ʉkʉtɨ, Kɨlɨsiti mpaka akʉbɨlwe nʉ kʉsyʉka ʉkʉfuma mbafwe. Aafumusyaga ɨnongwa sya Jesu, ʉkʉtɨ jo Meesija. ");
INSERT INTO nyy_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ABajuuta bamo balɨnkwitɨka, balɨnkʉja pamopeene na Paʉli na Sila. Boope aba bakaja Bajuuta abingi aba baalingiile ndwitɨko lwa Bajuuta na bakiikʉlʉ abingi abɨɨmɨkigwa balɨnkwitɨka, balɨnkʉja pamopeene na Paʉli na Sila. ");
INSERT INTO nyy_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Looli aBajuuta aba bakaalɨ biitɨki ʉbʉʉfi bʉlɨnkʉbakola, balɨnkʉbeega abandʉ bamo abaa kajɨɨlo akabiibi. Abo balɨnkʉbabʉngaania abandʉ abingi, balɨnkʉleefya nkaaja. Balɨnkʉbʉʉka kʉ nyumba jaa Jaasoni, balɨnkwingɨla kʉ maka, baabalondaga baa Paʉli na Sila, ʉkʉtɨ babatwale pa kɨlʉndɨlo kya bandʉ. ");
INSERT INTO nyy_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bo bakabaaga, balɨnkʉnnduusa Jaasoni na biitɨki biinɨɨtʉ bamo, balɨnkʉbʉʉka nabo kʉ balongosi baa kaaja, balɨnkʉlaata balɨnkʉtɨ, “Koope kʉno biisile, abandʉ aba bafisambʉleenie ɨfiisʉ fyosa. ");
INSERT INTO nyy_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jaasoni abambɨliile kʉmyake. Ʉmwene na bandʉ abo bikʉkilania ɨndagɨlo sya malafyale gwa Balooma, bikʉtɨ baatɨ alipo ʉmalafyale ʉjʉngɨ, ɨngamu jaake jo Jesu.” ");
INSERT INTO nyy_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ɨkɨlʉndɨlo kya bandʉ na balongosi baa kaaja bo basipɨliike ɨsyo, syabataamiisye. ");
INSERT INTO nyy_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jaasoni na biitɨki biinɨɨtʉ balɨnkʉsoosya ɨndalama ɨsya kwabʉligwa kʉ balongosi, balɨnkʉbalekesya. ");
INSERT INTO nyy_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ɨkɨlo kɨlakɨla abiitɨki abaa nkaaja kala, balɨnkʉbatʉma baa Paʉli na Sila kʉ Beloja. Bo bafikile kʉla, balɨnkʉbʉʉka mu sinagogi jaa Bajuuta. ");
INSERT INTO nyy_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Abandʉ baa mu Beloja baapɨlɨkɨsyaga ʉkʉbakɨnda abandʉ baa mu Tesaloniki, baalyambɨliile iisyʉ lya Kyala nɨ ndumbula joosa. Beeneesyaga Kalata ʉMwikemo kʉkʉtɨ isikʉ, ʉkʉtɨ basimanye ɨsi baamanyisyaga Paʉli na Sila lɨnga sya nalooli. ");
INSERT INTO nyy_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ABajuuta bingi balɨnkwitɨka, pamopeene na bakiikʉlʉ abɨɨmɨkigwa aba bakaja Bajuuta, na banyambala boope. ");
INSERT INTO nyy_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Looli aBajuuta abaa mu Tesaloniki, bo bapɨliike ʉkʉtɨ Paʉli ikʉlʉmbɨlɨla iisyʉ lya Kyala mu Beloja, balɨnkʉbʉʉka koope, balɨnkʉtwala ʉnjwego nʉ kʉfisofania ɨfilʉndɨlo fya bandʉ. ");
INSERT INTO nyy_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nakalɨnga abiitɨki abaa kʉla, balɨnkʉnsindɨkɨla Paʉli ʉkʉbʉʉka kʉ nyanja, looli Sila na Timoti balɨnkʉsyala kʉ Beloja. ");
INSERT INTO nyy_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Aba bansindɨkɨlaga Paʉli balɨnkwenda nagwe mpaka mu Ateni. Bo bikʉgomoka baalɨ nɨ ndʉmi ɨjaa kʉfuma kwa Paʉli, ʉkʉbabʉʉla baa Sila na Timoti ʉkʉtɨ bankonge mbɨbɨmbɨbɨ. ");
INSERT INTO nyy_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paʉli bo ikʉbaguulɨla baa Timoti na Sila mu Ateni, ɨndumbula jaake jaasulumeenie fiijo paapo aalyagile akaaja kala kiiswile ɨfifwani ɨfya gyabaakyala. ");
INSERT INTO nyy_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Po aamanyisyaga aBajuuta mu sinagogi, pamopeene na bandʉ abangɨ aba baalingiile ndwitɨko lwa Bajuuta. Na poope pa kɨbanja ɨkya lʉkomaano, aamanyisyaga kʉkʉtɨ isikʉ abandʉ aba aaganilaga nabo. ");
INSERT INTO nyy_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Pa kɨbanja apo, baalipo abamanyi bamo aba baabatɨgɨ, aBaepikuli na Basitoiki. Abo baajobesaniaga na Paʉli, bamo balɨnkʉtɨ, “Ʉgwa ndomo ʉjʉ ikʉlonda ʉkʉjoba ɨsya fiki?” Abangɨ balɨnkʉtɨ, “Sikʉnangɨsya ʉkʉtɨ ndʉmbɨlɨli gwa gyabaakyala ɨmiheesya.” Baajobile ɨsi paapo Paʉli aalʉmbɨlɨlaga ɨNdʉmi ɨNunu ɨjaa Jesu, nɨ sya kʉsyʉka. ");
INSERT INTO nyy_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Po abamanyi abo balɨnkʉntwala Paʉli ndʉkomaano lwa bamanyi ʉlʉ baatɨgɨ Alyopagi, balɨnkʉtɨ, “Tukʉkʉsʉʉma ʉtʉlɨngaanie ʉlʉmanyisyo ʉlʉpya ʉlʉ kʉfumusya. ");
INSERT INTO nyy_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ʉgwe ʉtwele ɨnongwa ɨmbya, tukʉlonda tʉsimanye ɨsyo silɨ bʉleebʉle.” ");
INSERT INTO nyy_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Abandʉ boosa abaa mu Ateni na baheesya aba baatʉʉgalaga nkaaja ako, baabombelaga akabalɨlo kaabo koosa ʉkʉpanga pamo ʉkʉpɨlɨkɨsya ɨnongwa ɨmbya. ");
INSERT INTO nyy_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Po Paʉli alɨnkwɨma ndʉkomaano lwa Alyopagi, alɨnkʉtɨ, “Mwe bandʉ baa mu Ateni! Ngwaga ʉkʉtɨ mukʉsyɨmɨka fiijo syosa ɨsya gyabaakyala gyɨnu. ");
INSERT INTO nyy_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Bo ngwenda kʉno na kʉno nkaaja, mfibwene ɨfifwani ɨfi mukʉfiipuuta. Kangɨ nkɨbwene ɨkɨgemo ɨkɨ kɨsimbiigwe ʉkʉtɨ, ‘kwa Kyala ʉjʉ akamanyigwa.’ Po Kyala ʉjo, ʉjʉ mukʉmmwipuuta kɨsita kʉmmanya, jo ʉjʉ ngʉmfumusya kʉmyɨnu. ");
INSERT INTO nyy_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Kyala ʉjo jo Ntwa gwa kʉmwanya na paasi, paapo jo ʉjʉ aapelile ɨkiisʉ na fyosa ɨfi filimo ʉmo. Ʉmwene atikʉtʉʉgala mu tempeli ɨsi basijengile abandʉ. ");
INSERT INTO nyy_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kangɨ atikʉbombeligwa na bandʉ ngatɨ ikʉlonda fimo, paapo ʉmwene jo ʉjʉ ikʉbapa abandʉ boosa ʉbʉʉmi, ʉmʉʉji nʉ tʉndʉ toosa. ");
INSERT INTO nyy_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Aalɨmpelile ʉmundʉ jʉmo, ʉkʉfuma mmundʉ ʉjo aapelile ɨfikolo fyosa ɨfya bandʉ, ʉkʉtɨ batʉʉgalege mfiisʉ fyosa. Aababɨɨkiile ʉkʉtɨ bikʉtʉʉgalaga pooki, na kʉkabalɨlo kalɨkʉ. ");
INSERT INTO nyy_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kyala aabombile bo ʉlo, ʉkʉtɨ abandʉ banndondege, pamo babagiile ʉkʉmfikɨla bo bikʉpalamaasya palamaasya, na paapo akaja kʉbʉtali nʉ mundʉ gwesa. ");
INSERT INTO nyy_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ngʉjoba bo ʉlo, ‘Paapo mmyake tʉlɨ bʉʉmi, tukwenda, kangɨ tʉliko.’ Bo abɨmba nyɨmbo bɨɨnu bamo baatile, ‘Ʉswe tʉlɨ baanaake Kyala.’ ” ");
INSERT INTO nyy_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Paʉli alɨnkwendelela ʉkʉjoba, alɨnkʉtɨ, “Paapo tʉlɨ baana baa Kyala, tʉlɨngiinogonaga ʉkʉtɨ afwene nɨ fifwani ɨfya sahabʉ pamo ɨfeesa, pamo iibwe. Fitendekesiigwe kʉ bʉmangʼanyi na mahala gaa bandʉ. ");
INSERT INTO nyy_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Akabalɨlo kaa kʉnyuma, aka abandʉ baabombaga ɨsyo kʉ bʉkonyofu, Kyala aaliibɨɨkile ngatɨ atikʉkeeta. Looli akabalɨlo aka ikʉbalagɨla abandʉ boosa kʉkʉtɨ bʉjo, ʉkʉpɨndʉka. ");
INSERT INTO nyy_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bikʉlondigwa ʉkʉpɨndʉka paapo alɨbɨɨkile ɨliisikʉ ɨlɨ ikwisa kʉbalonga abandʉ boosa mbʉgolofu, kʉ njɨla jaa mundʉ ʉjʉ aalɨnsalile. Kyala aabanangiisye ɨsi abandʉ boosa, kʉ njɨla jaa kʉnsyʉsya ʉmundʉ ʉjo mbʉfwe.” ");
INSERT INTO nyy_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Abandʉ bala bo bapɨliike ɨsya kʉsyʉka abafwe, bamo bʉʉgɨɨlaga, looli bamo balɨnkʉtɨ, “Tukʉlonda ʉkʉpɨlɨkɨsya kangɨ sisiisi pabʉngɨ.” ");
INSERT INTO nyy_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Po Paʉli alɨnkʉsookapo pa lʉkomaano. ");
INSERT INTO nyy_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Bamo balɨnkʉlongosania nagwe, balɨnkʉmmwitɨka Jesu. Ndɨ abo aalimo Ndyonisi, ʉgwa ndʉkomaano lwa Alyopagi, nʉ nkiikʉlʉ jʉmo ɨngamu jaake Ndamali, na bandʉ abangɨ aba baalɨ pamopeene nabo. ");
INSERT INTO nyy_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bo sikɨndile ɨsyo, Paʉli alɨnkʉsookamo mu Ateni, alɨnkʉbʉʉka mu Kolinti. ");
INSERT INTO nyy_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Mula alɨnkwaganila nʉ Njuuta jʉmo ɨngamu jaake Akwila, ʉjʉ aapaapiigwe mu Ponti. Akwila nʉ nkasi Pilisika, baafumile pakʉfika ʉkʉfuma nkiisʉ ɨkya Italija, paapo Kɨlaʉtio ʉmalafyale gwa Balooma aalagiile ʉkʉtɨ aBajuuta boosa basookemo mu Looma. Paʉli alɨnkʉbʉʉka kʉkʉbakeeta. ");
INSERT INTO nyy_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Abeene baabombaga ɨmbombo jaa kʉsona ɨheema, ɨmbombo ɨjɨ joope Paʉli aabombaga. Po alɨnkwanda ʉkʉtʉʉgala nabo, balɨnkʉbomba ɨmbombo ɨjo pamopeene. ");
INSERT INTO nyy_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kʉkʉtɨ isikʉ ɨlya pa Sabati Paʉli ingɨlaga mu sinagogi, aamanyisyaga aBajuuta na aba bakaja Bajuuta, ʉkʉbakwaba ʉkʉtɨ baje biitɨki. ");
INSERT INTO nyy_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timoti bo bafikile ʉkʉfuma mu Maketonija, Paʉli alɨnkwanda ʉkʉbombela akabalɨlo kaake koosa ʉkʉlʉmbɨlɨla nʉ kʉbasisimɨkɨsya aBajuuta ʉkʉtɨ Jesu jo Meesija. ");
INSERT INTO nyy_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Looli balɨnkʉmpɨnga nʉ kʉntʉka. Po Paʉli alɨnkʉkungʼunda ɨmyenda gyake nkyeni mmyabo, alɨnkʉbabʉʉla alɨnkʉtɨ, “Lɨnga Kyala ikʉbapyuta, lwɨnu jʉjʉʉmwe! Ʉne ngaja na nongwa najɨmo. Ʉkwandɨla ʉlʉ ngʉbʉʉkaga kʉkʉbalʉmbɨlɨla abandʉ aba bakaja Bajuuta.” ");
INSERT INTO nyy_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Po Paʉli alɨnkʉsookapo pa sinagogi, alɨnkʉbʉʉka kʉ mundʉ jʉmo ɨngamu jaake Tiiti Jusiti, ʉjʉ aalingiile ndwitɨko lwa Bajuuta, ɨnyumba jaake jaapalameene nɨ sinagogi. ");
INSERT INTO nyy_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ʉnkʉlʉmba gwa sinagogi jɨla, ɨngamu jaake Kilisipo, alɨnkʉmmwitɨka ʉNtwa Jesu, pamopeene na bandʉ boosa abaa nnyumba jaake. Boope aBakolinti bingi aba baalɨmpɨlɨkiisye Paʉli, balɨnkʉmmwitɨka ʉNtwa Jesu nʉ koosigwa. ");
INSERT INTO nyy_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Iisikʉ lɨmo pakɨlo, ʉNtwa alɨnkʉmmbʉʉla Paʉli nkɨsetʉka alɨnkʉtɨ, “Ʉlɨngatiilaga, looli endelelaga ʉkʉjoba, ʉngamyekaga, ");
INSERT INTO nyy_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","paapo ʉne ndɨ pamopeene na nungwe. Akajako ʉmundʉ najʉmo ʉgwa kʉkwisɨla kʉkʉkʉfulasya. Nkaaja aka balimo abandʉ bingi abaa kʉja biitɨki bangʉ.” ");
INSERT INTO nyy_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Po Paʉli alɨnkʉtʉʉgala mu Kolinti ɨkyɨnja kɨmo nɨ myesi ntandatʉ, ʉkʉtɨ abamanyisye abandʉ iisyʉ lya Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Looli nkabalɨlo ako alɨnkʉfika ʉnkʉlʉmba ʉmpya ʉgwa nkiisʉ ɨkya Akaja, ɨngamu jaake Galio. ABajuuta balɨnkʉmmotokela Paʉli, balɨnkʉntwala nkyeni mu nkʉlʉmba, pabʉlongi, ");
INSERT INTO nyy_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","balɨnkʉtɨ, “Ʉmundʉ ʉjʉ ikʉbasonga abandʉ, ʉkʉtɨ biipuutege kwa Kyala ʉkʉkɨndana nɨ ndagɨlo.” ");
INSERT INTO nyy_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Na paapo Paʉli aalondaga ʉkʉjoba, Galio aakaanile, alɨnkʉbabʉʉla aBajuuta alɨnkʉtɨ, “Lɨnga mwansitaakaga ʉmundʉ ʉjʉ kʉnongwa simo ɨmbiibi pamo kʉnongwa jaa bʉkomu, mwe Bajuuta naabagiile ʉkʉbapɨlɨkɨsya. ");
INSERT INTO nyy_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Looli paapo nongwa jaa masyʉ, ɨngamu nɨ ndagɨlo syɨnu, amusikeete jʉjʉʉmwe mutumule. Ʉne ngʉkaana ʉkʉja ndongi gwa nongwa ɨsyo!” ");
INSERT INTO nyy_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Po alɨnkʉbakaga pabʉlongi. ");
INSERT INTO nyy_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Po boosa balɨnkʉnkola ʉnkʉlʉmba gwa sinagogi, ɨngamu jaake Sositeni, balɨnkʉnkoma palapala nkyeni mu ndongi. Looli Galio akaapaasiisyepo na panandɨ ɨsi syabombigwaga nkyeni mmyake. ");
INSERT INTO nyy_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paʉli alɨnkwendelela ʉkʉtʉʉgala mu Kolinti amasikʉ mingi. Po alɨnkʉlagana na biitɨki bala, alɨnkʉbʉʉka pamopeene na Pilisika na Akwila kʉ Kenkeleja, kʉmbalɨ kʉ nyanja. Bo bafikile ʉko, Paʉli alɨnkʉmwa ɨnywili syake, paapo syalɨ sya lʉjɨɨganiko, alɨnkwipakɨla mu sitima ʉkʉbʉʉka nkiisʉ ɨkya mu Silija. ");
INSERT INTO nyy_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Balɨnkʉfika mu Efesi, apa aabalekile baa Pilisika na Akwila. Kʉla Paʉli alɨnkwingɨla mu sinagogi, alɨnkʉbamanyisya aBajuuta. ");
INSERT INTO nyy_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Po balɨnkʉnsʉʉma Paʉli ʉkʉtɨ atʉʉgale nabo akabalɨlo akatalipo, leelo aakaanile. ");
INSERT INTO nyy_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Looli bo ikʉlagana nabo alɨnkʉtɨ, “Lɨnga Kyala iiganile, ngwakwisa kangɨ kʉmyɨnu.” Po alɨnkʉsookamo mu Efesi nɨ sitima. ");
INSERT INTO nyy_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Po Paʉli alɨnkʉfika mu Kesalija, alɨnkwika mu sitima, alɨnkʉbʉʉka mu Jelusalemu nkʉkɨponia ɨkɨpanga kya Kyala. Po alɨnkʉbʉʉka mu Antyokija. ");
INSERT INTO nyy_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Bo atʉʉgeele ʉmo akabalɨlo akanandɨ, alɨnkʉsookamo. Alɨnkʉsyʉngʉʉtɨla ntwaja ʉtwingi ʉtwa mu Galatija na mu Filigija, aabakasyaga abiitɨki boosa. ");
INSERT INTO nyy_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Akabalɨlo ako ʉNjuuta jʉmo ɨngamu jaake Apolo alɨnkwisa mu Efesi, ʉmwenekaaja gwa mu Alikisandalija, aalɨ mundʉ mmanyi ʉkʉjoba, kangɨ aasimeenye ɨsya mwa Kalata ʉMwikemo. ");
INSERT INTO nyy_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ʉmundʉ ʉjo aamanyisiigwe ɨNjɨla jaa Ntwa, aamanyisyaga kanunu ɨnongwa ɨsya Jesu muno sijɨɨliile, kangɨ kʉ maka, na paapo aalʉmeenye lwene ʉloosyo ʉlwa Johani. ");
INSERT INTO nyy_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Alɨnkwanda ʉkʉjoba ɨsyo kɨsita kʉtiila mu sinagogi. Pilisika na Akwila bo bampɨlɨkiisye, balɨnkʉmmwega balɨnkʉbʉʉka nagwe kʉkaaja kaabo, balɨnkʉmmanyisya ɨNjɨla jaa Kyala kanunu. ");
INSERT INTO nyy_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Pabʉngɨ Apolo alɨnkʉlonda ʉkʉloboka mu nyanja ʉkʉbʉʉka mu Akaja. Abiitɨki banine abaa mu Efesi balɨnkʉnkasya, balɨnkʉmpapo kalata ʉgwa kʉbatwalɨla abiitɨki abaa mu Akaja, ʉkʉtɨ bakammwambɨlɨle. Bo afikile kʉla, aabatʉʉlile fiijo abandʉ aba baalɨmmwitiike Jesu kwi ipyana lya Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Alɨnkʉbatobesya aBajuuta nkyeni mmbandʉ boosa, aabanangɨsyaga mwa Kalata ʉMwikemo, ʉkʉtɨ Jesu jo Meesija. ");
INSERT INTO nyy_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ʉko nkiisʉ ɨkya mu Akaja, Apolo aatʉʉgalaga mu Kolinti. Akabalɨlo kalakala, Paʉli alɨnkwenda paasi ʉkʉbʉʉka kʉ Efesi. Ʉko kʉ Efesi alɨnkʉbaaga abiitɨki bamo abaa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Bo mummwitiike Jesu, bʉle mwalɨmmwambɨliile Mbepo Mwikemo?” Balɨnkʉmmwamula balɨnkʉtɨ, “Hɨmma, tʉkapɨlɨkamo sikʉ nʉ kʉtɨ aliko Mbepo Mwikemo.” ");
INSERT INTO nyy_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Alɨnkʉbalaalʉʉsya kangɨ alɨnkʉtɨ, “Po mwalyosiigwe ʉloosyo lʉlɨkʉ?” Balɨnkʉmmwamula balɨnkʉtɨ, “Ʉloosyo lwa Johani.” ");
INSERT INTO nyy_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paʉli alɨnkʉbabʉʉla alɨnkʉtɨ, “Johani aaboosyaga abandʉ ʉkʉnangɨsya ʉkʉtɨ bapɨndwike. Aababʉʉlaga ʉkʉtɨ bammwitɨkege ʉjʉ ikʉja pakwisa kʉnyuma kʉmyake, jo Jesu.” ");
INSERT INTO nyy_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bo bapɨliike amasyʉ aga, balɨnkoosigwa mu ngamu jaa Ntwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Po Paʉli alɨnkʉbɨɨka amaboko gaake pamwanya pamyabo, Mbepo Mwikemo alɨnkʉbasulukɨla, balɨnkwanda ʉkʉjoba mu njobelo ɨsingi, nʉ kʉkunguluka. ");
INSERT INTO nyy_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Baalɨ banyambala kalongo na babɨlɨ bʉno. ");
INSERT INTO nyy_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paʉli ingɨlaga mu sinagogi, aajobaga kɨsita kʉtiila, kʉkabalɨlo akaa myesi mitatʉ, aamanyisyaga abandʉ ʉkʉtɨ basiitɨke ɨnongwa sya Bʉnyafyale bwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Looli bamo baalɨ bakafu, baakaanile ʉkwitɨka, balɨnkʉjɨtʉka ɨNjɨla ɨjaa Ntwa Jesu pa kɨlʉndɨlo kya bandʉ. Paʉli alɨnkʉbaleka, alɨnkʉbeega abiitɨki baa Jesu ʉkwenda nagwe. Aamanyisyaga kʉkʉtɨ isikʉ pabʉjo ʉbwa mundʉ jʉmo, ɨngamu jaake Tilano. ");
INSERT INTO nyy_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Paʉli alɨnkwendelela ʉkʉbomba bʉnoobʉno ɨfyɨnja fibɨlɨ, po boosa aba baatʉʉgalaga nkiisʉ ɨkya mu Asija, aBajuuta na aba bakaja Bajuuta, balɨnkʉpɨlɨkɨsya iisyʉ lya Ntwa Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Akabalɨlo ako Kyala aabombaga ɨfiika ɨfikʉlʉmba kʉ njɨla jaa Paʉli. ");
INSERT INTO nyy_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Fyope ɨfitambala nɨ myenda ɨgɨ gɨpalamaasiisye ʉmbɨlɨ gwa Paʉli, baabatwalɨlaga ababine. Ababine baabʉmbʉlʉkaga ʉbʉbine bwabo, nɨ mbepo ɨnyali syasookangamo. ");
INSERT INTO nyy_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Baaliko aBajuuta bamo aba baagelaga ʉkʉsoosya ɨmbepo ɨnyali mmbandʉ nkaaja ako, kʉkʉbombela ɨngamu jaa Jesu, baatɨgɨ, “Mu ngamu jaa Jesu ʉjʉ ikʉlʉmbɨlɨligwa na Paʉli, nikʉkʉlagɨla sookamo!” ");
INSERT INTO nyy_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ndɨ abo baalipo abaana abanyambala bahaano na babɨlɨ, abaa mpuuti ʉndongosi gwa Bajuuta, ɨngamu jaake Sikeba. ");
INSERT INTO nyy_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Looli ɨliisikʉ lɨmo bo bikʉjɨkaga ɨmbepo ɨnyali mmundʉ jʉmo, ɨmbepo ɨnyali jɨla jɨlɨnkʉbaamula jɨlɨnkʉtɨ, “Jesu nʉmmeenye, joope Paʉli nʉmmwageenie, leelo ʉmwe mwe baani?” ");
INSERT INTO nyy_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Po ʉmundʉ ʉjʉ aalɨ nɨ mbepo ɨnyali, alɨnkʉbanyeelela, alɨnkʉbafulasya, alɨnkʉbatola amaka, balɨnkʉbopa kɨtali ʉkʉsooka nnyumba jɨla. ");
INSERT INTO nyy_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Abandʉ boosa aba baatʉʉgalaga mu Efesi, aBajuuta boosa na aba bakaja Bajuuta, baasipɨliike ɨnongwa ɨsi baabombeliigwe abaana baa Sikeba. Boosa balɨnkʉja nʉ lʉtende, ɨngamu jaa Ntwa Jesu jɨlɨnkwɨmɨkigwa fiijo. ");
INSERT INTO nyy_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Abandʉ bingi aba baalɨmmwitiike Jesu balɨnkwisa, balɨnkwilaata pabwelu ɨmbiibi ɨsi babombile. ");
INSERT INTO nyy_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bamo ndɨ abo balɨnkʉbʉngaania baakalata abaa kʉbombela ʉbʉlosi, balɨnkʉkosya nkyeni mmbandʉ boosa. Baabalile ʉntengo gwa baakalata bala, syalɨ ndalama nyingi fiijo, syafwene ʉmfwalo gwa isikʉ lɨmo ʉgwa bandʉ 50,000. ");
INSERT INTO nyy_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kʉ njɨla ɨjo ɨliisyʉ lya Ntwa lyakɨndɨlɨlaga ʉkʉfumuka nʉ kongelela ʉkʉja na maka. ");
INSERT INTO nyy_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bo sikɨndile ɨsyo, Paʉli alɨnkʉtumula ʉkʉbʉʉka mu Jelusalemu, ʉkwendela mu Maketonija na mu Akaja, alɨnkwinogona alɨnkʉtɨ, “Bo ngonilemo mu Jelusalemu, mpaka mbʉʉke koope kʉ Looma.” ");
INSERT INTO nyy_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Po alɨnkʉbatʉma abatʉʉli baake babɨlɨ, Timoti na Elasiti, ʉkʉtɨ batalepo ʉkʉbʉʉka kʉ Maketonija. Ʉmwene alɨnkʉsyala akabalɨlo akanandɨ nkiisʉ ɨkya mu Asija. ");
INSERT INTO nyy_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Akabalɨlo ako mu Efesi, gʉlɨnkʉsookela ʉnjwego ʉnnywamu fiijo kʉnongwa jaa manyisyo ɨsya Njɨla jaa Ntwa. ");
INSERT INTO nyy_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Aaliko ʉmundʉ jʉmo ɨngamu jaake Ndemetilio, ʉmponda fifwani fya feesa. Aapondaga ɨfifwani fya tempeli ɨjaa lyakyala ikiikʉlʉ, ɨngamu jaake Alitemi. Kʉ mbombo ɨjo Ndemetilio na bafundi baake baakabɨlangamo ʉbʉkabi ʉbwingi. ");
INSERT INTO nyy_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ndemetilio aababʉngeenie ababombi baake na bandʉ abangɨ aba baabombaga ɨmbombo bo ɨjo, alɨnkʉbabʉʉla alɨnkʉtɨ, “Mwe bandʉ ʉmwe, mumeenye ʉkʉtɨ ɨmbombo ɨjɨ jikʉtʉtwalɨla ʉbʉkabi ʉbwingi. ");
INSERT INTO nyy_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Looli musibwene nʉ kʉsipɨlɨka ʉkʉtɨ, Paʉli ʉjo abasongile abandʉ abingi nʉ kʉbasyutula ɨnyiinogono syabo. Biitiike ʉkʉtɨ gyabaakyala ɨgɨ gikʉtendekesigwa na bandʉ gɨkaja gyo gyabaakyala. Ikʉbomba bo ʉlo momma mwene mu Efesi, looli mbʉjo bwingi ʉbwa nkiisʉ ɨkya mu Asija. ");
INSERT INTO nyy_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ngʉtiila ɨmbombo jɨɨtʉ ɨjɨ, abandʉ batikʉjɨɨmɨkaga, joope nɨ tempeli ɨjaa lyakyala ikiikʉlʉ ikʉlʉmba Alitemi, batikʉjɨɨmɨkaga. Kangɨ ʉbʉsisya bwa lyakyala ɨlyo, ɨlɨ abandʉ boosa abaa mu Asija nɨ fiisʉ fyosa bikwipuuta kʉmyake, bukʉmalɨka.” ");
INSERT INTO nyy_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Abafundi abanine bo bapɨliike ɨnongwa ɨsyo, baakaleele fiijo, balɨnkwanda ʉkʉjwega balɨnkʉtɨ, “Alitemi ʉgwa Baefesi jo nkʉlʉmba!” ");
INSERT INTO nyy_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Akaaja koosa kalɨnkwisʉla ʉnjwego. Abandʉ balɨnkwalʉka pamopeene, balɨnkʉkʉʉja ʉkwakʉbakwaba baa Gajo na Alisitaliko, ʉkʉbʉʉka pa kɨbanja ɨkya lʉkomaano. Abandʉ abo baalɨ baa nkiisʉ ɨkya mu Maketonija, aba baalyendile pamopeene na Paʉli. ");
INSERT INTO nyy_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paʉli alɨnkʉlonda ʉkwingɨla pakatɨ pa kɨlʉndɨlo kya bandʉ, leelo abiitɨki abanine balɨnkʉnngomola. ");
INSERT INTO nyy_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Baalipo abalongosi bamo abaa nkaaja kala, aba baalɨ bamanyaani baa Paʉli. Baabatʉmile abandʉ kwa Paʉli ʉkʉmmbʉʉla ʉkʉtɨ, alɨngasulwa ʉkʉbʉʉka pa kɨbanja ɨkya lʉkomaano. ");
INSERT INTO nyy_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Abandʉ aba baabʉngeene pala, bamo balɨnkʉjwega, kʉkʉtɨ mundʉ alɨnkʉjoba ɨsyake. Ʉlʉkomaano lwalyonangiike. Abandʉ bingi bakaasimeenye na ɨsi baakomaaniile pala. ");
INSERT INTO nyy_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ABajuuta balɨnkʉnnguta ʉmundʉ gwabo jʉmo, ɨngamu jaake Alikisanda, na bandʉ bamo abaa nkɨlʉndɨlo kɨla balɨnkʉmmwɨmɨka ʉkʉtɨ ajobe. Joope Alikisanda alɨnkwinʉla ɨkɨboko kyake, ʉkʉtɨ abajobele ɨsya kʉbanokesya pabwelu. ");
INSERT INTO nyy_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Looli abandʉ aba baabʉngeene pala bo basyageenie ʉkʉtɨ Njuuta, boosa balɨnkʉlaata palɨkɨmo kʉkabalɨlo akaa sala ibɨlɨ, baatɨgɨ, “Alitemi ʉgwa Baefesi jo nkʉlʉmba!” ");
INSERT INTO nyy_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kʉmmalɨɨkɨsyo ʉnsimbi gwa kaaja kala alɨnkʉbabatamisya abandʉ, alɨnkʉjoba alɨnkʉtɨ, “Mwe bandʉ baa mu Efesi, jwani ʉjʉ akamanya ʉkʉtɨ akaaja akaa mu Efesi, ko aka kikʉjɨlɨndɨlɨla ɨtempeli ɨjaa Alitemi ʉnkʉlʉmba, nɨ kɨfwani kyake ɨkɨ kyasatwike ʉkʉfuma kʉmwanya? ");
INSERT INTO nyy_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Akajako ʉmundʉ ʉjʉ abagiile ʉkʉbʉkaana ʉbwanalooli ʉbʉ. Po mumyeke, kangɨ mulɨngakʉʉjaga ʉkʉbomba simo, ");
INSERT INTO nyy_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","paapo mubatwele abandʉ aba apa, na paapo bakalɨtʉkamo sikʉ lyakyala lyɨtʉ ikiikʉlʉ Alitemi, kangɨ bakiiba nafimo mu tempeli jaake. ");
INSERT INTO nyy_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Po lɨnga Ndemetilio na bafundi banine, balɨ nɨ nongwa simo kʉ bandʉ bamo, pabʉlongi na balongi abakʉlʉmba balipo. Babagiile ʉkʉbasitaaka ʉko. ");
INSERT INTO nyy_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Lɨnga mulɨ nasyo ɨnongwa ɨsingi, mutwale kʉ lʉkomaano ʉlʉ lwitɨkɨsiigwe nɨ ndagɨlo syɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ngʉjoba bo ʉlo paapo ʉlʉ tʉbagiile ʉkʉlongigwa kʉnongwa jaa njwego ʉgwa mwisyʉgʉ, namanga tʉkaja nasyo nasimo ɨsya kwinokesya kʉnongwa jaa njwego ʉgʉ.” ");
INSERT INTO nyy_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Bo amalile ʉkʉjoba ɨsi, alɨnkʉlʉbalania ʉlʉkomaano. ");
INSERT INTO nyy_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ʉnjwego gʉla bo gʉmaliike, Paʉli alɨnkʉbakoolela pamopeene abiitɨki, alɨnkʉbakasya. Po alɨnkʉbalaga, alɨnkʉsookapo ʉkʉbʉʉka mu Maketonija. ");
INSERT INTO nyy_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Bo ikwenda mfiisʉ fila, aajobaga na biitɨki boosa nʉ kʉbakasya. Po alɨnkʉfika mBʉgiliki, ");
INSERT INTO nyy_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ʉko aatʉʉgeele akabalɨlo akaa myesi mitatʉ. Bo ikwitendekesya ʉkwipakɨla mu sitima ʉkʉbʉʉka mu Silija, alɨnkʉsyagania ʉkʉtɨ aBajuuta bikʉntegelela ʉkʉmmbombela kabiibi. Po alɨnkʉtumula ʉkwenda ɨnjɨla ɨjaa nkiisʉ ɨkya mu Maketonija. ");
INSERT INTO nyy_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","5","Abandʉ abaa baatʉsindɨkɨlaga baatalilepo ʉkʉbʉʉka, baatʉguuliile nkaaja akaa mu Tiloja. Ɨngamu syabo baalɨ bo baa Sopatelo ʉmwana gwa Pilo ʉgwa mu Beloja, Alisitaliko na Sekundo abaa mu Tesaloniki, Gajo na Timoti abaa mu Ndelibe, Tikiko na Tilofimo abaa nkiisʉ ɨkya mu Asija. ");
INSERT INTO nyy_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ɨkyaka kya Pasa bo kɨkɨndile, tʉlɨnkʉsookako kʉ Filipi nɨ sitima, tʉlɨnkwenda amasikʉ mahaano, tʉlɨnkʉbaaga abiinɨɨtʉ mu Tiloja. Ʉko twagonile amasikʉ mahaano na mabɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Pi isikʉ ɨlya pa ndʉngʉ, twalyaganiile pakwipuuta nʉ kʉmenya ɨkɨsyesye. Paʉli alɨnkʉbamanyisya abandʉ mpaka pakɨlo pakatɨ, paapo aalondaga ʉkʉsookapo kɨlaabo kyake. ");
INSERT INTO nyy_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ɨkyumba ɨkya kʉ golofwa ɨkɨ twabʉngeene, kyalɨ nɨ nyaale nyingi. ");
INSERT INTO nyy_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Aaliko ʉndʉmyana jʉmo, ɨngamu jaake Jutika, aatʉʉgeele pi itʉʉlo. Paʉli alɨnkwendelela ʉkʉlʉmbɨlɨla akabalɨlo akatali, mpaka ʉndʉmyana ʉjo alɨnkwanda ʉkʉsipʉka. Ʉtʉlo bo tʉkɨndɨliile fiijo, alɨnkʉtunyuka ʉkʉfuma kʉ golofwa ɨjaa bʉtatʉ. Abandʉ balɨnkʉmmwinʉla, looli aafwile. ");
INSERT INTO nyy_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paʉli alɨnkʉsuluka paasi, alɨnkwinama, alɨnkʉmmʉʉbatɨla ʉndʉmyana jʉla, alɨnkʉbabʉʉla abandʉ alɨnkʉtɨ, “Mulɨnganyomokaga, ʉbʉʉmi bwake bʉkaalɨ bʉlimo!” ");
INSERT INTO nyy_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Po Paʉli alɨnkʉfyʉka kangɨ kʉ golofwa kʉkwipuuta, alɨnkʉmenya ɨkɨsyesye, balɨnkʉlya. Alɨnkwendelela ʉkʉlʉmbɨlɨla mpaka kʉbʉkye, po alɨnkʉsookapo. ");
INSERT INTO nyy_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Abandʉ bala, balɨnkʉntwala kʉkaaja ʉndʉmyana jʉla ʉnkafu itolo, balɨnkʉhoboka fiijo. ");
INSERT INTO nyy_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paʉli aatumwile ʉkwenda paasi ʉkʉbʉʉka kʉ Aso. Aapangile ʉkʉtɨ tʉtalepo tʉkammwage kʉla. Po ʉswe tʉlɨnkwipakɨla mu sitima, tʉlɨnkʉfika kʉla. ");
INSERT INTO nyy_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Bo atwagile mu Aso, tʉlɨnkʉmpakɨla mu sitima, tʉlɨnkʉbʉʉka twesa mpaka mu Mitilene. ");
INSERT INTO nyy_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ʉkʉfuma ʉko iisikʉ lya bʉbɨlɨ tʉlɨnkʉningana nʉ lʉsʉngo lwa mu Kija. Kɨlaabo kyake tʉlɨnkʉfika ndʉsʉngo lwa mu Samu, kɨlaabo ɨkɨngɨ tʉlɨnkʉfika mu Mileti. ");
INSERT INTO nyy_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paʉli aatumwile ʉkʉkɨɨsania kɨsita kwendela mu Efesi, ʉkʉtɨ alɨngakaabɨla nkiisʉ ɨkya mu Asija. Aalondaga ʉkwandana mu Jelusalemu, lɨnga sibagiile bo kɨkaalɨ ɨkyaka kya Pentekositi. ");
INSERT INTO nyy_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ʉkʉfuma kʉ Mileti, Paʉli alɨnkʉtʉma ɨndʉmi kʉ bakʉʉlʉ baa kɨpanga kya Kyala ɨkya mu Efesi, ʉkʉtɨ baaganile nagwe. ");
INSERT INTO nyy_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bo bafikile kʉmyake, alɨnkʉbabʉʉla alɨnkʉtɨ, “Ʉmwe mumeenye muno naatʉʉgalaga na nuumwe amasikʉ goosa ʉkʉfuma iisikʉ lya kwanda ɨlɨ naafikile apa pa Asija. ");
INSERT INTO nyy_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Bo ngʉmmbombela ʉNtwa Jesu pakatɨ pamyɨnu, naalɨ nʉ lwijiisyo ndɨ syosa, kaa kingi naalɨlaga mu ndumbula kʉnongwa jɨɨnu. Kangɨ naalyendile mu ngʉbɨlo ɨnyingi, fiijo kʉ Bajuuta aba baalɨndegeliile. ");
INSERT INTO nyy_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mumeenye ʉkʉtɨ ngaasyonganiike ʉkʉbalʉmbɨlɨla ɨsi sibagiile ʉkʉbatʉʉla ʉmwe, kangɨ naamanyisyaga pabwelu na mu nyumba syɨnu. ");
INSERT INTO nyy_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Naabalʉmbɨlɨlaga aBajuuta na aba bakaja Bajuuta ʉkʉtɨ bapɨndʉke, basʉʉme ʉlʉhobokelo kwa Kyala, nʉ kʉmmwitɨka ʉNtwa gwɨtʉ Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Namupɨlɨkɨsye. Ʉne nsumwike kʉ Jelusalemu, Mbepo Mwikemo ikʉʉfimbɨlɨsya. Ngʉbʉʉka kɨsita kʉsimanya ɨsi sikwakʉʉnyaaga ʉko. ");
INSERT INTO nyy_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Looli ɨsi nsimeenye syo ɨsi, Mbepo Mwikemo ikʉʉsisimɨkɨsya, kʉkʉtɨ kaaja aka ngwendamo, ʉkʉtɨ ʉkʉpinyigwa mu nnyololo nɨ ngʉbɨlo fyo ɨfi fikʉʉnguulɨla. ");
INSERT INTO nyy_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Looli ndikʉbʉpaasya ʉbʉʉmi bwangʉ ʉkʉja kandʉ kaa ntengo, ʉkʉtɨ njɨmalɨɨsye ɨmbombo ɨjɨ ʉNtwa Jesu aalɨmbeele, fyobeene ngʉjɨlʉmbɨlɨla ɨNdʉmi ɨNunu ɨjaa ipyana lya Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Lɨɨlɨno mmeenye akajapo najʉmo pakatɨ pamyɨnu ʉjʉ ikwisa kʉʉmbona kangɨ, mwe nendaga pakatɨ pamyɨnu bo nikʉbalʉmbɨlɨla ɨsya Bʉnyafyale bwa Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kʉnongwa ɨjo, ngʉlonda mwesa mumanye ʉmwisyʉgʉ, ʉkʉtɨ lɨnga jʉmo ikʉsoba jɨkaja nongwa jangʉ, ");
INSERT INTO nyy_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","paapo ngaasyonganiikepo ʉkabafumukɨsya syosa ɨsi Kyala aasibaatiike. ");
INSERT INTO nyy_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mwikeetege bʉnunu, kangɨ mugʉkeetege goope nʉ ntiimo goosa ʉgʉ Mbepo Mwikemo aababɨɨkile ʉmwe ʉkʉja bɨɨmɨlɨli. Mukɨtiimege ɨkɨpanga kya Kyala ɨkɨ aalyʉlile ni ilopa lyake jʉʉjo. ");
INSERT INTO nyy_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mmeenye fiijo ʉkʉtɨ bo nsookilepo, ɨmbwa ɨngalɨ ɨsya ndiisʉ aasikwisa pakatɨ pamyɨnu, sitikʉgʉpaakɨsyaga ʉntiimo. ");
INSERT INTO nyy_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Na nuumwe pakatɨ pamyɨnu mwe biitɨki, aabikwinʉka abandʉ aba aabikʉjobaga ɨnongwa sya bʉtʉngʉlʉ, ɨsya kʉbasofya abiitɨki ʉkʉtɨ babakongege abeene. ");
INSERT INTO nyy_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kʉnongwa ɨjo, mujege maaso! Mukʉmbʉkege ʉkʉtɨ ɨfyɨnja fitatʉ pakɨlo na pamuusi, ngaalekile ʉkʉnsoka kʉkʉtɨ mundʉ, kaa kingi naalɨlaga mu ndumbula. ");
INSERT INTO nyy_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Po ʉlʉ nikʉbabɨɨka mbʉlɨndɨlɨli bwa Kyala nʉ bwa isyʉ ɨlya ipyana lyake, ɨlɨ lɨbagiile ʉkʉbapa amaka nɨ sajo syosa ɨsi aafingile ʉkʉbapa abandʉ baake abiikemo. ");
INSERT INTO nyy_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ʉne ngasʉʉmamo sikʉ ʉmfwalo, pamo ɨmyenda kʉ mundʉ gwesa jʉla. ");
INSERT INTO nyy_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mumeenye jʉjʉʉmwe ʉkʉtɨ naabombaga ɨmbombo na maboko gangʉ jʉjʉʉne, ʉkʉtɨ ngabe fyosa ɨfi naalondaga ʉkʉbombela, ʉne na biinangʉ. ");
INSERT INTO nyy_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ndɨ syosa ɨsi naabombaga, mbanangiisye ʉkʉtɨ tukʉlondigwa ʉkwijʉʉla ʉkʉbomba ɨmbombo, ʉkʉtɨ tʉbatʉʉlege aboonywa. Mugakʉmbʉkege amasyʉ agaa Ntwa Jesu, jʉʉjo aatile, ‘Sajo fiijo ʉkʉsoosya ʉkʉkɨnda ʉkwambɨlɨla.’ ” ");
INSERT INTO nyy_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paʉli bo amalɨɨsiisye ʉkʉsijoba ɨsi, alɨnkʉfugama, alɨnkwipuuta pamopeene nabo boosa. ");
INSERT INTO nyy_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Po boosa balɨnkʉlɨla fiijo, balɨnkʉmmʉʉbatɨla Paʉli nʉ kʉmfipa. ");
INSERT INTO nyy_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Baakɨndɨliile ʉkʉsulumania, paapo aababʉʉlile ʉkʉtɨ batikwisa kʉmmbonamo kangɨ. Po balɨnkʉnsindɨkɨla mpaka mu sitima. ");
INSERT INTO nyy_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Bo tʉlageene nabo, tʉlɨnkwipakɨla mu sitima, tʉlɨnkʉgoloka ʉkʉbʉʉka mpaka ndʉsʉngo lwa mu Kosi. Kɨlaabo kyake tʉlɨnkʉfika ndʉsʉngo lwa mu Loto, ʉkʉfuma ʉko tʉlɨnkʉbʉʉka mu Patala. ");
INSERT INTO nyy_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ʉko tʉlɨnkʉjaaga ɨsitima ɨjaa kʉbʉʉka mu Foinike, tʉlɨnkwipakɨla, tʉlɨnkʉbʉʉka. ");
INSERT INTO nyy_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Bo tʉfikile apa ʉlʉsʉngo lwa mu Saipulasi lukʉboneka, tʉlɨnkwenda ɨnjɨla ɨjaa kwitongo ʉkʉbʉʉka nkiisʉ ɨkya mu Silija. Apo ɨsitima jɨlɨnkwɨma nkaaja akaa mu Tili, ʉkʉtɨ jɨsulusye ɨfitwalo. ");
INSERT INTO nyy_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tʉlɨnkʉsuluka, twabalondile abiitɨki baa pala. Twatʉʉgeele nabo amasikʉ mahaano na mabɨlɨ. Abiitɨki abo baalongosigwaga ʉkʉjoba na Mbepo Mwikemo, balɨnkʉmmbʉʉla Paʉli ʉkʉtɨ alɨngabʉʉkaga mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Looli ɨliisikʉ lya kʉsookapo bo lɨfikile, abiitɨki boosa abanyambala pamopeene na bakasi baabo, na baanaabo, baatʉsindɨkiile ʉkʉsookamo nkaaja. Bo tʉfikile kʉmbalɨ kʉ nyanja, twesa tʉlɨnkʉfugama, tʉlɨnkwipuuta. ");
INSERT INTO nyy_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Po tʉlɨnkʉlagana, ʉswe tʉlɨnkwipakɨla mu sitima jɨlajɨla, abeene balɨnkʉgomoka kʉmyabo. ");
INSERT INTO nyy_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ʉkʉfuma mu Tili, tʉlɨnkwendelela nɨ njɨla jɨɨtʉ, tʉlɨnkʉfika mu Tolomei. Ʉko tʉlɨnkʉbaponia abiitɨki, tʉlɨnkʉtʉʉgala nabo iisikʉ lɨmo. ");
INSERT INTO nyy_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kɨlaabo kyake tʉlɨnkʉbʉʉka mu Kesalija. Ʉko tʉlɨnkwingɨla nnyumba jaa Filipo ʉndʉmbɨlɨli, tʉlɨnkʉtʉʉgala kʉmyake. Ʉjo aalɨ jʉmo mmbandʉ bala bahaano na babɨlɨ, aba baasaliigwe ʉkʉjaba ɨfindʉ kʉla kʉ Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filipo aalɨ na baana bana abalɨndwana, aba bakaalɨ beegi, baalɨ nɨ kɨkʉngɨlwa ɨkya kʉkunguluka. ");
INSERT INTO nyy_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bo tʉtʉʉgeele kʉla amasikʉ mingi, alɨnkwisa ʉnkunguluka jʉmo ʉkʉfuma mu Jutai, ɨngamu jaake Agabo. ");
INSERT INTO nyy_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Bo afikile, alɨnkwega ʉmpango gwa Paʉli, alɨnkwipinya amalʉndɨ na maboko alɨnkʉtɨ, “Mbepo Mwikemo ikʉjoba ikʉtɨ, ‘Abalongosi baa Bajuuta abaa mu Jelusalemu bikwakʉmpinya bo ʉlʉ, ʉmwene mpango ʉgʉ, bikwakʉmmbɨɨka mmaboko gaa bandʉ aba bakaja Bajuuta.’ ” ");
INSERT INTO nyy_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Bo tʉpɨliike ɨsyo, ʉswe pamopeene na bandʉ abangɨ aba baalipo pala, tʉlɨnkʉmpyelesya Paʉli ʉkʉtɨ alɨngabʉʉkaga mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Looli ʉmwene alɨnkwamula alɨnkʉtɨ, “Fiki mukʉlɨla nʉ kʉʉnyogonyola ɨndumbula jangʉ? Ʉne ndikʉpaasya syosa, kʉje ko kʉpinyigwa pamo koope nʉ kʉfwa mu Jelusalemu, kʉnongwa jaa ngamu jaa Ntwa Jesu.” ");
INSERT INTO nyy_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Bo twagile Paʉli asikaanile ɨsi tʉmmbʉʉlile, twalekile ʉkʉmpyelesya, twatile, “Ʉbwigane bwa Ntwa bʉbombigwege.” ");
INSERT INTO nyy_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Bo tʉtʉʉgeelepo amasikʉ agangɨ, tʉlɨnkwega ɨfyombo fyɨtʉ, tʉlɨnkwendelela nɨ njɨla jaa kʉbʉʉka kʉ Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Abiitɨki bamo abaa mu Kesalija balɨnkʉlongosania na nuuswe. Balɨnkʉtʉtwala ʉkʉtɨ tʉkatʉʉgalege nnyumba jaa mundʉ jʉmo ʉjʉ bantɨgɨ Munasoni, ʉmundʉ gwa mu Saipulasi, ʉjʉ aalɨ jʉmo mbiitɨki abaa kʉbwandɨlo. ");
INSERT INTO nyy_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Bo tʉfikile mu Jelusalemu, abiitɨki balɨnkʉtwambɨlɨla nʉ lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kɨlaabo kyake, Paʉli alɨnkʉbʉʉka pamopeene na nuuswe kʉkʉmponia Jaakobo, boope na bakʉʉlʉ boosa abaa kɨpanga baalipo. ");
INSERT INTO nyy_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paʉli bo abaponiisye, alɨnkʉbabʉʉla syosa ɨsi Kyala aabombile kʉ bandʉ aba bakaja Bajuuta, mbʉbombeli bwake. ");
INSERT INTO nyy_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bo basipɨliike ɨsyo, balɨnkʉntuufya Kyala, po balɨnkʉmmbʉʉla Paʉli balɨnkʉtɨ, “Gwamyɨtʉ, bʉle ʉsibwene ɨsi silipo apa? Balipo aBajuuta baelʉfu bingi aba bammwitiike Jesu. Boosa abo bikwendelela ʉkʉsikonga fiijo ɨndagɨlo sya Moose. ");
INSERT INTO nyy_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Leelo baabʉʉliigwe ɨnongwa syako ʉkʉtɨ kʉbamanyisya aBajuuta boosa aba bikʉtʉʉgala mfiisʉ fya bandʉ aba bakaja Bajuuta, ʉkʉtɨ basileke ɨndagɨlo sya Moose, balɨngababuutaga kʉkyeni abaanaabo, kangɨ balɨngasikongaga ɨnyiiho syɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ʉlʉ tʉtɨ fiki? Silɨ pabwelu, aabikʉpɨlɨka ʉkʉtɨ gwisile. ");
INSERT INTO nyy_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Po ʉbombe ɨsi tukʉkʉbʉʉla. Tʉlɨ nabo apa abandʉ bana aba bikʉlonda ʉkʉbomba ɨsi banndapiile Kyala. ");
INSERT INTO nyy_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ʉje pamopeene nabo, ʉbombe ʉlʉbaatɨko ʉlwa kwijeelʉsya, ʉbahombele, ʉkʉtɨ bamwe ɨnywili syabo. Lɨnga ʉbombile bo ʉlo, abandʉ boosa aabikʉmanya ʉkʉtɨ ɨnongwa syako syosa ɨsi baabʉʉligwaga sya itolo, looli ʉgwe ʉsikolile ɨndagɨlo sya Moose. ");
INSERT INTO nyy_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Looli kʉ biitɨki aba bakaja Bajuuta, twabasimbiile kalata ʉgwa kʉbabʉʉla ɨsi twatumwile, ʉkʉtɨ balɨngalyaga ɨfindʉ ɨfi bagɨsookiisye gyabaakyala ʉkʉja ikemo, balɨngalyaga iilopa, balɨngalyaga ɨnyama ɨsya finyamaana ɨfi finiongotoliigwe amakosi, kangɨ balɨngalogwaga.” ");
INSERT INTO nyy_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Po kɨlaabo kyake Paʉli alɨnkʉbeega abandʉ bala, alɨnkwipuuta ʉlwipuuto lwa kwijeelʉsya pamopeene nabo. Alɨnkwingɨla ndʉpaso lwa tempeli ʉkʉbabʉʉla abapuuti akabalɨlo akaa kʉmalɨɨsya ʉkwijeelʉsya, na kabalɨlo akaa bapuuti ʉkʉbasookesya iikemo kwa Kyala kʉkʉtɨ mundʉ ʉjʉ aalapile. ");
INSERT INTO nyy_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Amasikʉ ago mahaano na mabɨlɨ agaa kwijeelʉsya bo gikʉja pakʉmalɨka, aBajuuta bamo aba baafumile mu Asija balɨnkʉmmbona Paʉli ndʉpaso lwa tempeli, balɨnkʉbasambʉlania abandʉ boosa aba baalipo pala, balɨnkʉnkola. ");
INSERT INTO nyy_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Balɨnkʉjwega balɨnkʉtɨ, “Mwe Banyaisilaɨli, namutʉtʉʉle! Ʉjʉ jo ʉjʉ ikʉmmanyisya kʉkʉtɨ mundʉ na kʉkʉtɨ bʉjo, ɨsi sikʉpɨnga ɨkɨkolo kyɨtʉ, ɨndagɨlo sya Moose, fiijo apa Pabʉjo ʉBwikemo. Kangɨ anyasiisye ɨtempeli ɨnyiikemo paapo ikʉbingɨsya mbʉjo bwɨtʉ aba bakaja Bajuuta.” ");
INSERT INTO nyy_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Baajobile bo ʉlo paapo baalɨmmbwene nkaaja ʉmundʉ ʉjʉ akaja Njuuta, ʉjʉ aalɨ Mwefesi, ɨngamu jaake Tilofimo, bo alɨ pamopeene na Paʉli. Balɨnkwinogona ʉkʉtɨ kɨngamo Paʉli aalɨmmwingiisye mbʉjo bwabo ʉbwa tempeli. ");
INSERT INTO nyy_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Po akaaja koosa kaa Jelusalemu kalɨnkʉsambʉka, abandʉ balɨnkʉbʉngaana mbɨbɨmbɨbɨ, balɨnkʉnkola Paʉli, balɨnkʉnkwabɨla panja ʉkʉfuma mbʉjo bwa Bajuuta. Nakalɨnga abalɨndɨlɨli baa mu tempeli balɨnkwigala ɨnyiigi. ");
INSERT INTO nyy_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bo bikʉlonda ʉkʉnngoga Paʉli, ɨndʉmi jɨlɨnkʉmfikɨla ʉndongosi ʉnkʉlʉmba gwa basikali aBalooma, ʉkʉtɨ akaaja kaa Jelusalemu koosa kasambwike. ");
INSERT INTO nyy_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Nakalɨnga ʉndongosi ʉjo alɨnkʉbeega abasikali na balongosi baabo, balɨnkʉbopa ʉkʉsuluka pa kɨlʉndɨlo kya bandʉ. Abandʉ abo bo bammbwene ʉndongosi ʉnkʉlʉmba na basikali baake, balɨnkʉleka ʉkʉnkoma Paʉli. ");
INSERT INTO nyy_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ʉndongosi ʉnkʉlʉmba gwa basikali alɨnkʉmmbʉʉkɨla Paʉli, alɨnkʉnkola, alɨnkʉlagɨla ʉkʉtɨ apinyigwe nɨ minyololo mibɨlɨ. Po alɨnkʉlaalʉʉsya alɨnkʉtɨ, “Ʉjʉ jo jwani? Abombile sya fiki?” ");
INSERT INTO nyy_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bamo nkɨlʉndɨlo kɨla ɨkya bandʉ balɨnkʉjwega, kʉkʉtɨ mundʉ alɨnkʉjoba ɨsyake. Ʉndongosi ʉnkʉlʉmba gwa basikali alɨnkʉtoligwa ʉkʉsyagania ɨsi sitwele ʉnjwego. Kʉnongwa ɨjo alɨnkʉbalagɨla ʉkʉtɨ bantwale Paʉli mwi ilinga ɨlya basikali. ");
INSERT INTO nyy_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paʉli bo afikile mu ntandalɨlo ʉgwa ilinga lɨla, abasikali bala balɨnkʉmpɨmba, paapo abandʉ baalɨ bingi aba baalondaga ʉkʉnngoga. ");
INSERT INTO nyy_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ɨkɨlʉndɨlo kya bandʉ kyankongaga, kyajwegaga kyatɨgɨ, “Agogigwe!” ");
INSERT INTO nyy_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Abasikali bo balɨ kɨfuki ʉkʉmmwingɨsya Paʉli mwi ilinga lyabo, Paʉli alɨnkʉnndaalʉʉsya ʉndongosi gwabo ʉnkʉlʉmba alɨnkʉtɨ, “Bʉle, mbagiile ʉkʉkʉbʉʉla simo?” Ʉndongosi jʉla alɨnkwamula alɨnkʉtɨ, “Ngɨmba ʉmeenye ɨKɨgiliki! ");
INSERT INTO nyy_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Bʉle, ʉgwe ʉkaja jo Mmisili jʉla ʉjʉ amasikʉ aga gakɨndile, aabasongile abandʉ ʉkʉsambʉka nʉ kʉlongosya ɨkɨlʉndɨlo kya bandʉ abagogi 4,000, ʉkʉbʉʉka nabo ndʉngalangala?” ");
INSERT INTO nyy_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paʉli alɨnkwamula alɨnkʉtɨ, “Mma! Ʉne ndɨ Njuuta gwa mu Taliso, akaaja akafumuke akaa mu Kilikija. Ngʉsʉʉma ʉʉnyiitɨkɨsye njobepo na bandʉ aba.” ");
INSERT INTO nyy_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ʉndongosi jʉla bo ammwitɨkiisye, Paʉli alɨnkʉbabatamisya abandʉ nɨ kɨboko kyake, aalyɨmile pa ntandalɨlo. Bo bamyekile, alɨnkʉjoba nabo mu njobelo jaabo. ");
INSERT INTO nyy_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Paʉli alɨnkʉtɨ, “Mwe baamyɨtʉ na mwe baataata, namumbɨlɨkɨsye ɨsi ngʉjoba nkyeni mmyɨnu, ɨsya kwinokesya.” ");
INSERT INTO nyy_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Bo baagile ikʉjoba mu njobelo jaabo, balɨnkongelapo ʉkʉmyeka. Po Paʉli alɨnkʉjoba alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ʉne niine ndɨ Njuuta bo ʉlwɨnu, mbaapiigwe mu Taliso nkiisʉ ɨkya mu Kilikija, looli ngʉliile nkaaja akanywamu kakaaka akaa Jelusalemu, mmanyisiigwe na Gamalieli, ʉkʉsikonga fiijo ɨndagɨlo sya biisʉkʉlʉ bɨɨtʉ. Bwila ngʉmmbombela Kyala nɨ ndumbula jangʉ joosa, bo ʉlʉ ʉmwe mukʉbomba lɨɨlɨno. ");
INSERT INTO nyy_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","“Naabataamyaga nʉ kʉlonda ʉkʉbagoga abandʉ aba baajɨkongaga ɨNjɨla ɨjɨ ɨjaa Ntwa Jesu, naabakolaga abanyambala na bakiikʉlʉ, naabapinyaga mu nnyololo. ");
INSERT INTO nyy_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ɨsi nikʉbabʉʉla ʉmwe, ʉmpuuti ʉnkʉlʉmba pamopeene nɨ Sanihendilini joosa, babagiile ʉkʉsisimɨkɨsya ʉkʉtɨ sya nalooli. Kangɨ abeene bo aba baalɨmbeele baakalata baa kʉbatwalɨla aBajuuta biinɨɨtʉ aba baalɨ mu Ndamasika. Ʉne naabʉʉkaga kʉla ʉkʉtɨ mbapinye abandʉ aba bikʉmmwitɨka Jesu, nʉ kʉbatwala muno mu Jelusalemu, ʉkʉtɨ biise bafundigwe.” ");
INSERT INTO nyy_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Nendaga mu njɨla, bo nsegeliile ʉkʉfika mu Ndamasika, bo iisʉba lɨlɨ pantʉ, nakalɨnga ʉndangalɨla ʉnnywamu ʉkʉfuma kʉmwanya, gwalɨɨmuliike ʉkʉʉsyʉngʉʉtɨla ʉne. ");
INSERT INTO nyy_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ndɨnkʉgwa paasi, ndɨnkʉpɨlɨka ɨliisyʉ ɨlɨ likʉʉmbʉʉla likʉtɨ, ‘Saʉli! Saʉli! Fiki kʉʉfunda?’ ");
INSERT INTO nyy_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Po ndɨnkwamula ndɨnkʉtɨ, ‘Gwe Ntwa, gwe gwani?’ Ʉmwene alɨnkʉʉnyaamula alɨnkʉtɨ, ‘Ʉne ne Jesu ʉgwa mu Nasaleti, ʉjʉ ʉgwe kʉmfunda.’ ");
INSERT INTO nyy_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Aba baalɨ pamopeene na niine baagʉbwene ʉndangalɨla gʉla, looli bakaalyageenie iisyʉ ɨlya ʉjʉ aajobaga na niine. ");
INSERT INTO nyy_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Po ndɨnkʉlaalʉʉsya ndɨnkʉtɨ, ‘Ntwa, mbombe ɨfiki?’ ɄNtwa alɨnkʉʉmbʉʉla alɨnkʉtɨ, ‘Sumuka! Gwingɨle mu Ndamasika, ʉmo mo kwakʉbʉʉligwa syosa ɨsi ʉbaatɨkɨliigwe ʉkʉsibomba.’ ");
INSERT INTO nyy_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kʉnongwa jaa bʉkalɨ ʉbwa ndangalɨla gʉla, naatoliigwe ʉkʉkeeta. Abiinangʉ balɨnkʉngola ɨkɨboko, balɨnkʉʉndongosya mpaka ʉkwakʉfika mu Ndamasika. ");
INSERT INTO nyy_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ʉko aaliko ʉmundʉ jʉmo, ɨngamu jaake Ananija, ʉmundʉ ʉjʉ antiilaga Kyala, kangɨ aasikolaga fiijo ɨndagɨlo sya Moose, nʉ kwɨmɨkigwa fiijo na Bajuuta boosa aba batʉʉgalaga mu Ndamasika. ");
INSERT INTO nyy_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Jo alɨnkwisa, alɨnkwɨma kɨfuki na niine, alɨnkʉʉmbʉʉla alɨnkʉtɨ, ‘Gwamyɨtʉ Saʉli, ʉkeetege kangɨ.’ Nakalɨnga amaaso gangʉ galɨnkʉkeeta, ndɨnkʉmmbona. ");
INSERT INTO nyy_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Po alɨnkʉjoba alɨnkʉtɨ, ‘Kyala gwa biisʉkʉlʉ bɨɨtʉ akʉsalile ʉgwe ʉkʉtɨ ʉbʉmanye ʉbwigane bwake, ʉmmbone ʉNgolofu, nʉ kʉlɨpɨlɨka ɨliisyʉ ʉkʉfuma nkanwa mmyake, ");
INSERT INTO nyy_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","paapo kʉjaga nkeeti gwake kʉ bandʉ boosa, kʉbabʉʉlaga ɨsi ʉsibwene nʉ kʉsipɨlɨka. ");
INSERT INTO nyy_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Lɨɨlɨno kʉguulɨla ɨfiki? Sumuka! Goosigwe, ʉhobokeligwe ʉbʉtʉlanongwa bwako, kʉ njɨla jaa kʉsʉʉma mu ngamu jaake.’ ");
INSERT INTO nyy_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Naagomwike mu Jelusalemu, ndɨnkwingɨla mu tempeli. Bo ndɨ pakwipuuta, ndɨnkʉkɨbona ɨkɨsetʉka. ");
INSERT INTO nyy_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nkɨsetʉka ɨkyo ndɨnkʉmmbona ʉNtwa ikʉtɨ, ‘Nakalɨnga ʉsookengemo mu Jelusalemu! Paapo bakabagɨla ʉkwitɨka amasyʉ gaako agaa kʉʉsisimɨkɨsya ʉne.’ ");
INSERT INTO nyy_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ndɨnkʉmmwamula ndɨnkʉtɨ, ‘Ntwa, abeene bameenye ʉkʉtɨ ʉne nendaga kʉkʉtɨ sinagogi, naabapinyaga mu nnyololo nʉ kʉbakoma aba baakwitɨkaga ʉgwe! ");
INSERT INTO nyy_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ʉnkeeti gwako Sitefani bo ikʉgogigwa, jʉjʉʉne naalyɨmile kɨfuki, naaliitiike ʉkʉtɨ babombe bo ʉlo, naalɨndɨliile amakoti agaa bandʉ aba banngogaga.’ ");
INSERT INTO nyy_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Po ʉNtwa alɨnkʉʉmbʉʉla alɨnkʉtɨ, ‘Bʉʉkaga! Nikʉkʉtʉma kʉbʉtali, kʉ bandʉ abaa mfikolo ɨfingi.’ ” ");
INSERT INTO nyy_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ɨkɨlʉndɨlo kya bandʉ bampɨlɨkɨsyaga Paʉli, leelo bo ajobile ɨliisyʉ ɨlɨ, po balɨnkwanda ʉkʉjwega fiijo balɨnkʉtɨ, “Namunsoosyepo pakiisʉ, paapo atikʉlondigwa ʉkʉjako kʉ bʉʉmi!” ");
INSERT INTO nyy_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Kangɨ baajwegaga nʉ kʉtaaga ɨmyenda gyabo, nʉ kʉtululusya ɨfumbɨ kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Po ʉndongosi ʉnkʉlʉmba jʉla alɨnkʉbalagɨla abasikali baake ʉkʉtɨ bammwingɨsye Paʉli mwi ilinga ɨlya basikali. Kangɨ alɨnkʉbalagɨla ʉkʉtɨ banndaalʉʉsyege bo bikʉnkoma nɨ fingoti, ʉkʉtɨ asimanye ɨsi sibapelile abandʉ abo ʉkʉjwega bo ʉlo. ");
INSERT INTO nyy_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Looli bo bampinyile Paʉli nɨ ngoje, ʉkʉtɨ akomigwe ɨfingoti, Paʉli alɨnkʉnndaalʉʉsya ʉndongosi gwabo ʉjʉ aalyɨmile kɨfuki nagwe alɨnkʉtɨ, “Bʉle, mwitɨkɨsiigwe nɨ ndagɨlo, ʉkʉnkoma ʉjʉ Ndooma kʉ lʉlagɨlo lwa kiisʉ, bo akalongigwa?” ");
INSERT INTO nyy_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ʉjo bo apɨliike ɨsi, alɨnkʉbʉʉka kʉ ndongosi ʉnkʉlʉmba gwa basikali alɨnkʉtɨ, “Kʉlonda ʉkʉbomba ɨfiki? Ʉmundʉ ʉjʉ Ndooma kʉ lʉlagɨlo lwa kiisʉ!” ");
INSERT INTO nyy_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Po ʉndongosi ʉnkʉlʉmba gwa basikali, alɨnkʉmmbʉʉla Paʉli alɨnkʉtɨ, “Mbʉʉla, bʉle ʉgwe ʉlɨ Ndooma?” Paʉli alɨnkwamula alɨnkʉtɨ, “Eena!” ");
INSERT INTO nyy_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ʉndongosi jʉla alɨnkʉtɨ, “Ʉne nhongile ɨndalama ɨnyingi ʉkʉbʉkaba ʉBʉlooma kʉ lʉlagɨlo lwa kiisʉ.” Paʉli alɨnkwamula alɨnkʉtɨ, “Ʉne naapaapiigwe ndɨ Ndooma paapo taata aalɨ Ndooma.” ");
INSERT INTO nyy_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Nakalɨnga abasikali aba baalondaga ʉkʉnndaalʉʉsya Paʉli balɨnkʉnndeka, ʉndongosi ʉnkʉlʉmba ʉgwa basikali alɨnkʉtiila, bo asyageenie ʉkʉtɨ Paʉli Ndooma kʉ lʉlagɨlo lwa kiisʉ, kangɨ ampinyile nɨ minyololo. ");
INSERT INTO nyy_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kɨlaabo kyake, paapo ʉnsikali ʉnkʉlʉmba aalondaga ʉkʉbʉmanya ʉbwanalooli, ʉkʉtɨ aBajuuta fiki bansitaakile Paʉli, alɨnkʉmmwabʉla nʉ kʉbalagɨla abapuuti abalongosi, nɨ Sanihendilini ʉkʉtɨ baaganile. Po alɨnkʉntwala Paʉli, alɨnkʉmmwɨmɨka nkyeni mmyabo. ");
INSERT INTO nyy_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paʉli alɨnkʉbangʼaatulɨla amaaso abaa mu Sanihendilini, alɨnkʉjoba alɨnkʉtɨ, “Baamyɨtʉ, ʉne mbʉʉmi bwangʉ mpaka lɨɨlɨno, ndɨ nɨ ndumbula ɨnunu nkyeni mwa Kyala.” ");
INSERT INTO nyy_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Looli ʉmpuuti ʉnkʉlʉmba Ananija alɨnkʉbalagɨla aba baalyɨmile kɨfuki na Paʉli, ʉkʉtɨ bankome ni ipi kʉ kanwa. ");
INSERT INTO nyy_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Po Paʉli alɨnkʉmmbʉʉla alɨnkʉtɨ, “Kyala ikwisa kʉkʉkoma, gwe imato ɨlya mpanya! Ʉgwe ʉtʉʉgeele pakʉʉndonga ʉne ʉkʉkongana nɨ ndagɨlo sya Moose, kangɨ jʉjʉʉgwe kʉkilania ɨndagɨlo sisiisyo ʉkʉlagɨla ʉkʉtɨ ngomigwe!” ");
INSERT INTO nyy_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Abandʉ aba baalyɨmile kɨfuki na Paʉli balɨnkʉmmbʉʉla balɨnkʉtɨ, “Ʉgwe, keeta kʉntʉka ʉmpuuti ʉnkʉlʉmba gwa Kyala?” ");
INSERT INTO nyy_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paʉli alɨnkʉbaamula alɨnkʉtɨ, “Baamyɨtʉ, ngaameenye ʉkʉtɨ mpuuti ʉnkʉlʉmba, paapo sisimbiigwe mwa Kalata ʉMwikemo ʉkʉtɨ, ‘Ʉlɨnganngunaga ʉndagɨli gwa bandʉ baako.’ ” ");
INSERT INTO nyy_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paʉli aasyageenie ʉkʉtɨ bamo Basatukai, abangɨ Bafalisai, po alɨnkʉlaata mu Sanihendilini alɨnkʉtɨ, “Mwe baamyɨtʉ, ʉne ndɨ Mfalisai, ndɨ mwana gwa Bafalisai, ngʉlongigwa pabʉlongi apa paapo ngʉsʉʉbɨla ʉkʉtɨ abafwe bikwisa kʉsyʉka.” ");
INSERT INTO nyy_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Paʉli bo ajobile ɨsyo, ʉlʉkaani ʉlwa Bafalisai na Basatukai lʉlɨnkʉtupuka, ɨSanihendilini jɨlɨnkʉtapʉkana. ");
INSERT INTO nyy_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Syaboniike ɨsyo paapo aBasatukai bikʉtɨ kʉkajako ʉkʉsyʉka mbafwe, bakajako abandʉmi, nɨ mbepo sikajako. Looli aBafalisai bikwitɨka ɨsi syosa. ");
INSERT INTO nyy_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Po palɨnkʉja nʉ njwego ʉnnywamu, abamanyisi bamo abaa ndagɨlo sya Moose aba baalɨ Bafalisai, balɨnkwɨma balɨnkʉpɨnga kʉ maka balɨnkʉtɨ, “Tʉtikʉjɨbona ɨnongwa najɨmo mmundʉ ʉjʉ. Kɨngamo mbepo, pamo gwandʉmi, ajobile nagwe.” ");
INSERT INTO nyy_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ʉlʉkaani bo lʉnywamu fiijo, ʉndongosi gwa basikali alɨnkwanda ʉkʉtiila ʉkʉtɨ babagiile ʉkʉnnyaafulania Paʉli. Po alɨnkʉbalagɨla abasikali ʉkʉmmwega Paʉli kʉ maka pakatɨ pa kɨlʉndɨlo kya bandʉ, ʉkʉtɨ bantwale mwi ilinga ɨlya basikali. ");
INSERT INTO nyy_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ɨkɨlo kɨla ʉNtwa Jesu alɨnkwɨma kɨfuki na Paʉli, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Gwikasye, ʉsifumwisye ɨnongwa syangʉ mu Jelusalemu. Mpaka ʉkasifumusye moope mu Looma.” ");
INSERT INTO nyy_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Bo bʉkiile, aBajuuta bamo balɨnkwitɨkana, balɨnkʉlapa ʉkʉtɨ bikʉfipɨɨka ɨfindʉ na mɨɨsi, mpaka banngoge Paʉli. ");
INSERT INTO nyy_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Abandʉ aba baalapile ʉkʉsibomba ɨsi baakɨndile amalongo mana. ");
INSERT INTO nyy_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Po balɨnkʉbʉʉka kʉ bapuuti abalongosi na balongosi baa Bajuuta, balɨnkʉbabʉʉla balɨnkʉtɨ, “Tʉlapile ʉkʉtɨ tʉtikʉpalamaasyapo ɨfindʉ pamo amɨɨsi, mpaka tʉnngoge Paʉli. ");
INSERT INTO nyy_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kʉnongwa ɨjo, ʉmwe pamopeene nɨ Sanihendilini, mutʉme ɨndʉmi kʉ ndongosi ʉnkʉlʉmba gwa basikali ʉkʉtɨ antwale Paʉli kʉmyɨnu, mufwanege mukʉlonda ʉkʉlaalʉʉsya kanunu ɨnongwa jaake. Ʉswe twitendekiisye ʉkʉnngoga bo akaalɨ ʉkʉsegelela ʉkʉfika apa.” ");
INSERT INTO nyy_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Looli ʉmwipwa gwa Paʉli bo apɨliike ɨnongwa ɨsya kʉnngoga Paʉli, alɨnkʉbʉʉka mwi ilinga ɨlya basikali, alɨnkʉmmbʉʉla Paʉli ɨnongwa sila. ");
INSERT INTO nyy_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paʉli alɨnkʉnkoolela ʉndongosi jʉmo ʉgwa basikali, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉntwale ʉndʉmyana ʉjʉ kʉ ndongosi ʉnkʉlʉmba gwa basikali, alɨ nasyo simo ɨsya kʉmmbʉʉla.” ");
INSERT INTO nyy_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Po ʉndongosi jʉla alɨnkʉntwala ʉndʉmyana kʉ ndongosi ʉnkʉlʉmba, alɨnkʉmmbʉʉla alɨnkʉtɨ, “Ʉmpinyigwa jʉla Paʉli, angooliile nʉ kʉʉsʉʉma ʉkʉtɨ nʉntwale ʉndʉmyana ʉjʉ kʉmyako, paapo alɨ nasyo simo ɨsya kʉkʉbʉʉla.” ");
INSERT INTO nyy_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ʉndongosi jʉla alɨnkʉnkola ɨkɨboko ʉndʉmyana jʉla, alɨnkʉbʉʉka nagwe pabʉtiitʉ, alɨnkʉnndaalʉʉsya alɨnkʉtɨ, “Ɨsi kʉlonda ʉkʉʉmbʉʉla syo silɨkʉ?” ");
INSERT INTO nyy_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ʉndʉmyana jʉla alɨnkwamula alɨnkʉtɨ, “ABajuuta biitɨkeene ʉkʉkʉsʉʉma ʉkʉtɨ ʉntwale Paʉli kɨlaabo nkyeni mu Sanihendilini, ʉkʉtɨ bafwanege ngatɨ bikʉlonda ʉkʉlaalʉʉsya kanunu ɨnongwa syake. ");
INSERT INTO nyy_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Looli ʉgwe ʉlɨngiitɨka, paapo abanyambala aba bakɨndile amalongo mana aabikʉnsigɨla Paʉli mu njɨla. Balapile ʉkʉtɨ bikʉfipɨɨka ɨfindʉ na mɨɨsi, mpaka banngoge. Biitendekiisye ʉkʉnngoga, bikʉkʉguulɨla ʉgwe ʉkwitɨkɨsya Paʉli ʉkwisa mu Sanihendilini.” ");
INSERT INTO nyy_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Po ʉndongosi ʉnkʉlʉmba jʉla alɨnkʉmmwitɨkɨsya ʉmwipwa gwa Paʉli ʉkʉsookapo pala, alɨnkʉnndagɨla alɨnkʉtɨ, “Ʉlɨngammbʉʉlaga ʉmundʉ najʉmo ʉkʉtɨ ʉʉmbʉʉlile ɨnongwa ɨsi.” ");
INSERT INTO nyy_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Po ʉndongosi ʉnkʉlʉmba gwa basikali alɨnkʉbakoolela abalongosi baa basikali babɨlɨ, alɨnkʉbabʉʉla alɨnkʉtɨ, “Mwitendekesye ʉkʉsookapo mu sala jaa 3:00 ɨkɨlo ɨkɨ, ʉkʉbʉʉka mu Kesalija. Muje pamopeene na basikali ɨmia ibɨlɨ, abaa kwitoga ɨfalaasi 70, na baa ngwego ɨmia ibɨlɨ. ");
INSERT INTO nyy_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Musitendekesye nɨ falaasi ɨsya kwitogapo Paʉli, mumfikɨsye kanunu kwa Feliki ʉnkʉlʉmba gwa kiisʉ.” ");
INSERT INTO nyy_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Po ʉndongosi ʉnkʉlʉmba gwa basikali alɨnkʉsimba kalata ʉjʉ ikʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Nikʉkʉsimbɨla ʉgwe mwɨmɨkigwa Feliki, gwe ndongosi gwa kiisʉ, nikʉkʉponia, jo ʉne Kɨlaʉtio Lisija. ");
INSERT INTO nyy_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ʉmundʉ ʉjʉ aakoliigwe na Bajuuta, baalondaga ʉkʉnngoga. Ndɨnkʉbʉʉka na basikali bangʉ, ndɨnkʉmpoka, paapo naameenye ʉkʉtɨ ʉmundʉ ʉjʉ Ndooma kʉ lʉlagɨlo lwa kiisʉ. ");
INSERT INTO nyy_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ʉne naalondaga ʉkʉjɨmanya ɨnongwa ɨjɨ aBajuuta bansitaakiile, po naalɨntwele nkyeni mu Sanihendilini jaabo. ");
INSERT INTO nyy_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ndɨnkʉsyagania ʉkʉtɨ bikʉnsitaaka pabʉlongi, kʉnongwa jaa kʉkaanikana ɨsya mu ndagɨlo syabo. Looli jɨkaalipo ɨnongwa najɨmo ɨjaa kʉtɨ agogigwe pamo apinyigwe. ");
INSERT INTO nyy_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Bo mbʉʉliigwe ʉkʉtɨ aBajuuta bamo biitɨkeene ʉkʉnngoga kɨsita kʉnndonga, ndɨnkʉtumula ʉkʉtɨ atwaligwe kʉmyako. Naabalagiile boope aba bikʉnsitaaka ʉkʉtɨ biise bajobe kʉmyako ɨsi bikʉnsitaakɨla. ");
INSERT INTO nyy_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Po abasikali balɨnkʉmmwega Paʉli bo muno balagɨliigwe, balɨnkʉntwala ɨkɨlo kɨlakɨla mpaka nkaaja akaa mu Antipateli. ");
INSERT INTO nyy_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kɨlaabo kyake abasikali abaa baaliitogile ɨfalaasi balɨnkʉbʉʉka pamopeene na Paʉli, aba baalyendile paasi balɨnkʉgomokelamo mwi ilinga ɨlya basikali. ");
INSERT INTO nyy_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Abasikali aba baalɨ na Paʉli bo bafikile mu Kesalija, balɨnkʉmpapo kalata ʉndongosi gwa kiisʉ, joope Paʉli balɨnkʉmmbɨɨka mmaboko gaake. ");
INSERT INTO nyy_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Bo abalile kalata jʉla, alɨnkʉbalaalʉʉsya alɨnkʉtɨ, “Ʉmundʉ ʉjʉ afumile nkiisʉ kɨlɨkʉ?” Bo asyageenie ʉkʉtɨ ʉmundʉ ʉjo afumile nkiisʉ ɨkya mu Kilikija, ");
INSERT INTO nyy_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","alɨnkʉmmbʉʉla alɨnkʉtɨ, “Nikwisa kʉpɨlɨkɨsyaga ɨnongwa jaako, bo biisile aba bakʉsitaakile.” Alɨnkʉlagɨla ʉkʉtɨ alɨndɨlɨligwege nkɨtangaalala ɨkya Heloti. ");
INSERT INTO nyy_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Amasikʉ mahaano bo gakɨndile, ʉmpuuti ʉnkʉlʉmba Ananija alɨnkwisa bo alongoseenie na balongosi bamo abaa Bajuuta, pamopeene nʉ njobi jʉmo, ɨngamu jaake Telitulo, ʉkʉtɨ bammbʉʉle ʉndongosi gwa kiisʉ ɨnongwa ɨsi bikʉnsitaakɨla Paʉli. ");
INSERT INTO nyy_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Abasikali balɨnkʉnkoolela Paʉli pabʉlongi, Telitulo alɨnkwanda ʉkʉsitaaka alɨnkʉtɨ, “Mwɨmɨkigwa Feliki, ʉbʉlongosi bwako ʉbʉnunu bʉtwele ʉlʉtengaano kʉkabalɨlo akatali, kangɨ na ɨsi sikʉlondigwa ʉkʉtendekesigwa, kʉsitendekesya kanunu kʉnongwa jaa kiisʉ kyɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tukʉsyambɨlɨla ɨsyo akabalɨlo koosa na popoosa pala nʉ kʉgwa ʉlʉpi fiijo kʉmyako. ");
INSERT INTO nyy_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Looli kɨsita kʉtaaga akabalɨlo kaako kingi, ngʉkʉpyelesya ʉtʉpɨlɨkɨsye nɨ kɨsa kyako kʉ bʉpimba. ");
INSERT INTO nyy_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Twagile ʉmundʉ ʉjʉ ikʉleefya, ikʉpasyʉla aBajuuta mfiisʉ fyosa, kangɨ ndongosi gwa biitɨki baa mundʉ ʉgwa mu Nasaleti. ");
INSERT INTO nyy_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kangɨ aagelilepo ʉkʉjɨnyasya ɨtempeli, leelo twalɨnkolile. Twalondaga ʉkʉnndonga ʉkʉkongana nɨ ndagɨlo syɨtʉ, ");
INSERT INTO nyy_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","looli Lisija ʉndongosi ʉnkʉlʉmba gwa basikali, aaliisile na basikali bingi, aalɨmmwegile kʉ maka mmaboko gɨɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Alɨnkʉlagɨla ʉkʉtɨ aba bikʉnsitaaka biise bansitaake kʉmyako. Ʉgwe bo gʉnndaalʉʉsiisye jʉjʉʉgwe, po ʉbagiile ʉkʉsimanya ʉkʉfuma kʉmyake syosa ɨsi tʉnsitaakiile kʉmyako, ʉkʉtɨ sya nalooli.” ");
INSERT INTO nyy_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ABajuuta bala boope balɨnkongaana nagwe, balɨnkʉmmoohela Paʉli balɨnkʉtɨ, syosa ɨsi ajobile Telitulo sya nalooli. ");
INSERT INTO nyy_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Po ʉnkʉlʉmba gwa kiisʉ alɨnkwitɨkɨla ʉntʉ ʉkʉtɨ Paʉli joope ajobepo. Po Paʉli alɨnkʉjoba alɨnkʉtɨ, “Mmeenye ʉkʉtɨ ʉgwe ʉlɨ ndongi nkiisʉ ɨkɨ ɨfyɨnja fingi. Kʉnongwa ɨjo ngʉjoba nkyeni mmyako ɨsya kwinokesya nʉ lʉsekelo. ");
INSERT INTO nyy_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ʉbagiile ʉkʉsisimɨkɨsya ʉkʉtɨ gakɨndile amasikʉ kalongo na mabɨlɨ itolo, ʉkʉfuma akabalɨlo aka naabʉʉkile kʉkwipuuta mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bakaalɨɨnyaagilemo ʉkʉkaanikana nʉ mundʉ najʉmo ndʉpaso lwa tempeli, pamo ʉkʉpasyʉla ɨkɨlʉndɨlo kya bandʉ, pamo mu sinagogi, pamo moosa nkaaja. ");
INSERT INTO nyy_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ɨnongwa ɨsi bikʉʉsitaakɨla, bakabagɨla ʉkʉnangɨsya ʉkʉtɨ sya nalooli. ");
INSERT INTO nyy_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Looli ʉne ngwitɨka kʉmyako, ʉkʉtɨ ngʉmmwipuuta Kyala ʉjʉ abiisʉkʉlʉ bɨɨtʉ bammwipuutaga, nʉ kʉkongana nɨ Njɨla ɨjɨ abandʉ bamo bikʉjɨjoba ʉkʉtɨ lwitɨko lwa bʉtʉngʉlʉ. Ngwitɨka syosa ɨsi sisimbiigwe mu ndagɨlo sya Moose, nɨ sya mwa baakalata abaa bakunguluka. ");
INSERT INTO nyy_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ʉne ngʉnsʉʉbɨla Kyala, boope bikʉnsʉʉbɨla Kyala, ʉkʉtɨ kukwisa kʉjako ʉkʉsyʉka abafwe, abagolofu na babiibi. ");
INSERT INTO nyy_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Fyobeene ngwijʉʉla bwila, ʉkʉtɨ njege nɨ ndumbula ɨnunu nkyeni mwa Kyala na nkyeni mmbandʉ. ");
INSERT INTO nyy_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Bo ndʉʉgeele ɨfyɨnja fingi mbʉtali, naagomwike mu Jelusalemu, ʉkʉtɨ mbatwalɨle abandʉ ɨfya bʉsʉsɨlwa nʉ kʉnsookesya Kyala ɨliikemo. ");
INSERT INTO nyy_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Bo ngʉbomba ɨsi, aBajuuta bamo aba baafumile nkiisʉ ɨkya mu Asija, balɨnkʉʉnyaaga mmalile ʉlwipuuto ʉlwa kwijeelʉsya ndʉpaso lwa tempeli. Kɨkaalipo ɨkɨlʉndɨlo ɨkya bandʉ pamo ʉnjwego. ");
INSERT INTO nyy_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ABajuuta abo bo biise baasitaake nkyeni mmyako, lɨnga balɨ nasyo simo ɨsya kʉmbɨnga ʉne. ");
INSERT INTO nyy_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Pamo abandʉ aba balipo apa bajobe ʉkʉtɨ baalɨɨnyaagile nʉ bʉbiibi bʉlɨkʉ, bo baanyɨɨmiike mu Sanihendilini. ");
INSERT INTO nyy_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Naabombile syene ɨsi naalaatile nkyeni mmyabo ʉkʉtɨ, ‘Mukʉʉndonga ʉne kʉnongwa jaa kʉjoba ʉkʉtɨ abafwe bikwisa kʉsyʉka.’ ” ");
INSERT INTO nyy_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Paapo Feliki aasimeenye kanunu ɨsya Njɨla ɨjɨ, alɨnkʉbalania ʉlʉkomaano alɨnkʉtɨ, “Lisija ʉndongosi ʉnkʉlʉmba gwa basikali bo iisile kʉno, po nikwisa kʉtumula ɨnongwa jɨɨnu.” ");
INSERT INTO nyy_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Po Feliki alɨnkʉnndagɨla ʉndongosi gwa basikali ʉkʉtɨ ampinye Paʉli mu nnyololo, looli ajege mwabʉke panandɨ, na bamanyaani baake balɨngabasigɨlaga lɨnga bikʉlonda ʉkʉmpa fimo. ");
INSERT INTO nyy_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Amasikʉ gamo bo gakɨndile, Feliki alɨnkwisa pamopeene nʉ nkasi Ndulusila, ʉjʉ aalɨ Njuuta, alɨnkʉbalagɨla ʉkʉtɨ bantwale Paʉli. Bo iisile, alɨnkwanda ʉkʉjoba ɨsya kʉmmwitɨka Kɨlɨsiti Jesu. ");
INSERT INTO nyy_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Looli Paʉli bo ikʉjoba ɨsya bʉgolofu, ʉkwitiima, nɨ sya isikʉ lya bʉlongi ɨlɨ likwisa, Feliki ʉlʉtende lʉlɨnkʉnkola, alɨnkʉjoba alɨnkʉtɨ, “Ɨsi ʉjobile sifwene. Lɨɨlɨno bʉʉkaga, angwisa kʉkʉkoolela kangɨ lɨnga nkaagile akabalɨlo.” ");
INSERT INTO nyy_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Akabalɨlo kalakala aasʉʉbɨlaga ʉkʉhombigwa ɨndalama na Paʉli, ankoolelaga kaa kingi nʉ kʉjoba nagwe. ");
INSERT INTO nyy_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ɨfyɨnja fibɨlɨ bo fikɨndile, ʉmundʉ jʉmo ɨngamu jaake Polikio Fesiti, alɨnkʉpyanilapo pabʉjo bwa kʉlongosya ʉbwa Feliki. Leelo kʉnongwa jaa kʉtɨ Feliki aalondaga ʉkʉbahobosya aBajuuta, alɨnkʉnndeka Paʉli mu nnyololo. ");
INSERT INTO nyy_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fesiti bo afikile nkiisʉ ɨkya mu Jutai nkaaja akaa mu Kesalija, aalɨndile amasikʉ matatʉ, alɨnkʉbʉʉka mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ʉko abapuuti abalongosi na balongosi bamo abaa Bajuuta balɨnkwisa kʉmyake, balɨnkʉmmbʉʉla ɨsi baalɨnsitaakiile Paʉli. ");
INSERT INTO nyy_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Bampyelesyaga fiijo ʉkʉtɨ kwi ipyana lyake, alagɨle ʉkʉtɨ Paʉli atwaligwe mu Jelusalemu. Looli abeene baapangile ʉkʉtɨ bo ikwisa mu njɨla bansigɨle nʉ kʉnngoga. ");
INSERT INTO nyy_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Looli Fesiti alɨnkʉbaamula alɨnkʉtɨ, “Paʉli ikʉlɨndɨlɨligwa mu Kesalija, na niine ndɨ kɨfuki ʉkʉbʉʉka kʉla. ");
INSERT INTO nyy_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Abalongosi bɨɨnu bamo bikʉlondigwa ndongosanie nabo, lɨnga ʉmundʉ ʉjʉ atʉlile simo ɨmbiibi, bakansitaake.” ");
INSERT INTO nyy_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesiti bo agonile amasikʉ lwele pamo kalongo, alɨnkʉbʉʉka mu Kesalija, kɨlaabo kyake alɨnkʉtʉʉgala pa kɨkota kya bʉlongi, alɨnkʉlagɨla ʉkʉtɨ bantwale Paʉli. ");
INSERT INTO nyy_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paʉli bo iisile, aBajuuta aba baaliisile ʉkʉfuma mu Jelusalemu, baalɨnsyʉngʉʉtɨliile, bansitaakaga ɨnongwa ɨnyingi ɨsito, ɨsi baatoliigwe ʉkʉnangɨsya pa bʉkeeti. ");
INSERT INTO nyy_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Po Paʉli alɨnkʉjoba ɨsya kwinokesya alɨnkʉtɨ, “Ʉne ngatʉla ɨnongwa najɨmo mu ndagɨlo sya Bajuuta, pamo ɨsya mu tempeli, pamo kʉ malafyale ʉnkʉlʉmba gwa Balooma.” ");
INSERT INTO nyy_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fesiti aalondaga ʉkʉnangɨsya ɨliipyana lyake kʉ balongosi baa Bajuuta, po alɨnkʉnndaalʉʉsya Paʉli alɨnkʉtɨ, “Bʉle, kʉlonda ʉkʉbʉʉka kʉla kʉ Jelusalemu, ʉkʉtɨ ɨnongwa ɨsi bakʉsitaakile, sikalongigwe kʉla nkyeni mmyangʉ?” ");
INSERT INTO nyy_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paʉli alɨnkʉmmwamula alɨnkʉtɨ, “Apa ndipo ʉne ndʉʉgeele pabʉlongi, ʉbʉ bʉbɨɨkiigwe nʉ malafyale ʉnkʉlʉmba, po apa fikʉtɨ ndongeligwege. Ngababombela aBajuuta ɨmbiibi nasimo, bo ʉlʉ ʉsimeenye ʉgwe. ");
INSERT INTO nyy_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Po lɨnga mbombile lɨmo ɨlya kʉtɨ mfwege, ndikʉkaana ʉkʉfwa, looli lɨnga bʉkajamo ʉbwanalooli nabʉmo mu nongwa ɨsi bikʉʉsitaaka, akajako ʉjʉ iitɨkɨsiigwe ʉkʉʉmbɨɨka mmaboko gaabo. Ʉne ngʉsʉʉma ʉkʉtɨ ɨnongwa jangʉ jɨkalongigwe nʉ malafyale ʉnkʉlʉmba jʉʉjo!” ");
INSERT INTO nyy_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Po Fesiti bo ajobeseenie na batʉʉli baake, alɨnkʉmmwamula Paʉli alɨnkʉtɨ, “Ʉsʉʉmile ʉkʉtɨ ɨnongwa jaako jɨbʉʉke kʉ malafyale ʉnkʉlʉmba, kʉbʉʉka!” ");
INSERT INTO nyy_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Amasikʉ gamo bo gakɨndilepo, ʉmalafyale Heloti Agilipa ni ilʉmbʉ Belinike balɨnkʉfika mu Kesalija, balɨnkwisa kʉkʉmponia Fesiti. ");
INSERT INTO nyy_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Paapo baatʉʉgeele ʉko amasikʉ mingi, Fesiti aakaagile akabalɨlo akaa kʉmmbʉʉla ʉmalafyale ɨnongwa jaa Paʉli alɨnkʉtɨ, “Apa alipo ʉmundʉ jʉmo ʉjʉ Feliki aalɨnndekile mu nnyololo. ");
INSERT INTO nyy_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Bo ndɨ mu Jelusalemu, abapuuti abalongosi na balongosi baa Bajuuta baalɨnsitaakile, balɨnkʉʉsʉʉma ʉkʉtɨ nʉnndonge. ");
INSERT INTO nyy_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Looli ʉne ndikʉbaamula, ndɨnkʉtɨ lʉkaja lwiho lwa Balooma ʉkʉnndonga ʉmundʉ, bo akaalɨ ʉkwaganila na bandʉ aba bikʉnsitaaka, kangɨ kɨsita kʉjoba simo ɨsya kwinokesya. ");
INSERT INTO nyy_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bo tʉfikile apa pa Kesalija, ngajɨkaabiisye ɨnongwa. Kɨlaabo kyake ndɨnkʉtʉʉgala pa kɨkota kya bʉlongi, ndɨnkʉlagɨla ʉkʉtɨ ʉmundʉ ʉjo bantwale. ");
INSERT INTO nyy_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Abasikali bo bantwele, balɨnkwɨma aba baalɨnsitaakile, balɨnkwanda ʉkʉnsitaaka, looli ɨnongwa ɨsi bansitaakaga sikaalɨ mbiibi bo muno naasʉʉbɨlaga. ");
INSERT INTO nyy_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Baakaanikanaga nagwe ɨsya lwitɨko lwabo, nɨ sya mundʉ jʉmo ʉjʉ bikʉtɨ Jesu ɨngamu jaake, ʉjʉ aafwile, looli ʉmwene Paʉli ikʉtɨ asyʉkile mʉʉmi. ");
INSERT INTO nyy_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ngaasimeenye ɨsya kʉbomba ʉkʉkaba ʉbwanalooli bwa nongwa ɨjɨ, po ndɨnkʉnndaalʉʉsya Paʉli ʉkʉtɨ lɨnga ikʉlonda ʉkʉbʉʉka kʉ Jelusalemu, ko ɨnongwa jaake jɨkalongigwe. ");
INSERT INTO nyy_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Looli Paʉli aakaanile, alɨnkʉsʉʉma ʉkʉtɨ abɨɨkigwe mu nnyololo bo ikʉguulɨla ɨnongwa jaake ʉkʉlongigwa nʉ malafyale ʉnkʉlʉmba gwa Balooma. Po ndikʉlagɨla ʉkʉtɨ endelelege ʉkʉlɨndɨlɨligwa mpaka akabalɨlo aka nikwisa kʉntwala kʉ malafyale ʉnkʉlʉmba.” ");
INSERT INTO nyy_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Po Agilipa alɨnkʉmmbʉʉla Fesiti alɨnkʉtɨ, “Na niine naalondaga ʉkʉmpɨlɨkɨsyapo ʉmundʉ ʉjo.” Fesiti alɨnkʉtɨ, “Kʉmpɨlɨkɨsya kɨlaabo.” ");
INSERT INTO nyy_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kɨlaabo kyake Agilipa ni ilʉmbʉ Belinike balɨnkwisa nʉ bʉsisya ʉbʉkʉlʉmba, balɨnkwingɨla mbʉlongelo ɨnongwa, pamopeene na balongosi abakʉlʉmba abaa basikali, na balongosi baa nkaaja. Po kʉ lʉlagɨlo ʉlwa Fesiti, balɨnkʉntwala Paʉli. ");
INSERT INTO nyy_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Po Fesiti alɨnkʉjoba alɨnkʉtɨ, “Malafyale Agilipa, na mwesa mwe mulipo pamopeene na nuuswe, ʉmundʉ ʉjʉ ɨɨmile nkyeni mmyɨnu, jo ʉjʉ aBajuuta boosa aba apa, na baa mu Jelusalemu, baalɨnsitaakile kʉmyangʉ. Baajwegaga baatɨgɨ ʉmundʉ ʉjʉ atikʉlondigwa ʉkʉjako kʉ bʉʉmi. ");
INSERT INTO nyy_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Looli ʉne bo njɨpɨlɨkiisye ɨnongwa jaake, naalyagile akabomba nasimo ɨmbiibi ɨsya kʉmpelela ʉkʉtɨ agogigwe. Ʉmwene bo asʉʉmile ʉkʉkɨnda kʉ malafyale ʉnkʉlʉmba, ndɨnkʉtumula ʉkʉntwala. ");
INSERT INTO nyy_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Looli ʉne ngaja nasyo nasimo ɨsya mundʉ ʉjʉ ɨsya kʉnsimbɨla ʉntwa gwɨtʉ ʉmalafyale ʉnkʉlʉmba. Fyobeene nʉntwele nkyeni mmyɨnu mwesa, fiijo nkyeni mmyako, gwe malafyale Agilipa, ʉkʉtɨ bo tʉnndaalʉʉsiisye nsyagemo simo ɨsya kʉnsimbɨla. ");
INSERT INTO nyy_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Paapo naagile ʉkʉntʉma ʉmpinyigwa kɨsita kʉsimba ɨnongwa jaake, bo ngabomba najɨmo.” ");
INSERT INTO nyy_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Po Agilipa alɨnkʉmmbʉʉla Paʉli alɨnkʉtɨ, “Gwitɨkɨsiigwe ʉkʉjoba.” Po Paʉli alɨnkʉgolosya ɨkɨboko kyake, alɨnkwanda ʉkʉjoba ɨsya kwinokesya alɨnkʉtɨ, ");
INSERT INTO nyy_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Malafyale Agilipa, ngwibona ʉkʉtɨ ndɨ nʉ lʉsajo, paapo nɨɨmile nkyeni mmyako ʉmwisyʉgʉ, ʉkwamula ɨnongwa syosa ɨsi aBajuuta baasitaakile. ");
INSERT INTO nyy_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ʉgwe ʉsimeenye ɨnyiiho syosa nɨ nongwa ɨsi bikʉkaanikana aBajuuta. Kʉnongwa ɨjo ngʉkʉsʉʉma ʉmbɨlɨkɨsye nʉ lwifimbɨlɨsyo. ");
INSERT INTO nyy_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“ABajuuta boosa bakameenye akajɨɨlo kangʉ ʉkʉfuma mbʉtubwa. Bameenye muno naatʉʉgaliile ʉkʉfuma kʉbwandɨlo, ngʉliile nkɨkolo kyangʉ na mu Jelusalemu. ");
INSERT INTO nyy_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Baameenye akabalɨlo akatali, lɨnga bikʉlonda ʉkʉjoba ɨsya bʉkeeti, ʉkʉtɨ naalɨ Mfalisai, ʉgwa lwitɨko lwɨtʉ ʉlʉ lukʉsisimɨkɨsya fiijo ʉkʉsikonga ɨndagɨlo syɨtʉ. ");
INSERT INTO nyy_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Looli lɨɨlɨno nɨɨmile apa pakʉlongigwa kʉnongwa jaa lʉsʉʉbɨlo ʉlwa lʉfingo ʉlʉ lwafingiigwe kʉ biisʉkʉlʉ bɨɨtʉ na Kyala jʉʉjo. ");
INSERT INTO nyy_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ʉlʉfingo ʉlo ɨfikolo fyɨtʉ kalongo na fibɨlɨ fikʉlʉsʉʉbɨla ʉkʉlwaga kʉ njɨla jaa kwijʉʉla ʉkwipuuta pamuusi na pakɨlo. Gwe malafyale! Kʉnongwa jaa kʉlʉmbɨlɨla ʉlʉsʉʉbɨlo ʉlo, aBajuuta bikʉʉsitaaka! ");
INSERT INTO nyy_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Fiki jʉmo nkɨlʉndɨlo kyɨnu iinogonege ʉkʉtɨ sikaja sya kwitɨka, ʉkʉtɨ Kyala ikʉbomba ɨsi aafingile ɨsya kʉbasyʉsya abafwe? ");
INSERT INTO nyy_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ʉne niine niinogonaga ʉkʉtɨ, sibagiisye ʉkʉbomba ɨmbombo sii nyingi, ɨsi sikʉpɨnga ɨngamu jaa Jesu ʉgwa mu Nasaleti. ");
INSERT INTO nyy_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ɨsyo syo ɨsi naasibombile mu Jelusalemu jʉjʉʉne. Bo mbeeliigwe amaka na bapuuti abalongosi, naabapinyile abiitɨki baa Jesu bingi. Kangɨ bo balongiigwe ʉkʉgogigwa, niitɨkaga itolo. ");
INSERT INTO nyy_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Kaa kingi naabafundaga mu sinagogi syosa, naagelile ʉkʉbafimbɨlɨsya ʉkʉlʉkaana ʉlwitɨko lwabo. Naalɨ nɨ ngalalɨsi fiijo kʉmyabo ʉkʉfikɨla ʉkʉbafwɨma, mpaka ntwaja ʉtwa fiisʉ ɨfingi.” ");
INSERT INTO nyy_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Iisikʉ lɨmo naalɨ mu njɨla naabʉʉkaga mu Ndamasika kʉkʉbomba ɨsyo, paapo naalɨ na maka nʉ lʉlagɨlo ʉkʉfuma kʉ bapuuti abalongosi. ");
INSERT INTO nyy_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Gwe malafyale, bo ndɨ mu njɨla, pamuusi iisʉba bo lɨlɨ pantʉ, ndɨnkʉgʉbona ʉndangalɨla ʉnnywamu ʉkʉfuma kʉmwanya, gwalɨ nkalɨ ʉkʉlɨkɨnda iisʉba, gwalɨɨmuliike ʉkʉʉsyʉngʉʉtɨla ʉne na aba nendaga nabo mu njɨla. ");
INSERT INTO nyy_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ʉswe twesa tʉlɨnkʉgwa paasi, ʉne ndɨnkʉpɨlɨka ɨliisyʉ likʉʉmbʉʉla mu njobelo jangʉ likʉtɨ, ‘Saʉli! Saʉli! Fiki kʉʉfunda? Kwifulasya itolo ʉkʉpɨnga ɨsi ikʉkʉlagɨla ʉndongosi.’ ");
INSERT INTO nyy_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ʉne ndɨnkʉlaalʉʉsya ndɨnkʉtɨ, ‘Gwe Ntwa, gwe gwani?’ ɄNtwa alɨnkʉʉnyaamula alɨnkʉtɨ, ‘Ʉne ne Jesu, ʉjʉ ʉgwe kʉmfunda. ");
INSERT INTO nyy_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Leelo sumuka, gwɨme na malʉndɨ gaako, paapo ngʉsetʉkiile ʉkʉtɨ ngʉbɨɨke ʉkʉja mbombeli gwangʉ. Kangɨ ʉfumusyege ɨsi ʉsibwene lɨɨlɨno, na ɨsi ngwisa kwinangɨsya kʉmyako. ");
INSERT INTO nyy_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ngwisa kʉkʉpoka kʉ Bajuuta biinaako, na kʉ bandʉ aba bakaja Bajuuta. Ngʉkʉtʉma kʉmyabo, ");
INSERT INTO nyy_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ʉkabiigʉle amaaso gaabo, ʉkʉtɨ basookemo mu ngiisi, bapɨndʉke biise ndʉmuli, basookemo mmaka gaa Seetano, biise mmaka gaa Kyala, ʉkʉtɨ bakabe ʉlʉhobokelo ʉlwa bʉtʉlanongwa bwabo, bakabe ʉbʉjo pakatɨ pa bandʉ abiikemo kʉ njɨla jaa kʉʉnyiitɨka ʉne.’ ");
INSERT INTO nyy_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Gwe malafyale Agilipa, jo nongwa ɨjɨ ʉne ngaakiilile ɨkɨsetʉka ɨkya kʉmwanya. ");
INSERT INTO nyy_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Looli naabalʉmbɨliile taasi abandʉ abaa mu Ndamasika, po mu Jelusalemu na ntwaja ʉtʉngɨ ʉtwa mu Jutai, nʉ twaja toosa ʉtwa pakiisʉ. Naalʉmbɨliile kʉ Bajuuta na kʉ bandʉ aba bakaja Bajuuta, ʉkʉtɨ bapɨndʉke. Kangɨ babombege ɨmbombo ɨsi sikʉnangɨsya ʉkʉtɨ bapɨndwike. ");
INSERT INTO nyy_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kʉnongwa ɨjo, aBajuuta balɨnkʉngola bo ndɨ ndʉpaso lwa tempeli, balɨnkʉlonda ʉkʉʉngoga. ");
INSERT INTO nyy_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Looli Kyala andʉʉlile mu mbombo syangʉ ʉkʉfika lɨɨlɨno, nɨɨmile ʉlʉ ʉkʉfumusya kʉ baniini na bakʉsi. Ɨsi ngʉjoba syo ɨsi abakunguluka na Moose baajobile ʉkʉtɨ aasikwisa kʉboneka. ");
INSERT INTO nyy_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Baajobile ʉkʉtɨ Meesija mpaka akʉbɨlwe, nʉ kʉja gwa kwanda ʉkʉsyʉka ʉkʉfuma mbafwe. Ikwisa kʉjɨfumusya ɨndʉmi jaa lʉmuli lwa bʉpoki kʉ bandʉ baake na kʉ bandʉ boosa abaa pakiisʉ.” ");
INSERT INTO nyy_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paʉli bo ikwendelela ʉkʉjoba ɨsi, Fesiti alɨnkʉlaata alɨnkʉtɨ, “Ʉgwe Paʉli! Ʉkɨmbiile ɨkɨgɨlɨ! Ʉbʉmanyi fiijo bwako bʉkʉpeliile ɨkɨgɨlɨ!” ");
INSERT INTO nyy_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Looli Paʉli alɨnkwamula alɨnkʉtɨ, “Mwɨmɨkigwa Fesiti, ʉne ngaja nɨ kɨgɨlɨ, looli ngʉjoba sya nalooli, kangɨ bo ndɨ na mahala goosa. ");
INSERT INTO nyy_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ʉne ngʉjoba nkyeni mmalafyale kɨsita kwilaamwa, kʉnongwa jaa kʉtɨ ʉmalafyale asimeenye ɨnongwa ɨsi syosa. Mmeenye ʉkʉtɨ lɨkajako nalɨmo mu nongwa ɨsi, ɨlɨ akalɨmanya, paapo sikaabombiigwe kʉbʉtiitʉ. ");
INSERT INTO nyy_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Gwe malafyale Agilipa, kʉbiitɨka abakunguluka? Mmeenye ʉkʉtɨ kʉbiitɨka.” ");
INSERT INTO nyy_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Po malafyale Agilipa alɨnkʉmmbʉʉla Paʉli alɨnkʉtɨ, “Bʉle, kʉkabalɨlo kapimba itolo kʉlonda ʉkʉmbela ʉne ʉkʉja Nkɨlɨsiti?” ");
INSERT INTO nyy_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paʉli alɨnkʉmmwamula alɨnkʉtɨ, “Ngʉnsʉʉma Kyala kaje kabalɨlo kapimba pamo katali, somma gwimwene itolo, looli na boosa aba bikʉmbɨlɨkɨsya ʉmwisyʉgʉ bajege bo ʉlwangʉ, looli kɨsita minyololo ɨgɨ.” ");
INSERT IN