﻿USE sofia;
DROP TABLE IF EXISTS sofia.nyu_vpl;
CREATE TABLE nyu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nyu_vpl WRITE;
INSERT INTO nyu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pakutoma Mulungu adalenga kudzulu na dziko la pansi. ");
INSERT INTO nyu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Dzikolo likhalibe maonekedwe yabwino ndipombo likhalibe cinthu. Mdima ukhadampsinkha nyandza yomwe ikhali padziko lense, ndipo Mzimu wa Mulungu ukhafamba-famba padzulu pa madzi. ");
INSERT INTO nyu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tsono Mulungu adati: “Kukhale ceza,” ndipo kudakhala na ceza. ");
INSERT INTO nyu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mulungu adaona kuti cezaco cikhali bwino. Pamwepo adamwazanisa ceza na mdima. ");
INSERT INTO nyu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Cezaco Mulungu adaciti masikati, mdima adauti usiku. Ndipo padawoneka maulo na macibese, ntsiku yakutoma. ");
INSERT INTO nyu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Patsogolo pace Mulungu adati: “Pakhale mtambo pakati pa madzi kuti madzi na madzi yagawikane,” ");
INSERT INTO nyu_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Na tenepo Mulungu adalenga mtambo ndipo adagawa madzi yakhali pansi pa ntambo yanango yakhali padzulu pa mtamboyo. Ndipo bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ndipo Mulungu adaucemera kuti kudzulu. Ndipo padawoneka maulo na macibese, ntsiku yaciwiri. ");
INSERT INTO nyu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ndipo Mulungu adati: “Madzi ya pantsi pa mtambo yakhale pambuto ibodzi, pawoneke mbuto yakuuma”, ndipo bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mbuto yakuuma Mulungu adayati Dziko, ndipo madzi yakhali pabodzi yale adayati nyanza. Mulungu adawona kuti bzikhali bwino. ");
INSERT INTO nyu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Tsono Mulungu adati: “Pamataka pacoke bzakumera, miti yakubala mbeu, ndipombo na miti yakubala bzisapo malingana na mtundu wace,” ndipo bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Na tenepo pamataka padamera bzakumera: Miti yakukhala na njere malingana ntundu wace na miti yakubereka bzisapo bza njere, malingana mitundu yayene. Mulungu adaona kuti bzikhali bwino. ");
INSERT INTO nyu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ndipo padawoneka maulo na macibese ya ntsiku yacitatu. ");
INSERT INTO nyu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Patsogolo pace Mulungu adati: “Kudzaulu kwa mtambo kukhale na bzakubvunika kuti pawoneke kugawana masikati na usiku. Pomwe kuti bzikhale bzizindikiro bza nthawe, ntsiku na magole. ");
INSERT INTO nyu_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ndipo bzakubvunika bzimwebzi bzikhale kudzulu kwa mtambo bzicimbabvunika dziko la pansi,” Ndipo bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Na tenepo Mulungu adalenga bzakubvunika bzikulu bziwiri: Cikulu kuti cibvunike masikati, ndipo cing'ono kuti cibvunike usiku. Ndipo adalengambo nyenyezi. ");
INSERT INTO nyu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Mulungu adabziikha padzulu pa mtambo kuti bzibvunike pansi, ");
INSERT INTO nyu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kuti bzimbabvunike masikati na usiku, kugawa ceza na mdima. Ndipo Mulungu adawona kuti bzikhali bwino. ");
INSERT INTO nyu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ndipo padawoneka maulo na macibese ya ntsiku yacinai. ");
INSERT INTO nyu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mulungu adati pomwe: “Munyanza mukhale na bzamoyo bzizinji, ndipo pakhale na mbalame zakumbuluka mdzulu mwa dziko”. ");
INSERT INTO nyu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ndipo Mulungu adalenga bzirombo bzikulu-bzikulu bza mnyanza, pabodzi na bzakulengedwa bzinango bzizinji bza mmadzi, malingana mitundu yace, ndipombo bzakumbuluka bzentse malingana mitundu yace. Ndipo Mulungu adaona kuti bzikhali bwino. ");
INSERT INTO nyu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ndipo Mulungu adabzidalisa, aciti: “Balanani, mudzaze madzi ya mnyanza. Ndipombo bzakumbuluka bzidzale padziko”. ");
INSERT INTO nyu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ndipo padawoneka maulo na macibese ya ntsiku yacixanu. ");
INSERT INTO nyu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ndipo Mulungu adati: “Padziko pakhale na bzamoyo malingana mitundu yace: Bzifuwo, bzakukwawa na bzirombo, cibodzi na cibodzi malingana mtundu wace”, Ndipo bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Pamwepo Mulungu adalenga bzirombo malingana mitundu yace, na bzifuwo malingana mitundu yace, na bzakukwawa malingana mitundu yace. Ndipo Mulungu adawona kuti bzikhali bwino. ");
INSERT INTO nyu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Na tenepo Mulungu adati: “Mbatikondze munthu wakulingana na ife ndipo adzakhale ninga ife. Adzatonge ntsomba za m'madzi, mbalame za mdzulu, bzifuwo, na bzakukwawa bzense bzapadziko lapansi”. ");
INSERT INTO nyu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ndipo Mulungu adalenga munthu mwakulingana na iye, mwakulingana na Mulungu adamulenga, adawalenga mwamuna na mkazi. ");
INSERT INTO nyu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mulungu adawadalisa, ndipo adati: “Mubalane, muwande, mudzaze dziko lense lapansi mucimbalitonga. Mutonge ntsomba za m'nyandza, mbalame za mdzulu na bzinyama bzakukwawa bzentse bza padziko”. ");
INSERT INTO nyu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ndipo Mulungu adati: “Ndiri kukupasani bzakumera bzense bzomwe bzin'bala padziko lentse la pantsi na miti yentse yomwe in'bala bzisapo bzina njere. Ibzo bzidzakhala phoso kwa imwe. ");
INSERT INTO nyu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Tsono bzinyama bzentse bza mdziko, mbalame zentse zamdzulu, na bzakukwawa bzense bzomwe bzina mphuwe ya moyo, ndabzipasa uswa buwisi bwentse kuti bzimbadye,” ndipo bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ndipo Mulungu adaona kuti bzense bzomwe adalenga bzire bzikhali bzabwino kwene-kwene. Tsono padawoneka maulo na macibese ntsiku yacitanthatu. ");
INSERT INTO nyu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Tenepoyo bzidamala kulengedwa, kudzulu na dziko la pantsi, na bzentse bzomwe bziri mumwemo. ");
INSERT INTO nyu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Pa ntsiku ya cinomwe Mulungu akhadamaliza kale basa lomwe akhacita, ndipo adapuma pantsiku imweyo. ");
INSERT INTO nyu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ndipo Mulungu adadalisa ntsiku yacinomwe aciipambula, thangwe pa ntsiku imweyo adapuma. ");
INSERT INTO nyu_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Imwei ni n'khani yo momwe bzidalengedwa, kudzulu na pantsi. Pomwe Mbuya Mulungu adalenga dziko la pantsi na bzentse bza kudzulu, ");
INSERT INTO nyu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","pakhalibe cakumera ciri-cense padziko la pantsi, ndipo mbeu zikhanati kumera, thangwe Mbuya Mulungu akhanati kubvumbisa mbvula padziko la pantsi. Ndipombo pakhalibe munthu wakulima pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tsono pfulere likhacoka pantsi licikwira licimbatotesa matakayo. ");
INSERT INTO nyu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Tsono Mbuya Mulungu adatenga pfumbi pamataka aciumba munthu, ndipo adamufulizira mphuwe wa moyo mumphuno mwace, ndipo munthuyo adakhala na moyo. ");
INSERT INTO nyu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ndipo Mbuya Mulungu adafungula munda wa bzisapo muEdeni kucipande ca kumabvadzuwa, ndipo munthu omwe adaumba ule adamuikha momwemo. ");
INSERT INTO nyu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Pamwepo Mulungu, pamataka adameresa miti ya mitundu iri yentse yamawonekedwe yabwino ndipo wabwino kudya. Tsono pakati pa mundayo pakhana muti wamoyo, na muti wakudziwisa bzabwino na bzakuipa. ");
INSERT INTO nyu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Mu Edeni mukhacoka mkulo omwe ukhathiriza mundayo, kucokera mumwemo ukhagawika panai. ");
INSERT INTO nyu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mkulo wakuyamba ukhacemeredwa Pisoni. Umweyo umbagonyola-gonyola mudziko la Havila, komwe kuna oro. ");
INSERT INTO nyu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Oro ya dziko lire njabwino, komweko kumbaoneka pomwe bedeliyo na mwala wa Onix. ");
INSERT INTO nyu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Mkulo waciwiri umbacemeredwa Giom, ndiwo umbazungulira dziko la Cuxe. ");
INSERT INTO nyu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Mkulo wacitatu umbacemerewa Tigre, omwe umbayenda kumabvadzuwa kwa Assiria, wacinai ni Eufarate. ");
INSERT INTO nyu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Tsono Mbuya Mulungu adatenga muthu ule acimuikha m'munda mwa Edeni kuti ambaulime na kuukonkhobza. ");
INSERT INTO nyu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ndipo Mbuya Mulungu adamupasa mphambvu munthuyo adati: “Pa miti yentse ya m'munda dyaya mwa ufulu. ");
INSERT INTO nyu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tsono leka kudya muti wa kudziwisa bzabwino na bzakuipa, thangwe ntsiku yomwe undzadya, cadidi iwe un'dzafa”. ");
INSERT INTO nyu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Patsogolo pace Mbuya adati: “Ni bzabwino lini kuti munthu akhale ekha. Ninin'konzera mwanzace kuti ambamuthandize”. ");
INSERT INTO nyu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ndipo Mbuya Mulungu atamara kuumba kucokera kumataka bzinyama bzense bzamtengo na mbalame zamudzulu zentse, adabzibweresa kuna Munthu, kuti awone angadabzicemera tani. Dzina lomwe munthu angadapereka kuna bzamoyo bzentse limwelo ndilo lingadakhala dzina laceene. ");
INSERT INTO nyu_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Adamu adapasa madzina bzifuwo bzense, mbalame za mudzulu na bzinyama bzense bzamuthengo. Pa bzensebzi alibe kuwona comwe cingadathandiza muthu napo kubverana naye. ");
INSERT INTO nyu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Pamwepo Mbuya Mulungu adacitisa munthu tulo ninga adafa, ndipo pomwe iye akhali mutulo, adamucosa mbabvu ibodzi, ndipo mbutoyo adaifunga na nyama. ");
INSERT INTO nyu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Na mbabvu yomwe Mbuya Mulungu adacosa kwa mamuna, adaikondza mkazi ndipo adambweresa kuna iye. ");
INSERT INTO nyu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Mwamuna adati: “Uyu ni cadidi pfupa la mapfupa yangu, ndipo nyama ya nyama yangu. An'dzacemeredwa mkazi thangwe acokera kwa mamuna”. ");
INSERT INTO nyu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ndipopo mamuna an'dzasiya baba na mai wace aciphatana na mkazi wace, iwo acikhala thupi libodzi. ");
INSERT INTO nyu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mwamuna na mkazi wace akhakhala pezi, tsono akhabva lini manyazi. ");
INSERT INTO nyu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Tsono, nyoka ikhadacenjera kuposa bzamoyo bzense bzomwe Mbuya Mulungu adalenga. Ndipo iyo idabvunza mkazi ule kuti: “Mulungu adalewadi tenepa kuti: ‘Lekani kudya bzisapo bza muti uli-wentse mmunda muno?’ ”. ");
INSERT INTO nyu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mkazi ule adatawira nyoka kuti: “Tingadye bzisapo bza miti yense ya mmundamu, ");
INSERT INTO nyu_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","tsono Mulungu adati: Lekani kudya muti omwe uli pakati pa munda, ngakhale kuukhuya, sabwa mungadzacitatenepo mun'dzafa”. ");
INSERT INTO nyu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Pamwepo nyoka idauza mkazi ule kuti: “Cadidi mun'dzafa lini! ");
INSERT INTO nyu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mulungu an'dziwa kuti ntsiku yomwe mudzaudya, maso yanu yan'dzafunguka, ndipo imwe mun'dzakhala ninga Mulungu, mun'dzakhala adziwi wa bzabwino na bzakuipa”. ");
INSERT INTO nyu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Pomwe mkazi adawona kuti muti ule ukhadadeka kudya, na maonekedwe yabwino, ndipo wakufunika ucipasa udziwi, adaca bzisapo bzace acidya ndipo adapasambo mwamuna wace, acidyambo. ");
INSERT INTO nyu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Awiriwo maso yawo yadafunguka, ndipo adadziwa kuti ali pezi. Na terepo adasona masamba ya mkuyu acibvala. ");
INSERT INTO nyu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Pauwiri bwawo pomwe adabva fala na ntswata-tswata wa Mbuya Mulungu akhafamba-famba maulo dzuwa latapepa mmunda mule, iwo adacoka patsogolo pa Mbuya Mulungu acikabisala pakati pamiti. ");
INSERT INTO nyu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ndipo Mbuya Mulungu adacemera mwamuna adambvundza kuti: “Kodi uli kuponi?” ");
INSERT INTO nyu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ndipo iye adatawira kuti: “Ndabva kufamba kwanu mmunda ndipo ndakhala na mantha thangwe ndikhali pezi, ndipopo ndabisala”. ");
INSERT INTO nyu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mulungu adamubvundza kuti: “Kodi mbani akuuza kuti uli pezi? Iwe wadya bzisapo bza muti omwe ndidakuletsa kudya?” ");
INSERT INTO nyu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mwamuna, adatawira kuti: “Mkazi omwe mudandipasa ninga mkazi wangu iye wandipasa cisapo ca muti ndipo ine ndadya”. ");
INSERT INTO nyu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mbuya Mulungu adabvunza mkazi kuti: “Niciani comwe wacitaci?” Mkazi adatawira kuti: “Nyoka ndiyo yandipumpsa ndipo ine ndadya”. ");
INSERT INTO nyu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Pamwepo Mulungu adauza nyoka kuti: “Pakuti wacita bzimwebzi, iwe wakutembereredwa pakati pa bzifuwo na bzilombo bza mthengo bzentse. Un'dzafamba na mimba yako, ndipo cakudya cako cin'dzakhala pfumbi ntsiku zense za moyo wako. ");
INSERT INTO nyu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ndin'dzaikha udani pakati pa iwe na mkazi, pan'dzakhala udani pakati pa wana wako na wana wace. An'dzaswa msolo wako ndipombo iwe un'dzaluma katende wace”. ");
INSERT INTO nyu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kwa mkazi adati: “Nindzathimizira kubonera kwako na mimba. Mwakubonera iwe un'dzabereka wana. Kufuna kwako kundzakhala kwa mamuna wako ndipo iye an'dzakutonga”. ");
INSERT INTO nyu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ndipo kwa mamuna adati: “Pakuti iwe wabvera mkazi wako, ndipo wadya cisapo comwe ndidakuuza kuti uleke kudya, Mataka yan'dzatembereredwe thangwe la iwe. Iwepo un'dzadya mwakubonera ntsiku zentse za moyo wako. ");
INSERT INTO nyu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Iyo yan'dzabala minga na bzakumera bza mthengo. Iwe un'dzadya bzakulima. ");
INSERT INTO nyu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Iwe Un'dzadya pau yako mwakucoka kaluma, kufikira udzabwerere kumataka, sabwa udacosiwa mwa iyo. Thangwe iwe ndiwe pfumbi ndipo kupfumbi un'dzabwerera”. ");
INSERT INTO nyu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu adapasa mkazi wace dzina lakuti Yeva, thangwe lakuti iye angadadzakhala mayi wa nthundu wentse wa wanthu. ");
INSERT INTO nyu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mbuya Mulungu adakondza bzakubvala bza khanda aciwabvazika Adamu na mkazi wace. ");
INSERT INTO nyu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Pamwepo Mbuya Mulungu adati: “Tsapano munthu akhala ninga ife, ali kudziwa bzabwino na bzakuipa. Na tenepo, aleke kubvumizidwa kuti iye atengembo cisapo ca muti moyo acicidya ndipo acikhala na moyo wakusaya kumala”. ");
INSERT INTO nyu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ndipopo Mbuya Mulungu adamthotha m'dimba mwa Edeni kuti alime mumataka momwe adacokera. ");
INSERT INTO nyu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Pomwe adandothotha Adamu, Mulungu adaikha anju zakukhalirira kumabvadzuwa kwa dimba la Edeni ndipo adaikha cisenga ca moto comwe cikhambazungulira, kukhalirira njira yakufika pamuti wa moyo. ");
INSERT INTO nyu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu adafambizana na mkazi wace Eva, ndipo iye adakhala na pathupi acibereka Kaini. Iye adati: “Mwakuthandizidwa na Mbuya ndabereka mwana wacimuna”. ");
INSERT INTO nyu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Patsogolo pace adabereka Aberi mbale wace. Aberi akhali makabusa wa mabira ndipo Kaini akhali mulimi. ");
INSERT INTO nyu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Yatapita nthawe pan'gono, Kaini adabweresa cakupereka ca bzisapo bza m'munda kuna Mbuya. ");
INSERT INTO nyu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Tsono, Aberi adabweresa ncere zakuyamba za mabira yace za zakunenepa. Ndipo Mbuya adatambira mwakukomedwa, cakupereka ca Aberi. ");
INSERT INTO nyu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Tsono Mbuya alibe kumtambira Kaini na cakupereka cace. Ndipopo Kaini adakalipa nkhope yace idadodoma. ");
INSERT INTO nyu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Pamwepo, Mbuya adati kuna iye, “Thangwe ranyi wakalipa? Thangwe lanyi nkhope yako yadodoma? ");
INSERT INTO nyu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Iwe ungacita bzabwino, ungaleke kutambiridwa? Tsono ungaleka kucita, dziwa kuti cakuipa ciri pamsuwo. Cakuipaco cin'funa kukunda, tsono iwe ucikunde”. ");
INSERT INTO nyu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kaini adauza mbale wace Aberi kuti: “Mbatiyende kuthengo”. Pomwe akhali kumweko, Kaini adasandulikira mbale wace acimupha. ");
INSERT INTO nyu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Pamwepo Mbuya adabvunza Kaini kuti: “Mbale wako Aberi ali kuponi?” Iye adatawira kuti: “Nin'dziwa lini, kodi ndine wakunyan'gani mbale wanguyo?” ");
INSERT INTO nyu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ndipo Mbuya adamuuza kuti: “Kodi n'ciani comwe wacita? Tetekera! Mulopa wa mbale wako ulikulira pamataka. ");
INSERT INTO nyu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tsapano watembereredwa pamataka, yomwe yafungula mulomo kuti yatambire m'manja mwako mulopa wa mbale wako. ");
INSERT INTO nyu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Pomwe un'dzalima, matakayo yan'dzakupasa lini phindu, ndipo un'dzakhala wakuthawa-thawa na kufamba-famba padziko”. ");
INSERT INTO nyu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Pamwepo Kaini adauza Mbuya kuti: “Nyathwa yangu ni ikulu kuposa yomwe ningakwanise. ");
INSERT INTO nyu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lero muli kundithotha padziko lino ndipo nidzabzibisa pamaso panu. Nin'dzakhala wakuthawa-thawa na kufamba-famba padziko, ndipo ali-yentse omwe an'dzadigumana an'dzandipha”. ");
INSERT INTO nyu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tsono Mbuya adamutawira kuti: “Bzin'dzakhala lini tenepo. Penu wina an'dzapha Kaini, nin'dzamupasa nyathwa yakufunya kanomwe”. Ndipo Mbuya adaikha cizindikiro kuna Kaini cakudziwisa kuti ali-yentse omwe angamugumanize aleke kumupha. ");
INSERT INTO nyu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tsono Kaini adacoka patsogolo pa Mbuya ndipo adakakhala kudziko la Nodi, kumabvadzuwa kwa Edeni. ");
INSERT INTO nyu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini adafambizana na mkazi wace, mkaziyo adakhala na pathupi, adabala mwana dzina lace Inoki. Tsono Kaini adamanga mzinda omwe adaupa dzina la mwana wace Inoki. ");
INSERT INTO nyu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Kwa Enoki kudabadwa mwana acimucemera Iradi. Iradi adabereka Mehuyaele, Mehuyaele adabereka Metusael ndipo Metusael adabereka Lameki. ");
INSERT INTO nyu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki adalowola akazi awiri. Mkazi wace wakuyamba akhacemeredwa Ada, waciwiri Zila. ");
INSERT INTO nyu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada adabala Jubale, omwe akhali baba wa wale omwe ambakhala mubzikumbi ndipo wakufuwa bzifuwo. ");
INSERT INTO nyu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Dzina la m'bale wace likhali Jubale, omwe adakhala Baba wa wentse wakuimba n'goma na citoliro. ");
INSERT INTO nyu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila adabalambo mwana wacimuna dzina lace Tubalcaim, omwe akhasula m'tundu uliwentse wa bzitsulo bza utale bwa Bronze na wa ferro. Tubalcaim akhana mpfumakazi ikhacemeredwa Naama. ");
INSERT INTO nyu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki adauza akazi wace Ada na Zila kuti: “Nditetekereni akazi wa Lameki, tetekerani fala yangu. Ine ndapha mwamuna m'bodzi thangwe wandipweteka, na mulumbwana m'bodzi thangwe wandiponda. ");
INSERT INTO nyu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Penu Kaini andzaboneresedwa kufunya kanomwe, kuna Lameki kun'dzakhala makumi manomwe na kanomwe”. ");
INSERT INTO nyu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu adafambizana pomwe na mkazi wace, ndipo iye adabala mwana winango wacimuna, omwe adapasa dzina lakuti Seti, thangwe iye adati: “Mulungu wandipasa mwana pankhankha ya Aberi omwe adaphedwa na Kaini”. ");
INSERT INTO nyu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti adaberekambo mwana wacimuna, omwe adapasa dzina lakuti Enosi. Nthawe imweyo wanthu adayamba kukuza dzina la Mbuya acimbapemba. ");
INSERT INTO nyu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Uyu ni m'ndandanda wa bzizukulu bza Adamu. Pomwe Mulungu adalenga munthu, adamukondza mwakulinganira na Mulungu. ");
INSERT INTO nyu_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Adawalenga mwamuna na mkazi, ndipo adawadalisa, aciwapasa dzina lakuti Adamu. ");
INSERT INTO nyu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Pomwe Adamu akhana magole 130, adabereka mwana wacimuna wakulinganilana na iye acifanana na iye adam'pasa dzina lakuti Seti. ");
INSERT INTO nyu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Atabala Seti, Adamu adakhala na moyo magole 800 ndipo adabereka pomwe wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ndipo adakhala na moyo magole 930, acifa. ");
INSERT INTO nyu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Pomwe Seti akhana magole 105, adabereka Enosi. ");
INSERT INTO nyu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Atabereka Enosi, Seti adakhala na moyo magole 807 ndipo adabereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Magole ya moyo wace wentse yakhali 912. Ndipo adafa. ");
INSERT INTO nyu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Pomwe Enosi akhana magole 90, adabereka Kaina. ");
INSERT INTO nyu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Atabereka Kaina, Enosi adakhala na moyo magole 815 ndipo adabereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Magole ya moyo wace wentse yakhali 905. Ndipo adafa. ");
INSERT INTO nyu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Pomwe Kaina akhana magole 70, adabereka Mahalale. ");
INSERT INTO nyu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Atabereka Mahalale, Kaina adakhala na moyo magole 840, ndipo adabereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Magole ya moyo wace wentse yakhali 910. Ndipo adafa. ");
INSERT INTO nyu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Pomwe Mahalale akhana magole 65, adabereka Jaredi. ");
INSERT INTO nyu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Atabereka Jaredi, Mahale adakhala na moyo magole 830 ndipo adabereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Magole ya moyo wace wentse yakhali 895. Ndipo adafa. ");
INSERT INTO nyu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Pomwe Jaredi akhana magole 162, adabereka Enoki. ");
INSERT INTO nyu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Atabereka Enoki, Jaredi adakhala na moyo magole 800 ndipo adabereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Magole ya moyo wace wentse yakhali 962. Ndipo adafa. ");
INSERT INTO nyu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Pomwe Enoki akhana magole 65, adabereka Metusale. ");
INSERT INTO nyu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Atabereka Metusale, Enoki adakhala na moyo magole 300, ndipo adabereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Magole ya moyo wace wentse yakhali 365. ");
INSERT INTO nyu_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoki adafamba na Mulungu, ndipo alibe kuwonedwa, sabwa Mulungu adamtenga. ");
INSERT INTO nyu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Pomwe Matusela akhana magole 187, adabereka Lameki. ");
INSERT INTO nyu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Atabereka Lameki, Matusela adakhala na moyo magole 782, ndipo adabereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Magole ya moyo wace wentse yakhli 969. Ndipo adafa. ");
INSERT INTO nyu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Pomwe Lameki akhana magole 182, adabereka mwana wacimuna. ");
INSERT INTO nyu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Adamupasa dzina lakuti Nowa ndipo adati: “Iye an'dzatithandisa pa basa lathu na pakubonera kwa manja yathu, kucokera pamataka yomwe Mbuya adatemberera”. ");
INSERT INTO nyu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Atabereka Nowa, Lameki adakhala na moyo magole 595 ndipo adabereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Magole ya moyo wace wentse yakhali 777. Ndipo adafa. ");
INSERT INTO nyu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Pomwe akhana magole 500, Nowa adabereka Semu, Hamu na Jafeti. ");
INSERT INTO nyu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Pomwe wanthu adayamba kuwanda padziko la pantsi, adabereka wana wacikazi, ");
INSERT INTO nyu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Wana wacimuna wa Mulungu adawona kuti wana wacikazi wa wanthu akhadadeka, adabzisankhulira wale omwe adawadekera. ");
INSERT INTO nyu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Pamwepo adati: “Thangwe ra kuphonya kwa munthu, Mzimu wangu un'dzakhala lini na iye mwakuyenda-na-kuyenda. Iye an'dzakhala na moyo magole 120 basi”. ");
INSERT INTO nyu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ntsiku zimwezo pakhana wanthu atali-atali padziko la pantsi, napombo m'tsogolomo pomwe wana wa Mulungu adakatenga wana wacikazi wa wanthu, omwe adawabalira wana. Amwewa akhali wanthu wa mphambvu wa kale-kale ndipo wambiri. ");
INSERT INTO nyu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mbuya adawona kuti kuphonya kwa wanthu wa padziko la pantsi kukhapitiliza, ndipo khalidwe la bzakukumbuka bza mitima yawo bzikhambapitiliza kuipa. ");
INSERT INTO nyu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Pamwepo Mbuya adabva ntsisi thangwe adakondza wanthu padziko la pantsi, ndipo bzimwebzi bzidamunesa m'tima. ");
INSERT INTO nyu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Mbuya adati: “Nin'dzacita kuti Wanthu omwe ndidalenga anyembereke padziko la pantsi, wanthu na bzilombo, bzakukwawa na bza kudzulu, thangwe ndabva ntsisi zakuti ndidawakondza”. ");
INSERT INTO nyu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ndipo Nowa adatambira nkhombo pamaso pa Mbuya. ");
INSERT INTO nyu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Mdandanda wakhalidwe la mbumba ya Nowa nguyu: Nowa akhali munthu wakulungama, wakubzipereka ku mabasa ya mbumba ya nthawe yace. Iye akhafamba na Mulungu. ");
INSERT INTO nyu_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowa adabereka wana atatu: Semu, Kamu na Jafeti. ");
INSERT INTO nyu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tsono, dziko likhadadzongeka pamaso pa Mulungu, ndipo likhadadzala na ukhambowa. ");
INSERT INTO nyu_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Pakuwona momwe dziko likhadadzongekera, pakuti wanthu wentse akhadataika pakhalidwe lawo, ");
INSERT INTO nyu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Mulungu adauza Nowa kuti: “Nin'dzamala wanthu wentse, sabwa dziko ladzala na ukambowa thangwe ra iwo. Ine nin'dzawadzonga pabodzi na dziko. ");
INSERT INTO nyu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kondza Arca ya matabwa ya muti Cipreste. Ugawe bzipinda ndipo ucijede na phula kunja na mkati. ");
INSERT INTO nyu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Muutali mwa yene mukhale na mphimo 140. Muufupi mwace mukhale na mphimo 23, ndipo mukutalimpha mwa yene mukhale na mphimo 13 na pakati. ");
INSERT INTO nyu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ukondze ntsodzi ya Arcayo, ndipo usiye buli la mphimo ya macentimetro 50 kucokera pakati pa ntsodzi na mmbali mwace. Uikhe msuo mumbali mwa Arca, ndipo kondza nyumba ya padzauru, inango pansi ina pakati ina padzaulu. ");
INSERT INTO nyu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Thangwe nin'dzagwesa mbvula ya cigumula padziko, kuti idzadzonge bzamoyo bzentse. Bzentse bzomwe bziri padziko bzin'dzafa. ");
INSERT INTO nyu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tsono iwepo nin'dzacita nawe mpangano, ndipo iwe un'dzapita mu Arca pabodzi na wana wako, mkazi wako na akazi wa wana wako. ");
INSERT INTO nyu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Pindza mu Arca bzamoyo bzentse cimuna na cikazi, ubzikoye kuti bzikhale na moyo na iwepo. ");
INSERT INTO nyu_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ntundu uli wentse wa mbalame, ntundu wentse wa bzinyama bzikulu na bzing'ono bzomwe bzinkwawa bzidzabwera cimuna na cikazi kuti bzidzakoyedwe na moyo. ");
INSERT INTO nyu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ndipo ukongobze bzakudya bza mtundu uli-wentse kuti imwe na bzinyamabzo mumbadzadye”. ");
INSERT INTO nyu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nowa adacita bzentse mwakulinganirana na momwe Mulungu adamuuza. ");
INSERT INTO nyu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mbuya adauza Nowa kuti: “Pita mu arca iwe na banja lako lentse, thangwe iwe ndiwe wekha wakulungama omwe ndawona patsogolo pangu pakati pa m'badwe uno. ");
INSERT INTO nyu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tenga bzinyama bzakubvumizidwa bzinomwe bziwiri-bziwiri, cimuna na cikazi ntsono bza mtundu wakulentsedwa bziwiri, cimuna na cikazi. ");
INSERT INTO nyu_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Napombo mbalame zinomwe ziwiri-ziwiri za mtundu uli-wentse, imuna na ikazi, kuti mbeu ikoyeke padziko lapantsi. ");
INSERT INTO nyu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pakatandopita ntsiku zinomwe, nin'dzagwesa mbvula padziko la pantsi ntsiku makumi manai, masikati na usiku, ndipo ndindzamalisa padziko bzamoyo bzentse bzomwe ndidakonza”. ");
INSERT INTO nyu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ndipo Nowa adacita bzense ninga momwe Mulungu adamuuza. ");
INSERT INTO nyu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowa akhana magole (600) pomwe cigumula ca madzi cidafika padziko la pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Thangwe la madzi ya cigumula, Nowa adapita mu arca, iye na wana wace, mkazi wace ndipo na akazi wa wana wace wacimuna. ");
INSERT INTO nyu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Bzinyama bzakubvumizidwa, na bzakusaya kubvumizidwa, mbalame na bzentse bzakukwawa padziko la pantsi, ");
INSERT INTO nyu_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","bzidabwera kuna Nowa, bzicipita mu arca, bziwiri-bziwiri cimuna na cikazi, ninga momwe Mulungu adamuuza. ");
INSERT INTO nyu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Zatapita ntsiku zinomwe, cigumula ca madzi cidafika padziko lentse la pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Pantsiku yomwe Nowa adakwanisa magole (600), mwezi ubodzi na ntsiku khumi na zinomwe (17) ntsiku imweyo bzidafunguka bzimicera bzikulu-bzikulu bza madzi pantsi bziciyamba kufanchukira, ndipo bzimisuwo bza madzi bzidafunguka kudzulu. ");
INSERT INTO nyu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ndipo mbvula idagwa padziko la pantsi ntsiku makumi manai masikati na usiku. ");
INSERT INTO nyu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Pa ntsiku imweyo letu, Nowa na wana wace amuna, Semu, Hamu na Yafeti, na akazi wace ndipo akazi wa wana wace atatu, adapita mu arca. ");
INSERT INTO nyu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Iwo adapita pabodzi na bzinyama malingana mitundu yace, bzinyama bza mthengo bzentse, bzifuwo bzentse, bzilombo bzakukwawa bzentse na bzamoyo bzentse bzomwe bzina maphapidwe, mbalame zentse na bzinango bzentse bzomwe bzimbambuluka. ");
INSERT INTO nyu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bzentse bzamoyo bzidabwera kuna Nowa, bziwiri-bziwiri bzicipita mu arca. ");
INSERT INTO nyu_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Bzamoyo bzomwe bzidapita bzikhali cimuna cibodzi na cikazi cibodzi pa mtundu wa camoyo ciri centse, malingana momwe Mulungu adamuuza Nowa. Ndipo Mbuya adafunga msuwo. ");
INSERT INTO nyu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Cigumula ca madzi cidatenga nsiku makumi manai padziko lapantsi. Madzi yadawanda ndipo yaciyangamisa arca kucoka pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Madziyo yadakhala yaciwanda padziko, ndipo arca ikhadeluka padzulu pa madzi. ");
INSERT INTO nyu_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Madzi yakhapitiriza kudzala padziko ndipo mapiri matali yadamizidwa pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Madzi yadadzala acipitirira ntsonga za mapiri na mphimo zinomwe. ");
INSERT INTO nyu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Bzamoyo bzense bzakukhala padziko la pantsi bzidafa, mbalame, bzifuwo, bzinyama bzamthengo na tulombo tung'ono-tung'ono twa padziko la pantsi, ndipo na wanthu wentse. ");
INSERT INTO nyu_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Centse comwe cikhana moyo cicipuma padziko la pantsi cidafa. ");
INSERT INTO nyu_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Na tenepo bzentse bzamoyo padziko bzidadzongedwa: Wanthu, bzinyama, bzakukwawa padziko na mbalame za kudzulu. Adasala ni Nowa yekha pabodzi na bzentse bzomwe bzikhana iye mu arca. ");
INSERT INTO nyu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ndipo madzi yale yadakhala padziko ntsiku dzana libodzi na ntsiku makumi maxanu (150). ");
INSERT INTO nyu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Pamwepo Mulungu adakumbukira Nowa na bzilombo bzentse bza mthengo na bzifuwo bzomwe bzikhana iye mu arca. Ndipo adatumiza mphepo padziko lapantsi, pamwepo madzi yadayamba kuphwa. ");
INSERT INTO nyu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Bzimicera bza padziko la pantsi na bzimisuwo bza madzi bzakudzulu, bzidafungidwa. Mbvula idakasa. ");
INSERT INTO nyu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Madzi yadayamba kupunguzika pang'ono-pang'ono padziko lapantsi. Patapita ntsiku dzana na makumi maxanu (150), madzi yadapunguzika, ");
INSERT INTO nyu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ndipo pa ntsiku yacikhumi na cinomwe (17), mwezi wacinomwe, arca idatsama pamapiri ya Ararati. ");
INSERT INTO nyu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Madzi yadapitiriza kupunguzika mpaka mwezi wacikhumi, ndipo ntsiku yakuyamba ya mwezi wacikhumiyo, ntsonga za mapiri zidayamba kuwoneka. ");
INSERT INTO nyu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Patapita ntsiku makumi manai, Nowa adafungula pabuli lomwe akhadakonza pa arca. ");
INSERT INTO nyu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ndipo adacosa khungubwe omwe adayenda acimbazunga mudzulu mpaka pantsi kuuma. ");
INSERT INTO nyu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Patsogolo pace adacosa nkhangaiwa kuti ikawone penu madzi yaphwa padziko la pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tsono, nkhangaiwa iribe kuwona mbuto yakuponda thangwe madzi yakhada mpsinkha mataka. Na tenepo idabwerera kuna Nowa mu arca. Iye adatambalalisa boko lace kunja aciiphata ndipo adayibwezera mu arca. ");
INSERT INTO nyu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nowa adadikhira pomwe ntsiku zinomwe, ndipo nkhangaiwa ire adaicosa pomwe. ");
INSERT INTO nyu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kumaulo pomwe nkhangaiwa idabwerera idabweresa tsamba liwisi la oliveira pamulomo pace. Pamwepo Nowa adadziwa kuti madzi yakhadapwa padziko. ");
INSERT INTO nyu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Patsogolo pace Nowa adadikhira pomwe ntsiku zinomwe, ndipo adacosa pomwe nkhangaiwa, tsono ulendo bumwebo iyo iribe kubwerera. ");
INSERT INTO nyu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nowa pomwe adakwanisa magole 601, pantsiku yakuyamba ya mwezi wakuyamba, madzi yadaphweratu padziko la pantsi. Nowa adafungula adacosa ntsodzi ya arca ndipo adawona kuti pantsi pakhadauma. ");
INSERT INTO nyu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Pantsiku makumi mawiri na zinomwe (27) za mwezi waciwiri, pantsi pakhadaumiratu. ");
INSERT INTO nyu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Mulungu adauza Nowa kuti: ");
INSERT INTO nyu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Bula mu arca, iwe na mkazi wako, wana wako na akazi wawo. ");
INSERT INTO nyu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Cita kuti bzinyama bzentse bzomwe bziri na iwe: Mbalame, bzinyama bzikiulu na bzing'ono bzakukwawa pantsi. Ubzicitise kuti bzicoke kuti bzibalalike padziko, bzibalabne ndipo bziwande”. ");
INSERT INTO nyu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Pamwepo Nowa adacoka mu arca na mkazi wace, wana wace na akazi wawo. ");
INSERT INTO nyu_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ndipo bzidacokombo mu arca bzinyama bzikulu-bzikulu na bzing'ono-bzing'no bzomwe bzikwawa pa dziko na mbalame zentse. Bzentse bzomwe nibzamoyo bza padziko bzidacoka mu arca, malingana mtundu wabzene. ");
INSERT INTO nyu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Pamwepo Nowa adakonzera Mbuya guwa ndipo adatenga bzinyama bzakubvumizidwa na mbalame zakubvumizidwa, adapereka ntsembe zakutentha pa guwa. ");
INSERT INTO nyu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mbuya adabva m'nunci wapfungo labwino ndipo adati: “Nin'dzatemberera lini pomwe dziko thangwe la wanthu, sabwa m'tima wace udadzala na bzakuipa kuyambira pa ubwana. Ndipo nin'dzadzonga lini pomwe cipo bza moyo bzentse ninga momwe ndacita ulendo buno. ");
INSERT INTO nyu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Nthawe yentse yomwe dziko la pantsi lin'dzakhala liripo, pan'dzasaika lini mbeu na kubvuna, mphepo na kupsa, cirimo na maindza, masikati na usiku”. ");
INSERT INTO nyu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Mulungu adadalisa Nowa na wana wace, adawauza kuti “Mubale wana azinji muwande ndipo mudzaze dziko la pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bzamoyo bzentse bza padziko la pantsi bzin'dzakhala na mantha patsogolo panu, bzilombo bzamthengo, mbalame zakudzulu, bzinyama bzakukwawa pantsi na ntsomba za m'nyanza. Ibzo bzaperekedwa mmanja mwanu. ");
INSERT INTO nyu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Bzentse bzomwe bzina moyo bzicifamba bzin'dzakhala cakudya canu. Ninga momwe ndidakupasani muliwo, tsapano ndirikukupasani bzinthu bzentse. ");
INSERT INTO nyu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tsono nyama na mulopa wace lekani kudya, pakuti ndiwo moyo wace. ");
INSERT INTO nyu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Wentse ule omwe an'pha munthu ngakhale cinyama, nidzampasa mulandu. Bondzi-na-bondzi nidzampasa mulandu wa moyo wa mbale wace.” ");
INSERT INTO nyu_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Omwe anipha munthu, iyembo aphedwe. Pakuti munthu adalengedwa mucifanizo ca Mulungu.” ");
INSERT INTO nyu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Tsono imwe, mubalane ndipo muwande. Balalikani padziko ndipo mulidzaze”. ");
INSERT INTO nyu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Mulungu adauza Nowa na wana wace kuti: ");
INSERT INTO nyu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Tsapano nicita mpangano langu na imwe ndipo na bzizukulu bzanu bza m'ntsogolo, ");
INSERT INTO nyu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na bzamoyo bzentse bzomwe muli nabzo, mbalame, bzifuwo, bzinyama bza mthengo na bzinango bzentse bzomwe bzidacoka na imwe mu arca napo bzinyama bzentse bza padziko. ");
INSERT INTO nyu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nin'dzacita cipangano cangu na imwe: Nin'dzapha lini pomwe bzamoyo na cigumula ca madzi, pan'dzawoneka lini pomwe nee cigumula ca kupfudza dziko”. ");
INSERT INTO nyu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ndipo Mulungu adati: “Ici ni cizindikiro ca mpangano comwe ndiri kuciikha kwa Ine na imwe na kwa bzamoyo bzentse bzomwe munabzo na kwa bzizukulu bzanu bzentse. ");
INSERT INTO nyu_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nidzaikha uta bwa Dedza mumitambo. Bun'dzakhala cizindikiro ca mpangano kwa Ine na dziko la pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Pomwe Ine nin'dzabweresa mitambo padziko ndipo mwa iyo mucidzawoneka uta bwa Dedza, ");
INSERT INTO nyu_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","pamwepo nin'dzakumbukira mpangano langu lomwe ndidacita na imwe na bzamoyo bza mitundu yentse. Madzi yan'dzakhala lini pomwe cigumula ca kudzapfudza makhalidwe yentse ya bzamoyo. ");
INSERT INTO nyu_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Nthawe zentse zomwe uta bwa Dedza budzawoneka mumitambo, nin'dzanyang'ana kuna ibo ndipo nin'dzakumbukira mpangano wakuyenda na kuyenda kwa Ine na bzamoyo bza mitundu yentse bzomwe bzin'khala padziko”. ");
INSERT INTO nyu_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Pakumalizira, Mulungu adauza Nowa kuti: “Cimweci ni cizindikiro ca mpangano comwe ndaciikha kwa Ine na bzamoyo bzentse bzomwe bziri padziko”. ");
INSERT INTO nyu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Wana wa Nowa omwe adacoka mu arca akhali Semu, Hamu na Yafeti. Hamu ndiye baba wa Kenani. ");
INSERT INTO nyu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Amwewa ndiwo wana atatu wa Nowa. Dziko lentse la pantsi lidadzala kucokera mwa iwo. ");
INSERT INTO nyu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa akhali mulimi, ndiye adayamba kubzala muti wa uva. ");
INSERT INTO nyu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Atamwa vinyu, adaledzera, acikhala pezi mucikumbi mwace. ");
INSERT INTO nyu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, baba wa Kenani, adawona kuti baba wace ali pezi, adakauza abale wace awiri omwe akhali panja. ");
INSERT INTO nyu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Tsono Semu na Yafeti adatenga cakufunika aciciikha m'mapewa ndipo adafamba cambuyo kuti aleke kumuwona pezi baba wawo adakam'funikiza. ");
INSERT INTO nyu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Pomwe Nowa adalamuka, adadziwa bzomwe mwana wace mng'ono adacita, ");
INSERT INTO nyu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ndipo adati: “Atembereredwe Kenani! An'dzakhala nyagrinya wa anyagrinya kwa abale wace”. ");
INSERT INTO nyu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Adalewa pomwe kuti: “Akuzidwe Mbuya, Mulungu wa Semu! Ndipo Kenani adzakhale nyagrinya wace. ");
INSERT INTO nyu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mulungu akuze dziko la Jafeti, ndipo iye akhale mubzikumbi bza Semu. Ndipo Kenani akhale nyagrinya wace”. ");
INSERT INTO nyu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Catamala cigumula ca madzi, Nowa adakhala na moyo magole madzana matatu na makumi maxanu (350). ");
INSERT INTO nyu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Magole ya moyo wace wentse yakhali madzana mapfemba na makumi maxanu (950) ndipo adafa. ");
INSERT INTO nyu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Uyu ni m'ndandanda wa mbumba ya wana wa Nowa, Semu, Hamu na Jafeti. Wana wawo adabadwa catamala cigumula ca madzi. ");
INSERT INTO nyu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Wana wa Jafeti mbawa: Gomeri, Magogi, Madai, Java, Tubala, Meseki na Tirasi. ");
INSERT INTO nyu_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Wana wa Gomeri mbawa: Askenazi, Rifati na Togarima. ");
INSERT INTO nyu_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Wana wa Java mbawa: Elisa, Tarisi, Kitimu na Dodanimu. ");
INSERT INTO nyu_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Kwa Amwewa ndiko kudacokera mbumba yakukhala mumantsuwa, omwe adakakhala m'dziko lace-lace, malingana na cirewedwe cawo, libodzi na libodzi malingana na dzindza la madziko yawo. ");
INSERT INTO nyu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Wana wa Hamu mbawa: Kuce, Mijiraimu, Pute na Kenani. ");
INSERT INTO nyu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Wana wa Kuce mbawa: Seba, Havila, Sabita, Raama na Sabiteka. Ndipo wana wa Raama mbawa: Saba na Dedani. ");
INSERT INTO nyu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuce adabereka Nimirodi, omwe adayamba kukhala wa mphambvu pa dziko. ");
INSERT INTO nyu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Akhali msodzi wa mphambvu pamaso pa Mbuya. Ndipopo bzimbalewedwa kuti: “Wa mphambvu ninga Nimirodi”. ");
INSERT INTO nyu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Pakutoma utongi bwace bukhaphatanidza Babeli, Ereki, Akadi na kuKalne, mudziko la Sineya. ");
INSERT INTO nyu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Iye adacoka kudziko limweli aciyenda ku dziko la Asiriya, komweko adakamanga Ninive, Rehoboti-Ir na Kala, ");
INSERT INTO nyu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Reseni mzinda ukulu omwe uli pakati pa Ninive na Kala. ");
INSERT INTO nyu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mijiraimu adabala aLudita, aAnamu, aLehabu, aNafutu, ");
INSERT INTO nyu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","aPatirusi, aKasilu omwe adabala aFilisti na aKafitorita. ");
INSERT INTO nyu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenani adabereka Sidoni mwana wace wakuyamba na Heti, ");
INSERT INTO nyu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Pomwe na aJebusi, aAmori, aGirigasi, ");
INSERT INTO nyu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","aHivi, aAriki, aSini, ");
INSERT INTO nyu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","aAravadi, aZemari na aHamati. Patsogolo pace madzinza ya aKenani yadabalalika. ");
INSERT INTO nyu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Malire ya aKenani yakhayambira kuSodoma mpaka kuJerali kufikira kuGaza ndipo kucokera kumweko yakhayenda mpaka kuSodomu, Gomora, Adima na Zeboimu kufika ku Lasa. ");
INSERT INTO nyu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Wana wa Hamu mbawa, malingana na dzindza liwo na cirewedwe mumidzi na mumadziko mwawo. ");
INSERT INTO nyu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semu, mkulu mbale nkulu wa Jafeti, adabelekambo wana. Semu akhali kholo la wana wentse wa Eberi. ");
INSERT INTO nyu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wana wa Semu mbawa: Elamu, Asuri, Aripakisadi, Ludi na Aramu. ");
INSERT INTO nyu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wana wa Aramu mbawa: Uzi, Hulu, Jetere na Masi. ");
INSERT INTO nyu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Aripakisadi adabereka Sala, ndipo umweyu adabereka Eberi. ");
INSERT INTO nyu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Kwa Eberi kudaberekedwa wana awiri: M'bodzi adacemeredwa Peleji, thangwe panthawe ya moyo wace, dziko likhadagawika. M'bale wace adacemeredwa Jokotani. ");
INSERT INTO nyu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jokotani adabereka Alimodani, Selefi, Hazara-Maveti, Jera, ");
INSERT INTO nyu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoramu, Uzali, Dikila, ");
INSERT INTO nyu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obala, Abimaele, Saba, ");
INSERT INTO nyu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Havila na Jobabu. Wentsenewa akhali wana wa Jokotani. ");
INSERT INTO nyu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ndipo adakhala kuyambira ku Mesa mpaka ku Sefari mumapiri ya kumabvadzuwa. ");
INSERT INTO nyu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Bzizukulu bza Semu ni ibzi, malingana na madzinza na malewedwe yawo, mumidzi na mumadziko yawo. ");
INSERT INTO nyu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Madzinza ya bzizukulu bza Nowa, malingana na mibadwe na mitundu yawo. Kucokera mwa iwo mbumba idabalalika catamala cigumula. ");
INSERT INTO nyu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Mudziko lentse mukhana cirewedwe cibodzi basi, na kalewerewedwe kabodzi. ");
INSERT INTO nyu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Wanthu watacoka kumabvadzuwa, adakafika kucigowa ca dziko la Sinara acikakhala kumweko. ");
INSERT INTO nyu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Pamwepo adayamba kuuzana kuti: “Mbatiumbe njedwa tizitenthe bwino”. Njedwa adaziphatisira basa la minyala ndipo matope adayaphatisa basa pa mbuto ya argamassa. ");
INSERT INTO nyu_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Patsogolo pace adati: “Bwerani timange mzinda wathu, na gota lakufika kudzulu. Tikacita tenepo tin'dzakhala na mbiri, ndipo tin'dzabalalika lini padziko lapantsi”. ");
INSERT INTO nyu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tsono Mbuya adabuluka kudzawona mzinda na gota lomwe wanthu akhamanga. ");
INSERT INTO nyu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ndipo Mbuya adati: “Iwo ni mbumba ibodzi ndipo ambalewa cirewedwe cibodzi. Ayamba kumanga ici. Tsapanopa palibe comwe cingadzawaletse bzomwe angatale kuti acite. ");
INSERT INTO nyu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Bwerani tibuluke tikasiyanise cirewedwe cawo kuti waleke kubverana m'bodzi na m'bodzi”. ");
INSERT INTO nyu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Tenepoyo Mbuya adabalalisa wanthuwo padziko lentse la pantsi, ndipo iwo adaleka kumanga mzinda ule. ");
INSERT INTO nyu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ndipopo mzindayo adaucemera kuti Babele, thangwe lakuti kumweko Mbuya adasiyanisa cirewedwe ca dziko lentse. Kuyambira pamwepo Mbuya adawabalalisa padziko lentse. ");
INSERT INTO nyu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Iyi ndiyo mibadwo yakucokera kwa Semu: Patapita magole mawiri catamala cigumula, Semu akhana magole 100, adabereka mwana dzina lace Aripakisadi. ");
INSERT INTO nyu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ndipo atabereka Arpakisadi, Semu adakhala na moyo magole 500, acibereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Aripakisadi pomwe adakwanisa magole 35, adabereka Sera. ");
INSERT INTO nyu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Atabereka Sera, Arpakisadi adakhala na moyo magole 403, acibereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sera pomwe adakwanisa magole 30, adabereka Eberi. ");
INSERT INTO nyu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Atabereka Eberi, Sera adakhala na moyo magole 403, acibereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberi pomwe adakwanisa magole 34, adabereka Pelegi. ");
INSERT INTO nyu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Atabereka Pelegi adakhala na moyo magole 430, acibereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi pomwe adakwanisa magole 30, adabereka Reu. ");
INSERT INTO nyu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Atabereka Reu, adakhala na moyo magole 209, acibereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu pomwe adakwanisa magole 32, adabereka Serugi. ");
INSERT INTO nyu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Atabereka Serudi, adakhala na moyo magole 207, acibereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugi pomwe adakwanisa magole 30, adabereka Nahori. ");
INSERT INTO nyu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Atabereka Nahori, adakhala na moyo magole 200, acibereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahori pomwe adakwanisa magole 29, adabereka Tera. ");
INSERT INTO nyu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Atabereka Tera, adakhala na moyo magole 119, acibereka wana anango amuna na akazi. ");
INSERT INTO nyu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera pomwe adakwanisa magole 70, adabereka Abrahamu, Nahori na Harani. ");
INSERT INTO nyu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Uyu ni m'ndandanda wa dzindza la Tera: Tera adabereka Abrahamu, Nahori na Harani. Harani adabereka Loti. ");
INSERT INTO nyu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harani adafera komwe adabadwira kukhacemeredwa Uri, wa kuKaldeya. Pomwe iye adafa, pai wace akhana moyo. ");
INSERT INTO nyu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abrahamu na Nahori adalowola. Abrahamu adalowola Sarai, ndipo Nahori adalowola Milika, mwana wa Harani, omwe akhali baba wa Milika na Isika. ");
INSERT INTO nyu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Tsono Sarai akhalibe wana, thangwe akhabala lini. ");
INSERT INTO nyu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ndipo Tera adatenga mwana wace Abrahamu na mzukulu wace Loti, mwana wa Harani, acitenga pomwe mulowola wace Sarai, mkazi wa mwana wace Abrahamu, ndipo adaguduka pabodzi, kucoka kumzinda wa Uri, wa kuKaldeya, kuyenda kudziko la Kenani. Tsono pomwe adafika kuHarani, adakhala kumweko. ");
INSERT INTO nyu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera adakwanisa magole madzana mawiri na maxanu (205), adafa kuHarani. ");
INSERT INTO nyu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Mbuya adauza Abrahamu kuti: “Coka kudziko lako, pakati pa abale wako na pabanja la baba wako, uyende kudziko lomwe nditi ndikulatize. ");
INSERT INTO nyu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Iwe nin'dzakucita mbumba ikulu ndipo nin'dzakudalisa. Nin'dzacitisa mbiri dzina lako ndipo iwe un'dzakhala daliso. ");
INSERT INTO nyu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nin'dzadalisa omwe an'kudalisa, ndipo nin'dzatemberera omwe an'kutemberera. Kucokera mwa iwe mbumba yentse ya padziko in'dzadalisidwa”. ");
INSERT INTO nyu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abrahamu adaguduka ninga momwe adalewa Mbuya, ndipo Loti adayenda naye. Abrahamu pomwe adacoka ku Harani, akhana magole makumi manomwe na maxanu (75). ");
INSERT INTO nyu_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abrahamu adatenga mkazi wace Sarai na Loti mwana wa mng'ono wace na bzace bzentse bzomwe akhadakwanisa na akapolo omwe akhanawo kuHarani. Adaguduka ulendo bwa kuyenda kuKenani. Iwo adakafika kumweko. ");
INSERT INTO nyu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abrahamu adagwata na m'dzikolo mpaka pambuto ya muti wa More, ku Sekemu. Panthawe imweire aKenani yakhakhala m'dzikomo. ");
INSERT INTO nyu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mbuya adawoneka kuna Abrahamu, acimuuza kuti: “Bzizukulu bzako nin'dzabzipasa dzikoli”. Pamwepo Abrahamu adamanga guwa la ntsembe la kutumbizira Mbuya omwe akhadawoneka kuna iye. ");
INSERT INTO nyu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ndipo adacoka pamwepo acifendera kumapiri ya kumabva-dzuwa ya kuBetele, komwe adamanga cikumbi pakati pa Betele kumadokero na Ai kumabva-dzuwa. Kumweko adamanga guwa la ntsembe la kutumbizira Mbuya, ndipo adacemera dzina la Mbuya. ");
INSERT INTO nyu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Patsogolo pace Abrahamu adaguduka, aciyenda kucipande ca kuNegebu. ");
INSERT INTO nyu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Mudziko lire mukhana njala, ndipo Abrahamu adayenda ku Ijipito kuti akakhale ntsiku zing'ono-ng'ono, thangwe njala ikhadakula. ");
INSERT INTO nyu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Pomwe akhafika ku Ijipito, adauza mkazi wace Sarai kuti: “Nin'dziwa cadidi kuti udadeka. ");
INSERT INTO nyu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tsono aIjipito angakakuwona an'kalewa kuti: ‘Umweyu ni mkazi wace,’ ndipo an'kandipha, acikasiya iwe na moyo. ");
INSERT INTO nyu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ukawauze kuti ni nkhosve yangu, kucitira kuti akandiphate bwino mwa lifoi la iwe ndipo muyo wangu ukakoyeke kucokera mwa iwe”. ");
INSERT INTO nyu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Pomwe Abrahamu adafika muIjipito, aIjipito adawona kuti Sara akhali mkazi wakudeka. ");
INSERT INTO nyu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Pomwe adamuwona Akulu-akulu wa nyumba ya Falau, adamutumbiza patsogolo pa Falau ndipo iye adatengedwa aciyenda kunyumba kwa Falau. ");
INSERT INTO nyu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Falau adamphata bwino Abrahamu thangwe la iye, ndipo Abrahamu adapasidwa mabira na ng'ombe, mabulu yacimuna na yacikazi, akapolo wacimuna na wacikazi, na ngamira. ");
INSERT INTO nyu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tsono Mbuya adapasa nyathwa kuna Falau na kuna akulu-akulu wa mnyumba yace na matenda yakugoswa, thangwe ra Sarai, mkazi wa Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pamwepo Falau adacemera Abrahamu, acim'bvundza kuti: “N'ciyani wacitaci kuna ine? Thangwe ranyi ulibe kundiuza kuti umweyu ni mkazi wako? ");
INSERT INTO nyu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Thangwe ranyi walewa kuti umweyu ni mpfumakazi yako, ndipopo ine ndikhadam'tenga kuti akhale mkazi wangu. Mkazi wako nguyo. Tenga ucoke!” ");
INSERT INTO nyu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Patsogolo pace Falau adauza akapolo wace kuti ampase bzakufunika paulendo, Abrahamu aguduke na mkazi wace na bzentse bzomwe akhanabzo. ");
INSERT INTO nyu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abrahamu adacoka na mkazi wace kuyenda kuNegebu na bzentse bzomwe akhanabzo, ndipo Loti adayenda naye pabodzi. ");
INSERT INTO nyu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abrahamu akhadadala kwene-kwene, pa bzifuwo ngakhale pa parata na oro. ");
INSERT INTO nyu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Iye adaguduka kuNegebu aciyenda kucipande ca kuBetele, acimbafamba mbuto na mbuto, mpaka adakafika pa mbuto ya pakati pa Betele na Ai komwe akhadamanga bzikumbi kalekale, ");
INSERT INTO nyu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ndipo komwe pa kuyambilira akhadamanga guwa. Pamwepo Abrahamu adacemera dzina la Mbuya. ");
INSERT INTO nyu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loti omwe akhali pabodzi na Abrahamu, akhana bzifuwo na bzikumbi bzacembo. ");
INSERT INTO nyu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ndipo bzikhakwanisika lini kuti awiriwo akhale cimbande cibodzi, thangwe ankhana bzinthu bzizinji mwa kuti mbuto yomwe akhali ikhakwana lini. ");
INSERT INTO nyu_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Na tenepo padawoneka kupolowana kwa amakabusa wa Abrahamu na wa Loti. Nthawe imweyo, aKenani na aFerezi akhakhala mdzikomo. ");
INSERT INTO nyu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Pamwepo Abrahamu adauza Loti kuti: “Paleke kuwoneka kupokana kwa ine na iwe, ayai kwa amakabusa wako na wangu. Thangwe mbubale bwathu caibo. ");
INSERT INTO nyu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kodi liri lini patsogolo pako dziko lentse? Mbatiyende timwazane. Penu iwe uniyenda ku mbali ya kumadzere ine niniyenda ku mbali ya kumadidi. Penu uniyenda ya kumadidi ine niniyenda ya kumadzere”. ");
INSERT INTO nyu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Pamwepo Loti adanyang'ana adawona cigowa ca mkulo wa Jolodani, centse na nyontho wabwino mpaka kuZowari, cikhali ninga munda wa Mbuya, ninga dziko la Ijipito. Bzimwebzi bzidacitika Mbuya akanati kudzonga Sodoma na Gomora. ");
INSERT INTO nyu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Loti adasankhula cigowa centse ca Jolodani, ndipo adayenda kumphimpha ya kumabva-dzuwa. Tepoyo awiriwo adamwazana. ");
INSERT INTO nyu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abrahamu adakhala mdziko la Kenani, tsono Loti adacinja bzikhumbi bzace acikakhala pambuto iri pafupi na Sodoma, pakati pa mizinda ya cigowa. ");
INSERT INTO nyu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tsono, wanthu wa muSodoma akhali wakuipa na wakuphonyera Mbuya. ");
INSERT INTO nyu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Pomwe Loti adamwazana na Abrahamu, Mbuya adauza Abrahamu kuti: “Kuyambira pomwe uli, nyang'ana kucipande ca kudzaulu, kunyantsi, kumabva-dzuwa na kumadokero. ");
INSERT INTO nyu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Dziko lentse lomwe uli kuwonali, nin'dzapasa iwe pabodzi na bzizukulu bzako kwa kuyenda na kuyenda. ");
INSERT INTO nyu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nin'dzacitisa bzizukulu bzako kuti bziwande ninga pfumbi la pantsi. Bzicikwanisika kulewenga pfumbi la pantsi, bzingadzacitikembo kulewenga bzizukulu bzako. ");
INSERT INTO nyu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Famba mudzikoli kuyambira kudzulu kuyenda kunyantsi, kumphimpha iyi na ina, thangwe Ine nin'dzapasa iwe”. ");
INSERT INTO nyu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ndipo Abrahamu adafuluka, acikakhala pafupi na miti ya Mamre kuHebroni, komwe adamangira Mbuya guwa la ntsembe. ");
INSERT INTO nyu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Pa magole yomwe yare, Anirafere, mambo wa kuSinari, Ariyoki, mambo wa kuElasari, Kedorilaomeri, mambo wa kuElamu na Tidali, mambo wa kuGoimi, ");
INSERT INTO nyu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","adayenda kunkhondo ya kumenya na Bera, mambo wa kuSodoma, na Birisa, mambo wa kuGomora, na Sinabe mambo wa kuAdima, na Semeberi, mambo wa kuZeboimi na mambo wa kuBela, komwe ni Zowari. ");
INSERT INTO nyu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wentsenewa adatsonkhanisa acikunda wawo mucigowa ca Sidimi, komwe kuna nyanza ya Munyu. ");
INSERT INTO nyu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Mumagole khumi na mawiri akhatumikira Kedorilaomeri, tsono pa gole khumi na lacitatu adam'sandulikira. ");
INSERT INTO nyu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Pa gole khumi na lacinai, Kedorilaomere na azimambo omwe iye akhadaphatana nawo adakunda aRefaimu kuAsiteroti-Karanaimu, aZuzi kuHamu, na aEmi kuSave-Kiriyataimi, ");
INSERT INTO nyu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na aHori kuyambira kumapiri ya Seiri, mpaka kuEli-Parani, pafupi na cidambo. ");
INSERT INTO nyu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Patsogolo pace adabwerera ndipo adayenda kuEni-Misipati, komwe ni Kadesi, ndipo adapsokonyola dziko lentse la aAmaleki na la aAmori omwe akhakhala kuHazazomi-Tamari. ");
INSERT INTO nyu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Pamwepo azimambo wa kuSodoma, Gomora, Adima, Zeboimi na Bela omwe ni Zowari, adayenda acikakhala mumbuto zakumenyanirana mucigowa ca Sidimi, ");
INSERT INTO nyu_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","na Kedorilaomeri mambo wa kuElaa, na Tidali, mambo wa kuGoimi, na Aniraferi, mambo wa kuSineari, na Ariyoki, mambo wa kuElasari. Akhali azimambo anai akham'enyana na azimambo axanu. ");
INSERT INTO nyu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Tsono, cigowa ca kuSidimi cikhadadzala na micera ya matope ndipo pomwe azimambo wa kuSodoma na kuGomora adathawa, anango wa iwo adagwa mumicera ndipo winango adapulumikira mumapiri. ");
INSERT INTO nyu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Wakukunda adatenga bzombo bzentse bza muSodoma na muGomora na phoso lawo lentse ndipo adaguduka. ");
INSERT INTO nyu_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Adatengambo Loti, m'zukulu wa Abrahamu, pabodzi na bzombo bzomwe iye akhanabzo, nakuti akhakhala muSodoma. ");
INSERT INTO nyu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tsono m'bodzi omwe adapulumuka adabwera kuna Abrahamu acimuuza bzentse, akhali muHebri omwe akhakhala pafupi na miti ya Manire, wa dzindza la aAmori. Manire na abale wace Esikolo na Aneri, akhali wakubverana na Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Pomwe Abrahamu adabva kuti m'bale wace waphatiwa ninga nyam'kawoko, adatsonkhanisa amuna madzana matatu na khumi na asere wakupfundzisidwa bza nkhondo, wakubadwa mumui mwace ndipo adacoka acitewera anyamadulanthaka mpaka ku Dani. ");
INSERT INTO nyu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Adawamenya nthgawe ya usiku mu magulu, na tenepoyo adawakunda, aciwatewera mpaka ku Hoba, kudzaulu kwa Damasiko, ");
INSERT INTO nyu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","pamwepo adawatengera bzombo bzentse acibwerera nabzo pomwe ndipombo na Loti m'bale wace na bzace bzentse, akazi na anyam'kawoko anango. ");
INSERT INTO nyu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abrahamu atabwerera kucokera pakukunda Kedorilaomere na azimambo omwe akhadaphatana na iye, mambo wa kuSodoma adayenda kukagumana naye kucigowa ca Save, comwe cimbacemeredwa cigowa ca Mambo. ");
INSERT INTO nyu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Pamwepo Melekizedeki, mambo wa kuSalemi ndipo baba wa ntsembe wa Mulungu Wakudzulu-dzulu, adabweresa pau na vinyu ");
INSERT INTO nyu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ndipo adadalisa Abrahamu, aciti: “Akhale wa kusimbidwa Abrahamu mwa Mulungu Wakudzulu-dzulu, Mulengi wa kudzulu na dziko la pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ndipo akhale wa kusimbiwe Mulungu akudzulu-dzulu, womwe adapereka anyamaduranthaka wako m'manja mwako”. Ndipo Abrahamu adapereka cakhumi ca bzentse. ");
INSERT INTO nyu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tsono mambo wa kuSodoma adauza Abrahamu kuti: “Ndipase wanthu ndipo bzinthu bzisale kuna iwe”. ");
INSERT INTO nyu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ndipo Abrahamu adatawira, aciti: “Ndiri kupicira pamaso pa Mbuya, Mulungu wakudzulu-dzulu, omwe ni mwenekeciro wa kudzulu na dziko la pantsi, ");
INSERT INTO nyu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ndinilumbira kuti nin'dzatenga lini bzentse bzomwe ni bzako, ngakhale usalu, ngakhale cingwe xango, kuti udzaleke kulewa kuti: ‘Ine ndidadaza Abrahamu.’ ");
INSERT INTO nyu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Palibe comwe nin'funa, kupambula bzomwe alumbwana adadya na cipande comwe ni ca Anere, Esikolo na Manire, omwe adandiperekeza. Iwo atambire cipande cawo”. ");
INSERT INTO nyu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bzatapita bzimwebzi, Mbuya adalewa kuna Abrahamu m'maso-mphenya, adamuuza kuti: “Leka mantha Abrahamu, Ine ndine m'khochereri wako. Mabaibai yako yan'dzakhala makulu”. ");
INSERT INTO nyu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Tsono Abrahamu adabvundza kuti: “Mbuya Mulungu, mundipasanyi, pakuti ine ndiribe wana ndipo wakupita pambuto yangu ni Eliezere wa kuDamasiko? ");
INSERT INTO nyu_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ndipo adapitiriza kulewa, adati: Imwe mulibe kundipasa mwana na m'bodziyo, na tenepo m'bodzi wa akapolo wa nyumba yangu ndiye an'dzakhala pa mbuto yangu”. ");
INSERT INTO nyu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Pamwepo Mbuya adamutawira aciti: “Wakudzakhala pa mbuto yako ndiye lini umweyu. Mwana wa kubelekewa na iwe caiye ndiye an'dzakhala pa mbuto yako”. ");
INSERT INTO nyu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Pamwepo adam'cosa panja acimuuza kuti: “Nyang'ana kudzulu ndipo lewenga nyenyezi penu un'kwanisa. Ndipo adapitiririza adati: Tenepa ndibzo bzin'dzacita bzizukulu bzako”. ");
INSERT INTO nyu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abrahamu adakhulupirira Mbuya, ndipo bzimwebzi bzidacitisa kuti ngwakulungama. ");
INSERT INTO nyu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Adamuuza pomwe kuti: “Ine ndine Mbuya, omwe ndidakucosa kuUri ku aKalidi, kuti ndikupase dziko lino likhale lako”. ");
INSERT INTO nyu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abrahamu adabvundza kuti: “Nandi Mbuya Mulungu, nin'dzadziwa tani kuti nin'dzalipasidwa?” ");
INSERT INTO nyu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mbuya adatawira kuti: “Ndibweresere kamwana ka ng'ombe, mbuzi ibodzi na bira, bzentse bza magole matatu, ndipombo mwana wa njiwa m'bodzi na mwana wa nkhangaiwa m'bodzi”. ");
INSERT INTO nyu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abrahamu adabweresa nyama zentsenezo, adazigwata pakati. Ndipo adazilonga mwa kunyanisana. Tsono mbalame alibe kuzigwata. ");
INSERT INTO nyu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Nyenga-nyenga zidayamba kumbambutha pa nyama, tsono Abrahamu adazithamangisa. ");
INSERT INTO nyu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Pomwe dzuwa likhamira, Abrahamu adaphatidwa na tulo ninga adafa, ndipo padacita mdima kwene-kwene, wakupasa mantha. ");
INSERT INTO nyu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Pamwepo Mbuya adamuuza kuti: “Dziwa kuti bzizukulu bzako bzin'dzakhala anyakudza mudziko lomwe ndawo lini, ndipo bzin'dzakhala pomwe anyagrinya bzicidzaboneresedwa kwa magole madzana manai. ");
INSERT INTO nyu_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tsono Ine nin'dzapasa nyanthwa dziko lomwe an'dzatumikira ninga anyagrinya ndipo bzatamala bzentsenebzi, an'dzacoka na cuma cizinji. ");
INSERT INTO nyu_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ndipo iwe un'dzayenda mwa ufulu kuna makolo yako. Un'dzakaikhidwa watakalambilatu. ");
INSERT INTO nyu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Pa m'badwo wacinai bzizukulu bzako bzin'dzabwerera pomwe kuno, thangwe kuipa kwa aAmori kukanati kufika pakukwanira”. ");
INSERT INTO nyu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Pomwe dzuwa lidamira, kucita mdima, ndipo padawoneka fogareiro ya utsi na mtsatso ukhagaka, udapita na pakati pa nyama zakugwatidwa zire. ");
INSERT INTO nyu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ntsiku imweyo Mbuya adacita cipangano na Abrahamu, aciti: ndapasa bzizukulu bzako dzikoli, kuyambira kumkulo wa kuIjipito mpaka kumkulo ukulu Eufurate. ");
INSERT INTO nyu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Dziko la aKeni, la aKenezi, la aKadimoni, ");
INSERT INTO nyu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","la aHiti, la aFerezi, la aRefaini, ");
INSERT INTO nyu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","la aAmori, la aKenani, la aJirigazi na la aJebuzi. ");
INSERT INTO nyu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Tsono, Sarai mkazi wa Abrahamu, alibe kum'balira mwana. Ndipo akhana kapolo wacikazi wa kuIjipito, akhacemeredwa Hagari, ");
INSERT INTO nyu_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai adauza Abrahamu kuti: “Pakuti Mbuya adandiletsa kubala wana, tenga kapolo wangu, pinango ine ningakhale na mbumba kucokera kuna iye?” Abrahamu adabvuma mafala ya Sarai. ");
INSERT INTO nyu_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Pomwe bzidacitika bzimwebzi, yakhadakwana magole khumi yakuti mamuna wace Abrahamu akhakhala muKanani. Ndiyo nthawe yomwe Sarai mkazi wace, adam' pasa kapolo wace wa kuIjipito Hagari. ");
INSERT INTO nyu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Iye adatenga Hagari acikhala naye ndipo adatenga pathupi. Pomwe adawona kuti ana pathupi, adayamba kunyoza Sarai. ");
INSERT INTO nyu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Pamwepo Sarai adauza Abrahamu kuti: “Kunyozedwa komwe ndiri kucitidwa ni thangwe la iwepo ndiwepo. Ndidapereka kapolo wangu m'manja mwako, ndipo tsapano pomwe adziwa kuti ana pathupi, alikundinyoza. Mbuya akhale mutongi wa ine na iwe”. ");
INSERT INTO nyu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abrahamu adatawira Sara kuti: “Kapolo wako ali mmanja mwako. Cita bzomwe ungafune kuna naye”. Na tenepo, Sarai adayamba kum'boneresa Hagari, mpaka kuthawa. ");
INSERT INTO nyu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ndipo anju wa Mbuya adagumana Hagari pamcera mucidambo, panjira ya kuyenda kuSuri. ");
INSERT INTO nyu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ndipo idam'bvundza kuti: “Hagari, kapolo wa Sarai, kodi uli kucoka kuponi? Uli kuyenda kuponi?” Iye adatawira kuti: “Ndiri kuthawa Sarai”. ");
INSERT INTO nyu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Pamwepo anju wa Mbuya adamuuza kuti: “Bwerera kuna Sara ndipo ukabzicepese kuna iye”. ");
INSERT INTO nyu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Anju ya Mbuya idamuuza pomwe kuti: “Nin'dzawandisa bzizukulu bzako, mwakuti palibe omwe an'dzakwanisa kulewenga”. ");
INSERT INTO nyu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Pakupitiriza na mafala, anju wa Mbuya adati: “Iwe unapathupi ndipo un'dzakhala na mwana wacimuna, omwe un'dzapasa dzina lakuti Jumaere, thangwe Mbuya wabva kubonera kwako. ");
INSERT INTO nyu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Iye an'dzakhala ninga bulu wamthengo, boko lace lin'dzawengana na wetse ndipo manja ya wentse yan'dzawengana naye. An'dzakhala acimbawengana na abale wace wentse”. ");
INSERT INTO nyu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Tsono Hagari adapasa dzina Mulungu, omwe adalewa naye, lakuti: “Imwe ndimwe Mulungu wakundiwona,” nakuti adati: “Pano ndamuwona iye omwe ambandinyang'ana”. ");
INSERT INTO nyu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ni thangwe race, mcera wa pakati pa Kadesi na Beredi ule, wanthu wambacemera kuti Mcera wa Wamoyo wakundiwona. ");
INSERT INTO nyu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Na tenepo Hagari adam'balira Abrahamu mwana wa mwamuna, acimucemera dzina lakuti Jumaere. ");
INSERT INTO nyu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Panthawe imweyo, Abrahamu akhadafika magole makumi masere na matanthatu. ");
INSERT INTO nyu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Pomwe Abrahamu akhana magole makumi mapfemba na mapfemba (99), Mulungu adamuwonekera acimuuza kuti: “Ine ndine Mulungu wa mphambvu zentse. Na tenepo, umbakhale pamaso pangu, ndipo umbakhale wakucena. ");
INSERT INTO nyu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ndin'dzacita nawe phangano la cipiciro, ndin'dzakupasa bzizukulu bzizinji”. ");
INSERT INTO nyu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Pamwepo Abrahamu adagodama acitsulima, ndipo Mulungu adati: ");
INSERT INTO nyu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Phangano lomwe ndin'dzacita na iwe ndiri: Ndin'kulonjeza kuti un'dzakhala kholo la wanthu wa madzindza mazinji. ");
INSERT INTO nyu_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Dzina lako lin'dzacemerewa lini pomwe Abrahamu, tsono kuti Abrahamu. Limweri ndiro dzina lako, thangwe ndiri kukusandusa kholo la wanthu wa madzindza mazinji. ");
INSERT INTO nyu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ndin'dzakupasa bzizukulu bzizinji, pomwe bzinango mwa ibzo bzin'dzakhala azimambo. Un'dzakhala na bzizukulu bzizinji na tenepo bzin'dzakhala madzindza makulu. ");
INSERT INTO nyu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Phangano languli ndin'dzaliikha pakati pa ine na iwe na bzizukulu bzako mtsogolo muno, pomwe lin'dzakhala phangano lakusaya kumala. Ine ndin'dzakhala Mulungu wako na Mulungu wa bzizukulu bzako. ");
INSERT INTO nyu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Dziko lomwe uli kukhala ninga mulendo lino, ndin'dzakupasa iwe na bzizukulu bzako. Dziko lentse la Kenani lin'dzakhala la bzizukulu bzako kuyenda na kuyenda, ndipo ine Ndin'dzakhala Mulungu wawo”. ");
INSERT INTO nyu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Mulungu adauza pomwe Abrahamu kuti: “Iwembo un'funika kuti utawire kukoya phangano langu, pabodzi na bzizukulu bzako bzamtsogolo. ");
INSERT INTO nyu_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Iwe pabodzi na bzizukulu bzako, mun'funika kukoya phangano iri, lakuti mwana wacimuna ali-yentse pakati pa imwe ambagwatidwe. ");
INSERT INTO nyu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kutomera tsapano lino mumbagwatidwe. Cimweci cin'dzakhala cizindikiro ca phangano pakati pa ine na imwe. ");
INSERT INTO nyu_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Mwana wacimuna ali-yentse, angakwanisa ntsiku zisere, mumbagwate. Mumbagwate mwamuna ali-yentse pamibadwo yanu yentse, wakubadwa mmwemo ayai nyankhoda, omwe ni dzindza lini lanu, mudacita kugula kuna mulendo. ");
INSERT INTO nyu_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ncadidi, ali-yentse mbagwatidwe, cimweci cin'dzakhala cizindikiro pamathupi yanu, cakuwonesa kuti phangano langu na imwe ndakuyenda na kuyenda. ");
INSERT INTO nyu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Munthu wacimuna omwe an'dzagwatiwa lini, an'dzacosewa pakati pa wanthu wa dzindza lace, thangwe alibe kukoya phangano langu”. ");
INSERT INTO nyu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Patsogolo pace, Mulungu adauza Abrahamu kuti: “Mkazi wako un'dzamucemera lini pomwe kuti Sarai. Kuyambira lero, un'dzam'cemera dzina lakuti Sara. ");
INSERT INTO nyu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Thangwe ine ndin'dzam'dalisa, acidzakubalira mwana wa mwamuna. Ndin'dzam'dalisa pomwe acidzakhala mai wa madzindza ya wanthu. Pakati pa bzizukulu bzace pan'dzacoka azimambo”. ");
INSERT INTO nyu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Pamwepo Abrahamu adagodama pantsi. Adayamba kuseka, aciti: “Nandi, mwamuna wakuti ana dzana la magole, angabereke pomwe? Nayembo Sara, omwe ana magole makumi mapfemba, angabale pomwe?” ");
INSERT INTO nyu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Na tenepo, Abrahamu adauza Mulungu kuti: “Ndiri kukumbirani kuti mundondidalisira Jumaereyu”. ");
INSERT INTO nyu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tsono Mulungu adati: “Ayai, na mkazi wako umweyu Sara an'dzakubalira mwana wa mwamuna omwe un'dzam'pasa dzina lakuti Isaki. Ine ndin'dzacita phangano na iye ndipombo na bzizukulu bzace, ndipo phanganolo lin'dzakhala lakuyenda na kuyenda. ");
INSERT INTO nyu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Tsono pakulewa bza Jumaere, ndin'dzam'dalisa, ndin'dzam'pasa pomwe wana azinji pabodzi na bzizukulu. An'dzakhala baba wa azimambo khumi na awiri, ndipo bzizukulu bzace bzin'dzakhala dzindza likulu. ");
INSERT INTO nyu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tsono ndin'dzacita phangano na mwana wako Isaki, omwe an'dzabadwa na Sara panyengo ninga imweino, pagole la mangwana”. ");
INSERT INTO nyu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Pomwe Mulungu adamala kulewa, adam'siya pamwepo Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ntsiku imweyo, Abrahamu adakumbukira bzomwe Mulungu akhadamuuza, ndipo adatenga mwana wace Jumaere pabodzi na anyankhoda wentse omwe mbakubalidwa mmwemo na wakucita kugula, tingalewe kuti amuna wentse m'banja mwace, aciwagwata khanda la kumaso. ");
INSERT INTO nyu_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahamu pomwe adagwatidwa, akhadakwanisa magole makumi mapfemba na mapfemba. ");
INSERT INTO nyu_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Mwana wace Jumaere, pomwe adagwatidwa, akhana magole khumi na matatu (13). ");
INSERT INTO nyu_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Pantsiku imweyo, Abrahamu na mwana wace Jumaere adagwatidwa, ");
INSERT INTO nyu_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","pabodzi na wanthu wacimuna wentse, wakubalidwa m'banja mwace ndipombo anango omwe akhali wakugula kwa alendo, wentsenewo adagwatidwa pabodzi na iye. ");
INSERT INTO nyu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mulungu adawonekera kwa Abrahamu mumiti ikulu ya Mamure. Pomwe akhadakhala pamsuwo pa cikumbi cace, nthawe ya masikati kukhatentha, ");
INSERT INTO nyu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","mwadzidzidzi adandowona wanthu atatu akhadaima na patali. Pomwe adandowawona, adanyamuka mwakamkulumize kukawatambira. Adagodama acitsulima, ");
INSERT INTO nyu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","aciti: “Mbuya wangu, penu ndawona nkhombo pamaso pa imwe, ndiri kukukumbirani kuti muleke kupitirira pamui pa kapolo wanu. ");
INSERT INTO nyu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Nditenge madzi mutsuke ndzayo. Mungadabakapuma patsinde la muti pano. ");
INSERT INTO nyu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ine tsapano ndikatenge cakudya, kuti mungadya muwone mphambvu zakupitirira na ulendo bwanu. Mwabwera panyumba pangu pano, na terepo ndin'funika kukutumikirani”. Wanthu wale adatawira kuti: “Mpsabwino, ucite ninga momwe waleweramo”. ");
INSERT INTO nyu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abrahamu adapita mwakamkulumize mucikumbi, aciuza Sara kuti: “Utenge mwakamkulumize ntsengwa zitatu za ufa bwabwino, ubumunye ukonze pau”. ");
INSERT INTO nyu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Pamwepo Abrahamu adathamanga, acikatenga mphulu yakunenepa, acipereka kwa kapolo wace kuti akondze mwakamkulumize. ");
INSERT INTO nyu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ndipo adatenga mkaka wakukhota na wakusaya kukhota na nyama yakukondza kale ire aciwapasa bzentsenebzo. Pomwe wanthuwo akhadya, patsinde la muti pale, iye adakhala pambali. ");
INSERT INTO nyu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Tsono wanthu wale adabvundza Abrahamu kuti: “Kodi mkazi wako Sara, ali kuponi?” Abrahamu adatawira kuti: “Ali mucikumbimu”. ");
INSERT INTO nyu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","M'bodzi wa iwo adati: “Ndiri kukupicira kuti pakapita minyezi mipfemba ndin'dzabwera pomwe, ndipo mkazi wako an'dzakhala ana mwana wa mwamuna”. Sara akhandobzibva ali kuseri kwa msuwo wa cikumbi. ");
INSERT INTO nyu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahamu pabodzi na Sara wakhadakalamba, ndipo nthawe imweyo Sara akhadaleka kale kusamba. ");
INSERT INTO nyu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Na terepo Sara adandoseka, acimbati, “Ha, ninga momwe ndakalambire ine muno, pomwembo mwamuna wangu ngwakukalambiratu, kodi bzingakwanisike kuti ningafatse na mwamuna wangu?” ");
INSERT INTO nyu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Mbuya adabvundza Abrahamu kuti: “Thangwe ranyi Sara akhaseka acimbalewa kuti: ‘Ine ninga momwe ndakalambiramu, bzingacitike tani kuti ndikhale na mwana?’ ");
INSERT INTO nyu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kodi ciripo cinango cakuti cingatazike na Mbuya? Tsono panthawe yace, ndin'dzacita cadidi bzomwe ndapicirabzi, ndipo Sara an'dzakhala na mwana wacimuna”. ");
INSERT INTO nyu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Pamwepo Sara adalamba, thangwe ra mantha, adati: “Ndiribe kuseka”. Tsono iye adati: “Cadidi, udaseka”. ");
INSERT INTO nyu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ndipo wanthu wale adacoka, acikafika pambuto pomwe pakhawonekera Sodoma. Abrahamu adayenda nawo pabodzi, aciwalatiza njira. ");
INSERT INTO nyu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ndipo Mbuya adalewa mwa iye yekha kuti: “Abrahamuyu ndin'm'bisira lini comwe ndiri kufuna kucita. ");
INSERT INTO nyu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Bzizukulu bzace bzin'dzakhala dzindza likulu la mphambvu. Ndipo madzindza yentse ya pantsi yan'dzadalisidwa thangwe ra iye. ");
INSERT INTO nyu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ndam'sankhula umweyu kuti alamulire wana wace na mabanja yace ya kutsogolo kuno kuti ambadzandibvere, pakuteweza Mtemo na kulunguma. Na tenepo ndin'dzacita bzentse bzomwe ndidam'picira”. ");
INSERT INTO nyu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Tsono Mbuya adauza Abrahamu kuti: “Pana bzakuphonyeka bzakugosva na kufuna kwa Sodoma na Gomora. Bzakuipa bzawo n'bziri kuwanda kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Na tenepo, ndiri kuyenda kumweko ndikawone penu kuphonya komwe ndabvako n'cadidi. Penu ni terepoyo lini, ndin'dzadziwa”. ");
INSERT INTO nyu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Wanthu wale adacoka, aciyenda kuSodoma, tsono Abrahamu adasala akhali patsogolo pa Mbuya. ");
INSERT INTO nyu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Pamwepo Abrahamu adafendera kuna Mulungu, acim'bvundza kuti: “Nandi imwe mun'dzadzonga wanthu wakuteweza Mtemo wanu pabodzi na wakuphonya? ");
INSERT INTO nyu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kodi pacikhala na wanthu wakulungama makumi maxanu mumzindamo, mungadzonge basi mzinda wentse? Kodi mungadzauleke lini kuti mukoye wanthu makumi maxanu wakulungama wale? ");
INSERT INTO nyu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Cadidi, mun'dzadzonga lini wanthu wakulungama pabodzi na wakuphonya. Bzimwebzi mungabzicite lini. Mungadabzicita bzimwebzi, mpsino wanthu wakulungama acimbapasiwa cirango pabodzi na wakuphonya. Kutali-tali caiko, imwe mungacite lini bzimwebzi! Kodi Mtongi wa dziko lentse, angasaye cirungamo?” ");
INSERT INTO nyu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mbuya adatawira kuti: “Ndiciwona wanthu makumi maxanu wakulungama muSodoma, ndin'dzaudzonga lini mzinda wentsenewo, thangwe ra wanthu wamwewo”. ");
INSERT INTO nyu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrahamu adalewa pomwe aciti: “Ndaphata minyendo, ndalimba m'tima pakulewa-lewa na imwe terepayu, Mbuya. Ine-pano ndine lini cinthu kuna imwe. ");
INSERT INTO nyu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kodi pa wanthu makumi maxanuwa wacipereweza waxanu, mungacite tani? Mungaudzonge mzindawo na thangwe rakuti apereweza axanu?” Mulungu adatawira aciti: “Ndikagumana wanthu wakulungama makumi manai na axanu, ndingadzaudzonge lini mzindawo”. ");
INSERT INTO nyu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahamu adabvundza pomwe kuti: “Kodi paciwoneka wakulungama makumi manai yokha?” Mulungu adatawira kuti: “Ndingagumana wanthu makumi manai, ndingaudzonge lini”. ");
INSERT INTO nyu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Pamwepo Abrahamu adati: “Ndaphata minyendo yanu, lekani kuwawidwa m'tima, Mbuya, tsapano lino ndin'bvundza pomwe. Kodi mungagumana wanthu wakulungama makumi matatu (30)?” Mbuya adati: “Ndingagumana wanthu makumi matatu, ndingaudzonge lini”. ");
INSERT INTO nyu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Pamwepo Abrahamu adati: “Ndalimba m'tima kuna imwe, mundilekerere kulimba m'tima terepayu pakulewa-lewa na imwe, Mbuya. Kodi mucigumana wakulungama makumi mawiri?” Mbuya adati: “Ndingagumana wanthu makumi mawiri wakulungama, ndingaudzonge lini mzindawo”. ");
INSERT INTO nyu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abrahamu adati: “Ndaphata minyendo, lekani kukalipa nande Mbuya, tsono ndirewe kabodzi kokha. Kodi mucigumana khumi wokha?” Pamwepombo Mbuya adati: “Ndicigumana wakulungama khumi, ndingadzaudzonge lini mzindawo”. ");
INSERT INTO nyu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Pomwe Mbuya adamala kulewa na Abrahamu, adacoka pam'pale, Abrahamuyo adabwerera kumbuto kwace. ");
INSERT INTO nyu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kwatadoka, anju ziwiri zidapita muSodoma, Loti akhadakhala pafupi na cipata ca mumzindamo. Tsono Lotiyo, pomwe adaziwona, adaimirira aciyenda kukazitambira. Adagodama aciti: ");
INSERT INTO nyu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Ndaphata minyendo, azimbuya wangu, tiyendeni mukafike kunyumba, mukatsuke ndzayo na kukagona kumweko. Mangwana kungacena, mun'dzakwanisa kupitiriza na ulendo bwanu”. Tsono iwo adatawira kuti: “Ayai, ife tin'gona panja mumzindamo muno”. ");
INSERT INTO nyu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Iye adapitiriza na kuwakumbira, patsogolo pace iwo adabvuma, waciyenda kunyumba kwace. Ndipo iye adawacitira uzokoto. Adawaphikira pau yakusaya cakufufumisa aciwakondzera cakudya cakukoma kwene-kwene, wanthuwo adadya. ");
INSERT INTO nyu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Alendowo akhanati kugona, wanthu wentse wacimuna wa mumzindamo, alumbwana na nkhalamba, adadzazungulira nyumbayo. ");
INSERT INTO nyu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Adacemera Loti wacim'bvundza kuti: “Nandi wanthu wabwera usiku buno wale, wali kuponi? Wabutse, wabwere kuno kuti tigone nawo”. ");
INSERT INTO nyu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti adabula panja, acifunga msuwo. ");
INSERT INTO nyu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ndipo adawakumbira kuti: “Imwe axamwali wangu, lekani kucita bzimwebzi, thangwe n'kuphonya kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Wonani, ine ndina wana wacikazi awiri, madende, akanati kudziwa mwamuna. Ndingaleke kukupasani wana amwewa kuti mucite nawo bzomwe mun'funa. Ndipo alendowa, lekani kuwacita cinthu ciri-centse, thangwe mbalendo wangu, ndipo ndin'funika kuwakhongobza”. ");
INSERT INTO nyu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tsono iwo adati: “Coka apa, nyakudza iwe! Ndiwe yani, iwe, kuti ungatiwuze bzakuti ticite? Ife-pano tin'kuboneresa kwene-kwene kuposa wamwewale”. Na tenepo adam'gwinya, acifendera kuti wakachole msuwo. ");
INSERT INTO nyu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tsono amuna awiri akhali nyumba wale, adam'pfuira nyumba Loti, wacifunga msuwo. ");
INSERT INTO nyu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Patsogolo pace, adawacitisa khungu wanthu wentse wakhadaima panja, alumbwana na nkhalamba kubodzi, na tenepo alibe kukwanisa pomwe kuwona msuwo. ");
INSERT INTO nyu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Amuna awiri wale adabvundza Loti kuti: “Kodi alipo winango ali-yentse omwe uli naye kuno? Tenga wana wako wacimuna na wacikazi, na akuwasa wako na winango ali-yentse wacibale omwe ali mumzinda muno, mucoke, ");
INSERT INTO nyu_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","thangwe ife tin'funa kudzonga mbuto ino. Mulungu awona bzakuipa bzentse bzomwe wali kucita wanthu an'khala mumzinda muno, ndipo ife tatumiwa kuti tiudzonge mzindayu”. ");
INSERT INTO nyu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Pamwepo Loti adayenda kwa akuwasa wace omwe akhafuna kulowola wana wacewo, aciwauza kuti: “Kulumizani, mbaticoke kuno, thangwe yasala nthawe ing'ono kuti Mulungu adzonge mbuto ino”. Tsono iwo akhandokumbuka kuti ni thabwala za pezi. ");
INSERT INTO nyu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Macibese mwace, anju zire zidayeza kumukulumizisa Loti, zicimbamuuza kuti: “Kulumiza! Iwepo na mkazi wako na wana wako wacikazi awiri, mucoke muyende kunja kwa mzinda, kuti mupulumuse moyo wanu, pomwe mzinda uno uli kufuna kudzongewa”. ");
INSERT INTO nyu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ndipo Loti akhacedwa, tsono Mulungu adamubvera ntsisi. Na tenepo wanthuwo adatenga Loti, mkazi wace na wana wace awiri wale, pakuwaphata paboko, aciwacosa kunja kwa mzindawo, acikawasiya kumweko. ");
INSERT INTO nyu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Adandokuwacosa kunja kwa mzindawo, ibodzi ya anju zire idati, “Thamangani, mupulumuse moyo wanu. Lekani kuceuka m'mbuyo, pomwe lekani kuima mcigowamo. Thawirani kumapiri kuti mungaphewe”. ");
INSERT INTO nyu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ndipo Loti adam'tawira kuti: “Ayai, azimbuya wangu, lekani kucita terepo. ");
INSERT INTO nyu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mwandicitira nkhombo pakupulumusa moyo wangu, tsono mapiri yale yali patali kwene-kwene. Kudzongeka kwa mbuto ino komwe mwalewa kun'citika ine ndikanati kufika kumapiri kule, ndipo ndinifa. ");
INSERT INTO nyu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Pang'ambo pale pana kamzinda kang'ono. Pam'pale mphafupi, ndingakwanise kukafika. Mungandileke ndicikafika kum'kule. Nkhang'ono kwene-kwene, tsono ndin'kwanisa kupulumukira kum'kule”. ");
INSERT INTO nyu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Munthuyo adatawira kuti: “Bzimwebzo ndabvuma. Kamzinda kom'kale ndin'kadzonga lini. ");
INSERT INTO nyu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kulumiza! Thamanga! Ndin'cita lini ciri-centse mpaka iwe ufike kum'kule”. Na terepoyo Loti adathamanga, acikafika pamzinda pale. Thangwe race, kamzinda kale kan'cemeredwa Zowari. ");
INSERT INTO nyu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Pomwe dzuwa likhacoka, Loti akhadafika kale kuZowari. ");
INSERT INTO nyu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ndipo Mulungu adagwesa moto ninga wa pacipala padzaulu pa Sodoma na Gomora. ");
INSERT INTO nyu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Na tenepoyo, adapfudziratu mizinda imweire, pabodzi na cigowa centse na wanthu wentse mcigowamo, kuphataniza na bzakumera bzentse bza mdzikomo. ");
INSERT INTO nyu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Tsono mkazi wa Loti adaceuka m'mbuyo, pamwepo adasanduka mwala wa munyu. ");
INSERT INTO nyu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mangwana yandzace, macibese-bese, Abrahamu adathamangira kumbuto ire komwe adaimirira patsogolo pa Mulungu. ");
INSERT INTO nyu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Adanyang'ana kumizinda ya Sodoma na Gomora na cigowa cire. Ndipo adandowona utsi uli tolo-tolo kucoka kucigowa kule ninga utsi wakucoka m'ng'anju ya moto. ");
INSERT INTO nyu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Na tenepo, pomwe Mulungu akhapfudza mizinda ya cigowa, adakumbukira pembero la Abrahamu, ndipo adapulumusa Loti kukudzongeka komwe kudasakaza mizinda ire yomwe Loti akhakhala. ");
INSERT INTO nyu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Nakuti Loti akhagopa kukhala kuZowari, iye pabodzi na wana awiriwo, adapita kudziko la mapiri, wentsenewo adakakhala kuphanga libodzi. ");
INSERT INTO nyu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mwana wace mkulu adauza mng'ono kuti: “Baba wathuwa wali kukalamba tsapano, ndipo palibe munthu na m'bodziyo omwe wakuti angatilowole padziko lino, kuti tibereke wana ninga momwe bzimbacitikira padziko la pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Mbatiwaledzerese baba wathuwa kuti wagone na ife, kuti dzindza lireke kumala”. ");
INSERT INTO nyu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Na tenepo, usiku umwewo wana adam'pasa vinyu baba wawo. Pomwe adacita terepo, mwana mkulu adagona na baba wace. Pamwepo babayo akhadaledzera kwene-kwene, na tenepo alibe kudziwa bzomwe bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mangwana yandzace, mwana mkuluyo adauza mng'ono wace kuti: “Ine dzulo ndidagona na baba. Mbatiwaledzerese pomwe kuti iwembo ugone nawo, kucitira kuti dzindza lireke kumala”. ");
INSERT INTO nyu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Na tenepo usiku umwewo, adamuledzeresa, ndipo mwana mng'onoyo adagona na baba wace. Nthawe imweyombo baba waceyo akhadaledzera, na terepo alibe kudziwa bzomwe bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Na msambo umweyu, wana wentse awiri wa Loti, adatenga pathupi pa baba wawo. ");
INSERT INTO nyu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mwana mkulu ule adabereka mwana wacimuna, acim'pasa dzina lakuti Mowabu. Umweyu ndilo kholo la aMowabu wentse. ");
INSERT INTO nyu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mng'ono waceyo nayembo adabereka mwana wacimuna, acim'pasa dzina lakuti Benami. Umweyu ndilo kholo la aAmoni. ");
INSERT INTO nyu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahamu adacoka kuMamure kule aciyenda kuNegebu (cigawo ca kunyantsi kwa Kenani). Adakakhala pakati pa mzinda wa Kadesi na dziko la Suri, wacidzakakhala kudziko la Gerari. ");
INSERT INTO nyu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Kumweko adauza wanthu kuti: “Sarayu ni mpfumakazi yangu”. Na tenepo Abimeleki, mambo wa kuGerari, adam'tenga Sarayo. ");
INSERT INTO nyu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ndipo Mulungu adamuwonekera usiku mukulota aciti: “Unifatu iwe, thangwe mkazi omwe watengayo ngwakulowodwa kale”. ");
INSERT INTO nyu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Tsono Abimeleki akhanati kum'khuya mkaziyo, na tenepo adati: “Mbuya, cadidi mungaphe munthu wakusaya kuphonya? ");
INSERT INTO nyu_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abrahamu pomwe adandiuza adati: ‘Ni mpfumakazi yangu’, iyembo mwenekaciro akhati, ‘Ni nkhosve yangu’. Ine pomwe ndidacita bzimwebzi, m'tima wangu ulibe kundigaza, pomwe ndiribe kuphonya”. ");
INSERT INTO nyu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Mulungu adam'tawira mukulota mmwemo kuti: “Inde, ndin'dziwa kuti pomwe udacita bzimwebzo, m'tima wako ulibe kugaza. Na tenepoyo, ndidakuletsa ndine kukhuya mkaziyo, kuti uleke kundiphonyera. ");
INSERT INTO nyu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tsono upereke mkazi umweyo kwa mwamuna wace. Mwamunayo ni mpolofita, ndipo iye an'dzakupemberera kuti uleke kufa. Tsono ukaleka kum'pereka, udziwe kuti cadidi un'dzafa, iwepo na banja lako lentse”. ");
INSERT INTO nyu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mangwana yandzace, macibese-bese, Abimeleki adacemera akapolo wace wentse aciwauza bzentse bzire, tsono wanthuwo adacita mantha kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Pamwepo Abimeleki adacemera Abrahamu acim'bvundza kuti: “Waticita tani? Kodi ine ndakuphonyera ciyani, kuti iwe un'diputire cirango ca terepayu, ine na wentse wa muumambo bwangu? Bzomwe wacitabzi mpsakufunika lini. ");
INSERT INTO nyu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Thangwe ranyi wacita bzimwebzi?” ");
INSERT INTO nyu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahamu adatawira kuti: “Ndikhakumbuka kuti kuno kulibe na m'bodziyo wakugopa Mulungu, ndipo wangadandipha wacitenga mkazi wanguyu. ");
INSERT INTO nyu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tsono n'cadidi umweyu ni mpfumakazi yangu, thangwe ni mwana wa baba wangu, tsono ngwakubadwa lini na mai wangu, ine ndidamulowola. ");
INSERT INTO nyu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Na terepo, pomwe Mulungu adandituma kucokera kunyumba kwa baba wangu, kuti ndiyende kumadziko ya cirendo, ndidamuuza mkazi wanguyu kuti: ‘Uku ndiko kundikomera m'tima komwe udzandicitire ine, pakuuza ali-yentse kuti ndine nkhosve yako, kuli-kwentse komwe tiniyenda.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Tsono Abimeleki adabwezera Sara kwa Abrahamu, ndipo nthawe imweyo adam'pasa mabira, ng'ombe na anyankhoda wacimuna na wacikazi. ");
INSERT INTO nyu_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ndipo Abimeleki adati: “Dziko lentseneri ndangu, ungakwanise kukhala kuli-kwentse un'funa”. ");
INSERT INTO nyu_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ndipo kwa Sara adati: “Nkhosve yakoyi ndiri kuipasa kobiri za ndzayaya zicena culu cibodzi, kuti cikhale ninga mboni kwa wentse omwe ali nawewa kuti iwe ndiwe wakusaya kuphonya”. ");
INSERT INTO nyu_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Pamwepo Abrahamu adapemberera Abimeleki, ndipo Mulungu adam'ciza. Aciciza pomwe mkazi wace pabodzi na akapolo wace wacikazi, kuti wentsenewo wakwanise kubala. ");
INSERT INTO nyu_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Thangwe ra Sara, mkazi wa Abrahamu, Mbuya akhadawafunga nthumbo akazi wentse wa banja la Abimeleki. ");
INSERT INTO nyu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mbuya adam'komera m'tima Sara, acimucitira bzomwe akhadamulonjeza. ");
INSERT INTO nyu_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Na terepoyo Sara adatenga pathupi, acim'balira mwana wacimuna Abrahamu. Nthawe imweyo, Abrahamuyo akhali nkhalamba. Mwana umweyo adabadwa panthawe caiyo-iyo yomwe Mulungu akhadalewa. ");
INSERT INTO nyu_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ndipo mwana wa Abrahamu, omwe Sara adam'balirayo, Abrahamu adam'pasa dzina lakuti Isaki. ");
INSERT INTO nyu_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Pomwe mwanayo adakwanisa ntsiku zisere, Abrahamu adamugwata, ninga momwe Mulungu adamulamulira. ");
INSERT INTO nyu_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abrahamu akhana magole dzana, pomwe Isakiyo adabadwa. ");
INSERT INTO nyu_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tsono Sara adati: “Mulungu wandikondweresa na kundisekesa. Ali-yentse omwe angadzabve bzimwebzi, an'dzakondwera nande”. ");
INSERT INTO nyu_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ndipo adati: “Angadadziwa mbani kuti Sara angayamwise mwana? Tsono ndamubalira mwana wacimuna Abrahamu, pomwe ali nkhalamba”. ");
INSERT INTO nyu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mwanayo adakula ndipo patsiku yakuti amuletse kuyamwa, Abrahamu adacita uzokoto bukulu. ");
INSERT INTO nyu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ntsiku inango, Jumaere, omwe Hagari muIjipito ule adabalira Abrahamu, akhambanyoza Isaki, mwana wa Sara. ");
INSERT INTO nyu_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara, pomwe adabziwona, adauza Abrahamu kuti: “Mucoseni nyankhodayu pabodzi na mwana wace. Mwana wa nyankhodayu mbaaleke kudzatambira nthaka yanu yomwe iti idzatambiriwe na mwana wanguyu Isaki”. ");
INSERT INTO nyu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Bzimwebzi bzidamunesa kwene-kwene Abrahamu, thangwe rakuti Jumaerembo akhali mwana wace. ");
INSERT INTO nyu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tsono Mulungu adauza Abrahamu kuti: “M'tima wako mbauleke kuneseka thangwe ra mwanayo na mkazi wako Hagari. Bzentse bzomwe ali kukuuza Sara ucite, thangwe Isakiyu ndiye an'dzakhala kholo la bzizukulu bzako ninga momwe ndidakulonjezera. ");
INSERT INTO nyu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mwanambo wa nyankhoda ndin'dzam'pasa wana wazinji, ndipo an'dzasandulika dzindza likulu, nakuti iyembo ni mwana wako”. ");
INSERT INTO nyu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Mangwana yandzace macibese-bese, Abrahamu adapasa Hagari cakudya na budu la khanda lomwe likhana madzi. Patsogolo pace, adatenga mwanayo acim'pereka kuna Hagari. Pomwe adacita tenepo, adamuuza kuti ayende. Hagari adacoka cadidi, acifamba-famba mucidambo ca Beereseba. ");
INSERT INTO nyu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tsono pomwe yadamala madzi yale, adatenga mwanayo acimusiya patuugogo. ");
INSERT INTO nyu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Iye adakakhala pantsi ninga apo pomwe pakhakwanira mathanya dzana, thangwe akhambati, “Ine ndingakwanise lini kuwona mwana wangu ali kufa terepayu”. Pomwe akhadakhala pam'pale, mwanayo adayamba kulira. ");
INSERT INTO nyu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mulungu adamubva mwanayo ali kulira, ndipo anju wa Mulungu adalewa na Hagari kucokera kudzulu idati, “Kodi iwe Hagari, ciri kukunesa n'ciyani? Leka kucita mantha. Mulungu wabva kulira kwa mwanayo. ");
INSERT INTO nyu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Nyamuka, uyende, ukamulamuse ukam'phate paboko lako. Bzizukulu bzace bzin'dzakhala dzindza likulu”. ");
INSERT INTO nyu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Pamwepo Mulungu adafungula maso ya Hagari, ndipo adawona mcera. Iye adayenda pamcera pale, acikadzaza budu la khanda lire na madzi, acimwesambo mwanayo. ");
INSERT INTO nyu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mulungu adakhala naye mwanayo mpaka kukula. Adakulira mucidambo ca Perani, acisanduka misiri wa uta. ");
INSERT INTO nyu_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Mai waceyo adamunyang'anira mkazi wa kuIjipito. ");
INSERT INTO nyu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Panthawe imweyo, Abimeleki pabodzi na Fikolo, mkulu wa acikunda wace, adayenda kwa Abrahamu acikamuuza kuti: “Imwe, Mulungu anamwe pabzentse bzomwe mumbacita. ");
INSERT INTO nyu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ni thangwe race tsapano, picirani pano pamaso pa Mulungu kuti mun'dzanamiza lini ine ayai wana wangu napo bzizukulu bzangu. Ine ndakhala wakukhulupirika kwa imwe, napombo imwe mupicire kuti mun'dzakhala wakukhulupirika kwa ine, mudziko lomwe mun'khalamo”. ");
INSERT INTO nyu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahamu adati: “Ndiri kupicira”. ");
INSERT INTO nyu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Patsogolo pace, Abrahamu adadandaulira Abimeleki bza mcera omwe akapolo wace adapsokonyola. ");
INSERT INTO nyu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki adati: “Ndin'dziwa lini omwe adacita bzimwebzi. Napo imwe caiye mulibe kundiuza, ndipo ine kubva nkhum'kuno-letu”. ");
INSERT INTO nyu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abrahamu adapasa Abimeleki mabira na ng'ombe, ndipo wentse awiriwo adacita mpangano. ");
INSERT INTO nyu_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahamu adapambula wana wa mabira anomwe pakati pa bzifuwo bzace. ");
INSERT INTO nyu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki adam'bvundza kuti: “Thangwe ranyi mun'cita bzimwebzi?” ");
INSERT INTO nyu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahamu adatawira kuti: “Imwe tambirani mabira manomweya thangwe mukacita terepo muli kutawira kuti mcerayu ndidaucera ndine”. ");
INSERT INTO nyu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Na tenepo, mbuto imweyo idacemeredwa Beereseba, thangwe kumweko ndiko komwe wanthu awiriwo adacita m'pangano. ");
INSERT INTO nyu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Watondocita mpanganoyo kuBeereseba, Abimeleki na Fikolo, mkulu wa acikunda ule, adabwerera kwawo kudziko la aFilisti. ");
INSERT INTO nyu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Tsono Abrahamu adabzala kanjedza kuBeereseba, acicemera mwakupemba Mbuya Mulungu Wakuyenda-na-kuyenda. ");
INSERT INTO nyu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ndipo adakhala dziko la aFilisti nthawe itali. ");
INSERT INTO nyu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Patapita magole, Mulungu adayeza Abrahamu. Adamucemera, adati: “Abrahamu!” Ndipo Abrahamu adatawira kuti: “Ndiri pano, Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Mulungu adati: “Tenga Isaki, mwana wako m'bodzi yekhayo, omwe umbafuna, uyende kudziko la Moriya. Kumweko ukam'pereke ninga ntsembe yakutentherera paphiri lomwe ndin'dzakuuza”. ");
INSERT INTO nyu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Mangwana yandzace madandakweca, Abrahamu adakondza cakumbingira pabulu wace, acigwata nkhuni zakukatenthera ntsembe, ndipo adatenga Isaki pabodzi na akapolo wace awiri wacinyamuka ulendo wakuyenda kumbuto yomwe Mulungu akhadawauza. ");
INSERT INTO nyu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Pantsiku yacitatu yace, Abrahamu adawona mbuto ire na patali. ");
INSERT INTO nyu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ndipo adauza akapolo wace kuti: “Imwe bakakhalani pano na buluyu. Ine na mulumbwanayu tiniyenda uko kukatumbiza, tingakamala tin'dzakuwonani”. ");
INSERT INTO nyu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahamu adasendzesa Isaki nkhuni zakukatenthera ntsembe ire. Ndipo iye adatenga moto mmanja mwace pabodzi na cisu, wentse waciyamba kufamba pabodzi. ");
INSERT INTO nyu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Tsono Isaki adacemera baba wace kuti: “Baba”. Abrahamu adatawira kuti: “Ndiri pano, mwanangu”. Isaki adabvundza kuti: “Moto na nkhuni ndiri kubziwona, bziripo. Tsono mwana wa bira wakukatentha ntsembe ali kuponi?” ");
INSERT INTO nyu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahamu adamutawira kuti: “Mwanangu, Mulungu an'katipasa mwana wa birayo”. Na tenepo wentse awiri adapitiriza na ulendo bwawo pabodzi. ");
INSERT INTO nyu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Pomwe adafika kumbuto yomwe Mulungu adamuuza ire, Abrahamu adamanga guwa la ntsembe, aciikha nkhuni padzaulu pa guwalo. Patsogolo pace adamanga mwana waceyo, acimugonesa padzaulu pa nkhunizo. ");
INSERT INTO nyu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ndipo adasolola cisu kuti amuphe mwana wace ule. ");
INSERT INTO nyu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tsono anju wa Mbuya adam'cemera kucokera kudzulu, idati: “Abrahamu, Abrahamu!” Iye adatawira kuti: “Ndiri pano, Mbuya!” Anjuyo idati, ");
INSERT INTO nyu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Leka kumupha mulumbwanayo, napo kumucita cinthu cinango ciri-centse. Ndiri kudziwa kuti ndiwe wakubvera cadidi, thangwe ulibe kundimana mwana wako m'bodzi yekhayo”. ");
INSERT INTO nyu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Pomwe Abrahamu adanyang'ana pambali, adawona kuti pana bvululume wakupanikika nyanga zace mumphangala. Mmbuto yakupereka mwana wace ninga ntsembe, adakatenga bvululume ule acimupha ninga ntsembe yakutenthera. ");
INSERT INTO nyu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abrahamu adacemera mbutoyo kuti: “Mbuya adapasa”. Ndipo mpaka lero lino, wanthu ambati: “Paphiri la Mbuya an'dzapasa”. ");
INSERT INTO nyu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Anju ya Mbuya ire idam'cemera Abrahamu kaciwiri kucokera kudzulu, idati, ");
INSERT INTO nyu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Mbuya ali kulewa kuti: ‘Ndiri kupicira kuti ndin'dzakudalisa kwene-kwene iwe, thangwe wacita bzimwebzi, ulibe kundimana mwana wako m'bodziyo. ");
INSERT INTO nyu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","N'cadidi nin'dzakudalisa ndipo nin'dzakupasa bzizukulu bzizinji ninga nyenyezi za kudzulu, ayai ninga mcenga wa mumphepete mwa thawale. Bzizukulu bzakobzo bzin'dzatenga mizinda ya awengi wawo. ");
INSERT INTO nyu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Madzindza yentse ya padziko la pantsi yan'dzatambira madaliso kucokera kuna bzizukulu bzako, thangwe iwe wandibvera.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abrahamu adabwerera komwe akhadasiya akapolo wace, ndipo wentsenewo adayenda kuBeereseba. Ndipo Abrahamu adakakhala kumweko. ");
INSERT INTO nyu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Patsogolo pace, Abrahamu adabva kuti Milika adabalira Nahori, m'bale wace, wana asere. ");
INSERT INTO nyu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Mwana wace wakutoma akhali Uzi, mng'ono wa Uziyo akhali Buzi. Akhalipombo Kemuwele, baba wa Aramu, ");
INSERT INTO nyu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi, Ahazo, Pilidasi, Idilafe na Betuyele. ");
INSERT INTO nyu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuyele adabereka Rebeka. Milika adabalira Nahori, m'bale wa Abrahamu, wana asere amwewa. ");
INSERT INTO nyu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ndipo Reuma, mkazi mng'ono wa Nahori, adabala Teba, Gahamu, Tahasi na Maaka. ");
INSERT INTO nyu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara adakhala na moyo magole dzana na makumi mawiri na manomwe (127), ");
INSERT INTO nyu_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ndipo adafera kuKiriyati-Ariba (ndiko kulewa kuti Hebroni) mdziko la Kenani. Abrahamu adayenda kumweko kukalira nkhawa ya Sara. ");
INSERT INTO nyu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Patsogolo pace, adasiya mtembo wa mkazi waceyo, acikalewa-lewa na aHiti kuti: ");
INSERT INTO nyu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ine ndine mulendo kwanu kuno. Mundigulisirembo kathengo kakuti kakhale thenje, kuti ndikaikhe nkhawa ya mkazi wangu”. ");
INSERT INTO nyu_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Wanthuwo adamutawira kuti: ");
INSERT INTO nyu_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Tibvereni, mbuya wathu. Imwe ndimwe mtongi wa Mulungu pakati pa ife. Mkazi wanuyo, mumuikhe mthenje liri-lentse labwino lomwe tinalo muno. Palibe na m'bodziyo pakati pathu omwe angakumaneni thenje lomwe tinalo, ayai kukuletsani kuikhamo maiwa”. ");
INSERT INTO nyu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Pamwepo Abrahamu adaimirira acikotama kuna wanthuwo, ");
INSERT INTO nyu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","aciwauza kuti: “Penu muli kubvuma kuti ndiikhe nkhawa ya mkazi wangu kuno, ndaphata minyendo ndikumbirireni Efuroni muHiti, mwana wa Zohari, ");
INSERT INTO nyu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kuti andigulisire gwindza la Makipera analoli. Gwindzalo liri mmalire mwa munda wace. Mukumbireni kuti andigulisire na ntsengwa yace caiyo, imwe mucimbawona, kuti mbutoyo ndiisanduse thenje”. ");
INSERT INTO nyu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Nthawe imweyo, Efuroniyo akhali pabodzi na aHiti kumbuto yakucitira mitsonkhano pacipata ca mui. Ndipo wanthu wentsenewo akhabva, iye adatawira kuti: ");
INSERT INTO nyu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Ayai, mbuya wangu. Ine ndin'kupasani munda wentseneyu pabodzi na gwindza limweri. Ndin'kupasani mwaulere mbutoyo pamaso pa wanthu wentsenewa, kuti muikhe nkhawa ya mai omwe watisiyawa”. ");
INSERT INTO nyu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Pamwepo Abrahamu adakotama patsogolo pa wanthu wentse wale, ");
INSERT INTO nyu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","aciuza Efuroni pakati pa mthithi wa wentse kuti: “Tsono ndaphata minyendo, mundibvere, ine ndin'cita kugula mundayo. Tambirani kobiri za ntsengwa ya mundayo, kuti nkhawa ya mkazi wangu ndidzaiikhe mmwemo”. ");
INSERT INTO nyu_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Tsono Efuroni adatawira kuti: ");
INSERT INTO nyu_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Bverani, mbuya wangu. Mbutoyo ntsengwa yace ni madzana manai (400) ya kobiri za ndzayaya zicena. Tsono zimwezo n'ciyani pakati pa imwe na ine? Ikhani nkhawa yanu”. ");
INSERT INTO nyu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahamu adabvuma, ndipo pamaso pa aHiti wentse adalewenga kobiri za ndzayaya zire madzana manai yomwe Efuroni adalewa, pakuteweza kobiri zomwe wanthu wa malonda akhaphatisa basa mdzikomo panthawe imweyo. ");
INSERT INTO nyu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Terepayu ndimo momwe kathengo kale ka Efuroni ka kuMakipera, kumabva-dzuwa kwa Mamure, kadadzakhala ka Abrahamu. Pakhana munda na gwindza mmalire mwa mundamo, pabodzi na miti yentse ya mundamo mpaka kukafika kumalire yace. ");
INSERT INTO nyu_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","AHiti omwe akhali pamtsonkhanopo adacita umboni kuti mbali yentseneyo nja Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Patsogolo pace, Abrahamu adaikha nkhawa ya mkazi wace Sara mgwindza la mmunda wa kuMakipera, kumabva-dzuwa kwa Mamure, (ndiko kulewa kuti Hebroni), mdziko la Kenani. ");
INSERT INTO nyu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Na terepo, mundayu pabodzi na thenje lomwe kale likhali la aHiti, mbuto yentseneyo idaperekewa kuna Abrahamu, ndipo iye adaisandusa thenje. ");
INSERT INTO nyu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ndipo Abrahamu akhadakalamba, akhadakwanisa magole mazinji, ndipo Mbuya adam'dalisa pabzentse bzomwe akhacita. ");
INSERT INTO nyu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ntsiku ibodzi, adauza kapolo wace mkulu omwe akhambawonerera bzinthu bzace bzentse kuti: “Ikha boko lako kuntsi kwa nchafu yangu. ");
INSERT INTO nyu_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ndin'funa kuti upicire pamaso pa Mbuya, Mulungu wa kudzulu na Mulungu wa dziko la pantsi, kuti un'dzatengera lini mwanangu mkazi pakati pa atsikana aKenaniwa komwe ndiri kuno. ");
INSERT INTO nyu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Tsono un'dzayenda kudziko kwangu, ndipo un'kam'tengera mkazi mwana wangu pakati pa abale wangu”. ");
INSERT INTO nyu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tsono kapoloyo adabvundza, “Kodi bzingadzacite tani mkaziyo akadzalamba kubwera na ine kuno? Kodi mwana wanuyo ndidzam'perekeze kudziko lanu komwe mudacoka?” ");
INSERT INTO nyu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahamu adatawira kuti: “Leka kudzam'perekeza kumweko mwana wanguyo. ");
INSERT INTO nyu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mbuya, Mulungu wa kudzulu, adanditenga kwathu m'banja mwa baba wangu na mudziko lomwe ndidabadwira, ndipo adandilonjeza mwakupicira kuti: ‘Dziko lino ndin'dzapasa bzizukulu bzako.’ Mbuyayo an'dzatuma anju yace yakukutsogolera, ndipo kumweko un'dzamutengera mkazi mwana wangu. ");
INSERT INTO nyu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tsono penu mkaziyo an'dzalamba kubwera na iwe kuno, un'dzatsudzuka pacipiciro cimweci. Tsono leka kum'bwezera mwana wangu kumweko”. ");
INSERT INTO nyu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Na terepo, kapoloyo adaikha boko lace kuntsi kwa nchafu ya Abrahamu, mbuya wace, ndipo adapicira kuti: “Ndin'dzacita bzentse bzomwe mwalewabzi”. ");
INSERT INTO nyu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tsono kapoloyo adatenga ngamira khumi za mbuya wace, na mphaso za kobiri kwene-kwene, ndipo adayenda kumzinda wa Nahori, mdziko la Mesopotamiya. ");
INSERT INTO nyu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Atandofika kumweko, adazigodamisa pantsi ngamirazo pafupi na mcera, kunja kwa mzinda. Kukhali kumaulo, nthawe yomwe akazi akhabwera kumcerako kudzatunga madzi. ");
INSERT INTO nyu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ndipo kapoloyo adayamba kupembera adati: “Mbuya, Mulungu wa mbuya wangu Abrahamu, ndiri kukukumbirani kuti bzentse bzindifambire bwino lero lino, ndipo muwonese lufoyi lanu lakusaya kusandulika lomwe munalo kuna mbuya wangu Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ndiri pano pamcera, ndipo akazi wa mumzindamo an'bwera kudzatunga madzi. ");
INSERT INTO nyu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ine ndingakumbira dende libodzi kuti: ‘Ndaphata minyendo, bulusa mtsuko wako kuti ndimwembo madzi.’ Tsono dendelo lingandibvumiza kuti: ‘Imwani, ndipo ndin'kumweserani ngamira zanu’, umweyu akhale dende lomwe mwasankhulira kapolo wanu Isaki. Bzimwebzi bzingacitika, ndin'dziwa cadidi kuti mwam'citira m'tima wabwino mbuya wangu”. ");
INSERT INTO nyu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Akanati kumaliza kupembera, adandowona uyu, wafika Rebeka, akhadasendza mtsuko paphewa. Umweyu akhali mwana wa Betuyele, mwana wa Milika, mkazi wa Nahori, m'bale wa Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Likhali dende lakudeka kwene-kwene, lomwe likhanati kufambizana na mwamuna. Iye adayenda kuphompho kumcera kule, adatunga madzi mumtsuko, acicoka kumweko. ");
INSERT INTO nyu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Tsono kapolo ule adam'thamangira kuti akagumane naye, acimukumbira kuti: “Ndaphata minyendo, mundipasembo madzi ya mumtsuko mwanu, kuti ndimwe”. ");
INSERT INTO nyu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Dendelo lidati, “Mwani, mbuya wangu,” ndipo mwakusaya kucedwa adabulusa mtsuko wace ule paphewa, aciuphatirira kuti mulendoyo amwe. ");
INSERT INTO nyu_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mulendo ule adamwa madziyo, dendelo lidati, “Ndin'bwera pomwe na madzi yanango, kuti zimwe ngamira zanu mpaka zikhondwe”. ");
INSERT INTO nyu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ndipo mwakamkulumize madzi ya mumtsukomo adayatsanulira mcimwadiya cakumwera bzifuwo, acithamanga kumcera kukatunga madzi yanango yakuti amwese ngamirazo. ");
INSERT INTO nyu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Munthuyo akhali cete, kunyang'ana bzomwe likhacita dendelo, kuti awone pinango Mbuya adalisa ulendo bwace ayai alibe. ");
INSERT INTO nyu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Dendelo latamala kumwesa ngamirazo, munthuyo adacosa mphete yakukondziwa na mwala wa kobiri zifuira, acim'bvadzika Rebeka pamphuno pace. Adam'bvadzikambo mmanja mwace nkhwinjiri ziwiri zakukondzedwa na mwala wa kobiri zifuira. ");
INSERT INTO nyu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Patsogolo pace, adabvundza dendelo kuti: “Kodi baba wako mbani? Ndiuze, ndaphata minyendo. Kodi mbuto yakuti tikagone ine na andzanguwa usiku buno iripo?” Dendelo lidatawira kuti: ");
INSERT INTO nyu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","“Ine ndine mwana wa Betuyele, mwana wa Nahori, omwe adam'balira Milika”. Adapitiriza pomwe acilewa kuti: ");
INSERT INTO nyu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","“Cakudya cakukadyesa bzifuwo ciriko kwathu, ndipo mbuto yakuti imwe mukagone iripo pomwe”. ");
INSERT INTO nyu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Pamwepo munthu ule adakotama acipemba Mbuya, ");
INSERT INTO nyu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ndipo adati: “Alemekezedwe Mbuya, Mulungu wa mbuya wangu Abrahamu, omwe wakoya mwakukoma m'tima na kukhulupirika lonjezo lace kwa mbuya wangu. Mbuya wanditsogolera ine kunyumba ya mbale wace wa mbuya wangu”. ");
INSERT INTO nyu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tsono dende lire lidathamangira kunyumba kwa mai walene, licikauza wentse nkhani yentseneyo. ");
INSERT INTO nyu_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Pamwepo Labani, nkhosve ya Rebekayo, idawona mphete ire pabodzi na nkhwinjiri kuboko la mpfumakazi yaceyo. ");
INSERT INTO nyu_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Atondomala kubva mpfumakazi yace kulewa bzomwe munthu ule adamuuza, Labaniyo adathamangira kumcera komwe kukhana munthuyo. Adakafika pambuto pomwe akhadaima kapolo wa Abrahamu, pafupi na ngamira zire kumcerako. ");
INSERT INTO nyu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Adauza munthuyo kuti: “Tiyendeni kwathu, imwe ndimwe munthu omwe Mbuya wakudalisani. Thangwe ranyi muli kuima kuno? Ine ndakukondzerani kale mbuto kunyumba, ndipombo mbuto ya ngamira zanu”. ");
INSERT INTO nyu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Na tenepo, munthu ule adakapita munyumba, ndipo Labani adatsudzula mitolo yomwe ikhadatakulidwa na ngamirazo. Pomwe adamala kucita bzimwebzo, adazipasa cakudya, aciperekambo madzi kuna kapolo wa Abrahamu kuti atsuke ndzayo pabodzi na andzace wentse. ");
INSERT INTO nyu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Pomwe cakudya cidabwera, munthu ule adati: “Ndin'dya lini ndikanati kulewa bzomwe ndabwerera”. Pamwepo Labani adamuuza kuti: “Lewa”. ");
INSERT INTO nyu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Iye adati: “Ine ndine kapolo wa Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mbuya adamudalisa kwene-kwene mbuya wangu, ndipo adamukuza kwene-kwene. Ana mabira, mbuzi na ng'ombe zizinji. Ana pomwe minyala ya kobiri zicena na zifuira, anyankhoda wacimuna na wacikazi, ana pomwe ngamira na mabulu. ");
INSERT INTO nyu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, mkazi wace wa mbuya wangu, adam'balira mwana wacimuna, Sarayo akhadakalamba kale. Ndipo mbuya wanguyo wam'pasa cuma cace centse mwana umweyu. ");
INSERT INTO nyu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tsono mbuya wangu adandipicirisa kuti ndikoye mafala yace yakuti: ‘Mwana wanguyo leka kudzam'tengera mkazi pakati pa madende ya dziko lino la Kenani, komwe ndiri ine kuno. ");
INSERT INTO nyu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Tsono uyende kwathu kwa baba wangu na abale wangu, kukamutengere mkazi mwana wangu kumweko.’ ");
INSERT INTO nyu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ndipo ine ndidamutawira mbuya wangu kuti: ‘Tsono bzin'dzacita tani penu mkaziyo an'dzalamba kubwera na ine kuno?’ ");
INSERT INTO nyu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Iye adanditawira kuti: ‘Mbuya omwe ndidakhala ndicimbamubvera nthawe zentse, an'dzatuma anju yace kuti iyende pabodzi na iwe, ndipo in'dzakuthandiza. Un'dzamunyang'anira mkazi mwana wangu pakati pa wanthu wangu, m'banja la baba wangu. ");
INSERT INTO nyu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ungacita bzimwebzi, temberero langu lin'dzakufikira lini. Tsono iwe ungafika kubanja langulo, wanthu wanguwo acikakulamba, un'dzatsudzuka kucipiciro cako’ ”. ");
INSERT INTO nyu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Tsono lero lino pomwe ndafika kumcera, ndapembera kuti: ‘Mbuya, Mulungu wa mbuya wangu Abrahamu, ndaphata minyendo mundithandize kuti ndikwanirise ulendo bwangubu. ");
INSERT INTO nyu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ndiri pano pamcera, pakabwera dende pano kudzatunga madzi, ine ndin'dzakumbira kuti: “Ndaphata minyendo, ndipasembo madzi ya mumtsuko mwako kuti ndimwe”. ");
INSERT INTO nyu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Iye anganditawira kuti: “Mwani, ndipo ndimwesembo ngamira zanuzi”, umweyo ndiye akhale dende lomwe Mbuya wasankhula kuti likhale mkazi wa mwana wa mbuya wangu.’ ");
INSERT INTO nyu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ndikanati kumaliza pembero langulo ndandowona uyu, wafika Rebeka, akhadasendza mtsuko paphewa, acimbapolikira kumcera kudzatunga madzi. Tsono ndam'kumbira kuti: ‘Ndaphata minyendo, ndipasembo madzi ndimwe.’ ");
INSERT INTO nyu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Mwakamkulumize abulusa mtsuko paphewa, acindiuza kuti: ‘Mwani, ndipo ndin'mwesa pomwe ngamira zanuzi.’ Na tenepo, ine ndamwa, ndipo iye amwesambo ngamirazo. ");
INSERT INTO nyu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ndipo ndam'bvundza kuti: ‘Baba wako mbani?’ Iye anditawira kuti: ‘Baba wangu ni Betuyele, mwana wa Nahori, omwe adam'balira Milika.’ Pamwepo ndam'bvazika mphete pamphuno, ndipombo nkhwinjiri kuboko. ");
INSERT INTO nyu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Patsogolo pace, ndakotama ndicipemba kwa Mbuya. Ndatumbiza Mbuya, Mulungu wa mbuya wangu Abrahamu, thangwe ra kunditsogolera bwino kwene-kwene. Mbuya wandifikisa kwa abale wace mbuya wangu, komwe ndakawona mwana wace omwe an'dzakhala mkazi wa mwana wa mbuya wangu. ");
INSERT INTO nyu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tsapanopa, imwe penu mun'komera m'tima mbuya wangu mwakukhulupirika, ndaphata minyendo, ndiuzeni ndibve. Penu ni terepoyo lini, lewani kuti ndidziwe cakucita”. ");
INSERT INTO nyu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Pamwepo Labani na Betuyele adauza munthuyo kuti: “Thangwe rakuti bzimwebzi n'bzakucokera kwa Mbuya, ife palibe comwe tingacite. ");
INSERT INTO nyu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nguyu Rebeka, mtengeni muyende naye. Mukam'pereke kwa mwana wa mbuya wanuyo kuti akakhale mkazi wace, ninga momwe Mbuya adalewera”. ");
INSERT INTO nyu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kapolo wa Abrahamu ule, pomwe adabva mafalayo, adagodama acitsulima pamaso pa Mbuya. ");
INSERT INTO nyu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Patsogolo pace, adacosa bzinthu bzakukondzedwa na minyala ya kobiri zicena na zifuira, pabodzi na bzakubvala, acipasa Rebeka. Adapereka pomwe mphaso za kobiri kwene-kwene kwa nkhosve ya Rebekayo na kwa mai wace. ");
INSERT INTO nyu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kapoloyo pabodzi na wanthu omwe akhali nayewo, adadya acimwa, ndipo adagona kumweko. Pomwe adalamuka macibese mwace, mulendoyo adati: “Ndibvumizeni ndibwerere kwa mbuya wangu”. ");
INSERT INTO nyu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tsono mai wace Rebeka, pabodzi na nkhosve yaceyo, adati: “Nee, dendeli likhale na ife kuno kanthawe kang'ono-ng'ono, ntsiku khumi zokha, patsogolopo an'dzayenda”. ");
INSERT INTO nyu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tsono kapoloyo adati: “Ndaphata minyendo, lekani kundicebwesa. Mbuya wandithandiza kwene-kwene paulendo bwangubu. Ndibvumizeni tsono ndibwerere kwa mbuya wangu”. ");
INSERT INTO nyu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Pamwepo iwo adatawira kuti: “Mbatiricemere dendelo, kuti tibve bzomwe iro linilewa”. ");
INSERT INTO nyu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Na terepo, adam'cemera Rebeka wacim'bvundza kuti: “Kodi uli kufuna kuyenda naye munthuyu?” Rebekayo adatawira kuti: “Inde, ndiniyenda”. ");
INSERT INTO nyu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Na tenepoyo, adamubvumiza Rebeka pabodzi na mulezi wace, kuti wayende na kapolo wa Abrahamu na wanthu wale womwe akhamuperekeza. ");
INSERT INTO nyu_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ndipo adam'dalisa Rebekayo, pakulewa mafala yakuti: “Iwe mwana wathu, Mbuya akudalise kuti udzakhale mai wa wanthu bzulu bzizinji. Bzizukulu bzako bzidzakunde mizinda ya nyamadulanthaka wawo”. ");
INSERT INTO nyu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Pamwepo Rebeka pabodzi na kapolo wace wacitsikana adanyamuka wacikapakira ngamira, waciyenda na munthu ule. ");
INSERT INTO nyu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaki akhabwera kucoka ku Beer-Lahai-Roi (ndiko kulewa Mcera wa ule Wamoyo omwe ambandiwona), thangwe akhakhala kuNegebu. ");
INSERT INTO nyu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ntsiku ibodzi kumaulo, Isakiyo akhafamba aciyenda kuthengo, ndipo adawona ngamira ziri kubwera. ");
INSERT INTO nyu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tsono Rebeka, pomwe adawona Isaki, adabuluka pangamira yace ire. ");
INSERT INTO nyu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Adam'bvundza kapoloyo kuti: “Kodi munthu ali kubwera kuno ule mbani?” Kapolo ule adatawira kuti: “Ndiye mbuya wangu umweule”. Na terepo Rebeka adatenga nguwo acibzifinikiza acim'psinkha mmaso. ");
INSERT INTO nyu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kapoloyo adamufotokozera Isaki bzentse bzomwe bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Tsono Isaki adatenga Rebeka kuti akhale mkazi wace, acipita naye mucikumbi mwace. Isaki adam'funa kwene-kwene Rebekayo, na tenepo bzimwebzi bzidamutsangalazisa acileka kukumbukira impfa ya mai wace. ");
INSERT INTO nyu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahamu adalowola pomwe mkazi winango, dzina lace Ketura. ");
INSERT INTO nyu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura adam'balira Zimirani, Yokisani, Medani, Midiyani, Isibaki na Suwa. ");
INSERT INTO nyu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokisani adabereka Sheba na Dedani, ndipo wana wa Dedani wakhali aAsuri, aLetusi na aLeumi. ");
INSERT INTO nyu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Wana wa Midiyani akhali Efa, Efera, Hanoki, Abida na Elida. Wentsenewa wakhali bzizukulu bza Ketura. ");
INSERT INTO nyu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahamu adasiyira Isaki bzentse bzomwe akhanabzo. ");
INSERT INTO nyu_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Tsono akanati kufa, adawapasa mphaso wana wace winango wale womwe adabala na akazi wace winango. Wentsenewo adawatumiza kudziko la kumabva-dzuwa, kuti akakhale kumweko, adawacosa kwa mwana wace Isaki. ");
INSERT INTO nyu_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahamu, pomwe adasayika akhana magole dzana na makumi manomwe na maxanu. ");
INSERT INTO nyu_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Adasayika akhali nkhalamba caiyo, akhadamala magole mazinji ndipo adakasanganiziwa na makolo yace. ");
INSERT INTO nyu_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Wana wace wale, Isaki na Jumaere, adamuikha mucigwindza cire ca Makipera, munda omwe kale ukhali wa Efuroni, mwana wa Zohari, muHiti. Mundayo ukhali kumabva-dzuwa kwa Mamure. ");
INSERT INTO nyu_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ukhali munda omwe Abrahamu adagula kwa aHiti. Abrahamu na mkazi wace Sara, adaikhidwa kumweko. ");
INSERT INTO nyu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Pomwe adasayika Abrahamu, Mulungu adadzadalisa mwana wace Isaki, omwe akhakhala pafupi na mcera wa Wamoyo wa Wakundiwona ule. ");
INSERT INTO nyu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Bzizukulu bza Jumaere mpsibzi, mwana wa Abrahamu omwe Hagari adam'balira, nyankhoda wa kuIjipito ule. ");
INSERT INTO nyu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Madzina ya wana wa Jumaere ngaya: Wakuyamba akhali Nebayoti, patsogolo pace adabereka Kedara, Adibeele, Mibisamu, ");
INSERT INTO nyu_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Duma, Masa, ");
INSERT INTO nyu_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi, Tema, Yeturi, Nafisi na Kedema. ");
INSERT INTO nyu_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Wamwewa ndiwo wana wa Jumaere, malingana na mii yawo ndipombo na misasa yawo. Wakhali azimambo khumi na awiri wa madzindza yakusiyana-siyana. ");
INSERT INTO nyu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Panthawe yomwe adasayika Jumaere, akhana magole dzana na makumi matatu na manomwe, ndipo adakasanganiziwa na makolo yace. ");
INSERT INTO nyu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Bzizukulu bza Jumaereyo bzikhakhala mdziko la pakati pa Havila na Suri, kumabva-dzuwa kwa Ijipito, panjira ya kuAsiriya. Bzikhakhala mwakumwazana na bzizukulu bzinango bza Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Bzizukulu bza Isaki, mwana wa Abrahamu, mpsibzi: Abrahamu adabereka Isaki. ");
INSERT INTO nyu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaki adalowola Rebeka, mwana wa Betuyele, muAramu wa kuMesopotamiya ule, Isakiyo akhana magole makumi manai. Nkhosve ya Rebekayo ikhali Labani, muAramu. ");
INSERT INTO nyu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Tsono mkazi wa Isaki akhabala lini. Na tenepo, Isakiyo adapemberera mkazi wace kwa Mbuya. Mbuya adabva pembero lace, ndipo Rebeka adatenga pathupi. ");
INSERT INTO nyu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Tsono pomwe wana awiri adayamba kugwinyana-gwinyana mmimba mwace, adati: “Penu bzimbacitika terepa, nin'khaliranyi na moyo?” Ndipo adayenda kukabvundza Mbuya kuti amutawire. ");
INSERT INTO nyu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mbuya adamuuza kuti: “Mmimba mwako muna madziko mawiri ya wanthu. Un'dzabereka madzindza ya wanthu yakupokana: Mwana m'bodzi an'dzakhala wa mphambvu kuposa mwandzace, Wamkulu an'dzakhala wakutumikira mng'ono”. ");
INSERT INTO nyu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Nthawe yakuti abale idakwana, Rebeka adabala mamphase. ");
INSERT INTO nyu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mwana wakuyamba kubadwa akhali mufuira, ndipo thupi race lentse likhali ninga cakubvala ca maukuse. Na terepo, adam'pasa dzina lakuti Esau. ");
INSERT INTO nyu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Pomwe adabadwa mng'ono wace, boko lace likhadaphata katende ka Esau. Na tenepo, adam'pasa dzina lakuti Yakobo. Pomwe adabadwa wana amwewa, Isaki akhana magole makumi matanthatu. ");
INSERT INTO nyu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Alumbwanawo adakula cadidi, ndipo Esau adadzakhala nkhumbalume wakudziwa kusodza, wakufuna kufamba kwene-kwene. Tsono Yakobo akhali wakunyamala, wakufuna kukhala pamui. ");
INSERT INTO nyu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ndipo Isaki akhafuna Esau, thangwe ra nyama yomwe Esauyo akapha akhambam'pasa. Tsono Rebeka akhafuna Yakobo. ");
INSERT INTO nyu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ntsiku ibodzi, Yakobo adaphika nyemba zifuira, Esau adabwera kucokera mthengo. ");
INSERT INTO nyu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Akhana njala kwene-kwene, na tenepo adauza Yakobo kuti: “Njala yandipweteka. Ndipasembo nyemba zifuira waphikazi ndinyopole”. (Ni thangwe race adam'cemera Edomu.) ");
INSERT INTO nyu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Tsono Yakobo adatawira kuti: “Utome wandipasa ukulu bwako bwa umwana wakuyamba, ndipo ndin'dzakupasa bzimwebzi”. ");
INSERT INTO nyu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau adati: “Ndabva, ine ndiri pafupi kufa. Kodi ukulu bwangubu buna phindu lanyi?” ");
INSERT INTO nyu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo adati: “Utome wapicira kuti ukulu bwakobu wandipasa cadidi”. Pamwepo Esau adalumbira, acigulisa ukulu bwace bwakubadwa kwa Yakobo. ");
INSERT INTO nyu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Nthawe imweyo, Yakobo adapasa Esau pau pabodzi na nyemba zire, ndipo Esau adadya acimwera madzi. Patsogolo pace, adanyamuka acicoka pam'pale. Tenepoyo, Esauyo adanyoza ukulu bwace bwa umwana wakuyamba. ");
INSERT INTO nyu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","M'dzikomo mudapita pomwe njala ya kuposa pa yomwe idapita panthawe ya Abrahamu. Ndipo Izaki adayenda kwa Abimeleki mambo wa Afilisti ku Jerari. ");
INSERT INTO nyu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ndipo Mbuya adawonekera kuna Izaki acimuwuza kuti: “Leka kuyenda ku Ijipito, ukhale m'dziko lomwe nin'dzakuwuza. ");
INSERT INTO nyu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Khala kuno ndipo Ine nin'dzakhala nawe. Nin'dzakudalisa thangwe nin'dzapereka madziko yentseneya kuna iwe na kwa bzizukulu bzako. Nin'dzatsimikiza kulumbira komwe ndidacita kwa baba wako Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nin'dzakupasa bzizukulu bzakuwanda ninga nyenyezi za kudzulu, ndipo bzizuku bzakobzo nin'dzabzipasa madziko yentseneya. Mitundu yentse ya pa dziko la pantsi in'dzadalisidwa kudzera mwa bzizukulu bzako. ");
INSERT INTO nyu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Thangwe Abrahamu adabvera fala langu, ndipo adateweza bzakutonga bzangu, malangizo yangu, bzakunemba bzangu na mitemo yangu”. ");
INSERT INTO nyu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Na tenepo Izaki adakhala ku Jerari. ");
INSERT INTO nyu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ndipo wanthu wa kumweko adam'bvundza bza mkazi wace, Izaki adati: “Umweyu ni mpfumakazi yangu”. Nakuti akhana mantha ya kulewa kuti: “Ni mkazi wangu”. Thangwe adakumbuka kuti wanthu wa kumweko angamuphe ndipo wangalowole Rebeka, pakuwona kuti akhali wakudeka kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Tsono Izaki atakhala kumweko ntsiku zizinji, Abimeleki mambo wa Afilisti adasondzokera pa mubo wa nyumba yace kunyang'ana kunja, adawona Izaki adakumbatira Rebeka, mkazi wace. ");
INSERT INTO nyu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Pamwepo Abimeleki adacemera Izaki, ndipo adati: “Umweyu cadidi ni mkazi wako! Thangwe ranyi ukhalewa kuti ni mpfumakazi yako?” Iye adatawira kuti: “Ndikhakumbuka kuti nin'dzaphedwa thangwe race”. ");
INSERT INTO nyu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Pamwepo Abimeleki adamubvundza kuti: “N'ciyani comwe waticitaci? Winango mwa wanthu wanguwa m'psino agona naye mkazi wako, iwepo ungadatiphonyesa”. ");
INSERT INTO nyu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ndipo Abimeleki adawuza wanthu wace wentse kuti: “Aliyentse omwe an'khuya mwamunayu pabodzi na mkazi waceyo, an'dzaphedwa”. ");
INSERT INTO nyu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Izaki adalima m'dzikomo, ndipo gole limwero adabvuna bzizinji kwene-kwene, thangwe Mulungu adamudalisa. ");
INSERT INTO nyu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Munthuyo adadala, cuma cace cikhapitiriza kuwanda, ndipo adakhala wakudala kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Tsono Afilisti adayamba kumucitira njiru, thangwe lakuti akhana mabira na ng'ombe zizinji, ndipo anyagirinya azinji. ");
INSERT INTO nyu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Na tenepo iwo adafucira micera yentse yomwe akapolo wa baba wace adacera, pantawe yomwe babaceyo akhana moyo. ");
INSERT INTO nyu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ndipo Abimeleki adawuza Izaki kuti: “Coka mudziko lathu lino, pakuti ndiwe wamphambvu kwene-kwene kuposa ife”. ");
INSERT INTO nyu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Na tenepo Izaki adacoka acikamanga bzikumbi m'cigowa ca Jerari ndipo adakhala kumweko. ");
INSERT INTO nyu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Izaki kumweko adafukula pomwe micera yomwe ikhadaceredwa panthawe ya baba wace Abrahamu. Thangwe Afilisti akhadayifucira pomwe Abrahamu adafa. Ndipo micerayo adayicemera madzina yomwe baba wace akhadayipasa. ");
INSERT INTO nyu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Akapolo wa Izaki adacera m'cigowa, ndipo adapata madzi ya kufunthukira. ");
INSERT INTO nyu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tsono amakabusa wa ku Jerari adayamba kupopotezana na amakabusa wa Izaki, akhambati: “Madziya ni yathu”. Na tenepo m'cerayo Izaki adawucemera Kupokana, nakuti adapopotezana thangwe ra iye. ");
INSERT INTO nyu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Pamwepo akapolo wa Izaki wale adacera m'cera winango, ndipo adapopotezana pomwe thangwe ra m'cerayo. Na tenepo Izaki adawucemera Madulanthaka. ");
INSERT INTO nyu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ndipo Izaki adacoka kumweko, acikacera pomwe m'cera winango. Kumweko Palibe omwe adapopotezana naye, na tenepo adawucemera Ufulu, adati: “Tsapano Mbuya watipasa mbuto, ndipo kuno tin'dzadala”. ");
INSERT INTO nyu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Izaki adacoka pamwepo aciyenda ku Berseba. ");
INSERT INTO nyu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Usiku bumwebo Mbuya adamuwonekera acimuwuza kuti: “Ine ndine Mulungu wa baba wako Abrahamu. Leka kucita mantha nakuti Ine ndiri na iwe. Nin'dzakudalisa, ndipo nin'dzawandisa bzizukulu bzako thangwe ra lifoi na m'tumiki wangu Abrahamu”. ");
INSERT INTO nyu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ndipo, pambuto imweyo Izaki adamanga guwa, acitumbiza dzina la Mbuya mwakupemba, adamanga cikumbi cace pamwepo, ndipo akapolo wace adacera m'cera unango. ");
INSERT INTO nyu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ntsiku inango Abimeleki pabodzi na xamwali wace Ahuzati, na Fikolo m'tsogoleri wa acikunda adacoka ku Jerari aciyenda kuna Izaki. ");
INSERT INTO nyu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ndipo Izaki adawabvundza kuti: “Thangwe ranyi mwabwera kuna ine, nakuti mumbadiwenga ndipo mudandithotha m'dziko mwanu?” ");
INSERT INTO nyu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Iwo adatawira kuti: “Ife tawonesesa kuti Mbuya ali na iwe, ndipopo takumbuka bzakuti iwe na ife tirumbirirane ndipo ticite cipangano na iwe: ");
INSERT INTO nyu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Iwe un'dzaticita lini cakuyipa, ninga ifembo tiribe kukucitira cakuyipa. Tidakucitira bzabwino, ndipo tidakubvumiza kuti uyende mwamtendere. Tsapano tadziwa kuti Mbuya alikukudalisa”. ");
INSERT INTO nyu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Pamwepo Izaki adawakondzera cikondwereso ndipo iwo adadya na kumwa. ");
INSERT INTO nyu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mangwana yance macibece-bece, awiriwo adalumbirirana. Patsogolo pace Izaki adagonekana nawo, ndipo iwo adayenda mwamtendere. ");
INSERT INTO nyu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ntsiku ibodzi-bodziyo akapolo wa Izaki adabwera kudzamuwuza bza m'cera omwe iwo adacera. Ndipo adati: “Taphata madzi”. ");
INSERT INTO nyu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Izaki adawucemera Seba. Ndipopo m'zindawo umbacemeredwa Bereseba mpaka lero lino. ");
INSERT INTO nyu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Pomwe Izawu akhana magole makumi manayi, adalowola Juditi mwana wa Beeri muHiti, adakalowola pomwe Basemati, mwana wa Eloni muHiti. ");
INSERT INTO nyu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Iwo adawonesa mabvuto makulu kuna Izaki na Rebeka. ");
INSERT INTO nyu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Izaki atakalamba, adacita khungu, mwakuti akhakwanisa lini kuona. Ndipo adatumiza mafala kuti Izau mwana wace mkulu abwere. Atabwera, Izaki adamucemera kuti: “Mwanangu!” Iye adatawira kuti: “Ndiri pano, baba”. ");
INSERT INTO nyu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ndipo Izakiyo adati: “Wona, ine nkukalamba kuno, ndipo nin'dziwa lini ntsiku yakuti ndife. ");
INSERT INTO nyu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tenga bzakusodzera bzako, uta na budu wa misewe, uyende ku thengo ukandiphere nyama. ");
INSERT INTO nyu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Undiphikire cakudya cakukoma ndimbafuna cire, ubwere naco kuno. Ndikadzamala kudya, nin'dzakudalisa ndikanati kufa”. ");
INSERT INTO nyu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeka akhabva pomwe Izaki akhalewa-lewa na mwana wace Izau. Ndipo Izauyo adayenda ku thengo kukanyan'gana nyama kuti adzapase baba wace, ");
INSERT INTO nyu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka adauza Yakobo kuti: “Ine ndabva baba wako akhauza Izau aciti: ");
INSERT INTO nyu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ubwere na nyama ya mthengo kuno, undiphikire cakudya cakukoma cire. Ndikadzamala kudya, ndidzakudalise pamaso pa Mbuya ndikanati kufa.’ ");
INSERT INTO nyu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tsono mwana wangu, undibvere ndipo ucite bzentse bzomwe nin'kuuza. ");
INSERT INTO nyu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ndoko ku thanga, ukanditengere tumbuzi tuwiri twakunenepa bwino, kuti ndiphike cakudya cakukoma comwe baba wako ambafuna. ");
INSERT INTO nyu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ukapereke cakudyaco kwa baba wako kuti akadye, ndipo akudalise akanati kufa”. ");
INSERT INTO nyu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tsono Jakobo adauza mai wace kuti: “Muli kudziwa kuti Izau ni waukuse, tsono ine khanda langu ni lakunyalala. ");
INSERT INTO nyu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Pinango baba wangu an'dzandimpsampsadzira, ndipo an'dzadziwa kuti ndili kumunyengeza. Na tenepo mmbuto mwa kundidalisa, an'dzanditemberera”. ");
INSERT INTO nyu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mai wace adatawira kuti: “Mwana wangu, temberero lacelo lidzagwere ine, nee iwe. Iwepo utondocita bzomwe ndakuuza, kanditengere tumbuzito”. ");
INSERT INTO nyu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Na tenepo Jakobo adayenda kukatenga tumbuzito acikapasa mai wace, ndipo Rebeka adaphika cakudya cakukoma comwe babayo akhafuna. ");
INSERT INTO nyu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Patsogolo pace Rebeka adatenga bzakubvala bzabwino bza Izau bzomwe akhakoya m'nyumba, adabvazika mng'ono wace Jakobo. ");
INSERT INTO nyu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Adamubvazika pomwe makhanda ya tumbuzi mmaboko mwace ndipombo pakhosi pace pakunyalala pakusaya ukuse. ");
INSERT INTO nyu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ndipo adatenga cakudya cakukoma cire na pau yakukondza bwino, adapasa Jakobo. ");
INSERT INTO nyu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jakobo adayenda kuna baba wace, adamucemera kuti: “Baba!” Izaki adabvunza kuti: “Kodi ndiwe mwana wangu uponi?” ");
INSERT INTO nyu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakobo adatawira kuti: “Ndine Izau mwana wanu mkulu, ndipo bzire mwandiwuza ndacita. Ndaphata minyendo mukani, khazikikani, mudye nyama ya mthengo ndakubwereseraniyi, ndipo mundidalise”. ");
INSERT INTO nyu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Pamwepo Izaki adabvundza kuti: “Kodi nyama imweyi waigumana tani mwakamkulumize tenepayu, mwanangu?” Jakobo adatawira kuti: “Mbuya, Mulungu wanu, andithandiza kuti ndiigumane”. ");
INSERT INTO nyu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Izaki adauza Jakobo kuti: “Fendera pafupi ndikupsapsadzire, kuti ndidziwe penu ndiwe cadidi mwana wangu Izau, penu nee”. ");
INSERT INTO nyu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakobo adafendera pafupi na baba wace, ndipo baba waceyo adamupsapsadzira aciti: “Falali ni la Jakobo, tsono mabokoya ni ya Izau”. ");
INSERT INTO nyu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Alibe kumudziwa Jakobo pakuona kuti maboko yace yakhali yaukuse ninga ya Izau. Na tenepo adayamba kumdalisa. ");
INSERT INTO nyu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Tsono adabvunza pomwe kuti: “Kodi ndiwe cadidi mwana wangu Izau?” Jakobo adatawira pomwe kuti: “Ndine cadidi”. ");
INSERT INTO nyu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Pamwepo Izaki adati: “Bwera nayo kuno nyama ya mthengo yako, kuti ndidye ndipo ndikudalise”. Jakobo adabwera na nyamayo, Izaki adadya, Jakobo acimupasa pomwe vinyu acimwa. ");
INSERT INTO nyu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ndipo baba waceyo adati: “Bwera pafupi, udzandikumbatire, mwanangu”. ");
INSERT INTO nyu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Atabwera pafupi kudzamkumbatira Izaki adamununkhiza bzakubvala bzomwe Jakobo akhadabvala, ndipo pamwepo adamudalisa, adati: “Pfungo labwino la mwana wangu lili ninga pfungo la bzakubvuna bza m'munda omwe Mbuya adaudalisa. ");
INSERT INTO nyu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mulungu akubvumbisire mvula, ndipo minda yako ikhale yakubala bwino. Akupase bzakudya na bzakumwa bzizinji. ");
INSERT INTO nyu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Wanthu ambakutumikire, mitundu ya wanthu ikugodamire. Ukhale wakutonga pakati pa abale wako, bzizukulu bza mai wako bzimbakugodamire. Atembereredwe wentse wakukutemberera, tsono adalisidwe wentse wakukudalisa”. ");
INSERT INTO nyu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Izaki atamaliza kudalisa, Jakobo adacoka. Nthawe imweyo adafika Izau kucokera kuusodzi kule. ");
INSERT INTO nyu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Iyembo adaphika cakudya cakukoma cire, adakapereka kuna baba wace. Izauyo adati: “Ndaphata minyendo baba mukani, khazikikani, mudye nyama ya mthengo yomwe ine mwana wanu ndakubwereserani, ndipo mundidalise”. ");
INSERT INTO nyu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Izaki adamubvundza kuti: “Kodi iwembo ndiwe yani?” Iye adatawira kuti: “Ndine mwana wanu mkulu Izau”. ");
INSERT INTO nyu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Pamwepo Izaki adayamba kutetemera thupi lense, adabvunza kuti: “Kodi ule adapha nyama acibwera nayo kuna ine ule mbani? Ndadya kale imweyo, iwe ukanati kubwera. Ndamudalisa kale, ndipo madaliso yamweyo ni yace mpaka kuyenda-na-kuyenda”. ");
INSERT INTO nyu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Izau atabva bzimwebzo, adawawidwa mum'tima acilira kwene-kwene, ndipo adati: “Baba, ndaphata minyendo inembo mundidalisembo”. ");
INSERT INTO nyu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tsono Izaki adatawira kuti: “Mng'ono wako wabwera, ndipo wandinyengeza. Umweyo ndiye omwe watenga madaliso yako yentse”. ");
INSERT INTO nyu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Pamwepo Izau adati: “Kamweka nkaciwiri kundicenjerera iye ule. Bzakudodomesa lini kuti dzina lace ni Jakobo. Ukulu bwangu bwa umwana wakuyamba adanditengera, ndipo tsapano wanditengera pomwe madaliso yangu. Kodi madalisoyo mulibe kundikoyera na pang'ono pokha?” ");
INSERT INTO nyu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Izaki adatawira Izauyo kuti: “Ndamudalisa kale umweyo kuti akhale wakutonga iwe, ndipo abale wace wentse ndawasandusa anyagrinya wace. Ndampasa bzakudya na bzakumwa bzace. Kodi tsapano casalambo n'ciyani cakuti ndikucitire iwe mwanangu?” ");
INSERT INTO nyu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Izau adapitiriza kukumbira baba waceyo kuti: “Kodi baba, muna daliso libodzi lokha basi? Inembo ndidalisenimbo, baba”. Na tenepo adayamba pomwe kulira. ");
INSERT INTO nyu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ndipo Izaki, baba waceyo, adamuuza kuti: “Mui wako un'dzakhala kutali kwa mataka ya ndovolo, mbvula in'dzabvumba lini pa minda yako. ");
INSERT INTO nyu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Basa lako lin'dzakhala lakumenya nkhondo, ndipo un'dzakhala nyagrinya wa m'bale wako. Tsono ukadzamala kubzitsudzula, un'dzacholeratu joki mkhosi mwako”. ");
INSERT INTO nyu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Na tenepo Izau adawenga Jakobo thangwe lakuti pambuto yakudalisa iye, baba wace adadalisa Jakobo. Ndipo adati: “Nthawe yakuti ndilire nkhawa ya baba wangu ili pafupi, pamwepo ndin'dzamupha Jakoboyu”. ");
INSERT INTO nyu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Tsono Rebeka atabva bzakukumbuka bzentse bza Izau, adacemera Jakobo acimuuza kuti: “Wona, m'bale wako Izau ali kukumbuka bzakuti akuphe kuti m'tima wace ukhazikike. ");
INSERT INTO nyu_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tsapano mwana wangu, ucite bzomwe nin'kuuza. Konzeka, thawira kuna nkhosve yangu Labani ku Harani. ");
INSERT INTO nyu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ubakakhale kuna umweyo ntsiku zakusaya kulewengeka, ");
INSERT INTO nyu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","mpaka kupsa m'tima kwa m'bale wako kumale aciyebwa bzentse bzomwe wamcitabzi. Panthaweyo, ine ndin'dzatuma munthu kudzakutenga. Kodi nditairenyi imwe wana wangu awiri pa ntsiku ibodzi?” ");
INSERT INTO nyu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka adauza Izaki kuti: “Akazi aHitiwa, ine ndaneta nawo! Jakobo akalowola winango mwa aHiti wakunowa, kodi kwa ine moyoyo nguponi?” ");
INSERT INTO nyu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Pamwepo Izaki adacemera Jakobo acimudalisa, ndipo adamuuza kuti: “Lekakulowola mkazi wa kuno ku Kanani. ");
INSERT INTO nyu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Konzeka, uyende ku Mesopotamiya, kumui kwa Betuele, baba wa mai wakoyu. Kumweko ukalowole m'bodzi mwa wana acikazi wa Labani, nkhosve ya mai wako. ");
INSERT INTO nyu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mulungu Wamphambvu-zentse akudalise malowozi yako, ndipo akupase wana aziji, kuti udzakhale gulu likulu la mitundu izinji ya wanthu. ");
INSERT INTO nyu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Akudalise iwe pabodzi na bzizukulu bzako ninga momwe adadalisira Abrahamu, kuti lidzakhale lako cadidi dziko lomwe un'kakhalalo, dziko lomwe adapasa Abrahamu”. ");
INSERT INTO nyu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Na tenepo Izaki adatumiza Jakobo kuMesopotamiya kwa Labani, mwana wa Betuele muAramu. Labani akhali nkhosve ya Rebeka mai wa Jakobo na Izau. ");
INSERT INTO nyu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Tsapano Izau adawona kuti Izaki wadalisa Jakobo, ndipo kuti Jakoboyo watumizidwa ku Mesopotamiya kuti akalowole kumweko. Adabva pomwe kuti pakumudalisapo, adamuuza kuti aleke kudzalowola mkazi wa ku Kanani. ");
INSERT INTO nyu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Adabva kuti Jakobo wabvera baba wace na mai wace, ndipo kuti wayenda ku Mesopotamiya. ");
INSERT INTO nyu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Pamwepo Izau adadziwa kuti baba wace Izaki akhawafuna lini akazi wa ku Kanani. ");
INSERT INTO nyu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Na tenepo adayenda kuna Jumayere mwana wa Abrahamu, acilowola Maharati mwana wa Jumayere, mpfumakazi ya Nebayoti. ");
INSERT INTO nyu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakobo adaguduka kucoka ku Beereseba, aciyenda ku Harani. ");
INSERT INTO nyu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Atafika pambuto panango, adaima pamwepo thangwe dzuwa likhadamira. Adagona pamwepo acitsamira mwala. ");
INSERT INTO nyu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ndipo adalota ali kuwona matambiko kucokera pansi mpaka kukafika kudzulu. Anju za Mulungu zikhabuluka na kumbakwira pa matambikoyo. ");
INSERT INTO nyu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mbuya adaimirira pambali pace acimuuza kuti: “Ine ndine Mbuya, Mulungu wa kholo lako Abrahamu na wa Izaki. Dziko udagonali nin'dzakupasa iwe pabodzi na bzizukulu bzako. ");
INSERT INTO nyu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Bzizukulu bzakobzo bzin'dzawanda ninga pfumbi la pa dziko la pansi. Bzin'dzabalalikira ku mbuto zentse: Kumabvadzuwa, kumadokero, kudzaulu na kunyansi. Ndipo mitundu yentse ya pa dziko la pansi in'dzadalisidwa kucokera mwa iwe na bzizukulu bzako. ");
INSERT INTO nyu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ndiri nawe, nin'dzakukhocherera kuli-kwense komwe un'dzayenda, ndipo nin'dzakubweza pomwe mdziko lino. Nin'dzakusiya lini mpaka ndatacita bzentse ndakuuzabzi”. ");
INSERT INTO nyu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jakobo pomwe adamuka adati: “Cadidi Mbuya ali pano, ndipo ine ndikhadziwa lini”. ");
INSERT INTO nyu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ndipo adabva mantha, adalewa kuti: “Hi, mbuto ino ni yakugopswa! Cadidi pano ni nyumba ya Mulungu ndipombo msuwo wa kudzulu”. ");
INSERT INTO nyu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jakobo adalamuka macibese-bese, adatenga mwala akhadatsamira ule, aciuimisa kuti ukhale mwala wacikumbuso. Ndipo adauikha mafuta mwalayo. ");
INSERT INTO nyu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ndipo mbutoyo adaicemera Betele. Pakuyamba muiwo ukhacemeredwa Luzi. ");
INSERT INTO nyu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Pamwepo Jakobo adalumbira kuna Mulungu, adati: “Mungakhala nande na kundikhocerera pa ulendo wanguyu, ndipo mungandipasa cakudya na bzakubvala, ");
INSERT INTO nyu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","na kundibwezera bwino kwathu kuna baba wangu, mun'dzakhala Mulungu wangu. ");
INSERT INTO nyu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Mwala wacikumbuso ndaimisayu un'dzakhala nyumba yanu, ndipo ine pa bzentse bzomwe mun'dzandipasa nin'dzakupasani cacikhumi”. ");
INSERT INTO nyu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ndipo Jakobo adapitiriza ulendo bwace, kuyenda kudziko la Mesopotamiya. ");
INSERT INTO nyu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Atafika adaona mcera ku ubusa, ndipombo mithithi itatu ya mabira yadagona pambali pa mcerayo. Mabirayo yakhamwa mcera umweyo omwe padzulu pace pakhana mwala ukulu. ");
INSERT INTO nyu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Mabira yentseneyo yakakhumanira pabodzi kumweko, abusa ndiwo wakhacosa mwalayo pamcerapo, kuti mabira yawoyo yamwe. Yakamala kumwa, wakhakukhuliza pomwe mwalayo acifunga mcerayo. ");
INSERT INTO nyu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakobo adabvunza abusawo kuti: “Kodi abale wangu mulikucokera kuponi?” Iwo adatawira kuti: “Tilikucokera ku Harani”. ");
INSERT INTO nyu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Jakobo adawabvunza pomwe kuti: “Kodi Labani mzukulu wa Nahori mumbamundziwa?” Iwo adatawira kuti: “Ee, timbamudziwa”. ");
INSERT INTO nyu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Adawabvunza pomwe kuti: “Kodi ali bwino?” Iwo adatawira kuti: “Ee, ali bwino. Nguyo Rakeli, mwana wace, ali kubwera na mabirayo”. ");
INSERT INTO nyu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ndipo Jakobo adati: “Pakuona kuti yakhali masikati, tsono nthawe yakukafungira ikanati kukwana, tani kuti muyamwese, muciyatenga kukayadyesa?” ");
INSERT INTO nyu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Iwo wale adatawira kuti: “Tin'kwanisa lini bzobzo mpaka mabira yentse yakhumanire pabodzi, ndipo mwala wa padzulu pa ncerayo tikaukukhuliza. Pamwepo tingakwanise kuyapasa madzi mabirayo”. ");
INSERT INTO nyu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jakobo alikupitirizakulewa-lewa na iwo, Rakeli adafika na mabira ya baba wace. Umweyo ndiye akhausa mabirayo. ");
INSERT INTO nyu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jakobo ataona Rakeli ali na mabira ya baba wace Labani, adayenda kuncera kule, adakukhuliza mwalayo, aciyamwesa mabira ya Labaniyo. ");
INSERT INTO nyu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ndipo Jakobo adamukumbatira Rakeliyo, adalira mwakukuwa. ");
INSERT INTO nyu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ndipo adamuuza kuti: “Ine ndine mwana wa Rebeka, mpfumakazi ya baba wako”. Pamwepo Rakeli adathamanga kukauza baba wace. ");
INSERT INTO nyu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani atabva bza Jakobo mwana wa mpfumakazi yace, adathamanga kagumana naye. Adamkumbatira, acimumpsompsona, adayenda naye kunyumba. Ndipo Jakobo adafotokozera Labani bzentse bzomwe bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Pamwepo Labani adamuuza kuti: “Inde, cadidi, iwe ndiwe m'bale wangu caiye-iye”. Jakobo adakhala kumweko mwezi wense. ");
INSERT INTO nyu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ndipo Labani adauza Jakobo kuti: “Un'themera lini kundiphatira basa lakusaya sagwati, thangwe lakuti mbubale bwathu. Undiwuze bzomwe ulikufuna kuti ndikulipire”. ");
INSERT INTO nyu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labani akhali na wana acikazi awiri, wakuyamba akhali Leya, mng'ono akhali Rakeli. ");
INSERT INTO nyu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya akhali na maso yakudeka, tsono Rakeli akhali ciphadzuwa. ");
INSERT INTO nyu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakobo akhambafuna Rakeli, ndipo adati: “Nin'dzakuphatirani basa magole manomwe thangwe la mwana wanu Rakeli”. ");
INSERT INTO nyu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Na tenepo Labani adati: “Ni bwino kwene-kwene kuti Rakeliyu ndipase iwe, kuposa munthu winango ali-yentse. Khala na ine”. ");
INSERT INTO nyu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Na tenepo Jakobo adaphata basa magole manomwe kuti alowole Rakeli, ndipo nthawe imweyo adandokuiwona ninga ntsiku zing'ono-ng'ono basi, thangwe lakuti akhamufuna kwene-kwene mkaziyo. ");
INSERT INTO nyu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jakobo adauza Labani kuti: “Tsapano nthawe zamala. Ndipaseni mwana wanuyu kuti ndimulowole”. ");
INSERT INTO nyu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Na tenepo Labani adakonza cikondweso la malowozi, adacemela wanthu wentse wakomweko. ");
INSERT INTO nyu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tsono usiku bumwebo Labani adatenga Leya adapasa Jakobo, ndipo Jakobo adagona na Leya. ");
INSERT INTO nyu_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Nthawe imweyo Labani adapereka pomwe nyagrinya wace Zilipa kuna Leya.) ");
INSERT INTO nyu_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kwatacena, Jakobo adaona kuti mkaziyo ni Leya. Ndipo adabvunza Labani kuti: “Thangwe lanyi mwandicita bzimwebzi? Kodi ndiribe kukuphatirani basa kuti ndilowole Rakeli? Tsono thangwe lanyi mwandinyengeza?” ");
INSERT INTO nyu_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani adatawira kuti: “Ni mwambo wathu lini kuno kulowoza mng'ono, mkulu wace akanati kulowodwa. ");
INSERT INTO nyu_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Dikhira, toma wamaliza mdzinga uno wa cikondweso ca malowozi, pambuyo pace nin'dzakupasa Rakeli, tsonotu un'dzandiphatira pomwe basa magole yanango maxanu na mawiri”. ");
INSERT INTO nyu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakobo adabvuma, ndipo mdzinga wa cikondwerero camalowozi watamala, Labani adapereka Rakeli kuna Jakobo kuti akhale mkazi wace. ");
INSERT INTO nyu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Nthawe imweyo Labani adapereka pomwe nyagrinya wace Biliha kwa Rakeli.) ");
INSERT INTO nyu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Na tenepo Jakobo adagona na Rakeli, tsono adamufuna kuposa Leya. Ndipo adaphata pomwe basa kwa Labani magole yanango manomwe. ");
INSERT INTO nyu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mbuya ataona kuti Jakobo akhanyoza Leya, adam'fungula nthumbo Leyayo, tsono Rakeli akhali ngomwa. ");
INSERT INTO nyu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya adatenga mimba, ndipo adabala mwana wacimuna. Ndipo adati: “Mbuya wawona kubonera kwangu. Cadidi tsapano mwamuna wangu an'dzayamba kundifuna”. Na tenepo mwanayo adamucemera Rubeni. ");
INSERT INTO nyu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Adatenga pomwe mimba, adabala mwana winango wacimuna, ndipo adati: “Mbuya wandipasa pomwe mwana wacimuna, thangwe adabva kuti mwamuna wangu akhandinyoza”. Na tenepo mwanayo adamucemera Simeoni. ");
INSERT INTO nyu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Adatenga pomwe mimba, acibala pomwe mwana wacimuna, ndipo adati: “Tsapano mwamuna wangu an'dzandinyoza lini, pakuona kuti ndamubalira wana wacimuna atatu”. Na tenepo mwanayo adamucemera Levi. ");
INSERT INTO nyu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Adatenga pomwe mimba, acibala pomwe mwana wacimuna, ndipo adati: “Tsapano ndin'dzatumbiza Mbuya”. Na tenepo mwanayo adamucemera Juda. Pamwepo adabakaima kubala. ");
INSERT INTO nyu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rakeli ataona kuti ali kumubalira lini wana Jakobo, adayamba kucita njiru na mkulu wace ule, ndipo adauza Jakobo kuti: “Mundipase wana, ayai ndinifa basi”. ");
INSERT INTO nyu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakobo adam'kalipira Rakeli, acimuuza kuti: “Ndiri lini mmbuto mwa Mulungu. Umweyo ndiye ali kukuletsa kubala wana”. ");
INSERT INTO nyu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Pamwepo Rakeli adati: “Nguyu nyagrinya wangu Biliha, gona naye kuti andibalire mwana. Na tenepo kucokera mwa iye, inembo nin'dzakhala na wana”. ");
INSERT INTO nyu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Na tenepo Rakeli adapereka Biliha kwa mwamuna wace, ndipo adagona naye. ");
INSERT INTO nyu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliha adatenga mimba adamubalira Jakobo mwana wacimuna. ");
INSERT INTO nyu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ndipo Rakeli adati: “Mulungu watonga mwakundikomera m'tima. Wabva mpembo wangu, ndipo wandipasa mwana wacimuna”. Na tenepo mwanayo adamucemera Dani. ");
INSERT INTO nyu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha nyagrinya wa Rakeli adatenga pomwe mimba adamubalira pomwe Jakobo mwana wacimuna. ");
INSERT INTO nyu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Pamwepo Rakeli adati: “Ndanesana naye kwene-kwene mkulu wangu, ndipo ndakunda”. Na tenepo mwanayo adamucemera Nafutali. ");
INSERT INTO nyu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leya ataona kuti wasiya kubala, adapereka nyagrinya wace Zilipa kuna Jakobo. ");
INSERT INTO nyu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ndipo Zilipa adabala mwana wacimuna. ");
INSERT INTO nyu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ndipo Leya adati: “Ndacita mwayi”. Na tenepo mwanayo adamucemera Gadi. ");
INSERT INTO nyu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilipa nyagrinya wa Leyayo adamubalira pomwe Jakobo mwana wacimuna waciwiri. ");
INSERT INTO nyu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Pamwepo Leya adati: “Ndakondwera! Ndipo akazi an'dzandicemera wamwayi”. Na tenepo mwanayo adamucemera Asere. ");
INSERT INTO nyu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Panthawe yakugwata tirigu, Rubeni adayenda ku minda, adagumana bzisapo bza mankhwala yakuthandiza akazi ndipo adadzapasa Leya mai wace. Rakeli adauza Leya kuti: “Ndaphata minyendo ndipasembo mankhwala yomwe mwana wako wakubweresera”. ");
INSERT INTO nyu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya adatawira kuti: “Kodi ulibe kukwanirisidwa na mwamuna wangu udanditengera ule? Tsapano un'funa kunditengera pomwe mankhwala yakuthandiza akazi yomwe mwana wangu wandinyanganira?” Rakeli adati: “Ungandipasa mankhwala yakucokera kwa mwana wakoya, mwamunayu an'gona na iwe usiku uno”. ");
INSERT INTO nyu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Pamwepo Jakobo akhabwera maulo kucokera ku munda, Leya adabula kukamumusa, aciti “Lero mugone kuno, thangwe la mankhwala yomwe yandinyanganira mwana wangu”. Na tenepo Jakobo adagona na Leya usiku bumwebo. ");
INSERT INTO nyu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Mulungu adabva mpembo wa Leya, na tenepo adatenga mimba, adamubalira Jakobo mwana wacixanu wacimuna. ");
INSERT INTO nyu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ndipo adati: “Mulungu wandipasa mphatso thangwe ndidapereka nyagrinya wangu kwa mwamuna wangu”. Na tenepo mwanayo adamucemera Isakara. ");
INSERT INTO nyu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya adatenga pomwe inango mimba, adamubalira Jakobo mwana wacimuna wacitanthatu. ");
INSERT INTO nyu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ndipo adati: “Mulungu wandipasa mphatso yabwino. Tsapano mwamuna wangu an'dzakhala nande thangwe ndamubalira wana wacimuna tanthatu”. Na tenepo mwanayo adamucemera Zebuloni. ");
INSERT INTO nyu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Patsogolo pace adabala mwana wacikazi, adamucemera Dina. ");
INSERT INTO nyu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ndipo Mulungu adakumbukira Rakeli, adabva mpembo wace, adamufungula nthumbo. ");
INSERT INTO nyu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Iyembo adatenga mimba, adabala mwana wacimuna. Ndipo adati: “Mulungu wandicosa manyazi ya ungomwa bwangu”. ");
INSERT INTO nyu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Na tenepo mwanayo adamucemera Zuze, adalewa kuti: “Mulungu andithimizire mwana winango”. ");
INSERT INTO nyu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Tsono pomwe Rakeli adabadwa Zuze, Jakobo adauza Labani kuti: “Mundibvumize ndibwerere kwathu. ");
INSERT INTO nyu_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ndipaseni akazi wangu ndakuphatirani basa, pabodzi na wana wangu, ndipo ndicoke. Muli kudziwa kuti ndakuphatirani bwino basa”. ");
INSERT INTO nyu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labani adamuuza kuti: “Undibvumize kuti ndirewe mafala aya, ‘Ine mwakuwombeza ndadziwa cadidi kuti Mbuya wandidalisa thangwe la iwe. ");
INSERT INTO nyu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ndiuze sagwati yako, ndikupase.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakobo adatawira kuti: “Muli kudziwa momwe ndakuphatirani basa, na momwe bzifuwo bzanu bzabalirana kwene-kwene pakubzikoya ine. ");
INSERT INTO nyu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kale mukhali na bzifuwo pang'ono tsono tsapano bzawanda, ndipo Mbuya wakudalisani thangwe la ine. Tsapano nin'funika kukhongobza banja langu”. ");
INSERT INTO nyu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Pamwepo Labani adamubvundza kuti: “Kodi ndikulipire ciyani?” Jakobo adatawira kuti: “Ndin'funa lini sagwati inango iliyense. Tsono ndidzapitiriza kukuusirani bzifuwo bzanu, mukatawira kucita bzomwe ndinilewa. ");
INSERT INTO nyu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Lero ndiniyenda pakati pa bzifuwo bzanu bzentse. Ndinpambura mabira yentse mapswipa, ndipombo mbuzi zentse zamabangamabanga na zamathothomathotho. Sagwati yomwe ndinfuna ine ni bzomwebzo. ");
INSERT INTO nyu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Pambuyo pace mun'dzazindikira penu ndacita bzimwebzi mwakulungama pomwe mun'dzabwera kudzawona sagwati yangu. Mukadzaona kuti ndina mbuzi yakusaya mathotho penu mabanga penu mwana wa bira omwe ni musvipa lini, mudzadziwe kuti cimweco ni cakuba”. ");
INSERT INTO nyu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani adatawira, adati: “Inde. Ticite ninga waleweramo”. ");
INSERT INTO nyu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tsono ntsiku imweyo, Labani adacosa atonde wentse wamathotho-mathotho na wamabanga-mabanga, na pomwe mbuzi zikazi zamathotho-mathotho na zamabanga-mabanga, zentse za mabanga yacena. Adacosa pomwe mabira yentse mapswipa, aciuza wana wace kuti wabzikhongobze bzifuwo bzensenebzo. ");
INSERT INTO nyu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Na tenepo adamwazana naye Jakobo ule adayenda nthawe ya n'tsiku zitatu. Nthawe imweyo Jakoboyo akhausa bzifuwo bzina bza Labani. ");
INSERT INTO nyu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ndipo Jakobo adatenga mithawi iwisi ya mitundu itatu ya miti ya mudzikomo, adaisvukula icicena. ");
INSERT INTO nyu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Mithawiyo adaiikha patsogolo pa bzimiyadiya bzikhamwera madzi bzifuwobzo, kuti bzifuwobzo bzimbawone mithawi ire pakumwa madzi, thangwe bzifuwobzo bzikhambakwirana pakudzamwa madzi. ");
INSERT INTO nyu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Na tenepo bzifuwobzo bzikhatenga madzamu bzidanyang'ana mithawiyo, ndipo wana wace wakhakhala na mawonekedwe ya mathotho-mathotho ndipombo ya mabanga-mabanga. ");
INSERT INTO nyu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jakobo adapambula maphandauzi ya mabira, aciyaikha mabira yanango kuti yanyang'anisane na bzifuwo bza Labani bzamathotho-mathotho na mapswipa. Mwa njira imweyi adakwanisa kuwona bzifuwo bzace, ndipo alibe kubzisanganiza na bzifuwo bza Labani. ");
INSERT INTO nyu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Nthawe zentse pomwe bzifuwo bzamphambvu bzikhambakwiriwa, Jakobo akhambabziikira mithawi ire kutsogolo kwacene pa mbuto yakumwera, kuti tenepo bzitenge madzamu pafupi na mithawiyo. ");
INSERT INTO nyu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tsono kwa bzifuwo bzakutepa, akhabziikha lini mithawi ire. Na tenepo bzifuwo bzikhakhala bzakutepa bzikhali bza Labani, tsono bzamphambvu bzikhali bza Jakobo. ");
INSERT INTO nyu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mwa njira imweyi Jakobo adadala kwene-kwene. Adakhala na bzifuwo bzizinji, anyagrinya wacimuna na acikazi, ngamira na mabulu. ");
INSERT INTO nyu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jakobo adabva kuti wana wa Labani akhalewa kuti: “Jakobo watenga bzentse bza baba wathu. Wadala na cuma ca baba wathu”. ");
INSERT INTO nyu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakobo adazindikira pomwe kuti Labani akhadzamunyang'ana lini na nkhope yabwino ninga kale. ");
INSERT INTO nyu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ndipo Mbuya adamuuza kuti: “Bwerera ku dziko la baba wako na kuna abale wako. Ine nin'dzakhala nawe”. ");
INSERT INTO nyu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ndipo Jakobo adatumiza mafala kuna Rakeli na kwa Leya kuti akagumane naye kuubusa komwe kukhana bzifuwo bzace. ");
INSERT INTO nyu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Atafika, iye adawauza kuti: “Ndaona kuti baba wanu tsapano ali kundinyang'ana lini na nkhope yabwino ninga kale. Tsono Mulungu wa baba wangu wakhala nande. ");
INSERT INTO nyu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mwense awirimwe muli kudziwa bwino kuti ndidaphata basa kwa baba wanu na mphambvu zangu zentse. ");
INSERT INTO nyu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Tsono iye wandikhulukha, ndipo sagwati yangu wacinja-cinja kakhumi. Tsono Mulungu alibekumubvumiza kuti andicite cakuipa. ");
INSERT INTO nyu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nthawe iri-yentse Labani akalewa kuti: ‘Bzifuwo bzamathotho-mathotho bzin'dzakhala sagwati yako,’ bzifuwo bzense bzikhakhala bzamathotho-mathotho. Tsono akalewa kuti: ‘Bzamithemba-mithemba bzin'dzakhala sagwati yako,’ bzifuwo bzense bzikhandokhala bzamithemba-mithemba. ");
INSERT INTO nyu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Mulungu watenga bzifuwo bzense kwa baba wanu, wapasa ine. ");
INSERT INTO nyu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Panthawe yakuti bzifuwo bzin'tenga madzamu, ine ndidalota, ndipo ndidaona kuti atonde omwe akhakwirawo akhali wamithemba-mithemba, wamathotho-mathotho na wamabanga-mabanga. ");
INSERT INTO nyu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ndipo anju wa Mulungu adalewa-lewa nande mukulota acindicemera kuti: ‘Jakobo,’ ine ndidatawira kuti: ‘Ndiri pano!’ ");
INSERT INTO nyu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Iye adati, ‘Nyang'ana, ndipo uwone kuti atonde wentse omwe alikukwirawa ni wamithemba-mithemba, wamathotho-mathotho na wamabanga-mabanga. Bzimwebzi ndacita ndine, thangwe ndawona bzomwe Labani ali kukucita. ");
INSERT INTO nyu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ine ndine Mulungu omwe ndidakuwonekera ku Betele kule komwe udaimisa mwala wacikumbuso na kuudzoza mafuta, ndipo kumweko iwe udalumbira. Konzeka tsapano, ucoke kuno, ubwerere ku dziko kwanu.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rakeli na Leya adatawira kuti: “Palibe comwe casala ife kwa baba wathu cakuti cikhale nthaka yathu. ");
INSERT INTO nyu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ife baba wathu ali kutiyesa alendo. Adatigulisa, ndipo kobiri zomwe adatambira pa ifezo, adazidzonga zentse. ");
INSERT INTO nyu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Cuma centse comwe Mulungu wacosa kuna baba wathu, ni cathu na wana wathu. Citani bzomwe Mulungu wakuuzani”. ");
INSERT INTO nyu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Na tenepo Jakobo adakonzekera kuti acoke, kubwerera kuna baba wace ku dziko la Kanani. Ndipo wana wace wentse pabodzi na akazi wacewo adawakwiza pa ngamira. ");
INSERT INTO nyu_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ndipo bzifuwo bzense adabzitsogoza acimbabziusa, pabodzi na bzense bzomwe adakwanisa ku Mesopotamiya kule. ");
INSERT INTO nyu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labani akhadayenda kukagwata ukuse mabira. Ndipo akanati kubwerera, Rakeli adaba tumirungu twa m'nyumba ya Labani, baba wace. ");
INSERT INTO nyu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Na tenepo Jakobo adamunyenga Labani Mwaramu ule pakusaya kumuuza kuti alikucoka. ");
INSERT INTO nyu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Adatenga bzace bzense, acicoka mwakuthawa. Adanyamuka, aciyambuka mkulo wa Yufurate, n'kuyamba ulendo wakuyenda ku dziko lamapiri la Giliyadi. ");
INSERT INTO nyu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Patapita n'tsiku zitatu, Labani adabva kuti Jakobo adathawa. ");
INSERT INTO nyu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ndipo adatenga abale wace, acimutewera Jakoboyo ntsiku zinomwe, mpaka adakamgumana ku dziko lamapiri la Giliyadi. ");
INSERT INTO nyu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Labani Mwaramu ule adalota usiku bumwebo. Mulungu adabwera acimuuza kuti: “Leka kumugopswa Jakobo mwa njira iliyense”. ");
INSERT INTO nyu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labani adagumana Jakobo atamanga bzikumbi kumapiriko. Na iyembo Labani adamanga bzikumbi bzace komweko ku dziko lamapiri la Giliyadi. ");
INSERT INTO nyu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labani adabvunza Jakobo kuti: “Thangwe lanyi wandimbzenga ucitenga wana wangu acikazi ninga wakuphatiwa pa nkhondo? ");
INSERT INTO nyu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Thangwe lanyi wandithawa ucindimbzenga nee kundiuza? Ungadandiwuza, m'psino ndakubvumiza mwakupfatsa, ndipo tingadaimba nyimbo na ng'oma na azeze. ");
INSERT INTO nyu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ulibe kundibvumiza kuti ndigonekane na azukulu wangu na wana wangu. Udacita bzaupsiru. ");
INSERT INTO nyu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ndina mphambvu zakukucita cakuipa. Tsono usiku wapitayu, Mulungu wa baba wako wandiwuza kuti: ‘Leka kumugopswa Jakobo mwa njira iliyense.’ ");
INSERT INTO nyu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ndilikudziwa kuti udacoka thangwe ukhafunisisa kubwerera kwanu. Tsono thangwe lanyi wandibera tumilungu twangu?” ");
INSERT INTO nyu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakobo adatawira kuti: “Ndikhagopa, thangwe ndikhakumbuka kuti mun'ditengera wana wanuwa. ");
INSERT INTO nyu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tsono mukatugumana kuna munthu ali-wentse pano ana tumirungu twanu, umweyo aphedwe. Wanthu wathuwa akhale mboni pano pomwe imwe munyang'ane bzinthu bzanu mumitolo yanguyi. Ndipo mukabziona bzanubzo mutenge”. Jakobo pamwepo akhadziwa lini kuti Rakeli adaba tumirunguto. ");
INSERT INTO nyu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labani adapita m'cikumbi ca Jakobo na m'cikumbi ca Leya ndipombo m'cikumbi ca anyagrinya awiri wale, tsono alibe kutuona tumilungu twaceto. Patsogolo pace adapita m'cikumbi ca Rakeli. ");
INSERT INTO nyu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rakeliyo akhadabisa tumirungu twa mnyumba ya Labani, akhadatuikha m'budu wa pamsana pa ngamira, iye acikhalira m'buduyo. Labani adanyang'ana-nyang'ana mcikumbi mwentsenemo, tsono alibe kutuwona. ");
INSERT INTO nyu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rakeli adauza baba wace kuti: “Lekani kundikalipira, baba, na kusaya kuimirira pamaso panu, thangwe lakuti macitidwe ya ife akazi yali kuna ine”. Na tenepo Labani alibe kutuwona tumirungu twa mnyumba mwace. ");
INSERT INTO nyu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Pamwepo Jakobo adapsa m'tima kwene-kwene ndipo adadandaula kwa Labani mwaukali, adati: “Kodi ndakuphonyerani ciyani? Kodi ndaphonya mtemo uponi, kuti mundilondole? ");
INSERT INTO nyu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Mwanyangana-nyangana mumitolo yangu yense, kodi mwaona ciyani canu? Comwe mwaonaco muciikhe padeca pano, kuti abale wanu na wanguwa aciwone. Iwo atonge kuti awone mbani waphonya pakati pa ife. ");
INSERT INTO nyu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Tsapano ndakhala namwe magole makumi awiri, ndipo mabira yanu na mbuzi zanu bziribe kupoloza cipo. Ine ndiribe kudya mabvululume ya mthanga mwanu. ");
INSERT INTO nyu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ndiribe kukubweresera nyama ya cifuwo cakuphatidwa na bzirombo. Ine ndikhabwezera nthawe imweyo cifuwo cinango. Mukhafuna kuti ndibwezere cense cakubedwa usiku penu masikati. ");
INSERT INTO nyu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Nthawe zizinji ndikhaneseka na kutentha masikati ndipombo na kudjedjela usiku. Ndikhakwanisa lini kugona tulo. ");
INSERT INTO nyu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tsapano ndakhala na imwe magole makumi mawiri panyumba panu. Ndakuphatirani basa magole khumi na manai thangwe la wana wanu awiriwa, ndipo magole matanthatu ndidaphatira bzifuwo. Tsono sagwati yangu mwacinja-cinja kakhumi. ");
INSERT INTO nyu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Mulungu wa baba wangu, Mulungu wa Abrahamu, Mulungu omwe Izaki akham'gopa, angadasaya kukhala nande, mungadandicosa kale ndiri cimanja-manja. Tsono Mulungu adawona kubonera kwangu na mabasa ya manja yangu, ndipo usiku wapitabu Iye wakugazani”. ");
INSERT INTO nyu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani adatawira Jakobo kuti: “Wana wacikaziwa ni wangu, wana wawo ni wangu na bzifuwo kubodzi. Bzentse uli kuonabzi n'bzangu. Tsapano ndiwacitire ciyani wana wangu wacikaziwa pabodzi na wana wawo? ");
INSERT INTO nyu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Bwera tsapano ticite cipangano, cikhale mboni pakati pa ine na iwe”. ");
INSERT INTO nyu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jakobo adaimisa mwala. ");
INSERT INTO nyu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Adauza abale wace kuti wakonkhe minyala, wagwezeke mudwi. Ndipo pambali pace pa mudwiyo adadyerapo cakudya. ");
INSERT INTO nyu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ndipo mudwiyo Labani adaucemera Yagara-Sahaduta, tsono mudwi womwewo Jakobo adaucemera Galedi. ");
INSERT INTO nyu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Patsogolo pace Labani adati: “Mudwi waminyalayu ukhale cikumbuso kwa ine na iwe”. Ni thangwe lace mbutoyo adaicemera Galedi. ");
INSERT INTO nyu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Labani adalewa pomwe kuti: “Mbuya atilindire ife tonse awiri pomwe tin'kusiyana”. Na tenepo mbutoyo adaicemera Mizipa. ");
INSERT INTO nyu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Labani adapitiriza kulewa kuti: “Ukaboneresa wana wanguwa, ayai ukalowola akazi winango, palibe winango pomwe tiri pano, ukumbukire kuti Mulungu ndiye mboni pakati pa ine na iwe”. ");
INSERT INTO nyu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ndipo Labani adauza Jakobo kuti: “Pano tina minyala yomwe tagwezeka pakati pathu, ndipo pampano pana mwala wacikumbuso. ");
INSERT INTO nyu_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Mudwi umwewu pabodzi na mwala wacikumbusowu, bzensenebzi ni mboni. Ine ndin'dzapitirira lini mudwi umweyu kuti ndipokane nawe. Iwembo leka kudzapitirira mudwiyu kuti upokane na ine. ");
INSERT INTO nyu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Mulungu wa Abrahamu, Mulungu wa Nahori, Mulungu wa baba wawo, ndiye an'dzatitonga ife awiri”. Na tenepo Jakobo adalumbira m'dzina la Mulungu omwe Izaki baba wace akhamugopa. ");
INSERT INTO nyu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ndipo Jakobo adapereka ntsembe paphiripo, adacemera abale wace kuti adzadye cakudya. Atamala kudya, adagona paphiri pamwepo. ");
INSERT INTO nyu_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Macibese-bese, Labani adampsompsona azukulu wace wale pabodzi na wana wace wacikaziwo adawagoneka, ndipo atawadalisa adacoka acibwerera kwace. ");
INSERT INTO nyu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Na iyembo Jakobo adaguduka ulendo bwace, ndipo anju za Mulungu zidagumana naye. ");
INSERT INTO nyu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ataziona, adati: “Uyu ni mthithi wa anyankhondo wa Mulungu”. Na tenepo mbutoyo adaicemera Mahanaimu. ");
INSERT INTO nyu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ndipo Jakobo adatuma atumiki wace kuna Izau mbale wace ku Seiri, ku dziko la Edomu. ");
INSERT INTO nyu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Adawapanganiza kuti akauze Izau kuti: “Ine Jakobo mtumiki wanu ndikhakhala kwa Labani, ndipo ndakhala kumweko kufikira tsapano lino. ");
INSERT INTO nyu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ndina ng'ombe, mabulu, mabira na mbuzi ndipombo anyagrinya wacimuna na wacikazi. Ndirikupanganiza mafala yamweya kuna imwe mbuya wangu, kuti mundikomere m'tima!” ");
INSERT INTO nyu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Atumikiwo atabwerera kwa Jakobo adati: “Tayenda kuna m'bale wanu Izau, ndipo ali kubwera pabodzi na wanthu 400, kudzagumana namwe”. ");
INSERT INTO nyu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Pamwepo Jakobo adabva mantha kwene-kwene acikhala na thupo. Na tenepo adawagawa wanthu omwe akhali nawo mmagulu mawiri, pabodzi na mabira, mbuzi, ng'ombe ndipombo ngamira. ");
INSERT INTO nyu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Iye akhakumbuka kuti: “Izau akabwera, ndipo akacita nkhondo na gulu lakuyamba, gulu linango lin'dzathawa”. ");
INSERT INTO nyu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Pamwepo Jakobo adapemba, aciti: “Mulungu wa kholo langu Abrahamu, Mulungu wa baba wangu Izaki, mundibve ine! Imwe Mbuya mudandiwuza kuti: ‘Bwerera ku dziko lako, dziko la abale wako, ndin'dzakukhongobza kuti bzinthu bzikuyendere bwino.’ ");
INSERT INTO nyu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ine nin'themera lini kucitiridwa nsisi na cikhulupiriro cense comwe mwandiwonesa ine mtumiki wanu. Thangwe pomwe ndidayambuka Jolodani ndikhana mpsimbo yokha, tsono tsapano ndabwerera na magulu mawiriya. ");
INSERT INTO nyu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ndaphata minyendo, ndipulumuseni ku mphambvu za mbale wangu Izau. Ndina mantha kuti pinango ali kubwera kudzatipha tentse, ine pabodzi na akazi na wana kubodzi. ");
INSERT INTO nyu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Kumbukirani fala lanu lire lakuti: ‘Cadidi ndin'dzakukhongobza bwino, ndipo nin'dzakupasa bzizukulu bzizinji bzakusayakulewengeka. Bzin'dzakhala bzakuwanda ninga mcenga wa mmphepete mwa nyanza.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Atagona kumweko, patsogolo pace adam'sankhulira m'bale wace Izau mphatso iyi pa cuma cense comwe akhali naco: ");
INSERT INTO nyu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Mbuzi zikazi 200 na atonde makumi mawiri, mabira yakazi 200 na mabvululume makumi mawiri, ");
INSERT INTO nyu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngamira zakumamisa makumi matatu pabodzi na wana wace, ng'ombe zikazi makumi manai, na mikono khumi, na mabulu yacikazi makumi mawiri na yacimuna khumi. ");
INSERT INTO nyu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Gulu liri-lentse la bzifuwo adalipereka kwa nyagrinya wace, ndipo adawauza kuti: “Imwe mutsogole, ndipo pakuyenda na magulu ya bzifuwo, mumbasiye mbuto pakati pa gulu liri-lentse”. ");
INSERT INTO nyu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Adauza nyagrinya wakutoma kuti: “Mbale wangu Izau angagumana nawe acikubvunza kuti: ‘Kodi mkulu wako mbani? Kodi uli kuyenda kuponi? Kodi bzifuwo bziri patsogolo pakobzi n'bza yani?’ ");
INSERT INTO nyu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Iwe ukatawire kuti: ‘Bzimwebzi ni bza mtumiki wanu Jakobo, ndipo aliukubzitumiza kuna imwe mbuya-wace, kuti bzikhale mphaso. Iyembo ali kubwera m'mbuyo mwathumu.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ndipo adauza pomwe nyagrinya wace waciwiri mafala yabodzi-bodziyo, na wacitatu, mpaka wentse omwe wakhatsogoza bzifuwo. Adawauza kuti: “Bzimwebzi ndibzo mukamuuze Izau, mungagumana naye. ");
INSERT INTO nyu_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Mukamuuze pomwe, ‘Ndipombo mtumiki wanu Jakobo ali kubwera m'mbuyo mwathumu.’ ” Jakobo akhakumbuka kuti: “Angandikhululukire na mphatso yomwe ndam'tumizirayi, ndipo ndikakagumana naye, pinango adzanditambira bwino”. ");
INSERT INTO nyu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Na tenepo mphatso ire idatsogola, ndipo usiku bumwebo Jakobo adagona kubzikumbi kumwekule. ");
INSERT INTO nyu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Usiku bumwebo Jakobo adalamuka adatenga akazi wace awiri, na anyagrinya wace awiri wale, pabodzi na wana wace khumi na m'bodzi, aciyambuka na panjerera mumkulo wa Yaboki. ");
INSERT INTO nyu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Atawayambusa wentse wale, adayambusambo cuma cace cense. ");
INSERT INTO nyu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Iye adasala yekha. Ndipo kudabwera mwamuna m'bodzi omwe adamenya naye mpaka madandakweca. ");
INSERT INTO nyu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mwamunayo ataona kuti ali kukwanisa lini kumukunda, adamenya Jakobo pamwendo acibzuguduka. ");
INSERT INTO nyu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Pamwepo mwamunayo adati: “Ndireke ndiyende, thangwe kulikucena”. Tsono Jakobo adatawira kuti: “Ndin'kusiya lini kuti uyende mpaka undidalise”. ");
INSERT INTO nyu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mwamunayo adamubvundza kuti: “Dzina lako ndiwe yani?” Jakobo adatawira kuti: “Dzina langu ndine Jakobo”. ");
INSERT INTO nyu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Mwamuna ule adati: “Dzina lako lin'dzakhala lini pomwe Jakobo. Wamenyana na Mulungu na wanthu, ndipo wakunda. Na tenepo dzina lako lin'dzakhala Ijirayeri”. ");
INSERT INTO nyu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Pamwepo Jakobo adati: “Na imwembo ndiuzenimbo dzina lanu”. Tsono mwamunayo adati: “Thangwe lanyi uli kundibvunza dzina?” Ndipo pamwepo munthu ule adadalisa Jakobo. ");
INSERT INTO nyu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakobo adati: “Ndamuwona Mulungu maso na maso, ndipo ndikana moyo”. Ndipo mbutoyo adaicemera Penuwele. ");
INSERT INTO nyu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Dzuwa likhacoka pomwe Jakobo akhacoka ku Penuwele, ndipo akhayenda mwakugwidoma thangwe la kubzuguduka kule. ");
INSERT INTO nyu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ndipopo mpaka lero lino bzizukulu bzentse bza Ijirayeri bzimbadya lini nyama yapancafu, thangwe ni pamudzipe wa padzugudu pomwe Jakobo adamenyedwa. ");
INSERT INTO nyu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakobo adaona Izau ali kubwera na amuna wace 400. Na tenepo wana wace wale adawagawira Leya, Rakeli na anyagrinya awiri wale. ");
INSERT INTO nyu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Adatsogoza anyagrinyawo pabodzi na wana wawo. Leya na wana wace akhatewera pambuyo pawo, Rakeli na Zuze akhabwera pambuyo pa wentse. ");
INSERT INTO nyu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jakobo adatsogola, ndipo adagodama acitsulima mpaka pansi kanomwe mpaka adafika pafupi na m'bale wace. ");
INSERT INTO nyu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tsono Izau adathamanga kukagumana naye, adamukumbatira, acimumpsompsona. Wentse awiriwo adalira. ");
INSERT INTO nyu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Izau atayang'ana, adawona akazi na wana omwe wale, ndipo adamubvundza kuti: “Wanthu awa omwe uli nawowa mbani?” Jakobo adatawira kuti: “Mbuya wangu, awa ni wana omwe Mulungu adandipasa mwa nsisi zace”. ");
INSERT INTO nyu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ndipo anyagrinya wacikazi wale adabwera pabodzi na wana wawo, adagodama wacitsulima. ");
INSERT INTO nyu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya adabwerambo pabodzi na wana wace, ndipo pakumalizira adafika Zuze na Rakeli. Wentsenewo adagodama wacitsulima. ");
INSERT INTO nyu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Izau adabvundza kuti: “Kodi mthithi wa bzifuwo ndagumana nawo ule ngwa ciyani?” Jakobo adatawira kuti: “Mbuyawangu, mthithi omwe ule ni wanu, kuti imwepo mundikomere m'tima”. ");
INSERT INTO nyu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tsono Izau adati: “Mbale wangu, bzifuwo bzimwebzi ndinabzo bzizinji. Bzomwe unabzo bzikhale bzako”. ");
INSERT INTO nyu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakobo adati: “Nee ndaphata minyendo, penu mwandikomera m'tima, tambirani mphatso yangu. Thangwe ine ndawona nkhope yanu ninga nkhope ya Mulungu, nakuti mwanditambira na manja mawiri. ");
INSERT INTO nyu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ndaphata minyendo tambirani mphaso ndakubwereseraniyi. Mulungu adandikomera m'tima, ndipo adandipasa bzakusaya bzangu bzense”. Adamuumiriza, mpaka Izau adatambira. ");
INSERT INTO nyu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ndipo Izau adati: “Mbatiguduke, tiyende. Ine ndin'tsogola”. ");
INSERT INTO nyu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tsono Jakobo adati: “Mbuya wangu, muli kudziwa kuti wanawa aneta, ndipombo ndina mabira na ng'ombe bzomwe bzina tuwana. Ndikabzikumba mwakam'kulumize ntsiku ibodzi yokha, bzinifa bzentse. ");
INSERT INTO nyu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ndaphata minyendo mbuya wangu, tsogolani, ine ndin'famba pang'ono-pang'ono pambuyo, malingana mafambidwe ya bzifuwo na wana wangu, mpaka kufika kuna imwe ku Seiri”. ");
INSERT INTO nyu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Pamwepo Izau adati: “Ndipo undibvumize kuti ndikusiyire amuna wangu winangowa”. Tsono Jakobo adati: “Ayai mbuya wangu, bzin'funika lini, mundondikomere m'tima basi”. ");
INSERT INTO nyu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Na tenepo pa ntsiku imweyo Izau adanyamuka ulendo kubwerera ku Seiri. ");
INSERT INTO nyu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Tsono Jakobo adayenda ku Sukoti, ndipo adakamanga nyumba yace, pabodzi na mathanga ya bzifuwo bzace. Ndipopo mbutoyo idacemerewa Sukoti. ");
INSERT INTO nyu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Patsogolo pace Jakobo adakafika bwino ku mzinda wa Sekemu m'dziko la Kanani, atabwerera kucokera ku Mesopotamiya. Adamanga bzikumbi pambuto panango, pafupi na mzindayo. ");
INSERT INTO nyu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Mbuto imweyo adagula kwa bzizukulu bza Hamori, baba wace wa Sekemu, pa ntsengwa ya kobiri 100 za ndzayaya zicena. ");
INSERT INTO nyu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Adamanga guwa pamwepo, adalicemera El-Elohe-Ijirayeri, ndiko kuti Mulungu, Mulungu wa Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ntsiku inango Dina mwana wa Jakobo wakubadwa na Leya, adayenda kukaceza na akazi winango wam'dzikomo. ");
INSERT INTO nyu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sekemu, mwana wa Hamori muHivi, mambo wa cipande ca dzikolo, ataliwona dende lire, adaliphata acisvitha. ");
INSERT INTO nyu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekemu akhafunisisa Dina, mwana wa Jakobo, ndipo akhalewalewa naye mafala yacikondi. ");
INSERT INTO nyu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Na tenepo adakauza baba wace kuti: “Nditengereni dende lire kuti akhale mkazi wangu”. ");
INSERT INTO nyu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Pomwe Jakobo adabva kuti mwana wace Dina wasvithiwa, wana wace wacimuna akhali kuubusa. Iye alibe kucita cinthu mpaka iwo atabwera. ");
INSERT INTO nyu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamori, baba wa Sekemu, adayenda kukacezerana na Jakobo. ");
INSERT INTO nyu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Panthawe imweyo wana wa Jakobo adafika kucokera kuubusa kule. Wanawo atabva bzimwebzo, adaipidwa nabzo. Adakalipa kwene-kwene thangwe Sekemu wacita cinthu cakupasa manyazi kwa aIjirayeri, pakusvitha Dina, mwana wa Jakobo, comwe cikhafunika lini kucita. ");
INSERT INTO nyu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ndipo Hamori adawauza kuti: “Mwana wangu Sekemu wamufuna mwana wanu. Ndaphata minyendo mubvumizeni kuti amulowole. ");
INSERT INTO nyu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tiyendeni tikhale wakubverana thangwe la malowozi. Ife tin'dzalowola wana wanu, imwembo mun'dzalowola wana wathu. ");
INSERT INTO nyu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mukhale nafe pabodzi m'dziko mwathu muno. Mukhale kuli-kwentse komwe mungafune, mumbacite malonda mwaufulu, ndipo mumbagule mbuto yakumanga nyumba”. ");
INSERT INTO nyu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Pambuyo pace Sekemu adauza baba wa Dina na nkhosve zace zire kuti: “Mundikomere m'tima, ndipo nin'dzakupasani bzentse bzomwe mun'dzakumbira. ");
INSERT INTO nyu_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ndiuzeni mphatso yomwe mun'funa, ndipo mulewe ntsengwa iri-yentse yakulowolera. Ine nin'dzakupasani bzentse bzomwe mun'dzalewa, ndipase mtsikanayo akhale mkazi wangu basi”. ");
INSERT INTO nyu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tsono wana wa Jakobo adatawira Sekemu na baba wace Hamori mwakuwanyengeza, thangwe Sekemu akhadacitisa manyazi Dina mpfumakazi yawo. ");
INSERT INTO nyu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Iwo adati: “Bzinkwanisika lini kuti tibvume mpfumakazi yathu kulowodwa na mwamuna alibe kugwatidwa. Cimweci ni cinthu camanyazi kuna ife. ");
INSERT INTO nyu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tingakwanise kubvuma pokhapokha imwe mwatakhala ninga momwe tiri ife, ndipo kuti mukagwata khanda la kumaso amuna wanu wentse. ");
INSERT INTO nyu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Pamwepo tin'dzakubvumizani kuti mulowole wana wathu, ndipo ifembo tin'dzalowola wana wanu. Ndipo tin'dzakhala pakati panu ticikhala dzinza libodzi. ");
INSERT INTO nyu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tsono mungaleka kubvuma bzomwe tiri kulewa, bzakuti muugwatidwe, ife tin'dzatenga mwana wathu wacikaziyu”. ");
INSERT INTO nyu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Mafala yamweya yadakondweresa Hamori na mwana wace Sekemu. ");
INSERT INTO nyu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ndipo mulumbwanayo adakulumiza kucita bzomwe bzikhafunikabzo, thangwe lakuti akhamufuna kwene-kwene mwana wa Jakoboyo. Sekemu akhana mbiri kwene-kwene m'banja mwawo. ");
INSERT INTO nyu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ndipo Hamori pabodzi na mwana wace Sekemu adakacita mtsonkhano kucipata ca mzinda wawo, adalewa-lewa na amuna wa mumzinda mwawo kuti: ");
INSERT INTO nyu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Wanthu awa ni axamwali wathu. Na tenepo tiwabvumize kuti akhale m'dziko mwathu muno, kuti acite veremawu mwaufulu. Dzikoli ndikulu ndipo liniwakwanira iwo. Bwerani tilowolane nawo. ");
INSERT INTO nyu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Tsono wanthu amwewa an'dzabvuma kukhala na ife, kuti tikhale mtundu ubodzi, pokha-pokha ife tikagwata khanda la kumaso amuna wentse ninga ambacitira iwo. ");
INSERT INTO nyu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kodi nkhulewa lini kuti bzifuwo bzawo, mitolo yawo na ng'ombe zawo bzin'dzakhala bzathu? Na tenepo mbatibvume kuti akhale nafe”. ");
INSERT INTO nyu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Amuna adabvuma bzomwe Hamori na Sekemu adalewa, ndipo amuna wentse wamumzindamo adagwatidwa khanda la kumaso. ");
INSERT INTO nyu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Patondokupita ntsiku zitatu, pomwe amuna wale akhawawidwa, wana awiri wa Jakobo, Simeoni na Levi, nkhosve za Dina, adatenga bzisenga bzawo, adapita mwakusaya kudziwika mumzinda mule, acipha amuna wentse. ");
INSERT INTO nyu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Adapha pomwe Hamori na mwana wace Sekemu na bzisenga. Adatenga Dina mnyumba mwa Sekemu, wacicoka. ");
INSERT INTO nyu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Wana winango wa Jakobo adafika pa wakuphedwa wale adaba bzentse bzamumzindamo, thangwe lakuti akhadasvitha mfumakazi yawo. ");
INSERT INTO nyu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Adaba mabira, ng'ombe, pabodzi na mabulu yawo na bzentse bzomwe bzikhali mumzindamo ndipombo bza mminda mwawo. ");
INSERT INTO nyu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Adatenga cuma cense, adaphata akazi wentse na wana, wacitengambo bzense bza mnyumba zawo. ");
INSERT INTO nyu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jakobo adauza Simeoni na Levi kuti: “Hi, mwandiputira mulandu. Mwandiipisa pakati pa wanthu wa dziko lino, Akanani na Aferezi. Ine ndilibe wanthu wazinji, ndipo iwo wakagumanizana kuti adzandimenye, ine na banja langu lense, tense pabodzi tin'dzadzongeka”. ");
INSERT INTO nyu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tsono iwo adati: “Mpfumakazi yathu angamusanduse lini puta nee!” ");
INSERT INTO nyu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ndipo Mulungu adauza Jakobo kuti: “Nyamuka, ndoko ku Betele, ukakhale komweko. Ukamange guwa la Mulungu omwe adakuwonekera pomwe ukhathawa mbale wako Izau”. ");
INSERT INTO nyu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Na tenepo Jakobo adauza banja lace na wentse omwe akhali naye kuti: “Tayani milungu yacilendo yomwe muli nayo pakati panu. Mubzicenese, ndipo mucinje bzakubvala. ");
INSERT INTO nyu_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Tin'coka kuno, tiniyenda ku Betele kumweko ndin'kamanga guwa la Mulungu omwe adandithandiza Panthawe ya matsautso yangu. Ndiye cadidi omwe wakhala nande kulikwense komwe ndikhayenda”. ");
INSERT INTO nyu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Na tenepo milungu yentse yacilendo yomwe wana wace akhali nayo, adaipereka kuna Jakobo, pabodzimbo na mphete zakukhutu zomwe akhabvala. Bzensenebzo adabzifucira patsinde pa muti ukulu pafupi na Sekemu. ");
INSERT INTO nyu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Pomwe Jakobo na wana wace adacoka, wanthu wentse wa mizinda yakuzungulira adabva mantha, na tenepo alibe kuwatewera wana wa Jakobo. ");
INSERT INTO nyu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ndipo Jakobo na wanthu wace adafika kuLuzi (komwe ni kuBetele) m'dziko la Kanani. ");
INSERT INTO nyu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Adamanga guwa kumweko, ndipo mbutoyo adaicemera El-Betele, thangwe kumweko nikomwe Mulungu adabzilatiza kwa Jakobo pomwe akhathawa mbale wace. ");
INSERT INTO nyu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debora mulezi wa Rebeka, adafa komweko, ndipo adaikhidwa patsinde pa muti ukulu ku Beteleko. Na tenepo mbutoyo idacemeredwa Muti ukulu wa Nkhawa. ");
INSERT INTO nyu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jakobo atabwera kucokera kuMesopotamiya kule, Mulungu adamuwonekera pomwe acimudalisa. ");
INSERT INTO nyu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mulungu adati: “Dzina lako ndiwe Jakobo, tsono un'dzacemeredwa lini pomwe Jakobo, dzina lako lin'dzakhala Ijirayeri”. Na tenepo adacemeredwa Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Patsogolo pace Mulungu adamuuza kuti: “Ine ndine Mulungu Wamphambvu-zentse. Ubale wana wazinji. Un'dzakhala na bzizukulu bzizinji, ndipo bzina mwa ibzo bzin'dzakhala azimambo. Bzizukulu bzako bzin'dzawanda kwene-kwene, na tenepo kuti bzin'dzakhala mitundu izinji ya wanthu. ");
INSERT INTO nyu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nin'dzakupasa dziko lomwe ndidapasa Abrahamu na Izaki. Dziko limweli ndidzapasambo bzizukulu bzako, iwe ukafa”. ");
INSERT INTO nyu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ndipo Mulungu adayenda acim'siya Jakobo pa mbuto yomwe akhalewa-lewa nayepo. ");
INSERT INTO nyu_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakobo adaimisa cimwala cacikumbuso pa mbuto imweyo. Adathulira cakumwa pamwalapo, acithulira mafuta. ");
INSERT INTO nyu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jakobo adaicemera Betele mbuto yomwe Mulungu adalewa-lewa naye. ");
INSERT INTO nyu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ndipo wentse adacoka ku Betele, tsono akanatikufika ku Efurata, nthawe yakuti Rakeli abale idakwana, ndipo kubala kwace kudamunesa kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Bzidafika pakuipa kwene-kwene, ndipo daya adamuuza kuti: “Leka kugopa, un'khala na mwana winango wacimuna”. ");
INSERT INTO nyu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ndipo Rakeli ali pafupi kufa, acimalizika, adamucemera mwanayo Benoni, tsono baba wace adamucemera Benjamini. ");
INSERT INTO nyu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rakeli watafa, adaikhidwa pambali pa mseu wakuyenda ku Efurata (komwe ni kuBelee.) ");
INSERT INTO nyu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ndipo Jakobo adaimisa cimwala cacikumbuso pa thenje la Rakeli. Mwalayo ukali pamwepo mpaka lero lino. ");
INSERT INTO nyu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ijirayeri adapitiliza acikamanga bzikumbi bzace kumbuyo kwa cigota ya Edere. ");
INSERT INTO nyu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Pomwe Ijirayeri akhakhala m'dziko limwero, Rubeni adagona na Biliha, mkazi mng'ono wa baba wace, ndipo Ijirayeri adabva bzimwebzo. Ijirayeri akhana wana wacimuna khumi na awiri. ");
INSERT INTO nyu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Wana wa Leya mbawa: Rubeni, mwana wautsvaka wa Jakobo, Simeoni, Levi, Juda, Isakara na Zebuloni. ");
INSERT INTO nyu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Wana wa Rakeli mbawa: Zuze na Benjamini. ");
INSERT INTO nyu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Wana wa Biliha nyagrinya wa Rakeli mbawa: Dani na Nafutali. ");
INSERT INTO nyu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Wana wa Zilipa nyagrinya wa Leya mbawa: Gadi na Asere. Amwewa ndiwo wana wa Jakobo omwe adabadwira ku Mesopotamiya. ");
INSERT INTO nyu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakobo adakafika kwa baba wace Izaki ku Mamure (kumweko kukhacemeredwa kuKiriyati-Ariba komwe ni kuHebroni), komwe Abrahamu na Izaki akhakhala kale. ");
INSERT INTO nyu_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ndipo Izaki adakwanisa magole 180. ");
INSERT INTO nyu_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ndipo Izaki adatsindira moyo, adafa, adam'tenga naye kwa makolo yace, akhadalamba kwene-kwene. Wana wace, Izau na wa Jakobo ndiwo adamuikha muthenje. ");
INSERT INTO nyu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Mpsibzi bzizukulu bza Izau, omwe akhacemeredwambo Edomu. ");
INSERT INTO nyu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Izau akhadalowola akazi Acikanani awa: Ada mwana wa Eloni Muhiti, Oholibama mwana wa Ana, mwana wa Zibiyoni Muhivi, ");
INSERT INTO nyu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","na Basemati mwana wa Jumayere, mpfumakazi ya Nebayoti. ");
INSERT INTO nyu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada adamubalira Izau Elifazi. Basemati adabala Reuele ");
INSERT INTO nyu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ndipo Oholibama adabala Yeusi, Yalamu na Kora. Amwewa ni wana wa Izau omwe adabadwira mdziko la Kanani. ");
INSERT INTO nyu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ndipo Izau adatenga akazi wace, wana wace wacimuna na wacikazi na wanthu wentse wa mnyumba yace, pabodzi na bzifuwo bzace bzense, na mitolo yace yense yomwe adakwanisa ku dziko la Kanani, ndipo adamwazana na mbale wace ule Jakobo, adayenda kukakhala ku dziko linango. ");
INSERT INTO nyu_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Adacoka thangwe lakuti dziko lomwe akhakhalalo iye pabodzi na Jakobo, likhawakwanira lini. Akhana bzifuwo bzakuwanda kwene-kwene. Na tenepo akhakwanisa lini kukhala pabodzi. ");
INSERT INTO nyu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Na tenepo Izau, omwe ni Edomu, adakakhala kuSeiri, dziko la mapiri. ");
INSERT INTO nyu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Mpsibzi bzizukulu bza Izau, kholo la Aedomu, waukhala m'dziko lamapiri la Seiri. ");
INSERT INTO nyu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Madzina ya wana wacimuna wa Izau ngaya: Elifazi mwana wa Ada mkazi wa Izau, na Reuele mwana wa Basemati mkazi wa Izau. ");
INSERT INTO nyu_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wana wa Elifazi ni Temani, Omara, Zefo, Gatamu na Kenazi. ");
INSERT INTO nyu_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","(Timna akhali mkazi mng'ono wa Elifazi mwana wa Izau, ndipo mwa Timnayo Elifazi adabereka Amaleke.) Amwewa ndiwo wana wa Ada mkazi wa Izau. ");
INSERT INTO nyu_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Wana wa Reuele mbawa: Nahati, Zera, Sama na Miza. Amwewa ndiwo wana wa Basemati mkazi wa Izau. ");
INSERT INTO nyu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Wana wa Oholibama mkazi wa Izau mbawa: Yeusi, Yalamu na Kora. Oholibamayo akhali mwana wa Ana mwana wa Zibiyoni. ");
INSERT INTO nyu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Mbawa atongi wa bzizukulu bza Izau. Mwa wana wa Elifazi, mwana wakuyamba wa Izau, pakhana atongi awa: Temani, Omara, Zefo, Kenazi, ");
INSERT INTO nyu_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatamu na Amaleke. Amwewa ni atongi mwa wana wa Elifazi m'dziko la Edomu. Wentsenewa akhali wana wa Ada. ");
INSERT INTO nyu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Mwa wana wa Reuele, mwana wa Izau, pakhana atongi awa: Nahati, Zera, Sama na Miza. Amwewa ndiwo atongi mwa wana wa Ruwele m'dziko la Edomu, ndipombo ndiwo wana wa Basemati mkazi wa Izau. ");
INSERT INTO nyu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Mwa wana wa Oholibama, mkazi wa Izau, pakhana atongi awa: Yeusi, Yalamu na Kora. Amwewa ndiwo atongi omwe mkazi wa Izau, Oholibama mwana wa Ana, adabala. ");
INSERT INTO nyu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Amwewa ni bzizukulu bza Izau, ndipombo ndiwo atongi wawo. ");
INSERT INTO nyu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Awa ni wana wacimuna wa Seiri Muhori, ndzika za dzikolo: Lotani, Sobali, Zibiyoni na Ana, ");
INSERT INTO nyu_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disoni, Ezere na Disani. Awa ndiwo atongi wa Ahori wana wa Seiri m'dziko la Edomu. ");
INSERT INTO nyu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Wana wa Lotani akhali Hori na Hemani, ndipo Timna akhali mpfumakazi ya Lotani. ");
INSERT INTO nyu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Wana wa Sobali mbawa: Alivani, Manahati, Ebala, Sefo na Onamu. ");
INSERT INTO nyu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Wana wa Zibiyoni mbawa: Aya na Ana. (Ana ndiye omwe adawona mbuto ya madzi yakutentha m'cidambo, pomwe akhadyesa mabulu ya Zibiyoni baba wace.) ");
INSERT INTO nyu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Wana wa Ana mbawa: Disoni mwana wacimuna, na Oholibama mwana wacikazi, ");
INSERT INTO nyu_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Wana wa Disoni mbawa: Hemudani, Esibani, Itirani na Kerani. ");
INSERT INTO nyu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Wana wa Ezere mbawa: Bilihani, Zaavani na Akani. ");
INSERT INTO nyu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Wana wa Disani mbawa: Uzi na Arani. ");
INSERT INTO nyu_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Atongi wa Ahori mbawa: Lotani, Sobali, Zibiyoni, Ana, ");
INSERT INTO nyu_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disoni, Ezere na Disani. Amwewa ndiwo atongi wa aHori mdziko la Seiri malingana na madzinza yawo. ");
INSERT INTO nyu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Mbawa azimambo omwe akhatonga dziko la Edomu, azimambo wa aIjirayeri wakanati kutonga kumweko: ");
INSERT INTO nyu_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mwana wa Beori, akhatonga dziko la Edomu, ndipo dzina la mzinda wace likhali Dinihaba. ");
INSERT INTO nyu_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela atafa, Yobabu mwana wa Zera wa ku Bozira ndiye omwe adapita umambo pambuto pace. ");
INSERT INTO nyu_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu atafa, Husamu wa ku dziko la Atemani adapita umambo pambuto pace. ");
INSERT INTO nyu_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Atafa Husamu, Hadadi mwana wa Bedadi adapita umambo pambuto pace. Umweyu ndiye omwe adakunda Amidiyani m'dziko la Mowabu, ndipo dzina la mzinda wace likhali Aviti. ");
INSERT INTO nyu_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Atafa Hadadi, Samila wa ku Masireka ndiye adapita umambo pambuto pace. ");
INSERT INTO nyu_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Atafa Samila, Shaulo wa ku Rehoboti, mzinda wa pamkulo, ndiye omwe adapita umambo pambuto pace. ");
INSERT INTO nyu_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Atafa Shaulo, Baala-Hanani mwana wa Akibori, ndiye adapita umambo pambuto pace. ");
INSERT INTO nyu_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baala-Hanani mwana wa Akibori atafa, Hadari ndiye adapita umambo pambuto pace. Dzina la mzinda wace likhali Pau, ndipo dzina la mkazi wace likhali Mehetabele, mwana wa Matiredi mwana wa Mezahabu. ");
INSERT INTO nyu_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Awa ndiwo atongi wa Izau, malingana na madzinza yawo na mbuto ya dzindza liri-lense: Timna, Aliva, Yeteti, ");
INSERT INTO nyu_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinoni, ");
INSERT INTO nyu_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazi, Temani Mibizara, ");
INSERT INTO nyu_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magadiele na Iramu. Amwewa ndiwo atongi wa Edomu (ndipo Izau ndiye kholo la Aedomu malingana na mbuto yomwe akhakhala mdziko lawolo.) ");
INSERT INTO nyu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakobo adakhala ku dziko la Kenani komwe baba wace akhadakhala ninga nyakudza. ");
INSERT INTO nyu_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Mbiri ya banja la Jakobo ni iyi: Pomwe Zuze akhali mulumbwana wa magole 17, akhausa mabira na mbuzi pabodzi na abale wace, wana wa Biliha na wa Zilipa, akazi wa baba wace. Ndipo Zuzeyo akhauza baba bzakuipa bzomwe akhacita abale wacewo. ");
INSERT INTO nyu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ijirayeri akhambafuna Zuze kuposa wana wace winango wentse, sabwa akhali mwana wace wa paunkhalamba. Adam'sonera cakubvala citali camanja. ");
INSERT INTO nyu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Abale wace atawona kuti baba wawo akhambafuna Zuze kuposa iwo, adayamba kuwengana naye, ndipo akhakwanisa lini kulewa-lewa naye mwa m'tendere. ");
INSERT INTO nyu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ntsiku inango Zuze adalota matulo, adafotokozera abale wace matuloyo. Ndipo adawengana naye kuposa kale. ");
INSERT INTO nyu_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Iye adawauza kuti “Bverani matulo yomwe ndalota. ");
INSERT INTO nyu_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tentsenefe tikhali m'munda, ndipo tikhamanga mitolo ya tirigu. Tirikumanga tenepo, m'tolo wangu udamuka uciima. Ndipo mitolo yanu ikhadauzungulira m'tolo wanguyo icimbaugodamira”. ");
INSERT INTO nyu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Pamwepo abale wacewo adamubvundza kuti: “Kodi ulikukumbuka kuti un'dzakhala mambo wathu? Kodi iwepo un'dzatitonga ife?” Na tenepo adawengana naye kwakupitirira kale thangwe la matuloyo na mafala yaceyo. ");
INSERT INTO nyu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ndipo Zuze adalota pomwe matulo yanango, adauza pomwe abale wacewo kuti: “Ndalota pomwe, ndipo ndawona dzuwa, mwezi na nyenyezi khumi na ibodzi bzicimbandigodamira”. ");
INSERT INTO nyu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Matulo yamweya adauza pomwe baba wace pabodzi na abale wace wale. Baba wace adam'tsimula, adati: “Kodi matulo yamweya ngakutani? Kodi ulikukumbuka kuti ine, mai wakoyu pabodzi na abale wakowa, tin'dzakugodamira iwe m'paka pantsi?” ");
INSERT INTO nyu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ndipo abale wace adam'citira njiru kwene-kwene. Tsono baba wace akhakhala acibzikumbuka bzimwebzi. ");
INSERT INTO nyu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ntsiku inango, abale wa Zuze adayenda ku Sekemu kukausa mabira ya baba wawo. ");
INSERT INTO nyu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ijirayeri adauza Zuze kuti: “Abale wako alikuusa mabira ku Sekemu. Ndirikukutuma kuti uyende kuna iwo”. Zuze adatawira kuti: “Inde, baba”. ");
INSERT INTO nyu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ndipo baba waceyo adamuuza kuti: “Ndoko ukawaone abale wako penu ali bwino, ndipombo bzifuwo penu bziri bwino ndipo udzandiuze”. Na tenepo baba wace adatuma Zuze kucokera ku cigowa ca Hebroni. Zuze atafika ku Sekemu, ");
INSERT INTO nyu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","munthu winango adam'gumana akhandofamba-famba kumweko adamubvunza kuti: “Kodi ulikunyang'ana ciyani?” ");
INSERT INTO nyu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Zuze adatawira kuti: “Ndirikunyang'ana abale wangu. Ndaphata minyendo ndiuzenimbo komwe alikuusira mabira”. ");
INSERT INTO nyu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Munthuyo adati: “Adacoka kale kuno. Ndidawabva acimbalewa kuti alikuyenda ku Dotani”. Pamwepo Zuze adatewera abale wace, ndipo adakawagumana ku Dotani. ");
INSERT INTO nyu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Abale wace wale adamuwona na patali, akanati kufika, adayamba kumukondzera ciwembo cakuti wamuphe. ");
INSERT INTO nyu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Iwo adauzana wina na mwandzace kuti: “Uyo, nyamatulo ule, alikubwera! ");
INSERT INTO nyu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Bwerani timuphe, citanda cace ticithuse m'cidindi cibodzi mwa madindiya. Tin'kalewa kuti wadyewa na cilombo, ndipo tidzawone n'ciyani cin'dzacitika na matulo yace yale”. ");
INSERT INTO nyu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Pomwe Rubeni adabva bzomwe wakhalewa, adayezera kupulumusa Zuze. Adati, “Mbatireke kumupha. ");
INSERT INTO nyu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Lekani kutaya mulopa wace. Ndom'thusani m'cidindi kucidambo kuno, tsono lekani kum'pweteka”. Akhalewa bzimwebzi kuti am'pulumuse m'manja mwawo, ndipo am'tumize kuna baba wace. ");
INSERT INTO nyu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Zuze atafika komwe kukhana abale wace, iwo adam'khundula cakubvala citali camanja cire comwe akhadabvala, ");
INSERT INTO nyu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","adam'tenga, wacim'thusa m'cidindi cakusaya madzi. ");
INSERT INTO nyu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Pomwe iwo akhadya, adawona m'thithi wa aIjimaele alikucokera ku Giliyadi. Ngamira zawo zikhadasendza ntsonono na bzakununchira bzomwe wakhayenda nabzo ku Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ndipo Juda adabvundza abale wace kuti: “Kodi tin'phindulanyi tikamupha m'bale wathuyu ticibisa citanda cace? ");
INSERT INTO nyu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Bwerani tim'gulise kwa aIjimaelewa, tireke kum'pweteka. Kodi umweyu ni mbale wathu lini, thupi libodzi ndipombo mulopa ubodzi?” Abale wacewo adabvuma bzimwebzo. ");
INSERT INTO nyu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Pomwe aIjimaele wamalonda wa kuMidiyani adafika pamwepo, abale wacewo adam'cosa Zuze m'cidindi mule, acim'gulisa kwa aIjimaelewo na kobiri ya parata makumi mawiri, ndipo iwo adayenda naye kuIjipito. ");
INSERT INTO nyu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubeni atabwerera kucidindi kule adawona mulibe Zuze. Pamwepo adang'amba bzakubvala bzace. ");
INSERT INTO nyu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ndipo adabwerera kwa abale wace wale adawauza kuti: “Mulumbwana ule mulibe! Ndipo ine nin'cita tani?” ");
INSERT INTO nyu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Pamwepo iwo adapha tonde, acibvuika cakubvala ca Zuze m'mulopa. ");
INSERT INTO nyu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Adatenga cakubvalaco aciyenda naco kwa baba wawo aciti: “Talokota ici. Wonani penu cingakhale cakubvala ca mwana wanu ule”. ");
INSERT INTO nyu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jakobo adacizindikira cakubvalaco, aciti: “Ni cakubvala ca mwana wangu. Cirombo camupha mwana wangu. Mawa ine, Zuze akhabvulidwa!” ");
INSERT INTO nyu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jakobo adang'amba bzakubvala bzace, adabvala sakha m'ciuno, Adalira nkhawa ya mwana waceyo ntsiku zizinji. ");
INSERT INTO nyu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wana wace wentse wacimuna na wacikazi, adabwera kuti am'pepese tsono iye adalamba, adati: “Nin'dzakhala ndicimbalira mwana wangu mpaka kuthenje komwe kuna iye”. Na tenepo adapitiriza kulira thangwe la Zuze mwana wace. ");
INSERT INTO nyu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Nthawe imweyo kuIjipito, aMidiyani wale akhadagulisa kale Zuze kuna Potifara, m'bodzi mwa wakulemekezeka wa Falau, ndipo mkulu wa acikunda wakulindira. ");
INSERT INTO nyu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nthawe imweyo Juda adasiya abale wace adakakhala kunyumba ya munthu winango kuAdulamu dzina lace Hira. ");
INSERT INTO nyu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Kumweko Juda adagumana m'tsikana wacikanani, mwana wa Suwa, adamulowola acimutenga. ");
INSERT INTO nyu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mkaziyo adatenga mimba, acibala mwana wacimuna, baba wace adam'pasa dzina lakuti Ere. ");
INSERT INTO nyu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Adatenga pomwe mimba acibala mwana wacimuna, mai wace adam'pasa dzina lakuti Onani. ");
INSERT INTO nyu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Adabala pomwe mwana winango wacimuna, adam'cemera Sela. Pomwe Sela akhabadwa, akhali ku Kezibu. ");
INSERT INTO nyu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda adamunyang'anira mkazi mwana wace waudende ule Ere, dzina lace Tamara. ");
INSERT INTO nyu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tsono Ere mwana wakuyamba wa Juda akhana khalidwe lakuipa pamaso pa Mbuya, na tenepo Mbuya adacitisa kuti afe. ");
INSERT INTO nyu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Pamwepo Juda adauza Onani kuti: “Fambizana naye mkazi wa m'bale wakoyu. Upite nthaka, kuti m'bale wakoyo akhale na wana”. ");
INSERT INTO nyu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tsono, Onani akhadziwa kuti wanawo an'dzakhala lini wace. Na tenepo nthawe zentse akhafambizana naye mkaziyo, tsono akhataira pantsi mbeu yace, kuti aleke kum'balira wana m'bale waceyo. ");
INSERT INTO nyu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ndipo bzomwe akhacitabzo bzidaipira Mbuya. Na tenepo adacitisa kuti afembo. ");
INSERT INTO nyu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Pamwepo Juda adauza mulowola wace ule Tamara kuti: “Bwerera kunyumba kwa baba wako, ukakhale mansiwa kumweko mpaka mwana wangu Sela akule”. Adalewa bzimwebzi thangwe akhagopa kuti Sela angafembo ninga abale wace wale. Na tenepo Tamara adabwerera kunyumba kwa baba wace. ");
INSERT INTO nyu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Patapita magole, mkazi wa Juda, mwana wa Suwa, adafa. Ndipo Juda atamala kulira nkhawayo, adayenda kwa wakumeta mabira kuTimna, iye na xamwali wace Hira, wa kuAdulamu. ");
INSERT INTO nyu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Munthu winango adauza Tamara kuti: “Mabzala wako alikuyenda ku Timna kukameta mabira”. ");
INSERT INTO nyu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ndipo Tamarayo adacinja bzakubvala bzace bzaumasiwa bzire adabvala bzinango. Adabzipsinkha nkhope na nguwo, adakakhala pa njira yakuyendera kuEnaimu. Muyi wa Enaimu ukhali pa mseu wakuyenda ku Timna. Iye adacita bzimwebzi thangwe adawona kuti Sela akhadakula kale, tsono Tamara akhanati kupasiwa Sela kuti akhale mwamuna wace. ");
INSERT INTO nyu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Juda atamuwona, adamuyesa mkazi puta, thangwe akhadabzipsinkha nkhope. ");
INSERT INTO nyu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Adayenda kumphimpha ya mseu komwe kukhana iye acimuuza kuti: “Bwera ndigone nawe!” Juda akhadziwa lini kuti ni mulowola wace. Mkazi ule adati: “Un'dzandipasa ciyani kuti ndigone nawe?” ");
INSERT INTO nyu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Juda adatawira kuti: “Nin'dzakutumizira mbuzi ing'ono ya m'thanga mwangu”. Ndipo Tamarayo adati: “Inde, nin'tawira mungandipasa cinthu cakuti ndibakaphatire mpaka kudzanditumizira”. ");
INSERT INTO nyu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Juda adamubvundza kuti: “Kodi ulikufuna kubakaphatira ciponi?” Tamara adatawira kuti: “Undipase mphete yomwe iri ku mkufu wako, na mpsimbo yakufambira yomwe ili m'manja mwakoyi”. Juda adapereka bzentsenebzo kwa Tamara. Na tenepo Juda adagona naye mkaziyo, ndipo adatenga mimba. ");
INSERT INTO nyu_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ndipo Tamara adanyamuka aciyenda. Adacosa nguwo yomwe akhadabzipsinkha nayo ire, acibvala pomwe bzakubvala bzace bzaumasiwa bzire. ");
INSERT INTO nyu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Patsogolo pace Juda adatuma xamwali wace wa kuAdulamu ule kukapereka mbuzi ire, kuti mkazi ule amubwezere bzinthu bzire. Tsono xamwali waceyo alibe kam'gumana mkaziyo. ");
INSERT INTO nyu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Adabvundza wanthu wakomweko kuti: “Kodi mkazi puta omwe akhakhala pambali pa mseu wakuyenda ku Enaimu ule ali kuponi?” Wanthuwo adatawira kuti: “Cikhaliremo pakanati kukhala mkazi puta pa mbuto imweyo”. ");
INSERT INTO nyu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Adabwerera kuna Juda, acikamuuza kuti: “Ndilibe kum'gumana mkazi ule, ndipo wanthu wakomweko andiwuza kuti: ‘Cikhaliremo pakanati kukhala mkazi puta pa mbuto imweyo.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda adati: “Bzinthu bzimwebzo atenge bzikhale bzace, kuti tileke kunyozedwa na wanthu. Ine ndidam'tumizira cadidi mbuzi ire tsono ulibe kumugumana”. ");
INSERT INTO nyu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Patapita minyezi mitatu, Juda adauzidwa kuti: “Mulowola wako ule Tamara adacita uputa, ndipo ana mimba”. Pamwepo Juda adalewa kuti: “Kam'tengeni ndipo mukam'tenthe kuti afe”. ");
INSERT INTO nyu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Pomwe wakhamucosa, Tamara adatumiza mafala kuna Juda mabzala wace kuti: “Ine ndina mimba ya mwenekaciro wa bzinthu ibzi, mpheteyi na mkufuyu ndipombo mpsimbo yakufambirayi”. Bziwoneni pinango mungadziwe mwenekaciro kuti mbani. ");
INSERT INTO nyu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda adabzidziwa adati: “Iye ngwakulungama kuposa ine. Nakuti ndiribe kupereka mwana wangu Sela kuna iye”. Ndipo alibe kudzafambizana naye. ");
INSERT INTO nyu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Yatakwana nthawe yakuti Tamara abale, m'mimba mwace mukhana mamphase. ");
INSERT INTO nyu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Panthawe yakubala, m'bodzi mwa wanawo adacosa boko. Daya adaliphata, acilimanga na usalu ufuira aciti: “Umweyu ndiye wakutoma kubadwa”. ");
INSERT INTO nyu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tsono mwanayo adalibweza boko lile, mwandzace acicoka. Ndipo daya ule adati: “Wabziphocolera tani?” Na tenepo mwanayo adacemeredwa Perezi. ");
INSERT INTO nyu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Patsogolo pace m'bale wace adabadwa, usalu ufuira uli ku boko. Ndipo adacemeredwa Zera. ");
INSERT INTO nyu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","AIjimaele wale adayenda naye Zuze ku Ijipito komwe Potifara Mujipito, wakulemekezeka wa Falau ndipombo mkulu wa acikunda wakulindira kunyumba ya mambo, adamugula. ");
INSERT INTO nyu_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mbuya akhali naye Zuze, ndipo adam'thandiza kuti bzentse bzimuyendere bwino. Adakhala m'nyumba ya mbuya wace, Mujipito ule. ");
INSERT INTO nyu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mbuya waceyo adawona kuti Mbuya akhali naye Zuze, na kuti akhamukwanirisa pa bzentse bzomwe akhacita. ");
INSERT INTO nyu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifara adakondwa naye Zuze pakuwona momwe akhamutumikira. Na tenepo adam'sandusa kapitau wa nyumba yace, ndipombo wakunyang'anira bzentse bzam'nyumbamo. ");
INSERT INTO nyu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kuyambira nthawe yomwe Zuze adayamba kunyanganira bzentse bza m'nyumba ya Potifarayo, Mbuya adadalisa bzentse bza kunyumba kwa Mujipitoyo, napombo bza kuminda kwace, thangwe la Zuzeyo. ");
INSERT INTO nyu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Na tenepo Potifara adaikha m'manja mwa Zuze bzace bzentse, na tenepo kuti akhalibe thupo na cinthu ciri-centse, tsono cakudya cokha comwe akhadya. Zuze akhali wa mawonekedwe yabwino na kudeka. ");
INSERT INTO nyu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Patapita kanthawi, mkazi wa mbuya wace adayamba kusirira Zuze. Ndipo mkaziyo adauza Zuzeyo kuti: “Tani ugone nande”. ");
INSERT INTO nyu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Zuze adalamba, adati: “Thangwe lakuti ine ndirikuphata basa muno, mbuya wangu alibe-thupo na cinthu ciri-centse ca m'nyumba muno. Adandipasa ukapitao wakunyang'anira bzace bzentse, ");
INSERT INTO nyu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ndipo utongi wa bzentse bza m'nyumba muno uli m'manja mwangu, nee m'manja mwace. Alibe-kundimana cinthu ciri-centse kupambula imwe mwekha, pakuti ndimwe mkazi wace. Ndipo bzingakwanisike tani kuti ine ndicite cinthu cakuipisisa catenepaci, na kuphonyera Mulungu?” ");
INSERT INTO nyu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Napo mkazi ule akhalewa-lewa mafala yamweya kuna Zuze ntsiku na ntsiku, Zuzeyo akham'bvera lini na pang'onopo kugona naye ngakhale kukhala pafupi naye. ");
INSERT INTO nyu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tsono ntsiku yinango Zuze adapita m'nyumba kuti aphate basa, ndipo pakhalibe wabasa winango m'nyumbamo. ");
INSERT INTO nyu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Mkazi ule adaphata cakubvala Zuzeyo, acimuuza kuti: “Ugone nande basi!” Tsono iye adathawira panja, kusiya cakubvala cile ciri m'manja mwa mkaziyo. ");
INSERT INTO nyu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ndipo mkazi ule atawona kuti Zuze wasiya cakubvala ndipo wathawira panja, ");
INSERT INTO nyu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","adacemera wabasa wam'nyumbamo, adawauza kuti: “Mwabziwona ibzi? Mwamuna wangu adabwera na Muhebri uyu kuti adzatitukane. Iye abwera kuna ine kuti andisvithe. Tsono ine ndakuwa kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ndipo atabva kukuwa kwanguko, wasiya cakubvala cace m'manja mwangumu acithawira panja”. ");
INSERT INTO nyu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Cakubvalaco adandocikoya m'manja kudikhira mpaka mbuya wa Zuze abwere. ");
INSERT INTO nyu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ndipo atabwera, adamufotokozera nkhani yentseneyo, adati: “Nyagrinya ule Wacihebri mudabwera naye m'nyumba munoyu, adapita kucipinda kwangu kudzandisinjirira ine. ");
INSERT INTO nyu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tsono ine ndidakuwa, umweyo adasiya cakubvala cace pafupi na ine, acithawira panja”. ");
INSERT INTO nyu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Atabva mafala ya mkazi wace yakulewa kuti: “Inde, ibzi ni bzomwe wandicita nyagrinya wanu”. Mbuya wa Zuze adawawidwa kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Pamwepo adamumangisa Zuze acikamufungira mukawoko momwe akhakoya anyam'kawoko wa mambo, ndipo adakhala mumwemo. ");
INSERT INTO nyu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tsono Mbuya akhanaye Zuze, adam'komera m'tima na kum'citira nkhombo kuti wakukoya kawoko akondwere naye Zuze. ");
INSERT INTO nyu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Adam'sandusa kapitau wakunyang'anira anyam'kawoko wentse, pabodzi na bzentse bzakucitika m'kawokomo. ");
INSERT INTO nyu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Bzentse bzikhali m'manja mwa Zuze, ndipo wakukoya kawokoyo akhanyang'anira-lini cinthu cina ciri-cense, thangwe Mbuya akhali naye Zuze ndipo akhamukwanilisa pa bzense bzomwe akhacita. ");
INSERT INTO nyu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Patapita nthawe, munthu wakuperekera vinyu na wakukondza pau ku nyumba ya mambo wa kuIjipito, adaphonyera mbuyawawo mambo wa ku Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Falau adawakalipira kwene-kwene akulu-akulu wace awiriwo mkulu wakuperekera vinyu na mkulu wakukondza pau. ");
INSERT INTO nyu_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Na tenepo adawafungira pa nyumba ya mkulu wa acikunda wakulindira, mukawoko momwe mukhana zuze. ");
INSERT INTO nyu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mkulu wa alindiri ule adasankhula Zuze kuti akoye wanthu awiriwo na kuwalindira. Adakhala ntsiku zizinji m'kawokomo. ");
INSERT INTO nyu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ndipo wakuperekera vinyu na wakuphika pau za mambo wa kuIjipito, omwe akhali mkawoko, pa uwiri bwawo adalota usiku ubodzi-bodziwo matulo yace-yace na thumbudzulo lace-lace ");
INSERT INTO nyu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Pomwe Zuze adabwera ku macibese, adawona iwo adadodoma. ");
INSERT INTO nyu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Pamwepo adabvundza akulu-akulu wa Falau omwe wakhali na iye m'kawoko mwa mbuya wawo, “Mwatani mulikuwoneka ninga wakusunama lero?” ");
INSERT INTO nyu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wentsenewo adatawira kuti: “Awirife tense talota ndoto usiku wapitayu, ndipo pano palibe na m'bodzi yekha omwe angatithumbudzulire malotoyo”. Pamwepo Zuze adawauza kuti: “Ni Mulungu yekha-basi omwe ambapasa nzeru zakuthumbudzula ndoto. Ndiuzenimbo ndoto zanuzo”. ");
INSERT INTO nyu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Na tenepo mkulu wakuperekera vinyu ule adayamba kulewa matulo yace kuna Zuze, adati: “Ine ndalota ndirikuwona muti wamphesa, ");
INSERT INTO nyu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ukhali na mithambi mitatu. Masamba yace yatondophukira, pamwepo padawoneka maluwa, patsogolo pace padawoneka pomwe mphesa zakutokota. ");
INSERT INTO nyu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mkombo wa Falau ukhali m'manja mwangu. Ndidatenga uva ndipo ndidapsinyira mum'kombo wa Falau, ndipo ndidaupereka m'manja mwa Falau”. ");
INSERT INTO nyu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Zuze adamutawira kuti: “Thumbudzulo la matulo yamweya ndiri: Mithambi itatuyo ni n'tsiku zitatu. ");
INSERT INTO nyu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","M'kati mwa n'tsiku zitatu, Falau an'kucosa muno, an'kulekelera, ndipo an'kubweza pa basa lako. Ndipo ucimbadzapereka mkombo kwa Falau ninga momwe ukhacitira kale pomwe ukhali wakuperekera vinyu. ");
INSERT INTO nyu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tsono udzandikumbukire, bzinthu bzikadzakuyendera bwino. Ndaphata minyendo udzandikomere m'tima na kucemera dzina langu kwa Falau, kuti ndidzacoke m'kawoko muno. ");
INSERT INTO nyu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ine adacita kundiba, ndipo adabwera nande kuno kucokera ku dziko la Ahebri. Ndipo napo kuno, ndilibe kucita cinthu ciri-centse kuti andifungire naco m'kawoko”. ");
INSERT INTO nyu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Wakuphika pau ire naiyembo adaona kuti thumbudzulo la malotoyo likhali labwino, adauza Zuze kuti: “Inembo ndalota ndatasendza ntsengwa zitatu za pau pamsolo pangu. ");
INSERT INTO nyu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Muntsengwa ikulu mukhana mitundu izinji ya cakudya ca Falau, tsono mbalame zikhadya cakudyaco muntsengwa pa msolo pangu”. ");
INSERT INTO nyu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Zuze adamutawira kuti: “Thumbudzulo la matulo yamweya ndiri: Ntsengwa zitatu na n'tsiku zitatu. ");
INSERT INTO nyu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mkati mwa ntsiku zitatu, Falau an'kucosa muno, ndipo an'dzaugwata msolo wako. Ndipo citanda cako an'dzacimanika pa muti, ndipo mbalame zidzadya mnofu wako”. ");
INSERT INTO nyu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Padatondokupita ntsiku zitatu, padacitika cikondweso cakusekerera ntsiku yakubadwa Falau, ndipo Falauyo adacemera wakulemekezeka wace wentse. Ndipo adam'cosa wakuperekera vinyu pabodzi na wakuphika pau. Awiri wentse wale adawaimisa pamaso pa wakulemekezeka wace. ");
INSERT INTO nyu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Falau adamubwezera pa basa lace mkulu wakuperekera vinyu ule, lomwe akhambacita lakuperekera mkombo m'manja mwa Falau. ");
INSERT INTO nyu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tsono wakuphika pau ule adam'manika, ninga momwe Zuze akhadalewera pakuthumbudzula matulo yawo yale. ");
INSERT INTO nyu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tsono wakuperekera vinyu ule alibe kumukumbukira Zuze, adandomuyebweratu. ");
INSERT INTO nyu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Patapita magole mawiri, Falau adalota kuti waimirira pamphepete pa m'kulo wa Nilo. ");
INSERT INTO nyu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nthawe imweyo adandowona ng'ombe zinomwe zakunenepa zakudeka zikhacoka mum'kulo, ndipo zikhadya m'mitete. ");
INSERT INTO nyu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Patsogolo pace mum'kulomo mudacoka pomwe ng'ombe zinango zinomwe zakuwonda zakuipa-ipa, zomwe zidaima pabodzi na zakuyamba, m'mphepete mwa m'kulo. ");
INSERT INTO nyu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ndipo ng'ombe zakuipa-ipa zakuwonda zidadya zinzace zakudeka zakunenepa zire. Pamwepo Falau adalamuka. ");
INSERT INTO nyu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Atagona pomwe, adalota matulo anango. Adawona ngala za tirigu zinomwe zatabala pa phesi libodzi, ndipo zikhali zakuwoneka bwino na zakukwima. ");
INSERT INTO nyu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Patsogolo pace padaphukira ngala zinango zinomwe zing'ono zakupsa na mphepo yakutetha yakumabvadzuwa. ");
INSERT INTO nyu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ngala zing'onozo zidameza ngala zinomwe zakukhwima zire. Falau pomwe adamuka, adawona kuti yakhali matulo basi. ");
INSERT INTO nyu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kwatacena macibese adabonera kwene-kwene, mwakuti adacemera wamatsenga wace wentse na wanthu wanzeru wentse wa ku Ijipito. Wentsenewo watabwera, Falau adawafotokozera matulo yaceyo, tsono pakhalibe na m'bodzi yekha omwe adakwanisa kuthumbudzula. ");
INSERT INTO nyu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Pamwepo wakuperekera vinyu ule adauza Falau kuti: “Lero ndin'zimbula kuphonya kwangu. ");
INSERT INTO nyu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pale imwe mambo mudatikalipira m'tima akapolofe. Ndipo ine na wakuphika mnkate tense mudatifungira mukawoko, m'nyumba ya mkulu wa alindiri. ");
INSERT INTO nyu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ndipo usiku winango, awirife tidalota ndoto. Ali-yentse mwa ife akhada lota ndoto yace, ya thumbudzulo lace-lace. ");
INSERT INTO nyu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","M'nyumba momwemo mukhali mulumbwana winango Wacihebri, mtumiki wa mkulu wa alindiri wa mukawoko mule. Umweyo adamuthumbudzulira bwino ali-yentse mwa ife thumbudzulo la ndoto zacezo. ");
INSERT INTO nyu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ndipo bzidacitikadi ninga momwe adatithumbudzulira. Ine ndidabwerera pa basa langu, tsono wakuphika mnkate ule adam'manika pa muti”. ");
INSERT INTO nyu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ndipo Falau adamcemeresa Zuze, ndipo adamcosa mwakan'kulumize kukawokoko. Umweyo atamsenga bwino na kucinja bzakubvala, adayenda kuna Falau kule. ");
INSERT INTO nyu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Falau adauza Zuze kuti: “Ine ndidalota ndoto, tsono palibe na m'bodzi yekha omwe adakwanisa kuthumbudzula ndotozo. Ndipo adandiwuza kuti iwe ukabva matulo, ati an'dziwa kuthumbudzula kwace”. ");
INSERT INTO nyu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Zuze adam'tawira kuti: “Bzobzi ni bzangu lini, tsono Mulungu ndiye an'dzapereka m'tawiro wa m'tendere kuna Falau”. ");
INSERT INTO nyu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pamwepo Falau adati: “Ine ndidalota ndaimirira pamphepete pa mkulo wa Nailo. ");
INSERT INTO nyu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Nthawe imweyo ndidandowona ng'ombe zinomwe zakunenepa zakudeka, ndipo zikhadya m'mitete. ");
INSERT INTO nyu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Patsogolo pace padacoka pomwe ng'ombe zinango zakuwonda zakuipa-ipa kwene-kwene. Ndikanati kuwona ng'ombe zinango zakuipa tenepa m'dziko lentse la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ng'ombe zakuwondazo zidadya zinzace zakunenepa zire. ");
INSERT INTO nyu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tsono zitadya zindzacezo, palibe na m'bodzi yekha angadazindikira, pakuwona kuti ng'ombe zakuwondazo zilibe-kucinja kwense kaonekedwe kace, tsono zidandokhala zakuwonda cadidi ninga kale. Ndipo ndidamuka. ");
INSERT INTO nyu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ndatagona pomwe ndidalota ndawona ngala zatirigu zinomwe zakuwoneka bwino na zakukhwima bwino zatabala pa phesi libodzi. ");
INSERT INTO nyu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Patsogolo pace padaphukira ngala zinango zinomwe zakuuma zakubwerera, zakutenthedwa na mphepo yakumabvadzuwa. ");
INSERT INTO nyu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ngala zing'onozo zidameza zinzace zakunenepa zire. Ndipo ndidafotokozera wamatsenga matulo yamweya, tsono palibe na m'bodzi yekha omwe adakwanisa kundithumbudzulira”. ");
INSERT INTO nyu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Pamwepo Zuze adauza Falau kuti: “Ndoto zense ziwirizi zili na thumbudzulo libodzi lokha. Mulungu wakuuzilatuni bzomwe an'dzacita. ");
INSERT INTO nyu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ng'ombe zixanu na ziwiri zakunenepazo na magole maxanu na mawiri. Ndipo ngala zatirigu zixanu na ziwiri zakukwimazo naizombo na magole maxanu na mawiri. Kuthumbudzula kwace nkubodzi. ");
INSERT INTO nyu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ng'ombe zixanu na ziwiri zakuwonda zomwe zidabwera pambuyo zire, ndipombo ngala zatirigu zixanu na ziwiri zakupsa na mphepo yakumabvadzuwa zire, ni magole maxanu na mawiri ya njala. ");
INSERT INTO nyu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ndipo ninga momwe adalewera, ndiye kuti Mulungu wakuuzilantuni bzomwe an'dzacita. ");
INSERT INTO nyu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Pan'dzakhala magole manomwe ya mpfumba m'dziko lentse la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Yangadzapita magole yamweyo, pan'dzakhala pomwe magole manomwe ya njala, ndipo magole yentse yale ya mpfumba bzin'dzayebweka mu Ijipito mwentse. Njalayo in'dzadzonga dziko. ");
INSERT INTO nyu_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Magole yentse yale ya bzinthu bzizinji yan'dzakumbukika lini, thangwe njala yomwe idzabwerayo in'dzakhala yakugoswa. ");
INSERT INTO nyu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nakuti imwe Falau mwalota kawiri matulo yokha-yokhayo, bzirikuwonesa kuti Mulungu ndiye omwe wakondza bzimwebzi, ndipo an'bzicita cadidi tsampanopa. ");
INSERT INTO nyu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tsapano imwe mambo sankhulani munthu an'dziwa bzinthu na wandzeru, mum'pase utongi pa dziko lense la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Musakhule pomwe wanthu wakulu-wakulu m'dziko lentse lino, ndipo cibodzi mwa bzigawo bzixanu bzilibzense bza bzakubvuna, ambaciikhe pambali pa magole maxanu na mawiri bza cakudya cakuwanda. ");
INSERT INTO nyu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Wagumanize cakudya cense ca magole yabzinthu bzomwe bzilikubwerabzi. Ambacite bzensenebzi na utongi wanu, ndipo wambaikhe tirigu pambali m'mizinda yentse na kumkoya bwino. ");
INSERT INTO nyu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Cakudya comweco cin'dzakhala cakudya ca nthawe ya njala ya magole maxanu na mawiri yomwe yan'dzabwera cadidi mu Ijipito muno, kuti na tenepo wanthu wa ku Ijipito waleke kudzafa na njala”. ");
INSERT INTO nyu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Falau pabodzi na wakulemekezeka wace adabvuma bzentse bzomwe adalewa Zuze. ");
INSERT INTO nyu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ndipo Falau adabvunza wakulemekezeka wacewo kuti: “Kodi tingamuwone kuponi munthu winango wakuposa uyu omwe ali na mzimu wa Mulungu?” ");
INSERT INTO nyu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Na tenepo Falau adauza Zuze kuti: “Pakuwona kuti Mulungu wakuwonesa bzentsenebzi, palibe pomwe winango ali-yentse an'dziwa bzinthu na wanzeru kuposa iwepo. ");
INSERT INTO nyu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Iwe ndiwe omwe un'dzatonga dziko langu, ndipo wanthu wangu wentse an'dzakubvera. Ine ndin'dzakuposa pa cimweci-cokha cakuti ndine mambo”. ");
INSERT INTO nyu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ndipo Falau adauza pomwe Zuze kuti: “Tsapano ine ndakusankhula iwepo kuti ukhale wakulemekezeka mukulu wa dziko lense la Ijipito”. ");
INSERT INTO nyu_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Na tenepo, Falau adacosa mphete ya umambo ku cala cace, aciibvazika ku cala ca Zuze. Adamubvazika pomwe bzakubvala bza ntsengwa ikulu na mkufu wa oro m'khosi mwace. ");
INSERT INTO nyu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Adamukwiza pa ngolo yace yaciwiri, ndipo alindiri wa Falau adayamba kukuwa patsogolo pa ngoloyo kuti: “M'godamireni”. Na tenepo Zuze adatambira utongi, ndipo adakhala wakulemekezeka mukulu wa dziko lense la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Falau adauza Zuze kuti: “Ine ndine Falau, iwe ukaleka kubvuma, palibe na m'bodzi yekha omwe an'dzakwanisa kucita cinthu ciri-cense napo kuyenda komwe m'dziko la Ijipito lentseneli”. ");
INSERT INTO nyu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pamwepo Zuze ule adamucemera Zafenati-Panea. Ndipo adampasa mkazi dzina lakuti Asenati, mwana wa Potifera omwe akhali nyantsembe wa mzinda wa Oni. Na tenepo Zuzeyo adazungira dziko lense la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Zuze akhana magole makumi matatu pomwe adakawonekera kwa Falau mambo wa ku Ijipito. Ndipo iye adacoka pamaso pa Falau acizungulira dziko lentse la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Pa magole manomwe yale ya mpfumba, m'dziko lentse mukhana cakudya cakuwanda kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Zuze adakhongobza cakudya pa magole manomwe, pomwe kukhana mpfumba kwene-kwene ku Ijipito, acibzikoya m'mizinda. Mum'zinda uli-wentse akhakoya cakudya ca ku minda yakuzungulira m'zindawo. ");
INSERT INTO nyu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Adakhongobza tirigu wakuwanda ninga m'cenga wakunyanza. Kukhana tirigu wakuwanda na tenepo kuti wakhadaleka kumupima kwense, pakuwona kuti kukha kwanisika lini kumupima tirigu wenseneyo. ");
INSERT INTO nyu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Magole yanjala yakanati kufika, Zuze adabala wana wacimuna wawiri mwa Asenati ule, mwana wa Potifera, nyantsembe wa ku Oni. ");
INSERT INTO nyu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ndipo adati: “Mulungu wandiyebwesa kusauka kwangu kwentse kule ndipombo banja la baba wangu”. Na tenepo mwana wace waciutswaka ule adam'pasa dzina lakuti Manase. ");
INSERT INTO nyu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ndipo adalewa pomwe kuti: “Mulungu adandikwanirisa m'dziko la kubonera kwangu”. Na tenepo mwana waciwiriyo adam'pasa dzina lakuti Eferemu. ");
INSERT INTO nyu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Patapita magole manomwe ya mpfumba mu dziko la Ijipito, ");
INSERT INTO nyu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","kudafika magole manomwe ya njala yomwe akhalewa Zuze yale. Njala imweyo ikhadafikambo ku m'madziko yanango yentse, tsono m'dziko lentse la Ijipito mukhana cakudya cizinji. ");
INSERT INTO nyu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Njalayo yatakwana dziko lentse la Ijipito, wanthu wakhalilira Falau kuti awapase cakudya. Falau akhawauza wentse kuti: “Ndokoni kuna Zuze, bzomwe an'kakuuzani, mukacite bzimwebzo”. ");
INSERT INTO nyu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ndipo njalayo yatakwana dziko lentse, Zuze adafungula magwangwa ya tirigu yale, acimbawagulisira aIjipitowo, thangwe ikhadakula cadidi mu Ijipitomo. ");
INSERT INTO nyu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Wanthu wakhafika ku Ijipito kucokera ku madziko yentse, kudzagula tirigu kuna Zuze, thangwe njala ikhadakula pakugosva pa dziko lentse la pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jakobo atabva kuti ku Ijipito ndiko kuna tirigu, adabvundza wana wace kuti: “Thangwe lanyi mulikondokukhala nee kucita cinthu? ");
INSERT INTO nyu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ndilikubva kuti ku Ijipito kuna tirigu. Ndokonimbo kumweko, mukatigulirembo ife, kuti tikhale na moyo tileke kufa na njala”. ");
INSERT INTO nyu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Na tenepo abale wace wa Zuze khumi adanyamuka kuyenda ku Ijipito kukagula tirigu. ");
INSERT INTO nyu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Jakobo alibekutumiza nawo Benjamini, mng'ono wace caiyecaiye wa Zuze ule, thangwe akhagopa kuti angacite tsoka. ");
INSERT INTO nyu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","AIjirayeriwo adayenda kuIjipito kukagula cakudya pabodzi na wanthu winango wentse, thangwe lakuti ku dziko la Kanani kukhana njala. ");
INSERT INTO nyu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ndipo pakuwona kuti Zuze akhali wakulemekezeka mkulu wakutonga dziko lentse la Ijipito, ndiye omwe akhagulisa tirigu kuna wanthu wakucokera ku mbuto zentse za dziko. Na tenepo, abale wa Zuze na iwombo adabwera, ndipo adamugodamira wacikotamisa misolo kuna Zuze. ");
INSERT INTO nyu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Zuze atawawona abale wacewo, adawazindikira, tsono adandocita ninga alibekuwadziwa. Adayamba adalewa nawo mwaukali, adawabvundza kuti: “Kodi imwe mulikucokera kuponi?” Iwo adatawira kuti: “Tilikucokera ku Kanani, tadzagula cakudya kuno”. ");
INSERT INTO nyu_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Zuze adawazindikira abale wace wale, tsono iwo alibe kumudziwa. ");
INSERT INTO nyu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Adakumbukira ndoto zire zakulewa bza iwo, ndipo adati: “Ndimwe wanthu wakuyendeza dziko. Mwabwera kuno kudzawona kuti muwone penu dziko lathu ni lakufoka”. ");
INSERT INTO nyu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Iwo wale adatawira kuti: “Ayai mbuya wathu, ife wakumtumikira wanu tabwera kuti tidzagule cakudya basi. ");
INSERT INTO nyu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tentsenefe ndife wana wa Jakobo. Ndife wanthu wakulungama, ndife lini wakuyendeza, mbuya wathu,”. ");
INSERT INTO nyu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Zuze adati: “Ayai. Imwe mwabwera kudzawona dziko lathu kuti muwone penu ni lakufoka”. ");
INSERT INTO nyu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ndipo iwo adati: “Mbuya wathu, ife tikhalipo wana wacimuna khumi na awiri pa ubale bwathu, baba wathu m'bodzi, ku dziko la kwathu ku Kanani. Mng'ono ana baba wathu, ndipo winango adafa”. ");
INSERT INTO nyu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tsono Zuze adawatawira kuti: “Pale ndalewa kale kuti ndimwe wakuyendeza basi. ");
INSERT INTO nyu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ndipo ndin'kuyezani tenepa, ndirikulumbira kuti pana Falau! Imwepo mun'coka lini, mpaka mng'ono wanuyo abwere kuno. ");
INSERT INTO nyu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tumani m'bodzi mwa imwe kuti ayende akamutenge. Winango mwentse mun'salamwe mukhale mukawoko, mpaka mafala yanuya yazindikirike, tiwone penu mulikulewa cadidi. Pamwepo nee, cadidi pana Falau, imwepo ndimwe wakuyendeza basi”. ");
INSERT INTO nyu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Atalewa mafala yamweya, adakawafungira mukawoko n'tsiku zitatu. ");
INSERT INTO nyu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Patapita n'tsiku zitatu, adawauza kuti: “Citani tenepa kuti mukhale na moyo sabwa Ine ndimbagopa Mulungu. ");
INSERT INTO nyu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Penu ndimwe wanthu wakulungama, mbasale m'bodzi wa imwe m'kawoko, anangomwe ndokoni, takulani tiriguyi kuti mukamalise njala ku zinyumba zanu. ");
INSERT INTO nyu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mng'ono wanuyo mukabwere naye kuno, kutsimikiza kuti mulikulewa bzacadidi, ndipo mun'dzaphedwa lini”. Iwo wale adabvuma bzimwebzo. ");
INSERT INTO nyu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ndipo adayamba kuuzana wina na mwandzace kuti: “Cadidi, ife tidaphonya pomwe mng'ono wathu akhatikumbira kuti tim'citire ntsisi, tsono ife tilibe kumubvera kwense nsisi. Ni thangwe lace tili mumatsautso tsapano lino”. ");
INSERT INTO nyu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Pamwepo Rubeni adati: “Ine pale ndikhakuuzani kuti mulumbwanayu musamucite cinthu, imwe mulibe kundibvera. Onani, tsapano tilikutambira sagwati ya imfa yace ire”. ");
INSERT INTO nyu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Zuze akhabva bzentse bzomwe akhauzanabzo, tsono iwo walibe kudziwa, thangwe lakuti akhalewa-lewa naye kucokera mwa wakuthumbudzula. ");
INSERT INTO nyu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ndipo Zuze adayenda payekha kukalira misozi. Patsogolo pace adabwera aciyamba pomwe kulewa-lewa nawo. Adapambulapo Simeoni, adammanga pamwepo iwo alikuwona. ");
INSERT INTO nyu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ndipo Zuze adatonga kuti mabudu yawo yadzazidwe na tirigu, ndipo kuti kobiri za ali-yentse ziikhidwe m'budu mwace momwemo. Adatonga pomwe kuti awapase cakudya capaulendo. Wabasa wa Zuze adacita bzensenebzo. ");
INSERT INTO nyu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Abale wacewo adapakiza pa mabulu yawo mabudu ya tirigu ule adagulayo, ndipo adanyamuka ulendo. ");
INSERT INTO nyu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Atafika pa gowa, m'bodzi mwa iwo adatsudzula budu wace kuti atengembo cakudya cakudyesa bulu wace. Atatsudzula, adandowona kuti pamulomo pa budupo pana kobiri. ");
INSERT INTO nyu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Adacemera abale wace adawauza kuti: “Ha, wandibwezera kobiri zangu. Ni izi ziri m'buduzi”. Pamwepo wentsenewo mitima yawo idandoti pswii! Adacita mantha kwene-kwene aciti: “Mulungu waticita bzakutani ife?” ");
INSERT INTO nyu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Atafika kuna baba wawo Jakobo, ku dziko la Kanani, adamufotokozera bzentse bzomwe bzidawagwera, adati: ");
INSERT INTO nyu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Wakulemekezeka m'kulu wa dzikolo adalewa-lewa nafe mwaukali, kuti ati ndife wakuyendeza dziko lawolo. ");
INSERT INTO nyu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ife tidamuuza munthuyo kuti: ‘Ndife wanthu wakulungama, ndife lini wakuyendeza. ");
INSERT INTO nyu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ife tentse tikhalipo wana wacimuna khumi na awiri, tsono m'bodzi adafa, ndipo m'ng'ono ana baba wathu ku Kanani.’ ");
INSERT INTO nyu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Pamwepo umweyo adati: ‘Kuti ndidziwe kuti ndimwe wanthu wakulungama, m'bale wanu m'bodzi asale na ine kuno, tsono anangomwe mwentsenemwe mutenge tirigu, muyende nayo kukamalisa njala ku zinyumba zanu. ");
INSERT INTO nyu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ndipo mbale wanu wamng'onoyo mudzabwere naye kuno. Pamwepo ndipo ndidzadziwe kuti ndimwe lini wakuyendeza, tsono ndimwe wakulungama. Mbale wanuyo ndidzambwezera kuna imwe. Mukadzatenepo mungakwanise kumbadzacita basi veremawu m'dziko muno.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Atatsudzula mabudu yawo, ali-yentse adaona kuti cikwama ca kobiri cikhali momwemo mubudumo. Ataona kobirizo, iwo pabodzi na baba wawo womweyo adacita mantha kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ndipo Jakobo baba wawo adawauza kuti: “Mwandibera wana wangu. Zuze adayenda, ndipo naiyembo Simeoni wayenda, tsapano mun'funa kutengambo Benjamini, bzense bzandigwera ine!” ");
INSERT INTO nyu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubeni adauza baba wace kuti: “Mudzaphe wana wangu awiriwo, ningaleka kum'bweresa Benjamini kuna imwe. Ndipaseni nin'dzam'bweresa”. ");
INSERT INTO nyu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tsono Jakobo adati: “Mwana wangu aniyenda lini namwe nee! M'bale wace adafa, ndipo ndiye wasala yekha. Pinango angagumane cakuipa pa njira komwe mulikuyenda, mun'dzacitisa kuti imbvi zangu ziyende kuthenje na kulira”. ");
INSERT INTO nyu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Njala idakula kwene-kwene m'dziko la Kanani. ");
INSERT INTO nyu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ndipo banja la Jakobo lire latadya tirigu wentse omwe adakasundza ku Ijipito ule, Jakobo adauza wana wace wale kuti: “Ndokoni pomwe, mukatigulirembo cakudya pang'ono”. ");
INSERT INTO nyu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Pamwepo Juda adati: “Munthu ule adaticenjeza caibzo kuti: ‘Mungasaya kubwera naye mng'ono wanu, mun'dzawona lini nkhope yangu’. ");
INSERT INTO nyu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Mungatibvumiza kuti tiyende naye m'bale wathu, tiniyenda, ticikakugulirani cakudya. ");
INSERT INTO nyu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mukasaya kutibvumiza, ife tiniyenda lini, pakuwona kuti munthu omweyo adalewelatu kuti: ‘Mukasaya kubwera naye m'bale wanu mun'dzawona lini nkhope yangu.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Pamwepo Ijirayeri adati: “Thangwe ciyani mudaumisa bzinthu pa ine pakumuuza kuti muli na mbale wanu winango pomwe?” ");
INSERT INTO nyu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Iwo adatawira kuti: “Ndipo kuti munthuyo akhandobvunzisisa bza ife na bza banja lathu akhati, ‘Kodi baba wanu akana moyo? Kodi muli naye mbale wanu wina?’ Ndipo ife nibzakufunika kutawira mibvunzo yenseneyi. Kodi ife tingadadziwa tani kuti iye alikutiwuza bzakuti mbale wathuyo tiyende naye pabodzi”. ");
INSERT INTO nyu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Na tenepo Juda adauza baba wace Ijirayeri kuti: “Ndipaseni ine mulumbwanayu, tiguduke tiyende kuti tikhale na moyo tireke kufa, ife ayai imwe ngakhale wana wathu. ");
INSERT INTO nyu_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ine ndinimukoya an'khala m'manja mwangu. Ndikasaya kubwerera naye ndicimuimisa pamaso panu nin'dzakhala na thangwe kwa imwe lakusaya kumala. ");
INSERT INTO nyu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Tingadasaya kupondaponda, tingadayenda na kubwerako kawiri kense tsapano”. ");
INSERT INTO nyu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ndipo baba wawo Ijirayeri adawauza kuti: “Penu na momwe bziriri, citani tenepo. Munthuyo mtengerenimbo bzisapo bzakukoma bza dziko lino m'mabudu mwanu kuti mukampase. Mumtengere pomwe mafuta yazinji pang'ono, uci pang'ono, mafuta yakununchira yakusiyana-siyana, mure, manduwi, ndipombo bzisapo bzinangombo. ");
INSERT INTO nyu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mutenge kobiri ntsengwa yakufunya kawiri, kuti mukabweze kobiri zomwe zidawoneka m'mabudu mwanu zire. Pinango bzidacitika mwa kuphonya. ");
INSERT INTO nyu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mtengeni m'bale wanuyu, ndipo nyamukani, muyende pomwe kuna munthuyo. ");
INSERT INTO nyu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mulungu Wa mphambvu akucitireni ntsisi pamaso pa munthuyo, kuti abweze m'bale wanu winango ule pabodzi na Benjamini. Cipande ca ine, penu niniluza wana, nin'dzakhala ndilibe wana”. ");
INSERT INTO nyu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Na tenepo abale wentse wale adatenga mphaso zire, ndipo adatenga pomwe kobiri ntsengwa yakufunya kawiri, acitengambo Benjamini. Adakonzeka, adaguduka ulendo kuyenda ku Ijipito. Kumweko adakawonekera pamaso pa Zuze. ");
INSERT INTO nyu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Zuze atawona Benjamini pabodzi nawo, adauza akapolo wakunyang'anira bzentse panyumba pace kuti: “Wanthu awa apitewentse m'nyumba. Ndipo uphe nyama na kuiphika bwino, thangwe wanthu amwewa an'dya na ine masikati yano”. ");
INSERT INTO nyu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kapoloyo adacita ninga momwe Zuze adamuuzira, adayenda nawo abale wale kunyumba kwa Zuze. ");
INSERT INTO nyu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tsono iwo adacita mantha kwene-kwene pakuwona kuti alikuyenda nawo kunyumba kwa Zuzeyo, akhakumbuka kuti: “Alikutipitisa muno thangwe la kobiri zire zidabwezedwa m'mabudu mwathu Panthawe yakuyamba ire. Alikutondofuna mulandu wakuti acite nafe nkhondo mwadzidzidzi, thangwe alikufuna kutisandusa anyagrinya wace na kutibera mabulu yathuya”. ");
INSERT INTO nyu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Na tenepo wakanatikupita m'nyumbamo adafika kwa wabasa wa Zuze wakunyang'anira nyumba ule, ");
INSERT INTO nyu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","acimuuza kuti: “Pepani mbuya, ife tidabwerambo kuno kale kudzagula cakudya. ");
INSERT INTO nyu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Tatafika pa mbuto ya gowa, pakutsudzula mabudu yathu, ali-yentse mwa ife adaona kobiri yace kumulomo kwa budu lace, ndipo kobirizo zikhalipo zentse ninga momwe tidazilewengera. Kobiri zimwezo tabwera nazo. ");
INSERT INTO nyu_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ndipo tabwera naizombo kobiri zinango zakudzagulira cakudya cinango. Omwe adaikha kobiri m'mabudu mwathu, tilikumudziwa lini nee”. ");
INSERT INTO nyu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Wabasa ule adati: “Lekani thupo, mitima yanu ikhale pantsi. Mulungu wanu, Mulungu wa baba wanu, ndiye omwe adakuikhirani kobiri zanu mumabudumo. Kobiri zanu zakuyamba zire ndidatambira”. Na tenepo, adawacosera Simeoni ule. ");
INSERT INTO nyu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kapoloyo watabwera nawo abalewo m'nyumba mwa Zuze, adawapasa madzi kuti asambe minyendo yawo, ndipo mabulu yawo yale adayadyesambo. ");
INSERT INTO nyu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ndipo abalewo adakondzeratu mphatso zawo zire Zuze akanati kubwera masikati, thangwe akhadabva kuti an'kadya kumweko. ");
INSERT INTO nyu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Pomwe Zuze adafika pa nyumba, abale wace adam'bweresera m'nyumba mphatso zomwe zikhali m'manja, ndipo adagodama pa maso pace wacitsulima mpaka pantsi. ");
INSERT INTO nyu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Iye adawabvundza momwe aliri, aciwabvunza pomwe kuti: “Kodi baba wanu wakukalamba ule mukhandiuzayo ali tani? Kodi akana moyo?” ");
INSERT INTO nyu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Iwo adatawira kuti: “Mtumiki wanu akana moyo, ndipo ali bwino”. Ndipo wentsenewo adamugodamira pomwe wacimkotamira pamwepo. ");
INSERT INTO nyu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Zuze pomwe adanyang'ana adawona Benjamini, m'bale wace caiye mwana wa mai wace, ndipo adati: “Uyu ndiye m'bale wanu wakumalizira ule omwe mukhalewa?” Ndipo adati: “Mulungu akudalise, mwana wangu”. ");
INSERT INTO nyu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Atalewa bzimwebzo Zuze adacoka pamwepo mwakam'kulumize thangwe lakuti m'tima wace udadzala na nsisi thangwe la mng'ono wace ule. Akhali pafupi-fupi kulira, na tenepo adapita m'cipinda mwace adakalira mumwemo. ");
INSERT INTO nyu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Atapukuta m'maso adabura, ndipo adalimba pomwe m'tima, adatonga kuti cakudya cibwere. ");
INSERT INTO nyu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Zuze akhadya payekha, abale wacewo akhadya pameza inango. AIjipito omwe akhali naye m'nyumba naiwombo akhadya paokha, thangwe iwo akhanyansidwa kudyera pabodzi na Ahebri. ");
INSERT INTO nyu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Abalewo akhadakhala pa mesa patsogolo pa Zuze, ndipo akhali atawaikha mwakutewererana na kubadwa kwawo, kuyambira wamkulu mpaka wamng'ono. Abale wale ataona momwe adawakhazikira, adadabwa kwene-kwene acimbanyanganisana. ");
INSERT INTO nyu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Cakudya comwe akhadyaco cikhacokera pa mesa pa Zuze, tsono cakudya cakupasa Benjamini cikhaposa ca wentsenewo ka xanu. Na tenepo wentsenewo adadya na kumwa pabodzi na Zuze mpaka kukhuta, ndipo adakodwela pabodzi naye. ");
INSERT INTO nyu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Patsogolo pace Zuze adauza wabasa mkulu wakunyang'anira nyumba yace kuti: “Dzaza phoso m'mabudu yomwe yabwera na wanthuwa, momwe angakwanisire kunyamula. Ndipo ikha kobiri za m'bodzi na m'bodzi pamulomo pa budu la phoso. ");
INSERT INTO nyu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mkombo wangu wa parata ikha pamulomo pa budu la phoso la mng'ono, pabodzi na kobiri zace zomwe akhafuna kugulira tirigu”. Kapoloyo adacita ninga momwe adamuuzira. ");
INSERT INTO nyu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Macibese kwatacena, wanthu wale adagoneka iwo na mabulu yawo. ");
INSERT INTO nyu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Adandocoka pang'ono mum'zindamo, Zuze adauza wabasa wace mkulu ule kuti: “Nyamuka, uthamangire wanthu wale. Ungawagumana, abvundze kuti: ‘Thangwe lanyi mwabwezera cakuipa pa mbuto ya cabwino? ");
INSERT INTO nyu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ndiwo lini mkombo omwe ambamwera mbuya wangu? Omwe ambavimira nawo? Bzomwe mwacitabzi ni bzakuipa.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Wabasa ule adawagumana, aciwauza mafalayo. ");
INSERT INTO nyu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Iwo adamutawira kuti: “Thangwe ranyi mulikulewa mafala yamweya mbuya? Ife anyagrinya wako tingacite lini bzinthu ninga bzimwebzo. ");
INSERT INTO nyu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kobiri yomwe tidawona m'milomo ya mabudu ya phoso, tidakubwezerani kuyambira ku dziko la Kanani, tsono tingadaba tani ku nyumba kwa mbuya wako parata ayai oro? ");
INSERT INTO nyu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Mwa anyagrinya wako, omwe an'gumanidwa na mkomboyo afe, ndipo ife tentse tin'dzakhala anyagrinya wako, mbuya!” ");
INSERT INTO nyu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Pamwepo kapoloyo adati: “Bzicitike ninga momwe mwalewera. Ule omwe an'gumaniwa nawo an'khala nyagrinya wangu, tsono anangomwe mun'khala wakusaya thangwe”. ");
INSERT INTO nyu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Na tenepo adabulusa mwakan'kulumize mabudu yawo, ali-yentse adatsudzula budu lace. ");
INSERT INTO nyu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Wabasa mkulu wa Zuze ule adafufudza-fufudza kuyambira pa m'kulu mpaka pa mng'ono, ndipo mkomboyo adawugumana m'budu la phoso la Benjamini. ");
INSERT INTO nyu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Pamwepo adang'amba bzakubvala bzawo. Adasendzesa pomwe mabulu mitolo yawo, wacibwerera kum'zinda. ");
INSERT INTO nyu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Juda na abale wace atafika kunyumba kwa Zuze, adagumana iye akalipo ndipo adakwathama pantsi pamaso pace. ");
INSERT INTO nyu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Zuze adati: “Ciyani cimweci comwe mwacita? Kodi mulikudziwa lini kuti munthu ninga ine an'kwanisa kuvimira?” ");
INSERT INTO nyu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Pamwepo Juda adati: “Kodi tingatawire ciyani kuna imwe, mbuya? Tinilewa ciyani? Tin'bzicitisa tani wakusaya thangwe? Mulungu wazimbula cakuphonya cathu, mbuya. Ndife anyagrinya wanu mbuya, ife ngakhale omwe agumanidwa na mkomboyo”. ");
INSERT INTO nyu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Tsono Zuze adati: “Ningacite lini bzimwebzo. Munthu omwe wagumanidwa na mkombo yekha, ndiye an'dzakhala nyagrinya wangu. Tsono anangomwe ndokoni mwa m'tendere kuna baba wanu”. ");
INSERT INTO nyu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Pamwepo Juda adafendera kuna Zuze, aciti “Ndilekeleleni mbuya, ndibvumizeni ine nyagrinya wanu kuti ndilewe namwe. Lekani kukalipa nande mbuya, imwe muli ninga Falau caiye. ");
INSERT INTO nyu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mbuya, mudatibvunza kuti: ‘Kodi muna baba ayai m'bale wanu?’ ");
INSERT INTO nyu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ndipo ife tidakutawirani kuti: ‘Tina baba wathu nkhalamba na mwana m'bodzi wakumalizira wa unkhalamba bwace. Mkulu wace adafa ndipo iye yekha ndiye adasala m'mimba mwa mai wace, ndipo baba wace ambam'funa’. ");
INSERT INTO nyu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Mbuya, pale imwe mudatiuza kuti: ‘Mudzabwere naye, kuti ndidzamuwone’. ");
INSERT INTO nyu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ife tidakutawirani kuti: ‘Mulumbwanayo angacoke lini kuna baba wace, pakuwona kuti angacita tenepo, baba waceyo kufa kudzakhala komweko.’ ");
INSERT INTO nyu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ndipo mudalewa kuti mun'dzatibvumiza lini kufika pomwe pamaso panu tikadzaleka kubwera naye mng'ono wathuyu. ");
INSERT INTO nyu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tatabwerera kwathu kuna baba wathu nyagrinya wanu, tidamuuza mafala yanu yentse yale. ");
INSERT INTO nyu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Baba wathu adatiuza kuti: ‘Bwererani mukatigulirembo phoso pang'ono,’ ");
INSERT INTO nyu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ife tidamuuza baba wathu kuti: ‘Tin'kwanisa lini kuyenda, tsono mungatibvumiza kuyenda na m'bale wathu mng'ono, tiniyenda. Sabwa tingasaya kuyenda na mng'ono wathu, tin'kafika lini pamaso pa munthu ule.’ ");
INSERT INTO nyu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tsono nyagrinya wanu baba wathu adati: ‘Mun'dziwa kuti mkazi wangu adandibalira wana awiri. ");
INSERT INTO nyu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","M'bodzi mwa iwo adandisiya. Ndipo ine ndidati: Cadidi adakhabvulidwa, mpaka lero ndiribe kumuwona pomwe. ");
INSERT INTO nyu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tsapano mukanditengera pomwe uyu pamaso pangu, ndipo pinango angagumane na cakuipa, mun'dzacitisa kuti imbvi zangu ziyende kuthenje na kulira.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Juda adapitiriza kulewa aciti: “Tsapano ndikabwerera kwa nyagrinya wanu baba wangu, ndicisaya kuyenda naye mulumbwanayu, omwe m'tima wa baba wangu na wace udabverana, ");
INSERT INTO nyu_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","wakatondokawona kuti umweyu palibe, basi wan'kafa. Ndipo anyagrinya wanu tin'dzacitisa kuti imbvi za nyagrinya wanu, baba wathu, ziyende ku thenje na kulira. ");
INSERT INTO nyu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ndipombo mbuya, ine ndidapereka moyo wangu kwa baba wangu thangwe la mulumbwana umweyu. Ndidamuuza kuti penu mulumbwanayu nin'dzabwerera lini naye, nin'dzakhala wakuphonya pamaso pa baba wangu moyo wangu wentse. ");
INSERT INTO nyu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ndipo tsapano mbuya, ine ndin'sala kuno kuti nin'khala nyagrinya wanu pambuto ya mulumbwanayu. Mbvumizeni umweyu ayende na abale wacewa. ");
INSERT INTO nyu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ine nin'kwanisa tani kuyenda kuna baba wangu pakusaya mulumbwanayu kuyenda nande? Ine ndekha nin'kwanisa lini kupirira kuti ndiwone tsoka la tenepa lilikugwera baba wangu”. ");
INSERT INTO nyu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Pamwepo Zuze alibe kukwanisa pomwe kubziphata pamaso pa wentse wakumutumikira wale. Adalewa mwakukuwa mafala kuti: “Wentse wacoke muno”. Na tenepo pakhalibe na m'bodzi yekha wakusalilira pomwe Zuze akhabzilatiza kwa abale wace wale. ");
INSERT INTO nyu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Adalira mwakubveka na tenepo aIjipito adabva, ndipo mbiri ya bzimwebzo idakafika mpaka kunyumba kwa Falau. ");
INSERT INTO nyu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Zuze adauza abale wace kuti: “Ine ndine Zuze. Kodi baba wangu akana moyo?” Tsono abale wacewo adadzazidwa na mantha, na tenepo kuti alibekukwanisa pomwe kumutawira cinango. ");
INSERT INTO nyu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ndipo Zuze adawauza kuti: “Ndaphata minyendo fenderani pafupi”. Wentse watafendera pafupi, Zuze adati: “Ine ndine m'bale wanu ule Zuze, omwe mudamugulisa ku Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ndipo tsapano lekani kutaya m'tima ngakhale kubzinesa mwekha, na thangwe la kundigulisa kuti ndibwere kuno. Nakuti Mulungu ndiye adandituma patsogolo pa imwe kuti mukhale na moyo. ");
INSERT INTO nyu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Gole lino ni gole laciwiri la njala. Tsono yasala magole maxanu, ndipo pa magole yamweya wanthu an'dzalima lini penu kubvuna. ");
INSERT INTO nyu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Mulungu adandituma patsogolo panu kuti bzizukulu bzanu bzikoyeke pa dziko na tenepo kuti mupitirize kukhala na moyo mwa cipulumuso cikulu. ");
INSERT INTO nyu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Na tenepo ndimwe lini omwe mudanditumiza kuno nee, tsono Mulungu. Iye wandisandusa wakulemekezeka mukulu wa Falau. Dziko lentse lino lili m'manja mwangu. Ijipito yense ndirikutonga ndine. ");
INSERT INTO nyu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Tsapano kulumizani, bwererani kuna baba wangu, mukamuuze kuti mwana wanu Zuze alikulewa kuti: ‘Mulungu wandikuza mpaka kukhala wakutonga Ijipito yense, ndipo bwerani kuno, lekani kucedwa. ");
INSERT INTO nyu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Mun'dzakhala ku dziko la Goseni, ndipo mudzakhale pafupi na ine. Mudzakhale imwepo, wana wanu, bzizukulu bzanu, mabira yanu na mbuzi kubodzi, ng'ombe zanu pabodzi na bzentse bzomwe munabzo. ");
INSERT INTO nyu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mukadzakhala ku Goseni, ine ndin'dzakukongobzani. Magole ya njala yakalipo maxanu. Ndin'funa lini kuti imwe musauke pabodzi na banja lanu, na wentse omwe muli nawo.’ ");
INSERT INTO nyu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ndipo mwentsenemwe na Benjamini, mng'ono wangayu, mungakwanise kuwona kuti ndine cadidi omwe ndilikulewa-lewa namwe. ");
INSERT INTO nyu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Muuzeni baba wangu kuti ndiri pa utongi ukulu ku Ijipito kuno. Mukamuuze pomwe baba wangu bzentse bzomwe mwawonabzi ndipo kulumizani, kubwera naye kuno”. ");
INSERT INTO nyu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Na tenepo adakumbatira Benjamini, mng'ono wace ule, aciyamba pomwe kulira. Na iyembo Benjamini adakumbatiriwa terepo adayamba kulira. ");
INSERT INTO nyu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Patsogolo pace adawampsompsona abale wace wentse wale alikulira. Patsogolo pace abale wace wale adayamba kuceza naye Zuze. ");
INSERT INTO nyu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Bzatabveka kunyumba kwa Falau kuti abale wa Zuze abwera, Falauyo na wabasa wace wentse adakondwa kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ndipo Falau adauza Zuze kuti: “Uza abale wako kuti asendzese bzifuwo bzawo mitolo, ndipo abwerere kudziko la Kanani. ");
INSERT INTO nyu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ndipo kumweko katengeni baba wanu na mabanja yanu, bwerani kuna ine. Nin'dzakupasani dziko la ndovolo ku Ijipito kuno, ndipo mun'dzadya bza m'dziko lino. ");
INSERT INTO nyu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Wauzembo kuti: ‘Citani ibzi, tengani ngolo za kuno ku Ijipito, kuti akazi wanu apakire pabodzi na wana. Katengeni baba wanu mubwere. ");
INSERT INTO nyu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Lekani thupo kuti musiye mitolo yanu kumweko, thangwe dziko labwino la ndovolo la ku Ijipito kuno lin'dzakhala lanu.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ndipo aIjirayeri adacita zimwezo. Zuze adawapasa ngolo ninga Falau adatongera, aciwapasa cakudya capaulendo. ");
INSERT INTO nyu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Adawapasa pomwe ali-yentse bzakubvala bzacikondwerero, tsono Benjamini adampasa kobiri zasiiva zakukwana 300, na bzakubvala bzixanu bzacikondwerero. ");
INSERT INTO nyu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Baba wace adamtumizira mabulu khumi yakusenza bzisapo bzakukoma bza ku Ijipito, na mabulu khumi yakusenza tirigu, mnkate na bzakudya bzina bza baba wace bzapaulendo. ");
INSERT INTO nyu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ndipo adawauza abale wacewo kuti ayende, ndipo pakuyendapo adalewa kuti: “Lekani kupokana pa njira”. ");
INSERT INTO nyu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ndipo iwo adacoka ku Ijipito, kubwerera ku dziko la Kanani, kuna baba wawo Jakobo. ");
INSERT INTO nyu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Atafika, adauza baba wawo kuti: “Zuze akana moyo! Ndiye alikutonga dziko lentse la Ijipito”. Na bzimwebzo, Jakobo adakomoka, sabwa alibe kukhulupirira. ");
INSERT INTO nyu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tsono iwo atamuuza bzentse bzomwe Zuze adawauza, ndipo iye atawona ngolo zomwe Zuze adatumiza kuti iye akwire pakuyenda ku Ijipito, Jakobo adayamba kuphephuka. ");
INSERT INTO nyu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ndipo adati: “Basi inde, mwana wangu Zuze akana moyo. Ndiniyenda ndikamuwone ndikanati kufa”. ");
INSERT INTO nyu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ijirayeri adayenda na bzace bzentse ku Bereseba kukapereka ntsembe kuna Mulungu wa baba wace Izaki. ");
INSERT INTO nyu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Usiku Mulungu adawonekera Ijirayeri m'masomphenya, ndipo adati: “Jakobo, Jakobo!” Iye adatawira kuti: “Inde Mbuya!” ");
INSERT INTO nyu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ndipo adamuuza kuti “Ine ndine Mulungu, Mulungu wa baba wako. Leka mantha kuyenda ku Ijipito. Kumweko nin'dzawandisa bzizukulu bzako, kuti bzikhale mtundu ukulu wa wanthu. ");
INSERT INTO nyu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ine nin'dzapolika nawe ku Ijipito, ndipo nin'dzakukwiza pomwe cadidi. Manja ya Zuze yan'dzafunga maso yako”. ");
INSERT INTO nyu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ndipo Jakobo adanyamuka kucokera ku Beereseba. Wana wace wa Ijirayeri wale adakwiza baba wawo Jakobo, pabodzi na akazi na wana, pa ngolo zomwe Falau adatumiza. ");
INSERT INTO nyu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Adatenga bzifuwo bzawo bzentse pabodzi na bzinthu bzentse bzomwe akhali nabzo ku Kanani, ndipo adayenda ku Ijipito. Jakobo adatenga bzizukulu bzace bzentse, ");
INSERT INTO nyu_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ndipo kuti wana na azukulu wace wacimuna, ndipombo wana na azukulu wace acikazi. Wentsenewo adayenda nawo ku Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ngaya madzina ya aIjirayeri omwe adayenda ku Ijipito, ndipo kuti Jakobo na wana wace. Rubeni, mwana waciutswaka wa Jakobo, ");
INSERT INTO nyu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","na wana awa wa Rubeni: Hanoki, Palu, Hezironi na Karimi. ");
INSERT INTO nyu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Wana wa Simeoni akhali awa: Yemuwele, Yamini, Ohadi, Yakini, Zohari na Shaulo, yomwe mai wace akhali mkazi wa ku Kanani. ");
INSERT INTO nyu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Wana wa Levi akhali awa: Geresoni, Kohati na Merari. ");
INSERT INTO nyu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Wana wa Juda akhali awa: Ere, Onani, Sela, Perezi na Zera, (tsono Ere na Onani adafera ku Kanani.) Wana wa Perezi akhali awa: Hezironi na Hamuli. ");
INSERT INTO nyu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Wana wa Isakara akhali awa: Tola, Puva, Iyobu na Simironi. ");
INSERT INTO nyu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Wana wa Zebuloni akhali awa: Seredi, Eloni na Yaleele. ");
INSERT INTO nyu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","(Wana amwewa ndiwo omwe Leya adabalira Jakobo ku Mesopotamiya kule, ndipo akhalipombo mwana wace wacikazi Dina. Azukulu wakubadwa mwa Leya akhalipo 33 wentse pabodzi.) ");
INSERT INTO nyu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Wana wa Gadi akhali awa: Zifiyoni, Hagi, Suni, Eziboni, Eri, Arodi na Areli. ");
INSERT INTO nyu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Wana wa Asere akhali awa: Imina, Isiva, Isivi, Beriya na mpfumakazi yawo Sera. Wana wa Beriya akhali awa: Hebere na Malikiele. ");
INSERT INTO nyu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","(Wentsenewa khumi na atanthatu akhali azukulu wa Jakobo wakubadwa mwa Zilipa omwe Labani adapereka kuna mwana wace Leya.) ");
INSERT INTO nyu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Wana wa Rakeli mkazi wa Jakobo wakhali awa: Zuze na Benjamini. ");
INSERT INTO nyu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Manase na Eferemu akhali wana omwe Zuze adabala mwa Asenati ku dziko la Ijipito, mwana wa Potifera nyantsembe wa ku Oni. ");
INSERT INTO nyu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Wana wa Benjamini akhali awa: Bela, Bekara, Asibele, Gera, Naamani, Ehi, Rosi, Mupimu, Hupimu na Aridi. ");
INSERT INTO nyu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","(Wentsenewa 14 ndiwo azukulu wa Jakobo mwa mkazi wace Rakeli.) ");
INSERT INTO nyu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dani akhali na mwana m'bodzi yekha dzina lace Husimu. ");
INSERT INTO nyu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Wana wa Nafutali akhali awa: Yazeele, Guni, Yezera na Silemu. ");
INSERT INTO nyu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","(Axanu na awiriwa ndiwo azukulu wa Jakobo omwe adabadwa mwa Biliha, omwe Labani adapereka kuna mwana wace Rakeli.) ");
INSERT INTO nyu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Cilewengero cense ca wanthu wakucokera mwa Jakobo, omwe adayenda ku Ijipito, cikhali 66, nee kulewenga akazi wa wana wace. ");
INSERT INTO nyu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Pakuwona kuti Zuze adabala wana awiri ku Ijipito, cilewengero cidafika 70. Wentsenewa akhali wa m'banja la Jakobo, ndipo ndiwo adayenda ku Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ijirayeri adatuma Juda patsogole pace kuna Zuze kuti amkam'tsogolere njira ya kuGoseni. Ndipo adafika ku dziko la Goseni, ");
INSERT INTO nyu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Zuze adacemeresa ngolo yace, adayenda ku Goseni kukagumana na Ijirayeri baba wace. Atondofika pamaso pace, adamkumbatira m'khosi, adalira nthawe itali cadidi, alibe kumulekera. ");
INSERT INTO nyu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ijirayeri adauza Zuze kuti: “Tsapano mbandife, pakuti ndawona nkope yako, ndipo ukana moyo”. ");
INSERT INTO nyu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Pamwepo Zuze adauza abale wace wale pabodzi na banja lense la baba wace kuti “Ndiniyenda ndikamuuze Falau kuti abale wangu pabodzi na wentse wa m'banja la baba wangu omwe akhakhala ku Kanani, abwera kuno kwa ine. ");
INSERT INTO nyu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Wanthu amwewa na abusa, wakuusa bzifuwo. Mabira yawo na ng'ombe kubodzi abwera nabzo, pabodzi na bzinthu bzawo bzentse. ");
INSERT INTO nyu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ndipo Falau akakucemerani, ndipo acikubvunzani kuti: ‘Mumbaphata basa lanyi?’ ");
INSERT INTO nyu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Imwe mukamuuze kuti: ‘Ife mbuya, ndife wakuusa bzifuwo kuyambira ubwana bwathu, ninga momwe akhacitira makolo yathu.’ Mukatenepo, ndiko kuti mun'dzakwanisa kukakhala m'dziko la Goseni”. Zuze adalewa bzimwebzo thangwe lakuti aIjipito akhanyansidwa na abusa. ");
INSERT INTO nyu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Pamwepo Zuze adabwera kuna Falau kuti: “Baba wangu pabodzi na abale wangu abwera kucokera ku Kanani. Abwera na bzifuwo bzawo ninga mabira na ng'ombe, pabodzi na bzawo bzentse. Tsapano alikukhala m'dziko la Goseni”. ");
INSERT INTO nyu_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ndipo adatenga abale wace axanu adayenda kukawonesa Falau. ");
INSERT INTO nyu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pamwepo Falau adawabvunza kuti: “Kodi mumbaphata basa lanyi?” Iwo adatawira kuti: “Ndife abusa mbuya, ninga momwe akhacitira makolo yathu”. ");
INSERT INTO nyu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Adamuuza pomwe Falau kuti: “Tabwera kudzakhala m'dziko muno, thangwe ku Kanani kuna njala yakugosva, na tenepo kwentse kulibe mpfuzo zakudyesa bzifuwo. Ndaphata minyendo mbuya, mutibvumize tikakhale ku dziko la Goseni”. ");
INSERT INTO nyu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Falau adauza Zuze kuti: “Baba wako pabodzi na abale wako abwera kwa iwe. ");
INSERT INTO nyu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Dziko la Ijipito lili m'manja mwako. Ukhazike baba wako pabodzi na abale wako m'dziko la ndovolo, akakhale ku Goseni. Ndipo penu winango mwa iwo ni wakukwimika wa bzifuwo, uwapase ukulu wakunyang'anira bzifuwo bzangu”. ");
INSERT INTO nyu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Zuze adatenga baba wace Jakobo, adayenda naye kuna Falau. Ndipo Jakobo adadalisa Faraoyo. ");
INSERT INTO nyu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Patsogolo pace Falau adabvunza Jakobo kuti: “Muli na magole mangasi?” ");
INSERT INTO nyu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakobo adatawira kuti: “Magole ya maulendo yangu yan'kwana 130. Magole yamweya ngakucepa ndipombo ngamatsautso, ngakusaya kulingana na magole ya maulendo ya makolo yangu”. ");
INSERT INTO nyu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ndipo atadalisa Falau, adagonekana naye acicoka. ");
INSERT INTO nyu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Zuze adamkhazika m'dziko la Ijipito baba wace ule, pabodzi na abale wace wentse wale, ndipo adawapasa mbuto ya nthaka yabwino na yamtendere, mucigawo cakucemeredwa Ramsesi, ninga momwe Falau adatongera. ");
INSERT INTO nyu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Zuze adapereka cakudya kwa baba wace na kwa abale wace na kwa mbumba yentse, pakuteweza kuwanda kwa wana wawo. ");
INSERT INTO nyu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Njala ire idakula kwene-kwene, na tenepo kuti pakhalibe cakudya pa dziko lense la pansi, ndipo wanthu wa ku Ijipito na wa ku Kananimbo wakhalibe mphambvu nayo njalayo. ");
INSERT INTO nyu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Zuze adakhongobza kobiri zentse zomwe wanthu wa ku Ijipito pabodzi na wa ku Kanani adadzonga pakugula tirigu. Kobiri zensenezo adazitenga aciyenda nazo kunyumba kwa Falau. ");
INSERT INTO nyu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kobiri zense zatawamarira wanthu wa ku Ijipito na wa ku Kanani, aIjipito wazinji adabwera kwa Zuze, acimuuza kuti: “Tipasenimbo cakudya! Lekani kutilekerera kuti tife, citanipo cinthu! Kobiri zathu zense zamala!” ");
INSERT INTO nyu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Zuze adawatawira kuti “Bwerani na bzifuwo bzanu, tidzacinjane na cakudya, penu mulikuti kobiri zanu zidamala zense”. ");
INSERT INTO nyu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Na tenepo adabwera na bzifuwo bzawo kwa Zuze, adacinjisa na cakudya bzifuwo bzawobzo, ninga makavalo, mabira na mbuzi, ng'ombe na mabulu. Gole lomwero Zuze adawapasa cakudya wanthuwo mwakucinjana na bzifuwo bzawobzo. ");
INSERT INTO nyu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Latamala gole lomwero, wanthuwo adayeda pomwe kwa Zuze acimuuza kuti: “Mbuya, ife tin'kubisirani lini kuti kobiri zathu pabodzi na bzifuwo bzathu kubodzi, bzatimalira. Palibe ciricense cakusala cakuti tingakwanise kukupasani, tin'tondokubzipereka ife pano na minda yathuyi. ");
INSERT INTO nyu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Lekani kutilekerera kuti tife m'dziko mwathu, imwe mulikuwona. Tipasenimbo cakudya, ndipo tibzigulise ife pano na minda yathu kubodzi. Tin'dzakhala anyagrinya wa Falau, iye an'dzatenga minda yathu kuti ikhale yace. Tipasenimbo mbeu kuti tikhale na moyo ndipo tileke kufa. Minda yathu ileke kukhala matsala”. ");
INSERT INTO nyu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Zuze adagulila Falau dziko lensene la Ijipito. Mujipito ali-yentse adagulisa minda yace thangwe njalayo ikhali yatafika pakuipa kwene-kwene. Na tenepo dziko lense lidasanduka la Falau. ");
INSERT INTO nyu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Zuze adawasandusa anyagrinya wanthuwo pensepense m'dziko la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Minda ya wantsembe yokha iye alibe kuigula. Sabwa wantsembe akhana cipande ca phoso comwe Falau akhawapasa, iwo akhadya cipande comwe Falau akhadawapasa. Ndipopo alibe kugulisa minda yawo. ");
INSERT INTO nyu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Zuze adauza wanthu kuti: “Onani tsapano ndakugulani pabodzi na minda yanu yense, kugulira Falau. Ndipo niizi mbeu, mubzale m'minda mwanu. ");
INSERT INTO nyu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Panthawe yakubvuna mudzapereka kwa Falau cibodzi mwa bzigawo bzixanu bzilibzense pa bzakubvuna bzanubzo, ndipo bzinango bzense bzakusala bzin'dzakhala bzanu. Bzinango mudzakoye mbeu, tsono bzinango mudzadye imwepo, mabanja wanu na wabasa wanu”. ");
INSERT INTO nyu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wanthu adatawira kuti: “Mwapulumusa moyo wathu. Pitirizani kutikomera m'tima ndipo tin'dzakhala anyagrinya wa Falau”. ");
INSERT INTO nyu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Na tenepo Zuze adaikha mtemo m'dziko lentse la Ijipito kufikira ntsiku ya lero kuti cibodzi mwa bzigawo bzixanu bzilibzentse pa bzakubvuna bzin'dzakhala bza Falau. Ntemo umweyu ulipobasi mpaka lero lino. Tsono madziko ya wansembe okha alibe kuyatenga kuti akhale wa Falau. ");
INSERT INTO nyu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Na tenepo Ijirayeri adakhala ku dziko la Ijipito, cipande ca kuGoseni. Iwo adakhala wa cipande ca dzikolo, ndipo adabala pomwe wana wazinji. ");
INSERT INTO nyu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakobo adakhala ku Ijipito, magole 17, tenepo magole ya moyo wace yadakwanira 147. ");
INSERT INTO nyu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ndipo ali pafupi kufa, adacemera mwana wace Zuze acimuuza kuti: “Penu ulikundifuna cadidi, undiphate m'kati mwa nchafu yanguyi, picira kuti un'dzandikomera m'tima na kukhulupirika kwa ine, ndipo kuti citanda cangu un'dzacipendesa lini ku Ijipito kuno. ");
INSERT INTO nyu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nin'funa kukagona pabodzi na makolo yangu. Citanda cangu udzacicose ku Ijipito kuno ukacipendese muthenje la makolo yangu”. Zuze adatawira kuti: “Nin'dzacita ninga momwe mwaleweramu”. ");
INSERT INTO nyu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jakobo adauza pomwe Zuze kuti: “Picira pamaso pangu kuti un'dzacita cadidi bzimwebzi”. Iye adam'picirira. Ndipo Ijirayeri adakotama acipemba kum'solo kwa talimba. ");
INSERT INTO nyu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Patapita nthawe, Zuze adabva kuti “Baba wanu ali kudwala”. Adatenga wana wace awiri, Manase na Eferemu, adayenda nawo kwa Jakobo. ");
INSERT INTO nyu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Jakoboyo atabva kuti “Mwana wanu Zuze wabwera kudzakumusani,” adabzilimbisa, acimuka, n'kukhala mwa kukhazikika patalimba pamwepo. ");
INSERT INTO nyu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakobo adauza Zuze kuti: “Mulungu Wamphambvu zentse adandiwonekera na kundidalisa ku Luzi m'dziko la Kanani. ");
INSERT INTO nyu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Adandiwuza kuti: ‘Nin'dzakupasa wana wazinji na tenepo kuti bzizukulu bzako bzin'dzasanduka mitundu izinji ya wanthu. Dziko lino ndin'dzapasa bzizukulu bzako kuti likhale lawo mpaka kuyenda-na-kuyenda.’ ");
INSERT INTO nyu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ndipo wana wako awiri, omwe udabereka ku Ijipito kuno, ine ndikanati kubwera, omwewombo ni wangu. Efuremu na Manase an'dzakhala wangu cadidi, ninga momwe aliri Rubeni na Simeoni. ");
INSERT INTO nyu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tsono wakubadwa pambuyo pa iwopo, ni wako amwewo. An'dzatambira nthaka yawo pabodzi na wacibale wawo. ");
INSERT INTO nyu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ndacita bzimwebzi thangwe lakuti pomwe ndikhabwerera kucokera ku Mesopotamiya, mai wako Rakeli adafera m'dziko la Kanani, tikanati kufika ku Efurata. Ntsisi zangu zikhali zikulu. Ndipo ndidamuikha komweko pa mseu wa ku Efurata kuBelee”. ");
INSERT INTO nyu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ijirayeri atawona wana wa Zuze, adabvundza kuti: “Kodi awa mbani?” ");
INSERT INTO nyu_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Zuze adatawira baba wace kuti “Amwewa ni wana wangu omwe Mulungu adandipasa kuno”. Pamwepo Ijirayeri adati: “Ndaphata minyendo abwere kuno wanawo kuti ndiwadalise”. ");
INSERT INTO nyu_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Maso ya Ijirayeri yakhawona lini bwino thangwe la unkhalamba. Zuze adawabweresa pafupi na iye wanawo ndipo adawakumbatira, aciwampsompsona. ");
INSERT INTO nyu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ijirayeri adauza Zuze kuti: “Ndikhadikhira lini kuti ndingakuwone pomwe, tsono tsapano Mulungu wandibvumiza kuti ndiwone wana wako kubodzi”. ");
INSERT INTO nyu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ndipo Zuze adatenga wanawo aciwacosa pa minyendo ya baba wace, ndipo adamugodamira. ");
INSERT INTO nyu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Zuze adawaphata paboko wanawo, Eferemu ku boko ladidi kuti pakutenepo akhale ku boko ladzere la Jakobo. Manase adakhala kumadzere kuti pakutenepo akhale ku boko ladidi la Jakobo. ");
INSERT INTO nyu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tsono Ijirayeri adapitanisa manja. Na tenepo adasanzika boko lace ladidi pamsolo pa Eferemu omwe akhali wamng'ono, boko ladzere adalisanzika pamsolo pa Manase omwe akhali wamkulu. ");
INSERT INTO nyu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ndipo adadalisa Zuze na mafala yakuti: “Mulungu omwe makolo yangu Abrahamu na Izaki yadamutumikira, Mulungu omwe ni m'busa wa moyo wangu wentse mpaka ntsiku ya lero, ");
INSERT INTO nyu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Anju yomwe imbandikhocherera ku bzakuipa bzentse, idalise alumbwanawa! Dzina langu na madzina ya makolo yangu Abrahamu na Izaki yambadzagumidwe pakati pawo nthawe zentse, ndipo adzawande kwene-kwene pa dziko la pantsi!” ");
INSERT INTO nyu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Zuze atawona kuti baba wace wasandzika boko ladidi pamsolo pa Eferemu, alibe kukomedwa. Na tenepo adatenga boko la baba wace acilicosa pam'solo pa Eferemu, acilisandzika pam'solo pa Manase. ");
INSERT INTO nyu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Adauza baba wace kuti: “Lekani kucita tenepa baba. Wamkulu ni uyu. Boko lanu ladidi likhale pamsolo pa umweyu”. ");
INSERT INTO nyu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tsono baba waceyo adalamba aciti: “Ndilikudziwa, mwana wangu, ndilikudziwa. Azukulu wa Manase an'dzakhalambo wanthu wakudala, tsono mng'ono waceyu an'dzadala kuposa iye, ndipo bzizukulu bzace bzin'dzakhala mitundu mikulu ya mbumba”. ");
INSERT INTO nyu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Na tenepo adawadalisa pa ntsiku imweyo na mafala yakuti: “Aisraele an'dzacemera madzina yanu pakudalisa. An'dzalewa kuti: ‘Mulungu akudaliseni imwe ninga Efuremu na Manase.’ ” Mwa njira imweyi adaikha Eferemu pambuyo pa Manase. ");
INSERT INTO nyu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Patsogolo pace Jiraele adauza Zuze kuti: “Ulikuwona kuti ndiri pafupi kufa, tsono Mulungu an'dzakhala namwe, ndipo an'dzakubwezerani ku dziko la makolo yanu. ");
INSERT INTO nyu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nin'kupasa kuposa abale wako mbali ya kumapiri yomwe ndidapsokonyola m'manja mwa aAmori na cisenga na uta bwangu”. ");
INSERT INTO nyu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Patsogolo pace Jakobo adacemera wana wace adawauza kuti: “Konchezanani pabodzi, kuti ndin'kuuzeni bzomwe bzidzakucitikireni m'tsogolo muno. ");
INSERT INTO nyu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Konchezanani, ndipo bvani, imwe wana wa Jakobo, bverani baba wanu Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rubeni iwe ndiwe mwana wangu waciutswaka, ndiwe mphambvu yangu, ndiwe kuyamba kwa mphambvu yangu. Mwa wana wangu wentse, waposa ndiwe pa utongi na mphambvu. ");
INSERT INTO nyu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Uli ninga kumfuacukira kwa madzi ya mabimbi, tsono un'dzakhala lini pomwe wakuposa, thangwe udafambizana na makhadzi wa ine baba wako, udagona patalimba pangu, ucilulisa. ");
INSERT INTO nyu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeoni na Levi ni paubale bwawo, bzisenga bzawo ni bzombo bzakudzonga. ");
INSERT INTO nyu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ine ndileke kukhala pa kabungwe kawo, napo kucita mbali pa m'tsonkhano wawo, thangwe mwa ukali bwawo adapha wanthu, ndipo adapundula mikono aciiyesa cakusekesa. ");
INSERT INTO nyu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Butembereredwe ukali bwawo, sabwa bukhali bwa mphambvu, ndipo kukalipa kwawo kukhali kwakukhwima, Nin'dzawagawa mwa Jakobo. Nin'dzawabalalisa mu Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Juda, abale wako an'dzakulemekeza. Un'dzakhwipa m'khosi anyamadulanthaka wako, wana wa baba wako an'dzakugodamira iwe. ");
INSERT INTO nyu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda ni kamphondolo. Mwana wangu, udakhabvula, ucicoka. Ambathamula acigona pantsi ninga mphondolo, ndipo ninga mphondolo ikazi mbani angadzailamuse? ");
INSERT INTO nyu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Mpsimbo yaufumu in'dzacoka lini mwa Juda, ngakhale utongi wa bzizukulu bzako, mpaka kubwera kwa mwenekaciro caiye, ndipo madziko yentse yan'dzamubvera. ");
INSERT INTO nyu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Iye an'dzamangirira bulu wace pa muti wa uva, kabulu kace pa muti wa uva wabwino-bwino. Bzakubvala bzace ambabzifula mu vinyo, nguwo zace mu vinyo yakufuira ninga mulopa, ");
INSERT INTO nyu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Maso yace yan'dzafuira na vinyo mano yace, yan'dzacena na mkaka. ");
INSERT INTO nyu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebuloni an'dzakhala m'mphepete mwa nyandza, ndipo lin'dzakhala gombe lakufikira mabote, malire yace yan'dzafika mpaka ku Sidoni. ");
INSERT INTO nyu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakara ni bulu wamphambvu, ambagona pakati pa mathanga. ");
INSERT INTO nyu_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Atawona kukoma kwa lusvingo, na kudeka kwa dzikolo. Adakotamisa msana acinyamula mitolo yace, ndipo adabzicepesa pa basa la unyagrinya. ");
INSERT INTO nyu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dani an'dzatonga mbumba yace, ninga dzin'dza libodzi la Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani an'dzakhala nyoka pambali pa mseu, nyoka ya ululu m'mphepete mwa njira, yakuluma ku katende wa haci, ndipo ambangwesa wakupakirayo cagada. ");
INSERT INTO nyu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ho Mbuya, ndirikudikhira cipulumuso canu! ");
INSERT INTO nyu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadi an'dzamenyewa na anyankondo, tsono iye an'dzawamenya aciwathamangisa. ");
INSERT INTO nyu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asere cakudya cace cin'dzatupa, Iye an'dzapereka cakudya camambo. ");
INSERT INTO nyu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali ni nyasa wakutsudzulidwa, omwe ambalewa mafala yabwino. ");
INSERT INTO nyu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Zuze ni muti wakubala, muti wakubala pafupi na ntsantsa, mithambi yace imbayanga pa dzulu pa muro. ");
INSERT INTO nyu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Anyauta abam'boneresa, adam'thusira am'cikalipisa. ");
INSERT INTO nyu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tsono uta wace udakhala wakulimba, manja yace yambalimbikisidwa, na manja ya wamphambvu wa Jakobo, omwe ni Mbusa na Mwala wa Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Na Mulungu wa baba wako omwe an'dzakuthandiza, Wamphambvu zentse omwe akudalise. Akudalise na madaliso ya kudzulu, na madaliso ya madzi ya pantsi, ndipo an'dzakudalisa pakukupasa wana azinji na bzifuwo bzizinji. ");
INSERT INTO nyu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Madaliso ya baba wako yan'dzaposa madaliso ya azibaba wangu, mpaka padzulu pa mapiri yakuyenda-nakuyenda yakhale pamsolo pa Zuze, na pamkuma pa omwe adampambulidwa pakati pa abale wace. ");
INSERT INTO nyu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamini ni mphumphi yomwe imbagwata-gwata macibese imbakhabvula m'sodzo, ndipo maulo imbagawa bzomwe yidaphatabzo”. ");
INSERT INTO nyu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Aya ndiyo madzindza khumi na mawiri ya Ijirayeri, ndipo bzimwebzi ndibzo baba wawo Jakobo adawauza, pomwe adadalisa m'bodzi na m'bodzi mwa iwo kuteweza m'daliso womwe ukham'funikira. ");
INSERT INTO nyu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ndipo Jakobo adawauza kuti: “Ine ndiripafupi kagumana na makolo yangu, mukandipendese kuna makolo yangu m'phanga lomwe liri m'munda wa Efuroni Muhiti. ");
INSERT INTO nyu_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","M'phanga lomwe liri m'munda wa Makipela, pafupi na Mamure m'dziko la Kanani. Abrahamu akhadagula phangalo na munda kubodzi kwa Efuroni Muhiti, kuti pakhale thenje. ");
INSERT INTO nyu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Kumweko adapendesa Abrahamu na Sara mkazi wace. Izaki pabodzi na mkazi wace Rebeka, adawapendesambo komweko, ndipo Leya ndidam'pendesa kumwekombo. ");
INSERT INTO nyu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Munda na phangalo bzidagulidwa kuna Ahiti”. ");
INSERT INTO nyu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Pomwe Jakobo adamaliza kuuza wana wace, adafunya minyendo yace patalimba, acifa ndipo adakaikhidwa kuna makolo yace. ");
INSERT INTO nyu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Pamwepo Zuze adabzigwesera pa citanda ca baba wace alikulira, acimupsompsona. ");
INSERT INTO nyu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ndipo Zuze adauza anyagrinya wace omwe akhali alapi kuti citanda ca baba wace akondze na mankhwala, kuti cileke kubvunda, ndipo iwo adacita bzimwebzo. ");
INSERT INTO nyu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Basalo lidawatengera ntsiku 40, ninga bzikafunikira pa basa la mtundu umwewo. AIjipito adalira n'khawa ya Ijirayeri ntsiku 70. ");
INSERT INTO nyu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Zuze atamala kulira nkhawayo, adauza wakulemekezeka wa Falau kuti: “Ndaphata minyendo mundikomere m'tima, mukamuuze Falau kuti: ");
INSERT INTO nyu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Pomwe baba wangu akhali pafupi kufa, adandipicirisa kuti ndikamupendese muthenje lomwe adabzicerera m'dziko la Kanani. Tsapano, mundibvumize kuti ndiyende ndikaipendese baba wangu, patsogolo pace ndin'dzabwera pomwe.’ ” ");
INSERT INTO nyu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Falau adamutawira kuti: “Ndoko ukaikhe baba wako ninga momwe adakulumbirisira”. ");
INSERT INTO nyu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Zuze adayenda kukapendesa baba wace. Ndipo wakulemekezeka wentse wa Falau, akulu-akulu wa bwalo, na wanthu winango wakudala wa ku Ijipito adam'perekeza. ");
INSERT INTO nyu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Adayendambo wentse wa banja lace, abale wace, na wentse wa banja la baba wace. Ku Goseni kule kudandosala wana okha, mabira yawo, abusa na ng'ombe zawo. ");
INSERT INTO nyu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Acikunda wakupakira pa ngolo na makavalo, naiwombo adam'perekeza. Na tenepo mthithi udakhala ukulu kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Atafika pa mbuwa ya kuAtadi, kumadokero kwa Jolodani, adalira nkhawa kumweko acicita mwambo waulemu wa nkhawa, ndipo Zuze adalira baba wace ntsiku zinomwe. ");
INSERT INTO nyu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Pomwe mbumba ya kuKanani idawona kulira kumweko pa mbuwa ya kuAtadi kule, adati: “Nkhawa imweyi njikulu kwa aIjipito”. Thangwe lace mbutoyo adaicemera kuti Abele-Miziraimu, ali kumadokero kwa Jolodani. ");
INSERT INTO nyu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Wana wa Jakobo adacita ninga momwe baba wawo adawatonga. ");
INSERT INTO nyu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Adam'nyamula kuyenda ku Kanani, acikamuikha m'phanga lomwe likhali m'munda ku Makipera, kumadokero kwa Mamure. Abrahamu adagula phangalo kuna Eferoni Muhiti pabodzi na munda womwewo, kuti pakhale thenje. ");
INSERT INTO nyu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Zuze atamala kupendesa baba wace muthenje, adabwerera ku Ijipito na abale wace wale, pabodzi na wentse omwe adam'perekeza. ");
INSERT INTO nyu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Watafa baba wawo ule, abale wace wa Zuze adati: “Kodi tin'dzatani ife, Zuze akadzayamba kuwengana nafe na kufuna kubwezera bzakuipa bzentse bzomwe tidamucita bzire?” ");
INSERT INTO nyu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Na tenepo adatumiza mafala kwa Zuze kuti: “Baba wanu akanati kufa adalewa mafala yakuti ");
INSERT INTO nyu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","tidzakuuze tenepayu, ‘Ndilikukumbira Zuze kuti alekerere cakuphonya na cakuipa comwe abale wace adamucitira.’ Tsapano tirekerereni cakuphonya comwe ife, anyagrinya wa Mulungu wa baba wanu, tidacita”. Adatondokubva bzimwebzo Zuze adayamba kulira. ");
INSERT INTO nyu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ndipo abale wace adabwera adagodama pamaso pace. Adati, “Ife tili pamaso panu ninga anyagrinya wanu”. ");
INSERT INTO nyu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tsono Zuze adawauza kuti: “Lekani kugopa nee. Ine nin'kwanisa lini kubziikha mumbuto mwa Mulungu. ");
INSERT INTO nyu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Imwe mukhandikumbukira bzakuipa, tsono Mulungu akhakumbuka bzabwino, kuti bzipulumuse moyo wa wanthu wazinji. ");
INSERT INTO nyu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tsapano imwe lekani thupo. Ndin'kukhongobzani pabodzi na wana wanu kubodzi”. Na tenepo adawalimbisa m'tima aciwa tsangalaza. ");
INSERT INTO nyu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Zuze adakhala ku Ijipito pabodzi na mbumba ya baba wace. Adakhala na moyo magole 110, ");
INSERT INTO nyu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ndipo adawona azukulu wace, wana wa Eferemu. Pomwe wana wa Makiri mwana wa Manase adabadwa, Zuze adawatambira m'banja mwace. ");
INSERT INTO nyu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ndipo adauza abale wace wale kuti: “Pasala pang'ono kuti ndikusiyeni, tsono Mulungu an'dzakukhongobzani cadidi, ndipo an'dzakucosani m'dziko muno, kuyenda namwe ku dziko lomwe akhadalumbirira Abrahamu, Izaki na Jakobo”. ");
INSERT INTO nyu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Patsogolo pace Zuze adakumbira aIjirayeri kuti alumbire. Adati, “Lumbirani kuti Mulungu akakukongobzani, mudzasenza mafupa yangu kucokera nayo kuno”. ");
INSERT INTO nyu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Na tenepo Zuze adafa ali wa magole 110. Citanda cace adacikondza na mankhwala, waciciikha mubaulu ku Ijipito komweko.");
INSERT INTO nyu_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Wana wa Jakobo wakucemeredwa kuti Ijirayeri, omwe adapita muIjipito pabodzi na iye, m'bodzi na m'bodzi na banja lace, madzina yawo ni aya: ");
INSERT INTO nyu_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeni, Simiyoni, Levi, Juda, ");
INSERT INTO nyu_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakara, Zebuloni, Benjamini, ");
INSERT INTO nyu_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Nafitali, Gadi na Aseri. ");
INSERT INTO nyu_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ndipo kulewenga wentse wa dzindza la Jakobo akhakwana makumi manomwe (70). Tsono Zuze akhali kale muIjipito. ");
INSERT INTO nyu_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ndipo Zuze na abale wace wentse na m'badwe umweule wentse adafa. ");
INSERT INTO nyu_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Tsono aIjirayeri adabalana aciwanda kwene-kwene, ndipo mbogo yawo idathimizirika, acikhala wamphambvu kwene-kwene, mwakuti dziko lidadzala na iwo. ");
INSERT INTO nyu_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Patsogolo pace, mudziko la Ijipito mudaikhidwa mambo winango omwe akhadziwa lini bza Zuze. ");
INSERT INTO nyu_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Mamboyo adauza mbumba yace kuti: “Wonani! Mbumba ya Ijirayeriyi yawanda kwene-kwene, ndipo ina mphambvu kuposa ife. ");
INSERT INTO nyu_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Bwerani ticenjere nawo, kuti aleke kuthimizirika pomwe, thangwe pakadzabwera nkhondo, iwo angadzakwanise kuphatana na anyamadulanthaka wathu, acimenyana nafe, ndipo acidzathawa m'dziko muno”. ");
INSERT INTO nyu_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ndipo adawaikhira aimiriri wakuwaphatisa basa mwakuboneresa, kuti awapundize na basa lakuuma. Na tenepo aIjirayeri adamangira Falau mizinda yakukoyera bzakudya yomwe ni Pitomi na Ramesesi. ");
INSERT INTO nyu_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Tsono napo iwo akhambapitiriza kuwaboneresa tenepo, mbogo yawo ikhathimizirika ndipo akhabalalika m'dziko lentsenero. Ndipopo aIjipito adayamba kugopa aIjirayeri, ");
INSERT INTO nyu_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ndipo adadzayamba kuwaphatisa basa lakuwawa la unyagirinya. ");
INSERT INTO nyu_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Adacitisa kuti khalidwe lawo likhale lakunesa, thangwe la basa lakutsadzikidza la kumunya dongo na kuumba njedwa, napombo basa lentse la m'munda. Mabasa yentse yomwe aIjipito akhawaphatisa yakhali yakuuma. ");
INSERT INTO nyu_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mambo wa kuIjipito adauza madaya ya aHeberi, yomwe yakhacemeredwa Sifara na Puwa, kuti: ");
INSERT INTO nyu_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Pomwe mun'thandiza azimai wa aHeberi pakubereka, mumbawone penu mwanayo ni wacimuna ayai ni wacikazi. Penu ni wacimuna phani, penu ni wacikazi mulekeni na moyo”. ");
INSERT INTO nyu_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Tsono adaya wale adagopa Mulungu, ndipo alibe kubvera bzomwe mambo wa kuIjipito adawauza, iwo adaleka wana wacimuna na moyo. ");
INSERT INTO nyu_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Pamwepo mambo wa muIjipito adacemera adaya wale, aciwabvundza kuti: “Thangwe ranyi mwacita bzimwebzi? Thangwe ranyi mwasiya wana wacimuna na moyo?” ");
INSERT INTO nyu_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Adayawo adam'tawira Falau kuti: “Azimai wa aHeberi alibe kulinganira na azimai wa aIjipito. Iwo ni wamphambvu, ndipo ambabala daya akanati kufika”. ");
INSERT INTO nyu_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ndipo Mulungu adawacitira bwino adaya wale, mbumba idapitiriza kuwanda, icikhala yamphambvu kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Pakuwona kuti adayawo akhagopa Mulungu, Iye adawapasa mabanja. ");
INSERT INTO nyu_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Pamwepo, Falau adauza mbumba yace yentse kuti: “Mwana ali-yentse wacimuna omwe an'badwa mwa aHeberi mum'thuse mum'kulo wa Niro, tsono wana wacikazi wentse muwaleke na moyo”. ");
INSERT INTO nyu_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Pakhana mwamuna m'bodzi wa dzindza la Levi adalowola mkazi wa dzindza libodzi-bodziro. ");
INSERT INTO nyu_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ndipo mkaziyo adatenga pathupi, acibala mwana wacimuna. Atawona kuti mwanayo adadeka, adam'bisa miyezi mitatu. ");
INSERT INTO nyu_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Tsono atawona kuti bzin'kwanisika lini pomwe kumubisa, adatenga kacitundu ka mitete, acimata na phula. Adaikha mwanayo m'mwemo, acibisa kacitunduko pakati pa mitete, m'mphepete mwa m'kulo wa Niro. ");
INSERT INTO nyu_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mpfumakazi ya mwanayo idaima patali icimbanyang'anisisa kuti iwone comwe cingadacitika kwa mwanayo. ");
INSERT INTO nyu_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mwana wa Falau wacikazi adapolika kum'kulo wa Niro kuti akasambe. Pamwepo, anyagirinya wace wacikazi akhazunga m'mphepete mwa m'kuloyo. Na tenepo iye adawona kacitundu pakati pa mitete, ndipo adatuma nyagirinya wace kuti akakatenge. ");
INSERT INTO nyu_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Pomwe adakafungula kacitunduko, adawona mwana wacimuna akhalira. Ndipo adabva ntsisi naye, aciti: “Mwanayu ni wa aHeberi”. ");
INSERT INTO nyu_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Pamwepo, mpfumakazi ya mwanayo idafendera icibvundza mwana wa Falau kuti: “Mun'funa kuti ndiyende ndikakucemerereni mkazi waciHeberi kuti adzamamise na kufuwa mwanayu?” ");
INSERT INTO nyu_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mwana wa Falau adamutawira kuti: “Inde ndoko”. Ndipo mpfumakazi ire idayenda icikacemera mai wa mwanayo. ");
INSERT INTO nyu_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pamwepo mwana wa Falau adauza mkaziyo kuti: “Tenga mwanayu ukandirerere, nin'dzakupasa sagwati”. Mai ule adatenga mwanayo acimulera. ");
INSERT INTO nyu_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mwanayo atakula, iye adakam'pereka kwa mwana wa Falau, ndipo iye adamuyanya ninga mwana wace acim'pasa dzina lakuti Mozeji, ndipo adati: “Thangwe ndidam'cosa mumadzi”. ");
INSERT INTO nyu_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mozeji atakula, ntsiku inango adayenda kukawona abale wace waciHeberi ndipo adawona kuuma kwa basa lomwe akhaphata. Adawona pomwe muIjipito alikumenya muHeberi m'bodzi wa adzinza lace. ");
INSERT INTO nyu_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Adanyang'ana mbali zentse, ndipo atawona kuti kulibe munthu, adapha muIjipitoyo acimufucira mumcenga. ");
INSERT INTO nyu_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Mangwana yace adacoka pomwe ndipo adawona aHeberi awiri alikumenyana. Adabvundza wakuphonyayo kuti: “Thangwe ranyi ulikumenya mwandzako?” ");
INSERT INTO nyu_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Iye adatawira kuti: “Mbani wakuikha m'tsogoleri na m'tongi kwa ife? Kodi uli kufuna kundipha ninga momwe udaphera muIjipito ule?” Mozeji adabva mantha ndipo adakumbuka kuti: Cadidi bzentse bzadziwidwa. ");
INSERT INTO nyu_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pomwe Falau adabva bzimwebzi, adafuna kupha Mozeji, tsono Mozeji adathawa aciyenda kukakhala kudziko la Midiyani. Atafika adakakhala pafupi na mcera. ");
INSERT INTO nyu_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Nyantsembe wa kuMidiyani akhana wana wacikazi anomwe. Iwo adayenda kukatunga madzi kuti adzaze bzakumwesera bzifuwo bza baba wawo. ");
INSERT INTO nyu_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Tsono adabwera amakabusa anango acithotha atsikana wale. Na tenepo, Mozeji adaimirira aciwakhocherera ndipo adapasa madzi bzifuwo. ");
INSERT INTO nyu_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Pomwe atsikana wale adabwerera kuna baba wawo Rewele, iye adawabvundza kuti: “Thangwe ranyi mwabwerera kamangu lero?” ");
INSERT INTO nyu_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Iwo adatawira kuti: “MuIjipito m'bodzi watikhocherera kuna amakabusa ndipo watitungira madzi mumcera acitimwesera bzifuwo”. ");
INSERT INTO nyu_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Baba wawo adawabvundza kuti: “Kodi iye ali kuponi? Thangwe ranyi mwamusiya mwamunayo kumweko? Kamucemereni adzadye na ife”. ");
INSERT INTO nyu_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mozeji adabvuma kukakhala pamui pa mwamuna ule. Ndipo iye adapasa Mozeji mwana wace Zipora kuti akhale mkazi wace. ");
INSERT INTO nyu_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Mkaziyo adabala mwana wacimuna, omwe Mozeji adapasa dzina lakuti Jeresoni, aciti: “Thangwe ndine mulendo mudziko lacirendo”. ");
INSERT INTO nyu_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Patapita ntsiku zizinji, mambo wa kuIjipito adafa. AIjirayeri akhambalira na unyagirinya, acimbadandaula mwakukuwa. Kudandaula kwawo kudabveka kuna Mulungu. ");
INSERT INTO nyu_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Mulungu adabva kudandaula kwawo ndipo adakumbukira pangano lomwe akhadacita na Abrahamu, Izaki na Jakobo. ");
INSERT INTO nyu_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Mulungu adawona aIjirayeriwo ndipo adaneseka. ");
INSERT INTO nyu_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mozeji akhausa bzifuwo bza mibzala wace Jetero, wantsembe wa kuMidiyani. Ntsiku inango adatenga bzifuwo aciyenda nabzo kumphimpha ya kumadokero kwa cidambo, adakafika kuphiri la Mulungu lakucemeredwa Horebu. ");
INSERT INTO nyu_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Pamwepo Anju wa Mbuya adamuwonekera mwa cirambi-rambi ca moto omwe ukhagaka pakati pa citsamba. Mozeji adawona kuti citsambaco cikhagaka moto, tsono cikhapsa lini. ");
INSERT INTO nyu_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Pamwepo adati: “N'cidabwiso canyi cimweci, ndiniyenda pamwepale ndikawonesese pafupi, thangwe ranyi citsamba cirikupsa lini”? ");
INSERT INTO nyu_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mbuya atawona kuti Mozeji alikufendera pafupi kudzawonesesa, adacemera pakati pacitsamba kuti: “Mozeji, Mozeji!” Iye adatawira kuti: “Ndiri pano”. ");
INSERT INTO nyu_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mulungu adapitiriza aciti: “Leka kufendera pafupi, cosa xango kundzayo, thangwe mbuto yomwe uli njakucena”. ");
INSERT INTO nyu_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Adalewa pomwe aciti: “Ine ndine Mulungu wa makolo yako, Mulungu wa Abrahamu, Mulungu wa Izaki na Mulungu wa Jakobo”. Mozeji adabisa nkhope thangwe adagopa kunyang'anisa Mulungu. ");
INSERT INTO nyu_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Mbuya adati: “Ndawona cadidi kubonera kwa mbumba yangu mudziko la Ijipito, ndabva kudandaula thangwe la kupundizidwa. Nimbadziwa kubonera kwawo. ");
INSERT INTO nyu_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ndipopo ndabwera kuti ndiwapulumuse m'manja mwa aIjipito ndipo ndiwacose muno ayende kudziko labwino likulu, dziko lomwe lidadzala mkaka na uci: Dziko la aKenani, aHiti, aAmori, aFerezi, aHevi na aJebusi. ");
INSERT INTO nyu_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Tsono kudandaula kwa aIjirayeri kwafika kuna Ine, ndipo ndawona momwe aIjipito alikuwapundizira. ");
INSERT INTO nyu_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Tsapano, Ine nin'kutuma kuna Falau, kuti ukacose mbumba yangu aIjirayeri kuIjipito”. ");
INSERT INTO nyu_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Pamwepo Mozeji adatawira kuna Mulungu aciti: “Ndine yani ine kuti ndiyende kuna Falau, ndicikacosa aIjirayeri kuIjipito?” ");
INSERT INTO nyu_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Mulungu adamutawira kuti: “Ine nin'dzakhala nawe. Ici cin'dzakhala cizindikiro cakuti ndakutuma ndine: Ukadzacosa mbumba yangu kuIjipito, mun'dzapemba Mulungu paphiri lino”. ");
INSERT INTO nyu_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mozeji adabvundza kuti: “Pomwe nin'kafika patsogolo pa wana wa aIjirayeri ndicikawauza kuti: Mulungu wa makolo yanu wandituma kuna imwe, ndipo iwo acikandibvundza kuti: ‘Dzina lace mbani?’ Nin'kawauza ciyani?” ");
INSERT INTO nyu_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mulungu adauza Mozeji kuti: “INE NDINE OMWE NDINE. Ni bzimwedzi bzomwe udzalewe kuna aIjirayeri: INE NDINE ndiye wandituma kuna imwe”. ");
INSERT INTO nyu_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Mulungu adauza pomwe Mozeji, adati: “Ukauze aIjirayeri kuti: Mbuya, Mulungu wa makolo yanu, Mulungu wa Abrahamu, Mulungu wa Izaki na Mulungu wa Jakobo, wandituma kuna imwe. Limweri ni dzina langu la kuyenda-na-kuyenda, mwa dzina limweri nin'dzakumbukiridwa pa m'badwe na mbadwe. ");
INSERT INTO nyu_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Ndoko ukatsonkhanise akulu wa aIjirayeri ndipo ukawauze kuti: Mbuya Mulungu wa makolo yanu, Mulungu wa Abrahamu, Mulungu wa Izaki na Mulungu wa Jakobo, adawonekera kwa ine acindiuza kuti: Cadidi Ine nimbabwera kudzakuwonani ndipo nimbawona bzomwe mumbacitidwa mudziko la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ndipo ndidapicira kudzawacosa mukuboneresedwa mudziko la Ijipito ndiciwayendesa kudziko la aKanani, la aHiti, la aAmori, la aFerezi, la aHevi, na la aJebusi, kudziko lakudzala mkaka na uci. ");
INSERT INTO nyu_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Ndipo atsogoleri wa aIjirayeri an'kakubvera. Patsogolo pace ukayende nawo kwa mambo wa mudziko la Ijipito ukamuuze kuti: Mbuya, Mulungu wa aHeberi, adabwera kudzagumana nafe. Tsapano tirekeni ticite ulendo wa ntsiku zitatu kucidambo kuti tikapereke ntsembe kuna Mbuya Mulungu wathu. ");
INSERT INTO nyu_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ine nin'dziwa kuti mambo wa kuIjipito an'dzakubvumizani lini kuti muyende, akasaya kukakamizidwa na boko la mphambvu. ");
INSERT INTO nyu_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Na tenepo nin'dzafuthula boko langu ndipo nin'dzapweteka aIjipito na bzidabwiso bzangu bzomwe nin'dzacita pakati pawo. Patsogolo pace, an'dzakubvumizani kuti muyende. ");
INSERT INTO nyu_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Ine nin'dzacitisa kuti mbumba idzawonedwe bwino patsogolo pa aIjipito, mwakuti pomwe mun'dzacoka mudzasaye kucoka cimanja-manja. ");
INSERT INTO nyu_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Akazi waciIjirayeri wentse an'dzakumbira wapafupi naye na mulendo panyumba pace bzinthu bza parata na bza oro, ndipo bzakubvala bzomwe mun'dzabvadzika wana wanu wacimuna na wacikazi. Na tenepo mun'dzawapsokonyola aIjipitowo”. ");
INSERT INTO nyu_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mozeji adatawira kuti: “Tsono penu iwo an'kandikhulupirira lini, ngakhale kundibvera ndipo acidzati: ‘Mbuya alibe kukuwonekera’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Mbuya adam'bvundza kuti: “Kodi ni ciyani ciri m'manja mwakoco?” Iye adatawira kuti ni mpsimbo. ");
INSERT INTO nyu_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Mbuya adamuuza kuti: “Ithuse pantsi”. Iye adaithusa, ndipo mpsimboyo idasanduka nyoka. Mozeji adaithawa. ");
INSERT INTO nyu_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Pamwepo Mbuya adauza Mozeji aciti: “Futhula boko uiphate kum'cira”. Mozeji adafuthula boko aciiphata kum'cira ndipo iyo idasanduka mpsimbo m'manja mwace. ");
INSERT INTO nyu_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ndipo Mbuya adati: “Bzimwebzi ni bzakuti iwo akakhulupirire kuti Mulungu wa makolo yawo, Mulungu wa Abrahamu, Mulungu wa Izaki na Mulungu wa Jakobo, adakuwonekera iwe”. ");
INSERT INTO nyu_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Mbuya adamuuza pomwe kuti: “Pitisa boko pacifuwa cako”. Iye adalipitisa. Tsono pomwe adalicosa likhana mapere, yakucena ninga matalala. ");
INSERT INTO nyu_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Mbuya adapitiriza kulewa aciti: “Bwerezera kupitisa bokolo pacifuwa cako”. Mozeji adalipitisa pomwe bokolo pacifuwapo, ndipo pomwe adalicosa lidabwerera mwa kale ninga momwe thupiro likhaliri. ");
INSERT INTO nyu_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Pamwepo Mbuya adati: “Penu iwo an'kakukhulupirira lini iwe, napo kubvuma cizindikiro cakuyamba cakudabwisa, an'dzakhulupirira cizindikiro caciwirico. ");
INSERT INTO nyu_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Tsono penu an'kakhulupirira lini bzizindikiro bziwiribzo, ngakhale kukubvera mafala yako, ukatunge madzi ya mumkulo wa Niro, ukayataye pamataka yakuuma. Pomwe iwepo un'dzataya madziyo pamataka yakuuma iyo yan'dzasanduka mulopa”. ");
INSERT INTO nyu_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mozeji adauza Mbuya aciti: “Ah, Mbuya! Nimbakwanisa lini kulewa bwino, kuyambira kale ngakhale tsapano pomwe mwalewa na kapolo wanu. Lirime langu lidalemera!” ");
INSERT INTO nyu_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Mbuya adatawira aciti: “Kodi mbani adapasa mulomo munthu? Mbani ambamusandusa nkhuthu, ayai bewewe? Mbani ambamucitisa kuti awone ayai kuti akhale zimola? Kodi ndine lini Mbuya omwe nimbacita bzimwebzi? ");
INSERT INTO nyu_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Tsapano ndoko, Ine nin'dzakhala na iwe ndicimbakupfundzisa bzakuti ulewe”. ");
INSERT INTO nyu_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Tsono Mozeji adatawira kuti: “Ndaphata minyendo Mbuya, ndirikukumbira kuti mutume munthu winango”. ");
INSERT INTO nyu_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Pamwepo Mbuya adakalipira Mozeji, ndipo aciti: “Iwepo ulibe m'bale wako Aloni, muLevi? Ine nin'dziwa kuti iye ambalewa-lewa bwino. Ndipo iye alikubwera kudzagumana nawe, angakuwona an'dzakondwera mum'tima mwace. ");
INSERT INTO nyu_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Iwepo un'dzalewa-lewa naye, ucidzamuuza bzomwe alewe. Ine nin'dzakhala namwe pomwe mumbadzalewa-lewa ndipo nin'dzakuuzani bzomwe mucite. ");
INSERT INTO nyu_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Iye an'kalewa-lewa kuna wanthu pambuto yako, an'dzakhala nthena yako, iwepo un'dzalewa-lewa na iye ninga momwe Mulungu ambalewera na apolofita wace. ");
INSERT INTO nyu_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Utenge mpsimboyi m'manja mwako, nakuti na iyo un'dzacita bzizindikiro bzakudabwisa”. ");
INSERT INTO nyu_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ndipo Mozeji adabwerera kuna Jetero thebzala wace, acimuuza kuti: “Ndaphata minyendo ndirekeni ndiyende kuIjipito kuti ndikawone abale wangu penu akana moyo”. Jetero adamutawira kuti: “Ndoko na mtendere!” ");
INSERT INTO nyu_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mbuya akhadawuza kale Mozeji kuMidiyani kuti: “Bwerera kuIjipito, nakuti wentse omwe akhafuna kukupha adafa”. ");
INSERT INTO nyu_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Na tenepo, Mozeji adatenga mkazi wace na wana wace, aciwakwiza pabulu, ndipo adabwerera kuIjipito. Mozeji adatenga mpsimbo ya Mulungu m'manja mwace. ");
INSERT INTO nyu_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Mbuya adauza pomwe Mozeji kuti: “Pomwe iwepo un'bwerera kuIjipito, leka kukayebwa kucita patsogolo pa Falau bzidabwiso bzentse bzomwe ndakupasa m'manja mwako, tsono Ine nin'kamuumisa m'tima wace kuti iye aleke kudzabvumiza mbumba kucoka”. ");
INSERT INTO nyu_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ndipo ukamuuze Falau kuti: “Mbuya alewa tenepa: ‘Ijirayeri ni mwana wangu wakuyamba, ");
INSERT INTO nyu_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ndipo ndirikukuuza kuti: Muleke mwanangu ayende kuti akandipembe. Tsono iwepo ungamulambiza kuti ayende, Ine nin'dzapha mwana wako wacimuna wakuyamba!’ ” ");
INSERT INTO nyu_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Pomwe Mozeji akhali paulendo, adagumana na Mbuya panyumba ya alendo ndipo akhafuna kumupha. ");
INSERT INTO nyu_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Tsono Zipora adatenga mwala wakuthwa, acicita m'sinda wa m'gwato mwanace, ndipo khandalo adalikhuyisa m'minyendo mwa Mozeji, acirewa kuti: “Iwe ndiwe mwamuna wa mulopa kwa ine”. ");
INSERT INTO nyu_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Mkaziyo adati: “Mwamuna wa mulopa”, thangwe ra m'sinda wa m'gwato. Na tenepo Mbuya adamusiya. ");
INSERT INTO nyu_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mbuya adauzambo Aloni kuti: “Ndoko kucidambo ukagumane na Mozeji”. Iye adayenda, ndipo adakagumana naye paphiri la Mulungu, acimumpsompsona. ");
INSERT INTO nyu_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mozeji adafotokozera Aloni mafala yentse yomwe Mbuya adamuuza, na bzidabwiso bzentse bzomwe adamuuza kuti akacite. ");
INSERT INTO nyu_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Na tenepo Mozeji na Aloni adayenda acikatsonkhanisa akulu-akulu wentse wa aIjirayeri. ");
INSERT INTO nyu_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aloni adalewa mafala yentse yomwe Mbuya akhadauza Mozeji. Patsogolo pace Mozeji adacita bzidabwiso pamaso pa mbumba. ");
INSERT INTO nyu_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ndipo mbumbayo idakhulupirira. Pomwe mbumbayo idabva kuti Mbuya adabwera kuti adzathandize wana wa aIjirayeri, ndipo adawona kubonera kwawo, idagodama icimupemba. ");
INSERT INTO nyu_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Patsogolo pace, Mozeji na Aloni adayenda acikauza Falau kuti: “Mbuya, Mulungu wa Ijirayeri alikulewa tenepa: ‘Leka mbumba yangu iyende, kuti ikandicitire cikondwereso mucidambo’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Falau adatawira kuti: “Kodi Mbuya mbani kuti ine ndibvere fala lace ndipo ndireke aIjirayeri ayende? Ndinim'dziwa lini Mbuya, na pang'onopo nin'dzalekerera lini aIjirayeri kuyenda”. ");
INSERT INTO nyu_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Iwo adapitiriza kulewa aciti: “Mulungu wa aHeberi atigumana, tirekeni tiyende ulendo wa ntsiku zitatu mucidambo, kuti tikapereke ntsembe kwa Mbuya, Mulungu wathu. Tikaleka kuyenda an'dzatipha na cisi ayai na cisenga”. ");
INSERT INTO nyu_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Tsono mambo wa kuIjipito adawauza kuti: “Thangwe ranyi Mozeji na Aloni, mulikulekesa mbumba basa layene? Bwererani kumabasa yanu!” ");
INSERT INTO nyu_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Falau adalewa pomwe kuti: “Mbumbayi yawanda, ndipo imwe mulikuwalekesa mabasa yawo!” ");
INSERT INTO nyu_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ntsiku imweire, Falau adapereka Mtemo kuna akulu-akulu wa mbumba pabodzi na akapitau wawo aciti: ");
INSERT INTO nyu_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Lekani kupitiriza kupasa pomwe mbumba usva bwakuuma bwakuumbira njedwa ninga kale, iwo ndiwo an'dzamweta usvabo. ");
INSERT INTO nyu_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ndipo mudzawasunde cirewengero ca njedwa comwe kale akhaumba, palibe kubweza. Mbatofu, ndipopo alikudandaula kuti: ‘Tiyendeni tikapereke ntsembe kuna Mulungu wathu’. ");
INSERT INTO nyu_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Thimizirani basa wanthuwa kuti aliteweze, ndipo aleke kubvera mafala yakunama”. ");
INSERT INTO nyu_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Pamwepo akulu-akulu na akapitau adayenda kukauza mbumba: “Falau alewa kuti: ‘Nin'dzakupasani lini usva. ");
INSERT INTO nyu_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Imwepo ndokoni, mukamwete usva komwe mun'kabuwona, nakuti basa lanu lin'dzapunguzika lini’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Na tenepo mbumba idabalalikira mudziko lentse la Ijipito acikagwezeka bziputu pambuto ya usva. ");
INSERT INTO nyu_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Akulu-akulu wa basa akhawakakamiza aciti: “Malizani basa lanu la ntsiku lomwe mukhaphata pomwe pakhana usva”. ");
INSERT INTO nyu_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Akapitau waciIjirayeri omwe adaikhidwa na akulu-akulu wa Falau, akhambamenyedwa, acimbabvundzidwa kuti: “Thangwe ranyi mulibe kumaliza dzulo na lero cirewengero ca njedwa zomwe mukhaumba kale?” ");
INSERT INTO nyu_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Pamwepo akapitau waciIjirayeri adayenda kuna Falau, acimudandaulira kuti: “Thangwe ranyi mulikuticita tenepa anyagrinya wanu? ");
INSERT INTO nyu_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Anyagrinya wanu tirikupasidwa lini usva, ndipo ambatiuza kuti: ‘Umbani njedwa’. Ife anyagrinya wanu timbakhala ticimenyedwa, uko mbumba yanu ndiyo irikuphonya”. ");
INSERT INTO nyu_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Falau adatawira kuti: “Atofu! Imwepo ndimwe atofu! Ndipopo mumbalewa kuti: ‘Tiyendeni tikapereke ntsembe kwa Mbuya’. ");
INSERT INTO nyu_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Tsapano ndokoni mukaphate basa, tsono usva mun'pasiwa lini, na tenepo mukaumbe njedwa mucirewengero cimwecire”! ");
INSERT INTO nyu_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Akapitau waciIjirayeri, pomwe adauzidwa kuti mun'dzapunguzidwa lini cirewengero ca njedwa zomwe mumbasundidwa pantsiku, adawona kuti bzafika pakunesa. ");
INSERT INTO nyu_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ndipo adacoka patsogolo pa Falau, acikagumana Mozeji na Aloni omwe akhawadikhira. ");
INSERT INTO nyu_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ndipo adawauza kuti: “Mbuya awone ndipo akutongeni! Imwepo mwatiwengesa pamaso pa Falau na wakulemekezeka wace, aciwapasa cisenga m'manja kuti atiphe”. ");
INSERT INTO nyu_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mozeji adabwerera kuna Mbuya aciti: “Mbuya, kodi waibonereseranyi mbumbayi? Thangwe ranyi wandituma? ");
INSERT INTO nyu_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Nakuti kuyambira pomwe ndidawonekera kuna Falau, kuti ndikalewe-lewe mudzina lako, iye ambaboneresa mbumbayi, ndipo iwe ulibe kuipulumusa na pang'onopo mbumba yako!” ");
INSERT INTO nyu_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Pamwepo Mbuya adauza Mozeji kuti: “Tsapano uniwona bzomwe nin'dzamucita Falau. Thangwe la boko langu lamphambvu, iye an'dzawaleka aciyenda. Ndipo thangwe la boko langu lamphambvu, iye an'dzawathotha m'dziko lace”. ");
INSERT INTO nyu_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mulungu adalewa pomwe na Mozeji kuti: “Ine ndine Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ndidawonekera kuna Abrahamu, Izaki na Jakobo ninga Mulungu Wamphambvu-zentse. Tsono ndiribe kuwadziwisa iwo dzina langu lakuti Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ndipo ndidacita nawo cipangano cakuwapasa dziko la Kenani, dziko lomwe adakhala ninga alendo. ");
INSERT INTO nyu_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Tsapano ndabva kudandaula kwa aIjirayeri omwe ali kucitidwa anyagrinya na aIjipito, ndipo ndakumbukira cipangano cangu. ");
INSERT INTO nyu_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Na tenepo uza aIjirayeri kuti: Ine ndine Mbuya, nin'dzakucosani mubasa lakuuma lomwe aIjipito alikukuphatisani, nin'dzakupulumusani muunyagrinya bomwe mulikucitidwa na iwo, ndipo nin'dzakulombolani na boko lamphambvu ndicidzatonga na kupasa nyathwa ikulu. ");
INSERT INTO nyu_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ine nin'dzakusandusani mbumba yangu, ndipo nin'dzakhala Mulungu wanu. Pamwepo mun'dzadziwa kuti Ine ndine Mbuya Mulungu wanu, omwe an'kupulumusani mubasa lakuuma lomwe aIjipito ali kukuphatisani. ");
INSERT INTO nyu_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ndipo nin'dzakuyendesani mudziko lomwe ndidalumbira mwa kuimisa boko kuti nin'dzapasa Abrahamu, Izaki na Jakobo. Ine nidzakupasani dzikolo kuti likhale lanu. Ine ndine Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ndipo Mozeji adabzirewa kuna aIjirayeri, tsono alibe kumutetekera Mozejiyo thangwe la kuwawidwa m'tima na unyagirinya bwakuuma. ");
INSERT INTO nyu_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Pamwepo Mbuya adauza Mozeji kuti: ");
INSERT INTO nyu_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Ndoko ukamuuze Falau mambo wa muIjipito kuti aleke aIjirayeri acoke mudziko lace”. ");
INSERT INTO nyu_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Tsono Mozeji adalewa patsogolo pa Mbuya aciti: “Wana wa aIjirayeriwo ambanditetekera lini tsono ndiye tani kuna Falau angakanditetekere? Napombo kulewalewa bwino nimbakwanisa lini”! ");
INSERT INTO nyu_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Tsono Mbuya adauza Mozeji na Aloni kuti alewe kuna aIjirayeri na kuna Falau, mambo wa Ijipito, kuti iwo adatumidwa kucosa aIjirayeri mudziko la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Atsogoleri wa mabanja ya makolo ya aIjirayeri mbawa: Rubeni, mwana wakuyamba wa Ijirayeri, wana wace akhali awa: Inoki, Palu, Ezironi na Kalimi. Amwewa ndiwo wa dzindza la Rubeni. ");
INSERT INTO nyu_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Wana wa Simiyoni mbawa: Jemuyeli, Jamini, Owadi, Jakimi, Zowari na Sawulo, mwana wa mkazi waciKenani. Amwewa ndiwo wa dzindza la Simiyoni. ");
INSERT INTO nyu_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Madzina ya wana wa Levi, kuteweza ndandanda wakubadwa ngaya: Geresoni, Kohati na Merari. Leviyo adakhala na moyo magole dzana libodzi na makumi matatu na manomwe (137). ");
INSERT INTO nyu_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Wana wa Geresoni mbawa: Libini na Simeyi na madzindza yawo. ");
INSERT INTO nyu_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Wana wa Kohati mbawa: Amuramu, Izali, Heboloni na Uzieri. Kohati adakhala na moyo magole dzana libodzi na makumi matatu na matatu (133). ");
INSERT INTO nyu_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Wana wa Merari mbawa: Mali na Musi. Yamweya ndiyo madzindza ya Levi, kuteweza ndandanda wa kubadwa kwawo. ");
INSERT INTO nyu_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amuramu adalowola mpfumakazi ya baba wace dzina lace Jokobede. Jokobedeyo adabala Aloni na Mozeji. Amuramu adakhala na moyo magole dzana libodzi na makumi matatu na manomwe (137). ");
INSERT INTO nyu_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Wana wa Izari mbawa: Kora, Nefeji na Zikiri. ");
INSERT INTO nyu_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Wana wa Uzieli mbawa: Misaere, Elizafani na Sitiri. ");
INSERT INTO nyu_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aloni adalowola Elizeba, mwana wa Aminadabe ndipo mpfumakazi ya Nasoni. Ndipo Elizeba adabala Nadabu, Abiwu, Eliyazara na Itamara. ");
INSERT INTO nyu_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Wana wa Kora mbawa: Asiri, Elikana na Abiyasafu. Yamweya ndiyo madzindza ya Kora. ");
INSERT INTO nyu_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eliyazara, mwana wa Aloni, adalowola m'bodzi wa wana wa Putiele, omwe adamubalira Finiyasi. Amwewa ndiwo akhali atsogoleri wa mabanja ya Levi malingana na madzindza yawo. ");
INSERT INTO nyu_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aloni na Mozeji amwewa ndiwo omwe Mbuya adawauza kuti: “Cosani aIjirayeri mudziko la Ijipito m'magulu-magulu”. ");
INSERT INTO nyu_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Amwewa Mozeji na Aloni ndiwo adauza Falau mambo wa kuIjipito kuti acose aIjirayeri muIjipito. ");
INSERT INTO nyu_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ndipo, pomwe Mbuya adalewa na Mozeji mudziko la Ijipito, ");
INSERT INTO nyu_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","adati: “Ine ndine Mbuya, uza Falau mambo wa muIjipito bzentse bzomwe nin'kuuza”. ");
INSERT INTO nyu_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Tsono Mozeji adatawira patsogolo pa Mbuya aciti: “Ine nimbakwanisa lini kulewa-lewa bwino, kodi Falau an'kandibvera tani?” ");
INSERT INTO nyu_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Mbuya adatawira Mozeji kuti: “Ndakupasa utongi bwangu patsogolo pa Falau, ndipo m'bale wako Aloni an'kalewa-lewa. ");
INSERT INTO nyu_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Iwe ukalewe bzentse bzomwe ndakuuza, Aloni m'bale wako an'kalewa kuna Falau, kuti acose aIjirayeri mudziko mwace. ");
INSERT INTO nyu_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Tsono Ine nin'dzaumisa m'tima wa Falau. Napo ndicidzacita bzizindikiro bzizinji na bzidabwiso mudziko la Ijipito, ");
INSERT INTO nyu_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Falau an'kakubverani lini. Tsono nin'dzaikha boko langu mudziko la Ijipito, ndicidzatonga na kupasa nyathwa ikulu, nin'dzacosa mithithi yangu, mbumba yangu, aIjirayeri, mudziko la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ndipo aIjipito an'dzadziwa kuti Ine ndine Mbuya, ndikadzaphatisa basa boko langu lamphambvu kwa Ijipito ndicidzacosa aIjirayeri kumweko”. ");
INSERT INTO nyu_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mozeji na Aloni adacita bzomwe Mbuya adawauza. ");
INSERT INTO nyu_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ndipo Mozeji akhana magole makumi masere (80), Aloni akhana magole makumi masere na matatu (83), pomwe adakalewa na Falau. ");
INSERT INTO nyu_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Mbuya adalewa kuna Mozeji na Aloni aciti: ");
INSERT INTO nyu_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Falau akakalewa kuti citani cidabwiso, ukauze Aloni kuti atenge mpsimbo yace aithuse pantsi patsogolo pa Falau ndipo iyo in'dzasanduka nyoka”. ");
INSERT INTO nyu_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Na tenepo Mozeji na Aloni adayenda kwa Falau, ndipo adacita ninga momwe Mbuya adawauzira. Aloni adathusa mpsimbo patsogolo pa Falau na wakulemekezeka wace ndipo iyo idasanduka nyoka. ");
INSERT INTO nyu_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Tsono Falau adacemeresa adziwi na mpfiti, ndipo wamatsengawo adacita bzibodzi-bodzi kudzera mwa udziwi bwawo bwakubisika. ");
INSERT INTO nyu_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Nakuti m'bodzi na m'bodzi adathusa mpsimbo yace pantsi, ndipo zidasanduka nyoka. Tsono mpsimbo ya Aloni idakhudyula mpsimbo zawo. ");
INSERT INTO nyu_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Tsono m'tima wa Falau udaumisidwa, ndipo iye alibe kubvera Mozeji na Aloni, ninga momwe Mbuya akhadalewa. ");
INSERT INTO nyu_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ndipo Mbuya adauza Mozeji kuti: “Falau ana m'tima wa makani. Iye alikulambiza mbumba kucoka. ");
INSERT INTO nyu_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ndoko kwa Falau macibese, pomwe iye an'dzakhala alikuyenda kumkulo. Ukam'dikhire m'mphepete mwa mkulo kuti ukagumane naye, ndipo udzatenge mpsimbo m'manja mwako yomwe idasanduka nyoka. ");
INSERT INTO nyu_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ndipo ukamuuze kuti Mbuya, Mulungu wa aHeberi, wandituma kuna iwe kudzadziwisa bzomwe walewa kuti ndikuuze: ‘Bvumiza mbumba yangu iyende kuti ikandipembe kucidambo. Tsono mpaka pano umbandibvera lini’. ");
INSERT INTO nyu_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Mbuya alikulewa tenepa: ‘Iwepo un'dzadziwa kuti Ine ndine Mbuya na ibzi: Na mpsimbo yomwe ndinayo manjayi nin'dzamenya madzi ya mumkuloya, ndipo yan'dzasanduka mulopa. ");
INSERT INTO nyu_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ntsomba zomwe ziri mumkulomo zin'dzafa, mkulo un'dzakhala ulikununkha kuipa, ndipo aIjipito an'dzakwanisa lini kumwa madzi yace’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ndipo Mbuya adauza Mozeji kuti: “Uza Aloni atenge mpsimbo yace ndipo afuthule boko pamadzi ya muIjipito, ya mumikulo, ya mutumikulo, ya m'thawale na mumbuto zentse zomwe zidakoyedwa madzi, kuti madziyo yasanduke mulopa. Mun'dzakhala mulopa mudziko lentse la Ijipito, napombo bzakukoyera madzi bza miti na bza minyala”. ");
INSERT INTO nyu_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mozeji na Aloni adacita ninga momwe Mbuya adawauzira. Aloni adadzusa mpsimbo acimenya madzi ya mumkulo patsogolo pa Falau na wakulemekezeka wace. Ndipo madzi yentse ya mumkulo yadasanduka mulopa. ");
INSERT INTO nyu_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ntsomba za mumkulomo zidafa, mkulo udayamba kununkha kuipa, mwakuti aIjipito akhakwanisa lini kumwa madzi ya mumkulomo. Dziko lentse la Ijipito lidadzala na mulopa. ");
INSERT INTO nyu_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ndipo wamatsenga wa muIjipito adacita bzibodzi-bodzibzo kudzera mwa udziwi bwawo bwakubisika. M'tima wa Falau udaumisidwa ndipo iye alibe kubvera Mozeji na Aloni ninga momwe Mbuya akhadalewera. ");
INSERT INTO nyu_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Napo na bzimwebzo Falau alibe kukhala na thupo, adacungunuka aciyenda kunyumba kwace. ");
INSERT INTO nyu_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","AIjipito wentse adafukula micera m'mphepete mwa mkulo kuti awone madzi yakumwa, thangwe madzi ya mumkulo yakhamweka lini. ");
INSERT INTO nyu_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Kucokera pomwe Mbuya adaipisa madzi ya mkulo wa Nilo, padapita ntsiku zinomwe. ");
INSERT INTO nyu_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ndipo Mbuya adauza Mozeji kuti: “Ndoko kwa Falau ukamuuze kuti Mbuya alikulewa tenepayu: ‘Bvumiza mbumba yangu iyende ikandipembe. ");
INSERT INTO nyu_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Penu iwepo uniwabvumiza lini kuti ayende, nin'dzatumiza cisi ca acule mudziko lako lentse. ");
INSERT INTO nyu_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mkulo un'dzadzala acule. Iwo an'dzakwira acidzapita m'nyumba mwako, kucipinda cako, mpaka patalimba wako. An'dzakhalambo m'nyumba za wakulemekezeka wako na mwa mbumba yako, m'kati mwa mbuto zawo zentse zakuphikira pau na mubzombo bzawo bzakumunyira. ");
INSERT INTO nyu_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ndipo aculewo an'dzakwira iwepo, wakulemekezeka wako wentse na mbumba yako’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Patsogolo pace Mbuya adauza Mozeji kuti: “Uza Aloni afuthule boko na mpsimbo padzaulu pa mikulo, m'tumikulo na m'mathawale, ndipo acitise kuti m'madzimo mucoke acule akwire mudziko la Ijipito”. ");
INSERT INTO nyu_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aloni adapfuthula boko kuna madzi ya muIjipito, ndipo acule adakwira acidzala m'dziko la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Tsono wamatsenga adacitambo bzibodzi-bodzibzo mwa udziwi bwawo bwakubisika, adacitisambo kuti acule akwire mudziko la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Falau adacemera Mozeji na Aloni aciwauza kuti: “Pembani kwa Mbuya kuti Iye acose aculewa kwa ine na kwa mbumba yangu, ndipo nin'dzasiya mbumba iciyenda kukapereka ntsembe kuna Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mozeji adalewa kuna Falau kuti: “Bziri kuna iwe kundiuza kuti ni lini pomwe ningadzakupemberere, wakulemekezeka wako na mbumba yako, kuti acule acoke kuna iwe na m'nyumba zako asale mumkulo mokha basi”. ");
INSERT INTO nyu_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Falau adatawira kuti: “Mangwana”. Mozeji adati: “Bzin'dzacitika ninga momwe walewera, kuti udzadziwe kuti palibe winango wakulingana na Mbuya Mulungu wathu. ");
INSERT INTO nyu_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Acule an'dzacoka kuna iwe, m'nyumba zako, kwa wakulemekezeka wako na mbumba yako ndipo an'dzasala mumkulo mokha basi”. ");
INSERT INTO nyu_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Pomwe Mozeji na Aloni adacoka patsogolo pa Falau, Mozeji adakadandaula kwa Mbuya thangwe la acule omwe adatumiza kuna Falau. ");
INSERT INTO nyu_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mbuya adacita ninga momwe Mozeji adadandaulira. Acule adafa m'manyumba, mucintalo na m'minda. ");
INSERT INTO nyu_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","AIjipito adagwezeka aculewo midwi-midwi, na tenepo dzikolo lidanunkha kuipa. ");
INSERT INTO nyu_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Tsono pomwe Falau adawona kuti bzinthu bzakhala bwino, adaumisa m'tima, ndipo alibe kubvera pomwe Mozeji na Aloni ninga momwe Mbuya akhadalewera. ");
INSERT INTO nyu_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ndipo Mbuya adauza Mozeji kuti: “Uza Aloni adzuse mpsimbo yace amenye pfumbi la pantsi kuti lisanduke ntsawawa mudziko lentse la Ijipito”. ");
INSERT INTO nyu_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Iwo adacita bzimwebzo. Aloni adafuthula boko na mpsimbo acimenya pfumbi la pantsi, ndipo padawoneka ntsawawa kuna wanthu na kuna bzinyama. Pfumbi lentse la dziko lentse la Ijipito lidasanduka ntsawawa. ");
INSERT INTO nyu_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Tsono pomwe wamatsenga adayezera kucita kuti pawoneke ntsawawa kudzera mwa udziwi bwawo bwakubisika, alibe kukwanisa, ndipo ntsawawazo zidabalalikira kuna wanthu na kuna bzinyama. ");
INSERT INTO nyu_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Na tenepo wamatsenga adakauza Falau kuti: “Cimweci ni cala ca Mulungu”. Tsono Falau adaumisa m'tima basi, ndipo alibe kuwabvera ninga momwe Mbuya akhadalewera. ");
INSERT INTO nyu_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ndipo Mbuya adauza Mozeji kuti: “Mangwana macibese-bese ulamuke ukawonane na Falau, pomwe iye an'dzakhala alikuyenda kumkulo ndipo ukamuuze kuti Mbuya alewa tenepa: ‘Leka mbumba yangu iyende kuti ikandipembe. ");
INSERT INTO nyu_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ukaleka kubvumiza mbumba yangu kuyenda, nin'dzatumiza bzidembedza bza ncence kuna iwe, kuna wakulemekezeka wako, kuna mbumba yako na m'nyumba zako. Nyumba za aIjipito na pantsi pomwe mun'ponda pan'dzadzala bzidembedza bza ncence’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“Tsono pantsiku imweyo nin'dzacita mwakusiyanisa dziko la Goseni, momwe mumbakhala mbumba yangu. Mun'dzawoneka lini cidembedza ca ncence m'mwemo na cibodzico, kuti iwepo udziwe kuti Ine Mbuya ndiri padziko. ");
INSERT INTO nyu_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nin'dzacita kuti pakhale kusiyana pakati pa mbumba yangu na yako. Cizindikiro cakudabwisa cimweci cin'dzacitika mangwana”. ");
INSERT INTO nyu_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Na tenepo Mbuya adacita bzimwebzo. Bzidembedza bzikulu bza ncence bzidabwera bzicipita mkati mwa nyumba ya Falau, na m'nyumba mwa wakulemekezeka wace na mudziko lentse la Ijipito, ndipo dziko lidadzongeka na ncencezo. ");
INSERT INTO nyu_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pamwepo Falau adacemeresa Mozeji na Aloni aciti: “Ndokoni mukapereke ntsembe kwa Mulungu wanu, tsono lekani kucoka mudziko muno”. ");
INSERT INTO nyu_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mozeji adatawira kuti: “Bzingakhale lini bwino kuti ticite tenepo, ntsembe zomwe ife timbapereka kuna Mbuya, Mulungu wathu ni zakunyantsa kwa aIjipito. Tingakapereka ntsembe zomwe ziniwoneka zakunyantsa kwa iwo, bzimwebzi bzingacitise lini kuti atibome na minyala? ");
INSERT INTO nyu_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tin'funika kuyenda ulendo wa ntsiku zitatu mucidambo, kuti tikapereke ntsembe kuna Mbuya Mulungu wathu ninga momwe iye alikutiuzira”. ");
INSERT INTO nyu_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Falau adalewa kuti: “Nin'dzakubvumizani kuti muyende mukapereke ntsembe kwa Mbuya Mulungu wanu kucidambo, tsono lekani kuyenda patali kwene-kwene, ndipo mundipembererembo”. ");
INSERT INTO nyu_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mozeji adatawira kuti: “Ndikatondokucoka pano, nin'kapemba kwa Mbuya, ndipo mangwana bzidembedza bza ncence bzin'dzacoka kwa Falau, kwa wakulemekezeka wako na kwa mbumba yako. Tsono Falau leka kundinyengeza pomwe, kudzasaya kubvumiza mbumba kuyenda kukapereka ntsembe kuna Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Pamwepo Mozeji adacoka patsogolo pa Falau, acikapemba kwa Mbuya, ");
INSERT INTO nyu_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ndipo Mbuya adatawira kukumbira kwace. Ncence zidacoka kwa Falau, kwa wakulemekezeka wace na kwa mbumba, palibe kusala ncence na ibodziyo. ");
INSERT INTO nyu_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Tsono ulendo buno Falau waumisa pomwe m'tima, ndipo alibe kubvumiza mbumba kuyenda. ");
INSERT INTO nyu_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ndipo Mbuya adauza Mozeji kuti: “Ndoko kwa Falau ukamuuze kuti Mbuya, Mulungu wa aHeberi alikulewa tenepa: Leka mbumba yangu iyende kukandipemba. ");
INSERT INTO nyu_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Penu iwepo uniramba pomwe kuwaleka aciyende, ucipitiriza kuwaletsa, ");
INSERT INTO nyu_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","dziwa kuti boko la Mbuya lin'dzabweresa cisi cakugopsa kuna bzifuwo bza Falau bzomwe bziri m'minda: Makavalo, mabulu, ngamira, ng'ombe na mabira. ");
INSERT INTO nyu_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Tsono Mbuya an'dzacita kuti pakhale kusiyana pakati pa bzifuwo bza aIjirayeri na bza aIjipito. Palibe cifuwo ca aIjirayeri na cibodzico cin'dzafa”. ");
INSERT INTO nyu_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mbuya adaikha nthawe aciti: “Mangwana Mbuya an'dzacita bzomwe adapicira mudziko lino”. ");
INSERT INTO nyu_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Mangwana yace Mbuya adacita bzimwebzo. Bzifuwo bza aIjipito bzentse bzidafa, tsono palibe cifuwo ca aIjirayeri na cibodzico cidafa. ");
INSERT INTO nyu_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pamwepo Falau adatuma kuti akawone, ndipo adabva kuti palibe cifuwo na cibodzico ca aIjirayeri cidafa. Napo bzikhali terepoyo m'tima wa Falau udapitiriza kuuma, ndipo alibe kubvumiza mbumba kuyenda. ");
INSERT INTO nyu_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ndipo Mbuya adauza Mozeji na Aloni kuti: “Tapani dotha la pakuphikira pau na manja, ndipo Mozeji akaliwaze kudzulu patsogolo pa Falau. ");
INSERT INTO nyu_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Dothalo lin'dzasanduka pfumbi lakunyodoka padziko lentse la Ijipito, ndipo kuna wanthu na kuna bzinyama kun'dzawoneka bzironda bza njinda mudziko lentse la Ijipito”. ");
INSERT INTO nyu_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Iwo adatenga dotha la pakuphikira pau acikaima kutsogolo kwa Falau. Mozeji adawaza dothalo kudzulu ndipo bzironda bza njinda bzidayamba kuwoneka kuna wanthu na kuna bzinyama. ");
INSERT INTO nyu_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Napo wamatsenga alibe kukwanisa kuima kutsogolo kwa Mozeji, thangwe adadzala bzironda ninga aIjipito anango wentse. ");
INSERT INTO nyu_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Tsono Mbuya adaumisa m'tima wa Falau, ndipo iye adalamba kubvera Mozeji na Aloni, ninga momwe Mbuya akhadalewera kuna Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ndipo Mbuya adauza Mozeji kuti: “Mangwana umuke macibese-bese, ukawonane na Falau, ukamuuze kuti: Mbuya, Mulungu wa aHeberi alewa tenepa: Leka mbumba yangu iyende kuti ikandipembe. ");
INSERT INTO nyu_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Nakuti, ulendo buno nin'dzatumiza bzisi bzangu bzentse kuna iwe, kwa wakulemekezeka wako na kuna mbumba yako, kuti iwepo udziwe kuti padziko lentse la pantsi palibe winango ninga Ine. ");
INSERT INTO nyu_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Thangwe Ine ningadapfuthula kale boko, ndicipweteka iwe na mbumba yako na cisi, comwe cingadamalisa moyo wako padziko. ");
INSERT INTO nyu_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Tsono Ine ndakuleka na moyo na cakulinga ici: Kukuwonesa mphambvu zangu, ndipo kuti dzina langu liralikidwe padziko lentse la pantsi. ");
INSERT INTO nyu_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Koma iwe ulikupitiriza kubzikuza ucimbafambira m'mbuyo mbumba yangu ucimbailetsa kuti iyende. ");
INSERT INTO nyu_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Wona, mangwana nthawe imweino nin'dzatumiza mbvula yakugosva ya matalala, yomwe ikanati kugwa kale mudziko la Ijipito kuyambira ntsiku yomwe lidakhazikisidwa mpaka lero. ");
INSERT INTO nyu_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Tsapano uza kuti akhongobze bzifuwo bzako na bzentse bzomwe unabzo kuminda. Wanthu wentse na bzinyama bzomwe bzin'dzakhala bziri kuminda, bzomwe bzin'dzakhala bziribe kukhongobzedwa, bzin'dzamenyedwa na matalala bzicifa”. ");
INSERT INTO nyu_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wakulemekezeka wa Falau omwe akhagopa fala la Mbuya adakulumiza kukhongobza anyagrinya wawo na bzifuwo bzawo pambuto ya m'khomeko. ");
INSERT INTO nyu_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Tsono omwe akhalibe thupo na fala la Mbuya adaleka anyagrinya na bzifuwo bzawo kuminda. ");
INSERT INTO nyu_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Pamwepo Mbuya adauza Mozeji kuti: “Lamusa boko kudzulu, ndipo matalala yan'dzagwa mudziko lentse la Ijipito, kwa wanthu, kwa bzinyama na kwa bzakumera bzentse bza mudziko la Ijipito”. ");
INSERT INTO nyu_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Pomwe Mozeji adalamusa mpsimbo yace kudzulu, Mbuya adabweresa kugunda na matalala, ndipo mpheni zikhagwa padziko. Tenepoyo Mbuya adabvumbisa matalala mudziko la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Matalala yadagwa ndipo mpheni zikhamenya mbali zentse. Pakhanati kuwoneka kale mbvula ya matalala ninga imweire mudziko lentse la Ijipito, kuyambira pomwe dzikolo lidakhazikisidwa dziko. ");
INSERT INTO nyu_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","M'dziko lentse la Ijipito matalala yadadzonga bzentse bzomwe bzikhali m'minda, kuyambira wanthu na bzinyama. Yadadzongambo bzentse bzakumera ndipo yadachola miti yentse. ");
INSERT INTO nyu_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Dziko la Goseni lokha, lomwe likhakhala aIjirayeri, liribe kugwa matalala. ");
INSERT INTO nyu_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pamwepo Falau adacemera Mozeji na Aloni adawauza kuti: “Ulendo buno ine ndaphonyera Mulungu. Mbuya ngwakulungama. Ine na mbumba yangu ndife wakuphonyeka. ");
INSERT INTO nyu_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pembani kuna Mbuya! Kugunda kwa Mulungu na matalala bzanyanya. Ine nin'kulekani kuti muyende, bzin'funika lini kuti mukhale pomwe kuno”. ");
INSERT INTO nyu_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mozeji adatawira kuti: “Ndikandokucoka mumzinda, nin'dzadzusa manja mwakupemba Mbuya, kugunda kun'dzalekeza, ndipo matalala yan'dzagwa lini pomwe, kuti udziwe kuti dziko lentse la pantsi ni la Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Tsono ine ndirikudziwa kuti iwe na wakulemekezeka wako, mukanati kugopa Mbuya Mulungu!” ");
INSERT INTO nyu_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Thonje na sevada bzidadzongedwa, pakuti sevada ikhadatumbuka kale, ndipo thonje likhana maluwa. ");
INSERT INTO nyu_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Tsono tirigu na senteyo bziribe kudzongedwa, thangwe bzikhanati kutumbuka.) ");
INSERT INTO nyu_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Na tenepo Mozeji adasiya Falau acicoka mumzinda, ndipo adadzusa manja acipemba Mbuya. Kugunda na matalala bzidalekeza, ndipo mbvula idakasa. ");
INSERT INTO nyu_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pomwe Falau adawona kuti mbvula, matalala na kugunda bzikhadalekeza, adaphonyera pomwe Mulungu aciumisa mumtima wace, iye na wakulemekezeka wace. ");
INSERT INTO nyu_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","M'tima wa Falau udapitiriza kuuma, ndipo iye alibe kuleka aIjirayeri acoke ninga momwe Mbuya akhadalewera kudzera mwa Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ndipo Mbuya adauza Mozeji kuti: “Ndoko kuna Falau, nakuti ndaumisa m'tima wace na wa wakulemekezeka wace, na cakulinga cakuti ndicite bzizindikiro bzangubzi pakati pawo, ");
INSERT INTO nyu_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","kuti iwepo ukwanise kudzafotokozere wana wako na azukulu wako momwe ndidanyazisira aIjipito na momwe ndidacitira bzidabwiso pakati pawo. Na tenepo imwepo mun'dzadziwa kuti Ine ndine Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mozeji na Aloni adayenda kuna Falau acikamuuza kuti: “Mbuya, Mulungu wa aHeberi, ali kulewa tenepa: ‘Mpaka lini iwepo un'dzalamba kubzicepesa patsogolo pangu. Bvumiza mbumba yangu iyende kuti ikandipembe. ");
INSERT INTO nyu_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Penu iwepo un'funa lini kuwaleka kuti ayende, mangwana nin'dzabweresa dzomba mudziko lako. ");
INSERT INTO nyu_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Iro lin'dzampsinkha pantsi pentse, mpaka mataka nee kuwoneka. Lin'dzadya bzing'ono-ng'ono bzomwe bzidasalabzo, pa mbvula ya matalala, na miti yentse yomwe irikuphukira m'minda. ");
INSERT INTO nyu_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Lin'dzadzala munyumba zako, na m'munyumba za wakulemekezeka wako wentse na za aIjipito wentse, bzomwe azibaba wako na makolo yawo alibe kubziwona kuyambira ntsiku yomwe adakhala m'dzikoli mpaka ntsiku ya lero’ ”. Patsogolo pace Mozeji adazungunuka acicoka patsogolo pa Falau. ");
INSERT INTO nyu_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Wakulemekezeka wa Falau adam'bvundza kuti: “Kodi munthu umweyu an'khala ninga cakuteya kwa ife mpaka lini? Abvumizeni wanthuwo kuti ayende akapembe Mbuya Mulungu wawo. Kodi mulikuwona lini kuti dziko la Ijipito lapfudzika?” ");
INSERT INTO nyu_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Pamwepo Mozeji na Aloni adabwezedwa pomwe patsogolo pa Falau, ndipo iye adawauza kuti: “Ndokoni, mukapembe Mbuya Mulungu wanu. Tsono ndiuzeni mbani aniyenda?” ");
INSERT INTO nyu_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mozeji adatawira kuti: “Bzin'funika kuti tiyende tentse: Maswaka na nkhalamba, wana wathu wacimuna na wacikazi, mabira yathu na ng'ombe zathu thangwe tin'kacita phwandu la Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Falau adawauza kuti: “Ndikabvuma kuti muyende na akazi wanu na wana, Mbuya akhale namwe! N'cadidi imwepo muna cakulinga cakuipa. ");
INSERT INTO nyu_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Bzin'citika lini na pang'onopo! Amuna wokha ndiwo angayende, kukapemba Mbuya, ninga momwe imwe mumbakumbirira”. Ndipo Mozeji na Aloni adathothedwa patsogolo pa Falau. ");
INSERT INTO nyu_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Pamwepo Mbuya adauza Mozeji kuti: “Pfuthula boko kuna Ijipito kuti mabombo yabwere padziko ndipo yadzonge bzakumera bzentse na bzentse bzomwe bzidasiyidwa na mbvula ya matalala”. ");
INSERT INTO nyu_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Pamwepo Mozeji adadzusa mpsimbo yace mudziko la Ijipito, ndipo Mbuya adabweresa mudzikomo condzi ca kumabva-dzuwa ntsiku ire yentse na usiku bwace. Macibese yace, condzi cikhadabweresa kale mabombo. ");
INSERT INTO nyu_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Mabomboyo yadapita mudziko lentse la Ijipito, ndipo yadabwera mwa mbogo ikulu, yacikhala mumbuto zentse za dzikolo. Kukhanati kuwoneka kale mabombo ninga yamweyo, ndipo cipo yan'dzawoneka lini pomwe yanango tenepayu. ");
INSERT INTO nyu_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Iyo yadampsinkha pantsi pentse, mwakuti pantsipo padacita mdima. Yadadya bzentse bzomwe matalala yakhadasiya: Bzakumera bzentse na bzisapo bzentse bza miti. Ndipo palibe kusala bzakuphukira m'miti napo bzakumera m'minda, mudziko lentse la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pamwepo Falau mwakamkulumize adacemeresa Mozeji na Aloni, aciwauza kuti: “Ndaphonyera Mbuya Mulungu wanu, na kuna imwepombo! ");
INSERT INTO nyu_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Tsapano ndirekerereni pomwe ulendo buno kuphonya kwangu, ndipo pembani kuna Mbuya Mulungu wanu, kuti acose cisi cakuphaci ciyende kutali na ine”. ");
INSERT INTO nyu_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mozeji adacoka patsogolo pa Falau, acikapemba kuna Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ndipo Mbuya adabweresa condzi camphambvu ca kumadokero, ico cidanyamula dzomba cicikalitaya muNyandza ifuira. Palibe dzomba na libodziro lidasala mudziko lentse la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Tsono Mbuya adaumisa m'tima wa Falau, ndipo iye alibe kuwabvumiza aIjirayeri kuti ayende. ");
INSERT INTO nyu_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ndipo Mbuya adauza Mozeji kuti: “Dzusa boko lako kudzulu, padziko la Ijipito pan'dzakhala na mdima, mdima wakuti bwerani mudzawone”. ");
INSERT INTO nyu_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mozeji adadzusa boko lace kudzulu, ndipo padziko lentse la Ijipito padakhala na mdima wakugopsa mwa ntsiku zitatu. ");
INSERT INTO nyu_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Akhakwanisa lini kuwonana wina na mwandzace, napo kucoka pambuto yace m'kati mwa ntsiku zitatu. Tsono aIjirayeri wentse akhana ceza mwakukhala mwawo. ");
INSERT INTO nyu_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pamwepo Falau adacemera Mozeji acimuuza kuti: “Ndokoni mukapembe Mbuya. Siyani mabira na ng'ombe basi, akazi na wana ayende”. ");
INSERT INTO nyu_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Tsono Mozeji adatawira aciti: “Iwepo letu utipase bzinyama bzakukapereka ntsembe zathu na ntsembe zakutentha zomwe tin'kapereka kuna Mbuya Mulungu wathu. ");
INSERT INTO nyu_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Bzifuwo bzathu bzin'dzayenda na ife, palibe cizondo na cibodzico cin'dzasiyidwa. Nakuti tin'kasankhula bzinango kuti tikapembe kwa Mbuya, Mulungu wathu, tsono tikanati kufika pambuto, tin'dziwa lini ni bzinyama bziponi bzomwe tin'kapereka ntsembe”. ");
INSERT INTO nyu_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Tsono Mbuya adaumisa m'tima wa Falau, ndipo iye alibe kuwabvumiza kuti ayende. ");
INSERT INTO nyu_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pamwepo Falau adauza Mozeji kuti: “Coka patsogolo pangu! Leka kudzabwera pomwe patsogolo pangu cipo! Ntsiku yomwe un'dzawona nkhope yangu, un'dzafa”. ");
INSERT INTO nyu_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mozeji adatawira kuti: “Bzikhale ninga momwe waleweramu, cipo nin'dzawona lini pomwe nkhope yako”. ");
INSERT INTO nyu_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ndipo Mbuya adauza Mozeji kuti: “Nin'dzatumiza pomwe cisi cinango kuna Falau na kuna Ijipito. Cikatondokupita cisi cimweci basi, iye an'dzakubvumizani kucoka muno, mpaka kukuthothani mwentse. ");
INSERT INTO nyu_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Uza mbumba, amuna napo akazi, kuti akumbire bzinthu bza parata na bza oro kwa wapafupi nawo”. ");
INSERT INTO nyu_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ndipo Mbuya adacitisa kuti aIjipito alatize m'tima wabwino kuna mbumba, ndipo Mozejiyo akhambalemekezedwa kwene-kwene na wakulemekezeka wa Falau napombo na mbumba mudziko la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Pamwepo Mozeji adauza Falau kuti: “Mbuya alewa tenepa: ‘Pakati pa usiku nin'dzapita muIjipito mwentse. ");
INSERT INTO nyu_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Na tenepo wana wentse wakuyamba wa mudziko la Ijipito an'dzafa, kuyambira mwana wakuyamba wa Falau, omwe ngwakuthemera wakupasidwa utaka, mpaka mwana wakuyamba wa nyagirinya wacikazi omwe ali pampheyo, na wana wentse wakuyamba wa bzifuwo. ");
INSERT INTO nyu_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Mudziko lentse la Ijipito mun'dzakhala kulira kukulu, komwe kukanati kuwoneka ndipo mun'dzawoneka lini pomwe. ");
INSERT INTO nyu_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Tsono pakati pa aIjirayeri, pan'dzawoneka lini mbwaya na ibodziyo in'dzautira wanthu ayai bzifuwo’. Na tenepoyo imwepo mun'dziwa kuti Mbuya ambasiyanisa pakati pa aIjipito na aIjirayeri! ");
INSERT INTO nyu_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Pamwepo wakulemekezeka wako wentsenewa an'dzabwera kuna ine acindigodamira, aciti: ‘Coka iwe na mbumba yentse yomwe irikukutewera! Patsogolo pace ine nin'dzacoka’ ”. Ndipo Mozeji adacoka patsogolo pa Falau mwakukalipa kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Mbuya akhadauza Mozeji kuti: “Falau an'kakubverani lini, kuti bzidabwiso bzangu bzithimizirike mudziko la Ijipito”. ");
INSERT INTO nyu_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ndipo Mozeji na Aloni adacita bzidabwiso bzentsebzi patsogolo pa Falau, tsono Mbuya adamuumisa m'tima, ndipo iye alibe kubvumiza aIjirayeri kucoka mudziko lace. ");
INSERT INTO nyu_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mbuya adauza Mozeji na Aloni mudziko la Ijipito kuti: ");
INSERT INTO nyu_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Umweyu kwa imwe ukhale mwezi wakuyamba kwa gole. ");
INSERT INTO nyu_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Uzani bungwe lentse la aIjirayeri kuti pantsiku khumi za mwezi uno, munthu ali-yentse adzapambule bira m'bodzi pabanja lace, bira m'bodzi panyumba ibodzi na ibodzi ");
INSERT INTO nyu_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Tsono, penu banjalo ni ling'ono kuna bira wentseneyo, agawane na wapafupi naye malingana na mbogo ya wanthu, ndipombo na momwe m'bodzi na m'bodzi angadyere. ");
INSERT INTO nyu_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Cifuwo cakusankhulidwaco cikhale cakusaya kupunduka cacimuna ca gole libodzi, ndipo cikhale bira ayai mbuzi. ");
INSERT INTO nyu_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Mucikoye kufikira ntsiku khumi na zinai za mwezi umweuno, ndipo ntsiku imweyo bungwe lentse la aIjirayeri lidzaphe kumaulo pakumira kwa dzuwa. ");
INSERT INTO nyu_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ndipo mudzapalangire mulopa mumbali ziwiri za msuwo na padzaulu pace, panyumba zomwe an'dzadyera nyamayo. ");
INSERT INTO nyu_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Usiku bumwebo adzadye nyama yakuwocha pamoto, muliwo wakuwawira na pau zakusaya cakufufumisa. ");
INSERT INTO nyu_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Lekani kudzadya nyama iwisi, napo yakuphika na madzi, koma yakuwocha pa moto: Msolo, minyendo na bzam'mimba. ");
INSERT INTO nyu_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Lekani kudzaisiya mpaka macibese, tsono yomwe in'dzasalayo, mudzaitenthe. ");
INSERT INTO nyu_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Pakudya, mukhale mudakondzekera kucoka: Bhande m'ciuno, xango kuminyendo na mpsimbo m'manja. Mudzadye mwakam'kulumize. Imweyi ni Paxkwa ya Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Usiku bumwebo nin'dzapita mudziko la Ijipito ndipo nin'dzapha wana wakuyamba wentse wa wanthu mpaka wa bzinyama. Nin'dzalanga mirungu yentse ya muIjipito. Ine ndine Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Mulopayo un'dzakhala ciratizo cakuwonesa nyumba zomwe muli. Ine ndikadzawona mulopayo, nin'dzakupitirirani. Ndikadzamenya Ijipito, cisi cakudzonga cin'dzakufikirani lini”. ");
INSERT INTO nyu_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ntsiku imweyi in'dzakhala ya cikumbuso kuna imwepo na bzizukulu bzanu mumbadzacite m'sinda ninga cikondwereso ca Mbuya. Mucite ninga m'temo wakusaya kumala. ");
INSERT INTO nyu_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","M'kati mwa ntsiku zinomwe mudzadye pau yakusaya cakufufumisa. Pantsiku yakuyamba mudzacose bzakufufumisa munyumba zanu, thangwe omwe an'dzadya cinthu ciri-centse cina cakufufumisa, kuyambira ntsiku yakuyamba mpaka yacinomwe, munthu umweyo an'dzacosedwa pakati pa Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Pantsiku yakuyamba napombo ntsiku ya cinomwe, citani mtsonkhano wa mapembero. Lekani kuphata basa liri-lentse ntsiku zimwezo, kupambula basa la kukondza cakudya ca wentse. Ni bzimwebzi bzokha bzomwe mungacite. ");
INSERT INTO nyu_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Mumbakumbukire cikondwereso ca pau zakusaya cakufufumisa, thangwe ntsiku imweyi Ine ndidacosa mithithi yanu mudziko la Ijipito. Ndipo koyani ntsiku imweyi kwa mibadwe yanu ninga m'temo wakuyenda-na-kuyenda. ");
INSERT INTO nyu_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mwezi wakuyamba dyani pau yakusaya cakufufumisa, kuyambira kumaulo kwa ntsiku yacikhumi na zinai, mpaka maulo ya ntsiku makumi mawiri na ibodzi. ");
INSERT INTO nyu_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","M'kati mwa ntsiku zinomwe imwepo lekani kukhala na cakufufumisa munyumba zanu. Omwe an'dzadya pau ina cakufufumisa an'dzacosidwa pa bungwe la Ijirayeri, ngakhale nyakudza ayai wa m'dzikomo. ");
INSERT INTO nyu_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Lekani kudya cakufufumisidwa. Kwentse komwe mungakakhale, dyani pau yakusaya cakufufumisa yokha”. ");
INSERT INTO nyu_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Pamwepo Mozeji adatsonkhanisa atsogoleri wentse wa Ijirayeri aciwauza kuti: “Sankhulani mbira m'bodzi ayai mbuzi kwa banja libodzi na libodzi. Phani kuti mucite cikondwereso ca Paxkwa. ");
INSERT INTO nyu_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Bvikani msumbu wa mpfunde m'mulopa omwe uli m'tsambidwe, mupalangire padzulu na mumbali ziwiri za msuwo. Paleke kuwoneka omwe an'bula m'nyumba mpaka kucene. ");
INSERT INTO nyu_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Pomwe Mbuya an'dzapita padziko kuti aphe aIjipito, angadzawona mulopa padzaulu pa msuwo na mumbali zace ziwiri, an'dzapitirira msuwoyo ndipo an'dzabvumiza lini Nyakudzonga apite m'nyumba zanu kuti akupheni. ");
INSERT INTO nyu_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Bverani malangizo yamweya ninga m'temo wakusaya kumala kwa imwepo na kwa bzizukulu bzanu. ");
INSERT INTO nyu_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Mungadzapita mudziko lomwe Mbuya adapicira kukupasani, mumbadzacite m'sinda umweyu. ");
INSERT INTO nyu_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Wana wanu wakadzakubvundzani kuti: ‘Kodi m'sinda umweyu unilewanyi?’ ");
INSERT INTO nyu_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Mudzawatawire kuti: Ni ntsembe ya Paxkwa ya Mbuya, omwe adapitirira nyumba za aIjirayeri kuIjipito, ndipo adasiya nyumba zathu pomwe adapha aIjipito”. Pamwepo, mbumba idagodama mwakumupemba. ");
INSERT INTO nyu_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Patsogolo pace, aIjirayeri adacoka acikacita ninga momwe Mbuya akhadauzira Mozeji na Aloni. ");
INSERT INTO nyu_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Pamwepo, pakati pa usiku Mbuya adapha wana wentse wakuyamba kubadwa wa mudziko la Ijipito, kuyambira mwana wakuyamba wa Falau omwe ndiye angadapita utaka bwa umambo, mpaka mwana wakuyamba wa omwe akhadakoyedwa m'kawoko, ndipo na wana wentse wakuyamba wa bzifuwo. ");
INSERT INTO nyu_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pakati pa usiku Falau, wakulemekezeka wace wentse na aIjipito wentse adalamuka. Ndipo kudabveka kulira kukulu muIjipito, thangwe pakhalibe nyumba yomwe ikhalibe nkhawa. ");
INSERT INTO nyu_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Usiku bumwebule, Falau adacemeresa Mozeji na Aloni aciwauza kuti: “Cokani tsapanopa pakati pa mbumba yangu, imwepo na aIjirayeri! Ndokoni mukapembe Mbuya, ninga momwe mudakumbirira. ");
INSERT INTO nyu_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Tengani bzifuwo bzanu, ninga momwe mukhadalewera ndipo mundidalisembo ine”. ");
INSERT INTO nyu_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","AIjipito akhaumiriza mbumba kuti ikulumize kucoka m'dzikomo, acimbati: “Tentsene tin'fa!” ");
INSERT INTO nyu_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Pamwepo mbumba idatenga ufa bwakumunya kale bwa pau bwakusaya cakufufumisa adaikha muntsambidwe acimanga pamkundza ndipo adanyamula paphewa. ");
INSERT INTO nyu_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","AIjirayeri adabvera fala la Mozeji ndipo adakumbira aIjipito bzombo bza parata na bza oro napombo bzakubvala. ");
INSERT INTO nyu_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Mbuya adacitisa kuti mbumba ikomeredwe m'tima kucipande ca aIjipito, mwakuti iwo akhawapasa bzomwe akhakumbiridwa. Na tenepo iwo adapamba cuma ca aIjipito. ");
INSERT INTO nyu_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","AIjirayeri adanyamuka kuRamesesi kuyenda kuSukote. Pakhana amuna wakukwanira bzulu madzana matanthatu (600.000) omwe akhafamba na minyendo, pakusaya kulewenga akazi na wana. ");
INSERT INTO nyu_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","M'thithi ukulu wa anyakudza wakusiyana-siyana udayenda na iwo, napombo m'thithi ukulu wa bzifuwo, ninga ng'ombe, mabira na mbuzi. ");
INSERT INTO nyu_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ndipo adaphika pau zakusaya cakufufumisa, na ufa bwakumunya kale bomwe adacoka nabo kuIjipito. Ufabo bukhalibe cakufufumisa, nakuti iwo adathothidwa mudziko la Ijipito ndipo akhalibe nthawe yakuphika cakudya. ");
INSERT INTO nyu_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","AIjirayeri adakhala mudziko la Ijipito magole madzana manai na makumi matatu (430). ");
INSERT INTO nyu_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ntsiku yomwe yadakwana magole madzana manai na makumi matatu (430), mithithi yentse ya Mbuya idacoka mudziko la Ijipito. ");
INSERT INTO nyu_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ninga momwe Mbuya adaphuphudzira usiku bule, kuti acose aIjirayeri muIjipito, amwewambo bzin'funika kuti aphuphudzembo usiku bwentsenebu kuti atumbize Mbuya pamibadwe yawo yentse. ");
INSERT INTO nyu_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ndipo Mbuya adauza Mozeji na Aloni kuti: “Mitemo ya Paxkwa njiyi: Palibe nyakudza na m'bodziyo omwe an'dzaidya. ");
INSERT INTO nyu_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Nyagirinya wakugulidwa angadzadye Paxkwa atamala kucitidwa m'sinda wa m'gwato, ");
INSERT INTO nyu_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Tsono mulendo na kapolo wakulipiridwa an'dzaidya. ");
INSERT INTO nyu_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Imwepo mun'dzaidyere munyumba ibodzi yokha, lekani kudzabula na nthindi ya nyama panja, ngakhale kuswa pfupa na libodziro. ");
INSERT INTO nyu_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Bungwe lentse la Ijirayeri limbadzacite cikondwereso ca Paxkwa. ");
INSERT INTO nyu_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Nyakudza ali-yentse omwe ambakhala pakati panu, akafuna kudya Paxkwa ya Mbuya, bzin'funika kucitidwa m'sinda wa m'gwato kuna amuna wentse wa m'banja mwawo. Pamwepo angacite mbali ya cikondwereso ninga aIjirayeri anango. Palibe na m'bodziyo wakusaya kucita m'sinda wa m'gwato angadzacite mbali. ");
INSERT INTO nyu_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","M'temo ubodzi-bodziyu udzaphatisidwe basa kwa mbadwe ya m'dzikomo na kwa nyakudza omwe an'khala m'dzikomo”. ");
INSERT INTO nyu_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","AIjirayeri wentse adacita ninga momwe Mbuya akhadauzira Mozeji na Aloni. ");
INSERT INTO nyu_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ntsiku ibodzi-bodziyo, Mbuya adacosa aIjirayeri mudziko la Ijipito, malingana na madzindza yawo. ");
INSERT INTO nyu_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ndipo Mbuya adauza Mozeji kuti: ");
INSERT INTO nyu_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Undipambulire wana wentse wakuyamba kubadwa. Mwana wakuyamba kubadwa wa aIjirayeri ni wangu, sikuti wa wanthu okha, tsonombo na wa pakati pa bzinyama”. ");
INSERT INTO nyu_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Pamwepo Mozeji adauza mbumba kuti: Mumbaikumbukire ntsiku imweyi, yomwe imwe mudacoka muIjipito, m'dziko la unyagirinya, thangwe Mbuya adakucosani kumweko na boko la mphambvu. Lekani kudya na pang'onopo bzakufufumisidwa. ");
INSERT INTO nyu_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Lero, ntsiku ya mwezi wakucemeredwa Abibu mulikucoka. ");
INSERT INTO nyu_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Pomwe Mbuya an'dzakupitisani mudziko la aKenani, la aHiti, la aAmori, la aHivi na la aJebusi, dziko lomwe adapicira kwa makolo yanu, kuti an'dzalipereka kwa imwe, lomwe lidadzala mkaka na uci, imwepo mumbadzacite msinda umweyu pamwezi umweyu. ");
INSERT INTO nyu_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mkati mwa ntsiku zinomwe mumbadzadye pau yomwe iribe cakufufumisa ndipo pantsiku yacinomwe mumbadzacite cikondwereso ca Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Dyani pau yomwe iribe cakufufumisa m'kati mwa ntsiku zinomwe. Paleke kudzawoneka cakufufumisidwa kwa imwe, ngakhale cakufufumisa m'kati mwa m'dziko lanu lentse. ");
INSERT INTO nyu_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Pantsiku imweyo, m'bodzi na m'bodzi adzauze mwana wace kuti: Ndirikucita bzimwebzi thangwe la bzomwe Mbuya adacita kwa ine, pomwe ndidacoka muIjipito. ");
INSERT INTO nyu_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Bzimwebzi bzin'dzakhala kwa imwe ninga cizindikiro m'manja mwanu ndipombo cikumbuso pamkuma panu kuti mulewe bza Mtemo wa Mbuya, thangwe Mbuya adakucosani kuIjipito na boko la mphambvu. ");
INSERT INTO nyu_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Muteweze bzalewedwabzi panthawe yace caiyo, pagole liri-rentse”. ");
INSERT INTO nyu_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Patsogolo pace Mbuya akadzakupitisani mudziko la aKanani aciripereka kuna imwe, ninga momwe adalumbira kwa imwe na kwa makolo yanu, ");
INSERT INTO nyu_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","mudzapambulire Mbuya mwana wakuyamba kubadwa wentse. Wana wakuyamba wacimuna wa bzifuwo bzanu wentse ni wa Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mwana wakuyamba wa bulu ali-yentse mudzamulombole na bira, tsono ukasaya kufuna kudzamulombola, udzachole khosi. Umbadzalombolembo mwana wakuyamba ali-yentse pakati pa wana wako”. ");
INSERT INTO nyu_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Kutsogoloko, wana wako akadzakubvundza kuti: ‘Bzinilewanyi bzimwebzi?’ Udzamutawire kuti: Mbuya adaticosa na boko la mphambvu kuIjipito, mudziko la unyagirinya. ");
INSERT INTO nyu_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ndipo pomwe Falau adapitiriza kuumisa m'tima acilamba kuti ticoke, Mbuya adapha wana wakuyamba kubadwa wentse wa muIjipito, wa wanthu napo wa bzifuwo. Ndipopo timbapereka ntsembe kwa Mbuya bzacimuna bzakuyamba kubadwa bzentse. Ndipo timbalombola wana wathu wakuyamba kubadwa”. ");
INSERT INTO nyu_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","“Cimweci cin'dzakhala ninga cilatizo paboko lako na cizindikiro pam'kuma pako kuti Mbuya adaticosa muIjipito na boko lace la mphambvu”. ");
INSERT INTO nyu_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Pomwe Falau adaleka mbumba kuti icoke, Mulungu alibe kuwayendesa na njira ya dziko la aFilisiti, napo imweyi ikhali njira ifupi, nakuti Mulungu adati: “Wanthuwa acigumana na nkhondo, pinango angakhumbule acibwerera kuIjipito”. ");
INSERT INTO nyu_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Na tenepo Mulungu adacitisa kuti mbumbayo izungulire kucidambo mwakutewera njira yomwe ikhayenda kuNyandza Ifuira. AIjirayeri adacoka kuIjipito mwakukondzeka kukamenya nkhondo. ");
INSERT INTO nyu_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mozeji adatakula mafupa ya Zuze, thangwe Zuze akhadalumbirisa aIjirayeri, pomwe adati: “Cadidi Mulungu an'dzabwera kudzakuthandizani, pamwepo mudzatakule mafupa yangu kucoka nayo kuno”. ");
INSERT INTO nyu_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","AIjirayeri adacoka muSukoti ndipo adamanga msasa muEtamu m'mphepete mwa cidambo. ");
INSERT INTO nyu_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Nthawe ya masikati, Mbuya akhawatsogolera na mtambo uli njo kuti uwalatize njira, ndipo usiku akhawatsogolera na moto uli njo kuti uwabvunikire, tenepoyo akhakwanisa kufamba masikati na usiku. ");
INSERT INTO nyu_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Nthawe zentse Pilar ya mtambo ikhacoka lini pakati pa mbumba masikati, napo pilar ya moto usiku. ");
INSERT INTO nyu_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Mbuya adauza Mozeji kuti: ");
INSERT INTO nyu_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Uza aIjirayeri kuti abwere ndipo amange msasa pafupi na Pi-Hahiroti, pakati pa Migdoli na nyandza. Mumange msasa m'mphepete mwa nyandza kunyang'anisana na Baala-Zefoni. ");
INSERT INTO nyu_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Falau an'dzakumbuka kuti aIjirayeri alikufamba mwakusaya kudziwa, ataika m'cidambo. ");
INSERT INTO nyu_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Pamwepo nin'dzaumisa m'tima wa Falau ndipo iye an'dzawatewera. Mwa bzentsenebzo Ine nin'dzatumbizidwa kudzera mwa Falau na wankhondo wace wentse. Ndipo aIjipito an'dzadziwa kuti Ine ndine Mbuya”. Ndipo aIjirayeri adacita tenepoyo. ");
INSERT INTO nyu_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Adauza mambo wa muIjipito kuti mbumba yathawa. Pamwepo Falau na wakulemekezeka wace adacinja ndzeru ndipo adati: “N'ciyani comwe tacita? Talekerera aIjirayeri kuti ayende ndipo taluza anyagirinya wathu!” ");
INSERT INTO nyu_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Pamwepo Falau adawauza kuti akondze ngolo yace ndipo adatenga gulu lace la nkhondo. ");
INSERT INTO nyu_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Adatenga ngolo zentse za nkhondo kuphatikidza madzana matanthatu (600) ya ngolo zakufunikira adaikha m'tsogoleri pangolo iri-yentse. ");
INSERT INTO nyu_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mbuya adaumisa m'tima wa Falau, mambo wa kuIjipito, ndipo iye adatewera aIjirayeri, omwe akhafamba mwautumbi. ");
INSERT INTO nyu_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","AIjipito na makavalo yentse na ngolo za nkhondo za Falau, na wakufamba na makavalo wace na gulu la acikunda wakufamba na minyendo, adacoka aciwatewera aIjirayeri ndipo adakawagumana ali pamsasa mumphepete mwa nyandza pafupi na Pi-Hahirote yakunyang'anisana na Baal-Zefoni. ");
INSERT INTO nyu_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Falau pomwe akhafendera, aIjirayeri adawona aIjipito akhabwera kuna iwo ndipo adabva mantha acikuwa mwakudandaula kuna Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Adauza Mozeji kuti: “Kodi n'kulewa kuti kuIjipito kukhalibe thenje ndipopa watibweresa kuti tidzafere kucidambo kuno? Waticitiranyi terepoyo, kuticosa kuIjipito? ");
INSERT INTO nyu_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ife tidakuuziratu kuIjipito kuti: Tisiye mwamtendere! Tin'dzakhala anyagirinya wa aIjipito! Bziribwino kukhala anyagirinya wa aIjipito kuposa kufera mucidambo!” ");
INSERT INTO nyu_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mozeji adatawira mbumba kuti: “Lekani mantha. Limbikani muwone cipulumuso comwe Mbuya an'kucitirani lero, thangwe imwepo mun'dzawawona lini pomwe aIjipito omwe mulikuwonawa. ");
INSERT INTO nyu_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Mbuya an'kumenyerani nkhondo imwepo derekhani”. ");
INSERT INTO nyu_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Pamwepo Mbuya adauza Mozeji kuti: “Thangwe ranyi iwepo ulikudandaula kuna Ine? Uza aIjirayeri kuti ayende kutsogolo. ");
INSERT INTO nyu_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Dzusa mpsimbo yako, ufuthule boko panyandza, ndipo madzi yan'dzagawika kuti aIjirayeri ayambuke pakuuma. ");
INSERT INTO nyu_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Tsono Ine nin'dzaumisa mitima ya aIjipito, kuti an'dzakutewereni. Kukundidwa kwa Falau, na acikunda wace wentse na ngolo zace na wakufamba na makavalo wace, kun'dzacitisa kuti ndidzatumbizidwe. ");
INSERT INTO nyu_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","AIjipito an'dzadziwa kuti Ine ndine Mbuya, pakutumbizidwa kwangu na kukunda Falau na ngolo zace na wakufamba na makavalo wace”. ");
INSERT INTO nyu_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Pamwepo anju wa Mulungu, omwe akhayenda patsogolo pa acikunda wa Ijirayeri, adacoka aciyenda m'mbuyo mwawo. Napombo Pilar ya mtambo idacoka patsogolo pawo, ndipo idakakhala m'mbuyo mwawo, ");
INSERT INTO nyu_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","icikakhala pakati pa aIjipito na aIjirayeri. Mtambo udabweresa mdima kuna awa ndipo ceza kuna anango, mwakuti usiku bwentsenebo aIjipito alibe kukwanisa kufendera kuna aIjirayeri. ");
INSERT INTO nyu_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Pamwepo, Mozeji adafuthula boko padzulu pa nyandza, ndipo Mbuya adagawa nyandza pacikhala pakuuma kudzera mwa mphepo ya mphambvu ya kumabva-dzuwa idafuliza usiku bwentse. Madzi yadagawika, ");
INSERT INTO nyu_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ndipo aIjirayeri adayambuka na pakati pa nyandza pakuuma, madzi yadakhala ninga litsito kuboko lawo ladidi na kuboko ladzere. ");
INSERT INTO nyu_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","AIjipito adawatewera m'mbuyo, ndipo makavalo yentse, ngolo za nkhondo, na wakufamba na makavalo wa Falau adapita mpaka pakati pa nyandza. ");
INSERT INTO nyu_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ndipo madandakweca, Mbuya ali mupilar ya moto na ya mtambo, adawona acikunda wa aIjipito ndipo adawacitisa phiringu. ");
INSERT INTO nyu_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Adacitisa kuti bzigaleta bza ngolo zawo bziyambe kufonyoka mwakuti akhafambisa mwakuneseka. Ndipo aIjipito adakuwa aciti: “Mbatiwathaweni aIjirayeri! Mbuya ali kucipande cawo kumenya aIjipito”. ");
INSERT INTO nyu_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Tsono, Mbuya adauza Mozeji kuti: “Futhula boko lako panyandza, kuti madzi yabwerere yamize aIjipito, na ngolo zawo na wakufamba na makavalo wawo”. ");
INSERT INTO nyu_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Na tenepo Mozeji adafuthula boko panyandza, ndipo pomwe kukhacena nyandza idabwerera mwace mwa kale. Pomwe aIjipito akhathawa, adakagumana na madzi, ndipo Mbuya adawathusa m'nyandza. ");
INSERT INTO nyu_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Madziyo yadabwerera yacimiza ngolo za nkhondo na wakufamba na makavalo na acikunda wentse wa Falau, omwe akhadatewera aIjirayeri m'nyandza. Palibe na m'bodziyo omwe adapulumuka. ");
INSERT INTO nyu_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Tsono, aIjirayeri adayambuka nyandza acifamba pakuuma, madzi yakhadakhala ninga litsito, kumphimpha ya ladidi na ya ladzere. ");
INSERT INTO nyu_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ntsiku imweire Mbuya adapulumusa Ijirayeri m'manja mwa aIjipito, ndipo aIjirayeri adawona aIjipito wakufa m'mphepete mwa nyandza. ");
INSERT INTO nyu_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Tenepoyo aIjirayeri adawona mphambvu ikulu ya Mbuya yomwe adakundanayo aIjipito, mbumba idagopa Mbuya, icim'khulupirira na m'tumiki wace Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Pamwepo, Mozeji na aIjirayeri adaimba nyimbo iyi kuna Mbuya, ndipo adati: “Nin'dzaimbira Mbuya pakuti awina mwautumbi. Adathusa m'nyandza haci na wakufamba nayo wace. ");
INSERT INTO nyu_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mbuya ni mphambvu yangu ndipo ni nyimbo yangu. Iye ni cipulumuso cangu! Iye ni Mulungu wangu, ndipo ine nin'dzamutumbiza, ni Mulungu wa baba wangu, ndipo ine nin'dzamukuza. ");
INSERT INTO nyu_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Mbuya ni wankhondo, Dzina lace ni Mbuya, ");
INSERT INTO nyu_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Iye adathusa munyandza ngolo za nkhondo na acikunda wa Falau. Wakulemekezeka wace wabwino adamira muNyandza Ifuira. ");
INSERT INTO nyu_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Madzi yakuzika yadawampsinkha, adamira pantsi ninga mwala. ");
INSERT INTO nyu_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Mbuya, boko lanu lamadidi lina ulemelero mwa mphambvu lace. Mbuya, boko lanu lamadidi lidagwata-gwata anyamadulanthaka. ");
INSERT INTO nyu_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Mukukunda kwanu kukulu mudagwesa omwe ankupindukirani. Mudatumiza ukali bwanu bwakugaka ninga moto, bomwe budawatentha ninga mausva. ");
INSERT INTO nyu_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Na kufuliza kwa mphambvu kwa mphuno zanu madzi yadagwezekana. Madzi yakuyerera yadaima ninga litsito. Madzi yakuzika yadauma m'kati mwa nyandza. ");
INSERT INTO nyu_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Nyamadulanthaka akhambabzitumbiza aciti: ‘Ine nin'dzawatewera ndiciwaphata, nin'dzagawa bzinthu bzawo nin'dzatenga bzomwe nin'funa. Na cisenga m'manja, ine nin'dzawadzonga’. ");
INSERT INTO nyu_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tsono mudatumiza mphepo yanu, ndipo nyandza idawamiza. Adamira ninga utale bwa cumbu m'madzi mazinji. ");
INSERT INTO nyu_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Mbani pakati pa mirungu adalinganira na imwe, Mbuya? Mbani adalinganira na imwe, wakulemekezedwa mwa kucena, wakugosva thangwe ra mabasa yanu ya ulemerero ndipo yakudabwisa, omwe ambakondza bzidabwiso? ");
INSERT INTO nyu_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Mafuthula boko lanu lamadidi, ndipo mataka yadawakhudyula anyamadulanthaka. ");
INSERT INTO nyu_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Na lufoi lanu lakusaya kucinja mwatsogolera mbumba yomwe mudalombola. Na mphambvu zanu Imwe mwaitenga kumbuto yanu yakucena. ");
INSERT INTO nyu_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Madziko yambabva, ndipo yambatekenyeka. Mantha makulu yambafikira wanthu wa dziko la Filisti. ");
INSERT INTO nyu_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Atsogoleri wa dziko la Edomu ambamala mphambvu, atongi wa dziko la Mowabi ambaphatidwa na mantha, wanthu wentse wakukhala mudziko la Kenani ambathetha. ");
INSERT INTO nyu_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Kutetemera na mantha bziniwagwera, kudzera mwa mphambvu za boko lako ambakhala pulu ninga mwala, mpaka mbumba yako ipite, oh Mbuya, mpaka ipite mbumba yako yomwe udagula. ");
INSERT INTO nyu_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Iwe udzaipitisa, ucidzaibzala paphiri ra utaka bwako, oh Mbuya, pambuto yomwe udakondza kuti ikhale pakukhala pako, nyumba yakucena, oh Mbuya, yomwe manja yako yadakondza. ");
INSERT INTO nyu_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Mbuya an'dzakhala mambo mpaka kuyenda-na-kuyenda”. ");
INSERT INTO nyu_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Pomwe makavalo ya Falau, ngolo za nkhondo na wakufamba na makavalo wa Falau adapita munyandza, Mbuya adabwezera madziyo ndipo yadawamiza, tsono aIjirayeri adayambuka nyandzayo mwakufamba na minyendo pakuuma. ");
INSERT INTO nyu_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Pamwepo Miriyamu mpolofita wacikazi, mpfumakazi ya Aloni, adatenga kang'oma, ndipo akazi wentse adamutewera akhaimba tung'oma acimbabzina. ");
INSERT INTO nyu_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ndipo Miriyamu akhawatawira mwakuimba aciti: “Imbirani Mbuya, nakuti wakunda mwautumbi. Adathusa m'nyandza kavalo na wakufamba naye”. ");
INSERT INTO nyu_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Patsogolo pace Mozeji adatsogolera aIjirayeri kucokera kuNyandza Ifuira mpaka kucidambo ca Suri. M'kati mwa ntsiku zitatu adafamba mucidambo alibe kuwona madzi. ");
INSERT INTO nyu_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ndipo adafika kuMara, tsono alibe kukwanisa kumwa madzi ya kumweko, thangwe yakhawawa. Ndipopo mbutoyo imbacemeredwa Mara. ");
INSERT INTO nyu_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ndipo mbumba idadandaulira Mozeji iciti: “Kodi tinimwa ciyani”? ");
INSERT INTO nyu_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mozeji adapemba mwakudandaula kuna Mbuya, ndipo Mbuya adamuwonesa kamuti. Mozeji adakathusa m'madzi, pamwepo madziyo yadakhala yabwino. KuMarako Mbuya adawapasa mitemo na malamulo, aciwayeza ");
INSERT INTO nyu_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","aciti: “Mukabvera bwino Mbuya Mulungu wanu, mucicita bzomwe Iye an'dekedwa nabzo, mucimbateweza malamulo yace na kukoya mitemo yace yentse, nin'dzakubwereserani lini matenda yali-yentse yomwe Ine ndidabweresera aIjipito, pakuti Ine ndine Mbuya omwe nimbakupozani”. ");
INSERT INTO nyu_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Patsogolo pace, adafika kuElimu, komwe kukhana micera ya madzi khumi na miwiri (12) na makanjedza makumi manomwe (70). Ndipo adamanga misasa pafupi na madziyo. ");
INSERT INTO nyu_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Mthithi wentse wa aIjirayeri udacoka kuElimu, ndipo pantsiku khumi na zixanu za mwezi waciwiri atacoka kudziko la Ijipito, adakafika kucidambo ca Sini, comwe ciri pakati pa Elimu na Sinai. ");
INSERT INTO nyu_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Mucidambomo mthithi wentse wa aIjirayeri udadandaulira Mozeji na Aloni. ");
INSERT INTO nyu_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","AIjirayeri adawauza kuti: “Bzikhali bwino boko la Mbuya lingadatiphera muIjipito! Kumweko tikhakhala pafupi na bzikalango bza nyama ndipo tikhadya pau ticikhuta, tsono imwepo mwatibweresa kucidambo kuno kuti muphe mthithi wentseneyu na njala!” ");
INSERT INTO nyu_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ndipo Mbuya adauza Mozeji kuti: “Ine nin'dzakubvumbisirani pau kucokera kudzulu. Mbumba in'dzacoka icimbadzalokota ntsiku zentse cipande cakukwanira ntsiku imweire. Na bzimwebzo, nin'dzakuyezani kuti ndikuwoneni penu mun'dzateweza m'temo wangu ayai nee. ");
INSERT INTO nyu_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Pantsiku yacitanthatu, mun'dzalokote ndipo mudzaphike bzakufunya kawiri pa bzomwe mumbalokota pantsiku”. ");
INSERT INTO nyu_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Pamwepo, Mozeji na Aloni adauza aIjirayeri wentse kuti: “Pomwe kun'doka, imwepo mun'dzadziwa kuti ni Mbuya omwe adakucosani kuIjipito, ");
INSERT INTO nyu_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ndipo mangwana macibese-bese mun'dzawona ulemerero bwa Mbuya, thangwe Mbuya wabva kudandaula komwe mukhamucitira. Kodi ife ndife yani kuti imwe mutidandaulire?” ");
INSERT INTO nyu_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mozeji adapitiriza aciti: “Mbuya an'kupasani nyama kuti mudye kumaulo na macibese pau momwe mun'funira, thangwe Mbuya wabva kudandaula komwe mukhamucitira, kodi ife ndife yani? Imwepo mulikudandaulira lini ife, koma Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mozeji adauza Aloni kuti: “Uza mbumba yentse ya aIjirayeri kuti ifike patsogolo pa Mbuya, nakuti Iye wabva kudandaula kwanu”. ");
INSERT INTO nyu_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Pomwe Aloni akhalewa-lewa na mthithi wa aIjirayeri, wentse adanyang'ana kucidambo, ndipo ulemerero wa Mbuya udawonekera mumtambo. ");
INSERT INTO nyu_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ndipo Mbuya adauza Mozeji kuti: ");
INSERT INTO nyu_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Ndabva kudandaula kwa aIjirayeri. Atawire kuti kumaulo mun'dzadya nyama, ndipo kumacibese mun'dzadya pau mucikhuta, na tenepo mun'dzadziwa kuti Ine ndine Mbuya Mulungu wanu”. ");
INSERT INTO nyu_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Kumaulo zidabwera ntsendzetsi zicimpsinkha mbuto yomwe akhadamanga msasa. Kumacibese kukhana mame kuzungulira msasa. ");
INSERT INTO nyu_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Pomwe mame yadamala mucidambo, pantsi padawoneka tubzinthu tucena ninga mabade. ");
INSERT INTO nyu_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","AIjirayeri pomwe adawona tubzinthu tule, adabvundzana wina na mwandzace kuti: “Kodi n'tuciyani tumwetu?” Nakuti akhatudziwa lini kuti nthuciyani. Mozeji adawauza kuti: “Imweyi ni pau yomwe Mbuya akupasani kuti mudye. ");
INSERT INTO nyu_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Mbuya adawauza terepa: ‘Mtsogoleri wa banja libodzi na libodzi akhongobze tomwe an'funa, munthu ali-yentse magaba mawiri, malinge na mbogo ya wanthu omwe ali pacikumbi pace’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","AIjirayeri adacita bzomwe adauzidwa. Anango adalokota bzizinji, anango bzing'ono-ng'ono. ");
INSERT INTO nyu_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Pomwe adapima na galoni, kuna omwe adalokota bzizinji bziribe kusala, ndipo bziribe kuperewera kuna omwe akhadalokota pang'ono. M'bodzi na m'bodzi adalokota bzomwe akhafuna. ");
INSERT INTO nyu_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Pamwepo Mozeji adawauza kuti: “Palibe omwe an'koya mpaka mangwana”. ");
INSERT INTO nyu_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Tsono anango mwa iwo alibe kum'bvera Mozeji, ndipo adakoya pang'ono mpaka mangwana yandzace, tsono bzakukoya bzire bzidagwa nkhonye bzicinunkha. Ndipopo Mozeji adawakalipira. ");
INSERT INTO nyu_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Macibese yali-yentse, wentse akhambalokota bzomwe akhakwanisa kudya, pakuti dzuwa likapsa bzimwebzire bzikhasungunuka. ");
INSERT INTO nyu_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Pantsiku yacitanthatu, adalokota pau kufunya kawiri, magaloni mawiri kwa munthu m'bodzi. Ndipo atsogoleri wa mthithi adayenda acikafotokozera Mozeji bzimwebzo, ");
INSERT INTO nyu_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","tsono Mozeji adawauza kuti: “Mbuya adalewa kuti: ‘Mangwana ni ntsiku yakupuma, ntsiku ya Sabudu yakupambulidwa kwa Mbuya. Wochani ndipo phikani yomwe mun'funa. Yakusalayo muikoye mpaka mangwana’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ndipo iwo adatukoya mpaka mangwana yace, ninga momwe Mozeji akhadawauzira, tulibe kununkha, ngakhale kugwa tulombo. ");
INSERT INTO nyu_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mozeji adawauza kuti: “Dyani tumwetu lero, nakuti lero ni ntsiku ya Sabudu ya Mbuya. Lero mun'tuwona lini kunjaku. ");
INSERT INTO nyu_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","M'kati mwa ntsiku zitanthatu imwepo mungalokote, tsono ntsiku yacinomwe, ya Sabudu, mun'dzawona lini cinthu”. ");
INSERT INTO nyu_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Napo na bzobzo, anango adayenda pantsiku yacinomwe kuti akalokote cakudya, tsono alibe kuwona cinthu. ");
INSERT INTO nyu_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Pamwepo Mbuya adauza Mozeji kuti: “Kodi imwepo mun'dzalamba kubvera malamulo yangu na malangizo yangu mpaka lini? ");
INSERT INTO nyu_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kumbukirani kuti Mbuya ndiye adakupasani ntsiku ya Sabudu. Ndipopo pantsiku ya citanthatu Iye ambakupasani pau zakuti mudye ntsiku ziwiri. Ntsiku yacinomwe khalani mwentse komwe muliko, palibe ndiye an'coka”. ");
INSERT INTO nyu_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Na tenepo, pantsiku yacinomwe mbumba idapuma. ");
INSERT INTO nyu_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Mbumba ya Ijirayeri idapasa cakudya cire dzina lakuti mana. Cikhali cakucena ninga mbewu icena, ndipo cikhatapira ninga bolo lakukondzedwa na uci. ");
INSERT INTO nyu_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mozeji adawauza kuti: “Mbuya alewa kuti lokotani galoni la mana, mulikoye kuti mibadwe ya kutsogolo kuno idzawone pau yomwe ndidakupasani mucidambo, pomwe ndidakucosani mudziko la Ijipito”. ");
INSERT INTO nyu_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Pamwepo Mozeji adauza Aloni kuti: “Pima magaba mawiri ya mana uikhe mucombo ndipo uikhe pana Mbuya, kuti yakoyedwere mibadwe ya kutsogolo kuno”. ");
INSERT INTO nyu_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Mwakubvera bzomwe Mbuya akhadauzira Mozeji, Aloni adaikha mana patsogolo pa Kaxa ya Cipangano kuti yakoyeke. ");
INSERT INTO nyu_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ndipo aIjirayeri adamala magole makumi manai alikudya mana, mpaka adakafika kudziko lakukhalika. Adadya mana mpaka kufika kumalire ya dziko la Kanani. ");
INSERT INTO nyu_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Galoni likhali cacikhumi ca efa.) ");
INSERT INTO nyu_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Mthithi wentse wa aIjirayeri udacoka kucidambo ca Sini, ucimbafamba mbuto na mbuto, ninga momwe Mbuya akhadawauzira. Adakamanga misasa muRefidimu, tsono kumweko kukhalibe madzi yakumwa. ");
INSERT INTO nyu_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Na bzimwebzo mbumba idayamba kunesana na Mozeji acimuuza kuti: “Tipase madzi timwe”. Iye adatawira kuti: “Thangwe ranyi mun'nesana na ine? Thangwe ranyi mulikuyeza Mbuya?” ");
INSERT INTO nyu_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Tsono mbumba ikhana nyota idadandaula kuna Mozeji iciti: “Thangwe ranyi iwe udaticosa kuIjipito? Kuti utiphe na nyota, ife na wana wathu na bzifuwo bzathu?” ");
INSERT INTO nyu_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Pamwepo Mozeji adandandaula kuna Mbuya aciti: “Ndicite ciyani na mbumbayi? Afika pakuti andibome na minyala”. ");
INSERT INTO nyu_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mbuya adatawira Mozeji adati: “Pita patsogolo pa mbumba. Tenga atsogoleri anango wa aIjirayeri, utenge mpsimbo yako m'manja yomwe udamenya nayo Nilo ndipo ndoko patsogolo. ");
INSERT INTO nyu_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ine nin'dzakhala kutsogolo kwako padzulu pa tsendwa la phiri la Horebe. Menya tsendwalo, ndipo lin'dzacoka madzi kuti mbumba imwe”. Mozeji adacita tenepo patsogolo pa atsogoleri wa Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ndipo mbuto ire adaicemera Masa na Meriba, thangwe kumwekule aIjirayeri adanesana ndipo adayeza Mbuya aciti: “Kodi Mbuya ali pakati pathu, ayai nee?” ");
INSERT INTO nyu_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ndipo aAmaleki adabwera kudzamenya aIjirayeri kuRefidimu. ");
INSERT INTO nyu_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Pamwepo Mozeji adauza Jozuwe kuti: “Sankhula amuna anango kuti amenyane na aAmaleki. Mangwana nin'dzakakhala padzulu pa kaphiri, na mpsimbo ya Mulungu m'manja mwangu”. ");
INSERT INTO nyu_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Jozuwe adayenda kukamenyana na aAmaleki ninga momwe Mozeji adamuuzira. Tsono Mozeji, Aloni na Huri adakwira pa dzulu pa kaphiri. ");
INSERT INTO nyu_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Pomwe Mozeji akhakwiza manja m'dzaulu, aIjirayeri akhakunda. Tsono pomwe akhagwesa manja aAmaleki akhakunda. ");
INSERT INTO nyu_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Pomwe Mozeji adaneta manja, iwo adakatenga mwala aciuikha pantsi pace, kuti aukhalire. Aloni na Huri akhadzusa manja ya Mozeji, m'bodzi mbali iyi winango mbali inango mwakuti manja yace yadakhala yakulimba mpaka dzuwa kumira. ");
INSERT INTO nyu_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ndipo Jozuwe adakunda mthithi wa acikunda wa aAmaleki na cisenga. ");
INSERT INTO nyu_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Patsogolo pace Mbuya adauza Mozeji kuti: “Nemba bzimwebzi mubukhu ninga cikumbuso, ndipo uza Jozuwe kuti nin'dzacitisa kuti aAmaleki adzakhale wakuyebwedwa-letu pantsi pano”. ");
INSERT INTO nyu_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ndipo Mozeji adamanga guwa aciricemera kuti: “Mbuya ndiye bandera langu”. ");
INSERT INTO nyu_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ndipo adati: “Mbuya walumbira, pan'dzawoneka nkhondo ya Mbuya kuna aAmaleki kwa m'badwe na m'badwe”. ");
INSERT INTO nyu_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetero, wantsembe wa kuMidiyani, thebzala wa Mozeji, adabva bzentse bzomwe Mulungu akhadacitira Mozeji na mbumba ya Ijirayeri, bza momwe Mbuya adacosera aIjirayeri muIjipito. ");
INSERT INTO nyu_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mozeji akhadatumiza Zipora mkazi wace kunyumba kwa thebzala wace Jetero, iye adamutambira ");
INSERT INTO nyu_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","pabodzi na wana wace awiri wacimuna. M'bodzi wawo akhacemeredwa Geresoni, thangwe Mozeji adati: “Ndakhala nyakudza mudziko lacilendo”. ");
INSERT INTO nyu_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ndipo winangoyo adam'cemera Eliyezere, thangwe adati: “Mulungu wa baba wangu akhali m'thandizi wangu ndipo adandipulumusa pa cisenga ca Falau”. ");
INSERT INTO nyu_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jetero, thebzala wa Mozeji, adabwera na mkazi na wana wa Mozeji mucidambo, komwe akhadamanga bzikumbi pafupi na phiri la Mulungu. ");
INSERT INTO nyu_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Ndipo Jetero adatumiza mafala kuna Mozeji kuti: “Ine thebzala wako Jetero, ndirikubwera kuna iwe, na mkazi wako na wana wace awiri”. ");
INSERT INTO nyu_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Pamwepo Mozeji adacoka acikagumana na thebzala wace, adagodama acimumpsompsona. Atamusana adapita mucikumbi. ");
INSERT INTO nyu_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ndipo Mozeji adafotokozera thebzala wace bzentse bzomwe Mbuya adacita kuna Falau na aIjipito, thangwe ra lufoi kuna aIjirayeri, ndipombo mphicha zomwe adagumana nazo paulendo, na momwe Mbuya adawapulumusira. ");
INSERT INTO nyu_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetero adakondwera na bzabwino bzentse bzomwe Mbuya adacitira aIjirayeri, kuwapulumusa m'manja mwa aIjipito. ");
INSERT INTO nyu_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ndipo adati: “Mbasimbidwe Mbuya, omwe adakupulumusani m'manja mwa aIjipito na mwa Falau. ");
INSERT INTO nyu_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Tsapano ndadziwa kuti Mbuya ni m'kulu kuposa mirungu yentse, thangwe adapulumusa mbumbayi m'manja mwa aIjipito, pomwe iwo akhainyoza”. ");
INSERT INTO nyu_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Pamwepo Jetero, thebzala wa Mozeji, adatenga ntsembe yakutentha na ntsembe zinango, acipereka kwa Mulungu. Ndipo Aloni na akulu wa Ijirayeri wentse adabwera kuti adzadye na thebzala wa Mozeji, patsogolo pa Mulungu. ");
INSERT INTO nyu_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mangwana yace, Mozeji adakhala pa mpando kuti atonge mirandu ya mbumba, ndipo mbumba ikhadaima patsogolo pa Mozeji, kuyambira macibese mpaka dzuwa kumira. ");
INSERT INTO nyu_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Pomwe Jetero, thebzala wa Mozeji, adawona bzentse bzomwe iye akhacitira mbumba, adati: “Ni ciyani comwe ulikucita kuna mbumba? Thangwe ranyi iwe wekha ndiwe un'khala pakutonga, ndipo mbumba yentse in'dikhira idaima, kuyambira macibese mpaka kumira kwa dzuwa?” ");
INSERT INTO nyu_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mozeji adatawira kuti: “Mbumbayi irikundibwerera kuti ine ndibvunze Mulungu. ");
INSERT INTO nyu_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Nthawe zentse zomwe wina an'khala na mulandu, ambabweresa kuna ine ndipo ine nimbatonga pakati pawo, ndiciwapfundzisa malamulo na mitemo ya Mulungu”. ");
INSERT INTO nyu_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Tsono thebzala wa Mozeji adati: “Bzomwe ulikucita n'bzabwino lini. ");
INSERT INTO nyu_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Iwe na mbumba yako mun'dzaneta, nakuti kwa iwe basali ndikulu kwene-kwene. Ungakwanise lini kulicita iwe wekha. ");
INSERT INTO nyu_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Tsapano bvaya bzomwe nin'funa kulewa! Ine nin'dzakuyeruza, ndipo Mulungu akhale na iwe. Uimirire mbumba pamaso pa Mulungu, tenga milandu yawo uipereke kuna Mulungu. ");
INSERT INTO nyu_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Apfunzise malamulo na mitemo, uciwadziwisa kakhalidwe ndipo kuti ni ciyani comwe angacite. ");
INSERT INTO nyu_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tsono pakati pa mbumba yentseneyi sankhula amuna omwe an'kwanisa, wakugopa Mulungu, amuna wakulungama omwe ambabvuma lini kugulidwa. Uwaikhe kuti akhale atsogoleri wa culu, wa dzana, wa makumi maxanu na wa khumi. ");
INSERT INTO nyu_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Iwo an'dzatonga mirandu ya mbumba nthawe zentse. Mirandu yentse yakunesa ambabwere nayo kuna iwe. Tsono mirandu yakupusa kutonga ambaitonge okha. Bzimwebzi bzin'dzalulisa mtolo wako, thangwe iwo an'dzagawana nawe. ");
INSERT INTO nyu_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Penu iwe un'cita tenepoyo, ndipo Mulungu acikuuza tenepoyo, iwepo un'dzakwanisa kulimbika pamphicha, ndipo mbumba yentseneyi in'dzabwerera kumui na mtendere”. ");
INSERT INTO nyu_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mozeji adabvuma mafala ya thebzala wace, ndipo adacita bzentse bzomwe iye adamuuza. ");
INSERT INTO nyu_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mozeji adasankhula amuna wakukwanisa pakati pa aIjirayeri wentse, ndipo adawaikha utsogoleri: Atsogoleri wa culu, atsogoleri wa dzana, atsogoleri wa makumi maxanu na atsogoleri wa khumi. ");
INSERT INTO nyu_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ndipo iwo akhatonga mbumba nthawe yentse. Mirandu yakunesa akhayenda nayo kuna Mozeji ndipo mirandu yakupusa kutonga akhaitonga okha. ");
INSERT INTO nyu_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Pamwepo, Mozeji adagonekana na thebzala wace, ndipo Jetero adabwerera kudziko lace. ");
INSERT INTO nyu_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Pantsiku yakuyamba ya mwezi wacitatu aIjirayeri atacoka kale mudziko la Ijipito, adafika kucidambo ca Sinai. ");
INSERT INTO nyu_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Atacoka kuRefidimu, adakafika kucidambo ca Sinai, ndipo Ijirayeri adamanga m'sasa kutsogolo kwa phiri. ");
INSERT INTO nyu_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Pamwepo, Mozeji adakwira paphiri kuti agumane na Mulungu. Ndipo Mbuya ali m'phirimo adamucemera aciti: “Uza mbumba ya Jakobo, omwe ni aIjirayeri, tenepa: ");
INSERT INTO nyu_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Imwepo mudawona bzomwe ndidacita Ijipito, ndipombo momwe ndidakutakulani m'maphaphidwe ya mphungu, ndicikubweresani kuna Ine. ");
INSERT INTO nyu_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Tsapano, mungandibvera mwakukhulupirika mucikoya cipangano cangu, imwepo mun'dzakhala cuma cangu cakusankhulidwa pakati pa mbumba zentse. Napo dziko la pantsi lentse liri langu, ");
INSERT INTO nyu_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","imwepo mun'dzakhala umambo bwangu bwa azibaba wa ntsembe, ndipombo mtundu wakucena. Yamweya ndiyo mafala yakuti iwepo uuze aIjirayeri”. ");
INSERT INTO nyu_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mozeji adabwerera acicemeresa atsogoleri wa mbumba, ndipo adawafotokozera mafala yentse yomwe Mbuya adamutuma kuti akalewe. ");
INSERT INTO nyu_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Pamwepo, mbumba yentse idatawira kabodzi-na-kabodzi, idati: “Bzentse bzomwe Mbuya walewa, tin'dzacita”. Ndipo Mozeji adakafokotozera Mbuya bzomwe mbumba idalewa. ");
INSERT INTO nyu_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Mbuya adauza Mozeji kuti: “Ndirikubwera kuna iwe mumtambo uvsipa, kuti mbumba ikadzabva kulewa-lewa kwangu na iwepo, imbadzakukhulupirire nthawe zentse”. Pamwepo Mozeji adauza Mbuya bzomwe mbumba idalewa. ");
INSERT INTO nyu_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Mbuya adauza Mozeji kuti: “Ndoko kuna mbumba, ukaicenese lero na mangwana. Iwo afule bzakubvala bzawo, ");
INSERT INTO nyu_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ndipo akhale wakukondzeka pantsiku yacitatu, thangwe ntsiku imweyo Mbuya an'dzabuluka muphiri la Sinai pamaso pa mbumba yentse. ");
INSERT INTO nyu_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ikha malire mwakuzungulira phiriro, uza mbumba kuti: Khalani na cheru muleke kukwira muphiri ayai kukhuya malire yace. Ali-yentse omwe an'dzalikhuya phiriro, cadidi an'dzaphedwa. ");
INSERT INTO nyu_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Palibe omwe angadzalikhuye na manja, tsono an'dzabomedwa na minyala ayai kulasidwa na misewe. Munthu napo bzinyama, bzin'dzakhala lini na moyo. Pokha-pokha cimbututu cikadzalira kabodzi mwakupitiriza, iwo angadzakwire paphiri”. ");
INSERT INTO nyu_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mozeji atabuluka paphiri, adacenesa mbumba. Ndipo iyo idafula bzakubvala bzayene. ");
INSERT INTO nyu_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Pamwepo iye adauza mbumba kuti: “Mkuca uno, khalani wakukondzekera, ndipo kuyambira lero mpaka ntsikuyo lekani kugona pabodzi na mkazi”. ");
INSERT INTO nyu_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ndipo kumacibese mkuca wace, kudabveka kugunda na bziphaliwali, na mtambo wakusvipa udampsinkha phiriro. Kudabveka kulira mwamphambvu kwa cimbututu, ndipo mbumba yentse yomwe ikhali pamsasa idatetemera na mantha. ");
INSERT INTO nyu_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mozeji adatenga mbumba aciyenda nayo kunja kwa msasa, kuti akagumane na Mulungu, ndipo iwo adaima munyantsi mwa phiri. ");
INSERT INTO nyu_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Phiri la Sinai lentse likhadampsinkhika na utsi, nakuti Mbuya akhadabulukira patsonga ya phirilo mwa cirambirambi ca moto. M'phirimo mukhakwira utsi ninga bwa forno, ndipo phiri lentse likhatekenyeka mwakugosva, ");
INSERT INTO nyu_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ndipo muwira wa cimbututu ukhathimizirika mwamphambvu. Pamwepo Mozeji adalewa-lewa, ndipo fala la Mulungu lidamutawira mwa kugunda. ");
INSERT INTO nyu_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mbuya adabwera pantsonga ya phiri la Sinai, ndipo adacemera Mozeji pantsonga ya phiripo. Mozeji adakwira, ");
INSERT INTO nyu_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ndipo Mbuya adauza Mozeji kuti: “Buluka, ukacenjeze mbumba kuti ileke kupitirira malire kudzawona Mbuya, sabwa azinji mwa iwo angafe. ");
INSERT INTO nyu_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Napo azibaba wa ntsembe omwe an'bwera kuna Mbuya, abzicenese, akaleka Mbuya an'dzawadzonga”. ");
INSERT INTO nyu_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mozeji adauza Mbuya kuti: “Mbumba ingakwire lini paphiri la Sinai, nakuti Iwepo udaticenjezeratu, kuti: ‘Ikha malire m'mphepete mwa phiri uwadziwise kuti ni phiri lakucena’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Mbuya adamuuza kuti: “Buluka ndipo ukwire pomwe pabodzi na Aloni. Tsono azibaba wa ntsembe na mbumba aleke kupitirira malire kubwera kuna Mbuya, akaleka Mbuya an'dzawadzonga”. ");
INSERT INTO nyu_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Pamwepo Mozeji adabuluka adadziwisa mbumba. ");
INSERT INTO nyu_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ndipo Mulungu adalewa mafala yentseneya, aciti: ");
INSERT INTO nyu_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ine ndine Mbuya, Mulungu wako, omwe ndidakucosa kuIjipito mudziko la unyagirinya”. ");
INSERT INTO nyu_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Leka kukhala na mirungu inango kunja kwa Ine”. ");
INSERT INTO nyu_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Leka kubzikondzera cakuti upembe, ngakhale cifanikizo ca cinthu ciri-centse ca kudzulu, na pantsi pa dziko, ayai m'madzi ya pantsi pa dziko”. ");
INSERT INTO nyu_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Leka kubzigodamira napo kubzipemba, nakuti Ine Mbuya, Mulungu wako, ndine Mulungu wa ntsanje, omwe nimbalanga wana thangwe ra bzakuipa bza azibaba wawo kufikira m'badwe wacitatu na wacinai wa wale omwe ambandiwenga, ");
INSERT INTO nyu_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","tsono nimbacitira lufoi lakusaya kucinja kuna mibadwe culu (1,000) ca wale omwe ambandifuna ndipo ambabvera malangizo yangu. ");
INSERT INTO nyu_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Leka kuguma dzina la Mbuya Mulungu wako papezi, thangwe Mbuya an'dzaleka lini kupasa nyathwa omwe an'dzaguma dzina lace papezi”. ");
INSERT INTO nyu_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Ukumbukire ntsiku ya malinkhuma, umbaiyese yakucena”. ");
INSERT INTO nyu_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Udzaphate basa ntsiku zitanthatu ndipo udzacite basa lako muntsiku zimwezo. ");
INSERT INTO nyu_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Tsono ntsiku yacinomwe ni Sabudu yakuperekedwa kuna Mbuya, Mulungu wako. Ntsiku imweyo leka kudzaphata basa liri-lentse iwepo, mwana wako wacimuna ayai wacikazi, ngakhale nyagirinya wako wacimuna ayai wacikazi, napo cifuwo cako, ayai alendo omwe alikukhala mum'zinda mwako. ");
INSERT INTO nyu_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Pakuti muntsiku zitanthatu Mbuya adakondza kudzulu na pantsi, nyanja na bzentse bziri m'mwemo, tsono ntsiku yacinomwe adapuma. Na tenepo, Mbuya adadalisa ntsiku ya Sabudu aciicenesa. ");
INSERT INTO nyu_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Lemekeza baba wako na mai wako, kuti ntsiku zako ziwande padziko lomwe Mbuya Mulungu wako an'kukupasa”. ");
INSERT INTO nyu_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Leka kupha”. ");
INSERT INTO nyu_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Leka kucita upombo”. ");
INSERT INTO nyu_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Leka kuba”. ");
INSERT INTO nyu_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Leka kulewa umboni bwakunama kuna winango”. ");
INSERT INTO nyu_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Leka kusirira nyumba ya winango. Leka kusirira mkazi wa winango, ngakhale nyagirinya wace wacimuna ayai wacikazi, ngakhale ng'ombe yace ayai bulu wace, ngakhale cinthu ciri-centse comwe ni cace”. ");
INSERT INTO nyu_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Mbumba idabva kugunda, bziphaliwali na kulira kwa cimbututu, ndipo paphiri pakhacoka utsi. Pamwepo, wentse adadzidzimuka acimbatetemera. Adaima patali, ");
INSERT INTO nyu_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ndipo adauza Mozeji kuti: “Lewa-lewa nafe iwepo, tin'kutetekera. Tsono Mulungu mbaleke kulewa-lewa nafe, kuti tireke kufa”. ");
INSERT INTO nyu_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mozeji adatawira mbumba kuti: “Lekani kukhala na mantha! Mulungu abwera kudzakuyezani kuti mumbamugope, ndipo kuti muleke kucita citazo”. ");
INSERT INTO nyu_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Tsono mbumba idapitiriza kukhala patali, ndipo Mozeji ndiye adafendera pamtambo usvipa pomwe pakhana Mulungu. ");
INSERT INTO nyu_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Pamwepo Mbuya adauza Mozeji kuti: “Uza aIjirayeri terepa: Imwepo mwabziwonera mwekha kuti ndalewa-lewa namwe ndiri kudzulu”. ");
INSERT INTO nyu_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","“Lekani kudzakondza bzifanikizo bza parata ayai bza oro, kuti mubzitumbize pabodzi na Ine”. ");
INSERT INTO nyu_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Mundikondzere guwa la ntsembe la mataka, ndipo mundipasire ntsembe zanu zakutentha pamwepo na bzakupereka bzanu bza ciphatano, mabira yanu na ng'ombe zanu. Pambuto iri-yentse komwe ine nin'kuuzani mupembe dzina langu, nin'dzabwera kuna imwe ndipo nin'dzakudalisani”. ");
INSERT INTO nyu_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Penu mun'dzandikonzera guwa la minyala, lekani kudzalikondza na minyala yakusema, thangwe kuphatisa basa bzakukondzesa kun'dzaliipisa. ");
INSERT INTO nyu_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Lekani kudzakwira na matambiko paguwa langu, kuti pamwepo padzaleke kuwonesedwa upezi bwace. ");
INSERT INTO nyu_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Mitemo yomwe udzauze mbumba ni iyi: ");
INSERT INTO nyu_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Penu iwepo un'dzagula nyagirinya waciHeberi, iye an'dzakuphatire basa magole matanthatu. Tsono lacinomwe adzatsudzulidwe mwakusaya kulipira”. ");
INSERT INTO nyu_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Penu adabwera ali khowa, an'dzacoka ali khowa. Penu akhana mkazi, an'dzacoka na mkazi wace. ");
INSERT INTO nyu_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Penu mbuya wace animupasa mkazi, iye acibereka wana wacimuna na wacikazi, mkazi na wana an'dzakhala wa mbuyayo ndipo iye an'dzacoka yekha. ");
INSERT INTO nyu_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Tsono, penu nyagirinya anirewa kuti: ‘Ine nin'funa mbuya wangu, mkazi wangu na wana wangu, nin'funa lini kutsudzulidwa’ ”, ");
INSERT INTO nyu_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","pamwepo, mbuya wace an'dzamutenga aciyenda naye kwa atongi. An'dzamuyendesa pamsuwo ayai mbali mwa msuwoyo, ndipo mbuya wace an'dzamubowola khutu na mkuluzo. Ndipo iye an'dzakhala nyagirinya wace pa moyo wace wentse. ");
INSERT INTO nyu_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Penu munthu an'gulisa mwana wace wacikazi kuti akhale nyagirinya, iye an'dzalomboledwa lini ninga anyagirinya wacimuna”. ");
INSERT INTO nyu_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Penu iye an'kondweresa lini mbuya wace omwe adam'sankhula, mbuyayo adzamubvumize kuti alomboledwe. Aleke kudzamugulisa kwa wanthu wakudza, pakuti bzimwebzi bzingadzawonese kusaya kukhulupirika kuna iye. ");
INSERT INTO nyu_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Penu mbuya wace anim'sankhula acipasa mwana wace, adzam'pase ugo bwa mwana wacikazi. ");
INSERT INTO nyu_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Penu mbuya animulowolera mkazi waciwiri, mbaleke kupunguza phoso kwa wakuyamba ayai bzakubvala na ugo bwa m'banja. ");
INSERT INTO nyu_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Akaleka kum'citira bzinthu bzitatubzi, iye an'dzacoka mwaufulu mwakusaya kulipira. ");
INSERT INTO nyu_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Omwe an'pweteka mwandzace acifa, iye aphedwembo. ");
INSERT INTO nyu_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Tsono, penu iye alibe kubzicita utowa, koma bzacitika mwangozi, pamwepo nin'dzakulatiza mbuto yomwe angadzathawire. ");
INSERT INTO nyu_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Tsono penu wina anipha mwandzace utowa mwa njira yakumunyengeza, mucoseni ngakhale pa guwa langu caipo ndipo mupheni. ");
INSERT INTO nyu_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Omwe an'pweteka baba wace ayai mai wace, bzin'funika kuti aphedwe”. ");
INSERT INTO nyu_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ule omwe aniba munthu acikam'gulisa ayai acigumanidwa adamukoya, munthu umweyo bzin'funika kuti aphedwe”. ");
INSERT INTO nyu_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ule omwe an'temberera baba wace ayai mai wace, bzin'funika kuti aphedwe”. ");
INSERT INTO nyu_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Penu wanthu awiri animenyana, m'bodzi wa iwo acipweteka mwandzace na mwala ayai na faiti ndipo unangoyo akasaya kufa, tsono acikagona pamphasa na kuwawidwa, ");
INSERT INTO nyu_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","penu iye aniramuka acifamba mwa kuthandizidwa na mpsimbo, ule omwe am'pweteka an'dzalangidwa lini, tsono an'dzalipira nthawe yomwe iye adaluza ndipo acimbamuthandiza mpaka kulimba. ");
INSERT INTO nyu_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Penu wina an'pweteka nyagirinya wace wacimuna ayai wacikazi na muti ndipo nyagirinyayo acifa, apasidwe nyathwa”, ");
INSERT INTO nyu_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","tsono penu nyagirinya an'khala na moyo ntsiku ibodzi ayai ziwiri, an'dzapasidwa lini nyathwa, na kuwona kuti ni cuma cace. ");
INSERT INTO nyu_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Penu amuna an'menyana, acipweteka mkazi wapathupi, ndipo mkaziyo acitaya pathupi tsono pacisaya kuwoneka mphicha inango, munthu ana mulanduyo an'dzaumirizidwa kulipira comwe mwenekaciro wa mkaziyo angafune, malingana na momwe angalewere atongi wa mphala”. ");
INSERT INTO nyu_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Tsono, pacikhala kuti pawoneka mphicha inango, nyathwa yace in'dzakhala kulipira moyo na moyo, ");
INSERT INTO nyu_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","diso na diso, dzino na dzino, manja na manja, mwendo na mwendo, ");
INSERT INTO nyu_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kutenthana na kutenthana, cironda na cironda, cithuza na cithuza. ");
INSERT INTO nyu_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Penu wina an'pweteka diso la nyagirinya wace wacimuna ayai wacikazi, licisaya kuwona, bzin'funika kuti amuleke nyagirinyayo akhale mwa ufulu ninga kulipira disolo”. ");
INSERT INTO nyu_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Penu an'gulula dzino la nyagirinya wacimuna ayai wacikazi, bzin'funika kuti amuleke akhale mwa ufulu ninga kulipira dzinolo. ");
INSERT INTO nyu_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Penu ng'ombe in'suntha mwamuna ayai mkazi icimubowola na nyanga acifa, bzin'funika kuti ng'ombeyo idzabomedwe mpaka kufa, nyama yace ireke kudzadyedwa. Tsono mwenekaciro wa ng'ombeyo an'dzalangidwa lini”. ");
INSERT INTO nyu_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Tsono, penu ng'ombe ikhambasuntha ndipo mwenekaciro akhadziwisidwa tsono akhaimangirira lini, ndipo ng'ombeyo icipha mwamuna ayai mkazi, ng'ombeyo ibomedwe ndipo mwenekaciroyo aphedwembo. ");
INSERT INTO nyu_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Tsono, penu animukumbira malipiro, pamwepo alombole moyo wace na bzomwe animukumbira. ");
INSERT INTO nyu_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Nyathwa imwei in'perekedwambo pa mulandu wa ng'ombe yomwe in'suntha mwana wacimuna ayai wacikazi. ");
INSERT INTO nyu_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Penu ng'ombe in'suntha nyagirinya wacimuna ayai wacikazi, mwenekaciro wa ng'ombe alipire kobiri za n'dzayaya (30) makumi matatu za parata kwa mbuya wawo ndipo ng'ombeyo ibomedwe. ");
INSERT INTO nyu_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Penu munthu an'cera cidindi acireka cidafunguka acisaya kucigwanankhira ndipo ng'ombe ayai bulu cicigwera momwemo”, ");
INSERT INTO nyu_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mwenekaciro wa cidindico bzin'funika kuti alipire bzadzongekabzo, apereke kobiri kuna mwenekaciro wa cifuwo ndipo iye atenge cifuwo cakufaco. ");
INSERT INTO nyu_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Penu ng'ombe ya munthu in'pweteka ng'ombe ya mwandzace icifa, an'dzagulisa ng'ombe ya moyo ntsengwa yace an'dzagawana kati na kati. Ndipo ng'ombe yakufayo an'dzagawana pomwe kati na kati”. ");
INSERT INTO nyu_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Tsono, bzikadziwika kuti ng'ombeyo ikhasuntha ndipo mwenekaciro akhaimangirira lini, bzin'funika kuti alipire ng'ombe ya moyo iye acitenga yakufayo. ");
INSERT INTO nyu_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Penu munthu aniba ng'ombe ayai bira acipha ayai acigulisa, bzin'funika kuti abwezere ng'ombe zixanu pa ibodzi ndipo mabira manai pa bira m'bodzi”. ");
INSERT INTO nyu_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Penu mbava yaphatidwa irikuchola nyumba, icipwetekedwa ndipo icifa, omwe waipweteka alibe mulandu wakupha”, ");
INSERT INTO nyu_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","tsono bzimwebzi bzikacitika dzuwa latacoka, an'dzakhala na mulandu wakupha. “Bzin'funika kuti mbava ibwezere bzomwe yaba, tsono penu iribe cinthu, idzagulisidwe kuti ilipire mulandu wakubayo”. ");
INSERT INTO nyu_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Penu cakubedwaco cin'gumanidwa na moyo m'manja mwace, penu ni ng'ombe, bulu ayai bira, alipire kwakufunya kawiri. ");
INSERT INTO nyu_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Penu munthu an'tenga bzifuwo bzace acikadyesa m'munda mwa winango bzicikadya mbeu za m'mundamo, mwenekaciro wa bzifuwobzo adzalipire na phoso labwino kwene-kwene la m'munda mwace ayai na uva zabwino kwene-kwene za m'munda mwace”. ");
INSERT INTO nyu_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Penu moto uniyenderera ucikaphata miti ya minga ndipo ucitentha misumbu ya phoso lakubvunidwa ayai tirigu wakubzala ngakhale munda wentse wakutimba, ule omwe wayamba kutentha lupsa an'dzalipira bzakudzongekabzo”. ");
INSERT INTO nyu_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Penu munthu an'pasa mwandzace parata ayai bzombo kuti abzikoye ndipo bzimwebzi bzingabedwa m'nyumba mwace, mbavayo penu in'phatidwa, bzin'funika kuti ilipire kwa kufunya kawiri. ");
INSERT INTO nyu_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Tsono penu mbavayo ikasaya kuphatidwa, bzin'funika kuti mwenekaciro wa nyumba akatawire kwa atongi, kuti pawoneke penu umweyo alibe kuphata bzinthu bza mwandzaceyo. ");
INSERT INTO nyu_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Nthawe zentse zomwe munthu angakhale na cinthu cakutaika ciri-centse ninga ng'ombe, bulu, bira, ayai bzakubvala, tsono winango acirewa kuti: ‘Cinthu cimweci ni cangu’ ”, awiriwo atenge nkhaniyo ayende nayo kuna atongi wa mphala. Ule omwe atongi animuuza kuti waphonya an'dzalipira kwa kufunya kawiri kuna mwandzaceyo. ");
INSERT INTO nyu_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Penu munthu an'pasa mwandzace bulu, ng'ombe, bira ayai cifuwo cinango ciri-centse kuti akoye, ndipo cicifa, ayai cicipwetekedwa, ayai cicitengedwa mwakusaya kuwonedwa na munthu ali-yentse, ");
INSERT INTO nyu_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","pamwepo, nkhani yawo in'tongedwa mwakulumbirisa wakukoyayo patsogolo pa Mbuya kuti alibe kuphata bzinthu bza mwandzace. Bzin'funika kuti mwenekaciro abvume kulumbirako ndipo palibe cakubwezera cin'dzakumbiridwa. ");
INSERT INTO nyu_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Tsono, penu cifuwoco cidabedwadi na mwandzaceyo, bzinfunika kuti am'bwezere mwenekaciroyo. ");
INSERT INTO nyu_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Penu cidadyedwa na cirombo ca m'thengo, iye abwerese cakusalaco ninga citsimikizo. Ndipo an'dzalipira lini cakufaco. ");
INSERT INTO nyu_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Penu munthu an'kumbira cifuwo kwa mwandzace, cicipwetekedwa ayai cicifa palibe mwenekaciro, bzin'funika kuti am'bwezere”. ");
INSERT INTO nyu_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Tsono penu mwenekaciro ali pafupi, omwe adakumbirayo bzin'dzafunika lini kubwezera. Penu cifuwoco ni cakukumbiza mwa malipiro, ntsengwa ya malipiroyo in'dzafunga mulanduwo. ");
INSERT INTO nyu_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Penu munthu an'pumpsa dende lomwe likanati kubvundziridwa, acigona nalo, bzin'funika kuti alipire nthamula-msana ndipo akhaliretu mkazi wace”. ");
INSERT INTO nyu_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Tsono penu baba wace aniramba kum'pereka, napo tenepo bzin'funika kuti mwamunayo alipire mwakulingana na momwe ambalipirira madende. ");
INSERT INTO nyu_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Lekani kuleka mpfiti yacikazi na moyo”. ");
INSERT INTO nyu_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Wentse omwe an'gona na bzinyama bzin'funika kuti aphedwe”. ");
INSERT INTO nyu_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Wentse omwe an'pereka ntsembe kwa mirungu inango, acireka kupereka kwa Mbuya yekha, adzatambire cirango cakuphedwa”. ");
INSERT INTO nyu_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Lekani kutsautsa ngakhale kupundiza anyakudza, pakuti imwepo mukhali anyakudza mudziko la Ijipito”. ");
INSERT INTO nyu_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Lekani kupenyerera amasiwa ngakhale nkhungwa, ");
INSERT INTO nyu_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","thangwe mukabzicita, ndipo iwo acidandaula kuna Ine, cadidi Ine nin'dzawabvera kudandaula kwawo. ");
INSERT INTO nyu_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Nidzakalipa, nin'dzakuphani na cisenga, akazi wanu an'dzakhala amasiwa ndipo wana wanu an'dzakhala nkhungwa. ");
INSERT INTO nyu_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Mukakumbiza munthu wa mbumba yangu, wakusauka omwe an'khala pakati panu, lekani kumusunda cimbadzo, lekani kucita phindu nabzo”. ");
INSERT INTO nyu_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Penu un'tenga cakubvala ca winango ninga citsimikizo, um'bwezere dzuwa likanati kumira, ");
INSERT INTO nyu_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","thangwe cakubvalaco ni cokhaco comwe ambafunikira thupi race. Kodi an'dzafunikira ciyani pakugona? Iye angadandaula kuna Ine, Ine nin'dzamubvera, pakuti ndine wantsisi. ");
INSERT INTO nyu_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Lekani kutukwana Mulungu, ngakhale kutemberera atsogoleri wa mbumba yanu. ");
INSERT INTO nyu_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Lekani kucedwa kubweresa bzakupereka bza bzakubvuna bzanu. “Mundipase wana wanu wacimuna wakuyamba, ");
INSERT INTO nyu_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","na mwana wakuyamba wa ng'ombe, wa mabira na wa mbuzi. M'kati mwa ntsiku zinomwe mwanayo an'dzakhala na mai wace, tsono pantsiku yacisere, mum'pereke kuna Ine. ");
INSERT INTO nyu_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Imwepo mun'dzakhala mbumba yangu yakucena. Lekani kudya nyama iri-yentse yakuphedwa na bzirombo bza m'thengo, ipaseni mbwaya”. ");
INSERT INTO nyu_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Lekani kupereka umboni bwakunama, ndipo lekani kuthandiza wakuipa pakum'citira umboni bwa cakulinga cakuipa. ");
INSERT INTO nyu_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Leka kutewera mthithi pakukacita cakuipa. Pakupereka umboni bwa mulandu, leka kugonyolesa cirungamo kuti uthandize mthithi. ");
INSERT INTO nyu_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Leka kutawirira munthu pamulandu, napo wakusauka. ");
INSERT INTO nyu_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Penu iwepo uniwona ng'ombe yakutaika ayai bulu omwe ni wa nyamadulanthaka wako, tenga ukapereke kuna iye. ");
INSERT INTO nyu_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Penu iwepo uniwona bulu wa munthu omwe ambakuwenga wagwa na mtolo wace, leka kumusiya, nyang'ana kum'thandiza. ");
INSERT INTO nyu_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Leka kupotosa mulandu wa wakusauka. ");
INSERT INTO nyu_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Leka kupitira nkhani zakunamizirana ngakhale kupasa nyathwa ya impfa munthu wakusaya thangwe napo wakulungama, thangwe nin'dzapasa nyathwa kuna wakuphonya. ");
INSERT INTO nyu_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Leka kutambira bobobo, pakuti bobobo ambacitisa kuti atongi aleke kuwona cadidi, ndipo ambapundiza omwe ana cirungamo. ");
INSERT INTO nyu_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Leka kuponderera nyakudza. Imwepo mun'dziwa kuti ni ciyani kukhala nyakudza, pakuti mukhali anyakudza muIjipito. ");
INSERT INTO nyu_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Bzalani mucibvuna m'minda mwanu mkati mwa magole matanthatu, ");
INSERT INTO nyu_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","tsono mugole lacinomwe irekeni ipume mwakusaya kulimidwa. Tenepoyo wakusauka wa mbumba yanu an'dzadya bzomwe bzin'dzamera bzicikula bzokha, ndipo bzomwe bzin'dzasala bzin'dzakhala bza bzirombo bza mthengo. Citani bzibodzi-bodzi na minda ya uva ndipo na ya oliva. ");
INSERT INTO nyu_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Muntsiku zithanthatu muphate basa lanu, tsono ntsiku yacinomwe, pumani kuti ng'ombe yanu na bulu wanu bzipume, ndipo nyagirinya wanu na nyakudza akhale pomwe na mphambvu. ");
INSERT INTO nyu_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Lekani kuyebwa kucita bzentse bzomwe ndakuuzani. Lekani kucemera mirungu inango, napo kubveka madzina ya mirunguyo pamiromo panu. ");
INSERT INTO nyu_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Imwepo mumbandicitire cikondwereso katatu pa gole. ");
INSERT INTO nyu_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Mumbacite Cikondwereso ca pau zakusaya cakufufumisa, m'kati mwa ntsiku zinomwe dyani pau zakusaya cakufufumisa, ninga momwe Ine ndidakuuzani. Citani bzimwebzi panthawe idatalidwa ya mwezi wa Abibe pakuti mwezi umweyo ni omwe mudacoka kuIjipito. “Palibe omwe an'dzabwera kuna Ine cimanja-manja. ");
INSERT INTO nyu_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Mumbacite Cikondwereso cakubvuna bzisapo bzakuyamba bza basa lanu lakubzala m'minda. “Mumbacite Cikondwereso cakumaliza kubvuna pakumala kwa gole, pomwe imwepo mun'koya bzakubvunabzo m'minda. ");
INSERT INTO nyu_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Amuna wentse bzin'funika kuti ambadzawonekere kwa Mbuya Mulungu katatu pa gole. ");
INSERT INTO nyu_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Lekani kupereka mulopa wa ntsembe yangu na pau yakufufumisidwa. “Mafuta ya bzinyama ya ntsembe za bzikondwereso bzangu mbayaleke kukoyedwa mpaka mangwana yandzace. ");
INSERT INTO nyu_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Bweresani pa Nyumba ya Mbuya, Mulungu wanu, bzisapo bzakuyamba bza kubvuna kwanu. “Lekani kuphika kambuzi mum'kaka wa mai wace. ");
INSERT INTO nyu_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Onani, nin'tumiza anju patsogolo panu kuti akukhocherereni munjira yentse ndipo akufikiseni kumbuto yomwe ndakondza. ");
INSERT INTO nyu_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Khalani na cheru ndipo mubvere bzomwe anirewa. Lekani kum'pandukira, thangwe an'dzalekerera lini bzitazo bzanu, pakuti mwa anjuyo muna dzina langu. ");
INSERT INTO nyu_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Tsono imwepo mungabvesesa bzomwe iye an'dzalewa, mucidzacita bzentse bzomwe nin'kuuzani, nin'dzakhala muwengi wa awengi wanu ndipo nyamadulanthaka wa anyamadulanthaka wanu. ");
INSERT INTO nyu_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Anju wangu an'dzayenda patsogolo panu ndipo an'dzakufikisani kudziko la aAmori, la aHiti, la aFerezi, la aKenani, la aHevi, na la aJebusi ndipo Ine nin'dzawadzonga. ");
INSERT INTO nyu_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Lekani kugodamira mirungu yawo, ngakhale kuipemba, napo kutewezera bzakucita bzawo. Idzongeni yentse ndipo svani minyala ya mirungu yawo. ");
INSERT INTO nyu_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Pembani Mbuya, Mulungu wanu, ndipo Iye an'dzakudalisani acikupasani bzakudya na madzi. Nin'dzacosa matenda pakati panu. ");
INSERT INTO nyu_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Mudziko mwanu pan'dzawoneka lini mkazi omwe an'dzabala mwana wakufa, ngakhale kudzawoneka mkazi wakusaya kubala. Nin'dzakupasani ntsiku zizinji za moyo wanu. ");
INSERT INTO nyu_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Nin'dzatumiza kugosva kwangu kukulu patsogolo panu, komwe kun'dzabweresa phiringu kuna madziko yentse yomwe imwepo mun'dzagumana. Nin'dzacitisa kuti anyamadulanthaka wanu wentse adzacungunuke acithawa. ");
INSERT INTO nyu_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nin'dzabweresa phiringu pakati pa aHevi, aKenani na aHiti kuti awathothe patsogolo panu. ");
INSERT INTO nyu_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nin'dzawathotha lini pagole libodzi, pakuti dziko lingadzakhale liribe wanthu ndipo bzirombo bza mthengo bzingadzawande, bzicikugosvani. ");
INSERT INTO nyu_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ine nin'dzawathotha pang'ono-pang'ono mpaka imwe muwande kufikira mudzatenge dziko. ");
INSERT INTO nyu_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Nin'dzaikha malire ya dziko lanu kuyambira kuNyandza Ifuira mpaka kunyandza ya aFilisti, ndipo kuyambira kucidambo mpaka kumkulo wa Eufarate, nin'dzapereka m'manja mwanu mbumba zomwe zimbakhala mudziko, zomwe imwepo mun'dzathotha patsogolo panu. ");
INSERT INTO nyu_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Lekani kucita cipangano nawo ngakhale na mirungu yawo. ");
INSERT INTO nyu_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Lekani kulekerera mbumbayo kuti ikhale mudziko mwanu, kuti ireke kudzakuphonyesani kwa Ine, nakuti kupemba mirungu kwawo kun'dzakhala diwa kuna imwe”. ");
INSERT INTO nyu_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Patsogolo pace Mulungu adauza Mozeji kuti: “Kwirani paphiri kuti mugumane na Mbuya, iwepo na Aloni, Nadabe na Abihu, na makumi manomwe ya akulu-akulu wa Ijirayeri. Mupembe na patali. ");
INSERT INTO nyu_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mozeji yekha ndiye an'dzafendera kuna Mbuya, anango nee. Ndipo mbumba ireke kukwira na iye”. ");
INSERT INTO nyu_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Pomwe Mozeji adayenda kuna mbumba acikaifokotozera mafala yentseneyo na mitemo ya Mbuya, iwo adatawira pabodzi kuti: “Tin'dzacita bzentse bzomwe Mbuya walewa”. ");
INSERT INTO nyu_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Pamwepo, Mozeji adanemba bzentse bzomwe Mbuya adamuuza. Mangwana yace macibese-bese Mozeji adalamuka acikondza guwa munyantsi mwa phiri ndipo adaimisa minyala khumi na miwiri, mwakuteweza madzindza khumi na mawiri ya Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Patsogolo pace adatumiza masvaka ya aIjirayeri, ndipo iwo adapereka ntsembe zakutentha na tumikono kuti tukhale ntsembe za ciphatano na Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mozeji adagawa mulopa adatenga cipande cibodzi aciikha mutumbale ndipo cipande cinango adawazira paguwa. ");
INSERT INTO nyu_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Patsogolo pace adatenga Livu la Cipangano acirilewenga kuna mbumba, ndipo iyo idati: “Bzentse bzomwe Mbuya walewa tin'dzacita ndipo tin'dzabvera”. ");
INSERT INTO nyu_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Pamwepo, Mozeji adawazira mulopa mbumba, aciti: “Uyu ni mulopa wa cipangano comwe Mbuya wacita na imwepo malingana na mafala yentseneya”. ");
INSERT INTO nyu_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mozeji, Aloni, Nadabe, Abihu na makumi manomwe (70) ya akulu-akulu wa Ijirayeri adakwira, ");
INSERT INTO nyu_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ndipo adawona Mulungu wa Ijirayeri, omwe pantsi pa ndzayo zace pakhana cinthu cakulingana na mseu cakukondzedwa na mwala wa safira, kuyetima kwacene ninga kudzulu. ");
INSERT INTO nyu_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Mulungu alibe kufuthula boko kuti apase nyathwa atsogoleri wa mbumba ya Ijirayeri. Iwo adawona Mulungu ndipo adadya acimwa. ");
INSERT INTO nyu_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Mbuya adauza Mozeji kuti: “Kwira phiri, bwera kuna Ine ubakakhale pano. Ndipo nin'dzakupasa matabwa ya minyala ya Mtemo na malamulo yomwe ndanemba kuti yapfundzise mbumba”. ");
INSERT INTO nyu_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mozeji adacoka na Jozuwe, mthandizi wace, ndipo adakwira paphiri la Mulungu. ");
INSERT INTO nyu_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Iye adauza akulu-akulu wa Ijirayeri kuti: “Tidikhireni pano mpaka kubwerera kwathu. Aloni na Huri an'dzasala na imwepo. Omwe angakhale na mulandu wakuti utongedwe, adzayende kuna iwo”. ");
INSERT INTO nyu_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Pomwe Mozeji adakwira, mtambo udampsinkha phiri, ");
INSERT INTO nyu_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ndipo ukulu bwa Mbuya budakhala paphiri la Sinai m'kati mwa ntsiku zitanthatu ndipo mtamboyo udampsinkha phiri. Ntsiku yacinomwe Mbuya adacemera Mozeji m'kati mwa mtambomo. ");
INSERT INTO nyu_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Pamaso pa aIjirayeri ukulu bwa Mbuya bukhawoneka ninga moto wakungundumuka pantsonga pa phiri. ");
INSERT INTO nyu_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mozeji adapita mum'tambo acimbakwira muphiri. Ndipo m'phirimo adakhala ntsiku makumi manai (40) masikati na usiku. ");
INSERT INTO nyu_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mbuya adauza Mozeji kuti: ");
INSERT INTO nyu_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Uza aIjirayeri andibweresere cakupereka. Utambire kwa wentse omwe ana m'tima wakufuna kupereka”. ");
INSERT INTO nyu_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Bzakupereka bzomwe un'tambira kuna iwo ni ibzi: Oro, parata na burondze, ");
INSERT INTO nyu_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","usalu bwa nguwo ya azuli, roxo na ifuira, nguwo yabwino, ukuse bwa mbuzi, ");
INSERT INTO nyu_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","makhanda ya bvululume yakupalangidwa mtoto ufuira, ndipo makhanda yakufewa na matabwa ya muti wa akasiya, ");
INSERT INTO nyu_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mafuta ya ciphani-phani, bzakununchira bza mafuta ya kudzozera na bza ntsembe yakununchira, ");
INSERT INTO nyu_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","minyala ya onikisi na minyala inango yakufunikira, kuti uikwatikidze pa cakubvala ca wantsembe na pa capacifuwa. ");
INSERT INTO nyu_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Ndipo andikondzere nyumba yakucena, kuti Ine ndidzakhale pakati pawo”. ");
INSERT INTO nyu_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Acite bzentse ninga momwe Ine nin'dzakuwonesa, malinge na citsandzo ca nyumba na bzakuphatisira basa bzace. ");
INSERT INTO nyu_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Kondza kaxa la muti wa akasiya ya metro ibodzi na sentimetru khumi (1.1 m) muutali mwace, sentimetru makumi manomwe (70 cm) muufupi mwace, ndipo sentimetru makumi manomwe (70 cm) kutalimpha kwace”. ");
INSERT INTO nyu_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Lipalangire oro caiyo, mkati na kunja ndipo kondza mthemba wa oro m'mphepete mwace. ");
INSERT INTO nyu_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ulikondzere aligola zinai za oro ndipo uyakhomerere mumbali zinai za minyendo ya kaxaro, mbali ibodzi ukhomerere aligola ziwiri mbali inangoyo ziwiri pomwe. ");
INSERT INTO nyu_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Patsogolo pace kondza tumitanda twa matabwa ya muti wa akasiya, utupalangire oro, ");
INSERT INTO nyu_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ndipo utupitise mkati mwa aligola za m'mphepete mwa kaxa kuti likwanise kunyamulika. ");
INSERT INTO nyu_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Tumitandato tun'dzapitiriza kukhala mu aligola mwa kaxa, mbatuleke kudzacosedwa. ");
INSERT INTO nyu_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ndipo mkati mwa kaxa ikha matabwa ya Cipangano yomwe nin'dzakupasa. ");
INSERT INTO nyu_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Kondza cakugwanankhirira ca cakutetererera ca oro caiyo, ca metru ibodzi (1) na sentimetru khumi za muutali mwace na sentimetru makumi manomwe (70) muufupi mwace, ");
INSERT INTO nyu_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","na makerubi mawiri ya oro yakumenyedwa na nyundo, m'mphepete mwa cakugwanankhiriraco. ");
INSERT INTO nyu_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Kondza kerubi ibodzi m'mphepete mwace ndipo ukondze yaciwiri kumphepete inangoyo, cimphatane cicikhala citsulo cibodzi na cakugwanankhirira cire. ");
INSERT INTO nyu_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Makerubi bzin'funika kuti yakhale na maphaphidwe yace yakutambalasidwa kudzulu, yacimpsinkha cakugwanankhiriraco. Yadzanyang'anisane, nkhope zayene zicitsulima kunyang'ana pa cakugwanankhirirapo. ");
INSERT INTO nyu_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ikha cakugwanankhiriraco pa kaxa, ndipo mkati mwace ikha matabwa ya Cipangano yomwe nin'dzakupasa. ");
INSERT INTO nyu_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Padzulu pa cakugwanankhirirapo pakati pa makerubi yomwe yali pa dzulu pa kaxa ya Cipangano, Ine nin'dzagumana nawe ndipo nin'dzakupasa malangizo yangu yentse ya aIjirayeri. ");
INSERT INTO nyu_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Kondza meza ya matabwa ya muti wa akasiya ya sentimetru makumi mapfemba (90) muutali mwace, sentimetru makumi manai na maxanu (45) muufupi mwace ndipo sentimetru makumi manomwe (70) muutali mwace”. ");
INSERT INTO nyu_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Uipalangire oro caiyo ndipo kondza mthemba wa oro m'mphepete mwace. ");
INSERT INTO nyu_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Kondzambo mkokoto m'mphepete mwace, kukula kwa muufupi kukhale kwa sentimetru zinomwe (7) ndipo na mthemba wa oro pa mkokotopo. ");
INSERT INTO nyu_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ndipombo ukondze aligola zinai (4) za oro pa meza ndipo uzikhomerere mumagonyo yace manai (4) momwe muna minyendo yace minai (4). ");
INSERT INTO nyu_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Aligola zin'funika kuti zikhale zakukhomereredwa pafupi na mkokoto kuti ziphate tumitanda tomwe tun'phatisidwa basa pakunyamula meza. ");
INSERT INTO nyu_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Kondza tumitanda twa matabwa ya muti wa akasiya, utupalangire oro. Na tumitandato an'dzanyamulisa meza. ");
INSERT INTO nyu_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Kondza mbale zako za oro caiyo na combo cakuphatisira basa ntsembe zakununchira, tumbale twace na mwakusambira m'manja momwe mumbathululira bzakupereka bza cakumwa. ");
INSERT INTO nyu_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ikha pau zakuperekedwa kuna Mulungu mwakusaya kulekeza pa dzulu pa meza kuti zikhale patsogolo pangu nthawe zentse. ");
INSERT INTO nyu_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Kondza cakukhazikira bziphani-phani bza oro caiyo, yakusulidwa na nyundo. Mwendo wace, tsinde lace, bzakumwera bzace, maluwa yace na mabutau ya bziphani-phani ciphatane pabodzi kuti cikhale citsulo cibodzi”. ");
INSERT INTO nyu_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Maboko matanthatu yan'dzacoka kuciphani-phani: Matatu (3) mbali ibodzi, matatu (3) mbali inango. ");
INSERT INTO nyu_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Pan'dzakhala na bzakumwera bzitatu (3) bzakukhala ninga maluwa ya muti wa amendowa pa boko libodzi, ndipo cibodzi na cibodzi cina butau na dziluwa, ndipo bzakumwera bzitatu (3) bzakukhala ninga dziluwa la muti wa amendowa pa boko lina, libodzi na libodzi lina butau na dziluwa. Tenepoyo bzin'dzakhala kwa maboko matanthatuyo (6) yomwe yan'coka kuciphani-phani. ");
INSERT INTO nyu_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Pa tsinde la cakukhazikira ciphani-phani pan'dzakhala bzakumwera bzinai (4) bzakulingana na maluwa ya muti wa amendowa, cibodzi na cibodzi cina butau na dziluwa. ");
INSERT INTO nyu_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Kuntsi kwa mbali ziwiri za maboko matanthatu (6) yomwe yan'cokera kuciphaniphani, kun'dzakhala butau. ");
INSERT INTO nyu_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Maboko na mabutau yace yan'dzaphatana yacikhala citsulo cibodzi na cakukhazikira ciphaniphani, ndipo bzentse bzikondzedwe na oro caiyo yakusulidwa na nyundo. ");
INSERT INTO nyu_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Kondza pomwe bziphaniphani bzinomwe (7) ndipo ubziikhe pa cakukhazikiraco kuti bzibvunike patsogolo pace”. ");
INSERT INTO nyu_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Bzakuphatisira bzace na bzakuthimira bzace, bzidzakhale bza oro caiyo. ");
INSERT INTO nyu_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Kondza cakukhazikira ciphaniphani na bzakuphatisira basa bzentsenebzi, na kiru makumi matatu na zixanu (35) za oro caiyo. ");
INSERT INTO nyu_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Khala na cheru la kukondza bzimwebzo malinge na momwe udalatizidwa paphiri. ");
INSERT INTO nyu_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Manga Cikumbi ca Mipembo na makorotina khumi ya nguwo yabwino yakupakasa ndipo ya usalu bwa nguwo ya azuli, ya roxo na ifuira, ndipo usone bordado za makerubi pa makorotinayo”. ");
INSERT INTO nyu_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Makorotina yentse yan'dzakhale na mphimo ibodzi-bodzi: Metro khumi na ziwiri na sentimetru makumi matanthatu (12.60 m) ya muutali mwace, ndipo na metro ibodzi na sentimetru makumi masere (1.80 m) ya muufupi. ");
INSERT INTO nyu_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Phatanidzani makorotina maxanu libodzi na lindzace, ndipo cita bzibodzi-bodzi na yanango maxanuyo. ");
INSERT INTO nyu_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Kondza magango ya nguwo ya azuli mumbali mwa bordado ya korotina mwakumalizira mwa maxanu yakuyambayo, maxanu yaciwiriyo udzacite bzibodzi-bodzi. ");
INSERT INTO nyu_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Kondza magango makumi maxanu (50) pa korotina lakumalizira la maxanu yakuyamba yale ndipo magango makumi maxanu (50) pa korotina lakuyamba la maxanu yaciwiri yale, mwakuti magango yakhale mwakunyang'anisana lina na lindzace. ");
INSERT INTO nyu_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Kondza pomwe kolocete makumi maxanu (50) za oro zomwe un'dzamangirira nazo makorotina maxanu yakuyamba libodzi na lindzace, kuti Cikumbi ca Mipembo cikhale cibodzi cokha. ");
INSERT INTO nyu_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Kondza makorotina khumi na libodzi (11) ya ukuse bwa mbuzi kuti yakhale cakusvimphirisa Cikumbi ca Mipembo”. ");
INSERT INTO nyu_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Makorotina khumi na libodzi (11) yakhale na mphimo ibodzi-bodzi: Metru khumi na zitatu na ina-pakati (13.5 m) muutali mwace, ndipo metru ibodzi na sentimetru makumi masere (1.80 m) muufupi mwace. ");
INSERT INTO nyu_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Mangirira mbali ibodzi makorotina maxanu na manangombo matanthatu ku mbali inango. Funya korotina yacitanthatu patsogolo pa Cikumbi ca Mipembo. ");
INSERT INTO nyu_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kondza magango makumi maxanu (50) m'mphepete mwa bordado la korotina la kumalizira pa maxanu yale yakuyamba, ndipombo m'mphepete mwa bordado la korotina lakuyamba la matanthatu yakumalizira yale. ");
INSERT INTO nyu_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Patsogolo pace kondza kolocete za burondze makumi maxanu (50) ndipo ziikhe mumagango kuti ziphatane zikhale cakusvimphirisa cibodzi cokha. ");
INSERT INTO nyu_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Mbali ya makorotina yomwe yan'sala pa cakusvimphirisa, ina-pakati ya korotina yomwe in'sala idzakhale yakumanikidwa kumbali yakumbuyo kwa Cikumbi ca Mipembo. ");
INSERT INTO nyu_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Makorotina khumi (10) yadzakhale ya sentimetru makumi manai na maxanu (45) kupitiriza kutalimpha kwa mbali ibodzi na ibodzi ndipo bzomwe bzin'sala bzin'manikidwe mumbali ziwiri za Cikumbi ca Mipembo kuti bzisvimphire Cikumbico. ");
INSERT INTO nyu_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ukondzerembo cakusvimphirisa ca khanda la bvululume lakupalangidwa m'toto ufuira, ndipo padzaulu pace cakusvimphirisa ca khanda lakufewa. ");
INSERT INTO nyu_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Kondzera Cikumbi ca Mipembo matabwa yakuimisa ya muti wa akasiya”. ");
INSERT INTO nyu_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Tabwa ibodzi na ibodzi ikhale na metru zinai na ina-pakati (4.5 m) mukutalimpha na sentimetru makumi manomwe (70) muufupi, ");
INSERT INTO nyu_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","na bzakulumikidzira bziwiri kuti bziphatanidze matabwa. Matabwa yentseneyo ya Cikumbi ca Mipembo yakondzedwe tenepo. ");
INSERT INTO nyu_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kondza matabwa makumi mawiri (20) mbali ya kunyantsi kwa Cikumbi ca Mipembo, ");
INSERT INTO nyu_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ndipo na matsinde ya parata makumi manai (40) pantsi pa matabwayo. Matsinde mawiri (2) pa tabwa ibodzi, pantsi pa cakulumikidzira cibodzi na cibodzi. ");
INSERT INTO nyu_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Mbali inangoyo ya kucitunthu kwa Cikumbi ca Mipembo, kondza matabwa makumi mawiri (20), ");
INSERT INTO nyu_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","na matsinde ya parata makumi manai (40), pantsi pa tabwa ibodzi na ibodzi matsinde mawiri (2). ");
INSERT INTO nyu_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kondza matabwa matanthatu (6) kumbuyo kwa Cikumbi ca Mipembo mbali ya kumadokero, ");
INSERT INTO nyu_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","na matabwa mawiri (2) kumbali ya kumbuyo m'magonyo. ");
INSERT INTO nyu_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Matabwa mawiriyo (2) ya m'magonyo yadzakhale yakufunya kawiri (2), kuyambira m'nyantsi kufikira m'dzulu, yaciikhidwa m'mphete ibodzi, mawiriyo yan'dzakhala tenepoyo. ");
INSERT INTO nyu_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Na tenepo, pan'dzakhala matabwa masere (8) na matsinde ya parata khumi na matanthatu (16), pantsi pa tabwa ibodzi na ibodzi matsinde mawiri (2). ");
INSERT INTO nyu_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Kondza pomwe mitanda ya muti wa akasiya. Mitanda mixanu (5) pa matabwa ya kumbali ibodzi ya Cikumbi ca Mipembo”, ");
INSERT INTO nyu_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","maxanu kumbali inango, maxanu kumbali ya kumadokero, kumbali ya kumbuyo kwa Cikumbi ca Mipembo. ");
INSERT INTO nyu_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","M'tanda wa pakati utandalikidwe pakati pa matabwa phampha na phampha. ");
INSERT INTO nyu_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Matabwayo uyapalangire oro ndipo kondza mphete za oro kuti zirimbise mitanda, yomwe bzin'funika kuti ipalangidwembo oro. ");
INSERT INTO nyu_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Manga Cikumbi ca Mipembo ninga momwe ndidakuwonesera pa phiri”. ");
INSERT INTO nyu_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Kondza cakuchinjiridzira ca nguwo yabwino yakulukidwa na usalu bwa nguwo ya azul, roxo na ifuira, ndipo usone bordado ya makerubi pa cakuchinjiridziraco”. ");
INSERT INTO nyu_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Manika cakuchinjiridzira na ngoloweko za oro mumbiru zinai (4) za muti wa akasiya zakupalangidwa oro ndipo ziciikhidwa pa matsinde ya parata manai (4). ");
INSERT INTO nyu_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Cakuchinjiridziraco ucimanike na ngoloweko ndipo ikha Bokosi la Cipangano m'mbuyo mwace. Cakuchinjiridziraco cin'dzagawa Mbuto Yakucena na Mbuto Yakucena kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ikha cakugwanankhirira pa kaxa ya Cipangano pa Mbuto Yakucena kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ikha meza pa mbali ya kunja kwa cakuchinjiridzira, cipande ca kucitunthu kwa Cikumbi ca Mipembo na cakukhazikira ciphani-phani patsogolo pace kumbali ya kunyantsi. ");
INSERT INTO nyu_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Pakupitira pa Cikumbi ca Mipemboco kondza korotina ya nguwo yabwino yakulukidwa na usalu bwa nguwo ya azul, roxo na ifuira, basa la nyakuluka”. ");
INSERT INTO nyu_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Kondza ngoloweko za oro za korotinayo na mbiru zixanu (5) za muti wa akasiya zakupalangidwa oro. Uzisungunusire matsinde ya burondze maxanu (5). ");
INSERT INTO nyu_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Kondza guwa la ntsembe la muti wa akasiya. Likhale la magonyo manai (4) la metru ziwiri na sentimetru makumi mawiri na zixanu (2.25 m) muufupi na metru ibodzi na sentimetru makumi matatu na zixanu (1.35 m) mukutalimpha. ");
INSERT INTO nyu_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Kondza cinthu cakulingana na nyanga pa gonyo libodzi na libodzi la mbali zinaizo, kuti cikhale cinthu cibodzi na guwa lomwe lin'dzapalangidwa na burondze. ");
INSERT INTO nyu_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kondzambo na burondze bzakuphatisira basa bzace bzentse: Bzombo bza kutaira dotha, foxolo, mabasiya, magalufo yakutengera nyama na bzakuphatira masimbe. ");
INSERT INTO nyu_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ukondzerembo cakuwochera ca burondze ninga sefa na aligola za burondze pa mbali zinai za cakuwocheraco. ");
INSERT INTO nyu_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Uikhe sefayo mkati mwa buli la guwa, kuti ifike kati na kati ya guwalo mukutalimpha. ");
INSERT INTO nyu_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Kondzera guwa mpsimbo za muti wa akasiya, ndipo uzipalangire na burondze. ");
INSERT INTO nyu_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Mpsimbo zimwezi zin'dzaikhidwa mu aligola za mbali ziwiri (2) za guwa, pomwe limweri lin'dzanyamulidwa. ");
INSERT INTO nyu_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kondza guwa lina mphako ndipo la matabwa, ninga momwe udawonesedwa pa phiri”. ");
INSERT INTO nyu_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Kondza cim'talo ca Cikumbi ca Mipembo. Kumbali ya kunyantsi likhale na metru makumi manai na zixanu (45) muutali mwace, ndipo cim'taloco cikhale na makorotina ya nguwo yabwino yakulukidwa, ");
INSERT INTO nyu_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","na mbiru makumi mawiri (20) na matsinde makumi mawiri (20) ya burondze, na ngoloweko ndipo maligadula ya parata mumbiruzo. ");
INSERT INTO nyu_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Mbali ya kucitunthu kun'dzakhalambo na metru makumi manai na zixanu (45) muutali, kucikhala na makorotina na mbiru makumi mawiri (20) na matsinde makumi mawiri (20) ya burondze, na ngoloweko na maligadula ya parata mumbiruzo”. ");
INSERT INTO nyu_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Mbali ya kumadokero na makorotina yace, zikhale na metru makumi mawiri na ziwiri na ina-pakati (22.5 m) muufupi, na mbiru khumi (10) na matsinde khumi (10)”. ");
INSERT INTO nyu_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Mbali ya kumabvadzuwa, komwe ni kumacenero, kun'dzakhalambo na metru makumi mawiri na ziwiri na ina-pakati (22.5 m) muufupi. ");
INSERT INTO nyu_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Pan'dzakhala makorotina ya metru zitanthatu na sentimetru makumi manomwe na zixanu (6.75 m) muutali mwace kumbali ibodzi ya kupitira, na mbiru zitatu (3) na matsinde matatu (3), ");
INSERT INTO nyu_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ndipo kumbali inangoyo makorotina ya metru zitanthatu na sentimetru makumi manomwe na zixanu (6.75 m) ya muutali mwace na mbiru zitatu (3) na matsinde matatu (3). ");
INSERT INTO nyu_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Pakupitira cimtalo pakhale korotina la metru zipfemba (9) muutali la nguwo yabwino yakulukidwa ndipo la usalu bwa nguwo ya azul, roxo na ifuira basa la nyakuluka, na mbiru zinai (4) na matsinde manai (4)”. ");
INSERT INTO nyu_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Mbiru zentse zakuzungulira bwalo zikhale na maligadula, ngoloweko za parata na matsinde ya burondze. ");
INSERT INTO nyu_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Cim'talo cidzakhale na metru makumi manai na zixanu (45) muutali, ndipo metru makumi mawiri na ziwiri na ina-pakati (22.5 m) muufupi, na nguwo yabwino yakulukidwa ya metru ziwiri na sentimetru makumi mawiri na zixanu (2.25 m) kutalimpha na matsinde ya burondze. ");
INSERT INTO nyu_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Bzombo bzentse bza basa la Cikumbi ca Mipembo, na kuphatikidza bzakukhomera bzentse bza Cikumbico pabodzi na bza cimtalo, bzidzakondzedwe na burondze. ");
INSERT INTO nyu_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Uza aIjirayeri kuti abwerese azeite caiyo ya oliva yakusikinya yakugasira ciphani-phani, kuti bziphani-phani bzimbakhale bzidagaka”. ");
INSERT INTO nyu_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","MuCikumbi ca Kugumanira, mbali ya kunja kwa cakuchinjiridzira comwe ciri patsogolo pa matabwa ya Cipangano, Aloni na wana wace wacimuna, apitirize kugasa bziphani-phani patsogolo pa Mbuya, kuyambira kukadoka mpaka macibese. Umweyu un'dzakhala Mtemo wakusaya kumala kwa m'badwe na m'badwe pakati pa aIjirayeri. ");
INSERT INTO nyu_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Cemera m'bale wako Aloni ndipo umupambule pakati pa aIjirayeri, ndipombo wana wace Nadabe, Abihu, Eleyazari na Itamari kuti anditumikire ninga azibaba wa ntsembe”. ");
INSERT INTO nyu_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Kwa m'bale wako Aloni, musonere bzakubvala bzakucenesedwa kuti bzimupase mbiri na kulemekezedwa. ");
INSERT INTO nyu_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Uza amuna wentse wakukwanisa omwe ndidapasa luso kuti asone bzakubvala bzakucenesedwa kwa Aloni kuti anditumikire ninga wantsembe. ");
INSERT INTO nyu_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Bzakubvala bzomwe mudzasone ni ibzi: Capacifuwa, koleti ya wantsembe, manto, batina lakulukidwa, tulubante na mceka. Kuti wantsembe Aloni na wana wace anditumikire ninga azibaba wa ntsembe, iwo adzasone bzakubvala bzimwebzi bzakucenesedwa. ");
INSERT INTO nyu_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ndipo mudzaphatise basa nguwo yabwino, usalu bwa oro na usalu bwa nguwo azul, roxo na ifuira. ");
INSERT INTO nyu_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Sona koleti ya wantsembe ya nguwo yabwino yakulukidwa, ya usalu bwa oro na usalu bwa nguwo za azul, roxo na ifuira, basa la waluso”. ");
INSERT INTO nyu_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Idzakhale na tumiceka tuwiri (2) m'mapewa twakusonerera mbali ziwiri (2) za m'mphepete kuti zirumikidzidwe bwino. ");
INSERT INTO nyu_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Mceka na koleti bzomwe bzidalumikidza na iyo bzidzakondzedwe na cibodzico. Mcekambo ukhale wa nguwo yabwino yakuluka, wa usalu bwa oro na usalu bwa nguwo za azul, ya roxo na ifuira. ");
INSERT INTO nyu_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Pa minyala miwiri (2) ya onikisi unembe madzina ya aIjirayeri”, ");
INSERT INTO nyu_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","pa ndandanda mwa kubadwa kwawo. Madzina matanthatu (6) pa mwala ubodzi ndipo matanthatu (6) pa winangoyo. ");
INSERT INTO nyu_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Nemba madzina ya wana wa aIjirayeri pa minyala miwiriyo (2) ngati misiri wakunemba selo. Patsogolo pace uiphatanidze pabzakulumikidzira bza oro. ");
INSERT INTO nyu_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Uisonerere m'mapewa ya koleti ya wantsembe, ninga minyala ya cikumbuso kuna aIjirayeri. Tenepo Aloni an'dzanyamula madzinayo m'mapewa mwace ninga cikumbuso patsogolo pa Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Kondza bzakulumikidza bza oro ");
INSERT INTO nyu_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na maunyolo mawiri (2) ya oro caiyo, yakupakasa ninga cingwe, ndipo mangirira maunyoloyo kubzakulumikidzira. ");
INSERT INTO nyu_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Kondza capacifuwa ca pakutonga, basa la waluso. Kondza ninga koleti ya wantsembe, ya nguwo yabwino yakuluka, usalu bwa oro na usalu bwa nguwo za azul, roxo na ifuira”. ");
INSERT INTO nyu_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Cikhale ca magonyo manai (4), ca cithatha cibodzi (1) m'mbali zentse, ndipo cakufunya kawiri (2). ");
INSERT INTO nyu_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Patsogolo pace, ndandamisa mifolo minai (4) ya minyala yakufunika. Pa mfolo wakuyamba pakhale rubi ibodzi, topazi ibodzi na berilo ibodzi, ");
INSERT INTO nyu_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","mfolo waciwiri (2) ukhale wa Jemerada, safira na diyamante, ");
INSERT INTO nyu_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","mfolo wacitatu (3) ukhale wa jasinto, agate na ametista, ");
INSERT INTO nyu_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","mfolo wacinai (4) ukhale wa kirizolito, onikisi na jasipe, iyoyo idzakhale yakukhaliridwa na oro mu ngoloweko zace. ");
INSERT INTO nyu_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Idzakhale minyala khumi na miwiri (12) ubodzi pa dzina libodzi na libodzi la aIjirayeri, ubodzi na ubodzi udzanembedwe ninga selo, na dzina libodzi la madzindza khumi na mawiri (12). ");
INSERT INTO nyu_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ukondze kwa capacifuwa tumaunyolo twa oro caiyo twakuluka ninga bzingwe”. ");
INSERT INTO nyu_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kondza pomwe mphete ziwiri (2) za oro ndipo uzilumikidze m'mphepete ziwiri (2) za capacifuwa. ");
INSERT INTO nyu_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Manga tumaunyolo tuwiri (2) twa oro mumphete za m'mphepete mwa capacifuwa. ");
INSERT INTO nyu_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ndipo mphepete munango mwa tumaunyolo umange bzakulumikidza bziwiri (2), mphatanidza m'mapewa mwa koleti ya wantsembe kucipande ca kutsogolo. ");
INSERT INTO nyu_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Kondza mphete zinango ziwiri (2) za oro ndipo uzimangiridze m'mphepete ziwiri (2) zinangozo za capacifuwa, pa cakulukidwa ca mkati, pafupi pa koleti ya wantsembe. ");
INSERT INTO nyu_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Kondza pomwe mphete ziwiri (2) za oro ndipo uzimangiridze kumbali ya mkati mwa m'mapewa, kutsogolo kwa koleti ya wantsembe, pafupi na mkawo, padzulu pa mceka wa koleti ya wantsembe. ");
INSERT INTO nyu_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Mphete za capacifuwa zidzamangiridzidwe kumphete za koleti na cingwe ca azul, mwakulumikidzana na capacifuwa kumceka, kuti cisaye kulekerana na koleti ya wantsembe. ");
INSERT INTO nyu_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Nthawe yentse yomwe Aloni an'pita pa Mbuto Yakucena, adzatenge madzina ya aIjirayeri pamtima mwa capacifuwa ca pakutonga, ninga cikumbuso cakusaya kumala patsogolo pa Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ikhambo Urimu na Tumimu mucapacifuwa ca pakutonga, kuti bzikhale pamtima pa Aloni nthawe zentse pomwe iye an'pita patsogolo pa Mbuya. Tenepoyo, Aloni nthawe zentse pomwe an'ndzayenda patsogolo pa Mbuya an'ndzakhala na bzinthu pacifuwa bza kudzathandiza nazo Ijirayeri pakutonga. ");
INSERT INTO nyu_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Kondza manto ya koleti ya wantsembe na usalu bwa azul basi”, ");
INSERT INTO nyu_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","pakati pa mantoyo siya buli lakupita msolo. Mwakuzungulira mwace mudzakhale nguwo yakufunya ninga gola kuti lireke kung'ambika. ");
INSERT INTO nyu_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Kondza bordado zakulingana na bzisapo bza roma za usalu bwa nguwo ya azul, roxo na bufuira m'mphepete mwakulukidwa mwa mantoyo, ndipo na mabhero ya oro mwakutewerana. ");
INSERT INTO nyu_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Mabhero ya oro na bordadozo bzidzapitanisidwe mumphepete mwa mantoyo. ");
INSERT INTO nyu_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aloni an'dzabvala manto pomwe an'dzatumikira. Muwira wa tumabero un'dzabveka pomwe iye an'dzapita pa Mbuto Yakucena patsogolo pa Mbuya na pomwe an'dzacoka, kuti aleke kufa. ");
INSERT INTO nyu_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Ukondze diyadema ya oro caiyo, ndipo uinembe ninga kunembedwa kwa cidhindo kuti: Cakupambulidwa ca Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Uimangirire kumbali yakutsogolo kwa turbante na cingwe ca azul. ");
INSERT INTO nyu_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ndipo in'dzakhala pam'kuma pa Aloni, tenepoyo iye an'dzatenga mulandu wa kutaza kuli-kwentse komwe aIjirayeri adacita kuna bzinthu bzakucenesedwa, pomwe adacita bzakupereka bzawo bzentse. In'dzakhala pam'kuma pa Aloni nthawe zentse, kuti bzakupereka bzidzatambiridwe na Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Pakasa batina na turbante ya nguwo yabwino, mceka udzakondzedwe na nyakuluka”. ");
INSERT INTO nyu_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Wana wa Aloni uwakondzerembo mabatina, miceka na bzapeu, kuti bziwapasise mbiri na kulemekezedwa. ");
INSERT INTO nyu_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ukadzamala kubvazika m'bale wako Aloni na wana wace, uwadzoze ndipo uwapambule kuti akhale azibaba wa ntsembe wakunditumikira. ");
INSERT INTO nyu_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Uwakondzerembo makabudula ya nguwo yakucokera mciuno mpaka mchafu, kuti abise upezi bwawo. ");
INSERT INTO nyu_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aloni na wana wace bzin'funika kuti ambadzabvale nthawe zentse zomwe an'dzapita muCikumbi ca Kugumanirana ayai pomwe an'dzafendera pafupi na guwa kuti aphate basa pa Mbuto Yakucena, kuti aleke kukhala na thangwe acifa”. Uyu ni Mtemo wakusaya kumala kuna Aloni na kwa bzizukulu bzace. ");
INSERT INTO nyu_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Iwepo pakudzapambula Aloni na wana wace kuti adzanditumikire ninga azibaba wa ntsembe udzacite terepa: Udzatenge kamkono kabodzi na mabira mawiri bzakusaya kupunduka. ");
INSERT INTO nyu_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Tenga ufa bwa tirigu bwabwino bwakusaya cakufufumisa, ukondze pau na mabolo bzakumunyidwa na azeite, na pau zakusaya nchinya, zakupalangiridwa azeite. ");
INSERT INTO nyu_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ubziikhe mucitundu, ndipo ubzibwerese mucitundumo. Ubweresembo kamkono kale na mabira mawiri yale (2). ");
INSERT INTO nyu_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Patsogolo pace, bweresa Aloni na wana wace pakupitira muCikumbi ca Kugumanirana ndipo udzawasambise. ");
INSERT INTO nyu_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ndipo utenge bzakubvala ubvazike Aloni batina na capacifuwa. Um'mangirire koleti ya wantsembe na mceka. ");
INSERT INTO nyu_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Umuikhe turbante mumsolo ndipo pa turbhantepo umangirire diyadema yakucenesedwa. ");
INSERT INTO nyu_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","M'dzoze na mafuta ya kudzozesa, uthululire m'msolo mwa Aloni. ");
INSERT INTO nyu_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ndipo ubwerese wana wace, uwabvazike batina m'bodzi na m'bodzi ");
INSERT INTO nyu_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","na turbante mumusolo. Uwaikhe miceka, Aloni na wana wace. Unyantsembe ni bwawo ninga Mtemo wakusaya kumala. Tenepoyo iwepo un'dzapambula Aloni na wana wace”. ");
INSERT INTO nyu_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Bweresa kamkono patsogolo pa Cikumbi ca Kugumanirana. Ndipo Aloni na wana wace an'dzaikha manja pamsolo pa kamkonoko, ");
INSERT INTO nyu_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ndipo iwe udzakaphe pamaso pa Mbuya kutsogolo kwa Cikumbi ca Kugumanirana. ");
INSERT INTO nyu_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Pamwepo udzatenge mulopa wa kamkono kale, ndipo udzapalangire pa nyanga za paguwa na cala. Mulopa wakusala udzauthululire patsinde la guwalo. ");
INSERT INTO nyu_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Patsogolo pace utenge mafuta yentse yomwe yanimpsinkha utumbo, mafuta ya kuciropa, impso ziwiri na mafuta yomwe yanimpsinkha impsozo ndipo ubzitenthe paguwapo. ");
INSERT INTO nyu_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Tsono nyama yace, khanda na ndowe za kamkono kale, ubzitenthe kunja kwa msasa. Ni ntsembe zakulekereredwa bzitazo”. ");
INSERT INTO nyu_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Tenga m'bodzi wa mabira yale, ndipo Aloni na wana wace adzaikhe manja pamsolo pace. ");
INSERT INTO nyu_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Udzamuphe ndipo udzatenge mulopa wace uciwazira m'mbali zentse za guwalo. ");
INSERT INTO nyu_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Udzagwate-gwate birayo ndipo udzatsuke utumbo na minyendo yace, udzaikhe pambali pa msolo na bzinangobzo. ");
INSERT INTO nyu_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ndipo utenthe bira wentseneyo paguwa. Ni ntsembe yakutentha ya Mbuya, ni ntsembe ya pfungo labwino ya Mbuya yakukondzedwa pamoto”. ");
INSERT INTO nyu_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Patsogolo pace udzatenge bira winangoyo ndipo Aloni na wana wace adzaikhe manja pamsolo pace, ");
INSERT INTO nyu_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ndipo iwe udzaphe birayo, udzatenge mulopa wace ucidzaupalangira munyantsi mwa khutu lamadidi la Aloni na la wana wace, na pa cala cikulu ca boko lamadidi na ca mwendo wamadidi ca m'bodzi na m'bodzi wawo. Patsogolo pace thululira mulopa wakusala m'mbali zentse za guwalo. ");
INSERT INTO nyu_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Pamwepo, utenge mulopa pan'gono wa guwa na mafuta pan'gono yakudzozesa, ndipo udzawazire Aloni na bzakubvala bzace, na wana wace na bzakubvala bzawo. Tenepoyo an'dzapambulidwa iye na bzakubvala bzace, na wana wace na bzakubvala bzawo”. ");
INSERT INTO nyu_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Patsogolo pace birayo udzam'cose mafuta, mafuta ya mbali ya kumcira, mafuta ya kuutumbo, mafuta ya kuciropa, impso ziwiri (2), na mafuta yomwe yambampsinkha impsozo na nchafu ya madidi. Umweyu ni bira wa msinda wa kudzoza. ");
INSERT INTO nyu_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ndipo mucitundu ca pau zakusaya cakufufumisa comwe ciri patsogolo pa Mbuya, cosa pau ibodzi, bholo libodzi lakuwochedwa na azeite na pau ibodzi yakusaya nchinya. ");
INSERT INTO nyu_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Bzentse ubziikhe m'manja mwa Aloni na mwa wana wace, ndipo abziwonese kumbali na mbali acidzabzipereka patsogolo pa Mbuya ninga ntsembe zakulatiza. ");
INSERT INTO nyu_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Patsogolo pace udzabzitenge m'manja mwawo ndipo udzatenthe pau pa guwa, na ntsembe yakutentha yakununchira bwino kwa Mbuya, ni cakuperekedwa ca Mbuya cakukondzedwa pa moto”. ");
INSERT INTO nyu_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Utenge nkhombe ya bira wakudzozera Aloni ndipo ulatize mbali na mbali patsogolo pa Mbuya, ninga ntsembe zakulatiza, nkhombe imweyo indzakhala yako. ");
INSERT INTO nyu_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Pamwepo udzapambule mbali zire za bvululume wakudzodzera Aloni na wana wace, nkhombe na nchafu bzomwe bzidalatizidwa ninga bzakupereka. ");
INSERT INTO nyu_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Mbali zimwezi nthawe zentse zin'dzaperekedwa na aIjirayeri acidzacitira Aloni na wana wace. Ni kutsonkha kwakuumirizidwa kuti acite, mu bzakupereka bzawo bza kuphatana na Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Bzakubvala bzakucenesedwa bza Aloni bzin'dzakhala bza wana wace wacimuna, kuti adzabvale akadzadzozedwa acidzapambulidwa. ");
INSERT INTO nyu_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mwana omwe an'dzakhala pambuto yace ninga wantsembe, pakudzapita muCikumbi ca Kugumanirana kuti aphate basa paMbuto Yakucena, bzakubvalabzo adzabzibvale m'kati mwa ntsiku zinomwe”. ");
INSERT INTO nyu_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Udzatenge bira wa kupambulidwa ndipo udzaphike nyama yace pambuto yakucena. ");
INSERT INTO nyu_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ndipo Aloni na wana wace adzadye nyama ya birayo na pau yomwe iri m'citundu, pamsuwo pa Cikumbi ca Kugumanirana. ");
INSERT INTO nyu_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ndipo adzadye bzakuperekedwabzo bzomwe iwo adapereka kuti alekereredwe bzitazo na kupambulidwa. Pokha-pokha azibaba wa ntsembe ndiwo angadye, thangwe ni bzakucenesedwa. ");
INSERT INTO nyu_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Pangasala nyama ya bira wa kupambulidwa ayai pau kufikira mangwana yandzace, udzatenthe. Bzireke kudyedwa, thangwe ni bzakucenesedwa. ");
INSERT INTO nyu_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Ndipo kudzozedwa kwa Aloni na wana wace, udzacite mkati mwa ntsiku zinomwe bzentse bzomwe ndidakuuza. ");
INSERT INTO nyu_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ntsiku iri-yentse umbaphe kamkono ninga cakupereka ca kulekereredwa bzitazo. Ucenese guwa, ucimbaperekera ntsembe pamwepo ndipo ulidzoze kuti licenesedwe. ");
INSERT INTO nyu_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Mukati mwa ntsiku zinomwe pereka ntsembe ya kulekereredwa ya guwalo ndipo ulicenese. Pamwepo guwalo lin'dzakhala lakucena kwakuposa, ndipo bzentse bzomwe bzin'dzalikhuya bzin'dzakhala bzakucenesedwa. ");
INSERT INTO nyu_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Bzomwe bzin'funika kuti umbapereke paguwa ni ibzi: Ntsiku iri-yentse upereke wana wa bira awiri wa gole libodzi. ");
INSERT INTO nyu_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Upereke m'bodzi macibese winango kumaulo. ");
INSERT INTO nyu_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Wakuyambayo umbam'pereke pabodzi na gaba m'bodzi wa ufa bwabwino, wakusanganiza na litru ibodzi ya azeite ya oliva, ndipo na litru ya vinyu ibodzi ninga cakupereka cakuthuluridwa. ");
INSERT INTO nyu_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Mwana wa bira waciwiriyo umbampereke kumaulo pabodzi na cakupereka ca cakudya na cakuthulula, ninga bza macibese bzire. Ni cakupereka ca pfungo labwino ca Mbuya cakukonzedwa pa moto. ");
INSERT INTO nyu_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Ntsembe yakutenthayi imbadzacitidwe ntsiku iri-yentse kwa m'badwe na m'badwe pamsuwo wa Cikumbi ca Kugumanirana, patsogolo pa Mbuya. Pambuto imweyi, Ine nin'dzagumana namwe ndipo nin'dzalewa-lewa na iwe. ");
INSERT INTO nyu_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Pamwepo nin'dzagumana na aIjirayeri, ndipo mbutoyo in'dzacenesedwa na ukulu bwangu. ");
INSERT INTO nyu_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Nin'dzacenesa Cikumbi ca Kugumanirana ndipo na guwa, nin'dzacenesambo Aloni na wana wace kuti anditumikire ninga azibaba wa ntsembe. ");
INSERT INTO nyu_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Nin'dzakhala pakati pa aIjirayeri ndipo nin'dzakhala Mulungu wawo. ");
INSERT INTO nyu_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","An'dzadziwa kuti Ine ndine Mbuya, Mulungu wawo, omwe ndidawacosa muIjipito kuti ndikakhale pakati pawo. Ine ndine Mbuya, Mulungu wawo. ");
INSERT INTO nyu_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Kondza guwa la muti wa akasiya lakutenthera ntsembe zakununchira. ");
INSERT INTO nyu_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Likhale na magonyo manai (4) yakundendemerana, ya sentimetru makumi manai na maxanu (45) mbali ibodzi na ibodzi, ndipo sentimetru makumi mapfemba (90) kutalimpha kwace, nyanga zalene zidzaphatane na guwalo cicikhala cinthu cibodzi. ");
INSERT INTO nyu_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Udzapalangire oro caiyo mbali yakudzulu, mbali zentse na m'magonyo mwace ndipo udzakondze m'kombero wa oro m'mphepete mwace. ");
INSERT INTO nyu_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Kondza aligola za oro ziwiri kumbali ibodzi na ibodzi ya guwa, pantsi pa m'kombero kuti ziphate tumitanda twakulinyamulisa. ");
INSERT INTO nyu_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Utenge muti wa akasiya ukondze tumitanda ndipo utupalangire oro. ");
INSERT INTO nyu_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ikha guwa patsogolo pa nguwo yakugawisa yomwe iri patsogolo pa Kaxa ya Cipangano, patsogolo pa cakugwanankhirira ca Kaxa ya Cipangano komwe nin'dzagumana na iwe. ");
INSERT INTO nyu_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Aloni an'dzatentha ntsembe yapfungo labwino pa guwa macibese yali-yentse, pomwe an'dzabwera kudzakondza bziphani-phani, ");
INSERT INTO nyu_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","napombo pomwe an'dzabzigasa kukadoka. Ntsembeyo imbadzatenthedwe ntsiku zentse patsogolo pa Mbuya pa mibadwe yanu yentse. ");
INSERT INTO nyu_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Pa guwa limweri lekani kudzapereka ntsembe zakununchira za mtundu winango napo zakutentha, ayai za phoso ngakhale kulithululira bzakumwa. ");
INSERT INTO nyu_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aloni ambadzacite ntsembe za kulekereredwa bzitazo m'magonyo mwa guwali kabodzi pagole. Ntsembe za pagolezo, zimbadzacitidwe na mulopa wakuperekedwa mwakulekereredwa bzitazo, kwa m'badwe na m'badwe. Guwa limweri kwa Mbuya ni lakucena kuposa”. ");
INSERT INTO nyu_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Pamwepo Mbuya adalewa na Mozeji aciti: ");
INSERT INTO nyu_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Iwe ukacita kanembera ka aIjirayeri, m'bodzi na m'bodzi wa iwo bzin'funika kuti alipire kuna Mbuya ntsengwa yakulomboledwa kwa moyo wace akadzakhala kuti alewengedwa. Tenepoyo palibe cisi cin'dzabwera kwa iwo iwepo ukawalewenga. ");
INSERT INTO nyu_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","M'bodzi na m'bodzi wakunembedwa adzatsonkhe garama zitanthatu (6), kucokera ku mphimo ya mbuto yakucena yomwe ni ya garama khumi na ziwiri (12). Garama zitanthatuzo ni zakupereka kwa Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Wentse wakulewengedwa wa magole makumi mawiri (20) kuyenda kutsogolo, adzapereke cakupereka cimweci kwa Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Anyakudala mbaleke kudzapereka mwakupitirira, ngakhale wakusauka kudzapereka mwakusaya kukwanira garama zitanthatu (6), pomwe an'dzapereka cakupereka kwa Mbuya ninga kulomboledwa kwa moyo wanu. ");
INSERT INTO nyu_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Tambira ntsengwa ya kulomboledwa kwa aIjirayeri ndipo udzaphatise basa pa Cikumbi ca Kugumanirana. In'dzakhala cikumbuso pamaso pa Mbuya kucipande ca aIjirayeri, kuti imbalombola moyo yanu”. ");
INSERT INTO nyu_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Pamwepo Mbuya adalewa kuna Mozeji aciti: ");
INSERT INTO nyu_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Kondza ntsambidwe ya burondze na thako la burondze kuti ambasambire. Uiikhe pakati pa guwa na Cikumbi ca Kugumanirana ndipo uidzaze madzi. ");
INSERT INTO nyu_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aloni na wana wace adzasambe manja na kunzayo muntsambidwemo. ");
INSERT INTO nyu_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Nthawe iri-yentse yomwe an'dzapita muCikumbi ca Kugumanirana, bzin'dzafunika kuti adzasambe na madziyo kuti aleke kufa. Napombo pomwe an'dzafendera pafupi na guwa kuti adzaphate basa la Mbuya, acidzawonesa cakupereka cakutenthedwa pa moto, ");
INSERT INTO nyu_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","an'dzasamba manja na kunzayo kuti aleke kufa. Umweyu ni Mtemo wakusaya kumala, kuna Aloni na bzizukulu bzace, mpaka mibadwe na mibadwe”. ");
INSERT INTO nyu_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Mbuya adapitiriza kuuza Mozeji kuti: ");
INSERT INTO nyu_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Sanganiza bzakununchira bzabwino ibzi: Kiru zitanthatu (6) za mira ya madzi-madzi, cipande ca bzimwebzi ayai kiru zitatu (3) za kanela, kiru zitatu (3) za ndzimbe zakununchira bwino, ");
INSERT INTO nyu_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","kiru zitanthatu (6) za kasiya, malinge na mphimo ya mbuto yakucena, ndipo na galoni libodzi la azeite ya oliva. ");
INSERT INTO nyu_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Na bzinthu bzimwebzi kondza mafuta yakucena yakudzozesa, ya kununchira bwino yakusanganizidwa, ninga momwe ambacitira wakukondza bzakununchira. Yamweyo yan'dzakhala mafuta yakucena yakudzozesa. ");
INSERT INTO nyu_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Yaphatise basa la kudzoza Cikumbi ca Kugumanirana, Kaxa ya Cipangano, ");
INSERT INTO nyu_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","meza na bzakuphatisira bzace bzentse, cakukhazikira ciphani-phani na bzakuphatisira bzace, guwa la ntsembe yakununchira, ");
INSERT INTO nyu_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","guwa la ntsembe yakutentha na bzakuphatisira bzace bzentse, ntsambidwe na thako lace. ");
INSERT INTO nyu_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Iwepo un'dzabzicenese tenepo bzinthubzo, ndipo bzin'dzakhala bzakucenesedwa kwene-kwene. Bzentse bzomwe bzin'dzakhuya bzinthubzo bzin'dzakhala bzakucenesedwa. ");
INSERT INTO nyu_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Dzoza Aloni na wana wace ndipo uwacenese kuti anditumikire ninga azibaba wa ntsembe. ");
INSERT INTO nyu_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Uza aIjirayeri kuti: Yamweya yan'dzakhala mafuta yangu yakucena yakudzoza, mibadwe na mibadwe. ");
INSERT INTO nyu_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Leka kudzayathululira kwa munthu omwe ni wantsembe lini, ndipo leka kudzakondza mafuta yanango na makondzedwe yamweya. Ni mafuta yakucena, na tenepo imwepo bzin'funika kuti muyayese yakucena. ");
INSERT INTO nyu_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Omwe an'dzakondza mafuta ninga yamweya ayai kudzayaphatisa basa kwa winango omwe ni wantsembe lini, an'dzacosedwa pakati pa mbumba yace”. ");
INSERT INTO nyu_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Mbuya adapitiriza kulewa na Mozeji kuti: “Sanganiza bzakununchira bwino ibzi: Balsamu, onika, galibanu na ntsembe yakununchira caiyo, bzentse mumphimo ibodzi-bodzi, ");
INSERT INTO nyu_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ndipo kondza ntsembe yakununchira ya m'nunci wakusanganiza, ninga momwe ambakondzera wakukondza bzakununchira. Udzaikhe munyu ndipo iyo in'dzakhala caiyo na yakucena. ");
INSERT INTO nyu_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Upeye cipande cinango mpaka kunyodoka ndipo uwuikhe kutsogolo kwa Kaxa ya Cipangano muCikumbi ca Kugumanirana, komwe nin'dzawonana na iwe. Ntsembe yakununchirayo in'dzakhala yakucena kwene-kwene kwa imwe. ");
INSERT INTO nyu_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Lekani kudzacita ntsembe yakununchira inango na kakondzedwe kamweka kuti ikhale yanu, ntsembe imweyi muiyese yakucena, yakuperekedwa kuna Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Omwe an'dzacita ntsembe yakulingana na imweyire kuti abve kununchira kwace, an'dzacosedwa pakati pa mbumba yace”. ");
INSERT INTO nyu_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Pamwepo Mbuya adauza pomwe Mozeji kuti: ");
INSERT INTO nyu_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ine ndasankhula Bezaleri, mwana wa Uri, mzukulu wa Huri, wa dzinza la Juda, ");
INSERT INTO nyu_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ndipo ndam'dzaza Mzimu wa Mulungu ndicimupasa luso, ndzeru na udziwi bwa kucita bzentse bza umisiri, ");
INSERT INTO nyu_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","kuti ambanembe citalo ca basa na kukondza bzinthu na oro, parata na burondze, ");
INSERT INTO nyu_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","aseme na kugoba minyala, ndipo kuti aseme muti na kugoba bzentse bza basa la luso. ");
INSERT INTO nyu_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ndipo Ine ndidalata Awoliyabe, mwana wa Aisamaki wa dzindza la Dani, kuti am'thandize. Napombo ndawapfundzisa wentse wa luso kuti andikondzere bzentse bzomwe ndawauza: ");
INSERT INTO nyu_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Cikumbi ca Kugumanirana, Kaxa ya Cipangano na cakugwanankhirira comwe ciri padzulu pa Kaxayo na bzinango bzentse bzakuphatisira basa bza Cikumbi, ");
INSERT INTO nyu_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ndipo meza na bzakuphatisira basa bzace, cakukhazikira bziphaniphani bza oro caiyo na bzakuphatisira basa bzace, guwa lakutenthera bzakununchira, ");
INSERT INTO nyu_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","guwa la ntsembe yakutentha na bzakuphatisira basa bzace, ntsambidwe na cakukhazikira cace, ");
INSERT INTO nyu_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","bzakubvala bza misinda, napombo bzakubvala bzakucenesedwa bza wantsembe Aloni na bvakubvala bza wana wace, pomwe an'katumikira ninga wantsembe, ");
INSERT INTO nyu_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mafuta ya kudzozera na ntsembe zakununchira za mbuto yakucena. An'dzacita bzentse ninga momwe Ine ndawauza”. ");
INSERT INTO nyu_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Mbuya adalewa pomwe kuna Mozeji aciti: ");
INSERT INTO nyu_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Uza aIjirayeri kuti ambakumbukire ntsiku zangu za Sabudu. Cimweci cidzakhala cizindikiro pakati pa Ine na imwe, m'badwe na m'badwe, mwakuti adzadziwe kuti Ine ndine Mbuya omwe nimbakucenesani. ");
INSERT INTO nyu_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“Kumbukirani ntsiku ya Sabudu nakuti kwa imwe ni yakucena. Ule omwe an'dzasaya kuikumbukira bzin'funika kuti adzaphedwe. Ndipo omwe an'dzaphata basa pantsiku imweyi, adzathothedwe pakati pa mbumba yace. ");
INSERT INTO nyu_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","M'kati mwa ntsiku zitanthatu mungadzacite basa liri-rentse, tsono ntsiku yacinomwe ni Sabudu, ntsiku yakupuma, yakucena kuna Mbuya. Ali-yentse omwe an'cita basa pantsiku ya Sabudu bzin'funika kuti adzaphedwe. ");
INSERT INTO nyu_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Na tenepo, aIjirayeri an'dzakumbukira ntsiku ya Sabudu, pa mibadwe na mibadwe yawo icikhala cipangano cakusaya kumala. ");
INSERT INTO nyu_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Cimweci cin'dzakhala cizindikiro cakusaya kumala pakati pa Ine na aIjirayeri, nakuti m'kati mwa ntsiku zitanthatu Mbuya adalenga kudzulu na pantsi ndipo pantsiku yacinomwe Iye, adapuma ndipo adakhala pomwe na mphambvu”. ");
INSERT INTO nyu_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Pomwe Mbuya adamala kulewa-lewa na Mozeji pa phiri ra Sinai, adam'pasa matabwa mawiri ya Cipangano, matabwa ya minyala, yakunembedwa na cala ca Mulungu. ");
INSERT INTO nyu_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mbumba pomwe idawona kuti Mozeji alikucedwa kubuluka muphiri, adakhonchezana pakhana Aloni icimuuza kuti: “Bwera, utikondzere mirungu kuti ititsogolere, nakuti Mozejiyo, mwamuna omwe adaticosa kuIjipito, tirikudziwa lini n'ciyani comwe camuwonekera”. ");
INSERT INTO nyu_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aloni adawatawira kuti: “Cosani mphete za m'makutu za oro za akazi wanu, na za wana wanu wacimuna na wacikazi ndipo zibwereseni kuna ine”. ");
INSERT INTO nyu_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Pamwepo, wentse adacosa mphete zawo za oro ndipo adayenda nazo kuna Aloni. ");
INSERT INTO nyu_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Iye adazitambira acizisungunusa, aciziikha mucakukondzera zentse zidakhala cifanikizo cibodzi ninga mphulu. Pamwepo, Iwo adalewa kuti: “Mbumba ya Ijirayeri, njiyi mirungu yanu yomwe idakucosani kuIjipito!” ");
INSERT INTO nyu_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aloni pomwe adawona bzimwebzi, adamanga guwa patsogolo pa mphuluyo ndipo adalewa aciti: “Mangwana kun'dzawoneka uzokoto bwakukondwerera Mbuya”. ");
INSERT INTO nyu_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Mangwana yace, adabweresa ntsembe zakutentha na za ciphatano. Ndipo mbumba idakhala pantsi icidya na kumwa, patsogolo pace idaima kuti ibzine. ");
INSERT INTO nyu_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Pamwepo, Mbuya adauza Mozeji kuti: “Buluka, thangwe mbumba yako yomwe udacosa kuIjipito, yataika. ");
INSERT INTO nyu_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Mwakakulumize asiya bzomwe ndidawauza ndipo acita cifanikizo ninga mphulu, adaipemba ndipo adaipasa ntsembe, acilewa kuti: ‘Imwe aIjirayeri njiyi mirungu yanu yomwe idakucosani kuIjipito’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Mbuya adauza pomwe Mozeji kuti: “Nimbawona kuti mbumba imweyi ina makani kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Tsapano leka ukali bwangu bubwerere iwo, kuti ine ndiwadzonge. Patsogolo pace nin'dzakusandusa mbumba ikulu”. ");
INSERT INTO nyu_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Tsono, Mozeji adadandaula kuna Mbuya, Mulungu wace, aciti: “Imwe Mbuya, thangwe ranyi mulikufuna kubweresa ukali bwanu kuna mbumba yanu, yomwe mudacosa kudziko la Ijipito na mphambvu ikulu ndipo na boko la mphambvu? ");
INSERT INTO nyu_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Kodi aIjipito an'dzalewa lini kuti: ‘Mudawacosa na cakulinga cakuipa, kuti muwaphe mumapiri ndipo muwadzonge pa dziko’? Bwezani moto wa ukali bwanu! Khalani na ntsisi lekani kubweresa cakuipaci kuna mbumba yanu! ");
INSERT INTO nyu_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kumbukirani anyagirinya wanu Abrahamu, Izaki na Ijirayeri, omwe imwepo caiye mudalumbirira kuti: ‘Ndin'dzacita kuti bzizukulu bzako bzidzakhale bzakuwanda ninga nyenyezi za kudzulu ndipo ndin'dzabzipasa dziko lentseneli lomwe ndidalewa, kuti lin'dzakhala utaka bwawo kwakusaya kumala’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Pamwepo Mbuya adaleka cakugosva comwe akhafuna kucitira mbumba. ");
INSERT INTO nyu_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ndipo, Mozeji adabuluka muphiri na matabwa mawiri ya Cipangano m'manja mwace, yakhadanembedwa mbali ziwiri kutsogolo na kumbuyo. ");
INSERT INTO nyu_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Matabwayo yakhadakondzedwa na Mulungu. Bzomwe bzikhadagobedwa m'matabwayo bzidanembedwa na Mulungu. ");
INSERT INTO nyu_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ndipo pomwe Josuwe adabva ciwowo ca mbumba icimbakuwa, adauza Mozeji kuti: “Pana ciwowo ca nkhondo pa msasa”. ");
INSERT INTO nyu_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mozeji adatawira kuti: “Ni muwira lini wa wakukunda, ngakhale muwira wa wakukundidwa, tsono ndirikubva muwira wa wakuimba!” ");
INSERT INTO nyu_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Pomwe Mozeji adafika pafupi na msasa, adawona mphulu na bzakubzina, adakalipa acithusa matabwa pantsi munyantsi mwa phiri, aciyabadula. ");
INSERT INTO nyu_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ndipo adaphata mphulu yomwe iwo akhadakondza aciidzonga pa moto yatasandulika mpaka kunyodoka, adaiwazira m'madzi acipasa aIjirayeri kuti amwe madziyo. ");
INSERT INTO nyu_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ndipo Mozeji adabvundza Aloni kuti: “Ni ciyani comwe mbumbayi yakucitira kuti uiphonyese kwakugosva tenepayu?” ");
INSERT INTO nyu_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aloni adamutawira kuti: “Lekani kukalipa, mbuya wangu, imwe mun'dziwisisa kuti mbumba imweyi imbakumbuka bzakuipa. ");
INSERT INTO nyu_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Iyo idandiuza kuti: ‘Tikondzere mirungu kuti ititsogolere, nakuti tirikudziwa lini ni ciyani comwe cacitika kuna Mozejiyo mwamuna omwe adaticosa kuIjipito’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Pamwepo ndidawauza kuti: “Omwe ana oro, abwerese kuna ine. Mbumba idandibweresera oro, ine ndidaithusa pa moto ndipo padacokera mphuluyi”. ");
INSERT INTO nyu_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mozeji adawona kuti mbumba ikhacita bzomwe in'funa, thangwe Aloni akhadawalekerera, mwakuti akhadasanduka cinthu cakusekesa kwa anyamadulanthaka wawo. ");
INSERT INTO nyu_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Pamwepo adaimirira pakupitira pa msasa, ndipo aciti: “Omwe ni wa Mbuya aphatane na ine”. Amuna wentse wa dzindza la Levi adaphatana na iye. ");
INSERT INTO nyu_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ndipo adawauza pomwe kuti: “Mbuya, Mulungu wa Ijirayeri alikulewa tenepa: ‘M'bodzi na m'bodzi atenge cisenga cace, apite mumsasa pacikumbi na cikumbi ndipo aphe m'bale wace, xamwali wace, na wapafupi wace’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Amunawo adacita ninga momwe adawauzira Mozeji, ndipo ntsiku imweyo adafa pafupi-fupi bzulu bzitatu pakati pa mbumba. ");
INSERT INTO nyu_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Pamwepo Mozeji adalewa kuti: “Lero imwepo mwabzipambula kuti mukhale wakutumikira Mbuya, nakuti palibe na m'bodziyo wa imwe wabva ntsisi na mwana wace ayai m'bale wace. Na tenepo, ntsiku imweyo Mbuya adawadalisa”. ");
INSERT INTO nyu_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mangwana yandzace, Mozeji adauza mbumba kuti: “Imwepo mwacita citazo cikulu. Tsapano nin'kwira pomwe kuphiri ndikalewe-lewe na Mbuya, kuti pinango ningakakwanise kuti Iye akulekerereni kutaza kwanu”. ");
INSERT INTO nyu_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ndipo Mozeji adabwerera kuna Mbuya aciti: “Mbumbayi idacita citazo cikulu, idabzikondzera mirungu ya oro. ");
INSERT INTO nyu_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Tsapano, ndaphata minyendo ndirikukumbirani kuti muwalekerere citazo cawo, bzikasaya kukwanisika mundipfudze mulivu lanu lomwe mudanemba”. ");
INSERT INTO nyu_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mbuya adam'tawira Mozeji aciti: “Nin'dzapfudza mulivu langu wentse omwe adacita citazo kuna Ine. ");
INSERT INTO nyu_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ndoko tsapano, tsogolera mbumba kumbuto yomwe ndidakuuza, ndipo anju wangu an'dzayenda patsogolo pako. Tsono nthawe ikadzakwana yakuwapasa nyathwa, Ine nin'dzawapasa nyathwa thangwe ra kuphonya kwawo”. ");
INSERT INTO nyu_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ndipo Mbuya adapweteka mbumba na cisi, thangwe idaumiriza Aloni kuti akondze mphulu. ");
INSERT INTO nyu_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Patsogolo pace Mbuya adauza Mozeji kuti: “Coka pambuto ino pabodzi na mbumba yomwe udacosa kudziko la Ijipito, ndipo ndoko kudziko lomwe ndidapicira na lumbiro kuna Abrahamu, Izaki na Jakobo, ndiciti: Ine nin'dzalipereka kuna bzizukulu bzako. ");
INSERT INTO nyu_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nin'dzatumiza anju patsogolo pako ndipo nin'dzathotha aKenani, aAmori, aHiti, aFerezi, aHevi na aJebuzi. ");
INSERT INTO nyu_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ndokoni kudziko lomwe lidadzala m'kaka na uci. Tsono Ine ndiniyenda lini na imwe, nakuti ndimwe mbumba ya makani kwene-kwene, ndipo Ine ningakudzongeni munjira”. ");
INSERT INTO nyu_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Pomwe mbumba idabva mafala yakugosvayo, idayamba kulira, ndipo palibe omwe adabvala bzamantikade. ");
INSERT INTO nyu_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Bzimwebzi ni thangwe lakuti Mbuya akhadauza Mozeji kuti auze aIjirayeri kuti: “Imwepo ndimwe mbumba ya makani kwene-kweni. Ine ningadayenda na imwe, napo nthawe pang'ono, Ine ningadakudzongani. Tsapano cosani bzamantikade bzanu ndipo Ine nin'dzadziwa n'ciyani nin'dzacita na imwe”. ");
INSERT INTO nyu_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ndipopo, kuyambira pa phiri la Sinai, aIjirayeri alibe kubvala pomwe bzamantikade. ");
INSERT INTO nyu_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ndipo Mozeji akhana msambo wakumanga Cikumbi mbali ya kunja kutali na msasa. Iye akhacicemera Cikumbi ca Kugumanirana. Ndipo omwe akhafuna kubvundza Mbuya, akhayenda muCikumbimo kunja kutali na msasa. ");
INSERT INTO nyu_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Nthawe zentse zomwe Mozeji akhayenda mpaka kumweko, mbumba yentse ikhambaimirira icikhala dzololo pakupitira pa bzikumbi bzawo, acimbamunyang'anisisa mpaka iye kukapita muCikumbi. ");
INSERT INTO nyu_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Nthawe zentse pomwe Mozeji akhapita muCikumbi, mtambo ukhabuluka uli-njo uciima pakupitira paCikumbi, ndipo Mbuya akhalewa-lewa na Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Pomwe mbumba ikhawona mtambo uli-njo udaima pakupitira pa Cikumbi, wentse akhapemba adaimirira, m'bodzi na m'bodzi pakupitira pa cikumbi cace. ");
INSERT INTO nyu_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Mbuya akhalewa-lewa na Mozeji nkhope na nkhope, ninga omwe alikulewa-lewa na xamwali wace. Patsogolo pace Mozeji akhabwerera kumsasa. Tsono Jozuwe mwana wa Nuni, omwe akhamtumikira ninga m'thandizi akhacoka lini paCikumbico. ");
INSERT INTO nyu_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mozeji adauza Mbuya adati: “Imwe mudandiuza kuti: ‘Tsogolera mbumbayi’, tsono mulibe kundiuza omwe mun'dzatuma kuti ayende na ine. Mudalewa kuti: ‘Ine ndirikukudziwa na dzina ndipo nimbakomedwa nawe’. ");
INSERT INTO nyu_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Penu cadidi mumbandicitira cifundo, ndidziwiseni bzitalo bzanu kuti ndikudziweni ndipo ndiwone cifundo canu kwa ine. Kumbukirani kuti wanthuwa ni mbumba yanu”. ");
INSERT INTO nyu_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Mbuya adatawira kuti: “Ine caiye nin'dzayenda nawe, ndipo nin'dzakupasa mphumulo”. ");
INSERT INTO nyu_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Pamwepo Mozeji adalewa kuti: “Mukaleka kuyenda nafe, lekani kutitumiza. ");
INSERT INTO nyu_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Tin'dzadziwa tani ine na mbumba yanu kuti mwaticitira cifundo mukaleka kuyenda nafe? Kodi ni ciyani comwe cisiyanisa, ine na mbumba yanu pakati pa mbumba zentse za padziko la pantsi?” ");
INSERT INTO nyu_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Mbuya adauza Mozeji kuti: “Nin'dzacita bzomwe wandikumbira, thangwe nimbakomedwa na iwe ndipo nimbakudziwa na dzina”. ");
INSERT INTO nyu_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Pamwepo Mozeji adati: “Ndirikukumbirani kuti mundiwonese ukulu bwanu”. ");
INSERT INTO nyu_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ndipo Mulungu adatawira kuti: “Nin'dzacitisa kuti ubwino bwangu bwentse bupite na patsogolo pako, ndipo nin'dzalewa dzina langu lomwe ni Mbuya patsogolo pako. Nin'dzacitira ntsisi ule omwe Ine nin'dzafuna kum'citira ntsisi, ndipo nin'dzacitira cifundo ule omwe Ine nin'dzafuna kum'citira cifundo”. ");
INSERT INTO nyu_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ndipo adapitiriza kuti: “Iwepo un'dzawona lini nkhope yangu, thangwe palibe omwe angandiwone, acipitiriza kukhala na moyo”. ");
INSERT INTO nyu_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Mbuya adapitiriza kulewa kuti: “Iripo mbuto pafupi na Ine pano, pomwe iwepo un'dzaima padzulu pa mwala. ");
INSERT INTO nyu_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Tsono ukulu bwangu bukambadzapita, Ine nin'dzakuikha mugwindza la mwala ndipo nin'dzakumpsinkha na boko langu mpaka Ine kupita. ");
INSERT INTO nyu_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Pamwepo nin'dzacosa boko langu ndipo iwepo un'dzawona kumbuyo kwangu. Tsono nkhope yangu palibe omwe an'dzaiwona”. ");
INSERT INTO nyu_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Mbuya adauza Mozeji kuti: “Goba matabwa mawiri (2) ya minyala yakulinganira na yakuyamba yale, ndipo pamatabwayo nin'dzanemba mafala yomwe yakhali pamatabwa yakuyamba yomwe iwe udabadula. ");
INSERT INTO nyu_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ukhale wakukonzeka macibese kuti udzakwire paphiri la Sinai. Ndipo pom'pale pantsonga ya phiri ukawonekere kuna Ine. ");
INSERT INTO nyu_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Palibe omwe an'dzakwira na iwe, napo kudzakhala pambuto iri-yentse ya phiri. Ndipo mabira na ng'ombe bzidzaleke kudyera pafupi na phiriro”. ");
INSERT INTO nyu_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Pamwepo Mozeji adagoba matabwa mawiri (2) ya minyala yakulinganirana na yakuyamba ndipo adakwira paphiri la Sinai, macibese-bese, ninga momwe Mbuya akhadamuuzira, adanyamula m'manja mwace matabwa mawiri (2) ya minyala. ");
INSERT INTO nyu_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Pamwepo Mbuya adabuluka mumtambo, adakhala naye pamwepo ndipo adalewa dzina lace lomwe ni Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ndipo adapita patsogolo pa Mozeji, acimbalewa kuti: “Mbuya, Mbuya, Mulungu wacifundo na ntsisi, wakusaya kukalipa mwakamkulumize, wakudzala na lufoi ndipo wakukhulupirika, ");
INSERT INTO nyu_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Omwe ambawonesa lufoi lace kwa bzulu bza mibadwe ndipo ambalekerera bzakuipa, kusandukira na bzitazo. Na bzentsenebzi ambaleka lini kulanga omwe ana mulandu. Ambapasa nyathwa wana na azukulu thangwe ra kuphonyera Mulungu kwa azibaba wawo, mpaka m'badwe wa citatu (3) na wa cinai (4)”. ");
INSERT INTO nyu_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Pamwepo letu Mozeji adagodama, acitsulima, ndipo adam'pemba aciti: ");
INSERT INTO nyu_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“Mbuya, penu cadidi mumbandicitira cifundo, tiperekezeni ndipo Mbuya. Napo mbumbayi ni ya makani kwene-kwene, tirekerereni cakuipa cathu na kutaza kwathu ndipo ticiteni utaka bwanu”. ");
INSERT INTO nyu_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Mbuya adauza Mozeji kuti: “Nin'cita cipangano. Patsogolo pa mbumba yako yentse nin'dzacita bzidabwiso bzomwe bzikanati kucitika pamaso pa mbumba inango iri-yentse ya padziko. Pakati pa mbumba yomwe iwepo un'khala, pan'dzawoneka basa la kudabwisa lomwe Ine Mbuya nin'dzacita. ");
INSERT INTO nyu_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Bvera bzomwe Ine nin'kuuza lero lino. Nin'dzathotha patsogolo pako aAmori, aKenani, aHiti, aFerezi, aHevi na aJebuzi. ");
INSERT INTO nyu_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Lekani kucita cipangano na wale alikukhala mdziko lomwe mulikuyenda, nakuti an'dzakhala ninga diwa kuna imwepo. ");
INSERT INTO nyu_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Kagweseni maguwa yawo, gumulani minyala yawo ndipo gwatani bzifanikizo bzawo bza mphanda. ");
INSERT INTO nyu_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Muleke kutumbiza mirungu inango, thangwe dzina la Mbuya ni Ntsanje, ndipo Iye cadidi ni Mulungu wa ntsanje”. ");
INSERT INTO nyu_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Cenjera kuti ukaleke kukacita cipangano na wale wakukhala m'dziko la Kenani. Nakuti iwo pomwe an'cita upombo acitewera mirungu yawo ndipo acimbaipasa ntsembe, an'dzacemera iwepo ucikadya nawo bza ntsembe zawozo ");
INSERT INTO nyu_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ndipo ucisankhulira wana wako akazi pakati pa wana wawo. Pomwe akaziwo an'kacita uputa mwakuteweza mirungu yawo, angadzacitise wana wako kuti acitembo upombo”. ");
INSERT INTO nyu_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Lekani kubzikonzera bzifanikizo bza utale bwakusungunusidwa”. ");
INSERT INTO nyu_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Lekani kuyebwa kucita cikondwereso ca pau zakusaya cakufufumisa. Mkati mwa ntsiku zinomwe mumbadye pau zakusaya cakufufumisa, ninga momwe ndidakuuzani. Citani bzimwebzi Panthawe yace, mwezi wa Abibe, pakuti mwezi umweule iwe udacoka kuIjipito. ");
INSERT INTO nyu_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Mwana wacimuna ali-yentse wa kuyamba kubadwa ni wangu, napombo cakuyamba kubadwa cacimuna pakati pa bzifuwo bzanu bzentse: Ng'ombe, mabira na mbuzi. ");
INSERT INTO nyu_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tsono bulu akadzabala mwana wakuyamba mudzamulombole na bira. Tsono mukadzasaya kumulombola mudzamupongonyole khosi. Mumbalombole wana wanu wentse wakuyamba kubadwa”. “Palibe omwe an'dzabwera cimanja-manja patsogolo pangu”. ");
INSERT INTO nyu_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Mumbaphate basa m'kati mwa ntsiku zitanthatu, tsono ntsiku yacinomwe mumbapume, napo panthawe yakulima ayai yakubvuna”. ");
INSERT INTO nyu_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Lekani kuyebwa kucita cikondwereso ca midzinga Panthawe ya bzakubvuna bzakuyamba bza tirigu ndipo cikondwereso cakumala kubvuna, pakumala kwa gole. ");
INSERT INTO nyu_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Amuna wentse pakati pa mbumba yako ambadzakawonekere patsogolo pa Mbuya, Mulungu wa Ijirayeri, katatu pa gole. ");
INSERT INTO nyu_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nin'dzathotha madziko patsogolo pako ndipo nin'dzathimizira dziko lako. Pomwe un'dzakwira katatu pa gole kuti ukawonane na Mbuya Mulungu wako, palibe omwe an'dzasirira dziko lako”. ");
INSERT INTO nyu_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Leka kudzandipasa mulopa wa ntsembe pabodzi na pau zakufufumisidwa, ndipo leka kudzasiya cinthu ca ntsembe ya cikondwereso ca Paxkwa mpaka kufikira mangwana yandzace”. ");
INSERT INTO nyu_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Bweresa bzisapo bzakuyamba bzabwino kwene-kwene dziko lako pambuto yakucena ya Mbuya, Mulungu wako. “Leka kuphika mbuzi mumkaka wa mai wace”. ");
INSERT INTO nyu_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Mbuya adauza Mozeji aciti: “Nemba mafalaya. Thangwe ni kucokera mwa iyo pomwe ndirikucita cipangano na iwe ndipo na Ijirayeri”. ");
INSERT INTO nyu_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mozeji adakhala na Mbuya kumwekule ntsiku makumi manai masikati na usiku, alibe kudya cinthu napo kumwa madzi. Ndipo adanemba pamatabwa mafala ya Cipangano, yomwe ni Malangizo Khumi. ");
INSERT INTO nyu_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Pomwe Mozeji akhabuluka paphiri la Sinai, na matabwa mawiri ya Cipangano m'manja, Mozeji alibe kudziwa kuti nkhope yace ikhayetima thangwe ra kulewa-lewa na Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Pomwe Aloni na aIjirayeri yentse adawona nkhope ya Mozeji idayetima adabva mantha kum'fenderera. ");
INSERT INTO nyu_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Tsono Mozeji adawacemera. Aloni na atsogoleri wentse wa mthithi adabwera kuna iye ndipo Mozeji adalewa-lewa nawo. ");
INSERT INTO nyu_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Pambuyo pace adabwerambo aIjirayeri wentse ndipo iye adawafotokozera bzentse bzomwe Mbuya adamuuza paphiri la Sinai. ");
INSERT INTO nyu_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Pomwe adamala kulewa-lewa nawo, adampsinkha nkhope na nguwo. ");
INSERT INTO nyu_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tsono, nthawe zentse zomwe Mozeji akhayenda patsogolo pa Mbuya kukalewa-lewa naye, akhacosa nguwoyo kufikira atabula. Ndipo akabula akhauza aIjirayeri bzentse bzomwe iye akhauzidwa kuti acite. ");
INSERT INTO nyu_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ndipo iwo akhambawona nkhope yace ikhayetima. Pamwepo Mozeji akhambampsinkha pomwe nkhope yace na nguwo mpaka kupita pomwe kuti alewe-lewe na Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mozeji adatsonkhanisa mthithi wentse wa aIjirayeri aciwauza kuti: “Bzomwe Mbuya wakuuzani kuti mucite ni ibzi: ");
INSERT INTO nyu_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","M'kati mwa ntsiku zitanthatu mungadzaphate basa liri-lentse, tsono ntsiku yacinomwe idzakhale yakucena kwa imwe, Sabudu ya m'pumulo yakusankhulidwa na Mbuya. Wentse ule omwe an'dzaphata basa pantsiku imweyo bzin'dzafunika kuti adzaphedwe. ");
INSERT INTO nyu_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ndipo mudzaleke kuphatiza moto munyumba zanu ntsiku ya Sabudu!”. ");
INSERT INTO nyu_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mozeji adauza mthithi wentse wa aIjirayeri kuti: “Bzomwe Mbuya walewa kuti mucite ni ibzi: ");
INSERT INTO nyu_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘Pambulani cipande ca bzinthu bzanu mupase Mbuya. Wentse ule omwe ana m'tima wakupasa, an'dzabweresa ninga cakupereka kwa Mbuya bzinthu ibzi: Oro, parata, burondze, ");
INSERT INTO nyu_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","usalu bwa nguwo ya azuli, roxo na ifuira, nguwo yabwino, ukuse bwa mbuzi, ");
INSERT INTO nyu_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","makhanda ya bvululume yakupalangiridwa mtoto ufuira, makhanda yakufewa, muti wa akasiya, ");
INSERT INTO nyu_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mafuta ya kubvunikira, bzakununcira bzakukondzera mafuta ya kudzozera na ntsembe yakununchira, ");
INSERT INTO nyu_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ndipo minyala ya onikisi na minyala inango yakufunikira kuti ikhidwe pakoleti ya wantsembe ndipo na pacifuwa’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Wentse omwe pakati panu an'kwanisa, an'dzacita bzentse bzomwe Mbuya alewabzi: ");
INSERT INTO nyu_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","‘Kukondza Cikumbi ca Mipembo, na cam'kati na bzakusvimphirira bzace, ngoloweko zace, matabwa yace, mitanda yace, mphanda zace na matsinde yace, ");
INSERT INTO nyu_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Kaxa ya Cipangano na tumitanda twace, cakugwanankhirira na nguwo yakupsinkhira, ");
INSERT INTO nyu_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","meza na tumitanda twace na bzombo bzace bzentse, ndipo na pau zakuperekedwa kuna Mulungu, ");
INSERT INTO nyu_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","cakukhazikira bziphaniphani na bzombo bzace, bziphaniphani bzace na mafuta ya kubvunikira, ");
INSERT INTO nyu_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","guwa la ntsembe yakununchira na tumitanda twace, na mafuta ya kudzozera, na ntsembe ya kununchira bwino, na cinguwo cakugwatisa pa kupitira muCikumbi ca Mipembo, ");
INSERT INTO nyu_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","guwa la ntsembe yakutentha na cakuwochera cace ca burondze, tumitanda twace na bzombo bzentse, ntsambidwe ya burondze na cakukhazikira cace, ");
INSERT INTO nyu_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","nguwo za kugwatira kunja kwa cimtalo, na mbiru zace na matsinde yace, na nguwo yakugwatira pakupitira mucimtalo, ");
INSERT INTO nyu_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","bzakukhomereresa Cikumbi ca Mipembo na ya cimtalo ndipo na bzingwe bzabzene, ");
INSERT INTO nyu_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","bzakubvala bzomwe an'dzabvala wakutumikira mumbuto yakucena, napo bzakubvala bzakucenesedwa bza wantsembe Aloni ngakhale bzakubvala bza wana wace, pomwe an'dzatumikira ninga wantsembe’ ”. ");
INSERT INTO nyu_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Pamwepo mthithi wentse wa aIjirayeri udacoka patsogolo pa Mozeji, ");
INSERT INTO nyu_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ndipo wentse omwe akhafuna mtima wace ucimuumiriza, adabweresa bzakupereka kuna Mbuya kuti amangire Cikumbi ca kugumanirana, na mabasa yawo yentse ndipo na bzakubvala bzakucenesedwa. ");
INSERT INTO nyu_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Wentse omwe adakondzeka amuna napo akazi, adabweresa mphete za oro za mitundu iri-yentse: Mphete, nkhwinjiri, mphete-cala na bzakudekesera. Ndipo adapereka bzinthu bzawo bza oro ninga cakupereka ca msinda wa Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Wentse omwe akhana usalu bwa nguwo ya azuli, ya roxo na ifuira ayai nguwo yabwino, ukuse bwa mbuzi, makhanda ya bvululume yakupalangiridwa mtoto ufuira ayai makhanda yakufewa, akhabzibweresa. ");
INSERT INTO nyu_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Wale omwe adabweresa cakupereka ca parata ayai ca burondze adabzipereka ninga cakupereka kwa Mbuya, ndipo wentse ule omwe akhana muti wa akasiya kuti aphatire basa liri-lentse, adaibweresambo. ");
INSERT INTO nyu_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Akazi wentse wakukwanisa akhabweresa bzakuluka na manja yawo: Nguwo ya azuli, yaroxo, ifuira na nguwo yabwino. ");
INSERT INTO nyu_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Akazi wentse omwe akhafuna ndipo akhana luso adaluka ukuse bwa mbuzi. ");
INSERT INTO nyu_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Atsogoleri adabweresa minyala ya onikisi na minyala inango yakufunikira kuti iikhidwe pakoleti na capacifuwa ca wantsembe. ");
INSERT INTO nyu_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Adabweresa pomwe bzakununchira na mafuta ya oliva kuti abvunikire, mafuta ya kudzozera ndipo na ntsembe yakununchira bwino. ");
INSERT INTO nyu_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","AIjirayeri wentse omwe adabzipereka, amuna napo akazi, adabweresa kuna Mbuya bzakupereka bzaufulu kwa basa lentse lomwe Mbuya adawauza kuti acite, kucokera mwa Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mozeji adauza aIjirayeri kuti: “Mbuya adasankhula Bezaleri, mwana wa Uri, m'zukulu wa Huri, wa dzinza la aJuda, ");
INSERT INTO nyu_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ndipo adamudzaza Mzimu wa Mulungu, acim'pasa ndzeru, udziwi na luso la umisiri, ");
INSERT INTO nyu_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","kuti anembe citalo ca basa ndipo acite basa na oro, parata na burondze, ");
INSERT INTO nyu_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","kuti aseme minyala yakudekesera, ndipo kugoba muti, ndipo kucita basa la umisiri liri-lentse. ");
INSERT INTO nyu_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ndipo adapasa iye napombo Awoliyabe, mwana wa Ayizamaki, wa dzindza la Dani, luso lakupfundzisa winango. ");
INSERT INTO nyu_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Wentsenewa adawapasa ndzeru zakuti acite basa liri-lentse la umisiri, la kunemba citalo ca basa, ndipo la kuluka nguwo yabwino na usalu bwa nguwo zakubiriwira ya roxo na ifuira ndipo la kupakasa. Akhakwanisa kunemba na kucita basa liri-lentse la umisiri. ");
INSERT INTO nyu_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Ndipo Bezaleri na Awoliyabe, na amuna wentse wakukwanisa, omwe Mbuya adapasa udziwi na luso la basa lentse la kumanga mbuto yakucena, an'dzaphata basa ninga momwe Mbuya adawauzira”. ");
INSERT INTO nyu_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Pamwepo Mozeji adacemera Bezaleri, Awoliyabe na amuna wa luso wentse omwe Mbuya adawapasa udziwi, omwe akhadakondzeka kubwera kudzaphata basa. ");
INSERT INTO nyu_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Adatambira kuna Mozeji bzakupereka bzentse bzomwe aIjirayeri akhadabweresa kuti bziphatisidwe basa la kumanga mbuto yakucena. Ndipo mbumba ikhambabweresa bzakupereka bza ufulu kuna Mozeji macibese yali-yentse. ");
INSERT INTO nyu_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ndipo amisiri wentse waluso omwe akhaphata basa pambuto yakucena, adaimisa basa ");
INSERT INTO nyu_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ndipo adauza Mozeji kuti: “Mbumba irikubweresa bzizinji kuposa bzomwe bzikhafunika kuti tiphatisire basa lomwe Mbuya adalewa”. ");
INSERT INTO nyu_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Pamwepo Mozeji adalewa kuti yalewedwe m'misasa yentse mafala yakuti: “Palibe mwamuna ayai mkazi an'bweresa pomwe cakupereka kumbuto yakucena”. Na tenepo mbumba idaletsedwa kubweresa pomwe bzinthu, ");
INSERT INTO nyu_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","thangwe bzikhadatambiridwabzo bzikhali bzizinji kuposa bzomwe bzikhafunika kuti aphatisire basa lentse. ");
INSERT INTO nyu_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Amuna wentse waluso pakati pa wabasa, adakondza Cikumbi ca Mipembo na makolotina ya m'kati khumi ya nguwo yabwino yakulukidwa na usalu bwa nguwo ya azuli, ya roxo na ifuira, pabodzi na makerubini yakulukidwa padzaulu pace. ");
INSERT INTO nyu_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Makolotina yentse yakhali yakundendemerana, muutali mwayene yakhana metru khumi na ziwiri na sentimetru makumi matanthatu (12.60 m), muufupi mwayene yakhana metru ibodzi na sentimetru makumi masere (1.80 m). ");
INSERT INTO nyu_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Adamangirira makolotina maxanu yam'kati ndipo acicita bzibodzi-bodzi na yanango maxanu. ");
INSERT INTO nyu_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Patsogolo pace adasona magango ya nguwo ya azuli mphepete mwa kolotina yakumalizira yamkati, za kolotina zakuyamba zamkati, adacita bzibodzi-bodzi na zaciwiri. ");
INSERT INTO nyu_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Adakondza pomwe magango makumi maxanu (50) ku kolotina yakuyamba ya m'kati ndipo magango makumi maxanu (50) ku makolotina yaciwiri ya m'kati. Magangoyo yakhadanyang'anisana linango na yandzace. ");
INSERT INTO nyu_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Patsogolo pace adakondza ngoloweko makumi maxanu (50) za oro ndipo na izo adaphatisira makolotina yam'kati na yanango, kuti Cikumbi ca Mipembo cikhale cinthu cibodzi. ");
INSERT INTO nyu_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Adakondzambo makolotina ya ukuse bwa mbuzi yakukwanira khumi na libodzi (11) kuti asvimphirire Cikumbi ca Mipembo. ");
INSERT INTO nyu_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Makolotina ya m'kati khumi na libodzi (11) yakhana mphimo ibodzi-bodzi: Muutali mwace mukhana metru khumi na zitatu na meya (13.5 m), muufupi mwace mukhana metru ibodzi na sentimetru makumi masere (1.80 m). ");
INSERT INTO nyu_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Adamanga makolotina ya m'kati maxanu pabodzi ndipo yanango matanthatu payokha. ");
INSERT INTO nyu_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Patsogolo pace adakondza magango makumi maxanu (50) m'mphepete mwa kolotina ya m'kati yakumalizira pa ibodzi ya iyo, napombo m'mphepete mwa kolotina ya m'kati yakumalizira ya inangoyo. ");
INSERT INTO nyu_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Adakondza pomwe ngoloweko makumi maxanu (50) za burondze kuti ziphatanidze Cikumbi, kuti cikhale cinthu cibodzi. ");
INSERT INTO nyu_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Patsogolo pace adakondza cakusvimphirisa ca makhanda ya bvululume yakupalangiridwa mtoto ufuira, ndipo padzulu pace cakusvimphirisa ca khanda lakufewa. ");
INSERT INTO nyu_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Adakondza pomwe matabwa ya muti wa akasiya yakuimisa Cikumbi Ca Mipembo. ");
INSERT INTO nyu_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Tabwa ibodzi ikhana metru zinai na meya (4.5 m) muutali ndipo na sentimetru makumi manomwe (70) muufupi, ");
INSERT INTO nyu_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","na bzakulumikidzira bziwiri bzakuyenda kubodzi-bodzi cibodzi na cindzace. Ndipo adalumikidza matabwayo yentse pa Cikumbi ca Mipembo. ");
INSERT INTO nyu_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Adalumikidza pomwe matabwa makumi mawiri (20) kumphimpha ya kunyantsi kwa Cikumbi ca Mipembo, ");
INSERT INTO nyu_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","na matsinde makumi manai (40) ya parata kuti yaikhidwe pantsi pace, matsinde mawiri pa tabwa ibodzi, libodzi kuntsi kwa cakulumikidzira. ");
INSERT INTO nyu_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Kumphimpha inango, mbali ya kucitunthu kwa Cikumbi ca Mipembo, adalumikidza matabwa makumi mawiri (20), ");
INSERT INTO nyu_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","na matsinde makumi manai (40) ya parata, mawiri pantsi pa tabwa iri-yentse. ");
INSERT INTO nyu_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Adalumikidza pomwe matabwa matanthatu kumbali ya kumbuyo kwa Cikumbi ca Mipembo, komwe ni kumbali ya kumadokero, ");
INSERT INTO nyu_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ndipo bzakulumikidzira bziwiri bzidaikhidwa m'magonyo mwa Cikumbi ca Mipembo kumbali ya kumbuyo kwacene. ");
INSERT INTO nyu_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","M'magonyo mawiriya matabwa yace yakhali yakuphatana, kuyambira pantsi mpaka mungoloweko ya kudzulu, iyo yentse yakhadakondzedwa bzibodzi-bodzi. ");
INSERT INTO nyu_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Na tenepo pakhana matabwa masere na matsinde khumi na matanthatu (16) ya parata, mawiri kuntsi kwa tabwa ibodzi na ibodzi. ");
INSERT INTO nyu_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Adakondza pomwe mitanda ya muti wa akasiya: Maxanu kumatabwa ya mbali ibodzi ya Cikumbi, ");
INSERT INTO nyu_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","maxanu kumbali inango ndipo maxanu kumbali ya kumadokero, kumbali ya kumbuyo kwa Cikumbi. ");
INSERT INTO nyu_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Adakondza m'tanda wa pakati ukhacokera kwakuyamba kukafika kuphampha ukhapita na pakati pa matabwa. ");
INSERT INTO nyu_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Adapalangira oro matabwa ndipo adakondza ngoloweko za oro kuti zirimbise mitandayo, yomwe adapalangirambo oro. ");
INSERT INTO nyu_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Adakondza nguwo yabwino yakulukidwa na usalu bwa nguwo ya azuli, ya roxo na ifuira, ndipo adakasonesa bzithundzi-thundzi bza makerubini pamwepo. ");
INSERT INTO nyu_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Adaikondzera mbiru zinai za muti wa akasiya acizipalangira oro. Adakondza pomwe ngoloweko zace za oro ndipo adasungunusa matsinde ya parata ya mbiruzo. ");
INSERT INTO nyu_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Pakupitira muCikumbi adasona kolotina ya nguwo yabwino yakulukidwa na usalu bwa nguwo ya azuli, ya roxo na ifuira, basa la nyakusonerera, ");
INSERT INTO nyu_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ndipo adaikondzera mbiru zixanu na ngoloweko. Mbiruzo adazipalangira oro padzulu na m'mbali mwace ndipo adakondza matsinde yace maxanu ya burondze. ");
INSERT INTO nyu_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleri adakondza Kaxa na muti wa akasiya, ya metru ibondzi na sentimetru khumi (1.10 m) muutali, sentimetru makumi manomwe (70) ya muufupi ndipo sentimetru makumi manomwe (70) ya mukutalimpha. ");
INSERT INTO nyu_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Adaipalangira oro caiyo, m'kati na kunja, ndipo adaikha mthemba wa oro m'mphepete mwace. ");
INSERT INTO nyu_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Adaisungunusira aligola zinai za oro aciziikha m'minyendo yace minai, na aligola ziwiri mbali iyi ziwiri mbali inango. ");
INSERT INTO nyu_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Patsogolo pace adakondza tumitanda tuwiri twa muti wa akasiya, acitupalangira oro ");
INSERT INTO nyu_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ndipo adatuikha mualigola za m'mbali ya Kaxa kuti ikwanisike kunyamulidwa. ");
INSERT INTO nyu_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Adakondza cakugwanankhirira ca cakutetererera ca oro caiyo ca metru ibodzi na sentimetru khumi (1.10 m) ya muutali na sentimetru makumi manomwe (70) ya muufupi. ");
INSERT INTO nyu_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Adakondza pomwe akerubi awiri wa oro yakumenyedwa m'mphepete mwa cakugwanankhiriraco. ");
INSERT INTO nyu_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Adakondza kerubi m'bodzi m'mphepete mwa mbali ibodzi ndipo yaciwiri kumbali inango, cicikhala cinthu cibodzi na cakugwanankhirira cire. ");
INSERT INTO nyu_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Akerubiwo maphaphidwe yawo akhadafuthulira padzulu, yacimpsinkha cakugwanankhiriraco. Iwo akhadanyanganisana wina na mwandzace, nkhope zawo zikhadanyanganisana pa cakugwanankhirirapo. ");
INSERT INTO nyu_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Adakondza meza na muti wa akasiya ya sentimetru makumi mapfemba (90) muutali mwace, sentimetru makumi manai na maxanu (45) muufupi mwace ndipo sentimetru makumi manomwe (70) kutalimpha kwace. ");
INSERT INTO nyu_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Adaipalangira oro caiyo ndipo adakondza cakuphatisira ca oro m'mphepete mwace. ");
INSERT INTO nyu_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Adakondza pomwe m'mphepete mwace mkokoto wa mphimo ya sentimetru zinomwe na mthemba wa oro wa mkokotowo. ");
INSERT INTO nyu_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Adasungunusa aligola zinai za oro za meza ndipo adazimangirira mumbali zinai momwe mukhana minyendo yace minai. ");
INSERT INTO nyu_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Aligola zidamangiriridwa pafupi na mkokoto kuti ziphatirise tumitanda twakunyamulira meza. ");
INSERT INTO nyu_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Adakondza tumitanda twakunyamulira meza twa muti wa akasiya, twakupalangiridwa oro. ");
INSERT INTO nyu_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ndipo na oro caiyo adakondza bzombo bza meza: Ndiro zace, bzakuikhira ntsembe zakununchira, tumbale na ntsambidwe zomwe zimbaikhidwa bzakupereka bzakumwa. ");
INSERT INTO nyu_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Adakondza pomwe cakukhazikira bziphaniphani bza oro caiyo yakusula na nyundo. Tsinde lace mwendo wace, bzakumwera bzace, maluwa yace na mabutau ya bziphaniphani ciphatane kuti cikhale citsulo cibodzi. ");
INSERT INTO nyu_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Mithawi mitanthatu idacoka pa cakukhazikira bziphaniphani: Mitatu pa mbali ibodzi mitatu pa mbali inango. ");
INSERT INTO nyu_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Pa mithawi mitanthatu ire, ubodzi na ubodzi ukhana bzakumwera bzitatu bzakukhala ninga dziruwa la muti wakucemeredwa mtowe uliwentse ukhana butau na dziluwa. ");
INSERT INTO nyu_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Pamwendo pa cakukhazikira bziphaniphani pakhana bzakumwera bzinai bza kuwoneka ninga dziruwa la mtowe, cibodzi na cibodzi cikhana dziruwa na butau. ");
INSERT INTO nyu_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Pakhana butau kuntsi kwa bziwiri-bziwiri pa mithawi mitanthatu ire yomwe ikhacokera ku mwendo wa cakukhazikira bziphaniphani. ");
INSERT INTO nyu_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Mithawi na mabutau yace bzikhakhala cinthu cibodzi na cakukhazikira bziphaniphani, bzentse bzikhadakondzedwa na oro caiyo yakusulidwa na nyundo. ");
INSERT INTO nyu_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Adakondza bziphaniphani bzinomwe na oro caiyo, na bzakugwatisa bzace na bzakuwolerera dotha bzace. ");
INSERT INTO nyu_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Pakukondza cakukhazikira bziphaniphani na bzakuphatisira basa bzace adadzonga kiru makumi matatu na zixanu (35 kg) za oro caiyo. ");
INSERT INTO nyu_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Adakondza pomwe guwa la ntsembe yakununchira la muti wa akasiya. Likhali la magonyo manai yakulingana, mbali ibodzi na ibodzi ikhali na sentimetru makumi manai na zixanu (45) ndipo kutalimpha kwace likhana sentimetru makumi mapfemba (90). Ndipo magonyoyo ikhaphatana na guwa cicikhala cinthu cibodzi. ");
INSERT INTO nyu_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Adalipalangira oro caiyo kumbali yadzulu na mbali mwentse napombo m'magonyo, ndipo adasonerera mkokoto wa oro m'mphepete mwace. ");
INSERT INTO nyu_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Adakondza pomwe mphete ziwiri za oro pa mbali ibodzi na ibodzi ya guwa mnyantsi mwa mkokoto, kuti ziphate mitanda yakulinyamulisa, ");
INSERT INTO nyu_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ndipo adaphatisira basa muti wa akasiya kuti akondze mitanda ndipo adaipalangira oro. ");
INSERT INTO nyu_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Adakondza pomwe mafuta yakucena ya kudzozera na ntsembe yakununchira bwino, basa la misiri wakusanganiza bzakununchira. ");
INSERT INTO nyu_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Adakondza guwa la ntsembe yakutentha la muti wa akasiya, la metru ibodzi na sentimetru makumi matatu na zixanu (1.35 m) kutalimpha kwace. Likhali la magonyo manai yakulingana ya metru ziwiri na sentimetru makumi mawiri na zixanu (2.25 m) pa mbali iri-yentse. ");
INSERT INTO nyu_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ndipo adakondza cinthu cakutengana na nyanga mbali zentse zinai, bzicikhala cinthu cibodzi na guwa comwe adacipalangira na burondze. ");
INSERT INTO nyu_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Adakondza bzombo bzace bzentse na burondze: Bzombo bza kuwolera dotha, foxolo, ntsambidwe za kumwazirira, magalufu ya nyama na bzakucosera masimbe ya moto. ");
INSERT INTO nyu_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Adakondzera guwalo utawo bwa burondze bwakukhala ninga sefa m'nyantsi mwa guwa, mpaka kati na kati ya guwa. ");
INSERT INTO nyu_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Adasungunusa mphete zinai za burondze kuti ziphatisire mitanda m'mbali zinai za utawo bwa burondze. ");
INSERT INTO nyu_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Adakondza mitanda ya muti wa akasiya aciipalangira na burondze, ");
INSERT INTO nyu_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ndipo adaiikha mphete, m'mbali ziwiri za guwa, kuti akwanise kulinyamula. Guwalo lidakondzedwa na matabwa ndipo likhadagoba. ");
INSERT INTO nyu_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Adakondza ntsambidwe ya burondze na cakukhazikira cace na bziwonero bza akazi omwe akhatumikira pa msuwo wa Cikumbi ca Kugumanirana. ");
INSERT INTO nyu_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Adakondza pomwe cimtalo. Mbali ya kunyantsi cikhana metru makumi manai na zixanu (45 m) muutali, ndipo kolotina zakunja za nguwo yabwino yakulukidwa, ");
INSERT INTO nyu_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","mphanda makumi mawiri (20) na matsinde makumi mawiri (20) ya burondze, ngoloweko na bzakulumikidzira bza parata pa mphanda. ");
INSERT INTO nyu_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Mbali yakucitunthu cikhana metru makumi manai na zixanumbo (45 m) muutali, mphanda makumi mawiri (20 m) na matsinde ya burondze makumi mawiri (20). Ngoloweko na bzakulumikidzira mphanda bzikhali bza parata. ");
INSERT INTO nyu_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Kumbali ya kumadokero kukhana makolotina ya kunja yakhana metru makumi mawiri na ziwiri na meya (22.5 m) muufupi, mphanda khumi (10) na matsinde khumi (10), ngoloweko na bzakulumikidzira bza parata pa mphanda. ");
INSERT INTO nyu_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Mbali ya kumabva-dzuwa komwe ni kumacenero kun'dzakhalambo na metru makumi mawiri na ziwiri na ina-pakati (22.5 m) muufupi. ");
INSERT INTO nyu_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Pakhana kolotina za metru zitanthatu na sentimetru makumi manomwe na zixanu (6.75 m) muutali mbali ibodzi ya kupitira, mphanda zitatu na matsinde yace matatu, ");
INSERT INTO nyu_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ndipo kolotina za metru zitanthatu na sentimentru makumi manomwe na maxanu (6.75 m) ya muutali ku mbali ina yakupitira kucimtalo, yakhanazombo mphanda zitatu na matsinde yace matatu. ");
INSERT INTO nyu_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Kolotina zentse za mumbali mwa cimtalo, zikhali zakukondzedwa na nguwo yabwino yakulukidwa. ");
INSERT INTO nyu_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Matsinde ya mphanda yakhali ya burondze. Ngoloweko na bzakuphatanidzira bza mphanda bzikhali bza parata, ndipo pakumalizira pa mphanda ikhadapalangidwambo na parata. Mwakuti mphanda zentse za cimtalo zikhana bzakuphatanidzira bza parata. ");
INSERT INTO nyu_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Pakupitira pa cimtalo pakhana kolotina ya nguwo yabwino yakulukidwa na usalu bwa nguwo ya azuli, ya roxo na ifuira, basa la misiri wakusonerera. Ikhana metru zipfemba muutali mwakulinganirana na kolotina ya cimtalo, yakhana metru ziwiri na sentimetru makumi mawiri na zixanu (2.25 m) kutalimpha, ");
INSERT INTO nyu_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","mphanda zinai na matsinde manai ya burondze, ngoloweko zace na bzakuphatanidzira bzikhali bza parata, ndipo padzulu pa mphanda pakhadapalangiridwambo na parata. ");
INSERT INTO nyu_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Bzakukhomereresa bzentse bza Cikumbi ca Mipembo na bza cimtalo comwe cikhacizungulira, bzikhali bza burondze. ");
INSERT INTO nyu_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Uyu ni ndandanda wa bzinthu bzomwe bzin'funika pakumanga Cikumbi ca Mipembo, comwe ni Cikumbi ca Cipangano. Mozeji adauza dzindza la Levi kucita ndandanda wa bzinthubzo, mwakutsogoleredwa na Itamar, mwana wa wantsembe Aloni. ");
INSERT INTO nyu_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleri mwana wa Uri, m'zukulu wa Huri, wa dzindza la Juda, adacita bzentse bzomwe Mbuya akhadauza Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ndipo akhali pabodzi na Awoliyabe, mwana wa Aizamaki, wa dzindza la Dani, misiri, wakunemba ndipombo na wakusona nguwo yabwino na usalu bwa nguwo ya azuli, ya roxo na ifuira. ");
INSERT INTO nyu_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Oro yentse yomwe idatambiridwa pa bzakupereka mwa ufulu kuti bziphatisidwe basa pakukondza mbuto yakucenayo, ikhali ya kiru culu (1,000 kg), malinge na mphimo yace caiyo ya mbuto yakucena. ");
INSERT INTO nyu_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Kulemera kwa parata yomwe idatambiridwa kuna omwe adalewengedwa pa kanembera wa mbumba idakhala yakuposa kiru bzulu bzitatu na madzana maxanu (3,500 kg), kucokera ku mphimo caiyo yambuto yakucena: ");
INSERT INTO nyu_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Grama zitanthatu (6 g) kwa mbodzi na mbodzi omwe adanembedwa, ndiko kulewa kuti bzulu madzana matanthatu na bzitatu na madzana maxanu na makumi maxanu (603.550) ya amuna kuyambira wa magole makumi mawiri (20) kuyenda kutsogolo. ");
INSERT INTO nyu_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Kiru bzulu bzitatu na madzana maxanu (3,500 kg) za parata zidaphatisidwa basa la kusungunusa kwa matsinde ya mbuto yakucena na nguwo yakugwatira: Matsinde dzana libodzi (100) yakukondzedwa na kiru bzulu bzitatu na madzana maxanu (3,500 kg), kiru makumi matatu na zixanu (35) pa tsinde libodzi na libodzi. ");
INSERT INTO nyu_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Kiru makumi mawiri na garama madzana matatu (20.3 kg) yadaphatisidwa basa pakukondza ngoloweko za mphanda, kuti apalangire cipande cakudzulu ca mphanda ndipo kuti akondze mwakulumikidzira. ");
INSERT INTO nyu_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Kulemera kwa burondze yomwe idaperekedwa ikhali ya kiru bzulu bziwiri na madzana maxanu (2,500 kg). ");
INSERT INTO nyu_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Iye adaiphatisa basa pakukondza matsinde ya pakupitira muCikumbi ca Kugumanirana, guwa la burondze, utawo bwace na bzakuphatisira basa bzace bzentse, ");
INSERT INTO nyu_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","matsinde ya cimtalo mwakuzungulira mwentse na pakupitira, ndipo nkhokho zentse za Cikumbi ca Mipembo ndipo za cimtalo cakuzungulira Cikumbico. ");
INSERT INTO nyu_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Na usalu bwa nguwo ya azuli, ya roxo na ifuira, adasona bzakubvala bza misinda kuti ambacitire nabzo basa mumbuto yakucena. Adasonambo bzakubvala bzakucenesedwa bza Aloni, ninga momwe Mbuya akhadauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Adasona koleti ya untsembe ya nguwo yabwino yakulukidwa na usalu bwa oro, na usalu bwa nguwo ya azuli, ya roxo na ifuira. ");
INSERT INTO nyu_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ndipo adasula oro tumapalaka tutete tomwe adagwata-gwata kuti asonerere pa nguwo yabwino, na usalu bwa nguwo ya azuli, ya roxo na ifuira, basa la misiri. ");
INSERT INTO nyu_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Adakondza mirau ya koleti ya untsembe, yakumangirira m'mphepete mwace muwiri kuti zikwanisike kumangika. ");
INSERT INTO nyu_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Bhande na koleti bzakuphatana bzidacitidwa na cinthu cibodzi. Bhandero lidakondzedwambo na nguwo yabwino yakulukidwa, na usalu bwa oro na usalu bwa nguwo ya azuli, ya roxo na ifuira, ninga momwe Mbuya akhadauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Adamangirira minyala ya onikisi mubzakuphatisira bza oro, pa minyalayo adadhinda madzina ya aIjirayeri, ninga momwe ambacitira misiri wakugoba cidhindo. ");
INSERT INTO nyu_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Pamwepo adaisonerera m'mapewa mwa koleti ya wantsembe ninga minyala yacikumbuso kwa aIjirayeri, ninga momwe Mbuya akhadauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Capacifuwa cidakondzedwa ninga koleti ya untsembe, basa la misiri. Cidakondzedwa na nguwo yabwino yakulukidwa, na usalu bwa oro, na usalu bwa nguwo ya azuli, ya roxo na ifuira. ");
INSERT INTO nyu_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Cikhali ca magonyo manai ndipo cakufunya kawiri, mbali zentse zikhana mphimo ya sentimetru makumi mawiri na mawiri (22). ");
INSERT INTO nyu_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Patsogolo pace, adaikha mifolo minai ya minyala yakufunika. Pa mfolo wakuyamba pakhana mwala wa rubi ubodzi, wa topazio ubodzi na wa berilo ubodzi. ");
INSERT INTO nyu_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Pa mfolo waciwiri pakhana mwala wa tulikeza ubodzi, wa safira ubodzi na wa diyamante ubodzi. ");
INSERT INTO nyu_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Pa mfolo wacitatu pakhana mwala wa jasinto ubodzi, wa agata ubodzi na wa ametixta ubodzi. ");
INSERT INTO nyu_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Pa mfolo wacinai pakhana mwala wa kirizolito ubodzi, wa onikisi ubodzi na wa jaxpe ubodzi, bzentse bzikhadakhazikisidwa pa cakuphatisira ca oro. ");
INSERT INTO nyu_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Pakhana minyala khumi na miwiri (12), mwala ubodzi pa dzina liri-rentse la aIjirayeri. Minyalayo ikhadagobedwa ninga momwe ambacitira misiri wakugoba cidhindo, ubodzi na ubodzi ukhana dzina libodzi la madzindza khumi na mawiri. ");
INSERT INTO nyu_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Kwa capacifuwa adakondza unyolo bwakulukidwa bwa oro caiyo ninga cingwe. ");
INSERT INTO nyu_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Adakondza bzakuphatisira bziwiri bza oro na magango mawiri yomwe adaphatanidzira m'mapewa mwa capacifuwa. ");
INSERT INTO nyu_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Kwakumalizira kwa maunyolo mawiri ya oro yale adamangirira m'magango mawiri m'mapewa mwa capacifuwa, ");
INSERT INTO nyu_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ndipo kwakumalizira kwinango adamangirira mubzakuphatisira bziwiri, bzomwe bzidalumikidza m'mapewa ya koleti ya untsembe kumbali ya kutsogolo. ");
INSERT INTO nyu_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Adakondza pomwe magango mawiri ya oro ndipo adayamangirira m'mapewa mwa capacifuwa, mucakusonerera m'kati pafupi na koleti ya untsembe. ");
INSERT INTO nyu_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Patsogolo pace adakondza pomwe magango mawiri ya oro, ndipo adayamangirira mbali ya kuntsi kwa mirau kutsogolo kwa koleti ya untsembe, pafupi na msono, padzulu pa bhande la koleti ya untsembe. ");
INSERT INTO nyu_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Adamangirira magango ya capacifuwa, kumagango ya koleti na cingwe cakubiriwira, aciciphatanidza na bhande, kuti capacifuwa cireke kulekerana na koleti ya untsembe, ninga momwe Mbuya akhadauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Adasona manto ya koleti ya untsembe ya usalu bwa nguwo ya azuli basi, basa la wakusona, ");
INSERT INTO nyu_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","pakati pace pakhadafunguka. Mwakuzungulira mwace akhadafunya acisona ninga gola, kuti lireke kung'ambika. ");
INSERT INTO nyu_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Adasonerera bzisapo bzakucemeredwa roma na usalu bwa nguwo ya azuli, ya roxo na ifuira m'mphepete mwa manto. ");
INSERT INTO nyu_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Adakondza pomwe tungwinjiri twa oro caiyo, acitumangirira m'mphepete mwa msono pakati pa bzisapobzo. ");
INSERT INTO nyu_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Tungwijirito na roma bzikhapitana-pitana, mwakuzungulira msono wentse wa manto. Bzentse bzidakondzedwa kuti bzibvalidwe pakutumikira, ninga momwe Mbuya akhadauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Kuna Aloni na wana wace adawasonera mabatina ya nguwo yabwino, basa la wakusona, ");
INSERT INTO nyu_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ndipo turbante, gorros na makabudula bza nguwo yabwino yakulukidwa. ");
INSERT INTO nyu_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Bhande likhali la nguwo ya seda yakuposa na usalu bwa nguwo yakubiwirira, ya roxo na ifuira, basa la nyakuluka ninga momwe Mbuya akhadauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Adakondzambo ntsinga-msolo yakucena ya oro caiyo, ndipo adanemba mwa iyo ninga ambanembera cidhindo: Cakupambulidwa kuna Mbuya. ");
INSERT INTO nyu_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Patsogolo pace adacimangirira na cingwe cakubiriwira pa mbali ya kudzulu kwa turbante, ninga momwe Mbuya akhadauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Na tenepo, adamaliza basa lentse la kukondza Cikumbi ca Mipembo, Cikumbi ca Kugumanirana. AIjirayeri adacita bzentse ninga momwe Mbuya akhadauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Pamwepo adabweresa Cikumbi ca Mipembo kuna Mozeji. Cikumbico cikhana makolotina, bzombo bza Cikumbi bzentse, ngoloweko, matabwa, mitanda, mphanda na matsinde. ");
INSERT INTO nyu_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Cikhana pomwe cakusvimphirira ca makhanda ya bvululume yakupalangiridwa mtoto ufuira, cakusvimphirira ca makhanda yakufewa, na nguwo yakuchinjiridzira. ");
INSERT INTO nyu_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Cikhana pomwe Kaxa ya Cipangano, mitanda yace, cakugwanankhirira, ");
INSERT INTO nyu_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","meza na bzombo bzace bzentse ndipo na pau zakuperekedwa kuna Mulungu. ");
INSERT INTO nyu_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Cikhana pomwe cakukhazikira bziphaniphani bza oro caiyo, bziphaniphani mwa ndandanda wace, bzombo bzace bzentse, na mafuta ya kubvunikira. ");
INSERT INTO nyu_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Cikhana pomwe guwa la oro, mafuta ya kudzozera, ntsembe yakununchira bwino na kolotina ya pakupitira mu Cikumbi. ");
INSERT INTO nyu_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Cikhana pomwe guwa la burondze, utawo bwace, mitanda yace, bzombo bzace bzentse, ntsambidwe na cakukhazikira cace. ");
INSERT INTO nyu_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Cikhana pomwe makolotina ya cimtalo, mphanda zace, matsinde yace ndipo kolotina ya pakupitira mucimtalo, bzingwe na nkhokho za cimtalo, na bzombo bzentse bza Cikumbi, Cikumbi ca Kugumanirana. ");
INSERT INTO nyu_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Cikhana pomwe bzakubvala bza misinda bza kuphatira basa mumbuto yakucena, napo bzakubvala bzakucenesedwa bza wantsembe Aloni, ngakhale bzakubvala bza wana wace, pomwe an'tumikira ninga wantsembe. ");
INSERT INTO nyu_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","AIjirayeri adacita basa lentse ninga momwe Mbuya adauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mozeji adawona basa lentse, ndipo adawona kuti akhadalicita ninga momwe Mbuya akhadamuuzira. Pamwepo Mozeji adawadalisa. ");
INSERT INTO nyu_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Mbuya adauza Mozeji kuti: ");
INSERT INTO nyu_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Imisa Cikumbi ca Mipembo, Cikumbi ca Kugumanirana ntsiku yakuyamba ya mwezi wakuyamba. ");
INSERT INTO nyu_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","M'mwemo uikhe Kaxa ya Cipangano ndipo uimpsinkhe na nguwo. ");
INSERT INTO nyu_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Bweresa meza ndipo uikhe padzulu pace bzinthu bzentse bzomwe ni bzace. Patsogolo pace bweresa cakukhazikira bziphaniphani ndipo uikhe bziphaniphani bzace. ");
INSERT INTO nyu_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ikha guwa la oro la ntsembe yakununchira patsogolo pa Kaxa ya Cipangano ndipo uikhe kolotina pakupitira pa Cikumbi ca Mipembo. ");
INSERT INTO nyu_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Ikha guwa la ntsembe yakutentha kutsogolo kwa pakupitira pa Cikumbi ca Mipembo, pa Cikumbi ca Kugumanirana. ");
INSERT INTO nyu_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ikha ntsambidwe pakati pa Cikumbi ca Kugumanirana na guwa, ndipo uidzaze madzi. ");
INSERT INTO nyu_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ukondze cimtalo cakuzungulira Cikumbico ndipo uikhe kolotina pakupitira pa cimtaloco. ");
INSERT INTO nyu_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Dzoza na mafuta ya kudzozera Cikumbi ca Mipembo na bzentse bzomwe bziri m'mwemo, ucicenese na bzombo bzace bzentse, ndipo cin'dzakhala cakucena. ");
INSERT INTO nyu_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Patsogolo pace dzoza guwa la kutenthera ntsembe na bzombo bzace bzentse. Cenesa guwalo ndipo lin'dzakhala lakucena kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Dzozambo ntsambidwe na cakukhazikira cace ndipo uicenese. ");
INSERT INTO nyu_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Bweresa Aloni na wana wace pakupitira pa Cikumbi ca kugumanirana ndipo uwauze akasambe. ");
INSERT INTO nyu_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Patsogolo pace bvazika Aloni bzakubvala bzakucenesedwa, umudzoze ndipo umucenese kuti anditumikire ninga wantsembe. ");
INSERT INTO nyu_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Udzabweresembo wana wace ucidzawabvazika mabatina, ");
INSERT INTO nyu_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Adzoze ninga momwe udadzozera baba wawo kuti iwo anditumikire ninga azibaba wa ntsembe. Kudzozedwa kwawo kun'dzakhala kwa untsembe bwakusaya kumala, kwa mibadwe na mibadwe”. ");
INSERT INTO nyu_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mozeji adacita bzentse ninga momwe MBYUA akhadamuuzira. ");
INSERT INTO nyu_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Na tenepo, Cikumbi ca Mipembo cidaimisidwa pantsiku yakuyamba ya mwezi wakuyamba wa gole laciwiri. ");
INSERT INTO nyu_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mozeji adaimisa Cikumbi ca Mipembo, aciikha matsinde mumbuto mwace, adaimisa matabwa adaikha mitanda ndipo adaimisa mphanda. ");
INSERT INTO nyu_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Patsogolo pace adapfuthula makolotina padzulu pa Cikumbi ndipo adaikha cakusvimphirira padzulu pace, ninga momwe Mbuya akhadauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Adaikhambo matabwa ya Cipangano m'kati mwa Kaxa, adaikha mitanda yakunyamulira Kaxa mumbuto mwace, ndipo adaikha cakugwanankhirira padzulu pace. ");
INSERT INTO nyu_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Patsogolo pace adapitisa Kaxa ya Cipangano m'kati mwa Cikumbi ca Mipembo ndipo adamanika nguwo yakugwatisira, acimpsinkha Kaxa ya Cipangano, ninga momwe Mbuya akhadauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mozeji adaikha meza muCikumbi ca kugumanirana kumbali ya kucitunthu kwa Cikumbi ca Mipembo, mbali ya kunja kwa nguwo yakugwatisira, ");
INSERT INTO nyu_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ndipo padzulu pa meza adaikha pau zakuperekedwa kuna Mulungu pamaso pa Mbuya ninga momwe Mbuya akhadamuuzira. ");
INSERT INTO nyu_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Adaikha cakukhazikira bziphaniphani muCikumbi ca kugumanirana patsogolo pa meza, ku mbali ya kunyantsi kwa Cikumbi ca Mipembo, ");
INSERT INTO nyu_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ndipo adaikha bziphaniphani patsogolo pa Mbuya, ninga momwe Mbuya akhadamuuzira. ");
INSERT INTO nyu_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mozeji adaikhambo guwa la oro muCikumbi ca Kugumanirana, patsogolo pa nguwo yakugwatisira, ");
INSERT INTO nyu_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ndipo paguwapo adatentha ntsembe yakununchira bwino, ninga momwe Mbuya akhadamuuzira. ");
INSERT INTO nyu_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Adaikhambo kolotina pakupitira muCikumbi ca Mipembo. ");
INSERT INTO nyu_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Adamanga guwa la ntsembe yakutentha pakupitira muCikumbi, Cikumbi ca Kugumanirana, ndipo adapereka ntsembe ya kutentha na ya ufa, ninga momwe Mbuya akhadamuuzira. ");
INSERT INTO nyu_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Adaikha ntsambidwe pakati pa Cikumbi ca Kugumanirana na guwa ndipo adaidzaza madzi. ");
INSERT INTO nyu_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mozeji, Aloni na wana wace akhambasamba na madziyo m'manja na m'minyendo. ");
INSERT INTO nyu_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Nthawe zentse zomwe iwo akhambapita muCikumbi ca Kugumanirana ndipo akhambafendera paguwa, iwo akhambasamba, ninga momwe Mbuya akhadauzira Mozeji. ");
INSERT INTO nyu_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Pakumalizira Mozeji adaimisa cimtalo mwakuzungulira Cikumbico na guwa ndipo adaikha kolotina pakupitira pa cimtaloco. Tenepoyo, Mozeji adamaliza basa lentse. ");
INSERT INTO nyu_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Pamwepo mtambo udampsinkha Cikumbi ca Kugumanirana ndipo ukulu bwa Mbuya budadzala muCikumbimo. ");
INSERT INTO nyu_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mozeji alibe kukwanisa kupita muCikumbi ca Kugumanirana, thangwe mtambo ukhacimpsinkha ndipo ukulu bwa Mbuya bukhadzala muCikumbi ca Mipembo. ");
INSERT INTO nyu_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Nthawe zentse zomwe mtambo ukhakwira kucokera paCikumbi ca Mipembo, aIjirayeri akhambaguduka ulendo bwawo. ");
INSERT INTO nyu_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Tsono pomwe mtambo ukhakwira lini, iwo akhambaguduka lini. Akhambaguduka pantsiku yomwe iwo ukhakwira. ");
INSERT INTO nyu_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Pa maulendo yawo yentse iwo akhambawona mtambo wa Mbuya. Masikati mtamboyo ukhakhala padzulu pa Cikumbi ca Mipembo, ndipo usiku mum'tambomo mukhambagaka moto, ucimbawoneka kwa mbumba yentse ya Ijirayeri.");
INSERT INTO nyu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","M'ndandanda wa makolo ya Jezu Krixtu dzindza la Davidi, dzindza la Abrahamu ni iri. ");
INSERT INTO nyu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamu adabereka Izaki, Izaki adabereka Jakobo, na Jakobo adabereka Juda na abale wace. ");
INSERT INTO nyu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda adabereka Perezi na Zera, omwe mai wawo akhali Tamara, Perezi adabereka Heziramu, na Heziramu adabereka Aramu. ");
INSERT INTO nyu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramu adabereka Aminadabi, Aminadabi adabereka Nasoni, na Nasoni adabereka Salimoni. ");
INSERT INTO nyu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni adabereka Bowazi, omwe mai wace akhali Rahabe, Bowazi adabereka Obedi, omwe mai wace akhali Ruti, na Obedi adabereka Jese. ");
INSERT INTO nyu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese adabereka mambo Davidi. Davidi adabereka Solomoni, omwe mai wace akhali mkazi wa Uriya. ");
INSERT INTO nyu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni adabereka Robohamu, Robohamu adabereka Abiyasi, na Abiyasi adabereka Asa. ");
INSERT INTO nyu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa adabereka Josafati, Josafati adabereka Joramu, na Joramu adabereka Uziyasi. ");
INSERT INTO nyu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziyasi adabereka Jotamu, Jotamu adabereka Akazi, na Akazi adabereka Ezekiya. ");
INSERT INTO nyu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiya adabereka Manasi, Manasi adabereka Amoni, na Amoni adabereka Josiya. ");
INSERT INTO nyu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiya adabereka Jekoniya na abale wace, panthawe yomwe adaphatidwa aciyendesedwa kuBabironya. ");
INSERT INTO nyu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Atayendesedwa kuBabironya, patsogolo pace: Jekoniya adabereka Salatiyeri, na Salatiyeri adabereka Zorobaberi. ");
INSERT INTO nyu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobaberi adabereka Abiyudi, Abiyudi adabereka Eriyakimu, na Eriyakimu adabereka Azoli. ");
INSERT INTO nyu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli adabereka Sadoki, Sadoki adabereka Akimu, na Akimu adabereka Eriyudi. ");
INSERT INTO nyu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriyudi adabereka Ereyazari, Ereyazari adabereka Matani, na Matani adabereka Jakobo. ");
INSERT INTO nyu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakobo adabereka Zuze, mwamuna wa Maliya, omwe adabala Jezu, omwe an'cemeredwa Krixtu. ");
INSERT INTO nyu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tenepoyo mibadwe yentse kuyambira Abrahamu mpaka Davidi ikhali khumi na minai (14), khumi na minai (14) kuyambira Davidi mpaka nthawe yomwe aIjirayeri adatengedwa unyagirinya kuyenda kuBabironya, ndipo khumi na minai (14) kuyambira nthawe yomwe aIjirayeri adatengedwa unyagirinya kuyenda kuBabilonya mpaka Krixtu. ");
INSERT INTO nyu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kubadwa kwa Jezu Krixtu kudacitika tenepayu: Maliya mai wace akhadabvundziridwa na Zuze, tsono akanati kukhala pabodzi adagumanika na pathupi kudzera mumphambvu ya Mzimu Wakucena. ");
INSERT INTO nyu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ndipo Zuze mwamuna wace akhali wakulungama alibe kufuna kumululisa, na tenepo akhafuna kumuleka mwakabise-bise. ");
INSERT INTO nyu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ndipo pomwe akhakumbuka bzimwebzi, anju wa Mbuya adamuwonekera mukulota acimuuza kuti: “Zuze, mwana wa Davidi, leka kubva mantha kutambira Maliya kukhala mkazi wako, nakuti pathupi pomwe anapo ni pakudzera mwa Mzimu Wakucena. ");
INSERT INTO nyu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iye an'dzabala mwana wa mwamuna ndipo iwepo un'dzam'pasa dzina lakuti Jezu, thangwe Iye an'dzapulumusa mbumba yace mubzakuphonyera Mulungu bzawo”. ");
INSERT INTO nyu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bzentsenebzi bzidacitika kuti bzikwanirisidwe bzomwe Mbuya adalewa kudzera mwa m'polofita: ");
INSERT INTO nyu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Dende lin'dzakhala na mimba ndipo lin'dzabala mwana wa cimuna omwe mun'dzamucemera Emanuweri”, bzomwe bzinirewa: “Mulungu ali nafe”. ");
INSERT INTO nyu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pomwe Zuze adamuka adacita bzomwe anju wa Mbuya akhadamuuza ndipo adatambira Maliya kukhala mkazi wace, ");
INSERT INTO nyu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","tsono alibe kufambizana mpaka mwana kubadwa. Ndipo Zuze adam'pasa dzina lakuti Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jezu adabadwa mumzinda wa Belee cigawo ca Judeya, nthawe ya mambo Herodi. Jezu atabadwa, adziwi wa bzacirengedwe wa kumabvadzuwa adafika kuJerusalema, ");
INSERT INTO nyu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ndipo adabvundza aciti: “Alikuponi mambo wa aJuda omwe abadwa? Ife tawona nyenyezi yace kumabvadzuwa ndipopa tabwera kudzamupemba”. ");
INSERT INTO nyu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pomwe mambo Herodi adabva bzimwebzi adaneseka kwene-kwene, napombo wanthu wentse wa muJerusalema. ");
INSERT INTO nyu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pamwepo iye adatsonkhanisa akulu wa anyantsembe wentse na adziwi wa Mtemo wa mbumba, aciwabvundza kuti kodi Krixtu an'dzabadwira kuponi? ");
INSERT INTO nyu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iwo adatawira aciti: “Kumzinda wa Belee cigawo ca Judeya. Thangwe m'polofita adanemba tenepa: ");
INSERT INTO nyu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Iwe Belee wa dziko la Juda, ndiwe lini m'ng'ono na pang'onopo pakati pa mizinda mikulu ya Juda. Nakuti mwa iwe mun'dzacoka m'tsogoleri wakudzawusa aIjirayeri mbumba yangu’”. ");
INSERT INTO nyu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pamwepo Herodi adacemera adziwi wa bzacirengedwe wa kumabvadzuwa wale pambali, kuti adziwe nthawe caiyo yomwe idawoneka nyenyeziyo. ");
INSERT INTO nyu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Patsogolo pace adawatumiza kuBelee aciwauza kuti: “Ndokoni mukabvesese bza mwanayo. Mungakamuwona mundzandiuzembo kuti ndikam'pembembo”. ");
INSERT INTO nyu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ndipo iwo atamala kubva mambo, adapitiriza na ulendo bwawo, nyenyezi ire yomwe akhadawona kumabvadzuwa idayenda patsogolo pawo mpaka idakaima m'dzulu pambuto pomwe pakhana mwanayo. ");
INSERT INTO nyu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pomwe adawona nyenyeziyo, adakondwera acipfatsa kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Atapita munyumba, adawona mwana na Maliya mai wace, adagodama acim'pemba mwanayo. Patsogolo pace adafungula mabudu yawo acim'pasa mphatso zawo za: Oro, lubani na mafuta yakucemeredwa mira. ");
INSERT INTO nyu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ndipo Mulungu adawacenjeza mukulota kuti aleke kubwerera kuna Herodi, na tenepo iwo adabwerera kudziko kwawo na njira inango. ");
INSERT INTO nyu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Adziwi wale atabwerera, anju wa Mbuya adawoneka kuna Zuze mukulota ndipo adamuuza aciti: “Lamuka utenge mwana na mai wace uthawire kuIjipito. Ukakhale kumweko mpaka ine ndidzakuuze, thangwe Herodi an'dzanyang'ana mwanayo kuti amuphe”. ");
INSERT INTO nyu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Usiku bumwebo iye adalamuka acitenga mwanayo na mai wace, adaguduka aciyenda kuIjipito, ");
INSERT INTO nyu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","acikakhala kumweko mpaka kufa kwa Herodi. Tenepoyo bzidakwanirisidwa bzomwe Mbuya akhadalewa kudzera mwa m'polofita aciti: “Ndidacemera Mwana wangu kuti acoke kuIjipito”. ");
INSERT INTO nyu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pomwe Herodi adadziwa kuti akhadanamizidwa na adziwi wa bzacirengedwe wakumabvadzuwa, adakalipa kwene-kwene ndipo adatuma wanthu kuti akaphe wana wentse wacimuna wa magole mawiri mpaka matsece kuBelee na m'mphepete mwace. Iye adacita bzimwebzi malingana na cidziwiso comwe adatambira kuna adziwi wa bzacirengedwe wa kumabvadzuwa. ");
INSERT INTO nyu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na tenepo bzidakwanirisidwa bzomwe m'polofita Jeremiya akhadalewa aciti: ");
INSERT INTO nyu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kudabveka fala kuRama, kulira na kudandaula kukulu, akhali Rakeli omwe akhalira wana wace ndipo alikulamba kunyamalizidwa thangwe wana wace afa”. ");
INSERT INTO nyu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pomwe Herodi adafa, anju wa Mbuya adawonekera kuna Zuze mukulota kuIjipito, ");
INSERT INTO nyu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","adamuuza aciti: “Lamuka tenga mwana na mai wace uyende kudziko la Ijirayeri, nakuti wale omwe akhafuna kupha mwanayo adafa”. ");
INSERT INTO nyu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iye adalamuka acitenga mwana na mai wace acibwerera kudziko la Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tsono pomwe adabva kuti Arikelau akhatonga muJudeya pambuto ya baba wace Herodi, adabva mantha kuyenda kumweko. Ndipo Mulungu adauza Zuze mukulota kuti ayende kucigawo ca Galireya, ");
INSERT INTO nyu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","acikakhala mum'zinda wakucemeredwa Nazareta. Na tenepo bzidakwanirisidwa bzomwe bzikhadalewedwa na apolofita kuti: “Iye an'dzacemeredwa munthu wa kuNazareta”. ");
INSERT INTO nyu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pantsiku zimwezire Juwau M'batizi adawoneka mucidambo ca Judeya acimbapalidza kuti: ");
INSERT INTO nyu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Khumbulani bzakuphonya bzanu, thangwe Umambo bwa kudzulu bwafendera”. ");
INSERT INTO nyu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Umweyu ni ule omwe m'polofita Izaiya adalewa kuti: “Fala la omwe alikukuwa mucidambo kuti: ‘Kondzani njira ya Mbuya, fungulani miseu yakulungama ya Iye’ ”. ");
INSERT INTO nyu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Bzakubvala bza Juwau bzikhadakondzedwa na ukuse bwa ngamira, ndipo akhabvala bhande la khanda m'ciuno. Cakudya cace cikhali mabombo na uci bwa nthengo. ");
INSERT INTO nyu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ndipo wanthu wentse akhabwera kuna Juwau kucokera kuJerusalema, kuJudeya na m'bali zentse za m'phepete mwa mkulo wa Jolodani. ");
INSERT INTO nyu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Akhabweka bzakuphonyera Mulungu bzawo, acimbabatizidwa na iye mumkulo wa Jolodani. ");
INSERT INTO nyu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pomwe iye adawona afalizi na sadusi azinji akhabwera kudzabatizidwa, adawauza kuti: “Imwe wana wa nyoka ya ululu! Mbani wakuuzani kuti muthawe ukali bomwe bulikubwera? ");
INSERT INTO nyu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Citani mabasa yomwe yaniratiza kukhumbula kwanu! ");
INSERT INTO nyu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Lekani kukumbuka kuti imwepo mungalewe mwa imwe mwekha muciti: ‘Baba wathu ni Abrahamu’. Ine nin'tsimikiza kuti mwa minyalayi Mulungu angaisanduse icikhala wana wa Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mbadzo yaikhidwa kale pa muzi wa miti, ndipo muti wentse omwe un'bala lini bzisapo bzabwino un'dzagwatidwa ucithusidwa pamoto. ");
INSERT INTO nyu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ine nin'kubatizani na madzi kuti mukhumbule. Tsono pambuyo pangu alikubwera winango wamphambvu kwene-kwene kuposa ine, mwakuti nin'themera lini kutakula xango zace. Iye an'dzakubatizani na Mzimu Wakucena ndipo na moto. ");
INSERT INTO nyu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iye ana cakupepetera m'manja mwace ndipo an'dzaungula tirigu pa mungu. Tirigu an'dzaikoya mugwangwa mwace, ndipo an'dzatentha mungu na moto wakusaya kuthima”. ");
INSERT INTO nyu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ntsiku zimwezire, Jezu adacoka kuGalireya aciyenda kumkulo wa Jolodani kuti akabatizidwe na Juwau. ");
INSERT INTO nyu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tsono Juwau adayezera kulamba aciti: “Ine ndine ndin'funika kubatizidwa na Imwe, ndipo Imwe mulikubwera kuna ine?” ");
INSERT INTO nyu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jezu adatawira kuti: “Pakali-pano leka tenepoyo, bzin'funika kuti ticite tenepoyo, kuti tikwanirise cifuniro ca Mulungu”. Ndipo Juwau adabvuma. ");
INSERT INTO nyu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ndipo Jezu atamala kubatizidwa adacoka m'madzi. Nthawe imweire kudzulu kudafunguka ndipo Iye adawona Mzimu wa Mulungu ucibuluka ninga nkhangaiwa ucibwera kudzam'butha Iye. ");
INSERT INTO nyu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pamwepo padabveka fala kudzulu liciti: “Uyu ni mwana wangu wakufunidwa, omwe ambandikondweresa”. ");
INSERT INTO nyu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pamwepo Jezu adatengedwa na Mzimu Wakucena aciyenda kucidambo kuti akayezedwe na Dyabu. ");
INSERT INTO nyu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ndipo atamala kubzimana kudya ntsiku makumi manai masikati na usiku, adabva njala. ");
INSERT INTO nyu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pamwepo wakumuyezayo adafendera kuna Iye acimuuza kuti: “Penu ndiwe Mwana wa Mulungu, uza minyalayi isanduke pau”. ");
INSERT INTO nyu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tsono Jezu adatawira aciti: “Bzidanembedwa kuti: ‘Munthu an'dzakhala lini na moyo thangwe ra pau yokha, koma na mafala yentse yomwe yan'coka pa mulomo wa Mulungu’”. ");
INSERT INTO nyu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pamwepo Dyabu adam'tenga, aciyenda naye kuJerusalema, mzinda wakucena, adamuimisa pa cipande citali ca padzaulu pa Nyumba ya Mulungu, ");
INSERT INTO nyu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","acimuuza kuti: “Penu ndiwe Mwana wa Mulungu, bzithuse pantsi. Nakuti bzidanembedwa: “ ‘Iye an'dzauza anju wace bza iwe, ndipo na manja iwo an'dzakuphata, kuti napo ndzayo zako zireke kudzapwetekeka pa mwala’”. ");
INSERT INTO nyu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jezu adam'tawira aciti: “Bzidanembedwa pomwe kuti: ‘Leka kuyeza Mbuya, Mulungu wako’”. ");
INSERT INTO nyu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Patsogolo pace, Dyabu adam'tenga aciyenda naye paphiri litali kwene-kwene ndipo adamuwonesa umambo bwentse bwa padziko la pantsi na ulemerero wabwene. ");
INSERT INTO nyu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ndipo adamuuza aciti: “Bzentsenebzi nin'kupasa, ungandigodamira ucindipemba”. ");
INSERT INTO nyu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pamwepo Jezu adamuuza kuti: “Coka, Sathani! Pakuti bzidanembedwa: ‘Pemba Mbuya, Mulungu wako, ndipo tumikira Iye yekha’”. ");
INSERT INTO nyu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na tenepo Dyabu adamusiya, ndipo anju adabwera acimutumikira. ");
INSERT INTO nyu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pomwe Jezu adabva kuti Juwau adaikhidwa m'kawoko, adabwerera kuGalireya. ");
INSERT INTO nyu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ndipo adacoka kuNazareta, acikakhala kuKafaranawumi, yomwe ikhali pafupi na nyandza, kumphimpha ya Zebuloni na Nafitali, ");
INSERT INTO nyu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","kuti bzikwanirise bzomwe bzidalewedwa na m'polofita Izaiya kuti: ");
INSERT INTO nyu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Dziko la Zebuloni na dziko la Nafitali, njira yakunyandza, ng'ambu ya Jolodani, Galireya ya omwe ni aJuda lini, ");
INSERT INTO nyu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mbumba yomwe ikhakhala mum'dima idawona ceza cikulu, na omwe akhakhala m'mbuto ya mdima wa impfa ceza cidawatoya”. ");
INSERT INTO nyu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuyambira pamwepo, Jezu adayamba kupalidza aciti: “Khumbulani bzakuphonya bzanu, nakuti Umambo bwa kudzulu buli pafupi”. ");
INSERT INTO nyu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pomwe akhafamba m'phepete mwa nyandza ya Galireya, Jezu adawona wathu awiri ubale bwawo: Simau, wakucemeredwa Pedru, na m'bale wace Andereya. Iwo akhathusa bwazi munyandza, nakuti akhali akhombwe. ");
INSERT INTO nyu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ndipo Jezu adati: “Nditewereni, ndipo Ine nin'kusandusani akhombwe wa wanthu”. ");
INSERT INTO nyu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Panthawe imweyo letu, iwo adasiya bwazi bwawo acitewera Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Atayenda patsogolo pang'ono, adawona pomwe anango awiri paubale bwawo: Tiyago na m'bale wace Juwau, wana wa Zebedeu. Iwo akhali m'bote na baba wawo Zebedeu, akhambakondza bwazi bwawo. Jezu adawacemera, ");
INSERT INTO nyu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ndipo pamwepo letu iwo adasiya baba wawo na bote, acimutewera. ");
INSERT INTO nyu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jezu akhafamba muGalireya mwentse acimbapfundzisa munyumba za mapembo, acimbapalidza Mafala Yabwino ya Umambo, acimbapoza wakuduwala na matenda yali-yentse pakati pambumba. ");
INSERT INTO nyu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ndipo mbiri yace idabvekera kuSiriya kwentse, ndipo mbumba idam'bweresera wentse omwe akhabonera na kuwawidwa na matenda yakusiyana-siyana, ninga wa mizimu yakuipa, wa khunyu, wakujejera bziwalo, ndipo Iye adawapolesa. ");
INSERT INTO nyu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","M'thithi ukulu udam'tewera, kucokera kuGalireya, Dekapoli, Jerusalema, Judeya na wambali ya ng'ambu ya mkulo wa Jolodani. ");
INSERT INTO nyu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jezu pomwe adawona mithithi ya wanthu adakwira paphiri ndipo adakhala pantsi. Wakupfundzira wace adafendera pafupi na Iye, ");
INSERT INTO nyu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ndipo Iye adayamba kuwapfundzisa aciti: ");
INSERT INTO nyu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mbakudalisidwa omwe ni wakusauka mum'zimu, nakuti Umambo bwa kudzulu ni bwawo. ");
INSERT INTO nyu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mbakudalisidwa omwe alikulira, nakuti an'dzanyamalizidwa. ");
INSERT INTO nyu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mbakudalisidwa omwe ni wakubzicepesa, nakuti iwo an'dzatambira dziko la pantsi ninga utaka. ");
INSERT INTO nyu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mbakudalisidwa omwe ana njala na nyota yakucita cifuniro ca Mulungu, nakuti an'dzakhutisidwa. ");
INSERT INTO nyu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mbakudalisidwa omwe an'citira cifundo anango, nakuti Mulungu an'dzawacitira cifundo. ");
INSERT INTO nyu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mbakudalisidwa omwe adacena m'tima, nakuti an'dzawona Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mbakudalisidwa omwe an'bweresa mtendere, nakuti an'dzacemeredwa wana wa Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mbakudalisidwa omwe an'fambiridwa mbuyo thangwe ra kucita cifuniro ca Mulungu, nakuti Umambo bwa kudzulu ni bwawo. ");
INSERT INTO nyu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Wakudalisidwa mun'dzakhala ndimwe pomwe an'dzakutukanani, acidzakufambirani mbuyo acidzakunamizirani bzakuipa bzakusiyana-siyana thangwe ra Ine. ");
INSERT INTO nyu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pfatsani, kondwerani, thangwe mabai-bai yanu ni makulu kudzulu. Nakuti tenepoyo adafambirambo mbuyo apolofita omwe akhalipo kale imwe mukanati kubadwa. ");
INSERT INTO nyu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Imwepo ndimwe munyu wa dziko la pantsi. Tsono munyu ungamala mphambvu, ungabwezeredwe tani mphambvu yace? Ulibe pomwe basa, kwasala nkhuutaya kunja ucipondedwa na wanthu. ");
INSERT INTO nyu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Imwepo ndimwe ceza ca dziko la pantsi. Mzinda wakumangidwa paphiri ungabisike lini. ");
INSERT INTO nyu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Napombo palibe angagase ciphani-phani acicigwanankhira na citundu. Koma ambaciikha padeca ndipo cin'bvunikira wentse omwe ali m'nyumbamo. ");
INSERT INTO nyu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na tenepo ceza canu cingwerewere patsogolo pa wanthu, kuti awone mabasa yanu yabwino ndipo alemekeze Baba wanu, omwe ali kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Lekani kukumbuka kuti ndabwera kudzamalisa Mtemo wa Mozeji ayai bzakupfundzisa bza Apolofita. Ndiribe kubwera kudzabzimalisa, tsono kudzakwanirisa. ");
INSERT INTO nyu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nin'kuuzani cadidi kuti: Kudzulu na dziko la pantsi bzikakhala bziripo, palibe comwe cin'dzacosedwa muMtemo, munembo ung'ono ayai mthembo uliwentse mpaka bzentse bzikwanirisidwe. ");
INSERT INTO nyu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wentse ule omwe an'dzanyoza ubodzi mwa mitemo imwei ngakhale ming'ono, acipfundzisa wanthu kucita bzibodzi-bodzibzo, an'dzacemeredwa ng'ono muUmambo bwa kudzulu. Tsono wentse ule omwe an'dzateweza, acipfundzisa mitemo imwei an'dzacemeredwa mkulu muUmambo bwa kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nakuti Ine nin'kuuzani kuti cirungamo canu cingasaya kupitirira ca Afalizi na ca adziwi wa Mtemo, mun'dzapita lini cipo muUmambo bwa kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Imwepo mudabva bzomwe bzidauzidwa makolo yanu kuti: ‘Leka kupha’, ndipo ‘omwe anipha an'dzatongedwa’. ");
INSERT INTO nyu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tsono Ine nin'kuuzani kuti ule omwe an'kalipira m'bale wace an'themera kudzatongedwa. Napombo ali-yentse omwe an'dzatukana m'bale wace kuti ‘ulibe basa’, an'dzayendesedwa kumphala. Ndipo ali-yentse omwe an'dzam'cemera kuti: ‘Psiru’, an'dzathemera kuthusidwa kumoto wakusaya kumala. ");
INSERT INTO nyu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Na tenepo, penu iwe un'bweresa cakupereka cako pa guwa la ntsembe ndipo ungakumbuka kuti una mulandu na m'bale wako, ");
INSERT INTO nyu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","siya cakupereka cakoco pa guwa la ntsembepo ndipo cakutoma uyende ukayanjane na m'bale wako, patsogolo pace ubwerere upereke cakupereka cako. ");
INSERT INTO nyu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Fulumiza kubverana na omwe waphonyerana naye, cita bzimwebzi pomwe uli naye munjira, kuti waphonyerana nayeyo aleke kukupereka kwa m'tongi ndipo m'tongi kwa mulindiri, kuti iwepo ungadzaikhidwe m'kawoko. ");
INSERT INTO nyu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ine nin'kutsimikiza kuti un'coka lini kumweko ukanati kulipira kobiri yentse ya mulandu wako. ");
INSERT INTO nyu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Imwe mudabva bzomwe bzidalewedwa kuti: ‘Leka kucita upombo’. ");
INSERT INTO nyu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tsono Ine nin'kuuzani kuti: Ali-yentse omwe an'nyang'ana mkazi mwakum'funa, acita kale upombo naye mum'tima mwace. ");
INSERT INTO nyu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Penu diso lako la madidi lin'kuphonyesa, licose ulithuse kunja. Ni bzabwino kuluza cipande ca thupi lako, kusiyana kuti thupi lentse likathusidwe kumoto wakusaya kumala. ");
INSERT INTO nyu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ndipo penu boko lako lamadidi lin'kuphonyesa, ligwate ulithuse kunja. Ni bzabwino kuluza cipande ca thupi lako, kusiyana na kuti thupi lentse likathusidwe kumoto wakusaya kumala. ");
INSERT INTO nyu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bzidalewedwa pomwe kuti: ‘Ule omwe aniramba mkazi wace bzin'funika kum'pasa tsamba la citsimikizo ca kumulamba’. ");
INSERT INTO nyu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tsono Ine nin'kuuzani kuti wentse ule omwe aniramba mkazi wace, kupambula omwe ana thangwe ra upombo, an'citisa kuti mkaziyo acite uputa, ndipo omwe anirowola mkazi wakulambidwayo alikucitambo upombo. ");
INSERT INTO nyu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Imwepo mudabvambo bzomwe bzidauzidwa makolo yanu kuti: ‘Leka kulumbira bzakunama, tsono teweza kulumbira komwe udacita patsogolo pa Mbuya’. ");
INSERT INTO nyu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tsono Ine nin'kuuzani kuti: Lekani kulumbira na pang'onopo, nee kulumbirira kudzulu thangwe ni mpando wa Umambo wa Mulungu, ");
INSERT INTO nyu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nee padziko la pantsi thangwe ni pakupondera minyendo yace, nee kulumbirira Jerusalema, thangwe ni mzinda wa Mambo m'kulu. ");
INSERT INTO nyu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ndipo leka kulumbirira msolo wako, nakuti iwepo un'kwanisa lini kucitisa kuti tsisi lako likhale licena ayai likhale lisvipa. ");
INSERT INTO nyu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Penu kutawira kwanu ni ‘inde’, kukhale ‘inde’ penu ni ‘nee’, kukhale ‘nee’. Bzikapita popa ni bzakucokera kuna Wakuipa. ");
INSERT INTO nyu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Imwepo mudabva bzomwe bzidalewedwa kuti: ‘Diso kubwezerambo na diso, dzino kubwezerambo na dzino.’ ");
INSERT INTO nyu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tsono Ine nin'kuuzani kuti: Lekani kulimbana naye wakuipa. Penu munthu an'kumenya phutu la madidi, perekera pomwe linango. ");
INSERT INTO nyu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ndipo penu unango an'funa kukumanga mulandu acikutengera cakubvala cako, musiye atenge pomwe bhachi. ");
INSERT INTO nyu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Penu winango an'kungingimiza kufamba naye kirometru ibodzi, ndoko naye kirometru ziwiri. ");
INSERT INTO nyu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pasa omwe an'kukumbira, ndipo leka kulindza ngoto kuna omwe an'funa kuti umukumbize cinthu. ");
INSERT INTO nyu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Imwepo mudabva bzomwe bzidalewedwa kuti: ‘Funa mwandzako, ndipo wenga nyamadulanthaka wako’. ");
INSERT INTO nyu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tsono Ine nin'kuuzani kuti: Funani anyamadulanthaka wanu ndipo pembererani omwe ambakufambirani mbuyo, ");
INSERT INTO nyu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kuti imwepo mudzakhale wana wa Baba wanu omwe ali kudzulu. Thangwe Iye ambagasa dzuwa kuna wakuipa na kuna wabwino ndipo ambabvumbisa mbvula kuna wakulungama na kuna wakusaya kulungama. ");
INSERT INTO nyu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Penu imwepo mun'funa wale omwe ambakufunani okha, ni mabai-bai yanyi yomwe imwepo mun'dzatambira? Nakuti anyakulipirisa m'tsonkho ambacitambo bzimwebzi. ");
INSERT INTO nyu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ndipo mungamusana na abale wanu okha basi, n'ciyani comwe mumbacita cakuposa anango? Nakuti wakusaya kupemba Mulungu ambacitambo bzimwebzi. ");
INSERT INTO nyu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Na tenepo, citani bzabwino ninga Baba wanu wakudzulu ambacita bzabwino nthawe zentse. ");
INSERT INTO nyu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Khalani wancheru lakuleka kucita ‘mabasa yanu ya cirungamo’ patsogolo pa wanthu kuti muwonedwe na iwo, mungacita bzimwebzi, mun'dzakhala lini na mabai-bai kwa baba wanu wa kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Na tenepo, iwe ukapereka bzinthu kuna wakusauka leka kubzikuwirira na cimbututu ninga bzomwe ambacita wacipha-maso munyumba za mapembo na munjira, kuti alemekezedwe na wanthu. Cadidi nin'kuuzani kuti iwo atambira kale mabai-bai yawo. ");
INSERT INTO nyu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tsono iwe ungapereka bzinthu kuna wakusauka, boko lako lamadzere lireke kudziwa bzomwe bzirikucita boko lamadidi, ");
INSERT INTO nyu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kuti cakupereka cako cicitike mwakubisala. Ndipo Baba wako, omwe ambawona bzomwe bzin'citika mwakubisala, an'dzakubaira. ");
INSERT INTO nyu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ndipo imwe mukambapemba, lekani kucita ninga wacipha-maso. Iwo ambafuna kupemba adaima munyumba za mapembo na m'phambano za njira kuti awonedwe na wanthu. Cadidi nin'kuuzani kuti iwo atambira kale mabai-bai yawo. ");
INSERT INTO nyu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tsono iwepo pomwe un'pemba, ndoko mucipinda cako ufunge m'suwo ndipo upembe kuna Baba wako omwe ali mwakubisala. Pamwepo Baba wako omwe ambawona bzakubisala an'dzakupasa mabai-bai. ");
INSERT INTO nyu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pomwe mun'pemba, lekani kumbabwerezera bzibodzi-na-bzibodzi, ninga bzomwe ambacita wakusaya kupemba Mulungu. Thangwe iwo ambakumbuka kuti akacita mpembo wakupitiriza an'dzabveredwa. ");
INSERT INTO nyu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Na tenepo lekani kundendemera na iwo, thangwe Baba wanu an'dziwa bzomwe imwe mulibe, mukanati kumukumbira. ");
INSERT INTO nyu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ndipo imwepo pembani tenepayu: “Baba wathu muli kudzulu! Dzina lanu liremekezedwe. ");
INSERT INTO nyu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Umambo bwanu bubwere, kufuna kwanu kucitike pa dziko la pantsi pano ninga momwe bzimbacitikira kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tipaseni lero cakudya cathu ca ntsiku na ntsiku. ");
INSERT INTO nyu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tirekerereni bzakuphonya bzathu, ninga momwe ife timbalekererambo omwe ambatiphonyera. ");
INSERT INTO nyu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ndipo lekani kutirekerera ticigwa mukuyezedwa, tsono mutipulumuse kwa bzakuipa, thangwe bwanu ni Umambo, mphambvu na mbiri kwakuyenda na kuyenda. Ameni. ");
INSERT INTO nyu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Thangwe imwepo mukalekerera wanthu bzakuphonya bzawo, Baba wanu wa kudzulu an'dzakulekereranimbo. ");
INSERT INTO nyu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tsono mukasaya kulekerera wanthu bzakuphonya bzawo, Baba wanu an'dzakulekererani lini bzakuphonya bzanu. ");
INSERT INTO nyu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pomwe mun'bziretsa kudya, lekani kubziwonesa nkhope yakudodoma ninga wacipha-maso, nakuti iwo ambacinja nkhope kuti wanthu awawone kuti iwo alikubziretsa kudya. Ine nin'kuuzani mwacadidi kuti iwo atambira kale mabai-bai yawo. ");
INSERT INTO nyu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pomwe iwe un'bziretsa kudya, samba m'maso ndipo pukusira mafuta tsisi lako, ");
INSERT INTO nyu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kuti wanthu aleke kudziwa kuti iwe uli kubziretsa kudya, tsono Baba wako yekha omwe ali mwakubisala. Ndipo Baba wako, omwe ambawona mwakubisala, an'dzakubaira. ");
INSERT INTO nyu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Lekani kukoya cuma canu padziko la pantsi, pomwe pana manthedza na ngula bzomwe bzimbadzonga ndipo pana mbava zomwe zimbachola ziciba. ");
INSERT INTO nyu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tsono koyani cuma canu kudzulu, komwe manthedza na ngula bzin'dzonga lini, ndipo komwe mbava zin'chola lini ziciba. ");
INSERT INTO nyu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pakuti komwe kuna cuma cako, komwekombo ndiko kun'dzakhala m'tima wako. ");
INSERT INTO nyu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Maso ndiyo ciphani-phani ca thupi. Penu maso yako ni yabwino, thupi rako lentse lin'khala na ceza. ");
INSERT INTO nyu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tsono penu maso yako ni yakuipa, thupi lako lentse lin'khala na m'dima. Na tenepo penu ceza comwe ciri m'kati mwa iwe casanduka m'dima, m'dima umweyu ngwakugosva kwene-kwene! ");
INSERT INTO nyu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Palibe omwe angaphatire basa azimbuya awiri, nakuti an'dzawenga m'bodzi acifuna winango, ayai an'dzaphatira basa m'bodzi acinyoza winango. Imwepo mun'kwanisa lini kutumikira Mulungu na kobiri. ");
INSERT INTO nyu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Na tenepo Ine nin'kuuzani kuti: Lekani kuneseka na moyo wanu, kuti mun'dzadya ciyani ayai mun'dzamwa ciyani. Ngakhale na thupi lanu, kuti mun'dzabvala ciyani. Kodi moyo ndiwo lini wakufunika kuposa cakudya? Ndipo thupi ndakufunika lini kuposa bzakubvala? ");
INSERT INTO nyu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nyang'anani mbalame za kudzulu, zimbabzala lini, zimbabvuna lini napo kukoya m'magwangwa. Tsono Baba wanu wa kudzulu ambazidyesa. Kodi imwepo ndimwe lini wakufunika kwene-kwene kuposa mbalame? ");
INSERT INTO nyu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kodi mbani wa imwe angathumizire ntsiku za moyo wace thangwe ra kuneseka? ");
INSERT INTO nyu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Thangwe ranyi imwepo mun'neseka na bzakubvala? Nyang'anani maluwa ya m'thengo momwe yamba kulira. Iyo yambaphata lini basa ngakhale kubzirukira bzakubvala. ");
INSERT INTO nyu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na tenepo Ine nin'kuuzani kuti ngakhale Solomoni muulemerero bwace bwentse alibe kubvala ninga libodzi la maluwaya. ");
INSERT INTO nyu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Penu Mulungu an'bvazika usva bwa m'thengo, bomwe lero bulipo ndipo mangwana bun'thusidwa kumoto, angadzataze kubvazika imwepo, wanthu wa cikhulupiriro cakucepamwe? ");
INSERT INTO nyu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Na tenepo lekani kuneseka muciti ‘tin'dzadyanyi?’ ‘Tin'dzamwanyi?’ Ayai ‘tin'dzabvalanyi?’ ");
INSERT INTO nyu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nakuti wakusaya kupemba Mulungu ndiwo ambanyang'ana bzinthu bzimwebzi. Tsono Baba wanu wa kudzulu an'dziwa kuti imwepo bzentsenebzi mun'bzifuna. ");
INSERT INTO nyu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tsono cakutoma, nyang'anani Umambo bwa Mulungu na cirungamo cace ndipo bzinango bzentsenebzi mun'dzabzipasidwa. ");
INSERT INTO nyu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Na tenepo, lekani kuneseka na ntsiku ya mangwana, nakuti ntsiku ya mangwana in'bwera na bzakuneseka bzayene. Ntsiku ibodzi na ibodzi ina bzakuipa bzace bzakukwana. ");
INSERT INTO nyu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Lekani kutonga anango, kuti imwe muleke kudzatongedwa. ");
INSERT INTO nyu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nakuti katongedwe kabodzi-bodzi komwe mun'cita, Mulungu an'dzakutonganimbo nako, ndipo mphimo yomwe mun'pereka, in'dzaperekedwambo kuna imwe. ");
INSERT INTO nyu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Thangwe ranyi iwe unyang'ana katsetswa komwe kali m'diso la m'bale wako, ndipo uniwona lini muti omwe uli m'diso mwako? ");
INSERT INTO nyu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Iwepo ungauze tani m'bale wako kuti: ‘Leka ndikucose katsetswa m'diso lakomu’, uko iwe una muti m'diso mwako? ");
INSERT INTO nyu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wacipha-masowe, yamba kucosa muti omwe uli m'diso mwako, ndipo iwe un'dzawona bwino-bwino pakucosa katsetswa m'diso la m'bale wako. ");
INSERT INTO nyu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Lekani kupasa mbwaya bzakucenesedwa, ngakhale kuthusira nkhumba mkufu wakufunidwa. Kuti izo zireke kuponda m'kufuyo, ndipo zin'dzakuzungunukirani zicikukhadzulani. ");
INSERT INTO nyu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kumbirani ndipo mun'dzapasidwa. Nyang'anani ndipo mun'dzacigumana. Gogodzani ndipo mun'dzafunguliridwa. ");
INSERT INTO nyu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pakuti wentse omwe an'kumbira an'pasidwa. Omwe an'nyang'ana an'cigumana. Ndipo ule omwe an'gogodza an'funguliridwa. ");
INSERT INTO nyu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Mbani munthu pakati panu, akakumbiridwa pau na mwana wace, kodi angam'pase mwala? ");
INSERT INTO nyu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ayai akakumbiridwa ntsomba angam'pase nyoka? ");
INSERT INTO nyu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tsono penu imwe nakuipa kwanuku, mumbadziwa kupasa wana wanu bzinthu bzabwino, ni tani tsono Baba wanu womwe ali kudzulu, an'dzapasa bzinthu bzabwino kwa omwe animukumbira! ");
INSERT INTO nyu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Na tenepo, citani kuna winango centse comwe imwepo mun'funa kuti iwo akucitireni. Nakuti umweyu ni Mtemo wa Mozeji na cipfundziso ca apolofita. ");
INSERT INTO nyu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Pitani na pa m'suwo wa kupapatiza, nakuti m'suwo ukulu na njira yakufuthuka bzimbayendesa kwakutaika, ndipo ni azinji omwe ambapita na njira imweyi. ");
INSERT INTO nyu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tsono m'suwo omwe umbayendesa kumoyo ni wakupapatiza, ndipo njira yace ni yakupsindiza! Ni ang'ono-ng'ono omwe ambaiwona. ");
INSERT INTO nyu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Khalani na cheru na apolofita wakunama. Iwo ambabwera kwa imwe na mawonekedwa ninga ya bira, tsono m'kati ni mphumphi zakulusa. ");
INSERT INTO nyu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Imwe mun'dzawazindikira na bzisapo bzomwe an'dzabala. Kodi bzingacitike kuti munthu abvune uva m'miti ya minga, ayai nkhuyu pauswa bwa dawe? ");
INSERT INTO nyu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ni bzibodzi-bodzi muti wabwino umbabala bzisapo bzabwino, tsono muti wakuipa umbabala bzisapo bzakuipa. ");
INSERT INTO nyu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Muti wabwino ungabale lini bzisapo bzakuipa, napo muti wakuipa ungabale lini bzisapo bzabwino. ");
INSERT INTO nyu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Muti uliwentse omwe un'bala lini bzisapo bzabwino umbagwatidwa ucithusidwa kumoto. ");
INSERT INTO nyu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Na tenepo apolofitawo mun'dzawazindikira na bzisapo bzawo! ");
INSERT INTO nyu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ni wentse lini omwe ambandicemera kuti: ‘Mbuya, Mbuya’, an'dzapita muUmambo bwa kudzulu, tsono wale okha omwe an'cita cifuniro ca Baba wangu omwe ali kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Azinji ntsiku imweire an'dzandiuza kuti: ‘Mbuya, Mbuya, tiribe kucita cipolofita mudzina lanu? Ndipo mudzina lanu tiribe kucosa bziwanda ndipo mudzina lanu tiribe kucita bzidabwiso bzizinji?’ ");
INSERT INTO nyu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pamwepo Ine nin'dzawauza padeca kuti: Cipo ndiribe kukudziwani. Fundukirani kuna Ine, imwe wakucita bzakuipa! ");
INSERT INTO nyu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Na tenepo, omwe anibva mafala yanguya acicita bzomwe yalikulewa, ali ninga munthu wakucenjera omwe adacera madindi yakuzika kwene-kwene mpaka kuphata mwala acimanga nyumba yace. ");
INSERT INTO nyu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mbvula idagwa, mikulo idadzala, ndipo mphepo idamenya nyumba ire na mphambvu. Ndipo iyo iribe kugwa nakuti ikhadamangidwa bwino. ");
INSERT INTO nyu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tsono ule omwe anibva mafala yanguya acireka kucita bzomwe yalikulewa, ali ninga wakupusa omwe adamanga nyumba yace acisaya kuzikisa madindi. ");
INSERT INTO nyu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mbvula idagwa, mikulo idadzala, ndipo mphepo idamenya nyumba ire na mphambvu, iyo idagwa. Ndipo idadzongeka kwene-kwene”. ");
INSERT INTO nyu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pomwe Jezu adamala kulewa bzimwebzi, mithithi ya wanthu idadabwisidwa na cipfundziso cace, ");
INSERT INTO nyu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","thangwe Iye akhawapfundzisa ninga omwe ana utongi, sikuti ninga adziwi wa Mtemo. ");
INSERT INTO nyu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pomwe Jezu adabuluka m'phiri, m'thithi ukulu udamutewera. ");
INSERT INTO nyu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pamwepo munthu winango wamapere adafendera pafupi acim'godamira ndipo aciti: “Mbuya, mukafuna, mungandipolese!” ");
INSERT INTO nyu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jezu adapfuthula boko, acim'khuya ndipo adati: “Nin'funa, Pola!” Pamwepo-letu iye adapolesedwa mapere. ");
INSERT INTO nyu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Patsogolo pace Jezu adati: “Wona, leka kuuza ali-yentse. Tsono ndoko ukabziratize kuna baba wantsembe ndipo ukapereke ntsembe yomwe Mozeji adalewa, kuti ikhale mboni”. ");
INSERT INTO nyu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pomwe Jezu adapita mumzinda wa Kafaranawumi, adayenda kawonana naye kapitau wa gulu la acikunda wa ciRoma acikam'kumbira thandizo. ");
INSERT INTO nyu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ndipo adati: “Mbuya, kapolo wangu ali m'nyumba alikukwanisa lini kufamba, alikubonera kwene-kwene”. ");
INSERT INTO nyu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jezu adamuuza kuti: “Ine nin'dzayenda kukam'cirisa”. ");
INSERT INTO nyu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tsono kapitau wa gulu la acikunda wa ciRoma adatawira aciti: “Mbuya, nin'themera lini kukutambirani panyumba yangu. Tsono lewani fala libodzi lokha, ndipo kapolo wangu an'dzacira. ");
INSERT INTO nyu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pakuti inembo ndiri pantsi pa utongi, ndipo ndina acikunda omwe ine nimbatonga. Ndikauza m'bodzi kuti: ‘Ndoko,’ iye ambayenda. Ndikauza winango kuti: ‘Bwera,’ iye ambabwera. Ndikauza nyagirinya wangu kuti: Cita ibzi, iye ambacita”. ");
INSERT INTO nyu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pomwe Jezu adabva bzimwebzi adadabwa aciuza omwe akhamutewera kuti: “Nin'kuuzani bzacadidi kuti: MuIjirayeri ndiribe kuwona omwe ana cikhulupiriro tenepayu. ");
INSERT INTO nyu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ndipo Ine nin'kuuzani kuti azinji an'dzabwera kucokera kumabva-dzuwa na kumadokero, ndipo an'dzakhala pameza na Abrahamu, Izaki na Jakobo muUmambo bwa kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tsono omwe akhathemera kukhala muUmambo an'dzathusidwa kunja kum'dima, kumweko an'dzalira na kukukuta mano”. ");
INSERT INTO nyu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pamwepo Jezu adauza kapitau wa gulu la acikunda wa ciRoma kuti: “Ndoko! Bzin'citika ninga momwe iwe wakhulupirira!” Nthawe imweyo letu kapolo wace adacira. ");
INSERT INTO nyu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Patsogolo pace Jezu atafika pa nyumba pa Pedru, adawona mibzala wace adagona na maferu. ");
INSERT INTO nyu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pamwepo Jezu adam'khuya mibzalayo pa dzanja, maferu yadamala, ndipo mibzala ule adalamuka aciyamba kumutanairira. ");
INSERT INTO nyu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pomwe dzuwa lidamira adam'bweresera wanthu azinji wakuphatidwa na mizimu yakuipa, ndipo na fala libodzi basi Iye adathotha mizimuyo, aciciza atenda wentse. ");
INSERT INTO nyu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Na tenepo bzidakwanirisidwa bzomwe bzidalewedwa na m'polofita Izaiya kuti: “Iye adatenga kuduwala kwathu ndipo adanyamula matenda yathu”. ");
INSERT INTO nyu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pomwe Jezu adawona m'thithi wa wanthu m'mbali mwace, adawauza wakupfundzira wace kuti ayambuke m'ng'ambu ya nyandza. ");
INSERT INTO nyu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pamwepo m'nembi wa Mtemo adafendera aciti: “M'pfundzisi, ine nin'kutewerani kuli kwentse komwe muniyenda”. ");
INSERT INTO nyu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jezu adatawira kuti: “Nkhandwe zina madindi yazene ndipo mbalame za m'dzulu zina bzitsa bzazene, tsono Mwana wa munthu alibe pakugonesa msolo”. ");
INSERT INTO nyu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ndipo wakupfundzira wace winango adamuuza kuti: “Mbuya, ndibvumizeni kuti nditome kapendesa baba wangu”. ");
INSERT INTO nyu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tsono Jezu adam'tawira kuti: “Nditewere, siya wakufa akapendese wakufa wawo”. ");
INSERT INTO nyu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pamwepo Jezu adapakira m'bote, ndipo wakupfundzira wace adayenda naye pabodzi. ");
INSERT INTO nyu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mwacisututu, condzi camphambvu cidayamba m'nyandza, mwakuti mabimbi yakhapita m'bote. Tsono Jezu akhadagona. ");
INSERT INTO nyu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ndipo wakupfundzira wace adayenda kamulamusa, acikuwa kuti: “Mbuya, tipulumuseni! Tinifa!” ");
INSERT INTO nyu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ndipo Iye adawabvundza aciti: “Thangwe ranyi imwepo muna mantha kwene-kwene, amuna wacikhulupiriro cakucepa?” Pamwepo Iye adamuka acitsimula condzi na mabimbi ndipo kudakhala bwino letu. ");
INSERT INTO nyu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Pamwepo wanthu wale adadabwisidwa, acimbabvundzana aciti: “Mbani umweyu ngakhale condzi na mabimbi bzimbam'bvera?” ");
INSERT INTO nyu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pomwe Iye adafika ng'ambu inango, cigawo cakucemeredwa Gadara, wanthu awiri wakuphatidwa na bziwanda adabwera kuna Iye omwe akhacokera m'thenje. Iwo akhali wakugosva kwene-kwene mwakuti palibe omwe angadapita na njira imweire. ");
INSERT INTO nyu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pamwepo bziwandabzo bzidakuwa bziciti: “N'ciyani mun'funa kuna ife, Mwana wa Mulungu? Mabwera kuno kudzatiboneresa nthawe ikanati kukwana?” ");
INSERT INTO nyu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pafupi na iwo pakhana m'thithi ukulu wankhumba zikhadya. ");
INSERT INTO nyu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pamwepo bziwanda bzire bzikhakumbira Jezu bziciti: “Penu mun'tithotha, titumize tikapite m'thithi wa nkhumba zire”. ");
INSERT INTO nyu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iye adauza bziwandabzo kuti: “Ndokoni!” Ibzo bzidacoka bzicikapita munkhumba, ndipo m'thithi wentse udathamangira kunkhomole mbali ya nyandza, mpaka kufa m'nyandzamo. ");
INSERT INTO nyu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wakudyesa nkhumbazo adathawa, adayenda mum'zinda acikafotokoza bzinthu bzentse, kuphatikidza bzomwe bzidacitika kuna omwe akhana bziwandawo. ");
INSERT INTO nyu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Na tenepo wanthu wentse wa mum'zindamo adayenda kukagumana na Jezu, ndipo pomwe adamuwona, adamukumbira mwa kumuumiriza kuti acoke mucigawo cawomo. ");
INSERT INTO nyu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jezu atapakira m'bote, adayambuka nyandza aciyenda kumzinda wace. ");
INSERT INTO nyu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wanthu winango adam'bweresera munthu wakudjedjera bziwalo, akhadam'gonesa pa machira pace. Pakuwona cikhulupiriro comwe iwo akhanaco, Jezu adauza wakulemalayo kuti: “Limbika mwana, bzakuphonyera Mulungu bzako bzalekereredwa”. ");
INSERT INTO nyu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Patsogolo pa bzimwebzo, adziwi wa Mtemo anango akhauzana okha-okha acimbati: “Munthu umweyu alikunyoza Mulungu!” ");
INSERT INTO nyu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jezu pakudziwa ndzeru zawo adawauza kuti: “Thangwe ranyi imwepo mulikukumbuka bzakuipa m'mitima mwanu? ");
INSERT INTO nyu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kodi bzidapusa ni bziponi kulewa kuti: ‘Bzakuphonyera Mulungu bzako bzalekereredwa’, ayai: ‘Lamuka ufambe’? ");
INSERT INTO nyu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tsono kuti imwepo mudziwe kuti Ine, Mwana wa Munthu ana utongi pantsi pano bwakulekerera bzakuphonyera Mulungu”, pamwepo adauza wakulemalayo aciti: “Lamuka, tenga machira yako yenda kumui”. ");
INSERT INTO nyu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wakudjedjera bziwaloyo adamuka aciyenda kumui kwace. ");
INSERT INTO nyu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ndipo pomwe m'thithi udawona bzimwebzi udakhala na mantha, ndipo udatumbiza Mulungu, omwe adapasa wanthu mphambvu imweyo. ");
INSERT INTO nyu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pomwe Jezu akhacoka kumweko, adawona munthu winango wakucemeredwa Mateu akhadakhala pa kukhomera m'tsonkho, ndipo adamuuza kuti: “Nditewere”. Mateu adalamuka acimutewera. ");
INSERT INTO nyu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ndipo Jezu pomwe akhadya m'nyumba, wakukhomesa m'tsonkho na “wakuphonyera Mulungu” azinji adabwera acidya naye pabodzi na wakupfundzira wace. ");
INSERT INTO nyu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Afalizi pakuwona bzimwebzi adabvundza wakupfundzira wace kuti: “Thangwe ranyi m'pfundzisi wanu alikudya na wakukhomesa m'tsonkho na ‘wakuphonyera Mulungu’?” ");
INSERT INTO nyu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jezu pomwe adabva bzimwebzi adati: “Wakulimba an'nyang'ana lini mulapi, koma mtenda ndiye an'nyang'ana mulapi. ");
INSERT INTO nyu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ndokoni mukapfundzire kuti bzimwebzi bzinirewanyi: ‘Nimbafuna lini ntsembe koma ntsisi’. Pakuti Ine ndiribe kubwera kudzacemera wakulungama, koma wakuphonyera Mulungu”. ");
INSERT INTO nyu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pamwepo wakupfundzira wa Juwau M'batizi adabwera kudzabvundza Jezu kuti: “Thangwe ranyi ife na afalizi timbabzimana cakudya, tsono wakupfundzira wanu ambabzimana lini?” ");
INSERT INTO nyu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jezu adawatawira kuti: “Kodi wakucemeredwa wa mwamuna pamsinda wa malowozi angatsukwale uko mwamunayo alipo? Zin'dzakwana ntsiku zakuti mwamunayo an'dzacosedwa, pamwepo iwo an'dzabzimana cakudya. ");
INSERT INTO nyu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Palibe omwe angatenge nguwo ipsa aciicita cigamba pa cakubvala cakale, nakuti cigambaco cin'pfuwa cicing'amba ndipo kung'ambikako kun'posa kale. ");
INSERT INTO nyu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ndipo ambathululira lini vinyu ipsa mubudu la khanda lakale, ungacita tenepoyo budulo lining'ambika ndipo vinyu in'taika budu, lin'dzongeka. Koma ambathululira vinyu ipsa mubudu la khanda lipsa, ndipo bziwiribzo bzimbakonkhobzeka bwino”. ");
INSERT INTO nyu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Pomwe Iye akhalewa-lewa m'kulu wa nyumba ya mapembo adafika, adagodama patsogolo pace aciti: “Mwanangu wacikazi afa tsapanopa. Tiyendeni mukamusandzike boko lanu ndipo iye an'khakhala na moyo”. ");
INSERT INTO nyu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Pamwepo, Jezu adalamuka aciyenda naye, pabodzi na wakupfundzira wace. ");
INSERT INTO nyu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mkazi winango omwe akhana matenda yakucoka mulopa mwa magole khumi na mawiri, adabwera na kumbuyo kwa Jezu acikhuya mkawo wa cakubvala ca Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Pakuti akhambalewa mwa iye yekha kuti: “Ine ndicitondo kukhuya cakubvala cace nin'cira”. ");
INSERT INTO nyu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jezu pomwe adazungunuka adamuwona aciti: “Mwana wacikaziwe limba m'tima, cikhulupiriro cako cakuciza!” Ndipo kuyambira nthawe imweyo mkaziyo adacira. ");
INSERT INTO nyu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pomwe Jezu adafika panyumba pa m'kulu wa nyumba ya mapembo adawona wakuimba bzitoliro na m'thithi womwe ukhali piringu-piringu, ");
INSERT INTO nyu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","adati: “Bulani! Mtsikanayu alibe kufa, tsono adagona”. Wentse adayamba kumuseka. ");
INSERT INTO nyu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pomwe m'thithi udafundukira, Jezu adapita acim'phata boko ndipo m'tsikanayo adalamuka. ");
INSERT INTO nyu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ndipo mbiri ya bzidacitikabzo idabveka kumbali zentse za dzikolo. ");
INSERT INTO nyu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jezu pomwe adacoka kumweko, azimola awiri adamutewera, acimbakuwa kuti: “Mwana wa Davidi, tibverenimbo ntsisi ife!” ");
INSERT INTO nyu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pomwe Iye adapita m'nyumba azimola adafendera, ndipo Jezu adawabvundza kuti: “Imwepo mun'khulupirira kuti nin'kwanisa kukucizani?” Iwo adatawira aciti: “Inde, Mbuya!” ");
INSERT INTO nyu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ndipo Jezu adakhuya maso yawo adati: “Bzicitike malingana cikhulupiriro canu!” ");
INSERT INTO nyu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ndipo maso yawo yadayamba kuwona. Pamwepo Jezu adawacenjeza mwakulimba aciti: “Bzimwebzi mbabzireke kudziwidwa na winango”. ");
INSERT INTO nyu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tsono iwo adacoka acikamwaza nkhani ya Jezu kumbali ire yentse. ");
INSERT INTO nyu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pomwe iwo akhacoka, adabweresedwa kuna Jezu munthu wakuphatidwa na ciwanda omwe akhakwanisa lini kulewa-lewa. ");
INSERT INTO nyu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pomwe ciwanda cidathothedwa, bewewe adayamba kulewa-lewa. M'thithi udadabwisika uciti: “Cipo bzikanati kuwoneka bzinthu ninga bzimwebzi muIjirayeri!” ");
INSERT INTO nyu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tsono afalizi akhambalewa kuti: “Iye alikuthotha bziwanda na mphambvu ya m'kulu wa bziwanda”. ");
INSERT INTO nyu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jezu akhambapita m'mizinda yentse na m'midzi acimbapfundzisa munyumba za mapembo, acimbapalidza Mafala Yabwino ya Umambo ndipo acimbapolesa matenda yentse na kuwofoka kwa thupi. ");
INSERT INTO nyu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pomwe Iye adawona mithithi, adabva ntsisi, thangwe ikhaneseka ndipo ikhali balala-balala, ninga mabira yakusaya makabusa. ");
INSERT INTO nyu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pamwepo adauza wakupfundzira wace kuti: “Basa lakubvuna ni likulu, tsono akapolo ni ang'ono-ng'ono. ");
INSERT INTO nyu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Na tenepo, Kumbirani kuna Mbuya mwenekaciro wa bzakubvunabzo, kuti atumize akapolo adzabvune”. ");
INSERT INTO nyu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jezu adacemera wakupfundzira wace khumi na awiri aciwapasa mphambvu yakuthotha mizimu yakuipa na kupolesa matenda yentse na bzakuwofoka bza m'thupi. ");
INSERT INTO nyu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Madzina ya atumiki khumi na awiriwo ngaya: Wakuyamba ni Simau wakucemeredwa Pedru na Andereya m'bale wace, Tiyago, mwana wa Zebedeu na Juwau m'bale wace, ");
INSERT INTO nyu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi na Bartolomeu, Tomasi na Mateu wakulipirisa m'tsonkho, Tiyago, mwana wa Alifeu, na Tadeu, ");
INSERT INTO nyu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simau wa phathi la azeloti na Judasi Isikaliyoti, omwe adapindukira Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Amuna khumi na awiriwa Jezu adawatuma aciwauza kuti: “Lekani kuyenda kwa omwe ni Ajuda lini, napo kupita mum'zinda uliwentse wa aSamaliya. ");
INSERT INTO nyu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tsono ndokoni kuna aIjirayeri omwe ali ninga mabira yakutaika. ");
INSERT INTO nyu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ndipo kwentse komwe muniyenda mbapalidzani mafala yakuti: ‘Umambo bwa kudzulu buli pafupi’. ");
INSERT INTO nyu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Polesani wakuduwala, lamusani wakufa, cizani wamapere, thothani bziwanda. Imwepo mwatambira mwaulere, perekanimbo mwaulere. ");
INSERT INTO nyu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Lekani kutakula oro, ayai parata, ngakhale kobre m'mabhande. ");
INSERT INTO nyu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Lekani kutakula budu la ulendo, ngakhale cakubvala ca pambali, napo xango, ayai mpsimbo. Pakuti wabasa ngwakuthemera kutambira cakudya cace. ");
INSERT INTO nyu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pomwe mun'pita mumzinda ayai m'mudzi, nyang'anani munthu womwe an'funa kukutambirani ndipo mukhale panyumba pace mpaka kucoka kwanu. ");
INSERT INTO nyu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pakupita m'nyumbamo, amuseni. ");
INSERT INTO nyu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Penu pa nyumbapo an'kutambirani bwino, mtendere wanu ukhale na iwo. Penu an'kutambirani lini bwino, mtendere wanu ubwerere kuna imwe. ");
INSERT INTO nyu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Penu winango an'kutambirani lini ngakhale kubva mafala yanu, kunkhumulani pfumbi la kundzayo zanu pakucoka pa nyumbapo ayai mum'zindamo. ");
INSERT INTO nyu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ine nin'kuuzani bzacadidi kuti: Pantsiku ya kudzatonga Mulungu an'dzabvera ntsisi Sodoma na Gomora kuposa mzinda umweyo. ");
INSERT INTO nyu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ine ndirikukutumani ninga mabira pakati pa mphumphi. Na tenepo khalani wakucenjera ninga nyoka ndipo wakusaya cakuipa ninga nkhangaiwa. ");
INSERT INTO nyu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Khalani na cheru, pakuti wanthu an'dzakuperekani kumphala zawo ndipo an'dzakuchangani m'nyumba zawo za mapembo. ");
INSERT INTO nyu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Imwepo mun'dzayendesedwa patsogolo pa atongi wa bzigawo na azimambo thangwe ra Ine, kuti mukakhale mboni kwa iwo na kwa omwe ni Ajuda lini. ");
INSERT INTO nyu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tsono akadzakumangani lekani kudzaneseka kutimun'dzalewa ciyani ayai mun'dzalewa tani. Nakuti nthawe imweyo mun'dzauzidwa bzakuti mulewe, ");
INSERT INTO nyu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","pakuti ndimwepo lini omwe mun'dzalewa, tsono Mzimu wa Baba wanu ndiwo un'dzalewa mwa imwe. ");
INSERT INTO nyu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“M'bale an'dzapereka m'bale wace kuimpfa, ndipo baba an'dzapereka mwana wace. Wana an'dzamukira azibaba wawo ndipo an'dzawapha. ");
INSERT INTO nyu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wentse an'dzakuwengani thangwe ra dzina langu, tsono ule omwe an'dzalimbikira mpaka pakumalizira an'dzapulumuka. ");
INSERT INTO nyu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ndipo pomwe an'dzakufambirani mbuyo mumzinda uyu, thawirani kuunango. Ine nin'kutsimikizirani kuti mun'mala lini mizinda yentse ya muIjirayeri, Mwana wa munthu akanati kubwera. ");
INSERT INTO nyu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Wakupfundzira an'posa lini m'pfundzisi wace, napo nyagirinya an'posa lini mbuya wace. ");
INSERT INTO nyu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Na tenepo wakupfundzira bzim'kwanire kukhala ninga m'pfundzisi wace ndipo nyagirinya ninga mbuya wace. Penu mwenekaciro wa nyumba adacemeredwa Belezebu, ndiye tani wanthu wa m'banja mwace! ");
INSERT INTO nyu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Na tenepo lekani kubva mantha na iwo. Nakuti palibe cakumpsinkhika comwe cin'dzasaya kuwoneka ayai cakubisika comwe cin'dzasaya kudziwika. ");
INSERT INTO nyu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bzomwe Ine nin'kuuzani mum'dima, bzireweni pa ceza. Bzomwe mudabzibvera m'khutu bzireweni pa ntsodzi. ");
INSERT INTO nyu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Lekani kugopa omwe anipha thupi, ndipo m'zimu an'kwanisa lini kuupha. Tsono gopani ule omwe anipha m'zimu na thupi kumoto wakusaya kumala. ");
INSERT INTO nyu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Atimba awiri ambagulisiwa lini na kasentavu kabodzi? Na tenepo palibe na ibodziyo inigwa pantsi Baba wanu acisaya kudziwa. ");
INSERT INTO nyu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Napo kuna imwepo tsisi lentse la mumsolo mwanu lidalewengedwa. ");
INSERT INTO nyu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Na tenepo lekani kugopa. Imwepo ndimwe wakufunika kwene-kwene kuposa atimba azinji! ");
INSERT INTO nyu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Wentse ule omwe an'dzandicitira umboni pakati pa wanthu, Ine nin'dzamucitirambo umboni patsogolo pa Baba wangu omwe ali kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tsono ule omwe andiramba pakati pa wanthu, Ine nin'dzamulambambo patsogolo pa Baba wangu omwe ali kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Lekani kukumbuka kuti Ine ndabweresa mtendere pa dziko la pantsi. Ndiribe kubweresa mtendere, koma nkhondo. ");
INSERT INTO nyu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nakuti Ine ndidabwera kudzamwazanisa mwana wacimuna na baba wace, mwana wacikazi na mai wace, mulowola na mibzala wace. ");
INSERT INTO nyu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Anyamadulanthaka wa munthu an'dzakhala wa m'banja mwace caiwo. ");
INSERT INTO nyu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Omwe an'funa baba wace ayai mai wace kuposa Ine, an'themera lini kwa Ine. Omwe an'funa mwana wace wacimuna ayai wacikazi kuposa ine an'themera lini kwa Ine. ");
INSERT INTO nyu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ndipo omwe an'saya kutakula m'tanda wace acinditewera, an'themera lini kwa Ine. ");
INSERT INTO nyu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ule omwe an'bzikoyera moyo wace an'dzauluza, ndipo omwe aniruza moyo wace thangwe ra ine un'dzauwona. ");
INSERT INTO nyu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ule omwe an'tambira imwepo, atambira Ine. Ndipo omwe an'tambira Ine, atambira ule omwe adandituma. ");
INSERT INTO nyu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ule omwe an'tambira m'polofita, thangwe ra kuti iye ni m'polofita, an'dzatambira mabai-bai ya m'polofita, ndipo omwe an'tambira wakulungama thangwe ra kuti iye ni wakulungama an'dzatambira mabai-bai ya wakulungama. ");
INSERT INTO nyu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ndipo penu wina an'dzapasa ngakhale mkombo ubodzi wa madzi yakudjedjera kwa m'bodzi mwa wakupfundzira wangu ang'onowa, thangwe ra kuti iye ni wakupfundzira wangu, Ine nin'kutsimikizirani kuti an'dzaluza lini mabai-bai yace”. ");
INSERT INTO nyu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pomwe Jezu adamala kulangiza wakupfundzira wace khumi na awiri, adacoka aciyenda kukapfundzisa na kupalidza mumizinda ya Galireya. ");
INSERT INTO nyu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juwau, pomwe adabva m'kawoko bzomwe Krixtu akhacita, adatumiza wakupfundzira wace kukam'bvundza kuti: ");
INSERT INTO nyu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Kodi ndimwe ule omwe akhadikhiridwa ayai tidikhirire winango?” ");
INSERT INTO nyu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jezu adatawira aciti: “Bwererani mukauze Juwau bzomwe imwepo mulikubva na kuwona: ");
INSERT INTO nyu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Azimola ali kuwona, wakupunduka alikufamba, wamapere ali kupolesedwa, nkhuthu zirikubva, wakufa ali kulamusidwa, ndipo wakusauka alikupalidziridwa Mafala Yabwino. ");
INSERT INTO nyu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ndipo ni wakusimbidwa omwe an'siya lini cikhulupiriro cawo thangwe ra Ine”. ");
INSERT INTO nyu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pomwe wakupfundzira wa Juwau akhacoka, Jezu adayamba kuuza m'thithi bza Juwau kuti: “Ni ciyani comwe imwepo mwayenda kukawona kucidambo? Mtete ukhatekenyesedwa na mphepo? ");
INSERT INTO nyu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tsono, ni ciyani comwe mwayenda kukawona? Munthu akhadabvala bzakubvala bzabwino? Tsono, wanthu wakubvala bzakubvala bzabwino ali muzinyumba za azimambo. ");
INSERT INTO nyu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tsono, ni ciyani comwe mwayenda kukawona? M'polofita? Inde, Ine nin'kuuzani, mwakuposa m'polofita. ");
INSERT INTO nyu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Umweyu ni Juwau M'batizi omwe adalewedwa mubzakunemba kuti: “ ‘Nin'dzatumiza m'tumiki wangu patsogolo pako. Iye an'dzakondza njira yako patsogolo pa iwe’. ");
INSERT INTO nyu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nin'kuuzani cadidi kuti: Pakati pa wakubadwa na mkazi pakanati kuwoneka omwe ni m'kulu kuposa Juwau M'batizi. Tsono, mung'ono muUmambo bwakudzulu nim'kulu kuposa iye. ");
INSERT INTO nyu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kuyambira ntsiku za Juwau M'batizi mpaka lero, Umambo bwa kudzulu bumbapsokonyoledwa mwa mphambvu, ndipo wakuupsokonyolawo ambaupamba. ");
INSERT INTO nyu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nakuti aPolofita wentse na Mtemo adapolofita mpaka Juwau. ");
INSERT INTO nyu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ndipo penu imwe mun'funa kumutawira, umweyu ni Eriya omwe akhafunika kuti abwere. ");
INSERT INTO nyu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Omwe ana makutu abve! ");
INSERT INTO nyu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ningandendemeze na yani m'badwe umweyu? Udalingana na wana omwe ambakhala m'misika ndipo acimbakuwira andzawo kuti: ");
INSERT INTO nyu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Ife takuimbirani citoliro, tsono imwe mulibe kubzina. Takuimbirani nyimbo yakudandaula, tsono imwepo mulibe kutsukwala’. ");
INSERT INTO nyu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pakuti Juwau adabwera, omwe akhabziretsa kudya na kumwa vinyu, ndipo mudati: ‘Ana ciwanda’. ");
INSERT INTO nyu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana wa munthu adabwera acidya na kumwa, ndipo mudati: ‘Muwoneni, wakulungwa wakumwa kwene-kwene, xamwali wa anyamitsonkho na “wakuphonyera Mulungu” ’. Tsono undziwi umbawonedwa na mabasa yace”. ");
INSERT INTO nyu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pamwepo Jezu adayamba kutsimula mizinda yomwe Iye adacita bzidabwiso bzizinji, thangwe iribe kukhumbula. ");
INSERT INTO nyu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Tsoka kwa iwe, Korazini! Tsoka kwa iwe Betisaida! Thangwe penu bzidabwiso bzomwe bzidacitika pakati pa imwe bzingadacitikira kumizinda ya Tiro na Sidoni, iyo ingadakhumbula kale-kale, mwakubvala masakha na kubziikha dotha. ");
INSERT INTO nyu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tsono Ine nin'kuuzani kuti ntsiku ya kudzatonga Mulungu an'dzabvera ntsisi Tiro na Sidoni, kuposa iwe Kafaranawumi. ");
INSERT INTO nyu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ndipo iwe Kafaranawumi, un'dzatengedwa mpaka kudzulu? Ni tenepo lini, iwepo un'dzapolika mpaka kudziko la wakufa! Penu bzidabwiso bzomwe bzidacitika kwa imwe bzingadacitikira kuSodoma, iwo angadakhala mpaka lero. ");
INSERT INTO nyu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tsono Ine nin'kuuzani kuti ntsiku ya kutongedwa Sodoma in'dzabveredwa ntsisi kuposa iwe Kafaranawumi”. ");
INSERT INTO nyu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nthawe imwe ire Jezu adati: “Ine nin'kutumbizani, Baba, Mbuya wa kudzulu na pantsi, thangwe mwabisa bzinthu bzimwebzi kuna adziwi na wakupfundza, ndipo mwabzizimbula kuna wanthu wakusaya kupfundza. ");
INSERT INTO nyu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Inde, Baba, nakuti tenepoyo mudacita mwa kukukomerani. ");
INSERT INTO nyu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Bzinthu bzentse ndidapasiwa na Baba wangu. Palibe an'dziwa Mwana kunja kwa Baba, ndipo palibe angadziwe Baba kunja kwa Mwana na omwe Mwana angafune kulatiza. ");
INSERT INTO nyu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Bwerani kwa Ine mwentse wakuneta na kulemedwa, ndipo Ine nin'dzakupumisani. ");
INSERT INTO nyu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tengani joki langu ndipo pfundzirani kuna Ine, nakuti ndine wakuderekha na wakubzicepesa mum'tima, ndipo mun'dzagumana pakupumisa mizimu yanu. ");
INSERT INTO nyu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pakuti joki langu ni lakulula ndipo m'tolo wangu ni wakupepuka”. ");
INSERT INTO nyu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pantsiku inango ya malinkhuma, Jezu adapita na muminda ya tirigu. Wakupfundzira wace akhana njala, ndipo adayamba kucosa ngala za tirigu acimbadya. ");
INSERT INTO nyu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Afalizi pakuwona bzimwebzo adauza Jezu kuti: “Wona, wakupfundzira wako alikucita bzomwe bzin'bvumizidwa lini kucita pa ntsiku ya malinkhuma”. ");
INSERT INTO nyu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iye adawatawira kuti: “Imwepo mulibe kulewenga bzomwe Davidi adacita pomwe iye na andzace akhana njala? ");
INSERT INTO nyu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davidi adapita m'nyumba ya Mulungu, pabodzi na andzace acikadya pau zakuperekedwa kwa Mulungu, bzomwe bzikhabvumizidwa lini kuti abzicite, tsono bzikhambacitidwa na anyantsembe okha. ");
INSERT INTO nyu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ayai imwepo mukanati kulewenga muMtemo kuti, ntsiku ya malinkhuma anyantsembe m'nyumba ya Mulungu ambachola Mtemo ntsiku ya malinkhuma, ndipo ambakhala alibe mulandu? ");
INSERT INTO nyu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ine nin'kuuzani kuti pano pana omwe ni m'kulu kuposa nyumba ya Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Imwepo mungadadziwa kuti yalikulewa ciyani mafala yakuti: ‘Nimbafuna lini ntsembe, koma wanthu’, mungadamanga lini mulandu wanthu wakusaya thangwe. ");
INSERT INTO nyu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nakuti Mwana wa munthu ni Mbuya wa Malinkhuma”. ");
INSERT INTO nyu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pomwe Jezu adacoka kumbuto ire adayenda munyumba yawo ya mapembo, ");
INSERT INTO nyu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ndipo m'mwemo mukhana munthu omwe akhadapunduka boko. Ndipo pakunyang'ana thangwe la kupasa Jezu, adamum'bvundza kuti: “Ni bzakubvumizidwa na Mtemo kulimbisa munthu pa ntsiku ya malinkhuma?” ");
INSERT INTO nyu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iye adawatawira kuti: “Kodi mbani wa imwe acikhala na bira wace ndipo birayo acigwera m'dindi pa ntsiku ya malinkhuma, an'kam'cosa lini m'mwemo? ");
INSERT INTO nyu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Munthu ni wakufunika kwene-kwene kuposa bira! Na tenepo, ni bzakubvumizidwa kucita bzabwino pa ntsiku ya malinkhuma”. ");
INSERT INTO nyu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pamwepo Iye adauza mwamunayo kuti: “Futhula boko”. Iye adafuthula, ndipo iro lidalimba, licikhala ninga lindzace. ");
INSERT INTO nyu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ndipo afalizi wale adacoka aciyamba kunyang'ana njira yakuti aphe Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jezu atadziwa bzimwebzi adacoka mbuto imweire. Wanthu azinji adam'tewera, ndipo Iye adacirisa atenda wentse omwe akhali pamwepo, ");
INSERT INTO nyu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ndipo adawacenjeza kuti aleke kuuza winango kuti Iye akhali yani. ");
INSERT INTO nyu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bzimwebzi bzidacitika kuti bzikwanirisidwe bzomwe bzidalewedwa na Mulungu kudzera mwa m'polofita Izaiya kuti: ");
INSERT INTO nyu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Onani m'tumiki wangu, omwe ndasankhula, omwe nimbafuna, omwe m'tima wangu umbakondwera naye. Nin'dzaikha mwa iye Mzimu, wangu, ndipo iye an'dzapalidza cirungamo kuna mbumba zentse. ");
INSERT INTO nyu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","An'dzacita lini makani ngakhale kukuwa. Palibe omwe an'dzabva fala lace m'miseu. ");
INSERT INTO nyu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","An'dzagwata lini mtete wakuchoka, napo kuthima lambi lakugaka pang'ono, mpaka cirungamo cikunde. ");
INSERT INTO nyu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mudzina lace mbumba zin'dzaikha cidikhiro cawo”. ");
INSERT INTO nyu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pambuyo pa bzimwebzi, adam'bweresera munthu wakuphatidwa na ciwanda omwe akhawona lini ndipo akhalewa-lewa lini, tsono Jezu adamulimbisa, mwakuti iye adayamba kuwona na kulewa-lewa. ");
INSERT INTO nyu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mbumba yentse idatsitsimwa nabzo iciti: “Ngumweyu lini Mwana wa Davidi?” ");
INSERT INTO nyu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tsono pomwe afalizi adabva bzimwebzo adati: “Umweyu alikucosa bziwanda na mphambvu ya Belezebu, m'kulu wa bziwandabzo”. ");
INSERT INTO nyu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jezu pakudziwa bzakukumbuka bzawo adawauza kuti: “Umambo uli wentse ukabzigawa un'pfudzika, ndipo mzinda uli wentse ayai nyumba ikabzigawa in'pitiriza lini. ");
INSERT INTO nyu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ndipo penu Sathani an'thotha Sathani, alikubzigawa yekha. Na tenepo umambo bwace bungadzapitirize tani? ");
INSERT INTO nyu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ndipo penu Ine nin'thotha bziwanda na mphambvu ya Belezebu, kodi wana wanu ambathotha na mphambvu ya yani? Na tenepo iwo caiwo an'dzakhala atongi wanu. ");
INSERT INTO nyu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tsono penu ni mwa Mzimu wa Mulungu omwe nin'thotha nawo bziwanda, pamwepo Umambo bwa Mulungu bwafika kuna imwe. ");
INSERT INTO nyu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ayai, munthu angapite tani m'nyumba ya munthu wa mphambvu, acimubera bzinthu bzace akanati kum'manga pakuyamba? Na tenepo ndipo angakwanise kuba bza m'nyumbamo. ");
INSERT INTO nyu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ule omwe ali rini na Ine, ngwakundiwenga. Ndipo ule omwe an'gwezeka lini na Ine an'mwaza. ");
INSERT INTO nyu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Thangwe ra bzimwebzi Ine nin'kuuzani kuti: Wanthu wakuphonyera Mulungu na kunyoza kuli kwentse an'dzalekeredwa, tsono kunyoza Mzimu wa Mulungu an'dzalekereredwa lini. ");
INSERT INTO nyu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wentse ule omwe anirewa kuipa Mwana wa munthu an'dzalekereredwa, tsono omwe anirewa kuipa Mzimu wa Wakucena an'dzalekereredwa lini, ngakhale tsapano lino ayai kutsogoloko. ");
INSERT INTO nyu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Muti wabwino un'bala cisapo cabwino, ndipo muti wakuipa un'bala cisapo cakuipa, nakuti muti umbadziwika na cisapo cace. ");
INSERT INTO nyu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mtundu wa nyoka za ululu, mungalewe tani bzinthu bzabwino uko imwepo ndimwe wakuipa? Nakuti mulomo umbalewa bzomwe bzidadzala mum'tima. ");
INSERT INTO nyu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Munthu wabwino ambacosa bzinthu bzabwino m'thenthe mwabwino, tsono munthu wakuipa ambacosa bzinthu bzakuipa m'thenthe mwakuipa. ");
INSERT INTO nyu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tsono Ine nin'kuuzani kuti, ntsiku ya kutongedwa wanthu an'dzatawira mulandu wa fala liri lentse lakusaya basa lomwe adalewa. ");
INSERT INTO nyu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pakuti na mafala yanu mun'dzalekereredwa ndipo na mafala yanu mun'dzamangidwa mulandu”. ");
INSERT INTO nyu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pamwepo afalizi na adziwi wa Mtemo winango adamuuza kuti: “M'pfundzisi, tin'funa kuwona cizindikiro cakudabwisa cakucitidwa na Imwe”. ");
INSERT INTO nyu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tsono Jezu adatawira kuti: “M'badwe wakuipa ndipo wakusaya kukhulupirika, ulikukumbira cizindikiro cakudabwisa! Tsono palibe cizindikiro comwe mun'citiridwa, kupambula cizindikiro ca m'polofita Jona. ");
INSERT INTO nyu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Na tenepo ninga Jona adakhala m'mimba mwa ntsomba ikulu ntsiku zitatu na usiku butatu, na tenepoyo Mwana wa munthu an'dzakhalambo ntsiku zitatu na usiku butatu pantsi pa dziko. ");
INSERT INTO nyu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ntsiku ya kudzatongedwa wanthu wa mzinda wa Ninive an'dzalamuka na m'badwe umweyu ndipo an'dzaumanga mulandu. Nakuti iwo adakhumbula kudzera mukupalidza kwa Jona, ndipo ali pano tsapanoyu ni m'kulu kuposa Jona. ");
INSERT INTO nyu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ntsiku ya kudzatongedwa mambo wacikazi wakunyantsi an'dzamuka na m'badwe umweyu, ndipo an'dzaumanga mulandu, nakuti iye adabwera kucokera kwakumalizira dziko kuti adzabve udziwi bwa Solomoni, ndipo ali pano tsapanoyu ni m'kulu kuposa Solomoni. ");
INSERT INTO nyu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Pomwe m'zimu wakuipa un'coka mwa munthu, umbayenda kumbuto zakuuma ucikanyang'ana mbuto ya kupumira, tsono umbaiwona lini. ");
INSERT INTO nyu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ndipo umbati: ‘Nin'bwerera kunyumba komwe ndidacoka’. Ukafika, un'gumana m'nyumbamo mulibe winango, mwakupsairidwa ndipo mwakulongedwa bwino. ");
INSERT INTO nyu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Pamwepo uniyenda ucikatenga mizimu inango minomwe yamphambvu kuposa iwo, ndipo ikapita imbakhala m'mwemo. Na tenepo khalidwe la kumalizira la munthu ule limbadzaipa kuposa pakuyamba. Bzimwebzi ndibzo bzin'dzacitika kwa m'badwe uno wakuipa”. ");
INSERT INTO nyu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Pomwe Jezu akhalewa na m'thithi, mai wace na abale wace adabwera aciima panja, akhafuna kulewa-lewa naye. ");
INSERT INTO nyu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ndipo munthu winango adamuuza kuti: “Mai na abale wanu ali panjapa ndipo alikufuna kulewa-lewa na imwepo”. ");
INSERT INTO nyu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jezu adam'tawira kuti: “Mai wangu mbani, ndipo abale wangu mbani?” ");
INSERT INTO nyu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ndipo adalata wakupfundzira wace aciti: “Ali pano mai wangu na abale wangu! ");
INSERT INTO nyu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nakuti ule omwe an'cita cifuniro ca Baba wangu omwe ali kudzulu, umweyo ndiye m'bale wangu, mpfumakazi yangu na mai wangu”. ");
INSERT INTO nyu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ntsiku ibodzi-bodziyo Jezu adacoka m'nyumba acikakhala m'phepete mwa nyandza ya Galireya. ");
INSERT INTO nyu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ndipo mthithi ukulu wa wanthu udamuzungulira, na tenepo Iye adapakira m'bote acikhala m'mwemo. Ndipo mbumba yentse ikhadaima pagombe. ");
INSERT INTO nyu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jezu adawauza bzinthu bzizinji m'mifananizo acimbati: “Mulimi adayenda kabzala. ");
INSERT INTO nyu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pomwe akhawaza mbeu inango idagwera m'phepete mwa njira, ndipo mbalame zidabwera ziciidya. ");
INSERT INTO nyu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Inango idagwera pa mbuto ina minyala, pomwe pakhalibe mataka mazinji. Ndipo idamera mwakam'fulumize nakuti pakhalibe mataka mazinji. ");
INSERT INTO nyu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tsono pomwe dzuwa lidacoka, m'mera udapsa uciuma, thangwe mizi ikhalibe kuzika. ");
INSERT INTO nyu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeu inango idagwera pakati pa minga, ndipo mingayo idakula icipsindiza mbeuyo. ");
INSERT INTO nyu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tsono inango idagwera pamataka yabwino, imwei idabereka dzana (100), inango makumi matanthatu (60), inango makumi matatu (30) bzakufunya kuposa pakuyamba. ");
INSERT INTO nyu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Omwe ana makutu, abve!” ");
INSERT INTO nyu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wakupfundzira wace adafendera pafupi naiye acimubvundza kuti: “Thangwe ranyi mumbalewa na mbumba mumifananizo?” ");
INSERT INTO nyu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iye adawatawira kuti: “Imwepo mudapasidwa kudziwa bzintsintsi bza Umambo bwa kudzulu, tsono iwo alibe kupasidwa. ");
INSERT INTO nyu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pakuti omwe anabzo an'dzapasidwa, ndipo an'dzakhala na bzizinji kwene-kwene. Tsono kuna omwe alibe, napo comwe anaco an'dzatengeredwa. ");
INSERT INTO nyu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tsono amwewa nimbalewa nawo mumifananizo thangwe ra kuti: “ ‘Alikunyang'anisa, alikuwona lini, ndipo alikutetekera, alikubva lini napo kubvesesa’. ");
INSERT INTO nyu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bzirikwanirisika mwa iwo bzomwe m'polofita Izaiya adalewa kuti: “ ‘Kubva mun'dzabva, tsono mun'dzabvesesa lini cipo. Kuwona mun'dzawona, tsono mun'dzadziwa lini cipo. ");
INSERT INTO nyu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Pakuti m'tima wa mbumba imweyi wakhala wakuumisidwa. Mwakusaya kufuna adabva na makutu yawo ndipo adafunga maso yawo, kuti aleke kuwona pomwe na maso, ngakhale kubva na makutu, kuti aleke kubvesesa na m'tima, acitendeuka, ndipo Ine ningadawaciza’. ");
INSERT INTO nyu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tsono maso yanu ni yakudala, thangwe yalikuwona. Ndipo makutu yanu, thangwe yalikubva. ");
INSERT INTO nyu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cadidi nin'kuuzani kuti: Apolofita azinji na wakulungama akhafuna kuwona bzomwe imwepo muli kuwona, tsono alibe kubziwona, ndipo kubva bzomwe imwepo mulikubva, tsono alibe kubzibva. ");
INSERT INTO nyu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Na tenepo, bvani m'fananizo wa mulimi kuti ulikulewa ciyani: ");
INSERT INTO nyu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Munthu ali-yentse akabva mafala ya Umambo acisaya kuyabvesesa, Wakuipa ambabwera acim'tengera bzomwe bzidabzalidwa mum'tima mwace. Umweyo adakhala ninga yomwe idabzalidwa m'phepete mwa njira. ");
INSERT INTO nyu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kuna zomwe zidabzalidwa paminyala, umweyu ni ule omwe ambabva mafala ndipo aciyatambira nthawe imweyo letu mwakupfatsa. ");
INSERT INTO nyu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tsono, pakuti alibe mizi ambakhala nthawe pang'ono. Pangawoneka mabvuto ayai kufambiridwa mbuyo thangwe ra mafalayo, ambacokeratu. ");
INSERT INTO nyu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kuna zomwe zidabzalidwa paminga, ni ule omwe ambabva mafala, tsono kutanganidwa na khalidwe la moyo uno na kupumpsika na cuma ambapsindiza mafalayo, yacikhala yakusaya kubala. ");
INSERT INTO nyu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ndipo mbeu yomwe idabzalidwa pamataka yabwino, ni ule omwe ambabva mafala aciyabvesesa, ndipo ambabereka bzisapo dzana, winango makumi matanthatu ndipo winango makumi matatu”. ");
INSERT INTO nyu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jezu adawauza m'fananizo winango aciti: “Umambo bwa kudzulu budalingana na munthu omwe adabzala mbeu yabwino m'munda mwace. ");
INSERT INTO nyu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tsono pomwe wentse akhadagona, nyamadulanthaka wace adabwera acibzala nyakasongole pakati pa tirigu aciyenda. ");
INSERT INTO nyu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pomwe m'mera udakula ucitumbuka, nyakasongole adawonekambo”. ");
INSERT INTO nyu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Akapolo wa mwenekaciro wa munda, adabwera kuna iye acimuuza kuti: ‘Mbuya, kodi mulibe kubzala mbeu yabwino m'munda mwanu? Tsono, nyakasongole adacokera kuponi?’ ” ");
INSERT INTO nyu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Iye adatawira kuti: “ ‘Ni nyamadulanthaka acita bzimwebzi’. “Akapolo adam'bvundza pomwe kuti: ‘Mbuya mun'funa kuti tikam'zule?’ ");
INSERT INTO nyu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Iye adatawira kuti: ‘Nee, thangwe imwepo pakukazula nyakasongole, mungakazulire pabodzi na tirigu. ");
INSERT INTO nyu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lekani bzikulire pabodzi mpaka nthawe yakubvuna. Pamwepo nin'dzauza wakubvuna kuti: Cakuyamba gwatani nyakasongole, mumange mitolo kuti atenthedwe. Pambuyo pace konkhobzani tirigu mukoye m'gwangwa mwangu’ ”. ");
INSERT INTO nyu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ndipo adawauza m'fananizo unango aciti: “Umambo bwa kudzulu buli ninga njere ya m'towe, yomwe munthu adabzala m'munda mwace. ");
INSERT INTO nyu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iyo ni ing'ono pa njere zentse, tsono ingakula imbakhala muti ukulu, mwakuti mbalame za kudzulu zimbabwera kudzakondza bzitsa mumithawi yace”. ");
INSERT INTO nyu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ndipo adawauza pomwe m'fananizo unango aciti: “Umambo bwa kudzulu buli ninga cakufufumisa comwe mkazi adatenga acicisanganiza na ufa buzinji ndipo bzakumunyidwabzo bzentse bzidafufuma”. ");
INSERT INTO nyu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jezu adalewa bzinthu bzentsenebzi kuna m'thithi m'mifananizo. Palibe comwe adalewa mwakusaya kuphatisa basa m'fananizo. ");
INSERT INTO nyu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Na tenepo kuti bzikwanirisidwe bzomwe bzidalewedwa na m'polofita kuti: “Nin'dzafungula mulomo wangu m'mifananizo, nin'dzazimbula bzinthu bzakubisika kuyambira cirengedwe ca dziko”. ");
INSERT INTO nyu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pamwepo Jezu adasiya m'thithiyo aciyenda kumui. Wakupfundzira wace adafendera pafupi naye ndipo adamukumbira kuti: “Tifokotozereni bza m'fananizo wa nyakasongole m'munda”. ");
INSERT INTO nyu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iye adatawira kuti: “Ule omwe adabzala mbeu yabwino ni Mwana wa munthu. ");
INSERT INTO nyu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Munda ni dziko la pantsi, ndipo mbeu ya bwino ni wana wa Umambo. Nyakasongole ni wana wa Wakuipa, ");
INSERT INTO nyu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ndipo nyamadulanthaka omwe adam'bzala ni Dyabu. Kubvuna ni cimaliziro ca nthawe ino, ndipo wakubvuna ni anju. ");
INSERT INTO nyu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Tenepoyo ninga nyakasongole an'dzakhongobzedwa acitenthedwa pa moto, tenepoyombo bzin'dzacitika pakumalizira kwa nthawe ino. ");
INSERT INTO nyu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana wa munthu an'dzatumiza anju wace ndipo iwo an'dzacosa muUmambo bwace bzentse bzomwe bzimbagwegwedusa na wentse omwe ambacita bzakuipa. ");
INSERT INTO nyu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Iwo an'dzawathusa pa cipala ca moto, pomwe pan'dzakhala kulira na kukukuta mano. ");
INSERT INTO nyu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pamwepo wakulungama an'dzayetima ninga dzuwa muUmambo bwa Baba wawo. Omwe ana makutu, abve. ");
INSERT INTO nyu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Umambo bwa kudzulu buli ninga cuma cakubisidwa m'munda. Munthu winango adacigumana acicibisa pomwe, ndipo mwakukomedwa adayenda kagulisa bzentse bzomwe akhanabzo acikagula munda ule. ");
INSERT INTO nyu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Umambo bwa kudzulu budakhalambo ninga nyamalonda omwe ambanyang'ana minyala yakufunidwa. ");
INSERT INTO nyu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Atagumana mwala wakufunidwa kwene-kweneyo, adayenda acikagulisa bzentse bzomwe akhanabzo aciugula. ");
INSERT INTO nyu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Umambo bwa kudzulu budakhala pomwe ninga bwazi bomwe bumbathusidwa m'nyandza ndipo bumbaphata mtundu wentse wa ntsomba. ");
INSERT INTO nyu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bungadzala akhombwe ambabupfuwira pa gombe. Pamwepo ambakhala acikonkhobza ntsomba zabwino m'bzitundu, tsono ambataya kunja zakuipa. ");
INSERT INTO nyu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tenepoyo bzin'dzacitika pakumalizira kwa nthawe ino. Anju an'dzabwera, acidzapambula wakuipa pa wakulungama ");
INSERT INTO nyu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ndipo wakuipawo an'dzawathusa kudindi la moto, komwe kun'dzakhala kulira na kukukuta mano”. ");
INSERT INTO nyu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pamwepo Jezu adawabvundza kuti: “Imwepo mwabvesesa bzinthu bzentsenebzi?” Iwo adatawira kuti: “Inde”. ");
INSERT INTO nyu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ndipo Jezu adabvundza wakupfundzira wace kuti: “Na tenepo m'nembi wa Mtemo aliwentse omwe adapfundzisidwa bza Umambo bwa kudzulu, adakhala ninga mwenekaciro wa nyumba omwe ambacosa pacuma cace bzinthu bzipsa na bza ntsundi”. ");
INSERT INTO nyu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ndipo Jezu atamala kufokotoza mifananizo imweyi, adacoka kumweko. ");
INSERT INTO nyu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pomwe adafika kumzinda wace, adayamba kupfundzisa mbumba munyumba za mapembo. Wentse adadabwisidwa ndipo adabvundzana aciti: “Kodi udziwi bumwebu na mphambvu za kucita bzidabwisobzi abziwona kuponi? ");
INSERT INTO nyu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kodi ngumweyu lini mwana wa misiri wa matabwa? Mai wace an'cemeredwa lini Maliya, ndipo abale wace Tiyago, Zuze, Simau na Juda? ");
INSERT INTO nyu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mpfumakazi zace timbakhala lini nazo pabodzi? Tsono bzinthu bzentsenebzi bzidacokera kuponi?” ");
INSERT INTO nyu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ndipo iwo adaipidwa naye. Tsono Jezu adawauza kuti: “M'polofita ambalemekezedwa kumbuto zentse, kupambula kudziko lace na kumui kwace”. ");
INSERT INTO nyu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ndipo alibe kucita bzidabwiso bzizinji kumweko thangwe ra kusaya kukhulupirira kwawo. ");
INSERT INTO nyu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Panthawe imweyo Herodi, mambo wa cigawo ca Galireya, adabva mbiri ya Jezu ");
INSERT INTO nyu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ndipo adauza omwe akham'tumikira kuti: “Umweyu ni Juwau M'batizi. Iye adamuka kwa wakufa! Ndipo ali kucita bzidabwiso bzentsenebzi”. ");
INSERT INTO nyu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Pakuti Herodi akhadaphata Juwau, acim'manga ndipo adamuikha m'kawoko thangwe ra Herodiyasi, mkazi wa Filipi m'bale wace, ");
INSERT INTO nyu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nakuti Juwau akhamuuza kuti: “Ni bzakuletsedwa na Mtemo kuti ukhale naye mkaziyu”. ");
INSERT INTO nyu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodi akhafuna kumupha tsono akhana mantha na mbumba, thangwe iyo ikhalewa kuti Juwau ni m'polofita. ");
INSERT INTO nyu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tsono pantsiku ya kukondwerera kubadwa kwa Herodi, mwana wacikazi wa Herodiyasi adabzina patsogolo pa wentse, ndipo adakondweresa Herodi ");
INSERT INTO nyu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","mwakuti iye adapicira mwa kulumbira kuti an'dzam'pasa comwe iye angakumbire. ");
INSERT INTO nyu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mwanayo mwakuthandizidwa na mai wace, iye adati: “Ndipaseni tsapanopa msolo wa Juwau M'batizi mundiro”. ");
INSERT INTO nyu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mambo adasukwala, tsono thangwe ra kulumbira komwe akhadacita patsogolo pa wakucemeredwa, adalewa kuti apasidwe comwe mtsikanayo akhadakumbira ");
INSERT INTO nyu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ndipo adatuma kuti akagwate msolo wa Juwau m'kawoko. ");
INSERT INTO nyu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Msolo wace udabweresedwa mundiro acim'pasa mtsikanayo, omwe adauyendesa kuna mai wace. ");
INSERT INTO nyu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pamwepo wakupfundzira wa Juwau adabwera, acitenga thupi lace ndipo adakam'pendesa. Patsogolo pace adayenda kauza Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jezu atabva bzomwe bzidacitikabzo, adacoka na bote aciyenda kucidambo yekha. Mithithi pomwe idabva bzimwebzo, idacoka m'mizinda icimutewera na kunja. ");
INSERT INTO nyu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pomwe Jezu adacoka m'bote adawona m'thithi ukulu kwene-kwene, adawabvera ntsisi ndipo adaciza atenda wawo. ");
INSERT INTO nyu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ndipo nthawe ya kumaulo, wakupfundzira wace adafendera pafupi naye acimuuza kuti: “Kuno ni kuthengo, ndipo kuli kudoka. Auzeni wanthuwa ayende m'mii kuti akagule cakudya”. ");
INSERT INTO nyu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jezu adawatawira kuti: “Iwo bzin'funika lini kuti ayende. Apaseni imwepo cakudya”. ");
INSERT INTO nyu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iwo adam'tawira kuti: “Bzomwe tinabzo pano ni pau zixanu (5) na ntsomba ziwiri (2) basi”. ");
INSERT INTO nyu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ndipo Iye adati: “Ndibweresereni kuno”. ");
INSERT INTO nyu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na tenepo adauza m'thithiyo kuti ukhale pa kapinga. Ndipo adatenga pau zixanu (5) na ntsomba ziwirizo (2), adanyang'ana kudzulu acitenda Mulungu ndipo adagwata pauzo. Patsogolo pace adaipereka kuna wakupfundzira, kuti apase mthithi. ");
INSERT INTO nyu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wentse adadya acikhuta, ndipo wakupfundzira adakonkhobza bzitundu khumi na bziwiri (12) bzakusala. ");
INSERT INTO nyu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Omwe adadya akhakwanira bzulu bzixanu (5,000) bza amuna okha, pakusaya kulewenga akazi na wana. ");
INSERT INTO nyu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bzatamala bzimwebzo Jezu adangingimiza wakupfundzira wace kuti apakire m'bote ndipo abakatsogole ng'ambo inango, uko Iye akhagonekana na mthithi. ");
INSERT INTO nyu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Atamala kugonekana na mthithi, adakwira m'phiri kuti akapembe yekha. Pomwe kukhadoka Iye akhali yekha kumweko, ");
INSERT INTO nyu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","tsono bote likhali pakati pa nyandza, likhamenyedwa na mabimbi thangwe condzi cikhacokera kutsogolo kwalene. ");
INSERT INTO nyu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Madandakweca, Jezu adayenda kuna iwo, ali kufamba padzulu pa madzi. ");
INSERT INTO nyu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pomwe adamuwona ali kufamba padzulu pa madzi, adakhala na mantha ndipo adati: “Ni ciphoko!” Ndipo adakuwa na mantha. ");
INSERT INTO nyu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tsono pamwepoletu Jezu adawauza kuti: “Khazikani m'tima! Ndine. Lekani mantha!” ");
INSERT INTO nyu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedru adati: “Mbuya, penu ndimwe, ndiuzeni ndibwere kuna Imwe padzulu pa madzi”. ");
INSERT INTO nyu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iye adatawira kuti: “Bwera”. Pamwepo Pedru adacoka m'bote, acifamba padzulu pa madzi ndipo adayenda cipande cikhana Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tsono pomwe adawona mphambvu ya condzi adabva mantha ndipo adayamba kumira acikuwa aciti: “Ndipulumuseni, Mbuya!” ");
INSERT INTO nyu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Pamwepoletu Jezu adapfuthula boko acim'phata. Ndipo adati: “Mwamuna wa cikhulupiriro cing'ono-ng'ono, thangwe ranyi iwepo wapenula?” ");
INSERT INTO nyu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pomwe adapakira m'bote condzi cidamala. ");
INSERT INTO nyu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pamwepo omwe akhali m'botemo adam'pemba aciti: “Cadidi-retu Imwe ndimwe Mwana wa Mulungu”. ");
INSERT INTO nyu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ndipo pomwe adayambuka nyandza, adafika kuGenezarete. ");
INSERT INTO nyu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pomwe wanthu wa kumweko adazindikira Jezu, adamwaza nkhani kumbali zentse za mbuto ire ndipo adam'bweresera atenda wawo. ");
INSERT INTO nyu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Akham'kumbira mwa kudandaula kuti andokhuya ntsonga ya cakubvala cace. Ndipo wentse omwe adakhuya adalimbisidwa. ");
INSERT INTO nyu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pamwepo adabwera kuna Jezu afalizi anango na adziwi wa Mtemo, kucokera kuJerusalema, acimubvundza kuti: ");
INSERT INTO nyu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Thangwe ranyi wakupfundzira wanu alikuchola mwambo wa makolo? Pakuti ambasamba lini m'manja pakudya!” ");
INSERT INTO nyu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jezu adatawira kuti: “Ni thangwe ranyi imwepo mumbachola bzakutonga bza Mulungu muciteweza mwambo wanu? ");
INSERT INTO nyu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Na tenepo Mulungu adati: ‘Lemekeza baba wako na mai wako’ ndipo ‘Wakunyoza baba wace ayai mai wace bzin'funika kuti aphedwe’. ");
INSERT INTO nyu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tsono imwepo mumbatsimikiza kuti penu winango anirewa baba wace ayai mai wace kuti: ‘Thandizo lirirentse lomwe imwepo mukhafuna kutambira kuna ine ni cakupereka kwa Mulungu’, ");
INSERT INTO nyu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","iye an'kakamizidwa lini pomwe ‘kulemekeza baba wace’. Na tenepoyo mwanyozera fala la Mulungu, thangwe ra mwambo wanu. ");
INSERT INTO nyu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Imwe wacipha-maso! M'polofita Izaiya adalewa bwino mafala ya Mulungu thangwe ra imwe, pomwe adati: ");
INSERT INTO nyu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Mbumba imweyi imbandiremekeza na miromo, tsono mitima yawo iri kutali na Ine. ");
INSERT INTO nyu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ambandipemba mwakusaya basa, pakuti ambapfundzisa mitemo yakucokera kwa wanthu ninga ni yangu’”. ");
INSERT INTO nyu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ndipo Jezu adacemera m'thithi acirewa kuti: “Bvani ndipo bvesesani. ");
INSERT INTO nyu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Comwe cin'pita na pamulomo ndico lini ‘cimbasvipisa’ munthu, tsono comwe cimbacoka pamulomo pace cimweco ndico ‘cimbam'svipisa’ ”. ");
INSERT INTO nyu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pamwepo wakupfundzira adafendera kuna Iye acimuuza kuti: “Mun'dziwa kuti afalizi adakalipa pomwe adabva bzimwebzire?” ");
INSERT INTO nyu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Iye adatawira kuti: “Muti uli wentse omwe Baba wangu wakudzulu alibe kuubzala un'dzazulidwa. ");
INSERT INTO nyu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Asiyeni iwo, ni atsogoleri azimola. Penu zimola an'tsogolera zimola mwandzace, awiriwo an'gwera m'dindi”. ");
INSERT INTO nyu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pamwepo Pedru adam'kumbira kuti: “Tifotokozereni m'fananizo ule”. ");
INSERT INTO nyu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jezu adawabvundza kuti: “Kodi imwepo mukanati kubvesesa? ");
INSERT INTO nyu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mulikubvesesa lini kuti comwe cin'pita pamulomo ciniyenda m'mimba ndipo patsogolo pace cimbakataidwa kuthengo? ");
INSERT INTO nyu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tsono bzinthu bzomwe bzimbacoka pamulomo bzimbacokera mum'tima, ndipo ni bzimwebzi bzomwe ‘bzimbasvipisa’ munthu. ");
INSERT INTO nyu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pakuti mum'tima mumbacoka ndzeru zakuipa, kuphana, upombo, malume ya pamphasa, kuba, umboni bwakunama na kunyoza. ");
INSERT INTO nyu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Bzinthu bzimwebzi ndibzo ‘bzimbasvipisa’ munthu. Tsono kudya alibe kusamba m'manja ‘kunimusvipisa’ lini”. ");
INSERT INTO nyu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ndipo Jezu atacoka kumweko, adayenda kumbali ya Tiro na Sidoni. ");
INSERT INTO nyu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mkazi m'bodzi waciKanani, mbadwe yakumweko, adabwera kuna iye acimbakuwa kuti: “Mbuya, Mwana wa Davidi, ndibvereni ntsisi! Mwana wangu ana ciwanda ndipo ali kubonera kwene-kwene”. ");
INSERT INTO nyu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tsono Jezu alibe kumutawira fala. Pamwepo wakupfundzira wace adamufenderera acimukumbira kuti: “Muuzeni ayende, nakuti alikubwera mbuyo mwathu acimbakuwa”. ");
INSERT INTO nyu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iye adatawira kuti: “Ine ndatumidwa kuna aIjirayeri okha omwe ali ninga mabira yakutaika”. ");
INSERT INTO nyu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mkaziyo adabwera, adam'godamira acim'pemba adati: “Mbuya, ndithandizeni!” ");
INSERT INTO nyu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iye adatawira kuti: “Ni bwino lini kucosa pau za wana, ucithusira tunkhanda”. ");
INSERT INTO nyu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tsono mkaziyo adati: “Inde, Mbuya, tsono mpaka tunkhanda tumbadya mbvululu zomwe zimbagwa pakudyera mbuya watwene”. ");
INSERT INTO nyu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jezu adatawira kuti: “Mkaziwe cikhulupiriro cako ni cikulu! Bzicitike ninga momwe un'funira”. Ndipo nthawe imweireletu mwana wace adalimbisidwa. ");
INSERT INTO nyu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jezu adacoka kumweko aciyenda m'mphepete mwa nyandza ya Galireya. Patsogolo pace adakwira paphiri acikhala. ");
INSERT INTO nyu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mthithi ukulu udayenda kuna Iye, adatakula wakupunduka, wakulemala, azimola, mabewewe na anango atenda azinji, aciwaikha m'minyendo mwace. Ndipo Iye adawacirisa. ");
INSERT INTO nyu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mbumba idadabwisidwa pomwe adawona mabewewe acirewa-lewa, wakulemala kulimbisidwa, wakupunduka acifamba ndipo azimola aciwona. Ndipo adatumbiza Mulungu wa Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jezu adacemera wakupfundzira wace aciwauza kuti: “Ndina ntsisi na mthithiyu. Palikupita ntsiku zitatu iwo ana Ine ndipo alibe cakudya. Nin'funa lini kuwayendesa na njala, thangwe angadzakomoke panjira”. ");
INSERT INTO nyu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wakupfundzira wace adatawira kuti: “Tiniziwona kuponi pau m'thengo muno, zomwe zin'kwana wanthu wentsenewa?” ");
INSERT INTO nyu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jezu adawabvundza kuti: “Muna pau zingasi?” Iwo adatawira kuti: “Zinomwe na ntsomba zinango”. ");
INSERT INTO nyu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iye adauza mthithi kuti ukhale pantsi. ");
INSERT INTO nyu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Patsogolo pace adatenga pau zinomwezire na ntsomba acitenda Mulungu, adaigwata aciipereka kuna wakupfundzira wace ndipo iwo adapasa mbumba. ");
INSERT INTO nyu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wentse adadya acikhuta. Ndipo adakhongobza bzakusala bzitundu bzinomwe bzakudzala. ");
INSERT INTO nyu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Omwe adadya akhali amuna bzulu bzinai (4,000), pakusaya kulewenga akazi na wana. ");
INSERT INTO nyu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ndipo atamala kugonekana na mthithi, Jezu adapakira m'bote aciyenda kumbali ya Magadani. ");
INSERT INTO nyu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ndipo afalizi na aSaduki adafendera kuna Jezu acikamuyeza, na kumukumbira kuti awawonese cizindikiro cakucokera kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Iye adatawira kuti: “Maulo yangafika, imwepo mumbati: ‘Mangwana kun'dzakhala bwino, thangwe kudzulu kudafuira’, ");
INSERT INTO nyu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ndipo macibese mumbati: ‘Lero kun'cita condzi, thangwe kudzulu kudafuira ndipo kuna mitambo’. Imwepo mumbakwanisa kuthandauzira makhalidwe ya kudzulu, tsono mumbakwanisa lini kuthandauzira bzizindikiro bza nthawe! ");
INSERT INTO nyu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","M'badwe wakuipa ndipo wakusaya kukhulupirika un'kumbira cizindikiro cakudabwisa, tsono palibe cizindikiro na cibodzico mun'dzapasidwa, kupambula cizindikiro ca Jona”. Pamwepo Jezu adawasiya acicoka. ");
INSERT INTO nyu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pomwe wakupfundzira adayenda kumbali ina ya nyandza, adayebwa kutenga pau. ");
INSERT INTO nyu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jezu adawauza kuti: “Khalani na cheru ndipo mpholeni na cakutupisa ca afalizi na aSaduki”. ");
INSERT INTO nyu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ndipo wakupfundzira akhambabvundzana kuti: “Ndiko kulewa kuti tiribe kubweresa pau”. ");
INSERT INTO nyu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jezu pomwe adazindikira kubvundzanako adati: “Amuna wacikhulupiriro pang'ono, thangwe ranyi imwepo muli kubvundzana bzakuti mulibe pau? ");
INSERT INTO nyu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mukanati kubvesesa? Mun'kumbuka lini bza pau zixanu (5) zidakwanira wanthu bzulu bzixanu (5,000) ndipo bzitundu bzingasi bzomwe imwepo mudakhongobza? ");
INSERT INTO nyu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Napo bza pau zinomwe zomwe zidakwana wanthu bzulu bzinai ndipo bzitundu bzingasi bzomwe mudakhongobza? ");
INSERT INTO nyu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Muli kusaya tani kubvesesa kuti ndiri kulewa lini bza pau? Na tenepo cenjerani na cakutupisa ca afalizi na aSaduki”. ");
INSERT INTO nyu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pamwepo adabvesesa kuti akhalewa lini kuti acenjere na cakutupisa pau, tsono na cipfundziso ca afalizi na aSaduki. ");
INSERT INTO nyu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jezu pomwe adafika kumbali ya Sezareya wa Filipi, adabvundza wakupfundzira wace kuti: “Kodi wanthu ambalewa kuti Ine Mwana wa munthu ndine yani?” ");
INSERT INTO nyu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Iwo adatawira kuti: “Anango ambalewa kuti ndimwe Juwau M'batizi. Anango Eriya, ndipo anango Jeremiya ayai m'polofita winango”. ");
INSERT INTO nyu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iye adabvundza kuti: “Tsono imwepo mumbalewa kuti Ine ndine yani?” ");
INSERT INTO nyu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simau Pedru adatawira kuti: “Imwe ndimwe Krixtu Mwana wa Mulungu wa moyo”. ");
INSERT INTO nyu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jezu adatawira kuti: “Wakusimbidwa ndiwe, Simau, mwana wa Jona! Thangwe bzimwebzi bziribe kuzimbulidwa na thupi ayai mulopa, tsono na Baba wangu omwe ali kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ndipo Ine nin'kuuza kuti iwe ndiwe Pedru, ndipo padzulu pa mwala umweyu nin'dzamanga gereja yangu, ndipo ngakhale impfa in'dzaikunda lini. ");
INSERT INTO nyu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ine nin'dzakupasa bzifungulo bza Umambo bwa kudzulu. Bzomwe iwepo un'dzamanga padziko la pantsi, bzindzakhala bzakumangidwa kudzulu, ndipo bzomwe iwepo un'dzatsudzula padziko lapantsi bzin'dzatsudzulidwambo kudzulu”. ");
INSERT INTO nyu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pamwepo adauza wakupfundzira wace kuti aleke kauza winango kuti Iye ni Krixtu. ");
INSERT INTO nyu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kuyambira nthawe imweire Jezu adayamba kufokotozera wakupfundzira wace kuti ni bzakufunika kuti Iye ayende kuJerusalema ndipo akaboneresedwe na bzinthu bzizinji m'manja mwa atsogoleri wa aJuda, akulu-akulu wa anyantsembe, na adziwi wa Mtemo, akaphedwe acidzalamusidwa ntsiku ya citatu. ");
INSERT INTO nyu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pamwepo Pedru adam'cemera kumphimpha, aciyamba kum'gaza aciti: “Bzingacitike lini, Mbuya! Bzimwebzo cipo bzin'dzakucitikirani lini!” ");
INSERT INTO nyu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jezu adazungunuka aciuza Pedru kuti: “Coka kumbuyo kwangu, Sathani! Imwepo ndiwe mwala wakugwegwedusa kuna Ine, ndipo un'kumbuka lini bzinthu bza Mulungu, tsono bza wanthu”. ");
INSERT INTO nyu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pamwepo Jezu adauza wakupfundzira wace kuti: “Penu munthu an'funa kunditewera, abzirambe iye yekha, atenge m'tanda wace aditewere. ");
INSERT INTO nyu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pakuti omwe an'funa kupulumusa moyo wace, an'dzauluza, tsono omwe aniruza moyo wace thangwe ra Ine an'dzauwona. ");
INSERT INTO nyu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kodi munthu an'dzaphindula ciyani angatambira dziko lentse aciruza moyo wace? Ayai ni ciyani comwe munthu angacinjanise na moyo wace? ");
INSERT INTO nyu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pakuti Mwana wa munthu an'dzabwera muulemerero wa Baba wace, na anju zace ndipo an'dzabwezera kuna m'bodzi na m'bodzi malingana na bzomwe adacita. ");
INSERT INTO nyu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nin'kuuzani cadidi kuti: Anango omwe alikuwoneka pampanowa an'dzaiwona lini impfa akanati kuwona Mwana wa munthu alikubwera muUmambo bwace”. ");
INSERT INTO nyu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Zatapita ntsiku zitanthatu (6) Jezu adatenga Pedru, Tiyago na Juwau m'bale wa Tiyago acikwira nawo kuphiri litali kwa wokha. ");
INSERT INTO nyu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kumweko Iye adasandulika patsogolo pawo. Nkhope yace idayetima ninga dzuwa, ndipo bzakubvala bzace bzidacena ninga ceza. ");
INSERT INTO nyu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Panthawe imweyo-letu adawonekera kuna iwo Mozeji na Eriya, acimbaceza na Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pamwepo Pedru adauza Jezu kuti: “Mbuya, ni bzabwino kuti ife tikhale pano. Penu mun'funa nin'kondza bzikumbi bzitatu, cibodzi ca imwe, cibodzi ca Mozeji ndipo cinango ca Eriya”. ");
INSERT INTO nyu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pomwe iye akhapitiriza kulewa-lewa, mtambo wakutoya udawampsinkha ndipo m'mwemo mudabveka fala lomwe likhalewa kuti: “Uyu ni Mwana wangu wakufunidwa omwe nimbakomedwa naye. Mum'bvere!” ");
INSERT INTO nyu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wakupfundzira atabva bzimwebzi, adagodama mpaka msolo kukhuya pantsi ndipo adakhala na mantha. ");
INSERT INTO nyu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tsono Jezu adafendera pafupi adawakhuya aciti: “Lamukani! Lekani mantha!” ");
INSERT INTO nyu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ndipo iwo pakunyang'ana kudzulu alibe kuwona wina, adandowona Jezu yekha. ");
INSERT INTO nyu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pomwe akhabuluka paphiri, Jezu adawauza kuti: “Lekani kuuza munthu bzomwe mwawonabzi, mpaka Mwana wa munthu adzalamusidwe kwa wakufa”. ");
INSERT INTO nyu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wakupfundzira adam'bvundza kuti: “Kodi thangwe ranyi adziwi wa Mtemo ambalewa kuti ni bzakufunika Eriya an'dzakhale wakutoma kubwera?” ");
INSERT INTO nyu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jezu adatawira kuti: “Cadidi, Eriya an'bwera kuti adzakondze papsa bzinthu bzentse. ");
INSERT INTO nyu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tsono Ine nin'kuuzani kuti: Eriya adabwera kale, ndipo iwo alibe kumuzindikira, tsono adamucita bzentse bzomwe iwo adafuna. Ni bzibodzi-bodzimbo Mwana wa munthu an'dzaboneresedwa na iwo”. ");
INSERT INTO nyu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pamwepo wakupfundzira adabvesesa kuti akhali Juwau M'batizi omwe Iye akhalewa. ");
INSERT INTO nyu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pomwe iwo adafika pakhana m'thithi, mwamuna m'bodzi adafendera kuna Jezu adagodama patsogolo pace acimuuza kuti: ");
INSERT INTO nyu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Mbuya mucitireni ntsisi mwana wangu. Thangwe iye ana mpfai ndipo alikubonera kwene-kwene. Nakuti kawiri-kawiri ambagwera pamoto ayai m'madzi. ");
INSERT INTO nyu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ndipo ndidabwera naye kwa wakupfundzira wanu, tsono alibe kumulimbisa”. ");
INSERT INTO nyu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jezu adatawira kuti: “Hu! Mbadwe wakusaya cikhulupiriro na wakuipa, nin'dzakhala namwe mpaka lini? Nin'dzapirira mpaka lini? Ndibweresereni mulumbwanayo”. ");
INSERT INTO nyu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jezu adathotha m'zimu wakuipa. Iwo udacoka mwa mulumbwanayo, kuyambira nthawe imweire adalimba. ");
INSERT INTO nyu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pamwepo wakupfundzira adafendera kuna Jezu pambali acim'bvundza kuti: “Thangwe ranyi tatazira kuuthotha?” ");
INSERT INTO nyu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iye adatawira kuti: “Thangwe cikhulupiriro canu cakucepa. Pakuti Ine nin'kuuzani cadidi kuti imwepo mukakhala na cikhulupiriro cakulingana na njere ya m'towe, mungadzauze phiriri kuti: ‘Coka apa ndoko uko’, ndipo iro lin'dzayenda. Palibe comwe cingadzasaye kukwanisika. ");
INSERT INTO nyu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tsono m'zimu wa m'tundu umweyu un'coka lini pakusaya mpembo na kubzimana cakudya”. ");
INSERT INTO nyu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ndipo wakupfundzira adatsonkhana kuGalireya, Jezu adawauza kuti: “Mwana wa munthu an'dzaperekedwa m'manja mwa wanthu. ");
INSERT INTO nyu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Iwo an'dzamupha, ndipo ntsiku yacitatu Iye an'dzalamusidwa kwa wakufa”. Ndipo wakupfundzira adadzalidwa na msunamo. ");
INSERT INTO nyu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pomwe Jezu na wakupfundzira wace adafika kuKafaranawumi, anyakukhomesa mtsonkho adabwera kuna Pedru acim'bvundza kuti: “Misiri wanu ambakhoma lini mtsonkho wa m'munyumba ya Mulungu?” ");
INSERT INTO nyu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedru adatawira kuti: “Inde, ambakhoma”. Pomwe Pedru adapita m'nyumba, Jezu ndiye adayamba kulewa-lewa, acimubvundza kuti: “Simau, iwepo un'kumbuka tani? Kodi azimambo wa padziko pano ambatambira mtsonkho kuna yani: Kuna wana wawo caiwo ayai kwa winango?” ");
INSERT INTO nyu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedru adatawira kuti: “Kwa winango”. Jezu adamuuza kuti: “Tsono wana anikhoma lini. ");
INSERT INTO nyu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tsono, kuti tireke kuwakalipisa, ndoko kunyandza ukamedze. Ntsomba yomwe un'kayamba kumedza, ukaifungule mulomo, ndipo un'kawona kobiri. Ukaitenge kobiriyo udzakhome mtsonkho wangu na wako”. ");
INSERT INTO nyu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Panthawe imweire wakupfundzira adafika kuna Jezu ndipo adam'bvundza kuti: “Mbani mkulu muUmambo bwa kudzulu?” ");
INSERT INTO nyu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ndipo Jezu adacemera mwana, acikaikha pakati pawo, ");
INSERT INTO nyu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ndipo adati: “Ine nin'kuuzani cadidi kuti, mungasaya kucinja mucikhala ninga wana, cipo mun'dzapita lini muUmambo bwa kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Na tenepo, omwe an'bzicepesa ninga kamwanaka, umweyo ni mkulu muUmambo bwa kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Omwe an'tambira m'bodzi mwa tuwanatu mudzina langu, ali kutambira Ine. ");
INSERT INTO nyu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tsono penu winango an'gwegwedusa m'ng'ono m'bodzi mwa an'khulupirira Inewa, bzingadakhala bwino kum'mangirira cimwala ca mpheyo m'khosi ndipo acimizidwa m'nyandza mwa kuzika. ");
INSERT INTO nyu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Tsoka kwa dziko thangwe ra bzinthu bzomwe limbacita bzakukalipisa! Bzinthu bzakukalipisabzo bzingaleke lini kucitika, tsono tsoka kuna ule omwe an'bweresa bzakukalipisabzo! ");
INSERT INTO nyu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Penu boko lako ayai mwendo wako un'kuphonyesa, bzigwate ndipo ubzithuse kunja. Ni bzabwino kupita mumoyo wakugwatika boko ayai mwendo, kusiyana kuti ukhale na manja mawiri na minyendo miwiri ucithusidwa mumoto wakusaya kumala. ");
INSERT INTO nyu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ndipo penu diso lako lin'kuphonyesa, licose ulithuse kunja. Ni bzabwino kupita mumoyo na diso libodzi, kusiyana kuti ukhale na maso mawiri ukathusidwe mumoto wakusaya kumala. ");
INSERT INTO nyu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Cenjerani lekani kunyoza na m'bodziyo mwa ang'onowa! Pakuti Ine nin'kuuzani kuti anju wawo kudzulu ambakhala ali kuwona nthawe zentse patsogolo pa Baba wangu wa kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Thangwe Mwana wa munthu adabwera kudzapulumusa comwe cikhadataika. ");
INSERT INTO nyu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Muli kukumbuka tani? Penu munthu wina ana mabira dzana (100), ndipo m'bodzi (1) wa iyo acitaika, an'dzasiya lini makumi mapfemba na mapfemba m'mapiri, acitewera wakutaikayo? ");
INSERT INTO nyu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ndipo akakwanisa kumuwona, cadidi nin'kuuzani kuti an'dzasekera kwene-kwene na bira wakutaikayo kuposa makumi mapfemba na mapfemba yomwe yakhalibe kutaika. ");
INSERT INTO nyu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ni bzibodzi-bodzi, Baba wa imwepo omwe ali kudzulu, an'funa lini kuti m'bodzi wa ang'onowa ataike. ");
INSERT INTO nyu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Penu m'bale wako an'kuphonyera, ndoko ukamutsimule payekha. Penu iye an'kakubvera, wabweza m'bale wako. ");
INSERT INTO nyu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tsono penu iye an'kubvera lini, utenge m'bodzi ayai awiri kuti ‘umboni bwa wanthu awiri ayai atatu butsimikizidwe’. ");
INSERT INTO nyu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Penu iye aniwabvera lini, uza gereja. Ndipo penu iye aniramba pomwe kubvera gereja, muyese ninga wakusaya kupemba ayai wakulipirisa mtsonkho. ");
INSERT INTO nyu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Cadidi nin'kuuzani kuti: Bzentse bzomwe imwepo munimanga padziko la pantsi bzin'dzamanga kudzulu, ndipo bzentse bzomwe mun'tsudzula padziko la pantsi bzin'dzatsudzulidwa kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nin'kuuzani pomwe kuti penu awiri wa imwe an'bverana cinthu ciricentse padziko mucikumbira, mudzacitambira kuna Baba wangu omwe ali kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pakuti pomwe awiri ayai atatu atsonkhana mudzina langu, Ine nin'khala pakati panu”. ");
INSERT INTO nyu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pamwepo Pedru adafendera kuna Jezu acimubvundza kuti: “Mbuya, kodi ningalekerere kangasi m'bale wangu akandiphonyera? Kupfitsa kanomwe?” ");
INSERT INTO nyu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jezu adam'tawira kuti: “Nin'kuuza lini kuti kanomwe, tsono upfitse makumi manomwe kufunya kanomwe. ");
INSERT INTO nyu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Na tenepo Umambo bwa kudzulu buli ninga mambo omwe adakasunda mangawa kuna akapolo wace. ");
INSERT INTO nyu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pomwe adayamba kuwasunda, adabweresedwa patsogolo pace munthu omwe akhana mangawa ya parata zizinji kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pakuwona kuti akhalibe cakuti am'bwezere, mbuya adalewa kuti iye, mkazi wace, wana wace na bzentse bzomwe akhali nabzo bzigulisidwe kuti abwezere mangawayo. ");
INSERT INTO nyu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kapoloyo adagodama patsogolo pace ndipo adam'kumbira kuti: ‘Bakapirirani, ndipo ine nin'dzakubwezerani bzentse’. ");
INSERT INTO nyu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mbuya wa kapoloyo adamucitira cifundo, adamulekerera mangawayo ndipo adamuleka aciyenda. ");
INSERT INTO nyu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tsono pomwe kapolo ule adacoka, adagumana na wina omwe akhali kapolo mwandzace, omwe akhana mangawa ya kobiri pang'ono. Ndipo adam'phata acimuxipa, acirewa kuti: ‘Ndibwezere mangawa yangu!’ ");
INSERT INTO nyu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Pamwepo kapolo mwandzaceyo adagodama acimukumbira kuti: ‘Pirirani nande, ndipo ine nin'dzakubwezerani’. ");
INSERT INTO nyu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Tsono iye adalamba. Patsogolo pace adamuikha m'kawoko, mpaka abwezere mangawayo. ");
INSERT INTO nyu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pomwe akapolo andzace adawona bzomwe bzidacitikabzo, adasukwala kwene-kwene ndipo adayenda kafokotozera mbuya wawo bzentse bzomwe bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Pamwepo mbuya adacemera kapoloyo acimuuza kuti: ‘Kapolo wakuipa, ndakulekerera mangawa yako yentse thangwe wandidandaulira. ");
INSERT INTO nyu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Iwepo ungadaleka kucitira ntsisi kapolo mwandzako ninga ine ndakucitira?’ ");
INSERT INTO nyu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ndipo atakalipa mbuya waceyo, adam'pereka kuna wakuboneresa, mpaka abwezere mangawa yentse. ");
INSERT INTO nyu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Baba wangu wakudzulu an'dzakucitanimbo tenepo, penu m'bodzi na m'bodzi anirekerera lini m'bale wace na m'tima wentse”. ");
INSERT INTO nyu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ndipo pomwe adamala kulewa bzinthu bzimwebzi, Jezu adacoka kuGalireya aciyenda mbali za Judeya, ng'ambu ina ya Jolodani. ");
INSERT INTO nyu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mithithi mikulu ikhamutewera, ndipo Iye adawalimbisa kumweko. ");
INSERT INTO nyu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Afalizi anango adafendera kuti amuyeze. Ndipo adam'bvundza kuti: “Ni bzakubvumizidwa kwa mwamuna kulamba mkazi wace na thangwe liri-lentse?” ");
INSERT INTO nyu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iye adatawira kuti: “Imwepo mulibe kulewenga, kuti paciyambi Mulengi ‘adalenga mwamuna na mkazi’ ");
INSERT INTO nyu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ndipo adati: ‘Na thangwe ra bzimwebzo, mwamuna an'dzasiya baba na mai acikaphatanidzana na mkazi wace, ndipo awiriwo an'dzakhala thupi libodzi’. ");
INSERT INTO nyu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Na tenepo iwo ni awiri lini pomwe, tsono ni thupi libodzi. Tenepoyo, comwe Mulungu aphatanidza, munthu aleke kulekanisa”. ");
INSERT INTO nyu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Afalizi adabvundza kuti: “Tsono thangwe ranyi Mozeji adapereka tsamba lakulambanisa mkazi ndipo acimuyendesa kwawo?” ");
INSERT INTO nyu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jezu adatawira kuti: “Mozeji adabvumiza kuti imwepo mulambe akazi wanu thangwe ra kuuma m'tima kwanu. Tsono bzikhali lini tenepo kuyambira paciyambi. ");
INSERT INTO nyu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ine nin'kuuzani kuti ali-yentse omwe aniramba mkazi wace, kupambula upombo ndipo acirowola mkazi winango, an'dzakhala alikucita upombo”. ");
INSERT INTO nyu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wakupfundzira adamuuza kuti: “Penu imwei ni nkhani ya mwamuna na mkazi wace, ni bzabwino kuleka kulowola”. ");
INSERT INTO nyu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jezu adatawira kuti: “Ni wentse lini an'kwanisa kubvuma mafala yamweya. Tsono pokha-pokha wale omwe an'pasidwa. ");
INSERT INTO nyu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Winango ni ngomwa thangwe adabadwa tenepo. Winango adacitidwa tenepoyo na wanthu. Winango adabzicita okha thangwe ra Umambo bwa kudzulu. Omwe angakwanise kubvuma pfundzisoli, abvume”. ");
INSERT INTO nyu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Patsogolo pace adabweresa wana kuna Jezu, kuti awasandzike manja ndipo awapemberere. Tsono wakupfundzira akhawaletsa. ");
INSERT INTO nyu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pamwepo Jezu adati: “Lekani wana abwere kuna ine ndipo lekani kuwaletsa. Pakuti Umambo bwa kudzulu ni bwa omwe adalingana na wana amwewa”. ");
INSERT INTO nyu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ndipo atamala kuwasandzika manja, adacoka kumweko. ");
INSERT INTO nyu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Onani, munthu winango adafendera kuna Jezu acimubvundza kuti: “Misiri, ni ciponi cabwino comwe ndingacite kuti ndikhale na moyo wakusaya kumala?” ");
INSERT INTO nyu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jezu adam'tawira kuti: “Thangwe ranyi iwepo uli kundibvundza kuti ni ciponi cabwino? Wabwino ni m'bodzi yekha. Penu iwepo un'funa kukhala na moyo, koya malamulo”. ");
INSERT INTO nyu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Iye adabvundza kuti: “Yaponi?” Jezu adatawira kuti: “ ‘Leka kupha, leka kucita upombo, leka kuba, leka kucita umboni bwakunama, ");
INSERT INTO nyu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","lemekeza baba wako na mai wako’, ndipo ‘Ufune mwandzako ninga un'bzifunira iwe wekha’ ”. ");
INSERT INTO nyu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mulumbwanayo adamuuza kuti: “Bzentsenebzi nimbateweza. Candisalira ni ciyani tsapano?” ");
INSERT INTO nyu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jezu adatawira kuti: “Penu iwepo un'funa kukhala wakukwana, ndoko, ukagulise bzentse bzomwe uli nabzo ndipo kobirizo ukapase wakusauka, ndipo iwepo un'dzakhala na cuma kudzulu. Patsogolo pace bwera udzanditewere”. ");
INSERT INTO nyu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tsono atabva bzimwebzi mulumbwanayo adacoka wakusunama, thangwe akhali nyakudala kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Na tenepo Jezu adauza wakupfundzira wace kuti: “Cadidi nin'kuuzani kuti: Mpsakunesa kuti munthu nyakudala adzapite muUmambo bwa kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ndipo nin'kuuzani pomwe kuti: Mpsakupusa kuti Ngamira ipite pamubo wa tsingano kuposana na munthu nyakudala kupita muUmambo bwa Mulungu”. ");
INSERT INTO nyu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pomwe wakupfundzira adabva bzimwebzi, adadabwa ndipo acibvundza kuti: “Penu ni tenepoyo angapulumuke mbani?” ");
INSERT INTO nyu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jezu adawanyang'anisisa aciti: “Kwa munthu bzin'kwanisika lini tsono kwa Mulungu bzinthu bzentse mpsakukwanisika”. ");
INSERT INTO nyu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pamwepo Pedru adam'tawira kuti: “Ife tidasiya bzentse kuti tikutewereni! Tsono tin'dzatambira ciyani?” ");
INSERT INTO nyu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jezu adawauza kuti: “Nin'kuuzani cadidi kuti: Imwe omwe mudanditewera mucibadwa papsa, pomwe Mwana wa munthu an'dzakhala pa m'pando wa umambo wa ulemerero yace, imwepombo mun'dzakhala m'mipando ya umambo khumi na miwiri pakudzatonga madzindza khumi na mawiri ya Ijirayeri. ");
INSERT INTO nyu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ndipo wentse omwe adasiya nyumba, abale wacimuna na wacikazi, baba, mai, wana ayai minda thangwe ra Ine an'dzatambira bzakufunya kadzana (100) kuposa kale ndipo an'dzakhala mumoyo wakusaya kumala. ");
INSERT INTO nyu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tsono wakuyamba azinji an'dzakhala wakumalizira, ndipo wakumalizira an'dzakhala wakuyamba”. ");
INSERT INTO nyu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Pakuti Umambo bwa kudzulu buli ninga mwenekaciro wa munda omwe adacoka macibese-bese kuti akapangane na akapolo wa kumunda kwace. ");
INSERT INTO nyu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iye adapangana nawo kuwalipira kobiri ya parata ya ntsiku ibodzi, ndipo adawayendesa kumunda kwace. ");
INSERT INTO nyu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Pafupi-fupi nthawe zipfemba (9) za kumacibese, iye adacoka ndipo adawona winango wakusaya basa adaima pa m'sika, ");
INSERT INTO nyu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ndipo adawauza kuti: ‘Ndokonimbo mukaphate basa m'munda, ndipo ine nin'dzakulipirani mwakufunikira’. ");
INSERT INTO nyu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ndipo iwo adayenda. “Munthu ule adayenda pomwe pafupi-fupi panthawe khumi na ziwiri (12) na pafupi-fupi panthawe zitatu (3) za kumaulo, adacita bzibodzi-bodzibzo. ");
INSERT INTO nyu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pafupi-fupi nthawe zixanu za kumaulo adayenda pomwe adagumana winango omwe akhalibe basa ndipo adawabvundza kuti: ‘Thangwe ranyi mudakhala pano ntsiku yentse mulibe cakucita?’ ");
INSERT INTO nyu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Iwo adatawira kuti: ‘Thangwe palibe munthu wa kutipitisa basa’. “Adawauza kuti: ‘Ndokonimbo imwepo mukaphate basa m'munda mwangu’. ");
INSERT INTO nyu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nthawe ya kumaulo, mwenekaciro munda adauza muimiriri kuti: ‘Cemera wabasa ndipo uwalipire malipiro yawo, kuyambira wakumalizira kupangana nawo mpaka kumalizira wakuyamba’. ");
INSERT INTO nyu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Adabwera akapolo omwe adapitisidwa nthawe zixanu za kumaulo ndipo adatambira kobiri ya parata ibodzi munthu ali-yentse. ");
INSERT INTO nyu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pomwe adabwera omwe akhadapitisidwa pakuyamba, akhadikira kutambira zizinji. Tsono m'bodzi na m'bodzi wa iwo adatambirambo kobiri ibodzi ya parata. ");
INSERT INTO nyu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pomwe adaitambira, adayamba kung'ung'udzika kuna mwenekaciro wa mundayo, ");
INSERT INTO nyu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","aciti: ‘Amuna wakumalizirawa aphata basa nthawe ibodzi yokha, ndipo mbuyamwe mwawapasa mwakundendemera na ife omwe tapirira na basa la kuuma na kutentha kwentse kwa dzuwa’. ");
INSERT INTO nyu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Tsono iye adatawira m'bodzi wa iwo aciti: ‘Xamwali, ndiri lini wakusaya kulungama kuna iwepo. Iwepo ulibe kubvuma kuphatira basa kobiri ibodzi ya parata? ");
INSERT INTO nyu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tambira comwe ni cako uyende. Ine nin'funa kupasa kuna omwe adapitisidwa pakumalizira bzibodzi-bodzi na bzomwe ndakupasa. ");
INSERT INTO nyu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kodi ningaleke kucita bzomwe nin'funa na kobiri yangu? Ayai ulikuipidwa nakuti ndina m'tima wabwino?’ ");
INSERT INTO nyu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Na tenepo wakumalizira an'dzakhala wakuyamba, ndipo wakuyamba an'dzakhala wakumalizira”. ");
INSERT INTO nyu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pomwe Jezu akhakwira kuyenda kuJerusalema, adacemera pambali wakupfundzira wace khumi na awiri (12) ndipo adawauza kuti: ");
INSERT INTO nyu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tirikukwira kuJerusalema, ndipo Mwana wa munthu an'dzaperekedwa kuna akulu-akulu wa anyantsembe na adziwi wa Mtemo. Iwo an'kamupasa mulandu wakumupha ");
INSERT INTO nyu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ndipo an'kamupereka kuna omwe ni aJuda lini kuti akamunyaze, akamuchange acikamukhomerera pam'tanda. Pantsiku yacitatu iye an'dzalamuka kwa wakufa!” ");
INSERT INTO nyu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pamwepo mkazi wa Zebedeu adafendera kuna Jezu na wana wace, ndipo adagodama acim'kumbira nkhombo. ");
INSERT INTO nyu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jezu adam'bvundza kuti: “Iwepo un'funa ciyani?” Iye adatawira kuti: “Lewani kuti muUmambo bwanu wana wangu awiriwa an'dzakhale, m'bodzi kuboko lanu la madidi ndipo winango kuboko lanu la madzere”. ");
INSERT INTO nyu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tsono Jezu adawauza kuti: “Imwepo mulikudziwa lini comwe mulikukumbira. Kodi imwepo mun'dzakwanisa kudzamwera m'kombo omwe Ine nin'dzamwera?” Iwo adatawira kuti: “Tin'dzakwanisa inde”. ");
INSERT INTO nyu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jezu adawauza kuti: “Cadidi imwepo mun'dzakwanisa kumwera m'kombo wangu. Tsono bzakukhala kuboko langu la madidi ayai kuboko langu la madzere ni bzangu lini. Mbuto zimwezi ni za wale omwe adawakondzeredwa na Baba”. ");
INSERT INTO nyu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pomwe wakupfundzira khumi (10) adabva bzimwebzi, adakalipira abale awiriwo. ");
INSERT INTO nyu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pamwepo Jezu adawacemera aciwauza kuti: “Imwepo mun'dziwa kuti atongi wa madziko ambaponderera ndipo wakufunika ambacita umambo kwa iwo. ");
INSERT INTO nyu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ni tenepoyo lini pakati pa imwe. Ali-yentse omwe an'funa kukhala m'kulu pakati pa imwe akhale wakukutumikirani, ");
INSERT INTO nyu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ndipo omwe an'funa kukhala wakuyamba pakati pa imwe adzakhale nyagirinya wanu. ");
INSERT INTO nyu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ninga momwe Mwana wa munthu, alibe kubwera kudzatumikiridwa, tsono kudzatumikira ndipo kudzapereka moyo wace kuti alombole wanthu azinji”. ");
INSERT INTO nyu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pomwe Jezu na akupfundzira wace akhacoka kuJeriko, m'thithi ukulu ukham'tewera. ");
INSERT INTO nyu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ndipo pakhana azimola awiri, akhadakhala m'phepete mwa mseu, pomwe adabva kuti Jezu akhapita adakuwa kuti: “Mbuya, Mwana wa Davidi, tibvereni ntsisi!” ");
INSERT INTO nyu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tsono m'thithi ukhambawatsimula kuti anyamale. Tsono iwo akhambapitiririza kukuwa acimbati: “Mbuya, mwana wa Davidi tibvereni ntsisi!” ");
INSERT INTO nyu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jezu ataima, adawacemera aciwabvundza kuti: “Imwepo mun'funa kuti ndikucitireni ciyani?” ");
INSERT INTO nyu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Iwo adatawira kuti: “Mbuya, tin'funa kuti maso yathu yawone”. ");
INSERT INTO nyu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jezu adawabvera ntsisi acikhuya maso yawo, pamwepo letu maso yawo yadalimba ndipo adam'tewera. ");
INSERT INTO nyu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Pomwe iwo akhafendera kuJerusalema adafika kuBetefaje, paphiri ra Olivera, Jezu adatuma wakupfundzira awiri, ");
INSERT INTO nyu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","aciwauza kuti: “Ndokoni pamui uli kutsogolo kwanuyo, mukatondo kupita mun'kagumana bulu adamangirira pabodzi na kamwana kace. Kayatsudzuleni mubwere nayo kuno. ");
INSERT INTO nyu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Penu winango an'kuuzani cinthu ciricentse, muuzeni kuti Mbuya alikuyafuna, pamwepo letu an'kakupasani”. ");
INSERT INTO nyu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bzimwebzi bzidacitika kuti bzikwanirisidwe bzomwe bzidalewedwa na m'polofita kuti: ");
INSERT INTO nyu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Uzani m'zindayi wa Siyau kuti: ‘Wona mambo wako alikubwera kuna iwe, mwakubzicepesa adapakira pa bulu, na pa kabulu, mwana wa bulu’”. ");
INSERT INTO nyu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Wakupfundzira adayenda acikacita bzomwe Jezu akhadawauza. ");
INSERT INTO nyu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Adabweresa bulu na kabulu, adaikha pamsana payene bzakubvala bzawo, ndipo Jezu adapakira pamwepo. ");
INSERT INTO nyu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","M'thithi ukulu udatandika bzakubvala bzawene munjira, anango akhachola mithawi ya miti ndipo akhaithusa munjira. ");
INSERT INTO nyu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","M'thithi omwe ukhayenda kutsogolo kwace na omwe ukhamutewera, ukhambakuwa uciti: “Ozana kuna Mwana wa Davidi!” “Wakusimbidwa ni omwe alikubwera mudzina la Mbuya!” “Ozana kudzulu!” ");
INSERT INTO nyu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pomwe Jezu adapita muJerusalema, mzinda wentse udakhala na cipiringu ndipo akhambabvundza kuti: “Kodi mbani umweyu?” ");
INSERT INTO nyu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","M'thithi ukhambatawira kuti: “Umweyu ni Jezu, m'polofita wa kuNazareta ya Galireya”. ");
INSERT INTO nyu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jezu adafika panyumba ya Mulungu ndipo adathamangisa wentse omwe akhali m'mwemo anyakugulisa na anyakugula. Adagwesa makatsantsali ya wakucinja kobiri na mipando ya omwe akhagulisa nkhangaiwa, ");
INSERT INTO nyu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ndipo adawauza kuti: “Bzidanembedwa kuti: ‘Nyumba yangu in'dzacemeredwa nyumba ya mpembo’. Tsono imwepo mulikuyisandusa ‘nkhunde ya mbava’”. ");
INSERT INTO nyu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Azimola na wakupunduka adafendera kuna Iye panyumba ya Mulungu, ndipo Iye adawalimbisa. ");
INSERT INTO nyu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tsono pomwe akulu-akulu wa anyantsembe na adziwi wa Mtemo adawona bzakudabwisa bzomwe Jezu akhacita ndipo wana akhambakuwa munyumba ya Mulungu kuti: “Ozana kwa Mwana wa Davidi”, adakalipa ");
INSERT INTO nyu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ndipo adamubvundza kuti: “Ulikubva lini bzomwe wanawa alikulewa?” Jezu adatawira kuti: “Inde, imwepo mukanati kulewenga kuti: “ ‘Mbuya Mulungu adapfundzisa wana na omwe abadwa tsapanopa kum'tumbiza bwino?’” ");
INSERT INTO nyu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ndipo atawasiya adacoka mum'zinda aciyenda kuBetanya adakagona kumweko. ");
INSERT INTO nyu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mangwana yandzace macibese-bese, pomwe akhabwerera kumzinda, Jezu adabva njala. ");
INSERT INTO nyu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pomwe adawona muti wakucemeredwa figeira m'mphepete mwa njira adaufenderera pafupi, tsono alibe kuwona cinthu, adandowona masamba yokha, pamwepo adauuza kuti: “Un'dzabala lini pomwe bzisapo!” Nthawe ibodzi-bodziyo mutiyo udauma. ");
INSERT INTO nyu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pomwe wakupfundzira adawona bzimwebzi adadabwa ndipo adabvundza kuti: “Kodi mkuyuyu wauma tani mwakamkulumize tenepayu?” ");
INSERT INTO nyu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jezu adatawira kuti: “Nin'kuuzani cadidi kuti penu imwepo mun'khala na cikhulupiriro mucireka kupenuka, mun'dzacita bzakuposa bzomwe bzacitidwa pa mkuyuyu, tsono mungadzauzembo phiriri kuti: ‘Coka pamwepa bzithuse munyandza’ bzimwebzo bzin'dzacitika. ");
INSERT INTO nyu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ndipo bzentse bzomwe mun'dzakumbira mwakupemba, mungadzakhulupirira mun'dzatambira”. ");
INSERT INTO nyu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jezu adapita munyumba ya Mulungu, ndipo pomwe akhapfundzisa, akulu-akulu wa anyantsembe na atsogoleri wa mbumba adafendera kuna Iye adabvundza kuti: “Kodi bzinthu bzimwebzi mulikubzicita na utongi buponi? Ndipo mbani omwe akupasani utongi bumwebu?” ");
INSERT INTO nyu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ndipo Jezu adawatawira kuti: “Ine nin'kupasanimbo m'bvundzo ubodzi. Penu imwepo mun'ditawira, Ine nin'kuuzani utongi omwe ndirikucita nawo bzinthu bzimwebzi. ");
INSERT INTO nyu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kodi ubatizo bwa Juwau bukhacokera kuponi? Bukhali bwa kudzulu ayai bwa wanthu?” Iwo akhambagazana acimbati: “Tikalewa kuti: Ngwakudzulu, Iye an'dzabvundza kuti: ‘Tsono thangwe ranyi imwepo mulibe kum'khulupirira?’ ");
INSERT INTO nyu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tsono tikalewa kuti: Budacokera kwa wanthu, tinamantha na mbumba, nakuti wentse ambawona Juwau ninga m'polofita”. ");
INSERT INTO nyu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Iwo adatawira Jezu kuti: “Tin'dziwa lini”. Ndipo Iye adawauza kuti: “Nin'kuuzani lini napang'onopo ni utongi buponi bomwe ndirikucita nabo bzinthu bzimwebzi. ");
INSERT INTO nyu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mulikubziwona tani? Pakhana munthu m'bodzi omwe akhana wana wace awiri. Pomwe adafika kuna mwana wakuyamba adati: ‘Mwanangu, lero ndoko ukaphate basa kumunda wa vinya’. ");
INSERT INTO nyu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ndipo iye adatawira kuti: ‘Ndanyonyo!’ Tsono adadzacinja ndzeru aciyenda. ");
INSERT INTO nyu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ndipo baba adayenda kuna mwana winangoyo adalewa bzibodzi-bodzibzo. Iye adatawira kuti: ‘Inde, mbuya!’ Tsono alibe kuyenda. ");
INSERT INTO nyu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Mbani wa awiriwo adacita cifuniro ca baba wace?” Iwo adatawira kuti: “Wakuyamba”. Jezu adawauza kuti: “Nin'kuuzani cadidi kuti: Anyakukhomesa m'tsonkho na aputa walikupita muUmambo bwa Mulungu imwe mukanati. ");
INSERT INTO nyu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Thangwe Juwau M'batizi adabwera kudzakulatizani njira ya cirungamo, ndipo imwepo mulibe kumukhulupirira, tsono anyakukhomesa m'tsonkho na aputa adakhulupirira. Ndipo napo mudawona bzimwebzi, imwepo mulibe kukungula ngakhale kum'khulupirira. ");
INSERT INTO nyu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Bvani m'fananizo unango wakuti: Kukhana mwenekaciro wa munda wa uva. Adasosera m'mphepete mwawene, adacera cidindi kuti apsinyire uva ndipo adakondza cigota. Patsogolo pace adaukumbiza kuna alimi anango kuti ambamulipire, ndipo iye adacita ulendo. ");
INSERT INTO nyu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pomwe nthawe yakubvuna idakwana, adatuma akapolo wace kuna alimi wale, kuti akatambire bzisapo bzomwe ni bzace. ");
INSERT INTO nyu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Alimi wale adaphata akapolo wace, acipweteka m'bodzi winango adamupha ndipo wacitatu adam'boma na minyala. ");
INSERT INTO nyu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pamwepo adatumiza akapolo anango azinji, ndipo alimi wale adacita bzibodzi-bodzi. ");
INSERT INTO nyu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pakumalizira adatumiza mwana wace aciti: ‘Mwana wangu an'kamulemekeza’. ");
INSERT INTO nyu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Tsono pomwe alimi adawona mwanayo, adauzana kuti: ‘Umweyu ni nyautaka. Bwerani timuphe ndipo titenge utaka bwace’. ");
INSERT INTO nyu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Na tenepo iwo adam'phata aciyenda naye kunja kwa munda ndipo adamupha. ");
INSERT INTO nyu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Na tenepo akabwera mwenekaciro wa munda an'dzacita ciyani na alimi wale?” ");
INSERT INTO nyu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Iwo adatawira kuti: “An'dzawapha alimi wale wakuipa ndipo an'dzakumbiza mundayo anango, omwe an'dzamupasa mbali yace Panthawe yakubvuna”. ");
INSERT INTO nyu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jezu adawauza kuti: “Imwepo mukanati kulewenga muBzakunemba mafalaya: “ ‘Mwala omwe anyakumanga nyumba adalamba, udadzakhala mwala wa pagonyo, bzimwebzi bzidacokera kwa Mbuya, ndipo ni cinthu cakudabwisa kwa ife’. ");
INSERT INTO nyu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Na tenepo Ine nin'kuuzani kuti Umambo bwa Mulungu un'dzacosedwa kwa imwepo ndipo un'dzapasidwa kwa mbumba yomwe in'dzabala bzisapo bza Umambo. ");
INSERT INTO nyu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ule omwe an'dzagwera mwalayu an'dzagwatidwa-gwatidwa ndipo kwa ule omwe an'dzagwedwa na iwo an'dzasanduka pfumbi”. ");
INSERT INTO nyu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pomwe akulu-akulu wa anyantsembe na afalizi adabva mifananizo ya Jezu, adazindikira kuti Iye akhalewa bza cipande ca iwo. ");
INSERT INTO nyu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ndipo akhanyang'ana njira yakuti am'mange, tsono akhana mantha na mithithi, nakuti ukhambamuyesa m'polofita. ");
INSERT INTO nyu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jezu adawauza pomwe mwa mifananizo aciti: ");
INSERT INTO nyu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Umambo bwa kudzulu budakhala ninga mambo omwe adakondza uzokoto bwa m'sinda wa malowozi ya mwana wace. ");
INSERT INTO nyu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Adatuma akapolo wace kuna omwe akhadacemeredwa kuuzokoto, adawauza kuti abwere. Tsono iwo adalamba kubwera. ");
INSERT INTO nyu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Adatuma pomwe akapolo anango adati: ‘Uzani omwe acemeredwa kuti ndakondza uzokoto bwangu: Ng'ombe zangu tumikono twakunenepa, ndipo bzentse bzakondzedwa kale. Bwerani kuuzokoto bwa malowozi!’ ");
INSERT INTO nyu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Tsono iwo alibe kum'tetekera ndipo adacoka, m'bodzi kumunda kwace, winango kumalonda yace. ");
INSERT INTO nyu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Anangowo, adaphata akapolo, adawaboneresa aciwapha. ");
INSERT INTO nyu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mambo adakalipa ndipo adatumiza acikunda wace, acikapha akambowa wale na kutentha mzinda wawo. ");
INSERT INTO nyu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Pamwepo adauza akapolo wace aciti: ‘Uzokoto bwa m'sinda wa malowozi bwakwana, tsono omwe ndikhadacemera akhalibe kuthemera. ");
INSERT INTO nyu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tsapano ndokoni m'magonyo ndipo cemerani kuuzokoto wentse omwe muniwona’. ");
INSERT INTO nyu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pamwepo akapolo adacoka aciyenda muzinjira ndipo adagumaniza wanthu wentse omwe adagumana nawo, wabwino na wakuipa, ndipo cipinda ca uzokoto bwa m'sinda wa malowozi, cidadzala na wakucemeredwawo. ");
INSERT INTO nyu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tsono pomwe mambo adapita kuti awone wakucemeredwawo, adawona mwemo mwamuna m'bodzi omwe akhalibe cakubvala ca pamsinda wa malowozi. ");
INSERT INTO nyu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ndipo adam'bvundza kuti: ‘Xamwali, kodi iwepo wapita tani muno ulibe cakubvala ca pamsinda wa malowozi?’ Iye adakhala zii. ");
INSERT INTO nyu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Pamwepo mambo adauza omwe akhatumikira kuti: ‘M'mangeni manja na minyendo, m'muthuse kunja, kum'dima. Kumweko an'dzalira acikukuta mano’. ");
INSERT INTO nyu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Nakuti wakucemeredwa ni azinji tsono wakusankhuliwa ni ang'ono-ng'ono”. ");
INSERT INTO nyu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pamwepo afalizi adacoka acikacita citalo cakuti atape m'kanwa Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ndipo iwo adam'tumizira wakupfundzira wawo pabodzi na waphathi ra Herodi kukam'bvundza kuti: “Misiri, tin'dziwa kuti ndimwe wakulungama ndipo mumbapfundzisa njira ya Mulungu mwacadidi, ndipo Imwe mulibe thupo na munthu ali yentse thangwe mumbanyang'ana lini khalidwe la wanthu. ");
INSERT INTO nyu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Na tenepo tiuze: Kodi uli kuwona tani? Ni bzakubvumizidwa kulipira mtsonkho kwa m'tongi m'kulu Sezari ayai nee?” ");
INSERT INTO nyu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tsono Jezu, pakudziwa ndzeru zawo zakuipa adawabvundza kuti: “Wacipha-masomwe! Thangwe ranyi mulikundiyeza? ");
INSERT INTO nyu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ndiwoneseni kobiri yomwe mumbaphatisa basa pakupereka mtsonkho”. Iwo adamuwonesa denariyo, ");
INSERT INTO nyu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ndipo Iye adawabvundza kuti: “Nkhopeyi na manembaya ni bzayani?” ");
INSERT INTO nyu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Iwo adatawira kuti: “Ni bza Sezari”. Ndipo Iye adawauza kuti: “Na tenepo, pasani Sezari bzomwe ni bza Sezari ndipo bza Mulungu bzomwe ni bza Mulungu”. ");
INSERT INTO nyu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pomwe iwo adabva bzimwebzi, adakhala wakudabwisidwa. Ndipo adam'siya, wacicoka. ");
INSERT INTO nyu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ntsiku imweire, sadusi, omwe ambati kulibe kulamuka kwa wakufa, adafendera pafupi na Iye acimubvundza kuti: ");
INSERT INTO nyu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Misiri, Mozeji adalewa kuti penu munthu m'bodzi an'fa acisaya kusiya wana, bzin'funika kuti m'bale wace alowole masiwayo kuti am'balire nyamuyayo. ");
INSERT INTO nyu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tsono pakati pathu abale anomwe. Wakuyamba adalowola mkazi, ndipo adafa alibe kusiya wana, mkaziyo adasiira m'bale wace. ");
INSERT INTO nyu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bzibodzi-bodzi bzidacitika kwa waciwiri, wacitatu mpaka wacinomwe. ");
INSERT INTO nyu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ndipo pakumalizira kwa wentse, adadzafambo mkaziyo. ");
INSERT INTO nyu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kodi tsapano, pakulamuka kwa wakufa an'dzakhala mkazi wa yani pa anomwewo? Pakuti wentsenewo akhadamulowola!” ");
INSERT INTO nyu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jezu adatawira aciti: “Imwepo mulikubzipumpsa thangwe ra kusaya kudziwa Manemba ngakhale phambvu ya Mulungu! ");
INSERT INTO nyu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pakudzalamuka kwa wakufa, wanthu an'dzalowolana lini ngakhale kudzacita malowozi. Tsono an'dzakhala ninga anju kudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ndipo bza yakulamuka kwa wakufa, imwepo mulibe kulewenga bzomwe Mulungu adakuuzani kuti: ");
INSERT INTO nyu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ine ndine Mulungu wa Abrahamu, Mulungu wa Izaki, Mulungu wa Jakobo?’ Iye ni Mulungu lini wa wakufa, tsono wa amoyo!” ");
INSERT INTO nyu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pomwe mithithi idabva bzimwebzi, idadabwisidwa na cipfundziso cace. ");
INSERT INTO nyu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pomwe adabva kuti Jezu adasiya aSaduki alibe fala lakuti am'tawire, afalizi adagumana. ");
INSERT INTO nyu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ndipo m'bodzi wa iwo, misiri wa Mtemo adamuyeza pa kum'mbvundza aciti: ");
INSERT INTO nyu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“M'pfundzisi, lamulo likulu la Mtemo ndiponi?” ");
INSERT INTO nyu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jezu adam'tawira kuti: “ ‘Funa Mbuya, Mulungu wako na m'tima wako wentse, na moyo wako wentse ndipo na ndzeru zako zentse’. ");
INSERT INTO nyu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Limweri ndiro lakuyamba ndipo lamulo likulu. ");
INSERT INTO nyu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ndipo laciwiri lakulingana na limweri, ni iri: ‘Funa mwandzako ninga momwe umbabzifunira iwe wekha’. ");
INSERT INTO nyu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pa malamulo mawiriya yambateweza Mitemo yentse na cipfundziso ca Apolofita”. ");
INSERT INTO nyu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Afalizi akali pamtsonkhano, Jezu adawabvundza kuti: ");
INSERT INTO nyu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Imwepo mun'kumbuka ciyani bza Krixtu? Kodi iye ni mwana wayani?” Iwo adatawira kuti: “Ni mwana wa Davidi”. ");
INSERT INTO nyu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iye adawauza kuti: “Tsono, ni thangwe ranyi Davidi mwa Mzimu Wakucena, ambacemera ‘Mbuya’? Na tenepo Iye ambatsimikiza kuti: ");
INSERT INTO nyu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Mbuya adalewa kuna Mbuya wangu: Khala kuboko langu lamadidi, mpaka Ine ndidzaikhe anyamadulanthaka wako pantsi pa ndzayo zako’. ");
INSERT INTO nyu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tsono, penu Davidi ambamucemera ‘Mbuya’, Iye angakhale tani mwana wace?” ");
INSERT INTO nyu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Palibe omwe akhakwanisa kum'tawira. Ndipo kuyambira ntsiku imweire palibe na m'bodziyo omwe adakhwimika kuti am'bvundze pomwe. ");
INSERT INTO nyu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pamwepo, Jezu adauza m'thithi na wakupfundzira wace kuti: ");
INSERT INTO nyu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Adziwi wa Mtemo na afalizi ambakhala pampando wa Mozeji. ");
INSERT INTO nyu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Abvereni ndipo mucite bzentse bzomwe iwo an'kuuzani. Tsono lekani kucita bzomwe iwo an'cita, nakuti iwo ambacita lini bzomwe an'palidza. ");
INSERT INTO nyu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Iwo ambamanga mitolo yakulemera aciikha m'mapewa mwa wanthu, tsono iwo caiwo ali rini wakukondzeka kuti aimise cala cibodzi kuti aidzuse. ");
INSERT INTO nyu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Bzentse bzomwe an'cita ni bzakuti awonedwe na wanthu. Iwo ambatalimphisa firateriyo zawo ndipo bzakubvala bzawo ni bzitali-bzitali. ");
INSERT INTO nyu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ambafuna mbuto zakutumbizidwa mwa m'misinda na mipando mikulu-mikulu munyumba za mapembo, ");
INSERT INTO nyu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","kuti ambamusidwe mumisika acimbacemeredwa ‘apfundzisi’. ");
INSERT INTO nyu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Tsono, imwepo lekani kucemeredwa ‘apfundzisi’. M'bodzi yekha ndiye M'pfundzisi wanu, ndipo mwentsenemwe ndimwe abale. ");
INSERT INTO nyu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Palibe omwe mungacemere ‘baba’ pantsi pano, thangwe imwepo muna Baba m'bodzi, ule omwe alikudzulu. ");
INSERT INTO nyu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Lekani kucemeredwa ‘m'tsogoleri’ na pang'onopo, thangwe imwepo muna M'tsogoleri m'bodzi yekha, Krixtu. ");
INSERT INTO nyu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","M'kulu pakati panu an'dzakhala wakutumikira. ");
INSERT INTO nyu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nakuti ule omwe an'bzikuza mwa iye yekha an'dzacepesedwa ndipo ali-yentse ule omwe an'dzabzicepesa mwa iye yekha an'dzakuzidwa. ");
INSERT INTO nyu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Tsoka kwa imwe adziwi wa Mtemo na afalizi, wanthu wacipha-maso! Imwepo mulikufungira Umambo bwa kudzulu patsogolo pa wanthu! Imwepo-letu munibupita lini, ngakhale munirekerera lini kupita wale omwe an'funa kupita. ");
INSERT INTO nyu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Tsoka kwa imwe adziwi wa Mtemo na afalizi, wanthu wacipha-maso! Imwepo mumbadyera m'manja akazi amasiwa, ndipo kuti bzireke kudziwika mumbanamizira na kucita mipembo yakupitiriza. Ndipopo mun'dzapasidwa nyathwa ikulu kuposa. ");
INSERT INTO nyu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Tsoka kwa imwe adziwi wa Mtemo na afalizi, wanthu wacipha-maso, thangwe mumbazungulira nyandza na pantsi kuti mutendeuse munthu, ndipo mukakwanisa mumbam'tenga munthu umweyo ninga wakuthemera kuyenda kumoto wakusaya kumala mwakufunya kawiri kuposa imwepo. ");
INSERT INTO nyu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Tsoka kwa imwe atsogoleri azimola, nakuti mumbati: ‘Penu wina anirumbirira Nyumba ya Mulungu yakucena, bzimwebzi bzinirewa lini cinthu. Tsono penu wina anirumbirira Oro ya Nyumba ya Mulungu, bzin'funika kuti acite momwe alumbirira’. ");
INSERT INTO nyu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Azimola wakupusamwe! Kodi ni ciyani cakufunikira kwene-kwene: Oro ayai Nyumba ya Mulungu yomwe inicenesa oro? ");
INSERT INTO nyu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Imwepombo mumbalewa kuti: ‘Penu wina anirumbirira guwa, ibzi bzinirewa lini cinthu. Tsono penu wina anirumbirira cakupereka comwe ciri paguwa, bzin'funika kuti acite momwe alumbirira’. ");
INSERT INTO nyu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Azimolamwe! Niciyani cakufunikira kwene-kwene: Bzakupereka ayai guwa lomwe linicenesa bzakuperekabzo? ");
INSERT INTO nyu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na tenepo, ule omwe anirumbirira guwa, alikulumbira mwa iro ndipo na bzentse bzomwe bziri paguwapo. ");
INSERT INTO nyu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ndipo omwe anirumbirira na nyumba ya Mulungu, alikulumbira mwa iyo ndipo na ule omwe ambakhala m'mwemo. ");
INSERT INTO nyu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ndipo, ule omwe anirumbirira kudzulu, alikulumbirira M'pando wa umambo bwa Mulungu ndipo kuna ule omwe ambakhala kuna iwo. ");
INSERT INTO nyu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Tsoka kwa imwe, adziwi wa Mtemo na afalizi, wanthu wacipha-maso! Imwepo mumbapereka cakhumi ca tumbeu twakununchira, na twakukomesa cakudya na citowe, tsono mumbaleka m'pfundo za Mtemo zakufunikira zomwe ni cirungamo, ntsisi, na kukhulupirika. Imwepo bzin'funika kuti mumbacite bzinthu bzimwebzi mwakusaya kupambula bzimwebzire. ");
INSERT INTO nyu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wakutsogolera azimola! Imwepo mumbasusa bzakumwa kuti mucose mbudu, tsono mumbameza ngamira. ");
INSERT INTO nyu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Tsoka kwa imwe, adziwi wa Mtemo na afalizi wanthu wacipha-maso! Imwepo mumbatsuka mkombo na ndiro kunja, tsono m'kati mwace mudadzala na kupamba na kusirira. ");
INSERT INTO nyu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“MuFalisi zimolawe! Cakuyamba tsuka m'kati mwa m'kombo, kuti kunja kukhalembo kwa kucena. ");
INSERT INTO nyu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Tsoka kwa imwe, adziwi wa Mtemo na afalizi, wanthu wacipha-maso! Imwepo mudakhala ninga nthutu zakuikidwa m'toto zomwe, kunja kwace kudadeka, tsono m'kati mwace mudadzala na mafupa ndipo na m'tundu wentse wa bzakubvunda. ");
INSERT INTO nyu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ni tenepoyo imwepo: Kunja mudakhala ninga wanthu wakulungama patsogolo pa mbumba, tsono m'kati mudadzala na kunama ndipo na kuipa. ");
INSERT INTO nyu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Tsoka kuna imwe, adziwi wa Mtemo na afalizi, wanthu wacipha-maso! Imwepo mumbakondza bwino nthutu za apolofita ndipo mumbadekesa nthutu za wanthu wakulungama. ");
INSERT INTO nyu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ndipo mumbalewa kuti: ‘Tingadakhala kuti tikhalipombo Panthawe ya makolo yathu, tingadacita lini nawo mbali pakupha apolofita’. ");
INSERT INTO nyu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na tenepoyo, imwepo mulikutsimikiza kuti ndimwe dzindza la wale omwe adapha apolofita. ");
INSERT INTO nyu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Malizani tsono, kudzaza mphimo ya bzakuipa bza makolo yanu! ");
INSERT INTO nyu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Bzinyoka! Mtundu wa nyoka za nyakungu! Mun'dzathawa tani kunyathwa yakuyenda kumoto wakusaya kumala? ");
INSERT INTO nyu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Na tenepo, Ine ndirikukutumizirani apolofita, adziwi na adziwi wa Mtemo. Anango wa iwo mun'dzawapha ndipo muciwakhomera pam'tanda. Anango mun'dzawachanga munyumba za mapembo zanu mucidzawafambira m'mbuyo mzinda na mzinda. ");
INSERT INTO nyu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tenepoyo, Mulungu andzakupasani nyathwa thangwe la kufa kwa wanthu wentse wakusaya thangwe omwe makolo yanu adapha, kuyambira kuphedwa kwa Aberi mwakusaya thangwe mpaka kwa Zakaliya, mwana wa Balakiya, omwe mudapha pakati pa Nyumba ya Mulungu na guwa la ntsembe. ");
INSERT INTO nyu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ine nin'kutsimikizirani kuti bzentsenebzi bzin'dzabwerera mibadwe imweyi. ");
INSERT INTO nyu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalema, Jerusalema, iwepo omwe ulikupha apolofita uciboma omwe umbatumiziridwa! Ni kangasi kentse komwe Ine nimbafuna kugumaniza wana wako, ninga nkhuku yomwe imbagumaniza wana wace pantsi pa maphapidwe yace, tsono imwe mulibe kubvuma. ");
INSERT INTO nyu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dziwani kuti nyumba yanu in'dzakhala matere. ");
INSERT INTO nyu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tsono Ine nin'kuuzani kuti imwepo mun'dzandiwona lini pomwe, mpaka mudzalewe kuti: ‘Asimbidwe omwe an'bwera mudzina la Mbuya’”. ");
INSERT INTO nyu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pomwe Jezu adacoka Nyumba ya Mulungu, ndipo akhayenda, wakupfundzira wace adafendera pafupi na Iye kuti amulatize kamangidwe ka Nyumba ya Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iye adawabvundza kuti: “Kodi imwepo muli kuwona bzentsenebzi? Cadidi Ine ndikuuzani kuti pano pan'dzakhala lini mwala padzulu pa undzace, yentse in'dzagumulidwa”. ");
INSERT INTO nyu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pomwe Jezu akhadakhala paphiri la Olivera, wakupfundzira adadza pafupi na Iye pawokha acimubvundza kuti: “Tiuzeni kuti bzimwebzi bzin'dzacitika lini? Ndipo cizindikiro cakubwera kwanu na cakumala kwa dziko cin'dzakhala ciponi?” ");
INSERT INTO nyu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jezu adatawira kuti: “Cenjerani, kuti winango angakupumpseni. ");
INSERT INTO nyu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pakuti azinji an'dzabwera na dzina langu acimbati: ‘Ine ndine Krixtu’, ndipo an'dzapumpsa azinji. ");
INSERT INTO nyu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Imwepo mudzabva kulewa bza nkhondo na ntabva-ntabva wa nkhondo, tsono lekani kukhala na thupo. Bzin'funika kuti bzimwebzi bzidzacitike, tsono cimaliziro cikanati kufika. ");
INSERT INTO nyu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pakuti madzindza yan'dzasandukirana ndipo umambo na umambo un'dzamenyana. Pan'dzakhala njala na citeke-teke mumbuto zakusiyana-siyana. ");
INSERT INTO nyu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bzentsenebzi bzin'dzakhala kuyamba kwa mphicha”. ");
INSERT INTO nyu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Pamwepo iwo an'dzakuperekani kuti muboneresedwe ndipo mucidzaphedwa, mun'dzawengidwa na madzindza yentse thangwe ra Ine. ");
INSERT INTO nyu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Panthawe imweyo azinji an'dzataya cikhulupiriro cawo, an'dzapindukirana ndipo aciwengana m'bodzi na m'bodzi. ");
INSERT INTO nyu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ndipo padzawoneka apolofita azinji wakunama, acidzapumpsa wanthu azinji. ");
INSERT INTO nyu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Thangwe ra kuwanda kwa bzakuipa, lufoi la azinji lin'dzacepekera. ");
INSERT INTO nyu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tsono pa ule omwe anirimbika mpaka kumalizira an'dzapulumuka. ");
INSERT INTO nyu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ndipo Mafala Yabwino ya Umambo yan'dzapalidzidwa padziko lentse ninga mboni za madzindza yentse, ndipo pamwepo cidzafika cimaliziro”. ");
INSERT INTO nyu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Na tenepo pomwe imwe mun'dzawona ‘cakudzonga cakupasa mantha’ comwe adalewa m'polofita Daniyeri, Pambuto Yakucena (omwe anirewenga abvesese), ");
INSERT INTO nyu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","pamwepo omwe an'dzakhala ali muJudeya adzathawire kumapiri. ");
INSERT INTO nyu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Omwe an'dzakhala ali pantsodzi, pa nyumba yace adzathawiretu adzaleke kupita kukacosa cinthu ciri centse m'nyumbamo. ");
INSERT INTO nyu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Omwe an'dzakhala kumunda adzaleke kubwerera kutenga bzakubvala. ");
INSERT INTO nyu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tsoka kwa akazi omwe an'dzagumanizidwa ana pathupi na wakumamisa ntsiku zimwezo! ");
INSERT INTO nyu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mupembe kuti bzimwebzi bzidzaleke kucitika panthawe ya mphepo ayai ntsiku ya malinkhuma. ");
INSERT INTO nyu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Thangwe kun'dzawoneka bvuto likulu, mwakuti likanati kuwoneka kale kuyambira cirengedwe ca dziko mpaka lero, ndipo yan'dzawoneka lini pomwe cipo. ");
INSERT INTO nyu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ndipo nthawezo zingadaleka kupunguzidwa, palibe omwe angadapulumuka. Tsono, thangwe ra wakusankhulidwa, nthawezo zidzapunguzidwa. ");
INSERT INTO nyu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Na tenepo penu anango an'dzakuuzani kuti: ‘Onani, Krixtu ali pano’ ayai: ‘Uyo ali apo’, lekani kudzam'bvera. ");
INSERT INTO nyu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Thangwe kun'dzawoneka akrixtu na apolofita wakunama omwe an'dzacita bzizindikiro na bzidabwiso bzikulu kuti penu bzin'kwanisika apumpse wakusankhulidwa. ");
INSERT INTO nyu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Onani Ine ndakudziwisani bzikanati kucitika”. ");
INSERT INTO nyu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Na tenepo, Penu winango an'dzakuuzani kuti: ‘Krixtu ali kule, kucidambo’, lekani kudzacoka. Ayai kuti: ‘Krixtu ali apo, m'kati mwa nyumba’, lekani kudzabvuma. ");
INSERT INTO nyu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Thangwe, tenepoyo ninga mpheni imbacoka kumabvadzuwa ndipo icibziwonesa kumadokero, bzin'dzakhalambo tenepo pakubwera kwa Mwana wa munthu. ");
INSERT INTO nyu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Komwe kun'dzawoneka mtembo ubodzi, kumweko kun'dzagwezekana magola”. ");
INSERT INTO nyu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Zikadzatondokumala ntsiku za kubonerazo, “ ‘Dzuwa lin'dzacita m'dima, mwezi un'dzabvunika lini, nyenyezi zin'dzagwa kudzulu ndipo mphambvu za kudzulu zin'dzatekenyesedwa’ ”. ");
INSERT INTO nyu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Pamwepo pan'dzawoneka kudzulu cizindikiro ca Mwana wa munthu ndipo madzindza yentse ya pantsi yan'dzadandaula ndipo an'dzawona Mwana wa munthu alikubwera mumitambo kudzulu na mphambvu na mbiri ikulu. ");
INSERT INTO nyu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ndipo Iye an'dzatumiza anju zace na muwira ukulu wa cimbututu, ndipo iwo an'dzatsonkhanisa wakusankhulidwa wace mumbali zinai, kucoka kuphampha kukafika kuphampha kundzace kwa kudzulu”. ");
INSERT INTO nyu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Pfundzirani m'fananizo wamuti wakucemeredwa figeira: Pomwe mithambi yace imbakula, masamba yace yambaphukira, imwe mumbadziwa kuti maindza yafendera. ");
INSERT INTO nyu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ni tenepoyombo, mukadzawona bzinthu bzentsenebzi, mudzadziwe kuti Iye ali pafupi, ali pamisuwo. ");
INSERT INTO nyu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ine nin'kutsimikizani kuti m'badwe uno an'dzamala lini bzikanati kuwoneka bzimwebzi. ");
INSERT INTO nyu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kudzulu na pantsi bzin'dzapita, tsono mafala yangu yan'dzakhala kwa kuyenda na kuyenda”. ");
INSERT INTO nyu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Bza nthawe na ntsiku palibe omwe an'dziwa, ngakhale anju za kudzulu, napo Mwana, tsono an'dziwa ni Baba basi. ");
INSERT INTO nyu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ninga momwe bzidacitikira Panthawe ya Nowa, bzin'dzacitikambo tenepo pa kubwera kwa Mwana wa munthu. ");
INSERT INTO nyu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nakuti ntsiku zidapitazo za cigumula, mbumba ikhakhala icidya na kumwa, acimbalowolana, mpaka ntsiku yomwe Nowa adapita mu arka, ");
INSERT INTO nyu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ndipo iwo alibe kudziwa, mpaka kubwera kwa cigumula ndipo cidatenga wentse. Tenepoyo bzin'dzacitika pa kudza kwa Mwana wa munthu. ");
INSERT INTO nyu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Panthawe imweyo amuna awiri an'dzakhala kumunda, m'bodzi an'dzatengedwa winango acisala. ");
INSERT INTO nyu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Akazi awiri an'dzakhala alikupeya, m'bodzi an'dzatengedwa winango acisala”. ");
INSERT INTO nyu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ndipopo, khalani na cheru, thangwe imwepo mun'dziwa lini kuti ni ntsiku iponi yomwe an'dzabwera Mbuya wanu. ");
INSERT INTO nyu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tsono bvani ibzi: Penu mwenekaciro wanyumba angadadziwa kuti ni nthawe iponi ya usiku yomwe mbava in'bwera, iye angadalindira ndipo angadalekerera lini kuti nyumba yace icholedwe. ");
INSERT INTO nyu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Na tenepo imwepombo bzin'funika kuti mukhale wakukondzeka, thangwe Mwana wa munthu an'dzabwera Panthawe yomwe imwe mun'dikhira lini”. ");
INSERT INTO nyu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Mbani tsono kapolo wakukhulupirika na kucenjera, omwe mbuya wace animuikha kuti anyang'anire wa pabanja pace kuti awapase phoso Panthawe caiyo? ");
INSERT INTO nyu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ngnyakudala kapolo omwe mbuya wace an'dzagumana alikucita bzimwebzi pomwe an'bwerera. ");
INSERT INTO nyu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nin'kutsimikizani kuti iye an'dzamuikha kuti anyang'anire bzace bzentse. ");
INSERT INTO nyu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tsono pinango kapoloyo ngwakuipa acirewa mwa iye yekha kuti: ‘Mbuya wangu alikucedwa’, ");
INSERT INTO nyu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ndipo pamwepo aciyamba kumbamenya wa panyumbapo ndipo acimbadya na kumwa pabodzi na aledzeri. ");
INSERT INTO nyu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pamwepo, Mbuya wa kapolo ule an'bwera ntsiku yomwe akhadikhirira lini ndipo panthawe yomwe an'dziwa lini. ");
INSERT INTO nyu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Iye an'dzamupasa nyathwa ikulu kwene-kwene ndipo an'dzamuikha pambuto ibodzi na wacipha-maso, komwe kun'dzakhala kulira na kukukuta mano”. ");
INSERT INTO nyu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Nthawe imweyo, Umambo wa kudzulu bundzakhala, ninga madende khumi yomwe yadatenga bziphani-phani bzayene ndipo yadacoka kuti yakagumane na namwali wawo. ");
INSERT INTO nyu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Maxanu ya iyo yakhali yakupusa, ndipo maxanu yakhali yakucenjera. ");
INSERT INTO nyu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yakupusa yadatenga bziphani-phani bzayene, tsono yalibe kutenga mafuta. ");
INSERT INTO nyu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tsono yakucenjera yadatenga mafuta m'bzombo pabodzi na bziphani-phani bzayene. ");
INSERT INTO nyu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Namwali adacedwa kufika, ndipo wentse adabva tulo acigona”. ");
INSERT INTO nyu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pakati pa usiku, kudabveka kukuwa kuti: ‘Namwali alikufendera! Cokani mukagumane naye!’ ”. ");
INSERT INTO nyu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Pamwepo madende yentse yadalamuka yacikondzekera bziphani-phani bza yene. ");
INSERT INTO nyu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yakupusa yale yadauza wakucenjera kuti: ‘Tipasenimbo pang'ono mafuta yanu, nakuti bziphani-phani bzathu bzirikuthima’ ”. ");
INSERT INTO nyu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Iwo adatawira kuti: ‘Nee, nakuti pinango yan'dzakwana lini kwa ife na imwepo. Ndokoni kuna wakugulisa mukagule mafuta yanu’ ”. ");
INSERT INTO nyu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ndipo iwo atacoka kukagula mafuta, namwali adafika. Madende yomwe yakhadakondzeka yadapita na iye muuzokoto bwa malowozi ndipo msuwo udafungiwa”. ");
INSERT INTO nyu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Mwakucedwa yadabwerambo madende yakupusa yale yaciti: ‘Mbuya! Mbuya! Tifungulirenimbo msuwo ife!’ ”. ");
INSERT INTO nyu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Tsono iye adatawira adati: ‘Cadidi n'cakuti ine nin'kudziwani lini!’ ” ");
INSERT INTO nyu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pakumaliza Jezu adati: “Na tenepo, khalani na cheru, thangwe imwepo mun'dziwa lini ntsikuna nthawe! ");
INSERT INTO nyu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Umambo bwa kudzulu un'dzandendemerambo ninga mwamuna omwe, pakucoka ulendo, adacemera akapolo wace aciwasiyira bzombo bzace. ");
INSERT INTO nyu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","M'bodzi adam'pasa talento zixanu, kwa winango adam'pasa ziwiri ndipo winango ibodzi. M'bodzi na m'bodzi malingana na mphambvu zace. Patsogolo pace adaguduka ulendo bwace. ");
INSERT INTO nyu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Omwe akhadatambira matalento maxanu adacokeratu pamwepo acikayaphatisa basa ndipo aciphindula yanango maxanu. ");
INSERT INTO nyu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Napombo omwe akhadatambira matalento mawiri adawona phindu mawiri. ");
INSERT INTO nyu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tsono omwe akhadatambira talento libodzi, adacoka acicera dindi pantsi aciifucira ndipo adabisa kobiri ya mbuya wace. ");
INSERT INTO nyu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Patapita nthawe izinji mbuya wa akapolo wale adabwerera acirewengerana kobirizo. ");
INSERT INTO nyu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Omwe akhadatambira matalento maxanu adabweresa yanango maxanu ndipo adati: ‘Inde, mbuya, mudandipasa matalento maxanu, onani ndacita phindu manango maxanu’. ");
INSERT INTO nyu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Mbuya adatawira aciti: ‘Ni bzabwino kwene-kwene, kapolo wabwino ndipo wakukhulupirika! Iwepo udakhulupirika na bzing'ono, ine nin'dzakuikha pa bzizinji. Bwera udzacite mbali pa cikondwerero ca ine, mbuya wako!’ ");
INSERT INTO nyu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Adabwerambo ule omwe akhadatambira matalento mawiri adati: ‘Inde mbuya mudandipasa matalento mawiri. Onani ndacita phindu yanango mawiri’. ");
INSERT INTO nyu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Mbuya adatawira kuti: ‘Ni bzabwino kwene-kwene, kapolo wabwino ndipo wakukhulupirika! Iwepo udakhulupirika na bzing'ono, ine nin'dzakuikha pa bzizinji. Bwera udzacite mbali pacikondwerero ca mbuya wako’. ");
INSERT INTO nyu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Pakumalizira adabwera omwe akhadatambira talento ibodzi adati: ‘Ine ndikhadziwa kuti mbuya ndimwe mwamuna wakunesa kwene-kwene, omwe mumbabvuna pomwe mulibe kubzala ndipo mumbakhongobza pomwe mulibe kumwaza. ");
INSERT INTO nyu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ndipopo ndidabva mantha, ndidacoka ndicikabisa talento yanu pantsi. Njiyi talento yanu’. ");
INSERT INTO nyu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mbuya adatawira kuti: ‘Kapolo wakuipa ndipo wautofu! Iwe ukhadziwa kuti ine nimbabvuna pomwe ine ndiribe kubzala ndipo nimbakhongobza pomwe ndiribe kumwaza? ");
INSERT INTO nyu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na tenepo, bzikhafunika kuti iwepo ukaikhe kuthenthe lakukoyera, kuti ine ndikabwera ndidzatambire na cimbadzo. ");
INSERT INTO nyu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Mutengereni talento yace iperekeni kuna omwe ana khumi. ");
INSERT INTO nyu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nakuti omwe anabzo, an'dzapasidwa bzinango, ndipo an'dzakhala na bzakuposa. Tsono omwe alibe, napo bzomwe anabzo an'dzatengeredwa. ");
INSERT INTO nyu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ndipo m'thuseni kunja kapolo wautofu, kum'dima, komwe kun'dzawoneka kulira na kukukuta-mano’. ");
INSERT INTO nyu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Pomwe Mwana wa munthu an'dzabwera pam'pando wa umambo bwace, pabodzi na anju zentse, an'dzakhala pam'pando wa utongi wa ulemerero. ");
INSERT INTO nyu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Madzindza yentse yan'dzatsonkhezedwa patsogolo pace, Ndipo Iye an'dzapambula yanango na yandzace ninga makabusa omwe an'pambula mabira pa atonde. ");
INSERT INTO nyu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ndipo an'dzaikha mabira kuboko lace lamadidi ndipo atonde kuboko lace la madzere. ");
INSERT INTO nyu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Pamwepo Mambo an'dzauza omwe aliboko lace lamadidi kuti: ‘Bwerani wakusimbidwa wa Baba wangu! Tambirani ninga utaka Umambo omwe budakondzedwa kuyambira pakulengedwa kwa dziko. ");
INSERT INTO nyu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nakuti Ine ndikhana njala ndipo imwepo mudandipasa cakudya. Ndikhana nyota imwepo mudandipasa cakumwa. Ndikhali nyakudza imwepo mudandikhongobza, ");
INSERT INTO nyu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ndikhana usiwa imwepo mudandibvazika. Ndikhaduwala imwepo mudandirimbikisa. Ndikhali m'kawoko imwepo mudadzandiwona’. ");
INSERT INTO nyu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Pamwepo wakulungama adam'tawira kuti: ‘Mbuya, ni lini pomwe tidakuwonani na njala ticikupasani cakudya ayai na nyota ticikupasani cakumwa? ");
INSERT INTO nyu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ni lini pomwe tidakuwonani ninga nyakudza ticikukhongobzani, ayai wausiwa ticikupasani bzakubvala? ");
INSERT INTO nyu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ni lini pomwe tidakuwonani mucidwala ayai m'kawoko ticidzakuzungirani?’ ");
INSERT INTO nyu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Mambo an'dzatawira kuti: ‘Nin'kuuzani bzacadidi kuti, bzomwe imwepo mudacita kwa m'bodzi mwa abale wangu ang'ono, mudacitira Ine’. ");
INSERT INTO nyu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pamwepo Iye an'dzauza omwe ali kuboko lace lamadzere kuti: ‘Wakutembereredwa, cokani kwa Ine ndokoni kumoto wakusaya kumala, omwe udakondzeredwa Dyabu na anju zace. ");
INSERT INTO nyu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nakuti Ine ndikhana njala, ndipo imwe mulibe kundipasa cakudya, ndikhana nyota ndipo mulibe kundipasa cakumwa, ");
INSERT INTO nyu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ndikhali mulendo imwepo mulibe kundikhongobza, ndikhana usiwa imwepo mulibe kundipasa cakubvala, ndikhadwala ndipo ndikhali m'kawoko imwepo mulibe kundzandiwona’. ");
INSERT INTO nyu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Pamwepo iwombo an'dzatawira kuti: ‘Mbuya, ni kuponi komwe tidakuwona na njala ayai nyota ayai nyakudza ayai wakusaya cakubvala ayai wakuduwala ayai m'kawoko ndipo tiribe kukuthandizani?’ ");
INSERT INTO nyu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Iye an'dzawatawira kuti: ‘Nin'kuuzani cadidi kuti: Comwe imwepo mudaleka kucita kwa ang'ono-ang'onowa, mulibe kucitambo kuna Ine’. ");
INSERT INTO nyu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ndipo amwewa an'dzayenda kunyathwa yakusaya kumala, tsono wakulungama kumoyo wakusaya kumala”. ");
INSERT INTO nyu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pomwe Jezu adamala cipfundziso centseneci, adauza wakupfundzira wace kuti: ");
INSERT INTO nyu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ninga imwe mun'dziwa, zasala ntsiku ziwiri kuti ticite uzokoto bwa Paxkwa, Mwana wa munthu an'dzaperekedwa kuti akhomereredwe pam'tanda”. ");
INSERT INTO nyu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Panthawe imweire akulu-akulu wa anyantsembe na atsogoleri wa mbumba adatsonkhana kunyumba kwa Kaifasi m'kulu wa anyantsembe, ");
INSERT INTO nyu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","iwo pabodzi adacita citalo cakuti amange Jezu acimupha mwakabise-bise. ");
INSERT INTO nyu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tsono akhalewa kuti: “Bzin'funika lini cita nthawe za uzokoto zino, nakuti pangawoneke phokoso pakati pa mbumba”. ");
INSERT INTO nyu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pomwe Jezu akhali muBetanya, kunyumba kwa Simau, nyamapere, ");
INSERT INTO nyu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mkazi winango adafendera kuna Iye na ntsupa ya mafuta ya alabastro bzakununchira bza kobiri zizinji kwene-kwene. Iye adathulurira mumsolo mwa Jezu, pomwe Iye akhadya pa meza. ");
INSERT INTO nyu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wakupfundzira pomwe adawona bzimwebzi, adaipidwa kwene-kwene ndipo adam'bvundza kuti: “Thangwe ranyi kudzonga terepa? ");
INSERT INTO nyu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bzakununchirabzi bzingadagulisidwa na ntsengwa ikulu, ndipo kobirizo zingadapasidwa wakusauka”. ");
INSERT INTO nyu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jezu pomwe adadziwa bzimwebzi adawabvundza kuti: “Ni thangwe ranyi imwepo mun'funa kunesa mkaziyu? Iye wacita cinthu cabwino kuna ine. ");
INSERT INTO nyu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nakuti wakusauka an'dzakhala na imwe nthawe zentse, tsono Ine imwepo mun'dzakhala lini nande nthawe zentse. ");
INSERT INTO nyu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pomwe athulula bzakununchirabzi muthupi mwangu, iye wabzicita mwakukondzekera thupi rangu kudidi. ");
INSERT INTO nyu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ine nin'kuuzani kuti kumbuto iri-yentse ya dziko lentse komwe kun'dzapalidzidwa Mafala Yabwinoya, bzomwe iye acita bzin'dzawerengedwambo mwakum'kumbukira”. ");
INSERT INTO nyu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pamwepo, m'bodzi wa khumi na awiri wale, wakucemeredwa Judasi Isikaliyoti, adayenda kuna akulu wa anyantsembe ");
INSERT INTO nyu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ndipo adakawabvundza kuti “Mun'dzandipasa ciyani ndikadzam'pereka kuna imwe?” Ndipo adamutalira ntsengwa kuti: Kobiri za ndzayaya za parata makumi matatu. ");
INSERT INTO nyu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kuyambira pamwepo, Judasi akhanyang'ana mpata wakuti apereke Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ndipo ntsiku yakuyamba ya uzokoto bwa pau zakusaya cakufufumisa, wakupfundzira adayenda kuna Jezu ndipo adamubvundza kuti: “Kodi mun'funa kuti tikakukondzereni kuponi cakudya ca paxkwa?” ");
INSERT INTO nyu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Iye adatawira kuti ndokoni kum'zinda, mukanyang'ane mwamuna m'bodzi mukamuuze kuti: “Misiri walewa kuti: Nthawe yangu yafendera Ine na wakupfundzira wangu nin'dzacitira kumui kwako uzokoto bwa paxkwa”. ");
INSERT INTO nyu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wakupfundzira adacita ninga momwe Jezu akhadawauzira ndipo adakakondza uzokoto bwa Paxkwa. ");
INSERT INTO nyu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pomwe kukhadoka, Jezu akhadakhala pa meza na wakupfundzira khumi na awiri wale. ");
INSERT INTO nyu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ndipo pomwe akhadya Jezu adati: “Nin'kuuzani cadidi kuti m'bodzi wa imwe an'dzandisandulikira”. ");
INSERT INTO nyu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iwo adakhala wakusunama kwene-kwene ndipo adayamba kumubvundza m'bodzi na m'bodzi kuti: “Mbuya, kodi ndine?” ");
INSERT INTO nyu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jezu adatsimikiza kuti: “Ule omwe anisaiza pabodzi na Ine mundiro, umweyo an'dzandisandulikira. ");
INSERT INTO nyu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wa munthu aniyenda, ninga momwe bzidanembedwa kucipande ca iye. Tsono, tsoka kwa ule omwe an'dzasandulikira Mwana wa munthu! Bzikhali bwino angadaleka kubadwa”. ");
INSERT INTO nyu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pamwepo, Judasi omwe angadamusandulikira, adati: “Misiri, kodi ndine?” Jezu adatsimikiza aciti: “Inde ndiwepo”. ");
INSERT INTO nyu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pomwe akhadya, Jezu adatenga pau acidalisa ndipo adaubedula, adapasa wakupfundzira wace adati: “Tambirani, dyani. Iri ni thupi rangu”. ");
INSERT INTO nyu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Patsogolo pace adatenga m'kombo wa vinyu aciudalisa adapasa wakupfundzira wace adati: “Mwani mwentse. ");
INSERT INTO nyu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Umweyu ni mulopa wangu wa cipangano, omwe un'dzataidwa thangwe ra azinji, kuti alekeleredwe bzakuphonyera Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ine nin'kuuzani kuti, kuyambira tsapano kuyenda kutsogolo nin'dzamwa lini pomwe bzakumwabzi bza muti wa uva mpaka ntsiku ire yomwe nin'dzamwa vinyu ipsa na imwepo muUmambo bwa Baba wangu”. ");
INSERT INTO nyu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Atamala kuimba nyimbo ibodzi, adacoka aciyenda kuphiri la Olivera. ");
INSERT INTO nyu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pamwepo Jezu adawauza kuti: “Usiku buno mwentsenemwe mun'ndisiya. Nakuti bzidanembedwa kuti: “ ‘Nin'dzapweteka makabusa, ndipo mabira yan'dzabalalisidwa pam'thithi’. ");
INSERT INTO nyu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ndipo, ndikadzalamuka kwa wakufa, nin'dzatsogola kuyenda kuGalireya”. ");
INSERT INTO nyu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedru adam'tawira kuti: “Napo wentse adzakusiyeni, ine nin'dzakusiyani lini cipo!” ");
INSERT INTO nyu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jezu adatawira kuti: “Cadidi nin'kuuza kuti usiku buno, congwe akanati kulira katatu iwepo un'dzandiramba”. ");
INSERT INTO nyu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tsono Pedru adatsimikiza kuti: “Napo bzicifunika kuti ine ndife pabodzi na imwe, nin'dzakulambani lini cipo”. Ndipo wakupfundzira anangowo adalewambo bzibodzi-bodzibzo. ");
INSERT INTO nyu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pamwepo Jezu adayenda na wakupfundzira wace kumbuto inango ikhacemeredwa Getsemani ndipo adati: “Bakakhalani pano pomwe Ine ndirikuyenda apo kukapemba”. ");
INSERT INTO nyu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Adatenga Pedru na wana awiri wa Zebedeu, Jezu adayamba kusunama na kutsukwala. ");
INSERT INTO nyu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Pamwepo Iye adawauza kuti: “M'tima mwangu mudadzala na m'sunamo mpaka kufa. Bakakhalani pano ndipo mulindire pabodzi na Ine”. ");
INSERT INTO nyu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Adayenda patsogolo pang'ono, adagodama acitsulima mpaka pantsi ndipo adapemba aciti: “Baba, penu bzin'kwanisika, kalise imweyi fundusani kuna Ine. Na tenepo, bzireke kucitika ninga momwe Ine nin'funa, tsono citani ninga momwe Imwe mun'funa”. ");
INSERT INTO nyu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tsono pomwe adabwerera kuna wakupfundzira wace, adawagumana adagona ndipo Iye adabvundza Pedru kuti: “Imwepo mulibe kukwanisa kulindira na Ine ngakhale nthawe ibodzi? ");
INSERT INTO nyu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Lindirani ndipo pembani kuti muleke kugwa mukuyezedwa. Mzimu un'funa tsono thupi ni lakuwofoka”. ");
INSERT INTO nyu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ndipo adacoka pomwe acikapemba kuti: “Baba wangu, penu bzin'kwanisika lini kundifundusira mkomboyu Ine ndicireka kuumwa, citani cifuniro canu”. ");
INSERT INTO nyu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pomwe adabwerera, adawagumana agona pomwe, thangwe maso yawo yakhadalemedwa. ");
INSERT INTO nyu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pamwepo adawasiya aciyenda kukapemba kacitatu adalewa mafala yabodzi-bodziyo. ");
INSERT INTO nyu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Patsogolo pace adabwerera kuna wakupfundzira wace adawauza kuti: “Imwepo mukadagona ndipo muli kupuma? Onani nthawe yakwana! Ndipo Mwana wa munthu alikuperekedwa m'manja mwa wanthu wakuphonyera Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lamukani, tiyende! Onani alikubwera ule omwe alikundipereka!” ");
INSERT INTO nyu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Pomwe Iye akhalewa terepoyo, adafika Judasi m'bodzi wa khumi na awiri wale. Iye akhana m'thithi ukulu omwe ukhadakondzeka bzisenga na mpsimbo, akhadatumidwa na akulu-akulu wa anyantsembe na atsogoleri wa mbumba. ");
INSERT INTO nyu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wakum'perekayo akhadapangana na iwo kuti an'cita cizindikiro cakuti: “Ule omwe nin'kamusana naye ndicim'mpsompsona, ni umweyo m'mangeni”. ");
INSERT INTO nyu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judasi adayenda lunga-lunga kuna Jezu ndipo adati: “Tikumuseni, Misiri”, ndipo adam'mpsompsona. ");
INSERT INTO nyu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jezu adam'bvundza kuti: “Xamwali, wabwera kudzacita ciyani?” Pamwepo iwo adafendera ndipo adam'phata acim'manga. ");
INSERT INTO nyu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tsono m'bodzi wa omwe akhana Jezu, adasolola cisenga acipweteka kapolo wa m'kulu wa anyantsembe mpaka kumugwata khutu. ");
INSERT INTO nyu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Na tenepo Jezu adamuuza kuti: “Bwezera cisenga m'mbuto yace! Pakuti wentse wakuphatisa basa cisenga, an'dzaphedwa na cisenga. ");
INSERT INTO nyu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kodi iwepo ulikukumbuka kuti Ine ningakumbire lini Baba wangu, ndipo Iye acinditumizira m'thithi wa anju wa nkhondo wakuposa khumi na awiri tsapanopa? ");
INSERT INTO nyu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tsono, bzingadakhala tenepoyo bzingadacitika tani kuteweza bzomwe Manemba yalikulewa kuti bzimwebzi bzikhafunika kuti bzicitike mwatenepayu?” ");
INSERT INTO nyu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Panthawe imweire Jezu adauza m'thithi kuti: “Mwabwera na bzisenga na mpsimbo kuti mudzandimange, kodi Ine ndirikutsogolera wanthu wakusandukira? Ntsiku zentse Ine ndikhambapfundzisa kucintalo ca Nyumba ya Mulungu ndipo imwe mulibe kundimanga! ");
INSERT INTO nyu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tsono bzentsenebzi bzacitika kuti bzikwanirisike Bzakunemba bza apolofita”. Pamwepo wakupfundzira wentse acimusiya, adathawa. ");
INSERT INTO nyu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ndipo omwe adamanga Jezu adam'tenga aciyenda naye kunyumba ya Kaifasi m'kulu wa anyantsembe, komwe akhadatsonkhana adziwi wa Mtemo na akulu wa aJuda. ");
INSERT INTO nyu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tsono Pedru akhatewera na patali mpaka kuseri kwa mkulu wa anyantsembe, adapita acikhala pabodzi na alindiri kuti awone bzomwe bzin'citika. ");
INSERT INTO nyu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Akulu wa anyantsembe na atongi wa mphala ikulu wentse akhanyang'ana mulandu wakunamizira Jezu kuti amuphe. ");
INSERT INTO nyu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tsono alibe kuwona mulandu napo akhambapereka umboni buzinji bwakunama. Pakumalizira adadzawoneka awiri ");
INSERT INTO nyu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","omwe adapereka umboni bwakuti: “Mwamuna umweyu adalewa kuti: ‘Ine ningakwanise kupfudza nyumba ya Mulungu ndipo ndiciimanga muntsiku zitatu’ ”. ");
INSERT INTO nyu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pamwepo m'kulu wa anyantsembe adaimirira aciuza Jezu kuti: “Iwepo un'bzitawirira lini mulandu omwe amwewa alikukupasa?” ");
INSERT INTO nyu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tsono Jezu adapitiriza kunyamala. M'kulu wa anyantsembe adamuuza kuti: “Ine nin'funa kuti Iwepo ulumbire mudzina la Mulungu wamoyo, tiuze penu Iwe ndiwe Krixtu, Mwana wa Mulungu”. ");
INSERT INTO nyu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jezu adam'tawira kuti: “Iwepo ndiwe walewa, tsono Ine nin'kuuzani mwentse kuti: In'dzafika ntsiku yomwe mun'dzawona Mwana wa munthu adakhala kuboko lamadidi la Wamphambvu zentse ndipo acidzabwera pakati pa mitambo ya kudzulu”. ");
INSERT INTO nyu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pamwepo m'kulu wa anyantsembe adang'amba bzakubvala bwace acirewa kuti: “Wanyoza! Kodi tin'funiranyi mboni zinango? Imwepo mwamala kubva kunyoza kumweku. ");
INSERT INTO nyu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Muli kukumbuka tani?” Iwo adatawira kuti: “Bzin'funika kuti aphedwe!” ");
INSERT INTO nyu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pamwepo anango adam'psipira mata kunkhope acim'menya na mafaiti. Anango akhamenya na mbama ");
INSERT INTO nyu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ndipo akhambati: “Cita cipolofita, Krixtu. Mbani omwe wakumenya?” ");
INSERT INTO nyu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedru akhadakhala kunja mulitsito la nyumba ya m'kulu wa anyantsembe, ndipo m'tsikana wa basa adafendera kuna iye aciti: “Iwepombo ukhali pabodzi na Jezu wa kuGalireya”. ");
INSERT INTO nyu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tsono iye adamulamba patsogolo pa wentse aciti: “Nin'dziwa lini bzomwe iwe ulikulewa”. ");
INSERT INTO nyu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ndipo adacoka aciyenda kwakupitira, kapolo winango wacikazi adamuwona aciuza omwe akhali pamwepo kuti: “Mwamunayu akhali pabodzi na Jezu wa kuNazareta”. ");
INSERT INTO nyu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ndipo iye mwa kulumbira adamulamba pomwe adati: “Nin'mudziwa lini mwamuna umweyu!” ");
INSERT INTO nyu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Patapita nthawe ing'ono-ng'ono, omwe akhali kumweko adafika pafupi na Pedru ndipo adati: “Cadidi letu iwepo ndiwe m'bodzi wa iwo! Kalewedwe kako kalikulatiza”. ");
INSERT INTO nyu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pamwepo Pedru adati: “Ndirikulumbira kuti ndinim'dziwa lini mwamuna umweyo! Mulungu andipase nyathwa penu ndirikunama!” Pamwepo letu congwe adalira. ");
INSERT INTO nyu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tsono Pedru adakumbukira mafala yomwe Jezu akhadalewa yakuti: “Congwe akhanati kulira, Iwepo un'dzandiramba katatu”. Ndipo pomwe adacoka pamwepo, adalira mwakupasa ntsisi. ");
INSERT INTO nyu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ndipo, mangwana yace macibese-bese, akulu-akulu wa anyantsembe wentse na atsogoleri wa aJuda adaphata mfundo yakupasa mulandu Jezu kuti aphedwe. ");
INSERT INTO nyu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ndipo adam'manga aciyenda naye kukam'pereka kuna Pirato m'tongi mkulu wa cigawo. ");
INSERT INTO nyu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pomwe Judasi omwe adam'pereka, adawona kuti Jezu wapasidwa nyathwa, adazindikira bzomwe adacita, adatenga kobiri za ndzayaya makumi matatu acikapereka kuna akulu-akulu wa anyantsembe na atsogoleri wa aJuda. ");
INSERT INTO nyu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ndipo adati: “Ndidaphonya, nakuti ndidapereka munthu wakusaya thangwe”. Ndipo iwo adam'tawira kuti: “Ife tinabzonyi? Mulandu ni wako”. ");
INSERT INTO nyu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pamwepo Judasi adathusa kobiri munyumba ya Mulungu ndipo pomwe adacoka adayenda kukabzimangirira. ");
INSERT INTO nyu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Akulu-akulu wa anyantsembe adagwezeka kobiri zire ndipo adati: “Ni kuphonyera Mtemo kuikha kobirizi kuthenthe, thangwe ni za ntsengwa ya mulopa”. ");
INSERT INTO nyu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pamwepo adaphata mpfundo yakuti akagule mbuto kwa nyakuumba bzikalango kuti ukhale thenje la anyakudza. ");
INSERT INTO nyu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndipopo mpaka lero iyo imbacemeredwa kuti Mbuto ya Mulopa. ");
INSERT INTO nyu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pamwepo bzidakwanirisidwa bzomwe bzidalewedwa na m'polofita Jeremiya kuti: “Adatenga kobiri za ndzayaya makumi matatu, ntsengwa yomwe mbumba ya Ijirayeri idabverana, ");
INSERT INTO nyu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ndipo adaziphatisa basa pakugula mbuto ya wakuumba bzikalango, ninga momwe Mbuya akhadalewa”. ");
INSERT INTO nyu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jezu adaikhidwa patsogolo pa Pirato m'tongi mkulu wa cigawo, ndipo iye adamubvundza kuti: “Iwe ndiwe mambo wa aJuda?” Jezu adam'tawira kuti: “Iwe ndiwe ulikulewa”. ");
INSERT INTO nyu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ndipo pomwe akhapasidwa mulandu na akulu-akulu wa anyantsembe na atsogoleri wa aJuda, Iye alibe kutawira cinthu. ");
INSERT INTO nyu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pamwepo Pirato adam'bvundza kuti: “Iwepo ulikubva lini kuti ni mirandu mingasi yomwe alikukupasayi?” ");
INSERT INTO nyu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tsono Jezu alibe kulewa fala na libodziro, mwakuti m'tongi m'kulu wa cigawo adakhala wakudabwa nabzo. ");
INSERT INTO nyu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tsono Panthawe za uzokoto bwa Paxkwa akhana cizerewezi ca m'tongi m'kulu wa cigawo kucosa wam'kawoko m'bodzi wakusankhulidwa na mbumba. ");
INSERT INTO nyu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nthawe imweire iwo akhana nyam'kawoko m'bodzi wakudziwika kwene-kwene dzina lace likhali Barabasi. ");
INSERT INTO nyu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pirato adabvundza mthithi omwe ukhadatsonkhana pa mbuto ire kuti: “Ni muponi wa amwewa omwe mun'funa kuti ndikutsundzulireni: Barabasi ayai Jezu, wakucemeredwa Krixtu?” ");
INSERT INTO nyu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Thangwe akhadziwa kuti adam'pereka mwa ciwengo. ");
INSERT INTO nyu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pomwe Pirato akhadakhala pa mphala, mkazi wace adamutumizira mafala yakuti: “Leka kupitira nkhani ya munthu wakusaya mulandu, thangwe lero mukulota ndabonera kwene-kwene thangwe la Iye”. ");
INSERT INTO nyu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tsono akulu-akulu wa anyantsembe na atsogoleri wa aJuda adapumpsa m'thithi kuti ukumbire kucoseredwa Barabasi ndipo aphe Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pamwepo m'tongi m'kulu wa cigawo adabvundza aciti: “Ni muponi pa awiriwa omwe mun'funa kuti ndikucosereni?” Iwo adatawira kuti: “Barabasi!” ");
INSERT INTO nyu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pirato adabvundza kuti: “Ndicite ciyani tsono na Jezu, wakucemeredwa Krixtu?” Wentse adatawira kuti: “Mukhomerereni pamtanda!” ");
INSERT INTO nyu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pirato adabvundza kuti: “Thangwe ranyi? Ni mulandu uponi omwe Iye acita?” Tsono iwo akhambapitiriza kukuwa aciti: “Mukhomerereni!” ");
INSERT INTO nyu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pomwe Pirato adadziwa kuti akhakwanisa lini kuwona phindu labwino, ndipo wanthuwo akhayamba kucita phokoso, adalewa kuti am'pase madzi, adasamba m'manja patsogolo pamthithi aciti: “Ndiribe mulandu pa mulopa wa mwamunayu, mulandu ni wanu”. ");
INSERT INTO nyu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mbumba yentse idatawira kuti: “Mulopa wace ugwere kuna ife na kuna wana wathu!” ");
INSERT INTO nyu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pamwepo Pirato adawatsudzulira Barabasi, adalewa kuti Jezu amenyedwe ndipo adam'pereka kuti akhomereredwe pa m'tanda. ");
INSERT INTO nyu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pamwepo acikunda wa m'tongi m'kulu adatenga Jezu aciyenda naye kunyumba ya m'tongi m'kulu wacigawo, ndipo acikunda wentse adam'zungulira. ");
INSERT INTO nyu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Adam'cosa bzakubvala acimubvazika cikapote cifuira, ");
INSERT INTO nyu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Adam'kondzera nkhata ya minga ndipo adamuikha mumsolo mwace. Acimuikha mpsimbo kuboko la madidi, ndipo adagodama patsogolo pace, acimbamusinjirira aciti: “Bzipulumuse, mambo wa aJuda!” ");
INSERT INTO nyu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Adamupsipira mata ndipo acimutengera mpsimbo acimbamenya nayo mumsolo. ");
INSERT INTO nyu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Atamala kumusinjirira Iye, adamucosa cikapote ndipo adamubvazika bzakubvala bzace pamwepo adam'tenga kuti akam'khomerere. ");
INSERT INTO nyu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pomwe akhacoka, adagumana na mwamuna m'bodzi wa kuSireni akhacemeredwa Simau ndipo adamukakamiza kunyamula m'tanda. ");
INSERT INTO nyu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Adafika pambuto ina yomwe ikhacemeredwa Gologota, komwe ni kulewa kuti mbuto ya n'khadzi za misolo, ");
INSERT INTO nyu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ndipo adam'pasa kuti amwe vinyu yakusanganiza na ndulu, tsono pomwe adalawidza adalamba kumwa. ");
INSERT INTO nyu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Atam'khomera pam'tanda, adagawana bzakubvala bzace mwakucita vima-vima. ");
INSERT INTO nyu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ndipo atakhala pamwepo adamulindira. ");
INSERT INTO nyu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Adaikha cikwangwali padzulu pa msolo wace comwe cikhadanemba mulandu omwe adamunamizira nawo kuti: Uyu ni Jezu, Mambo wa aJuda. ");
INSERT INTO nyu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Akambowa awiri adakhomeredwa naye pabodzi, ibodzi kuboko lamadidi inango kulamadzere. ");
INSERT INTO nyu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Omwe akhapita na pamwepo akhambam'tukana acimbakwetekedza msolo ");
INSERT INTO nyu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ndipo acimbalewa kuti: “Iwepo omwe un'pfudza Nyumba ya Mulungu ndipo uciimisa muntsiku zitatu, bzipulumuse! Penu ndiwe Mwana wa Mulungu, buluka pam'tanda!” ");
INSERT INTO nyu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bzibodzi-bodzi na atsogoleri wa anyantsembe, na adziwi wa Mtemo ndipo na atsogoleri wa aJuda akham'sinjirira, ");
INSERT INTO nyu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","acimbati: “Adapulumusa anango, tsono an'kwanisa lini kubzipulumusa Iye yekha! Iye ni mambo wa Ijirayeri! Buluka tsapanopa pam'tanda, ndipo tin'dzamukhulupirira. ");
INSERT INTO nyu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iye adakhulupirira Mulungu. Mulunguyo mbam'pulumuse tsapano, penu an'funa, nakuti adati: ‘Ndine mwana wa Mulungu!’ ” ");
INSERT INTO nyu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bzibodzi-bodzi na mbava zomwe zikhadakhomereredwa pabodzi na Iye zikham'tukana. ");
INSERT INTO nyu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ndipo kuyambira pakati na kati ya masikati kufikira nthawe zitatu zakumaulo padawoneka m'dima pa dziko lentse la pantsi. ");
INSERT INTO nyu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","M'kati mwa nthawe zitatu za kumaulo, Jezu adakuwa kwene-kwene adati: “Eloi, Eloi, Lama sabakitani?” Bzirikulewa kuti: “Mulungu wangu, Mulungu wangu, Thangwe ranyi mwandirekerera?” ");
INSERT INTO nyu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pomwe adabva bzimwebzi anango omwe akhali pambuto ire, adati: “Iye alikucemera Eriya”. ");
INSERT INTO nyu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pamwepo letu, m'bodzi wa iwo adathamanga kukatenga guntsalinya, acibviika muvinyu yakuwawasa, adaphairira kuntsonga kwa cimuti ndipo adapasira Jezu kuti amwe. ");
INSERT INTO nyu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tsono anango adalewa kuti: “Mulekeni. Tin'funa kuwona penu Eriya an'bwera kudzam'pulumusa”. ");
INSERT INTO nyu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pomwe adamala kukuwa pomwe, Jezu adapereka m'zimu. ");
INSERT INTO nyu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pamwepo letu, nguwo ya kugawa Nyumba ya Mulungu idang'ambika bzipande bziwiri, kuyambira kudzulu mpaka pantsi. Pantsi padatekenyeka, ndipo minyala idabaduka. ");
INSERT INTO nyu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nthutu zidafunguka, ndipo mitembo ya wakucena azinji omwe akhadafa adalamusiwa kwa wakufa. ");
INSERT INTO nyu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ndipo, atacoka munthutu, Jezu atalamuka kwa wakufa, adapita mum'zinda wakucena ndipo adawonekera. ");
INSERT INTO nyu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pomwe kapitau wa gulu la acikunda wa ciRoma na omwe akhali pabodzi na iye akhalindira Jezu adabva kutekenyeka na bzentse bzomwe bzikhadacitika, adakhala na mantha kwene-kwene ndipo acimbalewa kuti: “Cadidi umweyu akhali Mwana wa Mulungu!” ");
INSERT INTO nyu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Akazi azinji akhali pamwepo, acimbawona na patali. Iwo akhatewera Jezu kuyambira kuGalireya, kuti amutumikire. ");
INSERT INTO nyu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pakati pawo akhalipo Maliya wa kuMagadala, Maliya mai wa Tiyago na Zuze, ndipo na mai wa wana wa Zebedeu. ");
INSERT INTO nyu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pomwe kukhakwana kumaulo padafika mwamuna nyakudala, wa mzinda wa kuArimateya, akhacemeredwa Zuze, omwe akhalimbo wakupfundzira wa Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Adayenda kuna Pirato, acikakumbira mtembo wa Jezu, ndipo Pirato adalewa kuti apasidwe. ");
INSERT INTO nyu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Zuze adatenga mtembo, aciuzengezera pa nguwo icena ipsa. ");
INSERT INTO nyu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ndipo adauikha munthutu ipswa, yomwe iye akhadaceresa pa mwala. Ndipo adafunga na mwala ukulu pakupitira pace, acicoka. ");
INSERT INTO nyu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya Madalena na Maliya winango akhadakhala pamwepo, kutsogolo kwa nthutuyo. ");
INSERT INTO nyu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mangwana yandzace, yomwe ikhali ntsiku ya Sabudu, akulu-akulu wa anyantsembe na afalizi adayenda kuna Pirato ");
INSERT INTO nyu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ndipo adati: “Mbuya, tirikukumbuka kuti, pomwe akhana moyo, wakunama ule adati: ‘Pakupita ntsiku zitatu nin'dzalamuka’. ");
INSERT INTO nyu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Na tenepo, lewani kuti nthutu yace irindiridwe mpaka ntsiku yacitatu, kuti wakupfundzira wace aleke kubwera kudzaba thupi, acidzauza mbumba kuti iye walamuka kwa wakufa. Kunama kwakumaliziraku kungadzakhale kwakukulu kuposa kwakuyamba”. ");
INSERT INTO nyu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pirato adatawira kuti: “Tengani gulu la alindiri. Ndokoni mulindire nthutuyo mwacheru ninga momwe imwe mungawonere”. ");
INSERT INTO nyu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iwo adayenda acikacita citalo cakalindiridwe kanthutuyo, ndipo adaikha cizindikiro pa mwala acisiya alindiri pamwepo. ");
INSERT INTO nyu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yatapita ntsiku ya malinkhuma, kuyamba kwa m'dzinga macibese-bese, Maliya Madalena na Maliya unango adayenda kukawona nthutu. ");
INSERT INTO nyu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mwacisututu padabveka kutekenyeka kukulu, nakuti Anju wa Mbuya adabuluka kudzulu ndipo adafika pa nthutu, acicosa mwala pakupitira aciukhalira. ");
INSERT INTO nyu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mawonekedwe yace akhadakhala ninga mpheni ndipo bzakubvala bzace bzikhadacena ninga pfulere. ");
INSERT INTO nyu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ndipo lindiri wale adatetemera na mantha adakhala ninga wakufa. ");
INSERT INTO nyu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anju ule adauza akaziwo kuti: “Lekani kubva mantha! Nin'dziwa kuti imwepo mulikunyang'ana Jezu, omwe adakhomereredwa pa m'tanda. ");
INSERT INTO nyu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Iye ali lini pano, walamuka kwa wakufa, ninga momwe akhadalewera. Bwerani muwone mbuto yomwe Iye akhadagona. ");
INSERT INTO nyu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ndokoni mwakam'fulumize ndipo kauzeni wakupfundzira wace kuti: Iye walamuka kwa wakufa ndipo atsogola alikuyenda kuGalireya. Kumweko imwe mun'kamuwona. Dziwani kuti ine ndakudziwisiratuni”. ");
INSERT INTO nyu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Akazi wale adacoka mwakam'fulumize pa nthutu, mwa mantha na kudzala na kukomedwa, adayenda mwakuthamanga acikauza wakupfundzira wa Jezu. ");
INSERT INTO nyu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mwacisututu, Jezu adagumana nawo ndipo adati: “Khalani na mtendere!” Iwo adafendera pafupi na Iye, acim'phata minyendo ndipo adam'pemba. ");
INSERT INTO nyu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pamwepo, Jezu adawauza kuti: “Lekani mantha. Ndokoni mukauze abale wangu kuti wayende kuGalireya, kumweko iwo an'kandiwona”. ");
INSERT INTO nyu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pomwe akazi wale akhayenda, anango wa alindiri adayenda kum'zinda ndipo adakafokotozera akulu wa anyantsembe bzentse bzomwe bzikhadacitika. ");
INSERT INTO nyu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Akulu-akulu wa anyantsembe adatsonkhana na atsogoleri wa mbumba ndipo adacita citalo. Adapasa acikunda kobiri zizinji, ");
INSERT INTO nyu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aciwauza kuti: “Imwepo mulewe tenepa: Wakupfundzira wace abwera usiku ndipo waba thupi, pomwe tikhadagona. ");
INSERT INTO nyu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Penu bzimwebzi bzin'fika mumakutu mwa m'tongi mkulu wa cigawo, ife tin'dzauuza ndipo tin'dzakukhocererani pa mulandu uliwentse”. ");
INSERT INTO nyu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tenepoyo acikunda adatambira kobiri ndipo adacita ninga momwe akhadawapfundzisira. Ndipo kunama kumweku kudadzabvekera pakati pa aJuda mpaka ntsiku ya lero. ");
INSERT INTO nyu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wakupfundzira khumi na m'bodzi adayenda kuGalireya, kuphiri lomwe Jezu akhadawalatiza. ");
INSERT INTO nyu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pomwe adamuwona, adamupemba, tsono anango adapenukira. ");
INSERT INTO nyu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pamwepo, Jezu adafendera pafupi na iwo aciti: “Ndidapasidwa mphambvu zentse kudzulu na pantsi. ");
INSERT INTO nyu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Na tenepo, ndokoni kuna mbumba ya m'madziko yentse mukaisanduse wakupfundzira wangu, mucimbawabatiza mudzina la Baba na la Mwana na la Mzimu Wakucena. ");
INSERT INTO nyu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Muciwapfundzisa kubvera bzentse bzomwe Ine ndidakuuzani. Ndipo Ine nin'dzakhala namwe nthawe zentse mpaka kumalizira kwa pantsi”.");
INSERT INTO nyu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kuyamba kwa Mafala Yabwino yakulewa bza Jezu Krixtu, Mwana wa Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ninga m'polofita Izaiya adanemba kuti: “Mulungu adati: Ndin'dzatuma mtumiki wangu kutsogolo kwako, kuti akakondze njira yomwe iwe udzapitembo. ");
INSERT INTO nyu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Fala la munthu wakukuwa kudambo ali kulewa kuti, ‘Kondzani njira yakudzapitira Mbuya, thamulani miseu yomwe adzapitembo.’ ” ");
INSERT INTO nyu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","N'cadidi adawoneka Juwau M'batizi kucidambo acilalika: “Sandulikani m'tima, mubatizidwe. Mulungu an'dzakulekererani bzakuipa bzanu”. ");
INSERT INTO nyu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Akhabwera kwa iye wanthu wakucokera kumphimpha zentse za Judeya na Jerusalema. Iwo akhazimbula bzakuipa bzawo, Juwau akhawabatiza mumkulo wa Jolodani. ");
INSERT INTO nyu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Iye akhabvala bzakubvala bzakukondzedwa na ukuse bwa ngamira, akhamanga m'ciuno na mceka. Cakudya cace cikhali mabombo na uci bwa m'thengo. ");
INSERT INTO nyu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Akhalalika aciti: “M'mbuyo mwangu alikubwera winango wamphambvu kuposa ine. Wakuti ine ndine wakusaya kufunika ngakhale kukotama kutsudzula thambo za xangu zace. ");
INSERT INTO nyu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ine ndakubatizani na madzi, tsono Iye an'dzakubatizani na Mzimu Wakucena”. ");
INSERT INTO nyu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ntsiku zimwezo Jezu adabwera kucokera kuNazareta, mui ubodzi wa Galireya, acibatiziwa na Juwau mumkulo wa Jolodani. ");
INSERT INTO nyu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pakucoka m'madzimo, adawona kudzulu kwakufunguka, ndipo Mzimu Wakucena udabuluka kwa Iye ninga nkhangaiwa. ");
INSERT INTO nyu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kudzulu kudabveka mafala yakuti: “Iwe ndiwe Mwana wangu wa pamtima. Nimbakomedwa nawe kwakukulu”. ");
INSERT INTO nyu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nthawe imweyo Mzimu Wakucena udapitisa Jezu mudambo. ");
INSERT INTO nyu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Adakhala kumweko ntsiku makumi manai. Sathani adamuyeza. Bzikhalipombo bzirombo bza mthengo, ndipo anju akhamutumikira. ");
INSERT INTO nyu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ataikhidwa m'kawoko Juwau, Jezu adayenda kuGalireya acilalika Mafala Yabwino yakulewa bza Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Adati: “Nthawe yakwana. Bwafika Umambo bwa Mulungu. Sandulikani m'tima. Khulupirirani Mafala Yabwino”. ");
INSERT INTO nyu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Pakuyenda m'mphepete mwa thawale la Galireya, Jezu adawona wanthu awiri, Simau na m'bale wace Andereya, akhatheya bwazi m'madzi, thangwe akhali akhongwe. ");
INSERT INTO nyu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Adawauza Jezu: “Imwe munditewere, ndikusanduseni akhongwe wa wanthu”. ");
INSERT INTO nyu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Adasiiratu mabwaziyo ndipo adamutewera. ");
INSERT INTO nyu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Atafamba pang'ono, adawona Tiyago na Juwau, wana wa Zebedeu, omwe akhali m'mwadiya kukondza mabwazi. ");
INSERT INTO nyu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jezu adawacemera, ndipo adasiya baba wawo Zebedeu m'mwadiya pabodzi na akapolo wace, acimutewera. ");
INSERT INTO nyu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Adayenda wentse kuKafaranawumi. Yatafika ntsiku ya malinkhuma, Jezu adayenda m'nyumba ya mapembero, acipfundzisa. ");
INSERT INTO nyu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wentse adadabwa na bzakupfundzisa bzace thangwe akhapfundzisa na utongi, akhasiyana ninga amisiri wa Mtemo. ");
INSERT INTO nyu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nthawe pang'ono adawoneka m'nyumba ya mapemberomo munthu wakuphatidwa na mzimu wakuipa. Adalewa na kukuwa aciti: ");
INSERT INTO nyu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Tina ciani na Imwe, Jezu wa kuNazareta? Kodi mwabwera kudzatidzonga? Ndakudziwani kuti ndimwe Wakucena wa Mulungu”. ");
INSERT INTO nyu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ndipo Jezu adalamulira mzimu wakuipayo, aciti: “Khala zii, coka mwa munthuyu”. ");
INSERT INTO nyu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pamwepo mzimu wakuipa ule udamutekenyesa munthuyo kwakukulu ucikuwa kwene-kwene, ndipo udacoka. ");
INSERT INTO nyu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wentse wale adadabwa kwakukulu acimbabvundzana: “Kodi bzimwebzi n'ciani? Cakupfundzisa cipsa cimweci! Ambaitonga mizimu yakuipa na mphambvu, ndipo idamubvera”. ");
INSERT INTO nyu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mwakamkulumize, mbiri yace idamwazika mbali zentse za Galireya. ");
INSERT INTO nyu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pambuyo pace Jezu adacoka kunyumba ya mapembero kule, adayenda kunyumba ya Simau na Andereya pabodzi na Tiyago na Juwau. ");
INSERT INTO nyu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mibzala wa Simau akhadagona kwakufesuka, pamwepo wanthu adawuza Jezu bza matendayo. ");
INSERT INTO nyu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jezu adayenda aciwaphata boko aciwamusa, ndipo maferu yadamala. Na tenepo mai ule adawaphikira cakudya. ");
INSERT INTO nyu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Maulo, latamira dzuwa, adawabweresa wentse wanthu kwa Jezu wakuduwala na wakuphatidwa na mizimu yakuipa. ");
INSERT INTO nyu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wentse wa mumzindamu adagwezekana pamsuwo. ");
INSERT INTO nyu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jezu adalimbisa azinji omwe akhabonera na matenda yakusiyana-siyana, acicosa mizimu yakuipa, aciiletsa kulewa-lewa thangwe idamuzindikira. ");
INSERT INTO nyu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Macibese-bese kukhanati kucena, Jezu adamuka aciyenda kuthengo. Kumweko adakapembera. ");
INSERT INTO nyu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simau na andzace adamunyang'ana mbali zentse. ");
INSERT INTO nyu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Atamugumana adamuuza kuti: “Wanthu wentse ali kukunyang'anani”. ");
INSERT INTO nyu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tsono Iye adatawira kuti: “Mbatiyendeni tipite kumidzi inango pafupi na pam'pano, ndikalalike mafala kumweko. Thangwe ndibzo ndidabwerera”. ");
INSERT INTO nyu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ndipo adayenda acilalika m'nyumba zentse za mapembero kuGalireya kwentseko acicosa mizimu yakuipa. ");
INSERT INTO nyu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Munthu winango wa mapere adabwera kwa Jezu. Adagodama acimudandaulira: “Mucifuna, mungakwanise kundilimbisa”. ");
INSERT INTO nyu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jezu adamubvera ntsisi. Adatambalisa boko lace acimukhuya acilewa: “Cadidi, ndafuna, ulimbe!” ");
INSERT INTO nyu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Panthawe ibodzi-bodziyo mapere yace yadamala, acicenesewa. ");
INSERT INTO nyu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ndipo Jezu adamuwuza kuti acoke acimucenjeza ");
INSERT INTO nyu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","kuti: “Uleke kuwuza ali-yentse bzimwebzi, tsono uyende ukabziwonese kwa azibaba wa ntsembe, ukapereke ntsembe yomwe adalamula Mozeji ikakhale mboni kuti walimbadi”. ");
INSERT INTO nyu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Adandocoka pamwepo, munthuyo adayamba kumbazimbula bzentse na kumwaza nkhani. Na tenepo bzikhafunika lini kuti Jezu awoneke padeca m'mizinda mwentse tsono akhakhala kuthengo. Ndipo wanthu akhambayenda kwa Iye kucokera mbuto na mbuto. ");
INSERT INTO nyu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Patapita ntsiku pang'ono, Jezu adabwera pomwe kuKafaranawumi. Bzidabveka kuti ali kunyumba. ");
INSERT INTO nyu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Azinji adagumana m'nyumbamo. Ndipo angakhale na pamsuwo pakhalibe mbuto yakupitira. Jezu, pakulewa mafala ya Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wanthu anai adanyamula bundukutu aciyenda naye. ");
INSERT INTO nyu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Alibe kufika pafupi na Jezu thangwe ra mthithi wa wanthu. Adakwira pantsodzi ya nyumba, acinyasula ntsodziyo kulinganiza pakhana Jezu. Ndipo adamubulusa bundukutu ule pamacira. ");
INSERT INTO nyu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pakuwona cikhulupiriro cawo, Jezu adawuza bundukutuyo kuti: “Mwana wangu, bzakuipa bzako bzalekereredwa”. ");
INSERT INTO nyu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tsono pamwepo akhadakhalambo amisiri wa Mtemo wa Mozeji. Iwo adayamba kubzibvundza mum'tima mwawo kuti: ");
INSERT INTO nyu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kodi Umweyu angalewe tani tenepo? Kunyoza lini Mulungu kumweku? Mbani angalekerere bzakuipa? Ni Mulungu yekha!” ");
INSERT INTO nyu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ndipo Jezu mumzimu adadziwa kuti akhakumbuka bzimwebzi mum'tima mwawo, na tenepo adawabvundza kuti: “Thangwe ranyi mun'kumbuka bzimwebzi m'mitima mwanu? ");
INSERT INTO nyu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Cakupusa n'ciponi, kumuwuza bundukutuyu kuti: ‘Bzakuipa bzako bzalekereredwa,’ ayai: ‘Muka, tenga macira yako, uyende?’ ");
INSERT INTO nyu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tsono kuti mudziwe Mwana-wa-Munthu ali nayo mphambvu pantsi pano yakulekerera bzakuipa, wonani”. Ndipo adauza bundukutuyo, ");
INSERT INTO nyu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Iwe, muka, tenga macira yako, uyende kumui”. ");
INSERT INTO nyu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pamaso pawentse, munthu ule adamuka, acitenga macira yace acicoka. Wanthu wentse adadabwa kwene-kwene, acipasa mbiri Mulungu acimbalewa: “Cipo bzimwebzi tikanati kubziwona”. ");
INSERT INTO nyu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jezu adayenda pomwe kugombe. Wanthu azinji adafika kumweko, ndipo Iye adawapfundzisa. ");
INSERT INTO nyu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pakufamba Jezu, adawona Levi, mwana wa Alifeu, akhadakhala pambuto ya basa la msonkho. Adamuuza aciti: “Iwe, unditewere”. Ndipo adamuka acimutewera. ");
INSERT INTO nyu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pomwe Jezu akhadya m'nyumba mwa Levi, pakhana wanthu azinji wakupimisa msonkho na wanthu wakuphonya. Akhadya na Jezuyo pabodzi na wakupfundzira wace. Thangwe akhalipo azinji wa iwo omwe akhatewera iye. ");
INSERT INTO nyu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pakhali amisiri wa Mtemo wa afalizi ndipo adawona kuti Jezu an'kudya na wanthu wakuphonya na wanthu wakupimisa msonkho, adabvundza wakupfundzira wace kuti: “Thangwe ranyi an'kudya pabodzi na wakupimisa msonkho na wanthu wakuphonya?” ");
INSERT INTO nyu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jezu adabva bzimwebzo adawatawira kuti: “Wanthu omwe mbakulimba an'nyangana lini mulapi. Wakuduwala ndiye an'nyangana mulapi! Ine ndiribe kubwera kudzacemera wanthu wakulungama, tsono ndabwera kudzacemera wakuphonya”. ");
INSERT INTO nyu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tsapano wakupfundzira wa Juwau M'batizi na afalizi akhabzimana kudya. Wanthu adabwera kwa Jezu acimbabvundza aciti: “Wakupfundzira wa Juwau na wakupfundzira wa afalizi ambabzimana kudya. Thangwe ranyi wakupfundzira wanu ambabzimana lini?” ");
INSERT INTO nyu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jezu adatawira: “Kodi andzace wa mwenekaciro msinda ya malowozi angasale kudya pomwe namwaliyo ali nawo? Bzingacitike lini! Iwo angasale lini kudya pomwe namwaliyo ali nawo. ");
INSERT INTO nyu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tsono in'dzafika nthawe yomwe an'dzawacosera namwaliyo. Nthawe imweyo an'dzabzimana kudya”. ");
INSERT INTO nyu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Palibe angasonere cakubvala ca kale na cigamba cipsa. Thangwe angacita tenepo, cigamba cire cimbanyothokera cicikuza mubo. Ndipo kung'ambika kwace kumbakhala kwakukulu kusiyana kale. ");
INSERT INTO nyu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ndipombo munthu angathire lini vinyu ipsa m'mabudu ya khanda la kale. Thangwe angacita tenepo, mabudu yambang'ambika, ndipo vinyu ire imbataika. Mabuduyo nkhumala basa. Tsono bzin'funika kuikha vinyu m'mabudu yapsa”. ");
INSERT INTO nyu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pantsiku inango ya malinkhuma, Jezu akhapita m'minda ya tirigu. Akhayenda tenepo, wakupfundzira wace adayamba kucosa ngala za tirigu acimbadya. ");
INSERT INTO nyu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pamwepo afalizi adabvundza Jezu kuti: “Thangwe ranyi wakupfundira wanu ali kucita bzomwe bzin'funika lini pantsiku ya malinkhuma?” ");
INSERT INTO nyu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iye adatawira: “Thangwe ranyi mun'cita ninga mulibe kuwerenga bzomwe adacita Davidi na andzace, pomwe akhana njala? ");
INSERT INTO nyu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Iye adapita m'nyumba ya Mulungu, panthawe yomwe Abiyatali akhali mkulu wa azibaba wa ntsembe, acikadya pau yakuperekedwa kwa Mulungu. Na tenepo pau imweyo ikhali yakuletsedwa kuti winango ali-wentse adye, kupambula azibaba wa ntsembe wokha. Tsono adagawirambo andzace wale omwe akhali naye”. ");
INSERT INTO nyu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ndipo Jezu pakupitiriza fala, adauza afalizi kuti: “Mulungu adaikha ntsiku ya malinkhuma kuti ikhale yakuthandiza wanthu. Alibe kulenga wanthu kuti akhale akapolo wa ntsiku ya malinkhuma. ");
INSERT INTO nyu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na tenepo Mwana-wa-Munthu ana mphambvu ngakhale kwa ntsiku ya malinkhuma”. ");
INSERT INTO nyu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jezu adapita pomwe m'nyumba ya mapembero. Momwemo mukhana munthu winango wakupunduka boko. ");
INSERT INTO nyu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wanthu winango akhanyangana thangwe ra kupasira mulandu Jezuyo, na tenepo akhanyang'anisa kuti aone angamulimbise munthuyo pantsiku ya kupuma. ");
INSERT INTO nyu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jezu adawuza munthu wakupundaka boko ule kuti: “Ima, bwera kutsogolo kuno”. ");
INSERT INTO nyu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ndipo adabvundza wanthu wale kuti: “Kodi pantsiku ya malikhuma cin'bvumizidwa n'ciponi? Kucita bzabwino, ayai kucita bzakuipa? Kupulumusa moyo wa munthu, ayai kuudzonga?” Wanthuwo adakhala zii. ");
INSERT INTO nyu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jezu pakuo kuti akhada wuma ndzelu m'tima wace udamuwawa, pakuwona kuti akhali wanthu wamakani tenepo, ndipo adawayang'ana na ukali. Ndipo adamuwuza munthuyo kuti: “Thamula boko lako”. Iye adalithamula, ndipo boko lacero lidakhalambo bwino. ");
INSERT INTO nyu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pamwepo afalizi wale adacoka adakagumanizana na wanthu wa phati ra Herodi, kuti apangane njira yakuphera Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jezu pabodzi na wakupfundzira wace adacoka pompale acienda kugombe la Galireya. Mthithi ukulu wa wanthu udamutewera. ");
INSERT INTO nyu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Wanthu wale akhali wa kuGalireya, winango wa kuJudeya na kuJerusalema, winango wa kuIdumeya, na wa ng'ambo wa kumkulo wa Jolodani, ndipombo kucipande ca kuTiro na Sidoni. Wentsenewo adafika kwa Iye, thangwe akhabva bzizinji bzomwe Iye akhacita. ");
INSERT INTO nyu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jezu adauza wakupfundzira wace kuti amuikire mwadiya pafupi, akha gopesa kuti wanthu angayambe kum'psinyiza, thangwe ukhali mthithi ukulu ");
INSERT INTO nyu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Na kuona kuti akhaciza wanthu azinji, ndipopo wentse omwe akhana matenda akhambagwinyana-gwinyana pakufuna kuti am'khuye. ");
INSERT INTO nyu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pomwe mizimu yakuipa ikamuwona ikhabzigwesa pantsi kutsogolo kwa Iye icimbakuwa kuti: “Imwe ndimwe Mwana wa Mulungu”. ");
INSERT INTO nyu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tsono Iye akhambailetsa mwa mphambvu kuti ileke kumuzimbula. ");
INSERT INTO nyu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jezu adakwira kuphiri, ndipo adacemera wanthu omwe Iye akhawafuna, iwo adayenda komwe kukhana Iye. ");
INSERT INTO nyu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Pamwepo adasankhula kumi na awiri, aciwacemera dzina la kuti: “Atumiki”. Adawauza kuti: “Ndasakhula imwe kuti mumbakhale na ine, ndin'dzakutumani kukalalika, ");
INSERT INTO nyu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","dicikupasani mphambvu yakuthotha mizimu yakuipa”. ");
INSERT INTO nyu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wanthu kumi na awiri omwe adasankhuliwa mbawa: Simau omwe Jezu adamucemera Pedru, ");
INSERT INTO nyu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiyago na m'bale wace Juwau, wana wa Zebedeu omwewo adawapasa dzina linango lakuti Aboanerje, bziri kulewa kuti “Wakugopswa ninga Wana wa Ciphaliwali”, ");
INSERT INTO nyu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andereya, Filipi, Bartolomeu, Mateu, Tomasi, Tiyago mwana wa Alifeu, Tadeu, Simau wa phathi landale la Azelote, ");
INSERT INTO nyu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ndipombo Judasi Isikaliyoti omwe adapereka Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pambuyo pace Jezu adaenda kunyumba, ndipo wanthu azinji adagumana pomwe, na tenepo Iye na wakupfundzira wace alibe kudzaone nthawe ya kuti adye. ");
INSERT INTO nyu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Abale wace na kubva bzimwebzi, adabwera kuti adzamutenge, thangwe iwo akhati: “Ali kucita nsala”. ");
INSERT INTO nyu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Amisiri winango wa Mtemo, omwe adabwera kucokera kuJerusalema, akhalewa kuti: “Munthu omweyu waphatidwa na Belezebu”. Akhalewa pomwe: “Mphambvu zomwe umweyu ambacosera mizimu yakuipa nzakucokera kwa mkulu wa mizimuyo”. ");
INSERT INTO nyu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Na tenepo Jezu adacemera wanthu kuti abwere pafupi, aciwauza na mifanilizo kuti: “Nandi Sathani angabzithothe yekha? ");
INSERT INTO nyu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wanthu wa muumambo uli-wentse angayamba kusandukirana, umambo umwewo bunipitiriza lini. ");
INSERT INTO nyu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ndipo pomwe wanthu wa mbanja libodzi angayamba kugawika, banja limwero limpitiriza lini. ");
INSERT INTO nyu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na tenepo penu muumambo wa Sathani ngwakusandukirana na kupambulana, na tenepoyo bwamala. ");
INSERT INTO nyu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Palibe omwe angakwanise kupita m'nyumba ya munthu wamphambvu acimubera bzinthu bzace akanati kum'manga. Na tenepo ambatoma kum'manga acimubera bwino. ");
INSERT INTO nyu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ncadidi ndiri kulewa kuti wanthu angakwanise kulekereredwa bzakuipa bzentse, napo bzakulewa bzawo bzentse bzicikhala bzakunyoza Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tsono ali-yentse wakunyoza Mzimu Wakucena, an'dzalekereredwa lini bzakuipa bzace bzimbakhala bza kuyenda na kuyenda thagwe ni kaidi wa bzakuipa bzakusaya kumala”. ");
INSERT INTO nyu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jezu adalewa bzimwebzi pakuwona kuti wanthu wale akhalewa kuti: “Waphatidwa na mzimu wakuipa”. ");
INSERT INTO nyu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mai na abale wace Jezu adabwera kumuiko. Adaima panja, adatuma wanthu kuti akamucemere. ");
INSERT INTO nyu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wanthu azinji akhadakhala acimuzungulira. Ndipo wale adamuuza kuti: “Mai wako na abale wako ali panjapa, ali kukucemera”. ");
INSERT INTO nyu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tsono Iye adati: “Mai wangu! Abale wangu! Waponi pomwe?” ");
INSERT INTO nyu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pamwepo adayang'ana wanthu wale omwe akhadakhala acimuzungulira aciti: “Ine mai wangu na abale wangu mbawa. ");
INSERT INTO nyu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ali-yentse omwe ancita bzomwe Mulungu an'funa, womwewo ndiwo am'bale wangu, na mai wangu”. ");
INSERT INTO nyu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jezu adayamba pomwe kupfundzisa mphephete mwa thawale la Galireya. Wanthu azinji adakatsonkhana naye, na tenepo Iye adapakira m'mwadiya, Wanthu wentse akhali kunja mphepete mwa thawalero, ");
INSERT INTO nyu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ndipo Jezu akhamba wapfundzisa bzizinji m'mifananizo. Pakuwapfundzisa adati, ");
INSERT INTO nyu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tetekerani! Munthu winango adayenda kukabzala, ");
INSERT INTO nyu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pakubzala mbeu ire inango idagwera munjira, ndipo mbalame zidabwera ziciidya. ");
INSERT INTO nyu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Inango idagwera pantsongolobwe, pomwe pakhalibe mataka mazinji. Idamera kankulumize, thangwe matakayo yakhalibe kufika pantsi. ");
INSERT INTO nyu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pomwe dzuwa lidakwira, idapsa iciuma, thangwe ikhalibe mizi ");
INSERT INTO nyu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","inango idagwera paminga, pakukula minga ire idapsinyiza mbeu, na tenepo iyo iribe kudzabereka ");
INSERT INTO nyu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ndipo mbeu inango idagwera pamataka yabwino. Idamera bwino icikula, ndipo icibereka. Inango ikhana bzisapo makumi matatu, inango makumi matanthatu, inango dzana”. ");
INSERT INTO nyu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ndipo Jezu adati: “Ule ana makutu yakubva, abve!” ");
INSERT INTO nyu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pomwe Jezu akhali payekha, wakupfundzira khumi na awiri wale pabodzi na anango omwe akhali pabodzi naye adamubvundza bza mifananizo ire ");
INSERT INTO nyu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iye adawatawira kuti: “Imwepo Mulungu adakuzimbulirani cintsintsi ca Umambo wace. Tsono anangowo omwe ali kunja, bzentse ambandobzibvera m'mifananizo yokha, ");
INSERT INTO nyu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kuti: “ ‘Kuyang'ana ayang'ane, tsono acisaya kuwona cinthu, ndipo kubva abve cadidi, tsono acisaya kubva cinthu, mwanjira inango, kuti angasandulike m'tima ndipo Mulungu angadzawalekerere!’” ");
INSERT INTO nyu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pambuyo pace Jezu adawabvundza kuti: “Penu imwe muli kubvesesa lini mfananizo uyu, mungabvesese tani mifananizo inango? ");
INSERT INTO nyu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wakubzala mbeu ule ni omwe ambabzala mafala ya Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mbeu zakugwera munjira zire bziri kulewa wanthu omwe ambabva mafala ya Mulungu. Tsono nthawe yomweyo Sathani ambabwera, acicosa mafala yale. ");
INSERT INTO nyu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mbeu zakubzalidwa pantsongolobwe zire bziri kulewa wanthu omwe ambabva mafala ya Mulungu, nthawe yomweyo acitambira na mpfatso. ");
INSERT INTO nyu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tsono thangwe kuti mafalayo yalibe mizi, wanthuwo ambakhala nthawe ing'ono-ng'ono yokha. Ingandofika mphica ayai matsautso thangwe ra mafala yale, nthawe yomweyo wanthuwo ambabwerera m'mbuyo. ");
INSERT INTO nyu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mbeu zakubzalidwa paminga zire bziri kulewa wanthu omwe ambabva mafala ya Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tsono kufuna-funa bza pantsi-pano, kufunisisa nthaka na kusirira bzinthu bzinango bzizinji bzimbapitambo nkhusayisa mphambvu mafala yale, na tenepo yambadzabereka lini bzisapo. ");
INSERT INTO nyu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ndipo mbeu zakubzalidwa pamataka yabwino bziri kulewa wanthu omwe wambabva mafala ya Mulungu, aciyatambira. Acibereka bzisapo, yinango makumi matatu, yinango makumi matanthatu, yinango dzana”. ");
INSERT INTO nyu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tsono Jezu adawabvundza kuti: “Kodi wanthu ambatenga lampalina acigwanankira na mtsuko, ayai kuibisa mfunfuntsi mwa talimba? Ambaikha lini padeca? ");
INSERT INTO nyu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na tenepo ciri-centse cakubisika cin'dzaoneka, pomwe ciri-centse ca kabise-bise bzin'dzazimbuka padeca. ");
INSERT INTO nyu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Omwe ana makutu yakubva, abve!” ");
INSERT INTO nyu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Adawauza pomwe kuti: “Mumbakhale na tcero na mafala yomwe mumbabva. Maphatidwe uncita winango Mulungu an'dzaphatisambo basa cibodzibodzico pakuweruzambo imwepo, na tenepo kwa imwepo an'dzathimizira. ");
INSERT INTO nyu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pamwepo omwe ana cinthu kale, an'dzamuthimizira cinango. Tsono omwe alibe cinthu, cing'ono comwe anaco an'dzamutengera basi”. ");
INSERT INTO nyu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jezu adalewa pomwe kuti: “Umambo bwa Mulungu tingandendemeze na munthu wakubzala mbeu m'munda. ");
INSERT INTO nyu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Omwe ambandogona usiku na masikati, nthawe yentseneyo mbeu yomwe adabzala ire idamera icikula, mwenekaciroyo ne kudziwa momwe bziri kucitikira. ");
INSERT INTO nyu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pamwepo mataka yambaberekesa pomwe mbeu ire yokha-yokha. Ambayamba ni nyakamera, zicibwera ngala-ngala, pambuyo pace bzisapo mungala-ngala mule bzimbakhuma. ");
INSERT INTO nyu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tsono bzisapo bzingacena, munthu ule ambatenga cisu nkhumbagwata, thangwe nthawe yakubvuna yakwana”. ");
INSERT INTO nyu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jezu adabvunza pomwe: “Kodi Umambo bwa Mulungu tingaundendemeze na ciyani? Ayai tiufananize na ciyani? ");
INSERT INTO nyu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Udakhala ninga njere ya m'towe. Ingabzaliwa njing'ono kwene-kwene kuposa njere zinango pantsi pano. ");
INSERT INTO nyu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tsono akaibzala, imbamera, njere ire icikula kuposa miti inango iri yentse. Icicita mithawi mikulu-mikulu, na tenepo mbalame zimbakwanisa kumanga bzitsa munthundzi wace”. ");
INSERT INTO nyu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jezu akhalewa nawo na mifananizo mizinji ninga imwei, pakundendemeza na ndzeru za wanthuwo. ");
INSERT INTO nyu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Akhalewa lini acisaya kuwapasa mifananizo. Tsono akhati akakhala payekha na wakupfundzira wace, akhambawafokotozera bzentse. ");
INSERT INTO nyu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ntsiku imwe ire, kumaulo kwace, Jezu adauza wakupfundzira wace kuti: “Mbatiyendeni tiyambuke, tiyende ng'ambu ire”. ");
INSERT INTO nyu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ndipo iwo adagoneka mbumba ire acitenga mwadiya omwe iye akhali. Miyadiya inango ikhaenda naye pabodzi ");
INSERT INTO nyu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tsono padadzayamba condzi camphambvu. Mabimbi yakhayamba kupita m'mwadiyamo, na tenepo udayamba kudzala na madzi. ");
INSERT INTO nyu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tsono nthawe yomweyo Jezu akhali mambuyo mwa mwadiyamo, akhadagona acitsamira mtsago. Pamwepo wakupfundzira wale adam'musa, aciti: “Misiri, tinifa mulibe thupo?” ");
INSERT INTO nyu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jezu adamuka, ndipo adalewa kwa mphepoyo, acilamula mabimbi kuti: “Derekha! Khala zii!” Mphepo ire idaleka cadidi, ndipo padadzakhala ziiii ");
INSERT INTO nyu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pamwepo Jezu adawabvundza kuti: “Thangwe ranyi muna mantha? Kodi imwepo mundikhulupilira lini?” ");
INSERT INTO nyu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tsono iwo adakhala na mantha kwene-kwene, acimbabvundzana: “Kodi Umweyu ni munthu wanyi womweyu wakuti condzi na mabimbi bzimbamubvera?” ");
INSERT INTO nyu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jezu na wakupfundzira wace adafika ng'ambu ya Thawale la Galireya, mbali ya Gerasa. ");
INSERT INTO nyu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pomwe iye adandocoka m'mwadiya, padabwera munthu winango wakuphatidwa na mzimu wakuipa acicokera kuthenje. ");
INSERT INTO nyu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Munthuyo akhambakhala kuthenjeko, ndipo pakhalibe winango wakuti angadakwanisa kum'manga, napo na unyolo ");
INSERT INTO nyu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","kazinji wanthu akhamba m'manga miyendo na waya, ndipombo kum'manga manja na cingwe, tsono iye akhambabwedza unyolo bule, ndipo waya zakumanga miyendozo akhambagwata. Pakhalibe na m'bodziyo omwe akhakwanisa kumukunda. ");
INSERT INTO nyu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Masikati na usiku akhambakhala kuthenjeko na m'mapiri, acimbandokuwa na kubzipweteka na minyala. ");
INSERT INTO nyu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pomwe iye adaona Jezu na kutali, adam'thamangira acigodama kutsogolo kwace. ");
INSERT INTO nyu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Adakuwa aciti: “Kodi ndakuputani ciyani, imwe Jezu Mwana wa Mulungu Wakudzulu-dzulu? Na dzina la Mulungu ndiri kukumbirani, lekani kundiboneresa”. ");
INSERT INTO nyu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Akhalewa terepo thangwe Jezu akhadalewa kuti: “Mzimu wakuipawe, coka mwa munthuyu!” ");
INSERT INTO nyu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tsono Jezu adamubvundza munthuyo “Dzina lako ndiwe yani?” Iye adatawira kuti: “Dzina langu ndine ‘Mthithi’, tiripo azinji”. ");
INSERT INTO nyu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ndipo adamukumbira Jezu kuti aleke kuicosa kunja kwa mbali ire. ");
INSERT INTO nyu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pafupi na pamwepo pakhana kamtunthu komwe kakhana mthithi wa nkhumba, zikhadya ");
INSERT INTO nyu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tsono mizimu yakuipa ire idakumbira Jezu iciti: “Titumireni tipite munkhumba zire”. ");
INSERT INTO nyu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jezu adaibvumiza. Iyo idacoka icipita mwa nkhumbazo. Pamwepo mthithi ule wa nkhumba zomwe zikhakwana bzulu bziwiri zentsenezo zidaguduka zicipolika na kuthamanga zicikabzithusa mthawale, mpaka kufa mwemo. ");
INSERT INTO nyu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Amakabusa wazene adathawa, acikauza wanthu mumzinda na mii. Pamwepo wanthu wale adacoka kuti akaone bzomwe bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Atafika komwe kukhana Jezu, adaona munthu akhana mizimu yakuipa ule akhadakhala pantsi, akhadabvala, msala ule ukhadamala, Wanthuwo akhabva mantha. ");
INSERT INTO nyu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Omwe adaona bzentse wale, adawafotokozera bzomwe bzidacitika kwa munthu ule na kwa nkhumba zire. ");
INSERT INTO nyu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pamwepo wanthuwo adamuuza mwakumkakamiza Jezu kuti achoke kumphimpha yawo ire. ");
INSERT INTO nyu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pomwe Jezu akhapita m'mwadiya, munthu omwe akhana mizimu yakuipa ule adakumbira kuti aende nawo. ");
INSERT INTO nyu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tsono Jezu adalamba acimuuza kuti: “Iwe ndoko kumui kwanu ukalewe bzomwe Mbuya akucitira na ntsisi zace”. ");
INSERT INTO nyu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Munthuyo adaenda cadidi aciyamba kumwaza mafala kumbuto zentse za mizinda khumi bzire bzomwe Jezu adam'citira. Pakubva bzimwebzo wanthu wentse adadabwa. ");
INSERT INTO nyu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","pomwe Jezu adabwerera ng'ambu ire na mwadiya, atafika mthithi wa wanthu udagumana mphepete mwa thawale pomwe pakhana iye. ");
INSERT INTO nyu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Padadzafika munthu winango, dzina lace Jaire, omwe akhali m'bodzi wa akulu wa nyumba ya mapembero, ndipo iye adaona Jezu, adagodama m'minyendo mwace, ");
INSERT INTO nyu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","acimudandaulira kwene-kwene: Aciti: “Ndaphata minyendo, mwana wangu wamkazi ali pafupi kufa. Penu mungakwanise kukam'sanzika manja kuti alimbe acikhala na moyo”. ");
INSERT INTO nyu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jezu adayenda naye, Wanthu azinji adam'tewera akhambayenda mwa kum'psinyiza. ");
INSERT INTO nyu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tsono pakhana mkazi winango omwe akhambabonera na matenda yakucoka mulopa kwa magole khumi na mawiri. ");
INSERT INTO nyu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iye akhadayezerewa na alapi azinji, na tenepo akhadadzonga bzentse bzomwe akhanabzo tsono akhalimba lini ndipo dzikhalemwa ");
INSERT INTO nyu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mkaziyo pakubva mbiri ya Jezu, adayenda pamthithi wa wanthu ule, acipapatiza mpaka kukafika na kumbuyo kwa Jezu, acikamkhuya cakubvala cace. ");
INSERT INTO nyu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Thangwe akhambakumbuka tenepa: “Ningandokukhuya bzakubvala bzace bzokha, ninilimba”. ");
INSERT INTO nyu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ncadidi nthawe yomweyo matenda yace yadamala, mwenekaciroyo adabva mthupi mwace kuti walimba. ");
INSERT INTO nyu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pamwepo Jezu adabva kuti mphambvu zinango zacoka. Ndipo adazungunuka aciyang'ana wanthu wale aciwabvundza kuti: “Kodi mbani wandikhuya bzakubvala bzangu?” ");
INSERT INTO nyu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wakupfundzira wace adamutawira: “Mwekha muli kuwona kuti wanthu ali kukupsinyizani, ncadidi mungabvundze kuti: ‘Mbani wandikhuya?’ ” ");
INSERT INTO nyu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tsono Jezu adayang'ana-yang'ana m'mphepete kuti aone omwe wacita bzomwe bzire. ");
INSERT INTO nyu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na tenepo mkazi ule adabva mantha aciyamba kutetemera, thangwe akhadziwa bzomwe bzikhadacitika kwa iye. Adabwera pafupi, acidzigwesera kutsogolo kwa Jezu, acimufokotozera bzentse mwa cadidi. ");
INSERT INTO nyu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jezu adamuuza kuti: “Mwana wangu, cikhulupiriro cako cakulimbisa. Ndoko na mtendere. Watsudzuka kwa matenda yako”. ");
INSERT INTO nyu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pomwe Jezu akhalewa-lewa, kudafika wanthu kucokera kunyumba kwa mkulu ule wa nyumba ya mapembero. Kudzamuuza kuti: “Mwana wafa. Thangwe lanyi mulikuwanesa pomwe Misiriwa”. ");
INSERT INTO nyu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tsono Jezu alibe kubziphatisa basa bzomwe akhalewa wanthuwo. Iye adamuuza mkulu ule kuti: “Leka kugopa, iwe kukhulupirira basi”. ");
INSERT INTO nyu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ndipo alibe kubvumiza kuti winango amutewere iye, kupambula Pedru, na Tiyago, na Juwau, m'bale wa Tiyagoyo. ");
INSERT INTO nyu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pomwe iwo adafika kunyumba kwa mkulu ule wa nyumba yamapemphero Jezu adaona phiringo la wanthu omwe, ali akhalira acimbakuwa. ");
INSERT INTO nyu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iye adapita, aciwabvundza kuti: “Thangwe ranyi muli kucita phiringu na kukuwa Mwanayu alibe kufa adandogona”. ");
INSERT INTO nyu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pamwepo wanthuwo adayamba kumuseka. Iye adawacosa panja wentse, acitenga baba na mai wa mwanayo, na omwe akhali naye wale, acipita kucipinda kukhana mwana ule. ");
INSERT INTO nyu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ndipo adaphata boko la mwanayo acimuuza kuti: “Talita, kumi”. (Ndiko kulewa kuti: “Mtsikanawe, ndiri kukuuza kuti muka”.) ");
INSERT INTO nyu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mthawe ibodzi-bodziyo mtsikanayo adamukadi, aciyamba kufamba. Iye akhana magole khumi na mawiri. Pamwepo wanthu wale adadabwa kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tsono Jezu adawalamula mwa mphambvu kuti bzimwebzi winango ali-yentse aleke kubzidziwa. Aciwauza kuti am'pase cakudya mtsikana ule. ");
INSERT INTO nyu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jezu adacoka kumweko, acikafika kumui kwace pabodzi na wakupfundzira wace. ");
INSERT INTO nyu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pomwe idafika ntsiku ya malinkhuma, Iye adayamba kupfundzisa m'nyumba ya mapembero. Wanthu azinji omwe akhamutetekera adadabwa kwene-kwene acimbalewa kuti: “Kodi mamuna umweyu adabzipfunzdira kuponi bzentsenebzi? Udziwi bumwebu adabuwona kuponi? An'kwanisa tani kucita bzidabwiso tenepayu? ");
INSERT INTO nyu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kodi omweyu ndiye lini misiri wa matabwa ule, mwana wa Maliya? Kodi abale wace ndiwo lini Tiyago, na Zuze, na Judasi, na Simau? Ndiye lini omwe ana mfuma-kazi tinazozi?” Na tenepo alibe kufuna kudzadziwa pomwe bza iye. ");
INSERT INTO nyu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tsono Jezu adawauza kuti: “Mpolofiti ambalemekezedwa kumbuto zinango, kupambula kumui kwawo, pakati pa abale wace, ndipombo kunyumba kwawo”. ");
INSERT INTO nyu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na tenepo angadacita lini bzidabwiso kumweko. Adandosanzika manja kwa wakuduwala ang'ono-ng'ono, aciwalimbisa. ");
INSERT INTO nyu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pamwepo iye adadabwa pakuwona kuti wanthu wakumweko alibe kukhulupirira. Pambuyo pace Jezu adayenda kumii ya m'mphepete, acimbapfundzisa wanthu. ");
INSERT INTO nyu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jezu adacemera wakupfundzira wace khumi na awiri aciwatuma awiri-awiri. Aciwapasa mphambvu yakucosera mizimu yakuipa ");
INSERT INTO nyu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Aciwalamula kuti: “Pakuenda lekani kutenga cinthu ciri-centse, kupambula mpsimbo yokha. Lekani kutenga cakudya, ayai gumbu lakufamba nalo, ayai kobiri mukabudu. ");
INSERT INTO nyu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mubvale xango zokha, tsono lekani kunyamula bzakubvala bziwiri”. ");
INSERT INTO nyu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Adawauza pomwe kuti: “Mungafika pamui, mucitambiriwa khalani pamwepo, mpaka nthawe yanu yakucoka ikwane ");
INSERT INTO nyu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Penu kumbuto kwinango wanthu an'kutambirani lini, acilamba kubva mafala yanu, pakucoka kwanu mukunkhumule pfumbi la minyendo yanu. Cimweci cin'dzakhala cizindikiro cakuti ana mulandu”. ");
INSERT INTO nyu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tsono wakupfundzira wale adayenda, acimbalalikira wanthu kuti asandulike m'tima. ");
INSERT INTO nyu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Akhacosa mizimu yakuipa mizinji, ndipombo acimbadzoza mafuta wanthu wakudwala azinji acimbawalimbisa. ");
INSERT INTO nyu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mambo Herodi akhadabzibva bzimwebzi, thangwe mbiri ya Jezu likhadabveka kwentse-kwentse. Wanthu winango akhati: “Juwau M'batizi adamuka kwa wakufa, ndipopa ali kucita bzidabwiso bzentsenebzi”. ");
INSERT INTO nyu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tsono winango akhati: “Ayai, omweyu ni Eriya”. Winango akhati: “Uyu ni mpolofiti ninga m'bodzi wa apolofiti wakale”. ");
INSERT INTO nyu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pomwe Herodi adabva bzomwebzo, adati: “Adamuka kwa wakufa ule, ni Juwau omwe ndidagwata khosi”. ");
INSERT INTO nyu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Thangwe Herodiyo kale adatuma acikunda wace kuti akam'phate Juwau, akam'mange acithusa m'kaidi. Adacita bzimwebzire thangwe ra Herodiyasi, mkazi wa Filipi, m'bale wace. Na kuti Herodi akhadamulowola mkaziyo. ");
INSERT INTO nyu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ndipo Juwau akhambamuuza kuti: “Nkhuponya Mtemo kupsokhonyola mkazi wa m'bale wanu”. ");
INSERT INTO nyu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ndipo Herodiyasi akhambawenga Juwau, na tenepopo akhafuna kuti amuphe. Tsono akhataza, ");
INSERT INTO nyu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","thangwe Herodi akhambamgopa Juwau, pakudziwa kuti akhali munthu wakulungama acilungama. Ndipopo akhamkoya bwino. Akhafuna kumbabva mafala yace, ngakhale kuti akumubva tenepo, akhamala ndzeru naye. ");
INSERT INTO nyu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tsono pantsiku yakukondwerera kubadwa kwa Herodi, Herodiyasi adawona mphata. Herodi ule adakondza uzokoto, acicemera akulu-akulu wa boma, na akulu wakutonga acikunda, na atongi wa kuGalireya. ");
INSERT INTO nyu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ndipo mwana wacikazi wa Herodiyasi adapita, aciyamba kubzina. Herodi na wakucemeredwa wale adakomedwa kwene-kwene na kubzina kule. Pamwepo mambo adauza mtsikana ule kuti: “Undikumbire ciri-centse comwe un'funa, ine ninkupasa”. ");
INSERT INTO nyu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na tenepo adalumbira aciti: “Ciri-centse comwe undikumbira, ninkupasa, ngakhale cipande ca umambo bwangu”. ");
INSERT INTO nyu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mtsikanayo adacoka acikabvundza mai wace kuti: “Kodi ndikakumbire ciyani?” Mai wace adati “Kakumbire msolo wa Juwau M'batizi”. ");
INSERT INTO nyu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ndipo Mtsikana ule adabwerera mwa kankulumize kwa mambo acimuuza kuti: “Nin'funa kuti tsapanopa mundipase msolo wa Juwau M'batizi mu mbale” ");
INSERT INTO nyu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na tenepo mambo Herodi adabva ntsisi kwene-kwene. Tsono thangwe ra kulumbira komwe akhadacita patsogolo pa wakucemeredwa, mambo akhafuna lini kupfudza cipangano comwe adacita na mtsikana ule. ");
INSERT INTO nyu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mwakamkulumize adatuma m'bodzi wa acikunda wace, kuti abwerese msolo wa Juwau. Mcikunda ule adayenda kukaidi, acikagwata msolo wa Juwau. ");
INSERT INTO nyu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Adauikha m'phande acidzaupereka kwa mtsikana ule, mtsikanayo nkhukauperekambo kwa mai wace. ");
INSERT INTO nyu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wakupfundzira wa Juwau pomwe adabva bzimwebzo, adabwera acidzatenga nkhawa ire acikapendesa mucigwindza kuthenje. ");
INSERT INTO nyu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Atumiki adabwerera kwa Jezu acimufotokozera bzentse bzomwe adacita na kupfundzisidwa. ");
INSERT INTO nyu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jezu adawauza kuti “Mbatiyendeni kumbuto imbapita lini wanthu, kuti mukapume pang'ono”. Adalewa terepo thangwe wanthu akhali nyalu-nyalu, nakuti iwo akhalibe m'pata wa kuti angadakwanisa kudya ");
INSERT INTO nyu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","cadidi iwo adapita m'mwadiya acienda okha kumbuto komwe kukhalibe wanthu ");
INSERT INTO nyu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tsono wanthu azinji adawaona pakucoka, aciwazindikira. Na tenepo adathamanga na n'gambo ire kucokera kumizinda yentse, acitoma kufika, Jezu na wakupfundzira wace wale akhanati kufika. ");
INSERT INTO nyu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pamwe Jezu adacoka m'mwadiya, adaona mthithi ukulu wa wanthu. Adawabvera ntsisi, thangwe akhali ninga mabira yakusaya makabusa, na tenepo adayamba kuwapfundzisa bzizinji. ");
INSERT INTO nyu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nthawe ya kumaulo wakupfundzira wace adadzamuuza kuti: “Kuno nkhuthengo, ndipo kwadoka ");
INSERT INTO nyu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Auzeni wanthuwa ayende, akadye m'mii yomwe iri pafupiyi kuti akagule cakudya”. ");
INSERT INTO nyu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tsono Jezu adawauza kuti: “Imwepo apaseni cakudya”. Iwo adati: “Tsono kuti wakwane wanthuwa, pafunika kuti tikagule pau ya kobiri za parata zikwanira madzana mawiri kuti tidzawadyese wentsewa!” ");
INSERT INTO nyu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Na tenepo Jezu adawabvundza kuti: “Muna pau zingasi? Ndokoni mukaone”. Adayenda kukaona ndipo adati: “Ziripo pau zixanu na ntsomba ziwiri”. ");
INSERT INTO nyu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ndipo Jezu adawawuza kuti, wentse akhale pantsi kabungwe-kabungwe pakapinga. ");
INSERT INTO nyu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Cadidi wanthu wale adakhala pantsi, bungwe linango wanthu dzana, linango wanthu makumi maxanu. ");
INSERT INTO nyu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jezu adatenga pau zixanu zire na ntsomba ziwiri zire, aciyang'ana kudzulu, acitenda Mulungu. Tsapano adayamba kugwata-gwata pau zire, na ntsomba ziwiri acinyedza-nyedza acipereka kwa wakupfundzira wace kuti wagawire wanthu wale. ");
INSERT INTO nyu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wanthu wentse adadya mpaka kukhuta. ");
INSERT INTO nyu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pambuyo pace wakupfundzira wale adatenga pau zakusala na ntsomba zire acidzaza madengu khumi na mawiri. ");
INSERT INTO nyu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wanthu omwe adadya pau zire kuwerenga amuna okha akhakwana bzulu bzixanu. ");
INSERT INTO nyu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Atandomala, Jezu adawauza wakupfundzira wace kuti apite m'mwadiya, atsogole kuyenda ng'ambu ire ya Betisaida. Iye akhambagonekambo mthiti ule wa wanthu kuti ayende kwawo. ");
INSERT INTO nyu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pomwe adagonekana nawo, adakwira kuphiri kukapembera. ");
INSERT INTO nyu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pomwe kukhayamba kudoka, mwadiya ule ukhali pakati-na-kati ya nyandza, Jezu akhali yekha kunja. ");
INSERT INTO nyu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ndipo adawona wakupfundzira wale akhacapa mwakuneseka, thangwe akhayenda kukhacokera condzi. Imweyo ikhali nthawe ya madandakweca, Jezu adafamba padzulu pa madzi aciyenda kuna iwo acicita ninga an'funa kuwapitirira. ");
INSERT INTO nyu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tsono wakupfundzira wale, pakumuwona acifamba padzulu pa madzi, adakumbuka kuti nciphoko, adayamba kukuwa, ");
INSERT INTO nyu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","nakuti wentse pakumuona adakhala na mantha. Tsono nthawe yomweyo Jezu adawauza kuti: “Limbikani m'tima ndine, lekani kugopa”. ");
INSERT INTO nyu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pamwepo iye adapita m'mwadiya momwe iwo akhali, ndipo condzi cidaleka. Iwo adamalidwa ndzeru ");
INSERT INTO nyu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","thangwe alibe kubvesesa bwino bza kutupisidwa kwa pau zire, thangwe akhalibe nabzo thupo. ");
INSERT INTO nyu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jezu na wakupfundzira wace adayambuka gombe, acifika kuGenezarete, acitsamisa mwadiya pagombe. ");
INSERT INTO nyu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pomwe iwo adandocoka m'mwadiya, mbumba idamuzindikira Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Adathamangira kumbuto zentse za mbali ire, aciyamba kumbabwera na wanthu wakuduwala pamacira, kumbuto komwe akhabva kuti Jezu ali uku. ");
INSERT INTO nyu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kuli-kwentse komwe Jezu akhayenda, kumii na kumizinda, wanthu akhadzakhazika wakudwala m'misika. Acimukumbira kuti abvumize wakuduwalayo kuphata ayai kondomukhuya bzakubvala bzace. Nakuti wentse omwe akhakhuya, akhalimba. ");
INSERT INTO nyu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","afalizi winango pabodzi na adziwi winango wa Mtemo, omwe adacokera kuJerusalema, adasonkhana m'uphepete mwa Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Iwo adawona kuti wakupfundzira wace winango akhambadya cakudya na m'manja mwakuswipa (ndiye kuti akhalibe kuteweza Mtemo wa kusamba m'manja ninga momwe afalizi akhadayiwuza mbumba kuti yicite.) ");
INSERT INTO nyu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Thangwe afalizi na Ajuda wentse ambadya lini alibe kusamba m'manja na tcero, kuti akoye Mtemo wa makolo. ");
INSERT INTO nyu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ndipo angacoka kumsika, ambadya lini wakanati kubzitsuka bzetse bzomwe wabweranabzo. Ambakoya pomwe mitemo inango mizinji yomwe makolo yawo yadawasiyira, ninga kutsuka mikhombo, bzikhalango, na bzikasi bza mkuwa na talimba. ");
INSERT INTO nyu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Na tenepo afalizi na amisiri wa Mtemo wale adabvundza Jezu kuti: “Thangwe ranyi wakupfundzira wanu ambakoya lini Mtemo wa makolo, tsono ambandodya napo alibe kusamba m'manja?” ");
INSERT INTO nyu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jezu adawatawira kuti: “Imwe wanthu wacipha-maso, ncadidi bzomwe mpolofiti Izaiya adalewa pacipande ca imwe, iye adanemba kuti: “ ‘Mbumba imweyi imbandilemekeza na miromo, tsono mitima yawo iri kutali na Ine. ");
INSERT INTO nyu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ambandipemba mwakusaya basa, pakuti ambapfundzisa mitemo yakucokera kwa wanthu, ninga ni yangu’. ");
INSERT INTO nyu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jezu adapitiriza: ‘Imwe mumbasiya Mtemo wa Mulungu, mucimbakoya mitemo ya wanthu’ ”. ");
INSERT INTO nyu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tsono pakupitiriza mafala, Jezu adati: “Tsono imwe muna njira yanu yakucenjera yakusiyira Mtemo wa Mulungu kuti mukoye mitemo yanu. ");
INSERT INTO nyu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nakuti Mozeji adalewa kuti: ‘Lemekeza Baba wako na mai wako,’ ndipombo kuti: ‘Wakunyoza Baba wace ayai mai wace, bzin'funika kuti aphedwe.’ ");
INSERT INTO nyu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tsono imwe mumbati: ‘Munthu akawuza Baba wace ayai mai wace kuti: “Bzomwe ndingadakuthandizani nabzo ndabzipereka kuna Mulungu”, ");
INSERT INTO nyu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","umweyo anfunika lini pomwe kuwathandiza Baba wace na mai wace.’ ");
INSERT INTO nyu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na tenepo mafala ya Mulungu imwe mumbayasandusa yapezi, thangwe ra Mtemo wanu omwe mumbasiyirana. Ndipo mumbacita bzinango bzizinji tenepayu”. ");
INSERT INTO nyu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pambuyo pace Jezu adacemera pomwe mthithi wa wanthu ule kuti ubwere, aciti: “Tetekerani mwentsenemwe, ndipo mubvesese. ");
INSERT INTO nyu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bzentse bzomwe bzin'coka kunja bzicipita mkati mwa munthu bzinimuswipisa lini. Tsono bzomwe bzimbacoka mwa iye ndibzo bzinimuswipisa”. ");
INSERT INTO nyu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“Omwe ana makutu yakubva, abve!” ");
INSERT INTO nyu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pomwe Jezu adasiya mthithi ule wa wanthu acipita m'nyumba, wakupfundzira wace adamubvundza bza mfananizo ule. ");
INSERT INTO nyu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iye adati: “Kodi na imwembo mulikukhala ninga wanango wale, muli kubvesesa lini? Kodi muli kudziwa lini kuti bzetse bzakucokera kunja, na kupita mwa munthu, bzin'kwanisa lini kumuswipisa? ");
INSERT INTO nyu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Thangwe bzin'pita lini mum'tima mwace, tsono m'mimba, pambuyo pace nkhukabzitaya kuthengo”. (Pakulewa bzimwebzi, Jezu adalamulira kuti bzakudya bzentse wanthu angakwanise kudya.) ");
INSERT INTO nyu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Adati pomwe: “Bzomwe dzimbaswipisa munthu nidzire bzincoka m'tima mwace. ");
INSERT INTO nyu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Thangwe mkati mwa mitima wa wanthu ndimo mumbacoka ndzeru zakuipa, za ciwerewere, za kuba, za kuphana, ");
INSERT INTO nyu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","upombo, kusirira, kuipa m'tima, cinyengo, bzakunyantsa, kuipidwa, kunyoza, kubzikuza, ndipombo kupusa. ");
INSERT INTO nyu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bzakuipa bzentsenebzi bzimbacokera mkati mwa munthu, ndipo ndibzo bzimbamuswipisa”. ");
INSERT INTO nyu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jezu adanyamuka komweko aciyenda kumphimpha ya kuTiro. Adapita munyumba inango, ndipo akhafuna lini kuti wanthu wadziwe kuti iye ali kumweko. Tsono alibe kukwanisa kubisika, ");
INSERT INTO nyu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nakuti mkazi winango, omwe mwana wace wacikazi akhabonera na m'zimu wakuipa, adabva bza Iye. Adabwera kwa Jezu acigodama kuminyendo kwace. ");
INSERT INTO nyu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mkaziyo akhali wakunja, wa dziko la Siro-Fenisiya. Adakumbira Jezu kuti akacose mzimu wakuipa kwa mwana wace. ");
INSERT INTO nyu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tsono Jezu adamutawira kuti: “Ayai, alekeni wana atome adya acikhuta. Mpsabwino lini kutenga cakudya ca wana nkhuthusira tuntsidza”. ");
INSERT INTO nyu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pamwepo mkazi ule adati: “Ncadidi, Mbuya, tsono tuntsidza tumbakhala pafupi na mbuto yakudyera tucimbadya tumisuwa tomwe wana ambataya”. ");
INSERT INTO nyu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pamwepo Jezu adamuuza kuti: “Thangwe la matawiridwe yako, ndoko, mzimu wakuipa wacoka mwa mwana wako”. ");
INSERT INTO nyu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Pomwe mkazi ule adabwerera kunyumba kwace, adakawona mwana ule adagona patalimba, mzimu wakuipa ule wacoka. ");
INSERT INTO nyu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jezu adacoka pomwe kumphimpha ire ya kuTiro, acipita na kuSidoni, kuyenda kuthawale la kuGalireya, adapita na pakati pa Mizinda Khumi. ");
INSERT INTO nyu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wanthu winango adamubweresera munthu omwe akhali mkhutwi na ubewewe. Wanthuwo adakumbira Jezu kuti amulimbise pakumsandzika manja munthu ule. ");
INSERT INTO nyu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jezu adamucosa munthu ule pa mthithi wa wanthu acienda naye pambali. Adapitisa bzala m'makutu mwace, acipsipa mata, nkhukuya lirime lace munthu ule. ");
INSERT INTO nyu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Iye adanyang'ana kudzulu, acisisimira, acimuwuza kuti: “Efata!” Ndiko kulewa kuti: “Funguka!” ");
INSERT INTO nyu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Makutu ya munthu ule adafunguka, pamwepo lirime lace lidatsudzuka, aciyamba kulewa-lewa bwino ");
INSERT INTO nyu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jezu adalumurira andzace wa munthu ule kuti: “Lekani kukawuza winango ali-yentse bzimwebzi”. Tsono napo iye akhadawaletsa, iwo adayenda acibzizimbula kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ndipo wanthu wentse omwe akhabzibva akhadabwa kwene-kwene, aciti: “Omweyu ambacita bzentse mbzabwino. Ngakhale mkhutwi ambazilimbisa zicibva, pomwe wakusaya kulewa-lewa ambawacitisa kuti walewe-lewe”. ");
INSERT INTO nyu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ntsiku inango, mthithi ukulu wa wanthu udagumana pomwe. Na kuwona kuti palibe cakudya, Jezu adacemera wakupfundzira wace aciwawuza kuti, ");
INSERT INTO nyu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ndiri kuwabvera ntsisi wanthuwa, thangwe akhala nande ntsiku zitatu ndipo alibe cakudya. ");
INSERT INTO nyu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ningawabweza kwawo na njala tenepa, an'dzakomoka panjira, thangwe winango acokera kutali”. ");
INSERT INTO nyu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wakupfundzira wace adamubvundza kuti: “Wanthu azinji terepayu munthu angawanyang'anire tani cakudya cakukwanira, munthuku muno?” ");
INSERT INTO nyu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jezu adawabvundza kuti: “Muna pau zingasi?” Iwo adatawira: “Zinomwe”. ");
INSERT INTO nyu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pamwepo Jezu adauza mbumba ire kuti ikhale pantsi. Pambuyo pace adatenga pau zinomwe zire, acitenda Mulungu, adaigwatagwata aciipereka kwa wakupfundzira wace kuti agawire mbumba ire. Wakupfundzira wale adaigawira mbumba ire. ");
INSERT INTO nyu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Akhana tuntsomba pomwe tung'ono-ng'ono. Jezu adatenda Mulungu, acilamula wakupfundzira wace kuti agawire mbumba ire. ");
INSERT INTO nyu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wentse adadya acikhuta. Adakonkhobza bzakusala, acidzaza bzitundu bzinomwe. ");
INSERT INTO nyu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wanthu omwe akhali pamwepo, amuna okha akhali pafupi-fupi bzulu bzinai. Jezu adadzauza mbumba kuti iyende. ");
INSERT INTO nyu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pambuyo pace Iye na wakupfundzira wace adapita m'mwadiya aciyenda kumphimpha ya Dalamanuta. ");
INSERT INTO nyu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ndipo afalizi adayenda kuna Jezu, kukatsutsana naye. Iwo adamukumbira kuti awawonese cizindikiro cakudabwisa cakucokera kudzulu. Akhandofuna kumuteyera msampha basi. ");
INSERT INTO nyu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jezu adasisimira mum'tima aciti: “Thangwe ranyi wanthu wa tsapano lino wambafuna kuwona cizindikiro cakudabwisa? Ncadidi ndiri kulewa kuti palibe cizindikiro cidza citika kwa mbumba iyi”. ");
INSERT INTO nyu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na tenepo, adawasiya, acipita pomwe m'mwadiya aciyambuka ng'ambu ire. ");
INSERT INTO nyu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pakucoka wakupfundzira wa Jezu akhadayebwa kutenga pau, tsono m'mwadiyamo akhana pau ibodzi yokha. ");
INSERT INTO nyu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ndipo Jezu adawabebesa aciti: “Bvesesani mucenjere na cakutupisa ca afalizi na ca Herodi”. ");
INSERT INTO nyu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pamwepo wakupfundzira wale adayamba kutsutsana acimbati: “Ali kulewa bzimwebzi thangwe tiribe pau”. ");
INSERT INTO nyu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jezu adabva bzomwe iwo akhalewa, aciwabvundza kuti: “Thangwe ranyi muli kutsutsana kuti mulibe pau? Kodi mukhanati kuzindikira ayai kubvesesa? Kodi misolo yanu njakuuma, nandi? ");
INSERT INTO nyu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Maso munayo, tsono muniwona lini? Ndipo makutu munayo, tsono mumbabvesesa lini? Kodi imwe mun'kumbukira lini? ");
INSERT INTO nyu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pale ndidagwata-gwata pau zixanu kuti ndidyese wanthu bzulu bzixanu, kodi mudadzaza bzitundu bzingasi bza bzakusala?” Wakupfundzira wale adati: “Bzitundu khumi na bziwiri”. ");
INSERT INTO nyu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jezu adawabvundza pomwe kuti: “Kodi pale ndidagwata-gwata pau zinomwe na kudyesa wanthu bzulu bzinai, mudakonkhobza bzitundu bzingasi bza bzakusala?” Iwo adati: “Bzitundu bzinomwe”. ");
INSERT INTO nyu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pamwepo Jezu adati: “Kodi mukanati kubva basi?” ");
INSERT INTO nyu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jezu na wakupfundzira wace adafika kuBetisaida. Kumweko wanthu adabwera na zimola, acimukumbira kuti amukhuye. ");
INSERT INTO nyu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jezu adam'phata boko, acicoka naye kunja kwa mui. Adaikha mata m'maso mwa munthu ule, acimuikha boko acimubvundza kuti: “Kodi uli kuwona cinthu?” ");
INSERT INTO nyu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Munthu ule adakwiza maso acilewa: “Ndiri kuwona wanthu ali kufamba-famba, tsono wali kuwoneka ninga miti”. ");
INSERT INTO nyu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Adamuikha pomwe boko m'maso mwace. Ndipo adapenya acipola, aciyamba kuwona bwino-bwino ");
INSERT INTO nyu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jezu adamuuza kuti ayende kwawo, acimuwuza kuti: “Uleke kubwerera kumui ule”. ");
INSERT INTO nyu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jezu na wakupfundzira wace adayenda kumii ya kuSesaleya-Filipi. Munjira adabvundza wakupfundzira wace kuti: “Kodi wanthu ambalewa Ine ndine yani?” ");
INSERT INTO nyu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iwo adatawira kuti: “Winango ambalewa ndimwe Juwau M'batizi, winango ndimwe Eriya, winangombo ambalewa ndimwe m'bodzi wa apolofita”. ");
INSERT INTO nyu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pamwepo Jezu adawabvundza kuti: “Kodi imwepo, mumbati ndine yani?” Pedru adamutawira kuti: “Imwe ndimwe Krixtu” ");
INSERT INTO nyu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tsono Jezu adawalamula kuti waleke kuwuza munthu winango ali-yentse bza Iye. ");
INSERT INTO nyu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jezu adayamba kupfundzisa wakupfundzira wace kuti: “Mwana-wa-Munthu bzin'dzafunika kuti aboneresedwe kwene-kwene. Akulu wa Ayuda, na akulu wa azibaba wa ntsembe na amisiri wa Mtemo acidzamulamba. Iye an'dzaphedwa, tsono zingadzapita ntsiku zitatu an'dzamuka”. ");
INSERT INTO nyu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Bzimwebzi adabzilewa padeca Na tenepo Pedru adamutenga aciyenda naye pambali, aciyamba kumutsimula. ");
INSERT INTO nyu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tsono Jezu adaceuka, acinyang'ana wakupfundzira wace winango wale, ndipo adatsimula Pedru. Adati: “Coka kwa ine, iwe Sathani! Ndzeru yako ndiyo lini ndzeru ya Mulungu, ni ndzeru ya wanthu”. ");
INSERT INTO nyu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pambuyo pace Jezu adacemera mthithi wa wanthu pabodzi na wakupfundzira wale kuti abwere pafupi na iye, adawauza kuti: “Munthu an'funa kunditewera, abzilambe iye yekha, ndipo anyamule m'tanda wace acinditewera. ");
INSERT INTO nyu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Thangwe an'funa kupulumusa moyo wace, an'dzautaya, tsono wakutaya moyo wace thangwe ra Ine na Mafala Yabwino, an'dzaupulumusa. ");
INSERT INTO nyu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kodi ndiko kuti munthu ana phindu lanyi acikhala na bzentse bza pantsi pano, iye acitaya moyo wace? ");
INSERT INTO nyu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Munthu kuti alombole moyo wace angapereke ciyani? ");
INSERT INTO nyu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nakuti aliwetse wa m'badwe wadzigololo na kuphonya uno, an'cita manyazi na Ine ndipombo na mafala yangu pamaso pa wanthu, napombo ine Mwana-wa-Munthu nin'dzacita naye manyazi pomwe nin'dzabwera pabodzi na anju zakucena, na mbiri ya Baba wangu”. ");
INSERT INTO nyu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Adawauza pomwe kuti: “N'cadidi ndiri kulewa kuti alipo winango pompano omwe an'dzafa lini akanati kuwona kufika kwa Umambo bwa Mulungu na mphambvu”. ");
INSERT INTO nyu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Zatapita ntsiku zitanthatu, Jezu adatenga Pedru, Tiyago na Juwau, acikwira nawo kuphiri litali kwa okha. Ndipo adasandusidwa Jezu pamaso pawo. ");
INSERT INTO nyu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Bzakubvala bzace bzidasanduka bzicena, bziciyetima kuti mbe, kuposa momwe wakufula ali-yentse padziko angadacenesera. ");
INSERT INTO nyu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nthawe imweyo wakupfundzira wale adawona Eriya na Mozeji, alikuceza na Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedru adauza Jezu kuti: “Misiri, n'bzabwino kuti ife tikhale pano. Timange bzikumbi bzitatu, cibodzi canu, cinango ca Mozeji, na cinango ca Eriya”. ");
INSERT INTO nyu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Akhalewa tenepo thangwe iye akhadziwa lini cakulewa sabwa iwo adabva mantha kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ndipo padafika mtambo uciwampsinkha. Mumtambomo mudabveka fala kuti: “Uyu ndiye Mwana wangu omwe nimbafuna, mum'bvere”. ");
INSERT INTO nyu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mwa cisututu, wakupfundzira wale pomwe adanyang'ana-nyang'ana, alibe kuwona wina, adandowona Jezu yekha. ");
INSERT INTO nyu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pomwe akhabuluka m'phiri, Jezu adawaletsa kuti aleke kuwuza winango bzomwe adawona, mpaka Mwana-wa-Munthu amuke kwa wakufa. ");
INSERT INTO nyu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iwo adakoya cintsintsi cire, acimbabvudzana okha-okha kuti: “Kumuka kwa wakufa ndiko kulewa tani?” ");
INSERT INTO nyu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ndipo adambvundza aciti: “Kodi thangwe ranyi amisiri wa Mtemo ambalewa kuti Eriya an'dzakhala wakutoma kubwera?” ");
INSERT INTO nyu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jezu adatawira kuti: “N'cadidi, Eriya an'dzayamba kubwera kuti adzakondze bzentse. Tsono, thangwe ranyi bzakunemba bzimbalewa kuti Mwana-wa-Munthu an'dzaboneresedwa kwene-kwene na kunyozewa? ");
INSERT INTO nyu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tsono Ine ndiri kukuwuzani kuti Eriya adafika kale, ndipo wanthu winango adacita bzentse bzomwe iwo akhafuna ninga momwe Bzakunemba bzidalewera cipande ca iye”. ");
INSERT INTO nyu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pomwe iwo adabwerera kwa wakupfundzira winango wale, adawona mthithi ukulu wa wanthu ukhadawazungulira ndipo Amisiri wa Mtemo akhatsutsana na wakupfundzira wale. ");
INSERT INTO nyu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pomwe wanthu wentsenewo adawona Jezu, adadabwa kwene-kwene, ndipo adam'thamangira kukam'musa. ");
INSERT INTO nyu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iye adawabvundza kuti: “Nandi muli kutsutsana ciani?” ");
INSERT INTO nyu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ndipo m'bodzi wa wanthuwo adatawira kuti: “M'pfundzisi, ndakubwereserani mwana wangu wacimuna thangwe adaphatidwa na mzimu wakuipa wakumutazisa kulewa-lewa. ");
INSERT INTO nyu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ndipo ukandom'phata, umbam'gwesa pantsi, aciyamba kucoka phobvu kumulomo, acimbakukuta mano, mpaka thupi gwa kuuma. Ndipo ndidakumbira wakupfundzira wanu kuti aucose, tsono adatazira”. ");
INSERT INTO nyu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Pamwepo Jezu adawatawira kuti: “Hu! Wanthu wakusaya cikhulupiriro! Nin'dzakhala namwe mpaka lini? Ndin'dzapirira namwe mpaka lini? Ndibweresereni”. ");
INSERT INTO nyu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Adabwera naye. Pakuwona Jezu, mzimu wakuipa udayamba kusukusa mulumbwana ule mwa mphambvu, mpaka iye pantsi khu, nkhumbabvumbvulika, acicoka phobvu kumulomo. ");
INSERT INTO nyu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jezu adabvundza baba wace kuti: “Bzimwebzi bzidamuyamba lini?” Baba wace adati: “Bzidamuyamba ali mwana. ");
INSERT INTO nyu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mzimu umweyu umbakhala ucimbamugwesa kawiri-kawiri. Umbam'gwesa pamoto pinango m'madzi kufuna kumupha. Penu Imwe mungakwanisa, tibvereni ntsisi, tithandizeni”. ");
INSERT INTO nyu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jezu adati: “Uli kuti mungakwanise, bzinthu bzentse n'bzakukwanisika kuna omwe ana cikhulupiriro”. ");
INSERT INTO nyu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pamwepo baba wa mwana adakuwa mwa kudandaula aciti: “Ndiri kukhulupirira. Ndithandizeni kusaya cikhulupiriro kwangu”. ");
INSERT INTO nyu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pomwe Jezu adawona kuti wanthu ali kuwanda pambutoyo, adawutsimula mwa ukali mzimu wakuipayo, adati: “Iwe mzimu wakutazisa kulewa-lewa na kubva, ndiri kukuuza kuti ucoke mwa mwanayu, ndipo leka kudzapita pomwe mwa iye”. ");
INSERT INTO nyu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mzimu ule udakuwa ucim'sukusa mwa mphambvu, ucicoka. Mwana ule adakhala ninga wafa, mpaka azinji akhambati: “Wafa”. ");
INSERT INTO nyu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ndipo Jezu adam'phata boko acimuimisa, iye adaima. ");
INSERT INTO nyu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pomwe Jezu adakapita m'nyumba, wakupfundzira wace adamubvundza pambali, kuti: “Ife tidatazira tani kuucosa mzimu ule?” ");
INSERT INTO nyu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jezu adatawira kuti: “Mzimu wa mtundu umweyu ungacoke lini pakusaya kucita mpembo na kubzimana kudya”. ");
INSERT INTO nyu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jezu na wakupfundzira wace adacoka kumbuto ire ndipo adapita na kuGalireya. Iye akhafuna lini kuti wanthu adziwe komwe akhali, ");
INSERT INTO nyu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","thangwe akhapfundzisa wakupfundzira wace, acimbawati: “Mwana-wa-Munthu an'dzaperekedwa kwa wanthu, ndipo an'dzamupha. Tsono angamupha, Iye an'dzamuka pomwe zingadzapita ntsiku zitatu”. ");
INSERT INTO nyu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tsono iwo alibe kubvesesa bzomwe iye akhalewa, ndipo akhagopa kumubvundza. ");
INSERT INTO nyu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ndipo adafika kuKafaranawumi. Pomwe iye akhali m'nyumba, adawabvundza kuti: “Kodi panjira pale mukhambatsutsana ciani?” ");
INSERT INTO nyu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wakupfundzira wale adakhala cete, thangwe bzomwe akhatsutsana bzikhali bzakuti mkulu mbani pakati pawo. ");
INSERT INTO nyu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jezu adakhala pantsi, acicemera wakupfundzira khumi na awiri wale, aciwauza kuti: “Penu winango an'funa kukhala wakutoma, an'dzakhala wakumalizira, ndipo wakudzatumikira wentse”. ");
INSERT INTO nyu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pamwepo adatenga mwana m'bodzi, acimukhazika pakati pawo acikumbatira, adawauza kuti, ");
INSERT INTO nyu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ali-yentse an'tambira mwana ninga uyu thangwe ra Ine, ali kutambira Ine, Ndipo wakutambira Ine, ali kutambira ine na omwe adandituma”. ");
INSERT INTO nyu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juwau adawuza Jezu kuti: “Mpfundzisi, ife tidawona munthu winango acimbacosa mizimu yakuipa pakulewa dzina lanu, ndipo tidamuletsa, thangwe ambafamba lini na ife”. ");
INSERT INTO nyu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tsono Jezu adati: “Lekani kumuletsa, thangwe palibe omwe angacite bzidabwiso mudzina langu patsogolo pace acindinyoza. ");
INSERT INTO nyu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sabwa wakusaya kutsutsana nafe, umweyo ngwakuphatana nafe. ");
INSERT INTO nyu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na tenepo ule omwe an'kupasani mkombo wa madzi mudzina langu, thangwe ra kuti ndimwe wa kwa Krixtu, cadidi ndiri kulewa kuti umweyo cipo angadzasaye kutambira mabaibai”. ");
INSERT INTO nyu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Penu wina angaphonyese m'bodzi wa ang'onowa wakukhulupirira ine, umweyo bzikhali bwino kuti amangiriridwe cimwala ca nyampheyo mkhosi acikam'thusa panyandza. ");
INSERT INTO nyu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Penu boko lako liri kukuphonyesa, ligwate. N'bzabwino kuti ukapite kumoyo wakusaya kumala uli wakugwatika boko, kuposa kuti ukapite una manja yentse mawiri kumoto wakusaya kumala”. ");
INSERT INTO nyu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","“Kumweko kuna nkhonye zakuluma zimbafa lini, ndipo moto wacembo umbathima lini”. ");
INSERT INTO nyu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Penu mwendo wako uli kukuphonyesa, ugwate. N'bzabwino kuti ukapite kumoyo wakusaya kumala uli wakugwatika mwendo, kuposa kuti ukathusidwe kumoto wakusaya kumala una miyendo yentse miwiri”. ");
INSERT INTO nyu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","“Kumweko kuna nkhonye zakuluma zimbafa lini, ndipo moto wacembo umbathima lini”. ");
INSERT INTO nyu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Penu diso lako liri kukuphonyesa, licose. Ni bzabwino kuti ukapite muUmambo bwa Mulungu uli na diso libodzi lokha, kuposa kuti akakuthuse kumoto wakusaya kumala una maso yentse mawiri. ");
INSERT INTO nyu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kumweko kuna nkhonye zakuluma zimbafa lini, moto wacembo umbathima lini. ");
INSERT INTO nyu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Thangwe m'bodzi na m'bodzi an'dzalungidwa na moto. ");
INSERT INTO nyu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Munyu ngwabwino, tsono ungaterepo wamala goso, umbadzakhala pomwe munyu? Moyo wanu ukhale na munyu, ndipo mukhale na mtendere imwe na andzanu”. ");
INSERT INTO nyu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ndipo Jezu adanyamuka pambuto ire, adayenda kumphimpha ya kuJudeya, kumphimpha ya ng'ambu ya mkulo wa Jolodani. Ndipo wanthu azinji adadzagumana pomwe na iye. Mwa cizerewezi cace, akhawapfunzisa pomwe. ");
INSERT INTO nyu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ndipo adafika aFalizi anango, adamubvundza kuti: “Nandi ni bzakubvumizidwa kuti munthu alambe mkazi wace?” Akhadam'bvundza tenepo kuti amunyang'anire thangwe. ");
INSERT INTO nyu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jezu adawatawira aciti: “Ni ciani comwe Mozeji adakulamulirani?” ");
INSERT INTO nyu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iwo adati: “Mozeji adabvumiza kuti munthu anembere mkazi wace tsamba lakulambana patsogolo pace amucose”. ");
INSERT INTO nyu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jezu adati: “Mozeji adakunemberani Mtemo umweyo thangwe ra kuuma mitima kwanu. ");
INSERT INTO nyu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Koma, paciyambi pa bzentse Mulungu, adalenga wanthu, mwamuna na mkazi. ");
INSERT INTO nyu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Thangwe race mwamuna an'dzasiya baba na mai, acikaphatana na mkazi wace, ");
INSERT INTO nyu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ndipo awiriwa an'dzakhala thupi libodzi. Na tenepo ndiwo lini pomwe awiri, koma thupi libodzi. ");
INSERT INTO nyu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na tenepo bzomwe Mulungu waphatanidza, munthu aleke kubzilekanisa”. ");
INSERT INTO nyu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pomwe adapita m'nyumba, wakupfundzira adamubvundza Jezu bza nkhani imweire. ");
INSERT INTO nyu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iye adatawira kuti: “Omwe an'lamba mkazi wace acikalowola winango, ali kucita upombo kuna mkazi wace. ");
INSERT INTO nyu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bzibodzi-bodzimbo mkazi angalamba mwamuna wace, acikalowodwa na winango, na iyembo ali kucita upombo”. ");
INSERT INTO nyu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wanthu winango akhambabwera na wana kwa Jezu kuti awakhuye. Tsono wakupfundzira wace akhambawatsimula mwa ukali. ");
INSERT INTO nyu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jezu pomwe adawona bzimwebzire, adakalipa aciwauza kuti: “Alekeni wanawa abwere kwa Ine. Lekani kuwaletsa thangwe Umambo bwa Mulungu n'bwa wale wakulinganira na iwowa. ");
INSERT INTO nyu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cadidi ndiri kulewa kuti omwe an'bvuma lini Umambo bwa Mulungu ninga mwana, umweyo an'dzabupita lini”. ");
INSERT INTO nyu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na tenepo adayamba kuwakumbatira wana wale, aciwasandzika boko na kuwadalisa. ");
INSERT INTO nyu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pomwe Jezu akhaguduka, munthu wina adam'thamangira, acim'godamira kutsogolo kwace, acimubvundza kuti: “Apfundzisi wabwino, kodi ningacite ciyani kuti ndidzatambire moyo wakusaya kumala?” ");
INSERT INTO nyu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jezu adamutawira kuti: “Uli kundicemereranyi wabwino? Wabwino ni m'bodzi yekha, Mulungu basi. ");
INSERT INTO nyu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mitemo umbaidziwa: ‘Leka kupha, leka kucita upombo, leka kuba, leka kucita umboni bwakunama, leka kunamiza andzako, lemekeza baba wako na mai wako.’ ” ");
INSERT INTO nyu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Munthu ule adati: “Mpfundzisi, bzentsenebzi nimbabziteweza kuyambira ndiri mwana”. ");
INSERT INTO nyu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jezu adamunyang'ana, na lufoyi acimuuza kuti: “Ciri kukusalira cinthu cibodzi, ndoko, ukagulise cuma centse. Kobiri zentse ukapase wanthu wakusauka, ndipo un'dzatambira cuma kudzulu. Patsogolo pace ubwere, udzanditewere”. ");
INSERT INTO nyu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pakubva bzimwebzi, nkhope yace idadodoma, ndipo adacoka na kuneseka mum'tima thangwe akhali munthu wa cuma cizinji. ");
INSERT INTO nyu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jezu adanyang'ana mbali mwace, aciuza wakupfundzira wace kuti: “N'bzakunesa kwene-kwene kuti wacuma akapite muUmambo bwa Mulungu!” ");
INSERT INTO nyu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wakupfundzira adadabwa na mafalayo. Tsono Jezu adabwerezera, aciti: “Wana wangu, n'bzakunesa kwene-kwene kukapita muUmambo bwa Mulungu! ");
INSERT INTO nyu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","N'bzakupusa kuti ngamira ipite pamubo wa ntsingano kuposa kuti munthu nyakudala akapite muUmambo bwa Mulungu”. ");
INSERT INTO nyu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pamwepo wakupfundzira adadabwa kwene-kwene acibvundzana kuti: “Kodi angapulumuke mbani?” ");
INSERT INTO nyu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jezu adawanyang'anisa aciti: “Kwa wanthu bzin'kwanisika lini, tsono kwa Mulungu n'tenepo lini, Kwa Mulungu bzentse n'bzakukwanisika”. ");
INSERT INTO nyu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pamwepo Pedru adayamba kumuuza iye, kuti: “Onani, ife tidasiya bzentse kuti tikutewereni”. ");
INSERT INTO nyu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jezu adatawira: “Cadidi ndiri kukuuzani imwe, kuti omwe an'siya nyumba, nkhosve, mpfumakazi, mai, baba, wana ayai minda thangwe ra Ine, ndipombo thangwe ra Mafala Yabwino, ");
INSERT INTO nyu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","umweyo pantsi pano an'dzatambira bzentse bzakuwanda kwene-kwene kusiyana na kale bzomwe ni, nyumba, nkhosve, mpfumakazi, mai, wana, minda, ndipombo matsautso. Ndipo kutsogolo an'dzatambira moyo wakusaya kumala. ");
INSERT INTO nyu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pamwepo azinji omwe ali wakuyamba an'dzakhala wakumalizira, wakumalizira an'dzakhala wakuyamba”. ");
INSERT INTO nyu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Akhali paulendo bwa kuJerusalema, Jezu akhali patsogolo, wakupfundzira wace akhadabwa. Napombo wanthu omwe akhatewera akhana mantha. Ndipo adawacemera pomwe wakupfundzira khumi na awiriwo pambali, aciwafokotozera bzomwe bzin'dzamucitikira. ");
INSERT INTO nyu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Adati: “Tiri paulendo bwa kuJerusalema. Kumweko Mwana-wa-Munthu ati akaperekedwe kwa akulu wa azibaba wa ntsembe na adziwi wa Mtemo. Iwo an'kamutonga na kupasa nyathwa kuti aphedwe. Ndipo an'kamupereka kwa wanthu wakunja. ");
INSERT INTO nyu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Iwo an'kamusinjirira, acikamupsipira mata, acikamuchanga ndipo acikamupha. Zingadzapita ntsiku zitatu, Iye an'dzamuka”. ");
INSERT INTO nyu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tiyago na Juwau, wana wa Zebedeu, adafendera kwa iye aciti: “Mpfundsisi, comwe tinikukumbirani, muticitire”. ");
INSERT INTO nyu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jezu adabvundza kuti: “Mun'funa kuti ndikucitireni ciyani?” ");
INSERT INTO nyu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Iwo adati: “Tin'funa kuti pomwe mun'dzakhala mumbiri yanu, mudzatiikhe m'bodzi kuboko lanu ladidi, wina ladzere”. ");
INSERT INTO nyu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tsono Jezu adati: “Mun'dziwa lini bzomwe muli kukumbira. Kodi imwe mungakwanise kumwera mkombo omwe ine nin'dzamwera? Ndipo imwe mungadzabatizidwe ninga momwe ine nin'dzabatizidwa?” ");
INSERT INTO nyu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Iwo adatawira kuti: “Inde, tin'dzakwanisa”. Pamwepo Jezu adati: “Cadidi, mkombo omwe Ine nin'dzamwera, imwe mun'dzaumwerambo, ndipo mun'dzabatizidwa ninga ine. ");
INSERT INTO nyu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tsono Ine ni utongi lini bwangu kuikha munthu kuboko ladidi ayai ladzere. Mulungu ndiye adakondza mbutozo ndipo an'dzazipasa ali-yentse omwe iye angafune”. ");
INSERT INTO nyu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pomwe anango wale khumi adabva bzimwebzi, adakalipira Tiyago na Juwau. ");
INSERT INTO nyu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ndipo Jezu adawacemera kuti abwere pafupi na iye, adati: “Mun'dziwa kuti atongi wa madziko ambayakunda. Akulu-akulu wawombo ambawonesa mphambvu zawo kwa wanthu wawo. ");
INSERT INTO nyu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tsono pakati pa imwe bzileke kukhala tenepo. Omwe an'funa kukhala mkulu, atumikire andzace. ");
INSERT INTO nyu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ndipo omwe an'funa kukhala wakuyamba, akhale kapolo wa wentse. ");
INSERT INTO nyu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Thangwe Mwana-wa-Munthu alibe kubwera kuti adzatumikiridwe koma kuti Iye adzatumikire wanthu na kupereka moyo wace kuti alombole azinji”. ");
INSERT INTO nyu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ndipo adafika kumzinda wa Jeriko. Pomwe akhacoka mumzinda ule na wakupfundzira wace, pabodzi na mthithi wa wanthu, adagumana zimola m'bodzi wakukumbira-kumbira akhadakhala mphepete mwa njira. Munthuyo dzina lace akhacemeredwa Balitimeu, mwana wa Timeu. ");
INSERT INTO nyu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pomwe iye adabva kuti ni Jezu wa kuNazalee, adakuwa aciti: “Jezu, Mwana wa Davidi, ndibvereni ntsisi!” ");
INSERT INTO nyu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wanthu azinji akhamutsimula mwa ukali kuti anyamale. Tsono iye adapitiriza kukuwa aciti: “Mwana wa David, ndibverenimbo ntsisi!” ");
INSERT INTO nyu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jezu adaima, aciwauza kuti: “Mucemereni”. Iwo adamucemera acimuuza kuti: “Limba m'tima, lamuka, ali kukucemera”. ");
INSERT INTO nyu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pamwepo iye adathusa kapote wace adamuka, acimoga, aciyenda kuna Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jezu adamubvundza kuti: “Un'funa kuti ndikucitire ciyani?” Zimola ule adatawira kuti: “Mpfundzisi, nin'funa kuwona”. ");
INSERT INTO nyu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jezu adamuuza kuti: “Ndoko, cikhulupiriro cako cakulimbisa”. Nthawe ibodzi-bodziyo adayamba kuwona, ndipo adatewera Jezu munjira. ");
INSERT INTO nyu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pomwe Jezu na wakupfundzira wace akhafendera kuJerusalema, pafupi na mizinda ya Betefaje na Betanya ya pafupi na phiri ra maoliva, Iye adatuma wakupfundzira wace awiri, ");
INSERT INTO nyu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","aciti: “Ndokoni m'mui omwe uli kutsogolo kwanu. Mungandopita, mukagumana kabulu kadamangiridwa, komwe kakanati kupakiridwa na munthu ali yentse. Mukakatsudzule mucikabwera nako. ");
INSERT INTO nyu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Penu wina acikakubvundzani kuti: ‘Thangwe ranyi muli kucita bzimwebzi?’ Katawireni kuti: ‘Mbuya an'kafuna, ndipo patsogolo pace an'dzakabwezera pomwe kuno.’ ” ");
INSERT INTO nyu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Panthawe yomweyo wakupfundzira wale adayenda, acikawona kabulu kadamangirira pafupi na msuwo, kunja mphephete mwa njira, ndipo adakatsudzula. ");
INSERT INTO nyu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Anango omwe akhali pamwepo adawabvundza kuti: “Thangwe ranyi muli kutsudzula kabuluka?” ");
INSERT INTO nyu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iwo adawatawira ninga momwe Jezu adawauza. Ndipo adawaleka acitenga. ");
INSERT INTO nyu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Adakatenga kabulu, acibwera nako kuna Jezu ndipo adatandika bzakubvala bzawo pamsana pakene, ndipo Jezu adapakira. ");
INSERT INTO nyu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wanthu azinji akhambatandika bzakubvala bzawo munjira, anango akhambatandika mithawi ya miti yomwe akhambatcola m'minda. ");
INSERT INTO nyu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wanthu omwe akhali patsogolo, na omwe akhali m'mbuyo, adakuwa kuti: “ ‘Ozana!’ Simbani omwe ali kubwera mudzina la Mbuya. ");
INSERT INTO nyu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Simbani Umambo bwa baba wathu David, bomwe buli kubwera mudzina la mbuya. Ozana kwa Mulungu wakudzulu!” ");
INSERT INTO nyu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ndipo Jezu adapita muJerusalema, acikapita muNyumba ya Mulungu. Pakuti yakhali kale maulo, adanyang'ana-nyang'ana bzentse ndipo adacoka aciyenda kuBetanya pabodzi na wakupfundzira wace khumi na awiri. ");
INSERT INTO nyu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mangwana yace, pomwe iwo akhacoka kuBetanya, Jezu adabva njala. ");
INSERT INTO nyu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ndipo na patali adawona mkuyu ukhana masamba. Adayenda pafupi kuti pinango angawone nkhuyu. Ndipo adafika, alibe kuwona nkhuyu, adandokawona masamba yokha. Nakuti ikhali lini nyengo ya nkhuyu. ");
INSERT INTO nyu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pamwepo adawuza mutiyo kuti: “Muti iwe, kuyambira lero, cipo winango ali-yentse an'dzadya lini bzisapo bzako”. Ndipo wakupfundzira wace adabva bzimwebzo. ");
INSERT INTO nyu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Iwo atafika kuJerusalema, Jezu adapita muNyumba ya Mulungu, aciyamba kuthotha omwe akhacita malonda m'mwemo. Adagwesa meza zakusinthira kobiri na mipando ya wanthu wakugulisa nkhangaiwa. ");
INSERT INTO nyu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Akhabvumiza lini ali-yentse agwate na pacinthalo ca Nyumba ya Mulungu adanyamula cinthu. ");
INSERT INTO nyu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ndipo akhawapfundzisa aciti: “Bzidanembedwa kuti: ‘Nyumba yangu in'dzacemeredwa Nyumba ya mapembero kwa madziko yentse.’ Tsono imwe mwaisandusa nkhunde ya mbabva”. ");
INSERT INTO nyu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pakubva bzimwebzi akulu wa azibaba wa ntsembe na adziwi wa Mtemo akhanyang'ana njira yakuti amuphe. Tsono akhabva naye mantha thangwe wanthu wentse akhadabwa nabzo bzomwe Iye akhapfundzisa. ");
INSERT INTO nyu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kudayamba kudoka, Jezu na wakupfundzira wace adacoka mumzinda mule. ");
INSERT INTO nyu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Macibese, pakuyenda munjira, adawona mkuyu ule wauma na mizi kubodzi. ");
INSERT INTO nyu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pamwepo Pedru pakumbuka bzire, adamuuza kuti: “Mpfundzisi, onani, mkuyu omwe mudatemberera wauma”. ");
INSERT INTO nyu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jezu adawatawira: “Khulupirirani Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cadidi ndiri kukuwuzani kuti penu wina aniuza phiri iri kuti: ‘Coka apa, ukabzithuse kunyandza,’ angalewa na m'tima wakusaya kukayika, mucikhulupirira cadidi kuti bzomwe ali kulewabzo bzin'citika, na tenepo bzin'dzacitika ninga bzomwe walewa. ");
INSERT INTO nyu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Na tenepo ndiri kukuwuzani kuti ciri centse comwe mungakumbire mwa kupemba, khulupirirani kuti mwatambira ndpo na tenepo mun'dzatambira. ");
INSERT INTO nyu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ndipo mungafuna kupemba, cakutoma mulekerere mwandzanu penu munaye cinthu. Mungaterepo, Baba wanu omwe ali Kudzulu an'dzakulekelerani bzakuipa bzanu”. ");
INSERT INTO nyu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“Tsono penu imwe munilekerera lini andzanu, Baba wanu omwe ali Kudzulu an'dzakulekereranimbo lini bzakuipa bzanu”. ");
INSERT INTO nyu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Adabwerera pomwe kuJerusalema. Ndipo pomwe Iye akhandobzifambira m'Nyumba ya Mulungu, akulu wa azibaba wa ntsembe, na adziwi wa Mtemo, pabodzi na akulu wa Ajuda adabwera kuna iye acimubvundza kuti: ");
INSERT INTO nyu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Kodi utongi wakuti mumbacite bzimwebzi mudautenga kuponi? Mbani adakupasani utongi umweyu?” ");
INSERT INTO nyu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jezu adawatawira: “Na inembo ndicikupasani mbvundzo ubodzi. Munganditawira, ndipo nin'kuwuzani komwe ndidatenga utongi wakuti nimbacite bzimwebzi. ");
INSERT INTO nyu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kodi ubatizi bwa Juwau bukhali bwa kudzaulu ayai bwa wanthu? Nditawireni”. ");
INSERT INTO nyu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ndipo iwo adabvundzana acimbati: “Tingalewa adazitenga kwa Mulungu, umweyu anirewa kuti: ‘Kodi thangwe ranyi tsono mulibe kum'khulupirira?’ ");
INSERT INTO nyu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tsono tingalewa kuti adazitenga kwa wanthu”. Iwo akhagopa wanthu, pakuti wanthu wentse akhatawirira kuti Juwau akhali mpolofita. ");
INSERT INTO nyu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Na tenepo adamutawira Jezu kuti: “Tin'dziwa lini”. Iye adawatawira kuti: “Na inembo nin'kuwuzani lini komwe ndidautenga utongi wakuti nimbacite bzimwebzi”. ");
INSERT INTO nyu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Patsogolo pace Jezu adawatsikira mathere. Adati: “Mwamuna m'bodzi adalima dimba la uva acimanga litsito kuzungulira dimbalo. Adacera dindi lakupsinyira uva, acimanga gota lakukhalilira dimbalo. Patsogolo pace adapasa alimi anango acipangana nawo kuti akabvuna ambam'pase bzisapo bzace. Ndipo iye adacoka mudzikomo. ");
INSERT INTO nyu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nthawe yakubvuna yatakwana, mwenekaciro adatuma wabasa wace kwa alimi wale kuti akatambire bzisapo bzace. ");
INSERT INTO nyu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tsono iwo adaphata wabasa ule acim'menya ndipo acimubweza alibe cinthu. ");
INSERT INTO nyu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mwenekaciro ule adatuma wabasa winango tsono alimi wale adam'tema mumsolo acimunyazisa. ");
INSERT INTO nyu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ndipo mwenekaciro ule adatuma wabasa winango iwo adamupha. Adacita bzibodzi-bodzi na wabasa azinji, winango adawamenya aciwapweteka, wina adawapha”. ");
INSERT INTO nyu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Mwenekaciro ule adasala na mwana wace m'bodzi wapamtima. Ndipo patsogolo pace adadzam'tuma kuna iwo. Adakumbuka kuti: ‘Mwana wangu, an'kamulemekeza’ ”. ");
INSERT INTO nyu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ndipo alimi wale adayamba kuwuzana kuti: ‘Omweyu ndiye nyanthaka wace, mbatimuphe kuti idzakhale yathu’. ");
INSERT INTO nyu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Cadidi adamuphata, acimupha acimuthusa kunja kwa dimbalo”. ");
INSERT INTO nyu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Kodi mwenekaciro wa dimba an'dzacita ciyani? An'dzabwera aciwapha alimiwo, dimba lire acipasa anango. ");
INSERT INTO nyu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kodi mulibe kulewenga bzomwe bzakunemba bzimbalewa?” Bzimbati: “Mwala omwe amisiri wakumanga nyumba adaulamba ndiwo wadzakhala mwala wakufunika. ");
INSERT INTO nyu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mbuya Mulungu ndiye adacita, ndipo ni cidabwiso kwa ife”. ");
INSERT INTO nyu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ndipo akulu wa Mayuda adadziwa kuti mathereyo akhayezerera iwo. Ndipopo adafuna kum'manga Jezu, tsono akhagopa mthithi wa wanthu. Ndipo iwo adandocoka acimuleka. ");
INSERT INTO nyu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wanthu wa bungwe la afalizi, na winango wa phati ra Herodi adatumidwa kuti akatape mkanwa Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Iwo adafika aciti: “Mpfundzisi, tin'dziwa kuti imwe ndimwe wakulungama, ndipo mulibe lubvera. Mumbanyang'ana lini kuti uyu mbani, ndipo mumbapfundzisa njira ya Mulungu cadidi. Kodi kumbvumizidwa kuti timbapime msonkho kwa mambo wa kuRoma, ayai ne? ");
INSERT INTO nyu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Timbapimedi ayai tileke?” Tsono Jezu pakudziwa ndzeru zawo zaciphamaso, adati: “Thangwe ranyi mundiyeza utowa? Ndipaseni kobiri ibodzi kuti ndiione”. ");
INSERT INTO nyu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Iwo adam'pasa kobiri ire. Ndipo iye adawabvundza kuti: “Kodi nkhopeyi njayani, ndipo dzinali ndayani?” Iwo adatawira: “Ni bza Seza”. ");
INSERT INTO nyu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Pamwepo Jezu adawauza kuti: “Ehedi! Perekani bza Seza kwa Seza, bza Mulungu kwa Mulungu”. Pakubva bzimwebzi adadabwa naye. ");
INSERT INTO nyu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pamwepo aSadusi anango omwe ambati palibe an'dzamuka kwa wakufa, adafendera kwa Jezu, acimbvundza kuti: ");
INSERT INTO nyu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mpfundzisi, Mozeji adatinembera kuti: ‘Penu munthu akafa, acisiya mkazi, alibe naye mwana, m'bale wa wakufayo apite nthaka kuti abalire m'bale wace ule omwe adafa.’ ");
INSERT INTO nyu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Akhalipo wanthu anomwe paubale bwawo. Wakuyamba adalowola, adafa alibe kusiya mwana. ");
INSERT INTO nyu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Waciwiri adapita nthaka, na iyembo adafa ne kusiya mwana. Bzibodzi-bodzi, bzidacitika kuna wacitatu. ");
INSERT INTO nyu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mpaka anomwe wentse adafa alibe kusiya wana. Pakumalizira mkaziyo adadzafambo. ");
INSERT INTO nyu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kodi pantsiku yakudzamuka kwa wakufa, mwenekaciro mkaziyo an'dzakhala uponi? Thangwe la kuti abale anomwe wale wentse akhadamulowola”. ");
INSERT INTO nyu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jezu adawatawira kuti: “Ndipopa mumbaphonya thangwe ra kusaya kudziwa bzakunemba ndipo na mphambvu za Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Na tenepo pakumuka kwa wakufa, palibe kulowolana. Wentse an'dzakhala ninga anju za Kudzaulu. ");
INSERT INTO nyu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tsono bzakuti wanthu an'dzamuka kwa wakufa, kodi mulibe kulewenga mulivu la Mozeji, pomwe pali kulewa bza citsamba cakugaka? Mulungu adamuwuza Mozeji kuti: ‘Ine ndine Mulungu wa Abrahamu, Izaki, na Jakobo.’ ");
INSERT INTO nyu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ibzi bziri kulatiza kuti Mulungu ni mulungu lini wa wakufa, ni mulungu wa wamoyo. Imwepo muli kuphonyeka”. ");
INSERT INTO nyu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mdziwi m'bodzi wa Mtemo, adabva kutsutsana kwawo. Pomwe adawona kuti Jezu adawatawira bwino Asaduseyu wale, adafendera adabvundza aciti: “Kodi mwa mitemo yentse, ukulu ni uponi?” ");
INSERT INTO nyu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jezu adamutawira kuti: “Mtemo ukulu nguyu: ‘Bvani, aIjirayeri! Mbuya, Mulungu wathu, ndiye Mulungu m'bodzi yekha. ");
INSERT INTO nyu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Funa Mbuya, Mulungu wako, na m'tima wako wentse, na moyo wako wentse, na ndzeru zako zentse, na mphambvu zako zentse.’ ");
INSERT INTO nyu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","M'temo waciwiri nguyu: ‘Funa mwandzako ninga momwe umbabzifunira iwe wekha.’ Palibe Mtemo winango ukulu wakuposa mitemo imwei”. ");
INSERT INTO nyu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mdziwi ule wa Mtemo adati: “Mwatawira bwino, mpfundzisi. Ninga mwalewa, ncadidi kuti Mulungu ni m'bodzi yekha ndipo palibe winango. ");
INSERT INTO nyu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ndipombo umufune na m'tima wentse, na ndzeru zentse, na mphambvu zentse, ndipombo funa mwandzako ninga umbabzifunira iwe wekha, bzimwebzi mpsabwino kuposa kupereka ntsembe zakutentha na ntsembe zinango zentse”. ");
INSERT INTO nyu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jezu adawona kuti munthuyo adatawira na udziwi. Ndipo adamuwuza kuti: “Iwe uli lini kutali na Umambo bwa Mulungu”. Kuyambira pamwepo pakhalibe winango wakulimba m'tima kuti amubvundze. ");
INSERT INTO nyu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pomwe Jezu akhapfundzisa muNyumba ya Mulungu, adabvundza: “Kodi adziwi wa Mtemo ambalewa kuti Krixtu ni mwana wa David? ");
INSERT INTO nyu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David adati mwa Mzimu Wakucena kuti: “ ‘Mbuya adalewa kuna Mbuya wangu kuti: Khala kuboko langu lamadidi mpaka ndiikhe anyamadulanthaka wako pantsi pa ndzayo zako’. ");
INSERT INTO nyu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David caiye, ambacemera Krixtu kuti Mbuya. Angakhale tani mwana wace?” Wanthu azinji akhatetekera na kukomedwa kwene-kwene pakubva mafala yace. ");
INSERT INTO nyu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Pomwe Jezu akhawapfundzisa, adati: “Cenjerani nawo adziwi wa Mtemo. Ambafuna kuyenda adabvala bzakubvala bzitali nakuti alemekezedwe pamiseu. ");
INSERT INTO nyu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ambafuna mbuto yakutsogolo m'nyumba zamapembero, ndipombo mbuto zakulemekezeka pauzokoto. ");
INSERT INTO nyu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ndipo ambawadyera nthaka za amansiwa, acimbacita mapembero matali-matali mwakunamiza. Wanthu omwewo andzapasidwa nyathwa ikulu”. ");
INSERT INTO nyu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ntsiku inango, Jezu akhadakhala pafupi na ntsengwa yakuikhira kobiri za ntsembe muNyumba ya Mulungu. Akhanyang'anisisa momwe wanthu akhaperekera kobiri zawo. Wanthu azinji nyakudala akhathusa kobiri zizinji. ");
INSERT INTO nyu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tsono padafika mansiwa m'bodzi, adathusa tukobiri tuwiri twakukwanira kwadrante ibodzi. ");
INSERT INTO nyu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ndipo Jezu adacemera wakupfundzira wace aciwauza kuti: “Ncadidi ndiri kulewa kuti mansiwa wakusaukayu wathusa kuposa wanthu wentsewa omwe ali kuthusa kobiri muntsengwa. ");
INSERT INTO nyu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Thangwe winangowa andothusa bzomwe atapa pa bzizinji anabzo. Tsono mkaziyu, mwa kusauka kwace, wathusa bzentse bzomwe akhali nabzo, napo bzomwe bzingadamuthandiza pamoyo wace”. ");
INSERT INTO nyu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Pomwe Jezu akhacoka kuNyumba ya Mulungu, m'bodzi wa akupfundzira wace adamuwuza kuti: “Mpfundzisi, onani minyalayi na nyumbazi”. ");
INSERT INTO nyu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jezu adamuwuza kuti: “Kodi uli kuziwona nyumba zikulu-zikuluzi zentsenazi? Pan'dzasala lini mwala padzaulu pamwala undzace, yentseneyi in'dzagumulidwa”. ");
INSERT INTO nyu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jezu adakhala pantsi paphiri la Olivera kutsogolo kwa Nyumba ya Mulungu. Ndipo Pedru, Tiyago, Juwau na Andereya adamubvundza paokha kuti, ");
INSERT INTO nyu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tiwuzeni bzimwebzi bzin'dzacitika lini? Tin'dzawona cizindikiro canyi kuti bziri pafupi kucitika?” ");
INSERT INTO nyu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Pamwepo Jezu adawawuza kuti: “Cenjerani kuti wina ali-yentse aleke kukupumpsani. ");
INSERT INTO nyu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Thangwe azinji an'dzabwera mudzina langu acimbadzalewa kuti: ‘Krixtu ndine.’ Ndipo wan'dzasoceresa wanthu azinji. ");
INSERT INTO nyu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mukadzabva nkhondo ayai ntabva-tabva wa nkhondo, lekani thupo. Bzimwebzi bzin'funika kuti bzidzacitike, tsono cimaliziro cikanati kufika. ");
INSERT INTO nyu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Madzindza yakusiyana-siyana yan'dzasandukirana. Madziko yakusiyana-siyana yan'dzamenyana nkhondo. Mbuto zakusiyana-siyana zin'dzatekenyeka, ndipo kun'dzakhala njala. Tsono bzimwebzi bzidzakhala ninga kubvulumukidwa kwa mai wa pathupi. ");
INSERT INTO nyu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Cenjerani! Wanthu an'dzakuperekani kumbuto za kutongera mirandu, ndipo an'dzakuchangani m'nyumba zamapemphero. Mun'dzawonekera kwa atongi na kwa azimambo thangwe ra Ine kuti mukandicitire umboni. ");
INSERT INTO nyu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ndipo bzakufunika kuti Mafala Yabwino ya yambe kulewedwa kwa wanthu wa madzindza yentse. ");
INSERT INTO nyu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ndipo angadzakuphatani acikuperekani pamphala, lekani kudzakhala na thupo kuti: ‘Kodi tikalewe ciyani?’ Mun'kalewa bzomwe Mulungu an'kakuwuzani panthawe yomweyo. Thangwe ndimwe lini mun'dzalewa-lewa. Mzimu Wakucena ndiwo un'dzalewa-lewa. ");
INSERT INTO nyu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","M'bale an'dzapereka m'bale wace kuti aphedwe. Baba, mwana wace. Wana an'dzasandukira azibaba wawo mpaka kuwaphesa. ");
INSERT INTO nyu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mun'dzawengedwa na wanthu wentse thangwe ra dzina langu. Ndipo omwe an'dzalimbika mpaka pakumalizira, ndiye an'dzapulumuka”. ");
INSERT INTO nyu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mukawona cakudzonga cidaima pambuto yomwe cin'funika lini kuti cikhale. (Wakulewenga, abvesese!) Pamwepo omwe wali muYudeya adzathawire kumapiri. ");
INSERT INTO nyu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Omwe ali pacigota, abuluke athawiretu. Aleke kupita m'nyumba kuti akatenge cinthu. ");
INSERT INTO nyu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Omwe ali kumunda, aleke kubwerera kunyumba kuti akatenge bzakubvala. ");
INSERT INTO nyu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tsoka kwa akazi omwe an'dzagumanizidwa ana pathupi na wakumamisa wana ntsiku zimwezo. ");
INSERT INTO nyu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mupembe kuti bzimwebzi dzileke kudzakuwonekerani panyengo ya mphepo ");
INSERT INTO nyu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","thangwe pantsiku zimwezo yan'dzawoneka mabvuto yomwe yakanati kuwoneka kucokera paciyambi ca dziko lapantsi mpaka lero, ndipo yan'dzawoneka lini pomwe. ");
INSERT INTO nyu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na tenepo Mbuya angadasaya kuzipunguza ntsikuzo, palibe omwe angadapulumuka. Tsono Mulungu adazipunguza thangwe ra wanthu omwe iye adasankhula. ");
INSERT INTO nyu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Na tenepo, winango angadzakuwuzani kuti: ‘Ali pano Krixtu,’ ayai ‘Uyo ali apo.’ Lekani kudzam'bvera ");
INSERT INTO nyu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","thangwe kun'dzawoneka wanthu wakunama an'dzalewa kuti: ‘Ndine Krixtu’ pinango kuti: ‘Ndine mpolofiti.’ Wanthuwo acimbadzacita mabasa yamphambvu ndipombo bzinthu bzakudabwisa kuti bzingadzakwanisika adzasocerese napo wakusankhulidwa na Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ndipo imwe khalani na tceru. Ine ndakuwuzani bzentsenebzi bzikhanati kuti bzicitike”. ");
INSERT INTO nyu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ntsiku zimwezo, mabvutoyo yangadzamala, “ ‘Dzuwa lin'dzathima, mwezi un'dzaleka kugaka. ");
INSERT INTO nyu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nyenyezi zin'dzagwa kucokera kudzaulu, ndipo mphambvu za kudzaulu zin'dzatekenyeka’. ");
INSERT INTO nyu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Pamwepo an'dzawona Mwana-wa-Muntu ali kubwera m'mitambo na mphambvu zikulu na ulemerero. ");
INSERT INTO nyu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iye an'dzatuma anju zace kuti akagumanize wakusankhulidwa wace kucokera kudziko lentse zomwe ni, kudzaulu, kunyantsi, kumabva dzuwa, na kumadokero. ");
INSERT INTO nyu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Pfundzirani kuna mkuyu. Mukawona kuti mithawi yace yayamba kuswipirira ndipo masamba yali kufundira, mumbadziwe kuti mayindza yafendera. ");
INSERT INTO nyu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Na tenepo mungadzawona bziri kucitika, mudzadziwe kuti Mwana-wa-Munthu ali pafupi, ali pamsuwo caipo. ");
INSERT INTO nyu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cadidi ndiri kulewa kuti bzentsenebzi bzin'dzawoneka mbadwe uno ukanati kufa. ");
INSERT INTO nyu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kudzulu na dziko lapantsi bzin'dzamala, tsono mafala yangu yan'dzamala lini cipo”. ");
INSERT INTO nyu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ndipo ntsiku na nthawe yace, palibe omwe aniidziwa. Anjo za kudzaulu zin'dziwambo lini. Napo Mwana an'dziwambo lini. Aniidziwa ni Baba ekha basi. ");
INSERT INTO nyu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cenjerani! Khalani wakupenya thangwe mun'dziwa lini nthawe in'dzakwana lini. ");
INSERT INTO nyu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bzin'dzakhala ninga mwenekaciro-nyumba omwe adacoka aciyenda ulendo. Ambasiya bzinthu m'manja mwa akapolo wace, ali-yentse na basa lace, ndipo ambawuza mulindiri kuti akhale wakupenya. ");
INSERT INTO nyu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Khalani wakupenya thangwe mun'dziwa lini nthawe yomwe mwenekaciro wa nyumba an'dzabwera. Penu ni maulo, penu ni pakati pausiku, penu ni congwe wakuyamba, ayai madandakweca. ");
INSERT INTO nyu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kuti angakwanise kudzabwera mwa cisututu, aleke kudzakugumanani mudagona. ");
INSERT INTO nyu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Bzomwe ndiri kulewabzi, ndiri kuwuza mwentse, kuti Khalani mudapenya”. ");
INSERT INTO nyu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zikhadasala ntsiku ziwiri kuti ufike msinda wa Paxkwa na ntsiku yakudya pau yakusaya cakutupisa. Akulu wa azibaba wa ntsembe na adziwi wa Mtemo akhanyang'ana mpata wakuti amphate Jezu mwaciwembo, acimupha. ");
INSERT INTO nyu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tsono akhati: “Bzimwebzi tireke kubzicita panthawe ya cikondwereso kuti mbumba ileke kundzacita phokoso”. ");
INSERT INTO nyu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jezu akhali kuBetanya akhadakhala pameza, munyumba ya Simau nyamapere, adabwera mkazi m'bodzi akhadanyamula ntsupa ya girazi, yamafuta yakununchira yakucokera kumuti wa narido ya ntsengwa ikulu. Mkaziyo adaswa ntsupa ire, acitsanurira mumsolo mwa Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ndipo wanthu winango adaipidwa nabzo aciuzana kuti: “Thangwe ranyi kuyadzonga tenepa mafuta yakununchira? ");
INSERT INTO nyu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Angadayagulisa na ntsengwa yakupitirira kobiri zicena za nzayaya madzana matatu, acikapasa wakusauka” Na tenepo wanthuwo adamfufumira. ");
INSERT INTO nyu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tsono Jezu adati: “Mulekeni mkaziyu, muli kumuneseranyi? Iye wandicitira basa labwino. ");
INSERT INTO nyu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Thangwe wanthu wakusauka munawo nthawe zentse, pomwe mun'funa kuwacitira bza lufoi, mungakwanise kuwacitira. Tsono Ine mun'dzakhala lini nande nthawe zentse. ");
INSERT INTO nyu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Omweyu wacita bzomwe angadakwanisa kucita. Wadzozerau thupi langu likanati kuikhidwa kuthenje. ");
INSERT INTO nyu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cadidi ndiri kukuuzani kuti kuli-kwentse padziko lapantsi komwe kungadzalalikidwe Mafala Yabwino, bzidzafokotozedwambo bzomwe mkaziyu wacita kuti wanthu wamukumbukire”. ");
INSERT INTO nyu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judasi Isikaliyoti, m'bodzi wa wakupfundzira khumi na awiri wale, adayenda kwa akulu wa azibaba wa ntsembe kuti akapereke Jezu kuna iwo. ");
INSERT INTO nyu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pomwe iwo adabva bzimwebzi adakomedwa ndipo adapicira kuti an'dzamupasa kobiri. Pamwepo iye adayamba kunyang'ana mpata kuti apereke Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pantsiku yakutoma ya msinda wa pau zakusaya cakutupisa, ntsiku yomwe wanthu akhambapha mwana wa bira pakucita cikondwereso ca Paxkwa, wakupfundzira wa Jezu adamubvundza kuti: “Kodi tikakukondzereni kuponi mbuto yakudyera uzokoto wa Paxkwa?” ");
INSERT INTO nyu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jezu adatuma awiri mwa wakupfundzira wace, aciwauza kuti: “Ndokoni mumzindamu. Mun'gumana na mwamuna adanyamula mtsuko wa madzi. Mum'tewere. ");
INSERT INTO nyu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ndipo komwe an'kapita, mukauze mwenekaciro wa nyumba kuti: ‘Misiri ali kubvundza kuti, kodi n'ciponi cipinda cangu cakuti ndidzadyere uzokoto wa Paxkwa na wakupfundzira wangu?’ ");
INSERT INTO nyu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Iye an'kakuwonesani cipinda cikulu capadzaulu momwe akondza bzentse, mukatikondzere momwemo”. ");
INSERT INTO nyu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wakupfundzira wale adayenda acipita mumzinda mule. Adabziwona ninga momwe Jezu adawauzira ndipo adakondza bza uzokoto bwa Paxkwa. ");
INSERT INTO nyu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kwatadoka, Jezu adabwera na wakupfundzira wace khumi na awiri wale. ");
INSERT INTO nyu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pomwe akhadakhala pantsi acimbadya, Jezu adati: “Cadidi ndiri kulewa kuti mbodzi mwa imwe, omwe alikudya nande, an'dzandipereka kwa nyamadulanthaka wangu”. ");
INSERT INTO nyu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wakupfundzira adabva acidodoma. M'bodzi na m'bodzi adamubvundza kuti: “Kodi ningakhale ine?” ");
INSERT INTO nyu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jezu adawatawira kuti: “Ni m'bodzi wa khumi na awirimwe omwe ali kuikha boko mundiro pabodzi nande. ");
INSERT INTO nyu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cadidi Mwana-wa-Munthu ali kukaphedwa ninga momwe bzidanembedwa. Tsono ana tsoka omwe an'kapereka Mwana-wa-Munthuyo. Bzikhali bwino kwa munthu umweyo angadasaya kubadwa”. ");
INSERT INTO nyu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ndipo pomwe iwo akhambadya, Jezu adatenga pau, aciidalisa, adagwata-gwata, acipasa wakupfundzira, ndipo adati: “Phatani, iri ni thupi langu”. ");
INSERT INTO nyu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Patsogolo pace adatenga mkombo acidalisa, adaupereka kwa wakupfundzira, acimwa wentse. ");
INSERT INTO nyu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ndipo adawauza kuti: “Uyu ni mulopa wangu wa pangano la kulumbira. Mulopa omweyu ndin'dzawutaya thangwe la wanthu azinji. ");
INSERT INTO nyu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cadidi nin'kuuzani kuti, nin'dzamwa lini cakumwa ca muti wauvaci, mpaka ntsiku yomwe nin'dzamwa cipsa muUmambo bwa Mulungu”. ");
INSERT INTO nyu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ndipo adaimba nyimbo yakulemekeza Mulungu, adacoka aciyenda kuPhiri la Olivera. ");
INSERT INTO nyu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Patsogolo pace Jezu adauza wakupfundzira wace kuti: “Mwentsenemwe usiku buno mun'disiya mucibwerera thangwe bzidanembedwa kuti: ‘Nin'dzapweteka makabusa ndipo mabira yan'dzabalalika.’ ");
INSERT INTO nyu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tsono ndikadzamuka kwa akufa, nin'dzatsogola kuyenda kuGalireya”. ");
INSERT INTO nyu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ndipo Pedru adati: “Napo wentse wakusiyeni acibwerera, ine nibwerera lini cipo”. ");
INSERT INTO nyu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tsono Jezu adamuuza kuti: “Cadidi ndirikukuuza kuti lero usiku buno, congwe akanati kulira kawiri, un'dzandilamba katatu kuti un'ndidziwa lini”. ");
INSERT INTO nyu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pamwepo Pedru adagigimira kuti: “Napo bzicifunika kufa namwe pabodzi, cipo ningadzakulambeni kuti nin'kudziwani lini”. Anangowo wentse adalewabo bzibodzi-bodzi. ");
INSERT INTO nyu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jezu adayenda na wakupfundzira wace kumbuto ibodzi, ikhacemerewa Getsemani. Pomwe adafika, Jezu adauza wakupfundzira wace kuti: “Bakakhalani pano, Ine ndikapembe”. ");
INSERT INTO nyu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jezu adatenga Pedru, Tiyago na Juwau. Iye adayamba kubva mantha makulu acidodoma. ");
INSERT INTO nyu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Adawauza kuti: “Mzimu wangu ngwakudodoma mpaka kufa. Khalani mudapenya pano”. ");
INSERT INTO nyu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Adayenda patsogolo pang'ono, adagodama pantsi, acipemba kuti penu n'bzakukwanisika nthawe yakugoswa ire imupitirire. ");
INSERT INTO nyu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Adapemba kuti: “Aba, Baba, bzinthu bzentse bzingakwanisike kwa imwe. Mucose mkombo wa matsautsoyu kwa ine, tsono lekani kucita bzomwe ine ninfuna, citani cifuniro canu”. ");
INSERT INTO nyu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Atabwerera kuna wakuphunzira wace adawagumana adagona. Ndipo iye adabvundza Pedru kuti: “Simau, uli kugona kodi? Cadidi watazira kukhala udapenya panthawe ibodzi yokha? ");
INSERT INTO nyu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Khalani mudapenya mucimbapemba, kuti muleke kuyezedwa na bzakuipa. Cadidi mzimu uli kufuna, tsono thupi lawofoka”. ");
INSERT INTO nyu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Adayenda pomwe kapemba na mafala mabodzibodzi yale. ");
INSERT INTO nyu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pomwe adabwerera, adawagumana adagona, thangwe bzikhope bzawo bzikhadalemedwa na tulo. Na tenepo iwo adasaya cakumtawira. ");
INSERT INTO nyu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pomwe adabwerera kacitatu, adati: “Kodi muli kugona na kupuma? Bzakwana. Nthawe ire yakwana, Mwana-wa-Munthu ali kukaperekedwa kwa wanthu wakuipa. ");
INSERT INTO nyu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mukani, mbatiyende. Onani wa kundipereka kwa nyamadulanthaka ule, wafika”. ");
INSERT INTO nyu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jezu akanati kumaliza kulewa-lewa, nthawe yomweyo adafika Judasi, m'bodzi wa wakupfundzira khumi na awiri wale. Adabwera na mthithi wa wanthu akhadanyamula bzisenga na mabonga. Wanthuwo adatumidwa na akulu wa azibaba wa ntsembe na adziwi wa Mtemo na akulu wa Ajuda. ");
INSERT INTO nyu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wakudzam'pereka ule akhadawauza cizindikiro ca kuti: “Omwe nin'kapsompsonayo, ngumweyo. Mun'kam'phate mun'ciyenda naye, lekani kamuleka”. ");
INSERT INTO nyu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pomwe Judasi adabwera, adandofika pana Jezu adati: “Misiri!” Ndipo adamumpsompsona. ");
INSERT INTO nyu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ndipo wanthu wale adam'phata Jezu acim'manga. ");
INSERT INTO nyu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tsono mbodzi mwa wakupfundzira omwe akhali naye pamwepo, adasolola cisenga cace, adapweteka wabasa wa mkulu wa azibaba wa ntsembe, ndipo adam'gwata khutu. ");
INSERT INTO nyu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tsono Jezu adawabvundza wanthu wale kuti: “Mwandibwerera na bzisenga na mabonga kudzandimanga ninga ndine mbava? ");
INSERT INTO nyu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ntsiku zentse ndikhakhala namwe ndicimbapfundzisa muNyumba ya Mulungu, imwe nee kundiphata. Tsono bzimwebzi bzakukwanirisa bzomwe bzidanembedwa”. ");
INSERT INTO nyu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pamwepo wakupfundzira wace wentse adamsiya acibwerera. ");
INSERT INTO nyu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mulumbwana m'bodzi akhadafunika ciriya akhatewera Jezu. Wanthu wale akhafuna kuphata, ");
INSERT INTO nyu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","tsono iye adaikopola nguwo ire, acithawa ali pezi. ");
INSERT INTO nyu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ndipo iwo adatenga Jezu aciyenda naye kunyumba ya mkulu wa azibaba wa ntsembe. Kumweko kukhadagumana wentse akulu wa azibaba wa ntsembe na akulu wa Ajuda, na adziwi wa Mtemo. ");
INSERT INTO nyu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedru akhamutewera Jezu na patali, mpaka iye adakapitambo kuseri kwa nyumba ya mkulu wa azibaba wa ntsembe kule. Adakhala pantsi pabodzi na walindiri aciwotha moto. ");
INSERT INTO nyu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Akulu wa azibaba wa ntsembe wale na wentse akulu wa mbuto ikulu ya Ajuda akhanyang'ana umboni wakupasa mulandu Jezu kuti amuphe. Tsono alibe kuuwona. ");
INSERT INTO nyu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Azinji akhambalewa bzakumunamizira. Tsono umboni bwawo bukhabverana lini. ");
INSERT INTO nyu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Winango adaima aciyamba kumbalewa bzakunama, ");
INSERT INTO nyu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","aciti: “Munthu uyu ife tidamubva acimbalewa kuti: ‘Ine nin'dzapfudza Nyumba ya Mulunguyi yakumangidwa na wanthu. Ndipo muntsiku zitatu nin'dzamanga inango yakusaya kumangidwa na wanthu.’ ” ");
INSERT INTO nyu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Napo tenepoyo uboni bwawo bukhabverana lini. ");
INSERT INTO nyu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ndipo mkulu wa azibaba wa ntsembe adaima pamaso pawo, acibvundza Jezu kuti: “Kodi ulibe cakutawira? N'bziponi bzomwe wanthuwa wali kukunamizira?” ");
INSERT INTO nyu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jezu adanyamala. Alibe kudzatawira pomwe. Pamwepo mkulu wa azibaba wa ntsembe ule adabvundza pomwe kuti: “Kodi ndiwe Krixtu Mwana wa Mulungu wakusimbiwa?” ");
INSERT INTO nyu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jezu adatawira kuti: “Inde, ndine. Ndipo mun'dzawona Mwana-wa-Munthu adakhala kuboko ladidi la Mulungu wamphambvu zentse. Mun'dzamuwona ali kubwera m'mitambo yakudzulu”. ");
INSERT INTO nyu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pamwepo mkulu wa azibaba wa ntsembe ule adang'amba bzakubvala bzace, acilewa: “Tin'funiranyi pomwe mboni? ");
INSERT INTO nyu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwabzibvera mwekha kunyoza Mulunguku. Tsono muli kukumbuka tani?” Wentse adalamulira kuti bzin'funika kuti aphedwe. ");
INSERT INTO nyu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Winango adayamba kumupsipira mata acimumpsinkha m'maso acimbam'menya na mafaiti, acimbam'bvundza kuti: “Vima!” Ndipo alindiri wale adayambambo kum'menya na mbama. ");
INSERT INTO nyu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedru akhali panyumba ya pantsi ya mbuto yakutongera mirandu. Padafika Mtsikana m'bodzi kapolo wa mkulu wa azibaba wa ntsembe. ");
INSERT INTO nyu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pomwe adawona Pedru alikuwotha moto, adamuyang'anisisa aciti: “Na iwembo ukhali na Jezu wa kuNazaleyo”. ");
INSERT INTO nyu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tsono Pedru adalamba, adati: “Ndinimudziwa lini, napo bzomwe ulikulewa ndiri kubzidziwa lini”. Ndipo adacoka adayenda m'maseca. Pamwepo congwe adalira. ");
INSERT INTO nyu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ndipo kapolo ule adamuwona aciyamba pomwe kuuza omwe akhali pamwepo kuti: “Umweyu ni m'bodzi wawo”. ");
INSERT INTO nyu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tsono Pedru adalamba pomwe. Thawe pan'gono, wanthu omwe akhali pamwepo adamuuza Pedru kuti: “Cadidi iwepo ndiwe m'bodzi wawo. Thangwe ndiwembo wa kuGalireya”. ");
INSERT INTO nyu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tsono Pedru adayamba kudzitemberera na kulumbira kuti: “Ndinimudziwa lini munthu omwe muli kulewayo”. ");
INSERT INTO nyu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nthawe yomweyo congwe adalira kaciwiri. Ndipo Pedru adakumbukira mafala yomwe Jezu akhadamuuza yakuti: “Congwe akanati kulira kawiri, iwe un'dzandilamba katatu”. Pamwepo Pedru adayamba kulira. ");
INSERT INTO nyu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Macibese-bese, akulu wa azibaba wa ntsembe na akulu wa aJuda na adziwi wa Mtemo, pabodzi na wentse wa mbuto ikulu ya mirandu ya aJuda adasonkhana. Adam'manga Jezu acikamupereka kwa Pirato. ");
INSERT INTO nyu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pirato adambvundza kuti: “Kodi iwe, ndiwe Mambo wa aJuda?” Jezu adamutawira kuti: “Mwalewa ndimwe”. ");
INSERT INTO nyu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Akulu wa azibaba wa ntsembe adayamba kumunamizira bzinthu bzizinji. ");
INSERT INTO nyu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pirato adamubvundza pomwe kuti: “Kodi un'tawira lini? Nyang'ana ni bzinthu bzingasi bzomwe ali kukunamizira”. ");
INSERT INTO nyu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tsono Jezu alibe kudzatawira pomwe, na tenepo Pirato adadabwa kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Panthawe ya cikondwereso ca Paxkwa, Pirato akhambawatsudzulira mkaidi m'bodzi, omwe iwo akhakumbira. ");
INSERT INTO nyu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pakhana m'bodzi wakucemeredwa Barabasi, omwe akhali mukaidi pabodzi na wanthu winango thangwe ra kusandulikira Boma na kupha wanthu. ");
INSERT INTO nyu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ndipo mthithi wa wanthu udabwera, adayamba kukumbira Pilatu kuti awacitire bzomwe akhadazerewera. ");
INSERT INTO nyu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pirato adawabvundza kuti: “Kodi muli kufuna kuti ndikutsudzulireni Mambo wa aJudayu?” ");
INSERT INTO nyu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Adalewa terepo thangwe adadziwa kuti akulu wa azibaba wa ntsembewo adamupereka, thangwe ra njiru. ");
INSERT INTO nyu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tsono akulu wa azibaba wa ntsembewo akhapasa mphambvu mthithi wa wanthu kuti wakumbire kuwatsudzulira Barabasi pambuto pa Jesu. ");
INSERT INTO nyu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ndipo Pirato adawabvundza pomwe kuti: “Tsono mun'funa kuti ndicite ciyani naye omwe muli kuti ni Mambo wa Ajuda?” ");
INSERT INTO nyu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wanthuwo adakuwa pomwe kuti: “M'khomereni pam'tanda!” ");
INSERT INTO nyu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pirato adawabvundza kuti: “Thangwe ranyi? Waphonyanyi?” Tsono iwo adathimizira kukuwa kuti: “Mukhomereni pam'tanda!” ");
INSERT INTO nyu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na tenepo Pirato, pakufuna kukondweresa mthithi wa wanthuwo, adawatsudzulira Barabasi, acilamula kuti Jezu achangidwe. Patsogolo pace adam'pereka kuti akam'khomere pam'tanda. ");
INSERT INTO nyu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pamwepo acikunda adapitisa Jezu kumsasa kuseri kwa nyumba ya mkulu wawo, acikhonceza mthithi wentse wa acikunda andzawo. ");
INSERT INTO nyu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Patsogolo pace adam'bvazika cakubvala cifuira, acikondza nkhata ya minga acimuikha mumsolo. ");
INSERT INTO nyu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Patsogolo pace adayamba kumbam'musa aciti: “Tani moyo, mambo wa aJuda”. ");
INSERT INTO nyu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Acimbamumenya mumsolo na mpsimbo, acimbam'psipira mata, acimbanamizira kum'godamira. ");
INSERT INTO nyu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pomwe adamala kumsinjirira terepoyo, adamucosa cakubvala cire, acim'bvazika pomwe cakubvala cace. Patsogolo pace adam'tenga, aciyenda naye kuti akam'khomere pam'tanda. ");
INSERT INTO nyu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Panjira adagumana na Simau wa kuKhirene baba wa Alexandre na Rufu akhagwata kucokera kumunda. Ndipo acikunda wale adam'kakamiza kuti anyamule m'tanda wa Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Iwo adayenda naye Jezuyo kumbuto ikhacemerewa Golokota, (ndiko kuti “Mbuto ya N'khadzi za Msolo”.) ");
INSERT INTO nyu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Adam'pasa vinyu ina mankhwala yan'cemeredwa mira kuti amwe tsono Iye alibe kutambira. ");
INSERT INTO nyu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ndipo adam'khomera pam'tanda, adagawana bzakubvala bzace. Adacita muvima-vima na nkhakata kuti awone comwe m'bodzi na m'bodzi angadatenga. ");
INSERT INTO nyu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pamwe adamukhomera pam'tanda, zikhali nthawe zipfemba za kumacibese. ");
INSERT INTO nyu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mafala yakulatiza mulandu wakumuphera, akhadayanemba padzaulu pa mtanda tenepa: Mambo wa aJuda. ");
INSERT INTO nyu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pabodzi na Iye pakhadakhomeredwambo akambowa awiri, m'bodzi kuboko ladidi, winango kuboko ladzere. ");
INSERT INTO nyu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na tenepo bzidacitika bzomwe mafala ya Mulungu yadalewa kuti: “Adamuyesa ninga m'bodzi wa wanthu wakuphonya”. ");
INSERT INTO nyu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wanthu omwe akhambagwata na pamwepo akhambamusinjirira, acimbagwededza misolo acimbalewa kuti: “Ha, ndiwe lini iwe ukhambati: ‘Nin'dzapfudza Nyumba ya Mulungu ndicidzaimanga pomwe pantsiku zitatu?’ ");
INSERT INTO nyu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Dzipulumuse, buluka pam'tandapo!” ");
INSERT INTO nyu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Iwombo akulu wa azibaba wa ntsembe akhamuseka, acimbauzana na adziwi wa Mtemo kuti: “Adapulumusa wanthu anango, tsono ataza kudzipulumusa! ");
INSERT INTO nyu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iye akhati ni Krixtu wakulewedwa, Mambo wa aIjirayeri, naabuluke tsono pam'tandapo, kuti tiwone tikhulupirire!” Ndipombo omwe akhadakhomeredwa pabodzi na iye wale akhambamutukanambo. ");
INSERT INTO nyu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kuyambira nthawe ya masikati, padacita mdima padziko lentse mpaka panthawe zitatu za kumawulo. ");
INSERT INTO nyu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ndipo nthawe zitatu za kumawulo, Jezu adakuwa mwa mphambvu kuti: “Eloi, eloi, lama sabakitani?” Ndiko kulewa: “Mulungu wangu, Mulungu wangu, thangwe ranyi mwandisiya?” ");
INSERT INTO nyu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Anango omwe akhadaima pamwepo, adabva mafalayo adati: “Bvani, ali kucemera Eriya”. ");
INSERT INTO nyu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Na tenepo m'bodzi wawo adathamanga acikabviika guntsalinya muvinyu yakuwawisa, acipfikirira kum'tete acimupasira, kuti amwe. Acimbati: “Lekani, tiwone penu Eriyayo an'bwera kudzam'bulusa”. ");
INSERT INTO nyu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ndipo Jezu adakuwa mwa mphambvu, acimalizika. ");
INSERT INTO nyu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Cinguwo ca muNyumba ya Mulungu cidang'ambika kati-na-kati, kuyambira padzaulu mpaka pantsi. ");
INSERT INTO nyu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kapitau wa gulu la acikunda wa ciRoma omwe akhadaima pamwepo acimbam'nyang'anisisa, pomwe adawona kuti Jezu ali kukuwa tenepo acimalizika, adati: “Cadidi, munthuyu akhali Mwana wa Mulungu”. ");
INSERT INTO nyu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Patali na iye pakhana azimai, akhanyang'anisisa. Winango mwa iwo akhali Maliya wa kuMagadala, na Maliya, mai wa Tiyago m'ng'ono na wa Zuze, ndipombo Salome. ");
INSERT INTO nyu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Azimaiwa akhatewera Jezu pomwe Iye akhali kuGalireya, acimbam'tumikira. Akhalipombo azimai winango azinji omwe adayenda naye kuJerusalema. ");
INSERT INTO nyu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kukhadadoka kale. Ndipo cikhali Cixanu, ntsiku yakukondzekera Sabudu, ");
INSERT INTO nyu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ndipo Zuze wa kuArimateya adafika. Akhali mkulu wakudziwika, wa mbuto ikulu ya aJuda. Na iyembo akhadikhira Umambo bwa Mulungu. Ndipo iye adalimba m'tima, aciyenda kwa Pirato kukakumbira kuti am'pase citanda ca Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pirato adadabwa kubva kuti Jezu wafa kale. Na tenepo adacemeresa kapitau wa gulu la acikunda wa ciRoma ule, acimubvundza kuti: “Kodi Jezu wafa kale?” ");
INSERT INTO nyu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mkulu wa acikundayo pomwe adam'tsimikizira bza khaniyo, Pilatu adam'bvumiza Zuze kuti akatenge citandaco. ");
INSERT INTO nyu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zuze adagula nguwo yicena, adabulusa citanda cire acicitsetenga na nguwo ire, aciciikha kucingwidza cakucera pamwala, patsogolo pace adagulumundisa cimwala acifungira pamsuwo. ");
INSERT INTO nyu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya wa kuMagadala ule, na Maliya mai wa Zuze, adawona pomwe adamuikha Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pomwe idapita ntsiku ya malinkhuma ya Ajuda, Maliya wa kuMagadala, na Maliya, mai wa Tiyago, ndipombo Salome adagula mafuta yakununchira kuti akasvingisire citanda ca Jezu. ");
INSERT INTO nyu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Macibese-bese pantsiku ya mdzinga, adayenda kuthenje, dzuwa liri kucoka. ");
INSERT INTO nyu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Akhambabvundzana kuti: “Kodi mbani an'katicosera cimwala ca pamsuwo pathenje pale?” ");
INSERT INTO nyu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ndipo adanyan'gana adawona cimwala cire cikhadagwinyiridwa pambali, pakuti cikhali cikulu. ");
INSERT INTO nyu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Adapita mtenje adawona mulumbwana akhadakhala mbali ya kuboko ladidi, akhadabvala cakubvala cicena. Azimai wale adadzidzimuka. ");
INSERT INTO nyu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ndipo mulumbwana ule adawauza kuti: “Lekani kudzidzimuka. Muli kufuna Jezu wa kuNazalee, omwe adakhomeredwa pam'tanda ule. Wamuka, ali lini muno. Onani, pambuto pomwe akhadamuikha mphapa. ");
INSERT INTO nyu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tsono imwe ndokoni mukauze akupfundzira wace na Pedru, kuti: ‘Iye watsogola kale kuyenda kuGalireya. Mun'kamuwona kumweko, ninga momwe adakuuzirani.’ ” ");
INSERT INTO nyu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Iwo adacoka mwa kakulumize acithawa kuthenjeko, thangwe ra kuti adabva mantha, acimbatetemera. Ndipo thangwe ra manthayo walibe kuuza munthu ali-yentse. ");
INSERT INTO nyu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jezu pomwe adamuka kwa wakufa, macibese ntsiku ya mdzinga ya Ajuda, pakuyamba adawonekera Maliya wa kuMagadala, omwe adam'cosa mizimu yakuipa minomwe ule. ");
INSERT INTO nyu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliyayo adayenda kukauza omwe akhambakhala na Jezu wale. Iwo akhadasunama ndipo akhambalira. ");
INSERT INTO nyu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Napo adabva kuti Jezu ana moyo, ndipo Maliya akhadamuwona, iwo alibe kubvuma. ");
INSERT INTO nyu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Patsogolo pace Jezu, adawonekera na mawonekedwe yanango, kwa wakupfundzira wace awiri, pomwe iwo akhali pakati pa ulendo. ");
INSERT INTO nyu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wakupfundzirawo adabwerera kukauza andzawo, tsono iwo alibe kubvuma. ");
INSERT INTO nyu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pakumalizira Jezu adawonekera wakupfundzira khumi na m'bodzi wale akhambadya. Adawatsimula thangwe ra kusaya kubvuma na kuwuma mtima kwawo, nakuti akhabvuma lini bzomwe akhalewa andzawo omwe akhadamuwona Iye kuti wamuka kwa wakufa. ");
INSERT INTO nyu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ndipo adawauza kuti: “Ndokoni padziko lentse ra pantsi, mukafokotozere wanthu wentse Mafala Yabwino. ");
INSERT INTO nyu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Omwe an'bvuma acibatizidwa, an'dzapulumuka, tsono omwe an'bvuma lini, an'dzapasidwa nyathwa. ");
INSERT INTO nyu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wakukhulupirika an'dzacita bzizindikiro ibzi: An'dzacosa mizimu yakuipa mudzina langu, an'dzalewa-lewa bzirewedwe bzacirendo, ");
INSERT INTO nyu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ndipo an'dzaphata nyoka ayai kumwa bzakumwa bzakupha, an'dzacitiwa lini kuipa. An'dzaikha manja pa wakudwala iwo acidzalimba”. ");
INSERT INTO nyu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pomwe adandomala kulewa-lewa nawo Mbuya Jezu, adatengedwa kuyenda Kudzulu, acikhala kuboko ladidi la Mulungu. ");
INSERT INTO nyu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ndipo wakupfundzira wale adayenda acifokotoza mafala yabwino kwentse-kwentse. Mbuya akhaphata basa pabodzi nawo, ndipo akhambatsimikiza mafalayo na bzizindikiro bzomwe akhacita.");
INSERT INTO nyu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Azinji adayezera kale kunemba mbiri ya bzinthu bzomwe bzidacitika pakati pathu, ");
INSERT INTO nyu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","malinge na momwe tidauzidwa na wale omwe adawona na maso, omwe ni atumiki wa mafala. ");
INSERT INTO nyu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ine letu ndidafufudza bzentse mwacheru, kuyambira pakutoma ndipo ndidakumbuka kukunemberani mwa m'dondomeko imwe wakulemekezeka Teofilo, ");
INSERT INTO nyu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kuti mudziwisise cadidi ca bzinthu bzomwe mudapfundzisidwa. ");
INSERT INTO nyu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Panthawe yomwe Herodi akhali mambo wa kuJudeya, pakhana baba wa ntsembe wakucemeredwa Zakaliya, omwe akhali wa gulu la anyantsembe la Abiya ndipo mkazi wace, Zabere akhali wa dzindza la Alau. ");
INSERT INTO nyu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pa uwiri bwawo akhali wakulungama patsogolo pa Mulungu, ndipo akhateweza bwino mitemo na bzakutonga bzentse bza Mbuya mwakusaya kutsimulidwa. ");
INSERT INTO nyu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tsono akhalibe wana, thangwe Zabere akhabereka lini. Ndipo awiriwo akhadakalamba. ");
INSERT INTO nyu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ntsiku inango, Zakaliya akhacita basa lace la ubaba bwa ntsembe patsogolo pa Mulungu, nakuti ikhali nthawe ya gulu lace. ");
INSERT INTO nyu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Iye adasankhulidwa mwakucita mayere malinge na cizolowezi ca untsembe, kuti apite mumbuto yakucena ya Mbuya ndipo akapereke ntsembe zakutentha zakununcira bwino. ");
INSERT INTO nyu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Yatakwana nthawe yakutentha ntsembe yakununchira, mbumba yentse ikhapemba kunja. ");
INSERT INTO nyu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pamwepo anju wa Mulungu adawonekera kuna Zakaliya, kumbali ya madidi ya guwa la ntsembe yakununcirayo. ");
INSERT INTO nyu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pomwe Zakaliya adamuwona anju ule, adadzidzimuka ndipo adadzala na mantha. ");
INSERT INTO nyu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tsono anju ule adamuuza kuti: Zakaliya! Leka kubva mantha. Mpembo wako wabvedwa. Mkazi wako Zabere an'dzakubalira mwana wa mwamuna, ndipo iwe un'dzamupasa dzina lakuti Juwau. ");
INSERT INTO nyu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iye an'dzacitisa kuti ukomedwe na kudzakondwa ndipo wanthu azinji an'dzakomedwambo na kubadwa kwace, ");
INSERT INTO nyu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","nakuti an'dzakhala mkulu pamaso pa Mbuya. Iye an'dzamwa lini vinyu napo cakumwa cinango cakuledzeresa. Ndipo an'dzakhala wakudzazidwa na Mzimu Wakucena akanati kubadwa. ");
INSERT INTO nyu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iye an'dzabweresa pomwe wanthu wa kuIjirayeri kuna Mbuya Mulungu wawo. ");
INSERT INTO nyu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iye an'dzabakapita kutsogolo kwa Mbuya mumzimu na mumphambvu za Eriya, kuti adzabwezere mitima ya azibaba kuna wana wawo, ndipo wakusaya kubvera kuti adzakhale na udziwi bwa wakulungama, kuti asiye mbumba idakondzekera kuna Mbuya. ");
INSERT INTO nyu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ndipo Zakaliya adabvundza anju ule kuti: “Ningadziwe tani kuti bzimwebzi ni bzacadidi? Nakuti ine-pano ndine nkhalamba ndipo mkazi wanguyu ana magole mazinji”. ");
INSERT INTO nyu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anju adamutawira aciti: “Ndine Gabiriyeri, omwe nthawe zentse ali pabodzi na Mulungu. Ndatumidwa kuti ndidzakuuze mafala yabwinoya. ");
INSERT INTO nyu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tsapano iwepo un'dzakhala bewewe. Un'dzakwanisa lini kulewa-lewa mpaka ntsiku yomwe bzin'dzacitika bzomwe ndalewabzi, thangwe ulibe kubvuma mafala yangu yomwe yan'dzakwanirisidwa Panthawe yace”. ");
INSERT INTO nyu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pomwe bzimwebzi bzikhacitika, wanthu akhadikhira Zakaliyayo, acimbadabwa nakucedwa kwace mumbuto yakucena. ");
INSERT INTO nyu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pomwe iye adabula alibe kukwanisa kulewa cinthu, ndipo mbumba idadziwa kuti iye adawona maso-mphenya mumbuto yakucena. Zakaliya akhambalewa-lewa nawo mwa kulata-lata na manja, ndipo akhapitiriza kukhala bewewe. ");
INSERT INTO nyu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pomwe ntsiku zace za basa zidamala, iye adabwerera kumui. ");
INSERT INTO nyu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Zatapita ntsiku zimwezo, mkazi wace Zabere adatenga mimba, ndipo mkati mwa minyezi mixanu alibe kucoka panyumba. ");
INSERT INTO nyu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ndipo iye akhambati: “Ibzi ni basa la Mbuya! Tsapano wandicitira cifundo, kuti acose manyazi yangu pakati pa mbumba”. ");
INSERT INTO nyu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ndipo pa mwezi wacitanthatu, Mulungu adatuma anju Gabiriyeri kumzinda wa Nazareta cigawo ca Galireya. ");
INSERT INTO nyu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Komweko kukhana dende lomwe likhadikhira malowozi na mwamuna omwe akhacemeredwa Zuze, wa dzindza la Davide. Dendelo likhacemeredwa Maliya. ");
INSERT INTO nyu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anju ule adafendera pana Maliya ndipo adati: “Kondwera, wapasidwa nkhombo! Mbuya ali na iwepo!” ");
INSERT INTO nyu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliya adaneseka kwene-kwene na mafala yamweya, acimbakumbukira kuti mamusanoyo yakhalewanyi. ");
INSERT INTO nyu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tsono anju ule adamuuza kuti: “Maliya! Leka kubva mantha! Iwepo wapasidwa nkhombo na Mulungu! ");
INSERT INTO nyu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Iwepo un'dzakhala na pathupi ndipo un'dzabala mwana wacimuna, ndipo un'dzam'pasa dzina lakuti Jezu. ");
INSERT INTO nyu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iye an'dzakhala mkulu ndipo an'dzacemeredwa kuti Mwana wa Iye Wakudzulu-dzulu. Mbuya Mulungu an'dzam'pasa mpando wa kholo lace Davide, ");
INSERT INTO nyu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ndipo iye an'dzatonga mwakusaya kumala mbumba ya Jakobo. Umambo bwace bun'dzamala lini cipo”. ");
INSERT INTO nyu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliya adabvundza anju ule aciti: “Kodi bzin'dzacitika tani bzimwebzi? Pakuti ndikali dende?”. ");
INSERT INTO nyu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ndipo anju adamutawira aciti: “Mzimu Wakucena un'dzabuluka ucibwera kuna iwe, ndipo mphambvu za Wakudzulu-dzulu zin'dzakumpsinkha na mtundzi wace. Na tenepo, ule omwe an'dzabadwa an'dzacemeredwa wakucena, ndipo Mwana wa Mulungu. ");
INSERT INTO nyu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Napombo m'bale wako Zabere, an'dzakhala na mwana atakalamba. Ule omwe akhambalewa kuti anbala lini, ana kale pathupi pa minyezi mitanthatu. ");
INSERT INTO nyu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nakuti kuna Mulungu palibe comwe cingatazike”. ");
INSERT INTO nyu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maliya adatawira aciti: “Ndine nyagirinya wa Mbuya. Mbabzicitike kuna ine malinge na momwe mwalewera”. Ndipo anju ule adayenda acimusiya. ");
INSERT INTO nyu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pantsiku zomwezire, Maliya adakondzeka ndipo adayenda mwa kamkulumize mzinda omwe ukhali kumphimpa ya mapiri ya kuJudeya, ");
INSERT INTO nyu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","komwe adakapita munyumba ya Zakaliya ndipo adamusa Zabere. ");
INSERT INTO nyu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pomwe Zabere adabva mamuko ya Maliya, mwana omwe akhali m'mimba mwace adapfukunyuka, ndipo Zabere adadzazidwa na Mzimu Wakucena. ");
INSERT INTO nyu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Adakuwa aciti: “Wakusimbidwa ndiwe pakati pa akazi, ndipo wakusimbidwa ni mwana omwe iwepo un'dzabala! ");
INSERT INTO nyu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tsono ndine yani ine kuti mayi wa Mbuya wangu adzandizungire? ");
INSERT INTO nyu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pomwe ndandobva kundimusa kwanu, mwana omwe ali m'mimba mwangu wapfukunyuka na kukondwa. ");
INSERT INTO nyu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Wakudala ni ule omwe adatawira kuti bzin'dzacitika bzomwe Mbuya adalewa”. ");
INSERT INTO nyu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ndipo Maliya adalewa kuti: “M'tima wangu uli kutumbiza Mbuya, ");
INSERT INTO nyu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ndipo mzimu wangu uli kukondwa mwa Mulungu, Mpulumusi wangu. ");
INSERT INTO nyu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Thangwe iye wawona kubzicesva kwa nyagirinya wace. Kuyambira tsapano kuyenda kutsogolo, mibadwe yentse in'dzandicemera wakusimbidwa, ");
INSERT INTO nyu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nakuti Wamphambvu-zentse wandicitira bzinthu bzikulu, dzina lace wakucena. ");
INSERT INTO nyu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ntsisi zace zimbayenda kwa wale omwe anim'gopa, kwa mibadwe na mibadwe. ");
INSERT INTO nyu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iye adacita bzinthu bzamphambvu na boko lace, adabalalisa wakusamwa mumitima mwawo. ");
INSERT INTO nyu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Adagwesa wakutonga pamipando yawo, tsono adakwiza wakubzicepesa. ");
INSERT INTO nyu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Adapasa bzinthu bzabwino omwe ana njala, tsono nyakudala adawayendesa cimanja-manja. ");
INSERT INTO nyu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Adathandiza nyagirinya wace Ijirayeri, acikumbukira cifundo cace ");
INSERT INTO nyu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kuna Abrahamu na bzizukulu bzace kwa kuyenda na kuyenda, ninga momwe adalewera kuna makolo yathu”. ");
INSERT INTO nyu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliya adakhala na Zabere minyezi mitatu, patsogolo pace adabwerera kumui. ");
INSERT INTO nyu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pomwe zidakwana ntsiku zakuti Zabere abale, adabala mwana mwamuna. ");
INSERT INTO nyu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wanthu wa pafupi na abale wace adakondwa pomwe adabva kuti Mbuya adamubvera ntsisi. ");
INSERT INTO nyu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pomwe idakwana ntsiku yacisere, wanthu adayenda kuti akamucite msinda wa mgwato mwanayo, ndipo akhafuna kum'pasa dzina la baba wace, Zakaliya. ");
INSERT INTO nyu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tsono mai wace adalewa kuti: “Nee, ati achemeredwe Juwau”. ");
INSERT INTO nyu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ndipo iwo adamuuza kuti: “Iwepo ulibe m'bale na m'bodziyo ana dzina limweri”. ");
INSERT INTO nyu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pamwepo adabvundza baba wace na manja kuti adziwe dzina lomwe babayo akhafuna kupasa mwana wace. ");
INSERT INTO nyu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ndipo iye adakumbira katabwa acinemba kuti: “Dzina lace ni Juwau”. Na tenepo wanthu wentse adadabwa. ");
INSERT INTO nyu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Panthawe imweyo letu, mulomo wace udafunguka na lirime lace licitsudzuka. Ndipo iye adayamba kulewa-lewa, acisimba Mulungu. ");
INSERT INTO nyu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na tenepo wanthu wentse wa pafupi wace adadzala na mantha. Ndipo mbali yentse ya mapiri ya kuJudeya akhambalewa bza nkhani imweyi. ");
INSERT INTO nyu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wanthu wentse omwe akhaibva akhambaikoya mumtima, acimbabzibvundza kuti: “Kodi mwana omweyu an'dzakhala yani?” Nakuti boko la Mulungu likhali naye. ");
INSERT INTO nyu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ndipo baba wace Zakaliya, adadzazidwa na Mzimu Wakucena, acicita cipolofita adati: ");
INSERT INTO nyu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Wakusimbidwa ndiye Mbuya, Mulungu wa kuIjirayeri, thangwe adazungira ndipo adalombola mbumba yace. ");
INSERT INTO nyu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Iye adabweresa cipulumuso cakulimba kuna ife, ku dzindza la mtumiki wace Davidi, ");
INSERT INTO nyu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ninga momwe adalewera kudzera kwa apolofita wace wakucena, kale-letu, ");
INSERT INTO nyu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","acitipulumusa kuna anyamadulanthaka wathu na mumanja mwa wentse omwe an'tiwenga. ");
INSERT INTO nyu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kuti awonese ntsisi zace kuna makolo yathu, ndipo akumbuke cipangano cace cakucena, ");
INSERT INTO nyu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","na lumbiro lomwe adacita kuna baba wathu Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kutilombola mumanja mwa anyamadulanthaka wathu, kuti timutumikire mwakusaya mantha, ");
INSERT INTO nyu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mwakucena na mwakulungama pantsogolo pace ntsiku zathu zentse. ");
INSERT INTO nyu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ndipo iwe mulumbwana, un'dzacemeredwa mpolofita wa Kudzulu letu, Nakuti un'dzapita patsogolo pa Mbuya, kuti ukamukondzere njira, ");
INSERT INTO nyu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kuti akapase mbumba yace cidziwiso ca cipulumuso, kudzera pakulekeredwa bzitazo bzawo, ");
INSERT INTO nyu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Thangwe ra ntsisi zikulu, za Mulungu wathu, kudzera mwa nstisizo, kudzulu kun'dzatumiza dzuwa, kucokera kumabva dzuwa, ");
INSERT INTO nyu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kuti abvunikire wale omwe ali mumdima, na pamthundzi wa impfa, acitsogolera minyendo yathu munjira ya mtendere”. ");
INSERT INTO nyu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ndipo mulumbwanayo akhakula acimbalimba mumzimu. Ndipo adakhala mucidambo mpaka kukabziwonesa padeca kuIjirayeri. ");
INSERT INTO nyu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pantsiku zomwezire Seza Aguxto adapereka Mtemo padeca wakuti mbumba ya utongi bwa ciRoma yentse inemberedwe. ");
INSERT INTO nyu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ndipo kanembera wakutomayo adacitika pomwe Kerino akhali mtongi wa kuSiriya. ");
INSERT INTO nyu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wanthu wentse adayenda kukabzinembesa m'bodzi na m'bodzi kumzinda komwe adabadwira. ");
INSERT INTO nyu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ndipombo Zuze adacoka kumzinda wa Nazareta, cigawo ca Galireya, acikwira ku Judeya mzinda wa Davidi, wakucemeredwa Belee, nakuti akhali wa nyumba na dzindza la Davide, ");
INSERT INTO nyu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","kuti akanembedwe pabodzi na Maliya omwe akhadamubvundzira ndipo akhana mimba. ");
INSERT INTO nyu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pomwe iwo akhali kumweko, ntsiku zakuti abale zidakwana. ");
INSERT INTO nyu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ndipo iye adabala mwana wace wakuyamba, adamuvunyizira panguwo, acimugonesa mucakudyera bzifuwo, thangwe mukhalibe mbuto yakuti akhale munyumba ya alendo. ");
INSERT INTO nyu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ndipo kumphimpha imweire kukhana amakabusa omwe akhakhala kumweko, akhalindira bzifuwo bzawo usiku. ");
INSERT INTO nyu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ndipo bzidawoneka kuti anju m'bodzi wa Mbuya, adayenda kuna iwo ndipo ukulu bwa Mbuya udabvunika mumbali mwawo. Ndipo iwo adabva mantha kwene-kwene. ");
INSERT INTO nyu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tsono anjuyo adawauza kuti: “Lekani kubva mantha! Ndadzakuuzani nkhani yabwino yakukondweresa kukulu kuna wanthu wentse. ");
INSERT INTO nyu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nakuti lero lino kumzinda wa Davide, kwabadwa mpulumusi omwe ni Krixtu, Mbuya. ");
INSERT INTO nyu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Comwe mun'kamuzindikira naco ni ici: Mun'kawona mwana adavunyizira panguwo adagonesa mwakudyera bzifuwo”. ");
INSERT INTO nyu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mwacisututu, padawoneka mthithi ukulu wa acikunda wakudzulu pabodzi na anju, acimbatumbiza Mulungu, aciti: ");
INSERT INTO nyu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ulemerero kuna Mulungu wakudzulu, ndipo mtendere pantsi kuna wanthu omwe iye adapasa nkhombo zace”. ");
INSERT INTO nyu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pomwe anju wale adabwerera kudzulu, amakabusa adalewa m'bodzi na mwandzace kuti: “Mbatiyende kuBelee, ndipo tikawone bzacitikabzi, bzomwe Mbuya watidziwisa”. ");
INSERT INTO nyu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ndipo iwo adayenda na kamkulumize, acikamuwona Maliya na Zuze, na mwanayo adagonesa mucakudyeseramo. ");
INSERT INTO nyu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ndipo atamuwona, adauza wentse bzomwe akhadauzidwa pa cipande ca mwanayo. ");
INSERT INTO nyu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ndipo wentse omwe adabva bzomwe amakabusa adalewa, adakhala wakudabwisidwa. ");
INSERT INTO nyu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ndipo Maliya adakoya mafala yentseneyo ndipo acimbayakumbukira mum'tima mwace. ");
INSERT INTO nyu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Amakabusa adabwerera acimbakuza na kutumbiza Mulungu thangwe la bzentse bzomwe akhadawona na kubva, ninga momwe akhadauzidwa. ");
INSERT INTO nyu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pomwe ntsiku zisere zidakwana kuti mwanayo acitiridwe msinda wa mgwato, adapasidwa dzina lakuti Jezu, lomwe akhadapasidwa kale na anju Iye akanati kubadwa. ");
INSERT INTO nyu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nthawe ya msinda wakucenesedwa kwawo yatakwana, malinge na Mtemo wa Mozeji, Zuze na Maliya adatenga mwanayo aciyenda naye kuJerusalema kuti akamupereke kuna Mbuya, ");
INSERT INTO nyu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nakuti bzidanembedwa muMtemo wa Mbuya kuti: “Mwana wakuyamba kubadwa wacimuna bzin'funika kuti adzaperekedwe kwa Mbuya”, ");
INSERT INTO nyu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ndipo kuti akaperekembo ntsembe ninga momwe ukhalewera Mtemo wa Mbuya kuti: “Njiwa ziwiri ayai nkhangaiwa ziwiri”. ");
INSERT INTO nyu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","MuJerusalemamo mukhana munthu omwe akhacemeredwa kuti Simiyau, iye akhali wakulungama ndipo wakulemekeza Mulungu, iye akhadikhira kudzapepesedwa kwa Ijirayeri. Ndipo Mzimu Wakucena ukhana iye. ");
INSERT INTO nyu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Akhadadziwisidwa na Mzimu Wakucena kuti iye an'dzafa lini akanati kuwona Krixtu wa Mbuya. ");
INSERT INTO nyu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mwakutsogoleredwa na Mzimu, iye adayenda kunyumba ya Mulungu. Pomwe azibaba wa mulumbwana Jezu adam'bweresa kudzamcita bzomwe bzikhafunika na Mtemo, ");
INSERT INTO nyu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ndipo Simiyau adatambira mwanayo mmanja mwace acitenda Mulungu aciti: ");
INSERT INTO nyu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tsapano Mbuya, momwe mudapicira, tsapano mungagoneke mwa mtendere mtumiki wanu. ");
INSERT INTO nyu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nakuti maso yangu yawona cipulumuso canu, ");
INSERT INTO nyu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","comwe mudakondza pamaso pa mbumba yentse. ");
INSERT INTO nyu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ni ceza cakuwonesa wanthu wakunja ndipo na mbiri kwa mbumba yanu Ijirayeri”. ");
INSERT INTO nyu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Baba na mai wa mwanayo adadabwa na bzomwe adauzidwa bza cipande ca iye. ");
INSERT INTO nyu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ndipo Simiyau adawadalisa aciuza Maliya mai wa Jezu kuti: “Mwana umweyu adalatidwa kuti adzapfudze napo kudzalamusira azinji kuIjirayeri, ndipo an'dzakhala cizindikiro comwe azinji an'dzaciwenga, ");
INSERT INTO nyu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","mwakuti bzakukumbuka bza azinji bzin'dzawonesedwa. Tsono kusukwala, ninga cisenga cakuthwa kun'dzagwata mtima wako Maliya”. ");
INSERT INTO nyu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Akhalipombo mpolofita wacikazi dzina lace akhali Yana, mwana wa Faniwere wa dzindza la Aseri. Akhali wacikulire. Akhadakhala pa banja na mamuna wace magole manomwe (7) kuyambira pomwe adalowolana ");
INSERT INTO nyu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ndipo adadzakhala mamsiwa mpaka kupfitsa magole makumi masere na manai (84). Akhacoka lini cipo munyumba ya Mulungu, akhatumbiza Mulungu acimbabzimana kudya na kumbacita mipembo usiku na masikati. ");
INSERT INTO nyu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ndipo atafika pamwepo panthawe caiyoyo, adatenda Mulungu acilewa bza mwanayo kuna wentse omwe akhadikhira kupulumusidwa kwa Jerusalema. ");
INSERT INTO nyu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pomwe adamala kucita bzentse bzomwe bzikhafunidwa na Mtemo wa Mbuya, iwo adabwerera kumzinda wawo, Nazareta cigawo ca Galireya. ");
INSERT INTO nyu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ndipo mulumbwanayo akhakula acimbalimba, acimbakhala na ndzeru ndipo Mulungu akhamusimba. ");
INSERT INTO nyu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ndipo magole yentse azibaba wace akhambayenda kuJerusalema kucikondweso ca Paxkwa. ");
INSERT INTO nyu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Pomwe iye adakwanisa magole khumi na mawiri (12), Iwo adayenda kucikondwereso, nakuti ukhali msambo wawo. ");
INSERT INTO nyu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pomwe cidamala cikondweso, azibaba wace pakubwerera kumui, mulumbwana Jezu adasala kuJerusalema, mwakusaya kudziwika na iwo. ");
INSERT INTO nyu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Akhakumbuka kuti alikubwera na andzace wa ulendo, ndipo adafamba ntsiku yentse. Pamwepo adayamba kumunyang'ana pakati pa azibaba na kwa anantsi, ");
INSERT INTO nyu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tsono adamusaya, acibwerera pomwe kuJerusalema kukamunyang'ana. ");
INSERT INTO nyu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ndipo zatapita ntsiku zitatu (3), iwo adakam'bulukira munyumba ya Mulungu, akhali pakati pa adziwi wa Mtemo, acimbawatetekera na kuwapasa mibvundzo. ");
INSERT INTO nyu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wentse omwe akhamubva akhadabwa na ndzeru zace na katawiridwe kace. ");
INSERT INTO nyu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pomwe azibaba wace adamuwona, adadabwisidwa. Mai wace adati: “Nandi mwanangu, thangwe ranyi waticita tenepa? Ine-pano na baba wako tikhadadodoma tikhakunyang'ana”. ");
INSERT INTO nyu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iye adawabvundza kuti: “Thangwe ranyi imwepo mukhandinyang'ana? Kodi mun'dziwa lini kuti bzin'funika kuti ndikhale munyumba mwa Baba wangu?” ");
INSERT INTO nyu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tsono iwo alibe kubvesesa bzomwe akhawauza. ");
INSERT INTO nyu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pamwepo adapolika nawo kuNazareta. Ndipo iye akhambawabvera. Tsono mai wace akhabzikoya bzentsenebzo mum'tima mwace. ");
INSERT INTO nyu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ndipo Jezu akhakula pandzeru, pamsinkhu ndipo na nkhombo patsogolo pa Mulungu na pawanthu. ");
INSERT INTO nyu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pagole khumi na lacixanu la utongi bwa mambo Tiberiyo Sezar, nthawe imweyo, Pontsiyo Pirato akhali mtongi mkulu wa cigawo ca Judeya. Herodi akhali mtongi mkulu wa cigawo ca Galireya ndipo m'bale wace Filipi akhali mtongi mkulu wa cigawo ca Ituleya na kuTalakoniti. Ndipo Lizanya akhali mtongi mkulu wa cigawo ca Abirene. ");
INSERT INTO nyu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hanasi na Khefasi akhali akulu-akulu azibaba wa ntsembe. Ndiro gole lomwe, Mulungu adalewa na Juwau, mwana wa Zakaliya, mucidambo. ");
INSERT INTO nyu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ndipo Juwau adayenda mbali yentse ya pafupi na Jolodani, acipalidza kubatizidwa kwa kukhumbula kuti ulekereredwe bzitazo. ");
INSERT INTO nyu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ninga momwe bzidanembedwa mulivu la m'polofita Izaiya lidati: “Fala liri kulewa mucidambo kuti: ‘Kondzani mseu wa Mbuya, lungamisani msewuyo kuti adzapitire. ");
INSERT INTO nyu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bzigwa bzentse bzin'dzafuchiridwa, ndipo mapiri yentse na tumitunthu bzin'dzayalazidwa. Njira zakugonyoka zin'dzalungamizidwa ndipo njira zakucereka-cereka, zin'dzayalasidwa. ");
INSERT INTO nyu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wanthu wentse an'dzawona cipulumuso ca Mulungu’ ”. ");
INSERT INTO nyu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ndipo Juwau akhawauza mithithi yomwe ikhabwera kudzabatizidwa na iye akhati: “Wana wa nyoka! Mbani wakupasani ndzeru yakuthawa ukali bomwe bulikubwera? ");
INSERT INTO nyu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Citani bzinthu bzinilatiza kuti mwakhumbula. Ndipo lekani kulewa mwekha kuti: ‘Abrahamu ni baba wathu’. Tsono ine nin'kukuuzani kuti Mulungu angasanduse minyalayi kuti ikhale wana wa Abrahamu. ");
INSERT INTO nyu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mbadzo yaikhidwa kale pamuzi wa miti, ndipo muti wentse omwe un'bala lini bzisapo bzabwino, un'dzagwatidwa ucithusidwa pamoto”. ");
INSERT INTO nyu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ndipo mthithi ikhabvundza iciti: “Ticite tani tsono?” ");
INSERT INTO nyu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ndipo Juwau adawatawira kuti: “Ule ana bzakubvala bziwiri apasembo cibodzi omwe alibe-letu, napo ule omwe ana cakudya acite bzibodzi-bodzibzo”. ");
INSERT INTO nyu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Anyakupimisa mtsonkho adabwerambo kuti adzabatizidwe, ndipo iwo adam'bvundza kuti: “Misiri, kodi ni ciyani comwe ticite?” ");
INSERT INTO nyu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Iye adawatawira aciti: “Lekani kupimisa bzizinji kuposa bzomwe bzidalewedwa”. ");
INSERT INTO nyu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ndipo acikunda adam'bvundzambo kuti: “Kodi ife ticite ciyani?” Iye adawatawira aciti: “Lekani kutengera bzinthu wanthu mwakumugosva, napo kuwanamizira mulandu. Kondwerani na malipiro yomwe mun'tambira pamwezi”. ");
INSERT INTO nyu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ndipo mbumba ikhana cikhulupiro cikulu, icimbabzibvundza mumtima mwayene kuti kodi Juwau ndiye lini Krixtu umweyu. ");
INSERT INTO nyu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ndipo Juwau adatawira wentse aciti: “Ine nin'kubatizani na madzi. Tsono, alikubwera mkulu kuposa ine, omwe nin'themera lini kutsudzula nthambo za xango zace, umweyo an'dzakubatizani na Mzimu Wakucena na moto. ");
INSERT INTO nyu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iye ana focholo m'manja mwace, kuti adzawangule munda acigwezeka tirigu mugwangwa. Tsono mungu an'dzatentha na moto wakusaya kuthima”. ");
INSERT INTO nyu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ndipo Juwau akhambacenjeza mbumba na mafala yanango mazinji ndipo akhambawapalidzira mafala yabwino. ");
INSERT INTO nyu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ndipombo iye adatsimula Herodi mtongi mkulu, thangwe ra kutenga Herodiyasi, mkazi wa m'bale wace, napombo nakufuna kwa bzinthu bzinango bzakuipa bzomwe Herodi akhadacita. ");
INSERT INTO nyu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodi adathimizira mathangwe yace pomwe adatenga Juwau acimuikha m'kawoko. ");
INSERT INTO nyu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pomwe mbumba yentse ikhabatizidwa, Jezu adabatizidwambo. Ndipo pomwe Iye akhapemba, kudzulu kudafunguka, ");
INSERT INTO nyu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ndipo Mzimu Wakucena udabuluka na thupi ninga nkhangaiwa. Pamwepo fala lidabveka kudzulu liciti: “Iwepo ndiwe Mwanangu wapamtima. Nimbakomedwa nawe”. ");
INSERT INTO nyu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jezu akhana magole makumi matatu pomwe adayamba basa lace. Iye akhali ninga momwe akhakumbukira, mwana wa Zuze. Ndipo Zuze akhali mwana wa Eri, ");
INSERT INTO nyu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mwana wa Matati, mwana wa Levi, mwana wa Mereki, mwana wa Janai, mwana wa Zuze, ");
INSERT INTO nyu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mwana wa Matatiasi, mwana wa Amosi, mwana wa Naumi, mwana wa Esiri, mwana wa Nagai, ");
INSERT INTO nyu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwana wa Maati, mwana wa Matatiasi, mwana wa Simei, mwana wa Zuzeki, mwana wa Joda, ");
INSERT INTO nyu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mwana wa Juwana, mwana wa Leza, mwana wa Zolobaberi, mwana wa Salatiyeri, mwana wa Neri, ");
INSERT INTO nyu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana wa Meleki, mwana wa Adi, mwana wa Kozami, mwana wa Erimadami, mwana wa Eri, ");
INSERT INTO nyu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwana wa Jozuwe, mwana wa Eriyezeri, mwana wa Jolimi, mwana wa Matati, mwana wa Levi, ");
INSERT INTO nyu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mwana wa Simioni, mwana wa Juda, mwana wa Zuze, mwana wa Jonami, mwana wa Eriyakimi, ");
INSERT INTO nyu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mwana wa Mereya, mwana wa Minani, mwana wa Matati, mwana wa Natani, mwana wa Davide, ");
INSERT INTO nyu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwana wa Jesi, mwana wa Obedi, mwana wa Bwazi, mwana wa Sala, mwana wa Nasomi, ");
INSERT INTO nyu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mwana wa Aminadabi, mwana wa Dimimi, mwana wa Alini, mwana wa Heziramu, mwana wa Perezi, mwana wa Juda, ");
INSERT INTO nyu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwana wa Jakobo, mwana wa Izaki, mwana wa Abrahamu, mwana wa Tera, mwana wa Nakoli, ");
INSERT INTO nyu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwana wa Saluki, mwana wa Lagau, mwana wa Faleki, mwana wa Ibero, mwana wa Sala, ");
INSERT INTO nyu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mwana wa Kainani, mwana wa Alufaxadi, mwana wa Semi, mwana wa Nowa, mwana wa Lameki ");
INSERT INTO nyu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwana wa Matusala, mwana wa Enoki, mwana wa Jaledi, mwana wa Malalero, mwana wa Kainani, ");
INSERT INTO nyu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mwana wa Inosi, mwana wa Seti, mwana wa Adamu, omwe akhali mwana wa Mulungu. ");
INSERT INTO nyu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jezu, mwakudzazidwa na Mzimu Wakucena, adabwerera kucokera kumkulo wa Jolodani, ndipo adatsogoleredwa na Mzimuyo aciyenda kucidambo, ");
INSERT INTO nyu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","komwe adakayezeredwa na Dyabu, mkati mwa ntsiku makumi manai (40). Ntsiku zimwezo alibe kudya cinthu ciri-centse, ndipo zatamala ntsikuzo Iye adabva njala. ");
INSERT INTO nyu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dyabu adamuuza kuti: “Penu ndiwe mwana wa Mulungu, uza mwalayu kuti usanduke pau”. ");
INSERT INTO nyu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tsono Jezu adamutawira aciti: “Bzidanembedwa kuti: ‘Munthu an'dzacira lini na pau yokha’ ”. ");
INSERT INTO nyu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dyabu adamutenga acikwira naye padzulu-letu, ndipo mwacisututu adamulatiza umambo bwa dziko lentse la pantsi. ");
INSERT INTO nyu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Adamuuza kuti: “Ine nin'dzakupasani utongi bumwebu na ukulu bwa dziko lentse la pantsi, thangwe ndidapasidwa ndipo ningapasembo omwe nin'funa. ");
INSERT INTO nyu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ndipo ukandipemba, bzentsenebzi bzindzakhala bzako”. ");
INSERT INTO nyu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jezu adamutawira kuti: “Bzidanembedwa kuti: ‘Udzatumbize Mbuya, Mulungu wako, ndipo udzapembe iye yekha’ ”. ");
INSERT INTO nyu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ndipo Dyabu adamutenga aciyenda naye kuJerusalema, adakwira naye pakatolo-tolo pa Nyumba ya Mulungu acimuuza kuti: “Penu ndiwe Mwana wa Mulungu, bzithuse kucokera pano mpaka pantsi. ");
INSERT INTO nyu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nakuti bzidanembedwa kuti: “ ‘Iye an'dzatumiza anju wace kuna iwe, kuti adzakukhocherere. ");
INSERT INTO nyu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Iwo an'dzakuyakha m'manja kuti udzasaye kupwetekeka pamwala uli-wentse’”. ");
INSERT INTO nyu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jezu adatawira kuti: “Bzidalewedwa kuti ‘Leka kuyeza Mbuya, Mulungu wako’”. ");
INSERT INTO nyu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Atamala kucita miyezo yentseneyi, Dyabu adafundukira mpaka nthawe inango. ");
INSERT INTO nyu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jezu adabwerera kuGalireya mumphambvu ya Mzimu Wakucena, ndipo mbiri yace idamwazikira kumii yentse ya mphimpha imweire. ");
INSERT INTO nyu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iye akhapfundzisa m'nyumba za mipembo ndipo wanthu wentse akhambamutenda. ");
INSERT INTO nyu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jezu adayenda kuNazareta komwe adakulira, ndipo pantsiku ya malinkhuma adayenda kunyumba ya mipembo nakuti ukhali msambo wace. Ndipo adalamuka kuti awerenge. ");
INSERT INTO nyu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pamwepo adapasidwa livu la mpolofita Izaiya, adafungula acigumana mbuto yomwe ikhadanemba kuti: ");
INSERT INTO nyu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mzimu wa Mbuya uli pana ine, thangwe Iye wandidzoza kuti ndipalidze mafala yabwino kuna wakusauka. Iye adandituma kuti ndidziwise kutsudzulidwa kuna anyakumangidwa ndipo kuwona kwa azimola, kudzatsudzula wakupondereredwa, ");
INSERT INTO nyu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ndipo kudzadziwisa gole lomwe Mbuya an'dzapulumusa wanthu wace”. ");
INSERT INTO nyu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pamwepo iye adafunga Livu aciripereka kuna nthena ya m'nyumba ya mipembo, acikakhala. Ndipo wanthu wentse omwe akhali m'nyumba ya mipembomo akhamunyang'anisisa. ");
INSERT INTO nyu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iye adayamba kuwauza kuti: “Lero bzakunembedwa bzomwe mwamala kubvabzi bzacitika”. ");
INSERT INTO nyu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wanthu wentse akhambalewa ubwino bwace ndipo akhadabwa na mafala yakukondweresa yomwe yakhacoka pa mulomo pace, tsono akhambabvundza kuti: “Kodi umweyu ndiye lini mwana wa Zuze?” ");
INSERT INTO nyu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tsono adawatawira kuti: “N'cadidi kuti imwepo mun'ti mundiwuze mwani uyu: ‘Dombototo, bzilape iwe wekha! Cita kuno kudziko kwako bzomwe tidabva kuti udacita kuKafaranawumi’ ”. ");
INSERT INTO nyu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ndipo adapitiriza kuwauza aciti: “Ndirikukuuzani bzacadidi kuti: Palibe mpolofita omwe ambabvumidwa mudziko mwace. ");
INSERT INTO nyu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Lekani ndikuuzeni kuti, akhalipo amasiwa azinji kuIjirayeri panthawe ya Eriya, pomwe kudzulu kudafungidwa magole matatu na minyezi mitanthatu ndipo kudawoneka njala ikulu pa dziko lentse la pantsi. ");
INSERT INTO nyu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ndipo Eriya alibe kutumidwa kuna mubodzi wa amasiwawo, tsono kuna mansiwa m'bodzi yekha omwe akhakhala kuSerepita, pafupi na Sidoni. ");
INSERT INTO nyu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ndipombo kukhana wamapere azinji kuIjirayeri panthawe ya mpolofita Erizeu. Tsono palibe na m'bodzi wawo omwe adapolesedwa, Namani yekha wa dziko la Siriya”. ");
INSERT INTO nyu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ndipo wentse omwe akhali m'nyumba ya mipembomo, pomwe adabva mafala yomweyo, adadzala na ukali. ");
INSERT INTO nyu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pamwepo adaimirira, acimuthotha mumzindamo, ndipo adamutenga mpaka padzulu pa phiri pomwe pakhadamangidwa mzindawo kuti akamugwinyire muphompho. ");
INSERT INTO nyu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tsono Jezu adapsola na pakati pawo acicoka. ");
INSERT INTO nyu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iye adayenda kuKafaranawumi, kumzinda wa Galireya, ndipo ntsiku ya malinkhuma adayamba kupfundzisa mbumba. ");
INSERT INTO nyu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wanthu wentse akhadabwa na mapfundzisidwe yace, thangwe mafala yace yakhana mphambvu. ");
INSERT INTO nyu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Munyumba ya mipembomo mukhana munthu m'bodzi omwe akhana mzimu wakuipa. Ndipo iye adakuwa aciti: ");
INSERT INTO nyu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Nandi! Jezu wa kuNazareta, kodi un'funa ciyani kuna ife? Kodi wabwera kudzatidzonga? Nin'dziwa kuti imwe ndimwe yani: Wakucena wa Mulungu!”. ");
INSERT INTO nyu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pamwepo Jezu adaukalipira aciti: “Nyamala! Ndipo coka mwa iye”. Ndipo mzimu wakuipayo udamugwesera pantsi patsogolo pa wanthu wentse, ndipo udacoka mwa iye mwakusaya kum'pweteka. ");
INSERT INTO nyu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wanthu wentse adadabwa nabzo, ndipo akhalewa winango na mwanzace kuti: “Ni fala lanyi limweri? Napo mizimu yakuipa Iye ambaitonga na mphambvu, icicoka!”. ");
INSERT INTO nyu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ndipo mbiri yace idamwazikira kumphimpha zomwezire zentse. ");
INSERT INTO nyu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jezu adacoka munyumba ya mipembo, adayenda kumui kwa Simau. Mebzala wa Simauyo akhana maferu, ndipo iwo adakumbira Jezu kuti amuthandize. ");
INSERT INTO nyu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iye adakotama pakhana mtendapo, acicosa maferoyo, iyo yadamuleka. Ndipo iye adamuka aciyamba kuwatanairira. ");
INSERT INTO nyu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pomwe dzuwa likhamira, mbumba idabweresa atenda azinji omwe akhana matenda ya mtundu wakusiyana-siyana. Ndipo Iye adapolesa m'bodzi na m'bodzi wa iwo mwa kuwasanjika manja. ");
INSERT INTO nyu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Napombo winango akhagwa mizimu yakuipa icimbakuwa kuti: “Iwepo ndiwe Mwana wa Mulungu!”. Tsono Iye, akhaicosa ndipo akhaibvumiza lini kuti ilewe-lewe, thangwe ikhadziwa kuti akhali Krixtu. ");
INSERT INTO nyu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pomwe kudacena, Jezu adayenda kumbuto komwe kumbapita lini wanthu kawiri-kawiri. Ndipo mithithi ikhamunyang'ana, akhamuumiriza kuti aleke kuwasiya. ");
INSERT INTO nyu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tsono Iye adawauza kuti: “Bzin'funika kuti Ine ndikapalidze nkhani yabwino ya Umambo bwa Mulungubu kumizindambo inango, nakuti ndidatumidwira bzimwebzo”. ");
INSERT INTO nyu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ndipo adapitiriza kupalidza munyumba za mipembo kuJudeya. ");
INSERT INTO nyu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ntsiku inango, Jezu akhali m'mphepete mwa thawale la Jenezareti, mthithi wa wanthu ukhamupsindiza mbali zentse kuti ubve fala la Mulungu. ");
INSERT INTO nyu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ndipo Iye adawona miyadiya miwiri yomwe ikhali m'mphepete mwa thawale, ikhadasiyidwa na akhombwe, omwe akhatsuka bwazi. ");
INSERT INTO nyu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iye adapakira m'mwadiya omwe ukhali wa Simau, ndipo adamukumbira kuti augwinye pang'ono m'madzi. Ndipo adakhala m'mwadiyamo acipfundzisa mbumba. ");
INSERT INTO nyu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Atamala kulewa-lewa, adauza Simau kuti: “Yenda pambuto pana madzi yakuzika”, ndipo imwe mwentse: “Kathuseni bwazi kuti mumphate ntsomba”. ");
INSERT INTO nyu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simau adamutawira aciti: “Misiri, ife-pano tabziumiriza kuphata basa usiku bwentse ndipo tiribe kuphata cinthu. Tsono, nakuti ndimwepo mulikulewa bzimwebzi, ndiniyenda kukathusa bwazi”. ");
INSERT INTO nyu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pomwe iwo adacita bzimwebzo, adaphata ntsomba zizinji kwene-kwene, mwakuti bwazibo budayamba kung'ambika. ");
INSERT INTO nyu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pamwepo iwo adacemera na manja andzawo omwe akhali m'mwadiya winango, kuti abwere kudzawathandiza. Ndipo iwo adabwera acidzaza mimwadiyayo, mwakuti idafika pakufuna kumira. ");
INSERT INTO nyu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pomwe Simau Pedru adawona bzimwebzo, adagodamira m'minyendo mwa Jezu adati: “Mbuya, fundukirani pana ine, thangwe ine ndine munthu wakutaza”. ");
INSERT INTO nyu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pamwepo iye na andzacewo, adadabwa kwene-kwene na ntsomba zomwe akhadaphata, ");
INSERT INTO nyu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","napombo Tiyago na Juwau wana wa Zebedeu andzace wa Simau. Ndipo Jezu adauza Simau kuti: “Leka kucita mantha, kuyambira tsapano-lino mpaka kutsogolo un'dzakhala khombwe wa wanthu”. ");
INSERT INTO nyu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pamwepo iwo adapfuwa mimwadiya yawo aciyenda nayo pamcenga, adasiya bzentse ndipo adamutewera. ");
INSERT INTO nyu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pomwe Jezu akhali mum'zinda winango, padabwera munthu omwe akhadadzala na mapere. Pomwe iye adaona Jezu, adagodama acitsulima ndipo adamukumbira aciti: “Mbuya, mucifuna, mungandipolese”. ");
INSERT INTO nyu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jezu adafuthula boko acimukhuya ndipo adalewa kuti: “Inde, nin'funa! Pola”. Panthawe ibodzi-bodziyo mapereyo yadacoka. ");
INSERT INTO nyu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pamwepo Jezu adamuuza kuti: “Leka kuuza ali-yentse bzimwebzi. Tsono yenda ukabzilatize kuna baba wa ntsembe ndipo ukapereke ntsembe ya kupolesedwa kwaceko, ntsembe zomwe Mozeji adalewa, kuti zikhale mboni”. ");
INSERT INTO nyu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pamwepo, mafala yakulewa bza Iye yakhathimizirika kumwazikira, mwakuti mithithi ya wanthu ikhabwera kudzamubva na kudzapolesedwa matenda yawo. ");
INSERT INTO nyu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tsono Jezu akhambacoka aciyenda payekha ndipo akhapemba. ");
INSERT INTO nyu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ntsiku ibodzi pomwe Iye akhapfundzisa, pakhana aFalizi na apfundzisi wa Mtemo, akhadacokera kumii yentse ya kuGalireya, kuJudeya na kuJerusalema. Ndipo mphambvu za Mbuya zikhali na Iye kuti apolese atenda. ");
INSERT INTO nyu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Amuna anango adabwera adanyamula bundukutu pamakhangala, ndipo adayezera kum'pitisa m'yumbamo, kuti akamutule patsogolo pa Jezu, ");
INSERT INTO nyu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","tsono alibe kukwanisa thangwe ra mthithi wa wanthu. Ndipo adakwira pantsodzi adamtereza na makhangalayo, pa bulu lomwe adafungula, mpaka patsogolo pa Jezu. ");
INSERT INTO nyu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pomwe adawona cikhulupiro cawo, Jezu adati: “Munthuwe, bzitazo bzako bzalekeredwa”. ");
INSERT INTO nyu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Afalizi na amisiri wa Mtemo adayamba kukumbuka acimbati: “Umweyu mbani alikutukwana Mulungu? Mbani omwe angalekere bzitazo, pokha-pokha Mulungu yekha?” ");
INSERT INTO nyu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jezu pakudziwa bzomwe iwo akhakumbuka adati: “Thangwe ranyi imwepo mulikukumbuka tenepoyo? ");
INSERT INTO nyu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kodi cakupusa kulewa n'ciponi kuti: ‘Bzitazo bzako walekeredwa’ ayai kuti: ‘Lamuka uyende’? ");
INSERT INTO nyu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tsono kuti imwepo mudziwe kuti mwana wa munthu ana utongi bwa mphambvu padziko kuti alekerere bzitazo”, adauza bundukutu ule aciti: “Ine ndirikulewa: Lamuka, tenga khangala lako ndoko kunyumba”. ");
INSERT INTO nyu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pamwepo-letu mwamuna ule adaimirira patsogolo pawo, adatenga khangala lomwe akhadanyamulidwa nalo, adayenda kunyumba acimbatumbiza Mulungu. ");
INSERT INTO nyu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wanthu wentse adadabwa, acimbatumbiza Mulungu, ndipo mwakudzala na mantha akhambalewa kuti: “Lero tawona malengwa”. ");
INSERT INTO nyu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bzatamala bzimwebzo, Jezu adacoka ndipo adawona nyakupimisa mtsonkho, dzina lace Levi, akhadakhala pambuto ya kupimira mtsonkho. Ndipo adamuuza kuti: “Nditewere” ");
INSERT INTO nyu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi adaimirira, acisiya bzentse ndipo adamtewera. ");
INSERT INTO nyu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pamwepo Levi adamucitira cikondweso cikulu kwene-kwene panyumba pace. Ndipo pakhana wanthu azinji akhadya nawo, Wakupimisa mtsonkho na wanthu anangombo. ");
INSERT INTO nyu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tsono aFalizi na amisiri wa Mtemo wale omwe akhali wa gulu libodzi adaipidwa nawo ateweri wa Jezu, ndipo adawabvundza kuti: “Thangwe ranyi imwepo muli kudya na kumwa pabodzi na anyakupimisa mtsonkho ndipo ‘atazi’?” ");
INSERT INTO nyu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jezu adawatawira aciti: “Ni wakulimba lini omwe an'funa mulapi, tsono wale omwe ali kuduwala. ");
INSERT INTO nyu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ine ndiribe kubwera kudzacemera wakulungama, tsono wakutaza kuti akhumbule”. ");
INSERT INTO nyu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ndipo iwo adamuuza kuti: “Ateweri wa Juwau ambabzimana kudya ndipo ambapemba kazinji kentse, napombo ateweri wa afalizi. Tsono wakowa ambadya na kumwa”. ");
INSERT INTO nyu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jezu adawatawira aciti: “Imwepo mungacitise kuti wakucemeredwa pamsinda wa malowozi abzimane kudya uko wakulowola ali pamwepo? ");
INSERT INTO nyu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tsono in'dzakwana nthawe yomwe an'dzacoseredwa wakulowola. Nthawe zimwezo iwo an'dzabzimana kudya”. ");
INSERT INTO nyu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ndipo Iye adawatsikira matere aciti: “Palibe omwe an'gwata nguwo ipsa acisonerera cigamba pa nguwo ya kale, penu wina an'cita bzimwebzi, an'dzadzonga nguwo ipsayo, napombo cigambaco cin'ndendemera lini pa nguwo ipsayo. ");
INSERT INTO nyu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ndipo palibe omwe aniikha vinyu ipsa mucombo ca khanda lakale. Akabzicita, vinyuyo in'dzaciphokesa icitayika ndipo comboco cin'dzongeka. ");
INSERT INTO nyu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tsono vinyu ipsa, mbaiyikhidwe mucombo cakhanda lipsa. ");
INSERT INTO nyu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Palibe omwe angamwe vinyu ya kale, acifuna pomwe ipsa, nakuti ambati: ‘Vinyu yakale ni yabwino!’ ”. ");
INSERT INTO nyu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pantsiku inango ya Sabudu pomwe Jezu akhapita na m'munda wa mapira, ateweri wace adachola acipuya na manja acimbadya msoso. ");
INSERT INTO nyu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ndipo aFalizi anango adawabvundza kuti: “Thangwe ranyi muli kucita bzomwe bzimbabvumizidwa lini kucita pa ntsiku ya Sabudu?” ");
INSERT INTO nyu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ndipo Jezu adawatawira aciti: “Kodi mulibe kuwerenga bzomwe adacita Davide na andzace pomwe adabva njala? ");
INSERT INTO nyu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Iye adapita m'nyumba ya Mulungu, ndipo adatenga pau zakuperekedwa kuna Mulungu, zomwe zikhathemera kudyedwa na anyantsembe okha, tsono iye adadya acipasambo andzace”. ");
INSERT INTO nyu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ndipo adawauza pomwe kuti: “Mwana wa Munthu ndiye Mbuya wa Sabudu”. ");
INSERT INTO nyu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pasabudu linango, Jezu adayenda munyumba ya mipembo. M'mwemo mukhana munthu wakulemala boko la madidi. ");
INSERT INTO nyu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ndipo aFalizi na amisiri wa Mtemo akhanyang'ana mulandu wakuti apase Jezu. Ndipopo akhanyang'ana na cheru, kuti awone penu Iye angadalimbisa munthu ule ntsiku ya sabuduyo. ");
INSERT INTO nyu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tsono Jezu adadziwa bzomwe iwo akhakumbuka ndipo adauza wa kulemalayo kuti: “Imirira bwera pakatipa!” Ndipo iye adaimirira acikhala dzololo. ");
INSERT INTO nyu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pamwepo Jezu adawabvundza adati: “Kodi bzimbabvumizidwa kucita pantsiku ya Sabudu ni bziponi, bzabwino ayai bzakuipa? Kupulumusa moyo ayai kupha?” ");
INSERT INTO nyu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iye adanyang'ana wanthu wentse omwe akhadamuzungulira, ndipo adauza wakulemala bokoyo kuti: “Futhula boko”. Iye adalifuthula, licibwerera mwace. ");
INSERT INTO nyu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tsono iwo adakalipa kwene-kwene. Ndipo adayamba kucezerana kuti awone mulandu wakupasa Jezu. ");
INSERT INTO nyu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pantsiku zimwezire Jezu adacoka acikakwira m'phiri kuti akapembe, ndipo adaphuphudza acimbapemba Mulungu. ");
INSERT INTO nyu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ndipo pomwe kudacena, adacemera ateweri wace acisankhula khumi na awiri pakati pawo, omwe adawapasa dzina lakuti atumiki: ");
INSERT INTO nyu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simau omwe adapasa dzina lakuti Pedru, na m'bale wace Andereya, Tiyago, Juwau Filipi, Bartolomeu, ");
INSERT INTO nyu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateu, Tomasi, Tiyago mwana wa Alifeu, Simau omwe akhacemeredwa Zelote, ");
INSERT INTO nyu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judasi mwana wa Tiyago na Judasi Isikaliyoti omwe adadzapindukira Jezu. ");
INSERT INTO nyu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ndipo Jezu adabuluka pabodzi na iwo, ndipo adakaima pacidambo, pamwepo pakhana ateweri wace azinji na mthithi ukulu omwe udacokera kumphimpha za Judeya zentse, wa kuJerusalema na wa kunja kwa madzi ya nyandza ya Tiro na Sidoni, ");
INSERT INTO nyu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Omwe akhadabwera kuti adzabve na kudzalapidwa matenda yawo. Ndipombo omwe akhanesedwa na mizimu yakuipa adalimbisidwa. ");
INSERT INTO nyu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ndipo wanthu wentse akhafuna kumukhuya, thangwe kuna Iye kukhacoka mphambvu ikhapolesa wentse. ");
INSERT INTO nyu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pamwepo Iye adanyang'ana ateweri wace, aciti: “Wakusimbidwa ndimwe, wakusauka, nakuti ni bwanu Umambo bwa Mulungu. ");
INSERT INTO nyu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Wakusimbidwa ndimwe, omwe tsapano-lino muna njala, nakuti mun'dzakhuta. Wakusimbidwa ndimwe, omwe tsapano-lino muli kulira, nakuti mun'dzaseka. ");
INSERT INTO nyu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Wakusimbidwa ndimwe, akakuwengani, akakuthothani na kukutukanani, aciipisa dzina lanu na kukuyesani wanthu wakuipa, thangwe ra Mwana wa Munthu. ");
INSERT INTO nyu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Mudzakondwere ntsiku imweyo, mucidzasekera, thangwe mabaibai yanu kudzulu ni makulu kwene-kwene. Nakuti makholo yawo adacitambo bzibodzi-bodzibzo kuna apolofita. ");
INSERT INTO nyu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Tsono tsoka kuna imwe anyakudala, nakuti mwatambira kale mabai-bai yanu. ");
INSERT INTO nyu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tsoka kuna imwe, omwe tsapano-lino muna bzentse, nakuti mun'dzabva njala. Tsoka kuna imwe omwe tsapano-lino muli kuseka, nakuti mun'dzadandaula mucilira. ");
INSERT INTO nyu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tsoka kuna imwe, pomwe wentse an'dzalewa ubwino bwanu, nakuti tenepoyo makholo yawo adacitambo kuna apolofita wakunama. ");
INSERT INTO nyu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Tsono Ine ndirikuuza imwe omwe muli kundibva kuti: Khalani na lufoi kuna anyamadulanthaka wanu, citani bzabwino kuna wale omwe an'kuwengani. ");
INSERT INTO nyu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Simbani omwe ambakulewani kuipa, apemberenimbo wale omwe ambakuboneresani. ");
INSERT INTO nyu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Penu munthu an'kumenya phutu libodzi, perekera phutu linango. Penu munthu an'kutengera kapote, leka kumuletsa kukutengera kamiza. ");
INSERT INTO nyu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pasa munthu ali-wentse comwe iye an'kukumbira, ndipo penu munthu an'kutengera cinthu, leka kumuuza kuti akubwezere. ");
INSERT INTO nyu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bzomwe mun'funa kuti anango akucitireni, citanimbo imwepo kuna iwo. ");
INSERT INTO nyu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ni mabaibai yanyi yomwe mun'dzawona, mukambafuna omwe an'kufunani?, Nakuti ‘wabzitazo’ ambafunambo omwe aniwafuna. ");
INSERT INTO nyu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ndipo ni mabaibai yanyi yomwe imwepo mun'dzawona, mukacita ubwino kwa wale omwe ambakucitirani ubwino? Nakuti atazi ambacitambo tenepo. ");
INSERT INTO nyu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ni mabaibai yanyi yomwe mun'dzawona, mukapasa mangawa munthu omwe ambadzakubwezerani? Nakuti ‘atazi’ ambapasa mangawa ‘atazi’ acidikhira kubwezerewa mwa thunthu. ");
INSERT INTO nyu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tsono imwepo, funani anyamaduranthaka wanu, acitireni ubwino, ndipo akumbizeni, mwakusaya kudikhira kubwezerewa cinthu. Tsono mabai-bai yomwe mun'dzapasidwa yan'dzakhala makulu ndipo imwepo mun'dzakhala wana wa Wakudzulu-dzulu. Nakuti iye ni wabwino kuna wakusaya kutenda na wakuipa. ");
INSERT INTO nyu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Khalani na ntsisi nakuti Baba wanu ni wantsisimbo. ");
INSERT INTO nyu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Lekani kumbatongesa ndipo imwepo mun'dzatongesedwa lini. Lekani kupasa mulandu, ndipo mun'dzapasidwa lini mulandu, lekererani andzanu ndipo mun'dzalekereredwa. ");
INSERT INTO nyu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pasani andzanu, ndipo mun'dzapasidwa: Na mphimo yabwino, mwakutsindira, mwakukunkhumula na mpololo bzin'dzaperekedwa kuna imwe. Nakuti mphimo yomwe mumpimira ndiyo in'dzapimiridwambo imwe”. ");
INSERT INTO nyu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesu adacita pomwe mifananizo adati: “Kodi zimola angakhale langa kuna zimola mwandzace? Angagwe lini m'dindi wentse?. ");
INSERT INTO nyu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","M'pfundzi angapose lini misiri wace. Tsono wentse ule omwe an'pfundzisidwa bwino an'dzakhala ninga misiri waceyo. ");
INSERT INTO nyu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Thangwe ranyi iwepo ulikuwona katsetswa komwe kali m'diso mwa m'bale wako, ndipo uli kuwona lini citsetswa comwe ciri m'diso mwako? ");
INSERT INTO nyu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Iwepo ungauze tani m'bale wako kuti: ‘M'bale, bwera ndikucose katsetswa m'diso mwako’, uko iwe caiye un'kwanisa lini kuwona citsetswa ciri mudiso mwako? Wacipha-maso, cakuyamba cosa citsetswa comwe ciri m'diso lako, ndipo un'dzawona bwino-bwino kuti ukwanise ucose citsetswa ciri m'diso la m'bale wako. ");
INSERT INTO nyu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Palibe muti wabwino omwe umbabala bzisapo bzakuipa, ndipo palibe muti wakuipa omwe umbabala bzisapo bzabwino. ");
INSERT INTO nyu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Muti uli-wentse umbadziwika na bzisapo bzace. Palibe omwe ambache nkhuyu m'muti wa minga, napo uva muusva wa mpangala. ");
INSERT INTO nyu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Munthu wabwino ambalewa bzabwino bzomwe bziri muthenthe labwino lomwe liri mum'tima mwace, ndipo munthu wakuipa ambalewa bzakuipa bzomwe bziri mum'tima mwace, thangwe mulomo wace umbalewa-lewa bzomwe bzidadzala mum'tima. ");
INSERT INTO nyu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Thangwe ranyi imwepo mumbandicemera kuti: ‘Mbuya, Mbuya,’ ndipo mun'cita lini bzomwe Ine nimbalewa? ");
INSERT INTO nyu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ine nin'dzakuwonesani mbani omwe ningandendemeze na ule omwe an'bwera kuna Ine, acibva mafala yangu na kucita. ");
INSERT INTO nyu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Adalingana na munthu omwe adamanga nyumba yace, adacera madindi yakuzika ndipo adazika matsinde pa mwala. Pomwe madzi yadadzala, yadamenya nyumbayo, tsono yalibe kukwanisa kuitekenyesa nakuti ikhadamangidwa bwino. ");
INSERT INTO nyu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tsono ule omwe ambabva mafala yangu, acisaya kuyateweza, adalingana na munthu omwe adamanga nyumba yace pamataka mwakusaya kuzika. Ndipo pomwe madzi yadadzala, yadamenya nyumbayo icigweratu yentse ndipo idadzongeka kwene-kwene”. ");
INSERT INTO nyu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pomwe Jezu adamala kulewa bzentsenebzo kuna mbumba, adapita mumzinda wa Kafaranawumi. ");
INSERT INTO nyu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mumwemo mukhana nyagirinya wa mkulu wa acikunda, iye akhadwala mwa pafupi-fupi kufa, ndipo akhafunidwa kwene-kwene na mbuya waceyo. ");
INSERT INTO nyu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mkuluyo pomwe adabva kulewa bza Jezu, adatumiza atsogoleri wa aJuda, kuti akamukumbire abwere kudzamulimbisa nyagirinya wace. ");
INSERT INTO nyu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pomwe iwo adafika kuna Jezu, adamukumbira mwakungingimira aciti: “Munthu umweyu an'themera kuti mumucitire bzimwebzi, ");
INSERT INTO nyu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","thangwe iye ambafuna dziko lathu ndipo adakondza nyumba yathu ya mipembo”. ");
INSERT INTO nyu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pamwepo, Jezu adayenda nawo. Pomwe akhali pafupi na nyumba, mkulu wa acikunda ule adatuma axamwali wace kukauza Jezu kuti: “Mbuya, lekani kubzidedemesa, thangwe ndine lini wakuthemera kuti ndikutambireni panyumba pangu. ");
INSERT INTO nyu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ndipopo, ndiribe kubziyesa wakuthemera kudzalewa-lewa na imwe. Tsono lewani fala libodzi lokha, nyagirinya wangu an'limbisidwa. ");
INSERT INTO nyu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nakuti inembo ndine munthu omwe ndiri pantsi pa akulu ndipo ndina acikunda omwe nimbatonga. Ndikauza m'bodzi kuti: ‘Ndoko’, iye ambayenda. Ndikauza winango kuti ‘Bwera’, iye ambabwera. Ndikauza nyagirinya wangu kuti: ‘Cita ici’, iye ambacita”. ");
INSERT INTO nyu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pomwe Jezu adabva bzimwebzo adadabwa naye ndipo adazungunukira kuna mthithi omwe ukhamutewera aciti: “Ine nin'kuuzani kuti napo muIjirayeri ndiribe kuwona cikhulupiriro ninga cimweci”. ");
INSERT INTO nyu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pomwepo wanthu omwe akhadatumidwa wale adabwerera kumui ndipo adakamgumana walimba nyagirinya ule. ");
INSERT INTO nyu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bzatapita bzimwebzi, Jezu adayenda kumzinda ukhacemeredwa Naini, ndipo akhayenda pabodzi na ateweri wace na mthithi ukulu wa wanthu. ");
INSERT INTO nyu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pomwe akhafendera pa msuwo wa mzinda, mtembo wa mwana omwe akhali m'bodzi yekha wa mansiwa ukhacoka ukhayenda kukapendesedwa, ndipo mthithi wa wanthu wa mum'zinda ukhali pabodzi na mansiwayo. ");
INSERT INTO nyu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pomwe Mbuya adawona mansiwa ule, adamubvera ntsisi ndipo adati: “Leka kulira!” ");
INSERT INTO nyu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Patsogolo pace, Iye adafendera acikhuya baulu, ndipo omwe akhadalinyamula adaima. Jezu adati: “Mulumbwana, Ine ndirikukuuza lamuka!” ");
INSERT INTO nyu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mulumbwana ule adalamuka aciyamba kulewa-lewa, ndipo Jezu adamupereka kuna mai wace. ");
INSERT INTO nyu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ndipo wanthu wentse adabva mantha, acimbatumbiza Mulungu aciti: “Mpolofita mkulu wabwera pakati pathu” Iwo akhambati: “Mulungu wabwera kudzapulumusa mbumba yace”. ");
INSERT INTO nyu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ndipo nkhani imweyi yakulewa bza Jezu idamwazikira kuJudeya kwentse, na madziko ya m'malire. ");
INSERT INTO nyu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ndipo ateweri wa Juwau adamuuza bzentsenebzi. Iye adacemera awiri wawo, ");
INSERT INTO nyu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","aciwatuma kuna Mbuya kuti akamubvundze kuti: “Kodi ndimwepo omwe akhalewedwa kuti an'dzabwera? Ayai tidikhire winango?” ");
INSERT INTO nyu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pomwe amuna wale adafika kuna Jezu adalewa kuti: “Juwau M'batizi watituma kudzakubvundzani: ‘Kodi ndimwepo omwe mukhalewedwa kuti mun'dzabwera? Ayai tidikhire winango?’ ” ");
INSERT INTO nyu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Panthawe imweyo Jezu adalimbisa azinji wa kuwawidwa, wa matenda yakugopsa na wa mizimu yakuipa. Ndipo adafungula maso azinji omwe akhali azimola. ");
INSERT INTO nyu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ndipo Iye adawatawira aciti: “Bwererani mukauze Juwau bzomwe mwawona na kubva kuti: Azimola alikuwona, wakulemala alikufamba, wamapere alikupolesedwa, nkhuthwi zirikubva, wakufa alikulamusidwa ndipo mafala yabwino yalikupalidzidwa kwa wakusauka. ");
INSERT INTO nyu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ndipo wakusimbidwa ni ule omwe ambaipidwa lini thangwe ra Ine”. ");
INSERT INTO nyu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Atayenda ateweri wa Juwau, Jezu adayamba kuuza mthithi bza Juwau aciti: “Ni ciyani comwe mudakawona mudambo? Mtete wakutekenyeka na condzi?” ");
INSERT INTO nyu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ayai ni ciyani mudakawona? Munthu ana bzakubvala bza nguwo yabwino? Tsono omwe ambabvala bza nguwo zabwino acikhala na khalidwe lapadzulu-dzulu ali munyumba za umambo. ");
INSERT INTO nyu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kodi ni ciyani mwakawona? Mpolofita? Inde, ine nin'kuuzani kuti ni wakuposa mpolofita. ");
INSERT INTO nyu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Umweyu ni ule omwe alikulewedwa na bzakunembedwa kuti: “ ‘Nin'dzatumiza mtumiki wangu patsogolo pako. Iye an'dzakukondzera njira patsogolo’. ");
INSERT INTO nyu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ine nin'kuuzani kuti pakati pa omwe adabadwa na mkazi, palibe na m'bodziyo mkulu kuposa Juwau. Tsono omwe ni ng'ono muUmambo bwa Mulungu ni mkulu kuposa iye”. ");
INSERT INTO nyu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ndipo mbumba yentse, napo wakupimisa m'tsonko pomwe adabva mafala ya Jezu adadziwisisa kuti njira ya Mulungu ikhali yakulungama ndipo iwo adabatizidwa na Juwau. ");
INSERT INTO nyu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tsono aFalizi na adziwi wa Mtemo adalamba cakulinga ca Mulungu na iwo, ndipo adalamba kubatizidwa na Juwau. ");
INSERT INTO nyu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jezu adapitiriza kulewa aciti: “Tsono mbani ningandendemeze na wanthu wa m'badwe umweyu? Adatengana na yani? ");
INSERT INTO nyu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ali ninga wana omwe ambakhala pathambwe acimbakuwa kuna wina na andzawo kuti: “ ‘Ife takulizirani mulumbwi, tsono imwe mulibe kubzina. Taimba mwakutsukwalisa, tsono imwepo mulibe kulira’. ");
INSERT INTO nyu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nakuti adabwera Juwau M'batizi, omwe ambabzimana bzakudya, na kubzimana bzakumwa vinyu, imwepo mumbalewa kuti: ‘Ana dimonyo’. ");
INSERT INTO nyu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Adabwera Mwana wa munthu, ambadya na kumwa, imwepo mumbalewa kuti: ‘Wonani gopola ndipo muledzeri, xamwali wa wakukhomesa mtsonkho ndipo “atazi” ’. ");
INSERT INTO nyu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tsono udziwi bwa Mulungu bumbatsimikizidwa na ateweri wace wentse”. ");
INSERT INTO nyu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalizi m'bodzi adacemera Jezu kuti akadye naye cirarilo kumui kwace, Iye adayenda atafika kunyumbako adapita acikakhala pameza. ");
INSERT INTO nyu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ndipo mumzindamo mukhakhala mkazi mtazi, iye pomwe adabva kuti Jezu akhadya m'nyumba mwa m'Falizi, adabwera na ntsupa ya mafuta yakununchira. ");
INSERT INTO nyu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mkaziyo adadzakhala m'mbuyo mwa Jezu m'minyendo mwace, acimbalira misozi yace idatotesa minyendo ya Jezu. Patsogolo pace adaipukuta na tsisi lace, aciipsopsona ndipo adaidzoza na mafuta yakununcira. ");
INSERT INTO nyu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mfalizi omwe akhadamuchemera ule atawona bzimwebzo, yekha adakumbuka kuti: “Munthu umweyu angadakhala mpolofita, angadadziwa kuti mkazi alikumkhuyayu ni mbani ndipo ni khalidwe lanyi lomwe analo, nakuti mkaziyu ni mtazi”. ");
INSERT INTO nyu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ndipo Jezu adamuuza kuti: “Simau, ndina cinthu cakuti ndikuuze”. Iye adati: “Lewani Misiri”. ");
INSERT INTO nyu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Akhalipo amuna awiri, omwe akhana mangawa na munthu winango. M'bodzi akhana mangawa ya denariyo madzana maxanu (500). Ndipo winangoyo, akhana mangawa ya denariyo makumi maxanu (50). ");
INSERT INTO nyu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tsono pa awiriwo pakhalibe omwe akhana kobiri zakuti amubwezere, na tenepo adawalekerera awiriwo. Kodi pa uwiri bwawo ni m'poni omwe an'dzatenda caibzo kuna wakuwapasa mangawa ule?” ");
INSERT INTO nyu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ndipo Simau adatawira kuti: “Nin'kumbuka kuti ni ule omwe walekeredwa mangawa yakulu”. Pamwepo Jezu adamutawira kuti: “Walewa bwino”. ");
INSERT INTO nyu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Patsogolo pace, Jezu adaceuka kuna mkazi ule ndipo adauza Simau kuti: “Ulikuwona mkaziyu? Ndapita m'nyumba mwako, tsono iwepo ulibe kundipasa madzi ya kusamba m'minyendo. Apo iye wanditotesa na misozi acindipukuta na tsisi race. ");
INSERT INTO nyu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Iwepo ulibe kundimusa na mpsompsono, koma mkaziyu, kuyambira pomwe ndapita napano alibe kulekeza kumpsompsona m'minyendo yangu. ");
INSERT INTO nyu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Iwepo ulibe kundidzoza msolo wangu na mafuta, koma iye wathulurira mafuta yakununchira m'minyendo mwangu. ");
INSERT INTO nyu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Na tenepo, Ine nin'kuuza kuti bzitazo bzace bzizinji bzalekeredwa, nakuti iye walatiza lufoi likulu. Tsono ule omwe walekeredwa pang'ono, ana lufoi pang'ono”. ");
INSERT INTO nyu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pamwepo Jezu adauza mkaziyo kuti: “Bzitazo bzako bzalekeredwa”. ");
INSERT INTO nyu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ndipo akhadacemeredwa wale anango adayamba kubvundzana aciti: “Mbani umweyu mwakuti ambalekera bzitazo?” ");
INSERT INTO nyu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jezu adauza mkazi ule kuti: “Cikhulupiro cako cakupulumusa. Ndoko mwa mtendere”. ");
INSERT INTO nyu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bzatapita bzimwebzi Jezu, adafamba m'mizinda na m'mii acimbapalidza na kufotokoza Mafala Yabwino ya Umambo bwa Mulungu. Ateweri wace khumi na awiri akhali pabodzi na Iye, ");
INSERT INTO nyu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","napombo akazi anango omwe akhadacosedwa mizimu yakuipa na matenda, omwe ni Maliya wakucemeredwa Madalena ule omwe kale adacosedwa mizimu yakuipa minomwe, ");
INSERT INTO nyu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juwana, mkazi wa Kuza, wakunyang'anira nyumba ya umambo ya Herodi, Suzana na winangombo azinji. Akazi omwewa akhambathandiza Jezu na bzinthu bzawo. ");
INSERT INTO nyu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mthithi ukulu wa wanthu udakonkhana ndipo wanthu wa m'mizinda yentse akhabwera kuna Jezu. Iye adalewa m'fananizo adati: ");
INSERT INTO nyu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mulimi adayenda kukabzala. Pomwe iye akhabzala, mbeu inango idagwera m'phepete mwa njira. Idapondedwa, ndipo mbalame za kudzulu zidaidya. ");
INSERT INTO nyu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ndipo mbeu inango idagwera paminyala, pomwe idamera miti yace idauma thangwe lakusaya m'nyontho. ");
INSERT INTO nyu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Inango idagwera pakati pa minga, idamera icikula pabodzi na mingayo tsono idatutumuka. ");
INSERT INTO nyu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tsono inango idagwera pandovolo. Idakula icibala bzisapo bzizinji, ibodzi na ibodzi ikhana dzana”. Atamala kulewa bzimwebzi, adakuwa aciti: “Ule ana makutu yakubva, abve!” ");
INSERT INTO nyu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ndipo ateweri wace adamubvundza bzomwe ukhalewa m'fananizo ule. ");
INSERT INTO nyu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jezu adati: “Imwepo mudapasidwa kudziwa bzakubisika bza Umambo bwa Mulungu. Tsono kuna anango nimbalewa na mifananizo, kuti: “ ‘Ambanyang'anisa, tsono ambawona lini. Ndipo ambabva tsono ambabvesesa lini’ ”. ");
INSERT INTO nyu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Kuthumbudzula kwace ni uku: Mbeu ni Fala la Mulungu. ");
INSERT INTO nyu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ire yomwe idagwera munjira ni wanthu omwe ambabva fala, tsono Dyabu ambabwera acicosa fala mumitima mwawo, kuti asaye kukhulupirira aleke kupulumusidwa. ");
INSERT INTO nyu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ndipo ire yomwe idagwera paminyala ni wanthu omwe ambabvuma fala na mpfatso akalibva, tsono alibe muzi. Ambakhulupirira panthawe ing'ono-ng'ono, tsono akagumana na mphicha ambasiya. ");
INSERT INTO nyu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ire yomwe idagwera pakati paminga ni wanthu omwe ambabva, tsono pakutewera njira zawo ambadzatutumuka thangwe ra kuneseka na cuma napombo bzakufuna bza moyo uno. Ndipo iwo ambadzakhwima lini. ");
INSERT INTO nyu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tsono ire yomwe idagwera pamataka ya ndovolo ni wanthu omwe ana mtima wabwino na wacifundo, ambabva mafala aciyakoya ndipo ambabala bzisapo na kulimbika”. ");
INSERT INTO nyu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Palibe munthu omwe ambaphatiza ciphani-phani aciciikha mum'khate, ayai aciciikha pantsi pa talimba. Tsono, ambaciikha padzulu kuti wanthu akapita awone ceza. ");
INSERT INTO nyu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Thangwe palibe cinthu cakubisika comwe cin'dzasaya kuwonesedwa, napo cakubisika comwe cin'dzasaya kudziwisidwa na kuwonesedwa padeca. ");
INSERT INTO nyu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Na tenepo, cenjerani mabvedwe yomwe mulikucita. Ule omwe ana cinthu, an'dzapasiwa bzizinji. Ule omwe alibe cinthu, napo bzomwe an'kumbuka kuti anabzo an'dzatengeredwa”. ");
INSERT INTO nyu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ndipo mai wa Jezu na abale wace adayenda kukamuwona, tsono iwo alibe kukwanisa kufika pakhana Iye, thangwe mukhadadzala wanthu. ");
INSERT INTO nyu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Munthu winango adakauza Jezu kuti: “Mai wanu na abale wanu ali panjapa alikufuna kukuwonani”. ");
INSERT INTO nyu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tsono Iye adawatawira kuti: “Mai wangu na abale wangu ni wale omwe ambabva Fala la Mulungu aciliteweza”. ");
INSERT INTO nyu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ntsiku inango Jezu adauza ateweri wace kuti: “Mbatiyende ng'ambu ire ya thawale”. Iwo adapita mubote aciyenda. ");
INSERT INTO nyu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pomwe akhayambuka, Jezu adagona. Ndipo m'thawalemo mudacita condzi cikulu kwene-kwene, mwakuti botero likhayamba kumira, ndipo iwo akhali pangozi ikulu. ");
INSERT INTO nyu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na tenepo ateweriwo adayenda pafupi na Jezu acim'musa, aciti: “Misiri, Misiri, tirikufa ife!” Iye adamuka adaimisa condzi na mabimbi ya madzi. Bzentse bzidaleka ndipo kudakhala bwino. ");
INSERT INTO nyu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ndipo Jezu adawabvundza adati: “Kodi kukhulupirira kwanu kuli kuponi?”. Iwo adabva mantha na kudabwisidwa, acimbabvundzana winango na mwandzace kuti: “Kodi mbani umweyu omwe aniimisa condzi na mabimbi ya madzi, ndipo ibzo bzicimubvera?”. ");
INSERT INTO nyu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pamwepo, iwo adacapa aciyambuka kafika kumphimpha ya Jerasa yomwe iri ng'ambu ya thawale, kunyang'anisana na Galireya. ");
INSERT INTO nyu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pomwe iwo adatsama, munthu m'bodzi wa mum'zinda mule omwe akhana mizimu yakuipa, adabwera kudzagumana na Jezu. Iye akhadamala ntsiku zizinji ali pezi, ndipo akhakhala lini panyumba tsono m'thenje. ");
INSERT INTO nyu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pomwe iye adawona Jezu adakuwa acibzithusa m'minyendo mwace ndipo mwakukuwa adati: “Nandi Jezu! Kodi mun'funa ciyani kuna ine, Jezu Mwana wa Mulungu Wakudzulu-dzulu? Ndirikukukumbirani kuti muleke kundiboneresa!” ");
INSERT INTO nyu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Thangwe Jezu akhadaiuza kale kuti icoke m'thupi mwa munthuyo. Nakuti mizimu ire ikhadakhala nthawe zizinji mwa iye. Napo akhambamumanga na unyolo minyendo na manja acimbakoyedwa na alindiri, iye akhambabwedza unyolobo ndipo akhatengedwa na mizimuyo kuyenda naye kucidambo. ");
INSERT INTO nyu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jezu adam'bvundza kuti: “Kodi dzina lako ndiwe yani?” Ndipo iye adatawira kuti: “Ndine mthithi”, thangwe mizimu yakuipa mizinji ikhadapita mwa iye. ");
INSERT INTO nyu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ndipo mizimu yakuipa ire idamukumbira kuti aleke kuithothera kuCigwindza. ");
INSERT INTO nyu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pafupi na pamwepo pakhana nkhumba zikhadya m'mphepete mwa kaphiri. Ndipo mizimuyo idamukumbira kuti aibvumize ikapite munkhumba zire. Ndipo Jezu adaibvumiza. ");
INSERT INTO nyu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mizimuyo yatacoka mwa munthu ule, idakapita mu nkhumba, ndipo nkhumbazo zentse zidapolika zicikagwera m'thawale, ndipo zidamira. ");
INSERT INTO nyu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Omwe akhanyang'anira nkhumba zire pomwe adawona bzimwebzo, adathamanga acikauza wanthu kumzinda na m'mii. ");
INSERT INTO nyu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ndipo mbumba idayenda kukawona bzomwe bzidacitikabzo. Pomwe iyo idakafika pakhana Jezu, idakawona munthu omwe akhadacosedwa mizimu yakuipa ule akhadakhala m'minyendo mwa Jezu, atabvala ndipo ndzeru zace zikhadabwerera pambuto, mbumbayo idabva mantha. ");
INSERT INTO nyu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ndipo wanthu anango omwe akhadawona bzidacitikabzo, adafotokozera mbumba momwe adalimbisidwira munthu wa mizimu yakuipa ule. ");
INSERT INTO nyu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pamwepo, mbumba ya kuJerasa yentse, idakumbira Jezu kuti acoke, thangwe iyo ikhadadzala na mantha. Ndipo Iye adapakira mubote acibwerera. ");
INSERT INTO nyu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ndipo munthu omwe akhadacosedwa mizimu yakuipa ule, adakumbira Jezu kuti ayende naye pabodzi. Tsono Jezu adamubweza, adamuuza kuti: ");
INSERT INTO nyu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bwerera kumui ndipo ukafotokoze bzentse bzomwe Mulungu wakucitirabzi”. Na tenepo, iye adayenda mu mzinda acikafotokoza bzentse bzomwe bzidacitika. ");
INSERT INTO nyu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pomwe Jezu adabwerera, mthithi wa wanthu udamutambira mwakukondwera. Nakuti iwo wentse akhamudikhira. ");
INSERT INTO nyu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pamwepo, munthu m'bodzi dzina lace Jairosi, mtsogoleri wa nyumba ya mipembo adabwera ndipo adabzigwesera m'minyendo mwa Jezu, acimudandaulira kuti ayende naye kumui kwace. ");
INSERT INTO nyu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Thangwe mwana wace wacikazi m'bodzi yekha, wa magole khumi na mawiri, akhali pafupi-fupi kufa. Pomwe Jezu akhayenda mthithi ukhamupsindiza. ");
INSERT INTO nyu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tsono pamwepo pakhana mkazi winango omwe akhadwala matenda ya kucoka mulopa, mkati mwa magole khumi na mawiri (12). Tsono pakhalibe omwe angadakwanisa kumulapa. ");
INSERT INTO nyu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ndipo iye adayenda kumbuyo kwa Jezu acikhuya mkawo wa cakubvala cace, nthawe imweyo letu mulopa udaleka kucoka. ");
INSERT INTO nyu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ndipo Jezu adabvundza kuti: “Mbani wandikhuya?”. Tsono wentse adagaza ndipo Pedru adati: “Misiri, mthithiyu ndiwo ulikukupsindizani”. ");
INSERT INTO nyu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tsono Jezu adati: “Alipo omwe wandikhuya. Ine ndabva kuti mphambvu yangu yacoka”. ");
INSERT INTO nyu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pamwepo mkazi ule atawona kuti bzikhakwanisika lini kuti abisale, adafendera ali kutet