﻿USE sofia;
DROP TABLE IF EXISTS sofia.nys_vpl;
CREATE TABLE nys_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nys_vpl WRITE;
INSERT INTO nys_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","3","Karram, nginda Mammarapa Warrinyang kwadja-bi birdiyara, bandang moortaman koboorl-wirt. Keny mammarap Bethlehem-yen Judah-kal, baal kwadja-koorl Moab-ak baalang koort-maatyel wer baalapang koodjal nopa. Baal kol Elimelech, baalang koort-maat kol Naomi wer baalapang koodjal nopa kol Mahlon wer Chilion. Baalap ngoongoolongang Ephratha-yang, Bethlehem-yen Judah-gal. Baalap kwadja-koorl boodjer Moab-ang kidji nyin bookadja. ");
INSERT INTO nys_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","5","Yeyi Elimelech, koort-maat Naomi-ang, baal wanni, kidji Naomi nyiny baalang koodjal nopayel. Baalang koodjal nopa koorta-barrang koodjal koort-maata Moab-ang, kol Orpah wer Ruth. Nginda baalap kwadja-nyin bokadja maar-djen biroka, Mahlon wer Chilion wanni, ngarl Naomi kwadja-yinang, nopa-birt wer koort-maat-birt. ");
INSERT INTO nys_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","7","Moab-al, Naomi dwangka nartj Boolanga-Yira kwadja maar-yango baalang moortaman kidji yanga baalapany mereny. Naomi wer baalang nopakang koort-maata kakat karro-koorl baalang karla-maya Bethlehem-al. Ngarl Naomi wer baalang nopakang koort-maata woort-koorl baalapang maya-mayaka Moab-al kidji kwadjin korl-koorlo djoorootal Judah-kak. ");
INSERT INTO nys_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","14","Yalga Naomi waangka koodjal yoka, “Noonooka koodjal, korl-koorl noonookang karlapak ngaangkakang. Etjenna-bal Boolanga Yira yanga-kwabba noonookany alimarn noonooka kwadja-yanga-kwabba nganyany wer noonookang koort-maata noyitji. Etjenna-bal Boolanga Yira yanga noonookany ngabala-ngoonda karlaka-bwora noonookang milgar koort-maata.” Naomi nindyan baalapany, kidji baalap walwala. Baalap koodjal waangki baal, “Yoowart, ngala boorda koorl noonookyel noonang moortakak.” Yalga Naomi waangki, “Karro-koorl noonookang karlap, ngany kowarta. Nadjil boorda noonookany koorl nganyel? Ngany kayar kadak warmma nopa ngany doomboo-bwora, wa? Baalap kayar etjenna noonookang koort-maata, wa? Korl-koorl, ngany kowarta. Ngany karbarli. Ngany karagor-djil koorta-barrang warmma mammarap. Bayinya ngany koorta-barrang nidja kedela, kidji idja nopa, noonooka boorda nganaka baalapang maladjo, wa? Kidji noonooka boorda yoowart koorta-barrang warmma mammarapa, wa? Yoowart, ngany kowarta. Nidja djadam-ngatti nganyang, boola-ngatti nadjang noonookang, narla maar Bolanga-Yira-kang bakkaniny nganyany.” Ngarl baalap karro walwala. Orpah nindyan baalang mangat, yalga Ruth dirrup-barrang baalany. ");
INSERT INTO nys_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","17","Naomi waangki Ruth, “Miyalitj! Noonang deni karro-koorl baalang moortakak wer baalang motogona. Karro-koorl baalyel.” Yalga Ruth waangki, “Yoowart warranga ngany wandjo noonany kidji wort-koorl noonyen. Windja noonook koorl, ngany boorda koorl; windja noonook nyiny ngany boorda nyiny; noonang moorta boorda etjenna nganyang moorta wer noonang Boolanga Yira boorda etjenna nganyang Boolanga Yira. Windja noonook wanni, ngany boorda wanni - bokatja baalap boorda binarangka nganyany. Etjenna-bal Boolanga-Yira bama baalany bayinya ngany wandja noonany koodjookat ngany wanni.” ");
INSERT INTO nys_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","21","Nginda Naomi kaaditj Ruth kwadja kaat-mardeyin koorlo baalyel, baal yoowart ngatti waangki. Ngarl baalap koodjal korl-koorl Bethlehem-ak. Nginda baalap yoowal-koorl Bethlehem, boola moortaman djoorab-djoorab narla baalapang, kidji yoka waangki, “Nidja baal Naomi, wa?” Baal waangki baalapany, “Ngany yoowart Naomi, ngany kol Mara narla Boolanga Yira kwadja-warn nganyang wininy djadam-djil. Ngany kwadja wort-koorl moorart, yalga Boolanga-Yira karro-barrang nganyany bilyar. Nadjak kol nganyany Naomi? Boolanga Yira kwadja baladjan nganyany kidji baal kwadja yanga nganyan arda koort-warra.” ");
INSERT INTO nys_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Ngarl Naomi kwadja karro-koorl Moab-yen. Ruth Moab-ang, baalang nopang koort-maat, baal kambarn baalany. Baalap yoowal-koorl Bethlehem djiyal moortaman kwadja wedjanginy kwolaka. ");
INSERT INTO nys_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Yeyi, moorta Naomi-kang, baal kol Boaz. Baal moorta koort-maatang Naomi-yang, warda-kadak ngoongoolong Elimelech-ang. ");
INSERT INTO nys_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","5","Ruth Moab-ang waangki Naomi, “Koorl-oola nganyany boodjerak kwolakang kidji wedjang kwolaka. Ngany kayar-koorl ngoolyar moortaman ngiyan bedik-bedik nganyak”. Naomi waangki baalany, “Koorl, ngany koowart”. Ngarl Ruth koorl boodjerak kwolakang kidji wedjang kwolaka ngolonga yakina kwolakang. Yeyi, Boaz kadak nidja boodjera kwolakang. Baal moorta Elimelech-ang. Winidjinbar Boaz yoowal-koorl Bethlehem-yen. Baal waangki yakina kwolakang, “Boolanga-Yira nyin noonookayel!” Baalap yarman-waangki, “Boolanga-Yira yanga-kwabba noonany!” Karro Boaz waangki-djinang birdiyar yakinang kwolakang, “Nidja yok, ngiyan baalang moorta?” ");
INSERT INTO nys_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","9","Birdiyar yakinang kwolakang yarman-waangki, “Nidja baal Moabang. Baal korl-koorl Naomi-yel Moab-yen. Nidja yok waangki, ‘Wedjang-oola nganyany kwolaka ngolonga yakina kwolakang’, kidji baal kwadja-yaka nidjap ngaangk yirakang kidji yoowart nganop.” Karro Boaz waangki Ruth, “Ni, ngany koowart, yoowart koorl warmma boodjera kwolakang, yoowart wort-kool yalga djin-bordak ngany yoka mordiya. Miyalitj boodjera kwolakang kidji djin-bordak yakina kwolakang. Ngany kwadja waangki mammarapa mordiya yoowart yigan noonany. Bayinya noonook djarnyak kepa djoro, kanga kepa nganyang mammarapa mordiya kwadja barrang.” ");
INSERT INTO nys_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","13","Ngarl Ruth djabalar moolymarriyal kidji waangki baal, “Natj kwabba ngany don ngarl noonook djinang nganyany kidji ngorna-kwabba nganyak? Ngany mokang.” Yalga Boaz yalman-waangki, “Boola moortaman kwadja-waangki nganyany moodlooka noonook kwadja-don noonang mangatang ngolanga noonang koort-maat wanni. Noonook wandja noonang maaman wer ngaangk wer noonang boodjera koortang, kidji yoowal-koorl nidjap, moortamanak noonook yoowart katitj. Etjenna-bal Boolanga-Yira yanga-kwabba noonany. Etjenna-bal Boolanga-Yira Israel-ang yanga noonany moodlooka kwabba narla noonook yoowal-koorl ballaridjo baalang ganbar-ngarda.” Kidji Ruth waangki, “Nganyang birdiyar, etjenna-bal ngany kalyakool nyiny kwabba noonang miyalakal. Ngany yoowart nganyang yakina, ngany yoowart mokiny nganyang yoka mordiya, yalga noonook kwabba-don nganyak kidji waangki bedik-bedik noonak.” ");
INSERT INTO nys_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Nginda moortaman ngarniny, Boaz waangki Ruth, “Yoowal-koorl nidjap. Ngarn, kidji ngarda-barrang noonang mwereny bwora kepa djadam.” Ngarl Ruth nyiny bordak yakina kwolakang kidji Boaz maar-barrang baalany mwereny natj yakina kwadja-dookarn. Baal ngarn moorditj, koboorl moorart, kidji bangka mwereny wandja. ");
INSERT INTO nys_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","17","Nginda Ruth yiraba wedjango ngatti kwolaka, Boaz waangki baalang mammarapa mordiya, “Noonooka wedjang-oola baalany kwolaka kardagor boonaraka kwolakang. Yoowart karnyiny baalany. Noonooka djarnyak djookorn ngatti kwolaka baalang, kidji ngardakwir kwolaka baalang kidji yoowart djaat baalany.” Ngarl Ruth wedjang kwolaka boodjeral kwolakang djiyak kedalak, kidji baal bama natj baal kwadja-wedjang kidji baal barrang moorart mirkloorn kwolakang. ");
INSERT INTO nys_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","20","Ruth barrang kwolaka baalang mya-myak kidji Naomi djinang natj baal kwadja wedjang. Karro Ruth yanga baalang mangat mwereni baal yoowart kwadja-ngarn baalaal. Baalang mangat waangki-djinang baal, “Windja noonook wedjang kwolaka? Windja noonook yaka nidja kedala? Etjenna-bal Boolanga-Yira yanga-kwabba mammarap ngiyan djinang noonany.” Ngarl Ruth warranga baalang mangat moodlooka mammarapang wer baalang boodjera kwolakang. Ruth waangki, “Nitja mammarap kol Boaz!” Naomi waangki baalang koowart, “Etjenna-bal Boolanga-Yira yanga-kwabba nidja mammarap. Baal yoowart nganop ngorna-kwabba moortamanak wininy wer noyitj.” Naomi kardjir waangki Ruth, “Nidja mammarap ngalang moorta, ngalang moorditj-moyiran.” ");
INSERT INTO nys_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","23","Kidji Ruth Moabang waangki, “Baal kardjir warranga nganyany, ‘Boordak-djin nganyang yakinak djiyak baalap nganop wedjanginy bandang nganyang kwolaka’.” Naomi waangki Ruth, baalang nopang koort-maat, “Nidja kwabba-ngatti, nganyang koowart. Noonook djarnyak boordak-yaka baalang yoka mordiyak narla moortaman bakkan-pa noonany warmma boodjera kwolakang.” Ngarl Ruth boordak-djin Boaz-ang yoka mordiyak djiyak baalap nganop wedjang kwolaka. Baal nyiny karla-mayal baalang mangatang. ");
INSERT INTO nys_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","5","Ngolonga, Naomi, Ruth-ang mangat, waangki baal, “Nganyang koowart, ngany djarnyak djin-barranga karla-maya noonang ngarl keny moort kayar karrodjin noonany. Yeyi, nidja mammarap, Boaz, baal ngalang moorta. Noonook kwadja-yakiny boongal baalang yoka mordiya. Boaz boorda bama baalang kwolaka baalang baminyapal kwolakang nidja kedalak. Koorl, kakaloorni wer boyin-bandin noonaal, kidji wandang noonang bwoka kwabba-djil. Koorl baminyap-kwolakang, yalga yoowart baal djinang-oola noonany djiya baal nganop ngarniny wer djoriny. Nginda baal bidjar, miyalitj nginda baal ngwoorndiny, karro koorl kidji baldjar baalang djena kidji ngwoornda bookadja. Baal boorda warranga noonany natj noonook djarnyak don.” Ruth waangki baal, “Moodlooka noonook waangki, ngany boorda-don.” ");
INSERT INTO nys_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","9","Ngarl Ruth koorl baminyap-kwolakang kidji baal don moodlooka baalang mangat waangki. Ngolonga Baoz ngarn wer djor, kidji baal kwadja koorta-kwabba, baal ngwoorndiny boongal moorka kwolakang. Ruth ngardang baalak, baldjar baalang djena, kidji ngwoorndiny. Moordal kedelakang, Boaz ngoont-boorbang. Baal korang, kidji djinang yok ngwoorndiny bordak baalang djena. Baal waangki-djinang, “Ngiyan noonook?” Yok yalman-waangki, “Ngany Ruth, noonang yakina. Napang noonang yakina noonang bwokal narla noonook nganyang moorditj-moyiran.” ");
INSERT INTO nys_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boaz waangki, “Etjenna-bal Boolanga-Yira yanga-kwabba noonany, nganyang koowart. Noonang karriny karnayal nganyak, ngatti kwabba-djil naadjang noonook kwadjat-don. Noonook yoowart ngwaling mammarapa mordiya, bayinya baalap boola-boya kadak ka yoowart. ");
INSERT INTO nys_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","13","Yeyi, nganyang koowart, yoowart wayarn. Ngany boorda don moodlooka noonook ki, narla bandang nganyang moorta nidjapang, baalap kaditj noonook kwabba yok. Yalga yeyi, karnayal, ngany noonang moorditj-moyiran, yalga keny mammarap nyiny boordak-ngatti naatjang nganyany. Bidjar nidjapal nidja kedelak, kidji benang, bayinya baal boorda yaaka etjenno noonang moorditj-moyiran, kaya, kwabba, yalga bayinya baal yoowart yaaka etjenno noonang moorditj-moyiran, ngany waangki noonany, kolal Boolanga-Yirang, ngany boorda don nidja noonang. Ngwoornda nitjap djiyak benang.” ");
INSERT INTO nys_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","15","Ngarl Ruth ngwoornda boongal djena Boaz-ang djiyak ngaank yira. Ruth yiraba kwadjat moortaman kayar-djinang baalany. Boaz waangki baal, “Moortaman djarnyak yoowart kaaditj noonook kwadja-koorl nidjap.” Kidji baal waangki, “Yanga noonang kwart.” Ruth yanga Boaz baalang kwart. Boaz djaranga maar-keny mirlkoona kwolakang kwartal, kidji yira-barrang kwolaka Ruth-ang bogalal. Karro Boaz korl-koorl karlamaya Bethlehem-ak. ");
INSERT INTO nys_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","18","Nginda Ruth yoowarl-koorl baalang mangat, Naomi djinang-waangki baal, “Yarnmen moodlooka etjenna, ngany koowart?” Karro Ruth warranga Naomi moodlooka Boaz kwadja-don baalang. Baal waangki, “Boaz yanga ngany maar-keny mirlkoona kwolakang, narla baal waangki, ‘Yoowart korl-koorl mangat kanginy kayan maaral’.” Naomi yalman-waangki, “Kwidi, ngany koowart, arda nginda noonook kaditj naatj etjenna, narla nidja mammarap boorda yoowart ngwoorndiny nidja kedela arda nginda nidja noolonga etjenna.” ");
INSERT INTO nys_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","6","Ngarl Boaz koorl dedinak Bethlehem-ang kidji nyiny bokadja. Nginda warmma moorditj-moyiran djendjereniny, nidja baal ngiyan Boaz kwadja-warrang Ruth, Boaz waangki baal, “Yoowal-koorl ngooni, nyiny nidjap”. Ngarl nidja mammarap yoowal-koorl kidji nyiny. Karro Boaz mira maar-djen mammarapa Bethlehem-ang, waangkiny, “Nyiny nidjap.” Ngarl baalap nyiny. Karro Boaz waangki nidja warmma moorditj-moyiran, “Naomi kwadja korl-koorl Moaba-yen. Baal ki wort-bangal boodjera ngalang ngooniyang Elimelech. Ngany kaaditj ngany djarnak warranga noonook, ‘Barrang nidja boodjera noonaal, booram mammarapa nyinyiny nidjap kidji booram ngalang birdiyara.’ Bayinya noonook ki nidja boodjera, bangal-barranga noonaalang. Yalga bayinya noonook yoowart ki nidja boodjera, warranga nganyany, ngarl ngany kaaditj. Yoowart moort kayar barrang nidja boodjera, arda noonany, kidji ngany ngolonga noonany.” Ngarl mammarap waangki, “Ngany boorda barrang nidja boodjera.” Ngarl Boaz waangki, “Kedala noonook barranga nidja boodjera, noonook kardjir barrang Ruth Moabang, yenang mammarapang noyitj, ngarl kol noyitjang nyiny baalang boodjerayel.” Yilak-yilak, warmma moorditj-moyiran waangki, “Ngany yoowart kayar barrang nidja boodjera nganyaal, narla ngolonga ngany djarnyak walak-walak bandang naganyang boodjera Ruth-yel. Noonook bangal-barranga nidja boodjera noonaal, narla ngany yoowart kayar.” ");
INSERT INTO nys_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","10","Kwedjang, nginda moortaman Israel-ang walak-walak boodjera, keny mammarap djarnyak bilyan baalang djena-bwoka kidji yanga warmma mammarap. Ngarl warmma moorditj-moyiran waangki Boaz, “Barrang nidja boodjera noonaal!”, kidji baal bilyan baal djena-bwokal. Kidji Boaz waangki bandang moortaman, “Nidja kedala, noonooka etjenna nganyang marlangara. Ngany kwadja bangal-barrang maarayen Naomi-yang, bandang boodjera Elimelech-ang wer Chilion wer Mahlon. Ngany kardjir barrang Ruth Moabang, yinang Mahlon-ang, etjenno ngany koort-maat, ngarl kol mammarapang noyitj nyiny baalang boodjerayel, ngarl baalang kol yoowart boorda anbangbat baalang moortayen kidji yoowart dwangka-anbangbat nidjapal. Nidja kedala noonooka etjenna nganyang marlangara.” ");
INSERT INTO nys_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","12","Karro bandang birdiyara wer bandang moortaman nyinyiny dedinal, baalap waangki, “Ngala marlangara. Etjenna-bal Boolanga-Yira yanga-kwabba nidja yok ngiyan bwora-koorl noonang karla-maya, ngarl baal boorda etjenna mokiny Rachel wer Leah, ngiyan dandjo yiraba moortaman Israel-ang. Boolanga-Yira boorda yanga noonany warda-kadak Ephrathah-kal kidji yanga noonany kol koomba Bethlehem-al. Boolanga-Yira boorda yanga noonany boola koolangka nidja yok mordiyayel, ngarl noonang moorta boorda etjenna mokiny moorta Perez-ang, ngiyan Tamar yidja Judah-ak.” ");
INSERT INTO nys_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ngarl, Boaz barrang Ruth kidji Ruth etjenna baalang koort-maat. Baalap dandjo ngwoornda kidji Boolanga-Yira yanga-kwabba Ruth. Baal etjenna boodjari kidji yidja baalapang nop. ");
INSERT INTO nys_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","15","Bandang yoka waangki Naomi, “Ngala yanganan Boolanga-Yira narla nidja kedela, baal yoowart boorda wandja noonany koolang-birt, kidji baal boorda yoowart wandja noonang moorta yoowart milgar moorditj-moyiranyel. Etjenna-bal baal warda-kadak Israel-al. Nidja mammarap boorda yanga noonookang wininy. Nginda noonook kabarli, baal boorda karrodjin noonany, narla noonang koowart woonya noonany kidji baal kwadja-yidja nidja nop noonang kidji baal kwabba-ngatti noonang naadjal maar-koodjal nopa.” ");
INSERT INTO nys_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","17","Kidji Naomi barrang koolang kidji yidja baalany dawelal kidji Naomi karrodjin baalany. Yoka Bethlehem-ang waangki, “Nidja koorlang etjenna nop Naomi-yang.” Baalap kol baalany Obed. Baal etjenna maaman Jesse-yang, maaman David-ang. ");
INSERT INTO nys_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Nidja djoowaka Perez-ang: Perez maaman Hezron-ang; Hezron maaman Ram-ang; Ram maaman Amminadab-ang; Amminadab maaman Nahshon-ang; Nahshon maaman Salmon-ang; Salmon maaman Boaz-ang; Boaz maaman Obed-ang; Obed maaman Jesse-ang, wer Jesse maaman David-ang. ");
INSERT INTO nys_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nganyang kwabba babin, Theophilus. Boola moorta kwabba-don. Baal boordak karni warrinya mili-milikal, mandang noolonga edjeniny ngalany kardakor. ");
INSERT INTO nys_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Baalap boordak karni noolonga mili-milikal, moodlooka moorta warranga ngalany. Nidja-nidja moorta kwadja-djinang moodlooka alikwadjakang, kidji baalap warranga Warda-Kwabba. ");
INSERT INTO nys_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kidji ngarl, nganyang birdiyar, ngany kardjir mardayin-kaaditj moodlooka alikwadjakang. Ngany kaaditj nidja boorda kwabba, karni bardip mili-milikal boordakiny. ");
INSERT INTO nys_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngany boordakiny ngarl noonook boorda-kaaditj moorart karnarny, moodlooka noonook kwadja-dwangka. ");
INSERT INTO nys_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Keny mammarap, baalang kol Zechariah, baal nyiny yakin-kooranyi birokal Herod nyiny Djelyib Judea-kang. Baal keny yakina-kooranyikang ngiyan yaka Abijah-kang. Elizabeth baalang koort-maat. Baalang moorta kardjir nyiny yakina-kooranyi. ");
INSERT INTO nys_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Koodjal kwabba karra Boolanga-Yirakang miyalakal, moodlooka doniny Boolanga-Yirakang Warrinya waangki. ");
INSERT INTO nys_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Koodjal koorlang-birt, narla Elizabeth yoowart kwadja-boodjari-biny. Baal wer Zechariah, koodjal karakor-djil. ");
INSERT INTO nys_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Keny kedela, Zechariah, baal kwadja-yaka Maya-maya-Kooranyi-bwora, narla baalang kedela yakin-kooranyi yaakiny. ");
INSERT INTO nys_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yakina-kooranyi, baalap kalyakool banitja kooranyi boyara, djinanginy naatj mammarap boorda-narra manna-ngoonyang karla-kooranyal. ");
INSERT INTO nys_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ngarl Zachariah, baal bwora-koorl Boolanga-Yirakang Maya-maya-Kooranyi. Bandak, moorta boola baalap Boolanga-Yira kwadja-yanganiny narla manna-ngoonyang kwadja-narriny. ");
INSERT INTO nys_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Boolanga-Yirakang djin-djin-kwabba, baal Zechariah-kany yoowal-koorl, kidji baal yaaka ngwoornmoorn karla-kooranyikang, kwabbarap manna-ngoonyang narrinyang. ");
INSERT INTO nys_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nginda Zechariah djinang djin-djin-kwabba, baal wayarn. ");
INSERT INTO nys_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yalga djin-djin-kwabba waangki baalany, “Yoowart wayarn, Zechariah! Boolanga-Yira baal noonany dwangkiny, moodlooka noonang koort-bwora. Elizabeth, noonang koort-maat, baal boorda boodjari-biny. Baal boorda yidja noonang nop. Noonook boorda-kolitj baalany ‘John’. ");
INSERT INTO nys_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Noonook boorda djoorab-djoorab-biny, kidji warma moorta, baalap kardjir boorda koort-kwabba nginda baal koorlangweta! ");
INSERT INTO nys_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","“Baal boorda moorditj-biny Boolanga-Yirakang miyalakal. Baal yoowart djarnyak ngarn kepa-mardayin. Ngolanga doomboo, Kangya-Kooranyi boorda-moorartitj baalany, ");
INSERT INTO nys_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","kidji baal boorda karro-barrang boola moorta Israel-ang Birdiyarak, baalapang Boolanga-Yira. ");
INSERT INTO nys_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","“Baal boorda-koorl Birdiyar-koodjookat, mardayin-djil Elijah-mokiny, Boolanga-Yirakang Warda-Marridjiny. Baal boorda karro-barrang maamana wer koorlangka dandjo-dandjo. Baal boorda korang wara-wara moorta kwabba djoorootak, alidja djooroot-djin kwabba moorta yana, moorta ngiyan kaaditj karnarny. Baal boorda kakatar Boolanga-Yirakang moorta kwadjat Birdiyar yoowal-koorl.” ");
INSERT INTO nys_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah baal waangki-djinang djin-djin-kwabba, “Yarn ngany boorda-kaaditj nginda noonang waangkiny boorda edjena? Ngany bworan, kidji nganyang koort-maat kardjir karbarli.” ");
INSERT INTO nys_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","“Ngany Gabriel,” djin-djin-kwabba waangk. “Ngany yaaka Boolanga-Yira-booram. Boolanga-Yira baal waangki-koorl nganyany noonak. Ngany djarnyak waangki noonany kidji barrang Warda-Kwabba noonak! ");
INSERT INTO nys_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","“Yalga noonook yoowart djinang-karni nganyang warrinya. Moodlooka boorda-edjena kwabba kedelakal. Narla noonook yoowart djinang-karni, noonook boorda dwangka-birt. Noonook yoowart boorda waangki kwadjat kedela nginda nganyang warrinya edjena.” ");
INSERT INTO nys_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Yeyi moorta naan-yaaka Zechariah. Baalap wandaniny narla baal kwodjang Maya-maya-Kooranyi-bwora. ");
INSERT INTO nys_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nginda baal bandak-koorl, baal yoowart kayar-waangki, kidji ngarl baalap kaaditji Zechariah kwadja-djinang koondarm Maya-maya-Kooranyi bwora. Baal maar-waangki, yoowart waangkiny. ");
INSERT INTO nys_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ngolanga baalang kedelara yakiny Maya-maya-Kooranyi bwora, Zechariah wort-koorl baalang karlap. ");
INSERT INTO nys_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mila, baalang koort-maat, Elizabeth, boodjari-biny kidji baal naan-yaaka maya-maya-bwora maar mikara. ");
INSERT INTO nys_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Yeyi ngolanga kwodjang, Boolanga-Yira maar-yanga nganyany,” baal waangki. “Baal barnak wort-barrang nganyang karnya!” ");
INSERT INTO nys_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nginda Elizabeth boodjari maar-keny mikara, Boolanga-Yira waangki-koorl djin-djin-kwabba Gabriel Nazareth-ak, karlamaya Galilee-kal. ");
INSERT INTO nys_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Baal barrang Boolanga-Yirakang warrinya mangak. Baalang ngoonoolong kwadja-yanga baalany Joseph-ang koort-maat-biny. Nidja mammarap djoowak Djelyib David-ang. Mangakang kol ‘Mary’. ");
INSERT INTO nys_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Djin-djin-kwabba koorl Mary kidji waangki, “Nakal noonak! Boolanga-Yira nyiny noonookyel kidji baal moorditj yanga-kwabba noonak!” ");
INSERT INTO nys_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mary wayarn-djil, djin-djin-kwabba dwankiny, kidji baal waangki-djinang moodlooka baalang kaat-bwora. ");
INSERT INTO nys_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Djin-djin-kwabba waangki baal, “Mary! Yoowart wayarn! Boolanga-Yira yanga-kwabba noonany. ");
INSERT INTO nys_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Noonook boorda boodjari-biny kidji yidja nop, kidji noonook boorda-kolitj baalany ‘Jesus.’ ");
INSERT INTO nys_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Baal boorda moorditj. Baal boorda kolitj-yan ‘Boolanga-Yirakang Nop’. Boolanga-Yira waangki nidja. Baal boorda yira-yaaka Djelyib, baalang maam-inram David-mokiny. ");
INSERT INTO nys_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kidji baal boorda nyiny Djelyib djoowakang Jacob-ang kalyakool. Baalang Boodjer boorda-yaaka kalyakool!” ");
INSERT INTO nys_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary waangki djin-djin-kwabba, “Ngany koolamata. Yarn nidja boorda edjena?” ");
INSERT INTO nys_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Djin-djin-kwabba waangki, “Kangya-Kooranyi boorda-koorl noonak kidji Boolanga-Yirakang moorditj boorda yira-malitji noonook. Nidja kooranyi koorlang boorda kolitj-yan ‘Boolanga-Yirakang Nop’. ");
INSERT INTO nys_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Noonook barrang-dwangka Elizabeth, noonang ngoonoolong? Moorta waangki nidja baal yoowart koorlang-yidja, yalga yeyi, baal boodjari maar-keny mikara - kidji baal kabarli. ");
INSERT INTO nys_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yoowart noolonga nyiny naatj Boolanga-Yira yoowart kayar don.” ");
INSERT INTO nys_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","“Ngany Boolanga-Yirakang yakin,” Mary waangki. “Nidja edjena-oola nganyak, moodlooka noonook waangki.” Djin-djin-kwabba wort-koorl baalany. ");
INSERT INTO nys_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ngolanga, Mary kakatar kidji baal wort-koorl karlamaya kardakal Judea-kang. ");
INSERT INTO nys_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mary bwora-koorl Zechariah-ang maya-maya, kidji baal waangki-kwabba Elizabeth. ");
INSERT INTO nys_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeth dwangka Mary-ang maaya, kidji yilak-yilak, baalang maawit marridja baalang doomboo-bwora. ");
INSERT INTO nys_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kangya-Kooranyi moorartitj Elizabeth, kidji baal woola, “Boolanga-Yira boola-djil yanga-kwabba noonook, kardakor mandang yokaman, kidji baal yanga-kwabba koorlang, keny noonook boorda yidja! ");
INSERT INTO nys_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","“Naadjil nidja moorditj noolong edjena nganyak, yeyi nganyang Birdiyarang ngaangk yoowal-koorl, yoowal-koorl djinangak nganyany? ");
INSERT INTO nys_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Narla nginda noonook waangki-kwabba nganyany, ngany dwangka noonook, kidji nganyang koorlang ngany-bwora djoorabiny bardang. ");
INSERT INTO nys_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Noonook djarnyak djoorab-djoorab, kaaditjiny Boolanga-Yirakang warrinya noonak boorda-edjena!” ");
INSERT INTO nys_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary waangki: “Nganyang koort yanganan Boolanga-Yira. ");
INSERT INTO nys_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nganyang koortoomitj djoorab narla Boolanga-Yira barrang nganyang ngandabat, ");
INSERT INTO nys_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","narla baal barrang-dwangka nganyany, baalang wirt yakin! Yeyi moortaman, baalap boorda-waangki ngany djoorab, ");
INSERT INTO nys_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","narla Boolanga-Yira baal kwadja-don moorditj noolonga nganyang. Baalang kol kooranyi. ");
INSERT INTO nys_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Baal ngorna-kwabba moortakak ngiyan woonya baalany kidji yaka baalang, moorta djoowakang koora wer djoowakang yeyi. ");
INSERT INTO nys_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Baal kwadja-yiraman baalang mardayin maar, kidji baalil yoorang-yoorang warma moorta, moortaman wambadin kaaditjiny. ");
INSERT INTO nys_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Baal ngarda-barrang moorditj djelyiba yirap nyinyiny, kidji baal barrang-yira wirt moorta. ");
INSERT INTO nys_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Baal kwadja-moorartitj koboorl-wirt moorta, baalapany yanginy kwabba noolonga, yalga moorta boola boya-kadak, baalil waangki-wort-koorl baalapany, baalapang maara bilyar. ");
INSERT INTO nys_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Baal barrang-yalgawa baalang warrinya, moodlooka baal warranga ngalang maam-inrama, kidji baal yoowal-koorl kidji baalil maar-yanga baalang moorta Israel-ang. ");
INSERT INTO nys_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Baal kwadja-barrang-dwangka ngalany, baal ngorna-kwabba Abraham-ak kidji baalang mandang djoowaka kalyakool!” ");
INSERT INTO nys_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary naan-yaaka mo mila Elizabeth-al, kidji ngolonga, baal wort-koorl baalang karlamaya. ");
INSERT INTO nys_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Yeyi kedela koorl Elizabeth-ang maawitang. Baal yidja nop. ");
INSERT INTO nys_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elizabeth-ang ngoonoolonga wer baalang babina, baalap dwangka nidja warda. Boolanga-Yira moorditj yanga-kwabba Elizabeth, kidji baalap mandang djoorab-abiny Elizabeth-ang. ");
INSERT INTO nys_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ngolanga maar-koodjal kedela, moorta koorl maawitang kardjatinyang, alimarn Warriny waangki. Baalap koordook kolitjo baalany ‘Zechariah’, baalang maaman-mokiny. ");
INSERT INTO nys_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yalga baalang ngaangk waangki, “Yoowart! Baalang kol ‘John’.” ");
INSERT INTO nys_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ngarl baalap waangki baalany, “Yoowart noonookang ngoonoolonga kolitj-yan ‘John!” ");
INSERT INTO nys_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Karro baalap maar-waangki baalang maamanak. Baalap waangki-djinang baalany naatj kol baal koordook yango baalang nop. ");
INSERT INTO nys_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariah ngakaka mili-mili kidji baal boordak, “Baalang kol ‘John’.” “Kai!” baalap mira. ");
INSERT INTO nys_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Winidjinbar, Zechariah kayar waangki karro, kidji baal malyak Boolanga-Yirany yangananiny. ");
INSERT INTO nys_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Moortaman wayarn-abiny, kidji nidja warda koorl mandang kardak boodjerang Judea-ang. ");
INSERT INTO nys_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nginda moortaman dwangka nidja warda, baalap malyak kaaditjiiny kidji waangki-djinanginy, “Naatj nidja koorlang boorda-don?” Moortaman, baalap djinang Boolanga-Yirang mardayin nyiny koorlangal. ");
INSERT INTO nys_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kangya-Kooranyi yoowal-koorl Zechariah, John-ang maaman, kidji Kangya-Kooranyi moorartitj baalany. Zechariah waangki Boolanga-Yirakang Warda-Kwabba: ");
INSERT INTO nys_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ngala boorda yanganan Birdiyar! Baal Israel-ang Boolanga-Yira! Baal kwadja-koorl baalang moortakak, baalapany maar-yanginy kidji baalapany yalkaraniny. ");
INSERT INTO nys_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Boolanga-Yira kwadja-yanga ngalany baalang mardayin Nop. Baal boorda barrang-ngandabat ngalany. Baal David-ang djoowak, baalang yakin. ");
INSERT INTO nys_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Koora, baal warrin-yanga baalang Warda Marridjiny. ");
INSERT INTO nys_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Baal waangki nidja, baal boorda barrang-ngandabat ngalany, ngarl wara-wara moorta yoowart kayar-bakatj ngalany kidji yardjang ngalany. ");
INSERT INTO nys_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Baal waangki nidja, baal boorda ngorna-kwabba ngalang maam-inramak, kidji baal boorda barrang-dwangka baalang kooranyi warrinya, mandang warrinya baal yanga baalapany ");
INSERT INTO nys_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Baal ngwidam waangki Abraham-ak, ngalang maam-inram. Baal yanga baalang kooranyi warrin. Baal boorda barrang-ngandabat ngalany ngarl wara-wara moorta yoowart bakkan ngalany, kidji ngarl ngala kayar-yaka Boolanga-Yirang, wayarn-birt. ");
INSERT INTO nys_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ngarl ngala boorda nyiny kooranyi wer kwabba-djil, Boolanga-Yira-booram, mandang kedelara ngalang ngandabatang. ");
INSERT INTO nys_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nganyang koorlang, baalap boorda-kolitj noonookany, ‘Boolanga-Yirang Warda Marridjiny’. Noonook boorda-koorl Birdiyar koodjookat kidji kakatar baalang djooroot, ");
INSERT INTO nys_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kidji noonook boorda-warrang baalang moorta nidja: Boolanga-Yira boorda barrang-ngandabat baalapany nginda baal nyinya-nyinya baalapang wara-doniny. ");
INSERT INTO nys_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ngalang Boolanga-Yira yanga koort-kwabba kidji baal bedik-bedik. Baal boorda barrang ngalang ngandabat, ngangk-mokiny yirabiny ");
INSERT INTO nys_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nginda ngangk moonakiny Boolanga Yirang Boodjer-yen, moortamanak wininginy malitji mayartal noyitjang, kidji baal boorda-barrang-yalgawa ngalang djena djoorootal nakalang.” ");
INSERT INTO nys_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Koorlang kwabba-djil maladja, mardayan yarlinal wer kwoyalangal. John naan-yaaka kwangkanal kwadjat kedela nginda baal barnak koorl moortakak Israel-ang. ");
INSERT INTO nys_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yeyi Djelyib Augustus koordook djinanginy ngalan moorta wininginy baalang boodjeral. ");
INSERT INTO nys_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nidja koriyat bordakiny kolang moortamanang. Nidja edjena nginda Qurinius nyiny birdiyar Syria-ang. ");
INSERT INTO nys_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Moortaman koorl baalaparoo karlamaya, maam-inramang karlamaya. Bokadja, baalap boordak baalapang kola mili-milikal. ");
INSERT INTO nys_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph wandja Nazareth, Galilee-kang karlamaya, kidji koorl Bethlehem, karlamaya Judea-kal. Djelyib David kwadja-koorlangweta Bethlehem-al. Joseph koorl Bethlehem narla baal djoowak David-ang. ");
INSERT INTO nys_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Baal wer baalang koort-maat Mary, koodjal koorl Bethlehem boordakak baalapang kola. Mary-yang ngoongoolonga kwadja-yanga Mary-yany Joseph koorta-barranginy. Mary boodjari. ");
INSERT INTO nys_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Koodjal yoowal-koorl Bethlehem, karro dji edjena Mary-yang yidjiny baalang maawit. ");
INSERT INTO nys_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mary yidja baalang koriyat nop, baal wolang baalany bwokal kidji baal ngoming baalany mayakal booliyakang merenyang, narla yoowart ngowort koodjalang ngwoorndak karlamayakal. ");
INSERT INTO nys_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Alitja boodjeral, kookendjeriyang-yakina kwadja-yaka bandak kadikal, baalapang kookendjerira karrodjininy. ");
INSERT INTO nys_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kenyang Boolanga-Yirang djin-djin-kwabba yoowal-koorl baalapany-ngat, kidji Boolanga-Yirang moorditj-moorditj binari yira-birrikon baalapany. Baalap wayarn-djil. ");
INSERT INTO nys_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yalga djin-djin-kwabba waangki baalapany, “Yoowart wayarn! Ngany yoowal-koorl, kwabba warda noonookak barranginy. Nidja warda boorda barrang djoorab-djoorab-djil moortamanak! ");
INSERT INTO nys_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","“Yeyi nidja kedela, David-ang karlamayakal, Keny-Barranginy-Ngandabat koorlangweta - Christ Birdiyar! ");
INSERT INTO nys_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kidji noonooka karnarny boorda-djinang: noonooka maawit boorda-djinang, bwokal wolang-yan, kidji mayakal merenyang ngwoorndiny.” ");
INSERT INTO nys_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Yilak-yilak, boola-boola djin-djina-kwabba ngarda-koorl Boolanga-Yirakang Boodjer-yen. Baalap yaaka warma djin-djin-kwabba-ngat, warrangkiny kidji Boolanga-Yirany yanganiny. ");
INSERT INTO nys_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Moorditj-moorditj yanganan Boolanga-Yirak, yira-yira baalang Kooranyi Boodjeral, kidji nakal ngalang Boodjeral. Nakal kwabba moortamanak. Boolanga-Yira djoorabiny baalapyel.” ");
INSERT INTO nys_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nginda djin-djina-kwabba korl-koorl Boolanga-Yirang Boodjer, kookendjeriyang-yakina dandjo-waangki, “Ngala boorda-koorl Bethlehem kidji ngala djinang nidja noolong, naatj Boolanga-Yira waangki boorda-edjena.” ");
INSERT INTO nys_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Baalap wort-kakoodjen kidji baalap yoowal-koorl Mary-any wer Joseph. Baalap djinang maawit. Baal mayakal merenyang ngwoorndiny. ");
INSERT INTO nys_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nginda kookendjeriyang-yakina djinang maawit, baalap warranga koodjalany natj djin-djin-kwabba waangki koorlangang. ");
INSERT INTO nys_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Koodjal kai-kai nginda koodjal dwangka nidja-nidja noolonga, moodlooka kookendjeriyang-yakina waangki. ");
INSERT INTO nys_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary barrang-dwangka mandang nidja-nidja noolonga, kidji baal barrang-yalgawa moodlooka baalang koortal. ");
INSERT INTO nys_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kookendjeriyang-yakina korl-koorl, yedi-waangkiny kidji Boolanga-Yirany yanganiny narla moodlookang natj baalap kwadja-dwangka kidji djinang. Moodlooka kwadja-edjena, moodlooka djin-djin-kwabba waangki baalapany. ");
INSERT INTO nys_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ngolanga maar-koodjal kedelara, kedela yoowal-koorl kardjatak maawit, alimarn Warriny waangki. Koodjal kolitj baalany ‘Jesus’, narla djin-djin-kwabba yanga koodjalany alitja kol koora Mary boodjari-biny. ");
INSERT INTO nys_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kedela yoowal-koorl nginda Joseph wer Mary-yang boorda-don maawitang Kedela Barnanang alimarn Moses-ang Warriny waangki. Ngarl koodjal barrang maawit Jerusalem-ak, yangak baalany Boolanga-Yirakak, ");
INSERT INTO nys_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","narla boordakiny Boolanga-Yirang Warrinyal waangki, “Noonooka boorda yanga noonookang koryat nop Boolanga-Yirak.” ");
INSERT INTO nys_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Koodjal kardjir djarnyak yanga-narra koodjal djert, alimarn Boolanga-Yirang Warriny waangki, mana-barangka ka nembing. ");
INSERT INTO nys_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Alidja-alidja kedalara, Simeon nyiny Jerusalem. Baal kwabba mammarap. Baal ala Boolanga-Yira kidji baal ngayaka kedela nginda Boolanga-Yira boorda barrang-ngandabat Israel. ");
INSERT INTO nys_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kangya-Kooranyi nyiny Simeon-bwora kidji Kangya warranga baalany natj baal yoowart boorda wanni kwadjat baal djinang kedela nginda Keny boorda-yoowal-koorl, Keny Boolanga-Yira Waangki-Koorliny. ");
INSERT INTO nys_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kangya-Kooranyi barrang Simeon Maya-maya-Kooranyi-bwora. Winidjinbar, Jesus-ang maaman wer ngaangk barrang maawit Maya-maya-Kooranyi bwora, doniny natj Boolanga-Yirang Warriny waangki. ");
INSERT INTO nys_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon maara-barrang maawit kidji yanganan Boolanga-Yira. ");
INSERT INTO nys_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Birdiyar, noonook barrang-yalgawa noonang warrin, kidji yeyi, wort-koorl-oola noonang yakina nakalal. ");
INSERT INTO nys_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nganyang miyala kwadja-djinang noonany, yoowal-koorliny kidji ngalany barrang-ngandabatiny ");
INSERT INTO nys_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Noonook kwadja-don nidja noolong moortaman booram: ");
INSERT INTO nys_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Noonook waangki-koorl binari, warma moortamanal moonakiny; moorditj-moorditj-djil binari noonang moortang, Israel.” ");
INSERT INTO nys_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jesus-ang maaman wer ngaangk kai-kai dwangko nidja-nidja noolonga, moodlooka Simeon waangki Jesus-ang. ");
INSERT INTO nys_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon yanga-kwabba baalapany kidji baal waangki Mary, Jesus-ang ngaangkany, “Boolanga-Yira waangki-koorl nidja koorlang moortak Israel-ang. Baal boorda djakanak boola moorta kidji baal boorda barrangak-ngandabat boola moorta. Baal Boolanga-Yirang ngambany. Boola moorta boorda wara-waangki baalany. ");
INSERT INTO nys_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Moorta kobin baalapang kaaditjiny, yalga moodlooka boorda-djinang-yan. Kidji winyan boorda-kardjat noonang koort djarp djillab-mokiny.” ");
INSERT INTO nys_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Anna, baal nyiny karbarli yenang, kidji baal nyiny Warda Marridjiny. Baal Phanuel-ang kowart, ngoongoolong Asher-ang. Baal kwadja-koorta-barrang arda maar-koodjal biroka kidji yeyi baal kadak 84 biroka. Baal yoowart wort-koorl Maya-maya-Kooranyi. Kedela wer kadik, baal yanganan Boolanga-Yirany, yoowart ngarniny, kidji kalyakool Boolanga-Yira waangkiny. ");
INSERT INTO nys_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Winidjinbar, baal yoowal-koorl kidji baal yanganan Boolanga-Yira. Baal waangki moortaman, alidja-alidja nganayaka Boolanga-Yira boorda yalkaran Jerusalem. Anna warrang baalap koorlangang. ");
INSERT INTO nys_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ngolanga Joseph wer Mary nganitj moodlooka, mandang noolonga Boolanga-Yirang Warriny waangki, koodjalil korl-koorl koodjalang karlap, karlamaya Nazareth Galilee-kal. ");
INSERT INTO nys_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Koorlang maladja kidji mardayin-biny; baal kwadja moorart-biny karnarnyang wer kaaditjinyang, kidji Boolanga-Yira yanga-kwabba baalany. ");
INSERT INTO nys_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Djilba yoowal-koorl, ngarl Jesus-ang maaman wer ngaangk kalyakool koorl Jerusalem Mandjar Djendjeriny-Yirakang. ");
INSERT INTO nys_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nginda Jesus kadak 12 biroka, baalap koorl Mandjarak, alimarn kalyakool. ");
INSERT INTO nys_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ngolanga Mandjar, koodjal malyak korl-koorliny koodjalang karlap, yalga Jesus, koodjalang nop, baal naan-yaaka Jerusalem-al. Baalang maaman wer ngaangk yoowart kaaditj. ");
INSERT INTO nys_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Koodjal kaaditj Jesus kwadja-koorl koodjalang ngooloongongal, ngarl koodjal koorl keny kedela kidji karro koodjal malyak koorl-djinanginy Jesus koodjalang babina wer ngoonoolonga kardakor. ");
INSERT INTO nys_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Koodjal yoowart djinang Jesus, ngarl koodjal korl-koorl Jerusalem, baalany koorl-djinanginy. ");
INSERT INTO nys_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ngolanga mo kedelara, koodjalil djinang Jesus Maya-maya-Kooranyi-bwora Mammarap Warrinyang-boongal, baalapany dwangkiny kidji baalapany waangki-djinanginy. ");
INSERT INTO nys_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Moortaman Jesus-any aliny, baalap kai-kai narla baalang kaaditjinyang wer baalang warrinya. ");
INSERT INTO nys_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jesus-ang maaman wer ngaangk kai-kai nginda koodjal djinang baalany, kidji Jesus-ang ngaangk waangki baalany, “Nop, nadjil noonook don nidja noolong ngalak? Noonang maaman wer ngany kwadja-wayarn kidji ngala koordook djinango noonany.” ");
INSERT INTO nys_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesus waangki koodjalany, “Nadjil nyoodjoowal djarnyak yoowal-koorl nidjap, nganyany korl-djinanginy? Nyoodjoowal yoowart kaaditj natj ngany djarnyak nyiny nidja, nganyang Maamanang Maya-maya-bwora, wa?” ");
INSERT INTO nys_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yalga koodjal yoowart kaaditj Jesus-ang warrinya. ");
INSERT INTO nys_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ngarl Jesus koorl Nazareth koodjalyel. Bokadja, baal dwangka koodjalany, moodlooka doniny koodjal ngakaka. Jesus-ang ngaank kanya mandang nidja-nidja noolonga baalang koort-bwora. ");
INSERT INTO nys_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus maladja mardayinal wer kaadjitinyal, kidji baal kwabba maladja Boolanga-Yirang miyalakal wer moortakang miyalakal. ");
INSERT INTO nys_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nginda Djelyib Tiberius kwadja nyiny djelyib 15 biroka; Pontius Pilate nyiny birdiyar Judea-kang, Herod nyiny birdiyar Galilee-kang. Baalang ngooni Philip nyiny birdiyar boodjerang Iturea-ang wer Trachonitis-ang; Lysanias nyiny birdiyar Abilene-ang. ");
INSERT INTO nys_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas wer Caiaphas nyiny Birdiyara Yakina-Kooranyikang. Yeyi kwangkanal, Boolanga-Yira waangki John, Zechariah-ang nop. ");
INSERT INTO nys_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ngarl John koorl yennar bangka boodjerang bilyakang Jordan, warranginy: “Wort-korang noonang wara-doniny kidji kakaloorni kepakal, kidji Boolanga-Yira boorda-nyinya-nyinya noonang wara-doniny. ");
INSERT INTO nys_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Warda-Marridjiny Isaiah boordak nidja-nidja warrinya milikmilikal: ‘Keny mammarap kwangkanal miriny, “Kakatar Birdiyarang djooroot! Warn doorgool djooroot baalang marridjiny! ");
INSERT INTO nys_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Noonooka djarnyak moorartitj mandang wedina. Noonooka djarnyak ngardak-warn mandang morda wer karda. Noonooka djarnyak doorgool-warn mandang ngalen djooroota. Noonooka djarnyak kanyak-warn mandang barr djooroota. ");
INSERT INTO nys_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Moortaman boorda djinang Boolanga-Yira. Baal boorda barrang-ngandabat baalang moorta.”’” ");
INSERT INTO nys_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Moorta boola bandak-koorl John-ak. Baal kakaloorni baalapany kepakal. “Noonooka wakala!” John waangki baalap, “Ngiyan waangki alidja noonooka boorda-kwibidji? Kayida, Boolanga-Yira boorda-waangki-koorl noonookang djin-baminy! ");
INSERT INTO nys_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Don kwabba noolonga ngarl moorta boorda djinang noonooka kwadja wort-korang noonookang wara-doniny. Yoowart waangki kardakor noonookaal, ‘Abraham nyiny ngalang maam-inram’. Ngany noonookany waangki, Boolanga-Yira kayar warn nidja-nidja boyaka Abraham-ang djoowaka-biny. ");
INSERT INTO nys_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Koyitj kakatar bam-kadongak djinnara boornang. Mandang boorna yoowart kwabba djildji yidjiny, baalap boorda bam-kadong-yan kidji kwarda-yan karla-bwora.” ");
INSERT INTO nys_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Moorta waangki-djinang John, “Natj ngala boorda-don karro?” ");
INSERT INTO nys_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Baal waangki, “Bayinya moorta kadak koodjal bwoka, baal djarnyak yanga keny moortak bwoka-birt, kidji moort kadak mereny wer djaatj, baal djarnyak walak-walak.” ");
INSERT INTO nys_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Moorta boya-barranginy, baalap yoowal-koorl kakaloorninyang kidji baalap waangki-djinang John, “Birdiyar, natj ngala boorda don?” ");
INSERT INTO nys_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","John waangki baalap, “Yoowart kanga boya-ngatti nadjang Warriny waangki.” ");
INSERT INTO nys_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mammarapa-bakadjiny kardjir waangki-djinang baal, “Natj ngalang? Natj ngala djarnyak don?” John waangki baalap, “Yoowart bakkan moorta kidji yoowart ngakalya baalapang boya, kidji yoowart koolyoomitj moortakang. Noonooka djarnyak koota-kwabba boya-yel birdiyara yanga noonookany.” ");
INSERT INTO nys_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Moorta kwadjin koort-kwidiny, kidji baalap kwadjin kaaditjiny, “Kabin John nyiny Keny Boolanga-Yira Waangki-Koorliny!” ");
INSERT INTO nys_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ngarl John waangki mandang baalapany, “Ngany kakaloorni noonookany kepakal yalga warma moort yoowal-koorliny. Baal moorditj-ngatti nadjang nganyany. Ngany yoowart kwabba kinyak baalang djena-bwoka bilyaniny. Baal boorda-kakaloorni noonookany Kangya-Kooranyiyal wer karlal. ");
INSERT INTO nys_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Baal barranga baalang mirlkoon kidji baal boorda yoorang-yoorang kwolaka. Baal boorda bama mandang kwolaka kidji wedjang kwabba kwolaka baalang maya-maya-bwora kwolakang. Yalga baal boorda-narra yimbara karla-bwora. Alidja karla narra kalyakool.” ");
INSERT INTO nys_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","John warranga Warda-Kwabba moortakal. Baal banitja boola warma war. John karlaka baalapany, baalap djarnyak walak-yidja baalapang wara-wining. ");
INSERT INTO nys_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yalga John djaat Djelyib Herod, narla baal kwadja koorta-barrang Herodias, baalang ngooniyang koort-maat, kidji baal don boola warma wara-wara noolonga. ");
INSERT INTO nys_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Karro Herod don wara-djil noolong: baalang manatja yardjan John kidji yadarn baalany maya-maya dedinyang-bwora. ");
INSERT INTO nys_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ngolanga John kwadja kakaloorni moortaman kepakal, John kadjir kakaloorni Jesus-any. Korram Jesus waangki Boolanga-Yirany, Boolang Yirakang Boodjer yalgaran, ");
INSERT INTO nys_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","kidji Kangya-Kooranyi ngarda-koorl Jesus-al yarlin-mokiny mana-boorangkang. Kidji waangka ngarda-koorl Boolanga-Yirang Boodjer-yen, “Noonook baalang keny Nop. Nganya woonya noonany kidji ngany koort-kwabba noonal!” ");
INSERT INTO nys_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nginda Jesus kadak 30 birokaka, baal malyak baalang yakiny. Moorta waangki alidja baal Joseph-ang nop. Joseph nyiny Heli-kang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matthat-ang nop, Levi-kang nop, Melchi-kang nop, Jannai-kang nop, Joseph-ang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Mattathias-ang nop, Amos-ang nop, Nahum-ang nop, Esli-kang nop, Nakgai-kang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maath-ang nop, Mattathias-ang nop, Semein-ang nop, Josech-ang nop, Joda-kang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanan-ang nop, Rhesa-kang nop, Zerubbabel-ang nop, Shealtiel-ang nop, Neri-kang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melchi-kang nop, Addi-kang nop, Cosam-ang nop, Elmadam-ang nop, Er-ang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Joshua-kang nop, Eliezer-ang nop, Jorim-ang nop, Mattath-ang nop, Levi-kang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeon-ang nop, Judah-kang nop, Joseph-ang nop, Jonam-ang nop, Eliakim-ang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea-kang nop, Menna-kang nop, Mattatha-kang nop, Nathan-ang nop, David-ang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesse-kang nop, Obed-ang nop, Boaz-ang nop, Salmon-ang nop, Nahshon-ang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Amminadab-ang nop, Admin-ang nop, Arni-kang nop, Hezron-ang nop, Perez-ang nop, Judah-kang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacob-ang nop, Isaac-ang nop, Abraham-ang nop, Terah-kang nop, Nahor-ang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug-ang nop, Reu-kang nop, Peleg-ang nop, Eber-ang nop, Shelah-kang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cainan-ang nop, Arphaxad-ang nop, Shem-ang nop, Noah-kang nop, Lamech-ang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Methuselah-kang nop, Enoch-ang nop, Jared-ang nop, Mahalalel-ang nop, Kenan-ang nop, ");
INSERT INTO nys_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enosh-ang nop, Seth-ang nop, Adam-ang nop, Boolanga-Yirakang nop. ");
INSERT INTO nys_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus korl-koorl Bilya Jordan-yen, moorart Kangya-Kooranyang. Karro Kangya-Kooranyi barrang baalany kwangkanal. ");
INSERT INTO nys_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Djenak djona-karra baalany kwangkanal 40 kedelara. Mandang alidja-alidja kedelara, baal yoowart ngarn mereny wer djaadj, ngarl ngolonga boola kedelara Jesus koboorl-wirt. ");
INSERT INTO nys_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Djenak waangki Jesus, “Bayinya noonook Boolanga-Yirakang Nop, waangki nidja boya mereny-biny.” ");
INSERT INTO nys_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yalga Jesus waangki, “Boordakiny-Kooranyi waangki, ‘Moorta yoowart wining arda merenyal.’” ");
INSERT INTO nys_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Karro Djenak yira-barrang baalany. Keny djiyal, baal djinang moodlooka, mandang boodjera mandang djelyibakang Boodjerang. ");
INSERT INTO nys_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Djenak waangki baalany, “Ngany boorda yanga noonany mandang nidja-nidja noolonga, moorditj mardayin wer boola boya. Yeyi ngany kadak mandang nidja, kidji ngany kayar-yanga moodlooka moortak ngany koordook. ");
INSERT INTO nys_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Noonook boorda-kadak mandang nidja-nidja noolonga, bayinya noonook boni-nanookawin nganyak.” ");
INSERT INTO nys_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus waangki, “Boordakiny-Kooranyi waangki, ‘Yanganan Birdiyar, noonang Boolanga-Yira, kidji arda yaka baalang.’” ");
INSERT INTO nys_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Karro Djenak barrang Jesus Jerusalem-ak kidji baal yidja Jesus yira-djil Maya-maya-Kooranyikal, kidji waangki baalany, “Bayinya noonook Boolanga-Yirang Nop, karro ngarda-boordang, ");
INSERT INTO nys_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","narla Boordakiny-Kooranyi waangki, ‘Boolanga-Yira boorda-waangki-koorl baalang djin-djina-kwabba kidji baalap boorda-barrang-ngandabat noonany.’ ");
INSERT INTO nys_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Boordakiny-Kooranyi kadjir waangki, ‘Baalap boorda-maara-barrang noonany, ngarl noonang djena yoowart boorda-bama boyara.’ ” ");
INSERT INTO nys_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yalga Jesus waangki, “Boordakiny-Kooranyi kadjir waangki, ‘Noonook yoowart djarnyak djona-karra noonang Boolanga-Yira.’ ” ");
INSERT INTO nys_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nginda Djenak nganitj Jesus-any djoniny-karriny yennar waral, baal wort-koorl. ");
INSERT INTO nys_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Karro Jesus korl-koorl kidji Kangya-Kooranyiyang mardayin nyiny baalany-bwora. Warda baalang kooramba-koorl alidja boodjeral. ");
INSERT INTO nys_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesus karni-waangki moorta Maya-mayara-Kalyara-bwora, kidji moortaman kwabba-waangki baalang. ");
INSERT INTO nys_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Karro Jesus koorl Nazareth. Baal kwadja-maladja alidja karlamayal, kidji Kedela-Kooranyikal, baal koorl Maya-maya-Kalyara. Baal yiraba djinang-waangko Boordakiny-Kooranyi, ");
INSERT INTO nys_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","kidji baalap yanga baalany boordakiny Warda-Marridjinyang Isaiah. Baal yanganan mili-mili kidji djinbarranga bangka waangkiny: ");
INSERT INTO nys_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Boolanga-Yirang Kangya kwadja bwora-koorl nganyany, narla baal mira nganyany barranginy Warda-Kwabba winyan moortakak. Baal kwadja waangki-koorl nganyany warranginy yalkaran moortakak yatar-yan kidji yanginy miyala-djinanginy miyala-birt moortakak, kidji barranginy-yira moortany ngiyan ngarda-bilang-yan, ");
INSERT INTO nys_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kidji waangkiny, ‘Kedela kwadja yoowal-koorl nginda Birdiyar boorda-barrang-ngangandabat baalang moorta.’” ");
INSERT INTO nys_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesus barrang-ballar mili-mili, yanga yakinak, kidji nyiny. Maya-maya-Kalyarakal, moortaman miyalitj baalany. ");
INSERT INTO nys_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Baal waangki baalapany, “Nidja bangka Boordakiny-Kooranyikang karnany edjena nidja kedela, yeyi alimarn noonooka dwangka warrinya.” ");
INSERT INTO nys_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Moortaman kwabba-kaaditj baalang. Baalap kai-kai narla baalang kwabba-djil warrinya. Baalap waangki, “Baal Joseph-ang nop, wa?” ");
INSERT INTO nys_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Baal waangki baalapany, “Ngany kaaditj noonooka boorda waangki nidja bardip nganyak, ‘Malka, barra-barra noonaal!’ Noonooka kadjir boorda waangki nganyany, ‘Nidja noonang karlamayal, don noolonga-djin ngala dwangka, noolonga noonook kwadja don Capernaum-al.’” ");
INSERT INTO nys_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Ngany warranga noonookany,” Jesus waangki, “Moorta yoowart kwabba-waangki Warda-Marridjinyang baalroo karlamayakal. ");
INSERT INTO nys_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ni nganyak! Karnayal, boola yenanga wining Israel-al kedelaral Elijah-kang. Yoowart kepa koorl mo wer bangka birokayang, kidji wara-wara kedelara yambo-koorl boodjera, kedelara mereny-birt. ");
INSERT INTO nys_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yalga Boolanga-Yira yoowart waangki-koorl Elijah keny moortak Israel-ang, yalga arda yenangak Zarephath-al boodjerakal Sidon-ang. ");
INSERT INTO nys_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Boola moorta alidjap minditj, kadak wara-morba, yalga Elijah yoowart barra-barra keny baalapang, arda Naaman Syria-karlap.” ");
INSERT INTO nys_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Moortaman Maya-maya-Kalyara-bwora, baalap dwangka Jesus kidji baalap kaarang-kaarang-biny. ");
INSERT INTO nys_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Baalap yiraba kidji baalap yardjang Jesus kidji baalap bandak-barrang Jesus. Baalapang karlamaya nyiny kardal. Baalap malyak kwardiny Jesus kard-ngarda, ");
INSERT INTO nys_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","yalga baal wokart-koorl didara mortakang kidji baal koorl baalang djooroot. ");
INSERT INTO nys_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Karro Jesus koorl Capernaum, karlamaya Galilee-kang. Kedela-Kooranyikal, baal karni-waangki moorta. ");
INSERT INTO nys_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Moortaman dwangka Jesus. Baalap kai-kai-biny narla baal mardayin-djil waangki. ");
INSERT INTO nys_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Keny mammarap Maya-maya-Kalyarakal kwadja-nyinyiny. Keny djenak-wara wining baalany-bwora. Baal mardayin-djil waangki-djan: ");
INSERT INTO nys_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Naa! Natj noonook koordook ngalang, Jesus Nazareth-karlap? Noonook koorl dargango ngalany, wa? Ngany kaaditji noonany. Noonook Boolanga-Yirang Warda-Marridjiny!” ");
INSERT INTO nys_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus warranga djenak-wara, “Yoowart waangkiny! Bandak-koorl mammarap!” Djenak-wara ngarda-kwarda mammarap baalapang-booram kidji baal wort-koorl kidji yoowart bakkan baalany. ");
INSERT INTO nys_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Moortaman kardi kidji dandjo-waangki, “Natj nidja-nidja baalang warrinya? Nidja mammarap mardayin waangki kidji djenaka-wara bandak-koorl!” ");
INSERT INTO nys_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kidji warda Jesus-ang yambo-koorl mandang boodjer. ");
INSERT INTO nys_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus wort-koorl Maya-maya-Kalyara kidji baal koorl Simon-ang maya-maya. Ngaangk Simon-ang koort-maatang minditj-wara kidji kalarak, kidji baalap warranga Jesus baalang. ");
INSERT INTO nys_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yok ngwoordiny ngarl Jesus koorl kidji baal yaaka yok-boongal. Jesus warranga minditjak wort-koorlo yok. Baalang minditj wort-koorl, kidji baal yiraba kidji baal kwadjin baalapang mereny kakatiny. ");
INSERT INTO nys_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ngolanga ngangk-ngardak, moortaman barrang baalapang babina Jesus-ak, minditj-wara moorta. Baal maar-barrang baalapany kidji baal barra-barra mandang baalapany. ");
INSERT INTO nys_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Djenaka-wara kardjir wandja boola moortakany, waangki-djaniny, “Noonook Boolanga-Yirang Nop!” Jesus ngwidam waangki djenaka-wara, baalapany warranginy yoowart waangko narla djenaka-wara kaaditj Jesus nyiny Keny Boolanga-Yira Waangki-Koorl. ");
INSERT INTO nys_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ngangk-yira kidji Jesus wort-koorl Capernaum, kidji koorl doombart kwangkanak. Moorta malyak baalany koorl-djinanginy, kidji nginda baalap djinang baalany, baalap koordook nganitjak baalany kidji baalap ngakaka baalany yoowart wort-koorlak. ");
INSERT INTO nys_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yalga Jesus waangki baalapany, “Ngany djarnyak koorl warma karlamayaka, warrango mortakany Warda-Kwabba, baalapany warranginy Boodjerang Boolanga-Yirang Djelyibiny, narla Boolanga-Yira waangki-koorl nganyany dono nidja noolonga.” ");
INSERT INTO nys_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ngarl Jesus warranga mandang Maya-mayara-Kalyara-bwora boodjerang. ");
INSERT INTO nys_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kedela koorl kidji Jesus yaaka walbaril Malar Gennesaret-ang. Moorta bilang warma moorta. Baalap yoowal-koorl ngarl baalap kayar dwangka Boolanga-Yirang warrinya. ");
INSERT INTO nys_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesus djinang koodjal wandaberira wabaril; mammarapa-djildjitiny kwadja-wandja wandaberika kidji baalapang kooda-djildjitiny kwadja kakaloorniny. ");
INSERT INTO nys_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesus kana Simon-ang wandaberi-bwora kidji baal waangki Simon, “Wort-koorn walbar-boordak.” Jesus nyiny wandaberi-bwora kidji karni-waangki moortaman. ");
INSERT INTO nys_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nginda Jesus nganitj waangkiny, baal waangki Simon, “Koorl mordak kepak. Noonook wer noonang babina, ngardakwir noonookang koodaka kidji noonooka boorda barrang djildjita.” ");
INSERT INTO nys_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Birdiyar,” Simon waangki. “Ngala ngwidam-djil yaka mandang kadik kidji yoowart barrang djildjita. Yalga, bayinya noonook waangki, ngany boorda-ngardakwir koodaka.” ");
INSERT INTO nys_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Baal ngardakwir koodaka kidji barrang boola-boola djildjita ngarl koodaka boordak djakan. ");
INSERT INTO nys_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ngarl baalap mira baalapang babina warma wandaberiyal. Baalap yoowal-koorl kidji maar-yanga baalapany. Baalap moorartitj koodjal wandaberira djildjitakal ngarl koodjal wandaberira boordak ngardal. ");
INSERT INTO nys_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nginda Simon Peter djinang natj edjena, baal boni-nanookawin Jesus-booram kidji baal waangki, “Wort-koorl nganyany, Birdiyar! Ngany wara-wara mammarap!” ");
INSERT INTO nys_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon wer warma moorta kai-kai narla baalap kwadja barrang boola-boola djildjita. ");
INSERT INTO nys_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kardjir, Simon-ang babina, James wer John, Zebedee-kang nopa, baalap kai-kai. Jesus waangki Simon, “Yoowart wayarn-abiny. Nidja kedela, noonook boorda kwadjin moorta dalanginy.” ");
INSERT INTO nys_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Baalap djookoorn baalapang wandaberika walbaral, kidji wandja moodlooka, kidji kambarn Jesus. ");
INSERT INTO nys_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ngolonga, Jesus koorl warma karlamaya. Keny mammarap wining karlamayal, baal kadak wara-wara morba-minditj. Nginda baal djinang Jesus, baal djabalar kidji koort-koort Jesus, “Birdiyar, bayinya noonook koordook, noonook kayar-barra-barra nganyany!” ");
INSERT INTO nys_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus baka baalany. “Kaya, ngany koordook!” Jesus waangki, “Noonook barnan!” Winidjinbar, mammarapang minditj wandja baalany. ");
INSERT INTO nys_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesus waangki baal, “Yoowart warranga moorta, yalga noonook koorl yakin-kooranyi kidji baal djinang-oola noonany. Nidja marlanga moortakak alidja noonook barra-barra-yan. Karro noonook koorl kidji yanga-narra, waral Moses-ang Warriny waangki.” ");
INSERT INTO nys_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yalga warda Jesus-ang yambo-koorl mandang boodjer. Boola moorta yoowal-koorl, dwangko Jesus. Minditj moorta yoowal-koorl kidji Jesus barra-barra baalapany. ");
INSERT INTO nys_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yalga Jesus doombart wort-koorl kwangkanak, waangkak Boolanga-Yira. ");
INSERT INTO nys_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Warma kedela, Jesus kwadja karni-waangkiny. Pharisees wer Mammarapa-Warrinyang, baalap kwadja nyininy bokadja. Baalap yoowal-koorl koorambayen Galilee-yal wer Judea wer Jerusalem. Boolanga-Yirakang mardayin nyiny Jesus-bwora kidji baal barra-barra minditj moorta. ");
INSERT INTO nys_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Keny-keny mammarapa yoowal-koorl. Baal kanga minditj mammarap maya-ngwoorndinyal. Baal yoowart kayar-yana. Baalap koordook kango baalany maya-maya-bwora kidji yidja baalany Jesus-booram. ");
INSERT INTO nys_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yalga narla boola moorta, baalap yoowart kayar-djinang war kango baalany maya-maya-bwora. Ngarl baalap yira-kanga baalany boornookak. Baalap warn banan boornookal kidji baalang ngaraka maya-ngwoorndiny didara-bwora moortang Jesus-booram. ");
INSERT INTO nys_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nginda Jesus djinang baalapang moorditj koort-karni, baal waangki mammarap, “Nganyang babin, noonang wara-doniny nyinya-nyinya-yan.” ");
INSERT INTO nys_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mammarapa-Warrinyang wer Pharisee-ya, baalap kwadjin danjo-waangkiny, “Ngiyan nidja mammarap? Baal yidjan Boolanga-Yira! Boolanga-Yira arda kayar-nyinya-nyinya wara-doniny!” ");
INSERT INTO nys_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus kaaditj moodlooka baalap kaaditjiny kidji baal waangki-djinang baalapany, “Nadjil noonooka nidja-nidja noolonga kaaditjiny? ");
INSERT INTO nys_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Natj kwabba warrinya ngany kayar-waangki? ‘Noonang wara-doniny nyinya-nyinak-yan?’ ka ‘Yiraba kidji yana?’ ");
INSERT INTO nys_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ngarl ngany boorda-marlanga noonookany, nidja Boodjeral, Mammarapang Nop kadak mardayin wara doniny nyinya-nyinyiny.” Ngarl Jesus waangki minditj mammarapany, “Ngany warranga noonany, yiraba, djabban noonang maya-ngwoorndiny, kidji koorl noonang karlap!” ");
INSERT INTO nys_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yeyi mammarap yiraba moortaman booram, baal djabban baalang maya-ngwoorndiny kidji koorl baalang karlap, Boolanga-Yirany yanganiny. ");
INSERT INTO nys_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Moortaman dandjo-dandjo kai-kai kidji wayarn-djil. Baalap yanganan Boolanga-Yira, waangkiny, “Natj kardiny noolonga ngala djinang nidja kedela!” ");
INSERT INTO nys_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ngolanga nidja, Jesus bandak-koorl kidji baal djinang mammarap boya-barranginy. Baalang kol Levi. Jesus waangki baalany, “Kambarn nganyany!” ");
INSERT INTO nys_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi yiraba, wandja moodlooka, kidji baal kambarn Jesus. ");
INSERT INTO nys_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Karro Levi kakatar boola mereny wer djora baalang karlapal ngarl moorta kayar-ngarn Jesus-al. Boola moorta boya-barranginy wer warma moorta, baalap Levi-yang babina. ");
INSERT INTO nys_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Levi kardjir ngakaka Pharisee-ya wer Mammarapa-Warrinyang ngarl baalap kardjir yoowal-koorlak. Baalap kaarang-biny Jesus-ang ngooldjara-kambarnang, waangki-djinanginy, “Nadjil noonooka ngarniny wer djoriny moorta-yel boya-barranginy kidji warma wara moorta?” ");
INSERT INTO nys_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus waangki baalapany, “Koortamayara-kwabba moorta, baalap yoowart ngarnala malgar, yalga arda minditj moorta. ");
INSERT INTO nys_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngany yoowart yoowal-koorl miro kwabba moorta narla baalap kayar wort-korang wara-doniny, arda wara moorta.” ");
INSERT INTO nys_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Moorta waangki Jesus, “Boola kedelara, John-ang ngooldjara-kambarn yoowart ngarn ka djora, yalga waangki Boolanga-Yira, kidji kardjir Pharisee-yang ngooldjara-kambarn. Arda noonang ngooldjara-kambarna ngarn mandang kedelaka.” ");
INSERT INTO nys_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus waangki, “Natj noonooka kaaditj? Kedela koorta-barrangang, koort-maatang babina nyiny baalal. Baal kayar nganitj ngarniny, wa? Yoowart! ");
INSERT INTO nys_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yalga kedela boorda yoowal-koorl nginda moorta boorda wort-barrang koort-maat, kidji karro baalap yoowart boorda ngarn mereny.” ");
INSERT INTO nys_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus kardjir warranga baalapany nidja bardip, “Yoowart moort mingal karda milgar bwokang, kwabba warniny windang bwoka. Bayinya baalap don nidja, baalap boorda warn-wara milgar bwoka kidji karda milgar bwokang yoowart boorda windang bwoka-mokiny. ");
INSERT INTO nys_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yoowart! Kidji moorta yoowart yidja milgar kepa-mardayin windang bwokooda bwora, narla milgar kepa-mardayin boorda torotawa bwokooda. Karro kepa boorda-darang kidji bwokooda boorda-takan. ");
INSERT INTO nys_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yoowart! Noonooka djarnyak yidja milgar kepa-mardayin milgar bwokooda bwora! ");
INSERT INTO nys_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kidji moorta yoowart koordook milgar kepa-mardayin, ngolanga baalap djora windang kepa-mardayin. Baalap waangki, ‘Windang kepa kwabba-ngatti!’” ");
INSERT INTO nys_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kedela-Kooranyi yoowal-koorl. Jesus yana boodjeral kwolakang. Baalang ngooldjara-kambarn kwadjin kaata kwolakakang djabbaniny. Baalap yarrang-yarrang kaata baalapang maararal, kidji ngarn kwolaka. ");
INSERT INTO nys_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pharisee-ya waangki-djinang, “Nadjil noonooka noolong doniny ngalang Warriny waangki noonooka yoowart djarnyak don Kedela-Kooranyikal?” ");
INSERT INTO nys_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus waangki baalapany, “Noonooka kwadja djinang-waangki noolongang David don nginda baal wer baalang mammarapa kwadja koboorl-wirt, wa? ");
INSERT INTO nys_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","“Baal koorl Boolanga-Yirang Mya-mya-bwora. Baalap kwadja yanga alidja mereny Boolanga-Yirak, yalga David barrang mereny kidji baal ngarn. Kidji baal kardjir yanga mereny baalang mammarapak. Yalga ngalang Warriny waangki: yoowart moort kayar ngarn alidja mereny, yalga arda yakina-kooranyi, baalap kayar-ngarn alidja mereny.” ");
INSERT INTO nys_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kidji karro Jesus waangki, “Mammarapang Nop, baal nyiny Birdiyar Kedela-Kooranyikang.” ");
INSERT INTO nys_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Warma Kedela-Kooranyi, Jesus koorl Maya-maya-Kalyara-bwora kidji baal karni-waangki moortany. Keny mammarap alidja nyinyiny, baal yoowart kayar kalbang baalang maar-ngwoornmoorn. ");
INSERT INTO nys_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mammarapa Warrinyang wer Pharisee-ya, baalap koordook djirina Jesus wara-doninyang ngarl baalap koorl-djinang war. Ngarl baalap yaaka baalany miyalitjiny, djinango bayinya Jesus boorda-barra-barra nidja mammarap Kedela-Kooranyikal. ");
INSERT INTO nys_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yalga Jesus kaaditj baalapang kaaditjiny kidji baal waangki mammarapany, “Yiraba kidji yoowal-koorl ngany-booram.” Mammarap yiraba. ");
INSERT INTO nys_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Karro Jesus waangki baalapany, “Ngany waangki-djinang noonookany ngalang Warrinyang. Natj ngala kayar-don Kedela-Kooranyikal? Maar-yanga moorta ka bakkan moorta? Barrang-ngandabat morta ka dargang moortaka? Natj kwabba noolong ngala kayar don?” ");
INSERT INTO nys_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesus miyalitj mandang baalapany, karro baal waangki mammarap, “Yanga noonang maar nganyak.” Baal don nidja, kidji noonang maar barra-barra-yan. ");
INSERT INTO nys_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Baalap kaarang-kaarang-biny kidji kwadjin dandjo-dandjo waangki natj baalap kayar-don Jesus-ak. ");
INSERT INTO nys_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Alidja kedela, Jesus koorl kard-yira, Boolanga-Yirakany waangkiny. Baal naan-yaaka kadikang ");
INSERT INTO nys_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ngangk yira-koorl kidji Jesus waangki-yoowal-koorl baalang ngooldjara-kambarn. Baal barrang maar-djen-koodjal baalapang kidji kolitj baalapany ‘Moorta Ngany Waangki-Koorl’: ");
INSERT INTO nys_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (Jesus kolitj baalany ‘Peter’) wer baalang ngooni Andrew, James wer John, Philip wer Bartholomew; ");
INSERT INTO nys_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew wer Thomas, James (Alphaeus-ang nop), wer Simon, kol-yan ‘Mammarap Karni Judea-kang’; ");
INSERT INTO nys_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas (James-ang nop), wer Judas Iscariot – baal kobat-kobatan-biny. ");
INSERT INTO nys_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ngolonga Jesus wer baalang ngooldjara-kambarn ngarda-koorl kardon, Jesus yaaka niyandapal. Boola baalang ngooldjara-kambarn yaaka baalyel. Boola moorta yoowal-koorl koorambayen, Judea-yen wer Jerusalem-yen wer karlamayaka warlbaral Tyre-ang wer Sidon. ");
INSERT INTO nys_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Baalap yoowal-koorl alo Jesus kidji ngarl Jesus kayar-barra-barra baalapany. ");
INSERT INTO nys_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Moortaman koordook Jesus. Baalap baka baalany narla mardayin koorliny baalyen. Jesus barra-barra moortaman. ");
INSERT INTO nys_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus miyalitj baalang ngooldjara-kambarn kidji baal waangki: “Boolanga-Yira kwabba boorda-don noonookak moorta winyan yeyi; Noonooka kadak Boodjer Boolanga Yira Djelyibiny ");
INSERT INTO nys_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Boolanga-Yira kwabba boorda-don noonookak moorta koboorl-wirt yeyi. Noonookang koboorla boorda-moorart! Boolanga-Yira kwabba boorda-don noonookak moorta wal-waliny yeyi. Noonooka boorda kawa! ");
INSERT INTO nys_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Boolanga-Yira kwabba boorda don noonookak nginda moorta koort-djal noonookany, nginda moorta wort-korang noonookany, nginda baalap wara-waangki noonookany, kidji baalap kalyam noonookang, arda narla Mammarapang Nopang! ");
INSERT INTO nys_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Noonooka boorda djoorab-djoorab-biny nginda nidja edjena, kidji koort-kwabba kobori, narla Boolanga-Yira boorda yanga noonookany boola moorditj ngoolonga, noolonga Boolanga-Yirang Boodjerang. Nidja-nidja moorta, baalapang maam-inrama don noolonga-djin Boolanga-Yirang Warda-Marridjinyak. ");
INSERT INTO nys_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Yalga wara-wara-djil noonookang moorta boola boya-kadak yeyi! Noonooka kwadja-wining noonookang djoorab ngandabat! ");
INSERT INTO nys_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Wara-wara-djil noonookang moorta boola mereny-kadak yeyi. Noonook boorda koboorl-wirt! Wara-wara-djil noonookang moorta kawiny yeyi! Noonook boorda-koort-wara kidji walwaliny! ");
INSERT INTO nys_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Wara-wara-djil nginda moortaman kwabba-waangki noonookang! Baalapang maam-inrama waangki noolonga-djin nginda baalapil waangki kalyaminy Warda-Marridjinyany.” ");
INSERT INTO nys_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Yalga noonooka ni! Ngany warranga noonookany: bayinya moorta koordook bakkano noonany, noonook djarnyak woonya baalapany; bayinya moorta koort-djal noonany, noonook djarnyak kwabba-don baalapany; ");
INSERT INTO nys_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","bayinya moorta wara-waangki noonany, noonook djarnyak nyinya-nyinya baalapany, kidji bayinya moorta wara-don noonany, noonook djarnyak waangki Boolanga-Yirakany baalapang. ");
INSERT INTO nys_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bayinya moorta bama noonany keny kalyatal, noonook djarnyak waangki baalapany, baalap kardjir kayar-bama noonang warma kalyatal. Bayinya moorta ngakilya noonang bwoka, noonook djarnyak waangki baalapany, baalap kardjir kayar-barrang noonang warma bwoka. ");
INSERT INTO nys_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bayinya moortaman ngakaka noonany noolongang, yanga baalapany. Kidji bayinya moorta barrang noonang noolonga, yoowart ngakaka baalapany keny noolong korl-yanginy. ");
INSERT INTO nys_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Noonook djarnyak don warma moortakang, noolonga noonook koordook baalapany dono noonang. ");
INSERT INTO nys_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Bayinya noonook woonya moortany, arda bayinya baalap woonya noonany, nadjil noonook boorda yanganan-yan? Wara moorta woonya moortany bayinya baalap woonya baalapany! ");
INSERT INTO nys_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kidji bayinya noonooka arda kwabba-don moortak bayinya baalap kwabba don noonany, nadjil noonook boorda yanganan-yan? Wara moorta alidja don! ");
INSERT INTO nys_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kidji bayinya noonook arda yanga noolonga moortak bayinya noonook kaaditj baalap boorda-korl-yanga noonak, nadjil noonook boorda-yanganan-yan? Wara moorta yanga noolonga moortak kidji korl-barrang noolonga-djin! ");
INSERT INTO nys_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yoowart! Woonya moorta ngiyan koort-djal noonany kidji kwabba-don balaapak. Yanga noolonga moortakak kidji yoowart koordook moortakany noolonga korl-yanginy. Karro noonooka boorda yanga-yan boola noolonga kidji noonooka boorda Boolanga-Yirakang koorlangka-biny. Narla Boolanga-Yira kardjir kwabba don moortakak ngiyan yoowart yanganan baalany kidji kardjir wara-wara moortakak. ");
INSERT INTO nys_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Noonooka djarnyak ngorna-kwabba moortakany, noonang Maaman-mokiny, baal ngorna-kwabba mortakany.” ");
INSERT INTO nys_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Yoowart djirin warma moortany kidji Boolanga-Yira yoowart boorda djirin noonookany. Yoowart djin-bama warma moortany kidji Boolanga-Yira yoowart boorda djin-bama noonookany. Yinya-yinya warma moortany kidji Boolanga-Yira boorda yinya-yinya noonookany. ");
INSERT INTO nys_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yanga warma moortak kidji Boolanga-Yira boorda yanga noonookak. Bandodjil, noonooka boorda yanga-yan wobatiny kooda, kidji Boolanga-Yira boorda-yanga boola noolonga noonookang maara-bwora, mandang noonooka kayar-maar-barrang. War noonooka yanga warma moortak, alitja war-djin, Boolanga-Yira boorda-yanga noonookak.” ");
INSERT INTO nys_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesus waangki baalapany nidja bardip, “Keny miyala-birt mammarap, baal yoowart kayar booram-koorl warma moort. Bayinya baal don nidja, koodjal moorta boorda-djabalar karrab-bwora. ");
INSERT INTO nys_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Moort ngiyan ala baalang birdiyarang kwabba karni-waangkiny, baal yoowart yilak moorditj-ngatta-biny nadjang baalang birdiyar. Yalga moortaman ngiyan ala baalapang birdiyar, kidji kambarn baalany, nginda baalap nganitj, karro baalap boorda birdiyar-djin-abiny. ");
INSERT INTO nys_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nadjil noonook djinang dalba noonang ngooniyang miyal-bwora, yalga noonook yoowart djinang boorn noonroo miyal-bwora? ");
INSERT INTO nys_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Yarn noonook kayar-waangki noonang ngooniyany, ‘Nganyang ngoony, ngany djabban-oola dalba noonang miyalyen,’ yalga noonook yoowart yoowal djinang boorn noonang miyal-bwora? Noonook koolyoomitj! Wort-barrang boorn noonang miyalyen. Karro noonook boorda kwabba djinang kidji kayar djabban dalba noonang ngooniyang miyalyen.” ");
INSERT INTO nys_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kwabba boorn yoowart yidja wara djildji kidji wara boorn yoowart yidja kwabba djildji. ");
INSERT INTO nys_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Moorta kaaditj mandang boorna narla djildji baalap yidja. Noonooka yoowart barrang kwonding mornitjayen. Noonooka yoowart barrang kamak marlakayen. ");
INSERT INTO nys_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kwabba mammarap kadak kwabba noolonga baalang koortal ngarl baal bandak-barrang kwabba nooloonga. Wara mammarap kadak wara noolanga baalang koortal ngarl baal bandak-barrang wara nooloonga. Djaa waangki noolonga natj bandak-koorl koortany.” ");
INSERT INTO nys_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nadjil noonooka kolitj nganyany, ‘Birdiyar, Birdiyar,’ yalga noonooka yoowart don natj ngany warranga noonookany? ");
INSERT INTO nys_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Bayinya moort yoowal-koorl nganyany kidji baal dwangka nganyang warrinya kidji baal don natj ngany waangki, ngany boorda-warranga noonookany natj baal-mokiny. ");
INSERT INTO nys_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Baal mammarap-mokiny baalang maya-maya warniny; baal biyan karrab mordak kidji baal ngarda-yidja baalang maya-maya boyal. Bilya wobata kidja bama baalang maya-maya yalga kepa yoowart kayar-yoorang-yoorang maya-maya, narla baal kwabba warn maya-maya. ");
INSERT INTO nys_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yalga moort ngiyan dwangka nganyang warrinya yalga yoowart don natj ngany waangki, baal mammarap-mokiny ngiyan warn baalang maya-maya, yalga baal yoowart ngarda-yidja baalang maya-maya boyal. Bilya wobata kidji bama baalang maya-maya kidji maya-maya yilak-yilak djabalar. Maya-maya wara-djil djabalar!” ");
INSERT INTO nys_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ngolanga Jesus nganitj noolonga nidja-nidja waangkiny moortakak, baal koorl Capernaum. ");
INSERT INTO nys_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Birdiyar mammarapang bakadjiny Rome-ang, baal wining alidja kalamayal. Birdiyar woonya baalang yakin yalga yakin minditj-wara kidji noyitj-ngat. ");
INSERT INTO nys_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nginda birdiyar dwangka Jesus-ang, baal waangki-koorl warda-kadak mammarapa Judea-kang Jesus-ak, baalany ngakakiny bayinya baal kayar koorl kidji barra-barra baalang yakin. ");
INSERT INTO nys_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Baalap yoowal-koorl Jesus-any kidji baalap koort-koort baalany, “Nidja kwabba-djil mammarap kidji noonook doora maar-yanga baalany. ");
INSERT INTO nys_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Baal woonya ngalang moorta kidji baal warn ngalang Maya-maya-Kalyara.” ");
INSERT INTO nys_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ngarl Jesus koorl baalapyel. Nginda baal boordak-koorl maya-maya, birdiyar waangki-koorl baalang babina. Baal warranga Jesus, “Birdiyar, noonook yoowart doora koorl. Ngany yoowart kwabba-kinyak. Noonook yoowart doora bwora-koorl nganyang maya-maya, ");
INSERT INTO nys_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","kidji ngany kaaditj, ngany yoowart kwabba-kinyak koorlo noonook. Arda waangki, kidji nganyang mammarap boorda-barra-barra-yan. ");
INSERT INTO nys_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngany kardjir mammarap birdiyar-boorong. Baal yira-yaaka nganyang yalga boola mammarapa-bakadjiny ngarda-nyiny nganyany. Ngany warranga nidja mammarap, ‘Wort-koorl!’ kidji baal koorl. Ngany warranga alidja mammarap, ‘Yoowal-koorl!’ kidji baal yoowal-koorl. Kidji ngany warranga nganyang yakin, ‘Don nidja!’ Kidji baal don.” ");
INSERT INTO nys_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus dwangka nidja kidji baal kai-kai. Boola moorta kambarn Jesus. Baal korang kidji waangki, “Ngany warranga noonook, ngany yoowart djinang koort-karni nidja mammarap-djin, yoowart Israel-al, yoowart!” ");
INSERT INTO nys_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Moorta yana-waangki korl-koorl birdiyarang maya-maya kidji baalap djinang baalang yakin barra-barra-yan. ");
INSERT INTO nys_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kayida ngolanga, Jesus koorl karlamaya, Nain. Baalang ngooldjara wer boola warma moorta kambarn baalany. ");
INSERT INTO nys_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yeyi baal koorl bida karlamayang. Moorta boola bandak-koorliny. Baal wal-waliny kidji noyitj mammarap kanginy, arda nop yokang. Baal yenang. Boola moorta karlamayang yana baalyel. ");
INSERT INTO nys_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesus djinang yok. Baal koort-wara-djil kidji waangki baalany, “Yoowart wal-wal.” ");
INSERT INTO nys_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Karro Jesus boordak-yana kidji baal baka noyitj mammarapang maya-ngwoorndiny. Mammarapa baalany kanginy, baalap nganitj. Jesus waangki, “Koolambidi! Yiraba, ngany warranga noonany!” ");
INSERT INTO nys_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Noyitj mammarap yira-nyiny kidji malyak waangkiny, kidji Jesus korl-yanga nop baalang ngaangkak. ");
INSERT INTO nys_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Baalap mandang wayarn-djil kidji yanganan Boolanga-Yira. Baalap waangki, “Keny moorditj Warda-Marridjiny kardakor-koorl ngalany! Boolanga-Yira kwadja-yoowal-koorl barrangak-ngandabat ngalany!” ");
INSERT INTO nys_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nidja warda Jesus-ang kooramba-koorl alidja boodjeral wer boola boordak boodjera. ");
INSERT INTO nys_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nginda John-ang ngooldjara-kambarn warranga baalany nidja-nidja noolonga, baal mira koodjal baalapang ");
INSERT INTO nys_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","kidji waangki-koorl koodjal Birdiyarak, waangki-djinanginy, “Noonook alidja Keny Mammarap, Keny yoowal-koorliny. Ka ngala djarnyak nganayaka warma mammarap?” ");
INSERT INTO nys_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Koodjal Jesus koorl, kidji koodjal waangki, “John-Kakaloorniny waangki-koorl ngalany, waangki-djinanginy bayinya noonook alidja Keny Mammarap. John waangki alidja baal yoowal-koorliny. Ka ngala djarnyak nganayaka warma mammarap?” ");
INSERT INTO nys_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nidja kedela, Jesus kwadja-barra-barra boola moorta baalapang minditji, morba-wara wer djenaka-wara, kidji yanga miyaliny boola miyal-birt moortakak. ");
INSERT INTO nys_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesus waangki John-ang ngooldjarany, “Korl-koorl John-ak kidji warranga baalany nidja-nidja noolonga noonooka kwadja-djinang wer dwangka. Miyal-birt moorta kayar djinang, maat-wara moorta kayar-yana, moorta morba-wara-boorong barnan-biny, dwangka-birt moorta kayar dwangka, noyitj moorta yiraba-yan ngandabatal, Warda-Kwabba warranga-yan winyan moortakak. ");
INSERT INTO nys_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Boolanga-Yira boorda yanga-kwabba moortany, bayinya baalap yoowart wandja nganyang karni.” ");
INSERT INTO nys_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ngolanga John-ang ngooldjara wort-koorl, Jesus kwadjin waangkiny baalang moortaman-ak, “Nginda noonooka bandak-koorl John-ak kwangkanal, natj noonooka koordook djinango? Djilbar ngaliny marral? ");
INSERT INTO nys_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Natj noonooka koorl djinango? Mammarap bwoka kwabbalitj wandanginy? Moorta boya boola-kadak, bwoka kwabbalitj wandanginy, noonooka arda djinang baalapany moorditj maya-maya-bwora! ");
INSERT INTO nys_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Noonooka warranga nganyany, natj noonooka bandak-koorl djinango? Warda-Marridjiny? Kaya, karnayal, yalga noonooka djinang noolong moorditj-ngatti, yoowart arda Warda-Marridjiny. ");
INSERT INTO nys_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Narla Boordakiny-Kooranyi waangki nidja mammarapang, John, ‘Boolanga-Yira waangki, “Ngany boorda-waangki-koorl nganyang moort yana-waangki noonook-kwadjat, noonang djooroot barnaniny.” ’ ” ");
INSERT INTO nys_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesus waangki, “Ngany warranga noonookany, John moorditj-ngatti mammarap nadjang moortaman, moorta kwadja-wining kwidjang wer moorta wining nidja kedela. Yalga nyitanga moort Boodjeral Boolanga-Yira Djelyibiny, baal moorditj-ngatti nadjang John.” ");
INSERT INTO nys_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Moortaman dwangka John; mammarapa boya-barranginy kadjir dwangka Boolanga-Yirakang karni, kidji baalap koorl John-any narla baal kayar kakaloorni baalapany. ");
INSERT INTO nys_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yalga Pharisee-ya wer Mammarapa-Warrinyang, baalap wort-korang. Baalap yoowart koordook Boolanga-Yirang noolonga, noolonga Boolanga-Yira koordook baalapany doniny kidji baalap yoowart koorl John-ak kakaloorninyang. ");
INSERT INTO nys_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesus karro-waangki, “Yeyi natj ngany kayar-waangki moortakang nidja kedela? Baalap natj moorta-mokiny? ");
INSERT INTO nys_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Baalap koorlangka-mokiny mandjaral nyinyiny. Keny boongal mira warmak, ‘Ngala yedi-waangki koort-maatang, yalga noonooka yoowart kobori! Ngala yedi-waangki wanikang, yalga noonooka yoowart wal-wal!’ ");
INSERT INTO nys_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","John-Kakaloorniny koorl. Baal yoowart ngarn boola kedelara kidji baal yoowart djora kepa-moorditj, kidji noonooka waangki, ‘Djenak-wara baal-bwora!’ ");
INSERT INTO nys_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mammarapang Nop koorl, baal ngarn wer djora, kidji noonooka waangki, ‘Djinang nidja mammarap! Baal ngabatj koboorl kidji baal djora kepa-mardayin. Baal babin-biny mammarapang boya-barranginy kidji warma wara-wara moorta’ ");
INSERT INTO nys_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yalga noonooka kayar djinang Boolanga-Yirakang karni moortamanal ngiyan dwangka karni kidji maar-barrang karni.” ");
INSERT INTO nys_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Keny Pharisee ngakaka Jesus-any ngarnak wer djorak baalyel, kidji Jesus koorl baalang maya-maya kidji nyiny ngarno wer djorno. ");
INSERT INTO nys_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Alidja karlamayakal, keny karra-wara yok wining. Baal dwangka Jesus-ang ngarniny wer djoriny Pharisee-ang maya-maya-bwora. Ngarl baal barrang kooda-boya, moorart boyin-bandinang ");
INSERT INTO nys_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","kidji baal yaaka Jesus-ngoolya, wal-waliny kidji Jesus-ang djena yalyetiny baalang mingalal. Karro baal yindjaran Jesus-ang djena baalang djoombakal, nindyan Jesus-ang djena kidji baal nabba baalang djena boyin-bandinal. ");
INSERT INTO nys_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pharisee djinang nidja noolong, kidji baal waangki baalaal, “Bayinya nidja mammarap karnayal nyiny Warda-Marridjiny, baal boorda kaaditj nidja yokany wer baalang karra-wara!” ");
INSERT INTO nys_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus waangki baalany, “Simon, ngany boorda warranga noonany keny noolong.” “Kaya, Birdiyar,” baal waangki, “Warranga nganyany.” ");
INSERT INTO nys_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus malyak waangkiny, “Koodjal mammarapa djarnyak wort-yanga boya birdiyarak ngiyan narla baal yanga boya baalapak kwadjat. Keny mammarap djarnyak wort-yanga 500 boyara, kidji warma mammarap 50 boyara. ");
INSERT INTO nys_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Koodjal mammarapa yoowart kayar wort-yanga boya ngarl birdiyar nyina-nyina koodjal mammarapany mandang boya. Karro natj mammarap boorda woonya birdiyar moorditj-ngatti?” ");
INSERT INTO nys_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon waangki, “Ngany waangki, mammarap ngiyan wort-yanga 500 boyara. Birdiyar nyinya-nyinya baalany boolanga boya.” ");
INSERT INTO nys_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Karro Jesus korang yokak kidji waangki Simon, “Noonook djinang nidja yok? Ngany bwora-koorl baalang maya-maya, kidji noonook yoowart yanga nganyany kepa nganyang djena, yalga baal kwadja-kakaloorni nganyang djena baalang mingalal, kidji yindjaran nganyang djena baalang djoombakal. ");
INSERT INTO nys_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Noonook yoowart kalyara nganyany nindyanal, yalga baal yoowart nganitj nganyang djena nindyaniny ngolonga ngany yoowal-koorl. ");
INSERT INTO nys_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Noonook yoowart yanga nganyany boyin koorayin nganyang kaat, yalga baal nabba nganyang djena boyin-bandinal ");
INSERT INTO nys_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Karro ngany warranga noonany, narla baal yanga boola woonya, ngala kayar-djinang marlanga. Baalang boola wara-doniny nyinya-nyinya-yan. Yalga moort ngiyan nyinya-nyinya-yan nyit noolonga, baal nyit woonya.” ");
INSERT INTO nys_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Karro Jesus waangki yokany, “Noonang wara-doniny nyinya-nyinya-yan.” ");
INSERT INTO nys_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Warma moorta nyinyiny ngarniny wer djoriny, baalap malyak dandjo-waangkiny, “Ngiyan nidja baal? Baal kayar-nyinya-nyinya wara-doniny, wa?” ");
INSERT INTO nys_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yalga Jesus waangki yokany, “Noonang koort-karni barrang-ngandabat noonany. Koorl nakalal.” ");
INSERT INTO nys_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ngolonga, Jesus koorl mandang bangka boodjerang, Warda-Kwabba warranginy, warda Boodjerang Boolanga-Yirang Djelyibiny. Maar-djen-koodjal ngooldjara-kambarn koorl baalyel, ");
INSERT INTO nys_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kidji kardjir yoka ngiyan Jesus kwadja-barra-barra baalapang djenaka-wara wer menditj. Mary (kol Magdalene) – Jesus kwadja-yekan maar-koodjal djenaka-wara baal-bandak; ");
INSERT INTO nys_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","wer Joanna, Chuza-kang koort-maat, birdiyar Herod-ang maya-maya; wer Susanna, wer boola warma yoka. Baalap yanga baalapang boya Jesus-ak wer baalang ngooldjara, baalapany maar-yanginy. ");
INSERT INTO nys_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Boola Moorta koorl Jesus-ak mandang karlamayayen. Nginda baalap dandjo-dandjo koorl, Jesus warranga baalapany nidja bardip: ");
INSERT INTO nys_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Keny kedela, mammarap bandak-koorl, kwolaka niraniny. Baal niran kwolaka boodjer-bwora, yalga keny-keny kwolaka djabalar djoorootal. Moorta kana kwolaka kidji djerta ngarn baalapany. ");
INSERT INTO nys_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Keny-keny kwolaka djabalar boya-boodjeral. Kwolaka malatj, yalga dilbika yindjaran-biny narla yoowart kepa boodjeral. ");
INSERT INTO nys_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Keny-keny kwolaka djabalar mornitja-kardakor. Mornitja wer kwolaka dandjo-malatj kidji mornitja dargang kwabba kwolakany. ");
INSERT INTO nys_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yalga keny-keny kwolaka djabalar kwabba boodjeral; kwolaka malatj kidji yanga boola-ngatti kwolaka, boola-boola kwolaka.” Kidji Jesus nganitj baalang bardip, waangkiny, “Karro ni, bayinya noonooka dwangka-kadak!” ");
INSERT INTO nys_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesus-ang ngooldjara waangki-djinang baalany, “Natj karni bardipang?” ");
INSERT INTO nys_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesus waangki, “Ngany kwadja yanga noonookany kaaditjiny kobinakang Boodjerang Boolanga-Yira Djelyibiny, yalga warma moorta dwangka karni bardial, ngarl baalap miyalitj-pa, yalga yoowart djinang, kidji baalap dwangka-pa, yalga yoowart kaaditj.” ");
INSERT INTO nys_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nidja karni bardip-bwora. Kwolaka Boolanga-Yirakang Warriny-mokiny. ");
INSERT INTO nys_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kwolaka djoorootal djabalariny moorta-mokiny: baal dwangka Warriny yalga ngolanga, Djenak koorl kidji baal wort-barrang karni baalapang koort-yen. Djenak nganitj baalapany djinang-karniny kidji baal nganitj baalapany barrang-ngandabat-yan. ");
INSERT INTO nys_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kwolaka boya-boodjeral djabalariny moorta-mokiny: baalap dwangka karni, kidji djoorab maar-barrang karni. Yalga karni yoowart mordak-koorl baalap-bwora; baalap maar-barrang karni arda djikang yalga nginda kedela djoniny-karrinyang koorl, baalap wort-djabalar. ");
INSERT INTO nys_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kwolaka mornitja kardakor djabalariny moorta-mokiny: baalap dwangka, yalga ngwidam noolonga yoowal-koorl ka boola boya ka noolonga baalap koort-djinang. Nidja-nidja noolonga wort-koorna kwolaka ngarl djildji yoowart boorda-malatj. ");
INSERT INTO nys_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kwolaka kwabba boodjeral djabalariny moorta-mokiny: baalap dwangka Warriny kidji maar-barrang karni baalang koorta-bwora, kwabba wer doorgool koorta, kidji baalap mardayin-biny kidji yidja djildji.” ");
INSERT INTO nys_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Yoowart moort dookoon karla-maat kidji ballaridja binari. Baal yoowart yidja karla-maat kooda-ngarda ka maya-ngwoorndiny-ngarda. Yoowart, baal yira-yidja karla-maat ngarl moorta kayar-djinang binari karlang bayinya baalap koorl maya-mayak. ");
INSERT INTO nys_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Moodlooka moorta ballaridja boorda barrang-djinang-yan kidji noolonga moorta dengkoor boorda barrang-yan binari-bwora. ");
INSERT INTO nys_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Karro noonooka yoowart djarnyak wallar noolongakang noonooka dwangka; narla moorta noolong-kadak, baalap boorda-yanga-yan noolonga-ngatti, yalga moorta yoowart noolong-kadak, baalapang nyit noolonga baalap kaaditj baalap kadak, moodlooka boorda-wort-barrang-yan.” ");
INSERT INTO nys_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus-ang ngaangk wer baalang ngooniya koorl baalak, yalga baalap yoowart kayar-kalyara narla boola-boola moorta. ");
INSERT INTO nys_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Warma moort warranga Jesus-any, “Noonang ngaangk wer ngooniya bandak-yaakiny. Baalap koordook djiningo noonany.” ");
INSERT INTO nys_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesus warranga baalapany, “Nganyang ngaangk wer ngooniya, baalap moorta ngiyan dwangka Boolanga-Yirakang Warriny kidji don baal.” ");
INSERT INTO nys_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Keny kedela, Jesus wer baalang ngooldjara bwora-koorl wandaberi. Jesus waangki baalapany, “Ngala yambo-koorl-oola warma boongal malakang.” Ngarl baalap malyak koorliny ");
INSERT INTO nys_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Alimarn baalap koorl, Jesus ngwoornda kidji bidjar. Yeyi yirakal, balarany nooyang mala-yambo. Kepa kwadjin wandaberi moorartiny kidji mandang baalapang boordak mordakaniny. ");
INSERT INTO nys_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ngooldjara koorl Jesus-any kidji yikkan baalany. “Birdiyar! Birdiyar! Ngala boorda wanni!” Jesus djerramin kidji waangki balarany wer ngayanga. Baalap nganitj kidji moodlooka nakal-biny. ");
INSERT INTO nys_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Karro Jesus waangki ngooldjarakany, “Windji noonookang koort-karni?” Yalga baalap kai-kai wer wayarn, kidji dandjo-waangki, “Ngiyan nidja mammarap? Baal waangki balarany wer ngayanga kidji baalap don natj baal waangki!” ");
INSERT INTO nys_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesus wer baalang ngooldjara koorl wandaberikal boodjerak Gerasa-kang, yambo Mala Galilee. ");
INSERT INTO nys_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Alimarn Jesus kana walbaral, mammarap karlamayayen kalayara baalany. Boola djenaka-wara wining baal-bwora. Boola biroka, nidja mammarap koorl bwoka-birt kidji yoowart naan-yaaka maya-mayal, yalga baal naan-yaaka karraba-bwora noyitjang. ");
INSERT INTO nys_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nginda baal djinang Jesus-any, baal waangki-djan, ngarda-kwarda baalaal Jesus-ang djenakal, kidji waangki-djan, “Jesus, Boolanga-Yirakang Nop! Natj noonook koordook nganyang? Ngany koort-koort noonany, yoowart djin-bama nganyany!” ");
INSERT INTO nys_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Baal waangki nidja narla Jesus kwadja-warranga djenaka-wara, ‘Bandak-koorl baalany!’ Djenaka-wara kalyakool yardjang baalany. Moorta wangarn baalany kidja yadarn baalang djena wer maara madjikal, yalga baal kayar-djakan madji kidji djenaka-wara bandak-yekan baalany kwangkanak. ");
INSERT INTO nys_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus waangki-djinang baal, “Natj noonang kol?” “Nganyang kol ‘Boola’,” baal waangki, “Narla boola djenaka-wara wining ngany-bwora.” ");
INSERT INTO nys_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mandang djenaka-wara koort-koort Jesus-any yoowart waangki-koorl baalapany mayart karrab-bwora. ");
INSERT INTO nys_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Boordak alidjap, boola dwordoka ngarniny kardal. Ngarl djenaka-wara koort-koort Jesus, ‘Waangki-koorl ngalany dwordoka-bwora!’ Kidji Jesus waangki-koorl baalapany. ");
INSERT INTO nys_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Baalap bandak-koorl mammarapany kidji baalap koorl dwordoka-bwora. Mandang dwordoka djakoorl dandjo-dandjo kowa-ngarda mala-bwora kidji baalap mordakan. ");
INSERT INTO nys_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Moorta dwordoka-yel kwadja-yakiny, baalap djinang natj edjena, ngarl baalap wort-koorl maya-mayakak wer karlamayakak boodjeral kidji baalap warranga warda. ");
INSERT INTO nys_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Moorta bandak-koorl djinanginy natj kwadja edjeniny. Baalap yoowal-koorl Jesus-any kidji baalap djinang mammarapany. Mandang djenaka-wara kwadja-wort-koorl. Baal nyiny Jesus-ang djena-boordak, baalang bwoka wandanginy kidji doorkool baalang kaat-bwora. Ngarl mandang baalapang wayarn. ");
INSERT INTO nys_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Moorta ngiyan djinang natj edjena, baalap warranga mandang warma moortany yarn Jesus kwadja-barra-barra mammarapany. ");
INSERT INTO nys_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Karro moortaman alidjap ngakaka Jesus wort-koorlo narla baalap wayarn-djin. Ngarl Jesus koorl wandaberi-bwora kidji wort-koorl. ");
INSERT INTO nys_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mammarap ngiyan kwadja-barra-barra-yan boola djenaka-warang, baal koort-koort Jesus-any, “Ngany koordook koorlo noonook-yel.” Yalga Jesus waangki-wort-koorl baalany, waangkiny, ");
INSERT INTO nys_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Korl-koorl noonang maya-maya kidji warranga moorta natj Boolanga-Yira kwadja-don noonang.” Mammarap yambo-koorl karlamaya, waangkiny natj Jesus kwadja-don baalang. ");
INSERT INTO nys_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nginda Jesus korl-koorl warma boongal malakang, moorta djoorab-biny baalany djinanginy, narla moortaman kwadja-kwidiny baalany. ");
INSERT INTO nys_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Karro mammarap kol Jairus baal koorl; baal birdiyar Maya-maya Kalyarakang. Baal ngarda-djabalar Jesus-ang djenal kidji koort-koort Jesus-any yoowal-koorlo baalang maya-maya, ");
INSERT INTO nys_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","narla baalang keny kowart kwadja-wanniny. Baal maar-djen-koodjal biroka-kadak. Jesus yana djoorootal kidji boola moorta kambarn baalany. ");
INSERT INTO nys_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Keny yok yana baalapany kardakor. Baal minditj-wara kidji baal kwadja-ngobiny maar-djen-koodjal biroka. Baal kwadja-banitj mandang baalang boya malkang, yalga yoowart keny kayar-barra-barra baalany. ");
INSERT INTO nys_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Baal yana moorta kardakor Jesus-ngolanga kidji baal baka ngardanga baalang bwokang. Baalang ngobiny yilak-yilak nganitj. ");
INSERT INTO nys_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus waangki-djinang, “Ngiyan baka nganyany?” Mandang baalap waangki, “Yoowart ngany.” Yalga Peter waangki, “Birdiyar, moortaman noonany kamo-kooliny kidji noonany bilanginy.” ");
INSERT INTO nys_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yalga Jesus waangki, “Keny moort baka nganyany, narla ngany kaaditj nginda mardayin bandak-koorl nganyang.” ");
INSERT INTO nys_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yok djinang natj Jesus kaaditj baal kwadja-baka baalany, ngarl baal yoowal-koorl koorgonginy kidji baal ngarda-djabalar Jesus-ang djenakal. Moortaman booram baal warranga Jesus nadjil baal kwadja-baka baalany kidji yarn baal kwadja-barra-barra-yan winidjinbar. ");
INSERT INTO nys_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesus waangki baalany, “Nganyang kowart, noonang koort-karni warn noonany koortamayara-kwabba. Koorl nakalal.” ");
INSERT INTO nys_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Alimarn Jesus waangkiny, moort yana-waangki yoowal-koorl birdiyarang maya-maya-yen. Baal waangki Jairus-any, “Noonang kowart wanni. Nganitj Birdiyar karradjaliny yeyi.” ");
INSERT INTO nys_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yalga Jesus dwangka baalany kidji waangki Jairus-any, “Yoowart mayirak, arda djinang-karni, kidji baal boorda-barra-barra-yan.” ");
INSERT INTO nys_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nginda Jesus koorl maya-maya, baal warranga moortaman yoowart koorlo maya-maya-bwora baalyel, arda Peter, John wer James, wer maaman wer ngaangk koorlangang. ");
INSERT INTO nys_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Moortaman kwadja-wal-waliny kidji mayirakiny koorlangang. Jesus waangki, “Yoowart wal-waliny! Koorlang yoowart noyitj, baal arda ngwoorndiny!” ");
INSERT INTO nys_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Moortaman yidjan Jesus-any, narla baalap kaaditj baal kwadja-noyitj. ");
INSERT INTO nys_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yalga Jesus barrang baalang maar kidji mira, “Yiraba, koorlang!” ");
INSERT INTO nys_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Baalang ngandabat korl-koorl, kidji baal yilak-yilak yaaka, kidji Jesus warranga baalapany yango baalany mereny wer djaatj ngarnak. ");
INSERT INTO nys_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Baalang maaman wer ngaangk kwadja-kardi, yalga Jesus waangki koodjalany, koodjal yoowart djarnyak warranga moortakany natj edjena. ");
INSERT INTO nys_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus dandjo-mira baalang maar-djen-koodjal ngooldjara-kambarna kidji yanga baalapany mardayin wer moorditj bandak-yekano mandang djenaka-wara kidji barra-barro minditj moorta. ");
INSERT INTO nys_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Karro Jesus waangki-koorl baalapany warrango moorta Boodjerang Boolanga-Yira Djelyibiny, kidji moorta minditj barra-barro. ");
INSERT INTO nys_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yalga koryat, Jesus waangki baalapany, “Yoowart kanga keny noolong noonookal djoorootal noonooka boorda-marridja: yoowart boorn-yaniny, yoowart kooda koort-koortiny, yoowart boya kidji yoowart warma bwoka. ");
INSERT INTO nys_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bayinya moorta ngakaka noonookany, naan-yaaka alidja maya-maya-bwora kedalak noonooka wort-koorl karlamaya. ");
INSERT INTO nys_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bayiny moorta yoowart koordook noonooka, wort-koorl alidja karlamaya kidji yoorang-yoorang dalba noonookang djena-yen, ngambing-mokiny baalapak.” ");
INSERT INTO nys_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesus-ang ngooldjara koorl mandang karlamayara, Warda-Kwabba warranginy kidji moorta minditj barra-barriny kooramba. ");
INSERT INTO nys_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nginda Herod nyiny Djelyib Galilee-kang, baal dwangka mandang noolonga natja kwadja-edjena. Baal yowir-djil-biny narla moorta kwadja-waangkiny, ‘John Kakaloorniny kwadja korl-koorl ngandabatak’. ");
INSERT INTO nys_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Warma moorta waangki baalap Elijah kwadja-djinang, kidji yalga warma moorta waangki Warda-Marridjiny koorakang kwadja-korl-koorl ngandabatak. ");
INSERT INTO nys_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod waangki, “Ngany kardjat John-ang kaat. Yalga ngiyan nidja mammarap ngany dwangka nidja-nidja noolongang?” Ngarl baal koordook Jesus-any djinango. ");
INSERT INTO nys_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesus-ang ngooldjara korl-koorl kidji baalap warranga Jesus-any moodlooka baalap kwadja-don. Jesus dandjo-barrang baalapany baalyel. Baalap wandja warma moortaman kidji baalap koorl karlamaya kol Bethsaida. ");
INSERT INTO nys_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Boola moorta dwangka alidja, ngarl baalap yoowal-koorl Jesus koorl-djinanginy. Baal baalapany yanganan, baalapany warranganiny Boodjerang Boolanga-Yira Djelyibiny, kidji minditj moorta barra-barriny. ");
INSERT INTO nys_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nginda ngangk ngardakiny, Jesus-ang maar-djen-koodjal ngooldjara, baalap yoowal-koorl kidji waangki, “Waangki-wort-koorl moortany ngarl baalap kayar-koorl karlamayara wer maya-mayara boodjeral kidji korl-djinang djaatja ka mereny kidji korl-djinang maya-mayara ngwoorndo narla nidja woodjang boodjer.” ");
INSERT INTO nys_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yalga Jesus waangki baalapany, “Noonooka, noonookaal yanga baalapany noolong ngarno.” Baalap waangki, “Ngala arda barrang maar-keny mooloora mereny-ang wer koodjal djildjita. Noonook koordook ngalany koorlo kidji bangal-barrang djaatj wer mereny yango nidja-nidja moortaman, wa?” ");
INSERT INTO nys_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","5,000 mammarapa alidja. Jesus waangki baalang ngooldjarany, “Warranga moortaman nyinyo, 50 moorta dandjo-nyinyiny.” ");
INSERT INTO nys_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ngolonga ngooldjara don nidja, ");
INSERT INTO nys_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesus maar-barrang maar-keny mooloora merenyang wer koodjal djildjita. Baal yira-djinang, yanganan Boolanga-Yira, djakan baalapany, kidji baal yanga ngooldjarany mereny ka djildjita ngarl baalap kayar yanga moodlooka moortakak. ");
INSERT INTO nys_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Moortaman ngarn kidji moorart-abiny, kidji ngooldjara djabban maar-djen-koodjal koodaka merenyang wer djildjitang natj moorta yoowart ngarn. ");
INSERT INTO nys_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Keny kedela, Jesus kwadja-doombart, Boolanga-Yirakany waangkiny, kidji baalang ngooldjara koorl baalak. Jesus waangki-djinang baalapany, “Ngatj moortaman waangkiny? Ngiyan ngany?” ");
INSERT INTO nys_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Baalap yalman-waangki, “Mo moorta waangki ‘John Kakaloorni’. Warma moorta waangki, ‘Elijah’ kidji yalga warma moorta waangki, ‘Keny Warda-Marradjiny koorakang kwadja korl-koorl ngandabakak’.” ");
INSERT INTO nys_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Yalga noonooka,” Jesus waangki. “Ngiyan noonooka waangki ngany nyiny?” Peter yalman-waangki, “Noonook Keny Boolanga-Yira Waangki-Koorl.” ");
INSERT INTO nys_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Karro Jesus waangki baalapany baalap yoowart djarnyak warranga warma moorta. ");
INSERT INTO nys_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesus kardjir warranga baalapany, “Mammarapang Nop djarnyak bakkan. Moorta warda-kadak wer birdiyara Maya-maya-Kooranyikang wer Mammarapa-Warrinyang, mandang baalapang boorda wort-korang baalany. Baalap boorda dargang baalany. Yalga ngolonga mo kedela, baal boorda-yiraba-yan ngandabatak.” ");
INSERT INTO nys_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kidji Jesus warranga baalapany mandang, “Bayinya keny moort koordook kambarno nganyany, baal djarnyak dwangka-anbangbat baalaal, baal djarnyak yira-bilang baalang boorn-yambo yennar kedela kidji kambarn nganyany. ");
INSERT INTO nys_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bayinya moort koordook barrango baalang ngandabat, baal boorda anbangbat baalang ngandabat, yalga moort ngiyan anbangbat baalang ngandabat narla nganyang, baal boorda barrang baalang ngandabat. ");
INSERT INTO nys_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bayinya moort barrang moodlooka Boodjeral yalga anbangbat baalang ngandabat, baal yoowart barrang keny noolong, wa? Yoowart! ");
INSERT INTO nys_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bayinya moort karnya nganyang kidji nganyang warrinya, karro Mammarapang Nop boorda karnya baalang nginda baal korl-koorl, moorditj wer bandjatiny; bandjatiny Maamanang birrikon-mokiny wer djin-djina kooranyi. ");
INSERT INTO nys_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngany warranga noonookany, keny-keny moorta noonooka-kardakor, baalap yoowart boorda wanni koridjat baalap djinang kedela Boodjerang Boolanga-Yira Djelyibiny.” ");
INSERT INTO nys_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Maar-koodjal kedela ngolonga Jesus kwadja-waangki nidja-nidja noolonga, Jesus barrang Peter, John wer James baalyel kidji yira-koorl kard waangko Boolanga-Yirayel. ");
INSERT INTO nys_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Winidjinbar Jesus waangkiny, baalang moolyimarri warlak-yidja, kidji baalang bwoka dalbada-biny wer bandjatiny-biny. ");
INSERT INTO nys_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yilak-yilak, koodjal mammarapa koorl kidji waangki Jesus - Moses wer Elijah. ");
INSERT INTO nys_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Koodjal koorl bandjatiny Boolanga-Yirakang dalbada-djil kidji koodjal waangki Jesus warang baal kayida boorda nganitj moodlooka Boolanga-Yira koordook nginda Jesus boorda dargang-yan Jerusalem-al. ");
INSERT INTO nys_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter wer warma ngooldjara kwadji bidjara ngwoorndiny; yalga baalap yikkan kidji baalap djinang Jesus, bandjatiny dalbada-djil, kidji koodjal mammarapa yaakiny baalyel. ");
INSERT INTO nys_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Koodjal mammarapa malyak wort-koorliny Jesus. Peter waangki, “Birdiyar, kwabba-djil ngalang yaakiny nidja! Ngala boorda warn mo maya-mayara, noonookang, Moses-ang kidji Elijah-ang.” Peter yoowart bando kaaditj noolonga baal kwadja-waangkiny. ");
INSERT INTO nys_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Alimarn baal kwadja-waangkiny, koondart yoowal-koorl kidji balaritj baalapany, kidji ngooldjara wayarn-biny narla koondart yira-koorl baalapany. ");
INSERT INTO nys_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Maay waangki yoowal-koorl koondartal, “Nidja nganyang Nop, keny nganya waangki-koorl. Dwangka baalany!” ");
INSERT INTO nys_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nginda waangkiny nganitj, Jesus doombart yaaka. Ngooldjara yoowart kayar-waangki narla moodlooka edjeniny. Ngolanga, baalap yoowart warranga moortany noolongang baalap kwadja-djinang. ");
INSERT INTO nys_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Warning kedela, Jesus wer mo ngooldjara ngarda-koorl kard kidji boola moorta yoowal-koorl Jesus. ");
INSERT INTO nys_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Boola moorta kardakor, keny mammarap mira, “Birdiyar! Ngany koort-koort noonany, miyalitj nidja nganyang nop, nganyang keny nop! ");
INSERT INTO nys_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Djenak-wara yilak baladjan baalany kidji waangki-djan kidji ngarda-kwarditj baalany nanyariny, ngarl baal djaa-narridja. Djenak-wara kalyakool bakkan baalany kidji yoowart wort-koorl baalany. ");
INSERT INTO nys_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ngany koort-koort noonang ngooldjara waangki-koorlo djenak-wara wort-koorlo yalga baalap yoowart kayar-don alidja. Baal yoowart boorda wort-koorl.” ");
INSERT INTO nys_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus waangki, “Noonooka moortaman nyiny mingitj wer koort-karni-birt! Yarn kwodjang ngany djarnyak naan-yaaka noonooka-yel? Yarn kwodjang ngany djarnyak djinang noonookang war?” Karro Jesus waangki mammarap, “Barrang noonang nop nganyak.” ");
INSERT INTO nys_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Alimarn koorlang yoowal-koorl, djenak-wara ngarda-kwarda baalany boodjeral, nanyariny. Jesus waangki-mardayin djenak-wara wandjo. Jesus barra-barra koorlang kidji korl-yanga baalany baalang maamanak. ");
INSERT INTO nys_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Moortaman kwadja-kardi nginda baalap djinang Boolanga-Yirakang moorditj mardayin. Alimarn moorta kwadja-wandaniny moodlookang Jesus kwadja-doniny, Jesus waangki baalang ngooldjara, ");
INSERT INTO nys_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Yoowart dwangka-anbangbat noolonga ngany boorda-waangki noonookany! Mammarapang Nop boorda-yanga-yan mammarapakang maara-bwora wer balapang mardayin.” ");
INSERT INTO nys_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yalga ngooldjara yoowart kaaditj natj Jesus waangki. Karni balaritj-yan baalap-yen ngarl baalap yoowart djinang karni. Baalap wayarn ngakako Jesus ngatti waangkinyang. ");
INSERT INTO nys_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ngooldjara malyak waangki-waangki baalapaal kardakor. “Natj keny ngalang nyiny moorditj-ngatti?” ");
INSERT INTO nys_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus kaaditj baalapang kaaditjiny, ngarl baal barrang koorlang kidji baal warranga koorlangany yaako baalap-booram, ");
INSERT INTO nys_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kidji waangki baalapany, “Moort yanganan nidja koorlangany nganyang kolal, kardjir yanganan nganyany; kidji moort yanganan nganyany, kardjir yanganan keny ngiyan waangki-koorl nganyany. Ngarl nyit-ngatti moort noonookany kardakor, baal moordit-ngatti nadjang noonooka mandang.” ");
INSERT INTO nys_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John waangki, “Birdiyar, ngala djinang mammarap wort-waangki-koorl djenaka-wara noonang kolal, kidji ngala warranga baalany nganitjo, narla baal yoowart keny ngalang.” ");
INSERT INTO nys_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Yoowart warranga baalany nganitjo!” Jesus waangki John wer warma ngooldjara, “Bayinya baal yoowart bakadjiny noonookany, baal yaaka noonooka-yel.” ");
INSERT INTO nys_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kedala kwadja yoowal-koorliny nginda Jesus boorda yira-barrang-yan Boolanga-Yirakang Boodjerak. Jesus kaatidj noolonga baal djarnyak don kidji baal malyak koorliny baalang djoorootal Jerusalem-ak. ");
INSERT INTO nys_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesus waangki-koorl moorta baal kwadjat, baalang moorta yana-waangki, karlamayal Samaria-kang kakataro moodlooka. ");
INSERT INTO nys_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yalga moorta karlamayang, baalap yoowart koordook baalany naan-yaakiny narla baalap kayar-djinang Jesus kwadja-koorliny baalang djoorootal Jerusalem-ak. ");
INSERT INTO nys_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nginda ngooldjara, James wer John, djinang nidja noolong, baalap waangki, “Birdiyar, noonook koordook ngalany ngarda-miro karla Boolanga-Yirakang Boodjeral kidji dargang baalapany?” ");
INSERT INTO nys_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesus korang kidji djaat baalapany. ");
INSERT INTO nys_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Karro Jesus wer baalang ngooldjara, baalap koorl warmap. ");
INSERT INTO nys_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Alimarn baalap koorl baalapang djoorootal, keny mammarap waangki Jesus, “Ngany boorda-kambarn noonany kooramba noonook koorl.” ");
INSERT INTO nys_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus waangki baalany, “Mokinya kadak karrab, kidji djerta kadak djertamaya, yalga Mammarapang Nop yoowart kadak kenyap ngwoorndo kidji bidjar.” ");
INSERT INTO nys_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesus waangki warma mammarapany, “Kambarn nganyany!” Yalga mammarap waangki, “Birdiyar, koryat korl-koorl-oola nganyany kidji dambarritj nganyang maaman.” ");
INSERT INTO nys_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus waangki, “Noyitja moorta kayar-dambarritj baalapang noyitj moorta. Noonook yoowal-koorl kidji warranga Boodjerang Boolanga-Yira Djelyibiny.” ");
INSERT INTO nys_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Warma mammarap waangki, “Birdiyar, ngany boorda kambarn noonany; yalga koryat koorl-oola nganyany kidji waangki nganyang ngoongoolong.” ");
INSERT INTO nys_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus waangki baalany, “Mammarap malyakiny biyano boodjer yalga karro baal korl-miyalitj, baal yoowart kwabba kinyak Boodjerang Boolanga-Yira Djelyibiny.” ");
INSERT INTO nys_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ngolanga, Birdiyar barrang warma 72 mammarapa kidji baal waangki-koorl mandang baalapang, bandak-koorliny baal-kwadjat, koodjal mammarapa dandjo-koorliny. Baalap koorl mandang karlamayara, kooramba Birdiyar warranga baalany baal boorda-koorl. ");
INSERT INTO nys_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesus waangki baalapany, “Boola-boola kwolaka yaaka, kakatar wedjanginy yalga yoowart boola yakina kakatar kwolaka wedjanginy. Ngala boorda ngakaka moortany ngiyan kadak kwolaka ngarl baal boorda-waangki-koorl yakina baalang kwolaka wedjanginy. ");
INSERT INTO nys_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Koorl! Ngany noonookany waangki-koorliny, nyit kookendjeri-djin mokinya kardakor. ");
INSERT INTO nys_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yoowart barrang kooda boyang, yoowart kooda koort-koortiny, yoowart djena bwoka. Yoowart nganitj kidji waangki moortany djoorootal. ");
INSERT INTO nys_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nginda noonooka bwora-koorl maya-maya, koriyat waangki, ‘Nyiny-oola nakal karlapal nidja.’ ");
INSERT INTO nys_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bayinya keny mammarap wining alidja, baal woonya nakal, noonookang warrinya nakalang kayar nyin baalyel; bayinya yoowart, noonooka wort-barrang noonookang warranga nakalang. ");
INSERT INTO nys_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nyiny keny karlap-bwora, ngarn wer djora moodlooka baalap yanga noonookany, narla yakina doora barrang baalapang boya. Yoowart koorl karlapyen keny warma karlapak. ");
INSERT INTO nys_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bayinya noonooka bwora-koorl keny maya-maya kidji baalap yanganan noonookany, ngarn wer djora moodlooka baalap yanga noonookany. ");
INSERT INTO nys_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Barra-barra minditj moorta maya-mayarang kidji warranga moortany, ‘Boodjer Boolanga-Yira Djelyibiny kwadja-yoowal-koorl noonooka-boordak.’ ");
INSERT INTO nys_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Yalga bayinya noonooka bwora-koorl karlamaya kidji baal yoowart yanganan noonookany, koorl djoorootal kidji waangki, ");
INSERT INTO nys_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mandang dalba noonookang karlamaya, ngala yoorang-yoorang dalba ngalang djenakang noonookal. Yalga barrang-dwangka nidja! Boodjer Boolanga-Yira Djelyibiny kwadja-yoowal-koorl noonooka-boordak.’ ");
INSERT INTO nys_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngany warranga noonookany, nginda Kedela-Djoniny-Karriny yoowal-koorl, Boolanga-Yira boorda-yanga koort-kwabba ngatti Sodom-ak nadjang baalapang karlamaya.” ");
INSERT INTO nys_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Alidja kedela boorda-darnayaniny noonang, Chorazin! Alidja kedela boorda-darnayaniny noonookang kardjir, Bethsaida! Moorditj noolonga kwadja-don-yan noonooka-bwora. Bayinya nidja-nidja noolonga kwadja-don-yan Tyre-bwora wer Sidon-bwora, koora moorta alidja karlamayarang doora kwadja-nyiny, wolang bwoka koort-warakang kidji yirrbin dalba baalapang kaatal, barrang-djinanginy baalap kwadja-wort-korang baalapang wara-doniny. ");
INSERT INTO nys_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kedelal Djoniny-Karriny, Boolanga-Yira boorda-yanga koort-kwabba ngatti Tyre-kak wer Sidon-ak nadjang noonookak. ");
INSERT INTO nys_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Kardjir noonook, Capernaum! Noonook koordook yira-barrango noonookaal Boolanga-Yirakang Boodjerak, wa? Noonook boorda-ngarda-kwarditj-yan Djinbaminyangap-bwora.” ");
INSERT INTO nys_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesus waangki baalang ngooldjara, “Moort ngiyan dangka noonookak, baal kardjir dangka nganyak; kidji moort ngiyan wort-korang noonookany, baal kardjir wort-korang nganyany. Kidji moort ngiyan wort-korang nganyany, baal wort-korang Boolanga-Yira, keny ngiyan waangki-koorl nganyany.” ");
INSERT INTO nys_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Alidja-alidja 72 mammarapa korl-koorl djoorab-djil. “Birdiyar!” baalap waangki. “Ngala waangki djenaka-war noonang kolal kidji baalap don natj ngala warranga baalapany!” ");
INSERT INTO nys_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus waangki baalapany, “Ngany djinang Satan djabalar worl-yen babanginy-djin! ");
INSERT INTO nys_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ni! Ngany kwadja-yanga noonookany mardayin ngarl noonooka kayar-yana wagalal wer nirnt-daalanga kidji noonooka kayar-bama mandang mardayin Satan-ang. Kidji yoowart keny noolong boorda-bakkan noonooka. ");
INSERT INTO nys_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yalga noonooka yoowart djarnyak djoorab narla djenaka-wara dwangka noonookany. Noonooka djarnyak arda djeroob narla noonookang kola boordak-yan Boolanga-Yirakang Boodjeral.” ");
INSERT INTO nys_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Karro Kangya-Kooranyikang djoorabiny moorartitj Jesus-any kidji baal waangki, “Maaman, Birdiyar Boolanga-Yirakang Boodjer wer ngalang Boodjer! Ngany yanganan noonany narla noonook kwadja-yanga kaaditjiny moortakak ngiyan kaaditjiny-birt: noonook djinang-oola baalapany noolonga noonook kwadja ballaridja dwangka-boola moortayen. Kaya Maaman, noonook koordook moodlooka edjeno nidja waral. ");
INSERT INTO nys_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Nganyang Maaman kwadja-yanga nganyany moodlooka. Yoowart moort karnayal kaaditj Nop, arda Maaman; kidji yoowart moort karnayal kaaditj Maaman, arda Nop, kidji alidja-alidja moorta ngiyan Nop koordook baalapany djinango Maaman.” ");
INSERT INTO nys_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Karro Jesus korang baalang ngooldjarak kidji arda waangki baalapak, “Kwabba-djil noonookang, noolonga djinanginy natj noonooka djinanginy! ");
INSERT INTO nys_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ngany warranga noonookany, boola malka wer djelyiba, koordook djinango natj noonooka djinang, yalga baalap yoowart djinang. Baalap koordook dwangko natj noonooka dwangka, yalga baalap yoowart dwangka.” ");
INSERT INTO nys_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Keny Mammarap-Warrinyang yoowal-koorl, kaaditjiny baal kayar manga Jesus. “Malka,” baal waangki-djinang, “Natj ngany djarnyak don barrango ngandabat kalyakool?” ");
INSERT INTO nys_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus waangki baalany, “Natj Boordakiny-Kooranyi waangki? Natj karni noonook djinang-waangki?” ");
INSERT INTO nys_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mammarap waangki, “Noonook djarnyak woonya Birdiyarany noonang Boolanga-Yira mandang noonang koort-yel, wer mandang noonang koordoonitj-yel, wer mandang noonang mardayin-yel, wer mandang noonang kaat-yel; kidji noonook djarnyak woonya noonang moorta-boordak war-djin noonook woonya noonaal.” ");
INSERT INTO nys_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Noonook karnayal waangki,” Jesus waangki. “Don nidja kidji noonook boorda-wining.” ");
INSERT INTO nys_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yalga Mammarap-Warrinyang koordook moorta djinango baal dwangka-boola kadak, ngarl baal waangki-djinang Jesus-any, “Ngiyan nganyang moorta-boordak?” ");
INSERT INTO nys_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus waangki, “Keny mammarap kwadja-ngarda-koorliny Jerusalem-yen Jericho-ak. Ngakalyanga balladja baalany, wort-barrang baalang bwoka, bama baalany kidja wandja baalany, noyitj boordak. ");
INSERT INTO nys_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Alidja kedela, yakin-kooranyi kwadja-ngarda-koorliny alidja djooroot; yalga nginda baal djinang mammarapany, baal wort-yana warma naralal djoorootang. ");
INSERT INTO nys_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Keny mammarap, Levi-kang djoowak, kardjir ngarda-koorl alidja djooroot. Baal koorl kidji miyalitj mammarap, kidji karro wort-yana warma naralal djoorootang. ");
INSERT INTO nys_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ngolanga, mammarap Samaria-karlap ngarda-koorl alidja djooroot. Baal boordak-koorl mammarapany. Nginda baal djinang baalany, ngorna-kwabba moorartitj baalang koort. ");
INSERT INTO nys_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Baal koorl baalany, baal nabba boyin koorayinang wer kepa-mardayin baalang boomabaraka-bwora, kidji dengkoor baalapany. Karro baal yidja mammarapany baalang dongki-kal kidji barrang baalany maya-mayak ngwoorndiny, kidji maar-yanga baalany. ");
INSERT INTO nys_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Warning Kedela, baal barrang baalang boya kidji baal yanga boya birdiyarak maya-mayang. ‘Karrodjin baalany,’ mammarap Samaria-karlap waangki, ‘kidji nginda ngany korl-koorl djoorootal nidja, ngany boorda-yanga noonany boya-ngatti moodlookang noonook banitja baalang.’ ” ");
INSERT INTO nys_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Karro Jesus waangki-djinang, “Natj noonook kaaditj? Ngiyan kardakor nidja-nidja mo mammarapa kwadja moort-boordak mammarapang ngiyan ngakalyanga balladja?” ");
INSERT INTO nys_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mammarap-Warrinyang waangki, “Mammarap ngiyan maar-yanga baalany.” Jesus waangki, “Karro noonook koorl kidji don baal-djin.” ");
INSERT INTO nys_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Alimarn Jesus wer baalang ngooldjara yana baalapang djooroot, baalap yoowal-koorl karlamaya. Bokadja, keny yok kol Martha ngakaka baalapany ngwoorndo baalang maya-maya-bwora. ");
INSERT INTO nys_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mary, Martha-kang djook, nyiny Birdiyar-ang djena-boordak kidji koordook dwangko baalany. ");
INSERT INTO nys_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martha yoowart djoorab narla baal moodlooka doniny, ngarl baal koorl kidji waangki, “Birdiyar, noonook kayar-djinang nganyang djook, wa? Baal wort-koorl kidji nyiny kidji nganya djarnyak don mandang yakiny! Warranga Mary, baal djarnyak yoowal-koorl kidji maar-yanga nganyany!” ");
INSERT INTO nys_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesus waangki baalany, “Martha, Martha! Noonook koort-ngarda narla boola noolonga. ");
INSERT INTO nys_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yalga noonook ngarnala arda keny noolong. Mary koordook kwabba-ngatti noolong. Ngala yoowart djarnyak wort-barrang alidja baalyen.” ");
INSERT INTO nys_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Keny kedela warmapal, Jesus waangkiny Boolanga-Yirak. Nginda Jesus nganitj, keny baalang ngooldjar waangki baalany, “Birdiyar, warranga ngalany yarn ngala doora waangki Boolanga-Yirak, war-djin John warranga baalang ngooldjara.” ");
INSERT INTO nys_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus waangki baalapany, “Nginda noonooka waangki Boolanga-Yirak, waangki nidja: ‘Maaman, noonang kol nyiny kooranyi. Yoowal-koorl-oola kedela nginda noonook nyiny Djelyib. ");
INSERT INTO nys_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yanga ngalany mereny ngala ngarnala yennar kedela. ");
INSERT INTO nys_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nyinya-nyinya ngalang wara-doniny, war-djin ngala nyinya-nyinya wara-doniny moortaman don ngalak. Kidji yoowart barrang ngalany ngwidamap-ak djoriny karriny.’” ");
INSERT INTO nys_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kidji Jesus waangki baalang ngooldjarany, “Yeyi ni, bayinya keny noonang koorl babinang maya-mayak didara kadik, kidji waangki baalany, ‘Nganyang babin, ngany ngakaka noonany, ngany kayar bangal-yanga mo mooloor merenyang? ");
INSERT INTO nys_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nganyang warma babin marridjiny, yeyi baal yoowal-koorl nganyang maya-maya, yalga ngany mereny-birt yango baalany!’ ");
INSERT INTO nys_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kidji bayinya noonang babin mira maya-maya-yen, ‘Yoowart yikkan nganyany! Ngany kwadja-barrang-bida! Nganyang koorlangka wer ngany, ngala bidjara ngwoorndiny. Ngany yoowart kayar-yiraba kidji yanga noonany natj noonook koordook.’ ");
INSERT INTO nys_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yeyi natj karro? Ngany waangki noonany, bayinya baal yoowart boorda-yiraba kidji yanga noonany mereny narla noonook baalang babin, yalga baal boorda-yiraba kidji yanga noonany moodlooka noonook ngarnala narla noonook yoowart karnya ngakako ngatti-ngatti. ");
INSERT INTO nys_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kidji ngarl, ngany waangki noonookany: Ngakaka, kidji noonook boorda-yanga-yan; warkata, kidji noonook boorda-djinbarranga; dorl-dorl, kidji bida boorda yalgaran-yan noonookang. ");
INSERT INTO nys_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Narla moortaman ngiyan ngakaka, alidja noolong boorda-yanga-yan; kidji baal ngiyan warkata, baal boorda-djinbarranga. Dorl-dorl kidji bida boorda-yalgaran-yan moortamanang ngiyan dorl-dorl. ");
INSERT INTO nys_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ngany waangki-djinang noonookany, noonooka maamana: ‘Nginda noonookang nop ngakaka djildjit, noonooka boorda yanga baalany wagal, wa? ");
INSERT INTO nys_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kidji nginda baal ngakaka noorookany, noonooka boorda-yanga baalany nirnt-daalang, wa?’ ");
INSERT INTO nys_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yeyi noonooka wara moorta, yalga noonooka kaaditj yarn yango kwabba noolonga noonookang koorlangkak. Ngarl Boolanga-Yira, noonookang Maaman, baal boorda-yanga boola ngatti; baal boorda-yanga Kangya-Kooranyi moortamanak ngiyan ngakaka baalany!” ");
INSERT INTO nys_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus kwadja-yekaniny djenak-wara. Djenak-wara waangki-birt, yalga nginda djenak-wara bandak-koorl, mammarap malyak waangkiny. Moortaman kai-kai. ");
INSERT INTO nys_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yalga mo moorta waangki, “Beelzebul, djenaka-warakang yoolindja, baal yanga Jesus mardayin bandak-yekano baalapany.” ");
INSERT INTO nys_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Warma Moorta koordook mango Jesus, ngarl baalap Jesus-any ngakaka Jesus dono ngoolong-malka ngarl baalap kayar-djinang bayinya Boolanga-Yira nyiny Jesus-yel. ");
INSERT INTO nys_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yalga Jesus djinang natj baalap kwadja-kaaditjiny, ngarl Jesus waangki baalapany, “Bayinya keny boodjer karda-dakkan-yan kidji moorta boodjerang bakatj warma moorta boodjerang, karro nidja boodjer yoowart kwodjang boorda-yaaka; bayinya moorta ngoongoolongang karda-dakkan-yan, ngoongoolong boorda-djiran-yan. ");
INSERT INTO nys_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ngarl bayinya boodjer Satan-ang karda-dakkan-yan, yarn baalang boodjer boorda-yaaka? Noonooka waangki natj ngany yekana djenaka-wara narla Beelzebul yanga nganyany mardayin. ");
INSERT INTO nys_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bayinya ngany yekana baalapany nidja war, yarn noonookang ngooldjara-kambarna yekana baalapany? Noonookaroo ngooldjara-kambarna barrang-djinang alidja noonooka karna-birt! ");
INSERT INTO nys_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yoowart! Ngany yekana djenaka-wara narla Boolanga-Yirakang moorditj mardayin! Ngarl noonooka kayar djinang Boodjer Boolanga-Yira Djelyibiny yoowal-koorliny noonookak. ");
INSERT INTO nys_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nginda mardayin mammarap kakatar baalang kidja tornamako baalang maya-maya, karro mandang baalang noolonga nyiny ngabalangornda. ");
INSERT INTO nys_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yalga nginda mardayin-ngatti mammarap balladja baalany kidji ngarda-kwarditj baalany, baal wort-barrang mandang kidja, moodlooka mammarap kwadja-kakatar. Karro, moodlooka baal yardjang, baal walak-walak-yanga. ");
INSERT INTO nys_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Bayinya moort yoowart yaaka ngany-boordak, baal yaaka ngany-boyang, kidji bayinya moort yoowart maar-yanga nganyany noolonga djabaniny, karnayal, baal noolonga wort-kwarditjiny.” ");
INSERT INTO nys_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nginda djenak-wara bandak-koorl mammarapany, baal marridja kwangkanal, koorl-djinanginy nyinyap. Bayinya baal yoowart djinbarranga kenyap, baal waangki ‘Ngany boorda korl-koorl nganyang maya-maya.’ ");
INSERT INTO nys_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ngarl djenak-wara korl-koorl kidji baal djinang maya-maya, barnan-yan kidji djandarn-yan. ");
INSERT INTO nys_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Karro baal bandak-koorl kidj korl-barrang maar-koodjal warma djenaka-wara. Baalap wara-ngatti kidji baalap yoowal-koorl kidj nyiny alidja. Ngarl nginda moodlooka edjena, mammarapang ngandabat minditj-ngatti-bini wer wara-ngatti nadjang baalang ngandabat kwadjat.” ");
INSERT INTO nys_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ngolanga Jesus waangki nidja, keny yok moorta-boola kardakor waangki Jesus, “Yarn djoorab, yok ngiyan yidja noonany kidji yanga noonany bibi!” ");
INSERT INTO nys_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yalga Jesus waangki, “Yalga yarn djoorab, nidja-nidja moorta ngiyan dwangka Boolanga-Yira waangkiny kidji don moodlooka baal waangki!” ");
INSERT INTO nys_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Alimarn boola moorta boordak-koorl Jesus, baal karro-waangki, “Baalap wara-wara, moorta nidja kedela! Baalap koorl-djinang ngambing, yalga yoowart ngambing boorda-yanga-yan baalapany, arda Jonah-kang ngambing. ");
INSERT INTO nys_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Boolanga Yira, baal waangki-koorl Warda Marridjiny Jonah Ninevah-kak. Baal ngambing-biny moortakang. War-djin, Mammarapang Nop ngambing-biny moortakang nidja kedela. ");
INSERT INTO nys_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nginda Kedela-Djoniny-Karriny yoowal-koorl, Yok Djelyib Sheba-kang boorda-yaaka kidji djirin moorta nidja kedelang, narla baal marridja baalang kadjali boodjerayen dwangko Djelyib Solomon-ang kwabba-djil warrinya, kidji ngany warranga noonookany, moort yaaka nidja, baal moorditj-ngatti nadjang Solomon. ");
INSERT INTO nys_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nginda Kedela-Djoniny-Karriny yoowal-koorl, moorta Nineveh-karlap boorda yaaka kidji djirin noonookany narla baalap korang baalapang wara-wara war-yen nginda baalap dwangka Jonah-kang warranginy, kidji ngany waangki noonookany, karnayal, moort yaaka nidja, baal moorditj-ngatti nadjang Jonah!” ");
INSERT INTO nys_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Yoowart moort bowan karla-maat kidji ballaridja baalany ka dengkoor baalang binari. Baal yira-barrang dallar ngarl moorta kayar-djinang binari nginda baalap bwora-koorl. ");
INSERT INTO nys_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Noonookang miyala yarlinang binari-mokiny. Bayinya noonookang miyala kwabba, binyari boorda-moorartitj mandang noonookang yarlin; yalga bayinya noonookang miyala wara, mandang noonookang yarlin boorda-mayart-bwora. ");
INSERT INTO nys_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Noonook djarnyak wining ngarl binyari noonook-bwora yoowart mayart-bini. ");
INSERT INTO nys_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bayinya binyari moorartitj mandang noonookang yarlin, kidji yoowart bangka mayart-bwora, mandang noonookang yarlin boorda-bandjat-biny, karla-mokiny nginda baalang binyari noonookal bandjatiny.” ");
INSERT INTO nys_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nginda Jesus nganitj waangkiny, keny Pharisee ngakaka Jesus ngarno baalyel; ngarl Jesus bwora-koorl kidji nyiny ngarno. ");
INSERT INTO nys_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pharisee kai-kai nginda baal djinang Jesus yoowart kakaloorniny kwadjat ngarniny. ");
INSERT INTO nys_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ngarl Birdiyar waangki baalany, “Yeyi, noonooka Pharisee-ya barnan mabo moodlookakang natj noonooka banitja nginda noonooka ngarn ka djora, yalga noonooka-bwora, bakadjiny wer wara-wara moorartitj noonookany. ");
INSERT INTO nys_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Noonooka tatan moorta! Boolanga-Yira warn bangka-mabo. Boolanga-Yira kardjir warn bangka-bwora, wa? ");
INSERT INTO nys_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yalga barrang mereny wer djora kidji yanga winyan moorta. Karro moodlooka boorda-barnan-biny aliwar Warriny waangki. ");
INSERT INTO nys_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Darnayan-djil noonookatang Pharisee-ya! Noonooka yanga Boolanga-Yira baalang nyit walak noonookang djallamang wer kwolaka wer dilbiga, yalga noonooka yoowart don kwabba moortakak kidji noonooka yoowart woonya Boolanga-Yirany. Koriyat, noonooka djarnyak don nidja-nidja noolonga, kidji ngolonga, noonooka kardjir kayar-don warma noolonga. ");
INSERT INTO nys_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Darnayan-djil, noonookang Pharisee-ya! Noonooka woonya kwabba-djil nyinyap Maya-maya-Kalyarakal. Kidji mandjaral, noonooka koordook moortany waangkiny, ‘Noonooka moorditj.’ ");
INSERT INTO nys_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Darnayan-djil noonookang! Noonooka bogala-mokiny kol-birt, kidja moorta kana baalapany kaaditjiny-birt.” ");
INSERT INTO nys_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Keny Mammarap-Warrinyang waangki Jesus, “Birdiyar, bayinya noonook waangki nidja, noonook kardjir wara-waangki ngalany!” ");
INSERT INTO nys_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus waangki, “Darnavan-djil kardjir noonookang Mammarapa-Warrinyang! Noonooka yidja wondanga moortakang moorndinal, wondanga banyadak-ngatti kango yalga noonooka yoowart yiraba keny noonokang maar-biri maar-yango baalapany kango baalapang wondanga. ");
INSERT INTO nys_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Darnayan-djil noonookang! Noonooka warn kwabba-kwabba bogala Warda-Marridjinyang, yalga karnayal, noonookang maam-inrama, baalap dargang Warda-Marridjinya. ");
INSERT INTO nys_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nidja barrang-djinang noonooka djoorab narla noolonga noonookang maam-inrama kwadja-don. Baalap dargang Warda Marridjinya, kidji noonooka warn baalapang bogala. ");
INSERT INTO nys_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Narla nidja-nidja noolongakang, Boordakiny-Kooranyi waangki, ‘Ngany boorda waangki-koorl Warda-Marridjinyany baalapak kidji kardjir warma moorta waangko baalapany; baalap boorda dargang keny-keny moorta kidji baalap boorda-bakkan warma moorta’ ");
INSERT INTO nys_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ngarl moorta nidja kedelang boorda-djin-bama-yan Warda-Marridjinyang darganginy, mandang Warda-Marridjinya ngiyan kwadja-dargang-yan, ngolanga Boodjerang alikwadja, ");
INSERT INTO nys_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","malyakiny darganginyel Abel-ang, kidji nganitjiny darganginyel Zechariah-kang, bama-yan kardakor karla-kooranyi wer Kooranyap. Kaya, ngany warranga noonookany, moorta nidja kedelang boorda-djin-bama-yan narla mandang nidja-nidja noolonga!” ");
INSERT INTO nys_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Darnayan-djil noonookang, Mammarapa-Warrinyang! Noonook barrang-yalgawa war yalgarano bida maya-mayakang kaaditjinyang. Ngany karnayal waangki, noonooka yoowart boorda bwora-koorl, kidji noonooka nganitj warma moorta ngiyan koordook bwora-koorlo!” ");
INSERT INTO nys_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nginda Jesus bandak-koorl maya-maya, mandang Mammarapa-Warrinyang wer Pharisee-ya kwadjin wara-wara-waangkiny Jesus. Baal waangki-djinang baalany boola noolonga. ");
INSERT INTO nys_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Baalap koordook mango Jesus, djinanginy bayinya baal boorda-waangki karna-birt noolong. ");
INSERT INTO nys_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Boola-boola moorta malyak dandjo-dandjo yoowal-koorliny, boola-ngatti baalap kana warma moortany. Yalga koriyat, Jesus waangki baalang ngooldjara, “Balayi! Yoowart barrang Pharisee-yang kwolaka. Ngany waangkiny baalapang koolyooma, nginda baalap yoowart don noolonga baalap waangki. ");
INSERT INTO nys_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mandang noolonga dengkoor-yan boorda-djinang-yan, kidji moodlooka ballar-yan boorda-kaaditj-yan. ");
INSERT INTO nys_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Narla noolonga noonooka waangki mayartal kadikang boorda-dwangka-yan binarikal kedelang, kidji warrinya noonooka kati-kati-waangki kobinapal boorda-mira-yan kattayen maya-mayang.” ");
INSERT INTO nys_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ngany warranga noonookany, nganyang ngooldjara, yoowart wayarn moorta, alidja-alidja moorta ngiyan kayar-dargang noonookang yarlin, yalga ngolanga, baalap yoowart kayar-don wara-ngatti noolong. ");
INSERT INTO nys_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ngany boorda-warranga noonookany keny noonooka djarnyak wayarn. Wayarn Boolanga-Yirany! Ngolanga noonookany darganginy, baal kayar-kwarda noonookany Djinbaminyap-bwora. Karnayal, noonooka djarnyak wayarn Boolanga-Yira! ");
INSERT INTO nys_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Moorta bangal maar nyit djert koodjal boyakang nyit, wa? Yalga Boolanga-Yira yoowart dwangka-anbangbat keny nyit djert. ");
INSERT INTO nys_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Boolanga-Yira kaaditj mandang djoomba noonookang kaatal. Ngarl yoowart wayarn! Boolanga-Yira woonya noonookany boola-ngatti nadjang mandang djerta!” ");
INSERT INTO nys_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Karnayal, ngany warranga noonookany, bayinya moort barnak waangki, baal nyiny nganyang, Mammarapang Nop boorda-waangki noolonga-djin baalang, Boolanga-Yirakang djin-djina-kwabba booram. ");
INSERT INTO nys_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yalga bayinya moort barnak wort-korang nganyany, Mammarapang Nop kadjir boorda-wort-korang baalany Boolanga-Yirakang djin-djina-kwabba booram. ");
INSERT INTO nys_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Bayinya moorta wara-waangki Mammarapang Nop, baalap kayar nyinya-nyinya-yan; yalga bayinya moorta wara-waangki Kangya-Kooranyi, baala yoowart kayar nyina-nyinya-yan. ");
INSERT INTO nys_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nginda baalap barrang noonookany kidji djonany-karriny noonookany Maya-maya-Kalyaragal ka djelyiba booram ka warma birdiyara, noonooka yoowart djarnyak koort-ngarda nginda noonooka yaaka baalap-booram kidji noonooka yoowart kaaditj warrinya noonooka boorda-waangki ");
INSERT INTO nys_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","narla Kangya-Kooranyi boorda maar-yanga noonookany ngarl noonooka boorda-kaaditij warrinya noonooka djarnyak waangki.” ");
INSERT INTO nys_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Boola moorta kardakor, keny mammarap Jesus-any waangki, “Birdiyar, warranga nganyang ngooni baal djarnyak walak-yanga moodlooka ngalang maaman yanga ngalany ngolanga baal wanni.” ");
INSERT INTO nys_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus waangki baalany, “Ngiyan yanga nganyany mardayin waangko ngiyan kwabba nyiny kidji walak-yanga moodlooka nyootjoowal kardakor?” ");
INSERT INTO nys_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Karro Jesus waangki moortaman, “Balayi! Noonooka moortaman djarnyak wort-korang mandang ngarbat; narla moortang karnayal ngandabat yoowart djinang-yan noolongakal baal kadak, yoowart doora bayinya baal boya boola-boola-kadak.” ");
INSERT INTO nys_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Karro Jesus waangki baalapany nidja bardip, “Keny mammarap boola boya-kadak. Baalang boodjer yidja kwabba kwolaka. ");
INSERT INTO nys_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Baal kwadjin waangkiny, ‘Ngany yoowart kadak maya-maya ngomon kanyinyang nganyang kwolaka. Natj ngany kayar-don?’ ");
INSERT INTO nys_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘Nidja ngany boorda-don,’ baal waangki baalaal, ‘Ngany boorda-barrang-djakan nganyang maya-maya kwolakang kidji warn maya-mayara ngomon-djil kanyinyang moodlooka, nganyang kwolaka kidji mandang nganyang warma noolonga. ");
INSERT INTO nys_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Karro ngany kayar-waangki, “Noonook djoorab mammarap! Noonook kadak mandang kwabba noolonga, moodlooka noonang koort-bakkan boola birokang. Nyiny, ngarn wer djora, kidji ngandabat boorda-djoorab-biny!” ");
INSERT INTO nys_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Yalga Boolanga-Yira waangki baalany, ‘Noonook tatan mammarap! Yeyi, nidja kadik, noonook djarnyak wort-yanga noonang ngandabat. Karro, ngiyan boorda-kadak mandang nidja-nidja noolonga noonook arda kanya noonookaal?’ ” ");
INSERT INTO nys_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ngolonga bardip, Jesus waangki, “Nidja boorda-edjena ngandabatak moortang ngiyan kanya boola boya arda baalapaal, yalga baalap yoowart boola boya-kadak Boolanga-Yirakang miyalal.” ");
INSERT INTO nys_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Karro Jesus waangki baalang ngooldjar, “Kidji ngarl ngany warranga noonookany, yoowart koort-wara noonang ngandabatang, barranginyang mereny wer djora wer bwoka noonang yarlinang. ");
INSERT INTO nys_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ngandabat moorditj-ngatti nadjang ngarniny wer djoriny, kidji yarlin moorditj-ngatti nadjang bwoka. ");
INSERT INTO nys_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Djinang wardanga! Baalap yoowart niran kwolaka ka wedjang kwolaka. Baalap yoowart kadak maya-maya kwolakang. Boolanga-Yira yanga baalapany mereny ngarno! Noonooka moorditj-ngatti nadjang djerta! ");
INSERT INTO nys_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ngany waangki-djinang, noonooka kayar-wining kwodjang-ngatti arda narla noonooka koordook nidja? ");
INSERT INTO nys_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bayinya noonooka yoowart kayar-don nidja nyit noolong, nadjil koort-wara warma noolongakang? ");
INSERT INTO nys_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Djinang mania mandakak! Baalap yoowart yaka. Baalap yoowart warn bwoka wandango. Ngany warranga noonookany, Djelyib Solomon boola-boola boya-kadak yalga baal yoowart kadak kwabbalitj-ngatti bwoka nadjang nidja-nidja mania. ");
INSERT INTO nys_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","“Boolanga-Yira wolang-bwoka djilba. Nidja djilba maladj kedela nidja kidji wort-koorl benang, narra-yan karlakal. Ngarl Boolanga-Yira boorda wolang-bwoka noonookany koodjookat djilba, wa? Noonookang koort-karni nyit-djil! ");
INSERT INTO nys_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ngarl yoowart winyan, kalyakool koort-wariny noolongakang noonooka boorda-ngarn ka djora. ");
INSERT INTO nys_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Narla warma moorta Boodjerang nidja, moorta ngiyan yoowart kaaditj Boolanga-Yirany, baalap kalyakool koort-wara mandang nidja-nidja noolongakang. Noonookang maaman kaaditj noonooka ngarnala nidja-nidja noolonga. ");
INSERT INTO nys_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ngarl djoorabiny nganaka kedela nginda Boolanga-Yira boorda-nyin Djelyib kidji baal boorda-yanga noonookany mandang nidja-nidja noolonga.” ");
INSERT INTO nys_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nganyang nyit moorta, yoowart wayarn, narla noonookang Maaman djoorabiny yanga noonookany Boodjer Boolanga-Yira Djelyibiny. ");
INSERT INTO nys_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Wort-bangal noonookang banaraka kidji yanga boya winyan moortany. Barrang kooda-boyang natj yoowart mingal kidji yidja noonookang boya Boolanga-Yirakang Boodjeral. Bokadja, noonookang boya yoowart nyit-abini, narla yoowart ngakalyang kayar barrang kooramba kidji woorla yoowart kayar ngarn kooramba. ");
INSERT INTO nys_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Narla noonookang koorta kalyakool boorda-wining boodjeral windji noonookang boya wining. ");
INSERT INTO nys_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Noonooka djarnyak kakatar moodlookang natj boorda-edjena, wandang-yan kidji nganakiny kidji noonookang karla-maat narriny, ");
INSERT INTO nys_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","yakina-djin ngiyan nganakiny baalapang birdiyar korl-koorlo ngolonga mandjar koorta-kadakiny. Nginda baal yoowal-koorl kidji dorl-dorl, baalap kwitj boorda-yalgaran bida. ");
INSERT INTO nys_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Baalap djoorab-djil, nidja-nidja yakina, narla baalapang birdiyar djinbarranga baalapany djerramin kidji kakatar nginda baal korl-koorl! Ngany waangki noonookany, baal boorda-bilyan baalang kwabba bwoka, warranga baalapany nyino, kidji yanga baalapany baalapang mereny wer djora. ");
INSERT INTO nys_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Baalap boorda djoorab-djil, bayinya baal djinbarranga baalapany kakatar, bayinya baal doora yoowal-koorl mayartal kadikang ka ngangk boordak yira. ");
INSERT INTO nys_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yalga noonooka yeyi kaaditj nidja karnarny: bayinya mammarap kadak baalang maya-maya kidji baal kaaditj nginda ngakalyang boorda-yoowal-koorl, baal yoowart boorda-djakan-oola ngakalyang baalang maya-maya kidji bwora-koorl. ");
INSERT INTO nys_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kidji noonooka kardjir, noonooka djarnyak kakatar, narla Mammarapang Nop boorda-yoowal-koorl winidjinbar nginda noonooka yoowart nganaka baalany.” ");
INSERT INTO nys_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter waangki, “Birdiyar, noonook arda warranginy nidja bardip noonookak. Yalga noonook kardjir koordook mandang warma moorta dwangko bardip, wa?” ");
INSERT INTO nys_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Birdiyar yalman-waangki, “Karro, natj yakin koort-karni wer dwangka-boola? Yakin ngiyan birdiyar yidja baalany yira-ngatti nadjang warma yakina ngomon maya-mayal. Kwabba djikal, baal boorda-yanga mereny wer djora warma yakinarak. ");
INSERT INTO nys_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nidja yakin boorda-djoorab-djil bayinya baalang birdiyar djinang baalany doniny kwabba noolonga nginda baal karlap-koorl! ");
INSERT INTO nys_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Karnany, ngany warranga noonookany, birdiyar boorda-yidja baalany karrodjiny mandang baalang banarak. ");
INSERT INTO nys_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yalga bayinya nidja yakin waangki baalaal, ‘Nganyang birdiyar kwodjang korl-koorliny,’ kidji bayinya baal kwadjin baminy warma yakina, mammarapa wer kadjir yokaman, kidji ngarniny wer djoriny wer yowir-biny, ");
INSERT INTO nys_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","karro baalang birdiyar boorda-korl-koorl keny kedela, djikal baal yoowart kaaditj. Nidja yakin yoowart baalany nganakiny. Birdiyar boorda-kadjat baalany mala-malak kidji yakin boorda-ngarda-koorl djooroot djinbaminyang moortaman-mokiny mingitj doniny. ");
INSERT INTO nys_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Bayinya yakin kaaditj natj baalang birdiyar koordook baalany dono, yalga yoowart kakatar dono nidja, baal boorda-djinbaminy-yan boola baminyel. ");
INSERT INTO nys_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yalga bayinya yakin yoowart kaaditj natj baalang birdiyar koordook baalany dono, kidji don mingitj noolong, baalang birdiyar djarnyak djinbama baalany, yalga birdiyar boorda biyang bama baalany. Moort yanga-yan boola, baal djarnyak yanga boola; moort yanga-yan boola-ngatti, baal djarnyak yanga boola-ngatti. ");
INSERT INTO nys_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ngany yoowal-koorl Boodjer narro. Karnayal, ngany koort-bakkan karla yeyi bowan-yan. ");
INSERT INTO nys_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kedela nganyang kakaloorniny djarnyak edjena, kidji nganya boorda-koort-wara-djil kwadjat kedela nginda moodlooka boorda-nganitj. ");
INSERT INTO nys_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Noonooka waangki ngany yoowal-koorl barrango nakal Boodjerak? Yoowart, yoowart nakal, yalga arda karda-dakkaniny. ");
INSERT INTO nys_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yeyi keny ngoongoolongal, maar moorta boorda-karda-dakkan-yan, mo moorta boorda-bakatj koodjal moorta kidji koodjal moorta boorda-bakatj mo moorta. ");
INSERT INTO nys_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Maamana boorda-bakatj baalapang nopa kidji nopa boorda-bakatj baalapang maamana; ngaangka boorda-bakatj baalapang kowarta, kidji kowarta boorda-bakatj baalapang ngaangka; mangata boorda-bakatj baalapang kambarta; kidji kambarta boorda-bakatj baalapang mangata.” ");
INSERT INTO nys_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus kardjir waangki moortany, “Bayinya noonooka djinang koondart yoowal-koorliny marawaral, noonooka kwitj waangki, ‘Kepa yoowal-koorliny,’ kidji kepa yoowal-koorl. ");
INSERT INTO nys_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kidji bayinya booyal marr nooyang, noonooka waangki, ‘Nidja kedela boorda-karlang,’ kidji kedela karlang-bini ");
INSERT INTO nys_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Noonooka dal-koodjal! Noonooka kayar-djinang boodjera wer worl. Noonooka kaaditj ngambinga kepang wer marr. Ngarl, nadjil noonooka yoowart kayar-djinang ngambinga nidja-nidja kedelakang? ");
INSERT INTO nys_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nadjil noonooka yoowart kaaditji war doninyang kwabba?” ");
INSERT INTO nys_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Bayinya moort waangki-waangki kidji baal koordook barrango noonany ngomon maya-mayak djonany-karinyang, noonook djarnyak koridjat bedik-bedik waangki baalany kidji nyootjoowal djarnyak koorta-keny kwadjat noonook yoowal-koorl djonany-kariny. Bayinya noonook yoowart don nidja, baal boorda-barrang noonany birdiyar djonany-karinyang booram. Baal boorda-yanga noonany manatjakang maar-bwora, kidji baalap boorda-yidja noonany maya-mayal dedin-yan kidji baalap boorda-dedin bida. ");
INSERT INTO nys_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","“Ngany waangki noonany, noonook boorda-nyiny alidjap kedelak noonook boorda-yanga yadok boya, moodlooka noonook djarnyak yanga.” ");
INSERT INTO nys_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Alidja kedela, keny-keny moorta warranga Jesus moortakang Galilee-karlap. Pilate kwadja-dargang baalap winidjinbar baalap kwadja-yanga-narriny Boolanga-Yirakany. ");
INSERT INTO nys_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus waangki-djinang baalapany, “Natj noonooka waangki? Alidja-alidja moorta Galilee-karlap, Herod dargang baalapany bokadja. Noonooka waangki nidja edjena narla baalap kwadja-wara-doniny boola-ngatti nadjang warma moorta Galilee-karlap, wa? Noonooka kaaditj nidja, wa? ");
INSERT INTO nys_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yoowart, karnayal! Yalga ngany warranga noonookany, bayinya noonooka yoowart wort-korang, kidji wandja noonookang wara-doniny, mandang noonooka boorda-wanni, baalap-mokiny. ");
INSERT INTO nys_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kidji alidja-alidja 18 moorta Siloam-karlap. Baalap wanni narla alidja woorri maya-maya djabalar baalapal. Noonooka waangki nidja edjena narla baalap kwadja-wara-doniny boola-ngatti nadjang warma moorta Jerusalem-karlap, wa? Noonooka kaaditj nidja, wa? ");
INSERT INTO nys_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yoowart, karnayal! Yalga ngany warranga noonookany, bayinya noonooka yoowart wort-korang, kidji wandja noonookang wara-doniny, mandang noonooka boorda-wanni, baalap-mokiny.” ");
INSERT INTO nys_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Karro Jesus warranga baalapany nidja bardip. “Mammarap maladja keny kolboga boodjeral baalang maya-maya-boordak. Baal koorl-djinang djildji yalga baal yoowart djinang keny djildji. ");
INSERT INTO nys_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ngarl baal waangki baalang yakin, ‘Miyalitj! Ngany koorl-djinang djildji nidja kolbokakang, kidji ngany yoowart djinang keny djildji. Kadjat nidja boorn! Nidja kolboga yoowart djarnyak banitja boodjer.’ ");
INSERT INTO nys_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yalga yakin waangki, ‘Birdiyar, maladj-oola boorn keny warma birok. Ngany boorda-yidja koonang boodjeral kidji dordong-biyan boorn. ");
INSERT INTO nys_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Warning birok, bayinya boorn yidja djildji, alidja kwabba; bayinya yoowart, karro nyany boorda-kadjat boorn.’” ");
INSERT INTO nys_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Keny Kedela-Kooranyi, Jesus kwadja-karni-waangkiny moorta Maya-Maya-Kalyaragal. ");
INSERT INTO nys_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Keny yok djenak-wara kadak kidji baal kwadja-minditj 18 biroka. Baal kwadja bogal-wara kidji baal yoowart kayar yiraba. ");
INSERT INTO nys_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nginda Jesus djinang yok, baal waangki, “Yok, noonook yalkaran-yan noonang minditjang!” ");
INSERT INTO nys_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesus maar-barrang baal kidji kwitj baal yiraba kidji baal yanganan Boolanga-Yira. ");
INSERT INTO nys_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yeyi keny birdiyar Maya-Maya-Kalyarakang, baal kaarang-biny narla Jesus barra-barra nidja yok Kedela-Kooranyikal. Ngarl baal warranga moorta, “Noonooka kayar-yaka maar-keny kedelara; ngarl yoowal-koorl alidja-alidja kedelaka kidji barra-barra-biny; yalga yoowart yoowal-koorl Kedela-Kooranyikal!” ");
INSERT INTO nys_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesus waangki baalany, “Noonook dal-koodjal! Mandang noonooka boorda-bilyan noonookang booliyak ka ngort kidji bandak-barrang baalany kidji yanga baalany kepa Kedela-Kooranyikal. ");
INSERT INTO nys_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yeyi nidja yok, baal nyiny Abraham-ang djoowak. Satan kwadja-yadarn baalany 18 biroka. Nadjil baal yoowart kayar bilyan-yan Kedela-Kooranyikal?” ");
INSERT INTO nys_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nginda Jesus yalman-waangki, birdiyar ngiyan waangki-waangki karnya-biny, kidji moortaman djoorab-biny narla moorditj noolonga Jesus kwadja-doniny. ");
INSERT INTO nys_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus waangki-djinang, “Natjang Boodjer Boolanga-Yira Djelyibiny? Natj ngany kayar-waangki baal-mokiny? ");
INSERT INTO nys_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Baal nidja-mokiny. Mammarap barrang keny nyit-nyit kwolak kidji niran kwolak boodjeral. Kwolak maladja kidji boorn-biny, kidji djerta kayar-warn djertamayaka maarakal!” ");
INSERT INTO nys_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Karro Jesus waangki-djinang, “Natjang Boodjer Boolanga-Yira Djelyibiny? Natj ngany kayar-waangk baal-mokiny? ");
INSERT INTO nys_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Baal nidja-mokiny. Keny yok barrang nyamap kolyar kidji weyang kolyar wer kwonert ngomon mirlkoonal ngarl mandang mereny yiraba.” ");
INSERT INTO nys_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus koorl boola karlamaya, karni-waangkiny moort kidji koorliny baalang djoorootal Jerusalem-ak. ");
INSERT INTO nys_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Keny mammarap waangki-djinang baalany, “Birdiyar, keny-keny moorta arda boordabarrang-ngandabat-yan, wa?” Jesus yalman-waangki baalany, ");
INSERT INTO nys_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Noonooka djarnyak kalyakool don moodlooka natj noonook kayar-don bwora-koorlo nooloo bida. Ngarla karnayal, boola moorta boorda-koordook bwora-koorlo nooloo bida, yalga baalap yoowart boorda kayar bwora-koorl. ");
INSERT INTO nys_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Birdiyar maya-mayakang boorda-yiraba kidji dedin bida. Karro nginda noonooka bandak-yaaka kidji kwadjin dorl-dorliny kidji miriny ‘Birdiyar, yalgaran bida ngalang!’ baal boorda-waangki noonookany, ‘Ngany yoowart kaaditj noonookany. Windjang noonooka yoowal-koorl!’ ");
INSERT INTO nys_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Karro noonooka boorda-yalman-waangki, ‘Ngala ngarn wer djora noonal; noonook karni-waangki ngalang karlamayakal!’ ");
INSERT INTO nys_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Yalga karro baal boorda-waangki, ‘Ngany yoowart kaaditj noonookany kidji ngany yoowart kaaditj alidjap, windjang noonooka yoowal-koorl. Wort-koorl, mandang noonooka wara-wara moorta!’ ");
INSERT INTO nys_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Noonooka boorda-wal-wal kidji bakkan noonookang ngorlaka nginda noonooka djinang Abraham, Isaac wer Jacob, kidji mandang Warda-Marridjinya, nyinyiny bokadja Boodjeral Boolanga-Yira Djelyibiny yalga noonooka bandak-kwarda-yan. ");
INSERT INTO nys_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Moorta boorda-yoowal-koorl koorambayel - boyalal wer marawar, djeralal wer kongal - kidji nyin ngarniny wer djoriny Boodjera Boolanga-Yira Djelyibiny. ");
INSERT INTO nys_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Karro moorta ngiyan yadok nidja kedela, baalap boorda koriyat, kidji moorta ngiyan koriyat nidja kedela, baalap boorda yadok.” ");
INSERT INTO nys_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yeyi alidja kedela, keny-keny Pharisee-ya yoowal-koorl Jesus kidji waangki baalany, “Noonook djarnyak wort-koorl nidjap, kidji koorl warmap narla Herod koordook dargango noonany.” ");
INSERT INTO nys_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus waangki baalapany, “Koorl kidji warranga alidja dwert, ‘Ngany djenaka-wara yekaniny moorta-bandak kidji minditj moorta barra-barriny, nidja kedela wer benang, kidji ngolonga mo kedela, ngany boorda-nganitj mandang nganyang yaka.’” ");
INSERT INTO nys_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yalga ngany djarnyak koorl nganyang djooroot, nidja kedela wer benang wer warning kedela. Baalap djarnyak dargang Warda-Marridjinya, yalga arda Jerusalem-bwora. ");
INSERT INTO nys_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem! Noonook dargang Warda-Marridjinya kidji noonook boya-kwarditj moorta ngiyan Boolanga-Yira waangki-koorl waangko noonak. Kalyakool, ngany kwadja-koordak koort-bamo noonang moorta, ngaangk-djert-mokiny dandjo-dandjo barranginy baalang naba baalang kaanba-yendan, yalga noonook yoowart don-oola nganyany. ");
INSERT INTO nys_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kidji ngarl noonang Maya-Maya-Kooranyi boorda-bilyar-yan. Ngany warranga noonany, noonook yoowart karro boorda-djinang nganyany koridjat kedela yoowal-koorl nginda noonook waangki, ‘Boolanga-Yira yanga-kwabba baalany ngiyan yoowal-koorl Birdiyarang kolal.’” ");
INSERT INTO nys_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Keny Kedela-Kooranyi, Jesus koorl ngarno Pharisee-yang maya-mayal. Baal warda-kadak kidji moorta kwadja-djinanginy Jesus. ");
INSERT INTO nys_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Keny mammarap yoowak-koorl alidja. Baalang maara wer maata minditj-wara. Baal yoowal-koorl Jesus. ");
INSERT INTO nys_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ngarl Jesus waangki-djinang Mammarapa-Warrinyang wer Pharisee-ya, “Natj ngalang Warriny waangki? Ngala kayar-barra-barra moort Kedela-Kooranyikal ka yoowart?” ");
INSERT INTO nys_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yalga baalap yoowart kayar-waangki keny noolong. Jesus barrang mammarap, barra-barra baalany, kidji warranga baalany wort-koorlo. ");
INSERT INTO nys_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Karro Jesus waangki, “Bayinya keny noonookang kadak nop ka booliyak, kidji keny djabalar karrab-bwora Kedela-Kooranyikal, noonooka kwitj morl-barrang baalany, doora Kedela-Kooranyikal, wa?” ");
INSERT INTO nys_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yalga baalap yoowart kayar-yalman-waangki baalany. ");
INSERT INTO nys_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesus djinang keny-keny moortany kwabba-djil nyinap barranginy, ngarl baal warranga baalapany mandang nidja bardip. ");
INSERT INTO nys_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nginda moort ngakaka noonany koorta-kadakinyak ngarnak wer djorak, noonook yoowart djarnyak barrang kwabba-djil nyinap. Kabin warma moorta, moorditj-ngatti nadjang noonany kwadja-ngakaka-yan, ");
INSERT INTO nys_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kidji noonang babin ngiyan noonany ngakaka, baal boorda yoowal-koorl kidji waangki noonany, ‘Yanga baalany noonang nyinap.’ Karro noonook boorda-karnya kidji noonook djarnyak koorl ngardak-djil nyinapal. ");
INSERT INTO nys_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yalga, nginda noonang babin ngakaka noonany, koorl ngarda-djil nyinapal, ngarl noonang babin boorda-yoowal-koorl kidji waangki noonany, ‘Koorl yira-ngatti, nganyang babin, kwabba-djil nyinapal.’ Karro mandang moorta ngiyan kwadja-ngakaka-yan, baalap boorda-djinang natj noonook moorditj noonang babinang miyalakal. ");
INSERT INTO nys_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Narla mandang moorta ngiyan koordook warma moorta djinango baalapany moorditj, baalap boorda yidja-yan ngarda-ngatti, kidji mandang moorta ngiyan ngarda-yidja baalapaal, baalap boorda-yidja-yan yira-ngatti.” ");
INSERT INTO nys_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Karro Jesus waangki Pharisee-ya, “Nginda noonook ngakaka moorta ngarno wer djoro noonyel, noonook yoowart djarnyak ngakaka kwabba babina wer ngooniya wer moorta boola boya-kadak narla baalap noonany boorda-ngakaka korl-koorl baalapang maya-mayakak, kidji noonook boorda-korl-barrang natj noonook yanga baalapany. ");
INSERT INTO nys_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nginda noonook kakatar noonang kedela ngarno wer djoro, ngakaka warma moorta - winyan moorta wer bogal-wara wer maat-wara wer miyala-birt, ");
INSERT INTO nys_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","kidji Boolanga-Yira boorda-yanga-kwabba noonany narla baalap yoowart kayar-yanga noonany natj noonook yanga baalapany. Boolanga-Yira boorda-korl-yanga noonany kedelal nginda kwabba moorta yiraba noyitj-yen.” ");
INSERT INTO nys_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Keny mammarap nyininy baalap-kardakor, baal dwangka nidja kidji baal waangki, “Baalap boorda-djoorab-djil! Nidja-nidja moorta boorda-nyiny ngarniny wer djoriny Boodjeral Boolanga-Yirang Djelyibiny!” ");
INSERT INTO nys_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus waangki baalany, “Mammarap kakatar baalang ngomon kedela ngarninyang wer djorinyang. Baal boola moorta ngakaka. ");
INSERT INTO nys_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kedela koorl kidji baal waangki-koorl baalang yakin warrango baalang babina, ‘Yoowal-koorl! Moodlooka kakatar-yan!’ ");
INSERT INTO nys_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yalga baalap mandang kwadjin waangkiny nadjil baalap yoowart kayar-koorl. Koriyat moort waangki yakin, ‘Ngany kwadja-bangal boodjer kidji ngany djarnyak koorl kidji djinang boodjer. Ngany koort-wara, yalga ngany yoowart kayar-koorl.’ ");
INSERT INTO nys_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Warning moort waangki, ‘Ngany kwadja-bangal maar-djen booliyaka kidji yeyi ngany nganyang djoorootal koorliny yako baalapany. Ngany koort-wara yalga ngany yoowart kayar-koorl.’ ");
INSERT INTO nys_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Warma moort waangki, ‘Ngany arda yeyi koort-kadak, kidji doora, ngany yoowart kayar-koorl.’ ");
INSERT INTO nys_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yakin korl-koorl karlap kidji baal waangki baalang birdiyar moodlooka.” “Birdiyar kaarang-kaarang-bini kidji warranga baalang yakin, ‘Kakoodjen! Koorl ngomon djoorootak wer nyit bidiya nidja karlamayang kidji boola moorta barrang, winyan moorta wer bogal-wara wer miyala-birt wer maat-wara.’ ");
INSERT INTO nys_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Yakin kayada korl-koorl kidji baal waangki, ‘Birdiyar, nganya kwadja-don natj noonook waangki. Yalga noonang maya-maya yoowart moorart.’ ");
INSERT INTO nys_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ngarl birdiyar warranga yakin, ‘Koorl karlamaya-bandak djoorootak boodjeral wer nyit-djil bidiya kidji warranga moortaman baalap djarnyak yoowal-koorl ngarno wer djoro, ngarl nganyang maya-maya boorda moorart.’ ");
INSERT INTO nys_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngany noonookang mandang warranga, alidja-alidja moorta ngiyan ngany kwadja ngakaka, yoowart keny baalapang boorda-bakkanan nganyang mereny!’ ” ");
INSERT INTO nys_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Keny kedela, boola moorta kwadja dandjo-dandjo-yaniny Jesus-yel. Baal korang kidji waangki baalapany, ");
INSERT INTO nys_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Moort nganyany yoowal-koorliny, baal yoowart doora nganyang ngooldjar-kambarn-abini, arda bayinya baal woonya-ngatti nganyany nadjang baalang maaman wer ngaangk, baalang koort-maat wer koorlangka, baalang ngooniya wer djooka, wer kardjir woonya-ngatti nganyany nadjang baalaal. ");
INSERT INTO nys_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Bayinya moort yoowart boorda-kanga baalroo boorn-yambo kidji kambarn nganyany, baal yoowart kayar nganyang ngooldjar-kambarn-abini. ");
INSERT INTO nys_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bayinya keny noonookang kaaditjiny warno ngomom-djil woorri maya-maya, koriyat baal boorda-nyiny kidji kaaditj ngalan boya baal boorda-nganala, kidji djinang bayinya baal kadak kinyak boya warno maya-maya. ");
INSERT INTO nys_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bayinya baal yoowart kadak kinyak boya, kidji baal kwadjin maya-maya warniny, yalga ngolonga baal djarnyak nganitj, moortaman djinanginy naatj edjena, baalap boorda-yidjan baalany. ");
INSERT INTO nys_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Baalap boorda-waangki. ‘Nidja mammarap malyak maya-maya warniny yalga baal yoowart kayar-don baalany!’ ");
INSERT INTO nys_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Djelyib keny kadak 10,000 mammarapa. Bayinya nidja djelyib bandak-koorl bakadjiny, yalga warma djelyib yoowal-koorl kidji alidja delyib kadak 20,000 mammarapa, baal boorda-nyin koriyat kidji kaaditj bayinya baal kadak kinyak mardayin bakadjo alidja warma djelyib. ");
INSERT INTO nys_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bayinya baal yoowart kadak kinyak mardayin, nginda warma djelyib nyiny kadjali, baal boorda-waangki-koorl ngakaka-marridjinya kalyaro warma djelyib kidji ngakaka baalany bayinya baal boorda waangki nakalang.” ");
INSERT INTO nys_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ngarl karro Jesus waangki, “Nidja war-djin, yoowart keny noonookang kayar nganyang ngooldjar-kambarn-abini, arda bayinya baal ngwidam kaaditj natj baal djarnyak wort-yanga moodlooka, moodlooka baal kadak.” ");
INSERT INTO nys_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Djallam kwabba, yalga bayinya djallam yoowart bakkanan djallam-mokiny, noonook yoowart kayar warn nidja djallam kwabba-biny karro. ");
INSERT INTO nys_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nidja djallam yoowart kwabba malatjo mereny, kidji yoowart kwabba boodjerang. Noonook djarnyak wort-kwarda nidja djallam. Ni karro, bayinya noonooka dwangka kadak!” ");
INSERT INTO nys_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Keny kedela boola mammarapa boya-barranginy, wer warma moorta ngiyan kwadja wort-korang-yan, baalap yoowal-koorl dwangko Jesus waangkiny, ");
INSERT INTO nys_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pharisee-ya wer Mammarapa-Warrinyang, baalap malyak Jesus-any wara-waangkiny, “Nidja mammarap, baal yanganan wara-doniny moorta. Baal kardjir dandjo-dandjo ngarn baalapyel!” ");
INSERT INTO nys_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ngarl Jesus warranga baalapany nidja bardip: ");
INSERT INTO nys_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bayinya keny noonookang kadak 100 kookendjerira kidji noonook anbangbat keny baalapang, natj noonook boorda-don? Mammarap boorda-wandja warma 99 kookendjerira kidji baal boorda koorl-djinang nidja kookendjeri, keny anbangbat-yan, kidji baal yoowart boorda nganitj, arda nginda baal djinbarranga baalany. ");
INSERT INTO nys_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nginda baal djinbarranga nidja kookendjeri, baal djoorab-djil, baal yidja baalang kookendjeri mangakal kidji korl-koorl karlap. ");
INSERT INTO nys_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Karro baal mira baalang babina wer warma moorta baalang karlamaya, kidji baal waangki baalapany, ‘Ngany djoorab-djil narla ngany djinbarranga nganyang kookendjeri, keny angbangbat-yan. Ngala djarnyak djoorab dandjo-dandjo. Woola-koola!’ ");
INSERT INTO nys_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ngany warranga noonookany, war-djin, Boolanga-Yirakang Boodjer boorda-djoorab-djoorab narla keny moort wort-korang baalang wara-doniny, djeroob-ngatti nadjang 99 kwabba moortakang ngiyan yoowart nganala wort-korango.” ");
INSERT INTO nys_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Yeyi bayinya keny yok kadak maar-djen birrigon boyara kidji baal anbangbat keny baalapang, natj baal boorda-don? Baal dookoon karla-maat, baal barnang baalang maya-maya kidji baal koorl-djinang mandang bangka maya-mayang kidji baal arda nganitj nginda baal djinbarranga baalang boya. ");
INSERT INTO nys_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nginda baal djinbarranga boya, baal mira baalang babina, wer warma moorta baalang karlamayang, kidji baal waangki baalapany, ‘Ngany djoorab-djil narla ngany djinbarranga nganyang boya, keny angbangbat-yan. Ngala djarnyak djeroob dandjo-dandjo. Woola-koola!’ ");
INSERT INTO nys_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ngany waangki noonookany, war-djin, Boolanga-Yirakang djin-djina-kwabba mandang woola nginda keny moort korl-korang baalang wara-doniny.” ");
INSERT INTO nys_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Karro Jesus waangki, “Keny mammarap kadak koodjal nopa. ");
INSERT INTO nys_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yinang nop waangki baalany, ‘Maaman, yanga nganyang yeyi nganyang walak banarakang!’ Ngarl baalang maaman walak-yanga baalang banarak baalang koodjal nopa kardakor. ");
INSERT INTO nys_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ngolonga mo kedelaka, yinang nop bangal baalang walak, barrang boya kidji wandja karlap. Baal koorl kadjali boodjer. Bokadja baal wort-kwarda baalang boya, wara karriny. ");
INSERT INTO nys_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Baal banitja mandang boya. Karro yoowart kepa djabalar boodjeral kidji boodjer yoowart maladja mereny. Baal kayan-kadak, boya-birt wer mereny-birt. ");
INSERT INTO nys_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ngarl baal koorl kidji yaka mammarapang alidja boodjerang. Baal waangki-koorl baalany baalang boodjerak karrodjino baalang dwordoka. ");
INSERT INTO nys_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Baal koordook ngarno wara mereny natj baal yanga dwordoka, yalga yoowart moort yanga baalany mereny ngarno. ");
INSERT INTO nys_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ngarl karro baal malyak darkal kaaditj. ‘Ngany tatan. Nganyang maaman yanga boya baalang mandang yakinarak. Baalap kadak boola-ngatti mereny nadjang baalap kayar-ngarn, kidji ngany nyiny nidjap koboorl-wirt. ");
INSERT INTO nys_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngany boorda-yiraba kidji ngany boorda korl-koorl nganyang maaman kidji waangki, “Maaman, ngany kwadja-wara-don Boolanga-Yira booram wer noonany booram. ");
INSERT INTO nys_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngany kwadja-wara-djil. Noonook yoowart djarnyak kol nganyany noonang nop. Yalga noonook djarnyak yidja nganyany noonang yakina-mokiny kidji yanga nganyany boya yakinyang.” ’ ");
INSERT INTO nys_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Ngarl baal yiraba kidji koorl karlap baalang maamanak. Nginda baal kwadja-kadjali, baalang maaman djinang baalany. Baalang maamanang koort moorart nomaringang, kidji baal yakoorl, baal barrang baalang nop kidji baal koort-bama baalany kidji nindjan baalany. ");
INSERT INTO nys_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Maaman,’ nop waangki, ‘Ngany kwadja-wara-don, Boolanga-Yira booram, kidji noonook booram. Ngany kwadja-wara-djil kidji noonook yoowart djarnyak kol nganyany noonang nop.’ ");
INSERT INTO nys_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yalga baalang maaman mira yakina. ‘Kert-kert!’ baal waangki. ‘Barranga kwabba-dil bwoka kidji wolang nganyang nop. Yidja dordong baalang maaral kidji yidja djena-bwoka baalang djenal. ");
INSERT INTO nys_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Karro koorl kidji barrang kwabba-djil yinang booliyak kidji dargang baalany. Ngala boorda-ngarn wer djora djoorab-djoorabiny. Woola-koola! ");
INSERT INTO nys_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Narla nidja nganyang nop kwadja-noyitj, yalga yeyi baal wining; baal kwadga-anbangbat-yan yalga yeyi baal djinbarranga-yan!’ Baalap djoorab-djil kidji baalap malyak ngarniny ka djoriny. ");
INSERT INTO nys_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Korram mandang nidja-nidja noolonga kwadja-edjeniny, koriyat nop bandak yakiny. Baal korl-koorl. Nginda baal boordak-koorl maya-maya, baal dwangka yedi-waangkiny wer koboriny, ");
INSERT INTO nys_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ngarl baal mira keny yakin kidji waangki-djinang baalany, ‘Natj edjeniny?’ ");
INSERT INTO nys_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Noonang ngooni kwadja-korl-koorl karlap,’ yakin waangki, ‘kidji noonang maaman dargang kwabba-djil booliyak narla baalang nop kwadja korl-koorl noyitj-yen.’ ");
INSERT INTO nys_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ngooni koriyat kaarang-kaarang-biny kidji baal yoowart bwora-koorl maya-maya. Ngarl baalang maaman bandak-koorl kidji baal koort-koort baalany bwora-koorlo maya-maya. ");
INSERT INTO nys_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Yalga baal yalman-waangki baalang maaman, ‘Miyalitj, mandang nidja-nidja biroka ngany kwadja-yaka noonookang, keny noonang yakin-mokiny, kidji ngany kalyakool don moodlooka noonook koordook nganyany dono. Natj noonook kwadja-yanga nganyany? Yoowart keny yinang kidikot ngarl ngany wer nganyang babina kayar ngarn wer djora! ");
INSERT INTO nys_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yalga nidja noonang nop, baal wort-kwarda mandang noonang boya wara-wara yokal kidji yeyi baal yoowal-koorl karlap, kidji noonook dargang kwabba-djil yinang booliyak baalang!’ ");
INSERT INTO nys_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“ ‘Nganyang nop,’ baalang maaman yalman-waangki, ‘Noonook kalykool ngany-boordak, kidji moodloooka ngany kadak, noonook kayar-kadak mandang. ");
INSERT INTO nys_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yalga ngala djarnyak ngarn wer djora wer djoorab-djoorab narla noonang ngooni kwadja-noyitj yalga yeyi baal wining; baal kwadja-anbangbat-yan yalga yeyi baal djinbarranga-yan.’ ” ");
INSERT INTO nys_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus waangki baalang ngooldjara-kambarn, “Keny birdiyar boola boya-kadak kidji baalang yakin karrodjin baalang banarak. Moorta warranga birdiyar baalang yakin wara-banitja baalang banarak ");
INSERT INTO nys_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ngarl birdiyar mira baalany bwora-koorlo kidji baal waangki, ‘Natj nidja ngany dwangka noonang? Boordak moodlooka nganyang banarakang ngarl ngany kayar-djinang natj kwadja-edjeniny narla yeyi noonook yoowart kayar-yaka nganyang.’ ");
INSERT INTO nys_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yakin waangki baalaal, ‘Birdiyar boorda wort-waangki-koorl nganyany. Ngany yoowart boorda-kadak keny yakinyap. Natj ngany boorda-don? Ngany yoowart mardayin kinyak biyano karraba, kidji ngany karnya bayinya ngany djarnyak koort-koort. ");
INSERT INTO nys_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yeyi ngany kaaditji natj ngany boorda-don! Yeyi nginda nganyang yakiny nganitj, ngany boorda-kadak babina. Baalap boorda-ngakaka nganyany baalapang karlap-bwora.’ ");
INSERT INTO nys_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ngarl baal mira mandang moorta baalak. Nidja-nidja moorta djarnyak wort-yanga boya ka barnak birdiyarak. Baal waangki-djinang koriyat moort, ‘Ngalan noonook djarnyak yanga birdiyar?’ ");
INSERT INTO nys_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘100 bwokoota boyin koorayinang,’ baal waangki. Yakin warranga baalany, ‘Nidja noonang boordakiny. Nyiny kidji boordak 50.’ ");
INSERT INTO nys_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Karro baal waangki-djinang warning moort, ‘Noonook kardjir – ngalan noonook djarnyak yanga birdiyar?’ ‘1000 bwokoota kwolakang,’ baal waangki. Yakin warranga baalany, ‘Nidja noonang boordakiny. Boordak 800.’ ");
INSERT INTO nys_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Karro birdiyar kwabba-waangki baalang yakin narla baal kert-kert kaaditji kidji baal kakatar nadjang boorda-edjena. Narla moorta nidja Boodjerang, baalap kaaditj noolonga nidja Boodjerang kidji baalap kaaditj war banitjo nidja-nidja noolonga. Nidja Boodjerakal, baalap dwangka-boola-ngatti nadjang moorta binariyang.” ");
INSERT INTO nys_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Karro Jesus waangki, “Kidji ngarl ngany warranga noonookany: banitja noonookang boya ngarl moorta noonookang babin-abiny, moorta nidja Boodjerang, ngarl nginda noonooka boya-birt, noonooka kayar-bwora-koorl karlap ngatj nyiny kalyakool. ");
INSERT INTO nys_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Moort koort-karni nyit noolonga banitjiny, baal boorda-koort-karni noolonga banitjiny. ");
INSERT INTO nys_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ngarl bayinya noonooka yoowart koort-karni boyal nidja Boodjerang, yarn noonooka kayar-koort-karni karniyal boyal? ");
INSERT INTO nys_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kidji bayinya noonooka yoowart koort-karni noolonga warma moortakang, karro ngiyan boorda-yanga noonookany natj noonooka doora kadak? ");
INSERT INTO nys_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Yoowart yakin kayar-yaka koodjal birdiyarayel. Baal boorda-woonya keny birdiyar kidji yoowart woonya warma birdiyar; baal boorda koort-karni keny birdiyarak kidji yoowart koort-karni warma birdiyarak. Noonook yoowart kayar-yaka koodjal birdiyaral, Boolanga-Yira wer boya.” ");
INSERT INTO nys_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisee-ya dwangka nidja-nidja noolonga, ngarl baalap yidjan Jesus, narla baalap woonya boya. ");
INSERT INTO nys_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesus waangki baalapany, “Noonooka koordook yidjo noonookaal kwabba warma moortakang miyalakal, yalga Boolanga-Yira kaaditj noonookang koorta. Boola noolonga moorditj moortakang miyalakal, yalga nidja-nidja noolonga kayan Boolanga-Yirakang miyalakal. ");
INSERT INTO nys_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses-ang Warriny wer Warda-Marridjinyakang boordakiny kwidjang kwadja-yakiny kidji yaka John-Kakaloorniyang kedelak. Ngolonga alidja kedela, Warda-Kwabba Boodjerang Boolanga-Yirang Djelyibiny kwadja warranga kidji boola moorta bwora-koornoo baalapang djooroot. ");
INSERT INTO nys_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yalga Boodjer wer Worl boorda-wort-koorl koridjat keny nyit-nyit bangka Moses-ang Warrinyang wort-koorl. ");
INSERT INTO nys_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Bayinya keny mammarap wort-waangki-koorl baalang koort-maat kidji barrang warma yok, nidja mammarap wara-doniny; kidji mammarap ngiyan koorta-barrang alidja yok, baal kardjir wara-doniny.” ");
INSERT INTO nys_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Keny mammarap boola boya-kadak. Baal wandanga kwabbalitj bwoka yennar kedelara, kidji baal ngarn wer djorin moodlooka baal koordook. ");
INSERT INTO nys_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Lazarus, winyan mammarap, kardjir wining alidja karlamayakal, kalyakool birrba-birrba. Yennar kedelara, moorta barrang Lazarus bidak mammarapang boola boya-kadak. ");
INSERT INTO nys_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lazarus koordook ngarno koolyangarra merenyang natj kwarda ngarnapal mammarapang boola boya-kadak. Dwerta kalyakool yoowal-koorl kidji djalinyan baalang birrba. ");
INSERT INTO nys_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lazarus wanni kidji djin-djin-kwabba barranga baalany nyinyo Abraham-yel, ngarniny wer djoriny Boolanga-Yirakang Boodjerak. Mammarap boola boya-kadak, baal wanni kidji baalap dambarritj baalany. ");
INSERT INTO nys_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Baal koorl Djinbaminyap. Bokadja, baal kadak bakkan-djil. Baal yira-miyalitj kidji boyang, baal djinang Abraham wer Lazarus baalany boongal. ");
INSERT INTO nys_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ngarl baal mira, ‘Maaman Abraham! Nomaring nganyany! Waangki-koorl Lazarus yidjak baalang maar kepakal kidji kardjal nganyang djaalang, narla nganya kadak bakkan-djil nidjap bwora!’ ");
INSERT INTO nys_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Yalga Abraham waangki, ‘Barrang-dwangka, nganyang nop, nginda noonook kwadja-wining, noonook kadak mandang kwabba noolonga, yalga Lazarus, baal kadak mandang wara noolonga. Yalga yeyi baal djoorab nyiny nidjapal, korram noonook kadak bakkan. ");
INSERT INTO nys_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yalga yoowart arda alidja, moordak karrab nyiny ngalany kardakor, ngarl moorta koordookiny wandjak nidjap koorlo noonany, baalap yoowart kayar-koorl; kidji yoowart moorta kayar-wandja alidjap kidji yoowal-koolo ngalak.’ ");
INSERT INTO nys_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ngarl mammarap boola boya-kadak, baal waangki, ‘Karro ngany koort-koort noonany, Maaman Abraham, waangki-koorl Lazarus nganyang maamanang maya-mayak. ");
INSERT INTO nys_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Bokadja, ngany kadak maar ngooniya. Koorl-oola Lazarus kidji warranga baalapany ngarl baalap yoowart kardjir yoowal-koorl nidjap bakkanang.’ ");
INSERT INTO nys_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham waangki, ‘Noonang ngooniya kadak Moses wer Warda Marridjinya warrango baalapany. Noonang ngooniya doora-dwangka moodlooka baalap waangki.’ ");
INSERT INTO nys_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mammarap boola boya-kadak, baal waangki, ‘Baalap yoowart kinyak, Maaman Abraham! Yalga bayinya keny mammarap yiraba noyitj-yen kidji koorl baalapany, karro baalap boorda-wort-korang baalapang wara-doniny.’ ");
INSERT INTO nys_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Yalga Abraham waangki, ‘Bayinya baalap yoowart dwangka Moses-any wer Warda-Marridjinya, karro baalap yoowart boorda-dwangka, yoowart bayinya keny moort korl-koorl noyitj-yen.’ ” ");
INSERT INTO nys_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus waangki baalang ngooldjara-kambarnany, “Noolonga natj bilang moortakany wara-dono djarnyak edjena, yalga darnayan-djil moortang barranginy warma moorta wara-dono! ");
INSERT INTO nys_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kwabba-ngatti baalang, bayinya moorta yadarn keny ngomon boya baalang wordak kidji baalap kwarda baalany wardarn-bwora! Wara boola-ngatti baalang bayinya baal warn keny nidja-nidjang koorlangka wara-don! ");
INSERT INTO nys_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ngarl karro, miyalitj natj noonooka don! “Bayinya noonang ngooni wara-doniny, djaat baal; kidji bayinya baal korl-koorl baalang wara-doniny, noonook djarnyak nyinya-nyinya baalany. ");
INSERT INTO nys_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bayinya keny kedela baal don maar-koodjal wara noolonga noonak, kidji bayinya baal yoowal-koorl noonany ngolonga yennar keny kidji waangki, ‘Ngany wort-korang nganyang wara-doniny,’ noonook djarnyak nyinya-nyinya baalany.” ");
INSERT INTO nys_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesus-ang ngooldjara waangki baalany, “Malatj ngalang koort-karni!” ");
INSERT INTO nys_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesus waangki, “Bayinya noonooka kadak koort-karni nyit-nyit kwolak-djin, noonook kayar-warranga nidja boorn, ‘Marlbarrang-yidja noonaal djinaral kidji niran noonaal wardarn-bwora.’ Kidji boorn boorda-don natj noonook waangki.” ");
INSERT INTO nys_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Bayinya keny noonookang kadak yakin kidji baal bandak biyaniny ka kabin karrodjin kookendjerira. Nginda baal bwora-koorl, noonook warranga baalany kakoodjeno maya-maya-bwora kidji ngarn baalang mereny, wa? ");
INSERT INTO nys_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yoowart! Noonook waangki baalany, ‘Kakatar nganyang mereny, karro wolang noonang kwabba bwoka kidji yoowal-yaaka kidji yanga nganyang mereny. Karro noonook kayar-ngarn noonang mereny.’ ");
INSERT INTO nys_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Noonook yoowart yanganan yakin doninyang natj noonook warranga baalany dono, wa? ");
INSERT INTO nys_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","War-djin, nidja boorda-edjena noonookak. Nginda noonooka kwadja-don moodlooka, mandang noolonga noonooka kwadja warranga-yan dono, noonooka doora waangki, ‘Ngala arda yakina; ngala arda don alidja-alidja noolonga natj ngala djarnyak don.’ ” ");
INSERT INTO nys_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nginda Jesus Jerusalem koorliny, baal yana djoorootal kardakor Samaria wer Galilee. ");
INSERT INTO nys_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jesus karlamaya kwadja-koorliny. Maar-djen mammarapa yoowal-koorl baalany. Baalap kadak wara morba menditj kidji boyang-yaaka ");
INSERT INTO nys_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kidji baalap mira, “Jesus! Birdiyar! Nomaring ngalany!” ");
INSERT INTO nys_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus djinang baalapany kidji baal waangki, “Koorl yakina-kooranyikak ngarl baal kayar djinang noonookany.” Djoorootal, baalap kwadja-barra-barra-yan. ");
INSERT INTO nys_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nginda keny baalapang djinang baal kwadja-kwabba-bini, baal wort-koorl, Boolanga-Yira moorditj yangananiny. ");
INSERT INTO nys_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Baal kwarda boodjerak Jesus-ang djena-boordak kidji yanganan baalany. Baal Samaria-karlap. ");
INSERT INTO nys_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesus waangki, “Maar-djen mammarapa kwadja-barra-barra-yan; windji warma maar-koodjal-koodjal mammarapa? ");
INSERT INTO nys_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nadjil arda nidja keny mokang korl-koorl yangananak Boolanga-Yirany?” ");
INSERT INTO nys_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kidji Jesus waangki baalany, “Yiraba kidji koorl! Noonang koort-karni kwadja-barra-barra-yan noonany.” ");
INSERT INTO nys_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mo Pharisee-ya waangki-djinang Jesus nginda Boodjer Boolanga-Yira Djelyibiny boorda-yoowal-koorl. Jesus waangki, “Boodjer Boolanga-Yira Djelyibiny yoowart yoowal-koorl waral natj miyala kayar-djinang. ");
INSERT INTO nys_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yoowart moort kayar-waangki, ‘Miyalitj! Nidja baal!’ ka ‘Alidja baal!’ narla Boodjer Boolanga-Yira Djelyibiny wining noonooka-bwora.” ");
INSERT INTO nys_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Karro Jesus waangki ngooldjara, “Kedela boorda-yoowal-koorl nginda noonooka boorda-koordook djinango kedela Mammarapang Nopang yalga noonooka yoowart boorda-djinang baalany. ");
INSERT INTO nys_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Moorta boorda-warranga noonooka, ‘Miyalitj alidja’ ka ‘Miyalitj nidja!’ Yalga yoowart bandak-koorl kidji korl-djinang baalany. ");
INSERT INTO nys_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Alidja kedela, Mammarapang Nop boorda-koorl babanginy-mokiny, worl-yambo boordanginy, ngarrak-ngarrak bandjatiny. ");
INSERT INTO nys_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yalga koryat baal djarnyak bakkan-djil kidji moorta nidja kedelakang boorda wort-korang baalany. ");
INSERT INTO nys_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kedelara Mammarapang Nopang boorda-koorl Noah-kang kedelara-mokiny. ");
INSERT INTO nys_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Moorta kalyakool ngarn wer djor, kidji mammarapa wer yoka kalyakool koorta-barrang, kedelakak nginda Noah bwora-koorl wandaberi kidji boola kepa yoowal-koorl kidji mordakan mandang baalapany. ");
INSERT INTO nys_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Alidja kedela boorda-koorl Lot-ang kedela-mokiny. Moorta kalyakool ngarn wer djora. Baalap bangal wer niran wer warn maya-mayara. ");
INSERT INTO nys_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kedelakal Lot wort-koorl Sodom, karla wer narriny dalba djabalar worlyen kidji dargang mandang baalapany. ");
INSERT INTO nys_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kedela nginda moorta djinang Mammarapang Nop, baalang kedela boorda-koorl alidja-mokiny. ");
INSERT INTO nys_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Alidja kedela, keny mammarap nyinyiny yirakaatal baalang maya-maya, baal yoowart djarnyak ngarda-koorl maya-maya-bwora barrangak baalang noolonga. Kardjir, mammarap yaakiny baalang maya-maya-bandak, baal yoowart djarnyak korl-koorl maya-maya-bwora. ");
INSERT INTO nys_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Barrang-dwangka Lot-ang koort-maat! ");
INSERT INTO nys_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Moort koordookiny kanyo baalang ngandabat, baal boorda-anbangbat baalany. Moort anbangbatiny baalang ngandabat, baal boorda-kanya baalany. ");
INSERT INTO nys_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ngany warranga noonookany, alidja kadik, koodjal moorta boorda-bidjiny keny maya-ngwoorndinyal; keny moort boorda-wort-barrang-yan kidji warma moort boorda-nyiny.” ");
INSERT INTO nys_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Koodjal yoka boorda booma-boyakiny kwolaka dandjo-dandjo. Keny yok boorda-wort-barrang-yan kidji warma moort boorda-nyiny. ");
INSERT INTO nys_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Koodjal mammarapa boorda-nyiny mandakal. Keny mammarap boorda-wort-barrang-yan kidji warma mammarap boorda-nyiny. ");
INSERT INTO nys_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesus-ang ngooldjara waangki-djinang baalany, “Windji, Birdiyar?” Jesus waangki, “Windji noyitj moorta ngwoornda, woldjara boorda-koorl dandjo-dandjo.” ");
INSERT INTO nys_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Karro Jesus waangki baalang ngooldjara nidja bardip, karni-waangk baalapany war baalap kalyakool doora waangki Boolanga-Yira, kidji yoowart wayarniny narla baalapang ngandabat. ");
INSERT INTO nys_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Keny birdiyar djonany-karinyang, baal kwadja-wining karlamayal. Baal yoowart wayarn Boolanga-Yira wer baal yoowart wayarn moorta. ");
INSERT INTO nys_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Keny yenang kardjir kwadja-wining alidjapal. Baal kalyakool koorl birdiyar. Baal koort-koort birdiyarany maara-yango baalany barrangak natj baal doora barrang, waangkiny, ‘Noonook maar-yanga nganyany bakadjo nidja wara mammarap!’ ");
INSERT INTO nys_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yennar kedela, birdiyar yoowart kayar-don noolong, yalga baal waangki baalaal, ‘Karnayal, ngany yoowart wayarn Boolanga-Yira ka wayarn moorta, ");
INSERT INTO nys_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","yalga narla nidja yenang kalyakool karradjal-djin, ngany boorda-maar-yanga baalany barrango moodlooka, mandang noolonga baal koordook. ‘Bayinya ngany yoowart don nidja, baal boorda-yoowal-koorl yennar kedela kidji ngany boorda-bidibaba-biny narla baalang.’ ” ");
INSERT INTO nys_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kidji Jesus waangki, “Noonooka dwangka wara birdiyarang waangka! ");
INSERT INTO nys_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yeyi, noonook kaaditj Boolanga-Yira yoowart boorda-djonany-karinya baalang moorta kidji kwabba don baalapak ngiyan mira baalany kedela wer kadik maar-yangak baalapany, wa? Noonooka waangkiny Boolanga-Yira boorda-dabakarn maar-yanginy baalapany, wa? ");
INSERT INTO nys_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngany warranga noonookany, Boolanga-Yira boorda-donany-karinya baalang moorta kwabba waral kidji don nidja kert-kert. Yalga nginda Mammarapang Nop yoowal-koorl, baal boorda-djinbarranga koort-karni Boodjeral, wa?” ");
INSERT INTO nys_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus kardjir warranga nidja bardip moortakak ngiyan yira-kaaditj baalapaal kidji wambadin narla baalap kwabba-ngatti nadjang warma moorta. ");
INSERT INTO nys_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Keny kedela, koodjal mammarapa yira-koorl Maya-maya-Kooranyikak waangko Boolanga-Yira, keny Pharisee wer keny mammarap boya-barranginy. ");
INSERT INTO nys_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nidja Pharisee dombart yaaka kidji waangki, ‘Boolanga Yira, ngany yanganan noonany narla ngany yoowart ngabatj, ngany yoowart koolyoomitj wer ngany yoowart barrang warma yoka. Ngany yanganan noonookany narla ngany yoowart alidja moort-mokiny, moort boya-barranginy bokadja. ");
INSERT INTO nys_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yennar maar-koodjal kedela, ngany yoowart ngarn kenyang kedela, kidji ngany yanga noonookany kwabba walak mandang nganyang boya.’ ");
INSERT INTO nys_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Yalga mammarap boya-barranginy yaaka boyang kidji yoowart yiraba baalang moolyimarri Boolanga Yirakang Boodjerak, yalga bama baalang ngoornt kidji waangki, ‘Boolanga-Yira, nomaring nganyany, narla ngany nyiny wara-wara mammarap.’ ");
INSERT INTO nys_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ngany warranga noonookany,” Jesus waangki, “nginda koodjal mammarapa korl-koorl karlap, nidja mammarap boya-barranginy kwabba nyiny Boolanga-Yirakang miyalakal kidji yoowart nidja Pharisee. Moortaman baalapaal yira-yidjiny, baalap boorda-ngarda-yidja-yan, kidji moortaman baalapaal ngarda-yidjiny, baalap boorda-yira-yidja-yan.” ");
INSERT INTO nys_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Moorta kanga baalapang koorlangka Jesus-ak maar-barrang baalapany. Jesus-ang ngooldjara djinang baalapany kidji djaat baalapany narla baalap don alidja, ");
INSERT INTO nys_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","yalga Jesus mira koorlangka baalak kidji waangki, “Yoowal-koorl-oola koorlangkany nganyak kidji yoowart nganitj baalapany, narla moorta nidja-nidja koorlangka-mokiny, baalap kadak Boodjer Boolanga-Yira Djelyibiny. ");
INSERT INTO nys_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Barrang-dwangka! Moort ngiyan yoowart barrang Boodjer Boolanga-Yira Djelyibiny koorlang-mokiny, baal yoowart boorda-bwora-koorl.” ");
INSERT INTO nys_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Keny mammarap warda kadak Judea-karlap, baal waangki-djinang Jesus, “Moorditj Birdiyar, natj ngany djarnyak don barrango kalyakool ngandabat?” ");
INSERT INTO nys_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus waangki-djinang baalany, “Nadjil noonook waangki ngany ‘moorditj’? Yoowart moort nyiny moorditj, arda Boolanga-Yira. ");
INSERT INTO nys_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Noonook kaaditj noonang Warriny. Yoowart mooyang, yoowart dargang, yoowart ngakalya, yoowart koolyoomitj warma moortakang; dwangka-don noonang maaman wer ngaangk.” ");
INSERT INTO nys_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mammarap yalman-waangki, “Ngolonga ngany kwadja-yinang, ngany kalyakool kwadja-don moodlooka Warriny waangki.” ");
INSERT INTO nys_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nginda baal dwangka nidja, Jesus waangki baalany, “Keny warma noolong noonook djarnyak don. Bangal-yanga mandang noonang banaraka kidji wort-yanga moodlooka winyan moortak. Kidji noonook boorda-kadak boola banaraka Boolanga-Yirang Boodjeral; karro yoowal-koorl, kidji kambarn nganyany.” ");
INSERT INTO nys_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yalga nidja mammarap, nginda baal dwangka alidja, baal koort-wara-wara-biny, narla baal kadak boola banaraka. ");
INSERT INTO nys_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus djinang mammarap koort-wara kidji Jesus waangki, “Djadam-djil mammarpang boola boya-kadak bwora-koorlo Boodjer Boolanga-Yira Djelyibiny! ");
INSERT INTO nys_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bayinya mammarap boola boya-kadak, bwora-koorliny Boodjer Boolanga-Yira Djelyibiny djadam-ngatti baalang nadjang yongkang wokart-koorliny djit djangang.” ");
INSERT INTO nys_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Moortaman Jesus-any dwangkiny, baalap waangki-djinang, “Karro ngiyan kayar-barrang baalang ngandabat?” ");
INSERT INTO nys_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesus yalman-waangki, “Noolong moorta yoowart kayar-don, Boolanga-Yira kayar-don!” ");
INSERT INTO nys_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Karro Peter waangki, “Djinang! Ngala kwadja-wandja ngalang karlap kambarno noonookany.” ");
INSERT INTO nys_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Kaya,” Jesus waangki baalapany, “kidji karnayal, ngany warranga noonookany, bayinya moort wandja baalang karlap ka baalang koort-maat ka ngooniya ka maaman ka ngaangk ka koorlangka, narla Boodjer Boolanga-Yira Djeleyibiny, ");
INSERT INTO nys_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","baal boorda-barrang boola-ngatti nidja-nidja kedelakal, kidji ngolonga, baal boorda-barrang kalyakool ngandabat.” ");
INSERT INTO nys_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus kordja-barrang baalang maar-djen-koodjal ngooljdara kidji waangki baalapany, “Ni! Ngala Jerusalem kooliny. Bokadja, moodlooka boorda-edjena natj Warda-Marridjinya kwadja-boordak Mammarapang Nopang. ");
INSERT INTO nys_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Moorta boorda-yidja baalany mokangang maaral. Baalap boorda-yidjan baalany kidji baalap boorda wara-waangki baalany kidji narridja-kwarda baalal. ");
INSERT INTO nys_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Baalap boorda-bama baalany kidji dargang baalany. Yalga ngolanga mo kedela, baal boorda-yiraba ngandabatak.” ");
INSERT INTO nys_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yalga ngooldjara yoowart kaaditji nidja-nidja noolonga; karnany warrinyang kwadja-ballaridja-yan baalapang, kidji baalap yoowart kaaditji natj Jesus kwadja-waangkiny. ");
INSERT INTO nys_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus kwadja-koorliny Jericho-ngat. Mammarap miyala-birt kwadja-nyinyiny, djooroot boordak koort-koortiny. ");
INSERT INTO nys_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Baal dwangka boola moorta, boordak-djendjereniny, ngarl baal waangki-djinang, “Natj edjeniny?” ");
INSERT INTO nys_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Baalap waangki baalany, “Jesus Nazareth-karlap yoowal-koorliny.” ");
INSERT INTO nys_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Baal mira, “Jesus! David-ang Nop! Nomaring nganyany!” ");
INSERT INTO nys_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Moorta Jesus-booram, baalap djaat baalany kidji waangki, “Dja-dediny.” Yalga baal waangka-djan, “David-ang Nop! Nomaring ngany!” ");
INSERT INTO nys_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ngarl Jesus nganitj kidji ngakaka moortany barrango mammarap miyala-birt baalak. ");
INSERT INTO nys_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Natj noonook koodook? Natj ngany kayar don noonang?” “Birdiyar,” baal waangki, “Ngany koordook karro-djinango.” ");
INSERT INTO nys_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus waangki baalany, “Karro djinang! Noonang koort-karni kwadja-barra-barra noonany.” ");
INSERT INTO nys_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Winidjinbar, baal kayar-djinang, kidji baal kambarn Jesus, Boolanga-Yirany yangananiny. Moortaman miyalitjiny, baalap kardjir yanganan Boolanga-Yira. ");
INSERT INTO nys_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus koorl Jericho, karlamaya-wokart djendjeriny. Birdiyar mammarapang boya-barranginy wining Jericho-kal. ");
INSERT INTO nys_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Baalang kol Zacchaeus, kidji baal boola boya-kadak. ");
INSERT INTO nys_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Baal koordook djinango Jesus, yalga baal korad mammarap kidji baal yoowart djinang Jesus narla moortaman. ");
INSERT INTO nys_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jesus kwadja-koorliny djoorootal ngarl baal yakoorl moorta-yinadjat kidji balingar boorn djinango Jesus. ");
INSERT INTO nys_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nginda Jesus yoowal-koorl, baal yira-djinang kidji waangki Zacchaeus, “Kakoodjen ngarda, Zacchaeus, narla ngany djarnyak naan-yaaka noonang maya-maya-bwora nidja kedela.” ");
INSERT INTO nys_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacchaeus kakoodjen ngarda kidji baal koort-kwabba yanganan Jesus. ");
INSERT INTO nys_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Moortaman miyalitjiny, baalap malyak kaaranga-waangkiny, “Nidja baal Jesus koorliny nyinyo wer djoro wara mammarapang maya-mayal!” ");
INSERT INTO nys_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zacchaeus yiraba kidji waangki Jesus, “Birdiyar! Ni! Ngany boorda-yanga bangka nganyang banaraka moortakak winyan, kidji bayinya ngany kwadja-yardjang keny moort, ngany boorda-yanga baalany koodjal-koodjal boola-ngatti.” ");
INSERT INTO nys_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus waangki Zacchaeus, “Nidja kedela, nidja karlap wer nidja-nidja moorta barrang-ngandabat-yan, narla nidja mammarap, baal kardjir nyiny Abraham-ang djoowak. ");
INSERT INTO nys_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mammarapang Nop yoowal-koorl moorta koorl-djinango moorta anbangbat-yan, kidji barrang-ngandabat baalapany.” ");
INSERT INTO nys_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Moorta dwangka Jesus, ngarl Jesus karro waangki, waangkiny baalapany warma bardip. Yeyi Jesus yoowal-koorliny Jerusalem-boordak, moorta waangki kabin Boodjer Boolanga-Yira Djelyibiny kayida yoowal-koorlpa. ");
INSERT INTO nys_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ngarl Jesus waangki, “Keny kedela, keny mammarap warda-kadak kwadja-koorliny boyang boodjerak. Bokadja, moorta boorda-yidja baalany Djelyib-biny, kidji ngolanga, baal koordook koort-koorlo karlap. ");
INSERT INTO nys_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kwadjat wort-koorliny, baal mira baalang maar-djen yakina kidji baal yanga yennar moorta keny yando boya. Baal waangki baalapany, ‘Djinang natj noonooka kayar-don boyal korram ngany wort-koorliny.’ ");
INSERT INTO nys_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yeyi, mammarapa baalang boodjerang, baalap yoowart woonya baalany, ngarl baalap waangki-koorl ngakaka-marridjinya kambarniny baalany, waangkiny, ‘Ngala yoowart koordook nidja baal ngalang Djelyib-biny.’ ");
INSERT INTO nys_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yalga moorta boyang boodjerang, baalap yidja nidja mammarap djelyib-biny. Baal koort-koorl. Yilak-yilak, baal mira baalang yakina yaako baal-booram djinango ngalan boya baalap kwadja-warn. ");
INSERT INTO nys_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Koryat yakin yoowal-koorl kidji waangki, ‘Nganyang Djelyib, noonook yanga nganyany keny yando boya, kidji yeyi, ngany kadak maar-djen boyara.’ Djelyib waangki, ");
INSERT INTO nys_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Kwabba! Noonook kwabba yakin! Noonook kwadja-koort-karni nyit noolongal, ngarl ngany boorda-yidja noonany birdiyar-biny maar-djen ngomon karlamaya.’ ");
INSERT INTO nys_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Warning yakin yoowal-koorl kidji waangki, ‘Nganyang Djelyib, noonook yanga nganyany keny yando boya, kidji yeyi, ngany kadak maar boyara.’ ");
INSERT INTO nys_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Djelyib waangki, ‘Ngany boorda-yidja noonany birdiyar-biny maar ngomon karlamaya.’ ");
INSERT INTO nys_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Warma yakin yoowal-koorl kidji waangk, ‘Nganyang Djelyib, nidja, noonang keny yando boya, kanga baalany. Ngany kanya noonang boya kidji ballaridja boya bwoka-bwora. ");
INSERT INTO nys_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngany wayarn noonany. Noonook djadam mammarap. Noonook kanga natj noonook yoowart kadak kidji noonook wedjang natj noonook yoowart niran.’ ");
INSERT INTO nys_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Djelyib waangki, ‘Noonook wara yakin! Noonook kaaditj ngany djadam mammarap. Ngany boorda-banidja noonroo warrinya djin-bamo noonany! Ngany kanga natj ngany yoowart kadak kidji ngany wedjang natj ngany yoowart niran. ");
INSERT INTO nys_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ngarl karro, nadjil noonook yoowart yidja nganyang yando boya maya-maya-bwora boyang? Karro ngany boorda-barrang boya-ngatti ngolonga ngany kort-koorl karlap.’ ");
INSERT INTO nys_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Karro Djelyib warranga baalapany yaakiny bokadja, ‘Kanga baalang boya kidji yanga yakinak kadak maar-djen boyara.’ ");
INSERT INTO nys_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yalga baalap waangki, ‘Ngalang Djelyib, baal kadak maar-djen boya yeyi, wa?’ ");
INSERT INTO nys_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Djelyib waangki, ‘Moort kadak noolong, baal boorda-barrang boola-ngatti. Yalga moort kayan-kadak, baalang nyit-djil noolong boorda wort-kanga-yan. ");
INSERT INTO nys_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yeyi, alidja-alidja wara moorta, baalap yoowart koordook nganyany baalapang Djelyib-biny, barrang baalapany kidji dargang baalapany ngany-booram.’” ");
INSERT INTO nys_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ngolonga Jesus waangki nidja, baal Jerusalem koorl baal-yinadjat. ");
INSERT INTO nys_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jesus boordak-koorl Bethphage wer Bethany, Kard-Koorayinangal. Baal waangki-koorl koodjal ngooldjara yinadjat-koorlo. ");
INSERT INTO nys_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Baal warranga koodjalany, “Koorl karlamaya nyootjoowal-yinadjat. Nginda nyootjoowal bwora-koorl, nyootjoowal boorda-djinang yinang dongki yadarn-yan natj yoowart moort kwadja-dendang. Yalkaranan dongki kidji barrang baalany nganyak. ");
INSERT INTO nys_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bayinya moorta waangki-djinang nadjil nyootjoowal dongki yalkaraniny, warranga baalany, ‘Birdiyar koordook baalany.’ ” ");
INSERT INTO nys_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Koodjal koorl karlamaya kidji djinang moodlooka natj Jesus kwadja-waangki. ");
INSERT INTO nys_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Koodjal malyak dongki yalkaraniny. Moorta kadak dongki, baalap waangki-djinang, “Nadjil nyootjoowal dongki yalkaraniny?” ");
INSERT INTO nys_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Birdiyar koordook baalany,” koodjal waangki. ");
INSERT INTO nys_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kidji koodjal barrang dongki Jesus-ak. Karro baalap kwarda baalapang bwoka dongkikal, kidji baalap maar-yanga Jesus dendang. ");
INSERT INTO nys_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Alimarn Jesus nyinyiny dongkikal, moorta yidja baalapang bwoka djoorootal Jesus-booram. ");
INSERT INTO nys_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nginda Jesus boordak-koorliny Jerusalem djoorootal ngarda-koorliny Kard-Koorayinang, boola-boola Jesus-ang ngooljdara-kambarn, baalap malyak woola-wooliny kidji Boolanga-Yira yangananiny narla moodlookang baalap kwadja-djinang Jesus doniny. ");
INSERT INTO nys_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Boolanga-Yirayil, baal yanga-kwabba Djelyib. Djelyib yoowal-koorl Birdiyarang kolal! Nyiny-oola nakal Boolanga-Yirakang Boodjeral! Bokadja, Boolanga-Yira nyiny, yira-yira wer mardayin!” ");
INSERT INTO nys_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kardakor boola moorta, keny-keny Pharisee-ya waangki Jesus, “Birdiyar, warranga nganyang ngooljdara waangki-yonadji.” ");
INSERT INTO nys_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesus waangki, “Ngany warranga noonookany, bayinya baalap waangki-yonadji, nidja-nidja boyara boorda malyak miriny.” ");
INSERT INTO nys_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesus boordak-koorliny Jerusalem. Nginda baal kayar-djinang moorditj karlamaya, Jesus malyak waliny Jerusalem-ang. ");
INSERT INTO nys_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Baal waangki, “Bayinya noonook arda kaaditji nidja kedela natj noonook ngarnala ngarl noonook kayar kadak nakal! Yalga yeyi noonook yoowart kayar-djinang baalany! ");
INSERT INTO nys_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kedela boorda-yoowal-koorl nginda boomboorman boorda-yengalang noonany. Baalap boorda-dedin noonang djooroota kidji noonook yoowart boorda-kayar-bandak-koorl. ");
INSERT INTO nys_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Baalap boorda-koolyarn noonany wer kardjir moortaman noonook-bwora. Baalap yoowart boorda wandja keny boya yaakiny, narla noonook yoowart djinang-kaaditj kedela nginda Boolanga-Yira yoowal-koorl barrango noonang ngandabat!” ");
INSERT INTO nys_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Karro Jesus bwora-koorl Maya-maya-Kooranyi kidji malyak bandak-yekaniny moorta bangaliny boya, ");
INSERT INTO nys_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kidji waangkiny baalapany, “Boordakiny-Kooranyi waangki nidja: Boolanga-Yira waangki, ‘Nganyang maya-maya boorda-kol-yan maya-maya waangkinyang Boolang-Yirany.’ Yalga noonooka kwadja-warn baalany karraba-biny windji ngakalyang ballaridja!” ");
INSERT INTO nys_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yennar kedela Jesus bwora-koorl Maya-maya-Kooranyi kidji baal karni-waangki moortany. Birdiyar Yakina-Kooranyi wer Mammarapa-Warrinyang wer bworana, baalap mandang koordook dargango Jesus, ");
INSERT INTO nys_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","yalga baalap yoowart djinang war dargango baalany, narla moortaman kalyakool Jesus alayiny, kidji baalap yoowart koordook anbangbat keny warriny. ");
INSERT INTO nys_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nginda Jesus bwora-koorl Maya-maya-Kooranyi, moorta karni-waangkiny kidji baalapany warranginy Warda-Kwabba, Birdiyar Yakina Kooranyi wer Mammarapa-Warrinyang wer bworana, baalap yoowal-koorl dandjo-dandjo ");
INSERT INTO nys_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kidji waangki-djinang Jesus, “Warranga ngalany, yarn noonook kadak mardayin dono nidja-nidja noolonga? Ngiyan yanga noonany nidja mardayin?” ");
INSERT INTO nys_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesus yalman-waangki, “Yeyi, koriyat ngany koordook waangki-djinango noonookany noolong. ");
INSERT INTO nys_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","John kwadja-kadak mardayin kakaloorno moorta, wa? Warranga nganyany, ngiyan yanga John nidja mardayin? Boolanga-Yira ka moorta?” ");
INSERT INTO nys_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Baalap malyak waangki-waangki dandjo, “Natj ngala kayar waangki? Bayinya ngala waangki, ‘Boolanga-Yira,’ Jesus boorda-waangki, ‘Karro nadjil noonookany yoowart ala John?’ ");
INSERT INTO nys_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yalga bayinya ngala waangki, ‘moorta,’ nidja-nidja moortaman boorda boya-karditj ngalany, narla baalap waangki, ‘John kwadja nyiny Warda-Marridjiny.’” ");
INSERT INTO nys_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ngarl baalap waangki, “Ngala yoowart kaaditj ngiyan yanga John baalang mardayin.” ");
INSERT INTO nys_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ngarl Jesus waangki baalapany, “Ngarl ngany yoowart boorda-warranga noonookany ngiyan yanga nganyany mardayin dono nidja-nidja noolonga.” ");
INSERT INTO nys_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Karro Jesus warranga moorta nidja bardip. “Mammarap niran djildji baalang boodjeral. Warma moorta yanga baalany boya banitjo boodjer kidji nidja mammarap boyang wort-koorl. ");
INSERT INTO nys_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Boornoora yoowal-koorl kidji djildji kakatar, ngarl baal waangki-koorl yakin moortak banitjiny baalang boodjer barrango baalang walak djildjiyang. Yalga moorta bama baalang yakin kidji waangki-koorl baalany kayan-kadak. ");
INSERT INTO nys_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ngarl mammarap waangki-koorl warma yakin; yalga moorta bama baalany kidji wara-bakkan baalany, kidji waangki-koorl baalany kayan-kadak. ");
INSERT INTO nys_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Karro mammarap waangki-koorl warma yakin; yalga moorta kardjir bama baalany kidji bandak-kwarda baalany. ");
INSERT INTO nys_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Karro birdiyar boodjer-djildjiyang waangki, ‘Natj ngany boorda-don? Ngany kadak arda keny nop. Ngany woonya baalany. Ngany boorda-waangki-koorl baalany. Doora, baalap boorda ala baalany!’ ");
INSERT INTO nys_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Yalga nginda moorta djinang nopany, baalap waangki, ‘Nidja baal birdiyarang nop! Ngala boorda-dargang baalany, kidji baalang boodjer boorda ngalang boodjer-biny!’ ");
INSERT INTO nys_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ngarl baalap bandak-kwarda nopany boodjer-djildjiyang kidji dargang baalany.” Jesus waangki-djinang, “Yeyi, natj birdiyar boodjer-djildjiyang boorda-don nidja-nidja moortak? ");
INSERT INTO nys_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Baal boorda-yoowal-koorl kidji dargang nidja-nidja moortany kidji baal boorda-yanga boodjer-djildjiyang warma moortak banitjo.” Nginda moorta dwangka nidja bardip, baalap waangki, “Doora, nidja yoowart kayar-edjena!” ");
INSERT INTO nys_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesus miyalitj baalapany kidji baal waangki-djinang, “Natj nidja Boordakiny-Kooranyi waangki? ‘Yakina maya-maya warniny, baal wort-kwarda nidja banitja-birt boya, yalga yeyi nidja boya kwabba-djil boya-biny.’ ");
INSERT INTO nys_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mandang moorta ngiyan kwarda nidja boyal, baalap boorda-wara-bakkan-yan; kidji bayinya nidja boya kwarda moortal, boya boorda-koolyarn baalany dalbakak.” ");
INSERT INTO nys_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mammarapa-Warrinyang wer Birdiyara Yakina-Kooranyi, baalap kaaditj natj Jesus warranga nidja bardip djirino baalany, ngarl baala koordook yoordjango Jesus yeyi, yalga baalap wayarn moorta. ");
INSERT INTO nys_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ngarl baalap nganayaka baalapang kannar. Baalap yanga boya wara mammarapak kino baalap karnany waangki kidji baal waangki-koorl baalapany waangki-djinangak Jesus kidji mango baalany, ngarl baalap kayar yoordjang Jesus kidji yidja baalany maara-bwora Rome-kang Birdiyar. ");
INSERT INTO nys_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nidja-nidja wara mammarapa waangki Jesus “Birdiyar, ngala kaaditj noonookany. Nginda noonook waangki moorta, noonook karnayal waangki. Ngala kaaditj noonook yoowart miyalitj moortang mardayin yalga karni-waangki moorta natj Boolanga-Yira koordook baalapany dono. ");
INSERT INTO nys_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Warranga ngala, bayinya ngalang warriny waangki ngala djarnyak yanga boya Rome-kang Djelyibak, ka yoowart?” ");
INSERT INTO nys_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yalga Jesus djinang baalang barrit kidji baal waangki, ");
INSERT INTO nys_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Yanga nganyany keny boya. Ngiyanang moolyimarri nyiny boyal wer ngiyanang kol?” “Djelyib,” baalap waangki. ");
INSERT INTO nys_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ngarl Jesus waangki, “Karro, yanga Djelyibany noolonga Djelyib kadak, kidji yanga Boolanga-Yira noolonga Boolanga-Yira kadak.” ");
INSERT INTO nys_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bokadja, moorta-booram, baalap yoowart Jesus-any kayar manga, yoowart noolong keny, ngarl baalap waangki-yonadji, kidji baalap kai-kai narla moodlooka Jesus-any waangki. ");
INSERT INTO nys_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadducee-ya, baalap waangki nidja: moorta yoowart boorda-yiraba noyitj-yen, ngarl keny-keny Sadducee-ya koorl Jesus kidji waangki, ");
INSERT INTO nys_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Birdiyar, Moses boordak nidja Warriny ngalang: ‘Bayinya keny mammarap wanni kwadjat baalang koort-maat yidja koorlangka, baalang ngooni djarnyak koorta-barrang baalang yenang, ngarl baal kayar-yidja koorlangka noyitj mammarapang.’ ");
INSERT INTO nys_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Keny kedela, maar-koodjal ngooniya kwadja-wining. Koriyat ngooni koorta-barrang, yalga baal wanni koorlangka-birt. ");
INSERT INTO nys_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Karro warning ngooni koorta-barrang baalang yenang, kidji baal wanni. ");
INSERT INTO nys_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ngolonga, warning ngooni kardjir koorta-barrang yenang, kidji baal wanni. Noolong-djin edjena mandang maar-koodjal ngooniyak. Baalap mandang wanni koorlangka-birt, ");
INSERT INTO nys_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","kidji yadok, nidja yok kardjir wanni. ");
INSERT INTO nys_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ngarl, nginda moorta yiraba noyitj-yen, natj ngooni boorda nyiny yokang koort-maat? Mandang maar-koodjal ngooniya kwadja-koorta-barrang alidja yok.”, ");
INSERT INTO nys_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus yalman-waangki, “Nidja kedela, mammarapa wer yoka koorta-barrang, ");
INSERT INTO nys_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","yalga mammarapa wer yoka kwabba kinyak, baalap boorda yiraba noyitj-yen, baalap boorda-wining kedelakal yoowal-koorliny kidji karro baalap yoowart boorda-koorta-barrang. ");
INSERT INTO nys_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Baalap boorda djin-djina-kooranyi-mokiny kidji yoowart kayar-wanni. Baalap boorda Boolanga-Yirang koorlangka-biny narla baalap kwadja-yiraba noyitj-yen. ");
INSERT INTO nys_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kidji karnayal, Moses barrang-djinang ngalak, noyitj moorta boorda-yiraba ngandabatak. Ngalang Boordakiny-Kooranyi warranga ngalany Moses-ang wer narriny koorilkar. Bokadja, Moses waangki, ‘Abraham-ang Boolanga-Yira, Isaac-ang Boolanga-Yira wer Jacob-ang Boolanga-Yira.’ ");
INSERT INTO nys_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Baal nyiny Boolanga-Yira wining moortakang, yoowart noyitj moorta. Boolanga-Yirakak, mandang moorta wining.” ");
INSERT INTO nys_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Keny-keny Mammarapa-Warrinyang waangki, “Noonook kwabba yalman-waangki, Birdiyar!” ");
INSERT INTO nys_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Baalap wayarn-biny waangki-djinango Jesus warma noolong. ");
INSERT INTO nys_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesus waangki-djinang baalapany, “Boordakiny-Kooranyi waangki ‘Keny Boolanga-Yira Waangki-Koorl,’ baal boorda-nyiny David-ang djoowak. Yarn nidja kayar edjena? ");
INSERT INTO nys_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David baalaal boordak Yedika, kidji baal waangki, ‘Birdiyar waangki nganyang Birdiyar, “Nyin nidja, nganyang maar ngoornmoorn-ngat, ");
INSERT INTO nys_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kedelakak nginda ngany boorda-yidja noonang boomboorman ngwoorndinyap-mokiny noonang djena-ngarda.” ’ ");
INSERT INTO nys_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David kwadja-waangkiny Kenyang Boolanga-Yira Waangki-Koorl, kidji baal kolitj baalany ‘Birdiyar’. Yarn nidja baal nyin Davidang djoowak?” ");
INSERT INTO nys_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Moortaman kwadja-alayiny Jesus, yalga baal waangki baalang ngooljdarany, ");
INSERT INTO nys_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Balayi Mammarapa-Warrinyang. Baalap kalyakool marridja baalapang bwoka woori wandanginy kidji baalap koordook moortany mandjaral waangkiny baalap moorditj. Baalap koordook barrango kwabba-djil nyinap Maya-maya-Kalyaral kidji kwabba-djil nyinap kedelal ngarniny wer djoriny. ");
INSERT INTO nys_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Baalap barrit yenanga kidji baalap yoordjang baalapang maya-maya, yalga ngolonga, baalap koordook moorta djinango baalapany Boolanga-Yira waangkiny kwodjang! Baalapang djin-baminy boorda wara-ngatti!” ");
INSERT INTO nys_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus miyalitj moodlooka, kidji baal djinang mammarapa boola boya-kadak. Baalap baalapang boya barranginy kidji boya yidjiny koodakal boyang Maya-maya-Kooranyikal, ");
INSERT INTO nys_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jesus kardjir djinang keny winyan yenang, koodjal nyit djedari boyara koodakal yidjiny. ");
INSERT INTO nys_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesus waangki, “Ngany warranga noonookany, nidja winyan yenang, baal kwadja yanga boya-ngatti nadjang warma moortaman, ");
INSERT INTO nys_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","narla moorta warma yanga noolonga baalapang moorditj banaraka; yalga nidja winyan-djil yenang, baal yanga moodlooka, boya mandang baal kadak.” ");
INSERT INTO nys_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jesus-ang ngooldjara-kambarn kwadja-waangkiny Maya-maya-Kooranyiyang, yarn kwabbalitj baalany yaaka. Baalap miyalitjiny kwabba-djil boya wer boola warma noolonga moorta kwadja-yanga Boolanga-Yirakak. Jesus waangki, ");
INSERT INTO nys_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Noonooka djinang mandang nidja-nidja noolonga. Kedela boorda yoowal-koorl nginda yoowart keny boya boorda-yaaka baalang nyinapal; mandang boyara boorda bamakanrin-yan.” ");
INSERT INTO nys_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Baalap waangki-djinang, “Birdiyar, nginda nidja-nidja noolonga boorda-yoowal-koorl? Kidji natj boorda-edjena koriyat ngarl ngala kayar-djinang nginda moodlooka malyakiny edjeno?” ");
INSERT INTO nys_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesus waangki, “Balayi! Yoowart ala koolyooma. Boola mammarapa boorda-yoowal-koorl barrito, kin-kininy baalap waangki nganyang, kidji baalap boorda-waangki, ‘Ngany Keny!’ wer ‘Kedela yoowal-koorl!’ Yoowart kambarn baalapany! ");
INSERT INTO nys_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Noonooka yoowart djarnyak wayarn nginda noonooka dwangka bakadjinyang wer dornamakariny. Nidja-nidja noolonga djarnyak koriyat edjena; yalga nidja-nidja noolonga yoowart barrang-djinang yadok kedelara yoowal-koorliny.” ");
INSERT INTO nys_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesus ngatti-waangki. “Boola boodjera boorda bakadj warma boodjera. Djelyiba wer baalang moorta boorda-baladjan warma djelyiba wer baalang moorta. ");
INSERT INTO nys_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Karda boorda-yoorang-yoorang, moorta boorda mereny-birt wer djora-birt, kidji wara-wara minditj boorda-wokart-koorl mandang boodjera. Mogong noolonga wer darnayaniny noolonga boorda-djabalar worlyen. ");
INSERT INTO nys_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yalga kwadjat mandang nidja-nidja noolonga edjena, baalap boorda-yardjang noonookany kidji bakkan noonookany; baalap boorda-marlbarrang noonookany djin-baminyang Maya-maya-Kalyarakal kidj baalap boorda-yidja noonookany maya-maya-dedinyang bwora. Baalap boorda-yalbarrang noonookany djelyiba-booram wer birdiyara-booram ngarl nganyang. ");
INSERT INTO nys_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nidja boorda barrang noonookang kannar, ngarl noonooka kayar warranga Warda-Kwabba. ");
INSERT INTO nys_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kwadjat alidja kedela, noonooka djarnyak kakatar noonookaal, noonooka yoowart djarnyak wayarn yarn noonooka boorda yalman-waangki baalapany, ");
INSERT INTO nys_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","narla ngany boorda yanga noonookany kwabba warrinya wer dwangka-boola, ngarl yoowart keny nidja-nidja wara moortang boorda kayar yalman-waangko noonookany kidji waangki noonooka yoowart karnany warranginy. ");
INSERT INTO nys_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Noonookang maamana wer ngaangka, noonookang ngooniya wer babina, baalap boorda wort-yanga noonookany kidji moorta boorda-dargang keny-keny noonookang. ");
INSERT INTO nys_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Moortaman boorda koort-djal noonookany narla nganyang. ");
INSERT INTO nys_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yalga yoowart keny djoomba noonookang kaata boorda-anbangbat-yan. ");
INSERT INTO nys_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwitjar yiraba, kidji noonooka boorda-barrang-ngandabat noonookaal.” ");
INSERT INTO nys_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nginda noonooka djinang mammarapa-bakadjiny Jerusalem yengalanginy, karro noonooka boorda-kaaditj nidjap kayida boorda-djakan-yan. ");
INSERT INTO nys_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Karro alidja-alidja moorta wining Judea-kal, baalap djarnyak boordang kardakak; alidja-alidja moorta wining Jerusalem-al, baalap djarnyak yilak-yilak wort-koorl, kidji alidja-alidja moorta bandak mandakal, baalap yoowart djarnyak korl-koorl Jerusalem. ");
INSERT INTO nys_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nidja-nidja kedelara boorda ‘Kedelaka Djin-baminyang’-abiny, narla moodlooka natj Boordakiny-Kooranyi waangki doora boorda edjena. ");
INSERT INTO nys_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nidja-nidja Kedelara boorda darnayan-djil alidja-alidja yokang boodjari wer ngaangka kadak kooninya! Wara-wara kedelara wer darnayan kedelara boorda yoowal-koorl nidja boodjerak, kidji Boolanga-Yira boorda djin-bama nidja-nidja moorta. ");
INSERT INTO nys_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Boola moorta boorda dargang-yan djarpal; warma moorta boorda yardjang-yan kidji baalap boorda yadarn-yan kidji wort-kool-yan boyang boodjerak. Mokang moorta ngiyan yoowart kaaditj Boolanga-Yira, baalap boorda-kana-kana Jerusalem djiyak baalapang kedela boorda-nganitj. ");
INSERT INTO nys_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Mokang noolonga boorda edjena ngangkal, mikakal wer djindakal. Nidja boodjeral, boola moorditjap boorda-koort-wara-wara, wayarniny koordor ngiyangang kidji kaarang wardarn. ");
INSERT INTO nys_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Moorta boorda yowi-kwarda wayarnang, nganayakiny noolonga koorliny dengkooro mandang Boodjer. Mardayina kadjitang boorda-yekan-yan baalapang djoorootayen. ");
INSERT INTO nys_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Karro mandang moorta boorda djinang Mammarapang Nop, moorditj wer bandjatiny, koorliny koondartal. ");
INSERT INTO nys_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nginda nidja malyak edjeniny, yiraba kidji billan noonookang kaata. Noonookang barrang-ngandabatiny yoowal-koorl.” ");
INSERT INTO nys_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Karro Jesus waangki baalapany nidja bardip, “Barrang-dwangka kolboga kidji warma boorna. ");
INSERT INTO nys_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nginda noonooka djinang djilbika malyakiny maladjiny, noonooka kaaditj birok yoowal-koorliny. ");
INSERT INTO nys_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","War-djin, nginda noonooka djinang nidja-nidja noolonga edjeniny, noonooka boorda-kaaditj Boodjer Boolanga-Yira Djelyibiny boordak yoowal-koorliny. ");
INSERT INTO nys_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Barrang-dwangka, mandang nidja-nidja noolonga boorda edjena kwadjat yennar moorta yeyi wining boorda-wanni. ");
INSERT INTO nys_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Worl wer Boodjara boorda wort-koorl, yalga nganyang Warriny yoowart boorda wort-koorl.” ");
INSERT INTO nys_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Balayi! Yoowart kaaditj arda ngarninyang wer djorinyang wer moodlooka nidja Boodjerang. Alidja kedela yilak-yilak kayar yoowal-koorl kidji manga noonookany! ");
INSERT INTO nys_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Narla alidja kedela boorda yoowal-koorl mandang moortakak yennar bankang Boodjerang. ");
INSERT INTO nys_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kalyakool balayi kidji kalyakool ngakaka Boolanga-Yira yango noonookany kinyak mardayin ngarl noonooka kayar ngabalangornda wokart-koorl mandang nidja-nidja noolonga natj boorda edjena, kidji karro, noonooka boorda yira-yaaka Mammarapang Nop booram.” ");
INSERT INTO nys_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yennar kedelara, Jesus bwora-koorl Maya-maya-Kooranyi, moorta karni-waangkiny. Nginda ngangk ngarda-koorl, Jesus bandak-koorl Kard-Koorayinang kidji baal naan-yaaka bokadja mandang kadik. ");
INSERT INTO nys_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nginda ngangk yira, mandang moorta koorl Maya-maya-Kooranyi dwangka Jesus. ");
INSERT INTO nys_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yeyi ‘Mandjar Merenyang-Bargar’ kayida edjeniny. Moorta kardjir kol nidja mandjar ‘Yira-Djendjeriny’. ");
INSERT INTO nys_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Birdiyara Yakina-Kooranyi wer Mammarapa-Warrinyang wayarn moortany, ngarl baalap koordook war dargango Jesus ballar. ");
INSERT INTO nys_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Karro Satan bwora-koorl Judas. Moorta kardjir kol baalany ‘Iscariot’, keny Jesus-ang maar-djen-koodjal ngooldjara. ");
INSERT INTO nys_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ngarl Judas wort-koorl Birdiyara Yakina-Kooranyi, wer manatja Maya-maya-Kooranyiyang, kidji baal warranga baalapany war baal kayar-kobatan Jesus. ");
INSERT INTO nys_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Baalap koorta-keny kidji baalap waangki Judas baalap boorda-yanga baalany boya. ");
INSERT INTO nys_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas waangki, “Kaya,” kidji malyak korl-djinanginy kwabba dji kobatano Jesus nginda moorta yoowart miyalitjiny. ");
INSERT INTO nys_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mandjar Merenyang-Bargar yoowal-koorl kidji kedela nginda moorta dargang yinang kookendjeri ngarno kedelal Yira-Djenjerinyang. ");
INSERT INTO nys_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus waangki-koorl Peter wer John, waangkiny, “Koorl kidji kakatar mereny Yira-Djenjerinyang ngalang ngarn.” ");
INSERT INTO nys_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Windji noonook koordook ngalany kakataro mereny?” baalap waangki-djinang. ");
INSERT INTO nys_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus waangki, “Bwora-koorl ngomon karlamaya. Keny mammarap dinanginy bwokooda kepang, baal boorda yoowal-koorl noonookak. Nginda baal bwora-koorl maya-maya, kambarn baalany, ");
INSERT INTO nys_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","kidji noonooka warranga mammarapany kadak maya-maya: ‘Birdiyar ngakaka noonook, “Natj bangka maya-mayang kakatar-yan ngarl ngany wer nganyang ngooldjara kayar ngarn mereny Yira-Djenjeriny?” ’ ");
INSERT INTO nys_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Baal boorda yira-barrang noonookany djinango bangka maya-mayang windji moodlooka nyiny alidja ngalang. Kakatar mereny bokadja.” ");
INSERT INTO nys_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Baalap koorl kidji baalap djinang moodlooka waral Jesus warranga baalapany. ");
INSERT INTO nys_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nginda dji koorl, Jesus wer baalang ngooldjara koorl ngarnyapal kidji nyiny. ");
INSERT INTO nys_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesus warranga baalapany, “Karnayal, ngany koordook ngalany ngarno-dandjo nidja mereny Yira-Djenjerinyang kwadjat ngany wara bakkan! ");
INSERT INTO nys_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ngarl ngany warranga noonookany, ngany yoowart boorda ngarn karro noonooka-dandjo, arda nginda karnarny mandang nidja-nidja noolongakang kaaditj-biny Boodjeral Boolanga-Yirang Djelyibiny.” ");
INSERT INTO nys_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Karro Jesus barrang keny yoodjil, yanganan Boolanga-Yirany, kidji waangki “Kanga nidja yoodjil kidji walak-yanga baalany noonookaal kardakor. ");
INSERT INTO nys_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ngany warranga noonookany, yeyi ngany yoowart karro boorda djora nidja kepa-mardayin kwadjat Boodjer Boolanga-Yira Djeyibiny yoowal-koorl.” ");
INSERT INTO nys_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Karro Jesus barrang mooloor merenyang, yanganan Boolanga-Yirany, djakarn mereny, kidji baal yanga mereny baalapany, waangkiny, “Nidja nganyang yarlin. Baal yanga-yan noonookang. Don nidja barrang-dwangkak nganyany.” ");
INSERT INTO nys_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","War-djin, ngolonga mereny, Jesus yanga baalapany yoodjil kepakang, waangkiny, “Nidja yoodjil milgar koorta-kenyiny, boordak-yan nganyang ngopal. Baal darang-yan noonookang. ");
INSERT INTO nys_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yalga djinang! Keny ngiyan kobatan nganyany, baal nyiny ngarniny ngalany kardakor! ");
INSERT INTO nys_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mammarapang Nop boorda-wanni, waral Boolanga-Yira kwadja-waangki, yalga darnayan-djil mammarapang kobataniny baalany.” ");
INSERT INTO nys_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Karro baalap kwadjin waangki-djinanginy baalapaal kardakor, “Natj keny ngalang kayar-don nidja noolong?” ");
INSERT INTO nys_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mandang ngooldjara kwadjin waangki-waangkiny, natj keny baalapang moorditj-ngatti nyiny baalapany mandang kardakor. ");
INSERT INTO nys_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus waangki baalapany, “Djelyiba moortakang ngiyan yoowart kaaditj Boolanga-Yira, baalap kadak boola mardayin, warranginy moortany dono moodlooka baalap koordook. Nidja-nidja djelyiba kol baalapaal ‘Moortang Babina.’ ");
INSERT INTO nys_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yalga noonooka yoowart djarnyak karra war-djin. Yoowart! Moort moorditj-ngatti noonookany kardakor, baal djarnyak ngarda-bini, ngarda-ngatti moort-mokiny, kidji birdiyar djarnyak yakin-bini. ");
INSERT INTO nys_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ngiyan moorditj-ngatti? Moort nyininy ngarniny? Ka moort baalany yanginy baalang mereny? Karnayal, keny nyininy. Yalga ngany nyiny noonookany kardakor moorta-mokiny yakiny noonookang.” ");
INSERT INTO nys_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Noonooka kwadja-yaaka nganyang boongalak mandang wara noolongakal edjeniny nganyak. ");
INSERT INTO nys_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kidji yeyi, nganyang Maaman yanga nganyany mardayin Djelyib-biny, ngarl ngany yanga noonookany mardayin-djin. ");
INSERT INTO nys_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Noonooka boorda-ngarn wer djora ngany-boongal Boodjeral nginda ngany nyiny Djelyib kidji noonooka boorda-nyiny djelyibang nyinapal kidji noonooka boorda birdiyaritj maar-djen-koodjal ngoongoolonga Israel-ang.” ");
INSERT INTO nys_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon! Ni! Boolanga-Yira kaaditj Satan-ang, baal boorda-djonany-kariny mandang noonookany, walak-walakiny kwabba wer wara, yakina-mokiny boodjerang walak-walakiny kwolaka wer dalba. ");
INSERT INTO nys_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yalga ngany ngakaka Boolanga-Yirany maar-yango noonany, Simon, ngarl noonang koort-karni yoowart boorda-wanni. Kidji nginda noonook korl-koorl nganyany, noonook djarnyak yanga mardayin noonookang ngooniyak.” ");
INSERT INTO nys_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peter waangki, “Birdiyar, ngany kakatar yardjango-yan noonook-boongal kidji wanni noonook-boongal!” Jesus waangki, ");
INSERT INTO nys_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Ngany warranga noonook, Peter, nidja kadik, kwadjat djert mira, noonook boorda warranga mo koolyooma, waangkiny noonook yoowart kaaditj nganyany.” ");
INSERT INTO nys_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Karro Jesus waangki-djinang baalang ngooldjarany, “Alidja kedela, nginda ngany waangki-koorl noonookany bandak-koorlo, kooda-boya-birt, bwokooda-birt wer djena-bwoka-birt, noonooka nganala noolong, wa?” “Yoowart keny noolong,” baalap waangki. ");
INSERT INTO nys_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Yalga yeyi,” Jesus waangki, “moorta kadak kooda-boya ka bwokooda, baal djarnyak barrang baalany; kidji moorta yoowart kadak kitji, baal djarnyak bangal-yanga baalang bwoka kidji bangal-barrang kitj. ");
INSERT INTO nys_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Narla ngany warranga noonookany, Boordakiny-Kooranyi waangki, ‘Baal boorda-djin-baminy-yan wara-wara moort-mokiny’! Nidja djarnyak edjena nganyak narla moodlooka boordak-yan nganyang, yeyi djarnyak mandang edjena.” ");
INSERT INTO nys_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ngooldjara waangki, “Djinang! Nidja koodjal kitj, Birdiyar!” “Alidja kinyak!” Jesus waangki. ");
INSERT INTO nys_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesus wort-koorl ngomon karlamaya kidji baal yira-koorl Kard-Koorayinang, alidjap baal kalyakool koorl. Baalang ngooldjara kambarn baalany. ");
INSERT INTO nys_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nginda Jesus yoowal-koorl alidjap, baal waangki baalapany, “Noonookany djarnyak ngakaka Boolanga-Yirany natj noonooka yoowart djabalar djooroot-bwora doniny-karrinyang.” ");
INSERT INTO nys_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Karro Jesus wort-koorl baalapany, yoowart kadjali, boya-kwardiny-mokiny. Jesus boni-nanookawin kidji baal waangki Boolanga-Yirany. ");
INSERT INTO nys_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Maaman,” baal waangki, “Bayinya noonook koordook, noonook kayar wort-kanga nidja yoodjil, nidja yoodjil wara bakkanang. Yalga noonook yoowart djarnyak don natj ngany koordook: noonook djarnyak don natj noonook koordook dono.” ");
INSERT INTO nys_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Djin-djin-kwabba yoowal-koorl Boolanga Yirakang Boodjer-yen kidji maar-yanga Jesus mardayin-ngatti-biny. ");
INSERT INTO nys_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesus malyak bakkano wara-ngatti kidji baal waangki Boolanga-Yirany ngwidam-ngatti. Nganyang banya djabalar, yirribininy boodjerak ngop-mokiny. ");
INSERT INTO nys_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ngolonga Jesus nganitj waangkiny Boolanga-Yirany, baal yiraba kidji baal korl-koorl baalang ngooldjarany. Baal djinang baalapany ngwoordiny bidjar, mordibang-yan narla baalapang koort-wara-wara. ");
INSERT INTO nys_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Baal waangki baalapany, “Nadjil noonooka ngwoorndiny bidjar? Yiraba kidji ngakaka Boolanga-Yirany natj noonooka yoowart djabalar djooroot-bwora doniny-karrinyang.” ");
INSERT INTO nys_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus yoowart nganitj waangkiny nginda Judas, keny maar-djen-koodjal ngooldjarang, baal yoowal-koorl yalbarranginy boola moorta. Judas koorl nindjano Jesus. ");
INSERT INTO nys_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yalga Jesus waangki, “Judas, noonook kobatan Mammarapang Nop nindjanyel, wa?” ");
INSERT INTO nys_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nginda ngooldjara Jesus-any kambarniny baalap djinang nidja edjeniny, baalap ngakaka, “Birdiyar, ngala boorda-banitja ngalang kitja, wa?” ");
INSERT INTO nys_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kidji keny baalapang bama keny mammarapany, Birdiyar-Yira Yakina-Kooranyiyang yakin, kidji kadjat baalang dwangka ngoornmoorn. ");
INSERT INTO nys_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yalga Jesus waangki, “Kaa alidjang!” Baal baka mammarapang dwangka kidji barra-barra baalany. ");
INSERT INTO nys_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Karro Jesus waangki mandang baalapany, Birdiyara Yakina-Kooranyiyang wer manatja Maya-Maya-Kooranyiyang wer bworana, alidja-alidja moorta yoowal-koorliny yardjangak baalany, “Noonooka yoowal-koorl kitjo wer koondiya, war-djin noonooka yardjang ngakalyang, wa? ");
INSERT INTO nys_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ngany kwadja-nyinyiny noonooka-boongal Maya-Maya-Kooranyi-bwora yennar kedela. Noonooka yoowart kayar-barrang nganyany bokadja, wa? Yalga nidja noonookang dji, yoowal-koorliny nginda mardayin mayartang birdiyariny.” ");
INSERT INTO nys_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Baalap yardjang Jesus kidji wort-barrang baalany Birdiyar-Yira Yakina Kooranyikang maya-maya-bwora, kidji Peter kambarn baalapany. ");
INSERT INTO nys_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Moorta kwadja bowan karla didarakal, maya-maya bandak, kidji Peter boordak-koorl moortakak nyinyiny karla boordak. ");
INSERT INTO nys_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Keny yok yakin djinang Peter nyinyiny karla boordak, ngarl baal miyalitj darkal baalak kidji baal waangki, “Nidja mammarap kardjir kambarn Jesus!” ");
INSERT INTO nys_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yalga Peter koolyoomitj, “Yok, ngany yoowart kaaditj Jesus!” ");
INSERT INTO nys_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kayida keny, mammarap djinang Peter kidji baal waangki, “Noonook kardjir keny baalapang!” Yalga Peter waangki, “Mammarap, ngany yoowart!” ");
INSERT INTO nys_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ngolonga, warma mammarap waangki ngatti-ngatti “Ngany karnayal kaaditj. Mammarap nidja Jesus-any kambarn, narla baal kardjir Galilee-karlap!” ");
INSERT INTO nys_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Yalga Peter waangki, “Mammarap, ngany yoowart kaaditj naatj noonook waangkiny!” Winidjinbar, nginda Peter kwadja-waangkiny, keny djert mira. ");
INSERT INTO nys_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesus korang kidji miyalitj darkal Peter-ak, kidji Peter barrang-dwangka natj Jesus kwadja-waangki baalany, “Nidja kadik, kwadjat djert mira, noonook boorda warranga mo koolyooma, waangkiny noonook yoowart kaaditj nganyany.” ");
INSERT INTO nys_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peter wort-koorl, koort-wara waliny. ");
INSERT INTO nys_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mammarapa ngiyan kwadja-yardjang Jesus, baalap yidjan Jesus-any kidji bama-bama baalany. ");
INSERT INTO nys_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Baalang dengkoor Jesus-ang miyala kidji waangki-djinang, “Ngiyan bama noonany? Kambarng!” ");
INSERT INTO nys_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kidji baalap wara-waangki Jesus ngatti-ngatti. ");
INSERT INTO nys_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nginda ngank yira, bworana wer Birdiyara Yakina-Kooranyiyang wer Mammarapa-Warrinyang, baalap yoowal-koorl dandjo-dandjo, kidji baalap yalbarrang Jesus Yoolina-booram. ");
INSERT INTO nys_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Warranga ngalany,” baalap waangki, “Noonook nyiny Keny Boolanga Yira Waangki-Koorl, wa?” Jesus yalman-waangki, “Bayinya ngany warranga noonany, noonooka yoowart djinang-karni. ");
INSERT INTO nys_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kidji bayinya ngany waangki-djinang noonany noolong, noonooka yoowart boorda-yalman-waangki nganyany. ");
INSERT INTO nys_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yalga yeyi, Mammarapang Nop boorda-nyiny Boolanga-Yirang ngoornmoornal, moorditj wer mardayin.” ");
INSERT INTO nys_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Baalap bandang waangki, “Karro noonook Boolanga-Yirang Nop, wa?” Jesus baalapany waangki, “Noonooka waangki nidja nganyang.” ");
INSERT INTO nys_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kidji baalap waangki, “Ngala yoowart marlangaka ngarnala! Ngalaal dwangka baalang warranga!” ");
INSERT INTO nys_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Moortaman yiraba kidji barrang Jesus Pilate-booram. ");
INSERT INTO nys_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bokadja, baalap malyak djiriny Jesus, “Ngala kwadja-dwangka nidja mammarap barritiny ngalang moorta. Baal warranga baalapany yoowart yango boya Rome-ang Djelyibak kidji waangki natj baal nyiny Keny Boolanga Yira Waangki-Koorl, kidji baal nyiny keny djelyib baalaal.” ");
INSERT INTO nys_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate waangki-djinang baal, “Noonook Djelyib moortakang Judea-kang, wa?” “Ngarl noonook waangki,” Jesus yalman-waangki. ");
INSERT INTO nys_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Karro Pilate waangki Birdiyara Yakina-Kooranyiyang wer mandang moortany, “Ngany yoowart kayar-djinang mingitj noolong nidja mammarapal djin-bamo baalany.” ");
INSERT INTO nys_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yalga baalap mardayin-ngatti waangki, “Narla nidja mammarap waangki nidja-nidja noolonga, moorta kwadjininy waangki-waangko kidji bakadjiny kooramba Judea-kal. Baal malyak Galilee-kal kidji yeyi baal yoowal-koorl nidjap.” ");
INSERT INTO nys_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nidja dwangkiny, Herod waangki-djinang, “Nidja baal Galilee-karlap, wa?” ");
INSERT INTO nys_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nginda baal dwangka naatj Jesus Galilee-karlap, boodjer windji Herod nyiny djelyib, Pilate waangki-koorl Jesus Herod-ak, narla Herod kardjir Jerusalem-ak. ");
INSERT INTO nys_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod djoorab-djil djinango Jesus, narla baal kwadja-dwangka baalang kidji baal kalyakool kwadja-koordook kannar djinango Jesus. Herod koordook djinango Jesus doniny malgar noolonga. ");
INSERT INTO nys_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ngarl Herod waangki-djinang Jesus boola noolonga, yalga Jesus yoowart yalman-waangki. ");
INSERT INTO nys_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Birdiyara Yakina-Kooranyiyang wer Mammarapa-Warrinyang, baalap booram-kanna kidji baalap mardayin djirina Jesus. ");
INSERT INTO nys_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod wer baalang mammarapa-bakadjiny, baalap yidjan Jesus kidji wara-waangki baalany. Karro baalap wolang Jesus kwabba-djil bwokakal kidji baalap waangki-koorl Jesus Pilate-ak. ");
INSERT INTO nys_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aldja kedela, Herod wer Pilate babina-biny. Kwadjat, koodjal kwadja boomboorman. ");
INSERT INTO nys_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate dandjo-barrang Birdiyara Yakina-Kooranyiyang, mammarapa warda-kadak wer moortaman, ");
INSERT INTO nys_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kidji waangki baalapany, “Noonooka barrang nidja mammarap nganya-booram kidji noonooka waangki baal kwadja-koolyoomitjiny moortakak. Yeyi ngany kwadja-waangki-djinang baalany moodlooka noonooka-booram kidji ngany yoowart kayar djinbarranga baalany walgar-kadak kenyang alidja-alidja mingitj noolonga noonooka djirin baalang. ");
INSERT INTO nys_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod kardjir yoowart djinbarranga baalany walgar-kadak, narla baal waangki-koorl baalany ngalak. ");
INSERT INTO nys_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Nidja mammarap kwadja-don kayan nadjang baal djarnyak wanni. Ngarl ngany boorda-warranga baalapany bama-bamo baalany, kidji karro yalgaran baalany.” ");
INSERT INTO nys_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Moortaman waangka-djan, “Dargang baal boornil! Yalgaran Barabbas ngalak!” ");
INSERT INTO nys_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabbas kwadja yadarn-yan maya-mayakal dedinyang narla baal kwadja-malyak bakadjiny kardakor moorta Jerusalem-al, kidji baal kwadja-dargang moortany.) ");
INSERT INTO nys_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate koordook yalgarano Jesus, ngarl karro baal ngakaka mandang moorta. ");
INSERT INTO nys_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Yalga baalap kaarang-mira, “Dargang baalany boornil! Dargang baalany boornil!” ");
INSERT INTO nys_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Karro Pilate mo-waangki, waangki-djinanginy “Yalga natj wara noolong baalany kwadja-don? Ngany yoowart kayar-djinbarranga keny noolong baal kwadja-don nadjang baal doora-wanni. Ngarl ngany boorda-warranga baalapany bama-bamo baalany kidji karro yalgaran baalany.” ");
INSERT INTO nys_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yalga boola moorta yoowart nganitj waangka-djaniny natj baalap doora-katj Jesus boornak wanniyo. Yadok, ngolonga kwodjang, Pilate dwangka baalapang kaarang-mira kidji yanga baalapany natj baalap ngakaka. ");
INSERT INTO nys_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ngarl Pilate waangki warrinya noyitjang Jesus-ang, noolong baal koordook. ");
INSERT INTO nys_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Baal yalkaranan Barabbas, mammarap ngiyan baalap koordook, keny baalap yidja maya-maya-bwora dedinyang narla bakadjinyang wer darganginy, kidji Pilate yanga Jesus baalapak dono natj baalap koordook. ");
INSERT INTO nys_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mammarapa-bakadjiny wort-barrang Jesus. Baalap kayalar Simon Cyrene-karlap, keny mammarap bwora-koorliny ngomon karlamaya boodjeryen. Baalap yardjan Simon, baalap yidja Jesus-ang boorn-yambo baalal, kidji baalap warranga baalany kango boorn-yambo Jesus-ngolanga. ");
INSERT INTO nys_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Boola moorta kambarn Jesus; mo yoka baalapany kardakor, welweliny wer mariny baalang. ");
INSERT INTO nys_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus korang baalapak kidji waangki, “Yoka Jerusalem-ang! Yoowart weli nganyang, yalga arda weli noonookaal wer noonookang koorlangka. ");
INSERT INTO nys_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Narla kedelara koorliny nginda moorta boorda-waangki. ‘Baalap djoorab-djil, alidja-alidja yoka koorlangka-birt, ngiyan yoowart yanga bibi baalapak!’ ");
INSERT INTO nys_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nidja-nidja kedelara, moorta boorda-waangki kardakak, ‘Djabalar ngalal!’ Kidji moorta boorda-waangki mordakak, ‘Dengkoor ngalany!’ ");
INSERT INTO nys_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ngarl bayinya baalap don noolonga nidja-mokiny nginda boorn won-kin, natj boorda-edjena nginda boorn bitj?” ");
INSERT INTO nys_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Baalap kardjir bandak-barrang koodjal warma mammarapa, koodjal ngakalyanga, dargango boornal Jesus-boongal. ");
INSERT INTO nys_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nginda baalap yoowal-koorl mord, kol-yan ‘Kaat Kwetj’, baalap katj Jesus boorn-yambokal, kidji koodjal ngakalyanga, keny Jesus-ang ngoornmoornal wer keny warma baalang djoowoorlal. ");
INSERT INTO nys_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesus waangki, “Maaman, nyinya-nyinya baalapany! Baalap yoowart kaaditj naatj baalap doniny.” Baalap kwarda boyara walak-yango Jesus-ang bwoka kardakor baalapaal. ");
INSERT INTO nys_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Moorta yaaka bokadja, miyalitjiny. Karro birdiyara Judea-kang yidjan Jesus, “Baal barrang-ngandabat warma moorta, barrang-oola baalany baalroo ngandabat bayinya baal Keny Boolanga-Yira Waangki-Koorl.” ");
INSERT INTO nys_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mammarapa-bakadjiny, baalap kardjir yidjan Jesus. Baalap yoowal-koorl Jesus kidji baalap yanga baalany wara kepa-mardayin, ");
INSERT INTO nys_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kidji waangki baal, “Barrang-ngandabat noonookaal bayinya noonook djelyib moortagang Judea-kang!” ");
INSERT INTO nys_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Baalap boordak nidja-nidja warrinya Jesus-yira: ‘Djelyib moortakang Judea-kang.’ ");
INSERT INTO nys_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Keny ngakalyang waraniny bokadja, baal wara-waangki Jesus, “Noonook Keny Boolanga-Yira Waangki-Koorl, wa? Barrang-ngandabat noonookaal wer ngalany!” ");
INSERT INTO nys_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yalga warma ngagalyang djaat baalany, waangkiny, “Nadjil noonook yoowart wayarn Boolanga-Yira? Baalap Jesus djin-baminy ngalang-djin. ");
INSERT INTO nys_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yalga ngalang djin-baminy darkal, narla ngala barranginy naatj ngala doora-barrang nadjang ngala don; yalga baal don yoowart mingitj.” ");
INSERT INTO nys_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kidji baal waangki Jesus, “Jesus, barrang-dwangka nganyany, nginda noonook korl-koorl nyiny Djelib!” ");
INSERT INTO nys_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus waangki baalany, “Karnayal, ngany noonook warranga nidja kedela, noonook boorda nyiny ngany-yel Boolanga-Yirakang Boodjer-bwora.” ");
INSERT INTO nys_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Boordak malyarak, ngangk nganitj bandjatiny kidji mayart dengkoor mandang boodjer karbalakak; ");
INSERT INTO nys_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kidji ngomon bwoka, waraniny Maya-maya-Kooranyi-bwora, baal djeran-yan koodjal bangkakal. ");
INSERT INTO nys_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesus mardayin mira, “Maaman! Ngany yidja nganyang kangya noonang maara-bwora!” Baal waangki nidja kidji baal wanni. ");
INSERT INTO nys_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Birdiyar mammarapang bakadjiny djinang natj edjena, kidji baal yanganan Boolanga-Yira, waangkiny, “Karnayal, nidja baal kwabba mammarap!” ");
INSERT INTO nys_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Moorta dandjo-koorliny bokadja, miyalitjiny djin-baminy, baalap djinang natj edjena, mandang baalapang korl-koorl koort-wara baalapang karlapak, baminy baalapang ngornda. ");
INSERT INTO nys_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mandang moorta ngiyan kwadja-kaaditj Jesus kidji woonya baalany, wer kardjir yokaman kambarniny baalany Galilee-yen, baalap yaaka boyang kidji baalap miyalitj. ");
INSERT INTO nys_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Keny mammarap yaaka bokadja, Joseph Arimathea-karlap, karlamaya Judea-kang. Baal kwadja keny kwabbadjil, ngwidam mammarap. Baal keny Yoolinakang wer kardjir keny Pharisee-yang, yalga baal yoowart koort-keny baalapang kaaditjiny kidji natj baalap kwadja-don. Baal koort-karni nganaka Boolanga Yirang Boodjer Djelyibiny yoowal-koorlo. ");
INSERT INTO nys_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Baal koorl Pilate-booram kidji ngakaka Jesus-ang yarlin. ");
INSERT INTO nys_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Karro baal ngarda-barrang Jesus-ang yarlin, dengkoor baalany bwoka-bwora, kidji yidja baalany yalya-bwora natj kwadja-biyan-yan djadam boyal kidji yoowart yalga banitja-yan. ");
INSERT INTO nys_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nidja kedela maar-keny kidji Kedela-Kooranyi boordak alikwadjiny. ");
INSERT INTO nys_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yoka kambarniny Jesus Galilee-yen, baalap koorl Joseph-yel kidji baalap djinang Joseph yidja Jesus-ang yarlin yalya-bwora. ");
INSERT INTO nys_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Karro baalap korl-koorl karlap kidji kakatar djilbika wer boyin-bandin yidjo Jesus-ang yarlinal. Kedela-Kooranyikal, baalap bedik-bedik, aliwar Warriny waangki. ");
INSERT INTO nys_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nginda ngank yira koriyat kedelakal, yoka koorl yalyak, kanginy boyin-bandin natj baalap kwadja kakatar. ");
INSERT INTO nys_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Baalap djinang ngomon boya, wort-bilang-yan boonanyen yalyang ");
INSERT INTO nys_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ngarl baalap bwora-koorl; yalga baalap yoowart djinang Birdiyar Jesus-ang yarlin. ");
INSERT INTO nys_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Baalap yaaka bokadja narla nidja dwangka-birgi baalapany. Yilak-yilak koodjal mammarapa yaaka bokadja baalapany-boordak, koodjalang bwoka bandatjiny. ");
INSERT INTO nys_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yoka wayarn-djil. Baalap boni-nanookawin boodjerak. Mammarapa waangki-djinang, “Nadjil noonooka korl-djinang wininy moort kardakor noyitj moorta? ");
INSERT INTO nys_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Baal yoowart nidja! Baal kwadja yiraba-yan! Barrang-dwangka natj baal waangki noonookany Galilee-kal: ");
INSERT INTO nys_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mammarapang Nop djarnyak yidja-yan maara-bwora wara-wara mammarapa, dargang-yan, kidji ngolonga mo kedela, yiraba ngandabatak.’ ” ");
INSERT INTO nys_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Karro yoka barrang-dwangka Jesus-ang warrinya. ");
INSERT INTO nys_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Baalap korl-koorl yalyayen maar-djen-keny ngooldjarak wer warma moorta ngiyan kambarn Jesus, kidji baalap warranga baalapany mandang nidja-nidja noolonga. ");
INSERT INTO nys_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Alidja-alidja yoka, Mary Magdalene, Joanna, wer Mary James-ang ngaangk, wer yoka warma baalapyel, baalap warranga mandang nidja-nidja noolonga ngooldjarak. ");
INSERT INTO nys_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yalga ngooldjarang miyalakal, moodlooka yoka waangki arda balbayit-waangkiny, kidji baalap yoowart djinang karnany. ");
INSERT INTO nys_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yalga Peter yiraba kidji yakoorl yalyak; baal darba kidji djinang bwoka noyitjang yalga yoowart warma noolong. Karro baal korl-koorl, kardi narla moodlookang natj kwadja-edjena. ");
INSERT INTO nys_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kedela-djin, koodjal mammarap ngiyan kambarn Jesus-any, baal korl-koorliny karlap Emmaus-al, marridja keny karbalang Jerusalem-yen. ");
INSERT INTO nys_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Koodjal dandjo-waangkiny mandang noolongang natj kwadja-edjena. ");
INSERT INTO nys_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Alimarn baalap dandjo-waangkiny, Jesus baalaal boordak-koorl kidji yana koodjalyel. ");
INSERT INTO nys_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Koodjal djinang baalany, yalga koodjal yoowart kaaditj nidja baal Jesus. ");
INSERT INTO nys_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesus waangki koodjalany, “Nadjang nyootjoowal waangkinyang, dandjo-yaniny?” Koodjal nganitj yaniny kidji koodjalang moolyimari koort-wara. ");
INSERT INTO nys_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Keny koodjalang, Cleopas, waangki-djinang Jesus, “Noonook arda keny moort Jerusalem-al ngiyan yoowart kaaditj noolonga natj kwadja-edjena Jerusalem-bwora nidja-nidja keny-keny kedelara, wa?” ");
INSERT INTO nys_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Natj noolonga?” baal waangki-djinang. “Moodlooka natj edjena Jesus-ak Nazareth-karlap,” koodjal waangki. “Nidja mammarap nyiny Warda-Marridjiny. Moodlooka baal don wer waangki kwadja-moorditj wer mardayin moortakang miyalal wer Boolanga-Yirang miyalal. ");
INSERT INTO nys_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ngalang Birdiyara Yakina-Koorany wer warma birdiyara waangki-koorl baalany barrango warrinya noyitjang, kidji baal kwadja-dargang-yan boorn-yambokal. ");
INSERT INTO nys_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kidji ngala kaaditj ngalang koortal baal nyiny Keny ngiyan boorda yalkaranan Israel! “Yoowart arda alidja, yeyi mo kedelara ngolonga nidja edjena, ");
INSERT INTO nys_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","keny-keny yoka kardakor ngalang moorta, baalap kardi ngalany. Nginda ngank yira, baalap koorl yalya, ");
INSERT INTO nys_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","yalga baalap yoowart djinang Jesus-ang yarlin. Baalap korl-koorl ngalak, waangkiny baalap djinang djin-djina-kooranyi ngiyan warranga baalapany alidja Jesus wininy! ");
INSERT INTO nys_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Keny-keny ngalang moorta koorl yalya kidji baalap djinang moodlooka, war-djin yokaman waangki, yalga baalap yoowart djinang Jesus.” ");
INSERT INTO nys_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Karro Jesus waangki baalapany, “Balbayit-djil noonookang! Noonookang dabak-djil djinango-karni moodlooka, noolonga Warda-Marridjinya waangki! ");
INSERT INTO nys_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Koriyat, Keny Boolanga-Yira Waangki-Koorl, baal djarnyak bakkan-wara nidja-nidja noolonga, wa? Arda karro, baal kayar-kadak ngandabat, baalang moorditj wer banditjiny ngandabat.” ");
INSERT INTO nys_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kidji Jesus warranga baalapany moodlooka natj Boordakiny-Kooranyi waangki baalang, koriyat Moses kidji karro mandang Warda-Marridjinya. ");
INSERT INTO nys_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Baalap boordak-koorl baalapang karlap, yalga Jesus malyak wort-yaniny. ");
INSERT INTO nys_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Koodjal nganitj baalany, waangkiny, “Naan-yaaka ngalyel! Ngangk ngardiny kidji kadik-bini.” Ngarl Jesus bwora-koorl, naan-yaakiny koodjalyel. ");
INSERT INTO nys_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jesus nyiny ngarno koodjalyel. Baal barrang mereny, kidji yanganan Boolang-Yirany, karro baal djakarn mereny kidji yanga mereny koodjalak. ");
INSERT INTO nys_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Karro koodjalang miyala yalgaran-yan kidji koodjal djinang nidja baal Jesus. Yalga yilak-yilak, baal wort-koorl koodjalang miyalayen. ");
INSERT INTO nys_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Koodjal danjo-waangki, “Nginda Jesus waangki ngalany djoorootal kidji yalgaran Boordakiny-Kooranyi ngalak, baalang warrinya karla-mokiny, narriny ngalany-bwora.” ");
INSERT INTO nys_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Koodjal yilak-yilak yiraba kidji korl-koorl Jerusalem. Koodjal djinang maar-djen-keny ngooljdara, wer mandang warma moorta. ");
INSERT INTO nys_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Baalap waangkiny, “Birdiyar doora kwadja-yiraba! Jesus barrang-djinang baalaal Simon-ak!” ");
INSERT INTO nys_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Karro koodjal mammarapa warranga baalapany moodlooka natj kwadja-edjena djoorootal, kidji yarn koodjal doora djinang Birdiyarany nginda baal djakarn mereny. ");
INSERT INTO nys_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Alimarn koodjal mammarap warranga baalapany nidja, Jesus yaaka baalapany kardakor, kidji baal waangki, “Nakal noonookayel!” ");
INSERT INTO nys_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Baalap darnayan-djil, kaaditjiny baalap djinanginy keny djang. ");
INSERT INTO nys_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yalga Jesus waangki baalapany, “Naadjil noonooka wayarn? Nadjil noonooka yoowart djinang-karni noonookang koortal? ");
INSERT INTO nys_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Djinang nganyang maara wer djena. Miyalitj! Nidja nganyany, nganyaal! Baka nganyany, kidji noonooka boorda-kaaditj, narla djanga yoowart kadak yarlin wer kwetja, yalga noonook kayar-djinang nganyang yarlin!” ");
INSERT INTO nys_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jesus waangki nidja kidji baal barrang-djinang baalapany baalapang maara wer djena. ");
INSERT INTO nys_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yalga baalap yoowart kayar-djinang-karni. Baalap koort-kwabba-djil wer kai-kai-djil; ngarl Jesus ngakaka baalapany, “Noonooka kadak mereny ka djaadj ngarno, wa?” ");
INSERT INTO nys_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Baalap yanga Jesus bangka djildjitang dookarn-yan. ");
INSERT INTO nys_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Baal kanga djildjit kidji ngarn baalap-booram. ");
INSERT INTO nys_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Karro baal waangki baalapany, “Karnayal, ngany warranga noonookany nidja-nidja noolonga nginda ngany yalga kwadja-nyiny noonookayel: moodlooka boordak-yan nganyang Moses-ang Warriny-bwora, boordakiny Warda-Marridjinyang, wer Yediga-bwora; moodlooka natj djarnyak edjena.” ");
INSERT INTO nys_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Karro Jesus yalkaran baalapang kaaditjiny djinango moodlooka, mandang noolonga Boordakiny-Kooranyi waangki. ");
INSERT INTO nys_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Karro Jesus warranga baalapany, “Nidja kwadja-boordak-yan: ‘Keny Boolanga-Yira Waangki-Koorl, baal djarnyak bakkan-wara kidji ngolanga mo kedela, baal djarnyak yiraba noyitjyen.’ ");
INSERT INTO nys_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kolal Jesus-ang, Warda-Kwabba djarnyak warranga-yan, Warda-Kwabba nyinya-nyinyinyang nginda moorta wort-korang baalapang wara-doniny. Nidja djarnyak warranga-yan, kooramba Boodjaral, malyakiny Jerusalem-bwora. ");
INSERT INTO nys_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Noonooka kwadja-marlanga-bini mandang nidja-nidja noolongang. ");
INSERT INTO nys_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kidji karnayal, ngany nganyaal boorda-waangki-koorl noonookak moodlooka, mandang noolonga nganyang Maaman kwadja-waangki. Yalga noonooka djarnyak nganaka Jerusalem-bwora, kedalak nginda moorditj mardayin yirayen boorda ngarda-koorl noonookal.” ");
INSERT INTO nys_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Karro Jesus barrang baalapany Jerusalem-bandak, Bethany-boordak. Bokadja, baal yira-barrang baalang maara kidji baal yanga-kwabba baalapany. ");
INSERT INTO nys_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Alimarn Jesus yanga-kwabbiny baalapany, baal wort-koorl baalapyen kidji baal yira-barrang-yan Boolanga-Yirang Boodjerak. ");
INSERT INTO nys_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Baalap yanga moorditj yanganan Jesus-any, kidji korl-koorl Jerusalem-bwora, kidji koort-kwabba-djil moorartitj baalapany. ");
INSERT INTO nys_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yennar kedelara, baalap koorl Maya-maya-Kooranyi-bwora, yanganiny Boolanga-Yira. ");
ALTER TABLE nys_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
