﻿USE sofia;
DROP TABLE IF EXISTS sofia.nyf_vpl;
CREATE TABLE nyf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nyf_vpl WRITE;
INSERT INTO nyf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Bai aa ndo at'u a lukolo arilombola Jesu Masihi. Jesu Masihi wambola kahi za lukolo lwa Daudi, na Daudi naye akimbola kahi za lukolo lwa Burahemu. ");
INSERT INTO nyf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Burahemu wamuzhala Isaka. Isaka akimuzhala Jakobu. Jakobu akimuzhala Juda na nduguze a kilume. ");
INSERT INTO nyf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda akimuzhala P'erezi na Zera (mameye P'erezi na Zera were anaifwa T'amari). P'erezi, akimuzhala Hezironi. Hezironi, akimuzhala Aramu. ");
INSERT INTO nyf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramu, akimuzhala Aminadabu. Aminadabu, akimuzhala Nashoni. Nashoni akimuzhala Salimoni, ");
INSERT INTO nyf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni akimuzhala Boazi (mameye Boazi were anaifwa Rahabu). Boazi, akimuzhala Obedi (mameye Obedi were anaifwa Ruth'u). Obedi, akimuzhala Jese, ");
INSERT INTO nyf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","babaye muthawali Daudi. Daudi akimuzhala Selemani, (ho kwandza mameye Selemani wakala ni mukaza Uria). ");
INSERT INTO nyf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemani naye akimuzhala Rehoboamu. Rehoboamu akimuzhala Abija. Abija akimuzhala Asafu. ");
INSERT INTO nyf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafu akimuzhala Jehoshafati. Jehoshafati akimuzhala Joramu. Joramu akimuzhala Uzia. ");
INSERT INTO nyf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia akimuzhala Jothamu. Jothamu akimuzhala Ahazi. Ahazi akimuzhala Hezekia. ");
INSERT INTO nyf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia akimuzhala Manase. Manase akimuzhala Amoni. Amoni akimuzhala Josia. ");
INSERT INTO nyf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia akimuzhala Jekonia na nduguze a kilume makathi Ayahudi marihokala manahalwa mateka kwenda Babiloni. ");
INSERT INTO nyf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bada ya kuhalwa mateka kwa Ayahudi kugoma, Jekonia akimuzhala Salathieli. Salathieli akimuzhala Zerubabeli. ");
INSERT INTO nyf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabeli akimuzhala Abiudu. Abiudu akimuzhala Eliakimu. Eliakimu akimuzhala Azori. ");
INSERT INTO nyf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori, akimuzhala Zadoki. Zadoki akimuzhala Akimu. Akimu akimuzhala Eliudi. ");
INSERT INTO nyf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi akimuzhala Eliazari. Eliazari akimuzhala Mathani. Mathani akimuzhala Jakobu. ");
INSERT INTO nyf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Na Jakobu akimuzhala Josefu. Josefu nde ariyekudzakala mulume wa Maryamu, mameye Jesu. Na Jesu nde iye Masihi. ");
INSERT INTO nyf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kwa vizho kula Burahemu hatha muthawali Daudi, kwakala na vizhazi kumi na vine. Na kula Daudi hatha kuhalwa mateka kwa Ayahudi kuhirikwa Babiloni, kukikala na vizhazi kumi na vine kaheri. Na kula wakathi wa kuhalwa mateka kwa Ayahudi kuhirikwa Babiloni hatha kuzhalwa kwa iye Masihi, nako kukikala na vizhazi kumi na vine. ");
INSERT INTO nyf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Vikara kuzhalwa kwa Jesu Masihi kwakala vivi: Maryamu ariye were andakala mameye Jesu were analolwa ni Josefu, ela kabila k'adzamuhala, akimanywa kukala ana mimba kwa nguvu za Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Bai kwa kukala Josefu were ni mut'u muhachi k'ahendzeze kumugwiza aibu muchewe mbere za at'u bule, waona ni baha amuriche kisiri-siri. ");
INSERT INTO nyf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Vikara arihokala achere kuviaza, lola malaika wa Bwana akimwambolera ndosoni akimwamba, “Josefu mwana wa Daudi, sogohe kumuhala mucheo Maryamu, mana yo mimba ariyo nayo be waipata kwa nguvu za Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Naye andazhala mwana mulume, na mwana iye undamwiha Jesu, mana iye nde andeaokola at'ue kula kahi za dambi zao.” ");
INSERT INTO nyf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bai vivi zhosi zhakala ili ro neno ririronenwa ni Bwana kukira kwa nabii rithimire. Kwani nabii wanena akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Lolani, bikira andahenda mimba na andazhala mwana mulume na dzinare andaifwa Imanueli, yani Mulungu hamwenga naswi.” ");
INSERT INTO nyf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Vikara Josefu ariholamuka, akihenda vizho arizhokala adzalagizwa ni ye malaika. Wamuhala Maryamu, ");
INSERT INTO nyf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ela k'alalire naye hatha akimuzhala ye mwana wa kilume. Na Josefu akimwiha Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesu wazhalwa mudzi wa Beth'elehemu, uriwo kahi za jimbo ra Judea, makathi ga muthawali Herode. Vikara Jesu arihozhalwa, lola kwakudza at'u alachu kuko mudzi mubomu wa Jerusalemu. At'u aa were madzambola ts'i za mwambolero wa dzuwa. ");
INSERT INTO nyf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bai marihofika Jerusalemu mauza, “Yuno muthawali wa Ayahudi ariyezhalwa a hiko? Kwani fwayona yo nyenyezi ya kwakwe kuko mwambolero wa dzuwa, naswi hudzire humuvoye.” ");
INSERT INTO nyf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bai muthawali Herode hamwenga na at'u osi a Jerusalemu mabudzyika sana marihosikira uv̱oro uwo. ");
INSERT INTO nyf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Na kwa ut'u uwo, Herode akiaiha alombi abomu na alimu a Sheria a Kiyahudi, akiauza kala Masihi were andazhalwa hiko. ");
INSERT INTO nyf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Makiamba, ni Beth'elehemu, mudzi uriwo Judea. Kwani vizho ndo nabii arizhoora akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Mudzi wa Beth'elehemu kahi za ts'i ya Juda, si mudzi muthithe kamare kahi za athawali a Juda; kwani kula kuko kundambola muthawali andiyekala murisa wa at'u a kwangu, Aiziraeli.” ");
INSERT INTO nyf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herode arihosikira viryahu, akiavuha k'anda aryahu at'u alachu akiauzat'o wo wakathi irihombolera yo nyenyezi. Nao marihogonya kumwambira, ");
INSERT INTO nyf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","akiahuma ko Beth'elehemu, akiamba, “Kauzeni-uzeni hatha mumone. Mukikala mudzamona, ndzoni munambire, ili nami nende nikamuvoye.” ");
INSERT INTO nyf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Bai Herode arihogonya kunena nao, o at'u alachu makigwira ngira ya kwenda Beth'elehemu. Na lola mo ngirani, yo nyenyezi mariyoyona ko mwambolero wa dzuwa ikiambolera kaheri, nao makifwahirwa zhomu kuyona kaheri. Bai nyenyezi iyo yaalongoza hatha ichendaima haho arihokala ye mwana mutsanga. ");
INSERT INTO nyf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bai marihongira mo nyumbani machendamona ye mwana mutsanga na mameye, makimuzamira makimuvoya. Gonya makivugula mikoba yao, makimunosa dhahabu, na uvumba, na manemane. ");
INSERT INTO nyf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bai marihokala madzagonya kumunosa, Mulungu akiaonya kahi za ndoso kukala masiuye kwa Herode bule. Kwa vizho makiuya kwao na ngira nyingine. ");
INSERT INTO nyf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Vikara marihokala aryahu at'u alachu madzakwenda, lola malaika wa Bwana akimwambolera Josefu ndosoni akimwamba, “Herode, anamumala ye mwana amwalage. Kwa vizho, uka umuhale ye mutsanga na mameye, muchimbirire Misiri. Kakaleni kuko vivii hatha ho nindihomwamba muuye.” ");
INSERT INTO nyf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josefu ariholamuka, akimuhala ye mutsanga na mameye, makigwira ngira na usiku, sio, machenda Misiri. ");
INSERT INTO nyf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bai makala kuko Misiri hatha Herode akifwa, ndo makiuya. Na vivi zhosi zhakala ili riryahu neno ririronenwa ni Mulungu kukirira kwa nabii rithimire. Kwani nabii wanena akiamba, “Namwiha Mwanangu kula Misiri.” ");
INSERT INTO nyf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Vikara Herode arihoona kukala aryahu at'u alachu mamuv̱urya, watsukirwa zhomu na akihuma shikari Beth'elehemu na midzi iriyo k'anda-k'andaze makalage ahoho osi a kilume a kula miaka miri kwenda ts'ini. Vivi wavihenda kulingana na haho nyenyezi irihombolera, here arizhoambirwa ni o at'u alachu. ");
INSERT INTO nyf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Vivi zhahendeka kwamba ro neno ririronenwa ni nabii Jeremia rithimire. Kwani Jeremia wanena akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kwasikirwa k'ululu kuko Rama; mut'u anarira zhomu na kuthapathapa, Raheli anakakwa ni anae. Atsosha kunyamazwa k'anyamala, andanyamaladze bai, naye k'andaaona kaheri?” ");
INSERT INTO nyf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Bai Josefu wakala Misiri vivii hatha Herode anafwa, lola malaika wa Bwana akimwambolera ndosoni ");
INSERT INTO nyf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","akimwamba, “Uka umuhale ye muhoho na mameye muuye ts'i ya Iziraeli kwani o mariokala manamala roho ya ye muhoho mafwa.” ");
INSERT INTO nyf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kwa vizho Josefu akiuka akimuhala ye mwana na mameye makiuya Iziraeli. ");
INSERT INTO nyf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Arihofika Iziraeli, Josefu akisikira kukala Arikelao mwana wa Herode nde athawalaye Judea hat'u ha babaye. Kwa vizho akigoha kuuya ko kwao Judea. Bai Mulungu akimwambolera kahi za ndoso akimwamba ende jimbo ra Galilaya, naye akihenda vizho. ");
INSERT INTO nyf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Arihofika Galilaya, Josefu wakwendatoa kahi za mudzi uifwao Nazareth'i. Vivi zhakala ili ro neno ririronenwa ni manabii dzulu za iye Jesu, rithimire. Kwani manabii manena makiamba, “Andaifwa Munazareth'i.” ");
INSERT INTO nyf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bai bada ya miaka ya kuthala, kwambola mwanamulume ariyekala anaifwa Johana Mubat'izaji. Johana wahubiri ko nyika ya Judea na kuamba, ");
INSERT INTO nyf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Thubuni, kwani uthawali wa mulunguni udzafika hehi.” ");
INSERT INTO nyf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yuyu Johana ndiye ariyeambwa ni nabii Isaya haryahu arihonena akiamba, “Mut'u analuta mumirowe ko nyika na kuamba, ‘Mutengezereni ngira Bwana, Mutengezereni ngira ya kugoloka.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Valo ra Johana were ni ra nyoga za ngamira. Na wakala akidzifunga ukanda wa k'ingo chununi mwakwe. Chakuryache were ni kw'eth'eth'e na uchi wa nyuchi. ");
INSERT INTO nyf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","K'uzhona zho, at'u osi a Jerusalemu na a midzi mingine yosi ya Judea, na at'u osi mariokala makitoa kahi za midzi iriyo k'anda-k'anda za muho wa Jorodani marihovisikira, bagabaga makimuthuwa. ");
INSERT INTO nyf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nao maziungama dambi zao, na Johana akiabat'iza kahi za wo muho wa Jorodani. ");
INSERT INTO nyf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ela arihokala anaenderera kubat'iza, kukidza Mafarisayo na Masadukayo anji, nao makikala madzirebat'izwa. Bai Johana arihoaona, akiadumulira akiamba, “H'enwi kizhazi cha nyoka nwi! Ni h'ani ariyemwambira kukala muzichimbire zo k'oro za Mulungu zidzazo? ");
INSERT INTO nyf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","H'aya mahendo genu naganyese kukala mudzathubu dambi jeri. ");
INSERT INTO nyf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na musidzikenge bule mukaamba mu ana a Burahemu. Kwani namwambira kamare kukala, Mulungu anadima kumuumbira ana Burahemu hatha kula kwa gaga mawe! ");
INSERT INTO nyf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na vivi be tsoka ri ho kolo kare, na kila muhi usiwozhala matunda madzo, undathemwa utsufwe mohoni. ");
INSERT INTO nyf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mino ninamubat'iza kwa madzi kamwe, kunyesa kukala mudzathubu dambi zenu, ela ye andiyekudza nyuma zangu ni mubomu kukira mimi. Kwandza mosi sifika hatha mut'u wa kumuvula virahuzhe. Iye andamubat'iza kwa Roho Mweri na kwa moho. ");
INSERT INTO nyf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Na adzagwirira lungo anahehet'a ngano. Akigonya kuhehet'a andahala yo ngano ayangize lutsagani, gonya ahale wo wiswa autsuhe kahi za moho usiwozima.” ");
INSERT INTO nyf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Bai makathi garyahu Johana arihokala anabat'iza at'u, Jesu wambola jimbo ra Galilaya achenda Jorodani ili naye akabat'izwe ni Johana. ");
INSERT INTO nyf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Vikara Johana arihoona kukala Jesu naye anamala kubat'izwa akimwamba, “Mino namala nibat'izwe ni uwe, we unadza kwangu?” Kwa vizho akikala anamala kukahala kumubat'iza. ");
INSERT INTO nyf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ela Jesu akimudzigidzya akimwamba, “Vihende kwa rero, kwani vizho ndo hundakala hunathimiza hachi yosi.” Johana arihosikira viryahu akikubali kumubat'iza Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bai, Jesu arihokala adzagonya kubat'izwa wambola mo madzini. Bai arihombola thu, lola ko mulunguni kukigunuka, na akiona Roho wa Mulungu anatharamuka here giya hatha akidzamuthulama. ");
INSERT INTO nyf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na lola haho henye mumiro uchambola kula ko mulunguni ukiamba, “Yuyu ni Mwanangu muhendzwi, anifwahizaye.” ");
INSERT INTO nyf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bai Jesu akilongozwa ni Roho na achenda nyika kwendajezwa ni Shethani. ");
INSERT INTO nyf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Wafunga kwa siku mirongo mine, usiku na mutsana na badaye akisikira ndzala. ");
INSERT INTO nyf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Shethani akimuthuwa akimwamba, “Chamba u Mwana wa Mulungu jeri, gambire gaga mawe gakale mikahe.” ");
INSERT INTO nyf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesu akimudzigidzya akimwamba, “Zhaorwa kukala, ‘Mudamu k'andakala moyo kwa mukahe thu, ela kwa kila neno rimbolaro kanwani mwa Mulungu.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Shethani akimuhala hatha kuko mudzi mueri wa Jerusalemu, akimukweza dzulu za wo munara wa ro Hekalu, ");
INSERT INTO nyf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","akimwamba, “Chamba u Mwana wa Mulungu jeri, dzitsuhe ko ts'i, kwani zhaorwa kukala, ‘Andaalagiza malaikae makurinde, mandakwanula na mikono yao, p'ore ukakwala iwe.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesu akimudzigidzya akimwamba, “Zhaorwa kaheri kukala, ‘Usimujeze Bwana Mulunguo bule!’ ” ");
INSERT INTO nyf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","K'uzhona anambola haho, Shethani akimuhala Jesu achenda naye hatha dzulu za murima mure zhomu. Akimwanyesa ts'i zosi za urumwengu na ngumaze. ");
INSERT INTO nyf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Akimwamba, “Ukinizamira ukinivoya, vivi zhosi uzhonazho nindakup'a.” ");
INSERT INTO nyf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","K'ona Jesu akimudzigidzya akimwamba, “Hauke Shethani, kwani zhaorwa kukala, ‘Muvoye Bwana Mulunguo na umuhumikire iye h'akeye!’ ” ");
INSERT INTO nyf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ndo Shethani akimuricha, na lola kukidza malaika makidzamuhumikira. ");
INSERT INTO nyf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bai Jesu wakala ko jimbo ra Judea, ela arihosikira kukala Johana Mubat'izaji wagwirwa achangizwa jela, akikumbola kuko, akiuya Galilaya. ");
INSERT INTO nyf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Arihofika Galilaya, kuko Nazareth'i akikwambola, achendatoa Kaperinaumu. Mudzi uwo, were u k'anda-k'anda ya ziya ra Galilaya, kahi za muhaka wa lalo ra Zabuloni na lalo ra Nafutali. ");
INSERT INTO nyf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Bai Jesu wakwendatoa kuko, ili riryahu neno ririronenwa ni nabii Isaya rithimire. Kwani Isaya wanena akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Lalo ra Zabuloni na lalo ra Nafutali, kulaizira k'anda-k'anda za ziya ra Galilaya, kwenda hatha kuthalala muho wa Jorodani, na ts'i ya Galilaya, kuriko pia kunatoa at'u mario si Ayahudi, ");
INSERT INTO nyf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","at'u mariokala ma kizani, vivi madzaona mulangaza munji. Na at'u mariokala manatoa kahi za lalo ra kivurivuri cha kifwa mulangaza udzang'ala kahikahi zao.” ");
INSERT INTO nyf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Bai kula haho Jesu akikwatya kuhubiri akiamba, “Thubuni, mana uthawali wa mulunguni udzafika hehi.” ");
INSERT INTO nyf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Siku mwenga, Jesu arihokala anatsembera k'anda-k'anda za ziya ra Galilaya, wakwendamuthekeza mut'u na nduguye manatsuha vimia zhao mavuhe makumba, kwani were ni avuhi. Mumwenga were anaifwa Simoni, ariye were pia anaifwa P'et'ero. Ye mungine ye were anaifwa Anderea. ");
INSERT INTO nyf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","K'uzhona arihoaona akiambira, “Nithuwani, nami nindamuhendya mukale avuhi a at'u.” ");
INSERT INTO nyf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Marihosikira vizho thu, Simoni na Anderea makigwaga kare zho vimia zhao makimuthuwa. ");
INSERT INTO nyf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Anala haho achenda hatha anafika ho mbere, achendamuthekeza mut'u na nduguye kaheri. Mumwenga were anaifwa Jakobu, na ye mungine akikala anaifwa Johana. At'u aa were ni ana a Zebedayo. Hatha zho Jesu anendaathekeza, be were manafuma-fuma vimia zhao hamwenga na babiyao mo dauni mwao. Bai Jesu arihoaiha thu, ");
INSERT INTO nyf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jakobu na Johana makimuricha ye babiyao hamwenga na ro dau makimuthuwa Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","K'uzhona zho Jesu ariholaa haho, wadengereka Galilaya yosi, kuhubiri na kufundisha at'u kahi za masinagogi gao dzulu za Uv̱oro Udzo wa uthawali wa mulunguni. Kidza akihoza at'u anji mariokala na makongo na manyonge ga kila namuna. ");
INSERT INTO nyf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kwa ut'u uwo wenye bai, Jesu akihenda nguma kahi za ts'i yosi ya Siria. Na lola at'u makimurehera akongo na anyonge a kila namuna. A p'ep'o, a vitsala, na akuholoza, na osi Jesu akiahoza. ");
INSERT INTO nyf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bai wathuwiwa ni rikundi ribomu ra at'u kila arikokwenda. Kula mumo Galilaya hatha Midzi Kumi. Kula Jerusalemu na Judea yosi na hatha kuvuka muho wa Jorodani. ");
INSERT INTO nyf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lola siku mwenga, at'u anji makala manamudzalira Jesu. Vikara arihoona viryahu, akikwera dzulu za murima akikelesi. Bai anafundzie makimuthuwa kuko. ");
INSERT INTO nyf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Marihofika kuko Jesu wakelesi na akikwatya kuafundisha akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Baha ao akiya kahi za roho, mana uthawali wa mulunguni ni wao. ");
INSERT INTO nyf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Baha ao mario na huzuni, mana mandafarijiwa. ");
INSERT INTO nyf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Baha ao mario ni ap'eho, mana ts'i indakala yao. ");
INSERT INTO nyf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Baha ao mario na ndzala na k'ihu ya hachi, mana mandakushwa. ");
INSERT INTO nyf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Baha ao maaonerao mbazi andziyao, mana nao mandaonerwa mbazi. ");
INSERT INTO nyf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Baha ao mario ni aeri mioyoni mwao, mana mandamona Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Baha ao magwizanyao at'u, mana mandaifwa ana a Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Baha ao mateswao kwa ut'u wa kuhenda hachi mbere za Mulungu, mana uthawali wa mulunguni ni wao. ");
INSERT INTO nyf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Baha ninwi mundiohukanwa, na kuteswa, na kusingizirwa kila namuna ya maut'u mai kwa ut'u wangu mimi. ");
INSERT INTO nyf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Fwahirwani zhomu na kulika, mana zawadi yenu ni bomu kuko mulunguni. Mana vizho ndizho ao at'u marizhoahendera o manabii mariomuthangulia.” ");
INSERT INTO nyf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ninwi be mu munyu wa urumwengu. Vikara munyu ukikala udzauya k'aukoza, undahendwadze hatha ukoze kaheri? Jibu ni k'aufwaha kit'u bule, hatha kazi ni kutsufwa uzhogwe-zhogwe ni at'u. ");
INSERT INTO nyf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ninwi be mu mulangaza wa urumwengu. Mudzi uriwoakwa hat'u kirimani k'aufitsika bule. ");
INSERT INTO nyf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kidza mut'u k'adima kugwiza taa gonya akaribiningiza na muvure, ela nikurika nyambaroni, ili riang'alire at'u osi mo nyumbani. ");
INSERT INTO nyf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kwa vizho ninwi nanwi here mulangaza, ng'alirani kila mut'u, ili at'u magaone mahendo genu madzo na mamulike Babiyenu wa mulunguni.” ");
INSERT INTO nyf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Sioneni kukala nakudzagaluza Sheria ya Musa, na mafundisho ga manabii, hatha! Sidziregagaluza bule, nakudza nigathimize. ");
INSERT INTO nyf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na jeri wenye, kabila mulunguni na ts'i kukira, k'ahana hatha kadono kamwenga ka yo Sheria kandikokira bila kuthimira. ");
INSERT INTO nyf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Na mut'u yoyosi andiyekoseza yo Sheria th'ith'e ya zosi, na aafundishe andziye mahende dzazho arizhohenda iye, andakala mut'u muthithe sana kahi za uthawali wa mulunguni. Ela mut'u andiyethuwa na kuzigwira sheria zosi, na kuafundisha andziye ili nao mazithuwe na kuzigwira, andakala mut'u mubomu sana kahi za uthawali wa mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Namwambira kamare, kala uhachi wenu k'aundashinda uryahu wa Mafarisayo na alimu a Sheria, uthawali wa mulunguni k'amundawangira bule.” ");
INSERT INTO nyf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mwasikira kukala haho kapindi at'u maambwa, ‘Usalage’ na ‘Ukilaga undahukumiwa.’ ");
INSERT INTO nyf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ela mimi ninamwambira kukala, mut'u andemutsukirirwa mwandziwe andahukumiwa. Mut'u andiyemuv̱udhya mwandziwe andashithakiwa kwa ro Baraza ra athumia. Na mut'u andiyemuhukana mwandziwe amwambe, ‘Mut'u u mujinga zhomu uwe!’ andatsufwa kahi za moho wa Jehanamu. ");
INSERT INTO nyf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kwa vizho ukikala mwenye udzakwendamboza sadaka dzulu za cho kijaja cha kulazhira sadaka kiricho kahi za ro Hekalu, na ukumbukire kukala wamuhendera vii mwandziyo, ");
INSERT INTO nyf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","iriche haho kijajani yo sadaka, wende ukapatane na iye mwandziyo kwandza ndo udze uyamboze. ");
INSERT INTO nyf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mut'u akikala anakuhirika kotini, baha mugamarigizire mo ngirani, mana usihohenda vizho, andakufisha kwa jaji, na iye jaji andakulazha kwa shikari wangizwe ndani. ");
INSERT INTO nyf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nami nakwambira ujeri wenye, k'undarichirwa uwe hatha umarigize kuriha p'esa zosi.” ");
INSERT INTO nyf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mwasikira zhanenwa kukala, ‘Usizinge.’ ");
INSERT INTO nyf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ela vivi ninamwambira kukala, mut'u yoyosi andiyemulola mwanamuche na kumumizira mahe, andakala moyoni mwakwe adzagonya kare kuzinga naye. ");
INSERT INTO nyf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Dzitsoro ra mukono wa kurya rikikala rinakuhendya uhende dambi, rishukule uritsuhe. Kwani hatha baha kutsowa kilungo kimwenga kuriko mwiriwo wosi utsufwe Jehanamu. ");
INSERT INTO nyf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mukonowo wa kurya, ukikala unakuhendya uhende dambi utose uutsuhe. Kwani ni baha kutsowa kilungo kimwenga kuriko mwiriwo wosi utsufwe Jehanamu.” ");
INSERT INTO nyf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kahi za Sheria ya Musa zhaambwa kaheri kukala, ‘Mut'u andehendza kumuricha muchewe naamup'e cheti cha kunyesa kukala madzarichana.’ ");
INSERT INTO nyf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","“Ela vivi be namwambira kukala, mut'u andemuricha muchewe kwa sababu yoyosi nyingine, hasihokala uzindzi, anamuhendya ahende dambi ya uzindzi, ahalwaho kaheri. Na kila andiyemuhala ye muche wa kumbola kwa mulume ni muzindzi.” ");
INSERT INTO nyf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mwasikira kukala haho kapindi at'u maambwa, ‘Ukiapa mbere za Bwana usilahe ulongo bule, thimiza kila kit'u undichokala udzakiapa.’ ");
INSERT INTO nyf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ela vivi ninamwambira kukala musiape kamare. Musiape dzulu mulunguni kwa kukala kuko ndo Mulungu ariko, kahi za kihiche cha uthawali. ");
INSERT INTO nyf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Na musiape dzulu za ts'i, kwani ndo hat'uhe ha kuika magulu. Musiapire Jerusalemu, mana ni mudzi wa muthawali mubomu. ");
INSERT INTO nyf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kidza musiape dzulu za kwenu enye kwa kukala k'amudima kuhenda changari ludzere lumwenga lukakala lwiru hedu lwaruhe. ");
INSERT INTO nyf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kwa vizho ukiamba, ‘Ee,’ navikale ndozho jeri. Na ukiamba, ‘Hatha,’ vikale sozho. Zaidhi ya vizho vilaa kwa ye Mui.” ");
INSERT INTO nyf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mwasikira zhaorwa kukala, ‘Mut'u akikubola dzitso nawe mwabole. Akikung'ola dzino nawe mung'ole.’ ");
INSERT INTO nyf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ela vivi be namwambira kukala mut'u akikuhendera vii, usimurihize bule. Mut'u akikupiga kofi nyendze ya mukono wa kurya, mugaluzire yo nyendze nyingine nayo apige. ");
INSERT INTO nyf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mut'u akikushithaki akuhoke k'andzuyo, ro amba naro murichire. ");
INSERT INTO nyf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mut'u akikulazimisha mwende mwendo wa maili mwenga, enda naye maili mbiri zenye. ");
INSERT INTO nyf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mwandziyo akidzakuvoya kit'u hedu akidzakumala p'asha, mup'e, usimulashe bule.” ");
INSERT INTO nyf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Bai Jesu akienderera kufundisha akiamba, “Mwasikira zhanenwa kukala, ‘Muhendze mwandziyo, ela hadhuio mumene.’ ");
INSERT INTO nyf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ela vivi be ninamwambira kukala ahendzeni mahadhui enu, na muavoyere ao mamutesao, ");
INSERT INTO nyf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ili mukale ana a Babiyenu wa mulunguni. Kwani, iye nikurihendya dzuware rikaang'alira adzo na ai na kuarehera v̱ula ahachi hamwenga na athiriri. ");
INSERT INTO nyf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kwani mukiahendza kare o mamuhendzao ninwi, ni ut'u wani udzo mundokala mudzahenda? Kwani hatha athozi a kodi kidza ndo mahendazho. ");
INSERT INTO nyf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kwa vizho ukimulamusa ye nduguyo kare, kurya hadhui ye umuzire, undakala k'uhendere ut'u usha bule, kwani hatha at'u masiomumanya Mulungu nao ndo mahendazho. ");
INSERT INTO nyf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kwa vizho kalani akamilifu, dza zho Babiyenu wa mulunguni arizho mukamilifu.” ");
INSERT INTO nyf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesu akienderera kufundisha akiamba, “Ukihenda ut'u udzo, usinyese at'u kukala udzahenda ut'u udzo, kwani ukidzanyesa Babayo wa mulunguni k'andakunosa chochosi. ");
INSERT INTO nyf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Usendemwaviza mukiya, gonya ukapiga gunda, dza vizho at'u a kudzihendya mahendazho mumo ngira-ngira na masinagogini. Vizho zhosi manavihenda kwa manamala kulikwa, nami namwambira ujeri wenye kukala manoso gao gosi magonya kare kugapata. ");
INSERT INTO nyf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ela uchendamup'a kit'u mut'u mukiya be hatha wo mukonowo wa kumots'o kidza usimanye zho mukonowo wa kurya udzizhohenda. ");
INSERT INTO nyf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Naye Babayo aonaye ga sirini andakunosa.” ");
INSERT INTO nyf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Muvoyaho, musikale here at'u a kudzihendya mahendazho. Kazi yao ni kuima mathanoni hedu masinagogini ili maonewe ni at'u. Bai ujeri wenye at'u dza ao magonya kare kupata mariho gao. ");
INSERT INTO nyf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ela bai, uvoyaho, ngira nyumbani mwako ufunge muryango na umuvoye Babayo ariye sirini, naye kwa kukala anaona ga sirini, andakup'a zawadiyo. ");
INSERT INTO nyf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Muvoyaho musihaye-haye bule, here at'u masiomumanya Mulungu mahendazho. Kwani o manaona makinena maneno manji ndo Mulungu andaasikira. ");
INSERT INTO nyf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hatha, musihende vizho bule. Kwani ye Babiyenu be anamanya zho mumalazho hatha kabila k'amudzavoya. ");
INSERT INTO nyf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bai muvoyaho, voyani vivi: Babiyehu uriye ko mulunguni, dzinaro narikale rieri, ");
INSERT INTO nyf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Uthawaliwo naudze. Mahendzogo nagahendeke kuku ts'i, here gahendekazho ko mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hup'e vivi rero chakurya chehu cha kuhuthosha. ");
INSERT INTO nyf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na uhusamehe makosa gehu, here zho huasamehazho ao mahukoserao. ");
INSERT INTO nyf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na usihuhirike majezoni, ela huokole na ye Mui. ");
INSERT INTO nyf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kwani mukiasamehe at'u mamukosao, na Babiyenu wa mulunguni naye andamusamehe makosa genu. ");
INSERT INTO nyf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ela kala o at'u mamukoserao k'amundaasamehe, ye Babiyenu wa mulunguni naye k'andamusamehe bule.” ");
INSERT INTO nyf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mufungaho musinyese kukala k'amuna furaha dza zho at'u a kudzihendya mahendazho. Kwani o be ni kukundza uso, ili mamanywe kukala madzafunga. Bai namwambira jeri wenye kukala ao mahokera manoso gao kare. ");
INSERT INTO nyf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ela ufungaho, oga uso, gonya udzihake mafuha, ");
INSERT INTO nyf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ili at'u masimanye kukala udzafunga, isihokala Babayo ariye sirini. Bai kwa kukala iye anaona kahi za siri andakup'a zawadi.” ");
INSERT INTO nyf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Musiike akiba zenu kahi za urumwengu uu, zikariwa ni p'oho, na zikagwira k'anga, hedu aivi makadzaziiya. ");
INSERT INTO nyf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hatha bule, ikani akiba zenu mulunguni. Mana kuko k'akuna p'oho a kuzirya, hedu k'anga ya kuzononga-nonga. Kidza k'akuna aivi madimao kubanda na kuziiya. ");
INSERT INTO nyf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwani haho handihokala akibayo, ndo handihokala moyowo.” ");
INSERT INTO nyf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Bai Jesu waenderera kufundisha akiamba, “Matso ndo taa ra mwiri. Kwa vizho kala matsogo ni madzo, mwiriwo wosi nikudzala mulangaza. ");
INSERT INTO nyf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ela kala matsogo ni makongo, mwiriwo wosi nikwadzala kiza. Bai kala wo mulangaza ndani yenu udzagaluka kiza, kiza kicho be hatha k'akina mwandziwe bule. ");
INSERT INTO nyf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","K'akuna adimaye kuahendera kazi mathajiri airi. Kwani akihenda vizho, andamuhendza mumwenga ela ye mungine andamumena. Mumwenga andamuhendera kaziye t'ot'ot'o, ela ye mungine andamuv̱udhya. K'amudima kumuhumikira Mulungu na kuno munahumikira mali.” ");
INSERT INTO nyf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kwa ut'u uwo wenye bai, ninamwambira kukala musihende wasiwasi dzulu za maisha genu na miri yenu, kala mundaryani, hedu mundanwani, hedu mundavalani. Samba uzima udzakira chakurya, na mwiri nawo udzakira nguwo? ");
INSERT INTO nyf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Munawona wo unyama wa kubururuka? K'aurima, na k'auvuna ukangiza lutsagani bule, kidza Babiyenu wa mulunguni anaurisa. H'e seze ninwi murio muna kima kibomu kuukira uwo? ");
INSERT INTO nyf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ni h'ani kahi zenu adimaye kuhenda wasiwasi hatha akangeza ngaa saa mwenga kahi za maishage? ");
INSERT INTO nyf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Na ni kwanoni muna wasiwasi dzulu za nguwo? Hedu lolani go maluwa ga vuweni zho gamerazho. K'agahenda kazi, hedu hatha kudzifumira nguwo. ");
INSERT INTO nyf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ela ninamwambira kukala, hatha Selemani na ushahawe wosi, kidza k'avwaliret'o dza gago maluwa. ");
INSERT INTO nyf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","H'enwi at'u a kuluhiro thithe nwi! Kala Mulungu anadima kuzipamba zo nyasi za vuweni ambazo rero zi haha na machero zinatsufwa mohoni zishe, h'e seze nwi. Samba Mulungu andamuvika zaidhi? ");
INSERT INTO nyf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kwa vizho bai, musithapethape kuamba mundaryani, mundanwani, hedu mundavalani, ");
INSERT INTO nyf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","kwani gago gosi ndo mamalago at'u masiomumanya Mulungu. Ela ninwi musithapethape, kwani Babiyenu wa mulunguni anamanya kare kukala maut'u gago gosi munagamala naye andamup'a. ");
INSERT INTO nyf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ela umaleni uthawali wa kwakwe hamwenga na uhachiwe kwandza, na zho vingine zhosi mundangezezwa. ");
INSERT INTO nyf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bai kwa ut'u uwo wenye, musihende wasiwasi dzulu za maut'u ga machero, kwa kukala siku iyo ya machero be indadzihendera wasiwasi yenye. Kwani kila siku ina thabuze za kuthosha.” ");
INSERT INTO nyf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Bai Jesu waenderera kufundisha akiamba, “Musiahukumu andziyenu, p'ore nanwi mukahukumiwa. ");
INSERT INTO nyf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kwani zho mundizhohumira kuahukumira andziyenu, ndo vindizhohumirwa kumuhukumira ninwi. Cho kipimo mupimiracho andziyenu, ndicho mundichopimirwa ninwi. ");
INSERT INTO nyf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mbona unaona kinyalu kiricho dzitsoni mwa mwandziyo, ela gogo ririro dzitsoni mwako k'urisikira? ");
INSERT INTO nyf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Vidze, unadimadze kumwamba mwandziyo ‘Huma nikwamboze kinyalu,’ na kuno una gogo zima dzitsoni mwako? ");
INSERT INTO nyf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kudzihendyako we! Andza kuromboza ro gogo ririro mo dzitsoni mwako kwandza, ndo undihoonat'o hatha udime kumboza cho kinyalu kiricho dzitsoni mwa mwandziyo.” ");
INSERT INTO nyf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Usihale vit'u vieri ukavip'a k'uro, kwani mandakugalukira makutharure-tharure. Kidza usihale lulu be ukazitsuhira nguluwe, kwani mandazizhoga-zhoga.” ");
INSERT INTO nyf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Voyani nanwi mundagerwa, malani nanwi mundaona, bishani nanwi mundasundulirwa. ");
INSERT INTO nyf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mana kila avoyaye, nikugerwa; kila amalaye, nikuona; na kila abishaye nikusundulirwa. ");
INSERT INTO nyf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Vidze ni h'ani kahi zenu ariye mwanawe akimumala mukahe andamup'a iwe? ");
INSERT INTO nyf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hedu akimuvoya kumba andamup'a nyoka? ");
INSERT INTO nyf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bai kala ninwi at'u ai thu, kidza munamanya kuap'a ana enu vit'u vidzo, h'e seze Babiyenu wa mulunguni, ye si zaidhi? Samba ye andamup'a vit'u vidzo kila andiyemuvoya.” ");
INSERT INTO nyf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ahendereni at'u osi dza zho muhendzazho mamuhendere ninwi, kwani gago ndo mafundisho kahi za Sheria ya Musa, na Maoro ga manabii.” ");
INSERT INTO nyf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ngirani na muv̱irya mufufu, kwani muv̱irya wa kwangirira wangamikini ni mwalamu, na ngiraye i rahisi, na at'u anji ndo mangirirawo. ");
INSERT INTO nyf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Muv̱irya wa kwangirira uzimani ni mufufu na ngiraye nayo ni k'omu, na ni achache madimao kuyona ngira ii.” ");
INSERT INTO nyf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Bai Jesu waenderera kuafundisha anafundzie akiamba, “Dzitsundzeni na manabii a ulongo madzihendyao ap'ore here ng'ondzi, kudzi mioyoni mwao ni athiriri here mbawa av̱ara. ");
INSERT INTO nyf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ela vidze unadima kuhuta zabibu, kula kwa mihi ya miya? Hedu unadima kuhuta t'ini kula kwa mibaruthi? Kwa vizho ao nao mundaamanya kwa matunda gao, ");
INSERT INTO nyf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","kwa kukala muhi mudzo nikuzhala matunda madzo, na muhi mui nawo, nikuzhala matunda mai. ");
INSERT INTO nyf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Muhi mudzo k'audima kuzhala matunda mai, hedu muhi mui ukazhala matunda madzo. ");
INSERT INTO nyf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bai kila muhi usiwozhala matunda madzo, nikuthemwa-themwa ukakundywa moho. ");
INSERT INTO nyf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ndosa namwambira kukala mundaamanya kwa mahendo gao.” ");
INSERT INTO nyf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Bai Jesu akienderera kunena akiamba, “Si osi maniambao, ‘Bwana! Bwana!’ mandangira kahi za uthawali wa mulunguni, ela ni kila andiyehenda mahendzo ga Baba ariye dzulu mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kwani siku iyo ya mwisho anji mandaniamba, ‘Bwana, samba sino fwamboza unabii, na fukimboza p'ep'o kidza fukihenda miujiza minji kwa dzinaro?’ ");
INSERT INTO nyf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nami nindaadzigidzya niambe, ‘Nihaukirani, simumanya bule ninwi ahendi a mai.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesu akienderera kufundisha akiamba, “Mut'u andiyesirikiza gaga maneno gangu na kugagwira, adzahalana na mut'u mumwenga mulachu ariyeaka nyumbaye iweni. ");
INSERT INTO nyf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bai makathi ga v̱ula garihofika, v̱ula ikinya gojogojo, muretho ukidza, gonya luv̱utho nalo lukikira na haho, lukiipiga yo nyumba, ela kwa kukala yatsimbirwa musinji iweni k'aigwere bule. ");
INSERT INTO nyf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ela mut'u andesikira maneno gangu na akale k'andagagwira, adzahalana na mut'u muzuzu ariyeaka nyumbaye dhangadhini. ");
INSERT INTO nyf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bai makathi ga v̱ula garihofika, v̱ula ikinya gojogojo, na muretho ukidza, gonya luv̱utho nalo lukikira na haho lukiipiga. Bai luv̱utho lurihopiga, iryahu nyumba ikigwa na musindo mubomu.” ");
INSERT INTO nyf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","K'uzhona Jesu arihomarigiza kufundisha maneno gaga, ro kundi ra at'u rangalazwa ni go mafundishoge, ");
INSERT INTO nyf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kwani were k'afundisha dza here alimu a Sheria mafundishazho, ela were anafundisha here mut'u mwenye wadimi. ");
INSERT INTO nyf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Vikara Jesu arihokala adzagonya kufundisha, watharamuka kula ho dzulu murimani, na go makundi ga at'u gakikwatya kumuthuwa. ");
INSERT INTO nyf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bai lola hachambola mut'u mumwenga ariyekala ana mahana, akidzapiga mavindi ho mbere za Jesu akiamba, “Bwana, ukihendza unadima ukanihoza!” ");
INSERT INTO nyf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesu akigoloza mukono akimugut'a akimwamba, “Ninahendza, hola.” Na haho na haho kare, ye mut'u akihola. ");
INSERT INTO nyf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bai Jesu akimwamba, “Vivi be usizhambire mut'u bule, ela enda ukamwanyese mulombi, gonya umboze sadaka ya ko kuholako, iryahu ariyolagiza Musa, ili kila mut'u amanye kukala udzahola jeri.” ");
INSERT INTO nyf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Vikara, Jesu arihokala anangira mudzini Kaperinaumu, mubomu mumwenga wa jeshi ra Kirumi wamwendera, akimuvoya akimwamba, ");
INSERT INTO nyf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bwana, muhumiki wangu ni mukongo sana. Vilungozhe zhaholoza na analumwa k'azhadimikika.” ");
INSERT INTO nyf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesu akimudzigidzya akimwamba, “Nidzasikira, nadza nimuhoze.” ");
INSERT INTO nyf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ye mubomu wa shikari akimwamba Jesu, “Bwana, mimi siv̱irya kukala udze wangire nyumbani mwangu, ela nena neno thu, na muhumiki wangu andahola. ");
INSERT INTO nyf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwani mimi nami ni ts'ini za abomu angu, kidza nina shikari mario ts'ini zangu. Nikimwamba mumwenga, ‘Enda hat'u hasiku,’ anenda. Na yoyosi nindiyemwamba ‘Ndzo,’ anadza. Nikimwamba muhumiki wangu ‘Henda ut'u usiku’ anauhenda.” ");
INSERT INTO nyf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesu arihomusikira wangalala, gonya akinena na o at'u mariokala manamuthuwa akiamba, “Ninamwambira ujeri, sidzangwe kuona mut'u mwenye kuluhiro dza riri hatha kahi za ts'i ya Iziraeli. ");
INSERT INTO nyf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nami namwambira kukala, at'u anji mandambola mwambolero wa dzuwa, na mutserero wa dzuwa, madze makelesi hamwenga na Burahemu, na Isaka, na Jakobu chakuryani kahi za uthawali wa mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ela o mariotengezerwa wo uthawali enye, mandatsufwa ko ndze kizani, na kuko kundakala na kurira na kwafuna meno.” ");
INSERT INTO nyf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Arihogonya kunena viryahu, Jesu wamugalukira ye mubomu wa shikari akimwamba, “Enda, navikale here udzizhokuluhira.” Na wakathi uwo wenye ye muhumikiwe akihola. ");
INSERT INTO nyf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesu arihombola haho, wakwenda hatha nyumbani kwa P'et'ero, achendamuthekeza mutsedza wa P'et'ero wa kiche a kitandani, ana homa. ");
INSERT INTO nyf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bai, Jesu wamugut'a wo mukono, na haho henye ro homa rikimuricha, hatha akiuka akimuhikirahikira. ");
INSERT INTO nyf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","K'uzhona dzulo riro, Jesu akireherwa at'u anji mariokala mana p'ep'o. O p'ep'o akiachemera makimbola, na akihoza akongo osi. ");
INSERT INTO nyf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Bai gaga gahendeka, ili garyahu maneno garigonenwa ni nabii Isaya gathimire. Kwani Isaya waamba, “Wagahala manyonge gehu, na akigahoza makongo gehu.” ");
INSERT INTO nyf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesu arihoona ro kundi ra at'u mariokala madzamudengereka, akiaamurisha anafundzie kukala mavuke ro ziya mende nyangamo nyingine. ");
INSERT INTO nyf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kabila k'amadzaandza kuvuka, mwalimu mumwenga wa Sheria akidzamwamba kukala, “Mwalimu, mimi nindakuthuwa kila undikokwenda.” ");
INSERT INTO nyf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ela Jesu akimudzigidzya akimwamba, “Makala gana p'anga, na unyama una vitsunji zhao, ela Mwana wa Mudamu k'ana hat'u ha kuika mbavu.” ");
INSERT INTO nyf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kumbola iye, mwanafundzi mungine akiamba, “Bwana, niricha nikamuzike baba kwandza be nidze nikuthuwe.” ");
INSERT INTO nyf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ela Jesu akimudzigidzya akimwamba, “Nithuwa. Ariche at'u mariofwa mazike nyufu zao.” ");
INSERT INTO nyf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Bai arihogonya kunena, Jesu akingira dauni na anafundzie makimuthuwa. ");
INSERT INTO nyf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Marihofika kahikahi ya ro ziya, lola kukidza luv̱utho lukali, maimbi gakikala ganamala kuridzaza madzi ro dau. Vinakala vizho, Jesu ye tha were arere. ");
INSERT INTO nyf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bai o anafundzi marihoona viryahu machendamulamusa Jesu makimwamba, “Huthizhe Bwana, hunahoha!” ");
INSERT INTO nyf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesu akiamba, “H'enwi at'u a kuluhiro thithe mbona mu aoga.” Akirungarara akiluchemera lo luv̱utho na go maimbi, nazho hu vikihurira. ");
INSERT INTO nyf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bai marihoona vizho, o anafundzi makingalala zhomu makiamba, “Ni mut'u ariyedze yuno! Hatha luv̱utho na maimbi kidza nazho vinamusikira!” ");
INSERT INTO nyf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesu na anafundzie marihothima yo nyangamo nyingine, iriyo kahi za ts'i ya Agadari, wadhanwa ni anaalume airi mariokala na p'ep'o. At'u ao were makala makaburini, kidza were ni av̱ara hatha yo ngira ya kuko were k'aikirirwa kaheri kwa ao. ");
INSERT INTO nyf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bai marihomona Jesu anadza, lola makipiga k'ululu makimwamba, “Unani naswi h'ewe Mwana wa Mulungu? Hedu udzire uhutese kare, na wakathi k'audzafika?” ");
INSERT INTO nyf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Vikara ho kimberembere, kure nao vichache, were hanarisa ribadhi ra nguluwe. ");
INSERT INTO nyf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bai, o p'ep'o makimuvoya Jesu makimwamba, “Kala undafwamboza, furiche fukaangire aryahu nguluwe.” ");
INSERT INTO nyf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesu akiadzigidzya, akiamba, “H'aya, endani.” Bai o p'ep'o makiambola o at'u na machendaangira o nguluwe. Lola ro badhi rosi ra nguluwe rikitharamuka malo kula ko ngokani, rikivoromoka mo ziyani, rikifwa. ");
INSERT INTO nyf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kuona vizho, o arisa makichimbira, machangira mumo mudzini, makisema gosi garigokala gadzahendeka kwa o at'u mariokala na p'ep'o. ");
INSERT INTO nyf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Na lola at'u osi kula ko midzini bagabaga makidzamulola Jesu. Bai marihomona makimuvoya kukala akulae kuko kwao. ");
INSERT INTO nyf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Vikara Jesu arihombola kuko, wakwera dau akivuka ro ziya akiuya kwao Kaperinaumu. ");
INSERT INTO nyf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Arihofika kuko lola at'u makimurehera mut'u wa kuholoza ariyekala arere kitandani mwakwe. Bai Jesu arihoona ro kuluhiro rao, akimwamba ye mukongo, “Dzip'e moyo mwanangu, dambizo zidzasamehewa.” ");
INSERT INTO nyf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jesu arihonena vizho, lola angine kahi za o alimu a Sheria makikwatya kunena kimoyo-moyo na kuamba, “Mut'u yuyu be ananena kufuru.” ");
INSERT INTO nyf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ela Jesu akimanya maazo gao, na akiamba, “Mbona muna maazo mai zho? ");
INSERT INTO nyf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kwani, virizho rahisi ni hizho? Ni kumwamba mut'u, ‘Dambizo zidzasamehewa,’ hedu ni kumwamba, ‘Uka wanende?’ ");
INSERT INTO nyf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","H'aya manyani bai, kukala Mwana wa Mudamu ana wadimi wa kusamehe dambi haha dhuniani.” Arihogonya kunena vizho, akimwamba ye mut'u wa kuholoza, “Uka uhale kitandacho wende kwenu.” ");
INSERT INTO nyf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na ye mut'u akiuka, achenda kwao. ");
INSERT INTO nyf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Vikara aryahu at'u marihomona viryahu makiogoha zhomu, na makimulika Mulungu kwa kuap'a anadamu wadimi dza uwo. ");
INSERT INTO nyf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Vikara Jesu arihombola haho, wakwendamona mut'u ariyekala anaifwa Math'ayo. Mut'u yuyu were akelesi kahi za ofisi ya kodi. Bai Jesu arihomona, akimwamba, “Nithuwa.” Math'ayo akirungarara akimuthuwa. ");
INSERT INTO nyf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Badaye Jesu na anafundzie, makwendarya chakurya nyumbani kwa Math'ayo. Na lola athozi a kodi anji na at'u angine mariokala manaonewa kukala ni enye dambi, makudzarya hamwenga nao. ");
INSERT INTO nyf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Vikara Mafarisayo marihoona viryahu, makiauza o anafundzie, “Mbona ye mwalimu wenu anarya chakurya na athozi a kodi hamwenga na enye dambi?” ");
INSERT INTO nyf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesu arihosikira vizho akiamba, “Mukongo nde mwenye haja na muganga, ela muzima k'ana haja na muganga bule. ");
INSERT INTO nyf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hedu garya Maoro gaambago, ‘Sadaka zenu sizendzi, nimalazo ni mbazi,’ manaye ni noni? H'aya kagashomeni mugamanye manaye. Mimi nakudzaaiha enye dambi, sidzireaiha enye hachi!” ");
INSERT INTO nyf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Siku mwenga, anafundzi a Johana makwenda kwa Jesu, machendamuza makimwamba, “Ni kwanoni sino na Mafarisayo hunafunga, ela anafundzio o k'amafunga?” ");
INSERT INTO nyf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Bai Jesu akiadzigidzya akiamba, “Vidze ajeni a harusini nikukala na sumazi wakathi bwana harusi manaye haho? Ela siku zinadza, ambazo ye bwana harusi andauswa kahikahi zao, na haho mandafunga. ");
INSERT INTO nyf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","K'ahana mut'u adimaye kuhala nguwo ya kapindi akayangiza kiraka kisha, mana cho kiraka kindayamola yo nguwo chambole, na kindaihendya ikale na t'undu bomu kukira iyo ya chaho. ");
INSERT INTO nyf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kidza, divai mbisha k'aingizwa kahi za viriba zha kapindi. Kwani ikingizwa, indavipashula zho viriba imwagike. Bai zho viriba vindakala vidzanongeka, na yo divai nayo indakala idzamwagika. Ela divai mbisha ingizwa kahi za viriba visha, na k'ahana kindichonongeka.” ");
INSERT INTO nyf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Bai Jesu arihokala achere kunena, lola mubomu mumwenga wa Kiyahudi, akidzamupigira mavindi akimwamba, “Bwana, musichana wangu ala kufwani, hinde ukamuikire mukono naye andafufuka.” ");
INSERT INTO nyf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesu arihosikira vizho, iye hamwenga na anafundzie makiuka makimuthuwa. ");
INSERT INTO nyf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Vikara lola, kahi za ro kundi ra at'u mwere muna mwanamuche mumwenga ariyekala adzakala mukongo wa kumbola milatso kwa miaka kumi na miri. Bai mwanamuche yuyahu wamuthuwa Jesu ko nyuma kuno ananena kimoyo-moyo na kuamba, “Nikigut'a ro valore thu, nindahola.” K'ona akigut'a wo mutsa wa ro valore. ");
INSERT INTO nyf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bai ye mwanamuche arihogut'a ro valo, Jesu akigaluka, na arihomona akimwamba, “Dzip'e moyo mwanangu, kuluhiro ra kwako ridzakuhoza.” Na ye mwanamuche akihola haho na haho. ");
INSERT INTO nyf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesu arihofika ko nyumbani kwa ye mubomu wa sinagogi, wakwendathekeza at'u anji. Arya manarira, na arya manapiga vivoti. Bai akiamboza mumo nyumbani akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Mbolani, kwani ye musichana k'afwere bule, arere thu.” Kusikira vizho at'u makimutseka. ");
INSERT INTO nyf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bai aryahu at'u marihokala madzagonya kumbola, Jesu achangira ndani, na achendamugwira mukono iye mufwa, naye haho na haho kare akiuka. ");
INSERT INTO nyf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na lola uv̱oro uwo ukitsamuka lalo zima. ");
INSERT INTO nyf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Vikara Jesu arihokala anambola kuko, wathuwiwa ni anaalume airi vipofu, makiluta mimiro yao makimwamba, “Mwana wa Daudi, huonere mbazi!” ");
INSERT INTO nyf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bai Jesu wathuwa kwenda hatha anangira nyumbani, vipofu nao thia. Akiauza akiamba, “Vidze munakuluhira kukala nadima kumuhoza?” Makiamba, “Ee, funakuluhira Bwana.” ");
INSERT INTO nyf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Bai Jesu akiagut'a go matso, gonya akiamba, “H'aya navikale here mukuluhirazho.” ");
INSERT INTO nyf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na lola arihonena vizho thu, matso ga o vipofu gakigunuka na makikwatya kuona. Bai Jesu akiakokot'era zhomu zhenye kukala masizhambire mut'u. ");
INSERT INTO nyf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ela marihouka haho, machendavitsamusa kahi za lalo zima. ");
INSERT INTO nyf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Vikara marihokala makuukani, lola Jesu akireherwa mut'u ariyekala wapagawa ni p'ep'o. Mut'u yuyu were ni bwibwi. ");
INSERT INTO nyf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bai, Jesu akimwamboza ye p'ep'o na ye bwibwi akikwatya kunena. Bai zhaangalaza at'u anji sana hatha makikwatya kunena h'akiyao na kuamba, “Zho zha bwibwi kunena k'ahudzazhona bule kahi za ts'i ya Iziraeli!” ");
INSERT INTO nyf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ela Mafarisayo makiamba, “Yuyu anamboza p'ep'o kwa kuhumira nguvu za mubomu wa p'ep'o.” ");
INSERT INTO nyf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Bai Jesu wadengereka kurya na kurya, kahi za midzi mibomu na mithithe, kufundisha kahi za masinagogi, na kuhubiri Uv̱oro Udzo wa uthawali wa mulunguni, na kuhoza akongo na anyonge a kila namuna. ");
INSERT INTO nyf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ela arihoona go makundi ga at'u, waalola na akiaonera mbazi, kwa viryahu marizhokala manasirima na k'amamanya mahendedze, here ng'ondzi zisizo na murisa. ");
INSERT INTO nyf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Bai akiagalukira anafundzie akiambira, “Mavuno ni manji, ela ahendzi a kazi ni achache. ");
INSERT INTO nyf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kwa vizho bai muvoyeni ye Bwana wa mavuno, ahume ahendzi a kazi madze mavune.” ");
INSERT INTO nyf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Bai Jesu akiaiha aryahu anafundzie kumi na airi na akiap'a wadimi wa kumboza p'ep'o na kuhoza makongo na manyonge ga kila namuna. ");
INSERT INTO nyf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ahumwi ao were ni Simoni ariyekala akiifwa P'et'ero na nduguye aifwaye Anderea. Angine were ni Jakobu na Johana, ambao were ni ana a Zebedayo, ");
INSERT INTO nyf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipu, Bath'olomayo, T'omasi, na Math'ayo ariyekala muthozi wa kodi. Angine mere ni Jakobu mwana wa Alifayo, na Th'adayo, ");
INSERT INTO nyf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","na Simoni Muhehezi, na Juda Isikariote ariye nde ariyemusaliti Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Vikara Jesu waahuma aa anafundzie kumi na airi akiamba, “Musendeni kwa at'u mario si Ayahudi, hedu hatha kahi za midzi ya Asamaria. ");
INSERT INTO nyf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ela endani kwa Aiziraeli, ziryahu ng'ondzi zangu zirizongamika. ");
INSERT INTO nyf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Endani mukihubiri mukiamba, uthawali wa mulunguni udzafika hehi. ");
INSERT INTO nyf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hozani mahana na makongo mangine, fufulani nyufu, na mbozani p'ep'o. Gaga gosini gahendeni bule renye, mana zo nguvu za kuhendera maut'u gaga hatha ninwi mwazigerwa bule. ");
INSERT INTO nyf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Vikara kala munenda, musitsukule akiba yoyosi ya p'esa mabindoni mwenu. ");
INSERT INTO nyf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Musitsukule mukoba, hedu k'andzu mbiri, hedu virahu zha kugaluza, hedu mudhath'a mo charoni.” “Muhendzi wa kazi av̱irya kupata p'oshoye. ");
INSERT INTO nyf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mundihongira kahi za mudzi wowosi, lolani mut'u mudzo andiyemukaribisha na mukale ho hakwe hatha muuke vizho. ");
INSERT INTO nyf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Na mundihongira kahi za mudzi wowosi, lamusani muambe, ‘Dheri narikale kahi za mudzi uu.’ ");
INSERT INTO nyf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na kala mudzi uwo ni mudzo jeri, dheri renu narikale kahi za mudzi uwo. Ela kala mudzi uwo si mudzo, dheri renu narimuuyire. ");
INSERT INTO nyf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na mudzi wowosi, hedu mut'u yoyosi andiyekahala kumukaribisha, hedu hatha kusikiza gago mundigokala munamala kuganena, kut'ani-kut'ani nyayo zenu, gonya muhauke. ");
INSERT INTO nyf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kwani namwambira kamare kukala yo siku ya hukumu vindakala vii-vii zhomu kwa mudzi uwo, kukira zho vindizhokala kwa midzi ya Sodomu na Gomora.” ");
INSERT INTO nyf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Lolani, ninamuhuma here ng'ondzi kahikahi za mbawa. Kwa vizho bai kalani alachu here nyoka, na mukale ap'eho here magiya. ");
INSERT INTO nyf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Dzimanyirireni kwani at'u mandamugwira mamuhirike manenoni na mamupige mo masinagogini mwao. ");
INSERT INTO nyf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mundagwirwa muhirikwe mbere za maluwali na mbere za athawali kwa ut'u wangu, nanwi mundakwenda mukamboze ushuhuda dzulu zangu mbere zao, na mbere za at'u mario si Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mushithakiwaho, musithapethape bule kupanga maneno ga kwendanena, kwani gago mundagagerwa wakathi uwo wa kudzihehera. ");
INSERT INTO nyf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwani sinwi mundionena bule, Roho wa Babiyenu ndiye andenena kwa milomo yenu.” ");
INSERT INTO nyf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mut'u andamulazha nduguye mwenye hedu mwanawe mwenye alagwe. Ana nao mandaagalukira azhazi ao enye, maalazhe malagwe. ");
INSERT INTO nyf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nanwi mundamenwa ni at'u osi kwa ut'u wa dzina rangu. Ela andiyevumirira hatha mwisho andaokoka. ");
INSERT INTO nyf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mukiteswa kahi za mudzi uu, chimbirani mwende mudzi mungine, kuko nako mukiteswa, chimbirani mwende mungine. Nami namwambira kamare kukala k'amundaigot'ya bule yo midzi ya Iziraeli kabila Mwana wa Mudamu kudza.” ");
INSERT INTO nyf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mwanafundzi k'adima kumukira mwalimuwe, na mutumwa k'adima kumukira bwanawe. ");
INSERT INTO nyf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Vinathosha kare zho zha mwanafundzi akale here mwalimuwe, hedu mutumwa akale here bwanawe. Vikikala mwenye nyumba mwenye thu, kisha manamwiha Belizebuli, h'e seze nwi adamue?” ");
INSERT INTO nyf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Musiogohe bule, kila kit'u kidzichobiningizwa kindagunulwa, na kila kit'u kidzichofitswa kindaonewa. ");
INSERT INTO nyf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kila nindiromwambira kizani, rineneni lwazu mulangazani. Na kila mundirosikira njamani, ritangazeni zhomu zhenye. ");
INSERT INTO nyf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Musiagohe ao madimao kuwalaga wo mwiri h'akeye, ela roho yo, k'amayadima bule. Mwagoheni iye adimaye kuuhala wo mwiri hamwenga na yo roho, na akavinonga-nonga kahi za Jehanamu. ");
INSERT INTO nyf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Utsongo wiri samba unaguzwa rahisi renye, kidza ko k'ahana hatha kamwenga kadimako kufwa bila Babiyenu kuhendza. ");
INSERT INTO nyf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na hatha zo nyere zenu kidza Mulungu anazimanya isabuye. ");
INSERT INTO nyf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kwa vizho bai musogohe bule, mana ninwi muna th'amani bomu kukira iho ra utsongo. ");
INSERT INTO nyf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kila andiyenikubali mbere za at'u, mimi nami nindamukubali mbere za Baba ariye mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ela kila mut'u andiyenikahala mbere za at'u, nami nindamukahala mbere za Baba ariye mulunguni.” ");
INSERT INTO nyf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Sioneni kukala nakudzareha dheri haha dhuniani, hatha bule, nakudzareha k'ondo. ");
INSERT INTO nyf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kwani nakudzaahendya ana a kilume mathengane na babizao, ana a kiche mathengane na mamizao, na akaza ana mathengane na mizhala zao. ");
INSERT INTO nyf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mahadhui a mut'u mandakala o at'u a nyumbani mwakwe.” ");
INSERT INTO nyf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kila amuhendzaye babaye hedu mameye kunikira mimi, hedu amuhendzaye mwanawe wa kiche hedu wa kilume kunikira mimi, k'av̱irya kukala wangu bule. ");
INSERT INTO nyf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mut'u yoyosi ariye k'andahala musalabawe na kunithuwa, k'av̱irya kukala wangu bule. ");
INSERT INTO nyf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kwani kila andiyeyona rohoye andayangamiza, na andiyeyangamiza rohoye kwa ut'u wangu, andayona.” ");
INSERT INTO nyf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kila mut'u amuhokeraye ninwi, ananihokera mimi, na iye anihokeraye mimi, anamuhokera iye ariyenihuma. ");
INSERT INTO nyf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kila mut'u amuhokeraye nabii kwa kukala ni nabii, andapata zawadi ya nabii, na kila mut'u andiyemuhokera mut'u muhachi, kwa kukala ni muhachi, andapata zawadi ya mut'u muhachi. ");
INSERT INTO nyf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na kila mut'u andiyemup'a mumwenga wa aa at'u athithe, ngaa kikombe cha madzi ga p'eho kwa kukala ni mwanafundzi wangu, jeri wenye mut'u iye k'andakosa zawadiye bule.” ");
INSERT INTO nyf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Vikara Jesu arihokala adzagonya kualagiza o anafundzie kumi na airi, akihauka haryahu arihokala, achangira kahi za midzi mingine ya Galilaya, kuhubiri na kufundisha kuko. ");
INSERT INTO nyf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wakathi uryahu, Johana Mubat'izaji were a jela. Bai arihosikira gago maut'u gosi arigokala akigahenda ye Masihi, wahuma anafundzie makamuze Jesu mamwambe, ");
INSERT INTO nyf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Vidze, we ndiwe yuyahu huriyekala hunamuthariza hedu hutharize mungine?” ");
INSERT INTO nyf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","K'uzhona marihouza viryahu, Jesu akiadzigidzya akiamba, “Uyani mukamwambire Johana gago musikirago na kugaona. ");
INSERT INTO nyf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","At'u masoona manaona, vidende mananenda, akongo a mahana manahozwa, at'u masio na masikiro manasikira, nyufu zinafufulwa, na masikini manahubiriwa Uv̱oro Udzo. ");
INSERT INTO nyf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na baha iye ariye k'andakala na tashwishi dzulu zangu.” ");
INSERT INTO nyf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bai aryahu anafundzi a Johana marihokala makuukani, Jesu akigalukira ro kundi ra at'u akinena dzulu za Johana akiamba, “Harya murihokwenda kurya nyika were mudzakwendalolani? Vidze were mudzakwendalola kirungurungu kinafuswa-fuswa ni lupeho? ");
INSERT INTO nyf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Hedu mwakwendalola mut'u adzevala nguwo mbidzo? Hatha, mavalao nguwo mbidzo k'amakala nyika bule, makala kahi za madzumba ga athawali. ");
INSERT INTO nyf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","H'aya nambirani bai cho murichokwendalola ko nyika. Vidze mwakwendamulola nabii? Ee, ni vizho mwakwendamulola nabii. Nami ninamwambira kamare kukala mwakwendamulola mut'u ariye ni zaidhi ya nabii. ");
INSERT INTO nyf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kwani iye Johana ndiye ariyenenwa kahi za Maoro kukala, ‘Lola ninahuma mujumbe wangu mberezo, andiyekutengezera ngirayo kimbere.’ ");
INSERT INTO nyf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nami namwambira kamare kukala haha urumwenguni be k'ahadzazhalwa mut'u mubomu kumukira Johana, ela ye muthithe mwenye kamare kahi za uthawali wa mulunguni be ni mubomu kumukira ye Johana. ");
INSERT INTO nyf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Na hangu Johana aandze kuhubiri na kubat'iza at'u, wo uthawali wa mulunguni be udzakala ukipigwa viha, na ni o masitao ndo mandiowangira kwa nguvu. ");
INSERT INTO nyf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sheria za Musa na mafundisho ga manabii osi hatha kumufikira Johana ganena dzulu za wo uthawali. ");
INSERT INTO nyf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kwa vizho ahendzaye kukuluhira naakuluhire kukala Johana nde iye Elija ariyekala anatharizwa. ");
INSERT INTO nyf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mwenye masikiro, naasikire.” ");
INSERT INTO nyf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Bai Jesu akienderera kunena akiamba, “Kizhazi kino be tha ndakihalanisha na noni mino? Kidzahalana na ahoho makeresio sokoni. Asena ao manaamba, ");
INSERT INTO nyf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Fudzamupigira vivoti, ela k'amuvinire, hudzamuimbira wira wa hanga, ela k'amuririre kamare.’ ");
INSERT INTO nyf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Johana wakudza haha, akikala k'arya na k'anwa mukiamba kukala ana p'ep'o. ");
INSERT INTO nyf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Vino Mwana wa Mudamu wakudza, anarya na ananwa munamwamba kukala adzatona, kidza ni murevi na musena wa athozi a kodi, na enye dambi angine. Ela ulachu wa Mulungu unamanywa ni wa ujeri, kukirira kwa mahendo ga ao maukubalio.” ");
INSERT INTO nyf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Vikara Jesu akikwatya kuidumulira iryahu midzi ariyo were wakwendahenda miujiza mibomu-mibomu, ela at'u a kuko hatha bada ya kuona miujiza iyo, makikahala kuthubu vizho. ");
INSERT INTO nyf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Bai waamba, “Shauri yenu ninwi at'u a Korazini na Beth'isaida. Kwani kala yo miujiza niriyoihenda ko kwenu be naihenda kahi za midzi ya Tiro na Sidoni be o andziyenu ngere mavala nguwo za magunia, na kukala ivuni kapindi kunyesa kuthubu kwao. ");
INSERT INTO nyf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nami vivi namwambira kamare kukala yo siku ya hukumu vindakala baha o at'u a Tiro na Sidoni kaheri kuriko ninwi. ");
INSERT INTO nyf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nwi at'u a Kaperinaumu nanwi, munaona mundanulwa hatha mulunguni? Hatha bule. Ninwi mundatserezwa hatha kuzimu. Kwani kala yo miujiza iriyohendwa mo mudzini mwenu be yahendwa kahi za mudzi wa Sodomu, ngere Sodomu ichereko hatha rero. ");
INSERT INTO nyf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nanwi vivi namwambira kamare kukala, haho siku ya hukumu be vindakala vii-vii zhomu kwenu ninwi kuriko kwa at'u a Sodomu.” ");
INSERT INTO nyf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","K'uzhona wakathi uwo vizho, Jesu akiamba, “Nakulazhira muv̱era h'ewe Baba, Bwana wa dzulu na ts'i, kwa kukala maut'u gaga wagafitsa alachu na enye akili, ukigagunulira madanga ga ana. ");
INSERT INTO nyf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ni karakara Baba kwa kukala vizho were ndo urizhohendza.” ");
INSERT INTO nyf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Bai arihogonya kulazha muv̱era akiagalukira o at'u akiamba, “Maut'u gosini gaikwa mikononi mwangu ni Baba. K'akuna mut'u amumanyaye ye Mwana asihokala ye Baba, na k'akuna mut'u amumanyaye ye Baba asihokala ye Mwana na aryahu ambao ye Mwana anahendza kuang'azira ye Baba.” ");
INSERT INTO nyf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ndzoni kwangu ninwi nyosi musirimao, na murio mudzaremererwa ni mizigo nami nindamuoyeza. ");
INSERT INTO nyf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Rivaleni gogo rangu, mudzifundishe kwangu, kwa kukala mimi ni mup'eho na mup'ore, nanwi mundaoya kamare kahi za maroho genu. ");
INSERT INTO nyf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwani gogo rangu ni shushu na muzigo wangu k'auremerera.” ");
INSERT INTO nyf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Vikara makathi garyahu, Jesu hamwenga na anafundzie makala manakira kahikahi za minda ya ngano siku ya Sabato. Bai marihokala makukirani, o anafundzie makikala manasikira ndzala, kwa vizho makikwatya kuhuta masuche ga ngano na kwafuna. ");
INSERT INTO nyf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafarisayo marihoona viryahu makimwamba, “Lola! O anafundzio manahenda ut'u uriwo k'auhendwa siku ya Sabato.” ");
INSERT INTO nyf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bai Jesu arihosikira vizho akiadzigidzya o Mafarisayo akiamba, “Muthawali Daudi wahendadze harya arihokala iye na o at'u ariokala nao mana ndzala? Hedu k'amudzavishoma? ");
INSERT INTO nyf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Samba wangira kahi za nyumba ya Mulungu, na akirya yo mikahe ya sadaka, iriyo kulengana na Sheria, iye hedu hatha ao ariokala nao k'amav̱irya kuirya, hasihokala o alombi thu-thu-thu. ");
INSERT INTO nyf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","H'aya zho mbai, yo Sheria ya Musa samba inaamba kukala alombi manabanda Sheria ya Sabato kila siku ya Sabato kahi za Hekalu, kidza k'amana makosa gogosi. Zho nazho k'amudzavishoma? ");
INSERT INTO nyf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Vivi be manyani kukala haha hana mut'u mubomu kukira riro Hekalu. ");
INSERT INTO nyf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Na kala munamanya mana ya go Maoro gaambago kukala, ‘Sadaka zenu sizendzi, nimalazo ni mbazi,’ k'amungaahukumire at'u mario k'amana makosa. ");
INSERT INTO nyf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwani Mwana wa Mudamu nde Bwana wa yo siku ya Sabato.” ");
INSERT INTO nyf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bai arihombola haho Jesu wakwendangira kahi za ro sinagogi rao. ");
INSERT INTO nyf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na lola muryahu sinagogini, were muna mut'u mwenye mukono wa kuholoza. Na kwa kukala o Mafarisayo were manamala chausa cha kumushithakira Jesu, mamuza makimwamba, “Vidze, ni karakara kumuhoza mut'u siku ya Sabato?” ");
INSERT INTO nyf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesu akiadzigidzya akiamba, “Ni h'ani kahi zenu ariye ng'ondziye ikivoromoka winani siku ya Sabato andairicha mumo kwa kukala ni siku ya Sabato? ");
INSERT INTO nyf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Vidze mudamu anadima kulinganishwa na ng'ondzi? Kwa vizho bai ni karakara kamare kisheria kuhenda madzo siku ya Sabato.” ");
INSERT INTO nyf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kugonya kunena vizho, akimwambira ye mut'u, “Goloza wo mukonowo hedu.” Naye arihogoloza thu, ukiuyat'o na ukikala dza uwo mungine. ");
INSERT INTO nyf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Vikara o Mafarisayo marihoona kukala Jesu adzamuhoza ye mut'u, machambola machendapanga zho mandizhomwalaga Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bai Jesu arihoipata p'eho yo njama yao, akihauka achenda kungine. Ela hamwenga na vizho, at'u anji mamuthuwa na akiahoza at'u osi mariokala ni akongo. ");
INSERT INTO nyf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ela akiakokot'era kukala masimuhendye akamanywa iye ni h'ani. ");
INSERT INTO nyf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bai wahenda vivi ili garyahu maneno garigonenwa ni nabii Isaya gathimire. Kwani Isaya waamba, ");
INSERT INTO nyf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Lolani ye muhumiki wangu niriyemutsagula. Ninamuhendza na ananifwahiza. Nindamwangiza nguvu za Roho wangu ili atangazire at'u mario si Ayahudi, kukala hukumu indakala ya hachi. ");
INSERT INTO nyf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","K'andapigana k'anani na at'u hedu kupiga k'ululu. Kidza k'andanena zhomu-zhomu bule mo ngira-ngira. ");
INSERT INTO nyf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","At'u mario k'amana nguvu k'andaabanda moyo bule. Naye andaenderera vizho muhaka ahakikishe kukala hachi idzashinda. ");
INSERT INTO nyf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na kukirira na dzinare, at'u mario si Ayahudi mandahendywa makale na th'amaa ya hakika.” ");
INSERT INTO nyf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Vikara kahi za wakathi uwo, Jesu akireherwa mut'u ariyekala wapagawa ni p'ep'o. Mut'u yuyu were ni kipofu, na ni bwibwi. Ela arihorefwa kwa Jesu, Jesu akimuhoza na ye bwibwi akikwatya kuona na kunena. ");
INSERT INTO nyf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bai aryahu at'u marihoona viryahu osi makingalala zhomu, makiamba, “Yuno ela si iye Mwana wa Daudi?” ");
INSERT INTO nyf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ela Mafarisayo marihosikira vizho makiamba, “Hatha bule! Yuyu anamboza p'ep'o kwa kuhumira nguvu za Belizebuli, mubomu wa p'ep'o.” ");
INSERT INTO nyf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ela Jesu akigamanya go maazo gao na akiambira, “Ts'i yoyosi, o at'ue makidzigazha makundi-makundi, gahehanago, be ts'i iyo indanongeka. Na mudzi wowosi hedu hatha nyumba yoyosi, at'u makikala k'amagwirana milomo, mudzi uwo hedu nyumba iyo, k'aindatoa. ");
INSERT INTO nyf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na Shethani akimboza Shethani mwandziwe, andakala adzadzigazha. Vidze uthawaliwe undatoa jeri? ");
INSERT INTO nyf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Chamba mino namboza p'ep'o kwa nguvu za Belizebuli, o afuasi enu o manaamboza kwa nguvu za h'ani? Bai ao ndo mandiomuhukumu ninwi. ");
INSERT INTO nyf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ela nikimboza p'ep'o kwa Roho wa Mulungu, be wo uthawali wa Mulungu udzamudzirira. ");
INSERT INTO nyf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kwani k'akuna mut'u adimaye kungira kahi za nyumba ya mut'u mwenye nguvu na kumuhoka vit'uzhe hasiho kumufunga ye mwenye kwandza, ndo adime kumuhoka zho vit'uzhe.” ");
INSERT INTO nyf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kila mut'u ariye k'ahamwenga nami, a kinyume nami. Na iye ariye k'anaviza kukundzumanya hamwenga, kaziye ni kutsamula. ");
INSERT INTO nyf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kwa ut'u uwo wenye bai, ninamwambira kamare kukala, kila dambi na kila kufuru indasamehewa, ela kufuru dzulu za Roho Mweri, k'aindasamehewa bule. ");
INSERT INTO nyf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mut'u andiyenena ut'u wowosi kinyume cha Mwana wa Mudamu andasamehewa. Ela kila andiyenena ut'u wowosi kinyume cha Roho Mweri k'andasamehewa ng'o, kahi za urumwengu uu, na hatha kahi za urumwengu udzawo.” ");
INSERT INTO nyf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kila muhi umanyikana kwa gago matundage uzhalago. Muhi ukiutengezerat'o undazhala matunda madzo. Ela kala k'aundatengezerwat'o undazhala matunda mai-mai. ");
INSERT INTO nyf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","H'enwi kizhazi cha nyoka! Munadimadze kunena madzo kuno mioyo yenu i thele uthiriri? Mana kanwa ka mut'u kanena garyahu gadzigowadzala moyowe. ");
INSERT INTO nyf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mut'u mudzo, nikuzhala madzo kula kahi za akibaye mbidzo. Na mut'u mui naye, nikuzhala mai, kula kahi za akibaye mbii. ");
INSERT INTO nyf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ela mino namwambira kukala, kila neno risirofwaha, andironena mut'u andakudza arisemet'o haho siku ya hukumu. ");
INSERT INTO nyf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kwani siku iyo, mulomowo mwenye ndo undokuhendya ugerwe hachi, hedu uhukumiwe.” ");
INSERT INTO nyf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Vikara Jesu arihogonya kunena vizho, badhi ra Mafarisayo na alimu a Sheria makimwamba, “Mwalimu, funamala fuone muujiza kula kwako.” ");
INSERT INTO nyf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesu akiamba, “Kizhazi kithiriri kisokuluhira! Kinamala kwanyeswa muv̱ano, bai k'akindanyeswa muv̱ano wowosi, isihokala uryahu wa nabii Jona h'akeye. ");
INSERT INTO nyf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Na here Jona arizhomizwa ni nyangumi, na akikala ndanini mwakwe siku t'ahu, usiku na mutsana, Mwana wa Mudamu naye andakala mitsangani siku t'ahu, usiku na mutsana. ");
INSERT INTO nyf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nami namwambira kukala, siku iryahu ya hukumu at'u a mudzi wa Ninawi mandarungarara mamupige ulongo, kwa kukala marihosikira mahubiri ga Jona, mathubu dambi zao. Na lola vivi thiyuno mut'u mubomu kumukira Jona. ");
INSERT INTO nyf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","H'aya zho mbai, siku iyo ya hukumu vizho, muthawali muche wa ts'i ya kwa Mwaka, andarungarara amupige ulongo ninwi, kwa kukala iye wambola kure sana, akidza ts'i ya Iziraeli kudzasirikiza ulachu wa Selemani. Vino lola thiyuno mut'u mulachu kumukira Selemani, ela k'amumusirikiza.” ");
INSERT INTO nyf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesu akienderera kunena akiamba, “P'ep'o amwambolaho mut'u, nikundengereka kut'u kuriko k'akuna madzi ili apate hat'u ha kuoya, ela akikosa, ");
INSERT INTO nyf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nikunena kimoyo-moyo akaamba, ‘Mut'u mimi nindauya iryahu nyumba niriyombola.’ Bai auyaho nikuithekeza yo nyumba ni t'uhu, yasherwat'o na ikipangwat'o. ");
INSERT INTO nyf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Vikara aonaho vizho nikwendahala p'ep'o angine afungahe, ai kumukira ye mwenye, akadza nao, makadzangira, makatoa mumo. Bai hali ya mut'u iye ni kukala mbii-mbii hatha kukira zho arizhokala chaho. Na vizho ndo vindizhokala kwa kizhazi kiki kithiriri.” ");
INSERT INTO nyf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Vikara Jesu arihokala achere kunena na riryahu kundi ra at'u, lola mameye, na nduguze Jesu a kilume poo! Makiima ko ndze, makikala manamala kunena naye. ");
INSERT INTO nyf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bai mut'u mumwenga akimwamba Jesu, “Mameyo na nduguzo manakumala ko ndze.” ");
INSERT INTO nyf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesu arihosikira vizho akiuza, “M'ama na ndugu zangu ni hio?” ");
INSERT INTO nyf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Arihouza vizho, akienderera kunena kuno anaaloha o anafundzie akiamba, “Aa be ndo m'ama na ndo ndugu zangu. ");
INSERT INTO nyf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kwani kila ahendaye mahendzo ga Baba ariye mulunguni, nde m'ama na nde ndugu yangu.” ");
INSERT INTO nyf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bai siku iyo vizho, Jesu achambola mumo nyumbani arimokala na achendakelesi k'anda-k'anda ya ro ziya ra Galilaya. ");
INSERT INTO nyf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","K'uzhona arihokwendakelesi kuko, rikundi ribomu ra at'u rikimudzalira hatha akiona ni baha akwere dauni akelesi mumo. Bai wakelesi dauni kuno at'u angine osi makiima ko k'anda-k'anda ya ro ziya. ");
INSERT INTO nyf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Akiambira maut'u manji kwa kuhumira mafumbo. Akiamba, “Mut'u mumwenga wauka kwendamwaga-mwaga mbeyu mundani kwakwe. ");
INSERT INTO nyf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Vikara arihokala akuzimwagani-mwagani, mbeyu nyingine zikigwa k'anda-k'anda ya ngira. Unyama ukidzazit'ot'a. ");
INSERT INTO nyf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nyingine zikigwa kahi za mutsanga wa mawe-mawe, harihokala hana mutsanga muchache. Bai zikimera malo-malo kwa kukala were hana mutsanga muchache. ");
INSERT INTO nyf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ela zirihopigwa ni dzuwa thu zikinyala kare, kwa kukala were k'azina miziji ya kwenda kure. ");
INSERT INTO nyf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu nyingine zikigwa miyani. Zirihomera, miya iryahu ikikula na ikizizia-zia hatha k'azipatire nafasi ya kumbola ndze bule. ");
INSERT INTO nyf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ela mbeyu nyingine zo zikigwa kahi za mutsanga mudzo, na zikizhalat'o sana. Nyingine zazhala gana-gana, nyingine mirongo mihandahu, na nyingine zo zikizhala mirongo mihahu.” ");
INSERT INTO nyf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Arihogonya kunena viryahu akiamba, “Mwenye masikiro, naasikire.” ");
INSERT INTO nyf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bai, ariholaa haho, o anafundzie makimuza makimwamba, “Kwanoni unahendza kuhumira mafumbo kala unanena na o at'u?” ");
INSERT INTO nyf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesu akiadzigidzya akiamba, “Ninahenda vizho kwa kukala ninwi mwajaliwa kumanya siri za uthawali wa mulunguni, ela aryahu k'amajaliwirwe bule. ");
INSERT INTO nyf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kwani kila ariye nacho andangezwa, akale na vinji, ela ariye k'ana kit'u kamare, hatha cho kichache aricho nacho kidza andakihokwa. ");
INSERT INTO nyf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","At'u aryahu ninanena nao kwa mafumbo, kwa kukala manalola, ela k'amaona bule, kidza manasikiza, ela k'amasikira hedu kuelewa. ");
INSERT INTO nyf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na garyahu maneno garigonenwa ni nabii Isaya haho kapindi vivi gadzathimira kwao. Kwani Isaya wanena akiamba, ‘Mundasirikiza na kusirikiza ela k'amundang'alirwa bule. Mundalola na kulola ela k'amundaona bule. ");
INSERT INTO nyf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mana mioyo ya at'u aa idzakala mikomu, masikiro gao madzagagandiza, matso gao madzagafinya, masidze makaona na go matso gao, makasikira na go masikiro gao, makang'alirwa na yo mioyo yao, makanigalukira mimi, nikaahoza.’ ");
INSERT INTO nyf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Baha ninwi, kwani masikiro genu ganasikira na matso genu ganaona. ");
INSERT INTO nyf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kwani be namwambira kamare kukala, manabii anji na at'u ahachi angine, mathamani kuona gaga mugaonago, ela k'amagaonere, kidza mathamani masikire gago mugasikirago, ela k'amagasikirire bule.” ");
INSERT INTO nyf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesu akienderera kunena na anafundzie akiamba, “Vikara, sirikizani nimwambire mana ya ro fumbo ra mulayi. ");
INSERT INTO nyf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kila mut'u ariye akisikira neno ra Mulungu k'arielewa, ye Mui nikudza na kurusa ho moyoni ririholaywa. Bai mut'u dza iye nde iryahu mbeyu iriyogwa haryahu k'anda-k'anda ya ngira. ");
INSERT INTO nyf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ziryahu mbeyu zirizogwa mutsanga wa mawe-mawe, ni mut'u ariye akisikira neno thu, anarihokera kare mara mwenga, kidza anarihokera na raha. ");
INSERT INTO nyf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ela kwa kukala neno riryahu k'arina miziji moyoni mwakwe, mut'u yuyahu k'atoa naro bule. Kwani thabu, hedu mateso gakimudzirira kwa ut'u wa ro neno, k'avumirira bule, anaviricha kare. ");
INSERT INTO nyf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mungine ye ni here iryahu mbeyu iriyogwa miyani. Mut'u iye nikusikira ro neno ra Mulungu, ela v̱ata za urumwengu, na ukengi wa mali, nikurikonya-konya ro neno hatha rikakala k'arindazhala kit'u. ");
INSERT INTO nyf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ela mut'u mungine ye ni here iryahu mbeyu iriyogwa kahi za mutsanga mudzo. Mut'u yuyu nikurisikira ro neno ra Mulungu, akarielewat'o. Bai at'u mario dza vizho yuyu, nikuzhala matunda. Yuno gana, yuya mirongo mihandahu, na mungine mirongo mihahu.” ");
INSERT INTO nyf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Bai kula haho, Jesu akiambira o at'u fumbo ringine akiamba, “Uthawali wa mulunguni udzahalana na mut'u ariyekwendalaya ngano mundani kwakwe. ");
INSERT INTO nyf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Vikara siku iyo vizho, hadhui wa kwakwe naye, akithariza hatha at'u machangira ndazini, achendamwaga-mwaga ngano ya vuweni kahi za yo ngano yenye. ");
INSERT INTO nyf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Bai, mbeyu zizi zamera na zikikula hatha ngano inaamba inafumula, yo ngano ya vuweni nayo ikifumula. ");
INSERT INTO nyf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","K'uzhona aryahu ahumiki marihoona viryahu machendamuza ye mwenye munda makiamba, ‘Bwana, samba walaya ngano yenye we murya mundani mwako! Be mbona vino muna ngano ya vuweni?’ ");
INSERT INTO nyf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ye mwenye munda akiamba, ‘Hadhui ndiye ariyekudzailaya.’ O ahumiki makimwamba, ‘Vikara vino hukaing'ole hedu huhendedze?’ ");
INSERT INTO nyf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ye mwenye munda akiadzigidzya akiamba, ‘Hatha, musendeing'ola bule. Kwani muchendaing'ola munadima kung'ola hatha yo ngano yenye nayo. ");
INSERT INTO nyf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ut'u uwo uricheni ukule hamwenga, hatha wakathi wa kuvuna. Haho nindaambira o avuni kukala, “Ihaleni yo ngano ya vuweni yosi kwandza, muifunge mabutsa-mabutsa mugaike k'anda gaochwe. Mukigonya vizho, halani yo ngano yenye muyangize lutsagani mwangu.” ’ ” ");
INSERT INTO nyf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Bai Jesu arihogonya kuambira ro fumbo riro, akihamboza fumbo ringine kaheri akiamba, “Uthawali wa mulunguni udzahalana na katembe kathithe ka haradali, kariko mut'u mumwenga wakahala achendakalaya mundani mwakwe. ");
INSERT INTO nyf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Katembe kaka ni kathithe kukira t'embe zosi. Ela kakimera, nikukula zhomu hatha kakakira mimera mingine yosi ya mundani. Kidza nikukala muhi mubomu hatha unyama ukadzaaka vitsunji zhao mo vitaini.” ");
INSERT INTO nyf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesu akiambozera fumbo ringine, akiamba, “Uthawali wa mulunguni udzahalana na ts'ats'u iriyohalwa ni mwanamuche akivugira p'ishi t'ahu za unga wa ngano na ukikutuka wosi.” ");
INSERT INTO nyf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Bai kila kit'u arichokifundisha Jesu kwa o at'u, wakifundisha kwa kuhumira mafumbo, k'akuna kit'u hatha kimwenga arichokifundisha bila kuhumira mafumbo. ");
INSERT INTO nyf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bai wahenda vivi ili maneno garigonenwa ni nabii mumwenga ho kapindi gathimire. Kwani nabii iye wanena akiamba, “Nindahumira mafumbo kunena maut'u garigofitswa hangu kuumbwa kwa urumwengu.” ");
INSERT INTO nyf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Vikara Jesu arihogonya kunena akiaricha o at'u na akiuya ko nyumbani arikokala adzambola. Bai arihofika kuko anafundzie makimuthuwa makimwamba, “Bwana, rirya fumbo ra ngano ya vuweni manaye ni noni? Fambire.” ");
INSERT INTO nyf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu akiadzigidzya akiamba, “K'amuona h'e, mulayi wa yo mbeyu mbidzo ni Mwana wa Mudamu. ");
INSERT INTO nyf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wo munda ni uu urumwengu. Mbeyu mbidzo ni ana a Uthawali, na ngano ya vuweni ni ana a ye Mui. ");
INSERT INTO nyf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iye nde mulayi wa yo ngano ya vuweni. Wakathi wa kuvuna ni siku ya mwisho, na avuni ni malaika. ");
INSERT INTO nyf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Siku ya mwisho vindakala dza vizho zhenye, zha ngano ya vuweni kung'olwa na kwangizwa mohoni. ");
INSERT INTO nyf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kwani Mwana wa Mudamu andaalagiza malaikae makundzumanye ahendi a mai osi, hamwenga na aryahu maahendyao andziyao mahende mai, na maamboze ndze ya uthawali wa kwakwe. ");
INSERT INTO nyf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Makila haho maahale makaatsuhe mohoni. Na kuko mandarira na kufuna meno. ");
INSERT INTO nyf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ela ahachi o, mandang'ala here dzuwa kahi za uthawali wa Babiyao. Mwenye masikiro, naasikire.” ");
INSERT INTO nyf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesu akienderera kumboza mafumbo mangine akiamba, “Uthawali wa mulunguni udzahalana na ushaha uriwokala wafitswa hat'u mundani vivi. Vikara mut'u mumwenga arihokwendaupesa akikaza kuufitsa. Na kwa ro fwahiro bomu arirokala naro achendaguza vit'uzhe zhosi, akidzagula wo munda.” ");
INSERT INTO nyf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Bai Jesu akihamboza fumbo ringine kaheri akiamba, “Uthawali wa mulunguni udzahalana na mut'u mumwenga, ariyekala kaziye ni kumala lulu na kwendaguza. ");
INSERT INTO nyf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","K'ona siku mwenga achendaona lulu ya kima kibomu sana. Bai achendaguza vit'u zhosi arizhokala nazho, akidzaigula.” ");
INSERT INTO nyf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kidza Jesu akimboza fumbo ringine, akiamba, “Pia uthawali wa mulunguni udzahalana na nyavu bomu sana, iriyogwagwa ziyani na ikigwira makumba ga kila namuna. ");
INSERT INTO nyf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bai irihokala idzadzala o avuhi makiimboza ndze, gonya makikelesi kutsagula makumba ga kuriwa na gasigoriwa. Garyahu ga kuriwa makigangiza k'ahuni mwao, garya gasoriwa makigatsuha. ");
INSERT INTO nyf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na siku ya mwisho vindakala dza vizho zhenye. Malaika mandaathenga at'u, ai lwao, na ahachi lwao. ");
INSERT INTO nyf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Makigonya vizho, mandaahala at'u ai osi maatsuhe mohoni, na kuko mandarira na kufuna meno.” ");
INSERT INTO nyf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesu arihogonya kuathalira mafumbo gaga akiauza akiamba, “Vidze mudzagasikira gano nidzigomwambira?” Na anafundzie makimudzigidzya makiamba, “Ee hudzagasikira.” ");
INSERT INTO nyf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Bai marihokala madzadzigidzya, Jesu akiambira, “H'aya bai, kila mwalimu wa sheria adziyefundishwa ujeri dzulu za uthawali wa mulunguni, a karakara na mut'u ariye na akibaze nyumbani mwakwe. Ni kwangira akamboza mbisha na za kapindi.” ");
INSERT INTO nyf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Bai arihokala adzagonya kumboza go mafumbo gago, Jesu wauka haho arihokala ");
INSERT INTO nyf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","achenda kwao. Vikara arihofika kuko, achangira kahi za sinagogi ra at'u a kuko na akikwacha kufundisha. K'uzhona o at'u makingalala zhomu makiamba, “Uno ulachu be tha waupatahi? Na zino nguvu za kutengezera miujiza nazo wazilazhahi? ");
INSERT INTO nyf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yuno si yuyahu mwana wa fundhi wa kutsonga bule yuno? Samba tha mameye ni Maryamu yuno. Hatha nduguze osi a kilume hunaamanya: Jakobu, na Josefu, na Simoni, na Juda. ");
INSERT INTO nyf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","H'e o nduguze a kiche, samba osi ma haha! Vikara maut'u gano gosi wagapatahi?” ");
INSERT INTO nyf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bai k'aviafahire. Jesu arihoona viryahu akiamba, “Nabii anaishimiwa kila hat'u isihokala kahi za ts'i ya kwao, na mudzini kwao.” ");
INSERT INTO nyf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Bai kwa ut'u wa ko kutsakuluhira kwao, Jesu k'akuhendere miujiza minji kuko. ");
INSERT INTO nyf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Vikara makathi garyahu muthawali Herode, ariyekala akiifwa Anitipasi wasikira nguma ya go maut'u mabomu arigokala akigahenda Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Akiambira ahumikie, “Iye ni Johana Mubat'izaji iye, wafufuka, ndo hatha ana wadimi wa kuhenda maut'u mabomu-mabomu.” ");
INSERT INTO nyf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herode were wamugwira Johana akimufunga minyororo akimwangiza jela. Vivi wavihenda kwa ut'u wa Herodia, mwanamuche ariyekala Herode wamuhoka nduguye ariyekala akiifwa Filipu ");
INSERT INTO nyf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Johana Mubat'izaji akimwambira Herode kukala, “Si hachi bule kumuhala mukaza nduguyo.” ");
INSERT INTO nyf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Lengo ra Herode were ni amwalage ye Johana, ela k'avihendere kwa ut'u wa kuagoha o Ayahudi, kwani ao were manamona Johana kukala ni nabii. ");
INSERT INTO nyf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Siku mwenga, Herode were anausa sherehe ya kukumbukira siku ariyozhalwa, na musichana wa Herodia akidzaavinira ajeni. Bai Herode wafwahirwa zhomu ");
INSERT INTO nyf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hatha akilaha kukala chochosi andichomala ye musichana andamup'a. ");
INSERT INTO nyf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bai kwa kufundishwa ni mameye, ye musichana akiamba, “Ningizira kitswa cha Johana Mubat'izaji kahi za riri bunguu.” ");
INSERT INTO nyf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Arihosikira vizho, Herode washononeka zhomu, ela kwa were adzalaha mbere za ajeni kukala kila andichomalwa andalazha, akilagiza kukala agerwe. ");
INSERT INTO nyf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Akilagiza mut'u achenda ko jela, achendamutosa kitswa Johana. ");
INSERT INTO nyf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bai akichangiza bunguuni akimurehera ye musichana, naye akikihala akimuhirikira mameye. ");
INSERT INTO nyf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Anafundzi a Johana marihovisikira, makidzamuhala machendamuzika, gonya machendamwambira Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Vikara Jesu arihousikira wo uv̱oro wa kwalagwa kwa Johana, akikwera dau kwenda kut'u kwa iye h'akeye, kure na at'u. Ela at'u marihovisikira makimbola midzini, makundi-makundi, makimuthuwa na magulu hatha makifika ko arikokala anenda. ");
INSERT INTO nyf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bai arihothima mo dauni, akirona ro kundi bomu ra at'u ririrokala ridzamuthuwa, naye akiaonera mbazi na akiahoza akongo ao. ");
INSERT INTO nyf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Vikara kurihokala kunaenderera kutswa, o anafundzie mamwendera makimwamba, “Bwana, hat'u haha be ni nyika zhomu, nako kunakaza kutswa, kwa vizho baha uafumule aa at'u mangire mo midzini makadzigulire zhakurya.” ");
INSERT INTO nyf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesu akiadzigidzya akiamba, “Hatha, k'avimala bule, ap'eni chakurya ninwi.” ");
INSERT INTO nyf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Vikara marihosikira vizho o anafundzi makimuza Jesu makiamba, “Fundaarisadze sino naswi funa mikahe mitsano na makumba mairi thu-thu-thu?” ");
INSERT INTO nyf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesu akiadzigidzya akiamba, “Vireheni kuno hedu.” ");
INSERT INTO nyf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Akiambira o at'u makeresi ho nyasini. Marihogonya kukelesi, akihala yo mikahe mitsano na go makumba mairi, akilola dzulu mulunguni, akimboza muv̱era kwa Mulungu, gonya akivimogola-mogola akiap'a anafundzie maagazhire o at'u. ");
INSERT INTO nyf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nao osi makirya hatha makivilola. Bai marihogonya kurya, o anafundzi makitsola-tsola zho visiku-visiku virizhokala vidzasala na makidzaza k'ahu kumi na mbiri. ");
INSERT INTO nyf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Isabu ya o at'u mariorya were ni here alifu ts'ano, hasiho kuthala ache na ahoho. ");
INSERT INTO nyf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bai o at'u marihogonya kurya thu, Jesu waambira o anafundzie mangire dauni mathangulie kwenda nyangamo ya hiri kuno ye anaafumula o at'u. ");
INSERT INTO nyf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bai, arihokala adzagonya kuafumula, wakwera dzulu kirimani kwendavoya hatha akitsererwa h'akeye kuko. ");
INSERT INTO nyf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wakathi uwo ro dau were ridzafika kure zhomu, kidza were rinaheha na maimbi, kwani lupeho lwere lunambola ko mendako. ");
INSERT INTO nyf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bai urihofika wakathi wa jogolo ra kwandza kuika akiambolera kuno ananenda dzulu za madzi. ");
INSERT INTO nyf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ela o anafundzi marihomona ananenda dzulu za madzi, makihondoka zhomu, makipiga k'ululu kwa woga, kwa kukala were manaona ni p'ep'o. ");
INSERT INTO nyf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesu akinena nao haraka akiamba, “Sogoheni, ndimi musihondoke.” ");
INSERT INTO nyf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","P'et'ero akiamba, “Kala ndiwe jeri Bwana, nambira nami ninende dzulu za gaga madzi nikuthuwe kuko uriko.” ");
INSERT INTO nyf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesu akimudzigidzya akimwamba, “Ndzo.” K'ona P'et'ero akithima kula mo dauni akinenda dzulu za go madzi kumuthuwa Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ela arihosikira lo luv̱utho zho lupigazho na nguvu achangirwa ni woga na akikwacha kuhoha. Akipiga k'ululu akiamba, “Bwana, nokola!” ");
INSERT INTO nyf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na haho henye Jesu akigoloza mukono akimugwira gonya akiamba, “Mut'u wa kuluhiro thithe we, kwanoni udzahenda k'ai-k'ai mo moyoni?” ");
INSERT INTO nyf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Arihonena vizho, iye na P'et'ero machangira mo dauni na lo luv̱utho lukihurira. ");
INSERT INTO nyf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na o at'u osi mariokala mo dauni makimuzamira makiamba, “Ujeri wenye uwe u Mwana wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bai Jesu na anafundzie makivuka ro ziya na makifika ts'i ya Genezarethi. ");
INSERT INTO nyf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Vikara at'u a kuko marihomanya kukala ni Jesu, makivitsamusa kare lalo rosi kukala Jesu adzire. K'uzhona makimurehera Jesu akongo osi, ");
INSERT INTO nyf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","na makimuvoya mahende kugut'a ro pindo ra ro valore thu, na osi mariorigut'a mahola. ");
INSERT INTO nyf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Siku mwenga, Mafarisayo na alimu a Sheria, mambola Jerusalemu machenda hatha kuko arikokala Jesu. Manafika kuko makimwamba, ");
INSERT INTO nyf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mbona o anafundzio manaribanda ro adha ra kuoga mikono hurirorichirwa ni akare ehu? Kwani kala manarya k'amaoga mikono.” ");
INSERT INTO nyf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu akiadzigidzya akiamba, “Mbona nwi munabanda malagizo ga Mulungu ili muthuwe maadha genu enye? ");
INSERT INTO nyf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mulungu walagiza kukala, ‘Muishimu babayo na mameyo.’ Kidza akiamba, ‘Ye andemuhukana babaye hedu mameye, kumala kwalagwa naalagwe.’ ");
INSERT INTO nyf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ela nwi munafundisha kukala, mut'u akihala kit'u adimacho kumup'a babaye hedu mameye na akakala adzamwaviza, na hat'uhe akilazhe kwa Mulungu, ");
INSERT INTO nyf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","andakala k'ana haja ya kuaishimu bule. Mbona munarihenda neno ra Mulungu kutsakala na nguvu, kwa muthuwe maadha genu enye? ");
INSERT INTO nyf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Munadzihendya sana ninwi. Nabii Isaya wanenat'o sana dzulu zenu. Kwani waamba, ");
INSERT INTO nyf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘At'u aa mananogoha kwa makanwa gao, ela mioyo yao i kure nami. ");
INSERT INTO nyf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hatha makanivoya ni bule, kwa kukala manahala maadha ga anadamu, na kugafundisha here malagizo gangu.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Bai Jesu arihogonya kunena na o Mafarisayo, akiaiha o at'u akiambira, “Nisirikizani na mung'alirwe; ");
INSERT INTO nyf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Changiracho kanwani mwa mut'u, k'akimuhendya mukolo. Kimuhendyacho mut'u akakala mukolo, ni kiryahu chambolacho kanwani mwakwe.” ");
INSERT INTO nyf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","K'uzhona zho marihombola haho, anafundzi makimwamba kukala, “Unamanya kukala virya udzizhovinena harya vidzaatsukiza o Mafarisayo?” ");
INSERT INTO nyf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesu akiadzigidzya akiamba, “Kila mumera uriwo k'aulayirwe ni Baba ariye ko mulunguni, undang'olwa. ");
INSERT INTO nyf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aricheni, ao ni vipofu malongozao vipofu andziyao. Na kipofu akimulongoza kipofu mwandziwe, k'amafikahi bule, osi mandavoromoka winani.” ");
INSERT INTO nyf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ela P'et'ero akimwamba Jesu, “Fambire mana ya rirya fumbo hedu.” ");
INSERT INTO nyf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu akiadzigidzya akiamba, “Hatha ninwi nanwi k'amung'alirwa bule? ");
INSERT INTO nyf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Samba ukirya kit'u kinenda ndanini mwako, gonya uchenda chandze unenda ukachamboze. ");
INSERT INTO nyf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ela maut'u mai gambolago kanwani nikukala gala moyoni, na gago ndo gamuhendyago mut'u kukala mukolo. ");
INSERT INTO nyf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwani moyo ndo udimao kumboza maazo mai gamuhendyago mut'u akalaga, akazinga, akaiya, akamboza ushahidhi wa ulongo, na akahukana mut'u. ");
INSERT INTO nyf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gaga ndo maut'u gamuhendyago mut'u kukala mukolo. Ela kurya bila kuoga mikono dza zho mahendzazho ao, k'avidima kumuhendya mut'u yoyosi akale mukolo.” ");
INSERT INTO nyf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Bai Jesu akimbola jimbo ra Galilaya na achendakala kahi za eneo ra midzi ya Tiro na Sidoni. ");
INSERT INTO nyf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Arihofika kuko, lola mwanamuche mumwenga Muk'anani ariyekala akitoa p'ande zizo, akimuthuwa na akiluta mumiro akimwamba, “Nionera mbazi h'ewe Bwana, Mwana wa Daudi! Musichana wangu ana p'ep'o, be a vii-vii zhomu sana.” ");
INSERT INTO nyf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesu k'amudzigidzyire kit'u. Bai o anafundzi makimwamba Jesu, “Bwana, mwambe ariche kuhuthuwa-thuwa, kwani be anahupigira londzo.” ");
INSERT INTO nyf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesu akiamba, “Mimi nahumwa kwa Aiziraeli h'akeye, ng'ondzi zirizongamika.” ");
INSERT INTO nyf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ela ye mwanamuche akidzamupigira mavindi akiamba, “Naviza Bwana.” ");
INSERT INTO nyf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesu akimwamba, “Si karakara bule nihale chakurya cha ahoho nikitsuhire k'uro.” ");
INSERT INTO nyf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ye mwanamuche akidzigidzya akiamba, “U mujeri, ela hatha ye k'uro naye nikurya magande gadzigogwagwa ni ye mwenye k'uro.” ");
INSERT INTO nyf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesu akimwamba, “Mwanamuche uwe be una kuluhiro bomu sana. Bai vizho umalazho navikale.” Na wakathi uwo wenye ye musichanawe akihola kare. ");
INSERT INTO nyf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Vikara Jesu arihombola haho, wakira na k'anda-k'anda za ro ziya ra Galilaya, akipanda kuko dzulu virimani, achendakeresi kuko. ");
INSERT INTO nyf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bai at'u anji makidza na akongo ao, virema, vidende, vipofu, mabwibwi na akongo angine anji. Akongo aa makudzaikwa mbere za Jesu, naye akiahoza osini. ");
INSERT INTO nyf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","O at'u marihoona viryahu Jesu ahozazho akongo, machangalala na makimulika Mulungu wa Iziraeli. Maona mabwibwi gananena, at'u enye virema mananenda, vidende manahola na vipofu manaona. ");
INSERT INTO nyf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Vikara Jesu akiaiha anafundzie akiamba, “At'u aa be mananishononesa zhomu. Hangu makale nami haha, rero ni hahu, na vivi k'amana ut'u wowosi wa kurya, nami ts'endzi niafumule na ndzala, p'ore makendagwa na mutsare mo ngirani.” ");
INSERT INTO nyf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","K'uzhona o anafundzie makimuza makimwamba, “Bwana, cho chakurya cha kuarisa at'u ano osi hano nyika hundachambozahi?” ");
INSERT INTO nyf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesu akiauza akiamba, “Kwani muna mikahe mingahi?” Makiamba, “Mifungahe, na vikumba zha kuthala.” ");
INSERT INTO nyf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bai Jesu akiambira o at'u makelesi ho ts'i. ");
INSERT INTO nyf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Marihogonya kukelesi, Jesu akihala yo mikahe mifungahe na zho vikumba, akilazha muv̱era gonya akivimogola-mogola akiap'a o anafundzie maagazhire o at'u. ");
INSERT INTO nyf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Lola at'u osini marya vivii hatha makivilola, kidza o anafundzi makidzaza k'ahu fungahe za visiku-visiku virizhokala vidzasala. ");
INSERT INTO nyf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na murongo wa o at'u mariorya were unafika alume alifu ne, bila kuthala ache na ahoho. ");
INSERT INTO nyf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bai Jesu arihokala adzagonya kuafumula o at'u, wakwera dau achenda jimbo ra Magadani. ");
INSERT INTO nyf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Siku mwenga Mafarisayo na Masadukayo makwendamujeza Jesu makimwamba aanyese muujiza wa kula mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesu akiadzigidzya akiamba, “Mukiona dzuwa rinapothoka, na mulunguni ni kuthune, munaamba, ‘Machero kundasindat'o.’ ");
INSERT INTO nyf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mukiona kudzagit'ana na madzach'a na mulunguni ni kuthune, munaamba ‘Rero kundanya v̱ula ya luv̱utho.’ Munamanya kulola mulunguni na mukamanya kundakalani, ela miv̱ano ya makathi hurigo k'amumanya kuilola? ");
INSERT INTO nyf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kizhazi kithiriri kisokuluhira! Kinamala kwanyeswa muv̱ano, bai k'akindanyeswa muv̱ano wowosi, isihokala uryahu wa Jona.” Naye arihogonya kunena vizho, akihauka. ");
INSERT INTO nyf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Vikara marihombola haho Jesu na anafundzie makwera dauni na makivuka kwenda nyangamo ya hiri ya ro ziya ra Galilaya. O anafundzi mere madzasahau kutsukula mikahe kamare. ");
INSERT INTO nyf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesu akinena nao akiamba, “Dzichungeni sana. Dzimanyirireni na ts'ats'u ya Mafarisayo na ya Masadukayo.” ");
INSERT INTO nyf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","K'uzhona marihosikira viryahu, o anafundzi makiuzana-uzana makiamba, “Ni zho hurizho k'ahutsukulire mikahe.” ");
INSERT INTO nyf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ela Jesu ye akivimanya, akiamba, “At'u a kuluhiro thithe nwi! Mbona munauzana-uzana dzulu za kukosa mikahe? ");
INSERT INTO nyf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Vidze muchere k'amudzang'alirwa? Hedu mudzasahau kare zho nirizhoarisa at'u alifu ts'ano na mikahe mitsano hatha mukidzaza k'ahu nyinji zenye za masaza? ");
INSERT INTO nyf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","H'e zho nirizhoarisa at'u alifu ne na mikahe mifungahe. Zho samba mwadzaza k'ahu nyinji zenye za masaza mino! ");
INSERT INTO nyf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Vino mbona k'amung'alirirwe hatha munaamba nanena dzulu za mikahe? Ninanena kaheri, dzimanyirireni na ts'ats'u ya Mafarisayo na ya Masadukayo.” ");
INSERT INTO nyf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bai charo kiki, o anafundzi makielewa kukala Jesu were k'anena dzulu za ts'ats'u, ela were anaamba madzimanyirire na mafundisho ga Mafarisayo na ga Masadukayo. ");
INSERT INTO nyf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Vikara Jesu na anafundzie marihofika p'ande za Kaisaria Filipi, Jesu akiauza anafundzie akiamba, “At'u manaamba Mwana wa Mudamu ni h'ani?” ");
INSERT INTO nyf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Makimudzigidzya makiamba, “Angine manaamba u Johana Mubat'izaji, angine manaamba u Elija, na angine manaamba u Jeremia, hedu mumwenga kahi za o manabii.” ");
INSERT INTO nyf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesu akiauza kaheri akiamba, “Nwi enye munaamba ni h'ani?” ");
INSERT INTO nyf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni aifwaye P'et'ero akimudzigidzya akiamba, “Uwe u Masihi Mwana wa Mulungu ariye moyo.” ");
INSERT INTO nyf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesu akimwamba P'et'ero, “Baha uwe Simoni wa Jona, kwa kukala zho udzizhovinena be k'uzhambirirwe ni mut'u bule, udzazhambirwa ni Baba ariye ko mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nami nakwambira kukala uwe ndiwe P'et'ero, nami nindajenga kanisa rangu dzulu za iwe riri, na hatha miryango ya kuzimu kidza k'aindadima kurishinda. ");
INSERT INTO nyf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nindakup'a funguo za uthawali wa mulunguni. Na kila undichokifunga haha dhuniani, hatha ko mulunguni nako kindafungwa. Na kila undichokivugula haha dhuniani, hatha ko mulunguni nako kindavugulwa.” ");
INSERT INTO nyf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Bai arihogonya kunena vizho, Jesu akiakokot'era anafundzie masimwambire mut'u yoyosi kukala iye nde Masihi. ");
INSERT INTO nyf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Vikara kulaiza wakathi uwo, Jesu akikwacha kuambira anafundzie lwazu-lwazu dzulu za maut'u gandigokala. Bai waamba kukala, ni lazima ende Jerusalemu akateswe sana kahi za mikono ya athumia a Kiyahudi, na alombi abomu, na alimu a Sheria, na alagwe, na siku ya hahu afufulwe. ");
INSERT INTO nyf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","P'et'ero akimuvuha k'anda akikwacha kumuchemera akimwamba, “Hatha Bwana, vizho uambazho k'avindakala kamare.” ");
INSERT INTO nyf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesu akimugalukira P'et'ero akimwamba, “Hauke Shethani, unaniziza ngira, kwani maazogo k'agambolere kwa Mulungu bule, gadzambola kwa mudamu.” ");
INSERT INTO nyf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bai arihogonya kunena vizho akiagalukira o anafundzi akiamba, “Mut'u akihendza kunithuwa mimi, suthi adzikane mwenye, na adzihike musalabawe anithuwe. ");
INSERT INTO nyf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwani kila amalaye kuthizha rohoye andayangamiza, na kila andiyeyangamiza kwa ut'u wangu mimi andaipata. ");
INSERT INTO nyf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kwani vindamufwahani mut'u akipata vit'u zhosi zha urumwengu, gonya rohoye yangamike? Hedu mut'u anadima kugula rohoye? ");
INSERT INTO nyf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwani Mwana wa Mudamu andakudza na malaikae kahi za nguma ya Babaye, naye andakudzamuriha kila mut'u kulengana na maut'u arigogahenda mwenye. ");
INSERT INTO nyf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nami ninamwambira ujeri wenye kukala haha hana at'u mario k'amandafwa kabila kumona Mwana wa Mudamu anadza kahi za uthawaliwe.” ");
INSERT INTO nyf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Vikara siku t'andahu bada ya kunena dzulu za kudzakwe, Jesu wamuhala P'et'ero, na Jakobu, na Johana nduguye Jakobu, na akikwera nao dzulu za murima mure, kure na at'u. ");
INSERT INTO nyf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bai marihokala ma kuko, Jesu akigaluka sura kamare kuno manalolera. Usowe ukikala unang'ala-ng'ala here dzuwa na nguwoze zikikala nyaruhe tse-tse-tse. ");
INSERT INTO nyf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na lola haho henye, Musa na Elija makiambolera makikala mananena naye. ");
INSERT INTO nyf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bai P'et'ero arihoona viryahu akimwamba Jesu, “Bwana, ni vidzo zho zha fu haha. Ukihendza nadima kumuakira vibanda vihahu mino. Kimwenga chako, kimwenga cha Musa, na kimwenga cha Elija.” ");
INSERT INTO nyf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lola P'et'ero were k'adzatosa, kuchambola ingu ra kung'ala rikidzaafinikira. Na sauthi ikimbola mo inguni ikiamba, “Yuyu nde Mwanangu muhendzwi anifwahizaye, musirikizeni iye.” ");
INSERT INTO nyf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","K'ona o anafundzi marihosikira vizho machangirwa ni woga zhomu makigwa na moyo. ");
INSERT INTO nyf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ela Jesu akidzaagut'a akiamba, “Musigohe bule, ukani.” ");
INSERT INTO nyf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nao marihotsuha matso gao makimona Jesu thu h'akeye, k'amaonere mut'u mungine bule. ");
INSERT INTO nyf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Badaye marihokala manatharamuka kula ko dzulu ya wo murima, Jesu akiakokot'era o anafundzie akiamba, “Viryahu mudzizhozhona kuryahu, be musizhambire mut'u kamare, muhaka haho Mwana wa Mudamu andihofufulwa.” ");
INSERT INTO nyf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","O anafundzi makimuza Jesu makiamba, “Mbona o alimu a Sheria manaamba ni lazima Elija adze kwandza?” ");
INSERT INTO nyf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Akiadzigidzya akiamba, “Zho ni vizho, Elija ni lazima athangulie kuthayarisha kila kit'u. ");
INSERT INTO nyf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ela namwambira kukala, Elija wakudza kare, ela at'u k'amamanyire ndeye bule, makimuhenda kila marichoona ni karakara. Na vizho zhenye ndizho mandizhomutesa Mwana wa Mudamu.” ");
INSERT INTO nyf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesu arihogonya kunena, o anafundzi makimanya kukala were ananena dzulu za Johana Mubat'izaji. ");
INSERT INTO nyf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Vikara marihouya ko at'u marikokala, mwanamulume mumwenga akimudhana Jesu na akidzapiga mavindi ho mbereze ");
INSERT INTO nyf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","akiamba, “Bwana, muthana wangu ana vitsala vikali na vinamup'a thabu sana. Mara nyinji nikumugwaga mohoni na hatha madzini. Kwa vizho muonere mbazi Bwana. ");
INSERT INTO nyf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nidzaarehera aryahu anafundzio mamuhoze ela k'amazhadimire bule.” ");
INSERT INTO nyf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","K'uzhona Jesu arihosikira viryahu akidzigidzya akiamba, “H'enwi at'u a kizhazi cha kwangamika ngira, musio na kuluhiro, nindakala nanwi hatha rini? Nindamuvumirira hatha rini? Murehe kuno ye muhoho.” ");
INSERT INTO nyf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Naye arihorefwa, Jesu akimuchemera yuyahu p'ep'o wa vitsala akimwambola, na ye muhoho akihola kare. ");
INSERT INTO nyf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Vikara badaye, o anafundzi makimuthuwa Jesu kinjama machendamuza makiamba, “Bwana, kwanoni sino k'ahudimire kumwamboza ye p'ep'o?” ");
INSERT INTO nyf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesu akiadzigidzya akiamba, “Kuluhiro renu ni thithe ndosa k'amuzhadimire. Ela namwambira ujeri siku mundihokala na kuluhiro thithe renye here katembe ka haradali, mundadima kuwambira uu murima uhauke wende kut'u kungine, nawo undakwenda. K'akuna kit'u kindichokala k'achadimikika.  ");
INSERT INTO nyf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ela p'ep'o dza yuyu k'ambola rahisi-rahisi bule, isihokala kwa kufunga na kuvoya.” ");
INSERT INTO nyf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bai siku mwenga, marihokala madzakundzumanyikana hamwenga ko Galilaya, Jesu akiambira o anafundzie akiamba, “Suthi Mwana wa Mudamu alazhwe mikononi mwa at'u. ");
INSERT INTO nyf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nao mandamwalaga, ela siku ya hahu andafufuka.” Marihosikira vizho, o anafundzi mashononeka sana. ");
INSERT INTO nyf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Vikara marihofika mudzi wa Kaperinaumu, athozi a kodi ra Hekalu makimuthuwa P'et'ero makimuza, “Yuno mwalimu wenu kisha nikuriha kodi ra Hekalu?” ");
INSERT INTO nyf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","P'et'ero akiamba, “Ee nikuriha.” Gonya thiye achenda ko nyumbani kwendamwambira Jesu. Ela kabila P'et'ero k'adzanena, Jesu akimuza swali akiamba, “Simoni kuno dhuniani, athawali nikuthoza kodi at'u a kwao enye, hedu at'u a kula ts'i nyingine?” ");
INSERT INTO nyf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","P'et'ero akimudzigidzya akiamba, “Mathoza at'u a ts'i nyingine.” Jesu akiamba, “Kwa vizho at'u a kwao ma huru. ");
INSERT INTO nyf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ela kwa kukala k'afwendzi kuaudhi, enda vivi hatha ko ziyani ukatsuhe kiloo. Ro kumba ra kwandza undirorigwira rigunule mo kanwani undaona shekeli mwenga, ihale yo shekeli udze nayo urihe kodi rangu na rako.” ");
INSERT INTO nyf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Vikara wakathi uryahu, anafundzi makimuthuwa Jesu makimwamba, “Kahi za uthawali wa mulunguni mubomu ni hiye?” ");
INSERT INTO nyf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Bai kabila Jesu k'adzadzigidzya, akiiha muhoho muthithe akimuimisha ho mbere zao. ");
INSERT INTO nyf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Akiamba, “Namwambira ujeri wenye, kala k'amundagaluka na kukala here ahoho athithe, k'amundawangira ng'o wo uthawali wa mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kila andegaluka na kudzitsereza dza zho zha yuyu muhoho, iye nde mut'u mubomu kukira osi kahi za uthawali wa mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na mut'u yoyosi amuhokeraye muhoho dza yuyu kwa dzina rangu ananihokera mimi.” ");
INSERT INTO nyf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ela mut'u yoyosi andiyemuhendya mumwenga wa aa athithe manikuluhirao ahende dambi, ni baha afungwe lwalwa lwa singo atsufwe ko kahikahi ya bahari kwenye. ");
INSERT INTO nyf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Shauri yao ao mandioahendya andziyao mahende dambi. Majezo ni hatha gakale mumu dhuniani, ela shauriye iye andiyegareha. ");
INSERT INTO nyf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kwa ut'u uwo wenye bai, mukonowo ukikuhendya uhende dambi, utose uutsuhe. Hedu kigulucho kikikuhendya uhende dambi, kitose ukitsuhe. Kwani baha wangire uzimani na mukono mumwenga hedu na kigulu kimwenga, kuriko utsufwe kahi za moho wa kare na kare na mikono miri hedu magulu mairi. ");
INSERT INTO nyf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na dzitsoro rikikuhendya uhende dambi, rishukule uritsuhe. Kwani baha wangire uzimani na ch'ongo kuriko utsufwe kahi za moho wa Jehanamu. ");
INSERT INTO nyf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Dzimanyirireni sana p'ore mukaadharau ahoho athithe, kwani malaika a kwao ko mulunguni ma mbere za Baba ariye mulunguni.”  ");
INSERT INTO nyf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kwani Mwana wa Mudamu wakudzaokola kirichongamika. ");
INSERT INTO nyf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jesu akienderera kunena akiamba, “Mut'u akikala ana ng'ondzi gana mwenga gonya mwenga ikangamike, munaona nikuhendadze? Samba nikuziricha zo mirongo chenda na chenda akendaimala yo idziyongamika hatha akayona? ");
INSERT INTO nyf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na ninamwambira ujeri, akiyona andakala na raha nayo zhomu hatha kukira zo mirongo chenda na chenda zirizo k'azingamikire. ");
INSERT INTO nyf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na vizho ndo virizho hatha kwa Mulungu Babiyehu wa mulunguni. Iye, k'endzi aa ahoho athithe mangamike hatha mumwenga.” ");
INSERT INTO nyf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ndugu akikukosera, muthuwe wiri wenu, ukamuzhagazhe umwambire makosage. Akigakubali ni vidzo, undakala udzamupata. ");
INSERT INTO nyf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kala k'andagakubali, mala mut'u mumwenga hedu airi mwende nyosini ili kila neno rindironenwa rikale na mashahidhi airi hedu ahahu. ");
INSERT INTO nyf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Akikala k'andakubali, enda ukariambire kanisa. Akikubali, vidzo, k'akubalire, muhalire mut'u yuyahu dza ungazhomuhalira mut'u asiyemumanya Mulungu hedu here muthozi wa kodi. ");
INSERT INTO nyf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nami namwambira ujeri kukala kila mundichokifunga haha dhuniani hatha ko mulunguni nako kindakala kidzafungwa, na kila mundichokivugula haha dhuniani hatha ko mulunguni nako kindakala kidzavugulwa. ");
INSERT INTO nyf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kidza at'u airi kahi zenu makikubaliana dzulu za ut'u wowosi mandiwouvoya haha dhuniani, Babiyenu wa mulunguni andaahendera. ");
INSERT INTO nyf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwani at'u airi hedu ahahu mathungananaho kwa dzina rangu nindakala hamwenga nao.” ");
INSERT INTO nyf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jesu arihogonya kunena, P'et'ero akimuza akimwamba, “Bwana, mwandzangu akinikosera kwenda-kwenda, nimusamehe hatha k'ana nyingahi? Vidze nimusamehe k'ana fungahe?” ");
INSERT INTO nyf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu akimudzigidzya akimwamba, “Hatha bule, simusamehe k'ana fungahe thu, musamehe k'ana mirongo mifungahe mara fungahe.” ");
INSERT INTO nyf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kidza Jesu akiamba, “Ndo hatha uthawali wa mulunguni udzahalana na muthawali mumwenga ariyekala anamala kuhenda isabu za p'esa arizoap'a ahumikie. ");
INSERT INTO nyf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","K'ona shuhuli iyo irihoandza thu, akireherwa muhumikiwe mumwenga ariyekala anamwisa t'alant'a alifu kumi. ");
INSERT INTO nyf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na kwa kukala were k'adima kuziriha, ye muthawali akiamuru kukala aguzwe hamwenga na adamue osi, na vit'uzhe zhosi, ili zo p'esa zindizopatikana zirihe ro dheni. ");
INSERT INTO nyf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ela ye muhumiki akimugwerera maguluni ye muthawali, akimuvoya akiamba, ‘Bwana, kala radhi nami unip'e muda nami ndakuriha p'esazo zosi.’ ");
INSERT INTO nyf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","K'uzhona ye muthawali moyo ukimutika madzi hatha ro dheni akimusamehe, na akimuvugula akimurichira. ");
INSERT INTO nyf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ela kula haho kare, achendamona muhumiki mwandziwe ariyekala anamwisa dinari gana mwenga thu. K'uzhona akimugwavukira kare, gwa, akimugwira mumiro. Cha ‘Niriha p'esa zangu.’ ");
INSERT INTO nyf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Bai ye mwandziwe akimugwerera maguluni akimwamba, ‘Kala radhi nami unip'e muda nami ndakuriha p'esazo,’ ");
INSERT INTO nyf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ela akikahala kamare. Akimuhala akimuhirika jela achendafungwa muhaka ho andihomarigiza kuriha. ");
INSERT INTO nyf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Vikara ahumiki andziye marihoona viryahu mashikithika zhomu hatha machendamusema kwa muthawali. ");
INSERT INTO nyf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Bai, muthawali arihosikira uv̱oro uryahu, wamwiha mara mwenga yuyahu muhumiki ariyekala wamusamehe akimwamba, ‘We kumba u muthiriri vivi we! Waniririra nami nikikusamehe dheniro rosi, ");
INSERT INTO nyf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ela mbona we ye mwandziyo k'umuonerere mbazi dza vizho nirizhokuonera mbazi?’ ");
INSERT INTO nyf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","K'uzhona ye muthawali akitsukirwa zhomu hatha akiaiha shikari a jela madze mamuhale makamufunge muhaka ho andihomarigiza kuriha ro dhenire. ");
INSERT INTO nyf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na vizho zhenye ndizho andizhohenda Baba wa mulunguni, kala k'amundaasamehe andziyenu na moyo mumwenga.” ");
INSERT INTO nyf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Vikara Jesu arihogonya kufundisha anafundzie dzulu za kusameheana, wambola Galilaya achenda hatha achangira jimbo ra Judea, kuvuka muho wa Jorodani. ");
INSERT INTO nyf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bai makundi-makundi ga at'u makimuthuwa kuko, naye akiahoza akongo ao. ");
INSERT INTO nyf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bai Mafarisayo makidzamujeza makimuza, “Vidze ni hachi mut'u kumuricha muchewe kwa sababu yoyosi?” ");
INSERT INTO nyf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu akiadzigidzya akiamba, “Vidze k'amudzashoma kukala ye ariyeaumba ho chaho waaumba muche na mulume. ");
INSERT INTO nyf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kidza akiamba, ‘Kwa ut'u uu mut'u andamuricha babaye na mameye agwirane na muchewe, na ao airi mandakala mwiri mumwenga.’ ");
INSERT INTO nyf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bai, madzauya si airi kaheri, ni mwiri mumwenga. Kwa vizho adzichokigwizanya Mulungu, mudamu asikitose bule.” ");
INSERT INTO nyf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Marihosikira vizho o Mafarisayo makiamba, “Ni kwanoni Musa walagiza kukala, kala unamala kumuricha mucheo niumup'e cheti cha kurichana gonya umuriche?” ");
INSERT INTO nyf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesu akiadzigidzya akiamba, “Musa wamuruhusu muriche ache enu kwa kukala mu at'u a singo nyomu, ela ho kwandza were si vizho bule. ");
INSERT INTO nyf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na vivi ninamwambira kukala mut'u yoyosi amurichaye muchewe, isihokala kwa kosa ra uzindzi, na kuhala muche mungine, anazinga.” ");
INSERT INTO nyf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bai o anafundzie marihosikira viryahu makimwamba Jesu, “Kala ni vizho be hatha si baha kuthuwa kukala mudhaka kamare bai.” ");
INSERT INTO nyf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ela Jesu akiadzigidzya akiamba, “Munaona kila mut'u anadima kukala mudhaka nwi? Hatha, ni aryahu mariojaliwa ni Mulungu makale vizho ndo mazhadimao. ");
INSERT INTO nyf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kwani kuna at'u mario k'amadima kuhala ache kwa kukala mazhalwa kare k'aviamba kit'u. Angine o k'amadima kuhala kwa kukala mathulwa. Ela angine o, k'amahala kuhendza kwao kare, ili madzilazhe kamare-kamare kahi za uhumiki wa uthawali wa mulunguni. Bai azhadimaye naavihende.” ");
INSERT INTO nyf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wakathi mumwenga, at'u mareha ahoho athithe kwa Jesu ili adze aaikire mikono aavoyere, ela anafundzie makiadumulira. ");
INSERT INTO nyf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ela Jesu akiamba, “Hatha, musiazizeni bule o ahoho, aricheni madze kwangu, kwa kukala wo uthawali wa mulunguni be ni wa at'u dza vizho ao.” ");
INSERT INTO nyf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nao marihokudza akiaikira mikono gonya akihauka. ");
INSERT INTO nyf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Siku mwenga, mwanamulume mumwenga wakwenda kwa Jesu achendamuza akiamba, “Mwalimu, ni ut'u wani udzo nidimao kuuhenda hatha nami nangire uzima wa kare na kare?” ");
INSERT INTO nyf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Bai Jesu akimudzigidzya akimwamba, “Kwanoni unanuza mimi dzulu za udzo? Kuna mudzo mumwenga thu, ela ukimala kwangira uzimani, gwira malagizo gosi nawe undawangira.” ");
INSERT INTO nyf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Iye mwanamulume akimuza Jesu akiamba, “Malagizo higo?” Jesu akimudzigidzya akimwamba, “Usalage, usizinge, usiiye, usimboze ushahidhi wa ulongo, ");
INSERT INTO nyf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","aishimu babayo na mameyo, na muhendze mwandziyo here udzihendzazho mwenye.” ");
INSERT INTO nyf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ye muvulana akiamba, “Gago be nagagwira hangu kapindi. Vino nahungukirwa ni noni?” ");
INSERT INTO nyf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesu akimwamba, “Kala unamala ukamilike, kaguze vit'uzho zhosi na zo p'esa uap'e akiya. Nawe undakala na akiba ko mulunguni. Na ukigonya kuhenda vizho, ndzo unithuwe.” ");
INSERT INTO nyf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ye muvulana arihosikira vizho akihauka k'ana raha, mana were ana mali nyinji zhomu. ");
INSERT INTO nyf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Vikara ye mwanamulume arihouka, Jesu akinena na o anafundzie akiamba, “Namwambira ujeri, vindakala vikomu sana kwa thajiri kwangira kahi za uthawali wa mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ninanena kaheri, ni rahisi ngamira kukira kahi za t'undu ya shindano kuriko thajiri kwangira kahi za uthawali wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Marihosikira vizho, o anafundzie makingalala zhomu makiamba, “Hatha ni h'ani adimaye kuokoka be zho?” ");
INSERT INTO nyf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Marihouza vizho, Jesu akialola gonya akiamba, “Kwa nguvu za mudamu, vizho k'azhadimikika, ela kwa Mulungu, kila kit'u kinadimikika.” ");
INSERT INTO nyf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","P'et'ero akimwamba, “Lola, fwaricha zhosi hukikuthuwa uwe, vino hundapatani?” ");
INSERT INTO nyf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesu akimudzigidzya akiamba, “Namwambira ujeri, haho Mwana wa Mudamu andihokudza kelesi dzulu za kihi cha endzi kahi za wo urumwengu musha, ninwi mundakelesi dzulu ya vihi kumi na viri zha endzi na muhukumu zo kabila kumi na mbiri za Iziraeli. ");
INSERT INTO nyf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na kila ariyericha nyumbaze, na azhazie, na nduguze, na adamue, na mundawe, kwa ut'u wa dzina rangu, zho arizhoviricha andarifwa mara gana, kidza andapata uzima wa kare na kare. ");
INSERT INTO nyf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ela anji mario vivi ni a kwandza, mandakala a mwisho, na a mwisho, mandakala a kwandza.” ");
INSERT INTO nyf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Kwani uthawali wa mulunguni udzahalana na mwenye nyumba ariyekala na munda wa mizabibu. Mut'u iye warauka madzach'a maitsi genye kwendamala vibaruwa mende makamuhendere kazi mundani kwakwe. ");
INSERT INTO nyf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bai arihoapata makisikizana kukala andaariha dinari mwenga kutswa. Marihogonya kusikizana akiahirika ko mundani kwakwe. ");
INSERT INTO nyf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Inapiga saa t'ahu achendathekeza at'u angine mariokala makelesi ho sokoni thu na kazi ya kuhenda k'amana. ");
INSERT INTO nyf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ye mwenye munda akiambira, ‘Hatha ninwi nanwi hindeni mukanihendere kazi kuryahu mundani kwangu, nami nindamurihat'o.’ Nao machenda jeri. ");
INSERT INTO nyf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bai vivi wavithuwa hatha mara mbiri, murongo wa saa t'andahu na murongo wa saa chenda. ");
INSERT INTO nyf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Saa kumi na mwenga irihokala i hehi achenda ko sokoni kaheri, na achendadulukiza at'u mariokala madzadzikelesira thu. Akiauza, ‘Kwanoni hangu kudzecherera mukelesi thu?’ ");
INSERT INTO nyf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","O at'u makimudzigidzya makimwamba, ‘Fundakosadze kukelesi naswi k'ahudzaona mut'u wa kuhup'a kazi?’ Ye mwenye munda akiamba, ‘Andziyenu kinawaka kare ko mundani, kwa vizho endani mukagwirane nao.’ ");
INSERT INTO nyf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Bai, at'u aryahu mahenda kazi vivii hatha kukitswa. K'ona yuyahu mwenye munda akimulagiza munyaparawe akaihe o ahendzi a kazi adze aarihe. Bai, waandza na aryahu arioapata mwisho, hatha akimarigiza na aryahu arioapata kwandza. ");
INSERT INTO nyf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Vikara aryahu at'u mariohirikwa ko mundani saa kumi na mwenga marihokudza, makirifwa dinari mwenga-mwenga. ");
INSERT INTO nyf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aryahu at'u mariohirikwa ko mundani kwandza marihokudza, makiona here kwamba mandangezwa, ela k'avikalire vizho bule, ao nao makirifwa dinari mwenga-mwenga. ");
INSERT INTO nyf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Vikara marihoona kukala madzarifwa karakara na o angine, machendamulalamikira ye mwenye munda makiamba, ");
INSERT INTO nyf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Siswi fudzahenda kazi hangu madzach'a hatha vivi. Dzuwa rosi ridzagomera mwirini mwehu, gonya unafuriha karakara na aa madziohenda kazi kwa saa mwenga thu-thu-thu.’ ");
INSERT INTO nyf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ye mwenye munda akimudzigidzya mumwenga wao akiamba, ‘Musena, ro kosa nidziromuhendera nwi ni hiro? Samba fudzasikizana kukala nimurihe dinari mwenga kutswa nwi? ");
INSERT INTO nyf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mimi mwenye nidzaona nimurihe ninwi a kwandza karakara na o a mwisho, kwa vizho halani p'esa zenu mwende. ");
INSERT INTO nyf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Namanya muna wivu kwa wo udzo nidziwouhenda. Ela ni lazima mumanye kukala nina uhuru wa kuhumira p'esa zangu nihendzazho.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bai Jesu arihogonya kuthala ro fumbo riro akiamba, “Kwa vizho bai a kwandza mandakala a mwisho, na a mwisho mandakala a kwandza.” ");
INSERT INTO nyf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Vikara Jesu na anafundzie marihokala ma ngirani kwenda Jerusalemu, waavuha k'anda o anafundzie kumi na airi akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Lolani, vivi hunenda Jerusalemu. Na kuko Mwana wa Mudamu andalazhwa kwa alombi abomu na alimu a Sheria, nao mandamuhukumu kwalagwa. ");
INSERT INTO nyf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kidza ao nao mandamulazha kwa at'u mario si Ayahudi mamusholere, mamupige, gonya mamusulubishe, ela siku ya hahu andafufulwa.” ");
INSERT INTO nyf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Vikara kahi za wakathi uryahu, mameye Johana na Jakobu ana a Zebedayo, wakwenda kwa Jesu hamwenga na anae. Anafika kuko, akimupigira mavindi Jesu akimwamba, “Bwana, nifwaha na ut'u umwenga.” ");
INSERT INTO nyf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesu akimuza akimwamba, “Nikufwahe na noni?” Ye mwanamuche akimwamba, “Undihokwacha kuthawala, nakuvoya, uruhusu kukala, mwanangu mumwenga akelesi mukonowo wa kurya na mungine akelesi mukonowo wa kumots'o.” ");
INSERT INTO nyf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ela Jesu akimugalukira Jakobu na Johana akiamba, “Ninwi be tha k'amukimanya bule cho mukivoyacho. Vidze cho kikombe ninwacho munadima kukinwa nwi?” Nao makiamba, “Ee funadima.” ");
INSERT INTO nyf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Bai marihonena vizho Jesu akiamba, “Ee kikombe changu mundakinwa. Ela kumutsagula yuya akelesi mukono wa kurya, yuya mukono wa kumots'o, sina wadimi nazho bule. Kwani kuko, Baba wakutengezera at'ue, na ao ndo mandiokala kuko.” ");
INSERT INTO nyf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Vikara o anafundzi kumi marihovisikira, makiatsukirirwa o ndugu airi. ");
INSERT INTO nyf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ela Jesu akiaiha osini akiamba, “Munamanya kukala athawali a at'u mario si Ayahudi manahendza kuthawala at'u ao na ukali munji. Na aryahu abomu mario ts'ini zao nao, manahendza kuhumira wadimi wao wosi kuatumisha o at'u. ");
INSERT INTO nyf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ela ninwi musikale vizho bule. Iye ahendzaye kukala mubomu suthi akale muhumiki wenu. ");
INSERT INTO nyf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na kila ahendzaye kukala kitswa kahi zenu, suthi akale mutumwa wenu. ");
INSERT INTO nyf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kwani hatha Mwana wa Mudamu naye k'adzire haha urumwenguni adze ahumikirwe, ela wakudza ahumike na alazhe uzimawe aakombole at'u anji.” ");
INSERT INTO nyf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Badaye, Jesu na anafundzie marihokala manambola mudzi wa Jeriko, kundi bomu ra at'u rambola hamwenga nao rikiathuwa. ");
INSERT INTO nyf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Vikara were kuna vipofu airi mariokala makelesi k'anda za yo barabara. Lola marihosikira kukala Jesu anakira, maluta mimiro makiamba, “Mwana wa Daudi huonere mbazi!” ");
INSERT INTO nyf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","O at'u makiadumulira makiamba manyamale, ela o hatha makikaza kuluta mimiro makiamba, “Bwana, mwana wa Daudi huonere mbazi!” ");
INSERT INTO nyf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesu akiima, akiaiha akiamba, “H'aya munamala nimuhendereni?” ");
INSERT INTO nyf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","O vipofu makiamba, “Bwana, funamala ugunule matso gehu.” ");
INSERT INTO nyf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bai Jesu akiaonera mbazi akiagut'a go matso gao, na haho henye makikwacha kuona na makimuthuwa. ");
INSERT INTO nyf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Vikara Jesu na anafundzie marihokala ma hehi na Jerusalemu, mafika Beth'ifage, kuko Murima wa Mizeituni. Bai marihofika kuko, Jesu akihuma anafundzie airi akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Endani hatha mwangire ko kadzidzi mudzikoerekezana nako. Mukifika thu mundaona ndzowe na mwanawe madzafungwa. Avuguleni munirehere. ");
INSERT INTO nyf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mut'u yoyosi akimuza mwambireni kukala, ‘Bwana ana haja nao.’ Naye andaarichira mara mwenga.” ");
INSERT INTO nyf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bai gosi gahendeka ili garyahu maneno garigonenwa ni nabii gathimire. Kwani nabii mumwenga wanena akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ambireni at'u a mudzi wa Sayuni kukala, ‘Lolani, muthawali wenu anamudzirira. Ni mup'ore na adzakwera dzulu za ndzowe, kidza mwana wa ndzowe.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","K'uzhona o anafundzi makiuka na machendahenda here marizhokala madzalagizwa ni Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Makimureha ye ndzowe na mwanawe, makihala maamba gao makihandika ho dzulu zao na Jesu akikwera. ");
INSERT INTO nyf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","At'u anji makihala maamba gao makigahandika mo ngirani, angine o makithema vitai zha mihi makivihandika mo ngirani. ");
INSERT INTO nyf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bai go makundi ga at'u mariokala mbere na mariokala nyuma osi makikwacha kuimba kwa nguvu makiamba, “Naalikwe ye mwana wa Daudi! Naahaswe iye adzaye kwa dzina ra Bwana! Naalikwe ye Mulungu ariye dzulu!” ");
INSERT INTO nyf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesu arihongira Jerusalemu, mudzi wosi wadudumuka na at'u makiuza, “Ni h'ani ye?” ");
INSERT INTO nyf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bai o at'u mariokala na Jesu makidzigidzya makiamba, “Ni Jesu, yuyahu nabii wa kula Nazareth'i kuko Galilaya.” ");
INSERT INTO nyf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesu arihongira kahi za ro Hekalu, waainga at'u osi mariokala makigula na kuguza vit'u mo Hekaluni. Kidza akihala zo meza za abandi a p'esa, na vihi zha aguzi a magiya, akivipetula-petula zhosi. ");
INSERT INTO nyf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Gonya akiamba, “Zhaorwa kukala, ‘Nyumba yangu indaifwa nyumba ya mavoyo,’ ela ninwi munaihendya p'anga ya kuzama aivi.” ");
INSERT INTO nyf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bai at'u anji mariokala k'amaona, na vidende makimuthuwa Jesu mo Hekaluni, naye akidzaahoza. ");
INSERT INTO nyf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ela vikara o alombi abomu na alimu a Sheria marihoona go maut'u mabomu arigokala akigahenda Jesu, na zho ahoho marizhokala manapiga londzo na kuamba, “Mup'eni nguma Mwana wa Daudi!” mo Hekaluni makitsukirwa sana. ");
INSERT INTO nyf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bai makimuza Jesu makiamba, “Unaasikira o ahoho zho manenazho?” Akiadzigidzya akiamba, “Ee ninaasikira. Ela go Maoro gaambago, ‘Wapata nguma kwa makanwa ga ahoho athithe na ana atsanga’ k'amudzagashoma?” ");
INSERT INTO nyf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Naye arihogonya kunena vizho akimwambola mumo Jerusalemu achendalala mudzi wa Beth'ania. ");
INSERT INTO nyf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kunadzacha, Jesu warauka na madzach'a akikwacha kuuya Jerusalemu. Bai mumo ngirani akisikira ndzala. ");
INSERT INTO nyf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Akiona mutini ho k'anda-k'anda za ngira. Achendaulola chamba una matunda, ela k'apatire, mana were u gi makodza mahuhu. Jesu akiulani uryahu muhi akiamba, “Nawe k'undazhala matunda kaheri.” Nawo haho na haho kare ukiuma. ");
INSERT INTO nyf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","K'uzhona o anafundzi marihoona viryahu machangalala zhomu, makiamba, “Muhi uno be tha udzanyaladze haraka vino?” ");
INSERT INTO nyf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ela Jesu akiadzigidzya akiamba, “Ninamwambira ujeri kukala, mukikuluhira bila kukala na k'ai-k'ai mundahenda ut'u dza uu nidziwouhenda, na hatha zaidhi. Mundadima hatha kuwambira uu murima, ‘Ng'oka ukagwe baharini.’ Na vindakala vizho zhenye. ");
INSERT INTO nyf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mukikala na kuluhiro mundahokera kila mundichokivoya.” ");
INSERT INTO nyf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Bai Jesu akiuya kahi za ro Hekalu na akikwatya kufundisha. Arihokala akufundishani, alombi abomu na athumia a Kiyahudi makidzamuza makimwamba, “Unahenda maut'u gano kwa wadimi wani? Na ni h'ani ariyekup'a wadimi uno?” ");
INSERT INTO nyf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu akiamba, “Hatha mimi nindamuza swali, mukiridzigidzya, nindamwambira ni wadimi wani nihenderao maut'u gaga. ");
INSERT INTO nyf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wo wadimi ariohumira Johana kubat'izira at'u walahi? Wala kwa Mulungu hedu wala kwa anadamu?” O alombi abomu na o athumia makiojana makiamba, “Fukiamba wala kwa Mulungu, andafuza, ‘Kwanoni k'amumukuluhirire?’ ");
INSERT INTO nyf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na hukiamba, ‘Wala kwa mudamu,’ fu hatharini, mana aa at'u osini manakuluhira kukala Johana were ni nabii.” ");
INSERT INTO nyf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kwa vizho makimwamba Jesu, “K'ahumanya.” Jesu naye akiamba, “Hatha mimi nami sindamwambira wo wadimi nihumirao kuhendera maut'u gaga.” ");
INSERT INTO nyf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesu arihogonya kuadzigidzya o alombi abomu na o athumia, waambozera mufano akiamba, “Nambirani ut'u umwenga hedu. Kwakala na mut'u mumwenga ariyekala na athana airi. Siku mwenga akimwamba ye muthana mukulu, ‘Rero enda ukarime ko munda wa mizabibu.’ ");
INSERT INTO nyf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mwana anambola kunena akiamba, ‘Aa sindakwenda mino.’ Ela gonya ye mukulu akigalukwa ni moyo hatha achenda. ");
INSERT INTO nyf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kula haho, ye bimut'u achenda kwa ye wa hiri achendamwamba, ‘Rero enda ukarime ko munda wa mizabibu.’ Ye mwana akiamba, ‘H'aya ndakwenda.’ Ela k'endere bule. ");
INSERT INTO nyf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Vikara kahi za ano airi ni hiye ariyehenda malagizo ga babaye?” Makiamba, “Ni iye mukulu.” Jesu akiamba, “H'aya, hatha mimi nami namwambira ujeri wenye kukala athozi a kodi na malaya manangira kahi za uthawali wa Mulungu mbere zenu. ");
INSERT INTO nyf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwani Johana Mubat'izaji wakudzamwanyesa ngira ya hachi, ela k'amumukuluhirire, athozi a kodi na malaya o makimukuluhira. Nwi ng'o kamare, hatha bada ya kuona kukala andziyenu madzamukuluhira kidza nwi k'amugalukirwe ni mioyo.” ");
INSERT INTO nyf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Bai Jesu arihogonya kunena vizho akiamba, “Sirikizani nimwambire fumbo ringine bai. Kwakala na mwenye nyumba mumwenga ariyerima mundawe akiulaya mizabibu, akiudengereshera wiyo, akitsimba wina wa kukamulira zabibu, gonya akiaka uringo wa kurindira. Kugonya vizho, akiukodisha kwa ak'urima, gonya ye mwenye achenda ts'i nyingine. ");
INSERT INTO nyf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Makathi ga mavuno garihofika, waahuma ahumikie mende makagerwe muthalowe wa zabibu ni o ak'urima. ");
INSERT INTO nyf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bai o ak'urima marihoaona o ahumiki, mahala mumwenga makimupiga, mumwenga makimukot'a mawe, na mumwenga makimwalaga. ");
INSERT INTO nyf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Bai, ye mwenye munda akihuma ahumiki angine, anji kukira o arioahuma kwandza. Ela hatha ao nao k'amapatire kit'u, kwani mahendwa dza zho zha andziyao. ");
INSERT INTO nyf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ye mwenye munda arihoona vizho akiamba, ‘Charo kiki huriza nimuhume mwanangu. Bila shaka iye mandamuishimu.’ ");
INSERT INTO nyf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ela o ak'urima marihomona ye mwana akudzani, makiamba, ‘Yuno be hatha se andiyeuhala ufwa uno munda? Alume nahumwalage yuyu, uu munda ukale wehu.’ ");
INSERT INTO nyf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Makimuhala kare makimwamboza ndze ya wo munda makimwalaga. ");
INSERT INTO nyf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Vikara, munaona ye mwenye munda akidza andaahendadze arya ak'urima?” ");
INSERT INTO nyf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Makidzigidzya makiamba, “Andaahala o ak'urima aalage, gonya wo munda aap'e ak'urima angine mandiokala makimup'a muthalowe wa zabibu kila mavunaho.” ");
INSERT INTO nyf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesu akiamba, “Hedu k'amudzangwe kugashoma go Maoro gaambago, ‘Ro iwe ririrokahalwa ni aaki vivi be ridzagaluka ndo iwe bomu ra p'embeni. Ut'u uwo wahendwa ni Bwana, Na fukiulola unafwangalaza?’ ");
INSERT INTO nyf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kwa vizho be namwambira kamare kukala, wo uthawali wa Mulungu mundauhokwa na ugerwe at'u mandioishi maisha ga kumufwahiza Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Na iye andiyerigwerera iwe riro andabandika-bandika. Ela mut'u yoyosi rindiyemugwerera, rindamusaga tikitiki.” ");
INSERT INTO nyf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","O alombi abomu na o Mafarisayo marihosikira go mafumbo ga Jesu, makimanya kukala manaambwa ao. ");
INSERT INTO nyf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kwa vizho makijeza kumugwira mamushithaki, ela makishindwa kwa kukala were manaagoha o at'u. Kwani o at'u were manamona Jesu ni nabii. ");
INSERT INTO nyf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Bai Jesu akienderera kufundisha at'u kwa kuhumira mafumbo. Akimboza fumbo ringine kaheri akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Uthawali wa mulunguni, udzahalana na muthawali mumwenga ariyekala anamuusira harusi muthanawe. ");
INSERT INTO nyf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bai arihokala a thayari, waahuma ahumikie makaaihe aryahu at'u ariokala waasunga, ela k'amendere. ");
INSERT INTO nyf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Vikara arihoona viryahu, akihuma ahumikie angine akiamba, ‘Kaambireni kukala nidzatsindza ndzao zangu kare, hamwenga na vidzao zhangu zha kunona, na nidzathayarisha kila kit'u hatha masere ao madze marye harusi.’ ");
INSERT INTO nyf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Marihokwendaambirwa mavihalira madhe-madhe. Kila mut'u akithuwa shuhulize. Mumwenga akigwira ngira achenda mundani, mungine achenda biasharani kwakwe. ");
INSERT INTO nyf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Angine o makiagwira o ahumiki makiahendera makuruhu na makialaga. ");
INSERT INTO nyf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Muthawali arihosikira vizho akidzalwa ni k'oro, akihuma shikarie machendaalaga osi o alagi, na wo mudzi wao makiuocha. ");
INSERT INTO nyf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Bai bada ya vizho, ye muthawali akiahuma ahumikie kaheri akiamba, ‘Lolani harusi i thayari ela o nirioasunga tha were k'amav̱irya kamare. ");
INSERT INTO nyf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kwa vizho endani ko ngira-ngira na kila mut'u mundiyemona musungeni adze. Rehani at'u anji zhadimikikazho.’ ");
INSERT INTO nyf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","O ahumiki machenda mo ngira-ngira, makireha kila namuna ya at'u, adzo na ai. Hatha vinatululia, yo nyumba ya harusi ikidzala thele at'u. ");
INSERT INTO nyf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Vikara wakathi arihokwendaalola o ajeni, akipesa mut'u mumwenga ariyekala k'avalire nguwo ya harusi bule. ");
INSERT INTO nyf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Akimuza akimwamba, ‘Musena, udzangiradze muno bila kuvala nguwo ya harusi?’ Ye mut'u akisala wa kanwa ngh'aa. ");
INSERT INTO nyf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bai ye muthawali akialagiza ahumikie akiamba, ‘Muhaleni mumufunge mikono na magulu mumutsuhe ko ndze kizani. Na kuko kundakala na kiriro na kwafuna meno.’ ");
INSERT INTO nyf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Kwani ni anji masungwao, ela o matsagulwao ni achache.” ");
INSERT INTO nyf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ndo o Mafarisayo machenda njama, ili makapange viryahu mandizhomuhega Jesu na maneno ga kwakwe hatha mapate ut'u wa kumushithakira. ");
INSERT INTO nyf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bai marihogonya kupanga, makiahuma anafundzi ao, na at'u a Herode. Bai, at'u ao makwenda hatha kwa Jesu machendamwamba, “Mwalimu, hunamanya kukala uwe u mujeri. Unafundisha at'u zho Mulungu ahendzazho maishi, kwa ngira ya ujeri kamare. K'ugoha mut'u yoyosi hatha kala ana cheo chani. Mana k'ulola at'u kwa uso. ");
INSERT INTO nyf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bai fwambire. Kuriha kodi kwa Kaisari ni karakara hedu si karakara?” ");
INSERT INTO nyf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesu arihosikira vizho, akiimanya kare yo njama yao mbii mariyokala madzapanga, akiamba, “H'enwi adzihendyi! Kwanoni munanihega? ");
INSERT INTO nyf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nanyesani yo p'esa murihirayo kodi hedu.” Makimboza dinari makimup'a. ");
INSERT INTO nyf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bai Jesu akiauza akiamba, “Ino sura iriyo muno p'esani na ro dzina ni zha h'ani?” ");
INSERT INTO nyf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Makiamba, “Ni zha Kaisari.” Jesu akiambira, “Kwa vizho, zha Kaisari mup'eni Kaisari mwenye, na zha Mulungu nazho mup'eni Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nao marihosikira vizho, makingalala sana gonya sio, makimuricha haho makihauka. ");
INSERT INTO nyf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Siku iyo vizho, Masadukayo nao makidza kwa Jesu. At'u aa Masadukayo, k'amakuluhira kukala kuna kufufuka. Makimuthuwa Jesu makimwamba, ");
INSERT INTO nyf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mwalimu, Musa waamba kukala, mut'u akifwa kabila kupata ahoho, ye muchewe ahalwe ufwa ni nduguye ili amuzhalire ahoho ye mufwadzi. ");
INSERT INTO nyf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Vikara wakathi mumwenga hatoa ndugu afungahe haha. Ye mukulu akihala muche na akinongeka kabila kupata ahoho. Kwa vizho ye muche akihalwa ufwa ni nduguye. ");
INSERT INTO nyf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Iye naye akifwa bila kupata ahoho. Bai zhaenderera vizho hatha o ndugu afungahe osini makigoma kufwa hatha akisala ye muche. ");
INSERT INTO nyf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Iye naye akiathuwa. ");
INSERT INTO nyf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Vikara at'u mandihofufuka, yuno mwanamuche andakala mukaza h'ani na kila ndugu wamuhala?” ");
INSERT INTO nyf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesu akiadzigidzya akiamba, “Munahenda makosa kwa kukala k'amumanya Maoro, kidza k'amumanya nguvu za Mulungu zirizho. ");
INSERT INTO nyf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwani makathi at'u makifufuka, kundakala k'akuna kuhala hedu kuhalwa. At'u osi mandakala here malaika a mulunguni marizho. ");
INSERT INTO nyf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na dzulu za at'u kufufulwa, k'amudzahashoma harya hat'u Mulungu arihonena nanwi akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ndimi Mulungu wa Burahemu, na Isaka, na Jakobu?’ Mulungu ni Mulungu wa at'u mario moyo, si wa at'u mariofwa!” ");
INSERT INTO nyf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Na o at'u marihosikira zho Jesu afundishazho, makingalala kamare. ");
INSERT INTO nyf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ela Mafarisayo marihosikira kukala Jesu adzaanyamaza o Masadukayo, makithunganana kaheri. ");
INSERT INTO nyf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bai mumwenga wao, ariye were ni mwalimu wa Sheria akimuza Jesu swali ra kumujeza. ");
INSERT INTO nyf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Akiamba, “Mwalimu, amuri bomu kukira zosi ni hiyo kahi za Sheria?” ");
INSERT INTO nyf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","K'uzhona Jesu akimudzigidzya akimwamba, “ ‘Muhendze Bwana Mulunguo na moyowo wosi, na rohoro rosi, na akilizo zosi.’ ");
INSERT INTO nyf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ii ndo amuri ya kwandza na bomu kukira zosi. ");
INSERT INTO nyf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na ya hiri yenye mana dza iyo, ni, ‘Muhendze mwandziyo here udzihendzazho mwenye.’ ");
INSERT INTO nyf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Amuri zizi mbiri, ndo musinji wa Sheria zosi za Musa, na mafundisho gosi ga manabii.” ");
INSERT INTO nyf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Vikara o Mafarisayo marihokala machere kahi za wo muthunganano wao, Jesu akiuza swali akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yuno Masihi nwi, munamona ni mwana wa h'ani?” Makiamba, “Ni mwana wa Daudi.” ");
INSERT INTO nyf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesu akiamba, “Kala ni vizho, mbona Daudi arihokala adzadzalwa ni nguvu za Roho Mweri, wamwiha ye Masihi ‘Bwana’? Kwani Daudi waamba, ");
INSERT INTO nyf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bwana Mulungu wamwamba Bwana wangu, “Kelesi mukono wangu wa kurya, muhaka mahadhuio niathambaraze kamare ts'ini za magulugo.” ’ ");
INSERT INTO nyf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Bai kala Daudi wamwiha Masihi, ‘Bwana,’ anadimadze kukala mwanawe?” ");
INSERT INTO nyf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Swali riri rikiashinda kamare. Na kula siku iyo, k'ahana mut'u hatha mumwenga ariyedzambozeza kumuza swali Jesu kaheri. ");
INSERT INTO nyf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesu arihogonya kunena vizho, akiambira o anafundzie hamwenga na ro kundi ra at'u akiamba, ");
INSERT INTO nyf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Alimu a Sheria, na Mafarisayo ndio mariohala hat'u ha Musa. Manamufundisha na kumueleza Sheria ziambazho. ");
INSERT INTO nyf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kwa vizho gagwirenit'o go mafundisho gao, ela mahendo gao musigathuwe bule. Mana zho mafundishazho si zho mahendazho bule. ");
INSERT INTO nyf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kazi yao ni kufunga mizigo miziho-miziho isiyotsukulika na kuabagaza at'u angine maitsukule bila hatha kwangiza mukono. ");
INSERT INTO nyf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kila kit'u mandichokihenda manakihenda ili maonewe. Lolani zho vidude zhenye Maoro maeri mo vidhanguni na mikononi mwao, ni vibomu kukira zha at'u angine. H'e yo mitsa ya zo k'andzu zao, samba ni mire kukira ya andziyao. ");
INSERT INTO nyf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hat'u hajani manahendza kukelesi kuko mbere-mbere kwenye ajeni a ishima. Kahi za masinagogi ko, undaaona makelesi kuko mbere. ");
INSERT INTO nyf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Makifika masokoni, manahendza kulamuswa-lamuswa na ishima ni at'u na kuifwa ‘Alimu.’ ");
INSERT INTO nyf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ela mino ninamwambira kukala, musikubali kuifwa ‘Alimu’ kamare, kwa kukala ninwi mu ndugu na mwalimu wenu ni mumwenga. ");
INSERT INTO nyf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Musihale mut'u yoyosi haha dhuniani mukamwiha ‘Baba’ kwa kukala Babiyenu ni mumwenga thu, naye a dzulu mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kidza p'ore mukaifwa ‘Abomu’ bule, mana mubomu wenu ninwi ni mumwenga, naye ni Masihi. ");
INSERT INTO nyf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ela ye mut'u mubomu kumukira nyosi suthi akale muhumiki wenu. ");
INSERT INTO nyf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kwani kila andiyedzinula andatharamushwa, ela andiyedzitharamusha andanulwa.” ");
INSERT INTO nyf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Shauri yenu ninwi Mafarisayo na alimu a Sheria, kudzihendya kwenu nwi! Munaafungira at'u masingire kahi za uthawali wa mulunguni. Ninwi enye k'amwendzi kwangira, na hatha aryahu mamalao kwangira nao munaaziza.  ");
INSERT INTO nyf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Shauri yenu ninwi alimu a Sheria na Mafarisayo, kudzihendya kwenu nwi! Munaahoka ache magungu vit'u zhao. Gonya mukila haho, munadzihendesha kwa kuvoya mavoyo mare-mare. Adhabu yenu indakala k'ali zaidhi. ");
INSERT INTO nyf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Shauri yenu ninwi alimu a Sheria na Mafarisayo, kudzihendya kwenu nwi! Mu thayari kuvuka bahari na kwenda ts'i za kure, kwa kumala mwanafundzi mumwenga thu. Ela mukimupata, munamuhendya akale mui zaidhi na zo nafasi za kwangira Jehanamu zikale k'ana mbiri ya zo zenu.” ");
INSERT INTO nyf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Shauri yenu ninwi vilongozi vipofu. Mut'u akilaha kwa Hekalu munaamba kuko si kulaha, ela munaamba kulaha jeri ni kwa mut'u adziyelaha kwa dhahabu ya Hekalu. ");
INSERT INTO nyf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Vipofu ajinga nwi! Kibomu ni hicho? Ni yo dhahabu hedu ni ro Hekalu? Samba ro Hekalu ndiro rihendyayo yo dhahabu ikale eri! ");
INSERT INTO nyf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Munaamba kukala mut'u akilaha kwa cho kijaja cha kwambozera sadaka k'alahire kit'u. Ela akilaha kwa yo sadaka iriyo ho kijajani munaamba kuko ndo kulaha jeri. ");
INSERT INTO nyf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Vipofu nwi, cho kijaja na yo sadaka kibomu ni hicho? Samba cho kijaja ndo kihendacho yo sadaka ikale eri! ");
INSERT INTO nyf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kwa vizho mut'u alahaye kwa cho kijaja, analaha kwa kicho kijaja hamwenga na vit'u zhosi vindizhombozwa haho. ");
INSERT INTO nyf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na mut'u akilaha kwa Hekalu, analaha kwa riro Hekalu na kwa Mulungu ariye anakala mumo. ");
INSERT INTO nyf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na mut'u akilaha kwa dzulu mulunguni, analaha kwa kihi cha uthawali cha Mulungu na kwa Mulungu ariye ndiye akikeresiraye cho kihi kicho.” ");
INSERT INTO nyf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Shauri yenu ninwi alimu a Sheria na Mafarisayo, kudzihendya kwenu nwi! Munamboza fungu ra kumi hatha ra vilungo vithithe-vithithe here makodza ga kunuk'at'o na bizari, ela go maut'u mabomu-mabomu kahi za Sheria go k'amugathuwa bule. K'amuhenda hachi. Mbazi na kuluhiro nazho k'amuna. Munav̱irya mukale na hachi, na mbazi, na kuluhiro, na gago mangine nago musigariche. ");
INSERT INTO nyf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Vilongozi vipofu nwi! Munatsudza indzi, ela ngamira ye munamumiza.” ");
INSERT INTO nyf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Shauri yenu ninwi alimu a Sheria na Mafarisayo, kudzihendya kwenu nwi! Munahala kikombe na sahani munavigesa ko kwa ndze, ela ko ndani kuthele unyang'anyi na ndani nyalamu. ");
INSERT INTO nyf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mafarisayo vipofu nwi! Vigeseni ko ndani kwandza na ko kwa ndze kundakala kusafi.” ");
INSERT INTO nyf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Shauri yenu ninwi alimu a Sheria na Mafarisayo, kudzihendya kwenu nwi! Mu here mbira zidzizohakwa ch'ok'aa. Ukizilola ko ndze zinafwahiza, ela ko ndani kuthele misoza ya at'u a kufwa na kila namuna ya ukolo. ");
INSERT INTO nyf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ninwi nanwi mu here zizo mbira. At'u makimulola manamona mu ahachi hatha k'azhadimikika, kudzi mu thele dambi na kudzihendya kunji.” ");
INSERT INTO nyf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Shauri yenu ninwi alimu a Sheria na Mafarisayo, kudzihendya kwenu nwi! Munahala mbira za manabii na za at'u ahachi, munazijengera na kuzidona ");
INSERT INTO nyf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","na kuamba, ‘Kalaho ndiswi furioishi wakathi uwo wa akare ehu, k'afungaalagire bule o manabii.’ ");
INSERT INTO nyf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na vizho muhendazho be munadzifunga enye, mana munakubali kukala munambola kahi za lukolo luriloalaga o manabii. ");
INSERT INTO nyf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","H'aya imarigizeni iyo kazi iriyoandzwa ni akare enu. ");
INSERT INTO nyf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nyoka nwi! Kidza enye munaona mundathia kula kwa hukumu ya Jehanamu, k'amundathia bule. ");
INSERT INTO nyf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mana hatha ninamurehera manabii, na alimu, na at'u angine alachu. Ela ninwi mundaahala mualage, angine muasulubishe, na angine muapige vikotho kahi za masinagogi genu. Kidza muainge muamboze kahi za kila mudzi mandiwongira. ");
INSERT INTO nyf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kwa ut'u uwo bai, milatso ya at'u ahachi osi mariolagwa haha dhuniani indakala dzulu zenu. Kuandzira iryahu ya Abeli hatha ya Zakaria mwana wa Barakia, muriyemwalaga kahikahi za ho hat'u haeri na cho kijaja cha kwambozera sadaka. ");
INSERT INTO nyf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nami namwambira ujeri kukala, adhabu ya vifwa vizho zhosi indamugwerera ninwi at'u a kizhazi kiki.” ");
INSERT INTO nyf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Bai Jesu arihogonya kunena vizho, akikwatya kuashikithikira at'u a Jerusalemu. Akiamba, “H'enwi at'u a Jerusalemu. Kazi yenu ni kualaga manabii na kuakot'a mawe ahumiki a Mulungu mahumwao kwenu. Ni mara nyingahi nidzizomala kumukundzumanya hamwenga here k'uk'u aafinikirazho anae na mahahage, ela mudzakahala? ");
INSERT INTO nyf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lolani nyumba yenu idzarichwa ikale gandzo. ");
INSERT INTO nyf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nami namwambira kamare kukala, k'amundanona kaheri muhaka haho mundihokudzaamba, ‘Naahaswe iye adzaye kwa dzina ra Bwana.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Vikara Jesu arihokala adzambola kahi za ro Hekalu akwendani, anafundzie mamwanyesa go majengo ga ro Hekalu. ");
INSERT INTO nyf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ela Jesu akiambira kukala, “Amba munagaona gano majengo gosi zho? Be namwambira ujeri wenye k'ahana iwe hatha mwenga rindirosala dzulu za mwandziwe, kila kit'u kinadzabandwa-bandwa.” ");
INSERT INTO nyf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Bai Jesu arihombola haho, wakwendakelesi kahi za Murima wa Mizeituni. Vikara arihokala akelesi, anafundzie mamuza kinjama makiamba, “Maut'u gano gandahendeka rini? Vidze ni muv̱ano wani undiwonyesa kukala u hehi na kudza na mwisho wa dhunia udzafika?” ");
INSERT INTO nyf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu akiadzigidzya akiamba, “Dzimanyirireni hasidze mut'u akamukenga. ");
INSERT INTO nyf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwani kuna anji mandiokudza kwa dzina rangu na kuamba ao ndo Masihi, na mandakenga at'u anji. ");
INSERT INTO nyf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Na mundasikira uv̱oro wa viha vihefwazho hehi na vingine mundahenda kuvisikira uvumi, ela sogoheni, kwani ni hatha gakale gago, ela wo mwisho wa urumwengu undakala uchere mbere. ");
INSERT INTO nyf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kabila rindauka kwendapigana na kabila ringine. Uthawali undapigana na uthawali mungine. Kundakala na ndzala na ts'i indathethema hat'u-hat'u. ");
INSERT INTO nyf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ela gago gosi gandakala ni mwandzo wa utsungu thu.” ");
INSERT INTO nyf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mundagwirwa muteswe na mwalagwe. Kila mut'u andamumena haha urumwenguni kwa ut'u wa dzina rangu. ");
INSERT INTO nyf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kahi za wakathi uwo, at'u anji mandauya nyuma na makwatye kuguzana na kutsukirirwana enye kwa enye. ");
INSERT INTO nyf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kundambola manabii anji a ulongo na mandakenga at'u anji. ");
INSERT INTO nyf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na kwa kukala uthiriri undakala udzakaza zhomu, at'u mandaricha kuahendza andziyao. ");
INSERT INTO nyf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ela iye andiyevumirira hatha mwisho ndiye andiyeokoka. ");
INSERT INTO nyf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na Uv̱oro uu Udzo wa uthawali wa mulunguni undahubiriwa urumwengu muzima, ili ukale ushahidhi kwa makabila gosi, ndo wo mwisho udze.” ");
INSERT INTO nyf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mundaona kit'u cha kutsukiza na cha kwanonga, kirichonenwa ni nabii Danieli kapindi, kiimire kahi za ho hat'u haeri. (H'ewe mushomi, shomat'o ung'alirwe.) ");
INSERT INTO nyf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bai mundihoona vizho, at'u osi mandiokala Judea namachimbirire ko mirimani. ");
INSERT INTO nyf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mut'u andiyekala a dzulu za nyumba ya kwakwe asiuye mo nyumbani kwendahala kit'u chochosi. ");
INSERT INTO nyf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mut'u andiyekala a mundani asiuye mudzini kwendahala nguwoye. ");
INSERT INTO nyf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wakathi uwo vindakala vii-vii zaidhi kwa ano m'ama mandiokala mana mimba na mandiokala manaamwisa. ");
INSERT INTO nyf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Na voyani uwo wakathi mundihokala munachimbira, usikale ni wakathi wa p'eho, hedu siku ya Sabato. ");
INSERT INTO nyf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwani wakathi uwo kundakala na mateso mabomu garigo k'agadzaonewa na k'agandaonewa kaheri haha urumwenguni. ");
INSERT INTO nyf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Siku zizo za mateso Mulungu wazihunguza kwa ut'u wa at'u arioatsagula, ela kala si vizho, k'ahana hatha mut'u mumwenga angayeokoka.” ");
INSERT INTO nyf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Bai mut'u akimwamba, ‘Lola thiyuno ye Masihi!’ hedu, ‘Thiyuya kurya,’ sikuluhireni bule. ");
INSERT INTO nyf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mana kundambola ano Masihi anji a ulongo, na manabii anji a ulongo. At'u ao osi mandahenda miv̱ano mibomu ili vichadimikika maakenge hatha o at'u mariotsagulwa ni Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lolani, nidzamwambira maut'u gaga kimbere.” ");
INSERT INTO nyf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kwa vizho mut'u yoyosi andiyekudzamwambira kukala, ‘Masihi a nyika bewe!’ hedu ‘Masihi adzazama kuryahu ndani!’ hatha thuwani shuhuli zenu, musimugwire gakwe kamare. ");
INSERT INTO nyf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mana Mwana wa Mudamu andihokudza, andaonewa ni kila mut'u, dza viryahu lumethe lumethazho mwambolero wa dzuwa na lukaonewa hatha mutserero wa dzuwa. ");
INSERT INTO nyf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kwani ‘Hadzihogwa kimba, ndo nderi mathungananaho.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Bada ya siku ziryahu za mateso kukira thu, dzuwa rindangira kiza, na mwezi k'aundaala kaheri. Nyenyezi zindagwa ts'i, na nguvu za dzulu mulunguni zindathukuswa. ");
INSERT INTO nyf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Na vikigoma vizho, ko dzulu kundambola muv̱ano wa kunyesa kukala Mwana wa Mudamu akudzani. At'u a makabila gosi ga urumwengu mandarira, kidza mandamona Mwana wa Mudamu anatharamuka kuno a dzulu za maingu. Naye andatharamuka na nguvu na nguma nyinji. ");
INSERT INTO nyf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Andaahuma malaikae mapige gunda zhomu zhenye, na maakundzumanye o at'u osi mariotsagulwa ni Mulungu kula kila p'embe ya dhunia.” ");
INSERT INTO nyf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Bai dzifundisheni kula kwa mutini. Mutini t'aize zikikala nyolovu na kukwatya kumboza makodza, munamanya kare wakathi wa mavuno udzafika hehi. ");
INSERT INTO nyf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kwa vizho ninwi nanwi mukiona maut'u gaga gosi, manyani kukala wakathi wa kudza Mwana wa Mudamu udzafika hehi. ");
INSERT INTO nyf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nami namwambira kamare, kizhazi kiki k'akindakira kabila maut'u gaga gosi kuthimira. ");
INSERT INTO nyf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mulunguni na ts'i, zhosi vindahenda mwisho, ela maneno gangu k'agana mwisho bule.” ");
INSERT INTO nyf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jesu akienderera kunena akiamba, “Ela k'ahana mut'u amanyaye ni siku yani na saa yani gandihokalira maut'u gaga, hatha o malaika na ye Mwana wa Mudamu k'amaimanya bule, Baba h'akeye nde aimanyaye.” ");
INSERT INTO nyf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Kudza kwa Mwana wa Mudamu kundakala dza zho virizhokala wakathi wa Nuhu. ");
INSERT INTO nyf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwani siku zizo za Nuhu kabila v̱ula ya muretho k'aidzanya, at'u mathuwa kuishi here kawaida thu. Makala makirya na kunwa, na kuhala na kuhalwa hatha Nuhu achangira safinani. ");
INSERT INTO nyf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","At'u ao mathuwa kuishi bila kumanya kundakudzani, hatha muretho ukidzaahala vizho. Na vizho ndo vindizhokala hatha yo siku andihokudza Mwana wa Mudamu. ");
INSERT INTO nyf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Siku iyo alume airi mandakala ma mundani, mumwenga andahalwa na ye mungine arichwe. ");
INSERT INTO nyf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Anaache airi mandakala manasaga, mumwenga andahalwa na ye mungine arichwe. ");
INSERT INTO nyf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kwa vizho, kalani matso, mana k'amumanya Bwana wenu andakudza siku yani. ");
INSERT INTO nyf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sirikizani bai, kala mwenye nyumba ni kumanya mwivi andakudza usiku wa saa nyingahi, k'angakubalire nyumbaye ibandwe bule, angachesa matso kuirinda. ");
INSERT INTO nyf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kwa vizho ninwi nanwi dziikeni thayari wakathi wosi, kwani Mwana wa Mudamu andakudza wakathi musiwoudhania.” ");
INSERT INTO nyf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesu akienderera kunena akiamba, “Muhumiki mwaminifu na mulachu ni yuyahu ariye akirichirwa ahumiki andziye ni bwanawe aatsundze na kuap'a chakurya here vimalikanazho, andahenda vizho. ");
INSERT INTO nyf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Baha iye muhumiki iye ariye bwanawe andakudzamuthekeza anahenda vizho. ");
INSERT INTO nyf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kwani namwambira jeri wenye kukala, andamuhala na amuhendye akale muimirizi wa zho vit'u zhosi arizho nazho. ");
INSERT INTO nyf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ela ye muhumiki mui akiamba kimoyo-moyo, ‘Naona ye bwana wangu k'andauya vikara,’ ");
INSERT INTO nyf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","akwache kuapiga o ahumiki andziye, na kurya na kunwa hamwenga na arevi. ");
INSERT INTO nyf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bai ye bwana wa muhumiki yuyu andauya siku asiyodhania na saa asiyoimanya. ");
INSERT INTO nyf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Naye afikaho andakudzamuhala na amutose visiku-visiku, gonya amutsanganye na at'u a kudzihendya. Na kuko at'u mandarira na kwafuna meno kwa utsungu.” ");
INSERT INTO nyf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Haho siku andihokudzirira Mwana wa Mudamu, uthawali wa mulunguni undahalana na asichana kumi marioasha mataa gao mende makamutsangire bwana harusi. ");
INSERT INTO nyf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kahi za o asichana kumi, asichana atsano were ni azuzu, na atsano were ni alachu. ");
INSERT INTO nyf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Vikara aryahu asichana azuzu, mamanya ko kutsukula go mataa kare ela k'amatsukulire akiba yoyosi ya mafuha. ");
INSERT INTO nyf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ela arya alachu o makitsukula mataa hamwenga na mafuha ga akiba. ");
INSERT INTO nyf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bai kwa kukala ye bwana harusi k'adzire haraka, o asichana osi makunukira na makilala. ");
INSERT INTO nyf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ela usiku wa manane, makihenda kusikira, ‘Thiye bwana harusi ukani mwende mukamutsangire.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aryahu asichana osi makivumbuluka kare makikwacha kuthayarisha mataa gao. ");
INSERT INTO nyf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Vikara aryahu asichana azuzu marihoona kukala mataa gao k'agana mafuha, makiavoya o alachu makiamba, ‘Huthanyizeni naswi go mafuha, mana mataa gehu ganazima.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ela o asichana alachu makidzigidzya makiamba, ‘Go mafuha hurigo nago be k'agadima kuhuthosha hosi bule, kwa vizho kot'ani malo madhukani mukagule genu.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","K'uzhona o asichana azuzu marihokala makwendani ko madhukani, kuno ye bwana harusi akidza. Aryahu asichana atsano mariokala ma thayari, machangira hamwenga naye kahi za yo nyumba ya harusi na muryango ukifungwa.” ");
INSERT INTO nyf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Bada ya muda, o asichana angine makidza kula ko mafuhani. Makidzabisha zhomu zhenye makiamba, ‘Bwana, bwana, huvugulire!’ ");
INSERT INTO nyf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ela ye bwana harusi akiadzigidzya akiamba, ‘Kunena wo ujeri, simumanya bule ninwi.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesu arihomarigiza ro fumbo riro akiamba, “Kwa vizho, kalani thayari wakathi wosi, mana k'amumanya maut'u gaga gandakala siku yani na saa yani.” ");
INSERT INTO nyf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesu akienderera kunena akiamba, “Wakathi uwo be udzahalana na mut'u mumwenga ariyekala anamala kufunga charo cha kwenda ts'i za kure. Bai kabila k'adzauka, waaiha ahumikie akiap'a malize mamutsundzire. ");
INSERT INTO nyf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Waaiha hamwenga, na kila mut'u akimup'a t'alant'a kulengana na wadimiwe. Wa kwandza wamup'a t'alant'a ts'ano. Wa hiri akimup'a mbiri, na wa hahu akimup'a mwenga. Arihogonya vizho akiuka achenda. ");
INSERT INTO nyf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Vikara arihokala adzakwenda, ye muhumiki ariyegerwa t'alant'a ts'ano, akizihendera kazi na zikizhala ts'ano nyingine. ");
INSERT INTO nyf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yuya ariyegerwa mbiri naye, akizihendera kazi hatha zikizhala mbiri nyingine. ");
INSERT INTO nyf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ela ye muhumiki ariyegerwa t'alant'a mwenga, akiihala yo p'esa ya bwanawe achendaitsimbira wina akiizika.” ");
INSERT INTO nyf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Vikara bada ya muda mure, ye bwana wa aryahu ahumiki akiuya na akidzapiga hesabu na o ahumikie. ");
INSERT INTO nyf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bai yuyahu muhumiki ariyegerwa t'alant'a ts'ano, akimboza zo ts'ano nyingine akiamba, ‘Bwana, mut'u uwe wanirichira t'alant'a ts'ano, nami nikizihendera kazi hatha zikizhala zizi ts'ano nyingine, thizi.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ye bwanawe akimwamba, ‘U muhumiki mudzo na mwaminifu, uriyehenda kazi ya kunifwaha moyo wangu. Wakala mwaminifu dzulu za maut'u mathithe, na vivi ndakuhendya uimirire maut'u mabomu zaidhi. H'aya ndzo kuno wangire kahi za raha ya bwanao.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Kula iye, akithuwirizwa ni yuyahu wa t'alant'a mbiri. Iye naye akiamba, ‘Bwana, uwe wanip'a t'alant'a mbiri, nami nikizihendera kazi hatha zikizhala zizi t'alant'a mbiri nyingine, thizi.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ye bwanawe akiamba, ‘U muhumiki mudzo na mwaminifu, uriyehenda kazi ya kunifwaha moyo wangu. Wakala mwaminifu kwa maut'u mathithe nami nindakuhendya uimirire maut'u mabomu. H'aya ndzo kuno wangire kahi raha ya bwanao.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kula iye, akidza ye wa t'alant'a mwenga. Akiamba, ‘Bwana, uwe be ninakumanyat'o sana mino. U mut'u mwomu. Unahendza kuvuna hat'u uriho k'uhalayire, na kuzola mutsere uriwo k'uuhululire. ");
INSERT INTO nyf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kwa ut'u uwo wenye bai, yo t'alant'ayo nikigoha kuihendera kazi. Nikiihala nikiitsimbira wina nikiizika. Kwa vizho yo t'alant'ayo thii hala mwenye.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","K'ona ye bwanawe anambola kunena akiamba, ‘Muhumiki muthiriri na mukaha we. Be hatha navikale unanimanyat'o sana kukala nivuna hat'u niriho silayire, na kuzola mutsere hat'u niriho sihululire. ");
INSERT INTO nyf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Were k'udima kwendazika bengi zo p'esa zangu changari zikanizhalira faidha? ");
INSERT INTO nyf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","H'aya muhokeni kare yo t'alant'a mumup'e ye ariye na kumi. ");
INSERT INTO nyf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwani kila ariye na kit'u andagerwa akale na vinji. Ela ariye k'ana kit'u, andahokwa hatha cho aricho nacho. ");
INSERT INTO nyf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","H'aya muhaleni yuyu muhumiki asiye mana mumutsuhe ko ndze kizani. Na kuko kundakala na kurira na kwafuna meno.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesu akienderera kunena akiamba, “Haho Mwana wa Mudamu andihokudza na malaika osi kahi za nguma ya kwakwe, andakelesi dzulu za kihi cha kwakwe cha kithawali, kihi chenye nguma. ");
INSERT INTO nyf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bai andihokala yukelesi, at'u a makabila gosi mandakudzaima mbereze, naye andaathanya k'ana mbiri dza viryahu murisa athanyazho mbuzi na ng'ondzi. ");
INSERT INTO nyf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","At'u enye hachi andaaika mukono wa kurya. At'u athiriri o andaaika mukono wa kumots'o. ");
INSERT INTO nyf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Gonya ye Muthawali andaambira aryahu mandiokala mukono wa kurya, ‘Ndzoni kuno nwi at'u muriohaswa ni Baba. Ndzoni muhale uthawali muriwothayarishirwa ni Baba hangu urumwengu k'audzaumbwa. ");
INSERT INTO nyf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwani nirihokala nina ndzala, ninwi mwanip'a chakurya nikirya. Nirihokala nina k'ihu, mukinip'a madzi nikinwa. Na nirihokala ni mujeni mukinikaribishat'o. ");
INSERT INTO nyf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nirihokala nina wira mwanip'a nguwo nikivala. Nirihokala ni mukongo mukidzanilola, na nirihokala ni jela nazho dzazho.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","O ahachi mandauza maambe, ‘Bwana, unaamba kukala urihokala una ndzala fwakup'a chakurya ukirya. Urihokala una k'ihu fukikup'a madzi ukinwa. ");
INSERT INTO nyf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Urihokala u mujeni fukikukaribishat'o. Urihokala una wira fukikup'a nguwo ukivala. ");
INSERT INTO nyf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Urihokala u mukongo fukidzakulola, na urihokala u jela nazho dzazho. Be hatha fwakona rini sino hatha fukikuhendera maut'u gano gosi?’ ");
INSERT INTO nyf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ye Muthawali andaadzigidzya aambe, ‘Namwambira kamare kukala, zho murizhoahendera aa ndugu zangu athithe be mwanihendera mimi.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Gonya andaambira o at'u mandiokala mukono wa kumots'o, ‘Nihaukirani nwi at'u muriolaniwa. Endani kahi za moho wa kare na kare, kut'u kurikotengezerwa Shethani na malaikae! ");
INSERT INTO nyf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwani nirihokala nina ndzala, k'amunip'ere chakurya nikarya. Nirihokala nina k'ihu k'amunip'ere madzi nikanwa. ");
INSERT INTO nyf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nirihokala ni mujeni k'amunikaribishire. Nirihokala nina wira k'amunip'ere nguwo nikavala. Nirihokala ni mukongo k'amudzire nilola, na nirihokala jela nazho dzazho.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nao mandamuza mamwambe, ‘Bwana, ni rini ho furihokona una ndzala, hedu una k'ihu, hedu u mujeni, hedu u mukongo, hedu u jela gonya sino k'afukwavizire fukikuricha vizho?’ ");
INSERT INTO nyf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ye andaadzigidzya aambe, ‘Ninamwambira kamare kukala, zho murizho k'amuahenderere aa ndugu zangu athithe, be hatha mimi nami k'amunihenderere.’ ");
INSERT INTO nyf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nao mandihoambwa vizho, mandakwendangira kahi za hukumu ya kare na kare, ela ahachi o, mandangira kahi za uzima wa kare na kare.” ");
INSERT INTO nyf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Vikara Jesu arihokala adzagonya kunena maneno gaga gosi, waambira anafundzie, ");
INSERT INTO nyf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Here mumanyazho, muhondo ni sikuk'uu ya P'asaka. Na Mwana wa Mudamu andalazhwa ili asulubiwe.” ");
INSERT INTO nyf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wakathi uwo, alombi abomu na athumia a Kiyahudi mathunganana nyumbani kwa Kayafa. Mut'u yuyu Kayafa were nde Mulombi mubomu mwenye wakathi uwo. ");
INSERT INTO nyf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bai at'u ao mathunganana kuko ili mamale ngira ya kilachu ya kumugwirira Jesu na mamwalage. ");
INSERT INTO nyf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ela marihothunganana, mapatana kukala masimugwire Jesu wakathi wa P'asaka bule, p'ore at'u makathinya bugwa. ");
INSERT INTO nyf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Bai siku mwenga, Jesu wakwenda nyumbani kwa mwanamulume mumwenga ariyekala akiifwa Simoni Mahana. Mwanamulume yuyu were anatoa kahi za kadzidzi ka Beth'ania. ");
INSERT INTO nyf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Bai arihokala haho, mwanamuche mumwenga akidza na th'up'a iriyokala i thele mafuha ga marashi kidza ga gali sana. Th'up'a ii yere yatengezwa na iwe ra alabasita. Bai arihofika haho, akimumwagira Jesu go mafuha mo kitswani kuno Jesu mwenye anahumira chakurya. ");
INSERT INTO nyf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bai o anafundzi marihoona viryahu, k'aviafwahire bule, maamba, “Kuno be tha si kwanonga kuno? ");
INSERT INTO nyf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mafuha gaga kala gadzaguzwa gakambola p'esa nyinji zenye na makagerwa masikini?” ");
INSERT INTO nyf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesu arihovimanya akiamba, “Mbona munamubudzya ye mwanamuchengwa? Iye adzanihendera kit'u kidzo. ");
INSERT INTO nyf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Masikini munao siku zosini, ela mimi k'amundakala nami siku zosini bule. ");
INSERT INTO nyf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ut'u uu wa kunimwagira mafuha, yuyu mwanamuche adzauhenda ili anithayarishe kwa kuzikwa kwangu. ");
INSERT INTO nyf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nami namwambira ujeri, zho adzizhohenda mwanamuche yuyu vivi rero, nazho vindathalwa na kukumbukirwa kila undihohubiriwa wo Uv̱oro Udzo kahi za urumwengu muzima.” ");
INSERT INTO nyf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Bai wakathi uwo, mumwenga wa aryahu anafundzi kumi na airi a Jesu aifwaye Juda Isikariote, wauka achenda kwa alombi abomu. ");
INSERT INTO nyf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Anafika kuko akiamba, “Vidze mut'u yuno nikimulazha kwenu, mundanip'ani?” K'ona arihonena vizho, aryahu alombi abomu makimuthalira visiku mirongo mihahu zha fedha makimup'a. ");
INSERT INTO nyf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na kulaizira haho, Juda akikala anamala nafasi mbidzo ya kumusalitira Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Vikara siku ya kwandza ya sikuk'uu ya Mikahe Iso Ts'ats'u, anafundzi makwendamuza Jesu makiamba, “P'asaka ino undairyahi, fukakuthayarishire?” ");
INSERT INTO nyf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesu akidzigidzya akiamba, “Ngirani wo mudzi wa Jerusalemu mwende hatha kwa yuyu mut'u yuyu. Mukifika kuko mwambeni kukala, ‘Mwalimu anaamba wakathi wangu u hehi, kwa vizho nindarya P'asaka na anafundzi angu kwako nyumbani.’ ” ");
INSERT INTO nyf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bai o anafundzi makihenda here marizhokala madzalagizwa ni Jesu. Manafika kuko makithayarisha yo P'asaka. ");
INSERT INTO nyf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kurihofika dziloni, Jesu na anafundzie kumi na airi makelesi marye chakurya. ");
INSERT INTO nyf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Marihokala makuryani Jesu akinena akiamba, “Ninamwambira ujeri wenye kukala mumwenga wenu haha andanisaliti.” ");
INSERT INTO nyf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","O anafundzi marihosikira vizho makishikithika sana na makikwacha kumuza Jesu mumwenga-mumwenga makiamba, “Vidze ni mimi, Bwana?” ");
INSERT INTO nyf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ela Jesu akidzigidzya akiamba, “Iye atsotsaye nami kahi za muvure mumwenga nde andiyenisaliti. ");
INSERT INTO nyf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wa Mudamu anenda kare kamwe here Maoro gaambazho, ela shauriye iye mut'u amusalitiye! Vingakala baha kala k'azhalirwe.” ");
INSERT INTO nyf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Vikara Jesu arihonena viryahu, ye musaliti wa kwakwe naye akiuza akiamba, “Vidze ni mimi Mwalimu?” Jesu akimudzigidzya akiamba, “Udzanena.” ");
INSERT INTO nyf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bai marihokala makuryani, Jesu wahala mukahe, akimboza muv̱era kwa Mulungu, gonya akiumogola-mogola akiap'a o anafundzie akiamba, “Halani murye, uu ndo mwiri wangu.” ");
INSERT INTO nyf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na arihogonya kuap'a wo mukahe, akihala cho kikombe cha divai, akimboza muv̱era kwa Mulungu, gonya akiap'a o anafundzie akiamba, “Halani kikombe kiki mutsumbulirane, ");
INSERT INTO nyf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kwani ii ndo milatso yangu ya cho kilagane, imwagwayo ili at'u anji madime kusamehewa dambi zao. ");
INSERT INTO nyf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nami namwambira ujeri, sindanwa divai ii kaheri muhaka siku iyo nindihonwa divai mbisha hamwenga nanwi kahi za uthawali wa Baba.” ");
INSERT INTO nyf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Gonya makiimba wira na makiuka kwenda Murima wa Mizeituni. ");
INSERT INTO nyf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesu akiambira kukala, “Usiku wa rero, ninwi nyosi mundaniricha h'akiyangu. Kwani Maoro ganaamba, ‘Nindamupiga ye murisa na zo ng'ondzi zosi zindatsamukana.’ ");
INSERT INTO nyf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ela haho nikikala nidzafufulwa, nindamuthangulia kwenda Galilaya.” ");
INSERT INTO nyf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","P'et'ero akimudzigidzya akiamba, “Hatha kala osi mandakuricha, mimi sindakuricha ng'o.” ");
INSERT INTO nyf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu akimudzigidzya akiamba, “Nakwambira ujeri, usiku wa rero kabila jogolo k'aridzaika, undanikana k'ana t'ahu.” ");
INSERT INTO nyf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","P'et'ero akimwamba Jesu, “Hatha kala ni kufwa nanifwe, ela sindakukana ng'o!” Na o anafundzi angine nao makinena dza vizho. ");
INSERT INTO nyf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Gonya Jesu na anafundzie makwenda hat'u haifwaho Geth'isemane. Marihofika kuko, akiambira o anafundzie akiamba, “Kelesini haha munitharize nami nasongera mbere vichache nikavoye.” ");
INSERT INTO nyf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Arihokala akwendani akimuhala P'et'ero na o ana airi a Zebedayo, Jakobu na Johana achenda nao. Naye wakathi uwo washononeka zhomu na kubudzyika moyo. ");
INSERT INTO nyf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Bai makwenda hatha manafika ko mbere, akiambira kukala, “Ninashononeka zhomu moyoni mwangu hatha ni here nindiyefwa. Bai kalani haha muchese nami.” ");
INSERT INTO nyf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Gonya Jesu akiaricha ano P'et'ero haho na akisongera mbere vichache. Achendagwa na moyo akivoya akiamba, “Baba, chamba vinadimikika mateso gaga naganiukire, gasinipate bule. Ela navikale here uhendzazho uwe, visikale here nihendzazho mimi bule.” ");
INSERT INTO nyf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kula haho akiauyira o anafundzie, naye akidzaaona marere. Akimwamba P'et'ero, “Yani k'amudimire kuchesa nami hatha ngaa saa mwenga? ");
INSERT INTO nyf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chesani na muvoye sidze mukangira majezoni, kwani roho inahendza kamare, ela mwiri ni munyonge.” ");
INSERT INTO nyf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Naye arihogonya kunena, akiaricha haho kaheri na achendavoya dza vizho zha kwandza akiamba, “Baba, chamba vinadimikika, mateso gaga gasinipate bule. Ela visikale here nihendzazho mimi, navikale here uhendzazho uwe.” ");
INSERT INTO nyf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Arihogonya kuvoya vizho, akiauyira o ano P'et'ero. Anafika kuko, achendaathekeza marere kaheri. K'amadimire kukala matso kwa wo uts'indzizi mariwokala nawo. ");
INSERT INTO nyf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bai Jesu akiaricha kaheri, na achendavoya mara ya hahu, dza vizho zha mara ya kwandza. ");
INSERT INTO nyf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Arihogonya kuvoya, akiauyira o anafundzie akiambira, “Muchere kulala na kudzioyeza? Lolani wakathi wa Mwana wa Mudamu kusalitiwa kwa enye dambi udzafika. ");
INSERT INTO nyf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lamukani fwende, kwani ye andiyenisaliti akudzani.” ");
INSERT INTO nyf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bai arihokala achere kunena, lola Juda mumwenga wa o anafundzie kumi na airi akidza na kundi bomu ra at'u mariokala madzatsukula mishu na njogoma. At'u aa were mala kwa alombi abomu na athumia a Kiyahudi. ");
INSERT INTO nyf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Iye musaliti were waap'a muv̱ano kukala, “Ye nindiyemudonera nde mumumalaye, mugwireni.” ");
INSERT INTO nyf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Juda achenda mara mwenga na akiamba, “Dheri narikale kwako Mwalimu,” gonya akimudonera. ");
INSERT INTO nyf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesu arihoona viryahu, akimwamba Juda, “Henda zho vidzizhokufisha musenangu.” Bai o at'u makimwangiza magandzani Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Lola mumwenga kahi za o at'u mariokala na Jesu, akitsolola mushuwe na akimuthema muhumiki wa ye Mulombi mubomu mwenye akimutosa sikiro. ");
INSERT INTO nyf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesu arihoona viryahu, akimwamba ye mwenye mushu, “Wudzye chowani mwakwe wo mushuwo. Kwani kila ahumiraye mushu, andalagwa kwa mushu. ");
INSERT INTO nyf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","K'umanya kukala nikamwambira Baba anirehere maalifu ga malaika madze mafuhehere, ananirehera mara mwenga? ");
INSERT INTO nyf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ela nikihendazho, go Maoro gaambago kukala ni hatha vivi vikale gandathimiradze?” ");
INSERT INTO nyf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Bai Jesu arihogonya kunena vizho, akiagalukira o at'u akiamba, “Mbona mudzambola na mishu na njogoma kudzanigwira dza here mudzaogwira jambazi? Kila siku nidzakala nikikelesi kahi za ro Hekalu kufundisha na k'amunigwirire? ");
INSERT INTO nyf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ela gaga gosi ganakala kwamba garyahu garigoorwa ni manabii gathimire.” Bai o anafundzie osi makimuricha makichimbira. ");
INSERT INTO nyf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bai aryahu at'u mariomugwira Jesu, mamuhala vivii hatha nyumbani kwa Kayafa, ye Mulombi mubomu mwenye, mana kuko ndo o alimu a Sheria, na athumia marikokala madzathunganana kumuthariza. ");
INSERT INTO nyf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Marihokala makwendani, P'et'ero wamuthuwa Jesu kwa kure. Wakwenda hatha achendangira muhalani ha ye Mulombi mubomu mwenye, akikelesi na o arindzi ili alolere chamba vindakaladze. ");
INSERT INTO nyf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bai aryahu alombi abomu na ro Baraza ra athumia, majeza zhomu kumala ushahidhi wowosi wa ulongo wa kuthosha kumwalagira Jesu, ");
INSERT INTO nyf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ela k'amaupatire. At'u anji majeza kumboza ushahidhi wao wa ulongo, ela k'aufwahire kit'u. Mwisho kamare, kuchambola anaalume airi ");
INSERT INTO nyf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","makiamba, “Mwanamulume yuyu waamba kukala ro Hekalu ra Mulungu anadima kuribanda-banda na akariaka kwa siku t'ahu.” ");
INSERT INTO nyf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Bai ye Mulombi mubomu mwenye akirungarara, na akimuza Jesu akiamba, “Mbona k'udzigidzya kit'u. Zho manenazho ano at'u ni jeri?” ");
INSERT INTO nyf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ela Jesu akinyamala zii. Ye Mulombi mubomu mwenye akinena kaheri akiamba, “Ninakulahiza kahi za dzina ra Mulungu ariye moyo, ufwambire chamba uwe ndiwe Masihi Mwana wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesu akimwamba, “Udzanena. Nami namwambira ujeri, kula vivi mundamona Mwana wa Mudamu akelesi mukono wa kurya wa Mulungu mwenye nguvu, na anadza kuno a dzulu za maingu.” ");
INSERT INTO nyf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kusikira vizho thu, ye Mulombi mubomu mwenye akigwira nguwo za kwakwe akizitharura kwa kutsukirwa, kuno ananena na kuamba, “Iyo ni kufuru kamare iyo. K'amudzamusikira zho? Vino funa haja ya mashahidhi angine? ");
INSERT INTO nyf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hedu munaambadze nwi?” Na osini makiamba, “Anav̱irya kwalagwa.” ");
INSERT INTO nyf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ndo makimutsuhira mahe ga uso na kumupiga makonde. Angine makimupiga makofi, ");
INSERT INTO nyf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kuno manamwamba, “We Masihi, fwambire adzekupiga ni h'ani kala u nabii jeri!” ");
INSERT INTO nyf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Wakathi uu wosi P'et'ero were akelesi ko muhalani. Bai arihokala kuko muhendzi wa kazi wa kiche wa ye Mulombi mubomu mwenye wakudzamwamba P'et'ero, “We nawe samba were u hamwenga na yuyu Jesu wa Galilaya?” ");
INSERT INTO nyf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","P'et'ero akikana mbere zao akiamba, “Maneno gago mino sigamanya.” ");
INSERT INTO nyf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kula haho, P'et'ero akimbola achenda ko muv̱iryani. Anafika kuko, musichana mumwenga akimona na akiambira o at'u mariokala haho kukala, “Yuyu naye were a hamwenga na Jesu wa Nazareth'i benwi.” ");
INSERT INTO nyf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","P'et'ero akikanaiza kaheri kwa kuapa akiamba, “Mwanamulume iye simumanya kamare.” ");
INSERT INTO nyf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ela k'avitoere, o at'u mariokala maimire haho makimwamba P'et'ero, “Uwe be unakana ulongo, ela u mumwenga waho. Hatha yo minenereyo inanyesa t'i.” ");
INSERT INTO nyf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","P'et'ero akikwatya kulani na kulaha, akiamba, “Mwanamulume iye be simumanya.” Na haho henye jogolo rikiika. ");
INSERT INTO nyf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","P'et'ero akikumbukira viryahu arizhoambwa ni Jesu kukala, “Kabila jogolo k'aridzaika undanikana k'ana t'ahu.” Bai achambola ko ndze achendarira na utsungu munji. ");
INSERT INTO nyf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kurihocha, o alombi abomu na athumia a Kiyahudi mathunganana kaheri makipanga viryahu mandizhohenda hatha mamwalage Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bai mamuhala makimufunga, na makimuhirika kwa luwali P'ilato. ");
INSERT INTO nyf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Juda arihoona kukala ro Baraza ratosa kukala mamwalage Jesu, wadziutha sana, hatha akihala zho visiku mirongo mihahu zha fedha achenda nazho kuko kwa alombi abomu na athumia a Kiyahudi ili akaaujire. ");
INSERT INTO nyf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Arihofika kuko waagololeza akiamba, “Nahenda dambi bomu kumusaliti mut'u asiye dambi na mut'u.” O makimwamba, “Gago be ni gako gago, sino k'ahugamanya.” ");
INSERT INTO nyf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Naye kusikira vizho, akihala zho visiku zha fedha akivitsuha mo Hekaluni, achambola achendadzifunga lugwe. ");
INSERT INTO nyf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Vikara o alombi abomu makivitsola-tsola viryahu visiku zha fedha gonya makiamba, “P'esa zizi be zina kilatso, na Sheria yehu k'aihuruhusu kuika p'esa dza zizi kahi za akiba ya mumu Hekaluni.” ");
INSERT INTO nyf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kwa vizho bada ya kuojana-ojana makivihala machendagula hat'u harihokala hakiifwa Munda wa Muumbi wa Nyungu, hakale hat'u ha kuzikwa ajeni. ");
INSERT INTO nyf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Na kulaiza siku iyo hatha rero munda uwo unaifwa Munda wa Milatso. ");
INSERT INTO nyf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kwa ut'u uwo wenye bai, garyahu maneno garigonenwa ni nabii Jeremia gakithimira. Kwani Jeremia wanena akiamba, “Mahala vizho visiku mirongo mihahu zha fedha, iriyo were ndo bei ya kugulira mut'u iriyoikwa ni o ana a Iziraeli, ");
INSERT INTO nyf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","makivigula wo Munda wa Muumbi wa Nyungu here Bwana arizhonilagiza.” ");
INSERT INTO nyf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Vikara Jesu arihohirikwa kwa P'ilato, waimishwa haho mbereze na P'ilato akimuza akiamba, “Vidze we ndiwe muthawali wa Ayahudi?” Jesu akimudzigidzya akimwamba, “Uwe udzanena.” ");
INSERT INTO nyf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ela o alombi abomu na athumia a Kiyahudi marihomushithaki, Jesu wanyamala zii kamare. ");
INSERT INTO nyf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","P'ilato arihoona viryahu, akimuza Jesu akiamba, “Go maut'u manji genye madzigoamba wagahenda unagasikira?” ");
INSERT INTO nyf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ela Jesu ye akithuwa kunyamala vizho bila kudzigidzya hatha ango mwenga, hatha ye P'ilato vikimwangalaza zhomu zhenye. ");
INSERT INTO nyf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kila sikuk'uu ya P'asaka, P'ilato were ana mazowera ga kuambozera Ayahudi mufungwa mumwenga mandiyemutsagula enye. ");
INSERT INTO nyf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bai kahi za wakathi uwo, kwere kuna mufungwa ariyekala adzaluta nguma, dzinare ni Baraba. ");
INSERT INTO nyf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kwa vizho o Ayahudi marihokundzumanyikana hamwenga, P'ilato akiauza akiamba, “Nimwambozere Baraba hedu nimwambozere Jesu aifwaye Masihi?” ");
INSERT INTO nyf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kwani P'ilato wamanya kukala o athumia a Kiyahudi madzamushithaki Jesu kwa sababu ya wivu thu. ");
INSERT INTO nyf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bai P'ilato arihokala anakeresi kahi za kihiche cha hukumu alamule, muchewe akilagiza uv̱oro akiamba, “Maut'u gago be usigangirire kamare, kwani mut'u yuyu be ni muhachi. Mana usiku nidzaloha ndoso mbii-mbii sana dzulu za kwakwe. Nayo ndoso iyo idzanisirinya.” ");
INSERT INTO nyf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ela o alombi abomu na o athumia a Kiyahudi makiangola-ngola o at'u kukala maambe mambozerwe Baraba, ela Jesu ye alagwe. ");
INSERT INTO nyf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kwa vizho P'ilato arihouza kaheri na kuamba, “Kahi za ano at'u airi munahendza nimwambozere h'ani?” O at'u makiamba, “Baraba.” ");
INSERT INTO nyf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","P'ilato akiauza akiamba, “Na yuno Jesu aifwaye Masihi ye nimuhendedze?” Nao makinena kwa umwenga makiamba, “Naasulubiwe!” ");
INSERT INTO nyf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","P'ilato akiauza kaheri akiamba, “Kwani adzakosani kibomu?” Ela o hatha makikaza kupiga k'ululu makiamba, “Naasulubiwe!” ");
INSERT INTO nyf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bai P'ilato arihoona kukala hatha akaenderera kunena nao kidza k'avindafwaha kit'u na kidza o at'u were madzakwacha kuhenda fujo, akihala madzi akioga mikono mbere za ro kundi ra at'u, akiamba, “Milatso ya mut'u yuyu k'aidzulu yangu bule, i dzulu zenu.” ");
INSERT INTO nyf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na lola o at'u makidzigidzya kwa umwenga makiamba, “Milatsoye naikale dzulu zehu siswi na dzulu za ana ehu.” ");
INSERT INTO nyf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kwa vizho P'ilato akiambozera Baraba, gonya akiamuru Jesu apigwe vikotho, ndo alazhwe akasulubiwe. ");
INSERT INTO nyf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jesu arihokala adzalazhwa akasulubiwe, o shikari a luwali P'ilato mamuhala machangira naye mumo nyumbani mwa luwali, na cho kikosi chosi cha shikari kikimudengereka. ");
INSERT INTO nyf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bai mamuhala makimuvula nguwo, gonya makimuvika k'andzu th'une. ");
INSERT INTO nyf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Manambola haho makitengeza kiremba cha miya makimuvika. Gonya makihala kidhath'a cha mwandzi makimugwiza kahi za wo mukonowe wa kurya. Bai marihogonya vizho makikwacha kupiga mavindi na kumuv̱udhya Jesu na kumwamba, “K'una ut'u muheshimiwa muthawali wa Ayahudi?” ");
INSERT INTO nyf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bai mamutsuhira mahe, gonya makimunyagula cho kidhath'a makimupiga nacho mo kitswani. ");
INSERT INTO nyf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Marihokala madzamuv̱udhya zha kuthosha, mamuvula yo k'andzu th'une, makimuvika zo nguwoze kaheri, makimuthongozha kwendamusulubisha. ");
INSERT INTO nyf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Vikara marihokala madzambola kwa P'ilato makwendani, mumo ngirani mathungana mwanamulume mumwenga Muk'irene aifwaye Simoni. Bai o shikari makimulazimisha autsukule wo musalaba wa Jesu. ");
INSERT INTO nyf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bai makwenda vivii hatha hat'u haifwaho Gologoth'a, yani Ribeshe ra Kitswa. ");
INSERT INTO nyf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Makimup'a Jesu divai ya kutsanganywa na ut'u wa utsungu sana, ela arihoithatha akikahala kuinwa. ");
INSERT INTO nyf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Marihokala madzagonya kumusulubisha, mahala zo nguwoze makizigazha kwa kuhenda kuzipigira k'ura. ");
INSERT INTO nyf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Gonya makikelesi haho kumurinda. ");
INSERT INTO nyf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dzulu za cho kitswa cha Jesu haikwa kibao kirichoorwa kosa mariromushithakira. Nacho chere kinaamba vivi: Yuyu Ni Jesu, Muthawali Wa Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesu wasulubiwa hamwenga na aivi airi. Mumwenga mukono wa kurya, na mungine mukono wa kumots'o. ");
INSERT INTO nyf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","At'u mariokira na haho arihosulubiwa Jesu, mamusholera, makithukusa vitswa zhao kikav̱udhye, ");
INSERT INTO nyf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","makiamba, “Kw'aamba undaribanda ro Hekalu na uriake kwa siku t'ahu vino? H'aya dziokole mwenye be vivi. Chamba u Mwana wa Mulungu jeri, thima kula ho musalabani.” ");
INSERT INTO nyf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na lola o alombi abomu, na alimu a Sheria, na athumia a Kiyahudi nao makimusholera dza vizho zha akizi a ngira. Makiamba, “Waokola at'u angine, ela vino k'adima kudzakola mwenye. ");
INSERT INTO nyf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Samba ni muthawali wa Iziraeli ye, naathime kula ho musalabani, naswi fundamuamini. ");
INSERT INTO nyf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Amba ye were anamukuluhira Mulungu sana; hatha anaamba kukala ni Mwana wa Mulungu. H'aya kala ye Mulungu anamuhendza jeri, be vivi naamwakole.” ");
INSERT INTO nyf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hatha aryahu aivi airi mariosulubiwa hamwenga naye kidza nao mamusholera dza vizho zha o angine. ");
INSERT INTO nyf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Bada ya Jesu kusulubiwa, ts'i yosi yagit'ana kiza kuandzira saa sitha muhadhi saa chenda. ");
INSERT INTO nyf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Inafika mwendo wa saa chenda Jesu akirira kwa sauthi bomu akiamba, “Eloi Eloi, lama sabakithani?” Yani, “Mulungu wangu, Mulungu wangu, mbona udzaniricha?” ");
INSERT INTO nyf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kusikira vizho, angine kahi za ao at'u mariokala maimire haho makiamba, “Sirikizani, anamwiha Elija benwi!” ");
INSERT INTO nyf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Na haho na haho, mumwenga wao akikot'a malo achendavwika buwa kahi za siki, akiridunga mudhath'ani akimup'a Jesu anyunye. ");
INSERT INTO nyf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ela andziye makimwamba, “Richa hulole chamba Elija andakudzamuthizha.” Na mumwenga wao akihala fumo akimudunga lubavuni, akimbola milatso na madzi. ");
INSERT INTO nyf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bai Jesu akipiga k'ululu kaheri na akitoka roho. ");
INSERT INTO nyf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na lola yo p'azia kahi za ro Hekalu yapashuka ikigazhika p'ande mbiri, kula dzulu hatha ts'ini. Ts'i ikithethema na mawe gakibandika-bandika. ");
INSERT INTO nyf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mbira nyinji za at'u a Mulungu zikigunuka na o at'u enye makifufuka, ");
INSERT INTO nyf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","na machambola mo mbirani. Na lola Jesu arihofufuka, at'u aa mangira kahi za mudzi mueri wa Jerusalemu na makionewa ni at'u anji enye. ");
INSERT INTO nyf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bai o shikari mariokala manamurinda Jesu, hamwenga na ye mubomu wao marihoona zho ts'i irizhokala inathethema, hamwenga na go maut'u mangine gosi, mangirwa ni woga sana hatha makiamba, “Yuyu were ni Mwana wa Mulungu jeri.” ");
INSERT INTO nyf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kwere kuna anaache mariomuthuwa Jesu hangu Galilaya. Anaache aa ndo mariokala makimwaviza Jesu na mahitaji ga kwakwe. Bai makala maimire kure vichache kulolera kila kirichokala. ");
INSERT INTO nyf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kahi zao were hana Maryamu Magidalena, Maryamu mameye Jakobu na Josefu, na mameye Jakobu na Johana, ana a Zebedayo. ");
INSERT INTO nyf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kurihokala kunakala kidziloni, kukidza mwanamulume mumwenga wa kula Arimath'ea ariyeifwa Josefu. Mwanamulume yuyu were naye ni mwanafundzi wa Jesu na were ni thajiri. ");
INSERT INTO nyf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Bai wakwenda hatha kwa P'ilato achendamuvoya P'ilato amup'e mwiri wa Jesu akauzike. Naye P'ilato akilagiza agerwe. ");
INSERT INTO nyf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kwa vizho Josefu akiuhala akiulinga-linga ts'andza ya kitani safi, ");
INSERT INTO nyf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na achendauzika kahi za mbiraye mwenye, ariyokala waitsonga iweni. Mbira ii were ni mbisha yenye hatha were k'aidzazikwa mut'u. Bai wamwangiza mumo na akisukuma ro iwe akifunga, gonya akihauka. ");
INSERT INTO nyf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Wakathi uwo Josefu arihokala anamuzika Jesu, Maryamu Magidalena na ye Maryamu mungine were makelesi kulolana na iyo mbira manalolera. ");
INSERT INTO nyf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Siku ya hiriye, yani yo siku iriyothuwana na yo Siku ya Mathayarisho, o alombi abomu na Mafarisayo makwendathunganana na P'ilato. ");
INSERT INTO nyf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Makimwamba, “Muheshimiwa, at'u siswi be fudzakumbukira ut'u umwenga siswi. Yuyahu mulongo arihokala achere moyo, waamba kukala, bada ya siku t'ahu andafufuka. ");
INSERT INTO nyf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kwa vizho bai, lagiza shikari makarinde yo mbira muhaka yo siku ya hahu. Kwani kala k'ahundahenda vizho, o anafundzi a kwakwe manadima kudzamwiya gonya makaambira at'u kukala adzafufuka. Na ulongo uwo undakala mui zhomu hatha uwo wa kwandza mbai.” ");
INSERT INTO nyf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","P'ilato akiamba, “Shikari munao, kwa vizho hakikishani kukala inarindwa zha kuthosha.” ");
INSERT INTO nyf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kwa vizho machendahala ro iwe ra ho muryangoni makiripiga muhuri. Gonya makiika shikari marinde. ");
INSERT INTO nyf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabato irihokala idzakira, siku ya kwandza ya wiki na madzach'a maitsi genye, Maryamu Magidalena, na ye Maryamu mungine, marauka kwenda ko mbirani makailole. ");
INSERT INTO nyf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na lola haho henye ts'i ikithethema zhomu zhenye kwa kukala malaika wa Bwana watharamuka kula dzulu akidzaripingilisa ro iwe ra kusindikira yo mbira, akirikelesira. ");
INSERT INTO nyf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Uso wa malaika iye were unang'ala here lumethe, na nguwo za kwakwe were ni nyaruhe tse-tse-tse. ");
INSERT INTO nyf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aryahu shikari mariokala manarinda yo mbira makivinwa ni miri kwa woga hatha makikala here at'u madziofwa. ");
INSERT INTO nyf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ela ye malaika akinena na o anaache akiamba, “Musigohe bule. Ninamanya kukala munamumala ye Jesu ariyesulubiwa, ");
INSERT INTO nyf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","bai k'aho bule haha. Adzafufuka here arizhonena. Hatha ndzoni muhalole ho ariholazwa. ");
INSERT INTO nyf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na mukila haha, yerani malo mukaambire anafundzie kukala, ‘Adzafufuka kula kifwani na lola anamuthangulia kwenda Galilaya nanwi mundakwenda mukamone kuko.’ H'aya nidzamwambira mino.” ");
INSERT INTO nyf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bai o anaache mahauka haraka haryahu mbirani, kuno mana raha jeri-jeri, idzaho wo woga were k'audzaambola. Mauka malo mende makaambire o anafundzi dzulu za maut'u gago. ");
INSERT INTO nyf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Marihokala makwendani, lola Jesu akiambolera gafula mbere zao, akialamusa akiamba, “Voro.” Na lola o anaache makimusongerera makimugwira go magulu makimuvoya. ");
INSERT INTO nyf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesu akinena akiamba, “Musigohe bule. Endani mukaambire o ndugu zangu mende Galilaya, nao mandanona kuko.” ");
INSERT INTO nyf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Vikara marihokala o anaache makwendani, lola shikari angine kahi za aryahu mariokala manarinda yo mbira, mangira mumo Jerusalemu machendaambira o alombi abomu kila kit'u kirichokala kidzahendeka. ");
INSERT INTO nyf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bai aryahu alombi makithunganana na o athumia a Kiyahudi na makipanga kukala maahonge o shikari. Kwa vizho makiap'a p'esa nyinji zenye, ");
INSERT INTO nyf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","gonya makiambira kukala, “Ambani kukala usiku hudzihokala hurere, anafundzie madziremuiya makenda naye. ");
INSERT INTO nyf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na luwali akivisikira hundanena naye siswi hatha athosheke p'ore mukangira matatani.” ");
INSERT INTO nyf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bai o shikari makizihala zo p'esa na makihenda here marizholagizwa. Na lola ulongo uu watsamuka kahi za Ayahudi hatha vivi. ");
INSERT INTO nyf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Badaye aryahu anafundzi kumi na mumwenga a Jesu mauka kwenda Galilaya. Makwenda vivii hatha makifika wo murima ariolagiza Jesu kukala mathunganane. ");
INSERT INTO nyf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bai marihomona, madzigwaga mbereze makimuvoya, idzaho angine were machere mana mioyo miri-miri. ");
INSERT INTO nyf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesu akiasongerera hehi na akinena nao akiamba, “Mimi nagerwa wadimi wosi dzulu mulunguni na ts'i. ");
INSERT INTO nyf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kwa vizho endani mukaahendye at'u a makabila gosi makale anafundzi angu. Muabat'ize kahi za dzina ra Baba, na ra Mwana, na ra Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na muafundishe magagwire maut'u gosi nirigomulagiza. Na lola mimi nindakala hamwenga nanwi siku zosini muhaka mwisho wa dhunia.”");
INSERT INTO nyf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Uu ndo Uv̱oro Udzo wa Jesu Masihi Mwana wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Uv̱oro uu Udzo waandza here arizhokala nabii Isaya waora kukala Mulungu waamba, “Lola ninahuma mujumbe wangu mberezo, andiyekutengezera ngirayo. ");
INSERT INTO nyf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mut'u iye analuta mumirowe ko nyika na kuamba, ‘Mutengezereni ngira Bwana, Mutengezereni ngira ya kugoloka.’ ” ");
INSERT INTO nyf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bai muhumwa yuyu were ni mut'u mumwenga aifwaye Johana Mubat'izaji naye waonewa ko nyika akikala anahubiri na kuamba, “Thubuni mubat'izwe, na Mulungu andamusamehe dambi zenu.” ");
INSERT INTO nyf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na at'u anji makwendamusirikiza Johana. At'u aa mambola jimbo ra Judea na wo mudziwe mubomu uifwao Jerusalemu. Nao maziungama dambi zao, na Johana akiabat'iza kahi za wo muho wa Jorodani. ");
INSERT INTO nyf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johana were valore ni ra nyoga za ngamira naye wadzifunga mukanda wa k'ingo mo chununi. Naye wakala akirya kw'eth'eth'e na uchi wa nyuchi. ");
INSERT INTO nyf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Naye kahi za kuhubirikwe waamba, “Kunadza mut'u mwenye cheo kuriko mimi nyuma zangu. Mimi sifika hatha mut'u wa kumuvula virahuzhe. ");
INSERT INTO nyf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mimi ninamubat'iza na madzi, ela iye andamubat'iza na Roho Mweri.” ");
INSERT INTO nyf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na kahi za siku zizo Jesu wakudza kula Nazareth'i kahi za jimbo ra Galilaya na Johana akimubat'iza kahi za wo muho wa Jorodani. ");
INSERT INTO nyf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na Jesu arihokala akumbolani mo madzini, akiona ko mulunguni kudzagunuka na Roho anatserera dzuluze here giya. ");
INSERT INTO nyf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na kukimbola sauthi kula ko mulunguni ikiamba, “Uwe u Mwanangu muhendzwi, unifwahizaye.” ");
INSERT INTO nyf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na mara mwenga ye Roho Mweri akimuhendya ende nyika. ");
INSERT INTO nyf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Akikala ko nyika siku mirongo mine, na Shethani wakala akimujeza. Nao malaika makikala manamuhumikira. Jesu were a hamwenga na nyama a tsakani ko nyika. ");
INSERT INTO nyf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bada ya Johana Mubat'izaji kugwirwa na kwangizwa jela, Jesu wakwenda ko jimbo ra Galilaya na achendahubiri Uv̱oro Udzo wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Na Jesu waambira at'u vivi, “Wakathi uriwoambwa udzathimira na uthawali wa Mulungu udzafika hehi. Kwa vizho thubuni dambi zenu na muukuluhire wo Uv̱oro Udzo wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Siku mwenga Jesu arihokala ananenda mo k'anda-k'anda ya ziya ra Galilaya, waona avuhi airi, ambao were ni Simoni na nduguye ariyeifwa Anderea. Nao were manatsuha vimia zhao mo ziyani mavuhe makumba. ");
INSERT INTO nyf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu akiambira, “Nithuwani, nami nindamuhendya mukale avuhi a at'u.” ");
INSERT INTO nyf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nao haho kwa haho, makiviricha zho vimia zhao na makimuthuwa. ");
INSERT INTO nyf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Gonya Jesu akisongera ho mbere vichache na akiaona Jakobu na Johana, ana a Zebedayo ma dauni mwao manafuma vimia zhao. ");
INSERT INTO nyf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Naye ko kuaona thu, akiaiha. Bai ye mut'u na nduguye makimuricha babiyao Zebedayo na o at'u a kuhenda kukodisha mo dauni na makimuthuwa Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bai Jesu na o anafundzie machenda kahi za mudzi wa Kaperinaumu, na irihofika siku ya Sabato, Jesu achangira kahi za sinagogi na akiandza kufundisha. ");
INSERT INTO nyf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Na lola o at'u mariomusikira mangalazwa zhomu ni go mafundishoge, kwani were k'afundisha dza here alimu a Sheria mafundishazho, ela were anafundisha here mut'u mwenye wadimi. ");
INSERT INTO nyf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Saa iyo-iyo mumo sinagogini mukidza mut'u mwenye p'ep'o. Akipiga k'ululu, ");
INSERT INTO nyf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","akiamba, “Unani naswi we Jesu wa Nazareth'i? Vidze udzire uhunonge-nonge? Ninamanya uwe u h'ani. Uwe u Mweringwa wa Mulungu!” ");
INSERT INTO nyf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kusikira vizho, Jesu akimuchemera ye p'ep'o, akimwamba, “Hedu nyamala kare na umwambole.” ");
INSERT INTO nyf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ye p'ep'o akimuthukusa ye mut'u zhomu zhenye, kuno anapiga k'ululu na kumwambola ye mut'u. ");
INSERT INTO nyf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na o at'u osini mo sinagogini makingalala na makiuzana-uzana makiamba, “Ut'u uno ni ut'u wani? Mut'u yuyu ana wadimi wa kualagiza p'ep'o mambole, na o p'ep'o manahenda vizho zhenye! Ni mafundisho masha gano hedu dze!” ");
INSERT INTO nyf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kwa vizho uv̱oro wa Jesu ukitsamuka haraka kila hat'u kahi za jimbo ra Galilaya. ");
INSERT INTO nyf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bai Jesu, na Jakobu, na Johana na anafundzie angine marihombola kahi za ro sinagogi thu, makwenda kare hatha nyumbani kwa Simoni na Anderea. ");
INSERT INTO nyf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Vikara kuko, mutsedza wa Simoni wa kiche were a kitandani ana homa. Bai marihofika thu, Jesu achambirwa kare dzuluze. ");
INSERT INTO nyf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesu achenda hehi achendamugwira mukono, akimwaviza kurungarara. Na ro homa rikimuricha hatha akiandza kuahikirahikira. ");
INSERT INTO nyf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dzulo riro bada ya dzuwa kupothoka, akongo osi na o mariokala mapagawa ni p'ep'o marefwa kwa Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na o at'u osi a wo mudzi wa Kaperinaumu makundzumanyika ho mulomoni ha yo nyumba. ");
INSERT INTO nyf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Bai Jesu akiahoza anji mariokala na makongo ga kila namuna, na achamboza at'u p'ep'o anji. Kidza o p'ep'o k'aap'ere kadzanya ka kunena, kwa kukala mere manamanya iye ni h'ani. ");
INSERT INTO nyf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Madzach'a maitsi siku ya hiriye, Jesu wambola, akiuka achenda hat'u nyika hariho k'ahana mut'u na achendavoya. ");
INSERT INTO nyf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ndo Simoni na andziye makikwatya kumudengereka. ");
INSERT INTO nyf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Marihomona makimwamba, “At'u osi manakumala kuryahu” ");
INSERT INTO nyf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ela Jesu akiadzigidzya akiamba, “Hindeni kahi za vidzidzi vingine virizho hehi na haha. Vinav̱irya nikahubiri mo vidzidzini namo, kwa kukala vizho ndo virizhonireha.” ");
INSERT INTO nyf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kwa vizho achenda kahi za Galilaya yosi, kuhubiri kahi za masinagogi na kumboza at'u p'ep'o. ");
INSERT INTO nyf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Siku mwenga, hakidza mut'u wa mahana kwa Jesu, akipiga mavindi na akimuvoya akiamba, “Ukihendza unadima ukanihoza!” ");
INSERT INTO nyf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesu akidzalwa ni mbazi na akigoloza mukono akimugut'a na akiamba, “Ninahendza, hola!” ");
INSERT INTO nyf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na go mahana gachangamika mara mwenga na akihola kamare. ");
INSERT INTO nyf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesu akimwamba ye mut'u kukala ahauke kare na kidza akimukokot'era zhomu zhenye akimwamba, ");
INSERT INTO nyf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Vivi be usizhambire mut'u bule, ela enda ukamwanyese mulombi, gonya umboze sadaka ya ko kuholako, yo ariyolagiza Musa, ili kila mut'u amanye kukala udzahola jeri.” ");
INSERT INTO nyf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ela ye mut'u achenda, na achendakwacha kuuvumisha wo uv̱oro kila hat'u. Lola, wanena zhomu hatha Jesu akikala k'adima kwenda kahi za mudzi vivi-vivi, hat'u ha vizho akikala kut'u kungine-kungine kuriko k'akuna at'u, ela hamwenga na vizho at'u makimudzirira kula kila hat'u. ");
INSERT INTO nyf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Siku ch'ach'e zirihokira, Jesu wauya Kaperinaumu kaheri, na uv̱oro ukivuma kare kukala adzire. ");
INSERT INTO nyf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Makundi na makundi ga at'u, makiidzaza yo nyumba ariyokala Jesu. K'ahakalire na kadzanya hatha ko muryangoni mwa nyumba; naye Jesu were anaafundisha neno ra Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ana alume ane makidza kuno madzamutsukula mut'u wa kuholoza manamureha kwa Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwa wo unji wa at'u k'amadimire kwangira naye. Ndo makivomola ko dzulu ya yo nyumba, dzulu za ho arihokala Jesu, makimutharamusha na godhoro ye mut'u muhaka mbere za Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesu arihoona ro kuluhiro rao, akimwamba ye ariyeholoza, “Mwanangu, udzasamehewa dambizo!” ");
INSERT INTO nyf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bai alimu a Sheria mariokala were makelesi haho marihosikira vizho madziuza kimoyo-moyo makiamba, ");
INSERT INTO nyf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Anadimadze kunena vino yuno? Ni kufuru ii, Mulungu h'akeye nde adimaye kusamehe dambi!” ");
INSERT INTO nyf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Haho henye Jesu kahi za rohoye, akigamanya go maswali gao, akiauza, “Mbona munadziuza maswali dza go? ");
INSERT INTO nyf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Vidze virizho rahisi kumwamba yuno mut'u wa kuholoza ni hizho? Ni kumwamba, ‘Udzasamehewa dambizo,’ hedu ‘Uka, uhale godhororo wanende?’ ");
INSERT INTO nyf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ela manyani bai, kukala Mwana wa Mudamu ana wadimi wa kusamehe dambi haha dhuniani.” Kugonya kunena vizho Jesu akimwamba ye mut'u wa kuholoza, ");
INSERT INTO nyf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ninakwamba uka uhale godhororo wende mudzini.” ");
INSERT INTO nyf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ye mut'u akiuka kare, akihala godhorore kuno at'u osi manamulola, na achombola kwenda kwao. Na osi machangalala na makimulika Mulungu na kuamba, “K'ahudzangwe kuona ut'u dza uu kamare.” ");
INSERT INTO nyf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na siku mwenga Jesu akiuka kaheri achenda k'anda-k'anda ya ziya ra Galilaya na kundi ra at'u rikimudzirira kuko naye akikwatya kuafundisha neno ra Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Badaye Jesu arihokala anatsembera-tsembera mo k'anda-k'anda za ro ziya, wamona mut'u mumwenga aifwaye Lawi wa Alifayo akelesi ndani za ofisi ya kodi. Akimwamba, “Nithuwa.” Lawi akirungarara akimuthuwa. ");
INSERT INTO nyf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Badaye Jesu na anafundzie, makwendarya chakurya nyumbani kwa Lawi. Na athozi a kodi anji na at'u angine mariokala manaonewa kukala ni enye dambi, makudzarya hamwenga nao. ");
INSERT INTO nyf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ela alimu a Sheria mario were ni Mafarisayo marihomona Jesu anarya hamwenga na at'u aa, maauza o anafundzie makiamba, “Mbona yuno anarya na athozi a kodi hamwenga na enye dambi?” ");
INSERT INTO nyf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bai Jesu arihogasikira gago akiambira, “Mukongo nde mwenye haja ya muganga, ela muzima k'ana haja ya muganga bule. Mimi nakudzaaiha enye dambi, sidzireaiha enye hachi!” ");
INSERT INTO nyf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Anafundzi a Johana na Mafarisayo were makafunga, bai kukidza at'u kwa Jesu na makidzamuza makiamba, “Anafundzi a Johana na anafundzi a Mafarisayo ni kufunga, mbona o a kwako we k'amafunga?” ");
INSERT INTO nyf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu akiamba, “Vidze ajeni a harusini ni kufunga na hatha ye bwana harusi manaye haho? Hatha! Makalaho na iye bwana harusi k'amadima kufunga bule. ");
INSERT INTO nyf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ela siku zinadza, ambazo ye bwana harusi andauswa kahikahi zao, na wakathi uwo ukifika mandafunga. ");
INSERT INTO nyf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","K'ahana mut'u adimaye kuhala nguwo ya kapindi akayangiza kiraka kisha. Mana mut'u akihenda vizho, kiryahu kiraka kisha kindayamola yo nguwo ya kapindi chambole, na kindaihendya ikale na t'undu bomu kukira iyo ya chaho. ");
INSERT INTO nyf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na k'ahana mut'u adimaye kwangiza divai mbisha kahi za viriba zha kapindi. Kwani mut'u akihenda vizho, iryahu divai indavipashula zho viriba na yo divai hamwenga na zho viriba zhosi andavikosa. Ela divai mbisha zhakwe ni viriba visha.” ");
INSERT INTO nyf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Siku mwenga iriyokala ni Sabato, Jesu were anakira kahi za minda ya ngano, na o anafundzi mario were ma hamwenga naye makikwatya kuhuta masuche ga yo ngano. ");
INSERT INTO nyf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bai o Mafarisayo mario were ma ho hehi-hehi marihoona vizho makimwamba Jesu, “Kwanoni ano manahenda ut'u uriwo k'auhendwa siku ya Sabato?” ");
INSERT INTO nyf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesu akiadzigidzya akiamba, “Muthawali Daudi wahendadze harya arihokala iye na o at'u ariokala nao mana ndzala na manahitaji chakurya? Hedu k'amudzavishoma? ");
INSERT INTO nyf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Daudi wakwenda kahi za nyumba ya Mulungu wakathi Abiathari arihokala nde mulombi mubomu mwenye, akiirya yo mikahe ya sadaka, gonya akiap'a aryahu andziye nao, makirya, vingahokala kulingana na sheria, were ni alombi h'akiyao ndo madimao kuirya.” ");
INSERT INTO nyf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesu akisindikiza na kuamba, “Yo siku ya Sabato yaikirwa mudamu, ela mudamu k'aumbirwe kwa ut'u wa Sabato bule. ");
INSERT INTO nyf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bai Mwana wa Mudamu ni Bwana, hatha wa yo siku ya Sabato.” ");
INSERT INTO nyf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gonya kaheri siku mwenga iriyokala ni siku ya Sabato, Jesu achangira kahi za sinagogi na mumo mukikala muna mut'u mwenye mukono wa kuholoza. ");
INSERT INTO nyf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bai hakikala hana Mafarisayo mario were manamala chausa cha kumushithakira Jesu, kwa vizho makilolera maone chamba andamuhoza yo siku ya Sabato, makamushithaki. ");
INSERT INTO nyf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu akimwambira ye mut'u ariyeholoza mukono, “Ungarara ho kahikahi hedu.” ");
INSERT INTO nyf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Gonya Jesu akiauza o Mafarisayo akiamba, “Vidze kisheria ni hiro ririro ni karakara kuhendwa siku ya Sabato? Vidze ni kuhenda madzo hedu mai? Ni kuthizha hedu ni kwalaga?” Ela makinyamala zii! ");
INSERT INTO nyf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesu akialola o Mafarisayo kuno atsukirwe, akidzalwa ni kigondzi kwa ut'u wa kukosa mbazi kwao. Gonya akimwamba ye mut'u, “Goloza wo mukonowo hedu.” Akiugoloza nawo ukiuyat'o kare. ");
INSERT INTO nyf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ndo ao Mafarisayo machambola na machendathunganana na at'u a Herode kupanga mandizhomwalaga Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Bai Jesu hamwenga na anafundzie makiahaukira na machenda ko ziya ra Galilaya. Vikara arihokala anenda, ngororoki bomu ya at'u ikimuthuwa. At'u aa, angine mambola Galilaya, jimbo ra Judea, ");
INSERT INTO nyf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","na mudzi wa Jerusalemu, na jimbo ra Idumea, na kuvuka muho wa Jorodani. Angine mambola viv̱alo zha Tiro na Sidoni. Ao osi mamudzirira kwa kukala masikira go arigokala akigahenda Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kwa ut'u wa wo muminyano wa o at'u anji, Jesu walagiza o anafundzie mamuikire dau thithe ili asihoshwe ni at'u. ");
INSERT INTO nyf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Were adzahoza akongo anji, ndo anji angine mariokala k'amadima, makihendza makukume hatha mamugut'e kwamba mahole nao. ");
INSERT INTO nyf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na yoyosi ariyepagawa ni p'ep'o arihomona Jesu, wagolomokwa na akigwa mbereze akipiga k'ululu na kuamba, “Uwe ndiwe Mwana wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ela Jesu akiakokot'era sana masihende akamanywa iye ni h'ani. ");
INSERT INTO nyf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bada ya gago Jesu akikwera dzulu murimani, na akiaiha aryahu arioahendza nao machenda ho arihokala. ");
INSERT INTO nyf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na gonya akitsagula kumi na airi na akiahendya makale ahumwie na makale hamwenga naye. Kidza aahume kwendahubiri, ");
INSERT INTO nyf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na makale na wadimi wa kumboza at'u p'ep'o. ");
INSERT INTO nyf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Gaga ndo madzina ga o kumi na airi mariotsagulwa ni Jesu: Simoni ambaye Jesu wamup'a dzina ra P'et'ero, ");
INSERT INTO nyf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakobu na Johana, ana a Zebedayo ambao Jesu waaiha Boanerige, ambaro manaye ni “Ana a kigwaragwara,” ");
INSERT INTO nyf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anderea, Filipu, Bath'olomayo, Math'ayo, T'omasi, Jakobu mwana wa Alifayo, Th'adayo, Simoni Muhehezi, ");
INSERT INTO nyf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Juda Isikariote ariye nde ariyekudzamusaliti Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Arihogonya kuatsagula o ahumwie, achangira nyumbani. Bai ngororoki bomu ya at'u ikimwenderera kaheri, hatha Jesu na anafundzie k'amapatire mwanya wa kurya chakurya. ");
INSERT INTO nyf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ndo at'u a kwao marihosikira makiuka kwendamugwira, makiamba, “Ana vilalu.” ");
INSERT INTO nyf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nao alimu a Sheria mariombola Jerusalemu maamba, “Ana Belizebuli na anamboza p'ep'o kwa zo nguvu za iye mubomu wa p'ep'o.” ");
INSERT INTO nyf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bai Jesu akiambira o at'u makundzumanyike, gonya akiambira kwa mafumbo akiamba, “Vidze Shethani anadima kumwamboza Shethani mwandziwe? ");
INSERT INTO nyf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ts'i at'ue makidzigazha makundi-makundi gahehago, ts'i iyo k'aindatoa. ");
INSERT INTO nyf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na mudzi ukigazhika na at'ue makikala k'amagwirana milomo, be mudzi uwo k'aundatoa. ");
INSERT INTO nyf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na Shethani akidzipinga na kudzigazha mwenye, k'andatoa, uwo ndo undokala mwishowe. ");
INSERT INTO nyf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","K'akuna mut'u adimaye kungira kahi za nyumba ya mut'u mwenye nguvu na kumuhoka vit'uzhe hasiho kumufunga ye mwenye kwandza. Niamufunge kwandza ndo adime kumuhoka zho vit'uzhe. ");
INSERT INTO nyf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Namwambira ujeri wenye, anadamu mandasamehewa dambi zosi na kila kufuru mandiyonena. ");
INSERT INTO nyf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ela mut'u andiyemukufuru Roho Mweri, k'ana musamaha bule, andakala adzahenda dambi ya kare na kare.” ");
INSERT INTO nyf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu wanena vivi kwa kukala angine were madzamwamba ana p'ep'o. ");
INSERT INTO nyf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Gonya mameye na nduguze Jesu a kilume makidza. Makiima ko ndze ya yo nyumba, makihuma mut'u akamwihe Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wo muthunganano wa at'u mariokala makeresi, na madzamudengereka makimwamba Jesu, “Lola mameyo na nduguzo manakumala ko ndze.” ");
INSERT INTO nyf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesu akiadzigidzya akiamba, “M'ama na ndugu zangu ni hio?” ");
INSERT INTO nyf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Gonya akialolat'o o mariokala makeresi, kumudengereka, akiamba, “Aa be ndo m'ama na ndo ndugu zangu! ");
INSERT INTO nyf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kwani ahendaye mahendzo ga Mulungu, nde m'ama na nde ndugu yangu.” ");
INSERT INTO nyf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Siku nyingine Jesu wakwenda kaheri k'anda-k'anda ya ro ziya akikwatya kufundisha. Bai rikundi ribomu ra at'u rikimudzalira hatha akiona ni baha angire dauni akelesi mumo. Naye wakelesi mo dauni kuno o at'u osi makikala ma ko ts'i furufu. ");
INSERT INTO nyf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na Jesu waafundisha maut'u manji kwa kuhumira mafumbo. Kahi za mafundishoge akiambira, ");
INSERT INTO nyf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Sirikizani! Mut'u mumwenga wauka kwendamwaga-mwaga mbeyu mundani kwakwe. ");
INSERT INTO nyf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bai arihokala akuzimwagani-mwagani, mbeyu nyingine ikigwa k'anda-k'anda ya ngira na unyama ukidzait'ot'a. ");
INSERT INTO nyf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mbeyu nyingine ikigwa kahi za mutsanga wa mawe-mawe, harihokala hana mutsanga muchache. Bai ikimera malo-malo kwa kukala were hana mutsanga muchache. ");
INSERT INTO nyf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dzuwa ririhokola zhomu yo mitse ikinyala na ikifwa kwa kukala were k'aina miziji mire. ");
INSERT INTO nyf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeyu nyingine ikigwa miyani. Irihomera, miya iryahu ikikula na ikiizia-zia hatha k'aipatire nafasi ya kumbola ndze bule, bai kwa ut'u uwo k'aizhalire kit'u. ");
INSERT INTO nyf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ela nyingine zikigwa kahi za mutsanga mudzo nazo zikimerat'o, zikikula na zikizhala. Nyingine zazhala mirongo mihahu-mihahu, nyingine zikizhala mirongo mihandahu-mihandahu, na nyingine zikizhala gana-gana.” ");
INSERT INTO nyf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesu akimarigiza na kuamba, “Mwenye masikiro ga kusikirira, naasikire.” ");
INSERT INTO nyf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Badaye Jesu arihokala adzarichana na yo ngororoki ya at'u, aryahu anafundzie kumi na airi na angine kahi za ao mariokala madzagasikira go mafundishoge, mamuza Jesu kwamba mambirwe mana ya go mafumbo. ");
INSERT INTO nyf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesu akiambira, “Ninwi mwajaliwa kuimanya yo siri ya uthawali wa Mulungu. Ela o mario ndze ya wo uthawali, manasikira kwa ngira ya mafumbo, ");
INSERT INTO nyf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kwamba malole na kulola, ela masione, masirikize na kusirikiza, ela masing'alirwe. Kwani kala makaona na kung'alirwa makamuuyira Mulungu, naye akaausiza dambi zao.” ");
INSERT INTO nyf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Gonya Jesu akiauza akiamba, “Fuambe k'amung'alirwa ni fumbo riri? Bai mundang'alirwadze ni mafumbo mangine? ");
INSERT INTO nyf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ye mulayi, analaya neno ra Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","At'u angine ma here ziryahu mbeyu zirizogwa k'anda-k'anda ya ngira. At'u aa makigonya kusikira neno ra Mulungu, Shethani nikudza mara mwenga na kurusa riro neno ririrolaywa mo mioyoni mwao. ");
INSERT INTO nyf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ziryahu zirizogwa kahi za mutsanga wa mawe-mawe, ni at'u mario makisikira neno thu, manarihokera kare mara mwenga, kidza manarihokera na raha. ");
INSERT INTO nyf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ela kwa kukala k'arina miziji ndani mwao k'amatoa naro bule. Thabu hedu mateso gaadziriraho kwa ut'u wa ro neno manaviricha kare. ");
INSERT INTO nyf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na at'u angine ma here yo mbeyu iriyogwa miyani. Aa ni kusikira ro neno ra Mulungu, ");
INSERT INTO nyf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ela v̱ata za urumwengu, na ukengi wa mali, na th'amaa za maut'u mangine zikiangira, nikurikonya-konya ro neno hatha rikakala k'arindazhala kit'u. ");
INSERT INTO nyf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ela at'u angine ma dza here iryahu mbeyu iriyogwa kahi za mutsanga mudzo. At'u aa nikurisikira ro neno na kurikubali na kuzhala matunda. Yuno mirongo mihahu, yuya mirongo mihandahu na mungine gana zima.” ");
INSERT INTO nyf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu akienderera kufundisha akiamba, “K'akuna mut'u adimaye kugwiza taa gonya akaribiningiza na muvure hedu hatha kurika muvunguni! Nikurika dzulu ya nyambaro. ");
INSERT INTO nyf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mana kila kiricho hafufu kindambozwa halamu, na kila siri indamanywa. ");
INSERT INTO nyf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mut'u mwenye masikiro ga kusikirira, naasikire.” ");
INSERT INTO nyf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kidza akiambira, “Sirikizani zhomu na mugagwire gaga nimwambirago. Cho kipimo mupimiracho andziyenu ndicho mundichopimirwa ninwi, kidza hatha mwangezezwe. ");
INSERT INTO nyf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kwani kila ariye nacho andangezwa, na ariye k'ana kit'u, andahokwa hatha cho aricho nacho.” ");
INSERT INTO nyf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Gonya Jesu akiamba, “Uthawali wa Mulungu u dza here viryahu mut'u amwagazho-mwagazho mbeyu mundani. ");
INSERT INTO nyf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Usiku ukifika analala, mutsana anahenda makazige. Muda uu wosi t'embe zinamera na kukula, kuno ye k'amanya vinakuladze. ");
INSERT INTO nyf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Wo mutsanga h'akeye unaihenda yo mimera ikule na kuzhala mazhalo, unambola wo mutse chaho, gonya ro suche, na kusindikiza na zo t'embe. ");
INSERT INTO nyf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Suche rindihouma, mwenye munda ni kudzavuna kwa kukala wakathi wa kwakwe udzafika.” ");
INSERT INTO nyf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kidza Jesu akiamba, “Huambedze kaheri dzulu za kuhalanisha uthawali wa Mulungu? Fuhumire fumbo rani? ");
INSERT INTO nyf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tha ni here katembe ka haradali kariko nikulaywa. Katembe kaka ni kathithe kukira t'embe zosi haha urumwenguni. ");
INSERT INTO nyf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bada ya makathi fulani ni kumera na ukakala mumera mubomu kukira mimera yosi ya mundani, kwani ni kwamboza vitai ambazho unyama nikudza na kuaka vitsunji mumo.” ");
INSERT INTO nyf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Bai Jesu waafundisha at'u kuhumira mafumbo mangine manji here gaga. Naye waafundisha here wadimi wao wa kung'alirwa urizhokala. ");
INSERT INTO nyf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jesu k'afundishire at'u bila kuhumira mafumbo, ela wakathi arihokala ana anafundzie were anaang'azira kila kit'u. ");
INSERT INTO nyf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Bai dzulo ra yo siku iyo vizho Jesu akiambira anafundzie, “Nahuvuke ng'ambo.” ");
INSERT INTO nyf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kwa vizho o anafundzi makiaricha o at'u, na makipanda ro dau arirokala Jesu adzapanda na machenda naye. Kidza were kuna madau mangine ga nyuma-nyuma. ");
INSERT INTO nyf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ela k'avitoere kukidza luv̱utho lwa kitai na maimbi gakipiga ro dau hatha rikikwatya kudzala madzi. ");
INSERT INTO nyf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Wakathi uu Jesu were hatha a ko mwisho wa ro dau, adzaika kitswache muthoni na arere. Bai o anafundzie makimuthukusa makiamba, “Mwalimu, hunahoha, k'ujali we?” ");
INSERT INTO nyf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bai Jesu akilamuka, akiluchemera lo luv̱utho na akirambira ro ziya, “H'aya hurira!” Na lo luv̱utho lukiricha na go madzi gakihurira hu. ");
INSERT INTO nyf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Gonya Jesu akiauza anafundzie akiamba, “Mbona mu aoga? Hedu k'amuna kuluhiro?” ");
INSERT INTO nyf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nao makikala manavinwa ni miri k'azhadimikika. Makikwatya kuuzana-uzana na kuamba, “Ni h'ani yuno ariye hatha luv̱utho na maimbi vinamusikira?” ");
INSERT INTO nyf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesu na anafundzie makivuka ziya ra Galilaya makifika ts'i ya Agerasi. ");
INSERT INTO nyf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na arihothima mo dauni thu akithunganana na mut'u ariyekala adzalaa makaburini, naye were ana p'ep'o. ");
INSERT INTO nyf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mut'u yuyu were siku zosi akala ko makaburini, kidza k'ahana mut'u ariyedima kumufunga hatha kwa minyororo. ");
INSERT INTO nyf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Akwao mere majeza zhomu kumufunga magulu na mikono, ela kila marihomufunga waitosa yo minyororo na zho zhuma marizhomufunga maguluni. Mut'u yuyu were yuna nguvu zhomu hatha were k'ahana amwadimaye. ");
INSERT INTO nyf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Usiku na mutsana wakala akidengereka ko makaburini na ko virimani kuno anapiga londzo na kudzikop'ola vii-vii na mawe ga maso. ");
INSERT INTO nyf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bai arihomona Jesu kwa kure, achenda malo na akigwa mbereze, ");
INSERT INTO nyf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","na akipiga k'ululu akiamba, “Unani nami we Jesu Mwana wa Mulungu ariye dzulu ya zhosi? Bai ninakuvoya kwa dzina ra Mulungu usinitese!” ");
INSERT INTO nyf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ye p'ep'o wanena vivi kwa kukala Jesu were anaamba, “P'ep'o mukolo mwambole mut'u yuyu!” ");
INSERT INTO nyf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesu akimuza akiamba, “Dzinaro ndiwe h'ani?” Ye p'ep'o akiamba, “Dzina rangu ndimi majeshi kwa kukala hu anji mumu!” ");
INSERT INTO nyf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Akimudhedheja zhomu ye Jesu kwamba asiainge kwenda ndze ya yo ts'i ya Agerasi. ");
INSERT INTO nyf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Vikara haho were hana badhi bomu ra nguluwe rinarisa k'anda-k'anda ya karima. ");
INSERT INTO nyf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","O p'ep'o makimuvoya Jesu makiamba, “Fwambe fwende hukaangire aryahu nguluwe.” ");
INSERT INTO nyf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesu akiaruhusu na o p'ep'o akolo makimwambola ye mwanamulume na machendaangira o nguluwe. Ro badhi ra nguluwe here alifu mbiri rikitharamuka malo kula ko ngokani rikivoromoka mo ziyani rikihoha. ");
INSERT INTO nyf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kuona vizho, o arisa makichimbira na machenda ko midzini na mindani machendasema go garigokala gadzahendeka. Na at'u duu makidzalola. ");
INSERT INTO nyf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Makidza ho arihokala Jesu, na makimona ye ariyekala ana p'ep'o anji akilize ni ndzima na were adzavala nguwo na akelesi haho, na makingirwa ni woga. ");
INSERT INTO nyf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aryahu mariokala madzazhona zho virizhokala vidzahendeka, makiambira o at'u zho virizhokala vidzakala kwa ye mut'u na kwa o nguluwe. ");
INSERT INTO nyf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Na o at'u marihosikira vizho makimuvoya Jesu akulae kuko kwao. ");
INSERT INTO nyf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Vikara Jesu arihokala anangira mo dauni, ye mut'u ariyembozwa p'ep'o wavoya ende na Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ela Jesu akimukahaza, akimwamba, “Enda kwenu ukaambirize asenao go adzigokuhendera Bwana, na viryahu adzizhokuonera mbazi.” ");
INSERT INTO nyf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kwa vizho ye mwanamulume akiuka, achangira kahi za ro jimbo ra Midzi Kumi, na akiambira at'u garyahu arigokala adzahenderwa ni Jesu. Osi mariosikira uv̱oro uu machangalala. ");
INSERT INTO nyf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu akivuka kaheri ro ziya muhaka ko nyangamoni. Na ngororoki bomu ya at'u ikidza ho k'anda-k'anda ya ro ziya na makikala madzamuzunguluka. ");
INSERT INTO nyf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mut'u mumwenga aifwaye Jairo ariyekala ni mumwenga kahi za abomu a masinagogi akidza haho. Arihomona Jesu wagwa mbereze, ");
INSERT INTO nyf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na akimuvoya akiamba, “Musichana wangu akufwani. Bai vichadimikika nafwende ukamwikire mikono apate kuthia.” ");
INSERT INTO nyf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesu akiuka kumuthuwa ye Jairo, na at'u anji makimuthuwa ko arikokala anenda. At'u aa were ni anji hatha angine were manamukwala-kwala kamare. ");
INSERT INTO nyf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bai mo kahi ya yo ngororoki ya o at'u mwere muna mwanamuche mumwenga ariyekala adzakala mukongo wa kumbola milatso, kwa miaka kumi na miri. ");
INSERT INTO nyf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wathapathapa kwa aganga kuzikifwa vivii hatha vikishinda. Hatha were malize zosi wazigonya kwa kuzikifwa, ela hat'u ha ahende kabaha, ye akikala tha anakazizwa. ");
INSERT INTO nyf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Vikara mwanamuche yuyu were wasikira nguma ya Jesu, bai wamuthuwa Jesu ko nyuma, kuno ananena kimoyo-moyo na kuamba, “Nikigut'a ngaa ro valore thu, nindahola.” Kwa vizho akirigut'a ro valo ra Jesu na yo milatso ikithuma kare saa iyo na akidzisikira adzahola. ");
INSERT INTO nyf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Haho henye Jesu akisikira nguvuze zidzamuhungukira. Akiahundukira o at'u na akiauza akiamba, “Ni h'ani adziyegut'a valo rangu?” ");
INSERT INTO nyf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","O anafundzie makimudzigidzya makiamba, “Unauza ni h'ani adzekugut'a, k'uona bule zho marizho at'u ni anji hatha manakukwala-kwala?” ");
INSERT INTO nyf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ela Jesu k'aadzigidzire akienderera kutsuha matso kuno na kuno aone ni h'ani adzevihenda. ");
INSERT INTO nyf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ye mwanamuche kuona zho vidzizhokala achenda mbere za Jesu kuno anathethemwa ni mwiri kwa woga na akidzigwaga mbereze na akimwambira Jesu gosi garigo were gadzahendeka. ");
INSERT INTO nyf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesu akimwamba, “Mwanangu kuluhiro ra kwako ridzakuhoza. Enda na dheri ukale muzima na mashakago gadzagoma.” ");
INSERT INTO nyf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bai Jesu arihokala ananena gaga, poo at'u kula nyumbani kwa Jairo, makimwamba Jairo, “Ye musichanao be adzamarigizika, kwa vizho k'avimala umubudzye kaheri ye mwalimu.” ");
INSERT INTO nyf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesu hatha k'agatiire shuhuli go maronena o at'u, ela wamwamba Jairo, “Tha usogohe bewe, kuluhira thuwe.” ");
INSERT INTO nyf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bai arihokala anenda kuko kwa Jairo, akiakahaza at'u masimuthuwe asihokala P'et'ero, Jakobu na Johana nduguye ye Jakobu. ");
INSERT INTO nyf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Marihofika nyumbani kwa Jairo, makwendathekeza ha thele at'u mariokala manapiga k'ululu na kurira zhomu zhenye. ");
INSERT INTO nyf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesu achangira mo ndani, akiambira o at'u, “Mbona munapiga k'ululu na kurira? Ye muhoho k'afwere bule, arere thu.” ");
INSERT INTO nyf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","O at'u kusikira vizho makimutseka. Bai Jesu akiambira o at'u osi mambole ko ndze, akiahala o azhazi a ye muhoho na o anafundzie ahahu na achenda mo chumbani arimokala ye muhoho. ");
INSERT INTO nyf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesu akimugwira mukono ye muhoho akimwamba, “Talitha Koum.” Ambazho manaye ni, “Musichana, nakwambira uka!” ");
INSERT INTO nyf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Haho henye ye musichana arekala adzafwa akiungarara na akikwatya kunenda (iye were ni muhoho wa miaka kumi na miri). Bai o at'u marihoona zho vidzizhokala, machangalala zhomu. ");
INSERT INTO nyf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bai Jesu akiakokot'era zhomu, masimwambire mut'u. Gonya akiambira mamup'e ut'u wa kurya. ");
INSERT INTO nyf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesu akiuka kuuya mudzi wa kwao Nazareth'i iye hamwenga na anafundzie. ");
INSERT INTO nyf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na irihofika siku ya Sabato, achangira sinagogini kufundisha. Anji mariomusikira mangalazwa ni go mafundisho hatha makikwatya kuuzana-uzana, “Maut'u gano gosi be tha wagapatahi? Na ni ulachu wani arougerwa mut'u yuno? Ni miujiza yani ariyothalwa aihende yuno? ");
INSERT INTO nyf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Vidze yuno si yuyahu fundhi wa kutsonga, mwana wa Maryamu? Na samba nduguze ni Jakobu, Jose, Juda na Simoni? Na nduguze a kiche samba fu hosi haha hehu?” Bai k'aviafahire. ");
INSERT INTO nyf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ela Jesu akiambira, “Nabii anaishimiwa kila hat'u isihokala kahi za ts'i ya kwao, na kahi za amanyie, na mudzini kwao.” ");
INSERT INTO nyf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na kuko bai k'ahendere miujiza yoyosi, isihokala waaikira mikono at'u achache mariokala ni akongo na akiahoza. ");
INSERT INTO nyf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesu achangalazwa zhomu ni kutsakuluhira kwao. Gonya akidengereka mo midzi-midzi kufundisha. ");
INSERT INTO nyf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Siku mwenga Jesu waaiha aryahu anafundzi kumi na airi na akiahuma airi-airi. Akiap'a wadimi dzulu za p'ep'o akolo. ");
INSERT INTO nyf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Akiambira masitsukule kit'u chochosi mo charoni, isihokala mudhath'a thu h'akeye. Masitsukule leu, hedu mukoba, hedu hatha p'esa zozosi mabindoni mwao. ");
INSERT INTO nyf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Masivale k'andzu mbiri, ela mavale sapata. ");
INSERT INTO nyf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Hat'u mundihoambwa ‘Karibuni’ h'aya kalani kahi za nyumba iyo hatha mundihouka kut'u kuko. ");
INSERT INTO nyf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mwangiraho mudzini na o at'u masimwambe hatha ‘Karibuni’ hedu kumusirikiza bai hat'u haho haukeni kidza mukut'e-kut'e vumbi ra maguluni mwenu kunyesa kukala go gandigoapata k'amumo na mandamanya enye.” ");
INSERT INTO nyf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kwa vizho o anafundzi makiuka kwendahubiri na kuambira at'u mariche mahendo gao mai na mathubu. ");
INSERT INTO nyf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nao makwendamboza at'u p'ep'o anji na makiamwagira mafuha akongo anji na makiahoza. ");
INSERT INTO nyf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bai muthawali Herode akigasikira gosi gaga kwani dzina ra Jesu were ridzaenera kila hat'u hatha at'u angine were manaamba ni, “Johana Mubat'izaji, wafufuka, ndo hatha ana wadimi wa kuhenda maut'u mabomu-mabomu.” ");
INSERT INTO nyf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Angine o makikala manaamba, “Ni Elija” na angine makiamba, “Ni nabii dza here mumwenga wa o manabii a ho kapindi.” ");
INSERT INTO nyf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ela Herode arihosikira vivi akiamba, “Iye ni Johana Mubat'izaji niriyemutosa kitswa, wafufuka!” ");
INSERT INTO nyf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kwani Herode were walagiza kukala Johana afungwe minyororo na angizwe jela. Vivi wavihenda kwa ut'u wa Herodia mwanamuche ariyekala Herode wamuhoka nduguye ariyekala anaifwa Filipu. ");
INSERT INTO nyf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kwani Johana Mubat'izaji wakala akimwambira Herode kukala, “Si hachi bule uwe kumuhala mukaza nduguyo.” ");
INSERT INTO nyf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Vivi zhamuhendya Herodia akale na kitsukizi na akimala amwalage, ela k'azhadimire bule. ");
INSERT INTO nyf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kwani Herode wamwagoha Johana kwa kukala Johana were ni mut'u muhachi na mweri, kwa vizho akimurinda. Were kila arihomusirikiza anabudzyika moyo, ela hatha hamwenga na vizho were anahendza kusirikiza mafundishoge. ");
INSERT INTO nyf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mwishowe, Herodia wapata mwanya wa kumwalaga Johana. Herode waasunga asenae sherehe ya siku ya kukumbukira kuzhalwakwe. Bai mut'u iye waalika at'u osi a zheo uthawalini, abomu a majeshi na abomu a yo ts'i ya Galilaya. ");
INSERT INTO nyf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ndo musichana wa Herodia akidzaavinira. Bai wavinat'o zhomu hatha Herode na ajenie makifwahirwa. K'uzhona zho muthawali Herode akimwamba ye musichana, “Nambira chochosi uhendzacho nami nindakup'a.” ");
INSERT INTO nyf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Akimulahira akimwamba, “Chochosi undichomala nindakup'a, hatha kala ni nusu ya uthawali wangu.” ");
INSERT INTO nyf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ndo ye musichana akiuka kwendamuza mameye. Akiamba, “Nimale ut'u wani m'ama?” Ye mimut'u akimwamba, “Mala kitswa cha Johana Mubat'izaji.” ");
INSERT INTO nyf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ye musichana akiuya malo ko kwa muthawali achendamwamba, “Nahendza vivi kare unip'e kitswa cha Johana Mubat'izaji ndani za bunguu.” ");
INSERT INTO nyf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kudzasikira vivi, Herode washononeka zhomu, ela kwa were adzalaha mbere za ajeni kukala kila andichomalwa andalazha k'adimire kumukahaza bule. ");
INSERT INTO nyf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kwa vizho bai akilagiza shikari mara mwenga achenda ko jela akakirehe cho kitswa cha Johana. Ye shikari achenda ko jela achendamutosa kitswa Johana, ");
INSERT INTO nyf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","akidza nacho ndani za bunguu, akidzamup'a ye musichana na ye musichana akikihala akimup'a ye mameye. ");
INSERT INTO nyf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Badaye anafundzi a Johana marihosikira gaga makidzamuhala machendamuzika. ");
INSERT INTO nyf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Vikara o ahumwi a Jesu makiuya kula charo chao cha kuhubiri nao makidzamwambira viryahu marizhohubiri na marizhohenda. ");
INSERT INTO nyf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kwa ut'u wa at'u anji, ano manadza arya manauya, Jesu na anafundzie k'amadimire kurya. Bai Jesu akiambira o anafundzie, “Nahumbole-mbole vichache hedu fwende kut'u kwa h'akiyehu hukapate ngaa kudzioyeza.” ");
INSERT INTO nyf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kwa vizho machangira dauni ao kare na makiuka kwenda hat'u ha h'akiyao, kure na at'u. ");
INSERT INTO nyf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ela hatha hamwenga na vizho at'u anji maaona marihokala makuukani na makiamanya. Ndo makiuka malo kula midzi yosi kwenda ko arikokala Jesu na anafundzie manenda, nao makifika na mbere. ");
INSERT INTO nyf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","K'uzhona Jesu arihothima kula mo dauni akirona ro kundi bomu ra at'u, naye akiaonera mbazi kwa viryahu marizhokala ni here ng'ondzi zisizo na murisa. Bai akikwatya kuafundisha maut'u manji. ");
INSERT INTO nyf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mutsana urihokala udzaenderera zhomu nako kunenda kutswani, o anafundzi makimwamba Jesu, “Hat'u haha be ni nyika zhomu nako kunatswa. ");
INSERT INTO nyf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kwa vizho baha uafumule aa at'u mende kahi za midzi na minda iriyo hehi na haha makadzigulire ut'u wowosi wa kurya.” ");
INSERT INTO nyf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Naye Jesu arihombola kudzigidzya akiamba, “Ap'eni chakurya ninwi.” Ndo o anafundzie makimudzigidzya makimwamba, “Vidze unahendza hukagule mikahe ya kima cha dinari magana mairi at'u ano mathosheke kurya?” ");
INSERT INTO nyf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesu akiauza akiamba, “Kwani vino muna mikahe mingahi? Hedu kaloleni,” machendalola na marihogonya kulola makimwambira, “Ni mitsano na makumba mairi.” ");
INSERT INTO nyf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bai Jesu akiambira o anafundzie, “Ambireni o at'u madzigazhe vithundhu-vithundhu na makelesi ho nyasini.” ");
INSERT INTO nyf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kwa vizho o at'u makikelesi, vithundhu-vithundhu zha at'u gana-gana na zha at'u mirongo mitsano-mitsano. ");
INSERT INTO nyf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Gonya akihala yo mikahe mitsano na go makumba mairi, akilola dzulu mulunguni, akimboza muv̱era kwa Mulungu, gonya akiimogola-mogola yo mikahe na akiap'a o anafundzie maagazhire o at'u na go makumba mairi. ");
INSERT INTO nyf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nao osi makirya hatha makivilola. ");
INSERT INTO nyf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bai marihogonya kurya o anafundzi makitsola-tsola zho visiku-visiku zha mikahe na zha go makumba mairi virizhokala vidzasala, na makidzaza k'ahu kumi na mbiri. ");
INSERT INTO nyf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na isabu ya ao mariokala madzarya yo mikahe were ni at'u alifu ts'ano, alume. ");
INSERT INTO nyf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bai o at'u marihogonya kurya thu, Jesu waalagiza o anafundzie mangire dauni na mavuke mathangulie kwenda Beth'isaida, kuno ye anaafumula o at'u. ");
INSERT INTO nyf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Arihogonya kulagana na o at'u, wakwenda murimani kwendavoya. ");
INSERT INTO nyf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dzulo ririhongira, dau rere ri kahikahi ya ro ziya, ela Jesu were achere ko ts'i furufu h'akeye. ");
INSERT INTO nyf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Arihokala a kuko, akiaona o anafundzie manathabika kupiga makasia kwani lupeho lwere lunambola ko mendako. Bai urihofika wakathi wa jogolo ra kwandza kuika, akiambolera kuno ananenda dzulu za madzi. Akidzihendesha here anaakira. ");
INSERT INTO nyf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ela o anafundzi marihomona ananenda dzulu ya madzi, makiona ni p'ep'o be o, makipiga k'ululu. ");
INSERT INTO nyf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kwani osi mamona, na makihondoka. Jesu akinena nao mara mwenga akiamba, “Sogoheni ndimi, musihondoke.” ");
INSERT INTO nyf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Gonya achangira mo dauni na lo luv̱utho lukihurira hu! O anafundzi makingalala kamare, ");
INSERT INTO nyf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kwa kukala hatha bada ya kuona wo muujiza wa mikahe kidza were k'amadzangwe kung'alirwat'o bule kwani zo akili zao zere zidzaziywa. ");
INSERT INTO nyf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bai Jesu na anafundzie makivuka ro ziya na makifika ts'i ya Genezarethi makirifunga kuko ro dau. ");
INSERT INTO nyf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Marihokala manathima mo dauni at'u makimumanya kare ye Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Makiuka malo kuvisema kila hat'u, makikwatya kumuhirikira akongo mariokala madzaatsukula na vitanda, kila marihosikira a haho. ");
INSERT INTO nyf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Naye Jesu, wangira kila hat'u kula vidzidzini, midzini, mindani na masokoni na at'u makimurehera akongo, makimuvoya magut'e hatha chamba ni ro pindo ra ro valore, na osi mariorigut'a mahola. ");
INSERT INTO nyf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Siku mwenga Mafarisayo na alimu a Sheria mariokala madzambola Jerusalemu, makundzumanyikana mbere za Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Makiaona anafundzi angine a Jesu manarya chakurya hasiho kuoga mikono here malagizo ga akare ao gaambazho. ");
INSERT INTO nyf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ndo virizho na Mafarisayo na Ayahudi osi, ao managwira mafundisho ga akare ao. Lola k'amadima kurya hasiho kuoga mikono yao karakara na malagizo gaga. ");
INSERT INTO nyf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kidza makidza kula sokoni k'amadima kurya kit'u, muhaka maoge mikono kwandza. Pia were makigathuwa malagizo mangine manji marigogahokera dza here ngira ya karakara ya kugesa vikombe, nyungu na mabunguu ga ng'andu.) ");
INSERT INTO nyf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kuona gago marigokala o anafundzi a Jesu managahenda, o Mafarisayo na alimu a Sheria makimuza Jesu makiamba, “Mbona ano anafundzio k'amarigwira ro adha ra kuoga mikono hurirorichirwa ni akare ehu? Manarya na mikono michafu.” ");
INSERT INTO nyf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesu akiamba, “Nabii Isaya wanenat'o sana dzulu zenu ninwi at'u a kudzihendya, kwani Maoro ganaamba, ‘At'u aa mananogoha kwa makanwa gao, ela mioyo yao i kure nami. ");
INSERT INTO nyf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Hatha makanivoya ni bule, kwa kukala manahala maadha ga anadamu, na kugafundisha here malagizo gangu.’ ");
INSERT INTO nyf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mudzagaika k'anda malagizo ga Mulungu na hat'u ha vizho munathuwa mafundisho ga at'u.” ");
INSERT INTO nyf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesu akienderera kunena akiamba, “Muna ulachu wa kukahalira malagizo ga Mulungu kwamba muthuwe maadha genu. ");
INSERT INTO nyf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kwani Musa waamba, ‘Muishimu babayo na mameyo.’ Kidza akiamba, ‘Ye andemuhukana babaye hedu mameye, kumala kwalagwa naalagwe.’ ");
INSERT INTO nyf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ela ninwi munafundisha kwamba, mut'u akikala ana kit'u cha kuakola babaye na mameye, ela akiamba ‘Koribani’ ambazho manaye ni kuamba, (Cho niricho nikamup'a dzachamboza sadaka kwa Mulungu), ");
INSERT INTO nyf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ni kukala ana chausa cha kuthosha cha kutsamwaviza babaye na mameye. ");
INSERT INTO nyf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nanwi kwa ngira ii munarihenda neno ra Mulungu kutsakala na nguvu, kwa go muafundishago andziyenu; na kuna manji mangine muhendago gadzigohalana na gaga.” ");
INSERT INTO nyf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Gonya Jesu akiriha ro kundi ra at'u kaheri akiambira, “Nisirikizani nyosi na mung'alirwe. ");
INSERT INTO nyf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","K'akuna mut'u adimaye kuhendywa mukolo ni chakurya.” (Ela kidimacho kumuhendya mut'u kukala mukolo ni cho chambolacho mo moyoni mwa ye mut'u.)  ");
INSERT INTO nyf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mut'u mwenye masikiro, naasikire. ");
INSERT INTO nyf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Badaye Jesu arihokala adzaashalahukira o at'u, wakwenda kahi za nyumba, bai anafundzie makimuza dzulu za fumbo riri. ");
INSERT INTO nyf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesu akiadzigidzya akiamba, “Hatha ninwi nanwi k'amung'alirwa bule? Chakurya k'akidima kumuhendya mut'u akale mukolo, ");
INSERT INTO nyf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kwa kukala k'achenda mo moyoni, ela kinenda mo ndanini, na gonya endaho chandze cho adzichorya ni kwambola.” (Kwa kunena vivi, Jesu were ana mana kukala zhakurya zhosi ni visafi.) ");
INSERT INTO nyf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesu akienderera kunena akiamba, “Cho chambolacho mo moyoni mwa ye mut'u ndo kimuhendyacho mut'u kukala mukolo, ");
INSERT INTO nyf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","kwa kukala kula mumo moyoni ni kumbola maazo mai gamuhendyago kuhenda maut'u gasigov̱irya ambago ni kuiya, kwalaga, ");
INSERT INTO nyf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kuzinga, kutona, kila maazo mai, kukenga, kutsowa lau, kidzitso, kuhukana, kudzionya na uzuzu. ");
INSERT INTO nyf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gaga maut'u mai gosi ni kumbola kula moyoni mwa mut'u na ndo gadimago kumuhendya mukolo.” ");
INSERT INTO nyf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Gonya Jesu akiuka ko Galilaya na achenda hatha sehemu za midzi ya Tiro na Sidoni. Kuko, achangira kahi za nyumba mwenga naye were k'endzi mut'u yoyosi amanye kukala a haho. Ela k'avidimikikire kwani uv̱oro wa kudzakwe wavuma kare kila hat'u. ");
INSERT INTO nyf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Vikara kwere kuna mwanamuche mumwenga ariye were ana mwanawe wa kiche ana p'ep'o. K'uzhona zho arihosikira kukala Jesu adzire hat'u haho wakwenda na achendadzigwaga mbereze. ");
INSERT INTO nyf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Naye ye mwanamuche were si Muyahudi, ela were wazhalwa ts'i ya Asirofonike. K'uzhona zho akimuririra Jesu kwamba apate kumwamboza ye p'ep'o ariyekala a ndani za ye musichanawe. ");
INSERT INTO nyf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ela Jesu akimudzigidzya ye mwanamuche akiamba, “Richa o ahoho makuhe kwandza, kwa kukala si karakara kuhala chakurya cha ahoho na kukitsuhira k'uro.” ");
INSERT INTO nyf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Naye mwanamuche akimwambira Jesu, “U mujeri we, ela hatha o k'uro, ni kurya go magande ga cho chakurya cha ahoho gagwago ho ts'i.” ");
INSERT INTO nyf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesu akimudzigidzya akiamba, “Kwa vizho udzizhonena, unadima kwenda mudzini, ye p'ep'o adzamwambola ye mwanao.” ");
INSERT INTO nyf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Bai ye mwanamuche achenda ko mudzini kwakwe naye achendamuthekeza ye muhoho ahembelele kitandani na ye p'ep'o akikala adzamwambola. ");
INSERT INTO nyf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Badaye Jesu akiuka kula ko sehemu za midzi ya Tiro na Sidoni, akikira na upande wa ziya ra Galilaya hatha achangira jimbo ra Midzi Kumi. ");
INSERT INTO nyf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bai at'u fulani makimurehera Jesu mut'u ariye were ni gwigwi kidza were masikiroge ni makoto. O at'u makimubembeleza Jesu kwamba amuikire mukono ahole. ");
INSERT INTO nyf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","K'uzhona zho Jesu akimuvuha k'anda ye mut'u, kure na o at'u anji, achangiza mala mo masikironi mwa ye mut'u gonya akitsuha mahe mo malani mwakwe na akimugut'a lo ludhimi. ");
INSERT INTO nyf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Gonya Jesu akilola dzulu mulunguni na akisohera dzulu akiamba, “Efatha” ambazho manaye ni kuamba “Vuguka.” ");
INSERT INTO nyf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Haho henye ye mut'u masikiroge gakivuguka, na kidza ludhimilwe lukirichizwa na akinena t'ot'ot'o. ");
INSERT INTO nyf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesu akiakokot'era o at'u kukala masimwambire mut'u go adzigogahenda, ela kila arihoakokot'era makikaza kuvitsamula kila hat'u ");
INSERT INTO nyf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na lola o at'u mangalala kamare na makiamba, “Mut'u yuyu kila ahendaro ni ridzo, hatha anahenda magwigwi ganene na enye makoto mavuguke masikiro kamare!” ");
INSERT INTO nyf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Siku mwenga ngororoki bomu ya at'u yakundzumanyika, na kwa kukala were k'amana ut'u wowosi wa kurya, Jesu waaiha hamwenga o anafundzie na akiambira, ");
INSERT INTO nyf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“At'u aa be mananishononesa zhomu. Hangu makale nami haha, rero ni hahu, na vivi k'amana ut'u wowosi wa kurya. ");
INSERT INTO nyf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nikiamba ninaafumula mende kwao midzini bila kuap'a kit'u marye, mandagwa na mutsare mo ngirani kwani angine ao madzalaa kure.” ");
INSERT INTO nyf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ndo anafundzie makimudzigidzya makiamba, “Mut'u anadima kuarisadze at'u ano hano nyika?” ");
INSERT INTO nyf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ndo Jesu akiauza akiamba, “Kwani muna mikahe mingahi?” Makiamba, “Mifungahe.” ");
INSERT INTO nyf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bai Jesu akiambira o at'u, makelesi ho ts'i. Gonya akiihala yo mikahe mifungahe, akilazha muv̱era kwa Mulungu, na akiimogola-mogola akiap'a o anafundzie maagazhire o at'u, na o anafundzie makihenda vizho zhenye. ");
INSERT INTO nyf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kidza were mana vikumba vichache, vizho nazho Jesu akivihala akimboza muv̱era kwa Mulungu, na gonya akiap'a o anafundzi kwamba mavigazhizhe at'u nazho. ");
INSERT INTO nyf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na lola o at'u marya hatha makivilola, kidza o anafundzi makidzaza k'ahu fungahe za visiku-visiku virizhokala vidzasala. ");
INSERT INTO nyf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Naho were hana at'u mafikao alifu ne. ");
INSERT INTO nyf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bai Jesu akiafumula, gonya achangira dauni mara mwenga hamwenga na o anafundzie machenda ts'i ya Dalimanuth'a. ");
INSERT INTO nyf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bai arihokala kuko, Mafarisayo mamuthuwa makikwatya kupigana k'anani naye. Na kidza were manamala kumujeza, kwa vizho makimwamba Jesu aahendere muujiza wa kula mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesu akishononeka moyoni akiamba, “Mbona kizhazi kinamala kuhenderwa miujiza? Namwambira jeri wenye kukala k'akindanyeswa muujiza wowosi.” ");
INSERT INTO nyf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bai Jesu akiahaukira o Mafarisayo, achangira dauni na achenda nyangamo nyingine ya ro ziya. ");
INSERT INTO nyf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","O anafundzi a Jesu mere madzasahau kutsukula mikahe ya kuthosha, mere mana mukahe mumwenga thu mo dauni. ");
INSERT INTO nyf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesu akiaonya o anafundzie akiamba, “Dzichungeni sana. Dzimanyirireni na ts'ats'u ya Mafarisayo na ya Herode.” ");
INSERT INTO nyf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","K'uzhona bai o anafundzie makikwatya kuuzana-uzana makiamba, “Yuyu anaamba vivi kwa kukala k'ahuna mikahe.” ");
INSERT INTO nyf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu akikala anamanya zho marizhokala mananena, kwa vizho akiauza akiamba, “Kwanoni munauzana-uzana dzulu za kukosa mikahe? Vidze muchere k'amuona kidza k'amudzang'alirwa? Hedu muna mioyo miomu? ");
INSERT INTO nyf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Muna matso, ela k'amuona! Muna masikiro, ela k'amusikira. Kidza k'amukumbukira bule. ");
INSERT INTO nyf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nirihoimogola yo mikahe mitsano na kuarisa at'u alifu ts'ano, vidze ni k'ahu nyingahi za masaza murizodzaza?” O anafundzi makiamba, “Kumi na mbiri.” ");
INSERT INTO nyf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesu akienderera kuauza akiamba, “H'e zho nirizhoarisa at'u alifu ne na mikahe mifungahe, ni k'ahu nyingahi za masaza murizodzaza?” O anafundzie makiamba, “Fungahe.” ");
INSERT INTO nyf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesu akiamba, “Vidze muchere k'amudzang'alirwa?” ");
INSERT INTO nyf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bai machenda hatha makifika Beth'isaida, na kuko at'u makimurehera Jesu mut'u ariyekala ni kipofu na makimungolangola Jesu amugut'e ye kipofu kwamba ahole. ");
INSERT INTO nyf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ndo Jesu akimugwira mukono ye kipofu na achenda naye ndze ya ko kadzidzi. Akimutsuhira mahe mo matsoni gonya akimuikira mikono na akimuza akiamba, “Vidze vino unaona?” ");
INSERT INTO nyf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ye mut'u akinula kitswa vichache akilola naye akimwambira Jesu, “Ee naona at'u manenda, ela ni here mihi.” ");
INSERT INTO nyf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesu arihosikira vivi akimwikira mikono kaheri mo matsoni mwakwe, na ariholola kaheri nguvu za matsoge zikimuuyira naye akikwatya kuona kila kit'u t'ot'ot'o. ");
INSERT INTO nyf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesu akimukokot'era ye mut'u akiamba, “Enda mudzini kwako, na siuye na mo kadzidzini.” ");
INSERT INTO nyf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Badaye Jesu na o anafundzie machambola kwenda zho vidzidzi zha jimbo ra Kaisaria Filipi. Bai mo ngirani Jesu akiauza o anafundzie akiamba, “Vidze at'u manaamba mino ni h'ani?” ");
INSERT INTO nyf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Makimudzigidzya makiamba, “Angine manaamba u Johana Mubat'izaji, na angine manaamba u Elija, kidza angine manaamba kukala u mumwenga kahi za o manabii.” ");
INSERT INTO nyf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Naye akiuza akiamba, “Vidze nwi munaamba mino ni h'ani?” P'et'ero akimudzigidzya akiamba, “Uwe ndiwe ye Masihi.” ");
INSERT INTO nyf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesu akiakokot'era akiambira masimwambire mut'u yoyosi dzuluze. ");
INSERT INTO nyf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ndo Jesu akikwatya kuafundisha anafundzie, akiamba, “Mwana wa Mudamu lazima ateswe sana na akahalwe ni athumia, na alombi abomu na alimu a Sheria, na andalagwa, ela bada ya siku t'ahu andafufuka.” ");
INSERT INTO nyf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesu waganena maut'u gaga lwazu-lwazu. Bai P'et'ero akimuvuha k'anda akimuchemera. ");
INSERT INTO nyf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ela Jesu akihunduka kulola wo upande mariko o anafundzie na akimuchemera P'et'ero akimwamba, “Hauke Shethani! Maazogo k'agambola kwa Mulungu, ela ni ga kibinadamu.” ");
INSERT INTO nyf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Gonya Jesu akiambira o anafundzie hamwenga na wo muthunganano wa at'u madze hehi naye. Gonya akiamba, “Mut'u akihendza kunithuwa mimi, suthi adzikane mwenye, na adzihike musalabawe anithuwe. ");
INSERT INTO nyf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mana kila amalaye kuthizha rohoye andayangamiza, ela kila andiyeyangamiza rohoye kwa ut'u wangu na kwa ut'u wa wo Uv̱oro Udzo wa Mulungu, iye andaithizha. ");
INSERT INTO nyf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kwani vindamufwahani mut'u akipata vit'u zhosi zha urumwengu, gonya rohoye yangamike? ");
INSERT INTO nyf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Hedu mut'u anadima kugula rohoye? ");
INSERT INTO nyf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kwani mut'u anioneraye haya hamwenga na gaga mafundisho gangu kahi za kizhazi kiki cha dambi kisichokuluhira, Mwana wa Mudamu naye andamuonera haya siku iyo andihokudza kahi za nguma ya Babaye hamwenga na malaika aeri.” ");
INSERT INTO nyf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Gonya Jesu akiamba, “Ninamwambira ujeri, haha hana at'u mario k'amandafwa hatha mawone uthawali wa Mulungu udzire na nguvu.” ");
INSERT INTO nyf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bada ya siku t'andahu, Jesu wamuhala P'et'ero, Jakobu na Johana machendakwera dzulu za murima mure, makikala kuko h'akiyao. Vikara marihokala ma kuko, ye Jesu akigaluka sura kuno manalolera. ");
INSERT INTO nyf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nguwoze zakala nyaruhe zhomu, kidza were zinang'ala-ng'ala hatha k'akuna mufuli yoyosi haha dhuniani adimaye kuzifula dza vizho. ");
INSERT INTO nyf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Gonya Elija na Musa makiambolera na makikala mananena na Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","P'et'ero akimwambira Jesu, “Mwalimu ni vidzo zho zha fu haha! Nahuake vibanda vihahu, kimwenga cha kwako, kimwenga cha Musa na kimwenga cha Elija.” ");
INSERT INTO nyf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","P'et'ero were tha k'amanya aneneni kwa wo woga ariokala nao iye na o andziye. ");
INSERT INTO nyf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Gonya kukidza ingu rikidzaafinikira na sauthi ichambola mo inguni ikiamba, “Yuyu ni Mwanangu muhendzwi, musirikizeni iye.” ");
INSERT INTO nyf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Haho kwa haho P'et'ero, Jakobu na Johana makitsuha matso kuku na kuku, ela k'amaonere mut'u mungine hamwenga nao isihokala Jesu h'akeye. ");
INSERT INTO nyf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Badaye marihokala manatharamuka kula ko dzulu ya wo murima, Jesu akiakokot'era p'ore makambira mut'u go madzigogaona muhaka ho Mwana wa Mudamu andihofufuka. ");
INSERT INTO nyf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kwa vizho o anafundzie ahahu makisikira zho arizhoakokot'era ye Jesu, ela ko o enye na enye makiuzana-uzana, “Kufufuka kula kifwani manaye ni noni?” ");
INSERT INTO nyf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bai kahi za vizho o anafundzi makimuza Jesu makiamba, “Mbona alimu a Sheria manaamba ni lazima Elija adze kwandza?” ");
INSERT INTO nyf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesu akiadzigidzya akiamba, “Ni jeri, Elija ni lazima athangulie kuthayarisha kila kit'u kwandza, ela hatha vizho zhaorwa kwamba ye Mwana wa Mudamu andapata mashaka na kukahalwa. ");
INSERT INTO nyf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ela namwambira bai, kukala Elija wakudza kare na o at'u makimuhenda kila marichoona ni karakara dza here Maoro garizhonena dzuluze.” ");
INSERT INTO nyf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Badaye Jesu na o anafundzie ahahu marihoauyira o anafundzi angine makiona kundi ra at'u, na alimu a Sheria were manapigana k'anani na o anafundzi. ");
INSERT INTO nyf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","O at'u kumona Jesu akudzani thu, machangalala zhomu makikot'a malo machendamulamusa. ");
INSERT INTO nyf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesu akiauza, “Ni ut'u wani udziwomuhendya hatha munapigana k'anani?” ");
INSERT INTO nyf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ndo mwanamulume mumwenga ariyekala a kahi za ro kundi ra o at'u achambola kumudzigidzya Jesu akiamba, “Mwalimu, mut'u mimi dzamureha mwanangu kwako, kwa kukala k'adima kunena, ana p'ep'o bwibwi. ");
INSERT INTO nyf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kila amugwagaho ni kumuhendya akambola fulo ra kanwani, akaluma meno na kidza akaumalala. Dzaambira aa anafundzio mamwamboze ye p'ep'o, ela k'amazhadimire.” ");
INSERT INTO nyf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kusikira vizho Jesu akiahundukira o anafundzie, akiamba, “H'enwi at'u musio na kuluhiro! Nindakala nanwi hatha rini? Nindamuvumirira hatha rini? Mureheni kuno ye muhoho.” ");
INSERT INTO nyf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bai makimureha ye muhoho kwa Jesu. Lola ye p'ep'o arihomona Jesu thu, akimugwaga ye muhoho, kuno anagalagala na kumbola fulo ra kanwani. ");
INSERT INTO nyf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu akimuza ye bimut'u akiamba, “Zhamuandza rini vino?” Ye babaye ye muhoho akidzigidzya akiamba, “Ni kula uhohowe. ");
INSERT INTO nyf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","K'ana nyinji ye p'ep'o adzajeza kumwalaga kwa kumutsuha mohoni hedu madzini. Fuonere mbazi ufwavize chamba undazhadima!” ");
INSERT INTO nyf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu akidzigidzya akiamba, “Ati chamba ndazhadima? Gosi ganadimikika kwa ye akuluhiraye.” ");
INSERT INTO nyf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bai ye babaye ye muhoho akiluta mumiro akiamba, “Ninakuluhira, ela naviza kutsakuluhira kwangu.” ");
INSERT INTO nyf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu arihoona at'u anji manadza akimuchemera ye p'ep'o akimwamba, “We p'ep'o gwigwi na makoto, h'aya mwambole kare ye muhoho na usimwangire kaheri!” ");
INSERT INTO nyf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ye p'ep'o akipiga luchemi zhomu, akimupiga na ts'i ye muhoho ndo akimwambola. Naye wakala ni here adziyefwa ye muhoho. O at'u kuona vizho makikwatya kuamba, “Adzafwa benwi!” ");
INSERT INTO nyf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ela Jesu akigoloza mukono akimugwira ye muhoho na akimurungaraza. ");
INSERT INTO nyf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Badaye Jesu arihokala adzangira nyumbani na o anafundzie, o anafundzie mamuza kinjama makiamba, “Kwanoni sino k'ahudimire kumwamboza ye p'ep'o?” ");
INSERT INTO nyf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesu akiadzigidzya akiamba, “K'akuna mut'u adimaye kumwamboza p'ep'o dza yuyu hasiho kuvoya.” ");
INSERT INTO nyf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Machambola kuko, makikira kahikahi ya Galilaya. Naye k'ahendzeze mut'u yoyosi amanye ko ariko, ");
INSERT INTO nyf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwa kukala were anaafundisha anafundzie. Were anaamba, “Mwana wa Mudamu andalazhwa kwa at'u nao mandamwalaga. Bai achalagwa andafufuka bada ya siku t'ahu.” ");
INSERT INTO nyf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ela o anafundzie k'amang'alirirwe ni gago arigokala Jesu anaambira, kidza makikala aoga na kumuza. ");
INSERT INTO nyf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bai machenda hatha makifika Kaperinaumu na marihokala madzangira nyumbani, Jesu waauza o anafundzie akiamba, “Kurya ngirani mudzakala munapigana k'anani za noni?” ");
INSERT INTO nyf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","O anafundzie makimunyamalira zii, kwa kukala mo ngirani mosi were madzapigana k'anani za mubomu ni h'ani kahi zao. ");
INSERT INTO nyf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Vikara arihokala akeresi, Jesu waaiha o anafundzie kumi na airi akiambira, “Kila ahendzaye akale wa kwandza suthi adziike wa mwisho na akale muhumiki wa osi.” ");
INSERT INTO nyf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Gonya akimuhala muhoho muthithe, akimwika kahikahi yao, na akiamba, ");
INSERT INTO nyf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kila amuhokeraye muhoho muthithe dza yuyu kwa dzina rangu, ananihokera mimi, na ye anihokeraye mimi k'anihokera mimi bule, ela anamuhokera iye ariyenihuma.” ");
INSERT INTO nyf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kusikira vizho, Johana ariye ni mumwenga wa o anafundzi akiamba, “Mwalimu, fwaona mut'u anamboza p'ep'o kwa dzinaro, naswi hukimukahaza, kwa kukala si mumwenga wehu.” ");
INSERT INTO nyf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesu akidzigidzya akiamba, “Musimukahaze, kwani k'ahana ahendaye miujiza kwa dzina rangu gonya ko akanena mai dzulu zangu, ");
INSERT INTO nyf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","mana mut'u ariye k'akinyume chehu ni wehu. ");
INSERT INTO nyf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Manyani vivi, kila andemup'a kikombe cha madzi kwa kukala mu at'u a Masihi, mut'u iye k'andakosa zawadiye.” ");
INSERT INTO nyf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesu akienderera kunena akiamba, “Ela mut'u yoyosi andiyemuhendya mumwenga wa aa athithe manikuluhirao ahende dambi, ni baha afungwe lwalwa lwa singo atsufwe baharini. ");
INSERT INTO nyf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na mukonowo ukikuhendya uhende dambi, utose. Kwani ni baha wangire uzimani na mukono mumwenga, kuriko kwenda na mikono yosi miri ko Jehanamu, kuriko mohowe k'auzima hatha kare na kare.  ");
INSERT INTO nyf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Fundza a kuko k'amafwa bule na wo moho nawo k'auzinyika. ");
INSERT INTO nyf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na kigulucho kikikuhendya uhende dambi, kitose, kwani baha wangire uzimani na kigulu kimwenga kuriko utsufwe Jehanamu na magulugo mairi.  ");
INSERT INTO nyf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Fundza a kuko k'amafwa bule na wo moho nawo k'auzinyika. ");
INSERT INTO nyf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Dzitsoro rikikuhendya uhende dambi, rishukule. Kwani ni baha wangire kahi za uthawali wa Mulungu na ch'ongo, kuriko utsufwe Jehanamu na matso mairi, ");
INSERT INTO nyf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","murimo muna mabulu gasofwa na moho usiwozima. ");
INSERT INTO nyf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kwani kila mut'u andahendywa mueri kukirira na moho. ");
INSERT INTO nyf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Munyu ni mudzo, ela chamba k'aukoza kaheri, k'ahana ngira idimayo kuuhendya ukakoza. Kalani na munyu ndani mwenu na muishi na dheri na at'u angine.” ");
INSERT INTO nyf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Gonya Jesu akiuka kuko achenda jimbo ra Judea, na kuvuka muho wa Jorodani. Makundi-makundi ga at'u gakidza ho arihokala. Naye akiafundisha here garizhokala mazowerage. ");
INSERT INTO nyf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bai Mafarisayo makimwenderera makamujeze, makimuza, “Vidze ni karakara mut'u kumuricha muchewe?” ");
INSERT INTO nyf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesu akiadzigidzya akiamba, “Kwani Musa wamulagizadze?” ");
INSERT INTO nyf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Makiamba, “Musa walazha ruhusa mut'u aore cheti cha kurichana gonya umuriche.” ");
INSERT INTO nyf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesu akiamba, “Musa wamuorera malagizo gaga kwa kukala mu at'u a singo nyomu. ");
INSERT INTO nyf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ela hangu chaho cha kuumbwa urumwengu, ‘Mulungu waaumba muche na mulume.’ ");
INSERT INTO nyf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kwa ut'u uu mut'u andamuricha babaye na mameye agwirane na muchewe, ");
INSERT INTO nyf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na ao airi mandakala mwiri mumwenga. Bai madzauya si airi kaheri, ni mwiri mumwenga. ");
INSERT INTO nyf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kwa vizho adzichokigwizanya Mulungu, mudamu asikitose bule.” ");
INSERT INTO nyf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Badaye marihongira nyumbani kaheri, o anafundzie mamuza Jesu dzulu za ut'u uu kaheri. ");
INSERT INTO nyf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesu akiambira, “Mut'u amurichaye muchewe na kuhala muche mungine nikukala anazinga. ");
INSERT INTO nyf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na muche amurichaye mulumewe na kuhalwa ni mulume mungine nikukala anazinga.” ");
INSERT INTO nyf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Gonya at'u mere manamurehera Jesu ahoho athithe aagut'e, ela o anafundzi makiadumulira o at'u. ");
INSERT INTO nyf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesu arihoona viryahu, akitsukirwa akiamba, “Aricheni ahoho athithe madze kwangu, musiakahaze bule, kwani uthawali wa Mulungu ni wa at'u dza vizho aa. ");
INSERT INTO nyf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Namwambira ujeri wenye, mut'u ariye k'andauhokera uthawali wa Mulungu dza here muhoho muthithe, k'andawangira ng'o.” ");
INSERT INTO nyf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Gonya Jesu akiahala o ahoho akianula, akiaikira mikonoye akiahasa. ");
INSERT INTO nyf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Badaye Jesu arihouka kwenda mo ngirani, mut'u mumwenga akidza malo, akimupigira mavindi akimuza akiamba, “Mwalimu mudzo, nihendedze hatha nipate uzima wa kare na kare?” ");
INSERT INTO nyf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu akimwamba, “Kwanoni unaniha mudzo? K'akuna mudzo, asihokala Mulungu h'akeye. ");
INSERT INTO nyf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Uwe unamanya malagizo ga Mulungu: Usalage, usizinge, usiiye, usimboze ushahidhi wa ulongo, usikenge, aishimu babayo na mameyo.” ");
INSERT INTO nyf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ye mut'u kusikira vivi akiamba, “Mwalimu, gaga gosi nagagwira hangu nichere muhoho.” ");
INSERT INTO nyf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu akimulola kwa mahendzo, gonya akimwamba, “Udzahungukirwa ni kit'u kimwenga nacho ni kiki. Enda ukaguze kila kit'u uricho nacho, gonya zo p'esa uap'e akiya, nawe undakala na akiba ko mulunguni. Ukigonya kuhenda vizho ndzo unithuwe.” ");
INSERT INTO nyf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ye mut'u kudzasikira vizho, uso gii, akihauka k'ana raha mana were ana mali nyinji zhomu. ");
INSERT INTO nyf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu akitsuha matso kuno na kuno, akiambira o anafundzie, “Vindakala vikomu kwa mashaha kwangira uthawali wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","O anafundzi makingalala zhomu marihosikira maneno gago. Jesu akienderera kuamba, “Anangu ni vikomu zhomu kwa ao makuluhirao ushaha kwangira kahi za uthawali wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ni rahisi ngamira kukira kahi za t'undu ya shindano, kuriko shaha kwangira kahi za uthawali wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kusikira vizho, o anafundzi makingalala zhomu, makimwamba, “Hatha ni h'ani adimaye kuokoka be zho?” ");
INSERT INTO nyf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu akialola gonya akiamba, “Kwa nguvu za mudamu k'azhadimikika, ela si kwa Mulungu bule, mana kwa Mulungu kila kit'u kinadimikika.” ");
INSERT INTO nyf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ndo P'et'ero akimwamba Jesu, “Lola, fwaricha zhosi fukikuthuwa uwe.” ");
INSERT INTO nyf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu akiamba, “Namwambira ujeri, k'akuna mut'u ariyericha nyumbaye, nduguze, babaye, mameye, anae hedu minda kwa ut'u wangu mimi na kwa ut'u wa Uv̱oro Udzo, ");
INSERT INTO nyf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ariye k'andarifwa kahi za wakathi uu kare. Andapata mara gana ya vit'uzhe zhosi: nyumba, ndugu, mameze, ana, minda hamwenga na mateso nago. Na kidza andapata uzima wa kare na kare kahi za urumwengu udzawo. ");
INSERT INTO nyf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ela anji mario vivi ni a kwandza, mandakala a mwisho, na a mwisho, mandakala a kwandza.” ");
INSERT INTO nyf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Vikara makikala ma ngirani manenda Jerusalemu. Jesu were nde ariye mbere na o anafundzie makingalala, na ao at'u mariokala nyuma zao were mathele woga. Jesu akiavuha k'anda kaheri o anafundzi kumi na airi na akiathalira garyahu maut'u gandigomupata. ");
INSERT INTO nyf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Akiamba, “Lolani, vivi hunenda Jerusalemu. Na kuko Mwana wa Mudamu andalazhwa kwa alombi abomu na alimu a Sheria. Ao mandamuhukumu kwalagwa na mamulazhe kwa at'u mario si Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mandamusholera mamutsuhire mahe, mamupige na mamwalage, ela bada ya siku t'ahu andafufuka.” ");
INSERT INTO nyf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jakobu na Johana ana a Zebedayo makimwenderera Jesu, makimwamba, “Mwalimu, huna ut'u humalao uhuhendere.” ");
INSERT INTO nyf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesu akiauza akiamba, “Munamala nimuhendereni?” ");
INSERT INTO nyf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Makimwamba, “Hunamala haho kala udzire kahi za ngumayo, uhuruhusu mumwenga wehu akeresi mukonowo wa kurya na mungine akeresi mukonowo wa kumots'o.” ");
INSERT INTO nyf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesu akiambira, “Ninwi be tha k'amukimanya bule cho mukivoyacho. Vidze cho kikombe ninwacho munadima kukinwa nwi? Hedu munadima kubat'izwa na wo ubat'izo nibat'izirwao?” ");
INSERT INTO nyf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","O ana a Zebedayo makiamba, “Ee hunadima.” Jesu akiambira, “Cho kikombe ninwacho nanwi mundakinwa, na wo ubat'izo nibat'izirwao nanwi mundabat'izwa na uwo. ");
INSERT INTO nyf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ela kukeresi mukono wangu wa kurya hedu mukono wa kumots'o, sina wadimi nazho bule. Kwani kuko Baba wakutengezera at'ue, na ao ndo mandiokala kuko.” ");
INSERT INTO nyf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","K'uzhona aryahu anafundzi angine kumi marihosikira, makiatsukirirwa Jakobu na Johana. ");
INSERT INTO nyf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ela Jesu akiaiha, akiambira, “Munamanya kukala ao mav̱iryao kuathawala at'u mario si Ayahudi manahendza kuthawala at'u ao na ukali munji. Na aryahu abomu mario ts'ini zao nao, manahendza kuhumira wadimi wao wosi kuatumisha o at'u. ");
INSERT INTO nyf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ela ninwi musikale vizho bule. Iye ahendzaye kukala mubomu be suthi akale muhumiki wenu. ");
INSERT INTO nyf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na kila ahendzaye kukala kitswa kahi zenu suthi akale mutumwa wa osi. ");
INSERT INTO nyf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwani Mwana wa Mudamu naye k'adzire ahumikirwe, ela wakudza ahumike na alazhe uzimawe aakombole at'u anji.” ");
INSERT INTO nyf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Badaye Jesu na anafundzie makwenda mudzi wa Jeriko. Bai arihokala anambola Jeriko na anafundzie hamwenga na kundi bomu ra at'u, haho k'anda-k'anda za ngira, were hakelesi kipofu mumwenga ariyekala kaziye ni kuvoya-voya. Kipofu yuyu were anaifwa Bat'imayo, yani mwana wa T'imayo. ");
INSERT INTO nyf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Arihosikira kukala ni Jesu wa Nazareth'i nde ariyekala anakira, wakwatya kuluta mumiro akiamba, “Jesu mwana wa Daudi, nionera mbazi!” ");
INSERT INTO nyf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Na at'u anji makimudumulira makimwamba anyamale, ela ye tha akikaza kuluta mumiro akiamba, “Mwana wa Daudi, nionera mbazi!” ");
INSERT INTO nyf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu akiima akiamba, “Hedu mwiheni hano.” Bai makimwiha ye kipofu makiamba, “Sikale moga uka, anakwiha.” ");
INSERT INTO nyf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Akiritsuha ro ambare, akiuka haraka, akimwendera Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu akimuza akiamba, “Vidze unamala nikuhendereni?” Ye kipofu akidzigidzya akiamba, “Bwana, namala nione!” ");
INSERT INTO nyf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu akimwamba, “Enda, kuluhiroro ridzakuhoza.” Na haho henye, akikwacha kuona na akimuthuwa Jesu mo ngirani. ");
INSERT INTO nyf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na marihokala hehi na Jerusalemu makiona kwa kure Beth'ifage na Beth'ania, kahi za Murima wa Mizeituni, ndo akiahuma anafundzie airi ");
INSERT INTO nyf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","akiambira, “Endani hatha mwangire ko kadzidzi mudzikoerekezana nako. Mukikala munangira thu, mundaona mwana wa ndzowe ariye k'adzapandwa ni mut'u adzafungwa. Muvuguleni mumurehe. ");
INSERT INTO nyf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mut'u yoyosi akimuza, ‘Kwanoni munahendazho?’ mwambeni, ‘Bwana ana haja naye, na andamudzya kare.’ ” ");
INSERT INTO nyf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kwa vizho machenda na machendaona mwana wa ndzowe adzafungwa ndze ya mulomo wa nyumba ho ngirani. Makimuvugula. ");
INSERT INTO nyf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","O at'u mariokala haho makiauza makiamba, “Mbona munamuvugula ye mwana wa ndzowe kaheri?” ");
INSERT INTO nyf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","O anafundzie makiambira zho arizhokala adzaalagiza Jesu, na o at'u makiarichira machenda. ");
INSERT INTO nyf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bai machenda naye ye mwana wa ndzowe hatha kwa Jesu, makihandika maamba gao mongoni mwakwe na Jesu akikelesi dzuluze. ");
INSERT INTO nyf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","At'u anji makihandika maamba gao mo ngirani, angine o makitandaza viv̱ungo marizhovitosa mo mindani. ");
INSERT INTO nyf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na at'u mariokala ma mbere, na ao mariokala nyuma zao mapiga k'ululu makiamba, “Hosana! Naalikwe iye adzaye kwa dzina ra Bwana! ");
INSERT INTO nyf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nauhaswe wo uthawali udzawo wa mukare wehu Daudi. Hosana kwakwe iye ariye dzulu!” ");
INSERT INTO nyf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Bai Jesu achangira Jerusalemu na achenda kahi za ro Hekalu, akimulolat'o sana mo ndani, ela kwa kukala dzuwa were rinenda kutswani, akihambola haho na achenda Beth'ania hamwenga na o anafundzie kumi na airi. ");
INSERT INTO nyf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Siku ya hiriye, marihokala madzaombola Beth'ania, Jesu akisikira ndzala mo ngirani. ");
INSERT INTO nyf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kwa kure akiona mutini uriwokala u gi makodza. Bai achendalola chamba andapata matunda. Ela arihoufikira akiwona u gi makodza mahuhu, kwani gere si makathige ga kuzhala matunda. ");
INSERT INTO nyf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesu akiulani wo muhi akiamba, “K'undazhala matunda kaheri.” Na o anafundzie makisikira zho arizhonena. ");
INSERT INTO nyf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Marihofika Jerusalemu, Jesu achangira ndani za ro Hekalu, akikwatya kuainga aryahu mariokala makiguza na kugula muryahu Hekaluni. Kidza akihala zo meza za abandi a p'esa, na vihi zha aguzi a magiya, akivipetula-petula zhosi, ");
INSERT INTO nyf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","k'amuruhusire mut'u hatha mumwenga kutsukula kit'u chochosi kukirira wo muhala wa ro Hekalu. ");
INSERT INTO nyf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Gonya akikwatya kuafundisha akiamba, “Zhaorwa kukala, ‘Nyumba yangu indaifwa nyumba ya mavoyo kwa at'u osi!’ Ela ninwi mudzaihendya p'anga ya kuzama aivi.” ");
INSERT INTO nyf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bai o alombi abomu na alimu a Sheria makivisikira na makikwatya kumala ngira ya kumwalagira, kwani mamwagoha kwa kukala kundi rosi ra at'u rere rinangalazwa ni mafundishoge. ");
INSERT INTO nyf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kurihokala kunatswa Jesu na anafundzie makiwombola wo mudzi wa Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Madzach'age marihokala manakira ngira iryahu ya dzana, makiwona uryahu mutini, nao were udzanyala kula ko kirereni hatha ko koloni. ");
INSERT INTO nyf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kuona vivi P'et'ero akikumbukira, na akimwambira Jesu, “Mwalimu, lola bewe wo mutini uriwoulani udzanyala.” ");
INSERT INTO nyf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu akiadzigidzya akiamba, “Kalani na kuluhiro kwa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Namwambira ujeri, mut'u andewambira murima uu, ‘Ng'oka na ukagwe baharini,’ na kala k'andaamba, ‘Ela vindakala?’ moyoni mwakwe, ela akuluhire kukala zho adzizhoamba vindakala, be andahenderwa jeri. ");
INSERT INTO nyf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kwa vizho namwambira, kila mundichokivoya, kuluhirani kukala mudzakihokera, nanwi mundakipata. ");
INSERT INTO nyf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nanwi kila muimaho kuvoya, na kumbe muna neno na mut'u, musameheni, kwamba na Babiyenu ariye mulunguni apate kumusamehe makosa genu.  ");
INSERT INTO nyf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ela musihosamehe, ye Babiyenu ariye mulunguni naye k'andamusamehe makosa genu.” ");
INSERT INTO nyf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bai makifika Jerusalemu kaheri. Na Jesu arihokala anatsembera kahi za ro Hekalu, o alombi abomu, na alimu a Sheria na athumia makimwendera. ");
INSERT INTO nyf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Makimuza makiamba, “Unahenda maut'u gano kwa wadimi wani? Hedu ni h'ani ariyekup'a wadimi wa kugahenda?” ");
INSERT INTO nyf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu akiambira, “Nindamuza swali. Mukinidzigidzya, nindamwambira ni wadimi wani nihenderao maut'u gaga. ");
INSERT INTO nyf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Vidze wo wadimi ariohumira Johana Mubat'izaji kubat'izira at'u, wala kwa Mulungu hedu wala kwa anadamu? Nidzigidzyani.” ");
INSERT INTO nyf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","O alombi abomu na o athumia makiojana makiamba, “Fukiamba wala kwa Mulungu, andafuza, ‘Kwanoni k'amumukuluhirire?’ ");
INSERT INTO nyf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na hukiamba, ‘Wala kwa anadamu,’ be fu hatharini, kwani at'u osi mandahutsukirirwa.” (Manena vivi kwa kukala were ni aoga na at'u, kwa kukala o at'u osi mamona Johana kukala ni nabii jeri.) ");
INSERT INTO nyf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kwa vizho makimwamba Jesu, “K'ahumanya.” Jesu naye akiamba, “Hatha mimi nami sindamwambira wo wadimi nihumirao kuhendera maut'u gaga.” ");
INSERT INTO nyf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Gonya Jesu akikwatya kunena nao na mafumbo akiamba, “Kwere kuna mut'u mumwenga ariyerima mundawe akiulaya mizabibu, akiudengelezera wiyo, akitsimba wina wa kukamulira zabibu, kidza akiaka uringo wa kurindira. Kugonya vizho, wo munda akiukodishira ak'urima, ye mwenye achenda ts'i nyingine. ");
INSERT INTO nyf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Makathi ga mavuno garihofika akihuma muhumikiwe ende kwa aryahu ak'urima, akagerwe fungu ra zo zabibu. ");
INSERT INTO nyf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ye muhumiki arihofika, o ak'urima makimuhala makimupiga, gonya makimuja kihuhu. ");
INSERT INTO nyf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kuona vizho, ye mut'u akihuma muhumiki mungine. Iye naye makimwangiza ranga ra kitswa na makimuhendera makuruhu. ");
INSERT INTO nyf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akihuma mungine, na o ak'urima makihenda kumwalaga kamare, na angine anji mariohumwa mapigwa na angine makilagwa. ");
INSERT INTO nyf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Vikara ariyekala asere wa kumuhuma were ni mumwenga thu. Naye were ni mwanawe mwenye amuhendzaye. Bai akimuhuma akale wa mwisho, akiamba kimoyo-moyo, ‘Bila shaka mandamuishimu.’ ");
INSERT INTO nyf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ela o ak'urima marihomona ye mwana, makiambirana, ‘Yuno be hatha se andiyeuhala ufwa uno munda? Alume nahumwalage yuyu, na uu munda undakala wehu.’ ");
INSERT INTO nyf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bai makimugwavukira makimwalaga, gonya makimwamboza ndze ya wo munda. ");
INSERT INTO nyf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Vidze munaona ye mwenye munda andahendadze?” Jesu akienderera kuamba, “Ye mwenye munda andakudzaalaga o ak'urima na wo munda aap'e at'u angine. ");
INSERT INTO nyf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Vidze k'amudzagashoma gano Maoro gaambago, ‘Ro iwe ririrokahalwa ni aaki vivi be ridzagaluka ndo iwe bomu ra p'embeni. ");
INSERT INTO nyf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ut'u uwo wahendwa ni Bwana, Na fukiulola unafwangalaza?’ ” ");
INSERT INTO nyf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Marihosikira vizho o athumia a Kiyahudi makijeza kumugwira Jesu, kwani mamanya kukala ro fumbo ridzanenwa kwao ao, ela makigoha wo muthunganano wa o at'u. Kwa vizho makimuricha makihauka. ");
INSERT INTO nyf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ndo gonya makiahuma angine kahi za o Mafarisayo na at'u a Herode, mende makamuhege na maswali. ");
INSERT INTO nyf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hatha marihofika makimwamba, “Mwalimu, hunamanya kukala uwe u mujeri. K'ugoha mut'u yoyosi hatha kala ana cheo chani, mana k'ulola at'u kwa uso. Unafundisha ngira ya Mulungu jeri. Bai fwambire. Kuriha kodi kwa Kaisari ni karakara hedu si karakara?” ");
INSERT INTO nyf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesu akikumanya kare ko kudzihendya kwao, akiamba, “Kwanoni munanijeza? Nip'ani yo p'esa hedu niilole.” ");
INSERT INTO nyf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bai makiireha na makimup'a Jesu. Na Jesu akiuza akiamba, “Ino sura iriyo hano na ro dzina ni zha h'ani?” Makiamba, “Ni zha Kaisari.” ");
INSERT INTO nyf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesu akiambira, “H'aya bai, zha Kaisari mup'eni Kaisari mwenye, na zha Mulungu nazho mup'eni Mulungu.” Nao machangalazwa zhomu ni zho arizhodzigidzya. ");
INSERT INTO nyf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Gonya Masadukayo ambao manaamba k'akuna kufufuka makimudzirira Jesu makiamba, ");
INSERT INTO nyf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mwalimu, Musa wafuorera kukala, mut'u akifwererwa ni nduguye, na akisiya muche ela asisiye ahoho, ye nduguye mut'u ni amuhale ufwa ili amuzhalire ahoho ye mufwadzi. ");
INSERT INTO nyf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Vikara kwere kuna ndugu afungahe, ye mukulu wao akihala muche, ela akifwa bila kuzhala naye. ");
INSERT INTO nyf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ye wa hiri akimuhala, naye akifwa bila kusiya ahoho, na wa hahu naye dzazho. ");
INSERT INTO nyf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Osi afungahe makigoma kufwa bila kusiya ahoho. Mwisho ye muche naye akiathuwa. ");
INSERT INTO nyf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Vidze makathi at'u mandihofufuka, andakala mukaza h'ani? Kwani o ndugu osi afungahe mamuhala.” ");
INSERT INTO nyf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu akidzigidzya akiamba, “Ndo sababu munahenda makosa, kwa kukala k'amumanya Maoro, kidza k'amumanya nguvu za Mulungu zirizho. ");
INSERT INTO nyf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kwani wakathi at'u mandihofufuka kundakala k'akuna kuhala hedu kuhalwa, kwani mandakala here malaika a mulunguni. ");
INSERT INTO nyf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bai dzulu za at'u kufufuka, naamba, k'amudzashoma kahi za chuwo cha Musa dzulu za kitsakuzi kirichokala kinaaka na viryahu Mulungu arizhonena na Musa akiamba, ‘Ndimi Mulungu wa Burahemu, na Isaka, na Jakobu’? ");
INSERT INTO nyf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Vivi vinanyesa kukala Mulungu ni Mulungu wa at'u mario moyo si wa at'u mariofwa. Ninwi Masadukayo munakosa sana.” ");
INSERT INTO nyf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bai mumwenga wa aryahu a alimu a Sheria were a haho na akisikira zho marizho were manauza-uza na akimanya kamare kukala Jesu adzadzigidzyat'o. Kwa vizho naye akimuza rakwe akiamba, “Amuri ya kwandza ya zosi ni hiyo?” ");
INSERT INTO nyf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu akimudzigidzya akiamba, “Bomu ni ii iambayo, ‘Sirikizani h'enwi Aiziraeli, Bwana wehu Mulungu ni mumwenga na nde Bwana h'akeye. ");
INSERT INTO nyf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Muhendze Bwana Mulunguo na moyowo wosi, na rohoro rosi, na akilizo zosi, na nguvuzo zosi.’ ");
INSERT INTO nyf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Amuri ya hiri ni ii, ‘Muhendze mwandziyo here udzihendzazho mwenye.’ K'akuna amuri bomu kukira zizi mbiri.” ");
INSERT INTO nyf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ye mwalimu wa Sheria akimwamba, “Udzadzigidzyat'o mwalimu. U mujeri here udzizhoamba kwamba Mulungu ni mumwenga na k'akuna mungine hasihokala iye. ");
INSERT INTO nyf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na mut'u ni amuhendze na moyowe wosi na akilize zosi na nguvuze zosi na aahendze andziye dza zho adzihendzazho mwenye. Kugwira malagizo gaga kudzakira kumboza sadaka za kuocha na nyingine-nyingine.” ");
INSERT INTO nyf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesu arihomona kukala ye mwalimu wa Sheria adzadzigidzyat'o kilachu, akimwamba, “Uwe k'ukure na uthawali wa Mulungu.” Bada ya gago k'ahakalireho na mut'u ariyedzisikira amuze swali. ");
INSERT INTO nyf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Badaye Jesu arihokala anafundisha kahi za ro Hekalu, waauza swali o at'u akiamba, “Alimu a Sheria manadimadze kuamba kukala ye Masihi ni Mwana wa Daudi? ");
INSERT INTO nyf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi mwenye kahi za nguvu za Roho Mweri waamba, ‘Bwana Mulungu wamwamba Bwana wangu, “Kelesi mukono wangu wa kurya, muhaka mahadhuio niathambaraze kamare ts'ini za magulugo.” ’ ");
INSERT INTO nyf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Vikikala Daudi mwenye amwiha ‘Bwana,’ anadimadze kukala mwanawe?” Bai wo muthunganano mubomu ukimusirikiza na raha zhomu. ");
INSERT INTO nyf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesu arihokala anafundisha waamba, “Dzimanyirireni na alimu a Sheria mahendzao kutsembera kuno madzavala miguwo mire kwamba malamuswe kwa ishima mo masokoni, ");
INSERT INTO nyf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","na kidza manahendza kugerwa vihi zha mbere kahi za masinagogi na kahi za sherehe. ");
INSERT INTO nyf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kidza ao nikuahoka ache magungu vit'u zhao, na kudzihendesha kukala ni adzo kwa kuvoya mavoyo mare-mare. Adhabu yao indakala k'ali zaidhi.” ");
INSERT INTO nyf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Gonya Jesu achenda kahi za ro Hekalu na achendakelesi hehi na cho kiya cha kwangizira sadaka na akilolera viryahu at'u magwagazho p'esa. Vikara akiona mashaha managwaga nyinji-nyinji. ");
INSERT INTO nyf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na hakidza mwanamuche ariye were ni gungu kidza mukiya na akigwaga vipeni viri. ");
INSERT INTO nyf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesu akiaiha hamwenga o anafundzie na akiambira, “Namwambira ujeri, yuyu mwanamuche gungu adzagwaga nyinji kukira osi. ");
INSERT INTO nyf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mana o angine madzamboza kafungu thu ka wo ushaha mario nao, ela yuno ye, ni masikini nyasi, ela adzagwaga zhosi arizho nazho. Adzamboza zhosi arizho were angaishira.” ");
INSERT INTO nyf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bai arihokala anambola kula kahi za ro Hekalu, hakimbola mumwenga wa o anafundzie akiamba, “Mwalimu, lola zho garizho madzo go mawe ga ro Hekalu! Lola wo mujengo nawo!” ");
INSERT INTO nyf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu akidzigidzya akiamba, “Munagaona gano majengo mabomu gosi? Be namwambira ujeri wenye k'ahana iwe hatha mwenga rindirosala dzulu za mwandziwe, kila kit'u kinadzabandwa-bandwa.” ");
INSERT INTO nyf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bai Jesu arihombola haho wakwendakelesi kahi za Murima wa Mizeituni uriwo unalolana na ro Hekalu, hakidza P'et'ero, Jakobu, Johana na Anderea, makimuza kinjama makiamba, ");
INSERT INTO nyf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Maut'u gano gandahendeka rini? Vidze ni muv̱ano wani undiwonyesa kukala makathi gadzafika ga maut'u gaga kuhendeka?” ");
INSERT INTO nyf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu akiambira, “Dzimanyirireni hasidze mut'u akamukenga. ");
INSERT INTO nyf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kwani at'u anji mandakudza kwa dzina rangu, na mandadziamba kukala ao ndo ye Masihi na mandakenga at'u anji. ");
INSERT INTO nyf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na mundasikira uv̱oro wa viha vihefwazho hehi na vingine mundahenda kuvisikira uvumi, ela sogoheni, kwani ni hatha gakale gago, ela wo mwisho wa urumwengu undakala uchere mbere. ");
INSERT INTO nyf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kabila rindauka kwendapigana na kabila ringine. Uthawali undapigana na uthawali mungine. Ts'i indathethema hat'u-hat'u na kundakala na ndzala. Ela gago gosi gandakala ni mwandzo wa utsungu thu. ");
INSERT INTO nyf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nanwi dzimanyirireni kwani at'u mandamugwira mamuhirike manenoni. Mandamupiga kahi za masinagogi na mundaima mbere za maluwali na athawali kwa ut'u wa dzina rangu, na mwamboze ushahidhi mbere zao. ");
INSERT INTO nyf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nawo Uv̱oro Udzo suthi kwandza wambirizwe at'u osi a kila samupuli kabila wo mwisho k'audzafika. ");
INSERT INTO nyf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na mandihomugwira kwenda nanwi manenoni, musikale na wasiwasi dzulu za zho mundizhoadzigidzya, ela nenani gago mundigogerwa. Kwa kukala gago mundigoadzigidzya gandakala si genu, ela ni ga Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Mut'u andamulazha nduguye mwenye hedu mwanawe mwenye alagwe. Ana nao mandaagalukira azhazi ao enye, maalazhe malagwe. ");
INSERT INTO nyf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nanwi mundamenwa ni at'u osi kwa ut'u wa dzina rangu. Ela andiyevumirira hatha mwisho andaokoka. ");
INSERT INTO nyf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mundaona kit'u cha kutsukiza na cha kwanonga kiimire hat'u ambaho k'akiv̱irya kuima. (H'ewe mushomi, shomat'o ung'alirwe.) Bai mundihoona vizho, at'u osi mandiokala Judea namachimbirire ko mirimani. ");
INSERT INTO nyf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mut'u andiyekala a dzulu za nyumba ya kwakwe asiuye mo nyumbani kwendahala kit'u chochosi. ");
INSERT INTO nyf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mut'u andiyekala a mundani asiuye mudzini kwendahala valore. ");
INSERT INTO nyf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wakathi uwo vindakala vii-vii zaidhi kwa ano m'ama mandiokala mana mimba na mandiokala manaamwisa. ");
INSERT INTO nyf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bai voyani kwamba gaga gasihendeke makathi ga p'eho. ");
INSERT INTO nyf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwani wakathi uwo kundakala na mateso mabomu garigo k'agadzaonewa hangu Mulungu aumbe urumwengu na k'agandaonewa kaheri haha urumwenguni. ");
INSERT INTO nyf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Siku zizo za mateso Bwana wazihunguza kwa ut'u wa at'u arioatsagula, ela kala si vizho k'ahana hatha mut'u mumwenga angayeokoka. ");
INSERT INTO nyf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Bai makathi gago mut'u akimwamba, ‘Lola thiyuno ye Masihi!’ hedu, ‘Thiyuya kurya,’ sikuluhireni bule. ");
INSERT INTO nyf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mana kundambola ano Masihi anji a ulongo, na manabii anji a ulongo. At'u ao osi mandahenda miv̱ano na maajabu ili vichadimikika maakenge hatha o at'u mariotsagulwa ni Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bai ninwi kalani matso, nidzamwambira maut'u gaga kimbere.” ");
INSERT INTO nyf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Siku zizo bada ya mateso garyahu kukira, dzuwa rindangira kiza, na mwezi k'aundaala kaheri. ");
INSERT INTO nyf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nyenyezi zindagwa ts'i na nguvu za dzulu mulunguni zindathukuswa. ");
INSERT INTO nyf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ndo mandihomona Mwana wa Mudamu akudzani kahi za maingu, hamwenga na nguvu nyinji na nguma. ");
INSERT INTO nyf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Naye andaahuma malaikae maakundzumanye o at'u osi mariotsagulwa ni Mulungu kula kila p'embe ya dhunia. ");
INSERT INTO nyf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Bai dzifundisheni kula kwa mutini. Mutini t'aize zikikala nyolovu na kukwatya kumboza makodza munamanya kare wakathi wa mavuno udzafika hehi. ");
INSERT INTO nyf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kwa vizho ninwi nanwi mukiona maut'u gaga gosi, manyani kukala wakathi wa kudza Mwana wa Mudamu udzafika hehi. ");
INSERT INTO nyf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nami namwambira kamare, kizhazi kiki k'akindakira kabila maut'u gaga gosi kuthimira. ");
INSERT INTO nyf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mulunguni na ts'i, vindahenda mwisho, ela maneno gangu k'agana mwisho bule! ");
INSERT INTO nyf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Na k'ahana mut'u amanyaye ni siku yani hedu saa yani gandihokalira maut'u gaga, hatha o malaika na ye Mwana wa Mudamu k'amaimanya bule, Baba h'akeye nde aimanyaye. ");
INSERT INTO nyf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kwa vizho musilale, kalani thayari wakathi wosi, mana k'amumanya maut'u gaga gandakala rini. ");
INSERT INTO nyf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Vindakala ni here mut'u aukaye charo cha kure, ariyehala nyumbaye akiarichira ahumikie mamutsundzire. Kidza kila mumwenga akimup'a kaziye ya kuhenda, gonya akimulagiza ye murindzi akale matso muhaka andihouya. ");
INSERT INTO nyf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bai hatha ninwi kalani matso, mana k'amumanya andakudza rini ye bwana mwenye nyumba. Anadima akadza na dziloni, hedu usiku ukulu hedu akadza jogolo rinaika hedu hatha akadza na madzach'a. ");
INSERT INTO nyf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bai akihenda poo hasiho kukala na mbadha naye, asidzemudulukiza murere. ");
INSERT INTO nyf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gaga namwambira ninwi na hatha at'u osi. Kalani matso.” ");
INSERT INTO nyf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bai were zisere siku mbiri ndo iryahu sikuk'uu ya P'asaka na ya Mikahe Iso Ts'ats'u ifike, nao o alombi abomu na alimu a Sheria makikala manamala ngira ya kilachu ya kumugwirira Jesu na mamwalage. ");
INSERT INTO nyf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Makiambirana vivi, “Ut'u uu be nifusiuhende wakathi uu wa ii sikuk'uu, p'ore at'u makathinya bugwa.” ");
INSERT INTO nyf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Makathi gago Jesu were a nyumbani mwa mut'u ariyeifwa Simoni Mahana ko Beth'ania. Vikara marihokala makuryani hakidza mwanamuche kuno adzatsukula ts'azi iriyotengezwa kula kwa iwe ra alabasita ya mafuha masafi ga marashi, nago were ni ga gali sana. Ye mwanamuche akihala yo ts'azi akibanda cho kifundiroche na akimumwagira Jesu go mafuha mo kitswani. ");
INSERT INTO nyf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","At'u angine mariokala haho kudzaona vizho, k'aviafwahire bule kwani maamba, “Kuno be si kwanonga kuno? ");
INSERT INTO nyf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mafuha gaga kala gadzaguzwa gangambola zaidhi ya dinari magana mahahu na makagerwa masikini.” K'uzhona o at'u makikwatya kumudumulira ye mwanamuche. ");
INSERT INTO nyf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ela Jesu arihoona vizho akiakanya akiamba, “Muricheni ye mwanamuche, mbona munamubudzya? Iye adzanihendera kit'u kidzo. ");
INSERT INTO nyf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Masikini munao siku zosini. Bai kila muhendzaho munadima kuahendera zho muhendzazho, ela mimi bai k'amundakala nami siku zosini bule. ");
INSERT INTO nyf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Adzahenda here adzizhodima, kwani adzahenda vizho anithayarishe kwa kuzikwa kwangu. ");
INSERT INTO nyf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nami namwambira ujeri kukala, zho adzizhohenda mwanamuche yuyu vivi rero, be vindathalwa na kukumbukirwa kila undihohubiriwa wo Uv̱oro Udzo kahi za urumwengu muzima.” ");
INSERT INTO nyf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ndo Juda Isikariote, mumwenga wa aryahu anafundzi kumi na airi a Jesu akiuka na achendaambira o alombi abomu viryahu mangazhodima kumugwira Jesu kirahisi. ");
INSERT INTO nyf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na o alombi abomu marihosikira vivi makifwahirwa sana na makilagana naye kumup'a p'esa. Kwa vizho Juda Isikariote akiandza kumala nafasi mbidzo ya kumusalitira Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bai siku ya kwandza ya sikuk'uu ya Mikahe Iso Ts'ats'u, ambayo ndo siku ya kutsindza ng'ondzi za sikuk'uu ya P'asaka, o anafundzi mamuza Jesu makiamba, “P'asaka ino undairyahi, fukakuthayarishire?” ");
INSERT INTO nyf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Arihosikira vizho Jesu akiahuma anafundzie airi akialagiza akiamba, “Endani hatha mumo mudzini nanwi mundathungana mwanamulume adzatsukula muthanga wa madzi. Vikara mundihomona, muthuweni nyuma ");
INSERT INTO nyf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","muhaka yo nyumba andiyongira. Muchangira mwambeni ye mwenye nyumba vivi, ‘Mwalimu adzaamba, cho chumba cha ajeni ambacho iye na anafundzie mandarya sikuk'uu ya P'asaka ni hicho?’ ");
INSERT INTO nyf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Andihosikira vizho andamwanyesa chumba kibomu cha gorofani kiricho kina kila kit'u. Bai mukichona kwatyani kupanga-panga mumo.” ");
INSERT INTO nyf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kwa vizho o anafundzi airi machenda mo mudzini na makiona vizho arizho were Jesu adzaamba zhenye. Ndo makipanga-panga kwa ut'u wa yo sikuk'uu ya P'asaka. ");
INSERT INTO nyf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na kurihokala kudzakala dziloni, Jesu achenda mo mudzini hamwenga na o anafundzie kumi na airi. ");
INSERT INTO nyf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Marihokala madzakelesi na makuryani, Jesu akiamba, “Namwambira ujeri, mumwenga wenu ariye tha hunarya naye haha, andanisaliti.” ");
INSERT INTO nyf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kusikira vizho o anafundzi makidzalwa ni kigondzi na makiuza mumwenga-mumwenga makiamba, “Vidze, ni mimi mwalimu?” ");
INSERT INTO nyf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesu akiambira, “Iye ni mumwenga wa ninwi kumi na airi, iye atsotsaye muvureni hamwenga nami. ");
INSERT INTO nyf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ni jeri Mwana wa Mudamu anenda kare kamwe here Maoro gaambazho, ela shauriye iye mut'u amusalitiye! Vingakala baha kala k'azhalirwe.” ");
INSERT INTO nyf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Vikara marihokala makuryani, Jesu wahala mukahe akimboza muv̱era kwa Mulungu, gonya akiumogola-mogola akiap'a o anafundzie, akiamba, “Halani, uu ndo mwiri wangu.” ");
INSERT INTO nyf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Arihogonya kuap'a wo mukahe, akihala cho kikombe cha divai akimboza muv̱era kwa Mulungu, gonya akiap'a makinwa osini. ");
INSERT INTO nyf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Akiambira, “Ii ndo milatso yangu imwagikayo kwa ut'u wa at'u anji na inanyesa kilagane kisha kahi za Mulungu na mudamu. ");
INSERT INTO nyf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nami namwambira ujeri, sindanwa divai ii kaheri muhaka siku iyo nindihonwa divai mbisha kahi za uthawali wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Gonya makiimba na makiuka kwenda Murima wa Mizeituni. ");
INSERT INTO nyf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu akiambira anafundzie akiamba, “Usiku wa rero ninwi nyosi mundaniricha h'akiyangu. Kwani Maoro ganaamba, ‘Nindamupiga ye murisa na zo ng'ondzi zosi zindatsamukana.’ ");
INSERT INTO nyf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ela haho nikikala nidzafufulwa, nindamuthangulia kwenda Galilaya.” ");
INSERT INTO nyf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","P'et'ero akimwamba, “Hatha kala osi mandakuricha, mimi sindakuricha ng'o!” ");
INSERT INTO nyf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu akimwambira P'et'ero, “Simoni nakwambira ujeri, usiku wa rero kabila jogolo k'aridzaika k'ana mbiri, undanikana k'ana t'ahu.” ");
INSERT INTO nyf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","P'et'ero arihosikira vizho akinena kwa nguvu akiamba, “Hatha kala ni kufwa nanifwe, ela sindakukana ng'o!” Na o anafundzi angine nao makinena dza vizho. ");
INSERT INTO nyf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gonya Jesu na anafundzie machenda hat'u haifwaho Geth'isemane. Marihofika haho, akiambira o anafundzie akiamba, “Kelesini haha nami ninavoya haryahu.” ");
INSERT INTO nyf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Akimuhala P'et'ero, Jakobu na Johana achenda nao. Wakathi uwo washononeka zhomu na kubudzyika moyo. ");
INSERT INTO nyf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Akiambira o ahahu akiamba, “Ninashononeka zhomu moyoni mwangu hatha ni here nindiyefwa. Bai kalani haha muchese.” ");
INSERT INTO nyf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Gonya Jesu akiaricha o ano P'et'ero haho, ye akisongera mbere vichache. Achendagwa na moyo akivoya kwamba vichadimikika mateso gago gakire na k'anda. ");
INSERT INTO nyf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akiamba, “Aba! Baba! K'akuna ut'u usiwodimikika kwako. Bai navoya uniusire mateso gaga, ela navikale here uhendzazho uwe, visikale here nihendzazho mimi bule.” ");
INSERT INTO nyf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Gonya akiauyira o anafundzie na achendaathekeza marere. Kuona vizho akimwamba P'et'ero, “Simoni hatha urere kamare! Yani k'udima kukala matso ngaa saa mwenga? ");
INSERT INTO nyf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chesani na muvoye sidze mukangira majezoni, kwani roho inahendza kamare, ela wo mwiri ni munyonge.” ");
INSERT INTO nyf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Gonya akiuka kaheri kwendavoya, naye wavoya mavoyo dza gago ga chaho. ");
INSERT INTO nyf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Naye arihoauyira achendaathekeza marere kaheri. K'amadimire kukala matso kwa wo uts'indzizi mariwokala nawo. Nao k'amapatire ra kumudzigidzya. ");
INSERT INTO nyf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Arihouka na kudza kaheri lwa hahu akidzaambira, “Muchere kulala na kudzioyeza? Vinathosha. Lolani wakathi wa Mwana wa Mudamu kusalitiwa kwa enye dambi udzafika. ");
INSERT INTO nyf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","H'aya ukani fwende. Siyu kare iye anisalitiye!” ");
INSERT INTO nyf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bai arihokala achere kunena, poo, Juda mumwenga wa o anafundzi kumi na airi na kundi bomu ra at'u. Angine were madzatsukula mishu na angine were madzatsukula njogoma. At'u aa were mala kwa alombi abomu, na alimu a Sheria na athumia a Kiyahudi. ");
INSERT INTO nyf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bai ye musaliti were adzaap'a muv̱ano kukala, “Ye nindiyemudonera nde mumumalaye, mugwireni na mwende naye ts'ini za urindzi mukali.” ");
INSERT INTO nyf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bai arihokudza achenda mara mwenga na akiamba, “Mwalimu,” gonya akimudonera. ");
INSERT INTO nyf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kudzaona vizho o at'u makimwangiza magandzani Jesu. ");
INSERT INTO nyf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na mumwenga wa aryahu mariokala maimire haho, akitsolola mushuwe na akimuthema muhumiki wa ye Mulombi mubomu mwenye akimutosa sikiro. ");
INSERT INTO nyf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu akiauza o at'u akiamba, “Mbona mudzambola na mishu na njogoma kudzanigwira dza here mudzaogwira jambazi? ");
INSERT INTO nyf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kila siku nidzakala nikiima mbere yenu kahi za ro Hekalu kufundisha na k'amunigwirire? Ela gaga ganakala kwamba Maoro gathimire.” ");
INSERT INTO nyf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bai o anafundzie osi makimuricha makichimbira. ");
INSERT INTO nyf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Vikara hakikala hana muvulana mumwenga ariyekala adzadzikut'a shuka ya kitani naye wakala anamala kumuthuwa Jesu, o at'u makijeza kumugwira naye, ");
INSERT INTO nyf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ela akidziv̱itha, akiitsulusiza yo shuka ya kitani akichimbira huhu. ");
INSERT INTO nyf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bai makimuthongozha Jesu hatha ko kwa Mulombi mubomu mwenye, kuriko were ndo kudzikokundzumanyika o alombi abomu, alimu a Sheria, na athumia angine a Kiyahudi. ");
INSERT INTO nyf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Naye P'et'ero akimuthuwa nyuma kwa kure hatha haryahu muhalani ha ye Mulombi mubomu mwenye, bai akikelesi hamwenga na o arindzi a ye Mulombi mubomu mwenye na akikwatya kuoha moho. ");
INSERT INTO nyf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","O alombi abomu na ro Baraza rosi ra athumia, mamala kosa ra kumwalagira Jesu, ela k'amapatire bule. ");
INSERT INTO nyf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Anji mamboza ushahidhi wa ulongo, ela hatha vizho wo ushahidhi wao k'augwiranire kamare. ");
INSERT INTO nyf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Angine maungarara makimboza ushahidhi wa ulongo dzulu za Jesu makiamba, ");
INSERT INTO nyf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Famusikira anaamba vivi, ‘Nindaribanda-banda riri Hekalu ririroakwa ni at'u, nami nindaaka ringine risiroakwa ni at'u kwa siku t'ahu thu.’ ” ");
INSERT INTO nyf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hatha wo ushahidhi uwo nawo k'augwiranire bule. ");
INSERT INTO nyf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ndo ye Mulombi mubomu mwenye akirungarara mbere za ro Baraza ra athumia na akimuza Jesu akiamba, “Mbona k'udzigidzya kit'u. Zho manenazho ano at'u ni jeri?” ");
INSERT INTO nyf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ela Jesu akinyamala zii, k'adzigidzyire kit'u. Ye Mulombi mubomu mwenye akimuza kaheri, akiamba, “We ndiwe ye Masihi Mwana wa Mulungu?” ");
INSERT INTO nyf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu akidzigidzya akiamba, “Ee ndimi. Nanwi mundamona Mwana wa Mudamu akelesi mukono wa kurya wa Mulungu mwenye nguvu, na anadza kuno a dzulu za maingu ga ko dzulu.” ");
INSERT INTO nyf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kusikira vizho ye Mulombi mubomu mwenye akitharura nguwoze kwa kutsukirwa, akiamba, “Vino funa haja ya mashahidhi angine? ");
INSERT INTO nyf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nyosi mudzasikira zho amukufuruzho Mulungu. Vidze munaona baha humuhendedze be vino?” Na osi makikira luhande lumwenga lwa kuamba anav̱irya alagwe. ");
INSERT INTO nyf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Angine o hatha makikwatya kumutsuhira mahe na makimufunga kizuzu, makimupiga makonde kuno manamwamba, “H'aya nena ni h'ani ye adziyekupiga?” Na o shikari makimuhala na makimupiga mahi. ");
INSERT INTO nyf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","P'et'ero were achere ko muhalani kwa ye Mulombi mubomu mwenye, hakidza muhendzi wa kazi wa kiche wa ye Mulombi mubomu. ");
INSERT INTO nyf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bai arihomona P'et'ero anaoha moho, wamulolat'o gonya akimwamba, “Uwe nawe udzakala u hamwenga na Jesu wa Nazareth'i?” ");
INSERT INTO nyf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","P'et'ero akikanaiza akiamba, “Simumanya, kwandza hatha go unenago k'aganing'alira.” Naye tw'ee achambola ko ndze ko muv̱iryani, na jogolo rikihenda hee. ");
INSERT INTO nyf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ye musichana akimona haho naho na akikwatya kuambira ao mariokala maimire haho, akiamba, “Yuyu naye ni mumwenga waho.” ");
INSERT INTO nyf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","P'et'ero akiakanaiza kaheri, ela k'avitoere ao mariokala haho makimwamba P'et'ero, “Uwe be u mumwenga waho kamare, kwandza hatha kwenu ni Galilaya t'i.” ");
INSERT INTO nyf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ndo P'et'ero akiandza kulani na kuapa, akiamba, “Hachi ya Mulungu kamare yuyu mut'u mumuhadzaye be simumanya.” ");
INSERT INTO nyf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Haho henye jogolo rikiika lwa hiri na P'et'ero akikumbukira zho Jesu arizhokala adzamwambira kukala, “Kabila jogolo k'aridzaika k'ana mbiri, undanikana k'ana t'ahu.” P'et'ero arihoririkana vizho akiandza kurira kare kwa utsungu. ");
INSERT INTO nyf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Vikara kurihocha na madzach'a maitsi genye, o alombi abomu, alimu a Sheria, athumia a Kiyahudi hamwenga na baraza rosi, mahenda mipango yao. Bai makimuhala, makimufunga na makimuhirika kwa P'ilato ariye were nde luwali wa jimbo riro. ");
INSERT INTO nyf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Marihofika kuko P'ilato akimuza Jesu akiamba, “Vidze we ndiwe muthawali wa Ayahudi?” Jesu akimudzigidzya akimwamba, “Uwe udzanena.” ");
INSERT INTO nyf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","O alombi abomu makimusingizira maut'u manji gasigofwaha. Ela iye Jesu mwenye tha k'ajibire kit'u, wanyamala zii. ");
INSERT INTO nyf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ye P'ilato akimuza kaheri akiamba, “Udzagasikira go maut'u manji madzigokushithakira?” ");
INSERT INTO nyf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Na here ho chaho Jesu akithuwa kumunyamalira. Vivi vikimumasha P'ilato. ");
INSERT INTO nyf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bai here adha ra P'ilato were kila makathi ga sikuk'uu ya P'asaka ni kuavugulira mufungwa mumwenga mandiyemutsagula enye. ");
INSERT INTO nyf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Vikara kwereko mut'u mumwenga kifungoni ariyeifwa Baraba. Iye na andziye mere mapatikana na makosa ga kugwaga rabusha na kwalaga kwa ut'u wa kukahala uthawali wa Kirumi. ");
INSERT INTO nyf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ndo at'u marihokala madzadzala ndii ho ha P'ilato, makikwatya kumwambira ye P'ilato aahendere here aahenderazho siku zosi. ");
INSERT INTO nyf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bai P'ilato akiauza akiamba, “Vidze munahendza nimuvugulire yuno muthawali wa Ayahudi?” ");
INSERT INTO nyf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kwani P'ilato wamanya kukala o alombi abomu madzamushithaki Jesu kwa sababu ya wivu thu. ");
INSERT INTO nyf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ela o alombi abomu makiavuga akili o at'u kwamba hat'u ha kuamba arichizwe Jesu, maambe mavugulirwe Baraba. ");
INSERT INTO nyf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","P'ilato akiauza kaheri o at'u akiamba, “Vikara yuno mumwihaye muthawali wa Ayahudi nimuhendedze?” ");
INSERT INTO nyf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","O at'u makipiga k'ululu kaheri na kuamba, “Musulubishe!” ");
INSERT INTO nyf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","P'ilato akiauza akiamba, “Kwani adzakosani kibomu?” Ela o hatha makikaza kupiga k'ululu kuamba, “Musulubishe!” ");
INSERT INTO nyf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Vikara kwa kukala P'ilato were anamala kufwahiza ro kundi ra at'u waambozera Baraba, gonya akiamuru Jesu apigwe vikotho, ndo akimulazha ende akasulubiwe. ");
INSERT INTO nyf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bai Jesu akihalwa ni shikari na machenda naye muryahu muhalani mwa nyumba ya luwali ambamo mumo ndo k'ambi ya jeshi, gonya makiaiha o andziyao osi. ");
INSERT INTO nyf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Makihala riguwo ra rangi ya zambarau makimuvika, makitengeza kiremba cha miya makimuvika kitswani. ");
INSERT INTO nyf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Gonya makikwatya kumuv̱udhya na kumulamusa makiamba, “K'una ut'u muheshimiwa muthawali wa Ayahudi!” ");
INSERT INTO nyf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kidza makimupiga kitswani na mudhath'a, makimutsuhira mahe, makidzihendesha kupiga mavindi na makizama mbereze hatha vidhangu zhao vikigut'a ts'i. ");
INSERT INTO nyf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Marihokala madzamuv̱udhya zha kuthosha, mamuvula ro riguwo ra zambarau, makimuvika zo nguwoze kaheri, makimuthongozha kwendamusulubisha. ");
INSERT INTO nyf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Marihokala makwendani, makimuthungana mut'u aifwaye Simoni Muk'irene ala mashambani, naye makimulazimisha autsukule wo musalaba wa Jesu. Yuyu Simoni nde babaye Alekizanda na Rufo. ");
INSERT INTO nyf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","H'aya ndoo vivi hatha makimufisha Jesu hat'u haifwaho Gologoth'a, ambaho manaye ni Ribeshe ra Kitswa. ");
INSERT INTO nyf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na haho bai makimup'a divai ya kutsanganywa na manemane anwe, ela Jesu akiikahala. ");
INSERT INTO nyf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Marihogonya kumusulubisha, mahala zo nguwoze makizigazha kwa kuhenda kuzipigira k'ura maone ni h'ani andahala hiyo. ");
INSERT INTO nyf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wakathi manamusulubisha were ni saa t'ahu za madzach'a. ");
INSERT INTO nyf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ho dzulu za wo musalaba makihala kibao makindhika ro kosa mariromushithakira: Muthawali Wa Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na kidza makiasulubisha aivi airi hamwenga na Jesu, mumwenga mukono wa kurya, na mungine mukono wa kumots'o.  ");
INSERT INTO nyf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kahi za ngira ii go Maoro gakithimira garigoamba, “Wathalwa jao mwenga na enye dambi.” ");
INSERT INTO nyf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bai o at'u mariokira na haho arihosulubiwa Jesu, mamusholera, makithukusa vitswa zhao kikav̱udhye, makiamba, “H'aya, kw'aamba undaribanda ro Hekalu na uriake kwa siku t'ahu vino? ");
INSERT INTO nyf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","H'aya dziokole mwenye be vivi. Thima kula ho musalabani.” ");
INSERT INTO nyf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na o alombi abomu na alimu a Sheria nao makimusholera dza vizho zha akizi a ngira. Makiamba, “Waokola at'u angine, ela vino k'adima kudzakola mwenye. ");
INSERT INTO nyf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Vikara nahulole chamba ye Masihi muthawali wa Iziraeli, andathima kula ho musalabani. Akithima fundaona na fundamuamini.” Na o at'u airi mariosulubiwa hamwenga naye kidza nao mamusholera dza vizho zha o angine. ");
INSERT INTO nyf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Bai bada ya Jesu kusulubiwa, ts'i yosi yagit'ana kiza kuandzira saa sitha muhadhi saa chenda. ");
INSERT INTO nyf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Inafika saa chenda, Jesu akirira na sauthi bomu akiamba, “Eloi Eloi, lama sabakithani?” Ambazho manaye ni kuamba, “Mulungu wangu, Mulungu wangu, mbona udzaniricha?” ");
INSERT INTO nyf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kusikira vizho angine kahi za ao at'u mariokala maimire haho makiamba, “Sirikizani, anamwiha Elija benwi!” ");
INSERT INTO nyf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ndo mumwenga wao akikot'a malo achendavwika buwa kahi za siki, akiridunga mudhath'ani akimup'a Jesu anyunye. Akiamba, “Richani hulole chamba Elija andakudzamuthinya.” ");
INSERT INTO nyf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesu akipiga k'ululu na akimarigizika. ");
INSERT INTO nyf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na yo p'azia iriyokala kahi za ro Hekalu yapashuka ikigazhika p'ande mbiri, kula dzulu hatha ts'ini. ");
INSERT INTO nyf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ye mubomu wa shikari ariyekala aimire haho hehi naye, arihoona viryahu adzizhorira na kumarigizika akiamba, “Mut'u yuyu were ni Mwana wa Mulungu jeri.” ");
INSERT INTO nyf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na haho were hana anaache manavilolera kwa kure. Kahi za ao mariokala haho were ni Maryamu Magidalena, na Maryamu mameye Jakobu muthithe na Jose, na mwanamuche mungine aifwaye Salome. ");
INSERT INTO nyf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aa na anaache angine anji makala makimuthuwa na kumuhumikira Jesu arihokala ko Galilaya, nao mambuka na Jesu muhaka ko Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Siku iyo were ni siku ya kuthayarishira Sabato. Vikara kabila dzuwa k'aridzatswa, ");
INSERT INTO nyf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","mut'u mumwenga ariyeifwa Josefu wa Arimath'ea wakwenda kwa P'ilato bila woga kwendaumala mwiri wa Jesu, akauzike. Josefu yuyu were anagofwewa ni ro Baraza rosi na kidza were anauthariza uthawali wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","P'ilato wamashwa ni zho zha kukala adzafwa kare. Kwa vizho akimwiha ye mubomu wa shikari akimuza chamba adzamarigizika kare. ");
INSERT INTO nyf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Arihoambirwa ni ye shikari kukala ni jeri adzafwa, akimuruhusu Josefu ahale wo mwiri. ");
INSERT INTO nyf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josefu akigula ts'andza ya kitani, akiuthinya na akiulinga-linga iryahu ts'andza ya kitani na achendaulaza kahi za mbira iriyohenda kutsongwa iweni. Gonya akihala iwe bomu akiripingilisa rikifinikira wo mulomo wa yo mbira. ");
INSERT INTO nyf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maryamu Magidalena na Maryamu mameye Jose mahaona ho arihozikwa. ");
INSERT INTO nyf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Vikara siku ya Sabato irihokala idzakira, Maryamu Magidalena, Salome na Maryamu mameye Jakobu machendagula mavumba kwamba makamumwagire. ");
INSERT INTO nyf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bai madzach'a maitsi siku ya kwandza ya wiki, dzuwa ririhokala ridzapashula ingu, machenda ko mbirani. ");
INSERT INTO nyf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Mo ngirani makiuzana-uzana makiamba, “Ni h'ani andehupingilisira ro iwe kula ho mulomoni ha yo mbira?” Naro be were ni iwe bomu. Marihofika na kutsuha matso makiona kumbe rere ro iwe ridzagonya kare kupingiliswa k'anda. ");
INSERT INTO nyf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bai machangira mo ndani ya mbira makiona muvulana akelesi luhande lwa mukono wa kurya na adzavala valo raruhe tse! Vikiangalaza kare. ");
INSERT INTO nyf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ela ye muvulana akiambira, “Visimwangalaze, amba munamumala Jesu wa Nazareth'i ariyesulubiwa, k'aho haha adzafufuka. Lolani, samba maulaza haha mino! ");
INSERT INTO nyf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vikara vivi uyani mukaambire o anafundzie haswa P'et'ero maneno gaga, ‘Andamuthangulia kwenda Galilaya, kuko ndiko mundikomona here arizhomwambira.’ ” ");
INSERT INTO nyf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kwa vizho machambola haraka zhomu mo mbirani kuno miri inaavina ut'u wa kwangalaza kwa wo woga. Makimbola malo genye. Ngira yosi k'amanenere na mut'u kwani woga were udzaadzala zhomu.  ");
INSERT INTO nyf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Arihokala adzafufuka yo siku ya kwandza ya wiki na madzach'a, bai kwandza kamare wamwambolera Maryamu Magidalena ariyekala wamwamboza p'ep'o afungahe ho nyuma-nyuma. ");
INSERT INTO nyf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Naye Maryamu achendaambira aryahu mariokala osi, nao were madzadzalwa ni kigondzi na were manarira. ");
INSERT INTO nyf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Marihomusikira Maryamu Magidalena anaamba Jesu a moyo hatha adzamona na dzitsore, k'amakuluhirire bule. ");
INSERT INTO nyf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kidza badaye waambolera lwazu anafundzi airi, naye umbore were ridzakala ringine. Ao mariombolerwa ni Jesu mere ma ngirani manenda mashambani. ");
INSERT INTO nyf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kuona vizho makiuya machendaambira o andziyao ela hatha vizho ao nao k'amakuluhirire. ");
INSERT INTO nyf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mwisho kamare akiambolera lwazu o anafundzi kumi na mumwenga, nao were makeresi makungizani riziki. Naye Jesu akiadumulira kwa kutsakuluhira kwao, na mioyo yao mikomu mana k'amaakuluhirire aryahu mariokala madzamona arihokala adzafufuka. ");
INSERT INTO nyf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Akiambira, “H'aya bai endani kahi za urumwengu wosi mukauhubiri Uv̱oro Udzo wa Mulungu kwa at'u a kila samupuli. ");
INSERT INTO nyf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Iye andiyekuluhira na kubat'izwa yundaokoka, na iye ariye k'andakuluhira yundahukumiwa. ");
INSERT INTO nyf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na ao makuluhirao mandagerwa miv̱ano ii ya wadimi. Kwa dzina rangu mandamboza p'ep'o na mandanena na luga nyingine. ");
INSERT INTO nyf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mandagwira nyoka na k'amandaaluma, na hatha makinwa ut'u wa kwalaga, k'amandafwa kamare, mandaaikira mikono akongo nao mandahola.” ");
INSERT INTO nyf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bai Bwana Jesu arihogonya kunena nao, akinulwa achenda dzulu mulunguni, akikelesi mukono wa kurya wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ndo o anafundzi machenda kila hat'u, kuhubiri Uv̱oro Udzo wa Mulungu, kuno Mulungu anahenda kazi hamwenga nao. Na lola ye Mulungu wahenda wo uv̱oro uonewe kukala ni wa jeri kwa kuagera wadimi wa kuhenda miujiza.");
INSERT INTO nyf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kwa muheshimiwa Th'eofilo. At'u anji majeza here madimazho kundhika garyahu maut'u ambago gahendeka kahikahi zehu. ");
INSERT INTO nyf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","At'u ao maora go hurigoambirwa ni ao mashudhia a maut'u gaga na mario pia were ni alimu a wo Uv̱oro. ");
INSERT INTO nyf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kwa vizho muheshimiwa Th'eofilo, kwa kukala mimi mwenye nami navichunguza zhosi na nikivithuwa t'ot'ot'o kula chaho, naona ni vidzo nami nikuorere t'ot'ot'o here maut'u garizhokala, ");
INSERT INTO nyf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kwamba udime kumanya ujeri wosi wa maut'u urigofundishwa. ");
INSERT INTO nyf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bai wakathi muthawali Herode anathawala Judea, kwakala na mulombi ariyekala anaifwa Zakaria. Zakaria yuyu were anambola kahi za lukolo lwa kilombi lwa Abija. Muchewe were anaifwa Elizabeth'i kidza naye were anambola kahi za lukolo lwa kilombi lwa Haruni. ");
INSERT INTO nyf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Osi airi, mut'u na muchewe were manaishi maisha ga kumufwahiza Mulungu, kidza were manazigwira amuri zosi na malagizo gosi ga Bwana hasiho kaila. ");
INSERT INTO nyf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ela ko were k'amana ahoho bule, kwani Elizabeth'i were ni t'asa, kidza visithoshe, osi airi were madzakala athumia jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Vikara siku mwenga Zakaria were anaenderera na kaziye ya ulombi mumo kahi za ro Hekalu. Jaore kahi za maut'u ga ulombi were ndo ririro isani kahi za wakathi uwo, ");
INSERT INTO nyf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kwa vizho marihopiga k'ura kulengana na adha rao, ikimugwerera Zakaria kwamba angire haryahu hat'u haeri kahi za ro Hekalu ra Bwana na afukize uvumba. ");
INSERT INTO nyf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Vikara wakathi wa kufukiza uvumba urihofika, aryahu at'u angine osi makala manavoya ko ndze ya haryahu hat'u haeri. ");
INSERT INTO nyf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ndo hachambola malaika na akikala aungerere luhande lwa mukono wa kurya wa cho kijaja cha kufukizira uvumba. ");
INSERT INTO nyf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","K'uzhona zho Zakaria arihomona ye malaika wangalala na akikwatya kwadzalwa ni woga. ");
INSERT INTO nyf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kuona vizho, ye malaika akimwamba Zakaria, “Usogohe Zakaria! Kwani Mulungu adzasikira mavoyogo. Mucheo Elizabeth'i andakuzhalira muthana na undamwiha Johana. ");
INSERT INTO nyf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mwana yuyu andihozhalwa undahenda raha kidza undanyeth'a, na hatha anji angine mandahenda raha haho akizhalwa. ");
INSERT INTO nyf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kwani mwana yuyu andakala mut'u mubomu mbere za Bwana, kidza bai asinwe divai hedu kinywaji chochosi cha kurezha hatha vichache, na andadzala Roho Mweri hatha kabila k'adzazhalwa. ");
INSERT INTO nyf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mut'u yuyu andaahendya Aiziraeli anji mamuuyire Bwana Mulungu wao. ");
INSERT INTO nyf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kidza andamuthangulia Mulungu kahi za roho na nguvu here arizhokala Elija. Na lola andaahendya o ano biat'u madziomena ana ao, maahendze, na andaagaluza o at'u masiosikira makale na ulachu dza uryahu wa at'u enye hachi. Mut'u yuyu andamuthayarishira Mulungu at'u.” ");
INSERT INTO nyf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria arihosikira vizho, akimuza ye malaika akiamba, “Ut'u uno be nindamanyadze ni wa jeri? Kwani mimi nidzakala muthumia na muchangu naye adzathumika.” ");
INSERT INTO nyf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ye malaika akimudzigidzya akiamba, “Mimi ni Gaburieli, nikalaye mbere za Mulungu kumuhumikira, nami nidzahumwa kwako nidze nikwambire uv̱oro uu udzo. ");
INSERT INTO nyf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ela ko udzawona uu uv̱oro wangu uriwo undathimira kwa wakathiwe kukala si wa jeri, na lola kwa kukala k'ugakuluhirire maneno gangu, be undafungika sauthi muhaka siku gandihothimira gaga nidzigokwambira.” ");
INSERT INTO nyf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wakathi uu o at'u mariokala manamuthariza Zakaria ambole madangana kwa viryahu arizhokala anatoa zhomu mo Hekaluni. ");
INSERT INTO nyf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bai arihombola akikala k'adima kunena nao bule, na o at'u marihoona vizho makimanya kare kukala suthi akale adzaona maono mo Hekaluni. Vikara kwa kukala were k'adima kunena wahenda kuap'a miv̱ano na yo mikonoye. ");
INSERT INTO nyf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakaria waenderera kukala kahi za ro Hekalu muhaka zamuye ikigoma ndo akidziudzya kwakwe mudzini. ");
INSERT INTO nyf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","K'avitoere Elizabeth'i mukaza ye Zakaria akifunga mimba. Bai arihokala adzafunga mimba k'ambolere mo nyumbani hatha miezi mitsano pu. ");
INSERT INTO nyf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kidza akiamba, “Bwana adzanaviza kahi za ngira ii. Lola adzaniusira kusholerwa nirikokala nikisholerwa!” ");
INSERT INTO nyf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Bai kahi za mwezi wa handahu wa mimba ya Elizabeth'i, Mulungu wamuhuma ye malaika Gaburieli muhaka mudzi mumwenga uifwao Nazareth'i kahi za jimbo ra Galilaya. ");
INSERT INTO nyf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mulungu wamuhuma ende kuko akalazhe uv̱oro kwa musichana mumwenga aifwaye Maryamu. Musichana yuyu were analolwa ni mut'u aifwaye Josefu, ariye were anambola kahi za lukolo lwa Daudi. ");
INSERT INTO nyf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kwa vizho ye malaika achenda kwa Maryamu na akiamba, “K'una ut'u? Mulungu a hamwenga nawe uwe, kidza adzakuhasa zhomu sana!” ");
INSERT INTO nyf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maryamu arihosikira maneno gago, wabudzyika mo moyoni mwakwe na akidziuza, “Ut'u uno be manaye ni noni?” ");
INSERT INTO nyf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ye malaika akimwamba, “Usogohe bule Maryamu, kwa kukala udzapata nema kwa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na lola undafunga mimba na undazhala mwana mulume. Mwana yuyu undamup'a dzina umwihe Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yuyu andakala mut'u mubomu kidza andaifwa Mwana wa Mulungu ariye dzulu ya zhosi. Bwana Mulungu andamup'a kihi cha uthawali cha mukarewe Daudi. ");
INSERT INTO nyf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Naye andakala muthawali wa Aiziraeli hatha kare na kare. Wo uthawaliwe be k'aundahenda mwisho bule.” ");
INSERT INTO nyf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kusikira vizho Maryamu akimwamba ye malaika, “Maut'u gano be gandakaladze, nami sidzakala na mulume?” ");
INSERT INTO nyf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ye malaika akimudzigidzya akiamba, “Roho Mweri andakudzirira, na kidza nguvu za Mulungu ariye dzulu ya zhosi zindakufinikira dza here kivurivuri. Kwa ut'u uu bai, iye mwana andiyezhalwa andakala mueri, na andaifwa Mwana wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na lola yuyahu mumanyio Elizabeth'i naye andazhala mwana mulume idzaho adzakala muthumia. Ye ariyekala akiambwa ni t'asa, be lola vivi ana mimba ya miezi mihandahu, ");
INSERT INTO nyf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","mana k'akuna kisichodimikika kwa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kusikira vizho Maryamu akiamba, “Mimi ni muhumiki wa Mulungu, kwa vizho bai maut'u gaga naganikalire here udzizhoamba uwe.” Gonya ye malaika akimuhaukira ye Maryamu. ");
INSERT INTO nyf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bada ya gago, k'avitoere Maryamu achenda haraka kahi za kadzidzi kamwenga kariko kahi za mirima ya Judea. ");
INSERT INTO nyf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Naye wakwenda hatha mudzini kwa Zakaria na achendamulamusa Elizabeth'i. ");
INSERT INTO nyf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Iye Elizabeth'i arihosikira wo uvoro wa Maryamu thu, ye mwana mo ndanini akisumba zhomu zhenye na lola ye Elizabeth'i akidzalwa ni Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","K'uzhona zho Elizabeth'i akinena na sauthi bomu akimwamba Maryamu, “Uwe ndiwe udziyehaswa ni Mulungu kukira anaache osi na kidza adzahaswa iye mwana undiyemuzhala! ");
INSERT INTO nyf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ela be mino hatha be ni h'ani hatha ye mameye Bwana wangu anitsemberere? ");
INSERT INTO nyf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kwani lola nidzihosikira wo uvorowo thu, ye mwana mo ndanini mwangu adzasumba zhomu zhenye kwa fwahiro. ");
INSERT INTO nyf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bai haswa kwa kukala wakuluhira kukala go maneno arigokwambira ye Bwana gandathimira jeri.” ");
INSERT INTO nyf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ndo Maryamu akiamba, “Moyo wangu unamulika Bwana. ");
INSERT INTO nyf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kidza roho yangu ina raha kwa ut'u wa Mulungu mwokoli wangu, ");
INSERT INTO nyf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","mana adzanionera mbazi mimi muhumikiwe niriye hatha si chochosi! Kwani lola kula vivi rero vizhazi zhosi vindaniha mut'u nidziyehaswa, ");
INSERT INTO nyf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kwa ut'u wa go maut'u mabomu ambago ye Mulungu mwadimi adzanihendera. Dzinare iye ni rieri. ");
INSERT INTO nyf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Naye ana mbazi kwa ao mario manamwagoha, kula kahi za vizhazi zhosi. ");
INSERT INTO nyf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iye waugoloza wo mukonowe wa nguvu na akiatsamula-tsamula o at'u madzionyao hamwenga na go maazo gao garigo mo vitswani mwao. ");
INSERT INTO nyf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kidza waathinya athawali kula kahi za vihi zhao zha endzi, na akianula at'u mario hatha k'amaonewa kit'u ni mut'u. ");
INSERT INTO nyf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Waakusha o enye ndzala na vit'u vidzo-vidzo, ela o mario ni mashaha akiauja kihuhu chenye. ");
INSERT INTO nyf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kidza iye vizho adzathimiza kilaganeche na akare ehu na adzire aviza Aiziraeli, ahumikie.” ");
INSERT INTO nyf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maryamu wakala na Elizabeth'i kuko kwa muda wa miezi mihahu vivi, ndo akiuya kwao mudzini. ");
INSERT INTO nyf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Vikara wakathi urihofika wa ye Elizabeth'i kudzivugula, wahagwaga muthana. ");
INSERT INTO nyf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na lola majiranige na amanyie mafwahirwa naye marihosikira kukala Bwana adzamuonera mbazi nyinji na akamujalia Elizabeth'i mwana. ");
INSERT INTO nyf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","K'uzhona zho ye mutsanga arihofisha siku nane hakidza at'u kwamba mamwangize lwembeni, nao o at'u were madzapanga kumup'a dzina ra Zakaria ambaro ndo dzina ra babaye mwenye. ");
INSERT INTO nyf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ela ye mimut'u kusikira vizho akiamba, “Hatha bule! Dzinare yuyu andaifwa Johana.” ");
INSERT INTO nyf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","O at'u makimwamba, “Mbona kaheri, samba k'ahana mukwenu yoyosi aifwaye Johana?” ");
INSERT INTO nyf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ndo makiona baha mamuze ye bimut'u chamba angahendza ye mwana agerwe dzina rani. Kwa vizho makimuza kwa kuhenda kuhumira miv̱ano. ");
INSERT INTO nyf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Bai ye bimut'u akilagiza agerwe kibao cha kuorera, na ye here kitai akiora vivi, “Dzinare nde Johana.” O at'u osi machangalala kamare. ");
INSERT INTO nyf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na haho henye sauthiye ikirichirwa na akikala anadima kunena kaheri, naye akimulika Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","O majirani ao osi makihondoka na lola kahi za mirima yosi ya Judea be were kila mut'u uv̱oro ni uu. ");
INSERT INTO nyf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kila mut'u ariyesikira uv̱oro uu wadziuza kimoyo-moyo na kuamba, “Muhoho yuno andakala muhoho wa samupuli yani?” Kwani were vi lwazu kamare kukala nguvu za Bwana zi hamwenga naye. ");
INSERT INTO nyf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Gonya Zakaria, babaye Johana wadzalwa ni Roho Mweri na akinena maneno gaga ga Mulungu akiamba, ");
INSERT INTO nyf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Naalikwe Bwana Mulungu wa Iziraeli kwa kukala iye wakudzaalola at'ue na kuakombola. ");
INSERT INTO nyf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kidza wahurehera mwokoli mwenye nguvu wa kula kahi za lukolo lwa muhumikiwe Daudi. ");
INSERT INTO nyf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Here arizholaga haho kapindi kukirira na maneno gao o manabii a kwakwe aeri, ");
INSERT INTO nyf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kwamba huthie kula kwa mahadhui ehu na kula kwa at'u osi madziohumena. ");
INSERT INTO nyf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bai anaaonera mbazi o akare ehu na kidza anathimiza kilaganeche kieri, ");
INSERT INTO nyf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","arichomulahira mukare wehu Burahemu kukala andahuthizha kula kwa mahadhui ehu kwamba hudime kumuhumikira hasiho woga. ");
INSERT INTO nyf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kidza humuhumikire kahi za ngira ambayo ni ya ueri na ya hachi mbereze kahi za maisha gehu gosi. ");
INSERT INTO nyf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Na uwe mwanangu, bai undaifwa nabii wa Mulungu ariye dzulu ya zhosi kwani undamuthangulia Bwana kwamba umutengezere ngiraye, ");
INSERT INTO nyf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","na kidza uamanyise o at'u kukala Mulungu andaasamehe dambi zao na kwa ngira ii mandaokolwa. ");
INSERT INTO nyf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kwani Mulungu wehu ana mbazi nyinji na kukirira kwa zizo mbazize, dzuwa ra wokolwi rindahumbolera kula mulunguni. ");
INSERT INTO nyf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Naro dzuwa riro rindaang'alira aryahu mario manaishi kizani na mario kahi za kivurivuri cha kifwa. Naro rindang'ala kwamba rilongoze nyayo zehu zizhoge kahi za ngira yendayo dherini.” ");
INSERT INTO nyf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","K'uzhona zho yuyahu muhoho akikula na akikala ana nguvu nyinji za kiroho. Lola mut'u yuyu wakala anatoa nyika muhaka uryahu wakathi wa kuambolera Aiziraeli lwazu-lwazu urihofika. ");
INSERT INTO nyf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kahi za siku zizo Kaisari Augusito ariye were ni muthawali wa Kirumi, wamboza amulo kukala at'u osini matoao kahi za ts'i yosi mathalwe. ");
INSERT INTO nyf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Kuthala at'u kuku were ndo kwa kwandza kamare kuhendeka. Bai kahi za uwo wakathi, Kurenio were ni luwali wa ts'i ya Siria.) ");
INSERT INTO nyf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kila mut'u wakwendadzindhikisha kahi za uwo mudzi ambolawo. ");
INSERT INTO nyf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ndo Josefu naye akiuka kula mudzi wa Nazareth'i uriwo kahi za jimbo ra Galilaya na akimbuka kwenda mudzi wa Beth'elehemu ambawo u kahi za jimbo ra Judea. Kuko Beth'elehemu were ndo kurikozhalwa muthawali Daudi, kwa vizho Josefu wakwenda kuko kwa kukala iye were anambola kahi za mbari iyo na lukolo lulo lwa Daudi. ");
INSERT INTO nyf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Naye wakwendadzindhikisha na Maryamu ariye were andakala muchewe kwani were anamulola, kidza Maryamu wakathi uu were ana mimba. ");
INSERT INTO nyf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Vikara marihokala ma kuko Beth'elehemu, wakathi wa kudzivugulakwe Maryamu ukifika, ");
INSERT INTO nyf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","na lola akidzivugula mwanawe wa kwandza, naye were ni muthana. Bai akimuhala ye mwana na akimufunga nguwo za kihoho na akimuhambalaza kahi za kidau cha kuririra ng'ombe. Vivi wavihenda kwa kukala were zo nyumba za kulala ajeni zi thele zosi. ");
INSERT INTO nyf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Vikara kwereko na arisa kahi za luhande lwa ts'i iyo. Arisa aa were manarinda mifugo yao wakathi wa usiku ko urisani. ");
INSERT INTO nyf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ndo poo malaika wa Bwana akiambolera na kidza mulangaza wa Bwana ukiang'alira. Kuona vizho o arisa madzalwa ni woga jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ela ye malaika kuona vizho akiambira o arisa, “Musihondoke, lolani nidzamurehera Uv̱oro Udzo undioafwahiza sana at'u osi. ");
INSERT INTO nyf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kwani vivi rero kahi za mudzi wa Daudi mudzazhalirwa mwokoli wenu, naye nde Masihi Bwana. ");
INSERT INTO nyf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nanwi mundihokwenda, mundamumanya kwa muv̱ano uu: Mundamona mwana mutsanga adziyefungwa viguwo zha kihoho na adzalazwa kahi za kidau cha kuririra ng'ombe.” ");
INSERT INTO nyf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ndo haho henye hachambola kundi bomu ra malaika na makigwirana na yuyahu malaika mungine na makimulika Mulungu na kuamba, ");
INSERT INTO nyf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nguma nayende kwa Mulungu ko dzulu, na dheri narikale dhuniani kwa o at'u ario Mulungu anafwahirwa nao!” ");
INSERT INTO nyf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bai aryahu malaika marihoahaukira aryahu arisa na kuuya mulunguni, o arisa maambirana enye kwa enye makiamba, “At'u siswi nafwende ko Beth'elehemu fukachone cho kit'u fudzichombirwa ni Bwana kukala kidzahendeka.” ");
INSERT INTO nyf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kwa vizho makihenda haraka na makiuka machenda. Marihofika kuko makidengereka makimona Josefu na Maryamu na ko kadzanake katsanga. Nako were kadzalazwa kahi za kadau ka kuririra ng'ombe. ");
INSERT INTO nyf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","O arisa marihomona ye mwana, maambira at'u viryahu marizhokala madzambirizwa ni malaika dzulu za ye mwana. ");
INSERT INTO nyf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na lola kila ariyesikira zho marizhoamba o arisa wangalazwa ni wo uv̱oro wao. ");
INSERT INTO nyf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ela Maryamu ye arihosikira maut'u gaga wagaika moyoni na akikala anagaaza kwenda-kwenda. ");
INSERT INTO nyf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bai aryahu arisa mauya ko urisani, kuno manamup'a nguma Mulungu na kumulika kwa garyahu gosini marigo were magasikira na kugaona, kwani maut'u gago gakala here viryahu marizhokala mambirwa zhenye. ");
INSERT INTO nyf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bai yuyahu muhoho arihofisha siku nane, ambawo ndo wakathi wa kumwangiza lwembeni, wagerwa dzina akiifwa Jesu. Dzina riri were ndo ririrolazhwa ni ye malaika hatha kabila ye mimut'u k'adzafunga mimba. ");
INSERT INTO nyf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Vikara wakathi urihofika wa Maryamu na Josefu kuthimiza adha ra kudzitsusa here Sheria ya Musa ilagizazho, madzitsusa, makimuhala ye mwana machenda naye ko Jerusalemu kwendamwika mbere za Mulungu, ");
INSERT INTO nyf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(kwani zhaorwa kahi za sheria ya Bwana kukala, “Kila mwana mulume wa kwandza suthi aikwe mbere za Bwana.”) ");
INSERT INTO nyf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kidza makwenda kuko ili makalazhe sadaka ya magiya mairi hedu uthoro wiri uriwo uchere ginda-ginda, here sheria ya Mulungu iambazho. ");
INSERT INTO nyf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Vikara kuko Jerusalemu kwereko na mut'u mumwenga ariyeifwa Simioni. Mut'u yuyu were ni muhachi na amwagohaye Mulungu, naye wakala anauthariza uryahu wakathi ambawo Aiziraeli mandahurizwa. Mut'u yuyu were Roho Mweri a hamwenga naye. ");
INSERT INTO nyf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bai iye Roho Mweri were wamuhakikishira kukala k'andafwa muhaka amone na dzitso ye Masihi wa Bwana. ");
INSERT INTO nyf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ndo Roho akimuhendya ende kahi za wo muhala wa ro Hekalu, vikara o azhazi a Jesu marihomureha ye mwana wao ndani ili mamuhendere here adha ra sheria riambazho, ");
INSERT INTO nyf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioni wamuhokera ye mwana mikononi mwakwe na akimulika Mulungu na kuamba, ");
INSERT INTO nyf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Vikara Bwana, muriche muhumikio ende na dheri, here urizholaga. ");
INSERT INTO nyf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwani kwa dzitso rangu nidzawona wokolwio, ");
INSERT INTO nyf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nidzawona wokolwio uriwo udzauthayarisha kwa at'u osi. ");
INSERT INTO nyf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Na wokolwi uu ni wo mulangaza undioang'alira at'u mario si Ayahudi, na kureha nguma kwa at'uo Aiziraeli.” ");
INSERT INTO nyf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kusikira vizho o azhazi a Jesu mangalala zhomu dzulu za gago garigokala gadzanenwa dzulu za ye mwana. ");
INSERT INTO nyf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Gonya Simioni akiahasa na kidza akimwamba ye Maryamu mameye Jesu, “Lola, mwana yuyu adzaikwa akale chausa cha Aiziraeli anji kwangamika na angine anji kuthia, na andaanyesa at'u mahendzo ga Mulungu, ela ko at'u mandamunena vii. ");
INSERT INTO nyf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na bai mwana yuyu adzaikwa kwamba maazo ga anji garigo mioyoni gang'azwe ngh'aa. Na lola bai uwe nawe undakala na utsungu zhomu mo moyoni tha vindakala ni here udziyedungwa mushu.” ");
INSERT INTO nyf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Bai mweremo mumo Hekaluni nabii wa kiche aifwaye Ana. Ana were ni mwana wa Fanueli wa mbari ya Asheri. Mwanamuche yuyu were adzakala muthumia sana. Ho kapindi wahalwa na akitoa na mulumewe kwa miaka mifungahe, ");
INSERT INTO nyf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","gonya mulumewe akinongeka na akikala gungu muhadhi wakathi uu ambawo were ana miaka mirongo minane na mine. Lola were k'ambola mo kahi za ro Hekalu hatha kaziye were ni kumuvoya Mulungu kwa kufunga na kuvoya usiku na mutsana. ");
INSERT INTO nyf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kwa vizho akidza mumo wakathi uwo na akimboza muv̱era kwa Mulungu na akinena dzulu za ye muhoho kwa o at'u mario were manathariza yo siku ambayo Mulungu andakombola Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bai Josefu na Maryamu marihogonya kuhenda kila kit'u kuthuwana na sheria ya Bwana iambazho, mauya kahi za mudzi wao wa Nazareth'i uriwo jimbo ra Galilaya. ");
INSERT INTO nyf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naye ye muhoho akikula na akikala na nguvu na akikala athele ulachu, na nema ya Mulungu ikikala dzuluze. ");
INSERT INTO nyf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Vikara kila mwaka azhazi a Jesu were ni kwenda Jerusalemu kwa sikuk'uu ya P'asaka. ");
INSERT INTO nyf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bai Jesu arihokala adzafisha miaka kumi na miri, iye na azhazie mambuka kwenda Jerusalemu kwa yo sikuk'uu here garizhokala mazowera gao. ");
INSERT INTO nyf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Vikara iryahu sikuk'uu irihokira, o azhazie maandza charo cha kuuya mudzini, ela Jesu ye akisala kuko Jerusalemu. Na bai o azhazie k'amavimanyire bule vivi. ");
INSERT INTO nyf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kwani ao makala manaona iye a kahi za go makundi-makundi ga at'u, kwa vizho makithuwa kubugula kwenda, mutsana muzima, ndo makikwatya kumumala-mala kahi za o amanyi ao na asena ao. ");
INSERT INTO nyf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Marihokala k'amamona, mauya ko Jerusalemu kwendamudengereka kuko. ");
INSERT INTO nyf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bada ya siku t'ahu hangu aangamike matsoni, machendamona kahi za ro Hekalu akelesi mumo na alimu, naye were anaasirikiza na kuauza-uza maswali. ");
INSERT INTO nyf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Aryahu osini mariomusikira ananena mangalazwa ni wo ulachuwe na go madzigidzyoge. ");
INSERT INTO nyf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bai o azhazie marihomona mumo mangalala. Ndo mameye achambola kuuza akiamba, “Aa, Mwanangu, mbona udzahuthabisha vino we? Mimi na babayo be were fu wasiwasi jeri kukudengereka uwe.” ");
INSERT INTO nyf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesu akidzigidzya akiamba, “Mudzakala munanimalirani benwi? Fuambe were k'amumanya bule kukala suthi nikale kahi za nyumba ya Baba?” ");
INSERT INTO nyf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ela o azhazie k'amaelewerwe mana ya zho arizhonena. ");
INSERT INTO nyf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bai Jesu akitharamuka mudzi wa Nazareth'i hamwenga na azhazie, na akikala mwenye kuasikiza. Ela mameye wagaika maut'u gaga moyoni mwakwe. ");
INSERT INTO nyf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Bai Jesu waenderera kukula kimo na hatha ulachu, naye waenderera kumufwahiza Mulungu na at'u nao. ");
INSERT INTO nyf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Vikara kahi za mwaka wa kumi na tsano wa uthawali wa Kaisari Tiberio, ariye were ni muthawali mubomu wa ts'i zosi za Kirumi, P'onitio P'ilato were ni luwali wa jimbo ra Judea, Herode ye, were nde ariye anathawala jimbo ra Galilaya. Nduguye Herode aifwaye Filipu were anathawala majimbo mairi, Iturea na Tirakoniti. Naye Lisania were anathawala jimbo ra Abilene. ");
INSERT INTO nyf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kahi za wakathi uwo Anasi hamwenga na Kayafa were ndo alombi abomu enye. Bai ndo neno ra Mulungu rikimudzirira Johana wa Zakaria kuko nyika. ");
INSERT INTO nyf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kwa vizho Johana achenda kahi za sehemu zosi zirizo hehi na muho wa Jorodani na akihubiri na kuamba, “Thubuni mubat'izwe, na Mulungu andamusamehe dambi zenu.” ");
INSERT INTO nyf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Johana wakala anahubiri here virizhoorwa kahi za chuwo cha nabii Isaya kukala, “Mut'u analuta mumirowe ko nyika na kuamba, ‘Mutengezereni ngira Bwana, Mutengezereni ngira ya kugoloka. ");
INSERT INTO nyf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila det'e rindadzazwa, kila murima na mukole vindatandazwa, zo ngira zenye mibokw'e-mibokw'e zindalainishwa. ");
INSERT INTO nyf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kidza anadamu osini mandawona wokolwi wa Mulungu!’ ” ");
INSERT INTO nyf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bai makundi na makundi ga at'u makwenda kwamba mabat'izwe ni Johana. Ela arihoaona akiambira, “H'enwi kizhazi cha nyoka nwi! Ni h'ani ariyemwambira kukala muzichimbire zo k'oro za Mulungu zidzazo? ");
INSERT INTO nyf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","H'aya mahendo genu naganyese kukala mudzathubu dambi jeri. Na kidza musidziambe mu ana a Burahemu. Kwani namwambira kamare kukala, Mulungu anadima kumuumbira ana Burahemu hatha kula kwa gaga mawe! ");
INSERT INTO nyf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na vivi be tsoka ri ho kolo kare, na kila muhi usiwozhala matunda madzo, undathemwa utsufwe mohoni.” ");
INSERT INTO nyf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kusikira vizho o at'u makimuza makiamba, “Vikara vino be fuhendedze sino?” ");
INSERT INTO nyf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Johana akiadzigidzya akiamba, “Ariye na k'andzu mbiri na amup'e mwenga ye ariye k'ana, na ariye na chakurya na amugazhizhe mwandziwe.” ");
INSERT INTO nyf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bai athozi a kodi nao machenda ili makabat'izwe. Makimuza Johana makiamba, “Mwalimu, sino naswi fuhendedze?” ");
INSERT INTO nyf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Akiadzigidzya akiamba, “Musithoze at'u zaidhi ya cho kiwango kirichoikwa.” ");
INSERT INTO nyf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Gonya shikari nao makimuza makiamba, “H'aya sino fuhendedze?” Akiadzigidzya akiamba, “Musihale p'esa za mut'u kwa kibavu, hedu kushithaki mut'u kwa kuhenda kumusingizira, na thoshekani na yo mishahara yenu.” ");
INSERT INTO nyf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bai o at'u were manathariza na th'amaa na osi were manadziuza mo mioyoni na kuamba, “Yuno be akale nde ye Masihi hedu dze?” ");
INSERT INTO nyf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Johana akinena nao osi akiamba, “Mimi ninamubat'iza na madzi, ela kundakudza mut'u mungine ariye simufika kahi za wadimi, kidza sifika hatha mut'u wa kumuvula virahuzhe. Iye andamubat'iza kwa Roho Mweri na kwa moho. ");
INSERT INTO nyf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kwani iye adzagwirira lungo kuhehet'a ngano. Akigonya kuhehet'a andahala yo ngano ayangize lutsagani, gonya ahale wo wiswa autsuhe kahi za moho usiwozima.” ");
INSERT INTO nyf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Bai Johana waashauri at'u kwa kuhumira mifano minji mingine arihokala anaambiriza wo Uv̱oro Udzo. ");
INSERT INTO nyf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Na kidza akimuchemera muthawali Herode kwa kumuhala Herodia mukaza nduguye mwenye na kwa ut'u wa mai mangine arigokala wagahenda. ");
INSERT INTO nyf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herode arihosikira vizho akikaza kuwangeza wo uthiririwe kwa kuhenda kumwangiza jela kamare ye Johana. ");
INSERT INTO nyf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bai o at'u osi marihokala manabat'izwa, Jesu wakwenda naye achendabat'izwa, vikara arihokala akuvoyani, ko mulunguni kwagunuka, ");
INSERT INTO nyf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Roho Mweri akitserera dzuluze kwa umbo ra giya. Na kukimbola mumiro kula ko mulunguni ukiamba, “Uwe u Mwanangu muhendzwi, unifwahizaye.” ");
INSERT INTO nyf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu arihoandza kaziye, were ana here miaka mirongo mihahu vivi, na at'u maelelya kukala were ni mwana wa Josefu ariye were babaye ni Heli. ");
INSERT INTO nyf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli were ni mwana wa Mathati, Mathati were ni mwana wa Lawi na Lawi were ni mwana wa Meliki na Meliki were ni mwana wa Janai na Janai were ni mwana wa Josefu. ");
INSERT INTO nyf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josefu were ni mwana wa Matathia, Matathia yuyu were ni mwana wa Amosi, na Amosi were ni mwana wa Nahumu na Nahumu were ni mwana wa Esili na Esili were ni mwana wa Nagai. ");
INSERT INTO nyf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai were ni mwana wa Maathi na Maathi were ni mwana wa Matathia na Matathia were ni mwana wa Semeini na Semeini were ni mwana wa Joseki na Joseki were ni mwana wa Joda, ");
INSERT INTO nyf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","na Joda were ni mwana wa Joanani, na Joanani were ni mwana wa Resa na Resa were ni mwana wa Zerubabeli, na Zerubabeli were ni mwana wa Salathieli, na Salathieli were ni mwana wa Eri. ");
INSERT INTO nyf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Eri were ni mwana wa Meliki, na Meliki yuyu were ni mwana wa Adi, na Adi were ni mwana wa Kosamu, na Kosamu were ni mwana wa Elimadamu na Elimadamu were ni mwana wa Eri, ");
INSERT INTO nyf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","na Eri were ni mwana wa Joshua, na Joshua were ni mwana wa Eliezeri, na Eliezeri were ni mwana wa Jorimu, na Jorimu were ni mwana wa Matathi na Mathati yuyu were ni mwana wa Lawi. ");
INSERT INTO nyf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi yuyu were ni mwana wa Simioni, na Simioni were ni mwana wa Juda, na Juda were ni mwana wa Josefu, na Josefu yuyu were ni mwana wa Jonamu, na Jonamu were ni mwana wa Eliakimu, ");
INSERT INTO nyf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","na Eliakimu were ni mwana wa Melea, na Melea were ni mwana wa Mena, na Mena were ni mwana wa Matatha, na Matatha were ni mwana wa Nath'ani, na Nath'ani were ni mwana wa Daudi. ");
INSERT INTO nyf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daudi were ni mwana wa Jese, na Jese were ni mwana wa Obedi, na Obedi were ni mwana wa Boazi, na Boazi were ni mwana wa Salimoni, na Salimoni were ni mwana wa Nashoni. ");
INSERT INTO nyf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashoni were ni mwana wa Aminadabu, na Aminadabu were ni mwana wa Aramu, na Aramu were ni mwana wa Hezironi, na Hezironi were ni mwana wa P'erezi, na P'erezi were ni mwana wa Juda, ");
INSERT INTO nyf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","na Juda yuyu were ni mwana wa Jakobu, na Jakobu were ni mwana wa Isaka, na Isaka were ni mwana wa Burahemu, na Burahemu were ni mwana wa T'era, na T'era were ni mwana wa Nahori. ");
INSERT INTO nyf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahori were ni mwana wa Serugi, na Serugi were ni mwana wa Reu, na Reu were ni mwana wa P'elegi, na P'elegi were ni mwana wa Eberi, na Eberi were ni mwana wa Sala, ");
INSERT INTO nyf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","na Sala were ni mwana wa K'ainani na K'ainani were ni mwana wa Arafakasadi, na Arafakasadi were ni mwana wa Shemu, na Shemu were ni mwana wa Nuhu, na Nuhu were ni mwana wa Lameki. ");
INSERT INTO nyf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Bai Lameki were ni mwana wa Meth'usela, na Meth'usela were ni mwana wa Enok'o na Enok'o were ni mwana wa Jaredi, na Jaredi were ni mwana wa Mahalaleli, na Mahalaleli were ni mwana wa K'ainani, ");
INSERT INTO nyf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","na K'ainani yuyu were ni mwana wa Enosi, na Enosi were ni mwana wa Sethi, na Sethi were ni mwana wa Adamu, na Adamu were ni mwana wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu akiuka kula kahi za wo muho wa Jorodani kuno athele Roho Mweri, naye ye Roho wamulongoza ende nyika. ");
INSERT INTO nyf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kuko nyika Jesu wagonya siku mirongo mine kuno anajezwa ni Shethani. Bai kahi za zo siku mirongo mine k'arirye kit'u bule. Vikara kahi za mwisho wa zo siku zizo akisikira ndzala. ");
INSERT INTO nyf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ye Shethani akimwamba Jesu, “Chamba u Mwana wa Mulungu jeri, rambire riri iwe riri rikale mukahe.” ");
INSERT INTO nyf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu akimudzigidzya akiamba, “Zhaorwa kukala, ‘Mudamu k'andakala moyo kwa mukahe thu.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Gonya ye Shethani akimuhala Jesu na achenda naye hat'u dzulu na akimwanyesa ts'i zosi za urumwengu kwa wakathi mufuti, ");
INSERT INTO nyf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","gonya akimwamba Jesu, “Mimi nindakup'a wadimi wosi dzulu za zizi ts'i, kidza nindakup'a ushaha uu wosi. Kwani maut'u gaga nagagerwa mimi mikononi mwangu na nina wadimi wa kumup'a yoyosi nihendzaye kumup'a. ");
INSERT INTO nyf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kwa vizho ukinivoya, maut'u gaga gosi gandakala gako.” ");
INSERT INTO nyf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu akimudzigidzya akiamba, “Zhaorwa kukala, ‘Muvoye Bwana Mulunguo na umuhumikire iye h'akeye!’ ” ");
INSERT INTO nyf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Gonya ye Shethani akimuhala muhaka mudzi wa Jerusalemu, na akimukweza dzulu za wo munara wa ro Hekalu na akimwamba, “Kala u Mwana wa Mulungu jeri, dzirichire kula haha na udzitsuhe ko ts'i, ");
INSERT INTO nyf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kwani zhaorwa kukala, ‘Mulungu andaalagiza malaikae makurinde t'ot'ot'o.’ ");
INSERT INTO nyf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kidza, ‘Ao mandakwanula na mikono yao, p'ore ukakwala iwe.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesu akimudzigidzya akiamba, “Maoro ganaamba, ‘Usimujeze Bwana Mulunguo bule!’ ” ");
INSERT INTO nyf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bai Shethani arihogonya kumujeza Jesu kahi za ngira zosini, waandza kumuhaukira kwandza kwa muda. ");
INSERT INTO nyf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Badaye Jesu wauya kahi za jimbo ra Galilaya, na uv̱orowe ukivuma kahi za sehemu zosi zidzizohakana na jimbo riro, na lola nguvu za Roho Mweri zere zi hamwenga naye. ");
INSERT INTO nyf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Bai Jesu akifundisha kahi za go masinagogi kuko na kila mut'u akikala anamulika. ");
INSERT INTO nyf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Badaye achenda ko Nazareth'i ambawo ndo mudzi ariorerwa. Vikara irihofika siku ya Sabato, achenda kahi za sinagogi here garizhokala mazowerage, na akiungarara kwamba ashome Maoro. ");
INSERT INTO nyf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bai akigolozerwa chuwo cha nabii Isaya. K'uzhona zho akikihala akikivugula na akipata hat'u harihoorwa vivi: ");
INSERT INTO nyf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Roho wa Bwana a hamwenga nami, kwani adzanihaka mafuha ili nihubiri wo Uv̱oro Udzo kwa akiya. Iye Bwana adzanihuma niambire o mario jela mavugulwe. Kidza ao mario ni vipofu madime kuona, na adzanihuma ili ao mario manaonerwa niaike huru, ");
INSERT INTO nyf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na kidza niamanyise at'u dzulu za uwo mwaka wa Bwana ambawo ye Bwana andanyesa mbazize.” ");
INSERT INTO nyf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bai Jesu arihogonya kushoma wahala cho chuwo akikikundza t'ot'ot'o gonya akimugolozeza ye muhumiki na achendakeresi. Bai kila mut'u kahi za ro sinagogi wamuthema dzitso ye Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ndo Jesu akiambira, “Vivi rero be gaga Maoro gaga gadzathimira here mudzizhogasikira nikigashoma.” ");
INSERT INTO nyf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bai kila mut'u wanena madzo dzuluze na kidza were manangalazwa ni go maneno madzo garigombola kanwani mwakwe. Na lola makikwatya kuuzana-uzana na kuamba, “Vino akale yuno si mwana wa Josefu bule yuno?” ");
INSERT INTO nyf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesu akiambira, “Vivi jeri wenye namanya mundanambira ii ndhumo ii iambayo, ‘Muganga dzihoze mwenye.’ Kidza garyahu hurigosikira wagahenda kuko Kaperinaumu be gahende hatha haha kahi za mudzi wa kwako wenye.” ");
INSERT INTO nyf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesu akienderera kunena akiamba, “Namwambira ujeri wenye, k'akuna nabii ahendzwaye kwao. ");
INSERT INTO nyf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ko kunena wo ujeri wenye, be kahi za ts'i ya Iziraeli were kuna ache magungu anji enye kahi za uryahu wakathi wa Elija. Kahi za wakathi uwo v̱ula yazuliwa kunya kwa muda wa miaka mihahu na nusu, k'uzhona zho kukihenda ndzala ya kitai kahi za ts'i ndzima. ");
INSERT INTO nyf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ela ko Elija k'ahumwirwe kwa yoyosi kahi za ao, hat'u ha vizho, akihumwa kwa mwanamuche gungu kuko Sareputa kahi za ts'i ya Sidoni. ");
INSERT INTO nyf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Visithoshe kahi za ts'i ya Iziraeli were kuna at'u anji enye mahana, kahi za wakathi wa nabii Elisha, ela ko k'ahana mungine yoyosi ariyehozwa hasihokala Namani wa kula ts'i ya Siria.” ");
INSERT INTO nyf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bai o at'u mariokala kahi za ro sinagogi marihosikira maneno gaga, matsukirwa jeri-jeri, ");
INSERT INTO nyf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","nao ngh'o makirungarara na makimuchuchuza Jesu muhaka ko muv̱iryani kwa wo mudzi, uriwo were wajengwa kirimani. Nao ndoo naye vivi muhaka hat'u mutharamukoni, ili mamusukume avoromoke ko ts'ini. ");
INSERT INTO nyf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ela Jesu akikira kahikahi zao na achenda na shuhulize. ");
INSERT INTO nyf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Gonya Jesu akitharamuka kahi za mudzi wa Kaperinaumu ambawo u kahi za jimbo ra Galilaya. Bai kahi za siku ya Sabato akikwatya kufundisha o at'u. ");
INSERT INTO nyf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na lola o at'u mangalazwa zhomu ni go mafundishoge kwa kukala iye were ananena na wadimi. ");
INSERT INTO nyf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Vikara mumo kahi za ro sinagogi were muna mut'u ariyepagawa ni p'ep'o. Bai mut'u yuyu wapiga k'ululu here adimazho, akiamba, ");
INSERT INTO nyf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Unani naswi we Jesu wa Nazareth'i? Vidze udzire uhunonge-nonge? Ninamanya uwe u h'ani. Uwe u Mweringwa wa Mulungu!” ");
INSERT INTO nyf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kusikira vizho Jesu akimuchemera ye p'ep'o, akimwamba, “Hedu nyamala kare na umwambole!” Bai ye p'ep'o akimupiga chavu ye mut'u mbere za o at'u osi na akimwambola hasiho kumulumiza hat'u hohosi. ");
INSERT INTO nyf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","O at'u osi marihoona vizho mangalala na makiuzana-uzana makiamba, “Gano ni maneno garigodze gano! Kwa kuhumira nguvu na wadimi anaachemera p'ep'o mambole nao manambola jeri!” ");
INSERT INTO nyf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bai uv̱oro wa Jesu watsamuka kila hat'u kahi za lalo riro. ");
INSERT INTO nyf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Badaye Jesu wambola mo sinagogini achenda hatha nyumbani kwa Simoni. Vikara kuko, mutsedza wa Simoni wa kiche were ana homa kali, bai o at'u makimuvoya Jesu amwavize. ");
INSERT INTO nyf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ndo Jesu achenda na akizama, akirichemera ro homa naro rikiricha kare, naye akiungarara mara mwenga, akiahikirahikira. ");
INSERT INTO nyf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bai dzuwa ririhokala rinapothoka, at'u osi mariokala mana akongo ao a kila namuna mamurehera Jesu, naye akiaikira mikono osi akiahoza. ");
INSERT INTO nyf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hatha p'ep'o nao maambola at'u anji kuno manapiga k'ululu na kuamba, “Uwe u Mwana wa Mulungu!” Ela Jesu akiachemera na k'aap'ere kadzanya ka kunena, kwa kukala o p'ep'o mere manamanya kukala iye nde Masihi. ");
INSERT INTO nyf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bai kurihocha, Jesu wambola wo mudzi na achenda kut'u k'anda kuriko k'akuna at'u. Ndo at'u makikwatya kumudengereka, nao marihofika kuko arikokala, majeza kumubembeleza ili asiahaukire. ");
INSERT INTO nyf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ela Jesu akiambira, “Mimi suthi nihubiri wo Uv̱oro Udzo wa uthawali wa Mulungu kwa yo midzi mingine nayo, kwani vizho ndo virizhohenda nihumwe.” ");
INSERT INTO nyf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bai Jesu waenderera kuhubiri kahi za masinagogi ga Judea ndzima. ");
INSERT INTO nyf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Siku mwenga Jesu were aimire k'anda-k'anda za ro ziya ra Genezarethi kuno adzazungulukwa ni rikundi ribomu ra at'u mario were manasirikiza neno ra Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bai ariholola akiona madau mairi gadzarichwa ho k'anda-k'anda ya ro ziya. O avuvi enye were madzakwendagesa vimia zhao. ");
INSERT INTO nyf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesu akikwera mwenga kahi za go madau. Riro dau arirokwera were ni ra Simoni. Bai Jesu akimwamba Simoni arisukume mo ziyani vichache, virihokala vidzahendwa, Jesu wakeresi mo dauni na akikwatya kuafundisha o at'u. ");
INSERT INTO nyf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Arihokala adzagonya kunena wamwamba Simoni, “Simoni, sukuma riri dau muhaka rifike ko kwenye madzi manji, gonya mutsuhe zho vimia zhenu mugwire makumba.” ");
INSERT INTO nyf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni akimudzigidzya akiamba, “Bwana! At'u siswi fudzachesa kuvuha tha ngh'aa na k'afugwirire chochosi, ela kwa udzaamba, be nindatsuha zho vimia.” ");
INSERT INTO nyf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na lola marihohenda vizho, magwira makumba manji zhomu hatha zho vimia vikikala vinakwatya kutharuka. ");
INSERT INTO nyf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Marihoona vizho makiatsuhira mikono aryahu andziyao mariokala kahi za ro dau ringine, madze maavize. Bai marihokudza, makidzaza go madau gosi mairi na makumba, hatha go madau gakimala kuhoha. ");
INSERT INTO nyf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","K'uzhona zho ye Simoni P'et'ero arihoona maut'u gaga, wapiga mavindi mbere za Jesu na akimwamba, “Bwana nihaukira, kwani mimi ni mut'u mwenye dambi!” ");
INSERT INTO nyf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Naye wanena vizho kwa kukala iye hamwenga na o andziye osi were madzamashwa ni go makumba marigokala madzagagwira. ");
INSERT INTO nyf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hatha o ana a Zebedayo, Jakobu na Johana ambao were mavuha na Simoni, ao nao were madzamaka. Bai Jesu akimwamba Simoni, “Usogohe, kwa kukala kula vivi rero, undakala muvuhi wa at'u.” ");
INSERT INTO nyf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bai machenda na go madau hatha ho k'anda-k'anda za ro ziya, nao makiricha kila kit'u haho na makimuthuwa Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Siku mwenga, Jesu arihokala a kahi za mudzi mumwenga, hakudza mwanamulume ariyekala ana mahana mwiri muzima. Bai arihomona Jesu wazama hatha usowe ukigut'a ts'i na akimuvoya akiamba, “Bwana, ukihendza unadima ukanihoza!” ");
INSERT INTO nyf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesu akigoloza mukono akimugut'a na akimwamba, “Ninahendza, hola” Na haho na haho kare go mahana gakimwangamika. ");
INSERT INTO nyf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Gonya Jesu akimukokot'era kukala asizhambire mut'u bule, akimwamba, “Ela enda ukamwanyese mulombi, gonya umboze sadaka ya ko kuholako here arizholagiza Musa, ili kila mut'u amanye kukala udzahola jeri.” ");
INSERT INTO nyf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ela hatha hamwenga na vizho, wo uv̱oro dzulu za Jesu wakaza kutsamuka kila hat'u, na makundi mabomu ga at'u gachendamusirikiza na kuhozwa makongo gao. ");
INSERT INTO nyf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ela Jesu were akaahaukira na kwenda hat'u k'anda h'akeye kwendavoya. ");
INSERT INTO nyf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Vikara siku mwenga Jesu were anafundisha, bai haho hakikala hana Mafarisayo na alimu a Sheria mario were makeresi haho. At'u aa were angine madzalaa kahi za kila kadzidzi ka jimbo ra Galilaya, na jimbo ra Judea na angine were madzalaa mudzi wa Jerusalemu. Bai nguvu za Mulungu were zi hamwenga na Jesu kuhoza akongo. ");
INSERT INTO nyf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","K'uzhona zho hakidza anaalume madzamutsukula mut'u wa kuholoza kitandani. Bai makijeza kwenda naye mo ndani ya nyumba kwamba mamuhambalaze mbere za Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ela kwa wo unji wa at'u mariokala kahi za yo nyumba makosa ngira ya kwangirira naye mumo ndani. Ndo makikwera hatha ko dzulu ya nyumba makivomola go mawe na makipata mwanya makimutharamusha ye mut'u na cho kitandache muhaka ho kahikahi za ro kundi ra at'u, naho were ni ho mbere za Jesu henye. ");
INSERT INTO nyf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Bai Jesu arihoona ro kuluhiro rao, wamwamba ye mut'u, “Dambizo zidzasamehewa, musena!” ");
INSERT INTO nyf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kusikira vizho o Mafarisayo na alimu a Sheria makikwatya kudziuza kimoyo-moyo makiamba, “Mwenye ni h'ani yuno, anenaye kufuru namuna ino? Vidze hana mungine adimaye kusamehe dambi isihokala Mulungu h'akeye?” ");
INSERT INTO nyf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bai Jesu arihogamanya go maswali gao, akiuza akiamba, “Kwanoni munadziuza maswali? ");
INSERT INTO nyf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Vidze virizho rahisi ni hizho? Ni kumwamba mut'u ‘Udzasamehewa dambizo,’ hedu ni kumwamba, ‘Uka wanende?’ ");
INSERT INTO nyf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","H'aya manyani bai, kukala Mwana wa Mudamu ana wadimi wa kusamehe dambi haha dhuniani.” Kugonya kunena vizho Jesu akimwamba ye mut'u ariyeholoza, “Ninakwamba uka uhale kitandacho wende kwenu.” ");
INSERT INTO nyf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na haho henye ye mut'u akiungarara mbere za o at'u osi, akihala zo ndazi arizo were adzahambalalira na achenda kwao kuno anamulika Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na lola, kila mut'u wangalala na akimulika Mulungu. Nao o at'u ao madzalwa ni woga na makiamba, “H'aa, rero fudzaona kitai.” ");
INSERT INTO nyf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bai bada ya maut'u gago Jesu wambola ko ndze ya wo mudzi, kuko akimona muthozi mumwenga wa kodi ariyekala anaifwa Lawi akeresi kahi za ofisi ya kodi. Jesu akimwamba, “Nithuwa.” ");
INSERT INTO nyf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi akiricha kila kit'u, akirungarara akimuthuwa Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Badaye ye Lawi achendamuusira ujeni ubomu ye Jesu ko kwakwe nyumbani, na kundi bomu ra athozi a kodi andziye hamwenga na at'u angine, makudzarya hamwenga nao. ");
INSERT INTO nyf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bai o Mafarisayo na alimu ao a Sheria marihoona vizho makikwatya kuanung'unikira o anafundzi a Jesu na kuamba, “Mbona munarya na kunwa na athozi a kodi, hamwenga na at'u enye dambi?” ");
INSERT INTO nyf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesu akiadzigidzya akiamba, “Mukongo nde mwenye haja na muganga, ela muzima k'ana haja na muganga bule. ");
INSERT INTO nyf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mimi nakudzaaiha enye dambi mathubu, sidzireaiha enye hachi!” ");
INSERT INTO nyf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Gonya at'u angine makimuza Jesu makiamba, “Mbona anafundzi a Johana, na anafundzi a Mafarisayo mara kwa mara manafunga na kuvoya, ela o a kwako kazi yao ni kurya na kunwa?” ");
INSERT INTO nyf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesu akiamba, “Vidze munadima kuahendya ajeni a harusini makafunga kala ye bwana harusi manaye haho? ");
INSERT INTO nyf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ela siku zinadza, ambazo ye bwana harusi andauswa kahikahi zao, na wakathi uwo ukifika mandafunga.” ");
INSERT INTO nyf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Gonya Jesu akiambozera fumbo riri, akiamba, “K'ahana atosaye kiraka kula kwa nguwo mbisha na akachangiza kahi za nguwo ya kapindi. Mana mut'u akihenda vizho, iryahu nguwo mbisha andakala adzayomola, na hatha kiryahu kiraka k'akindatsomana na yo nguwo ya kapindi bule. ");
INSERT INTO nyf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kidza k'ahana mut'u adimaye kwangiza divai mbisha kahi za viriba zha kapindi. Kwani akihenda vizho yo divai mbisha indavipashula zho viriba. Bai zho viriba vindakala vidzanongeka, na yo divai nayo indakala idzamwagika. ");
INSERT INTO nyf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ela divai mbisha suthi yangizwe kahi za viriba visha. ");
INSERT INTO nyf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","K'amuona bai, k'ahana anwaye divai ya kapindi gonya akathamani kunwa yo mbisha nayo, kwani andaamba, ‘Ii ya kapindi ndo mbidzo.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Siku mwenga iriyokala ni siku ya Sabato, Jesu were anakira na anafundzie kahi za minda ya ngano. K'uzhona zho aryahu anafundzie makikwatya kuhuta go masuche ga yo ngano na kugahulula na kurya. ");
INSERT INTO nyf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ela Mafarisayo angine marihoona vizho makiauza makiamba, “Mbona munahenda ut'u uriwo k'auhendwa siku ya Sabato?” ");
INSERT INTO nyf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesu akiadzigidzya akiamba, “Muthawali Daudi wahendadze harya arihokala iye na o at'u ariokala nao mana ndzala? Hedu k'amudzavishoma? ");
INSERT INTO nyf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Iye Daudi wangira kahi za nyumba ya Mulungu na akihala yo mikahe ya sadaka akiirya, gonya akiap'a aryahu andziye nao makirya, vingahokala kulingana na sheria, were ni alombi h'akiyao ndo madimao kuirya.” ");
INSERT INTO nyf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Gonya Jesu akisindikiza na kuamba, “Bai ye Mwana wa Mudamu nde Bwana wa yo siku ya Sabato.” ");
INSERT INTO nyf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Badaye siku nyingine yenye ya Sabato, Jesu wakwenda kahi za sinagogi na akifundisha. Bai mumo sinagogini mwere muna mut'u ariyeholoza mukono wa kurya. ");
INSERT INTO nyf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na o Mafarisayo na alimu a Sheria, mere ma haho, nao were mamalacho ni chausa cha kumushithakira, kwa vizho makimulolera maone chamba andamuhoza kahi za yo siku ya Sabato, makamushithaki. ");
INSERT INTO nyf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ela Jesu akigamanya kare go maazo gao, bai akimwamba ye mut'u wa mukono wa kuholoza, “Ungarara udze uime haha kahikahi hedu.” Bai ye mut'u akiungarara akidzaima haho. ");
INSERT INTO nyf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ndo Jesu akiauza akiamba, “Namala munambire, kisheria virizho karakara kuhendwa kahi za siku ya Sabato ni hizho? Vidze ni kuhenda madzo hedu mai? Vidze mut'u ni athizhe hedu ni alage?” ");
INSERT INTO nyf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bai Jesu akialola osi, gonya akimwamba ye mut'u, “Goloza wo mukonowo hedu.” Ye mut'u akihenda vizho zhenye, naye wo mukonowe ukiuyat'o kamare. ");
INSERT INTO nyf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ela o alimu a Sheria na o Mafarisayo marihosikira gago matsukirwa vii-vii, makiuzana o enye kwa enye na kuamba, “Yuno be fundamuhendadze?” ");
INSERT INTO nyf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Bai kahi za siku zizo, Jesu wauka na achenda kut'u mirimani achendavoya. Naye wachesa kumuvoya Mulungu kuko hatha ngh'aa. ");
INSERT INTO nyf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ndo kurihokala kudzacha akiaiha o anafundzie na akitsagula kumi na airi kahi zao na akiap'a dzina ra ahumwi. ");
INSERT INTO nyf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bai ao arioatsagula were ni Simoni ariye Jesu wamup'a dzina ra P'et'ero, na nduguye ariyeifwa Anderea. Angine were ni Jakobu, na Johana, na Filipu, na Bath'olomayo, ");
INSERT INTO nyf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na Math'ayo, na T'omasi, na Jakobu mwana wa Alifayo, na Simoni ariyeifwa Muhehezi, ");
INSERT INTO nyf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na Juda mwana wa Jakobu, na Juda Isikariote ambaye badaye wakudzamusaliti Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Badaye Jesu watharamuka hamwenga nao na achendaima hat'u hariho ha th'ambarare. Bai haho hakikala hadzakundzumanyika kundi bomu ra o anafundzie na at'u angine anji zhomu mario angine were madzambola Jerusalemu na sehemu nyingine zosi za Judea, na angine were madzambola p'wani za midzi ya Tiro na Sidoni. ");
INSERT INTO nyf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","At'u aa makudza kwamba mamusirikize Jesu na mahozwe makongo gao. Na ao mario were manabudzywa ni p'ep'o mahozwa. ");
INSERT INTO nyf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na kidza o at'u osi majeza here madimazho mamugut'e Jesu, kwa kukala nguvu were zikambola ko kwakwe na kuhoza at'u osi. ");
INSERT INTO nyf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Gonya Jesu akialola o anafundzie na akiamba, “Baha ninwi akiya, mana wo uthawali wa Mulungu ni wenu. ");
INSERT INTO nyf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Baha ninwi murio vivi kare muna ndzala, mana mundakushwa. Baha ninwi murio vivi kare munarira, mana mundatseka. ");
INSERT INTO nyf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Baha ninwi, at'u makimumena na kumuthenga-thenga na kumuhukana na kumukahala here at'u ai, kwa ut'u wa ye Mwana wa Mudamu. ");
INSERT INTO nyf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Bai maut'u gago gandihomudzirira be hendani raha na muguluke-guluke na raha, kwa kukala zawadi yenu ni bomu kuko mulunguni. Mana vizho ndo o akare enu marizhoahendera o manabii ho kapindi. ");
INSERT INTO nyf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ela shauri yenu ninwi murio ashaha, mana mundakala mwarya raha yenu kare. ");
INSERT INTO nyf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Shauri yenu ninwi murio vivi mukusi, mana mundasikira ndzala. Shauri yenu ninwi murio vivi munapiga kw'akw'a, mana mundapiga yapiyowe na kurira. ");
INSERT INTO nyf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Shauri yenu, o at'u osi makimbola na kunena madzo-madzo dzulu zenu, mana o akare ao pia manena madzo-madzo dzulu za o manabii a ulongo.” ");
INSERT INTO nyf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesu akienderera kunena akiamba, “Ela namwambira vivi ninwi murio munasirikiza, ahendzeni mahadhui enu, kidza ahendereni madzo aryahu mario madzamumena. ");
INSERT INTO nyf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Avoyereni madzo ao mario manamuvoyera mai, na o mario manamuhendera mai, avoyereni. ");
INSERT INTO nyf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mut'u akikupiga kofi nyendze mwenga, mugaluzire yo nyendze nyingine nayo apige. Mut'u akikuhoka ambaro, murichire hatha yo k'andzuyo. ");
INSERT INTO nyf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mut'u akikuvoya kit'u, mup'e, na mut'u akikuhoka vit'uzho, usimale kuujirwa. ");
INSERT INTO nyf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Viryahu ambazho mungahendza at'u mamuhendere, ninwi nanwi ahendereni vizho zhenye. ");
INSERT INTO nyf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Vikikala mundaahendza kare o mamuhendzao ninwi, be zho hatha vindamufwahani? Mana hatha o at'u mario k'amakimulungu kidza nao manaahendza asena ao. ");
INSERT INTO nyf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na mukiahendera madzo aryahu mamuhenderao madzo, be zho vindamufwahani? Mana vizho ndo mahendazho hatha ao at'u mario k'amakimulungu. ");
INSERT INTO nyf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na vikikala mundaakopesha aryahu ambao muna th'amaa kukala mandamuriha, be zho vindamufwahani? Mana hatha o at'u masiomumanya Mulungu, kidza nikukopeshana, kuno th'amaa yao ni kurifwa kamili. ");
INSERT INTO nyf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ela hat'u ha vizho ahendzeni mahadhui enu, ahendereni madzo, na kidza muakopeshe hasiho kukala na th'amaa ya kurifwa chochosi. Mukihenda vizho zawadi yenu indakala bomu, na kidza mundakala ana a Mulungu ariye dzulu ya zhosi. Mana Mulungu nikuonera mbazi at'u masioshukuru na at'u ai. ");
INSERT INTO nyf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kwa vizho bai kalani na mbazi dza Babiyenu arizho na mbazi.” ");
INSERT INTO nyf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Bai Jesu waenderera kunena akiamba, “Musiahukumu andziyenu, p'ore nanwi mukahukumiwa. Musilaumu andziyenu, p'ore nanwi mukalaumiwa. Sameheni andziyenu, ndo nanwi mundasamehewa. ");
INSERT INTO nyf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Lazhani, nanwi mundagerwa, mundagerwa kipimo kidzo cha kuhenda kusindirirwa, na kusukwasukwa hatha vingine vimwagike. Na kipimo kiki ndicho mundichogerwa mikononi mwenu. Mana cho kipimo mupimiracho andziyenu ndicho mundichopimirwa ninwi.” ");
INSERT INTO nyf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Gonya akiambozera fumbo riri akiamba, “Vidze kipofu anadima kumugwira mukono kipofu mwandziwe? Hatha! Akihenda vizho osi airi mandavoromoka winani. ");
INSERT INTO nyf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mwanafundzi k'adima kumukira mwalimuwe, ela kila mut'u andihokala adzafundishwa jeri-jeri, anadima akakala here mwalimuwe. ");
INSERT INTO nyf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mbona unaona kinyalu kiricho dzitsoni mwa mwandziyo, ela gogo ririro dzitsoni mwako mwenye k'urisikira? ");
INSERT INTO nyf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Unadimadze kumwamba nduguyo, ‘Huma, mwanehu nikwamboze kinyalu,’ na kuno we mwenye una gogo zima mo dzitsoni mwako na k'urisikira. Ii! Mudzihendyi we! Andza kuromboza ro gogo ririro mo dzitsoni mwako kwandza, ndo undihoonat'o hatha udime kumboza cho kinyalu kiricho dzitsoni mwa mwandziyo.” ");
INSERT INTO nyf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mana k'akuna muhi mudzo uzhalao matunda mai, hedu muhi mui uzhalao matunda madzo. ");
INSERT INTO nyf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kwani kila muhi unamanyikana kwa go matunda uzhalago. At'u k'amahuta t'ini kula kahi za mihi ya miya hedu kuhuta zabibu kula kahi za vihundu zha miya. ");
INSERT INTO nyf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mut'u mudzo nikuzhala madzo kula kahi za akibaye mbidzo iriyo moyoni mwakwe. Mut'u mui naye nikuzhala mai kula kahi za akibaye mbii. Mana kanwa ka mut'u kanena garyahu gadzigowadzala moyowe.” ");
INSERT INTO nyf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesu akienderera kunena akiamba, “Mbona munaniha, ‘Bwana! Bwana!’ na kuno go ninenago k'amugahenda? ");
INSERT INTO nyf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Hedu humani nimwambire viryahu mut'u yuyahu asikiraye maneno gangu na kugahenda arizho. ");
INSERT INTO nyf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mut'u wa samupuli ii adzahalana na muaki wa nyumba ariyetsimba musinji mure, na akiaka nyumbaye dzulu za mwamba. K'uzhona zho muretho urihokudza, ukiisukuma yo nyumba, ela hatha kusumba kwenye k'aisumbire, mana yere yaakwat'o. ");
INSERT INTO nyf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ela bai mut'u agasikiraye maneno gangu na kutsagathuwa, adzahalana na mut'u ariyeaka nyumbaye ho ts'i hasiho musinji. Vikara wakathi muretho urihokudza thu, nyumba iyo ikigwa kare, na kubandikakwe kwakala kubomu.” ");
INSERT INTO nyf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bai Jesu arihogonya kunena maut'u gago arigokala anaambira at'u, wauka na achenda Kaperinaumu. ");
INSERT INTO nyf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Vikara kuko Kaperinaumu kwere kuna mubomu mumwenga wa jeshi ra Kirumi, ariyekala na muhumiki amuhendzaye jeri-jeri. Bai muhumiki yuyu were ni mukongo hatha k'amanyikana kuthia. ");
INSERT INTO nyf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","K'uzhona zho yuyahu mubomu wa jeshi arihosikira uv̱oro wa Jesu, wahuma athumia a Kiyahudi mende makamwambe adze amuhoze ye muhumiki. ");
INSERT INTO nyf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bai marihofika kwa Jesu, mamusitira makiamba, “Mut'u yuyu ana hachi ya uwe umwavize, ");
INSERT INTO nyf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mana anaahendza o at'u ehu na kidza nde ariyehuakira Sinagogi rehu.” ");
INSERT INTO nyf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kwa vizho Jesu achenda hamwenga nao. Ela arihofika hehi na yo nyumba, ye mubomu wa jeshi akihuma asenae makamwambe Jesu vivi, “Bwana, usidzibudzye bule, mana mimi siv̱irya kukala uwe udze wangire nyumbani mwangu, ");
INSERT INTO nyf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ndosa sidzire kwako mimi mwenye. Ela nena neno na muhumiki wangu andahola. ");
INSERT INTO nyf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kwani mimi nami naikwa ts'ini za abomu angu, kidza nina shikari mario ts'ini zangu. Nikimwamba mumwenga, ‘Enda hat'u hasiku,’ anenda. Na yoyosi nindiyemwamba ‘Ndzo,’ anadza. Nikimwamba muhumiki wangu ‘Henda ut'u usiku,’ anauhenda.” ");
INSERT INTO nyf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesu arihosikira maneno gago wangalazwa ni ye mut'u, na akigalukira ro kundi ra at'u mariokala manenda osi, akiamba, “Ninamwambira kukala sidzangwe kuona mut'u mwenye kuluhiro dza riri hatha kahi za ts'i ya Iziraeli.” ");
INSERT INTO nyf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bai aryahu at'u mario were madzahumwa mauya ko nyumbani na machendamuthekeza ye muhumiki k'ana ut'u. ");
INSERT INTO nyf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","K'avitoere, Jesu achenda kahi za mudzi uifwao Naini, iye hamwenga na anafundzie na kundi bomu ra at'u. ");
INSERT INTO nyf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bai marihofika hehi na wo muv̱irya wa wo mudzi lola makithunganana na at'u mario were madzatsukula maithi. Mut'u yuyu were wazhalwa iye thu, na mameye were ni gungu. Bai kundi bomu ra at'u kula kahi za wo mudzi were ri hamwenga na yuyahu mwanamuche. ");
INSERT INTO nyf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bwana Jesu arihomona ye mameye ye mufwa, moyowe wamutika madzi na akimwamba, “Usirire m'ama.” ");
INSERT INTO nyf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Gonya akigasongerera garyahu machera na akigagut'a na aryahu at'u mario were madzagatsukula makiima thii. Jesu akiamba, “We muthana hedu ungarara!” ");
INSERT INTO nyf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Lola ye mufwa waungarara na akikeresi na akikwatya kunena, bai Jesu akimuhala na akimulazha kwa mameye. ");
INSERT INTO nyf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kuona vizho o at'u osini mariokala haho madzalwa ni woga na makimulika Mulungu na kuamba, “Nabii mubomu adzafwambolera.” Kidza makiamba, “Mulungu adzire aokola at'ue.” ");
INSERT INTO nyf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bai uv̱oro uu dzulu za Jesu watsamuka kahi za ts'i yosi ya Judea, na hatha kungine-kungine. ");
INSERT INTO nyf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bai Johana achambirwa ni o anafundzie dzulu za maut'u gaga gosi. Ndo akiiha anafundzie airi ");
INSERT INTO nyf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na akiahuma mende makamuze ye Bwana Jesu chamba nde iye aambwaye andakudza hedu seye matharize mungine. ");
INSERT INTO nyf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bai aryahu ahumwi marihofika kwa Jesu maamba, “Johana Mubat'izaji adzahuhuma hudze hukuze, chamba ndiwe ye mut'u aambwaye andakudza hedu siwe hutharize mungine?” ");
INSERT INTO nyf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na lola wakathi uwo wenye Jesu were anahoza at'u anji mariokala ni akongo manalumwa, na kidza wahoza anji mario were mana p'ep'o. Jesu vizho waahendya at'u anji mario were ni vipofu madime kuona. ");
INSERT INTO nyf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kwa vizho akiadzigidzya o at'u mariokala madzahumwa ni Johana akiamba, “Uyani na mukamwambire Johana garyahu mudzigogaona na kugasikira, kwamba, vipofu manaona, virema manazhogat'o, at'u enye mahana manahozwa, enye masikiro ga makoto manasikira, nyufu zinafufulwa na Uv̱oro Udzo unaambirizwa at'u mario ni akiya. ");
INSERT INTO nyf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Baha mut'u yuyahu ambaye mahendo gangu kwakwe k'agandakala kikwazo.” ");
INSERT INTO nyf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bai bada ya aryahu at'u mario were madzahumwa ni Johana kuuka, Jesu wakwatya kunena na riryahu kundi ra at'u dzulu za ye Johana, akiamba, “Harya murihokwenda nyika, were mudzakwendalolani? Vidze were mudzakwendalola nyasi zifuswazo ni p'eho? ");
INSERT INTO nyf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bai ikikala si vizho vikara were mudzakwendalolani? Hedu were munalola mut'u adziyevwala nguwo mbidzo? Hatha bule! Mana at'u mavwalao nguwo za gali na kuishi maisha ga dzulu makala kahi za madzumba ga athawali. ");
INSERT INTO nyf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Vikara nambirani were mudzakwendalolani? Were mudzakwendalola nabii? Ee, ni jeri, namwambira kamare iye adzakira nabii, iye wahumwa ni Mulungu adze anene dzulu za ye Masihi. ");
INSERT INTO nyf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iye nde ariye Maoro gaorwa dzuluze kuamba, ‘Lola ninahuma mujumbe wangu mberezo, andiyekutengezera ngirayo kimbere.’ ");
INSERT INTO nyf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kunena wo ujeri, kahi za anadamu osi be k'akuna mut'u ariye ni mubomu kuriko Johana. Ela bai iye mut'u ariye nde muthithe kamare kahi za uthawali wa Mulungu be ni mubomu hatha kuriko iye Johana.” ");
INSERT INTO nyf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Lola o at'u osini na hatha o athozi a kodi mamusikira Johana. Na ao bai ni aryahu ambao makubali kukala yo ngira ya Mulungu ni jeri, kwa kukala were mabat'izwa ni Johana. ");
INSERT INTO nyf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ela o Mafarisayo na alimu a Sheria makahala mupango ario Mulungu waapangira na makikahala kubat'izwa ni Johana.” ");
INSERT INTO nyf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesu akienderera kunena akiamba, “Ano at'u a siku zino hatha be ndaahalanisha na noni? Hatha madzahalana na noni ano? ");
INSERT INTO nyf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","At'u aa madzahalana na ahoho mario makeresi sokoni manazaziga. Kundi mwenga nikurambira ro ringine vivi, ‘Hudzamupigira kivoti, nanwi k'amuvinire; Hudzamuimbira wira wa hanga, nanwi k'amuririre.’ ");
INSERT INTO nyf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mana Johana Mubat'izaji arihokudza, mut'u iye wakala k'arya hedu hatha kunwa divai, ela ko mukiamba, ‘Ana p'ep'o.’ ");
INSERT INTO nyf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana wa Mudamu arihokudza na akikala anarya na kunwa, mukiamba, ‘Muloleni adzatona, kidza ni murevi, na anapatana na athozi a kodi na hatha at'u enye dambi.’ ");
INSERT INTO nyf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ela bai ulachu wa Mulungu unamanyikana kala ni wa jeri kukirira kwa osi mario manaukuluhira.” ");
INSERT INTO nyf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Vikara mut'u mumwenga ariye were ni Farisayo wamusunga Jesu ende akarye chakurya ko kwakwe nyumbani. Bai Jesu achenda na achendakeresi ho chakuryani. ");
INSERT INTO nyf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Bai lola kahi za mudzi uwo were kunatoa mwanamuche ariyekala maishage ni ga dambi. Vikara arihosikira kukala Jesu a kuko kwa ye Farisayo anarya chakurya, wauka na achenda na ts'azi iriyotengezwa kula kwa iwe ra alabasita ya mafuha ga marashi. ");
INSERT INTO nyf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Arihofika kuko, akiima hehi na Jesu kuno anarira, bai go matsozige gakidweka mo maguluni mwa Jesu. Ye mwanamuche akigahangusa na zo nyereze, akigadonera go maguluge kunyesa ishima, gonya akigamwagira go marashi. ");
INSERT INTO nyf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Vikara yuyahu Farisayo ariyekala nde adzemusunga Jesu arihoona maut'u gago, akinena kimoyo-moyo akiamba, “Kala mut'u yuyu ni nabii jeri, akamanya kare, kala iye adziyemugut'a ni h'ani na kidza ni mut'u wa samupuli yani, akamanya kukala ni mudambi.” ");
INSERT INTO nyf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ndo Jesu akimwamba ye Farisayo akiamba, “Simoni, nina ut'u nimalao kukwambira.” Ye Farisayo akidzigidzya akiamba, “H'aya nambira mwalimu.” ");
INSERT INTO nyf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Bai Jesu akiamba, “Kwereko at'u airi mario were manaiswa ni mut'u mumwenga ariyekala waakopesha. Mumwenga were anaiswa dinari magana matsano na ye mungine ye were anaiswa dinari mirongo mitsano. ");
INSERT INTO nyf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Vikara osini airi makishindwa ni kumuriha, mana were k'amana kit'u. Bai yuyahu ariyekala anaaisa akiona baha aasamehe. H'aya unaona ni h'ani kahi za o airi ariye andamuhendza ye ariyeasamehe zaidhi?” ");
INSERT INTO nyf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ye Simoni akidzigidzya akiamba, “Naona ni yuyahu ariyesamehewa dheni bomu.” Jesu akimwamba, “U mujeri.” ");
INSERT INTO nyf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bai Jesu akigaluka akimulola ye mwanamuche na akimwamba ye Simoni, “Unamona yuno mwanamuche? Nidzihokudza mumu mwako nyumbani k'unangizirire madzi ga kuoga magulu, ela yuno ye adzagalwanya magulu gangu na go matsozige gonya akagahangusa na zo nyereze. ");
INSERT INTO nyf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nidzihongira haha k'unikaribishire kwa kunidonera, ela yuno mwanamuche ye adzadonera magulu gangu hangu nidzihongirira haha. ");
INSERT INTO nyf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Uwe k'unimwagirire mafuha ga kitswani, ela yuno ye adzagamwagira magulu gangu marashi. ");
INSERT INTO nyf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kwa ut'u uu bai, namala nikwambe vivi, gago mahendzo ga kwakwe mabomu, be vinanyesa kamare kukala zo dambize nyinji zidzasamehewa. Ela mut'u ariye adzasamehewa dambi ch'ach'e nde mwenye hendzo thithe.” ");
INSERT INTO nyf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Gonya Jesu akimwamba ye mwanamuche, “M'ama dambizo zidzasamehewa.” ");
INSERT INTO nyf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","K'uzhona zho aryahu ajeni angine mario were ma ho chakuryani makikwatya kuuzana-uzana na kuamba, “Ni h'ani yuno ariye anasamehe hatha dambi?” ");
INSERT INTO nyf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na Jesu akimwamba ye mwanamuche, “Kuluhiro ra kwako ridzakwakola, h'aya enda na dheri.” ");
INSERT INTO nyf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bada ya gago, Jesu wakwenda kuno na kuno kahi za midzi kuhubiri Uv̱oro Udzo wa uthawali wa Mulungu. Naye were a hamwenga na aryahu ahumwie kumi na airi, ");
INSERT INTO nyf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na ano m'ama angine ambao were Jesu waamboza p'ep'o na kuahoza makongo gao. Ano m'ama aa were ni Maryamu (ariyekala anaifwa Magidalena) ambaye were wambozwa p'ep'o afungahe ho nyuma-nyuma, ");
INSERT INTO nyf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana ariye were ni mukaza Kuza, (iye Kuza were ni mwimirizi kahi za nyumba ya muthawali Herode), na Suzana, na ano m'ama angine anji. Ano m'ama aa makala kazi yao ni kumboza vit'u zhao kwa ut'u wa kumwaviza Jesu hamwenga na anafundzie. ");
INSERT INTO nyf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bai siku mwenga makundi ga at'u kula kahi za kila mudzi were ganamukundzumanyikira, vikara marihokala madzakundzumanyika hatha madzafika anji enye, Jesu waambozera fumbo riri akiamba, ");
INSERT INTO nyf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mut'u mumwenga wauka kwendamwaga-mwaga mbeyuye mundani kwakwe. Bai arihokala akuzimwagani-mwagani, nyingine zagwa k'anda-k'anda ya ngira, zikizhogwa-zhogwa na unyama wa kubururuka ukidzazit'ot'a. ");
INSERT INTO nyf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nyingine zikigwa iweni, bai zirihoandza kumera zikinyala kwa kukala were k'ahana kinemi. ");
INSERT INTO nyf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mbeyu nyingine zikigwa miyani, bai zirihokala zinakula, yo miya nayo yakula na ikizizia-zia hatha k'azipatire nafasi ya kumbola ndze. ");
INSERT INTO nyf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ela nyinginezo zikigwa kahi za mutsanga mudzo, nazo zikimerat'o na zikizhala, kila t'embe ikizhala t'embe gana zaidhi.” Jesu akimarigiza kwa kunena zhomu akiamba, “Mwenye masikiro ga kusikirira, naasikire.” ");
INSERT INTO nyf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kusikira vizho o anafundzie makimuza makiamba, “Mana ya ro fumbo ni noni?” ");
INSERT INTO nyf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesu akiamba, “Ninwi mwajaliwa kuzimanya zo siri za uthawali wa Mulungu, ela kwa at'u angine ninanena kwa mafumbo, ili ‘malole, ela masione, masikize, ela masing'alirwe.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Bai mana ya ro fumbo riri ni ii: Ziryahu mbeyu ni neno ra Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ziryahu mbeyu zirizogwa k'anda-k'anda ya ngira ni aryahu at'u masikirao neno ra Mulungu, gonya Shethani nikudza akadzarusa kula kahi za mioyo yao, ili masidze makakuluhira na kuokoka. ");
INSERT INTO nyf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ziryahu mbeyu zirizogwa iweni, ni aryahu at'u mario makisikira neno thu, manarihokera kare mara mwenga, kidza manarihokera na raha, ela kwa k'amana miziji, manakuluhira kare kwa muda na majezwaho, manaviricha. ");
INSERT INTO nyf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ziryahu mbeyu zirizogwa miyani manaye ni aryahu at'u masikirao neno ra Mulungu, ela badaye maukaho, riryahu neno rinendakonywa-konywa ni maut'u ga urumwengu, ushaha, na raha za maisha, kwa ut'u uwo, k'amakumala bule. ");
INSERT INTO nyf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ela ziryahu mbeyu zirizogwa kahi za mutsanga mudzo, ni aryahu mario makisikira neno ra Mulungu manarigwira kwa uaminifu na mioyo midzo, nao kwa kuvumirira ni kuzhala matunda.” ");
INSERT INTO nyf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesu akienderera kunena akiamba, “K'akuna mut'u agwizaye taa, gonya akaribiningiza na muvure hedu hatha kurika muvunguni. Ela nikurika nyambaroni, ili kila angiraye aone wo mulangaza. ");
INSERT INTO nyf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mana k'akuna kit'u kirichofitswa, ambacho kindarichwa vizho hasiho kumbozwa halamu, na k'akuna kit'u kiricho kidzabiningizwa, kindichorichwa hasiho kumanywa hedu kumbozwa ndze. ");
INSERT INTO nyf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kwa vizho bai, dzimanyirireni na yo misirikizire yenu. Mana kila ariye nacho andangezwa, na ye ariye k'ana kit'u, andahokwa hatha kiryahu aricho anadziona anacho.” ");
INSERT INTO nyf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Siku mwenga mameye, na nduguze Jesu a kilume, makwenda kwamba makamone, ela marihofika k'amadimire kumusongerera hehi kwa ut'u wa ro kundi ra at'u ririrokala haho. ");
INSERT INTO nyf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ndo hachambola mut'u akimwamba Jesu, “Mameyo na nduguzo manakumala ko ndze.” ");
INSERT INTO nyf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kusikira vizho Jesu akiadzigidzya o at'u akiamba, “M'ama na ndugu zangu, ni aryahu masikirao neno ra Mulungu na kuhenda here riambazho.” ");
INSERT INTO nyf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Siku mwenga, Jesu wangira dauni na anafundzie akiambira, “Nahuvuke hedu fwende nyangamo nyingine ya ziya.” Kwa vizho makiuka machenda. ");
INSERT INTO nyf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bai marihokala makuvukani, Jesu wanyekererwa mo dauni na akilala. K'uzhona zho kukidza luv̱utho lwa kitai mo ziyani hatha ro dau rikikwatya kudzala madzi, nao mere ma hatharini. ");
INSERT INTO nyf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bai aryahu anafundzi machendamulamusa Jesu makiamba, “Bwana! Bwana! Funahoha!” Ndo Jesu akilamuka akiluchemera lo luv̱utho na go maimbi, na lo luv̱utho hu lukihurira. ");
INSERT INTO nyf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesu akiauza o anafundzie akiamba, “Ro kuluhiro renu be hatha ri hiko?” Bai makingalala na makidzalwa ni woga kidza makikwatya kuuzana-uzana na kuamba, “Yuno ni h'ani yuno? Analagiza hatha luv̱utho na madzi nazho vinamusikira.” ");
INSERT INTO nyf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bai Jesu na anafundzie maenderera na charo chao na makifika ts'i ya Agerasi. Ts'i ii inalolana na Galilaya. ");
INSERT INTO nyf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesu arihothima mo dauni thu, akithunganana na mut'u kula kahi za mudzi uwo ariyekala ana p'ep'o. Mut'u yuyu were ho arihohegezera kuvala nguwo hedu kwenda mudzini k'ahamanya, mana were akala makaburini. ");
INSERT INTO nyf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bai arihomona Jesu, wapiga k'ululu na akidzigwaga maguluni ha Jesu, akiluta mumirowe akiamba, “Unani nami we Jesu Mwana wa Mulungu ariye dzulu ya zhosi? Ninakuvoya usinitese.” ");
INSERT INTO nyf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Naye wanena vivi kwa kukala Jesu were adzamwamurisha ye p'ep'o amwambole ye mut'u. Mara nyinji ye p'ep'o were akamugwaga na vingahokala were akafungwa minyororo ya magulu na mikono na kuikwa kahi za urindzi, iye were ni kusita hatha akaitosa iryahu minyororo na ye p'ep'o akamuhendya ende nyika. ");
INSERT INTO nyf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesu akimuza akiamba, “Dzinaro ndiwe h'ani?” Ye p'ep'o akiamba, “Majeshi.” Naye wadzigidzya vivi kwa kukala were wangirwa ni p'ep'o anji. ");
INSERT INTO nyf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bai aryahu p'ep'o makimudhedheja Jesu kukala asiaamurishe kwenda kahi za ridzina risiro mwisho. ");
INSERT INTO nyf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Vikara haho were hana ribadhi ribomu ra nguluwe rinarisa k'anda-k'anda za karima. Bai o p'ep'o makimuvoya aaruhusu mende makaangire o nguluwe, na Jesu akiaruhusu. ");
INSERT INTO nyf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bai aryahu p'ep'o makimwambola ye mwanamulume, na machendaangira o nguluwe, na ro badhi ra nguluwe rikitharamuka malo kula ko ngokani rikivoromoka mo ziyani rikihoha. ");
INSERT INTO nyf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aryahu arisa kudzaona vizho virizhokala vidzahendeka, machimbira na machendasema uv̱oro uu ko midzini na mindani. ");
INSERT INTO nyf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bai o at'u duu machendalola zho virizhokala vidzahendeka. Marihokudza kwa Jesu makimona ye ariyekala adzambozwa p'ep'o akelesi ho maguluni ha Jesu na adzavala nguwo kidza akilize ni ndzima. Kuona vizho o at'u makingirwa ni woga. ");
INSERT INTO nyf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aryahu mariokala madzazhona zho virizhokala vidzahendeka, makiambira o at'u zho ye mut'u ariyekala wapagawa ni p'ep'o arizhokala adzahozwa. ");
INSERT INTO nyf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gonya o at'u osi a ro jimbo riro ra Agerasi makimwamba Jesu aahaukire, mana were mathele woga. Bai Jesu achangira dauni na akihauka. ");
INSERT INTO nyf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ela kabila ye Jesu k'adzauka ye mut'u ariyekala adzambozwa p'ep'o wamuvoya Jesu akiamba, “Nahendza nikuthuwe.” Ela Jesu akimulaga na kuamba, ");
INSERT INTO nyf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uya kwenu ukaseme garyahu adzigokuhendera Mulungu.” Kwa vizho ye mut'u achenda kahi za wo mudzi muzima na kuambira at'u garyahu arigokala adzahenderwa ni Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bai Jesu arihouya yo nyangamo nyingine ya ro ziya, wakaribishwa ni kundi bomu ra at'u, mana ao were manamuthariza. ");
INSERT INTO nyf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na lola, hakidza mut'u mumwenga aifwaye Jairo. Mut'u yuyu were ni mubomu wa sinagogi. Bai arihofika wadzigwaga maguluni ha Jesu na akimuvoya afike ko nyumbani kwakwe. ");
INSERT INTO nyf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mana were ana musichanawe, wa here miaka kumi na miri vivi, ariyekala were akufwani. Bai Jesu arihokala akwendani kwa Jairo o at'u were manamuhosha. ");
INSERT INTO nyf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mwanamuche mumwenga ariyekala adzakala mukongo wa kumbola milatso, kwa miaka kumi na miri na k'ahana ariyedima kumuhoza, ");
INSERT INTO nyf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","wakudza nyuma za ye Jesu na akigut'a wo mutsa wa ro valo ra Jesu, na lola haho henye yo milatso ikithuma kare. ");
INSERT INTO nyf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesu akiuza akiamba, “Ni h'ani ye adziyenigut'a?” Ela o at'u osi k'ahana hatha mumwenga ariyeamba, “Ndimi.” Ndo P'et'ero akimwamba, “Mwalimu, at'u anji aa mario madzakuzunguluka hatha manakukwala-kwala, ela unauza ni h'ani adziyekugut'a!” ");
INSERT INTO nyf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ela Jesu akiamba, “Hana mut'u adziyenigut'a, mana nasikira nguvu zidzanambola.” ");
INSERT INTO nyf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ndo yuyahu mwanamuche arihoona kukala adzamanyikana wakwenda kwa Jesu kuno anavinwa ni mwiri na akigwa ho mbereze. Bai akinena mbere za o at'u osi viryahu virizhokala vidzamuhendya hatha akamugut'a na viryahu arizhokala adzahola saa iyo-iyo. ");
INSERT INTO nyf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ndo Jesu akimwamba, “Mwanangu kuluhiro ra kwako ridzakuhoza. Enda na dheri.” ");
INSERT INTO nyf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Naye arihokala achere kunena, poo mut'u ariyekala adzambola nyumbani kwa ye mubomu wa sinagogi na akimwamba Jairo, “Ye musichanao be adzamarigizika, kwa vizho k'ahana haja ya kumubudzya ye mwalimu.” ");
INSERT INTO nyf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesu arihosikira vivi wamwamba Jairo, “Tha usogohe bewe, kuluhira thuwe naye andahola.” ");
INSERT INTO nyf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bai Jesu arihofika kuko mudzini kwa Jairo, k'aruhusire mut'u yoyosi mungine angire mumo hasihokala P'et'ero, Johana, na Jakobu hamwenga na ye bimut'u na mimut'u. ");
INSERT INTO nyf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wakathi uwo o at'u osini were manapiga k'ululu na kurira. Jesu arihoona vizho akiambira, “Musirire bule, ye muhoho k'afwere bule, arere thu.” ");
INSERT INTO nyf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","At'u makimutseka, mana were manamanya kukala ye musichana adzafwa. ");
INSERT INTO nyf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bai Jesu akimugwira mukono akimwamba, “Muhoho, hedu uka!” ");
INSERT INTO nyf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Rohoye ikiuya kaheri na haho henye akirungarara. Gonya Jesu akialagiza mamup'e ut'u wa kurya ye muhoho. ");
INSERT INTO nyf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Azhazie mangalala zhomu, ela Jesu akiambira masimwambire mut'u yoyosi gago gadzigohendeka. ");
INSERT INTO nyf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Badaye Jesu akiaiha aryahu anafundzi kumi na airi, na akiap'a nguvu na wadimi dzulu za p'ep'o osi na kuhoza makongo. ");
INSERT INTO nyf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Gonya akiahuma mende makahubiri Uv̱oro Udzo wa uthawali wa Mulungu na kuhoza akongo. ");
INSERT INTO nyf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akiambira vivi, “Musitsukule chochosi mo charoni. Musitsukule mudhath'a, hedu mukoba, hedu leu, hedu p'esa, hedu k'andzu mbiri. ");
INSERT INTO nyf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba yoyosi mundiyongira na mukaribishwet'o, kalani kahi za nyumba iyo hatha mukale munauka ndo mwambole. ");
INSERT INTO nyf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ela mwangiraho mudzini na o at'u masimukaribishe, bai haukeni na mukut'e-kut'e vumbi ra maguluni mwenu, kunyesa kukala mandamanya enye.” ");
INSERT INTO nyf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kwa vizho o anafundzi makiuka kwenda. Bai machenda kadzidzi kano na kadzidzi karya kuhubiri Uv̱oro Udzo na kuhoza akongo kila hat'u. ");
INSERT INTO nyf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bai muthawali Herode arihosikira dzulu za gago gosi garigokala ganakala, wadangana, mana at'u angine mere manaamba, “Johana Mubat'izaji wafufuka.” ");
INSERT INTO nyf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Angine o makiamba, “Nabii Elija adzatsumbuka,” na angine nao makiamba, “Mumwenga kahi za o manabii a kapindi adzafufuka.” ");
INSERT INTO nyf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ela Herode akiamba, “Johana namutosa kitswa, vikara ni h'ani yuno niriye ninasikira uv̱oro uno dzuluze?” Bai akikala anathamani kumona. ");
INSERT INTO nyf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Vikara aryahu ahumwie marihouya, makudzamwambira Jesu go marigokala magahenda. Bai Jesu akiahala o anafundzie na makihenda nyeree, machenda kahi za mudzi uifwao Beth'isaida. ");
INSERT INTO nyf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ela ro kundi ra at'u rikivimanya vizho, naro rikimuthuwa. Bai Jesu akiakaribisha na akinena nao dzulu za wo uthawali wa Mulungu na kidza akiahoza ao mariokala mana haja ya kuhozwa. ");
INSERT INTO nyf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Vikara dzuwa ririhokala rinenda kutswani aryahu anafundzie kumi na airi mamwendera na makimwamba, “Baha uafumule aa ili mende kahi za midzi na minda iriyo hehi na haha makadzimalire chakurya na ndazi, mana hano be ni nyika t'uhu.” ");
INSERT INTO nyf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesu akiamba, “Ap'eni chakurya ninwi.” Ndo o anafundzie makimudzigidzya makimwamba, “Huna mikahe mitsano na makumba mairi thu labuda fukarigulire riri kundi rosi ra at'u chakurya.” ");
INSERT INTO nyf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Na haho were hana here at'u alifu ts'ano, alume.) Jesu akiambira o anafundzie akiamba, “Ambireni o at'u makeresi kahi za vithundhu zha here at'u mirongo mitsano-mitsano vivi.” ");
INSERT INTO nyf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bai o anafundzie makihenda vizho na o at'u makikeresi osi. ");
INSERT INTO nyf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesu akihala yo mikahe mitsano na go makumba mairi, akilola dzulu mulunguni, akimboza muv̱era kwa Mulungu, gonya akivimogola-mogola na akiap'a o anafundzie maagazhire o at'u. ");
INSERT INTO nyf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nao osi makirya hatha makivilola. Marihogonya kurya o anafundzie makitsola-tsola zho visiku-visiku virizhokala vidzasala na makidzaza k'ahu kumi na mbiri. ");
INSERT INTO nyf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Siku mwenga Jesu were anavoya h'akeye, bai o anafundzie makidza haho. Akiauza, akiamba, “Vidze o at'u manaamba mino ni h'ani?” ");
INSERT INTO nyf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Makidzigidzya makiamba, “Angine manaamba uwe u Johana Mubat'izaji, angine o manaamba, u Elija na hatha angine manaamba u mumwenga wa o manabii a kapindi ariyefufuka.” ");
INSERT INTO nyf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesu akiauza akiamba, “H'aya nwi, munaamba mino ni h'ani?” P'et'ero akiamba, “Uwe ndiwe ye Masihi wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bai Jesu akiakokot'era ili masizhambire mut'u yoyosi. ");
INSERT INTO nyf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesu akienderera kunena akiamba, “Ye Mwana wa Mudamu suthi ateswe sana, na akahalwe ni athumia a Kiyahudi na alombi abomu na alimu a Sheria. Naye suthi alagwe, ela siku ya hahu andafufulwa.” ");
INSERT INTO nyf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Gonya akiambira osi vivi, “Mut'u akihendza kunithuwa mimi, suthi adzikane mwenye, adzihike musalabawe kila siku na anithuwe. ");
INSERT INTO nyf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mana kila amalaye kuthizha rohoye andayangamiza, ela kila andiyeyangamiza rohoye kwa ut'u wangu, nde andiyeithizha. ");
INSERT INTO nyf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kwani vindamufwahani mut'u akipata vit'u zhosi zha urumwengu gonya rohoye yangamike hedu adzanonge mwenye? ");
INSERT INTO nyf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kwani mut'u anioneraye haya hamwenga na gaga mafundisho gangu, bai ye Mwana wa Mudamu andamuonera haya siku iyo andiyokudza kahi za ngumaye mwenye na ya Baba na ya malaika aeri. ");
INSERT INTO nyf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Bai ninamwambira ujeri, haha hana at'u mario k'amandafwa ng'o hatha mawone wo uthawali wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Siku nane bada ya Jesu kunena gaga, wamuhala P'et'ero, Johana na Jakobu, machendakwera dzulu za murima mavoye. ");
INSERT INTO nyf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bai arihokala Jesu akuvoyani yo suraye yagaluka, zo nguwoze zikikala nyaruhe kidza za kung'ala-ng'ala zhomu. ");
INSERT INTO nyf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na lola haho henye hachambola at'u airi, Elija na Musa nao makinena naye. ");
INSERT INTO nyf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nao were manang'ala-ng'ala. Bai at'u ao were mananena na Jesu dzulu za viryahu arizho were andathimiza na kifwache kiricho were kindakala ko Jerusalemu ");
INSERT INTO nyf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","wakathi uwo P'et'ero na andziye were marere uts'indzizi wa fungo ela bai marihong'alwa ni matso, mawona wo mulangazawe hamwenga na aryahu at'u airi mariokala maimire naye. ");
INSERT INTO nyf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Vikara Elija na Musa marihokala manauka, P'et'ero wamwamba Jesu, “Mwalimu ni vidzo zho zha fu haha! Nahuake vidzumba vihahu, kimwenga chako, kimwenga cha Musa na kimwenga cha Elija.” P'et'ero were tha k'amanya ananenani. ");
INSERT INTO nyf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Naye tha were k'adzatosa kukidza ingu rikidzaafinikira, na o anafundzi makigwirwa ni woga marihokala manafinikirwa ni ro ingu. ");
INSERT INTO nyf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mo inguni muchambola mumiro wa mut'u ukiamba, “Yuyu ni Mwanangu niriyemutsagula, musirikizeni iye.” ");
INSERT INTO nyf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bada ya yo sauthi kugonya kunena, o anafundzie mamona Jesu a h'akeye renye. Bai o anafundzie k'amazhambirire mut'u vivi wakathi uwo marihokala madzazhona hatha mathuwa kukala nazho enye. ");
INSERT INTO nyf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Siku ya hiriye, marihokala madzatharamuka kula ko murimani, ngororoki bomu ya at'u yakudzathunganana na Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kahi za yo ngororoki hachambola mwanamulume mumwenga ariyenena zhomu zhenye akiamba, “Mwalimu, nakuvoya umulole yuyu muthana wangu, mana sina mwana mungine. ");
INSERT INTO nyf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Lola ana p'ep'o ariye nikumugwaga na akaandza kupiga k'ululu akamuhendya afitike na ambole fulo ra kanwani. K'avimwendera kure kamare, hatha vinamwanonga bai. ");
INSERT INTO nyf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nidzaasitira o anafundzio mamwamboze ye p'ep'o ela k'amazhadimire.” ");
INSERT INTO nyf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesu akidzigidzya akiamba, “H'enwi at'u a kizhazi cha kwangamika ngira, musio na kuluhiro, nindakala nanwi hatha rini? Hedu nindamuvumirira hatha rini? Murehe kuno ye muthanao.” ");
INSERT INTO nyf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Vikara ye muvulana arihokala anadza ye p'ep'o akimupiga chavu na kufitika, ela Jesu akimuchemera akimwamboza ye p'ep'o, ye muvulana akihola, akimuhala akimulazha kwa babaye. ");
INSERT INTO nyf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na lola o at'u osi makingalazwa kamare ni zo nguvu za Mulungu. Bai marihokala o at'u machere kungalala-ngalala na go arigokala Jesu adzagahenda, iye Jesu waambira o anafundzie akiamba, ");
INSERT INTO nyf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Sirikizani sana gaga nimalago kumwambira. Kwani ye Mwana wa Mudamu andalazhwa mikononi mwa at'u.” ");
INSERT INTO nyf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ela o anafundzie k'amang'alirirwe ni gago arigokala Jesu anaambira. Kwani kwao, were vidzafitswa ili masidime kuvielewa, na kidza ao were ni aoga na kumuza dzulu za gago. ");
INSERT INTO nyf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bai o anafundzie makinenezana dzulu za mubomu ni h'ani kahi zao. ");
INSERT INTO nyf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ela Jesu akigamanya kare go maazo gao, kwa vizho akihala muhoho muthithe akimurungaraza ho hehi naye. ");
INSERT INTO nyf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Gonya akiambira, “Kila amuhokeraye muhoho muthithe dza yuyu kwa dzina rangu, ananihokera mimi, na ye anihokeraye mimi k'anihokera mimi bule, ela anamuhokera iye ariyenihuma, mana ye ariye ni muthithe kahi zenu nyosi be nde mubomu.” ");
INSERT INTO nyf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Johana achambola kunena akiamba, “Bwana, fwaona mut'u anamboza p'ep'o kwa dzinaro, naswi hukimukahaza, kwa kukala si mumwenga wehu.” ");
INSERT INTO nyf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesu akimwamba, “Musimukahaze, mana mut'u ariye k'akinyume chenu, a upande wenu.” ");
INSERT INTO nyf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Vikara siku za Jesu kuhalwa kwenda mulunguni zirihofika hehi, Jesu wakat'a shauri kwenda Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bai akihuma at'u mamuthangulie nao machenda kahi za kadzidzi ka Asamaria ili mamuthayarishire hat'u. ");
INSERT INTO nyf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ela o at'u a kuko makikahala kumukaribisha Jesu kwa kukala were anenda Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","K'uzhona anafundzie airi, Jakobu na Johana marihoona vizho makiamba, “Bwana, unahendza fuihe moho kula mulunguni udze uanonge-nonge ano dza here Elija arizhohenda?” ");
INSERT INTO nyf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ela Jesu akihunduka na akiadumulira, akiamba, “Ninwi k'amumanya ni roho ya samupuli yani yo muriyo nayo. Mana Mwana wa Mudamu k'adzire kudzangamiza maisha ga at'u, ela wakudza kugaokola.” ");
INSERT INTO nyf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bai makiuka na machenda kahi za kadzidzi kangine. ");
INSERT INTO nyf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Vikara Jesu na anafundzie marihokala ma mo ngirani, makwendani, mut'u mumwenga wamwamba Jesu, “Mut'u mimi nindakuthuwa kila undikokwenda.” ");
INSERT INTO nyf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesu akimudzigidzya akiamba, “Makala gana p'anga, na unyama wa kubururuka una vitsunji zhao, ela Mwana wa Mudamu, k'ana hat'u ha kuika mbavu.” ");
INSERT INTO nyf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Badaye Jesu akimwamba mut'u mungine, “Nithuwa.” Ela ye mut'u akidzigidzya akiamba, “Bwana niricha nikamuzike baba kwandza be nidze nikuthuwe.” ");
INSERT INTO nyf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesu akimwamba, “Ariche at'u mariofwa mazike nyufu zao, ela uwe enda ukauhubiri wo uthawali wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mut'u mungine ye akimwamba Jesu, “Mimi nindakuthuwa Bwana, ela niricha kwandza nikaalage adamu angu ko nyumbani.” ");
INSERT INTO nyf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesu akimudzigidzya akiamba, “Mut'u yoyosi agwiraye jembe kurima gonya akalola nyuma k'afwaha kuhenda kazi kahi za uthawali wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bada ya gaga, Bwana watsagula anafundzi angine mirongo mifungahe na airi. Gonya akiahuma airi-airi mende kimbere kahi za kila mudzi na kila hat'u ambaho iye mwenye were k'avindatoa andakwenda. ");
INSERT INTO nyf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Bai akiambira, “Mavuno ni manji, ela ahendzi a kazi ni achache. Kwa vizho bai muvoyeni ye Bwana wa mavuno, ahume ahendzi a kazi madze mavune. ");
INSERT INTO nyf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","H'aya, endani! Lolani ninamuhuma here ana a ng'ondzi kahikahi za mbawa. ");
INSERT INTO nyf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Musitsukule p'ochi, mukoba, hedu virahu. Kidza mo ngirani musingamize wakathi kulamusa-lamusa at'u. ");
INSERT INTO nyf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kahi za nyumba yoyosi mundiyongira kwandza ambani, ‘Dheri narikale kahi za nyumba ii.’ ");
INSERT INTO nyf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bai mukikala muna mut'u wa dheri mumo, be dheri renu rindakala dzuluze na kala k'amuna mut'u wa dheri, bai rindamuuyira enye. ");
INSERT INTO nyf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nanwi toani kahi za nyumba iyo murye na munwe chochosi mandichomwambozera, mana muhendzi wa kazi anav̱irya kupata marihoge. ");
INSERT INTO nyf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mudzi wowosi mundiongira na mukikaribishwa, ryani chochosi mundichombozerwa. ");
INSERT INTO nyf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hozani o akongo mario haho na muambire vivi, ‘Uthawali wa Mulungu udzamufikira hehi.’ ");
INSERT INTO nyf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ela mwangiraho kahi za mudzi na musikaribishwe endani kahi za zo barabaraze na muambe, ");
INSERT INTO nyf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hatha ro vumbi ra uwo mudzi wenu ridzirohugwira, hunarikut'a kunyesa kukala mundamanya enye; kidza manyani vivi, kukala wo uthawali wa Mulungu udzafika hehi.’ ");
INSERT INTO nyf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Bai namwambira kamare kukala siku ya mwisho vindakala vii-vii zhomu kwa mudzi uwo, kukira zho vindizhokala kwa Sodomu.” ");
INSERT INTO nyf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesu akienderera kunena akiamba, “Shauri yenu ninwi at'u a Korazini na Beth'isaida. Kwani kala yo miujiza niriyoihenda ko kwenu be naihenda kahi za midzi ya Tiro na Sidoni be andziyenu ngere mavala nguwo za magunia, na kukala ivuni kapindi kunyesa kuthubu kwao. ");
INSERT INTO nyf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ela yo siku ya hukumu be vindakala baha o at'u a midzi ya Tiro na Sidoni kaheri kuriko ninwi. ");
INSERT INTO nyf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","H'aya, nwi at'u a Kaperinaumu nanwi, munaona mundanulwa hatha mulunguni? Hatha bule, ninwi mundatserezwa hatha kuzimu.” ");
INSERT INTO nyf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesu akiambira o anafundzie akiamba, “Mut'u amusikiraye ninwi, ananisikira mimi, na mut'u amukahalaye ninwi, ananikahala mimi. Anikahalaye mimi, anamukahala iye ariyenihuma.” H'aya makiuka machenda. ");
INSERT INTO nyf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Badaye aryahu anafundzi mirongo mifungahe na airi mauya kuno mana raha makiamba, “Bwana, lola bewe hatha o p'ep'o manahusikira siswi kwa dzinaro.” ");
INSERT INTO nyf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesu akiadzigidzya akiamba, “Namona Shethani anagwa kula mulunguni dza here lumethe. ");
INSERT INTO nyf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lolani, namup'a wadimi wa kuzhoga nyoka na mah'ambini na wadimi wa kuzishinda nguvu zosi za iye hadhui. K'akuna chochosi kindichomulumiza. ");
INSERT INTO nyf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ela hamwenga na vizho musihende raha kwa kukala o p'ep'o manamusirikira, ela hendani raha kwa kukala madzina genu gaorwa ko mulunguni.” ");
INSERT INTO nyf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wakathi uwo Jesu wadzalwa ni fwahiro kukirira na Roho Mweri akiamba, “Nakulazhira muv̱era h'ewe Baba, Bwana wa dzulu na ts'i, kwa kukala maut'u gaga wagafitsa alachu na enye akili, ukigagunulira madanga ga ana. Ni karakara Baba, mana vizho ndizho urizhohendza.” ");
INSERT INTO nyf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesu akienderera kunena akiamba, “Maut'u gosini gaikwa mikononi mwangu ni Baba. K'akuna mut'u amanyaye ye Mwana ni h'ani asihokala ye Baba, na k'akuna mut'u amanyaye ye Baba ni h'ani asihokala ye Mwana na aryahu ambao ye Mwana anahendza kuang'azira ye Baba.” ");
INSERT INTO nyf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Gonya akiagalukira o anafundzie akiambira kinjama akiamba, “Baha ao maonao maut'u gaga mugaonago. ");
INSERT INTO nyf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mana namwambira kamare manabii anji na athawali mathamani kuona gaga mugaonago, ela k'amagaonere, kidza mathamani masikire gago mugasikirago ela k'amagasikirire bule.” ");
INSERT INTO nyf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lola siku mwenga, mwalimu mumwenga wa Sheria warungarara kumujeza Jesu na swali akiamba, “Mwalimu, nihendedze hatha niupate uzima wa kare na kare?” ");
INSERT INTO nyf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesu akimudzigidzya akiamba, “Kwani kahi za yo Sheria, mwaorwani? Na unavishomadze we?” ");
INSERT INTO nyf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Akimudzigidzya akiamba, “ ‘Muhendze Bwana Mulunguo na moyowo wosi, na rohoro rosi, na nguvuzo zosi, na akilizo zosi,’ na ‘Muhendze mwandziyo here udzihendzazho mwenye.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesu akimwamba, “Udzadzigidzya karakara, bai henda vizho nawe undaishi.” ");
INSERT INTO nyf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ela yuyahu mwalimu wa Sheria were anahendza aonekane kukala ro swalire were ni ra mana, kwa vizho akimuza Jesu akiamba, “Na yuno jirani wangu ni hiye?” ");
INSERT INTO nyf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bai kahi za kudzigidzya, Jesu waamba, “Kwere kuna mwanamulume mumwenga ariyembola Jerusalemu na akikala anatharamuka kwenda Jeriko. Bai mumo ngirani akigwavukirwa ni akora nao mamupiga na makimuhoka zo nguwoze na makimuricha haho ngirani k'adzimanya, gonya thio, machenda. ");
INSERT INTO nyf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kwa bahathi mbidzo mulombi mumwenga akitharamuka na ngira iyo vizho, ela arihomona be hatha wahenda kukira na k'anda kamare. ");
INSERT INTO nyf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bai Mulawi naye arihofika haho na kumona ye mut'u, wahenda vizho zhenye naye, wakira na k'anda. ");
INSERT INTO nyf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ela Musamaria mumwenga ariye hatha si Muyahudi kamare were a kahi za safarize arihofika haho arihokala ye mut'u, wadzalwa ni mbazi arihomona. ");
INSERT INTO nyf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Bai akimusongerera na achendamumwagira mafuha na divai mo marangani na akimufunga bandeji. Vikara yuyahu Musamaria were ana ndzowewe, bai wamuhala ye mupigwa na akimukweza kahi za ndzowe wa kwakwe na achenda naye vivii muhaka kahi za nyumba ya kukala asafiri ambako wakwendamutsundzat'o. ");
INSERT INTO nyf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Siku ya hiriye ye Musamaria wamboza p'esa akimup'a ye mwenye yo nyumba ya kukala asafiri na akimwamba, ‘Mutsundze yuyu, na kukikala na garama zozosi nyingine, ndakudza nikuujire haho nikikala nidzauya.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Gonya Jesu akimuza ye mwalimu wa Sheria akiamba, “Vikara kahi za ano ahahu, unaona ni h'ani we ariye wakala ni jirani wa ye ariyegwavukirwa ni akora?” ");
INSERT INTO nyf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ye mwalimu wa Sheria akidzigidzya akiamba, “Ni yuyahu ariyemuonera mbazi ye mut'u.” Jesu akimwamba, “H'aya uwe nawe enda ukahende dza vizho.” ");
INSERT INTO nyf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesu na anafundzie marihokala ma kahi za safari zao, mafika kahi za kadzidzi kamwenga, bai mwanamuche mumwenga aifwaye Marith'a akimukaribisha ko kwakwe mudzini. ");
INSERT INTO nyf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marith'a yuyu were ana nduguye aifwaye Maryamu. Maryamu wathuwa kukeresi ho ts'i hehi na magulu ga Bwana kumusirikiza gago arigokala ananena. ");
INSERT INTO nyf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ela Marith'a akikala anabudzyika na zo kazi za kuathayarishira o ajeni. Kwa vizho achenda kwa Jesu, achendamwamba, “Bwana, k'ujali we zho zha kukala yuno ndugu yangu adzanirichira kazi zosini h'akiyangu? Mwambe adze anavize!” ");
INSERT INTO nyf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ye Bwana akimudzigidzya akiamba, “Marith'a asena, una wasiwasi na kubudzyika na maut'u manji, ");
INSERT INTO nyf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ela ut'u uriwo unahendzekana ni ut'u umwenga thu, Maryamu adzatsagula kit'u ambacho ni kidzo zaidhi nacho k'andakihokwa kamare.” ");
INSERT INTO nyf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Siku mwenga Jesu were a hat'u anavoya. Bai arihogonya ko kuvoya, mumwenga kahi za o anafundzie akimwamba, “Bwana, hufundishe kuvoya, here Johana naye arizhoafundisha anafundzie.” ");
INSERT INTO nyf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Bai Jesu akiambira, “Kala munavoya ambani, ‘Baba, Uriye ko mulunguni, Dzinaro narikale rieri, Uthawaliwo naudze, Mahendzogo nagahendeke kuku ts'i, here gahendekazho ko mulunguni. ");
INSERT INTO nyf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kila siku hup'e chakurya chehu cha kuhuthosha. ");
INSERT INTO nyf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Na uhusamehe makosa gehu, kwani siswi naswi hunaasamehe osi mahukosao. Na usihuhirike majezoni, ela fuokole na ye Mui.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kidza Jesu akiambira o anafundzie akiamba, “Fuambe, mumwenga wenu ana musenawe, bai amwendere ye musenawe usiku wa manane na akamwambe, ‘Musenangu, nikopesha mikahe mihahu hedu, ");
INSERT INTO nyf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mana be hana musenangu mumwenga adzire kula charoni nami be sina ut'u wowosi wa kumwambozeza.’ ");
INSERT INTO nyf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Gonya ye musenawe mo nyumbani amudzigidzye amwambe, ‘Aa! Usinibudzye mino, wo muryango udzafungwa kare, kidza mimi na anangu hu ndazini, kwa vizho sindadima kuuka na kudzakup'a chochosi.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jesu akienderera kunena akiamba, “Namwambira kamare, idzaho k'andauka amup'e mikahe kwa zho zha ni musenawe, ela andakudza amup'e zho amalazho zhosi kwa kukala anaenderera kuvoya hasiho haya. ");
INSERT INTO nyf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kwa vizho nami namwambira, voyani nanwi mundagerwa, malani nanwi mundaona, bishani nanwi mundasundulirwa. ");
INSERT INTO nyf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mana kila avoyaye, nikugerwa; kila amalaye, nikuona; na kila abishaye nikusundulirwa. ");
INSERT INTO nyf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","H'aya ni bimut'u h'ani kahi zenu, ariye mwanawe akimala kumba andamup'a nyoka, hat'u ha kumba. ");
INSERT INTO nyf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Hedu hatha ye mwana akimala iji, vidze andamup'a h'ambini? ");
INSERT INTO nyf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bai kala ninwi at'u ai thu, kidza munamanya kuap'a ana enu vit'u vidzo, h'e seze ye Babiyenu ariye mulunguni, ye si zaidhi? Iye nikuap'a Roho Mweri ao mamuvoyao!” ");
INSERT INTO nyf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Badaye Jesu were anamboza p'ep'o bwibwi. Bai yuyahu p'ep'o arihombola, ye bwibwi akikwatya kunena, na o at'u machangalala. ");
INSERT INTO nyf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ela at'u angine haho makikwatya kuamba, “H'aa, anamboza p'ep'o kwa kuhumira nguvu za Belizebuli, nde mubomu wa p'ep'o.” ");
INSERT INTO nyf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Angine o makimuhega kwa kumwamba ahende muujiza wa kula mulunguni. ");
INSERT INTO nyf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ela Jesu akigamanya go maazo gao na akiambira, “Ts'i yoyosi, o at'ue makidzigazha makundi-makundi, gahehanago, be ts'i iyo indanongeka. Na mudzi ukigazhika na at'ue k'amagwirana milomo, be mudzi uwo undabandika. ");
INSERT INTO nyf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Vikara ikikala ye Shethani adzadzigazha, vidze uthawaliwe undatoa jeri? Nanena vivi kwa kukala munaamba ninamboza p'ep'o kwa nguvu za Belizebuli. ");
INSERT INTO nyf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Chamba mino namboza p'ep'o kwa nguvu za Belizebuli, o at'u enu o manaamboza kwa nguvu za h'ani? Bai ao ndo mandiomuhukumu ninwi. ");
INSERT INTO nyf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ela nikimboza p'ep'o kwa chala cha Mulungu, be wo uthawali wa Mulungu udzamudzirira. ");
INSERT INTO nyf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mut'u mwenye nguvu na silaha, arindaho nyumbaye mwenye, zho vit'uzhe ni kukala salama. ");
INSERT INTO nyf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ela adzaho mut'u mungine mwenye nguvu kukira iye na kumuvamia na kumudhima nguvu, be mut'u iye ni kumuhoka zo silaha adzizokuluhira na kugazha zho vit'u adzizhomuhoka. ");
INSERT INTO nyf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kila mut'u ariye k'ahamwenga nami, a kinyume nami. Na iye ariye k'anaviza kukundzumanya hamwenga, kaziye ni kutsamula.” ");
INSERT INTO nyf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“P'ep'o amwambolaho mut'u nikudengereka-dengereka kut'u kuriko k'akuna madzi ili apate hat'u ha kuoya, ela akikosa, nikunena kimoyo-moyo akaamba, ‘Mut'u mimi nindauya iryahu nyumba niriyombola.’ ");
INSERT INTO nyf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bai auyaho na kuithekeza yo nyumba yasherwat'o na ikipangwat'o, ");
INSERT INTO nyf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","nikwendahala p'ep'o angine afungahe, ai kumukira ye mwenye, makadzangira, makatoa mumo. Bai hali ya mut'u iye ni kukala mbii-mbii hatha kukira zho arizhokala chaho.” ");
INSERT INTO nyf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesu arihokala akunenani maut'u gaga hambola mwanamuche kahi za ro kundi ra at'u akinena zhomu zhenye akiamba, “Baha iye m'ama ariyekuzhala uwe na kukuamwisa.” ");
INSERT INTO nyf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ela Jesu akidzigidzya akiamba, “Ee ni jeri, ela baha ao masikirao neno ra Mulungu na kurigwira.” ");
INSERT INTO nyf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Vikara ro rikundi ra at'u ririhokala rinakaza kwangezeka, Jesu waamba, “Kizhazi kiki be ni kithiriri! Ati kinamala kuhenderwa miujiza. Ela k'akuna muujiza mandiohenderwa isihokala uwo muujiza wa Jona. ");
INSERT INTO nyf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mana here Jona arizho were iye ni muv̱ano kwa at'u a Ninawi, ndo vindizhokala pia kwa ye Mwana wa Mudamu. Iye andakala muv̱ano kwa at'u a kizhazi kiki. ");
INSERT INTO nyf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bai siku ya hukumu, ye muthawali wa kula kwa mwaka andaungarara hamwenga na o at'u a kizhazi kiki na aapige ulongo kwa kutsanikuluhira mimi. Mana iye muthawali iye wambola kula kure zhomu, na akidzasirikiza ulachu wa Selemani. Bai lolani haha, hana mut'u ariye ni mubomu hatha kuriko ye Selemani. ");
INSERT INTO nyf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kidza kahi za siku ya hukumu ao at'u a Ninawi mandaungarara hamwenga na o at'u a kizhazi kiki, maapige ulongo, mana ao marihomusikira Jona anahubiri mathubu. H'aya lolani, haha bai hana mut'u ariye ni mubomu hatha kukira ye Jona.” ");
INSERT INTO nyf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesu akienderera kunena akiamba, “K'akuna mut'u agwizaye taa gonya akarifitsa, hedu hatha akaribiningiza na muvure. Ela nikurika nyambaroni, ili kila angiraye aone wo mulangaza. ");
INSERT INTO nyf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matsogo be ndo taa ra wo mwiriwo. Kala matsogo ni madzo, wo mwiriwo ni kukala ni mulangaza muhuhu, ela kala ni makongo, be wo mwiriwo wosi nikwadzala kiza. ");
INSERT INTO nyf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kwa vizho dzimanyirire ili uwo mulangaza wa Uv̱oro Udzo uriwo ndani mwako usikale kiza. ");
INSERT INTO nyf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bai mwiriwo wosi ukikala u thele mulangaza na k'ahana hat'u hohosi ha wo mwiri hariho na kiza, be wo mwiri undang'ala wosi, dza viryahu ambazho taa ni kukung'aza na wo mulangazawe.” ");
INSERT INTO nyf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bai Jesu arihokala adzagonya kunena gaga, hambola mut'u mumwenga ariyekala ni Farisayo akimusunga Jesu ende akarye chakurya naye ko kwakwe. Kwa vizho Jesu akikubali na achenda na akikelesi ho chakuryani. ");
INSERT INTO nyf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ela yuyahu Farisayo akimashwa ni viryahu arizhokala Jesu anarya bila kuoga mikono. ");
INSERT INTO nyf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ela ye Bwana akimwamba, “Ninwi Mafarisayo muhendazho ni kwamba munagesa vikombe na vibakuli ko kwa ndze h'akeye, ela ko ndani be mu thele unyang'anyi na uthiriri. ");
INSERT INTO nyf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ii, azuzu nwi! Samba ariyetengeza ko ndze nde ariyetengeza tha ko ndani. ");
INSERT INTO nyf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bai lazhani vizho virizho mo ndani ya zho vikombe na zho vibakuli kwa akiya, mukihenda vizho, lolani kila kit'u kindakala kisafi kwenu.” ");
INSERT INTO nyf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Jesu akienderera kunena akiamba, “Ela shauri yenu ninwi Mafarisayo, mana munalazha fungu ra kumi hatha ra vilungo, kiswenya na mboga nyingine, ela ko k'amujali hachi hedu hatha kumuhendza Mulungu. Bai ni karakara kumboza fungu ra kumi, ela go mangine nago musigariche. ");
INSERT INTO nyf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Shauri yenu ninwi Mafarisayo! Mana munahendza zho vihi zha ishima mo kahi za masinagogi na munahendza kulamuswa-lamuswa na ishima mo masokoni. ");
INSERT INTO nyf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Shauri yenu! Mana ninwi mu here mbira zirizo k'azinyesa ni mbira, mana at'u ni kukira na haho makazizhoga hasiho kumanya.” ");
INSERT INTO nyf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","K'uzhona zho mwalimu mumwenga wa Sheria achambola kunena akiamba, “Mwalimu, ukinena vizho be unafwangirira hatha siswi.” ");
INSERT INTO nyf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesu akiadzigidzya akiamba, “H'aya hatha ninwi alimu a Sheria nanwi shauri yenu, mana munahika at'u mizigo iriyo k'amadima kuitsukula, na nwi enye nwi k'amwangiza hatha mukono. ");
INSERT INTO nyf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Shauri yenu, kwa kukala munaajengera mbira o manabii, mariolagwa ni babizenu enye. ");
INSERT INTO nyf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kwa vizho vinanyesa kukala munaunga mukono gago garigohendwa ni o akare enu, kwa kukala ao maakot'a o manabii, nanwi munazijengera zo mbira zao. ");
INSERT INTO nyf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kwa ut'u uu bai ulachu wa Mulungu waamba, ‘Mimi nindaahirikira manabii na ahumwi, angine kahi zao mandaakot'a na angine mandaatesa.’ ");
INSERT INTO nyf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kwa vizho bai, o at'u a kizhazi kiki mandauzwa yo milatso ya o manabii iriyomwagwa hangu kuumbwa kwa urumwengu. ");
INSERT INTO nyf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kula hangu milatso ya Abeli muhaka ya Zakaria, ariye walagwa mo ndani za ro Hekalu, kahikahi za cho kijaja cha kulazhira sadaka na ho hat'u haeri. Ee, namwambira kamare cho kizhazi kiki kindauzwa maut'u gaga gosi. ");
INSERT INTO nyf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Shauri yenu ninwi alimu a Sheria, kwa kukala yo funguo ya kumanya mwaihala ninwi. H'aya, ninwi enye k'amwangirire na ao mariokala manangira nao mukiaziza.” ");
INSERT INTO nyf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bai Jesu arihouka haho, Mafarisayo na o alimu a Sheria makwatya kumupinga vii-vii na kumuza maswali manji jeri-jeri, ");
INSERT INTO nyf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kuno th'amaa yao ni kwamba kahi za kunenakwe, akihenda kwele, mamugwire. ");
INSERT INTO nyf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Vikara wakathi uwo maalifu na maalifu ga at'u gadzazana hatha vikikala manakwalana-kwalana kamare. Bai Jesu akikwatya kunena na o anafundzie kwandza akiamba, “Dzimanyirireni na yo ts'ats'u ya Mafarisayo ambayo ni ko kudzihendya kwao. ");
INSERT INTO nyf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kila kit'u kidzichobiningizwa kindagunulwa, na kila kit'u kidzichofitswa kindaonewa. ");
INSERT INTO nyf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kwa vizho bai gago murigonena kizani, gandasikirwa mulangazani, na zo njama murizonena kahi za nyumba zidzizofungwa miryango, zindatangazwa zhomu zhenye.” ");
INSERT INTO nyf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Namwambira asenangu, musogohe ao malagao mwiri, na bada ya kuhenda gago, k'amadima kumuhenda vingine. ");
INSERT INTO nyf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ela bai nindamwanyesa iye ariye ni mumwagohe: Ninwi mwagoheni iye ambaye bada ya kuwalaga wo mwiri ana wadimi wa kuuhala na akautsuha Jehanamu. Ee, namwambira kamare, mwagoheni iye! ");
INSERT INTO nyf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Vidze samba utsongo utsano unaguzwa rahisi renye, kidza ko k'ahana hatha kamwenga kariko Mulungu anadima kukasahau. ");
INSERT INTO nyf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","H'aya zho mbai, hatha zo nyere zenu kidza Mulungu anazimanya isabuye. Kwa vizho bai musogohe bule, mana ninwi muna th'amani kukira iho ra utsongo!” ");
INSERT INTO nyf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesu akienderera kunena na akiamba, “Namwambira kamare, kila mut'u andiyenikubali mbere za at'u, iye Mwana wa Mudamu naye andamukubali mbere za malaika a Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ela kila mut'u andiyenikahala mbere za at'u, iye naye andakahalwa mbere za malaika a Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Na kila mut'u andiyenena rorosi kinyume cha ye Mwana wa Mudamu, andasamehewa, ela mut'u yoyosi andiyenena kufuru dzulu za Roho Mweri, k'andasamehewa bule. ");
INSERT INTO nyf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mukihirikwa masinagogini kwendashithakiwa, hedu mukihirikwa mbere za athawali na maluwali, be hatha musihende wasiwasi wa kuamba mundadzigidzyani hedu mundanenani, ");
INSERT INTO nyf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kwa kukala ye Roho Mweri andamufundisha saa iyo-iyo gago muv̱iryago kunena.” ");
INSERT INTO nyf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Bai hachambola mut'u mumo kundini akimwamba Jesu, “Mwalimu, mwambire ndugu yangu anigazhire wo ufwa nami!” ");
INSERT INTO nyf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesu akimudzigidzya akimwamba, “Musena, h'aya ni h'ani ariyenihendya mulamuli hedu mugazhi wenu wa ufwa?” ");
INSERT INTO nyf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gonya akiambira osini akiamba, “Kalani matso, na mudzimanyirire na kila samupuli ya th'amaa ya kuhendza vit'u, kwa kukala wo uzima wa mut'u be k'aukahi za wo unji wa vit'u arizho nazho bule.” ");
INSERT INTO nyf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Gonya Jesu akiambozera fumbo riri, akiamba, “Kwereko thajiri mumwenga ariye mundawe wazhalat'o sana. ");
INSERT INTO nyf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","K'uzhona akidziuza kimoyo-moyo na kuamba, ‘Vino be hatha ndahendadze mut'u mino? Mana be sina hat'u ha kuika mavuno gangu gosi.’ ");
INSERT INTO nyf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Gonya akiamba, ‘Nindizhohenda ni vivi, nindazivomola ziryahu ts'aga zangu na niake nyingine bomu zaidhi na bai nindawika wo mutsere wangu wosi na zho vit'u zhangu mumo.’ ");
INSERT INTO nyf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nikigonya vizho, h'aya nidziambe, ‘Mut'u uwe be una maut'u manji madzo-madzo gandigokuhala miaka minji kugoma, vikara thuwa kuhurira urye, unwe na ufwahirwe.’ ");
INSERT INTO nyf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ela Mulungu akimwamba, ‘Ii muzuzu we! Usiku wa rero be rohoro, rindamalwa, h'aya zho vit'uzho urizho udzadziikira vindakala zha h'ani?’ ” ");
INSERT INTO nyf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Bai Jesu akimarigiza na kuamba, “H'aya, vivi be ndizho vindizhokala kwa mut'u yoyosi adziikiraye vit'u kuno ko si shaha kahi za maut'u ga Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Gonya Jesu akiambira o anafundzie akiamba, “Kwa ut'u uwo wenye bai, ninamwambira kukala, musihende wasiwasi dzulu za maisha genu, na miri yenu, kala mundaryani, hedu mundavalani. ");
INSERT INTO nyf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mana uzima udzakira chakurya, na mwiri nawo udzakira nguwo. ");
INSERT INTO nyf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hedu lolani go makunguru. K'agarima na k'agavuna, k'agana hat'u ha kuika vit'u, hedu hatha ts'aga, ela Mulungu anagarisa. Nanwi, samba muna kima k'ana nyinji hatha kukira wo unyama! ");
INSERT INTO nyf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni h'ani kahi zenu adimaye kuhenda wasiwasi hatha akangeza ngaa saa kahi za maishage? ");
INSERT INTO nyf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bai ikikala ut'u uthithe wenye dza uu k'amudima kuuhenda, kwanoni muhende wasiwasi na go mangine? ");
INSERT INTO nyf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Hedu lolani zho maluwa gamerazho, k'agahenda kazi, hedu hatha kudzifumira nguwo. Ela namwambira kamare, hatha Selemani na ushahawe wosi, be k'avwaliret'o dza gago maluwa. ");
INSERT INTO nyf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","H'enwi at'u a kuluhiro thithe nwi! Kala Mulungu anadima kuzipamba zo nyasi za vuweni ambazo rero zi haha na machero zinatsufwa mohoni zishe, h'e seze nwi. Samba Mulungu andamuvika zaidhi? ");
INSERT INTO nyf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Bai musithapethape kumala mundaryani hedu mundanwani, musihende wasiwasi dzulu za maut'u gago. ");
INSERT INTO nyf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mana gago gosi ndo at'u a urumwengu mamalago, naye Babiyenu anamanya kukala maut'u gago munagamala. ");
INSERT INTO nyf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ela umaleni wo uthawaliwe kwandza, na zho vingine mundangezezwa.” ");
INSERT INTO nyf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Musogohe ninwi badhi thithe, kwa kukala Babiyenu adzaona ni vidzo kumup'a wo uthawali. ");
INSERT INTO nyf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kwa vizho bai guzani zho vit'u murizho nazho, na zo p'esa muap'e akiya. Nanwi kwa kuhenda vizho, mundakala mudzadziikira akiba wo ushaha wenu ko mulunguni ambako be k'aundagoma, mana k'akuna mwivi adimaye kuusongerera hehi, na k'akuna p'oho madimao kudzawanonga. ");
INSERT INTO nyf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mana haho hariho zo akiba zenu be ndo handihokala yo mioyo yenu.” ");
INSERT INTO nyf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesu akienderera kunena na akiamba, “Dzifungeni nguwo, na mukale thayari-thayari, kuno mataa genu ganaaka. ");
INSERT INTO nyf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kalani here at'u mario manamuthariza bwana wao auye kula harusini, ili andihouya na kubisha, mamuvugulire kare. ");
INSERT INTO nyf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bai baha ao ahumiki ambao ye bwana andakudzaathekeza mathayari-thayari. Namwambira ujeri, iye andavwala nguwo za kazi na aahumikire. Iye andaambira makeresi na aambozeze chakurya. ");
INSERT INTO nyf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kidza baha ao ahumiki ambao ye bwana wao hatha adzaho usiku wa manane hedu jogolo ra kwandza andakudzaathekeza mathayari-thayari. ");
INSERT INTO nyf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ela bai manyani vivi, kalaho mwenye nyumba anadima kumanya zo saa andizokudzirira mwivi, be k'angakubalire nyumbaye ibandwe bule, angachesa matso kuirinda. ");
INSERT INTO nyf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Bai ninwi nanwi dziikeni thayari wakathi wosi, kwani Mwana wa Mudamu andakudza wakathi musiwoudhania.” ");
INSERT INTO nyf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kusikira vizho P'et'ero akimuza akimwamba, “Bwana, fuambe rino fumbo unarambira siswi kare, hedu unarambira at'u osini!” ");
INSERT INTO nyf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ye Bwana akidzigidzya akiamba, “Muhumiki mwaminifu na mulachu ni yuyahu ariye akirichirwa ahumiki andziye ni bwanawe aatsundze na kuap'a chakurya here vimalikanazho, andahenda vizho. ");
INSERT INTO nyf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bai baha iye muhumiki iye ariye bwanawe, andakudzamuthekeza anahenda vizho. ");
INSERT INTO nyf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Namwambira ujeri, andamuhala na amuhendye akale muimirizi wa zho vit'u zhosi arizho nazho. ");
INSERT INTO nyf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ela ye muhumiki akiamba kimoyo-moyo, ‘Naona ye bwana wangu k'andauya vikara,’ bai akwache kuapiga o ahumiki andziye ache kwa alume, na athuwe kurya na kunwa na kurea. ");
INSERT INTO nyf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bai ye bwana wa muhumiki yuyu andauya siku asiyodhania na saa asiyoimanya. Naye afikaho andakudzamuhala na amutose visiku-visiku na amwike hamwenga na at'u masiokuluhirika. ");
INSERT INTO nyf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Muhumiki ambaye anamanya amalazho ye bwanawe, ela ko k'adzithayarisha hedu kuhenda zho ahendzazho ye mubomuwe, be muhumiki iye andapigwa ut'u wa kwangalaza. ");
INSERT INTO nyf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ela muhumiki ariye k'amanya kala ye bwanawe anahendzani, kidza ahende maut'u garigo ganav̱irya apigwe, bai muhumiki iye k'andapigwa zhomu. Kila mut'u ariyegerwa vinji, andaiswa vinji, kidza iye ariyeikirwa amana vit'u vinji, bai mut'u iye andamalwa vinji zaidhi.” ");
INSERT INTO nyf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesu akiamba, “Mut'u mimi nakudzaigwiza moho ii dhunia, nami naaza ukale hatha ni gwuu kare! ");
INSERT INTO nyf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ela bai nina ubat'izo uriwo niniukirire, yani kifwa, nami be nabudzyika muhaka kit'u kiki kindihomarigizika! ");
INSERT INTO nyf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nwi enye munaona nakudza nirehe dheri hano dhuniani? Hatha! Sidzire nirehe dheri, ela namwambira nakudza nihende at'u magazhane. ");
INSERT INTO nyf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kwani kula vivi vikara na kuenderera at'u atsano a nyumba mwenga mandagazhana. Ahahu mandakira kumwenga na o airi mandakira upande wao. ");
INSERT INTO nyf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bimut'u andathengana na mwanawe wa kilume, ye mwana wa kilume naye andathengana na babaye. Mimut'u andathengana na mwanawe wa kiche na ye mwanangwa wa kiche andathengana na mameye. Mizhala andathengana na mukaza mwanawe, na ye mukaza mwana wa mut'u andathengana na mizhalaye.” ");
INSERT INTO nyf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesu akinena na ro kundi ra at'u akiamba, “Ninwi mukiona ingu ridzagit'ana ko mutserero wa dzuwa nikuamba, ‘Indanya’ na ikanya jeri. ");
INSERT INTO nyf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","H'aya, na p'eho ya mwakani ipigaho, ninwi nikuamba, ‘Kundahenda kazikazi,’ na vikakala vizho jeri. ");
INSERT INTO nyf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","At'u a kudzihendya nwi! Munamanya kulola mulunguni na ts'i na mukamanya kundahendeka ut'u wani. Ela mbona miv̱ano ya makathi hurigo k'amumanya kuilola? ");
INSERT INTO nyf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kwanoni k'amulola nwi enye mukamanya ririro karakara kuhenda? ");
INSERT INTO nyf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mut'u akikala anakuhirika kotini, jeza here wadimazho upatane naye mo ngirani. Kala k'undahenda vizho, iye andakuv̱urura muhaka kwa jaji, jaji akulazhe kwa shikari, na shikari akutsuhe jela. ");
INSERT INTO nyf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nami nakwambira k'undambola uwe muhaka ugonye kuriha p'esa zosi.” ");
INSERT INTO nyf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Bai kahi za wakathi uryahu were hana at'u ambao mamwambira Jesu dzulu za Agalilaya ambao Liwali P'ilato watsanganya yo milatso yao na yo ya sadaka zao. ");
INSERT INTO nyf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesu akiadzigidzya akiamba, “Be, munaona kukala ano Agalilaya were mana dambi kukira ao Agalilaya angine, kwa kukala maona t'endere? ");
INSERT INTO nyf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Hatha bule! Namwambira kamare, musihothubu, bai ninwi nyosi nanwi mundafwa dza ao. ");
INSERT INTO nyf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hedu munaona arya at'u kumi na anane mariofwa kwa kugwererwa ni munara ko Siloamu were mana makosa zaidhi kukira o at'u angine osi matoao ko Jerusalemu? ");
INSERT INTO nyf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Hatha bule! Namwambira kamare, musihothubu, bai ninwi nyosi nanwi mundafwa dza ao.” ");
INSERT INTO nyf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Gonya Jesu akiambozera fumbo riri akiamba, “Kwereko mut'u mumwenga ariyekala ana mutini ariwoulaya kahi za mundawe wa mizabibu. Bai siku mwenga, achendamala matunda, ela k'endereona hatha mwenga. ");
INSERT INTO nyf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","K'uzhona zho bai, akimwamba ye mutsundziwe wa wo munda, ‘Lola, dzafisha miaka mihahu kudza nikimala matunda kula kwa uu mutini. H'aya utheme uugwage! Kwanoni uthuwe kwanonga mutsanga bule?’ ");
INSERT INTO nyf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kusikira vizho, ye mutsundzi wa wo munda akimudzigidzya akiamba, ‘Bwana, up'e mwaka mungine mumwenga, nawo nindaurimira na niwangize mbolea. ");
INSERT INTO nyf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mwaka udzao ukizhala, vidzo, h'aa k'auzhalire ndzo uutheme.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bai siku mwenga iriyokala ni Sabato, Jesu were anafundisha kahi za mwenga ra go masinagogi. ");
INSERT INTO nyf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na lola mumo kahi za ro sinagogi mwere muna mwanamuche ariye were ana p'ep'o ariyemulunya kwa miaka kumi na minane. Mwanamuche yuyu were akizama-zama naye were k'adima kugoloka wima kamare. ");
INSERT INTO nyf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bai Jesu arihomona wamwiha ho mbere na akimwamba, “M'ama udzavugulwa kula kahi za ukongoo.” ");
INSERT INTO nyf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Gonya akimuikira mikono na haho henye akigoloka na akikwatya kumulika Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Wee, kuona vizho ye mubomu wa ro sinagogi akitsukirwa kwa kukala Jesu were adzahoza kahi za yo siku ya Sabato. Bai akiambira o at'u akiamba, “Hana siku t'andahu ndzima ziv̱iryazo at'u kuhenda kazi, kwa vizho ndzoni siku zizo mudze muhozwe, ela si yo siku ya Sabato bule.” ");
INSERT INTO nyf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ye Bwana akimudzigidzya akiamba, “H'enwi adzihendyi! Ni h'ani hano asiyevugula ng'ombeye hedu ndzowewe kwendaneswa kwa kukala ni siku ya Sabato? ");
INSERT INTO nyf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Bai kala nwi munahendazho, kwanoni yuno mwanamuche ariye ni mwana wa Burahemu kidza ariye wakelesizwa ni Shethani kwa miaka kumi na minane asivugulwe kahi za siku ya Sabato?” ");
INSERT INTO nyf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bai Jesu arihodzigidzya samupuli ii, o mahadhuie osi masala matso kodoo kumulola, ela bai o at'u angine osi were manafwahizwa kwa go maut'u ga nguma arigokala anagahenda. ");
INSERT INTO nyf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Gonya Jesu akiamba, “Uno uthawali wa Mulungu, be hatha udzahalana na noni? Hatha nindauhalanisha na noni be vino? ");
INSERT INTO nyf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Uwo uthawali udzahalana na katembe ka haradali, kariko mut'u mumwenga wakahala achendakalaya mundani mwakwe. Bai katembe kako kakikula hatha kakikala muhi, na unyama wa kubururuka ukidzaaka vitsunji kahi za zho vitaizhe.” ");
INSERT INTO nyf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Gonya Jesu akiuyira kaheri kuamba, “Uno uthawali wa Mulungu be hatha nindauhalanisha na noni? ");
INSERT INTO nyf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Uthawali wa mulunguni udzahalana na ts'ats'u iriyohalwa ni mwanamuche akivugira p'ishi t'ahu za unga wa ngano na ukikutuka wosi.” ");
INSERT INTO nyf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Bai Jesu arihokala a ngirani kwenda ko mudzi wa Jerusalemu, wakirira kahi za midzi mibomu na midzi mithithe-mithithe kuafundisha at'u. ");
INSERT INTO nyf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Bai mut'u mumwenga akimuza Jesu akiamba, “Bwana fuambe, ni at'u achache thu ndo mandiookoka?” Jesu akidzigidzya akiamba, ");
INSERT INTO nyf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Sitani zhomu mwangire kukirira uwo muryango mufufu, kwa kukala, namwambira kamare anji mandajeza kwangira, ela k'amandadima bule. ");
INSERT INTO nyf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Haho ye mwenye nyumba akiungarara na kuusindika wo muryango, be ninwi mundaima ko ndze kuno munaamba, ‘Bwana, huvugulire!’ Ela iye andamudzigidzya aambe, ‘At'u ninwi simumanya kala mu ano h'ani na mudzambola nahi.’ ");
INSERT INTO nyf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nanwi mundadzigidzya muambe, ‘Samba fwarya na kunwa hosi we? Na kidza uwe ukifundisha kahi za zo barabara za midzi yehu?’ ");
INSERT INTO nyf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ela iye andadzigidzya aambe, ‘At'u ninwi simumanya kala mu ano h'ani na mudzambolahi. H'aya nihaukirani mino, ahendi a mai nwi!’ ");
INSERT INTO nyf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Na kuko mundarira na kwafuna meno, haho mundihomona, Burahemu, Isaka, na Jakobu hamwenga na o manabii osini ma kahi za wo uthawali wa Mulungu, ela nwi enye nwi mudzatsufwa ndze. ");
INSERT INTO nyf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","At'u mandambola mwambolero wa dzuwa, na mutserero wa dzuwa, na kwa vuri na kwa mwaka, madze makeresi chakuryani kahi za uthawali wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nanwi lolani, hana at'u ambao ni a mwisho, mario mandakala a kwandza, na ao a kwandza mandakala a mwisho.” ");
INSERT INTO nyf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Bai wakathi uwo-uwo vizho, Mafarisayo angine makudzamwambira Jesu, makiamba, “Hauke haha, na wende hat'u hohosi hangine, kwa kukala Herode anamala akwalage be vivi.” ");
INSERT INTO nyf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesu akidzigidzya akiamba, “Endani mukarambire ro kala kukala, ‘Ninamboza p'ep'o na kuhoza at'u vivi rero na machero, na indihofika siku ya hahu ndagonya kazi yangu.’ ");
INSERT INTO nyf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ela hatha vizho suthi nienderere na charo changu vivi rero na machero na muhondo, kwa kukala k'azhadimikika nabii afwe hat'u hangine hohosi hasihokala Jerusalemu!” ");
INSERT INTO nyf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Bai Jesu arihogonya kunena vizho, akikwacha kuashikithikira at'u a Jerusalemu. Akiamba, “H'enwi at'u a Jerusalemu. Kazi yenu ni kualaga manabii na kuakot'a mawe ahumiki a Mulungu mahumwao kwenu. Ni mara nyingahi nidzizomala kumukundzumanya hamwenga here k'uk'u aafinikirazho anae na mahahage, ela mudzakahala? ");
INSERT INTO nyf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lolani mudzarichirwa enye nyumba yenu ikale gandzo. Nami namwambira kamare kukala, k'amundanona kaheri muhaka wakathi mundihokudzaamba, ‘Naahaswe iye adzaye kwa dzina ra Bwana.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Siku mwenga iriyokala ni Sabato, Jesu wakwendarya chakurya kahi za nyumba ya mut'u ariye were ni kahi za o abomu a Mafarisayo. Vikara o Mafarisayo makikala manamulola kala andahenda ut'u wani. ");
INSERT INTO nyf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na lola ho mbere za Jesu were hana mwanamulume ariyekala ana ukongo wa magulu na mikono kwadzala. ");
INSERT INTO nyf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesu akiauza o alimu a Sheria na o Mafarisayo akiamba, “Vidze Sheria yehu inaruhusu kuhoza mut'u siku ya Sabato?” ");
INSERT INTO nyf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","O at'u hat'u ha kumudzigidzya o makimunyamalira zii. Kwa vizho Jesu akimugwira mukono ye mukongo akimuhoza gonya akimwamba ende mudzini. ");
INSERT INTO nyf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Gonya Jesu akiagalukira o alimu a Sheria na Mafarisayo, akiauza akiamba, “Ni h'ani hano ariye anadima kuricha ndzowewe hedu ng'ombeye idziyogwa ndani ya kisima asiyamboze kwa kukala ni siku ya Sabato?” ");
INSERT INTO nyf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nao k'amapatire ra kumudzigidzya bule. ");
INSERT INTO nyf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesu arihoona viryahu marizhokala o ajeni manawaniira vihi zha ishima ho chakuryani, waaadha kivivi, ");
INSERT INTO nyf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mut'u akikusunga harusi, usende ukakelesi zho vihi zha ishima p'ore hakakala were hadzasungwa mut'u aishimiwaye kukira uwe, ");
INSERT INTO nyf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kwani ye mwenye mudzi adziyemusunga anadima akadza akaamba, ‘Hedu ungarara umuhise yuyu cho kihi,’ nawe ugwirwe ni haya ukakeresi zho vihi zha ts'ini. ");
INSERT INTO nyf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ela bai usungwaho harusi, enda ukakeresi zho vihi zha ts'ini ili iye adziyekusunga akikona haho anadima kuamba, ‘Musena, hinde ukakeresi kahi za vihi vidzo zaidhi hedu.’ Na vivi vindakup'a ishima mbere za o ajeni andziyo osi. ");
INSERT INTO nyf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mana iye ahendzaye kudzanula andatserezwa, na iye adzitserezaye bai andanulwa.” ");
INSERT INTO nyf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Gonya Jesu akimwamba ye mwenye mudzi, “Uikaho sherehe ya chakurya cha mutsana hedu cha dzulo, usiasunge asenao, hedu nduguzo, hedu mbarizo, hedu majiranio mashaha, kwa kukala ukihenda vizho, ao nao mandakusunga na vindakala ni here madziokuriha. ");
INSERT INTO nyf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ela uusaho sherehe, bai asunge at'u akiya, vidende, virema, na atsowi a matso. ");
INSERT INTO nyf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ukihenda vizho undahaswa haho wakathi at'u a Mulungu mandihofufulwa, kwani ao akiya, vidende, virema na atsowi a matso k'amadima kukuriha bule, ela Mulungu anadima kukuriha.” ");
INSERT INTO nyf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mumwenga kahi za ao mariokala haho arihosikira maneno gago wamwamba Jesu, “Be k'amana raha sana ao mandioirya yo sikuk'uu kahi za uthawali wa Mulungu!” ");
INSERT INTO nyf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ela Jesu akimwamba, “Kwereko na mut'u mumwenga ariyekala anamala kuusa sherehe bomu sana, naye akisunga at'u anji jeri-jeri.” ");
INSERT INTO nyf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bai wakathi irihokala yo haja i thayari kamare, yuyahu mut'u wahuma muhumikiwe akaambire o asungwa kukala maut'u be ga thayari. ");
INSERT INTO nyf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ela osi makimboza visingwa kukala k'amandadima kufika bule ko hajani. Ye wa kwandza akiamba, “Mut'u mimi dzagula hat'u na kwa zhozhosi suthi nende nikahalole, kwa vizho nashikithika sindadima kudza bule.” ");
INSERT INTO nyf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na wa hiri akiamba, “Mimi be dzagula ndzao kumi za kuhendera kazi hatha vivi unonazho be dzakala ninenda nikazijeze, kwa vizho nashikithika sindadima kudza bule.” ");
INSERT INTO nyf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na mungine ye akiamba, “Dzahala muche, kwa vizho ko kudza be ni vikomu.” ");
INSERT INTO nyf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ye muhumiki akiuya ko kwa bwanawe achendamwambira gosi marigo were o asungwa madzamwambira. Kusikira vizho, ye mwenye haja watsukirwa zhomu sana, akimwamba ye muhumikiwe, “Enda mara mwenga hatha kahi za wo mudzi na udze na o akiya, vidende, virema na hatha atsowi a matso mario kahi za barabara za wo mudzi na zho vigira-vigira kahi za go madzumba.” ");
INSERT INTO nyf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ye muhumiki akihenda vizho na arihouya akidzaamba, “Viryahu udzizhonihuma be dzavihenda, ela kuchere na nafasi.” ");
INSERT INTO nyf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Bai ye mwenye yo sherehe akimwamba ye muhumiki, “Enda kuko mabarabarani na vigira zha magulu na ukaasitire at'u madze ili ii haja yangu idzale. ");
INSERT INTO nyf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kwani namwambira kamare k'ahana hatha mumwenga kahi za ao nirioasunga sherehe chaho andekudzathatha kiki chakurya changu.” ");
INSERT INTO nyf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na arihokala Jesu akwendani, kwereko na kundi bomu ra at'u ririro were rinamuthuwa. Bai Jesu akiagalukira na akiambira, ");
INSERT INTO nyf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mut'u yoyosi ahendzaye kunithuwa mimi, suthi anihendze mimi kukira viryahu aahendzazho babaye na mameye, muchewe na anae, nduguze na hatha ye mwenye, ndo akale mwanafundzi wangu. ");
INSERT INTO nyf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na mut'u yoyosi ariye k'adima kuhala musalabawe na kunithuwa k'adima kukala mwanafundzi wangu. ");
INSERT INTO nyf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Vidze, mumwenga wenu kala anamala kuaka munara, andaandza kuaka hasiho kukelesi na kugwaga kitswa amanye kala ana p'esa za kuthosha kuakira wo munara? ");
INSERT INTO nyf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kwani akidziakira hasiho kuaza anadima akakala k'andauivisha bule bada ya kuika wo musinji, na kila andekira na kuona zho virizho, andamutseka. ");
INSERT INTO nyf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kwani o at'u mandaamba, ‘H'aya, wadzihendesha kuaka vino zhamuremeza.’ ");
INSERT INTO nyf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Na muthawali endaho na shikari alifu kumi, kupiga k'ondo muthawali mwandziwe ariye ana shikari alifu mirongo miri, jeri wenye iye ni kukelesi kwandza akaoja kala anadima kumudhima ye mwandziwe na o shikari alifu kumi. ");
INSERT INTO nyf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Akiona kukala k'andamwadima, bai andahuma athumia mende makamone ye muthawali kabila k'adzafika hehi, ili madime kurya amani. ");
INSERT INTO nyf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bai kahi za ngira iyo nanwi, k'ahana adimaye kukala mwanafundzi wangu, asihoandza kuricha maut'u gosi arigo nago.” ");
INSERT INTO nyf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Munyu ni mudzo, ela ukikala udzauya k'aukoza kaheri, k'ahana ngira idimayo kuuhendya ukakoza, ");
INSERT INTO nyf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","hatha virizho haho ni kutsufwa thu, kwa kukala k'auna faidha kwa wo mutsanga, hedu hatha kwa mbolea. Mwenye masikiro, naasikire.” ");
INSERT INTO nyf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Vikara athozi a kodi na at'u angine anji mario k'amahendzwa ni at'u makala makidza makimusirikiza Jesu wakathi arihokala anafundisha. ");
INSERT INTO nyf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ela o Mafarisayo na alimu a Sheria makikwatya kunung'unika na kuamba, “Ii, mut'u yuno hatha anakaribisha at'u mario k'amahendzwa ni at'u na hatha anarya hamwenga nao!” ");
INSERT INTO nyf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesu arihosikira gago waambozera fumbo akiamba, ");
INSERT INTO nyf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Vidze mumwenga wenu akikala ana ng'ondzi gana mwenga gonya angamize mwenga, nikuhendadze? Samba nikuziricha zo mirongo chenda na chenda, akendaidengereka yo idziyongamika hatha akayona. ");
INSERT INTO nyf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bai ayonaho nikuhenda raha zhomu, akayanula, ");
INSERT INTO nyf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","akenda nayo mudzini. Gonya akifika ko mudzini ni kuaiha asenae na majiranige madze hamwenga, naye ni kuambira, ‘Asena, nafusherehekee hosi mana yo ng'ondzi iriyongamika be nidzayona.’ ");
INSERT INTO nyf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Namwambira kahi za ngira iyo vizho, kundakala na fwahiro bomu kuko mulunguni, dzulu za mwenye dambi mumwenga adziyethubu, kukira dzulu za at'u ahachi mirongo chenda na chenda masiomala kuthubu. ");
INSERT INTO nyf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kwani ni mwanamuche hiye adimaye kukala ana shilingi kumi za fedha na angamize mwenga akatsailola? Mut'u iye andagwiza taa, gonya aishere yosi yo nyumba na aimale yo shilingi muhaka ayone. ");
INSERT INTO nyf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na ayonaho yo shilingi, ni kuaiha asenae na majiranige hamwenga na kuamba, ‘Lolani benwi iryahu shilingi iriyokala yangamika dzayona. Kwa vizho hatha ndzoni fusherehekee kwa iyo raha niriyo nayo.’ ");
INSERT INTO nyf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na vizho ndo virizho hatha ko mulunguni, wakathi mwenye dambi adziuthaho na kuziricha dambize, be malaika a Mulungu ni kudzalwa ni fwahiro sana.” ");
INSERT INTO nyf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesu akienderera kuamba, “Kwakala na mut'u mumwenga ariyekala na ana airi a kilume. ");
INSERT INTO nyf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yuyahu muvaha akimwamba babaye, ‘Baba hugazhire wo ufwa wehu.’ Kwa vizho ye bimut'u akihala yo mali akiagazhizha o anae. ");
INSERT INTO nyf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","K'avihalire siku nyinji yuyahu muvaha akihala yo mali yosi akiiguza. Thiye akiuka achenda. Wakwenda hatha ts'i ya kure na kwao, kuko achendanonga-nonga p'esaze zosi kwa kuishi maisha ga uzindzi.” ");
INSERT INTO nyf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Arihokala adzagonya kuzirya zosi zo p'esa, kukigwa ndzala bomu kahi za ts'i iyo. Naye akikala atsululu. ");
INSERT INTO nyf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kwa vizho achendagwirana na mut'u mumwenga wa ts'i iyo na achandhikwa kibaruwa cha kurisa nguluwe. ");
INSERT INTO nyf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Naye were ana ndzala, hatha go makanda garigokala ganariwa ni o nguluwe akigamizira mahe. K'ahambolere mut'u ariyemup'a kaut'u kokosi ka kurya. ");
INSERT INTO nyf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Bai mwishowe arihokeresi na kudziuza akiamba, ‘Ni ahumiki angahi a baba maryao kutsuha, mino nalaha haha! ");
INSERT INTO nyf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mut'u mimi ndahauka haha nende kwa baba na nikamwambe vivi, “Baba, mimi namukosera Mulungu na nikikukosera uwe nawe. ");
INSERT INTO nyf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nadzona siv̱irya kamare kuifwa mwanao, kwa vizho nihendya here muhendzio wa kazi.” ’ ");
INSERT INTO nyf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Gonya akiuka akikwatya kwenda kwa babaye. Bai arihokala achere kure na ho mudzini, babaye akimona na akidzalwa ni mbazi, akimudhana achendamudzagamira akimudonera. ");
INSERT INTO nyf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Haho ndo ye mwana akimwambiriza babaye vivi, ‘Baba, mut'u mimi namukosera Mulungu na nikikukosera uwe nawe, kwa vizho siv̱irya kuifwa mwanao bule.’ ");
INSERT INTO nyf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ela ye bimut'u akiaiha ahumikie akiamba, ‘H'aya hendani haraka, murehe nguwo mbidzo kahi za zosi mumuvike, gonya muhale p'ehe na virahu mumuvike. ");
INSERT INTO nyf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Gonya kakihaleni kiryahu kidzao cha kunona mukitsindze fusherehekee. ");
INSERT INTO nyf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mana mwanangu yuyu were ni here ariyefwa vino adzauya moyo, kidza were ni here ariyengamika, vino adzaoneka.’ Nao makikwatya kusherehekea jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ganakala gaga ye mukulu were a mundani, bai arihokala akuuyani anafika hehi na ho mudzini, anasirikiza vivi, akisikira londzo lwa ngoma na misindo ya at'u manavina. ");
INSERT INTO nyf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bai akiiha muhumiki mumwenga akimuza akiamba, ‘Kunani ko mudzini?’ ");
INSERT INTO nyf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ye muhumiki akimudzigidzya akiamba, ‘Ye muvahao adzire, kwa vizho babayo adzamutsindzira kiryahu kidzao cha kunona mana adzamuhokera muzima.’ ");
INSERT INTO nyf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kusikira vizho ye mukulu wa mut'u akitsukirwa vii-vii hatha akikahala kuhangira ho mudzini. Ndo babaye achendamungolangola, ");
INSERT INTO nyf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ela ye mwana akidzigidzya akiamba, ‘Lola, miaka ii yosi nidzakuhumikira uwe dza here mutumwa, sidzabanda amuriyo hatha lumwenga, nawe k'udzanip'a hatha kabuzi nikausa sherehe na asenangu. ");
INSERT INTO nyf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ela mwanao yuyu, arenonga-nonga maliyo na malaya adzihokudza udzamutsindzira cho kidzao cha kunona.’ ");
INSERT INTO nyf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ye bimut'u akimudzigidzya akimwamba, ‘Mwanangu, uwe siku zosi u haha nami, na kila kit'u changu ni chako hatha uwe. ");
INSERT INTO nyf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ela ni karakara kuusa sherehe na kuhenda raha mana nduguyo yuyu were ni here ariyefwa, ela vino adzauya moyo kaheri, were wangamika, ela vino adzaoneka.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesu akiambira o anafundzie akiamba, “Kwereko mut'u mumwenga ariyekala ni shaha naye were ana muimiriziwe wa kazi ariye were anaambwa kukala ananonga-nonga mali za thajiriwe. ");
INSERT INTO nyf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kwa vizho ye thajiriwe akimwiha akimuza akiamba, ‘Ni maut'u gani gano nisikirago dzuluzo? H'aya namala nimanye isabu yosi, kwani k'udima kukala muimirizi wangu kaheri.’ ");
INSERT INTO nyf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ye muimirizi akiaza, ‘Mut'u mimi, yuyu thajiri wangu be andanifuta, be hatha ndahendadze? Sina nguvu za kugwira jembe, na kuvoya-voya be na haya nako. ");
INSERT INTO nyf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bai nindizhohenda navimanya, ili nifutwaho kazi kisha nikale na asena mandionikaribisha kwao midzini.’ ");
INSERT INTO nyf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kwa vizho akiaiha o at'u osi mariokala manaiswa ni thajiriwe. Marihokudza akimuza ye wa kwandza akiamba, ‘Thajiri wangu anakwisa kiasi chani?’ ");
INSERT INTO nyf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Akiamba, ‘Ananisa madebe gana ga mafuha ga muzeituni.’ Ye muimirizi akimwamba, ‘H'aya hala ro karatasi rinyesaro dheniro. Keresi mara mwenga na uore madebe mirongo mitsano.’ ");
INSERT INTO nyf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Gonya akimugalukira ye wa hiri akimwamba, ‘H'aya we nawe unaiswa ut'u wani?’ Akiamba, ‘Magunia gana ga ngano.’ Ye muimirizi akimwamba, ‘H'aya hala yo risitiyo na uore magunia mirongo minane.’ ");
INSERT INTO nyf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na bai ye thajiri akimulika ye muimirizi mujanja kwa kukala wahumira ujanja, kwani at'u a urumwengu uu ni alachu kala manahumikirana kukira at'u maumanyao ujeri.” ");
INSERT INTO nyf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jesu akienderera kuamba, “Bai namwambira dzimalireni asena kwa kuhumira ushaha wa haha urumwenguni, ili hatha wo ushaha ugomaho, mudime kukaribishwa kahi za mudzi wa kare na kare. ");
INSERT INTO nyf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mut'u ariye ni mwaminifu kwa maut'u machache, andakala mwaminifu hatha kwa maut'u mabomu na mut'u ariye ni mulongo kwa maut'u mathithe andakala mulongo hatha kwa maut'u mabomu. ");
INSERT INTO nyf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bai kala k'amudima kukala aaminifu kwa ushaha wa haha urumwenguni ni h'ani ye andiyemuikira ushaha wa jeri? ");
INSERT INTO nyf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na kala k'amudima kuaminika na kit'u cha mut'u, vidze ni h'ani andemukuluhira na amup'e vit'u virizho zhenu enye? ");
INSERT INTO nyf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","K'akuna muhumiki adimaye kuahendera kazi mathajiri airi. Kwani akihenda vizho, andamuhendza mumwenga ela ye mungine andamumena. Mumwenga andamuhendera kaziye t'ot'ot'o, ela ye mungine andamuv̱udhya. K'amudima kumuhumikira Mulungu na kuno munahumikira mali.” ");
INSERT INTO nyf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bai o Mafarisayo makigasikira gaga gosi na makimutseka, kwa kukala ao be were manahendza p'esa sana. ");
INSERT INTO nyf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesu arihosikira vizho akiambira, “Ninwi ndinwi mudzihendeshao kukala mu at'u adzo mbere za at'u, ela Mulungu be anamanya virizho kahi za mioyo yenu, kwani kuhendza p'esa kunadima kuonekana kukala ni kit'u sana, ela ko mbere za Mulungu k'avimufwaha bule. ");
INSERT INTO nyf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Sheria ya Musa na Maoro ga manabii zhakalako na kidza vikihakira wakathi wa Johana Mubat'izaji. Bai kula wakathi uwo hatha vivi be Uv̱oro Udzo dzulu za uthawali wa Mulungu unaambirizwa at'u na kila mut'u anajeza zhadimikikazho awangire. ");
INSERT INTO nyf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ela ni rahisi mulunguni na ts'i kukira, kuriko kuhala hatha kadono kamwenga ka yo Sheria na kukausa. ");
INSERT INTO nyf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kila amurichaye muchewe na kuhala muche mungine, hedu mut'u ahalaye muche wa kurihira, nikukala anazinga.” ");
INSERT INTO nyf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesu akienderera kuamba, “Kwereko mut'u mumwenga ariyekala ni thajiri sana naye were avala nguwo za zambarau na za kitani safi. Chakuryache chere ni cha hali ya dzulu. ");
INSERT INTO nyf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ho muryangoni hakwe were ni kuikwa mukiya ariyeifwa Lazaro, naye were wo mwiriwe wosi ni vironda vihuhu. ");
INSERT INTO nyf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Iye were a ho mulomoni th'amaaye ni kwamba arye go magande gandigogwa kula kahi za yo meza ya ye thajiri. Zho mbai were k'uro ni kudza na makamulamba-lamba zho virondazhe. ");
INSERT INTO nyf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bai yuyahu mukiya akidza akifwa, na malaika makimuhala na machendamwika lagani mwa Burahemu ko mulunguni. Yuyahu thajiri naye akifwa na akizikwa. ");
INSERT INTO nyf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bai arihokala ako kuzimu na anateseka, achanula matsoge na akimona Burahemu kwa kure, na Lazaro a ho hehi na ye Burahemu. ");
INSERT INTO nyf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bai akipiga k'ululu akiamba, ‘Baba Burahemu, nionera mbazi umuhume Lazaro athobe chalache kahi za madzi naadze anizizinye ludhimi lwangu kwa kukala ninalumira kahi za uu moho.’ ");
INSERT INTO nyf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ela Burahemu akimudzigidzya akiamba, ‘Mwanangu, kumbukira kukala uwe kahi za maishago were una maut'u madzo-madzo, ela Lazaro ye akikala ana go mai-mai mahuhu, vivi vikara bai ye Lazaro ana raha nawe unateswa. ");
INSERT INTO nyf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hamwenga na vizho kahi za siswi na ninwi hana ridzina ribomu, ili ao mamalao kuthalala kula kuku kudza kwenu masidime, na ao a kuko nao masidime kuvuka na kudza kuku kwehu furiko.’ ");
INSERT INTO nyf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ye thajiri akidzigidzya akiamba, ‘Baba Burahemu nakuvoya bai umuhume Lazaro ende ko mudzini kwehu ");
INSERT INTO nyf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mana nina ndugu zangu atsano kuko, ende akaakanye kimbere ili masidze kahi za hat'u haha ha mateso.’ ");
INSERT INTO nyf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Burahemu akimudzigidzya akiamba, ‘Kuko kuna Musa na manabii, bai ni maasikize ao.’ ");
INSERT INTO nyf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ye thajiri akiamba, ‘Hatha bule Baba Burahemu k'amandasikira bule muhaka mut'u ambole kula kuku kifwani aaendere ndo mandathubu.’ ");
INSERT INTO nyf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Burahemu akimudzigidzya akiamba, ‘Kala were k'amandaasikiza Musa na o manabii, be k'amandasikira hatha kukafufuka mut'u kula kifwani.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Gonya Jesu akiambira anafundzie akiamba, “Maut'u gahendago at'u makahenda dambi k'agana budhi kudza, ela andamanya mwenye iye agarehaye. ");
INSERT INTO nyf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mut'u dza iye ni baha afungwe lwalwa lwa singo atsufwe baharini, kuriko kumuhendya mumwenga wa aa athithe ahende dambi. ");
INSERT INTO nyf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kwa vizho at'u ninwi dzimanyirireni! “Nduguyo akikuhendera dambi, muchemere na akiamba adzathubu musamehe. ");
INSERT INTO nyf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Na hatha akikukosera k'ana fungahe yo siku mwenga, na kila akukoseraho adze kwako aambe, ‘Dzathubu, sindavihenda kaheri,’ bai vinakuv̱irya umusamehe.” ");
INSERT INTO nyf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","O ahumwi makimwamba Jesu, “Rihende kuluhiro rehu ringezeke.” ");
INSERT INTO nyf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesu akiadzigidzya akiamba, “Kala muna kuluhiro thithe renye here katembe ka haradali be mungadima, kuwamba uu mukuyu, ‘Ng'oka na wende ukalayike ko baharini,’ na ukamusikira.” ");
INSERT INTO nyf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesu akienderera kuamba, “K'udima kukala na muhumiki akurimani hedu anarisa ng'ondzi naye akidza kula ko mundani umwambe, ndzo vikara ukeresi urye chakurya. ");
INSERT INTO nyf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hatha! K'udima kuhenda vizho, hat'u ha vizho undamwamba, ‘Nigit'ira chakurya unambozeze nirye na kidza ninwe nindihogonya, h'aya nawe unadima kurya na ukanwa.’ ");
INSERT INTO nyf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ye muhumiki k'adima kugerwa muv̱era kwa kuhenda here adzizholagizwa, hedu munaona ni kugerwa muv̱era ye? ");
INSERT INTO nyf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bai hatha ninwi muhendaho zhosi mudzizhombirwa mutengeze, ambani vivi, ‘Siswi hatha, fu ahumiki a kawaida thu, na fudzahenda garyahu gahuv̱iryago.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Vikikala Jesu arihokala akwendani ko Jerusalemu wakirira kahikahi za mihaka ya Samaria na Galilaya. ");
INSERT INTO nyf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Naye were akwendani kahi za kadzidzi kamwenga, bai arihokala achere kwenda, akithunganana na at'u kumi mariokala mana mahana. ");
INSERT INTO nyf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bai o at'u makiima kure na makipiga londzo makiamba, “Jesu! We Bwana! Fuonere mbazi!” ");
INSERT INTO nyf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesu arihoaona akiambira, “Endani hatha ko kwa alombi mukaambire mamulole kala mudzahola jeri.” Bai marihokala machere makwendani makihola kare. ");
INSERT INTO nyf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Bai mumwenga wao arihodziona kukala adzahola wauya kwa Jesu kuno anamulika Mulungu na mumiro mubomu. ");
INSERT INTO nyf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akidza, akidzadzigwaga ho mbere za Jesu kuno anamwambozera muv̱era na mut'u yuyu were si Muyahudi, ela were ni Musamaria. ");
INSERT INTO nyf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesu akiamba, “O madziohozwa samba were ni kumi, vidze arya chenda ma hiko? ");
INSERT INTO nyf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yani k'ahaonekanire mut'u wakudzalazha muv̱era na kumulika Mulungu, hatha ni yuyu Musamaria h'akeye ambaye hatha si Muyahudi kamare?” ");
INSERT INTO nyf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bai Jesu akimwambira ye mut'u “Rungarara wende, kwani kuluhiroro ndo ridzirokuhendya uhole.” ");
INSERT INTO nyf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mafarisayo angine makimuza Jesu mamanye ni rini uthawali wa Mulungu undihokudza. Bai Jesu akiadzigidzya akiamba, “Wo uthawali wa Mulungu k'audza kwa ngira ambayo mut'u anadima kuwona na matso, ");
INSERT INTO nyf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","hedu hatha mut'u yoyosi kuamba, ‘Lolani si uno vino!’ hedu ‘Thiurya kurya!’ kwa kukala wo uthawali wa Mulungu u ndani mwenu.” ");
INSERT INTO nyf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Gonya Jesu akiambira o anafundzie akiamba, “Wakathi unadza ambaho mundathamani muone angaa siku mwenga yaho kahi za siku za Mwana wa Mudamu, ela ko k'amundayona bule. ");
INSERT INTO nyf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma kuko mandiomwamba ninwi, ‘Lolani thiyuya kurya!’ hedu ‘Thiyuno hano!’ ela musikiraho vizho musendeni, hedu hatha kuathuwa. ");
INSERT INTO nyf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kwani Mwana wa Mudamu andihokudza andaonewa ni kila mut'u dza viryahu lumethe luonewazho lwazu-lwazu kila hat'u. ");
INSERT INTO nyf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ela kwandza ni suthi apate thabu nyinji na akahalwe ni at'u a kizhazi kiki. ");
INSERT INTO nyf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kudza kwa Mwana wa Mudamu kundakala dza zho virizhokala wakathi wa Nuhu. ");
INSERT INTO nyf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kwani siku zizo za Nuhu kabila v̱ula ya muretho k'aidzanya, at'u mathuwa kuishi here kawaida thu. Makala makirya na kunwa, na kuhala na kuhalwa hatha Nuhu achangira safinani. Gonya ndo uwo muretho ukidza ukialaga osi. ");
INSERT INTO nyf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na kidza vindakala dza vizho virizhokala wakathi wa Lutu. At'u osi mathuwa kurya na kunwa, kugula na kuguza vit'u, kurima na kuaka nyumba. ");
INSERT INTO nyf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ela siku Lutu arihombola Sodomu thu, be moho na baruthi vikihenda kunya here v̱ula kula mulunguni na vikialaga osi. ");
INSERT INTO nyf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bai vindakala dza vizho zhenye kahi za siku ya kunyeswa lwazu kwa Mwana wa Mudamu. ");
INSERT INTO nyf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Siku iyo bai, mut'u andiyekala a dzulu za nyumba asithime bule na kwendakolokothanya vit'uzhe virizho mo nyumbani, na pia mut'u andiyekala a mundani, ni asiuye bule ko mudzini kwendahala kit'u chochosi. ");
INSERT INTO nyf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Munakumbukira zho zha kukala mukaza Lutu walola nyuma na akigaluka kisiki cha munyu? ");
INSERT INTO nyf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mut'u yoyosi amalaye kuthizha rohoye andayangamiza, ela kila andiyeyangamiza, andaithizha. ");
INSERT INTO nyf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Usiku uwo gandihokala gaga, at'u airi mandakala marere kitanda kimwenga, bai mumwenga andahalwa na ye mungine arichwe. ");
INSERT INTO nyf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Anaache airi mandakala manasaga, bai mumwenga andahalwa na ye mungine arichwe. ");
INSERT INTO nyf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ana alume airi mandakala ma mundani mumwenga andahalwa na mungine arichwe.” ");
INSERT INTO nyf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","O anafundzie makimuza makiamba, “Maut'u gano gandakala hiho?” Jesu akiadzigidzya akiamba, “Hadzihogwa kimba, ndo nderi mathungananaho.” ");
INSERT INTO nyf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Siku mwenga Jesu akiambira o anafundzie fumbo riri, ili aafundishe kukala manav̱irya kuvoya hasiho kutsoka. ");
INSERT INTO nyf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akiamba, “Kwakala kuna jaji mumwenga kahi za mudzi mumwenga ariyekala k'amwagoha Mulungu hedu hatha kujali at'u. ");
INSERT INTO nyf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na bai kahi za mudzi uryahu vizho kwere kuna mwanamuche gungu ariyekala achenda kwa yuyahu jaji kila siku na kumwamba, ‘K'unip'a hachi yangu dzulu za yuno hadhui yangu?’ ");
INSERT INTO nyf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Bai zhahala muda mure, jaji yuyahu k'endzi kuhenda here ye mwanamuche ahendzazho, ela mwisho akiaza mo moyoni, ‘Vingahokala simwogoha Mulungu hedu hatha kujali mut'u yoyosi, ela hatha vizho kwa kukala yuyu gungu ananibudzya, be ninamup'a hachiye, kwani nisihohenda vizho be k'andaricha kunidzirira na mwishowe andanitsosha!’ ” ");
INSERT INTO nyf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesu akienderera kuamba, “Kala jaji asemogoha Mulungu anadima kutsoshwa dza vizho. ");
INSERT INTO nyf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Vidze Mulungu andakosa kuap'a hachi at'ue mwenye, mamuririrao usiku na mutsana ili mapate wavizi? Vidze Mulungu andatoa kuaviza? ");
INSERT INTO nyf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Namwambira kamare, iye andahakikisha kukala madzapata hachi yao kidza haraka. Ela hamwenga na vizho, vidze Mwana wa Mudamu adzaho hano dhuniani andaona kuluhiro jeri?” ");
INSERT INTO nyf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gonya Jesu akiambira fumbo riri ao madzionao kukala ni ahachi na enye kuav̱udhya at'u angine. ");
INSERT INTO nyf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Jesu akiandza vivi, “Kwereko at'u alume airi mariokwenda kahi za ro Hekalu kuvoya Mulungu, bai kahi za ao airi, mumwenga were ni Farisayo na mungine ye were ni muthozi wa kodi. ");
INSERT INTO nyf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Bai ye Farisayo akirungarara na akivoya voyo riri kimoyo-moyo akiamba, ‘Nakulazhira muv̱era Mulungu, kwa kukala mimi si dza here at'u angine, si munyang'anyi, si mulongo, kidza si muzindzi dza at'u angine marizho. Nakulazhira muv̱era kwa kukala si dza here riri rithozi ra kodi haha. ");
INSERT INTO nyf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mino kahi za wiki ndzima, nafunga siku mbiri, kidza ninakup'a sehemu ya kumi ya zhosi nipatazho.’ ");
INSERT INTO nyf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ela ye muthozi wa kodi k'ahendere vizho, arizhohenda ni kwamba waima kure, na hatha ko kulola ko dzulu mulunguni zhamushinda. Wadzipiga makonde ga laga kwa ko kushononeka zhomu akiamba, ‘Nionera mbazi Mulungu, mimi ni mwenye dambi!’ ” ");
INSERT INTO nyf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesu arihogonya kunena vizho, akiamba, “Jeri wenye namwambira, yuyu muthozi wa kodi be wakwenda kwakwe mudzini akikala adzahendywa muhachi ni Mulungu, ela ye Farisayo k'avikalire vizho bule, mana mut'u ahendzaye kudzanula, andatserezwa, ela mut'u adzitserezaye andanulwa.” ");
INSERT INTO nyf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vikara at'u mere manamurehera ahoho aagut'e. Ela o anafundzie marihoona vizho makiadumulira. ");
INSERT INTO nyf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ela Jesu arihoona vizho, akiaiha o ahoho na akiambira o anafundzie, “Aricheni o ahoho athithe madze kwangu, musiakahaze bule, mana wo uthawali wa Mulungu ni wa at'u dza vizho aa. ");
INSERT INTO nyf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Namwambira ujeri wenye, mut'u ariye k'andauhokera uthawali wa Mulungu dza here muhoho muthithe, k'andawangira ng'o.” ");
INSERT INTO nyf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bai mut'u mungine ariyekala ni kilongozi wa Kiyahudi akimuza Jesu akiamba, “Mwalimu mudzo, nihendedze hatha niupate uzima wa kare na kare?” ");
INSERT INTO nyf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesu akimudzigidzya akiamba, “Kwanoni unaniha mudzo? K'akuna mudzo asihokala Mulungu thu basi.” ");
INSERT INTO nyf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ela dzulu za swaliro, uwe unamanya malagizo ga Mulungu, “Usizinge, usalage, usiiye, usimboze ushahidhi wa ulongo, na aishimu babayo na mameyo.” ");
INSERT INTO nyf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ye kilongozi wa Kiyahudi arihosikira vizho akiamba, “Gaga gosi nagagwira hangu nichere muhoho.” ");
INSERT INTO nyf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesu arihosikira gago akimwamba, “Uwe uchere unahungukirwa ni kit'u kimwenga, nacho ni kiki, guza zhosi urizho nazho, gonya uhale zo p'esa uagazhire akiya, nawe undakala na akiba ko mulunguni. Ukigonya vizho ndzo unithuwe.” ");
INSERT INTO nyf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bai ye mut'u arihosikira vizho, akidzalwa ni kigondzi, mana were ni shaha k'amuna. ");
INSERT INTO nyf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesu akimulolat'o, gonya akiamba, “Ni vikomu zhomu kwa mashaha kwangira kahi za uthawali wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kwani ni rahisi ngamira kukira kahi za t'undu ya shindano kuriko shaha kwangira kahi za uthawali wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bai o marihosikira vizho makiamba, “Hatha ni h'ani adimaye kuokoka be zho?” ");
INSERT INTO nyf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesu akidzigidzya akiamba, “Kisodimikika kwa mudamu, kwa Mulungu kinadimikika.” ");
INSERT INTO nyf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","P'et'ero akiamba, “Lola, fwaricha midzi yehu fukikuthuwa uwe.” ");
INSERT INTO nyf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesu akidzigidzya akiamba, “Namwambira ujeri, k'akuna mut'u ariyericha nyumba, muche, ndugu, azhazi, hedu ana kwa ut'u wa uthawali wa Mulungu, ");
INSERT INTO nyf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ariye k'andarifwa. Andahokera k'ana nyinji zenye vivi kare, na kidza andapata uzima wa kare na kare kahi za urumwengu udzawo.” ");
INSERT INTO nyf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Gonya Jesu akiavuha k'anda aryahu anafundzie kumi na airi akiambira, “Lolani vivi be funenda Jerusalemu. Na kuko, kila kit'u kirichoorwa ni o manabii dzulu za ye Mwana wa Mudamu be kindathimira. ");
INSERT INTO nyf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iye andalazhwa kwa o at'u mario si Ayahudi, nao mandamusholera, mamuv̱udhye, mamutsuhire mahe, ");
INSERT INTO nyf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","mamupige, gonya mamwalage, ela siku ya hahu andafufuka. ");
INSERT INTO nyf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Maut'u gaga k'agaang'alirire bule o anafundzie. Yo mana ya kuamba vizho were idzafitswa, na hatha k'amamanyire ananena dzulu za kit'u chani.” ");
INSERT INTO nyf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bai Jesu arihokala a hehi na mudzi wa Jeriko, zhakala haho k'anda-k'anda ya ngira were hakelesi mwanamulume mumwenga kipofu ariyekala anavoya-voya. ");
INSERT INTO nyf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bai iye kipofu arihosikira ro duu na lo londzo-londzo lwa at'u mario were manakira wauza kala kunani. ");
INSERT INTO nyf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na o at'u makimwamba, “Ni Jesu wa Nazareth'i, anakira.” ");
INSERT INTO nyf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ye kipofu arihosikira vizho, akiluta mumiro akiamba, “Jesu Mwana wa Daudi, nionera mbazi!” ");
INSERT INTO nyf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","O at'u mariokala ko mbere makimudumulira makimwamba anyamale. Ela ye hatha akikaza kuluta mumiro akiamba, “Mwana wa Daudi, nionera mbazi!” ");
INSERT INTO nyf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesu akiima na akilagiza ye kipofu arefwe. Bai arihokudza hehi Jesu akimuza akimwamba, ");
INSERT INTO nyf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Vidze unamala nikuhendereni?” Naye akidzigidzya akiamba, “Bwana, namala nione.” ");
INSERT INTO nyf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesu akimwamba, “H'aya ona! Kuluhiroro ridzakuhendya uhole.” ");
INSERT INTO nyf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na haho henye, akikwacha kuona na akimuthuwa Jesu kuno anamulika Mulungu. Bai ro kundi ra at'u ririhoona vizho, ramulika Mulungu. ");
INSERT INTO nyf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu achangira mudzi wa Jeriko, naye akikala anakira kahikahi za wo mudzi. ");
INSERT INTO nyf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Bai hakikala hana mut'u ariye were ni mubomu wa athozi a kodi dzinare were ni Zakayo, naye were ni shaha k'azhadimikika. ");
INSERT INTO nyf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Naye were anamala kumona Jesu amanye chamba ni mut'u ariyedze, ela vikimushinda mana were ni mut'u mufuti mwenye na ro kundi ra at'u rere rinamuziya. ");
INSERT INTO nyf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kwa vizho akiuka malo achenda ko mbere, na achendakwera mukuyu ili adime kumona Jesu, kwani Jesu were andakira na ngira iyo. ");
INSERT INTO nyf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bai Jesu arihofika ho hat'u haho, walola dzulu na akimwamba Zakayo, “Zakayo, thima mara mwenga! Kwani vivi rero be suthi nikale mujenio.” ");
INSERT INTO nyf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kusikira vizho Zakayo wathima mara mwenga na akimuhala Jesu achenda naye kwakwe mudzini kuno ana raha ut'u wa kwangalaza. ");
INSERT INTO nyf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ela o at'u, ut'u uu k'auafwahirire bule, kwani makwatya kunung'unika na kuamba, “Mut'u yuyu adzakwenda ujeni kwa mut'u ariye be ni mudambi zhomu!” ");
INSERT INTO nyf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","K'uzhona zho Zakayo akiungarara na akimwamba Bwana vivi, “Lola Bwana! Kulaiza virero be nusu ya ushaha wangu nindaip'a akiya, na mut'u yoyosi niriyemukenga na nikimuthoza kiwango kibomu, be mut'u iye nindamuriha k'ana ne zenye ya zho nirizhomuhalira.” ");
INSERT INTO nyf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesu akimwamba Zakayo, “Rero wokolwi udzangira kahi za nyumba ii, kwani yuyu naye ni wa lukolo lwa Burahemu. ");
INSERT INTO nyf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na Mwana wa Mudamu wakudza kuamala na kuakola aryahu mariongamika.” ");
INSERT INTO nyf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bai o at'u marihokala machere manaaza go maut'u gaga, Jesu waenderera kunena na akiambira fumbo, kwa kukala were Jesu a hehi na mudzi wa Jerusalemu na o at'u makiona kukala wo uthawali wa Mulungu be undahenda kuhenda poo. ");
INSERT INTO nyf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kwa vizho Jesu akikwatya kunena ro fumbo akiamba, “Kwereko na mut'u ariyekala wazhalwa kahi za nyumba ya kithajiri. Bai akiuka kwenda ts'i ya kure akagerwe cheo cha kukala muthawali, gonya auye kwao mudzini. ");
INSERT INTO nyf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bai kabila k'adzaandza charoche akiaiha ahumikie kumi na akiap'a kila mumwenga shilingi ya dhahabu, na akiambira, ‘H'aya hendani biashara na zizi p'esa muhaka nindihouya.’ ");
INSERT INTO nyf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ela bai aryahu at'u ambao were akiuya ni adze aathawale were k'amamwendzi bule, kwa vizho makihuma at'u makaambe, ‘K'afumwendzi akale muthawali wehu yuyu.’ ");
INSERT INTO nyf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ela hatha hamwenga na vizho yuyu mut'u wahendwa akale muthawali na gonya akiuya mudzini. Bai arihouya waaiha aryahu ahumikie arioap'a ziryahu p'esa ili amanye kala mazihendera kazi na zikireha faidha yani. ");
INSERT INTO nyf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Bai ye wa kwandza akidza na akiamba, ‘Bwana iryahu shilingi ya dhahabu yareha faidha ya shilingi nyingine kumi za dhahabu.’ ");
INSERT INTO nyf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Bai ye mut'u ariyekwendahendywa muthawali akimwamba ye muhumiki, ‘Wahenda ut'u udzo sana, uwe u muhumiki mudzo! Bai kwa kukala wakala mwaminifu kwa maut'u mathithe, nindakuhendya ukale mubomu wa midzi kumi.’ ");
INSERT INTO nyf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Gonya ye wa hiri akidza, akiamba, ‘Bwana iryahu shilingi yo ya dhahabu yareha faidha ya shilingi nyingine ts'ano za dhahabu.’ ");
INSERT INTO nyf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ye Bwanawe akimudzigidzya akimwamba, ‘Uwe nawe kala mubomu wa midzi mitsano.’ ");
INSERT INTO nyf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kula iye akidza mungine, akiamba, ‘Bwana, shilingiyo ya dhahabu siino, naihala nikiifunga kithambaani na nikiifitsa. ");
INSERT INTO nyf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kwani were unanigoshera mana uwe u mut'u mukali, unahendza kuhala vit'u virizho si zhako, kidza unahendza kuvuna ut'u uriwo k'uulayire.’ ");
INSERT INTO nyf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kusikira vizho ye bwanawe akimwamba, ‘Ii, muhumiki mui we! Nakupiga ulongo kwa ludhimilo mwenye. Uwe were unamanya kukala ni mwomu, nahendza kuhala vit'u virizho si zhangu, kidza nahendza kuvuna ut'u uriwo siulayire, ");
INSERT INTO nyf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","vikara kwanoni k'uihalire yo p'esa yangu na ukendayika bengi, ili nikiuya niyone idzazhala faidha?’ ");
INSERT INTO nyf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Arihogonya kunena vizho akiagalukira o at'u mariokala maimire haho na akiambira, ‘Hedu muhokeni yo shilingi ya dhahabu na mumup'e ye ariye na kumi.’ ");
INSERT INTO nyf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","O at'u makimudzigidzya makiamba, ‘Aa, samba ye ana kumi kare Bwana?’ ");
INSERT INTO nyf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ye Bwana akiamba, ‘Namwambira kamare, kila ariye nacho, andagerwa, ela iye ariye k'ana kit'u, andahokwa hatha cho aricho nacho. ");
INSERT INTO nyf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na vikara dzulu za aryahu mahadhui angu mariokala k'amendzi nikale muthawali wao, namala muarehe haha na mualage nalolera.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesu arihogonya kunena vivi wathangulia kumbuka kwenda Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bai achenda hatha arihokala a hehi na kadzidzi ka Beth'ifage na ka Beth'ania kahi za Murima uifwao wa Mizeituni, akiahuma anafundzie airi mathangulie, ");
INSERT INTO nyf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","naye waahuma na malagizo gaga, “Endani hatha kadzidzi mudzikoerekezana nako. Muchangira mundaona mwana wa ndzowe ariye k'adzapandwa ni mut'u adzafungwa, muvuguleni mumurehe haha. ");
INSERT INTO nyf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mut'u yoyosi andiyemuza kwanoni munamuvugula, mwambeni, ‘Bwana ana haja naye.’ ” ");
INSERT INTO nyf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kwa vizho aryahu mariohumwa machenda na marihofika kila kit'u kikikala here arizhokala Jesu adzaambira. ");
INSERT INTO nyf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bai marihokala manamuvugula ye mwana wa ndzowe, hakimbola o enye makiamba, “Mbona munamuvugula ye mwana wa ndzowe kaheri?” ");
INSERT INTO nyf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","O anafundzi makidzigidzya makiamba, “Bwana ana haja naye.” ");
INSERT INTO nyf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bai makimureha kwa Jesu, makihala go maamba gao makigahandika ho dzulu za ye mwana wa ndzowe, gonya makimukweza Jesu ho dzulu. ");
INSERT INTO nyf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Vikara arihokala akwendani, o at'u mahala maamba gao makigahandika mo ngirani. ");
INSERT INTO nyf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bai arihokala adzafika hehi mutharamuko wa Murima wa Mizeituni, ro kundi rosi ra anafundzie rikikwatya kumulika Mulungu kwa sauthi bomu kuno mana fwahiro kwa yo miujiza mariyokala mayona. ");
INSERT INTO nyf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Makiamba, “Naalikwe iye muthawali adzaye kahi za dzina ra Bwana! Dheri narikale ko mulunguni, na nguma yende kwa Mulungu ariye dzulu!” ");
INSERT INTO nyf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bai Mafarisayo angine kahi za ro kundi makimwamba Jesu vivi, “Mwalimu ambire o anafundzio manyamale hedu!” ");
INSERT INTO nyf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesu akiadzigidzya akiamba, “Ao makinyamala, be namwambira kamare gaga mawe gandapiga londzo kare.” ");
INSERT INTO nyf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Vikara Jesu arihofika hehi na wo mudzi, na arihoulola ho mbereze, warira kwa ut'u wa o at'ue. ");
INSERT INTO nyf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Akiamba, “Kala munamanya vivi rero virizho vingamurehera dheri! Ela bai k'amudima kuzhona, ");
INSERT INTO nyf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","kwa kukala siku zinadza, adhui enu mandamuzingira na kumuziza musipate hat'u ha kumbolera. ");
INSERT INTO nyf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nao mandamunonga-nonga kamare hamwenga na wo mudzi wenu. K'ahana iwe ririro k'arindapetulwa, kwa kukala k'amumanyire ho Mulungu arihomudzirira.” ");
INSERT INTO nyf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Gonya Jesu achenda kahi za ro Hekalu na achendaainga o at'u osi mariokala managuza vit'u mumo. ");
INSERT INTO nyf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Akiambira, “Zhaorwa kukala, ‘Nyumba yangu indakala nyumba ya mavoyo,’ ela ninwi mudzaihendya p'anga ya kuzama aivi.” ");
INSERT INTO nyf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bada ya gago Jesu akiandza kufundisha kahi za ro Hekalu kila siku. Bai o alombi abomu, na alimu a Sheria na vilongozi a o at'u makikala manamala kumwalaga, ");
INSERT INTO nyf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ela makikosa ngira ya kumwalagira, kwani o at'u osi were manamusirikizat'o sana hasiho kukirwa ni neno hatha mwenga. ");
INSERT INTO nyf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Siku mwenga Jesu were anafundisha at'u kahi za ro Hekalu na kuhubiri Uv̱oro Udzo. Alombi abomu, na alimu a Sheria, na athumia a Kiyahudi makidza. ");
INSERT INTO nyf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Makimwamba, “Fambire hedu, gano maut'u gano unagahenda kwa wadimi wani? Na ni h'ani ariyekup'a wadimi uno?” ");
INSERT INTO nyf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesu akidzigidzya akiamba, “Hatha mimi nindamuza swali, nambirani hedu, ");
INSERT INTO nyf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Vidze wo wadimi ariohumira Johana Mubat'izaji kubat'izira at'u, wala kwa Mulungu hedu wala kwa anadamu?” ");
INSERT INTO nyf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","O alombi abomu na o athumia makiojana makiamba, “Fukiamba wala kwa Mulungu, andafuza, ‘Kwanoni k'amumukuluhirire?’ ");
INSERT INTO nyf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na hukiamba, ‘Wala kwa anadamu,’ aa at'u osi mandahupiga mawe kwani manaamini kukala Johana were ni nabii.” ");
INSERT INTO nyf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kwa vizho makimudzigidzya Jesu makiamba k'amamanya ko urikolaa. ");
INSERT INTO nyf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesu akiambira, “Hatha mimi nami sindamwambira wo wadimi nihumirao kuhendera maut'u gaga.” ");
INSERT INTO nyf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesu akienderera na akiambira o at'u fumbo riri, akiamba, “Kwereko na mut'u ariyelaya munda wa mizabibu, gonya akiukodishira ak'urima angine, ye mwenye achenda ts'i nyingine achendakala kuko kwa muda mure. ");
INSERT INTO nyf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Makathi ga mavuno garihofika, akihuma muhumikiwe ende kwa aryahu ak'urima, akagerwe fungu ra zo zabibu. Ela aryahu ak'urima makimupiga, makimuja kihuhu. ");
INSERT INTO nyf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kuona vizho ye mwenye munda akihuma muhumiki mungine, ela iye naye makimupiga, makimuhendera makuruhu, gonya makimudzya kihuhu. ");
INSERT INTO nyf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ye mwenye munda akimuhuma muhumikiwe wa hahu, ela o ak'urima makimwangiza ranga gonya makimwamboza mo mundani, makimugwaga ko ndze. ");
INSERT INTO nyf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kusikira vizho ye mwenye munda akiaza, ‘Mut'u mino be hatha ndahendadze vino? Nindizhohenda ni vivi, nindamuhuma ye mwanangu nimuhendzaye, hangine nikwenda makamuishimu.’ ");
INSERT INTO nyf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ela o ak'urima marihomona ye mwana akudzani makiambirana, ‘Yuno be hatha se andiyeuhala ufwa uno munda? Alume nahumwalage yuyu, ili uu munda ukale wehu.’ ");
INSERT INTO nyf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kwa vizho makimugwira makimwamboza ndze ya wo munda makimwalaga. Vidze yuya mwenye munda andaahendadze arya ak'urima? ");
INSERT INTO nyf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ut'u andiouhenda ni kwamba andakudzaalaga aryahu ak'urima, gonya wo munda aap'e at'u angine.” Bai o at'u marihosikira vivi makiamba, “Hatha! K'avindakala bule vizho.” ");
INSERT INTO nyf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kusikira vizho Jesu akialolat'o gonya akiauza akiamba, “Vidze go Maoro gaambago, ‘Ro iwe ririrokahalwa ni aaki vivi be ridzagaluka ndo iwe bomu ra p'embe,’ manaye ni noni? ");
INSERT INTO nyf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kila mut'u andiyerigwerera iwe riro, andabandika-bandika, ela mut'u yoyosi rindiyemugwerera rindamusaga tikitiki.” ");
INSERT INTO nyf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bai saa iyo kare o alimu a Sheria, na alombi abomu makijeza kumwangiza Jesu mikononi, mana mamanya kukala fumbo riro were ridzanenwa kwao ao, ela makigoha o at'u. ");
INSERT INTO nyf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kwa vizho makikala manalola madime kupata mwanya mudzo. Bai makiahuma at'u madzihendeshe kukala k'amana malengo mai, na were th'amaa yao ni kwamba Jesu andanena ut'u undiomuhendya agwirwe na angizwe mikononi mwa ye luwali wa Kirumi. ");
INSERT INTO nyf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kwa vizho o at'u mariokala manahenda kudzihendesha makimuza Jesu makiamba, “Mwalimu, hunamanya kukala gago unenago na kufundisha be ni ga karakara, kidza k'una upendheleo, ela unafundisha ngira ya Mulungu jeri. ");
INSERT INTO nyf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Vikara fwambire. Kulazha kodi kwa Kaisari kwehu sino, ni karakara hedu si karakara?” ");
INSERT INTO nyf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesu akiwona kare wo ulachu wao na akiambira, ");
INSERT INTO nyf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Hedu nanyesani yo p'esa.” Arihonyeswa akiuza, “Vidze ino sura iriyo hano na ro dzina ni zha h'ani?” Nao makidzigidzya makiamba, “Ni zha Kaisari.” ");
INSERT INTO nyf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesu akiambira, “H'aya bai, zha Kaisari, mup'eni Kaisari mwenye, na zha Mulungu, mup'eni Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na kwa ut'u uwo makishindwa ni kuona makosa gogosi kahi za gago arigonena mbere za at'u, kwani jibu ra Jesu raangalaza hatha makinyamala zii. ");
INSERT INTO nyf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","At'u angine maifwao Masadukayo ambao manaamba kukala k'akuna kufufuka makudza kwa Jesu na swali, ");
INSERT INTO nyf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","makiamba, “Mwalimu, Musa wafuorera kukala, mut'u akifwererwa ni nduguye, na asiye ye muche kare bila ahoho, ye nduguye mut'u ni amuhale ufwa ili amuzhalire ahoho ye mufwadzi. ");
INSERT INTO nyf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Vikara kwereko na at'u alume afungahe mario were ni ndugu mwenga, bai ye muzhere akihala muche naye akifwa na akimusia ye muche hasiho kuzhala naye ahoho. ");
INSERT INTO nyf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kwa vizho ye wa hiri akimuhala ufwa ye muche. ");
INSERT INTO nyf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Badaye akihalwa ni ye wa hahu, ela osi afungahe mafwa bila kusiya ahoho. ");
INSERT INTO nyf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mwisho ye muche naye akiathuwa. ");
INSERT INTO nyf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Vikara at'u mandihofufuka, ye mwanamuche andakala mukaza h'ani? Kwani o ndugu osi mamuhala.” ");
INSERT INTO nyf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu akiadzigidzya akiamba, “Kuhala na kuhalwa ni kwa at'u haha urumwenguni. ");
INSERT INTO nyf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ela bai o at'u mandioonewa kukala manav̱irya kufufulwa kahi za yo siku ya mwisho na kutoa kahi za urumwengu udzawo, k'amandahala hedu kuhalwa. ");
INSERT INTO nyf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kwani mandakala karakara na malaika, k'amandafwa bule ao ni ana a Mulungu kwa kukala madzahenda kufufulwa. ");
INSERT INTO nyf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kwani hatha Musa naye ananena lwazu kamare kukala at'u mandafufulwa, kahi za haryahu arihondhika dzulu za kiryahu kitsakuzi kirichokala kinaaka, anamwiha ye Mulungu, Mulungu wa Burahemu, na Isaka, na Jakobu. ");
INSERT INTO nyf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mana Mulungu ni Mulungu wa at'u mario moyo, si wa at'u mariofwa. Kwa vizho at'u aa ma moyo kwa kukala kwakwe ye Mulungu be at'u osi ma moyo.” ");
INSERT INTO nyf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Alimu a Sheria angine mariokala haho marihosikira jibu ra Jesu makiamba, “Udzadzigidzyat'o kamare mwalimu.” ");
INSERT INTO nyf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bada ya vizho k'ahana mut'u ariyedzisikira kumuza Jesu swali kaheri. ");
INSERT INTO nyf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Gonya Jesu akiamba, “Vinadimikikadze at'u kuamba kukala ye Masihi ni Mwana wa Daudi? ");
INSERT INTO nyf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kwani hatha ye Daudi mwenye waora kahi za chuwo cha Zaburi vivi, ‘Bwana Mulungu wamwamba Bwana wangu, “Keresi mukono wangu wa kurya ");
INSERT INTO nyf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","muhaka mahadhuio niathambaraze kamare ts'ini za magulugo.” ’ ");
INSERT INTO nyf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","H'aya vikikala Daudi mwenye anamwiha ‘Bwana,’ anadimadze kukala ni mwanawe?” ");
INSERT INTO nyf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Vikara marihokala at'u osini madzahega sikiro kumusirikiza, Jesu waagalukira o anafundzie na akiambira, ");
INSERT INTO nyf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Dzimanyirireni na o alimu a Sheria ambao manafwahizwa ni kutsembera kuno madzavala miguwo mire, na kidza manafwahizwa ni kulamuswa na ishima mo masokoni na mana ngwiri na vihi zha ishima mo kahi za masinagogi. Na lola mendaho kahi za nyumba, be manahendza kwendakeresi zho vihi zha ishima. ");
INSERT INTO nyf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","H'aya visithoshe, ao vizho manaahoka ache magungu vit'u zhao, na kudzihendesha adzo kwa kuvoya mavoyo mare-mare. Adhabu yao indakala k'ali zaidhi.” ");
INSERT INTO nyf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Vikara Jesu were a mo kahi za Hekalu akilola kuku na kuku na akiona at'u mario were ni mathajiri managwaga sadaka zao kahi za cho kiya cha sadaka. ");
INSERT INTO nyf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","K'avitoere akimona mwanamuche ariye were ni gungu kidza mukiya anagwaga vipeni viri. ");
INSERT INTO nyf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesu arihoona vizho akiambira o at'u akiamba, “Namwambira ujeri, yuyu mwanamuche gungu adzagwaga nyinji kukira osi, ");
INSERT INTO nyf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","mana o angine madzamboza kafungu thu ka wo ushaha mario nao, ela yuno ye ni masikini nyasi, ela adzagwaga zhosi arizho nazho.” ");
INSERT INTO nyf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Badaye angine kahi za o anafundzie makikala manasumurira viryahu ambazho ro Hekalu raakwa t'ot'ot'o na viryahu garizho madzo go mawe garigoakirwa na viryahu virizho vidzo zho vit'u virizhombozwa here sadaka kahi za ro Hekalu. Jesu arihosikira vizho akiadzigidzya akiamba, ");
INSERT INTO nyf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Munazhona zho, wakathi unadza ambawo k'ahandasala iwe dzulu za iwe, kila kit'u kindabandwa-bandwa.” ");
INSERT INTO nyf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","O anafundzi marihosikira vizho makimuza Jesu makiamba, “Vidze maut'u gano gandahendeka rini? Ni muv̱ano wani undiwonyesa kukala makathi gadzafika ga maut'u gaga kuhendeka?” ");
INSERT INTO nyf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesu akiadzigidzya akiamba, “Dzimanyirireni hasidze mut'u akamukenga. Kwani at'u anji mandakudza kwa dzina rangu, na mandadziamba ao ndo iye Masihi, kidza mandaamba, ‘Wo wakathi be udzafika.’ Ela hatha mandihonena vizho, siakuluhireni bule. ");
INSERT INTO nyf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na mundihosikira uv̱oro wa viha na fujo, sogoheni, kwani ni hatha gakale gago, ela wo mwisho undakala uchere mbere.” ");
INSERT INTO nyf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Gonya Jesu akienderera kunena akiamba, “Kabila rindauka kupigana na kabila ringine. Uthawali undapigana na uthawali mungine. ");
INSERT INTO nyf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ts'i indathethema ut'u wa kwangalaza, na kundakala na ndzala na mapigo ga makongo kila hat'u. Kundahendeka maut'u ga kwagosha-gosha na ga kitai-kitai ko mulunguni. ");
INSERT INTO nyf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ela kabila maut'u gaga k'agadzahendeka, at'u mandamugwira na mamutese. Mandamuhirika kahi za masinagogi na kumwangiza jela. Mandamuhirika mbere za athawali na maluwali kwa ut'u wa dzina rangu. ");
INSERT INTO nyf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na iyo indakala ni nafasi kwenu ninwi ya kumboza ushuhuda dzulu zangu. ");
INSERT INTO nyf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Musikale na wasiwasi dzulu za zho mundizhoadzigidzya. ");
INSERT INTO nyf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kwani mimi nindamuhendya mudzigidzye kuhumira maneno gandigoahendya o mahadhui enu makose ut'u wowosi wa kumwamba zho mudzizhonena sozho. ");
INSERT INTO nyf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nanwi mundalazhwa hatha ni azhazi enu enye, na ndugu zenu na amanyi enu na hatha asena enu enye, na angine kahi zenu mandalagwa. ");
INSERT INTO nyf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Visithoshe, mundamenwa ni kila mut'u kamare kwa ut'u wa dzina rangu. ");
INSERT INTO nyf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ela hamwenga na vizho, mundakala na urindzi munji na hatha ludzere lumwenga lwenye k'alundatoka bule. ");
INSERT INTO nyf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwa vizho mukienderera kukuluhira mundathizha roho zenu.” ");
INSERT INTO nyf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kidza mundihoona shikari anji madzauzingira wo mudzi wa Jerusalemu, be manyani kukala wakathiwe wa kunongwa-nongwa be udzafika hehi jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Vikara wakathi uwo undihofika, at'u mandiokala Judea namachimbirire ko mirimani, na ao mandiokala kahi za wo mudzi wa Jerusalemu suthi mawambole kare. Na ao mandiokala ma mashambani ni masiwangire bule wo mudzi, ");
INSERT INTO nyf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","kwa kukala siku zizo at'u mandaadhibiwa here Maoro gaambazho. ");
INSERT INTO nyf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wakathi uwo vindakala vii-vii zaidhi kwa ano m'ama mandiokala mana mimba na mandiokala manaamwisa. Kwani be kundakala na mashaka ga kwangalaza kahi za ts'i na k'oro zosi za Mulungu zindakala dzulu za at'u aa. ");
INSERT INTO nyf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Angine mandalagwa kwa kuthemwa-themwa mishu, na angine o mandagwirwa mahalwe mateka mende kahi za kila kabila ra at'u. Na wo mudzi wa Jerusalemu nawo, undakudzazhogwa-zhogwa ni at'u mario si Ayahudi, muhadhi wakathi wao wa kuthawala ugome. ");
INSERT INTO nyf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kidza ro dzuwa na wo mwezi na zo nyenyezi, zhosi vindathimwa ni maut'u ga kitai-kitai. Hano ho ts'i ho, ts'i zindakala zingelele kwani zindagoshezhwa ni kururuma kwa bahari na kupiga kwa maimbi mabomu. ");
INSERT INTO nyf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Na lolani, at'u mandangirwa ni woga hatha magwe mazime mioyo. K'amandamanya ni ut'u wani udzirirao urumwengu, mana nguvu za dzulu mulunguni zindathukuswa. ");
INSERT INTO nyf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ndo haho mandamona Mwana wa Mudamu akudzani kahi za ingu, hamwenga na nguvu nyinji na nguma. ");
INSERT INTO nyf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","H'aya bai maut'u gaga gandihoandza kuhendeka, be sogoheni, at'u ninwi rungararani na mulole ko dzulu na th'amaa mana wakathi wa Mulungu kumukombola undakala udzafika hehi!” ");
INSERT INTO nyf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesu akienderera kunena na akiambozera fumbo riri. Akiamba, “Lolani mutini hedu na hatha mihi yosi mingine. ");
INSERT INTO nyf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wakathi imbozaho makodza, ni kukala ninwi enye munamanya kamare wakathi wa mavuno udzafika hehi. ");
INSERT INTO nyf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kwa vizho ninwi nanwi, mukiona maut'u gaga gosi, manyani kukala uthawali wa Mulungu u hehi. ");
INSERT INTO nyf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nami namwambira kamare, kizhazi kiki k'akindakira kabila maut'u gaga gosi kuhendeka. ");
INSERT INTO nyf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mulunguni na ts'i, zhosi vindahenda mwisho, ela maneno gangu k'agana mwisho bule.” ");
INSERT INTO nyf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nanwi dzimanyirireni, musihale wakathi wenu mukauhenda wa kurya na kunwa kukira muhaka, hedu hatha kudzishuhulisha zhomu na maut'u ga haha dhuniani, kwani mukihenda vizho, be iyo siku inadima ikahenda kumudulukiza na kumugwira here muhambo. ");
INSERT INTO nyf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kwani siku iyo be indaadzirira at'u osini matoao kahi za urumwengu muzima. ");
INSERT INTO nyf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kwa vizho bai kalani matso na muvoye ili mupate nguvu za kugakirira maut'u gaga gandihohendeka, kidza mudime kuima mbere za ye Mwana wa Mudamu.” ");
INSERT INTO nyf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesu were akaafundisha at'u mutsana kahi za ro Hekalu siku zizo, na dzulo richangira were akawombola wo mudzi na kwendakala kut'u kuifwako Murima wa Mizeituni na kuukiza wo usiku kuko. ");
INSERT INTO nyf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na o at'u nao were makarauka kwenda kahi za ro Hekalu kila siku kumusirikiza Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Vikara wakathi wa sikuk'uu ya Mikahe Iso Ts'ats'u ambayo pia inaifwa P'asaka were udzafika hehi. ");
INSERT INTO nyf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","K'uzhona bai o alombi abomu na alimu a Sheria makikala manamala mwanya wa kumwalagira Jesu kisiri kwani were ni aoga na at'u. ");
INSERT INTO nyf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ndo Shethani akimwangira-ngira Juda Isikariote ariye were ni mumwenga wa o anafundzi kumi na airi a Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Naye Juda wakwenda vivii muhaka kwa alombi abomu na abomu a arindzi a ro Hekalu na achendapanga nao viryahu angazhodima kumusaliti Jesu kwao. ");
INSERT INTO nyf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bai marihosikira vizho mafwahirwa hatha makilagana naye kumup'a p'esa. ");
INSERT INTO nyf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Juda akikubali na akiandza kumala nafasi mbidzo ya kumusalitira Jesu hasiho kukala na kundi rorosi ra at'u. ");
INSERT INTO nyf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ndo yo siku ya Mikahe Iso Ts'ats'u ikifika ambayo pia ndo siku ya kutsindza ng'ondzi za sikuk'uu ya P'asaka. ");
INSERT INTO nyf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ndo Jesu akimuhuma P'et'ero na Johana akiamba, “Endani hedu mukahuthayarishire viryahu hundizhorya ii sikuk'uu ya P'asaka.” ");
INSERT INTO nyf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","P'et'ero na Johana marihosikira vivi makimuza Jesu makiamba, “Vidze, unahendza fukakuthayarishire hiko?” ");
INSERT INTO nyf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesu akidzigidzya akiamba, “Endani vivi hatha muchangira wo mudzi thu mundaona mwanamulume adzatsukula muthanga wa madzi, bai mundihomona muthuweni nyuma muhaka yo nyumba andiyongira. ");
INSERT INTO nyf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mundihokala mudzangira mo nyumbani, muzeni ye mwenye nyumba muambe, ‘Mwalimu adzaamba, cho chumba cha ajeni ambacho iye na anafundzie mandarya sikuk'uu ya P'asaka ni hicho?’ ");
INSERT INTO nyf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Andihosikira vizho andamwanyesa chumba kibomu cha gorofani kiricho kina kila kit'u. Bai mukichona kwatyani kupanga-panga mumo.” ");
INSERT INTO nyf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kwa vizho o anafundzi makiuka na makikwatya kwenda, nao makiona zho arizho were Jesu adzaamba zhenye. Ndo makipanga-panga kwa ut'u wa yo sikuk'uu ya P'asaka. ");
INSERT INTO nyf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bai wakathi urihofika, Jesu wakwendakelesi hamwenga na o ahumwie kurya chakurya. ");
INSERT INTO nyf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kidza Jesu akiambira, “Mut'u mimi were na thamani zhomu kurya sikuk'uu ya P'asaka hamwenga nanwi kabila sidzaandza kupata mateso! ");
INSERT INTO nyf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kwani namwambira kamare sindaithatha kaheri ii sikuk'uu muhaka indihopata manaye kamare-kamare kahi za uthawali wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Gonya Jesu akihala cho kikombe cha divai achamboza muv̱era kwa Mulungu na akiambira o ahumwie akiamba, “H'aya halani mutsumbulirane. ");
INSERT INTO nyf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nami namwambira ujeri, sindanwa kaheri divai muhaka uthawali wa Mulungu undihokudza.” ");
INSERT INTO nyf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Arihogonya vizho akihala mukahe, akimboza muv̱era, gonya akiumogola-mogola na akiagolozeza akiamba, “Uu ndo mwiri wangu umbozwao kwa ut'u wenu, kalani mukiurya kwa kunikumbukira mimi.” ");
INSERT INTO nyf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Bai marihogonya kurya, akihala cho kikombe cha divai akiap'a, akiamba, “Kikombe kiki ndo kilagane kisha kidzichoikwa kwa milatso yangu ambayo indamwagwa kwa ut'u wenu. ");
INSERT INTO nyf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ela lolani bai iye mut'u anisalitiye be yu haha, na hatha ninarya naye. ");
INSERT INTO nyf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kwani Mwana wa Mudamu andalagwa karakara na ahendzazho Mulungu, ela shauriye iye mut'u amusalitiye.” ");
INSERT INTO nyf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","O anafundzie marihosikira vizho makikwatya kuuzana-uzana o enye kwa enye mamanye chamba ni h'ani andiyehenda ut'u dza uwo. ");
INSERT INTO nyf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kidza hakimbola k'anani kahi za o anafundzi dzulu za ni h'ani kahi zao anahalirwa dza here mubomu wao. ");
INSERT INTO nyf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ndo Jesu akiambira kukala, “Athawali a at'u mario si Ayahudi mathawala at'u ao na ukali, kidza o vilongozi ao manaifwa, ‘Aheshimiwa.’ ");
INSERT INTO nyf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ela ninwi bai ni musikale dza ao bule. Hat'uhe, iye ariye ni mubomu kahi zenu suthi akale muthithe wa osi. Kidza iye kilongozi suthi akale dza here muhumiki. ");
INSERT INTO nyf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Vidze ariye mubomu kahi za ano at'u airi ni hiye? Vidze ni yuyahu akelesiye akambozerwa chakurya hedu ni iye mwambozi wa chakurya? Samba ni iye akelesiye na akambozerwa. Ela mimi bai ni dza here mut'u ahumikaye kahi zenu. ");
INSERT INTO nyf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ninwi ndinwi mudzioenderera kukala hamwenga nami kahi za majezo nigapatago. ");
INSERT INTO nyf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nanwi namup'a wo uthawali dza here Baba arizhonip'a. ");
INSERT INTO nyf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ninwi mundarya na munwe kahi za meza yangu kahi za uthawali wangu na kidza mundakelesi kahi za vihi zha endzi na muhukumu zo kabila kumi na mbiri za Iziraeli.” ");
INSERT INTO nyf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kidza Jesu akiamba, “Simoni, Simoni! Lola Shethani adzamumala ili amuhehet'e dza here mut'u ahehet'azho ngano. ");
INSERT INTO nyf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ela hamwenga na vizho mimi nidzakuvoyera vivi Simoni kwamba uenderere kukuluhira. Kidza bai undihoniuyira mimi, hakikisha kukala udzaangiza nguvu o nduguzo.” ");
INSERT INTO nyf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simoni arihosikira vizho akidzigidzya akiamba, “Bwana, mut'u mimi ni thayari fukafungwe hosi hedu hatha nalagwe hamwenga nawe.” ");
INSERT INTO nyf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesu akimudzigidzya akimwamba, “Nakwambira ujeri P'et'ero, undanikana k'ana t'ahu kabila jogolo k'aridzaika usiku wa rero, na undaamba kukala k'unimanya bule.” ");
INSERT INTO nyf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Gonya Jesu akiagalukira o anafundzie akiauza akiamba, “Munakumbukira harya nirihomuhuma na nikimwamba, musitsukule p'esa, hedu mukoba hedu hatha virahu zhenye? Vidze murihohendazho mwatsowa kit'u chochosi?” O anafundzi makidzigidzya makiamba, “K'ahutsowere kit'u.” ");
INSERT INTO nyf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesu akiambira, “Ela vivi bai ariye na p'esa hedu mukoba na avihale, na ariye k'ana mushu naaguze ro valore na augule. ");
INSERT INTO nyf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kwani go Maoro gaambago kukala, ‘Wathalwa jao mwenga na enye dambi,’ vivi be suthi gathimizwe kwangu. Kwa kukala go garigoorwa dzulu zangu be gandakala jeri.” ");
INSERT INTO nyf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","O anafundzi marihosikira vizho makiamba, “Bwana! Lola haha kare huna mishu miri.” Jesu akiadzigidzya akiamba, “H'aa, vinathosha vizho.” ");
INSERT INTO nyf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Badaye Jesu hamwenga na anafundzie wakwenda Murima wa Mizeituni here garizhokala mazowerage. ");
INSERT INTO nyf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bai marihofika kuko Jesu waambira o anafundzie akiamba, “Voyani sidze mukangira majezoni.” ");
INSERT INTO nyf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Arihogonya kunena vizho akiashalahukira na achenda hat'u ambaho ukurewe ni dza uryahu wa mut'u adzevuguriza iwe. Arihofika haho akipiga mavindi na akivoya voyo riri, ");
INSERT INTO nyf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Baba, kala ni mahendzogo niusira gaga mateso gaga, ela visikale here nihendzazho mimi, ela navikale here uhendzazho uwe, visikale here nihendzazho mimi bule.”  ");
INSERT INTO nyf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ndo malaika kula mulunguni akimwambolera na akimwangiza nguvu. ");
INSERT INTO nyf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na kidza kahi za hali ya kukala angelele akikaza kuvoya kwa nguvu zaidhi, na lola achambola mavukuhi garigokala gadzahalana na madeswe ga milatso, gakidweka ho ts'i. ");
INSERT INTO nyf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bai arihogonya kuvoya waauyira o anafundzie na achendaathekeza madzalela kwa cho kigondzi kinji na marere. ");
INSERT INTO nyf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesu arihoona vizho akiauza akiamba, “Mbona murere kaheri? H'aya ukani muvoye sidze mukangira majezoni.” ");
INSERT INTO nyf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bai arihokala achere kunena, kukidza kundi ra at'u ririrokala rinalongozwa ni Juda, ariyekala ni mumwenga wa o anafundzi kumi na airi. K'uzhona zho akidza na akimudonera Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ela Jesu arihoona vizho akimuza Juda akiamba, “Juda hatha unamusaliti ye Mwana wa Mudamu kwa kuhenda kumudonera kamare?” ");
INSERT INTO nyf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ndo o anafundzie mario were ma hamwenga naye marihoona vizho makimwamba, “Bwana! Fuatheme-theme na myushu ano?” ");
INSERT INTO nyf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hakimbola mumwenga wao, akimuthema muhumiki wa ye Mulombi mubomu mwenye hatha akimutosa sikiro. ");
INSERT INTO nyf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ela Jesu akiamba, “Aa! Mbai, vinathosha vizho.” Gonya akirigut'a ro sikiro na akihola kare. ");
INSERT INTO nyf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesu akiambira o alombi abomu, na abomu a arindzi a ro Hekalu hamwenga na athumia a Kiyahudi mario were madzire mamugwire, akiamba, “Mbona mudzire na mishu na njogoma here mudzaogwira jambazi? ");
INSERT INTO nyf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kila siku were ni hamwenga nanwi kahi za ro Hekalu na were k'amunigwira. Ela vivi bai ni wakathi wenu, ni wakathi ambawo nguvu za kiza zinathawala.” ");
INSERT INTO nyf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bai o at'u makimugwira Jesu na makimuthongozha muhaka nyumbani kwa ye Mulombi mubomu mwenye. P'et'ero ye akihenda kuathuwa kwa kure. ");
INSERT INTO nyf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Vikara ho kahikahi za wo muhala hakikala hadzakotw'a moho na hana at'u manauoha. P'et'ero achenda na achendakelesi hamwenga nao. ");
INSERT INTO nyf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Bai P'et'ero arihokala akelesi haho muhendzi wa kazi mumwenga wa kiche wamona, kwa vizho akimulolat'o, akimulolat'o kaheri gonya akiambira o andziye akiamba, “Yuyu mwanamulume be were yu hamwenga na yuyahu adziyegwirwa!” ");
INSERT INTO nyf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","P'et'ero arihosikira vizho akiamba, “M'ama, mut'u yuyahu be simumanya kamare!” ");
INSERT INTO nyf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","K'avitoere hachambola mut'u mungine akimona ye P'et'ero na akiamba, “Uwe be u mumwenga waho kahi za aryahu at'u.” P'et'ero akidzigidzya akiamba, “Hatha. Si mumwenga waho bule ts'awe!” ");
INSERT INTO nyf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kidza bada ya here saa ndzima kukira, hachambola mungine akisita kunena akiamba, “Jeri wenye kamare yuyu mwanamulume yuyu were a hamwenga na yuyahu adziyegwirwa. Kwani yuyu naye ni Mugalilaya t'i.” ");
INSERT INTO nyf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","P'et'ero arihosikira vizho akiamba, “Ts'awe, simanya unanena ut'u wani be vivi.” Na haho henye, kabila k'adzatosa, jogolo rikiika. ");
INSERT INTO nyf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ndo ye Bwana Jesu akigaluka na akimulola ye P'et'ero ko kwa uso. P'et'ero akikumbukira zho arizhokala adzambirwa ni ye Bwana Jesu, kukala, “kabila jogolo k'aridzaika uu usiku wa rero, undanikana k'ana t'ahu.” ");
INSERT INTO nyf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bai P'et'ero achambola ko ndze na achendarira na utsungu munji. ");
INSERT INTO nyf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Vikara o at'u mariokala manamurinda Jesu makikwatya kumuhendera kav̱udhye na kumupiga. ");
INSERT INTO nyf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mamuhala na makimufunga kizuzu, makimupiga gonya makimwamba, “H'aya fwambire! Ni h'ani ye adziyekupiga vino kare?” ");
INSERT INTO nyf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na lola at'u ao maenderera kumutsuha nyomba nyinji ye Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Vikara kurihocha, o athumia a Kiyahudi, alombi abomu na alimu a Sheria mathunganana. Ndo Jesu akirefwa hatha haho mbere za ro Baraza ra athumia. ");
INSERT INTO nyf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Makimuza makiamba, “H'aya fwambire, we ndiwe ye Masihi?” Jesu akiadzigidzya akiamba, “Hatha nikamwambira kisha k'amundakuluhira bule, ");
INSERT INTO nyf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na kidza hatha nikamuza swali k'amundanidzigidzya. ");
INSERT INTO nyf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ela kula vivi ye Mwana wa Mudamu andakelesi mukono wa kurya wa Mulungu mwenye nguvu.” ");
INSERT INTO nyf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Makimuza makiamba, “Vikara ndo fuambe we u Mwana wa Mulungu?” Jesu akidzigidzya akiamba, “Zho munenazho kukala ndimi be ni vizho.” ");
INSERT INTO nyf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ndo kusikira vizho makiamba, “Vino funa haja ya ushahidhi? Mana siswi enye fudzasikira here adzizhonena na kanwake!” ");
INSERT INTO nyf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ndo ro kundi rosi ra at'u rikiungarara na rikimuthongozha Jesu muhaka kwa luwali P'ilato. ");
INSERT INTO nyf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Marihofika kuko, makikwatya kumushithaki na kuamba, “Mut'u yuyu fwamugwira anaavuga akili at'u ehu. Kidza hatha anaambira at'u kukala masimboze kodi kwa Kaisari na kuno anadziamba kukala iye nde ye Masihi, yani muthawali.” ");
INSERT INTO nyf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kwa vizho P'ilato arihosikira vizho akimuza Jesu akiamba, “Vidze we ndiwe muthawali wa Ayahudi?” Jesu akimudzigidzya akimwamba, “Uwe udzanena.” ");
INSERT INTO nyf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na P'ilato akiagalukira o alombi abomu na ro kundi ra at'u na akiambira, “Mut'u yuyu simona na kosa rorosi ra kumuhendya ahukumiwe.” ");
INSERT INTO nyf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kusikira vizho, o at'u makikaza kamare kuamba, “Mut'u yuyu anavuga akili at'u kukirira na go mafundishoge na kuahenda mathinye bugwa kahi za Judea ndzima. Ut'u uu wauandza Galilaya na vino hatha adzavifisha kuku kamare.” ");
INSERT INTO nyf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","P'ilato arihosikira vivi waauza o at'u chamba ye mut'u madzemushithaki ni Mugalilaya. ");
INSERT INTO nyf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ndo arihombirwa kukala Jesu anambola kahi za jimbo rithawalwaro ni Herode, akiona baha alagize ahirikwe kwa iye Herode, ariye wakathi uwo were a mo Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","K'uzhona zho Herode arihomona Jesu wafwahirwa zhomu kwa kukala kwa muda mure were anathamani kumona. Naye kwa kukala were wasikira manji dzuluze were ana thamani kumona anahenda miujiza. ");
INSERT INTO nyf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kwa vizho Herode arihomona Jesu, wamuza-muza maswali manji, ela Jesu k'amudzigidzyire bule. ");
INSERT INTO nyf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kuno ko, o alombi abomu na alimu a Sheria maimire haho na manasita kuamba Jesu ana makosa. ");
INSERT INTO nyf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ndo Herode na shikarie makikwatya kumuv̱udhya na kumuzuma Jesu. Gonya makimuvika rivalo ridzo ra kithawali na makimulazha aujwe kwa luwali P'ilato. ");
INSERT INTO nyf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kula siku iyo Herode na P'ilato makigwirana usena, mana haho nyuma-nyuma were be k'amapatana kamare. ");
INSERT INTO nyf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bai marihofika kwa P'ilato, P'ilato waaiha hamwenga o alombi abomu na o vilongozi a o at'u, ");
INSERT INTO nyf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na akiambira vivi, “At'u ninwi mudzanirehera mut'u yuyu ambaye munaamba anaavuga akili at'u na kuhenda mathinye bugwa. Nidzamuza maswali mbere zenu na lola nikamona kukala kahi za gago gosi mudzigomushithaki nago, be k'ahana kosa rorosi arirohenda. ");
INSERT INTO nyf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hatha Herode naye kidza k'amonere na kosa ndosa akamudzya kuku kwehu. Kwa vizho k'ahendere ut'u wowosi uwi wa kumuhendya alagwe. ");
INSERT INTO nyf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nindizhohenda ni kulagiza apigwe vikotho gonya arichizwe.”  ");
INSERT INTO nyf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Vikara kahi za kila sherehe ya P'asaka, P'ilato were k'ana budhi kuavugulira mufungwa mumwenga. ");
INSERT INTO nyf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ela o at'u makipiga mikululu na kuamba, “Yuyu mwalage! Fuvugulire ye Baraba!” ");
INSERT INTO nyf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Baraba were ni mut'u ariyefungwa jela kwa kukala wakalamo kahi za bugwa ririrohendeka mo Jerusalemu na kahi za maut'u ga kulaga at'u.) ");
INSERT INTO nyf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","P'ilato were ahendzazho ni kumurichiza Jesu, kwa vizho akijaribu kunena na ro kundi ra at'u kaheri, ");
INSERT INTO nyf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ela o hatha makithuwa o wa, “Musulubishe! Musulubishe!” ");
INSERT INTO nyf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","P'ilato arihosikira vizho akiuza lwa hahu akiamba, “Asulubiwe kwa adzakosani kibomu? Nidzamulola na nikamona k'ana kosa ra hatha kukala ahukumiwe kwalagwa, kwa vizho ndalagiza apigwe vikotho na gonya arichizwe.” ");
INSERT INTO nyf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ela o at'u makikaza kamare kupiga mikululu na kuamba, asulubiwe. Na lola mwisho zo k'ululu zao zikishinda. ");
INSERT INTO nyf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kwa vizho P'ilato akimuhukumu kwalagwa ye Jesu here marizhokala manahendza. ");
INSERT INTO nyf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ndo akivugulirwa Baraba ariye were wafungwa kwa kuthinya bugwa na kwalaga, naye were nde mahendzaye avugulwe. Gonya P'ilato akimuhala Jesu na akimulazha kwao here marizhokala manamala. ");
INSERT INTO nyf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kwa vizho o shikari a Kirumi makimuhala Jesu machenda naye mende makamwalage. Bai marihokala makwendani makithungana mut'u aifwaye Simoni Muk'irene. Mut'u yuyu were anangira mo mudzini kula mashambani. O shikari marihomona mamugwira na makimuhika wo musalaba kithuroni, autsukule, kuno Jesu a mbere ye a nyuma. ");
INSERT INTO nyf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kidza ngororoki bomu ya at'u yakala inamuthuwa Jesu nyuma-nyuma. Kahi za ii ngororoki mwere muna anaache mariokala manapiga k'ululu na kurira kwa ut'u wa go garigokala ganamukalira Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesu arihoona vizho waagalukira o anaache na akiambira, “H'enwi ano m'ama a Jerusalemu, at'u ninwi musirireni kwa ut'u wa kunishikithikira mimi, ela dziririreni ninwi enye hamwenga na ana enu. ");
INSERT INTO nyf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwani lolani siku za thabu zinadza ambaho at'u mandaamba, ‘Baha ao anaache mario ni t'asa, baha ao mario k'amazhalire ahoho, hedu hatha kuamwisa ana!’ ");
INSERT INTO nyf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Gonya mandanena na mirima na mayambe, ‘Nwi mirima h'aya fugwerereni!’ Na zho virima vithithe-vithithe mandazhambira, ‘Hedu hufinikireni!’ ");
INSERT INTO nyf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kwani ikikala at'u manadima kuhenda maut'u gaga kwa muhi mwitsi vidze makivihenda kwa muhi mufu vindakaladze?” ");
INSERT INTO nyf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kidza were hana ahendi a mai airi, bai aa nao mathongozhwa hamwenga na Jesu kwendalagwa. ");
INSERT INTO nyf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ndoo vivii, hatha hat'u haifwaho Ribeshe ra Kitswa, bai haho makimusulubisha Jesu. Naye wasulubiwa hamwenga na ahendi a mai airi, mumwenga mukono wa kurya, na mungine mukono wa kumots'o.  ");
INSERT INTO nyf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ndo Jesu akiamba, “Baba asamehe! Mana k'amamanya ro mahendaro.” O shikari makizigazha zo nguwo za Jesu. Nao mahenda vivi kwa kuhenda kuzipigira k'ura. ");
INSERT INTO nyf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na o at'u makikala ma haho manavilolera zho vikalazho, kuno ko o vilongozi a Kiyahudi makikala manamusholera Jesu na kuamba, “H'aya k'aokola angine, vivi be ni adziokole mwenye kala nde iye Masihi jeri ariyetsagulwa ni Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na o shikari nao makihenda dza vizho zhenye mamuv̱udhya Jesu, kwani mamuthuwa hehi na makimup'a siki, ");
INSERT INTO nyf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","makimwamba, “H'aya dziokole mwenye kala u muthawali wa Ayahudi jeri!” ");
INSERT INTO nyf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kidza ho dzulu za kitswache hakotw'a kibao kirichokala chaorwa maneno gaga: Yuyu Nde Muthawali Wa Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Vikara mumwenga kahi za o ahendi a mai ariyekala adzanganywa haho, wamusholera Jesu akimwamba, “Vidze we siwe ye Masihi bule? H'aya dziokole mwenye gonya ufuokole naswi!” ");
INSERT INTO nyf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ye mungine ye arihosikira vizho akimudumulira ye mwandziwe akiamba, “We fuambe kumwogoha Mulungu bule? Siswi hosini ahahu fwahukumiwa vimwenga. ");
INSERT INTO nyf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Na bai siswi zho furizhohukumiwa ni karakara, kwani zho fuhendwazho be vinalengana na go mai furigogahenda, ela yuyu be k'ahendere rii rorosi.” ");
INSERT INTO nyf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Gonya akimwamba Jesu, “Nikumbukira bai Jesu, undihokudza kahi za uthawaliwo!” ");
INSERT INTO nyf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesu akimudzigidzya akiamba, “Nakwambira ujeri wenye, vivi rero kare fundakwenda hosini p'ehoni.” ");
INSERT INTO nyf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ganakala gago were ni saa t'andahu, bai ts'i yosi yagit'ana kiza muhadhi saa chenda, ");
INSERT INTO nyf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","mana ro dzuwa raricha kuala na yo p'azia ya nguwo kahi za ro Hekalu ikitharuka h'waa p'ande mbiri. ");
INSERT INTO nyf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Gonya Jesu akipiga k'ululu akiamba, “Baba, yo roho yangu ninayika mikononi mwako.” Naye ko kugonya kunena vizho thu, akimarigizika kare. ");
INSERT INTO nyf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Bai ye mubomu wa shikari arihoona vizho virizho were vidzahendeka wamulika Mulungu na akiamba, “Ni jeri mut'u yuyu were k'ana makosa gogosi.” ");
INSERT INTO nyf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Vikara ro kundi ra at'u mario were madzirelolera zho vikalazho marihoona go maut'u gago gakihendeka, mauya midzini kwao kuno manathukusa vitswa zhao kwa kushikithika. ");
INSERT INTO nyf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na o at'u mario were ni asena a Jesu, ambao angine were ni aryahu anaache mariokala madzamuthuwa Jesu kula Galilaya, maima kure vichache na makilolera maut'u gaga. ");
INSERT INTO nyf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Vikara kwereko na mut'u mumwenga ariyeifwa Josefu naye were anambola mudzi mumwenga wa Ayahudi uifwao Arimath'ea. Iye were ni mut'u mudzo kidza ni muhachi, na were anauthariza uthawali wa Mulungu. Idzaho were ni mumwenga waho kahi za ro Baraza ra athumia, iye k'aaungire mukono kahi za gago marigogahenda. ");
INSERT INTO nyf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Bai wakwenda hatha kwa P'ilato na achendaumala mwiri wa Jesu akauzike. ");
INSERT INTO nyf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Arihoruhusiwa wakwendamuthinya akimulinga-linga ts'andza ya kitani, na achendamwika kahi za mbira iriyohenda kutsongwa iweni. Mbira ii were k'aidzahumirwa bule. ");
INSERT INTO nyf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ganakala gago were ni siku ya Mathayarisho, mana siku ya Sabato were i hehi na kwangira. ");
INSERT INTO nyf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na aryahu anaache mariokala mamuthuwa Jesu hangu Galilaya, makwenda na Josefu na machendayona yo mbira na makiona viryahu mwiriwe urizhoikwa. ");
INSERT INTO nyf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ndo makiuya midzini kwao na machendathayarisha mavumba na marashi ga kudzaumwagira mwiri wa Jesu. Na irihofika siku ya Sabato makioya here Sheria iambazho. ");
INSERT INTO nyf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Vikara irihofika siku ya kwandza ya wiki o anaache mauka na madzach'a maitsi machenda ko mbirani na go mavumba marigokala madzagathayarisha mende makamumwagire here adha rao ririzho. ");
INSERT INTO nyf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Marihofika kuko machendaona ro riiwe ra kubiningizira yo mbira ridzapingiliswa kure na yo mbira. ");
INSERT INTO nyf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ela hatha vizho machangira mo ndani, mariholola k'amawonere bule wo mwiri wa Bwana Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Marihokala machere haho kudangana-dangana, lola mahenda kuona anaalume airi maimire hehi nao. At'u alume aa mere madzavala nguwo za kumetha-metha. ");
INSERT INTO nyf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bai o anaache mapiga mavindi makidzizanya kuno nyuso zao zinalola ho ts'i kwa ut'u wa woga munji mariokala nawo. O at'u alume machambola kuuza makiamba, “Mbona munamumala mut'u ariye moyo kahi za at'u mariofwa? ");
INSERT INTO nyf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","K'aho bule be haha, adzafufuka! Amba munakumbukira zho arizhokala akimwambira arihokala achere nanwi ko Galilaya? ");
INSERT INTO nyf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kukala Mwana wa Mudamu andalazhwa mikononi mwa at'u enye dambi, kidza andasulubiwa, ela indihofika siku ya hahu andafufuka kaheri.” ");
INSERT INTO nyf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ndo haho o ana ache makikumbukira go maneno ga Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bai marihouya kula ko mbirani makwendaambira o anafundzi kumi na mumwenga na o angine osi gaga maut'u gaga. ");
INSERT INTO nyf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Anaache aa were ni Maryamu Magidalena na Joana, na Maryamu mameye Jakobu. Aa hamwenga na o angine mariokala hamwenga nao ndo mariokwendaambira o ahumwi dzulu za maut'u gaga. ");
INSERT INTO nyf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ela o ahumwi makiona go marigonena o ana ache be k'agana mana yoyosi, kwa vizho k'amaakuluhirire bule. ");
INSERT INTO nyf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ela hamwenga na vizho, P'et'ero waungarara na akikot'a malo kwenda ko mbirani. Arihofika kuko akizama akilola na akizona zo nguwo za sandza zi h'akeye. Ndo akiuka akikwatya kuuya kuno anaaza mo moyoni, “Ut'u uno udziwohendeka ni ut'u wani?” ");
INSERT INTO nyf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Vikara siku iyo vizho, hakikala hana anafundzi airi a Jesu manenda kadzidzi kaifwako Emau. Kadzidzi kaka were ka here maili fungahe vivi kula Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Anafundzi aa were manenda kuno manasumurira dzulu za kila kit'u ambacho were chahendeka. ");
INSERT INTO nyf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","K'uzhona zho marihokala manasumurira, Jesu waasongerera na akinenda hamwenga nao, ");
INSERT INTO nyf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ela ao k'amadimire kumumanya bule kwani matso gao were gadzaziywa. ");
INSERT INTO nyf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ndo Jesu akiuza akiamba, “Munasumurira dzulu za ut'u wani nwi kuno munenda?” Kusikira vizho makiima thii, kuno nyuso zao zidzakundzika kwa huzuni. ");
INSERT INTO nyf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mumwenga wao kahi za aa airi were nde Kileopa. Vikara yuyu akimuza Jesu akiamba, “Unamala uambe u mujeni muno Jerusalemu hatha k'umanya maut'u garigohendeka vino dzuzi-dzuzi?” ");
INSERT INTO nyf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesu akiauza akiamba, “Ni maut'u gani be go?” O anafundzi makimudzigidzya makiamba, “Ni maut'u garigomukalira mut'u aifwaye Jesu wa Nazareth'i. Mut'u yuyu were ni nabii na were ana nguvu mbere za Mulungu na mbere za at'u osi. Nguvu zizi zaoneka kahi za kunenakwe na hatha kahi za mahendoge. ");
INSERT INTO nyf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bai o alombi abomu na o vilongozi ehu, makimulazha ili ahukumiwe kwalagwa, ndo akisulubiwa. ");
INSERT INTO nyf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Siswi were huna th'amaa kukala iye nde ariye angakombola ts'i ya Iziraeli! Zaidhi ya gago ni kwamba rero ni hahu hangu gakale gaga. ");
INSERT INTO nyf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Na ut'u ungine ni kwamba ano m'ama ehu angine madzahushangaza. At'u ao madzarauka ko mbirani madzach'a, ");
INSERT INTO nyf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ela madzihofika kuko, k'amawonere bule wo mwiri wa Jesu. Ndo makadza na makahuthalira uv̱oro wa kukala madzaona maono ga malaika na makaambira kukala ye Jesu a moyo! ");
INSERT INTO nyf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Badaye angine ehu makenda vivii, hatha ko mbirani. Madzihofika kuko makaona zho madzizhoamba o anaache zhenye, ela ye Jesu mwenye k'amamonere bule.” ");
INSERT INTO nyf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesu akiambira, “Mbona mu azuzu namuna ino? Mbona muna kiziho na kukuluhira go garigonenwa ni manabii ho kapindi? ");
INSERT INTO nyf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Vidze were k'avimala ye Masihi apate thabu na badaye angire kahi za ngumaye?” ");
INSERT INTO nyf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","K'uzhona zho Jesu akikwatya kuang'aziza gosi garigo kahi za Maoro ganenago dzuluze. Jesu waandza na zhuwo zhosi zha Musa na hatha Maoro ga manabii osi, akiaeleza. ");
INSERT INTO nyf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Vikara marihokala madzafika hehi na ko kadzidzi marikokala manenda, Jesu were ni here andiyekira ende ko mbere ya ko kadzidzi. ");
INSERT INTO nyf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kuona vizho makimusitira makiamba, “H'aa, ni zhani bai, kala naswi kwani hatha dzuwa rinenda kupothokani na dzulo rinangira kare.” Kwa vizho Jesu k'akahalire achenda hamwenga nao. ");
INSERT INTO nyf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Vikara arihokala adzakelesi kuhumira chakurya hamwenga nao, wahala mukahe akimboza muv̱era kwa Mulungu gonya akiumogola na akiap'a. ");
INSERT INTO nyf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Haho ndo matso gao gakigunuka na makimumanya ye Jesu. K'avitoere, ko kumumanya thu, achangamika kare haho kwa haho ");
INSERT INTO nyf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Na lola makikwatya kuuzana-uzana na kuamba, “Vidze kurya ngirani amba mioyo yehu were ina raha zhomu, adzihokala ananena naswi na kufung'azira garya garigo kahi za Maoro?” ");
INSERT INTO nyf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bai makiungarara kare na makikwatya kuuya Jerusalemu. Marihofika kuko makionana na aryahu ahumwi kumi na mumwenga hamwenga na anafundzi angine a Jesu. ");
INSERT INTO nyf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na o airi kuonewa thu makiambwa, “Aa ni jeri benwi! Ye Bwana be adzafufuka jeri na hatha akamwambolera Simoni.” ");
INSERT INTO nyf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Gonya o airi nao makithala garyahu ambago were gadzaakalira mo ngirani kwenda Emau, na viryahu ambazho mamumanya ye Jesu arihomogola mukahe. ");
INSERT INTO nyf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Na lola hatha were k'amadzatosa wo moro wao, poo ye Jesu mwenye na akiima kahi zao. Akialamusa akiamba, “Dheri narikale kwenu.” ");
INSERT INTO nyf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lola makihondoka na makidzalwa ni woga, kwani maona manaona p'ep'o be o. ");
INSERT INTO nyf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ela Jesu akiauza akiamba, “Mbona munabudzyika kaheri? Kwanoni mioyo yenu i thele kutsakuluhira? ");
INSERT INTO nyf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","H'aya nilolani go magulu na yo mikono yangu hedu, samba ndimi mino! Nigut'ani mulole hedu, kwani p'ep'o k'ana mwiri hedu hatha misoza, dza here nirizho mimi.” ");
INSERT INTO nyf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Arihogonya kunena vizho, akianyesa go magandzage na go maguluge. ");
INSERT INTO nyf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ndo marihokala machere k'amadzakuluhira kwa ut'u wa ro fwahiro bomu na ko kushangaa, Jesu akiauza akiamba, “Vidze muna ut'u wowosi wa kurya hano?” ");
INSERT INTO nyf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bai makihala kisiku cha kumba ra kukanja makimup'a. ");
INSERT INTO nyf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesu akikihala cho kisiku cha kumba na akikirya manalola. ");
INSERT INTO nyf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Gonya akiambira, “Maut'u gaga genye be ndo nirigokala nikimwambira nirihokala nichere hamwenga nanwi, kukala kila kit'u kirichoorwa dzulu zangu kahi za Sheria ya Musa na zhuwo zha manabii na hatha kahi za zhuwo zha zaburi suthi vithimire.” ");
INSERT INTO nyf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Gonya akiahendya madime kung'alirwa ni go Maoro. ");
INSERT INTO nyf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kidza akiambira, “Vivi ndizho ambazho zhaorwa, kukala ye Masihi were suthi apate thabu na kidza afwe na siku ya hahu afufuke kula kifwani. ");
INSERT INTO nyf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na at'u osini a kila kabila, kuandzira mudzi wa Jerusalemu mahubiriwe kahi za dzinare kwamba mathubu na mausizwe dambi zao. ");
INSERT INTO nyf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ninwi bai mu mashahidhi a maut'u gaga. ");
INSERT INTO nyf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na lolani mimi mwenye bai nindamuhirikira viryahu virizholagwa ni Baba. Ela kabila vizho, kalani haha Jerusalemu muhaka mundihovikwa nguvu za kula dzulu mulunguni.” ");
INSERT INTO nyf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Badaye akialongoza kuwombola wo mudzi muhaka kadzidzi ka Beth'ania, marihofika kuko Jesu akinula mikonoye na akiahasa. ");
INSERT INTO nyf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bai arihokala achere kuahasa akiahaukira na akinulwa achenda mulunguni. ");
INSERT INTO nyf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","O anafundzi makimuabudu gonya makiuya Jerusalemu na fwahiro bomu. ");
INSERT INTO nyf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nao makala kahi za ro Hekalu siku zosi kumulika Mulungu.");
INSERT INTO nyf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Haho chaho kwakala neno, na iye Neno wakala kwa Mulungu, na ye Neno wakala ni Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hangu ho chaho ye Neno were a kwa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Vit'u zhosi zhaumbwa kwa kukirira kwakwe. Na k'ahana kit'u hatha kimwenga kirichoumbwa hasiho kukirira kwakwe. ");
INSERT INTO nyf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iye Neno were nde chaho cha uzima, na uzima uu wareha mulangaza kwa anadamu. ");
INSERT INTO nyf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mulangaza uu, unang'ala kizani na kiza k'akiwadimire. ");
INSERT INTO nyf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bai kwereko mut'u mumwenga ariyehumwa ni Mulungu, dzinare ni Johana. ");
INSERT INTO nyf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mut'u yuyu wakudza kwamba aambirize at'u dzulu za wo mulangaza, kwamba kukirira kwa iye Johana at'u osi madime kukuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iye mwenye were siye mulangaza bule, ela wakudzaambiriza at'u dzulu za uwo mulangaza. ");
INSERT INTO nyf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na uwo mulangaza wa jeri ung'alirawo kila mut'u, were unadza urumwenguni. ");
INSERT INTO nyf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iye were a urumwenguni, na uwo urumwengu waumbwa kukirira na iye, ela kidza o at'u a urumwengu k'amamumanyire bule. ");
INSERT INTO nyf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mut'u iye wakudza kwa a kwakwe enye, ela o mario akwe k'amamuhokerere. ");
INSERT INTO nyf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ela mwero wa osi aryahu mariomuhokera na kumukuluhira waap'a wadimi wa kukala ana a Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ana aa k'amazhalirwe kwa ngira ya kibinadamu, hedu kwa mahendzo ga mut'u, ela mazhalwa ni Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","K'uzhona zho, Neno akikala mut'u na akitoa hamwenga naswi. Bai hukiona ngumaye. Nguma ii were ni yakwe kwa kukala were nde Mwana wa h'akeye kula kwa babaye, naye were adzere nema na ujeri. ");
INSERT INTO nyf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Kwa vizho Johana wamboza ushahidhi dzuluze, akiluta mumiro akiamba, “Yuyu nde yuyahu niriyekala ninamwamba nirihoamba kukala, ‘Iye adzaye nyuma zangu be ni mubomu kuriko mimi, kwa kukala wakalako hatha kabila mimi sidzakalako.’ ” ");
INSERT INTO nyf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Bai siswi hosi fwahokera nema ya kukup'ulirwa kula kwa uthimiri wa kwakwe. ");
INSERT INTO nyf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kwani Sheria yalazhwa kukirira kwa Musa, ela nema na ujeri zhakudza kukirira kwa Jesu Masihi. ");
INSERT INTO nyf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","K'ahana mut'u ariyemona Mulungu, ela ye Mulungu Mwana, ariye ni Mwana wa h'akeye ariye lagani hakwe nde ariyehumanyisa iye Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Bai vivi ndizho Johana arizhoamba wakathi Ayahudi marihoahuma alombi na Alawi kula Jerusalemu kwamba makamuze maambe, “U h'ani we?” ");
INSERT INTO nyf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Marihofika kuko, Johana k'akahalire kuadzigidzya, ela waambira lwazu-lwazu akiamba, “Mimi si iye Masihi bule.” ");
INSERT INTO nyf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Marihosikira vizho makimuza kaheri makiamba, “Vikara u h'ani? U Elija?” Johana akidzigidzya akiamba, “Mimi si Elija bule.” Makimuza kaheri makiamba, “We u iye nabii?” Johana akiadzigidzya akiamba, “Hatha bule.” ");
INSERT INTO nyf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mwisho kamare makimuza makiamba, “Vikara u h'ani? Hup'e jibu hukaambire aryahu at'u madziohuhuma. Vidze unaambadze dzuluzo?” ");
INSERT INTO nyf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Johana akidzigidzya akiamba, “Here nabii Isaya arizhonena, Mimi ni mut'u alutaye mumiro ko nyika na kuamba, ‘Mutengezereni Bwana ngira ya kugoloka.’ ” ");
INSERT INTO nyf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","O at'u mariokwenda kwa Johana, were madzahumwa ni Mafarisayo. ");
INSERT INTO nyf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bai makimuza Johana makiamba, “Kala k'u Masihi na k'u Elija, hedu ye nabii humutharizaye, mbona unabat'iza at'u?” ");
INSERT INTO nyf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johana akiadzigidzya akiamba, “Mimi ninabat'iza at'u kwa madzi, ela kahikahi zenu haimire mut'u musiyemumanya. ");
INSERT INTO nyf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Na iye bai ndiye adzaye nyuma yangu ambaye mimi siv̱irya hatha kumuvula virahuzhe.” ");
INSERT INTO nyf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Maut'u gaga gahendeka kuko Beth'ania, nyangamo ya hiri ya muho wa Jorodani arikokala Johana anabat'iza at'u. ");
INSERT INTO nyf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Siku ya hiriye Johana akimona Jesu anadza na arihomona akiamba, “Lolani thiyu ye Mwana Ng'ondzi wa Mulungu ausaye dambi ya urumwengu. ");
INSERT INTO nyf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yuyu ndiye niriyekala ninaamba haho nirihonena nikiamba, ‘Iye mut'u adzaye nyuma zangu, ni mubomu kuriko mimi, mana wakalako hatha kabila mimi sidzakalako.’ ");
INSERT INTO nyf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mut'u mimi sidimire kumanya kala andakala h'ani, ela nakudza nibat'ize at'u na madzi kwamba adime kuonyeswa kwa Aiziraeli.” ");
INSERT INTO nyf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Gonya Johana achamboza ushahidhi akiamba, “Naona ye Roho akitserera kula mulunguni dza here giya na akimuthulama. ");
INSERT INTO nyf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Sikamumanyire, ela ye ariyenihuma nibat'ize at'u na madzi wanambira vivi, ‘Ye mut'u ambaye undaona Roho anatserera na kumuthulama, be ndiye iye andebat'iza at'u kwa Roho Mweri.’ ");
INSERT INTO nyf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nami nidzazhona na ninamboza ushahidhi kwamba yuyu nde Mwana wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Bai siku ya hiriye kaheri, Johana were aimire haho na anafundzie airi, ");
INSERT INTO nyf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","bai arihomona Jesu anatsembera akiamba, “Lolani thiye ye Mwana Ng'ondzi wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","O anafundzi airi makimusikira Johana ananena vivi, makimuricha na makimuthuwa Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesu akigaluka na akiaona o anafundzi airi manamuthuwa, akiauza akiamba, “Munamalani nwi?” Makidzigidzya makiamba, “Ukalahi kwani Rabi?” (Rabi manaye ni mwalimu.) ");
INSERT INTO nyf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesu akiamba, “Ndzoni muhaone hedu.” Kwa vizho machenda naye na makiona ho akalaho na makikala hamwenga naye siku iyo. Ganakala gaga were ni murongo wa saa kumi za dziloni. ");
INSERT INTO nyf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mumwenga wa aryahu airi mariomusikira Johana ananena na machenda na Jesu, were ni Anderea, nduguye Simoni P'et'ero. ");
INSERT INTO nyf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kit'u cha kwandza arichohenda Anderea wakwendamona nduguye Simoni na akimwambira vivi, “Hudzamona ye Masihi bewe.” (Mana ya Masihi ni mut'u ariyetsagulwa ni Mulungu.) ");
INSERT INTO nyf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Gonya Anderea akimuhirika Simoni kwa Jesu. Bai Jesu akimulola na akiamba, “Uwe u Simoni mwana wa Johana, ela dzinaro rindakala K'efa.” (K'efa manaye ni P'et'ero yani iwe.) ");
INSERT INTO nyf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Siku ya hiriye akiona baha ende Galilaya. Bai akimona Filipu, na Jesu akimwamba Filipu, “Nithuwa hedu.” ");
INSERT INTO nyf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipu wakala ni mut'u wa Beth'isaida, kut'u arikotoa Anderea na P'et'ero. ");
INSERT INTO nyf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ndo Filipu akiuka kwenda kwa Nath'anieli na achendamwamba, “Nath'anieli hudzamona iye ambaye Musa waora maut'u dzuluze kahi za cho chuwo cha Sheria, na kidza ambaye manabii maora dzuluze. Dzinare ni Jesu wa Nazareth'i, mwana wa Josefu.” ");
INSERT INTO nyf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nath'anieli arihosikira vizho akiuza akiamba, “Vino kuna kit'u kidzo kidimacho kwambola kula Nazareth'i jeri?” Filipu akimwamba, “Ndzo ulole.” ");
INSERT INTO nyf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesu arihomona Nath'anieli anamudzirira akiamba, “Lolani, thiyu Muiziraeli jeri-jeri ambaye k'ana ulongo wowosi ndanimwe.” ");
INSERT INTO nyf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nath'anieli akimuza akiamba, “Udzanimanyadze?” Jesu akidzigidzya akiamba, “Nidzakona haryahu udzihokala u ts'ini za uryahu mutini. Na hatha Filipu were k'adzakwiha.” ");
INSERT INTO nyf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nath'anieli akimudzigidzya akiamba, “Rabi, uwe u Mwana wa Mulungu, u muthawali wa Iziraeli.” ");
INSERT INTO nyf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesu akiamba, “Unakuluhira kwa kukala nidzakwambira dzakona udzihokala u ts'ini za mutini? Be undaona maut'u mabomu kukira gaga.” ");
INSERT INTO nyf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesu akienderera kunena akiamba, “Ninamwambira ujeri, mundaona mulunguni ku lwazu na malaika a Mulungu manambuka na kutharamuka kwa Mwana wa Mudamu.” ");
INSERT INTO nyf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bada ya siku mbiri kukikala na harusi kuko K'ana, mudzi wa Galilaya; na mameye Jesu akikala a kuko. ");
INSERT INTO nyf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu naye na anafundzie masungwa yo harusi. ");
INSERT INTO nyf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bai divai ya yo harusi irihogoma mameye Jesu akimwambira, “Divai idzaagomera kuryahu.” ");
INSERT INTO nyf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesu akimwamba, “Kwanoni unanambira zho m'ama? Wakathi wangu k'audzafika bule.” ");
INSERT INTO nyf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ye mameye akiambira o ahumiki akiamba, “Tengezani rorosi andiromwambira.” ");
INSERT INTO nyf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bai kwereko kuko mabiga mahandahu ga mawe garigoikwa kwa adha ra Ayahudi ra kuoga. Kila mwenga were rinangira geleni mirongo miri hedu mirongo mihahu za madzi. ");
INSERT INTO nyf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Bai Jesu akiambira o ahumiki akiamba, “Dzazani mabiga gaga na madzi.” Kwa vizho makigadzaza mulembelembe. ");
INSERT INTO nyf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Gonya Jesu akiambira o ahumiki, “Vikara hekani mukamup'e ye kilongozi wa yo sherehe.” Bai makiheka makimuhirikira, ");
INSERT INTO nyf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","na ye kilongozi akithatha go madzi garigokala gadzagaluka divai. K'amanyire idzambolahi, ingahokala o ahumiki mariokala madzaheka go madzi were manamanya zho vidzizhokala. Bai ye kilongozi akimuvuha k'anda ye bwana harusi, ");
INSERT INTO nyf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na akimwamba, “Kawaida mut'u ni kumboza divai mbidzo kwandza ndo gonya kala at'u madzanwa zhomu zhenye, akamboza yo mbii-mbii, ela we vivi udzayika yo mbidzo hatha vivi ndo unayomboza.” ");
INSERT INTO nyf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Bai uu ndo muujiza wa kwandza kamare ariouhenda Jesu. Nawo wauhenda K'ana, mudzi uriwo ko Galilaya, bai akinyesa ngumaye na o anafundzie makimukuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bada ya vivi Jesu na mameye na nduguze na anafundzie makitharamuka Kaperinaumu kwa siku mbiri t'ahu. ");
INSERT INTO nyf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Gonya wakathi wa sikuk'uu ya Kiyahudi ya P'asaka urihofika hehi, Jesu wambuka kwenda Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Bai arihokwenda kahi za ro Hekalu akiona at'u haho, managuza ng'ombe na ng'ondzi na magiya. Kidza were kuna angine mariokala manabanda p'esa, makeresi na meza zao. ");
INSERT INTO nyf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesu akisuka kikotho cha nyugwe na akiainga osi mo Hekaluni hamwenga na zo ng'ombe na ng'ondzi zao. Na kidza akizipetula-petula zo meza zao, na zo p'esa zosi zikimwagika! ");
INSERT INTO nyf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Akiadumulira o mariokala managuza magiya akiamba, “H'aya gauseni gaga mumu! Siigaluzeni nyumba ya Baba na kuihendya soko!” ");
INSERT INTO nyf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Gonya o anafundzi marihoaza dzulu ya zho arizhohenda Jesu, makikumbukira viryahu virizhondhikwa kahi za Maoro zhaambazho, “Mulungu, hat'u ha kukuvoya ha moyoni mwangu zhomu hatha sina zha kuhenda.” ");
INSERT INTO nyf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ndo o Ayahudi makimwamba, “Undafwanyesa muujiza wani hatha fumanye una wadimi wa kuhenda gaga?” ");
INSERT INTO nyf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesu akiadzigidzya akiamba, “Ribandeni riri Hekalu, nami nindariaka kaheri kwa siku t'ahu.” ");
INSERT INTO nyf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","O vilongozi makimwamba, “Hekalu riri raakwa kwa muda wa miaka mirongo mine na mihandahu, undadima jeri kuriaka kwa siku t'ahu we?” ");
INSERT INTO nyf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ela Jesu were ananena vivi kuhusu Hekalu ra uwo mwiriwe. ");
INSERT INTO nyf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bai arihofufuka, anafundzie makumbukira kukala ut'u uu were waunena kare. Ndo makikuluhira garyahu Maoro na riryahu neno arironena Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Bai Jesu arihokala a kuko Jerusalemu wakathi uwo wa sikuk'uu ya P'asaka, wahenda miujiza minji kwa nguvu za Mulungu. Kwa ut'u uwo at'u anji makimukuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ela Jesu k'aakuluhirire, kwani waamanya at'u osi t'ot'ot'o. ");
INSERT INTO nyf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","K'akukalire na haja ya mut'u kumwambira dzulu ya at'u, mana wamanya garigokala mioyoni mwao. ");
INSERT INTO nyf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bai kwereko mut'u mumwenga aifwaye Nikodemu. Nikodemu were ni kilongozi wa Ayahudi ariyekala kahi za chama cha Mafarisayo. ");
INSERT INTO nyf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Siku mwenga wakwenda kwa Jesu na usiku, achendamwamba, “Rabi hunamanya kukala u mwalimu ariyehumwa ni Mulungu. Mana k'akuna adimaye kuhenda ii miujiza uhendayo hasiho Mulungu kukala hamwenga naye.” ");
INSERT INTO nyf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesu akimwamba, “Ninakwambira ujeri wenye, mut'u asihozhalwa mara ya hiri, k'adima kuwona uthawali wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu akiuza akiamba, “Mut'u adimadze kuzhalwa kaheri kala adzakala muthumia? Vidze anadima kwangira kaheri ndanini mwa mameye na akazhalwa?” ");
INSERT INTO nyf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesu akimwamba, “Ninakwambira ujeri wenye, mut'u asihozhalwa kwa madzi na Roho k'adima kwangira kahi za uthawali wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kizhalwacho ni mwiri, ni mwiri na kizhalwacho ni Roho, ni roho. ");
INSERT INTO nyf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Usangalale kwa zho nidzizhonena kwamba, ‘Suthi muzhalwe lwa hiri.’ ");
INSERT INTO nyf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lola p'eho nikuvuma kokosi ihendzako. Unadima kuisikira ivumazho, ela k'udima kumanya ilako hedu yendako. Bai ndo virizho na kila mut'u azhalwaye ni Roho.” ");
INSERT INTO nyf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu akiamba, “Maut'u gano ganadima kukaladze?” ");
INSERT INTO nyf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesu akiamba, “U mwalimu wa Iziraeli, ela ko maut'u gaga k'ugamanya? ");
INSERT INTO nyf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ninakwambira ujeri, hunanena humanyago na hunamboza ushahidhi wa hurigogaona, ela hatha hamwenga na vizho ninwi at'u k'amukubali ushahidhi wehu. ");
INSERT INTO nyf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nidzamwambira maut'u ga urumwenguni na k'amukuluhira. Vidze, ela mundakuluhira nikimwambira maut'u ga mulunguni? ");
INSERT INTO nyf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“K'akuna mut'u ariyekwenda mulunguni, hasihokala iye ariyethima kula mulunguni ambaye ni Mwana wa Mudamu. ");
INSERT INTO nyf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Here Musa arizhomwanula ye nyoka wa ng'andu ko nyika, ndizho Mwana wa Mudamu arizho suthi anulwe, ");
INSERT INTO nyf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kwamba kila mut'u amukuluhiraye akale na uzima wa kare na kare. ");
INSERT INTO nyf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Kwa mana Mulungu wauhendza urumwengu zhomu hatha akimulazha Mwanawe wa h'akeye ili kila amukuluhiraye asingamike, ela akale na uzima wa kare na kare. ");
INSERT INTO nyf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mulungu k'amuhumire Mwanawe urumwenguni ili adze auhukumu, ela uokolwe kukirira kwa iye. ");
INSERT INTO nyf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kila amukuluhiraye ye Mwana k'ahukumiwa, ela kila asiyemukuluhira adzahukumiwa kare, kwa kukala k'amukuluhirire Mwana wa h'akeye wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Bai chausa cha hatha at'u mahukumiwe ni kiki; wo mulangaza wakudza urumwenguni, ela o at'u makihendza kiza kuriko wo mulangaza kwa kukala mahendo gao ni mai. ");
INSERT INTO nyf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kwani kila mut'u ahendaye mai nikuutsukirirwa wo mulangaza, na k'andakudza ho mulangazani sidze mahendoge gakaoneka. ");
INSERT INTO nyf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ela kila mut'u ahendaye ga hachi nikudza mulangazani kwamba adzigogahenda gaoneke lwazu kukala adzagahenda kukirira kwa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bada ya gaga, Jesu na anafundzie mambola Jerusalemu na akikala hamwenga nao kwa muda kahi za jimbo ra Judea na akibat'iza at'u. ");
INSERT INTO nyf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Johana naye were anabat'iza at'u kuko Enoni hehi na Salimu, kwani were kuna madzi manji kuko, na at'u manadza makibat'izwa. ");
INSERT INTO nyf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wakathi uwo Johana were k'adzangwe kwangizwa jela bule. ");
INSERT INTO nyf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bai kuchambola h'uwoh'uwo kahi za anafundzi a Johana na Muyahudi mumwenga dzulu za adha ra kuoga. ");
INSERT INTO nyf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ndo makidza kwa Johana na makimwambira, “Rabi, unamukumbukira yuya mut'u ariyekala nawe nyangamo ya hiri ya Jorodani, yuya uriyenena dzuluze? Lola vivi anabat'iza na kila mut'u anamuthuwa!” ");
INSERT INTO nyf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johana akiamba, “K'akuna adimaye kukala na kit'u hasiho kukigerwa kula mulunguni. ");
INSERT INTO nyf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ninwi enye mu mashudhia gangu kukala naamba, ‘Mimi si Masihi,’ ela naamba, ‘Nahumwa mbereze.’ ");
INSERT INTO nyf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mimi ni here muhiriki wa bwana harusi. Ye bwana harusi nde mwenye bibi harusi. Muhiriki wa bwana harusi nikuima na kusirikiza, na nikufwahirwa asikiraho sauthi ya bwana harusi. Vivi ndo hatha nina raha zhomu. ");
INSERT INTO nyf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Vinav̱irya ngumaye ingezeke na yangu ihunguke. ");
INSERT INTO nyf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ye mut'u adzaye kula dzulu ni mubomu kuriko at'u osi; naye mut'u wa haha ts'i ni wa haha ts'i, na nikunena maut'u ga haha ts'i. Ela iye adzaye kula mulunguni ni mubomu kuriko osi. ");
INSERT INTO nyf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mut'u iye anena vizho arizhoona na kusikira, ela k'akuna akubaliye ushahidhiwe. ");
INSERT INTO nyf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kila akubaliye ushahidhiwe anathibitisha kukala Mulungu ni jeri. ");
INSERT INTO nyf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Bai iye ahumwaye ni Mulungu nikunena maneno ga Mulungu, kwa kukala Mulungu nikumup'a unji wa Rohore. ");
INSERT INTO nyf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","“Iye Baba anamuhendza Mwanawe na adzazhika vit'u zhosi mikononi mwakwe. ");
INSERT INTO nyf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kila amukuluhiraye ye Mwana yuna uzima wa kare na kare, ela kila amukahalaye k'andawona uwo uzima uwo, ela k'oro za Mulungu zi dzuluze.” ");
INSERT INTO nyf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Bai Mafarisayo masikira kukala Jesu anapata na kubat'iza anafundzi anji kuriko Johana. (Ingahokala Jesu mwenye were k'abat'iza, isihokala anafundzie.) K'uzhona zho Jesu arihomanya kukala Mafarisayo magasikira gago, akiuka kula Judea na akiuya Galilaya. ");
INSERT INTO nyf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na kahi za charoche akikala k'ana budhi akire na Samaria. ");
INSERT INTO nyf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ndeye vivi hatha mudzi mumwenga wa Samaria uriwoifwa Sikari. Mudzi uu were u hehi na munda wa Josefu ariwogerwa ni babaye Jakobu. ");
INSERT INTO nyf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na haho were hana kisima cha Jakobu, bai kwa kukala were Jesu adzatsoka kwa charoche, wakelesi k'anda-k'anda ya cho kisima akioya. Na wakathi uu were ni here saa sitha za mutsana. ");
INSERT INTO nyf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Bai Jesu arihokala a ho kisimani, kukidza mwanamuche wa Kisamaria kudzaheka madzi. Arihofika haho Jesu akimwamba, “Nisaidhia na madzi ninwe hedu.” ");
INSERT INTO nyf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ganakala gaga were o anafundzie k'amaho, madzambola-mbola masokoni kwendagula chakurya. ");
INSERT INTO nyf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ye mwanamuche akimwamba, “Uwe u Muyahudi na mino ni Musamaria, kidza mwanamuche, viandzadze bai unanivoya madzi unwe?” (Mana Ayahudi na Asamaria were k'amadima kuhumira viya vimwenga zha kuririra hedu kunererwa.) ");
INSERT INTO nyf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesu akimwamba ye mwanamuche, “Kala unamanya kigerwa cha Mulungu na iye akuvoyaye madzi ni h'ani, ungamuvoya iye naye angakup'a madzi ga uzima.” ");
INSERT INTO nyf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ye mwanamuche akiamba, “Undagahekadze Bwana, na k'una kiya cha kuhekera na kisima ni kire. Undagapatahi go madzi ga uzima? ");
INSERT INTO nyf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Vidze unamala uambe u mubomu kuriko babiyehu Jakobu ariyehup'a kisima kiki ambacho iye, anae, na mifugoye yosi manwa madzi ga kwakwe?” ");
INSERT INTO nyf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesu akiamba, “Kila anwaye madzi gaga andasikira k'ihu kaheri, ");
INSERT INTO nyf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ela iye andiyenwa go madzi nindigomup'a k'andasikira k'ihu hatha kare na kare. Go madzi nindigomup'a mimi gandakala here kidzuho ndanimwe, na kidzuho kiki kindakala kinamup'a madzi ga uzima wa kare na kare.” ");
INSERT INTO nyf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ye mwanamuche akiamba, “Bwana, nip'a gago madzigo, ili nisisikire k'ihu kaheri, hedu hatha kudzaheka madzi kaheri haha.” ");
INSERT INTO nyf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesu akimwamba, “Enda ukamuhale mulumeo hedu udze naye.” ");
INSERT INTO nyf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ye mwanamuche akiamba, “Sina mulume mino.” Jesu akimwambira, “U mujeri kuamba k'una mulume. ");
INSERT INTO nyf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwani uwe udzafisha alume atsano mariokuhala na mukirichana, na hatha haha ninenaho, iye mulume uriye naye si wa hilali.” ");
INSERT INTO nyf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ye mwanamuche akiamba, “Bwana, naona uwe u nabii! ");
INSERT INTO nyf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Babizehu a Kisamaria mamuvoya Mulungu kahi za murima uu, ela nwi Ayahudi mudzasita kuamba Jerusalemu ndo hat'u hav̱iryaho kuvoywa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesu akiamba, “Kuluhira gaga ninenago m'ama, wakathi unadza ambawo k'amundamuvoya Baba Mulungu kahi za murima uu hedu hatha Jerusalemu kaheri. ");
INSERT INTO nyf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ninwi Asamaria munavoya, ela k'amumanya kala munamuvoya h'ani, ela siswi Ayahudi bai hunamumanya ye humuvoyaye, kwa kukala wokolwi unaadzirira at'u kukirira kwa Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ela wakathi unadza na hatha udzire kare ambaho o avoyi a jeri na jeri mandamuvoya Baba Mulungu kahi za Roho na ujeri. Na aa be ndo avoyi mamalwao ni Baba. ");
INSERT INTO nyf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kwani Mulungu ni roho na ao mamuvoyao manav̱irya kumuvoya kahi za Roho na ujeri.” ");
INSERT INTO nyf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ye mwanamuche akiamba, “Namanya iye Masihi andakudza, bai haho akidza andafung'aziza gosini.” ");
INSERT INTO nyf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesu akiamba, “Mimi ninenaye nawe, ndimi iye.” ");
INSERT INTO nyf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bai Jesu arihokala anasumurira na ye mwanamuche, anafundzie makiuya na machangalala kumona anasumurira na mwanamuche. Marihoona vizho, k'ahambolere hatha mumwenga ariyemuza ye mwanamuche kala anamalani hedu hatha kumuza Jesu kwanoni anasumurira naye. ");
INSERT INTO nyf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Bai ye mwanamuche akiricha wo muthangawe na akiuya ko mudzi wa Sikari achendaambira at'u akiamba, ");
INSERT INTO nyf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ndzoni mulole hedu yuno mut'u adziyenambira gosini nirigogahenda. Mut'u yuno akale nde Masihi?” ");
INSERT INTO nyf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bai at'u makimbola ko mudzini na makiandza kudza kwa Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Bai wakathi uu o anafundzi makimurenga-renga Jesu makiamba, “Rabi, rya chakurya.” ");
INSERT INTO nyf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ela Jesu akiamba, “Mimi nina chakurya musichokimanya bule.” ");
INSERT INTO nyf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","O anafundzie marihosikira vizho makiuzana-uzana makiamba, “Vidze hakale hana mut'u adziyemurehera chakurya kare be zho?” ");
INSERT INTO nyf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesu akiamba, “Chakurya changu mimi ni kuhenda zho ahendzazho ye ariyenihuma na kumarigiza kaziye. ");
INSERT INTO nyf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ninwi munaamba, ‘Vinahala miezi mine ndo huvune.’ Ela namwambira muilolet'o yo minda, kwani ni myaruhe tse na i thayari kuvunwa. ");
INSERT INTO nyf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ye mut'u avunaye nikuhokezwa mushahara kalaho anagakusanya mavuno kahi za uzima wa kare na kare, kwamba iye mut'u alayaye na iye avunaye mafwahirwe hamwenga. ");
INSERT INTO nyf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bai vizho ni jeri kukala ‘mut'u mumwenga ni kulaya na mungine akavuna.’ ");
INSERT INTO nyf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Namuhuma mukavune mavuno kwenye munda ambawo k'amuuhendere kazi, angine mahenda kazi kuko nanwi munafaidhi kazi yao.” ");
INSERT INTO nyf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bai Asamaria anji kahi za wo mudzi wa Sikari mamukuluhira Jesu, kwa kukala ye mwanamuche were adzaashuhudia na kuamba, “Adzanambira kila kit'u nirichokihenda!” ");
INSERT INTO nyf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kwa vizho ao Asamaria marihokudza kwakwe mamuvoya akale haho hamwenga nao, naye akihenda vizho, akikala kuko siku mbiri. ");
INSERT INTO nyf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bai Jesu akinena na o at'u, na anji angine makimukuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Makimwamba ye mwanamuche, “Hunakuluhira vikara, si kwa viryahu urizhofwambira thu, ela kwa kukala siswi enye hudzamusikira na hunamanya kamare kukala ni jeri ni mwokoli wa urumwengu.” ");
INSERT INTO nyf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bada ya kukala haho siku mbiri, Jesu wauka na achenda Galilaya. ");
INSERT INTO nyf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwani Jesu mwenye were waamba, “Nabii k'aishimiwa kahi za ts'i ya kwao.” ");
INSERT INTO nyf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ela arihofika Galilaya at'u makimuhokerat'o, mana were makwenda kwa sikuk'uu ya P'asaka ko Jerusalemu na makiona kila kit'u arichokihenda kahi za sikuk'uu iyo. ");
INSERT INTO nyf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ndo Jesu achenda kaheri K'ana ya Galilaya, arikokala wagaluza madzi gakikala divai. Bai kuko kwere na mubomu ariyekala ana muthanawe Kaperinaumu ariyekala ni mukongo. ");
INSERT INTO nyf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Arihosikira kukala Jesu were adzire kula Judea hatha Galilaya, wakwenda kwakwe na akimuvoya ende Kaperinaumu akamuhoze mwanawe ariyekala k'amanyikana kuthia. ");
INSERT INTO nyf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesu akiamba, “K'ahana hatha mumwenga wenu andiyekuluhira muhaka muone miujiza na maut'u ga kungalaza.” ");
INSERT INTO nyf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Iye mubomu akiamba, “Bwana, hinde kabila mwanangu k'adzamarigizika.” ");
INSERT INTO nyf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesu akimwamba, “Enda, mwanao andakala moyo!” Bai ye mut'u akikuluhira maneno ga Jesu na achenda. ");
INSERT INTO nyf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Arihokala akwendani ko mudzini, ahumikie makimuthungana na uv̱oro uu, “Muthanao ni muzima!” ");
INSERT INTO nyf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Akiuza chamba ni wakathi wani iye muthanawe arihoandza kupata baha. Makiamba, “Ramuricha dzana, murongo wa saa fungahe za mutsana.” ");
INSERT INTO nyf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Badaye ye babaye muthana akikumbukira kukala ni wakathi uryahu Jesu arihomwambira, “Muthanao andakala moyo.” Kwa vizho iye na adamue osi makikuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Uu were ndo muujiza wa hiri ariouhenda Jesu kuko Galilaya bada ya kudza kula Judea. ");
INSERT INTO nyf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Badaye Jesu wambuka Jerusalemu kwa sikuk'uu ya Kiyahudi. ");
INSERT INTO nyf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Vikara kuko Jerusalemu hehi na Muv̱irya wa Ng'ondzi kuna birika ambaro kwa Kieburania rinaifwa Betizath'a. Birika riri were rina ukuta uriwo na miryango mitsano. ");
INSERT INTO nyf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bai kahi za birika riri were hana akongo anji sana mahembelele, masoona, vidende, na akuholoza.  ");
INSERT INTO nyf_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nao were manathariza madzi gatigwe, mana were wakathi kwa wakathi, malaika wa Bwana anatharamuka mo birikani na kugatiga go madzi. Vikara mut'u wa kwandza wa kwangira mo birikani bada ya madzi kutigwa wahozwa ukongowe ariwokala nawo. ");
INSERT INTO nyf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bai haho were hana mut'u mumwenga ariyekala adzafisha miaka mirongo mihahu na minane analumwa thu. ");
INSERT INTO nyf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesu arihomona na kumanya kukala adzakala haho kwa muda mure, wamuza akiamba, “Vidze unamala kuhola?” ");
INSERT INTO nyf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ye munyonge akiamba, “Bwana mut'u mimi, sina mut'u wa kunangiza birikani madzi gatigwaho, mana nikijeza kwangira thu, nakatw'a ni mut'u mungine.” ");
INSERT INTO nyf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesu akimwamba, “Uka, uhale godhororo wanende.” ");
INSERT INTO nyf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Haho henye ye mut'u akihola. Akihala godhoro ra kwakwe akinenda. Vinakala vivi were ni siku ya Sabato. ");
INSERT INTO nyf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bai o Ayahudi makimwamba ye ariyekala adzahozwa, “Rero ni Sabato na kulingana na sheria yehu k'uv̱irya kutsukula godhoro bule.” ");
INSERT INTO nyf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Iye mut'u akiamba, “Ye adziyenihoza adzanambira, ‘Hala godhororo wende.’ ” ");
INSERT INTO nyf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bai makimuza makiamba, “Ni h'ani mut'u yuno adziyekwambira uhale godhororo na wende kwenu?” ");
INSERT INTO nyf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ela ye mut'u ariyehozwa k'amumanyire ye ariyekala adzamuhoza, kwa kukala hat'u haho were hana kundi ra at'u na Jesu were adzahenyeza akenda. ");
INSERT INTO nyf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Badaye Jesu akimona kahi za ro Hekalu akimwamba, “Lola u muzima vikara. Usihende dambi kaheri, p'ore ukagwirwa ni ut'u uwi zaidhi kukira uu.” ");
INSERT INTO nyf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ndo ye mut'u achenda na akiambira o Ayahudi kukala ni Jesu nde ariyemuhoza. ");
INSERT INTO nyf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kwa ut'u uu o Ayahudi makiandza kumutesa Jesu, kwa kukala were adzahenda kihendo kiki siku ya Sabato. ");
INSERT INTO nyf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesu akiadzigidzya, akiamba, “Baba anahenda kazi kila wakathi, na mimi nami nav̱irya nihende kazi.” ");
INSERT INTO nyf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Neno riri raahendya o Ayahudi mazidhi kumala kumwalaga Jesu, kwa kukala were k'avundzire Sabato thu, ela were adzaamba kukala iye Mulungu be ni babaye mwenye, na kwa vivi wadzihendya kukala yu karakara na Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ndo Jesu akiadzigidzya akiamba, “Ninamwambira ujeri, Mwana k'adima kuhenda kit'u chochosi h'akeye. Mut'u iye anahenda go aonago Babaye anagahenda. Go ahendago Baba ndo ahendago Mwana. ");
INSERT INTO nyf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kwani Baba anamuhendza Mwanawe na anamwanyesa kila kit'u ambacho ye mwenye anakihenda. Andamwanyesa ye Mwanawe maut'u mabomu zaidhi ga kuhenda, nanwi mundangalala. ");
INSERT INTO nyf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Here Baba afufulazho nyufu na kuzip'a uzima, Mwana naye dzazho ni kuap'a uzima aryahu amalao kuap'a uzima. ");
INSERT INTO nyf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ye Baba k'amuhukumu mut'u yoyosi, ela wamup'a Mwanawe wadimi kamili wa kuhukumu, ");
INSERT INTO nyf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kwamba osi mamuheshimu Mwana here mamuheshimuzho ye Baba ariyemuhuma. ");
INSERT INTO nyf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ninamwambira ujeri, mut'u yoyosi asikiraye maneno gangu na kumukuluhira ye ariyenihuma, yuna uzima wa kare na kare. K'andahukumiwa, ela adzagonya kare kukira kifwani hatha uzimani. ");
INSERT INTO nyf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ninamwambira ujeri, wakathi unadza na udzire kare, ambaho nyufu zindasikira sauthi ya Mwana wa Mulungu na ao mandioisikira mandaishi. ");
INSERT INTO nyf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kwani here arizho Baba mwenye nde chaho cha uzima, dza vizho zhenye Mwanawe adzamuhendya chaho cha uzima. ");
INSERT INTO nyf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na adzamup'a Mwana wadimi wa kuhukumu, kwa kukala iye ni Mwana wa Mudamu. ");
INSERT INTO nyf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Musangalale kwa gaga, mana wakathi unadza ambawo osi mario mbirani mandasikira sauthiye, ");
INSERT INTO nyf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na mandambola mo mbirani. Na ao mariohenda madzo mandafufuka na kukala moyo na osi mariohenda mai mandafufuka na mandahukumiwa.” ");
INSERT INTO nyf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Mimi h'akiyangu sidima kuhenda kit'u chochosi. Mut'u mimi ninahukumu thu here Mulungu anambirazho, kwa vizho hukumu yangu ni ya ujeri, mana sihenda go nihendzago mimi, ela nahenda garyahu gamalwago ni iye ariyenihuma. ");
INSERT INTO nyf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nikimboza ushahidhi dzulu yangu mwenye go ninenago si ga ujeri. ");
INSERT INTO nyf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ela kuna mungine anambozeraye ushahidhi hat'u hangu na ninamanya uwo ushahidhiwe dzulu yangu ni jeri. ");
INSERT INTO nyf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Mwahirika at'u kwa Johana, na akinena ujeri dzulu zangu. ");
INSERT INTO nyf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Si kwa kukala nidzathumainia ushahidhi niupatao ula kwa mudamu, ela ninanena vivi kwamba mukuluhire. ");
INSERT INTO nyf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Iye were ni taa riakaro na kung'ala, nanwi mukihendza kufurahi kwa muda kahi za mulangazawe. ");
INSERT INTO nyf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ela wo ushahidhi niriwo nawo ni mubomu kuriko wa Johana, nawo ni zizo kazi arizonip'a Baba nizithimize. Bai kazi zizi zenye nizihendazo ndo zirizo zinanambozera ushahidhi kukala Baba wanihuma. ");
INSERT INTO nyf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na ye Baba mwenye ariyenihuma anamboza ushahidhi dzulu zangu. Ela ninwi k'amudzamusikira sauthiye hedu hatha kumona umbore, ");
INSERT INTO nyf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","na kidza nenore k'amunaro ndani mwenu, kwani k'amumukuluhira iye ariyemuhuma. ");
INSERT INTO nyf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Munashoma Maoro kwa chadi mukiona kukala kwa gago mundapata uzima wa kare na kare. Gaga ndo Maoro ganilazhirago ushahidhi, ");
INSERT INTO nyf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ela kidza munakahala kudza kwangu kupata uzima. ");
INSERT INTO nyf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Simala ishima kula kwa at'u. ");
INSERT INTO nyf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ela ninamanya kukala k'amuna mahendzo ga Mulungu mioyoni mwenu. ");
INSERT INTO nyf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mut'u mimi nakudza kahi za dzina ra Baba, ela k'amunihokerere, mut'u mungine akidza kwa dzinare mundamuhokera. ");
INSERT INTO nyf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Munadimadze kukuluhira ikidzakala mwakubali kudzip'a nguma enye kwa enye na k'amuhenda chadi chochosi kupata nguma imbolayo kwa Mulungu h'akeye? ");
INSERT INTO nyf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Hatha vizho musione kukala nindamushithaki kwa Baba, Musa nde andiyemushithaki ninwi. Naye ni yuyahu Musa ambaye mudzamutumainia. ");
INSERT INTO nyf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kala jeri mwamukuluhira Musa ngere mwanikuluhira, mana iye wandhika dzulu zangu. ");
INSERT INTO nyf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ela chamba k'amukuluhira zho arizhondhika Musa, munadimadze kukuluhira go ninenago?” ");
INSERT INTO nyf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bada ya vivi Jesu wakwenda luhande lungine lwa ziya ra Galilaya ambaro pia ni ziya ra Tiberia. ");
INSERT INTO nyf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bai at'u anji makimuthuwa, mana maona yo miujiza ariyoahendera at'u mariokala ni akongo. ");
INSERT INTO nyf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kidza Jesu akikwera kirimani na akikelesi na anafundzie. ");
INSERT INTO nyf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Vikara wakathi uu sikuk'uu ya Kiyahudi ya P'asaka were i hehi. ");
INSERT INTO nyf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bai Jesu arihonula matso waona kundi bomu ra at'u rinamudzirira. Akimuza Filipu, akiamba, “Vidze hundagulahi mikahe ya kuarisa at'u ano?” ");
INSERT INTO nyf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ela Jesu wamuza kumujeza thu, kwani were anamanya kare zho arizhokala andahenda ye mwenye. ");
INSERT INTO nyf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Bai Filipu akiamba, “Hatha dinari magana mairi k'azidima kugula chakurya cha kuthosha cha kila mumwenga apate kaut'u ka kuluma-luma.” ");
INSERT INTO nyf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ndo mwanafundziwe mumwenga Anderea, ariye ni nduguye Simoni P'et'ero akiamba, ");
INSERT INTO nyf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Haha hana muvulana ariye na mikahe mitsano ya shayiri na makumba mairi. Ela zho be hatha ni noni kwa at'u anji namuna ino?” ");
INSERT INTO nyf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesu akiamba, “Ambireni o at'u makelesi hedu.” Hat'u haho were hana nyasi nyinji. Kwa vizho kila mut'u akikeresi. Nao were ni here at'u alifu ts'ano, alume. ");
INSERT INTO nyf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Bai Jesu akihala yo mikahe achamboza muv̱era kwa Mulungu na akiagazhira o at'u mariokala makelesi haho. Akihenda vizho pia kwa go makumba, na osi makirya hatha makivilola. ");
INSERT INTO nyf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Marihokala osi makusi, Jesu waambira anafundzie, “Tsolani-tsolani zho visiku vidzizhosala ili husitsuhe chochosi.” ");
INSERT INTO nyf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kwa vizho makivitsola-tsola zhosi, na makidzaza k'ahu kumi na mbiri kula kahi za yo mikahe mitsano ya shayiri iriyoriwa ni o at'u. ");
INSERT INTO nyf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bai at'u marihoona wo muujiza ariwohenda Jesu makiandza kuamba, “Jeri wenye yuyu nde nabii humutharizaye haha urumwenguni.” ");
INSERT INTO nyf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kidza Jesu akimanya kukala were manamala kudzamugwira mamuhendye muthawali kwa nguvu. Kwa vizho akiachimbira achenda murimani na akikala h'akeye. ");
INSERT INTO nyf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bai kurihokala dziloni o anafundzie makwenda ko ziyani, ");
INSERT INTO nyf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","machangira dauni mavuke mende Kaperinaumu. Bai usiku uchangira na Jesu akikala k'adzaafikira bule. ");
INSERT INTO nyf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na wakathi uu luv̱utho lukali lwere lunapiga na kuvuruga go madzi. ");
INSERT INTO nyf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bai o anafundzie marihokala madzakwenda mwendo wa maili t'ahu hedu ne vivi mumo ziyani, mamona Jesu ananenda dzulu za madzi na anadza hehi na ro dau, bai makigoshezhwa. ");
INSERT INTO nyf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ela Jesu akiamba, “Sogoheni bule, ndimi.” ");
INSERT INTO nyf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bai makikala ma thayari apande mo dauni, ela vichache zhenye riro dau rikifika yo ts'i mariyokala manenda. ");
INSERT INTO nyf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Siku ya hiriye muthunganano uriwokala nyangamo ya ziya wakumbukira kukala ni dau mwenga h'akeye ririrokala haho. Kwa vizho makimanya kukala Jesu k'endere na anafundzie mo dauni ela makala madzamuricha. ");
INSERT INTO nyf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kidza madau mangine kula Tiberia gakidzaima hehi na ho hat'u ambaho at'u were marya mikahe bada ya Bwana Jesu kulazha muv̱era kwa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","O at'u marihoona kukala Jesu hedu anafundzie were k'amaho, machangira madauni na machenda Kaperinaumu kumumala Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na o at'u marihomona Jesu nyangamo ya ziya makimuza makiamba, “Rabi, hatha wakudza rini be kuno?” ");
INSERT INTO nyf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesu akiamba, “Ninamwambira ujeri, ninwi k'amunimala kwa kukala mwaona mana ya miujiza niriyoihenda, ela kwa kukala mwarya mikahe hatha muchakuha. ");
INSERT INTO nyf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bai musihende kazi kwa ut'u wa chakurya kidimacho kunongeka, ela kwa ut'u wa chakurya kitoacho na kilazhacho uzima wa kare na kare, ambacho ye Mwana wa Mudamu nde andemup'a. Iye nde ariye Mulungu Baba adzamup'a wadimi wa kuhenda vizho.” ");
INSERT INTO nyf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kudzasikira vizho makimuza makiamba, “Huhendedze ili hukale hunahenda kazi ya Mulungu?” ");
INSERT INTO nyf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesu akiamba, “Ii ndo kazi ambayo Mulungu anahendza muihende, mukuluhireni iye ariyemuhuma.” ");
INSERT INTO nyf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Makiamba, “Vidze undahenda muujiza wani ili fuwone na fukukuluhire? ");
INSERT INTO nyf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kwani babizehu marya Mana kuko nyika, here Maoro gaambazho, ‘Waap'a mukahe kula mulunguni makirya.’ ” ");
INSERT INTO nyf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesu akiamba, “Ninamwambira ujeri, Musa k'amup'ire chakurya kula mulunguni, ela Baba nde amup'aye chakurya jeri kula mulunguni. ");
INSERT INTO nyf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwani chakurya kilazhwacho ni Mulungu ni ye adzaye kula mulunguni na kulazha uzima kwa urumwengu.” ");
INSERT INTO nyf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Makiamba, “Bwana hup'e chakurya kiki kwenda-kwenda.” ");
INSERT INTO nyf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesu akiambira, “Mimi ndimi chakurya cha uzima. Mut'u andiyekudza kwangu k'andasikira ndzala kamare, na iye andiyenikuluhira mimi k'andasikira k'ihu ng'o. ");
INSERT INTO nyf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Vikara here nidzizhomwambira mudzanona, ela k'amukuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kila mut'u nindiyep'ewa ni Baba, andakudza ko kwangu, na iye andiyekudza kwangu sindamuinga bule. ");
INSERT INTO nyf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwani sidzire kula mulunguni kudzahenda mahendzo gangu mwenye, ela nakudza ili nihende mahendzo ga iye ariyenihuma. ");
INSERT INTO nyf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Bai iye ariyenihuma anamala nihende vivi: Kwamba niafufule o at'u osi arionip'a. K'endzi nangamize hatha mumwenga. ");
INSERT INTO nyf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwani zho ahendzazho ye Baba ni vivi: Kwamba osi mamonao Mwana na kumukuluhira madime kupata uzima wa kare na kare; nami nindaafufula siku ya mwisho.” ");
INSERT INTO nyf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ayahudi makiandza kumunung'unika kwa kukala were adzaamba, “Mimi ndimi chakurya kirichothima kula mulunguni.” ");
INSERT INTO nyf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Makiamba, “Samba yuno ni Jesu, mwana wa Josefu? Babaye na mameye samba hunaamanya! Vikara viandzadze anaamba kukala wathima kula mulunguni?” ");
INSERT INTO nyf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesu akiambira, “Richani kunung'unikirana. ");
INSERT INTO nyf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","K'akuna adimaye kudza kwangu asihovufwa ni ye Baba ariyenihuma, nami nindamufufula siku ya mwisho. ");
INSERT INTO nyf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Manabii mandhika kukala, ‘At'u osi mandafundishwa ni Mulungu.’ Kila mut'u amusikiraye ye Baba na kudzifundisha kula kwakwe, ni kudza kwangu. ");
INSERT INTO nyf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Vivi k'avinyesa kukala kuna mut'u yoyosi ariyemona Baba, hasihokala iye alaye kwa Mulungu, bai iye ndiye ariyemona Baba. ");
INSERT INTO nyf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ninamwambira ujeri, mut'u akuluhiraye, yuna uzima wa kare na kare. ");
INSERT INTO nyf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mimi ndimi chakurya cha uzima. ");
INSERT INTO nyf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Babizenu marya Mana kuko nyika, kidza makifwa vizho. ");
INSERT INTO nyf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ela haha hana chakurya kitharamushwacho kula mulunguni ambacho mut'u anadima kurya na kutsafwa. ");
INSERT INTO nyf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mimi ndimi chakurya chenye uzima kirichotharamushwa haha ts'i kula mulunguni. Kila mut'u anderya chakurya kiki andakala moyo kare na kare. Mukahe uu ni mwiri wangu, ambawo ninaulazha kwamba urumwengu upate uzima.” ");
INSERT INTO nyf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bai o Ayahudi marihosikira vivi, makinenezana enye kwa enye na kuamba, “Vinadimikikadze yuno mut'u kuhup'a mwiriwe huurye?” ");
INSERT INTO nyf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesu akiamba, “Ninamwambira ujeri. Kala k'amundarya mwiri wa Mwana wa Mudamu na kunwa milatsoye k'amundakala na uzima ndani mwenu. ");
INSERT INTO nyf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kwani ye aryaye mwiri wangu na kunwa milatso yangu yuna uzima wa kare na kare, na nindamufufula siku ya mwisho. ");
INSERT INTO nyf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwani wo mwiri wangu ndo chakurya jeri-jeri na milatso yangu ndo kinywaji jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mut'u aryaye mwiri wangu na kunwa milatso yangu andakala kit'u kimwenga nami. ");
INSERT INTO nyf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Here Baba ariye moyo arizhonihuma, nami ni moyo kwa ut'u wa Baba, kwa vizho ye aniryaye andakala moyo kwa ut'u wa mimi. ");
INSERT INTO nyf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bai kiki ndo chakurya kirichotharamushwa kula mulunguni. Nacho si here kiryahu marichorya babizenu na makifwa. Ela iye andiyerya chakurya kiki nindichomup'a, andakala moyo kare na kare.” ");
INSERT INTO nyf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesu wanena vivi arihokala anafundisha kahi za sinagogi kuko Kaperinaumu. ");
INSERT INTO nyf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Anji kahi za anafundzie marihosikira vivi maamba, “Riri ni fundisho komu, k'akuna adimaye kurikubali bule.” ");
INSERT INTO nyf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bai Jesu akimanya kukala o anafundzie mananung'unika dzulu ya vivi, kwa vizho akiambira, “Vidze vino vinamukwaza? ");
INSERT INTO nyf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Vidze mundasikiradze mundihomona Mwana wa Mudamu anenda dzulu arikombola? ");
INSERT INTO nyf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kilazhacho uzima ni Roho wa Mulungu, nguvu za mudamu k'azina faidha bule. Gago maneno nidzigomwambira ni Roho na uzima. ");
INSERT INTO nyf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kidza angine enu k'amukuluhira!” Jesu wamanya hangu chaho aryahu mario were k'amandamukuluhira na iye andiyemusaliti. ");
INSERT INTO nyf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Na achangeza kuamba, “Ndosa namwambira kukala k'akuna adimaye kudza kwangu, asihodimirwa kuhenda vizho ni Baba.” ");
INSERT INTO nyf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kwa ut'u uu, anji kahi za anafundzie mamuricha na k'amadimire kwenda naye kila hat'u kaheri. ");
INSERT INTO nyf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ndo Jesu akiauza o anafundzie kumi na airi, akiamba, “Vidze munamala muniriche nanwi?” ");
INSERT INTO nyf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni P'et'ero akimudzigidzya akiamba, “Bwana fukuriche fwende kwa h'ani? Uwe una maneno ga uzima wa kare na kare, ");
INSERT INTO nyf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","na hunakuluhira na hunamanya kukala uwe ndiwe Mweri wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kidza Jesu akidzigidzya akiamba, “Vidze simutsagulire ninwi kumi na airi? Kidza mumwenga wenu ni Shethani!” ");
INSERT INTO nyf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Wamanisha Juda mwana wa Simoni Isikariote ambaye vingahokala ni mumwenga kahi za o anafundzie kumi na airi, iye were andakudzamusaliti ko mbereni. ");
INSERT INTO nyf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bada ya vivi Jesu wakwenda kuno na kuno kuko Galilaya, k'ahendzere kwenda Judea, kwa kukala o Ayahudi were manamala kumwalaga. ");
INSERT INTO nyf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Bai sikuk'uu ya Ayahudi ya Vibanda were idzafika hehi, ");
INSERT INTO nyf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ndo nduguze Jesu makimwambira, “Mut'u uwe ungauka haha ukenda Judea ili o anafundzio madime kuona zo kazi uhendazo. ");
INSERT INTO nyf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kwani k'akuna adimaye kufitsa kaziye kala anahendza kumanywa t'ot'ot'o. Nawe kwa kukala unahenda maut'u gaga, richa urumwengu wosi umanye dzuluzo.” ");
INSERT INTO nyf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Zhakala vivi kwa kukala hatha nduguze enye kidza k'amamukuluhirire. ");
INSERT INTO nyf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kwa vizho Jesu akiambira, “Wakathi wangu wa karakara, k'audzangwe kufika, ela kwenu ninwi wakathi wowosi ni karakara. ");
INSERT INTO nyf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Urumwengu k'audima kumumena ninwi, ela unanimena mimi, kwa kukala ninamboza ushahidhi kukala vizho uhendazho wo urumwengu ni vii. ");
INSERT INTO nyf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Vikara ninwi h'e mbukani kwenda ko shereheni. Mimi sindakwenda kare vivi bule, kwa kukala wakathi wangu k'audzafika.” ");
INSERT INTO nyf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bada ya kunena vivi Jesu wasala kuko Galilaya. ");
INSERT INTO nyf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ela bada ya o nduguze kumbuka ko shereheni, iye naye wakwenda, ela kisiri-siri. ");
INSERT INTO nyf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Vikara haho shereheni o Ayahudi mamumala na kumuuziza-uziza na kuamba, “A hiko yuno mut'u?” ");
INSERT INTO nyf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kidza kahi za ro kundi mwere muna masumuriro ga kinjama-njama dzuluze. Angine were manaamba, “Ni mut'u mudzo.” Ela angine makidzigidzya makiamba, “Anakenga at'u thu.” ");
INSERT INTO nyf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ela k'ahana ariyenena lwazu-lwazu dzuluze kwa kuagoha o Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Vikara yo sherehe irihokala idzafika kahikahi, Jesu wakwenda mo Hekaluni na akiandza kufundisha. ");
INSERT INTO nyf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","K'uzhona zho Ayahudi machangalala na makiamba, “Vikaladze yuno mut'u anamanya maut'u namuna ino na hatha k'ashomerere zhamwanya?” ");
INSERT INTO nyf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesu akiamba, “Go nifundishago, si mafundisho gangu, ela ni ga Mulungu ariyenihuma. ");
INSERT INTO nyf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mut'u akitsagula kuhenda mahendzo ga Mulungu, andamanya kukala mafundisho gangu gala kwa Mulungu hedu ninadzinenera mwenye thu. ");
INSERT INTO nyf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ye adzineneraye mwenye ni kuhenda vizho ili adzipatire nguma, ela ye ahendaye kazi kwa ishima ya iye ariyemuhuma ni mut'u wa ujeri, k'ana ulongo bule ndanimwe. ");
INSERT INTO nyf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Vidze Musa k'amup'ire sheria? Kidza k'ahana hatha mumwenga wenu aithuwaye. Mbona munamala kunalaga kaheri?” ");
INSERT INTO nyf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","O at'u makimwamba, “Una p'ep'o! Ni h'ani amalaye kukwalaga bewe?” ");
INSERT INTO nyf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesu akiaamba, “Nahenda muujiza mumwenga thu nanwi nyosi muchangalala. ");
INSERT INTO nyf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa wamup'a amulo mungize lwembeni ahoho, nanwi munavihenda siku ya Sabato ingahokala sheria ii k'aiandzire na Musa, ela yaandza na o babizenu. ");
INSERT INTO nyf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Na siku ya kwangizwa lwembeni ikigwa siku ya Sabato ni suthi mumwangize lwembeni vizho, ili Sheria ya Musa isibandwe. Mbona munanitsukirirwa kwa kukala namuhoza mut'u siku ya Sabato? ");
INSERT INTO nyf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Richani kuhukumu kwa kumulola mut'u kwa uso, ela hukumuni kwa ngira ya hachi.” ");
INSERT INTO nyf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kusikira vizho at'u angine a Jerusalemu makiamba, “Vidze yuno se mut'u aindzwaye alagwe? ");
INSERT INTO nyf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lola thiyu ananena wazi-wazi na k'akuna anenaye vii dzuluze. Vidze vinadimikika kukala vilongozi manamanya kukala yuno ni ye Masihi? ");
INSERT INTO nyf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ela hunamanya ko alako yuyu. Ye Masihi andihokudza k'akuna andiyemanya alako.” ");
INSERT INTO nyf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Bai Jesu akifundisha kahi za ro Hekalu, akiluta mumirowe akiamba, “Ee munanimanya, na munamanya ko nirikombola. Mimi si haha kitswa changu, ela ye ariyenihuma ni jeri. Ninwi k'amumumanya, ");
INSERT INTO nyf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ela mimi ninamumanya kwa kukala nila kwakwe na iye ndiye ariyenihuma.” ");
INSERT INTO nyf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kusikira vizho, makijeza kumugwira, ela k'akuna mut'u ariyemugut'a, kwa kukala wakathiwe were k'audzafika. ");
INSERT INTO nyf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ela anji ao kahi za ro kundi mamukuluhira na kuamba, “Vidze ye Masihi akidza andahenda miujiza kushinda ii ahendayo mut'u yuyu?” ");
INSERT INTO nyf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bai Mafarisayo makisikira kundi rinanena kinjama-njama maut'u gago dzuluze. Kwa vizho alombi abomu na Mafarisayo makiahuma arindzi a ro Hekalu makamugwire. ");
INSERT INTO nyf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesu akiamba, “Nindakala nanwi kwa muda muchache na gonya nindakwenda kwa iye ariyenihuma. ");
INSERT INTO nyf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mundanimala na k'amundanona, kwa kukala ko nindikokala k'amudima kudza.” ");
INSERT INTO nyf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kusikira vizho o Ayahudi makiambirana enye kwa enye na kuamba, “Yuno mut'u anapanga kwendahi ambako k'ahudima kumona? Vidze andakwenda kahi za midzi ya at'u mario si Ayahudi ambako Ayahudi andziyehu manakala? Vikale andakwendaafundisha o at'u mario si Ayahudi kuko? ");
INSERT INTO nyf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Anaamba, ‘Mundanimala, ela k'amundanona,’ na ‘k'amudima kudza ko nindikokala.’ Vidze manaye ni noni?” ");
INSERT INTO nyf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Siku ya mwisho ya sherehe were ndo siku bomu kukira zosi. Siku iyo Jesu akiima na akiluta mumiro akiamba, “Mwenye k'ihu naadze kwangu anwe. ");
INSERT INTO nyf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Here Maoro gaambazho, ‘Ye anikuluhiraye vidzuho zha madzi ga uzima vindathuza kula moyoni mwakwe.’ ” ");
INSERT INTO nyf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesu waamba ut'u uu dzulu za ye Roho ariye aryahu mandiomukuluhira were mandamup'ewa. Kwani Kufikira siku ii were k'adzadza, kwa kukala Jesu were k'adzangwe kugerwa ngumaye. ");
INSERT INTO nyf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","At'u marihosikira zho arizhoamba. Makiamba, “Mut'u yuyu nde yuyahu nabii.” ");
INSERT INTO nyf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ela angine makiamba, “Yuyu nde iye Masihi.” Angine o makiamba, “Masihi k'adima kula Galilaya. ");
INSERT INTO nyf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Go Maoro ganaamba kukala ye Masihi andambola lukolo lwa Daudi na andazhalwa Beth'elehemu, mudzi wa Daudi.” ");
INSERT INTO nyf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kwa vizho at'u makigazhikana kwa ut'u wa Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Angine mamala kumugwira, ela k'ahana hatha mumwenga ariyemugut'a. ");
INSERT INTO nyf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bai o arindzi makiuya kwa o alombi abomu na Mafarisayo marioauza makiamba, “Mbona k'amudzire naye kaheri?” ");
INSERT INTO nyf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","O arindzi makiamba, “K'akuna mut'u anenayet'o here yuyu.” ");
INSERT INTO nyf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","O Mafarisayo makiuza makiamba, “Vidze mwakengwa nanwi? ");
INSERT INTO nyf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mudzangwe kuona kilongozi yoyosi hedu mumwenga kahi za Mafarisayo kumukuluhira? ");
INSERT INTO nyf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kundi riri k'arimanya Sheria ya Musa, kwa vizho ri ts'ini ya lana ya Mulungu!” ");
INSERT INTO nyf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemu ariyekala wakwendamona Jesu na usiku ho nyuma-nyuma, were ni mumwenga wa o vilongozi, naye akiambira vivi, ");
INSERT INTO nyf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kuthuwirizana na Sheria yehu, k'ahudima kumuhukumu mut'u kabila kumusikira na kumanya adzahendadze.” ");
INSERT INTO nyf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Makimwamba, “Mwenye ula Galilaya? Shoma Maoro na undamanya kukala k'akuna nabii ambolaye Galilaya.”  ");
INSERT INTO nyf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Gonya kila mumwenga achenda kwakwe mudzini. ");
INSERT INTO nyf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ela Jesu ye achenda kahi za Murima wa Mizeituni. ");
INSERT INTO nyf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na kurihocha na madzach'a maitsi sana akiuya kaheri ndani za ro Hekalu ndo at'u osini makimukundzumanyikira hamwenga, bai akikelesi na akiandza kuafundisha. ");
INSERT INTO nyf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","K'uzhona zho o alimu a Sheria na Mafarisayo makireha mwanamuche ariyekala adzagwirwa anazinga na makimuimisha mbere zao osi. ");
INSERT INTO nyf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Makiamba, “Mwalimu, mwanamuche yuyu adzagwirwa akuzingani. ");
INSERT INTO nyf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Vikara kahi za Sheria yehu, Musa wahulagiza kukala hualage anaache mario dza yuyu kwa kuapiga mawe. Vikara we unaambadze?” ");
INSERT INTO nyf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nao were mananena vivi kumuhega ili mapate ut'u wa kumushithakira. Ela Jesu akizama akiandza kuora-ora ho ts'i na chala. ");
INSERT INTO nyf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Marihokaza kumuza-muza maswali, akidziungaraza na akiamba, “Ye asiye na dambi kahi za ninwi na akale wa kwandza kumupiga iwe.” ");
INSERT INTO nyf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kidza akizama kaheri na akiora-ora ho ts'i na chala. ");
INSERT INTO nyf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Marihosikira vivi, makiandza kuuka mumwenga-mumwenga, kuandzira na o akulu. Jesu akirichwa h'akeye na ye mwanamuche haho. ");
INSERT INTO nyf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Akiima na akimuza ye mwanamuche akiamba, “M'ama, ma hiko arya at'u? Vidze hana adziyesala kukuhukumu?” ");
INSERT INTO nyf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akidzigidzya akiamba, “K'ahana Bwana.” Jesu akiamba, “Hatha mimi sikuhukumu. Enda ela usihende dambi kaheri.” ");
INSERT INTO nyf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Badaye Jesu akinena na o at'u kaheri akiamba, “Mimi ndimi mulangaza wa urumwengu. Anithuwaye k'andanenda kizani kamare, andakala na mulangaza wa uzima.” ");
INSERT INTO nyf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kusikira vizho o Mafarisayo makimwambira, “Uwe unadzishuhudia we mwenye, bai wo ushahidhi wa kwako si wa ujeri.” ");
INSERT INTO nyf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesu akiamba, “Hatha chamba ninadzambozeza mwenye ushahidhi, be ninenazho ni jeri kwa kukala ninamanya nilako na nendako, ela ninwi k'amukumanya ko nilako na ko nendako. ");
INSERT INTO nyf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Hukumu yenu ni ya kibinadamu. Mino si hukumu mut'u. ");
INSERT INTO nyf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ela hatha kala were ni nihukumu, hukumu yangu ikakala ya ujeri kwa kukala si h'akiyangu kahi za vivi. Iye Baba ariyenihuma yu hamwenga nami. ");
INSERT INTO nyf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Zhaorwa kahi za Sheria yenu kukala ushahidhi wa at'u airi ukikubaliana, bai zho maambazho ni kukala ni vikubaliwe. ");
INSERT INTO nyf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ninadzambozeza ushahidhi na Baba ariyenihuma naye ananambozeza ushahidhi.” ");
INSERT INTO nyf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Makimuza makiamba, “Babayo yu hiko?” Jesu akiamba, “K'amunimanya mimi hedu Baba. Kalaho munanimanya, mukamumanya Baba naye.” ");
INSERT INTO nyf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu wanena gaga arihokala anafundisha kahi za ro Hekalu, kahi za haryahu hat'u hagwagwaho sadaka na k'akuna ariyemugwira, kwa kukala wakathiwe were k'audzafika bule. ");
INSERT INTO nyf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesu akiambira kaheri “Ninenda, na mundanimala, ela mundafwa kahi za dambi zenu. Kuko nendako k'amudima kudza.” ");
INSERT INTO nyf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","O Ayahudi makiamba, “Anaamba kukala k'ahudima kwenda ko endako, enye vino vinaonyesa kukala andadzalaga hedu?” ");
INSERT INTO nyf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesu akienderera kunena, akiamba, “Ninwi mula haha ts'i, ela mimi nila dzulu. Ninwi mu a urumwengu uu, ela mimi si wa urumwengu uu. ");
INSERT INTO nyf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ndosa nidzamwambira kukala mundafwa kahi za dambi zenu. Na mundafwa kahi za dambi zenu kala k'amundakuluhira kukala, ‘Mimi ndimi iye.’ ” ");
INSERT INTO nyf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Makimuza makiamba, “U h'ani we?” Jesu akiamba, “Ni vizho nidzizhomwambira hangu chaho. ");
INSERT INTO nyf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nina manji ga kunena ga kumushithaki ninwi. Ela iye ariyenihuma ni mujeri na ninawambira urumwengu zho nirizhosikira kula kwakwe.” ");
INSERT INTO nyf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nao k'amamanyire kukala were anaambira dzulu za Baba. ");
INSERT INTO nyf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Bai Jesu akiambira, “Mundihomwanula Mwana wa Mudamu mundamanya kukala, mimi ndimi iye kidza mundamanya kukala sihenda kit'u h'akiyangu, ela ninanena gago adzigonifundisha Baba. ");
INSERT INTO nyf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na iye ariyenihuma a hamwenga nami, k'adzaniricha h'akiyangu, kwa kukala ninahenda gamufwahizago kila wakathi.” ");
INSERT INTO nyf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Anji mariomusikira Jesu akinena maut'u gaga mamukuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Bai Jesu akiambira o Ayahudi mariomukuluhira, “Mukienderera kugwira mafundisho gangu be mu anafundzi angu jeri-jeri, ");
INSERT INTO nyf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mundamanya ujeri na wo ujeri undamwika huru.” ");
INSERT INTO nyf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","O Ayahudi makiamba, “Siswi fwazhalwa ni Burahemu na k'ahudzakala atumwa a mut'u, vikara unamanisha noni kuamba, ‘Mundakala huru?’ ” ");
INSERT INTO nyf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesu akiamba, “Ninamwambira ujeri: Kila mut'u ahendaye dambi ni mutumwa wa dambi. ");
INSERT INTO nyf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na mutumwa k'akala nyumbani kila wakathi, ela mwana akala nyumbani kila wakathi. ");
INSERT INTO nyf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Bai Mwana akikwika huru undakala huru jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ninamanya kukala mu ana a Burahemu, ela kidza munamala kunalaga, kwa kukala k'amukubali mafundisho gangu. ");
INSERT INTO nyf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mimi ninanena garyahu ambago Baba wanonyesa, ela ninwi munahenda go mudzigombirwa ni babiyenu.” ");
INSERT INTO nyf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Makimudzigidzya makiamba, “Babiyehu ni Burahemu.” Jesu akiamba, “Kalaho mu ana a Burahemu, mukahenda kazi arizozihenda Burahemu. ");
INSERT INTO nyf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nidzizhohenda mimi ni kumwambira ujeri niriwousikira kula kwa Mulungu, kidza munamala kunalaga. Burahemu k'ahendere kit'u dza kiki. ");
INSERT INTO nyf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ela ninwi munahenda vizho ahendazho babiyenu.” Makiamba, “Mulungu h'akeye nde Babiyehu naswi hu anae.” ");
INSERT INTO nyf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesu akiambira, “Kalaho Mulungu nde babiyenu jeri munganihendza, kwa kukala nala kwakwe na vikara ni haha. ");
INSERT INTO nyf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kwanoni k'amuelewa zho nimwambirazho? Ni kwa kukala k'amudima kusikira uv̱oro wangu. ");
INSERT INTO nyf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","At'u ninwi mu a babiyenu Ibilisi na muhendzazho ni kuhenda mahendzoge. Iye were ni mwalagi hangu chaho na k'endzi kit'u chochosi kuhusu ujeri, kwa kukala k'amuna ujeri ndanimwe. Akikenga ananena here arizho, kwani ni mulongo na nde babe ulongo. ");
INSERT INTO nyf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ela kwa kukala ninanena ujeri k'amunikuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni h'ani kahi zenu adimaye kunamba nina dambi? H'aya ninanena ujeri, mbona k'amunikuluhira? ");
INSERT INTO nyf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iye ariye ni wa Mulungu ni kusikira manenoge. Ela ninwi k'amua Mulungu ndosa k'amundasikira.” ");
INSERT INTO nyf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bai o Ayahudi makimudzigidzya Jesu makiamba, “Vidze were k'ahuajeri kuamba u Musamaria na una p'ep'o?” ");
INSERT INTO nyf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesu akidzigidzya akiamba, “Sina p'ep'o. Ninamuheshimu Baba, ela ninwi k'amuniishimu bule. ");
INSERT INTO nyf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Sidzimalira ishima, ela kuna mumwenga aimalaye na iye bai ndiye jaji. ");
INSERT INTO nyf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ninamwambira ujeri iye ahendaye here nilagizazho k'andafwa bule.” ");
INSERT INTO nyf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kusikira vizho, o Ayahudi makimwambira, “Vikara hunamanya kukala jeri wenye una p'ep'o! Burahemu wafwa na o manabii nao dzazho, kidza unaamba kukala yoyosi andiyehenda go uhendzago k'andafwa bule. ");
INSERT INTO nyf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Vidze we u mubomu kuriko babiyehu Burahemu na o manabii? Burahemu wafwa, na o manabii nao makifwa. Unadziona u h'ani we?” ");
INSERT INTO nyf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesu akidzigidzya akiamba, “Nikidzip'a nguma mwenye, nguma yangu k'aina mana yoyosi. Baba ariye nanwi munaamba ni Mulungu wenu, ananipa nguma. ");
INSERT INTO nyf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Vingahokala ninwi k'amumumanya mimi ninamumanya. Nikiamba simumanya nindakala mulongo here ninwi, ela ninamumanya na kugwira nenore. ");
INSERT INTO nyf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Babiyenu Burahemu wafwahirwa kwamba adime kuyona siku yangu, naye akiyona na akifwahirwa.” ");
INSERT INTO nyf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","O Ayahudi makimwambira, “K'udzafisha miaka mirongo mitsano na unaamba wamona Burahemu?” ");
INSERT INTO nyf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesu akidzigidzya akiamba, “Ninamwambira ujeri, kabila ya Burahemu kuzhalwa mino were ni kuko kare!” ");
INSERT INTO nyf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ndo makitsola mawe mamukot'e, ela Jesu akizama na badaye achambola mo Hekaluni achenda ndze. ");
INSERT INTO nyf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Bai Jesu arihokala yunatsembera, waona mut'u ariyekala k'aona hangu kuzhalwakwe. ");
INSERT INTO nyf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","K'uzhona zho anafundzie makimuza, makiamba, “Rabi ni dambi ya h'ani iriyomuhendya hatha azhalwe k'aona? Ni yakwe mwenye hedu ni ya azhazie?” ");
INSERT INTO nyf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesu akidzigidzya akiamba, “Kutsaona kwa kwakwe k'akuhusiana na dambize hedu za azhazie. Iye avizho ili nguvu za Mulungu zidime kuoneka zikihenda kazi kwakwe. ");
INSERT INTO nyf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bai hunav̱irya kuenderera kuhenda kazi za iye ariyenihuma kukikala kuchere mutsana, kwani usiku unadza ambaho k'akuna adimaye kuhenda kazi. ");
INSERT INTO nyf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nirizho ni haha urumwenguni, mimi ni mulangaza wa urumwengu.” ");
INSERT INTO nyf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bada ya kunena vivi Jesu watsuha mahe ts'i na akivuga-vuga ulongo na mahege na akimuhaka ye mut'u mo matsoni, ");
INSERT INTO nyf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","na akimwamba, “Enda ukaoge usowo kahi za birika ra Siloamu.” (Mana ya Siloamu ni kuhumwa.) Bai ye mut'u achendaoga usowe na akiuya anaona. ");
INSERT INTO nyf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bai majirani a kwakwe na osini mariokala makimona anavoya-voya kabila ya vivi, mauza makiamba, “Vidze yuno se mut'u ariyekala akikelesi na kuvoya-voya?” ");
INSERT INTO nyf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Angine maamba, “Ni iye” Ela angine makiamba, “Seye bule adzahenda kuhalana naye.” Bai ye mut'u mwenye akiamba, “Ndimi iye.” ");
INSERT INTO nyf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Makimuza ye mut'u, makiamba, “Matsogo gapatadze kuona?” ");
INSERT INTO nyf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Akiamba, “Ye mut'u aifwaye Jesu wavuga-vuga ulongo, akinihaka mo matsoni na akinambira, ‘Enda Siloamu na ukaoge usowo.’ Bai nichenda na nirihooga thu nikipata kuona.” ");
INSERT INTO nyf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Makimuza makiamba, “Vino a hiko ye mut'u ye?” Ye mut'u akiamba, “Simanya mino!” ");
INSERT INTO nyf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bai makimuhirika ye mut'u ariyezhalwa k'aona kwa Mafarisayo. ");
INSERT INTO nyf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Vikara siku iryahu ambayo Jesu wavuga-vuga ulongo na kumuhendya matsoge gaone ye mut'u, yere ni siku ya Sabato. ");
INSERT INTO nyf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mafarisayo makimuza kaheri ye mut'u here arizhopata kuona. Akiambira, “Wanihaka ulongo matsoni, nichendaoga uso wangu na vikara ninaona.” ");
INSERT INTO nyf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mafarisayo angine makiamba, “Ye mut'u ariyehenda vizho k'adima kula kwa Mulungu bule, kwa kukala k'agwira malagizo ga yo Sabato.” Hatha vizho angine maamba, “Vidimikikadze mut'u ariye na dambi kuhenda kazi bomu dza zizi?” Na k'amakubalianire. ");
INSERT INTO nyf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bai Mafarisayo makimuza ye mut'u kaheri, “Unaamba kukala wakuhendya matsogo gaone. H'aya unaambadze dzulu ya ye?” Akiamba, “Ni nabii iye.” ");
INSERT INTO nyf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","O Ayahudi k'amakuluhirire kukala were k'aona na wapata kuona muhaka marihohumiza azhazie. ");
INSERT INTO nyf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Marihokudza makiauza makiamba, “Vidze yuno ni mwana wenu? Munaamba kukala wazhalwa k'aona, h'aya zhakaladze hatha vino anaona?” ");
INSERT INTO nyf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Azhazie makiamba, “Hunamanya kukala yuyu ni mwana wehu, na hunamanya kukala wazhalwa k'aona. ");
INSERT INTO nyf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ela k'ahumanya kala zhaandzadze hatha anaona, na hatha ye ariyemuhendya aone k'ahumumanya. Muzeni iye mwenye, kwani ni mut'u muzima anadima kudzinenera mwenye!” ");
INSERT INTO nyf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Azhazie manena vivi kwa kukala were manaogoha Ayahudi mariokala madzakubaliana kukala mut'u yoyosi andiyeamba kukala Jesu ni Masihi andaingwa mo sinagogini. ");
INSERT INTO nyf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Vizho ndo hatha azhazie makiamba, “Ni mut'u muzima, muzeni mwenye.” ");
INSERT INTO nyf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","K'uzhona zho makimwiha kaheri ye mut'u ariyezhalwa k'aona, na makimwambira, “Mup'e nguma Mulungu, mana siswi hunamanya kukala yuyu mut'u yuyu ni mwenye dambi.” ");
INSERT INTO nyf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Akidzigidzya akiamba, “Kala ni mwenye dambi hedu si mwenye dambi mino simanya. Nimanyacho ni kit'u kimwenga, were siona, ela vino ninaona.” ");
INSERT INTO nyf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Makiuza makiamba, “Wakuhenderadze? Wahendadze hatha matsogo gakiona?” ");
INSERT INTO nyf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Akidzigidzya akiamba, “Nidzamwambira kare na k'amudimire kusikiza. Mbona munamala kusikira kaheri? Hedu hangine munamala mukale anafundzie nanwi?” ");
INSERT INTO nyf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Makimuchemera makiamba, “Uwe ndiwe mwanafundzi wa mut'u iye, ela sino hu anafundzi a Musa. ");
INSERT INTO nyf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Hunamanya kukala Mulungu wanena na Musa, ela kuhusu mut'u yuyu k'ahumanya hatha ko arikombola.” ");
INSERT INTO nyf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ye mut'u akidzigidzya akiamba, “Kiki ni kit'u cha kwangalaza sana! K'amumanya arikombola, na wanihendya nione! ");
INSERT INTO nyf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Hunamanya kukala Mulungu k'asikira enye dambi, ela iye nikusikira at'u mamuishimuo na kuhenda ahendzazho mahende. ");
INSERT INTO nyf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hangu wo urumwengu uumbwe, k'avidzangwe kuonewa kukala mut'u fulani wamuhendya mut'u ariyezhalwa k'aona aone. ");
INSERT INTO nyf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kalaho mut'u iye k'ambolere kwa Mulungu, be k'angadimire kuhenda kit'u.” ");
INSERT INTO nyf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kusikira vizho makimudzigidzya makiamba, “Uwe wazhalwa na ukirerwa dambini na vino unamala kuhufundisha?” Bai makimuinga sinagogini. ");
INSERT INTO nyf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","K'uzhona zho Jesu akisikira kukala mamuthenga. Bai arihomona akimuza, “Vidze unamukuluhira Mwana wa Mudamu?” ");
INSERT INTO nyf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ye mut'u akiamba, “Nambira ni h'ani bwana ili nimukuluhire!” ");
INSERT INTO nyf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesu akimwambira, “Udzamona kare na ni ye anenaye nawe vivi.” ");
INSERT INTO nyf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ye mut'u akiamba, “Ninakuluhira Bwana,” na akimuabudu Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesu akiamba, “Nakudza urumwenguni na hukumu kwamba masioona, maone na maonao makatsaona.” ");
INSERT INTO nyf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafarisayo angine mariokala hehi naye mavisikira vivi na makimwamba, “Vidze naswi k'ahuona?” ");
INSERT INTO nyf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu akidzigidzya akiamba, “Kala k'amuona ngere k'amuna dambi, ela kwa kukala munaamba munaona be dambi yenu i nanwi.” ");
INSERT INTO nyf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Bai Jesu akiamba, “Ninamwambira ujeri wenye kukala ye asiyengira chaani na muryangoni, ela anakwera na dzulu, be iye ni mwivi kidza ni jambazi. ");
INSERT INTO nyf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ela ye angiraye na muryangoni nde murisa wa zo ng'ondzi. ");
INSERT INTO nyf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ye murindzi ni kumuvugulira muryango ye murisa, na zo ng'ondzi nikusikira sauthiye kalaho anaziha na madzina na kuzilongoza ndze. ");
INSERT INTO nyf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Akizamboza ndze, iye nikuzithangulia na zo ng'ondzi ni kumuthuwa, kwa kukala zinaimanya yo sauthiye. ");
INSERT INTO nyf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ng'ondzi zizo k'azidima kumuthuwa mut'u yoyosi mungine, hat'uhe zindamuchimbira ye mut'u, kwa kukala k'aziimanya iyo sauthiye.” ");
INSERT INTO nyf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu waambira fumbo riri, ela k'amamanyire mana ya zho arizhokala anaambira. ");
INSERT INTO nyf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kwa vizho Jesu akinena nao kaheri, akiamba, “Ninamwambira ujeri wenye, mimi ndimi muryango wa zizo ng'ondzi. ");
INSERT INTO nyf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Osini mariokudza mbere zangu were ni aivi na majambazi, ela zo ng'ondzi k'azisirikizire zizo sauthi zao bule. ");
INSERT INTO nyf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mimi ndimi muryango. Kila mut'u andiyengira kukirira kwangu andaokoka, andangira na kidza andambola na apate ndiso. ");
INSERT INTO nyf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwivi akidza hat'u, nikukala adzire aiye, alage na anonge-nonge, ela mimi bai nakudza kwamba mupate uzima, na muupate thele kwa thele. ");
INSERT INTO nyf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mimi ndimi murisa mudzo. Murisa mudzo yu thayari kufwa kwa ut'u wa zo ng'ondzi. ");
INSERT INTO nyf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ela mut'u wa kwandhikwa na ariye si murisa mudzo na kidza ariye zo ng'ondzi si zakwe, aonaho mbawa ni kuziricha zo ng'ondzi, na akachimbira. Bai mbawa ni kuzigwira zo ng'ondzi na nyingine zikatsamukana. ");
INSERT INTO nyf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ye wa kwandhikwa ni kuchimbira kwa kukala ni mwandhikwa na k'azijali bule zo ng'ondzi. ");
INSERT INTO nyf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Mimi ndimi murisa mudzo. Here dza Baba animanyazho mimi, nami namumanya iye, bai vizho ndo nami nimanyazho zo ng'ondzi zangu, nazo kidza zinanimanya mimi. Nami ni thayari kufwa kwa ut'u wa zizo. ");
INSERT INTO nyf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na kuna ng'ondzi zangu nyingine ambazo k'azi kahi za chaa kiki bule. Bai zizo nazo ninav̱irya nizirehe. Ng'ondzi zizo zindasikira sauthi yangu, na zindakala badhi mwenga na renye murisa mumwenga. ");
INSERT INTO nyf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Iye Baba ananihendza kwa kukala ni thayari kulazha uzima wangu ili nidime kuuhokera kaheri. ");
INSERT INTO nyf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","K'akuna adimaye kuuhala kula kwangu uwo uzima wangu, ela ninahenda kuulazha kwa kuhendza mwenye. Nina wadimi wa kuulazha uzima wangu na nina wadimi wa kuuhala mwenye kaheri.” ");
INSERT INTO nyf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Marihosikira vivi o Ayahudi magazhikana kaheri. ");
INSERT INTO nyf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Anji ao were manaamba, “Mut'u yuyu ana p'ep'o na kidza ana vilalu, munamusirikiza wani benwi?” ");
INSERT INTO nyf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ela angine were manaamba, “Mut'u ariye na p'ep'o k'adima kunena dza vivi. Adimadze p'ep'o kuhenda vipofu maone?” ");
INSERT INTO nyf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Wakathi wa sikuk'uu ya Kukumbukira Kuhendywa Eri kwa ro Hekalu kuko Jerusalemu wafika. Nao wakathi uwo were ni wakathi wa mwaka. ");
INSERT INTO nyf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Naye Jesu were anatsembera mo Hekaluni kahi za baraza riifwaro ra Selemani. ");
INSERT INTO nyf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","K'uzhona zho Ayahudi makimuzingira na makiamba, “We undahuhendya huaze-aze hatha rini? Kala ndiwe Masihi fwambire lwazu-lwazu thu.” ");
INSERT INTO nyf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesu akiadzigidzya akiamba, “At'u ninwi namwambira kare, ela k'amukuluhirire. Bai zo kazi zangu nihendazo kwa dzina ra Baba zinaninenera, zizo vizho zinanimanyisa kukala ni h'ani. ");
INSERT INTO nyf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","“Ela k'amukuluhira kwa kukala k'amu kahi za badhi rangu. ");
INSERT INTO nyf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mut'u mimi ninazimanya zo ng'ondzi zangu, nazo nikusikira sauthi yangu na zikanithuwa, ");
INSERT INTO nyf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","nami ninazigera uzima wa kare na kare, nazo k'azindafwa na k'akuna adimaye kunihoka bule. ");
INSERT INTO nyf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Iye Baba ariyenip'a ni mubomu kuriko osi na k'akuna adimaye kuzinyagula kula mikononi mwa Baba. ");
INSERT INTO nyf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mimi na Baba hu kit'u kimwenga.” ");
INSERT INTO nyf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kusikira vizho o Ayahudi makitsola mawe kaheri mamukot'e. ");
INSERT INTO nyf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesu akiambira, “Nidzahenda mahendo manji madzo mbere zenu ambago Baba waniamba nigahende. Munamala kunikot'a mawe kwa hiro kahi za go?” ");
INSERT INTO nyf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","O Ayahudi makimudzigidzya makiamba, “K'ahumala kukukot'a mawe kwa mahendo madzo gogosi, ela kwa viryahu urizho unamukufuru Mulungu! Uwe u mudamu thu, ela unamala kudzihendya Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesu akidzigidzya akiamba, “Zhaorwa kahi za Sheria yenu kukala Mulungu waambira angine, ‘Ninwi mu milungu.’ ");
INSERT INTO nyf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mulungu waaiha milungu aryahu ambao map'ewa uv̱oro na hunamanya kukala zho gaambazho go Maoro ni ujeri hatha kare na kare. ");
INSERT INTO nyf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Vidze munamwamba iye ariyetsagulwa ni Baba na akihumwa urumwenguni, kukala anakufuru Mulungu kwa kukala naamba, ‘Ni Mwana wa Mulungu’? ");
INSERT INTO nyf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kala sihenda kazi za Baba, k'ahana haja ya kunikuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ela kala ninazihenda, ingahokala k'amunikuluhira munav̱irya kukuluhira zo kazi zangu, ili mumanye kamare-kamare kukala Baba yu ndani yangu, na mimi ni ndaniye.” ");
INSERT INTO nyf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","K'uzhona zho kusikira vizho makijeza kumugwira kaheri, ela akihenyeza mikononi mwao. ");
INSERT INTO nyf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesu akivuka kaheri nyangamo ya muho wa Jorodani hatha hat'u haryahu arihokala Johana wabat'iza at'u na akikala haho. ");
INSERT INTO nyf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Na lola at'u anji makimudzirira makiamba, “Johana k'ahendere miujiza mibomu, ela gosi arigonena dzulu za mut'u yuyu were ni jeri.” ");
INSERT INTO nyf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bai at'u anji kuko makimukuluhira Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bai kwereko mut'u mumwenga ariyeifwa Lazaro. Mut'u yuyu were anaishi na nduguze airi a kiche mario were ni Maryamu na Marith'a ko mudzi wa Beth'ania. Siku mwenga akikala mukongo. ");
INSERT INTO nyf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Maryamu yuyu ni yuyahu ariyemumwagira mafuha Bwana maguluni na akigahangusa na nyereze. Bai iye ndiye ariyekala nduguye Lazaro k'adima.) ");
INSERT INTO nyf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bai ao nduguze a kiche makihuma uv̱oro kwa Jesu kuamba, “Bwana musenao wa kurya na kuusa ni mukongo.” ");
INSERT INTO nyf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ela Jesu arihosikira akiamba, “Ukongo uu si wa kifwa, ela ni wa kumup'a nguma Mulungu. Na kwa ut'u wa ukongo uu, Mwana wa Mulungu andaluta nguma.” ");
INSERT INTO nyf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesu wamuhendza Marith'a hamwenga na Maryamu na ndugu yao Lazaro. ");
INSERT INTO nyf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Gonya ko, arihosikira uv̱oro wa ukongo wa Lazaro k'aukire kare kwenda, ela watoa haho siku mbiri nyingine zaidhi. ");
INSERT INTO nyf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Halafu ndo akiambira o anafundzie akiamba, “Hindeni Judea kaheri.” ");
INSERT INTO nyf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","O anafundzi marihosikira vizho makimudzigidzya makiamba, “Rabi, dzuzi-dzuzi Ayahudi mamala kukukot'a mawe, na vino unamala kuuya kuko kaheri mbona?” ");
INSERT INTO nyf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesu akiamba, “Mutsana una masaa kumi na mairi, hedu sozho? Bai mut'u akitsembera na mutsana k'akwala, kwa kukala anaona mulangaza wa urumwengu. ");
INSERT INTO nyf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ela akitsembera na usiku andakwala, kwa kukala k'ana mulangaza ndanimwe.” ");
INSERT INTO nyf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesu bada ya kunena vivi, achangeza akiamba, “Musena wehu Lazaro arere, ela nindakwenda nikamulamuse.” ");
INSERT INTO nyf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kusikira vizho o anafundzi makiamba, “Kala arere andauka.” ");
INSERT INTO nyf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ela Jesu were anaamba kukala adzanongeka, ela ao maona kukala arere uts'indzizi. ");
INSERT INTO nyf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Bai Jesu akiambira lwazu-lwazu, “Lazaro adzafwa, ");
INSERT INTO nyf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ela kwa ut'u wenu ninafwahirwa kukala sikalireho ili mudime kukuluhira. Ela nafwende ko kwakwe.” ");
INSERT INTO nyf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","T'omasi aifwaye “P'ats'a” akiambira anafundzi andziye akiamba, “Hindeni nanwi, hukafwe naye.” ");
INSERT INTO nyf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesu arihofika Beth'ania akithekeza kukala Lazaro were wafwa na hatha were wazikwa kare siku ne zirizokira. ");
INSERT INTO nyf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mudzi wa Beth'ania were u hehi na Jerusalemu, kiasi cha maili mbiri vivi. ");
INSERT INTO nyf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bai Ayahudi anji mere madzire kuap'a p'ore Marith'a na Maryamu kwa ut'u wa cho kifwa cha ndugu yao. ");
INSERT INTO nyf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","K'uzhona zho Marith'a arihosikira Jesu anadza wambola kumudhana, ela Maryamu ye akisala mo nyumbani. ");
INSERT INTO nyf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ndiho Marith'a akimwamba Jesu, “Bwana kalaho were u haha ndugu yangu k'angafwere, ");
INSERT INTO nyf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ela hatha vizho ninamanya kukala Mulungu andakup'a chochosi undichomuvoya.” ");
INSERT INTO nyf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesu akimwamba, “Nduguyo andafufuka.” ");
INSERT INTO nyf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marith'a akidzigidzya, “Ninamanya kukala andafufuka siku ya mwisho.” ");
INSERT INTO nyf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesu akimwamba, “Mimi ndimi ufufulo na ndimi uzima. Iye anikuluhiraye mimi hatha akafwa kidza andakala moyo kaheri, ");
INSERT INTO nyf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","na ye ariye moyo na akinikuluhira, k'andafwa bule. Unagakuluhira go?” ");
INSERT INTO nyf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marith'a akiamba, “Ee Bwana, ninakukuluhira kukala ndiwe Masihi Mwana wa Mulungu ariyeambwa andakudza urumwenguni.” ");
INSERT INTO nyf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marith'a arihogonya kunena vivi, wauya na achendamwiha nduguye Maryamu k'anda. Akimwamba, “Mwalimu adzire na anakurunga.” ");
INSERT INTO nyf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Bai Maryamu arihosikira vizho, akiuka haraka na achendamudhana. ");
INSERT INTO nyf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesu were k'adzafika ho mudzini, ela were achere haryahu arihothunganana na Marith'a. ");
INSERT INTO nyf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","O Ayahudi mariokala manamuhuriza Maryamu mo nyumbani, marihoona viryahu adzizhombola haraka na kwenda ndze, makimuthuwa, makiona kukala anenda akarire ko mbirani. ");
INSERT INTO nyf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bai Maryamu arihofika haho arihokala Jesu, na kumona thu, akigwa maguluni hakwe. Akiamba, “Bwana, kalaho were u haha ndugu yangu k'angafwere.” ");
INSERT INTO nyf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesu arihomona anarira na o Ayahudi mariokudza naye nao manarira, achangirwa ni mbazi na akibudzyika moyoni mwakwe zhomu. ");
INSERT INTO nyf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Akiuza akiamba, “Mwamulazahi kwani?” Makimwamba, “Bwana, ndzo uhalole!” ");
INSERT INTO nyf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesu akirira. ");
INSERT INTO nyf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bai o Ayahudi makiamba, “Lolani zho arizhokala anamuhendza.” ");
INSERT INTO nyf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ela ko angine makiamba, “Vidze ye ariyemuhendya mut'u asiyeona aone, vidze were k'angadimire kumuhendya yuno akatsafwa?” ");
INSERT INTO nyf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesu akidzalwa ni mbazi kaheri, achenda ko mbirani. Yo mbira were ni p'anga iriyo na iwe ririrokinganywa ho mulomoni. ");
INSERT INTO nyf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Bai Jesu akilagiza akiamba, “Usani ro iwe hedu.” Marith'a nduguye ye mufwa akidzigidzya akiamba, “Kundakala na muruk'e mui Bwana, mana rero ni ne hangu azikwe.” ");
INSERT INTO nyf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesu akimwambira, “Vidze sikwambirire kukala undaona nguma ya Mulungu ukikuluhira?” ");
INSERT INTO nyf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bai makirusa ro iwe. Jesu akilola ko dzulu na akiamba, “Ninakulazhira muv̱era Baba, kwa kukala unanisikira. ");
INSERT INTO nyf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ninamanya kukala unanisikira siku zosi, ela ninanena vivi kwa ut'u wa aa haha ili makuluhire kukala wanihuma.” ");
INSERT INTO nyf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bada ya kunena vivi akiluta mumiro kuiha. Akiamba, “Lazaro mbola kuno ndze!” ");
INSERT INTO nyf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ye mufwa achambola ndze na zo sandzaze na usowe were udzafungwa na kithambaa. Jesu akiamba, “H'aya muvuguleni athuwe shuhulize.” ");
INSERT INTO nyf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bai Ayahudi anji mariokala madziremutsemberera Maryamu na mariokala mazhona vizho arizhohenda Jesu mamukuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ela angine ao makwenda kwa Mafarisayo na machendaambira zho Jesu arizhokala adzahenda. ");
INSERT INTO nyf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bai alombi abomu na o Mafarisayo makiiha mukut'ano wa Baraza ra athumia na makiuzana-uzana makiamba, “Hundahendadze? Kwani mut'u yuyu anahenda miujiza minji. ");
INSERT INTO nyf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Hukimuricha vivi andaenderera na kila mut'u andamukuluhira, na o Arumi mandakudzanonga-nonga ro Hekalu rehu na ts'i yehu yosi.” ");
INSERT INTO nyf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kusikira vizho mumwenga wao aifwaye Kayafa ariyekala ndiye Mulombi mubomu mwenye mwaka uwo akiamba, “K'amuna mumanyaro. ");
INSERT INTO nyf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","K'amumanya kukala baha mut'u mumwenga kufwa kwa ut'u wa o at'u kuriko ts'i yosi kwanongwa?” ");
INSERT INTO nyf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","K'anenere vivi kwa akiliye mwenye, ela ni kwa kukala were nde Mulombi mubomu mwenye mwaka uwo, naye were anatabiri kukala Jesu were andafwa kwa ut'u wa Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hatha vizho si kwa ao thu, ela pia kwamba aakundzumanye hamwenga at'u osi a Mulungu mariotsamukana makale kit'u kimwenga. ");
INSERT INTO nyf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kwa vizho kula siku iyo o Ayahudi makikwatya kupanga kumwalaga Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Bai Jesu k'atsemberere kaheri lwazu-lwazu kuko Judea, ela wauka na achenda kut'u kurikoifwa Efuraimu hehi na nyika, ambako watoa na anafundzie. ");
INSERT INTO nyf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Vikara sikuk'uu ya Kiyahudi ya P'asaka were i hehi na at'u anji mambuka kwenda Jerusalemu, kwendadzitsusa kabila ya yo sikuk'uu yenye. ");
INSERT INTO nyf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","O at'u mere manamumala Jesu na makiambirana kahi za ro Hekalu makiamba, “Vidze munaonadze? Jeri munaona andakudza kwenye sherehe vino virizho?” ");
INSERT INTO nyf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nao manena vivi kwa kukala alombi abomu na Mafarisayo were madzalazha amulo kukala mut'u yoyosi amanyaye ko Jesu ariko anav̱irya avinene makamugwire. ");
INSERT INTO nyf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Siku t'andahu kabila ya sikuk'uu ya P'asaka, Jesu wakwenda Beth'ania mudzini kwa ano Lazaro ariye were wamufufula kula kifwani. ");
INSERT INTO nyf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bai makimuthayarishira chakurya haho, na Marith'a akikala nde muhikihiki kuno Lazaro akikala ni mumwenga wao mariokeresi mezani na Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bai Maryamu akihala rathili ya mafuha masafi ga marashi ga gali sana garigotengezwa kula kwa muhi wa munadi na akimumwagira Jesu mo maguluni na gonya akigahangusa na nyereze. K'uzhona zho wo muruk'e wa go marashi ukidzala nyumba ndzima. ");
INSERT INTO nyf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ela Juda Isikariote, mumwenga wa anafundzi a Jesu, ariye were nde andiyemusaliti arihoona vizho, akiamba, ");
INSERT INTO nyf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kwanoni marashi gano k'agaguzirwe dinari magana mahahu na makagerwa masikini?” ");
INSERT INTO nyf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","K'anenere vivi kwa kukala were ana mbazi sana na masikini, ela kwa kukala were ni mwivi na were akadzifwaha na cho changizwacho mo mukobani, mana were nde muiki wa wo mukoba wa p'esa. ");
INSERT INTO nyf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesu akiamba, “Muricheni agaike kwa kuthariziza siku yangu ya mazishi. ");
INSERT INTO nyf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Masikini munao siku zosini, ela mimi k'amundakala nami siku zosini bule.” ");
INSERT INTO nyf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kundi bomu ra Ayahudi masikira kukala Jesu a Beth'ania, kwa vizho machenda kuko. Nao makwenda si kwa ut'u wa Jesu h'akeye, ela pia kwa kumona Lazaro ariyefufulwa ni Jesu kula kifwani. ");
INSERT INTO nyf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Bai alombi abomu makipanga kumwalaga Lazaro naye. ");
INSERT INTO nyf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kwani kwa ut'u wa iye, Ayahudi anji were manaaricha vilongozi ao na kumukuluhira Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Siku ya hiriye ro kundi bomu ririrokala kahi za sikuk'uu ya P'asaka rikisikira kukala Jesu anadza Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bai makihala vitai zha mitende na machendamudhana kuno makipiga njerejere na kuamba, “Hosana! Naalikwe iye adzaye kwa dzina ra Bwana! Naalikwe iye muthawali wa Iziraeli!” ");
INSERT INTO nyf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu wapata mwana wa ndzowe na akimupanda here Maoro gaambazho, ");
INSERT INTO nyf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Musogohe h'enwi at'u a mudzi wa Sayuni. Lolani muthawali wenu anadza! Anadza dzulu ya mwana wa ndzowe.” ");
INSERT INTO nyf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Anafundzie k'amavielewere bule wakathi uwo vivi, ela Jesu arihokala adzafufulwa na kugerwa nguma makikumbukira kukala Maoro gaamba vivi dzuluze, na kwamba were mamuhendera vivi. ");
INSERT INTO nyf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ro kundi ririrokala na Jesu arihomufufula Lazaro kula kifwani rere ridzamboza ushahidhi kuhusu gago garigohendeka. ");
INSERT INTO nyf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bai vizho ndo virizhohenda at'u anji mamutsangire, kwa kukala masikira wahenda uu muujiza. ");
INSERT INTO nyf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mafarisayo machambirana makiamba, “H'aya lolani k'ahufaulu kamare. Lola urumwengu wosi unamuthuwa!” ");
INSERT INTO nyf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kahi za aryahu mariokwendavoya Jerusalemu wakathi wa sherehe angine were ni Ayunani. ");
INSERT INTO nyf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bai machenda kwa Filipu, mut'u wa Beth'isaida kuko Galilaya na makiamba, “Muzee, hunamala humone Jesu.” ");
INSERT INTO nyf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipu achendamwambira Anderea na osi airi machendamwambira Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesu akiamba, “Wakathi udzafika wa Mwana wa Mudamu kugerwa nguma ");
INSERT INTO nyf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ninamwambira ujeri, t'embe ya ngano isihogwa mutsangani ikafwa, ni kutoa h'akeye, ela ikifwa nikuzhala zhomu zhenye. ");
INSERT INTO nyf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mut'u aihendzaye rohoye, andayangamiza, ela kila aimenaye rohoye kahi za urumwengu uu, andaithizha hatha uzima wa kare na kare. ");
INSERT INTO nyf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ye amalaye kunihumikira, suthi anithuwe, ili muhumiki wangu akale ho niriho mimi. Baba andamuheshimu iye anihumikiraye.” ");
INSERT INTO nyf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Vikara moyo wangu unasirima, vikara nineneni? Vidze niambe, ‘Baba, usihende thabu ii ikanigwerera?’ Hatha, vivi ndo virizhonireha kwamba niikirire thabu ii. ");
INSERT INTO nyf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baba rip'e nguma dzinaro.” Kidza sauthi kula mulunguni ikiamba, “Nidzarip'a nguma na nindarip'a nguma kaheri.” ");
INSERT INTO nyf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ro kundi ririrokala haho rasikira yo sauthi na rikiamba, “Kudzadoka kigwaragwara.” Angine makiamba, “Ni malaika adzanena naye.” ");
INSERT INTO nyf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesu akiamba, “Sauthi ii k'ainenere kwa ut'u wa mimi, ela idzanena kwa ut'u wa ninwi. ");
INSERT INTO nyf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vikara uu ni wakathi wa urumwengu kuhukumiwa, vikara muthawali wa urumwengu uu andapenduliwa. ");
INSERT INTO nyf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nami nichanulwa dzulu za ts'i, nindaavuha at'u osi kwangu.” ");
INSERT INTO nyf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wanena vivi kunyesa kifwache kindizhokala. ");
INSERT INTO nyf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ro kundi rikidzigidzya rikiamba, “Sheria yehu inaamba kukala Masihi andakala moyo kare na kare. Vikaladze bai unaamba, ‘Mwana wa Mudamu lazima anulwe dzulu?’ Yuno Mwana wa Mudamu ni h'ani?” ");
INSERT INTO nyf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesu akidzigidzya akiamba, “Wo mulangaza uchere nanwi kwa wakathi muchache thu. Tsemberani kahi za mulangaza, sidze mukagit'anirwa ni kiza, kwa kukala mut'u atsemberaye k'amanya bule ko endako. ");
INSERT INTO nyf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kuluhirani wo mulangaza zho ucherezho nanwi ili mukale at'u a mulangaza.” Bada ya Jesu kunena vivi akiahaukira na achendadzifitsa. ");
INSERT INTO nyf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ingahokala wahenda miujiza ii yosi mbere zao, ela k'amamukuluhirire. ");
INSERT INTO nyf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bai zho arizhonena nabii Isaya vikithimira. Isaya waamba, “Bwana, ni h'ani ariyekuluhira uv̱oro wehu? Bwana wanyesa nguvuze kwa h'ani?” ");
INSERT INTO nyf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kwa chausa kiki k'amadimire kukuluhira. Kwani Isaya waamba kaheri, ");
INSERT INTO nyf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mulungu adzagahendya matso gao gasione na adzaihendya mioyo yao ikale mikomu masidze makaona na matso gao na mioyo yao ikang'alirwa, makanigalukira mimi, nikaahoza.” ");
INSERT INTO nyf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya waamba vivi kwa kukala waona nguma ya Jesu na akinena dzuluze. ");
INSERT INTO nyf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hatha vizho anji kahi za vilongozi mamukuluhira Jesu, ela k'amanenere lwazu-lwazu kwa ut'u wa Mafarisayo, ili masiingwe kahi za masinagogi. ");
INSERT INTO nyf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kwani mahendza zhomu kulikwa ni at'u kuriko kulikwa ni Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesu akiluta mumiro, akiamba, “Ye andiyenikuluhira, k'anikuluhira mimi thu, ela hatha iye ariyenihuma. ");
INSERT INTO nyf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Na anonaye, anamona hatha iye ariyenihuma. ");
INSERT INTO nyf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nakudza urumwenguni dza here mulangaza kwamba kila anikuluhiraye asikale kizani. ");
INSERT INTO nyf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ye asikiraye uv̱oro wangu na kutsaukuluhira sindamuhukumu. Sidzire kuuhukumu urumwengu, ela nakudza kuwakola. ");
INSERT INTO nyf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ye anikahalaye na k'akubali uv̱oro wangu andahukumiwa ni mut'u mumwenga. Ro neno nidzironena rindakala muhukumuwe siku ya mwisho. ");
INSERT INTO nyf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mana sidzinenerere mwenye, ela Baba ariyenihuma adzaniamuru ninene go ambago ganav̱irya ninene. ");
INSERT INTO nyf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nami ninamanya kukala amuriye inareha uzima wa kare na kare. Kwa vizho go niambago ndo Baba adzigonambira ninene.” ");
INSERT INTO nyf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bai kabila sikuk'uu ya P'asaka kuandza, Jesu wakala anamanya kukala wakathiwe wa kuuka urumwenguni na kuuya kwa Babaye udzafika. Naye waahendza aryahu mariokala a kwakwe kahi za urumwengu uu, waahendza vivi hatha mwisho. ");
INSERT INTO nyf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesu na anafundzie were manarya chakurya cha dziloni. K'uzhona zho Shethani were adzawadzala moyo wa Juda mwana wa Simoni Isikariote kwamba amusaliti Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesu wamanya kukala Baba were adzamup'a nguvu zosi. Wamanya kukala wala kwa Mulungu na anauya kwa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Bai Jesu akiuka ho mezani hakwe akivula nguwoye ya dzulu na akidzifunga kithambaa chununi. ");
INSERT INTO nyf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Gonya achangiza madzi besenini na akiandza kugesa nyayo za o anafundzie na akizifurusha na cho kithambaa arichokala adzadzifunga chununi. ");
INSERT INTO nyf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Arihomufikira Simoni P'et'ero amugese nyayoze, P'et'ero akikahala, akiamba, “Vidze unanagesa nyayo uwe Bwana?” ");
INSERT INTO nyf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesu akiamba, “Vivi k'umanya ninahendadze, ela undamanya badaye” ");
INSERT INTO nyf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","P'et'ero akiamba, “Hatha, k'undanagesa nyayo zangu bule.” Jesu akidzigidzya akimwamba, “Kala sindakwagesa be k'u mwanafundzi wangu.” ");
INSERT INTO nyf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni P'et'ero akiamba, “Bwana, kala ni vizho be usagese nyayo zangu thu-thu-thu, ela nagesa hatha mikono na kitswa changu!” ");
INSERT INTO nyf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesu akiamba, “Ye adziyeoga ni musafi kamare na k'ana haja ya kuoga kaheri isihokala nyayoze. Ela si nyosi murio mu asafi.” ");
INSERT INTO nyf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesu wamanya andiyemusaliti ndo akiamba, “Si nyosi murio asafi.” ");
INSERT INTO nyf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesu arihogonya kuagesa nyayo zao, wavwala valore ra ndze na akiuya hat'uhe kahi za meza na akiuza, “Vidze munaelewa zho nidzizhomuhendera? ");
INSERT INTO nyf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Munaniha Mwalimu na Bwana na munanena jeri kwani ndo nirizho. ");
INSERT INTO nyf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bai kala mimi Bwana na Mwalimu wenu nidzamwagesa nyayo zenu, ninwi nanwi munav̱irya mugesane nyayo zenu. ");
INSERT INTO nyf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mana nidzamwanyesa mufano ili muhende here nidzizhomuhendera. ");
INSERT INTO nyf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ninamwambira ujeri wenye kukala, mutumwa k'adima kukala mubomu kumukira Bwanawe, hedu muhumwa kukala mubomu kuriko ye ariyemuhuma. ");
INSERT INTO nyf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Vikara murizho mudzamanya maut'u gaga, bai mundahaswa mundihogahenda. ");
INSERT INTO nyf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Sinena kwa ninwi nyosi. Ninamanya aryahu nidzioatsagula. Ela Maoro lazima gathimire, gaambago, ‘Ye mut'u arerya chakurya nami wanigalukira.’ ");
INSERT INTO nyf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ninamwambira kare kabila k'avidzahendeka, kwamba vikihendeka mukuluhire kukala, mimi ndimi iye. ");
INSERT INTO nyf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ninamwambira ujeri, mut'u amuhokeraye iye mut'u niriyemuhuma, ananihokera mimi, na iye anihokeraye mimi, anamuhokera iye ariyenihuma.” ");
INSERT INTO nyf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bada ya kunena vivi Jesu akibudzyika zhomu na akinena lwazu-lwazu, akiamba, “Ninamwambira ujeri, mumwenga wenu andanisaliti.” ");
INSERT INTO nyf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Anafundzi makilolana na kwangalala dzulu za ni h'ani ariyekala anaambwa. ");
INSERT INTO nyf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Bai yuyahu mwanafundzi ariyehendzwa zaidhi ni Jesu were akelesi hehi naye. ");
INSERT INTO nyf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni P'et'ero akimufinyira dzitso kuamba, “Muze kala ananena dzulu za h'ani.” ");
INSERT INTO nyf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Bai yuyahu mwanafundzi akisongera hehi na Jesu zaidhi na akiuza akiamba, “Ni h'ani Bwana?” ");
INSERT INTO nyf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesu akidzigidzya akiamba, “Ye nindiyemup'a mukahe nindiokala nidzautsotsa mutsuzini ndeye.” Bai akihala kisiku cha mukahe, akikitsotsesha na akimup'a Juda mwana wa Simoni Isikariote. ");
INSERT INTO nyf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Juda arihohala wo mukahe, Shethani wamwangira. Jesu akiamba, “Kihende haraka cho umalacho kuhenda!” ");
INSERT INTO nyf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Vikara k'ahana hatha mumwenga ho mezani ariyeelewa kwanoni Jesu wamwambira vivi Juda. ");
INSERT INTO nyf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Juda were nde mwiki wa wo mukoba wa p'esa, kwa vizho anafundzi angine makiona kukala Jesu were adzamwambira agule zho vimalikanazho kwa sherehe, hedu aap'e chochosi akiya. ");
INSERT INTO nyf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Juda akihala wo mukahe na achenda ndze kare. Nako kwere ni usiku. ");
INSERT INTO nyf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bai bada ya Juda kuuka, Jesu akiamba, “Vikara Mwana wa Mudamu andap'ewa nguma. Na kukirira kwakwe, Mulungu andagerwa nguma. ");
INSERT INTO nyf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na kala Mulungu andagerwa nguma kukirira kwakwe, bai Mulungu andamup'a nguma Mwana wa Mudamu ndanimwe, na andahenda vizho haraka. ");
INSERT INTO nyf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Anangu, mut'u mimi sindakala nanwi muda mure. Mundanimala, ela ninamwambira kare zho nirizhoambira Ayahudi kukala, ‘k'amudima kudza kuko nendako.’ ");
INSERT INTO nyf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Namup'a amuri mbisha: Hendzanani. Here nidzizhomuhendza, bai hendzanani. ");
INSERT INTO nyf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mukihendzana, osi mandamanya kukala ninwi mu anafundzi angu jeri.” ");
INSERT INTO nyf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni P'et'ero akiuza, “Unendahi Bwana?” Jesu akidzigidzya akiamba, “K'udima kudza kare vivi ko nendako, ela undakudza badaye” ");
INSERT INTO nyf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","P'et'ero akiamba, “Bwana kwanoni sidima kukuthuwa vino kare? Ni thayari kufwa kwa ut'u wa uwe!” ");
INSERT INTO nyf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesu akiamba, “Vidze u thayari jeri kufwa kwa ut'u wa mimi? Nakwambira ujeri kabila jogolo k'aridzaika, undanikana k'ana t'ahu!” ");
INSERT INTO nyf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Musikale na wasiwasi mioyoni mwenu. Mukuluhireni Mulungu na mimi nami. ");
INSERT INTO nyf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kuko ariko Baba kuna makalo manji, kala k'akuna ningamwambira. Mimi ninenda nikamuthayarishire hat'u, ");
INSERT INTO nyf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","na nichendamuthayarishira hat'u, nindakudza kaheri nimuhale ili ho nindihokala mimi, nanwi mukale haho. ");
INSERT INTO nyf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Munamanya ngira ya kuko nendako.” ");
INSERT INTO nyf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ndo T'omasi akimuza akiamba, “Bwana k'ahumanya ko wendako, hunadimadze kumanya ngira ya kufika kuko?” ");
INSERT INTO nyf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Bai Jesu akimudzigidzya akiamba, “Mimi ndimi ngira, ndimi ujeri na ndimi uzima, k'akuna adimaye kudza kwa Baba asihokirira kwangu. ");
INSERT INTO nyf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bai kwa kukala unanimanya, undamumanya ye Baba naye na kuandzira vivi, unamumanya na udzamona.” ");
INSERT INTO nyf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipu akimwamba, “Bwana, fwanyese ye Baba naswi fundathosheka.” ");
INSERT INTO nyf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu akiamba, “Nidzakala hamwenga nanwi nyosi muda wosi uu, kidza k'unimanya Filipu? Ye adziyenona mimi adzamona Baba. Kwanoni unaamba, ‘Fanyese Baba?’ ");
INSERT INTO nyf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Vidze k'ukuluhira Filipu kukala mimi ni ndani ya Baba na Baba a ndani yangu? Go maneno ninenago k'agala kwangu. Ye Baba ariye ndani yangu anahenda kazize. ");
INSERT INTO nyf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kuluhirani kukala mimi ni ndani ya Baba na Baba a ndani yangu. Kala sozho, kuluhirani kwa ut'u wa yo miujiza nihendayo. ");
INSERT INTO nyf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ninamwambira ujeri ye anikuluhiraye andahenda kazi nizihendazo mimi, na andahenda hatha zaidhi ya zizi, kwa kukala ninenda kwa Baba. ");
INSERT INTO nyf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na nindahenda chochosi mundichomala kwa dzina rangu, ili ishima ya Baba ioneke kukirira na ye Mwana. ");
INSERT INTO nyf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mukivoya kit'u chochosi kwa dzina rangu nindakihenda.” ");
INSERT INTO nyf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Mukinihendza mundagwira malagizo gangu. ");
INSERT INTO nyf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nami nichenda nindamuvoya Baba amurehere Mwavizi. Iye akidza andakala nanwi kare na kare. ");
INSERT INTO nyf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iye nde Roho aung'azaye ujeri, ambaye at'u a urumwengu k'amadima kumuhokera, kwa kukala k'amamona na k'amamumanya. Ela ninwi munamumanya kwa kukala anakala hamwenga nanwi na andakala ndani mwenu. ");
INSERT INTO nyf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Sindamuricha h'akiyenu dza here ana k'iya, nindamudzirira. ");
INSERT INTO nyf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ndani za muda muchache urumwengu k'aundanona kaheri, ela ninwi mundanona, na kwa kukala nina uzima, ninwi nanwi mundakala nawo. ");
INSERT INTO nyf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Siku iyo ikifika, mundamanya kukala mimi ni ndani ya Baba na kwamba ninwi mu ndani yangu na mimi ni ndani yenu. ");
INSERT INTO nyf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Iye adzifundishaye malagizo gangu na kugagwira be nde anihendzaye jeri, nami nindamuhendza na nindadzimanyisa kwakwe. Na iye anihendzaye andahendzwa ni Baba.” ");
INSERT INTO nyf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kwereko na mwanafundzi ariyeifwa Juda naye, (ela yuyu si yuyahu Isikariote). Mwanafundzi yuyu akimwamba Jesu, “Bwana unamala kudzimanyisa kwehu, ela si kwa urumwengu?” ");
INSERT INTO nyf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesu akiamba, “Iye anihendzaye andagwira malagizo gangu. Naye Baba andamuhendza, na mimi na Baba hundamudzirira na kuhenda makalo naye siku zosi. ");
INSERT INTO nyf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Iye asiyenihendza, k'agwira malagizo gangu bule. Uv̱oro mudziousikira si wangu, ela ula kwa Baba ariyenihuma. ");
INSERT INTO nyf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nidzamwambira maut'u gaga gosi vivi hucherezho hosini. ");
INSERT INTO nyf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ela iye Mwavizi, iye Roho Mweri kidza, ambaye Baba andamureha kwa dzina rangu, andamufundisha na kumukumbukiza gosi nirigomwambira. ");
INSERT INTO nyf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ninamup'a dheri, na dheri rangu si here riro ra urumwengu umup'azho. Musikale na wasiwasi na musogohe. ");
INSERT INTO nyf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mudzanisikira nikimwambira, ‘Ninenda, ela nindakudza kaheri kwenu.’ Kalaho munanihendza mukafwahirwa kwa kukala ninenda kwa Baba, kwani iye ni mubomu kuriko mimi. ");
INSERT INTO nyf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Sirikizani! Nidzamwambira kimbere kukala maut'u gaga gandahendeka, ili gakihendeka mudime kukuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Vikara nina wakathi muchache sana wa kunena nanwi, kwa kukala muthawali wa urumwengu uu anadza. Naye k'ana wadimi dzulu zangu, ");
INSERT INTO nyf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ela nikwamba nahenda gosi arigonilagiza Baba ili urumwengu umanye kukala ninamuhendza Baba. Ukani fwende.” ");
INSERT INTO nyf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesu akiamba, “Mimi ndimi muzabibu wa jeri, na Baba ndiye muk'urima. ");
INSERT INTO nyf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila kitai ndani mwangu kisichozhala matunda, iye ni kukitosa, na kila kitai kizhalacho matunda, ni kukitsatsulira kizidhi kuzhala zhomu. ");
INSERT INTO nyf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ninwi mudzagonya kukala asafi kukirira na ro neno niriromwambira. ");
INSERT INTO nyf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Bai kalani ndani yangu nami ndani yenu. Dza here viryahu kitai kirizho k'achadima kuzhala matunda chamba kidzatoswa na ki h'akeye, vizho zhenye ninwi k'amudima kuzhala matunda musihotoa ndani mwangu. ");
INSERT INTO nyf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mimi ni muzabibu na ninwi mu vitai. Mut'u akitoa ndani yangu andazhala matunda manji, kwani bila mimi, k'amwadima kuhenda chochosi. ");
INSERT INTO nyf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mut'u asihokala ndani yangu, a here kitai kifu. Bai vitai vifu ni kutsolwa-tsolwa na vikatsufwa mohoni. ");
INSERT INTO nyf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mukikala ndani yangu na maneno gangu gakikala ndani yenu, voyani rorosi mumalaro nanwi mundap'ewa. ");
INSERT INTO nyf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mukizhala matunda manji Baba andap'ewa nguma na kwa ut'u uu at'u mandamanya kukala mu anafundzi angu. ");
INSERT INTO nyf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Here Baba arizhonihendza, bai nami namuhendza ninwi dza vizho. Kalani kahi za mahendzo gangu. ");
INSERT INTO nyf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mukigagwira malagizo gangu, mundakala kahi za mahendzo gangu, dza viryahu nirizhogagwira malagizo ga Baba na nikikala kahi za mahendzoge. ");
INSERT INTO nyf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nidzamwambira vivi kwamba furaha yangu ikale ndani yenu na kidza furaha yenu ikamilike. ");
INSERT INTO nyf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Riri ndo lagizo rangu: Hendzanani dza here zho nirizhomuhendza. ");
INSERT INTO nyf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","K'akuna mwenye mahendzo mabomu kuriko mut'u afwaye kwa ut'u wa asenae. ");
INSERT INTO nyf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nanwi mukihenda here nimulagizazho mundakala asenangu. ");
INSERT INTO nyf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Vikara simwiha ahumiki kaheri, ela namwiha asena, kwa kukala muhumiki k'amanya aazaro Bwanawe. Ela ninwi namwiha asena, kwa kukala gosi nirigosikira kwa Baba namumanyisa. ");
INSERT INTO nyf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ninwi k'amunitsagulire, ela mimi ndimi niriyemutsagula kwamba mukazhale matunda gandigotoa na Baba andamup'a rorosi mundiromala kwa dzina rangu. ");
INSERT INTO nyf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Bai ninamulagiza kwamba muhendzane.” ");
INSERT INTO nyf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Urumwengu uu ukimumena, manyani wanimena mimi chaho. ");
INSERT INTO nyf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bai kalaho mu a urumwengu, uwo urumwengu ungamuhendza, kwa kukala mungere mu dza uwo. Ela vikara ninwi k'amua urumwengu, mana namutsagula kumbola kwa uwo urumwengu na ndosa udzamumena. ");
INSERT INTO nyf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bai gakumbukireni go nirigomwambira kukala, ‘Mutumwa k'adima kukala mubomu kumukira bwanawe.’ Kwa vizho ninamwambira kukala, kala manitesa mimi bai mandamutesa hatha ninwi nanwi. Na kala magwira mafundisho gangu, bai mandagwira hatha go genu nago. ");
INSERT INTO nyf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ela mandamuhendera mai kwa ut'u wa mimi, na kwa kukala k'amamumanya iye ariyenihuma. ");
INSERT INTO nyf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kalaho mimi sidzire haha dhuniani kunena nao, ngere k'amadima kupigwa ulongo kwamba ni adambi. Ela vikara k'amadima kudzihehera dzulu za yo dambi yao. ");
INSERT INTO nyf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mut'u adziyenimena mimi adzamumena hatha Baba naye. ");
INSERT INTO nyf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kala k'amayonere yo miujiza niriyohenda iriyo, k'akuna mut'u mungine ariyepata kuihenda kimbere, ngere k'amadima kupigwa ulongo kwamba ni adambi. Ela hatha bada ya kuona yo miujiza niriyoihenda, manimena mimi hamwenga na Baba. ");
INSERT INTO nyf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Vivi zhakala ili ripate kuthimira neno ririroorwa kahi za Sheria yao, riambaro, ‘Manimena bila chausa!’ ");
INSERT INTO nyf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ela andihokudza ye Mwavizi, nindiyemuhuma mimi kula kwa Baba, ambaye ni ye Roho wa ujeri, andamboza ushahidhi dzulu zangu mimi. ");
INSERT INTO nyf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Hatha ninwi nanwi mundakala mashahidhi angu, kwa kukala ninwi ndinwi mudziokala hamwenga nami hangu chaho. ");
INSERT INTO nyf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nidzamwambira maut'u gaga ili musiuye nyuma. ");
INSERT INTO nyf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kwani mandamuthenga kula kahi za masinagogi gao, na kidza zaidhi ya vivi kundakudza wakathi ambawo vindakala mut'u akikwalaga andaona here kwa kuhenda vizho anamuhumikira Mulungu. ");
INSERT INTO nyf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kidza mandahenda vizho, kwa kukala k'amamumanya Baba na k'amanimanya hatha mimi. ");
INSERT INTO nyf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ela nidzamwambira maut'u gaga kimbere ili wakathi wao wa kuhenda vivi ukifika mudime kukumbukira kukala namwambira kare. Simwambirire maut'u gaga hangu chaho, kwa kukala were ni hamwenga nanwi.” ");
INSERT INTO nyf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ela vivi ninenda kwa iye ariyenihuma, kidza k'ahana hatha mumwenga wenu anuzaye, ‘Unendahi?’ ");
INSERT INTO nyf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ela kwa kukala dzanena vivi, bai mioyo yenu idzadzalwa ni kigondzi. ");
INSERT INTO nyf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Hatha vizho ninamwambira ujeri wenye, vindakala vidzo kwenu nichenda, mana kala sindakwenda ye Mwavizi k'andakudza kwenu, ela nichenda nindamuhuma kwenu. ");
INSERT INTO nyf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na andihokudza andauhenda urumwengu ung'alirwe lwazu-lwazu dzulu za dambi na ueri na hukumu. ");
INSERT INTO nyf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Andaahendya mang'alirwe o at'u a urumwengu uu, kukala ni enye dambi kwa kukala k'amanikuluhira mimi. ");
INSERT INTO nyf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Andaahendya mang'alirwe o at'u a urumwengu kukala ni muhachi kwa kukala ninenda kwa Baba nanwi k'amundanona kaheri. ");
INSERT INTO nyf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Andaahendya mang'alirwe o at'u a urumwengu kukala Mulungu nde jaji kwa kukala wagonya kare kumuhukumu muthawali wa urumwengu uu. ");
INSERT INTO nyf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mut'u mimi nina maut'u manji zaidhi ga kunena nanwi, ela gandakala manji nanwi zhomu kwa wakathi uu. ");
INSERT INTO nyf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ela ye Roho aung'azaye ujeri akidza andamulongoza kwenye ujeri wosi, mana k'andanena kwa wadimi wa kwakwe mwenye, ela andanena kila kit'u andichosikira kula kwangu na kidza andamwambira maut'u gandigokudza. ");
INSERT INTO nyf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iye andanip'a nguma, kwa kukala andahala go nindigonena na amwambire ninwi. ");
INSERT INTO nyf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Gosi garigo ga Baba ni gangu, ndosa namwambira kukala Roho andahala maneno gangu na amwambire ninwi.” ");
INSERT INTO nyf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kwa muda muchache k'amundanona kaheri, na kidza bada ya muda muchache mundanona kaheri.” ");
INSERT INTO nyf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Bai anafundzi a kwakwe angine makiuzana-uzana, makiamba, “Ni noni vino afwambirazho kukala, ‘Kwa muda muchache k'amundanona na kidza kaheri kwa muda muchache mundanona,’ na gonya anaamba anenda kwa Babaye?” ");
INSERT INTO nyf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Makienderera kuuzana-uzana, makiamba, “Mana ya kuamba, ‘Muda muchache’ ni noni? Siswi be hatha k'ahumanya mana ya vivi ni noni.” ");
INSERT INTO nyf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Bai Jesu akimanya cho marichokala manamala kumuza akiamba, “Vidze vino ndizho muuzanazho enye kwa enye kukala manaye ni noni kuamba, ‘Kwa muda muchache k'amundanona na kaheri kwa muda muchache mundanona kaheri?’ ");
INSERT INTO nyf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ninamwambira ujeri wenye kukala kwa muda muchache udzao mundarira na kubagarikwa ni matsozi, ela at'u a urumwengu mandafwahirwa. Mundashononeka, ela kaheri kwa muda muchache kushononeka kwenu, kundagaluka furaha. ");
INSERT INTO nyf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wakathi wa utsungu wa mwanamuche amalaye kuzhala ukifika, ye mwanamuche nikukala ana kigondzi. Ela agonyaho kuzhala mwanawe ni kusahau wo utsungu. Vivi ni kwa sababu ya iyo furaha ya kureha mwana dhuniani. ");
INSERT INTO nyf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ninwi vivi muna kigondzi, ela mimi nindamona kaheri na mioyo yenu indadzala furaha, furaha ambayo k'akuna adimaye kuyusa kwenu. ");
INSERT INTO nyf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Siku iyo ikidza mimi k'amundanivoya kit'u, kwani ninamwambira ujeri kukala ye Baba andamup'a chochosi mundichovoya kwa dzina rangu. ");
INSERT INTO nyf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ninwi hatha warero k'amudzangwe kuvoya chochosi kwa dzina rangu, bai voyani nanwi mundapata ili furaha yenu ikamilike. ");
INSERT INTO nyf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Vivi nidzanena nanwi kwa mafumbo, ela wakathi unadza ambaho nindanena nanwi, lwazu-lwazu dzulu za ye Baba. ");
INSERT INTO nyf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Siku iyo ikidza mundavoya kwa dzina rangu, nami siamba kukala nindamuvoya Baba kwa ut'u wenu bule. ");
INSERT INTO nyf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kwani Baba mwenye anamuhendza, kwa kukala ninwi enye munanihendza na munakuluhira kukala nambola kwa Baba. ");
INSERT INTO nyf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nambola kwa Baba na nikidza haha urumwenguni na vino kaheri ninauka urumwenguni, na ninauya kwa Baba.” ");
INSERT INTO nyf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ndo anafundzie makiamba, “K'ona zho, vikara k'unena naswi kimafumbo kaheri, ela unanena naswi lwazu-lwazu. ");
INSERT INTO nyf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vikara hunamanya kukala unamanya kila kit'u, na kwamba k'umala mut'u akuze maswali, kwa ut'u uu hunakuluhira kukala wala kwa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ndo Jesu akiadzigidzya akiamba, “Vidze vikara munakuluhira? ");
INSERT INTO nyf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bai wakathi unadza, na hatha udzafika kare, ambawo mundatsamukana kila mut'u kwao-kwao na muniriche h'akiyangu. Ela hatha vizho si h'akiyangu bule, mana Baba a hamwenga nami. ");
INSERT INTO nyf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Bai nidzamwambira vivi ili mukale na dheri kwa kukala kit'u kimwenga nami. Kahi za urumwengu uu, mundapata thabu, ela dzip'eni moyo mana mimi nidzaushinda urumwengu.” ");
INSERT INTO nyf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Bada ya Jesu kugonya kunena vivi, walola dzulu mulunguni na akivoya, “Baba wakathi udzafika. Bai mup'e nguma Mwanao, ili iye Mwanao naye akup'e nguma. ");
INSERT INTO nyf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mana wamup'a wadimi dzulu za at'u osi kwamba adime kuap'a uzima wa kare na kare osi uriomup'a. ");
INSERT INTO nyf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Vikara uzima wa kare na kare ni uu, kwamba makumanye uwe Mulungu wa jeri na wa h'akeye na Jesu Masihi uriyemuhuma. ");
INSERT INTO nyf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mimi nidzakurehera nguma dhuniani kwa kuimarigiza yo kazi uriyonip'a niihende. ");
INSERT INTO nyf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Vikara Baba, nip'a nguma, nip'a nguma iryahu niriyokala nayo nirihokala hamwenga nawe kabila urumwengu k'audzaumbwa.” ");
INSERT INTO nyf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Mut'u mimi nidzaahendya ao at'u urionip'a kula kahi za urumwengu makumanye. At'u ao were ni ako nao ukinip'a nao makirigwira nenoro. ");
INSERT INTO nyf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Vikara vivi manamanya kukala kila kit'u niricho nacho kila kwako, ");
INSERT INTO nyf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kwani mimi naambira maneno urigonip'a na makigakubali. Kwa vizho madzamanya kwa hakika kukala nala kwako, na madzakuluhira kukala ndiwe uriyenihuma. ");
INSERT INTO nyf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Bai ninaavoyera. Siavoyera at'u a urumwengu, ela naavoyera aryahu urionip'a, mana ni ako. ");
INSERT INTO nyf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Osi nirio nao ni ako na osi urio nao ni angu, nami ninap'ewa nguma kwa ao. ");
INSERT INTO nyf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Vikara mimi si mumu urumwenguni kaheri, ninadza kwako uwe Baba uriye mueri. Ela aa machere mumu urumwenguni, bai arinde kwa nguvu za dzinaro, riryahu dzina urironip'a, ili makale kit'u kimwenga here mimi na uwe hurizho kit'u kimwenga. ");
INSERT INTO nyf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bai nirihokala ni hamwenga nao nakala nikiarinda kahi za dzinaro. Naarinda osi urionip'a na k'ahana ariyengamika isihokala ye ariye were suthi angamike ili Maoro gathimire. ");
INSERT INTO nyf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ela vikara ninadza kwako, ela ninanena maut'u gaga vivi nirizho nichere haha dhuniani, ili furaha yao ikamilike ndani mwao. ");
INSERT INTO nyf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nidzaap'a nenoro, na at'u a urumwengu uu, madzaamena mana ao si at'u a urumwengu kaheri here mimi nirizho si mut'u wa urumwengu. ");
INSERT INTO nyf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Voyo rangu si kwamba uause kula haha urumwenguni, ela uarinde na ye Mui. ");
INSERT INTO nyf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ao si at'u a urumwengu here mimi nirizho si mut'u wa urumwengu. ");
INSERT INTO nyf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ahende aeri kwa wo ujeri, mana nenoro ndo ujeri. ");
INSERT INTO nyf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nidzaahuma kwa at'u a urumwengu here uwe urizhonihuma kwa at'u a urumwengu uu. ");
INSERT INTO nyf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na kwa ut'u wa aa ninadzilazha kwako ili ao nao madzilazhe kwako kamare-kamare.” ");
INSERT INTO nyf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Mimi siavoyera aa h'akiyao, ela naavoyera na aryahu mandionikuluhira kukirira kwa neno ra aa, ");
INSERT INTO nyf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ili ao osi makale kit'u kimwenga h'ewe Baba, here urizho uwe u ndani yangu na mimi ni ndani mwako. Bai nao makale ndani yehu ili urumwengu udime kukuluhira kukala uwe ndiwe uriyenihuma. ");
INSERT INTO nyf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mimi naap'a nguma dza iryahu uriyonip'a, ili makale kit'u kimwenga here siswi hurizho kit'u kimwenga. ");
INSERT INTO nyf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mimi ni ndani yao na uwe u ndani yangu. Bai ao nao makale kit'u kimwenga kamare, ili urumwengu udime kumanya kukala uwe ndiwe uriyenihuma. Kidza madime kumanya kukala unaahendza here unihendzazho mimi. ");
INSERT INTO nyf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Baba, ninahendza aryahu osi urionip'a makale hamwenga nami ho niriho na maone nguma yangu. Ii ndo nguma ambayo wanip'a kabila urumwengu k'audzaumbwa, mana wanihendza. ");
INSERT INTO nyf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baba uriye muhachi, idzahokala at'u a urumwengu k'amakumanya, mimi ninakumanya na o at'u angu manamanya kukala uwe ndiwe uriyenihuma. ");
INSERT INTO nyf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mimi nidzaamanyisa uwe, na nindaenderera kukuhendya makumanye ili go mahendzo urigo nago kwangu, gakale mioyoni mwao, na mimi nami nikale kit'u kimwenga nao.” ");
INSERT INTO nyf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bai bada ya Jesu kugonya kunena maneno gaga, waahala o anafundzie na akiuka hat'u haho. Machenda na makivuka det'e ra Kidironi kurikokala kuna chunga kithithe cha mizeituni na machangira mumo. ");
INSERT INTO nyf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Vikara Juda ariyekala andamusaliti Jesu, were anahamanya hat'u haho, mana Jesu na anafundzie makala makithunganana haho mara kwa mara. ");
INSERT INTO nyf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Bai Juda akidza haho kuno analongoza kundi ra at'u. Kahi za kundi riro kwere kuna arindzi a ro Hekalu mariokala madzambola kwa o alombi abomu na Mafarisayo. Angine kahi zao ao mere ni shikari a Kirumi. Bai kundi riri were ridzatsukula mataa na zhenje na silaha. ");
INSERT INTO nyf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesu were anagamanya kare gago gandigohendeka kwakwe. Bai akiasongerera na akiuza, “Munamumala h'ani?” ");
INSERT INTO nyf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Makimudzigidzya makiamba, “Hunamumala Jesu wa Nazareth'i.” Akiamba, “Ni mimi!” Bai Juda, musaliti were a hamwenga nao o at'u. ");
INSERT INTO nyf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","O at'u marihosikira Jesu akiamba, “Ni mimi,” makiuya na nyuma na makigwa. ");
INSERT INTO nyf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Akiuza kaheri akiamba, “Munamumala h'ani?” Makiamba, “Hunamumala Jesu wa Nazareth'i.” ");
INSERT INTO nyf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesu akiamba, “Nidzamwambira kare kukala ni mimi. Vikara kwa kukala munimalaye ni mimi, aricheni aa anafundzi angu mende.” ");
INSERT INTO nyf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesu wanena vivi kwamba Maoro gathimire kukala, “O urionip'a singamizire hatha mumwenga.” ");
INSERT INTO nyf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni P'et'ero were ana mushu. Akiwamboza chowani mwakwe na akimutosa sikiro ra kurya ye muhumiki wa Mulombi mubomu mwenye. Muhumiki yuyu dzinare were ni Maliko. ");
INSERT INTO nyf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ela Jesu akimwambira P'et'ero, akiamba, “Wudzye chowani mwakwe wo mushuwo. Baba adzanip'a kikombe kiki cha dhiki, vidze nisikinwe?” ");
INSERT INTO nyf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Gonya yuyahu kilongozi mubomu wa o shikari akiambira o shikarie hamwenga na o arindzi a Hekalu mamugwire Jesu. Nao makimugwira makimufunga. ");
INSERT INTO nyf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Gonya makimuhirika kwa Anasi. Anasi were ni mutsedza wa Kayafa ariyekala ndiye Mulombi mubomu mwenye mwaka uwo. ");
INSERT INTO nyf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa yuyu ndiye mut'u aremboza ojo kahi za mashauri ga Ayahudi kwamba vinav̱irya mut'u mumwenga afwe kwa ut'u wa anji. ");
INSERT INTO nyf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Bai Simoni P'et'ero hamwenga na mwanafundzi mwandziwe makimuthuwa Jesu. Mwanafundzi yuyu mungine were manamanyana na ye Mulombi mubomu, kwa vizho iye achangira hamwenga na Jesu ho muhalani ha ye Mulombi mubomu mwenye. ");
INSERT INTO nyf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ela P'et'ero k'afikire ho muhalani, waima ko ndze muv̱iryani. Ndo yuyahu mwanafundzi mungine ariyekala anamanyana na ye Mulombi mubomu mwenye arihomona P'et'ero aimire ndze, wamuuyira na akidzanena na musichana ariyekala zamu ho muv̱iryani. Bai ndizho P'et'ero naye akiruhusiwa kwangira ho muhalani. ");
INSERT INTO nyf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yuyahu musichana akimulolat'o P'et'ero na akimwamba, “We k'umumwenga wa anafundzi a Jesu bule?” Ela P'et'ero akiamba, “Hatha si mwanafundzi wa mut'u yuyahu mino.” ");
INSERT INTO nyf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Bai ahumiki angine na arindzi were madzaasha makala na maimire haho kuoha wo moho, kwa kukala were kuna p'eho. P'et'ero naye akiima hehi nawo akioha. ");
INSERT INTO nyf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bai yuyahu Mulombi mubomu mwenye akimuza-muza Jesu maswali dzulu za mafundishoge na dzulu za anafundzie. ");
INSERT INTO nyf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesu akimudzigidzya akimwamba, “Mimi nidzakala nikiafundisha at'u kila wakathi lwazu-lwazu. Nafundisha kila wakathi kahi za hat'u ambaho Ayahudi ehu kwa kawaida ni kuthunganana hasa kahi za masinagogi na kahi za mihala ya ro Hekalu. Sidzangwe kufundisha at'u kisiri. ");
INSERT INTO nyf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kwanoni unanuza mimi? Kala unamala umanye mafundisho nifundishago, auze ao marionisikira. Ao ndo mamanyao mafundisho gangu.” ");
INSERT INTO nyf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesu arihogonya kunena vivi, mumwenga wa o arindzi ariyekala aimire hehi naye wamwangiza mbalahi ya usoni, akimudumulira akiamba, “Zho ndo at'u mamudzigidzyazho Mulombi mubomu mwenye?” ");
INSERT INTO nyf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesu akimwamba, “Kala dzanena neno rii, nambira, ni hiro. Ela kala sinenere rii, bai udzanipigirani?” ");
INSERT INTO nyf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Gonya ndo Anasi akimuhirika Jesu kwa ye Kayafa, Mulombi mubomu mwenye kuno adzafungwa. ");
INSERT INTO nyf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ela iye Simoni P'et'ero were achere anaoha moho. Bai at'u makimuza makiamba, “We k'umumwenga wa anafundzi a yuya mut'u?” P'et'ero akikanaiza akiamba, “Hatha!” ");
INSERT INTO nyf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Gonya mut'u mungine akinena. Naye were ni muhumiki wa ye Mulombi mubomu mwenye. Mut'u yuyu were ana umanyi wa hehi na yuyahu mut'u ariyetoswa sikiro ni P'et'ero. Akimuza naye, akiamba, “We sikonere hamwenga na Jesu kurya chungani?” ");
INSERT INTO nyf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ndo P'et'ero akikanaiza kaheri na haho henye jogolo rikiika. ");
INSERT INTO nyf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kidza dzuwa ririhokala ridzaandza kwombola makimuhala Jesu kula kahi za nyumba ya Kayafa hatha ko nyumbani kwa luwali P'ilato. O Ayahudi k'amangirire bule mo nyumbani kwa kugoha masidzangize nyenye, sidze makakosa kurya P'asaka. ");
INSERT INTO nyf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ndo P'ilato achambola mo nyumbani akiathuwa ho marihokala akiauza akiamba, “Vidze ni ut'u wani hasa uwi ambawo munaamba wauhenda?” ");
INSERT INTO nyf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ao Ayahudi makidzigidzya makiamba, “Kala mut'u yuyu k'ahendere uwi k'ahungamurehere kwako!” ");
INSERT INTO nyf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","P'ilato akiadzigidzya akiamba, “Muhaleni enye mumuhukumu kuthuwirizana na sheria yenu.” Ela aryahu Ayahudi makikahala makiamba, “K'ahuna amulo ra kulagiza mut'u alagwe.” ");
INSERT INTO nyf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Vivi zhahendeka ili neno arirokala Jesu warinena dzulu za andizhofwa ripate kuthimira. ");
INSERT INTO nyf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kidza P'ilato achangira kaheri mo nyumbani mwakwe. Akimwiha Jesu akimuza akiamba, “Vidze we ndiwe muthawali wa Ayahudi?” ");
INSERT INTO nyf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu akimudzigidzya akiamba, “Unauza swali riri kitswacho hedu unanena kwa kukala udzambirwa ni at'u vizho?” ");
INSERT INTO nyf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","P'ilato akidzigidzya akiamba, “Unaona kukala ni Muyahudi mino? Ni o alombi abomu, na o at'u akwenu ndo madziokureha kwangu.” ");
INSERT INTO nyf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesu akidzigidzya akiamba, “Uthawali wangu si wa urumwengu uu. Kalaho uthawali wangu ni wa urumwengu uu, at'u angu, kwa hakika ngere madzaheha na aryahu Ayahudi ili masinigwire. Ela bai uthawali wangu si wa urumwengu.” ");
INSERT INTO nyf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kidza P'ilato akimuza akiamba, “Kwa vizho u muthawali uwe?” Jesu akiamba, “Uwe ndiwe uriye unaamba kukala ni muthawali. Mut'u mimi nakudza urumwenguni na nikizhalwa kwamba nifundishe ujeri. Kila mut'u adzekusudhia kumanya na kuthuwa ujeri, andanisikira.” ");
INSERT INTO nyf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","P'ilato akiuza akiamba, “Ujeri ni noni?” Arihogonya kunena vizho, achambola ndze, achenda kwa o Ayahudi mariokala madzamushithaki Jesu akiamba, “Mut'u yuyu simona na kosa! ");
INSERT INTO nyf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ela ni adha renu wakathi uu wa sikuk'uu yenu ya P'asaka humuvugulire mufungwa mumwenga yoyosi mundiyeamba. Vidze munahendza nimuvulire yuno muthawali wa Ayahudi?” ");
INSERT INTO nyf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ela o Ayahudi makipiga londzo na kuamba, “Si mut'u yuyu, k'ahuna v̱ata naye, hat'u ha yuyu muvugule Baraba!” Yuyahu Baraba were ni jambazi. ");
INSERT INTO nyf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Gonya P'ilato akilagiza Jesu apigwe vikotho. ");
INSERT INTO nyf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kidza ao shikari, makitengeza kiremba cha miya na makimuvika Jesu kitswani. Kidza makihala riguwo ra rangi ya zambarau makimuvika. ");
INSERT INTO nyf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Na makiamba, “K'una ut'u muheshimiwa muthawali wa Ayahudi?” Na makimupiga makofi. ");
INSERT INTO nyf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","P'ilato achambola mo nyumbani kaheri na akiambira o Ayahudi akiamba, “Nindamwambozera haha ndze yuyu mut'u, mumanye kukala siona kukala adzahenda kihendo kii chochosi.” ");
INSERT INTO nyf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Bai Jesu achambola ndze kuno adzavala kirembache cha miya na riguwo ra zambarau. Gonya P'ilato akiambira o at'u, “H'aya thiyuno!” ");
INSERT INTO nyf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bai o alombi abomu na arindzi ao marihomona Jesu, mapiga k'ululu na kuamba, “Musulubishe! Musulubishe!” P'ilato akiadzigidzya akiamba, “Muhaleni enye, mumusulubishe. Kwani mino simona na kosa rorosi.” ");
INSERT INTO nyf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aryahu Ayahudi makimujibu makiamba, “Siswi huna sheria, na kulingana na sheria iyo vinav̱irya afwe, kwa kukala wadziamba ni Mwana wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bai P'ilato arihosikira maneno gaga, wakaza kungirwa ni woga zaidhi. ");
INSERT INTO nyf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kidza achangira kaheri mo nyumbani mwakwe, hamwenga na Jesu. Gonya akimuza akiamba, “Kwenu ni hiko we?” Ela Jesu akinyamala zii. ");
INSERT INTO nyf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ndo, P'ilato akimuza akiamba, “Mbona k'unidzigidzya? Unamanya mino nina wadimi wa kukuricha huru hedu kukusulubisha?” ");
INSERT INTO nyf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesu akimudzigidzya akiamba, “K'ungere na wadimi wa kuhenda kit'u chochosi kwangu, kala kup'ewerwe wadimi uwo kula dzulu mulunguni. Kwa vizho ye mut'u adziyenireha kwako adzahenda dambi bomu kuriko uwe.” ");
INSERT INTO nyf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Neno riri ra Jesu ramuhendya P'ilato alole ngira yoyosi ya kumuricha Jesu huru. Ela aryahu Ayahudi makipiga londzo kudzigidzya, “Ukimuruhusu mut'u yuyu akale huru be hundamanya kukala k'u musena wa Kaisari. Unamanya kukala mut'u akidziamba ni muthawali haha, be a kinyume cha Kaisari.” ");
INSERT INTO nyf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","P'ilato arihosikira vizho akimwamboza Jesu ko ndze kaheri. Kidza akikelesi kahi za kihiche cha hukumu kiricho were ki hat'u haifwaho Muhala wa Mawe ambaho kwa luga ya Kieburania hanaifwa Gabath'a. ");
INSERT INTO nyf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Siku ii were ni siku ya Kuthayarishira P'asaka, saa here sitha vivi. P'ilato akiambira o Ayahudi akiamba, “H'aya Muthawali wenu siye!” ");
INSERT INTO nyf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ela ao makipiga k'ululu makiamba, “Muse! Muse! Musulubishe!” P'ilato akiauza akiamba, “Vidze munamala nimusulubishe muthawali wenu?” O alombi abomu makimudzigidzya makiamba, “Siswi k'ahuna muthawali mungine isihokala Kaisari.” ");
INSERT INTO nyf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kidza P'ilato akimulazha Jesu kwao mamusulubishe. ");
INSERT INTO nyf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Bai makimuhala Jesu na machenda naye kuno adzatsukula musalabawe muhaka hat'u haifwaho Ribeshe ra Kitswa hedu kwa Kieburania Gologoth'a. ");
INSERT INTO nyf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Haho makimusulubisha hamwenga na at'u angine airi, mumwenga kuku na mungine kuku, na Jesu akikala a ho kahikahi yao. ");
INSERT INTO nyf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kabila ya vivi P'ilato were adzalagiza kukala maore kibao. Kidza akilagiza kwamba cho kibao makilunganye na wo musalaba na kukiora vivi: Jesu Wa Nazareth'i, Muthawali Wa Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Haryahu hat'u marihokala mamusulubisha Jesu were ni hehi na wo mudzi. Ndosa Ayahudi anji makishoma cho kibao, nacho chere chaorwa kahi za luga ya Kieburania na ya Kiyunani na ya Kilatini. ");
INSERT INTO nyf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kidza aryahu alombi abomu a Kiyahudi makimwamba P'ilato, “Usiore ‘Muthawali wa Ayahudi,’ ela ora kukala yuyu mut'u wadziamba, ‘Mimi ni Muthawali wa Ayahudi.’ ” ");
INSERT INTO nyf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ela P'ilato akiamba, “Vizho nidzizhondhika ni vizho.” ");
INSERT INTO nyf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Shikari aryahu marihogonya kumusulubisha Jesu magazha mavwaloge kahi za mafungu mane, ili kila shikari apate fungu. Ela k'amatharurire valore ra ndani bule. Riryahu valo ra ndani rere k'arigwizanyirwe na ringine mana rere rashonwa rere mwenga. ");
INSERT INTO nyf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ndosa shikari makiambirana, “Nahusiritharure, hat'uhe nahuripigire k'ura hulole chamba rindahalwa ni h'ani.” Vivi virihokala zhathimiza garyahu Maoro gaambago, “Magazha nguwo zangu na valo rangu ra ndani makiripigira k'ura.” ");
INSERT INTO nyf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bai vizho ndizho marizhohenda o shikari. Hehi na ho musalabani were haimire mameye Jesu na nduguye iye mameye na Maryamu mukaza Kilopa, na Maryamu Magidalena. ");
INSERT INTO nyf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kidza Jesu arihomona mameye na ye mwanafundzi ariyemuhendza aimire hehi, akimwamba mameye, “M'ama, lola yuyu vikara nde mwanao” ");
INSERT INTO nyf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Gonya akimwambira yuyahu mwanafundzi akiamba, “Vikara yuyu nde mameyo” Bai yuyahu mwanafundzi bada ya vivi akimuhala ye Maryamu mameye Jesu na achenda naye mudzini kwakwe. ");
INSERT INTO nyf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Badaye Jesu kuno akimanya kukala adzagonya kaziye yosi, akiamba, “Nina k'ihu” Bai Maoro gakithimira. ");
INSERT INTO nyf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na haho were hana kiya kithele siki. Bai makihala buwa makirivika mo sikini, gonya makimugolozeza Jesu anyunye. ");
INSERT INTO nyf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Bai Jesu akinyunya ro siki, na akiamba, “Vidzagoma.” Gonya akizanya kitswache akitoka roho. ");
INSERT INTO nyf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Vikara kwa kukala were ni siku ya kuthayarishira Sabato, o Ayahudi were k'amendzi yo miri isale ho misalabani kahi za yo siku ya Sabato, mana yo Sabato iyo were ni bomu. Bai machendamuvoya P'ilato kukala go magulu ga o asulubiwa gabandwe. ");
INSERT INTO nyf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kwa vizho shikari machendabanda magulu ga yuyahu wa kwandza na ga yuyahu wa hiri, ");
INSERT INTO nyf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ela marihofika kwa Jesu makiona kukala adzagonya kufwa, kwa vizho k'amabandire maguluge. ");
INSERT INTO nyf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ela shikari mumwenga akimudunga fumo ra lwavuni. Bai vichache zhenye milatso na madzi vichambola kula kahi za ro ranga ra lwavuni. ");
INSERT INTO nyf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ye muori wa maut'u gaga waona gakihendeka naye adzanena dzulu ya ut'u uu ili ninwi nanwi mukuluhire. Go arigoganena ni ga ujeri naye anamanya kukala ananena ujeri. ");
INSERT INTO nyf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bai vivi zhathimiza go Maoro gaambago, “K'amandabanda musozawe hatha mumwenga.” ");
INSERT INTO nyf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na kidza kuna Maoro mangine gaambago, “Mandamulola iye mariyemudunga fumo.” ");
INSERT INTO nyf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bada ya vivi mut'u mumwenga wa mudzi wa Arimath'ea aifwaye Josefu achendamuza P'ilato, kala anadima kuuhala mwiri wa Jesu akauzike. Yuyu Josefu were ni mwanafundzi wa Jesu wa kisiri-siri, kwa kukala were anaagoha o Ayahudi. Bai P'ilato akikubali. Kwa vizho Josefu achendamuhala Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kidza Nikodemu ariyekala ho chaho wamwendera Jesu na usiku wakwenda na marashi manji sana garigo uzihowe were ni here rathili gana mwenga. Marashi gaga were ni mutsanganyiko wa manemane na udhi. ");
INSERT INTO nyf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","O anaalume airi mauhala wo mwiri wa Jesu na makiulinga-linga ts'andza ya kitani na go marashi here adha ra Kiyahudi ra kuthayarisha lufu lukazikwe ririzho. ");
INSERT INTO nyf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Vikara haho Jesu arihosulubiwa were hana munda na kahi za wo munda were hana mbira mbisha ambayo were k'aidzazikwa mut'u. ");
INSERT INTO nyf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bai kwa kukala were ni siku ya Kiyahudi ya Mathayarisho na kwa kukala were yo mbira i hehi, makimwika Jesu mumo. ");
INSERT INTO nyf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Bai siku ya kwandza ya wiki irihofika, Maryamu Magidalena wakwenda ko mbirani arikozikwa Jesu wakathi kurihokala kuchere kimidhimidhi. Arihofika haho, akiona ro iwe ririroikwa ho mulomoni mwa yo mbira ridzauswa. ");
INSERT INTO nyf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Arihoona kukala mwiri wa Jesu k'aumo, akiuya nyuma malo. Na achendamona P'et'ero na yuyahu mwanafundzi ariyehendzwa ni Jesu sana. Akiambira, “Madzamuhala ye Bwana wehu kula mo mbirani! K'ahumanya chamba madzakwendamwika hiko.” ");
INSERT INTO nyf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kidza P'et'ero na yuyahu mwanafundzi mungine makiuka haraka na machenda malo kuko mbirani. ");
INSERT INTO nyf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Osi makot'a malo, ela yuyahu mwanafundzi mungine akimukira P'et'ero. Iye nde ariyefika ho mbirani kimbere. ");
INSERT INTO nyf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Bai akizama na akitsungurira mo mbirani. Akiona zo nguwo za ts'andza haho, ela ye mwenye k'angirire mo mbirani bule. ");
INSERT INTO nyf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Badaye Simoni P'et'ero naye akidza. Achangira mo mbirani haraka na akizona zo nguwo za ts'andza zi haho. ");
INSERT INTO nyf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Iryahu nguwo iriyokala yafungwa Jesu kitswani yere i haho, nayo yere k'aihamwenga na zo nguwo nyingine, ela yere idzakundzwa t'ot'ot'o na idzaikwa k'anda. ");
INSERT INTO nyf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kidza yuyahu mwanafundzi mungine, ariyekala adzafika haho kimbere, wangira mumo na akikuluhira. ");
INSERT INTO nyf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Vikara kufikira wakathi uu o anafundzi were k'amadzangwe kuelewa mana ya go Maoro, kukala Jesu were suthi afufuke. ");
INSERT INTO nyf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Gonya aryahu anafundzi makiuya kwao madzumbani. ");
INSERT INTO nyf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maryamu arihouya ko mbirani waungarara ko ndze, kuno anarira. Bai arihokala anarira, akizama na akitsungurira mo mbirani, ");
INSERT INTO nyf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","na akiona malaika airi. Malaika ao were madzavala nguwo nyaruhe tse. Nao mere makelesi haho harihokala haikwa mwiri wa Jesu. Mumwenga were akelesi haho harihokala kitswa cha Jesu, na ye mungine were akelesi ho harihokala magulu ga Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bai makinena na Maryamu makiamba, “Unarizwa ni noni, m'ama?” Akiadzigidzya, akiamba, “Bwana wangu adzahalwa na simanya chamba madzamwikahi!” ");
INSERT INTO nyf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kugonya kunena vizho, akigaluka. Bai arihogaluka akimona Jesu aimire haho, ela k'amumanyire bule. ");
INSERT INTO nyf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ndo Jesu akinena naye akiamba, “Unarizwa ni noni m'ama? Vidze una mut'u umumalaye?” Kwa kukala Maryamu waona kukala ye mut'u ni mutsundzi wa ho hat'u akimwambira, “Bwana, kala ndiwe udziyemusa nakuvoya unambire ko udzikomwika, ili nimuhale.” ");
INSERT INTO nyf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ndo Jesu akiamba, “Maryamu!” Maryamu arihosikira vizho akinula kitswa akihika Kieburania, “Raboni!” (Raboni manaye ni mwalimu.) ");
INSERT INTO nyf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu akiamba, “Sinigut'e bule, mana sidzangwe kwenda dzulu kwa Baba. Uwe, enda kwa o ndugu zangu ukaambire vivi, ‘Mimi ni hehi na kuuya kwa Baba ariye nanwi ni Babiyenu, ninauya kwa Mulungu, ariye nanwi ni Mulungu wenu.’ ” ");
INSERT INTO nyf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Bai Maryamu Magidalena achendaambira o anafundzi, akiamba, “Nidzamona Bwana benwi!” Gonya akiathalira zho arizhokala Bwana adzaamba. ");
INSERT INTO nyf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Siku iyo yenye kurihotswa aryahu anafundzi a Jesu mere madzakundzumanyika hamwenga ndani ya nyumba. Nao mere madzafunga muryango kwa kuaogoha o Ayahudi. Bai haho henye Jesu akiambolera. Akialamusa, akiamba, “Dheri narikale kwenu.” ");
INSERT INTO nyf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bada ya kualamusa akianyesa go magandzage na lo lwavulwe. Bai o anafundzie marihomona Bwana mafwahirwa zhomu. ");
INSERT INTO nyf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Gonya Jesu akiambira kaheri akiamba, “Dheri narikale nanwi. Dza here Baba arizhonihuma, bai nami ninamuhuma.” ");
INSERT INTO nyf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Gonya akiasohera na akiamba, “H'aya hokerani Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mukimusamehe mut'u dambize, bai Mulungu andamusamehe dambize. Musihomusamehe mut'u dambize, bai Mulungu k'andamusamehe mut'u iye dambize.” ");
INSERT INTO nyf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Vikara wakathi Jesu arihoonana na anafundzie T'omasi were k'ahamwenga nao. Yuyu T'omasi were ni mumwenga wa anafundzi kumi na airi a Jesu. Dzinare ringine were anaifwa P'ats'a. ");
INSERT INTO nyf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Badaye aryahu anafundzi angine makimwambira T'omasi, makiamba, “Hudzamona Bwana bewe!” Ela iye akiamba, “Sindakuluhira kamare muhaka mimi mwenye nione go makushu ga misumari mo magandzani na nigagut'e na chala changu, kidza niike gandza rangu dzulu za ro kushu ra lwavuni mwakwe.” ");
INSERT INTO nyf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Bada ya siku nane, anafundzi a Jesu mere madzakundzumanyika kaheri kahi za nyumba iryahu. Wakathi uu T'omasi were a hamwenga nao. Vichache zhenye Jesu akidza akiima mbere zao, ingahokala were madzafunga miryango na ndani. Akialamusa akiamba, “Dheri narikale nanwi.” ");
INSERT INTO nyf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Gonya akimwamba T'omasi, “H'aya lola gano magandza gangu hedu, gut'a hano na chalacho kidza goloza wo mukonowo hedu ugut'e lwavu lwangu. Richa mioyo miri-miri na ukuluhire.” ");
INSERT INTO nyf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Bai T'omasi akiamba, “Bwana wangu na Mulungu wangu!” ");
INSERT INTO nyf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesu akimwamba, “Udzakuluhira kwa kukala udzanona, ela baha at'u aryahu makuluhirao hasiho kuona.” ");
INSERT INTO nyf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Vikara Jesu wahenda miujiza minji mingine mbere za anafundzie ambayo siihadzire kahi za chuwo kiki. ");
INSERT INTO nyf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ela nidzaora dzulu ya miujiza ii michache kwamba mudime kukuluhira kukala Jesu nde iye Masihi, Mwana wa Mulungu na kwa kukuluhira, mukale na uzima wa kare na kare kahi za dzinare. ");
INSERT INTO nyf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Badaye Jesu waambolera anafundzie kaheri kahi za ziya ra Tiberia. Nazho zhakala kivivi: ");
INSERT INTO nyf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni P'et'ero, na T'omasi ambaye dzina ringine waifwa P'ats'a, na Nath'anieli ariye kwao were ni K'ana ya Galilaya, na ana a Zebedayo na anafundzi airi angine, were ma hamwenga. ");
INSERT INTO nyf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ndo Simoni P'et'ero akiambira o andziye akiamba, “Nenda nikavuhe makumba.” Aryahu angine nao makiamba, “Hunakuthuwa.” Kwa vizho machangira dauni. Were ni usiku ho marihokwendavuha makumba. Makichesa kuvuha makumba, ela k'amagwirire kit'u. ");
INSERT INTO nyf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kurihokala kunang'ala-ng'ala, Jesu waima ko ngokani, ela anafundzi k'amamanyire kukala ni Jesu. ");
INSERT INTO nyf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesu akiluta mumiro akiamba, “Anangu, muna makumba ko?” Makidzigidzya, “Ii hatha!” ");
INSERT INTO nyf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ndo Jesu akiambira, “Tsuhani kimia chenu mukono wa kurya wa ro dau na mundagwira makumba kuko.” Ndo makitsuha cho kimia mukono wa kurya wa dau. Bai makumba manji gachangira mo kimiani na gakigwirwa hatha k'amadimire kukivuha cho kimia na kuchangiza mo dauni kwa go makumba manji! ");
INSERT INTO nyf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","8","Bai yuyahu mwanafundzi ariyehendzwa ni Jesu arihoona kit'u kicho, akimwamba P'et'ero, “Yuyahu ni Bwana bewe.” Bai Simoni arihosikira maneno gago, akidzifunga yo nguwoye ya ndze mo chununi, kwani were adzaivula. Bai P'et'ero akidzitsuha mo madzini, ela aryahu anafundzi angine makidza na ro dau, kwani were k'amakure na yo ts'i furufu, kula ho marihokala na ko ts'i furufu were ni here ure wa mikono gana. Bai o anafundzi were manakivuha cho kimia kidzichodzala makumba na ro dau. ");
INSERT INTO nyf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","K'uzhona zho marihofika k'anda-k'anda ya ro ziya makiona moho wa makala na makumba garokala ganakanjwa, na ho k'anda were hana mikahe. ");
INSERT INTO nyf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ndo Jesu akiambira, “Nireherani sehemu ya go makumba murigo mula kugwirani hedu.” ");
INSERT INTO nyf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Bai Simoni P'et'ero akikivuha cho kimia muhaka ko k'anda-k'anda ya ziya. Cho kimia were kithele mikumba mibomu-mibomu, gana na mirongo mitsano na mihahu; na ingahokala were ni minji namuna iyo cho kimia k'akitharukire bule. ");
INSERT INTO nyf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Gonya Jesu akiambira, “Ndzoni mufungule hano.” Na k'ahana hatha mumwenga kahi za o anafundzi ariyethatha kumwamba, “We u h'ani,” kwani mamanya kukala iye ni Bwana. ");
INSERT INTO nyf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Bai Jesu achenda ho mohoni, akihala yo mikahe akiap'a, gonya akihala makumba nago akiap'a. ");
INSERT INTO nyf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ii were ni k'ana ya hahu ya Jesu kuambolera anafundzie bada ya kufufukakwe. ");
INSERT INTO nyf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Marihogonya kufungula, Jesu akierekeza manenoge kwa P'et'ero kuamba, “Simoni mwana wa Johana, vidze unanihendza kuriko aa?” P'et'ero akiamba, “Ee Bwana! Unamanya kukala ninakuhendza.” Kidza Jesu akiamba, “Be risa anang'ondzi angu.” ");
INSERT INTO nyf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kidza Jesu akimuza lwa hiri, akiamba, “Simoni mwana wa Johana, vidze unanihendza?” Akidzigidzya akiamba, “Ee Bwana, unamanya kukala ninakuhendza.” Jesu akiamba lwa hiri, “Bai tsundza anang'ondzi angu.” ");
INSERT INTO nyf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Gonya Jesu akimuza lwa hahu akiamba, “Simoni mwana wa Johana, unanihendza?” Bai achangirwa ni kigondzi kwa kukala adzauzwa ni Jesu lwa hahu kala anamuhendza. Bai akiamba, “Bwana uwe, unamanya kila kit'u. Unamanya kukala ninakuhendza” Gonya Jesu akiamba, “Bai risa ng'ondzi zangu.” ");
INSERT INTO nyf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Gonya Jesu achangeza akiamba, “Ninakwambira ujeri wenye urihokala u muthana, were ukafunga ukanda mwenye na ukenda uhendzako. Ela nakwambira kukala undihothumika undagoloza mikonoyo na uhende kufungwa ukanda ni at'u na makuhirike kut'u uriko kw'endzi kwenda.” ");
INSERT INTO nyf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesu wanena vivi kunyesa kifwa cha P'et'ero kindizhokala na kindizhoreha nguma kwa Mulungu. Gonya akimwambira P'et'ero, “Nithuwa hedu.” ");
INSERT INTO nyf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","P'et'ero akigaluka na akimona yuyahu mwanafundzi ariyehendzwa ni Jesu anaathuwa. Mwanafundzi yuyu ni yuyahu ariyekala hehi na Jesu marihokala manarya chakurya kabila kufwakwe na kidza nde ariyemuza Jesu akiamba, “Ni h'ani andiyekusaliti Bwana?” ");
INSERT INTO nyf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","P'et'ero arihomona mwanafundzi yuyahu akimwamba Jesu, “H'e yuno ye Bwana?” ");
INSERT INTO nyf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesu akimudzigidzya akiamba, “Kala ninamala akale moyo hatha nindihouya kaheri, vidze zho vinakuhusu noni? Uwe h'e nithuwa.” ");
INSERT INTO nyf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Badaye, zhavuma kahi za o ndugu kukala yuyahu mwanafundzi k'andafwa bule. Ela Jesu k'amwambire kukala k'andafwa, ela waamba, “Kala ninamala akale moyo hatha nindihouya kaheri, vidze zho vinakuhusu noni?” ");
INSERT INTO nyf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yuyu mwanafundzi ahadzwaye nde iye ariyenena dzulu ya gaga gosi garigohendeka. Na kidza ndeye ariyegaora maut'u gaga na hunamanya kukala zho arizhonena ni ujeri. ");
INSERT INTO nyf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Bai kuna maut'u mangine manji garigonenwa ni Jesu. Kala vinadimikika kukala at'u maore kila kimwenga arichokihenda Jesu, naona kukala yo dhunia ndzima k'aingakalire na nafasi ya kuthosha ya kuika zho zhuwo vingazhoorwa.");
INSERT INTO nyf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kwa muheshimiwa Th'eofilo. Kahi za kiryahu chuwo changu cha kwandza naora dzulu za go maut'u gosi arigogahenda Jesu na arigogafundisha hangu mwandzo, ");
INSERT INTO nyf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","muhaka arihohalwa achenda mulunguni. Naye kabila k'adzangwe kuhalwa kwenda mulunguni, waap'a malagizo kwa nguvu za Roho Mweri o ahumwie ariokala waatsagula. ");
INSERT INTO nyf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Bai bada ya kufwakwe, wadzionyesa lwazu kwa at'u aa k'ana nyinji zenye, kwa muda wa siku mirongo mine kunyesa kukala wafufuka jeri. Naye lola waonewa ni o at'u ao na akinena nao dzulu za wo uthawali wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bai siku mwenga Jesu arihokala a hamwenga nao, waalagiza akiambira vivi, “At'u ninwi samboleni bule mumu Jerusalemu, ela kalani mumu mutharize yo zawadi ya Roho Mweri iriyolagwa ni ye Baba, ambayo mwaisikira nikiihadza-hadza. ");
INSERT INTO nyf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kwani Johana wabat'iza at'u kwa madzi, ela k'avindatoa bule ninwi mundabat'izwa kwa Roho Mweri.” ");
INSERT INTO nyf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Vikara o ahumwi marihothunganana hamwenga na Jesu, mamuza makiamba, “Vidze Bwana, vino ndo undawudzya uthawali kwa Aiziraeli hedu?” ");
INSERT INTO nyf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesu akiadzigidzya akiamba, “At'u ninwi si kazi yenu kumanya makathi, hedu hatha siku arizozika Baba kwa wadimiwe here arizhoona mwenye. ");
INSERT INTO nyf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ela bai haho Roho Mweri andihomudzirira dzulu zenu, be mundahokera nguvu, nanwi mundakala mashahidhi angu haha Jerusalemu, na Judea yosi na Samaria na hatha kahi za urumwengu muzima.” ");
INSERT INTO nyf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Naye arihotosa kunena gaga, akinulwa kwenda dzulu kuno manalola na gonya akifinikirwa ni ingu nao k'amadimire kumona kaheri. ");
INSERT INTO nyf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bai marihokala machere kukodola matso kulola ko dzulu mulunguni arikokala Jesu anenda, lola hambola anaalume airi mariokala madzavala nguwo nyaruhe tse, nao makiima hehi na o anafundzi a Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bai aa at'u airi makiamba, “H'enwi at'u a Galilaya, mbona muthii haha kulola ko dzulu mulunguni? H'aya bai Jesu yuyu mwenye adziyeuswa mbere zenu na kwenda mulunguni, be andauya dza vizho zhenye mudzizhomona anenda.” ");
INSERT INTO nyf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ndo makiuya ko Jerusalemu kula ko murima uifwao Murima wa Mizeituni. Na kula kuko muhaka Jerusalemu were ni here kilomita mwenga vivi. ");
INSERT INTO nyf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","K'uzhona zho, marihofika makikwera kahi za cho chumba cha gorofani ambamo ndo marimokala makikala. Bai ao mariokwendangira kahi za chumba kicho were ni, P'et'ero, na Johana, na Jakobu, na Anderea, na Filipu na T'omasi, Bath'olomayo na Math'ayo, Jakobu mwana wa Alifayo na Simoni Muhehezi, na Juda mwana wa Jakobu. ");
INSERT INTO nyf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","At'u aa makala na umwenga, kahi za kuvoya kwa chadi kwenda-kwenda, nao were ma hamwenga na o anaache ambao mumwenga wao ni Maryamu mameye Jesu, na nduguze Jesu a kilume. ");
INSERT INTO nyf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Bai bada ya siku mbiri t'ahu, P'et'ero waungarara mbere za o at'u mariomukuluhira Jesu. Na ao mariokala haho were manafika gana na mirongo miri. ");
INSERT INTO nyf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Bai P'et'ero akiamba, “Ndugu zangu, go Maoro were k'agana budhi kuthimira. Kahi za go Maoro, ye Roho Mweri wanena kukirira na kanwa ka Daudi dzulu za Juda ariye nde ariyeahirika o at'u kwendamugwira Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Juda watsagulwa kahi za uhumiki uu, kwa vizho were ni mumwenga wehu.” ");
INSERT INTO nyf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Naye Juda akigula munda na zo p'esa arizorifwa kwa wo uwiwe. Bai akigwa haho na kwa kitswa, akipashuka na go mahumboge gosi gakithuruka. ");
INSERT INTO nyf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kila mut'u mo Jerusalemu wausikira wo uv̱oro uu, kwa vizho makiup'a dzina ra kikwao uryahu munda makiwiha “Akelidama” ambazho manaye ni “Munda wa milatso.”) ");
INSERT INTO nyf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","P'et'ero akienderera kunena akiamba, “Kwani zhaorwa kahi za chuwo cha Zaburi, ‘Makaloge nigakale gandzo; na hasikaleho mut'u yoyosi kuishi mumo bule.’ ” “Na kidza zhaorwa kukala, ‘Nahambole mut'u mungine ahale uimiriziwe.’ ");
INSERT INTO nyf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Kwa vizho ni lazima hupate mut'u andiyedziunga naswi na akale shahidhi wa kufufuka kwa Bwana Jesu. Mut'u yuyu niakale ni mumwenga wa aryahu anaalume ambao madzakala hamwenga naswi kahi za muda wosini ambawo Bwana Jesu wakala hamwenga naswi. Kula wakathi arihobat'izwa ni Johana muhaka wakathi uryahu ambawo Jesu wauswa kwehu na achenda dzulu mulunguni.” ");
INSERT INTO nyf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bai o ahumwi makiika anaalume airi, Josefu ariyeifwa Barisaba (ambaye dzinare ringine were ni Jusito) na Matiasi. ");
INSERT INTO nyf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Gonya makivoya makiamba, “H'ewe Bwana, uwe unamanya moyo wa kila mut'u. H'aya fwanyese kahi za aa at'u airi, ni h'ani udziyemutsagula ");
INSERT INTO nyf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ahale ino nafasi ya kazi ya uhumwi iriyorichwa ni Juda, na achenda ko arikokala anav̱irya kwenda.” ");
INSERT INTO nyf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","K'uzhona zho makipiga k'ura, na yo k'ura ikimugwerera Matiasi. Kwa vizho Matiasi akihala hat'u ha Juda na akikala mumwenga wa o ahumwi kumi na airi. ");
INSERT INTO nyf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bai irihofika siku ya sherehe ya Pentekote, o anafundzi osi mere makundzumanyika hamwenga. ");
INSERT INTO nyf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Na lola haho henye kuchambola londzo kula mulunguni dza here luv̱utho lwa kikukuzi na lukidzadzala yo nyumba yosi marimokala makeresi. ");
INSERT INTO nyf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nao makihenda kuona vit'u vidzizhohalana na ndhimi za moho, nazho zhagazhikana na kila mut'u akithulamwa ni lumwenga. ");
INSERT INTO nyf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nao osi makidzazwa Roho Mweri na makikwatya kunena luga nyingine zenye here ye Roho arizhoadimira kunena. ");
INSERT INTO nyf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Vikara mumo Jerusalemu mwere munaishi Ayahudi mario were manamwogoha Mulungu, na Ayahudi aa mere madzambola kahi za kila ts'i haha dhuniani. ");
INSERT INTO nyf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","K'uzhona bai marihosikira lo londzo lulu, hakundzumanyika kundi bomu ra at'u. Nao were madzamaka jeri-jeri, kwani kila mut'u wasikira yo lugaye yenye inanenwa ni ao mariokala madzadzazwa Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bai kahi za ko kungalala na kumaka kwao, makiamba, “Ano osini manenao samba ni Agalilaya, ");
INSERT INTO nyf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","viandzadze kaheri kila mumwenga wehu anaasikira mananena zo luga zehu zenye? ");
INSERT INTO nyf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mana angine ehu haha ni, Aparithi, Amedi, na Aelamiti. Angine o ni at'u makalao Mesopotamia, Judea, na Kapadokia, P'onito na Asia. ");
INSERT INTO nyf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","H'aya, angine mala Furugia na P'amufulia, Misiri na k'anda za Libia hehi na K'irene na ajeni akumbola Rumi. ");
INSERT INTO nyf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Na angine kaheri ni Ak'irete na Arabu. Na kahi zehu hosi, angine ni Ayahudi na angine si Ayahudi bule, ela mangira dini ya Kiyahudi. Ela ut'u wa kwangalaza nikukala, hosini funaasikira mananena na kufwambira dzulu za maut'u mabomu garigohendwa ni Mulungu!” ");
INSERT INTO nyf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","K'uzhona zho mamaka na machangalala kidza makiuzana-uzana makiamba, “Ut'u uno be manaye ni noni?” ");
INSERT INTO nyf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Angine o makiatsea makiamba, “H'aa, at'u aa madzarea thu.” ");
INSERT INTO nyf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ndo P'et'ero akiungarara hamwenga na aryahu ahumwi kumi na mumwenga na akinena na o at'u kwa sauthi bomu akiamba, “H'enwi Ayahudi andzangu na ninwi nyosini murio munatoa Jerusalemu, nisirikizani hedu nimung'azize ut'u uu. ");
INSERT INTO nyf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kwani at'u aa si kwamba madzarea dza here muonazho, kwandza vivi hatha ni saa t'ahu zenye za madzach'a! ");
INSERT INTO nyf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ela vivi muonazho be ni viryahu virizhonenwa ni nabii Joeli ho kapindi, kukala ");
INSERT INTO nyf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mulungu yunaamba kukala kahi za siku za mwisho nindaadzaza at'u osi Roho wangu. Ana enu a kilume na a kiche mandamboza unabii. Athana enu mandanyeswa maono, na athumia enu a kilume mandaloha ndoso za kimulungu. ");
INSERT INTO nyf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Siku zizo nindaadzaza Roho wangu ahumiki angu a kilume na a kiche, nao mandamboza unabii. ");
INSERT INTO nyf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nindahenda maut'u ga kwangalaza kuku dzulu mulunguni na ko ts'i, kundakala na milatso, na moho, na maingu ga mosi. ");
INSERT INTO nyf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Dzuwa rindagwirwa rikale kiza na mwezi nawo undagwirwa ukale muthune here milatso. Vivi vindakala kabila yo siku bomu ya nguma kufika, na yo siku iyo ni ya Bwana. ");
INSERT INTO nyf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kila mut'u andiyemuririra Bwana Mulungu andaokoka.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Bai P'et'ero akienderera kunena akiamba, “H'enwi Aiziraeli, sirikizani hedu! Ye Jesu wa Nazareth'i be were ni mut'u ariyenyeswa lwazu kwenu kukala watsagulwa ni ye Mulungu mwenye, kukirira na miujiza, na maut'u ga kwangalaza-ngalaza, na miv̱ano ambayo Mulungu waihenda kahi zenu kukirira kwakwe here ninwi enye mumanyazho. ");
INSERT INTO nyf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bai mut'u yuyu walazhwa mikononi mwenu nanwi kwa kuvizwa ni at'u mario ni ai mukimuhala mukimwalaga kwa kumusulubisha kahi za musalaba. Mulungu were anavimanya kare vizho na kidza were wapanga vikale namuna iyo. ");
INSERT INTO nyf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bai Mulungu akimufufula, akimuvugula kula kwa utsungu wa kifwa, mana were k'azhadimikika bule cho kifwa kienderere kumuhendya mufungwa. ");
INSERT INTO nyf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kwani Daudi waamba vivi dzuluze, ‘Ninamanya Bwana Mulungu a hehi nami na ananirinda wakathi wosi, wakathi wa thabu iye nguvuze nikunihendya nikakala salama. ");
INSERT INTO nyf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kwa vizho bai moyo wangu unaererwa na nindapiga njerejere, kidza idzaho ndafwa, ela nina th'amaa, ");
INSERT INTO nyf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","mana uwe Bwana k'undaniricha nikale kuzimu, hedu hatha kumuricha muhumikio mueri aole. ");
INSERT INTO nyf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Uwe wanimanyisa ngira za uzima, nami ninatsamirwa ni uwe kukala hehi nami.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","P'et'ero akienderera kunena akiamba, “Ndugu zangu, ngojani nimwambire hasiho woga dzulu za mukare wehu Daudi, kwamba iye wafwa na akizikwa, na mbiraye i haha hehu hatha haha ninenaho. ");
INSERT INTO nyf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ela hamwenga na vizho iye, were ni nabii naye wamanya kamare kukala Mulungu walaha kukala andaika mumwenga kahi za at'u a lukololwe kahi za kihi cha uthawali dza here iye Daudi arizhokala. ");
INSERT INTO nyf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Naye Daudi kwa kukala were anamanya zho vingazhokala mbereni, akinena kare dzulu za kufufuka kwa ye Masihi, kukala iye k'arichirwe akale ko kuzimu, hedu hatha mwiriwe wenye kuola! ");
INSERT INTO nyf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Bai Mulungu wamufufula yuyu Jesu na hosini bai fu mashahidhi a ut'u uu. ");
INSERT INTO nyf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Naye wanulwa dzulu na akiikwa luhande lwa nguvu, mukono wa kurya wa Mulungu, na akihokera kula kwa ye Baba iye Roho Mweri ariyelagwa kukala andakudza, naye Jesu adzahup'a ut'u uu muwonao na kuusikira. ");
INSERT INTO nyf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kwani ye Daudi mwenye k'endere dzulu mulunguni dza here viryahu arizhokwenda Jesu, ela ko waamba, ‘Bwana Mulungu wamwamba Bwana wangu, “Keresi mukono wangu wa kurya, ");
INSERT INTO nyf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","muhaka mahadhuio niathambaraze kamare ts'ini za magulugo.” ’ ");
INSERT INTO nyf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Kwa vizho bai, Aiziraeli osi ni mamanye kamare kukala yuyu Jesu muriyemusulubisha, be Mulungu wamuhendya akale Bwana kidza akale Masihi!” ");
INSERT INTO nyf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na lola o at'u marihosikira maneno gaga masikira kusha zhomu mo mioyoni mwao hatha makimwambira P'et'ero na ahumwi andziye “Vikara ndugu zehu, fuhendedze be vinoo?” ");
INSERT INTO nyf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","P'et'ero akiadzigidzya akiamba, “Kila mumwenga wenu ni athubu na abat'izwe kahi za dzina ra Jesu Masihi, ili Mulungu amusamehe dambi zenu. Nanwi mundahokera kigerwa cha Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mana yo ahadi ii, ni yenu na ahoho enu na at'u osi mario kure na at'u osini mario ye Bwana Mulungu wehu andaaiha.” ");
INSERT INTO nyf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","P'et'ero waenderera kuhubiri kwa maneno mangine manji na akiaonya zhomu zhenye akiamba, “Dzimanyirireni na kizhazi kiki cha mahendo mai.” ");
INSERT INTO nyf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bai siku iyo o at'u mariogwira maneno ga P'et'ero na kubat'izwa were manafika alifu t'ahu, nao makikala madzangeza murongo wa aryahu at'u mariomukuluhira Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nao at'u ao makala na chadi kahi za kuthuwa go mafundisho ga o ahumwi, na makishirikiana kahi za maut'u manji na makirya mikahe hamwenga, na kumuvoya Mulungu hamwenga. ");
INSERT INTO nyf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na lola miujiza na maut'u ga kwangalaza were ganahendwa ni o ahumwi, ut'u uriwoahenda at'u osi magoshezhwe. ");
INSERT INTO nyf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bai osi mariokuluhira mere makikala hamwenga na kidza were manashirikiana na vit'u zhao zhosi. ");
INSERT INTO nyf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","At'u ao makala makiguza minda yao na vit'u zhao na kugazhizhana zo p'esa marizopata here kila mut'u arizhokala anatsoweka. ");
INSERT INTO nyf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nao kila siku at'u aa maenderera kuthunganana hamwenga kahi za wo muhala wa ro Hekalu. Zhakurya zhao were manavirya hamwenga ko madzumbani, nao were manarya na raha na mioyo myaruhe. ");
INSERT INTO nyf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","At'u ao makala makimulika Mulungu na kuafwahiza at'u osi. K'uzhona zho Bwana akienderera kurongeza ro kundi kila siku kukirira kwa ao mariokala manaokoka. ");
INSERT INTO nyf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Siku mwenga P'et'ero na Johana makala makwendani ko Hekaluni kwa mavoyo ga saa chenda za mutsana. ");
INSERT INTO nyf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Wakathi uwo mwanamulume mumwenga ariyekala wazhalwa kidende were anatsukulwa. Kila siku, at'u were makamuhala na makadzamwika kahi za muv̱irya mumwenga wa ro Hekalu uifwao “Muv̱irya Mudzo,” ili avoye-voye p'esa kula kwa o at'u mangirao mo Hekaluni. ");
INSERT INTO nyf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mut'u yuyu arihoaona o ani P'et'ero manangira mumo Hekaluni, waavoya p'esa. ");
INSERT INTO nyf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Vikara P'et'ero na Johana marihoona vizho makimuthema dzitso ye mut'u, gonya P'et'ero akimwamba, “Hulolet'o hedu!” ");
INSERT INTO nyf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Iye mwanamulume akialola kuno th'amaaye ni kupata chochosi kula kwao. ");
INSERT INTO nyf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ela P'et'ero akiamba, “Mimi sina fedha hedu dhahabu, ela nindakup'a cho niricho nacho vivi kare. H'aya, kahi za dzina ra Jesu Masihi wa Nazareth'i, ungarara wanende!” ");
INSERT INTO nyf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","P'et'ero akimugwira wo mukonowe wa kurya na akimwaviza kuungarara, na lola haho henye zo nyayoze na nguyuze zikipata nguvu. ");
INSERT INTO nyf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Mut'u iye wahenda ngh'o, na akiungarara na akikwatya kwanenda, bai achangira mumo Hekaluni hamwenga nao, kuno ananenda na kuthuluka-thuluka kumulika Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bai o at'u osini marihomona ananenda na kumulika Mulungu, ");
INSERT INTO nyf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mamumanya kukala yuyu nde yuyahu ariyekala akikelesi na kuvoya-voya kahi za wo muv̱irya uifwao “Mudzo.” Bai marihoona vizho mamaka zhomu na machangalazwa ni gago garigokala gadzamukalira. ");
INSERT INTO nyf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Vikara yuyahu mut'u arihokala anaagwira kisena o ani P'et'ero na Johana, o at'u osini mangalala na machenda malo genye muhaka haho marihokala o ani P'et'ero, naho were ni hat'u henye baraza riifwaro “Baraza ra Selemani.” ");
INSERT INTO nyf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bai P'et'ero kuona vizho, akiambira o at'u akiamba, “H'enwi Aiziraeli andzangu, mbona ut'u uno unamumasha? Kwanoni munahulolat'o here kwamba fudzamuhendya yuyu mut'u anende kwa nguvu zehu hedu ueri wehu enye? ");
INSERT INTO nyf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","K'amuona h'e, iye Mulungu wa ani Burahemu, Isaka na Jakobu, na akare ehu angine, bai adzamup'a nguma muhumikiwe Jesu ariye mwamuhala na mukimulazha kwa at'u alagwe na mukimukahala mbere za luwali P'ilato, idzaho iye P'ilato were adzaona baha amuriche huru ende. ");
INSERT INTO nyf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mwamukahala ye mueri na muhachi na mukimwamba P'ilato amuvugulire ye mwalagi. ");
INSERT INTO nyf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kwa vizho mukimwalaga iye ariye nde mwandzo wa uzima, ela ko Mulungu akimufufula. Naswi bai fu mashahidhi a ut'u uu. ");
INSERT INTO nyf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Bai kukirira kwa kuluhiro kahi za dzina ra Jesu, be yuyu mut'u mumonaye na muriyemunamumanya, adzahendwa apate nguvu. Ut'u uu wa kuhozwa kamare kwa mut'u yuyu here muwonazho nyosi na matso, be udzakala kwa dzina ra Jesu na ro kuluhiro ridzaro kukirira kwakwe. ");
INSERT INTO nyf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Vikara ndugu zangu, namanya kukala ninwi na o vilongozi enu mwamuhendera Jesu ut'u uwo kwa kutsamanya. ");
INSERT INTO nyf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ela bai garyahu maut'u arigogahubiri ye Mulungu ho kapindi kukirira na makanwa ga manabii a kwakwe osi, kwamba ye Masihi suthi were apate thabu, bai ye Mulungu wagathimiza kahi za ngira ii. ");
INSERT INTO nyf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kwa vizho bai, thubuni mumuuyire Mulungu, ili afute makosa genu. ");
INSERT INTO nyf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kusudhi gadze makathi ga nguvu za kiroho kula kwa Bwana na ili amuhume Jesu ambaye nde ye Masihi ariye wamutsagulira ninwi ho kapindi. ");
INSERT INTO nyf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Bai iye suthi akale ko mulunguni muhaka ufike uryahu wakathi wa maut'u gosi kuhendywa masha, here Mulungu arizholaga ho kapindi kukirira na manabii a kwakwe aeri. ");
INSERT INTO nyf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mana Musa waamba, ‘Ye Bwana Mulungu wenu andamwanulira nabii dza mimi kula kahi za o at'u enu enye, nanwi bai suthi musikire kila kit'u andichomwambira. ");
INSERT INTO nyf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mut'u yoyosi ariye k'andamusikira nabii yuyu bai andathengwa na o at'u a Mulungu na anongwe-nongwe kamare.’ ");
INSERT INTO nyf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Na jeri wenye, Samueli na manabii angine osi mariomuthangulia na mariomuthuwiriza, manena dzulu za siku zizi hurizo. ");
INSERT INTO nyf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Bai zizo ahadi za Mulungu arizozika kukirira na o manabiie be ni zenu ninwi, na kidza muna muthalo kahi za cho kilagane arichochika ye Mulungu na o akare enu. Iye Mulungu wamwamba Burahemu vivi, ‘Kukirira na lukolo lwa kwako at'u a makabila gosi haha urumwenguni mandahaswa.’ ");
INSERT INTO nyf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ndosa Mulungu arihomutsagula muhumikiwe, wamuhuma kwenu kwandza ili adze amuhase kwa kumugaluza kila mumwenga wenu kula kahi za uwiwe.” ");
INSERT INTO nyf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Vikara P'et'ero na Johana marihokala mananena na o at'u, o alombi na ye murindzi mubomu kahi za ro Hekalu hamwenga na Masadukayo makwenda haho marihokala o airi. ");
INSERT INTO nyf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nao were matsukirwe jeri-jeri. Ut'u uriwoatsukiza ni viryahu zha kukala ao ahumwi were manaafundisha at'u kukala Jesu wafufuka kula kifwani na kwa ut'u uwo bai ao mariofwa mandafufuka. ");
INSERT INTO nyf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kwa vizho makiagwira makiasindikira jela, na kwa kukala were kudzatswa kare, makiaricha mumo hatha kukicha. ");
INSERT INTO nyf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ela anji kahi za aryahu mariosikira go mahubiri ga kwao, makuluhira na yo isabu ya anaalume ichangezeka na ikifika here at'u alifu ts'ano. ");
INSERT INTO nyf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Bai kurihocha, aryahu vilongozi a Kiyahudi, na athumia na alimu a Sheria makala na muthunganano mo Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kahi za ao mariokala haho muthungananoni, were ni Anasi ariye were nde Mulombi mubomu mwenye na Kayafa. Angine mariokala haho ni Johana, Alekizanda na at'u angine mario were ao nao mana lukolo na ye Mulombi mubomu mwenye. ");
INSERT INTO nyf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bai makiahala P'et'ero na Johana makiaika ho kahikahi, gonya makiauza makiamba, “Nwi, ut'u uno mwauhenda kwa nguvu zani na kwa dzina ra h'ani?” ");
INSERT INTO nyf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ndo P'et'ero achambola kudzigidzya kuno adzadzala Roho Mweri, akiamba, “H'enwi vilongozi na athumia! ");
INSERT INTO nyf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Vikikala vivi fudzaifwa haha fudze funenet'o dzulu za kihendo kidzo arichohenderwa ye kidende na hunauzwa chamba waholadze, ");
INSERT INTO nyf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","be ninwi na at'u osini a Iziraeli, manyani vivi: Mwanamulume yuyu aimire mbere zenu akikala k'ana ut'u kamare kukirira na nguvu za dzina ra Jesu Masihi wa Nazareth'i. Jesu yuyu ni yuyahu muriyemusulubisha, ela Mulungu akimufufula. ");
INSERT INTO nyf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iye nde iye ariyehadzwa kahi za chuwo cha Zaburi, kukala, ‘Riro iwe murirorikahala ninwi aaki, ndo iwe bomu ra p'embeni.’ ");
INSERT INTO nyf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wo wokolwi be k'aupatikana kukirira kwa mut'u yoyosi mungine, kwani kahi za urumwengu muzima k'akuna dzina ringine ambaro anadamu magerwa ili siswi fudime kuokoka kukirira kwa riro, hasihokala dzina ra Jesu.” ");
INSERT INTO nyf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bai ro Baraza rosi ririhoasikira P'et'ero na Johana mananena, ramanya kukala at'u ao be k'amana elimu ya thendhe, hatha ni at'u thu. Ut'u uriwoangalaza ni kwamba at'u ao were mananena hasiho woga, ndo makikumbukira kukala makala makikala hamwenga na Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","K'uzhona zho makikosa ra kunena, mana ye mut'u ariyehozwa were aimire haho na P'et'ero na Johana. ");
INSERT INTO nyf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kwa vizho makiambira mahauke vichache, ili kuku nyuma mahende h'ee-h'ee. ");
INSERT INTO nyf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bai marihokala madzauka kuku nyuma makiuzana-uzana na kuamba, “H'aya, at'u alume ano be fundaahendadze? Kwani kila mut'u atoaye mumu Jerusalemu, be anamanya kamare kukala at'u aa mahenda muujiza uriwo u kih'akeye, ut'u uu h'e, k'afudima kuamba k'aukalire. ");
INSERT INTO nyf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ela kuuhenda ut'u uu usikaze kutsamuka-tsamuka, be suthi fuakanye, masinene na mut'u yoyosi dzulu za dzina riri ra Jesu.” ");
INSERT INTO nyf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Marihogonya yo njama yao makiaiha kaheri na makiapiga marufuku masinene hedu hatha kufundisha at'u kwa kuhumira dzina ra Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kusikira vizho P'et'ero na Johana makiadzigidzya makiamba, “H'aya viloleni ninwi chamba virizho karakara ni hizho mbere za Mulungu, ni humusikire ninwi hedu humusikire Mulungu? ");
INSERT INTO nyf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwani at'u siswi k'ahudima kuricha kunena dzulu za gago furigogaona na kugasikira.” ");
INSERT INTO nyf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bai ro Baraza ra athumia rikiagosha-gosha kaheri, gonya rikiambira mahauke mende, kwani majeza kumala chausa cha kuaadhibira, ela k'amapatire, mana o at'u osi were manamulika Mulungu kwa gago garigohendeka. ");
INSERT INTO nyf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Iye mwanamulume ariyehozwa kimiujiza were ana miaka zaidhi ya mirongo mine. ");
INSERT INTO nyf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bai P'et'ero na Johana marihorichizwa, maauyira o andziyao na machendaakup'ulira gosi marigokala madzaambwa ni o alombi abomu na o athumia a Kiyahudi. ");
INSERT INTO nyf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","K'uzhona zho marihosikira vizho makiluta mimiro yao kwa umwenga kumuvoya Mulungu, makiamba, “H'ewe Bwana, uwe waumba dzulu na ts'i na ukiumba bahari, na ukiumba zhosi virizho mumo. ");
INSERT INTO nyf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Uwe vizho wanena kwa kuhumira kanwa ka muhumikio Daudi, ariye ni mukare wehu. Nawe wahenda vizho kukirira kwa Roho Mweri, ukiamba, ‘Kwanoni o at'u mario si Ayahudi magwaga rabusha? Kwanoni o at'u mapanga maut'u garigo k'agana mana? ");
INSERT INTO nyf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Athawali a dhunia madzipanga, na o abomu makithunganana hamwenga, kumuheha Bwana na ye Masihiwe.’ ");
INSERT INTO nyf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Nazho ndizho virizhokala, mana Herode na P'onitio P'ilato mahenda muthunganano na o at'u mario si Ayahudi na o at'u a Iziraeli. Nao mahenda vizho kahi za mudzi uu wa Jerusalemu, kupanga maut'u mai dzulu za Jesu, ariye ni muhumiki wa kwako mueri, uriyemutsagula akale Masihi. ");
INSERT INTO nyf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nao mahenda gago garigo uwe kwa wadimi wa kwako na mahendzogo wagapanga kare kukala nigakale. ");
INSERT INTO nyf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Vikara vivi Bwana, vilole vizho madzizhofwagosha-gosha na uahende o ahumikio madime kunena nenoro hasiho woga wowosi. ");
INSERT INTO nyf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Goloza mukonowo uhoze at'u na uhende maut'u ga kwangalaza na miujiza kukirira kwa dzina ra Jesu, muhumikio mueri.” ");
INSERT INTO nyf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bai marihogonya kuvoya, ho hat'u marihokala madzathunganana hakithukuka na osi makidzazwa Roho Mweri, na makihubiri ro neno ra Mulungu hasiho woga. ");
INSERT INTO nyf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","O at'u osi mariomukuluhira Jesu were mioyo yao na maazo gao ni mamwenga. K'ahana mut'u yoyosi ariyeamba kukala zho vit'u arizho nazho be ni zhakwe h'akeye. Hatha, at'u ao makala makigazhirana zhosi marizhokala nazho. ");
INSERT INTO nyf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nao o ahumwi maenderera kuambira at'u dzulu za kufufuka kwa ye Bwana Jesu. Nao mahenda vivi na nguvu nyinji jeri-jeri na Mulungu akiahasa zhomu osi. ");
INSERT INTO nyf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kahi zao, be were k'ahana mut'u hatha mumwenga ariyekala anatsowa kit'u, kwani ao mariokala mana minda hedu nyumba zenye, mavihala makiviguza na zo p'esa marizopata machenda nazo, ");
INSERT INTO nyf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","machendaap'a o ahumwi, na o ahumwi makigazhizha kila mut'u karakara na utsowiwe. ");
INSERT INTO nyf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mufano wa mut'u ariyehenda kit'u dza kicho, ni mut'u mumwenga aifwaye Josefu. Josefu were ni Mulawi kula Kuporo. O ahumwi were manamwiha Barinaba (mana ya Barinaba ni mut'u ap'aye moyo at'u). ");
INSERT INTO nyf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bai mut'u yuyu naye wahala hat'uhe akihaguza na akihala zo p'esa achendaap'a o ahumwi. ");
INSERT INTO nyf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ela kwereko mwanamulume mumwenga ariyeifwa Anania. Mut'u iye naye hamwenga na muchewe ariyeifwa Safira waguza kisiku cha mundawe. ");
INSERT INTO nyf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Gonya akikubaliana na muchewe kukala ziryahu p'esa marizopata mavule nusu maike, kurya makalazhe nusu, gonya maambe zizo ndo marizopata. Bai makihenda vizho. Makihala zo p'esa makizivula makiika, zo zirizosala, makizihirika ko kwa ahumwi. ");
INSERT INTO nyf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bai Anania arihokwenda na zizo p'esa kwa P'et'ero, P'et'ero akimwamba, “Anania, kwanoni udzamuricha Shethani akawadzala moyowo hatha ukamukenga Roho Mweri na kuhala zo p'esa urizopata kwa kuguza wo munda ukazivula? ");
INSERT INTO nyf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Samba kabila k'udzauguza, wo munda were ni wako? Na hatha urihokala udzauguza, samba zo p'esa were zi mikononi mwako? Kwanoni bai ukaaza kuhenda ut'u dza uno? H'aya bai, uwe k'umukengere mwanadamu, ela udzamukenga Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","K'uzhona zho, Anania arihosikira vizho thu, akigwa kare haho akifwa. Na osi mariosikira gago garigohendeka mangirwa ni woga jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Badaye hakimbola avulana, makimuhala, makimulinga-linga sandza na machenda naye ko ndze, machendamuzika. ");
INSERT INTO nyf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bada ya here masaa mahahu vivi, poo ye muche, naye hatha were k'amanya kudzakalani. ");
INSERT INTO nyf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bai P'et'ero akimuza ye muche akimwamba, “H'aya, nambira, zino ndo p'esa murizopata bada ya kuguza wo munda?” Ye mukaza Anania akidzigidzya akiamba, “Ee, ni zizo.” ");
INSERT INTO nyf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","P'et'ero akimwamba, “Mudzaandzadze nwi kumupima Roho wa Bwana? Sikiza, thio o at'u madziokwendamuzika mulumeo na tha uwe nawe mandakutsukula.” ");
INSERT INTO nyf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na haho henye, akigwa ho mbereze na akifwa. Badaye o avulana makidza mumo na marihomona adzafwa, makimuhala machenda naye ko ndze machendamuzika hehi na ye mulumewe. ");
INSERT INTO nyf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bai kanisa rosi richadzala woga jeri-jeri, na yoyosi mungine ariyesikira ut'u uwo, wamaka sana. ");
INSERT INTO nyf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","O ahumwi mahenda miujiza minji na maut'u manji ga kwangalaza kahi za o at'u. Na o at'u osi mariomukuluhira Jesu makala makithunganana hamwenga kahi za Baraza ra Selemani. ");
INSERT INTO nyf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","K'ahana mut'u yoyosi mungine ariyethatha kudziunga nao, idzaho were manalikwa sana ni o at'u. ");
INSERT INTO nyf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ela hamwenga na vizho ao mariomukuluhira ye Bwana maenderera kwangezeka, ache kwa alume. ");
INSERT INTO nyf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bai kwa ut'u wa iyo miujiza iriyokala ikihendwa ni o ahumwi, at'u anji makwenda na akongo ao vitandani na vitsekani na machendaalaza ho ngirani, ili ngee magutw'e ni cho kivurivuri cha P'et'ero andihokala akukirani. ");
INSERT INTO nyf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na makundi ga at'u kula midzi iriyo hehi na Jerusalemu makudza na akongo ao na makihozwa. Ao mario were manateswa ni p'ep'o nao marefwa, na o p'ep'o osini marioapagaa machambozwa. ");
INSERT INTO nyf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ndo ye Mulombi mubomu mwenye hamwenga na o andziye osi mario were ni anachama a chama cha Masadukayo machangirwa ni wivu jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","K'uzhona zho makiagwira o ahumwi na machendaangiza jela. ");
INSERT INTO nyf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ela usiku uwo kukidza malaika wa Bwana na akidzaivugula yo miryango ya jela na akiamboza ndze. ");
INSERT INTO nyf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ye malaika akiambira o ahumwi vivi, “Endani mukaime kahi za wo muhala wa ro Hekalu na muambire o at'u kila kit'u dzulu za maisha gaga masha!” ");
INSERT INTO nyf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nao madzach'a maitsi genye machenda kahi za wo muhala wa ro Hekalu na makihenda here zho marizhombirwa ni ye malaika zhenye, makikwatya kuafundisha o at'u. Wakathi uwo-uwo vizho ye Mulombi mubomu mwenye na o andziye makiiha muthunganano wa ro Baraza rosi, yani vilongozi osi a Kiyahudi. Bai makihuma at'u mende ko jela makaahale o ahumwi. ");
INSERT INTO nyf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ela o shikari marihofika kuko jela, machendaathekeza k'amamo. K'uzhona zho makiuya machendasema. ");
INSERT INTO nyf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Makiamba, “At'u siswi fudzakwendayona yo jela idzafungwa vizho, na o arindzi maimire ho miryangoni, ela bai fudzihovugula k'afuonere mut'u yoyosi mo ndani.” ");
INSERT INTO nyf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bai ye mubomu wa o arindzi a ro Hekalu na o alombi abomu marihosikira uv̱oro uu, mangalala kuno k'amamanya kala ut'u uwo undarehani. ");
INSERT INTO nyf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","K'avitoere hakidza mut'u mumwenga akiamba, “Lolani! O at'u murioangiza jela dzana, be ma kahi za wo muhala wa ro Hekalu, manafundisha at'u.” ");
INSERT INTO nyf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kusikira vizho ye mubomu wa arindzi a ro Hekalu achenda na o shikarie na machendaahala o ahumwi makidza nao. Ut'u uu mauhenda hasiho kuhumira nguvu, mana were ni aoga na o at'u, p'ore makakotw'a mawe nazho. ");
INSERT INTO nyf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Vikara marihofika nao, makiaika mbere za ro Baraza ili mauzwe-uzwet'o ni ye Mulombi mubomu mwenye. ");
INSERT INTO nyf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","K'uzhona zho ye Mulombi mubomu akiauza akiamba, “Nwi, samba fwamupiga marufuku musifundishe at'u kahi za dzina ra mut'u yuyu? H'aya lolani yo Jerusalemu yosi be mudzaidzaza go mafundisho genu. Kidza munamala kuhuhendya yo milatso ya mut'u yuyahu ikale dzulu yehu!” ");
INSERT INTO nyf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kusikira vizho P'et'ero na o ahumwi angine makiadzigidzya makiamba, “Vidze ni karakara fumusikize Mulungu, hedu fumusikize ninwi anadamu? ");
INSERT INTO nyf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Iye Mulungu wa akare ehu wamufufula Jesu bada ya ninwi kumwalaga kwa kumwanganya kahi za musalaba. ");
INSERT INTO nyf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Bai Mulungu akimwanula na akimwika kahi za mukonowe wa kurya akale muthawali na mwokoli, ili aap'e o Aiziraeli nafasi ya kuthubu na masamehewe dambi zao. ");
INSERT INTO nyf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bai at'u siswi fu mashahidhi a maut'u gaga, na fu mashahidhi hamwenga na ye Roho Mweri naye, ariye Mulungu wamulazha kwa aryahu mamusikirao.” ");
INSERT INTO nyf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wee! Ko kusikira vizho o athumia a Baraza makitsukirwa jeri-jeri, hatha makikala manamala kualaga o ahumwi. ");
INSERT INTO nyf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ela kahi za ro Baraza ra athumia were hana mwanamulume mumwenga aifwaye Gamalieli. Gamalieli were ni Farisayo kidza ni mwalimu wa Sheria ariyekala akiishimiwa ni at'u sana. Bai akiungarara kahikahi za ro Baraza na akilagiza kwamba o ahumwi mambozwe ko ndze vichache. ");
INSERT INTO nyf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gonya akinena na ro Baraza ra athumia akiamba, “H'enwi at'u a Iziraeli, zho mumalazho kuahenda anaalume aa, be baha muviaze kaheri. ");
INSERT INTO nyf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mana ho nyuma-nyuma kwambola Th'euda naye akidziamba kukala ni mut'u mubomu, na here at'u magana mane makimuthuwa. Bai iye akilagwa, na osi mariokala makimuthuwa makitsamuka-tsamuka na vikikala ndo vidzaricha be vizho. ");
INSERT INTO nyf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bada ya iye, kuchambola Juda wa Galilaya. Juda wambola uryahu wakathi marihokala at'u manathalwa, iye naye akithuwiwa ni rikundi ribomu ra at'u, ela naye akilagwa, na osi mariokala makimuthuwa makitsamuka-tsamuka. ");
INSERT INTO nyf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kwa vizho bai, nimalazho kumwambira ni vivi, at'u aa h'e, aricheni na maut'u gao! Ee, arichizeni mende! Mana, kala gaga malengo gao na kazi yao ni zha kibinadamu be k'avindafururiza. ");
INSERT INTO nyf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ela kala ut'u uu ula kwa Mulungu, be k'amundaadima bule aa anaalume. Munadima mukahenda kudzona munaheha hatha na Mulungu.” Bai o athumia a ro Baraza makigwira gago arigokala Gamalieli adzaambira. ");
INSERT INTO nyf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ndo makiaiha o ahumwi mo ndani na makilagiza mapigwe vikotho, gonya makiapiga marufuku kunena kahi za dzina ra Jesu na makiarichiza mende. ");
INSERT INTO nyf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","K'uzhona zho o ahumwi mauka haho kuno mana raha kwa kuonewa kukala madzafika at'u a kuaibishwa kwa ut'u wa ro Dzina ra Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bai kila siku maenderera kuafundisha o at'u na kuhubiri Uv̱oro Udzo dzulu za Jesu kukala nde iye Masihi. ");
INSERT INTO nyf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Vikara kahi za siku zizo, wo murongo wa aryahu anafundzi were unangezeka. Bai o Ayahudi manenao Kiyunani manung'unika dzulu za viryahu marizhokala go magungu gao ganabaguliwa ni o Ayahudi andziyao kahi za maut'u ga kila siku ga kugazha chakurya. ");
INSERT INTO nyf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","K'uzhona zho aryahu ahumwi kumi na airi makiakundzumanya hamwenga o anafundzi, makiamba, “Si vidzo bule siswi huriche neno ra Mulungu na fukwatye kulola maut'u ga chakurya. ");
INSERT INTO nyf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kwa vizho bai ndugu, tsagulani anaalume afungahe kahi zenu mario manamanyikana kukala mathele Roho Mweri na mana akili. At'u aa bai yo kazi iyo fundaap'a ao, ");
INSERT INTO nyf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","sino swi, futhuwe wo wa kuvoya na kuhubiri ro neno ra Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bai ro kundi rosi rikifwahizwa ni gago marigokala o ahumwi madzaamba, kwa vizho makiatsagula aa at'u aa: Sitivini, ariye were ni mut'u ariye na kuluhiro bomu na adziyedzala Roho Mweri. Angine were ni Filipu, Purokoro, Nikanori, T'imoni, P'arimena, na Nikolao ambaye were kwao ni Anitiokia. Mut'u yuyu Nikolao were wangira dini ya Kiyahudi, ela gonya akimukuluhira Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bai ro kundi ra o at'u mariomukuluhira Jesu rikiahala o at'u aa na rikiaika mbere za o ahumwi. Ndo o ahumwi makivoya na makiaikira mikono yao. ");
INSERT INTO nyf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bai ro neno ra Mulungu raenderera kutsamuka kila hat'u. Wo murongo wa ao anafundzi mo Jerusalemu ukingezeka malo-malo na alombi anji enye nao makikuluhira. ");
INSERT INTO nyf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Mulungu wamuhasa zhomu Sitivini na akimugera nguvu, bai akihenda miujiza na maut'u ga kwangalaza kahi za o at'u. ");
INSERT INTO nyf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ela richa hambole at'u makwatye kumupinga. At'u aa were ni ashirika a Sinagogi ra Mahuru (here ririzhokala rinaifwa). Sinagogi riri were rina Ayahudi a kula K'irene na Alekizandiria, na hatha ashirika angine were manambola kahi za majimbo ga Kilikia na Asia. Bai at'u aa makwatya kunenezana na Sitivini, ");
INSERT INTO nyf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ela k'amamwadimire kwa kukala were ananena kwa akili, naye wahenda vivi kwa nguvu za ye Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","K'uzhona zho makiats'ots'era at'u fulani ili maambe vivi, “At'u siswi fwamusikira Sitivini ananena maneno mai dzulu za Musa na kidza ananena kufuru kwa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kwa vizho makiavuga akili o at'u, o athumia a Kiyahudi na o alimu a Sheria. Bai machendamugwira ye Sitivini na makidza naye mbere za ro baraza ra athumia. ");
INSERT INTO nyf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ndo haho makihamboza mashahidhi a ulongo mariomboza ushahidhi na kuamba, “Mut'u yuyu ananena maneno mai dzulu za Hekalu rehu rieri na dzulu za Sheria ya Musa. ");
INSERT INTO nyf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kwani fwamusikira anaamba ati yuyu Jesu wa Nazareth'i andaribanda-banda ro Hekalu na go maadha hurigop'ewa ni Musa andagagaluza.” ");
INSERT INTO nyf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na o at'u osi mariokala makeresi haho mamuthema dzitso ye Sitivini, na makiwona wo usowe u here uso wa malaika. ");
INSERT INTO nyf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Bai ye Mulombi mubomu mwenye akimuza Sitivini akiamba, “Vidze gano udzigoambwa nago ni jeri?” ");
INSERT INTO nyf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitivini akidzigidzya akiamba, “Ndugu zangu na ano baba, nisirikizani hedu! Iye Mulungu wa nguma wamwambolera mukare wehu Burahemu arihokala achere ko Mesopotamia, wakathi uryahu ambawo were k'adzangwe kwendatoa ko Harani. ");
INSERT INTO nyf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Akimwamba, ‘Iriche yo ts'iyo na pia ariche o amanyio na wende kahi za yo ts'i nindiyokwanyesa.’ ");
INSERT INTO nyf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kwa vizho akiyombola yo ts'i ya Akalidayo na achendatoa ko Harani. Bai bada ya kifwa cha babaye, iye Mulungu wamusa Burahemu kula ts'i iyo muhaka ts'i ambayo ndo mutoayo ninwi vikara. ");
INSERT INTO nyf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Naye Mulungu k'amup'ire Burahemu hatha ndhalago mwenga ya yo ts'i ikale yakwe. Ela bai Mulungu akilagana naye kukala andamup'a yo ts'i ikale maliye na ikale mali ya kizhaziche kindichokudza bada ya iye. Bai wakathi uwo Burahemu were k'ana mwana bule. ");
INSERT INTO nyf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ye Mulungu wamwamba Burahemu vivi, ‘Kizhazicho uwe kindakwendatoa kahi za ts'i iriyo si yao nao mandahendywa atumwa na kuhenderwa maut'u mai kwa miaka magana mane. ");
INSERT INTO nyf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ela yo ts'i indiyoahendya atumwa be nindayangiza akili na gonya kicho kizhaziche kindambola kula kahi za ts'i iyo na madze manivoye haha.’ ");
INSERT INTO nyf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Gonya Mulungu akiika kutahira kukale muv̱ano wa cho kilagane arichochika na Burahemu. Bai Burahemu wamuzhala Isaka na akimwangiza lwembeni arihokala adzafisha siku nane. Badaye Isaka wamuzhala Jakobu na akimutahira, na Jakobu akiazhala aryahu ano ts'awe kumi na airi na ao nao akiatahira. ");
INSERT INTO nyf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Bai aryahu ano ts'awe angine mamuonera wivu ndugu yao Josefu hatha makimuguza akakale mutumwa ko Misiri. Ela bai Mulungu wakala hamwenga naye ");
INSERT INTO nyf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","na akimwokola kahi za mashakage gosi. Mulungu akimup'a ulachu ye Josefu na akimuhendya afwahize kwa Farao, Muthawali wa Misiri. Farao akimuhendya Josefu akale luwali kahi za ts'i ya Misiri na kahi za nyumbaye yosi. ");
INSERT INTO nyf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Badaye kukigwa ndzala kahi za Misiri yosi na ts'i ya K'anani. Ndzala ii yareha mashaka mabomu na o akare ehu k'amadimire kupata chakurya. ");
INSERT INTO nyf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Bai Jakobu arihosikira kawee kukala kuna chakurya ko Misiri, waahuma o babizehu charo chao cha kwandza. ");
INSERT INTO nyf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bai marihouya charo cha hiri, ye Josefu wadzimanyisa kwa o nduguze na Farao akimanya dzulu za yo nyumba ya ani Josefu. ");
INSERT INTO nyf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Bada ya maut'u gaga Josefu wahumiza kukala babaye na wo mudzi wosi makambirwe madze. Nao osini were ni at'u mirongo mifungahe na atsano. ");
INSERT INTO nyf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kwa vizho Jakobu achenda Misiri, na kuko ndo iye na o akare ehu marikofwa. ");
INSERT INTO nyf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bai iyo miri yao ikihirikwa ko Shekemu na ichendazikwa kahi za mbira iriyo were yagulwa ni Burahemu kula kwa ana a Hamori kuko. ");
INSERT INTO nyf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kufikira wakathi wa Mulungu kuthimiza kilaganeche na Burahemu, wo murongo wa at'u ehu ko Misiri were udzangezeka jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Bai bada ya muda mure, kukinuka muthawali mungine ko Misiri ariye were k'amanya rorosi dzulu za Josefu. ");
INSERT INTO nyf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Bai muthawali yuyu akihumira ujanja kwa at'u ehu na akiaonera o akare ehu kwa kualazimisha maatsuhe ana ao atsanga mafwe. ");
INSERT INTO nyf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Bai kahi za wakathi uu Musa akizhalwa, nako were ni kahoho kadzo jeri-jeri. Bai warerwa kahi za nyumba ya babaye kwa miezi mihahu. ");
INSERT INTO nyf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Badaye arihokwendaikwa ko ndze, wakwendatsolwa ni musichana wa Farao na akimuhendya mwanawe mwenye. ");
INSERT INTO nyf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bai Musa akifundishwa ulachu wosi wa Amisiri na akikala mut'u mubomu wa kumanya kunena na kuhenda. ");
INSERT INTO nyf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Arihofisha umuri wa miaka mirongo mine akiona baha ende akaatsemberere o Aiziraeli andziye. ");
INSERT INTO nyf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Vikara akiona mumwenga wao anahenderwa ut'u uwi ni Mumisiri, k'uzhona zho achendamuhehera, akimurihiza ye Mumisiri kwa kuhenda kumwalaga. ");
INSERT INTO nyf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Musa waona ao mandaelewa kukala Mulungu anamuhumira kwa ut'u wa kuathizha ao, ela ko k'amaelewerwe bule.) ");
INSERT INTO nyf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","H'aya, siku ya hiriye Musa waambolera Aiziraeli airi mariokala manapigana. Bai akijeza kuathanya. Akiamba, ‘Asena, samba mu ndugu nwi? Mbona munamala kulumizana kaheri?’ ");
INSERT INTO nyf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ela ye ariyekala anamulumiza ye mwandziwe wamusukuma Musa k'anda na akiamba, ‘Ni h'ani ariyekuhendya ukale muthawali wehu na mulamuli wehu? ");
INSERT INTO nyf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Vidze unamala kunalaga dza viryahu urizhomwalaga yuyahu Mumisiri dzana?’ ");
INSERT INTO nyf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa arihosikira maneno gaga, wachimbira achenda ts'i ya Midiani. Kuko wakwendatoa here mujeni na akizhala ana airi a kilume. ");
INSERT INTO nyf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Bai bada ya miaka mirongo mine, Musa wambolerwa ni malaika wa Bwana kuko nyika hehi na Murima wa Sinai. Malaika yuyu wamwambolera kwa mufano wa kitsakuzi kirichokala kinaaka moho. ");
INSERT INTO nyf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kuona vizho Musa wangalala. Bai arihosongera hehi kuvilolat'o, akisikira mumiro wa Bwana ");
INSERT INTO nyf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ukiamba, ‘Mimi ni Mulungu wa akareo, ni Mulungu wa Burahemu, na Isaka, na Jakobu.’ K'uzhona Musa akikwatya kuvinwa ni mwiri kwa woga na k'athathire hatha vichache kukilola cho kitsakuzi. ");
INSERT INTO nyf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Bai ye Bwana akimwamba Musa, ‘Hedu vula zho virahuzho, mana ho hat'u uimireho be ni hat'u haeri. ");
INSERT INTO nyf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Go mateso ga at'u angu ko Misiri nidzagaona. Nidzaasikira kiriro chao nami nidzathima, niathizhe. Vikara ndzo, nindakuhuma ko Misiri.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Sitivini akienderera kunena akiamba, “Musa yuyu ni yuyahu mariyemukahala, na makiamba, ‘Ni h'ani ariyekuhendya muthawali wehu na mulamuli wehu?’ Musa wahumwa ni Mulungu mwenye kukirira na ye malaika ariyemwambolera kwa mufano wa kiryahu kitsakuzi, ili akale kilongozi wao na akale mwokoli wao. ");
INSERT INTO nyf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mut'u yuyu waalongoza akiamboza ndze ya Misiri, akihenda miujiza na maut'u ga kwangalaza kuko Misiri, na ko Bahari ya Shamu na ko nyika akihenda miujiza kwa miaka mirongo mine. ");
INSERT INTO nyf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yuyu nde iye Musa ariyeambira o Aiziraeli akiamba, ‘Mulungu andamwanulira nabii dza mimi kula kahi za o at'u enu enye.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Sitivini akienderera kunena akiamba, “Iye Musa nde ariyekala hamwenga na ro kundi ra Aiziraeli ko nyika, hamwenga na o akare ehu na ye malaika ariyenena naye kahi za Murima wa Sinai. Musa wahokera maneno ga uzima kula kwa Mulungu ili ahuhokeze siswi. ");
INSERT INTO nyf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ela o akare ehu makikahala kumusikira, hat'u ha vizho makimukahala na makikala manamala kuuya ko Misiri. ");
INSERT INTO nyf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kwa vizho makimwamba Haruni, ‘Hutengezere milungu ambayo indahulongoza mo ngirani, mana k'ahumanya go garigomupata yuyu Musa ariyehulongoza akifwamboza ndze ya ts'i ya Misiri!’ ");
INSERT INTO nyf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Bai ni kahi za wakathi uwo ndo marihodzitengezera kizuka chenye muhalano wa kidzao cha ng'ombe. Makichambozera sadaka na makiika sherehe kwa ishima ya zho marizhokala madzavitengeza na yo mikono yao enye. ");
INSERT INTO nyf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bai Mulungu akialozera mongo, akiaricha mavoye zo nyenyezi za mulunguni. Vivi vinagwirana na vizho ambazho zhaorwa kahi za chuwo cha manabii viambazho, ‘Vidze mwanitsindzira nyama na kunambozera sadaka kwa miaka mirongo mine ko nyika, h'enwi Aiziraeli? ");
INSERT INTO nyf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hatha bule, ninwi mwatsukula ro hema ra Moloki na muchanula sanamu ya nyenyezi ya Refani, ambazho were ni vizuka murizhotengeza ili muvivoye. Kwa vizho bai nindamutsanya mwende ts'i iriyo si yenu kukira ts'i ya Babiloni.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sitivini akienderera kunena akiamba, “Kuko nyika ao akare ehu makala na ro hema rironyesa kukala Mulungu anao. Hema riro were ratengezwa here Mulungu arizhokala wamulagiza Musa, kukala aritengeze kulengana na wo muundo ariwokala wawona. ");
INSERT INTO nyf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Bai ao akare ehu marihoripata ro hema, ao hamwenga na Joshua makudza naro wakathi uryahu marihokala madzaihala yo ts'i kula kwa o at'u mario si Ayahudi ambao ye Mulungu waainga mbere zao. Naro hema riro rakala kahi za yo ts'i muhaka wakathi uryahu wa kuthawala Daudi. ");
INSERT INTO nyf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi wamufwahiza Mulungu zhomu hatha akimwamba Mulungu amuruhusu amuakire iye Mulungu wa Jakobu hat'u ha kukala. ");
INSERT INTO nyf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ela k'avikalire bule, kwani mwanawe Selemani nde ariyemuakira nyumba Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Hamwenga na vizho iye Mulungu ariye dzulu ya zhosi be k'atoa kahi za nyumba ziakwazo ni at'u. Nazho ni here zho Mulungu arizhonena kukirira kwa nabii akiamba, ");
INSERT INTO nyf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ko mulunguni ndo kihi changu cha endzi, na hano ts'i ni kihi changu cha kuikira magulu. H'aya mundaniakira nyumba ya samupuli yani benwi? Ho hat'u nindihooya mino ni hiho? ");
INSERT INTO nyf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Samba zhosi vizho navitengeza na mukono wangu?’ ” ");
INSERT INTO nyf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitivini akienderera kunena akiamba, “Aa! At'u musiosikira nwi, mioyo yenu ni miomu na masikiro genu k'agasikira maneno ga Mulungu! Ninwi be mu here o akare enu, siku zosini munamupinga Roho Mweri! ");
INSERT INTO nyf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Vidze hana nabii yoyosi ambaye k'ateserwe ni o akare enu? At'u ao maalaga hatha o at'u ambao were manena kimbere kukala kundakudza ye Muhachi. Na vikara mwamusaliti na mukimukot'a. ");
INSERT INTO nyf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","At'u ninwi mwaihokera yo Sheria ambayo yathinywa kwehu ni malaika, ela ko k'amuigwirire.” ");
INSERT INTO nyf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","O athumia a Baraza kusikira vizho thu, makitsukirwa zhomu hatha makikwatya kwafuna meno. ");
INSERT INTO nyf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ela Sitivini walola ko dzulu mulunguni kuno athele Roho Mweri, na akiona mulangaza wa Mulungu na akimona Jesu aimire mukono wa kurya wa Mulungu, luhande lwa nguvu. ");
INSERT INTO nyf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Akiamba, “Lola ko mulunguni ninakona kudzagunuka na ye Mwana wa Mudamu aimire kahi za mukono wa kurya wa Mulungu!” ");
INSERT INTO nyf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kusikira vizho makigandiza masikiro gao na makimugulukira kuno manapiga k'ululu kwa umwenga. ");
INSERT INTO nyf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bai makimuburutha muhaka ko ndze ya wo mudzi wa Jerusalemu na makikwatya kumukot'a mawe. Wakathi uwo o mariomushithaki mahala maamba gao na makimup'a muvulana mumwenga aifwaye Sauli agatsundze. ");
INSERT INTO nyf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Marihokala makumukot'ani mawe, Sitivini wavoya akiamba, “Bwana Jesu hokera roho rangu.” ");
INSERT INTO nyf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Gonya akipiga mavindi na akinena na mumiro mubomu akiamba, “Bwana, dambi ii usiithale kwao.” Arihogonya kunena vizho akifwa. ");
INSERT INTO nyf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Bai Sitivini arihokala analagwa, Sauli zhamufahiza. Ndo siku iyo ro kanisa ho Jerusalemu rikikwatya kuteswa jeri-jeri. Ao ahumwi h'akiyao ndo mariosala mo Jerusalemu, ela o angine osi matsamuka kila hat'u kahi za jimbo ra Judea na jimbo ra Samaria. ");
INSERT INTO nyf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bai kuchambola at'u mario were manamwogoha Mulungu, makimuhala Sitivini makimuzika. Nao bai mamuririra zhomu sana. ");
INSERT INTO nyf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ela Sauli ye akikala anaralaga ro kanisa. Kwani wangira mo nyumba-nyumba za at'u na kuaburutha at'u, ache kwa alume na kwendaasindikira jela. ");
INSERT INTO nyf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Vikara ao mariokala matsamuka kila hat'u mahubiri ro neno kosini marikokwenda. ");
INSERT INTO nyf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipu watharamuka achenda kahi za mudzi mumwenga ko Samaria na achendaahubiri at'u kuko dzulu za ye Masihi. ");
INSERT INTO nyf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bai go makundi ga at'u garihomusikira Filipu na garihoona go mahendo ga miujiza arigogahenda, be makwatya kugahegera masikiro t'ot'ot'o gago arigokala ananena. ");
INSERT INTO nyf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Lola p'ep'o maambola at'u anji kuno manapiga k'ululu, na at'u anji a kuholoza na vidende mahozwa. ");
INSERT INTO nyf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kwa vizho kahi za mudzi uwo wa Samaria be at'u makala mana raha sana. ");
INSERT INTO nyf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Vikara kwereko muganga mumwenga kahi za mudzi uryahu aifwaye Simoni. Simoni wakala kaziye ni kutengeza uganga kahi za mudzi uwo, naye waamasha at'u osini a Samaria. Simoni were anadzionya na kudziamba kukala ni mut'u mubomu. ");
INSERT INTO nyf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","At'u osini, abomu kwa athithe makala makimusikiza sana na kuamba, “Mut'u yuyu nde iryahu nguvu ya Mulungu iifwayo ‘Nguvu Bomu.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nao mathuwa go gakwe kwa kukala iye were adzaamasha muda mure. ");
INSERT INTO nyf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ela bai at'u a Samaria marihomusikira Filipu anahubiri wo Uv̱oro Udzo dzulu za uthawali wa Mulungu na dzulu za Jesu Masihi, makuluhira na makibat'izwa. Nao mabat'izwa osi, ache kwa alume. ");
INSERT INTO nyf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ye Simoni naye akikuluhira na akibat'izwa. Naye wakala akimuthuwa-thuwa Filipu kila hat'u arihokwenda. Simoni wamashwa ni yo miujiza na maut'u ga kwangalaza arigogaona ganahendwa ni Filipu. ");
INSERT INTO nyf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bai aryahu ahumwi mariokala ko Jerusalemu marihosikira kukala o Asamaria mahokera neno ra Mulungu, mamuhuma P'et'ero na Johana mende kuko. ");
INSERT INTO nyf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bai marihofika kuko, maavoyera ao at'u ili mamuhokere ye Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mana iye Roho Mweri were k'adzangwe bule kumudzirira mut'u yoyosi kahi zao. Ao makala mabat'izwa kwa dzina ra Bwana Jesu thu h'akeye. ");
INSERT INTO nyf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ndo P'et'ero na Johana makiaikira mikono yao na makimuhokera ye Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","K'uzhona zho Simoni arihoona ye Roho Mweri adzalazhwa kwa kuhenda kuikirwa mikono ni o ahumwi, waambozera p'esa na akiamba, ");
INSERT INTO nyf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“K'amuniguziza be wo wadimi, ili nami nikale mut'u yoyosi nindiyemuikira mikono yangu, anahokera Roho Mweri.” ");
INSERT INTO nyf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","P'et'ero akimudzigidzya akiamba, “Uwe na yo p'esayo fwa! Mana unaona unadima ukagula kigerwa cha Mulungu na p'esa t'i. ");
INSERT INTO nyf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Uwe be k'una fungu rorosi hedu muthalo wowosi kahi za ii kazi yehu, kwa kukala wo moyowo be k'aukarakara mbere za Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bai thubu kwa ut'u wa uwio, umuvoye ye Bwana, ili akusamehe kwa kuaza ut'u dza vizho uwo mo moyoni mwako. ");
INSERT INTO nyf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kwani zho nikonazho, be nakona udzadzalwa ni dzitso na udzafungwa ni dambi.” ");
INSERT INTO nyf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni akidzigidzya akiamba, “Nivoyerani Mulungu bai ili nikatsapatwa ni rorosi kahi za garyahu udzigonena.” ");
INSERT INTO nyf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bai P'et'ero na Johana marihogonya kuaonya o at'u na kuhubiri neno ra Bwana, mauya ko Jerusalemu. Nao mo ngirani mahubiri wo Uv̱oro Udzo kahi za vidzidzi vinji zha Samaria. ");
INSERT INTO nyf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bai malaika wa Bwana akimwamba Filipu, “Uka, na wende luhande lwa kwa mwaka muhaka iryahu ngira ambayo kala ula Jerusalemu, be unatharamuka muhaka Gaza.” (Ngira ii k'aikirirwa kaheri.) ");
INSERT INTO nyf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kwa vizho Filipu akikwatya kwenda. Bai lola mumo ngirani akimona mut'u mumwenga kula Ithopia. Mut'u yuyu were k'akola, na kidza were ni mut'u mubomu ariyekala nde mutsundzi wa mali zosi za K'andake ambaye were nde muthawali muche wa Ithopia. Mut'u yuyu wakala adzakwenda Jerusalemu kwendavoya Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wakathi uu yuyu mut'u were anadziuja kwakwe mudzini, kuno adzakelesi dzulu za gari ra kuvufwa ni farasi na anashoma chuwo cha nabii Isaya. ");
INSERT INTO nyf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","K'uzhona zho ye Roho Mweri akimwamba Filipu, “Enda hatha urigwire riryahu gari hedu.” ");
INSERT INTO nyf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ndo Filipu akikot'a malo hatha akirigwira ro gari, arihofika akimusikira ye mut'u anashoma chuwo cha nabii Isaya. Bai akimuza akiamba, “Vidze zho ushomazho vinakueleya kisha?” ");
INSERT INTO nyf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ye mut'u akidzigidzya akiamba, “Vindanieleadze nisihopata mut'u wa kunieleza?” Kwa vizho akimwamba Filipu apande na akelesi naye. ");
INSERT INTO nyf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Haryahu hat'u arihokala anashoma ni haha haambaho vivi, “Iye wakala ni dza here ng'ondzi idziyothongozhwa kwendatsindzwa, naye dza here mwana wa ng'ondzi anyamalazho mbere za iye amunyolaye nyoga, iye naye dzazho, wanyamala. ");
INSERT INTO nyf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kahi za kuaibishwakwe, iye were ni mujeri, ela akipigwa ulongo. K'ahana mut'u andiyedima kunena dzulu za kizhaziche. Mana wo uzimawe k'auho kaheri kahi za ts'i.” ");
INSERT INTO nyf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Bai ye mut'u akimuza Filipu akiamba, “Nambira bai yuno nabii ananena dzulu za h'ani, vidze ananena gaga dzuluze mwenye hedu dzulu za mut'u mungine?” ");
INSERT INTO nyf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ndo Filipu akiandza na cho kifungu kicho na akimwambira ye mut'u wo Uv̱oro Udzo dzulu za Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Vikara marihokala manaenderera na charo chao mo ngirani, mafika hat'u ambaho were hana madzi, bai ye mut'u akiamba, “Lola! Siga madzi. H'aya, kwanoni usinibat'ize?”  ");
INSERT INTO nyf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipu akimudzigidzya akiamba, “Ukikuluhira na moyowo wosi, unadima ukabat'izwa.” Ye mwanamulume akidzigidzya akiamba, “Mut'u mimi, ninakuluhira kukala Jesu Masihi ni Mwana wa Mulungu.” ");
INSERT INTO nyf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Bai akilagiza ro gari riimishwe. Gonya osi airi, makitharamuka mo madzini na Filipu akimubat'iza. ");
INSERT INTO nyf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Badaye marihombuka kula mo madzini haho henye, ye Roho wa Bwana wamuhala Filipu muhaka Azoto. Bai yuyahu Muithopia k'amonere Filipu kaheri, ela waenderera na charoche na raha. ");
INSERT INTO nyf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Vikara Filipu akihenda kudzona a Azoto, naye kuko wakwenda kuno na kuno kuhubiri wo Uv̱oro Udzo kahi za midzi yosi muhaka akifika Kaisaria. ");
INSERT INTO nyf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Bai kahi za wakathi uwo, Sauli were achere anaenderera na uthiririwe wa kuagosha na kuamba andaalaga o anafundzi a Bwana. Mut'u iye wakwenda kwa ye Mulombi mubomu mwenye, ");
INSERT INTO nyf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","na achendamwamba amup'e baruwa za kwenderera kahi za go masinagogi ga Damesiki. Naye lengore were ni akiona mut'u yoyosi kuko ariye anathuwa iryahu Ngira ya Bwana, ni muche ni mulume, amugwire naadze naye Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Vikara kahi za cho charoche akifika hehi na mudzi wa Damesiki. Bai haho henye akihenda kuona m'e, mulangaza kula mulunguni, na ukimupiga kosi-kosi. ");
INSERT INTO nyf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Naye akigwa ho ts'i, kidza akisikira sauthi ikimwamba, “Sauli! Sauli! Mbona unanitesa?” ");
INSERT INTO nyf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli akiuza akiamba, “Ndiwe h'ani kwani we Bwana?” Yo sauthi ikidzigidzya ikiamba, “Ndimi Jesu, yuyahu umutesaye. ");
INSERT INTO nyf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Vikara vivi ungarara na wangire kahi za wo mudzi, nawe kuko undaambirwa viryahu ambazho suthi uvihende.” ");
INSERT INTO nyf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Aryahu at'u mariokala ma charoni na Sauli maungarara haho kuno makanwa ga ngh'aa. Mahenda kusikira yo Sauthi thu, ela k'amaonere mut'u yoyosi. ");
INSERT INTO nyf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Bai Sauli akiungarara, ela arihojeza kuvugula matso na kulola, k'adimire kuona kit'u. Kwa vizho o at'u makihenda kumugwira mukono na makimulongoza kwangira Damesiki. ");
INSERT INTO nyf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Naye wabaki vizho k'aona kwa siku t'ahu, k'arya na k'anwa. ");
INSERT INTO nyf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Vikara ko Damesiki kwere kuna mwanafundzi mumwenga aifwaye Anania. Bai Bwana akinena naye kahi za maono akimwamba, “Anania!” Anania akihika akiamba, “H'ee, thimi Bwana.” ");
INSERT INTO nyf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ye Bwana akimwamba, “Uka wende kahi za ngira iryahu iifwayo ‘Kugoloka’ na ukamale nyumba ya Juda. Ukifika kahi za nyumba iyo, muuzize mut'u aifwaye Sauli wa kula T'ariso, kwani lola be akuvoyani vivi. ");
INSERT INTO nyf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Iye Sauli kahi za maono adzamona mut'u aifwaye Anania adzire na akamwikira mukono ili aone kaheri.” ");
INSERT INTO nyf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","K'uzhona zho Anania akidzigidzya akiamba, “Bwana, mut'u mimi nidzasikira manji sana dzulu za mut'u yuyu, viryahu arizhoahendera nav̱isi o at'u a kwako ko Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Naye haha be adzire kukirira na wadimi ariougerwa ni o alombi abomu ili aagwire osi aryahu makuvoyao uwe.” ");
INSERT INTO nyf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ela ye Bwana akimwamba Anania, “Enda, kwa kukala iye nidzamutsagula akale muhumiki wangu, ili ahirike dzina rangu mbere za at'u mario si Ayahudi na mbere za o athawali ao na mbere za o at'u a Iziraeli. ");
INSERT INTO nyf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mana mimi mwenye nindamwanyesa viryahu ambazho vindamubidhi ateseke kwa ut'u wa dzina rangu.” ");
INSERT INTO nyf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kwa vizho Anania achenda. Bai wakwenda achendangira iryahu nyumba arimokala Sauli na akimuikira mikono, akiamba, “Sauli, ndugu yangu. Ye Bwana, yuyahu Jesu ariyekwambolera mo ngirani urihokala unadza kuku, adzanihuma ili upate kuona kaheri na udzalwe ni Roho Mweri.” ");
INSERT INTO nyf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Bai haho henye hakigwa vit'u here magaugau kula mo matsoni mwa Sauli naye akipata kuona kaheri, akiungarara na akibat'izwa. ");
INSERT INTO nyf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Badaye akirya chakurya na akipata nguvu. Bai Sauli watoa na o anafundzi ko Damesiki kwa siku za kuthala, ");
INSERT INTO nyf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","na mara mwenga akikwatya kuhubiri kahi za masinagogi dzulu za Jesu, kukala iye ni Mwana wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na lola osi mariomusikira mangalala makiuza makiamba, “Yuno se yuyahu ariyekala akiathabisha o at'u mariokala manamukuluhira Jesu ko Jerusalemu? Na samba wakudza haha ili aagwire na aahirike ko kwa alombi abomu?” ");
INSERT INTO nyf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ela kuhubiri kwa Sauli, kukikaza kukala na nguvu na akianyesa o Ayahudi matoao mo Damesiki kukala anamanya t'ot'ot'o kukala ye Jesu be nde iye Masihi. Vivi zhaahenda o Ayahudi makose ra kunena. ");
INSERT INTO nyf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Bai bada ya siku nyinji, o Ayahudi angine mapanga njama ya kumukot'a ye Sauli. ");
INSERT INTO nyf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ela iye mwenye akidza akiimanya yo njama yao. O Ayahudi makala manamufungurira Sauli kahi za yo miv̱irya ya wo mudzi usiku na mutsana ili mamwalage. ");
INSERT INTO nyf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ela o anafundzie bai, makimuhala na usiku makimwangiza rikahuni na makimutharamusha ko ndze kukirira na mwanya wa wo ukuta uriwozunguka wo mudzi. ");
INSERT INTO nyf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Bai Sauli arihofika ko Jerusalemu, wajeza kudziunga na o anafundzi kuko, ela o anafundzi k'amakuluhirire kukala iye wamukuluhira Jesu jeri. Hat'u ha vizho, ao makala ni aoga naye. ");
INSERT INTO nyf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ndo Barinaba akimuhala na achenda naye ko kwa ahumwi. Achendaambira viryahu ambazho ye Sauli wamona Bwana kahi za charoche na viryahu ambazho ye Bwana wanena naye. Kidza akiambira viryahu ambazho ye Sauli wahubiri kahi za dzina ra Jesu ko Damesiki hasiho woga. ");
INSERT INTO nyf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ndo Sauli akitoa hamwenga nao na akikala anadima kwenda hohosi mo Jerusalemu bila wasiwasi, na kunena kahi za dzina ra Bwana hasiho woga. ");
INSERT INTO nyf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Bai akinena na aryahu Ayahudi manenao Kiyunani na kunenezana nao, ela ao makijeza kumwalaga. ");
INSERT INTO nyf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","K'uzhona zho aryahu ndugu marihomanya kit'u kiki mamuhala ye Sauli na makimwomboza vivii muhaka Kaisaria na makimwamba ende T'ariso. ");
INSERT INTO nyf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Bai ro kanisa ko Judea, Galilaya na Samaria k'aripatire mateso kaheri, rajengwa na rikienderera kwangezeka. Ratoa kahi za kumwagoha Mulungu na kwangizwa nguvu ni Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Vikara P'et'ero wakala achenda kuno na kuno kahi za yo ts'i. Bai siku mwenga watharamuka ko Lida kwendaatsemberera o at'u mariomukuluhira Jesu kuko. ");
INSERT INTO nyf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","K'uzhona zho kuko Lida akimona mut'u mumwenga aifwaye Ainea. Mut'u yuyu were waholoza naye were a kitandani kwenda kwa miaka minane. ");
INSERT INTO nyf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bai P'et'ero akimwamba, “Ainea, Jesu Masihi anakuhoza be vivi. Ungarara uhandike cho kitandacho hedu.” Na haho henye Ainea akiungarara na akihenda vizho. ");
INSERT INTO nyf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Na lola o at'u osi mariotoa ko Lida na Sharoni mamona iye ariyekala adzahozwa nao makimugalukira Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Vikara kahi za mudzi wa Jopa kwere kuna mwanafundzi mumwenga aifwaye T'abith'a. (Dzina riri kwa luga ya Kiyunani ni Dorok'asi.) Mwanamuche yuyu were anahenda madzo siku zosi na kuaviza akiya. ");
INSERT INTO nyf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bai kahi za wakathi uwo akigwirwa ni unyonge na achanongeka, wo mwiriwe uchageswa na ukilazwa kahi za chumba cha gorofani. ");
INSERT INTO nyf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na kwa viryahu midzi ya Lida na Jopa were k'aikure na kure, aryahu anafundzi marihosikira kukala P'et'ero a kuko Lida, mahuma at'u airi mende makamusitire adze mara mwenga. ");
INSERT INTO nyf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","P'et'ero arihombirwa vizho akiuka achenda hamwenga nao. Bai arihofika wahirikwa kahi za cho chumba cha dzulu. K'uzhona zho o anaache magungu mariokala haho mamukundzumanyikira ye P'et'ero kuno manarira na kumwanyesa zo k'andzu na zo nguwo nyingine zirizoshonwa ni Dorok'asi arihokala achere moyo. ");
INSERT INTO nyf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bai P'et'ero akiamboza o at'u osi ko ndze gonya akipiga mavindi na akivoya, badaye akiuhundukira uryahu mwiri na akiamba, “T'abith'a, hedu ungarara!” Naye T'abith'a akigunula matsoge na arihomona P'et'ero akiuka akikeresi. ");
INSERT INTO nyf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bai P'et'ero akimugwira mukono na akimwaviza kurungarara. Gonya akiaiha aryahu anaache magungu na ao mariomukuluhira Jesu na akimuhala Dorok'asi akimwika mbere zao wa moyo. ");
INSERT INTO nyf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na lola uv̱oro uu be wavuma kila hat'u kahi za Jopa ndzima na at'u anji makimukuluhira Bwana. ");
INSERT INTO nyf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","P'et'ero wahala siku nyinji zenye ko Jopa, kwa fundhi mumwenga wa k'ingo aifwaye Simoni, gonya ndo akiuka. ");
INSERT INTO nyf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Bai kwere kuna mut'u mumwenga ko Kaisaria ariyeifwa Korinelio. Korinelio were ni mubomu kahi za kikosi cha shikari kiifwacho “Kikosi cha Kiitaliani.” ");
INSERT INTO nyf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mut'u yuyu hamwenga na adamue were madzambozera kwa Mulungu na kidza were manathuwa dini t'ot'ot'o. Mara nyinji, Korinelio wakala akiap'a vit'u akiya a Kiyahudi na kidza were siku zosini anamuvoya Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","K'uzhona zho siku mwenga murongo wa here saa chenda za mutsana akiona maono. Bai kahi za go maono akiona lwazu-lwazu malaika wa Mulungu. Malaika yuyu wamudzirira na akimwamba, “Korinelio!” ");
INSERT INTO nyf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korinelio akimuthema dzitso ye malaika kuno athele woga. Akiuza akiamba, “Vidze ni noni Bwana?” Ye malaika akimudzigidzya akiamba, “Mulungu wasikira mavoyogo na akihokera sadakazo uap'azo akiya. ");
INSERT INTO nyf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Vikara vivi kare huma at'u mende ko Jopa na madze na mwanamulume mumwenga aifwaye Simoni ambaye dzinare ringine ni P'et'ero. ");
INSERT INTO nyf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mut'u yuyu ni mujeni wa Simoni, yuyahu fundhi wa k'ingo ariye nyumbaye i k'anda-k'anda za bahari.” ");
INSERT INTO nyf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Bai yuyahu malaika ariyenena naye arihouka, Korinelio waaiha airi kahi za o ahumikie na akiiha mumwenga kahi za aryahu shikari mamurindao. Shikari yuyu were anamwagoha Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Korinelio akiadondolera zhosi virizhokala vidzahendeka gonya akiahuma ko Jopa. ");
INSERT INTO nyf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bai siku ya hiriye marihokala madzafika hehi na wo mudzi murongo wa dzuwa ra vitswani vivi, P'et'ero naye kuryahu, wakwera dzulu za nyumba kwendavoya. ");
INSERT INTO nyf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","K'uzhona zho akigwirwa ni ndzala na akikala anahendza ut'u wowosi wa kurya. Bai kirihokala kiryahu chakurya kinahikirwahikirwa ye P'et'ero wagwirwa ni fingifingi na akiona maono. ");
INSERT INTO nyf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Waona ko mulunguni kudzagunuka na kunathima kit'u here nguwo bomu. Nacho kit'u kicho were kidzagwirwa yo mitsa mine na kinathinywa ho ts'i. ");
INSERT INTO nyf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ndani za cho kit'u mwere muna kila samupuli ya nyama a magulu mane, nyama mahambalao ts'i na unyama wa kubururuka. ");
INSERT INTO nyf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Gonya kukimbola sauthi ikimwamba, “Ungarara P'et'ero. H'aya, tsindza urye!” ");
INSERT INTO nyf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kusikira vizho P'et'ero akidzigidzya akiamba, “Hatha, k'avindakala bule Bwana, mut'u mimi sidzangwe kurya kit'u chochosi kiricho kulengana na sheria ya Kiyahudi ni kikolo.” ");
INSERT INTO nyf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Bai yo sauthi ikinena naye k'ana ya hiri ikiamba, “Kit'u chochosi kidzichotsuswa ni Mulungu, usichambe ni kikolo.” ");
INSERT INTO nyf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Bai ut'u uu wakala hatha k'ana t'ahu, gonya riryahu riguwo rikiujwa ko mulunguni. ");
INSERT INTO nyf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","K'uzhona zho P'et'ero arihokala achere kudangana-dangana dzulu za mana ya go maono, lola aryahu anaalume mariokala madzahumwa ni Korinelio poo! Kwani were madzauza-uza hatha makafika ho nyumba ya Simoni iriho, na were maimire ho muryangoni. ");
INSERT INTO nyf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bai makibisha na makiuza chamba ye Simoni ariye anaifwa P'et'ero akala haho. ");
INSERT INTO nyf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","P'et'ero kuno ye, arihokala achere kuririkana dzulu za go maono, ye Roho akimwamba, “Simoni, lola sio at'u ahahu manakumala. ");
INSERT INTO nyf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","H'aya, uka bai utharamuke ko ts'ini, na usihende kisoi kwenda nao, mana nidzaahuma mimi ao.” ");
INSERT INTO nyf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kwa vizho P'et'ero akitharamuka na achendaambira o anaalume vivi, “Mimi ni iye mut'u mumumalaye. H'aya, ni ut'u wani udziwomureha?” ");
INSERT INTO nyf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","O anaalume makidzigidzya makiamba, “At'u siswi fudzambola kwa Korinelio, ariye ni mubomu wa shikari. Mut'u iye ni muhachi na anamwagoha Mulungu na kidza anaishimiwa zha nguma ni o Ayahudi osi. Bai iye waambwa ni malaika mueri kukala ahume at'u madze makwihe wende ko nyumbani kwakwe asikire go undigomwambira.” ");
INSERT INTO nyf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Bai P'et'ero akiakaribisha mangire mo nyumbani na akiap'a ndazi. Siku ya hiriye P'et'ero wadziondzola-ondzola na achenda na aryahu at'u. Ndugu angine kula Jopa nao makwenda pia. ");
INSERT INTO nyf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","K'uzhona zho siku ya hiriye makifika Kaisaria. Naye Korinelio were anaathariza. Korinelio wakala adzaaiha hamwenga o amanyie, na o asenae a kurya na kuusa. ");
INSERT INTO nyf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Vikara P'et'ero arihokala anangira mo nyumbani, ye Korinelio wamudhana na akimupigira mavindi kumuvoya. ");
INSERT INTO nyf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ela P'et'ero akimwamba, “Hedu ungarara! Mimi ni mwanadamu thu.” ");
INSERT INTO nyf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bai P'et'ero achangira mo ndani kuno ananena na ye Korinelio. Mumo ndani akithekeza mu thele at'u. ");
INSERT INTO nyf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","P'et'ero akiamba, “Ninwi enye munamanya kukala Sheria yehu siswi Ayahudi k'aihuruhusu kugwirana na mut'u ariye si Muyahudi, hedu hatha kumutsemberera. Ela bai Mulungu adzananyesa kukala nisiambe mut'u yoyosi ni mukolo here sheria yehu iambazho. ");
INSERT INTO nyf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ndosa nirihoifwa sikahalire, nidzire. Vikara namala niuze, were munanihirani?” ");
INSERT INTO nyf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korinelio akidzigidzya akiamba, “Mut'u mimi, dzuzi kusinda dzuzi saa dza zizi nakala ni nyumbani mwangu navoya, naro dzuwa rere ridzahunduka. Na lola poo, mut'u ariyekala adzavala nguwo za kumetha-metha akidzaima mbere zangu ");
INSERT INTO nyf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","akiamba, ‘Korinelio! Go mavoyogo gadzasikirwa ni Mulungu na zho vit'u up'azho akiya adzavikumbukira. ");
INSERT INTO nyf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Bai huma at'u mende ko Jopa makamwihe ye Simoni, aifwaye P'et'ero. Mut'u iye ni mujeni wa Simoni yuyahu fundhi wa k'ingo ambaye anatoa k'anda-k'anda za bahari.’ ");
INSERT INTO nyf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","K'uzhona zho haho henye, nikihuma at'u madze kwako mara mwenga, nawe bai udzahendat'o kudza. H'aya bai, vivi hosi fu haha mbere za Mulungu husikire gosini ambago walagizwa ni Bwana ufwambire.” ");
INSERT INTO nyf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ndo P'et'ero akikwatya kunena akiamba, “Vivi be dzamanya jeri kukala Mulungu k'ana upendheleo. ");
INSERT INTO nyf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ela iye anahokera at'u osi kula kahi za kila lukolo ambao manamwagoha iye na manahenda go gav̱iryago. ");
INSERT INTO nyf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bai uu ndo uv̱oro ambawo ye Mulungu wauhuma kwa at'u a Iziraeli, naye wauhuma ili aambire Uv̱oro Udzo wa dheri kukirira kwa Jesu Masihi ariye ni Bwana wa at'u osi. ");
INSERT INTO nyf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ninwi munamanya go garigokala kahi za Judea ndzima, na maut'u gago gaandza Galilaya bada ya uryahu ubat'izo uriwohubiriwa ni Johana. ");
INSERT INTO nyf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nanwi munamanya viryahu ambazho ye Mulungu wamudzaza Roho Mweri na akimudzaza nguvu ye Jesu wa Nazareth'i. Naye Jesu bai wakwenda kuno na kuno kuhenda madzo, na kuahoza o at'u osi mariokala ma ts'ini za nguvu za Shethani. Jesu wahenda vivi kwa kukala ye Mulungu were a hamwenga naye. ");
INSERT INTO nyf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Na siswi bai fu mashahidhi a garyahu maut'u gosi arigogahenda kahi za ts'i ya Ayahudi na kahi za Jerusalemu. At'u ao mamwalaga kwa kumukot'a misumari musalabani. ");
INSERT INTO nyf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ela Mulungu akimufufula siku ya hahu na akimuhendya aonekane. ");
INSERT INTO nyf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Naye k'aonewerwe ni at'u osi bule, ela waonewa ni aryahu mashahidhi mario were matsagulwa kare kimbere ni Mulungu, nao ndo siswi furiorya na kunwa naye bada ya kufufuka kula kifwani. ");
INSERT INTO nyf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iye wahulagiza fuahubiri o at'u na fwamboze ushahidhi kukala iye Jesu nde ariyetsagulwa ni Mulungu akale jaji wa ao mario moyo na ao mariofwa. ");
INSERT INTO nyf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Na ao manabii osi bai manamboza ushahidhi dzuluze, kukala kila mut'u amukuluhiraye iye, bai mut'u iye andasamehewa dambize kukirira na ro dzinare iye Jesu.” ");
INSERT INTO nyf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Naye P'et'ero were k'adzatosa kunena maneno gaga, ye Roho Mweri akiadzaza, naye waadzaza osini mariokala madzausikira wo uv̱oro uwo. ");
INSERT INTO nyf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Vikara aryahu Amasihia a Kiyahudi mariokala madzire na P'et'ero kula Jopa mangalala kuona cho kipawa cha Roho Mweri kidzahokerwa hatha ni at'u mario si Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kwani maasikira mananena na luga nyingine na manamulika Mulungu. Ndo P'et'ero akiamba, ");
INSERT INTO nyf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Vidze hana mut'u adimaye kuaziza at'u ano masibat'izwe na madzi? Kwani madzamuhokera ye Roho Mweri dza here siswi hurizhomuhokera.” ");
INSERT INTO nyf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kwa vizho bai, P'et'ero akilagiza mabat'izwe kahi za dzina ra Jesu Masihi. Badaye o at'u makimuvoya P'et'ero akale kuko kwa siku za kuthala, naye akihenda vizho. ");
INSERT INTO nyf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bai aryahu ahumwi na o ndugu mariokala kahi za Judea ndzima, masikira kukala aryahu at'u mario si Ayahudi mahokera neno ra Mulungu nao. ");
INSERT INTO nyf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kwa vizho P'et'ero arihombuka ko Jerusalemu, aryahu Amasihia mariokala manamala kuangiza lwembeni o Amasihia mario si Ayahudi, makwatya kumwangirira. ");
INSERT INTO nyf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Makimwamba, “Uwe wakwendangira nyumba za at'u mario si Ayahudi na mario k'amadzangizwa lwembeni, ukirya nao.” ");
INSERT INTO nyf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ndo P'et'ero akikwatya kunena, akiadondolera kila kit'u lwazu-lwazu here maut'u garizhohendeka kula chaho. ");
INSERT INTO nyf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Akiamba, “Mut'u mimi were ni kahi za mudzi wa Jopa navoya, bai nikiona maono. Kahi za go maono nikiona kit'u here riguwo rinatharamushwa kula mulunguni. Riguwo riri were ridzagwirwa yo mitsaye mine, bai rikithima ho nirihokala. ");
INSERT INTO nyf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nirihotsungurira mo ndani nikiona nyama a magulu mane, a tsakani, mahambalao ts'i na unyama wa kubururuka. ");
INSERT INTO nyf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Gonya nikisikira sauthi ikiamba, ‘Ungarara P'et'ero, utsindze urye.’ ");
INSERT INTO nyf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nikidzigidzya nikiamba, ‘Hatha bule Bwana! Mo kanwani mwangu be k'amudzangira kit'u chochosi kiricho kulengana na sheria ya Kiyahudi ni kikolo.’ ");
INSERT INTO nyf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Bai iyo sauthi ikinena kaheri kula mulunguni ikiamba, ‘Usihale kit'u kidzichotsuswa ni Mulungu ukachamba ni kikolo.’ ");
INSERT INTO nyf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ut'u uu be wahendeka hatha k'ana t'ahu gonya vivi ro riguwo rikivufwa kuuya mulunguni kaheri. ");
INSERT INTO nyf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Na wakathi uwo wenye, poo, anaalume ahahu mariokala madzahumwa kwangu kula Kaisaria makidza kahi za yo nyumba niriyokala ninakala. ");
INSERT INTO nyf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Bai Roho Mweri akinambira nende hamwenga nao hasiho kisoi. Bai nikiahala ndugu ahandahu na fuchenda hamwenga na huchangira kahi za nyumba ya mut'u aifwaye Korinelio. ");
INSERT INTO nyf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Hurihongira, ye mut'u akifuthalira viryahu arizhombolerwa ni malaika mo nyumbani mwakwe na akimwamba, ‘Huma mut'u ende Jopa akamwihe Simoni ariye pia anaifwa P'et'ero. ");
INSERT INTO nyf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iye P'et'ero nde andiyekwambira maneno gandigokwokola uwe hamwenga na nyumbayo yosi.’ ");
INSERT INTO nyf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“K'uzhona zho nirihokala nidzakwatya kuadungira moro, ye Roho Mweri akiathimira dza viryahu arizhohuthimira ho chaho. ");
INSERT INTO nyf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ndo nikikumbukira garyahu arigoamba Bwana kukala, ‘Johana wabat'iza at'u kwa madzi, ela ninwi mundabat'izwa kwa Roho Mweri.’ ");
INSERT INTO nyf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Vikara vikikala Mulungu waap'a kigerwa kicho ambacho ndo kicho hurichogerwa siswi hurihomukuluhira Bwana Jesu Masihi. Bai mino were ni h'ani, hatha nijeze kumuziza Mulungu?” ");
INSERT INTO nyf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Marihosikira vivi, o Ayahudi mariokala manamala kuangiza lwembeni o Amasihia mario si Ayahudi makinyamala na hat'uhe makimulika Mulungu na kuamba, “Kudzi Mulungu adzaap'a o at'u mario si Ayahudi nafasi ya kuthubu na mapate uzima.” ");
INSERT INTO nyf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Vikara aryahu at'u mariokala matsamuka-tsamuka kwa ut'u wa go mateso garigokalako wakathi Sitivini anakotw'a, angine makwenda Fonike, angine machenda kisiwa cha Kuporo, na angine machenda Anitiokia. Kahi za kwenda kwao, were manaambiriza Ayahudi h'akeye dzulu za wo Uv̱oro Udzo. ");
INSERT INTO nyf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ela bai angine kahi zao, mariokala manambola kisiwa cha Kuporo na K'irene, marihofika Anitiokia makwendakwacha kuahubiri o Ayunani kuko nako. Mahubiri Uv̱oro Udzo wa Bwana Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bai nguvu za Mulungu zere zi hamwenga nao, na at'u anji makikuluhira na makimugalukira Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","K'uzhona zho uv̱oro uu ukirifikira ro kanisa ko Jerusalemu, bai makimuhuma Barinaba ende ko Anitiokia. ");
INSERT INTO nyf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","K'uzhona, Barinaba arihofika kuko na kuona viryahu ambazho Mulungu wakala adzaahasa, wafwahirwa na akiangiza moyo osini ili maenderere kumukuluhira Bwana na mioyo yao yosi. ");
INSERT INTO nyf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barinaba were ni mut'u mudzo ariyedzalwa ni Roho Mweri na ariyekala na kuluhiro bomu. Bai at'u anji marefwa kwa Bwana. ");
INSERT INTO nyf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Badaye akiuka achenda T'ariso kumumala Sauli. ");
INSERT INTO nyf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bai Barinaba arihomona Sauli makudza osi muhaka Anitiokia. Nao kwa mwaka muzima, makala makithunganana na ro kanisa kuko na kidza mafundisha at'u anji sana kuko. Kuko Anitiokia ndiko ambako o anafundzi a Jesu maandza kuifwa Amasihia kwa mara ya kwandza kamare. ");
INSERT INTO nyf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Bai kahi za wakathi uwo kuchambola manabii kula Jerusalemu makitharamuka Anitiokia. ");
INSERT INTO nyf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mumwenga wao were anaifwa Agabo. Agabo waungarara na kwa nguvu za Roho akinena kimbere kukala kundakudza ndzala ya kitai kahi za urumwengu muzima. (Ndzala ii yakudza jeri wakathi wa kuthawala kwa Kilaudio.) ");
INSERT INTO nyf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Bai o ndugu makipanga kukala kila mumwenga wao kulengana na wadimiwe amboze musadha kwa o anafundzi andziyao ko Judea. ");
INSERT INTO nyf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nazho ndo marizhohenda. Mahirika yo mitsango yao kwa o azee a kanisa ko Judea kukirira kwa Barinaba na Sauli. ");
INSERT INTO nyf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Vikara kahi za wakathi uu, muthawali Herode wakwatya kuatesa angine kahi za ro kanisa. ");
INSERT INTO nyf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wamwalaga Jakobu nduguye Johana kwa mushu. ");
INSERT INTO nyf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bai arihoona kukala ut'u uu unaafwahiza o Ayahudi, wamugwira P'et'ero naye. Maut'u gaga gahendeka wakathi uryahu wa sikuk'uu ya Mikahe Iso Ts'ats'u. ");
INSERT INTO nyf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Vikara arihomugwira P'et'ero, wamuhala na akimusindikira jela na akilagiza arindwe ni makundi mane ga shikari ane-ane. Herode were adzapanga amwamboze ndze ajibu k'esi mbere za at'u bada ya sherehe ya P'asaka. ");
INSERT INTO nyf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kwa vizho akithuwa kuikwa mo jela, ela ro kanisa bai rikimuvoya Mulungu kwa chadi dzuluze. ");
INSERT INTO nyf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Bai usiku uryahu wa kulalira siku ambayo Herode were andamwamboza ajibu k'esi, P'et'ero were arere kahikahi, kuno ni shikari na kuno ni shikari. Naye were adzafungwa minyororo miri, na kuko ndze ya muryango were kuna shikari. ");
INSERT INTO nyf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bai lola malaika wa Bwana achambola, na wo mulangazawe uking'ala mo chumbani. Ye malaika akimupiga-piga mo lwavuni ye P'et'ero akimulamusa. Akimwamba, “Uka mara mwenga!” Na lola yo minyororo potho, ikigwa kula mo mikononi mwakwe. ");
INSERT INTO nyf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Gonya ye malaika akimwamba, “Dzifunge wo ukandao na uvale zho virahuzho.” H'aya P'et'ero akihenda vizho. Ye malaika akimwamba, “H'aya dzikut'e ro ambaro na unithuwe.” ");
INSERT INTO nyf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","K'uzhona zho P'et'ero akimuthuwa ye malaika kwombola ndze ya yo jela, ela ko k'amanyire kala zho arizhokala anahenda ye malaika ni zha jeri, kwani hatha waona here kwamba anaona maono beye. ");
INSERT INTO nyf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bai ndoo vivii, hatha makikira cho kikundi cha kwandza na cha hiri cha o shikari na machambolera wo muryango wa chuma ambawo ndo wa kwangirira mo mudzini. Marihofika haho, wo muryango ukihenda kuvuguka wenye na makimbola. Vikara marihonenda kahi za barabara mwenga, lola ye malaika akimwangamika. ");
INSERT INTO nyf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ndo P'et'ero akitsundzulukwa na akinena kimoyo-moyo akiamba, “Vivi namanya ni jeri kukala Bwana adzahuma malaikawe akadzanamboza magandzani mwa Herode na gosi marigo o Ayahudi were madzapanga kunihendera.” ");
INSERT INTO nyf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Bai maut'u gaga garihomung'alira, wafururiza muhaka nyumbani kwa Maryamu mameye Johana, ariye pia anaifwa Mariko. Kuko kwere kuna at'u anji madzakundzumanyika manavoya. ");
INSERT INTO nyf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","P'et'ero akibisha na wo muryango wa ko ndze, na hachambola musichana mumwenga aifwaye Roda ariye were ni muhendzi wa kazi wa mo nyumbani, bai achenda ili akamuvugulire. ");
INSERT INTO nyf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","K'uzhona zho arihomanya kukala wo mumiro ni wa P'et'ero, wadzalwa ni raha ut'u wa kwangalaza hatha akiuya malo hasiho kuusundula wo muryango, achendaamba, “Ni P'et'ero benwi!” O at'u marihosikira vizho makimudzigidzya makiamba, ");
INSERT INTO nyf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Una vilalu uwe.” Ela arihosita kuamba ni P'et'ero, o at'u makiamba, “Iye ni malaikawe.” ");
INSERT INTO nyf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Wakathi uwo P'et'ero were anabisha thu, bai marihosundula wo muryango na kumona, mangalala kamare. ");
INSERT INTO nyf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","P'et'ero akiavungira mukono manyamale, gonya akiathalira viryahu Bwana arizhomwamboza ko jela. Badaye akiamba, “Ambireni Jakobu na o ndugu angine dzulu za maut'u gaga.” Gonya akiuka achenda kut'u kungine. ");
INSERT INTO nyf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","K'uzhona zho kurihocha, o shikari mabudzyika sana. Makiuzana-uzana na kuamba, “Vino be akale ye P'et'ero adzakwendahi?” ");
INSERT INTO nyf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Bai Herode akilagiza P'et'ero amalwe hatha apatikane, ela bai k'amamonere bule. K'uzhona zho Herode akiauza-uza maswali o arindzi gonya akilagiza manyongwe. Bada ya gaga Herode wauka Judea na akitharamuka kwenda Kaisaria na akikala kuko siku za kuthala. ");
INSERT INTO nyf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herode were ana k'ondo na at'u a Tiro na Sidoni. K'uzhona zho o at'u makiungana na machendamona. Nao were mamwangola-ngola Bulasito ariye were ni muhumiki adziyekuluhirwa ni ye muthawali, hatha akikira upande wao. Bai makwendamala dheri na Herode, kwani chakurya chao ao at'u a Tiro na Sidoni were kimbola ko Herode arikokala anathawala. ");
INSERT INTO nyf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Bai yo mbadha mariyoikana irihofika, Herode wakelesi kahi za kihiche cha endzi kuno adzakot'ea go mavwaloge ga kithawali, bai akikwatya kuahutubia o at'u. ");
INSERT INTO nyf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Marihosikira yo hotubaye, makipiga njerejere makiamba, “Ii be ni sauthi ya mulungu kamare, si ya mwanadamu hatha.” ");
INSERT INTO nyf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Haho henye malaika wa Bwana, akimwakasha, naye akiriwa ni minyolo akifwa, mana k'amup'ire nguma Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Neno ra Mulungu ro, rikikaza kuhenda nguvu na rikitsalalira. ");
INSERT INTO nyf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bai Barinaba na Sauli marihomarigiza yo shuhuli mariyohumwa, mauka Jerusalemu na makimuhala Johana ariye dzina ringine nde Mariko makiuya Anitiokia. ");
INSERT INTO nyf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Bai kahi za ro kanisa ko Anitiokia were kuna manabii na alimu. At'u aa were ni, Barinaba na Simioni ariye were pia anaifwa Nigeri (yani mut'u mwiru) na Lukio kula K'irene, na Sauli, na Manaeni (Manaeni were wafugwa na Herode). ");
INSERT INTO nyf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Vikara marihokala makumuvoyani Bwana na kufunga, ye Roho Mweri waamba, “Nithengerani k'anda Barinaba na Sauli kwa ut'u wa yo kazi niriyoaihira.” ");
INSERT INTO nyf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kwa vizho marihokala madzafunga na kuvoya maaikira mikono gonya makiamboza machenda. ");
INSERT INTO nyf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bai o airi marihokala madzaambwa mende ni ye Roho Mweri, matharamuka kut'u kuifwako Seleukia na kuko machangira chomboni na machenda vivii muhaka kisiwa cha Kuporo. ");
INSERT INTO nyf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Marihofika Kuporo mangira mudzi wa Salami, makihubiri neno ra Mulungu kahi za go masinagogi ga Ayahudi kuko. Johana Mariko were a hamwenga nao dza here mut'u wa kuaviza-viza. ");
INSERT INTO nyf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bai Barinaba na Sauli makwenda kuno na kuno kahi za cho kisiwa hatha makifika P'afo, kuko P'afo makimona muganga mumwenga wa Kiyahudi aifwaye Bari-Jesu. Mut'u yuyu were ni nabii wa ulongo, ");
INSERT INTO nyf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","kidza were anaelewana na luwali Serigio P'aulo. Serigio P'aulo were ni mut'u wa akili sana. Bai ye luwali akilagiza Barinaba na Sauli mende ko kwakwe mana were mana haja na kusikira neno ra Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ela bai yuyahu muganga, ariye dzinare kwa Kiyunani ni Eluma, akiaikira vikwazo na akijeza kumugaluza ye luwali ili asikuluhire. ");
INSERT INTO nyf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ndo Sauli, ambaye pia were anaifwa P'aulo, akimuthema dzitso ye Eluma kuno athele Roho Mweri, akimwamba, ");
INSERT INTO nyf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Uwe u mwana wa Shethani na u hadhui wa kila kit'u kiricho karakara! U thele kila samupuli ya ukengi na ujanja na unajeza kuuhala ujeri wa Bwana na kuuhendya ulongo. ");
INSERT INTO nyf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","H'aya bai, lola mukono wa Bwana u dzuluzo, nawe vivi undakala kipofu kwa muda na k'undaona mulangaza wowosi.” Naye haho henye matsoge gachangira kunje na kiza, naye akikala ni wa zuzuru-zuzuru kumala mut'u amugwire mukono amutsetseze. ");
INSERT INTO nyf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","K'uzhona zho ye luwali arihoona gago garigokala gadzahendeka, wakuluhira na achangalazwa ni go mafundisho dzulu za Bwana Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bai kula P'afo, P'aulo na andziye makwera chomboni machenda mudzi wa P'eriga kahi za ts'i ya P'amufulia. Marihofika kuko, Johana Mariko waaricha na akiuya Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","H'aya makiuka kula P'eriga na machenda kut'u kuriko kunaifwa Anitiokia kahi za ts'i ya P'isidia. Bai siku ya Sabato irihofika machangira kahi za sinagogi makikeresi. ");
INSERT INTO nyf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bai hachambola mut'u akishoma Maoro kula kahi za Sheria ya Musa na kula kahi za Maoro ga manabii. Gonya aryahu abomu a ro sinagogi makihuma mut'u achendaambira o ani P'aulo vivi, “Ndugu, chamba muna neno rorosi rindiroangiza nguvu aa at'u be hunamuvoya murinene.” ");
INSERT INTO nyf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ndo P'aulo akirungarara akiavungira mukono ili mamusirikize, akiamba, “H'enwi at'u a Iziraeli na ninwi nyosi murio k'amu Ayahudi, ela munamwogoha Mulungu, nisirikizani hedu! ");
INSERT INTO nyf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Iye Mulungu wa at'u a Iziraeli waatsagula o akare ehu na akiahendya makikala taifa bomu kahi za kuishi kwao ko Misiri, kidza akiamboza kula kahi za ts'i iyo kwa nguvuze nyinji, ");
INSERT INTO nyf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","na akiavumirira kwa miaka mirongo mine ko nyika. ");
INSERT INTO nyf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Iye Mulungu vizho, akiganonga makabila mafungahe ga at'u mariokala manatoa kahi za ts'i ya K'anani na akihala yo ts'i yao akianosa at'ue ikale yao. ");
INSERT INTO nyf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Maut'u gaga gosi gahala miaka magana mane na mirongo mitsano, badaye Mulungu akitsagula at'u na akiahendya makale vilongozi na alamuli ao, bai zhakala vivi muhaka wakathi wa nabii Samueli. ");
INSERT INTO nyf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bai badaye, o at'u mamala muthawali na Mulungu akiap'a Sauli mwana wa Kishi wa kula kahi za mbari ya Benjamini, naye Sauli wathawala miaka mirongo mine. ");
INSERT INTO nyf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","H'aya, badaye Mulungu arihomufuta Sauli, wamutsagula Daudi na akimuhendya akale muthawali wao. Mulungu wanena dzulu za Daudi akiamba, ‘Nidzafwahirwa zhomu ni Daudi mwana wa Jese. Kwani nidzamona kukala andahenda kila kit'u nindichomwambira ahende.’ ");
INSERT INTO nyf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Bai kula kahi za lukolo lwa mut'u yuyu, Mulungu waarehera mwokoli Jesu o Aiziraeli here arizhokala walaga. ");
INSERT INTO nyf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ela kabila Jesu k'adzaandza kaziye, Johana wahubiri kwa o Aiziraeli osi dzulu za kuthubu na kubat'izwa. ");
INSERT INTO nyf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Naye Johana arihokala akumarigizani kaziye, waamba, ‘Vidze munaelelya kukala mino ni h'ani? Bai mimi si iye mumutharizaye, ela lolani, kuna mut'u andiyekudza nyuma zangu ambaye sifika hatha mut'u wa kumuvula virahu.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","P'aulo akienderera kunena akiamba, “Ndugu zangu, ana a Burahemu, na ninwi ambao k'amu Ayahudi ela munamwogoha Mulungu, uv̱oro uu wa wokolwi, k'aungadzire, ela wakudza kwa ut'u wa siswi. ");
INSERT INTO nyf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ao at'u a Jerusalemu na athawali ao k'amamanyire kukala Jesu were nde mwokoli, ela marihokala madzamuhukumu kwalagwa makigathimiza garyahu maneno ga manabii gashomwago kila siku ya Sabato. ");
INSERT INTO nyf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Idzaho k'amadimire kupata ushahidhi wa kuthosha wa kumuhukumu kwalagwa, ao mamwamba P'ilato alagize alagwe vizho. ");
INSERT INTO nyf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bai marihogonya kumuhendera garyahu garigoorwa kahi za Maoro dzuluze, mamuthinya kula ho musalabani machendamwangiza mbirani. ");
INSERT INTO nyf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ela Mulungu akimufufula kula kifwani, ");
INSERT INTO nyf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","naye akionewa siku nyinji zenye ni aryahu ariokala akisafiri nao kula Galilaya kwenda Jerusalemu, Bai at'u aa ndo mashahidhie kwa o at'u ehu.” ");
INSERT INTO nyf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","P'aulo akienderera kunena akiamba, “At'u siswi hunamwambiriza Uv̱oro Udzo wa cho kilagane marichop'ewa akare ehu, ");
INSERT INTO nyf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ambacho Mulungu adzakithimiza kwehu siswi ana, kwa kumufufula Jesu kula kifwani. Here zaburi ya hiri kahi za chuwo cha Zaburi iambazho kukala, ‘Uwe u Mwanangu, mimi vivi rero nidzakala Babayo.’ ");
INSERT INTO nyf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Na dzulu za kufufulwa kwa Jesu kula kifwani ili asiole, iye Mulungu wanena akiamba, ‘Jeri wenye nindakuhasa here nirizhomulaga Daudi kukala ningamuhasa.’ ");
INSERT INTO nyf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kidza kahi za go Maoro, hat'u hangine hanaamba, ‘K'undamuricha ye muhumikio mueri aole.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","P'aulo akienderera kunena akiamba, “Mana Daudi arihogonya kuhenda maut'u ga Mulungu kahi za kizhaziche, waathuwa o ts'aweze, akizikwa na akiola. ");
INSERT INTO nyf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ela iye ariyefufulwa ni Mulungu kula kifwani k'aolere bule. ");
INSERT INTO nyf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Kwa vizho ndugu zangu, namala mumanye kukala ninwi munaambirizwa dzulu za musamaha wa dambi kukirira kwa Jesu. Kukirira kwa iye bai, kila mut'u akuluhiraye anahendywa muhachi kula kwa garyahu ambago were Sheria ya Musa k'aidima kumuhendya muhachi. ");
INSERT INTO nyf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","H'aya dzimanyirireni bai, ili garyahu garigoorwa kahi za chuwo cha manabii gasimupate bule. ");
INSERT INTO nyf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Nago ganaamba vivi: ‘Lolani nwi at'u a zarau, makani na mwangamike. Mana mimi nindahenda kit'u kahi za wakathi wenu, ut'u uriwo k'amundaukuluhira kamare, hatha mukaelezwa kidza ni bule.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Vikara P'aulo na Barinaba marihokala makumbolani mo sinagogini, o at'u maambira o ani P'aulo madze kaheri kahi za yo siku ya Sabato idzayo ili madze manene zaidhi dzulu za gago maut'u marigokala madzaganena kare. ");
INSERT INTO nyf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bai uryahu muthunganano urihokala unafumukana, P'aulo na Barinaba mathuwiwa ni Ayahudi anji na at'u angine anji mario were manathuwa dini ya Kiyahudi, bai o ani P'aulo masumurira na at'u na makiakokot'era ili makaze kuremera wo udzo wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","K'uzhona zho yo Sabato nyingine irihofika, karibu kila mut'u kahi za mudzi uwo wakudza ili asikire neno ra Bwana. ");
INSERT INTO nyf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ela o Ayahudi marihoona ro thele ra at'u, madzalwa ni wivu na makikwatya kunena mai dzulu za go arigokala P'aulo ananena, makimuhukana-hukana. ");
INSERT INTO nyf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ndo P'aulo na Barinaba makiadzigidzya hasiho woga makiamba, “At'u siswi were k'avina budhi fuandze kumwambira neno ra Mulungu ninwi kwandza, ela kwa kukala munarikahala na k'amudziona kukala munav̱irya mupate uzima wa kare na kare, lolani funamuricha na hunenda kwa o at'u mario si Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mana vizho ndizho Bwana arizhofulagiza, akiamba, ‘Nidzakuhenda ukale mulangaza kwa o at'u mario si Ayahudi, ili uwe urehe wokolwi kahi za urumwengu muzima.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","K'uzhona zho aryahu at'u mario si Ayahudi marihosikira vivi mafwahirwa na makimulazhira muv̱era Bwana kwa ro nenore, na osini mariotsagulwa kwa ut'u wa uzima wa kare na kare, makuluhira. ");
INSERT INTO nyf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Bai ro neno ra Bwana ratsamuka kila hat'u kahi za ro jimbo riro. ");
INSERT INTO nyf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ela o Ayahudi makiavuga akili aryahu ano m'ama mariokala manamwagoha Mulungu na manaishimiwa sana, na makiavuga akili aryahu anaalume mario ni abomu kahi za mudzi uwo, na makikwatya kuatesa o ani P'aulo na Barinaba na makiainga kula kahi za jimbo rao. ");
INSERT INTO nyf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Aryahu ani P'aulo bai makikut'a-kut'a ro vumbi ra maguluni mwao here onyo kwao, gonya makiuka machenda Ikonio. ");
INSERT INTO nyf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na o anafundzi makikala mana raha sana na makidzalwa ni Roho Mweri. ");
INSERT INTO nyf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Vikara kuko Ikonio, P'aulo na Barinaba makwenda kahi za sinagogi ra Kiyahudi here garizhokala mazowera gao. Bai marihofika mumo sinagogini, makihubirit'o hatha kundi bomu renye ra Ayahudi na at'u mario si Ayahudi makikuluhira. ");
INSERT INTO nyf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ela aryahu Ayahudi mario k'amakuluhirire, maavuga akili aryahu at'u mario si Ayahudi ili makale kinyume cha o ndugu. ");
INSERT INTO nyf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Bai P'aulo na Barinaba makala kut'u kuko kwa muda mure wenye kuhubiri dzulu za Bwana hasiho woga. Ye Bwana akinyesa kukala wo uv̱oro wa nemaye ni wa jeri, kwa kuap'a nguvu za kuhenda miujiza na maut'u ga kwangalaza. ");
INSERT INTO nyf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bai ro kundi ra at'u kahi za mudzi uwo rikigazhika, kabadhi kakikala upande wa aryahu Ayahudi, na kabadhi kangine kakikala upande wa aryahu ahumwi. ");
INSERT INTO nyf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mwishowe aryahu at'u mario si Ayahudi na o Ayahudi hamwenga na vilongozi, makitsila njama ya kuahenda kit'u kii o ahumwi. Mana were madzapanga maakot'e mawe. ");
INSERT INTO nyf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","K'uzhona zho o ahumwi makivigundua na makichimbira kwenda kahi za midzi ya Lukaonia ambayo ni Lusitera na Deribe, kidza machenda hatha kahi za go malalo gadzigoizunguluka yo midzi iyo. ");
INSERT INTO nyf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Marihokala ma kuko, bai maenderera kuhubiri wo Uv̱oro Udzo wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Bai kuko Lusitera kwere kuna mwanamulume mumwenga ariyekala wazhalwa kidende, naye were k'adzanenda hatha siku mwenga. ");
INSERT INTO nyf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Vikara akikelesi akimusirikiza P'aulo ananena. Bai P'aulo akimuthema dzitso ye kidende na akimona kukala anakuluhira kukala andahozwa, ");
INSERT INTO nyf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kwa vizho akinena naye kwa sauthi ya dzulu akimwamba, “H'aya ungarara na magulugo!” Haho henye ye mut'u akiguluka na akikwatya kwanenda. ");
INSERT INTO nyf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","K'uzhona zho, ro kundi ra at'u ririhoona vizho arizhokala P'aulo adzahenda, mapiga k'ululu kahi za luga yao ya Kilukaonia na kuamba, “Milungu idzathima kwehu kwa umbo ra anadamu benwi!” ");
INSERT INTO nyf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bai Barinaba makimwamba nde Zeusi, P'aulo ye makimwamba nde Herime, mana nde ariyekala ananena. ");
INSERT INTO nyf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ye mulombi wa Zeusi, ambaye hekalure were ri ko ndze ya wo mudzi, akidza na ndzao za ng'ombe na viremba zha maluwa muhaka ho muryango wa kwangirira mo mudzini. Iye hamwenga na ro kundi ra at'u were manamala kuambozera sadaka o ahumwi. ");
INSERT INTO nyf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ela Barinaba na P'aulo marihosikira maut'u gaga, mahala zo nguwo zao makizitharura kunyesa kukala zho at'u marizhokala mananena na kuhenda were k'aviafwaha kamare. Nao lola mauka malo muhaka mo kundini kuno manaamba, ");
INSERT INTO nyf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Asena, kwanoni munahenda kit'u dza kino? Siswi naswi be fu at'u thu, fu binadamu dza here ninwi. Siswi fudzamurehera Uv̱oro Udzo, hudzire humwambire muriche kuhasa vit'u vivi visizho mana na mumugalukire Mulungu ariye moyo, na ariyeumba dzulu na ts'i na bahari na zhosini virizho mumo. ");
INSERT INTO nyf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Haho kapindi, iye Mulungu, waaricha at'u osi mathuwe maut'u gao genye. ");
INSERT INTO nyf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ela hamwenga na vizho k'arichire kudzambozera ushahidhi wa kukala a kuko. Iye Mulungu anamup'a v̱ula kula dzulu na anamup'a vilimo vidzo, iye vizho anamugera chakurya kinji na anayadzaza mioyo yenu raha.” ");
INSERT INTO nyf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Na lola hatha bada ya maneno gaga kidza zhakala vikomu kwa P'aulo na Barinaba kuzulia ro kundi risiambozere sadaka. ");
INSERT INTO nyf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ndo kukidza Ayahudi angine kula Anitiokia na Ikonio, makidzanena na o at'u hatha o at'u makigwira go gao. Makimukot'a mawe P'aulo na makimuv̱urura muhadhi ko ndze ya wo mudzi, kuno manaona kukala adzafwa beo. ");
INSERT INTO nyf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ela o anafundzi marihomukundzumanyikira, waungarara na akiuya kaheri mo mudzini. Bai siku ya hiriye, iye na Barinaba mauka na machenda Deribe. ");
INSERT INTO nyf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bai P'aulo na Barinaba mahubiri wo Uv̱oro Udzo kuko Deribe na at'u anji enye makimukuluhira Jesu. Badaye makiuya ko Lusitera, Ikonio na Anitiokia, ");
INSERT INTO nyf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","kuno manaangiza nguvu na kuap'a moyo o anafundzi ili maenderere kutoa kahi za ro kuluhiro. Makiamba, “Ko kwangira kahi za uthawali wa Mulungu, be suthi fukirire shidha nyinji zenye.” ");
INSERT INTO nyf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bai kahi za wakathi uwo vizho, P'aulo na Barinaba matsagula azee kahi za kila kanisa, na kwa kufunga na kuvoya, makiaika mbere za ye Bwana mariyemukuluhira. ");
INSERT INTO nyf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kigonya o ahumwi makikira na jimbo ra P'isidia na makifika P'amufulia. ");
INSERT INTO nyf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bai kuko P'amufulia mahubiri ro neno ra Mulungu kahi za mudzi wa P'eriga ndo makitharamuka machenda Atalia. ");
INSERT INTO nyf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kuko Atalia machangira chomboni na makidziuja Anitiokia ambako ndo marikovoyerwa ho chaho kwamba Mulungu aaonere mbazi na aavize kahi za yo kazi ambayo were ndo vivi madzaimarigiza. ");
INSERT INTO nyf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Bai marihofika kuko, marikusanya hamwenga ro kanisa na makithala kila kit'u ambacho ye Mulungu wakihenda kukirira kwa ao, na makithala viryahu ambazho Mulungu wavugula muryango na o at'u mario si Ayahudi makikuluhira. ");
INSERT INTO nyf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nao bai o ani P'aulo makala kuko na o anafundzi kwa muda mure wenye. ");
INSERT INTO nyf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Badaye kukidza at'u alume kula Judea ko Anitiokia. At'u alume aa were manaafundisha o ndugu na kuamba, “Kala k'amundangizwa lwembeni karakara na Sheria ya Musa iambazho, be manyani k'amudima kuokoka bule.” ");
INSERT INTO nyf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","K'uzhona zho kit'u kiki kindaahenda P'aulo na Barinaba manenezane na aa at'u jeri-jeri. Mwishowe vikionewa kukala baha P'aulo na Barinaba magwirane na ndugu angine na mambuke kwenda Jerusalemu kwendaauza mashauri o ahumwi na o azee a kanisa dzulu za kit'u kiki cha kwangizwa lwembeni. ");
INSERT INTO nyf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","H'aya makihumwa ni ro kanisa, nao machenda. Kahi za charo chao, makira na Fonike na Samaria, kuko makiambira o at'u viryahu ambazho o at'u mario si Ayahudi mamugalukira Mulungu. Bai uv̱oro uu waahenda o ndugu mafurahi sana. ");
INSERT INTO nyf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Vikara marihofika Jerusalemu, makaribishwat'o ni ro kanisa, na o ahumwi na o azee a kanisa. Ndo makiadondolera kila kit'u ambacho Mulungu wakihenda kukirira kwa ao. ");
INSERT INTO nyf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ela angine kahi za aryahu mariokuluhira na mario were ma kahi za chama cha Mafarisayo makiungarara makiamba, “At'u ao ni mangizwe lwembeni ndo maamuriwe kuithuwa yo Sheria ya Musa.” ");
INSERT INTO nyf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bai o ahumwi na o azee makiona baha maike mukut'ano na masumurire dzulu za kit'u kiki. ");
INSERT INTO nyf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Vikara kahi za mukut'ano uwo makudzasumurira kwa muda mure wenye hasiho kugwirana maneno, ndo P'et'ero akiungarara na akinena nao akiamba, “Ndugu zangu, ninwi munamanya kukala ho kapindi Mulungu wanitsagula kula kahi zenu ili niambirize Uv̱oro Udzo o at'u mario si Ayahudi, ili masikire na makuluhire. ");
INSERT INTO nyf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na Mulungu amanyaye mioyo ya at'u, wanyesa kukala adzaahokera kwa kuap'a Roho Mweri dza here zho arizhohup'a siswi. ");
INSERT INTO nyf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Haho marihokuluhira, Mulungu waatsusa mioyo yao dza zho arizhofutsusa mioyo yehu wakathi furihomukuluhira. K'aambire ano mavino ano mavino. ");
INSERT INTO nyf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Vikara, mbona munamujeza Mulungu kwa kuahika o anafundzi muzigo uriwo waashinda o akare enu na siswi kuutsukula? ");
INSERT INTO nyf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ela bai, hunakuluhira kukala siswi hunaokoka kwa mbazi za Bwana Jesu, karakara na ao.” ");
INSERT INTO nyf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Badaye ani P'aulo na Barinaba marihokala manathala viryahu ambazho Mulungu wahenda miujiza na maut'u ga kwangalaza kwa o at'u mario si Ayahudi kukirira kwa ao, wo muthunganano wosi wanyamala zii kuasirikiza. ");
INSERT INTO nyf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bai marihotosa wo moro wao, Jakobu waungarara na akiamba, “Ndugu, nisirikizani hedu. ");
INSERT INTO nyf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni adzahuthalira viryahu ambazho Mulungu ho kwandza waalola o at'u mario si Ayahudi, na kahi zao akidzivulira kafudza. ");
INSERT INTO nyf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Go maneno ga o manabii be ganagwirana na ut'u uu. Here Maoro gaambazho, ");
INSERT INTO nyf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Bada ya maut'u gaga nindauya na niiake lusha yo nyumba ya Daudi iriyogwa. Nindayujat'o kaheri, ");
INSERT INTO nyf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ili o at'u masereo mamumale Bwana; na o at'u osi mario si Ayahudi ambao manaifwa na dzina rangu manimale. Vivi ndo aambazho ye Bwana ahendaye maut'u gaga gosini, ");
INSERT INTO nyf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ambago wahenda gamanyikane kula kapindi na kapindi.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jakobu akienderera kunena akiamba, “Kwa vizho bai, kizhangu mimi, naona kukala fusivihende vikomu kwa o at'u mario si Ayahudi kumuuyira Mulungu, ");
INSERT INTO nyf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ela hat'u ha vizho, siswi nafuaorere baruwa ya kuambira kukala masirye zhakurya ambazho vidzambozezwa vizuka na masizinge, na masirye nyama a kushongolwa, kidza masirye mulatso. ");
INSERT INTO nyf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kwani yo Sheria ya Musa be inahubiriwa kahi za kila mudzi kula hangu ho kare na kidza inashomwa kahi za masinagogi kila ifikaho siku ya Sabato.” ");
INSERT INTO nyf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ndo o ahumwi na o azee a kanisa, hamwenga na kanisa rosi makiona baha matsagule at'u kahi zao, maahume mende ko Anitiokia hamwenga na P'aulo na Barinaba. Bai akitsagulwa Juda, aifwaye Barisaba na Silasi. At'u aa airi were nao ni vilongozi a o ndugu. ");
INSERT INTO nyf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Makiahuma mende na baruwa ii iambayo vivi: “Siswi ndugu zenu ahumwi hamwenga na azee a kanisa, hunamulamusa ninwi at'u murio k'amu Ayahudi, ela munamukuluhira Mulungu. Ninwi ambao mu kuko mudzi wa Anitiokia, na jimbo ra Siria, na Kilikia. ");
INSERT INTO nyf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Siswi fwapata uv̱oro kukala kuna at'u fulani mariombola kahi zehu hasiho ruhusa yehu na makidza kuko makidzamubudzya akili kwa gago marigonena. ");
INSERT INTO nyf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kwa vizho hosini hudzaona ni vidzo, fuhume at'u mamudzirire. At'u aa fudzaagwizanya na asena ehu airi, Barinaba na P'aulo. ");
INSERT INTO nyf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Anaalume aa, Barinaba na P'aulo were ma thayari kufwa kwa ut'u wa ro dzina ra Bwana wehu Jesu Masihi. ");
INSERT INTO nyf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kwa vizho hudzamuhuma Juda na Silasi ambao gaga hugaorago, be mandakudzagaelezat'o na milomo yao enye kuko. ");
INSERT INTO nyf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ye Roho Mweri na siswi, be fwaona ni vidzo kutsamuhika mizigo na ut'u wowosi hasihokala gaga machache thu. ");
INSERT INTO nyf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","At'u ninwi musirye chakurya kidzichombozerwa sadaka vizuka, musirye mulatso, musirye nyama adziyehenda kushongolwa na musizinge. Bai mukidzirinda na gaga mundakala munahenda kit'u cha mana. H'aya kalani azima.” ");
INSERT INTO nyf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bai at'u ao machambozwa na makitharamuka ko Anitiokia. Marihofika kuko marikusanya ro kanisa na makilazha yo baruwa. ");
INSERT INTO nyf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bai o at'u marihoishoma madzalwa ni fwahiro kwa kukala vizho virizhokala vidzaorwa mo ndani be were vinaap'a moyo. ");
INSERT INTO nyf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ndo Juda na Silasi, mario were ni manabii, makinena manji kuap'a moyo na kuangiza nguvu o ndugu. ");
INSERT INTO nyf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bai at'u ao makala kuko wiki za kuthala na badaye makimbozwa ni o ndugu mauye na dheri kwa ao mariokala maahuma.  ");
INSERT INTO nyf_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ela Silasi akiona baha aimeime kuko kwandza. ");
INSERT INTO nyf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","P'aulo na Barinaba makibaki ko Anitiokia, ambako ao hamwenga na andziyao anji mafundisha na kuhubiri neno ra Bwana kuko. ");
INSERT INTO nyf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Badaye P'aulo wamwamba Barinaba, “Hedu nahuuye kahi za yo midzi huriyohubiri neno ra Bwana, fukaalole o ndugu chamba manaendereradze.” ");
INSERT INTO nyf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Vikara Barinaba akikala ahendzazho ni mamuhale Johana Mariko, mende osi, ");
INSERT INTO nyf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ela P'aulo akizhona mbai, mana marihokala P'amufulia ye Johana waaricha o ani P'aulo na k'aenderere nao kahi za yo kazi. ");
INSERT INTO nyf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","K'uzhona zho mandanenezana hatha matoke. Bai Barinaba akimuhala ye Mariko na machangira chomboni kwenda kisiwa cha Kuporo. ");
INSERT INTO nyf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","P'aulo ye akimuhala Silasi akivoyerwa Mulungu ni o ndugu, thio, makiuka. ");
INSERT INTO nyf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bai P'aulo na Silasi makira na Siria na Kilikia kugangiza nguvu go makanisa kuko. ");
INSERT INTO nyf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bai P'aulo akienderera na charoche muhaka Deribe, gonya achenda Lusitera. Kuko Lusitera ndo kurikotoa mwanafundzi mumwenga aifwaye T'imoth'i. Mameye were ni Muyahudi ariyemukuluhira Jesu, ela babaye vivi akikala ni Muyunani. ");
INSERT INTO nyf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Iye T'imoth'i were ananenwat'o ni o ndugu mariotoa ko Lusitera na Ikonio. ");
INSERT INTO nyf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","K'uzhona zho P'aulo akihendza amuhale mende osi, kwa vizho akimuhala na akimwangiza lwembeni, kwa ut'u wa o Ayahudi mariotoa kahi za lalo riro, mana were osi manamanya kamare kukala ye babaye T'imoth'i si Muyahudi, ela ni Muyunani. ");
INSERT INTO nyf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Vikara kahi za charo chao, makira kahi za mudzi uno na mudzi urya, kuap'a o at'u garyahu malagizo garigokizishwa ni o ahumwi na o azee a kanisa ko Jerusalemu, ili magagwire. ");
INSERT INTO nyf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kwa vizho go makanisa gachangizwa nguvu kahi za kuluhiro na wo murongo wao uchangezeka kila siku. ");
INSERT INTO nyf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","H'aya, P'aulo na o andziye makira na jimbo ra Furugia na jimbo ra Galatia, mana Roho Mweri waakahaza masihubiri ro neno kahi za jimbo ra Asia. ");
INSERT INTO nyf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ndoo vivii, hatha manafika hehi na Misia, makijeza kwenda Bith'inia ela iye Roho wa Jesu k'aaruhusire mende bule. ");
INSERT INTO nyf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kwa vizho makikira na Misia na makitharamuka bandari ya T'eroa. ");
INSERT INTO nyf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Usiku uwo P'aulo akiona maono, akiona mwanamulume wa Mak'edonia aimire na anamubembeleza na kumwamba, “Vuka udze Mak'edonia ufwavize.” ");
INSERT INTO nyf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Bai arihokala P'aulo adzaona maono gago, fwadziondzola-ondzola na mara mwenga hukiuka kwenda ko Mak'edonia, kwa kukala fwamanya kamare kukala Mulungu anafwiha hukaambire wo Uv̱oro Udzo kuko. ");
INSERT INTO nyf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kwa vizho fuchangira chomboni kula ho T'eroa na fukifururiza mwenga kwa mwenga muhaka kisiwa cha Samoth'irake, na siku ya hiriye fuchangira bandari ya Neapoli. ");
INSERT INTO nyf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Furihouka Neapoli fwakwenda na magulu muhaka Filipi. Mudzi uu were ndo wa kwandza kahi za jimbo riro ra Mak'edonia. Mudzi uu were waakwa ni Arumi nao were ndo anji mumo. Bai fukikala kuko siku za kuthala. ");
INSERT INTO nyf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Na siku ya Sabato irihofika fwawombola wo mudzi na fuchenda hat'u muhoni, kumala haryahu hat'u ambaho Ayahudi ni kuthunganana makavoya. Bai hurihohapata fwakeresi na hukikwatya kunena wo Uv̱oro Udzo wa Mulungu na o anaache mariokala madzire haho mavoyoni. ");
INSERT INTO nyf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kahi za ao mariokala haho kusirikiza, were ni mwanamuche mumwenga aifwaye Lidia wa kula mudzi uifwao Thiyatira. Lidia were ana biashara ya kuguza vithambaa zha zambarau, naye were ni mut'u amuvoyaye Mulungu. K'uzhona zho Bwana akimuvugula moyowe ili akubali garyahu garigokala gananenwa ni P'aulo. ");
INSERT INTO nyf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Badaye iye na nyumbaye marihokala madzabat'izwa, wahusitira akiamba, “Chamba munaona kukala mimi ninamwamini Bwana jeri, be zho zha mu kuku, hindeni mukakale kwangu.” Na lola be akihusitira zhomu sana hatha fukiona baha fwende fukakale ko kwakwe. ");
INSERT INTO nyf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Bai siku mwenga hurihokala hunenda haryahu hat'u ha kuvoya, fwathungana musichana mumwenga wa kitumwa ariyekala ana p'ep'o ariyemuhendya atabiri maut'u gandigoakalira at'u mbereni. Naye were anaangizira p'esa nyinji ao abomue. ");
INSERT INTO nyf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Musichana yuyu wakala akimuthuwa-thuwa P'aulo na siswi angine na kupiga k'ululu na kuamba, “At'u alume aa be ni ahumiki a Mulungu ariye dzulu ya zhosi, nao manamwambiriza ninwi ngira ya kumwakola.” ");
INSERT INTO nyf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Na ut'u uu be ye musichana wauthuwa-thuwa siku nyinji zenye hatha P'aulo vikimusinya. Ndo siku mwenga P'aulo akimugalukira na akimwamba ye p'ep'o, “H'aya, kwa dzina ra Jesu Masihi mwambole kare be vivi!” Na haho henye ye p'ep'o akimwambola ye musichana. ");
INSERT INTO nyf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bai aryahu abomue yuyahu musichana marihoona kukala cho maricho were madzakikuluhira kiangizire p'esa k'akiho kaheri, mamugwira P'aulo na Silasi na makiav̱urura muhaka kwa vilongozi a wo mudzi. ");
INSERT INTO nyf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Makiaika mbere za o abomu na makiamba, “At'u alume aa ni Ayahudi, na manareha fujo kahi za mudzi wehu, ");
INSERT INTO nyf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","kwa kufundisha maadha garigo k'avidimikika siswi Arumi kugagwira na kugathuwa.” ");
INSERT INTO nyf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Bai ro kundi ra at'u rikidzangiza mo h'uwoh'uwoni, na makiaheha o ani P'aulo na Silasi na maneno. Aryahu abomu makitharura-tharura zo nguwo za ani P'aulo na makilagiza matandikwe. ");
INSERT INTO nyf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Vikara marihogonya kutandikwa mahalwa na makitsufwa jela, na iye shikari wa mo jela akilagizwa kwamba ahakikishe k'amachimbirire. ");
INSERT INTO nyf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","K'uzhona zho ye shikari jela arihombirwa gaga, waahala o ani P'aulo na akiangiza kahi za chumba cha ndani mumo jela, na akihala go magulu gao akigafunga gogoni. ");
INSERT INTO nyf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Bai urihofika usiku ukulu, P'aulo na Silasi makala manavoya na kumuimbira maira Mulungu, na aryahu afungwa angine makikala madzahega masikiro kuasirikiza. ");
INSERT INTO nyf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","K'uzhona zho haho henye yo ts'i ikithethema ut'u wa kwangalaza, hatha wo musinji wa iyo jela ukithukuka. Haho henye kimoho moho, yo miryango yosi ikisunduka ngh'aa na kila mut'u yo minyororo ikimuvuguka. ");
INSERT INTO nyf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Bai ye shikari jela akivumbuluka, k'uzhona zho kuyona yo miryango i wazi, akihala wo mushuwe na akikala anamala kudzalaga, mana waona nikwenda o afungwa madzachimbira. ");
INSERT INTO nyf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ela P'aulo arihoona vizho wapiga k'ululu akiamba, “Hatha bule, sidzalage! Hosini huchere mumu!” ");
INSERT INTO nyf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ndo ye shikari jela akilagiza kurefwe mataa. Garihokudza, akingira malo mo ndani ya jela na akidzigwaga mbere za P'aulo na Silasi kuno be anavinwa ni mwiri jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Bai akiahala akiamboza ko ndze, na akiauza akiamba, “Nihendedze athumia mino, hatha niokoke?” ");
INSERT INTO nyf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Makimudzigidzya makimwamba, “Mukuluhire Bwana Jesu, nawe undaokolwa uwe hamwenga na nyumbayo.” ");
INSERT INTO nyf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Gonya makimwambiriza Uv̱oro Udzo wa Mulungu, iye na osini mariokala mo nyumbani. ");
INSERT INTO nyf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Bai ye shikari jela akiamboza na uwo usiku na akiagesa go maranga gao na k'avitoere akibat'izwa iye hamwenga na o adamue osi. ");
INSERT INTO nyf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Gonya ye shikari achenda nao nyumbani kwakwe na achendaambozera chakurya, nao mudzi muzima makikala mana raha, kwa kukala vikara were manamukuluhira Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bai kurihocha aryahu abomu a Kirumi mahuma maofisaa ga kwao gende ko jela makamwambe ye shikari wa jela vivi, “Avugule ao at'u mende.” ");
INSERT INTO nyf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ndo ye shikari wa jela akimwamba P'aulo, “O abomu madzaamba kukala uwe na Silasi muvugulwe mwende. H'aya bai mbolani mwende na dheri.” ");
INSERT INTO nyf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ela P'aulo akiambira o maofisaa akiamba, “Mahupiga mbere za at'u hasiho hatha kunenwa yo k'esi idzaho siswi hu at'u a Kirumi. Mahuhala na makihusindikira jela, vino ati manamala kufwamboza kisiri-siri. Hatha bule, ni madze enye madze mafwamboze ndze.” ");
INSERT INTO nyf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","K'uzhona zho o maofisaa machenda na machendaambira o abomu gago garigokala gadzanenwa ni P'aulo. Marihosikira kukala ao ani P'aulo ni at'u a Kirumi, makihondoka. ");
INSERT INTO nyf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bai makidza na makidzaavoya musamaha ndo makiamboza mo jela na makiambira mawombole wo mudzi. ");
INSERT INTO nyf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","K'uzhona zho P'aulo na Silasi marihombola mo jela, makwenda muhaka nyumbani kwa Lidia, na kuko makithunganana na o ndugu na makiap'a moyo gonya thio makiuka. ");
INSERT INTO nyf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bai kahi za charo chao, P'aulo na Silasi makira na Amufipoli na Apolonia muhaka mudzi wa Th'esalonike ambako were kuna sinagogi ra Kiyahudi. ");
INSERT INTO nyf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Vikara P'aulo achenda mo sinagogini here garizhokala mazowerage. Bai akisumurira na o at'u dzulu za go Maoro kila siku ya Sabato muhaka Sabato t'ahu pu. ");
INSERT INTO nyf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kahi za siku zizi za Sabato wakala akiaeleza o at'u na kuanyesa kukala ye Masihi were k'ana budhi apate thabu na afufuke kula kifwani. P'aulo waamba vivi, “Yuyu Jesu nimwambiraye, be nde iye Masihi.” ");
INSERT INTO nyf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Kusikira vizho, angine kahi zao mashawishika na makigwirana na ao ani P'aulo na Silasi, na Ayunani anji enye mamwagohao Mulungu na anaache anji mario mana nguma mbidzo kahi za wo mudzi nao dzazho, makikuluhira. ");
INSERT INTO nyf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ela aryahu Ayahudi machangirwa ni wivu, na machenda mo masokoni-masokoni na machendaaunga-unga aryahu at'u akora-akora na makiunda kakundi, na makikwatya kuhenda fujo mo mudzini. Machenda malo muhaka nyumbani kwa mut'u mumwenga aifwaye Jasoni kumumala P'aulo na Silasi maarehe mbere za ro kundi ra at'u. ");
INSERT INTO nyf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ela marihofika ko kwa Jasoni k'amaaonere bule, k'uzhona zho mandamuv̱urura Jasoni hamwenga na ndugu angine muhaka mbere za o abomu a wo mudzi, kuno be manapiga k'ululu na kuamba, “O at'u alume madziotholathola yo dhunia be madzire haha, ");
INSERT INTO nyf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","na Jasoni akaakaribisha ko kwakwe nyumbani. At'u alume aa osi, be manazibanda zosi zo sheria za Kaisari kwa kuamba ati kuna muthawali mungine aifwaye Jesu.” ");
INSERT INTO nyf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ro kundi ra at'u na o maofisaa a wo mudzi kusikira vizho, makibudzyika jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bai o maofisaa makimwamba Jasoni na o andziye mamboze bondi, marihomboza, makiarichiza machenda. ");
INSERT INTO nyf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Bai usiku uwo, o ndugu mamuhala P'aulo na Silasi, makiamboza machenda Beroya. Vikara marihofika ko Beroya makwenda kahi za sinagogi ra Kiyahudi. ");
INSERT INTO nyf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Aryahu Ayahudi a Beroya were ni asikizi hatha kushinda aryahu a Th'esalonike. At'u a Beroya marihosikira wo Uv̱oro Udzo, be mauhokera kwa hamu sana na kidza kila siku makikala manashoma go Maoro mahakikishe chamba go arigonena P'aulo ni ga jeri. ");
INSERT INTO nyf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bai anji kahi za o Ayahudi makuluhira na angine mariokuluhira ni anaache a Kiyunani mario na nguma na at'u anji angine alume. ");
INSERT INTO nyf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ela aryahu Ayahudi a ko Th'esalonike marihopata kawee kukala P'aulo anahubiri neno ra Mulungu ko Beroya, kuko nako makikuzhoga na machendalunga kundi ra at'u na makikala ma thayari kugwaga rabusha kuko. ");
INSERT INTO nyf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Aryahu ndugu marihoona kit'u kicho, mamuhala P'aulo mara mwenga na makimwamboza achenda p'wani, Silasi na T'imoth'i o makisala ko Beroya. ");
INSERT INTO nyf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Vikara aryahu at'u mariokwenda na P'aulo, makwenda naye vivii muhaka mudzi wa Athene. Marihokala manauya, P'aulo waahuma madze maambire Silasi na T'imoth'i, masitoe magwirane kuko Athene. ");
INSERT INTO nyf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Bai P'aulo arihokala a kuko kuathariza ani Silasi na T'imoth'i, waona wo mudzi wosi be u thele milungu ya vizuka, ut'u uu be wamushononesa sana. ");
INSERT INTO nyf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kwa vizho kila siku wakala akisumurira na o Ayahudi na aryahu Ayunani mamwagohao Mulungu kahi za sinagogi na kidza akisumurira na o at'u arioaona mo masokoni. ");
INSERT INTO nyf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ndo kuchambola alachu angine a chama cha Epikurio na chama cha Sitoiko, makikwatya kunenezana na P'aulo. Angine kahi zao mauza makiamba, “Ananenani yuno muhayihayi?” Angine o makiamba, “Vinanyesa yuyu mut'u anafundisha dzulu za milungu mijeni.” Nao manena vivi kwa kukala P'aulo were anahubiri dzulu za Jesu na dzulu za kufufukakwe. ");
INSERT INTO nyf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bai makimuhala hatha kirima cha Areopago. Marihofika kuko makimwamba, “H'aya fwambire vikara, hunamala fumanye dzulu za gaga mafundisho masha ufundishago. ");
INSERT INTO nyf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mana fudzakusikira unafundisha maut'u masha uwe, naswi be hunamala humanye yo mana ya gago mafundisho gago.” ");
INSERT INTO nyf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(O at'u osi a Athene na o ajeni mariokala manakala kuko were k'amana rorosi mahendaro hasihokala kukeresi na kusumurira na kunena dzulu za maut'u masha-masha.) ");
INSERT INTO nyf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Bai P'aulo akiungarara kahikahi za wo muthunganano ho Areopago na akiamba, “Nwi at'u a Athene! At'u ninwi ninamona kukala munathuwa dini t'ot'ot'o sana kwa kila upande. ");
INSERT INTO nyf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ela nirihotsembera na kuvilolat'o zho muvivoyazho be naona kijaja kimwenga chenye maoro gaga: ‘KWA MULUNGU ASIYEMANYIKANA.’ Vikara iye muriyemunamuvoya na kuno k'amumumanya be nde ariye ninamala nimwambirize. ");
INSERT INTO nyf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Iye Mulungu ariyeumba urumwengu na zhosi virizho mumo urumwenguni, be nde Bwana wa mulunguni na ts'i, naye be k'aishi kahi za mahekalu garigoakwa ni binadamu. ");
INSERT INTO nyf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Na k'ahumikirwa ni binadamu dza here kwamba anatsowa kit'u, kwa kukala iye nde amugeraye kila mudamu p'umuzi na kumuhendya adime kusoha na nde mulazhi wa vit'u vingine zhosi. ");
INSERT INTO nyf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mulungu waumba makabila gosi ga at'u kula kwa mudamu mumwenga, naye waumba makabila gaga gosi ili gadime kutoa kahi za urumwengu wosi. Na iye mwenye wapanga kare zo siku mandizoishi na ho hat'u mandihokala. ");
INSERT INTO nyf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Mulungu waaumba o anadamu ili madime kumumala na hangine mamufikire na mamone, kwandza hatha k'akure na kila mumwenga wehu. Dza here aimbi enu angine marizhonena na kuamba, ");
INSERT INTO nyf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Iye, nde ahuhendaye hukaishi na hukanenda na hukakala.’ Na pia aimbi angine maamba, ‘Siswi hu anae.’ ");
INSERT INTO nyf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“H'aya bai, kwa kukala hu ana a Mulungu, k'aviv̱irya huone kukala ye Mulungu be a dza here sanamu ya dhahabu hedu ya fedha, hedu ya iwe, ambazho ni vit'u vitengezwazho kwa kuhumira akili ya mudamu. ");
INSERT INTO nyf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Bai haho kapindi makathi ga kutsamanya hatha vivi, ye Mulungu wathuwa kumuricha mudamu ahende zho ahendzazho, ela vivi bai anaamuru kukala at'u osi kila hat'u mathubu. ");
INSERT INTO nyf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kwani iye ana siku adziyoyika ambaho andakudzahukumu wo urumwengu muzima kwa ngira ya hachi, na andahenda vizho kukirira na iye mut'u ariyemutsagula. Iye Mulungu adzawanyesa ut'u uu lwazu kwa kumufufula iye mut'u kula kifwani.” ");
INSERT INTO nyf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Bai o at'u marihosikira uv̱oro dzulu za kufufuka, angine kahi zao mahagwaga kitseko, ela angine o makiamba, “Hundakwiha kaheri udze ufwambire dzulu za kit'u kiki.” ");
INSERT INTO nyf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ndo P'aulo akiuka ho muthungananoni. ");
INSERT INTO nyf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Bai angine makikuluhira na makiungana naye. Kahi za at'u ao mariokuluhira were ni Dionisio, mufuasi wa o at'u mariokala makithunganana ho Areopago, na mwanamuche mumwenga aifwaye Damarisi, na angine-angine. ");
INSERT INTO nyf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bada ya kunena na o at'u ho Areopago, P'aulo wauka ko Athene na achenda Korintho. ");
INSERT INTO nyf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kuko Korintho akithunganana na Muyahudi mumwenga aifwaye Akw'ila. Mut'u yuyu Akw'ila wazhalwa P'onito, na mo Athene were wakudza dzuzi-dzuzi iye na muchewe aifwaye P'urisila, nao were mambola Italiya, mana were Kilaudio, muthawali mubomu wa Kirumi wamboza amulo kukala o Ayahudi osi makwambole ko Rumi. Bai P'aulo achenda ili makaonane. ");
INSERT INTO nyf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Marihoonana, P'aulo watoa hamwenga nao na makihenda kazi ya kutengeza mahema osini, mana P'aulo were ni fundhi wa mahema dza here o ani P'urisila na Akw'ila. ");
INSERT INTO nyf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kidza P'aulo wakala akisumurira na Ayahudi na Ayunani kahi za sinagogi kila siku ya Sabato kujeza kuavuha. ");
INSERT INTO nyf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Vikara Silasi na T'imoth'i marihokudza kula Mak'edonia, P'aulo wakala akihumira wakathiwe wosi kuhubiri, na kumboza ushahidhi kwa o Ayahudi kukala ye Jesu be nde iye Masihi. ");
INSERT INTO nyf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ela aryahu Ayahudi marihomukanaiza P'aulo na kumuhukana-hukana, iye P'aulo wahala zo nguwoze akizikut'a-kut'a kunyesa kukala mandamanya enye, akiamba, “Mundamanya enye muchangamika, mut'u mimi be simo. H'aya kula vivi be ninenda kwa aryahu at'u mario si Ayahudi.” ");
INSERT INTO nyf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","P'aulo achambola mo sinagogini na achenda nyumbani kwa mut'u mumwenga aifwaye Titio Jusito, ambaye ni mut'u ariyekala akimuvoya Mulungu. Nyumbaye mut'u yuyu yere i hehi na ro sinagogi. ");
INSERT INTO nyf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Bai mubomu mumwenga wa ro sinagogi aifwaye K'irisipo wamukuluhira Bwana Jesu, iye hamwenga na nyumbaye, na kidza Akorintho anji marihomusikira P'aulo, makuluhira na makibat'izwa. ");
INSERT INTO nyf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","K'uzhona zho usiku mumwenga Bwana akinena na P'aulo kahi za maono, akiamba, “Sogohe bule, enderera kufundisha at'u thuwe, usinyamale bule ");
INSERT INTO nyf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mimi ni hamwenga nawe, na k'ahana mut'u yoyosi andiyekuvamia kukuhenda ut'u wowosi uwi, kwa kukala kahi za mudzi uu be nina at'u a kwangu anji enye.” ");
INSERT INTO nyf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kwa vizho P'aulo akikala ko Korintho kwa muda wa mwaka mumwenga na nusu kuafundisha o at'u neno ra Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Vikara wakathi Galio arihokala luwali wa jimbo ra Akaia, Ayahudi angine maungana na machendamugwira P'aulo makidza naye kotini. ");
INSERT INTO nyf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Makiamba, “Mut'u yuyu anajeza kuavuha at'u ili mamuvoye Mulungu kahi za ngira ambazo be zi kinyume na sheria yehu.” ");
INSERT INTO nyf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Bai P'aulo arihokala anamala kuvugula mulomo anene, Galio wamukirira mbere na akiambira o Ayahudi, akiamba, “Kalaho ut'u uu muambawo be ni dzulu za kihendo kii hedu uthiriri fulani, be ningere sina budhi kumusirikiza. ");
INSERT INTO nyf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ela kwa kukala maut'u gaga ganahusu madzina na maneno genu na sheria yenu enye, be sindatosa maut'u gago, hatha be gabambanyeni enye.” ");
INSERT INTO nyf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kwa vizho akiainga mo kotini. ");
INSERT INTO nyf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ndo osi makimugwavukira Sosithene, mubomu wa sinagogi makimutandika mbere za yo koti, ela Galio k'avirungire. ");
INSERT INTO nyf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bai P'aulo wakala ko Korintho siku za kuthala, gonya akilagana na o ndugu na achangira chomboni akikwatya kwenda Siria, iye hamwenga na P'urisila na Akw'ila. Ela bai kabila k'adzauka wahala zo nyereze akizinyola ko K'enikirea, mana were wapiga hathi kwa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","H'aya nao ndoo vivii muhaka Efeso, kuko akiaricha o ani P'urisila na Akw'ila. Bai iye P'aulo achenda kahi za sinagogi na akisumurira na o Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Badaye o Ayahudi makimuvoya P'aulo akale hamwenga nao kwa muda, ela akikahala. ");
INSERT INTO nyf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ela hatha vizho arihokala akuukani waalaga akiamba, “Nindauya kaheri Mulungu ahendzaho.” Ndo achangira chomboni akiuka ko Efeso. ");
INSERT INTO nyf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Bai ndeye vivii, hatha akifika Kaisaria, arihofika kuko wambuka Jerusalemu kwendalamusa ro kanisa gonya akitharamuka Anitiokia. ");
INSERT INTO nyf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kuko Anitiokia wakala kwa muda gonya akikulaa na achenda kuno na kuno kahi za jimbo ra Galatia na Furugia kuap'a moyo o anafundzi. ");
INSERT INTO nyf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Vikara kahi za wakathi uwo Muyahudi mumwenga aifwaye Apolo, ambaye wazhalwa Alekizandiria wazhoga mo Efeso. Mut'u yuyu were anamanya kunena na kidza were anamanya Maoro t'ot'ot'o sana. ");
INSERT INTO nyf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Visithoshe, were wafundishwa kahi za ngira ya Bwana Jesu, naye were akinena be ananena na nguvuze zosi na were akifundisha anafundisha karakara dzulu za Jesu, ela were anamanya ubat'izo wa Johana thu h'akeye. ");
INSERT INTO nyf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Bai Apolo akikwatya kunena kahi za ro sinagogi hasiho woga. K'uzhona zho P'urisila na Akw'ila marihomusikira mamuhala machenda naye nyumbani kwao na machendamugunulira yo ngira ya Mulungu t'ot'ot'o zaidhi. ");
INSERT INTO nyf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Wakathi arihokala anamala kuvuka ende Akaia o ndugu ko Efeso mamup'a moyo na makimugwiza baruwa akaap'e o anafundzi kuko ili mamukaribishe, kuko Akaia. Bai arihofika kuko waaviza sana o at'u mariokala makuluhira kwa kukirira kwa zo mbazi za Mulungu, ");
INSERT INTO nyf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","kwani mut'u iye waadhima o Ayahudi na manenoge mbere za at'u, waanyesa kwa kuhumira Maoro, kukala ye Jesu be nde iye Masihi. ");
INSERT INTO nyf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Vikara wakathi arihokala ye Apolo a ko Korintho, P'aulo wagwira ngira ya ndani-ndani muhaka ko mudzi wa Efeso. Bai kuko Efeso wathekeza anafundzi kuko, ");
INSERT INTO nyf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","na akiauza akiamba, “Vidze mwamuhokera Roho Mweri wakathi murihomukuluhira Jesu?” Makidzigidzya makiamba, “Hatha. Mwandzo tha zho zha kuna kit'u kiifwacho Roho mweri, k'afudzavisikira.” ");
INSERT INTO nyf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ndo P'aulo akiauza akiamba, “Vikara ndo fuambe, mwahokera ubat'izo hiwo?” Makidzigidzya makiamba, “At'u siswi fwahokera ubat'izo wa Johana siswi.” ");
INSERT INTO nyf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","P'aulo akiamba, “Uryahu ubat'izo wa Johana h'e, were ni ubat'izo wa kuthubu. Iye Johana waambira at'u mamukuluhire iye ariyekala andakudza nyumaze, ambaye ni Jesu.” ");
INSERT INTO nyf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bai o at'u marihosikira vizho, mabat'izwa kwa dzina ra Bwana Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","P'aulo arihoaikira mikono, makihokera Roho mweri na makinena na luga na makinena ga Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","At'u aa were manafika alume kumi na airi. ");
INSERT INTO nyf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bai P'aulo wakala achangira kahi za sinagogi na kunena lwazu-lwazu hasiho woga, naye wahenda vivi kwa muda wa miezi mihahu. Wanena na o at'u na kuashawishi dzulu za uthawali wa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ela hatha vizho angine kahi za o at'u mahenda singo nyomu, makahala kukuluhira na makinena mai dzulu za yo ngira ya Jesu lwazu-lwazu. Kwa vizho P'aulo akiaricha na akiahala o anafundzi na achenda kahi za sikuli ya T'irano na kuko akikala kaziye ni kusumurira na at'u kila siku. ");
INSERT INTO nyf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Naye P'aulo be ut'u uu wauthuwa-thuwa hatha miaka miri pu, bai o Ayahudi osi na Ayunani mariotoa kahi za jimbo ra Asia marisikira ro neno ra Bwana Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mulungu wahenda maut'u manji ga kwangalaza kukirira kwa P'aulo. ");
INSERT INTO nyf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Hatha vithambaa zhenye na mikumbuu ya mwirini mwakwe, yahalwa ikihirikirwa akongo, nao makihozwa go makongo gao na o p'ep'o makiambola. ");
INSERT INTO nyf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Vikara kwereko Ayahudi angine mariokala makidengereka na kupunga p'ep'o. Bai makijeza kuhumira dzina ra Jesu dzulu za ao mariokala mapagawa ni p'ep'o, makiamba, “H'aya nakuamuru umbole kahi za dzina ra yuyahu Jesu ahubiriwaye ni P'aulo.” ");
INSERT INTO nyf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bai kwere kuna athana afungahe mariokala manahenda kit'u kiki, nao were ni ana a mulombi mubomu wa Kiyahudi aifwaye Sikeva. ");
INSERT INTO nyf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bai marihohenda kit'u kicho ye p'ep'o wadzigidzya akiamba, “Ye Jesu namumanya, na P'aulo naye namumanya, h'aya nwi nanwi mu ano h'ani?” ");
INSERT INTO nyf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Gonya ye mut'u mwenye p'ep'o akiathulukira na akiadhima nguvu osi, akiahenda kazi, hatha manapata mwanya wa kuchimbira, milatso ni voo, kuno mahuhu renye. ");
INSERT INTO nyf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bai o Ayahudi na Ayunani matoao Efeso, marihovipata p'eho vivi madzalwa ni woga osi na ro dzina ra Bwana Jesu rikilikwa jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bai at'u anji kahi za o mariokuluhira makudzasema go mahendo gao mai lwazu-lwazu. ");
INSERT INTO nyf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Anji kahi za aryahu mariokala manathuwa maut'u ga utsai mareha go mabuk'u gao ga utsai makigakundzumanya hamwenga makigaocha at'u manalola. Bai marihopiga isabu ya cho kima cha mabuk'u gago, mapata kukala gana kima cha vipande alifu mirongo mitsano zha fedha. ");
INSERT INTO nyf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kwa ut'u uwo, ro neno ra Bwana Jesu ratsamuka kila hat'u na rikikaza kuhenda nguvu. ");
INSERT INTO nyf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bada ya maut'u gaga kukala, P'aulo wakat'a shauri kwenda Jerusalemu, kukirira Mak'edonia na Akaia. Akiamba, “Nindihofika kuko, vindanibidhi kwa zho zhosi nizhoge Rumi nako.” ");
INSERT INTO nyf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Bai akiahala at'u airi kahi za avizi a kwakwe na akiahuma ko Mak'edonia. At'u aa were ni T'imoth'i na Erasito. Ye P'aulo mwenye akisala kahi za ro jimbo ra Asia vichache. ");
INSERT INTO nyf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Bai kahi za wakathi uwo-uwo kwahenda h'uwoh'uwo ko Efeso dzulu za yo Ngira ya Jesu. ");
INSERT INTO nyf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Were kuna musanyi mumwenga wa fedha aifwaye Demetirio. Mut'u yuyu Demetirio wakala akisanya sanamu za fedha zirizohalana na Hekalu ra mulungu muche aifwaye Aritemi, naye wakala akiangizira faidha sana o mafundhi. ");
INSERT INTO nyf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kwa vizho akiakundzumanya hamwenga o mafundhi hamwenga na at'u angine mariokala mana kazi dza zizo akiamba, “Asena, ninwi munamanya kukala kazi ii inahup'a mapato madzo genye. ");
INSERT INTO nyf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Na vikara amba munaona na munasikira vino, yuno bwana aifwaye P'aulo arizho anaavuha at'u anji a Efeso na kuagaluza, kwa kuambira kukala milungu ya kuhenda kutengezwa ni at'u si milungu bule. Na ut'u uu k'auhenda haha Efeso h'akeye, anauhenda kahi za jimbo rosi ra Asia. ");
INSERT INTO nyf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Vikara hathari iriyo haho ni kwamba yo kazi yehu indav̱udhywa. Hiri, hekalu ra mulungu mubomu wehu wa kiche be k'arindaonewa kit'u bule na hatha ye mwenye naye dzazho. Aritemi anavoywa kila hat'u kahi za jimbo ra Asia na kahi za urumwengu muzima, bai kit'u kiki kindahenda ahokwe yo ishimaye.” ");
INSERT INTO nyf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bai ro kundi ra mafundhi ririhosikira vizho ratsukirwa vii-vii na rikikwatya kupiga k'ululu na kuamba, “Aritemi wa Aefeso nde mubomu!” ");
INSERT INTO nyf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Na lola k'avitoere kila mut'u kahi za wo mudzi akikala ni h'uwoh'uwo thu. Bai o at'u marihokala makwendani, maagwira anaalume airi, Gayo na Arisitariko na machenda nao malo muhaka kahi za wo uwanja mubomu wa mikut'ano. At'u aa Gayo na Arisitariko were ni at'u a Mak'edonia mariokala manasafiri na P'aulo. ");
INSERT INTO nyf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","H'aya, P'aulo naye akikala anamala kwangira mo kundini ajeze kusumurira na o at'u, ela aryahu anafundzi makimukahaza. ");
INSERT INTO nyf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Angine kahi za aryahu abomu a ro jimbo, ambao were manaeleana na P'aulo, mahuma uv̱oro kwa P'aulo kwendamubembeleza kwamba asithathe kwangira mo uwanjani. ");
INSERT INTO nyf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Bai wakathi uwo ro kundi rosi ra at'u rakala ni fujo t'uhu. Angine were manaamba vino, na arya manaamba vino. Anji kahi za o at'u mariokala haho were k'amamanya kala ma haho muthungananoni kwanoni. ");
INSERT INTO nyf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bai o Ayahudi makimugwira mwanamulume mumwenga aifwaye Alekizanda na makimusukuma ho mbere, mana angine kahi za ro kundi maona kukala iye nde ariye anahusika. Bai ye Alekizanda akiavungira mikono manyamale, ili adzihehere. ");
INSERT INTO nyf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ela marihogundua kukala ye Alekizanda ni Muyahudi, osi mapiga k'ululu kwa umwenga kwa muda wa here masaa mairi vivi, kuno manaamba, “Aritemi wa Aefeso nde mubomu!” ");
INSERT INTO nyf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mwishowe ye karani wa wo mudzi akiambira o at'u manyamale. Akiamba, “Nwi at'u a Efeso! Ni h'ani kahi za urumwengu wosi asiyemanya kukala mudzi wa Efeso ndo murindzi wa ro Hekalu ra Aritemi, mulungu wehu mubomu? Hedu ni h'ani asiyemanya kukala mudzi wa Efeso ndo murindzi wa yo sanamuye iriyohenda kugwa kula mulunguni? ");
INSERT INTO nyf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Bai k'akuna mut'u adimaye kukanaiza maut'u gaga. Kwa vizho at'u ninwi h'e, hurirani na maut'u gaga sigahalireni maruru. ");
INSERT INTO nyf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","At'u ninwi mudzaareha haha aa anaalume, idzaho k'amaiyire vit'u zha hekaluni hedu hatha kumukufuru mulungu wehu muche. ");
INSERT INTO nyf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Bai chamba Demetirio na o mafundhi andziye mana neno na mut'u yoyosi atungwaye, h'aya makoti ga wazi na atosi a maneno nao ma haho, na mende makashithaki. ");
INSERT INTO nyf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ela chamba kuna maut'u mangine zaidhi mumalago, h'aya be gago gandabambanywa kahi za mukut'ano wa hilali. ");
INSERT INTO nyf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kwani vivi virizho, be fu hatharini, hunadima kushithakiwa kwa fujo ii idziyokala rero. Fujo ii ya rero be k'aina sababu ya mana, na hukishithakiwa be k'ahundadima kuvinenat'o bule.” ");
INSERT INTO nyf_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Bai arihogonya kunena vivi, akiubanda wo mukut'ano. ");
INSERT INTO nyf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Vikara bada ya ro h'uwoh'uwo ko Efeso kuhurira, P'aulo wahuma at'u makaaihe o anafundzi. Bai marihokudza, waaadha gonya akilagana nao, akiuka kwenda Mak'edonia. ");
INSERT INTO nyf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Naye wakirira kahi za jimbo riro na akinena manji ga kuap'a moyo o at'u mariomukuluhira Jesu muhaka akifika ts'i ya Ayunani. ");
INSERT INTO nyf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Akikala kuko kwa muda wa miezi mihahu. Vikara arihokala a hehi na kwenda Siria, wagundua kukala o Ayahudi were manatsila kumuhendera kit'u kii, kwa vizho akiona baha auye na Mak'edonia. ");
INSERT INTO nyf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bai kahi za cho charoche, wakwenda na Sopatiro mwana wa P'uro kula Beroya na Arisitariko na Sekundo ambao ni at'u a Th'esalonike, na Gayo wa kula Deribe na T'imoth'i. Tukiko na T'erofimo, kula kahi za jimbo ra Asia makwenda na P'aulo pia. ");
INSERT INTO nyf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bai at'u aa mathangulia na machendahuthariza ko T'eroa. ");
INSERT INTO nyf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Sino swi fuchangira chomboni kula Filipi bada ya sikuk'uu ya Mikahe Iso Ts'ats'u kugoma na fukikwatya kwenda. Bai fukigwirana na o andziyehu ko T'eroa bada ya siku ts'ano, naswi bai fukikala kuko T'eroa kwa muda wa siku fungahe. ");
INSERT INTO nyf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Vikara irihofika siku ya kwandza ya wiki, fwakwendakundzumanyika fukirya mikahe hamwenga. ");
INSERT INTO nyf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Vikara kahi za kicho chumba cha dzulu hurimokala hudzathunganana mwere muna mataa manji. ");
INSERT INTO nyf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Bai hakikala hana muvulana mumwenga aifwaye Yutiko akeresi dhirishani. Wakathi P'aulo anaenderera kunena, yuyu muvulana wagwirwa ni uts'indzizi akilala. Vikara arihokala arere, watsuluka kula yo gorofa ya hahu furimokala akigwa, tha manendamutsola akikala adzafwa kare. ");
INSERT INTO nyf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","K'uzhona zho P'aulo akithima na achendadzigwaga dzuluze ye Yutiko na akimulinga mikonoye akiamba, “Musihondoke bule, a moyo yuyu!” ");
INSERT INTO nyf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Gonya P'aulo akiuya kahi za cho chumba cha dzulu na achendamogola mukahe akirya. Bai akienderera kusumurira na o at'u hatha ngh'aa, ndo h'aya, akiuka. ");
INSERT INTO nyf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Aryahu at'u makimuhala yuyahu muthana machenda naye mudzini kuno a moyo, nao be makidzalwa ni raha jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","H'aya vikara siswi fukithangulia kwenda ko Aso kahi za chombo, ambako kuko were ndo hundikomupakia P'aulo. Iye P'aulo walagiza kukala akahalwe kuko mana were anenda kuko na magulu. ");
INSERT INTO nyf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Bai arihofona ko Aso, fwamuhala na fukimupakia mo chomboni na fuchenda Mitulene. ");
INSERT INTO nyf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Siku ya hiriye, fwauka Mitulene na cho chombo kicho, fuchenda muhaka kisiwa cha Kio. Bai kurihocha fwavuka fuchenda kisiwa cha Samo, na yo siku iriyothuwiriza fwakala fudzafika Mileto. ");
INSERT INTO nyf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Vikara P'aulo kahi za charo kiki akikala lengore ni ahavunge ho Efeso, mana were k'endzi kungamiza wakathi kahi za ro jimbo ra Asia, kwani were anawania, ngaa afike ko Jerusalemu siku ya Pentekote. ");
INSERT INTO nyf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Bai P'aulo arihokala a ko Mileto, wahuma at'u mende Efeso makaaihe o azee a kanisa kuko. ");
INSERT INTO nyf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Vikara marihokala o azee a kanisa madzire, P'aulo wanena nao akiamba, “At'u ninwi munamanya viryahu ambazho nakala nanwi kula iryahu siku ya kwandza nirihozhoga Asia. ");
INSERT INTO nyf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mut'u mimi be namuhumikira Bwana hasiho kudzionya kamare. Namuhumikira Mulungu kwa matsozi na kwa majezo garigonipata kukirira kwa zo njama za Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ninwi munamanya kukala mimi sikalire mwomu wa kuhubiri ut'u wowosi ambawo ungamwaviza, mana namufundisha mbere za at'u na mo nyumba-nyumba. ");
INSERT INTO nyf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mut'u mimi naambiriza o Ayahudi na Ayunani wo ut'u umwenga, kwamba suthi mamugalukire Mulungu kwa kuthubu na mamukuluhire Bwana wehu Jesu Masihi. ");
INSERT INTO nyf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Bai vivi lolani ninasikira nasukumwa ni Roho nende Jerusalemu, nami simanya ndapatwa ni ut'u wani kuko. ");
INSERT INTO nyf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nimanyacho ni kukala ninatharizwa ni kifungo na mashaka manji kuko, here Roho Mweri adzizhonambira. Kwani kahi za kila mudzi iye nikunambira zho vindizhokala. ");
INSERT INTO nyf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ela hamwenga na vizho sigaona go maisha gangu kukala ni kit'u. Nivoyacho ni kwamba ngaa nimarigize wo mwendo na nimarigize iryahu kazi niriyogerwa ni Bwana Jesu, ambayo ni kunena wo Uv̱oro Udzo dzulu za mbazi za Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Vikara lolani, mut'u mimi namanya kamare ninwi nyosini niriomudengerekera na kumwambiriza wo uthawali, be k'amundanona kaheri. ");
INSERT INTO nyf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kwa vizho ninamwambira vivi rero kukala sina lawama ya mut'u yoyosi ariye k'andaokolwa. ");
INSERT INTO nyf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mana namwambiriza dzulu za malengo gosi ga Mulungu hasiho kumufitsa kit'u. ");
INSERT INTO nyf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bai dzimanyirireni ninwi enye, na kidza murimanyirire ro badhi rosi ambaro Roho Mweri wamuhendya mukale aimirizi a riro, ili mukale arisa a ro kanisa ra Mulungu ambaro warigula kwa milatso ya mwanawe Jesu Masihi. ");
INSERT INTO nyf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Namanya nindihokala dzauka, ko nyuma kundakudza at'u mario ni here mbawa av̱ara kahi zenu, nao k'amandarionera mbazi bule ro badhi. ");
INSERT INTO nyf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","H'aya zho mbai, kundatsumbuka angine kahi za ninwi enye, ambao mandahala wo ujeri na kuugaluza ulongo, ili madzipatire anafundzi mandiothuwa go gao. ");
INSERT INTO nyf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kwa vizho be dzimanyirireni! Musisahau bule kukala namukanya kila mumwenga wenu na matsozi kwa muda wa miaka mihahu usiku na mutsana. ");
INSERT INTO nyf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Vikara, ninamuvoyera Mulungu akale hamwenga nanwi, murimanye nenore ra mbazi na rimujenge. Kwani riro nenore ndo ridimaro kumup'a ninwi muthalo hamwenga na at'u angine osi mariotsagulwa ni Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mut'u mimi sihendere dzitso na p'esa za mut'u, hedu hatha nguwoye. ");
INSERT INTO nyf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ninwi enye munamanya kukala nahenda kazi na mikono yangu yenye kwa ut'u wa nipate mahitaji gangu mimi na ga andzangu mariokala hamwenga nami. ");
INSERT INTO nyf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nami kahi za maut'u gosi nirigogahenda, namwanyesa kukala kazi k'omu ya samupuli ii be funav̱irya fuihende kuaviza aryahu ambao ni anyonge kuno fukikumbukira garyahu maneno ga Bwana Jesu kukala, ‘Ni baha kulazha kuriko kuhokera.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Bai arihogonya kunena vivi ye P'aulo wapiga mavindi hamwenga nao na akivoya. ");
INSERT INTO nyf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nao makirira osini kuno manamudzagamira na kumudonera. ");
INSERT INTO nyf_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kirichoangiza kigondzi zaidhi ni viryahu arizhoamba kukala k'amandamona kaheri. Bai badaye makimwamboza muhaka ko chomboni. ");
INSERT INTO nyf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Bai fukihenda kudzinyothola kwa o azee a kanisa ko Efeso na fuchangira chomboni fukifururiza mwenga kwa mwenga muhaka kisiwa cha Kosi. Siku ya hiriye fuchenda Rodo na hurihombola ko Rodo fwakwenda bandari ya Patara. ");
INSERT INTO nyf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kuko Patara hukiona chombo kingine ambacho were kindavuka kwenda Fonike, kwa vizho fuchendapanda na fuchenda. ");
INSERT INTO nyf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Bai fwakwenda vivii muhaka fukiona kisiwa cha Kuporo kwa kure, h'aya fukikikira na kwa mwaka cho kisiwa, fuchenda. Bai fuchenda vivii muhaka Siria na fukithima ko bandari ya Tiro, mana kuko cho chombo were kindathinya mizigo. ");
INSERT INTO nyf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Bai hukiamala o anafundzi kuko, furihoaona fukikala hamwenga nao kwa muda wa siku fungahe, nao kukirira na ye Roho makimwamba P'aulo asende bule ko Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ela wakathi wehu urihogoma, fwauka na fukienderera na charo chehu. Furihokala fukwendani, o at'u mariomukuluhira Jesu hamwenga na ache ao na ahoho ao mafwamboza vivii muhaka ndze ya wo mudzi, na hosi hukipiga mavindi hukivoya. ");
INSERT INTO nyf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Gonya ndo hukilagana, sino fuchangira mo chomboni, nao makigaluka kuuya kwao. ");
INSERT INTO nyf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Bai hukiuka ko Tiro, naswi ndiswi vivii muhaka Putolemai, kuko bai hukialamusa o ndugu na hukisinda nao siku iyo. ");
INSERT INTO nyf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Siku ya hiriye fukiuka na fuchenda Kaisaria, na kuko Kaisaria fwakwendatoa kahi za nyumba ya Filipu ariye were ni muhubiri wa Uv̱oro Udzo kidza were ni mumwenga kahi za aryahu at'u afungahe mariotsagulwa ko Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Mut'u yuyu were ana asichanae ane mario were k'amadzahalwa nao were mana vigerwa zha unabii. ");
INSERT INTO nyf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Vikara hurihokala hudzagonya siku za kuthala haho, hakudza nabii mumwenga aifwaye Agabo kula Judea. ");
INSERT INTO nyf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Bai nabii yuyu wakudza hatha ho hurihokala, akihala ukanda wa P'aulo na akidzifunga yo mikono na go magulu na akiamba, “Vivi ndo aambazho ye Roho Mweri, kukala, ‘Kahi za ngira ii nidzizhodzifunga be o Ayahudi ko Jerusalemu ndizho mandizhomufunga yuyu mwenye ukanda uu, nao mandamuhala na mamulazhe kwa at'u mario si Ayahudi.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Hurihosikira gago, siswi hamwenga na o at'u a kuko fwamusitira P'aulo asimbuke kwenda Jerusalemu bule. ");
INSERT INTO nyf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ela ye P'aulo akihudzigidzya akiamba, “Mbona munarira na kunibanda moyo namuna ino kaheri? Mut'u mimi h'e, si thayari kufungwa thu h'akeye, ela ni thayari kufwa ko Jerusalemu kwa ut'u wa dzina ra Bwana Jesu.” ");
INSERT INTO nyf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Bai arihokala P'aulo k'abembelezeka, fwaviricha na fukiamba, “Navikale here Mulungu ahendzazho bai.” ");
INSERT INTO nyf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Bai bada ya gaga fwadziondzola-ondzola na fuchambuka kwenda Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Angine kahi za o anafundzi ko Kaisaria makwenda hamwenga naswi muhaka makifwangiza nyumbani kwa mut'u mumwenga aifwaye Munasoni, ambako were ndo hundikokala. Munasoni were ni mut'u wa kula Kuporo na kidza were ni mumwenga kahi za o at'u mariokala mamukuluhira Jesu kapindi. ");
INSERT INTO nyf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Vikara furihofika Jerusalemu, o ndugu mahukaribishat'o na raha. ");
INSERT INTO nyf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Bai siku ya hiriye, P'aulo wagwirana naswi na fuchendamona Jakobu. Hunafika kuko, o azee osi a ro kanisa makikala ma haho. ");
INSERT INTO nyf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","H'aya, P'aulo akialamusa tha go, gonya akiadondolera kila kit'u arichokala ye Mulungu wakihenda kwa o at'u mario si Ayahudi kukirira kwa uhumikiwe. ");
INSERT INTO nyf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Na lola marihosikira vivi mamulika Mulungu, gonya makimwamba P'aulo, “Unaona mwanehu zho marizho Ayahudi maalifu na maalifu makuluhira, na osini bai mana chadi na yo Sheria jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bai ao mapata kawee dzuluzo, kukala unaafundisha o Ayahudi matoao kahi za ts'i za at'u mario si Ayahudi kukala mailozere mongo yo Sheria ya Musa. Manaamba uwe unaambira masingize lwembeni ana ao hedu hatha kuishi karakara na maadha gehu. ");
INSERT INTO nyf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","H'aya, vikara vino be fundahendadze? Mana kwa zhozhosi ao mandasikira kukala udzire. ");
INSERT INTO nyf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Uwe, henda vivi fundizhokwambira. Hana anaalume ane haha mario mapiga hathi kwa Mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Bai ahale at'u aa na ugwirane nao kahi za adha ra kudzitsusa kwao, arihire zo garama zao ili manyole zo nyere zao. Ukihenda vizho kila mut'u andamanya kukala gago marigombirwa dzuluzo ni ga ulongo, ela ni kwamba hatha uwe mwenye nawe kidza unaishi karakara na yo Sheria iambazho na unayogoha. ");
INSERT INTO nyf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ela, dzulu za aryahu mariomukuluhira Jesu na si Ayahudi, siswi fwaaorera dzulu za gago furigogakizisha, kukala at'u ao ni masirye chakurya kidzichombozerwa sadaka vizuka na masirye mulatso, na masirye nyama madziohenda kushongolwa na masizinge.” ");
INSERT INTO nyf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bai siku ya hiriye P'aulo waahala aryahu anaalume na akidzitsusa hamwenga nao, gonya ndeye vivii muhaka kahi za ro Hekalu kwendalazha mbadha ya ho zindihogomera zo siku za adha ra kudzitsusa na kila mumwenga wao amboze sadaka. ");
INSERT INTO nyf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Vikara ziryahu siku fungahe zirihokala zi hehi na kugoma, Ayahudi angine kula jimbo ra Asia mamupesa mo Hekaluni ye P'aulo. K'uzhona zho makirilunga rosi ro kundi ra at'u na makimugwira, ");
INSERT INTO nyf_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","kuno manapiga k'ululu na kuamba, “H'aya, alume a Iziraeli fwavwizeni! Yuyu be nde yuyahu mut'u afundishaye at'u osi kila hat'u kinyume cha o at'u ehu na kinyume cha yo Sheria yehu na kinyume cha hat'u haha. H'aya zho mbai, adzire na Ayunani mumu ndani za muhala wa ro Hekalu na hakangizwa nyenye haha hat'u haeri.” ");
INSERT INTO nyf_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(O at'u manena vizho kwa kukala were madzamona T'erofimo ariye ni mut'u wa Efeso, ko kahi za wo mudzi na were yu hamwenga na P'aulo, kwa vizho makiona kukala P'aulo adzakwenda naye kahi za wo muhala wa ro Hekalu.) ");
INSERT INTO nyf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Bai wo mudzi wosi ukidzala fujo t'uhu, na o at'u makidza malo arya madzambola na kuno na arya madzambola na kurya, h'aya thio makidzamugwira P'aulo na makimuv̱urura muhaka ko ndze ya wo muhala wa ro Hekalu, na haho henye yo miryango ya ro Hekalu ikifungwa kare. ");
INSERT INTO nyf_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Vikara marihokala manajeza kumukot'a ye P'aulo, ye mubomu wa majeshi ga Kirumi wapata p'eho kukala wo mudzi wosi wa Jerusalemu u thele fujo. ");
INSERT INTO nyf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Bai arihosikira vizho, akiuka kare, akihala maofisaa sehemu na shikari nao sehemu, naye h'aya akitharamuka ko kwenye ro kundi ra at'u. Vikara o at'u marihomona ye mubomu wa majeshi, makiricha kuryahu kumupiga ye P'aulo. ");
INSERT INTO nyf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ndo yuyahu mubomu wa majeshi akidzamugwira ye P'aulo na akilagiza afungwe na minyororo miri. Ndo akiuza chamba ye mut'u ni h'ani na adzahendadze. ");
INSERT INTO nyf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Angine kahi za ro kundi makipiga k'ululu, ano manaamba vino na arya manaamba virya. Bai ye mubomu wa majeshi k'adimire kumanya wo ujeri uhiho kwa ut'u wa ro h'uwoh'uwo, kwa vizho akilagiza kwamba ye P'aulo ahirikwe ko k'ambini. ");
INSERT INTO nyf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Vikara P'aulo arihofika ho ngazini, zo fujo za ro kundi zangezeka zhomu hatha vikibidhi o shikari mahende kumwanula dzulu-dzulu kamare. ");
INSERT INTO nyf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ro kundi ririrokala nyuma rakala rinapiga k'ululu thu na kuamba, “Mwalageni iye!” ");
INSERT INTO nyf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","K'uzhona zho aryahu shikari marihokala ma hehi na kumwangiza P'aulo mo k'ambini, ye P'aulo wanena na ye mubomu wa jeshi akiamba, “Namala ninene ut'u, vidze nadima?” Ye mubomu wa jeshi akimuza akiamba, “Ala, kudzi unamanya Kiyunani we? ");
INSERT INTO nyf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","We k'uyuyahu Mumisiri ariye ho nyuma-nyuma wajeza kupindua sirikali na akilongoza magaidhi alifu ne, akigamboza achenda nago ko nyika?” ");
INSERT INTO nyf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","P'aulo akidzigidzya akiamba, “Hatha bule, mut'u mimi ni Muyahudi kula T'ariso kahi za ts'i ya Kilikia. Ni mut'u nambolaye kahi za mudzi ambawo si muthithe bule. Vikara navoya vichadimikika nisumurire na aa at'u.” ");
INSERT INTO nyf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Bai ye mubomu wa majeshi arihomup'a ruhusa, P'aulo waungarara ho ngazini na akiavungira mukono o at'u, marihokala madzahurira, akinena nao kwa Kieburania akiamba, ");
INSERT INTO nyf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ndugu zangu na ano baba, namala musikize viryahu nindizhodzihehera.” ");
INSERT INTO nyf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Bai marihosikira ananena nao kwa Kieburania, makaza kuhurira hu. Ndo P'aulo akiamba, ");
INSERT INTO nyf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Mut'u mimi ni Muyahudi mimi, nazhalwa T'ariso mudzi uriwo ko Kilikia, ela narerwa kahi za mudzi uu wa Jerusalemu. Nafundishwa sheria yosi ya akare ehu t'ot'ot'o ni Gamalieli na nakala na chadi na Mulungu dza vizho murizho ninwi nyosini vivi rero. ");
INSERT INTO nyf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Naatesa o at'u mathuwao Ngira ii ya Jesu na hatha nikialaga. Naagwira ache kwa alume na nichendaatsuha jela. ");
INSERT INTO nyf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ye Mulombi mubomu mwenye na ro Baraza rosi manadima kumboza ushahidhi wa gaga ninenago. Mimi nahokera baruwa kula kwa o alombi abomu na ro Baraza ra athumia, baruwa iyo were yaorerwa o Ayahudi a Damesiki. Bai nichenda ili nikaagwire, nidze nao Jerusalemu here mahabusu ili madze mangizwe akili. ");
INSERT INTO nyf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Vikara nirihokala kahi za cho charo changu mo ngirani, hehi na Damesiki, murongo wa dzuwa ra vitswani, lola, kwambola mulangaza wa kung'ala sana kula mulunguni na ukinipiga. ");
INSERT INTO nyf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","K'uzhona zho nakwenda chavu ho ts'i na nikisikira sauthi ya mut'u ikinamba, ‘Sauli! Sauli! Mbona unanitesa kaheri?’ ");
INSERT INTO nyf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nikiuza nikiamba, ‘U h'ani, Bwana?’ Akidzigidzya akiamba, ‘Mimi unitesaye ni Jesu wa Nazareth'i.’ ");
INSERT INTO nyf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bai aryahu andzangu huriokala hosi, mawona wo mulangaza, ela yo sauthi ya iye ariyekala ananena nami k'amaisikirire bule. ");
INSERT INTO nyf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ndo nikiuza nikiamba, ‘Vikara nihendedze Bwana?’ Ye Bwana akiamba, ‘Uka wangire Damesiki, ukifika kuko undambirwa kila kit'u udzichothayarishirwa kuhenda.’ ");
INSERT INTO nyf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Bai aryahu andzangu manigwira mukono na makinitsetseza muhaka mo Damesiki, mana were yo ch'enje ya wo mulangaza idzanalaga matso kamare. ");
INSERT INTO nyf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Vikara kuko Damesiki kwere kuna mut'u mumwenga aifwaye Anania. Anania were wadzambozeza kuithuwa yo sheria naye were anaishimiwa sana ni o Ayahudi osi mariotoa kuko. Bai akidzanona. ");
INSERT INTO nyf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Arihofika, waima hehi nami na akiamba, ‘Sauli mwenehu h'aya ona kaheri!’ Na haho henye nikidima kumona hatha iye. ");
INSERT INTO nyf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Gonya ye Anania akiamba, ‘Iye Mulungu wa akare wakutsagula ili umanye mahendzoge na umone iye Muhachi na usikire go maneno gandigombola kanwani mwakwe. ");
INSERT INTO nyf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Uwe undakala shahidhiwe kwa at'u osi, undaambira garyahu urigogaona na kugasikira. ");
INSERT INTO nyf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nawe vikara unatharizani be vino? Uka ubat'izwe kwa dzina ra Jesu na ukihenda vizho undasamehewa kamare.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","P'aulo akienderera kunena akiamba, “Vikara nikiuya haha Jerusalemu na nirihokala ni kahi za ro Hekalu navoya, naona maono. ");
INSERT INTO nyf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Namona Bwana akiniamba, ‘Henda haraka umbole kare mumu Jerusalemu, mana o at'u haha k'amandaukubali bule wo ushahidhiwo dzulu za mimi.’ ");
INSERT INTO nyf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nikidzigidzya nikiamba, ‘Bwana, at'u aa be manamanya kukala mimi nangira Sinagogi rino na rirya na kuagwira at'u na kuafunga na kuapiga ao makukuluhirao uwe. ");
INSERT INTO nyf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na wakathi yuyahu shahidhiwo Sitivini arihokala anakotw'a, mut'u mimi nakala wa thi, haho kuaunga mukono na kuzikat'o zo nguwo za aryahu mariokala manamwalaga.’ ");
INSERT INTO nyf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Bai ye Bwana akinamba, ‘Uka, nindakuhuma wende kut'u kure kwenye, ko kwa at'u mario si Ayahudi.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bai ro kundi ra at'u ramusirikiza P'aulo hatha arihohadza dzulu za kwenda kwa at'u mario si Ayahudi, richa mapige k'ululu na kuamba, “Museni yuyu haha dhuniani, k'av̱irya kukala moyo bule!” ");
INSERT INTO nyf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Vikara marihokala ni h'uwoh'uwo na kutsuha go maamba gao na kufitisa vumbi ko dzulu, ");
INSERT INTO nyf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ye mubomu wa jeshi walagiza ye P'aulo ahirikwe ko k'ambini. Pia akilagiza auzwe-uzwe kwa kupigwa vikotho ili amanye ni kwanoni o at'u manapiga k'ululu kwa ut'u wa iye, namuna iyo. ");
INSERT INTO nyf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Bai marihokala manamufunga ili mamupige, P'aulo wamwamba ye ofisaa ariyekala aimire haho akiamba, “Vidze kisheria ni hachi, kumupiga raiya wa Kirumi na ko k'adzangwe kupigwa ulongo?” ");
INSERT INTO nyf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","K'uzhona zho kusikira vizho, ye ofisaa wakwenda kwa ye mubomu wa jeshi na achendavisema, akiamba, “H'aya, undahendadze, kwani mut'u yuyu be ni raiya wa Kirumi.” ");
INSERT INTO nyf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Bai ye mubomu wa jeshi achendamuza P'aulo akiamba, “Nambira hedu, we ati u raiya wa Kirumi?” P'aulo akidzigidzya akiamba, “Ee.” ");
INSERT INTO nyf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ye mubomu wa jeshi akiamba, “Mimi be wo uraiya naurihira p'esa nyinji sana.” P'aulo akidzigidzya akiamba, “Mino be nazhalwa kare raiya.” ");
INSERT INTO nyf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ndo aryahu mario were mandamuza-muza maswali makihenda nyeree kare, na ye mubomu wa jeshi mwenye achangirwa ni woga arihogundua kukala, adzamuhala P'aulo na akamufunga minyororo na ko ni raiya wa Kirumi. ");
INSERT INTO nyf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Vikara siku ya hiriye, ye mubomu wa jeshi were anamala amanye ni ut'u wani haswa uriwo unaahenda o Ayahudi mamushithaki ye P'aulo, kwa vizho akimwamboza na akilagiza o alombi abomu na ro Baraza rosi makundzumanyike. Bai virihohendeka vizho, wamuhala P'aulo na achendamwika mbere zao. ");
INSERT INTO nyf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bai P'aulo akialolat'o o athumia a ro Baraza, akiamba, “Ndugu zangu! Mut'u mimi nina hakika mbere za Mulungu kukala nidzaishi maisha madzo hatha vivi.” ");
INSERT INTO nyf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kusikira vivi Anania ariye were nde Mulombi mubomu mwenye, waalagiza ao mario were maimire hehi na ye P'aulo, mamwangize mbalahi ya kanwa. ");
INSERT INTO nyf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","K'ona P'aulo akimwamba ye Mulombi mubomu mwenye, “Wee, unadzihendya u mut'u mudzo na k'umudzo kit'u! Mulungu andakwangiza mbalahi. Udimadze kukeresi haho na kunihukumu kisheria, kuno ko we mwenye unaibanda yo sheria kwa kulagiza at'u manangize mbalahi!” ");
INSERT INTO nyf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bai aryahu mariokala maimire hehi na ye P'aulo, mamwamba, “Mbona unamudhyoma Mulombi mubomu mwenye wa Mulungu we?” ");
INSERT INTO nyf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","P'aulo akidzigidzya akiamba, “Aa, p'oreni ndugu zangu, simanyire kala yuyu nde Mulombi mubomu mwenye, mana Maoro ganaamba kukala, ‘Usinene mai dzulu za muthawali wa at'uo.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Vikara P'aulo were anamanya kukala angine kahi za o at'u ni Masadukayo na angine ni Mafarisayo, bai akinena na mumiro mubomu kahi za ro Baraza ra athumia, akiamba, “Mut'u mimi, ni Farisayo ndugu zangu, nazhalwa ni Mafarisayo. Nami nidzarefwa haha manenoni, kwa kukala ninakuluhira kukala at'u mariofwa mandafufulwa.” ");
INSERT INTO nyf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Naye kutosa kunena vivi thu, o Mafarisayo na Masadukayo makikosana kare, na wo muthunganano ukigazhika. ");
INSERT INTO nyf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Mana Masadukayo manaamba k'akuna cha at'u kufufuka na manaamba kukala k'akuna cha malaika hedu roho, ela o Mafarisayo manaamini kukala vivi vit'u zhosi vi kuko.) ");
INSERT INTO nyf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","K'uzhona zho kundahenda h'uwoh'uwo na londzo lunji na angine kahi za alimu a Sheria mario were ni Mafarisayo makiungarara na makilalamika jeri-jeri makiamba, “Mut'u yuyu be k'afumona na kosa rorosi na hangine nikwenda akakala roho hedu malaika manena naye jeri!” ");
INSERT INTO nyf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Na lola ro h'uwoh'uwo kahi za o Mafarisayo na Masadukayo rikikaza zhomu hatha ye mubomu wa jeshi akikala ana wasiwasi k'anji P'aulo andatharurwa visiku-visiku ni ao at'u. Bai akialagiza o shikari matharamuke ko ts'ini na makamuhale kwa nguvu kula kwa o at'u na mende naye ko k'ambini. ");
INSERT INTO nyf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","K'uzhona zho, usiku uwo, Bwana wakudzaima hehi na ye P'aulo na akiamba, “Dzip'e moyo, mana vizho udzizhomboza ushahidhi uu dzulu zangu kahi za Jerusalemu, be ndo ambazho ni suthi unambozeze ushahidhi kuko Rumi nako.” ");
INSERT INTO nyf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Bai kurihocha na madzach'a o Ayahudi mapanga njama ya kumwalaga P'aulo, makilaha kwa Mulungu kukala k'amandarya kit'u hedu kunwa chochosi muhaka maone kukala madzamwalaga ye P'aulo. ");
INSERT INTO nyf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bai o at'u mariopanga njama iyo were ni zaidhi ya mirongo mine. ");
INSERT INTO nyf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","At'u aa makwenda muhaka ko kwa alombi abomu na o athumia a Kiyahudi na machendaamba, “At'u siswi fudzalaha kwa Mulungu kamare, kukala k'afundadona kit'u muhaka humwalage P'aulo. ");
INSERT INTO nyf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Vikara ninwi na o athumia a Baraza hirikani uv̱oro kwa ye mubomu wa jeshi kwamba amurehe P'aulo mbere zenu na mudzihendye munamala kumanya zaidhi dzulu za yo k'esiye, naswi fu thayari fumwalage kabila k'adzafika haha.” ");
INSERT INTO nyf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","K'uzhona zho muthana wa nduguye P'aulo wa kiche akiipata p'eho yo njama, bai achenda ko k'ambini na achendamutinyira P'aulo. ");
INSERT INTO nyf_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ndo P'aulo akiiha mumwenga kahi za o maofisaa na akimwamba, “Muhale yuyu muvulana wende naye hatha kwa ye mubomu wa jeshi, ana ut'u amalao kwendamwambiriza.” ");
INSERT INTO nyf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Bai akimuhala achenda naye kwa ye mubomu wa jeshi. Marihofika kuko ye ofisaa akimwamba ye mubomu wa jeshi, “P'aulo, yuyahu mufungwa adzanihuma nimurehe yuyu muvulana kwako, mana ana ut'u amalao kukwambira.” ");
INSERT INTO nyf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","K'uzhona zho ye mubomu wa jeshi akimugwira mukono ye muvulana na akimuvuha k'anda, akimuza akiamba, “H'aya were una ut'u wani wa kunambira?” ");
INSERT INTO nyf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ye muvulana akiamba, “O Ayahudi madzapanga kukala machero, uwe umurehe P'aulo mbere za o athumia a Baraza nao madzihendye manamala kusikira manji zaidhi dzuluze. ");
INSERT INTO nyf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Vikara uwe, usithuwe zho zhao bule, mana hana at'u zaidhi ya mirongo mine ambao madzamuzamira ko ngirani na madzalaha kwa Mulungu kukala k'amandadona kit'u hedu hatha kunwa chochosi muhaka mamwalage ye P'aulo. Na vivi be ma thayari kare, hatha manathariza zho undizhoamba thu.” ");
INSERT INTO nyf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Bai ye mubomu wa jeshi akimukokot'era ye muvulana akiamba, “Usiseme kwa mut'u yoyosi kukala udzire nambira maut'u gaga.” Gonya akimwamba ye muvulana ende. ");
INSERT INTO nyf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Arihokala ye muvulana adzauka, ye mubomu wa jeshi waaiha airi kahi za o maofisaae a shikari na akialagiza akiamba, “Thayarishani shikari magana mane na mirongo mifungahe. Magana mairi makale ni shikari a kawaida, magana mairi makale ni a mafumo na mirongo mifungahe makale ni a kupanda farasi. H'aya, aa osi mende Kaisaria vivi rero usiku wa saa t'ahu. ");
INSERT INTO nyf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kidza muthayarishireni farasi a kuthala ye P'aulo na mwende naye salama kwa luwali Feliki.” ");
INSERT INTO nyf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Gonya ye mubomu wa jeshi akiora baruwa iambayo: ");
INSERT INTO nyf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ni mimi Kilaudio Lusia, nakuorera uwe muheshimiwa luwali Feliki. Vidze k'una ut'u? ");
INSERT INTO nyf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mut'u yuyu wagwirwa ni Ayahudi na hachache henye mamwalage, ela bai nichenda na shikari angu na nichendamuthizha, mana nakala dzapata uv̱oro kukala iye ni raiya wa Kirumi. ");
INSERT INTO nyf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Vikara nikikala namala nimanye manamushithakirani, kwa vizho nikimuhirika mbere za ro Baraza ra athumia. ");
INSERT INTO nyf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Bai nikigundua kukala mamushithaki kwa maut'u ga Sheria yao, ela hatha were k'ahana kosa rorosi ridimaro kumuhendya alagwe hedu angizwe jela. ");
INSERT INTO nyf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Vikara nirihombirwa dzulu za njama iriyokala idzatsilwa dzulu za yuyu mut'u, ndo nikiona baha nimuhume kuko kwako mara mwenga, kidza nidzaambira ao at'u madziomushithaki kukala yo k'esi mariyo nayo dzulu za mut'u yuyu be ni mainene mberezo.” ");
INSERT INTO nyf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Kwa vizho o shikari, makihenda here marizhokala madzalagizwa, makimuhala P'aulo na wo usiku na machenda naye vivii muhaka Anitipatiri. ");
INSERT INTO nyf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Bai siku ya hiriye aryahu shikari mario were k'amahumira farasi mauya ko k'ambini, ela aryahu shikari a kuhumira farasi makienderera na cho charo cha kumuhirika P'aulo. ");
INSERT INTO nyf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Vikara marihofika ko Kaisaria mahala yo baruwa na makimup'a ye luwali na makimulazha ye P'aulo kwa iye luwali. ");
INSERT INTO nyf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","H'aya, ye luwali akiishoma yo baruwa gonya akimuza ye P'aulo chamba anambola kahi za jimbo hiro. Bai arihokala adzamanya kukala ye P'aulo ni wa Kilikia, ");
INSERT INTO nyf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","akiamba, “Nindaisirikizat'o yo k'esiyo haho mandihokudza ao mariokushithaki.” Gonya akilagiza kukala ye P'aulo aikwe kahi za nyumba iriyoakwa ni muthawali Herode, na arindwe jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Vikara bada ya siku ts'ano, Anania, Mulombi mubomu mwenye watharamuka ko Kaisaria, iye hamwenga na athumia fulani, na wakili mumwenga ariyeifwa T'eritulo. Bai makwenda kuko makanene yo k'esi yao na P'aulo mbere za ye luwali Feliki. ");
INSERT INTO nyf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","K'uzhona zho P'aulo andaihiwa. Arihokudza, T'eritulo wakwatya kumushithaki na kuamba, “Muheshimiwa, at'u siswi fudzatoat'o muda mure wenye na dheri ts'ini za ulongozio na udzagaluza maut'u manji mai kahi za ts'i ii kwa kukala unaona kure. ");
INSERT INTO nyf_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bai maut'u gaga hunagahokera kila hat'u na kahi za ngira zosini, naswi funaamba funa muv̱era zhomu. ");
INSERT INTO nyf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ela bai ts'endzi ni kutsoshe bule, nimalazho ni kwamba, nahendza ufusirikize vichache zhenye chamba vinadimikika. ");
INSERT INTO nyf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“At'u siswi fwagundua kukala mut'u yuyu be ni muthiriri. Anadusha fujo kahi za Ayahudi, naye anahenda ut'u uu kahi za urumwengu muzima. Kidza yuyu nde kitswa cha kundi ra Anazareth'i, ");
INSERT INTO nyf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","na hatha wajeza kurangiza nyenye ro Hekalu, kwa vizho hukimwangiza magandzani. Naswi were hunamala kumuhukumu kulengana na sheria yehu, ");
INSERT INTO nyf_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ela ye Lusia mubomu wa jeshi akidza na akidzamuhala kula mikononi mwehu kwa kibavu. ");
INSERT INTO nyf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Gonya akilagiza madze ko kwako ao madziomushithaki. Vikara uwe mwenye ukimuza-muza maswali undamanya ho uriho wo ujeri dzulu za gaga gosi humushithakirago.” ");
INSERT INTO nyf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Bai o Ayahudi mariokala haho, mauunga mukono moro uu, makiamba, “Gago gadzigonenwa be ni ga jeri.” ");
INSERT INTO nyf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Bai ye luwali akimonyesa P'aulo muv̱ano kukala ni zamuye ya kunena. Ndo P'aulo akidzigidzya akiamba, “Ninamanya kukala uwe udzakala jaji kahi za ts'i ii miaka minji yenye, kwa vizho ninadzihehera na raha. ");
INSERT INTO nyf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","H'aya, uwe unadima ukamanya kukala mimi nakwenda Jerusalemu kwendavoya. Bai vivi k'azizidhi siku kumi na mbiri bule hangu nende. ");
INSERT INTO nyf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Aa Ayahudi madzionishithaki be k'amanonere nanenezana na mut'u yoyosi kahi za ro Hekalu, hedu hatha kualunga at'u kahi za masinagogi na kahi za wo mudzi wa Jerusalemu magwage fujo. ");
INSERT INTO nyf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Zho mbai, aa be k'amadima kumboza ushahidhi wa kunyesa kukala zho maniambazho nazho ni jeri. ");
INSERT INTO nyf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kit'u ambacho ninakikubali ni kiki, mimi ninamuvoya ye Mulungu wa akare ehu kwa kuithuwa iryahu Ngira ya Jesu ambayo Ayahudi manayamba ni chama cha fujo. Kidza mimi nagakuluhira gosini garyahu garigoorwa kahi za Sheria ya Musa na garigoorwa ni manabii, ");
INSERT INTO nyf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","nami th'amaa yangu kwa Mulungu be ni dza ii ya at'u aa yenye, kwamba at'u ahachi na masio ahachi mandafufulwa. ");
INSERT INTO nyf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kwa ut'u uu bai, siku zosi ninajeza here zhadimikikazho kuhenda madzo mbere za Mulungu na mbere za anadamu. ");
INSERT INTO nyf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Bai bada ya kukala ko dzulu-dzulu miaka minji yenye, nauya ko Jerusalemu kwendaahirikira masikini a kwehu musadha wa p'esa, na kidza kwendamboza sadaka kamare. ");
INSERT INTO nyf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Vikara nirihokala ni kahi za kuhenda gaga, at'u aa manipesa mo Hekaluni, nami were nidzahenda adha ra kudzitsusa. Were sina kundi ra at'u ho nirihokala, na were k'ahana fujo yoyosi. ");
INSERT INTO nyf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ela bai were hana Ayahudi angine kula jimbo ra Asia, kwandza ao manav̱irya makale ma haha na manene chamba mana ut'u wowosi wa kunishithakira. ");
INSERT INTO nyf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","H'aya zho mbai, aa mario haha, be vivi ni manene kala manona nina kosa haho nirihoima mbere za ro Baraza ra athumia. ");
INSERT INTO nyf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nina kit'u kimwenga nirichokihenda, na kala mananishithaki na kicho, ninakikubali. Napiga k'ululu mbere zao nikiamba, ‘Ninahukumiwa kwa kukala ninakuluhira kukala kuna kufufuka.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ndo Feliki, ambaye go maut'u ga yo Ngira ya Jesu were anagamanyat'o, akiona baha yo k'esi aifunge kwandza, akiamba, “Ii k'esiyo ndaitosa haho Lusia mubomu wa jeshi andihokala adzire.” ");
INSERT INTO nyf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Bai akilagiza mubomu wa shikari amwangize rumande ye P'aulo, ela pia amup'e uhuru wa kutsembererwa ni asenae na mamwavize na mahitaji ga kwakwe. ");
INSERT INTO nyf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Bai bada ya siku mbiri t'ahu, Feliki wakudza na muchewe Dirusila. Mukaza Feliki were ni Muyahudi. K'uzhona bai, Feliki akimulagiza P'aulo adze, arihokudza P'aulo wanena dzulu za kumukuluhira Masihi Jesu na Feliki akikala anasirikiza thu. ");
INSERT INTO nyf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Vikara P'aulo arihokala adzakwatya kunena dzulu za hachi na dzulu za kudziunya, na dzulu za yo hukumu indiyokudza, Feliki wangirwa ni woga akiamba, “Vinathosha vizho kwa rero! Haho nikikala nidzafisha nindakwiha kaheri.” ");
INSERT INTO nyf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Mo ndani-ndani were Feliki ana th'amaa kukala hangine nikwenda P'aulo akamup'a kaitsi, kwa vizho akikala ni wa kumwiha kila mara na kunena naye. ");
INSERT INTO nyf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bai bada ya miaka miri kukira, ho hat'u ha Feliki hahalwa ni P'orikio Fesito, ela kwa kukala Feliki were anamala ahendzwe ni o Ayahudi, wathuwa kumuricha P'aulo mo rumande. ");
INSERT INTO nyf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Vikara luwali Fesito akifika kahi za ro jimbo riro. Bai bada ya siku t'ahu akiuka Kaisaria akimbuka kwenda Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Bai arihokala a kuko Jerusalemu o alombi abomu na vilongozi a Kiyahudi mamushithaki P'aulo kwa Fesito. ");
INSERT INTO nyf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Makimuvoya Fesito chamba vinadimikika ye P'aulo arefwe Jerusalemu. Ela lengo rao were ni chamba akudzani, mamuvamie mahende kumukot'a kamare. ");
INSERT INTO nyf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ela Fesito akidzigidzya akiamba, “P'aulo a rumande ko Kaisaria, na mimi mwenye sindatoa, ndakwenda kuko. ");
INSERT INTO nyf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Kwa vizho o vilongozi enu na madze fugwirane na hutharamuke kuko Kaisaria, bai chamba ye mut'u wahenda ut'u wowosi uwi, mundavinena kuko.” ");
INSERT INTO nyf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Bai Fesito akikala hamwenga nao kwa muda wa siku nane hedu kumi vivi gonya akitharamuka kwenda Kaisaria, na siku ya hiriye achendakelesi kahi za kihiche cha hukumu na akilagiza ye P'aulo aifiwe. ");
INSERT INTO nyf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Vikara P'aulo arihokudza, aryahu Ayahudi mariokala madzire kula Jerusalemu maima kumudengereka na makimushithaki na maut'u manji maziho-maziho ambago were k'amana ushahidhi nago. ");
INSERT INTO nyf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ndo P'aulo achambola kudzihehera akiamba, “Mut'u mimi sihendere kosa rorosi kinyume cha Sheria ya Kiyahudi hedu kinyume cha ro Hekalu, na sihendere kosa rorosi kinyume cha Kaisari.” ");
INSERT INTO nyf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Bai kwa kukala Fesito were anamala ahendzwe ni o Ayahudi, wamuza P'aulo akiamba, “Simanya chamba ungahendza kwenda Jerusalemu na yo k'esi nikaitosere kuko?” ");
INSERT INTO nyf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","P'aulo akidzigidzya akiamba, “Vivi kare niimire mbere za koti ra Kirumi na yo karakara yo k'esi niitoserwe haha. Na here we mwenye umanyazho t'ot'ot'o be mimi siahenderere rii rorosi o Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ela chamba ni mukosa na nav̱irya nalagwe, be mut'u mimi ni thayari kufwa, ela chamba gaga marigo mananiamba nago aa be ni ga ulongo, h'aya be k'ahana mut'u ariye na hachi ya kunilazha kwa at'u aa. Navoya nihirikwe kwa Kaisari.” ");
INSERT INTO nyf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Bai Fesito akiojana na o ashauri a kwakwe gonya akimudzigidzya P'aulo akiamba, “Udzavoya uhirikwe kwa Kaisari, h'aya undakwenda.” ");
INSERT INTO nyf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Vikara bada ya siku za kuthala, muthawali Agiripa na Berinike mazhoga mo Kaisaria kudzamubisha na kumukaribisha kamare ye Fesito. ");
INSERT INTO nyf_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bai makitoa kuko kwa siku za kuthala. Wakathi uwo ndo Fesito arihosumurira na ye Agiripa dzulu za yo k'esi ya P'aulo. Akiamba, “Hana mwanamulume mumwenga haha ariyerichwa rumande ni Feliki, ");
INSERT INTO nyf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","nami nirihokala ko Jerusalemu, o alombi abomu, na athumia a Kiyahudi makudzamushithaki kwangu na makikala manaamba apigwe ulongo. ");
INSERT INTO nyf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Bai nikidzigidzya nikiamba kukala kulengana na adha ra Kirumi, ni makosa kumulazha mut'u hasiho kumwika mbere za ao madziomushithaki na kumup'a mwanya wa kudzihehera. ");
INSERT INTO nyf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Vikara marihofika haha siitoejere bule yo k'esi, mana siku ya hiriye nakeresi kotini na nikilagiza arefwe mo ndani. ");
INSERT INTO nyf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","K'uzhona zho o ak'ondoe marihorungarara kunena, nasirikiza, aa, manamushithaki na mangine genye, hatha si gago nirigokala naelelya. ");
INSERT INTO nyf_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ao be were mananenezana naye dzulu za dini yao enye na dzulu za mut'u aifwaye Jesu ambaye wafwa, ela P'aulo adzasita kuamba a moyo. ");
INSERT INTO nyf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Vikara kwa kukala maut'u gaga be mimi mwenye were simanya ngira ya kugachunguzira, namuza ye mwenye chamba angahendza kwenda Jerusalemu na yo k'esi ya maut'u gaga ikanenwe kuko. ");
INSERT INTO nyf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ela P'aulo arihombola kunena, akivoya aikwe rumande muhaka yo k'esi indihololwat'o ni ye Kaisari mwenye. Ndo nikilagiza aikwe mo rumande muhaka nindihodima kumuhirika ko kwa Kaisari.” ");
INSERT INTO nyf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Bai ye Agiripa akimwamba Fesito, “Mimi pia nahendza nimusirikize yuyu mwanamulume.” Fesito akidzigidzya akiamba, “Undamusikira machero.” ");
INSERT INTO nyf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Bai siku ya hiriye Agiripa na Berinike makudza kuno be njerejere zinapigwa, ndoo vivii hatha machangira ho hat'u hasirikizwaho maneno. Nao were ma hamwenga na at'u maishimiwao kahi za wo mudzi. Bai, Fesito akilagiza kukala P'aulo arefwe. ");
INSERT INTO nyf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Arihorefwa, Fesito akiamba, “Muthawali Agiripa na at'u osini murio haha naswi, munamona yuno mut'u yuno? O Ayahudi osi, a Jerusalemu na a haha Kaisaria makudzanipasha habari dzulu za mut'u yuyu. Mapiga k'ululu kuamba mut'u yuyu be k'av̱irya kukala moyo. ");
INSERT INTO nyf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ela mimi be naona kukala k'ahendere kosa ra kumup'a adhabu ya kifwa, ela kwa kukala wavoya ii k'esi ikasirikizwe ni ye Kaisari mwenye, naona mut'u mimi baha nimuhirike ko kwa ye Kaisari. ");
INSERT INTO nyf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mimi be sina ra kumuorera ye Kaisari dzulu za mut'u yuyu, kwa vizho nidzamureha haha mbere zenu nyosi, haswa nidzamureha mberezo uwe Muthawali Agiripa, kwamba undihokala udzagachunguza gaga maneno nipate ut'u wa kwandhika. ");
INSERT INTO nyf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwani naona si vidzo kumuhirika mufungwa hasiho kunyesa wazi adzashithakiwa na makosa gani.” ");
INSERT INTO nyf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Bai muthawali Agiripa akimwamba P'aulo, “H'aya hudzakup'a ruhusa, dzihehere.” Ndo P'aulo akiavungira mukono na akikwatya kudzihehera akiamba, ");
INSERT INTO nyf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Muthawali Agiripa, mut'u mimi be nadziona kukala nina bahathi sana kuima mberezo vivi rero na kudzihehera na gago gosi nirigo naambwa nago ni o Ayahudi. ");
INSERT INTO nyf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Haswa na bahathi kwa viryahu ambazho uwe mwenye unagamanya t'ot'ot'o go maadha gosi ga Ayahudi na zo tofauti zao, kwa vizho nakuvoya vichadimikika uvumirire na unisirikize. ");
INSERT INTO nyf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“K'ahana Muyahudi hatha mumwenga ariye k'amanya mitoere yangu hangu uthana wangu hatha vivi. Kila mut'u anamanya kula hangu chaho viryahu mitoere yangu irizhokala, hangu ko kwehu T'ariso na ko Jerusalemu. ");
INSERT INTO nyf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","O at'u madzanimanya miaka minji kukala mimi naishi here mwanachama wa chama cha Mafarisayo, ambacho ndo chenye sheria k'omu zaidhi. Na makihendza manadima kukwambira dzulu za gaga. ");
INSERT INTO nyf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Vino bai ni haha nanena k'esi kwa ut'u wa th'amaa yangu niriyo nayo dzulu za gago ambago Mulungu waalaga o akare ehu. ");
INSERT INTO nyf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ahadi ii ya at'u kufufulwa ndo iahendyayo at'u a zo mbari zehu kumi na mbiri, makale na th'amaa nayo. Ndosa manamuhumikira Mulungu kwa chadi usiku na mutsana. Nami bai ninashithakiwa ni o Ayahudi kwa kukala nina th'amaa iyo h'ewe muheshimiwa Muthawali! ");
INSERT INTO nyf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kwanoni munaona vikomu kukuluhira kukala Mulungu anadima kufufula at'u? ");
INSERT INTO nyf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Kunena wo ujeri mimi mwenye, be nakala naona nihende zhosi nadimazho kuripinga ro dzina ra Jesu wa Nazareth'i. ");
INSERT INTO nyf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nazho vizho ndo nirizhohenda zhenye kuko Jerusalemu. Nap'ewa wadimi ni o alombi abomu nami nikiagwira o at'u a Mulungu na nikiangiza kifungoni, na marihokala manahukumiwa kwalagwa napiga k'ura yangu kukala malagwe. ");
INSERT INTO nyf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nangira kahi za masinagogi k'ana nyinji kuhakikisha manangizwa akili, na nahenda zhosi nadimazho kualazimisha mamukufuru Mulungu. Ut'u uu were udzanihayusa tha nichenda kahi za midzi ya kure kwendaadengereka na kuatesa. ");
INSERT INTO nyf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Bai nirihokala nichere na gago, nagerwa ruhusa na malagizo ni o alombi abomu nami nikiuka kwenda Damesiki. ");
INSERT INTO nyf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Vikara mo ngirani, murongo wa dzuwa ra vitswani, naona mulangaza h'ewe muthawali kula ko dzulu mulunguni. Mulangaza uwo were unang'ala hatha ro dzuwa kuuya nyuma. Bai wanipiga mimi na o andzangu huriokala hu charoni hosini. ");
INSERT INTO nyf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Naswi hosi hukigwa ho ts'i na nikisikira sauthi ya mut'u ikinena nami kwa Kieburania ikiamba, ‘Sauli! Sauli mbona unanitesa? Unapiga hala k'onjo uwe.’ ");
INSERT INTO nyf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Bai nikiuza nikiamba, ‘Ndiwe h'ani kwani we Bwana?’ Ye Bwana akidzigidzya akiamba, ‘Ndimi Jesu, ye umutesaye. ");
INSERT INTO nyf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Vikara vivi ungarara uime na magulugo. Kwani mimi nidzakwambolera ili nikutsagule ukale muhumiki wangu na uambire at'u zho udzizhozhona, na kidza uambire na garyahu nindigokwanyesa. ");
INSERT INTO nyf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nindakuthizha kula kwa ao at'uo enye na kula kwa o at'u mario si Ayahudi. Mimi ninakuhuma kuko kwa at'u ao, ");
INSERT INTO nyf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ili ukaang'aze matso, na uagaluze mambole kizani mangire mulangazani, na kidza uamboze kula kwa nguvu za Shethani na mamugalukire Mulungu, ili kwa kunikuluhira mimi madime kusamehewa dambi zao na makale mana hat'u kahi za ao at'u mariotsagulwa ni Mulungu.’ ");
INSERT INTO nyf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Kwa vizho bai h'ewe Muthawali Agiripa gago maono ga mulunguni be nagatii kamare. ");
INSERT INTO nyf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Bai kwandza kamare nikiahubiri o at'u ko Damesiki, na ko Jerusalemu na kila hat'u kahi za yo ts'i ya Judea, na kidza nikiahubiri o at'u mario si Ayahudi nao. Naahubiri nikiambira kukala manav̱irya mathubu na mamugalukire Mulungu, na mahende mahendo gandigonyesa kukala madzathubu jeri. ");
INSERT INTO nyf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Vizho bai ndo virizhoahenda o Ayahudi manigwire kahi za wo muhala wa ro Hekalu na majeze kunalaga. ");
INSERT INTO nyf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ela Mulungu adzaenderera kunaviza hatha vivi rero, na ndosa niimire haha kumboza ushahidhi kwa at'u osi, abomu kwa athithe. Mut'u mimi sinena mangine, hasihokala gago garigoambwa ni o manabii na Musa kukala gandahendeka, ");
INSERT INTO nyf_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","nago ni gago ga kukala ye Masihi andateseka na andakala wa kwandza kufufuka kula kifwani, na andaambiriza o Ayahudi na o at'u mario si Ayahudi dzulu za wo mulangaza wa wokolwi.” ");
INSERT INTO nyf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bai P'aulo arihokala anaenderera kudzihehera, ye Fesito wapiga k'ululu akimutsindza ludhimi akiamba, “Una vilalu we P'aulo! Yo elimuyo nyinji idzakuhayusa!” ");
INSERT INTO nyf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","P'aulo akidzigidzya akiamba, “Sina vilalu bule, muheshimiwa Fesito zho ninenazho be ni ujeri uhuhu. ");
INSERT INTO nyf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ye Muthawali Agiripa anagamanya t'ot'ot'o gaga nami nadima kunena naye wazi-wazi hasiho woga, na namanya kamare kukala k'ahana hatha mwenga ridziromukira, mana maut'u gaga k'agahenderwe njamani bule. ");
INSERT INTO nyf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Naamba, we muthawali Agiripa unaakuluhira o manabii? Nimanyazho ni kwamba unaakuluhira.” ");
INSERT INTO nyf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kusikira vizho ye Agiripa akimwamba P'aulo, “Vino be unaona kukala unadima kunihendya Mumasihia kwa muda mufuti namuna ii?” ");
INSERT INTO nyf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","P'aulo akidzigidzya akiamba, “Vindahala muda mure hedu mufuti mino simanya. Nivoyacho kwa Mulungu ni uwe, na si uwe h'akeyo thu, ela hatha aa angine osi mario mananisirikiza vivi rero mukale dza mimi, isihokala ii minyororo thu.” ");
INSERT INTO nyf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Bai ye muthawali, na ye luwali, na ye Berinike na osini mariokala makeresi hamwenga nao marungarara, ");
INSERT INTO nyf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","na machambola mo chumbani, bai wakathi manasumurira ao h'akiyao, maamba, “Mut'u yuyu k'ahenda ut'u wowosi uwi ambawo unadima kumuhendya alagwe hedu hatha kufungwa jela.” ");
INSERT INTO nyf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Gonya Agiripa akimwamba Fesito, “Kala si zho zha kukala yuyu mwanamulume wavoya ahirikwe ko kwa Kaisari, be hatha akarichwa huru.” ");
INSERT INTO nyf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Vikara Fesito arihoamba kukala fundakwenda Italiya, ye P'aulo hamwenga na afungwa angine, maikwa mikononi mwa mubomu mumwenga wa shikari aifwaye Juliasi ambaye were ni mubomu wa kikosi kiifwacho “Kikosi cha Kaisari.” ");
INSERT INTO nyf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Bai fuchangira chombo kiricho were kila bandari ya Aduramutino na kindakira na bandari za jimbo ra Asia. Kwa vizho fuchangira, naswi thiswi, fukiandza charo chehu. Kahi za charo kiki were fu hamwenga na Mumak'edonia wa kula Th'esalonike aifwaye Arisitariko. ");
INSERT INTO nyf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Bai siku ya hiriye fuchangira bandari ya Sidoni, na Juliasi akimuhendera vidzo ye P'aulo, mana wamuruhusu ende kwa asenae ili akadime kupata mahitajige. ");
INSERT INTO nyf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Vikara kula ho Sidoni, fwangira chomboni kaheri na huchendakira na luhande lwa Kuporo ambalo k'aluerekeza p'eho mana lo luhande lungine were zo p'eho zinadza na nguvu zaidhi. ");
INSERT INTO nyf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Bai ndiswi vivii muhaka hukivuka bahari ya k'anda za Kilikia na P'amufulia fuchangira bandari ya Mura, ambawo ni mudzi uriwo ko Lukia. ");
INSERT INTO nyf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kuko Mura, ye mubomu wa shikari wapata chombo cha kula Alekizandiria kiricho were kinenda Italiya, kwa vizho akifuhala akifwangiza kahi za cho chombo kicho. ");
INSERT INTO nyf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","K'uzhona zho ndiswi p'ore-p'ore vivi kuno funapata thabu jeri-jeri, hatha fukifika hehi na bandari ya Kinido. Vivi zhahala siku nyinji zenye. Vikara p'eho zirihokala k'azihurusu fuenderere kwenda luhande lulo, fwakwenda na luhande lwa kisiwa cha K'irete, hehi na Salimone. Luhande lulu were k'aluerekeza p'eho bule. ");
INSERT INTO nyf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Bai hukiambala-mbala haho hatha hukifika hat'u haifwaho “Bandari Mbidzo” na hehi na haho here hana mudzi uifwao Lasea. ");
INSERT INTO nyf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kufikira wakathi uu, were muda munji udzatsuhika sana na vikikala ni hathari kuenderera na cho charo, kwa kukala wo wakathi wa sherehe ya Mufungo were wagonya kukira kare. Kwa vizho P'aulo akiambira kimbere akiamba, ");
INSERT INTO nyf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Alume, mut'u mimi naona kukala kiki charo chehu kindafwangiza hasara, yo mizigo nikwenda ikatsuhika na hatha go maisha gehu nago dzazho.” ");
INSERT INTO nyf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ela ye mubomu wa shikari k'agagwirire bule gago ga P'aulo hat'uhe akithuwa gago ga ye dhereva wa cho chombo na go ga ye mwenye cho chombo. ");
INSERT INTO nyf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Vikara kwa kukala yo bandari were si mbidzo wakathi uwo wa mwaka, anji ehu maamba futhuwe kuenderera na cho charo chehu, ngaa hufike bandari ya Fonike na fukaukize kuko wo wakathi wa p'eho ya mwaka. Fonike were ni bandari iriyo kuko K'irete, nayo were inalolana na mutserero wa dzuwa. ");
INSERT INTO nyf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Vikara hurihokala huchere hu haho kwakwatya kupiga kapeho kadzo kula kwa mwaka, k'uzhona zho makiona zho madzizhokala manavimala madzavipata bai makiyusa yo nanga na machenda na mo k'anda-k'anda za K'irete. ");
INSERT INTO nyf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Bai k'avitoere kukidza luv̱utho lubomu lwa p'eho luifwalo Yurakulo, nalo lwapiga kula ko luhande lwa K'irete. ");
INSERT INTO nyf_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","K'uzhona zho cho chombo kikipigwa ni lo luv̱utho na kikikala k'akidima kwenda ko ludzirirako lo lupeho, kwa vizho fukikiricha vizho kithuwe kukokotwa ni lo luv̱utho. ");
INSERT INTO nyf_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Bai ndiswi vivii, hatha hukifika hehi na kisiwa kithithe kiifwacho Kauda, nacho chahuziza na lulo luv̱utho vichache na hukigwira ko kadau karikokala gadzafungwa ko nyuma ya cho chombo, ela be zhakala zha gada. ");
INSERT INTO nyf_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Vikara o anaalume makikangiza mo chomboni ko kadau, makikafunga, gonya cho chombo makikilinga-linga nyugwe makikifunga ndzi-ndzi-ndzi, ili kikale kinasita. Kidza makivitharamusha zho zhandharua, mana were mana wasiwasi nikwenda cho chombo kikafuswa na kikendakwama kahi za wo mutsanga wa yo p'wani ya Siriti. Bai makivitharamusha, makithuwa kukiricha chende na yo p'eho cho chombo. ");
INSERT INTO nyf_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Lola lo luv̱utho lwaenderera kupiga thu. K'uzhona zho siku ya hiriye o mabaharia makikwatya kuihala yo mizigo na kuitsuha mo madzini. ");
INSERT INTO nyf_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","H'aya, yo siku iriyothuwiriza makihala zho viya zha cho chombo na makivitsuha mo madzini nazho. ");
INSERT INTO nyf_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Bai zakira siku nyinji k'afuona dzuwa hedu nyenyezi na lo luv̱utho lwere lunaenderera thu, k'uzhona zho hukikala k'afuna th'amaa kaheri ya kuthia. ");
INSERT INTO nyf_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Vikara o at'u magonya siku nyinji zenye bila kudona kit'u. K'uzhona zho P'aulo akiima kahikahi zao akiamba, “Alume, kalaho mwagagwira go gangu kuryahu K'irete, kukala fusiuke bule kuko, ngere k'amukapatire mashaka gaga gosi hedu hasara ii muipatayo. ");
INSERT INTO nyf_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ela vivi bai, namuvoya mudzip'e moyo, mana k'ahana hatha mumwenga wenu haha andiyefwa, yo meli h'akeye ndo indiyongamika. ");
INSERT INTO nyf_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mana usiku wa kulamukira rero, yuyahu Mulungu ambaye mimi ni mut'uwe, adzahuma malaikawe kwangu mimi muhumikiwe. Bai adzihokudza akaima hehi nami ");
INSERT INTO nyf_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","akaamba, ‘Usogohe bule P'aulo, uwe suthi uime mbere za Kaisari na kidza lola iye Mulungu kwa zo mbazize, andaahenda aa osini urio charoni nao mathie.’ ");
INSERT INTO nyf_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Kwa vizho bai, dzip'eni moyo alume, kwa kukala nakuluhira kukala vizho adzizhoamba Mulungu be ndizho vindizhokala zhenye. ");
INSERT INTO nyf_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ela hatha hamwenga na vizho k'ahana vingine, hasihokala hundatsufwa kahi za kisiwa fulani thu.” ");
INSERT INTO nyf_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Bai urihofika usiku wa kumi na ne, at'u siswi were fuchere hunakokotwa ni lo luv̱utho thu. Bai fwakokotwa kuku na kuku kahi za yo bahari ya Adiria. K'uzhona zho inafika here usiku wa manane, aryahu mabaharia maelelya kukala fudzafika hehi na ts'i furufu, ");
INSERT INTO nyf_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Kwa vizho makihala lugwe ambalo lwere ludzafungwa kit'u kiziho, makilutharamusha mapime chamba hana wina wa kiasi chani. Bai marihopima maona kukala ho hat'u were hana wina wa futi gana na mirongo miri. Makiima-ima, gonya makipima kaheri, makipata kukala ho furihokala were hana wina wa futi mirongo chenda thu. ");
INSERT INTO nyf_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bai kwa ut'u wa kuogoha p'ore makagwizanywa na ho mbararani, mahala zo nanga ne na makizitharamusha mo madzini na makivoya ngee kuche. ");
INSERT INTO nyf_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Vikara aryahu mabaharia makijeza kuchimbira, makidzihendesha manendagwaga nanga wo upande wa mbere wa cho chombo. Makihala karyahu kadau kathithe ka kudzithizhira na makikala manakatharamusha mo madzini machimbire. ");
INSERT INTO nyf_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Kuona vizho P'aulo akimwamba ye mubomu wa shikari, hamwenga na o shikari enye akiamba, “Aa mabaharia kala k'amandathuwa kukala mumu chomboni, be k'amundathia bule.” ");
INSERT INTO nyf_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Bai o shikari makihala zo nyugwe ambazo were zidzafungirwa ko kadau makizitosa na makikaricha kagwe mo madzini kende. ");
INSERT INTO nyf_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Vikara kurihokala kunenda kuchani, P'aulo waasitira o at'u mumo chomboni marye chakurya. Bai wanena akiamba, “Hangu muandze kulolera chamba kundakalani, hatha vivi rero, ni siku kumi na ne nanwi k'amudzangwe kudona chochosi. ");
INSERT INTO nyf_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Bai ninamuvoya murye chakurya, mana kicho ndo kindichomuthizha. Mana haha be k'ahana mut'u hatha mumwenga andiyengamiza hatha ludzere lumwenga lwenye mo kitswani mwakwe.” ");
INSERT INTO nyf_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Arihogonya kunena vivi, akihala mukahe akimboza muv̱era kwa Mulungu, kuno osi mana lola, gonya akiumogola na akikwatya kurya. ");
INSERT INTO nyf_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ndo nao bai, machangira moyo na makikwatya kurya. ");
INSERT INTO nyf_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Hosini mo chomboni were fu at'u magana mairi na mirongo mifungahe na ahandahu. ");
INSERT INTO nyf_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Vikara kila mut'u arihokala adzarya kwakuha, o at'u mahala yo ngano na makiitsuha mo baharini ili cho chombo kikale kishushu. ");
INSERT INTO nyf_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Bai kurihocha aryahu mabaharia k'amamanyire chamba mere ma ts'i yani, ela maona mukono wa yo bahari uriwo were una nyangamo yenye mutsanga munji. Kwa vizho makiamua kwendachanganya kuko cho chombo. ");
INSERT INTO nyf_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ndo makizihala ziryahu nyugwe zirizokala zidzazulia zo nanga na makizitosa makiziricha zo nanga zihohe mo baharini. Makiziregeza zo nyugwe zirizokala zidzazulia yo sukani, makihala cho chandharuwa kirichokala ko mbere makikifunga ili p'eho idime kukisukuma, bai makikwatya kwenda ko nyangamoni. ");
INSERT INTO nyf_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ela kahi za kwenda ko nyangamoni cho chombo chafika hat'u hariho were hathunganana mikono miri ya bahari na kidza k'ahana wina, bai kichendazikika haho na ko kwa mbere, uno upande wa nyuma wo ukikala unabandwa-bandwa ni maimbi. ");
INSERT INTO nyf_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Kuona vizho o shikari makipanga kualaga osi o afungwa, ili hasikaleho na yoyosi kupiga go madzi na kuchimbira. ");
INSERT INTO nyf_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ela yuyahu mubomu wa shikari were anahendza amuthizhe P'aulo, kwa vizho akiamba masihende vizho bule, hat'uhe akiambira aryahu osini ambao manadima kupiga madzi, makale a kwandza kudzitsuha mo madzini na mapige madzi mende ko ts'i furufu. ");
INSERT INTO nyf_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","O angine mandathuwiriza, ela kwa kuhenda kugwira mbao hedu zho visiku zha cho chombo kidzichobandika. Bai kwa ngira ii hosini fwathiya na hukifika ts'i furufu azima. ");
INSERT INTO nyf_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Bai furihokala fudzathiya na fu kuko nyangamoni, haho ndo furihomanyira kukala cho kisiwa kinaifwa Malita. ");
INSERT INTO nyf_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","O at'u matoao kahi za cho kisiwa kicho mahukaribisha t'ot'ot'o sana. Vikara wakathi uwo were kunanya v̱ula, na kuna p'eho ya kuzizima, bai o at'u a cho kisiwa makikot'a kome ra moho na makihukaribisha hosini. ");
INSERT INTO nyf_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Badaye P'aulo achendamala ndodo, vikara arihokala anazigwaga-gwaga ho mohoni, kwambola nyoka ariyekala adzakolwa ni ro theri na akimuluma kidza akidzilinga-linga mo mukononi mwakwe. ");
INSERT INTO nyf_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","K'uzhona zho o at'u a cho kisiwa marihomona ye mududu analewa-lewa mo mukononi mwa P'aulo manena o enye na enye makiamba, “Mut'u yuyu suthi akale ni mwalagi thu, mana yudzathia jeri na yo bahari, ela ko yo ‘Hachi’ k'aindamuricha akale moyo bule.” ");
INSERT INTO nyf_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ela P'aulo bai wamuthiv̱a ho mohoni ye mududu na k'asikirire chochosi. ");
INSERT INTO nyf_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Enye were manaona kukala andakwatya kukanang'ana hedu andagwa kare afwe, ela marihololera muda mure wenye na k'akuna rorosi rii rikalaro kwa P'aulo, magaluza na makikwatya kuamba ye P'aulo ni mulungu. ");
INSERT INTO nyf_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Vikara hehi na haho were hana minda ya iye mubomu wa cho kisiwa ambaye were anaifwa P'abulio. Mut'u yuyu P'abulio be wahukaribishat'o sana, na huchendakala ajenie kwa muda wa siku t'ahu. ");
INSERT INTO nyf_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Wakathi uwo babaye P'abulio were a kitandani k'adima, mana were ana homa na ndani ya kumwaga milatso. Bai P'aulo wangira mo mwakwe chumbani akimuvoyera, gonya akimuikira mikono naye akihola. ");
INSERT INTO nyf_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","K'uzhona zho kudzahendeka kit'u kiki, o akongo angine osi a cho kisiwa makudza na makihozwa. ");
INSERT INTO nyf_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bai o at'u kuko, mafup'a zawadi nyinji sana. Zho mbai, wakathi hurihokala hunadzithayarisha kuuka, mafup'a vit'u zhosi furizhokala fundavihendza mo charoni. ");
INSERT INTO nyf_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Bai bada ya miezi mihahu, fwangira chombo cha kula Alekizandiria kiifwacho “Milungu ya P'ats'a” ambacho were kinakiza wo wakathi wa p'eho haho kisiwani. ");
INSERT INTO nyf_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","H'aya, ndiswi vivii, hatha hukifika mudzi wa Sirakusi, na hukikala kuko kwa muda wa siku t'ahu. ");
INSERT INTO nyf_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Furihouka haho Sirakusi, fwakwenda vivii muhaka Regiamu. Siku ya hiriye ko Regiamu, yo p'eho ya kwa mwaka ikikwatya kupiga jeri-jeri, kwa vizho fukiuka, ndiswi vivii, hatha inapiga siku ya hiri fukikala fudzafika bandari ya Puteoli. ");
INSERT INTO nyf_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Bai kuko Puteoli fukiona ndugu nao makifukaribisha hutoe hamwenga nao kwa muda wa wiki mwenga, ndo badaye hukifika Rumi. ");
INSERT INTO nyf_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","K'uzhona zho aryahu ndugu, marihosikira uv̱oro wehu ko Rumi, mambola makihudhana. Makudza vivii muhaka hat'u haifwaho Soko ra Apio, angine o makidzahutharizira hat'u haifwaho Hot'eli T'ahu. Bai P'aulo arihoaona o at'u, wamwambozera muv̱era Mulungu na akidzisikira adzapata moyo. ");
INSERT INTO nyf_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Vikara furihofika ko Rumi, ye P'aulo wap'ewa ruhusa aishi hat'u h'akeye na akiikirwa shikari wa kumurinda ili asichimbire. ");
INSERT INTO nyf_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Bai bada ya siku t'ahu, P'aulo waaiha hamwenga o vilongozi a Kiyahudi na marihokala madzakundzumanyika hamwenga, akiambira, “Ndugu zangu, mut'u mimi nagwirwa ko Jerusalemu na nikilazhwa kwa Arumi dza here mufungwa, idzaho were sihendere ut'u uwi kinyume na o at'u ehu hedu kinyume cha go maadha hurigogahokera kula kwa o akare ehu. ");
INSERT INTO nyf_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Bai o vilongozi a Kirumi makinuza-nuza maswali na makiona kukala sina kosa ra kunihenda nalagwe, kwa vizho makikala manamala kuniricha huru. ");
INSERT INTO nyf_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ela bai o Ayahudi makikala ma kinyume na gaga, kwa vizho nikikala sina vingine hasihokala kuvoya nihirikwe kwa Kaisari mwenye, idzaho were sina ut'u wowosi wa kudzaashithakira o at'u a kwangu enye. ");
INSERT INTO nyf_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Bai kiki ndo chausa cha mimi kumwiha hudze huonane na husumurire, mana nidzafungwa minyororo ii kwa ut'u wa iye ariye siswi Aiziraeli hudzamukuluhira.” ");
INSERT INTO nyf_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Marihosikira vizho makimudzigidzya makiamba, “At'u siswi k'ahudzapata baruwa yoyosi kula ko Judea iriyo inakuhadza uwe na pia k'ahana yoyosi kahi za o ndugu mariokudza kula kuko, ariyereha uv̱oro wowosi hedu kudzakuhadza uwe kivii. ");
INSERT INTO nyf_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ela siswi hunamala husikire gago urigo nago mo kitswani mwako, mana humanyazho ni kwamba kundi riri ambaro uwe u mumo be rinakanaizwa ni at'u kila hat'u.” ");
INSERT INTO nyf_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","K'uzhona bai, makimup'a mbadha. Bai mbadha iyo irihofika at'u anji makwenda haho arihokala anakala P'aulo, naye P'aulo waaeleza na kuagunulira lwazu dzulu za uthawali wa Mulungu kulaiza madzach'a muhaka dziloni. Akijeza kuashawishi maukubali wo uv̱oro wa Jesu, kwa kuhumira Sheria ya Musa na Maoro ga o manabii. ");
INSERT INTO nyf_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Angine kahi zao makikubali go manenoge, ela angine k'amakuluhirire bule. ");
INSERT INTO nyf_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kwa vizho makiuka kuno mananenezana o enye kwa enye. Vikara kabila k'amadzafumukana, P'aulo were adzanena nao akaamba, “Gago arigonena ye Roho Mweri kukirira kwa nabii Isaya kuambiriza o akare ehu be were ni jeri. ");
INSERT INTO nyf_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Kwani waamba, ‘Enda ukaambirize at'u aa, uambe: Mundasirikiza na kusirikiza, ela k'amundang'alirwa bule. Mundalola na kulola, ela k'amundaona bule. ");
INSERT INTO nyf_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Mana mioyo ya at'u aa idzakala mikomu, masikiro gao madzagagandiza, matso gao madzagafinya, masidze makaona na go matso gao, makasikira na go masikiro gao, makang'alirwa na yo mioyo yao, makanigalukira mimi, nami nikaahoza.’ ” ");
INSERT INTO nyf_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Bai P'aulo akimarigiza kwa kuamba, “H'aya manyani vivi bai, kukala uv̱oro dzulu za wokolwi wa Mulungu unahirikwa kwa o at'u mario si Ayahudi, nao bai mandausikira!”  ");
INSERT INTO nyf_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","K'uzhona zho, P'aulo arihogonya kunena gago, o Ayahudi mafumukana kuno mananenezana jeri-jeri. ");
INSERT INTO nyf_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bai P'aulo wakeresi haho miaka miri mizima kahi za nyumba ariyoikodisha ye mwenye na akiakaribisha osini mariokwendamutsemberera. ");
INSERT INTO nyf_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Mut'u iye wakala anahubiri dzulu za wo uthawali wa Mulungu na kuafundisha at'u dzulu za Bwana Jesu Masihi hasiho woga hedu kuzizwa ni mut'u yoyosi.");
INSERT INTO nyf_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Baruwa ii ila kwangu mimi P'aulo muhumiki wa Masihi Jesu. Mulungu wanitsagula nikale muhumwi na akinithenga k'anda ili nihubiri uwo Uv̱orowe Udzo. ");
INSERT INTO nyf_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Mulungu walaga hangu kapindi kukala andafurehera uwo Uv̱oro Udzo. Naye walaga kukirira kwa manabii a kwakwe, kahi za Maoroge maeri. ");
INSERT INTO nyf_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Uv̱oro uu Udzo ni dzulu za mwanawe Jesu. Kahi za hali ya kwakwe ya kidamu, Jesu wazhalwa kahi za lukolo lwa Daudi. ");
INSERT INTO nyf_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Na kukirira kwa Roho Mweri, Bwana wehu Jesu Masihi, wahendywa kukala Mwana wa Mulungu na mwenye nguvu, haryahu arihofufuka kula kifwani. ");
INSERT INTO nyf_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kukirira kwa iye Jesu Masihi, Mulungu wafup'a nema kwa kuhutsagula hukale ahumwi. Na vivi zhakala ili fukadime